﻿USE sofia;
DROP TABLE IF EXISTS sofia.swhulb_vpl;
CREATE TABLE swhulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swhulb_vpl WRITE;
INSERT INTO swhulb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hapo mwanzo Mungu aliumba mbingu na nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nayo nchi haikuwa na umbo na ilikuwa tupu. Giza lilikuwa juu ya uso wa vilindi vya maji. Roho wa Mungu alikuwa akielea juu ya uso wa maji. ");
INSERT INTO swhulb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mungu akasema, “na kuwe nuru,” na kulikuwa na nuru. ");
INSERT INTO swhulb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mungu akaona nuru kuwa ni njema. Akaigawa nuru na giza. ");
INSERT INTO swhulb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mungu akaiita nuru “ mchana” na giza akaliita “usiku.” Ikawa jioni na asubuhi, siku ya kwanza. ");
INSERT INTO swhulb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mungu akasema, “ na kuwe na anga kati ya maji, na ligawe maji na maji.” ");
INSERT INTO swhulb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mungu akafanya anga na kugawanya maji yaliyo kuwa chini ya anga na maji ambayo yalikuwa juu ya anga. Ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mungu akaita anga “mbingu.” Ikawa jioni na asubuhi siku ya pili. ");
INSERT INTO swhulb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mungu akasema, “maji yaliyo chini ya mbingu yakusanyike pamoja mahali pamoja, na ardhi kavu ionekane.” Ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mungu aliita ardhi kavu “nchi,” na maji yaliyo kusanyika akayaita “bahari.” Akaona kuwa ni vyema. ");
INSERT INTO swhulb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mungu akasema, nchi ichipushe mimea: miche itoayo mbegu na miti ya matunda itoayo matunda ambayo mbegu yake imo ndani ya tunda, kila kitu kwa namna yake.” Ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nchi ikatoa mimea, miche itoayo mbegu ya aina yake, na miti itoayo tunda ambalo mbegu yake imo ndani yake, kwa aina yake. Mungu akaona kuwa ni vyema. ");
INSERT INTO swhulb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ikawa jioni na asubuhi, siku ya tatu. ");
INSERT INTO swhulb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mungu akasema, “kuwe na mianga katika anga kutenganisha mchana na usiku. Na ziwe kama ishara, kwa majira, kwa siku na miaka. ");
INSERT INTO swhulb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ziwe mianga katika anga ili kutoa mwanga juu ya nchi.” Ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mungu akafanya mianga mikuu miwili, mwanga mkuu zaidi kutawala mchana, na mwanga mdogo kutawala usiku. Akafanya nyota pia. ");
INSERT INTO swhulb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mungu akazipanga katika anga kutoa mwanga juu nchi, ");
INSERT INTO swhulb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kutawala mchana na usiku, na kugawanya mwanga kutoka kwenye giza. Mungu akaona kuwa ni vyema. ");
INSERT INTO swhulb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ikawa jioni na asubuhi, siku ya nne. ");
INSERT INTO swhulb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mungu akasema, “maji yajae idadi kubwa ya viumbe hai, na ndege waruke juu ya nchi katika anga la mbingu.” ");
INSERT INTO swhulb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mungu akaumba viumbe wakubwa wa baharini, pamoja na kila kiumbe hai cha aina yake, viumbe waendao na wanaojaa kila mahali majini, na kila ndege mwenye mabawa kwa aina yake. Mungu akaona kuwa ni vyema. ");
INSERT INTO swhulb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mungu akavibariki, akisema, “zaeni na muongezeke, na mjae majini katika bahari. Ndege waongezeke juu nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ikawa jioni na asubuhi, siku ya tano. ");
INSERT INTO swhulb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mungu akasema, “ nchi na itoe viumbe hai, kila kiumbe kwa aina yake, mnyama wa kufugwa, vitu vitambaavyo, na wanyama wa nchi, kila kitu kwa jinsi yake.” Ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mungu akafanya wanyama wa nchi kwa aina yake, wanyama wa kufugwa kwa aina yake, na kila kitambaaho juu ya ardhi kwa aina yake. Akaona kuwani vyema. ");
INSERT INTO swhulb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mung akasema, “na tumfanye mtu katika mfano wetu, wa kufanana na sisi. Wawe na mamlaka juu ya samaki wa bahari, juu ya ndege wa angani, juu ya wanyama wa kufuga, juu ya nchi yote, na juu ya kila kitu kitambaacho kinacho tambaa juu ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mungu akamuumba mtu kwa mfano wake. Katika mfano wake alimuumba. Mwanaume na mwanamke aliwaumba. ");
INSERT INTO swhulb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mungu akawabariki na akawaambia, “zaeni na kuongezeka. Jazeni nchi, na muitawale. Muwe na mamlaka juu ya samaki wa baharini, juu ya ndege wa angani, na juu ya kila kiumbe hai kiendacho juu ya nchi,” ");
INSERT INTO swhulb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mungu akasema, “tazama, nimewapeni kila mmea uzaao mbegu ambao uko juu ya nchi, na kila mti wenye tunda ambalo lina mbegu ndani yake. Vitakuwa ni chakula kwenu. ");
INSERT INTO swhulb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kwa kila mnyama wa nchi, kwa kila ndege wa angani, na kila kitambaacho juu ya nchi, na kila kiumbe ambacho kina pumzi ya uhai ni metoa kila mmea kwa ajili ya chakula.” ikawa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mungu akaona kila kitu alichokiumba. Tazama, kikawa chema sana. Ikawa jioni na asubuhi siku ya sita. ");
INSERT INTO swhulb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kisha mbingu na nchi zilimalizika, na viumbe hai vyote vilivyo jaza mbingu na nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Siku ya saba Mungu alifikia mwisho wa kazi yake ambayo aliifanya, na kwa hiyo alipumzika siku ya saba kutoka kwenye kazi yake yote. ");
INSERT INTO swhulb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mungu akaibarikia siku ya saba na akaitakasa, kwa sababu katika siku hiyo alipumzika kutoka kwenye kazi yake yote ambayo aliifanya katika uumbaji. ");
INSERT INTO swhulb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Haya yalikuwa ni matukio yahusuyo mbingu na nchi, wakati vilipoumbwa, katika siku ambayo Yahwe Mungu aliumba nchi na mbingu. ");
INSERT INTO swhulb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Hapakuwa na msitu wa shambani uliokuwa katika nchi, na hapakuwa na mmea wa shambani uliokuwa umechipuka, kwa kuwa Yahwe Mungu alikuwa hajasababisha mvua kunyesha juu ya nchi, na hapakuwa na mtu wa kulima ardhi. ");
INSERT INTO swhulb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Lakini ukungu uliinuka juu kutoka kwenye nchi na kuutia maji uso wote wa ardhi. ");
INSERT INTO swhulb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahwe Mungu aliumba mtu kutoka mavumbi ya ardhi, na akampulizia puani pumzi ya uhai, na mtu akawa kiumbe hai. ");
INSERT INTO swhulb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahwe Mungu aliotesha bustani upande wa mashariki, katika Edeni, na pale akamuweka mtu ambaye alimuumba. ");
INSERT INTO swhulb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kutoka ardhini Yahwe Mungu alifanya kila mti uote ambao unapendeza na ni mzuri kwa chakula. Hii ni pamoja na mti wa uzima ambao ulikuwa katikati ya bustani, na mti wa ujuzi wa mema na mabaya. ");
INSERT INTO swhulb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mto ukatoka nje ya Edeni kuitia maji bustani. Na kutoka pale ukagawanyika na kuwa mito minne. ");
INSERT INTO swhulb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Jina la ule wa kwanza ni Pishoni. Huu ni ule ambao unatiririka kupitia nchi yote ya Havila, ambapo kuna dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dhahabu ya inchi ile ni nzuri. pia kuna bedola na jiwe shohamu. ");
INSERT INTO swhulb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Jina la mto wa pili ni Gihoni. Huu unatiririka kupitia nchi yote ya kushi. ");
INSERT INTO swhulb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Jina la mto wa tatu ni Hidekeli, ambao unatiririka mashariki mwa Ashuru. Mto wa nne ni Frati. ");
INSERT INTO swhulb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahwe Mungu alimtwaa mtu na kumweka ndani ya bustani ya Edeni kuilima na kuitunza. ");
INSERT INTO swhulb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahwe Mungu alimuagiza mtu akisema, “kutoka kwenye kila mti bustanini waweza kula kwa uhuru. ");
INSERT INTO swhulb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Lakini kutoka kwenye mti wa ujuzi wa mema na mabaya usile, kwa kuwa siku utakayo kula kutoka katika mti huo, utakufa hakika.” ");
INSERT INTO swhulb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kisha Yahwe Mungu akasema, “siyo jambo jema kwamba mtu huyu lazima awe pekeyake. Nitamfanyia msaidizi anaye mfaa.” ");
INSERT INTO swhulb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kutoka ardhini Yahwe Mungu akafanya kila mnyama wa kondeni na kila ndege wa angani. Kisha akawaleta kwa mtu huyu aone angewapatia majina gani. Jina ambalo mtu huyu alimwita kila kiumbe hai, hili ndilo lilikuwa jina lake. ");
INSERT INTO swhulb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mtu huyu akawapatia majina wanyama wote, ndege wote wa angani, na kila mnyama wa mwitu. Lakini kwa mtu mwenyewe hapakuwa na msaidizi wa kumfaa yeye. ");
INSERT INTO swhulb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yahwe Mungu akaleta usingizi mzito kwa mtu huyu, kwa hiyo mtu huyu akalala. Yahwe Mungu akatwaa moja ya mbavu za mtu huyu na akapafunika pale alipo chukua ubavu. ");
INSERT INTO swhulb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kwa ubavu ambao Yahwe Mungu alichukua toka kwa mtu huyu, akafanya mwanamke na akamleta kwa mtu huyu. ");
INSERT INTO swhulb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mwanaume akasema, “kwa sasa, huyu ni mfupa katika mifupa yangu, na nyama katika nyama yangu. ataitwa 'mwanamke,' kwa sababu ametwaliwa katika mwanaume. ");
INSERT INTO swhulb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kwa hiyo mwanaume atawaacha baba yake na mama yake, ataungamanika na mke wake, na watakuwa mwili mmoja. ");
INSERT INTO swhulb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wote wawili walikuwa uchi, mwanaume na mke wake, lakini hawakuona aibu. ");
INSERT INTO swhulb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sasa nyoka alikuwa mwerevu kuliko myama mwingine yeyote wa kondeni ambaye Yahwe Mungu alikuwa amemuumba. Akamwambia mwanamke, “Je ni kweli Mungu amesema, 'Msile matunda kutoka kwenye mti wowote bustanini'?” ");
INSERT INTO swhulb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mwanamke akamwambia nyoka, “Twaweza kula tunda kutoka kwenye miti ya bustani, ");
INSERT INTO swhulb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","lakini kuhusu tunda la mti ambao uko katikati ya bustani, Mungu alisema, 'msile, wala msiuguse, vinginevyo mtakufa.'” ");
INSERT INTO swhulb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka akamwambia mwanamke, “hakika hamtakufa. ");
INSERT INTO swhulb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kwasababu Mungu anajua kwamba siku mkila macho yenu yatafumbuliwa, na mtakuwa kama Mungu, mkijua mema na mabaya.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Na mwanamke alipoona kuwa mti ni mzuri kwa chakula, na kuwa unapendeza macho, na kwamba mti ulitamanika kwa kumfanya mtu awe mwerevu, alichukua sehemu ya tunda na akala. Na sehemu yake pia akampatia mumewe aliyekuwa naye, naye akala. ");
INSERT INTO swhulb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Macho ya wote wawili yalifumbuliwa, na wakajua kuwa wako uchi. Wakashona majani ya miti pamoja na wakatengeneza vya kujifunika wao wenyewe. ");
INSERT INTO swhulb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Wakasikia sauti ya Yahwe Mungu akitembea bustanini majira ya kupoa kwa jua, kwa hiyo mwanaume na mke wake wakajificha wao wenyewe kwenye miti ya bustani kuepuka uwepo wa Yahwe Mungu. ");
INSERT INTO swhulb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahwe Mungu akamuita mwanaume na kumwambia, “ uko wapi?” ");
INSERT INTO swhulb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mwanaume akasema, “nilikusikia bustanini, na nkaogopa, kwa sababu nilikuwa uchi. kwa hiyo nikajificha.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mungu akasema, “Ni nani alikwambia kuwa ulikuwa uchi? Je umekula kutoka mti ambao nilikuagiza usile matunda yake?” ");
INSERT INTO swhulb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mwanaume akasema, “ Mwanamke uliyenipa kuwa na mimi, alinipatia tunda kutoka kwenye mti, na nikala.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahwe Mungu akamwambia mwanamke, “ Nini hiki ulichofanya?” mwanamke akasema, “nyoka alinidanganya, na nikala.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahwe Mungu akamwambia nyoka, “ kwa sababu umefanya jambo hili, umelaaniwa wewe mwenyewe miongoni mwa wanyama wote wa kufugwa na wanyama wote wa mwituni. Itakuwa kwa tumbo lako utakwenda, na mavumbi utakula kwa siku zote za maisha yako. ");
INSERT INTO swhulb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nitaweka uadui kati yako na mwanamke, na kati ya uzao wako na uzao wake. Atakujeruhi kichwa chako na utamjeruhi kisigino chake.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kwa mwanamke akasema, nitaongeza uchungu wakati wa kuzaa watoto; itakuwa katika maumivu utazaa watoto. Tamaa yako itakua kwa mume wako, lakini atakutawala.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kwa Adam akasema, “kwa sababu umesikiliza sauti ya mke wako, na umekula kutoka katika mti, ambao nilikuagiza, nikisema, “ usile matunda yake', ardhi imelaaniwa kwa sababu yako; kupitia kazi yenye maumivu utakula matunda ya ardhi kwa siku zote za maisha yako. ");
INSERT INTO swhulb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ardhi itazaa miiba na mbigili kwa ajili yako, na utakula mimea ya shambani. ");
INSERT INTO swhulb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kwa jasho la uso wako utakula mkate, mpaka utakapo irudia ardhi, ambayo kwayo ulitwaliwa. kwa kuwa wewe ni mavumbi na kwenye mavumbi utarudi.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mwanaume akaita mke wake jina Hawa kwa sababu alikuwa mama wa wote wenye uhai. ");
INSERT INTO swhulb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahwe Mungu akatengeneza mavazi ya ngozi kwa ajili ya Adam na mke wake na akawavalisha. ");
INSERT INTO swhulb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahwe Mungu akasema, “ sasa mtu huyu amekuwa kama mmoja wetu, ajuaye mema na mabaya. Kwa hiyo sasa hataruhusiwa kugusa kwa mkono wake, na kuchukua tunda la mti wa uzima, na kula akaishi tena milele.” ");
INSERT INTO swhulb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kwa hiyo Yahwe Mungu akamuondoa kutoka kwenye bustani ya Edeni, kwenda kulima ardhi ambayo kwahiyo alikuwa ametwaliwa. ");
INSERT INTO swhulb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kwa hiyo Mungu akamfukuza mtu huyu nje ya bustani, na akaweka kerubi mashariki mwa bustani ya Edeni, na upanga wa moto ulio geuka geuka kila upande, ili kulinda njia ya kwenda kwenye mti wa uzima. ");
INSERT INTO swhulb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Mwanume akalala na Hawa mke wake. Akabeba mimba na akamzaa Kaini. Akasema, “ nimezaa mwanaume kwa msaada wa Yahwe.” ");
INSERT INTO swhulb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kisha akazaa ndugu yake Habili. Sasa Habili akawa mchungaji, lakini Kaini alilima udongo. ");
INSERT INTO swhulb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ikawa kwamba baada ya muda Kaini alileta sehemu ya mazao ya ardhi kama sadaka kwa Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habili pia, alileta sehemu ya wazao wa kwanza wa wanyama wake na sehemu zilizonona. Yahwe akamkubali Habili pamoja na sadaka yake, ");
INSERT INTO swhulb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","lakini Kaini pamoja na sadaka yake Mungu hakuikubali. Kwa hiyo Kaini alikasirika sana, na uso wake ukakunjamana. ");
INSERT INTO swhulb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahwe akamwambia Kaini, “ kwa nini umekasirika na kwa nini uso wako umekunjamana? ");
INSERT INTO swhulb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kama ukifanya vema, je hutapata kibali? lakini kama hutafanya lilio jema, dhambi iko inakuotea mlangoni na inatamani kukutawala, lakini inakupasa uishinde. ");
INSERT INTO swhulb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaini akamwambia Habili ndugu yake. Hata wakati walipokuwa shambani, Kaini aliinuka dhidi ya Habili ndugu yake na akamuua. (Katika tafsiri za kale zinasema, Kaini alimwambia Habili ndugu yake, “ twende mashambani.” Na wakati walipokuwa shambani, Kaini alimuinukia Habili ndugu yake na kumuua). ");
INSERT INTO swhulb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kisha Yahwe akamuuliza Kaini, “Ndugu yako Habili yuko wapi?” Akasema, “sijui. Je mimi ni mlinzi wa ndugu yangu?” ");
INSERT INTO swhulb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahwe akasema, “umefanya nini? damu ya ndugu yako inaniita mimi kutokea ardhini. ");
INSERT INTO swhulb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na sasa umelaaniwa wewe kutoka ardhi ambayo imefungua kinywa chake kupokea damu ya ndugu yako kutoka mikononi mwako. ");
INSERT INTO swhulb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Utakapo ilima ardhi, kuanzia sasa na kuendelea haita kuzalia wewe nguvu yake. Utakuwa mkimbizi na mtu asiye na makao duniani.” ");
INSERT INTO swhulb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini akamwambia Yahwe, “Adhabu yangu ni kubwa kuliko uwezo wangu wa kustahimili. ");
INSERT INTO swhulb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kwa hakika umenifukuza siku hii ya leo kutoka kwenye ardhi hii, na sitaonekana mbele ya uso wako. Nitakuwa mkimbizi na mtu nisiye na makao katika dunia, na yeyote atakaye niona ataniua.” ");
INSERT INTO swhulb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahwe akamwambia, “ikiwa mtuyeyote atamuua Kaini, kisasi kitakuwa juu yake mara saba.” Kisha Yahwe akaweka alama juu ya Kaini, ili kwamba kama mtu awayeyote akimuona, mtu huyo asimshambulie. ");
INSERT INTO swhulb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kwa hiyo Kaini akatoka mbele ya uwepo wa Yahwe na akaishi katika nchi ya Nodi, mashariki mwa Edeni. ");
INSERT INTO swhulb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini akamjua mke wake na akapata mimba. Akamzaa Henoko. Akajenga mji na akauita kwa jina la mwanae Henoko. ");
INSERT INTO swhulb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kwa Henoko akazaliwa Iradi. Iradi akamzaa Mehuyaeli. Mehuyaeli akamzaa Methushaeli. Methushaeli akamzaa Lameki. ");
INSERT INTO swhulb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki akajitwalia wake wawili: jinala mmoja alikuwa Ada, na jina la yule mwingine alikuwa Sila. ");
INSERT INTO swhulb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada akamzaa Yabali. Huyu ndiye alikuwa baba yao na wale walioishi hemani ambao wanafuga wanyama. ");
INSERT INTO swhulb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ndugu yake aliitwa Yubali. Huyu alikuwa baba yao na wale wapigao kinubi na filimbi. ");
INSERT INTO swhulb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila naye akamzaa Tubal Kaini, mfua vyombo vya shaba na chuma. Dada yake na Tubal Kaini alikuwa Naama. ");
INSERT INTO swhulb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki akawaambia wake zake, Ada na Sila, sikieni sauti yangu; ninyi wake wa Lameki, sikilizeni nisemacho. Kwa kuwa nimemuua mtu kwa kunijeruhi, kijana kwa kunichubua. ");
INSERT INTO swhulb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ikiwa Kaini atalipiwa kisasi mara saba, ndipo Lameki atalipiwa kisasi mara sabini na saba.” ");
INSERT INTO swhulb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam akamjua mke wake tena, na akazaa mtoto mwanaume. Akamuita jina lake Sethi na akasema, “ Mungu amenipatia mtoto mwingine wa kiume kwa nafasi ya Habili, kwa kuwa Kaini alimuuwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Mtoto wa kiume alizaliwa kwa Sethi na akamuita jina lake Enoshi. Wakati huo watu walianza kuliitia jina la Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hii ni orodha ya vizazi vya Adamu. Katika siku ambayo Mungu alimuumba mtu, aliwaumba katika mfano wake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mwanaume na mwanamke aliwaumba. Akawabariki na akawaita Adam wakati walipoumbwa. ");
INSERT INTO swhulb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Wakati Adamu alipokuwa ameishi miaka 130, akamzaa mwana katika sura yake mwenyewe, kwa mfano wake, na akamuita jina lake Sethi. ");
INSERT INTO swhulb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Baada ya Adamu kumzaa Sethi, aliishi miaka mia nane. Akawazaa wana wengi waume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu akaishi miaka 930 kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Wakati Sethi alipokuwa ameishi miaka 105, akamzaa Enoshi. ");
INSERT INTO swhulb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Baada ya kumzaa Enoshi, akaishi miaka 807 na akawazaa wana wengi waume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sethi akaishi miaka 912 kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Wakati Enoshi alipokuwa ameishi miaka tisini, akamzaa Kenani. ");
INSERT INTO swhulb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Baada ya kumzaa Kenani, Enoshi aliishi miaka 815. Akazaa wana wengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi aliishi miaka 905 na kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Wakati Kanani alipokuwa ameishi miaka sabini, akamzaa Mahalaleli. ");
INSERT INTO swhulb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Baada ya kumzaa Mahalaleli, Kenani aliishi miaka 840. Akawazaa wana wengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani aliishi miaka 910, na kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli alipokuwa ameishi miaka sitini na tano, alimzaa Yaredi. ");
INSERT INTO swhulb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Baada ya kumzaa Yaredi, Mahalaleli aliishi miaka 830. Akazaa wana wengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli aliishi miaka 895 na kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaredi alipokuwa ameishi miaka 162, alimzaa Henoko. ");
INSERT INTO swhulb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Baada ya kumzaa Henoko, Yaredi aliishi miaka mianane. Akazaa wana wengi waume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaredi aliishi miaka 962 na kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoko alipokuwa ameishi miaka sitini na tano, akamzaa Methusela. ");
INSERT INTO swhulb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henoko akaenenda na Mungu miaka miatatu baada ya kumzaa Methusela. Aliwazaa wana wengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henoko aliishi miaka 365. ");
INSERT INTO swhulb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoko alienenda na Mungu, na kisha alitoweka, kwa kuwa Mungu alimtwaa. ");
INSERT INTO swhulb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Wakati Methusela alipokuwa ameishi miaka 187, alimzaa Lameki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Baada ya kumzaa Lameki, Methusela aliishi miaka 782. Akawazaa wana wengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methusela aliishi miaka 969. Kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Wakati Lameki alipokuwa ameishi miaka 182, alimzaa mwana. ");
INSERT INTO swhulb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Akamuita jina lake Nuhu, akisema, “Huyu ndiye atatupatia pumziko kutoka katika kazi yetu na kutoka katika kazi ya taabu ya mikono yetu, ambayo lazima tuifanye kwa sababu ya ardhi ambayo Yahwe ameilaani.” ");
INSERT INTO swhulb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki aliishi miaka 595 baada ya kumzaa baba wa Nuhu. Akazaa wanawengi wa ume na wake. ");
INSERT INTO swhulb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki aliishi miaka 777. Kisha akafariki. ");
INSERT INTO swhulb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Baada ya Nuhu kuishi miaka miatano, akamzaa Shemu, Hamu, na Yafethi. ");
INSERT INTO swhulb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ikawa wakati watu walipoanza kuongezeka juu ya uso wa nchi na wana wa kike wakazaliwa kwao, ");
INSERT INTO swhulb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","wana wa Mungu walipoona kuwa mabinti wa wanadamu ni wenye kuvutia. waliwachukua kuwa wake zao, kila waliye mchagua. ");
INSERT INTO swhulb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahwe akaema, “ roho yangu haitasalia kwa mwanadamu milele, kwa kuwa wao ni nyama. Wataishi miaka 120.” ");
INSERT INTO swhulb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Majitu makubwa yalikuwa juu ya uso wa nchi nyakati hizo, na hata baada ya hapo. Hii ilitokea wakati wana wa Mungu walipowaoa binti za wanadamu, na kupata watoto pamoja nao. Hawa walikuwa watu hodari zamani, watu wenye sifa. ");
INSERT INTO swhulb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahwe akaona kwamba uovu wa watu umezidi katika nchi, na kwamba mawazo ya mioyo yao daima inaelekea tu katika uovu. ");
INSERT INTO swhulb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahwe akajuta kuwa amemuumba mwanadamu juu ya nchi, na ikamuhuzunisha moyo wake. ");
INSERT INTO swhulb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kwa hiyo Yahwe akasema, “Nitamfutilia mbali mwanadamu ambaye nimemuumba katika uso wa nchi; mwanadamu na wanyama wakubwa, na vitambaavyo na ndege wa angani, kwa kuwa nimehuzunika kuwa nimeviumba.” ");
INSERT INTO swhulb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Lakini Nuhu akapata neema ya upendeleo machoni pa Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kulikuwa na matukio kumuhusu Nuhu. Nuhu alikuwa mtu mwenye haki, na asiye na lawama miongoni mwa watu wa kipindi chake. Nuhu alitembea na Mungu. ");
INSERT INTO swhulb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu akafanyika baba wa wana watatu wa kiume: Shem, Ham na Yafeti. ");
INSERT INTO swhulb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nchi iliharibika mbele za Mungu, na ikajaa ghasia. ");
INSERT INTO swhulb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mungu akaiona nchi; tazama, ilikuwa imeharibika, kwa kuwa wote wenye mwili walikuwa wameharibu njia zao juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mungu akamwambia Nuhu, “Nimeona kuwa sasa niwakati wa mwisho kwa wote wenye mwili, kwa kuwa inchi imejaa ghasia kutokana na wao. Hakika, nitawaharibu wao pamoja na nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tengeneza safina ya mti wa mvinje kwa ajili yako. Tengeneza vyumba katika safina, na vifunike kwa lami ndani na nje. ");
INSERT INTO swhulb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hivi ndivyo utakavyofanya: urefu wa safina dhiraa miatatu, upana wake dhiraa hamsini, kwenda juu kwake dhiraa thelathini. ");
INSERT INTO swhulb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tengeneza paa la safina, na ulimalize kwa kipimo cha dhiraa kutoka juu ubavuni. Weka mlango katika ubavu wa safina na utengeneze dari ya chini, ya pili na ya tatu. ");
INSERT INTO swhulb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Sikiliza, nimekaribia kuleta gharika ya maji juu ya nchi, kuharibu wenye mwili wote wakaao ndani ya nchi wenye pumzi ya uhai chini ya mbingu. Kila kitu kilichopo juu ya nchi kitakufa. ");
INSERT INTO swhulb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lakini nitalifanya thabiti agano langu na wewe. Utaingia ndani ya safina, wewe, na wana wako wa kiume, na mke wako, pamoja na wake za wanao. ");
INSERT INTO swhulb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kwa kila kiumbe hai chenye mwili, viwili vya kila aina utavileta ndani ya safina, ili visalie hai pamoja nawe, vya kike na vya kiume. ");
INSERT INTO swhulb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Katika ndege kwa jinsi yake, na wanyama wakubwa kwa jinsi yake, kila kitambaacho ardhini kwa jinsi yake, viwili viwili vya kila aina vitakuja kwako ili viwe salama. ");
INSERT INTO swhulb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kusanya kila aina ya chakula kinacholiwa kwa ajili yako na ukitunze, ili kwamba viwe chakula chako na chao.” ");
INSERT INTO swhulb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kwa hiyo Nuhu akafanya hivi. kulingana na yote ambayo Mungu alimuagiza, ndivyo alifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahwe akamwambia Nuhu, “Njoo, wewe na nyumba yako wote, katika safina, kwa kuwa nimeona kuwa wewe ni mwenye haki mbele yangu katika kizazi hiki. ");
INSERT INTO swhulb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kwa kila mnyama aliye safi utakuja nao saba wa kiume na saba wa kike. Na kwa wanyama wasio safi, lete wawili wawili, wakiume na wakike. ");
INSERT INTO swhulb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pia na kwa ndege wa angani, lete saba wa kiume na saba wa kike, ili kuhifadhi kizazi chao juu ya uso wa nchi yote. ");
INSERT INTO swhulb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kwa kuwa ndani ya siku saba nitasababisha mvua kunyesha juu ya nchi muda wa siku arobaini mchana na usiku. Nitaharibu kila kiumbe hai nilichokiumba juu ya uso wa ardhi.” ");
INSERT INTO swhulb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu alifanya yote ambayo Yahwe alimuagiza. ");
INSERT INTO swhulb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu alikuwa na umri wa miaka mia sita wakati gharika ilipokuja juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu, watoto wake wa kiume, mke wake, na wake za watoto wake waliingia katika safina pamoja kwa sababu ya maji ya gharika. ");
INSERT INTO swhulb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Wanyama ambao ni safi na wanyama ambao si safi, ndege, na kila kitambaacho juu ya ardhi, ");
INSERT INTO swhulb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wawili wawili mume na mke wakaja kwa Nuhu na wakaingia katika safina, kama vile Mungu alivyokuwa amemwagiza Nuhu. ");
INSERT INTO swhulb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ikawa kwamba baada ya siku saba, maji ya gharika yakaja juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Katika mwaka wa mia sita wa maisha yake Nuhu, katika mwezi wa pili, katika siku ya kumi na saba ya mwezi, katika siku iyo hiyo, chemchemi zote za vilindi vikuu zilipasuka na kufunguka, na madirisha ya mbinguni yakafunguka. ");
INSERT INTO swhulb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mvua ikaanza kunyesha juu ya nchi kwa siku arobaini mchana na usiku. ");
INSERT INTO swhulb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Katika siku iyo hiyo Nuhu pamoja na watoto wake, Shem, Ham, na Yafethi na mke wa Nuhu, na wale wake watatu wa wana wa Nuhu pamoja waliingia katika safina. ");
INSERT INTO swhulb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Waliingia pamoja na kila mnyama wa mwitu kwa jinsi yake, na kila mnyama wa kufugwa kwa jinsi yake, na kila kitambaacho juu ya ardhi kwa jinsi yake, na kila aina ya ndege kwa jinsi yake, kila aina ya kiumbe chenye mabawa. ");
INSERT INTO swhulb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Viwili viwili katika kila chenye mwili ambacho kilikuwa na pumzi ya uhai kilikuja kwa Nuhu na kuingia katika safina. ");
INSERT INTO swhulb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Wanyama walioingia ndani walikuwa wakiume na kike katika wote wenye mwili; wakaingia kama vile Mungu alivyokuwa amemwagiza. Kisha Yahwe akawafungia mlango. ");
INSERT INTO swhulb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kisha gharika ikaja juu ya nchi kwa siku arobaini, na maji yakaongezeka na kuinua safina juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maji yakafunika kabisa nchi, na safina ikaelea juu ya uso wa maji. ");
INSERT INTO swhulb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maji yakaongezeka zaidi juu ya nchi kiasi kwamba milima yote mirefu ambayo ilikuwa chini ya anga ikafunikwa. ");
INSERT INTO swhulb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maji yakaongezeka dhiraa kumi na tano juu ya vilele vya milima. ");
INSERT INTO swhulb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Vitu vyote vyenye uhai ambavyo vilitembea juu ya nchi vilikufa: ndege, mifugo, wanyama wa mwituni, viumbe hai vyote kwa wingi vilivyoishi juu ya nchi, pamoja na watu. ");
INSERT INTO swhulb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Viumbe hai vyote ambavyo vilikaa juu ya ardhi, vilivyo pumua pumzi ya uhai kwa njia ya pua, vilikufa. ");
INSERT INTO swhulb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Hivyo kila kilichokuwa hai ambacho kilikuwa juu ya uso wa mchi kilifutwa, kuanzia watu mpaka wanyama wakubwa, mpaka vitambaavyo, na mpaka ndege wa angani. Vyote viliangamizwa kutoka kwenye nchi. Nuhu tu pamoja na wale waliokuwa naye kwenye safina ndio walisalia. ");
INSERT INTO swhulb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maji haya kuzama chini ya nchi kwa muda wa siku miamoja na hamsini. ");
INSERT INTO swhulb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mungu akamtazama Nuhu, wanyama wote wa mwitu, na wanyama wote wa kufugwa ambao walikuwa pamoja naye kwenye safina. Mungu akafanya upepo uvume juu ya nchi, na maji yakaanza kuzama chini. ");
INSERT INTO swhulb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Chemichemi za vilindi pamoja na madirisha ya mbingu vikafungwa, na mvua ikakoma kunyesha. ");
INSERT INTO swhulb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Maji ya gharika yakaanza kuzama kidogo kidogo katika nchi. na mwisho wa siku miamoja na hamsini maji yakawa yamezama chini. ");
INSERT INTO swhulb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","safina ikatulia katika mwezi wa saba, siku ya kumi na saba ya mwezi, juu ya milima ya Ararati. ");
INSERT INTO swhulb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maji yakaendelea kuzama chini hadi mwezi wa kumi. Siku ya kwanza ya mwezi, vilele vya milima vikaonekana. ");
INSERT INTO swhulb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ikatokea kwamba baada ya siku arobaini Nuhu alifungua dirisha la safina ambayo aliitengeneza. ");
INSERT INTO swhulb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Akatuma kunguru na akaruka hadi maji yalipo kauka katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kisha akatuma njiwa kuona kama maji yamezama chini kutoka kwenye uso wa nchi, ");
INSERT INTO swhulb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","lakini njiwa hakuona sehemu ya kutua unyayo wake, na akarudi kwake ndani ya safina, kwa kuwa maji yalikuwa bado yamefunika nchi yote. Akanyoosha mkono wake, akamchukua na kumuweka ndani ya safina pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Akasubiri siku saba zingine akatuma tena njiwa kutoka kwenye safina. ");
INSERT INTO swhulb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Njiwa akarudi kwake jioni. Tazama! katika mdomo wake kulikuwa na jani bichi la mzeituni lililochumwa. Kwa hiyo Nuhu akatambua kuwa maji yamekwisha zama chini ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Akasubiri siku saba zingine na akamtuma njiwa tena. Njiwa hakurudi kwake tena. ");
INSERT INTO swhulb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ikawa kwamba katika mwaka wa mia sita na moja, katika mwezi wa kwanza, siku ya kwanza ya mwezi, maji yalikuwa yamekauka katika nchi. Nuhu akaondoa kifuniko cha safina, akatazama nje, na akaona kwamba, Tazama, uso wa nchi ulikuwa umekauka. ");
INSERT INTO swhulb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Katika mwezi wa pili, siku ya ishirini na saba ya mwezi, nchi ilikuwa imekauka. ");
INSERT INTO swhulb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mungu akamwambia Nuhu, ");
INSERT INTO swhulb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Toka nje ya safina, wewe, mke wako, wanao wa kiume, na wake wa wanao pamoja nawe. ");
INSERT INTO swhulb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Wachukuwe utoke nje pamoja nao kila kiumbe hai chenye mwili ambacho kiko nawe - ndege, wanyama wa kufugwa, na kila kitambaacho ambacho hutambaa juu ya nchi - ili kwamba viweze kukua na kuwa na idadi kubwa zaidi ya viumbe hai katika nchi yote, kwa kuzaliana na kuongezeka juu ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kwa hiyo Nuhu akatoka nje pamoja na watoto wake wa kiume, mke wake, na wake wa wa wanawe pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kila kiumbe hai, kila kitambaacho, na kila ndege, na kila kiendacho juu ya nchi, kwa kabila zao, wakaiacha safina. ");
INSERT INTO swhulb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu akajenga madhabahu kwa Yahwe. Akachukua baadhi ya wanyama walio safi na baadhi ya ndege walio safi, na kutoa sadaka ya kuteketezwa juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahwe akanusa harufu nzuri ya kuridhisha na akasema moyoni mwake, “ Sita laani tena ardhi kwa sababu ya mwanadamu, ingawa nia za mioyo yao ni mbaya tokea utoto. Wala sita haribu kilakitu chenye uhai, kama nilivyo fanya. ");
INSERT INTO swhulb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Wakati nchi isaliapo, majira ya kupanda mbegu na mavuno, baridi na joto, kiangazi na majira ya baridi, mchana na usiku havitakoma.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kisha Mungu akambariki Nuhu na wanawe, na kuwaambia, “Zaeni, mkaongezeke, na muijaze nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Hofu na utisho wenu vitakuwa juu ya kila mnyama aliye hai juu ya nchi, juu ya kila ndege wa angani, juu ya kila kitu kiendacho chini juu ya ardhi, na juu ya samaki wote wa baharini. Vimetolewa katika mikono yenu. ");
INSERT INTO swhulb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kila kitu kiendacho kilicho hai kitakuwa chakula kwa ajili yenu. Kama nilivyo wapa mimea, sasa nawapa kila kitu. ");
INSERT INTO swhulb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lakini msile nyama pamoja na uhai wake - yaani damu yake - ndani yake. ");
INSERT INTO swhulb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Lakini kwa ajili ya damu yenu, uhai uliomo katika damu yenu nitataka malipo. Kutoka katika mkono wa kila mnyama nitaitaka. Kutoka katika mkono wa kila mtu, yaani, kutoka katika mkono wa yule ambaye amemuua ndugu yake, nitataka fidia kwa ajili ya uhai wa mtu huyo. ");
INSERT INTO swhulb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Yeyote amwagaye damu ya mtu, kwa njia ya mtu damu yake itamwagwa, kwa sababu ilikuwa ni katika mfano wa Mungu kwamba Mungu alimuumba mtu. ");
INSERT INTO swhulb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na hivyo nanyi zaeni na kuongezeka, sambaeni katika inchi yote na muongezeke juu yake.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kisha Mungu akazungumza na Nuhu na wanae pamoja naye, akisema, ");
INSERT INTO swhulb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kwa ajili yangu, sikiliza! Ninakwenda kulithibitisha agano langu pamoja nawe na uzao wenu baada yenu, ");
INSERT INTO swhulb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na kwa kila kiumbe hai kilicho pamoja nawe, pamoja na ndege, mnyama wa kufugwa, na kila kiumbe cha nchi pamoja nawe, kuanzia kwa wote waliotoka kwenye safina, mpaka kwa kila kiumbe hai juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kwa sababu hii ninalithibitisha agano langu pamoja nanyi, kwamba hapatatokea kuangamizwa kwa mwenye mwili kwa njia ya maji ya gharika. Tena hapatatokea gharika ya kuangamiza nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mungu akasema, “ na hii ndiyo ishara ya agano ambalo ninafanya kati yangu na ninyi pamoja na kila kiumbe hai kilicho pamoja nanyi, kwa vizazi vyote vya baadaye: ");
INSERT INTO swhulb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nimeweka upinde wangu wa mvua katika wingu, na itakuwa ndiyo ishara ya agano kati yangu na nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Hata itakuwa nitakapoleta wingu juu ya nchi na upinde wa mvua ukaonekana katika wingu, ");
INSERT INTO swhulb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ndipo nitakumbuka agano langu, ambalo ni kati yangu na ninyi na kila kiumbe hai cha wote mwenye mwili. Maji hayatafanyika tena gharika kuharibu wote wenye mwili. ");
INSERT INTO swhulb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Upinde wa mvua utakuwa katika mawingu na nitauona, ili kukumbuka agano la milele kati ya Mungu na kila kiumbe hai cha wote wenye mwili ambacho kiko juu ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kisha Mungu akamwambia Nuhu, “ Hii ni ishara ya agano ambalo nimelithibitisha kati yangu na wenye mwili wote ambao wako juu ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wana wa Nuhu ambao walitoka katika safina walikuwa ni Shemu, Hamu, na Yafethi. Na Hamu akamzaa kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Watatu hawa walikuwa ndio wana wa Nuhu, na kutokea kwa hawa nchi yote ikajaa watu. ");
INSERT INTO swhulb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu akaanza kuwa mkulima, na akapanda mizabibu. ");
INSERT INTO swhulb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Akanywa sehemu ya divai na akalewa. Akawa amelala hemeani uchi. ");
INSERT INTO swhulb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kisha Hamu, baba yake na Kanaani, akaona uchi wa baba yake na akawaambia ndugu zake wawili waliokuwa nje. ");
INSERT INTO swhulb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kwa hiyo Shemu na Yafethi wakachukua kanzu wakaitanda juu ya mabega yao, na wakatembea kinyumenyume na wakaufunika uchi wa baba yao. Nyuso zao zikiwa zimegeuka nyuma upande mwingine, kwa hiyo hawakuona uchi wa baba yao. ");
INSERT INTO swhulb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu alipozinduka kutoka katika ulevi wake, alijua ni jambo gani mtoto wake mdogo amemfanyia. ");
INSERT INTO swhulb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Hivyo akasema, “Alaaniwe Kanaani. Na awe mtumishi kwa watumishi wa ndugu zake.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Akasema pia, Yahwe, Mungu wa Shemu, abarikiwe, Kanaani na awe mtumwa wake. ");
INSERT INTO swhulb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mungu na apanuwe mipaka ya Yafethi, na afanye makazi yake katika hema za Shemu. Kanaani na awe mtumwa wake.” ");
INSERT INTO swhulb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Baada ya gharika, Nuhu aliishi miaka miatatu na hamsini. ");
INSERT INTO swhulb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Siku zote za Nuhu zilikuwa ni miaka mia tisa na hamsini, na kisha alikufa. ");
INSERT INTO swhulb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hivi ndivyo vilikuwa vizazi vya wana wa Nuhu, ambao ni, Shemu, Hamu, na Yafethi. Wana wa kiume walizaliwa kwao baada ya gharika. ");
INSERT INTO swhulb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Yafethi walikuwa Gomeri, Magogu, Madai, Yavani, Tubali, Masheki, na Tirasi. ");
INSERT INTO swhulb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na wana wa Gomeri walikuwa Ashikenazi, Rifathi na Togama. ");
INSERT INTO swhulb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani walikuwa Elisha, Tarshishi, Kitimu, na Dodanimu. ");
INSERT INTO swhulb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kutoka kwa hawa watu wa pwani waligawanyika na kwenda kwenye ardhi zao, kila mtu na lugha yake, kufuatana na koo zao, kwa mataifa yao. ");
INSERT INTO swhulb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu walikuwa Kushi, Misraimu, Putu, na Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kushi walikuwa Seba, Havila, Sabta, Raama, na Sabteka. Wana wa Raama walikuwa Sheba na Dedani. ");
INSERT INTO swhulb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi akamzaa Nimrodi, ambaye alikuwa hodari wa kwanza juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Alikuwa mwindaji mkuu mbele ya Yahwe. Hii ndiyo sababu hunenwa, “Kama Nimrod mwindaji mkuu mbele za Yahwe.” ");
INSERT INTO swhulb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Miji ya kwanza ya ufalme wake ilikuwa Babeli, Ereku, Akadi na Kalne, katika ichi ya Shinari. ");
INSERT INTO swhulb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kutoka katika nchi ile alikwenda Ashuru na akajenga Ninawi, Rehoboth- iri na Kala, ");
INSERT INTO swhulb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Raseni ambao ulikuwa kati ya Ninawi na Kala. Ulikuwa mji mkubwa. ");
INSERT INTO swhulb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraimu akazaa Waludi, Waanami, Walehabi, na Wanaftuhi, ");
INSERT INTO swhulb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Wapathrusi na Wakasluhi ( ambao kwao Wafilisti walitokea), na Wakaftori. ");
INSERT INTO swhulb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani akamzaa Sidono, mwanawe wa kwanza, na Hethi, ");
INSERT INTO swhulb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","pia na Myebusi, na Mwamori, Mgirgashi, ");
INSERT INTO swhulb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Mhivi, Mwarki, Msini, ");
INSERT INTO swhulb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Mwarvadi, Msemari, na Mhamathi. Baadaye koo za wakanaani zikasambaa. ");
INSERT INTO swhulb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mpaka wa Wakanaani ulianzia Sidoni, katika mwelekeo wa Gerari, hata Gaza, na kama kuelekea Sodoma, Gomora, Adma, na Seboimu hata Lasha. ");
INSERT INTO swhulb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hawa walikuwa wana wa Ham, kwa koo zao, kwa lugha zao, katika ardhi zao na katika mataifa yao. ");
INSERT INTO swhulb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Pia walizaliwa wana kwa Shemu, ndugu yake mkubwa wa Yafethi. Shemu pia alikuwa baba yao na watu wote wa Eberi. ");
INSERT INTO swhulb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu walikuwa Elamu, Ashuru, Alfaksadi, Ludi, na Aramu. ");
INSERT INTO swhulb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Aramu walikuwa ni Usi, Huli, Getheri, na Mashi. ");
INSERT INTO swhulb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadi akamzaa Sela, na Sela akamzaa Eber. ");
INSERT INTO swhulb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi akazaa wana wawili wa kiume. Jina la mmoja aliitwa Pelegi maana katika siku zake nchi iligawanyika. Jina la ndugu yake aliitwa Yoktani. ");
INSERT INTO swhulb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktani akamzaa Almodadi, Shelefu, Hasarmawethi, Yera, ");
INSERT INTO swhulb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzali, Dikla, ");
INSERT INTO swhulb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Sheba, ");
INSERT INTO swhulb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila, na Yobabi. Hawa wote walikuwa wana wa Yoktani. ");
INSERT INTO swhulb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mpaka wao ulikuwa unaanzia Mesha, hadi Sefari, mlima wa mashariki. ");
INSERT INTO swhulb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hawa walikuwa wana wa Shemu, kulingana na koo zao na lugha zao, katika ardhi zao kulingana na mataifa yao. ");
INSERT INTO swhulb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hizi zilikuwa koo za wana wa Nuhu, kulingana na vizazi vyao, kwa mataifa yao. Kutokea kwa hawa mataifa yaligawanyika na kwenda juu ya nchi baada ya gharika. ");
INSERT INTO swhulb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sasa nchi yote ilikuwa inatumia lugha moja na ilikua na usemi mmoja. ");
INSERT INTO swhulb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikawa waliposafiri upande wa mashariki, wakaona eneo tambarare katika nchi ya Shinari na wakakaa pale. ");
INSERT INTO swhulb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wakasemezana, “Haya njoni, tufanye matofari na tuyachome kikamilifu.” Walikuwa na matofari badala ya mawe na lami kama chokaa. ");
INSERT INTO swhulb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wakasema, “njoni, na tujenge mji sisi wenyewe na mnara ambao kilele chake kitafika angani, na tujifanyie jina. Kama hatutafanya, basi tutatawanyika katika uso wa nchi yote.” ");
INSERT INTO swhulb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kwa hiyo Yahwe akashuka kuona mji na mnara ambao wazao wa Ibrahimu walikuwa wamejenga. ");
INSERT INTO swhulb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahwe akasema, “Tazama, watu hawa ni taifa moja na lugha moja, na wameanza kufanya hivi! Hivikaribuni halitashindikana jambo watakalo kusudia kulifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Njoni, tushuke na tuvuruge lugha yao pale, ili kwamba wasielewane.” ");
INSERT INTO swhulb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kwa hiyo Yahwe akawatawanya kutoka pale kwenda pande zote za uso wa nchi na wakaacha kujenga mji. ");
INSERT INTO swhulb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kwa hiyo, jina lake ukaitwa Babeli, kwa sababu hapo Yahwe alivuruga lugha ya nchi yote na tangu pale Yahwe akawatawanya ng'ambo juu ya uso wa nchi yote. ");
INSERT INTO swhulb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hivi ndivyo vilikuwa vizazi vya Shemu. Shemu alikuwa na umri wa miaka mia moja, na akamzaa Alfaksadi miaka miwili baada ya gharika. ");
INSERT INTO swhulb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shemu akaishi miaka miatano baada ya kumzaa Alfaksadi. Pia akazaa wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Wakati Alfaksadi alipokuwa ameishi miaka thelathini na mitano akamzaa Shela. ");
INSERT INTO swhulb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Alfaksadi aliishi miaka 403 baada ya kumzaa Shela. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Wakati Shela alipokuwa ameishi miaka thelathini, akamzaa Eberi. ");
INSERT INTO swhulb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shela aliishi miaka 403 baada ya kumzaa Eberi. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Wakati Eberi alipokuwa ameishi miaka thelathini na minne, akamzaa Pelegi. ");
INSERT INTO swhulb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eberi aliishi miaka 430 baada ya kumzaa Pelegi. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Wakati Pelegi alipokuwa ameishi miaka thelathini, akamzaa Reu. ");
INSERT INTO swhulb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi aliishi miaka 209 baada ya kumza a Reu. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Wakati Reu alipokuwa ameishi miaka thelathini na miwili, alimzaa Serugi. ");
INSERT INTO swhulb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu aliishi miaka207 baada ya kumzaa Seregu. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Wakati Seregu alipokuwa ameishi miaka thelathini, akamzaa Nahori. ");
INSERT INTO swhulb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seregu aliishi miaka mia mbili baada ya kumzaa Nahori. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Wakati Nahori alipokuwa ameishi miaka ishirini na tisa, akamzaa Tera. ");
INSERT INTO swhulb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahori aliishi mika 119 baada ya kumzaa Tera. Akawazaa pia wana wengine wa kiume na wa kike. ");
INSERT INTO swhulb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Baada ya Tera kuishi miaka sabini, akamzaa Abram, Nahori, na Haran. ");
INSERT INTO swhulb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hivi ndivyo vilikuwa vizazi vya Tera. Tera alimzaa Abram, Nahori, na Harani, na Harani akamzaa Lutu. ");
INSERT INTO swhulb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani akafa machoni pa baba yake Tera katika nchi aliyozaliwa, katika Ur wa Wakaldayo. ");
INSERT INTO swhulb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram na Nahori wakajitwalia wake. Mke wa Abram aliitwa Sarai na mke wa Nahori aliitwa Milka, binti wa Harani, aliyekuwa baba wa Milka na Iska. ");
INSERT INTO swhulb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sasa Sarai alikuwa Tasa; hakuwa na mtoto. ");
INSERT INTO swhulb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera akamtwaa Abram mwanawe, Lutu mwana wa mwanawe Harani, na Sarai mkwewe, mke wa mwanawe Abram, na kwa pamoja wakatoka Ur wa Wakaldayo, kwenda katika nchi ya Kanaani. Lakini walipofika Harani wakakaa pale. ");
INSERT INTO swhulb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera akaishi miaka 205 kisha akafa hapao Harani. ");
INSERT INTO swhulb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kisha Yahwe akamwambia Abram, “Nenda utoke katika nchi yako, na toka kwa ndugu zako, na kwa jamaa za baba yako, uende katika nchi nitakayo kuonesha. ");
INSERT INTO swhulb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nitakufanya uwe taifa kubwa, na nitakubariki na kulifanya jinalako kuwa kubwa, na utafanyika baraka. ");
INSERT INTO swhulb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nitawabariki wakubarikio, lakini asiye kuheshimu nita mlaani. Kupitia kwako familia zote za nchi zitabarikiwa. ");
INSERT INTO swhulb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kwa hiyo Abram akaondoka kama vile Yahwe alivyo mwambia kufanya, na Lutu akaenda pamoja naye. Abram alikuwa na miaka sabini na mitano wakati alipotoka Harani. ");
INSERT INTO swhulb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram akamchukua Sarai mkewe, Lutu, mtoto wa ndugu yake, na vyote walivyomiliki ambavyo wamevikusanya, na watu ambao wamewapata wakiwa huko Harani. Wakatoka kwenda katika nchi ya Kanaani, wakafika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram akapitia katikati ya nchi hadi Shekemu, hadi mwaloni wa More. Wakati huo wakanaani waliishi katika nchi hiyo. ");
INSERT INTO swhulb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahwe akamtokea Abram, na kusema, “Nitawapa uzao wako nchi hii.” Kwa hiyo Abram akamjengea madhabahu, Yahwe ambaye alimtokea. ");
INSERT INTO swhulb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kutoka pale akaenda kwenye nchi ya mlima mashariki mwa Betheli, ambapo alipiga hema yake, magaribi kukiwa na Betheli na mashariki kukiwa na mji wa Ai. Akajenga madhabahu ya Yahwe pale na kuliitia jina la Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kisha Abram akaendelea kusafiri, akielekea upande wa Negebu. ");
INSERT INTO swhulb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kulikuwa na njaa katika nchi, kwa hiyo Abram akaenda kukaa Misri, kwa kuwa njaa ilikua kali katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wakati alipokaribia kuingia Misri, akamwambia Sarai mkewe, “tazama, najua kuwa wewe ni mwanamke mzuri. ");
INSERT INTO swhulb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wamisri watakapokuona watasema, huyu ni mke wake, na wataniua mimi, lakini watakuacha wewe hai. ");
INSERT INTO swhulb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hivyo wewe sema kuwa ni dada yangu, ili kwamba niwe salama kwa sababu yako, na kumba maisha yangu yatasalimika kwa sababu yako.” ");
INSERT INTO swhulb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ikawa kwamba Abram alipoingia Misri, Wamisri wakaona kwamba Sarai ni mzuri sana. ");
INSERT INTO swhulb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Wakuu wa Farao wakamuona, na kumsifia kwa Farao, na huyu mwanamke akachukuliwa kupelekwa nyumbani mwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farao akamtendea kwa wema Abram kwa ajili yake, na akampatia kondoo, maksai, punda waume watumishi wa kiume, watumishi wa kike, punda wake, na ngamia. ");
INSERT INTO swhulb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kisha Yahwe akampiga Farao na nyumba yake kwa mapigo makuu kwa sababau ya Sarai, mke wa Abram. ");
INSERT INTO swhulb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Farao akamwita Abram na kusema, “Nini hiki ambacho umenifanyia? Kwa nini hukuniambia kuwa alikuwa mke wako? ");
INSERT INTO swhulb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kwa nini ulisema, 'ni dada yangu; na mimi nikamchukua kuwa mke wangu? Sasa kwa sababu hiyo huyu hapa mke wako. Mchukue na uende zako.” ");
INSERT INTO swhulb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kisha Farao akatoa amri kwa watu wake kuhusiana naye, na wakamuondoa, yeye pamoja na mke wake na vyote alivyokuwa navyo. ");
INSERT INTO swhulb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kwa hiyo Abram akaondoka akatoka Misri na akaenda Negebu, Yeye, mke wake, na vyote alivyokuwa navyo. Lutu pia akaenda pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Na sasa Abram alikuwa tajiri wa mifugo, fedha na dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Aliendelea na safari yake kutoka Negebu hadi Betheli, mahali ambapo hema yake ilikuwa tangu mwanzo, kati ya Betheli na mji wa Ai. ");
INSERT INTO swhulb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Akaenda mahali ambapo madhabahu ilikuwa imejengwa mwanzoni. Hapa akaliitia jina la Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","aliyekuwa anasafiri na Abram, alikuwa pia na ngo'mbe, makundi ya mifugo, na mahema. ");
INSERT INTO swhulb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nchi haikuwatosha wote kukaa pamoja karibu kwa sababu mali zao zilikuwa nyingi sana, kiasi kwamba hawakuweza kukaa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Pia, kulikuwa na ugomvi kati ya wachunga wanyama wa Abram na wachunga wanyama wa Lutu. Wakanaani pamoja na Waperizi walikuwa wakiishi katika nchi ile wakati huo. ");
INSERT INTO swhulb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kwa hiyo Abram akamwambia Lutu, “Pasiwe na ugomvi kati yako na mimi, na kati ya wachunga wanyama wako na wachunga wanyama wangu; licha ya hayo sisi ni familia. ");
INSERT INTO swhulb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Je nchi hii yote haiko mbele yako? Nenda na ujitenge na mi. Ikiwa utakwenda kushoto, mimi nitakwenda kulia. au ikiwa utakwenda kulia, mimi nitakwenda kushoto.” ");
INSERT INTO swhulb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kwa hiyo Lutu akatazama, na akaona kuwa nchi yote tambarare ya Yorodani ilikuwa na maji kila mahali hadi Zoari, kama vile bustani ya Yahwe, na kama nchi ya Misri. Hii ilikuwa ni kabla Yahwe hajaiangamiza Sodoma na Gomora. ");
INSERT INTO swhulb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kwa hiyo Lutu akajichagulia yeye mwenyewe nchi tambarare ya Yorodani na akasafiri mashariki, na ndugu hawa wakatengana wao kwa wao. ");
INSERT INTO swhulb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram akaishi katika nchi ya Kanaani, na Lutu akaishi katika miji ya tambarare. Akatandaza hema zake hadi Sodoma. ");
INSERT INTO swhulb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na sasa watu wa Sodoma walikuwa waovu na wenye dhambi nyingi dhidi ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahwe akamwambia Abram baada ya Lutu kuondoka kwake, “Angalia kuanzia mahali ulipo simama hadi kaskazini, kusini, mashariki, na magharibi. ");
INSERT INTO swhulb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nchi yote hii uionayo, nitakupatia wewe pamoja na uzao wako milele. ");
INSERT INTO swhulb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nitawafanya uzao wako kuwa wengi kama mavumbi ya nchi, kiasi kwamba kama kuna mtu anaweza kuhesabu mavumbi ya nchi, ndipo na uzao wako pia utahesabika. ");
INSERT INTO swhulb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Inuka, tembea katika urefu na upana wa nchi hii, kwa kuwa nitakupatia.” ");
INSERT INTO swhulb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kwa hiyo Abram akachukua hema yake, akaja na kukaa katika mwaloni wa Mamre, ambao uko Hebroni, na pale akajenga Madhabahu ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ikiwa katika siku za Amrafeli, mfalme wa shinari, Arioko, mfalme wa Elasari, Kedorlaoma, mfalme wa Elam na Tidali, mfalme wa Goimu, ");
INSERT INTO swhulb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","walifanya vita dhidi ya Bera mfalme wa Sodoma, Birsha, mfalme wa Gomora, Shinabu, mfalme wa Adma, Shemeberi, mfalme wa Seboim, na mfalme wa Bela(pia ikiitwa Soari). ");
INSERT INTO swhulb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hawa wafalme watano wa mwisho waliungana pamoja katika bonde la Sidim (pia likiitwa bahari ya chumvi). ");
INSERT INTO swhulb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kwa miaka kumi na mbili walimtumikia Kedorlaoma, lakini katika mwaka wa kumi na tatu waliasi. ");
INSERT INTO swhulb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kisha katika mwaka wa kumi na nne, Kedorlaoma na wafalme waliokuwa pamoja nae walikuja na kuwashambulia Warefai katika Ashteroth Karnaimu, na Wazuzi katika Hamu, Waemi katika Shawe Kiriathaimu, ");
INSERT INTO swhulb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Wahori katika mlima wao wa Seiri, mpaka El Parani iliyo karibu na jangwa. ");
INSERT INTO swhulb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kisha wakarudi wakaja En Misifati (Pia ikiitwa Kadeshi), na kuishinda nchi yote ya Waamaleki, na pia Waamori ambao waliishi Hasasoni Tamari. ");
INSERT INTO swhulb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kisha mfalme wa Sodoma, mfalme wa Gomora, mfalme wa Adma, mfalme wa Seboim, na mfalme wa Bela (pia ikiitwa Soari) walikwenda na kuandaa vita ");
INSERT INTO swhulb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","dhidi ya Kadorlaoma, mfalme wa Elam, Tidali mfalme wa Goim, Amrafeli, mfalme wa Shinari, Arioki, mfalme wa Elasari; wafme wanne dhidi ya wale watano. ");
INSERT INTO swhulb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na sasa bonde la Sidimu lilikuwa limejaa mashimo ya lami, na wafalme wa Sodoma na Gomora walipokimbia, wakaanguka pale. Wale waliosalia wakakimbilia milimani. ");
INSERT INTO swhulb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kwa hiyo adui akachukua mali zote za Sodoma na Gomora na vyakula vyao vyote, na wakaenda zao, ");
INSERT INTO swhulb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","walipoondoka, wakamchukua pia Lutu, mtoto wa ndugu yake na Abram ambaye aliishi Sodoma, pamoja na mali zake zote. ");
INSERT INTO swhulb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mmoja ambaye alitoroka alikuja na kumwambia Abram mwebrania. Alikuwa anaishi katika mialoni ya Mamre, mwamori ambaye alikuwa ni ndugu wa Eshkoli na Aneri ambao walikuwa washirika wa Abram. ");
INSERT INTO swhulb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram aliposikia kuwa maadui wamemteka ndugu yake, akawaongoza wanaume waliofunzwa na kuzaliwa nyumbani mwake 318 na akawaongoza hadi Dani. ");
INSERT INTO swhulb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Akawagawanya watu wake dhidi yao usiku na kuwavamia, na kuwafukuza mpaka Hoba, ambayo iko kaskazini mwa Dameski. ");
INSERT INTO swhulb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kisha akarudisha mali zote, pia akamrudisha ndugu yake Lutu na mali zake, pamoja na wanawake na watu wengine. ");
INSERT INTO swhulb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Baada ya Abram kurudi kutoka kumpiga Kadorlaoma na wafalme waliokuwa pamoja nae, mfalme wa Sodoma akatoka kuonana nae katika bonde la Shawe (pia iliitwa bonde la mfalme). ");
INSERT INTO swhulb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkizedeki, mfalme wa Salem, akaleta mkate na divai. Alikuwa ni kuhani wa Mungu aliye juu sana. ");
INSERT INTO swhulb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Alimbariki akisema, “Abarikiwea Abram na Mungu aliye juu sana, muumba wa mbingu na nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Abarikiwe Mungu aliye juu sana, ambaye amekupatia adui zako katika mikono yako.” Kisha Abram akampatia sehemu ya kumi ya kila kitu. ");
INSERT INTO swhulb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mfalme wa Sodama akamwambia Abram, “Nipatie watu, na ujichukulie wewe mwenyewe mali.” ");
INSERT INTO swhulb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram akamwambia mfalme wa Sodoma, “Nimeinua juu mkono wangu kwa Yahwe, Mungu aliye juu sana, muumbaji wa mbingu na nchi, ");
INSERT INTO swhulb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kwamba sitachukua uzi wala gidamu ya kiatu, au kitu chochote ambacho ni chako, 'ili kwamba usiseme, nimemfanya Abram kuwa tajiri.' ");
INSERT INTO swhulb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sitachukua chochote isipokuwa kile ambacho vijana wamekula na sehemu za watu waliokwenda nami. Aneri, Eskoli, na Mamre na wachukue sehemu zao.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Baada ya mabo haya neno la Yahwe likamjia Abram katika maono, likisema, “Usiogope, Abram! mimi ni ngao yako na thawabu yako kubwa sana.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram akasema, “Bwana Yahwe, utanipatia nini, kwa kuwa naenda bila mtoto, na mrithi wa nyumba yangu ni Eliezeri wa Dameski?” ");
INSERT INTO swhulb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram akasema, “Kwakuwa hujanipatia uzao, tazama, mwangalizi wa nyumba yangu ndiye mrithi wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kisha, tazama, neno la Yahwe likaja kwake, kusema, “Mtu huyu hatakuwa mrithi wako; isipokuwa atakaye toka katika mwili wako ndiye atakuwa mrithi wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kisha akamtoa nje, na akasema, Tazama mbinguni, na uzihesabu nyota, ikiwa unaweza kuzihesabu.” Kisha akamwambia, hivyo ndivyo uzao wako utakavyokuwa. ");
INSERT INTO swhulb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Akamwamini Yahwe, na akamuhesabia jambo hili kuwa mwenye haki. ");
INSERT INTO swhulb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Akamwambia, Mimi ni Yahwe, niliye kutoa katika Uru ya Wakaldayo, na kukupatia nchi hii kuirithi.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Akasema, “Bwana Yahwe, nitajua je kuwa nitairithi?” ");
INSERT INTO swhulb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kisha akamwambia, “Nipatie ndama wa umri wa miaka mitatu, mbuzi mke wa umri wa miaka mitatu, na kondoo mume wa umri wa miaka mitatu, na njiwa na mwana njiwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Akamletea hivi vyote, akavipasua katika sehemu mbili, akaweka kila kipande kuelekea mwenzake, ila ndege hakuawapasua. ");
INSERT INTO swhulb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Wakati ndege walipokuja juu ya mizoga, Abram akawafukuza. ");
INSERT INTO swhulb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kisha wakati jua lilipokuwa likizama, Abram akalala usingizi mzito na tazama, hofu ya giza kuu ikamfunika. ");
INSERT INTO swhulb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kisha Yahwe akamwambia Abram, “Ujuwe kwa hakika kwamba uzao wako watakuwa wageni katika nchi ambayo si ya kwao, na watatumikishwa na kuteswa kwa miaka mia nne. ");
INSERT INTO swhulb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nitahukumu taifa ambalo watalitumikia, na baadye watatoka wakiwa na mali nyingi. ");
INSERT INTO swhulb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Lakini utakwenda kwa baba zako kwa amani, na utazikwa katika uzee mwema. ");
INSERT INTO swhulb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Katika kizazi cha nne watakuja tena hapa, kwa sababu uovu wa Waamori haujafikia mwisho wake.” ");
INSERT INTO swhulb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Jua lilipokuwa limezama na kuwa giza, tazama, chungu cha moshi wenye moto na miali ya mwanga ilipita kati ya vile vipande. ");
INSERT INTO swhulb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Siku hiyo Yahwe akafanya agano na Abram, akisema, “Ninatoa nchi hii kwa uzao wako, kutoka mto wa Misri hadi kwenye mto mkuu, Frati - ");
INSERT INTO swhulb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Mkeni, Mkenizi, na Mkadmoni, ");
INSERT INTO swhulb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Mhiti, Mperizi, Mrefai, ");
INSERT INTO swhulb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Mwamori, Mkanaani, Mgirgashi, na Myebusi. ");
INSERT INTO swhulb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Kisha Sarai mke wa Abram, alikuwa hajamzalia mtoto, lakini alikuwa na mtumishi wa kike, Mmisri ambaye jina lake aliitwa Hajiri. ");
INSERT INTO swhulb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kwa hiyo Sarai akamwambia Abram, “Tazama, Yahwe hajanifanya mimi kuwa na watoto. Nenda na ulale na mtumishi wangu. Ili kwamba niweze kupata watoto kupitia yeye.” Abram akasikiliza sauti ya Sarai. ");
INSERT INTO swhulb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ilikuwa baada ya Abram kuishi miaka kumi katika nchi ya Kanaani ndipo Sarai, mke wa Abram, alimtoa Hajiri yule mmisri mtumishi wake kwa mume wake awe kama mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kwa hiyo akawa na mahusiano na Hajiri, na akabeba mimba. Na alipoona kuwa amebeba mimba, akamdharau bibi yake. ");
INSERT INTO swhulb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kisha Sarai akamwambia Abram, “Jambo hili baya kwangu ni kwa sababu yako. Nilimtoa mtumishi wangu wa kike katika kumbatio lako. Na alipoona kuwa amebeba mimba, nilidharaulika machoni pake. Na sasa acha Yahwe aamuwe kati yangu na wewe.” ");
INSERT INTO swhulb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Lakini Abram akamwambia Sarai, “Tazama, hapa, mtumishi wako yuko katika uwezo wako, fanya unachofikiri ni kizuri sana kwake.” Kwa hiyo Sarai akakabiliana naye kwa ukatili, na akatoroka. ");
INSERT INTO swhulb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika wa Yahwe akamkuta karibu na chemichemi ya maji katika jangwa, chemichemi iliyo katika njia kuelekea Shuri. ");
INSERT INTO swhulb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Akasema, Hajiri, mtumishi wa Sarai, umetoka wapi na unakwenda wapi?” Na akasema, ninamtoroka bibi yangu Sarai.” ");
INSERT INTO swhulb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaika wa Yahwe akamwambia, “ Rudi kwa bibi yako, na unyenyekee chini ya mamlaka yake.” ");
INSERT INTO swhulb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kisha Malaika wa Yahwe akamwambia, “Nitazidisha uzao wako maradufu, kiasi kwamba watakuwa wengi wasioweza kuhesabika.” ");
INSERT INTO swhulb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malaika wa Yahwe pia akamwambia, “ Tazama, wewe unamimba, na utazaa mtoto kiume, na utamwita jina lake Ishmaeli, kwasabab Yahwe amesikia mateso yako. ");
INSERT INTO swhulb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Atakuwa punda mwitu wa mtu. Atakuwa adui dhidi ya kila mtu, na kila mtu atakuwa adui yake, na ataishi kando na ndugu zake wote.” ");
INSERT INTO swhulb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kisha akamwita jina hili Yahwe aliye zungumza naye, “Wewe ni Mungu unionaye mimi,” kwa kuwa alisema, “je ninaendelea kweli kuona, hata baada ya kuwa ameniona?” ");
INSERT INTO swhulb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kwa hiyo kisima kiliitwa Beerlahairori; Tazama, kiko kati ya Kadeshi na Beredi. ");
INSERT INTO swhulb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajiri akamzalia Abram mwana wa kiume, na Abram akamwita mwanawe, ambaye Hajiri amemzaa jina, Ishmaeli. ");
INSERT INTO swhulb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram alikuwa na umri wa miaka themanini na sita wakati Hajiri alipomzaa Ishmaeli kwa Abram. ");
INSERT INTO swhulb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wakati Abram alipokuwa na umri wa miaka tisini na tisa, Yahwe alimtokea Abram na akamwambia, “Mimi ni Mungu wa uwezo. Uende mbele yangu, na uwe mkamilifu. ");
INSERT INTO swhulb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kisha nitalithibitisha agano langu kati yangu mimi na wewe, na nitakuzidisha sana. ");
INSERT INTO swhulb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram akainama uso wake hadi chini ardhini na Mungu akazungumza naye, akisema, ");
INSERT INTO swhulb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Mimi, tazama, agano langu liko nawe. Utakuwa baba wa mataifa mengi. ");
INSERT INTO swhulb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Wala jina lako halitakuwa tena Abram, bali jina lako litakuwa Abraham - kwa kuwa ninakuchagua kuwa baba wa mataifa mengi. ");
INSERT INTO swhulb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nitakufanya uwe na uzao mwingi zaidi, na nitakufanya mataifa, na wafalme watatoka kwako. ");
INSERT INTO swhulb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nitaimarisha agao langu kati yangu mimi na wewe na uzao wako baada yako, katika vizazi vyao vyote kwa agano la milele, nitakuwa Mungu kwako na kwa wazao wako baada yako. ");
INSERT INTO swhulb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nitakupa wewe, na wazao wako baada yako, nchi ambayo ulikuwa unaishi, nchi yote ya Kanaani, kuwa miliki ya milele, na nitakuwa Mungu wao.” ");
INSERT INTO swhulb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kisha Mungu akamwambia Abraham, “nawe lazima ulishike agano langu, wewe pamoja na uzao wako baada yako kwa vizazi vyao. ");
INSERT INTO swhulb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hili ndilo agano langu, ambalo utalishika, kati yangu na wewe na wazao wako baada yako: Kila mwanaume wa kwenu lazima atahiriwe. ");
INSERT INTO swhulb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Lazima mtatahiriwa katika nyama ya govi la ngozi ya mbele, na hii itakuwa ishara ya agano kati yangu mimi na ninyi. ");
INSERT INTO swhulb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kila mwanaume wa kwenu aliye na umri wa siku nane lazima atahiriwe, katika vizazi ya watu wenu. Hii ni pamoja na yule azaliwaye katika nyumba yako na yeye ambaye amenunuliwa kwa fedha kutoka kwa mgeni yeyote ambaye si mmoja wa wazao wako. ");
INSERT INTO swhulb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mtu ambaye amezaliwa katika nyumba yako na yule aliye nunuliwa kwa fedha yako lazima atahiriwe. Hivyo agano langu litakuwa katika mwili wenu kuwa agano la milele. ");
INSERT INTO swhulb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mwanaume yeyote asiye tahiriwa katika mwili govi la ngozi yake ya mbele atatengwa na watu wake. Amevunja agano langu.” ");
INSERT INTO swhulb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mungu akamwambia Abraham, “kwa habari ya Sarai mkeo, usimuite tena Sarai. Badala yake jina lake litakuwa Sara. ");
INSERT INTO swhulb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nitambariki, na nitakupatia mtoto wa kiume kwake. Nitambariki, na atakuwa mama wa mataifa. Wafalme wa watu wa mataifa watapatikana kutokana na yeye. ");
INSERT INTO swhulb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kisha Abraham akainama uso wake hadi ardhini, na akacheka, akasema moyoni mwake, Je yawezekana mtoto azaliwe kwa mwanaume ambaye ana umri wa miaka miamoja? na Je Sara, ambaye ana umri wa miaka tisini anaweza kuzaa mwana?” ");
INSERT INTO swhulb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham akamwambia Mungu, “Lau Ishmaeli angeweza kuishi kabla yako!” ");
INSERT INTO swhulb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mungu akasema, Hapana, Sarai mkeo atakuzalia mtoto wa kiume na utamwita jina lake Isaka. Nita imarisha agano langu na yeye kama agano la milele pamoja na uzao wake baada yake. ");
INSERT INTO swhulb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na kwa habari ya Ishmaeli nimekusikia. Tazama, ninambariki, na nitamfanya kuwa na uzao na kumzidisha maradufu. Atakuwa baba wa viongozi kumi na mbili wa makabila, na nitamfanya kuwa taifa kuu. ");
INSERT INTO swhulb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Lakini agano langu nitalifanya imara na Isaka, ambaye Sarai atazaa kwako majira haya mwakani.” ");
INSERT INTO swhulb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Alipo kuwa amemaliza kuzungumza naye, Mungu akaondoka kwa Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kisha Abraham akamtwaa Ishmaeli mwanawe, na wote ambao walizaliwa katika nyumba yake, na wote ambao walinunuliwa kwa fedha yake, kila mwanaume miongoni mwa watu wa nyumba ya Abraham, walitahiriwa mwili wa magovi ya ngozi ya mbele katika siku iyo hiyo, kama Mungu alivyo kuwa amesema. ");
INSERT INTO swhulb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham alikuwa na umri wa miaka tisini na tisa alipotahiriwa katika mwili wa govi la ngozi yake ya mbele. ");
INSERT INTO swhulb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na Ishmaeli mwanawe alikuwa na umri wa miaka kumi na tatu alipotahiriwa katika mwili wa govi la ngozi yake ya mbele. ");
INSERT INTO swhulb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Siku ile ile ambayo wote wawili Abraham na Ishmael mwanawe walipotahiriwa, ndipo ");
INSERT INTO swhulb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","wanaume wote wa nyumba yake walitahiriwa pia, hawa ni pamoja na wale waliozaliwa katika nyumba ile na wale walionunuliwa kwa fedha kutoka kwa mgeni. ");
INSERT INTO swhulb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahwe alimtokea Abraham katika Mialoni ya Mamre, alipokua ameketi mlangoni pa hema wakati wa jua. ");
INSERT INTO swhulb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Akatazama juu na, tazama, akaona wanaume watatu wamesimama mbele yake. Alipo waona, alikimbia kupitia mlango wa hema kuwalaki na kuinama chini hadi ardhini. ");
INSERT INTO swhulb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Akasema, “Bwana, kama nimepata upendelea machoni pako, nakuomba usinipite na kuniacha mtumishi wako. ");
INSERT INTO swhulb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Naomba maji kidogo yaletwe, mnawe miguu yenu, na mjipumzishe chini ya mti. ");
INSERT INTO swhulb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nami acha nilete chakula kidogo, ili kwamba mjiburudishe wenyewe. Ndipo baadae mwaweza kwenda zenu, kwa kuwa mmekuja kwa mtumishi wenu.” Nao wakasema, “Fanya kama ulivyo sema.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kisha Abraham akaenda upesi hemani kwa Sara, na akasema, “Harakisha, chukua vipimo vitatu vya unga safi, uukande, na fanya mkate.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kisha Abraham akakimbia kundini, akachukua ndama wa ng'ombe aliye laini na mzuri, na akampatia mtumishi na kwa haraka akamwandaa. ");
INSERT INTO swhulb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Akatwaa siagi na maziwa na ndama aliye kwisha andaliwa, na akaweka chakula mbele yao, naye akasimama karibu nao chini ya mti wakati wanakula. ");
INSERT INTO swhulb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wakamwambia, “Mke wako Sara yuko wapi?” akajibu. “pale hemani.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","akasema, “Hakika nitarejea kwako majira ya machipuko, na tazama Sara mkeo atakuwa na mtoto wa kiume.” Sara alikuwa akisikiliza mlangoni pa hema iliyokuwa nyuma yake. ");
INSERT INTO swhulb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham na Sara walikuwa wazee, umri wao ulikuwa umeendelea sana, na Sara alikuwa amepita umri ambao mwanamke anaweza kuzaa watoto. ");
INSERT INTO swhulb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kwa hiyo Sara akajicheka mwenyewe, akijisemesha mwenyewe, “baada ya kuwa nimechakaa na bwana wangu ni mzee, je ni tapata furaha hii?” ");
INSERT INTO swhulb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahwe akamwambia Abraham, “Kwa nini Sara amecheka na kusema, Je ni kweli nitazaa mtoto, nikiwa mzee'? ");
INSERT INTO swhulb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Je kuna jambo lolote gumu sana kwa Yahwe? Itakuwa katika wakati nilioweka mimi majira ya machipuko, nitarejea kwako. Majira haya mwakani Sara atakuwa na mtoto wa kiume.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kisha Sara akakataa na kusema, “sikucheka,” kwa kuwa aliogopa. Yahwe akasema, “hapana ulicheka.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kisha wale wanaume walisimama kuondoka na wakatazama chini kuelekea Sodoma. Abraham akafuatana nao kuona njia yao. ");
INSERT INTO swhulb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Lakini Yahwe akasema, Je ni mfiche Abraham kile ninacho kusudia kufanya, ");
INSERT INTO swhulb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ikiwa kwa hakika Abraham atakuwa mkuu na taifa lenye nguvu, na katika yeye mataifa yote ya dunia watabarikiwa? ");
INSERT INTO swhulb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kwa kuwa nimemchagua ili awaelekeze wanawe na nyumba yake baada yake waishike njia ya Yahwe, watende utakatifu na haki, ili kwamba Yahwe ampatie Abraham yale aliyo yasema kwake.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kisha Yahwe akasema, “Kwa sababu kilio cha Sodoma na Gomora ni kikuu, na kwa kuwa dhambi yao ni kubwa, ");
INSERT INTO swhulb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","sasa nitashuka pale na kuona kilio kilicho nifikia dhidi yake, ikiwa kweli wamefanya au hawakufanya, nitajua.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kwa hiyo wale wanaume wakageuka toka pale, na kuelekea Sodoma, lakini Abraham akabaki amesimama mbele ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kisha Abraham alikaribia na kusema, “Je utawafutilia mbali watakatifu pamoja na waovu? ");
INSERT INTO swhulb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Huenda wakawepo wenye haki hamsini katika mji. Je utawakatilia mbali na usiuache mji kwa ajili ya hao watakatifu hamsini walioko hapo? ");
INSERT INTO swhulb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hasha usifanye hivyo, kuwauwa watakatifu pamoja na waovu, ili kwamba watakatifu watendewe sawa na waovu. Hasha! Je muhukumu wa ulimwengu wote hatatenda haki?” ");
INSERT INTO swhulb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahwe akasema, “Katika Sodoma nikipata watakatifu hamsini kwenye mji, nita uacha mji wote kwa ajili ya hao.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham akajibu na kusema, “Tazama, Nimeshika kusema na Bwana wangu, hata kama mimi ni mavumbi na majivu! ");
INSERT INTO swhulb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Itakuwaje ikiwa kuna watano pungufu katika idadi ya hao watakatifu hamsini? Je utaangamiza mji wote kwa upungufu wa hao watano?” Akasema, “Sitaangamiza, ikiwa nitapata watu arobaini na watano pale.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Akaongea naye tena, na kusema, “Itakuwaje ikiwa arobaini watapatikana pale?” Akajibu, “Sitafanya kwa ajili ya hao arobaini.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Akasema, Tafadhali usikasirike, Bwana, nikiongea. Pengine thelathini watapatikana pale.” Akajibu, 'Sitafanya, ikiwa nitapata thelathini pale.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Akasema, Tazama, Nimeshika kusema na Bwana wangu! Pengine ishirini watapatikana pale.” Akajibu, “Sitaharibu kwa ajili ya hao ishirini.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Akasema, “Tafadhali usikasirike, Bwana, na nitasema jambo hili kwa mara ya mwisho. Huenda kumi wakaonekana kule.” Na akasema, sitaangamiza kwa ajili ya hao kumi.” ");
INSERT INTO swhulb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahwe akaendelea na njia yake mara tu baada ya kumaliza kuongea na Abraham, na Abraham akarudi nyumbani. ");
INSERT INTO swhulb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malaika wawili wakaja Sodoma jioni, wakati ambao Lutu alikuwa amekaa langoni mwa Sodoma. Lutu akawaona, akainuka kuwalaki, na akainama uso wake chini ardhini. ");
INSERT INTO swhulb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Akasema, Tafadhari Bwana zangu, nawasihi mgeuke mwende kwenye nyumba ya mtumishi wenu, mlale pale usiku na muoshe miguu yenu. Kisha muamke asubuhi na mapema muondoke.” Nao wakasema, “Hapana, usiku tutalala mjini.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lakini akawasihi sana, mwishowe wakaondoka pamoja nae, na wakaingia katika nyumba yake. Akaandaa chakula na kuoka mkate usiotiwa chachu, wakala. ");
INSERT INTO swhulb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Lakini kabla hawaja lala, wanaume wa mji, wa Sodoma, vijana kwa wazee wakaizunguka nyumba, wanaume wote kutoka kila kona ya mji. ");
INSERT INTO swhulb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wakamwita Lutu, na kumwambia, “Wale wanaume walioingia kwako usiku wakowapi? watoe hapa nje waje kwetu, ili tuweze kulala nao.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu akatoka nje na akafunga mlango. ");
INSERT INTO swhulb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Akasema, “Nawasihi, ndugu zangu, msitende uovu. ");
INSERT INTO swhulb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tazama, nina mabinti wawili ambao hawajawahi kulala na mwanaume yeyote. Nawaomba tafadhari niwalete kwenu, na muwafanyie lolote muonalo kuwa jema machoni penu. Msitende lolote kwa wanaume hawa, kwa kuwa wamekuja chini ya kivuli cha dari yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Wakasema, “Ondoka hapa!” Wakasema pia, huyu alikuja kukaa hapa kama mgeni, na sasa amekuwa mwamuzi! Sasa tutakushugulilia vibaya wewe kuliko wao.” Wakamsonga sana huyo mtu, huyo Lutu, na wakakaribia kuvunja mlango. ");
INSERT INTO swhulb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lakini wale wanaume wakamkamata Lutu na kumweka ndani na wakafunga mlango. ");
INSERT INTO swhulb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kisha wale wageni wa Lutu wakawapiga kwa upofu wale wanaume waliokuwa nje ya nyumba, vijana na wazee kwa pamoja, kiasi kwamba wakachoka wakati wakiutafuta mlango. ");
INSERT INTO swhulb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Basi wale watu wakamwambia Lutu, Je una mtu mwingine yeyote hapa? wakwe zako, wanao na mabinti zako, na yeyote mwingine katika huu mji, ukawatoe hapa. ");
INSERT INTO swhulb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kwa kuwa tunakaribia kuiangamiza sehemu hii, kwa sababu mashitaka dhidi yake mbele ya Yahwe yamezidi kiasi kwamba ametutuma kuuangamiza.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lutu akatoka na akazungumza na wakwe zake, wanaume ambao walikuwa wamewaposa binti zake, akawambia, “Ondokeni upesi mahali hapa, kwa kuwa Yahwe anakaribia kuuangamiza mji.” Lakini kwa wakwe zake alionekana kuwa anawatania. ");
INSERT INTO swhulb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Alfajiri, malaika wakamsihi Lutu, wakisema, ondoka, mtwae mkeo na binti zako wawili ambao wako hapa, ili kwamba usipotelee katika adhabu ya mji huu.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lakini akakawia-kawia. Kwa hiyo watu wale wakamshika mkono wake, na mkono wa mkewe, na mikono ya binti zake wawili, kwa sababu Yahwe alimhurumia. Wakawatoa nje, na kuwaweka nje ya mji. ");
INSERT INTO swhulb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Wakisha kuwatoa nje mmoja wa wale watu akasema, “jiponye nafsi yako! usitazame nyuma, au usikae mahali popote kwenye hili bonde. Toroka uende milimani ili kwamba usije ukatoweshwa mbali.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lutu akawambia, “Hapana, tafadhali bwana zangu! ");
INSERT INTO swhulb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mtumishi wenu amepata kibali machoni pako, na umenionesha wema ulio mkuu kwa kuokoa maisha yangu, lakini sitaweza kutorokea milimani, kwa sababu mabaya yataniwahi na nitakufa. ");
INSERT INTO swhulb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tazama, ule mji pale uko karibu nijisalimishe pale, na ni mdogo. Tafadhari niacheni nikimbilie pale ( Je Siyo mdogo ule?), na maisha yangu yataokolewa.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Akamwambia, “Sawa, nimekubali ombi hili pia, kwamba sitaangamiza mji ambaoumeutaja. ");
INSERT INTO swhulb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Harakisha! toroka uende pale, kwa kuwa sitafanya chochote mpaka ufike pale.” kwa hiyo mji ule ukaitwa Soari. ");
INSERT INTO swhulb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Jua lilikuwa limekwisha chomoza juu ya nchi wakati Lutu alipofika Soari. ");
INSERT INTO swhulb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kisha Yahwe akanyesha juu ya Sodoma na Gomora kiberiti na moto toka kwa Yahwe mbinguni. ");
INSERT INTO swhulb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Akaharibu miji ile, na bonde lote, na vyote vilivyomo katika miji, na mimea iliyo chipua juu ya ardhi. ");
INSERT INTO swhulb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lakini mke wa Lutu aliye kuwa nyuma yake, akatazama nyuma, na akawa nguzo ya chumvi. ");
INSERT INTO swhulb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham akaamuka asubuhi na mapema akaenda mahali alipokuwa amesimama mbele ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Akatazama chini kuelekea Sodoma na Gomora na kuelekea katika nchi yote bondeni. Akaona na tazama, moshi ulikuwauki ukienda juu kutoka chini kama moshi wa tanuru. ");
INSERT INTO swhulb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Wakati Mungu alipoharibu miji ya bondeni, Mungu akamkumbuka Abraham. Akamtoa Lutu kutoka katika maangamizi alipoangamiza miji ambayo katika hiyo Lutu aliishi. ");
INSERT INTO swhulb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lakini Lutu akapanda juu kutoka Soari na kwenda kuishi katika milima akiwa pamoja na binti zake wawili, kwa sababu aliogopa kuishi Soari. Kwa hiyo akaishi pangoni, yeye na binti zake wawili. ");
INSERT INTO swhulb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yule wa kwanza akamwambia yule mdogo, “Baba yetu ni mzee, na hakuna mwanaume mahali popote wa kulala na sisi kulingana na desturi ya dunia yote. ");
INSERT INTO swhulb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Njoo na tumnyweshe baba yetu mvinyo na tulale naye ili kwamba tuendeleze uzao wa baba yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kwa hiyo wakamnywesha baba yako mvinyo usiku ule. Kisha yule wa kwanza akaingia na akalala na baba yake; Baba yake hakujua ni wakati gani alikuja kulala, wala wakati alipo amka. ");
INSERT INTO swhulb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Siku iliyo fuata yule wa kwanza akamwambia mdogowake, “Sikiliza, usiku wa jana nililala na baba yangu. Na tumnyweshe mvinyo usiku wa leo pia, na uingie ukalale naye. Ili kwamba tuendeleze uzao wa baba yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kwa hiyo wakamnywesha baba yao mvinyo usiku ule pia, na yule mdogo akaenda na akalala naye. Baba yake hakujua ni wakati gani alilala, wala wakati alipoamka. ");
INSERT INTO swhulb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Basi hao binti wote wawili wa Lutu wakapata mimba kwa baba yao. ");
INSERT INTO swhulb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Wa kwanza akazaa mwana wa kiume, na akamwita jina lake Moabu. Akawa ndiye baba wa wamoabu hata leo. ");
INSERT INTO swhulb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nayule mdogo naye akazaa mwana wa kiume, na akamwita Benami. Huyu ndiye baba wa watu wa Waamoni hata leo. ");
INSERT INTO swhulb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham akasafiri kutoka pale hadi nchi ya Negebu, na akakaa kati ya Kadeshi na Shuri. Akawa mgeni akiishi Gerari. ");
INSERT INTO swhulb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham akasema kususu mkewe Sara, “ni dada yangu.” Kwa hiyo Abimeleki mfalme wa Gerari akatuma watu wake kumchukua Sara. ");
INSERT INTO swhulb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lakini Mungu akamtokea Abimeleki usiku katika ndoto, akamwambia, “Tazama, wewe ni mfu kutokana na mwanamke uliye mchukua, kwa kuwa ni mke wa mtu.” ");
INSERT INTO swhulb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Basi Abimeleki alikuwa bado hajamkaribia hivyo akasema, “Bwana, Je utaua hata taifa lenye haki? ");
INSERT INTO swhulb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Je si yeye mwenyewe aliye niambia, 'Sara ni dada yangu?' Hata Sara mwenyewe alisema, 'ni kaka yangu.' Nimefanya hili katika uadilifu wa moyo wangu na katika mikono isiyo na hatia.” ");
INSERT INTO swhulb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kisha Mungu akasema naye katika ndoto, “Kweli, ninajua pia kwamba umefanya hili katika uadilifu wa moyo wako, na pia nilikuzuia usitende dhambi dhidi yangu mimi. Ndiyo maana sikuruhusu umshike. ");
INSERT INTO swhulb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kwa hiyo, mrudishe huyo mke wa mtu, kwa kuwa ni nabii. Atakuombea, na utaishi. Lakini usipo mrudisha, ujuwe kwamba wewe pamoja na wote walio wa kwako mtakufa hakika. ");
INSERT INTO swhulb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki akaamka asubuhi na mapema akawaita watumishi wake wote waje kwake. Akawasimulia mambo haya yote, na watu wale wakaogopa sana. ");
INSERT INTO swhulb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kisha Abimeleki akamwita Abraham na kumwambia, “Umetufanyia jambo gani? Ni kwa jinsi gani nimekutenda dhambi kwamba umeniletea mimi na ufalme wangu dhambi hii kubwa? Umenifanyia mimi jambo ambalo halipaswi kufanywa.” ");
INSERT INTO swhulb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki akamwambia Abraham, “Nini kilikushawishi wewe kutenda jambo hili?” ");
INSERT INTO swhulb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham akasema, “Ni kwasababu nilifikiri hakika hakuna hofu ya Mungu katika sehemu hii, na kwamba wataniua kwa ajili ya mke wangu.' ");
INSERT INTO swhulb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Licha ya kwamba kweli ni dada yangu, binti wa baba yangu, ingawa si binti wa mama yangu; na ndiye alifanyika kuwa mke wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Wakati Mungu aliponiondoa katika nyumba ya baba yangu na kusafiri kutoka mahali kwenda mahali pengine, nilimwambia mke wangu, kwa kila sehemu tutakayo kwenda, unioneshe uaminifu wako kama mke wangu: Kila mahali tutakapo kwenda, useme juu yangu kuwa, “Ni kaka yangu.”''' ");
INSERT INTO swhulb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ndipo Abimeleki akatwaa kondoo, maksai, watumwa wa kiume na wa kike akampatia Abraham. Basi Abimeleki akamrudisha Sara, mke wa Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki akasema, Tazama, Nchi yangu i mbele yako. Kaa mahali utakapopendezewa.” ");
INSERT INTO swhulb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Na kwa Sara akasema, Tazama, nimempatia kaka yako vipande elfu vya fedha. Navyo ni kwa ajili ya kufunika kosa lolote dhidi yako machoni pa wote walio pamoja na wewe, na mbele ya kila mtu ambaye umemfanya kuwa na haki.” ");
INSERT INTO swhulb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kisha Abraham akaomba kwa Mungu, Na Mungu akamponya Abimeleki, mkewe, na watumwa wake wa kike kiasi kwamba wakaweza kupata watoto. ");
INSERT INTO swhulb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kwa kuwa Yahwe alikuwa amewafanya wanawake wote wa nyumaba ya Abimeleki kuwa tasa kabisa, kwa sababu ya Sara, mke wa Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahwe akamsikiliza Sara kwa umakini kama alivyo kuwa amemwambia, Yahwe akamfanyia Sara kama alivyo kuwa amemwahidi. ");
INSERT INTO swhulb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara akachukua mimba na akamzalia Abraham mtoto wa kiume katika uzee wake, katika muda ule ule ambao Mungu alikuwa amemwambia. ");
INSERT INTO swhulb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham akamwita jina mwanawe, ambaye alizaliwa kwake, na Sara, Isaka. ");
INSERT INTO swhulb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham akamtahiri mwanawe Isaka alipofikisha siku nane, kama vile Mungu alivyokuwa amemwagiza. ");
INSERT INTO swhulb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham alikuwa na umri wa miaka mia moja wakati mwanawe Isaka anazaliwa kwake. ");
INSERT INTO swhulb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara akasema, “Mungu amenifanya nicheke; kila mtu atakaye sikia atacheka pamoja na nami.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Pia akasema, “Nani angesema kwa Abraham kwamba Sara atalea mtoto, na sasa kweli nimemzalia mtoto wakiume katika uzee wake!” ");
INSERT INTO swhulb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mtoto akakua na akaachishwa kunyonya, na Abraham akafanya sherehe kubwa katika siku ambayo Isaka aliachishwa. ");
INSERT INTO swhulb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara akamwona mwana wa Hajiri Mmisri, ambaye alikuwa amezaliwa kwa Abraham, akidhihaki. ");
INSERT INTO swhulb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kwa hiyo akamwambia Abraham, “Mfukuze huyu mwanamke huyu mtumwa pamoja na mtoto wake: kwa kuwa mtoto huyu wa mwanamke mtumwa hawezi kuwa mrithi pamoja na mwanangu Isaka.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Jambo hili likamuhuzunisha sana Abraham kwa sababu ya mwanawe. ");
INSERT INTO swhulb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lakini Mungu akamwambia Abraham, “Usihuzunike kwa sababu ya kijana huyu, na kwa sababu ya mwanamke huyu mtumwa wako. Sikiliza maneno asemayo Sara juu ya jambo hili, kwa sababu itakuwa kupitia Isaka kwamba uzao wako utaitwa. ");
INSERT INTO swhulb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nitamfanya pia mtoto wa mjakazi kuwa taifa, kwa sababu ni uzao wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham akaamka asubuhi na mapema, akachukua mkate na kiriba cha maji, akampatia Hajiri, akiweka juu ya bega lake. Akamtoa kijana akampatia Hajiri na akawaondoa. Hajiri akaondoka akapotea katika jangwa la Beerisheba. ");
INSERT INTO swhulb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Maji yalipokwisha kwenye kiriba akamtelekeza kijana katika moja ya vichaka. ");
INSERT INTO swhulb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kisha akaondoka, na akakaa umbali kidogo na yule kijana, umbali kama wa kutupa mshale, kwa vile alisema, “Na nisitazame kifo cha mtoto.” Alipokuwa amekaa kumkabili, akapaza sauti yake akalia. ");
INSERT INTO swhulb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mungu akasikia kilio cha kijana, na malaika wa Mungu akamwita Hajiri kutoka mbinguni, akamwambia, “Nini kinakusumbua? Usiogope, kwa kuwa Mungu amesikia kilio cha kijana mahali alipo. ");
INSERT INTO swhulb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Inuka msimamishe mtoto, na umtie moyo; kwa kuwa nitamfanya kuwa taifa kubwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kisha Mungu akayafunua macho ya Hajiri, natazama akaona kisima cha maji. Akaenda akajaza kiriba maji, na akampatia kijana akanywa. ");
INSERT INTO swhulb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mungu akawa pamoja na kijana, na akakua. Akaishi jangwani akawa mwindaji. ");
INSERT INTO swhulb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Akaishi katka jangwa la Parani, na mama yake akampatia mke kutoka Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ikawa kwamba katika wakati ule Abimeleki na Fikoli kamanda wa jeshi lake akamwambia Abraham, akisema, “Mungu yuko pamoja na wewe katika yote uyatendayo. ");
INSERT INTO swhulb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Sasa niapie kwa Mungu kwamba hutanifanyia baya, wala mwanangu, wala uzao wangu. Onesha kwangu na kwa nchi ambayo umekuwa ukikaa agano lile lile la uaminifu ambalo nimekuonesha wewe.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham akasema, “Nina apa.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham pia akamlalamikia Abimeleki kuhusu kisima cha maji ambacho watumishi wa Abimeleki wamekinyang'anya. ");
INSERT INTO swhulb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki akasema, “Sijui ni nani amefanya jambo hili. Hukuniambia mapema; na sijalisikia ila leo hii.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kwa hiyo Abraham akachukua kondoo na ng'ombe maksai akampatia Abimeleki, na wawili hawa wakafanya agano. ");
INSERT INTO swhulb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Kisha Abraham akatenga wanakondoo wa kike saba pekeyao. ");
INSERT INTO swhulb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki akamwambia Abraham, “Nini maana ya hawa wanakondoo wa kike saba ambao umewatenga pekeyao?” ");
INSERT INTO swhulb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Akajibu, “Hawa wanakondoo wa kike saba utawapokea kutoka mkonono mwangu, ili kwamba uwe ushahidi kwangu, kuwa nichimba kisima hiki.” ");
INSERT INTO swhulb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kwa hiyo akaita mahali pale Beerisheba, kwa sababu mahali pale wote wawili wali apa kiapo. ");
INSERT INTO swhulb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Walifanya agano hapo Bersheba, kisha Abimeleki na Fikoli, amiri wa jeshi, wakarudi katika nchi ya Wafilisti. ");
INSERT INTO swhulb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham akapanda mti wa mkwaju katika Beerisheba. Na pale akamwabudu Yahwe, Mungu wa milele. ");
INSERT INTO swhulb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham akasalia kuwa mgeni katika nchi ya Wafilisti kwa siku nyingi. ");
INSERT INTO swhulb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ikawa kwamba baada ya mambo hayo Mungu akampima Abraham. Akamwambia, “Abraham!” Abraham akasema, “Mimi hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kisha Mungu akasema, “Mchukue mwanao, mwanao wa pekee, umpendaye, Isaka, na uende katika nchi ya Moria. Mtoe kama sadaka ya kuteketezwa mahali pale juu ya moja ya milima hiyo, ambayo nitakwambia.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kwa hiyo Abraham akaamka asubuhi na mapema, akatandika punda wake, akawachukuwa vijana wake wawili, pamoja na Isaka mwanawe. Akakata kuni kwa ajili ya sadaka ya kuteketezwa, kisha akapanga safari kwenda mahali ambapo Mungu alimwambia. ");
INSERT INTO swhulb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siku ya tatu Abraham akatazama juu na akaona mahali pakiwa mbali. ");
INSERT INTO swhulb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham akawambia vijana wake, “kaeni hapa pamoja na punda, mimi pamoja na Isaka tutakwenda pale. Tutaabudu na kisha tutarudi hapa penu.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ndipo Abraham akachukua kuni kwa ajili ya sadaka ya kuteketezwa akaziweka juu ya Isaka mwanawe. Mkononi mwake akachukua moto na kisu; na wote wawili wakaondoka pamoja. ");
INSERT INTO swhulb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka akazungumza na Abraham baba yake akisema, “Baba yangu,” naye akasema, “ Ndiyo mwanangu.” Akasema, “Tazama huu ni moto na kuni, lakini yuko wapi mwanakondoo kwa ajili ya sadaka ya kuteketezwa?” ");
INSERT INTO swhulb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham akasema, “Mungu mwenyewe atatupatia mwanakondoo kwa ajili ya sadaka ya kuteketezwa, mwanangu.” Kwa hiyo wakaendelea, wote wawili pamoja. ");
INSERT INTO swhulb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Walipofika mahali ambapo Mungu alikuwa amemwambia, Abraham akajenga madhabahu pale na akaweka kuni juu yake. Kisha akamfunga Isaka mwanawe, na akamlaza juu ya madhabahu, juu ya zile kuni. ");
INSERT INTO swhulb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham akanyoosha mkono wake akachukua kisu ili kumuua mwanawe. ");
INSERT INTO swhulb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ndipo malaika wa Yahwe akamwita kutoka mbinguni na kusema, “Abraham, Abraham!” naye akasema, “Mimi hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Akasema, “usinyooshe mkono wako juu ya kijana, wala usifanye jambo lolote kumdhuru, kwa kuwa sasa najua unamcha Mungu, kwa kuona kuwa hukumzuilia mwanao, mwanao wa pekee, kwa ajili yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham akatazama juu na tazama, nyuma yake kulikuwa na kondoo mume amenaswa pembe zake kichakani. Abraham akaenda akamchukua kondoo na akamtoa kama sadaka ya kuteketezwa badala ya mwanawe. ");
INSERT INTO swhulb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kwa hiyo Abraham akapaita mahali pale, Yahwe atatoa,” na panaitwa hivyo hata leo. “Juu ya mlima wa Yahwe itatolewa.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaika wa Yahwe akamwita Abraham kwa mara ya pili kutoka mbinguni ");
INSERT INTO swhulb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","na kusema - Hiki ni kiapo cha Yahwe, “Kwa ajili ya nafsi yangu nimeapa kwamba kwa kuwa umefanya jambo hili, na hukunizuilia mwanao, mwanao wa pekee, ");
INSERT INTO swhulb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","hakika nitakubariki na nitakuzidishia uzao wako kama nyota za angani, na kama mchanga ulioko kwenye ufukwe wa bahari; na uzao wakowatamiliki lango la adui zao. ");
INSERT INTO swhulb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kupitia uzao wako mataifa yote ya dunia watabarikiwa, kwa sababu umetii sauti yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kwa hiyo Abraham akarejea kwa vijana wake, na wakaondoka wakaenda pamoja Beerisheba, hivyo akakaa Beerisheba. ");
INSERT INTO swhulb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ikawa kwamba baada ya mambo haya ambayo Abraham aliambiwa, “Milka amemzalia pia watoto, ndugu yako Nahori.” ");
INSERT INTO swhulb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Hawa walikuwa ni Usi mzaliwa wa kwanza, Busi ndugu yake, Kemueli aliye mzaa Aramu, ");
INSERT INTO swhulb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Hazo, Pildashi, Yidlafu, na Bethueli. ");
INSERT INTO swhulb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel akamzaa Rebeka. Hawa walikuwa ni wale watoto wanane ambao Milka alizaa kwa Nahori, ndugu yake na Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Suria wake, ambaye aliitwa Reuma, pia akamzaa Teba, Gahamu, Tahashi, na Maaka. ");
INSERT INTO swhulb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara akaishi mika mia moja na ishirini na saba. Hii ndiyo ilikuwa ni miaka ya maisha ya Sara. ");
INSERT INTO swhulb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara akafa katika Kiriathi Arba, ambayo ni Hebroni, katika nchi ya Kanaani. Abraham akaomboleza na kumlilia Sara. ");
INSERT INTO swhulb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kisha Abraham akainuka na kutoka kwa mkewe aliye kufa, akanena na watoto wa kiume wa Hethi, akisema, ");
INSERT INTO swhulb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mimi ni mgeni kati yenu. Tafadhari nipatieni mahali pa kuzikia miongoni mwenu, ili kwamba niweze kuzika wafu wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wana wa Hethi wakamjibu Abraham, wakasema, ");
INSERT INTO swhulb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tusikilize, bwana wangu. Wewe ni mwana wa Mungu miongoni mwetu. Zika wafu wako katika makaburi yetu utakayochagua. Hakuna miongoni mwetu atakaye kuzuilia kaburi lake, kwa ajili ya kuzikia wafu wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham akainuka na kusujudu chini kwa watu wa nchi ile, kwa wana wa Hethi. ");
INSERT INTO swhulb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Akawaambia, akisema, “ikiwa mmekubali mimi kuzika wafu wangu, ndipo nisikilizeni, msihini Efroni mwana wa Sohari kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Mwambieni aniuzie pango la Makpela, ambalo analimiliki, ambalo liko mwishoni mwa shamba lake. Kwa bei kamili aniuzie waziwazi mbele ya watu kama miliki ya kuzikia.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efroni alikuwa ameketi miongoni mwa wana wa Hethi, hivyo Efroni Mhiti akamjibu Abraham alipowasikia wana wa Hethi, wote ambao walikuwa wamekuja langoni mwa mji wake, akasema, ");
INSERT INTO swhulb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hapana, bwana wangu, nisikilize. Ninakupatia shamba na pango ambalo limo ndani yake. Ninakupatia mbele ya wana wa watu wangu. Ninakupatia uzike wafu wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kisha Abraham akasujudu chini mbele ya watu wa nchi ile. ");
INSERT INTO swhulb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Akamwambia Efroni watu wa nchi ile wakisikiliza, akasema, ikiwa uko radhi, tafadhari nisikilize. Nitalipia shamba. Chukua fedha kwangu, na nitazika wafu wangu pale.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni akamjibu Abraham, akisema, ");
INSERT INTO swhulb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tafadhari bwana wangu, nisikilize. Kipande cha ardhi kinathamani ya shekeli mia nne za fedha, na hiyo ni kitu gani kati yangu mimi na wewe? wazike wafu wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham akamsikiliza Efroni na akampimia Efroni kiwango cha fedha alizosema mbele ya wana wa Helthi wakisikiliza, shekeli mia nne za fedha, kwa mujibu wa viwango vya vipimo vya kibiashara. ");
INSERT INTO swhulb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kwa hiyo shamba la Efroni, lililokuwa katika Makpela, mbele ya Mamre, shamba pamoja na pango lililokuwamo ndani yake na miti yote iliyokuwamo ndani ya shamba na iliyokuwa mpakani ikatolewa ");
INSERT INTO swhulb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kwa Abraham kwa njia ya manunuzi mbele ya wana wa Hethi, na mbele ya wote waliokuja malangoni pa mji wake. ");
INSERT INTO swhulb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Baada ya haya, Abraham akamzika Sara mkewe katika pango la shamba la Makpela, lililo mbele ya Mamre, ambayo ni Hebroni, katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kwa hiyo shamba pamoja na pango likatolewa na wana wa Hethi kwa Abraham kama milki na eneo la kuzikia. ");
INSERT INTO swhulb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Basi Abraham alikuwa mzee sana na Yahwe akawa amembariki katika mambo yote. ");
INSERT INTO swhulb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham akamwambia mtumwa wake, ambaye alikuwa mkubwa kuliko wote wa nyumbani mwake na mkuu wa vyote alivyo kuwa navyo.”Weka mkono wako chini ya paja langu ");
INSERT INTO swhulb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","na nitakufanya uape kwa Yahwe, Mungu wa Mbingu na nchi, kwamba hutampatia mwanangu mke kutoka kwa mabinti wa Wakanaani, miongoni mwao wale nikaao kati yao. ");
INSERT INTO swhulb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Lakini utakwenda kwenye nchi yangu, na kwa ndugu zangu, na kumtafutia mwanangu Isaka mke.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yule mtumwa wake akamwambia, “Itakuwaje ikiwa mwanamke hatakuwa tayari kufuatana nami hadi katika nchi hii? Je nitamrudisha mwanao katika nchi ambayo ulitoka?” ");
INSERT INTO swhulb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham akamwambia, “Hakikisha kwamba hutamrudisha mwanangu kule! ");
INSERT INTO swhulb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahwe, Mungu wa mbingu, ambaye alinitoa mimi kutoka katika nyumba ya baba yangu na kutoka katika nchi ya ndugu zangu, na ambaye aliniahidia kwa kiapo maalumu akisema, 'Nitawapa uzao wako nchi hii,' atatuma malaika wake mbele yako, na utapata mke kwa ajili ya mwanangu kutoka huko. ");
INSERT INTO swhulb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Lakini ikiwa mwanamke hatakuwa tayari, ndipo utakuwa huru katika hiki kiapo changu. Cha muhimu tu ni kwamba usije ukamrudisha mwanangu huko.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kwa hiyo mtumwa akaweka mkono wake jini ya paja la Abraham bwana wake, na akaapa kuhusiana na jambo hili. ");
INSERT INTO swhulb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Mtumwa akachukua ngamia kumi wa bwana wake na akaondoka. Akachukua pia aina zote za zawadi kutoka kwa bwana wake. Akaondoka na kwenda katika mkoa wa Aramu Naharaimu, mji wa Nahori. ");
INSERT INTO swhulb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Akawapigisha magoti ngamia nje ya mji karibu na kisima cha maji. Ilikuwa jioni wakati ambao wanawake huenda kuchota maji. ");
INSERT INTO swhulb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kisha akasema, “Yahwe, Mungu wa bwana wangu Abraham, anijalie kufanikiwa leo na aoneshe agano la uaminifu kwa bwana wangu Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tazama, nimesimama hapa karibu na chemchemi ya maji na binti za watu wa mji wanakuja kuteka maji. ");
INSERT INTO swhulb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na itokee hivi kwamba. Nikimwambia msichana, tafadhari tua mtungi wako ili niweze kunywa maji,' na akiniambia, 'Kunywa, na kwamba nitawanywesha ngamia wako pia,' huyo ndiye awe ambaye umemchagulia mtumwa wako Isaka. Kwa njia hii nitajua kuwa umeonesha agano la uaminifu kwa bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ikawa kwamba hata kabla hajamaliza kuzungumza, tazama, Rebeka akaja akiwa na mtungi wake wa maji begani mwake. Rebeka alizaliwa na Bethueli mwana wa Milka, mke wa Nahori, ndugu yake na Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Msichana huyu alikuwa mzuri na alikuwa bikira. Hapana mwanaume aliye kuwa amekwisha lala naye. Akashuka kisimani na kuujaza mtungi wake, na kupanda juu. ");
INSERT INTO swhulb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kisha mtumwa yule akakimbia kumlaki yule msichana, na kusema, “Tafadhari nipatie maji kidogo ya kunywa kutoka katika mtungi wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Akasema, “kunywa tafadhari bwana wangu,” na kwa haraka akatua mtungi wake juu ya mkono wake, na akampatia maji ya kunywa. ");
INSERT INTO swhulb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Alipokuwa amemaliza kumpatia maji, akasema, “Nitachota maji kwa ajili ya ngamia wako pia, mpaka watakapomaliza kunywa.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hivyo akaharakisha akamwaga maji yaliyokuwa mtungini kwenye chombo cha kunywshea mifugo, kisha akakimbia tena kisimani kuchota maji, na kuwanywesha ngamia wake wote. ");
INSERT INTO swhulb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Yule mtu akamtazama msichana akiwa kimya kuona kama Yahwe amefanikisha njia yake au la. ");
INSERT INTO swhulb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamia walipomaliza kunywa maji, yule mtu akaleta pete ya pua ya dhahabu yenye uzito wa nusu shekeli, na bangili mbili za dhahabu kwa ajili ya mikono yake zenye uzito wa shekeli kumi, ");
INSERT INTO swhulb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","akamuuliza, “wewe ni binti wa nani? Niambie tafadhali, Je kuna nafasi nyumbani mwa baba yako kwa ajili yetu kupumzika usiku?” ");
INSERT INTO swhulb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Akamwambia, “Mimi ni binti wa Bethueli mwana wa Milka, ambaye alimzaa kwa Nahori.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Akasema pia, “Tunayo malisho tele na chakula, na iko nafasi kwa ajili yako kulala usiku.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kisha yume mtu akainama chini na kumwabudu Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Akasema, “Abarikiwe Yahwe, Mungu wa bwana wangu Abraham, ambaye hakuacha agano lake la uaminifu na kweli yake mbele ya bwana wangu. Kwa vile Yahwe ameniongoza moja kwa moja kwenye nyumba ya ndugu zake bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kisha yule msichana akakimbia na kwenda kuwaeleza watu wa nyumba ya mama yake juu ya mambo yote haya. ");
INSERT INTO swhulb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Na sasa Rebeka alikuwa na kaka yake, jina lake aliitwa Labani. Labani akakimbia kwa yule mtu aliye kuwa nje barabarani karibu na kisima. ");
INSERT INTO swhulb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Akisha kuona hereni ya puani pamoja na zile bangili kwenye mikono ya dada yake, na kusikia maneno ya Rebeka dada yake, “Hivi ndivyo yule mtu alicho niambia,” alikwenda kwa yule mtu, na, Tazama, alikuwa amesimama karibu na ngamia pale kisimani. ");
INSERT INTO swhulb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani akasema, “Njoo, wewe uliye barikiwa na Yahwe. Kwa nini umesimama nje? nimekwisha andaa nyumba, pamoja na mahali kwa ajili ya ngamia.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kwa hiyo yule mtu akaingia ndani ya nyumba na akashusha mizigo kutoka kwa wale ngamia. Ngamia wakapatiwa malisho na chakula, na maji yakatolewa kuosha miguu yake pamoja na miguu ya wale watu aliokuwa pamoja nao. ");
INSERT INTO swhulb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Wakaandaa chakula mbele yake ale, lakini akasema, “Sitakula mpaka niseme kile ninacho paswa kusema.” Kwa hiyo Labani akmwambia, “Sema.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Akasema, “Mimi ni mtumwa wa Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahwe amembariki sana bwana wangu na amekuwa mtu mkuu. Amempatia mifugo na makundi ya wanyama, fedha, dhahabu, watumwa wa kiume na watumwa wa kike, pamoja na ngamia na punda. ");
INSERT INTO swhulb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mke wa bwana wangu, alimzalia mwana bwana wangu alipokuwa mzee, na amempatia mwanawe kila kitu anachomiliki. ");
INSERT INTO swhulb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bwana wangu aliniapisha, akisema, “Usije ukampatia mwanangu mke kutoka kwa mabinti wa Wakanaani, ambao kwao nimefanya makazi. ");
INSERT INTO swhulb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Badala yake, lazima uende kwa familia ya baba yangu, na kwa ndugu zangu, na kupata mke kwa ajili ya mwanangu.' ");
INSERT INTO swhulb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nikamwambia bwana wangu, pengine mwanamke huyo asikubali kufuatana nami.' ");
INSERT INTO swhulb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Lakini akaniambia, Yahwe, ambaye ninakwenda mbele yake, atatuma malaika wake pamoja nawe na atakufanikisha njia yako, kwamba utapata mke kwa ajili ya mwangu kutoka miongoni mwa ndugu zangu na kutoka katika ukoo wa baba yangu. ");
INSERT INTO swhulb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Lakini utakuwa huru katika kiapo changu ikiwa utafika kwa ndugu zangu na wasikuruhusu kuja naye. Ndipo utakuwa huru katika kiapo changu. ");
INSERT INTO swhulb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Hivyo nimefika leo kisimani, na nikasema, 'O Yahwe, Mungu wa bwana wangu Abraham, tafadhari, ikiwa kweli umekusudia kuifanya safari yangu kuwa yenye kufanikiwa - ");
INSERT INTO swhulb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","tazama niko hapa nimesimama karibu na kisima cha maji - na iwe kwamba binti ajaye kuchota maji, nitakaye mwambia, “Tafadhari unipatie maji kidoka kutoka kwenye mtungi wako ninywe,” mwanamke atakaye niabia, ");
INSERT INTO swhulb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","“Kunywa, na nitakuchotea pia maji kwa ajili ya ngamia wako” - na awe ndiye ambaye wewe Yahwe, umemchagulia mtoto wa bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ikawa hata kabla sijamaliza kuzungumza moyoni mwangu, Tazama, Rebeka akaja na mtungi wake juu ya bega lake akashuka chini kisimani akachota maji. Hivyo nikamwambia, 'Tafadhari nipatie maji ninywe.' ");
INSERT INTO swhulb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ndipo kwa haraka alipoushusha mtungi wake begani mwake na akasema, 'Kunywa, na pia nitawapatia maji ngamia wak.' Kwa hiyo nikanywa, na akawanywesha ngamia pia. ");
INSERT INTO swhulb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nikamuuliza na kusema, 'Wewe ni binti wa nani?' Akasema, 'Binti wa Bethueli, Mwana wa Nahori, ambaye Milka alizaa kwake.' Kisha nikamwekea pete puani mwake pamoja na bangili mikononi mwake. ");
INSERT INTO swhulb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kisha nikainama chini nikamwabudu Yahwe, na kumbariki Yahwe, Mungu wa bwana wangu Abraham, ambaye ameniongoza katika njia sahihi kumpata binti wa ndugu za bwana wangu kwa ajili ya mwanawe. ");
INSERT INTO swhulb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kwa hiyo, ikiwa mko tayari kumfanyia rehema na kweli, niambieni. Lakini kama sivyo, niambieni, ili kwamba niweze kwenda upande wa kulia, au kushoto.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ndipo Labani na Bethueli wakajibu na kusema, “Jambo hili limetoka kwa Yahwe; hatuwezi kusema kwako aidha neno baya au zuri. ");
INSERT INTO swhulb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Tazama, Rebeka yu mbele yako. Mchukue na uende, ili awe mke wa mtoto wa bwana wako, kama Yahwe alivyosema.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mtumwa wa Abraham aliposikia maneno yao, akainama mwenyewe chini ardhini kwa Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mtumwa akaleta vipande vya fedha na vipande vya dhahabu, na nguo, akampatia Rebeka. Akampatia pia kaka yake na mama yake zawadi zenye thamani. ");
INSERT INTO swhulb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kisha yeye na watu aliokuwa nao wakala na kunywa. wakakaa pale mpaka usiku, na walipoamka asubuhi, akasema, Niruhusuni niende kwa bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kaka yake na mama yake wakasema, mwache binti abaki nasi kwa siku chache zingine, angalau siku kumi. baada ya hapo anaweza kwenda.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lakini akawambia, msinizuie, kwa kuwa Yahwe amefanikisha njia yangu. Niruhusuni niende kwa bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wakasema, “Tutamwita binti na kumuuliza.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kwa hiyo wakamwita Rebeka na kumuuliza, “Je utakwenda na mtu huyu?” Akajibu, “Nitakwenda.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kwa hiyo wakampeleka dada yao Rebeka, pamoja na watumishi wake wa kike, kwenda njiani pamoja na mtumishi wa Abraham na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wakambarikia Rebeka, na wakamwambia, “Ndugu yetu, na uwe mama wa maelfu na wa makumi elfu, uzao wako upate kumiliki lango la wale wanao wachukia.” ");
INSERT INTO swhulb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kisha Rebeka akasimama, yeye na watumishi wake kwa hesabu ya ngamia, na wakamfuata yule mtu. Hivyo watumishi wakamchukua Rebeka, na wakaenda zao. ");
INSERT INTO swhulb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nyakati hizo Isaka alikuwa anakaa katika Negebu, na alikuwa tu amerejea kutoka Beerlahairoi. ");
INSERT INTO swhulb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaka akaenda kutafakari shambani jioni. Alipotazama akaona, natazama, kulikuwa na ngamia wakija! ");
INSERT INTO swhulb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka akatazama na alipomwona Isaka, akaruka kutoka kwenye ngamia. ");
INSERT INTO swhulb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Akamwambia mtumwa, “mtu huyo ni nani anaye tembea shambani akija kutupokea?” Mtumwa akasema, “Ni bwana wangu.” Hivyo Rebeka akachukua shela yake akajifunika. ");
INSERT INTO swhulb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mtumwa akamwambia Isaka mambo yote ambayo amefanya. ");
INSERT INTO swhulb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kisha Isaka akamleta katika hema ya Sara mama yake na akamchukua Rebeka, na akawa mke wake, na akampenda. Kwa hiyo Isaka akafarijika baada ya kifo cha mama yake. ");
INSERT INTO swhulb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham akaoa mke mwingine; jina lake aliitwa Ketura. ");
INSERT INTO swhulb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Akamzalia Zimrani, Jokshani, Medani, Midiani, Ishbaki, na Shua. ");
INSERT INTO swhulb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshani akamzaa Sheba na Dedani. Wana wa Dedani walikuwa ni Waashuru, Waletushi, na Waleumi. ");
INSERT INTO swhulb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wana wa Midiani walikuwa ni Efa, Eferi, Hanoki, Abida, na Eldaa. Hawa wote walikuwa ni wana wa Ketura. ");
INSERT INTO swhulb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham akampatia Isaka vitu vyote alivyokuwa navyo. ");
INSERT INTO swhulb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ingawaje, wakati alipokua angali akiishi, aliwapatia zawadi wana wa masuria wake na kuwapeleka katika nchi ya mashariki, mbali na Isaka, mwanae. ");
INSERT INTO swhulb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Hizi ndizo zilikuwa siku za miaka ya uhai wake Abraham alizoishi, miaka 175. ");
INSERT INTO swhulb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham akapumua pumzi ya mwisho na akafa katika uzee mwema, mzee aliye shiba siku, na akakusanywa kwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaka na Ishmaili, wanae wakamzika katika pango la Makipela, katika shamba la Efron mwana wa Soari Mhiti, pango lililokuwa karibu na Mamre. ");
INSERT INTO swhulb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Shamba hili Abraham alilinunua kwa watoto wa Hethi. Abraham akazikwa pale pamoja na Sara mkewe. ");
INSERT INTO swhulb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Baada ya kifo cha Abraham, Mungu akambariki Isaka mwanae, na Isaka akaishi karibu na Beerlalahairoi. ");
INSERT INTO swhulb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Na sasa hawa ndio walikuwa wana wa Ishimaeli, mwana wa Abraham, ambaye Hajiri Mmisri mtumishi wake Sara, alizaa kwa Abraham. ");
INSERT INTO swhulb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Haya ndiyo yalikuwa majina ya wana wa Ishimaeli, kuanzia mzaliwa wa kwanza: Nebayothi - mzaliwa wa kwanza wa Ishimaeli, Kedari, Adbeeli, Mibsamu, ");
INSERT INTO swhulb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO swhulb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yeturi, Nafishi, na Kedema. ");
INSERT INTO swhulb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hawa ndio walikuwa wana wa Ishimaeli, na haya ndiyo majina yao, kwa vijiji vyao, na katika vituo vyao; Maseyidi kumi na wawili kufuatana na kabila zao. ");
INSERT INTO swhulb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hii ndiyo ilikuwa miaka ya Ishimaeli, miaka 137: akapumua pumzi yake ya mwisho na akafa, na akakusanywa pamoja na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Walioshi toka Havila mpaka Shuri, ambayo iko karibu na Misri, kuelekea Ashuru. Waliishi kwa uadui kati yao. ");
INSERT INTO swhulb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Haya ndiyo yalikuwa matukio kumuhusu Isaka, mwana wa Abraham: Abraham alimzaa Isaka. ");
INSERT INTO swhulb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka alikuwa na umri wa miaka arobaini alipomuoa Rebeka, binti wa ethueli Mshami wa Padani Aramu, ndugu wa Labani Mshami. ");
INSERT INTO swhulb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka akamwomba Yahwe kwa ajili ya mke wake kwa sababu alikuwa tasa, na Yahwe akajibu maombi yake, Rebeka mkewe akabeba mimba. ");
INSERT INTO swhulb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Watoto hawa walipokuwa tumboni mwake wakasumbuka, naye akasema, “Kwa nini jambo hili linatokea kwangu mimi?” Akaenda kumuuliza Yahwe kuhusu jambo hili. ");
INSERT INTO swhulb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahwe akamwambia, “Mataifa mawili yako katika tumbo lako, na mataifa haya mawili yatatengana ndani yako. Taifa moja litakuwa lenye nguvu kuliko lingine, na yule mkubwa atamtumikia mdogo. ");
INSERT INTO swhulb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ulipo wadia wakati wa kujifungua, tazama, kulikuwa na mapacha ndani ya tumbo lake. ");
INSERT INTO swhulb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wakwanza akatoka akiwa mwekundu mwili wote kama vazi la nywele. Wakamwita jina lake Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Baada ya hapo ndugu yake akatoka. Mkono wake ukiwa umeshika kisigino cha Esau. Akaitwa jina lake Yakobo. Isaka alikuwa na umri wa miaka sitini wakati mke wake alipo wazaa hawa watoto. ");
INSERT INTO swhulb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Vijana hawa wakakua, Hesau akawa mwindaji hodari, mtu wa nyikani; lakini Yakobo alikuwa mtu mkimya, aliye tumia muda wake akiwa katika mahema. ");
INSERT INTO swhulb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kisha Isaka akampenda Esau kwa sababu alikula wanyama ambao alikuwa anawinda, lakini Rebeka akampenda Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yakobo akapika mchuzi. Esau akaja kutoka nyikani, akiwa dhaifu kutokana na njaa. ");
INSERT INTO swhulb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau akamwambia Yakobo, “Nilishe mchuzi mwekundu. Tafadhari, nimechoka!” Na hii ndiyo sababu jina lake aliitwa Edomu. ");
INSERT INTO swhulb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo akasema, “Kwanza uniuzie haki yako ya mzaliwa wa kwanza.” ");
INSERT INTO swhulb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau akasema, “Tazama, nakaribia kufa. Ni nini kwangu haki ya mzaliwa wa kwanza?” ");
INSERT INTO swhulb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo akasema, “Kwanza uape kwangu mimi,” kwa hiyo Esau akaapa kiapo na kwa njia hii akawa ameuza haki yake ya mzaliwa wa kwanza kwa Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakobo akampatia Esau mkate pamoja na mchuzi wa dengu. Akala na kunywa, kisha akainuka na akaenda zake. Kwa njia hii Esau akawa ameidharau haki yake ya mzaliwa wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Basi njaa ikatokea katika nchi, mbali na njaa ya kwanza iliyotokea siku za Ibrahimu. Isaka akaenda kwa Abimeleki, mfalme wa Wafilisiti huko Gerari. ");
INSERT INTO swhulb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Basi Yahwe akamtokea na kumwambia, “Usishuke kwenda Misri; kaa katika nchi niliyokuambia. ");
INSERT INTO swhulb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kaa katika nchi hii hii niliyokuambia, nami nitakuwa pamoja nawe na kukubariki; kwani kwako wewe na uzao wako, nitawapa nchi hii yote, nami nitatimiza kiapo nilichomwapia Ibrahimu baba yako. ");
INSERT INTO swhulb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nitauzidisha uzao wako kama nyota za mbinguni, nami nitawapa uzao wako nchi hizi zote. Kupitia uzao wako mataifa yote ya dunia yatabarikiwa. ");
INSERT INTO swhulb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nitalifanya hili kwa sababu Ibrahimu aliitii sauti yangu na kutunza maelekezo yangu, amri zangu na sheria zangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hivyo Isaka akakaa Gerari. ");
INSERT INTO swhulb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Watu wa eneo hilo walipomwuliza juu ya mke wake, alisema, “Yeye ni dada yangu.” Aliogopa kusema, “Yeye ni mke wangu,” kwa kuwa alidhani, “Watu wa nchi hii wataniua ili wamchukue Rebeka, kwa kuwa ni mzuri wa uso.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Baada ya Isaka kuwa amekaa pale kwa muda mrefu, Ikatukia kwamba Abimeleki mfalme wa Wafilisiti alichungulia katika dirisha. Tazama, akamwona Isaka akimpapasa Rebeka, mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki akamwita Isaka kwake na kusema, “Tazama, kwa hakika yeye ni mke wako. Kwa nini ulisema, 'Yeye ni dada yangu?” Isaka akamwambia, “Kwa sababu nilidhani mtu mmoja aweza kuniua ili amchukue.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki akamwambia, “Ni jambo gani hili ulilotufanyia? Mmojawapo wa watu angeweza bila shaka kulala na mke wako, nawe ungeweza kuleta hatia juu yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hivyo Abimeleki akawaonya watu wote na kusema, “Mtu yeyote atakayemgusa mtu huyu au mke wake atauwawa.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka akapanda mazao katika nchi hiyo na kuvuna mwaka huo vipimo mia, kwa kuwa Yahwe alimbariki. ");
INSERT INTO swhulb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mtu huyo akawa tajiri, naye akaongezeka zaidi hata akawa mkuu sana. ");
INSERT INTO swhulb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Alikuwa na kondoo na ngombe na familia kubwa. Wafilisiti wakamwonea wivu. ");
INSERT INTO swhulb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Basi visima vyote watumishi wa baba yake walikuwawamevichimba katika siku za Ibrahimu baba yake, Wafilisiti wakavikatalia kwa kwa kuvijaza kifusi. ");
INSERT INTO swhulb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki akamwambia Isaka, “Ondoka kati yetu, kwa kuwa wewe una nguvu kuliko sisi.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hivyo Isaka akaondoka pale na kukaa katika bonde la Gerari, na kuishi pale. ");
INSERT INTO swhulb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kwa mara nyingine tena Isaka akachimba visima vya maji, vilivyokuwa vimechimbwa siku za Ibrahimu baba yake. Wafilisiti walikuwa wamevizuia baada ya kufa kwake Ibrahimu. Isaka akaviita visima kwa majina aliyokuwa ameviita baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Watumishi wa Isaka walipochimba katika bonde, wakaona kisima cha maji yaliyokuwakuwa yakibubujika. ");
INSERT INTO swhulb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Wachungaji wa Gerari wakagombana na wachungaji wa Isaka, na kusema, “Haya ni maji yetu.”Hivyo Isaka akakiita kisima hicho “Eseki,” kwa sababu waligombana naye. ");
INSERT INTO swhulb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Wakachimba kisima kingine, wakakigombania hicho nacho, hivyo akakiita “Sitina.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Akatoka hapo na akachimba kisima kingine, lakini hicho hawakukigombania. Hivyo akakiita Rehobothi, na akasema, “Sasa Yahwe ametufanyia nafasi, na tutafanikiwa katika nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kisha Isaka akaenda Beersheba. ");
INSERT INTO swhulb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yahwe akamtokea usiku huohuo na akasema, “Mimi ni Mungu wa Ibrahimu baba yako. Usiogope, kwa maana mimi nipo pamoja nawe na nitakubariki na kuvidisha vizazi vyako, kwa ajili ya mtumishi wangu Ibrahimu.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka akajenga madhabahu pale na akaliita jina la Yahwe. Akapiga hema yake pale, na watumishi wake wakachimba kisima. ");
INSERT INTO swhulb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kisha Abimeleki akamwendea kutoka Gerari, pamoja na Ahuzathi, rafiki yake, na Fikoli, jemedari wa jeshi. ");
INSERT INTO swhulb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka akawambia, “Kwa nini mmekuja kwangu, kwani mlinichukia na kunifukuza kwenu. ");
INSERT INTO swhulb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nao wakasema, “Tumeona yakini kwamba Yahwe amekuwa nawe. Hivyo tukaamua kwamba kuwe na kiapo kati yetu, ndiyo, kati yetu nawe. Hivyo na tufanye agano nawe, ");
INSERT INTO swhulb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kwamba hautatudhuru, kama ambavyo sisi hatukukudhuru, na kama sisi tulivyokutendea vema wewe na tumekuacha uondoke kwa amani. Kwa kweli, Yahwe amekubariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hivyo Isaka akawaandalia sherehe, na wakala na kunywa. ");
INSERT INTO swhulb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wakaamuka mapema asubuhi na wakaapiana kiapo. Kisha Isaka akawaruhusu kuondoka, nao wakamwacha katika amani. ");
INSERT INTO swhulb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siku hiyohiyo watumishi wake wakaja na kumwambia juu ya kisima walichokuwa wamekichimba. Wakasema, “Tumeona maji.” ");
INSERT INTO swhulb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Akakiita kile kisima Shiba, hivyo jina la mji ule ni Beersheba hata leo. ");
INSERT INTO swhulb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau alipokuwa na umri wa miaka arobaini, akajitwalia mke, Yudithi binti Beeri Mhiti, na Basemathi binti Eloni Mhiti. ");
INSERT INTO swhulb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wakamhuzunisha Isaka na Rebeka. ");
INSERT INTO swhulb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka alipozeeka na macho yake kuwa mazito kiasi cha kutokuona, alimwita Esau, mwanawe mkubwa, na akamwambia, “Mwanangu. Yeye akasema, “Mimi hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Akamwambia, “Tazama, mimi nimezeeka. Sijui siku ya kufa kwangu. ");
INSERT INTO swhulb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kwahiyo chukua silaha zako, podo lako na upinde wako, na uende uwandani ukaniwindie mnyama. ");
INSERT INTO swhulb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Uniandalie chakula kitamu, aina ile niipendayo, uniletee ili nikile na kukubariki kabla sijafa. ");
INSERT INTO swhulb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Basi Rebeka akasikia Isaka alipoongea na Esau mwanawe. Esau akaenda uwandani kuwinda mawindo na kuja nayo. ");
INSERT INTO swhulb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka akaongea na Yakobo mwanawe na kumwambia, “Tazama, nimemsikia baba yako akiongea na Esau ndugu yako. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Niletee mnyama na unitengenezee chakula kitamu, ili nikile na kukubariki mbele za Yahwe kabla ya kufa kwangu.' ");
INSERT INTO swhulb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kwa hiyo sasa, mwanangu, usikilize sauti yangu kama ninavyokuagiza, ");
INSERT INTO swhulb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nenda kundini, na uniletee wanambuzi wawili; nami nitaandaa chakula kitamu kutokana nao kwa ajili ya baba yako, kwa namna aipendayo. ");
INSERT INTO swhulb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Utakipeleka kwa baba yako, ili kwamba akile, na kukubariki kabla hajafa.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobo akamwambia Rebeka mama yake, “Tazama, Ndugu yangu Esau ni mtu mwenye manyoya, na mimi ni mtu laini. ");
INSERT INTO swhulb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pengine baba yangu atanigusa, nami nitaonekana kama mdanganyifu kwake. Nami nitajiletea laana badala ya baraka.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mama yake akamwambia, “Mwanangu, acha laana yoyote iwe juu yangu. Wewe sikiliza sauti yangu, nenda, uniletee.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Hivyo Yakobo alikwenda na kuchukua wanambuzi na kuwaleta kwa mama yake, na mama yake akaandaa chakula kitamu, kama alichokipenda baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka akachukua nguo nzuri za Esau, mwanawe mkubwa, alizokuwa nazo nyumbani mwake, na akamvika Yakobo, mwanawe mdogo. ");
INSERT INTO swhulb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Akamvalisha ngozi ya mwanambuzi katika mikono yake na katika sehemu laini za shingo yake. ");
INSERT INTO swhulb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Akaweka katika mikono ya Yakobo kile chakula kitamu na mkate aliokuwa ameuandaa. ");
INSERT INTO swhulb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobo akaenda kwa baba yake na kumwambia, “Babangu.” Yeye akasema, “Mimi hapa; U nani wewe, mwanangu?” ");
INSERT INTO swhulb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo akamwambia baba yake, “Mimi ni Esau mzaliwa wako wa kwanza; nimefanya kama ulivyoniagiza. Basi kaa na ule sehemu ya mawindo yangu, ili unibariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka akamwambia mwanawe, “Imekuwaje umepata kwa haraka hivyo, mwanangu?” Akasema, “Ni kwa sababu Yahwe Mungu wako ameniletea.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaka akamwambia Yakobo, “Njoo karibu nami, ili nikuguse, mwanangu, ili nijue kama kweli wewe ni mwanangu Esau au hapana.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo akamkaribia Isaka baba yake; na Isaka akamgusa na kusema, “Sauti ni sauti ya Yakobo, lakini mikono ni mkikono ya Esau.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaka hakumtambua, kwa sababu mikono yake ilikuwa na manyoya, kama mikono ya Esau ndugu yake, hivyo Isaka akambariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Akasema, “Wewe kweli ni mwanangu Esau?” Naye akasema, “Ni mimi.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaka akasema, “Kilete chakula kwangu, na nile mawindo yako, ili nikubariki.” Yakobo akakileta chakula kwake. Isaka akala, na Yakobo akamletea mvinyo, akanywa. ");
INSERT INTO swhulb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kisha Isaka baba yake akamwambia, “Sogea karibu nami na unibusu, mwanangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobo akasogea na kumbusu, naye akanusa harufu ya nguo zake na kumbariki. Akasema, “Tazama, harufu ya mwanangu ni kama harufu ya shamba alilolibariki Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mungu akupe sehemu ya umande wa mbinguni, sehemu ya unono wa nchi, na wingi wa nafaka na mvinyo mpya. ");
INSERT INTO swhulb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Watu na wakutumikie na mataifa yainame chini yako. Uwe bwana juu ya ndugu zako, na wana wa mama yako wainame chini yako. Kila anayekulaani na alaaniwe; na kila anayekubariki abarikiwe.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mara Isaka alipomaliza kumbariki Yakobo, na Yakobo ndo ametoka mbele ya Isaka baba yake, Esau ndugu yake akaja kutoka kuwinda. ");
INSERT INTO swhulb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Yeye pia akaandaa chakula kitamu na kukileta kwa baba yake. Akamwambia baba yake, “Baba, inuka na ule baadhi ya mawindo ya mwanao, ili uweze kunibariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka baba yake akamwambia, “U nani wewe? Akasema, “Mimi ni mwanao, Esau, mzaliwa wako wa kwanza.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka akatetemeka sana na kusema, “Alikuwa nani aliyewinda mawindo nakuniletea? Nilikula chote kabla haujaja, nami nimembariki. Atabarikiwa, kwa kweli.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau aliposikia maneno ya baba yake, akalia kwa kilio kikubwa na cha uchungu sana, na akamwambia baba yake, “Unibariki nami, mimi pia, babangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaka akasema, “Ndugu yako alikuja hapa kwa hila na amechukua baraka yako.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau akasema, “Je hakuitwa Yakobo kwa haki? Kwa maana amenidanganya mara mbili hizi. Alichukua haki ya uzaliwa wangu wa kwanza, na tazama, sasa amechukua baraka yangu.” Na akasema, “Je haukuniachia baraka? ");
INSERT INTO swhulb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka akajibu na kumwambia Esau, “Tazama, nimemfanya kuwa bwana wako, na nimempa ndugu zake kuwa watumishi wake. Na nimempa nafaka na divai. Je nikufanyie nini mwanangu? ");
INSERT INTO swhulb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau akamwambia babaye, “Je hauna hata baraka moja kwa ajili yangu, babangu? Nibariki nami, hata mimi pia, babangu.” Esau akalia kwa sauti. ");
INSERT INTO swhulb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaka baba yake akajibu na kumwambia, “Tazama, mahali unapoishi patakuwa mbali na utajiri wa nchi, mbali na umande juu angani. ");
INSERT INTO swhulb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kwa upanga wako utaishi, nawe utamtumikia ndugu yako. lakini utakapoasi, utaiondoa nira yake shingoni mwako.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau akamchukia Yakobo kwa sababu ya baraka ambayo baba yake alimpa. Esau akajisemea moyoni, “Siku za maombolezo kwa ajili ya baba yangu zinakaribia; baada ya hapo nitamwua Yakobo ndugu yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka akaambiwa maneno ya Esau mwanawe mkubwa. Hivyo akatuma na kumwita Yakobo mwanawe mdogo na kumwambia, “Tazama, Esau ndugu yako anajifariji juu yako kwa kupanga kukuuwa. ");
INSERT INTO swhulb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kwa hiyo sasa, mwanangu, unisikie na kukimbilia kwa Labani, ndugu yangu, huko Harani. ");
INSERT INTO swhulb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ukae naye kitambo, mpaka hasira ya ndugu yako itakapopungua, ");
INSERT INTO swhulb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","hata hasira ya ndugu yako itakapokuondokea, na kusahau ulivyomtenda. Kisha nitatuma na kukurudisha kutoka pale. Kwa nini niwapoteze ninyi nyote katika siku moja? ");
INSERT INTO swhulb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka akamwambia Isaka, “Nimechoka na maisha kwa sababu ya hawa binti za Hethi. Ikiwa Yakobo atachukua mmojawapo wa binti wa Hethi kuwa mkewe, kama wanawake hawa, baadhi ya binti za nchi, maisha yatakuwa na maana gani kwangu?” ");
INSERT INTO swhulb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaka akamwita Yakobo, akambariki, na kumwagiza, “Usichukuwe mwanamke katika wanawake wa Kikanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Inuka, nenda Padani Aramu, katika nyumba ya Bethueli baba wa mama yako, na uchukue mwanamke pale, mmojawapo wa binti za Labani, kaka wa mama yako. ");
INSERT INTO swhulb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mungu Mwenyezi na akubariki, akupe uzao na akuzidishe, hata uwe wingi wa watu. ");
INSERT INTO swhulb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Na akupe baraka ya Ibrahimu, wewe, na uzao wako baada yako, kwamba uweze kumilki nchi ambapo umekuwa ukiishi, ambayo Mungu alimpa Ibrahimu.” ");
INSERT INTO swhulb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Hivyo Isaka akamwondoa Yakobo. Yakobo akaenda Padani Aramu, kwa Labani mwana wa Bethueli Mwaramu, kaka wa Rebeka, mama yao Yakobo na Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Basi Esau alipoona kwamba Isaka amembariki Yakobo na kumpeleka Padani Aramu, kuchukua mke kutoka pale. Lakini pia akaona kwamba Isaka alikuwa amembariki na kumwagiza, akisema, “Usichukue mke katika wanawake wa Kanaani.” ");
INSERT INTO swhulb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau pia akaona kwamba Yakobo alikuwa amemtii baba yake na mama yake, na alikuwa amekwenda Padani Aramu. ");
INSERT INTO swhulb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau akaona kwamba wanawake wa Kanaani hawakumpendeza Isaka baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hivyo akaenda kwa Ishmaeli, na kuchukua, mbali na wake aliokuwa nao, Mahalathi binti Ishmaeli, mwana wa Ibrahimu, dada wa Nebayothi, kuwa mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo akatoka Beersheba na akaelekea Harani. ");
INSERT INTO swhulb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Akaja mahali fulani na akakaa pale usiku kucha, kwa kuwa jua lilikuwa limekuchwa. Akachukua mojawapo ya mawe katika eneo hilo, akaliweka chini ya kichwa chake, na akalala usingizi katika eneo hilo. ");
INSERT INTO swhulb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akaota na kuona ngazi imewekwa juu ya nchi. Ncha yake ilifika hata mbinguni na malaika wa Mungu walikuwa wakishuka na kupanda juu yake. ");
INSERT INTO swhulb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tazama, Yahwe amesimama juu yake na kusema, “Mimi ni Yahwe, Mungu wa Ibrahimu baba yako, na Mungu wa Isaka. Nchi uliyolala juu yake, nitakupa wewe na uzao wako. ");
INSERT INTO swhulb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Uzao wako utakuwa kama mavumbi ya ardhi, na utaenea mbali kuelekea magharibi, mashariki, kaskazini, na kusini. Kupitia kwako na kupitia uzao wako familia zote za dunia zitabarikiwa. ");
INSERT INTO swhulb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tazama, mimi nipo nawe, na nitakulinda kila uendako, Nitakurudisha katika nchi hii tena; kwani sitakuacha. Nitafanya kila nililokuahidi.” ");
INSERT INTO swhulb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo akaamka katika usingizi, na akasema, “Hakika Yahwe yupo mahali hapa, sikujua hili.” ");
INSERT INTO swhulb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Akaogopa na kusema, “Eneo hili linatisha kama nini! Hili sio kingine zaidi ya nyumba ya Mungu. Hili ni lango la mbinguni.” ");
INSERT INTO swhulb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakobo akaamka mapema asubuhi na akachukua jiwe alilokuwa ameliweka chini ya kichwa chake. Akaliweka kama nguzo na kumimina mafuta juu yake. ");
INSERT INTO swhulb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Akapaita pale Betheli, lakini jina la kawaida la mji lilikuwa Luzu. ");
INSERT INTO swhulb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakobo akatoa nadhiri, kusema, “Ikiwa Mungu atakuwa nami na atanilinda katika njia nipitayo, na atanipa mkate wa kula, na mavazi ya kuvaa, ");
INSERT INTO swhulb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","hata nikarudi salama katika nyumba ya baba yangu, ndipo Yahwe atakapokuwa Mungu wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kisha jiwe hili nililoliweka kama nguzo litakuwa jiwe takatifu. Kutoka katika kila utakachonipa, kwa hakika nitakupa tena sehemu ya kumi.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kisha Yakobo akaendelea na safari yake na akafika katika nchi ya watu wa mashariki. ");
INSERT INTO swhulb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Hata alipotazama, akaona kisima kondeni, na, tazama, makundi matatu ya kondoo yalikuwa yamelala kando yake. Kwani kutoka katika hicho wangeyanywesha makundi, na jiwe juu ya mdomo wa kisima lilikuwa kubwa. ");
INSERT INTO swhulb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wakati makundi yote yangekusanyika pale, wachungaji wangevingirisha jiwe kutoka katika mdomo wa kisima na kuwanywesha kondoo, na kisha kurudisha jiwe juu ya mdomo wa kisima, mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo akawambia, “Ndugu zangu, ninyi mnatokea wapi?” nao wakasema, “Tunatoka Harani.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Akawambia, “Mnamfahamu Labani mwana wa Nahori?” Wakasema, “Tunamfahamu.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Akawambia, “Je hajambo?” Wakasema, “Hajambo, na, tazama pale, Raheli binti yake anakuja na kondoo.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo akasema, “Tazama, ni mchana. Siyo wakati wa kukusanya kondoo pamoja. Mnapaswa kuwanywesha kondoo na kisha mkaenda na kuwaacha wachunge.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Wakamwambia, “Hatuwezi kuwanywesha mpaka makundi yote yakusanyike pamoja. Ndipo wanaume watakapovingirisha jiwe kutoka mlangoni mwa kisima, na ndipo tutakapowanywesha kondoo.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wakati bado Yakobo anaongea nao, Raheli akaja pamoja na kondoo wa babaye, kwani alikuwa akiwachunga. ");
INSERT INTO swhulb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo alipomwona Raheli, binti wa Labani, kaka wa mamaye, na kondoo wa Labani, kaka wa mama yake, Yakobo akaja juu, akalivingirisha jiwe kutoka mlangoni mwa kisima, na akawanywesha kondoo wa Labani, kaka wa mama yake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakobo akambusu Raheli na akalia kwa sauti. ");
INSERT INTO swhulb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo akamwambia Raheli kwamba alikuwa ni ndugu wa baba yake, na kwamba alikuwa mwana wa Rebeka. Kisha yeye akakimbia kumwambia baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani aliposikia habari kuhusu Yakobo mwana wa dada yake, akaenda kukutana naye, akamkumbatia, akambusu, na kumleta nyumbani kwake. Yakobo akamwambia Labani mambo haya yote. ");
INSERT INTO swhulb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani akamwambia, “Kwa hakika wewe ni mfupa wangu na nyama yangu.” Kisha Yakobo akakaa naye kama mwezi mmoja. ");
INSERT INTO swhulb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kisha Labani akamwambia Yakobo, “Je unitumikie bure kwa kuwa wewe ni ndugu yangu? Niambie, ujira wako utakuwaje? ");
INSERT INTO swhulb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Basi Labani alikuwa na binti wawili. Jina la mkubwa lilikuwa ni Lea, na jina la mdogo lilikuwa Raheli. ");
INSERT INTO swhulb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Macho ya Lea yalikuwa dhaifu, lakini Raheli alikuwa mzuri wa umbo na mwonekano. ");
INSERT INTO swhulb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo alimpenda Raheli, hivyo akasema, “Nitakutumikia miaka saba kwa ajili ya Raheli, binti yako mdogo.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani akasema, Itakuwa vema kukupa wewe, kuliko kumpa mtu mwingine. Kaa nami.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hivyo Yakobo akamtumikia kwa miaka saba kwa ajili ya Raheli; nayo ilionekana kwake kama siku chache tu, kwa ajili ya upendo aliokuwa nao kwake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kisha Yakobo akamwambia Labani, “Nipe mke wangu, kwani siku zangu zimetimia - ili kwamba nimwoe! ");
INSERT INTO swhulb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hivyo Labani akawaalika watu wa mahali hapo na kuandaa sherehe. ");
INSERT INTO swhulb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Wakati wa jioni, Labani akamchukua Lea binti yake mkubwa na kumleta kwa Yakobo, aliyelala naye. ");
INSERT INTO swhulb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani akampa mtumishi wake wakike Zilpa kuwa mjakazi wa Lea. ");
INSERT INTO swhulb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ilipofika asubuhi, tazama, kumbe ni Lea! Yakobo akamwambia Labani, “Ni nini hiki ulichonifanyia? Je sikukutumikia kwa ajili ya Raheli? Kwa nini basi umenihadaa? ");
INSERT INTO swhulb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani akamwambia, “Siyo utamaduni wetu kumtoa bindi mdogo kabla ya mzaliwa wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Timiza juma la bibi arusi, na tutakupa yule mwingine pia kwa mbadala wa kunitumikia miaka mingine saba.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo akafanya hivyo, na akatimiza juma la Lea. Kisha Labani akampa Raheli binti yake kuwa mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lakini pia Labani akampa Raheli binti yake Bilha, kuwa mjakazi wake. ");
INSERT INTO swhulb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hivyo Yakobo akalala na Raheli, pia, lakini akampenda Raheli zaidi ya Lea. Hivyo Yakobo akamtumikia Labani kwa miaka saba mingine. ");
INSERT INTO swhulb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahwe akaona kwamba Lea hakupendwa, hivyo akalifungua tumbo lake, lakini Raheli hakuwa na mtoto. ");
INSERT INTO swhulb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea akashika mimba na kuzaa mwana, naye akamwita Rubeni. Kwani alisema, “Kwa sababu Yahwe ameliangalia teso langu; bila shaka mme wangu sasa atanipenda.” ");
INSERT INTO swhulb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kisha akashika mimba tena na kuzaa mwana. Akasema, “Kwa sababu Yahwe amesikia kwamba sipendwi, kwa hiyo amenipa mwana mwingine,” na akamwita Simoni. ");
INSERT INTO swhulb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kisha akashika mimba tena na kuzaa mwana. Akasema, “Wakati huu mme wangu ataungana nami, kwa kuwa nimemzalia wana watatu.” Kwa hiyo akaitwa Lawi. ");
INSERT INTO swhulb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Akashika mimba tena na kuzaa mwana. Akasema, “Wakati huu nitamsifu Yahwe.” Kwa hiyo akamwita jina lake Yuda; kisha akaacha kuzaa watoto. ");
INSERT INTO swhulb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raheli alipoona kwamba hamzalii Yakobo watoto, Raheli akamwonea wivu dada yake. Akamwambia Yakobo, “Nipe watoto, sivyo nitakufa.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Hasira ya Yakobo ikawaka juu ya Raheli. Akasema, “Mimi ni badala ya Mungu, aliyekuzuilia usipate watoto? ");
INSERT INTO swhulb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Akasema, “Tazama, kuna mjakazi wangu Bilha. Lala naye, hivyo aweze kuzaa watoto magotini pangu, nami nitapata watoto kwake. ");
INSERT INTO swhulb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hivyo akampa Bilha mjakazi kama mke wake, na Yakobo akalala naye. ");
INSERT INTO swhulb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha akashika mimba na kumzalia Yakobo mwana. ");
INSERT INTO swhulb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kisha Raheli akasema, “Mungu ameamua kwa faida yangu. Ameyasikiliza maombi yangu na kunipa mwana.” Kwa sababu hiyo akamwita jina lake Dani ");
INSERT INTO swhulb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, mjakazi wa Raheli, akashika mimba tena na kumzalia Yakobo mwana wa pili. ");
INSERT INTO swhulb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raheli akasema, “Kwa mashindano yenye nguvu nimeshindana na dada yangu na kushinda.” Akamwita jina lake Naftali. ");
INSERT INTO swhulb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea alipoona kwamba ameacha kuzaa, akamchukua Zilpa, mjakazi wake, na kumpa Yakobo kama mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, mjakazi wa Lea, akamzalia Yakobo mwana. ");
INSERT INTO swhulb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea akasema, “Hii ni bahati njema!” Hivyo akamwita jina lake Gadi. ");
INSERT INTO swhulb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kisha Zilpa, mjakazi wa Lea, akamzalia Yakobo mwana wa pili. ");
INSERT INTO swhulb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea akasema, “Nina furaha! Kwa maana mabinti wataniita furaha.” Hivyo akamwita jina lake Asheri. ");
INSERT INTO swhulb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Siku za mavuno ya ngano Rubeni akaenda shambani na kuona tunguja. Akazileta kwa mama yake. Kisha Raheli akamwambia Lea, “Nipe baadhi ya tunguja za mwanao.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea akamwambia, “Je ni jambo dogo kwako, kumchukua mme wangu? Je na sasa unataka kuchukua tunguja za mwanangu pia? Raheli akasema, “Kisha atalala nawe leo usiku, kwa kubadilishana na tunguja za mwanao. ");
INSERT INTO swhulb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jioni Yakobo akaja kutoka uwandani. Lea akaenda kumlaki na kusema, “Leo usiku utalala nami, kwani nimekuajiri kwa tunguja za mwanangu.” Hivyo Yakobo akalala na Lea usiku huo. ");
INSERT INTO swhulb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mungu akamsikia Lea, na akashika mimba na kumzalia Yakobo mwana wa tano. ");
INSERT INTO swhulb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea akasema, “Mungu amenipa ujira wangu, kwa sababu nilimpa mme wangu mjakazi wangu.” Akamwita jina lake Isakari. ");
INSERT INTO swhulb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea akashika mimba tena na kuzaa mwana wa tano kwa Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea akasema, “Mungu amenipa zawadi njema. Sasa mme wangu ataniheshimu, kwa sababu nimemzalia wana sita.” Akamwita jina lake Zabuloni. ");
INSERT INTO swhulb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Baadaye akazaa binti na kumwita jina lake Dina. ");
INSERT INTO swhulb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mungu akamkumbuka Raheli na kumsikiliza. Akampa kushika mimba. ");
INSERT INTO swhulb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Akashika mimba na kuzaa mwana. Akasema, “Mungu ameiondoa aibu yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Akamwita jina lake Yusufu, akisema, Yahwe ameniongeza mwana mwingine.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Baada ya Raheli kumzaa Yusufu, Yakobo akamwambia Labani, “Niache niande, ili kwamba niende nyumbani kwetu na katika nchi yangu. ");
INSERT INTO swhulb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nipe wake zangu na watoto wangu niliokutumikia kwa ajili yao, na uniache niondoke, kwani unafahamu nilivyokutumikia. ");
INSERT INTO swhulb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani akamwambia, “Ikiwa nimepata kibali machoni pako, subiri, kwa sababu nimejifunza kwa kutumia uaguzi kwamba Yahwe amenibariki kwa ajili yako.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kisha akasema, “Taja ujira wako, nami nitalipa.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo akamwambia, “Unajua nilivyokutumikia, na jinsi ambavyo mifugo wako wamekuwa nami. ");
INSERT INTO swhulb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kwani walikuwa wachache kabla sijaja, na wameongezeka kwa wingi. Popote nilipokutumikia Mungu amekubariki. Je ni lini mimi nitaandaa kwa ajili ya nyumba yangu pia?” ");
INSERT INTO swhulb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hivyo Labani akasema, “Je nikulipe nini? Yakobo akasema, 'Usinipe chochote. Ikiwa utafanya jambo hili kwa ajili yangu, nitawalisha tena kondoo wako na kuwatunza. ");
INSERT INTO swhulb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Niache nipite kati ya kundi lako lote leo, kwa kuondoa kila kondoo mwenye milia na mabaka, na kila kondoo mweusi kati yao, na kati ya wenye mabaka na milia katika mbuzi. Hawa watakuwa ujira wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Uadilifu wangu utashuhudia kwa ajili yangu hapo baadaye, utakapokuja kuangalia ujira wangu. Kila ambaye hana milia na hana madoa miongoni mwa mbuzi, na mweusi kati ya kondoo, ikiwa wataonekana kwangu, watahesabiwa kuwa wameibwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani akasema, “Nakubali. Na iwe kama yalivyo maneno yako.” ");
INSERT INTO swhulb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Siku hiyo Labani akaondoa mabeberu yaliyokuwa na milia na madoa, na majike ya mbuzi yaliyokuwa na milia na madoa, kila aliyekuwa mweupe, na weusi wote katika mbuzi, akawakabidhi katika mikono ya wanaye. ");
INSERT INTO swhulb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Pia Labani akaweka safari ya siku tatu kati yake na Yakobo. Hivyo Yakobo akabaki kuchunga wale kondoo wa Labani waliosalia. ");
INSERT INTO swhulb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobo akachukua matawi mabichi yaliyokatwa ya mipopla, mlozi na mwaramoni mbichi akatoa maganda ili michilizi myeupe ionekane, na akaifanya sehemu nyeupe ya ndani ya mti iliyokuwa ndani ya fito ionekane. ");
INSERT INTO swhulb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kisha akaziweka fito alizokuwa amezibambua mbele ya makundi ya kondoo, mbele ya mabirika yakunyweshea walipokuja kunywa maji. Wakashika mimba walipokuja kunywa maji. ");
INSERT INTO swhulb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wanyama wakapandana mbele ya fito; nao wakazaa watoto wenye milia, mabaka na wenye madoa. ");
INSERT INTO swhulb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo akawatenga hawa wanakondoo, lakini akawafanya waliosalia kuelekea wanyama wenye milia na kondoo weusi wote katika kundi la Labani. Kisha akayatenga makundi yake mwenyewe pekee na hakuwaweka pamoja na wale wa Labani. ");
INSERT INTO swhulb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Pindi kondoo wenye nguvu katika kundi walipopandana, Yakobo alilaza fito katika mabirika ya maji mbele ya macho ya kundi, ili kwamba washike mimba kati ya fito. ");
INSERT INTO swhulb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lakini wakati waliodhaifu walipokuja, hakuweka fito mbele yao. Hivyo wanyama dhaifu wakawa wa Labani, na wenye nguvu wakawa wa Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mtu huyo akastawi sana. Akawa na kundi kubwa la kondoo, wajakazi na wajoli, ngamia na punda. ");
INSERT INTO swhulb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Basi Yakobo akasikia maneno ya wana wa Labani, wakisema, “Yakobo amechukuwa yote yaliyokuwa ya baba yetu, na ni kutoka katika mali ya baba yetu amepata utajiri wake.” ");
INSERT INTO swhulb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo akaona mwonekano katika uso wa Labani. Akaona kwamba nia yake imebadilika. ");
INSERT INTO swhulb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kisha Yahwe akamwambia Yakobo, “Rudi katika nchi ya baba zako na ya ndugu zako, nami nitakuwa nawe.” ");
INSERT INTO swhulb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakobo akatuma kuwaita Raheli na Lea uwandani katika kundi lake la kondoo ");
INSERT INTO swhulb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","naye akawambia, “Naona nia ya baba yenu kwangu imebadilika, lakini Mungu wa baba yangu amekuwa nami. ");
INSERT INTO swhulb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nanyi mnajua kwamba ni kwa nguvu zangu zote nimemtumikia baba yenu. ");
INSERT INTO swhulb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Baba yenu amenidanganya na amebadilisha ujira wangu mara kumi, lakini Mungu hakumruhusu kunidhuru. ");
INSERT INTO swhulb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ikiwa alisema, 'Wanyama wenye mabaka watakuwa ujira wako,' ndipo kondoo wote walipozaa watoto wenye mabaka. Na aliposema, wenye milia watakuwa ujira wako,' ndipo kundi lote lilipozaa watoto wenye milia. ");
INSERT INTO swhulb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kwa njia hii Mungu amemnyang'anya mifugo baba yenu na kunipa mimi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Wakati fulani wa majira ya kupandana, niliona katika ndoto mabeberu yaliyowapanda kundi. Mabeberu yalikuwa ya milia, mabaka na madoa. ");
INSERT INTO swhulb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika wa Mungu akaniambia katika ndoto, 'Yakobo.' Nikasema, 'Mimi hapa.' ");
INSERT INTO swhulb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Akasema, 'Inua macho yako uone mabeberu wanaolipanda kundi. Wana milia, madoa na na mabaka, kwani nimeona kila jambo Labani analokutendea. ");
INSERT INTO swhulb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mimi ni Mungu wa Betheli, mahali ulipoitia nguzo mafuta, mahali uliponitolea nadhiri. Basi sasa inuka na uondoke katika nchi hii na kurudi katika nchi uliyozaliwa. ");
INSERT INTO swhulb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raheli na Lea wakajibu na kumwambia, “Je kuna sehemu yoyote au urithi wetu katika nyumba ya baba yetu? ");
INSERT INTO swhulb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Je hatutendei kama wageni? Kwa maana ametuuza na kwa ujumla ametapanya pesa zetu. ");
INSERT INTO swhulb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mali zote ambazo sasa Mungu amemnyang'anya baba yetu ni zetu na watoto wetu. Sasa basi, lolote Mungu alilokuambia, fanya. ");
INSERT INTO swhulb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kisha Yakobo akainuka na kuwapandisha wanawe na wakeze kwenye ngamia. ");
INSERT INTO swhulb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Akawaongoza mifugo wake wote mbele yake, pamoja na mali zake zote, wakiwemo wanyama aliowapata huko Padani Aramu. Kisha akaenda kuelekea kwa Isaka baba yake katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani alipokuwa amekwenda kuwakata manyoya kondoo wake, Raheli akaiba miungu ya nyumba ya baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo pia akamdanganya Labani Mwarami, kwa kutomtaarifu kwamba anaondoka. ");
INSERT INTO swhulb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Hivyo akaondoka na vyote alivyokuwa navyo na kwa haraka akavuka mto, na akaenda kuelekea nchi ya vilima ya Gileadi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Siku ya tatu Labani akaambiwa kwamba Yakobo amekimbia. ");
INSERT INTO swhulb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Hivyo akawachukua ndugu zake pamoja naye na kumfuatia kwa safari ya siku saba. Akampata katika nchi ya vilima ya Gileadi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Basi Mungu akaja kwa Labani Mwarami katika ndoto usiku na kumwambia, “Ujiadhari kumwambia Yakobo jambo lolote liwe jema au baya.” ");
INSERT INTO swhulb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani akampata Yakobo. Basi Yakobo alikuwa amepiga hema yake katika nchi ya vilima. Labani pia akapiga kambi pamoja na ndugu zake katika nchi ya kilima ya Gileadi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani akamwambia Yakobo, “Umefanya nini, kwamba umewachukua binti zangu kama mateka wa vita? ");
INSERT INTO swhulb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kwa nini umekimbia kwa siri na kunihadaa kwa kutokuniambia? Ningekuruhusu uondoke kwa sherehe na kwa nyimbo, kwa matari na vinubi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Haukuniacha niwabusu wajukuu wangu na binti zangu kwa kuwaaga. Basi umefanya upumbavu. ");
INSERT INTO swhulb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Iko katika uwezo wangu kukudhuru, lakini Mungu wa baba yako alisema nami usiku wa leo na kuniambia, 'Jiadhari usimwambie Yakobo neno la heri wala shari.' ");
INSERT INTO swhulb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Na sasa, umeondoka kwa sababu umeitamani sana nyumba ya baba yako. Lakini kwa nini umeiba miungu yangu? ");
INSERT INTO swhulb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo akajibu na kumwambia Labani, “Ni kwa sababu niliogopa na kudhani kuwa ungeninyang'anya binti zako kwa nguvu ndiyo maana nikaondoka kwa siri. ");
INSERT INTO swhulb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yeyote aliyeiiba miungu yako hataendelea kuishi. Mbele ya ndugu zetu, onesha chochote kilichochako nilichonacho na uchukue.” Kwa maana Yakobo hakujua kwamba Raheli alikuwa ameviiba. ");
INSERT INTO swhulb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani akaingia katika hema ya Yakobo, katika hema ya Lea, na katika hema za wale wajakazi wawili, lakini hakuviona. Akatoka katika hema ya Lea na kuingia katika hema ya Raheli. ");
INSERT INTO swhulb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Basi Raheli alikuwa ameichukua miungu ya nyumbani, na kuiweka katika ngozi ya ngamia, na kukaa juu yake. Labani akatafuta katika hema yote, lakini hakuiona. ");
INSERT INTO swhulb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Akamwambia baba yake, “Usikasirike, bwana wangu, kwamba siwezi kusimama mbele yako, kwani nipo katika kipindi changu.” Hivyo akatafuta lakini hakuiona miungu ya nyumbani mwake. ");
INSERT INTO swhulb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo akakasirika na kuojiana na Labani. Akamwambia, “Kosa langu ni nini? Dhambi yangu ni ipi, hata ukanifuatia kwa ukali? ");
INSERT INTO swhulb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kwa maana umechunguza mali zangu zote. Umeona nini kati ya kitu chochote cha nyumbani mwako? Viweke hapa mbele ya ndugu zetu, ili waamue kati yetu wawili. ");
INSERT INTO swhulb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kwa miaka ishirini nimekuwa nawe. Kondoo wako na mbuzi wako hawakutoa mimba, wala sikula dume lolote la kondoo katika wanyama wako. ");
INSERT INTO swhulb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kilichoraruliwa na hayawani sikukuletea. Badala yake, nilichukua upotevu huo, kwamba wameibwa mchana au usiku. ");
INSERT INTO swhulb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nilikuwepo wakati wote; mchana joto lilinipata, na baridi wakati wa usiku; na sikupata usingizi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Miaka hii ishirini nimekuwa katika nyumba yako. Nilikufanyia kazi miaka kumi na nne kwa ajili ya binti zako wawili, na miaka sita kwa ajili ya wanyama wako. Umebadili ujira wangu mara kumi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Isipokuwa Mungu wa baba yangu, Mungu wa Ibrahimu, yule Isaka anayemwofu, amekuwa nami, bila shaka sasa ungenipeleka mikono mitupu. Mungu ameliona teso langu na jinsi nilivyofanya kazi kwa bidii, na hivyo akakukemea usiku wa leo. ");
INSERT INTO swhulb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani akajibu na kumwambia Yakobo, “Mabinti hawa ni mabinti zangu, wajukuu ni wajukuu wangu, na wanyama ni wanyama wangu. Yote uyaonayo ni yangu. Lakini nitafanya nini leo kwa hawa binti zangu, au kwa watoto wao waliowazaa? ");
INSERT INTO swhulb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Hivyo sasa, na tufanye agano, wewe nami, na liwe shahidi kati yangu nawe.” ");
INSERT INTO swhulb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hivyo Yakobo akachukua jiwe na kuliweka kama nguzo. ");
INSERT INTO swhulb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobo akawambia ndugu zake, “Kusanyeni mawe.” Hivyo wakachukua mawe na kufanya rundo. Kisha wakala pale kati ya lile rundo. ");
INSERT INTO swhulb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani aliliita Yega Saha Dutha, lakini Yakobo akaiita Galeedi ");
INSERT INTO swhulb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani akasema, “Rundo hili ni shahidi kati yangu nawe leo.” Kwa hiyo jina lake likaitwa Galedi. ");
INSERT INTO swhulb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Inaitwa pia Mispa, kwa sababu Labani alisema, “Yahwe na atuangalie mimi nawe, tunapokuwa hatuonani. ");
INSERT INTO swhulb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ikiwa utawatesa binti zangu, au ikiwa utachukua wanawake wengine mbali na binti zangu, japokuwa hakuna mwingine yupo nasi, tazama, Mungu ni shahidi kati yangu nawe.” ");
INSERT INTO swhulb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani akamwambia Yakobo, Tazama rundo hili, na tazama nguzo, nililoliweka kati yako nami. ");
INSERT INTO swhulb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Rundo hili ni shahidi, na nguzo ni shahidi, kwamba sitapita rundo hili kuja kwako, na kwamba wewe hautapita rundo hili kuja kwangu, kwa madhara. ");
INSERT INTO swhulb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mungu wa Ibrahimu, na mungu wa Nahori, miungu ya baba zao, waamue kati yetu.”Yakobo akaapa kwa Hofu ya Isaka baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo akatoa sadaka juu ya mlima na akawaita ndugu zake kula chakula. Walikula na kukaa usiku kucha juu ya mlima. ");
INSERT INTO swhulb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labani akaamka asubuhi na mapema, akawabusu wajuu zake na binti zake na kuwabariki. Kisha Labani akaondoka na kurudi kwake. ");
INSERT INTO swhulb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo pia akaendelea na safari yake, na malaika wa Mungu wakakutana naye. ");
INSERT INTO swhulb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo alipowaona, akasema, “Hii ni kambi ya Mungu,” hivyo akapaita mahali pale Mahanaimu. ");
INSERT INTO swhulb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo akatuma wajumbe mbele yake waende kwa Esau ndugu yake katika nchi ya Seiri, katika eneo la Edomu. ");
INSERT INTO swhulb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Aliwaagiza, kusema, “Hivi ndivyo mtakavyosema kwa bwana wangu Esau: Hivi ndivyo mtumishi wako Yakobo asemavyo: 'Nimekuwa nikikaa na Labani, naye amekawilisha kurudi kwangu hata sasa. ");
INSERT INTO swhulb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nina ng'ombe, punda, na kondoo, wajori na wajakazi. Nimetuma ujumbe huu kwa bwana wangu, ili kwamba nipate kibali mbele zako.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wajumbe wakarudi kwa Yakobo na kusema, “Tulikwenda kwa Esau ndugu yako. Anakuja kukulaki, na watu mia nne pamoja naye.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ndipo Yakobo alipoogopa sana na kutaabika. Hivyo akagawanya watu aliokuwa nao katika kambi mbili, na kondoo pia, mbuzi na ngamia. ");
INSERT INTO swhulb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Akasema, “Ikiwa Esau ataishambulia kambi moja, ndipo kambi nyingine itakaposalimika.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakobo akasema, “Mungu wa baba yangu Ibrahimu, na Mungu wa baba yangu Isaka, Yahwe, uliyeniambia, 'Rudi katika nchi yako na kwa jamaa yako, nami nitakustawisha,' ");
INSERT INTO swhulb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mimi sistahili matendo yako yote ya agano la uaminifu na ustahilifu wote uliomfanyia mtumishi wako. Kwa maana nilikuwa na fimbo tu nilipovuka mto huu wa Yordani, na sasa nimekuwa matuo mawili. ");
INSERT INTO swhulb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tafadhari niokoe kutoka katika mikono ya ndugu yangu, mikono ya Esau, kwa maana namwogopa, kwamba atakuja na kunishambulia mimi na wamama na watoto. ");
INSERT INTO swhulb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lakini ulisema, 'hakika nitakufanya ufanikiwe. Nitaufanya uzao wako kuwa kama mchanga wa bahari, ambao hauwezi kuhesabika kwa hesabu yake.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakobo akakaa pale usiku huo. Akachukua baadhi ya alivyokuwa navyo kama zawadi kwa Esau, ndugu yake: ");
INSERT INTO swhulb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","mbuzi majike mia mbili na mabeberu ishirini, kondoo majike mia mbili na madume ya kondoo ishirini, ");
INSERT INTO swhulb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamia wakamwao thelathini na wana wao, ng'ombe madume arobaini na madume kumi ya ng'ombe, punda wa kike ishirini na madume yake ishirini. ");
INSERT INTO swhulb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Akawaweka katika mikono ya watumishi wake, kila kundi peke yake. Akawambia watumishi, “Tangulieni mbele yangu na mwache nafasi kati ya makundi ya wanyama.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Akamwagiza mtumishi wa kwanza, akisema, “Ndugu yangu Esau atakapokutana nawe na kukuuliza, akasema, 'Ninyi ni wa nani? Mnakwenda wapi? Na wanyama hawa mbele yenu ni wa nani? ");
INSERT INTO swhulb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ndipo umwambie, 'Ni wa mtumishi wako Yakobo. Ni zawadi wanaopelekwa kwa bwana wangu Esau. Na tazama, yeye pia anakuja nyuma yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakobo akatoa maelekezo kwa kundi la pili pia, la tatu, na watu wote walioyafuata makundi ya wanyama. Akasema, mseme vilevile kwa Esau mtakapokutana naye. ");
INSERT INTO swhulb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mnapaswa pia kusema, 'mtumwa wako Yakobo pia anakuja nyuma yetu.” Kwani alifikiri, “nitamtuliza Esau kwa zawadi nilizozituma mbele yangu. Kisha baadaye, nitakapomwona, bila shaka atanipokea.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hivyo zawadi zikatangulia mbele yake. Yeye mwenyewe akakaa kambini usiku huo ");
INSERT INTO swhulb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yakobo akaamka wakati wa usiku, na akawachukua wakeze, wajakazi wake na wanaye kumi na wawili. Akawawavusha kijito cha Yaboki. ");
INSERT INTO swhulb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kwa njia hii akawapeleka kupitia chemichemi pamoja na mali yake yote. ");
INSERT INTO swhulb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobo akaachwa peke yake, na mtu akashindana naya mpaka alfajiri. ");
INSERT INTO swhulb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mtu yule alipoona kwamba hawezi kumshinda, akalipiga paja lake. Paja la Yakobo likatenguka alipokuwa akishindana naye. ");
INSERT INTO swhulb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yule mtu akasema, “Niache niende, kwani kunakucha.” Yakobo akasema, sitakuacha uende mpaka uwe umenibariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yule mtu akamwuliza, “Jina lako ni nani?” Yakobo akasema, “Yakobo.” Yule mtu akasema, ");
INSERT INTO swhulb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Jina lako halitakuwa Yakobo tena, ila Israeli. Kwa kuwa umeshindana na Mungu na wanadamu na umeshinda.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo akamwambia, “Tafadhari niambie jina lako.” Akasema, “Kwa nini kuniuliza jina langu?” Kisha akambariki pale. ");
INSERT INTO swhulb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo akapaita mahali pale Penieli kwani alisema, “Nimemwona Mungu uso kwa uso, na maisha yangu yamesalimika.” ");
INSERT INTO swhulb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jua likatoka wakati Yakobo anaipita Penieli. Alikuwa akichechemea kwa sababu ya paja lake. ");
INSERT INTO swhulb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ndiyo maana wana wa Israeli hawali kano ya paja iliyopo katika nyonga ya paja, kwa sababu yule mtu aliziumiza hizo kano alipotegua paja la Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo akainua macho yake na, tazama, Esau alikuwa anakuja, na alikuwa na watu mia nne pamoja naye. Yakobo akawagawanya watoto kati ya Lea, Raheli, na wale wajakazi wawili. ");
INSERT INTO swhulb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kisha akawaweka wajakazi na wanao mbele, wakifuatiwa na Lea na watoto wake, Raheli na Yusufu wakafuata mwisho wa wote. ");
INSERT INTO swhulb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yeye mwenyewe akatangulia mbele yao. Akasujudu mara saba kuelekea ardhi, hata alipomkaribia ndugu yake. ");
INSERT INTO swhulb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau akakimbia kumlaki, akamkumbatia, akakumbatia shingo yake na kumbusu. Kisha wakalia. ");
INSERT INTO swhulb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau alipoinua macho, aliona wanawake na watoto. Akauliza, “Hawa watu pamoja nawe ni kinanani?” Yakobo akasema, Ni watoto ambao Mungu amempa mtumishi wako kwa neema.” ");
INSERT INTO swhulb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kisha wajakazi wakakaribia pamoja na watoto wao, nao wakasujudia. ");
INSERT INTO swhulb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Akafuata Lea pia na watoto wake wakaja na kusujudia. Mwisho Yusufu na Raheli wakaja na kusujudia. ");
INSERT INTO swhulb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau akasema, Unamaanisha nini kwa makundi haya yote niliyokutana nayo?” Yakobo akasema, “Kutafuta kibali mbele za bwana wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau akasema, “Ninayo ya kutosha, ndugu yangu. Tunza uliyonayo kwa ajili yako mwenyewe.” ");
INSERT INTO swhulb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo akasema, “Hapana, tafadhari, ikiwa nimeona kibali mbele zako, basi upokee zawadi yangu kutoka mkononi mwangu, na ni kama kuona uso wa Mungu, na umenipokea. ");
INSERT INTO swhulb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tafadhari pokea zawadi yangu uliyoletewa, kwa sababu Mungu amenitendea kwa neema, na kwa sababu ninavyo vya kutosha.” Hivyo Yakobo akamsihi, na Esau akamkubali. ");
INSERT INTO swhulb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kisha Esau akasema, “Haya na tuondoke. Nitakutangulia.” ");
INSERT INTO swhulb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobo akamwambia, “Bwana wangu anajua kwamba watoto ni wadogo, na kwamba kondoo na ng'ombe wananyonyesha ndama wao. Ikiwa watapelekwa kwa haraka hata siku moja, wanyama wote watakufa. ");
INSERT INTO swhulb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tafadhari bwana wangu na amtangulie mtumishi wake. Nitasafiri polopole, kwa kadili ya mifugo iliyo mbele yangu, na kadili ya watoto, hata nitakapofika kwa bwana wangu huko Seiri.” ");
INSERT INTO swhulb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau akasema, haya nikuachie baadhi ya watu wangu waliopamoja nami.” Yakobo akasema, “Kwa nini kufanya hivyo? Bwana wangu amekuwa mkalimu kwangu kiasi cha kutosha.” ");
INSERT INTO swhulb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hivyo Esau akaanza kurudi Seiri. ");
INSERT INTO swhulb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakobo akasafiri kuelekea Sukothi, akajijengea nyumba, na akafanya mazizi kwa ajili ya mifugo wake. Hivyo jina la eneo linaitwa Sukothi. ");
INSERT INTO swhulb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobo alipokuja kutoka Padani Aramu, akafika salama katika mji wa Shekemu, uliyo katika nchi ya Kanaani. Akapiga kambi karibu na mji. ");
INSERT INTO swhulb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kisha akanunu sehemu ya ardhi alipokuwa ameweka hema yake kutoka kwa wana wa Hamori, baba wa Shekemu, kwa vipande mia vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Akajenga madhabahu pale na kuiita El Elohe Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Basi Dina, Binti wa Lea aliyemzalia Yakobo, akaenda kuwaona wasichana wa nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shekemu mwana wa Hamori Mhivi, mwana mfalme wa nchi, akamwona na akamkamata kwa nguvu na kulala naye. ");
INSERT INTO swhulb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Akavutiwa na Dina, binti Yakobo. Akampenda msichana na kuongea naye kwa upole. ");
INSERT INTO swhulb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekemu akamwambia Hamori baba yeke, kusema, “Nipe msichana huyu kuwa mke wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Basi Yakobo akasikia kwamba alikuwa amemchafua Dina binti yake. Wanawe walikuwa pamoja na wanyama uwandani, hivyo Yakaobo akawangoja hata walipokuja. ");
INSERT INTO swhulb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori baba wa Shekemu akaenda kuongea na Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Wana wa Yakobo waliposikia neno hili wakaja kutoka uwandani. Watu hawa walichukizwa sana. Walikasirika sana kwa sababu alikuwa amemwaibisha Israeli kwa kumlazimisha binti wa Yakobo, kwa maana jambo kama hilo halikupasa kutendeka. ");
INSERT INTO swhulb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori akaongea nao, akisema, “Shekemu mwanangu anampenda binti yenu. Tafadhari mpeni kuwa mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mwoane nasi, tupeni binti zenu, na mjichukulie binti zetu kwa ajili yenu wenyewe. ");
INSERT INTO swhulb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mtaishi nasi, na nchi itakuwa wazi kwa ajili yenu kufanya biashara humo, na kupata mali.” ");
INSERT INTO swhulb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekemu akamwambia baba yake na ndugu zake, “Na nione kibari machoni penu, na chochote mtakachoniambia nitatoa. ");
INSERT INTO swhulb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Niambieni kiasi kikubwa chochote cha mahari na zawadi kama mtakavyo, nami nitatoa chochote msemacho, lakini mnipe msichana kuwa mke wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wana wa Yakobo wakamjibu Shekemu na Hamori baba yake kwa hila, kwa sababu Shekemu alikuwa amemnajisi Dina dada yao. ");
INSERT INTO swhulb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wakawambia, “Hatuwezi kufanya jambo hili, kumpa dada yetu mtu yeyote ambaye hajatailiwa; kwani hiyo ni aibu kwetu. ");
INSERT INTO swhulb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kwa sharti hili peke yake tutakubaliana nanyi: iwapo mtatailiwa kama sisi, ikiwa kila mtu mme miongoni mwenu atatailiwa. ");
INSERT INTO swhulb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ndipo tutakapowapa binti zetu, nasi tutachukua binti zenu kwetu sisi wenyewe, na tutaishi nanyi na kuwa wamoja. ");
INSERT INTO swhulb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Lakini kama hamtusikilizi na kutailiwa, ndipo tutakapomchukua dada yetu na kuondoka. ");
INSERT INTO swhulb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Maneno yao yakawafurahisha Hamori na Shekemu mwanaye. ");
INSERT INTO swhulb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kijana hakukawia kufanya walichokisema, kwa maana alipendezwa na binti Yakobo, na kwa sababu alikuwa mtu aliyeheshimiwa sana katika nyumba ya babaye. ");
INSERT INTO swhulb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori na Shekemu mwanaye wakaenda katika lango la mji wao na kuongea na watu wa mji, kusema, ");
INSERT INTO swhulb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Watu hawa wanaamani nasi, hivyo na waishi katika nchi na kufanya biashara humo kwa maana, kweli, nchi ni kubwa ya kuwatosha. Haya na tuwachukue binti zao kuwa wake, nasi tuwape binti zetu. ");
INSERT INTO swhulb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kwa shariti hili pekee watu hawa wanakubali kuishi nasi na kuwa wamoja: ikiwa kila mwanamme miongoni mwetu atatailiwa, kama wao. ");
INSERT INTO swhulb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Je wanyama wao na vitu vyao - wanyama wao wote kuwa wetu? Haya na tukubaliane nao, nao wataishi kati yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Watu wote wa mji wakamsikiliza Hamori na Shekemu, mwanaye. Kila mwanamme akatailiwa. ");
INSERT INTO swhulb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Katika siku ya tatu, walipokuwa katika maumivu bado, wawili wa wana wa Yakobo (Simoni na Lawi, kaka zake Dina), wakachukua kila mmoja upanga wake na kuushambulia mji ambao ulikuwa na uhakika wa ulinzi wake, nao wakauwa wanamme wote. ");
INSERT INTO swhulb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wakamwua Hamori na Shekemu kwa makali ya upanga. Wakamchukua Dina kutoka nyumba ya Shekemu na kuondoka. ");
INSERT INTO swhulb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wale wana wengine wa Yakobo wakaja kwa maiti na kuuteka nyara mji, kwa sababu watu wale walikuwa wamemnajisi dada yao. ");
INSERT INTO swhulb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wakachukua makundi yao ya kondoo, mbuzi, punda, na kila kitu ndani ya mji na viunga vyake ");
INSERT INTO swhulb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","utajiri wote. Watoto na wake zao wote, wakawachukua. Hata wakachukua kila kitu kilichokua katika nyumba. ");
INSERT INTO swhulb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakobo akawambia Simoni na Lawi, “Mmeleta shida juu yangu, kunifanya ninuke kwa wenyeji wa nchi, Wakanaani na Waperizi. Mimi nina watu wachache. Ikiwa watajikusanya pamoja kinyume changu na kunishambulia.” ");
INSERT INTO swhulb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Lakini Simoni na Lawi wakasema, “Je Shekemu alipaswa kumtendea dada yetu kama kahaba?” ");
INSERT INTO swhulb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mungu akamwambia Yakobo, “Inuka, panda kwenda Betheli, na ukae pale. Unijengee madhabahu pale, niliyekutokea pale ulipomkimbia Esau kaka yako.” ");
INSERT INTO swhulb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kisha Yakobo akawambia nyumba yake na wote aliokuwa nao, “Wekeni mbali miungu yote ya kigeni iliyo kati yenu, jitakaseni wenyewe, na kubadili mavazi yenu. ");
INSERT INTO swhulb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kisha tuondoke na kwenda Betheli. Nitajenga pale madhabahu kwa Mungu, aliyenijibu katika siku ya shida yangu, naye amekuwa pamoja nami kila nilikokwenda. ");
INSERT INTO swhulb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hivyo wakampa Yakobo miungu yote ya kigeni iliyokuwa mikononi mwao, na heleni zilizokuwa katika masikio yao. Yakobo akazifukia chini ya mwaloni uliokuwa karibu na Shekemu. ");
INSERT INTO swhulb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kwa kadili walivyo safiri, Mungu akaifanya miji yote iliyokuwa karibu nao kuhofu, hivyo watu hao hawakuwafuatia wana wa Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Hivyo Yakobo akafika Luzu(ndiyo Betheli), ulioko katika nchi ya Kanaani, yeye na watu wote aliokuwa nao. ");
INSERT INTO swhulb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Alijenge madhabahu na kuliita eneo hilo El Betheli, kwa sababu Mungu alikuwa amejifunua kwake, alipokuwa akimkimbia ndugu yake. ");
INSERT INTO swhulb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora, mlezi wa Rebeka, akafa. Akazikwa chini kutoka Betheli chini ya mwaloni, hivyo ikaitwa Aloni Bakuthi. ");
INSERT INTO swhulb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo alipokuja kutoka Padani Aramu, Mungu akamtokea tena na kumbariki. ");
INSERT INTO swhulb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mungu akamwambia, “Jina lako ni Yakobo, lakini jina lako halitakuwa Yakobo tena. Jina lako litakuwa Israeli.” Hivyo Mungu akamwita jina lake Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Mungu akamwambia, “Mimi ni Mungu Mwenyezi, Uwe mwenye kuzaa na kuongezeka. Taifa na wingi wa mataifa watakujia, na wafalme watatoka miongoni mwa uzao wako. ");
INSERT INTO swhulb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nchi ambayo nilimpa Ibrahimu na Isaka, nitakupa wewe. Nami nitaupa pia uzao wako baada yako nchi hii.” ");
INSERT INTO swhulb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mungu akapanda kutoka mahali alipoongea naye. ");
INSERT INTO swhulb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo akaweka nguzo katika eneo ambalo Mungu alikuwa ameongea naye, nguzo ya jiwe. Akamimina juu yake sadaka ya kinywaji na akamimina mafuta juu yake. ");
INSERT INTO swhulb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo akaiita sehemu Mungu aliyoongea naye, Betheli ");
INSERT INTO swhulb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wakaendelea na safari kutoka Betheli. Walipokuwa kitambo kabla ya kufika Efrathi, Raheli akashikwa na uchungu. ");
INSERT INTO swhulb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Akawa na utungu mzito. Alipokuwa katika utungu mzito zaidi, mkunga akamwambia, “Usiogope, kwani sasa utapata mtoto mwingine wa kiume.” ");
INSERT INTO swhulb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hata alipokaribia kufa, kwa pumzi yake ya mwisho akamwita jina lake Benoni, lakini baba yake akamwita jina lake Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raheli akafa na kuzikwa katika njia iendayo Efrathi (ndio Bethlehemu). ");
INSERT INTO swhulb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo akaweka nguzo katika kaburi lake. Ndiyo alama ya kaburi la Raheli hata leo. ");
INSERT INTO swhulb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israeli akaendelea na safari na akaweka hema yake kuvuka mnara wa walinzi wa kondoo. ");
INSERT INTO swhulb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yakobo alipokuwa akiishi katika nchi hiyo, Rubeni akalala na Bilha suria wa baba yake, na Israeli akasikia kuhusu hilo. Basi Yakobo alikuwa na wana kumi na mbili. ");
INSERT INTO swhulb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wanawe kwa Lea walikuwa Rubeni, mzaliwa wa kwanza wa Yakobo, na Simoni, Lawi, Yuda, Isakari, na Zabuloni. ");
INSERT INTO swhulb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wanawe kwa Raheli walikuwa Yusufu na Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wanawe kwa Bilha, mjakazi wa Raheli walikuwa Dani na Naftali. ");
INSERT INTO swhulb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wana wa Zilpa, mjakazi wa Lea, walikuwa Gadi na Asheri. Hawa wote walikuwa wana wa Yakobo waliozaliwa kwake huko Padani Aramu. ");
INSERT INTO swhulb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo akaja kwa Isaka, baba yake, huko Mamre katika Kiriathi Arba (jina sawa na Hebroni), alipoishi Ibrahimu na Isaka. ");
INSERT INTO swhulb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka akaishi miaka mia moja na themanini. ");
INSERT INTO swhulb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaka akapumua pumzi yake ya mwisho na akafa, na akakusanywa kwa wahenga wake, na mtu mzee amejaa siku. Esau na Yakobo, wanawe, wakamzika. ");
INSERT INTO swhulb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hivi ndivyo vizazi vya Esau (aliyeitwa pia Edom). ");
INSERT INTO swhulb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau akachukua wakeze kutoka kwa Wakanaani. Hawa walikuwa wake zake: Ada binti Eloni Mhiti; Oholibama binti Ana, mjukuu wa Zibeoni Mhivi; na ");
INSERT INTO swhulb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemathi, binti Ishmaeli, dada wa Nebayothi. ");
INSERT INTO swhulb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada akamzaa Elifazi kwa Esau, na Basemathi akamzaa Reueli. ");
INSERT INTO swhulb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama akamzaa Yeushi, Yalamu, na Kora. Hawa walikuwa wana wa Esau waliozaliwa kwake katika nchi ya Kananaani. ");
INSERT INTO swhulb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau akawachukua wakeze, wanawe, binti zake, na watu wote wa nyumba yake, mifugo wake - wanyama wake wote, na mali yake yote, aliyokuwa amekusanya katika nchi ya Kanaani, na akaenda katika nchi iliyoko mbali kutoka kwa Yakobo nduguye. ");
INSERT INTO swhulb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Alifanya hivi kwa sababu mali zao zilikuwa nyingi sana kwa wao kuishi pamoja. Nchi waliyokuwa wamekaa isingeweza kuwafaa kwa mifugo yao. ");
INSERT INTO swhulb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hivyo Esau, aliyejulikana pia kama Edomu, akakaa katika nchi ya kilima Seiri. ");
INSERT INTO swhulb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hivi ndivyo vizazi vya Esau, babu wa Waedomu katika nchi ya mlima Seiri. ");
INSERT INTO swhulb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Haya yalikuwa majina ya wana wa Esau: Elifazi mwana wa Ada, mkewe Esau; Reueli mwana wa Basemathi, mkewe Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifazi walikuwa Temani, Omari, Zefo, Gatamu, na Kenazi. ");
INSERT INTO swhulb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, suria wa Elifazi, mwana wa Esau, akamzaa Amaleki. Hawa walikuwa wajukuu wa Ada, mkewe Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Hawa walikuwa wana wa Reueli: Nahathi, Zera, Shama, na Miza. Hawa walikuwa wajukuu wa Basemathi, mkewe Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Hawa walikuwa wana wa Oholibama, mkewe Esau, aliyekuwa binti Ana na mjukuu wa Zibeoni. Alimzalia Esau Yeushi, Yalamu, na Kora. ");
INSERT INTO swhulb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hizi zilikuwa koo kati ya vizazi vya Esau: uzao wa Elifazi, mzaliwa wa kwanza wa Esau: Temani, Omari, Zefo, Kenazi, Kora, ");
INSERT INTO swhulb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Gatamu, na Amaleki. Hivi vilikuwa vizazi vya koo kutoka kwa Elifazi katika nchi ya Edomu. Walikuwa wajukuu wa Ada. ");
INSERT INTO swhulb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hizi zilikuwa koo kutoka kwa Reueli, mwana wa Esau: Nahathi, Zera, Shama, Miza. Hizi zilikuwa koo kutoka kwa Reueli katika nchi ya Edomu. Walikuwa wajukuu wa Basemathi, mkewe Esau. ");
INSERT INTO swhulb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Hizi zilikuwa koo za Oholibama, mkewe Esau: Yeushi, Yalamu, Kora. Hizi ni koo zilizotoka kwa Oholibama mkewe Esau, binti Ana. ");
INSERT INTO swhulb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hawa walikuwa wana wa Esau na koo zao. ");
INSERT INTO swhulb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hawa walikuwa wana wa Seiri Mhori, wenyeji wa nchi hiyo: Lotani, Shobali, Zibeoni, Ana, ");
INSERT INTO swhulb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Ezeri, na Dishani. Hizi zilikuwa koo the Wahori, wenyeji wa Seiri katika nchi ya Edomu. ");
INSERT INTO swhulb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani walikuwa Hori na Hemani, na Timna alikuwa dada wa Lotani. ");
INSERT INTO swhulb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Hawa walikuwa wana wa Shobali: Alvani, Manahathi, Ebali, Shefo, na Onamu. ");
INSERT INTO swhulb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Hawa walikuwa wana wa Zibeoni: Aia na Ana. Huyu ndiye Ana aliyeona chemichemi za moto nyikani, alipokuwa akichunga punda wa Zibeoni babaye. ");
INSERT INTO swhulb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Hawa walikuwa watoto wa Ana: Dishoni na Oholibama, binti Ana. ");
INSERT INTO swhulb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Hawa walikuwa wana wa Dishoni: Hemdani, Eshbani, Ithrani, na Kerani. ");
INSERT INTO swhulb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Hawa walikuwa wana wa Ezeri: Bilhani, Zaavani, na Akani. ");
INSERT INTO swhulb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Hawa walikuwa wana wa Dishani: Uzi na Arani. ");
INSERT INTO swhulb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hizi zilikuwa koo za Wahori: Lotani, Shobali, Zibeoni, na Ana, ");
INSERT INTO swhulb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoni, Ezeri, Dishani: hizi zilikuwa koo za Wahori, kulingana na ukoo ulivyoorodheshwa katika nchi ya Seiri. ");
INSERT INTO swhulb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hawa walikuwa wafalme waliomiliki katika nchi ya Edomu kabla ya mfalme yeyote kumilika juu ya Waisraeli: ");
INSERT INTO swhulb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Beori, alitawala huko Edomu, na jina la mji wake lilikuwa Dinhaba. ");
INSERT INTO swhulb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela alipofariki, kisha Yobabu mwana wa Zera kutoka Bozra, akatawala mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu alipofariki, Hushamu aliyekuwa wa nchi ya Watemani, akatawala mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu alipofariki, Hadadi mwana wa Bedadi aliyewashinda Wamidiani katika nchi ya Moabu, akatawala mahali pake. Jina la mji wake lilikuwa Avithi. ");
INSERT INTO swhulb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi alipofariki, kisha Samla wa Masreka akatawala mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla alipofariki, kisha Shauli wa Rehobothi kando ya mto alitawala mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli alipofariki, kisha Baali Hanani mwana wa Akbori akatawala mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali Hanani mwana wa Akbori, alipokufa, kisha Hadari akatawala mahali pake. Jina la mji wake lilikuwa Pau. Jina la mkewe lilikuwa Mehetabeli, binti Matredi, mjukuu wa Me Zahabu. ");
INSERT INTO swhulb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Haya ndiyo yalikuwa majina ya wakuu wa koo kutoka uzao wa Esau, kwa kufuata koo zao na maeneo yao, kwa majina yao: Timna, Alva, Yethethi, ");
INSERT INTO swhulb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinoni, ");
INSERT INTO swhulb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mbza, ");
INSERT INTO swhulb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdieli, na Iramu. Hawa walikuwa wakuu wa ukoo wa Edomu, kwa kufuata makao yao katika nchi waliyomiliki. Nao ni Esau, baba wa Waedomu. ");
INSERT INTO swhulb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo akaishi katika nchi aliyokaa babaye, katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Haya ndiyo matukio yaliyomhusu Yakobo. Yusufu, aliyekuwa kijana wa miaka kumi na saba, alikuwa akilichunga kundi pamoja na ndugu zake. Alikuwa pamoja na wana wa Bilha na pamoja na wana wa Zilpa, wake wa baba yake. Yusufu akaleta taarifa yao mbaya kwa baba yao. ");
INSERT INTO swhulb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Basi Israeli akampenda Yusufu kuliko wanawe wote kwa sababu alikuwa mwana wa uzee wake. Akamshonea vazi zuri. ");
INSERT INTO swhulb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ndugu zake wakaona kwamba baba yao alimpenda sana kuliko ndugu zake wote. Wakamchukia na hawakuongea naye vema. ");
INSERT INTO swhulb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu akaota ndoto, na akawambia ndugu zake. Wakamchukia zaidi. ");
INSERT INTO swhulb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aliwambia, “Tafadhari sikilizeni ndoto hii niliyoiota. ");
INSERT INTO swhulb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tazama, tulikuwa tukifunga miganda ya nafaka shambani na tazama, mganda wangu ukainuka na kusimama wima, na tazama, miganda yenu ikasogea na kuuinamia mganda wangu” ");
INSERT INTO swhulb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ndugu zake wakamwambia, “Je ni kweli utatutawala? Je utatutawala juu yetu? Hata wakamchukia zaidi kwa ajili ya ndoto zake na maneno yake. ");
INSERT INTO swhulb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Akaota ndoto nyingine na kuwasimulia ndugu zake. Alisema, “Tazama, nimeota ndoto nyingine: Jua na mwezi na nyota kumi na moja ziliniinamia.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Akamwambia baba yake vile vile alivyowambia ndugu zake, na baba yake akamkemea. Akamwambia, Je umeota ndoto ya namna gani hii? Je mama yako na mimi na ndugu zako kweli tutakuja kukuinamia mpaka chini?” ");
INSERT INTO swhulb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ndugu zake wakamwonea wivu, lakini baba yake akaliwema jambo hilo moyoni. ");
INSERT INTO swhulb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ndugu zake wakaenda kulichunga kundi la baba yao huko Shekemu. ");
INSERT INTO swhulb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israeli akamwambia Yusufu, 'Je ndugu zako hawalichungi kundi huko Shekemu? Njoo, nami nitakutuma kwao.” Yusufu akamwambia, “nipo tayari.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Akamwambia, “Basi nenda, uwaone ndugu zako na kundi wanaendeleaje, na uniletee neno.” Hivyo Yakobo akamtuma kutoka katika bonde la Hebroni, na Yusufu akaenda Shekemu. ");
INSERT INTO swhulb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Mtu mmoja akamwona Yusufu. Tazama, Yusufu alikuwa akizunguka kondeni. Yule mtu akamwuliza, “Unatafuta nini?” ");
INSERT INTO swhulb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu akamwambia, “Nawatafuta ndugu zangu. Tafadhari, niambie, wananalichunga wapi kundi.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yule mtu akasema, “Waliondoka mahali hapa, kwa maana niliwasikia wakisema, 'Haya twende Dothani.” Yusufu akawafuata ndugu zake na kuwaona huko Dothani. ");
INSERT INTO swhulb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wakamwona kutokea mbali, na kabla hajawakaribia, wakapanga njama ya kumwua. ");
INSERT INTO swhulb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ndugu zake wakaambiana wao kwa wao, “Tazama, mwotaji anakaribia. ");
INSERT INTO swhulb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Njoni sasa, na tumwue na kumtupa katika mojawapo ya mashimo haya. Nasi tutasema, 'Mnyama mkali amemrarua.' Nasi tutaona ndoto zake zitakuwaje.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeni alilisikia hilo na kumwokoa kutoka katika mikono yao. Alisema, “Tusiuondoe uhai wake.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubeni aliwambia, “Msimwage damu. Mtupeni katika shimo hili lililopo nyikani, lakini msiweke mikono yenu juu yake” - ili kwamba aweze kumwokoa katika mikono yao na kumrudisha kwa baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ikawa Yusufu alipowafikia ndugu zake, walimvua vazi lake zuri. ");
INSERT INTO swhulb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Wakamchukua na kumtupa shimoni. Shimo lilikuwa tupu bila maji. ");
INSERT INTO swhulb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wakakaa chini kula mkate. Walipoinua macho yao na kuangalia, na, tazama, msafara wa Waishmaeli ulikuwa ukija kutoka Gileadi, pamoja na ngamia wao waliochukua viungo, malhamu na manemane. Walikuwa wakisafiri kuvichukua kuelekea Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda akawambia ndugu zake, “Ni faida gani kama tutamwua ndugu yetu na kufunika damu yake? ");
INSERT INTO swhulb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haya, na tumwuze kwa Waishmaeli na wala tusiweke mikono yetu juu yake. Kwani yeye ni ndugu yetu, nyama yetu.” Ndugu zake wakamsikiliza. ");
INSERT INTO swhulb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wafanyabiashara wa Kimidiani wakapita. Ndugu zake wakamwinua na kumtoa Yusufu shimoni. Wakamwuza Yusufu kwa Waishmaeli kwa vipande ishirini vya fedha. Waishmaeli wakamchukua Yusufu mpaka Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni akarudi kwenye shimo, na, tazama, Yusufu hakuwemo shimoni. Akararua mavazi yake. ");
INSERT INTO swhulb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Akarudi kwa ndugu zake na kusema, “Kijana yuko wapi? Na mimi, je niende wapi?” ");
INSERT INTO swhulb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wakachinja mbuzi na kisha wakalichukua vazi la Yusufu na kulichovya katika damu. ");
INSERT INTO swhulb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kisha wakalipeleka kwa baba yao na kusema, “Tumeiona hii. Tafadhari angalia kwamba ni vazi la mwanao au hapana.” ");
INSERT INTO swhulb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","“Yakobo akaitambua na kusema, “Ni nguo ya mwanangu. Mnyama wa mwitu amemrarua. Bila shaka Yusufu ameraruliwa katika vipande. ");
INSERT INTO swhulb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakobo akararua mavazi yake na kuvaa mavazi ya magunia katika viuno vyake. Akaomboleza kwa ajili ya mwanawe siku nyingi. ");
INSERT INTO swhulb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanawe na binti zake wote wakainuka na kumfariji, lakini alikataa kufarijiwa. Akasema, “Hakika nitashuka kuzimu nikimwombolezea mwanangu.” Babaye akamlilia. ");
INSERT INTO swhulb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Wamidiani wakamwuza huko Misri kwa Potifa, afisa wa Farao, kepteni wa walinzi. ");
INSERT INTO swhulb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ikawa wakati ule Yuda akawaacha ndugu zake na kukaa na Mwadulami fulani, jina lake Hira. ");
INSERT INTO swhulb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Pale akakutana na binti Mkanaani jina lake Shua. Akamwoa na kulala naye. ");
INSERT INTO swhulb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Akawa mjamzito na kuzaa mwana. Akaitwa Eri. ");
INSERT INTO swhulb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Akawa mjamzito tena na kuzaa mwana tena. Akamwita jina lake Onani. ");
INSERT INTO swhulb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Akazaa mwana mwingine akamwita jina lake Shela. Alikuwa huko Kezibu alipomzaa. ");
INSERT INTO swhulb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda akaona mke kwa ajili ya Eri, mzaliwa wake wa kwanza. Jina lake Tamari. ");
INSERT INTO swhulb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eri, mzaliwa wa kwanza wa Yuda, alikuwa mwovu mbele za Yahwe. Yahwe akamwua. ");
INSERT INTO swhulb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuda akamwambia Onani, “Lala na mke wa nduguyo. Fanya wajibu wa shemeji kwake, na umwinulie nduguyo mwana.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onani alijua kwamba mtoto asingekuwa wake. Pindi alipolala na mke wa kaka yake, alimwaga mbegu juu ya ardhi ili kwamba asimpatie nduguye mtoto. ");
INSERT INTO swhulb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Alilolifanya lilikuwa ovu mbele za Yahwe. Yahwe akamwua pia. ");
INSERT INTO swhulb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kisha Yuda akamwambia Tamari, mkwewe, “Ukakae mjane katika nyumb aya baba yako hadi Shela, mwanangu, atakapokuwa.” Kwani aliogopa, “Asije akafa pia, kama nduguze.” Tamari akaondoka na kuishi katika nyumba ya babaye. ");
INSERT INTO swhulb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Baada ya muda mrefu, binti Shua, mkewe Yuda, alikufa. Yuda akafarijika na kwenda kwa wakatao kondoo wake manyoya huko Timna, yeye na rafiki yake, Hira Mwadulami. ");
INSERT INTO swhulb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamari akaambiwa, “Tazama, mkweo anakwenda Timna kukata kondoo wake manyoya.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Akavua mavazi yake ya ujane na akajifunika kwa ushungi. Akakaa katika lango la Enaimu, lililoko kando ya njia iendayo Timna. Kwa maana aliona kwamba Shela amekua lakini akupewe kuwa mke wake. ");
INSERT INTO swhulb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda alipomwona alidhani ni kahaba kwa maana alikuwa amefunika uso wake. ");
INSERT INTO swhulb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Akamwendea kando ya njia na kusema, “Njoo, tafadhari uniruhusu kulala nawe” - kwani hakujua kwamba alikuwa ni mkwewe - naye akasema, “Utanipa nini ili ulale nami? ");
INSERT INTO swhulb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Akasema, “Nitakuletea mwana mbuzu wa kundi.” Akasema, “Je utanipa rehani hata utakapo leta?” ");
INSERT INTO swhulb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Akasema, “Nikupe rehani gani?” Naye akasema, “Mhuri wako na mshipi, na fimbo iliyo mkononi mwako.” Akampa na kulala naye. Akawa mjamzito. ");
INSERT INTO swhulb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Akaamka na kuondoka. Akavua ushungi wake na kuvaa vazi la ujane wake. ");
INSERT INTO swhulb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda akatuma mwana mbuzi kutoka kundini kwa mkono wa rafiki yake Mwadulami ili aichukue rehani kutoka katika mkono wa mwanamke, lakini hakumwona. ");
INSERT INTO swhulb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kisha Mwadulami akauliza watu wa sehemu hiyo,”Yupo wapi kahaba aliyekuwa Enaimu kando ya njia?” Wakasema, hapajawai tokea kahaba hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Akarudi kwa Yuda na kusema, “Sikumwona. Pia watu wa eneo hilo wamesema, 'Hajawai kuwapo kahaba hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda akasema, “Mwache akae na vitu, tusije tukaaibika. Hakika, nimemletea mwanambuzi, lakini hukumwona.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ikawa baada ya miezi mitatu Yuda akaambiwa, “Tamari mkweo amefanya ukahaba, na kwa hakika, yeye ni mjamzito.” Yuda akasema, “Mleteni hapa ili achomwe.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Alipoletwa nje, alipeleka ujumbe kwa mkwewe, “Mimi ni mjamzito kwa mtu mwenye vitu hivi.” Akasema, “Tambua tafadhari, mhuri huu na mshipi na fimbo ni vya nani.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda akavitambua na kusema, “Yeye ni mwenye haki kuliko mimi, kwani sikumpa Shela, mwanangu awe mme wake.” Hakulala naye tena. ");
INSERT INTO swhulb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Muda wake wa kujifungua ukafika, tazama, mapacha walikuwa tumboni mwake. ");
INSERT INTO swhulb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ikawa alipokuwa akijifungua mmoja akatoa mkono nje, na mkunga akachukua kitambaa cha rangi ya zambarau na kukifunga katika mkono wake na kusema, “Huyu ametoka wa kwanza.” ");
INSERT INTO swhulb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ikawa aliporudisha mkono wake, tazama, ndugu yake akatoka kwanza. Mkunga akasema, “Umetokaje” Na akaitwa Peresi. ");
INSERT INTO swhulb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kisha ndugu yake akatoka, akiwa na utepe wa zambarau juu ya mkono wake, naye akaitwa Zera. ");
INSERT INTO swhulb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusufu akaletwa Misri. Potifa, aliyekuwa afisa wa Farao mkuu wa walinzi na Mmisri, akamnunua kutoka kwa Waishmaeli, waliokuwa wamempeleka pale. ");
INSERT INTO swhulb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahwe alikuwa pamoja na Yusufu na akawa mtu aliyefanikiwa. Aliishi katika nyumba ya Mmisri bwana wake. ");
INSERT INTO swhulb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Bwana wake akaona kwamba Yahwe alikuwa pamoja naye na kwamba Yahwe alifanikisha kila kitu alichokifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu akapata kibali mbele zake. Akamtumikia Potifa. Potifa akamfanya msimamizi juu ya nyumba yake, na kila alichokimiliki, akakiweka chini ya uangalizi wake. ");
INSERT INTO swhulb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ikawa alipomfanya msimamizi juu ya nyumba yake na juu ya kila kitu alichomiliki, Yahwe akaibariki nyumba ya Mmisri kwa sababu ya Yusufu. Baraka za Yahwe zilikuwa juu ya kila kitu alichokuwa nacho Potifa nyumbani na shambani. ");
INSERT INTO swhulb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifa akaweka kila alichokuwa nacho chini ya uangalizi wa Yusufu. Hakuwa na haja ya kufikiri juu ya lolote isipokuwa chakula alichokula tu. Basi Yusufu alikuwa kijana mzuri na wa kuvutia. ");
INSERT INTO swhulb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ikawa baada ya hayo mke wa bwana wake akamtamani Yusufu. Akamwambia, “Lala nami.” ");
INSERT INTO swhulb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Lakini yeye alikataa na kumwambia mke wa bwana wake, “Tazama, bwana wangu haangalii chochote nikifanyacho nyumbani, na ameweka kila kitu anachokimiliki chini ya uangalizi wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hakuna mtu aliye mkuu katika nyumba hii kuliko mimi. Hajanidhuiria chochote isipokuwa wewe, kwa sababu wewe ni mkewe. Ni kwa namna gani basi naweza kufanya uovu mkuu namna hii na kumtenda dhambi Mungu? ");
INSERT INTO swhulb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Akamwambia Yusufu siku baada ya siku, lakini yeye akakataa kulala naye wala kuwa naye. ");
INSERT INTO swhulb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ikawa siku moja aliingia ndani kufanya kazi yake. Hakuna mtu yeyote wa nyumbani aliyekuwepo pale ndani. ");
INSERT INTO swhulb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Akashika nguo zake na kusema, “Lala nami.” Akaacha nguo zake mikononi mwake, akakimbia, na kutoka nje. ");
INSERT INTO swhulb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ikawa, alipoona kwamba ameziacha nguo zake mikononi mwake na kwamba amekimbia nje, ");
INSERT INTO swhulb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","akawaita watu wa nyumbani mwake na kuwambia, “Tazama, Potifa ameleta Mwebrania huyu kutudhihaki. Aliingia kulala nami, na nikapiga kelele. ");
INSERT INTO swhulb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ikawa aliponisikia nikipiga kelele, akaniacha na nguo yake, akakimbia, na kutoka nje.” ");
INSERT INTO swhulb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Akaweka nguo zake karibu naye hata bwana yake alipokuja nyumbani. ");
INSERT INTO swhulb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Akamwambia maelelezo haya, “Yule mtumishi Mwebrania uliyemleta kwetu, aliingia kunidhihaki. ");
INSERT INTO swhulb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ikawa nilipopiga kelele, akaacha nguo yake kwangu akakimbia nje.” ");
INSERT INTO swhulb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ikawa, bwana wake aliposikia maelezo aliyoambiwa na mkewe, “Hivi ndivyo mtumishi wako alivyonitenda,” alikasirika sana. ");
INSERT INTO swhulb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Bwana wa Yusufu akamchukua na kumweka gerezani, mahali walipowekwa wafungwa wa mfalme. Akawa pale kifungoni. ");
INSERT INTO swhulb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lakini Yahwe alikuwa pamoja na Yusufu na kumwonyesha uaminifu wa agano. Akampa kibali mbele ya mlinzi wa gereza. ");
INSERT INTO swhulb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mlinzi wa gereza akawaweka mikononi mwa Yusufu wafungwa wote waliokuwa gerezani. Chochote walichokifanya, kilikuwa chini ya uangalizi wa Yusufu. ");
INSERT INTO swhulb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mlinzi wa gereza hakuwa na wasiwasi juu ya chochote kilichokuwa mkononi mwake, kwa sababu Yahwe alikuwa pamoja naye. Yahwe akafanikisha kila alichokifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ikawa baada ya mambo haya, mnyweshaji wa mfalme wa Misri na mwokaji wa mfalime walimkosa bwana wao, mfalme wa Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao akawakasirikia hawa maafsa wawili, mkuu wa wanyweshaji na mkuu wa waokaji. ");
INSERT INTO swhulb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Akawaweka katika lindo katika nyumba ya kapteni wa walinzi, katika gereza lile Yusufu alimofungwa. ");
INSERT INTO swhulb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kapteni wa walinzi akamweka Yusufu kuwa mtumishi wao. Walikaa kifungoni kwa muda fulani. ");
INSERT INTO swhulb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Wote wakaota ndoto - mnyweshaji na mwokaji wa mfalme wa Misri waliokuwa wamefungwa gerezani - kila mmoja akaota ndoto usiku huo huo, na kila ndoto ilikuwa na tafsiri yake. ");
INSERT INTO swhulb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu akaja kwao asubuhi na kuwaona. Tazama, walikuwa na uzuni. ");
INSERT INTO swhulb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Akawauliza maafsa wa Farao waliokuwa pamoja naye kifungoni katika nyumba ya bwana wake, kusema, “Kwa nini leo mnaoneka wenye uzuni?” ");
INSERT INTO swhulb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wakamwambia, Sisi wote tumeota ndoto na hakuna wakuitafsiri.” Yusufu akawambia, “Je tafsiri haitoki kwa Mungu? Niambieni, tafadhari.” ");
INSERT INTO swhulb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mkuu wa wanyweshaji akamwambia Yusufu ndoto yake. Akamwambia, “Katika ndoto yangu, tazama, kulikuwa na mzabibu mbele yangu. ");
INSERT INTO swhulb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na kulikuwa na matawi matatu katika mzabibu huo. Ulipochipua, ukachanua maua na kuzaa vichala vya zabibu. ");
INSERT INTO swhulb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kikombe cha Farao kilikuwa mkononi mwangu. Nikachukua zabibu na kuzikamua katika kikombe cha Farao, na kukiweka kikombe katika mkono wa Farao.” ");
INSERT INTO swhulb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu akamwambia, “Tafsiri yake ni hii. Yale matawi matatu ni siku tatu. ");
INSERT INTO swhulb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ndani ya siku tatu Farao atakiinua kichwa chako na kukurudisha katika nafasi yako. Utakiweka kikombe cha Farao katika mkono wake, kama ulivyokuwa ulipokuwa mnyweshaji wake. ");
INSERT INTO swhulb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lakini unikumbuke ukifanikiwa, na unionesha wema. Unitaje kwa Farao na kuniondoa hapa gerezani. ");
INSERT INTO swhulb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Maana hakika nilitekwa kutoka katika nchi ya Waebrania. Na hapa sijafanya chochote kinachonipasa niwekwe gerezani.” ");
INSERT INTO swhulb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mkuu wa waokaji alipoona kwamba tafsiri ilikuwa ya kuvutia, akamwambia Yusufu, “Mimi pia niliota ndoto, na tazama, vikapu vitatu vya mikate vilikuwa juu ya kichwa changu. ");
INSERT INTO swhulb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Katika kikapu cha juu kulikuwa na kila aina za bidhaa ya kuokwa kwa Farao, lakini ndege wakavila ndani ya kikapu juu ya kichwa changu.” ");
INSERT INTO swhulb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu akajibu na kusema, “Tafsiri ni hii. Vikapu vitatu ni siku tatu. ");
INSERT INTO swhulb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ndani ya siku tatu Fareao atakiinua kichwa chako kutoka kwako na atakutundika juu ya mtu. Ndege watakula mwili wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ikawa siku ya tatu ambayo ilikuwa ni siku ya kuzaliwa kwa Farao. Akafanya sherehe kwa watumishi wake wote. “Akakiinua juu” kichwa cha mkuu wa wanyweshaji na kichwa cha mkuu wa waokaji, kati ya watumishi wake. ");
INSERT INTO swhulb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Akamrudisha mkuu wa wanyweshaji katika majukumu yake, na akakiweka tena kikombe katika mkono wa Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lakini akamtundika mkuu wa waokaji, kama Yusufu alivyokuwa amewatafsiria. ");
INSERT INTO swhulb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Hata hivyo mkuu wa wanyweshaji hakukumbuka kumsaidia Yusufu. Badala yake, alimsahau. ");
INSERT INTO swhulb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ikawa mwishoni mwa miaka miwili mizima Farao akaota ndoto. ");
INSERT INTO swhulb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tazama, alikuwa amesimama kando ya Nile. Tazama, ng'ombe saba wakatoka katika mto Nile, wakupendeza na wanene, na wakajilisha katika nyasi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tazama, ng'ombe wengine saba wakatoka katika Nile baada yao, wasiopendeza na wamekondeana. Wakasimama ukingoni mwa mto kando ya wale ng'ombe wengine. ");
INSERT INTO swhulb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kisha wale ng'ombe wasiopendeza na waliokonda wakawala wale waliokuwa wanapendeza na walionenepa. ");
INSERT INTO swhulb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kisha Farao akaamka. Kisha akalala na kuota mara ya pili. Tazama, masuke saba ya nafaka yalichipua katika mche mmoja, mema na mazuri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tazama, masuke saba, membamba na yaliyokaushwa na upepo wa mashariki, yakachipua baada yake. ");
INSERT INTO swhulb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Masuke membamba yakayameza yale masuke saba mema yote. Farao akaamka, na, tazama, ilikuwa ni ndoto tu. ");
INSERT INTO swhulb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ikawa wakati wa asubuhi roho yake ikafadhaika. Akatuma na kuwaita waganga na wenye hekima wote wa Misri. Farao akawasimlia ndoto zake, lakini hakuna aliyeweza kumtafsiria Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kisha mkuu wa wanyweshaji akamwambia Farao, “Leo ninayafikiri makosa yangu. ");
INSERT INTO swhulb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao aliwakasirikia watumishi wake, na kutuweka kifungoni katika nyumba ya kapteni wa walinzi, mkuu wa waokaji na mimi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tuliota ndoto usiku huo mmoja, yeye na mimi. Kila mmoja aliota kwa kadili ya tafsiri yake. ");
INSERT INTO swhulb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Pamoja nasi kulikuwa na kijana Mwebrania, mtumishi wa kapteni wa walinzi. Tulimwambia na akatutafsiria ndoto zetu. Alitutafsiria kila mmoja wetu kulingana na ndoto yake. ");
INSERT INTO swhulb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ikawa kama alivyotutafsiria, ndivyo ilivyokuwa. Farao alinirudisha katika nafasi yangu, lakini akamtundika yule mwingine.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ndipo Farao alipotuma na kumwita Yusufu. Kwa haraka wakamtoa gerezani. Akajinyoa mwenyewe, akabadili mavazi yake, na akaingia kwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao akamwambia Yusufu, “Nimeoda ndoto, lakini hakuna wa kuitafsiri. Lakini nimesikia kuhusu wewe, kwamba unaposikia ndoto unaweza kuitafsiri.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu akamjibu Farao, kusema, “Siyo katika mimi. Mungu atamjibu Farao kwa uhakika.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farao akamwambia Yusufu, “Katika ndoto yangu, tazama, nilisimama katika ukingo wa Nile. ");
INSERT INTO swhulb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tazama, ng'ombe saba wakatoka ndani ya Nile, wanene na wakuvutia, nao wakajilisha katika nyasi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tazama, ng'ombe wengine saba wakapanda baada yao, dhaifu, wabaya, na wembaba. Sijawao kuona wabaya kama hao katika nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Wale ng'ombe wembamba na wabaya wakawala wale ng'ombe saba na wanene. ");
INSERT INTO swhulb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Walipokuwa wamemaliza kuwala wote, haikujulikana kama walikuwa wamewala, kwani walibaki wabaya kama mwanzo. Kisha nikaamka. ");
INSERT INTO swhulb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Niliona katika ndoto yangu, na tazama, masuke saba yakatoka katika bua moja, jema na limejaa. ");
INSERT INTO swhulb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tazama, masuke saba zaidi, yaliyonyauka, membamba na yamekaushwa na upepo wa mashariki, yakachipua baada yake. ");
INSERT INTO swhulb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yale masuke membamba yakayameza masuke saba mema. Niliwaambia waganga ndoto hizi, lakini hakuna aliyeweza kunielezea.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu akamwambia Farao, “Ndoto za Farao ni moja. Mungu amemwambia Farao kuhusu jambo analokwenda kulifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Wale ng'ombe saba wema ni miaka saba, na masuke saba mema ni miaka saba. Ndoto ni moja. ");
INSERT INTO swhulb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na wale ng'ombe saba wembamba na wabaya waliokuja baadaye ni miaka saba, na pia masuke saba membamba yaliyokaushwa na upepo wa mashariki itakuwa miaka saba ya njaa. ");
INSERT INTO swhulb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Hilo ni jambo nililomwambia Farao. Mungu amemfunulia Farao jambo analokwenda kulifanya. ");
INSERT INTO swhulb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tazama, miaka saba yenye utele mwingi inakuja katika nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na miaka saba ya njaa itakuja baada yake, na utele wote katika nchi ya Misri utasahaulika, na njaa itaiaribu nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Utele hautakumbukwa katika nchi kwa sababu ya njaa itakayofuata, kwa kuwa itakuwa kali sana. ");
INSERT INTO swhulb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kwamb ndoto ilijirudia kwa Farao sababu ni kwamba jambo hili limeanzishwa na Mungu, na Mungu atalitimiza hivi karibuni. ");
INSERT INTO swhulb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Basi Farao atafute mtu mwenye maharifa na busara, na kumweka juu ya nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao na afanye hivi: achague wasimamizi juu ya nchi. Na wachukue sehemu ya tano ya mazao ya Misri katika miaka saba ya shibe. ");
INSERT INTO swhulb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Na wakusanye chakula chote cha hii miaka myema ijayo na kuitunza nafaka chini ya mamlaka ya Farao, kwa chakula kutumika katika miji. Wakiifadhi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chakula kitakuwa matumizi ya nchi kwa miaka saba ya njaa itakayokuwa katika nchi ya Misri. Kwa njia hii nchi haitaaribiwa na njaa.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ushauri huu ukawa mwema machoni pa Farao na machoni pa watumishi wake wote. ");
INSERT INTO swhulb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farao akawambia watumishi wake, “Je tunaweza kumpata mtu kama huyu, ambaye ndani yake kuna Roho wa Mungu?” ");
INSERT INTO swhulb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hivyo Farao akamwambia Yusufu, “Kwa vile Mungu amekuonesha yote haya, hakuna mtu mwenye ufahamu na busara kama wewe. ");
INSERT INTO swhulb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Utakuwa juu ya nyumba yangu, watu wangu watatawaliwa kwa kadili ya neno lako. Katika kiti cha enzi peke yake mimi nitakuwa mkuu kuliko wewe.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao akamwambia Yusufu, “Tazama, nimekuweka juu ya nchi yote ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao akavua pete yake ya mhuri kutoka katika mkono wake na kuiweka katika mkono wa Yusufu. Akamvika kwa mavazi ya kitani safi, na kuweka mkufu wa dhahabu shingoni mwake. ");
INSERT INTO swhulb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Akataka apandishwe katika kibandawazi cha pili alichokuwa nacho. Watu wakapiga kelele mbele yake, “Pigeni magoti.” Farao akamweka juu ya nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao akamwambia Yusufu, “Mimi ni Farao, mbali na wewe, hakuna mtu atakayeinua mkono wake au mguu wake katika nchi ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao akamwita Yusufu jina la Zafenathi Panea.” Akampa Asenathi, binti wa Potifera kuhani wa On, kuwa mke wake. Yusufu akaenda juu ya nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu alikuwa na umri wa miaka thelathini aliposimama mbele ya Farao, mfalme wa Misri. Yusufu akatoka mbele ya Farao, na kwenda katika nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Katika miaka saba ya shibe nchi ilipozaa kwa wingi. ");
INSERT INTO swhulb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Akakusanya chakula chote cha miaka saba iliyokuwako katika nchi ya Misri na kukiweka chakula katika miji. Akaweka katika kila mji chakula cha mashamba yaliyokizunguka. ");
INSERT INTO swhulb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu akahifadhi nafaka kama mchanga wa bahari, kingi kiasi kwamba akaacha kuhesabu, kwa sababu kilikuwa hakihesabiki. ");
INSERT INTO swhulb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kabla miaka ya njaa kuingia Yusufu akapata wana wawili, ambao Asenathi, binti wa Potifera kuhani wa On, alimzalia. ");
INSERT INTO swhulb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu akamwita mzaliwa wake wa kwanza Manase, kwani alisema, “Mungu amenisahaurisha shida zangu zote na nyumba yote ya baba yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Akamwita mwanawe wa pili Efraimu, kwani alisema, Mungu amenipa uzao katika nchi ya mateso yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Miaka saba ya shibe iliyokuwa katika nchi ya Misri ikafika mwisho. ");
INSERT INTO swhulb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Miaka saba ya njaa ikaanza, kama alivyokuwa amesema Yusufu. Kulikuwa na njaa katika nchi zote, lakini katika nchi yote ya Misri kulikuwa na chakula. ");
INSERT INTO swhulb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nchi yote ya Misri ilipokuwa na njaa, watu wakapiga kelele kwa Farao kwa ajili ya chakula. Farao akawambia Wamisri wote, “Nendeni kwa Yusufu na mfanye atakavyosema.” ");
INSERT INTO swhulb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Njaa ilikuwa juu ya uso wote wa nchi. Yusufu akafungua ghala zote na kuuza chakula kwa Wamisri. Njaa ilikuwa kali sana katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Dunia yote ikaja Misri kununua nafaka kutoka kwa Yusufu, kwani njaa ilikuwa kali katika dunia yote. ");
INSERT INTO swhulb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Basi Yakobo akafahamu kwamba kuna nafaka huko Misri. Akawambia wanawe, “Kwa nini mnatazamana? ");
INSERT INTO swhulb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Akasema, “Tazama, nimesikia kwamba kuna nafaka huko Misri. Shukeni huko mkatununulie chakula ili tuishi wala tusife.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ndugu kumi wa Yusufu wakashuka Misri kununua chakula. ");
INSERT INTO swhulb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lakini Benjamini, ndugu wa Yusufu, Yakobo hakumtuma na ndugu zake, kwani alihofu kwamba madhara yaweza kumpata. ");
INSERT INTO swhulb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Wana wa Israeli wakaja kununua miongoni mwao waliokuja, kwani njaa ilikuwapo katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Basi Yusufu alikuwa mtawala juu ya nchi. Ndiye aliyekuwa akiwauzia watu wote wa nchi. Ndugu zake Yusufu wakaja na kumwinamia na nyuso zao hata chini. ");
INSERT INTO swhulb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu akawaona ndugu zake na kuwatambua, lakini alijibadili kwao na kuongea nao kwa ukali. Akawambia, “Mmetoka wapi?” Wakasema, “Kutoka nchi ya Kanaani ili kununua chakula.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu akawatambua ndugu zake, lakini wao hawakumtambua. ");
INSERT INTO swhulb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu akazikumbuka ndoto aliyoziota kuhusu wao. Akawambia, “Ninyi ni wapelelezi. Mmekuja kuona sehemu za nchi zisizolindwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wakamwambia, “Hapana, bwana wangu. Watumishi wako wamekuja kununua chakula. ");
INSERT INTO swhulb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sisi sote ni wana wa baba mmoja. Ni watu wa kweli. Watumishi wako siyo wapelelezi.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Akawambia, “Hapana, mmekuja kuangalia sehemu za nchi zisizolindwa.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wakasema, “Sisi watumishi wako tupo ndugu kumi na wawili, wana wa baba mmoja katika nchi ya Kanaani. Tazama, mdogo yupo na baba yetu, na mwingine hayupo hai tena.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu akawambia, “Ndivyo nilivyowambia; ninyi ni wapelelezi. ");
INSERT INTO swhulb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mtajaribiwa kwa njia hii. Kama aishivyo Farao, hamtaondoka hapa, mdogo wenu asipokuja hapa. ");
INSERT INTO swhulb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mtumeni mmoja wenu amlete mdogo wenu. Mtabaki gerezani, hata maneno yenu yatakapothibitishwa, kwamba kuna ukweli ndani yenu.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Akawaweka kifungoni kwa siku tatu. ");
INSERT INTO swhulb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Katika siku ya tatu Yusufu akaongea nao, “Fanyeni hivi nanyi mtaishi, kwani ninamcha Mungu. ");
INSERT INTO swhulb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kama ninyi ni watu wa kweli, mmoja wenu atazuiliwa hapa gerezani, lakini ninyi nendeni, chukueni nafaka kwa ajili ya nyumba zenu. ");
INSERT INTO swhulb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mleteni mdogo wenu kwangu ili kwamba maneno yenu yathibitishwe nanyi hamtakufa.” Wakafanya hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wakasemezana wao kwa wao, “Kwa kweli tuna hatia juu ya ndugu yetu kwani tuliona tabu ya nafsi yake alipotusihi nasi hatukusikia. Kwa hiyo taabu hii imeturudia.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni akawajibu, “Je sikuwambia, 'Msitende dhambi juu ya kijana,' lakini hamkusikia? Basi, tazama, damu yake inatakiwa juu yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Lakini hawakuja kwamba Yusufu anawaelewa, kwani kulikuwa na mkalimani kati yao. ");
INSERT INTO swhulb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Akatoka kwao na kulia. Akarudi kwao na kuongea nao. Akamchukua Simoni miongoni mwao na kumfunga mbele ya macho yao. ");
INSERT INTO swhulb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kisha Yusufu akaagiza watumishi kujaza mifuko yao kwa nafaka, na kurudisha pesa ya kila mmoja katika gunia lake, nakuwapa mahitaji kwa safari. Wakatendewa hivyo. ");
INSERT INTO swhulb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hawa ndugu wakapandisha chakula chao juu ya punda zao na kuondoka pale. ");
INSERT INTO swhulb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mmoja wao alipofungua gunia lake ili kumlisha punda wao katika sehemu waliyokuwa, akaona pesa yake. Tazama, ilikuwa mdomoni mwa gunia lake. ");
INSERT INTO swhulb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Akawambia ndugu zake, “Pesa yangu imerudishwa. Tazama, imo katika gunia langu.”Mioyo yao ikazimia na wakageukiana kila mmoja huku wakitetemeka. Wakasema, “Ni nini hiki alichotutendea Mungu?” ");
INSERT INTO swhulb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wakaenda kwa Yakobo, baba yao katika nchi ya Kanaani na kumwambia yote yaliyowapata. ");
INSERT INTO swhulb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wakasema, “Yule mtu, bwana wa nchi, aliongea nasi kwa ukali na kutudhania kuwa wapelelezi katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tukamwambia, 'Tu watu wa kweli sisi. Sisi siyo wapelelezi. ");
INSERT INTO swhulb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tupo ndugu kumi na wawili, wana wa baba yetu. Mmoja hayupo hai tena, na mdogo yupo na baba yetu katika nchi ya Kanaani.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yule mtu, bwana wa nchi, akatwambia, 'Kwa hili nitajua kwamba ni watu wa kweli ninyi. Mwacheni mmojawapo wa ndugu zenu, chukueni chakula kwa ajili ya njaa katika nyumba zenu, na mwondoke. ");
INSERT INTO swhulb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mleteni mdogo wenu kwangu. Ndipo nitakapojua kwamba ninyi si wapelelezi, lakini ni watu wa kweli. Kisha nitamwachilia ndugu yenu, na mtafanya biashara katika nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ikawa walipoyafungua magunia yao, na tazama, kila mfuko wa fedha wa mmojawao ulikuwa katika gunia lake. Wakati wao na baba yao walipoona mifuko yao ya fedha, wakaogopa. ");
INSERT INTO swhulb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo baba yao akawambia, “Mmeniharibia watoto wao. Yusufu hayupo hai tena, Simoni ameondoka, nanyi mmpeleke Benjamini naye. Mambo haya yote ni kunyume changu.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeni akamwambia baba yake, kusema, “Unaweza kuwaua wanangu wawili nisipomrudisha Benjamini kwako. Mweke mikononi mwangu, nami nitamrudisha tena kwako.” ");
INSERT INTO swhulb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakobo akasema, “Mwanangu atashuka pamoja nanyi. Kwani ndugu yake amekufa na yeye peke yake amebaki. Ikiwa madhara yatampata katika njia mnayoiendea, ndipo mtakapozishusha mvi zangu kaburini kwa huzuni.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Njaa ilikuwa kali katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ikawa walipokuwa wametumia chakula chote walichokitoa Misri, baba yao akawambia, “Nendeni tena; mtununulie chakula.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda akamwambia, “Yule mtu alituonya kwa ukali, 'Hamtauona uso wangu ndugu yenu asipokuwa nanyi.' ");
INSERT INTO swhulb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ikiwa utamtuma ndugu yetu pamoja nasi, tutashuka na kuwanunulia chakula. ");
INSERT INTO swhulb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Lakini usipompeleka, hatutashuka. Kwa maana yule mtu alitwambia, 'Hamtauona uso wangu ndugu yenu asipokuwa nanyi.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israeli akawambia, “Kwa nini mlinitendea mimi vibaya hivyo kwa kumwambia mtu huyo kwamba mnaye ndugu mwingine?” ");
INSERT INTO swhulb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wakasema, “Yule mtu alituuliza habari zetu na familia yetu kwa kina. Akasema, 'Je baba yenu bado yuko hai? Je mnaye ndugu mwingine?'Tukamjibu kulingana na maswali haya. Tungejuaje kwamba angetwambia, 'Mleteni ndugu yenu?” ");
INSERT INTO swhulb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda akamwambia Israeli baba yake, “Mtume kijana pamoja nami. Tutainuka na kwenda ili kwamba tuishi tusife, wote sisi, wewe, na hata watoto wetu. ");
INSERT INTO swhulb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mimi nitakuwa mdhamini wake. Utaniwajibisha mimi. Kama nisipomleta na kumweka mbele yako, basi nibebe lawama daima. ");
INSERT INTO swhulb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kwani kama tusingekawia, bila shaka hata sasa tungekuwa tumekwisha rudi mara ya pili.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Israeli baba yao akawambia, “Kama ni hivyo, basi fanyeni hivi. Chukueni baadhi ya mazao mazuri ya nchi katika mifuko yenu. Mchukulieni yule mtu zawadi: baadhi ya malhamu, asali, viungo na manemane, jozi na lozi. ");
INSERT INTO swhulb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Chukueni pesa mara mbili mikononi mwenu. Pesa iliyorudishwa katika magunia yenu, muichukue tena katika mikono yenu. Pengine walikosea. ");
INSERT INTO swhulb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mchukueni ndugu yenu pia. Inukeni na mwende tena kwa mtu yule. ");
INSERT INTO swhulb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mungu Mwenyezi na awape kuona rehema mbele ya huyo mtu, hivyo kwamba awafungulie ndugu yenu mwingine na Benjamini. Kama nikipotelewa na watoto, nimepotelewa.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Watu wale wakachukua zawadi hii, na katika mikono yao wakachukua mara mbili ya kiasi cha pesa, pamoja na Benjamini. Wakaamka na kushuka Misri na kusimama mbele ya Yusufu. ");
INSERT INTO swhulb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu alipomwona Benjamini akiwa nao, akamwambia mtunzaji wa nyumba yake, “Walete watu hao ndani ya nyumba, chinja mnyama na umwandae, kwani watu hawa watakula chakula cha mchana pamoja nami.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mtunzaji wa nyumba akafanya kama Yusufu alivyosema. Akawaleta wale watu nyumbani kwa Yusufu. ");
INSERT INTO swhulb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wale ndugu wakaogopa kwa vile walivyoletwa katika nyumba ya Yusufu. Wakasema, “Ni kwa sababu ya pesa iliyorudishwa katika magunia yetu mara ya kwanza tulipoletwa ndani, kwamba atafute nafasi kinyume chetu. Kwamba aweze kutukamata na kutuchukua kama watumwa, na kuchukua punda wetu.” Wakamsogelea mtunzaji wa nyumba ya Yusufu, ");
INSERT INTO swhulb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","nao wakaongea naye mlangoni mwa nyumba, ");
INSERT INTO swhulb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","wakisema, “Bwana wangu, tulikuja mara ya kwanza kununua chakula. ");
INSERT INTO swhulb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ikawa, tulipofika katika eneo la kupumzikia, tukafungua magunia yetu, na, tazama, pesa ya kila mtu ilikuwa katika gunia lake, pesa yetu kwa kiasi kamili. Tumeileta katika mikono yetu. ");
INSERT INTO swhulb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tumekuja na pesa nyingine pia mikonon mwetu ili kununua chakula. Hatujui aliyeziweka pesa katika magunia yetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mtunzaji wa nyumba akasema, “Amani iwe kwenu, msiogope. Mungu wenu na Mungu wa baba yenu ndiye aliyeweka pesa katika magunia yenu. Nilipokea pesa yenu.” Kisha mtunzaji wa nyumba akamleta Simoni kwao. ");
INSERT INTO swhulb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Msimamizi wa nyumba akawapeleka watu hao katika nyumba ya Yusufu. Akawapa maji, nao wakaosha miguu yao. Akawalisha punda wao. ");
INSERT INTO swhulb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wakaandaa zawadi kwa ajili ya Yusufu aliyekuwa akija mchana, kwani walikuwa wamesikia kwamba watakula pale. ");
INSERT INTO swhulb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu alipokuja nyumbani, wakaleta nyumbani zawadi iliyokuwa mikononi mwao, nao wakainama mbele yake hata chini. ");
INSERT INTO swhulb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Akawauliza juu ya hali zao na kusema,”Je baba yenu hajambo, yule mzee mliyemnena? Je bado yu hai?” ");
INSERT INTO swhulb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wakasema, “Mtumishi wako baba yetu hajambo. Na bado yu hai” Wakajinyenyekeza na kuinama chini. ");
INSERT INTO swhulb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Alipoinua macho yake akamwona Benjamini ndugu yake, mwana wa mamaye, naye akasema, “Je huyu ndiye mdogo wenu mliyemsema?” Na kisha akasema, “Mungu na awe mwenye neema kwako, mwanangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusufu akaharakisha kutoka chumbani, kwani aliguswa sana kuhusu nduguye. Akatafuta mahali pa kulia. Akaingia chumbani mwake na kulia umo. ");
INSERT INTO swhulb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Akaosha uso wake na kutoka nje. Akajizuia mwenyewe, akasema, “karibuni chakula.” ");
INSERT INTO swhulb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Watumishi wakamhudumia Yusufu peke yake na wale ndugu peke yao. Wamisri pale wakala pamoja naye peke yao kwa sababu Wamisri hawakuweza kula mkate na Waebrania, kwani hilo ni chukizo kwa Wamisri. ");
INSERT INTO swhulb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wale ndugu wakakaa mbele yake, mzaliwa wa kwanza kwa kulingana na haki yake ya uzaliwa, na mdogo kulingana na ujana wake. Wale watu wakashangaa wote. ");
INSERT INTO swhulb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufu akapeleka sehemu kwao kutoka katika chakula kilichokuwa mbele yake. Lakini sehemu ya Benjamini ilikuwa mara tano zaidi ya kila ndugu zake. Wakanywa na wakamfurahia. ");
INSERT INTO swhulb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu akamwamru msimamizi wa nyumba yake, akisema, “Jaza magunia ya watu hawa kwa chakula, kiasi wawezacho kubeba, na uweke pesa ya kila mtu katika mdomo wa gunia lake. ");
INSERT INTO swhulb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Uweke kikombe changu, cha fedha, katika mdomo wa gunia la mdogo, na pesa yake ya chakula pia.” Msimamizi akafanya kama Yusufu alivyosema. ");
INSERT INTO swhulb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kukapambazuka asubuhi, na wale watu wakaruhusiwa kuondoka, wao na punda zao. ");
INSERT INTO swhulb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Walipokuwa wametoka mjini lakini hawajafika mbali, Yusufu akamwambia msimamizi wa nyumba yake, “Inuka, uwafuatie wale watu, na utakapowapata, wambie, 'Kwa nini mmelipa uovu badala ya mema? ");
INSERT INTO swhulb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Je hiki siyo kikombe ambacho bwana wangu hukinywea, na kikombe akitumiacho kwa uaguzi? Mmefanya vibaya, kwa jambo hili mlilolifanya.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Msimamizi wa nyumba akawapata na kuwambia maneno haya. ");
INSERT INTO swhulb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wakasema, “Kwa nini bwana wetu anasema maneno kama haya? Na iwe mbali na watumishi wako kwamba wanaweza kufanya jambo hili. ");
INSERT INTO swhulb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tazama, pesa tulizozikuta katika midomo ya magunia yetu, tulizileta kwako kutoka katika nchi ya Kanaani. Ni kwa jinsi gani basi tunaweza kuiba katika nyumba ya bwana wako fedha au dhahabu? ");
INSERT INTO swhulb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yeyote kitakayeonekana kwake miongoni mwa watumishi wako, atakufa, nasi sote tutakuwa watumwa wa bwana wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Msimamizi akasema, “Basi na iwe kwa kadili ya maneno yenu. Yeye ambaye kikombe kitaonekana kwake atakuwa mtumwa wangu, nanyi wengine mtakuwa bila hatia.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kisha kila mtu akaharakisha na kulishusha gunia lake chini. na kila mtu akalifungua gunia lake. ");
INSERT INTO swhulb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Msimamizi akatafuta. akaanza na mkubwa wa wote na kumaliza kwa mdogo wa wote, na kikombe kikaonekana katika gunia la Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wakararua mavazi yao. Kila mtu akapakia juu ya punda wake nao wakarudi mjini. ");
INSERT INTO swhulb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na ndugu zake wakaja katika nyumba ya Yusufu. Bado alikuwepo pale, nao wakainama mbele zake hata chini. ");
INSERT INTO swhulb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu akawambia, “Je ni nini hili mlilolifanya? Je hamjui kwamba mtu kama mimi anafanya uaguzi. ");
INSERT INTO swhulb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda akasema, “Je tunaweza kumwambia nini bwana wangu? Tuseme nini? au ni jinsi gani twaweza kujithibitisha wenyewe? Mungu ameona uovu wa watumishi wako. Tazama, sisi ni watumwa wa bwana wangu, wote sisi na yule ambaye kikombe kimeonekana mkononi mwake.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu akasema, “Na iwe mbali nami kwamba naweza kufanya hivyo. Mtu ambaye kikombe kimeonekana mkononi mwake, huyu ndiye atakuwa mtumwa wangu, lakini ninyi wengine, nendeni kwa amani kwa baba yenu.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ndipo Yuda alipomkaribia na kusema, “Bwana wangu, tafadhari mwache mtumishi wako aseme neno katika masikio ya bwana wangu, na usiziache hasira zako kuwaka dhidi ya mtumishi wako, kwani wewe ni kama Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Bwana wangu aliwauliza watumishi wake, kusema, Je mnaye baba au ndugu?' ");
INSERT INTO swhulb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nasi tukamwambia bwana wangu, 'Tunaye baba, ni mzee, na mwana wa uzee wake, ni mdogo. Na ndugu yake alishakufa, na yeye peke yake ndiye amebaki kwa mama yake, na baba yake anampenda.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nawe ukawambia matumishi wako, 'Mleteni ili nimwone.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nasi tukamwambia bwana wangu, 'Kijana hawezi kumwacha babaye. Kwani akimwacha babaye baba yake angekufa.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Na ukawambia watumishi wako, 'Mdogo wenu asipokuja pamoja nanyi, hamtauona uso wangu tena.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na ikawa tulipokwenda kwa mtumishi wako baba yangu, tulimwambia maneno ya bwana wangu. ");
INSERT INTO swhulb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na baba yetu akasema, Nendeni tena, mkatununulie chakula.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nasi tukasema, “Hatuwezi kushuka. Ikiwa mdogo wetu atakuwa nasi, ndipo tutakaposhuka, kwani hatuwezi kuuona uso wa mtu yule mdogo wetu asipokuwa pamoja nasi.' ");
INSERT INTO swhulb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mtumishi wako baba yetu akatwambia, 'Mnajua kwamba mke wangu alinizalia wana wawili. ");
INSERT INTO swhulb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Na mmoja akatoka kwangu nami nikasema, “Bila shaka ameraruliwa vipande, na tangu hapo sijamwona.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nanyi mkimchukua huyu naye kutoka kwangu mabaya yanaweza kumpata, mtashusha mvi zangu kwa kaburini kwa huzuni. ");
INSERT INTO swhulb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kwa hiyo, basi, nitapokuja kwa mtumishi wako baba yangu, na kijana hayupo nasi, kwa kuwa uhai wake umefungamanishwa katika uhai wa kijana, ");
INSERT INTO swhulb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","itakuwa, atakapoona kwamba kijana hayupo nasi atakufa. Na watumishi wako watazishusha mvi za mtumishi wako baba yetu kaburini kwa masikitiko. ");
INSERT INTO swhulb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kwani mtumishi wako alikuwa mdhamini wa kijana kwa baba yangu na alisema, 'Ikiwa sitamleta kwako, ndipo nitakapokuwa mwenye hatia kwa baba yangu daima.” ");
INSERT INTO swhulb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kwa hiyo sasa, tafadhari mwache mtumishi wake akae kama mtumwa kwa bwana wangu badala ya kijana, na umwache kijana aende na ndugu zake. ");
INSERT INTO swhulb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kwa maana nitakwenda jinsi gani kwa baba yangu ikiwa kijana hayupo nami? Ninaogopa kuona mabaya yatakayompata baba yangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ndipo Yusufu hakuweza kujizuia mwenyewe mbele ya watumishi waliosimama kando yake. Akasema kwa sauti, “Kila mtu aondoke.” Hivyo hakuna mtumishi aliyesimama kando yake wakati Yusufu alipojitambulisha kwa ndugu zake. ");
INSERT INTO swhulb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Akalia kwa sauti, Wamisri wakasikia, na nyumba ya Farao wakasikia kuhusu hilo. ");
INSERT INTO swhulb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu akawambia ndugu zake, “Mimi ni Yusufu. Je baba yangu ni mzima bado? Ndugu zake hawakuweza kumjibu, kwani walitishwa na uwepo wake. ");
INSERT INTO swhulb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kisha Yusufu akawambia ndugu zake, “Nikaribieni, tafadhari.” Nao wakasogea. Akawambia, “Mimi ni Yusufu ndugu yenu, mliyemwuza Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Lakini sasa msihuzunike au kukasirika miongoni mwenu kwamba mliniuza huku, kwani Mungu alinituma mbele yenu ili kutunza uhai. ");
INSERT INTO swhulb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Maana ni miaka miwili njaa imekuwa katika nchi, na bado kuna miaka mitano ambayo hakutakuwa na kulima wala kuvuna. ");
INSERT INTO swhulb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mungu alinituma mbele yenu kuwahifadhi kama masalia duniani, na kuwaweka hai kwa ukombozi mkuu. ");
INSERT INTO swhulb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hivyo si ninyi mlionipeleka huku bali ni Mungu, na amenifanya baba kwa Farao, bwana wa nyumba yake yote, na mtawala wa nchi yote ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Fanyeni haraka mwende kwa baba yangu na mmwambie, 'Hivi ndivyo asemavyo Yusufu mwanao, “Mungu amenifanya bwana kwa Wamisri wote. Shuka kwangu, usikawie. ");
INSERT INTO swhulb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Utaishi katika nchi ya Gosheni, nawe utakuwa karibu nami, wewe na watoto wako na watoto wa watoto wako, na kondoo wako na mbuzi wako, na yote uliyonayo. ");
INSERT INTO swhulb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nami nitakuhudumia pale, kwa maana bado kuna miaka mitano ya njaa, hivyo usije ukaingia katika uhitaji, wewe, nyumba yako, na yote uliyonayo.” ");
INSERT INTO swhulb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tazama, macho yenu yanaona, na macho ya Benjamini ndugu yangu, kwamba ni kinywa changu kinachoongea nanyi. ");
INSERT INTO swhulb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mtamwambia baba yangu juu ya heshima yangu yote huku Misri na yote mliyoyaona. Mtaharakisha na kumleta baba yangu huku.” ");
INSERT INTO swhulb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Akaikumbatia shingo ya Benjamini ndugu yake na kulia, na Benjamini akalia shongoni mwake. ");
INSERT INTO swhulb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Akawabusu ndugu zake wote na kulia kwa ajili yao. Baada ya hayo ndugu zake wakaongea naye. ");
INSERT INTO swhulb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Habari ya jambo hili ikasemwa katika nyumba ya Farao: “Ndugu zake Yusufu wamekuja.” Ikampendeza sana Farao na watumishi wake. ");
INSERT INTO swhulb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao akamwambia Yusufu, “Wambie ndugu zako, 'Fanyeni hivi: Wapakieni wanyama wenu na mwende katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mchukueni baba yenu na nyumba zenu mnijie. Nami nitawapa mema ya nchi ya Misri, nanyi mtakula unono wa nchi.' ");
INSERT INTO swhulb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Basi mmeamriwa, 'Fanyeni hivi, chukueni mikokoteni kutoka Misri kwa ajili ya watoto wenu na kwa ajili ya wake zenu. Mchukueni baba yenu na kuja. ");
INSERT INTO swhulb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Msijari kuhusu mali zenu, kwani mema yote ya nchi ya Misri ni yenu.” ");
INSERT INTO swhulb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Wana wa Israeli wakafanya hivyo. Yusufu akawapa mikokoteni, kwa kadili ya agizo la Farao, na akawapa mahitaji ya safari. ");
INSERT INTO swhulb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Akawapa wote mavazi ya kubadilisha, lakini akampa Benjamini vipande mia tatu vya fedha na mavazi matano ya kubadilisha. ");
INSERT INTO swhulb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Akampelekea baba yake: punda kumi waliobeba mema ya Misri, punda majike kumi wamebeba nafaka, mikate, na mahitaji mengine kwa baba yake kwa ajili ya safari. ");
INSERT INTO swhulb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Hivyo akawaruhusu ndugu zake nao wakaondoka. Akawambia, “Angalieni msijemkagombana njiani.” ");
INSERT INTO swhulb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wakapanda kutoka Misri na kuja katika nchi ya Kanaani, kwa Yakobo baba yao. ");
INSERT INTO swhulb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wakamwambia “Yusufu bado yu hai, na ndiye mtawala juu ya nchi yote ya Misri.” Na moyo wake ulishikwa na ushangao, kwani hakuwaamini. ");
INSERT INTO swhulb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wakamwambia maneno yote ya Yusufu aliyokuwa amewambia. Yakobo alipoona mikokoteni Yusufu aliyokuwa amepeleka kuwabeba, roho ya Yakobo baba yao ikafufuka. ");
INSERT INTO swhulb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israeli akasema, “Inatosha. Yusufu mwanangu yu hai. Nitakwenda nikamwone kabla sijafa.” ");
INSERT INTO swhulb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israeli akasafiri na yote aliyokuwa nayo na akaja Beersheba. Pale akatoa sadaka kwa Mungu wa Isaka baba yake. ");
INSERT INTO swhulb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mungu akamwambia Israeli katika ndoto usiku, akisema, “Yakobo, Yakobo.” ");
INSERT INTO swhulb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Akasema, “Mimi hapa.” Akasema, “Mimi ni Mungu, Mungu wa baba yako. Usiogope kushuka Misri, kwa maana nitakufanya taifa kubwa huko. ");
INSERT INTO swhulb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nitakwenda pamoja nawe huko Misri, Nami nitakupandisha huku tena bila shaka. Na Yusufu akayafunika macho yako kwa mikono wake.” ");
INSERT INTO swhulb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakobo akainuka kutoka Beersheba. Wana wa Israeli wakamsafirisha Yakobo baba yao, watoto wao, na wake wao, katika mikokotene ambayo Farao alikuwa ameipeleka kuwachukua. ");
INSERT INTO swhulb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wakachukua mifugo yao na mali zao walizokuwa wamezipata katika nchi ya Kanaani. Wakaja Misri, Yakobo na uzao wake wote pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Akaja Misri pamoja na wanawe na wana wa wanawe, binti zake na wana wa binti zake, na uzao wake wote. ");
INSERT INTO swhulb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Haya ni majina ya watoto wa Israeli waliokuja Misri, Yakobo na wanawe: Rubeni, mzaliwa wa kwanza wa Yakobo; ");
INSERT INTO swhulb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","wana wa Rubeni Hanoki na Palu na Hezroni na Karmi; ");
INSERT INTO swhulb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","wana wa Simoni, Yemueli, Yamini, Ohadi, Yakini, Zohari, na Shauli, wana wa mwanamke Mkanaani; ");
INSERT INTO swhulb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","wana wa Lawi Gershoni, Kohathi, na Merari. ");
INSERT INTO swhulb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wana wa Yuda: Eri, Shela, Peresi, na Zera, (Lakini Eri na Onani walikufa katika nchi ya Kanaani). Na wana wa Peresi walikuwa Hezroni na Hamuli. ");
INSERT INTO swhulb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wana wa Isakari walikuwa Tola, Puva, Lobu, na Shimroni; ");
INSERT INTO swhulb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wana wa Zabuloni walikuwa Seredi, Eloni, na Yahleeli ");
INSERT INTO swhulb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hawa walikuwa wana wa Lea aliomzalia Yakobo huko Padani Aramu, pamoja na na Dina binti yake. Wanawe na binti zake walikuwa thelathini na watatu. ");
INSERT INTO swhulb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wana wa Gadi walikuwa Zifioni, Hagi, Shuni, Ezboni, Eri, Arodi, na Areli. ");
INSERT INTO swhulb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wana wa Asheri walikuwa Imna, Ishva, Ishvi, na Beria; na Sera alikuwa dada yao. Wana wa Beria walikuwa Heberi na Malkieli. ");
INSERT INTO swhulb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hawa walikuwa wana wa Zilpa, ambaye Labani alikuwa amempa Lea binti yake. Wana aliomzalia Yakobo wote walikuwa kumi na sita. ");
INSERT INTO swhulb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Wana wa Raheli mkewe Yakobo walikuwa Yusufu na Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Huko Misri Manase na Efraimu walizaliwa kwa Yusufu na Asenathi, binti Potifera kuhani wa Oni. ");
INSERT INTO swhulb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wana wa Benjamini walikuwa Bela, Bekeri, Ashbeli, Gera, Naamani, Ehi, Roshi, Mupimu, Hupimu, na Ardi. ");
INSERT INTO swhulb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hawa walikuwa wana wa Raheli waliozaliwa kwa Yakobo - jumla yao kumi na wanne. ");
INSERT INTO swhulb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana wa Dani alikuwa Hushimu. ");
INSERT INTO swhulb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wana wa Naftali walikuwa Yahzeeli, Guni, Yezeri, na Shilemi. ");
INSERT INTO swhulb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hawa walikuwa wana Bilha aliomzalia Yakobo, ambaye Labani alimpa Raheli binti yake - wote walikuwa saba. ");
INSERT INTO swhulb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wate waliokwenda na Yakobo, waliokuwa uzao wake, bila kuhesabu wake wa wana wa Yakobo walikuwa sitini na sita. ");
INSERT INTO swhulb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pamoja na wana wawili wa Yusufu waliozaliwa kwake huko Misri, watu wa familia yake waliokwenda Misri walikuwa sabini jumla yao. ");
INSERT INTO swhulb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo akamtuma Yuda kuwatangulia mbele kwa Yusufu kuonesha njia mbele yake kwenda Gosheni, nao wakaja katika eneo la Gosheni. ");
INSERT INTO swhulb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu akaandaa kibandawazi chake na akaenda kumlaki baba yake huko Gosheni. Akamwona, akaikumbatia shingo yake, na akalia shingoni mwake kwa kitambo. ");
INSERT INTO swhulb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israeli akamwambia Yusufu, “Basi na nife sasa, kwa kuwa nimeuona uso wako, kwamba bado uko hai.” ");
INSERT INTO swhulb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu akawambia ndungu zake na nyumba ya baba yake, “Nitakwenda na kumwambia Farao, kusema, 'Ndugu zangu na nyumba ya baba yangu, waliokuwa katika nchi ya Kanaani, wamenijia. ");
INSERT INTO swhulb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Watu hawa ni wafugaji, kwani wamekuwa watunza wanyama. Wamekuja na makundi yao ya kondoo, na mbuzi, na vyote walivyonavyo.' ");
INSERT INTO swhulb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Itakuwa, Farao atakapowaita na kuwauliza, 'Kazi yenu ni ipi?' ");
INSERT INTO swhulb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mwambieni, 'Watumishi wako wamekuwa watunza wanyama tangu ujana wetu mpaka sasa, sisi, na baba zetu.' Fanyeni hivyo ili mweze kuishi katika nchi ya Gosheni, kwani kila mfugaji ni chukizo kwa Wamisri.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kisha Yusufu akaingia kwa Farao na kumwambia, “Baba yangu na ndugu zangu, kondoo wao, mbuzi wao, na yote waliyonayo, wamefika kutoka katika nchi ya Kanaani. Tazama, wapo katika nchi ya Gosheni.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Akawachukua watano katika ndugu zake na kuwatambulisha kwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao akawambia ndugu zake, “Kazi yenu ni nini?” Wakamwambia Farao, “Watumishi wako ni wafugaji, kama mababu zetu.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kisha wakamwambia Farao, “Tumekuja kukaa kwa muda katika nchi. Hakuna malisho kwa ajili ya makundi ya watumishi wako, kwa maana njaa ni kali sana katika nchi ya Kanaani. Hivyo, tafadhari waache watumishi wako wakae katika nchi ya Gosheni.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kisha Farao akamwambia Yusufu, kusema, “Baba yako na ndugu zako wamekuja kwako. ");
INSERT INTO swhulb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Nchi ya Misri iko mbele yako. Mkalishe baba yako na ndugu zako katika eneo zuri, nchi ya Gosheni. Ikiwa unafahamu watu wenye uwezo miongoni mwao, uwaweke kuwatunza wanyama wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kisha Yusufu akamwingiza Yakobo baba yake na kumweka mbele ya Farao. Yakobo akambariki Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao akamwambia Yakobo, “Umeishi kwa muda gani?” ");
INSERT INTO swhulb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo akamwambia Farao, “Miaka ya safari zangu ni mia moja na thelathini. Miaka ya maisha yangu imekuwa mifupi na ya maumivu. Siyo kama miaka ya baba zangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kisha Yakobo akambariki Farao na kuondoka mbele zake. ");
INSERT INTO swhulb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kisha Yusufu akamweka baba yake na ndugu zake. Akawapa eneo katika nchi ya Misri, sehemu nzuri sana ya nchi, katika eneo la Ramesesi, kama Farao alivyokuwa ameagiza. ");
INSERT INTO swhulb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu akamhudumia baba yake kwa chakula, ndugu zake, na nyumba yote ya baba yake, kulingana na hesabu ya wahitaji wao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Basi hakukuwa na chakula katika nchi yote; kwani njaa ilikuwa kali sana. Nchi ya Misri na nchi ya Kanaani ikaharibika kwa sababu ya njaa. ");
INSERT INTO swhulb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu akakusanya pesa yote iliyokuwa katika nchi ya Misri na nchi ya Kanaani, kwa kuwauzia wakaaji wake chakula. Kisha Yusufu akaleta ile pesa katika kasri la Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pesa yote ya nchi za Misri na Kanaani ilipokwisha, Wamisri wote wakaja kwa Yusufu wakisema, “Tupe chakula! Kwa nini tufe mbele zako kwa maana pesa yetu imekwisha?” ");
INSERT INTO swhulb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu akasema, “Ikiwa pesa yenu imekwisha, leteni wanyama wenu nami nitawapa chakula badala ya wanyama wenu.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hivyo wakaleta wanyama wao kwa Yusufu. Yusufu akawapa chakula kwa kubadilishana na farasi, kondoo, mbuzi na kwa punda. Akawalisha kwa mkate kwa kubadilisha na wanyama wao mwaka ule. ");
INSERT INTO swhulb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka ule ulipokwisha, wakaja kwake mwaka uliofuata na kumwambia, “Hatutaficha kwa bwana wangu kwamba pesa yetu yote imekwisha, na wanyama ni wa bwana wangu. Hakuna kilichobaki mbele za bwana wangu, isipokuwa miili yetu na nchi yetu. ");
INSERT INTO swhulb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kwa nini tufe mbele za macho yake, sisi na nchi yetu? Utununue sisi na nchi yetu badala ya chakula, na sisi na nchi yetu tutakuwa watumishi wa Farao. Tupe mbegu ili kwamba tuishi na tusife, na kwamba nchi isiwe tupu bila watu. ");
INSERT INTO swhulb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hivyo Yusufu akamnunulia Farao nchi yote ya Misri. Kwani kila Mmisri akauza shamba lake, kwa sababu njaa ilikuwa kali sana. Kwa njia hii, nchi ikawa mali ya Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Na watu, akawafanya kuwa watumwa kutoka mpaka mmoja wa Misri hata mkapa mwingine. ");
INSERT INTO swhulb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ilikuwa ni nchi ya makuhani pekee ambayo Yusufu hakuinunua, kwa maana makuhani walikuwa wakipewa posho. Walikula katika sehemu aliyowapa Farao. Kwa hiyo hawakuuza nchi yao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kisha Yusufu akawambia watu, “Tazama, nimewanunua ninyi na nchi yenu leo kwa ajili ya Farao. Basi mbegu hii hapa kwa ajili yenu, nanyi mtapanda katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Wakati wa mavuno, mtampa Farao sehemu ya tano, na sehemu nne zitakuwa zenu, kwa mbegu za shamba na kwa chakula cha nyumba zenu na watoto wenu.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wakasema, “Umeokoa maisha yetu. Na tupate kibali machoni pako. Tutakuwa watumishi wa Farao.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hivyo Yusufu akaifanya kuwa sheria inayofanya kazi hata leo katika nchi ya Misri, kwamba moja ya tano ni ya Farao. Eneo la makuhani peke yake ndo halikufanywa kuwa la Farao. ");
INSERT INTO swhulb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hivyo Israeli akaishi katika nchi ya Misri, katika eneo la Gosheni. Watu wake wakapata umiliki pale. Walikuwa wenye kuzaa na kuongezeka sana. ");
INSERT INTO swhulb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo akaishi katika nchi ya Misri miaka kumi na saba, kwa hiyo miaka ya maisha ya Yakobo ilikuwa miaka mia moja arobaini na saba. ");
INSERT INTO swhulb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wakati wa kufa kwake Yakobo ulipokaribia, alimwita Yusufu mwanaye na kumwambia, “Ikiwa nimepata kibali mbele zako, weka mkono wako chini ya paja langu, na unitendee kwa uaminifu na kweli. Tafadhari usinizike Misri. ");
INSERT INTO swhulb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nitakapolala na baba zangu, utanitoa Misri na kunizika katika eneo la kuzikia la baba zangu.” Yusufu akasema, “Nitafanya kama ulivyosema.” ");
INSERT INTO swhulb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israeli akasema, “Niapie,” na Yusufu akamwapia. Kisha Israeli akainama chini mbele ya kitanda chake. ");
INSERT INTO swhulb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ikawa baada ya mambo haya, mmojawapo akamwambia Yusufu, “Tazama, baba yako ni mgonjwa.” Hivyo akaondoka pamoja na wanawe wawili, Manase na Efrahimu. ");
INSERT INTO swhulb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo alipoambiwa, “Tazama, mwanao Yusufu amekuja kukuona,” Israeli akakusanya nguvu na kukaa juu ya kitanda. ");
INSERT INTO swhulb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo akamwambia Yusufu, Mungu Mwenyezi alinitokea huko Luzu katika nchi ya Kanaani. Akanibariki na ");
INSERT INTO swhulb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","kuniambia, 'Tazama, nitakupa uzao mwingi, na kukuzidisha. Nitakufanya kuwa kusanyiko la mataifa. Nitakupa nchi hii wewe na uzao wako kuwa milki ya milele.' ");
INSERT INTO swhulb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na sasa wanao wawili, waliozaliwa kwako katika nchi ya Misri kabla sijaja Misri, ni wangu. Efrahimu na Manase watakuwa wangu, kama walivyo Rubeni na Simioni. ");
INSERT INTO swhulb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Watoto utakaowapata baada ya hapo ni wako; watahesabiwa katika majina ya ndugu zao katika urithi wao. ");
INSERT INTO swhulb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Lakini kwangu mimi, nilipokuja kutoka Padani, kwa uzuni yangu Raheli alikufa njiani katika nchi ya Kanaani, wakati kungalipo kitambo kwenda Efrathi. Nilimzika pale katika njia iendayo Efrathi” (ndio, Bethlehemu). ");
INSERT INTO swhulb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israeli alipowaona wana wa Yusufu, akasema, “Ni nani hawa?” ");
INSERT INTO swhulb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu akamwambia baba yake, “Hawa ni wanangu, Mungu alionipa hapa:” Israeli akasema, “Walete kwangu, kwamba niwabariki.” ");
INSERT INTO swhulb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Basi macho ya Israeli yalikuwa yanashindwa kwa ajili ya umri wake, hivyo hakuweza kuona. Hivyo Yusufu akawasogeza karibu yake, na akawabusu na kuwakumbatia. ");
INSERT INTO swhulb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israeli akamwambia Yusufu, “Sikutazamia kuuona uso wako tena, Lakini Mungu ameniruhusu kuwaona hata wanao.” ");
INSERT INTO swhulb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu akawaondoa kati ya magoti ya Israeli, na kisha akainama na uso wake juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu akawachukua wote wawili, Efrahimu katika mkono wake wa kulia kuelekea mkono wa kushoto wa Israeli, na Manase katika mkono wake wa kulia kuelekea mkono wa kulia wa Israeli, na akawasogeza kwake. ");
INSERT INTO swhulb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israeli akainua mkono wake wa kulia na kuuweka juu ya kichwa cha Efrahimu, aliyekuwa mdogo, na mkono wake wa kushoto juu ya kichwa cha Manase. Akaipishanisha mikono yake, kwani Manase ndiye alikuwa mzaliwa wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Israeli akambariki Yusufu, akisema, Mungu ambaye mbele zake baba zangu Ibrahimu na Isaka walitembea, Mungu aliyenilinda hata leo, ");
INSERT INTO swhulb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","malaika walionilinda na madhara yote, awabariki vijana hawa. Jina langu na litajwe kwao, na majina ya baba zangu Ibrahimu na Isaka. Na wawe makutano ya watu juu ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu alipoona baba yake ameweka mkono wake wa kulia juu ya kichwa cha Efrahimu, haikumpendeza. Akauchukuwa mkono wa baba yake auweke katika kichwa cha Manase. ");
INSERT INTO swhulb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu akamwambia baba yake, “Sivyo babangu; kwani huyu ndiye mzaliwa wa kwanza. Uweke mkono wako juu ya kichwa chake.” ");
INSERT INTO swhulb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Baba yake akakataa na kusema, “Ninafahamu, mwanangu, nafahamu. Yeye naye atakuwa watu, naye pia atakuwa mkuu. Lakini mdogo wake atakuwa mkuu kuliko yeye, na uzao wake utakuwa wingi wa mataifa.” ");
INSERT INTO swhulb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Israeli akawabariki siku hiyo kwa maneno haya, “Watu wa Israeli watatamka baraka kwa majina yenu wakisema, Mungu na akufanye kama Efrahimu na kama Manase'. “Kwa njia hii, Israeli akamweka Efrahimu mbele ya Manase. ");
INSERT INTO swhulb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israeli akamwambia Yusufu, “Tazama, ninakaribia kufa, lakini Mungu atakuwa nanyi, na atawarudisha katika nchi ya baba zenu. ");
INSERT INTO swhulb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kwako wewe, kwa kuwa uko juu ya ndugu zako, ninakupa mtelemko wa mlima niliouchukuwa kutoka kwa Waamori kwa upanga wangu na upinde wangu.” ");
INSERT INTO swhulb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kisha Yakobo akawaita wana wake, na kusema: “Jikusanyeni pamoja, ili niwaambie yatakayowapata nyakati zijazo. ");
INSERT INTO swhulb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kusanyikeni ninyi wenyewe na msikilize, enyi wana wa Yakobo. Msikilizeni Israeli, baba yenu. ");
INSERT INTO swhulb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reubeni, wewe ni mzaliwa wangu wa kwanza, nguvu zangu, na mwanzo wa uwezo wangu, aliyesalia katika heshima na nguvu. ");
INSERT INTO swhulb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Asiyezuilika kama maji yarukayo, hautakuwa na umaharufu, kwa sababu ulikwenda juu ya kitanda cha baba yako. Hata ukakitia unajisi; ulikipanda kwa kuvizia. ");
INSERT INTO swhulb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simoni na Lawi ni ndugu. Panga zao ni silaha za vurugu. ");
INSERT INTO swhulb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ee nafsi yangu, usiingie barazani pao; usiingie katika mikutano yao, kwani moyo wangu unaheshima kubwa kwa ajili yao. Kwani katika hasira yao waliua watu. Iliwapendeza kuwakata visigino ng'ombe. ");
INSERT INTO swhulb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Hasira yao na ilaaniwe, kwani ilikuwa kali - na ukali wao, kwani ulikuwa ni katili. Nitawagawa katika Yakobo na kuwatawanya katika Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, ndugu zako watakusifu. Mkono wako utakuwa shingoni mwa adui zako. Wana wa baba yako watainama mbele zako ");
INSERT INTO swhulb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda ni mwana simba. Mwanangu, umetoka katika mawindo yako. Alisimama chini, alijikunyata kama simba, kama simba jike. Je nana atakayejaribu kumwamsha? ");
INSERT INTO swhulb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Fimbo haitaondoka katika Yuda, wala fimbo ya utawala kutoka katika miguu yake, hata atakapo kuja Shilo. Mataifa yatamtii. ");
INSERT INTO swhulb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kumfunga punda wake kwenye mzabibu, na mwanapunda wake katika mzabibu mzuri, amefua mavazi yake katika divai, na kanzu yake katika damu ya vichala vya mzabibu. ");
INSERT INTO swhulb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Macho yake yatakuwa mausi kama mvinyo, na meno yake meupe kama maziwa. ");
INSERT INTO swhulb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloni atakaa katika fukwe ya bahari. Atakuwa bandari kwa ajili ya meli, na mpaka wake utakuwa hata Sidoni. ");
INSERT INTO swhulb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari ni punda mwenye nguvu, ajilazaye kati ya kondoo. ");
INSERT INTO swhulb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Anaona mahali pazuri pa kupumzikia na nchi ya kupendeza. Atainamisha bega lake kwa mzigo na kuwa mtumishi wake. ");
INSERT INTO swhulb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani atawaamua watu wake kama mojawapo ya makabila ya Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani atakuwa nyoka kando ya njia, nyoka mwenye sumu aumaye visigino vya farasi katika njia, hivyo aongozaye farasi huanguka nyuma. ");
INSERT INTO swhulb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ninaungoja wokovu wako, Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi - wapanda farasi watamshambulia, lakini yeye atawapiga katika visigino vyao. ");
INSERT INTO swhulb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Vyakula vya Asheri vitakuwa vingi, naye ataandaa vyakula vya kifalme. ");
INSERT INTO swhulb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali ni dubu jike asiyefungwa; atakuwa na watoto wa dubu walio wazuri. ");
INSERT INTO swhulb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu ni tawi lizaalo, tawi lizaalo karibu na kijito, ambaye matawi yake yako juu wa ukuta. ");
INSERT INTO swhulb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mpiga mishale atamshambulia na kumrushia na kumsumbua. ");
INSERT INTO swhulb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Lakini upinde wake utakuwa imara, na mikono yake itakuwa hodari kwa sababu ya mikono ya Mwenyenguvu wa Yakobo, kwa ajili ya jina la Mchungaji, Mwamba wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mungu wa baba yako atakusaidia na Mungu Mwenye enzi atakubariki kwa baraka mbinguni juu, baraka za vilindi vilivyo chini, na baraka za maziwa na tumbo. ");
INSERT INTO swhulb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Baraka za baba yako ni kuu kuliko baraka za milima ya zamani au vitu vilivyotamaniwa vya milima ya kale. Na viwe katika kichwa cha Yusufu, hata juu ya taji ya kifalme kichwani pa ndugu zake. ");
INSERT INTO swhulb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamini ni mbwamwitu mwenye njaa. Wakati wa asubuhi atalarua mawindo, na jioni atagawa mateka.” ");
INSERT INTO swhulb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Haya ni makabila kumi na mbili ya Israeli. Hiki ndicho baba yao alichowambia alipowabariki. Aliwabariki kila mmoja kwa baraka iliyomstahili. ");
INSERT INTO swhulb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kisha akawaelekeza na kuwaambia, “Ninakaribia kwenda kwa watu wangu. Mnizike pamoja na babu zangu katika pango lililoko katika shamba la Efroni Mhiti, ");
INSERT INTO swhulb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","katika pango lililo katika shamba la Makpela, karibu na Mamre katika nchi ya Kanaani, shamba Ibrahimu alilolinunua kwa Efron Mhiti kwa ajili ya eneo la kuzikia. ");
INSERT INTO swhulb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Pale walimzika Ibrahimu na Sara mkewe; pale wakamzika Isaka na Rebeka mkewe; na pale nikamzika Lea. ");
INSERT INTO swhulb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Shamba na pango lililomo lilinunuliwa kutoka kwa watu wa Hethi.” ");
INSERT INTO swhulb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo alipomaliza maagizo hayo kwa wanawe, akaiweka miguu yake kitandani, akakata roho, akawaendea watu wake ");
INSERT INTO swhulb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu akahuzunika sana hata akauangukia uso wa baba yake, akamlilia, na kumbusu. ");
INSERT INTO swhulb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusufu akawaagiza watumishi wake matabibu kumtia dawa babaye. Hivyo matabibu wakampaka dawa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wakatimiza siku arobain, kwani huo ndio uliokuwa muda kamili wa kutia dawa. Wamisri wakamlilia kwa siku sabini ");
INSERT INTO swhulb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Siku za maombolezo zilipotimia, Yusufu akaongea na watumishi wa baraza la kifalme wa Farao kusema, “Ikiwa nimepata kibali machoni penu, tafadharini ongeeni na Farao, kusema, ");
INSERT INTO swhulb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Baba yangu aliniapisha, kusema, “Tazama, ninakaribia kufa. Unizike katika kaburi nililolichimba kwa ajili yangu mwenyewe katika nchi ya Kanaani. Ndipo utakaponizika.” Basi sasa niruhusu niende nimzike baba yangu, na kisha nitarudi.” ");
INSERT INTO swhulb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao akajibu, “Nenda na umzika baba yako, kama alivyokuwapisha.” ");
INSERT INTO swhulb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusufu akaenda kumzika baba yake. Maofisa wa Farao wote wakaenda pamoja naye - washauri wa nyumba yake, maofisa waandamizi wote wa nchi ya Misri, ");
INSERT INTO swhulb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","pamoja na nyumba yote ya Yusufu na ndugu zake, na nyumba yote ya baba yake. Lakini watoto wao, kondoo wao na makundi ya mbuzi wao yaliachwa katika nchi ya Gosheni. ");
INSERT INTO swhulb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Vibandawazi na wapanda farasi pia walikwenda pamoja naye. Lilikuwa kundi kubwa sana la watu. ");
INSERT INTO swhulb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Hata walipokuja katika sakafu ya kupuria ya Atadi upande mwingine wa Yordani, wakaomboleza kwa majonzi ya huzuni kubwa. Yusufu akafanya maombolezo ya siku saba kwa ajili ya babaye pale. ");
INSERT INTO swhulb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wenyeji wa nchi, Wakanaani, walipoona maombolezo katika sakafu ya Atadi, wakasema, “Hili ni tukio la kuhuzunisha sana kwa Wamisri.” Ndiyo maana eneo hilo likaitwa Abeli Mizraimu, lililoko mbele ya Yordani. ");
INSERT INTO swhulb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hivyo wanawe wakamfanyia Yakobo kama alivyokuwa amewaagiza. ");
INSERT INTO swhulb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wana wake wakampeleka katika nchi ya Kanaani na wakamzika katika pango katika shamba la Makpela, karibu na Mamre. Ibrahimi alikuwa amelinunua pango pamoja na shamba kwa ajili ya eneo la kuzikia. Alikuwa amelinunua kutoka kwa Efroni Mhiti. ");
INSERT INTO swhulb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Baada ya kuwa amemzika babaye, Yusufu akarudi Misri, yeye, pamoja na ndugu zake, na wote waliokuwa wamemsindikiza ili kumzika babaye. ");
INSERT INTO swhulb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nduguze Yusufu walipoona kwamba baba yao amekufa, wakasema, “Itakuwaje ikiwa Yusufu atatukasirikia na akataka kutulipa kikamilifu kwa ajili ya uovu tuliomtenda?” ");
INSERT INTO swhulb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hivyo wakamwagiza Yusufu, kusema, “Baba yako alitoa maelekezo kabla hajafa, kusema, ");
INSERT INTO swhulb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Mwambieni hivi Yusufu, “Tafadhari samehe makosa ya ndugu zako na dhambi yao uovu waliokutenda.” Basi wasamehe watumishi wa Mungu wa baba yako.” Yusufu akalia walipomwambia. ");
INSERT INTO swhulb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ndugu zake pia wakaenda na kuinamisha nyuso zao mbele zake. Wakasema, “Tazama, sisi ni watumishi wako.” ");
INSERT INTO swhulb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lakini Yusufu akawajibu, “Msiogope, Je mimi ni badala ya Mungu? ");
INSERT INTO swhulb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Lakini kwenu, mlikusudia kunidhuru, lakini Mungu alikusudia mema, kuhifadhi maisha ya watu wengi, kama mwonavyo leo. ");
INSERT INTO swhulb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hivyo basi msiogope. Nitawahudumia ninyi na watoto wenu wadogo.” Kwa njia hii aliwatia moyo na kuongea na mioyo yao kwa upole. ");
INSERT INTO swhulb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu akakaa Misri, pamoja na familia ya baba yake. Akaishi miaka mia moja na kumi. ");
INSERT INTO swhulb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu akawaona wana wa Efraimu hata kizazi cha tatu. Pia aliwaona wana wa Makiri mwana wa Manase, waliowekwa katika magoti ya Yusufu. ");
INSERT INTO swhulb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu akawambia ndugu zake, “Ninakaribia kufa; lakini kwa hakika Mungu atawajilia na kuwaongoza kutoka katika nchi hii na kuwapeleka katika nch aliyoapa kumpa Ibrahimu, kwa Isaka na kwa Yakobo.” ");
INSERT INTO swhulb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kisha Yusufu akawaapisha watu wa Israeli kwa kiapo. Akasema, “Bila shaka Mungu atawajilia. Wakati huo mtachukuwa mifupa yangu kutoka hapa.” ");
INSERT INTO swhulb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hivyo Yusufu akafa, mwenye miaka 110. Wakampaka dawa na akawekwa katika jeneza huko Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Haya ndiyo majina ya wana wa Israeli waliokuja Misri pamoja na Yakobo kila moja na familia yake: ");
INSERT INTO swhulb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simioni, Lawi, na Yuda, ");
INSERT INTO swhulb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zebuluni, na Benjamini, ");
INSERT INTO swhulb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Naftali, Gadi, na Asheri. ");
INSERT INTO swhulb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jumla ya watu wa ukoo wa Yakobo walikuwa sabini. Yusufu alikuwa Misri tayari. ");
INSERT INTO swhulb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ndipo Yusufu, pamoja na kaka zake wote, na kizazi chote wakafa. ");
INSERT INTO swhulb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Waisraeli walifanikiwa sana, wakaongezeka sana idadi yao, na wakawa na nguvu maana nchi ilijazwa na wao. ");
INSERT INTO swhulb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Wakati huu sasa mfalme mpya asiyemjua Yusufu aliinuka katika Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Akawaambia watu wake, “Tazama, hawa Waisraeli ni wengi na wenye nguvu kuliko sisi. ");
INSERT INTO swhulb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Njooni na tukae nao kwa akili, ama sivyo wataendelea kuongezeka na kama vita ikiibuka, wataungana na adui zetu, watapigana nasi, na kisha wataondoka.” ");
INSERT INTO swhulb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hivyo wakawekea walinzi ambao waliwatesa kwa kuwatumikisha kazi ngumu. Waisraeli walijenga maghala ya miji kwa ajili ya Farao: Pishoni na Ramsei. ");
INSERT INTO swhulb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lakini kadiri Wamisri walivyowatesa, ndivyo Waisraeli waliendelea kuongezeka na kusambaa. Hivyo Wamisri wakaanza kuwaogopa Waisraeli. ");
INSERT INTO swhulb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Wamisri waliwafanya Waisraeli wafanye kazi kwa nguvu nyingi. ");
INSERT INTO swhulb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Waliyafanya maisha yao kuwa machungu kwa kuwafanyisha kazi ngumu kwa vinu na matofali na kwa kila aina ya kazi za shambani. Kazi zao zote zilikuwa ngumu. ");
INSERT INTO swhulb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kisha mfalme wa Misri akawaambia wakunga wa Kiebrania; mmoja wao aliitwa jina lake Shifra, na mwingine aliitwa Puha. ");
INSERT INTO swhulb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Akasema, “Wakati mnapowasaidia wanawake wa Kiebrania wanapojifungua, chunguzeni wanapozaa. Ikiwa ni mtoto wa kiume, basi muueni; bali ikiwa ni mtoto wa kike, basi mwacheni aishi.” ");
INSERT INTO swhulb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lakini wale Wakunga walimwogopa Mungu na hawakufanya kama mfalme wa Misri alivyowaagiza; badala yake waliwaacha watoto wa kiume waishi. ");
INSERT INTO swhulb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mfalme wa Misri akawaita Wakunga na kuwaambia, “Kwanini mmefanya haya, na kuwaacha watoto wa kiume wakaishi?” ");
INSERT INTO swhulb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Wale Wakunga wakamjibu Farao, “Hawa wanawake wa Kiebrania siyo kama wanawake wa Kimisri. Hawa wana nguvu na jasiri sana maana wao humaliza kuzaa kabla hata mkunga hajafika.” ");
INSERT INTO swhulb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mungu aliwalinda hawa Wakunga. Watu waliongezeka kwa idadi na kuwa na nguvu sana. ");
INSERT INTO swhulb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kwa sababu wale Wakunga walimwogopa Mungu, aliwapa familia. ");
INSERT INTO swhulb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Farao akawaagiza watu wote, “Lazima mmutupe kila mtoto wa kiume anayezaliwa katika mto, lakini kila mtoto wa kike wamwache aishi.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Sasa mwanamme wa kabila la Lawi alimuoa mwanamke Mlawi. ");
INSERT INTO swhulb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Yule mwanamke akapata mimba na kuzaa mtoto wa kiume. Alipoona ya kuwa alikuwa mtoto mwenye afaya, alimficha kwa miezi mitatu. ");
INSERT INTO swhulb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Lakini alipokuwa hawezi kuendelea kumficha tena, alichukua kikapu cha manyasi akakipaka sifa na lami. Akamtia mtoto ndani yake na kukiweka juu ya maji katika majani kando ya mto. ");
INSERT INTO swhulb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Dada yake akasimama kwa mbali ili ajue yatakayompata. ");
INSERT INTO swhulb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Binti Farao akashuka kuoga mtoni wakati vijakazi wake wakitembea kando ya mto. Naye akaona kile kikapu katika majani na akamtuma kijakazi wake kwenda kukileta. ");
INSERT INTO swhulb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Alipokifungua, aliomwona mtoto. Tazama, mtoto alikuwa analia. Alimhurumia na kusema, “Bila shaka huyu ni mmoja wapo wa watoto wa Waebrania.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Basi dada wa yule mtoto akamwambia binti Farao, “Je naweza kwenda kukutafutia mwanamke wa Kiebrania aje akulele mtoto kwa ajili yako?” ");
INSERT INTO swhulb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Binti Farao akamwambia, “Nenda.” Hivyo yule binti akaenda na kumwita mama yake yule mtoto. ");
INSERT INTO swhulb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Binti Farao akamwambia mama yake yule mtoto, “Mchukue mtoto huyu ukaninyonyeshee, nami nitakupa posho.” Hivyo yule mwanamke akamchukua mtoto na kumnyonyesha. ");
INSERT INTO swhulb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mtoto alipokuwa mkubwa, akamleta kwa binti Farao, na akawa mtoto wake. Akamwita jina lake Musa akisema, “Kwa sababu nilimtoa katika maji.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musa alipokuwa mtu mzima, alienda kwa watu wake na kuona kazi ngumu walizokuwa wanafanya. Alimuona Mmisri akimpiga Mwebrania, mmoja wa watu wa jamii yake. ");
INSERT INTO swhulb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Aliangalia huku na kule, na alipoona ya kuwa hakuna mtu, alimuua yule mmisri na kuuficha mwili wake katika mchanga. ");
INSERT INTO swhulb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Alienda tena siku iliyofuata, na tazama, Waebrania wawili walikuwa wanapigana. Alimwambia yule aliyekuwa na makosa, “Kwa nini unampigia mwenzako?” ");
INSERT INTO swhulb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Lakini yule mtu alisema, “Ni nani aliyekuweka wewe kuwa kiongozi na mwamuzi juu yetu? Unataka kuniua na mimi kama ulivyomuua yule mmisri?” Ndipo Musa akaogopa na kusema, “Hakika niliyoyafanya yamejulikana.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao aliposikia habari hizi, alijaribu kumuua Musa. Lakini Musa alikimbia na kwenda kuishi katika nchi ya Wamidiani. Kule alikaa chini kando ya mto. ");
INSERT INTO swhulb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Wakati huo kuhani wa Midiani alikuwa na mabinti saba. Walikuja mtoni kuchota maji na kujaza vyombo vyao ili wawanyweshe mifuko ya baba yao. ");
INSERT INTO swhulb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Wachungaji walikuja na kutaka kuwafukuza, lakini Musa alienda kuwasaidia. Kisha akawanywesha mifugo wao. ");
INSERT INTO swhulb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wale mabinti walipoenda kwa Reueli baba yao, aliwauliza, “Kwa nini mmerudi nyumbani mapema hivi leo?” ");
INSERT INTO swhulb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wakamwambia, “Mmisri mmoja alituokoa dhidi ya wachungaji. Pia alichota maji na kuwanywesha mifugo wetu.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kisha akawauliza binti zake, “Yu wapi sasa? Kwa nini mlimwacha? Mwiteni ili apate kula chakula pamoja nasi.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa akakubali kukaa na yule mtu ambaye pia alimpa binti yake Zipora ili amuoe. ");
INSERT INTO swhulb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Alizaa mtoto wa kiume, na Musa akamwita jina lake Geshomu; akisema; “Nimekuwa mkazi katika nchi ya ugeni.” ");
INSERT INTO swhulb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Muda mrefu baadaye, mfalme wa Misri akafa. Waisraeli walilalamika kwa sababu ya kazi za utumwa. Walilia kutafuta msaada, na maombi yao yakamfikia Mungu kwa sababu ya mateso yao. ");
INSERT INTO swhulb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mungu aliposikia malalamiko yao, Mungu alikumbuka agano lake na Abrahamu, na Isaka, na Yakobo. ");
INSERT INTO swhulb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mungu aliwaona Waisraeli na akaielewa hali yao. ");
INSERT INTO swhulb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Wakati huu Musa aliendelea kuchunga mifugo ya Yethro baba mkwe wake, kuhani wa Midiani. Musa aliliongoza kundi la mifugo kuelekea upande wa mbali wa jangwa mpaka kufika Horebu, mlima wa Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Akiwa pale malaika wa Yahwe akamtokea kama mwali wa moto katika kichaka. Musa aliangalia, na tazama, kichaka kiliwaka moto lakini hakikuteketea. ");
INSERT INTO swhulb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa akasema, “Nitageuka ili nione kitaku hiki cha ajabu, kwa nini kichaka hakiteketei.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yahwe alipoona ya kuwa amegeuka upande ili aone, Mungu alimwita kutoka katika kile kichaka na kusema, “Musa, Musa.” Musa akasema, “Mimi hapa.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mungu akasema, “Usinikaribie! Vua viatu katika miguu yako, kwa kuwa mahali uliposimama ni mahali palipowekwa wakfu kwa ajili yangu.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Aliongeza kusema, “Mimi ni Mungu wa baba yako, Mungu wa Abrahamu, Mungu wa Isaka, na Mungu wa Yakobo.” Kisha Musa akaufunika uso wake, kwa kuwa aliogopa kumwangalia Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahwe akasema, “Hakika nimeyaona mateso ya watu wangu walioko Misri. Nimesikia kelele zao kwa sababu ya mabwana wao, kwa kuwa nayajua mateso yao. ");
INSERT INTO swhulb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nimekuja chini kuwaokoa dhidi ya mamlaka ya Wamisri na kuwatoa katika nchi ile na kuwaleta katika nchi nzuri, pana, nchi ijaayo maziwa na asali; kwenye ukanda wa Wakanaani, Wahiti, Waamori, Waperizi, Wahivi, na Wayebusi. ");
INSERT INTO swhulb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sasa kilio cha watu wa Israeli kimenifikia mimi. Zaidi sana, Mimi nimeyaona mateso ambayo Wamisri wanawatesa. ");
INSERT INTO swhulb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sasa basi, nitakutuma wewe kwa Farao ili upate kuwatoa watu wangu, wana wa Israeli, kutoka katika nchi ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lakini Musa akamwambia Mungu, “Mimi ni nani hata niende kwa Farao na kuwatoa Waisraeli kutoka Misri?” ");
INSERT INTO swhulb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mungu akamjibu, “Hakika nitakuwa pamoja nawe. Hii itakuwa ishara kwako ya kuwa nimekutuma. Utakapokuwa umewatoa watu kutoka Misri, mtaniabubu mimi katika mlima huu.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa akamwambia Mungu, “Nikienda kwa Waisraeli na kuwaambia, 'Mungu wa baba zenu amenituma mimi kwenu,' na kisha wakiniambia, 'jina lake nani?' nitawaambia nini?” ");
INSERT INTO swhulb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mungu akamwambia Musa, “MIMI NIPO AMBAYE NIPO.” Mungu akasema, “Ni lazima uwaambie Waisraeli, “MIMI NIPO amenituma kwenu.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Pia Mungu akamwambia Musa, “Lazima uwaambie Waisraeli, 'Yahwe, Mungu wa baba zenu, Mungu wa Abrahamu, Mungu wa Isaka, na Mungu wa Yakobo amenituma mimi kwenu. Hili ndio jina langu milele, na hivi ndivyo nitakavyokumbukwa na vizazi vyote.' ");
INSERT INTO swhulb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Nenda ukawakusanye wazee wa Israeli pamoja. Waambie, 'Yahwe, Mungu wa baba zenu, Mungu wa Abrahamu, wa Isaka na Yakobo, amenitokea mimi na kusema, “Hakika nimewatazama na nimeona yale mliyotendewa huko Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nimeahidi kuwatoa ninyi katika mateso ya Misri na kuwaleta katika nchi ya Wakanaani, Wahiti, Wamwori, Waperizi, Wahivi, na Wayebusi. Nchi ijaayo maziwa na asali.” ");
INSERT INTO swhulb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Watakusikiliza. Wewe pamoja na wazee wa Israeeli itawapasa kwenda kwa mfalme wa Misri, na imewapasa kumwambia, 'Yahwe, Mungu wa Waebrania amekutana nasi. Hivyo tuache sisi twende safari ya siku tatu katika jangwa ili tupate kutoa sadaka kwa Yahwe Mungu wetu.' ");
INSERT INTO swhulb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Lakini nafahamu ya kuwa mfalme wa Misri hatawaacha ninyi mwende, isipokuwa kwa kulazimishwa. ");
INSERT INTO swhulb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nitainua mkono wangu na kuwapiga Wamisri kwa miujiza yote nitakayoifanya kati yao. Baada ya hayo, atawaacha mwende. ");
INSERT INTO swhulb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nitawapa watu hawa kufadhiliwa kutoka kwa Wamisri ili muondokapo msiende mikono mitupu. ");
INSERT INTO swhulb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kila mwanamke ataomba kwa jirani yake Mmisri na kwa kila mwanamke akaaye kwenye nyumba ya jirani yake, vyombo vya fedha na vya dhahabu na nguo. Nanyi mtawavika watoto wenu wa kiume na binti zenu. Kwa njia hii mtawateka nyara Wamisri.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa akajibu, “Lakini itakuwaje wasiponiamini mimi au wasiponisikiliza na kusema, 'Yahwe hajakutokea wewe?” ");
INSERT INTO swhulb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahwe akamwambia, “Hicho ni nini mkononi mwako?” Musa aksema, “Ni fimbo.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yahwe akasema, “Itupe chini.” Musa akaitupa chini ile fimbo, nayo ikageuka na kuwa nyoka. Musa akarudi nyumba. ");
INSERT INTO swhulb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahwe akamwambia Musa, “Mchukue kwa kumshikia mkia wake.” Hivyo alimchukua yule nyoka. Mara ikaggeuka na kuwa fimbo mkononi mwake tena. ");
INSERT INTO swhulb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Hii ni ili wapate kuamini ya kuwa Yahwe, Mungu wa baba zao, Mungu wa wa Abrahamu, Mungu wa Isaka, na Mungu wa Yakobo amekutokea wewe.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahwe pia alimwambia, “Sasaingiza mkono wako ndani ya vazi lako.” Hivyo Musa akaingiza mkono wake ndani ya vazi lake. Na alipoutoa nje, tazama, mkono wake ulikuwa na ukoma, mweupe kama theluji. ");
INSERT INTO swhulb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yahwe akasema, “Ingiza mkono wako ndani ya vazi lako tena.” Hivyo akaingiza mkono wake ndani ya vazi lake, na alipoutoa nje aliona ukiwa mzima tena kama ulivyo mwili wake wote. ");
INSERT INTO swhulb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yahwe akasema, “Kama hawatakuamini wewe - kama hawatazingatia ishara yanggu ya kwanza ya nguvu zangu au kuziamini, basi wataamini ishara ya pili. ");
INSERT INTO swhulb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na ikiwa hawataamini hata ishara hizi zote mbili za nguvu zangu, au wasipokusikiliza wewe, basi chota maji kutoka katika mto na uyamwage katika nchi kavu. Maji utakayoyamwaga yatakuwa damu katika nchi kavu.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ndipo Musa akamwambia Yahwe, “Bwana, mimi ni mzuri wa kuongea, si hapo kwanza au hata baada ya kuwa umeongea na mtumishi wako. Mimi ni mdhaifu wa kuongea na nina kigugumizi.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahwe akamwambia, “Ni nani anayeumba mdomo wa mwanadamu? Ni nani amfanyaye mwanadamu kuwa bubu au aone au kipofu? Je si mimi Yahwe? ");
INSERT INTO swhulb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Sasa nenda, nami nitauongoza mdomo wako na nitakufundisha cha kusema.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lakini Musa akasema, “Bwana, tafadhali mtume mtu mwingine, yeyote unayependa kumtuma.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kisha Yahwe akamkasirikia Musa. Akasema, “Vipi kuhusu Aroni kaka yako yule Mlawi? Najua ya kuwa anaweza kuongea vizuri. Hata hivyo, anakuja kukutana na wewe, na atakapokuona moyo wake utajawa na furaha. ");
INSERT INTO swhulb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Wewe utaongea naye na utaweka maneno ya kusema kinywani mwake. Nami nitakiongoza kinywa chako na kinywa chake pia, nami nitaonesha ninyi nyote yawapasayo kutenda. ");
INSERT INTO swhulb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Yeye ataongea na watu kwa niaba yako. Yeye atakuwa msemaji wako, na wewe utakuwa kama Mungu kwake. ");
INSERT INTO swhulb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Utachukua hii fimbo pamoja nawe mkononi mwako. Kwa fimbo hii utafanya ishara.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hivyo Musa alirudi kwa Yethro - baba mkwe wake na kumwambia, “Niruhusu nipate kurudi kwa ndugu zangu walioko Misri ili niweze kuona kama bado wako hai.” Yethro akwambia Musa, “Nenda kwa amani.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahwe akamwambia Musa kule Midiani, “Nenda, rudi Misri, kwa kuwa watu wote waliotaka kukuua wameshakufa.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa akamchukua mke wake na watoto wake wa kiume na kuwapandisha kwenye punda. Akarudi mpaka nchi ya Misri, naye alichukua fimbo ya Mungu pamoja naye mkononi mwake. ");
INSERT INTO swhulb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahwe akamwambia Musa, “Utakaporudi Misri, jitahidi kufanya ishara zote nilizokupa kufanya mbele ya Farao. Lakini nitaufanya moyo wake kuwa mgumu, naye hawatawaacha watu waende. ");
INSERT INTO swhulb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Lazima umwambie Farao, 'Hivi ndivyo asemavyo Yahwe: Israeli ni mtoto wangu, mzaliwa wa kwanza wangu, ");
INSERT INTO swhulb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","nami nakuamuru, “Mwache mwanangu aende ili apate kuniabudu mimi.” Lakini kwa kuwa umekataa kumwachia, hakika nitamuua mtoto wako wa kiume, mzaliwa wa kwanza wako.”' ");
INSERT INTO swhulb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Sasa wakiwa njiani, wakati wa usiku walipopumzika, Yahwe alikutana na Musa na kutaka kumuua. ");
INSERT INTO swhulb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kisha Zipora akachukua kisu kikali na kukata govi la mtoto wake wa kiume na kuligusisha miguuni pake. Kisha akasema, “Hakika wewe ni bwana harusi wangu kwa njia ya damu.” ");
INSERT INTO swhulb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hivyo Yahwe akamwachia. Akasema, “Wewe ni bwana harusi wa damu” kwa sababu ya kutahiriwa. ");
INSERT INTO swhulb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahwe akamwambia Aroni, “Nenda nyikani ukutane na Musa.” Aroni akaenda na kukutana naye katika mlima wa Mungu, na kumbusu. ");
INSERT INTO swhulb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa akwambia Aroni maneno yote ya Yahwe ambayo alimtuma kusema na kwa habari za ishara zote za nguvu za Yahwe ambazo alimwagiza kutenda. ");
INSERT INTO swhulb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kisha Musa na Aroni wakaenda na kuwakusanya wazee wote wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aroni akawaambia maneno yote ambayo Yahwe alimwambia Musa. Pia alionesha ishara na miujiza ya nguvu za Yahwe mbele ya watu. ");
INSERT INTO swhulb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Watu waliamini. Waliposikia ya kuwa Yahwe aliwaona Waisraeli na ya kwamba aliyaona mateso yao, waliinamisha vichwa vyao na kumwabudu. ");
INSERT INTO swhulb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Baada ya mambo haya kutokea, Musa na Aruni walienda kwa Farao na kumwambia, ““Hivi ndivyo Yahwe, Mungu wa Israeli anasema: 'Waache watu wangu waende, ili wapate kunifanyia karamu jangwani.'” ");
INSERT INTO swhulb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao akasema, “Yahwe ni nani? Kwa nini mimi nisikiliz sauti yake na kuwaacha Israeli waende? Mimi simjui Yahwe; na la zaidi, sitawaacha Israeli waende.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Wakasema, “Mungu wa Waebrania amekutana nasi. Tuache twende safari jangwani kwa siku tatu ili tutoe sadaka kwa Yahwe Mungu wetu ili asituadhibu kwa mapigo au kwa upanga.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lakini mfalme wa Misri aliwaambia, “Musa na Aruni, kwa nini mnawatoa watu kazini mwao? Nendeni kazini kwenu.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pia alisema, “Sasa kuna Waebrania wengi nchini mwetu, na ninyi mnawafanya waache kazi zao.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siku ile ile, Farao alitoa amri kwa wasimamizi na wanyapara wa wale watu. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Tofauti na ilivyokuwa mwanzo, “Tofauti ni ilivyokuwa awali, msiwapatie tena watu majani ya kutengenezea tofali. Waacheni wao waende kujitafutia majani wenyewe. ");
INSERT INTO swhulb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ingawa wanapaswa kuleta hesabu sawa ya matofali watakayotengeneza kama ilivyokuwa awali. Msipokee pungufu, kwasababu wao ni wavivu. Ndiyo maana wanapiga kelele na kusema, 'turuhusu tuende tukamtolee sadaka Mungu wetu.' ");
INSERT INTO swhulb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Waongezeeni kazi wanaume ili wasipate tena muda wa kusikiliza maneno ya upotoshaji.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kwa hiyo viongozi wa watu na waangalizi wao waliwajulisha watu. Walisema, “Hivi ndivyo farao amesema: 'Sitawapeni tena malighafi. ");
INSERT INTO swhulb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nyinyi wenyewe mtaenda kutafuta majani popote mtakapopata, lakini kazi zenu hazitapunguzwa. ");
INSERT INTO swhulb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Basi watu hao wakatawanyika katika nchi yote ya Misri ili wapate kukusanya matakataka badala ya majani. ");
INSERT INTO swhulb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Wasimamizi wao wakawahimiza na kusema, “Malizeni kazi zenu, sawa na wakati ule majani yalipokuwapo.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wanyapara wa Farao wakawapiga wasimamizi wa Waisraeli, watu walewale ambao waliwaweka kuwa wasimamizi wa watumishi. Wale Wanyapara wakakazana kuwauliza, “Kwanini hamjatimiza idadi ya matofali inayotakiwa kwenu, siku ya jana na hata leo kama ambavyo mlifanya siku za nyuma?” ");
INSERT INTO swhulb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Basi Wanyapara wa wana wa Israeli wakamwendea Farao na kumlilia. Walisema, “Kwanini unawatendea watumishi wako hivi? ");
INSERT INTO swhulb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Sisi watumishi wako hatupewi majani tena, lakini bado wanatuambia sisi, “Tengenezeni tofali!' Sisi watumwa wako tunapigwa sasa, lakini kosa hilo ni la watu wako.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Lakini Farao akasema, “Ninyi ni wavivu! Wavivu ninyi! Ninyi mwasema, 'Turuhusu twende kumtolea Yahwe sadaka.' ");
INSERT INTO swhulb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sasa rudini kazini. Hamtapewa majani tena, lakini mnapaswa kutengeneza idadi ile ile ya matofali.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Wanyapara wa wana wa Israeli wakagundua ya kuwa walikuwa kwenye shida kubwa mara walipoambiwa, “Hamtapunguza kamwe idadi ya matofali mnayotengeneza kila siku.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Wakakutana na Musa na Haruni, waliokuwa wamesimama nje ya Ikulu wakati wanatoka kwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wakawaambia Musa na Haruni, “Yahwe awatazame ninyi na kuwaadhibu, kwa sababu mmetufanya sisi kuonekana wabaya mbele ya Farao na watumishi wake. Mmetia upanga mikononi mwao ili watuue.” ");
INSERT INTO swhulb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa akarudi kwa BWANA na kumwambia, “Bwana, kwanini umewatenda mabaya watu hawa? Kwanini kunituma mimi kwanza? ");
INSERT INTO swhulb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tangu nilipokuja kwa Farao kusema naye kwa jina lako, amewatenda mabaya watu hawa, wala hujawaokoa watu wako hata kidogo.” ");
INSERT INTO swhulb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kisha Yahweh akasema na Musa, “Sasa utaona nitakacho fanya kwa Farao. Utaona hili, kwa kuwa ata waacha waenda kwa mkono wangu hodari. Kwasababu ya mkono wangu hodari, ata waondoa nje ya nchi.” ");
INSERT INTO swhulb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mungu akasema na Musa na kumwambia, “Mimi ni Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nilimtokea Ibrahimu, Isaka, na Yakobo kama Mungu mwenye nguvu; lakini kwa jina langu, Yahweh, sikujuliikana kwao. ");
INSERT INTO swhulb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Pia niliimarisha agano langu na wao, ilikuwapatia nchi ya Kanani, nchi walioishi kama sio raia, nchi walio tanga tanga. ");
INSERT INTO swhulb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Zaidi ya yote, nimesikia kilio cha Waisraeli ambao wa Misri wame wa chukua watumwa, na nimekumbuka agano langu. ");
INSERT INTO swhulb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kisha basi, sema kwa Waisraeli, 'Mimi ni Yahweh. Nitawatoa kwenye utumwa chini ya wa Misri, na kuwaweka huru na nguvu zao. Nitawaokoa kwa kudhihirisha nguvu zangu, na kwa matendo ya ajabu ya hukumu. ");
INSERT INTO swhulb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nitawaleta kwangu kama watu wangu, na nitakuwa Mungu wenu. Mtajua kuwa mimi ndiye Yahweh Mungu wenu, aliye watoa kwenye utumwa chini ya wa Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nitawaleta kwenye nchi niliyo muahidi kumpa Ibrahimu, Isaka, na Yakobo. Nitawapa kama mali yenu. Mimi ni Yahweh.”' ");
INSERT INTO swhulb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa alipo waambia haya Waisraeli, hawakumsiliza kwasababu ya mateso magumu ya utumwa wao. ");
INSERT INTO swhulb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hivyo Yahweh akazungumza na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Nenda umwambie Farao, mfalme wa Misri, awaache watu wa Israeli waondoke kwenye nchi yake.” ");
INSERT INTO swhulb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa akamwambia Yahweh, “Kama Waisraeli hawajanisikiliza mimi, kwa nini Farao anisikillize mimi, tangu mimi sio mzuri wakuzungumza?” ");
INSERT INTO swhulb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahweh akasema na Musa na Aruni. Akawapa amri ya Waisraeli na Farao, mfalme wa Misri, awatoe Waisraeli kutoka nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hawa walikuwa vichwa wa nyumba za baba yao: wana wa Rubeni, mzaliwa wa kwanza wa Israeli, walikuwa Hanoki, Palu, Hezroni, na Karmi. Hawa walikuwa mababu wa ukoo wa Rubeni. ");
INSERT INTO swhulb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wana wa Simeoni walikuwa Yemueli, Yamini, Ohadi, Yakini, Zohari, na Shauli - mwana wa mwanamke wa Kanani. Hawa walikuwa mababu wa ukoo wa Simeoni. ");
INSERT INTO swhulb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Hapa yameorodheshwa majina ya wana wa Lawi, pamoja na uzo wao. Walikuwa ni Gerishoni, Kohathi, na Merari. Lawi aliishi mpaka alipo kuwa na miaka 137. ");
INSERT INTO swhulb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana wa Gerishoni walikuwa Libni na Shimei. ");
INSERT INTO swhulb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana wa Kohathi walikuwa Amramu, Izhari, Hebroni, na uzieli. Kohathi aliishi hadi miaka 133. ");
INSERT INTO swhulb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana wa Merari walikuwa Mahli na Mushi. Hawa walikuja kuwa mababu wa ukoo wa Walawi, pamoja na uzao wao. ");
INSERT INTO swhulb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramu alimuoa Yokebedi, dada yake baba yake. Alimzalia Aruni na Musa. Amramu aliishi miaka 137 na akafa. ");
INSERT INTO swhulb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wana wa Izhari walikuwa Kora, Nefegi, na Zikri. ");
INSERT INTO swhulb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana wa Uzieli walikuwa Mishaeli, Elizafani na Sithri. ");
INSERT INTO swhulb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aruni alimuoa Elisheba, binti wa Aminadabu, dada wa Nashoni. Alimzaa Nadabu na Abihu, Eleazari na Ithamari. ");
INSERT INTO swhulb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wana wa Kora walikuwa Asiri, Elikana na Abiasa. Hawa walikuwa mababu wa ukoo wa Wakora. ");
INSERT INTO swhulb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazari, mwana wa Aruni, alimuoa mmoja wa mabinti Wa Putieli. Alimzalia Fineazi. Hawa walikuwa vichwa wa nyumba za baba yao miongoni mwa Walawi, pamoja na uzao wao. ");
INSERT INTO swhulb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Hawa wanaume wawili walikuwa Musa na Aruni ambao Yahweh alisema, “Waleteni Waisraeli kutoka nchi ya Misri, kwa makundi ya wanaume wapiganaji.” ");
INSERT INTO swhulb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aruni na Musa wakazungumza na Farao, mfalme wa Misri, awaruhusu Waisraeli watoke Misri. Hawa walikuwa Musa na Aruni wale wale. ");
INSERT INTO swhulb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Pale Yahweh alipo zungumza na Musa katika nchi ya Misri, ");
INSERT INTO swhulb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","alimwambia, “Mimi ni Yahweh. Sema kwa Farao, mfalme wa MIsri, kila kitu nitacho kwambia.” ");
INSERT INTO swhulb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lakini Musa alimwambia Yahweh, “Mimi sio mzuri wa kuongea, hivyo kwanini Farao anisikilize mimi?” ");
INSERT INTO swhulb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahweh akasema na Musa, “Ona, nimekufanya kama mungu kwa Farao. Aruni kaka yako atakuwa nabii wako. ");
INSERT INTO swhulb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Utasema kila kitu nitacho kuamuru kusema. Aruni kaka yako ata sema na Farao iliawaachie watu wa Israeli watoke kwenye nchi yake. ");
INSERT INTO swhulb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lakini nitaufanya moyo wa Farao mgumu, na nitaonyesha ishara nyingi za nguvu zangu, maajabu mengi, katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Lakini Farao hata kusikiliza, kwahiyo nitaueka mkono wangu juu ya Misri na kutoa makundi yangu ya wanaume wapiganaji, watu wangu, wazao wa Israeli, watoke nchi ya Misri kwa matendo makubwa ya hukumu. ");
INSERT INTO swhulb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Wamisri watajua kuwa mimi ni Yahweh nitapo nyoosha mkono wangu kwa Misri na kuwatoa Waisraeli kutoka miongoni mwao.” ");
INSERT INTO swhulb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Aruni wakafanya hivyo; walifanya kama Yahweh alivyo waamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa alikuwa na miaka themanini, na Aruni miaka themanini na tatu walipo ongea na Farao. ");
INSERT INTO swhulb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahweh akamwambia Musa na Aruni, ");
INSERT INTO swhulb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Wakati Farao atakapo waambia, 'Fanya muujiza,' utamwambia Aruni, 'Chukuwa gongo lako na ulirushe chini mbele ya Farao, ililigeuke nyoka.”' ");
INSERT INTO swhulb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kisha Musa na Aruni wakaenda kwa Farao, na wakafanya kama Yahweh alivyo waamuru. Aruni akarusha chini gongo lake mbele ya Farao na watumishi wake, na likageuka nyoka. ");
INSERT INTO swhulb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kisha naye Farao akawaita wazee wenye hekima na wachawi. Wakafanya jambo hilo hilo kwa uchawi wao. ");
INSERT INTO swhulb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kila mtu akarusha chini gongo lake, na magongo yakawa nyoka. Lakini gongo la Aruni lilimeza nyoka zao. ");
INSERT INTO swhulb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Moyo wa Farao ulikuwa mgumu, na akusikiliza, kama Yahweh alivyo tabiri. ");
INSERT INTO swhulb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahweh akasema na Musa, “Moyo wa Farao ni mgumu, na anakataa kuacha watu waende. ");
INSERT INTO swhulb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nenda kwa Farao asubui anapoenda kwenye maji. Simama kwenye chanzo cha mto kukutana naye, na uchukuwe mkononi mwako gongo ambalo liligeuka nyoka. ");
INSERT INTO swhulb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mwambie, 'Yahweh, Mungu wa Waebrania, amenituma kwako, “Acha watu wangu waende, iliwaniabudu nyikani. Mpaka sasa haujanisikiliza.” ");
INSERT INTO swhulb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahweh anasema hili: “Kwa hili utajua kuwa mimi ni Yahweh. Ninaenda kupiga maji ya mto wa Misri kwa gongo langu lililo mikono mwangu, na mto utageuzwa kuwa damu. ");
INSERT INTO swhulb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Samaki walio kwenye mto watakufa, na mto utanuka. Wa Misri Hawataweza kunywa maji yalio kwenye mto.”''' ");
INSERT INTO swhulb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kisha Yahweh akasema na Musa, “Mwambie Aruni, 'Chukuwa gongo lako na unyooshe mkono kwenye maji ya Misri, na juu ya mito yake, mifereji, visima, na madimbwi yote, ili maji yao ya damu. Fanya hivi ilikuwe na damu nchi nzima ya Misri, hadi kwenye vyombo vyote vya mbao na mawe.”' ");
INSERT INTO swhulb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Aruni walifanya kama Yahweh alivyo waamuru. Aruni alinyanyua gongo na kupiga maji ya mto, machoni pa Farao na watumishi wake. Maji yote kwenye mto yaligeuga damu. ");
INSERT INTO swhulb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Samaki kwenye mto wakafa, na mto ukaanza kunuka. Wamisri hawakuweza kunywa maji kwenye mto, na damu ilikuwa kila mahali katika nchii ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lakini wachawi walifanya vivyo hivyo na uchawi wao. Kwaiyo moyo wa Farao ukawa mgumu, na akakataa kuwasikiliza Musa na Aruni, kama Yahweh alivyo sema itatokea. ");
INSERT INTO swhulb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kisha Farao akarudi na kwenda nyumbani kwake. Wala hakutilia maanani hili. ");
INSERT INTO swhulb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Wamisri wote walichimba pembeni ya mto kwa ajili ya maji ya kunywa, lakini hawakuweza kunywa maji ya mto. ");
INSERT INTO swhulb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Siku saba zilipita baada ya Yahweh kushambulia mto. ");
INSERT INTO swhulb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kisha Yahweh akazungumza na Musa, “Nenda kwa Farao na umwambie, 'Yahweh anasema hivi: Acha watu wangu waende hili wakaniabudu. ");
INSERT INTO swhulb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ukikataa kuwaruhusu waende, nitaidhuru nchi yako yote kwa vyura. ");
INSERT INTO swhulb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mito itajawa na vyura. Watatoka na kuingia nyumbani kwako, chumbani kwako, na kitandani kwako. Wataenda nyumbani mwa watumishi wako. Wataenda kwa watu wako, kwenye majiko yako, na vyombo vya kukandia mkate. ");
INSERT INTO swhulb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Vyura watakushambulia wewe, watu wako, na watumishi wako wote.\"”' ");
INSERT INTO swhulb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahweh akamwambia Musa, “Mwambie Aruni, 'Nyoosha mkono wako na gongo lako kwenye mito, mifereji, na kwenye mabwawa, na uwatoe vyura juu ya nchi ya Misri.”' ");
INSERT INTO swhulb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aruni akanyoosha mkono juu ya maji ya Misri, na vyura wakatoka na kujaza nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lakini wachawi walifanya vivyo hivyo na uchawi wao: waliwatoa vyura juu ya nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kisha Farao akawaita Musa na Aruni na kuwaambia, “Muombeni Yahweh iliawaondoe vyura kwangu na kwa watu wangu. Kisha nitawaacha watu waende, iliwamtolee dhabihu.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa akamwambia Farao, “Unaweza chukuwa fursa ya kuniambia lini nikuombee wewe, watumishi wako, na watu wako, ili vyura waondolewe kwako na nyumbani kwako na wabaki tu kwenye mito.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao akasema, “Kesho.” Musa akasema, “Acha iwe kama ulivyo sema, ili kwamba ujue hakuna Mungu mwengine kama Yahweh, Mungu wetu. ");
INSERT INTO swhulb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Vyura wataondoka kutoka kwako, nyumbani mwako, kwa watumishi wako, na kwa watu wako. Watabaki tu kwenye mito.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa na Aruni wakaondoka kwa Farao. Kisha Musa akamlilia Yahweh kuhusu hao vyura alio waleta kwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahweh akafanya kama Musa alivyo omba: Vyura wakafa kwenye nyumba, nyuani, na mashambani. ");
INSERT INTO swhulb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Watu wakawakusanya kwa mafungu, na nchi ikanuka. ");
INSERT INTO swhulb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lakini Farao alipoona kuna afadhali, aliufanya moyo wake kuwa mgumu na hakumsikiliza Musa na Aruni, kama Yahweh alivyo sema. ");
INSERT INTO swhulb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahweh akamwambia Musa, “Mwambie Aruni, 'Nyoosha gongo lako na upige udongo chini, iliuwe chawa kati nchi yote ya Misri.”' ");
INSERT INTO swhulb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wakanya hivyo: Aruni akanyoosha mkono wake na gongo lake. Akaupiga udongo wa ardhi. Chawa wakaja juu ya watu na wanyama. Udongo wote kwenye ardhi ukawa chawa katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wachawi walijaribu kufanya chawa kwa uganga wao lakini hawakuweza. Palikuwa na chawa kwa watu na kwa wanyama. ");
INSERT INTO swhulb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kisha wachawi wakamwambia Farao, “Hichi ni kidole cha Mungu.” Lakini moyo wa Farao ulikuwa Mgumu, hivyo akakataa kuwasikiliza. Ilikuwa kama Yahweh alivyo sema Farao atafanya. ");
INSERT INTO swhulb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahweh akamwambia Musa, “Inuka asubui mapema na usimame mbele ya Farao anapoenda mtoni. Umwambie, 'Yahweh anasema hivi: “Acha watu wangu waende wakaniabudu mimi. ");
INSERT INTO swhulb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Lakini usipo acha watu wangu waende nitatuma kundi la nzi kwako, watumishi wako, na watu wako, na kwenye nyumba zenu. Nyumba za wa Misri zitajawa na makundi ya nzi, na ata ardhi wanayo simama itajawa na nzi. ");
INSERT INTO swhulb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Lakini katika siku hiyo nitaitendea nchi ya Gosheni tofauti, nchi ambayo watu wangu wanaishi, ilikwamba kusiwe na makundi ya nzi huko. Hili litatokea ili kwamba mjue mimi ni Yahweh katika hii nchi. ");
INSERT INTO swhulb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nitaweka utofauti kati ya watu wangu na watu wako. Hii ishara ya nguvu zangu itatokea kesho\"”' ");
INSERT INTO swhulb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahweh akafanya hivyo, na kundi kubwa la nzi likaja nyumbani mwa Farao na nyumbani mwa watumishi wake. Katika nchi yote ya Misri, nchi iliharibiwa na makundi ya nzi. ");
INSERT INTO swhulb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farao akawaita Musa na Aruni na kuwaambia, “Nendeni, mtolee Mungu wenu dhabihu kwenye nchi yetu.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa akasema, “Sio vyema sisi kufanya hivyo, kwa kuwa dhabihu tunazo mtolea Yahweh Mungu wetu zinachukiza kwa Wamisri. Kama tutatoa dhabihu mbele ya macho yao zilizo chukizo kwa Wamisri, hawata tupiga mawe? ");
INSERT INTO swhulb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Hapana, ni safari ya siku tatu kwenda nyikani ambayo lazima tuende, ili kiutoa dhabihu kwa Yahweh Mungu wetu, kama anavyo tuamuru.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao akasema, “Nitakuruhusu kwenda kumtolea dhabihu Yahweh Mungu wenu nyikani. Ila usiende mbali sana. Niombee.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa akasema, “Wakati tu nitakapoenda kutoka kwako, nitamuomba Yahweh ili makundi ya nzi yatoke kwako, wewe Farao, na watumishi wako na watu kesho. Lakini usifanye udhalimu tena kwa kutowaacha watu wetu waende kumtolea dhabihu Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa akaenda nje kutoka kwa Farao na kumuomba Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yahweh akafanya kama Musa alivyo muomba: alitoa makundi ya nzi kutoka kwa Farao, watumishi wake, na watu wake. Hakuna ata mmoja aliye baki. ");
INSERT INTO swhulb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lakini Farao aliufanya moyo wake mgumu tena, na hakuwaacha watu waende. ");
INSERT INTO swhulb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kisha Yahweh akamwambia Musa, Nenda kwa Farao na umwambie, 'Yahweh, Mungu wa Waebrania, anasema hivi: “Acha watu wangu waende ili wakaniabudu mimi.” ");
INSERT INTO swhulb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Lakini ukikataa kuwaruhusu waende, kama utaendelea kuwa bakiza nyuma, ");
INSERT INTO swhulb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","basi mkono wa Yahweh utakuwa kinyume dhidi ya mifugo yako shambani na kwa farasi, punda, ngamia, ng'ombe na kondoo, naitasababisha ugonjwa mbaya sana. ");
INSERT INTO swhulb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahweh ata tendea tofauti mifugo ya Israeli na mifugo Misri: Haukuna mnyama wa Waisraeli ataye kufa. ");
INSERT INTO swhulb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahweh ametenga muda; amesema, “Ni kesho ambapo nitafanya ilitukio katika nchi.\"”' ");
INSERT INTO swhulb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yahweh akafanya hivi siku iliyofuata: mifugo yote ya Misri ikafa. Lakini hamna mnyama wa Waisraeli aliye kufa, hamna mnyama ata mmoja. ");
INSERT INTO swhulb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao akafanya utafiti, na tazama, hakuna mnyama ata mmoja aliye kufa. Lakini moyo wake ulikuwa mjeuri, hivyo hakuwaacha watu waende. ");
INSERT INTO swhulb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kisha Yahweh akawambia Musa na Aruni, “Chukuwa majivu na uyajaze mkononi kutoka kwenye tanuru. Wewe, Musa, lazima uyarushe juu wakati Farao akitazama. ");
INSERT INTO swhulb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yatakuwa vumbi safi nchi nzima ya Misri. Yatasababisha majipu na mafua kulipuka kwa watu na wanyama katika nchi yote ya Msri.” ");
INSERT INTO swhulb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Hivyo Musa na Aruni wakachukuwa majivu kutoka kwenye tanuru na kusimama mbele ya Farao. KIsha Musa akarusha majivu juu. Majivu yakasababisha majipu na mafua kutokea kwa watu na wanyama. ");
INSERT INTO swhulb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Waganga hawakuweza kumzuia Musa kwasababu ya majipu, kwasababu majipu yalikuwa kwao na kwa Wamisri wote. ");
INSERT INTO swhulb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yahweh akaufanya moyo wa Farao kuwa mgumu, Farao hakuwasikiliza Musa na Aruni. Hili ndilo Yahweh alilo mwambia Musa Farao atalo fanya. ");
INSERT INTO swhulb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kisha Yahweh akamwambia Musa, Amka asubui mapema, simama mbele ya Farao, na umwambie, 'Yahweh, Mungu wa Waebrania, anasema hivi: Acha watu wangu waende ili wakaniabudu mimi. ");
INSERT INTO swhulb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kwa muda huu nitatuma mapigo kwako wewe, kwa watumishi wako na watu wako. Nitafanya hivi ili ujue hakuna kama mimi kwenye dunia yote. ");
INSERT INTO swhulb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mpaka sasa ningeweza kuunyosha mkono wangu na kukushambulia wewe na watu wako kwa ugonjwa, na ungeondelewa kwenye nchi. ");
INSERT INTO swhulb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Lakini ni kwa sababu hii nimekuruhusu uishi: ili kukuonyesha nguvu zangu, ili kwamba jina langu litangazwe dunia nzima. ");
INSERT INTO swhulb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Bado unajiinua dhidi ya watu wangu kwa kuwaacha wasiende. ");
INSERT INTO swhulb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Sikiliza! Kesho muda kama huu nita leta mvua ya mawe ya barafu kubwa, kama ambayo haijawai kuonekana Misri toka ilipo anza hadi sasa. ");
INSERT INTO swhulb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kisha sasa, tuma wanaume na ukusanye mifugo yako na vitu vyote ulivyo navyo mashambani sehemu salama. Kila mtu na mnyama aliyeko shambani na hajaletwa nyumbani - mawe ya barufu yatawashukia, na watakufa.\"”' ");
INSERT INTO swhulb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kisha hao wa watumishi wa Farao walio amini ujumbe wa Yahweh waka harakisha kuleta watumwa na mifugo yao ndani ya nyumba zao. ");
INSERT INTO swhulb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lakini hao ambao hawa kuchukuwa ujumbe wa Yahweh maanani waliacha watumwa wao na mifugo shambani. ");
INSERT INTO swhulb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kisha Yahweh akamwambia Musa, “Nyoosha mkono wako kuelekea mbingu ili kuwe na mawe ya barafu katika nchi yote ya Misri, kwa watu, kwa wanyama, na kwenye mimea yote shambani na nchi nzima ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa akanyoosha mkono na gongo lake kuelekea mbiguni, na Yahweh akatuma mngurumo, mawe ya barafu, na radi kwenye nchi. Pia alinyesha mvua kwenye nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hivyo kulikuwa na radi iliyo changanyika na mawe ya barafu, ilikuwa hatari sana, kuliko yeyote iliyowai kutokea kwenye nchi ya Misri tangu liwe taifa. ");
INSERT INTO swhulb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Katika nchi yote ya Misri, barafu ya mawe ilipiga kila kitu kwenye shamba, watu na wanyama. Ilipiga kila mmea shambani na kuvunja kila mti. ");
INSERT INTO swhulb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Isipo kuwa tu nchi ya Gosheni, walipo ishi Waisraeli, hapakuwa na mawe ya barafu. ");
INSERT INTO swhulb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kisha Farao akatuma wanaume wakawaite Musa na Aruni. Akawaambia, “Nimetenda dhambi wakati huu. Yahweh ni mwenye haki, na mimi na watu wangu ni waovu. ");
INSERT INTO swhulb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Muombe Yahweh, kwasababu radi na barafu ya mawe imezidi. Nitawaacha muende, na hamtabaki tena hapa.” ");
INSERT INTO swhulb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa akamwambia, “Nitakapo ondoka tu kwenye mji, nitaitanua mikono yangu kwa Yahweh. Mngurumo utaacha, na hakutakuwa na barafu ya mawe tena. Kwa ili utajua kuwa nchi ni ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lakini kwa wewe na watu wako, najua bado hamu mheshimu Yahweh Mungu.” ");
INSERT INTO swhulb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Sasa kitani na shayiri ziliharibiwa, kwa kuwa shayiri ilikuwa katika kukomaa, na kitani ilikuwa imestawi. ");
INSERT INTO swhulb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Lakini ngano na kusemethu hazikupigwa mana zinachelewa kukua. ");
INSERT INTO swhulb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa alipo muacha Farao na mji, alitanua mikono yake kwa Yahweh; mngurumo na barafu ya mawe ikasimama, na mvua haikunyesha tena. ");
INSERT INTO swhulb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao alipoona mvua, barafu ya mawe, na mngurumo umekatika, akatenda dhambi na kufanya moyo wake kuwa mgumu, pamoja na watumishi wake. ");
INSERT INTO swhulb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Moyo wa Farao ulikuwa mgumu, hakuacha watu wa Israeli waende. Hivi ndivyo Yahweh alimwambia Musa Farao atafanya. ");
INSERT INTO swhulb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahweh akamwambia Musa, “Nenda kwa Farao, kwa kuwa nimeufanya moyo wake mgumu na moyo wa watumishi wake. Nimefanya hivi kuonyesha hizi ishara za nguvu zangu miongoni mwao. ");
INSERT INTO swhulb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Pia nimefanya hivi ili muwaambie watoto wenu na wajukuu wenu vitu nilivyo fanya, jinsi nilivyo itendea Misri kwa ukali, na jinsi nilivyo onyesha aina tofauti za ishara za nguvu zangu miongoni mwao. Kwa hili mtajua kuwa mimi ni Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Hivyo Musa na Aruni wakaenda kwa Farao na kumwambia, “Yahweh, Mungu wa Waebrania, anasema hivi: 'Kwa muda gani utaendelea kukataa kujinyenyekesha mbele zangu? Acha watu wangu waenda ili wakaniabudu. ");
INSERT INTO swhulb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Lakini ukikataa kuwaruhusu watu wangu kwenda, sikiliza, kesho nitaleta nzige kwenye nchi yako. ");
INSERT INTO swhulb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Watafunika ardhi ya juu ili kwamba mtu asiweze kuona udongo. Watakula mabaki yote yalio salia kwenye mvua ya barafu ya mawe. Pia watakula kila mti unaokua shambani. ");
INSERT INTO swhulb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Watajaza nyumba zenu, zote za watumishi wenu, na zote za Wamisri wote - jambo ambalo baba zenu wala mababu zenu hawakuwai kuona, jambo ambalo halikuwai shuhudiwa toka walipo kuwa duniani hadi leo.”' Kisha Musa akaondoka na kutoka kwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Watumishi wa Farao wakamwambia, “Mpaka lini huyu mwanaume ata kuwa msumbufu kwetu? Acha Waisraeli waende wakamuabudu Yahweh Mungu wao. Bado haujatambua kuwa Misri imeharibiwa?” ");
INSERT INTO swhulb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musa na Aruni wakaletwa tena kwa Farao, ambaye aliwaambia, “Nendeni amkamuabudu Yahweh Mungu wenu. Lakini watu gani wataenda?” ");
INSERT INTO swhulb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa akasema, “Tutaondoka na wadogo wetu na wakubwa wetu, pamoja na wana wetu na mabinti zetu. Tutaondoka na ng'ombe na kondoo zetu, maana lazima tufanye siku kuu ya Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao akawaambia, “Yahweh kwa kweli awe nanyi, kama nitawaacha muende na wadogo zenu waende. Angalia, una uovu kwenye nia. ");
INSERT INTO swhulb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hapana! Nenda, wanaume tu miongoni mwenu, na mmuabudu Yahweh, kwa kuwa hilo ndilo mnalo litaka.” Kisha Musa na Aruni wakaondolewa uweponi mwa Farao. ");
INSERT INTO swhulb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kisha Yahweh akamwambia Musa, “Nyoosha mkono wako kwenye nchi ya Misri palipo na nzige, ili washambulie nchi ya Misri na kula kila mmea, kila kitu barua ya mawe iliyo acha.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa akanyoosha na gongo lake juu ya nchi ya Misri, na Yahweh akaleta upepo wa mashariki juu ya nchi mchana wote na usiku mzima. Palipo kuwa asubui, upepo wa mashariki ulileta nzige. ");
INSERT INTO swhulb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nzige wakaenda nchi yote ya Misri na kuharibu sehemu zote. Hapajawai kuwa na kundi kama hilo la nzige juu ya nchi, hakuna kama tena kama hilo litawai kutokea. ");
INSERT INTO swhulb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Walifunika ardhi yote ya juu ikawa giza. Walikula kila mmea na kila tunda la miti ambayo barafu ya mawe ilibakiza. Kila eneo la nchi ya Misri, hakuna mmea wa kijani ulibaki, wala mti au mmea wa shambani. ");
INSERT INTO swhulb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kisha Farao akawaita Musa na Aruni na kuwaambia, “Nimefanya dhambi dhidi ya Yahweh na dhidi yako. ");
INSERT INTO swhulb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kisha sasa, nisamehe dhambi yangu wakati huu, na uombe kwa Yahweh Mungu wako aondoe hichi kifo kwangu.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa akaondoka kwa Farao na kumuomba Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yahweh akaleta upepo mkali wa magharibi ulio wachukuwa wale nzige na kuwapeleka Bahari ya Shamu; hakuna nzige ata mmoja aliye baki eneo la Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lakini Yahweh aliufanya moyo wa Farao mgumu, na Farao hakuacha Waisraeli waende. ");
INSERT INTO swhulb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kisha Yahweh akamwambia Musa, “Nyoosha mkono wako kuelekea mbingu, ili kuwe na giza nchi yote ya Misri, giza linalo weza kuhisiwa.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa akanyoosha mkono wake kuelekea mbingu, na kulikuwa na giza nene nchi yote ya Misri kwa siku tatu. ");
INSERT INTO swhulb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hakuna aliye muona mwingine; hakuna aliye toka nyumbani mwake kwa siku tatu. Walakini, Waisraeli wote walikuwa na taa katika sehemu walizo ishi. ");
INSERT INTO swhulb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao alimuita Musa na kusema, “Nenda umuabudu Yahweh. Ata familia zenu za weza kwenda nanyie, lakini ng'ombe zenu na kondoo zenu zitabaki.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Lakini Musa akasema, “Lazima utupe wanyama kwa ajili ya dhabihu na sadaka za kuteketeza ili tuwatoe dhabihu kwa Yahweh Mungu wetu. ");
INSERT INTO swhulb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Mifugo yetu lazima iende na sisi; ata mmoja hawezi kubaki, lazima tuwapeleke wakamuabudu Yahweh Mungu wetu. Kwa kuwa hatujui tutakacho muabudu nacho Yahweh mpaka tufike pale. ");
INSERT INTO swhulb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lakini Yahweh aliufanya moyo wa Farao mgumu, na hakuwaacha waende. ");
INSERT INTO swhulb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao alimwambia Musa, “Toka kwangu! Kuwa muangalifu na jambo moja, kwamba usinione tena, kwa kuwa siku utakapo uona uso wangu, utakufa.” ");
INSERT INTO swhulb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa akasema, “Wewe mwenyewe umesema. Sitauona uso wako tena.” ");
INSERT INTO swhulb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kisha Yahweh akamwambia Musa, “Bado kuna pigo moja nitalo lileta kwa Farao na Misri. Baada ya hilo, atakuacha uondoke hapa. Atakapo kuachia uende, ata kuondoa kabisa. ");
INSERT INTO swhulb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Waelekeze watu kwamba kila mwanaume na mwanamke amuulizie jirani yake vitu vya fedha na vitu vya dhahabu.” ");
INSERT INTO swhulb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Sasa Yahweh aliwafanya Wamisri kuwa na shauku ya kuwapendeza Waisraeli. Aidha, Musa alikuwa wakuvutia sana machoni pa watumishi wa Farao na watu wa Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa akasema, “Yahweh asema hivi: 'Wakati wa usiku wa manane nitaenda Misri yote. ");
INSERT INTO swhulb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Wazaliwa wa kwanza wote wa nchi ya Misri watakufa, kuanzia mzaliwa wa kwanza wa Farao, anaye keti kiti chake cha enzi, mpaka mzaliwa wa kwanza wa misichana mtumwa anaye saga mbegu, na kwa wazaliwa wa kwanza wa mifugo. ");
INSERT INTO swhulb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kisha kutakuwa na kilio kikubwa nchi yote ya Misri, kama ambacho hakijawai wala hakitatokea tena. ");
INSERT INTO swhulb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lakini ata mbwa hata bweka kwa watu wa Israeli, dhidi ya mtu au mnyama. Kwa hili utajuwa kuwa nina watendea Wamisri na Waisraeli tofauti.' ");
INSERT INTO swhulb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Watumishi wote hawa wako, Farao, watakuja chini yangu na kunisujudu mimi. Watasema, 'Nenda, wewe na watu wote wanao kufuata!' Baada ya hapo nitaondoka.” Kisha akaondoka mbele ya Farao kwa hasira kubwa. ");
INSERT INTO swhulb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahweh akamwambia Musa, Farao hatakusikiliza. Hii ni ili nifanye mambo ya ajabu katika nchi ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Aruni wakafanya mambo haya ya kushangaza mbele za Farao. Lakini Yahweh aliufanya moyo wa Farao mgumu, na Farao hakuwaacha watu wa Israeli kuondoka katika nchi yake. ");
INSERT INTO swhulb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahweh akasema na Musa na Aruni katika nchi ya Misri. Alisema, ");
INSERT INTO swhulb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kwako wewe, mwezi huu utakuwa mwanzo wa miezi, mwezi wa kwanza wa mwaka kwako. ");
INSERT INTO swhulb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Liambie kusanyiko la Israeli, 'Siku ya kumi mwezi huu kila mtu lazima achukuwe mwana kondoo au mbuzi mdogo wa kwake, kila familia ifanye hivi, mwana kondoo kwa kila nyumba. ");
INSERT INTO swhulb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kama hiyo nyumba ni ndogo sana kwa mwana kondoo, mwanaume na jirani yake wachukuwe mwana kondoo au nyama ya mbuzi mdogo ambayo itatosha watu. Lazima iwe yatosha kwa kila mtu kula, kwaiyo lazima wachukuwe nyama ya kutosha kulisha wote. ");
INSERT INTO swhulb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mwana kondoo wako au mbuzi wako mdogo lazima asiwe na upungufu, dume mwenye mwaka mmoja. Unaweza kuchukuwa mmoja wa kondoo au mbuzi. ");
INSERT INTO swhulb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Lazima umtunze mpaka siku ya kumi na nne ya huo mwezi. Kisha kusanyiko lote la Israeli lazima liwaue hawa wanyama jioni. ");
INSERT INTO swhulb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Lazima uchukuwe baadhi ya damu na uweke kwenye sehemu mbili za mihimili ya milango na juu ya fremu za milango ambapo utalia hizo nyama. ");
INSERT INTO swhulb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Lazima ule hizo nyama usiku, baada ya kuchoma kwenye moto. Kula na mkate ulio andaliwa kwa hamira, pamoja na mimea michungu. ");
INSERT INTO swhulb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Usiile mbichi au imechemshwa kwenye maji. Badala yake, choma kwenye moto na kichwa chake, miguu na sehemu za ndani. ");
INSERT INTO swhulb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Usiache ata kidogo kubaki mpaka asubui. Lazima uchome chochote kilicho baki asubui. ");
INSERT INTO swhulb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Hivi ndivyo wa paswa kula: ukiwa umefunga mkanda wako, umevaa viatu vyako, na gongo lako mkononi mwako. Lazima ule kwa haraka. Ni Pasaka ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Yahweh anasema hili: Nitaenda katika nchi ya Misri usiku na kushambulia wazaliwa wote wa kwanza wa wanadamu na wanyama katika nchi ya Misri. Nitaleta pigo kwa miungu yote ya Misri. Mimi ni Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Damu itakuwa ishara kwenye nyumba zenu ya kuja kwangu. Nitakapo ona damu, nitapita nitakapo shambulia nchi ya Misri. Ili pigo halitawajia na kuwaharibu. ");
INSERT INTO swhulb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Hii siku itakuwa kumbukumbu kwenu, ambayo lazima muadhimishe kama sherehe ya Yahweh. Itakuwa sheria kwenu pia, kwenye vizazi vyote vya watu wenu, ambayo mwapaswa kuadhimisha leo. ");
INSERT INTO swhulb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Utakula mkate bila hamira wakati wa siku saba. Siku ya kwanza utaondoa hamira kwenye nyumba zenu. Yeyote atakaye kula mkate uliyotiwa chachu kwanzia siku ya kwanza mpaka siku ya saba, huyo mtu lazima akatwe kutoka Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Siku ya kwanza kutakuwa na kusanyiko lililo tengwa kwa ajili yangu, na siku ya saba kutakuwa na kusanyiko kama hilo. Hakuna kazi itakayo fanywa hizi siku, zaidi ya kupika kila mmoja ale. Hiyo ndio kazi pekee itakayo fanywa na wewe. ");
INSERT INTO swhulb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Lazima uadhimishe hii Sherehe ya Mkate Usiotiwa Chachu kwasababu ni siku hii ambayo nitawaleta watu wako, makundi yaliyo na silaha, kwa makundi yaliyo na silaha, kutoka nchi ya Misri. Lazima uadhimishe hii siku kwa vizazi vyote vya watu wako. Hii itakuwa sheria kwako. ");
INSERT INTO swhulb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Lazima ule mkate usiotiwa chachu kuanzia jioni ya siku ya kumi na nne ya mwezi wa kwanza wa mwaka, mpaka jioni ya siku ya ishirini na moja ya mwezi. ");
INSERT INTO swhulb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Wakati wa hizi siku, nyumbani mwenu kusipatikane na hamira. Yeyote atakaye kula mkate ulio andaliwa na hamira lazima akatwe kutoka jamii ya Israeli, huyo mtu awe ni mgeni au mtu aliye zaliwa nchini mwenu. ");
INSERT INTO swhulb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hautakula chochote kilicho andaliwa na hamira. Popote utapo ishi, lazima ule mkate usio na hamira.”' ");
INSERT INTO swhulb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kisha Musa akawaita viongozi wote wa Israeli na kuwaambia, “Nendeni na mchague mwana kondoo au mbuzi watakao tosha kulisha familia zenu na muue mwana kondoo wa pasaka. ");
INSERT INTO swhulb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kisha chukua jani la hisopu na uchovye kwenye damu itakayo kuwa kwenye beseni. Paka damu iliyo kwenye beseni juu ya fremu ya mlango na kwenye mihimili miwili ya mlango. Hakuna ata mmoja atakaye toka nje ya mlango wake mpaka asubui. ");
INSERT INTO swhulb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kwa kuwa Yahweh atapita kushambulia Wamisri. Atakapo ona damu juu ya fremu ya mlango na kwenye mihimili miwili ya mlango, atapita mlango wako na ata ruhusu mharibifu kuja nyumbani kwenu kuwashambulia. ");
INSERT INTO swhulb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Lazima uadhimishe hili tukio. Hili litakuwa daima sheria kwako na kwa uzao wenu. ");
INSERT INTO swhulb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Utakapo ingia nchi Yahweh atakayo kupa, kama alivyo ahidi kufanya, lazima uadhimishe hili tendo la ibada. ");
INSERT INTO swhulb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Watoto wako watakapo kuuliza, 'Hili tendo la ibada lina maana gani?' ");
INSERT INTO swhulb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kisha lazima useme, 'Ni sadaka ya Pasaka ya Yahweh, kwasababu Yahweh kapita nyumba za Waisraeli Misri alipo washambulia Wamisri. Aliweka nyumba zetu huru.”' Kisha watu wakamsujudia Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Waisraeli wakaenda na kufanya kama Yahweh alivyo waamuru Musa na Aruni. ");
INSERT INTO swhulb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ikawa usiku wa manane kuwa Yahweh akawashambulia wazaliwa wote wa kwanza wa nchi ya Misri, kuanzia mzaliwa wa kwanza wa Farao, aliye keti kiti chake cha enzi, mzaliwa wa kwanza wa mtu aliye gerezani na wazaliwa wote wa kwanza wa mifugo. ");
INSERT INTO swhulb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao akaamka usiku - yeye, watumishi wake, na Wamisri. Palikuwa na kelele za maombolezo Misri, kwa kuwa hakukuwa na nyumba ambayo hamna mtu hakufa. ");
INSERT INTO swhulb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao akamuita Musa na Aruni usiku na kusema, “Inuka, tokeni miongoni mwa watu wangu, nyie pamoja na Waisraeli. Nenda, mmuabudu Yahweh, kama mlivyo sema mnataka kufanya. ");
INSERT INTO swhulb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Chukuweni ng'ombe zenu na kondoo zenu, kama mlivyo sema, na muende, na pia mnibariki.” ");
INSERT INTO swhulb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisri walikuwa na haraka ya kuwa ondoa nchini, kwa kuwa walisema, “Sisi ni watu tuliokufa.” ");
INSERT INTO swhulb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Watu wakachukuwa ngano yao pasipo kuongeza hamira yeyote. Bakuli zao zakukandia ngano zilifungiwa kwenye nguo zao na kwenye mabega yao. ");
INSERT INTO swhulb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Watu Waisraeli walifanya kama Musa alivyo waambia. Waliwaomba Wamisri vitu vya fedha, vitu vya dhahabu, na nguo. ");
INSERT INTO swhulb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yahweh aliwafanya Wamisri na shauku ya kuwapendeza Waisraeli. Hivyo Wamisri waliwapa chochote walicho waomba. Katika hili, Waisraeli waliwachukulia vingi Wamisri. ");
INSERT INTO swhulb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waisraeli wakasafiri kutoka Ramesi kwenda Sakothi. Walikuwa na idadi ya wanaume 600, 000 kwa miguu, kuongezea kwa wanawake na watoto. ");
INSERT INTO swhulb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Mchanganyiko wa kundi la wasio Waisraeli pia walienda nao, pamoja na ng'ombe na kondoo, idadi kumbwa ya mifugo. ");
INSERT INTO swhulb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Walioka mikate na unga wa ngano wenye hamira walio utoa Misri. Ulikuwa hauna hamira kwasababu waliondolewa Misri na hawakuweza chelewa kuandaa chakula. ");
INSERT INTO swhulb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waisraeli waliishi Misri kwa miaka 430. ");
INSERT INTO swhulb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Baada ya miaka 430, siku hiyo hiyo, majeshi yote ya Yahweh yalio jiami waliondoka kutoka nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Huu ulikuwa usiku wakuwa macho, ili Yahweh awatoe kutoka nchi ya Misri. Huu ulikuwa usiku wa Yahweh wa kuadhimishwa na Waisraeli wote na watu wa vizazi vyao vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahweh akamwambia Musa na Aruni, “Hii ni sheria ya Pasaka: hakuna mgeni anaye ruhusiwa kuila. ");
INSERT INTO swhulb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Walakini, kila mtumwa wa Misraeli, aliye nunuliwa kwa pesa, anaeza kula baada ya kutahiriwa. ");
INSERT INTO swhulb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Wageni na watumishi waajiriwa hawapaswi kula chakula chochote. ");
INSERT INTO swhulb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Chakula chapaswa kuliwa ndani ya nyumba moja. Hauruhusiwi kubeba nyama yeyote nje ya nyumba, na hauruhusiwi kuvunja mfumba wowote. ");
INSERT INTO swhulb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Jamii zote za Israeli za paswa kuadhimisha sherehe. ");
INSERT INTO swhulb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kama mgeni anaishi na wewe na anataka kuadhimisha Pasaka kwa Yahweh, ndugu zake wote wa kiume wapaswa kutahiriwa. Kisha anaeza kuja na kuadhimisha. Atakuwa kama watu walio zaliwa kwenye nchi. Walakini, hakuna mtu asiye tahiriwa anaruhusiwa kula chakula chochote. ");
INSERT INTO swhulb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sheria hii hii itahusika kwa mzaliwa wa asili na mgeni anayeishi miongoni mwenu.” ");
INSERT INTO swhulb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waisraeli wote walifanya kama Yahweh alivyo waamuru Musa na Aruni. ");
INSERT INTO swhulb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ikaja kuwa siku hiyo Yahweh akawaleta Israeli kutoka nchi ya Misri kwa makundi yalio jiami. ");
INSERT INTO swhulb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahweh akasema na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nitengee wazaliwa wote wa kwanza, kila mzaliwa wa kwanza wa Waisraeli, watu na wanyama. Mzaliwa wa kwanza ni wangu.” ");
INSERT INTO swhulb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa akawambia watu, “Hii kumbukeni hii siku, siku mliyo toka Misri, kutoka nyumba ya utumwa, kwa mkono hodari wa Yahweh amewatoa kutoka hii sehemu. Hakuna mkate wa hamira waruhusiwa kuliwa. ");
INSERT INTO swhulb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mnatoka Misri hii siku, mwezi wa Abibu. ");
INSERT INTO swhulb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yahweh atakapo waleta nchi ya Wakanani, Wahiti, Waamori, Wahivi, na Wayebusi, nchi aliyo waapia mababu zenu kuwapa, nchi inayo tiririka kwa maziwa na asali - kisha wapaswa kuadhimisha hili tendo la ibada kila mwezi. ");
INSERT INTO swhulb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwa siku saba utakula mkate bila hamira; siku ya saba kutakuwa na maakuli ya kumuadhimisha Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mkate usio na hamira wapaswa kuliwa kwa siku saba zote; hakuna mkate ulio na hamira wapaswa kuliwa miongoni mwenu. Hakuna hamira yapaswa kuonekana kwenye mipaka yenu. ");
INSERT INTO swhulb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Hiyo siku utasema kwa watoto wako, 'Hii ni kwasababu ya kile Yahweh alichofanya kwangu nilipo taka Misri.' ");
INSERT INTO swhulb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Hii itakuwa kumbukumbu mkononi mwako, na kumbukumbu kwenye paji la uso wako. Hii ni ili sheria ya Yahweh iwe kinywani mwako, maana kwa mkono hodari Yahweh amewatoa kutoka Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kisha basi wapaswa kushika hii sheria kwa wakati uliyo kusudiwa kutoka mwaka hadi mwaka. ");
INSERT INTO swhulb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Yahweh atakapo waleta kwenye nchi ya Wakanani, kama alivyo apa kwenu na kwa mababu zenu kufanya, na atakapo wapa nchi ninyi, ");
INSERT INTO swhulb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","lazima umtengee mzaliwa wa kwanza mtoto na uzao wa kwanza wa wanyama wenu. Wakiume watakuwa wa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kila mzaliwa wa kwanza wa punda lazima umnunue tena na mwana kondoo. Kama hautamnunua tena, lazima uivunje shingo yake. Lakini kila mzaliwa wa kwanza wakiume miongoni mwenu - lazima umnunue tena. ");
INSERT INTO swhulb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mwanae atakapo kuuliza baadae, 'Hii ina maana gani?' kisha utamwambia, 'Ni kwa mkono hodari Yahweh katutoa Misri, kutoka nyumba ya utumwa. ");
INSERT INTO swhulb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao alipo kataa kwa ujeuri kutuachia twende, Yahweh aliwaua wazaliwa wa kwanza wa nchi ya Misri, wazaliwa wa kwanza wa watu na wa wanyama. Ndio sababu ninatoa dhabihu kwa Yahweh kwa kila mzaliwa wa kwanza wa kila mnyama, na pia sababu nina nunua wazaliwa wa kwanza wa wanangu tena.' ");
INSERT INTO swhulb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Hii itakuwa kumbukumbu mikononi mwako na kumbukumbu kwenye paji lako la uso, kwa kuwa ni kwa mkono hodari Yahweh alitutoa kutoka Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao alipo waachia watu waende, Mungu akuwaongoza kwa njia ya Wafilisti, japo hiyo njia ilikuwa karibu. Kwa kuwa Mungu alisema, “Labda watu watabadili nia zao watakapo ona vita na watarudi Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hivyo Mungu akawaongoza watu kuzunguka nyikani kupita Bahari ya Shamu. Waisraeli waliondoka kutoka nchi ya Misri wakiwa wamejiami kwa pambano. ");
INSERT INTO swhulb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa akachukuwa mifupa ya Yusufu pamoja naye, kwa kuwa Yusufu aliwaapisha Waisraeli na kusema, “Mungu atawaokoa, na muibebe mifupa yangu na nyie.” ");
INSERT INTO swhulb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Waisraeli walisafiri kutoka Sakothi na kuweka kambi Ethamu pembezoni mwa nyikani. ");
INSERT INTO swhulb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahweh alitangulia mbele yao mchana kama nguzo ya wingu kuwaongoza njiani. Usiku alienda kama nguzo ya moto kuwapa mwanga. Kwa namna hii waliweza kusafiri mchana na usiku. ");
INSERT INTO swhulb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yahweh hakuchukuwa kutoka kwa watu nguzo ya wingu mchana wala nguzo ya moto usiku. ");
INSERT INTO swhulb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahweh akasema na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Waambie Waisraeli wageuke na kueka kambi mbele ya Pi Hahirothi, katikati ya Migdoli na bahari, mbele ya Baali Zefoni. Wapaswa kueka kambi pembenni ya Pi Hahirothi. ");
INSERT INTO swhulb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao atasema kuhusu Waisraeli, 'Wanaangaika kwenye nchi. Nyikani imewafunika.' ");
INSERT INTO swhulb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nitaufanya moyo wa Farao mgumu, na yeye ata wakimbiza. Nitapata utukufu kwasababu ya Farao na jeshi lake lote. Wamisri watajua mimi ni Yahweh.” Kisha Waisraeli wakaeka kambi kama walivyo elekezwa. ");
INSERT INTO swhulb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mfalme wa Misri alipo ambiwa Waisraeli wametoroka, nia ya Farao na watumishi wake ikageuka dhidi ya watu. Wakasema, “Tumefanya nini kwa kuwaacha Waisraeli waende huru na wasitutumikie?” ");
INSERT INTO swhulb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kisha Farao akachukuwa magari yake ya farasi na jeshi lake. ");
INSERT INTO swhulb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Alichukuwa magari ya farasi mia sita imara na magari yote ya farasi ya Misri, pamoja na maafisa wa hayo magari. ");
INSERT INTO swhulb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yahweh akafanya mgumu moyo wa Farao, mfalme wa Misri, na mfalme akawafukuzia Waisraeli. Sasa Waisraeli waliondoka kwa shangwe. ");
INSERT INTO swhulb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Lakini Wamisri wali wafukuzia, pamoja na farasi na magari ya farasi, wapanda farasi, na jeshi lake. Walikuta Waisraeli wameeka kambi pembezoni mwa bahari kati ya Pi Hahirothi na Baali Zefoni. ");
INSERT INTO swhulb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Farao alipo karibia, Waisraeli walitaza juu na kushangaa. Wamisri walikuwa wakija kwao, na waliogopa. Waisraeli walimlilia Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Walimwambia Musa, “Ni kwasababu hakukuwa na makaburi Misri, hadi umetuleta tufe huku nyikani? Kwanini umetutendea hivi, kwa kututoa Misri? ");
INSERT INTO swhulb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Hili si ndilo tulilo kwambia Misri? Tulikwambia, 'Utuache, ili tuwafanyie Wamisri kazi.' Ingekuwa bora kwetu sisi kuwafanyia kazi kuliko kufa nyikani.” ");
INSERT INTO swhulb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa akawaambia watu, “Msiogope. Simameni imara na muone wokovu Yahweh atakao uleta kwenu leo. Kwa maana hamtawaona tena Wamisri mnao waona leo. ");
INSERT INTO swhulb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh ata wapigania, na ninyi mtasima imara.” ");
INSERT INTO swhulb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kisha Yahweh akamwambia Musa, “Kwanini wewe, Musa, unaendelea kuniita mimi? Waambie Waisraeli waendelee mbele. ");
INSERT INTO swhulb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nyanyua gongo lako juu, nyoosha mkono wako kuelekea baharini na uigawanye sehemu mbili, ili watu wa Israeli wapite baharini kwenye nchi kavu. ");
INSERT INTO swhulb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Jitahadharishe kuwa nitafanya mioyo ya Wamisri kuwa migumu ili wawafuate. Nitapata utukufu kwasababu ya Farao na jeshi lake lote, magari yake ya farasi, na wapanda farasi. ");
INSERT INTO swhulb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kisha Wamisri watajua kuwa mimi ni Yahweh nitakapo pata utukufu kwasababu ya Farao, magari yake ya farasi, na wapanda farasi wake.” ");
INSERT INTO swhulb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Malaika wa Mungu, aliyeenda mbele ya Waisraeli, aliama na kwenda nyuma yao. Nguzo ya wingu ili sogea mbele yao na kwenda kusimama nyumba yao. ");
INSERT INTO swhulb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Wingu lilikuja katikati ya kambi ya Misri na kambi ya Israeli. Lilikuwa wingu jeusi kwa Wamisri, lakini liliangaza usiku kwa ajili ya Waisraeli, hivyo upande mmoja haukuweza kuja karibu ya mwingine usiku wote. ");
INSERT INTO swhulb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa akanyoosha mkono wake kuelekea bahari. Yahweh akasogeza bahari nyuma kwa upepo mkali wa mashariki usiku huo wote na kufanya bahari nchi kavu. Kwa namna hii maji yaligawanyika. ");
INSERT INTO swhulb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Waisraeli walienda katikati ya bahari kwa nchi kavu. Maji yaliunda ukuta mkono wao wa kulia na mkono wao wa kushoto. ");
INSERT INTO swhulb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wamisri waka wafukuzia. Wali wafuata hadi katikati ya bahari - farasi wote wa Farao, magari ya farasi, na wapanda farasi. ");
INSERT INTO swhulb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Lakini masaa ya mapema ya asubui, Yahweh alitazama chini jeshi la Wamisri kupitia nguzo ya moto na wingu. Alisababisha hofu miongoni mwa Wamisri. ");
INSERT INTO swhulb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Magari yao ya farasi yalikuwa yana kwama matairi, na wapanda farasi waliendesha kwa ugumu. Hivyo Wamisri walisema, “Acha tuwakimbie Waisraeli, kwa kuwa Yahweh anawapigania dhidi yetu.” ");
INSERT INTO swhulb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahweh akamwambia Musa, “Nyoosha mkono kuelekea bahari ili maji yawarudie Wamisri, magari yao ya farasi, na wapanda farasi wao.” ");
INSERT INTO swhulb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Hivyo Musa akanyoosha mkono wake kuelekea bahari, na ikarudi kwenye hali yake ya kawaida palipo pambazuka. Wamisri walikimbilia ndani ya bahari, na Yahweh akawaingiza Wamisri katikati ndani yake. ");
INSERT INTO swhulb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maji yakarudi na kufunika magari ya farasi ya Farao, wapanda farasi, na jeshi lake lote lililo fuata magari ya farasi kwenye bahari. Hakuna aliyepona. ");
INSERT INTO swhulb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Walakini, Waisraeli walitembea kwenye nchi kavu katikati ya bahari. Maji yalikuwa ukuta kwao mkono wa kulia na mkono wa kushoto. ");
INSERT INTO swhulb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hivyo Yahweh akaokoa Israeli hiyo siku kutoka mkono wa Wamisri, na Israeli ikaona maiti za Wamisri ufukweni. ");
INSERT INTO swhulb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israeli ilipoona nguvu kubwa Yahweh aliyo itumia dhidi ya Wamisri, watu walimsifu Yahweh, na kumwamini Yahweh na mtumishi wake Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kisha Musa na watu wa Israeli wakaimba hii nyimbo kwa Yahweh. Waliimba, “Nitaimba kwa Yahweh, kwa kuwa ameshinda kwa utukufu; farasi na dereva wake amewatupa kwenye bahari. ");
INSERT INTO swhulb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh ni uweza wangu na nyimbo yangu, na amekuwa wokovu wangu. Huyu ni Mungu wangu, na nitamsifu, Mungu wa baba yangu, nitamtukuza. ");
INSERT INTO swhulb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh ni shujaa; Yahweh ni jina lake. ");
INSERT INTO swhulb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ametupa magari ya farasi ya Farao na jeshi lake kwenye bahari. Maafisa wa Farao hodari walizama kwenye Bahari ya Shamu. ");
INSERT INTO swhulb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kina kiliwafunika; walienda kwenye kina kama jiwe. ");
INSERT INTO swhulb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mkono wako wakulia, Yahweh, una nguvu ya utukufu; mkono wako, Yahweh, umewavunja adui. ");
INSERT INTO swhulb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kwa utukufu mkubwa umewapindua walio inuka dhidi yako. Umetuma gadhabu; imewateketeza kama karatasi. ");
INSERT INTO swhulb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kwa pumzi ya pua yako maji yalijaa; maji yanayo tembea yalisimama wima na kujaa juu; maji yalikuwa manene ndani ya kilindi cha bahari. ");
INSERT INTO swhulb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Adui alisema, 'Nitakimbiza, nitapita, nitagawa nitakacho chukuwa; tamanio langu litatimizwa kwao; nitavuta upanga wangu; mkono wangu utawaharibu wao.' ");
INSERT INTO swhulb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lakini ulipuliza kwa upepo wako, na bahari ikawafunika wao; walizama kama chuma nzito kwenye maji mengi. ");
INSERT INTO swhulb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ni nani kama wewe, Yahweh, miongoni mwa miungu? Nani kama wewe, mtakatifu wa utukufu, katika sifa umetukuzwa, anaye fanya miujiza? ");
INSERT INTO swhulb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ulinyoosha mkono wako wa kulia, na dunia ikawameza. ");
INSERT INTO swhulb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Katika uaminifu wa agano lako umewaongoza watu ulio waokoa. Katika uweza wako umewaongoza katika sehemu takatifu unayo ishi. ");
INSERT INTO swhulb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Watu watasikia, na watatetemeka; hofu itawakumba wakazi wa Filistia. ");
INSERT INTO swhulb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Kisha wazee wa Edomu wataogopa; wanajeshi wa Moabu watetemeka; wakazi wote wa Kanani watayayuka. ");
INSERT INTO swhulb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Mshituko na hofu vitawaangukia. Kwasababu ya nguvu ya mkono wako, watakuwa kimya kama jiwe hadi watu wako watakapo pita, Yahweh - hadi watu ulio waokoa watakapo pita. ");
INSERT INTO swhulb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Utawaleta na kuwapanda kwenye mlima wa urithi wako, sehemu, Yahweh, ulio jenga ya kuishi, sehemu takatifu, Bwana wetu, mikono yako iliyo jenga. ");
INSERT INTO swhulb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahweh ata tawala milele na milele.” ");
INSERT INTO swhulb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kwa kuwa farasi wa Farao walienda na magari ya farasi na wapanda farasi kwenye bahari. Yahweh alileta maji ya bahari juu yao. Lakini Waisraeli walienda juu ya nchi kavu katikati ya bahari. ");
INSERT INTO swhulb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriamu nabii wa kike, dada wa Aruni, akanyanyua tari, na wanawake wote wakatoka na matari, wakicheza nae. ");
INSERT INTO swhulb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu akawaimbia: “Muimbieni Yahweh, kwa kuwa ameshinda kwa utukufu. Farasi na mpanda farasi amewatupa baharini. ");
INSERT INTO swhulb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kisha Musa akaongoza Israeli mbele kupita Bahari ya Shamu. Walienda nyikani ya Shuri. Walisafiri kwa siku tatu nyikani pasipo kuona maji yeyote. ");
INSERT INTO swhulb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kisha wakaja Mara, lakini hawakunywa maji ya huko kwasababu yalikuwa machungu. Hivyo wakaita hiyo sehemu Mara. ");
INSERT INTO swhulb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Hivyo watu wakamlalamikia Musa na kusema, “Nini tunaweza kunywa?” ");
INSERT INTO swhulb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa akamlilia Yahweh, na kumonyesha mti. Musa akautupa kwenye maji, na maji yakawa matamu kunywa. Ndio pale Yahweh alipowapa sheria kali, na ndio pale alipo wajaribu. ");
INSERT INTO swhulb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Alisema, “Kama utasikiliza sauti ya Yahweh Mungu wako kwa umakini, na kufanya yalio sahihi machoni pake, na kama utatega sikio kwa amri zake na kutii sheria zake zote - sitawaekea ninyi magonjwa yale niliyo waekea Wamisri, kwa kuwa mimi ni Yahweh ninaye kuponya.” ");
INSERT INTO swhulb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kisha watu wakaja Elimu, palipo kuwa na chemichemi kumi na mbili za maji na miti sabini ya mtende. Walieka kambi hapo pembeni ya maji. ");
INSERT INTO swhulb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Watu wakaendelea na safari kutoka Elimu, na jamii yote ya Waisraeli ikaja nyikani mwa Sinu, iliyopo katikati ya Elimu na Sinai, siku ya kumi na tano ya mwezi wa pili walipo toka Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Jamii yote ya Waisraeli wali walalamikia Musa na Aruni nyikani. ");
INSERT INTO swhulb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Waisraeli waliwaambia, “Kama tu tungekufa kwa mkono wa Yahweh nchi ya Misri tulipo kuwa tumeketi kwenye vyombo vya nyama na tulikuwa tunakula mkate kwa tele. Maana umetuleta nyikani uuwe jamii zetu zote kwa njaa.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kisha Yahweh akamwambia Musa, “Nitakunyeshea mvua ya mkate. Watu wataenda na kukusanya kiasi cha siku kila siku ili niwajaribu kama wataendelea kushika sheria yangu au hapana. ");
INSERT INTO swhulb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Itakuja kuwa siku ya sita, kwamba watakusanya mara mbili zaidi ya wanavyo kusanyaga, na watapika wanacholeta.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kisha Musa na Aruni wakawaambia watu wote wa Israeli, “Jioni mtajua kuwa ni Yahweh aliye waleta kutoka nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Asubui utaona utukufu wa Yahweh, kwa maana anasikia mna mlalamikia. Sisi ni nani hadi mtulalamikie?” ");
INSERT INTO swhulb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa pia akasema, “Utajua hili pale Yahweh atakapo kupa nyama jioni na mkate asubui kwa tele - kwa kuwa amesikia malalamishi mnayo tamka dhidi yake. Nani ni Aruni na mimi? Malalamishi yenu sio dhidi yetu; ni dhidi ya Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa akamwambia Aruni, “Sema kwa jamii yote ya watu wa Israeli, 'Njoo karibu ya Yahweh, kwa kuwa amesikia malalamishi yenu.'” ");
INSERT INTO swhulb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ikawa, Aruni alipo sema na jamii yote ya watu wa Israeli, wakaangalia kuelekea nyikani, na, tazama, utukufu wa Yahweh ukatokea kwenye wingu. ");
INSERT INTO swhulb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Kisha Yahweh akasema na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nimesikia malalamishi ya watu wa Israeli. Sema nao na useme, 'Jioni utakula nyama, na asubui utashiba mkate. Kisha utajua mimi ni Yahweh Mungu wako.'” ");
INSERT INTO swhulb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ikaja kuwa kwamba jioni kware wakaja juu na kufunika kambi. Asubui umande ulitanda kambini. ");
INSERT INTO swhulb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Umande ulipo kwisha, pale juu ya ardhi ya nyikani kulikuwa na kama barafu iliyo ganda kwenye ardhi. ");
INSERT INTO swhulb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Watu wa Israeli walipo ona, walisema mmoja kwa mwenzake, “Hii ni nini?” Hawakujua ilikuwa ni nini. Musa akawaambia, “Ni mkate Yahweh aliyo wapa mle. ");
INSERT INTO swhulb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hii ni amri Yahweh aliyotoa: 'Lazima ukusanye, kila mmoja wenu, kiasi unacho itaji kula, lita mbili kwa kila mtu. Hivi ndivyo utakavyo kusanya: Kusanya cha kutosha kula cha kila mtu anaye ishi hemani mwako.'” ");
INSERT INTO swhulb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Watu wa Israeli wakafanya hivyo. Baadhi wakakusanya zaidi, baadhi wakakusanya kidogo. ");
INSERT INTO swhulb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Walipo pima kwa kipimo cha lita, hao walio kusanya zaidi hawakuwa na kilicho salia, na hao walio kusanya kidogo hawakuwa na pungufu. Kila mmoja alikusanya cha kutosha kukidhi maitaji yake. ");
INSERT INTO swhulb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kisha Musa akawaambia, “Hakuna ata mmoja kubakiza hadi asubui.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Walakini, hawakumsikiliza Musa. Baadhi yao waliacha baadhi hadi asubui, lakini ilizalisha wadudu na kuwa batili. Kisha Musa akawa na hasira juu yao. ");
INSERT INTO swhulb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Walikusanya asubui kwa asubui. Kila mtu alikusanya cha kutosha kula kwa hiyo siku. Jua lilipo kuwa kali, ili yayuka. ");
INSERT INTO swhulb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","siku ya sita walikusanya mkate mara mbili zaidi, lita mbili kwa kila mtu. Viongozi wote wa jamii walikuja na kumwambia hili kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Aliwaambia, “Hili ndilo Yahweh alililo lisema: 'Kesho ni mapumziko ya kujiliwaza, sabato takatifu kwa utukufu wa Yahweh. Oka kile unataka kuoka, na chemsha kile unataka kuchemsha. Vyote vitakavyo baki, jihifadhie hadi asubui.”' ");
INSERT INTO swhulb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hivyo wakaeka pembeni hadi asubui, kama Musa alivyo elekeza. Haikuharibika, wala haikuwa na mdudu yeyote. ");
INSERT INTO swhulb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa alisema, “Kula hicho cha kula leo, kwa kuwa leo ni siku iliyo tengwa ya kumtukuza Yahweh. Leo hamtaikuta mashambani. ");
INSERT INTO swhulb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mtaikusanya ndani ya siku sita, lakini siku ya saba ni Sabato. Siku ya Sabato hakuta kuwa na manna.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ilikuja kuwa siku ya saba ambapo baadhi ya watu walienda kukusanya manna, lakini hawakukuta ");
INSERT INTO swhulb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kisha Yahweh akamwambia Musa, Kwa muda gani utaendelea kukataa kushika amri zangu na sheria zangu? ");
INSERT INTO swhulb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tazama, Yahweh amekupa Sabato. Hivyo siku ya sita anakupa mkate wa siku mbili. Kila mmoja wenu lazima akae kwenye sehemu yake; hakuna hata mmoja wa kutoka sehemu yake siku ya saba.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hivyo watu watapumzika siku ya saba. ");
INSERT INTO swhulb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Watu wa Israeli walikiita chakula kile “manna.” Ilikuwa ni nyeupe kama mbegu ya mgiligani, na ladha yake kama maandazi yaliyo pikwa na asali. ");
INSERT INTO swhulb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa akasema, “Hili ndilo Yahweh alilo amuru: 'Acha lita mbili ya manna ihifadhiwe kwa ajili vizazi vya watu wako ili kwamba uzao wako uone mkate niliyo kulisha nyikani, baada ya kukutoa kutoka nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa akamwambia Aruni, “Chukuwa jagi na uweke lita mbili za manna ndani yake. Hifadhi kwa Yahweh i dumu vizazi vyote vya watu.” ");
INSERT INTO swhulb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kama Yahweh alivyo muamuru Musa, Aruni akahifadhi pembeni mwa mawe yaliyo kuwa na amri za agano. ");
INSERT INTO swhulb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Watu wa Israeli walikula manna miaka arobaini mpaka walipo kuja nchi yenye watu. Walikula mpaka walipo fika kwenye mipaka ya nchi ya Kanani. ");
INSERT INTO swhulb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Lita mbili ni makumi ya efa. ");
INSERT INTO swhulb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Jamii yote ya Israeli ili safiri kutoka nyikani ya Sinu, wakifuata maelekezo ya Yahweh. Walieka kambi Refidimu, lakini hapakuwa na maji ya watu kunywa. ");
INSERT INTO swhulb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Hivyo watu wakamlaumu Musa kwa hali yao na kusema, “Tupe maji ya kunywa.” Musa akasema, “Kwanini mnagombana na mimi? Kwanini mnajaribu Yahweh?” ");
INSERT INTO swhulb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Watu walikuwa na kiu sana, na waka mlalamikia Musa. Wakasema, “Kwanini umetutoa Misri? Ili utuue sisi na watoto wetu na mifugo yetu kwa kiu?” ");
INSERT INTO swhulb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kisha Musa akamlilia Yahweh, “Nini ni fanya kwa hawa watu? Wako tayari ata kunipiga mawe.” ");
INSERT INTO swhulb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh akamwambia Musa, “Nenda mbele yao, na uchukuwe baadhi ya wazee wa Israeli. Chukuwa gongo ulilo piga nalo mto, na uende. ");
INSERT INTO swhulb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nitasimama mbele yako pale kwenye mwamba wa Horebu, na utaupiga mwamba. Maji yatatoka ya watu kunywa.” Kisha Musa akafanya hivyo mbele ya wazee wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Aliita ile sehemu Massa na Meriba kwasababu ya malalamishi ya Waisraeli, na kwasababu walimjaribu Bwana kwa kusema, “Je Yahweh yupo miongoni mwetu au hapana?” ");
INSERT INTO swhulb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kisha jeshi la watu wa Ameleki wakaja na kushambulia Israeli huko Refidimu. ");
INSERT INTO swhulb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Hivyo Musa akamwambia Yoshua, “Chagau wanaume kadha na uende nje. Pigana na Ameleki. Kesho nitasimama juu ya kilima na gongo la Mungu mkononi mwangu.” ");
INSERT INTO swhulb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Hivyo Yoshua akapigana na Ameleki kama Musa alivyo elekeza, wakati Musa, Aruni, na Huri walienda juu ya kilima. ");
INSERT INTO swhulb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Wakati Musa alipo kuwa ameshikilia mikono yake juu, Israeli ilikuwa yashinda; alipo acha mikono yake ipumzike, Ameleki alianza kushinda. ");
INSERT INTO swhulb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mikono ya Musa alipo kuwa mizito, Aruni na Huri walichukuwa jiwe na kuweka chini yake alikalie. Muda huo huo, Aruni na Huri walinyanyua mikono yake juu, mtu mmoja upande mmoja, na mtu mmoja upande mwingine. Hivyo mikono ya Musa ilishikiliwa tuli mpaka jua lilipo zama. ");
INSERT INTO swhulb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hivyo Yoshua akawashinda watu wa Ameleki kwa upanga. ");
INSERT INTO swhulb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahweh akamwambia Musa, “Andika haya kwenye kitabu na umsomee Yoshua, kwasababu nitaondoa kumbukumbu ya Ameleki kutoka chini ya mbingu.” ");
INSERT INTO swhulb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kisha Musa akajenga madhabahu na kuiita “Yahweh ni bendera yangu.” ");
INSERT INTO swhulb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Alisema, “Kwa kuwa mkono ulinyanyuliwa juu kuelekea kiti cha enzi cha Yahweh - kwamba Yahweh ata fanya vita na Ameleki vizazi na vizazi.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yethro, kuhani wa Midiani, baba mkwe wake Musa, alisikia yote Mungu aliyo fanya kwa Musa na kwa Israeli watu wake. Alisikia Yahweh ametoa Israeli kutoka Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Yethro, baba mkwe wake Musa, akamchukuwa Zipora, mke wa Musa, baada ya kumpeleka nyumbani, ");
INSERT INTO swhulb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","na wana wake wawili; jina mmoja lilikuwa Gershomu, kwa kuwa Musa alisema, “Nimekuwa mgeni katika nchi ya kigeni.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Jina la mwingine lilikuwa Eliezeri, kwa kuwa Musa alisema, “Mungu wa babu yangu alikuwa msaada wangu. Aliniokoa na mkono wa Farao.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yethro, baba mkwe wake Musa, alikuja na watoto wake Musa na mke wake Musa nyikani alipo eka kambi katika mlima wa Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Alimwambia Musa, “Mimi, baba mkwe wako Yethro, nina kuja kwako na mke wako na wanao wawili.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa alitoka kwenda kukutana na baba mkwe wake, akamwinamia, na kumbusu. Wakajuliana hali na wakaingia ndani ya hema. ");
INSERT INTO swhulb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa akamwambia baba mkwe wake yale yote Yahweh aliyo ya fanya kwa Farao na Wamisri kwa ajili ya Waisraeli, magumu yote yaliyo watoke njianim na jinsi Yahweh alivyo waokoa. ");
INSERT INTO swhulb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yethro akafurahia yale mema yote Yahweh aliyo watendea Israeli, kwa hilo amewaokoa na mkono wa Wamisri. ");
INSERT INTO swhulb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yethro akasema, “Yahweh atukuzwe, kwa kuwa amekuokoa na mkono wa Wamisri na mkono wa Faraom na kuwatoa watu kwenye mkono wa Wamisri. ");
INSERT INTO swhulb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sasa najua Yahweh ni mkuu kuliko miungu yote, kwasababu Wamisri walipo watenda Waisraeli kwa kiburi, Mungu aliwaokoa watu wake.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yethro, baba mkwe wake Musa, akaleta sadaka ya kuteketeza na dhabihu kwa Mungu. Aruni na wazee wote wa Israeli wakaja kula chakula mbele za Yahweh na baba mkwe wake Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Siku iliyofuata Musa aliketi kuwa hukumu watu. Watu walisimama kumzunguka Musa kwanzia asubui hadi jioni. ");
INSERT INTO swhulb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Baba mkwe wake Musa alipo ona yale yote aliyo yafanya kwa watu, alisema, “Ni nini unachofanya na watu? Kwanini unaketi peke yako na watu wote wamesimama kukuzunguka asubui hadi jioni?” ");
INSERT INTO swhulb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa akamwambia baba mkwe wake, “Watu wanakuja kuniuliza muongozo wa Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wanapo kuwa na malumbano, wanakuja kwangu. Ninaamua kati ya mtu mmoja na mwingine, na nina wafundisha maagizo na sheria.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Baba mkwe wake Musa alimwambia, “Unachofanya sicho kizuri sana. ");
INSERT INTO swhulb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Hakika utajichosha, wewe na watu waliyopo na wewe. Huu mzigo ni mzito sana kwako. Hauwezi kufanya peke yako. ");
INSERT INTO swhulb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nisikilize. Nitakupa ushauri, na Mungu ata kuwa na wewe, kwasababu wewe nimwakilishi wa watu kwa Mungu, na una leta malumbano yao kwake. ");
INSERT INTO swhulb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Lazima uwafundishe maagizo yake na sheria. Lazima uwafundishe njia yakutembea na kazi ya kufanya. ");
INSERT INTO swhulb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mbali zaidi, lazima uchague wanaume wenye uwezo kutoka watu wote, wanaume wanao muheshimu Mungu, wanaume wa kweli wanao chukuia mapato ya ufisadi. Lazima uwaeke juu ya watu, kuwa viongozi wa maelfu, mamia, hamsini, na makumi. ");
INSERT INTO swhulb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Watawa hukumu watu na kesi za kawaida, lakini kesi ngumu wataleta kwako. Kwa kesi ndogo, wanaweza kuhukumu wenyewe. Kwa hivyo itakuwa rahisi kwako, na watabeba mzigo na wewe. ");
INSERT INTO swhulb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ukifanya hivi, na kama Mungu akikuamuru kufanya al kadhalika, basi utaweza kuvumilia, na watu wote watarudi nyumbani wameridhika.” ");
INSERT INTO swhulb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Hivyo Musa akasikiliza maneno ya baba mkwe wake na akafanya yale yote aliyo yasema. ");
INSERT INTO swhulb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa alichagua wanaume wenye uwezo kutoka Israeli na kuwa fanya vichwa juu ya watu, viongozi wahusika wa maelfu, mamia, hamsini, na makumi. ");
INSERT INTO swhulb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Waliwa hukumu watu katika hali za kawaida. Kesi ngumu walimletea Musa, lakini wao wenyewe wali hukumu kesi ndogo. ");
INSERT INTO swhulb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kisha Musa akamwacha baba mkwe wake kuondoka, na Yethro akarudi kwenye nchi yake. ");
INSERT INTO swhulb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Katika mwezi wa tatu baada ya watu wa Israeli kutoka Misri, siku hiyo, walikwenda nyikani ya Sinai. ");
INSERT INTO swhulb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Walipo ondoka Refidimu na kuja nyikani ya Sinai, walieka kambi mbele ya mlima. ");
INSERT INTO swhulb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa akaenda juu kwa Mungu. Yahweh alimuita kutoka mlimani na kusema, “Lazima uiambie nyumba ya Yakobo, watu wa Israeli: ");
INSERT INTO swhulb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Uliona nilicho fanya kwa Wamisri, jinsi nilivyo kubeba kwa mabawa ya tai na kukuleta kwangu. ");
INSERT INTO swhulb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kisha sasa, ukinisikiliza kwa utii sauti yangu na kushika agano langu, kisha utakuwa mali yangu ya pekee miongoni mwa watu wote, kwa kuwa dunia yote ni yangu. ");
INSERT INTO swhulb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Utakuwa ufalme wa kikuhani na taifa takatifu langu. Haya ni maneno wapaswa kuwaambia Waisraeli. ");
INSERT INTO swhulb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Hivyo Musa akaja na kuwaita wazee wa watu. Aliweke mbele yao maneno yote haya Yahweh aliyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Watu wote walijibu pamoja na kusema, “Tutafanya yote Yahweh aliyo tuambia.” Kisha musa akaja kutoa taarifa ya maneno watu kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahweh akamwambia Musa, “Nitakuja kwako kwa wingu nene ili watu wasikie ninapo sema na wewe na wakuamini milele.” Kisha Musa kamwambia Yahweh maneno ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahweh akamwambia Musa, “Nenda kwa watu. Leo na kesho lazima uwatenge, na kuwafanya waoshe mavazi yao. ");
INSERT INTO swhulb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kuwa tayari kwa siku ya tatu, kwa kuwa siku ya tatu Yahweh atashuka chini ya Mlima Sayuni. ");
INSERT INTO swhulb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Lazima uweke mipaka kote kuzunguka mlima kwa ajili ya watu. Uwaambie, 'Kuweni waangalifu msiende juu ya mlima au kushika mipaka yake. Yeyote atakaye shika mlima ata uawa.' ");
INSERT INTO swhulb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hakuna mkono wa mtu yeyote kumshika mtu huyu. Badala yake, lazima apigwe mawe au kuchomwa mshale. Iwe ni mtu au mnyama, lazima auawe. Tarumbeta itakapo pigwa muda mrefu, wanaweza kuja chini ya mguu wa mlima.” ");
INSERT INTO swhulb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kisha Musa akashuka mlimani kwenda kwa watu. Aliwatenga watu kwa ajili ya Yahweh na wakaosha mavazi yao. ");
INSERT INTO swhulb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Aliwaambia watu, “Kuweni tayari siku ya tatu; msiwakaribie wake zenu.” ");
INSERT INTO swhulb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Siku ya tatu, ilipo fika asubui, kulikuwa na ngurumo na radi na wingu nene kwenye mlima, na sauti kubwa ya tarumbeta. Watu wote kambini waliogopa. ");
INSERT INTO swhulb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa akaleta watu kutoka kambini kukutana na Mungu, na wakasimama miguuni mwa mlima. ");
INSERT INTO swhulb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mlima Sina ulijwa kabisa na moshi kwasababu Yahweh alishuka na moto na moshi. Moshi ulipanda juu kama moshi wa tanuru, na mlima wote ulitikisika kwa vurugu. ");
INSERT INTO swhulb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Sauti ya tarumbeta ilipo ongezeka na zaidi, Musa akazungumza, na Mungu kamjibu kwa sauti. ");
INSERT INTO swhulb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahweh akashuka chini ya Mlima Sinai, juu ya mlima, na akamuita Musa kuja juu. Kisha Musa akapanda juu. ");
INSERT INTO swhulb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahweh akamwabia Musa, “Shuka chini na uwaonye watu wasipite kuniangalia, au wengi wao wataangamia. ");
INSERT INTO swhulb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Acha pia mukuhani wanao kuja karibu yangu wakitenge - wajiandae kwa ujio - ili nisiwashambulie.” ");
INSERT INTO swhulb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa akamwabia Yahweh, “Watu hawawezi kuja juu ya mlima, kwa kuwa umetuamuru: 'Eka mipaka kuzunguka mlima na utenge kwa ajili ya Yahweh.'” ");
INSERT INTO swhulb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh akamwambia, Nenda, shuka chini ya mlima, na umelete Aruni na wewe, lakini usiache makuhani na watu kupita vizuizi na kuja kwangu, au nitawashambulia.” ");
INSERT INTO swhulb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hivyo Musa akaenda chini kwa watu na kusema nao. ");
INSERT INTO swhulb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mungu alisema maneno yote haya: ");
INSERT INTO swhulb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ndimi Bwana Mungu wenu, niliyewatoa katika ardhi Misri, nje ya nyumba ya utumwa. ");
INSERT INTO swhulb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Msiwe na miungu mingine ila mimi tu. ");
INSERT INTO swhulb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Msijitengenezee sanamu za kuchonga kufananisha na kitu chochote kilichopo juu ya mbingu, chini ya ardhi, au ndani ya maji. ");
INSERT INTO swhulb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Msipinde na kuabudu sanamu, mimi Yahweh Mungu wenu, ni Mungu mwenye wivu. Nitaadhibu uovu wa mabubu kwa kuleta adhabu juu ya kizazi, cha tatu hadi kizazi cha nne kwa wale wanao nichukia. ");
INSERT INTO swhulb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ila nitaweka agano la uaminifu kwa maelfu watakao nipenda na kushika amri zangu. ");
INSERT INTO swhulb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Usilitaje bure jina la Yahweh Mungu wako, sitkuwa na hatia kwa yeyote atakaye taja jina langu bure. ");
INSERT INTO swhulb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ikumbuke siku ya Sabato, na kunitengea. ");
INSERT INTO swhulb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","lazima ufanye kazi zako zote kwa siku sita. ");
INSERT INTO swhulb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ila siku ya saba ni Sabato kwaajili ya Yahweh Mungu wako. Siku hiyo usifanye kazi yoyote, wewe, au mwana wako, au binti yako, au mtumishi wako wakiume, au mtumishi wako mwanamke, au ng'ombe zako, au mgeni aliye ndani ya malango yako. ");
INSERT INTO swhulb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kwa siku sita Yahweh aliumba mbingu na nchi, bahari, na vitu vyote vilivyomo, na siku ya saba alipumzika. Kwa hiyo Yahweh aliibariki siku ya Sabato na kuitenga. ");
INSERT INTO swhulb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Waheshimu baba na mama yako, ili uweze kuishi miaka mingi duniani Yahweh Mungu wako ametoa. ");
INSERT INTO swhulb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Usiue. ");
INSERT INTO swhulb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Usifanye uasherati (usizini). ");
INSERT INTO swhulb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Usiibe kwa mtu yoyote. ");
INSERT INTO swhulb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Usishuhudie uongo dhidi ya jirani yako. ");
INSERT INTO swhulb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Usitaman nyumba ya jirani yako; usitamani mke wa jirani yako, wala mtumishi wake wakiume, mtumishi wake mwanamke, ng'ombe wake, punda wake, au chochote cha jirani yako. ");
INSERT INTO swhulb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Watu wote waliona radi na umeme, na kusikia sauti ya mbiu, na mlima ukitoa moshi. Watu walipoona hivo, walitetemeka na kusimama mbali. ");
INSERT INTO swhulb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wakamwambia Musa, ongea na sisi, na tutakusikiliza; lakini usiruhusu Mungu kuongea nasi, ama tutakufa. ");
INSERT INTO swhulb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa akawaambia watu, “msiogope, Mungu alikuja kuwajaribu ili heshima yake iwe ndani yenu, kwa hiyo msitende dhambi.” ");
INSERT INTO swhulb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","hivyo watu walisimama mbali, na Musa alikaribia giza nene Mungu alipokuwa. ");
INSERT INTO swhulb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahweh alimwambia Musa, “Ni lazima uwaambie hili Waisraeli: 'Wewe mwenyewe umeona niliongea na wewe kutoka mbinguni. ");
INSERT INTO swhulb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Misjitengenezee miungu mingine pamoja nami, miungu ya fedha au miungu ya dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tengenezeni madhabahu ya udongo kwa ajili yangu, na lazima mtoe sadaka ya kuteketeza, sadaka ya ushirika, kondoo, na ng'ombe. kila sehemu ntakapotaka jina langu liheshimiwe, nitakuja kwenu na kuwabariki. ");
INSERT INTO swhulb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kama mtatengeneza madhabahu ya mawe, msijenge na mawe yaiyokatika, na kama mtatumia vyombo vyenu juu yake, mtaweka unajisi. ");
INSERT INTO swhulb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","msije juu ya madhabahu yangu kwa hatua zenu; hii ni ili msioneshe sehemu zenu za siri.” ");
INSERT INTO swhulb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Sasa hizi ni amri utakazoweka kabla yao: ");
INSERT INTO swhulb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","'kama mtanunua mtumishi wa kiebrania, atatumikia kwa miaka sita, na mwaka wa saba ataachiwa huru bila kilipwa chochote. ");
INSERT INTO swhulb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kama alikuja mwenyewe, ataenda huru kwa ridhaa yake; ");
INSERT INTO swhulb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","kama bwana wake atampa mke na kumzalia mwana na binti, mke pamoja na watoto wake watabaki mali ya bwana wake, na ataenda zake huru. ");
INSERT INTO swhulb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Lakini kama mtumishi atasema waziwazi, “Nampenda bwana wangu, mke wangu, na watoto; sitaenda nje,” ");
INSERT INTO swhulb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","“kisha bwana wake atapaswa kumleta kwa Mungu. Bwana wake atapaswa kumleta katika mlango au katika muhimili wa mlango, na bwana wake atatoboa sikio lake na sindano. Kisha mtumishi wake atamtumikia kwa maisha yake yote. ");
INSERT INTO swhulb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kama mwanaume ata muuza binti wake kama mtumishi wa kike, ata weza kwenda huru kama watumishi wa kiume wanavyo enda. ");
INSERT INTO swhulb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kama hamridhishi bwana wake, aliye mtenga kwa ajili yake, kisha lazima amnunue tena. Hana ruhusa ya kumuuza kwa watu wengine wa kigeni. Hana ruhusa hiyo, sababu amemtendea kwa hila. ");
INSERT INTO swhulb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ikiwa bwana wake atamposa awe mke wa mwanae, atamtendea kama desturi zipasavyo sawa na binti zake. ");
INSERT INTO swhulb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ikiwa atajitwalia mke mwingine, asimpunguzie huyo chakula chake, nguo na haki zake za unyumba. ");
INSERT INTO swhulb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Lakini asipofanyiwa mambo haya matatu, basi anaweza kwenda bure pasipo kutolewa mali. ");
INSERT INTO swhulb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Mtu awaye yote ampigaye mtu hata akafa, inampasa mtu huyo auawe pia. ");
INSERT INTO swhulb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Lakini kama hakumvizia, ila kwa bahati mbaya, basi nitamfanyia mahali pa kukimbilia. ");
INSERT INTO swhulb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lakini mtu akimwendea mwenzake kwa kujikinai, kusudi apate kumwua kwa hila; huyo utamwondoa hata kama ni madhabahuni pangu, ili auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Yeyote atakaye mpiga baba au mama yake lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Yeyote atakaye mteka mtu na kumuuza, au mtu amekutwa kama mali yake, huyo mtekaji lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Yeyote atakaye mlaani baba au mama yake lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kama wanaume watapigana na mmoja akimpiga mwengine kwa jiwe au ngumi, na huyo mtu asife, lakini alazwe kitandani; ");
INSERT INTO swhulb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kisha akapona na anaweza kutembea kwa gongo lake, yeye aliye mpiga lazima alipe muda aliye mpotezea; na lazima alipe matibabu yake yote. Lakini huyo mtu hana hatia ya mauaji. ");
INSERT INTO swhulb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kama mwanaume akimpiga mtumishi wake wa kiume au wa kike kwa gongo, na kama mtumishi huyo akifa kwa madhara ya pigo, kisha huyo mtu lazima ahadhibiwe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Walakini, mtumishi huyo akiishi siku moja au mbili, bwana aruhusiwi kuadhibiwa, kwa kuwa atateseka kupoteza mtumishi huyo. ");
INSERT INTO swhulb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kama wanaume wakipigana pamoja na wakamuumiza wanamke mwenye mimba na kuiharibu, lakini hakuna majeraha mengine kwake, kisha huyo mwanaume mwenye hatia lazima alipe kama mme wa mwanamke anavyo taka kwake, na kulipa kama hakimu anavyo kusudia. ");
INSERT INTO swhulb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Lakini kama kuna majeraha makubwa, lazima utoe uhai kwa uhai, jicho kwa jicho, ");
INSERT INTO swhulb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","jino kwa jino, mkono kwa mkono, mguu kwa mguu, ");
INSERT INTO swhulb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kuchoma kwa kuchoma, jeraha kwa jeraha, au mkwaruzo kwa mkwaruzo. ");
INSERT INTO swhulb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kama mwanaume akipiga jicho la mtumishi wake kiume au mtumishi wake wa kike na kuliharibu, kisha lazima amuache mtumishi aende pasipo fidia ya jicho. ");
INSERT INTO swhulb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kama akitoa jino la mtumishi wake wa kiume au mtumishi wake wa kike, lazima amuache mtumishi kwenda huru kama fidia ya jino. ");
INSERT INTO swhulb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kama ng'ombe akimpiga mwanaume au mwanamke akafa, ng'ombe lazima apigwe mawe, na nyama yake hairuhusiwi kuliwa; lakini mmiliki wa ng'ombe lazima awe huru kwa hatia. ");
INSERT INTO swhulb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lakini kama ng'ombe alikuwa na tabia ya kupiga hapo awali, na mmiliki wake alionywa lakini hakumzuia, na ng'ombe ameua mwanaume au mwanamke, huyo ng'ombe lazima apigwe mawe, na mmiliki wake lazima auawe pia. ");
INSERT INTO swhulb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kama malipo ya uhai yanaitajika, lazima alipe chochote anachotakiwa kulipa. ");
INSERT INTO swhulb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kama ng'ombe amempiga mwana wa mwanaume au binti wake, mmiliki wa ng'ombe anapaswa kufanya kama masharti yanavyo mlazimu. ");
INSERT INTO swhulb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kama ng'ombe akimpiga mtumishi wa kiume au wakike, mmiliki wa ngombe lazima alipe shekeli thelathini za fedha, na ng'ombe lazima apigwe mawe. ");
INSERT INTO swhulb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kama mwanaume akifungua shimo, au kama mwanume akichimba shimo na asifunike, na ng'ombe au punda akaanguka ndani, ");
INSERT INTO swhulb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mmiliki wa shimo lazima alipe madhara. Lazima atoe hela kwa mmiliki wa mnyama aliye kufa, na mnyama aliye kufa atakuwa wake. ");
INSERT INTO swhulb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kama ng'ombe wa mwanaume akimuumiza ng'ombe wa mwanume mwengine hadi kufa, kisha lazima wamuuze ng'ombe aliye hai na kugawana gharama, na pia lazima wagawane ng'ombe aliye kufa. ");
INSERT INTO swhulb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Lakini kama ilijulikana kama ng'ombe alikuwa na tabia ya kupiga hapo awali, na mmiliki wake hakumfunga ndani, hakika lazima alipe ng'ombe kwa ng'ombe, na mnyama aliye kufa atakuwa wake. ");
INSERT INTO swhulb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kama mwanaume akiiba ng'ombe aua kondoo na kumuua au kumuuza, kisha lazima alipe ng'ombe watano au ng'ombe mmoja, na kondoo wanne kwa mmoja. ");
INSERT INTO swhulb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kama mwizi akikutwa anavunja ndani, na kama akipigwa na kufa, hakutakuwa na hatia ya mauaji hayatakuwa juu ya mtu yeyote. ");
INSERT INTO swhulb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Lakini kama jua limechomoza kabla ya yeye kuvunja ndani, hatia ya mauaji itakuwa juu ya aliyemuua. Mwizi lazima afanya alipe alichoiba. Kama hana chochote, kisha lazima auzwe kwa uwizi wake. ");
INSERT INTO swhulb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kama mnyama amekutwa hai eneo lake, kama ni ng'ombe, punda, au kondoo, lazima alipe mara mbili. ");
INSERT INTO swhulb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kama mwanaume akiwapeleka malishoni mifugo yake au shamba la mizabibu na akawaachia wanyama wake, na kawa wanakula shambani mwa mwanaume mwengine, lazima afanye malipo bora kutoka shambani mwake na shamba lake la mizabibu. ");
INSERT INTO swhulb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kama moto ukitokea na kusambaa kwenye miba hadi mbegu, au mimea, au shamba kuteketezwa, yeye aliye anzisha moto lazima afanye malipo. ");
INSERT INTO swhulb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kama mwanaume akitoa pesa au mali kwa jirani yake amtunzie, na kama itaibiwa nyumbani mwa huyo mwanaume, kama mwizi akipatikana, huyo mwizi lazima alipe mara mbili. ");
INSERT INTO swhulb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lakini kama mwizi asipo patikana, kisha mmiliki wa nyumba ata kuja mbele za waamuzi kuona kama ameeka mkono wake kwenye mali za jirani yake. ");
INSERT INTO swhulb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kwa kila lumbano kuhusu jambo, kama ni ng'ombe, punda, kondoo, nguo, au chochote kilichopotea mtu anacho sema, “Hichi ni changu,” malalamiko ya pande zote lazima zije kwa waamuzi. Mwanaume ambaye waamuzi wanamkuta na hatia ata lipa mara mbili kwa jirani yake. ");
INSERT INTO swhulb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Kama mwanaume akimpa jirani yake punda, ng'ombe, kondoo, au mnyama yeyote kumuhifadhia, na kama akifa au kuumia au akibebwa pasipo mtu kumuona, ");
INSERT INTO swhulb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","kiapo kwa Yahweh lazima wafanye wote wawili, kama ndio au hapana mtu ameeka mkono wake kwenye mali ya jirani yake. Mmiliki lazima akubali hili, na mwengine hatafanya malipo. ");
INSERT INTO swhulb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lakini kama iliibwa kwake, mwengine lazima afanye malipo kwa mmiliki kwa ajili yake. ");
INSERT INTO swhulb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kama mnyama alikatwa vipande, acha mwanaume mwengine alete huyo mnyama kama ushahidi. Hatalipa kwa ajili ya vile vipande. ");
INSERT INTO swhulb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kama mwanaume akiazima mnyama kutoka kwa jirani yake na mnyama akajeruhia au akafa pasipo mmiliki kuwa naye, mwanaume mwengine lazima afanya malipo. ");
INSERT INTO swhulb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lakini kama mmiliki alikuwa nae, mwanaume mwengine haitaji kulipa; kama mnyama aliazimwa, atalipwa kwa gharama ya kuazima. ");
INSERT INTO swhulb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kama mwanaume akimtongoza bikra ambaye hana mchumba, na kama akilala naye, lazima amfanye kuwa mke wake kwa kulipa gharama za bibi arusi zinazo stahili. ");
INSERT INTO swhulb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kama baba yake akikataa kabisa kumpatia, lazima alipe hela inayo lingana na gharama za bibi arusi bikra. ");
INSERT INTO swhulb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hautamwacha mchawi kuishi. ");
INSERT INTO swhulb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Yeyote atakaye lala na mnyama lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Yeyote atakaye toa dhabihu kwa mungu mwengine isipo kuwa Yahweh lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Hauta mkosea mgeni au kumnyanyasa, kwa kuwa ninyi mlikuwa wageni katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Hauruhusiwi kumtendea vibaya mjane au mtoto asiye kuwa na baba. ");
INSERT INTO swhulb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ukiwadhuru ata kidogo, na kama wakiniita mimi, hakika nitasikia sauti yao. ");
INSERT INTO swhulb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Hasira yangu itawaka, na nitakuua kwa upanga; wake zenu watakuwa wajane, na watoto wenu pasipo baba. ");
INSERT INTO swhulb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ukiazima hela kwa watu wangu walio maskini, haupaswi kuwa kama anaye kopesha hela kwake au kutoza faida. ");
INSERT INTO swhulb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ukichukuwa vazi la jirani yako kwa deni, lazima umrudishie kabla jua kuzama, ");
INSERT INTO swhulb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kwa kuwa hilo ndilo funiko lake, ni vazi la mwili wake. Nini tena ambacho anaweza kulalia? Atakapo niita mimi, nitasikia, kwa kuwa mimi ni mwenye huruma. ");
INSERT INTO swhulb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Usinikufuru mimi, Mungu, wala kumtukana mtawala wa watu wako. ");
INSERT INTO swhulb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Husizuie sadaka kutoka kwenye mavuno yako au kwenye hifadhi ya mvinyo wako. Lazima unipe mzaliwa wa kwanza wa wana wako. ");
INSERT INTO swhulb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Lazima ufanye hivyo hivyo kwa ng'ombe na kondoo wako. Kwa siku saba lazima wabaki na mama zao, lakini siku ya nane lazima unipe mimi. ");
INSERT INTO swhulb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Mtakuwa watu walio tengwa kwa ajili yangu. Hivyo hamtakula nyama iliyo uliwa na wanyama porini. Badala yake, uwatupie mbwa. ");
INSERT INTO swhulb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Haupaswi kutoa taarifa ya uongo kuhusu yeyote. usijiunge na mwanaume muovu kuwa shahidi wa uongo. ");
INSERT INTO swhulb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Haupaswi kufuata umati kufanya uovu, wala kutoa ushahidi ukiwa na umati ili kupotosha haki. ");
INSERT INTO swhulb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Haupaswi kumpendelea mwanaume maskini kwenye kesi yake. ");
INSERT INTO swhulb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ukikutana na ng'ombe wa adui wako au punda wake amepotea, lazima umrudishie. ");
INSERT INTO swhulb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ukiona punda wa yule anaye kuchukia ameanguka chini na mzigo wake, hauta muacha huyo mtu. Lazima umsaidie na punda wake ");
INSERT INTO swhulb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Haupaswi kupotosha haki kama yapaswa kwenda kwa watu maskini katika kesi ya mwanaume maskini. ");
INSERT INTO swhulb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Usijiunge na wengine kufanya shutuma za uongo, na usiue asiye na hatia wala mwenye haki, kwa kuwa sitamuacha muovu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Husiwai chukuwa rushwa, kwa kuwa rushwa inawapofusha wanaoona, na kupotosha maneno ya wakweli. ");
INSERT INTO swhulb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Haupaswi kumnyanyasa mgeni, kwa kuwa wewe ulikuwa mgeni katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Kwa miaka sita utapanda mbegu kwenye nchi yako na kukusanya mazao yake. ");
INSERT INTO swhulb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Lakini katika mwezi wa saba utaacha hakujalimwa, ili kwamba maskini miongoni mwenu wale. Wanacho acha, wanyama wa porini watakula. Utafanya hivyo na mashamba yenu ya mizabibu na ya mizaituni. ");
INSERT INTO swhulb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Wakati wa siku sita utafanya kazi, lakini siku ta saba utapumzika. Fanya hivi ili ng'ombe na punda wako wapumzike, na ili wana wa watumwa wako wa kike na wageni wapumzike na kupata hauweni. ");
INSERT INTO swhulb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Kuwa makini kwa kila kitu nilicho kwambia. Husitaje majina ya miungu mingine, wala kuruhusu majina yao kusikika kutoka mdomoni mwako. ");
INSERT INTO swhulb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Lazima usafiri kusherehekea mara tatu kwa ajili yangu kila mwaka. ");
INSERT INTO swhulb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Lazima uadhimishe sherehe ya Mkate usiotiwa Chachu. Kama nilivyo kuamuru, utakula mkate usiotiwa chachu kwa siku saba. Wakati huo, utajitokeza kwangu mwezi wa Abibu, uliowekwa kwa ajili ya kusudi hili. Ni kwa mwezi huu uliyo toka Misri. Lakini usijitokeze kwangu mikono mitupu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Lazima uadhimishe Sherehe ya Mavuno, matunda ya kwanza ya kazi yako ulipo panda mbegu shambani. Pia lazima uadhimishe Sherehe ya Ukusanyaji wa mwisho wa mwaka, unapo kusanya mazao yako kutoka shambani. ");
INSERT INTO swhulb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Wanaume wote wako lazima wajitokeze kwa Bwana Yahweh mara tatu kila mwaka. ");
INSERT INTO swhulb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Haupaswi kutoa damu iliyo tolewa dhabihu kwangu na mkate uliyotiwa hamira. Mafuta kutoka kwa dhabihu za sherehe zangu hayapaswi kubaki usiku wote mpaka asubui. ");
INSERT INTO swhulb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Lazima ulete matunda ya kwanza bora kutoka shambani mwako ndani ya nyumba yangu, nyumba ya Yahweh Mungu wako. Haupaswi kumchemsha mbuzi mtoto akiwa bado ananyonya. ");
INSERT INTO swhulb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ninaenda kumleta malaika mbele yako kukuongoza njiani, na kukuleta sehemu niliyo iandaa. ");
INSERT INTO swhulb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kuwa makini naye na kumtii. ");
INSERT INTO swhulb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Husimkasirishe, kwa kuwa hatasamehe makosa yako. Jina langu liko kwake. Kama hakika ukimtii sauti yake na kufanya kila ninacho kwambia, kisha nitakuwa adui kwa adui zako na mpinzani kwa wapinzani wako. ");
INSERT INTO swhulb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaika mwangu ataenda mbele zako na kukuleta kwa Waamori, Wahiti, Waperizi, Wakanani, Wahivi, na Wayebusi. Nitawaharibu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Haupaswi kuinamia miungu yao, kuabudu, au kufanya wanavyo fanya. Badala yake, lazima uwapindue kabisa na kuvunja nguzo zao za mawe vipande vipande. ");
INSERT INTO swhulb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Lazima umuabudu Yahweh Mungu wako, na atabariki mkate wako na maji. Nitaondoa magonjwa miongoni mwenu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hakuna mwanamke atakaye kuwa tasa au mimba kuharibika katika nchi yako. Nitawapa maisha marefu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Nitatuma hofu yangu kwao ambao mnaenda. Nitaua wote mnao kutana nao. Nitafanya maadui zenu wawaogope kwa kugeuza migongo yao kwenu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nitatuma mavu kwenu watakao fukuza Wahivi, Wakanani, na Wahiti mbele zenu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Sitawaondoa kwenu kwa mwaka mmoja, au nchi itakuwa imetelekezwa, na wanyama wa porini watakuwa wengi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Badala yake, nitawafukuza kidogo kidogo kutoka kwenu mpaka utakapo kuwa umestawi na kurithi nchi. ");
INSERT INTO swhulb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nitatengeneza mipaka yako kutoka Bahari ya Shamu hadi Bahari ya Wafilisti, na kutoka nyikani hadi Mto Frati. Nitakupa ushindi juu ya wakazi wote wa nchi. Utawaondoa kutoka kwako mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Haupaswi kufanya agano na wao au na miungu yao. ");
INSERT INTO swhulb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Hawapaswi kuishi nchini mwako, au watakufanya ufanya dhambi dhidi yangu. Ukiabudu miungu yao, hakika watakuwa mtego kwako.'” ");
INSERT INTO swhulb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kisha Yahweh akamwabia Musa, “Njoo juu kwangu -wewe, Aruni, Nadabu, Abihu, na wazee sabini wa Israeli, na kuniabudu kwa mbali. ");
INSERT INTO swhulb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa peke yake anaweza kuja karibu yangu. Wengine hawapaswi kuja karibu, wala watu kuja juu na yeye.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa akaenda juu na kuwaambia watu maneno yote ya Yahweh na amri zake. Watu wote wakajibu kwa sauti moja na kusema, “Tutafanya maneno yote Yahweh aliyo tuamuru.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kisha Musa akaandika chini maneno yote ya Yahweh. Asubui mapema, Musa akajenga madhabahu chini ya mguu wa mlima na kupanga nguzo kumi na mbili za mawe, ili mawe yawakilishe makabila kumi na mbili ya Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Aliwatuma vijana Wakiisraeli kutoa sadaka ya kuteketeza na kutoa dhabihu za ng'ombe za sadaka ya ushirika kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa allichukuwa nusu ya damu na kuweka kwenye mabeseni; alinyunyuzia nusu ingine kwenye madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Alichukuwa kitabu cha agano na kuwasomea kwa nguvu watu. Walisema, “Tutafanya yote Yahweh aliyo sema. Tutakuwa watiifu.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kisha Musa akachukuwa damu na kunyunyiza kwa watu. Alisema, “Hii ni damu ya agano Yahweh alilo lifanya nanyi kwa kuwapa hii ahadi kwa maneno yote haya.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kisha Musa, Aruni, Nadabu, Abihu, na wazee sabini wa Israeli wakaenda juu ya mlima. ");
INSERT INTO swhulb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Walimuona Mungu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Chini ya miguu yake kulikuwa na sakafu iliyo jengwa kwa jiwe la yakuti samawi, safi kama mbingu yenyewe. Mungu hakugusa na mkono kwa hasira viongozi Waisraeli. Walimuona Mungu, na wakanywa na kula. ");
INSERT INTO swhulb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahweh akamwambia Musa, “Njoo juu kwangu mlimani na ubaki pale. Nitakupa saani za mawe na sheria na amri nilizo ziandika, ili uwafundishe.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Hivyo Musa akaenda na msaidizi wake Yoshua na kwenda juu mlima wa Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa akawaambia wazee, “Baki hapa na mtusubiri hadi tutakapo warudia. Aruni na Huri wapo nanyi. Kama kuna mtu mwenye malalamiko, acha awaende.” ");
INSERT INTO swhulb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Hivyo Musa akaenda juu ya mlima, na wingu likafunika. ");
INSERT INTO swhulb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Utukufu wa Yahweh ukabaki juu ya Mlima wa Sinai, na wingu likafunika kwa siku sita. Siku ya saba alimuita Musa kutoka ndani ya wingu. ");
INSERT INTO swhulb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Utukufu wa Yahweh ulikuwa kama moto ulao juu ya mlima kwenye macho ya Waisraeli. ");
INSERT INTO swhulb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa akaingia kwenye wingu na kwenda juu ya mlima. Alikuwa mlimani siku arobaini na usiku arobaini. ");
INSERT INTO swhulb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh akamwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Waambie Waisraeli wanitolee sadaka kila mtu nawe utapokea kutoka kwa mtu yeyote atakayetoa kwa moyo mkunjufu. Lazima upokee hizi sadaka kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Hizi ndio sadaka utakazopokea kwao; dhahabu, fedha na shaba, ");
INSERT INTO swhulb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","buluu, zambarau na nyekundu, na nguo za kitani safi, na manyoya ya mbuzi; ");
INSERT INTO swhulb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na ngozi za kondoo dume zilizotiwa rangi nyekundu na ngozi za pomboo, miti ya mjohoro, ");
INSERT INTO swhulb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta ya ile taa, na viungo vya manukato kwa yale mafuta ya kupaka na kwa ule uvumba wenye harufu nzuri; ");
INSERT INTO swhulb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mawe ya shohamu na mawe mengine ya kutiwa kwa ile naivera na kwa kile kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Waache wanifanyie patakatifu ili nipate kukaa kati yao. ");
INSERT INTO swhulb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Lazima ufanye sawa na haya yote nikuoneshayo mfano wa maskani, na vifaa vyake, ndivyo utakavyovifanya. ");
INSERT INTO swhulb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Wana paswa wafanye sanduku la mti wa mjohoro. Urefu wake na uwe dhiraa mbili na nusu; na upana wake moja na nusu, na kwenda juu kwake dhiraa moja na nusu. ");
INSERT INTO swhulb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lazima ulifunike nadni kwa dhahabu safi, na utie na ukingo wa dhahabu kulizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Nawe uta yayusha katika viduara vinne vya dhahabu, na kuviweka katika miguu yake minne; viduara viwili upande mmoja, na viduara viwili upande wake wa pili. ");
INSERT INTO swhulb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Nawe lazima ufanya miti mirefu ya mshita na kuifunika dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Nawe lazima uweka hiyo miti katika vile viduara vilivyo katika pande mbili za sanduku ili kulichukua hilo sanduku. ");
INSERT INTO swhulb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Hiyo miti itakaa katika vile viduara vya sanduku; haitaondolewa. ");
INSERT INTO swhulb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kisha weka ndani ya sanduku hizo amri nitakazokupa. ");
INSERT INTO swhulb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Nawe lazima utengeneze kifuniko cha dhahabu safi. Urefu wake utakuwa dhiraa mbili na nusu, na upana wake dhiraa moja na nusu. ");
INSERT INTO swhulb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Nawe fanya makerubi mawili ya dhahabu katika hiyo miisho miwili ya kiti cha rehema. ");
INSERT INTO swhulb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Weka kerubi moja mwisho mmoja wa kiti cha rehema, na kerubi la pili mwisho wa pili. Lazima hao makerubi wawe kitu kimoja na kiti cha rehema. ");
INSERT INTO swhulb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Na hao makerubi watainua mabawa yao juu, na kukifunika hicho kiti cha rehema kwa mabawa yao. Nyuso zao makerubi zitaelekeana na zitaelekea kiti cha rehema. ");
INSERT INTO swhulb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Lazima uweke kiti cha rehema juu ya hilo sanduku, kisha uwe hizo amri nitakazokupa ndani ya sanduku. ");
INSERT INTO swhulb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nami nitaonana nawe hapo katika sanduku. Nitazungumza nawe pale nilipo juu ya kiti cha rehema. Itakuwa katikati ya hao makerubi mawili waliyo juu ya sanduku la ushuhuda nitakapo zungumza na wewe katika mambo yote nitakayokuagiza kwa ajili ya wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Nawe fanya meza ya mti wa mshiti. Urefu wake utakuwa dhiraa mbili, na upana wake dhiraa moja, na kwenda juu kwake dhiraa moja na nusu. ");
INSERT INTO swhulb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uifunike dhahabu safi na kuifanyia ukingo wa dhahabu wa kuizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Lazima ufanyie fremu ya kuizunguka pande zote, upana wake utakuwa nyanda nne, ukingo wa dhahabu wa kuuzunguka fremu pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Uifanyie viduara vinne vya dhahabu na kuvitia vile viduara katika pembe zake nne, katika miguu yake minne ilipo kuwa. ");
INSERT INTO swhulb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Vile viduara na viwe karibu na ile fremu ili viwe mahali pa kutilia ile miti, ya kuichukulia meza. ");
INSERT INTO swhulb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Fanya ile miti ya mti wa mshita, na kuifunika dhahabu, kwamba ile meza ichukuliwe kwayo. ");
INSERT INTO swhulb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nawe fanya sahani zake, na miiko yake, na makopo yake, na vikombe vyake vya kumiminia. Vifanye vyote vya dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Nawe utaiweka mikate ya wonyesho juu ya meza mbele yangu daima. ");
INSERT INTO swhulb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Nawe fanya kinara cha taa cha dhahabu safi; hicho kinara na kifanywe cha kazi ya kufua, kitako chake, na mti wake, vikombe vyake, na matovu yake, na maua yake, vyote vitakuwa vya kitu kimoja nacho. ");
INSERT INTO swhulb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Nacho kitakuwa na matawi sita yenye kutoka ubavuni mwake - matawi matatu ya kinara upande wake mmoja, na matawi matatu ya kinara upande wake wa pili. ");
INSERT INTO swhulb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tawi la kwanza lazima liwe na vikombe vitatu vilivyotengenezwa mfano wa maua ya mlozi katika tawi moja, tovu na ua na vikombe vitatu vilivyofanywa mfano wa maua ya mlozi katika tawi la pili, tovu na ua. Vivyo hivyo hayo matawi yote sita yatokayo katika kile kinara. ");
INSERT INTO swhulb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Katika hicho kinara, lazima kuwe na vikombe vinne vilivyofanywa mfano wa maua ya mlozi, matovu yake, na maua yake. ");
INSERT INTO swhulb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Lazima kuwe na tovu chini ya matawi - mawili la kitu kimoja nacho, na tovu chini ya matawi mawili la kitu kimoja nacho, na tovu chini ya matawi mawili la kitu kimoja nacho, kwa hayo matawi sita yatokayo katika kile kinara. ");
INSERT INTO swhulb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Matovu yake na matawi yake yatakuwa ya kitu kimoja nacho, kiwe chote pia kazi moja ya kufua, ya dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Lazima nawe uzifanye hivyo vinara saba na taa zake saba, nao wataziwasha hizo taa zake, zitoe nuru mbele yake. ");
INSERT INTO swhulb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Na makoleo yake, na visahani vyake, vyote vitakuwa vya dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tumia talanta moja ya dhahabu safi, pamoja na vyombo hivi vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Nawe angalia ya kwamba uvifanye kama mfano wake, uliooneshwa mlimani. ");
INSERT INTO swhulb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Lazima ufanye hiyo maskani iwe na mapazia kumi ifanye ya nguo ya kitani nzuri ya kusokota, pamoja na nyuzi za rangi ya buluu, zambarau na nyekundu, pamoja na makerubi. Kazi ya fundi stadi. ");
INSERT INTO swhulb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Urefu wa kila pazia utakuwa dhiraa ishirini na nane, na upana wa kila pazia utakuwa dhiraa nne. Mapazia yote yatakuwa ya kipimo kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mapazia matano yataungwa pamoja, na mapazia matano mengine yataungwa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Lazima ufanye tanzi za rangi ya samawati upande wa mwisho wa pazia moja katika ule upindo wa fungu lake. Vivyo hivyo utafanya upande wa mwisho wa ile pazia iliyo, katika fungu la pili. ");
INSERT INTO swhulb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fanya matanzi hamsini katika pazia moja, na matanzi hamsini katika upande wa mwisho wa ile pazia iliyo katika kuungana kwa pili. ");
INSERT INTO swhulb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Fanya hivi ili hizo tanzi zielekeana. Kisha ufanye vifungo hamsini vya dhahabu, na kuunganisha hayo mapazia pamoja kwa vile vifungo na hiyo maskani itakuwa ni moja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Lazima ufanye mapazia ya nywele za mbuzi yawe hema juu ya maskani. Lazima ufanye mapazia kumi na moja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Urefu wa kila pazia utakuwa dhiraa thelathini, na upana wa kila pazia utakuwa dhiraa nne. Hayo mapazia kumi na moja yatakuwa ya kipimo kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Lazima utaunganisha mapazia matano mbali, na mapazia sita mbali, na lile pazia la sita utalikunja hapo upande wa mbele wa ile hema. ");
INSERT INTO swhulb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ufanye tanzi hamsini upande wa mwisho wa pazia lile lililo la mwisho katika hayo yaliyounganywa pamoja, na tanzi hamsini upande wa mwisho wa lile pazia lililo nje katika hayo ya pili yaliyounganywa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kisha ufanye vifungo hamsini vya shaba, na kuvitia vile vifungo katika zile tanzi, na kuiunganya ile hema pamoja, ili iwe hema moja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kipande kile kilichosalia, kile kiangukacho, cha yale mapazia ya hema, itaanguka huko upande wa nyuma wa maskani. ");
INSERT INTO swhulb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Lazima kuwe na dhiraa moja upande mmoja, na ile dhiraa moja upande wa pili - ya urefu wa mapazia ya hema uliosalia, zitaanguka katika ubavu wa maskani upande huu na upande huu, ili kuifunika. ");
INSERT INTO swhulb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Nawe fanya kifuniko cha ile hema, cha ngozi za kondoo dume zilizotiwa rangi nyekundu, na juu yake kifuniko cha ngozi za pomboo. ");
INSERT INTO swhulb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Nawe lazima ufanye hizo fremu za maskani za mti wa mjohoro. ");
INSERT INTO swhulb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kila fremu utakuwa na urefu wa dhiraa kumi, na upana wake kila ubao utakuwa dhiraa moja na nusu. ");
INSERT INTO swhulb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kila fremu itakuwa na ndimi mbili, zenye kuunganishwa huu na huu. Ndivyo utakavyozifanya mbao zote za maskani. ");
INSERT INTO swhulb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kisha ufanye zile mbao za maskani, mbao ishirini kwa upande wa kusini kuelekea kusini. ");
INSERT INTO swhulb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Lazima nawe ufanye vitako arubaini vya fedha chini ya zile fremu ishirini. Vitako viwili chini ya fremu moja, kupokea zile ndimi zake mbili, na vitako viwili chini ya fremu nyingine kupokea zile ndimi zake mbili. ");
INSERT INTO swhulb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kwa upande wa pili wa maskani, upande wa kaskazini, mbao ishirini ");
INSERT INTO swhulb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vitako vyake vya fedha arubaini. Lazima kuwe na vitako viwili chini ya fremu moja, na vitako viwili chini ya fremu nyingine. ");
INSERT INTO swhulb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ufanye fremu sita kwa ajili ya upande wa nyuma wa maskani kuelekea magharibi. ");
INSERT INTO swhulb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tena ufanye fremu mbili kwa ajili ya hizo pembe za maskani zilizo upande wa nyuma. ");
INSERT INTO swhulb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hizi fremu zitakuwa zimetengana upande wa chini, lakini zimeshinkana kwa juu ya duara moja. ");
INSERT INTO swhulb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Fremu zitakuwa ni nane, na vitako vyake vya fedha. Vitako kumi na sita, vitako viwili chini ya fremu moja, na vitako viwili chini ya ubao wa pili. ");
INSERT INTO swhulb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Lazima ufanye mataruma ya mti wa mshita- mataruma matano kwa ajili ya mbao za upande mmoja wa maskani, ");
INSERT INTO swhulb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na mataruma matano kwa ajili ya fremu za upande wa pili wa maskani, na mataruma matano kwa ajili ya fremu za upande wa maskani ulio nyuma kuelekea magharibi. ");
INSERT INTO swhulb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Na hilo taruma la katikati lililo katikati ya zile fremu, litapenya toka mwisho huu hata mwisho huu. ");
INSERT INTO swhulb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","lazima uzifunuke hizo fremu kwa dhahabu. Nawe lazima ufanye maduara yake ya za dhahabu, kuwa kama vishikizo, na hayo mataruma utayafunika dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Nawe utaisimamisha hiyo maskani sawasawa na mfano wake uliooneshwa mlimani. ");
INSERT INTO swhulb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Nawe fanya pazia la nyuzi za rangi ya buluu, zambarau na nyekundu, na nguo za kitani nzuri zenye kusokotwa, litafumwa na kutiwa makerubi, kazi ya fundi stadi. ");
INSERT INTO swhulb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kisha litungike katika nguzo nne za mti wa mshita zilizofunikwa dhahabu, vifungo vyake vitakuwa vya dhahabu, katika vitako vya fedha vinne. ");
INSERT INTO swhulb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Nawe tungika lile pazia chini ya vile vifungo, nawe lete lile sanduku la ushuhuda. Lile pazia litawagawanyia kati ya patakatifu, na mahali patakatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nawe lazima utaweka kiti cha rehema juu ya lile sanduku la ushuhuda ndani ya mahali pale patakatifu sana. Na ile meza utaiweka nje ya pazia. ");
INSERT INTO swhulb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Lazima uweke kinara cha taa kuikabili ile meza upande wa maskani wa kuelekea kusini. Lile meza utaiweka upande wa kaskazini. ");
INSERT INTO swhulb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Kisha utafanya kisitiri kwa mlango wa hema, cha nyuzi za rangi ya buluu, zambarau, na nyekundu, na kitani nzuri yenye kusokotwa, kazi ya mshonaji wa taraza. ");
INSERT INTO swhulb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Nawe fanya nguzo tano za mti wa mshita kwa kile kisitiri, na kuzifunika dhahabu; kulabu zake zitakuwa za dhahabu. Nawe utasubu vitako vya shaba vitano kwa ajili yake. ");
INSERT INTO swhulb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Nawe fanya madhabahu ya mti wa mshita, urefu wake utakuwa ni dhiraa tano na upana wake dhiraa tano. Hiyo madhabahu itakuwa mraba na kwenda juu kwake kutakuwa dhiraa tatu. ");
INSERT INTO swhulb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Nawe fanya pembe nne kama mfano wa pembe za ng'ombe. Hizo pembe zitakuwa za kitu kimoja na madhabahu, nawe utayafunika kwa shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Lazima vyombo vyake vya kuyaondoa majivu yake utavifanya, na majembe yake, na mabakuli yake, na uma zake, na meko yake. Vyombo vyake vyote utavifanya vya shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Nawe uifanyie hiyo madhabahu wavu wa shaba. Kisha utie pete nne za shaba katika hizo pembe nne za ule wavu. ");
INSERT INTO swhulb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Nawe lazima uweke huo wavu chini ya kizingo kiizungukacho madhabahu upande wa chini. ");
INSERT INTO swhulb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nawe fanya miti kwa ajili ya madhabahu, miti ya mshita, na kuifunika shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Na hiyo miti itatiwa katika viduara, na ile miti itakuwa katika pande mbili za madhabahu, wakati wa kuichukua. ");
INSERT INTO swhulb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Uifanye ya mbao, yenye mvungu ndani yake kama ulivyooneshwa mlimani. ");
INSERT INTO swhulb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Nawe ufanye ua wa maskani. Upande wa kusini wa kuelekea kusini kutakuwa na chandarua ya nguo ya kitani nzuri yenye kusokotwa, kwa huo ua, urefu wake upande mmoja utakuwa ni dhiraa mia moja. ");
INSERT INTO swhulb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Na nguzo zake zitakuwa nguzo ishirini, na vitako vyake ishirini, vitako vyake vitakuwa vya shaba kulabu za zile nguzo na vitanzi vyake vitakuwa vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ni vivyo hivyo upande wa kaskazini, urefu wake hiyo chandarua utakuwa ni dhiraa mia moja, na nguzo zake ishirini, na vitako vyake ishirini vitakuwa vya shaba, kulabu za zile nguzo na vitanzi vyake vitakuwa vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Na upande wa magharibi, upana wa ua kutakuwa na chandarua ya dhiraa hamsini; nguzo zake kumi, na vitako vyake kumi. ");
INSERT INTO swhulb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Na upana wa ule ua upande wa mashariki kuelekea mashariki utakuwa ni dhiraa hamsini. ");
INSERT INTO swhulb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Chandarua upande mmoja wa lango itakuwa dhiraa kumi na tano upana wake. Lazima nguzo zake zitakuwa tatu na vitako vyake vitatu. ");
INSERT INTO swhulb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Upande wa pili ni vivyo hivyo chandarua ya dhiraa kumi na tano; nguzo zake tatu, na vitako vyake vitatu. ");
INSERT INTO swhulb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Na kwa lile lango la ua patakuwa na kisitiri cha dhiraa ishirini, kitakuwa cha nguo ya rangi ya buluu, zambarau na nyekundu, na kitani nzuri yenye kusokotwa, kazi ya mshonaji taraza; nguzo zake zitakuwa nne, na vitako vyake vinne. ");
INSERT INTO swhulb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Nguzo zote za ule ua ziuzungukao pande zote zitakuwa na vitanzi vya fedha; kulabu zake za fedha, na vitako vyake vya shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Urefu wa huo ua utakuwa dhiraa mia moja, na upana wake utakuwa dhiraa hamsini kotekote, na kwenda juu kwake dhiraa tano; yawe ya nguo ya kitani nzuri, na vitako vyake vitakuwa vya shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Vyombo vyote vya maskani vitumiwavyo katika utumishi wake wote, na vigingi vyake vyote, na vigingi vyote vya ule ua, vitakuwa vya shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","awe waamuru wana wa Israeli wakuletee mafuta ya zeituni safi ya kupondwa kwa ajili ya nuru, ili kufanya ile taa kuwaka daima. ");
INSERT INTO swhulb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ndani ya ile hema ya kukutania, nje ya hilo pazia, lililo mbele ya huo ushuhuda, Haruni na wanawe wataitengeza tangu jioni hadi asubuhi mbele ya BWANA; itakuwa ni amri ya milele katika vizazi vyao vyote kwa ajili ya wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Umuite Aruni kaka yako na wana wake - Nadabu, na Abihu, na Eleazari, na Ithamari - miongoni mwa wana wa Israeli, ili anitumikie katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nawe utamfanyia Aruni ndugu yako mavazi matakatifu, kwa utukufu na kwa uzuri. ");
INSERT INTO swhulb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Nawe utawaambia watu wote wenye moyo wa hekima, niliowajaza na roho ya hekima wamfanyie Aruni mavazi ili kumtakasa anitumikie katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Na mavazi watakayoyafanya ni kifuko cha kifuani, na naivera, na joho, na kanzu ya kazi ya urembo, na kilemba, na mshipi; nao watawafanyia Aruni nduguye, na wanawe, mavazi matakatifu ili anitumikie katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Nao wataitwaa dhahabu, na nguo ya rangi ya samawi, na ya rangi ya zambarau, na ya rangi nyekundu. ");
INSERT INTO swhulb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Nao waifanye naivera kwa nyuzi za dhahabu, na za samawi, na za zambarau, na nyekundu, na kitani nzuri yenye kusokotwa kwa kazi ya mstadi. ");
INSERT INTO swhulb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Lazima itakuwa na vipande viwili vya mabegani, vilivyoungana kwenye ncha zake mbili; ili ipate kuunganywa. ");
INSERT INTO swhulb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Na mshipi wa kazi ya ustadi ulio juu yake, ili kuifunga mahali pake; utakuwa wa kazi kama ile ya naivera, ya vitu vile vile ya nyuzi za dhahabu, na za rangi ya samawi, na ya zambarau, na nyekundu, na kitani nzuri yenye kusokotwa. ");
INSERT INTO swhulb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Nawe utatwaa vito viwili vya shohamu, ya rangi ya chani-kiwiti, nawe utachora juu yake majina ya wana wa Israeli; ");
INSERT INTO swhulb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Majina yao sita katika kito kimoja, na majina sita yaliyosalia katika kile kito cha pili, kwa utaratibu wa kuzaliwa kwao. ");
INSERT INTO swhulb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kwa kazi mtu mwenye kuchora mawe kama vile muhuri ichorwavyo, utavichora hivi vito viwili, sawasawa na majina ya wana wa Israeli, nawe utavitia katika vijalizo vya dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Nawe utavitia vile vito viwili juu ya vipande vya mabegani vya hiyo naivera, viwe vito vya ukumbusho kwa ajili ya wana wa Israeli. Naye Aruni atayachukua majina yao mbele za Yahweh juu ya mabega yake mawili ili kuwa ukumbusho. ");
INSERT INTO swhulb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Nawe fanya vijalizo viwili vya dhahabu ");
INSERT INTO swhulb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu miwili ya dhahabu safi; utaifanya iwe mfano wa kamba, ya kazi ya kusokotwa; nawe uitie ile mikufu ya kazi ya kusokotwa katika vile vijalizo. ");
INSERT INTO swhulb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Nawe lazima utafanya kifuko cha kifuani cha hukumu, kazi ya fundi stadi; utakifanya kwa kuiandama ile kazi ya hiyo naivera. Fanya nyuzi za dhahabu, na za rangi ya samawi, na za rangi ya zambarau, na nyekundu, na kitani safi yenye kusokotwa, ndivyo utakavyokifanya. ");
INSERT INTO swhulb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kitakuwa mraba, tena cha kukunjwa; urefu wake utakuwa shibiri moja, na upana wake shibiri moja. ");
INSERT INTO swhulb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Nawe ukijaze viweko vya vito, safu nne za vito; safu moja itakuwa ni akiki, na yakuti ya rangi ya manjano, na baharamani, hivi vitakuwa safu ya kwanza. ");
INSERT INTO swhulb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Na safu ya pili itakuwa zumaridi, na yakuti samawi, na almasi. ");
INSERT INTO swhulb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Na safu ya tatu itakuwa hiakintho, na akiki nyekundu, na amethisto. ");
INSERT INTO swhulb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Na safu ya nne itakuwa ni zabarajadi, na shohamu, na yaspi. Vito hivyo vitakazwa ndani ya dhahabu kwa kujaa mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Na vile vito vitakuwa sawasawa na majina ya wana wa Israeli, kumi na viwili, sawasawa na majina yao. Mfano wa kuchora kwa muhuri kila kimoja sawasawa na jina lake, vitakuwa vya hizo kabila kumi na mbili. ");
INSERT INTO swhulb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Nawe lazima utie katika kile kifuko cha kifuani mikufu mfano wa kamba, ya kazi ya kusokotwa, ya dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nawe utie maduara mawili ya dhahabu katika kile kifuko cha kifuani, na kuzitia hizo pete mbili katika ncha mbili za kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nawe utie hiyo mikufu miwili ya dhahabu iliyosokotwa katika zile pete mbili zilizo katika ncha za kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Na ncha zile nyingine za hiyo mikufu miwili ya kusokotwa utazitia katika vile vijalizo viwili, na kuvitia katika vile vipande vya mabegani vya naivera upande wa mbele. ");
INSERT INTO swhulb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Nawe utafanya viduara vili vya dhahabu, uzitie katika hizo ncha mbili za kifuko cha kifuani, katika ukingo wake. ");
INSERT INTO swhulb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nawe lazima ufanye viduara vili vya dhahabu, na kuzitia katika vile vipande viwili vya mabegani vya ile naivera chini yake, upande wa mbele, karibu na kifungo chake, juu ya huo mshipi wa naivera uliosukwa kwa ustadi. ");
INSERT INTO swhulb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Nao watakikaza kile kileso kwa vile viduara vyake kwenye viduara za naivera kwa ukanda wa rangi ya samawi, ili kwamba kikae pale juu ya ule mshipi wa naivera uliosukwa kwa ustadi, ili kwamba kifuko cha kifuani kisiachane na naivera. ");
INSERT INTO swhulb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Na Aruni atayachukua majina ya wana wa Israeli katika kile kifuko cha kifuani cha hukumu juu ya moyo wake kwa kufanya maamuzi, hapo atakapoingia ndani ya mahali patakatifu, kuwa ukumbusho mbele yaYahweh daima. ");
INSERT INTO swhulb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Nawe utie hizo Urimu na Thumimu katika kile kifuko cha kifuani cha hukumu; nazo zitakuwa juu ya moyo wa Aruni, hapo atakapoingia ndani mbele ya Yahweh na Aruni atachukua hukumu ya hao wana wa Israeli juu ya moyo wake mbele ya Yahweh daima. ");
INSERT INTO swhulb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Nawe fanya hiyo joho ya naivera ya rangi ya samawi yote. ");
INSERT INTO swhulb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nayo itakuwa na tundu katikati yake kwa kupitisha kichwa; itakuwa na utepe wa kazi ya kusokotwa kuzunguka hilo tundu lake, mfano wa tundu lililo katika kanzu ya chuma, ili lisipasuke. ");
INSERT INTO swhulb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nawe katika pindo zake utatia makomamanga ya rangi ya samawi, na ya rangi ya zambarau, na ya rangi nyekundu, kuzunguka pindo zake kotekote; na njuga za dhahabu kati ya hayo makomamanga pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kengele ya dhahabu na komamanga, kengele ya dhahabu na komamanga, katika pindo za joho kuizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Nayo itakuwa juu ya Aruni akitumika; na sauti ya hizo kengele itasikilikana hapo aingiapo ndani ya mahali patakatifu mbele ya Yahweh na hapo atokapo nje, ili kwamba asife. ");
INSERT INTO swhulb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Nawe fanya bamba la dhahabu safi na kuchora juu yake, mfano wa machoro ya muhuri, “Mtakatifu kwa Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Nawe ulitie hilo bamba katika ukanda wa rangi ya samawi, nalo litakuwa katika kile kilemba; litakuwa upande wa mbele wa kile kilemba. ");
INSERT INTO swhulb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Nalo litakuwa katika kipaji cha uso cha Aruni, na Aruni atauchukua uovu wa vile vitu vitakatifu, watakavyovitakasa hao wana wa Israeli katika vipawa vyao vyote vitakatifu, nalo litakuwa katika kipaji chake cha uso sikuzote, ili kwamba vipate kukubaliwa mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Na hiyo kanzu utaifuma ya kitani nzuri ya kazi ya urembo, ufanye na kilemba cha nguo ya kitani nzuri, nawe utafanya mshipi wa kazi ya mwenye kutia taraza. ");
INSERT INTO swhulb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Kisha utafany kanzu kwa ajili ya wana wa Aruni, nawe wafanyie mishipi, wafanyie na kofia kwa utukufu na uzuri. ");
INSERT INTO swhulb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nawe mvike huyo nduguye Aruni na wanawe nao mavazi hayo; nawe watie mafuta, na kuwaweka kwa kazi takatifu, na kuwatakasa, ili wapate kunitumikia mimi katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Nawe wafanyie suruali za nguo ya kitani, ili kufunika tupu ya miili yao; suruali hizo zitafika tangu kiunoni hata mapajani. ");
INSERT INTO swhulb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aruni na wanawe watazivaa, hapo watakapoingia katika hema ya kukutania, au hapo watakapoikaribia madhabahu ili watumike katika mahali patakatifu; wasije wakachukua uovu, wakafa; hii itakuwa ni amri ya milele kwake yeye, na kwa wazao wake. ");
INSERT INTO swhulb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Sasa Hivi ndivyo wapaswa kufanya kuwatenga ili wanitumikie kama makuhani. Chukuwa mtoto wa ng'ombe dume na kondoo bila lawama, ");
INSERT INTO swhulb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","mkate bila hamira, na keki bila hamira iliyo changanywa na mafuta. Pia chukuwa maandazi bila hamira yalio pakwa mafuta. Fanya maandazi kwa unga mzuri wa ngano. ");
INSERT INTO swhulb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Lazima uweke kwenye ndoo moja, leta kwenye ndoo, na kuleta pamoja na ng'ombe dume na wana kondoo wawili. ");
INSERT INTO swhulb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Lazima nawe umlete Aruni na wana wake wawili katika lango la kuingilia hema la kukutania. Lazima uwasafishe Aruni na wana wake kwenye maji. ");
INSERT INTO swhulb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kisha twaa hayo mavazi na kumvika Haruni; itie kanzu, na joho ya naivera, na naivera, na kifuko cha kifuani, na kumkaza kwa huo mshipi wa naivera uliosukwa kwa ustadi. ");
INSERT INTO swhulb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Nawe mvike kile kilemba kichwani, na ile taji takatifu utaitia katika kile kilemba. ");
INSERT INTO swhulb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ndipo utakapotwaa hayo mafuta ya kutiwa, na kummiminia kichwani mwake, na kumtia mafuta. ");
INSERT INTO swhulb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kisha walete hao wanawe na kuwavika kanzu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Nawe uwakaze mishipi, Aruni na wanawe, na kuwavika kofia. Nao watakuwa na huo ukuhani kwa amri ya milele. Nawe utawaweka Haruni na wanawe kwa kazi takatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kisha utamleta huyo ng’ombe mbele ya hema ya kukutania; na Haruni na wanawe wataweka mikono yao juu ya kichwa cha huyo ng’ombe. ");
INSERT INTO swhulb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kisha utamchinja huyo ng’ombe mbele ya Yahweh pa hema ya kukutania. BWANA, ");
INSERT INTO swhulb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kisha twaa baadhi ya damu ya ng’ombe, uitie katika pembe za madhabahu kwa kidole chako; na kuimimina damu yote chini ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kisha chukuwa mafuta yote yafunikayo matumbo, na kitambi kilicho katika ini, na figo mbili, na mafuta yaliyo juu yake, uyateketeze yote juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Lakini nyama yake huyo ng’ombe, na ngozi yake, na mavi yake, utayachoma kwa moto nje ya marago; ni sadaka kwa ajili ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Pia mtwae kondoo mume mmoja; na Aruni na wanawe wataweka mikono yao juu ya kichwa chake huyo kondoo mume. ");
INSERT INTO swhulb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kisha utamchinja huyo kondoo mume, na kuitwaa damu yake, na kuinyunyiza katika madhabahu kuizunguka kando-kando. ");
INSERT INTO swhulb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kisha utamkata-kata kondoo vipande vyake, na kuyaosha matumbo yake na miguu yake, na kuiweka pamoja na vipande vyake na kichwa chake, ");
INSERT INTO swhulb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","nawe mteketeze kondoo mzima juu ya madhabahu. Ni sadaka ya kuteketezwa kwa ajili yaYahweh; ni harufu nzuri, sadaka iliyosongezwa kwa Yahweh kwa njia ya moto. ");
INSERT INTO swhulb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kisha mtwae huyo kondoo mwingine; na Aruni na wanawe wataweka mikono yao juu ya kichwa chake huyo kondoo. ");
INSERT INTO swhulb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kisha utamchinja kondoo, na kuitwaa damu yake, na kuitia katika ncha ya sikio la Aruni la upande wa kuume, na katika ncha za masikio ya kuume ya wanawe, na katika vyanda vya gumba vya mikono yao ya kuume, na katika vidole vikuu vya miguu yao ya kuume, na kuinyunyiza hiyo damu katika madhabahu kuizunguka kando-kando. ");
INSERT INTO swhulb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kisha twaa katika hiyo damu iliyo juu ya madhabahu, na katika hayo mafuta ya kutiwa, na kumnyunyizia Aruni, juu ya mavazi yake, na wanawe, na mavazi yao pia, pamoja naye; naye atatakaswa, na mavazi yake, na wanawe, na mavazi ya wanawe, pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tena yatwae mafuta ya huyo kondoo mume, na mkia wake wa mafuta, na mafuta yafunikayo matumbo, na kitambi kilicho katika ini, na figo mbili, na mafuta yaliyo katika hizo figo, na paja la kuume; kwani ni kondoo ambaye ni wa kuwekwa kwa kazi takatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Utwae na mkate mmoja wa unga, na mkate mmoja ulioandaliwa kwa mafuta, na kaki moja katika kile kikapu cha mikate isiyotiwa chachu, kilichowekwa mbele ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nawe utavitia hivi vyote katika mikono ya Aruni, na katika mikono ya wanawe; nawe utavitikisa-tikisa viwe sadaka ya kutikiswa mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kisha uvitwae vile vitu mikononi mwao, na kuviteketeza juu ya madhabahu, juu ya ile sadaka ya kuteketezwa, viwe harufu nzuri mbele yangu; ni sadaka iliyotengenezwa kwangu kwa njia ya moto. ");
INSERT INTO swhulb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kisha twaa kidari cha huyo kondoo wa kuwekwa kwake Haruni kwa kazi takatifu, na kukitikisa-tikisa kiwe sadaka ya kutikiswa mbele za Yahwe nacho kitakuwa ni sehemu yako. ");
INSERT INTO swhulb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Nawe kitakase kile kidari cha ile sadaka ya kutikiswa, na lile paja la sadaka ya kuinuliwa, lililotikiswa, na lililoinuliwa juu, vya yule kondoo wa kuwekwa kwa kazi takatifu, huyo aliyekuwa kwa ajili ya Aruni na wanawe. ");
INSERT INTO swhulb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Navyo vitakuwa vya Haruni na wanawe posho ya lazima sikuzote itokayo kwa hao wana wa Israeli; kwa kuwa ni sadaka ya kuinuliwa; nayo itakuwa ni sadaka ya kuinuliwa itokayo kwa hao wana wa Israeli katika dhabihu zao za sadaka za amani, ni sadaka yao ya kuinuliwa kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Na hayo mavazi matakatifu ya Aruni yatakuwa ya wanawe baada yake, wayavae watakapotiwa mafuta, na watakapowekwa kwa kazi takatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Huyo mwanawe atakayekuwa kuhani badala yake atayavaa muda wa siku saba, hapo atakapoingia ndani ya hiyo hema ya kukutania, ili atumike ndani ya mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Nawe twaa huyo kondoo mume aliyekuwa wa kuwekwa kwa kazi takatifu, na kuitokosa nyama yake katika mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Na Aruni na wanawe wataila ile nyama ya kondoo, na mikate iliyo katika kile kikapu, hapo mbele ya mlango wa hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Nao watakula vile vitu ambavyo upatanisho ulifanywa kwa hivyo, ili kuwaweka kwa kazi takatifu na kuwatakasa; lakini mgeni asivile, maana, ni vitu vitakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Na kwamba kitu cho chote cha ile nyama, iliyo kwa ajili ya kuweka kwa kazi takatifu, au cho chote cha hiyo mikate, kikisalia hata asubuhi, ndipo utavichoma kwa moto hivyo vilivyosalia; havitaliwa, maana, ni vitu vitakatifu ");
INSERT INTO swhulb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ni hivyo utakavyowatendea Aruni na wanawe kama nilivyo kuagiza. Utawaweka kwa kazi takatifu siku saba. ");
INSERT INTO swhulb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kila siku utamtoa ng’ombe wa sadaka ya dhambi kwa ajili ya upatanisho; nawe utaisafisha hiyo madhabahu, hapo utakapofanya upatanisho kwa ajili ya hiyo madhabahu; nawe utaitia mafuta, ili kuitakasa. ");
INSERT INTO swhulb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Utafanya upatanisho kwa ajili ya hiyo madhabahu muda wa siku saba, na kuitakasa; ndipo madhabahu itakapokuwa takatifu sana; kila kitu kiigusacho madhabahu kitakuwa kitakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Lazima utoe kwenye madhabahu wana-kondoo wa mwaka mmoja wawili siku baada ya siku ");
INSERT INTO swhulb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","daima. Mwana-kondoo mmoja utamchinja asubuhi; na mwana-kondoo wa pili utamchinja jioni ");
INSERT INTO swhulb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pamoja na mwana-kondoo mmoja utatoa vibaba vitatu vya unga mzuri uliochanganyika na mafuta yenye kupondwa, kiasi cha kibaba na robo kibaba; na divai kiasi cha kibaba na robo kibaba, iwe sadaka ya kinywaji. ");
INSERT INTO swhulb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Na huyo mwana-kondoo wa pili utamchinja wakati wa jioni. Nawe utamfanyia vivyo kama ile sadaka ya unga ya asubuhi, na kama ile sadaka yake ya kinywaji. Hii itatoa harufu nzuri, ni dhabihu ya kusongezwa kwangu kwa njia ya moto. ");
INSERT INTO swhulb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Itakuwa ni sadaka ya kuteketezwa milele katika vizazi vyenu vyote mlangoni pa ile hema ya kukutania mbele ya Yahweh, hapo nitakapokutana nanyi, ili niseme na wewe hapo. ");
INSERT INTO swhulb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Nami nitakutana na wana wa Israeli hapo; na hiyo hema itafanywa takatifu na utukufu wangu. Nami nitaitakasa hiyo hema ya kukutania, na hiyo madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Pia Aruni na wanawe nitawatakasa, ili wanitumikie katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Na mimi nitakaa kati ya wana wa Israeli, nami nitakuwa Mungu wao. ");
INSERT INTO swhulb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Nao watanijua kuwa mimi ndimi Yahweh, Mungu wao, niliyewaleta watoke katika nchi ya Misri, nipate kukaa kati yao. Ni mimi Yahweh, Mungu wao. ");
INSERT INTO swhulb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Nawe fanya madhabahu ya kufukizia uvumba; utaifanyiza kwa mti wa mshita. ");
INSERT INTO swhulb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Urefu wake utakuwa dhiraa moja, na upana wake dhiraa moja; itakuwa mraba; na kwenda juu kwake dhiraa mbili; pembe zake zitakuwa za kitu kimoja nayo. ");
INSERT INTO swhulb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Nawe utaifunikiza dhahabu safi juu yake - na mbavu zake kando kando, na pembe zake. Nawe utaifanyia ukingo wa dhahabu kuizunguka. ");
INSERT INTO swhulb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kisha utaifanyia pete mbili za dhahabu, chini ya ukingo wake katika mbavu zake mbili, katika pande zake mbili utazifanya; nazo zitakuwa mahali pa kuitia miti ya kuichukulia madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Na ile miti utaifanya kwa mti wa mshita, na kuifunikiza dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Nawe utaitia mbele ya lile pazia lililo karibu na sanduku la ushuhuda mbele ya kiti cha rehema kilicho juu ya ushuhuda, hapo nitakapokutana nawe. ");
INSERT INTO swhulb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Na Aruni atafukiza uvumba wa manukato juu yake; kila siku asubuhi. Atakapozitengeneza zile taa, ataufukiza, ");
INSERT INTO swhulb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","na Aruni atakapoziwasha zile taa wakati wa jioni, ataufukiza, uwe uvumba wa daima mbele za Yahweh katika vizazi vyenu vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Hamtafukiza juu yake uvumba mgeni, wala sadaka ya kuteketezwa, wala sadaka ya unga, wala hamtamimina juu yake sadaka ya kinywaji. ");
INSERT INTO swhulb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Naye Aruni atafanya upatanisho juu ya pembe zake mara moja kila mwaka. Kwa damu ya ile sadaka ya dhambi ya kufanya upatanisho, mara moja kila mwaka ataifanyia upatanisho, katika vizazi vyenu vyote. Ni takatifu sana kwa Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","BWANA akanena na Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Utakapowahesabu wana wa Israeli, kama itakavyotokea hesabu yao, ndipo watakapompa BWANA kila mtu ukombozi kwa ajili ya roho yake, hapo utakapowahesabu; ili kwamba yasiwe maradhi kati yao, hapo utakapowahesabu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kila mtu apitaye kwa wale waliohesabiwa atatoa nusu shekeli kwa kuiandama shekeli ya mahali patakatifu; (shekeli ni gera ishirini). Nusu shekeli kwa sadaka ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kila mtu apitaye kwa wale waliohesabiwa tangu huyo ambaye umri wake ni miaka ishirini, au zaidi, atatoa hiyo sadaka kwangu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Watu watakapo leta hii sadaka kwangu kufanya upatananisho, matajiri hawataleta zaidi, wala maskini hawataleta kilichopungua katika hiyo nusu shekeli. ");
INSERT INTO swhulb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nawe utapokea hizo fedha za upatanisho mikononi mwa hao wana wa Israeli, na kuziweka kwa ajili ya utumishi wa hema ya kukutania. Ili kwamba ziwe ukumbusho kwa ajili ya wana wa Israeli mbele yangu ili kufanya upatanisho kwa ajili ya roho zenu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahweh akamwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Fanya na birika la shaba, na tako lake la shaba, ili kuogea; nawe utaliweka kati ya hema ya kukutania na madhabahu, nawe utalitia maji. ");
INSERT INTO swhulb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Na Aruni na wanawe wataosha mikono yao na miguu yao humo. ");
INSERT INTO swhulb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Hapo waingiapo ndani ya hema ya kukutania au waendepo karibu na madhabahu kunitumikia kwa kuchoma sadaka, watajiosha majini, ili wasife. ");
INSERT INTO swhulb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Basi wataosha mikono yao na miguu yao ili kwamba wasife; na neno hili litakuwa amri kwao milele, kwake yeye na kwa wazao wake katika vizazi vyao vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kisha Yahweh akasema na Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Jitwalie manukato yaliyo bora, manemane mbichi shekeli mia tano, na mdalasini wenye harufu nzuri 250, na kane shekeli 250 ");
INSERT INTO swhulb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kida shekeli mia tano, kwa kuiandama shekeli ya mahali patakatifu, na mafuta ya zeituni kiasi cha vibaba vitano. ");
INSERT INTO swhulb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Nawe utayafanya mafuta ya kutiwa matakatifu, marhamu iliyochanganywa kwa kazi ya ustadi ya mtengezaji manukato; yatakuwa ni mafuta matakatifu ya kutiwa. ");
INSERT INTO swhulb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Nawe utaipaka hema ya kukutania kwa mafuta hayo, na hilo sanduku la ushuhuda, ");
INSERT INTO swhulb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na hiyo meza, na vyombo vyake vyote, na kinara cha taa, na vyombo vyake, ");
INSERT INTO swhulb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na madhabahu ya kufukizia uvumba, na madhabahu ya kuteketezea sadaka, pamoja na vyombo vyake vyote, na birika, na tako lake. ");
INSERT INTO swhulb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nawe utavitakasa vitu hivyo, ili viwe vitakatifu sana; tena kila kivigusacho vyombo vile kitakuwa kitakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Nawe utawatia mafuta Aruni na wanawe, na kuwatakasa, ili wanitumikie katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Nawe utanena na wana wa Israeli na kuwaambia, Haya yatakuwa ni mafuta matakatifu ya kutiwa kwa ajili yangu mimi katika vizazi vyenu vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Hayatamiminwa katika kiwiliwili cha binadamu, wala msifanye mengine mfano wa haya kama yalivyoungwa kwa viungo vyake; ni matakatifu, na kwenu ninyi yatakuwa matakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mtu awaye yote atakayechanganya mafuta mfano wa haya, au mtu awaye yote atakayetia mafuta haya juu ya mgeni, mtu huyo atakatiliwa mbali na watu wake.'” ");
INSERT INTO swhulb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh akamwambia Musa, “Jitwalie manukato mazuri, yaani, natafi, na shekelethi, na kelbena; viungo vya manukato vizuri pamoja na ubani safi; vitu hivyo vyote na viwe vya kipimo kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Nawe utafanya uvumba wa vitu hivyo, manukato ya kazi ya ustadi wa mtengenazaji manukato, yatakuwa yamekolea, safi, matakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Nawe baadhi yake utayaponda sana, na kuyaweka mbele ya ushuhuda ndani ya hema ya kukutania, hapo nitakapokutana nawe; nayo yatakuwa kwenu matakatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Na uvumba utakaofanya, hamtajifanyia uvumba wenye viungo sawasawa na uvumba huo; utakuwa kwenu mtakatifu kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mtu ye yote atakayefanya mfano wa huo, ili kuunusa, mtu huyo atakatiliwa mbali na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahweh akasema na Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Angalia, nimemwita kwa jina lake Bezaleli mwana wa Uri, mwana wa Huri, wa kabila ya Yuda ");
INSERT INTO swhulb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nami nimemjaza Bezaleli na roho ya Mungu, katika hekima, na maarifa, na ujuzi, na mambo ya kazi ya kila aina, ");
INSERT INTO swhulb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ili abuni kazi za ustadi, kuwa fundi wa dhahabu, na wa fedha, na wa shaba, ");
INSERT INTO swhulb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","na kukata vito kwa kutiwa mahali, na kuchora miti, na kufanya kazi ya ustadi iwayo yote. ");
INSERT INTO swhulb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tena, nimemchagua, awe pamoja naye Oholiabu, mwana wa Ahisamaki, wa kabila ya Dani. Nami nimetia hekima katika mioyo ya wote wenye moyo wa hekima, ili wapate kufanya vyote nilivyokuagiza. Hii ni, ");
INSERT INTO swhulb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","hema ya kukutania na sanduku la ushuhuda, na kiti cha rehema kilicho juu yake, na vyombo vyote vya Hema; ");
INSERT INTO swhulb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","na meza, na vyombo vyake, na kinara cha taa safi pamoja na vyombo vyake vyote, ");
INSERT INTO swhulb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","na madhabahu ya kufukizia uvumba; na madhabahu ya sadaka ya kuteketezwa na vyombo vyake vyote, na birika na tako lake. ");
INSERT INTO swhulb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Pia mavazi yenye kufumwa kwa uzuri, na mavazi matakatifu ya Haruni kuhani, na mavazi ya wanawe, ili kutumika katika kazi ya ukuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Pia mafuta ya kutiwa, na uvumba wa manukato mazuri, kwa ajili ya mahali patakatifu; sawasawa na yote niliyokuagiza ndivyo watakavyofanya wao. ");
INSERT INTO swhulb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","akasema na Musa, ");
INSERT INTO swhulb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Waambie wana wa Israeli, 'Hakika mtazishika Sabato zangu, kwa kuwa ni ishara kati ya mimi na ninyi katika vizazi vyenu vyote; ili mpate kujua ya kuwa mimi ndimi BWANA niwatakasaye ninyi. ");
INSERT INTO swhulb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Basi mtaishika hiyo Sabato; kwa kuwa ni takatifu kwenu; kila mtu atakayeitia unajisi hakika yake atauawa; kwa kuwa kila mtu afanyaye kazi katika siku hiyo, nafsi hiyo itakatiliwa mbali na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kazi itafanywa siku sita; lakini siku ya saba ni Sabato ya kustarehe kabisa, takatifu kwa BWANA; kila mtu atakayefanya kazi yo yote katika siku ya Sabato, hakika yake atauawa. ");
INSERT INTO swhulb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kwa ajili ya hayo wana wa Israeli wataishika Sabato. Kuiangalia sana hiyo Sabato katika vizazi vyao vyote, ni agano la milele. ");
INSERT INTO swhulb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ni ishara kati ya mimi na wana wa Israeli milele; kwani kwa siku sita Yahweh alifanya mbingu na nchi, akastarehe kwa siku ya saba na kupumzika. ");
INSERT INTO swhulb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Hapo Mungu alipokuwa amekwisha zungumza na Musa katika mlima wa Sinai, akampa hizo mbao mbili za ushuhuda, mbao mbili za mawe, zilizoandikwa kwa mkono wake. ");
INSERT INTO swhulb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Hata watu walipoona ya kuwa Musa amekawia kushuka katika mlima, wakakusanyana wakamwendea Aruni, wakamwambia, “Njoo, katufanyizie sanamu itakayokwenda mbele yetu, kwa maana Musa huyo aliyetutoa katika nchi ya Misri hatujui yaliyompata.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Hivyo Aruni akawaambia, “Zitoeni pete za dhahabu zilizo katika masikio ya wake zenu, na wana wenu, na binti zenu, mkaniletee.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Watu wote wakavua pete za dhahabu zilizo katika masikio yao, na wakamletea Aruni. ");
INSERT INTO swhulb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Akapoke mikononi mwao akaitengeneza kwa patasi, akaifanya iwe sanamu ya ndama kwa kuiyeyusha. Nao wakasema, “Hiyo ndiyo miungu yako, Ee Israeli, iliyokutoa katika nchi ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Naye Haruni alipoona jambo hili, akajenga madhabahu mbele yake; Aruni akatangaza akasema, ");
INSERT INTO swhulb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","“Kesho itakuwa sikukuu kwa Yahweh.” Wakaondoka asubuhi na mapema, wakatoa dhabihu, wakaleta sadaka za amani, watu wakaketi kula na kunywa, wakaondoka wacheze. ");
INSERT INTO swhulb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kisha Yahweh akamwambia Musa, “Shuka upesi, kwa maana watu wako uliowatoa katika nchi ya Misri wamejiharibu nafsi zao. ");
INSERT INTO swhulb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wamepotoka upesi kuiacha ile njia niliyowaamuru, wamejifanyizia ndama ya kuyeyusha wakaiabudu na kuitolea dhabihu. Wakasema, 'Hiyo ndiyo miungu yako, Ee Israeli, iliyokutoa katika nchi ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Kisha Yahweh akamwambia Musa, “Mimi nimewaona watu hawa, na tazama, ni watu wenye shingo ngumu. ");
INSERT INTO swhulb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Basi sasa usinizuie. Ili hasira zangu ziwake juu yao, niwaangamize. Nami nitakufanya wewe uwe taifa kuu.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa akamsihi sana Yahweh Mungu wake, na kusema,”Yahweh, kwa nini hasira zako kuwaka juu ya watu wako uliowaleta kutoka nchi ya Misri kwa uweza mkuu, na kwa mkono wenye nguvu? ");
INSERT INTO swhulb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kwa nini Wamisri kusema, 'Amewatoa kwa kuwatenda uovu, ili apate kuwaua milimani, na kuwaondoa watoke juu ya uso wa nchi?' Geuka katika hasira yako kali, ughairi uovu huu ulio nao juu ya watu wako. ");
INSERT INTO swhulb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Mkumbuke Ibrahimu, na Isaka, na Israeli, watumishi wako, ambao uliwaapia kwa nafsi yako, na kuwaambia, 'Nitazidisha kizazi chenu mfano wa nyota za mbinguni; tena nchi hii yote niliyoinena nitakipa kizazi chenu nao watairithi milele.'” ");
INSERT INTO swhulb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na Yahweh akaughairi ule uovu aliosema ya kwamba atawatenda watu wake. ");
INSERT INTO swhulb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kisha Musa akageuka akashuka katika mlima, na zile mbao mbili za mawe mikononi mwake. Mbao zilizoandikwa pande zote mbili, upande huu na upande huu ziliandikwa. ");
INSERT INTO swhulb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Na zile mbao zilikuwa kazi ya Mungu nayo maandiko yalikuwa maandiko ya Mungu, yaliyochorwa katika zile mbao. ");
INSERT INTO swhulb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Na Yoshua aliposikia kelele za watu walipokuwa wakipiga kelele, akamwambia Musa, “Kuna kelele ya vita kambini. ");
INSERT INTO swhulb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","“Lakini Musa akasema, “Hiyo si sauti ya watu wapigao kelele kwa sababu ya kushinda vitani, wala si sauti ya watu wapigao kelele kwa sababu ya kushindwa; bali kelele za watu waimbao ndizo ninazozisikia mimi.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Hata alipoyakaribia kambini akaiona ile ndama, na watu wakicheza. Hasira ya Musa ikawaka. Akazitupa zile mbao mikononi mwake, akazivunja chini ya mlima. ");
INSERT INTO swhulb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Akaitwaa ile ndama waliyoifanya, akaichoma moto, akaisaga hata ikawa mavumbi, akainyunyiza juu ya maji. Akawanywesha wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa akamwambia Aruni, “Watu hawa wamekufanyani hata ukaleta dhambi hii kuu juu yao? ");
INSERT INTO swhulb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aruni akasema, “Hasira yako isiwake, bwana wangu. Wewe unawajua watu hawa, ya kuwa wamejielekeza kwa mabaya. ");
INSERT INTO swhulb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Maana waliniambia, 'Katufanyie miungu, itakayokwenda mbele yetu. Kwa maana mtu huyo Musa, aliyetutoa katika nchi ya Misri, hatujui yaliyompata.' ");
INSERT INTO swhulb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nikawaambia, 'Mtu ye yote aliye na dhahabu na aivue; basi wakanipa, nami nikaitupa ndani ya moto, akatoka ndama huyu.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Basi Musa alipoona ya kuwa watu hawa wameasi (maana Haruni amewaacha waasi, ili wawe dhihaka kati ya adui zao) ");
INSERT INTO swhulb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ndipo Musa akasimama katika mlango wa marago, akasema, “Mtu awaye yote aliye upande wa Yahweh na aje kwangu.” Wana wa Lawi wote wakamkusanyikia. ");
INSERT INTO swhulb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Akawaambia, Yahweh, Mungu wa Israeli, asema hivi, 'Kila mtu na ajifunge upanga wake pajani mwake, akapite huko na huko toka mlango hata mlango kati ya marago, mkamchinje kila mtu ndugu yake, na kila mtu mwenziwe na kila mtu jirani yake.'” ");
INSERT INTO swhulb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Na hao wana wa Lawi wakafanya kama vile alivyosema Musa, wakaanguka siku ile kama watu elfu tatu. ");
INSERT INTO swhulb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa akasema, Jiwekeni wakfu kwa Yahweh leo, kila mtu juu ya mwanawe na juu ya ndugu yake; ili Yahweh awape baraka leo.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Hata asubuhi yake Musa akawaambia watu, “Mmetenda dhambi kuu. Sasa nitakwenda juu kwa Yahweh. Labda nitafanya upatanisho kwa ajili ya dhambi yenu.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa akarejea kwa Yahweh akasema,” Oh! Watu hawa wametenda dhambi kuu wamejifanyia miungu ya dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Walakini sasa, ikiwa utawasamehe dhambi yao – na kama sivyo, unifute, nakusihi, katika kitabu chako ulichoandika.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahweh akamwambia Musa, “Mtu ye yote aliyenitenda dhambi ndiye nitakayemfuta katika kitabu changu. ");
INSERT INTO swhulb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Basi sasa uende ukawaongoze watu hawa mpaka mahali pale ambapo nimekwambia habari zake. Tazama, malaika wangu atakutangulia. Lakini pamoja na hayo siku nitakayowajilia nitawapatiliza kwa ajili ya dhambi yao.” ");
INSERT INTO swhulb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kisha Yahweh akawapiga hao watu, kwa walivyoifanya ile ndama, ambayo Aruni aliifanya. ");
INSERT INTO swhulb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahweh anasema na Musa, “Nenda kutoka hapa, wewe na watu ulio watoa kutoka nchi ya Misri. Nenda kwenye nchi nilio fanya nadhiri na Ibrahimu, Isaka, Yakobo, nilipo sema, 'Nitakupa wewe na uzao wako'.' ");
INSERT INTO swhulb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nitatuma malaika mbele yako, na kuwaondoa Wakanani, Waamori, Wahiti, Waperizi, Wahivi, na Wayebusi. ");
INSERT INTO swhulb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Nenda kwenye hiyo nchi, inayo tiririka kwa maziwa na asali, lakini sitaenda nawe, kwasababu ninyi ni watu wajehuri. Ninaweza kuwaharibu njiani.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Watu walipo sikia haya maneno ya kushtua, walilia, na hakuna aliye vaa mikufu. ");
INSERT INTO swhulb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahweh alisema kwa Musa, “Waambie Waisraeli, 'Ninyi ni watu wakorofi. Kama ningeenda miongoni mwenu ata kwa muda kidogo, nigewaharibu ninyi. Hivyo sasa, toa mikufu yenu ili niamue nini cha kufanya kwenu.”' ");
INSERT INTO swhulb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Hivyo Waisraeli hawaku vaa mikufu kutoka Mlima Horebu na kwendelea. ");
INSERT INTO swhulb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa akachukua hema na kukita nje ya kambi, umbali kidogo na kambini. Aliita hema ya kukutania. Kila mtu alliye muuliza Yahweh kitu chochote alienda kwenye hema ya kukutania, nje ya kambi. ");
INSERT INTO swhulb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kisha Musa alipo enda kwenye hema, watu wote walisima kando ya hema yao na kumuangalia Musa hadi alipo ingia ndani. ");
INSERT INTO swhulb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Wakati wowote Musa alipo ingia hemani, nguzo ya wingu ilishuka chini na kusimama nje ya lango la hema, na Yahweh alizungumza na Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wakati wowote watu walipo ona nguzo ya wingu imesimama langoni mwa hema, waliamka na kuabudu, kila langoni mwa hema yake. ");
INSERT INTO swhulb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahweh alizungumza na Musa uso kwa uso, kama mtu anapo zungumza na rafiki yake. Kisha Musa alirudi kambini, lakini mtumishi wake Yoshua mwana wa Nuni, kijana, alibaki hemani. ");
INSERT INTO swhulb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa alisema na Yahweh, “Ona, umekuwa ukisema na mimi, 'Chukuwa watu hawa safarini,' lakini hauja niambia nani utamtuma na mimi. Umesema, 'Nina kujua kwa jina, na umepata upendeleo kwangu.' ");
INSERT INTO swhulb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kama nimepata upendeleo machoni pako, nionyeshe njia zako ili nikujue na kuendelea kupata upendeleo machoni pako. Kumbuka ili taifa ni watu wako.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yahweh akajibu, “Uwepo wangu utaenda nawe, na nitakupa pumziko.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa akasema, “Kama uwepo wako hautaenda nasi, usitutoe hapa. ");
INSERT INTO swhulb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Au je, itajulikanaje niimepata upendeleo machoni pako, mimi na watu wako? Haitakuwa kuwa tu kama ukienda nasi mimi na watu wako tutakuwa na utofauti na watu wengine wote waliopo katika uso wa dunia?” ");
INSERT INTO swhulb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahweh akamwambia Musa, “Nitafanya pia hichi kitu ulicho niomba, kwa kuwa umepata upendeleo machoni mwangu, na nina kujua kwa jina lako.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa akasema, Tafadhali nionyeshe utukufu wako.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yahweh akasema, “Nitafanya wema wangu wote ujulikani kwako, na nitatangaza jina langu 'Yahweh' kwako. Nitakuwa na neema kwake nitakae kuwa na neema, na nitaonyesha rehema kwake nitakaye onyesha rehema.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Lakini Yahweh akasema, “Hauta ona uso wangu, kwa kuwa hakuna aonaye uso wangu na kuiishi.” ");
INSERT INTO swhulb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahweh akasema, “Ona, hapa kuna sehemu yangu; utasimama kwenye huu mwamba. ");
INSERT INTO swhulb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Wakati utukufu wangu unapita, nitakuweka kwenye shimo kubwa la mwamba na kukufunika kwa mkono wangu mpaka nitakapo pita. ");
INSERT INTO swhulb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kisha nitaondoa mkono wangu, na utaona mgongo wangu, ila uso wangu hautaonekana.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahweh akamwabia Musa, “Kata mbao mbili za mawe kama zile za awali. Nitaandika kwenye hizi mbao za mawe maneno yaliyo kuwa kwenye mbao za mawe za mwanzo, mbao za mawe ulizo zivunja. ");
INSERT INTO swhulb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kuwa tayari asubui na uje Mlima Sinai, na uje mbele zangu juu ya mlima. ");
INSERT INTO swhulb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Hakuna atakaye kuja nawe. Usiruhusu mtu yeyote aonekana popote kwenye mlima. Hakuna kundi la mifugo wanao ruhusiwa ata kula mbele ya mlima.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hivyo Musa akakata mbao mbili za mawe kama za mwanzo, na akaamka asubui mapema na kwenda juu ya Mlima Sinai, kama Yahweh alivyo muelekeza. Musa alibeba mbao za mawe mikononi mwake. ");
INSERT INTO swhulb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahweh akaja chini katika wingu na akasima mbele za Musa, na akatamka jina “Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahweh akapita kwake na kukiri, “Yahweh, Yahweh, Mungu ni wa rehema na wa neema, sio mwepesi wa hasira, na anadumu katika uwaminifu wa agano na uadilifu, ");
INSERT INTO swhulb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ukishika uaminifu wa agano kwa vizazi maelfu, ukisamehe maasi, makosa, na dhambi. Lakini hamsafishi mwenye hatia. Ataleta adhabu ya dhambi za baba kwa watoto wao na watoto wa watoto wao, kwa kizazi cha tatu na hadi cha nne.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa haraka akainamisha kichwa chake kwenye ardhi na kuabudu. ");
INSERT INTO swhulb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kisha akasema, “Kama sasa nimepata upendeleo machoni pako, Bwana wangu, tafadhali nenda pamoja nasi, kwa kuwa hawa watu ni wa korofi. Samehe maasi yetu na dhambi zetu, na utuchukuwe kama urithi wako.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yahweh akasema, “Ona, ninakaribu kufanya agano. Mbele za watu wako, nitafanya maajabu ambayo hayajawai kufanywa duniani kote wala kwenye taifa lote. Watu wote miongoni mwako wataona matendo yangu, kwa kuwa ni kitu cha hofu ninacho fanya kwako. ");
INSERT INTO swhulb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tii amri zangu leo. Ninawaondoa mbele yako Waamori, Wakanani, Wahivi, Wahiti, Waperizi, Wahivi, na Wayebusi. ");
INSERT INTO swhulb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kuwa mwanglifu usifanye agano na wakazi wa nchi unayo kwenda, au wata kuwa mtego kwako. ");
INSERT INTO swhulb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Badala yake, lazima uvunje madhabahu zao, ponda nguzo zao za mawe, na kukata nguzo zao za Ashera. ");
INSERT INTO swhulb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kwa kuwa wewe haupaswi kumuabudu mungu mwingine, maana Yahweh, ambaye jina lake ni Uwivu, ni Mungu wa uwivu. ");
INSERT INTO swhulb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Hivyo kuwa mwangalifu usifanye agano na wakazi wa nchi, kwa kuwa wanajifanyia ukahaba kwa miungu yao, na wanatoa dhabihu kwa miungu yao. Kisha mmoja wao ata kukaribisha na wewe utakula baadhi ya dhabihu zake, ");
INSERT INTO swhulb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","na kisha utachukuwa baadhi ya mabinti zake kwa wanao, na mabinti wake watafanya ukahaba kwa miungu yao, na watafanya wanao kufanya ukahaba kwa miungu yao. ");
INSERT INTO swhulb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Usifanye Miungu ya chuma ya kuyayusha. ");
INSERT INTO swhulb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Laziam ushike Sherehe ya Mkate Usiotiwachachu. Kama nilivyo kuamuru, lazima ule mkate usio na hamira kwa siku saba kwa muda uliotengwa wa mwezi wa Abibu, maana nikatika mwezi wa Abibu ulitoka Misri. ");
INSERT INTO swhulb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Wazaliwa wote ni mwangu, ata mzaliwa wa kwanza wa kiume wa mifugo, yote ya ng'ombe na kondoo. ");
INSERT INTO swhulb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Lazima umnunue tena mzaliwa kwanza wa punda kwa kondoo, lakini usipo mnunua tena, kisha uivunje shingo yake. Lazima ununue tena wazaliwa wa kwanza wote wa wanao. Hakuna ata mmoja atakye kuja kwangu mikono mitupu. ");
INSERT INTO swhulb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Utafanya kazi kwa siku sita, lakini siku ya saba utapumzika. Ata wakati wakilimo na wa mavuno, lazima upumzike. ");
INSERT INTO swhulb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Lazima uadhimishe Sherehe ya Majuma kwa mazao ya kwanza ya mavuno ya ngano, na lazima uadhimishe Sherehe ya Makusanyo mwisho wa mwaka. ");
INSERT INTO swhulb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mara tatu kwa mwaka wanaume wenu wote watajitokeza kwa Bwana Yahweh, Mungu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kwa kuwa nitaondoa mataifa mbele yenu na kutanua mipika. Hakuna atakaye tamani kuwa na ardhi yenu kama yao utakapo toka mbele za Yahweh mara tatu kwa mwaka. ");
INSERT INTO swhulb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Hautatoa damu ya dhabihu yangu na hamira yeyote, wala nyama yeyote kutoka dhabihu za Sherehe ya Pasaka kubaki hadi asubui. ");
INSERT INTO swhulb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Lazima ulete matunda ya kwanza yalio bora kutoka nyumbani kwako. Usimchemshe mbuzi mtoto katika maziwa ya mama yake.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh akamwabia Musa, “Andika chini haya maneno, kwa kuwa nimejiahidi haya maneno niliyo yasema, na nimefanya agano kwako na Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa alikuwa huko na Yahweh kwa siku arobaini na usiku; hakula chakula chochote wala kunywa maji yeyote. Aliandika katika mbao maneno ya agano, Amri kumi. ");
INSERT INTO swhulb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa alipo shuka chini ya Mlima Sinai na mbao mbili za agano za ushuhuda mikononi mwake, hakujua kuwa ngozi ya kuwa uso wake ulikuwa wa'ngaa akizungumza na Mungu. ");
INSERT INTO swhulb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Wakati Aruni na Waisraeli walipo muona Musa, ngozi ya uso wake ulikuwa wa ng'aa, na waliogopa kuja karibu yake. ");
INSERT INTO swhulb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lakini Musa aliwaita, na Aruni na viongozi wa jamii wakaja kwake. Kisha Musa akasema nao. ");
INSERT INTO swhulb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Baada ya haya, watu wote wa Israeli wakaja kwa Musa, na akawambia amri zote Yahweh alizo mpa katika Mlima Sinai. ");
INSERT INTO swhulb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa alipo maliza kuzungumza nao, alifunika uso wake kwa kitambaa. ");
INSERT INTO swhulb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Wakati Musa alipoenda mbele za Yahweh kusema naye, aliondoa kitambaa, hadi alipo toka. Alipo toka, aliwaambia Waisraeli alicho amriwa kusema. ");
INSERT INTO swhulb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Waisraeli walipo muona Musa ana'ngaa uso, alirudisha kitambaa tena usoni mpaka alipokuwa anaenda kuongea na Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa akawakusanya jamii yote ya Waisraeli na kuwaambia, “Haya ndio mambo Yahweh aliyo waamuru mfanye. ");
INSERT INTO swhulb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kwa siku sita kazi ya weza fanywa, lakini kwako, siku ya saba lazima iwe siku takatifu, siku ya Sabato ya mapumziko, takatifu kwa Yahweh. Yeyote atakaye fanya kazi hiyo siku lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Haupaswi kuwasha moto kwenye nyumba zenu siku ya Sabato.” ");
INSERT INTO swhulb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa akasema na jamii yote ya Waisraeli, kwa kusema, “Hichi ndicho kitu Yahweh alicho amuru. ");
INSERT INTO swhulb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Chukuwa sadaka kwa ajili ya Yahweh, wote wenye moyo mkunjufu. Leta sadaka kwa Yahweh - dhahabu, fedha, shaba, ");
INSERT INTO swhulb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","buluu, zambarau, sufu nyekundu na kitambaa kizuri; nywele za mbuzi; ");
INSERT INTO swhulb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ngozi za kondoo zilizotiwa rangi nyekundu na ngozi za pomboo; na mbao za mshita; ");
INSERT INTO swhulb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta ya taa kwa pahali patakatifu, viungo vya manukato kwa hayo mafuta ya kutiwa, ");
INSERT INTO swhulb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kwa uvumba mzuri na vito vya shohamu na vito vya kutiwa kwa hiyo naivera, na kwa hicho kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Kila mwanaume mwenye ustadi kati yenu aje na afanye kila kitu ambacho Yahweh aliyaamuru — ");
INSERT INTO swhulb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","hema la kuabudia, na kifuniko chake, na vifungo vyake, na mbao zake, nguzo, na sakafu; ");
INSERT INTO swhulb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","pia sanduku na nguzo zake, kiti cha rehema, na pazia la kusitiri. ");
INSERT INTO swhulb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Walileta meza na miguu yake, vyombo vyake vyote, na mkate wa wonyesho; ");
INSERT INTO swhulb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kinara cha taa, vyombo vyake, taa, na mafuta ya zile taa; ");
INSERT INTO swhulb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ile madhabahu ya uvumba na nguzo zake, mafuta ya upako na uvumba ulitiwa maukato; kishikizo cha mwingilio wa hema ya kuabudia; ");
INSERT INTO swhulb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","madhabahu ya sadaka ya kuteketeza na kitunzi cha shaba na nguzo na vyombo; na ile beseni kubwa na sakafu yake. ");
INSERT INTO swhulb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Walileta vishikizo kwa ajili ya nyuani na nguzo zake na sakafu yake, na pazia kwa ajili mwingilio wa nyauni; ");
INSERT INTO swhulb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na ile misumari ya hema la kuabudia na nyuani, pamoja na kamba zake. ");
INSERT INTO swhulb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Walileta mavazi yaliyofumwa kutumikia sehemu takatifu, mavazi takatifu ya Aruni kuhani na wanae, kwa wao kutumika kama makuhani.” ");
INSERT INTO swhulb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kisha makabila yote ya Israeli yakaondoka na kwenda kutoka uweponi mwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kila mtu moyo wake ulimchochea na aliye andaliwa na roho yake alikuja na kuleta sadaka kwa Yahweh kwa matengenezo ya hema ya kuabudia, kwa vitu vyote kwajili ya huduma ndani yake, na kwa vazi takatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Walikuja, wote wanaume kwa wanawake, wote waliokuwa na moyo wa utayari. Walileta madini, hereni, pete, na vitu vya thamani, vitu vyote tofauti vyenye madini ya dhahabu. Waliwasilisha sadaka za dhahabu kama sadaka ya kupunga kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kila mmoja alikuwa na sufu ya buluu, dhambarau, au nyekundu, nguo nzuri, singa za mbuzi, ngozi za kondoo zilizobadili kuwa nyekundu, na ngozi ya pomboo walivileta. ");
INSERT INTO swhulb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","kila mmoja alitengeneza sadaka ya fedha au shaba walizileta kama sadaka kwa Yahweh, na kila mmoja aliyekuwa na mti wa mshita kwa matumizi ya kazi aliuleta. ");
INSERT INTO swhulb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","kila mwanamke mwenye ustadi walisokota sufu kwa mikono yao na walileta sufu walizosokota za buluu, dhambarau, au sufu nyekundu, au nguo nzuri. ");
INSERT INTO swhulb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Wanawake wote wenye mioyo iliyochochewa na walio na ustadi walisokota singa za mbuzi. ");
INSERT INTO swhulb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Viongozi walileta mawe ya shohamu na mawe mengine kwaajili ya kuwekwa kwenye hiyo naivera na hicho kifuko cha kifuani; ");
INSERT INTO swhulb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","walileta viungo na mafuta kwaajili ya taa, kwa mafuta ya upako, na kwa uvumba wa manukato. ");
INSERT INTO swhulb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Waisraeli walileta sadaka ya hiyari kwa Yahweh; kila mwanaume na mwanamke ambao mioyo yao ilikuwa tayari walileta vifaa kwaajili kazi zote ambazo Yahweh aliamuru kupitia Musa zifanyike. ");
INSERT INTO swhulb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa alisema kwa waisraeli, “Tazama, Yahweh ameita kwa jina juu ya Bezaleli mwana wa Uri mwana wa Huri, kutoka kabila la Yuda. ");
INSERT INTO swhulb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Aliijaza Bezaleli kwa Roho yake, kumpa hekima, uwelewa, na maarifa, kwa aina zote za ujenzi, ");
INSERT INTO swhulb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kufanya sanaa ya ubunifu na kufanya kazi za dhahabu, shaba, na shaba; ");
INSERT INTO swhulb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pia kukata na kupanga mawe na mbao iliochongwa- kufanya kazi za aina zote kwa ubunifu na ujenzi. ");
INSERT INTO swhulb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Aliiweka kufundisha ndani ya moyo wake, yeye pamoja na Oholiabu mwana wa Ahisamaki, kutoka kabila la Dani. ");
INSERT INTO swhulb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Aliwajaza kwa ustadi wa kufanya kazi za aina zote, kufanya kazi ya kama kuchora mawe, kama mwerevu, kama mtia taraza katika nyuzi za rangu ya buluu, dhambarau, na nyekundu na nguo nzuri, na kama washonaji. Walikuwa wachonga mawe wa kazi zote, na walikuwa wabunifu wa sanaa. ");
INSERT INTO swhulb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Hivyo Bezaleli na Oholiabu na kila mtu mwenye ustadi ambaye Yahweh aliye mpa ustadi na uwezo kujua jinsi ya kufanya kazi katika ujenzi wa sehemu takatifu wafanye kazi kadiri ya yote Yahweh aliyo amuru.” ");
INSERT INTO swhulb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa akamuita Bezaleli, Oholiabu, na kila mtu mwenye ujuzi ambaye Yahweh kampa ujuzi, na ambaye moyoni mwake ulichochewa kuja na kufanya kazi. ");
INSERT INTO swhulb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Walipokea kutoka kwa Musa sadaka zote ambazo Waisraeli walizo leta kwa ujenzi ya sehemu takatifu. Watu walikuwa bado wanaleta sadaka za hiari kila asubui kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Hivyo watu wote walikuwa na ujuzi walikuwa wakifanya kazi sehemu takatifu walikuja kutoka kwenye kazi walikuwa wakifanya. ");
INSERT INTO swhulb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Wachonga mawe walimwabia Musa, “Watu wanaleta zaidi sana ya yanayo itajika kufanya kazi Yahweh aliyo tuamuru.” ");
INSERT INTO swhulb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Hivyo Musa akaamuru mtu yeyote asilete tena kwa ujenzi wa sehemu takatifu. Kisha watu wakaacha kuleta hivi vitu. ");
INSERT INTO swhulb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Walikuwa na zaidi ya vitu vya ujenzi. ");
INSERT INTO swhulb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Hivyo wachonga mawe miongoni mwao wakajenga lile hema la kuabudia kwa mapazia kumi yaliyo jengwa kitamba kizuri na buluu, zambarau, na sufu nyekundu kwa aina ya kerubi. Hii ni kazi ya Bezaleli, mjenzi mwenye ujuzi sana. ");
INSERT INTO swhulb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Urefu wa kila pazia ulikuwa mikono ishirini na nane, nao upana wa kila kitambaa ulikuwa mikono minne. Vitambaa vyote hivyo vilikuwa na kipimo kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bezaleli akaunganisha vitambaa vitano pamoja, na vile vitambaa vingine vitano akaviunganisha pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kisha akafanya vitanzi vya uzi wa bluu kwenye upindo wa kitambaa kilicho mahali pa kuungania. Akafanya vivyo hivyo kwenye upindo wa kitambaa cha nje kabisa kilicho mahali pale pengine pa kuungania. ");
INSERT INTO swhulb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Akafanya vitanzi hamsini kwenye kitambaa kimoja, akafanya vitanzi hamsini kwenye mwisho wa kitambaa kilichokuwa mahali pale pengine pa kuungania, vitanzi hivyo vikiwa vinaelekeana. ");
INSERT INTO swhulb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Mwishowe akafanya kulabu hamsini za dhahabu na kuviunganisha vitambaa hivyo pamoja kwa kulabu hizo, hivi kwamba hiyo ikawa maskani moja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Bezaleli akafanya vitambaa vya mahema vya manyoya ya mbuzi kwa ajili ya hema lililo juu ya maskani. Vitambaa kumi na moja ndivyo alivyofanyiza. ");
INSERT INTO swhulb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Urefu wa kila kitambaa ulikuwa mikono thelathini, nao upana wa kila kitambaa ulikuwa mikono minne. Vitambaa hivyo kumi na moja vilikuwa na kipimo kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kisha akaunganisha vitambaa vitano pamoja na vile vitambaa vingine sita pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Kisha akafanya vitanzi hamsini kwenye upindo wa kitambaa cha nje kabisa kilicho mahali pa kuungania, naye akafanya vitanzi hamsini kwenye upindo wa kile kitambaa kingine kilichoungana nacho. ");
INSERT INTO swhulb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bezaleli akafanya kulabu hamsini za shaba kwa ajili ya kuliunganisha hilo hema pamoja liwe kipande kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Naye akafanya kifuniko cha hema kutokana na ngozi za kondoo dume zilizotiwa rangi nyekundu na kifuniko kutokana na ngozi za sili, upande wa juu. ");
INSERT INTO swhulb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Bezaleli akafanya viunzi vya mbao vya hema ya kukutani kutokana na mbao za mshita. ");
INSERT INTO swhulb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Urefu wa kiunzi ulikuwa mikono kumi, nao upana wa kila kiunzi ulikuwa mkono mmoja na nusu. ");
INSERT INTO swhulb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kila kiunzi kilikuwa na ndimi mbili zilizounganishwa. Hivyo ndivyo alivyofanya viunzi vyote vya maskani. ");
INSERT INTO swhulb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Basi akafanya viunzi vya maskani, viunzi ishirini kwa ajili ya upande kuelekea kusini. ");
INSERT INTO swhulb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Bezaleli akafanya vikalio arobaini vya fedha viwe chini ya vile viunzi ishirini, vikalio viwili chini ya kiunzi kimoja pamoja na ndimi zake mbili na vikalio vingine viwili chini ya kiunzi kingine pamoja na ndimi zake mbili. ");
INSERT INTO swhulb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Na kwa ajili ya ule upande mwingine wa maskani, upande wa kaskazini, akafanya viunzi ishirini ");
INSERT INTO swhulb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vikalio vyake arobaini vya fedha. Vikalio viwili chini ya kiunzi kimoja na vikalio viwili chini ya kiunzi kingine ");
INSERT INTO swhulb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Na kwa ajili ya zile pande za nyuma za maskani kuelekea magharibi akafanya viunzi sita. ");
INSERT INTO swhulb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Naye akafanya viunzi viwili vya pembeni ya maskani kwenye pande zake mbili za nyuma ");
INSERT INTO swhulb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Hizi zilikuwa pacha upande wa chini, lakini juu ya kila moja kwenye pete ya kwanza. Hivyo ndivyo alivyoifanya yote miwili, ile miimo ya pembeni. ");
INSERT INTO swhulb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Basi vikajumlika kuwa viunzi vinane na vikalio vyake kumi na sita vya fedha, vikalio viwili kando ya vikalio viwili chini ya kila kiunzi. ");
INSERT INTO swhulb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Bezaleli akafanya miti ya mshita, mitano kwa ajili ya viunzi vya upande mmoja wa maskani, ");
INSERT INTO swhulb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","na miti mitano kwa ajili ya viunzi vya upande ule mwingine wa maskani na miti mitano kwa ajili ya viunzi vya maskani kwa ajili ya zile pande mbili za nyuma za magharibi. ");
INSERT INTO swhulb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kisha akafanya mti wa katikati upitie katikati ya vile viunzi toka mwisho mmoja mpaka ule mwingine. ");
INSERT INTO swhulb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Naye akavifunika vile viunzi kwa dhahabu, akafanyiza pete zake za dhahabu ziwe vitegemezo kwa ajili ya ile miti, akaifunika ile miti kwa dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Bezaleli akafanya pazia, la uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa cha rangi nyekundu ya kochinili na kitani bora kilichosokotwa, kalitia makerubi kwa kazi ya mjenzi. ");
INSERT INTO swhulb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Kisha akalifanyia nguzo nne za mshita na kuzifunika kwa dhahabu, vibanio vyake vikiwa vya dhahabu, na kutengeneza vikalio vinne vya fedha kwa ajili yake. ");
INSERT INTO swhulb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Naye akafanya kisitiri kwa ajili ya mwingilio wa hema kutokana na uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora kilichosokotwa, kazi ya mfumaji. ");
INSERT INTO swhulb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Pia akafanya na nguzo zake tano na vibanio vyake. Naye akavifunika vilele vyake na viungo vyake kwa dhahabu, lakini vile vikalio vyake vitano vilikuwa vya shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli akafanya Sanduku la mbao za mshita. Mikono miwili na nusu urefu wake, na mkono mmoja na nusu upana wake, na mkono mmoja na nusu kimo chake. ");
INSERT INTO swhulb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kisha akalifunika kwa dhahabu safi ndani na nje na kulifanyia ukingo wa dhahabu kulizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kisha akalitengenezea pete nne za dhahabu, za juu ya miguu yake minne, pete mbili upande wake mmoja na pete mbili upande wake mwingine ");
INSERT INTO swhulb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kisha akafanya miti ya mshita na kuifunika kwa dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Halafu akaitia miti hiyo kwenye zile pete zilizo pande za Sanduku ili kulibeba Sanduku. ");
INSERT INTO swhulb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Naye akafanya kifuniko cha dhahabu safi. Mikono miwili na nusu urefu wake, na mkono mmoja na nusu upana wake. ");
INSERT INTO swhulb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Bezaleli akafanya makerubi wawili wa dhahabu. Kwa kazi ya kufua akawafanya kwenye miisho yote miwili ya kifuniko. ");
INSERT INTO swhulb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kerubi mmoja kwenye mwisho ule, na yule kerubi mwingine kwenye mwisho huu. Aliwafanya makerubi juu ya kifuniko kwenye miisho yote miwili. ");
INSERT INTO swhulb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nao wakawa makerubi wanaonyoosha mabawa yao mawili kuelekea juu, wakisitiri kifuniko kwa mabawa yao, nazo nyuso zao zilikuwa zikielekeana. Nyuso za makerubi hao zilielekea kifuniko hicho. ");
INSERT INTO swhulb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezaleli akafanya meza ya mbao za mshita. Mikono miwili urefu wake, na mkono mmoja upana wake, na mkono mmoja na nusu kimo chake. ");
INSERT INTO swhulb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Halafu akaifunika kwa dhahabu safi na kufanya ukingo wa dhahabu kuizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kisha akafanya mzingo wa upana wa kiganja kuizunguka na kufanya ukingo wa dhahabu kwa ajili ya mzingo wake kuizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Tena, akatengeneza pete nne za dhahabu kwa ajili yake na kuziweka pete hizo kwenye zile pembe nne zilizokuwa kwa ajili ya ile miguu minne. ");
INSERT INTO swhulb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Pete hizo zilikuwa karibu na ule mzingo, ili kutegemeza ile miti ya kuibeba meza hiyo. ");
INSERT INTO swhulb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Halafu akafanya ile miti ya mshita na kuifunika kwa dhahabu ili kuibeba ile meza. ");
INSERT INTO swhulb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Baada ya hilo akafanya kutokana na dhahabu safi vile vyombo vilivyo juu ya meza, sahani zake na vikombe vyake na mabakuli yake na mitungi yake iliyotumiwa kumimina matoleo ya kinywaji. ");
INSERT INTO swhulb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kisha akafanya kinara cha taa cha dhahabu safi. Kwa kazi ya kufua akakifanya kinara cha taa. Pande zake na matawi yake, vikombe vyake, mafundo yake na maua yake vikatokea kwake. ");
INSERT INTO swhulb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Na matawi sita yalikuwa yakitoka kwenye pande zake, matawi matatu ya kinara cha taa kutoka kwenye upande wake mmoja na matawi mengine matatu ya kinara cha taa kutoka kwenye ule upande wake mwingine. ");
INSERT INTO swhulb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Vikombe vitatu vyenye umbo la maua ya mlozi vilikuwa kwenye kikundi kimoja cha matawi, vifundo na maua yakifuatana; na vikombe vitatu vyenye umbo la maua ya mlozi vilikuwa kwenye kile kikundi kingine cha matawi, vifundo na maua yakifuatana. Hivyo ndivyo ilivyokuwa kwa yale matawi sita yaliyokuwa yakitoka katika kile kinara cha taa. ");
INSERT INTO swhulb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na kwenye kile kinara cha taa kulikuwa na vikombe vinne vyenye umbo la maua ya mlozi, vifundo vyake na maua yake yakifuatana. ");
INSERT INTO swhulb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Na kile kifundo chini ya matawi mawili kilitoka kwake, na kifundo kilicho chini ya yale matawi mengine mawili kilitoka kwake, na kifundo kingine kilicho chini ya matawi mengine mawili zaidi kilitoka kwake, kwa ajili ya matawi sita yanayotoka katika kinara. ");
INSERT INTO swhulb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Vifundo vyake na matawi yake vilitoka kwake, vyote vilikuwa kitu kimoja cha kazi ya kufua, cha dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Kisha akafanya taa zake saba na mikasi ya tambi zake na vyetezo vyake kutokana na dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Alikifanya kwa talanta ya dhahabu safi, hicho pamoja na vyombo vyake vyote. ");
INSERT INTO swhulb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Sasa akafanya madhabahu ya uvumba+ kutokana na mbao za mshita. + Mkono mmoja urefu wake na mkono mmoja upana wake, ikiwa mraba, na mikono miwili kimo chake. Pembe zake zilitoka kwake. ");
INSERT INTO swhulb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kisha akaifunika kwa dhahabu safi, upande wake wa juu na pande zake za kando kuizunguka na pembe zake, naye akafanya ukingo wa dhahabu kuizunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Naye akaifanyia pete mbili za dhahabu chini ya ukingo wake kwenye pande zake mbili, kwenye pande zake mbili zinazoelekeana, za kutegemeza ile miti ya kuibeba. ");
INSERT INTO swhulb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kisha akafanya ile miti ya mshita na kuifunika kwa dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Tena akafanya yale mafuta yanayotumiwa kutia mafuta na ule uvumba safi uliotiwa manukato, + kazi ya mtengenezaji wa marhamu. ");
INSERT INTO swhulb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Naye akafanya madhabahu ya toleo la kuteketezwa kwa mbao za mshita. Mikono mitano urefu wake, na mikono mitano upana wake, ilikuwa mraba, na mikono mitatu kimo chake. ");
INSERT INTO swhulb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Halafu akafanya pembe zake kwenye zile ncha zake nne. Pembe zake zilitoka kwake. Kisha akaifunika kwa shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Baada ya hilo akavifanya vyombo vyote vya madhabahu, yale makopo na zile sepetu na yale mabakuli, zile nyuma na vile vyetezo. Vyombo vyake vyote alivifanya kwa shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Tena akaifanyia madhabahu kiunzi cha fito, mtandao wa shaba, chini ya ukingo wake, chini kuelekea katikati yake. ");
INSERT INTO swhulb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Halafu akatengeneza pete nne kwenye ile miisho minne karibu na kile kiunzi cha shaba, ili kuitegemeza ile miti. ");
INSERT INTO swhulb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Bezaleli akafanya miti ya mshita na kuifunika kwa shaba. ");
INSERT INTO swhulb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kisha akaitia ile miti kwenye zile pete zilizo pande za madhabahu ili kuibeba. Akaifanya kuwa sanduku la mbao lenye uwazi. ");
INSERT INTO swhulb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kisha akafanya beseni ya shaba na kinara chake cha shaba. Kwa kutumia vioo vya watumishi wanawake ambao walifanya utumishi uliopangwa kwenye mwingilio wa hema la mkutano. ");
INSERT INTO swhulb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Naye akafanya ule ua. Upande unaokabili Negebu, kuelekea kusini, mapazia ya ua yalikuwa ya kitani bora kilichosokotwa, kwa mikono mia moja. ");
INSERT INTO swhulb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Nguzo zake ishirini na vikalio vyake ishirini vilikuwa vya shaba. Misumari ya nguzo na viungo vyake vilikuwa vya fedha ");
INSERT INTO swhulb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pia, kwa ajili ya upande wa kaskazini kulikuwa na mikono mia. Nguzo zake ishirini na vikalio vyake ishirini vilikuwa vya shaba. Misumari ya nguzo na viungo vyake vilikuwa vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Lakini kwa ajili ya upande wa magharibi mapazia yalikuwa mikono hamsini. Nguzo zake zilikuwa kumi na vikalio vyake kumi. Misumari ya nguzo na viungo vyake vilikuwa vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Na kwa ajili ya upande wa mashariki kulikuwa na mikono hamsini. ");
INSERT INTO swhulb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mapazia yalikuwa mikono kumi na mitano kwa upande mmoja. Nguzo zake zilikuwa tatu na vikalio vyake vitatu. ");
INSERT INTO swhulb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Na kwa ajili ya upande ule mwingine, huu na ule, wa lango la ua, mapazia yalikuwa mikono kumi na mitano. Nguzo zake zilikuwa tatu na vikalio vyake vitatu. ");
INSERT INTO swhulb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mapazia yote ya ua kuzunguka pande zote yalikuwa ya kitani bora kilichosokotwa. ");
INSERT INTO swhulb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Navyo vikalio vya nguzo vilikuwa vya shaba. Vibanio vya vikalio na viungo vyake vilikuwa vya fedha navyo vilifunikwa kwa shaba sehemu ya juu, na kulikuwa na viungo vya shaba kwa ajili ya nguzo zote za ua. ");
INSERT INTO swhulb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Nacho kisitiri cha lango la ua kilikuwa na mikono ishirini urefu. Cha uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora kilichosokotwa, na urefu wake ulikuwa mikono ishirini, nacho kimo kotekote kilikuwa mikono mitano sawasawa na mapazia ya ua. ");
INSERT INTO swhulb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Na nguzo zake nne na vikalio vyake vinne vilikuwa vya shaba. Misumari yake ilikuwa ya fedha na utando wa vichwa vyake na viungo vyake ulikuwa wa fedha. ");
INSERT INTO swhulb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Na misumari yote ya hema kwa ajili ya maskani na kwa ajili ya ua kuzunguka pande zote ilikuwa ya shaba ");
INSERT INTO swhulb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hivi ndivyo vitu vilivyohesabiwa vya maskani, maskani ya Ushuhuda, vilivyohesabiwa kwa amri ya Musa, kuwa utumishi wa Walawi chini ya uongozi wa Ithamari mwana wa Aruni kuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Naye Bezaleli mwana wa Uri mwana wa Huru wa kabila la Yuda alifanya yote ambayo Yahweh alikuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Na pamoja naye alikuwa Oholiabu mwana wa Ahisamaki wa kabila la Dani, fundi na mtarizi na mfumaji wa uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora. ");
INSERT INTO swhulb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Dhahabu yote iliyotumiwa kwa ajili ya kazi katika kazi yote ya mahali patakatifu ikawa jumla ya dhahabu ya toleo la kutikisa, + talanta ishirini na tisa na shekeli 730 kulingana na shekeli+ ya mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Nayo fedha ya wale walioandikishwa kati ya kusanyiko ilikuwa talanta mia moja na shekeli 1, 775 kulingana na shekeli ya mahali patakatifu, ");
INSERT INTO swhulb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ile nusu shekeli kwa ajili ya mtu mmoja ilikuwa nusu shekeli kulingana na shekeli ya mahali patakatifu,. Kwa kila mtu aliyekuwa akipita kuingia upande wa wale waliokuwa wameandikishwa kuanzia miaka ishirini na zaidi, jumla ya watu 603, 550. ");
INSERT INTO swhulb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Na talanta mia moja za fedha zilitumiwa kutengeneza vikalio vya mahali patakatifu na vikalio vya lile pazia. Vikalio mia moja vilitoshana na talanta mia moja, talanta moja kwa kikalio kimoja. ");
INSERT INTO swhulb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na kutokana na zile shekeli 1, 775 alifanyiza vibanio vya nguzo na kuvifunika sehemu yake ya juu na kuviunganisha pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Nayo shaba ya toleo la kutikisa ilikuwa talanta sabini na shekeli 2, 400. ");
INSERT INTO swhulb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Naye akaitumia kufanya vile vikalio vya mwingilio wa hema la mkutano na ile madhabahu ya shaba na kile kiunzi chake cha shaba, na vyombo vyote vya madhabahu, ");
INSERT INTO swhulb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","na vile vikalio vya ua kuzunguka pande zote, na vile vikalio vya lango la ua, na misumari yote ya maskani na misumari+ yote ya ua kuzunguka pande zote. ");
INSERT INTO swhulb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Na kutokana na ule uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili wakafanya mavazi yaliyofumwa kwa ajili ya kuhudumu katika mahali patakatifu. Basi wakafanya yale mavazi matakatifu yaliyokuwa kwa ajili ya Aruni, kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Basi akaifanya ile naivera ya dhahabu, uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora kilichosokotwa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Kisha wakafua mabamba ya dhahabu yawe mabamba membamba, naye akakata nyuzi za kufuma pamoja na ule uzi wa bluu na ile sufu iliyotiwa rangi ya zambarau na kile kitambaa chenye rangi nyekundu ya kochinili na kile kitani bora, kama kazi ya mjenzi. ");
INSERT INTO swhulb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wakaifanyia vipande vya begani vilivyounganishwa. Iliunganishwa kwenye miisho yake miwili. ");
INSERT INTO swhulb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Nao mshipi, uliokuwa juu yake ili kuifunga, ulikuwa wa kitambaa kilekile kulingana na ufundi wake, wa dhahabu, uzi wa bluu, na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora kilichosokotwa, kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Kisha wakafanya mawe ya shohamu yaliyopangwa kwenye mapambo ya dhahabu, yaliyochongwa kwa michoro ya muhuri kulingana na majina ya wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Bezaleli akayaweka kwenye vile vipande vya begani vya naivera yawe mawe ya ukumbusho kwa ajili ya wana wa Israeli, kama vile Yehova alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kisha akafanya kile kifuko cha kifuani kwa ufundi wa mjenzi, kama ule ufundi wa naivera, kutokana na dhahabu, uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili na kitani bora kilichosokotwa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kilikuwa mraba kilipokunjwa. Walikifanya kile kifuko cha kifuani, kinapokunjwa, shubiri moja urefu wake na shubiri moja upana wake. ");
INSERT INTO swhulb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kisha wakakijaza kwa mistari minne ya mawe. Mstari wa zabarijadi, topazi na zumaridi ulikuwa mstari wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nao mstari wa pili ulikuwa feruzi, yakuti na yaspi. ");
INSERT INTO swhulb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Nao mstari wa tatu ulikuwa jiwe la leshemi, akiki na amethisti. ");
INSERT INTO swhulb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Nao mstari wa nne ulikuwa krisolito na shohamu na yashefi. Yaliwekwa katika mapambo ya dhahabu katika mahali pake. ");
INSERT INTO swhulb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Na mawe hayo yalikuwa kulingana na majina ya wana wa Israeli. Yalikuwa kumi na mawili kulingana na majina yao, kwa michongo ya muhuri, kila moja kulingana na jina lake kwa ajili ya yale makabila kumi na mawili. ");
INSERT INTO swhulb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nao wakafanya juu ya kile kifuko cha kifuani minyororo yenye mashada, msokoto wa kamba, wa dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kisha wakafanya mapambo mawili ya dhahabu na pete mbili za dhahabu na kuziweka hizo pete mbili kwenye ile miisho miwili ya kile kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Baada ya hilo wakapitisha zile kamba mbili za dhahabu kwenye zile pete mbili zilizo kwenye miisho ya kile kifuko cha kifuani. ");
INSERT INTO swhulb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Nao wakapitisha ile miisho miwili ya zile kamba mbili kwenye yale mapambo mawili. Halafu wakaiweka juu ya vile vipande vya begani vya naivera, mbele yake. ");
INSERT INTO swhulb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kisha wakafanya pete mbili za dhahabu na kuziweka kwenye ile miisho miwili ya kile kifuko cha kifuani kwenye upindo wake ulio upande unaoelekea ile efodi upande wa ndani. ");
INSERT INTO swhulb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Halafu wakafanya pete mbili za dhahabu na kuziweka juu ya vile vipande viwili vya begani vya efodi upande wake wa chini, sehemu yake ya mbele, karibu na mahali pake pa kuungania, juu ya ule mshipi wa naivera. ");
INSERT INTO swhulb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Mwishowe wakakifunga kile kifuko cha kifuani kwa pete zake kwenye zile pete za efodi kwa uzi wa bluu, ili kipate kuwa juu ya mshipi wa efodi na kile kifuko cha kifuani kisiondoke juu ya efodi, kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezaleli akafanya lile koti la naivera, lote la uzi wa zambarau, kazi ya mshonaji. ");
INSERT INTO swhulb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Na sehemu wazi ya hilo koti ilikuwa katikati yake, kama sehemu wazi ya vazi la chuma. Sehemu hiyo iliyo wazi ilikuwa na ukingo kuizunguka pande zote ili isiraruke. ");
INSERT INTO swhulb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Halafu wakafanya kwenye upindo wa hilo koti makomamanga ya uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili, vilivyosokotwa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Wakafanya kengele za dhahabu safi na kuziweka kengele hizo katikati ya makomamanga kwenye upindo wa lile koti kuzunguka pande zote, katikati ya makomamanga; ");
INSERT INTO swhulb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","kengele na komamanga, kengele na komamanga kwenye upindo wa hilo koti kuzunguka pande zote, kwa ajili ya kuhudumu, kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kisha wakafanya zile kamba za kitani bora, kwa ajili ya Haruni na wanawe. ");
INSERT INTO swhulb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Na kile kilemba cha kitani bora na yale mavalio ya kichwani ya mapambo ya kitani bora na zile suruali za kitani bora kilichosokotwa, ");
INSERT INTO swhulb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na ule ukumbuu wa kitani bora kilichosokotwa na uzi wa bluu na sufu iliyotiwa rangi ya zambarau na kitambaa chenye rangi nyekundu ya kochinili, kazi ya mfumaji, kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Mwishowe wakafanya lile bamba linalong’aa, ishara takatifu ya wakfu, kutokana na dhahabu safi na kuandika juu yake maandishi kwa mchongo wa muhuri: “Utakatifu kwa Yahweh. ” ");
INSERT INTO swhulb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kisha wakalitia uzi wa bluu ili waliweke juu ya kile kilemba upande wa juu. Kama vile Yahweh alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Basi kazi ya ile maskani ya hema la mkutano ikafikia mwisho wake. Kwa maana wana wa Israeli waliendelea kufanya kulingana na yote ambayo Yahweh alikuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Nao wakaileta maskani kwa Musa, lile hema pamoja na vyombo vyake vyote, kulabu zake, viunzi vyake vya mbao, miti yake na nguzo zake na vikalio vyake, ");
INSERT INTO swhulb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na kifuniko chake cha ngozi za kondoo-dume zilizotiwa rangi nyekundu na kifuniko chake cha ngozi za sili na pazia la kisitiri, ");
INSERT INTO swhulb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na sanduku la ushuhuda na miti yake na kifuniko. ");
INSERT INTO swhulb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Wakaleta meza, vyombo vyake vyote, na ule mkate wa wonyesho, ");
INSERT INTO swhulb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kile kinara cha taa cha dhahabu safi, taa zake, ule mstari wa taa, na vyombo vyake vyote na yale mafuta ya kuangazia taa, ");
INSERT INTO swhulb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na madhabahu ya dhahabu na yale mafuta yanayotumiwa kutia mafuta na ule uvumba uliotiwa manukato na kile kisitiri kwa ajili ya mwingilio wa hema, ");
INSERT INTO swhulb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ile madhabahu ya shaba na kile kiunzi chake cha shaba, miti yake na vyombo vyake vyote, ile beseni na kinara chake, ");
INSERT INTO swhulb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Wakaleta mapazia ya ua, nguzo zake na vikalio vyake na kile kisitiri+ kwa ajili ya lango la ua, kamba zake za hema na misumari yake ya hema na vyombo vyote kwa ajili ya utumishi wa maskani, kwa ajili ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Wakaleta yale mavazi yaliyofumwa kwa ajili ya kuhudumu katika patakatifu, yale mavazi matakatifu kwa ajili ya Aruni kuhani na mavazi ya wanawe ya kutumikia wakiwa makuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Kulingana na yote ambayo Yahweh alikuwa amemwamuru Musa, hivyo ndivyo wana wa Israeli walivyoufanya utumishi wote. ");
INSERT INTO swhulb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Naye Musa akaiona ile kazi yote, na, tazama, walikuwa wameifanya kama vile Yahweh alivyokuwa ameamuru. Hivyo ndivyo walivyokuwa wamefanya. Basi Musa akawabariki. ");
INSERT INTO swhulb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kisha Yahweh akasema na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Siku ya kwanza ya mwezi wa kwanza ya mwaka lazima wewe uandae hema la kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Utaweka sanduku la ushuhuda ndani yake, na utaziba sanduku kwa pazia. ");
INSERT INTO swhulb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Utaleta ndani meza na kuandaa kwa mpangilio vitu vyake. Kisha utaleta kinara cha taa na kuandaa taa. ");
INSERT INTO swhulb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Nawe utaweka madhabahu ya dhahabu ya uvumba mbele ya sanduku la ushuhuda, na utaweka pazia katika mwingilio wa hema la kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Utaweka madhabahu kwa ajili ya sadaka ya kuteketezwa mbele ya mwingilio wa hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Utaweka ile saani kubwa katikati ya hema la kukutania na madhabahu na utaweka maji ndani yake. ");
INSERT INTO swhulb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Uandae nyuani inayoizunguka, na utundike pazia katika mwingilio wa nyuani. ");
INSERT INTO swhulb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Lazima uchukuwe mafuta ya upako na upake hema la kukutania na kila kitu kilichopo ndani yake. Lazima uitenge na samani zake kwangu; kisha itakuwa takatifu. ");
INSERT INTO swhulb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Lazima upake mafuta madhabahu ya sadaka ya kuteketezwa na vyombo vyake. Lazima utenge madhabhu kwa ajili yangu na itakuwa takatifu kwangu. ");
INSERT INTO swhulb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Upake mafuta beseni la shaba na sakafu yake na uitenge kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Umlete Aruni na wanae kwa mwingilio wa hema la kukutania na uwaoshe wote kwa maji. ");
INSERT INTO swhulb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Utamfunika Aruni kwa mavazi yaliyo tengwa kwa ajili yangu, mpake mafuta na umtenge ili anitumikie kama kuhani. ");
INSERT INTO swhulb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Utawaleta wana wake na kuwafunika kwa nguo nzito. ");
INSERT INTO swhulb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Utawapaka mafuta kama ulivyo mpaka baba yao ili wanitumikie kama makuhani. Upako wao utawafanya makuhani wa kudumu vizazi vyote vya watu wao.” ");
INSERT INTO swhulb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Hivi ndivyo Musa alivyo sema; alifuata yote Yahweh aliyo muamuru. Alifanya vitu vyote hivi. ");
INSERT INTO swhulb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hivyo hema la kukutania liliandaliwa siku ya kwanza ya mwezi wa mwaka wa pili. ");
INSERT INTO swhulb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa alianda hema la kukutania, akaeka sakafu zake sehemu yake, akaanda fremu zake, akashikisha chuma zake, na akaanda minara na nguzo zake. ");
INSERT INTO swhulb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Alitandaza mfuniko juu ya hema la kukutania na kuweka hema juu yake, kama Yahweh alivyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Alichukuwa amri za agano na kuweka kwenye sanduku. Pia aliweka nguzo kwenye sanduku na kuweka mfuniko wa kiti cha rehema. ");
INSERT INTO swhulb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Aliichukuwa sanduku na kuweka ndani ya hema la kukutania. Aliandaa pazia ili lizibe sanduku la ushuhuda, kama Yahweh alivyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Alieka meza kwenye hema la kukutania, kwa upande wa kaskazini mwa hema la kukutania, nje ya pazia. ");
INSERT INTO swhulb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Alieka mkate kwa mpangilio katika meza ya Yahweh, kama Yahweh alivyo amuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Alieka kinara cha taa kwenye hema la kukutania, upande wa pili wa meza, kusini mwa hema la kukutani. ");
INSERT INTO swhulb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Aliwasha taa mbele za Yahweh, kama Yahweh alivyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Aliweka madhabahu ya dhahabu ya uvumba ndani ya hema la kukutania mbele ya pazia. ");
INSERT INTO swhulb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Alichoma uvumba wa manukato hapo, kama Yahweh alivyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Alitundika pazia katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Aliweka madhabahu ya sadaka ya kuteketeza katika hema ya kukutania. Aliitolea sadaka ya kuteketeza na sadaka ya unga, kama Yahweh alivyo muamuru. ");
INSERT INTO swhulb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Aliweka beseni katikati ya hema ya kukutunia na madhabahu, na maji ya kuoshea. ");
INSERT INTO swhulb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, Aruni, na wanae waliosha mikono yao na miguu kwenye beseni ");
INSERT INTO swhulb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","muda wowote walipoenda kwenye hema ya kukutania na muda wowote walipoenda kwenye madhabahu. Walijisafisha, kama Yahweh alivyo muamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Musa alianda nyuani nyuma ya hema ya kukutania na madhabahu. Alianda pazia katika mwingilio wa nyuani. Katika hili, Musa alimaliza kazi. ");
INSERT INTO swhulb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kisha wingu likafunika hema ya kukutania, na utukufu wa Yahweh ukafunika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa hakuweza kuingia hema ya kukutania kwasababu wingu lilikuwa juu yake, na kwasababu utukufu wa Yahweh ulijaza hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Muda wowote wingu lilipo chukuliwa juu kutoka hema ya kukutania, watu wa Israeli waliendelea na safari yao. ");
INSERT INTO swhulb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Lakini kama wingu haliku nyanyuka juu kutoka hema ya kukutania, kisha basi watu hawaku safiri. Walibaki hadi siku lilipo nyanyuliwa juu. ");
INSERT INTO swhulb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kwa kuwa wingu la Yahweh lilikuwa juu ya hema ya kukutania mchana, na moto wake ulikuwa juu yake usiku, wazi kwa watu wote wa Israeli kipindi chote cha safari yao. ");
INSERT INTO swhulb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mungu alimwita Musa na alisema naye kutoka kweye hema la kukutania, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Sema na wana wa Israeli na uwaambie, 'Mwanaume yeyote miongoni mwenu akileta sadaka kwa Bwana, aleta kama matoleo katika wanyama wako, iwapo mifugo au katika kundi.” ");
INSERT INTO swhulb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kama matoleo yake ni ya sadaka ya kutekezwa kutoka katika kundi, atatoa dume asiyekuwa na kasoro. Atamtoa katika mlango wa kuingilia katika hema ya kukutania, ili iwe imekubaliwa mbele za Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ataweka mikono yake kichwani pa sadaka ya kuteketezwa, na ndipo itakuwa imekubaliwa badala yake kufanya upatanisho kwa ajili yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ndipo atapaswa kuchinja ng'ombe mbele ya Bwana. Watoto wa Aroni, makuhani wataleta damu na kuinyunyizia katika madhabahu iliyo katika mlango wa kuingilia katika hema la kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ndipo ataichuna sadaka ya kuteketezwa na kuikata vipande. ");
INSERT INTO swhulb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kisha wana wa Haruni kuhani wataweka moto katika madhabahu na kuweka kuni ili kuchochea moto. ");
INSERT INTO swhulb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Wana wa Haruni, makuhani wataweka vipande, kichwa na mafuta, watazipanga juu ya kuni zilizoko juu ya moto ulio madhabahuni. ");
INSERT INTO swhulb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lakini matumbo yake na miguu lazima ataiosha kwa maji. Kisha kuhani atateketeza kila kitu kilicho juu ya madhabahu kama sadaka ya kuteketeza. Italeta harufu nzuri sana kwangu; itakuwa sadaka iliyotolewa kwa moto kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kama sadaka kwa ajili ya sadaka ya kuteketeza kutoka kundi, kondoo au mbuzi, lazima atoe dume asiye na kasoro. ");
INSERT INTO swhulb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Lazima atamchinja juu ya madhabahu iliyo katika upande wa kaskazini mbele ya Bwana. Wana wa Haruni makuhani, watanyunyiza damu kila upande wa madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kisha ataikata katika vipande, pamoja na kichwa na mafuta yake, kuhani atavipanga juu ya kuni zilizo katika moto ulio madhabahuni, ");
INSERT INTO swhulb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","lakini matumbo yake na miguu yake lazima ioshwe kwa maji. Kisha kuhani atatoa yote na kuiteketeza juu ya madhabahu. Ni sadaka ya kuteketezwa, italeta harufu nzuri kwa ajili ya Bwana; itakuwa sadaka ya Bwana iliyotolewa kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kama sadaka yake kwa Bwana itakuwa ni sadaka ya kuteketezwa ni ndege, ndipo ataleta kama sadaka yake aidha ni huwa au kinda la njiwa. ");
INSERT INTO swhulb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kuhani ataileta madhabahuni, atamnyonga kichwa chake, na kuiteketeza juu ya madhabahu. Kisha damu yake itachuruzishwa juu ya pande za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kisha atakiondoa kibofu chake pamoja na uchafu wake, na kukiweka upande wa mashariki mwa madhabahu, katika sehemu ya majivu. ");
INSERT INTO swhulb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kisha atapasua mabawa yake, lakini hatagawanya katika vipande viwili. Kisha Kuhani atamtekeza katika madhabahu, juu ya kuni amabazo ziko juu ya moto. Itakuwa sadaka ya kuteketezwa, na italeta harufu nzuri sana kwa Bwana; itakuwa sadaka ya Bwana iliyotolewa kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Yeyote akitoa sadaka ya nafaka kwa Bwana, sadaka yake lazima iwe unga safi, na atamwaga mafuta juu yake na kuweka ubani juu yake. ");
INSERT INTO swhulb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Atachukua sadaka kwa wana wa Haruni, makuhani na pale kuhani atachukua konzi moja ya unga safi pamoja na mafuta na ubani. Kisha kuhani atateketeza hiyo sadaka juu ya madhabahu kuwa shukrani kwa uzuri wa Bwana. Italeta harufu nzuri sana kwa Bwana, itakuwa sadaka ya Bwana iliyotolewa kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Unga wowote uliobaki utakuwa ni wa Haruni na watoto wake. Ni takatifu sana kwa Bwana iliyotolewa sadaka kwa Bwana kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kisha utakapotoa sadaka ya unga bila chachu iliyookwa kweye kiokeo, itakuwa mkate lainiya unga safi uliochanganywa na mafuta, au mkate mgumu usiokuwa na chachu, ambao umesambazwa na mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kama matoleo yako ya nafaka yameokwa na kikaango cha chuma ni lazima iwe unga safi bila chachu uliochanganywa na mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Utagawanya katika vipande na kumwaga mafuta juu yake. Hii ni sadaka ya nafaka. ");
INSERT INTO swhulb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kama sadaka yako ya nafaka imepikwa katika kikaango, ni lazima iwe imetengenezwa kwa unga safi na mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Utaleta matoleo ya nafaka yaliyotengenezwa kwa vitu hivi kwa Bwana, italeta kwa kuhani, ambaye ataleta mbele ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ndipo kuhani atachukua baadhi ya sadaka ya nafaka ya shukrani ya Bwana, ataitekeza katika madhabahu. Itakuwa sadaka ya kuteketezwa kwa moto, italeta harufu nzuri kwa Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Itakayobaki sadaka ya nafaka itakuwa ya Haruni na wanawe. Itakuwa takatifu kamili ya Bwana kutoka matoleo kwa Bwana yatolewayo kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Sadaka ya nafaka itolewayo kwa Bwana isiwe na chachu, hautatekeza chachu wala asali kama matoleo yatakayotekezwa kwa moto kwa ajili ya Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Utayatoa kwa Bwana kama mazao ya kwanza, lakini hayatatumika kama matoleo ya harufu nzuri ya moto juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Utaweka chumvi katika kila matoleo yako ya nafaka. Usipungukie chumvi ya agano la Bwana katika matoleo yako ya unga. Matoleo yako yote hayatapungukiwa na chumvi. ");
INSERT INTO swhulb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kama ukitoa matoleo ya nafaka ya mazao ya kwanza kwa Bwana, utatoa nafaka mbichi yaliyookwa kwa moto, na yaliyopondwa. ");
INSERT INTO swhulb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Lazima utaweka mafuta na ubani juu yake. Haya ni matoleo ya nafaka. ");
INSERT INTO swhulb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kuhani atatoa sehemu ya nafaka iliyopondwa na mafuta na ubani, kama sadaka ya shukrani itolewayo kwa uzuri wa Bwana. Hii ni sadaka ya Bwana inayotolewa kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kama mtu atoa dhabihu ambayo ni matoleo ya amani ya mnyama kutoka katika kundi, dume au jike, lazima atatoa mnyama asiyena kasoro mbele ya Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ataweka mikono yake juu ya sadaka yake na atamchinja mbele ya mlango wa hema ya kukutania. Kisha wana wa Haruni makuhani watanyunyizia damu yake katika pande za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Mtu akitoa dhabihu ya amani itolewayo kwa moto kwa ajili ya Bwana. Mafuta yanayofunika au yanayoungana na hizo sehemu za ndani, ");
INSERT INTO swhulb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","figo mbili na mafuta yaliyofunika kiunoni na yanayozunguka ini, pamoja na figo atayatoa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Wana wa Haruni watayachoma hayo katika madhabahu pamoja na sadaka ya kutekezwa, juu ya kuni zilizo kwenye moto. Zitaleta harufu nzuri mbele ya Bwana; itakuwa sadaka ya itolewayo kwake kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kama dhabihu ya amani ya mtu itolewayo kwa Bwana ni kutoka katika mifugo ni mbuzi au kondoo ni dume au jike, atatoa dhabihu isiyo na kasoro. ");
INSERT INTO swhulb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kama atatoa mwanakondoo kwa ajili ya dhabihu yake, atamtoa mbele za Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ataweka mkono wake juu ya ya kichwa cha dhabihu yake na atamchinja mbele ya hema ya kukutania. Ndipo wana wa Haruni watanyunyizia damu pande za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Mtu akitoa sadaka ya dhabihu ya amani kama sadaka ya kusogezwa kwa moto kwa Bwana. Mafuta, mafuta ya mkia yatakatwa hapo karibu na mfupa wa kiuno, na mafuta yanayofunika matumbo na mafuta yaliyo katika matumbo, ");
INSERT INTO swhulb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","na figo zote mbili na mafuta yanayofunika yaliyo karibu na kiuno kitambi kilicho karibu na ini na figo ataziondoa zote. ");
INSERT INTO swhulb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Na kuhani atayatekeza yote kwa moto katika madhabahu kama sadaka ya chakula isogezwayo kwa moto kwa Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kama matoleo ya mtu ni mbuzi, ndipo ataitoa mbele ya Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ataweka mikono yake juu ya kichwa cha mbuzi na atamchinja mbele ya hema ya kukutania. Ndipo wana wa Haruni watanyunyizia damu pande zote za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mtu akitoa dhabihu kwa Bwana kwa njia ya moto. Ataondoa mafuta yanayozunguka matumbo, na mafuta yote yanayozunguka matumbo. ");
INSERT INTO swhulb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Ataondoa pia figo mbili na mafuta yanayozunguka, ambayo yanazunguka kiuno na kitambi cha maini pamoja na figo. ");
INSERT INTO swhulb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kuhani atateketeza yote juu ya madhabahu kama matoleo ya chakula yatolewayo kwa moto, ni sadaka ya kuleta harufu nzuri sana. Mafuta yote ni ya Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Itakuwa ni amri ya kudumu kwa kizazi cha watu katika maeneo yote mtakapotengeneza makazi, kwamba hamtakula mafuta au damu.”' ");
INSERT INTO swhulb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Bwana alisema na Musa na kumwambi, ");
INSERT INTO swhulb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Waambie wana wa Israeli 'mtu yeyote akifanya dhambi bila kukusudia, kufanya chochote ambacho Bwana ameagiza kutofanya, na kama akifanya chochote kilichozuiliwa, yafuatayo lazima yatatendeka. ");
INSERT INTO swhulb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kama ni kuhani mkuu aliyetenda dhambi na kuleta hatia kwa watu, atatoa dume asiyekuwa na kasoro kwa Bwana kwa ajili ya dhambi aliyotenda kama sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ataleta dume mbele ya mlango wa hema ya kukutania mbele ya Bwana, ataweka mikono juu ya dume, na atamchinja huyo dume mbele za Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kuhani aliyewekewa mafuta atachukua damu ya dume na kuileta mbele ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kuhani atazamisha kidole chake katika damu na kuinyunyiza mara saba mbele za Bwana, mbele ya pazia la mahali pa takatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Na kuhani ataweka kiasi cha damu ya huyo dume juu ya pembe za madhabahu ya kuvukizia uvumba mbele za Bwana, katika hema ya kukutania na ataimwaga yote iliyobaki chini ya madhabahu ya sadaka ya kuteketezwa, iliyo mahali pa kuinglia katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Atakata mafuta yote ya dume wa sadaka ya dhambi, mafuta yanayofunika matumbo na mafuta yote yaliyo katika matumbo, ");
INSERT INTO swhulb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","figo mbili na mafuta yaliyopo pamoja nazo, yaliyo karibu na kiuno na kitambi cha maini pamoja na hizo figo. ");
INSERT INTO swhulb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ataondoa zote vile vile kama yanavyoondolewa katika dume wa sadaka ya dhabihu ya amani. Kuhani atatekeza sehemu hizo katika madhabahu ya sadaka za kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ngozi ya dume na mabaki yoyote ya nyama, pamoja na kichwa chake, miguu yake, matumbo yake na mavi yake, ");
INSERT INTO swhulb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mabaki yote ya dume atayachukua nje ya mji mahali palipo safi, mahali wanapomwaga majivu; watateketeza sehemu zote juu ya kuni. Watateketeza sehemu zote mahali wanapomwaga majivu. ");
INSERT INTO swhulb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kama mkutano wote wa wana wa Israeli wakitenda dhambi bila kukusudia, na mkutano hawatakumbuka kwamba wametenda dhambi, na kufanya vile Bwana aliagiza wasifanye na wakajisikia hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Na dhambi waliyofanya ikajulikana, mkutano watatoa ng'ombe dume mchanga kuwa sadaka ya dhambi watamleta mbele ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Wazee wa mkutano wataweka mikono yao juu ya kichwa cha ng'ombe mbele za Bwana, na ng'ombe atachinjwa mbele za Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kuhani aliyetiwa mafuta ataleta damu ya ng'ombe katika hema ya kukutania, ");
INSERT INTO swhulb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","kuhani atachovya kidole chake katika damu na kuinyunyizia mara saba mbele za Bwana mbele ya pazia. ");
INSERT INTO swhulb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ataweka kiasi cha damu katika pembe za madhabahu mbele za Bwana iliyo katika hema ya kukutania na ataimwaga damu yote chini ya madhabahu ya sadaka ya kuteketezwa, iliyo katika mlango wa kuingilia katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Atakata mafuta yote na kuyatekeza katika madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Hivyo ndivyo atakavyomfanya huyo ng'ombe, kama alivyomfanya ng'ombe wa sadaka ya dhambi, atamfanyia vivyo hivyo huyu ng'ombe, kuhani atawafanyia upatanisho watu nao watasamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Atamchukua huyo ng'ombe nje ya mji na kumteketeza kama alivyomteketeza ng, ombe wa kwanza. Hii ni sadaka ya dhambi kwa ajili ya mkutano. ");
INSERT INTO swhulb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Mtawala akitenda dhambi bila kukusudia kufanya moja ya yale Bwana Mungu wake ameagiza kutotenda, na anajisikia hatia ");
INSERT INTO swhulb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","na kama dhambi yake aliyotenda anaifahamu, ataleta dhabihu yake mbuzi mme asiye na kasoro. ");
INSERT INTO swhulb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ataweka mkono wake juu ya kichwa cha mbuzi na kumchinja mahali ambapo huchinja sadaka ya kuteketezwa mbele za Bwana. Hii ni sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kuhani atachukua damu ya sadaka ya dhambi kwa kidole chake na kuiweka juu ya pembe za madhabahu kwa dhabihu ya kuteketezwa, na atamwaga damu chini ya madhabahu ya dhabihu ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Atateketeza mafuta yote katika madhabahu, kama vile mafuta ya dhabihu ya sadaka ya amani, Kuhani atafanya upatanisho kwa ajili ya mtawala kulingana na dhambi yake, na mtawala atakuwa amesamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kama yeyote wa watu wa kawaida akitenda dhambi bila kukusudia, kufanya vitu ambavyo Bwana ameagiza kutokufanywa na kama ana hatia, ");
INSERT INTO swhulb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ndipo dhambi yake aliyoitenda ikajulikana kwake, ndipo ataleta mbuzi mke asiyekuwa na kasoro awe dhabihu kwa ajili ya dhambi zake alizotenda. ");
INSERT INTO swhulb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ataweka mikono yake juu ya sadaka ya dhambi na kuchinja sadaka ya dhambi mahali pa sadaka ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kuhani atachukua kiasi cha damu kwa kidole chake na kuweka katika pembe za madhabahu ya dhabihu ya kuteketezwa. Damu yote iliyobaki ataimwaga chini ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Atayaondoa mafuta yote, kama alivyoondoa mafuta katika dhabihu ya amani. Kuhani ataiteketeza katika madhabahu ili kuwa harufu nzuri kwa Bwana. Kuhani atafanya upatanisho kwa mtu, na atasamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kama mtu ataleta mwanakondoo kama dhabihu yake kwa sadaka ya dhambi, ataleta jike asiye na kasoro. ");
INSERT INTO swhulb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ataweka mikono kichwani mwa sadaka ya dhambi na atamchinja kuwa sadaka ya dhambi mahali wanapochinjwa sadaka ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kuhani atachukua baadhi ya damu ya sadaka ya dhambi kwa kidole chake na kuweka katika pembe za madhabahu kwa ajili ya sadaka za kuteketezwa, na ataimwaga damu yote chini ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ataondoa mafuta yote, kama akatavyo mafuta ya mwanakondoo dhabihu ya sadaka ya amani na kuhani ataiteketeza juu ya madhabahu juu ya sadaka ya Bwana itolewayo kwa moto. Kuhani ataleta upatanisho kwa dhambi aliyoifanya, naye atasamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kama mtu atatenda dhambi kwa sababu hakusema ukweli wakati alipotakiwa kutoa ushahidi fulani kuhusu kile alichotakiwa, ameona au kufahamu habari zake, yeye anastahili adhabu. ");
INSERT INTO swhulb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Au mtu akigusa kitu chochote ambacho Mungu amekitaja kuwa ni najisi hata kama ni mzoga wa wanyama wa porini au ni mzoga wa wanyama wa kufugwa au wataambaao hata kama mtu huyo hakukusudia kumgusa, yeye ni najisi na mwenye hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Au amegusa kitu chochote kilicho kichafu, kwa vyovyote kama hakujua, ndipo atakuwa na hatia akijua vile. ");
INSERT INTO swhulb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Au kama yeyote akiapa bila kufikiri kwa midomo yake kufanya ubaya, au kufanya vyema kwa vyovyote vile mtu ameapa kwa haraka atakapotambua atakuwa na hatia kwa vitu hivyo. ");
INSERT INTO swhulb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Mtu yeyote akiwa na hatia kwa vitu hivi, lazima akiri kwa yoyote dhambi aliyotenda. ");
INSERT INTO swhulb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ndipo atakapoleta sadaka yake ya hatia mbele za Bwana kwa dhambi aliyokwisha tenda. Ataleta kondoo jike au mbuzi kutoka katika kundi lake kuwa matoleo ya dhambi, kuhani atafanya upatanisho kuhusu dhambi yake. ");
INSERT INTO swhulb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kama hataweza kununua mwana kondoo ataleta kama sadaka ya hatia, hua wawili au makinda mawili ya njiwa kwa Bwana, mmoja kwa sadaka ya dhambi na mwingine ni sadaka ya kutekeketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Atawaleta kwa kuhani, wa kwanza atatoa kwa ajili ya sadaka ya dhambi. Atamvunja shingo yake lakini ataacha kichwa chake kinaning'inia wala hataiondoa kabisa shingo yake katika mwili. ");
INSERT INTO swhulb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ndipo atanyunyizia damu yake katika sehemu za madhabahu, na damu inayobaki ataimwaga chini ya madhabahu. Hii ni dhabihu ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ndipo ataoa ndege wa pili kama sadaka ya kuteketezwa kama ilivyoelekezwa, na kuhani atafanya upatanisho kwa ajili ya dhambi alizokwisha kufanya, na huyo mtu atakuwa amesamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Lakini kama hataweza kununua hua wawili au makinda ya njiwa mawili, ndipo ataleta kama dhabihu ya dhambi zake sehemu ya kumi ya unga laini kama sadaka ya dhambi. Asiweke mafuta wala ubani juu yake, kwa kuwa ni sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Atauleta kwa kuhani, na kuhani atachukua konzi moja ya unga kama ukumbusho wa wema wa Bwana na atauweka juu ya madhabahu na kuteketeza juu ya sadaka za kuteketezwa kwa moto kwa ajili ya Bwana. Hii ni sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kuhani atafanya upatanisho kwa dhambi yoyote aliyofanya mtu yeyote, mtu huyo atasamehewa. Na sadaka inayobaki itakuwa ya kuhani, kama ilivyo sadaka ya nafaka.'” ");
INSERT INTO swhulb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Bwana akamwambia Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kama mtu akikiuka amri na kufanya dhambi kinyume na mambo matakatifu ya Bwana, lakini akifanya bila kukusudia ataleta sadaka ya hatia kwa Bwana. Sadaka hii itakuwa ni kondoo dume asiye na kasoro kutoka katika kundi; thamani yake halisi kifedha kulingana na shekeli ya mahali patakatifu, kama sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Lazima atalipa kwa Bwana kwa kile alichokosa kulingana na kitakatifu, na ataongezea moja ya tano na kumpa kuhani. Ndipo kuhani ataweka upatanisho kwa ajili yake pamoja na kondoo wa sadaka ya hatia, na mtu atakuwa amesamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kama mtu akitenda dhambi kwa kufanya kile ambacho Bwana aliagiza kisifanyike, hata kama hakujuwa, atakuwa na hatia na ataibeba hatia yake. ");
INSERT INTO swhulb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Lazima ataleta kondoo dume asiye na kasoro kutoka katika kundi, anayestahili thamani ya fedha, kama sadaka ya hatia kwa kuhani. Ndipo kuhani atafanya upatanisho kulingana na dhambi aliyotenda, ambayo hakujua atakuwa amesamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ni sadaka ya hatia, na amekuwa na hatia mbele za Bwana.” ");
INSERT INTO swhulb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Bwana alisema na Musa kumwabia, ");
INSERT INTO swhulb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kama mtu akifanya dhambi na kuvunja amri kinyume na Bwana, kama kujihusisha na uongo dhidi ya jirani yake kuhusu kitu fulani cha kutokuwa mwaminifu, au kama akidanganya au kuiba au amemdhurumu jirani. ");
INSERT INTO swhulb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Au akiokota kitu fulani ambacho jirani yake amepoteza na kusema uongo kuhusu hicho, na kuapa kwa uongo au kwa mambo kama haya ambayo watu wanaweza kutenda dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Ndipo itakuwa hivi, kama ametenda dhambi na hatia, kwamba lazima akirudishe kwa vyovyote alichoiba au kudanganya au amedhurumu au kitu kilichopotea naye kukiokota. ");
INSERT INTO swhulb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Au kama amedanganya kwa jambo lolote, lazima atakirudisha kamilina kuongezea sehemu ya tano kwa kumlipa anayedai, kwa siku ile anayopatikana na hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ataleta sadka ya hatia kwa Bwana: kondoo dume asiye na kasoro kutoka katika kundi lake kulingana na thamani yake, kama sadaka ya hatia kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kuhani atafanya upatanisho kwa ajili yake mbele ya Bwana, atakuwa amesamehewa kulingana na chochote kilicho mfanya kuwa na hatia.” ");
INSERT INTO swhulb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ndipo Bwana alisema na Musa kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mwagize Haruni na wanawe, kusema, 'hii ni sheria ya sadaka ya kuteketezwa: Sadaka ya kuteketezwa lazima iwe juu ya makaa ya madhabahu usiku wote hata asubuhi, na moto wa madhabahu utaendelea kuwaka. ");
INSERT INTO swhulb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kuhani atavaa nguo zake za kitani na atavaa nguo za kitani ndani yake. Atatoa majivu yaliyobaki baada ya moto kutekeza sadaka ya kuteketezwa juu ya madhabahu, na ataweka majivu pembeni mwa madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Atavua mavazi haya na kuvaa mavazi mengine ili kuchukua majivu nje ya kambi na kupeleka mahali palipo safi. ");
INSERT INTO swhulb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto katika madhabahu utaendelea kuwaka. Usizimike, na kuhani ataongeza kuni kila asubuhi. Atapanga juu yake sadaka ya kuteketezwa kama inavyotakiwa, na atateketeza juu yake mafuta ya sadaka ya amani. ");
INSERT INTO swhulb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto lazima utaendelea kuwaka katika madhabahu, kamwe usizimike. ");
INSERT INTO swhulb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hii ni sheria ya sadaka ya nafaka. Wana wa Haruni watatoa mbele ya Bwana katika madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kuhani atachukua konzi ya unga laini wa sadaka ya nafaka na mafuta na ubani ambao uko juu ya sadaka ya nafaka, atateketeza juu ya madhabahu kuleta harufu nzuri ya shukrani ya kumpendeza Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruni na wanae watakula sadaka inayobaki, italiwa bila kutiwa chachu mahali patakatifu. Watakula katika ua ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Haitaokwa pamoja na chachu. Nimewapa kama sehemu ya sadaka yangu itolewayo kwa moto, ni takatifu sana, kama sadaka ya dhambi na sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Kwa nyakati zote zijazo kupitia watu wa kizazi chako, mwanaume yeyote mzaliwa kutoka kwa Haruni aweza kula ni sehemu yake, ichukuliwayo katika sadaka ya Bwana kwa moto. Yeyote anayeigusa atakuwa mtakatifu.” ");
INSERT INTO swhulb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Bwana aliongea tena na Musa kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Hii ni sadaka ya Haruni na wanawe ambayo watatoa kwa Bwana katika siku ambayo kila mwana atawekwa wakfu: sehemu ya kumi ya efa ya unga laini kama kawaida sadaka ya nafaka nusu yake asubuhi na nusu yake jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Itatengenezwa na mafuta katika kikaango, utaileta ikiwa imeandaliwa imeokwa katika vipande utatoa sadaka ya nafaka ili kuleta harufu nzuri kwa Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mwana wa Kuhani Mkuu atakayekuwa Kuhani Mkuu mpya kutoka miongoni mwa wanawe ataitoa. Kama amri ya milele, yote itateketezwa kwa Bwana. ");
INSERT INTO swhulb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kila sadaka ya nafaka ya kuhani itatekezwa yote. Haitaliwa kamwe.” ");
INSERT INTO swhulb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Bwana alisema tena Musa, kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Sema na Haruni na watoto wake kwamba, 'Hii ni sheria ya sadaka ya dhambi: Sadaka ya dhambi lazima kuchinjwa mahali pa sadaka ya kuteketezwa itachinjwa mbeleya Bwana. Ni takatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kuhani atakayeitoa kwa ajili ya dhambi ndiye atakayeila. Italiwa mahali patakatifu katika ua wa hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Yeyote atakayeigusa nyama yake atakuwa ni mtakatifu na kama damu itadondokea mavazi yatafuliwa mahali palipodondokewa, mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Lakini chungu kikipikiwa kitavunjwa, kama imepikiwa katika chombo cha shaba, lazima kitasuguliwa na kusafishwa kwa maji. ");
INSERT INTO swhulb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mwanaume yeyote miongoni mwa makuhani anaweza kula nyama hiyo kwa sababu ni takatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Na hakuna sadaka ya dhambi italiwa ambayo damu yake imeletwa katika hema ya kukutania kufanya upatanisho katika mahali patakatifu. Ni lazima iteketezwe. ");
INSERT INTO swhulb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Hii ndiyo sheria ya sadaka ya hatia. Kwa sababu hiyo ni sadaka takatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ni lazima waichinje sadaka ya hatia mahali panapostali kuchinjwa, na ni lazima watainyunyiza damu yake pande zote za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mafuta yote yaliyomo ndani yake yataondolewa: mafuta ya mkiani, mafuta yaliyo sehamu za ndani, ");
INSERT INTO swhulb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","zile figo mbili pamoja na mafuta yaliyo juu yake, yaliyo karibu na kiuno, na yanayofunika ini—nyama hii yote lazima iondolewe pamoja na hizo figo. ");
INSERT INTO swhulb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kuhani ataviteketeza vipande hivi juu ya madhabahu viwe dhabihu iliyofanywa kwa Yahweh kwa moto. Hii ni sadaka ya hatia ");
INSERT INTO swhulb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kila mwanaume miongoni mwa familia ya kuhani anaweza kula sehemu ya sadaka hii. Lakini ni lazima iliwe ndani ya mahali patakatifu kwa sababu ni takatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Nayo sadaka ya dhambi ni kama ilivyo sadaka ya hatia. Ni sheria ileile hutumika kwa zote mbili. Zote ni mali ya kuhani azitumiaye kufanya upatanisho. ");
INSERT INTO swhulb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kuhani atoaye sadaka ya kuteketezwa kwa ajili ya mtu yeyote anaweza kuchuku ngozi ya sadaka hiyo kwa ajili yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kila sadaka ya nafaka inayookwa mekoni, na kila sadaka kama hiyo ipikwayo kaangoni au kwenye sufuria itakuwa ya kuhani aitoaye. ");
INSERT INTO swhulb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kila sadaka ya nafaka, ama iwe unga mkavu au uliochanganywa na mafuta ya zeitu itakuwa ya ukoo wa Aroni kwa usawa. ");
INSERT INTO swhulb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Hii ndiyo sheria ya dhabihu ya sadaka za amani, ambazo watu watazitoa kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Iwapo mtu yeyote anaitoa ili kuonyesha shukrani kwa Yahweh, basi ataitoa pamoja na dhabih uya mikate iliyotengenezwa bila hamira, bali kwa mafuta ya zeituni yaliyochanganywa na unga lakini bila hamira, na maandazi yaliyotengenezwa bila hamira, bali yaliyopakwa mafuta juu yake, na mikate miembamba iliyofanywa kwa unga laini uliochanganywa na mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kwa kusudi la kutoa shukrani, pia anapaswa kutoa pamoja na sadaka yake ya amani, vipande vya mikate iliyotiwa hamira. ");
INSERT INTO swhulb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ni lazima atatoa moja kila aina ya sadaka hizi kama sadaka iliyoletwa kwa Yahweh. Nayo itakuwa ya makuhani wanaonyunyizia damu ya sadaka ya amani kwenye madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Mtu anayeleta sadaka ya amani kwa kusudi la kutoa shukrani ni lazima ataila nyama ya sadaka yake siku ya kutoa dhabihu. Hatakiwi kusaza chochote kilicho cha sadaka hiyo hata asubuhi ya pili. ");
INSERT INTO swhulb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Lakini iwapo dhabihu ya matoleo yake kusudi lake ni nadhiri, au kwa kusudi la sadaka ya hiari, nyama yake italiwa siku iyo hiyo aitoapo dhabihu yake, lakini chochote kinachosalia cha sadaka hiyo kinaweza kuliwa siku inayofuata. ");
INSERT INTO swhulb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Hata hivyo, nyama yoyote ya dhabihu inayobaki siku ya tatu ni lazima ichomwe moto. ");
INSERT INTO swhulb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Iwapo kipande chochote cha nyama hiyo ya dhabihu kinachobaki kinaliwa katika siku ya tatu, hakitakubalika, wala hakitatolewa kwa aliyeitoa. Kitakuwa ni kitu cha kuchukiza, na mtu akilaye atabeba hatia ya dhambi mwenyewe yake. ");
INSERT INTO swhulb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Nyama yoyote inayogusa kitu kilicho najisi haitaliwa. Ni lazima ichomwe moto. Na kwa ajili ya nyama inayobaki, yeyote aliye safi anaweza kuila. ");
INSERT INTO swhulb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Hata hivyo, mtu najisi anayekula nyama kutoka kwenye dhabihu ya matoleo ya amani ambayo ni ya Yahweh yapasa mtu huyu akatiliwe mbali kutoka kwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Iwapo mtu yeyote anagusa kitu chochote kilichonajisi—iwe ni unajisi wa binadamu, au wa mnyama aliyenajisi, au wa kitu fulani kilichonajisi na chenye kuchukiza, na kisha akala baadhi ya nyama ya dhabihu ya sadaka ya amani iliyotolewa kwa Yahweh, lazima mtu huyo akatiliwe mbali kutoka kwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kisha Yahweh akazungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Zungumza na watu wa Israeli na uwaambie, 'hamruhusiwi kula mafuta ya fahali au kondoo au mbuzi. ");
INSERT INTO swhulb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta ya mnyama yoyote afaye peke yake bila ya kuwa dhabihu, au mafuta ya mnyama yeyote aliyeraruliwa na wanyama pori, yanaweza kutumika kwa makusudi mengine, lakini hakika hamtayala. ");
INSERT INTO swhulb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Yeyote atakayekula mafuta ya mnyama ambayo watu wanaweza kuyatoa kuwa dhabihu ya iliyofanywa kwa Yahweh kwa moto, mtu huyo lazima atakatiliwa mbali kutoka kwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Hamtakula damu yoyote katika mojawapo ya nyumba zenu, ama iwe kutoka kwa ndege au mnyama. ");
INSERT INTO swhulb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Yeyote alaye damu yoyote, mtu huyo lazima akatiliwe mbali kutoka kwa watu wake.'” ");
INSERT INTO swhulb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kwa hiyo Yahweh akazungumza na Musa na akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Zungumza na watu wa Israeli na uwaambie, 'Yeye atoaye dhabidhu ya sadaka ya amani kwa Yahweh lazima alete sehemu ya dhabihu yake kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Mikono yake mwenyewe lazima iilete hiyo sadaka ifanywayo kwa Yahweh kwa moto. Naye atayaleta hayo mafuta pamoja na kidari, ili kwamba kidari kiweze kutikiswa kuwa sadaka ya kutikiswa mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kuhani atayachoma mafuta hayo juu ya madhabahu, lakini kile kidari kitakuwa mali ya Aroni na uzao wake. ");
INSERT INTO swhulb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ni lazima utatoa paja la kulia kwa kuhani kama sadaka iliyotokana na dhabihu ya sadaka yako ya amani. ");
INSERT INTO swhulb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Yule kuhani, mmoja wa wazao wa Aroni, atoaye damu na mafuta ya sadaka ya amani—ni lazima atapata paja la kulia kama mgao wake wa sadaka. ");
INSERT INTO swhulb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kwa kuwa nimetwaa kidari, na paja la sadaka ya kutikiswa kutoka kwa watu wa Israeli uwe mchango wao, na amepewa Aroni kuhani na wanawe kuwa mgao wao wa kawaida. ");
INSERT INTO swhulb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Huu ndiyo mgao wa Aroni na uzao wake utokanao na matoleo yaliyofanywa kwa Yahweh kwa moto, siku ile Musa alipowaweka wakfu ili kumtumikia Yahweh katika kazi ya kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Huu ndio mgao ambao Yahweh aliamru waweze kupewa kutoka kwa watu wa Israeli, katika siku hiyo aliyowatia mafuta ya upako wawe makuhani. Nao utakuwa mgao wao wa kila siku katika vizazi vyote. ");
INSERT INTO swhulb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hii ndiyo sheria ya sadaka ya kuteketezwa, ya sadaka ya nafaka, ya sadaka ya dhambi, ya sadaka ya hatia, ya sadaka ya kuweka wakfu, na ya dhabihu, ya sadaka za amani, ");
INSERT INTO swhulb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ni sheria ambazo Yahweh alizitoa kwa Musa kwenye Mlima Sinai siku aliyowaamru watu wa Israeli kutoa dhabihu zao kwa Yahweh katika jangwa la Sinai.'” ");
INSERT INTO swhulb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh akazungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Walete Aroni na wanawe pamoja naye, mavazi na mafuta ya upako, fahali kwa ajili ya sadaka ya dhambi, kondoo dume wawili, na kikapu cha mkate usio na hamira. ");
INSERT INTO swhulb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ita kusanyiko lote kwenye ingilio la hema la kukutania.” ");
INSERT INTO swhulb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Kwa hiyo Musa akafanya kama Yahweh alivyomwamru, nalo kusanyiko lilikuja pamoja mbele ya ingilio la hema la kukutania. Kisha Musa akaliambia kusanyiko, ");
INSERT INTO swhulb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","“Hivi ndivyo alivyotuamru Yahweh tutende.” ");
INSERT INTO swhulb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Musa akamleta Aroni na wanawe na kuwaosha kwa maji. ");
INSERT INTO swhulb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Akamvika Aroni kanzu ya ndani yenye urefu wa kufika magotini na kumfunga ukumbuu kiunoni mwake, akamvika joho la nje lenye mikono mirefu na kumvika kile kizibao chenye vipande viwili tumboni na mgongoni na kukifunga kuzunguka kiunoni mwake kwa mshipi uliosokotwa kwa ustadi na kukikaza mwilini mwake. ");
INSERT INTO swhulb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Kisha Musa akaweka kifuko kifuani mwa Aroni, na ndani ya kifuko hicho akaweka Urimu na Thumimu. ");
INSERT INTO swhulb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Na kisha akamfunga kiremba kichwani, na juu ya kiremba kwa mbele, akaweka bamba la dhahabu; liwe taji takatifu, kama Yahweh alivyomwamru yeye. ");
INSERT INTO swhulb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Musa akayatwaa hayo mafuta ya upako, akalipaka lile hema la kukutania na kila kitu kilichokuwamo ndani yake na kuvitenga kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Akayanyunyiza hayo mafuta juu ya madhabahu mara saba, na kisha akaipaka mafuta hiyo madhabahu na vyombo vyake vyote, na sinia la kunawia na kitako chake ili kuvitenga wa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Akamimina sehemu ya mafuta ya upako juu ya kichwa cha Aroni na kisha akampaka mafuta ili kumtenga. ");
INSERT INTO swhulb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Musa akawaleta wana wa Aroni na kuwavika kila mmoja kanzu ya ndani yenye urefu wa kufika magotini. Kila mmoja wao akamfunga kwa ukumbuu kiunoni mwake na kuwafunga vitambaa vya kitani kichwani pao, kama vile Yahweh alivyokuwa amemru Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Musa akamleta huyo fahali kwa ajili ya sadaka ya dhambi, naye Aroni na wanawe wakaweka mikono yao juu ya kichwa cha fahali ambaye wamemelete kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa akamchinja, na kisha akachukua sehemu ya damu yake kwa kidole chake na kuiweka juu ya mpembe za madhabahu, akaitakasa hiyo madhabahu, na kuitenga kwa Mungu, ambapo kwa kufanya hivyo, aliisababisha madhabahu kuwa sehemu ya kufaa kwa kufanyia upatanisho. ");
INSERT INTO swhulb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Akachukua mafuta yote yaliyokuwa sehemu za ndani, kile kiwambo cha ini, zile figo mbili pamoja na mafuta yake, Musa akaichoma hiyo nyama yote juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Lakini yule fahali, ngozi yake, nyama yake na kinyesi chake, akavichoma nje ya kambi, kama vile Yehweh alivyokuwa amemwamru yeye. ");
INSERT INTO swhulb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Musa akamleta yule konndoo dume kwa ajili ya sadaka ya kuteketezwa, naye Aroni na wanawe wakaweka mikono yao juu ya kichwa cha huyo kondoo. ");
INSERT INTO swhulb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa akamchinja kondoo na kuinyunyizia damu yake kila upande wa madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Naye akamkatakata kondoo vipande vipande na akakiteketeza kichwa chake pamoja na vile vipande na mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Akaziosha kwa maji zile sehemu za ndani pamoja na miguu na akamteketeza kandoo mzima juu ya madhabahu. Ilikuwa ni dhabihu ya kuteketezwa na ilitoa harufu ya kupendeza, sadaka iliyofanywa kwa Yahweh kwa moto kama vile Yahweh alivyokuwa amemwamru Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kisha Musa akamleta yule kondoo dume mwingine, kondoo wa kuwekwa wakfu, naye Aroni na wanawe wakaweka mikono yao juu ya kichwa cha kondoo. ");
INSERT INTO swhulb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Aroni akamchinja, naye Musa akachukua sehemu ya damu na kuiweka kwenye ncha ya sikio la Aroni la kulia, juu ya dole gumba la mkono wake wa kulia, na kwenye kidole kikumbwa cha mguu wake wa kulia. ");
INSERT INTO swhulb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Akawaleta wana wa Aroni, naye akaweka sehemu ya damu ya kondoo yule kwenye ncha ya sikio lao la kulia, kwenye dole gumba lao cha mkono wa kulia na kwenye kidole chao kikubwa cha mguu wa kulia. Kisha Musa akainyunyiza damu ya huyo kila upande wa madhabahu ");
INSERT INTO swhulb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Naye akayatwaa yale mafuta, mafuta ya mkiani, mafuta liyolikuwa sehemu za ndani, na mafuta yafunikayo ini, zile figo mbili pamoja na mafuta yake na paja la kulia. ");
INSERT INTO swhulb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Akachukua mkate mmoja kutoka kwenye kikapu cha mikate isiyo na hamira ambayoo ilikuwa mbele za Yahweh, akatwaa mkate moja usio na hamira, na mkate mmoja ulioandaliwa kwa mafuta, na mkate mwemba wa kaki na akaiweka juu ya mafuta na juu ya paja la kulia la kondoo. ");
INSERT INTO swhulb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Akaiweka yote mikoni mwa Aroni na katika mikono ya wanawe na kuitikisa mbele za Yahweh kuwa sadaka ya kutikiswa ");
INSERT INTO swhulb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kisha Musa akaichukua mikate hiyo kutoka mikononi mwao na kuiteketeza juu ya madhabahu kwa ajili ya sadaka ya kuteketezwa. Zilikuwa ni sadaka ya kuwekwa wakfu na ilitoa harufu ya kupendeza. Ilikuwa sadaka iliyofanywa kwa Yahweh kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa akakichukua kidari na kukitikisa kuwa sadaka ya kutikiswa kwa Yahweh. Ilikuwa ni mgao wa Musa wa kondoo wa kuwekewa mikono kwa makuhani, Kama vile Yahweh alivyokuwa amemwamuru yeye. ");
INSERT INTO swhulb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa akatwaa sehemu ya mafuta ya upako na damu iliyokuwa juu ya madhabahu; naye akayanyunyiza haya juu ya nguo za Aroni, juu ya nguo zake mwenyewe na juu ya nguo za wana wa Aruni waliokua pamoja naye. Kwa njia hii alimtenga Aroni na nguo zake, na wanawe na nguo zao kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kwa hiyo Musa akawambia Aruni na wanawe, “Ipikeni nyama mbele ya ingilio la hema la kukutania, na hapo mtaila pamoja na mkate ulio kwenye kikapu cha kuwekwa wakfu, kama ilivyoamriwa, kusema, 'Aroni na wanawe wataila.' ");
INSERT INTO swhulb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Masalio yoyote ya nyama na mikate utayateketeza kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Na hamtatoka kwenye ingilio la hema la kukutania kwa muda wa siku saba, hata zitakapotimia siku za kuwekwa mikono kwenu. Kwa kuwa kwa muda wa siku saba, Yahweh atawaweka wakfu. ");
INSERT INTO swhulb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kilichotendeka siku hii— Yahweh ndiye amekiamru kitendekeke ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mtakaa kwenye ingilio la hema la kukutania mchana na usiku siku saba, nanyi ishikeni amri ya Yahweh ili msije mkafa, kwa sababu hivi ndivyo ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Kwa hiyo Aroni na wanawe wakafanya mambo yote ambayo Yahweh alikuwa amewaamru kwa kinywa cha Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Katika siku ya nane, Musa akawaita Aroni na wanawe pamoja na wazee wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Akamwambia Aroni, “Twaa ndama dume kutoka kundini kwa ajili ya sadaka ya dhambi zako, na kondoo dume kwa ajili ya sadaka ya kuteketezwa, wote wawili wasiwe na dosari, na uwatoe mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Zungumza na watu wa Israeli na uwaambie, 'Twaeni beberu kwa ajili ya sadaka ya dhambi na ndama na mwana-kondoo, hawa wawili wawe na umri wa mwaka mmoja na bila dosari, ni kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhulb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","pia twaeni fahali na kondoo dume kwa sadaka za amani ili kuwatoa mbele za Yahweh, na sadaka za nafaka iliyochanganywa na mafuta, kwa sababu leo Yahweh atajidhihirisha kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Kwa hiyo wakaleta kwenye hema la kukutania vyote ambavyo Musa aliagiza, nalo kusanyiko lote la Israeli likakaribia na kusimama mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kisha Musa akasema, “Hivi ndivyo Yahweh amewaamru nyinyi mfanye, ili kwamba utukufu wake uweze kuonekana kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","“Musa akamwambia Aroni, “Njoo karibu na Madhabahu na uteo sadaka yako ya dhambi na sadaka ya kuteketezwa, na kufanya upatanisho kwa ajili ya watu ili kufanya upatanisho kwa ajili yao kama vile ambavyo Yahweh amekwishaamru.” ");
INSERT INTO swhulb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kwa hiyo Aroni akaikaribia madhabahu na akamchinja yule ndama kwa ajili ya sadaka ya dhambi, ambayo ilikuwa kwa ajili yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Nao wana wa Aroni wakamletea hiyo damu, naye akakichofya kidole chake kwenye damu na kuiweka kwenye pembe za madhabahu, kisha akaimwaga damu chini ya kitako cha madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Hata hivyo, aliyateketeza hayo mafuta, figo, na mafuta yanafunika ini juu ya madhabahu kuwa sadaka ya dhambi, kama vile Yahweh alivyokuwa amemwamru Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Na akaiteketeza hiyo nyama pamoja na ngozi nje ya kambi ");
INSERT INTO swhulb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aroni akaichinja sadaka ya kuteketezwa, nao wanawe wakampa hiyo damu, ambayo aliinyunza pande zote za madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Kisha wakampa ile sadaka ya kuteketezwa, kipande kwa kipande, pamoja na kichwa, naye akaviteketeza juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Akaziosha sehemu za ndani pamoja na miguu na kuziteketeza juu ya dhabihu ya kuteketezwa juu ya Madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Aroni akaleta dhabihu ya watu— mbuzi, kisha akamtoa kuwa dhabihu kwa ajili ya dhambi yao naye akamchinja, akaitoa dhabihu kwa ajili ya dhambi, kama alivyofanya kwa yule mbuzi wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Akaileta sadaka ya kuteketezwa na kuitoa kama Yahweh alivyokuwa ameamru. ");
INSERT INTO swhulb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Akaileta sadaka ya nafaka; akakijaza kiganja chake nafaka na kuiteketeza juu ya madhabahu, pamoja na sadaka ya asubuhi ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pia akamchinja fahali na yule kondoo dume, dhabihu kwa ajili ya sadaka ya amani, ambayo ilikuwa kwa ajili ya watu. Nao wana wa Aronni wakampa damu, ambayo aliinyunyiza kila upande wa mdhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Hata hivyo, waliyakata mafuta ya fahali na ya yule kondoo dume, mafuta ya kwenye mkia, mafuta yafunikayo sehemu za ndani, figo, na yale mafuta yaliyofunika mapafu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Wakazichukua hizi sehemu zilizokatwa wakaziweka juu ya vidari, na kisha Aroni akateketeza mafuta juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Naye Aroni akavitikisa vidari na paja la kulia kuwa sadaka ya kutikiswa mbele za Yahweh, kama vile Musa alivyokuwa ameamru, ");
INSERT INTO swhulb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kisha Aroni akainua juu mikono yake mbele ya watu na kuwabariki, kisha akashuka chini kutoka mahali alipokuwa akitoa hiyo sadaka ya dhambi, sadaka ya kuteketezwa, na sadaka ya amani. ");
INSERT INTO swhulb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa na Aroni wakaingia ndani ya hema la kukutania, kisha wakatoka nje tena na kuwabariki watu, na utukufu wa Yahweh ukaonekana kwa watu wote. ");
INSERT INTO swhulb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moto ukashuka kutoka kwa Yahweh na ukairamba sadaka ya kuteketezwa na mafuta yaliyokuwa juu ya madhabahu. Watu wlipoona jambo hili, wakapiga kelele na kulala chini. ");
INSERT INTO swhulb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu na Abihu, wana wa Aroni, wakachukua kila mtu kifukizo chake, akaweka moto ndani yake, na kisha uvumba. Kisha wakatoa moto usiokuabalika mbele za Yahweh, moto ambao hakuwaamru wao kuutoa. ");
INSERT INTO swhulb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kwa hiyo moto ukashuka chini mbele za Yahweh na kuwala, nao wakafa mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kisha Musa akamwambia Aroni, Hivi ndiyo Yahweh alivyokuwa akizunguzia aliposema, 'Nitaufunua utakatifu wangu kwa wale wajao mbele zangu. Nami nitatukuzwa mbele za watu wote.'” Naye Aroni hakusema neno lolote. ");
INSERT INTO swhulb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa akamwita Mishaeli na Elzafani, wana wa Uzieli mjomba wa Aroni, naye akamwambia, “njoo huku na uwatowe ndugu zako nje ya kambi watoke mbele ya hema.” ");
INSERT INTO swhulb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Hivyo wakakaribia na kuwachukua wangali wamevaa kanzu zao za kikuhani, nao wakawapeleka nje ya kambi, kama Musa alivyokuwa ameelekeza. Kisha Musa akamwambia Aroni na wanawe wengine wawili, Eliezari na Ithamari, “ ");
INSERT INTO swhulb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Msiache wazi nywele za vichwa vyenu, wala msirarue nguo zenu, ili kwamba msije mkafa, na kwamba Yahweh asilikasirikie kusanyiko zima. Lakini waacheni jamaa zenu, nyumba yote ya Israeli waweze kufanya ibada za maombolezo kwa ajili ya hao ambao Yahweh amewaangamiza kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Msiende nje kutoka kwenye ingilio la hema la kukutania, ama sivyo mtakufa, kwa kuwa mafuta ya Yahweh ya upako yako juu yenu.” Kwa hiyo wakatenda sawasawa na maelekezo ya Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mungu akazungumza na Aroni, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Msinywe mvinyo wala kinywaji kikali, wewe, au wanao wanaobaki pamoja nawe, ili kwamba mtakapoingia kwenye hema ya kukutania msije mkafa. Hii itakuwa amri ya kudumu katika vizazi vyote vya watu wenu, ");
INSERT INTO swhulb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ili kupaambanua kati ya mambo matakatifu na mambo ya kawaida, na kati ya najisi na safi, ");
INSERT INTO swhulb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ili kwamba mweze kuwafundisha watu wa Israeli amri zote ambazo Yahweh ameziamru kwa kinywa cha Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa akazungumza na Aroni na wanawe wawili waliosalia; Eliazari naIthamari, Twaeni sadaka ya nafaka inayobaki kutokana na sadaka ifanywayo kwa Yahweh kwa moto, nanyi ileni kando ya madhabahu bila hamiara, kwa kuwa ni takatifu sana. ");
INSERT INTO swhulb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","lazima mtaila mahali patatifu kwa sababu huo ni mgao wako wewe na mgao wa wanao wa matoleo yaliyofanywa kwa Yahweh kwa moto, kwa kuwa hivi ndivyo limeamriwa niwaambie. ");
INSERT INTO swhulb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kile kidari kitikiswacho na lile paja ambalo hutolewa kwa Yahweh, yapasa mzile mahali palipo safi panapokubalika kwa Mungu. Wewe mwenyewe, wanao na binti zako waliopamoja nawe mtakula sehemu hizo, kwa kuwa zimetolewa kuwa mgao wako na mgao wa wanao kutokana na dhabihu ya sadaka ya ushirika wa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Lile paja lililotolewa na kidari kilichotikiswa, ni lazima ziletwe pamoja na sadaka ya mafuta iliyofanywa kwa moto, ili kutikiswa mbele za Yahweh. Nazo zitakuwa zako wewe na wanao kuwa mgao wenu daima, kama Yahweh alivyoamru. ");
INSERT INTO swhulb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kisha Musa akauliza kuhusu yule mbuzi wa sadaka ya dhambi, naye akagundua kwamba alikuwa ametekezwa kwa moto. Kwa hiyo akawakasirikia Eliazari na Ithamari, wana wa Aroni waliosalia; akawaambia, ");
INSERT INTO swhulb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Kwa nini hamjaila sadaka ya dhambi katika eneo la hema, kwa kuwa ni takatifu sana, na kwa kuwa Yahweh amishaitoa kwenu ili kuchukua uovu wa kusanyiko, ili kufanya upatanisho kwa aijli yao mbele zake? ");
INSERT INTO swhulb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tazama, damu yake haikuletwa ndani ya hema, kwa hiyo iliwapasa kwa hakika kuwa mekwisha ila kwenye eneo la hema, kama nilivyoagiza? ");
INSERT INTO swhulb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Kisha Aroni akamjibu Musa, “ Tazama, leo walitoa sadaka yao ya dhambi na sadaka ya kuteketezwa mbele za Yahweh, na jambo hili vilevile limetendeka kwangu leo. Ikiwa nimeshakula sadaka ya dhambi leo, Je! Isingekuwa imeshapendeza mbele za Yahweh?” ");
INSERT INTO swhulb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Naye Musa aliposikia hivyo, akaridhika. ");
INSERT INTO swhulb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahweh akazungumza na Musa na Aroni, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Sungumzeni na watu wa Israeli muwaambie, 'Hivi ndivyo viumbe vyenye uhai ambavyo mwaweza kula miongoni mwa wanyama walioko juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mnaweza kula mnyama yeyote aliye na kwato zenye kugawanyika na ambaye pia hucheua. ");
INSERT INTO swhulb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Hata hivyo, kuna baadhi ya wanyama ambao ama hawacheui au hana kwato zilizogawanyika, nanyi msiwale hao, wanyama kama ngamia, kwa sababu yeye hucheua lakini hana kwato zilizogawanyika. Kwa hiyo ngamia ni najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pimbi pia: kwa sababu yeye hucheua lakini hana kwato zilizogawanyika mara mbili, huyo pia ni najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Na sungura pia: kwa sababu yeye hucheua lakini hana kwato zilizogawanyika mara mbili, huyu naye ni najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Na nguruwe pia: ingawaje yeye anazo kwato zilizogawanyika lakini hacheui, kwa hiyo yeye ni najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Msile aina yoyote ya nyama yao, wala msiiguse mizoga yao. Hao ni najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Nao wanyama waishio majini mnaoweza kuwala ni wale wote walio na mapezi na magamba, iwe waliomo baharini au mitoni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Lakini viumbe wote hai wasio na mapezi na magamba waliomo baharini au mitoni, pamoja na wale waendao majini na viumbe hai waliomo majini —watakuwa chukizo kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Kwa kuwa watakuwa chukizo, msile nyama yao, pia mizoga yao sharti itakuwa chukizo. ");
INSERT INTO swhulb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chochote kisichokuwa na mapezi au magamba kilichomo majini ni lazima kiwe chukizo kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Nao ndege mtakaowachukia na msiopaswa kuwala ni hawa wafuatao: tai, furukombe, kipungu, ");
INSERT INTO swhulb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mwewe mwekundu, aina yoyote ya kipanga, ");
INSERT INTO swhulb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kila aina ya kunguru, ");
INSERT INTO swhulb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","kiruka-njia, kipasuasanda, Shakwe, na aina yoyote ya mwewe. ");
INSERT INTO swhulb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Ni lazima pia bundi mdogo na bundi mkubwa muwaone kuwa chukizo, mnandi, ");
INSERT INTO swhulb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bundi mweupe na mwari, ");
INSERT INTO swhulb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","korongo na ina zote za koikoi, huduhudi na popo pia. ");
INSERT INTO swhulb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Wadudu wote wenye mabawa wanatembea kwa miguu minne kwenu ni machukizo. ");
INSERT INTO swhulb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Lakini manaweza kula wadudu wenye mabawa wanaotembea kwa miguu minne ya kurukia ardhini yenye vifundo. ");
INSERT INTO swhulb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Na manaweza kula kula aina zote za nzige, senene, parare, au panzi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Lakini wadudu wote warukao wenye miguu minne ni chulkizo kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Nanyi mtakuwa najisi hata jioni kutokana na wanyama hawa endapo mtagusa mizogo yao. ");
INSERT INTO swhulb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Na yeyote atakayeokota mojawapo wa mizoga yao ni lazima atazifua ngua zake naye atakuwa najisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Mnyama yeyote ambaye anazo kwato ziliachana ambazo hazikugawanyika kabisa au hacheui huyo ni najisi kwenu. Yeyote awagusaye atakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Mnyama yeyote anayetembea kwa vitanga vyake miongoni mwa wanyama waendao kwa miguu yote minne ni najisi kwenu. Yeyote agusaye mzoga kama huo atakuwa najisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Na yeyote aokotaye mzoga kama huo ni zazima atazifua nguo zake na kuwa najisi hata jioni. Wanyama hawa watakuwa najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Kuhusiana na wanyama wataambaao juu ya ardhi, hawa ndiyo walio najisi kwenu: kicheche, panya, aina zote za mijusi mikubwa, guruguru, ");
INSERT INTO swhulb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","kenge, mijusi ya ukutani, goromoe, na kinyonga. ");
INSERT INTO swhulb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wanyama hawa wote ambao hutambaa, hawa ndiyo watakuwa najisi kwenu. Yeyote awagusaye atakuwa njisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Na iwapo mmoja wao anakufa na kuanguka juu ya chombo, chombo hicho kitakuwa najisi, ama kiwe kimetengenezwa kwa mbao, nguo, ngozi, au gunia. Kiwe chombo cha namna gani na kiwe kwa matumizi gani, ni lazima kitalowekwa katika maji nacho kitakuwa najisi hata jio. Kisha kitakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kwa hiyo kila chungu ambacho mnyama najisi atakiangukia juu yake au ndani yake, chochote kilichomo kwenye chungu hicho kitakuwa najisi, na ni lazima mtakivunja chungu hicho. ");
INSERT INTO swhulb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Vyakula vyote ambavyo ni safi na kilichuhusiwa kuliwa, lakini kikaingiwa na maji kutoka kwenye chungu najisi kilichoanguka, nacho kitakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Na kitu chochote kinachoweza kunywewa kutoka kwenye chungu kama hicho kitakuwa najisi. Kila kitu kitakachoangukiwa juu yake na kipande cha mzoga wa mnyama najisi nacho kitakuwa najisi, ama liwe ni jiko au vyungu vya kupikia. Ni najisi na ni lazima kiwe najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Chemchemi au kisima cha maji ya kunywa yanapokusanyika patabaki kuwa safi iwapo kiumbe najisi kama hicho kitaangukia humo. Lakini ikiwa yeyote anaugusa mzoga wa mnyama aliye najisi uliomo ndani ya maji, yeye atakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Iwapo sehehemu yoyote ya mzoga wa mnyama aliyenajisi inaangukia juu ya mbegu zozote zilizo kwa ajili ya kupanda. Mbegu hizo zitakuwa bado zingali safi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lakini kama maji yanawekwa juu ya mbegu, na kama sehemu ya mzoga unaangukia juu yake, nazo zitakuwa najisi kwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Iwapo mnyama yeyote awezaye kuliwa anakufa, naye yeyote amgusaye atakuwa najisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Na yeyote alaye chochote cha mzoga huo atalazimika kufua nguo zake naye atakuwa anjisi hata jioni. Na yeyote aokotaye mzoga kama huo atafua nguo zake na kuwa najisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Kila mnyama atambaaye juu ya ardhi atakuwa chukizo; hatakuwa wa kuliwa. ");
INSERT INTO swhulb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Chochote kitambaacho kwa kujivuta juu ya tumbo lake, na chochote kitembeacho kwa miguu yake yote minne, au chochote kilicho na miguu mingi—wanyama wote ambao hutambaa juu ya nchi, hawa msiwale, kwa sababu watakuwa machukizo. ");
INSERT INTO swhulb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Msijinajisi wenyewe kwa kiumbe chochote nnajisi kitaambacho; msijinasi wenyewe kwavyo, ili kwamba msije mkachafuliwa navyo. ");
INSERT INTO swhulb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kwa kuwa Mimi ndimi Yahweh Mungu wenu. Nanyi lazima muwe watakatifu, kwa hiyo na iweni watakatifu, kwa sababu Mimi ni mtakatifu. Haiwapasi kujichafua kwa aina yoyote ya kiendacho juu ya nchi. ");
INSERT INTO swhulb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kwa kuwa Mimi ndimi Yahweh, aliyewaleta ninyi kutoka nchi ya Misri, ili niwe Mungu wenu. Kwa hiyo lazima muwe watakatifu, kwa kuwa Mimi ni mtakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Hii ndiyo sheria kuhusu wanyama, ndege, kila kiumbe hai kiendacho majini, na ya kila kiumbe kitambaacho juu ya nchi, ");
INSERT INTO swhulb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","kwa jili ya kilie kinachopaswa kutofautishwa kati ya kilicho najisi na kilicho safi, na kati ya vitu vilivyokufa na vilivyo hai ambavyo vyaweza kuliwa na vitu vyenye uihai visivyoweza kuliwa.” ");
INSERT INTO swhulb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh akamwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“zungumza na watu wa Israeli, uwaambie, 'endapo mwanamke anakuwa mjamzito na kujifungua mtoto wa kiume, naye atakuwa najisi kwa muda wasiku saba, ni kama tu vile anavyokuwa najisi katika siku za kipindi chake kwa mwezi. ");
INSERT INTO swhulb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Katika siku ya nane nyama ya govi la mtoto mvulana itatahiriwa. ");
INSERT INTO swhulb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Kisha utakaso wa mama wa kutokwa damu yake utaendelea kwa muda wa siku tatu. Haimpasi kugusa kitu chochote kilicho kitakatifu au kukaribia eneo la hema mpaka zitakapomalizika siku za kutakaswa kwake. ");
INSERT INTO swhulb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Lakini kama atajifungua mtoto wa kike, naye atakuwa najisi kwa mud wa majuma mawili, kama alivyo wakati wa kipindi chake. Kisha utakaso wa mama utaendelea kwa siku sitini sita. ");
INSERT INTO swhulb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Siku za kutakaswa kwake zitakapoisha, kwa ajili ya mwana au binti, atalazimika kuleta kwa kuhani mwana-kondoo wa mwaka mmoja kuwa sadaka ya kuteketezwa, na kinda la njiwa au huwa kuwa sadaka ya dhambi, mbele ya ingilio la hema la kukutania, ");
INSERT INTO swhulb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kisha atawatoa mbele za Yahweh na kufanya sadaka ya upatanisho kwa ajili yake, naye atatakaswa kutokana kutiririka kwa damu yake. Hii ndiyo sheria kuhusu mwanamke aifunguaye ama mtoto wa kiume au wa kike. ");
INSERT INTO swhulb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Na kama hana uwezo wa kutoa mwana-kondoo, naye ataleta makinda mawili ya njiwa ua hua, mmoja kwa ajili ya sadaka ya kuteketezwa na mwingine kuwa sadaka ya dhambi, naye kuhani atafanya upatanisho kwa ajili yake; naye atakuwa safi.” ");
INSERT INTO swhulb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh akazungumza na Musa na Aroni, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Mtu yeyote anayeonekana na uvimbe au pele au doa ling'aalo juu ya ngozi ya mwili wake, na likawa limeambukizwa ugonjwa wa ngozi mwilini mwake, ni lazima aletwe kwa Aroni kuhani mkuu au kwa mmoja wa wanawe makuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Naye kuhanai atachunguza ugonjwa huo kwenye ngozi ya mwili wake. Iwapo malaika zilizopo eneo lenye ugonjwa zimegeuka kuwa nyeupe, na iwapo ugonjwa umejitokeza juu ya ngozi, huo ni ugonjwa wa kuambukiza. Baada cha kuhani kumchunguza, atamtangaza kuwa ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Iwapo lile doa ling'aalo katika ngozi yake ni jeupe, na kuonekana kwake halikwenda chini zaidi ya ngozi, na iwapo malaika za eneo lenye ugonjwa hazijabadilika kuwa nyeupe, naye kuhani atamtenga mgonjwa kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Katika siku ya saba, huyo kuhani itambidi kumchunguza tena ili kuona kama katika maamzi yake huo ugonjwa siyo mbaya, na kama haujaenea kwenye ngozi. Iwapo haujaenea, basi, kuhani atamtenga kwa siku saba zaidi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Naye kuhani atamchunga tena katika siku ya saba ili kuona kama ugonjwa ubepona na haujasambaa zaidi kwenye ngozi. kama haujasambaa, basi, kuhani atamtangaza kuwa yeye ni safi. Ni upele tu. Naye atafua nguo zake, na kisha yeye yu safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lakini endapo ule upele utakuwa umishasambaa kwenye ngozi baada ya kuwa amejionyesha kwa kuhani kwa ajili kusafishwa kwake, itambidi kujionyesha tena kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Naye kuhani atamchunguza ilikuona kama huo upele umsambaa zaidi ndani ya ngozi. Na endapo utakuwa umesambaa, kisha kuhani atamtangaza kuwa najisi. Huo ni ugonjwa wa kuambukiza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Iwapo ugonjwa wa ngozi wa kuambukiza umo kwa mtu fulani, naye mtu huyo yapasa aletwe kwa kuhan. ");
INSERT INTO swhulb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kuhani atamchunguza ili kuona kama kunauvimbe mweupe katika ngozi yake, endapo malaika zitakuwa zimebadilika kuwa nyeupe, au kumekuwa na nyama mbichi kwenye uvimbe. ");
INSERT INTO swhulb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Kama ipo, basi, huo ni ugonjwa sugu wa ngozi, naye kuhani atamtangaza kuwa najisi. Hatamtenga kwa kuwa yeye tayari ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Iwapo huo ugonjwa unajitokeza na kupanuka zaidi kwenye ngozi, na kuifunika ngozi ya mtu kwa ugonjwa tangu kichwani pake hata miguuni, maadamu anajitokeza kwa kuhani, ");
INSERT INTO swhulb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","naye kuhani atamchunguza ili kuona kama huo ugonjwa umeshaenea mwili wake wote. Ikiwa imetokeo hivyo, kuhani atamtangaza mtu huyo aliye na ugonjwa kuwa ni safi. Ikiwa amebadilika kuwa mweupe, huyo ni safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lakini ikiwa nyama mbichi imeonekana juu yake, atakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kuhani ataiangalia hiyo nyama mbichi na kumtanga kuwa najisi kwa sababu hiyo nyama mbichi ni najisi. Huo ni ugonjwa wa kuambukiza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Lakini endapo hiyo nyama mbichi inageuka kuwa nyeupe tena, naye huyo mtu hana budi kwenda kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kuhani atamchunguza ili kuona kama hiyo nyama imebadilika kuwa nyeupe. Kama imekuwa hivyo naye kuhani atatangaza kwamba mtu huyo kuwa ni safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Mtu anapokuwa na jipu juu yangozi yake na limishapona, ");
INSERT INTO swhulb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","na mahali pa jipu pamekuwa na uvimbe au doa lenye kung'aa, wekundu unaochanganyikana na weupe, yapasa kuonyeshwa kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Naye kuhani atalichunguza ili kuona kama linaonekana limekwenda chini ya ngozi, na kama hizo malaika zimebadilika kuwa nyeupe, kama ni hivyo, kuhani atamtangaza kuwa najisi. Huo ni ugonjwa wa kuambukiza, endapo utakuwa umezalishwa mahali lilipokuwa jipu hilo. ");
INSERT INTO swhulb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lakini endapo kuhani atakuwa amelichunguza na haoni malaika nyeupe ndani yake, na kwamba iliko chini ya ngozi bali limefifia, kisha kuhani atamtenga kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kama linaenea kwa kupanuka kwenye ngozi, kisha kuhani atamtangaza kuwa najisi. Huo ni ugonjwa wa kuambukiza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Lakini kama hilo doa lenye kung'ara linabaki mahali pake na halijasambaa, basi hilo ni kovu la jipu, naye kuhani atamtangaza kuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ngozi inapoungua na nyama mbichi ya inamekuwa na wekundu uliochanganyika na weupe au doa jeupe, ");
INSERT INTO swhulb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kisha kuhani ataichunguza kuona kama malaika zilizoko kwenye doa hilo zimebadilika na kuwa nyeupe, na kama limeonekana kwenda chini zaidi ya ngozi, kama limekuwa hivyo, basi huo ni ugonjwa wa kuambukiza. Umejitokeza kwenye jeraha la moto, naye kuhani atamtangaza kuwa najisi. Huo ni ugonjwa wa kuambukiza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lakini endapo kuahani analichunguza na naona kwamba hakuna malaika nyeupe kwenye doa, na kwamba halikuenda chini ya ngozi bali linafifia, basi, kuhani atamtenga mtu huyo kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kisha yapasa kuahani kumchunguza tena katika siku ya saba. Iwapo litakuwa limesambaa kwa upana kwenye ngozi, naye kuhani atamtangaza kuwa najisi. Huo ni ugojwa wa kuambukiza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Iwapo hilo doa lisalia mahali pake na halitakuwa limesambaa kwenye ngozi bali limefifia, ni uvimbe tu kutokana na kuungua moto, naye kuhani atamtangaza kuwa safi, kwa kuwa siyo zaidi ya jeraha la kuungua. ");
INSERT INTO swhulb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Iwapo mwanaume au mwanamke ana ugonjwa wa kuambukiza kichwani au kidevuni pake, ");
INSERT INTO swhulb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kisha kuhani atamchunguza mtu huyo kwa ajili ya ugonjwa wa kuambukiza ili kuona kama unakwenda ndani zaidi ya ngozi, na kama kuna nywele za manjano, nyembamba ndani yake. endapo zinaonekana, kisha kuhani atamtangaza kuwa najisi. Huo ni mwasho, ugonjwa wa kuambukiza kichwani au kidevuni. ");
INSERT INTO swhulb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Iwapo kuhani anachunguza ugonjwa wa mwasho na anagundu kuwa hauko chini ya ngozi, na kama hakuna nywele nyeusi ndani yake, kisha kuhani atamtenga mtu huyo mwenye ugonjwa wa mwasho kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Katika siku ya saba kuhani atauchunguza tena huo ugonjwa ili kuona kama umesambaa, Endapo hakuna malaika za manjano, na iwapo ugonjwa uko usawa ngozi tu, ");
INSERT INTO swhulb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","basi, yapasa mtu huyo kunyolewa., lakini sehemu yenye ugonjwa haitanyolewa, naye kuhani atamtenga mtu huyo mwenye ugonjwa wa mwasho kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Katika siku ya saba kuhani atauchunguza tena ugonjwa ili kuona kama umacha kusambaa ndani ya ngozi. Iwapo unaonekana kuwa hukwenda chini zaidi ya ngozi, kisha kuhani atamtangaza kuwa safi. Mtu huyo yapasa kufua nguo zake, na kisha atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lakini ikiwa ugonjwa wa mwasho umeenea kwa sehemu kubwa kwenye ngozi baada ya kuhani kutangaza kuwa alikuwa safi, ");
INSERT INTO swhulb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","naye kuhani itabidi amchunguze tena. Iwapo ugonjwa utakuwa umesambaa katika ngozi, kuhani hahitajiki kutafuta nywele za manjano. Mtu huyo ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Lakini iwapo katika mtazamo wa kuhani inaonekana kuwa huo ugonjwa wa mwasho umekoma kusambaa, basi huo ugonjwa umekwisha pona. Yeye ni safi, naye kuhani atamtangaza kuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Iwapo mwanume au mwanamke ana madoa juu ya ngozi, ");
INSERT INTO swhulb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kisha kuhani atamchunguza mtu huyo ili kuona kama hayo madoa ni meupe kwa kufiifia, ambalo ni kovu tu lililojitokeza kwenye ngozi. Yeye yu safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Iwapo nywele za mtu zimenyonyoka kichwani, yeye ni kipara lakini yu safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Na iwapo nywele zake zimenyonyoka upande wa mbele wa kichwa chake, na iwapo paji lake la uso lina kipara, yeye yu safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lakini endapo kuna kidonda chenye wekundu uliochanganyika na weupe, juu ya kipara chake au paji lake la uso, huo ni ugonjwa wa kuambukiza uliojitokeza. ");
INSERT INTO swhulb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Naye kuhani atamchunguza ili kuona iwapo uvimbe wa eneo linaugua juu ya upara wake au paji lake la uso lina wekundu uliochanganyika na weupe, kama kuonekana kwa ugonjwa wa kuambukiza kwenye ngozi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Ikionekana hivyo, basi huyo ana ugonjwa wa kuambukiza naye ni najisi. Hakika kuhani atamtangaza kuwa najisi kwa sababu ya ugonjwa wake kichwani pake. ");
INSERT INTO swhulb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Mtu aliye na ugojwa wa kuambukiza atavaa nguo zilizochanika, ni lazima nywele zake ziachwe wazi, na yampasa kufunika uso wake mpaka puani na kupiga kelele, 'Najisi, najisi.' ");
INSERT INTO swhulb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Naye atakuwa najisi siku zote za ugonjwa wake wa kuambukiza. Kwa sababu anao ugonjwa unaosambaa, yapasa kuishi peke yake nje ya kambi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kuna wakati fulani vazi la mtu hupata ukungu juu yake. Laweza kuwa vazi, ama la sufu au kitani, ");
INSERT INTO swhulb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","au kitu chochote kilichosukwa au kufumwa kutokana na sufu au kitani, au ngozi au kitu chochote kilichotengenezwa kwa ngozi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Iwapo sehemu iliyochafuliwa ina rangi ya kijani au nyekundu katika vazi, ngozi, kifaa kilichosukwa au kufumwa, basi huo ni ukungu uanasambaa, ni lazima uonyeshwe kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Yapasa kuhani akichunguze hicho kifaa kwa ajili ya ukungu; ni lazima akitenge kitu chochote kilicho na ukungu kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Naye atauchunguza tena huo ukungu katika siku ya saba. Endapo utakuwa umesambaa katika kifaa hicho, basi ni wazi kwamba huo ni ukungu wenye kuangamiza, na hicho kifaa ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Na mwenye kukimiliki atalazimika kukichoma na kukiteketeza kabisa hicho kifaa kilichoonekana na ukungu ndani yake, haijalishi kiwe ni kifaa cha aina gani, kwani huo ukungu unaweza kusababisha ugonjwa. ");
INSERT INTO swhulb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Iwapo kuhani anakichunguza hicho kifaa na kuona kwamba ukungu haujaenea kwenye vazi au chombo kilichosukwa au kusokotwa kutokana na sufu, kitani au ngozi, ");
INSERT INTO swhulb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","basi atawaagiza wakisafishe hicho kifaa kilichopatikana na ukungu, naye yampasa kukitenga kwa siku saba zaidi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Kisha kuhani atakichunguza tena hicho kifaa chenye ukungu baada ya kuwa kimesafinshwa. Kama ukungu haukubadilika rangi yake, hata kama haukusambaa, kifaa hicho ni najisi. Yapasa kichomwe, haijalishi ni wapi ukungu huo utakuwa umekichafua. ");
INSERT INTO swhulb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Iwapo kuhani anakichunguza hicho kifaa, na kama ukungu umefifia baada ya kuwa umeoshwa, basi atakirarua kile kipande kilichochaufuliwa kutoka kwenye vazi au kutoka kwenye ngozi, au kutoka kwenye chombo kilichosukwa au kusokotwa. ");
INSERT INTO swhulb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ikiwa ukungu unazidi kuonekana katika vazi, ama katika chombo kilichosukwa au kufumwa, au katika kitu chochote kilichotengenezwa kwa ngozi, basi, ukungu utakuwa unasambaa. Kifaa chochote kilicho na ukungu ni lazima kichomwe. ");
INSERT INTO swhulb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Vazi au kitu chochote kilichosukwa au kufumwa kutokana na sufu, au kitani, au ngozi au kitu chochote kilichotengenezwa kwa ngozi—iwapo unakisafisha kifaa nao ukungu ukawa umetoka, nacho kifaa lazima kisafishwe mara ya pili, kisha kitakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Hii ndiyo sheria ihusuyo ukungu katika vazi la sufu au kitani, au kwenye kitu chochote kilichosukwa au kufumwa kutokana na sufu, au kitani, au kitu chochote kilichotengenewa kwa ngozi, ili kwamba mweze kuvitangaza kuwa safi au najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahwe alizungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Hii itakuwa sheria kwaajili ya mtu aliyekufa kwenye siku ya utakaso. Lazima aletwe kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kuhani atakwenda nje ya kambi kumchunguza mtu kuona kama madhara ya ugonjwa wa ngozi yameponywa. ");
INSERT INTO swhulb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Ndipo kuhani ataamuru kwamba mtu mwenye kutakaswa lazima achukue ndege safi wawili, waliohai, mti wa mwerezi, kitani nyekundu na hisopo. ");
INSERT INTO swhulb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kuhani atamwamuru kuua moja ya hao ndege juu ya maji safi yaliyo kwenye chungu cha udongo. ");
INSERT INTO swhulb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ndipo kuhani atamchukua ndege aliyehai na mti wa mwerezi, na kitani nyekundu na hisopo, na vyote hivi, pamoja na ndege aliyehai atavichovya kwenye damu ya ndege aliyechinjiwa kwenye maji safi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ndipo kuhani atanyunyiza maji haya mara saba juu ya mtu anayetakaswa katika ugonjwa, na ndipo kuhani atamtangaza kuwa msafi. Ndipo kuhani atamwachia ndege aliyehai katika eneo wazi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Mtu aliyetakaswa atafua nguo zake, atanyoa nywele zake zote, ataoga kwa maji, na ndipo atakuwa safi. Baada ya hayo lazima aje kwenye kambi, lakini ataishi nje ya hema lake kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Katika siku ya saba lazima anyoe nywele za kichwa chake, na lazima pia anyoe ndevu zake na nyusi. Lazima anyoe nywele zake zote, na lazima afue nguo zake na aoge kwenye maji; ndipo atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Katika siku ya nane lazima achukue dume wa wana kondoo wawili wasio na lawama, mwana kondoo jike wa mwaka mmoja asiye na lawama, na tatu ya kumi ya efa ya unga safi uliochanganywa mafuta kama sadaka ya nafaka, na kipimo kimoja cha mafuta. ");
INSERT INTO swhulb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kuhani ambaye amemtakasa mtu atamsimamisha mtu ambaye aliyemtakasa, pamoja na vile vitu, mbele ya Yahwe mahali pa kuingilia kwenye hema ya mkutano. ");
INSERT INTO swhulb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kuhani atachukua mmoja wa wanakondoo dume na kumtoa kama sadaka ya hatia, pamoja na kipimo cha mafuta; atavitikisa kwa sadaka ya kutikiswa mbele ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Lazima aue mwana kondoo dume mahali ambapo wanapochinjia sadaka ya dhambi na sadaka ya kuteketezwa, katika eneo la hema, sababu sadaka ya dhambi ni ya kuhani, kama afanyavyo sadaka ya hatia, kwasababu ni takatifu zaidi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kuhani atachukua baadhi ya damu ya sadaka ya hatia na kuiweka kwenye ncha ya sikio la kulia la mtu yule wa kutakaswa, katika dole gumba la kulia, katika dole la mguu wa kulia. ");
INSERT INTO swhulb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ndipo kuhani atachukua mafuta kutoka chombo na kuyamimina katika kiganja cha mkono wake wa kushoto, na kuzamisha kidole chake katika mafuta hayo yaliyo kwenye mkono wa kushoto, ");
INSERT INTO swhulb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","na kunyunyiza baadhi ya mafuta kwa kidole mara saba mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","kuhani ataweka mafuta yaliyobaki kwenye mkono wake kwenye ncha ya sikio la kulia la mtu wa kutakaswa, juu ya dole gumba la mkono wa kulia, na katika dole kubwa la mguu wa kulia. Lazima aweke mafuta haya juu ya damu kutoka kwenye sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kama kwa mafuta yaliyosalia kwamba katika mkono wa kuhani, atayaweka juu ya kichwa cha mtu ambaye atakaswaye, na kuhani atafanya utakaso kwaajili yake mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ndipo kuhani atatoa sadaka ya dhambi na kufanya upatanisho kwaajili yake atakaswaye kwa sababu ya kutokuwa safi kwake, na badaye ataua sadaka ya kuchomwa. ");
INSERT INTO swhulb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ndipo kuhani atatoa sadaka ya kuteketezwa na sadaka ya nafaka juu ya madhabahu. Kuhani atafanya upatanisho kwaajili ya mtu huyo, na ndipo atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Kwa namna hiyo, kama mtu ni masikini na hawezi kumudu matoleo haya, ndipo anaweza kuchukua kondoo mmoja dume kama sadaka ya hatia ya kutikiswa, kufanya upatanisho kwaajili yake mwenyewe, na moja ya kumi ya efa ya unga safi uliochanganywa na mafuta kama sadaka ya nafaka, na chombo cha mafuta, ");
INSERT INTO swhulb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","pamoja na njiwa wawili au kinda mbili za njiwa, ambao anaweza kupata; ndege mmoja atakuwa sadaka ya dhambi na mwingine sadaka ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Katika siku ya nane lazima awalete kwa kuhani kwaajili ya utakaso, pakuigilia katika hema ya mkutano, mbele ya Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kuhani atachukua mwana kondoo kwaajili ya sadaka, na atachukua pamoja na kiasi cha mafuta ya mzeituni, na ataviinua juu kama anaviwasilisha kwa Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Atamuua mwana kondoo kwaajili ya sadaka ya hatia, na atachukua baadhi ya ya damu ya sadaka ya hatia na kuiweka juu ya ncha ya sikio la kulia la yule wakutakaswa, juu ya dole gumba la mkono wake wa kulia, na kwenye dole kubwa la mguu, wa kulia. ");
INSERT INTO swhulb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ndipo kuhani atamimina baadhi ya mafuta katika kiganja cha mkono wake wa kushoto, ");
INSERT INTO swhulb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na atanyunyiza kwa kidole chake cha kulia baadhi ya mafuta ambayo yako kwenye mkono wa kushoto mara saba mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ndipo kuhani ataweka kiasi cha mafuta ambayo yako kwenye mkono wake kwenye ncha ya sikio la yule mtu wa kutakaswa, katika dole gumba lake la mkono wa kulia, na dole kubwa la mguu wa kulia, maeneo yale yale ambayo kaweka damu ya sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ataweka mafuta yaliyobaki yaliyo mkononi mwake juu ya yule wakutakaswa, kufanya upatanisho kwaajili yake mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Lazima atoe sadaka ya njiwa au makinda ya njiwa, yale ambayo mtu ameweza kupata - ");
INSERT INTO swhulb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","moja kama ya sadaka ya dhambi na nyingine kama sadaka ya kuteketezwa, pamoja na sadaka ya nafaka. Ndipo kuhani atafanya upatanisho kwaajili ya yule ambaye atatakaswa mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hii ni sheria kwaajili ya mtu kwake kuna athari za ugonjwa wa ngozi, ambaye hawezi kumudu kiwango cha sadaka kwaajili ya utakaso wake.” ");
INSERT INTO swhulb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahwe alizungumza na Musa na Haruni, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Wakati mtakuja katika nchi ya Kanaani ambayo nimewapa kama miliki, na kama naweka ukungu unaenea ndani ya nyumba katika nchi ya miliki yenu, ");
INSERT INTO swhulb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ndipo yeye ambaye anamiliki nyumba ile lazima aje na kumwambia kuhani. Lazima aseme 'Inaonekana kwangu kuna kitu fulani kama ukungu ndani ya nyumba yangu.'” ");
INSERT INTO swhulb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ndipo kuhani ataamuru kwamba watoe vitu vyote ndani kabla hajaenda ndani kuona uthibitisho wa ukungu, kiasi kwamba hakuna ndani ya nyumba kitakachofanywa najisi. Badaye kuhani lazima aende ndani kuona humo ndani. ");
INSERT INTO swhulb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Yeye lazima achunguze ukungu kuona kama umo katika kuta za nyumba, na kuona ikiwa kunaonekana ukijani au wekundu katika bonde za mwonekano wa kuta. ");
INSERT INTO swhulb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Kama nyumba inao ukungu, ndipo kuhani atatoka nje ya nyuma na kufunga mlango wa nyumba kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ndipo kuhani atarudi tena katika siku ya saba na kuichunguza kuona kama ukungu umeenea katika kuta za nyumba. ");
INSERT INTO swhulb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Kama hivyo, ndipo kuhani ataamuru kwamba wayaondoe mawe ambayo ukungu umepatikana na yatupwe katika sehemu najisi nje ya mji. ");
INSERT INTO swhulb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Yeye atataka kuta zote za ndani ya nyumba zikwanguliwe, na lazima achukue vitu vilivyochafuliwa na hivyo vilivyokwanguliwa nje ya mji na kuvitupa kwenye eneo lisilosafi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Lazima wayachukue mawe mengine na kuyaweka katika sehemu ya mawe yaliyoondolewa, na lazima watumie udongo mpya kupigia lipu nyumba. ");
INSERT INTO swhulb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kama ukungu unakuja tena na unaingia katika nyumba ambayo mawe yameondolewa na kuta zimekwanguliwa na kupigwa lipu upya, ");
INSERT INTO swhulb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ndipo kuhani lazima aje aingie ndani na kuchunguza nyumba kuona kama ukungu umeenea ndani ya nyumba. Kama hivyo, huo ni ukungu mbaya, na nyumba ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Nyumba hiyo lazima iangushwe chini. Hayo mawe, mbao, na lipu yote ndani ya nyumba lazima vibebwe kupelekwa nje ya mji kwenye sehemu najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kwa nyongeza, yeyote anaenda ndani ya nyumba wakati imefungwa atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Na yeyote aliyelala ndani ya nyumba lazima afue nguo zake, na yeyote aliyekula ndani ya nyumba lazima afue nguo zake. ");
INSERT INTO swhulb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kama kuhani akaingia hiyo kuichunguza kuona ikiwa ukungu umeenea katika nyumba baada ya nyumba kupigwa lipu, ndipo, kama ukungu umetoweka, ataitangaza nyumba hiyo kuwa ni safi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ndipo kuhani lazima achukue ndege wawili kuitakasa nyumba, na mti wa mwelezi, na sufu nyekundu, na hisopo. ");
INSERT INTO swhulb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Atamuua ndege mmojawapo katika maji masafi kwenye dumu la udongo. ");
INSERT INTO swhulb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Atachukua mti wa mwerezi, hisopo, sufu nyekundu na ndege aliyehai, na kuvichovya kwenye damu ya ndege aliyekufa, kwenye maji safi, na kunyunyizia nyumba mara saba. ");
INSERT INTO swhulb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ataitakasa nyumba kwa damu ya ndege na maji safi, pamoja na ndege aliyehai, mti wa mwerezi, hisopo, na sufu nyekundu. Lakini atamwachia ndege aliyehai aende nje ya mji mashambani. ");
INSERT INTO swhulb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kwa njia hii lazima afanye upatanisho kwaajili ya nyumba, na itakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Hii ni sheria kwa aina zote za athari ya ugonjwa wa ngozi na vitu vyote vinavyosababisha ugonjwa kama huo, na kwaajili ya kuwashwa, ");
INSERT INTO swhulb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na kwa ukungu kwenye mavazi na nyumba, ");
INSERT INTO swhulb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kwaajili ya uvimbe, kwaajili ya vipele, madoa, ");
INSERT INTO swhulb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kutambua wakati wowote tatizo hili ni najisi au lini limetakaswa. Hii ni sheria kwaajili ya athari za ugonjwa wa ukungu. ");
INSERT INTO swhulb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahwe alizungumza na Musa na Haruni, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Waambie watu wa Israeli, na sema kwao, 'Wakati mtu yeyote kisonono kimemwathiri mwili wake unatoa ugiligili, anakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Unajisi wake unatokana na athari ya kisonono. Iwe mwili wake unatoa ugiligili au umekoma, huo ni unajisi.” ");
INSERT INTO swhulb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kitanda chochote anachokilalia kitakuwa najisi, na kila kitu ambacho anakaa juu yake kitakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Yeyote anayegusa kitanda chake lazima afue nguo zake na aoge kwenye maji, na awe amenajisika mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Yeyote anayekaa katika kitu chochote ambacho mtu ambaye ameathiriwa na kisonono alikaa, mtu huyo lazima afue nguo zake na aoge katika maji, na atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Na yeyote anayegusa mwili wa ambaye ameathirika na kisonono lazima afue nguo zake na aoge katika maji, na awe najisi hadi jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kama mtu ambaye anaona majimaji kama hayo kwa mtu fulani ambaye ametakasika, ndipo mtu huyo lazima afue nguo zake na aoge kwenye maji, na atakuwa najisi hata jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Tandiko lolote ambalo ambaye anamajimaji ya kisonono atalikalia litakuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Yeyote anayegusa kitu chochote kilichokuwa chini ya mtu huyo atakuwa najisi mpaka jioni, na yeyote anayebeba vitu hivyo lazima afue nguo zake na aoge katika maji; atanajisika mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ambaye anamajimaji kama hayo akimgusa kabla kwanza ya kuosha kwa maji safi mikono yake, mtu aliyeguswa lazima afue nguo zake na aoge katika maji, na atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Chungu chochote cha udongo ambacho ambaye anamajimaji kama hayo akigusa lazima kivunjwe, na kila chombo cha mti lazima kioshwe na maji safi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Wakati mwenye kisonono anapotakaswa katika kisonono chake, ndipo lazima ahesabu kwaajili yake siku saba kwaajili ya kutakasika kwake; ndipo afue nguo na aoshe mwili wake kwenye maji yatiririkayo. Ndipo atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Katika siku ya nane lazima achukue njiwa wawili au kinda mbili za njiwa na aje mbele za Yahwe pakuingilia kwenye hema ya mkutano; pale lazima atoe hao ndege kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Lazima kuhani awatoe, moja kama sadaka ya dhambi na nyingine kama ya kuteketezwa, na kuhani lazima afanye upatanisho kwaajili yake mbele za Yahwe kwaajili ya kisonono chake. ");
INSERT INTO swhulb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kama mtu yeyote ametokwa na shahawa, ndipo lazima aoge mwili wake wote katika maji; atanajisika mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kila vazi au ngozi ambayo juu yake kuna shahawa lazama paoshwe kwa maji; itakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Na kama mwanamke na mwanaume watalala pamoja na kunakutokwa kwa shahawa kwenda kwa mwanamke, lazima wote wawili waoge katika maji; watakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Mwanamke anapokuwa kwenye hedhi, ataendelea kunajisika kwa siku saba, na yeyote anayemgusa atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Chochote anacholala juu yake wakati wa hedhi kitakuwa najisi; kila kitu ambacho anakalia kitakuwa pia najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Yeyote anayegusa kitanda chake lazima afue nguo zake na aoge kwa maji; mtu huyo atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Yeyote anayegusa chochote ambacho amekikalia lazima afue nguo zake na aoge kwa maji; mtu huyo anakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Iwe juu ya kitanda au kitu chochote juu ya popote atakapokaa, kama akikigusa, mtu huyo atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kama mwanaume yeyote akilala naye, na unajisi wa mwanamke ukamgusa, atakuwa amenajisika siku saba. Kila kitanda ambacho anakilalia mwanaume huyo kitanajisika. ");
INSERT INTO swhulb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kama mwanamke ametokwa damu kwa siku nyingi ambayo siyo kipindi cha hedhi yake, au ikitoka zaidi ya kipindi chake cha hedhi, wakati wote wa siku za kunajisika, atakuwa kama alikuwa kwenye siku zake za hedhi. Yeye ni najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kila kitanda anachokilalia wakati wote wa kutokwa damu itakuwa kwake sawa tu kama kitanda anacholalia wakati wa hedhi, na kila kitu ambacho anakalia kitakuwa najisi, kama tu unajisi wa hedhi yake. ");
INSERT INTO swhulb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Na yeyote anayegusa kitu kati ya vitu hivyo atakuwa najisi; lazima yeye afue nguo zake na aoge mwenyewe kwenye maji, na atakuwa amenajisika mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Lakini kama mwanamke ametakasika katika kutokwa na damu, ndipo atahesabu kwaajili yake siku saba, baada ya hizo atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Katika siku ya nane atachukua kwake njiwa wawili au kinda wawili wa njiwa na atawaleta kwa kuhani pakuingilia hema ya mkutano. ");
INSERT INTO swhulb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Huyo kuhani atatoa ndege mmoja kama sadaka ya dhambi na mwingine kama sadaka ya kuteketezwa, na atafanya upatanisho kwaajili ya huyo mbele ya Yahwe kwaajili unajisi wa mwanamke atokwaye damu. ");
INSERT INTO swhulb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Hivi ndivyo lazima uwatenge watu wa Israeli katika unajisi wao, hivyo hawatakufa tokana na unajisi wao, kwa kuchafua hema langu, ambapo naishi kati yao. ");
INSERT INTO swhulb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Huu ndio utaratibu kwa kila ambaye anakisonono, kwaajili kila mwanaume ambaye shahawa yake inatoka na inamfanya kuwa najisi, ");
INSERT INTO swhulb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kwaajili ya mwanamke ambaye yuko katika kipindi cha hedhi, kwaajili ya yeyote aliye na kisonono, awe mwanaume au mwanamke, na kwaajili ya yeyote anayelala na mwanamke najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahwe alizungumza na Musa - hii ni baada vifo vya wana wawili wa Haruni, walipomkaribia Yahwe na ndipo wakafa. ");
INSERT INTO swhulb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahwe alimwambia Musa, “Ongea na Haruni kaka yako na umwambie hapana kuja tu wakati wowote katika patakatifu pa patakatifu ndani ya pazia, mbele ya kifuniko cha upatanisho kilicho juu ya sanduku. Akifanya hivyo, anakufa, kwasababu naonekana katika wingu juu ya kifuniko cha upatanisho. ");
INSERT INTO swhulb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Hivi ndivyo jinsi Haruni lazima aje katika patakatifu pa patakatifu. Yeye lazima aingie pamoja na ndama kama sadaka ya dhambi, na kondoo dume kama sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ni lazima avae kanzu ya kitatani, na lazima avae ndani yake nguo ya kitani, na lazima avae mshipi wa kitani na kilemba cha kitani. Haya ni mavazi matakatifu. Lazima aoge mwili wake katika maji na avae mavazi haya. ");
INSERT INTO swhulb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Lazima achukue kwenye umati wa watu wa Israeli mbuzi wawili waume kama sadaka ya dhambi na kondoo dume moja ikiwa ni sadaka ya kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ndipo Haruni lazima alete ng'ombe kama sadaka ya dhambi, ambayo itakuwa kwaajili yake mwenyewe, kufanya upatanisho kwaajili yake mwenyewe na familia yake. ");
INSERT INTO swhulb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ndipo lazima achukue mbuzi wawili na kuwaweka mbele ya Yahwe katika mlango wa kuingilia kwenye hema ya mkutano. ");
INSERT INTO swhulb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ndipo Haruni lazima apige kura kwaajili ya mbuzi hao wawili, kura moja kwaajili ya Yahwe, na kura nyingine kwaajili ya msingiziwa. ");
INSERT INTO swhulb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ndipo Haruni lazima awasilishe mbuzi ambaye kura imeangukia kwa Yahwe, na kumtoa mbuzi huyo kama sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Lakini mbuzi ambaye kura ya usingiziwa imemwangukia lazima aletwe kwa Yahwe akiwa hai, kufanya upatanisho kwa kumwachia aende porini kama, mbuzimsingiziwa. ");
INSERT INTO swhulb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Pia Haruni lazima alete ng'ombe kwaajili ya sadaka ya dhambi, ambayo itakuwa kwaajili yake mwenyewe, lazima afanye upatanisho kwaajili yake mwenyewe na familia yake, hivyo lazima yeye amuue huyo ng'ombe kama sadaka ya dhambi kwaajili yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Haruni lazima achukue chetezo iliyojaa mkaa wa moto kutoka kwenye madhabahu mbele ya Yahwe, na mikono imejaa ubani mzuri, na kuleta vitu hivi ndani ya pazia. ");
INSERT INTO swhulb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Hapo lazima aweke ubani juu ya moto mbele za Yahwe ili kwamba wingu kutoka kwenye ubani liweze kufunika kifuniko cha agano la imani ya upatanisho. Yeye afanye hivyo ili kwamba asife. ");
INSERT INTO swhulb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ndipo lazima achukue kiasi cha damu ya ng'ombe na kuinyunyiza kwa kidole chake mbele ya kifuniko cha upatanisho. Lazima anyunyize kiasi cha damu kwa kidole chake mara saba mbele ya kifuniko cha upatanisho. ");
INSERT INTO swhulb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ndipo lazima aue mbuzi kwaajili ya sadaka ya dhambi ambayo ni kwaajili ya watu na kuileta damu yake ndani kwenye pazi. Hapo lazima aifanyie damu kama alivyofanya kwenye damu ya fahali: lazima ainyunyize juu ya kifuniko cha upatanisho na mbele ya kifunuko cha upatanisho. ");
INSERT INTO swhulb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yeye lazima afanye upatanisho kwaajili ya mahali patakatifu kwa sababu ya matendo ya unajisi ya watu wa Israeli, na kwa sababu ya uasi na dhambi zao zote. Yeye pia lazima afanye haya kwaajili ya hema ya mkutano, ambapo Yahwe anaishi kati yao, katika uwepo wa matendo yao ya unajisi. ");
INSERT INTO swhulb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Hakuna mtu anayetakiwa kuwepo katika hema ya mkutano wakati Haruni anaingia kufanya upatanisho katika mahali patakatifu pa patakatifu, na mpaka atoke nje na amemaliza kufanya upatanisho kwaajili yake mwenyewe na kwaajili ya familia yake, na kwaajili umati wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Yeye lazima aende nje kwenye madhabahu hapo mbele za Yahwe na kufanya upatanisho kwaajili ya hiyo, na lazima achukue kiasi cha damu ya mbuzi na kuiweka juu ya pembe za madhabahu yote kuzunguka. ");
INSERT INTO swhulb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Anatakiwa anyunyize kiasi cha damu juu yake kwa kidole chake mara saba kuitakasa na kuitenga maalumu kwa Yahwe, mbali kutoka matendo ya unajisi wa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Atakapo maliza kupatanisha kwaajili ya mahali patakatifu sana, hema la mkutano, na madhabahu, lazima amlete mbuzi aliyehai. ");
INSERT INTO swhulb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruni lazima aweke mikono yake yote juu ya kichwa cha mbuzi huyu aliyehai na akiri juu yake maovu yote ya watu wa Israeli, uasi wao wote, dhambi zao zote. Ndipo lazima aweke dhambi hizo juu ya kichwa cha mbuzi na amwachie katika uangalizi wa mtu aliyetari kumwongoza mbuzi huyo porini. ");
INSERT INTO swhulb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mbuzi lazima abebe juu yake mwenyewe uovu wote kwenda mahali pakiwa. Kule msituni, huyo mtu amwache mbuzi aende huru. ");
INSERT INTO swhulb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ndipo Haruni anapaswa kwenda tena humo kwenye hema ya mkutano na kuvua mavazi ya kitani ambayo amayavaa kabla hajaenda mahali patakatifu sana, na anatakiwa kuyaacha mavazi hayo pale. ");
INSERT INTO swhulb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Anapaswa aoshe mwili wake kwa maji mahali patakatifu, na avae nguo zake za kawaida; pia lazima atoke nje kutoa sadaka ya kuteketezwa na sadaka ya kuteketezwa na sadaka ya kuteketezwa kwaajili ya wale watu, na kwa njia hii anafanya upatanisho kwaajili yake mwenyewe na kwaajili ya watu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Lazima yeye achome mafuta ya sadaka ya dhambi juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Huyu mtu anayemwacha mbuzi msingiziwa aende huru anafua nguo zake na kuosha mwili wake katika maji; baada ya hayo, anaweza kurudi tena kambini. ");
INSERT INTO swhulb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Yule fahali kwaajili ya sadaka ya dhambi na mbuzi kwaajili ya sadaka za dhambi, ambaye damu yake ililetwa kufanya upatanisho katika mahali patakatifu, lazima ipelekwe nje ya kambi. kule lazima wachome, ngozi zao, nyama yao na kinyesi chao. ");
INSERT INTO swhulb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Huyu anayechoma sehemu hizo lazima afue nguo zake na aoge mwili wake katika maji; baada ya hapo, anaweza kurudi tena kwenye kambi. ");
INSERT INTO swhulb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hii itakuwa sharti kwaajili yenu kwamba katika mwezi wa saba, kwenye siku ya kumi ya mwezi, mtanyenyekea wenyewe na msifanye kazi, iwe mwenyeji wa kuzaliwa au mgeni anayeishi kati yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Hii ni kwasababu katika siku hii ya upatanisho utafanywa kwaajili yenu, kuwatakasa ninyi kutoka dhambi zenu zote ili mwe safi mbele za Yahwe. ");
INSERT INTO swhulb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hii ni maalumu kwa Sabato ya kupumzika kwaajili yenu, na lazima mnyenyekee wenyewe na msifanye kazi. Hili litakuwa sharti kati yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kuhani mkuu, ambaye atapakwa mafuta na kuwekwa wakfu kuwa kuhani mkuu katika nafasi ya baba yake, lazima afanye upatanisho huu na kuvaa mavazi ya kitani, hayo ni mavazi matakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Lazima afanye upatanisho kwaajili ya mahali patakatifu sana; lazima afanye upatanisho kwaajili ya hema ya mkutano na madhabahu, na lazima afanye upatanisho kwaajili ya makuhani na kwaajili ya kusanyiko la watu. ");
INSERT INTO swhulb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Hii daima itakuwa sharti kwaajili yako, kufanya upatanisho kwaajili ya watu wa Israeli kwasababu ya dhambi zao zote, mara moja kwa kila mwaka.” Na ilikuwa ikifanika kama Yahwe alivyomwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh akamwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Zungumza na Aroni na wanawe, na watu wote wa Israeli. Waambie mambo ambayo ameamru Yahweh: ");
INSERT INTO swhulb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mtu yeyote wa Isreli anayeua fahali au mwana—kondoo au mbuzi kambini, au amuuaye nje ya kambi, ili kumtoa dhabihu— ");
INSERT INTO swhulb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kama hamleti katika ingilio la hema la kukutania ili kumtoa dhabihu kwa Yahweh mbele za hema lake la kukutania, mtu huyo ana hatia ya damu iliyomwagika. Amemwaga damu, na mtu huyo ni sharti akatiliwe mabali kutoka miongoni mwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kusudi la amri hii ni kwamba watu wa Israeli wataleta dhabihu zao kwa Yahweh kwenye ingilio la hema la kukutania, watazileta kwa kuhani ziweze kutolewa kuwa matoleo ya shukrani kwa Yahweh, badala ya kutoa dhabihu hadharani katika shamba. ");
INSERT INTO swhulb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kuhani atainyunyiza damu juu ya madhabahu ya Yahweh kwenye ingilio la hema la kukutania; atayachoma mafuta yake ili kutoa harufu ya kupendeza mbele za Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ni lazima watu wasitoe tena dhabihu zao kwa sanamu za mbuzi, ambazo kwazo hutenda kama makahaba. Hili litakuwa agizo la kudumu kwa ajili yao katika vizazi vya watu wao vyote. ");
INSERT INTO swhulb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ni lazima uwaambie, 'Mtu yeyote wa Israeli, au Mgeni yeyote aishiye miongoni mwao, atoweye dhabihu ");
INSERT INTO swhulb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na asiilete kwenye ingilio la hema la kukutania ili kuitoa kwa Yahweh, mtu huyo ni lazima akatiliwe mbali kutoka kwa watu wake.' ");
INSERT INTO swhulb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Na Mtu yeyote wa Israeli, au yeyote wa Wageni anayeishi miongoni mwao, ambaye hunywa damu; nitamkatilia mbali atoke miongoni mwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kwa kuwa uhai wa mnyama yeyote umo katika damu yake. Nimeitoa damu yake kwenu kufanya upatanisho juu ya madhabahu kwa ajili ya uhai wenu, kwa sababu ni damu ndiyo ifanyayo upatanisho, kwa kuwa ni damu ipatanishayo kwa ajili ya uhai ");
INSERT INTO swhulb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kwa hiyo Niliwaambia Watu wa Israeli kwamba hayupo miongoni mwenu impasaye kula damu, wala yeyote wa Wageni aishiye miongoni mwenu atakaye kula damu. ");
INSERT INTO swhulb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Na yeyote miongoni mwa watu wa Israeli, au yeyote wa Wageni aishiye miongoni mwenu ni lazima aimwage damu ya mnyama na kuifukia hiyo damu kwa mafumbi. ");
INSERT INTO swhulb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kwa kuwa uhai wa kila kiumbe umo katika damu yake. Ni kwa sababu hii niliwaambia watu wa Israeli, ni lazima msile damu ya kiumbe cho chote, kwa kuwa maisha ya kila kiumbe chenye uhai ni damu yake. Yeyeote ailaye ni lazima akatiliwe mbali. ");
INSERT INTO swhulb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Mtu yeyote alaye mnyama aliyekufa au ambaye amelaruliwa na wanyama pori, ama yule mtu ni mwenyeji wa kuzaliwa au ni mgeni aishiye miongoni mwenu, ni lazima atazifua nguo zake na kujiosha katika maji, naye atakuwa najisi hata jioni. Kisha atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Lakini kama hazifui nguo zake au kuosha mwili wake, ni lazima aichukue hatia yake”. ");
INSERT INTO swhulb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh akazungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Zungumza na watu wa Israeli na uwaambie, “Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Msitende mambo ambayo watu wa Misri huyatenda, mahali mlikokuwa mkiishi awali. Na ni lazima msitende mambo yale wanayoyatenda watu wa Kanaani, nchi ambayo ninawapeleka nyinyi. Msifuate desturi zao. ");
INSERT INTO swhulb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Sheria zangu ndizo mtakazozitenda, na amri zangu ndizo mtakazozishika, kwa sababu Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kwa hiyo ni lazima mzitunze hukumu zangu na sheria zangu. Ikiwa mtu amezitii, ataishi kwa sababu ya hizo. Mimi Ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Pasiwepo kwenu atakayelala na yeyote aliye na uhusiano wa karibu naye. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Usimfedheheshe baba yako kwa kulala na mama yako. Yeye ni mama yako! Haikupasi kumfedhehesha yeye. ");
INSERT INTO swhulb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Usilale na yeyote wa wake za baba yako; Usimfedheheshe namna hiyo baba yako. ");
INSERT INTO swhulb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Usilale na yeyote aliye mmoja miongoni mwa dada zako, ama ni binti ya baba yako au ni binti ya mama yako, ama aliyelelewa nyumbani mwenu au mbali nawe. Usilale na dada zako. ");
INSERT INTO swhulb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Usilale na binti ya mwanao, au binti ya binti yako. Hiyo ingekuwa aibu yako mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Usilale na binti ya mke wa baba yako, aliyezaliwa kwa baba yako, yeye ni dada yako, na usilale naye. ");
INSERT INTO swhulb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Usilale na dada ya baba yako. Yeye ni ndugu wa karibu kwa baba yako. ");
INSERT INTO swhulb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Usilale na dada ya mama yako. Yeye ni ndugu wa mama yako. ");
INSERT INTO swhulb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Usimfedheheshe ndug wa baba yako kwa kulala na mke wake. Usimkaribie kwa kusudi hilo; yeye ni shangazi yako. ");
INSERT INTO swhulb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Usilale na binti- mkwe wako, Yeye ni mke wa mwanao; usilale naye. ");
INSERT INTO swhulb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Usilale na mke wa kaka yako; usije ukamfedhesha yeye katika njia hii. ");
INSERT INTO swhulb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Usilale na mwanamke kisha na binti yake, au binti wa mwanawe au binti wa binti yake. Hao ni ndugu zake wa karibu, na kulala nao lingekuwa ni uovu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Usimwoe dada ya mke wako kuwa mke wako wa pili na kulala naye wakati bado mke wako wa kwanza angali hai. ");
INSERT INTO swhulb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Usilale na mwanamke wakati wake wa hedhi. ");
INSERT INTO swhulb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Yeye ni najisi kwa wakati huo. Usilale na mke wa jilani yako na kujichafua mwenyewe kwake katika njia hii. ");
INSERT INTO swhulb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Msiwatoe watoto wenu ili kuwapitisha kwenye moto, ili kwamba muwatoe sadaka kwa Moleki, kwa sababu msije mkalinajisi jina la Mungu wenu. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Usilale na mwanaume mwingine kama ulalavyo na mwanamke. Jambo hili lingekuwa uovu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Usilale na myama yeyote na kujitia unajisi kwake. Haimpasi mwanamke kufikiria kulala na mnyama ye yote. Huo ungekuwa upotovu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Msijichafue wenyewe katika njia hizi, kwa kuwa katika njia hizi mataifa yamechafuliwa, mataifa ambayo Nitayafukuza yatoke kwa ajili yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ni kwa sababu nchi imenajisiwa, hivyo niliiadhibu dhambi yao, nayo nchi ikawatapika wakazi wake ");
INSERT INTO swhulb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Kwa hiyo, yawapasa kuzishika amri zangu na maagiza yangu, na msifanye aina yoyote ya mambo haya ya machukizo, wala Mwisraeli mzaliwa au Mgeni aishie miongoni mwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kwa kuwa ni uovu huu ambao watu wametenda, wale ambao waliishi hapa kabla yenu, na sasa nchi imenajisiwa. ");
INSERT INTO swhulb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Kwa hiyo, muwe waangalifu ili kwamba nchi isiwatapike nyinyi baada ya kuwa mmeinajisi, kama ilivyowatapika wale watu waliokuwako kabla yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Yeyote anayefanya mambo haya ya kuchukiza, watu wafanyao mambo hayo ya kuchukiza lazima watakatiliwa mbali kutoka miongoni mwa watu wao. ");
INSERT INTO swhulb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Kw a hiyo inawapasa kuzishika amri zangu na sitende mojawapo ya desturi hizi zenyekuchukiza ambazo zilitendwa hapo kabla yenu, ili msijinajisi wenyewe kwa hizo. Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahweh akazungumza na Musa, akisema. ");
INSERT INTO swhulb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Zungumza na kusanyiko lote la watu wa Israeli na uwaambie, 'Ni lazima muwe watakatifu, kwa kuwa mimi Yahweh Mungu wenu ni mtakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kila mtu amstahi mama yake na baba yake. Na ni lazima muzishike Sabato zangu. Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Msizigeukie sanamu zisizo na thamani, wala kujitengenezea wenyewe miungu kutokana na chuma. Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Unapotoa dhabihu za sadaka ya ushirika kwa Yahweh, utatoa ili kupata kibali. ");
INSERT INTO swhulb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ni sharti iliwe siku hiyo hiyo uliyoitoa, au siku inayofuata. ");
INSERT INTO swhulb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kama kinabaki kitu cho chote hata siku ya tatu ni lazima kiteketezwe kwa moto. Kama kitaliwa katika siku ya tatu kitakuwa najisi. Hakitakubalika, ");
INSERT INTO swhulb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","lakini kila akilaye ni lazima atachukua hatia yake kwa sababu amekivunjia heshima kilicho kitakatifu kwa Yahweh. Mtu huyo ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Unapovuna mavuno ya ardhi yako, usivune hata pembezo mwa shamba lako kabisa, wala hutakusanya mabaki ya mavuno yako yote. ");
INSERT INTO swhulb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Usikusanye kila zabibu kutoka katika mizabibu yako, wala usiziokote dhabibu zilizoanguka chini katika shamba la mizabibu. Ni lazima uziache kwa ajili ya masikini na kwa ajili ya wageni. Mimi ndimi Yahweh Mungu wako. ");
INSERT INTO swhulb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Usiibe. Usiseme uongo. Msidanganyane. ");
INSERT INTO swhulb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Usiape kwa jina langu kwa uongo na kulinajisi jina la Mungu wako. Mimi ndimi Yahweh ");
INSERT INTO swhulb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Usimgandamize jirani yako wala kumwibia. Usishikilie malipo ya kibarua usiku kucha hata asubuhi. ");
INSERT INTO swhulb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Usimlaani kiziwi au kuweka kikwazo mbele ya kipofu. Badala yake, yakupasa umwogope Mungu wako. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Usisababishe hukumu ikawa ya uongo. Usionyeshe upendeleo kwa mtu fulani eti kwa kuwa tu yeye ni masikini na usionyeshe upendeleo kwa mtu fulani eti kwa kuwa tu yeye ni mtu muhimu. Badala yake, amua juu ya jirani yako kwa haki. ");
INSERT INTO swhulb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Usiende huku na huko ukisema habari za uchochezi miongoni mwa watu wako, bali tafuta kuyalinda maisha ya jirani yako. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Usimchukie ndugu yako moyoni mwako. Mkemee jirani yako kwa heshima ili kwamba usishiriki katika dhambi kwa sababu yake. ");
INSERT INTO swhulb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Usijilipize kisasi au kuwa na chuki yoyote dhidi ya mtu yeyote wa watu wako, lakini badala yake mpende jirani yako kama unavyojipenda wewe mwenyewe. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Shika amri zangu. Usiwazalishe wanyama wako kwa kutumia wanyama wa aina nyingine tofauti. Usichanganye aina mbili tofauti za mbegu unapopanda shamba lako. Usivae vazi lililofumwa kwa kutumia nyuzi za rangi mbili tofauti zilizochanganywa pamoja. ");
INSERT INTO swhulb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Yeyote anayelala na msichana mtumwa aliyeposwa na mume mwingine, lakini ambaye hajakombolewa au hajaachwa huru, lazima waadhibiwe. Hawatauawa kwa sababu yule msichana hakuwa huru. ");
INSERT INTO swhulb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ni lazima mtu huyo alete sadaka yake ya hatia kwenye ingilio la hema la kukutania—kondoo dume iwe sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kisha kuhani atafanya upatanisho kwa ajili yake kwa huyo kandoo dume mbele za Yahweh kutokana na dhambi aliyoitenda. Nayo dhambi iliyotendwa itasamehewa. ");
INSERT INTO swhulb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Mtakapoingia katika nchi na kupanda aina zote za miti kwa chakula, kisha mtayahesabu matunda yatakayozaliwa kuwa yamekatazwa kuliwa. Tunda litakatazwa kwako kwa miaka mitatu. Halitaliwa. ");
INSERT INTO swhulb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Lakini katika mwaka wa nne matunda yote yatakuwa matakatiifu, matoleo ya sifa kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Katika mwaka wa tano unaweza kula tunda, ambalo umelisubiri ili kwamba mti uweze kuzaa zaidi. Mimi ndimi Yahweh Mungu wako. ");
INSERT INTO swhulb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Usile nyama yoyote amabayo damu ingalimo ndani yake. Usiulize kwa roho juu ya wakati ujao, ");
INSERT INTO swhulb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Usitafute kuwadhibiti wengine kwa njia ya nguvu za kichawi. Msifuate tabia za kipagani kama vile kunyoa denge au kunyoa pembe za ndevu zeu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Usiukate mwili wako kwa ajili ya wafu au kuchanja chale juu ya mwili wako. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Usimwaibishe binti yako kwa kumfanya kahaba, la sivyo taifa litaangukia kwenye ukahaba na nchi itajawa na uovu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Utazitunza Sabato zangu na kupaheshimu mahali patakatifu pa hema langu la kukutania. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Msiwageukie wale wanaoongea na wafu au roho wachafu. msiwatafute, la sivyo watawanajisi ninyi, Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ni lazima usimame mbele za mtu mwenye mvi na uheshimu uwepo wa mzee. Yakupasa umwegope Mungu wako. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Mgeni anapoishi miongoni mwenu katika nchi yanu, usimtendee lolote lililobaya. ");
INSERT INTO swhulb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mgeni anayeishi pamoja nanyi ni lazima awe kama mwenyeji Mwisraeli mzaliwa anayeishi kwenu, na sharti umpende kama unavyojipenda wewe mwenyewe, ni kwa sababu wewe ulikuwa mgeni katika nchi ya Misri. Mimi ndimi Yahweh Mungu wako. ");
INSERT INTO swhulb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Unapopima urefu, uzito, au wingi usitumie vipimo vya udanganyifu. ");
INSERT INTO swhulb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tumia mizani iliyo halali, mawe ya kupimia uzito yaliyo halali, efa halali, hini iliyo halali. Mimi ndimi Yahweh Mungu wako, aliyekutoa katika nchi ya utumwa ya Misri. ");
INSERT INTO swhulb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Utayatii maagizo yangu na sheria zangu zote na kuzitenda. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh akazungumza na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Waambie watu wa Waisraeli, 'mtu yeyote miongoni mwa watu Israeli, au Mgeni yeyote anayeishi miongoni mwa Waisraeli atakayemtoa mtoto wake yeyote kwa Moleki, hakika atauawa. Ni lazima watu wa nchi wamponde kwa mawe. ");
INSERT INTO swhulb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Pia nitaukaza uso wangu dhidi ya mtu huyo na kumkatilia mbali kutoka miongoni mwa watu wake kwa sababu amemtoa mtoto wake kwa Moleki, ili kupatia unajisi mahali pangu patakatifu na kulinajisi jina langu takatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Na kama watu wa nchi watayafumba macho yao kwa mtu huyo anapomtoa mmoja wa watoto wake kwa Moleki, kama hawatamwua mtu huyo, ndipo Mimi mwenyewe nitaukaza uso wangu dhidi ya mtu huyo na ukoo wake, ");
INSERT INTO swhulb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Nami nitamkatilia mbali pamoja na yeyote anayejifanya kahaba ili kufanya umalaya na Moleki. ");
INSERT INTO swhulb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Mtu yule anayewageukia wanaozungumza na wafu, au na wale wanaozungumza na roho ili kufanya ukahaba nao, Nitakaza uso wangu dhidi ya mtu huyo; Nami nitamkatilia mbali atoke miongoni mwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kwa hiyo jitakaseni wenyewe na muwe watakatifu, kwa sababu Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mtazitunza amari zangu na kuzifuta. Mimi ndimi Yahweh anayewatenga ninyi muwe watakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Yeyote amlaaniye baba yake au mama yake hakika mtu huyo atauawa. Amemlaani baba yake au mama yake, kwa hiyo ana hatia na anastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Mwanaume yeyote afanyaye uzinzi na mke wa mwanaume mwingine, yaani, yeyote anayezini na mke wa jirani yake—yule mwanaume mzinzi na mwanamke mzinzi ni lazima wote wawili wauawe. ");
INSERT INTO swhulb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Mwanaume yeyote anayelala na mke wa baba yake ili kukutana naye kimwili amemfedhehesha baba yake mwenye. Wote wawili; mwana huyo na mke huyo wa baba yake kwa hakika watauawa. wanahatia na wanastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kama mwanaume atalala na mke wa mwanawe, wote wawili; mwanaume huyo na mke huyo wa mwanawe hakika watauawa. Wametenda upotovu. Wana hatia na wanastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kama mwanaume analala na mwanaume mwingine kama alalavyo na mwanamke, wote wawili watakuwa wamefanya jambo lililo ovu. Hakika watauawa. Wana hatia na wanastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ikiwa mwanaume atamwoa mwanamke na pia akamwoa mama wa mwanamke huyo, huu ni uovu. Ni lazima wachomwe kwa moto, wote wawili, mwanaume huyo na manamke huyo, ili kwamba hapatakuwepo na uovu miongoni mwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ikiwa mwanaume analala na mnyama, hakika atauawa, ni lazima mumuue na mnyama huyo pia. ");
INSERT INTO swhulb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ikiwa mwanamke anamkaribia mnyama ili kulala naye, ni lazima mmuuwe mwanamke huyo pamoja na mnyama. Kwa hakika ni lazima wauawe. wana hatia na wanastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ikiwa mwanaume analala na dada yake, ama ni binti ya baba yake au binti ya mama yake—ikiwa wamelala pamoja, hilo ni jambo la aibu. Ni lazima wakatiliwe mbali watoke machoni pa watu wao, kwa sababu amelala na dada yake. Ni lazima aibebe hatia yake. ");
INSERT INTO swhulb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kama mwanaume analala na mwanamke katika kipindi cha hedhi yake, na amekutana naye kimwili, atakuwa amefunua mtiririko wa damu yake, chanzo cha damu yake. Ni lizima wote wawili wakatiliwe mbali kutoka mingoni mwa watu wao. ");
INSERT INTO swhulb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Usilale na dada ya mama yako, au dada ya baba yako, kwa sababu ungeweza kumwaibisha jamaa yako wa karibu. Ni lazima utabeba hatia yako mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ikiwa mwanaume analala na shangazi yake, atakuwa amemfedhehesha mjomba wake. Wanapokufa, nitawaadhibu wote wawili, na wanapokufa nitauondolea mbali urithi wa watoto wao ambao wangeliupokea kutoka kwa wazazi wao. ");
INSERT INTO swhulb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ikiwa mwanaume anamwoa mke wa kaka yake wakati ambapo kaka yake angali hai, hilo ni jambo la aibu. Amemfedhehesha kaka yake, na nitaondolea mbali mali yoyote amabayo watoto wao wangerithi kutoka kwa wazazi wao. ");
INSERT INTO swhulb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Kwa hiyo imewapasa kuzishika amri na sheria zangu zote; ni lazima mzitii ili kwamba ile nchi ambayo ninawaleta kuishi isiwatapike nyinyi. ");
INSERT INTO swhulb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Msienende katika desturi za mataifa ambayo nitayafukuza mbele yenu, ni kwa sababu wamefanya mambo haya yote, nami mimewachukia wao. ");
INSERT INTO swhulb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Nami nikawaambia ninyi, “Mtaimiliki nchi yao, nitaitoa kwenu ili muimiliki, nchi itiririkayo amaziwa na asali. Mimi ndimi Yahweh Mungu wenu, aliyewatenga nyinyi kutoka kwa watu wengine. ");
INSERT INTO swhulb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ni lazima pia mtofautishe kati ya wanya najisi na wale walio safi, na kati ya ndege walio najisi na walio safi. Msijichafue wenyewe kwa wanyama au ndege au kiumbe kitambaacho juu ya nchi kilicho najisi, ambacho nimekitenga kuwa najisi. ");
INSERT INTO swhulb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mtakuwa watakatifu, kwa kuwa Mimi, Yahweh, ni mtakakatifu, nami nimewatenga nyinyi kutoka kwa watu wengine, kwa kuwa nyinyi ni wangu. ");
INSERT INTO swhulb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Mwanaume au mwanamke anayeongea na wafu au anayeongea na roho hakika atauawa. Watu watawaponda kwa mawe. Wanayo hatia na wanastahili kufa. ");
INSERT INTO swhulb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahweh akamwambia Musa, “Zungumza na makuhani, wana wa Aroni, nawe waambie, 'hakuna hata mmoja miongoni mwenu atakayejitia unajisi kwa wale wanaokufa miongoni mwa watu wake, ");
INSERT INTO swhulb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","isipokuwa yule aliye ndugu wa karibu—mama yake, baba yake, mwanawe, bintiye, nduguye, ");
INSERT INTO swhulb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","au dada yake bikira anayemtegemea, kwa kuwa hana mume—kwake huyo anaweza kujitia unajisi. ");
INSERT INTO swhulb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Lakini hatajitia unajisi na kujichafu kwa ajili ya jamaa wengine. ");
INSERT INTO swhulb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Makuhanai hawatanyoa vichwa vyo wala kunyoa pembeni mwa ndevu zao, wala hawatachanja chale miili yao. ");
INSERT INTO swhulb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Watakuwa watakatifu kwa Mungu wao, wala hawataliaibisha jina la Mungu wao, kwa sababu makuhani hutoa sadaka ya Yahweh ya chakula, mkate wa Mungu wao. Kwa hiyo makuhani lazima wawe watakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Hawataoa mwanamke aliye kahaba na aliyetiwa unajisi, na hawataoa mwanamke aliyetalikiwa kutoka kwa mume wake kwa sababu wametengwa kwa ajili ya Mungu wao. ");
INSERT INTO swhulb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Utamtenga kwa sababu yeye ndiye anayetoa mkate kwa Mungu wako. Ni lazima awe mtakatifu, kwa sababu—Mimi, Yahweh, ndimi niwatakasaye nyinyi—pia Mimi mwenyewe ni mtakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Binti yeyote wa kuhani anayejitia unajisi kwa kujifanya kahaba anajifedhehesha mwenyewe. Ni lazima ateketezwe kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Mtu ambaye ni kuhani mkuu miongoni mwa nduguze, ambaye mafuta ya upako yamekwisha kumiminwa kichwani pake, na ambaye amekwisha kuwekwa wakfu ili kuvaa mavazi maalum ya kuhani mkuu, kamwe hataziacha wazi nywele zake wala hatazirarua nguo zake. ");
INSERT INTO swhulb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hataingia kamwe mahali popote ambapo kuna maiti na kujitia unajisi, hata kama ni maiti ya baba yake au ya mama yake. ");
INSERT INTO swhulb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kuhani mkuu hataondoka eneo takatifu la hema la kukutania au kupatia unajisi patakatifu pa Mungu wake, kwa sababu amewekwa wakfu kuwa kuhani mkuu kwa kutiwa mafuta ya upako ya Mungu wake. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Kuhani mkuu nilazima aoe bikira kuwa mke wake. ");
INSERT INTO swhulb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Hataoa mjene, mwanamke mtalaka au mwanamke aliye kahaba. Anaweza kuoa mwanamke bikira kutoka kwa watu wake, ");
INSERT INTO swhulb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kwa hiyo asiwatia unajisi watoto wake miongoni mwa watu wake. kwa kuwa Mimi Yahweh, ndimi ninayemfanya yeye mtakatifu.” ");
INSERT INTO swhulb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahweh akamwambia Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Zungumza na Aroni na umwambie, 'mtu yeyote wa ukoo wako katika vizazi vyako vyote mwenye kasoro mwilini mwake, asisogee kutoa chakula kwa Mungu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mtu yeyote mwenye kasoro mwilini mwake asimkaribie Yahweh, ");
INSERT INTO swhulb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","mtu kama vile: kipofu au mtu asiyeweza kutembea, mtu aliyeharibiwa uso au kupungukiwa na viungo mwilini, mtu aliye na mguu au mkono wenye ulemavu, ");
INSERT INTO swhulb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","mtu mwenye kibiongo mgongoni mwake au aliye na kimo kidogo au wembamba usio wa kawaida, au mtu mwenye kasoro machoni mwake, au mwenye ugonjwa, kidonda, upele, au yule ambaye korodani zake zimeharibiwa. ");
INSERT INTO swhulb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Hakutakuwa na mtu miongoni mwa ukoo wa Aroni kuhani mkuu mwenye kasoro mwilini atakayekaribia kutoa matoleo yatakayoteketezwa kwa moto kwa ajili ya Yahweh. Mtu kama huyo mwenye kasoro mwilini hatakaribia ili kutoa mkate wa Mungu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Anaweza kula chakula cha Mungu wake, ama iwe baadhi ya vile vilivyo vitakatifu sana au vile vitakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Hata hivyo, hataingia ndani ya pazia wala kuisogelea madhabahu, kwa sababu ana kasoro mwilini mwake, ili kwamba asipanajisi mahali patakatifu pangu, kwa kuwa Mimi ndimi Yahweh anayewafanya watakatifu.” ");
INSERT INTO swhulb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kwa hiyo Musa akamwambia maneno haya Aroni, wanawe, na watu wote wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahweh akazungumza na Musa, kusema, ");
INSERT INTO swhulb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ongea na Aroni na wanawe, waambie wajiepushe na vitu vitakatifu vya watu wa Israeli wanavyovitenga kwangu. Wasilinajisi jina langu. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Waambie, 'Ikiwa mmoja wa wazao wenu katika vizazi vyenu vyote anakaribia vitu vitakatiifu vile ambavyo watu wa Israeli wamevitenga kwa Yahweh, wakati akiwa najisi, sharti mtu huyo akatiliwe mbali atoke mbele zangu. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Hatakuwapo yeyote wa uzao wa Aroni aliye na ungonjwa wa ngozi wa kuambukiza, au maambukizi yatirirkayo kutoka mwilini mwake, atakayekula sehemu yoyote ya dhabihu inatolewayo kwa Yahweh mpaka atakapotakasika. Yeyote agusaye kitu chochote kilichonajisi kwa njia ya kugusa maiti, au kwa kumgusa mtu yeyote aliyetokwa na shahawa, ");
INSERT INTO swhulb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","au yeyote agusaye mnyama atakayemtia unajisi, au mtu yeyote atakayemfanya najisi, kwa hiyo unajisi wowote unaweza kuwa— ");
INSERT INTO swhulb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","kuhani yeyote agusaye kitu chochote kisichosafi atakuwa najisi hata jioni. Hatakula chochote cha vitu vitakatifu, isipokuwa ameuosha mwili wake katika maji. ");
INSERT INTO swhulb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Jua linapotua, ndipo atakuwa safi. Baada ya machweo anaweza kula kutoka katika vitu vitakatifu, kwasababu hivyo ni vyakuala vyake. ");
INSERT INTO swhulb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Asile mzoga wowote uliookotwa au mnyama aliyeraruliwa na wanyama pori, ambaye kwake atajitia unajisi. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ni lazima makuhani wafuate maagizo yangu, ama sivyo watakuwa na hatia ya dhambi na wangeweza kufa kwa kunitia unajisi. Mimi ndimi Yahweh ninayewafanya wao watakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Hakuna mtu kutoka nje ya familia ya kuahani, wakiwemo wageni wa kuhani au watumwa wake wa kuajiliwa, atakayeweza kula kitu chochote kilicho kitakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Lakini kama huyo kuhani amenunua mtumwa kwa fedha yake mwenyewe, mtumwa huyo anaweza kula kutoka katika vitu vilivyotengwa kwa Yahweh. Na watu wa familia ya kuhani na watumwa waliozaliwa nyumbani mwake, pia wanaweza kula pamoja naye kutoka katika vitu hivyo. ");
INSERT INTO swhulb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ikiwa binti wa kuhani ameolewa na mtu asiye kuhani, hataweza kula chochote cha mchango wa matoleo matakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lakini ikiwa huyo binti wa kuhani ni mjane au ametalikiwa, na ikiwa hana mtoto, na anarudi kuishi knyumbani kwa baba yake kama alivyokuwa wakati wa ujana wake, anaweza kula kutoka katika chakula cha baba yake. Lakini hakuna yeyote asiye wa familia ya kikuhani anatakayeruhusiwa kula kutoka katika chakula cha kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Kama mtu anakula chakula kitakatifu bila ya kukijua, naye atamlipa kuahani kwa ajili ya hicho; itampasa kuongeza moja ya tano juu yake na kukirejesha kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Haiwapasi watu wa Israeli kutoheshimu vitu vitakatifu ambavyo vimeinuliwa juu na kuletwa kwa Yahweh, ");
INSERT INTO swhulb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kisha wakajisababishia wenyewe kuchukua dhambi amabyo ingewafanya kuwa na hatia ya kula chakula kitakatifu, kwa kuwa mimi ndimi Yahweh awafanyaye wao watakatifu.” ");
INSERT INTO swhulb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahweh akazungumza na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sema na Aroni na wanawe, na kwa watu wa Israeli wote. Waambie, Mwisraeli yeyote, au Mgeni anayeishi katika Israeli, waletapo dhabihu—iwe ni kutimiza kiapo, au iwe ni sadaka ya hiari, au wanaleta kwa Yahweh sadaka ya kuteketezwa kwa moto, ");
INSERT INTO swhulb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ikiwa wanataka ikubalike, ni lazima watowe mnyama dume asiye na dosari, kutoka kwenye kundi la ng'ombe, kondoo au mbuzi ");
INSERT INTO swhulb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Lakini hamtatoa chochote kilicho na dosari. Sitakipokea kwa niaba yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Yeyote atoae dhabihu ya sadaka ya ushirika kutoka katika kundi la ng'ombe au la kondoo kwa Yahweh ili kutimiza kiapo, au kama sadaka ya hiari, ili ikubalike, ni lazima isiwe na kilema. Ni lazima pasiweko na kasoro katika mnyama. ");
INSERT INTO swhulb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Msitoe kabisa wanyama waliovipofu, waliojeruhiwa, wala walio na kilema, wenye upele, vidonda vitokavyo usaha, wala wenye vigaga. Msiwatoe hawa kuwa dhabihu ya kuteketezwa kwa moto iliyotolewa kwa Yahweh juu ya madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Unaweza kumleta makisai au mwana-kondoo mlemavu au aliyedumaa kuwa sadaka ya hiari, lakini sadaka kama hiyo kwa ajili kutimiza kiapo, haitapokelewa. ");
INSERT INTO swhulb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Usitoe kwa Yahweh mnyama yeyote aliyetiwa jeraha, kupondwa, au kukatwa korodani zake. ");
INSERT INTO swhulb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Usifanye haya katika nchi yako. Usilete mkate wa Mungu wako kutoka mkononi mwa mgeni. Hao wanyama wenye vilema na dosari ndani yao, hawatapokelewa kabisa kwa ajili yako. ");
INSERT INTO swhulb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahweh akamwambia Musa na akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Wakati ndama, mwana—kondo au mwana—mbuzi azaliwapo, sharti abaki na mama yake kwa muda wa siku saba. Ndipo kuanzia siku ya nane na kuendelea, anaweza kupokelewa kuwa dhabihu iliyofanywa kwa moto kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Usimchinje ng'ombe jike pamoja na ndama wake au mbuzi jike pamoja na kitoto chake kwa siku moja. ");
INSERT INTO swhulb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Utoapo sadaka ya shukrani kwa Yahweh utaitoa kwa njia iliyokubalika. ");
INSERT INTO swhulb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ni lazima iliwe siku iyo hiyo inayotolewa. Hutakiwi kubakiza chochote hata asubuhi. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Kwa hiyo imewapasa kuzishika amri zangu na kuzifuata. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Msiliabishe jina langu takatifu. Ni lazima nitambuliwe kuwa ni mtakatifu na watu wa Israeli. Mimi ndimi Yahweh niwafanyaye ninyi watakatifu, ");
INSERT INTO swhulb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ambaye amewaleta kutoka katika nchi ya Misri ili niwe Mungu wenu: Mimi ndimi Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh akamwambia Musa: ");
INSERT INTO swhulb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Zungumza na watu wa Israeli, na uwaambie, 'Hizi ndizo sikukuu zilizoamriwa kwa ajili ya Yahweh, ambazo ni lazima mzitangaze kuwa makusanyiko matakatifu, ni sikukuu zangu za mara kwa mara. ");
INSERT INTO swhulb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Mnaweza kufanya kazi kwa siku sita, lakini siku ya saba ni Sabato ya kupumzika kabisa. Usifanye kazi kwa sababu ni Sabato kwa ajili ya Yahweh mahali pote mnaposhi. ");
INSERT INTO swhulb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Hizi ndizo sikukuu za Yahweh zilizoamriwa, Makusanyiko matakatifu mtakayoyatangaza kwa nyakati zilioamriwa: ");
INSERT INTO swhulb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Katika mwenzi wa kwanza, siku ya kumi na nne ya mwezi kwenye mwanga hafifu wa machweo ya jua, ni Pasaka ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Siku ya kumi na tano ya mwezi ule ule ni sikukuu ya mikate isiotiwa hamira kwa ajili ya Yahweh. Kwa muda wa siku saba mtakula mikate isiotiwa hamira. ");
INSERT INTO swhulb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Siku ya kwanza ni lazima mjitenge kwa pamoja, hamtafanya kazi ya kawaida. ");
INSERT INTO swhulb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwa siku saba mtamletea Yahweh matoleo ya chakula. Siku ya saba ni ya kusanyiko takatifu lililotengwa kwa ajili ya Yahweh, nanyi katika siku hiyo hamtafanya kazi yoyote ya kawaida.” ");
INSERT INTO swhulb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahweh akamwambia Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Sema na watu wa Israeli uwaambie, 'mtakapika kwenye nchi nitakayowapa nyinyi, na mtakapovuna mazao yake, nanyi yawapasa kumletea kuhani fungu la masuke ya nafaka ya matunda yake ya kwanza. ");
INSERT INTO swhulb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Naye ataliinua hilo fungu la masuke ya nafaka mbele za Yahweh na kulileta kwake, kwa kuwa litakubalika kwa niaba yenu. Nalo litaletwa siku baada ya Sabato ili kwamba kuhani ataliinua na kulileta kwangu. ");
INSERT INTO swhulb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Siku ile mtakapoliinua lile fungu la masuke ya nafaka na kulileta kwangu, itawabidi kutoa mwana—kondoo dume wa mwaka mmoja na asiye na dosari awe sadaka ya kuteketezwa kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Matoleo ya nafaka yatakuwa sehemu za kumi za efa za unga laini uliochanganywa na mafuta, uwe matoleo yaliyofanywa kwa moto kwa Yahweh, ili kutoa harufu nzuri ya kupendeza, pamoja na hiyo kutakuwa na matoleo ya kinywaji ya divai, moja ya nne ya hini. ");
INSERT INTO swhulb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Hamtakula mkate, wala nafaka iliyokaangwa au nafaka mpya hata siku ile mliyoleta matoleo haya kwa Mungu wenu. Hii itakuwa amri ya kudumu katika vizazi vyote vya watu wenu, popote pale mnapoishi. ");
INSERT INTO swhulb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Tangu siku iliyofuata baada ya Sabato—hiyo ilikuwa siku mlipolileta lie fungu la nafaka la matoleo ya kutikiswa—hesabuni majuma saba kamili. ");
INSERT INTO swhulb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mtahesabu siku hamsini, ambazo zingekuwa siku baada ya Sabato ya saba. Kisha mtaleta matoleo ya nafaka mpya kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Mtaleta kutoka nyumbani mwenu mikate miwili iliyotengenezwa kutokana na mbili za kumi za efa. Ni lazima ifanywe kwa unga laini na uliochanganywa na hamira; zitakuwa matoleo ya kutikiswa ya malimbuko ya kwanza kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Mtaileta hiyo mikate pamoja na wana—kondoo saba wa mwaka mmoja na wasiokuwa na dosari, fahali mmoja mchanga na dume wa kondoo wawili. Watakuwa matoleo ya kuteketezwa kwa moto kwa Yahweh, pamoja na matoleo yao ya nafaka na matoleo ya kinywaji, matoleo yaliyofanywa kwa moto na kutoa harufu nzuri ya kupendeza kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ni lazima mtowe mbuzi dume mmoja kwa ajili ya matoleo ya dhambi, na wana—kondoo dume wawili wa mwaka mmoja kwa ajili ya dhabihu, wawe matoleo ya ushirika. ");
INSERT INTO swhulb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ni lazima kuhani azitikise pamoja na mkate wa malimbuko ya kwanza mbele za Yahweh na kuzileta kwake kuwa matoleo pamoja na kondoo dume wawili. Watakuwa sadaka takatifu kwa Yahweh kwa ajili ya kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mtatoa tangazo siku iyo hiyo. Kutakuwa na kusanyiko takatifu, na hamtafanya kazi za kawaida. Hii itakuwa amri ya kudumu katika vizazi vya watu wenu mahali pote mnapoishi. ");
INSERT INTO swhulb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Mtakapovuna mazao ya nchi yenu, Msivune kabisa kabisa pembeni mwa mashamba yenu, wala msivune mazazo ya mavuno yenu. Inawapasa kuyaacha kwa ajili ya masikini na mgeni. Mimi ndimi Yahweh Mungu wenu.” ");
INSERT INTO swhulb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahweh akazungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Zungumza na watu wa Israeli na uwaambie, “Siku ya kwanza ya mwezi wa kwanza itakuwa siku ya pumzika makini kwa ajili yenu, kumbukumbu pamoja na kupigwa kwa tarumbeta na kusanyiko takatifu, ");
INSERT INTO swhulb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Hamtafanya kazi ya kawaida, na ni lazima mtoe dhabihu inayofanywa kwa moto kwa Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Kisha Yahweh akamwambia Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Sasa, siku ya kumi ya mwezi huu wa saba, ni Siku ya Upatanisho. Kutakuwa na kusanyiko takatifu, na ni lazima mjinyenyekeze na kuleta kwa Yahweh matoleo kwa moto. ");
INSERT INTO swhulb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Hamtafanya kazi katika siku hiyo kwa sababu ni Siku ya Upatanisho, ili kufanya upatanisho kwa ajili yenu mbele za Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Yeyote asiyejinyenyekeza siku hiyo lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Yeye afanyaye kazi yoyote katika siku hiyo, Mimi, Yahweh, nitamwangamiza atoke miongoni mwa watu wake. ");
INSERT INTO swhulb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Msifanye kazi ya aina yoyote katika siku hiyo. Hii itakuwa amri ya kudumu katika vizazi vyote vya watu wenu mahali pote mnapoishi. ");
INSERT INTO swhulb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Siku hii itakuwa Sabato ya pumziko lenye utlivu, na ni lzima siku ya tisa ya mwezi mjinyenyekeze katika majira ya jioni. Tangu jioni hata jioni mtaishika Sabato yenu.” ");
INSERT INTO swhulb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahweh akazungumza na Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Zungumza na watu ISraeli, uwaambie 'Katika siku ya kumi na tano ya mwezi wa saba kutakuwa na Sikukuu ya vibanda kwa Yahweh. nayo itadumu siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Siku ya kwanza kutakuwa na kusanyiko takatifu. Hamtafanya kazi ya kawaida. ");
INSERT INTO swhulb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwa muda wa siku saba mtatoa dhabihu iliyofanywa kwa moto kwa Yahweh. Siku ya nane kutakuwa na kusanyiko takatifu, nanyi mtato dhabihu iliyofanywa kwa moto kwa Yahweh. Hili ni kusanyiko lenye utulivu, nanyi msifanye kazi yoyote ya kawaida. ");
INSERT INTO swhulb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Hizi ndizo sikukuu zilizoamriwa kwa ajili ya Yahweh, ambazo mnapaswa kuzitangaza kuwa ni makusanyiko matakatifu ya kutoa dhabihu kwa moto kwa Yahweh, matoleo ya kuteketezwa na matoleo ya nafaka, dhabihu na matoleo ya vinywaji, kila moja kwa siku yake. ");
INSERT INTO swhulb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Sikukuu hizi zitakuwa nyongeza kwa Sabato za Yahweh na zawadi zenu, viapo vyenu vyote, na sadaka zenu zote za hiari mzitoazo kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Kuhusu Sikukuu ya vibanda, siku ya kumi na tano ya mwezi wa saba, mtakapokuwa mmeyakusanya ndani matunda ya nchi, ni lazima muitunze sikukuu hii ya Yehweh kwa muda wa siku saba. Siku ya kwanza itakuwa ya pumziko lenye utulivu, na siku ya nane pia itakuwa ya pumziko lenye utulivu. ");
INSERT INTO swhulb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Siku ya kwanza mtachuma tunda lililobora kutoka kwenye miti, mtakata makuti ya mtende, na matawi ya miti minene yenye majani mengi, na majani ya mierebi kutoka chemchemi za maji, nanyi mtashangilia mbele za Yahweh Mungu wenu kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kwa muda wa siku saba kila mwaka, mtaisherehekea sikukuu hii kwa Yahweh. Hii itakuwa amri ya kudumu katika vizazi vyote vya watu wenu mahali potepote mtakapoishi. Mtaisherehekea sikukuu hii katika mwezi wa saba. ");
INSERT INTO swhulb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mtaishi kwenye vibanda vidogovidogo kwa siku saba. Waisraeli wenyeji wa kuzaliwa wote itawapasa kuishi katika vibanda vidogovidogo kwa siku saba, ");
INSERT INTO swhulb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ili kwamba wazao wenu, kizazi baada ya kizazi, waweze kujifunza nilivyowafanya wana wa Israeli kuishi kwenye vibanda kama hivi nilipowaongoza kutoka katika nchi ya Misri. Mimi ndimi Yahweh Mungu wenu.'” ");
INSERT INTO swhulb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Katika njia hii Musa akazitangaza kwa watu wa ISraeli sikukuu zilizoamria kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh akamwambia Musa, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Waamru watu wa Israeli wakuletee mafuta halisi yaliyokamliwa kutokana na mizeituni ili yatumike kwenye taa, ili kwamba taa ziweze kuwaka daima na kuleta mwanga. ");
INSERT INTO swhulb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Nje ya pazia lililoko mbele ya sanduku la maamzi ndani ya hema la kukutania, Aroni ataiwasha daima taa mbele za Yahweh, tangu asubuhi hata jioni. Hii itakuwa amri ya kudumu katika vizazi vyote vya watu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kuhani mkuu atazifanya taa ziwake daima mbele za Yahweh, taa hizo zilizo kwenye kinara cha dhahabu safi. ");
INSERT INTO swhulb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Yawapasa kuchukua unga laini na kuoka kwa huo mikate kumi na miwili. Ni lazima kuwe na mbili za kumi za efa za unga katika kila mkate. ");
INSERT INTO swhulb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kisha mtaipanga juu ya meza ya dhahabu safi mbele za Yahweh katika safu mbili, mikate sita katika kila safu, ");
INSERT INTO swhulb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Mtaweka uvumba safi kando ya kila safu ya mikata kuwa sadaka ya kuwakilisha. Uvumba huo utachomwa kwa moto kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kila siku ya Sabato kuhani mkuu sharti aipange kwa utaratibu hiyo mikate mbele za Yahweh kwa niaba ya watu wa Israeli, iwe ishara ya agano la milele. ");
INSERT INTO swhulb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Sadaka hii itakuwa kwa ajili ya Aroni na wanawe, na ni lazima waile mahali palipo patakatifu, kwa kuwa ni sehemu ya matoleo kwa Yahweh yaliyofanywa kwa moto.” ");
INSERT INTO swhulb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Sasa ilitokea kwamba mwana wa mwanamke Mwisraeli, ambaye baba yake alikuwa Mmisri, alikwenda miongoni mwa watu wa Israeli. Huyu mwana wa mwanamke Mwisraeli akagombana na mwanume Mwisraeli kambini. ");
INSERT INTO swhulb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mwana wa mwanamke Mwisraeli akalikufuru jina la Yahweh na kumlaani Mungu, kwa hiyo watu wakamleta kwa Musa. Jina la mama yake aliitwa Shelomithi, binti wa Dibri, kutoka kabila la Dani. ");
INSERT INTO swhulb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wakamweka kizuizini mpaka Yahweh mwenyewe atakapotangaza mapenzi yake kwao. ");
INSERT INTO swhulb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Kisha Yahweh akamwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mchukue nje ya kambi huyo aliyemlaani Mungu. Wale wote waliomskia wataweka mikono yao juu ya kichwa chake, na kisha kusanyiko lote watamponda kwa mawe. ");
INSERT INTO swhulb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ni lazima uwaeleze watu wa Israeli na kusema, 'Yeyote anayemlaani Mungu wake imempasa kubeba hatia yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Yeye anayelikufuru jina la Yahweh kwa hakika ni lazima auawe. Hakika, kusanyiko lote litampiga mawe, ama awe mgeni au Mwisraeli mwenyeji mzaliwa. Ikiwa yeyote analikufuru jina la Yahweh, ni lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Naye amuuaye mtu mwingine ni lazima kwa hakika auewa. ");
INSERT INTO swhulb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Yeye anayemuua mnyama wa mwingine sharti amfidie, uhai kwa uhai. ");
INSERT INTO swhulb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Iwapo mtu anamjeruhi jirani yake, ni lazima atendewe vivyo hivyo alivyomtendea jirani yake: ");
INSERT INTO swhulb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Mvunjiko kwa mvunjiko, jicho kwa jicho, jino kwa jino. Kama amesababisha jeraha kwa mtu, ndivyo ipasavyo kutendwa kwake. ");
INSERT INTO swhulb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Yeyote auaye mnyama ni lazima amfidie, na yeyote auaye mtu ni lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ni lazima mwe na sheria moja kwa wote, mgeni na Mwisraeli mwenyeji mzaliwa, kwa kuwa Mimi ndimi Yahweh Mungu wanu.” ");
INSERT INTO swhulb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kwa hiyo Musa akazungumza na watu wa Israeli, nao watu wakamleta mwanaume huyo nje ya kambi, yule ambaye alikuwa amemlaani Yahweh. Wakampiga kwa mawe. Watu waisraeli wakaitekeleza amri ya Yahweh aliyoitoa kupitia Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh akazungumza na Musa kwenye Mlima wa Sinai, akisema, ");
INSERT INTO swhulb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Zungumza na watu wa Israeli na uwaambie, “Mtakapoingia katika nchi ambayo ninawapa, kisha hiyo nchi lazima ifanywe iwe ya kuishika Sabato kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ni lazima mtapanda mazao yenu kwa miaka sita, na kwa miaka sita mtaikatia matawi mizabibu yenu na kukusanya mazao yake. ");
INSERT INTO swhulb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Lakini katika mwaka wa saba, Sabato ya pumziko la utulivu kwa nchi itashikwa, ni Sabato kwa Yahweh. Hamtapanda mashamba yenu wala kuikatia mizabibu yenu matawi yake. ");
INSERT INTO swhulb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hamtasimamia mavuno yoyote ya mazao ya mizabibu iliyojiotesha yenyewe katika mashamba yenu ya mizabibu isiyokatiwa matawi. Huu utakuwa mwaka wa pumziko lenye utulivu kwa ardhi. ");
INSERT INTO swhulb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Chochote ardhi isiyofanyiwa kazi itakachotoa wakati wa Sabato ndicho kitakuwa chakula chako. Wewe mwenyewe, watumwa wako wa kiume na wa kike, watumishi wako wa kuajiriwa na wageni wanaoishi pamoja nawe mnaweza kujikusanyia chakula. ");
INSERT INTO swhulb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Na wnyama wako wa kufugwa na wanyama pori waweze kula chochote ardhi itoacho. ");
INSERT INTO swhulb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ni lazima kwenu kuhesabu Sabato saba za miaka, yaani, saba mara miaka saba, ikifanya jumla ya miaka arobaini na tisa. ");
INSERT INTO swhulb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kisha mtapiga sauti ya tarumbeta kila mahali katika siku ya kumi ya mwezi wa saba. Katika Siku ya Upatanisho ni lazima mtapiga tarumbeta katika nchi yenu yote. ");
INSERT INTO swhulb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Nanyi mtautenga mwaka wa hamsini kwa ajili ya Yahweh na mtatangaza uhuru katika nchi yote kwa wakazi wote. Kutakuwa na Yubile kwa ajili yenu, ambayo kwayo mali na watumwa ni lazima warejeshwe kwa familia zao. ");
INSERT INTO swhulb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mwaka wa saba kutakuwa na Yubile kwenu. Hamtapanda wala kusimamia mavuno ya kijioteshacho chenyewe, na kukusanya kichipukacho kwenye mizabibu isiyokatiwa matawi. ");
INSERT INTO swhulb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kwa sababu hiyo ni Yubile takatifu kwenu. Nanyi mtakula mazao yanayokua yenyewe kutoka mashambani. ");
INSERT INTO swhulb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ni lazima muwarejeshe kila mmoja kwenye miliki yake katika mwaka huu wa Yubile. ");
INSERT INTO swhulb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Iwapo utauza ardhi yoyote ya jirani yako au kununua ardhi yake, ni shrti msipunjane au kutendeana kwa hila. ");
INSERT INTO swhulb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Iwapo unanunua ardhi kutoka kwa jirani yako, zingatia idadi ya miaka na mazao ambayo yaweza kuvunwa mpaka mwaka wa Yubile nyingine. Jirani yako anayeuza ardhi ni lazima aihesabu miaka hiyo pia. ");
INSERT INTO swhulb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Miaka inapoongezeka mpaka Yubile nyingine, ataongeza thamani ya ardhi, na miaka inapokuwa michache kufikia Yubile nyingine atashusha thamani, kwa sababu idadi ya mavuno inahusiana na idadi ya miaka kabla ya Yubile nyingine. ");
INSERT INTO swhulb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Msipunjane au kutendeana kwa hila, badala yake, yawapasa kumheshi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Kwa hiyo basi, ni lazima muyatii maagiza, kuzitunza sheria zangu na kuzitekeleza. Nanyi mtaishi katika nchi katika usalama. ");
INSERT INTO swhulb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nayo nchi itawapa mavuno yake, nanyi mtakula matunda yenu na mtaishi humo salama. ");
INSERT INTO swhulb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Labda mtasema, Tutakula nini katika mwaka wa saba? Tazama, hatuwezi kupanda wala kukusanya mazao yetu.” ");
INSERT INTO swhulb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Nitaiamru baraaka yangu ije juu yenu katika mwaka wa sita, nayo itatoa mavuno ya kutosha kwa miaka mitatu. ");
INSERT INTO swhulb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mtapanda katika mwaka wa nane na mtaendelea kula mazao ya miaka iliyopita na kutoka kwenye ghala la chakula. Mpaka mavuno ya mwaka wa tisa yatakapofika, mtaweza kula kutoka kwenye riziki iliyohifadhiwa katika miaka iliyopita ");
INSERT INTO swhulb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ardhi haitauzwa kwa mmiliki mpya wa kudumu, kwa sababu ardhi ni mali yangu. Ninyi nyote mu wageni na wakazi wa muda juu ya ardhi yangu. ");
INSERT INTO swhulb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ni lazima muitunze haki ya ukombozi kwa ajili ya ardhi yote mtakayoimiliki; itawapasa kuruhusu ardhi inunuliwe tena na familia ambayo wewe uliinunua hiyo ardhi kutoka kwao. ");
INSERT INTO swhulb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Iwapo Mwisraeli mwenzako anakuwa masikini na kwa sababu hiyo anauza baadhi ya miliki yake, kisha jamaa yake wa karibu anaweza kuja na kuikomboa hiyo miliki ambayo jamaa yake kaiuza kwako. ");
INSERT INTO swhulb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Iwapo mtu hana jamaa wa kuikomboa mali yake, lakini ikiwa kafanikiwa na anao uwezo wa kuikomboa, ");
INSERT INTO swhulb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","kisha atahesabu miaka tangu ardhi hiyo ilipouzwa na kurejesha kwa mtu aliyemuuzia fedha iliyosalia. Naye anaweza kuerejea kwenye miliki yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lakini ikiwa hawezi kuirejesha kwake ardhi aliyoiuza, nayo hiyo ardhi aliyoiuza itabaki katika umiliki wa yule aliyeinunua mpaka mwaka wa Yubile. Kwenye mwaka wa Yubile, ardhi itarejeshwa kwa mtu aliyeiuza, naye mmiliki wa asili atarejea kwenye mali yake. ");
INSERT INTO swhulb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ikiwa mtu anauza nyumba iliyo kwenye mji uliozungushiwa ukuta, naye anaweza kuinunua tena ndani ya mwaka baada ya kuuzwa. kwa kuwa, kwa mwaka mzima atakuwa na haki ya ukombozi. ");
INSERT INTO swhulb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kama nyumba hiyo haitakombolewa kabla ya mwaka mzima, ndipo hiyo nyumba iliyoko kwenye mji uliozungushiwa ukuta itakuwa mali ya kudumu ya yule aliyeinunua, katika vizazi vyote vya uzao wake. Nyumba hiyo haitakuwa ya kurejeshwa katika mwaka wa Yubile. ");
INSERT INTO swhulb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lakini nyumba za vijijini zisizokuwa na ukuta kuzizunguuka, zitahesabiwa kuwa shamba la nchi. Zaweza kukombolewa, na ni lazima zirejeshwe katika mwaka wa Yubile. ");
INSERT INTO swhulb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Hata hivyo, nyumba zinazomilikiwa na makuhani katika miji yao zaweza kukombelewa wakati wowote. ");
INSERT INTO swhulb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Iwapo mmoja wa makuhani haikombowi nyumba iliyozwa, kisha nyumba hiyo iliyouzwa katika miji ilimo, ni lazima irejeshwe katika mwaka wa Yubile, kwa kuwa nyumba za miji ya makuhani ni mali yao miongoni mwa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lakini yale mashamba yanayozunguka miji yao hayataweza kuuzwa kwa sababu hiyo ni mali ya kudumu ya Makuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ikiwa mwananchi mwenzako anakuwa masikini, kiasi kwamba hawezi kujihudumia, nawe utalazimika kumsaidia kama vile ungemsaidia mgeni au mwingine yeyote kutoka nje aishie miongoni mwenu. ");
INSERT INTO swhulb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Usimtoze riba au kujaribu kunufaika kutoka kwake katika njia yoyote, bali mheshimu Mungu wako ili kwamba ndugu yako aendelee kuishi nawe. ");
INSERT INTO swhulb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Hutampa mkopo wa fedha na kumtoza riba, wala hutamuuzia chakula chako ili kupata faida. ");
INSERT INTO swhulb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mimi ndimi Yahweh Mungu wako, aliye kuleta wewe kutoka nchi ya Misri, ili kwamba Nikupe nchi ya Kanaani, na kwamba niwe Mungu wako. ");
INSERT INTO swhulb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Iwapo mwananchi mwenzako atakuwa masikini na kujiuza mwenyewe kwako, hutamfanyisha kazi kama mtumwa. ");
INSERT INTO swhulb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Mtendee kama mtumishi wa kuajiriwa. Ni lazima awe kama yule ahudumuye nawe kwa muda mpaka mwaka wa Yubile. ");
INSERT INTO swhulb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kisha ataondoka kwako, yeye mwenyewe na watoto wake pamoja naye, na atarejea kwenye familia yake mwenyewe na kwenye miliki ya baba yake. ");
INSERT INTO swhulb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kwa sababu wao ni watumishi wangu niliowaleta kutoka katika nchi ya Misri. Hawatauzwa kama watumwa. ");
INSERT INTO swhulb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Usitawale juu yao kwa ukatili, bali yakupasa kumheshimu Mungu wako. ");
INSERT INTO swhulb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Kwa upande wa watumwa wako wakiume na watumwa wako wa kike, unaowezao kuwapata kutok kwa mataifa yanayokuzunguka, waweza kununua watumwa kutoka kwao. ");
INSERT INTO swhulb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Unaweza pia kununua watumwa kutoka kwa wageni wanaoishi miongoni mwenu, yaani, kutoka familia zao waliopamoja nawe, wale wtoto waliozaliwa katika nchi yako. Wanaweza kuwa mali yako. ");
INSERT INTO swhulb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Unaweza kuzalisha watumwa hao kama urithi kwa watoto wako baada yako, ili kuwamiliki kama mali. Kutoka kwao waweza kununua watumwa daima, lakini hamtawezi kutawala kwa ukali juu ya ndugu zenu walio miogoni mwa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Iwapo mgeni anayeishi nawe kwa muda anakuwa tajiri, na ikiwa mmoja wa Waisraeli amekuwa masikini na kujuza mwenyewe kwa familia ya mgeni, au kwa mtu fulani katika familia, ");
INSERT INTO swhulb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","baada ya Mwisraeli mwenzako kuwa amenunuliwa. Anaweza kurejeshwa kwa maliopo. Iwapo anaweza kurejeshwa. Mtu fulani katika familia yake anaweza kumkomboa. ");
INSERT INTO swhulb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Anaweza kuwa mjomba wake, au mjomba wa mwanawe, anayemkomboa yeye, au yeyote aliye ndugu yake wa karibu kutoka kwa ukoo wake. Au, iwapo ni mwenye mafanikio, anaweza kujikomboa mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ni lazima apatane na mtu aliyemnunua, itawapasa kuhesabu miaka tangu mwaka aliojiuza kwa mnunuzi wake mpaka mwaka wa Yubile. Ile thamani ya ukombozi wake ihesabiwe kulingana na kiwango cha mshahara anaolipwa mtumishi aliyeajiriwa, kwa idadi ya miaka ambayo angeweza kuendelea kufanya kazi kwa yule aliyemnunua. ");
INSERT INTO swhulb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Endapo kutakuwa kungali na miaka mingi iliyobaki mpaka mwaka wa Yubile, atalazimika kulipa fungu kubwa la fedha kwa ajili ya ukombozi ambao ni uwino wa idadi ya miaka hiyo. ");
INSERT INTO swhulb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Iwapo kuna miaka michache tu iliyobaki mpaka mwaka wa Yubile, atapatana na aliyemnunua ili kuipitia idadi ya miaka iliyobaki mpaka Yubile, naye atalazimika kulipia ukombozi wake kulingana na idadi ya miaka. ");
INSERT INTO swhulb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Naye atatendewa kama mtu aliyeajiriwa mwaka kwa mwaka. Utahakikisha kwamba hatendewi kwa ukali. ");
INSERT INTO swhulb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Iwapo hakukombolewa katika njia hizi, basi atatumika mpaka mwaka wa Yubile, yeye pamoja na watoto wake. ");
INSERT INTO swhulb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Kwangu mimi watu wa Israeli ni watumishi. Wao ni watumishi wangu ambao Niliwatoa katika nchi ya Misri. Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Msijitengenezee sanamu, wala msisimamishe kinyago cha kuchonga au nguzo ya jiwe ya kuabudia, na msisimamisha sura ya jiwe la kuchonga katika nchi yenu mtayoiinamia, kwa kuwa Mimi ndimi Yahweh Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ni lazima muitunze Sabato Yangu na kupaheshimu patakatifu pangu. Mimi ndimi Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Iwapo mtatembea katika sheria zangu na kuzishika amri zangu na kuzitii, ");
INSERT INTO swhulb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Nami nitawapa ninyi mvua katika majira yake; nayo nchi itatoa mazao yake, na miti ya shambani itatoa matunda yake. ");
INSERT INTO swhulb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Upuraji wenu utaendelea hata wakati wa mavuno ya zabibu, na mavuno ya zabibu yataendelea mpaka majira ya kupada mbegu. Nanyi mtakula mkate na kushiba na kuishi salama mahali mtakapofanya mji wenu katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nitawapa amani; mtalala bila ya kitu chochote kuwatia hofu. Nitawaondolea mbali wanyama waliohatari katika nchi, na upanga hautapita katika nchi yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mtawafukuza adui zenu, nao wataanguka mbele yenu kwa upanga. ");
INSERT INTO swhulb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Watu wenu watano watafukuza adui mia moja, na watu wenu mia moja watafukuza adui elfu kumi; adui zenu wataanguka mbele yenu kwa upanga. ");
INSERT INTO swhulb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nitawatazama kwa upendeleo na kuwafanya nyinyi mzae na kuwazidisha nyinyi. ");
INSERT INTO swhulb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mtakula chakula kilichotunzwa ghalani kwa muda mrefu. Mtayaondoa mazao yaliyohifadhiwa ghalani kwa sababu mtahitaji ghala kwa ajili ya mavuno mapya. ");
INSERT INTO swhulb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nitaliweka hema langu katikati yenu, nami stachukizwa nanyi. ");
INSERT INTO swhulb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nitatembea miongoni mwenu nami nitakuwa Mungu wenu, nanyi mtakuwa watu wangu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mimi ndimi Yahweh Mungu wenu, aliyewaleta nyinyi kutoka nchi ya Misri, ili kwamba msingeendelea kuwa watumwa wao. Nimevunja makomeo ya nira yenu na nikawafanya mtembee kwa kunyooka. ");
INSERT INTO swhulb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Lakini ikiwa hamtanisikiliza mimi, ");
INSERT INTO swhulb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na kutozitii amri hizi, na ikiwa mtayakataa maagizo yangu, na kuzichukia sana sheria zangu, kiasi kwamba hamtaweza kuzitii amri zangu zote, lakini mkalivunja agano langu— ");
INSERT INTO swhulb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","—kama mtafanya mambo haya, Nami nitafanya hili kwenu: Nitasababisha hofu juu yenu, maradhi na homa kali itakayoangamiza macho na kuondoa uhai wenu. Mtapanda mbegu zenu kwa hasara, kwa sababu adui zenu watakula mazao yake. ");
INSERT INTO swhulb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nitakaza uso wangu dhidi yenu, na mtashindwa na adui zenu. Watu wanaowachukia watatawala juu yenu, na mtakimbia hata kama hakutakuwa na yeyote anayewafukuza. ");
INSERT INTO swhulb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Iwapo hamtasikiliza maagizo yangu, Nami niwataadhibu vikali mara saba kwa dhambi zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nami nitakivunja kiburi chenu katika uwezo wenu. Nitaifanya mbingu juu yenu iwe kama chuma na nchi yenu kama shaba. ");
INSERT INTO swhulb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nguvu yenu itatumika bure, kwa sababu nchi yenu haitazalisha mavuno yake, na miti yenu katika nchi haitazaa matunda yake. ");
INSERT INTO swhulb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Iwapo mtataenenda kinyume changu na hamtanisikiliza mimi, nitaleta mapigo mara saba zaidi juu yenu, sawasawa na dhambi zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nitatuma wanyama mapori hatari dhidi yenu, ambao watawaibia watoto wenu, kuangamiza mifugo yenu na kuwafanya mwe wachache katika idadi yenu. Hivyo barabara zenu zitakuwa nyeupe. ");
INSERT INTO swhulb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Endapo pamoja na mambo haya kuwapata lakini msiyakubali marekebisho yangu na mkazidi kuenenda katika upinzani dhidi yangu, ");
INSERT INTO swhulb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ndipo nami pia nitaenenda kinyume chenu, na Mimi mwenyewe nitawaadhibu mara saba kwa sababu ya dhambi zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nitaleta upanga juu yenu utakaowaadhibu kwa kisasi kwa sababu ya kulivunja agano. Nanyi mtajikusanya kwenye miji yenu, Nami nitatuma humo maafa miongoni mwenu, na mtachukuliwa mikononi mwa adui yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nitakapokomesha mgao wa chakula, wanawake kumi wataweza kuoka mkate wako katika chombo kimoja cha kuokea na watakugawia mkate wako kwa uzani. Nanyi mtakula lakini hamtatoshelezwa. ");
INSERT INTO swhulb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Endapo hamtanisikiliza pamoja na mambo haya kuwapata, lakini mkazidi kuenenda kinyume na mimi, ");
INSERT INTO swhulb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","kisha nami nitakwenda kinyume nanyi katika hasira, Nami nitawaadhibu hata mara saba kulingana na wingi wa dhambi zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ndipo mtakapokula nyama ya wana wenu; mtakula nyama ya binti zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nitapaangamiza mahali penu pa juu, kuziangusha chini madhabahu zenu za kufukizia uvumba, na kuzitupa maiti zenu juu ya maiti ya sanamu zenu, na Mimi mwenyewe nitawadharau nyinyi. ");
INSERT INTO swhulb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nitaigeuza miji yennu kuwa magofu na kupaharibu patakatifu penu. Nami sitapendezwa na harufu nzuri ya matoleo yenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nami nitaiharibu nchi. Adui zenu watakaokuwa wakiishi humo watashtushwa na uharibifu huo. ");
INSERT INTO swhulb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nami nitawatawanya nyinyi katika mataifa, na nitaufuta upanga wangu na kuwafuatia. Nchi yenu itatelekezwa, na miji yenu itakuwa magofu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nayo nchi itazifurahia Sabato zake kwa kuwa itakuwa imetelekezwa na ninyi mkiwa katika nchi za daui zenu. Katika nyakati hizo, nchi itapumzika na kufurahia Sabato zake. ");
INSERT INTO swhulb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Maadamu itakuwa imetelekezwa, itakuwa na pumziko, ambalo litakuwa ni pumziko iliyolikosa pamoja na Sabato zenu mlipokuwa mkiishi ndani yake. ");
INSERT INTO swhulb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Na kwa wale watakoachwa humo kwenye nchi za adui zenu, Nitatuma hofu ndani ya mioyo yenu kiasi kwamba hata kama ni maelfu ya majani tu yatakapopeperushwa katika upepo yatawaogofyeni. Nanyi mtaanguka hata kama hakutakuwa na awafukuzaye. ");
INSERT INTO swhulb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Mtajikwaa kila mmoja juu ya mwenzake kama vile mlikuwa mkiukimbia upanga, hata kama hakutakuwa na awafukuzaye nyinyi. Hamtakuwa na nguvu ya kusimama mbele ya daui zenu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Nanyi mtaangamia miongoni mwa mataifa, nayo nchi ya adui zenu yenyewe itawamezani. ");
INSERT INTO swhulb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wale watakosalia miongoni mwenu watapotelea katika dhambi zao, huko kwenye nchi za adui zenu, na kwa sababu ya dhambi zao, na kwa sababu ya dhambi za baba zao watapotelea mbali pia. ");
INSERT INTO swhulb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Lakini kama watakiri dhambi zao na dhambi ya baba zao, na usaliti wao ambao kwao hawakuwa waaminifu kwangu, pia na mwenendo wao dhidi yangu— ");
INSERT INTO swhulb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ambao ulinisababisha kuwa kinyume nao, na kuwaleta katika nchi ya adui zao—iwapo mioyo yao isiyotahiriwa itanynyekezwa, ");
INSERT INTO swhulb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","na iwapo wataikubali adhabu kwa ajili ya dhambi zao, nami nitalikumbuka agano langu na Yakobo, agano langu na Isaka, agano langu na Abrahamu; Pia, nitaikumbuka nchi. ");
INSERT INTO swhulb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nchi itakayotelekezwa na wao, hivyo itapendezwa na Sabato zake inapobaki imetelekezwa na wao. Itawapasa kulipa hatia kwa dhambi zao kwa sababu ni wao wenyewe ndiyo walioyakataa maagizo yangu na kuzichukia sheria zangu. ");
INSERT INTO swhulb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Lakini pamoja na haya yote, watapokuwa katika nchi ya adui zao, Mimi stawakataa wao, wala sitawachukia ili kuwaangamiza kabisa na kulifutilia mbali agano langu nilililoagana nao, kwa kuwa Mimi ndimi Yahweh Mungu wao. ");
INSERT INTO swhulb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Bali kwa ajili yao, nitalikumbuka agano langu na baba zao, niliowaleta kutoka katika nchi ya Misri machoni pa mataifa, ili niwe Mungu wao. Mimi ndimi Yahweh.” ");
INSERT INTO swhulb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hizi ndizo amri, hukumu, na sheria ambazo Yahweh alifanya baina yake na watu wa Israeli kwenye Mlima Sinai kwa kupitia Musa. ");
INSERT INTO swhulb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh akazungumza na Musa na akasema, ");
INSERT INTO swhulb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Zungumza na watu wa Israeli na uwaambie, 'Iwapo mtu yeyote anatoa kiapo maalum cha kuwa mnathiri kwa Yahweh, tumieni tathmini zifuatazo: ");
INSERT INTO swhulb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Viwango vyenu vya thamani kwa mwanaume aliye na umri kati ya miaka ishirini na miaka sitini yaweza kuwa shekeli hamsini za fedha, kulingana na vipimo vya shekeli ya mahali pa patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kwa mwanamke wa umri uleule viwango vyenu vya thamani yapasa viwe shekeli thelathini vya fedha. ");
INSERT INTO swhulb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Tangu wenye umri wa miaka mitano mpaka wa miaka ishirini viwango vyenu vya thamani kwa mwananume vitakuwa shekeli ishirini za fedha, na kwa mwanamke ni shekeli kumi za fedha, ");
INSERT INTO swhulb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kwa wenye umri wa tangu mwezi mmoja mpaka miaka mitano viwango vyenu vya thamani kwa mawanaume vitakuwa shekeli tano za fedha na kwa mwanamke shekeli tatu za fedha. ");
INSERT INTO swhulb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Tangu wenye umri wa miaka sitini na zaidi kwa mwanaume viwango vyenu vya thamani vitakuwa shekeli kumi na tano, na kwa mwanamke ni shekeli kumi. ");
INSERT INTO swhulb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Lakini kama mtu atoaye kiapo cha mnadhiri hawezi kulipa kiwango hicho cha thamani, kisha huyo mtu anayetolewa lazima atapelekwa kwa kuhani, naye kuhani atamthamanisha huyo atolewaye kwa kiasi anachoweza kutoa yule anayetoa kiapo cha mnadhiri. ");
INSERT INTO swhulb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Iwapo mtu anataka kutoa sadaka ya mnyama kwa Yahweh, na iwapo Yahweh ataikubali, kisha huyo mnyama atatengwa kwake. ");
INSERT INTO swhulb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Mtu huyo hataruhusiwa kumtoa madhabahuni au kumbadilisha huyo mnyama, mzuri kwa mbaya au mbaya kwa mzuri. endapo atatoa mnyama badala ya mwingine, kisha wanyama hao wawili; yule anayetolewa na yule anayebadilishwa wanakuwa watakatifu. ");
INSERT INTO swhulb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Hata hivyo, iwapo kile mtu amishaapa kumtolea Yahweh kwa uhalisia siyo kisafi, kwa hiyo, Yahweh hatakikubali, naye huyo mtu atalazimika kumleta huyo mnyama kwa kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kuhani atamthamanisha, kwa thamani ya soko la mnyama. Thamani yoyote kuhani atakayoiweka juu ya mnyama, hiyo ndiyo itakuwa thamani yake. ");
INSERT INTO swhulb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Na kama mmiliki anapenda kumkomboa, kisha tano ya thamani yake itaongezwa kwenye gharama yake ya ukombozi. ");
INSERT INTO swhulb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Mtu aitengapo nyumba yake iwe zawadi takatifu kwa Yahweh, kisha kuhani ataweka thamani yake ama iwe ni nzuri au mbaya. Thamani yoyote itakayowekwa na kuhani juu yake, ndiyo itakuwa thamani yake. ");
INSERT INTO swhulb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Lakini kama mmiliki wake anayeitenga nyumba yake anapenda kuikomboa, atalazimika kuongeza sehemu ya tano ya thamani yake kwenye gharama ya ukombozi wake, nayo nyumba itakuwa yake. ");
INSERT INTO swhulb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Iwapo mtu anatenga sehemu ya ardhi yake mwenye, kisha tathmini yake itakuwa katika uwiano kwa kiwango cha kiasi cha mbegu inayotakiwa kuipanda katika ardhi hiyo—homeri moja ya mbegu za shairi ambayo itathamanishwa kwa shekeli hamsini za fedha. ");
INSERT INTO swhulb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Na kama analitenga shamba lake katika mwaka wa Yubile, tathmini yake ya awali itabaki kuwa ileile. ");
INSERT INTO swhulb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Lakini endapo atalitenga shamba hilo baada ya mwaka wa Yubile, kisha kuhani atalazimika kukokotoa thamani yake kwa idadi ya miaka inayobaki mpaka mwaka wa Yubile, na thamani yake lazima ishushwe. ");
INSERT INTO swhulb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Iwapo mtu anayelitenga shamba lake anapenda kuliko, mboa, naye atalazimika kuongeza sehemu ya tano kwenye thamani, nalo shamba litakuwa lake tena. ");
INSERT INTO swhulb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Iwapo halikomboi shamba, au iwapo amishaliuza shamba kwa mtu mwingine, haliwezi kukombolewa tena. ");
INSERT INTO swhulb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Badala yake, shamba hilo litakapoachwa huru katika mwaka wa Yubile, litakuwa zawadi takatifu kwa Yahweh, kama lilivyo shamba lililotolewa kabisa kwa Yahweh. Nalo litakuwa mali ya kuhani. ");
INSERT INTO swhulb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Iwapo mtu anatenga shamba alilolinunua, lakini hilo shamba siyo sehemu ya ardhi ya familia yake, ");
INSERT INTO swhulb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kuhani atafanya tathmini yake mpaka mwaka wa Yubile, na mtu huyo lazima atalipa thamani yake katika siku hiyo hiyo kuwa zawadi takatifu kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Katika mwaka wa Yubile, shamba litarejeshwa kwa mtu yule ambaye lilikuwa limenunuliwa, kwa mmiliki wa ardhi. ");
INSERT INTO swhulb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Tathmani yote lazima ifanywe kwa uzani wa shekeli ya mahali pa patakatifu. Gera ishirini kwa shekeli moja. ");
INSERT INTO swhulb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Asiwepo mtu atakayetenga mzaliwa wa kwanza miongoni mwa wanyama, kwa kuwa wazaliwa wote wa kwanza wa wanyama tayari ni mali ya Yahweh; iwe ni maksai au kondoo, ni wa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Na kama ni mnyama aliye najisi, kisha mmiliki wake anaweza kumnunua tena sawasawa na thamani yake, na sehemu ya tano lazima itaongezwa kwenye thamani hiyo. Na kama mnyama hakombolewi, naye atauzwa kwa thamani iliyowekwa. ");
INSERT INTO swhulb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Hakutakuwa na kitu amabacho mtu anakitoa kwa Yahweh, kutoka katika vyote alivyonavyo, iwe ni mwanadamu au mnyama, au ardhi ya familia yake, ambacho chaweza kuuzwa au kukombolewa. Kila kitu kitolewacho ni kitakatifu sana kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hakuna fidia inayoweza kulipwa kwa ajili ya mtu aliyetolewa ili kuangamizwa. Mtu huyo sharti auawe ");
INSERT INTO swhulb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Zaka yote iliyo ya ardhini, iwe nafaka ichipukayo juu ya ardhi au tunda kutoka kwenye miti, ni mali ya Yahweh. Ni takatifu kwa Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Iwapo mtu anakomboa chochote cha zaka yake, atalazimika kuongeza sehemu ya tano kwenye thamani yake. ");
INSERT INTO swhulb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Na kwa kila mnyama wa kumi wa kundi la ng'ombe au la kondoo, yeyote anayepita chini ya fimbo ya mchungaji, atatengwa kwa ajili ya Yahweh. ");
INSERT INTO swhulb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mchungaji hatatafuta wanyma waliobora au wabaya kabisa, na haruhusiwi kubadili mnyama mmoja kwa mnyama mwingine. Iwapo anambadilisha kwa namna yoyote ile, kisha wote wawili yule wa kwanza na huyo aliyebadiliwa watakuwa watakatifu. Mnyama huyo atolewaye hawezi kukombolewa.'” ");
INSERT INTO swhulb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hizi ndizo amri ambazo Yahweh alimpa Musa kwenye mlima Sinai kwa ajili ya watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mungu alimwambia Musa katika hema ya kukutania walipokuwa katika jangwa la Sinai. Hii ilitokea katika siku ya kwanza ya mwezi wa pili miaka miwili baadaya Waisraeli kutoka nchi ya Misri. Mungu alisema, ");
INSERT INTO swhulb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","'fanya sensa ya wanaume wote wa Israel kutoka kila ukoo, katika familia za baba zao. Wahesabu kwa majina, wahesabu kila mume, kila mwanamume ");
INSERT INTO swhulb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","kuanzia umri a miaka ishirini na zaidi. Uwahesabu wote wanaoweza kupigana kama askari wa Israel. Wewe na Haruni mtaandika idadi ya wanaume katika makundi ya majeshi yao. ");
INSERT INTO swhulb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kila mwanamume kwa kila kabila, kichwa cha ukoo, lazima atumike na wewe kama kiongozi wa kabila. ");
INSERT INTO swhulb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Haya ndiyo majina ya viongozi ambao watapigana pamoja na wewe: Kutoka kabila la Reubeni, Elizuri mwana wa Shedeuri; ");
INSERT INTO swhulb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kutoka kabila la Simeoni, Shelumiel mwana wa Zurishadai ");
INSERT INTO swhulb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Kutoka kabila la Yuda, Nashoni mwana wa Aminadabu; ");
INSERT INTO swhulb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ktoka kabila la Isakari, Nethaneli mwana wa Zuari; ");
INSERT INTO swhulb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kutoka kabila Zebuluni, Eliabu mwana wa Heloni ");
INSERT INTO swhulb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kutoka kabila la Efraimu mwana wa Yusufu, Elishama mwana wa Ammihudi; kutoka kabila la Manase, Gamaliel mwan wa Pedazuri; ");
INSERT INTO swhulb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kutoka kabila la Benjamini mwana wa Ysufu, Abidani mwan wa Gidion; ");
INSERT INTO swhulb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Kutoka kabila la Dan, Ahizeri mwana wa Amishadai; ");
INSERT INTO swhulb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kutoka kabila Asheri, Pagieli mwana wa Okirani; ");
INSERT INTO swhulb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kutoka kabila la Gadi, Eliasafu mwana wa Deuli; ");
INSERT INTO swhulb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","na kutoka kabila la Naftali, Ahira mwana wa Enani.” ");
INSERT INTO swhulb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hawa ndio wanaume waliochaguliwa kutoka kwa watu. Waliongoza kabila za mababu zao. Walikuwa viongozi wa koo katika Israel. ");
INSERT INTO swhulb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Haruni wakawachukua wale wanaume, waliokuwa wameandikwa kwa majina, ");
INSERT INTO swhulb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na pamoja na wanaume hao waliwakusanya wanume wote katika siku ya kwanza ya mwezi wa pili. Kisha kila mwanume wa miaka ishirini na zaidi alitambua babu zake. Alitakiwa kutaja koo na famila kutoka katika ukoo. ");
INSERT INTO swhulb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Kisha Musa akaandika hesabu yao huko katika nyika ya Sinai, Kama Mungu alivyokuwa amemwamuru kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kutoka uzao wa Reubeni, mtoto wa kwanza wa Israel, yalihesabiwa majina yote ya kila mwanamume mwenye umri wa miaka ishirini na zaidi wenye uwezo wa kwenda vitani, kutoka hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Waliwahesabu wanaume 46, 000 kutoka ukoo wa Reubeni. ");
INSERT INTO swhulb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kutoka uzao wa Simeoni yalihesabiwa majina yote ya kila mwanamume mwenye umri wa miaka ishirini na zaidi au wenye uwezo wa kwenda vitani, kutokana na hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Walihesabu wanaume 59, 300 kutoka kabila la Simeoni. ");
INSERT INTO swhulb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kutoka uzao wa Gadi yalihesabiwa majina yote ya kila mwanamume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Walihesabu wanaume 45, 650 kutoka kabila la Gadi. ");
INSERT INTO swhulb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kutoka uzao wa Yuda yalihesabiwa majina yote ya wanaume wenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","walihesabiwa wanume 74, 000 kutoka kabila la Yuda. ");
INSERT INTO swhulb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kutoka uzao wa Isakari yalihesabiwa majina yote ya kila mwanamume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Walihesabiwa wanaume 54, 000 kutoka kabila la Isakari. ");
INSERT INTO swhulb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kutoka uzao wa Zabuloni yalihesabiwa majina yote ya kila mwanamume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Walihesabiwa wanume 57, 400 kutoka kabila la Zabuloni. ");
INSERT INTO swhulb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kutoka uzao wa Efraimu mwana wa Yusufu yalihesabiwa majina yote ya kila mwanaume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Walihesabiwa wanaume 40, 500 kutoka kabila la Efraimu. ");
INSERT INTO swhulb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kutoka uzao wa Manase mwana wa Yusufu yaliheabiwa majina yote ya kila mwanaume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu y a ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Walihesabiwa wanaume 32, 000 kutoka kabila la Manase. ");
INSERT INTO swhulb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kutoka uzao wa Benjamini yalihesabiwa majina yote ya kila mwanaume mwenye umri wa miaka ishirini au zaidi na wenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Walihesabiwa wanaume 35, 000 kutoka kabila la Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kutoka uzao wa Dani yalihesabiwa majina yote ya kila mwanaume mwenye umri wa miaka ishirini au zaidi na mwenye uwezo wa kwenda vitani, Kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Walihesabiwa wanaume 62, 000 kutoka kabila la Dani. ");
INSERT INTO swhulb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kutoka uzao wa Asheri yalihesabiwa majina yote ya kila mwanume mwenye umri wa miaka ishirini au zadi na mwenye uwezo wa kwenda vitani, kutoka kwenye hesabu y a ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Walihesabiwa wanaume 41, 500 kutoka ukoo wa Asheri. ");
INSERT INTO swhulb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kutoka ukoo wa Naftali yalihesabiwa majina yote ya kila mwanaume mwenye umri wa miaka ishirini au zaidi na mwenye uwezo wa kwenda vitani, kutoka kwenye hesabu ya ukoo na familia. ");
INSERT INTO swhulb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Walihesabiwa wanaume 53, 400 kutoka kabila la Naftari ");
INSERT INTO swhulb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Musa na Haruni waliwahesabu wanaume wote hawa, pamoja na wale wanaume kumi na wawili waliokuwa wakiongoza yale makabila kumi na mawili ya Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Kwa hiyo wanaume wote wa Israeli wenye umri wa miak ishirini au zaidi, wote wenye uwezo wa kwenda vitani, walihesabiwa kutoka kwenye familia zao. ");
INSERT INTO swhulb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Walihesabu wanaume 603, 550. ");
INSERT INTO swhulb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lakini wanaume toka uzao wa Lawi hawakuhesabiwa, ");
INSERT INTO swhulb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kwa sababu BWANA alimwambia Musa, ");
INSERT INTO swhulb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“usiwahesabu wale wa kabila la Lawi wala kuwajumuisha kwenye jumla ya watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Badala yake, waagize Walawi kuliangalia hema la amri za agano, na kuangalia mapambo ya hema na vyote vilivyomo. Walawi watalazimika kulibeba hema na lazima wayabebe mapambo ya hema. Lazima waliangalie hema na kuyatengeneza mazingira yake. Wataiangalia masikani na kuzitengeneza kambi zinazolizunguka. ");
INSERT INTO swhulb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kila hema litakapotakiwa kuhamishiwa eneo jingine, Walawi ndio watakaolipeleka pale. Na kila hema litakapotakiwa kusimamishwa, Walawi ndio watakao lisimamisha. Na mgeni yeyote atakayelisogelea hema lazima auawe. ");
INSERT INTO swhulb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Wakati watu wa Israeli watakaposimamisha hema zao, kila mwanaume lazima awe karibu na bango la jeshi lake. ");
INSERT INTO swhulb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Hata hivyo Walawi lazima waweke hema zao kuizunguka hiyo masikani ya amri za agano ili kwamba hasira yangu isije ikawaka juu ya wana wa Israeli. Walawi lazima wailinde hiyo masikani ya amri za agano.” ");
INSERT INTO swhulb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Wana wa Israeli walifanya yote haya. Walifanya yote ambayo BWANA aliagiza kupitia Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","BWANA akasema na Musa na Haruni tena. Akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Kila mtu atapanga kulingana na mahali pake, pamoja na mabango ya baba zao. Watapanga kuzunguka hema ya kukutania kila upande. ");
INSERT INTO swhulb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Wale watakaopanga mashariki mwa hema ya kukutania, mahali ambapo juu huonekana wakati wa jua kuchomoza, ni makambi ya Yuda nao watakuwa katika kundi lao. Nashoni mwana wa Aminadabu ni kiongozi wa watu wa Yuda. ");
INSERT INTO swhulb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Idadi ya watu wa Yuda ni 74, 600. ");
INSERT INTO swhulb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kabila la Isakari litapanga mbele ya Yuda. Nethaneli mwana wa Zuari ataliongoza jeshi la Isakari. ");
INSERT INTO swhulb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Idadi ya kikosi chake ni wanaume 54, 000. ");
INSERT INTO swhulb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kabila la Zabuloni litapanga mbele ya Isakari. Eliabu mwana wa Heloni ndiye atakayeliongoza jeshi la Zabuloni. ");
INSERT INTO swhulb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Idadi ya kikosi chake ni 57, 400. ");
INSERT INTO swhulb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Idadi yote ya kambi y a Yuda ni 186, 400. Watakuwa wa kwanza kuondoka. ");
INSERT INTO swhulb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Upande wa kusini kutakuwa na kambi ya Reubeni katika kundi lao. Kiongozi wa kundi la Reubeni ni Elizuri mwana wa Shedeuri. ");
INSERT INTO swhulb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Idadi ya kikosi chake ni 46, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeoni atapanga mbele ya Reubeni. Kiongozi wa watu wa Simeoni ni Shelumieli mwana wa Zurishadai. ");
INSERT INTO swhulb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Waliohesabiwa kwenye kikosi chake ni 59, 300. ");
INSERT INTO swhulb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kabila la Gadi litafuatia. Kiongozi wa watu wa Gadi ni Eliasafu mwana wa Deuli. ");
INSERT INTO swhulb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Idadi ya kikosi chake ni 45, 650. ");
INSERT INTO swhulb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Wote waliohesabiwa kwenye kambi ya Reubeni, kulingana na kikosi chake, ni 151, 450. Watakuwa wa pili kuondoka. ");
INSERT INTO swhulb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kifuatacho, ni hema la kukutania kuondoka kambini pamoja na Walawi likiwa katikati ya kambi zote. Lazima waondoke hapo kambini kwa mpangilio huo kama walivyoingia kwenye kambi. Kila mwanamume lazima awe mahali pake kwa kufuata bango lake. ");
INSERT INTO swhulb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Migawanyiko ya kambi y Efraimu kufuata mahali pake. Kiongozi wa watu wa Efraimu ni Elishama mwana wa Amihudi. ");
INSERT INTO swhulb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Hesabu ya kikosi hiki ni 40, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Baada ya hao lilifuata kabila la Manase. Kiongozi wa Manase ni Gamaliel mwana wa Pedazuri. ");
INSERT INTO swhulb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Hesabu ya kikosi hiki ni 32, 200. ");
INSERT INTO swhulb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kabila litakalofuata ni la Benjamini. Kiongozi wa Benjamini n Abidani mwana wa Gidioni. ");
INSERT INTO swhulb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Hesabu ya kikosi hiki ni 35, 000 ");
INSERT INTO swhulb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wote waliohesabiwa katika kambi ya Efraimu ni 108, 100. Watakuwa wa tatu kuondoka. ");
INSERT INTO swhulb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Upande wa kaskazini kutakuwa na kambi ya kikosi cha Dani. Kiongozi wa watu wa Dani ni Ahiezeri mwana wa Amishadai. ");
INSERT INTO swhulb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Hesabu ya kikosi hiki ni 62, 700. ");
INSERT INTO swhulb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Watu wa kabila ya Asheri watapanga mbele ya Dani. Kiongozi wa Asheri ni Pagieli mwana wa Okirani. ");
INSERT INTO swhulb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Hesabu ya Kikosi hiki ni 41, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kabila la Naftali ndilo litakalofuatia. Kiongozi wa Naftali ni Ahira mwana wa Enani. ");
INSERT INTO swhulb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Hesabu ya kikosi hiki ni 53, 400. ");
INSERT INTO swhulb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Wote waliohesabiwa kwenye kambi ya Dani ni 157, 600. Hawa watakuwa wa mwisho kuondoka kambini, wakifuata bango lao. ");
INSERT INTO swhulb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hawa ndio Waisraeli, waliohesabiwa kufuata familia zao. Wote waliohesabiwa kwenye kambi zao, kwa kufuata vikosi vyao ni 603, 550. ");
INSERT INTO swhulb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lakini Musa na Haruni hawakujumuisha Walawi kwenye Hesabu ya Waisrael. Ilikuwa kama BWANA alivyokuwa amemwagiza Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Watu wa Israel walifanya yote ambayo BWANA alimwagiza Musa. Walipanga kwa kufuata mabango yao. Walisafiri kutoka kambini kwa kufuata jamaa zao, kwa mpangilio wa familia za koo zao. ");
INSERT INTO swhulb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Sasa hii ndiyo historia ya uzao wa Haruni na Musa wakati BWANA aliposema na Musa kwenye mlima Sinai. ");
INSERT INTO swhulb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Majina ya watoto wa Haruni walikuwa Nadabu ambaye ndiyo mtoto wa kwanza, na Abihu, na Eliezeri, na Ithamari. ");
INSERT INTO swhulb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Haya ndiyo majina ya wana wa Haruni, makuhani waliokuwa wamepakwa mafuta na kuwekwa wakfu kutumika kama makuhani. ");
INSERT INTO swhulb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lakini Nadabu na Abihu walikufa mbele ya BWANA walipomtolea moto usiokubalika walipokuwa katika nyika ya Sinai. Nadabu na Abihu hawakuwa na watoto, kwa hiyo Eliazari na Ithamari walitumika kama makuhani pamoja na baba yao. ");
INSERT INTO swhulb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","BWANA alinena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Walete kabila ya Lawi na uwaweke kwa Haruni kuhani ili wamsaidie ");
INSERT INTO swhulb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Nao lazima wafanye majukumu badala ya Haruni na jumuiya yote mbele ya hema ya kukutania. Lazima watumike hemani. ");
INSERT INTO swhulb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Watayatunza mapambo ya hema ya kukutania, na watawatumikia makabila ya Israel kwa huduma ya hemani. ");
INSERT INTO swhulb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Uwaweke Walawi kwa Haruni na watoto wake. Nimewatoa kikamilifu ili wamsaidie kuwatumikia watu wa Israel. ");
INSERT INTO swhulb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Umchague Haruni na watoto wake kuwa makuhani, lakini mgeni yeyote atakayekaribia lazima auawe.” ");
INSERT INTO swhulb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","BWANA alinena na Musa. akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Tazama, nimewachagua Walawi katika watu wa Israel. Nimefanya hivyo badala ya kuchukua mzaliwa wa kwanza wa kiume wa wana wa Israel. Hawa Walawi ni wangu. ");
INSERT INTO swhulb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Na hata wazaliwa wa kwanza ni mali yangu. Katika siku ambyo niliwavamia wazaliwa wote wa kwanza wa nchi ya Misri, Niliwatenga wazaliwa wa kwanza wa Israeli kwa ajili yangu, watu na wanyama pia. Ni mali yangu. Mimi ndimi BWANA.” ");
INSERT INTO swhulb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","BWANA alinena na Musa katika nyika ya Sinai. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Wahesabu uzao wa Lawi katika kila familia, katika nyumba za koo zao. Hesabu kila mume kuanzia mwezi mmoja au zaidi.” ");
INSERT INTO swhulb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musa aliwahesabu, kufuata maelekezo ya BWANA, kama alivyoamriwa kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Majina ya watoto waLawi yalikuwa Gerishoni, Kohathi, na Merari. ");
INSERT INTO swhulb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ukoo uliotokana na watoto wa Gerishoni walikuwa ni Libni na Shimei. ");
INSERT INTO swhulb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ukoo uliotokana na watoto Kohathi walikuwa ni Amramu na, Izihari, Hebroni, na Uzieli. ");
INSERT INTO swhulb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ukoo uliotokana na watoto wa Merari walikuwa ni Mahili na Mushi. Hizi ndizo koo za Walawi, zilizoorodheshwa ukoo kwa ukoo. ");
INSERT INTO swhulb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Koo za Walibini na Washimei zilitokana na Wagerishoni. Hizi ndizo koo za Wagerishoni. ");
INSERT INTO swhulb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Wanaume wote wenye umri wa mwezi mmoja au zaidi walihesabiwa na kufikia idadi ya 7, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Koo za Wagerishoni watapanga upande wa magharibi wa hema. ");
INSERT INTO swhulb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasafu mwana wa Laeli ataongoza koo za uzao wa Wagerishoni. ");
INSERT INTO swhulb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Familia ya Gerishoni watalilinda hema la kukutania pamoja na hiyo masikani. Watalilinda hema, kifuniko chake, na lile pazia la lango la hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Wataulinda ua, lile pazia la kwenye lango—ua unaozunguka mahali patakatifu na madhabahu. Watazilinda kamba za hema ya kukutania na vyote vilivyomo. ");
INSERT INTO swhulb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Koo zifuatazo zinatokana na Kohathi: ukoo wa Waamrami, ukoo wa Waizihari ukoo wa Wahebroni, na ukoo wa Wauzieli. Koo hizi zinatokana na Wakohathi. ");
INSERT INTO swhulb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Wanaume 8, 600 wenye umri wa mwezi mmoja au zaidi walihesabiwa ili kulinda vitu vya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Familia ya uzao wa Kohathi watapanga upande wa kusini wa Hema. ");
INSERT INTO swhulb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elizafani mwana wa Uzieli ndiye atakayeongoza ukoo wa Wakohathi. ");
INSERT INTO swhulb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Watalilinda sanduku, meza, vikalishio vya taa, madhabahu, vitu vitakatifu ambvyo hutumika katika huduma yao, pazia, na kazi zote zinazoambatana na hema. ");
INSERT INTO swhulb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eliazari mwana wa Haruni kuhani atawaongoza wanaume wanaowaongoza Walawi. Atawasimamia wanaume wanaongoza eneo takatifu. ");
INSERT INTO swhulb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Koo mbili zimetoka kwa Merari: Ukoo wa Mahili na ukoo wa Mushi. Koo hizi zimetokana na Merari, ");
INSERT INTO swhulb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Wanaume 6, 200 wenye umri wa mwezi mmoja na zaidi walihesabiwa. ");
INSERT INTO swhulb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Zurieli mwana wa Abihaili ataongoza ukoo wa Merari. Hawa watapanga upande wa kaskazini mwa hema. ");
INSERT INTO swhulb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Uzao wa Merari utatunza mbao za hema, mataruma, nguzo, makalishio, viifaa vya ujenzi na vitu vyote vinavyohusika, ");
INSERT INTO swhulb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","na nguzo za ua zinazozunguka hema, makalishio, vigingi na kamba zake. ");
INSERT INTO swhulb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Haruni na watoto wake watapanga upande wa mashariki wa masikani, mbele ya hema ya kukutania kuelekea mawio ya jua. Wao wataajibika na majukumu ya mahali patakatifu na majukumu ya wana wa Israeli. Mgeni atakayekaribia mahali patakatifu auawe. ");
INSERT INTO swhulb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Musa na Haruni wakawahesabu wanaume wote wa ukoo wa Walawi walikuwa na umri wa mwezi mmoja na zaidi, kama vile BWANA alivyokuwa ameagiza.. Walihesabu wanaume ishirini na mbili elfu. ");
INSERT INTO swhulb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","BWANA alisema na Musa, “Wahesabu wanaume wote ambo ni wazaliwa wa kwanza wa Israeli ambao wana umri wa mwezi mmoja na zaidi. Orodhesha majina yao. ");
INSERT INTO swhulb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Unitwalie walawi kwa ajili yangu badala ya wazaliwa wa kwanza wa Israeli, Mimi ndimi BWANA. Na utwae wanyama wa Walawi badala ya wazaliwa wa kwanza wa wanyama wa uzao wa Israeli,” ");
INSERT INTO swhulb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa akawahesabu wazaliwa wa kwanza wote wa Israeli kama BWANA alivyomwagiza kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Aliwahesabu wazaliwa wote wa kwanza kwa mjina, wenye umri wa mwezi mmoja na zaidi. Alihesabu wanaume 22, 273. ");
INSERT INTO swhulb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tena BWANA alinena na Musa. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Watwae Walawi badala ya wazaliwa wote wa kwanza wa wana wa Israeli. Na utwae wanyama wa Walawi badala ya wanyama wa Waisreli wengine. Walawi ni mali yangu. Mimi ndimi BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Unikusanyie shekeli tano za wokovu kwa kila hao 273 za hao wazaliwa wa kwanza wa Israeli za hao wanaozidi idadi ya Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Utazitumia hizo shekeli tano kwa kipimo cha mahali patakatifu. Shekeli moja ni sawa na gera ishirini. ");
INSERT INTO swhulb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Utawalipa hizo shekeli za wokovu kwa Haruni na wanawe.” ");
INSERT INTO swhulb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kwa hiyo Musa akakusanya shakeli za wokovu kutoka kwa wale waliozidi idadi ya wale waliookolewa na Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Musa akakusanya zile fedha kutoka kwa hao wazaliwa wa kwanza wa wana wa Israeli. Alikusanya jumla ya shekeli 1, 365, zenye kipimo sawa na mahali patakatifu. Musa akamlipa Haruni na wanawe hizo shekeli za wokovu. ");
INSERT INTO swhulb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa akafanya kila kitu alichoagizwa na neno la BWANA kama BWANA alivyomwagiza. ");
INSERT INTO swhulb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","BWANA akanena na Musa na Haruni. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Fanya sensa ya uzao waume wa Kohathi kutoka kwa Walawi, kwa kufuata jamaa na na familia za koo. ");
INSERT INTO swhulb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Uwahesabu wanaume ambao wana umri wa miaka thelathini hadi miaka hamsini. Hawa wataungana na kundi linalotumika kutoa huduma kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Uzao wa Kohathi watalinda vile vitu vitakatifu zaidi vilivyohifadhiwa kwa ajili yangu katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Wakati kambi inapojiandaa kusonga mbele, Haruni na wanawe lazima waende hemani, kulishusha pazia linalotenganisha mahali patakatifu na kulifunika sanduku la ushuhuda kwa pazia hilo. Watalifunika hilo sanduku kwa ngozi za pomboo. ");
INSERT INTO swhulb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Watatandika juu yake nguo za rangi ya samawi. Watachomeka hiyo miti ya kubebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Watatandika nguo ya rangi ya samawi kwenye meza ya mikate ya wonyesho. Juu yake wataweka sahani, vijiko, mabakuli na vikombe vya kumiminia. Mikate itakuwepo daima mezani. ");
INSERT INTO swhulb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Wataifunika na nguo ya rangi nyekundu na ngozi za pomboo. na kuweka miti ya kubebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Watachukua nguo ya rangi ya samawi na kukifunika kinara, pamoja na taa zake, na koleo zake, na sahani zake na vikombe vyake vya kuwekea mafuta ya taa. ");
INSERT INTO swhulb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Wataweka kinara na vifaa vyake vikiwa vimefunikwa na ngozi ya pomboo, na wataweka kwenye miti ya kukibebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Watafunika na nguo ya samawi katika madhabau ya dhahabu. Wataifunika na ngozi za pomboo, na kuweka ile miti ya kubebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Watavichukua vyombo vyote vya kazi takatifu na kuvizonga kwenye hiyo nguo ya rangi ya samawi. Watavifunika na ngozi za pomboo na kuviweka hivyo vyombo kwenye miti ya kubebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Watayaondoa majivu kwenye madhabahu na kutandika nguo ya rangi ya zambarau juu yake. ");
INSERT INTO swhulb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Watavieka kwenye miti ya kubebea vyombo vyote wanavyovitumia kwa kazi ya madhabahuni. Vyombo hivi ni vyetezo, majembe, mabakuli na vitu vingine vya madhabahuni. Wataifuniks madhabahu na ngozi za pomboo na kuweka ile miti ya kubebea. ");
INSERT INTO swhulb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Wakati Haruni na wanawe walipokuwa wamekamilisha kupafunika mahali patakatifu na vyombo vyote, na kambi itakapoanza kuendelea mbele, ndipo wana wa Kohathi watakapokuja kubeba vitu vya mahali patakatifu. Kama watagusa vyombo vitakatifu, lazima watakufa. Hii ni kazi ya wana wa uzao wa Kohathi, kubeba mapambo ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eliazari mwana wa Haruni kuhani atalinda na kusimamia mafuta ya taa, ubani mzuri, sadaka za mara kwa mara na mafuta ya upako. Atasimamia ulinzi wa hema lote na vyote vilivyomo, mahali patakatifu na vyombo vyake.” ");
INSERT INTO swhulb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","BWANA akanena na Musa na Haruni. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Usiruhusu kabila la Wakohathi kuondolewa kati ya Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Walinde waishi ili wasije wakafa, kwa kufanya hivi. Wanapokuwa wanasogelea ");
INSERT INTO swhulb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","wasije wakaingia ndani ili kuona eneo takatifu hata kwa kitambo, vinginevyo watakufa. Bali Haruni na wanawe wanaweza kuingia, ndipo Haruni na Wanawe watakapowapangia Wakohathi kazi maalumu ya kufanya, kwa kila mmoj.” ");
INSERT INTO swhulb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","BWANA akanena na Musa tena, Akasema, “Fanya sensa kwa wana Gerishoni pia, kwa kufuata familia za mababu zao, koo zao. ");
INSERT INTO swhulb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Uwahesabu wale wenye umri wa mika thelathini hadi miaka hamsini. ");
INSERT INTO swhulb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Uwahesabu wote ili waje kuungana na wale wanaotumika katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Hii ndiyo itakuwa kazi ya koo za Gerishoni, wanapotumikia na wanachobeba. ");
INSERT INTO swhulb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Watabeba pazia la masikani, hema la kukutania, na vifunikio vyake, vifuniko vya ngozi ya pomboo ambvyo viko juu yake, na pazia kwenye lango la hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Watabeba pazia la ua, pazia la kwenye mlango wa ua, ambao uko karibu na maskani karibu na madhabahu, kamba zake na vifaa vyote vya utumishi wake. Chochote kinachotakiwa kufanywa kutokana na vitu hivi, wao ndio watakaofanya. ");
INSERT INTO swhulb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Haruni na wanawe ndio watakaongoza utumishi wa uzao wa Wagerishoni, kwa vitu vyote vile vya kusafirisha, na katika utumishi wao wote. Lazima uwagawie majukumu yao yote. ");
INSERT INTO swhulb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Huu ndio utumishi wa koo za uzao wa wana wa Wagerishoni katka hema ya kukutania. Ithamari mwana wa Haruni kuhani atawaongoza katika utumishi. ");
INSERT INTO swhulb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Utawahesabu uzao wa Merari kwa koo zao, na uwapange katika familia za mabau zao, ");
INSERT INTO swhulb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","kuanzia wenye umri wa miaka thelatini hadi miaka hamsini. Umuhesabu kila atakayeungana na kundi lenye utumishi katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Huu ndio wajibu na kazi yao katika utumishi wao kwenye hema ya kukutania. Watazilinda mbao za maskani, mataluma yake, nguzo na makalishio yake, ");
INSERT INTO swhulb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","pamoja na nguzo za ua zinazozunguka masikani, makalishio yake, vigingi na kamba zake, na vifaa vinginevya ujenzi. Waorodheshe kwa majina na majukumu yao. ");
INSERT INTO swhulb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huu ndio utumishi wa koo za uzao wa Merari, ambao wanatakiwa kufanya katika hema ya kukutania, chini ya uongozi wa Ithmari mwana wa Haruni kuhani.” ");
INSERT INTO swhulb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa na Haruni na viongozi wa watu waliwahesabu wana wa uzao wa Wakohathi kwa kufuata koo za familia za mababu zao. ");
INSERT INTO swhulb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Waliwahesabu wale wenye umri wa miaka thelathini hadi miaka hamsini. Walimhesabu kila mmoja aliyepaswa kuungana na kundi linalotoa huduma ya utumishi kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Waliwahesabu wanaume 2, 750 kwa kufuata koo zao. ");
INSERT INTO swhulb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Musa na Haruni waliwahesabu wanaume wote kutoka koo na familia za Wakohathi ambao hutumika kwenye hema ya kukutania. Walifanya hivi kwa kumtii BWANA aliyewaagiza kupitia kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Uzao wa Gerishoni walihesabiwa kufuata koo na familia za mababu zao, ");
INSERT INTO swhulb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","kuanzia umri wa miaka thelathini hadi miaka hamsini, kwa kila mmoja aliyetakiwa kuungana na watu wanaotoa huduma kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Wanaume wote waliohesabiwa kufuata koo na familia za mababu zao walikuwa 2, 630. ");
INSERT INTO swhulb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Musa na Haruni walizihesabu koo za uzao wa Gerishoni ambao watatumika kwenye hema ya kukutania. Walifanya hivi ili kutii ambacho BWANA aliwaamuru kufanya kuptia kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Uzao wa Merari walihesabiwa kwa koo kupitia familia za mababu zao, ");
INSERT INTO swhulb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","kuanzia wenye umri wa miaka thelathini hadi miaka hamsini, kila anayepaswa kuungana na watu wanaotumika kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Wanaume wote waliohesabiwa kupitia koo za familia za mababu zao walikuwa 3. 200. ");
INSERT INTO swhulb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Musa na Haruni waliwahesabu wanaume hawa, uzao wa Merari. Kw kufanya hivi walitii amri ya BWANA aliyowaaagiza kufanya kupitia kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Kwa hiyo Musa na Haruni na viongozi wa Israeli waliwahesabu Walawi wote kw kufuata koo na familia za mababu zao ");
INSERT INTO swhulb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","kuanzia wenye umri wa miaka thelathini hadi miaka hamsini. walimhesabu kila aliyepaswa kufanya kazi kwenye masikani, na kila aliyepaswa kubeba na kulinda vitu vya kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Waliwahesabu wanaume 8, 580. ");
INSERT INTO swhulb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kwa agizo la BWANA, Musa alimhesabu kila mwanamume na kutunza kumbukumbu ya kazi ambayo kila mmoja anaweza kufanya. Kwa hivyo, walitii kile ambacho BWANA alikuwa amewaagiza kufanya kupitia kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","BWANA alinena na Musa. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Waamuru wana wa Israel wawatoe watu wote wenye magonjwa ya ngozi yanayoambukiza, na kila mwenye mwenye vidonda vinavyotoa harufu, na ambaye amenajisika kwa kugusa maiti. ");
INSERT INTO swhulb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Awe mme au mke, umtoa kambini. Ili wasije wakaitia unajisi kambi, kwa sababu Mimi huishi ndani yake,” ");
INSERT INTO swhulb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Watu wa Israeli walifanya hivyo. Waliwatoa kambini, Kama BWANA alivyomwagiza Musa. Watu wa Israeli walimtii BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Tena BWANA akanena na Musa. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Nena na wana wa Israeli. mtu mume na mtu mke akifanya dhambi yeyote ambayo watu hufanyiana wao kwa wao, na mtu huyo akamwasi BWANA, mtu huyo atakuwa na hatia. ");
INSERT INTO swhulb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ndipo huyo mtu ataungama hiyo dhambi aliyoifanya. Mtu huyo atarudisha malipo ya hatia yake na kuongeza kwenye malipo hayo sehemu ya tano zaidi. Atamlipa huyo aliyemtendea makosa ");
INSERT INTO swhulb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Lakini kama huyo mtu huyu aliyetendewa kosa hana ndugu wa kupokea hayo malipo, basi atalipa hayo malipo ya hatia kwangu kupitia kuhani pamoja na kondoo dume kwa ajili ya sadaka yake mwenyewe. ");
INSERT INTO swhulb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kila sadaka ya wana wa Israeli, vitu ambavyo vimetengwa na vikaletwa kwa kuhani na watu wa Israeli, vitakuwa vyake. ");
INSERT INTO swhulb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Sadaka ya kila mtu itakuwa ya kuhani; kama mtu yeyote atatoa kitu chochote kwa kuhani, kitakuwa chake.” ");
INSERT INTO swhulb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Tena BWANA akanena na Musa. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Nena na wana wa Israel. Uwaambie, 'kama mke wa mtu ataasi na kufanya dhambi dhidi ya mume wake. ");
INSERT INTO swhulb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Halafu mtu mwingine akalala naye. Kwa sababu, hiyo atakuwa amenajisika. Na hata kama mume wake hakuona na hajui, hata kama hakuna mtu aliyemkamta akiwa katika tendo na hakuna mtu wa kushuhudia dhidi yake; hata hivyo ile roho ya wivu itaendele kumjulisha yule mume kuwa mke wake amenajisika. ");
INSERT INTO swhulb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ingawa, roho ya wivu inaweza kumdanganya yule mwanamume wakati mke wake hajanajisika. ");
INSERT INTO swhulb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Kwa mazingira hayo, yule mwanamume anapaswa kumpeleka mke wake kwa kuhani. Yule mwanamume anapaswa kutoa sadaka ya divai kwa ajili yake. Atapaswa kuleta sehemu ya kumi ya efa ya unga wa shayiri. Asitie mafuta juu yake wala asitie ubani juu yake maana ni sadaka ya unga ya wivu, ni sadaka ya unga ya ukumbusho wa uovu. ");
INSERT INTO swhulb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ndipo kuhani atasogeza karibu na kumweka mbele ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kuhani atachukua kikombe cha maji matakatifu na atachukua mavumbi ya kwenye masikani. Ataweka yale mavumbi kwenye maji. ");
INSERT INTO swhulb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kisha kuhani atamweka huyo mwanamke mbele za BWANA na atazifungua nywele kichwani kwa huyo mwanamke. Atamwekea mikononi mwake hiyo sadaka ya unga kwa ajili ya ukumbusho, ambayo ni sadaka ya unga kwa ajili ya wivu. ");
INSERT INTO swhulb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kuhani atashikilia mikononi mwake maji machungu yanayoweza kuleta laana. Kuhani atamweka huyo mwanamke chini ya kiapo na kumwambia. 'Kama haujafanya uzinzi na mwanaume mwingine, na kama hajakengeuka na kufanya uovu, basi utakuwa huru na maji haya yanayoweza kuleta laana. ");
INSERT INTO swhulb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lakini kama wewe, mwanamke uliye chini ya mume wako, umekengeuka, na kama umenajisika, na kama mwanamume mwingina amelala nawe, ");
INSERT INTO swhulb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ndipo, (kuhani atamtaka huyo mwanamke aape kiapo kinachoweza kuleta laana kwake, na kwamba ataendelea kumwambia yule mwanamke) 'BWANA atakufanya wewe kuwa laana itakayooneshwa kuwa hivyo kwa watu wako. Hii itatokea pale BWANA atakapoyafanya mapaja yako kuoza na tumbo lako kuvimba. ");
INSERT INTO swhulb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Haya maji ambayo huleta laana yataingia tumboni mwako na kulifanya tumbo lako kuvimba na mapaja yako kuoza,' mwanamke alitakiwa kujibu, 'Ndiyo, hayo yanipate kama mimi ni mwenye hatia.' ");
INSERT INTO swhulb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Naye kuhani ataziandika laana hizi kwenye kitabu, na kisha kuzifuta laana zilizoandikwa kwa maji ya uchungu. ");
INSERT INTO swhulb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Naye kuhani atamwelekeza yule mwanamke kunywa yale maji machungu yaletayo laana. Yale maji yaletayo laana yataingia na kuwa machungu. ");
INSERT INTO swhulb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kuhani ataitwaa ile sadaka ya unga ya wivu mikononi mwa yule mwanamke. Atailekeza ile sadaka ya unga mbele ya BWANA na kuileta madhabahuni. ");
INSERT INTO swhulb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kuhani atachukua konzi ya sadaka ya unga mkononi mwake kama sadaka ya kuwakilisha, na kuiteketeza madhabahuni. Ndipo atakapompatia mwanamke yale maji machungu ili ayanywe. ");
INSERT INTO swhulb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Wakati wa kumpa yale maji ili anywe, kama amenajisika kwa sababu alifanya uovu dhidi ya mume wake, ndipo yale maji yaletayo laana yatamwingia na kuwa machungu. Tumbo lake litavimba na paja lake litaoza. Yule mwanamke atalaaniwa kati ya watu wake. ");
INSERT INTO swhulb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Lakini kama yule mwanake hajanajisika na kama ni msafi, basi atakuwa huru. Tena ataweza kubeba uja uzito. ");
INSERT INTO swhulb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Hii ndiyo sheria ya wivu. Ni sheria ya mwanamke anayekengeuka kwa mumewe na kunajisika. ");
INSERT INTO swhulb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Ni sheria ya mwanamume mwenye roho ya wivu kwa mkewe. Atamleta mwanamke mbele ya BWANA, na kuhani atamfanyia huyo mwanamke kila kitu ambacho sheria ya wivu inamtaka kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Yule mwanamume atakuwa hana hatia kwa kumleta mke wake kwa kuhani. Na yule mwanmke atauchukua uovu wake.” ");
INSERT INTO swhulb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","BWANA alinena na Musa. Akamwabia, ");
INSERT INTO swhulb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","'Nena na wana wa Israeli, uwaambie, 'Kama mume au mke ataweka nadhiri kwa BWANA kwa kiapo maalumu cha mnadhiri, ndipo atajiepusha na divai na vileo. hatakunywa siki itokanayo na divai. ");
INSERT INTO swhulb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Asinywe kileo kitokanacho na siki au kilevi. Asinywe maji ya divai yeyote au kula zabibu mbichi wala zilizokauka. ");
INSERT INTO swhulb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Katika siku zote ambazo amejitenga kwa ajili yangu, asile chochote kinachotokana na zabibu, wala kitu chochote kitokanacho na makokwa hadi maganda. ");
INSERT INTO swhulb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Wakati wote wa nadhiri yake, wembe usiipite kichwani mwake mpaka siku zake za nadhiri kwa BWANA zitimilike. Lazima ajitenge kwa BWANA. Ataziacha nywele zake zikue kichwani mwake. ");
INSERT INTO swhulb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Wakati wote wa kujidhiri kwake kwa BWANA, asiikaribie maiti. ");
INSERT INTO swhulb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Asijinajisi kwa namna yeyote hata kama atakufa baba yake, mama, dada, au ndugu yake. Hii ni kwa sababu amejitenga kwa ajili ya Mungu, kama ambavyo kila mmoja anavyoweza kumuona kwa uerfu wa nywele zake. ");
INSERT INTO swhulb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Wakati wote wa kujidhiri kwake atakuwa mtakatifu, alijitunza kwa ajili ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ikitokea mtu amekufa ghafla pembeni yake na kukitia unajisi kichwa chake kitakatifu, ndipo atakaponyoa kichwa chake katika siku ya kujitakasa —Siku ya saba atanyoa kichwa chake. ");
INSERT INTO swhulb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Siku ya nane atamletea kuhani njiwa wawili au makinda mawili ya njiwa kwenye lango la hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Naye kuhani atamtoa ndege mmoja kama sadaka ya dhambi na mwingine kama sadaka ya kuteketezwa. Hawa watafanyika sadaka ya upatanisho kwake kwa sababu atakuwa ametenda dhambi ya kuwa karibu na mfu. Atatakasika kichwa chake siku hiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Atajitenga kwa BWANA tena katika siku hizo za utakaso. Ataleta kondoo mume mwenye umri wa mwaka mmoja kama sadaka ya hatia. Zile siku zake kabla ya kunajisika hazitahesabiwa, kwa sababu kujiweka wakfu kwake kulinajisika. ");
INSERT INTO swhulb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Hii ndiyo sheria ya mnadhiri wakati wa muda wa kujidhiri unapokuwa umetimia. Ataletwa kwenye mlango wa hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ataleta sadaka yake kwa BWANA. Atatoa mwanakondoo mume wa mwaka mmoja asiye na hila kama sadaka ya kuteketezwa. Ataleta kondoo mke wa mwaka mmoja asiye na hila kama sadaka ya dhambi. Ataleta kondoo mume asiye na hila kama sadaka ya amani. ");
INSERT INTO swhulb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ataleta kikapu cha mikate iliyotengenezwa bila amira, mikate ya unga mwembamba iliyokandwa kwa mafuta, mikate ya kaki isiyo na amira iliyopakwa mafuta, pamoja na sadaka za unga na sadaka za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kuhani atawaleta mbele za BWANA. Atazitoa hizo sadaka zake za dhambi na kuteketezwa. ");
INSERT INTO swhulb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Na kikapu cha mikate isiyowekwa amira, atamtoa yule kondoo mume kama sadaka ya amani kwa BWANA. Pia kuhani atatoa hiyo sadaka ya unga na sadaka ya vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Mnadhiri atanyoa nywele zake kama ishara ya kujitenga kwa ajili ya Mungu kwenye mlango wa hema ya kukutania. Atazitoa nywele zake kichwani kwake na kuzichoma kwa moto ulio chini ya sadaka ya amani. ");
INSERT INTO swhulb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kuhani atachukua bega la kondoo mume lililotokoswa, na mkate usiotiwa amira toka kikapuni, na mkate mmoja wa kaki usiotiwa amira. Atauweka kwenye mikono ya Mnadhiri baada ya kuwa amenyoa nywele kwa ishara ya kujidhiri. ");
INSERT INTO swhulb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kisha kuhani atavitikisa kuwa sadaka kwa BWANA, sehemu takatifu kwa kuhani, pamoja na kidari cha kutikiswa na paja lililotolewa kwa kwa kuhani. Baadaye, Mnadhiri anaweza kunywa divai. ");
INSERT INTO swhulb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hii ndiyo sheri ya Mnadhiri anayeapia sadaka yake kwa BWANA kwa ajili ya kujidhiri kwake. Chochote atakachotoa, lazima afanye kama alivyoapa, kuilinda ahadi yake kama ilivyoaniswa katika sheria ya Mnadhiri. ");
INSERT INTO swhulb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Tena BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“nena na Harunu na wanawe. Uwaambie, 'mtawabariki wana wa Israeli kwa njia hii. Mtawaambia, ");
INSERT INTO swhulb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","BWANA na awabariki na kuwatunza. ");
INSERT INTO swhulb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","BWANA na awaangazie nuru ya uso wake na awe mwenye neema kwenu. ");
INSERT INTO swhulb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","BWANA na awatazame kwa neema na awape amani.'” ");
INSERT INTO swhulb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ni kwa jinsi hii kwamba wanaweza kuwapa jina langu wana wa Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Siku ambayo Musa alikamilsha masikani, alitia mafuta na kuiweka wakfu kwa BWANA, pamoja na mapambo yake. Aliifanyia hivyo madhabahu na vyombo vyake. Aliitia mafuta na kuiweka wakfu kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Siku hiyo, viongozi wa Israeli na wale vichwa vya familia za mababu walitoa sadaka. Hawa wanaume walikuwa viongozi wa makabila. Walisaidia kuhesabu watu kwenye ile sensa. ");
INSERT INTO swhulb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Walileta sadaka zao kwa BWANA. Walileta magari sita yaliyofunikwa na mafahari kumi na mbili. Walileta gari moja kwa kila viongozi wawili, kila kiongozi alileta fahari moja. Walileta vitu hivi mbele ya masikani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Kisha BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Uzipokee hizo sadaka kutoka kwao na uzitumie kwa matumizi ya kazi ya hema ya kukutania. Uwape hizo sadaka Walawi, kwa kila mmoja kadri ya uhitaji wa kazi yake.” ");
INSERT INTO swhulb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Musa akayatwaa yale magari na mafahari. na kuwapatia Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Aliwapa magari mawili na mafahari wanne wale wa uzao wa Gerishoni, kwa sababu ndivyo kazi yao ilivyohitaji. ");
INSERT INTO swhulb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Aliwapatia uzao wa Merari magari manne na mafahari nane, chini ya uangalizi wa Ithamari mwana wa Haruni kuhani. Alifanya hivi kwa sababu ya uhitaji wa kazi yao. ");
INSERT INTO swhulb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Lakini wale wa uzao wa Kohathi hakuwapa chochote kwa sababu wao waliangalia vitu vtakatifu amabvyo vilipaswa vibebwe mabagani mwao, siyo kwa magari. ");
INSERT INTO swhulb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Viongozi walitoa bidhaa zo zingine kwa ajili ya kuwekwa wakfu kwa madhabahu katika siku ile ambayo Musa aliitia mafuta madhabahu. Viongozi walitoa sadaka zao mbele ya madhabahu hiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","BWANA akasema na Musa, “kila kiongozi atatoa sadaka kwa siku yake kwa ajili ya kuiweka wakfu madhabahu.” ");
INSERT INTO swhulb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Katika siku ya kwanza, Nashoni mwana wa Aminadabu, wa kabila ya Yuda, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130 na bakuli moja ya fedha ambayo uzito wake ni shekeli sabini, kwa kipimo cha mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Pia alimpa unga wa dhahabu kiasi cha bakuli moja chenye uzani wa shekeli kumi kilichojaa ubani ");
INSERT INTO swhulb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Alitoa sadaka ya kuteketezwa fahari mchanga, kondoo dume mmoja na mwanakondoo dume mmoja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Alitoa beberu kama kama sadaka ya hatia. ");
INSERT INTO swhulb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Alitoa makisai mbili, kondoo waume watano, beberu watano na wanakondoo dume watano wenye umri wa mwaka mmoja mmoja, kama sadaka ya amani. Hii ilikuwa sadaka ya Nashoni mwana wa Aminadabu. ");
INSERT INTO swhulb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Siku ya pili, Nethanel mwana wa Zuari, kiongozi wa Isakari, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Sadaka yake ilikuwa sahani moja ya fedha ya uzito wa shekeli130 na bakuli moja la fedha lenye uzani wa sheli sabini, kwa kipimo cha mahali patakatifu. Viyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Pia alitoa kijiko kimoja cha dhahabu chenye uzito wa shekeli kumi, iliyojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Alitoa sadaka ya kuteketezwa fahari mchanga, kondoo dume mmoja, na mwanakondoo mmoja dume. ");
INSERT INTO swhulb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Alitoa beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Alitoa makisai wawili, Kondoo dume watano, beberu watano, na wanakondoo dume watano wa mwaka mmoja mmoja kuwa sadaka ya amani. Hiii likuwa sadaka ya Nethaneli mwana wa Zuari. ");
INSERT INTO swhulb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Siku ya tatu, Eliabu mwana wa Heloni, kiongozi wa uzao wa Zabuloni alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130, na bakuli moja la fedha lenye uzito wa shekeli sabini kwa kipimo cha shekeli za mahali patakatifu. vyombo vyote hivi vilikuwa vimeja unga mwembemba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Alitoa sadaka ya fahari mchanga, kondoo dume mmoja, na mwanakondoo dume mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Alitoa beberu mmoja kama sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Alitoa makisai wawili, kondoo dume watano, beberu watano, na wanakondoo dume watano wa mwaka mmoja mmoja. kuwa sadaka ya amani. Hii ilikuwa sadaka ya Eliabu mwana Heloni. ");
INSERT INTO swhulb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Siku ya nne, Elizuri mwana wa shedeuri, kiongozi wa uzao wa Reubeni, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130 na bakuli moja la fedha lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo hivi vyote vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichoo jaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Alitoa sadaka ya kuteketezwa fahari mmoja mchanga, mwanakondoo dume mmoja mchanga wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Alitoa beberu moja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Alitoa maksai wawili, kondoo dume watano wa mwaka mmoja kuwa sadaka ya amani. Hii ilikuwa sadaka ya Elizuri mwana wa Shedeuri. ");
INSERT INTO swhulb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Siku ya tano, Shelumieli mwana wa Zurishadai, kiongozi wa uzao wa Simeoni, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shaekali 130 na bakuli mojala fedha lenye uzani wa shekeli sabini kwa kipimo cha shekeli za mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, uliojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Alitoa sadaka ya kuteketezwa fahari mchanga, dume la kondoo, na dume la mwanakondoo la mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Alitoa beberu moja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Alitao maksai wawili, dume wawili wa kondoo, beberu watano, na dume watano wa wanakondoo wa mwaka mmoja mmoja kuwa sadaka y amani. Hiindiyo iliyokuwa sadka ya Shelumei mwana wa Zurishadai. ");
INSERT INTO swhulb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Siku ya sita, Eliasafu mwana wa Deuli, kiongozi wa uzao wa Gadi, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130 na bakuli la shaba lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo hivi vyote vilikuwa vimejaa unga mwembemba uliochanganywa na mafuta kwa ajili ya sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Alitoa sadaka ya kuteketezwa ya fahari changa, kondoo dume mmoja, na dume la mwanakondoo mmoja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Alitoa beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Alitoa maksai wawili, dume watano wa kondoo, beberu watano, na wanakondoo dume watano wa mwaka mmoja kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Eliasafu mwana wa Deuli. ");
INSERT INTO swhulb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Siku ya saba, Elishama mwana wa Amihudi, kiongozi wa uzao wa Efraimu, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130 na bakuli la fedha lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo hivi vyote ilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Pia alitoa kijiko kimoja cha dhahabu, kilichojaa ubani ");
INSERT INTO swhulb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Alitoa sadaka ya kuteketezwa, fahari mmoja, kondoo dume mmoja, na mwanakondoo dume mmoja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Alitoa beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Alitoa maksai wawili, kondo dume watano, beberu watano, na na wanakondoo dume watano wa mwaka mmoja mmoja kuwa sadaka ya amani. Hii ndiyo ilikuwa sdaka ya Elishama mwana wa Amidu. ");
INSERT INTO swhulb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Siku y a nane, Gamaliel mwana wa Pedazuri, kiongozi wa uzao wa Manase, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli130 na bakuli moja la fedha lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Alitoa sadaka ya kuteketezwa ya fahari mmoja, kondoo dume mmoja, na mwanakondoo dume mmoja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Alitoa beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Alitoa maksai wawili, kondoo dume watano, beberu watano, na wanakondoo dume watano wa mwaka mmoja mmoja kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Gamaliel mwana wa Pedazuri. ");
INSERT INTO swhulb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Siku ya tisa, Abidani mwana wa Gidioni, kiongozi wa uzao wa Benjamini, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Sadaka yake ilikuwa sahani moja yafedha yenye uzani wa sheli 130 na bakuli moja la fedha lenye uzito wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Alitoa sadaka ya kuteketezwa fahari mmoja mchanga, kondoo dume mmoja, na mwanakondoo dume mmoja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Alitoa beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Alitoa makisai wawili, kondoo dume watano, beberu watano, na wanakondoo dume watano kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Abidani mwana wa Gidioni. ");
INSERT INTO swhulb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Siku ya kumi, Ahizeri mwana wa Amishadai kiongozi wa Dani alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Alitoa sahani moja ya fedha yenye uzani wa shaekeli 130 na bakuli moja lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Pia alitoa kijiko kimoja cha dhahabu chenye uzito wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Alitoa sadaka ya kuteketezwa fahari mmoja mchanga, dume moja la kondoo, na dume moja la mwanakondoo wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Alitoa beberu moja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Alitoa maksai wawili, kondoo dume watano, beberu watano, na wanakondoo dume watano wa mwaka mmoja mmoja, kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Ahizeri mwana wa Amishadai. ");
INSERT INTO swhulb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Siku ya kumi na moja. Pagieli mwana wa Okrani kiongozi wa uzao wa Asheri alaitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Sadaka yake ilikuwa sahani moja ya fedha yenye uzani wa shekeli 130 na bakuli moja la fedha lenye uzani wa shekeli sabani, kwa kipimo cha shekeli ya mahali patakatifu. Vyombo vyote hivi ilikuwa vimejaa unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Alitoa sadaka ya kuteketezwa fahari mmoja mchanga. dume la kondoo moja, dume moja la mwanakondoo wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Alitoa beberu moja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Alitoa maksai wawili, dume watano wa kondoo, na wanakondoo dume watano kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Pagieli mwana wa Okrani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Siku ya kumi na mbili., Ahira mwana wa Enani, kiongozi wa uzao wa Naftali, alitoa sadaka yake. ");
INSERT INTO swhulb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Sadaka yake ailikuwa sahani moja ya fedha yenye uzani wa shaekeli 130 na bakuli moja la fedha lenye uzani wa shekeli sabini, kwa kipimo cha shekeli za mahali patakatifu. Vyombo vyote hivi vilikuwa vimejaa unga mwembamba ulichanganywa na mafuta kuwa sadaka ya unga. ");
INSERT INTO swhulb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Pia alitoa kijiko kimoja cha dhahabu chenye uzani wa shekeli kumi, kilichojaa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Alitoa sadaka ya kuteketezwa fahari mmoja mchanga, dume moja la kondoo, na mwanakondoo dume moja wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Alitoa beberu moja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Alitoa maksai wawili, kondoo dume watano, beberu watano, na wanakondoo dume watano wa mwaka mmoja mmoja kuwa sadaka ya amani. Hii ndiyo iliyokuwa sadaka ya Ahra mwana wa Enani. ");
INSERT INTO swhulb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Viongozi wa Israeli waliviweka wakfu hivi vitu vyote siku ambayo Musa alimimina mafuta kwenye madhabahu. Waliziweka wakfu zile sahani kumi na mbili za fedha, Bakuli kumi na mbili za fedha, na vijiko kumi na vili vya dhahabu. ");
INSERT INTO swhulb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Zile sahani za fedha kila moja ilikuwa na uzani wa shaekeli 130 na kila bakuli ye fedha ilikuwa na uzani wa shekeli sabini. Vyombo vyote vya fedh vilikuwa na ujumla ya uzani wa shekeli 2, 400, kwa kipimo cha shekeli za mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Vile vijiko vya dhahabu vilivyokuwa vimejaa ubani, vilikuwa na uzani wa shekeli kumi kila kimoja. Vijiko vyote vya dhahabu vilikuwa na uzani wa shekeli 120. ");
INSERT INTO swhulb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Waliwatenga wanyama wote kwa ajili ya sadaka ya kuteketezwa, fahari kumi na wawili, kondoo dume kumi na wawili, na wanakondoo dume kumi na wawili wa mwaka mmoja mmoja. Walitoa sadaka yao ya unga. Walitoa beberu kumi na wawili kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Kutokana na ng'ombe zao, walitoa fahari ishirini na nne, kondoo dume sitini beberu sitini, na wanakondoo dume sitini wa mwaka mmoja mmoja kuwa sadaka ya amani. Hii ilikuwa kwa ajiliya kuiweka wafu ile madhabahu baada ya kumiminiwa mafuta. ");
INSERT INTO swhulb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa alipoingia kwenye hema ya kukutania kusema na BWANA, ndipo alipoisikia sauti yake ikisema naye. BWANA alinena naye kutoka juu ya kiti cha rehema kilichokuwa juu ya sanduku la ushahidi, kutoka katikati ya makerubi. Alinena naye. ");
INSERT INTO swhulb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Sema na Haruni umwambie, 'zile taa saba lazima zimulike mbele ya kinara utakapoziwasha,” ");
INSERT INTO swhulb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruni alifanya haya. Aliziwasha zile taa juu ya kinara ili ziangaze mbele yake kama BWANA alivyomwagiza Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kinara kilitengenezwa kwa njia hii kama BWANA alivyomwelekeza Musa muundo wake. Kiitakaiwa kutengenezwa kwa dhahabu kuanzia kwenye kitako chake hadi juu, ndivyo kilivyotakiwa kutengenezwa kwa dhahabu kwa maua hadi juu. ");
INSERT INTO swhulb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Tena, BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","'“Uwatwae Walawi kati ya wana wa Israeli na uwatakase.” ");
INSERT INTO swhulb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Uwafanyie hivi ili kuwatakasa: Uwanyunyizie maji ya utakaso juu yao. Hakikisha wamenyoa miili yao yote, wafue nguo zao, na kwa njia hii wajitakase wenyewe. ");
INSERT INTO swhulb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kisha wachukue fahari mchanga na sadaka ya unga mwembamba uliochanganywa na mafuta. Halafu wachukue fahari mchanga kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Uwalete Walawi mbele ya hema ya kukutania, na uwakusanye jamii yote ya wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Uwalete Walawi mbele yangu, BWANA. Wana wa Israeli wataweka mikono yao juu ya Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haruni atawatoa Walawi mbele yangu, kuwa sadaka ya kutikiswa. Atafanya hivi ili kwamba Walawi wanitumikie. ");
INSERT INTO swhulb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Walawi wataweka mikono yao juu ya hao fahari. Mtatoa fahari mmoja kuwa sadaka ya dhambi na fahari mwingine kuwa sadaka ya kuteketezwa kwangu, ili kuwa upatanisho kwa Walawi. ");
INSERT INTO swhulb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Walete Walawi mbele ya Haruni na mbele ya wana wake, uwainue kuwa sadaka ya kutikiswa kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kwa njia hii utawatenganisha Walawi toka wana wa Israeli. Walawi watakuwa wangu. ");
INSERT INTO swhulb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Baadaye Walawi wataingia ndani ya hema ya kukutania. Utawatakasa. utawatoa kuwa sadaka ya kutikiswa ");
INSERT INTO swhulb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Fanya hivi kwa sababu wao ni wangu wote kutoka kwa wana wa Israeli. Watachukua nafasi ya kila mzaliwa wa kwanza afunguaye tumbo, mzaliwa wa kwanza wa uzao wa Israeli. Nimewachukua Walawi kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Wazaliwa wa kwanza wote kutoka kwa wana wa Israeli ni wangu, watu wote pamoja na wanyama pia. Siku ile nilipowachukua wazaliwa wa kwanza katika nchi ya Misri, Niliwatenga kwa ajili yangu ");
INSERT INTO swhulb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nimewachukua Walawi kutoka kwa wana wa Israeli badala ya wazaliwa wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nimewatoa Walawi kuwa zawadi kwa Haruni na wana wake. Nimewachukua toka wana wa Isreali ili kuwatumikia wana wa Israeli katika hema ya kukutania. Nimewatoa ili kuwa upatanisho kwa watu ili kwamba wasipatwe na mapigo wakati wanapokaribia kwenye eneo takatifu. ");
INSERT INTO swhulb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Haruni na jamii ya Waisraeli wote waliwafanyia Walawi hivi. Walifanya kila kitu ambacho BWANA alikuwa amemwamuru Musa kuhusu Walawi. Wana wa Israeli wakafanya haya pamoja nao. ");
INSERT INTO swhulb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Walawi wakajitakasa wenyewe na kufua mavazi yao, Na Haruni akawatoa kama sadaka ya kutikiswa kwa BWANA na akafanya upatanisho kwao ili kuwatakasa. ");
INSERT INTO swhulb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Baada ya hayo, Walawi waliingia ndani kufanya utumishi wao katika hema ya kukutania mbele ya Haruni na mbele ya wanawe. Kama BWANA alivyokuwa amemwagiza Musa juu ya Walawi. Waliwahudumia Walawi wote kwa jinsi hii. ");
INSERT INTO swhulb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","BWANA akanena na Musa tena, Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Haya yote ni kwa ajili ya Walawi ambao wana umri wa miaka ishirini na mitano na zaidi. Wataungana na wale wanaohudumia hekaluni. ");
INSERT INTO swhulb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Wataacha kutoa huduma hii watakapokuwa na umri wa miaka hamsini. Katika umri huu hawatakiwi kuendelea na huduma tena. ");
INSERT INTO swhulb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Wanaweza kuwasaidia ndugu zao wanaoendelea kufanya kazi ndani ya hema ya kukutania, lakini hawatakiwai kufanya kazi tena. Utawaelekeza Walawi kuyafahamu haya yote.” ");
INSERT INTO swhulb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","BWANA akanena na Musa katika katika jangwa la Sinai, mwezi wa kwanza wa mwaka wa pili baada ya kutoka katika nci ya Misri. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Wana wa Israeli wataikumbuka Pasaka katika wakati wake kila mwaka. ");
INSERT INTO swhulb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Siku ya kumi na nne ya mwezi huu, muda wa jioni, utaikumbuka Pasaka kila mwaka kwa muda uliopanggwa. Lazima uikumbuke, fuata taratibu zake zote na utii sheria zake zote zinazohusiana na tukio hilo. ");
INSERT INTO swhulb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kwa hiyo, Musa akawaambia wana wa Isareli kuwa wataishika sikukuu ya Pasaka. ");
INSERT INTO swhulb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kwa hiyo wakaishika sikuu ya Pasaka katika mwezi wa kwanza, wakati wa jioni wa siku ya kumi na nne ya mwezi katika jangwa la Sinai. Wana wa Israeli walitii kila kitu ambacho BWANA alimwamuru Musa kukifanya. ");
INSERT INTO swhulb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kulikuwa na watu fulani walionajisika kwa sababu ya maiti ya mtu. Hawakuweza kuishika Pasaka siku hiyo. Kwa hiyo walikwenda kwa Musa na Haruni siku hiyohiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wakamwambia Musa, “Sisi tumenajisika kwa sababu ya maiti ya mtu. Kwa nini basi unatutaka tuendelee kutoa sadaka kwa BWANA kwa wakati wa mwaka uliopangwa kwa wana wa Israeli?” ");
INSERT INTO swhulb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Naye Musa akawaambia, “Subirini nimsikilize BWANA ataniambia nini juu Yenu.” ");
INSERT INTO swhulb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Nena na wana wa Israeli, uwaambie, 'kama mmoja wenu au mwana wa uzao wenu amenajisika kwa sababu ya maiti, au ana safari ndefu, bado anaweza kuishika Pasaka ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Wataishika Pasaka siku ya kumi na nne ya mwezi wa pili wakati wa jioni. Wataila kwa mikate isyotiwa chahcu na mboga chungu. ");
INSERT INTO swhulb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Wasiiache mpaka jioni, au kuvunja mifupa yake. Watafuata taratibu zote za Pasaka. ");
INSERT INTO swhulb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Lakini mtu yeyote asiye najisi na hayuko safarini, na akashindwa kuishika Pasaka, huyo mtu lazima aondolewe kati ya watu wake kwa sababu hakutoa sadaka ambayo BWANA huitaka kwa wakati wa mwaka uliopangwa. Huyo mtu lazima aibebe dhambi yake. ");
INSERT INTO swhulb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kama mtu mgeni anayeishi kati yenu na akaishika, Pasaka kwa heshima ya BWANA, ataishika na kufanya amri zote, na kutii taratibu zake. Utakuwa na sheria hizohizo kwa wageni na kwa wote waliaozaliwa katika nchi. ");
INSERT INTO swhulb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Na siku hiyo ambayo masikani iliposimamishwa, wingu lilifunika masikani, ile hema ya amari ya agano. Ilipokuwa jioni wingu lilkuwa juu ya masikani. Lilionekana kama moto mpaka asubuhi. ");
INSERT INTO swhulb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Liliendelea hivyohivyo. Lile wingu lilifunika masikani na kuonekana kama moto wakati wa usiku. ");
INSERT INTO swhulb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Na kila wingu lilipochukuliwa kutoka kwenye hema, wana wa Isareli waliendelea na safari yao. Na kila wingu liliposimama, watu waliweka kambi. ");
INSERT INTO swhulb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Wana wa Israrli walisafiri kwa amri ya BWANA, na kwa amri yake waliweka kambi. Wakati wingu liliposimama juu ya masikani, nao walikaa kwenye kambi zao. ");
INSERT INTO swhulb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Na wingu lilipobaki kwenye masikani kwa siku nyingi, wana wa Israeli walitakiwa kutii maelekezo ya BWANA na kusitisha safari yao. ");
INSERT INTO swhulb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Wakati mwingine wingu lilibaki kwa siku chache tu kwenye masikani. Kwa mazingira kama hayo walilazimika kutii amri ya BWANA - waliweka kambi na kisha kuendelea na safari tena kwa amri yake. ");
INSERT INTO swhulb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wakati mwingine wingu lilikuwepo kambini kuanzia jioni mpaka asubuhi. Na wingu liliponyanyuliwa asubuhi, walisafiri. Kama liliendelea kwa mchana wote na kwa usiku wote, ni pale tu wingu liliponyanyuliwa ndipo walipoendelea na safari. ");
INSERT INTO swhulb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Hata kama wingu lilibaki kwenye masikini kwa siku mbili, kwa mwezi mmoja, au kwa mwaka mmoja, ili mradi tu limebaki pale, wana wa Israeli walibaki kwenye kambi zao na kusitisha safari. Lakini pale wingu liliponyanyuliwa, walianza safari yao. ");
INSERT INTO swhulb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Walifanya kambi kwa amri ya BWANA, na walisafiri kwa amri yake. Walitii amri ya BWANA iliyotolewa kupitia kwa Musa ");
INSERT INTO swhulb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","BWANA alinena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“tengenza tarumbeta mbili za fedha. Uzitengeneze kwa kufua hizo fedha. Utazitumia hizo tarumbeta kwa kuwaita watu waje pamoja na kwa kuwaita watu wote wakati wa kuondoka kwenye kambi zao. ");
INSERT INTO swhulb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Makuhani watapiga tarumbeta kwa ajili ya kuwaita watu wote mbele yako kwenye lango la hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kama makuhani watapiga tarumbeta moja tu, basi viongozi, vichwa koo za Israeli ndipo watakapokutana kwako. ");
INSERT INTO swhulb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Utakapopiga tarumbeta ya sauti kuu, ile kambi ya upande wa mashariki itaanza kusafiri. ");
INSERT INTO swhulb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nawe utakapopiga tarumeta kwa sauti kuu mara ya pili, ile kambi ya upande wa kusini wataanza kusafiri. Watapiga tarumbeta kwa sauti kuu ili kuanza safari yao. ");
INSERT INTO swhulb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Watu wote watakapokutana pamoja, piga hizo tarumbeta lakini si kwa sauti kuu. ");
INSERT INTO swhulb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Wana wa Haruni, makuhani, watapiga hizo tarumbeta. Huu ndio utakaokuwa utaratibu wa watu wako kwa vizazi vyote. ");
INSERT INTO swhulb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Nanyi mtakapoenda vitani katika ardhi yenu dhidi ya maadui wenu wanaowakandamiza, ndipo mtakapotoa ishara ya sauti ya tarumbeta. Mimi, BWANA Mungu wako nitawaita kuwakumbuka na kuwaokoa kutoka kwa maadui wenu. ");
INSERT INTO swhulb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Pia, wakati wa kusherehekea, sikukuu zenu za kawaida na katika miandamo ya miezi, mtapiga tarumbeta zenu kwa heshima ya sadaka zenu za kuteketezwa na kwa sadaka zenu za amani. Huu utakuwa ukumbusho wenu kwangu, Mungu wenu. Mimi ndimi BWANA Mungu wenu.” ");
INSERT INTO swhulb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Katika siku ya ishrini, mwezi wa pili, mwaka wa pili, Lile wingu liliinuliwa toka masikani ya amri za maagano. ");
INSERT INTO swhulb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Wana wa Israeli wakaendelea na safari yao toka jangwa la Sinai. Lile wingu likasimama kwenye jangwa la Parani. ");
INSERT INTO swhulb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Walifanya safari yao ya kwanza, kufuatia amri ya BWANA iliyotolewa kupitia kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Kambi ya mahali pa uzao wa Yuda iliondoka ya kanza, wakiondoa majeshi yao binafsi. Nashoni mwana wa Aminadabu ndiye aliyeongoza jeshi la Yuda. ");
INSERT INTO swhulb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneli mwana wa Zuari aliongoza jeshi la kabila la uzao wa Isakari. ");
INSERT INTO swhulb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliabu mwana wa Heloni aliongoza jeshi la kabila la Zabuloni. ");
INSERT INTO swhulb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Uzao wa Gerishoni na Merari, ambao walitunza masikani, na kuanza kusafiri. ");
INSERT INTO swhulb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Baadaye Walifuata jeshi la mahali pa kambi ya Reubeni walianza safari yao. Elizuri mwana wa Shedeuri alliongoza jeshi la Reubebni. ");
INSERT INTO swhulb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mwana wa Zurishadai aliliongoza jeshi la kabila la uzao wa Simeoni. ");
INSERT INTO swhulb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasafu mwana Deuli aliliongoza jeshi la kabila la uzao wa Gadi. ");
INSERT INTO swhulb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kabila la Kohathi nalo lilianza safari. Wao walibebba vyombo vya mahali patakatifu. Wengine waliisimamisha masikani kabla ya Wakohathi kufika kambi inayofuata. ");
INSERT INTO swhulb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Majeshi ya kabila la uzao wa Efraimu ndio waliofuata. Elishama mwana wa Amihudi ndiye aliyeongoza jeshi la Efraimu. ");
INSERT INTO swhulb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwana wa Pedazuri aliongoza jeshi la uzao wa Manase. ");
INSERT INTO swhulb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidani mwana wa Gidioni aliongoza jeshi la uzao wa kabila la Benjamini. ");
INSERT INTO swhulb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Lile jeshi lililoweka kambi mahali pa bango la uzao wa Dani lilikuwa la mwisho kuondoka. Ahizeri mwana wa Amishadai ndiye aliyeongoza jeshi la Dani. ");
INSERT INTO swhulb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mwana wa Okirani aliongoza jeshi la wana wa uzao wa Asheri. ");
INSERT INTO swhulb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira mwana wa Enani aliongoza jeshi la uzao wa kabila ya Naftali. ");
INSERT INTO swhulb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hivi ndivyo majeshi ya wana wa Israeli yalivyosafiri. ");
INSERT INTO swhulb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa alinena na Hobibu mwana wa Reueli wa Kabila la Midiani. Reueli alikuwa baba mke wa Musa. Musa akanena na Hobibu akasema, “Tunasafiri kuelekea mahali ambapo BWANA ametuahidi. BWANA alisema kuwa, “Nitawapeni ninyi hilo eneo, 'Njoni pamoja nasi na tutawatendea mema. BWANA ameahidi kuwafanyia mema Waisraeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Lakini Hobibu akmwambia Musa, “Sitaambatana nanyi.” ");
INSERT INTO swhulb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Naye Musa akamjibu, “Tafadhali msituache. Mnajua jinsi ilivyo kuweka kambi jangwani. Tunaomba mtujali. ");
INSERT INTO swhulb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kama mtaambatana nasi tutawatendea mema sawa na jinsi BWANA anavyotutendea.” ");
INSERT INTO swhulb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Walisafiri kutoka mlima wa BWANA kwa siku tatu. Sanduku la agano la BWANA liliwatangulia kwa siku tatu ili kupata mahali pa kupumzika. ");
INSERT INTO swhulb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wingu la BWANA lilikuwa juu yao muda wote wa mchana walipokuwa safarini. ");
INSERT INTO swhulb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kila hilo sanduku liliposafiri kwenda mbele, Musa alisema, “Inuka BWANA, Uwatawanye maadui wako. Uwafanye wale wanaokuchukia kukukimbia.” ");
INSERT INTO swhulb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na kila lile sanduku liliposimama, Musa alisema, “BWANA uwarudie, hawa Waisraeli makumi elfu.” ");
INSERT INTO swhulb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Sasa watu wakanung'unika juu ya matatizo yao wakati BWANA alipokuwa akiwasikiliza. BWANA akawasikia watu naye akakasirika. Moto kutoka kwa BWANA ukashuka na ukawaka kati yao na kuteketeza baadhi ya kambi kwenye pembe zake. ");
INSERT INTO swhulb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ndipo watu wakamwita Musa kwa nguvu, Naye Musa akamwomba BWANA, na ule moto ukazimika. ");
INSERT INTO swhulb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mahali pale paliitwa Tabera, kwa sababu moto wa BWANA uliwaka kati yao. ");
INSERT INTO swhulb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Baadhi ya wageni wakaanza kuweka kambi zao pamoja na wana wa wa Israeli. Walitaka kula chakula kizuri. Kisha wana wa Israeli walipoanza kulia wakisema, “Ni nani atakayetupatia nyama za kula? ");
INSERT INTO swhulb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tunakumbuka samaki tulizokula bure kule Misri, yale matango, na matikiti maji, na mboga na vitunguu na vitunguu saumu. ");
INSERT INTO swhulb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Na sasa hatuna hamu ya kula, kwa sababu tunaona mana tu. ");
INSERT INTO swhulb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ilifanana na punje ya mtama. ilionekana kama bedola. ");
INSERT INTO swhulb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","watu wakazunguka kisha wakakusanyika. Wakaisaga, wakaitwanga kwa vinu, wakaitokosa nyunguni, na kuitengeneza mikate. radha yake ilikuwa kama mafuta mapya ya mizeituni. ");
INSERT INTO swhulb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Na umande ulipoanguka kambini usiku ule, na mana ilianguka pia. ");
INSERT INTO swhulb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa akawasikia watu wakilia katika familia zao, na kila mtu alikuwa kwenye lango la hema yake. BWANA alikasirika sana, na mbele ya macho ya Musa malalamiko yao yalikuwa mabaya. ");
INSERT INTO swhulb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa akasema na BWANA, “Kwa nini umemtendea mtumishi wako vibaya namna hiyo? kwa nini hujapendezwa na mimi? unanifanya kubeba mizigo ya hawa watu. ");
INSERT INTO swhulb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Je, mimi ndiye niliyewatungia mimba hawa watu? Mimi ndiye niliyewazaa kiasi kwamba unaniambia, “wabebe kwa ukaribu vifuani mwako kama baba abebavyo mtoto wake? Je, nitawabeba mpaka kwenye nchi ambayo uliwaahidi mababu zao kuwapa? ");
INSERT INTO swhulb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Naweza kupata wapi nyama za kuwapa watu wote hawa? Wanalia mbele zangu na wanasema, 'tupe nyama tule.' ");
INSERT INTO swhulb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mimi peke yangu siwezi kuwabeba watu wote hawa. Ni wengi sana kwangu. ");
INSERT INTO swhulb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kwa vile unanitendea hivi, basi uniue, na kama wewe ni mpole kwangu, basi niondolee mzigo huu.” ");
INSERT INTO swhulb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","BWANA akamwambia Musa, “Niletee wazee sabini miongoni mwa Waisraeli. Hakikisha ni wazee na viongozi wa watu. Uwalete kwenye hema ya kukutania wasimame pamoja na wewe. ");
INSERT INTO swhulb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nami nitashuka niseme nawe mahali pale. Nitatoa sehemu ya roho iliyo ndani yako na kuwapatia wao. Nao watabeba mzigo wa watu pamoja nawe. na hautaubeba peke yako. ");
INSERT INTO swhulb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Waambie watu, 'Jitakaseni ninyi wenyewe, kwa kuwa kesho mtakuala nyama, kwa kuwa mmelia na BWANA amesikia, “Mlipokuwa mkisema kuwa nani atakayetupa nyama tule? Kule Misri tulikula chakula kizuri!” Kwa hiyo BWANA atawapeni nyama, nanyi mtakula nyama. ");
INSERT INTO swhulb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hamtakula nyama kwa siku moja tu, au siku mbili, au siku tano, au siku kumi, au siku ishirini, ");
INSERT INTO swhulb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Lakini mtakula nyama kwa mwezi mmoja mpaka zitakapowatokea puani. Mpaka zitawakinai kwa sababu mmemkataa BWANA ambaye yuko kati yenu. Mmelia mbele yake. mmesema, “Kwa nini tulitoka Misri?”” ");
INSERT INTO swhulb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Kisha Musa akasema, “Mimi nina watu 600, 000, na wewe umesema, “Nitawapa nyama mle kwa mwezi mmoja,' ");
INSERT INTO swhulb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Je, tutayachinja haya makundi ya ng'ombe na kondoo ili kuwatosheleza?” ");
INSERT INTO swhulb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","BWANA akasema na Musa, “Je mkono wangu ni mfupi? Sasa utaona kama maneno yangu ni ya kweli ama sivyo. ");
INSERT INTO swhulb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa alitoka nje kwenda kuwaambia watu maneno ya BWANA. Aliwakusanya wazee sabini wa watu na kuwaweka kuizunguka hema. ");
INSERT INTO swhulb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","BWANA akashuka chini katika wingu akaongea na Musa. BWANA akachukua sehemu ya roho iliyokuwa kwa Musa na kuiweka kwa wale wazee sabini. Roho alipowashukia, wakaanza kutoa unabii, lakini ilitokea kwenye tukio hilo tu na haikujirudia tena. ");
INSERT INTO swhulb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Watu wawili waitwao Elidadi na Medadi walibaki kambini. Lakini Roho aliwashukia pia. Majina yao yalikuwa yameandikwa kwenye orodha lakini walikuwa hawajaenda hemani. Hata hivyo nao walitoa unabii wakiwa kambini. ");
INSERT INTO swhulb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Kijana mmoja huko kambini alikimbia akaenda kumwambia Musa, “Elidadi na Medadi wanatoa unabii kambini.” ");
INSERT INTO swhulb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua mwana wa Nuni, msaidizi wa Musa, ambaye ni miongoni mwa wale aliowachagua akamwambia Musa, “Bwana wangu Musa, wazuie.” ");
INSERT INTO swhulb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa akamwambia, “una wivu kwa niaba yangu? Natamani kama watu wote wa BWANA wangekuwa manabii na kwamba angeweka Roho yake juu yao wote!” ");
INSERT INTO swhulb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Kisha Musa na wale wazee wakarudi kambini. ");
INSERT INTO swhulb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kisha upepo ukavuma kutoka kwa BWANA ukaja na kware kutokea baharini. Wakaanguka karibu na kambi, kiasi cha umbali wa safari ya siku moja upande huu na umbali wa siku moja upande mwingine. Wale kware wakaizunguka kambi kiasi cha mita moja toka uso wa dunia. ");
INSERT INTO swhulb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Watu wakawakusanya hao kware kwa bidii mchana huo wote na usiku huo wote, na mchana wote uliofuatia. Hakuna aliyekusanya pungufu ya mita mbili za uajazo. Wakawaanika kweye ardhi yote hapo kambini. ");
INSERT INTO swhulb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Wakati ile nyama ikiwa bado iko kwenye meno yao, wakiwa bado wanatafuna, BWANA akawakasirikia. Akwapiga watu wale kwa gonjwa kubwa sana. ");
INSERT INTO swhulb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Mahali pale paliitwa Kibroti Hataava, kwa sababu pale walizika watu waliotamani nyama. ");
INSERT INTO swhulb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kutoka Kibroti Hataava watu wakasafiri hadi Hazeroti, ambapo walipumzika. ");
INSERT INTO swhulb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Kisha Miriamu na Haruni wakasema kinyume na Musa kwa sababu ya mwanamke Mkushi ambaye alikuwa amemwoa. ");
INSERT INTO swhulb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Walisema. “ Hivi BWANA amesema na Musa tu? Ni kweli hajawahi kusema nasi pia? Sasa BWANA akasikia kile walichokuwa wanaongea. Sasa ");
INSERT INTO swhulb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa alikuwa mtu mpole sana, mpole kuliko mtu yeyote duniani. ");
INSERT INTO swhulb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Wakati huo, BWANA akanena na Musa, Haruni na Miriamu: “tokeni nje ninyi watatu kwenye hema ya kukutania.” kwa hiyo wale watatu wakatokanje. ");
INSERT INTO swhulb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kisha BWANA akashuka katika nguzo ya wingu. Akasimama kwenye lango la hema na akamwita Haruni na Miriamu. wote wakaja mbele. ");
INSERT INTO swhulb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","BWANA akasema, “Sasa sikilizeni maneo yangu, Nabii wangu anapokuwa nanyi, Mimi nitajifunua kwake kwa maono na kusema naye katika ndoto. ");
INSERT INTO swhulb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lakini si hivyo kwa mtumishi wangu Musa. Yeye ni mwaminifu katika nyumba yangu yote. ");
INSERT INTO swhulb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mimi huongea na Musa moja kwa moja, si kwa maono wala mafumbo. Yeye huniona umbo langu. Kwa hiyo, kwa nini hamuogoopi kumnenea kinyume, mtumishi wangu Musa?” ");
INSERT INTO swhulb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Hasira ya BWANA ikawawakia, kisha akawaacha. ");
INSERT INTO swhulb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Lile wingu likainuka juu ya hema, Miriamu akapata ukoma ghafla - akawa mweupe kama theluji. Naye Haruni alipogeuka kumwona Miriamu, akamwona amepata ukoma. ");
INSERT INTO swhulb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Haruni akamwambia Musa, “Bwana wangu, usituadhibu kwa uovu wetu huu. Tumenena katka upumbuvu, na tumetenda dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Tafadhali nakuomba usimwache akawa kama mtoto mchanga aliyekufa ambaye nusu ya nyama yake imeoza tangu kuzaliwa” ");
INSERT INTO swhulb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kwa hiyo Musa akamwomba BWANA, akasema, “Mungu ninakusihi umponye tafadhali.” ");
INSERT INTO swhulb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","BWANA akamwambia Musa, “ kama baba yake angemtemea usoni angepata aibu kwa muda wa siku saba. Umfungie nje ya kambi kwa muda wa siku saba. Kisha umrejeshe ndani tena.” ");
INSERT INTO swhulb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kwa hiyo Miriamu akafungiwa nje ya kambi kwa siku saba. Watu hawakusafiri mpaka aliporudi kambini. ");
INSERT INTO swhulb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Kisha watu wakasafiri kutoka Hazeroti na kuweka kambi kwenye jangwa la Parani. ");
INSERT INTO swhulb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kisha BWANA akanena na Musa, akamwambia, “tuma watu waende kuipeleleza nchi ya Kanani, ambayo nimewapa wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Tuma mwanamume mmoja kutoka kila jamaa ya kabila. Kila mwanamume awe kiongozi katika kabila lake.” ");
INSERT INTO swhulb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa akawatuma kutoka jangwa la Parani, ili watii amri ya BWANA. Watu wote hao walikuwa viongozi wa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Majina yao yalikuwa haya yafuatayo: kutoka kabila la Reubeni, Shamua mwana wa Zakuri; ");
INSERT INTO swhulb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kutoka kabila la Simeoni, Shafati mwana wa Hori; ");
INSERT INTO swhulb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kutoka kabila la Yuda, Kalebu mwana wa Yefune; ");
INSERT INTO swhulb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kutoka kabila la Isakari, Igali mwana wa Yusufu, ");
INSERT INTO swhulb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kutoka kabila la Efraimu, Hoshea mwana wa Nuni; ");
INSERT INTO swhulb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kutoka kabila la Benjamini, Paliti mwana wa Rafu; ");
INSERT INTO swhulb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","kutoka kabila ya Zabuloni, Gadieli mwana wa Sodi; ");
INSERT INTO swhulb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","kutoka kabila la Yusufu (hiyo inamaanisha kutoka kabila la Manase), Gadi mwana wa Susi; ");
INSERT INTO swhulb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","kutoka kabila la Dani, Amieli mwana wa Gemalili; ");
INSERT INTO swhulb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","kutoka kabila Asheri, Setu mwana wa Mikaili; ");
INSERT INTO swhulb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","kutoka kabila la Naftali, Nabi mwana wa Vofisi; ");
INSERT INTO swhulb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kutoka kabila la Gadi, Geuli mwana wa Machi. ");
INSERT INTO swhulb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Haya ndiyo majina ya wanaume ambao Musa aliwatuma kwenda kuipelelza ile nchi. Musa akamwita Hoshea mwana wa Nuni kwa jina la Joshua. ");
INSERT INTO swhulb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa akawatuma kwenda kuipeleleza ile nchi ya Kanani. Naye akawaambia, “ Mkaanzie Negebu hadi mahali pa milima. ");
INSERT INTO swhulb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kaipelelezeni nchi kujua ni nchi ya namna gani. Wachunguzeni watu wake, kama ni watu wenye nguvu au dhaifu, kama ni wachache au ni wengi. ");
INSERT INTO swhulb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Chunguzeni nchi hiyo wanayoishi ni nchi ya namna gani. Ni nzuri au mbaya? Miji yao ikoje? Je iko kama kambi au ni miji yenye ngome? ");
INSERT INTO swhulb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Chunguzeni ni nchi ya namna gani, kama ni njema kwa mazao au la kama kuna miti au hapana. Mwe hodari mkalete sampuli za mazao ya nchi,” Sasa ni muda wa msimu wa malimbuko ya mizabibu. ");
INSERT INTO swhulb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kwa hiyo wale wanaume wakaenda kuipeleleza ile nchi kutoka jangwa la Sini mpaka Rehobi, karibu na Lebo Hamati. ");
INSERT INTO swhulb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Walienda kutoka Negebu nao wakafika Hebroni. Ahimani, Sheshai, na Talmai, Uzao wa Anaki nao walikuweko, Sasa Hebroni ilikuwa imejengwa miaka saba iliyokuwa imepita kabla ya Zoani wa Misri. ");
INSERT INTO swhulb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Nao walipofika katika bonde la Eshikoli, walikata matawi ya mizabibu lenye kishada cha zabibu. Na makundi mawili ya wapelelezi wakakibeba kwenye mti. Pia wakaleta makomamanga na mtini. ");
INSERT INTO swhulb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Mahali pale paliitwa Eshikoli, kwa sababu ya kishada cha mizabibu ambacho wana wa Israeli walikata kule. ");
INSERT INTO swhulb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Baada ya siku arobaini, wakarudi kutoka kuipeleleza nchi. ");
INSERT INTO swhulb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wakaja kwa Musa, Haruni na kwa watu wote wa Israeli katka jangwa la Parani, kule Kadeshi. Wakaleta taarifa kwao na kwa Waisraeli wote, na kuwaonyesha matunda ya nchi ile. ");
INSERT INTO swhulb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wakamwambia Musa, “Tulifika katika ile nchi uliyotutuma. Kwa hakika ni nchi ya kutiririka maziwa na asali. Na baadhi ya matunda yake ni haya hapa. ");
INSERT INTO swhulb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Hata hivyo, watu wanaoishi huko ni wenye nguvu. Miji yao ni mikubwa tena ina maboma. Pia tuliwaona wana wa Anaki huko. ");
INSERT INTO swhulb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Waamaleki wanaishi Negebu. Wahiti, Wayebusi, na Waamori nao wanaishi katika milima ya hiyo nchi. Wakanaani wanaishi kando ya bahari na mto Yorodani.” ");
INSERT INTO swhulb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kisha Kalebu akawatuliza watu waliokuwa mbele ya Musa, akasema, “Twendeni tukaiteke nyara hiyo nchi, kwa kuwa tuna uhakika wa kuikamata.” ");
INSERT INTO swhulb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lakini wale watu waliokuwa wameenda naye walisema, “Hatutaweza kuwashinda hao watu kwa kuwa wao ni hodari kuliko sisi.” ");
INSERT INTO swhulb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kwa hiyo wakasambaza taarifa za kukatisha tamaa kwa Wana wa Israeli juu ya nchi ile waliyoipeleleza. Walisema, “Ile nchi tuliyoiona ni nchi inayowala watu wake. Watu wote tuliowaona ni watu warefu. ");
INSERT INTO swhulb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Kule tuliiona majitu, wana wa uzao wa Anaki, ambao nii uzao wa majitu. Sisi tulionekana kama panzi machoni mwao tulipojilingsnisha nao, hivyo ndivyo tulivyoonekana machoni mwao pia.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Usiku huo watu wote walilia kwa sauti. ");
INSERT INTO swhulb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Watu wote wa Israeli wakamlalamikia Musa na Haruni. Watu wote wakawaambia, “Ni bora kama tungelifia katika nchi ya Misri, au katika hili! ");
INSERT INTO swhulb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kwa nini BWANA alituleta katika nchi hii ili tufe kwa upanga? Wake zetu na watoto wetu watakuwa watumwa wao. Je, si bora kwetu kurudi Misri?” ");
INSERT INTO swhulb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Wakasemezana wao kwa wao, “Na tuchague kiongozi mwingine, turudi Misri.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ndipo Musa na Haruni wakalala kifudifudi mbele ya kundi lote la wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua mwana wa Nuni na Kalebu mwana wa Yefune, ambao walikuwa miongoni mwa wale waliokuwa waemtumwa kwenda kuipeleleza nchi wakachana mavazi yao. ");
INSERT INTO swhulb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Wakawaambia watu wote wa Israeli. Walisema, “Ile nchi tuliyopita katikati yake ni nchi nzuri sana. ");
INSERT INTO swhulb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kama BWANA amependezwa nasi, basi atatuingiza katika nchi hii na kutupatia. Ile nchi inatiririka maziwa na asali. ");
INSERT INTO swhulb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Lakini msimwasi BWANA, na msiwahofie hao wakazi wa nchi hiyo. Tutawateketeza kwa urahisi kama kula chakula. Ulinzi wao utaondolewa kutoka kwao, kwa sababu BWANA yuko pamoja nasi. Msiwahofie.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Lakini watu wote walitishia kuwapiga kwa mawe mpaka wafe. Kisha utukufuwa BWANA ukaonekana kwenye hema ya kukutania kwa watu wote wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","BWANA akamwambi Musa, “watu hawa watanidharau hadi lini? Wataendelea kutoniamini mpaka lini? Nijapokuwa nimefanya ishara kwa nguvu zangu kati yao? ");
INSERT INTO swhulb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nitawapiga kwa mapigo, na kuwaondolea urithi, na kufanya taifa kubwa kutoka kwenye ukoo wako ambalo litakuwa kubwa na lenye nguvu kuliko wao. ");
INSERT INTO swhulb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa akamwambia BWANA, “Kama utafanya hivi, Na Wamisiri wakisikia habari hizi, na kwa sababu uliwaokoa kutoka kwao kwa nguvu zako. ");
INSERT INTO swhulb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Basi watawaambia wakazi wa nchi hii. Wamesikia ya kuwa wewe BWANA u kati ya watu hawa, kwa sababu uso wako waonekana. Wingu lako husimama juu ya watu wetu. Wewe huwatangulia katika nguzo ya wingu wakati wa mchana na katika nguzo ya moto wakati wa usiku. ");
INSERT INTO swhulb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Sasa kama utawaua hawa watu kama mtu mmoja, basi mataifa ambao wamesikia sifa zako watasema, ");
INSERT INTO swhulb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Kwa Sababu BWANA hana uwezo wa kuwapeleka watu hawa katika nchi ambayo aliwaapia kuwapa, ndiyo maana amewaua katika jangwa hili.' ");
INSERT INTO swhulb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Sasa, nakusihi, utumie uweza wako. Kwa kuwa umesema kuwa, ");
INSERT INTO swhulb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'BWANA si mwepesi wa hasira na ni mwingi wa uaminifu katika agano. Yeye husamehe uovu na uasi. Kwa vyovyote vile atafutilia hatia atakapoleta hukumu ya dhambi za mababu juu ya wazao wao, kwa kizazi cha tatu na cha nne.' ");
INSERT INTO swhulb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ninakusihi uwasameha watu hawa dhambi zao kwa sababu ya ukuu wa uaminifu wa agano lako, kama vile ambavyo umekuwa ukiwasamehe watu hawa tokea wakati wakiwa Misri mpaka sasa.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","BWANA akasema, Nimewasamehe kwa kama ulivyoomba, ");
INSERT INTO swhulb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","bali kama Niishivyo, na kama vile dunia yote itakavyojazwa na utukufu wangu, ");
INSERT INTO swhulb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","watu wote walioona utukufu wangu na ishara za nguvu zangu nilizotenda kule Misri na kule jangwani - Lakini bado wamenijaribu mara kumi sasa na hawakuisikiliza sauti yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Kwa hiyo nasema kwamba hakika hawataiona nchi ile ambayo niliwaahdi kuwapa mababu zao. Hakuna hata mmoja wao ambao wamenidharau watakaoiona, ");
INSERT INTO swhulb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","isipokuwa mtumishi wangu Kalebu, kwa sababu alikuwa na roho nyingine. Yeye amenifuata kwa ukamilifu; Yeye nitampeleka katika nchi hiyo ambayo alienda kuipeleleza. Wazao wake wataimilki. ");
INSERT INTO swhulb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Sasa Waamaleki na Wakanani waliishi katika bonde.) Kesho mtageuka na kwenda katika jangwa kwa njia ya bahari ya Shamu.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","BWANA akanena na Musa na Haruni, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Nitaivumilia jamii ya watu hawa waovu ambao wananinung'unikia mpaka lini? Nimeyasikia malalamiko ya wana wa Israeli dhidi yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Waambie, 'Kama niishivyo,' asema BWANA, 'kama vile mlivyosema katika masikio yake, nitawafanyia jambo hili: ");
INSERT INTO swhulb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Maiti zenu zitaanguka katika jangwa hili, Ninyi nyote mliolalamika dhidi yangu, ninyi mliohesabiwa kwenye ile sensa, idadi yote ya watu kuanzia umri wa mika ishirini na kuendelea. ");
INSERT INTO swhulb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kwa hakika hamtaingia kwenye ile nchi ambayo niliahidi kuwapa kuwa makazi yenu, isipokuwa Kalebu mwana wa Yefune na Joshua mwana wa Nuni. ");
INSERT INTO swhulb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Bali watoto wenu ambao mlisema kuwa watakuwa watumwa, wao ndio nitakaowapeleka katika nchi hiyo. Wao wataifurahia nchi ambayo nInyi mmeikataa! ");
INSERT INTO swhulb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Lakini ninyi, maiti zenu zitaanguka katika jangwa hili. ");
INSERT INTO swhulb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Watoto wenu watakuwa wachungaji katika jangwa hili kwa muda wa miaka arobaini. Lazima watabeba madhara ya matendo yenu ya kutokuamini mpaka mwisho wa maiti ya mwisho jangwani. ");
INSERT INTO swhulb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kama vile ilivyo hesabu ya siku ambayo mliipeleleza nchi—siku arobaini, vivyo hivyo mtabeba madhara ya dhambi zenu kwa muda wa miaka arobaini—mwaka mmoja kwa kila siku moja, na mtajua kuwa ni sawa na kuwa adui yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mimi BWANA nimesema. Hakika nitafanya hivi kwa kizazi hiki chote kiovu ambacho kimekusanyika kinyume na Mimi. Wao watakatwa kabisa, na watafia hapa.'” ");
INSERT INTO swhulb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Kwa hiyo wale wanaume ambao Musa aliwatuma kwenda kuingalia ile nchi wote walikufa kwa tauni mbele ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Hawa ni wale ambao waliorudi na kutoa taarifa mbaya juu ya nchi. Hii iliwafanya watu wote wamlalamikie Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Kati ya watu wale waliokuwa wameenda kuiangalia nchi ile, ni Joshua mwana wa Nuni na Kalebu mwana wa Yefune tu ndio waliobaki hai. ");
INSERT INTO swhulb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa alipowataarifu mambo haya watu wote wa Israeli waliomboleza sana. ");
INSERT INTO swhulb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Waliamka asubuhi na mapema wakaenda juu ya mlima na kisha wakasema, “Tazama, tuko hapa, na tutaenda mahali pale ambapo BWANA ametuahidi, kwa kuwa tumetenda dhambi.” ");
INSERT INTO swhulb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Lakini Musa akasema, “Kwa nini sasa mnapinga amri ya BWANA? hamtafanikiwa. ");
INSERT INTO swhulb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Msiende, kwa sababu BWANA hayuko pamoja nanyi kuwalinda dhidi ya maadui zenu. ");
INSERT INTO swhulb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Waamaleki na Wakanaani wako kule, na mtakufa kwa upanga kwa sababu mliumtegea mgongo BWANA na hamkumfuata. Kwa hiyo hatakuwa pamoja nanyi. ");
INSERT INTO swhulb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Lakini walithubutu kukwea mlimani; lakini si Musa wala Sanduku la agano la BWANA walioondoka kambini. ");
INSERT INTO swhulb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Kisha Waamaleki walikuja chini, pia wale Wakanaani walioshi kwenye hiyo milima. Wakawavamia Waisreli wakawapiga na kuwaangusha mpaka Horima. ");
INSERT INTO swhulb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kisha BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Sema na wana wa Israeli uwaambie, 'Mtakapoingia katka nchi ambayo mtaishi, ambayo BWANA atawapa, ");
INSERT INTO swhulb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mtatakiwa kuandaa sadaka kwa moto kwa BWANA, sadaka ya kuteketezwa au sadaka ya kukamilisha kiapo au sadaka ya hiari, au sadaka katika sikukuu zenu, ili kutoa harufu nzuri kwa BWANA ya ng'ombe au ya kondoo. ");
INSERT INTO swhulb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Utamtolea BWANA sadaka ya kuteketezwa pamoja na sehemu ya kumi ya efa ya sadaka ya unga mwembamba uliochanganywa na robo ya hini ya mafuta. ");
INSERT INTO swhulb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Na tena mtatoa pamoja na sadaka ya kuteketezwa, au kwa sadaka ya divai robo ya hini ya sadaka ya vinywaji kwa kila mwanakondoo. ");
INSERT INTO swhulb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kama unatoa sadaka ya kondoo dume, utaandaa sadaka ya unga ya sehemu za kumi mbili za efa ya unga mwembamba uliochanganywa na sehemu ya tatu ya hini ya divai. ");
INSERT INTO swhulb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Kwa sadaka ya kinywaji, mtatoa sehemu ya tatu ya hini ya divai ambayo itatoa harufu nzuri kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Utakapoandaa fahari kwa ajiliy a sadaka ya kuteketezwa au sadaka ya kutimiza kiapo, au sadaka ya amani kwa BWANA, ");
INSERT INTO swhulb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Ndipo utakapotoa sadaka ya fahari pamoja na sadaka ya unga ya sehemu za kumi tatu za unga mwembamba uliochanganywa na nusu ya hini ya mafuta. ");
INSERT INTO swhulb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Mtatoa sadaka ya kinywaji nusu ya hini ya divai, sadaka iloyotengenezwa kwa moto ili kufanya harufu nzuri kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Itafanyika hivi kwa kila fahari, kwa kila kondoo dume, na kila mwanakondoo dume au mbuzi mchanga. ");
INSERT INTO swhulb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Kila sdaka utakayoindaa na kuitoa itafanyika kama ilivyoanishwa hapa. ");
INSERT INTO swhulb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Wazawa wote wa Israeli watafanya mambo haya kwa utaratibu huu, yeyote atakayeleta sadaka iliyotengenezwa kwa moto, ili kufanya harufu nzuri kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na kama kuna mgeni anayeishi kati yenu, au yeyote atakayeishi na watu wa vizazi vyenu vyote, lazima atengeneze sadaka iliytoengenezwa kwa moto, ili kutoa harufu nzuri kwa BWANA. Atafanya kama mnavyofanya. ");
INSERT INTO swhulb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kutakuwa na sheria hiyo hiyo kwa watu wote na kwa mgeni anayeishi kati yenu, sheria ya kudumu kwa watu wote wa uzao wako. Ninyi mlivyo, ndivyo atakavyokuwa mgeni aliyeishi kati yenu. Atafanya kama mnavyofanya mbele ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sheria na amri hiyohiyo ndiyo itakayotumika kwa mgeni anayeishi kati yenu.” ");
INSERT INTO swhulb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Tena BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Nena wana wa Israeli uwaambie, 'mtakapofika katika nchi ninayowapeleka, ");
INSERT INTO swhulb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mtakapokula chakula kinachozalishwa katika nchi hiyo, mtatoa sadaka ya kunipendeza mimi. ");
INSERT INTO swhulb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Kutoka kwenye mikate yenu ya kwanza mtatoa mkate wa kuinuliwa kama sadaka iliyoinuliwa kutoka mahali pa kupuria nafaka. Mtaiinua kwa jinsi hii. ");
INSERT INTO swhulb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Watu wa uzao wako wote wtanitolea sadaka ya kuinuliwa kutoka kwenye unga wenu wa kwanza. ");
INSERT INTO swhulb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Wakati mwingine mtafanya dhambi pasipo kukusudia, Kama hamtatii amri zote hizi ambazo nimemwambia Musa ");
INSERT INTO swhulb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","-kila kitu ambacho nimewaamuru kupitia Musa kuanzia siku ambayo nilianza kuwaamuru na kuendelea kwa watu wote wa uzao wako. ");
INSERT INTO swhulb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Kwa swala la dhambi isiyokusudiwa ambayo watu wote hawaijui, basi watu wote watatoa fahari mchanga sadaka ya kuteketezwa ili kufanya harufu nzuri kwa BWANA. Pamoja na haya yote, lazima itengenezwe sadaka ya unga na sadaka ya kinywaji, kama ilivyoagaizwa katika amri, na beberu mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kuhani atafanya sadaka upatanisho kwa watu wote wa Israeli. Watasemehewa kwa sababu dhambi haikukusudiwa. Wametoa sadaka yao, sadaka iliyotengenezwa kwa moto kwa ajili yangu. Wameleta sadaka yao kwangu iliyotengenezwa kwa moto. Wameleta sadaka yao ya uovu mbele yangu kwa ajili ya kosa lao. ");
INSERT INTO swhulb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ndipo watu wote wa Israeli watasamehewa, pia wageni wote wanaoishi kati yao, kwa sababu watu wote walitenda dhambi pasipo kukusudia. ");
INSERT INTO swhulb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kama mtu atatenda dhambi bila kukusudia, atatoa mbuzi jike wa umri wa mwaka mmoja kuwa sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Naye kuhani atafanya upatanisho kwa BWANA kwa ajili ya mtu yule aliyefanya dhambi pasipo kukusudia. Yule mtu atasamehewa baada ya upatanisho kufanyika. ");
INSERT INTO swhulb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mtakuwa na sheria hiyohiyo kwa mtu yeyote anayefanya dhambi hiyo pasipo kukusudia, sheria hiyohiyo hata kwa mzawa wa Isreli na kwa wageni wanaoishi kati yao. ");
INSERT INTO swhulb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lakini mtu afanyaye chochote kwa KUkusudia, awe mzawa au mgeni, ananikufuru mimi. Huyo mtu ataondolewa kati ya watu wake. ");
INSERT INTO swhulb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Kwa sababu atakuwa amedharau neno langu na amevunja neno amri yangu, mtu huyo ataondolewa kabisa. Dhambi yake itakuwa juu yake.'” ");
INSERT INTO swhulb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Wakati wana wa Israeli walipokuwa katika jangwa, wakamuona mwanamume akikusanya kuni sikiu ya Sabato. ");
INSERT INTO swhulb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wale waliomwona wakamleta kwa Musa, Haruni na kwa watu wote. ");
INSERT INTO swhulb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Wakamweka kifungoni kwa sababu ilikuwa haijaamuliwa atakachotendewa. ");
INSERT INTO swhulb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Kisha BWANA akanena na Musa, “Yule mwanamume lazima auawe. Watu wote lazima wampige kwa mawe nje ya kambi.” ");
INSERT INTO swhulb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kwa hiyo watu wote wakamtoa nje ya kambi nao wakampiga kwa mawe mpaka akafa kama vile BWANA alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","BWANA akanena na Musa tena, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Waambie wana wa Israeli na uwaamuru wajifanyie vishada wavining'inize katika mapindo ya mavazi yao, wavining'ineze katika ncha zote kwa nyuzi za rangi ya samawi. Watu wote watafanya hivi kwa watu wote wa kizazi chote. ");
INSERT INTO swhulb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Huu utakuwa ukumbusho maalumu kwenu, kila mtakapovitazama, mtakumbuka amri zangu, na kuzishika ili kwamba msije mkatangatanga katika mioyo na macho yenu na kuwa waasherati wa hayo. ");
INSERT INTO swhulb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Fanyeni hivi ili kwamba mweze kukumbuka na kutii amri zangu zote, na ili kwamba mpate kuwa watakatifu, waliotunzwa kwa ajili yangu, Mungu wenu. ");
INSERT INTO swhulb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mimi ndimi BWANA Mungu wenu niliyekutoa toka nchi ya Misri, ili niwe Mungu wenu. Mimi ndimi BWANA Mungu wenu.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Sasa Kora mwana wa Izihari mwana wa Kohathi mwana wa Lawi, pamoja na Dathani na Abiramu mwana wa Eliabu, na Oni mwana wa Peleti, wa uzao wa Reubeni, waliwakusanya wanaume kadhaa. ");
INSERT INTO swhulb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Wakamwinukia Musa, pamoja na wanaume fulani kutoka wana wa Israeli, viongozi wa watu wapatao mia mbili na hamsini waliokuwa wakifahamika katika ile jamii. ");
INSERT INTO swhulb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Walikusanyika pamoja kumpinga Musa na Haruni. Wakawaambia, “Ninyi sasa mnatumia mamlaka zaidi ya uwezo wenu! Watu wote wamejitenga, kila mmoja wao, na BWANA yuko pamoja nao. Kwa nini mnajiinua sana juu ya watu wengine wa BWANA?” ");
INSERT INTO swhulb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa alipoyasikia hayo, akalala kifudifudi. ");
INSERT INTO swhulb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Akamwambia Kora na wote aliokuwa nao, “Asubuhi BWANA atafanya ijulikane ni nani walio wake na nani aliyetengwa kwa ajili yake. Atamleta huyo mtu karibu na yeye. Yule anayemchagua atamleta karibu naye. ");
INSERT INTO swhulb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Fanya hivi, wewe Kora na kundi lako. ");
INSERT INTO swhulb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Kesho mchukue vyetezo na muweke moto na ubani ndani yake mbele ya BWANA. Yule ambaye BWANA amemchagua, atamtenga kwa BWANA. Sasa imetosha ninyi watu wa uzao wa Lawi,” ");
INSERT INTO swhulb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Tena Musa akamwambia Kora, “Sasa unisililize, ninyi watu wa uzao wa Lawi: ");
INSERT INTO swhulb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Je ni jambo dogo kwenu kwamba Mngu wa mbinguni amewatenga ninyi kutoka watu wa Israeli, ili awalete ninyi karibu na yeye, ili mfanye kazi katika masikani ya BWANA na kusimama mbele ya watu ili muwatumikie? ");
INSERT INTO swhulb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Amewasogeza karibu, na ndugu zako, wa uzao wa Lawi pamoja nanyi, na sasa mnataka na ukuhani pia! ");
INSERT INTO swhulb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hiyo ndiyo sababu wewe na kundi lako mmekusanyika pamoja kinyume na BWANA. Kwa nini mnalalamika juu ya Haruni, ambaye anamtii BWANA?” ");
INSERT INTO swhulb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kisha Musa akamwita Dathani na Abiramu, wana wa Eliabu, lakini wakasema, “hatutakuja. ");
INSERT INTO swhulb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kwani jambo dogo kwamba umetuleta mpaka kwenye nchi inayotiririka maziwa na asali, ili kutuua katika jangwa hili? Sasa unataka kujifanya kuwa mtawala wetu! ");
INSERT INTO swhulb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Na kwa nyongeza, haujatuingiza kwenye nchi ya kutiririka maziwa na asali, au kutupa urithi wa mashamba na mashamba ya mizabibu. Sasa unataka kutupofusha na ahadi hewa? Hatutakuja kwako.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa alikasirika sana na akamwambia BWANA, “Usisipokee sadaka zao. Sijachukua punda mmoja kutoka kwao, na sijamdhuru hata mmoja wao.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kisha Musa akamwambia Kora, “Kesho wewe na kundi lako mtaenda mbele za BWANA-wewe na wao na Haruni. ");
INSERT INTO swhulb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kila mmoja wenu atatwaa chetezo na kuweka ubani ndani yake. Ndipo kila mtu atamletea BWANA chetezo chake, vyetezo mia mbili na hamsini. Wewe na Haruni, pia, kila mmoja ataleta chetezo chake. ");
INSERT INTO swhulb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kwa hiyo kila mtu alitwaa chetezo chake, akaweka moto ndani yake, akaweka na ubani ndani yake, na kusimama mbele ya lango la hema ya kukutania pamoja na Musa na Haruni. ");
INSERT INTO swhulb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora naye akawakusanya watu wote waliokuwa kinyume na Musa na Haruni hapo kwenye lango la hema ya kukutania, na kisha utukufu wa BWANA ukaonekana kwa watu wote. ");
INSERT INTO swhulb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ndipo BWANA aliposema na Musa na Haruni: ");
INSERT INTO swhulb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Tokeni ninyi kutoka hawa watu ili nipate kuwaangamiza haraka.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa na Haruni wakalala kifudifudi na kusema, “Mungu, Mungu wa wote wenye mwili, kama mtu akitenda dhambi, ni lazima uwe na hasira na watu wote?” ");
INSERT INTO swhulb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Sema na watu wote, uwaaambie, 'Tokeni kwenye hema ya Kora, Dathani, na Abiramu.'” ");
INSERT INTO swhulb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Kisha Musa akaamuka akaenda kwa Dathani na Kwa Abiramu; viongozi wa Israeli wakamfuata. ");
INSERT INTO swhulb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Akaongea na watu wote akasema, “Sasa jitengeni na hema ya hawa watu waovu na msiguse kitu chochote kilicho chao, vinginevyo mtaangamizwa na dhambi zao.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kwa hiyo watu wote toka pande zote za hema ya Kora, Dathani na Abiramu wakaondoka. Dathani na Abiramu wakatoka nje wakasimama kwenye lango la hema zao, wakiwa na wake wao, wana, na watoto wao. ");
INSERT INTO swhulb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kisha Musa akasema, “Kwa hili sasa mtatambua kuwa BWANA amenituma kufanya kazi hizi zote, kwa kuwa sijazifanya kwa uwezo wangu. ");
INSERT INTO swhulb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kama hawa watu watakufa kifo cha kawaida ambacho humpata kila mmoja, basi BWANA hakunituma. ");
INSERT INTO swhulb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Lakini kama BWANA aumbaye malango ya ardhi ambayo huwameza kama mdomo mkubwa, pamoja na familia zao, na kama wataingia ndani ya shimo wakiwa hai, ndipo mtakapojua kuwa wamemdharau BWANA,” ");
INSERT INTO swhulb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mara ghafla Musa alipomaliza kusema maneno haya, aridhi ya pale walipokuwa ikafunguka. ");
INSERT INTO swhulb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Dunia ikafungua makanwa yake na kuwameza, familia zao na watu wote wa Kora, pamoja na mali zao zote. ");
INSERT INTO swhulb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wao na kila mmoja kwenye familia zao wakaingia ndani shimoni wakiwa hai. Dunia ikwafunika, na kwa njia hii wakapotea kutoka miongoni mwa ile jamii. ");
INSERT INTO swhulb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nao Israeli yote waliokuwa karibu nao wakakimbia kwa sababu ya vilio vyao. Walisema kwa mshangao, “Nchi isije kutumeza na sisi!” ");
INSERT INTO swhulb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kisha moto ukashuka toka kwa BWANA na kuwaangamiza wale wanaume 250 waliokuwa wametoa ubani. ");
INSERT INTO swhulb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Tena BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mwambie Eliazari mwana wa Haruni yule kuhani achukue vile vyetezo kutoka ule moto, kwa kuwa vile vyetezo vimetengwa ka ajili yangu. Na aumwage ule moto mbali. ");
INSERT INTO swhulb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Vitwae vile vyetezo vya wale waliopoteza maisha yao kwa sababu ya dhambi zao. Na vifanyike kuwa mbao za kufuliwa ili viwe vifuniko vya madhabahu. Kwa kuwa wale watu walivitoa kwangu, kwa hiyo ni vitakatifu. Vitakuwa ishara ya uwepo wangu kwa wana wa Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Naye Eleazari yule kuhani akavichukue vile vyetezo vya shaba ambavyo vilikuwa vimetumiwa na wale watu walioungua, na vikafuliwa kuwa vifuniko vya madhbahu, ");
INSERT INTO swhulb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ili kuwa ukumbusho kwa wana wa Israeli, ili kwamba asije akatokea mtu toka nje ya uzao wa Haruni akaja kutoa ubani kwa BWANA, ili wasije kuwa kama Kora na kundi lake— kama vile BWANA alivyoamuru kupitia kinywa cha Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Lakini siku iliyofuata asubuhi watu wa Israeli wakamlalamikia Musa na Haruni. Nao walisema, “Umeua watu wa BWANA.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Kisha ikatokea, wakati watu walipokuwa wamekusanyika kinyume na Musa na Haruni, wakatazama kuielekea hema ya kukutania, na tazama lile wingu lilikuwa likiifunika. Utukufu wa BWANA ukaonekana, ");
INSERT INTO swhulb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa na Haruni wakaja mbele ya hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Kisha BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Toka kati ya watu hawa ili niwaangamize haraka.” Musa na Haruni wakalala chini kifudifudi. ");
INSERT INTO swhulb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa akamwambia Haruni, uchukue chetezo, na utie ndani moto kutoka madhabahuni, tia na uvumba ndani yake, upeleke haraka kwa watu, na ukafanye upatanisho kwao, kwa sababu hasira hii inatoka kwa BWANA. Tauni imeanza.” ");
INSERT INTO swhulb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Kwa hiyo Haruni akafanya kama alivyoelekezwa na Musa. Akakimbia kati ya watu. na Tauni ilikuwa imeanza kuenea kati ya watu, kwa hiyo akaweka ndani yake uvumba na akafanya upatanisho wa watu. ");
INSERT INTO swhulb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Haruni akasimama kati kati ya zile maiti na watu hai; na kwa njia hii ile tauni ikazuiwa. ");
INSERT INTO swhulb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Idadi ya wale waliokuwa wamekufa kwa tauni walikuwa14, 000, nje na wale waliokufa kutokana na swala la Kora. ");
INSERT INTO swhulb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Haruni akarudi kwa Musa kwenye lango la hema ya kukutania, na ile tauni ikakoma. ");
INSERT INTO swhulb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Waambie wana wa Israeli wakuletee fimbo za kutembelea moja kwa kila jamaa, fimbo kumi na mbili. Uandika jina la kila mmoja kwenye hizo fimbo. ");
INSERT INTO swhulb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Utaandika jina la Haruni kwenye jina la Lawi. Kutakuwa na fimbo moja kwa kila kiongozi kutoka kwenye kabila la mababu zake. ");
INSERT INTO swhulb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Utaziweka hizo fimbo kwenye hema ya kukutania mbele ya amri za agano, ambapo Mimi hukutana na wewe. Itakuwa hivi, ");
INSERT INTO swhulb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","fimbo ya mtu yule ninayemchagua itachipua. Nitazuia watu wa Israeli walalamikao, ambao wanaongea kinyume na wewe.” ");
INSERT INTO swhulb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kwa hiyo Musa akawaambia wana wa Israeli. Viongozi wote wa kabila wakampatia fimbo, fimbo moja kutoka kwa kila kiongozi, aliyechaguliwa kutoka kwenye kila kabila ya babu zao, jumla yake fimbo kumi na mbili. Fimbo ya Haruni ilikuwa miongoni mwa fimbo hizo. ");
INSERT INTO swhulb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ndipo Musa alipoziweka zile fimbo mbele ya BWANA katika hema ya amri ya agano. ");
INSERT INTO swhulb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Siku iliyofuata Musa aliingia kwenye hema ya amri ya agano, na tazama, fimbo ya Haruni kwa ajili ya Kabila la Lawi ilikuwa imetoa machipukizi. Machipukizi yalikuwa hadi kuchanua maua na kuzaa malozi mabivu! ");
INSERT INTO swhulb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa akazitoa fimbo zote kutoka kwa BWANA kwa watu wote wa Israeli, na kila mtu akachukua fimbo yake. ");
INSERT INTO swhulb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","BWANA akamwambua Musa, “Iweke fimbo ya Haruni mbele ya amri za agano. Iweke iwe ishara ya hatia mbele ya watu waliopinga ili ukomeshe malalamiko dhidi yangu, vinginevyo watakufa.” ");
INSERT INTO swhulb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa akafanya kama BWANA alivyoagiza. ");
INSERT INTO swhulb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Wana wa Israeli wakanena na Musa wakisema, “tutakufa hapa! Wote tutaangamia! ");
INSERT INTO swhulb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kila mmoja anayekuja hapa, anayekaribia masikani ya BWANA, atakufa. Je, ni lazima wote tuangamie?” ");
INSERT INTO swhulb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","BWANA akamwambia Haruni, “Wewe, wana wako, na uzao wa baba yako watawajibika kwa dhambi zote zilizotendwa mahali patakatifu. Lakini wewe na wana wako pekee mtawajibika kwa uovu uliofanywa na yeyote mahali patakatifu. ");
INSERT INTO swhulb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Na ndugu zako nao wa kabila ya Lawi, kabila la ukoo wako, utawaleta pamoja na wewe ili kwamba waweze kuungana na wewe ili wakusaidie wakati wewe na wanao mnapokuwa mnatumikia mbele ya hema ya amri ya agano. ");
INSERT INTO swhulb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Watakutumikia wewe na hema yote. Hata hivyo, wasisogee karibu na chochote ndani ya mahali patakatifu au kitu chochote kilichounganishwa na madhabahu, vinginevyo wewe na wao mtakufa. ");
INSERT INTO swhulb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Wataungana na wewe na kuitunza hema ya kukutania, kwa kazi zote zinazohusiana na hema. Mtu mgeni asikusogelee. ");
INSERT INTO swhulb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Wewe utaajibika kwa ajili ya mahali patakatifu na kwa ajili ya madhabahu ili kwamba hasira yangu isiwajilie watu wa Israeli tena. ");
INSERT INTO swhulb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Tazama, Mmi mwenyewe nimewachagua ndugu zako wa kabila ya Walawi kutoka mioingoni mwa uzao wa Israeli. Wao ni zawadi kwako. walitolewa kwangu ili waifanye kazi inayohusiana na hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lakini ni wewe pekee yako na wanao ndio mnaoruhusiwa kufanya kazi ya ukuhani kuhusiana na kila kitu kilichounganishwa na madhabahu na kitu chochote ndani ya lile pazia. Wewe mwenyewe lazima ukamilishe majukumu hayo. Mimi ninakupa ukuhani kama zawadi. Mgeni yeyote anayekaribia atauawa.” ");
INSERT INTO swhulb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Kisha BWANA akamwambia Haruni, “Tazama, Nimekupa majukumu ya kusimamia sadaka za kuinuliwa kwangu, na sadaka zengine takatifu ambazo wana wa Israeli wanatoa kwangu. Nimekupa sadaka hizi wewe na wana wako kuwa haki yako milele. ");
INSERT INTO swhulb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Hivi ni vitu vitakatifu sana, amabavyo visiteketezwe kwa moto: kutoka kwenye sadaka zao-kila sadaka ya unga, kila sadaka ya dhambi, na kila sadaka ya hatia- ni vitu vitakatifu sana kwa ajili yako na wana wako. ");
INSERT INTO swhulb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Sadaka hizi ni takatifu sana; kila mume lazima aile, kwa kuwa ni vitakatifu kwako. ");
INSERT INTO swhulb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Hizi ni sadaka ambazo zitakuwa zako: Sadaka zao, sadaka zote za kuinuliwa za wana wa Israeli. Nimekupa wewe, wana wako na binti zako kuwa gawio lako la milele. Kila mmoja ambaye ni msafi katika familia yako anaweza kula sadaka zozote katika hizi. ");
INSERT INTO swhulb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Mafuta yote mazuri, ile divai nzuri yote mpya na unga, malimbuko ambyo watu hutoa kwangu- vitu hivi vyote nimekupa wewe. ");
INSERT INTO swhulb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mavuno ya kwanza yaliyoiva yaliyo katika ardhi yao ambayo wanaleta kwangu, yatakuwa yako. Kila mtu aliye msafi kwenye famila yako anaweza kula vitu hivi. ");
INSERT INTO swhulb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Kila kitu kilichotolewa wakfu katika Israeli kitakuwa chako. ");
INSERT INTO swhulb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Kila kitu kinachofungua tumbo, kila limbuko ambalo watu hutoa kwa BWANA, vyote vya watu na wanyama, vitakuwa vyako. Hata hivyo, watu lazima wawakomboe wazaliwa wa kwanza wa kiume, na watawakomboa wazaliwa wa kwanza wa wanyama wasio safi. ");
INSERT INTO swhulb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Wale ambao wanahitaji kukombolewa na watu watakombolewa wakiwa na umri wa mwezi mmoja. Ndipo watu watawakomboa kwa bei ya shekeli tano, kwa kiwango cha shekeli za mahali patakatifu, ambacho ni sawa na gera ishirini. ");
INSERT INTO swhulb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Lakini mzaliwa wa kwanza wa ng'ombe, au mzaliwa wa kwana wa kondoo, au mzaliwa wa kwanza wa mbuzi-msiwakomboe hawa wanyama, wametengwa kwa ajili yangu. Utanyunyizia damu yake madhabahuni na kuteketeza mafuta yao kama sadaka ya moto, ambayo ni harufu nzuri ya kumpendeza BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama yao itakuwa yako. Kama kidali cha kuinuliwa na paja la kulia, nyama yao itakuwa yako. ");
INSERT INTO swhulb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sadaka yote takatifu ambayo watu wa Israeli wanaitoa kwa BWANA, nimekupa wewe, na wana wako na binti zako walio pamoja nawe. Kama gawio la kudumu. Hili ni agano la milele la chumvi, agano linalofunga milele, mbele za BWANA kwako wewe na uzao wako walio pamoja na wewe.” ");
INSERT INTO swhulb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","BWANA akasema na Haruni. “hautakuwa na urithi katika ardhi ya watu, wala hautakuwa na gawio miongoni mwa watu. Mimi ndimi gawiio lenu na urithi wenu miongoni mwa watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Tazama, Nimewapatia uzao wa Lawi, zaka zote za Israeli kuwa urithi wao kwa sababu ya huduma wanayotoa katika hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kuanzi a sasa, watu wa Israeli wasisogee karibu na hema ya kukutania, vinginevyo wataajibika kwa dhambi hii na kufa. ");
INSERT INTO swhulb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Walawi wafanya kazi inayohusiana na hema ya kukutania. Wataajibika kwa dhambi inyohusiana na hema. Hii itakuwa sheri ya kudumu kwa watu wote wa uzao wako. Na miongoni mwa watu wa Israeli hawa hawatakuwa na urithi. ");
INSERT INTO swhulb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kwa kuwa zaka za wana wa Israeli, wanazotoa kama mchango kwangu -ndivyo hivyo ambavyo nimewapa Walawi kuwa urithi wao. Hiyo ndiyo sababu ya kuwaambia, Kuwa hawatakuwa na urithi kati ya watu wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Inakupasa ukaseme na Walawi uwaambie, 'Mnapopokea zaka toka kwa watu ambayo BWANA amewapa kutoka kwao kuwa urithi, ndipo na nyie mtakapotoa sehemu ya kumi ya zaka hizo. ");
INSERT INTO swhulb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Zaka yenu itahesabika kama moja ya mapato ya sakafu ya kupuria nafaka ya mazao yenu au mazao ya vinu vya kukamulia zabibu. ");
INSERT INTO swhulb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Kwa hiyo na ninyi lazima mtoe mchango wenu kwa BWANA kutokana na zaka mnazopata kutoka kwa watu wa Israeli. Kutokana na hizo mtatoa matoleo yenu kwa Haruni yule kuhani. ");
INSERT INTO swhulb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kwa kila sadaka mnayopata, mtatoa matoleo yenu kwa BWANA. Mtafanya hivi kutokana na vitu vizuri na vitakatifu sana ambavyo mmepewa. ");
INSERT INTO swhulb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Kwa hiyo utawaambia, 'Mnapotoa hayo matoleo mazuri, ndipo itahesabika kwa Walawi kuwa ni mazao yao kutoka kwenye sakafu za kupuria na vinu vyao vya kukamulia. ");
INSERT INTO swhulb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ndipo matakapokula nafaka zote zinazobaki mahali popote, ninyi na famailia zenu kwa sababu ndiyo malipo yenu ya kazi y a kwenye hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Hamtakuwa na hatia yeyote kwa kuvila na kuvinywa, kama mtatoa kwa BWANA matoleo yenu mazuri mliyopokea. Lakini msizinajisi sadaka takatifu za wana wa Israeli, vinginevyo mtakufa.,” ");
INSERT INTO swhulb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","BWANA akanena na Musa na Haruni, Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Hii ni amri, ni sheria ninayokuamuru: Waambie wana waIsraeli wakuletee ng'ombe mke mwekundu asiyekuwa na kipaku wala waa, ambaye hajawahi kubeba nira. ");
INSERT INTO swhulb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mpatie Eliazari kuhani huyo ng'ombe jike. Naye atamtoa nje ya kambi, na mtu mmoja amchinje mbele yake. ");
INSERT INTO swhulb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kisha Eliazari kuhani atachukua sehemu ya damu yake kwa kidole chake na kuinyunyiza mara saba akielekea sehemu ya mbele ya ile hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Na kuhani mwingine atamchoma huyo ng'ombe mbele ya macho yake. Ataichoma ngozi yake, nyama yake, na damu yake pamoja na mavi yake, ");
INSERT INTO swhulb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Yule kuhani atachukua mti wa mwerezi, na hisopo na sufu na kivitupa katikati ya huyo ng'ombe anayechomwa. ");
INSERT INTO swhulb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kisha atazifua nguo zake na kuoga kwenye maji. Ndipo atakuja kambini, ambapo atabaki najisi mpaka jioni ya siku hiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Yule aliyemchoma huyo ng'ombe mke atafua nguo zake kwa maji na kuoga majini. Naye atabaki najisi mpaka jioni ya siku ile. ");
INSERT INTO swhulb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Baadaye mtu aliyesafi atayakusanya hayo majivu ya ng'ombe huyo na kuyaweka nje ya kambi kwenye eneo safi. Majivu haya yatatunzwa kwa ajili ya jamii ya watu wa Israeli. Watayachanganya majivu na maji kwa ajili ya utakaso wa dhambi, kwa kuwa majivu yalitokana na sadaka ya dhambi. ");
INSERT INTO swhulb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Yule aliyeyakusanya majivu ya ng'ombe huyo lazima afue mavazi yake. Atabaki najisi mpaka jioni ya siku ile. Hii itakuwa sheria ya kudumu kwa watu wa Israeli na kwa wageni wanaoishi nao. ");
INSERT INTO swhulb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Yeyote atakayegusa maiti ya mtu atakuwa najisi kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mtu wa jinsi hiyo atajitakasa mwenyewe siku ya tatu na siku ya saba. Ndipo atakapokuwa safi. Lakini kama hatajitakasa mwenyewe katika siku ya tatu, basi hatakuwa safi siku ya saba. ");
INSERT INTO swhulb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Yeyote atakayegusa mtu aliyekufa, maiti ya mtu aliyekufa na hajajitakasa - mtu huyu anainajisi masikani ya BWANA. Mtu huyo ataondolewa kuwa miongoni mwa Waisraeli kwa sababu maji ya farakano hayakunyunyiziwa kwake. Atabaki najisi; na unajisi wake utabaki kwake. ");
INSERT INTO swhulb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Hii ndiyo sheri ya mtu anayefia hemani. Kila mtu aingiaye hemani na kila mtu ambaye tayari yumo hemani atakuwa najisi kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kila chombo ambacho hakina kifuniko kinanajisika. ");
INSERT INTO swhulb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Vivyo hivyo, kwa mtu aliye nje ya hema ambaye atamgusa mtu aliyeuawa kwa upanga, au mzoga wowote, au mfupa wa mtu, au kaburi—mtu huyo atakuwa najisi kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Fanyeni hivi kwa mtu najisi: twaeni majivu ya sadaka ya dhaambi ya kuteketezwa na myacahanganye kwenye chombo chenye maji ya mto. ");
INSERT INTO swhulb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ndipo mtu aliye safi atachukua hisopo, na kutia katika hayo maji, na kunyunyizia juu ya hema, na katika vyombo vyote vilivyo hemani, na kwa watu waliokuwepo, na kwa yule aliyegusa ule mfupa, mtu aliyeuawa, maiti, au kaburi. ");
INSERT INTO swhulb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Katika siku ya tatu na siku ya saba, yule mtu aliye msafi atamnyunyizia yule mtu asiyekuwa safi. Katika siku ya saba mtu najisi atajitakasa mwenyewe. Atazifua nguo zake na kuoga kwenye maji. Jioni yake atakuwa safi. ");
INSERT INTO swhulb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Lakini yule atakayebaki najisi, anayekataa kujitakasa mwenyewe — huyo mtu ataondolewa kutoka kwenye jamii, kwa sababu amepanajisi patakatifu pa BWANA. Hajanyunyiziwa maji ya utakaso; atabaki najisi. ");
INSERT INTO swhulb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hii itakuwa sheria ya kudumu kuhusiana na hali ya hivi. Yule mtu anayenyunyizia maji ya farakano atafua mavazi yake. Yule atakayeyagusa maji ya farakano atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Chochote kile ambacho kitaguswa na mtu najisi kitakuwa najisi. na mtu atakayekigusa naye atakuwa najisi mpaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Kwa hiyo wana wa Israeli, na jamii yote ya watu, wakaenda katika jangwa la Sini katika mwezi wa kwanza; wakaa Kadeshi. Hapo ndipo Miriamu alipofia na kuzikwa. ");
INSERT INTO swhulb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Huko hapakuwa na maji kwa ajili ya watu, kwa hiyo wakakusanyika kinyume na Musa na Haruni huko. ");
INSERT INTO swhulb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Watu wakamlalamikia Musa. Wakasema, “Ilikuwa ni bora kama tungelikufa wakati Waisraeli wenzetu walipokufa mbele za BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Kwa nini umewaleta watu wa BWANA kufia katika jangwa hili, sisi na wanyama wetu? ");
INSERT INTO swhulb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kwa nini ulitutoa Misri na kutuleta katika eneo hili baya? Hapa hakuna nafaka, wala mitini, wala mizabibu, wala makomamanga. Na hakuna maji ya kunywa.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Basi Musa na Haruni wakatoweka mbele ya mkutano huo. Wakaenda kwenye hema ya kukutania wakalala kifudifudi. Ndipo pale utukufu wa Busara wa BWANA ukaonekana kwao. ");
INSERT INTO swhulb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Chukua fimbo yako na uwakusanye watu, wewe na Haruni ndugu yako. Uumbie huu mwamba mbele ya macho yao, na uumuru utoe maji. Nawe utawapa maji kutoka kwenye huu mwamba, nawe utawapa maji ya kunywa hao watu na wanyama wao.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa akachukua hiyo fimbo mbele ya BWANA, kama vile BWANA alivyokuwa amemwamuru kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Kisha Musa na Haruni wakawakusanya watu pamoja mbele ya ule mwamba. Ndipo Musa akawaambia, “Sasa sikilizeni, enyi wapinzani. Lazima tuwape maji kutoka kwenye huu mwamba?” ");
INSERT INTO swhulb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ndipo Musa akanyosha mkono wake na kuupiga ule mwamba mara mbili kwa fimbo yake, na maji mengi yakatoka. Wale watu wakanywa pamoja na wanyama wao. ");
INSERT INTO swhulb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kisha BWANA akamwambia Musa na Haruni, “Kwa kuwa hamkuniheshimu mimi na kuniamini mbele ya watu wa Israeli, hamtawaingiza hawa watu katika nchi niliyowaahidi. ");
INSERT INTO swhulb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mahali hapa paliitwa maji ya Meriba kwa sababu wana wa Israeli walitofautiana na BWANA pale, na akajionyesha kwao kuwa mtakatifu. ");
INSERT INTO swhulb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa akatuma wajumbe kutoka Kadeshi kwa mfalme wa Edom: Ndugu yako Israeli anasema hivi: “Wewe unajua magumu yote ambayo yametupata. ");
INSERT INTO swhulb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Na unajua kuwa babu zetu walienda Misri na waliishi Misri kwa muda mrefu. Wamisri walitutendea vibaya pamoja na babu zetu. ");
INSERT INTO swhulb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Tulipomlilia BWANA, akatusikia na kututumia malaika ambaye alitutoa toka Misri. Tazama, sasa tuko Kadeshi, mji unaopakana na nchi yako. ");
INSERT INTO swhulb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tunakuomba uturuhusu kupita katika nchi yako. Hatutapita mashambani wala kwenye mashamba ya mizabibu, wala hatutakunywa maji ya visima vyako. Tutapita kwenye njia kuu ya mfalme. Hatutageuka upande wa kulia wala upande wa kushoto mpaka tutakapopita mpaka wako.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lakini mfalme wa Edomu akamjibu, “Msipite hapa. Kama mtafanya hivyo, Nitakuja na upanga kukuvamia.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ndipo wana wa Israeli wakamwambia,”tutapitia njia kuu. Kama sisi au wanyama wetu watakunywa maji yako, basi tutalipa. Tunaomba uturuhusu tupite tukitembea kwa miguu yetu, bila kufanya jambo lolote lile.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Lakini mfalme wa Edomu akajibu, “Usipite hapa.” Kwa hiyo nfalme wa Edomu akawa kinyume cha Israeli kwa mkono wenye nguvu pamoja na jeshi kubwa sana. ");
INSERT INTO swhulb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mfame wa Edomu akawazuia wana wa Israeli kupita kwenye mipaka yake. Kwa sababu ya hili, Israeli akageuka kuiacha nchi ya Edomu. ");
INSERT INTO swhulb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kwa hiyo watu wakasafiri kutoka Kadeshi. Wana wa Israeli, watu wote, wakafika Mlima Hori. ");
INSERT INTO swhulb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","BWANA akanena na Musa na Haruni hapo kwenye Mlima Hori, kwenye mpaka wa Edomu. Akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Sasa ni wakati wa Haruni kukusanyika na watu wake, hataingia katika nchi ile niliyowaahidi wana wa Israeli. Hii ni kwa sababu ninyi wawili hamkuitii sauti yangu pale kwenye maji ya Meriba. ");
INSERT INTO swhulb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Mchukue Haruni na Eliazari mwanaye, na uwalete juu ya Mlima Hori. ");
INSERT INTO swhulb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Umvulishi HarunI yale mavazi ya kikuhani na umvalishe Eliazari mwanaye. Haruni atakufa na kulazwa pamoja na watu wake.” ");
INSERT INTO swhulb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa akafanya kama BWANA alivyomwamuru. Wakaenda juu y a Mlima Hori na watu wote wakiona. ");
INSERT INTO swhulb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa akamvulisha Haruni yale mavazi ya kikuhani na kumvalisha Mwanaye Eliazari. Haruni akafa pale juu ya Mlima Hori. Kisha Musa na Eliazari wakashuka. ");
INSERT INTO swhulb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Watu walipoona kuwa Haruni amekufa, taifa lote wakamlilia Haruni kwa siku arobaini. ");
INSERT INTO swhulb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Aradi mfalme wa Wakanaani, aliyekuwa akiishi Negebu, aliposikia kuwa Israeli alikuwa akisafiri kwa kupitia barabara kuelekea Atharimu, akapigana dhidi ya Israeli na kujitwalia baadhi ya mateka. ");
INSERT INTO swhulb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israeli akaapa mbele ya BWANA akasema, “Kama utatupa ushindi dhidi ya hawa watu, ndipo tutakapoingamiza kabisa miji yao,” ");
INSERT INTO swhulb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","BWANA akaisikia sautiya Israeli na kuwapa ushindi dhidi ya Wakanaani. Wakawaangamiza kabisa pamoja na miji yao. Mahali pale paliitwa Horima. ");
INSERT INTO swhulb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Wakasafiri kutoka Mlima Hori kwa barabara kuelekea bahari ya shamu wakiizunguka nchi ya Edomu. Watu walikufa moyo kwa njia hiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Watu wakamnung'unikia Mungu na Musa: “Kwa nini umetutoa Misiri ili tufa katika jangwa hili? Hapa hakuna mikate, wala maji, na chakula hiki dhaifu kimetukinai.” ");
INSERT INTO swhulb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Basi Mungu akatuma nyoka wa sumu kati yao. Wale nyoka wakawauma wale watu; watu wengi walikufa. ");
INSERT INTO swhulb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Watu wakaenda kwa Musa wakamwambia, “Tumetenda dhambi kwa sababu tumemnung'unikia Mungu na wewe. Mwombe Mungu atuondolee hawa nyoka.” Kwa hiyo Musa akawaombea watu. ");
INSERT INTO swhulb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","BWANA akamwambia Musa, “Tengeneza nyoka na umweke kwenye nguzo. Na itakuwa kila anayeumwa, akimwangalia huyo nyoka atapona,” ");
INSERT INTO swhulb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kwa hiyo Musa akatengeneza nyoka wa shaba naye akamweka juu ya nguzo. Na kila mtu alipoumwa na nyoka na kumwangalia huyo nyoka alipona. ");
INSERT INTO swhulb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Kisha watu wa Israeli wakasafiri na kisha kuweka kambi Obothi. ");
INSERT INTO swhulb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kisha wakasafiri kutoka pale na kuweka kambi Iye Abarimu katika jangwa linalokabili Moabu kuelekea upande wa mashariki. ");
INSERT INTO swhulb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kutoka pale wakasafiri na kuweka kambi katika bonde la Zeredi. ");
INSERT INTO swhulb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kutoka pale walisafiri na kuweka kambi kwenye upande mwingine wa mto Amoni, ambao ukubwa wake unaanzia kwenye mpaka wa Waamori. Mto wa Amoni ndio unaootengeneza mpaka wa Moabu, kati ya Moabu na Waamori. ");
INSERT INTO swhulb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ndiyo maana imeandikwa katika gombo la Kitabu cha BWANA, “Wahebu katika Sufa, na bonde la Amoni, ");
INSERT INTO swhulb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","mtelemko wa bonde linaloelekea katika mji wa Ari na kuelekea kwenye mpaka wa Moabu,” ");
INSERT INTO swhulb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kutoka pale wakasafiri mpaka Beeri, hapo ndipo palipo na kisima ambacho Bwana alimwambia Musa, “Wakusanye watu kwa ajili yangu ili uwape maji,” ");
INSERT INTO swhulb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ndipo Israeli waipoimba wimbo huu: “enyi visima, yajazeni maji. Imbeni juu ya kisima hiki. ");
INSERT INTO swhulb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kisima ambacho viongozi wetu walichimba, kisima ambacho wenye hekima walichimba kwa fimbo ya kifalme na kwa fimbo ya kutembelea.” Kisha kutoka jangwani walitembea mpaka Matanaha. ");
INSERT INTO swhulb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Kutoka Matanaha walisafiri mpaka Nathalieli, na kutoka Nathalieli mpaka Bamothi, ");
INSERT INTO swhulb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kutoka Bamothi hadi kwenye bonde la Moabu. Hapo ndipo kilele cha Mlima Piska kinapoonekana jangwani. ");
INSERT INTO swhulb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Kisha Israeli akatuma wajumbe kwa Sihoni mfalme wa Waamori akisema, ");
INSERT INTO swhulb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Tunaomba tupite katika nchi yako. hatutapita katika shamba au kwenye shamba la mizabibu. Hatutakunywa maji ya visima vyako. Tutapita katika njia kuu ya mfalme mpaka tutakapopita mpaka wako.” ");
INSERT INTO swhulb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Lakini mfalme Sihoni hakumruhusu Israeli kupita kwenye mpaka wao. Badala yake, Sihoni akakusanya jeshi lake lote na kumvamia Isreli huko jangwani. Akaja kwa Jahazi, ambapo alipigana dhidi ya Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israeli akalivamia jeshi la Sihoni na nchi ya upanga na kuchukua nchi yao kutoka Amon mpaka mto Jabboki, hadi kufikia nchi ya watu wa Amoni. Sasa mpaka wa watu wa Amoni ulikuwa umefungwa. ");
INSERT INTO swhulb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israeli akachukua miji yote ya Waamori na akaishi ndani yake, pamoja na Heshiboni na vijiji vyake wote. ");
INSERT INTO swhulb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboni ulikuwa mji wa Sihoni mfalme wa Waamori, ambaye hapo awali alipigana dhidi ya mfalme wa kwanza wa Moabu. Sihoni alikuwa ameteka ardhi yake yote toka mipaka yake mpaka mto wa Amoni. ");
INSERT INTO swhulb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hiyo ndiyo sababu wala ambao huongea kwa Mitahali husema, “Njoni Heshboni. Mji wa Sihoni ujengwe na kuimarishwa tena. ");
INSERT INTO swhulb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Moto uliwaka toka Heshiboni, moto kutoka mji wa Sihoni ambao uliiteketeza Ari ya Moabu, na wenyeji wa miji ya juu ya Amoni. ");
INSERT INTO swhulb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ole wako, Moabu! umepotea, enyi watu wa Chemoshi. Amewafanya watu wake kuwa wakimbizi na binti zake kuwa wafungwa wa Sihoni mfalme wa Waamori. ");
INSERT INTO swhulb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Lakini tumempiga Sihoni. Tumeiangsmiza Heshibon mpaka Diboni. Tumewaharibu wote mpaka Nofa, ambayo inafika mpaka Madeba.” ");
INSERT INTO swhulb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Kwa hiyo Israeli akaanza kuishi katika nchi ya Waamori, ");
INSERT INTO swhulb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Kisha Musa akatuma watu kwenda kuingalia Yaziri. Waliviteka vijiji vyake na kuwafukuza Waamori waliokuwa wakiishi humo. ");
INSERT INTO swhulb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kisha wakageuka na kuelekea njia inayoelekea Bashani. Ogu mfalme wa Bashani akatofautiana nao, yeye na Jeshi lake lote, ili apigane nao kule Ederei. ");
INSERT INTO swhulb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kisha BWANA akasema na Musa, “Msimwogope, kwa sababu nimewapeni ushindi dhidi yake, Jeshi lake lote na nchi yake. Mfanyeni kama mlivyomfanya Sihoni mfalme wa Waamori, aliyekuwa akiishi Heshiboni.” ");
INSERT INTO swhulb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Kwa hiyo wakamuua, na wanawe, na jeshi lake lote, mpaka wote wakaishi na hakubaki hata mmoja aliyebaki hai. Kisha wakaichukua nchi yake. ");
INSERT INTO swhulb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Watu wa Israeli wakasafiri mpaka wakaweka kambi kwenye uwanda wa Moabu karibu na Yeriko, kwenye upande mwingine wa mto Yorodani kutoka mji ule. ");
INSERT INTO swhulb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaki mwana wa Zippori aliona yote ambayo Israeli aliwafanyia Waamori. Moabu aliogopa sana hao watu kwa sababu walikuwa wengi sana, ");
INSERT INTO swhulb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","na Moabu alIwahofia wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mfalme wa Moabu akawaambia wazee wa Midiani, “Huu umati utakula kila kitu tulicho nacho na maksai hula nyasi za kondeni.” Sasa Balaki mwana wa Zippori alikuwa mfalme wa Moabu. ");
INSERT INTO swhulb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Akatuma wajumbe kwenda kwa Balamu mwana wa Beori, kule Petho ambayo iko karibu na mto Frati, katika nchi ya taifa lake na watu wake. Akamwita na kumwambia, “Tazama, Kuna taifa ambalo wamekuja hapa tokea Misiri. Wanafunika uso wa dunia na sasa wananifuatia mimi. ");
INSERT INTO swhulb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Tafadhali naomba uje unilaanie hili taifa, kwa sababu wana nguvu kuliko mimi. Labda nitaweza kuwavamia na kuwafukuza watoke katika nchi yangu. Najua kuwa yeyote unayembariki hubarikiwa na yeyote unayemlaani atalaaniwa.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Kwa hiyo wazee wa Moabu na wale wa Midiani wakaondoka, pamoja nao wakachukua malipo ya uganga. Wakafika kwa Balaamu wakamwambia maneno ya Balaki. ");
INSERT INTO swhulb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu akawaambia, “Bakini hapa usiku wa leo. Kesho nitawaletea atakachoniambia BWANA.” Kwa hiyo wale viongozi wa Moabu wakabaki na Balaamu kwa usiku huo. ");
INSERT INTO swhulb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mungu akaja kwa Balaamu na kumwambia, “Ni akina nani hawa waliokuja kwako?” ");
INSERT INTO swhulb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu akamjibu Mungu, “Balaki mwana wa Zippori, Mfalme wa Moabu amewatuma kwangu. Alisema, ");
INSERT INTO swhulb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","'Tazama hawa watu waliotoka Misri wanafunika uso wa nchi yangu. Sasa naomba uje unilaanie hawa watu. Labada nitaweza kuwa kuwashinda na kuwafukuza.'” ");
INSERT INTO swhulb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mungu akamjiu Balaam, “Usiambatane na hao wanaume. Na usiwalaani hawa wana wa Israeli kwa sababu wamebarikiwa.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaamu akaamka asubuhi na kuwaambia wale viongozi wa Balaki,. “Rudini nchini kwenu kwa sababu BWANA amenikataza kuambatana nanyi.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kwa hiyo wale viongozi wa Moabu wakaondoka na kurudi kwa Balaki. Wakamwambia, “Balaamu amekataa kuambatana nasi.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki akatuma viongozi wengine waliokuwa wanaheshimiwa zaidi kuliko kundi lile la awali. ");
INSERT INTO swhulb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wakaja kwa Balaamu na kumwambia, “Balaki mwana wa Zippori anasema hivi, 'Tafadhali hebu kitu chochote kisikuzuie kuja kwangu, ");
INSERT INTO swhulb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","kwa sababu nitakulipa malipo mazuri sana na kukupa heshima kubwa, nami nitakufanyia chochote utakachoniambia. Tafadhali sana uje unilaanie hawa watu.'” ");
INSERT INTO swhulb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaamu akawajibu watu wa Balaki akawaambia, “Hata kama Balaki atanipa ikulu yake ikiwa imejaa fedha na dhahabu, sitaweza kufanya dhidi ya maneno ya BWANA, Mungu wangu na kufanya pungufu au zaidi ya kile anachoniambia. ");
INSERT INTO swhulb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Sasa basi, tafadhali subirini hapa usiku wa leo pia, ili kwamba nipate kujifunza kitu zaidi ambacho BWANA ananiambia.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","BWANA akaja kwa Balaamu usiku ule na kumwambia, “kwa kuwa hawa watu wamekuja kukuita, inuka uende nao. Lakini utafanya tu kile nitakachokuambia kufanya.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu akainuka asubuhi, akatandika punda wake, akaenda pamoja na viongozi wa Moabu. ");
INSERT INTO swhulb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Lakini kwa sababu alienda, hasira za Mungu zikawaka. Malaika wa BWANA akasimama barabarani kama adui wa Balaamu, aliyekuwa akimpanda yule punda. Watumishi wawili wa Balaamu walikuwa pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Yule punda alimwona yule malaika wa BWANA akiwa amesimama barabarani akiwa na upanga mkononi mwake. Yule punda akageuka na kwenda shambani. Balaamu akampiga yule punda ili arudi barabarani. ");
INSERT INTO swhulb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Sasa malaika wa BWANA akasimama kwenye njia nyembamba katikati ya mashamba ya mizabibu, na kushoto kwake kulikuwa na ukuta. ");
INSERT INTO swhulb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Yule punda akamwona yule malaika wa BWANA tena. Akasogea zaidi ukutani na kuubana mguu wa Balaamu ukutani. Balaamu akampiga tena yule punda. ");
INSERT INTO swhulb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Yule malaika wa BWANA akasogea mbele zaidi kwenye eneo jingine jembamba zaidi ambalo haikuwezekana kugeuka upande mwingine. ");
INSERT INTO swhulb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Yule Punda akamwona tena yule malaika wa BWANA, akalala chini ya Balaamu. Hasira za Balaamu zikawaka, akampiga yule punda kwa fimbo yake. ");
INSERT INTO swhulb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Kisha BWANA akafungua kinywa cha punda na akaongea. Akamwambia Balaamu, “Nimekukosea nini kiasi kwamba umenipiga mara tatu?” ");
INSERT INTO swhulb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu akamjibu yule punda, “Ni kwa sababu umenitendea kwa ujinga. Natamani kama ningekuwa na upanga mkononi mwangu, kama ningekuwa nao, sasa hivi ningekuwa nimekuua.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Yule punda akamwambia Balaamu, “Je, mimi si punda wako ambaye umenipanda maishani mwako mwote mpaka hivi sasa? Je, nimewahi kuwa na tabia ya kukufanyia hivi hapo awali?” Balaamu akasema “hapana.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Basi BWANA akafungua macho ya Balaamu, na akamwona malaika wa BWANA amesimama barabarani akiwa na upanga mkononi mwake. Balaamu akainamisha kichwa chake chini. ");
INSERT INTO swhulb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Yule malaika wa BWANA akamwambia, “Kwa nini umempiga punda wako mara tatu? Tazama, Nimekuja kama adui yako kwa sababu matendo yako kwangu yamekuwa maovu. ");
INSERT INTO swhulb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Yule punda aliniona na akageuka kutoka kwangu mara tatu. Kama asingekuwa amegeuka kutoka kwangu, hakika ningekuwa nimekua na yeye kumwacha hai. ");
INSERT INTO swhulb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu akamwambia malaika wa BWANA, nimetenda dhambi. Sikujua kuwa ulisimama kinyume na mimi barabarani. Kwa hiyo sasa, kama haikupendezi, Nitageuka.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Lakini yule malaika wa BWANA akamwambia Balaamu, “endelea na wale watu. Lakini utasema maneno nitakayokwambia tu.”Kwa hiyo Balaamu akaendelea na wale vioingozi wa Balaki. ");
INSERT INTO swhulb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki aliposikia kuwa Balaamu alikuwa amekuja, alienda kukutana naye kule mjini Moabu pale Amoni, ambao uko mpakani. ");
INSERT INTO swhulb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki akamwambia Balaamu, “Je, mimi sikutuma watu kukuita? Basi kwa nini hukuja kwangu? Je, mimi sina uwezo wa kukufanya uheshimike?” ");
INSERT INTO swhulb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ndipo Balaamu alipomjibu Balaki, “Tazama, mimi nimekuja kwako. Je mimi sina mamlaka ya kusema chochote? Mimi ninaweza kusema maneno ambayo Mungu ameweka kinywani mwangu.” ");
INSERT INTO swhulb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaamu akaenda na Balaki, na Wakafika Kiriathi Huzothi. ");
INSERT INTO swhulb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Kisha Balaki akatoa sadaka ya maksai na kondoo na kumpatia Balaamu baadhi ya hiyo nyama na wale viongozi waliokuwa pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kesho yake asubuhi, Balaki akampeleka Balaamu mpaka juu mahali pa Baali. Kule juu Balaamu aliweza kuona sehemu tu ya kambi za Waisraeli. ");
INSERT INTO swhulb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu akamwabia Balaki, “Jenga madhabahu saba kwa ajili yangu na uandae mafahari saba na kondoo dume saba.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Kwa hiyo Balaki akafanya kama Balaamu alivyoomba. Kisha Balaki na Balaamu wakatoa sadaka ya fahari mmoja na kondoo dume mmoja kwa kila madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ndipo Balaamu alipomwamiba Balaki, “Simama kwenye sadaka yako ya kuteketezwa na mimi nitaenda. Labda BWANA atakuja kukutana na mimi. Chochote atakachoniambia nitakuambia.” Kwa hiyo akaenda juu ya mlima usiokuwa na miti. ");
INSERT INTO swhulb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Wakati bado akiwa juu ya mlima. Mungu akakutana naye, na Balaamu akamwambia, “Nimejenga madhabahu saba, na nimetoa sadaka ya fahari na kondoo dume kwa kila madhabahu.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","BWANA akaweka ujumbe kwenye kinywa cha Baalamu akasema, “Rudi kwa Balaki ukamwambie.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Kwa hiyo Balaamu akarudi kwa Balaki aliyekuwa amesimama karibu na sadaka yake ya kuteketezwa, na viongozi wote wa Moabu walikuwa pamoja naye. ");
INSERT INTO swhulb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ndipo Balaamu alipoanza kunena unabii wake akisema, “Balaki amenileta kutoka Aramu, Mfalme wa Moabu kutoka katika milima ya mashariki, 'Njoo, nilaanie Yakobo kwa ajili yangu,' alisema, 'Njoo umtie unajisi Israeli,' ");
INSERT INTO swhulb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nawezaje kuwalaani wale ambao Mungu hajawalaani? Nawezaje kuwapinga wale ambao Mungu hawapingi? ");
INSERT INTO swhulb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kwa kuwa kutoka juu ya miamba Ninamwona; kutoka kwenye milima ninamtazama. Kuna watu wanaoishi pekee yao na hawajioni wenyewe kama ni taifa la kawaida. ");
INSERT INTO swhulb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Nani awezaye kuyahesabu mavumbi ya Yakobo au kuhesabu hata robo ya Israeli? Naomba nife kifo cha mtu mwenye haki, na mwisho wa maisha yangu uwe kama wake!” ");
INSERT INTO swhulb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki akamwambia Balaamu, “Umenifanyia nini? Nilikuleta ili uwalaani maadui wangu, lakini ona, umewabariki,” ");
INSERT INTO swhulb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu akajibu akasema, “Kwa nini nisiwe mwangalifu kusema kile ambacho BWANA anaweka kinywani mwangu?” ");
INSERT INTO swhulb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Basi Balaki akamwambia, “Hebu uje nami kwenye eneo jingine ili uwaone. Utakaowaona ni wale wa karibu tu, huwezi kuwaona wote. Huko sasa unaweza kunilaania hawa watu.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Kwa hiyo akampeleka Balaamu kwenye shamba la Zofimu, lililo juu ya Mlima Pisiga, na kule akajenga madhabau zingine saba. Akatoa sadaka ya fahari mmoja na kondoo dume kwa kila madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Kisha Balaamu akamwambia Balaki, “Simama hapa karibu na sadaka zako, wakati mimi naenda kukutana na BWANA kule.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Kwa hiyo BWANA akakutana na Balaamu na kumwekea ujumbe kinywani mwake. Alimwambia, “Rudi kwa Balaki ukamwambie huu ujumbe toka kwangu.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaamu akamrudia, na tazama, alikuwa amesimama karibu na sadaka zake za kuteketezwa, na vionigozi wa Moabu walikuwa pamoja naye. Balaki akamwuliza, “BWANA amekwambiaje?” ");
INSERT INTO swhulb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaamu akaanza kutoa unabii. Akasema, “Inuka, Balaki na usikilize. Nisikilize mimi wewe mwana wa Zippori. ");
INSERT INTO swhulb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mungu siyo mtu, kwamba umdanganye, au mwanadamu awezaye kubadili mawazo. Je, alishawahi kuahidi kitu pasipo kukitekeleza? Je, alishawahi kusema kuwa atafanya kitu bila kufanya kama alivyosema? ");
INSERT INTO swhulb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tazama, Mimi nimeamriwa kuwabariki. Mungu ametoa baraka, nami siwezi kuibadilisha. ");
INSERT INTO swhulb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Hajawahi kuona magumu katika Yakobo au tabu katika Israeli. BWANA Mungu wao yuko pamoja nao, na kelele za wafalme wao ziko pamoja nao. ");
INSERT INTO swhulb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mungu aliwatoa Misri kwa nguvu kama za nyati. ");
INSERT INTO swhulb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Hakuna uganga utakaofanikiwa dhidi ya Yakobo, na hakuna uchawi utakaomwumiza Israeli. Badala yake, itasemwa juu ya Yakobo na Israeli, 'Tazama kile ambacho Mungu amefanya!' ");
INSERT INTO swhulb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Tazama, watu wanainuka kama simba jike, kama vile simba ainukavyo na kuvamia. Halali chini mpaka ale windo lake na kunywa damu ya windo lake,” ");
INSERT INTO swhulb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Kisha Balaki akamwambia Balaamu, “Kamwe usiwalaani wala kuwabariki.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Lakini Balaamu akamjibu Balaki, “Sijakuambia kuwa nitasema yote ambayo BWANA ananiambia kusema? ");
INSERT INTO swhulb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki akamwambia Balaamu, “Njoo sasa, Nami nitakupeleka mahali pengine. Labda kule itampendeza Mungu kunilaania hawa hawa watu.” ");
INSERT INTO swhulb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kwa hiyo Balaki akampeleka Balaamu juu ya Mlima Peori, ambao unalitazama chini lile jangwa, ");
INSERT INTO swhulb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu akamwambia Balaki, “Nijengee madhabahu saba hapa na uniandalie mafahari saba na kondoo duume saba. ");
INSERT INTO swhulb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","“Kwa hiyo Balaki akafanya kama alivyoambiwa; akatoa sadaka ya fahari na kondoo mume kwenye kila madhabahu. ");
INSERT INTO swhulb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaamu alipooa kuwa ilimpendeza BWANA kubariki Israeli, hakwenda, kama hapo awali, kwa kutumia uganga, badala yake akatazama jangwani. ");
INSERT INTO swhulb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Akayainua macho yake na kumwona Isreli akiwa kwenye kambi, kila mmoja kwa kabila yake, na Roho wa Mungu akamjia. ");
INSERT INTO swhulb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Akapokea huu unabii na kusema, “Balaamu mwana wa Beori anataka kusema, yeye ambaye macho yake yemefunuliwa sana. ");
INSERT INTO swhulb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Huongea na kusikia maneno ya Mungu. Huona maono toka kwa Mwenyezi, ambaye mbele zake humwinamia na macho yake yakiwa yamefumbuliwa. ");
INSERT INTO swhulb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Jinsi zilivyo nzuri hema zako, ewe Yakobo, mahali unapoishi, Israeli! ");
INSERT INTO swhulb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Wamesambaa kama bonde, kama bustani zilizo pembezoni mwa mto, Kama miti ya mishubiri iliyopandwa na BWANA, ni kama mfano wa mielezi pembezoni mwa maji. ");
INSERT INTO swhulb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Maji yanatiririka katika ndoo zao, na mbegu zao zimemwagiwa maji vizuri. Mfalme wao atakuwa juu ya Agagi, na ufalme wao utaheshimiwa. ");
INSERT INTO swhulb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Mungu anamtoa Misri, na nguvu kama za nyati. Atawameza mataifa wanaopigana nao. Ataivunja mifupa yao katika vipande vipande. atawapiga kwa mishale yake. ");
INSERT INTO swhulb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ananyatia kama simba mume, na kamaa simba jike. Ni nani atakayejaribu kumsumbua? Kila mmoja anayembariki na abarikiwe; na kila mmoja anayemlaani na alaaniwe.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Hasira za Balaki zikawaka dhidi ya Balaamu naye akaipiga mikono yake kwa pamoja. Balaki akamwambia Balaamu, “Nilkuita ili uwalaani maadui zangu, Lakini tazama, umewabariki mara tatu. ");
INSERT INTO swhulb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Kwa hiyo ondoka uende nyumbani uniache sasa hivi. Nilisema ningekupa zawadi kubwa sana, lakini BWANA amekuzuilia kupata zawadi.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ndipo Balaamu alipomjibu Balaki, “Niliwaambia wale wajumbe ulionitumia, ");
INSERT INTO swhulb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'Hata kama Balaki atanipa ikulu yake ikiwa imejaa fedha na dhahabu, sitafanya zaidi ya maneno ya BWANA kwa lolote zuri au baya, au kwa chochote ambacho ningetaka kufanya. Ninaweza kusema kile tu ambacho BWANA ananiambia kusema,' Je, sikuwaambia haya? ");
INSERT INTO swhulb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Kwa hiyo sasa, tazama, nitarudi kwa watu wangu. Lakini kwanza nikuonye kile ambacho hawa watu watawafanyia watu wako katika siku zijazo.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balaamu alianza unabii huu. Akisema, “Balaamu mwana wa Beori anasema, Mtu yule aliyefumbuliwa macho yake. ");
INSERT INTO swhulb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Huu ni unabii wa mtu alisikiaye neno la Mungu, aliye na maarifa toka kwake Yeye aliye juu, aliye na maono kutoka kwa Mwenyezi, Yeye ambaye humpigia magoti macho yakiwa yamefumbuliwa. ");
INSERT INTO swhulb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ninamwona, lakini hayuko hapa sasa. Ninamtazama, lakini siyo karibu. Nyota itatokea katika Yakobo, na fimbp ya enzi itatokea katika Israeli. Naye atawapigapiga viongozi wa Moabu na kuwaharibu wa uzao wa Sethi ");
INSERT INTO swhulb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ndipo Edomu atakapokuwa miliki ya Israeli, na Seiri pia itakuwa milki yao, maadui wa Israeli, ambao Israeli atawashinda kwa nguvu zake. ");
INSERT INTO swhulb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Kutoka kwa Yakobo atatoka mfalme ambaye utawala wake naye atawaangamiza waliosalia katika mji.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Kisha Balaamu akamtazama Amaleki na akaanza kutoa unabii wake. Alisema, “Amaleki alikuwa mkuu katika mataifa, lakini mwisho wake utakuwa uharibifu.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kisha Balaamu akawatazama Wakeni na akaanza kutoa unabii wake. Akasema, “Mahali unapoishi pana usalama, na viiota vyake viko kwenye miamba. ");
INSERT INTO swhulb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Lakini pamoja na hayo, Kaini ataharibiwa na Ashuru atakapowachukua mateka.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kisha Balaamu akanza unabii wake wa mwisho. Akasema, “Ole wake atakayesalia Mungu atakapoyafanya haya? ");
INSERT INTO swhulb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Merikebu zitakuja toka pwani ya Kittimu; Zitaivamia Ashuru na kuiharibu Eberi, lakini wao pia wataishia kwenye uharibifu.” ");
INSERT INTO swhulb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kisha Balaamu akainuka na kuondoka. Akarudi nyumbani kwake, na Balaki naye akaondoka. ");
INSERT INTO swhulb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israeli akakaa Shitimu, na wanaume wakaanza kufanya ukahaba na wanawake wa Moabu, ");
INSERT INTO swhulb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","kwa kuwa Wamoabu waliwakaribishsa kutoa sadaka kwa miungu yao. Kwa hiyo watu wakala na kuisujudia miungu ya Moabu. ");
INSERT INTO swhulb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Watu wa Israeli wakaungana kumwabudu Baali wa Peori, na hasira ya BWANA ikawaka dhidi ya Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","BWANA akamwambia Musa, “Waue viongozi wote wa watu na uwanyonge mbele yangu ili waonekane wakati wa mchana, ili kwamba hasira yangu kali iondoke kwa Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kwa hiyo Musa akawaambia viongozi wa Israeli, “Kila mmoja wenu lazima awanyonge watu wake ambao wameshiriki kumwabudu Baali wa Peori.” ");
INSERT INTO swhulb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kisha mtu mmoja wa Israeli akaleta mwanamke mmoja aliyekuwa miongoni mwa familia yake. Hili lilitokea mbele ya macho ya Musa na watu wa Israeli, wakati walipokuwa wakilia mbele ya lango la hema ya kukutania. ");
INSERT INTO swhulb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwana wa Eliazari, mwana wa Haruni kuhani, alipoona hivyo, akainuka kutoka jamii ya watu akachukua mkuki mkononi mwake. ");
INSERT INTO swhulb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Akamfuata yule mwanaume Muisraeli hemani na kuwachoma kwa mkuki wote wawili kwenye miili yao, wote yule Muisraeli na yule mwanamke. Kwa hiyo ile tauni ambayo Mungu alikuwa ameituma kwa watu wa Israeli ikakoma. ");
INSERT INTO swhulb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Idadi ya wale waliokufa kwa tauni walikuwa elfu ishirini na nne. ");
INSERT INTO swhulb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","BWANA akanena na Musa, akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eliazari mwana wa Haruni, kuhani amaigeuza hasira yangu isiwe kwa wana wa Israeli kwa sababu alikuwa na wivu kati yao juu ya wivu wangu. Kwa hiyo sijawaangamiza watu wa Israeli kwa hasira yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kwa hiyo waambie, 'BWANA anasema, “Tazama, Ninampa Finehasi agano la amani. ");
INSERT INTO swhulb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Kwake na kwa wana wake baada yake, litakuwa agano la kudumu la ukuhani kwa sababu alikuwa na wivu juu yangu, Mungu wake. Amewapatanisha wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Sasa yule Muisraeli aliyeuwawa pamoja na Yule mwanamke Mmidiani alikuwa Zimri mwana wa Salu, kiongozi wa familia ya uzao wa Simeoni. ");
INSERT INTO swhulb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Jina la yule Mmidiani aliyeuwawa lilikuwa Cozibi binti wa Zuri, ambaye alikuwa mkuu wa familia wa kabila huko Midiani. ");
INSERT INTO swhulb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Kwa hiyo BWANA akanena na Musa na kusema, ");
INSERT INTO swhulb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Watendee Wamidiani kama maadui na uwaangamize, kwa kuwa waliwatendea kama maadui ");
INSERT INTO swhulb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kwa kuwadanganya. Waliwaongoza katika uovu kwa swala la Peori na kwa swala la dada yao Cozibi, binti wa kiongozi wa Wamidiani, ambaye aliuawa siku ile ya tauni kwa swala la Peori.” ");
INSERT INTO swhulb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ilitokea baada ya tauni ambayo BWANA alimwambia Musa na Eliazari mwana wa Haruni kuhani, Alisema, ");
INSERT INTO swhulb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Wahesabu watu wote wa Israeli, kuanzia miaka ishirini na zaidi, kwa jamaa ya familia zao wote ambao wanaweza kwenda kwenye vita kwa ajili ya Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Kwa hiyo Musa na Eliazari kuhani wakawaambia katika uwanda wa Moabu karibu na Yorodani kule Yeriko na kusema, ");
INSERT INTO swhulb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Wahesabuni watu, kuanzi umri wa miaka ishirini na zaidi kama BWANA alivyomwamuru Musa na watu wa Israeli walitoka katika nchi ya Misri.” ");
INSERT INTO swhulb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reubeni ndiye aliyekuwa wa kwanza, Kutoka kwa mwana wake Hanoki ulitokea ukoo wa Wahanoki. Kutoka kwa Palu ulitokea ukoo wa Wapalu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Kutoka Hezroni. ulitokea ukoo wa Wahezroni. Kutoka kwa Kami ulitokea ukoo wa Wakami. ");
INSERT INTO swhulb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hizi ndizo zilikuwa koo za uzao wa Reubeni, ambzo idadi yao ilikuwa wanaume 43, 730. ");
INSERT INTO swhulb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliabu alikuwa mwana wa Palu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Wana wa Eliabu walikuwa ni Nemueli, Dathani. na Abiramu. Hawa ni walewale Dathani na Abiramu waliomfuata Kora waliompinga Musa na Haruni na kumpinga BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Pale ambapo dunia ilifungua kinywa na kuwameza pamoja na Kora wakati ambapo wafuasi wa Kora walikufa. Wakati ule, moto uliteketeza wanaume 250, amboa wlikuwa ishara ya onyo. ");
INSERT INTO swhulb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lakini uzao wa Kora haukufa. ");
INSERT INTO swhulb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ukoo wa uzao wa Simeoni walikuwa hawa wafuatao: Kutoka kwa Nemueli, ukoo wa Wanemueli, kwa Jamini, ukoo wa Wajamini, kwa Jakini, ukoo wa Wajakini, ");
INSERT INTO swhulb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kwa Zera, ukoo wa Wazera, kwa Shauli, ukoo wa Washauli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hizi ndizo koo za uzao wa Simeoni, idadi yao ilikuwa wanaume 22, 200. ");
INSERT INTO swhulb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Koo za uzao wa Gadi zilikuwa hizi: Kwa Zefoni, Ukoo wa Wazefoni, kwa Hagi, ukoo wa Wahagi, kwa Shuni, ukoo wa Washuni, ");
INSERT INTO swhulb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kwa Ozini, ukoo wa Waozini, kwa Eri, ukoo wa Waeri, ");
INSERT INTO swhulb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","kwa Arodi, ukoo wa Waarodi, kwa Areli, ukoo wa Waareli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hizi ndizo koo za uzao wa Gadi, idadi yao walikuwa wanaume 40, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Wana wa Yuda walikwa Er na Onani, lakini hawa walifia katika nchi ya Kanaani. ");
INSERT INTO swhulb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Koo zingine za uzao wa Yuda zilikuwa hizi: Kwa Shela, ukoo wa Washela, kwa Perezi, ukoo wa Waperezi, na kwa Zera, ukoo wa Wazera. ");
INSERT INTO swhulb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Uzao wa Perezi walikuwa hawa: Kwa Hezroni, ukoo wa Wahezroni, kwa Hamuli, ukoo wa Wahamuli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hizi ndizo zilizokuwa koo za Yuda, idadi yao ilikuwa wanaume 76, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Koo za uzao wa Isakari zilikuwa hizi: Kwa Tola, ukoo wa Watola, kwa Puva, ukoo wa Wapuva, ");
INSERT INTO swhulb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kwa Jashubu, ukoo wa Wajashubu, kwa Shimroni, ukoo wa Washimroni. ");
INSERT INTO swhulb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hizi ndizo zilikuwa koo za Isakari, Idadi yao ilikuwa wanaume 64, 300. ");
INSERT INTO swhulb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Koo za uzao wa Zabuloni zilikuwa hizi: Kwa Seredi, ukoo wa Waseredi, kwa Eloni, ukoo wa Waeloni, kwa Jahaleeli, ukoo wa Wajahaleeli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hizi ndizo zilikuwa koo za Zabuloni, idadi y ao ilikuwa wanaume 60, 500. ");
INSERT INTO swhulb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Koo za uzao wa Ysufu zilikuwa Manase na Efraimu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Huu ndio uliokuwa uzao wa Manase: Kwa Machiri, ukoo wa Wamachiri (Machiri ndiye aliyekuwa baba wa Giliedi), kwa Giliedi, ukoo wa Wagiliedi. ");
INSERT INTO swhulb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Wazo wa Giliedi walikuwa hawa wfuatao: Kwa Lezeri, ukoo wa Walezeri, kwa Helweki, ukoo wa Waheleki, kwa Asrieli, ");
INSERT INTO swhulb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ukoo wa Asrieli wa Waasrieli, kwa Shekemu, ukoo wa Washekemu, ");
INSERT INTO swhulb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kwa Shemida, ukoo wa Washemida, kwa Hefa, ukoo wa Wahefa. ");
INSERT INTO swhulb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehadi mwana wa Hefa hakuwa na watoto wa kiume bali alikuwa na mabinti. Majina ya binti zake yalikuwa Mahilahi, Noha, Hoglaha, Milika, na Tiriza. ");
INSERT INTO swhulb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hizi ndizo koo za Manase, idadi yao ilikuwa wanaume 52, 700. ");
INSERT INTO swhulb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Koo za wana wa uzao wa Efraimu zilikuwa hizi zifuatazo: Kwa Shuthelaha, ukoo wa Washutheleha, kwa Becheri, ukoo wa Wabecheri, kwa Tahana, ukoo wa Watahana. ");
INSERT INTO swhulb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Uzao wa Shuthelaha walikuwa, kwa Erani, ukoo wa Waerani. ");
INSERT INTO swhulb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hizi ndizo koo za uzao wa Efraimu, idadi yao ilikuwa wanaume 32, 500. Huu ndio uzao wa Yusufu, uliohesabiwa toka kila koo zao. ");
INSERT INTO swhulb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Koo za uzao wa Benjamini zilikuwa hizi zifuatazo: Kwa Bela ukoo wa Wabela, kwa Ashibeli, ukoo wa Washibeli, kwa Ahiramu, ukoo wa Wahiramu, ");
INSERT INTO swhulb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kwa Shefufamu, ukoo wa Washefumamu, kwa Hufamu, ukoo wa Wahufamu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Wana wa Bela walikuwa ni Ardi na Naamani. Kutoka kwa Ardi ulijitokeza ukoo wa Waardi, na kutoka kwa Naamani ukajaitokeza ukoo wa Wanaamani. ");
INSERT INTO swhulb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hizi ndizo koo za uzao wa Benjamini. Idadai yao ilikuwa wanaume 45, 600. ");
INSERT INTO swhulb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Kooo za uzao wa Dani zilikuwa hizi zifuatazo: Kwa Shuhamu, ukoo wa Washuhamu. Hizi ndizo koo za uzao wa Dani. ");
INSERT INTO swhulb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Idadi ya koo zote za Washuhamu ilikuwa wanaume 64, 400. ");
INSERT INTO swhulb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Koo za uzao wa Asheri zilikuwa zifuatazo: Kwa Imna, ukoo wa Waimna, kwa Ishvi, ukoo wa Waishivi, kwa Beria, ukoo wa Waberia. ");
INSERT INTO swhulb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Uzao wa Beria walikuwa hawa: Kwa Heberi, ukoo wa Waheberi, kwa Malikieli, ukoo wa Wamalikieli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Jina la binti wa Asheri lilikuwa Sera. ");
INSERT INTO swhulb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hizi ndizo koo za uzao wa Asheri, idadi yao ilikuwa wanaume 53, 400. ");
INSERT INTO swhulb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Koo za uzao wa Naftali zilikuwa zifuatazo: Kwa Jahazeeli, ukoo wa Wajahazeel, kwa Guni, ukoo wa Waguni, ");
INSERT INTO swhulb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kwa Jezeri, ukoo wa Wajezeri, kwa Shilemu, ukoo wa Washilemu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hizi ndizo zilizokuwa koo za uzao wa Naftali, idadi yao walikuwa wanaume 45, 000. ");
INSERT INTO swhulb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Hii ndiyo iliyokuwa jumla kuu ya wanaume wa Israeli: 601, 730. ");
INSERT INTO swhulb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","BWANA akanena na Musa akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Ile ardhi itagawanywa kati ya wanaume hawa kama urithi wao kwa kufuata idadi ya majina yao. ");
INSERT INTO swhulb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kwa zile koo kubwa utawagawia urithi mkubwa, na kwa koo ndogo ndogo utawagawia urithi kidogo. Kwa kila familia utawapa urithi kufuata idadi ya wanaume waliohesabiwa. ");
INSERT INTO swhulb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Lakini ardhi itagawiwa kwa kupigiwa kura. Watairithi nchi kama itakavyogawiwa kwa kufuata koo za mababu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Urithi huu utagiwiwa kufuata koo kubwa na ndogo, watagawiwa kwa kufuata kura zitakavyokuwa. ");
INSERT INTO swhulb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Koo za Walawi, zilizohesabiwa kwa kufuata ukoo kwa ukoo, walikuwa hivi: Kwa Gerishoni, ukoo wa Wagerishoni, kwa Kohathi, ukoo wa Wakohathi, kwa Merari, ukoo wa Wamerari. ");
INSERT INTO swhulb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Koo za walawi zilikuwa hzi: ukoo wa Walibni, Ukoo wa Wahebroni, ukoo wa Wamahali, ukoo wa Wamushi, na ukoo wa Wakora. Kohathi alikuwa wa uzao wa Amramu. ");
INSERT INTO swhulb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Jina la mke wa Amramu lilikuwa Jokibed, wa ukoo wa Lawi, aliyekuwa amezaliwa kwa Walawi kule Misri. Alimzalia Amramu watoto wao, ambao walikuwa ni Haruni, Musa, na Miriamu dada yao. ");
INSERT INTO swhulb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Kwa Haruni alizaliwa Nadabu na Abihu, Eliazari na Ithamari. ");
INSERT INTO swhulb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabu na Abihu walikufa walipotoa sadaka kwa BWANA sadaka ya moto isiyokubalika. ");
INSERT INTO swhulb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Waume walioheabaiwa miionigoni mwao walikuwa elfu ishirini na tatu, hawa nia wale wa umri wa mwezi mmoja na zaidi. Lakini hawakuhesabiwa kati ya wazawa wa Israeli kwa sababu hawakupewa urithi miongoni mwa wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Hawa nadio wale walihesabiwa na Musa na Eliazari kuhani. Waliwahesabu watu wa Israeli katika uwanda wa Moabu karibu na Yorodani kule Yeriko. ");
INSERT INTO swhulb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Lakini miongoni mwa hawa hapakuwa na mwanamume aliyehasabiwa na Musa na Haruni kuhani wakati wana wa uzao wa Israeli walipohesabiwa katika jangwa la Sinai. ");
INSERT INTO swhulb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kwa BWANA alikuwa amesema kuwa kwa hakika watu hao wote wangefia jangwani. Hapakuwa na mtu aliyebaki miongoni mwao, isipokuwa Kalebu mwana wa Yefune na Joshua mwana wa Nuni. ");
INSERT INTO swhulb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Kisah wakaja kwa Musa binti wa Zelofehadi mwana wa Hefa mwana wa Gilied mwana wa Machiri mwana wa Manase, wa ukoo wa Manase mwana wa Yusufu. Hawa ndio waliokuwa binti zake: Mahala, Noha, Hogla, Milika, na Tiriza. ");
INSERT INTO swhulb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Walisimama mbele ya Musa, Eliazari kuhani, kwa. viongozi, na mbele ya watu wote langoni mwa hema ya kukutania. Walisema, ");
INSERT INTO swhulb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baba yetu alifia jangwani. Hakuwa mmoja wa wale waliompinga BWANA katika lile kundi la Kora. Alikufa kwa dhambi zake, na hakuwa na watoto wa kiume. ");
INSERT INTO swhulb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kwa nini jina la baba yetu liondolewe mioingoni mwa ukoo wa jamaa zake kwa sababu ya kukosa wana? Tupeni ardhi miongoni mwa ndugu wa baba zetu.” ");
INSERT INTO swhulb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Kwa hiyo Musa alileta shauri hilo mbele za BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","BWANA akanena na Musa akamwambia, “ Binti wa ");
INSERT INTO swhulb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Zelofehadi wanasema kitu sahihi. Lazima uwaptie ardhi kama urithi miongoni mwa ndugu wa baba zao, na uhakikishe kuwa urithi wa baba zao wanapata. ");
INSERT INTO swhulb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Utawaambia wana wa Israeli na kusema, 'Kama mtu anakufa na hana mtoto wa kiume, basi utaufanya urithi wake wapewe binti zake. ");
INSERT INTO swhulb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kama hana binti, basi urithi wake atapewa kaka zake. ");
INSERT INTO swhulb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kama hana kaka zake basi huo urithi watapewa ndugu wa baba yake. ");
INSERT INTO swhulb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kama baba yake hana ndugu, basi huo urithi atapewa ndugu yake wa karibu katika ukoo, na utauchukua kuwa wake. Hii itakuwa sheria iliyoanzishwa kwa amri kwa ajili ya watu wa Israeli kama BWANA akivyoniamuru.” ");
INSERT INTO swhulb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","BWANA alimwamia Musa, “Nenda juu ya mlima Abaraimu na uitazama nchi ambyo nimewapa wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Baada ya kuwa umeiona, pia lazima ufe, kama Haruni kaka yako. ");
INSERT INTO swhulb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Hii itatokea kwa sababu ulipinga amri yangu katika jangwa la Sini. Pale ambapo maji yalitoka kwenye mwamba, katika hasira yako ulishindwa kuniheshimu mimi kama mtakatifu mbele ya macho ya watu wote.” Haya ni yale maji ya Meriba ya Kadeshi katika jangwa la Sini. ");
INSERT INTO swhulb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Ndipo Musa akamwambia BWANA akisema, ");
INSERT INTO swhulb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Wewe, BWANA, Mungu wa wote wenye mwili, uchague mtu awe juu ya watu, ");
INSERT INTO swhulb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","mtu ambaye atatoka na kuingia kuja kwao na kuwatoa kisha kuwarudisha, ili kwamba watu wako wasije kuwa kama kondoo wasiokuwa na mchungaji.” ");
INSERT INTO swhulb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","BWANA akanena na Musa, “Mchukue Joshua mwana wa Nuni, mtu ambaye Roho yangu hukaa, na umwekee mikono yako juu yake. ");
INSERT INTO swhulb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Umweke mbele ya Eliazari kuhani na mbele ya watu wote, na umwamuru kuwaongoza mbele ya macho yao. ");
INSERT INTO swhulb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Utaweka baadhi ya mamlaka yako kwake, ili kwamba watu wote wa Isareli wamtii. ");
INSERT INTO swhulb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ataenda mbele ya Eliazari kuhani ili kutafuta mapenzi yangu kwake kwa ajili ya maamuzi ya kura. Yeye ndiyo atakayetoa amri ili watu kutoka na kuingia, yeye pamoja na watu wa Israeli, ambao ni watu wote.” ");
INSERT INTO swhulb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Kwa hiyo Musa akafanya kama alivyoagizwa na BWANA. Alimchukua Joshua na kumweka mbele ya Eliazari kuhani na mbele ya jamii yote. ");
INSERT INTO swhulb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Akaweka mikono yake juuy ake na kumwamuru aongoze, kama BWANA alivyokuwa amemwamuru kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","BWANA akanena na Musa akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Waamuru wana wa Isrseli uwaambie, 'Mtanitolea sadaka kwa wakati uliopangwa, chakula cha sadaka yangu kilichotengenezwa kwa moto ili kutoa harufu nzuri kwa ajili yangu. ");
INSERT INTO swhulb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Pia uwaambie, 'Hii ni sadaka iliyotengenezwa kwa moto ambayo mtaitoa kwa BWANA- mwanakondoo dume wa mwaka mmoja asiyekuwa na waa, wawili kila siku kuwa sadaka ya kuteketezwa ya kila siku. ");
INSERT INTO swhulb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mwanakodoo mmoja atatolewa sadaka asubuhi, na mwingine atatolewa sadaka jioni. ");
INSERT INTO swhulb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Mtatoa sadaka ya sehemu ya kumi ya efa ya unga mwembamba kuwa sadaka ya unga, uliochanganywa na robo ya hini ya mafuta yaliyokamuliwa. ");
INSERT INTO swhulb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hii ni sadaka ya ya kuteketezwa ya kila siku iliyoamriwa mlima Sinai ili kutoa harufu nzuri, sadaka iliyotengenezwa kwa moto kwa ajili ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Pamoja na robo ya hini ya sadaka ya kinywaji kwa mmoja wa hao wanakondoo. Utaimimina mahali patakatifu hiyo sadaka ya kinywaji kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Yule mwanakondoo mwingine utamtoa sadaka jioni pamoja na sadaka ya unga kama kama yule wa asubuhi alivyotolewa. Pia utatoa tena sadaka ya kinywaji pamoja naye, sadaka iliyotengenezwa kwa moto ili kutoa harufu nzuri kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Katika siku ya Sabato utatoa wanakondoo dume wawili, wa umri wa mwaka mmoja kila mmoja wasiokuwa na dosari, na sehemu ya kumi mbili ya efa ya unga mwembamba kwa sadaka ya unga, uliochanganywa na mafuta, pamoja na sadaka ya kinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hii itakuwa sadaka ya kuteketezwa kwa kila siku ya Sabato, kama nyongeza ya ile sadaka ya kila siku pamoja na ile sadaka ya kinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Kila mwanzo wa mwezi, mtatoa sadaka za kuteketezwa kwa BWANA. Utatoa sadaka ya fahari wawili wachanga, kondoo dume mmoja, na wanakondoo dume saba wa umri wa mwaka mmoja wasiokuwa na dosari. ");
INSERT INTO swhulb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Pia mtatoa sehemu ya kumi tatu ya efa unga mwembamba kuwa sadaka ya unga uliochanganywa na mafuta kwa kila fahari, na sehemu za kumi mbili za unga mwembamba kuwa sadaka ya unga uliochanganywa na mafuta kwa yule kondoo mume mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Pia mtatoa sehemu ya kumi ya efa ya unga mwembamba uliochanganywa na mafuta kuwa sadaka ya unga kwa kila mwanakondoo. Hii itakuwa sadaka ya kuteketezwa, ya kutoa harufu nzuri, sadaka iliyotengenezwa kwa moto kwa ajilI ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Sadaka ya kinywaji ya watu itakuwa nusu ya hini ya divai ya yule fahari, sehemu ya tatu ya hini ya kondoo dume, na robo ya hini ya mwanakondoo. Hii ndiyo itakuwa sadaka ya kuteketezwa ya kila mwezi kwa miezi yote ya mwaka. ");
INSERT INTO swhulb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Mtatoa beberu mmoja kuwa sadaka ya dhambi kwa BWANA. Hii itakuwa nyongeza kwa ile sadaka ya kila siku pamoja na ile sadaka ya viinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Katika siku kumi na nne, ya mwezi wa kwanza itakuwa Pasaka ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Katika sku ya kumi na tano ya mwezi huu kutakuwa na sikukuu. Mtakuka mikate isiyo na chachu kwa siku saba. ");
INSERT INTO swhulb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Katika siku ya kwanza kutakuwa na kusanyiko takatifu la kumheshimu BWANA. Katika siku hiyo msifanye kazi zenu za kila siku ");
INSERT INTO swhulb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Hata hivyo, mtatoa sadaka iliyotengenezwa kwa moto, sadaka ya kuteketezwa kwa BWANA. Mtatoa sadaka ya fahari wawili, kondoo dume mmoja, na kondoo dume saba wa umri wa mwaka mmoja wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pamoja na yule fahari, mtatoa sadaka sehemu za tatu efa za unga mwembamba uliochanganywa na mafuta, pamoja na yule kondoo mume sehemu za pili za kumi. ");
INSERT INTO swhulb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Kwa kila wale wanakondoo saba, mtatoa sehemu ya kumi ya efa ya unga mwembamba uliochanganywa na mafuta, ");
INSERT INTO swhulb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","na beberu mmoja kuwa sdaka ya dhambi ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhulb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mtotoa hivi vitu kama sadaka ya nyongeza katika ile sadaka ya kila siku inayotakiwa kila asubuhi. ");
INSERT INTO swhulb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Kama ilivyofafanuliwa hapa, mtatoa sadaka hizi kila siku, kwa zile siku saba za Pasaka, kile chakula cha sadaka kilichotengenezwa kwa moto kuwa harufu nzuri kwa BWANA. Hiki kitatolewa kuwa sadaka ya nyongeza ya ile sadaka ya kuteketezwa na pamoja na ile sadaka ya vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Siku ya saba mtakuwa na kusanyiko takatifu ili kumheshimu BWANA, na katika siku hiyo msifanye zile kazi zenu zakila siku. ");
INSERT INTO swhulb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Pia katika siku ya malimbuko, mtakapokuwa mnatoa sadaka ya unga mpya katika sikukuu zenu za Majuma, mtakuwa na kusanyiko takatifu la kumheshimu BWANA, na katika siku hiyo msifanye kazi zenu za kila siku. ");
INSERT INTO swhulb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mtatoa sadaka ya kuteketezwa ili kutoa harufu nzuri kwa BWANA. Mtatoa fahari wawili wachanga, kondoo mume mmoja, na wanakondoo saba waume wa mwaka mmoja. ");
INSERT INTO swhulb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pamoja na hiyo mtatoa sadaka ya unga: unga mwembamba uliochanganywa na mafuta, sehemu tatu za kumi za efa za unga mwembamba uliochanganywa na mafuta kwa kila fahari na sehemu kumi mbili za yule kondoo mume. ");
INSERT INTO swhulb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Toeni sehemu ya kumi ya efa ya unga mwembamba uliochanganywa na mafuta kwa kila wale wanakondoo saba, ");
INSERT INTO swhulb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","na beberu mmoja ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhulb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Mtakapotoa hao wanyama wasio na dosari, pamoja na sadaka zake za vinywaji, hii itakuwa sadaka ya nyongeza katika zile sadaka za kila siku na pamoja na zile sadaka za unga.'” ");
INSERT INTO swhulb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Katika siku ya kwanza, ya mwezi wa saba, mtakuwa na kusanyiko takatifu la kumwabudu BWANA. Katika siku hiyo hamtafanya kazi zenu za kila siku. Itakuwa siku ya kupiga matarumbeta. ");
INSERT INTO swhulb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mtatoa sadaka ya kuteketezwa ya kufanya harufu nzuri kwa BWANA. Mtatoa sadaka ya fahari mchanga, kondoo dume mmoja na wanakondoo dume saba wa mwaka mmoja, kila mmoja mkamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pamoja na hao mtatoa sadaka ya unga, unga mwembamba uliochanganywa na mafuta, sehemu tatu za kumi za efa kwa ajili ya huyo fahari, sehemu mbili za kumi kwa ajili ya huyo kondoo mume, ");
INSERT INTO swhulb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na sehemu ya kumi ya kila hao wanakondoo waume saba. ");
INSERT INTO swhulb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Na mtatoa beberu mmoja kuwa sadaka ya dhambi ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Toeni hizo sadaka katika mwezi wa saba kama nyongeza ya sadaka mtakazotoa kila mwanzo wa kila mwezi: pamoja na sadaka maalumu za kuteketezwa na sadaka za unga. Hizi zitakuwa nyongeza za sadaka za kuteketezwa za kila siku, na sadaka zake za unga, na sadaka zake za vinywaji. Utakapokuwa ukiendelea na sadaka hizi, utakuwa ukitii kile kilichoamriwa kutoa harufu nzuri, sadaka iliyotengenezwa kwa moto kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Siku ya kumi ya mwezi wa saba, mtakuwa na kusanyiko takatifu la kumwabudu BWANA. Mtajinyeneyekeza na hamtafanya kazi. ");
INSERT INTO swhulb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mtatoa sadaka ya kuteketezwa ili kutoa harufu nzuri kwa BWANA. Mtatoa fahari mmoja mchanga ili kutoa harufu nzuri, kondoo mmoja mume, na wanakondoo saba waume wa mwaka mmoja. Wote wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Pamoja na sadaka hizo utatoa sadaka ya unga, unga mwembamba uliochanganywa na mafuta, sehemu tatu za kumi za efa kwa ajili ya fahari, sehemu mbili za kumi za kondoo dume mmoja, ");
INSERT INTO swhulb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na sehemu ya kumi ya efa moja kwa kila mwanakondoo wale saba. ");
INSERT INTO swhulb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mtatatoa beberu mmoja kuwa sadaka ya upatanisho. Hii itakuwa sadaka ya nyongeza ya upatanisho, ya sadaka ya kila siku ya kuteketezwa, pamoja na sadaka za unga, na sadaka zake za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Siku ya kumi na tano ya mwezi wa saba, mtakuwa na kusanyiko takatifu lakumwabudu BWANA. Siku hiyo hamtafanya kazi za kila siku, na mtazitunza hizo sikukuu kwa muda wa siku saba kwa ajili ya BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Mtatoa sadaka ya kuteketezwa, sadaka iliyotengenezwa kwa moto ilikutoa harufu nzuri kwa BWANA. Mtatoa mafahari wachanga kumi na tatu, kondoo waume wawili, na wanakondoo waume kumi na nne wa mwaka mmoja. Wote wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Pamoja na hao mtatoa sadaka ya unga, unga mwembaba uliochanganywa na mafuta, sehemu tatu za kumi za efa kwa kila fahari katika hao kumi na tatu, sehemu mbili za kumi kwa kila hao kondoo dume wawili, ");
INSERT INTO swhulb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na sehemu ya kumi ya efa ya hao wanakondoo kumi na nne. ");
INSERT INTO swhulb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mtatoa beberu mmoja kuwa sadaka ya dhambi katika nyongeza ya sadaka ya kuteketezwa, sadaka yake ya unga, pamoja na sadaka za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Siku ya pili ya kusanyiko, mtatoa mafahari kumi na mbili, kondoo dume wawili na wanakondoo dume kumi na mbili wa umri wa mwaka mmoja, wote wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Pamoja nao mtatoa sadaka ya unga, na sadaka ya vinywaji kwa ajili ya wale mafahari, kondoo dume, na kwa ajili ya wale wanakondoo, mkitoa sadaka nyingi kama ilvyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mtatoa beberu mmoja kuwa sadaka ya dhambi kuwa nyongeza ya sadaka za kila siku, sadaka yake ya unga, na sadaka zake za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Siku ya tatu ya kusanyiko, mtatoa sadaka mafahari kumi na moja, kondoo dume wawili, na wanakondoo dume kumi na nne wa umri wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Pamoja na hizo sadaka mtatoa sadaka ya unga na sdaka ya vinywaji kwa wale mafahari, kwa wale kondoo dume, na kwa wale wanakondoo, utoe sadaka nyingi kama ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mtatoa sadaka beberu mmoja kuwa sadaka ya dhambi kama nyongeza ya zile sadaka za kila siku, na sadaka zake za unga, na sadaka zake za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Siku ya nne ya kusanyiko, mtatoa mafahari kumi, kondoo dume wawili, na wanakondoo dume kumi na nne wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Pamoja na sadaka hizo mtatoa sadaka za unga na sdaka za vinywaji kwa wale mafahari, na kwa wale kondoo dume na kwa wale wanakodoo, mtatoa sadaka nyingi kama ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mtatoa beberu mmoja kuwa sadaka ya dhambi kuwa nyongeza ya sadaka za kuteketezwa za kila siku, sadaka zake za unga, na sadaka zake za vinywaji ");
INSERT INTO swhulb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Siku ya tano ya kusanyiko, mtatoa mafahari tisa, kondoo dume wawili, na wanakondoo dume kumi na nne wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Pamoja na sadaka hizo mtatoa sadaka za unga na sadaka ya vinywaji kwa ajili ya wale mafahari, kondoo dume, na wale wanakondoo, mkitoa sdaka nyingi kama ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mtatoa beberu mmoja kuwa sadaka ya dhambi kama nyongeza ya sadaka za kuteketezwa za kila siku, na sadaka zake za unga, na sadaka za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Siku ya sita ya kusanyiko, mtatoa mafahari wanane, kondoo dume wawili, na wanakondoo kumi na nne wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Pamoja na sadaka hizo mtatoa sadaka za unga nasadaka za vinywaji kwa wale mafahari, kondoo wa dume na wale wanakondoo, mkitoa sadaka nyingi kama ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mtatoa beberu kuwa sadaka ya dhambi kama nyongeza ya sadaka za kila siku za kuteketezwa, sadaka zadaka zake za unga, na sadaka zake za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Siku ya saba ya kusanyiko, mtatoa mafahari saba, kondoo dume saba, na wanakondoo dume kumi na nne wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Pamoja nao mtataengeneza sadaka ya unga na sadaka ya vinywaji kwa ajili ya wale mafahari, na kondoo dume, na kwa wale wanakondoo, mkitoa sadaka nyingi kama ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mtatoa beberu mmoja kuwa sadaka ya dhambi kama nyongeza ya sadaka ya kuteketezwa ya kila siku, na sadaka yake ya unga, na sadaka yake ya vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Siku ya nane mtakuwa na kusanyiko lingine makini. Hamtafanya kazi zenu za kila siku. ");
INSERT INTO swhulb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mtafanya sadaka za kuteketezwa, sadaka iliyotengenezwa kwa moto ili kutoa harufu nzuri kwa BWANA. Mtatoa fahari mmoja, kondoo mmoja dume, na wanakondoo saba dume wa umri wa mwaka mmoja, wakamilifu. ");
INSERT INTO swhulb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Mtatoa sadaka zake za unga na sadaka zake za vinywaji kwa ajili ya yule fahari, kondoo dume, na kwa wale wanakondoo, mkifanya sadaka nyingi kadri ilivyoamriwa. ");
INSERT INTO swhulb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mtatoa beberu mmoja kuwa sadaka ya dhambi kama nyongeza ya sadaka za kila siku, na sadaka zake za unga, na sadaka zake za vinywaji. ");
INSERT INTO swhulb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Hivi ndivyo utakavyotoa sadaka kwa BWANA katika sikukuu zenu za kila mwaka. Hivi vitakuwa nyongeza ya viapo vyenu na sadaka zenu za hiari. Mtavitoa hivi kama sadaka zenu za kuteketezwa, sadaka za unga, sadaka za vinywaji, na sadaka za amani.” ");
INSERT INTO swhulb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa aliwaambia wana wa Israeli kila kitu ambacho BWANA alikuwa amemwamuru kusema. ");
INSERT INTO swhulb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa aliwambia viongizi wote wa makabila ya watu wa Israeli. “Hiki ndicho ambacho BWANA ameamuru. ");
INSERT INTO swhulb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mtu yeyote atakayefanya nadhiri kwa BWANA, au kuapa kwa kiapo ili kufunga nafsi yake kwa ahadi, asivunje neno lake. Atafanya sawa na ahadi yake imtokayo kinywani mwake. ");
INSERT INTO swhulb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Na kama binti anaishi katika nyumba ya baba yake kwa atafanya nadhiri kwa BWANA na kuifunga nafsi yake kwa kiapo, ");
INSERT INTO swhulb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na kama baba yake atasikia hiyo nadhirina ahadi ambayo ametumia kuifunga nafsi yake, naye asiseme kitu kumzuia, ndipo nadhiri zake zitakuwa na nguvu. Kila ahadi ambayo ameitumia kuifunga nafsi yake itabaki kuwa na nguvu. ");
INSERT INTO swhulb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Lakini kama baba yake atasikia nadhairi yake na ahadi zake, na kama hatasema chochote kwake, ndipo nadhiri zake zote na ahadi alizofanya zitakapokuwa na nguvu. ");
INSERT INTO swhulb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Hata hivyo, kama baba yake atasikia nadhri zake zote alizofanya na ahadi zake makini ambazo ametumia kufunga nafsi yake, na kama atazitengua ndani ya siku hiyo, ndipo hizo nadhiri hazitakuwa na nguvu. BWANA atamsamehe kwa kuwa baba yake amemzuia. ");
INSERT INTO swhulb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Kama ataolewa angali katika hivyo viapo, au kama atafanya ahadi za bila kufikiri ambazo atajifunga nazo, hivyo vifungo vitakuwa na nguvu. ");
INSERT INTO swhulb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Lakini kama mume wake atamzuia siku hiyo hiyo ambayo atamskia akiapa, basi atabatailisha hicho kiapo alichokifanya, maneno yake ya midomo yaka ya bila kufikiri ambayo kwayo amefunga nafsi yake. BWANA atamfungua. ");
INSERT INTO swhulb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Lakini kwa mjane au kwa mwanamke aliyetalikiwa, kila kitu amabacho atakisema kufunga nafsi yake lazima kitabaki na nguvu kinyume na yeye. ");
INSERT INTO swhulb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Na kama mwanamke atafanya kiapo katika nyumba ya mume wake au akijifunga mwenyewe kwa kufanaya kiapo, ");
INSERT INTO swhulb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na mume wake akakisikia hicho kiapo na hakusema chochote kwake na hakumpinga, basi viapo vyake vitasimama na vifungo alivyovifanaya vitabaki na nguvu. ");
INSERT INTO swhulb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Lakini kama mume wake atamzuilia katika siku hiyo ambayo atavisikia, basi chochote ambacho kitatoka katika kinywa chake kuhusu viapo vyake au ahadi zake havitabaki kuwa na nguvu. Mume wake atkuwa amevibatilisha. BWANA atamfungua. ");
INSERT INTO swhulb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Kila kiapo ambacho mwanamke anakifanya ambacho kinamfunga ili kujikana kianaweza kuthibitika au kubatilishwa na mume wake. ");
INSERT INTO swhulb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Lakini kama hatasema chochote kwake siku baada ya siku, basi atathibitisha nadhiri zake na ahadi zake zinazomfunga ambazo amefanya. Atakuwa amezithibitisha kwa sababu hakusema chochote wakati alipozisikia. ");
INSERT INTO swhulb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Na kama mume wake atajariibu kubatilisha kiapo cha mke wake baada ya kuzisikia kwa muda mrefu, basi ataajibika kwa dhambi zake.” ");
INSERT INTO swhulb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Hizi ndizo amri ambazo Mungu alimwamuru Musa kuzitangaza - amri ambazo ziko kati ya mume na mke wake na kati ya baba na binti yake wakati akiwa katika ujana wake katika familia ya baba yake. ");
INSERT INTO swhulb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","BWANA alinena na Musa na kumwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Uwalipizie kisasi Wamidiani kwa kile walichowafanya Waisraeli. Baada ya kufanya hivyo utakufa na kukusanyika na watu wako.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kwa hiyo Musa akawaambia watu. Akasema, “andaeni baadhi ya majeshi yenu kwa ajili ya vita ili kwamba wakawapige Wamidiani na kubeba kiapo cha BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kwa kila kabila la Israeli watatuma askari elfu moja kwa ajili ya vita.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Kwa hiyo kati ya wanaume maelfu elfu wa Israeli, wanaume elfu moja walitolewa kwa ajili ya vita, jumla ya wanaume elfu kumi na mbili. ");
INSERT INTO swhulb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Kisha Musa akawatuma kwenda vitani, elfu moja toka kila kabila pamoja na Finehasi mwana wa Eliazari kuhanai, wakiwa na vitu kutoka mahali patakatifu wakiwa na matarumbeta kwa ajili ya ishara za sauti. ");
INSERT INTO swhulb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Wakapigana na Midiani, kama BWANA alivyokuwa amemwamuru Musa. Wakamwua kila mwanaume. ");
INSERT INTO swhulb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Wakawaua wafalme wa Midiani pamoja na wengine waliowaua ni: Evi, Rekimu, Zuri, Huri, na Reba, hawa walaikuwa ndio waflme watano wa Midiani. pia walimwua Balaamu mwana wa Beori, kwa upanga. ");
INSERT INTO swhulb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Jeshi la Israeli likawachukua mateka wanawake wa Midiani, watoto wao, mifugo yao yote, kondoo wao na bidhaa zao zote. walivichukua hivi kama mateka. ");
INSERT INTO swhulb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Waliichoma moto miji yao yote walimoishi na kambi zao zote. ");
INSERT INTO swhulb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Walichukua vitu vyote na wafungwa, watu na wanyama. ");
INSERT INTO swhulb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wakawaleta mateka, nyara, na wakakamata vitu wakavileta kwa Musa, na Eliazari kuhani, na kwa jamii ya watu wa Israeli. Wakavileta hivi vitu kambini katika uwanda wa Moabu, kule Yorodani karibu na Yeriko. ");
INSERT INTO swhulb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, Eliazari kuhani, pamoja na viongozi wa watu wakaenda kukutana nao nje ya kambi. ");
INSERT INTO swhulb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Lakini Musa alikuwa na hasira dhidi ya viongozi wa jeshi, Wale majemedari wa maelfu na maakida wa mamia, waliotoka kupigana. ");
INSERT INTO swhulb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa akawaambia, “Je, mmeawaacha wanawake wote kuishi? ");
INSERT INTO swhulb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Tazama, wanawake hawa ndio waliosababisha watu wa Israeli, kwa kupitia ushauri wa Balaamu, kufanya dhambi dhidi ya BWANA huko Peori, wakati ile tauni iliposambaa kwa watu wa Mungu. ");
INSERT INTO swhulb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Sasa basi, ueni kila mwanaume kuanzia wadogo, na ueni kila mwanamke aliyelala na mwanamume. ");
INSERT INTO swhulb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Lakini chukueni wale mabinti wadogo ambao hawajalala na mwanamume. ");
INSERT INTO swhulb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Mtaweka kambi nje na kambi za Israeli kwa muda wa siku saba. Ninyi wote ambao mmeua watu au ambao mmegusa maiti yeyote mtajitakasa wenyewe katika siku ya tatu na katika siku ya saba - ninyi na mateka wenu. ");
INSERT INTO swhulb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Na mtayatakasa mavazi yenu yote, na kila kitu kilichotengenezwa kwa ngozi za wanyama, na manyoya ya mbuzi, na kila kitu kilichotengenezwa kwa mbao.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eliazarai kuahani akawaambia wale wanajeshi waliokuwa wameenda vitani, “Hii ni amri ya sheria ambayo BWANA alimpa Musa: ");
INSERT INTO swhulb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zile dhahabu, fedha, vyuma, bati, risasi, ");
INSERT INTO swhulb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na kila kitu knaweza kuhhimili moto, mtakiweka katka moto, navyo vitakuwa safi. Nakisha mtavitakasa vitu hivyo na maji ya farakano. Na vitu vyote ambavyo haviwezi kupita katika moto, mtavitakasa kwa maji hayo. ");
INSERT INTO swhulb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Na mtazifua nguao zenu katika siku ya saba, ndipo mtakapokuwa safi. Baada ya hapo mnaweza kurudi kwenye kambi za Israeli.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kisha BWANA akanena na Musa, akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Vihesabu vitu vyote vilivyochukuliwa nyara, wote watu na wanyama. Wewe, Eliazari kuhani, na viongozi wa watu kufuata koo ");
INSERT INTO swhulb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","watavigawa hivi vitu katika mkundi mawili. Mvigawe kwa wanajeshi walioenda kupigana na kwa watu wote. ");
INSERT INTO swhulb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kisha toza kodi ambayo itatolewa kwangu kutoka kwa wanajeshi waliokuwa wameenda vitani. Hii kodi itakuwa moja kati ya mia tano, katika watu, ng'ombe, punda, kondoo, au mbuzi. ");
INSERT INTO swhulb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Uichukue hii kodi kutoka katika nusu yao na umpe Eliazari kuhani kwa ajili ya sadaka itakayotolewa kwangu. ");
INSERT INTO swhulb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Pia kutoka katika nusu ya watu wa Israeli, utachukua moja kati ya hamsini -kutoka vitu, ng'ombe, punda, na mbuzi. Uvitoe hivi kwa Walawi wanaotumika katika masikani yangu.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Kwa hiyo Musa na Eliazari kuhani wakafanya kama BWANA alivyokuwa amemwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Sasa zile nyara zilizokuwa zimebaki ambazo wanajeshi walikuwa wameteka zilikuwa kondoo 675, 000, ");
INSERT INTO swhulb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","maksai elfu sabini na mbili, ");
INSERT INTO swhulb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","punda elfu sitini na moja, ");
INSERT INTO swhulb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na wanawake elfu thelathini na mbili ambao walikuwa hawajalala na mwanamume yeyote. ");
INSERT INTO swhulb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ile hesabu ya nusu iliyokuwa imetunzwa kwa ajili ya wanajeshi ilikuwa kondoo 337, 000. Ile sehemu ya ");
INSERT INTO swhulb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","BWANA ya kondoo ilikuwa kondoo 675. ");
INSERT INTO swhulb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Maksai walikuwa elfu thelathini na sita ambayo kodi ya BWANA ilikuwa sabini na mbili. ");
INSERT INTO swhulb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Punda walikuwa 30, 500 ambao sehemu ya BWANA ilikuwa sitini na moja. ");
INSERT INTO swhulb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Watu walikuwa wanawake elfu kumi na sita ambao kodi ya BWANA ilikuwa thelathini na mbili. ");
INSERT INTO swhulb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa aliichukua ile kodi ambayo ilitakiwa kuwekwa sadaka kwa BWANA. Akampatia Eliazari kuhani, kama BWANA alivyomwamuru Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ile nusu ya watu wa Israeli ambayo Musa alikuwa ameichukua toka kwa wanawjeshi waliokuwa wameenda vitani - ");
INSERT INTO swhulb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ile nusu y a watu ilikuwa kondoo 337, 500, ");
INSERT INTO swhulb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","maksai elfu thelathini na sita, ");
INSERT INTO swhulb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","punda 30, 500, ");
INSERT INTO swhulb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","na wanawake elfu kumi na sita. ");
INSERT INTO swhulb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kutoka kwenye nusu ya watu wa Israeli, Musa alichukua moja katika hamsini, wote watu na wanyama. Aliwapa Walawi ambao huitumikia masikani ya BWANA, kama BWANA alivyokuwa amemwamuru kufanya. ");
INSERT INTO swhulb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kisha wale maakida wa jeshi, makamanda wa elfu na makapteni wa mamia, wakaja kwa Musa. ");
INSERT INTO swhulb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Wakamwambia, “watumishi wako wamewahesabu wanajeshi ambao wako chini yetu, hakuna hata mmoja wao aliyekosa. ");
INSERT INTO swhulb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Tumemletea BWANA sadaka, ambayo kila mmoja amepata, vitu vya dhahabu, metali, timbi, pete za mhuri, vipini na vikuku, ili kujifanyia upatanisho kwa BWANA.” ");
INSERT INTO swhulb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa na Eliazari kuhani akapokea kutoka kwao dhahabu na vitu vyote vilivyotengenezwa kwa ufundi. ");
INSERT INTO swhulb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Vitu vyote vya sadaka ya dhahabu ambavyo walimpa BWANA- sadaka toka kwa makamanda wa maelfu na kutoka kwa makepteni wa mamia - vilikuwa na uzito wa shekeli 16, 750. ");
INSERT INTO swhulb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kila mwanajeshi alikuwa ameteka nyara ya kila mtu kwa ajili yake. ");
INSERT INTO swhulb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa na Eliazari kuhani wakazichukuazile dhahabu toka kwa makamanda wa maelfu na makepteni wa mamia. Wakavipeleka kwenye hema ya kukutania kama ukumbusho wa watu wa Israeli kwa BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Sasa wana wa uzao wa Reubeni na wa Gadi walikuwa na idadi kubwa ya wanyama. Waliiona ardhi ya Jazeri na Gileadi, kuwa ni ardhi nzuri kwa mifugo. ");
INSERT INTO swhulb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Kwa hiyo wana wa Gadi na wa Reubeni wakaja kumwambia Musa, na Eliazari kuhani, na viongozi wa watu. Wakasema, ");
INSERT INTO swhulb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Hii ndiyo orodha ya maeneo ambayo tumeyatembelea: Diboni, Jazeri, Nimraha, Heshibonni, Ellealehi, Sebamu, Nebo, na Beoni. ");
INSERT INTO swhulb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Haya ni maeneo ambayo BWANA aliyachukua mbele ya watu wa Israeli, na maeneo mazuri kwa ajili ya mifugo. Sisi watumishi wako tuna mifugo mingi sana. ");
INSERT INTO swhulb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Wakasema kuwa, “Kama tutapata kibali mbele ya macho yako, tunaomba ardhi hii tupewe, sisi watumishi wako, kuwa urithi. Usituvushe ng'ambo ya Yorodani.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa akawajibu wale wana wa auzao wa Gadi na Reubeni, “Je, mngependa ndugu zenu waende vitani wakati ninyi mkikaa hapa? ");
INSERT INTO swhulb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kwa nini kuwafish moyo watu wa Israeli wasivuke kwenda kwenye nchi ambayo BWANA amewapa? ");
INSERT INTO swhulb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Baba zenu walifanya hivyo nilipowatuma kutoka Kadeshi Banea kwenda kuipeleleza ile nchi. ");
INSERT INTO swhulb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Walienda mpaka kwenye bonde la Eskoli. Waliiona ile ardhi kisha wakawafisha moyo watu wa Israeli kwa hiyo wakagoma kuingia kwenye nchi ambayo BWANA alikuwa amewapa. ");
INSERT INTO swhulb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Siku hiyo hasira ya BWANA iliwaka. Akaapa akisema, ");
INSERT INTO swhulb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'Kwa hakika hakuna mtu aliyetoka Misri, kuanzia wa umri wa miaka ishirini na zaidi ambao wataiona nchi ambao niliwaapia Ibrahimu, Isaka, na Yakobo, kwa sababu hawakunifuata mimi kwa ukamilifu, isipokuwa Kalebu mwana wa Yefune Mkenizi, na Yoshua mwana wa Nuni. ");
INSERT INTO swhulb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ni Kalebu na Joshua tu ndio walionifuata kwa ukamilifu.' ");
INSERT INTO swhulb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Kwa hiyo hasira za BWANA ziliwaka juu ya Israei. Akawafanya wazunguke zunguke jangwani kwa miaka arobaini mpaka kile kizazi kilichofanya maovu mbele za macho yake kilipoteketea. ");
INSERT INTO swhulb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Tazama, mmetokea katika nafasi za baba zenu, kama watu wengine wenye dhambi zaidi, ili kuongeza hasira ya BWANA kwa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Kama hamtamfuata, ataiacha Israeli jangwani na mtakuwa mmewateketeza watu hawa wote. ");
INSERT INTO swhulb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Kwa hiyo wakaja karibu na Musa wakamwambia, “Turuhusu tujenga hapa uzio kwa ajili ya ng'ombe zetu na miji hapa kwa ajili ya familia zetu. ");
INSERT INTO swhulb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Hata hivyo, sisi wenyewe tutajipanga kijeshi kwenda na jeshi la Israeli mpaka tumewaongoza kupata maeneo yao. Lakini familia zetu zitakuwa kwenye miji ya maboma kwa ssbabu ya watu wengine ambao bado wanaishi katika nchi hii. ");
INSERT INTO swhulb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Hatutarudi kwenye familia zetu mpaka kila mmoja watu wa Israeli apate urithi wake. ");
INSERT INTO swhulb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Sisi hatutachukua urithi wa ardhi pamoja nao kule ng'ambo ya Yorodani, kwa sababu urithi wetu uko hapa upande wa mashariki mwa Yorodani.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kwa hiyo Musa akawajibu, “Kama mtafanya mnachokisema, kama mtajipanga wenyewe mbele za BWANA kwenda vitani, ");
INSERT INTO swhulb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","basi kila mmoja wa wanajeshi wenu lazima avuke Yorodani mbele za BWANA, mpaka atakapowafukuza maadui zake kutoka mbele zake ");
INSERT INTO swhulb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na nchi itawaliwe na Israeli mbele zake. Kisha mtaweza kurudi. Hamtakuwa na hatia mbele za BWANA na mbele ya Israeli. Hii nchi itakuwa miliki yenu mbele za BWANA. ");
INSERT INTO swhulb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Bali kama hamtafnya hivyo, tazama, mtakuwa mmefanya dhambi mbele ya BWANA. Mwe na hakika kuwa dhambi yenu itaonekana ");
INSERT INTO swhulb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","wazi. Jengeni miji kwa ajili ya familia zenu na mazizi kwa ajili ya kondoo zenu; kisha fanyeni kile mlichokisema.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Wale wana wa Gadi na Reubeni wakamwambia Musa, wakisema, “Watumishi wako wtafanya kama vile wewe, bwana wetu, unavyotuamuru. ");
INSERT INTO swhulb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Watoto wetu, wake zetu, makundi yetu, na wanyama wetu wote watakaa huko kwenye miji ya Gileadi. ");
INSERT INTO swhulb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Hata hivyo, sisi watumishi wako, tutavuka kwenda ng'ambo mbele za BWANA kupigana, kila mtu ambaye yuko tayari kwa vita, kama vile wewe, bwana wetu, unavyosema.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Kwa hiyo Musa akawapa maelekezo yayowahusu kwa Eliazari kuhani, kwa Joshua mwana wa Nuni, na kwa viongozi wa koo kufuata jamaa zao katika makabila ya wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa akawaambia, “Kama uzao wa Reubeni na Gadi watavuka ng'ambo ya Yorodani pamoja nanyi, kila mwanamume anayetakiwa kuwa vitani mbele za BWANA, na kama nchi mtaitawala mbele zenu, ndipo mtakapowapa eneo la Gileadi kuwa miliki yao. ");
INSERT INTO swhulb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lakini kama hawatavuka pamoja nanyi wakiwa na silaha zao, basi mtawapa urithi wao katika nchi ya Kanaani.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kwas hiyo wana wa uzao wa Gadi na wa Reubeni wakamjibu wakisema, Kama vile BWANA alivyosema nasi, sisi watumwa wako, hiki ndicho tutakachokifanya. ");
INSERT INTO swhulb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tutavuka tukiwa na silaha zetu mbele za BWANA kuingia katika nchi ya Kanaani, lakini urithi wetu utabaki utabaki upande huu wa Yorodani.” ");
INSERT INTO swhulb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Kwa hiyo uzao wa Gadi na Reubeni, na pia nusu ya kabila la Manase mwana wa Yusufu, Musa akawapa ufalme wa Sihoni, mfalme wa Waamori, na wa Ogi, mafalme wa Bashani, Aliwapa hiyo nchi, na kuwagawia miji yake yote pamoja na mipaka yake, miji yote ya nchi inayowazunguka. ");
INSERT INTO swhulb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Wale wa uzao wa Gadi wakaijenga Diboni, ");
INSERT INTO swhulb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarothi, Aroeri, Atrothi, Jazeri, Jogbehaha, Bethi Nimraha, ");
INSERT INTO swhulb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","na Bethi Harani kuwa miji iliyo na maboma na mazizi ya kondoo wao. ");
INSERT INTO swhulb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Wale wa uzao wa Reubeni wakaijenga Heshiboni. Elealehi, Kiriathaimu, ");
INSERT INTO swhulb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baali Meoni - baadaye waliyabadili majina yao, na Sibimaha. ");
INSERT INTO swhulb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Wale wa uzao wa Machiri mwana wa Manase walienda Gileadi na kuutwaa kutoka kwa Waamori waliokuwa wakiishi humo. ");
INSERT INTO swhulb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Kisha Musa akaitoa Gileadi kwa Machiri mwana wa Manase, na watu wake wakaishi humo. ");
INSERT INTO swhulb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jairi mwana wa Manase alienda kuiteka miji yake na kuiita Havothi Jairi. ");
INSERT INTO swhulb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobaha alienda kuitieka Kenathi na vijiji vyake, na akauita kwa jina lake Nobaha. ");
INSERT INTO swhulb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hizi ndizo safari za wana wa Israeli hapo walipotoka katika nchi ya Misri pamoja na makundi yao ya kijeshi chini ya uongozi wa Musa na Haruni. ");
INSERT INTO swhulb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musa aliandika maeneo yote tangu walipoondoka mpaka walipofika, kama alivyoamuriwa na BWANA. Hizi ndizo safari zao kama kutoka kwao kulivyokuwa kwa kila walipotoka. ");
INSERT INTO swhulb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Mwezi wa kwanza walisafiri kutoka Ramesi, waliondoka siku ya kumi na tano. Asubuhi siku iliyofuata baada ya Pasaka, Wana wa Israeli waliondoka wazi wazi, mbele ya machoya Wamisri wote. ");
INSERT INTO swhulb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Hii ilitokea wakati Wamisiri walipokuwa wakizika wazaliwa wao wa kwanza, ambao BWANA alikuwa amewaua miongoni mwao, kwa kuwa pia alikuwa ameiadhibu miungu yao. ");
INSERT INTO swhulb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Wana wa Israeli walisafiri kutoka Ramesi na kuweka kambi ");
INSERT INTO swhulb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukothi. Walisafiri toka Sukothi na kuweka kambi Ethamu, mwisho wa nyika. ");
INSERT INTO swhulb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wakasafiri kutoka Ethamu wakarudi mpaka Pi-Hahirothi, ambayo inaikabili Baali Zephoni, ambapo waliweka kambi kuikabili Migidoli ");
INSERT INTO swhulb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Kisha wakasafiri toka mkabala wa Pi-Hairothi na kupita katikati ya bahari kuelekea nyikani. Wakasafiri safari ya siku tatu katika nyika ya Ethamu na kuweka kambi Mara. ");
INSERT INTO swhulb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wakasafiri kutoka Mara kufika Elimu. Pale Elimu kulikuwa na chemichemi kumi na mbili za maji na miti sabini ya mitende. hapo ndipo walipoweka kambi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Walisafiri kutoka Elimu na kuweka kambi karibu na Bahari ya Shamu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Walisafiri kutoka Bahari ya Shamu na kuweka kambi katika nyika ya Sini. ");
INSERT INTO swhulb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Walisafiri kutoka nyika ya Sini na kuweka kambi Dofka. ");
INSERT INTO swhulb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wakasafiri kutoka Dofka na kuweka kambi Alushi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wakasafiri kutoka Alushi na kuweka kambi Refidimu, ambapo watu walikosa maji ya kunywa. ");
INSERT INTO swhulb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Walisafiri kutoka Refidimu na kuweka kambi kwenye nyika ya Sinai. ");
INSERT INTO swhulb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Walisafiri kutoka nyika ya Sinai na kuweka kambi Kibrothi Hataava. ");
INSERT INTO swhulb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Walisafiri kutoka Kibrothi Hataava na kuweka kambi Hazerothi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Walisafiri kutoka Hazerothi na kuweka kambi Rithima. ");
INSERT INTO swhulb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Walisafiri kutoka Rithima na kuweka kambi Rimoni Perezi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Walisafiri kutoka Rimoni Perezi na kuweka kambi Libna. ");
INSERT INTO swhulb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Walisafiri kutoka Libna na kuweka kambi Risa. ");
INSERT INTO swhulb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Walisafiri kutoka Risa na kuweka kambi Kehelatha. ");
INSERT INTO swhulb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Walisafiri kutoka Kehelatha na kuweka kambi kwenye Mlima Sheferi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Walisafiri kutoka Mlima Sheferi na kuweka kambi Harada. ");
INSERT INTO swhulb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Walisafiri kutoka Harada na kuweka kambi Makelothi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Walisafiri kutoka Makelothi na kuweka kambi Tahathi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Walisafiri kutoka Ttahalathi na kuweka kambi Tera. ");
INSERT INTO swhulb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Walisafiri kutokaTera na kuweka kambi Mithika. ");
INSERT INTO swhulb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Walisafiri kutoka Mithika na kuweka kambi Hashimona. ");
INSERT INTO swhulb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Walisafiri kutoka Hashimona na kuweka kambi Moserothi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Walisafiri kutoka Moserothi na kuweka kambi Bene Jaakani. ");
INSERT INTO swhulb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Walisafiri kutoka Bene Jaakani na kuweka kambi Hori Hagidigadi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Walisafiri kutoka Hori Hagidigadi na kuweka kambi Jotibatha. ");
INSERT INTO swhulb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Walisafiri kutoka Jotibatha na kuweka kambi Abrona. ");
INSERT INTO swhulb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Walisafiri kutoka Abrona na kuweka kambi Ezioni Geberi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Walisafiri toka Ezioini Geberi na kuweka kambi katika nyika ya Sini kule Kadeshi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Walisafiri kutoka Kadeshi na kuweka kambi Mlima Hori, Pembezoni mwa nchi ya Edomu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Hapo ndipo Haruni kuhani alipoenda kwenye Mlima Hori kwa amri ya BWANA na kufa kule mwaka wa arobaini bada ya Wisraeli kutoka katika nchi ya Misri, katika siku ya kwanza ya mwezi wa tano. ");
INSERT INTO swhulb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruni alikuwa na umri wa mika 123 alipokufa pale juu ya Mlima Hori. ");
INSERT INTO swhulb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Wakanaani, mfalme wa Aradi, ambao waliishi kusini mwa nyika katika nchi ya Kanaani, walisikia juu ya ujio wa wana wa Israeli. ");
INSERT INTO swhulb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Walisafiri kutika Mlima Hori n a kuweka kambi Zalimona. ");
INSERT INTO swhulb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Walisafiri kutoka Zalimona na kuweka kambi Punoni. ");
INSERT INTO swhulb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Walisafiri kutoka Punoni na kuweka kambi Obothi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Walisafiri kutoka Obothi na kuweka kambi Abarimu, katika mpaka wa Moabu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Walisafiri kutoka Abarimu na kuweka kambi Diboni Gadi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Walisafiri kutoka Diboni Gadi na kuweka kambi Alimoni Diblathaimu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Walisafiri kutoka Alimoni Diblathaimu na kuweka kambi kwenye milima ya Abarimu mkabala na Nebo. ");
INSERT INTO swhulb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Walisafiri kutoka mlima wa Abarimuna kuweka kambi kwenye nyanda za Moabu karibu na Yorodani huko Yeriko. ");
INSERT INTO swhulb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Waliweka kambi karibu na Yorodani, kutoka Bethi Jeshimothi mpaka Abeli Shitimu katika nyanda za Moabu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Hapo BWANA alinenana Musa katika nyanda za Moabu karibu na Yorodani kule Yeriko akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Nena na wana wa Israeli uwaambie. 'Mtakapovuka mto Yorodani kuingia Kanaani, ");
INSERT INTO swhulb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ndipo mtakapowafukuza wenyeji wote mbele yenu. Mtaziharibu sanamu zote za kuchongwa. Mtaziharibu sanamu zao za kusubu na kuharibu mahali pao pote palipoinuka. ");
INSERT INTO swhulb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mtachukua hiyo ardhi iwe mali yenu na muishi ndani yake, kwa sababu nimewapeni hiyo nchi iwe mali yenu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mtairithi hiyo nchi kwa kupiga kura, kwa kufuata kila ukoo. Kwa zile koo kubwa kubwa mtawapa sehemu kubwa ya ardhi, na kwa zile koo ndogo ndogo mtawapa sehemu ndogo ya ardhi. Kura itakapoanguka kwenye kila ukoo, hiyo ardhi itakuwa mali yake. Mtairithi ardhi kufuata ukoo wa kabilla la jamaa zenu. ");
INSERT INTO swhulb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Lakini kama hamtawafukuza wenyeji wa nchi hiyo watoke mbele yenu, ndipo wale watu mtakaowaruhusu wakae nanyi watakapokuwa kama sindano machoni mwenu na miiba katika mbavu zenu. Watayafanya maisha yenu yawe magumu katika nchi mnayoishi. ");
INSERT INTO swhulb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ndipo itakapotokea kuwa kile ambacho Mimi ninakusudia kufanya kwa wale watu, Nitawafanyia pia ninyi'” ");
INSERT INTO swhulb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","BWANA akanena na Musa akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Waamuru watu wa Israeli na uwaambie, 'Mtakapoingia katika nchi ya Kanaani, nchi ambayo itakuwa mali yenu, nchi ya Kanaani na mipaka yake, mpaka wenu wa kusini utaendelea kutoka nyika ya Sini hadi mpaka wa Edomu. ");
INSERT INTO swhulb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Mwisho wa mpaka wa kusini utakuwa mwisho wa bahari ya chumvi kuelekea mashariki. ");
INSERT INTO swhulb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Mpaka wenu utageukia kusini kutoka mlima kuelekea Akrabimu na kupitia nyika ya Sini. na kutokea huko utaelelkea kusini mwa Kadeshi Barinea na kuelekea Hazari Adari mpaka Azimoni. ");
INSERT INTO swhulb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Kutoka huko, mpaka utageuka kutoka Azimoni kuelekea kijito cha Misri na kukifuata mpaka baharini. ");
INSERT INTO swhulb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Mpaka wa Magharibi utakuwa pwani ya bahari kuu. Huu ndio utakuwa mpaka wenuwa Magharibi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Mpaka wenu wa kaskazini utaanzia kwenye bahari kuu hadi Mlima Hori, ");
INSERT INTO swhulb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","kisha kutoka Mlima Hori hadi Lebo Hamathi, kisha Zedadi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Mpaka utaendelea hadi Zifroni na kuishia Hazari Enani. Huu ndio utakuwa mpaka wenu wa kaskazini. ");
INSERT INTO swhulb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Kisha mtaweka alama za mpaka wenu wa mashariki ambao utaanzia Hazari Enani kuelekea kusini Shefamu. ");
INSERT INTO swhulb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Kisha mpaka wa kusini utaendelea kutoka Shefamu hadi Ribla, upande wa masharikia mwa Aini. Mpaka utaedelea upande huo wa mashariki hadi upande wa mashariki wa bahari ya Kinerethi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Kisha mpaka utaendelea kuelekea kusini hadi mto Yorodani na hadi bahari ya chumvi. Hii ndiyo itakuwa nchi yenu, kwa kuifuata mipaka yake yote inayozunguka.'” ");
INSERT INTO swhulb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Kisha Musa akawaamuru watu wa Israeli akasema, “Hii ndiyo nchi ambayo mtaipokes kwa kura, ambayo BWANA ameamuru kuwapa wale makabila tisa na nusu. ");
INSERT INTO swhulb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Kabila ya uzao wa Reubeni, kwa kufuata jinsi walivyopewa urithi kwa jamaa ya kabila yao, na uzao wa kabila la Gadi, kwa kufuata jinsi walivyopewa urithi kwa jamaa ya kabila yao, na nusu ya Manase wamepata ardhi yao. ");
INSERT INTO swhulb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Wale makabila mawili na nusu wameshapata mgawo wao ng'ambo ya mto Yorodani upande wa mashariki, kuelekea kule linakotokea jua.” ");
INSERT INTO swhulb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","BWANA akanena na Musa akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Haya ndiyo majinaya watu watakaoigawa ardhi kwa ajili ya urithi wao: Eliazari kuhani na Joshua mwana wa Nuni. ");
INSERT INTO swhulb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Mtachagua kiongozi mmoja toka kila kabila ili kuigawa ardhi kwa koo zao. ");
INSERT INTO swhulb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Haya ndiyo majina ya wanaume: Kutoka kabila la Yuda, Kalebu mwana wa Yefune. ");
INSERT INTO swhulb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kutoka kwenye kabila la uzao wa Simeoni, Shemueli mwana wa Amihudi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kutoka kabila la Benjamini, Elidadi mwana wa Kisloni. ");
INSERT INTO swhulb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Kiongozi kutoka kabila la uzao wa Dani, Buki mwana wa Jogili. ");
INSERT INTO swhulb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Kiongozi kutoka uzao wa Yusufu, kwenye kabila la Manase, Hannieli mwana wa Efodi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kiongozi kutoka kwenye kabila la uzao wa Efraimu, Kemueli mwana wa Shiftani. ");
INSERT INTO swhulb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Kiongozi kutoka kabila la uzao wa Zabuloni, Elizafani mwana wa Parinaki. ");
INSERT INTO swhulb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Kiongozi kutoka kwenye kabila la uzao wa Isakari, Palitieli mwana wa Azzani. ");
INSERT INTO swhulb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Kiongozi kutoka kabila la uzao wa Asheri, Ahihudi mwana wa Shelomi. ");
INSERT INTO swhulb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Kiongozi kutoka kabila la uzao wa Naftali, Pedaheli mwana wa Amihudi.” ");
INSERT INTO swhulb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","BWANA aliwaamuru wanaume hawa kuigawa nchi ya Kanaani na kuwapa kila kabla sehemu yao. ");
INSERT INTO swhulb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","BWANA akanena na Musa kwenye nyanda za Moabu karibu na Yorodani kule Yeriko akasema, ");
INSERT INTO swhulb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Waamuru watu wa Israeli kutoa sehemu ya urithi wa ardhi yao kwa Walawi. Watawapa miji ya kuishi ndani yake na eneo la malisho kuzunguka miji hiyo. ");
INSERT INTO swhulb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Walawi watakuwa na miji hiyo ya kuishi. Eneo la malisho litakuwa kwa ajili ya ng'ombe zao, kondoo zao, na wanyama wao wote. ");
INSERT INTO swhulb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Hayo malisho yatakayozunguka miji hiyo ambayo mtawapa Walawi yataanzia kwenye maboma kwa ukubwa wa “mita 457” kila upande. ");
INSERT INTO swhulb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Utapima dhiraa elfu mbili kutoka nje ya mji kuelekea mashariki, na dhiraa elfu mbili kuelekea kusini, na dhiraa elfu mbili kuelekea upande wa magharibi, na dhiraa elfu mbilii kuelekea upandewa kaskazini. Haya yatakuwa maeneo ya malisho yao. Miji itakuwa katikati. ");
INSERT INTO swhulb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Katika hiyo miji sita mtakayowapatia Walawi itatumika kama miji ya ukimbizi. Mtatoa maeneo haya ili kama mtu ameua mtu apate mahali pa kukimbilia. Pia mtatoa miji mingine arobaini na mbli. ");
INSERT INTO swhulb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Jumla ya miji ambyo mtawapa Walawi itakuwa arobaini na nane. Mtawapa hiyo miji pamoja na maeneo yao ya malisho. ");
INSERT INTO swhulb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Zile kabila kubwa za watu wa Israeli, kabila ambalo lina ardhi zaidi, watatoa ardhi zaidi. Makabila madogo madogo watatoa miji michache. Kila kabila lazima watoe kwa ajili ya Walawi kwa kufuata mgawo waliopata.” ");
INSERT INTO swhulb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Kisha BWANA akanena na Musa akamwambia, ");
INSERT INTO swhulb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Sema na wana wa Israeli na uwaambie, 'Mtakapovuka Yorodani kuingia Kanaani, ");
INSERT INTO swhulb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Kisha mchague miji itakayotumika kama miji ya ukimbizi kwa, ajili yenu, mahali ambapo mtu aliyeua mtu pasipo kukusudia anaweza kukimbilia. ");
INSERT INTO swhulb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Hii miji itakuwa kwenu miji ya ukimbizi kwa mtu anayetaka kulipa kisasi. ili kwamba mtuhumiwa asije akauawa bila kwanza kusikilizwa na jamii. ");
INSERT INTO swhulb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Mtachagua miji sita kuwa miji ya ukimbizi. ");
INSERT INTO swhulb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mtatoa miji mitatu kule ng'ambo ya Yorodani na miji mitatu huko Kanaani. Itakuwa miji ya ukimbizi. ");
INSERT INTO swhulb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Kwa ajili ya watu wa Israeli, wageni, kwa, yeyote anayeishi kati yenu, hii miji sita itatumika kama miji ya ukimbizi kwa mtu yeyote atakayeua mtu bila kukusudia anaweza kukimbila. ");
INSERT INTO swhulb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Lakini kama mtuhumiwa amempiga mtu na chombo cha chuma, na huyo mtu akafa, basi kwa hakika yule mtuhumiwa ni muuaji. Kwa hiyo anatakiwa kuuawa. ");
INSERT INTO swhulb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kama yule mtuhumiwa amempiga mtu kwa jiwe mkonono mwake ambalo linaweza kumwua mtu, na kama yule mtu atakufa, basi hakika huyo mtuhumiwa ni mwuaji. Kwa hakika anatakiwa kuuawa. ");
INSERT INTO swhulb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ka