﻿USE sofia;
DROP TABLE IF EXISTS sofia.swhonmm_vpl;
CREATE TABLE swhonmm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swhonmm_vpl WRITE;
INSERT INTO swhonmm_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hapo mwanzo Mungu aliumba mbingu na dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Wakati huu dunia ilikuwa haina umbo, tena ilikuwa tupu. Giza lilikuwa juu ya vilindi vya maji, naye Roho wa Mungu alikuwa ametulia juu ya maji. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mungu akasema, “Iwepo nuru,” nayo nuru ikawepo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mungu akaona ya kuwa nuru ni njema; ndipo Mungu akatenganisha nuru na giza. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mungu akaiita nuru “mchana”, na giza akaliita “usiku”. Ikawa jioni, ikawa asubuhi, siku ya kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mungu akasema, “Iwepo nafasi kati ya maji, igawe maji na maji.” ");
INSERT INTO swhonmm_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kwa hiyo Mungu akafanya nafasi, akatenganisha maji yaliyo chini ya hiyo nafasi na maji yaliyo juu yake. Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mungu akaiita hiyo nafasi “anga”. Ikawa jioni, ikawa asubuhi, siku ya pili. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mungu akasema, “Maji yaliyopo chini ya anga na yakusanyike mahali pamoja, pawepo na nchi kavu.” Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mungu akaiita nchi kavu “ardhi”, nalo lile kusanyiko la maji akaliita “bahari.” Mungu akaona kuwa ni vyema. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kisha Mungu akasema, “Ardhi na itoe mimea: miche itoayo mbegu, miti juu ya nchi itoayo matunda yenye mbegu ndani yake, kila mmea kulingana na aina zake mbalimbali.” Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ardhi ikachipua mimea: Mimea itoayo mbegu kulingana na aina zake, na miti itoayo matunda yenye mbegu kulingana na aina zake. Mungu akaona ya kuwa hili ni jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ikawa jioni, ikawa asubuhi, siku ya tatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mungu akasema, “Iwepo mianga kwenye nafasi ya anga ili itenganishe usiku na mchana, nayo iwe alama ya kutambulisha majira mbalimbali, siku na miaka, ");
INSERT INTO swhonmm_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","nayo iwe mianga kwenye nafasi ya anga ya kutia nuru juu ya dunia.” Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mungu akafanya mianga miwili mikubwa: mwanga mkubwa utawale mchana, na mwanga mdogo utawale usiku. Pia Mungu akafanya nyota. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mungu akaiweka hiyo mianga katika nafasi ya anga iangaze dunia, ");
INSERT INTO swhonmm_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","itawale usiku na mchana, na ikatenganishe nuru na giza. Mungu akaona kuwa hili ni jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ikawa jioni, ikawa asubuhi, siku ya nne. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mungu akasema, “Kuwepo na viumbe hai tele kwenye maji, nao ndege waruke juu ya dunia katika nafasi ya anga.” ");
INSERT INTO swhonmm_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kwa hiyo Mungu akaumba wanyama wakubwa wa baharini na kila kiumbe hai kiendacho majini kulingana na aina zake, na kila ndege mwenye mabawa kulingana na aina yake. Mungu akaona kuwa hili ni jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mungu akavibariki, akasema, “Zaeni mwongezeke, mkayajaze maji ya bahari, nao ndege waongezeke katika dunia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ikawa jioni, ikawa asubuhi, siku ya tano. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mungu akasema, “Ardhi na itoe viumbe hai kulingana na aina zake: mifugo, viumbe vinavyotambaa ardhini na wanyama pori, kila kiumbe kulingana na aina yake.” Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mungu akafanya wanyama pori kulingana na aina zake, mifugo kulingana na aina zake, na viumbe vyote vinavyotambaa ardhini kulingana na aina zake. Mungu akaona kuwa hili ni jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ndipo Mungu akasema, “Tufanye mtu kwa mfano wetu, kwa sura yetu, wakatawale samaki wa baharini na ndege wa angani, na mifugo na wanyama pori wote, na dunia yote, na viumbe vyote vinavyotambaa ardhini.” ");
INSERT INTO swhonmm_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kwa hiyo Mungu akamuumba mtu kwa mfano wake mwenyewe, kwa mfano wa Mungu alimuumba; mwanaume na mwanamke aliwaumba. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mungu akawabariki na akawaambia, “Zaeni na mkaongezeke, mkaijaze dunia na kuitiisha. Mkatawale samaki wa baharini, ndege wa angani, na kila kiumbe hai kiendacho juu ya ardhi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kisha Mungu akasema, “Nimewapa kila mche utoao mbegu juu ya uso wa dunia yote, na kila mti wenye matunda yenye mbegu ndani yake. Vitakuwa chakula chenu. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Nao wanyama wote wa nchi, ndege wote wa angani, na viumbe vyote viendavyo juu ya ardhi: yaani kila kiumbe chenye pumzi ya uhai, ninawapa kila mche wa kijani kuwa chakula.” Ikawa hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mungu akaona vyote alivyoumba, na tazama, vilikuwa vizuri sana. Ikawa jioni, ikawa asubuhi, siku ya sita. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kwa hiyo mbingu na dunia zikakamilika, pamoja na vyote vilivyomo. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kufikia siku ya saba Mungu alikuwa amekamilisha kazi aliyokuwa akiifanya; hivyo siku hiyo ya saba akapumzika kutoka kazi zake zote. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mungu akaibariki siku ya saba, akaifanya takatifu, kwa sababu katika siku hiyo alipumzika baada ya kazi zote za kuumba alizokuwa amefanya. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Haya ndio maelezo ya mbingu na dunia wakati zilipoumbwa. Bwana Mwenyezi Mungu alipoziumba mbingu na dunia, ");
INSERT INTO swhonmm_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hapakuwa na mche wa shambani uliokuwa umejitokeza ardhini, wala hapakuwa na mmea wa shamba uliokuwa umeota, kwa kuwa Bwana Mwenyezi Mungu alikuwa hajanyeshea mvua juu ya nchi, na hapakuwa na mtu wa kuilima ardhi, ");
INSERT INTO swhonmm_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","lakini umande ulitokeza kutoka ardhini na kunyesha uso wote wa nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bwana Mwenyezi Mungu alimuumba mtu kutoka mavumbi ya ardhi, akampulizia pumzi ya uhai puani mwake, naye mtu akawa kiumbe hai. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Basi Bwana Mwenyezi Mungu alikuwa ameotesha bustani upande wa mashariki, katika Edeni; huko akamweka huyo mtu aliyemuumba. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Bwana Mwenyezi Mungu akafanya aina zote za miti ziote kutoka ardhini, miti yenye kupendeza macho na mizuri kwa chakula. Mti wa uzima ulikuwa katikati ya bustani, na pia mti wa kujua mema na mabaya. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mto wa kunyeshea bustani ulitiririka toka Edeni; kuanzia hapo ukagawanyika kuwa mito minne. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mto wa kwanza uliitwa Pishoni, nao huzunguka nchi yote ya Havila ambako kuna dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Dhahabu ya nchi hiyo ni nzuri; bedola na vito shohamu pia hupatikana huko.) ");
INSERT INTO swhonmm_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Jina la mto wa pili ni Gihoni, ambao huzunguka nchi yote ya Kushi. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Jina la mto wa tatu ni Tigrisi, unaopita mashariki mwa Ashuru. Mto wa nne ni Frati. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bwana Mwenyezi Mungu akamchukua huyo mtu, akamweka kwenye Bustani ya Edeni ailime na kuitunza. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Bwana Mwenyezi Mungu akamwagiza huyo mtu, akamwambia, “Uko huru kula matunda ya mti wowote katika bustani; ");
INSERT INTO swhonmm_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","lakini kamwe usile matunda ya mti wa kujua mema na mabaya, kwa maana siku utakapokula matunda yake, hakika utakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bwana Mwenyezi Mungu akasema, “Si vyema huyu mtu awe peke yake. Nitamfanyia msaidizi wa kumfaa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Basi Bwana Mwenyezi Mungu alikuwa ametengeneza kutoka ardhi wanyama pori wote, na ndege wote wa angani. Akawaleta kwa huyu mtu aone atawaitaje, nalo jina lolote alilokiita kila kiumbe hai, likawa jina lake. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hivyo Adamu akawapa majina mifugo wote, ndege wa angani, na wanyama pori wote. Lakini kwa Adamu hakupatikana msaidizi wa kumfaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hivyo Bwana Mwenyezi Mungu akamfanya Adamu kulala usingizi mzito, naye alipokuwa amelala akachukua moja ya mbavu zake, akapafunika mahali pale kwa nyama. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kisha Bwana Mwenyezi Mungu akamfanya mwanamke kutoka kwa ule ubavu alioutoa kwa mwanaume, akamleta huyo mwanamke kwa mwanaume. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Huyo mwanaume akasema, “Huyu sasa ni mfupa wa mifupa yangu, na nyama ya nyama yangu, ataitwa ‘mwanamke’, kwa kuwa alitolewa katika mwanaume.” ");
INSERT INTO swhonmm_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kwa sababu hii mwanaume atamwacha baba yake na mama yake, na kuambatana na mkewe, nao watakuwa mwili mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adamu na mkewe wote walikuwa uchi, wala hawakuona aibu. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Basi nyoka alikuwa mjanja kuliko wanyama pori wote ambao Bwana Mwenyezi Mungu aliwafanya. Nyoka akamwambia mwanamke, “Ati Mungu alisema, ‘Kamwe msile matunda ya mti wowote wa bustanini’?” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mwanamke akamjibu nyoka, “Tunaweza kula matunda ya miti iliyo katika bustani, ");
INSERT INTO swhonmm_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","lakini Mungu alisema, ‘Kamwe msile tunda la mti ulio katikati ya bustani, wala kuugusa, la sivyo mtakufa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lakini nyoka akamwambia mwanamke, “Hakika hamtakufa. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kwa maana Mungu anajua kwamba mtakapokula tunda hilo, macho yenu yatafumbuliwa, nanyi mtakuwa kama Mungu, mkijua mema na mabaya.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mwanamke alipotambua kwamba tunda la mti huo lilikuwa zuri kwa chakula na la kupendeza macho, tena linatamanika kwa kujipatia hekima, basi akachuma matunda yake, akala. Pia akampa mumewe, aliyekuwa pamoja naye, akala. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ndipo macho yao wote wawili yakafumbuliwa, wakajiona kwamba walikuwa uchi; hivyo wakashona majani ya mtini, wakajifunika. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Yule mwanaume na mkewe waliposikia sauti ya Bwana Mwenyezi Mungu akitembea bustanini jioni, wakajificha kutoka kwa Bwana Mwenyezi Mungu katikati ya miti ya bustani. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Lakini Bwana Mwenyezi Mungu akamwita Adamu, “Uko wapi?” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Naye akajibu, “Nilikusikia katika bustani nikaogopa kwa sababu nilikuwa uchi, hivyo nikajificha.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mungu akamuuliza, “Ni nani aliyekuambia ya kuwa ulikuwa uchi? Je, umekula matunda ya mti niliokuamuru usile?” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adamu akasema, “Huyu mwanamke uliyenipa awe pamoja nami alinipa matunda ya huo mti, nami nikala.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ndipo Bwana Mwenyezi Mungu akamuuliza mwanamke, “Umefanya jambo gani?” Mwanamke akajibu, “Nyoka alinidanganya, nami nikala.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hivyo Bwana Mwenyezi Mungu akamwambia nyoka, “Kwa kuwa umefanya hili, “Umelaaniwa kuliko mifugo wote na wanyama pori wote! Utatambaa kwa tumbo lako na kula mavumbi siku zote za maisha yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nami nitaweka uadui kati yako na huyu mwanamke, na kati ya uzao wako na wake; yeye atakuponda kichwa, nawe utamuuma kisigino.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kwa mwanamke akasema, “Nitakuzidishia sana uchungu wakati wa kuzaa kwako; kwa uchungu utazaa watoto. Tamaa yako itakuwa kwa mumeo, naye atakutawala.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Akamwambia Adamu, “Kwa sababu umemsikiliza mke wako na ukala kutoka mti niliokuamuru, ‘Msile tunda lake,’ “Ardhi imelaaniwa kwa sababu yako; kwa kazi ngumu utakula chakula kitokacho humo siku zote za maisha yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Itakuzalia miiba na mibaruti, nawe utakula mimea ya shambani. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kwa jasho la uso wako utakula chakula chako hadi utakaporudi ardhini, kwa kuwa ulitwaliwa kutoka humo; wewe u mavumbi na mavumbini utarudi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu akamwita mkewe jina Hawa, kwa kuwa atakuwa mama wa wote walio hai. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bwana Mwenyezi Mungu akawatengenezea Adamu na mkewe mavazi ya ngozi, akawavika. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kisha Bwana Mwenyezi Mungu akasema, “Sasa mtu huyu amekuwa kama mmoja wetu, kwa kujua mema na mabaya. Sharti asiruhusiwe kunyoosha mkono wake na kuchuma pia kutoka mti wa uzima akala, naye akaishi milele.” ");
INSERT INTO swhonmm_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hivyo Bwana Mwenyezi Mungu akamfukuzia mbali kutoka Bustani ya Edeni, akalime ardhi ambamo alitolewa. ");
INSERT INTO swhonmm_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Baada ya kumfukuzia mbali Adamu, Mungu akaweka makerubi mashariki mwa Bustani ya Edeni, pamoja na upanga wa moto ukimulika kila upande kulinda njia ya kuuendea mti wa uzima. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu akakutana kimwili na mkewe Hawa, naye akapata mimba, akamzaa Kaini. Hawa akasema, “Kwa msaada wa Mwenyezi Mungu nimemzaa mtoto wa kiume.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Baadaye akamzaa Habili ndugu yake. Basi Habili akawa mfugaji, na Kaini akawa mkulima. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Baada ya muda, Kaini akaleta baadhi ya mazao ya shamba ikiwa sadaka kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Lakini Habili akaleta fungu nono kutoka baadhi ya wazaliwa wa kwanza wa mifugo yake. Mwenyezi Mungu akamkubali Habili pamoja na sadaka yake, ");
INSERT INTO swhonmm_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","lakini Mungu hakumkubali Kaini pamoja na sadaka yake. Kwa hiyo Kaini akakasirika sana, uso wake ukawa na huzuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kisha Mwenyezi Mungu akamwambia Kaini, “Kwa nini umekasirika? Kwa nini uso wako una huzuni? ");
INSERT INTO swhonmm_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ukifanya lililo sawa, je, hutakubalika? Lakini usipofanya lililo sawa, dhambi inakuvizia mlangoni mwako, ikikutamani wewe, lakini inakupasa uishinde.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Basi Kaini akamwambia ndugu yake Habili, “Twende shambani.” Walipokuwa shambani, Kaini akamshambulia Habili ndugu yake, akamuua. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kisha Mwenyezi Mungu akamuuliza Kaini, “Ndugu yako Habili yuko wapi?” Akamjibu, “Sijui. Je, mimi ni mlinzi wa ndugu yangu?” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mwenyezi Mungu akasema, “Umefanya nini? Sikiliza! Damu ya ndugu yako inanililia mimi kutoka ardhini. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sasa umelaaniwa na umehamishwa kutoka ardhi, ambayo imefungua kinywa chake na kupokea damu ya ndugu yako kutoka mkononi mwako. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Utakapoilima ardhi, haitakupa tena mazao yake. Utakuwa mtu wa kutangatanga duniani bila utulivu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini akamwambia Mwenyezi Mungu, “Adhabu yangu ni zaidi ya ninavyoweza kustahimili. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Leo unanifukuza kutoka nchi, nami nitafichwa mbali na uwepo wako. Nitakuwa mtu wa kutangatanga duniani bila utulivu, na yeyote anionaye ataniua.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lakini Mwenyezi Mungu akamwambia, “La, sivyo! Ikiwa mtu yeyote atamuua Kaini, atalipizwa kisasi mara saba.” Kisha Mwenyezi Mungu akamwekea Kaini alama ili yeyote angemwona asimuue. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kwa hiyo Kaini akaondoka mbele za Mwenyezi Mungu, akaenda kuishi katika nchi ya Nodi, mashariki mwa Edeni. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini akakutana kimwili na mkewe, naye akapata mimba na akamzaa Idrisi. Wakati huo Kaini alikuwa anajenga mji, akauita Idrisi, jina la mtoto wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Idrisi akamzaa Iradi; Iradi akamzaa Mehuyaeli; Mehuyaeli akamzaa Methushaeli; naye Methushaeli akamzaa Lameki. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki alioa wanawake wawili: mmoja aliitwa Ada, na mwingine Sila. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada akamzaa Yabali; huyu akawa baba wa wale wanaoishi katika mahema na kufuga wanyama. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kaka yake aliitwa Yubali, aliyekuwa baba wa wote wapigao zeze na filimbi. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Pia Sila alikuwa na mtoto wa kiume aliyeitwa Tubali-Kaini, ambaye alifua vifaa vya aina mbalimbali vya shaba na chuma. Naama alikuwa dada wa Tubali-Kaini. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki akawaambia wake zake, “Ada na Sila, nisikilizeni mimi; wake wa Lameki sikieni maneno yangu. Nimemuua mtu kwa kunijeruhi, kijana mdogo kwa kuniumiza. ");
INSERT INTO swhonmm_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kama Kaini atalipizwa kisasi mara saba, basi Lameki itakuwa mara sabini na saba.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu akakutana kimwili na mke wake tena, akamzaa mwana, akamwita jina Sethi, akisema, “Mungu amenijalia mwana mwingine badala ya Habili, kwa kuwa Kaini alimuua.” ");
INSERT INTO swhonmm_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Naye Sethi akamzaa mwana, akamwita jina Enoshi. Wakati huo watu wakaanza kuliitia jina la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hii ni orodha iliyoandikwa ya vizazi vya Adamu. Mungu alipomuumba mwanadamu, alimfanya kwa sura ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Aliwaumba mwanaume na mwanamke, akawabariki. Walipokwisha kuumbwa, akawaita “Binadamu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu alipokuwa ameishi miaka mia moja na thelathini, alimzaa mwana aliyekuwa na sura yake, mwenye kufanana naye. Akamwita jina Sethi. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Baada ya Sethi kuzaliwa, Adamu aliishi miaka mia nane, akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu aliishi jumla ya miaka mia tisa na thelathini, ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sethi alipokuwa ameishi miaka mia moja na tano, akamzaa Enoshi. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Baada ya kumzaa Enoshi, Sethi aliishi miaka mia nane na saba (807), akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sethi aliishi jumla ya miaka mia tisa na kumi na mbili (912), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi alipokuwa ameishi miaka tisini, akamzaa Kenani. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Baada ya kumzaa Kenani, Enoshi aliishi miaka mia nane na kumi na tano (815), naye alikuwa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi aliishi jumla ya miaka mia tisa na tano (905), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani alipokuwa ameishi miaka sabini, akamzaa Mahalaleli. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Baada ya kumzaa Mahalaleli, Kenani aliishi miaka mia nane na arobaini, akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani aliishi jumla ya miaka mia tisa na kumi, ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli alipokuwa ameishi miaka sitini na tano, akamzaa Yaredi. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Baada ya kumzaa Yaredi, Mahalaleli aliishi miaka mia nane na thelathini, akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli aliishi jumla ya miaka mia nane tisini na tano (895), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaredi alipokuwa ameishi miaka mia moja na sitini na mbili (162), akamzaa Idrisi. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Baada ya kumzaa Idrisi, Yaredi aliishi miaka mia nane, naye akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaredi aliishi jumla ya miaka mia tisa na sitini na mbili (962), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Idrisi alipokuwa ameishi miaka sitini na tano, akamzaa Methusela. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Baada ya kumzaa Methusela, Idrisi alitembea na Mungu miaka mia tatu, na akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Idrisi aliishi jumla ya miaka mia tatu sitini na tano (365). ");
INSERT INTO swhonmm_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Idrisi akatembea na Mungu, kisha akatoweka, kwa sababu Mungu alimchukua. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methusela alipokuwa ameishi miaka mia moja na themanini na saba (187), akamzaa Lameki. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Baada ya kumzaa Lameki, Methusela aliishi miaka mia saba na themanini na mbili (782), akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methusela aliishi jumla ya miaka mia tisa sitini na tisa (969), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki alipokuwa ameishi miaka mia moja na themanini na mbili (182), alimzaa mwana. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Akamwita jina Nuhu. Naye akasema, “Huyu ndiye atakayetufariji katika kazi ngumu ya mikono yetu yenye maumivu makali yaliyosababishwa na ardhi iliyolaaniwa na Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Baada ya Nuhu kuzaliwa, Lameki aliishi miaka mia tano na tisini na tano (595), akawa na watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki aliishi jumla ya miaka mia saba sabini na saba (777), ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Baada ya Nuhu kuishi miaka mia tano, aliwazaa Shemu, Hamu, na Yafethi. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Idadi ya watu ilipoanza kuongezeka duniani, na watoto wa kike wakazaliwa kwao, ");
INSERT INTO swhonmm_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","wana wa Mungu wakawaona kuwa hao binti za wanadamu walikuwa wazuri wa sura, wakaoa yeyote miongoni mwao waliyemchagua. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ndipo Mwenyezi Mungu akasema, “Roho yangu haitashindana na mwanadamu milele, kwa kuwa yeye ni wa kufa; siku zake zitakuwa miaka mia moja na ishirini.” ");
INSERT INTO swhonmm_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Wanefili walikuwa duniani siku hizo, na hata baadaye, hao wana wa Mungu walipoingia kwa binti za wanadamu na kuzaa nao. Wanefili walikuwa mashujaa wa zamani, na watu mashuhuri. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mwenyezi Mungu akaona jinsi uovu wa mwanadamu ulivyokuwa mkubwa duniani, na ya kuwa kila mwelekeo wa mawazo ya moyo wake wakati wote ulikuwa mbaya tu. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mwenyezi Mungu akasikitika kwamba alimuumba mwanadamu duniani, na moyo wa Mungu ukasikitika sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kwa hiyo Mwenyezi Mungu akasema, “Nitamfutilia mbali mwanadamu niliyemuumba kutoka uso wa dunia, wanadamu na wanyama, pamoja na viumbe vinavyotambaa ardhini, na ndege wa angani. Kwa maana nasikitika kuwaumba.” ");
INSERT INTO swhonmm_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Lakini Nuhu akapata kibali machoni pa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hivi ndivyo vizazi vya Nuhu. Nuhu alikuwa mtu wa haki, na mkamilifu miongoni mwa watu wa wakati wake, tena alitembea na Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu alikuwa na wana watatu: Shemu, Hamu na Yafethi. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Wakati huu dunia ilikuwa imejaa uharibifu na ukatili machoni pa Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mungu akaona jinsi dunia ilivyoharibika, kwa maana watu wote duniani walikuwa wameharibu njia zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kwa hiyo Mungu akamwambia Nuhu, “Nitawaangamiza watu wote, kwa kuwa dunia imejaa ukatili kwa sababu yao. Hakika nitaangamiza watu pamoja na dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kwa hiyo jitengenezee safina kubwa kwa mbao za mvinje; tengeneza vyumba ndani yake na uipake lami ndani na nje. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hivi ndivyo utakavyoitengeneza: Safina iwe na urefu wa dhiraa mia tatu, upana wake dhiraa hamsini, na kimo chake dhiraa thelathini. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Itengenezee paa na umalizie safina kwa kuacha nafasi ya dhiraa moja juu. Weka mlango ubavuni mwa safina, na uifanye ya ghorofa ya chini, ya kati na ya juu. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nitaleta gharika ya maji juu ya dunia ili kuangamiza kila chenye uhai chini ya mbingu, kila kiumbe chenye pumzi ya uhai ndani yake. Kila kitu juu ya dunia kitaangamia. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lakini mimi nitaweka agano langu na wewe, nawe utaingia ndani ya Safina, wewe pamoja na mke wako, wanao na wake zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Utaingiza ndani ya Safina kila aina ya kiumbe hai wawili wawili, wa kiume na wa kike, ili kuwahifadhi hai pamoja na wewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Wawili wa kila aina ya ndege, wa kila aina ya mnyama, na wa kila aina ya kiumbe kinachotambaa ardhini watakuja kwako ili wahifadhiwe hai. ");
INSERT INTO swhonmm_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Utachukua kila aina ya chakula kitakacholiwa, na ukiweke akiba kama chakula kwa ajili yako na yao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu akafanya kila kitu kama vile Mungu alimwamuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ndipo Mwenyezi Mungu akamwambia Nuhu, “Ingia katika safina, wewe na jamaa yako yote, kwa sababu katika kizazi hiki nimeona ya kuwa wewe ni mwenye haki. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Chukua wanyama saba walio safi wa kila aina, wa kiume na wa kike; na wanyama wawili wawili wa kila aina walio najisi, wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pia uchukue ndege saba walio safi wa kila aina, wa kiume na wa kike, ili kuhifadhi aina zao mbalimbali katika dunia yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Siku saba kuanzia sasa nitaleta mvua juu ya dunia kwa siku arobaini, usiku na mchana; nami nitafutilia mbali kutoka uso wa dunia kila kiumbe hai nilichokiumba.” ");
INSERT INTO swhonmm_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu akafanya yote Mwenyezi Mungu aliyomwamuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu alikuwa na umri wa miaka mia sita gharika ilipokuja juu ya dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu na mkewe, na wanawe na wake zao, wakaingia katika safina ili waepuke ile gharika. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Jozi ya wanyama walio safi na walio najisi, ndege na viumbe vinavyotambaa ardhini, ");
INSERT INTO swhonmm_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wa kiume na wa kike, walikuja kwa Nuhu, wakaingia katika safina kama Mungu alivyomwamuru Nuhu. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Baada ya siku saba, maji ya gharika yakaja juu ya dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Katika siku ya kumi na saba ya mwezi wa pili, mwaka wa mia sita wa maisha ya Nuhu, siku hiyo chemchemi zote za vilindi zilibubujika kwa nguvu, na malango ya mafuriko ya mbinguni yakafunguliwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mvua ikanyesha juu ya dunia siku arobaini usiku na mchana. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siku hiyo Nuhu na mkewe, na wanawe Shemu, Hamu na Yafethi pamoja na wake zao, wakaingia katika ile safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nao walikuwa pamoja na kila mnyama pori kufuatana na aina yake, wanyama wote wafugwao kufuatana na aina zao, kila kiumbe kinachotambaa juu ya ardhi kwa aina yake, na kila ndege kufuatana na aina yake, naam kila kiumbe chenye mabawa. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Viumbe vyote vyenye pumzi ya uhai vikaja kwa Nuhu viwili viwili, vikaingia katika safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Wanyama walioingia katika safina walikuwa wa kiume na wa kike, wa kila kiumbe chenye uhai kama Mungu alivyomwamuru Nuhu; ndipo Mwenyezi Mungu akamfungia ndani. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kwa siku arobaini mafuriko yaliendelea kujaa duniani; maji yalivyozidi kuongezeka, yaliinua safina juu sana kutoka uso wa dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maji yakajaa na kuongezeka sana juu ya dunia, na safina ikaelea juu ya maji. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maji yakazidi kujaa juu ya dunia, yakaifunika milima yote mirefu chini ya mbingu yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maji yakaendelea kujaa, yakaifunika milima kwa kina cha zaidi ya dhiraa kumi na tano. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kila kiumbe hai kinachotambaa juu ya dunia kikaangamia: ndege, mifugo, wanyama pori, viumbe vyote juu ya nchi, na wanadamu wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kila kiumbe juu ya nchi kavu chenye pumzi ya uhai kikafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kila kitu chenye uhai juu ya uso wa nchi kilifutiliwa mbali; watu, wanyama pori, viumbe vinavyotambaa ardhini, na ndege warukao angani wakafutiliwa mbali toka duniani. Waliobaki ni Nuhu peke yake na wale waliokuwa pamoja naye ndani ya safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maji yakaifunika dunia kwa siku mia moja na hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mungu akamkumbuka Nuhu na wanyama pori na mifugo wote waliokuwa naye ndani ya safina; akatuma upepo ukavuma katika dunia, nayo maji yakapungua. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Chemchemi za vilindi zikawa zimefungwa, na malango ya mafuriko ya mbinguni pia yakawa yamefungwa; nayo mvua ikawa imekoma kunyesha. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Maji yakaendelea kupungua taratibu katika dunia. Mwishoni mwa siku ya mia moja na hamsini, maji yakawa yamepungua. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na katika siku ya kumi na saba ya mwezi wa saba, safina ikatua katika milima ya Ararati. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maji yakaendelea kupungua hadi mwezi wa kumi. Siku ya kwanza ya mwezi wa kumi, vilele vya milima vikaonekana. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Baada ya siku arobaini, Nuhu akafungua dirisha alilokuwa amelifanya katika safina, ");
INSERT INTO swhonmm_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","akamtoa kunguru, naye akawa akiruka kwenda na kurudi hadi maji yalipokwisha kukauka juu ya dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kisha akamtoa hua ili aone kama maji yameondoka juu ya ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lakini hua hakupata mahali pa kutua, kwa kuwa maji yalienea juu ya uso wa dunia yote, kwa hiyo akarudi kwa Nuhu ndani ya safina. Nuhu akanyoosha mkono akamchukua yule hua, akamrudisha ndani ya safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhu akangojea siku saba zaidi, kisha akamtoa tena hua kutoka safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Jioni hua aliporudi kwa Nuhu alikuwa amebeba jani bichi la mzeituni lililochumwa wakati ule ule katika mdomo wake! Ndipo Nuhu akajua ya kuwa maji yameondoka juu ya dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Akangojea siku saba zaidi na akamtuma tena hua, lakini wakati huu hua hakurudi tena kwa Nuhu. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kufikia siku ya kwanza ya mwezi wa kwanza wa mwaka wa mia sita na moja (601) wa maisha ya Nuhu, maji yalikuwa yamekauka duniani. Kisha Nuhu akatoa kifuniko juu ya safina, akaona ya kuwa uso wa ardhi ulikuwa umekauka. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kufikia siku ya ishirini na saba ya mwezi wa pili, dunia ilikuwa imekauka kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ndipo Mungu akamwambia Nuhu, ");
INSERT INTO swhonmm_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Toka katika safina, wewe na mkeo, na wanao na wake zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Utoe nje kila aina ya kiumbe hai aliye pamoja nawe, wakiwamo ndege, wanyama na viumbe vyote vinavyotambaa ardhini, ili wakazae, na kuongezeka na kuijaza tena dunia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kwa hiyo Nuhu akatoka nje pamoja na mkewe, na wanawe na wake zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Wanyama wote na viumbe vyote vinavyotambaa ardhini, na ndege wote, kila kitu kinachoenda juu ya nchi, aina moja baada ya nyingine vikatoka katika safina. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kisha Nuhu akamjengea Mwenyezi Mungu madhabahu, akachukua baadhi ya wale wanyama na ndege wote walio safi, akatoa sadaka za kuteketezwa juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mwenyezi Mungu akasikia harufu nzuri ya kupendeza, naye akasema moyoni mwake, “Kamwe sitailaani tena ardhi kwa sababu ya mwanadamu, hata ingawa kila mwelekeo wa moyo wake ni mbaya tangu ujana. Kamwe sitaangamiza tena viumbe hai vyote kama nilivyofanya. ");
INSERT INTO swhonmm_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Kwa muda dunia idumupo, majira ya kupanda na ya kuvuna, wakati wa baridi na wa joto, wakati wa kiangazi na wa masika, usiku na mchana kamwe havitakoma.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ndipo Mungu akawabariki Nuhu na wanawe, akiwaambia, “Zaeni, mkaongezeke kwa idadi, na mkaijaze tena dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Wanyama wote wa nchi, na ndege wote wa angani, na kila kiumbe kinachotambaa juu ya ardhi, na samaki wote wa baharini wamekabidhiwa mikononi mwenu, nao watawaogopa na kuwahofu. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kila kitu chenye uhai kiendacho kitakuwa chakula chenu. Kama vile nilivyowapa mimea mbalimbali, sasa nawapa kila kitu. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Lakini kamwe msile nyama ambayo bado ina damu, kwa maana damu ni uhai. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Hakika damu ya uhai wenu nitaidai. Nitaidai kutoka kwa kila mnyama. Kutoka kwa kila mwanadamu pia nitaidai kwa ajili ya uhai wa binadamu mwenzake. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Yeyote amwagaye damu ya mwanadamu, damu yake itamwagwa na mwanadamu; kwa kuwa katika mfano wa Mungu, Mungu alimuumba mwanadamu. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bali ninyi, zaeni mwongezeke kwa idadi; zidini duniani na kuijaza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ndipo Mungu akamwambia Nuhu na wanawe pamoja naye: ");
INSERT INTO swhonmm_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sasa mimi ninaweka agano langu nanyi, pamoja na uzao wenu baada yenu, ");
INSERT INTO swhonmm_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","pia na kila kiumbe hai kilichokuwa pamoja nanyi: ndege, mifugo, na wanyama pori wote, wale wote waliotoka katika safina pamoja nanyi: kila kiumbe hai duniani. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ninaweka agano nanyi: Kamwe uhai hautafutwa tena kwa gharika; kamwe hakutakuwa tena gharika ya kuangamiza dunia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mungu akasema, “Hii ni ishara ya agano ninalofanya kati yangu na ninyi na kila kiumbe hai kilicho pamoja nanyi, agano kwa vizazi vyote vijavyo: ");
INSERT INTO swhonmm_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nimeweka upinde wangu wa mvua mawinguni, nao utakuwa ishara ya agano nifanyalo kati yangu na dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wakati wowote ninapotanda mawingu juu ya dunia na upinde wa mvua ukatokea mawinguni, ");
INSERT INTO swhonmm_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nitakumbuka agano langu kati yangu na ninyi na viumbe vyote vilivyo hai vya kila aina. Kamwe maji hayatakuwa tena gharika ya kuangamiza uhai wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Wakati wowote upinde wa mvua unapotokea mawinguni, nitauona na kukumbuka agano la milele kati ya Mungu na viumbe vyote vilivyo hai vya kila aina duniani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hivyo Mungu akamwambia Nuhu, “Hii ndiyo ishara ya agano ambalo nimelifanya kati yangu na viumbe vyote vilivyo hai duniani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wana wa Nuhu waliotoka ndani ya safina walikuwa: Shemu, na Hamu, na Yafethi. (Hamu ndiye alikuwa baba wa Kanaani.) ");
INSERT INTO swhonmm_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hao walikuwa wana watatu wa Nuhu, na kutokana nao watu walienea katika dunia. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu akawa mkulima, akawa mtu wa kwanza kupanda mizabibu. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Alipokunywa huo mvinyo wake, akalewa na akalala uchi kwenye hema lake. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, baba wa Kanaani, akauona uchi wa baba yake na kuwaeleza ndugu zake wawili waliokuwa nje. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lakini Shemu na Yafethi wakachukua nguo, wakaitanda mabegani mwao wote wawili, kisha wakaenda kinyumenyume, wakaufunika uchi wa baba yao. Nyuso zao zilielekea upande mwingine ili wasiuone uchi wa baba yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu alipolevuka na kujua lile mwanawe mdogo alilomtendea, ");
INSERT INTO swhonmm_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","akasema, “Alaaniwe Kanaani! Atakuwa mtumwa wa chini kabisa kwa ndugu zake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pia akasema, “Atukuzwe Mwenyezi Mungu, Mungu wa Shemu! Kanaani na awe mtumwa wa Shemu. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mungu na apanue mipaka ya Yafethi; Yafethi na aishi katika mahema ya Shemu, na Kanaani na awe mtumwa wake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Baada ya gharika, Nuhu aliishi miaka mia tatu na hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu aliishi jumla ya miaka mia tisa na hamsini, ndipo akafa. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hivi ndivyo vizazi vya wana wa Nuhu, yaani Shemu, Hamu na Yafethi, ambao walizaa wana baada ya gharika. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Yafethi walikuwa: Gomeri, Magogu, Madai, Yavani, Tubali, Mesheki na Tirasi. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeri walikuwa: Ashkenazi, Rifathi na Togarma. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani walikuwa: Al-Yasa, Tarshishi, Kitimu na Rodanimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Kutokana na hawa mataifa ya pwani yalienea katika nchi zao, kwa koo zao katika mataifa yao, kila moja kwa lugha yake.) ");
INSERT INTO swhonmm_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu walikuwa: Kushi, Misri, Putu na Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kushi walikuwa: Seba, Havila, Sabta, Raama na Sabteka. Wana wa Raama walikuwa: Sheba na Dedani. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi akamzaa Nimrodi, ambaye alikua akawa shujaa mwenye nguvu duniani. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Alikuwa mwindaji hodari mbele za Mwenyezi Mungu; Ndiyo maana watu husema, “Kama Nimrodi, mwindaji hodari mbele za Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Vituo vya kwanza katika ufalme wake vilikuwa Babeli, Ereki, Akadi na Kalne, katika nchi ya Shinari. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kutoka nchi ile alienda Ashuru, ambako alijenga miji ya Ninawi, na Rehoboth-Iri, na Kala, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni, mji ulio kati ya Ninawi na Kala; huo ndio mji mkubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misri alikuwa baba wa: Waludi, Waanami, Walehabi, Wanaftuhi, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Wapathrusi, Wakasluhi (hao ndio asili ya Wafilisti), na Wakaftori. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani alikuwa baba wa: Sidoni mzaliwa wake wa kwanza, Hethi, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Wayebusi, Waamori, Wagirgashi, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Wahivi, Waarki, Wasini, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Waarvadi, Wasemari na Wahamathi. (Baadaye koo za Wakanaani zilitawanyika, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","na mipaka ya Kanaani ikaenea kutoka Sidoni kuelekea Gerari hadi Gaza, kisha kuelekea Sodoma, Gomora, Adma na Seboimu, hadi kufikia Lasha.) ");
INSERT INTO swhonmm_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hawa ni wana wa Hamu kwa koo zao na lugha zao, katika nchi zao na mataifa yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, ndugu mkubwa wa Yafethi, alizaa wana pia. Shemu alikuwa baba wa wana wote wa Eberi. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu walikuwa: Elamu, Ashuru, Arfaksadi, Ludi na Aramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Aramu walikuwa: Usi, Huli, Getheri na Mashi. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadi alikuwa baba wa Shela, naye Shela akamzaa Eberi. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi akapata wana wawili: Mmoja wao aliitwa Pelegi, kwa kuwa wakati wake dunia iligawanyika; nduguye aliitwa Yoktani. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktani alikuwa baba wa: Almodadi, Shelefu, Hasarmawethi, Yera, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, Uzali, Dikla, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Seba, ");
INSERT INTO swhonmm_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila na Yobabu. Hawa wote walikuwa wana wa Yoktani. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Eneo waliloishi lilienea kutoka Mesha kuelekea Sefari, kwenye nchi ya vilima iliyo mashariki.) ");
INSERT INTO swhonmm_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hao ndio wana wa Shemu kwa koo zao na lugha zao, katika nchi zao na mataifa yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hizi ndizo koo za wana wa Nuhu, kufuatana na vizazi vyao, katika mataifa yao. Kutokana na hawa mataifa yalienea duniani kote baada ya gharika. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wakati huo dunia yote ilikuwa na lugha moja na msemo mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Watu walipoelekea upande wa mashariki, wakafika kwenye tambarare katika nchi ya Shinari, nao wakaishi huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wakasemezana wao kwa wao, “Njooni, tufyatue matofali na tuyachome vizuri kwa moto.” Walitumia matofali badala ya mawe, na lami kuunganisha hayo matofali. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ndipo wakasema, “Njooni, tujijengee mji wenye mnara ambao utafika hadi mbinguni, ili tujipatie jina, tusije tukatawanyika duniani kote.” ");
INSERT INTO swhonmm_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Lakini Mwenyezi Mungu akashuka ili auone mji na mnara ambao wanadamu walikuwa wanaujenga. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mwenyezi Mungu akasema, “Ikiwa kama taifa moja wanaozungumza lugha moja wameanza kufanya hili, basi hakuna lolote watakalopanga kufanya ambalo halitawezekana kwao. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Njooni, tushuke tuvuruge lugha yao ili wasielewane wao kwa wao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hivyo Mwenyezi Mungu akawatawanya kutoka mahali pale waende duniani kote; nao wakaacha kuujenga huo mji. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ndiyo maana pakaitwa Babeli, kwa sababu hapo ndipo Mwenyezi Mungu alipoivuruga lugha ya dunia nzima. Kutoka hapo Mwenyezi Mungu akawatawanya duniani kote. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hivi ndivyo vizazi vya Shemu. Miaka miwili baada ya gharika, Shemu alipokuwa na umri wa miaka mia moja, akamzaa Arfaksadi. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Baada ya kumzaa Arfaksadi, Shemu aliishi miaka mia tano, akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksadi alipokuwa ameishi miaka thelathini na tano, akamzaa Shela. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Baada ya kumzaa Shela, Arfaksadi aliishi miaka mia nne na tatu (403), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela alipokuwa ameishi miaka thelathini, akamzaa Eberi. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Baada ya kumzaa Eberi, Shela aliishi miaka mia nne na tatu (403), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi alipokuwa ameishi miaka thelathini na nne, akamzaa Pelegi. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Baada ya kumzaa Pelegi, Eberi aliishi miaka mia nne na thelathini (430), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi alipokuwa ameishi miaka thelathini, akamzaa Reu. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Baada ya kumzaa Reu, Pelegi aliishi miaka mia mbili na tisa (209), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu alipokuwa ameishi miaka thelathini na mbili, akamzaa Serugi. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Baada ya kumzaa Serugi, Reu aliishi miaka mia mbili na saba (207), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi alipokuwa ameishi miaka thelathini, akamzaa Nahori. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Baada ya kumzaa Nahori, Serugi aliishi miaka mia mbili, akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori alipokuwa ameishi miaka ishirini na tisa, akamzaa Tera. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Baada ya kumzaa Tera, Nahori aliishi miaka mia moja na kumi na tisa (119), akazaa watoto wengine wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera alipokuwa ameishi miaka sabini, akamzaa Abramu, na baadaye akawazaa Nahori na Harani. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hivi ndivyo vizazi vya Tera. Tera aliwazaa Abramu, Nahori na Harani. Harani akamzaa Lutu. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera alipokuwa bado hai, Harani akafa katika Uru ya Wakaldayo, nchi aliyozaliwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu na Nahori walioa. Mke wa Abramu aliitwa Sarai, naye mke wa Nahori aliitwa Milka; Milka na Iska walikuwa watoto wa Harani. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai alikuwa tasa, hakuwa na watoto. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera akawachukua Abramu mwanawe, mjukuu wake Lutu mwana wa Harani, na Sarai mkwewe, mke wa Abramu mwanawe, wakatoka Uru ya Wakaldayo pamoja, wakaenda nchi ya Kanaani. Lakini walipofika Harani, wakaishi huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera aliishi miaka mia mbili na mitano (205), akafa huko Harani. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mwenyezi Mungu alikuwa amemwambia Abramu, “Ondoka katika nchi yako, uache jamii yako na nyumba ya baba yako, uende hadi nchi nitakayokuonesha. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Nitakufanya taifa kubwa na nitakubariki, Nitalikuza jina lako, nawe utakuwa baraka. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nitawabariki wale wanaokubariki, na yeyote akulaaniye nitamlaani; na kupitia kwako mataifa yote duniani yatabarikiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Hivyo Abramu akaondoka kama Mwenyezi Mungu alivyokuwa amemwambia; naye Lutu akaondoka pamoja naye. Abramu alipoitwa aondoke Harani, alikuwa na umri wa miaka sabini na tano. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu akamchukua Sarai mkewe pamoja na Lutu mwana wa ndugu yake, mali yote waliyokuwa nayo, pamoja na watu aliokuwa amewapata huko Harani, wakasafiri kwenda nchi ya Kanaani, na wakafika huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramu akasafiri katika nchi hiyo hadi huko Shekemu, mahali penye mwaloni wa More. Wakati huo Wakanaani walikuwa wanaishi katika nchi hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mwenyezi Mungu akamtokea Abramu, akamwambia, “Nitawapa uzao wako nchi hii.” Hivyo hapo akamjengea madhabahu Mwenyezi Mungu aliyekuwa amemtokea. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kutoka huko Abramu akasafiri kuelekea kwenye vilima mashariki mwa Betheli, naye akapiga hema huko, Betheli ikiwa upande wa magharibi na Ai upande wa mashariki. Huko alimjengea Mwenyezi Mungu madhabahu na akaliitia jina la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kisha Abramu akasafiri kuelekea upande wa Negebu. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Basi kulikuwa na njaa katika nchi hiyo, naye Abramu akashuka kwenda Misri kukaa huko kwa muda, kwa maana njaa ilikuwa kali. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Alipokaribia kuingia Misri, akamwambia Sarai mkewe, “Ninajua kwamba wewe ni mwanamke mzuri wa sura. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wamisri watakapokuona, watasema, ‘Huyu ni mke wake.’ Kisha wataniua, lakini wewe watakuacha hai. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sema wewe ni dada yangu, ili nitendewe mema kwa ajili yako, na maisha yangu yahifadhiwe kwa sababu yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramu alipoingia Misri, Wamisri wakamwona Sarai kuwa ni mwanamke mzuri sana wa sura. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Maafisa wa Farao walipomwona, wakamsifia kwa Farao; ndipo Sarai akapelekwa kwa nyumba ya mfalme. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kwa ajili ya Sarai, Farao akamtendea Abramu mema, naye Abramu akapata kondoo, ng’ombe, punda, ngamia, na watumishi wa kiume na wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Lakini Mwenyezi Mungu akamwadhibu Farao na nyumba yake kwa maradhi ya kufisha kwa sababu ya kumchukua Sarai, mke wa Abramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ndipo Farao akamwita Abramu, akamuuliza, “Umenifanyia nini? Kwa nini hukuniambia yeye ni mke wako? ");
INSERT INTO swhonmm_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kwa nini ulisema, ‘Yeye ni dada yangu,’ hata nikamchukua kuwa mke wangu? Sasa basi, mke wako huyu hapa. Mchukue uende zako!” ");
INSERT INTO swhonmm_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kisha Farao akawapa watu wake amri kuhusu Abramu, wakamsindikiza pamoja na mke wake na kila alichokuwa nacho. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hivyo Abramu akakwea kutoka Misri kwenda Negebu, na mkewe na kila kitu alichokuwa nacho; pia Lutu akaenda pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Wakati huo Abramu alikuwa tajiri sana wa mifugo, fedha na dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kutoka Negebu, akasafiri sehemu mbalimbali hadi akafika Betheli, mahali ambapo mwanzoni alipiga hema lake kati ya Betheli na Ai, ");
INSERT INTO swhonmm_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","pale alipokuwa amejenga madhabahu ya kwanza. Huko Abramu akaliitia jina la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Basi Lutu, aliyekuwa anafuatana na Abramu, alikuwa pia na mifugo na mahema. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Lakini nchi haikuwatosha kukaa pamoja kwa ajili ya wingi wa mali yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ukazuka ugomvi kati ya wafugaji wa wanyama wa Abramu na wale wa Lutu. Wakati huo, Wakanaani na Waperizi pia waliishi katika nchi hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hivyo Abramu akamwambia Lutu, “Pasiwe na ugomvi wowote kati yangu na wewe, wala kati ya wachungaji wangu na wako, kwa kuwa sisi ni ndugu. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Je, nchi yote haiko mbele yako? Tutengane. Ukielekea kushoto, nitaenda kulia; ukielekea kulia, mimi nitaenda kushoto.” ");
INSERT INTO swhonmm_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu akatazama, akaona lile bonde lote la Yordani kuwa lilikuwa na maji tele, kama bustani ya Mwenyezi Mungu, kama nchi ya Misri, kuelekea Soari. (Hii ilikuwa kabla Mwenyezi Mungu hajaharibu Sodoma na Gomora.) ");
INSERT INTO swhonmm_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hivyo Lutu akajichagulia bonde lote la Yordani, akaelekea upande wa mashariki. Watu hao wawili wakatengana. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu aliishi nchi ya Kanaani, naye Lutu akaishi miongoni mwa miji ya lile bonde na kupiga mahema yake karibu na Sodoma. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Basi watu wa Sodoma walikuwa waovu, wakitenda dhambi nyingi dhidi ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Baada ya Lutu kuondoka, Mwenyezi Mungu akamwambia Abramu, “Ukiwa hapo ulipo, inua macho yako utazame kaskazini na kusini, mashariki na magharibi. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nchi yote unayoiona nitakupa wewe na uzao wako hata milele. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nitaufanya uzao wako uwe mwingi kama mavumbi ya nchi, hivyo ikiwa kuna yeyote awezaye kuhesabu mavumbi, basi uzao wako utahesabika. ");
INSERT INTO swhonmm_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ondoka, tembea katika marefu na mapana ya nchi, kwa maana ninakupa wewe.” ");
INSERT INTO swhonmm_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Basi Abramu akaondoa mahema yake, akaenda kuishi karibu na mialoni ya Mamre huko Hebroni. Naye akamjengea Mwenyezi Mungu madhabahu huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wakati huo Amrafeli mfalme wa Shinari, Arioko mfalme wa Elasari, Kedorlaoma mfalme wa Elamu, na Tidali mfalme wa Goimu ");
INSERT INTO swhonmm_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","walienda kupigana vita dhidi ya Bera mfalme wa Sodoma, Birsha mfalme wa Gomora, Shinabu mfalme wa Adma, Shemeberi mfalme wa Seboimu, na mfalme wa Bela (yaani Soari). ");
INSERT INTO swhonmm_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wafalme wa kundi hili la pili waliunganisha majeshi yao katika Bonde la Sidimu (yaani Bahari ya Chumvi). ");
INSERT INTO swhonmm_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Walikuwa wametawaliwa na Mfalme Kedorlaoma kwa miaka kumi na mbili, lakini mwaka wa kumi na tatu wakaasi. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mwaka wa kumi na nne, Mfalme Kedorlaoma na wafalme waliojiunga naye walienda vitani na wakawashinda Warefai katika Ashtaroth-Kanaimu, Wazuzi katika Hamu, Waemi katika Shawe-Kiriathaimu, ");
INSERT INTO swhonmm_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Wahori katika nchi ya vilima ya Seiri, hadi El-Parani karibu na jangwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kisha wakarudi, wakaenda En-Misfati (yaani Kadeshi), wakashinda nchi yote ya Waamaleki, pamoja na Waamori walioishi Hasason-Tamari. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ndipo mfalme wa Sodoma, na mfalme wa Gomora, mfalme wa Adma, mfalme wa Seboimu, na mfalme wa Bela (yaani Soari) wakatoka kupanga majeshi yao kwenye Bonde la Sidimu ");
INSERT INTO swhonmm_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","dhidi ya Kedorlaoma mfalme wa Elamu, na Tidali mfalme wa Goimu, Amrafeli mfalme wa Shinari, na Arioko mfalme wa Elasari; yaani wafalme wanne dhidi ya wafalme watano. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Basi Bonde la Sidimu lilikuwa limejaa mashimo ya lami, nao wafalme wa Sodoma na wa Gomora walipokimbia, baadhi ya watu walitumbukia huko na wengine wakakimbilia vilimani. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wale wafalme wanne wakateka mali yote ya Sodoma na Gomora pamoja na vyakula vyao vyote, kisha wakaenda zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Pia walimteka Lutu, mwana wa ndugu yake Abramu, pamoja na mali yake, kwa kuwa alikuwa akiishi Sodoma. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mtu mmoja aliyekuwa ametoroka akaja kumpa Abramu Mwebrania taarifa. Abramu alikuwa anaishi karibu na mialoni ya Mamre Mwamori, ndugu ya Eshkoli na Aneri, ambao wote walikuwa wameungana na Abramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramu alipopata habari kwamba jamaa yake amechukuliwa mateka, akawaita watu mia tatu na kumi na nane (318) wa nyumbani mwake waliokuwa wamefunzwa kupigana vita, wakawafuatilia hadi Dani. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Wakati wa usiku, Abramu aliwapanga watu wake katika vikosi, wakawashambulia na kuwashinda, wakawafukuza hadi Hoba, kaskazini mwa Dameski. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abramu akarudisha mali yote, na akamrudisha Lutu jamaa yake na mali yake, pamoja na wanawake na watu wengine. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramu aliporudi baada ya kumshinda Mfalme Kedorlaoma na wale wafalme waliojiunga naye, mfalme wa Sodoma akatoka kwenda kumlaki katika Bonde la Shawe (yaani Bonde la Mfalme). ");
INSERT INTO swhonmm_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ndipo Melkizedeki mfalme wa Salemu akaleta mkate na divai. Alikuwa kuhani wa Mungu Aliye Juu Sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Naye akambariki Abramu, akisema, “Abarikiwe Abramu na Mungu Aliye Juu Sana, Muumba wa mbingu na nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Abarikiwe Mungu Aliye Juu Sana, ambaye amewaweka adui zako mkononi mwako.” Ndipo Abramu akampa Melkizedeki sehemu ya kumi ya kila kitu. ");
INSERT INTO swhonmm_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mfalme wa Sodoma akamwambia Abramu, “Nipe hao watu, nawe uchukue hizo mali.” ");
INSERT INTO swhonmm_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lakini Abramu akamwambia mfalme wa Sodoma, “Nimeinua mkono wangu kwa Mwenyezi Mungu, Mungu Aliye Juu Sana, Muumba wa mbingu na dunia, na nimeapa ");
INSERT INTO swhonmm_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kwamba sitapokea kitu chochote kilicho chako, hata kama ni uzi au gidamu ya kiatu, ili kamwe usije ukasema, ‘Nimemtajirisha Abramu.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sitapokea chochote, ila kile tu watu wangu walichokula, na sehemu ambayo ni fungu la watu walioenda pamoja nami, ambao ni Aneri, Eshkoli na Mamre. Wao na wapewe fungu lao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Baada ya jambo hili, neno la Mwenyezi Mungu likamjia Abramu katika maono, akaambiwa: “Usiogope, Abramu. Mimi ni ngao yako, na thawabu yako kubwa sana.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lakini Abramu akasema, “Ee Bwana Mungu Mwenyezi, utanipa nini na mimi sina mtoto, na atakayerithi nyumba yangu ni huyu Eliezeri Mdameski?” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramu akasema, “Hukunipa watoto, hivyo mtumishi katika nyumba yangu ndiye atakuwa mrithi wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ndipo neno la Mwenyezi Mungu lilipomjia, likanena: “Mtu huyu hatakuwa mrithi wako, bali mwana atakayetoka katika viuno vyako ndiye atakayekurithi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Akamtoa nje na kusema, “Tazama juu mbinguni na uhesabu nyota, kama hakika utaweza kuzihesabu.” Ndipo akamwambia, “Hivyo ndivyo uzao wako utakavyokuwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramu akamwamini Mwenyezi Mungu, naye kwake jambo hili likahesabiwa kuwa haki. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Pia akamwambia, “Mimi ndimi Mwenyezi Mungu, niliyekutoa Uru ya Wakaldayo nikupe nchi hii uimiliki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lakini Abramu akasema, “Ee Bwana Mungu Mwenyezi, nitawezaje kujua kwamba nitaimiliki?” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ndipo Mwenyezi Mungu akamwambia, “Niletee ndama jike, mbuzi, na kondoo dume, kila mmoja wa miaka mitatu, pamoja na hua na kinda la njiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramu akamletea hivi vyote, akampasua kila mnyama vipande viwili, akavipanga kila kimoja kuelekea mwenzake, lakini hata hivyo ndege hakuwapasua vipande viwili. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kisha ndege walao nyama wakatua juu ya mizoga, lakini Abramu akawafukuza. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Jua lilipokuwa linatua, Abramu akashikwa na usingizi mzito, na giza nene na la kutisha likaja juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kisha Mwenyezi Mungu akamwambia, “Ujue hakika kwamba wazao wako watakuwa wageni katika nchi isiyo yao, nao watafanywa watumwa na kuteswa kwa miaka mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lakini nitaliadhibu taifa lile watakalolitumikia kama watumwa, na baadaye watatoka huko na mali nyingi. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wewe hata hivyo utaenda kwa baba zako kwa amani, na kuzikwa katika uzee mwema. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Katika kizazi cha nne wazao wako watarudi hapa, kwa maana uovu wa Waamori bado haujafikia kipimo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Jua lilipokuwa limezama na giza limeingia, tanuru la moshi na mwali wa moto unaowaka vikatokea na kupita kati ya vile vipande vya nyama. ");
INSERT INTO swhonmm_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Siku hiyo Mwenyezi Mungu akafanya agano na Abramu, na kumwambia, “Nitawapa wazao wako nchi hii, kuanzia Kijito cha Misri hadi mto ule mkubwa, Frati: ");
INSERT INTO swhonmm_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","yaani nchi ya Wakeni, Wakenizi, Wakadmoni, ");
INSERT INTO swhonmm_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Wahiti, Waperizi, Warefai, ");
INSERT INTO swhonmm_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Waamori, Wakanaani, Wagirgashi na Wayebusi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Basi Sarai, mkewe Abramu, alikuwa hajamzalia watoto. Lakini alikuwa na mjakazi Mmisri jina lake Hajiri. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hivyo Sarai akamwambia Abramu, “Mwenyezi Mungu amenizuilia kupata watoto. Basi nenda ukutane kimwili na mjakazi wangu; huenda nitaweza kupata watoto kupitia kwake.” Abramu akakubaliana na lile Sarai alilosema. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hivyo baada ya Abramu kuishi katika nchi ya Kanaani miaka kumi, Sarai akamchukua mjakazi wake Mmisri aliyeitwa Hajiri, na kumpa mumewe awe mke wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu akakutana kimwili na Hajiri, naye akapata mimba. Hajiri alipojua kuwa ana mimba, akaanza kumdharau Sarai. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ndipo Sarai akamwambia Abramu, “Unawajibika na mateso ninayoyapata. Nilimweka mtumishi wangu mkononi mwako. Sasa kwa vile anajua kwamba ana mimba, ananidharau mimi. Mwenyezi Mungu na aamue kati yako na mimi!” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramu akamwambia, “Haya, mtumishi wako yuko mkononi mwako. Mtendee lolote utakalo!” Ndipo Sarai akamtesa Hajiri, naye akamtoroka. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika wa Mwenyezi Mungu akamkuta Hajiri karibu na chemchemi huko jangwani; chemchemi hiyo ilikuwa kando ya barabara iendayo Shuri. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malaika akamwambia, “Hajiri, mtumishi wa Sarai, umetoka wapi, na unaenda wapi?” Akamjibu, “Ninamkimbia bibi yangu Sarai.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ndipo malaika wa Mwenyezi Mungu akamwambia, “Rudi kwa bibi yako ukajishushe chini yake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Malaika akaendelea akasema, “Nitazidisha wazao wako, hivi kwamba watakuwa wengi mno wasiohesabika.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pia malaika wa Mwenyezi Mungu akamwambia: “Wewe sasa una mimba nawe utamzaa mwana. Utamwita jina lake Ishmaeli, kwa sababu Mwenyezi Mungu amesikia kuhusu huzuni yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Atakuwa kama punda-mwitu kati ya wanadamu; mkono wake utakuwa dhidi ya kila mtu, na mkono wa kila mtu utakuwa dhidi yake, naye ataishi kwa uhasama na ndugu zake wote.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajiri akampa Mwenyezi Mungu aliyezungumza naye jina hili: “Wewe ndiwe Mungu unionaye mimi,” kwa maana alisema, “Sasa nimemwona yeye anayeniona mimi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ndiyo sababu kisima kile kikaitwa Beer-Lahai-Roi; bado kipo hata leo kati ya Kadeshi na Beredi. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hivyo Hajiri akamzalia Abramu mwana, naye Abramu akamwita huyo mwana Hajiri aliyemzalia jina la Ishmaeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu alikuwa na umri wa miaka themanini na sita Hajiri alipomzalia Ishmaeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramu alipokuwa na umri wa miaka tisini na tisa, Mwenyezi Mungu akamtokea, akamwambia, “Mimi ndimi Mungu Mwenyezi; nenda mbele zangu na uishi kwa unyofu. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nitafanya agano kati yangu na wewe, nami nitakuzidisha sana.” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu akaanguka kifudifudi, naye Mungu akamwambia, ");
INSERT INTO swhonmm_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kwangu mimi, hili ndilo agano langu na wewe: Wewe utakuwa baba wa mataifa mengi. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hutaitwa tena Abramu, bali jina lako litakuwa Ibrahimu, kwa maana nimekufanya baba wa mataifa mengi. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nitakufanya uwe na uzao mwingi sana; kwako yatatoka mataifa, na wafalme watatoka kwako. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nitalithibitisha agano langu kama agano la milele kati yangu na wewe na wazao wako baada yako na vizazi vijavyo, nami nitakuwa Mungu wako na Mungu wa wazao wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nchi yote ya Kanaani, unayoishi sasa kama mgeni, nitakupa kuwa milki yako milele, na ya uzao wako; nami nitakuwa Mungu wao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ndipo Mungu akamwambia Ibrahimu, “Kwako wewe, lazima ushike agano langu, wewe na wazao wako baada yako na vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hili ni agano langu na wewe pamoja na wazao wako baada yako, agano mtakalolishika: Kila mwanaume miongoni mwenu atatahiriwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mtatahiriwa, na hii itakuwa ni alama ya agano kati yangu na ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kwa vizazi vijavyo, kila mwanaume miongoni mwenu mwenye siku nane ni lazima atahiriwe, pamoja na watakaozaliwa nyumbani mwako au walionunuliwa kwa fedha kutoka kwa mgeni, wale ambao sio wa uzao wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Awe amezaliwa nyumbani mwako au amenunuliwa kwa fedha yako, ni lazima atahiriwe. Agano langu katika mwili wako litakuwa ni agano la milele. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kila mwanaume asiyetahiriwa, ambaye hajapata tohara ya mwilini, atatengwa na watu wake; amelivunja agano langu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Pia Mungu akamwambia Ibrahimu, “Kwa upande wa Sarai mkeo, hutamwita tena Sarai, bali jina lake litakuwa Sara. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nitambariki, na hakika nitakupatia mwana kwake. Nitambariki ili awe mama wa mataifa; wafalme wa mataifa watatoka kwake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahimu akaanguka kifudifudi, akacheka na kusema moyoni mwake, “Je, mtu wa miaka mia moja aweza kuzaa mwana? Je, Sara atazaa mtoto katika umri wa miaka tisini?” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibrahimu akamwambia Mungu, “Laiti Ishmaeli naye angeshiriki baraka yako!” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ndipo Mungu akasema, “Ndiyo, lakini mkeo Sara atakuzalia wewe mwana, nawe utamwita jina lake Isaka. Nitalithibitisha agano langu naye kama agano la milele kwa ajili yake na wazao wake baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kuhusu Ishmaeli, nimekusikia. Hakika nitambariki; nitamfanya awe na uzao mwingi na nitaongeza sana idadi yake. Atakuwa baba wa watawala kumi na wawili, nami nitamfanya awe taifa kubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Lakini agano langu nitalithibitisha kwa Isaka, ambaye Sara atakuzalia mwaka ujao majira kama haya.” ");
INSERT INTO swhonmm_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Alipomaliza kuzungumza na Ibrahimu, Mungu akaondoka kwa Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Siku hiyo hiyo, Ibrahimu akamchukua Ishmaeli mwanawe na wote waliozaliwa nyumbani mwake, pamoja na wale walionunuliwa kwa fedha zake; kila mwanaume wa nyumbani mwake akawatahiri, kama Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahimu alikuwa na umri wa miaka tisini na tisa alipotahiriwa; ");
INSERT INTO swhonmm_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","naye Ishmaeli mwanawe alitahiriwa akiwa na umri wa miaka kumi na tatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ibrahimu na Ishmaeli mwanawe walitahiriwa siku hiyo hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Wanaume wote nyumbani mwa Ibrahimu, waliozaliwa nyumbani mwake na walionunuliwa kwa fedha kutoka kwa wageni, walitahiriwa pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mwenyezi Mungu akamtokea Ibrahimu karibu na mialoni ya Mamre alipokuwa ameketi kwenye ingilio la hema lake wakati wa adhuhuri. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ibrahimu akainua macho, akaona watu watatu wamesimama karibu naye. Alipowaona, akaharakisha kutoka ingilio la hema lake, akawalaki na kusujudu hadi chini. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ibrahimu akasema, “Bwana wangu, ikiwa nimepata kibali machoni mwako, usimpite mtumishi wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Acha yaletwe maji kidogo, nanyi mnawe miguu yenu, na mpumzike chini ya mti huu. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Niruhusuni niwapatie chakula kidogo mle, ili mpate nguvu mwendelee na safari yenu, kwa kuwa mmekuja kwa mtumishi wenu.” Nao wakamjibu, “Vema sana, fanya kama unavyosema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hivyo Ibrahimu akaharakisha akaingia kwenye hema kwa Sara, akamwambia, “Chukua vipimo vitatu vya unga laini haraka, ukande na uoke mikate.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kisha Ibrahimu akakimbia kwenye kundi, akachagua ndama mzuri laini, na akampa mtumishi, ambaye aliharakisha kumtayarisha. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kisha akaleta jibini, maziwa na nyama ya yule ndama iliyoandaliwa, akaviweka mbele ya wageni. Walipokuwa wakila, alisimama karibu nao chini ya mti. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wakamuuliza, “Yuko wapi Sara mkeo?” Akasema, “Yuko ndani ya hema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kisha Mwenyezi Mungu akasema, “Hakika nitakurudia majira kama haya mwaka ujao, na Sara mkeo atakuwa na mwana.” Sara alikuwa akiwasikiliza kwenye ingilio la hema lililokuwa nyuma ya Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahimu na Sara walikuwa wazee tena waliosogea miaka, naye Sara alikuwa amepita umri wa kuzaa mtoto. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hivyo Sara akacheka kimoyomoyo alipokuwa akiwaza, “Baada ya mimi kuwa mkongwe hivi na bwana wangu amezeeka, je, nitaweza kufurahia jambo hili?” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ndipo Mwenyezi Mungu akamwambia Ibrahimu, “Kwa nini Sara amecheka na kusema, ‘Kweli nitazaa mtoto nami sasa ni mzee?’ ");
INSERT INTO swhonmm_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Je, kuna jambo lolote gumu lisilowezekana kwa Mwenyezi Mungu? Nitakurudia majira kama haya mwaka ujao, naye Sara atakuwa na mwana.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara akaogopa, hivyo akadanganya na kusema, “Mimi sikucheka.” Lakini Mwenyezi Mungu akasema, “Ndiyo, ulicheka!” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Watu hao waliposimama ili waondoke, walielekeza nyuso zao Sodoma, naye Ibrahimu akatembea nao ili awasindikize. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ndipo Mwenyezi Mungu akasema, “Je, nimfiche Ibrahimu jambo ninalokusudia kufanya? ");
INSERT INTO swhonmm_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Hakika Ibrahimu atakuwa taifa kubwa na lenye nguvu, na kupitia kwake mataifa yote ya dunia yatabarikiwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kwa maana nimemchagua yeye, ili awaongoze watoto wake na jamaa yake kufuata njia ya Mwenyezi Mungu, kwa kuwa waadilifu na kutenda haki, ili Mwenyezi Mungu atimize ahadi yake kwa Ibrahimu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Basi Mwenyezi Mungu akamwambia Ibrahimu, “Kilio dhidi ya Sodoma na Gomora ni kikubwa sana na dhambi zao zinanisikitisha sana, ");
INSERT INTO swhonmm_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","hivyo nitashuka nione kama waliyoyatenda ni mabaya kiasi cha kilio kilichonifikia. Kama sivyo, nitajua.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Basi wale watu wakageuka, wakaelekea Sodoma, lakini Ibrahimu akabaki amesimama mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibrahimu akamsogelea, akasema: “Je, utawaangamiza wenye haki na waovu? ");
INSERT INTO swhonmm_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Je, ikiwa watakuwepo watu hamsini wenye haki katika mji huo, kweli utauangamiza na wala hutauacha kwa ajili ya hao watu hamsini wenye haki waliomo? ");
INSERT INTO swhonmm_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Na liwe mbali nawe, kufanya jambo kama hilo: kuwaua wenye haki pamoja na waovu, kuwatendea wenye haki sawasawa na waovu. Liwe mbali nawe! Je, Mwamuzi wa dunia yote hatafanya haki?” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mwenyezi Mungu akajibu, “Nikipata watu hamsini wenye haki katika mji wa Sodoma, nitauacha huo mji wote kwa ajili yao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kisha Ibrahimu akasema tena: “Sasa kwa kuwa nimekuwa na ujasiri wa kuzungumza na Bwana, ingawa mimi si kitu bali ni mavumbi na majivu. ");
INSERT INTO swhonmm_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Je, kama hesabu ya wenye haki imepungua watano katika hamsini, utauangamiza huo mji wote kwa ajili ya hao watano waliopungua?” Bwana akamjibu, “Nikiwakuta huko watu arobaini na watano, sitauangamiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahimu akazungumza naye kwa mara nyingine, “Je, kama huko watapatikana watu arobaini tu?” Akamjibu, “Kwa ajili ya hao arobaini, sitauangamiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ndipo akasema, “Bwana na asikasirike, lakini niruhusu nizungumze. Je, kama huko watakuwepo thelathini tu?” Akajibu, “Sitauangamiza ikiwa nitawakuta huko watu thelathini.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahimu akasema, “Sasa kwa kuwa nimekuwa na ujasiri sana kuzungumza na Bwana, je, wakipatikana huko watu ishirini tu?” Bwana akajibu, “Kwa ajili ya hao ishirini, sitauangamiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibrahimu akasema, “Bwana na asikasirike, lakini niruhusu nizungumze tena mara moja tu. Itakuwaje kama watapatikana huko watu kumi tu?” Bwana akajibu, “Kwa ajili ya hao kumi, sitauangamiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mwenyezi Mungu alipomaliza kuzungumza na Ibrahimu, akaondoka, naye Ibrahimu akarudi nyumbani. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malaika wale wawili walifika Sodoma wakati wa jioni, naye Lutu alikuwa ameketi kwenye lango la mji. Alipowaona, alienda kuwalaki, akasujudu, uso wake ukagusa chini. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Akasema, “Bwana zangu, tafadhali karibuni kwenye nyumba ya mtumishi wenu. Mnaweza kunawa miguu na kulala hapa, kisha asubuhi na mapema mwendelee na safari yenu.” Wakamjibu, “La, tutalala hapa uwanjani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lakini aliwasihi sana hadi wakaingia nyumbani mwake. Akawaandalia chakula, mikate isiyotiwa chachu, nao wakala. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kabla hawajaenda kulala, wanaume wote kutoka kila sehemu ya mji wa Sodoma, vijana kwa wazee, waliizunguka nyumba. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wakamwita Lutu wakisema, “Wako wapi wale wanaume waliokuja kwako jioni hii? Watoe nje kwetu ili tuwalawiti.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu akatoka nje kuongea nao, akaufunga mlango nyuma yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Akawaambia, “La hasha, rafiki zangu! Msifanye jambo hili ovu. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tazama, ninao binti zangu wawili ambao ni bikira. Acha niwatoe kwenu, nanyi mnaweza kuwafanyia lolote mnalotaka. Lakini msiwafanyie chochote wanaume hawa, kwa sababu wako chini ya ulinzi wa dari langu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Wakamjibu, “Tuondokee mbali!” Wakaendelea kusema, “Huyu mtu alikuja hapa kama mgeni na sasa anataka kuwa mwamuzi wetu! Tutakutenda vibaya kuliko wao.” Waliendelea kumlazimisha Lutu na kuusogelea mlango ili kuuvunja. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lakini wanaume wale waliokuwa ndani wakanyoosha mikono yao, wakamvuta Lutu ndani ya nyumba na kuufunga mlango. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kisha wakawapiga kwa upofu wale wanaume waliokuwa mlangoni mwa ile nyumba, vijana kwa wazee, hivyo hawakuweza kuupata mlango. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wale wanaume wawili wakamwambia Lutu, “Una mtu mwingine yeyote hapa: wakwe, wana au binti, ama yeyote mwingine aliye wako katika mji huu? Waondoe hapa, ");
INSERT INTO swhonmm_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kwa sababu tunapaangamiza mahali hapa. Kilio kwa Mwenyezi Mungu dhidi ya watu wa hapa ni kikubwa kiasi kwamba ametutuma kupaangamiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kwa hiyo Lutu alitoka ili kuzungumza na wakwe wake waliokuwa wamewaposa binti zake. Akawaambia, “Fanyeni haraka kuondoka mahali hapa, kwa kuwa Mwenyezi Mungu yu karibu kuangamiza mji huu!” Lakini wakwe wake walifikiri kwamba alikuwa akitania. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kulipopambazuka, malaika wakamhimiza Lutu, wakisema, “Fanya haraka! Mchukue mke wako na binti zako wawili walio huku, la sivyo utaangamizwa mji huu utakapoadhibiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Alipositasita, wale wanaume wakamshika mkono wake, na mikono ya mke wake na binti zake wawili na kuwaongoza salama nje ya mji, kwa kuwa Mwenyezi Mungu aliwahurumia. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mara walipokwisha kuwatoa nje, mmoja wao akawaambia, “Mkimbie kwa usalama wenu! Msitazame nyuma, wala msisimame popote katika nchi tambarare! Kimbilieni milimani, ama sivyo mtaangamizwa!” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lakini Lutu akawajibu, “La hasha, bwana zangu, tafadhalini! ");
INSERT INTO swhonmm_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mtumishi wenu amepata kibali mbele ya macho yenu, nanyi mmeonesha wema mkubwa kwangu kwa kuokoa maisha yangu. Lakini siwezi kukimbilia milimani; janga hili litanikumba, nami nitakufa. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tazama, hapa kuna mji karibu wa kukimbilia, nao ni mdogo. Niruhusuni nikimbilie humo: Ni mdogo sana, ama sivyo? Ndipo maisha yangu yatasalimika.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Akamwambia, “Vema sana, nitalikubali hili ombi pia, sitauangamiza mji ulioutaja. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Lakini ukimbilie huko haraka, kwa sababu sitaweza kufanya lolote hadi ufike huko.” (Ndiyo maana mji huo ukaitwa Soari.) ");
INSERT INTO swhonmm_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lutu alipofika Soari, jua lilikuwa limechomoza katika nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ndipo Mwenyezi Mungu akanyesha moto wa kiberiti juu ya Sodoma na Gomora kutoka kwake Mwenyezi Mungu mbinguni. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hivyo akaiteketeza miji ile na eneo lote la tambarare, pamoja na wote walioishi katika miji hiyo, hata pia mimea yote katika nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lakini mke wa Lutu akatazama nyuma, hivyo akawa nguzo ya chumvi. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Asubuhi na mapema siku iliyofuata, Ibrahimu akaamka na kurudi mahali pale aliposimama mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Akatazama upande wa Sodoma na Gomora, kuelekea nchi yote ya tambarare, akaona moshi mzito ukipanda kutoka nchi, kama moshi unaotoka katika tanuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kwa hiyo Mungu alipoiangamiza miji ya tambarare, alimkumbuka Ibrahimu, akamtoa Lutu kutoka lile janga lililoharibu miji ile ambamo Lutu alikuwa ameishi. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lutu na binti zake wawili waliondoka Soari na kufanya makao yao kule milimani, kwa maana aliogopa kukaa Soari. Yeye na binti zake wawili waliishi katika pango. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Siku moja binti mkubwa akamwambia yule mdogo, “Baba yetu ni mzee, na hakuna mwanaume mahali hapa atakayekutana na sisi kimwili, kama ilivyo desturi ya mahali pote duniani. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tumnyweshe baba yetu mvinyo, kisha tukutane naye kimwili ili tuhifadhi uzao wetu kupitia baba yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Usiku ule walimnywesha baba yao mvinyo; alipolewa, binti yake mkubwa akaingia na kukutana naye kimwili. Baba yao hakujua binti yake alipoingia kulala naye wala alipotoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Siku iliyofuata binti mkubwa akamwambia yule mdogo, “Usiku uliopita mimi nilikutana kimwili na baba yangu. Tumnyweshe divai tena, usiku huu nawe ukutane naye kimwili ili tuweze kuhifadhi uzao wetu kupitia baba yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kwa hiyo wakamnywesha baba yao mvinyo tena usiku ule, naye binti yake mdogo akaingia, akakutana naye kimwili. Kwa mara nyingine baba yao hakujua binti yake alipolala naye wala alipoondoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hivyo binti wawili wa Lutu wakapata mimba kwa baba yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Binti mkubwa akamzaa mwana, akamwita jina Moabu; ndiye baba wa Wamoabu hata leo. ");
INSERT INTO swhonmm_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Binti mdogo pia akamzaa mwana, naye akamwita jina Benami; ndiye baba wa Waamoni hata leo. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Basi Ibrahimu akaondoka huko akaenda hadi nchi ya Negebu, akaishi kati ya Kadeshi na Shuri. Kwa muda mfupi alikaa Gerari. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Huko Ibrahimu akasema kuhusu Sara mkewe, “Huyu ni dada yangu.” Kisha Abimeleki mfalme wa Gerari akaagiza Sara aletwe, naye akamchukua awe mkewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lakini Mungu akamjia Abimeleki katika ndoto usiku na kumwambia, “Wewe ni kama mfu kwa sababu ya huyu mwanamke uliyemchukua; yeye ni mke wa mtu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Wakati huo Abimeleki alikuwa bado hajamsogelea, kwa hiyo akasema, “Je, Bwana utaliharibu taifa lisilo na hatia? ");
INSERT INTO swhonmm_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hakusema kwangu, ‘Huyu ni dada yangu’; naye Sara pia hakusema, ‘Huyu ni kaka yangu’? Nimefanya haya kwa dhamiri safi na mikono safi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kisha Mungu akamwambia katika ndoto ile, “Ndiyo, najua kwamba umefanya haya kwa dhamiri safi, kwa hiyo nimekuzuia usinitende dhambi. Ndiyo sababu sikukuacha umguse. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sasa umrudishe huyo mke wa mtu, kwa maana ni nabii, naye atakuombea nawe utaishi. Lakini kama hutamrudisha, ujue kwa hakika kuwa wewe na watu wako wote mtakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kesho yake asubuhi na mapema, Abimeleki akawaita maafisa wake wote, na baada ya kuwaambia yote yaliyotukia, waliogopa sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kisha Abimeleki akamwita Ibrahimu na kumwambia, “Wewe umetufanyia nini? Nimekukosea nini hata ukaleta hatia kubwa namna hii kwangu na kwa ufalme wangu? Umenifanyia mambo ambayo hayakupasa kufanyika.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki akamuuliza Ibrahimu, “Ulikuwa na kusudi gani kufanya hivi?” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahimu akajibu, “Niliwaza kwamba, ‘Hakika hakuna hofu ya Mungu mahali hapa, nao wataniua kwa sababu ya mke wangu.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pamoja na hayo, ni kweli kwamba yeye ni dada yangu, binti ya baba yangu ingawa si mtoto wa mama yangu; basi akawa mke wangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mungu aliponifanya nisafiri mbali na nyumbani mwa baba yangu, nilimwambia, ‘Hivi ndivyo utakavyoonesha pendo lako kwangu: Kila mahali tutakapoenda, sema hivi kunihusu, “Huyu ni kaka yangu.” ’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kisha Abimeleki akatwaa kondoo na ng’ombe, na watumwa wa kiume na wa kike, akampa Ibrahimu, na akamrudisha Sara kwa mumewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki akasema, “Nchi yangu iko mbele yako; ishi popote unapotaka.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Akamwambia Sara, “Ninampa kaka yako shekeli elfu moja za fedha. Hii ni kufidia kosa lililofanyika dhidi yako mbele ya wote walio pamoja nawe; haki yako imethibitishwa kabisa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kisha Ibrahimu akamwomba Mungu, naye Mungu akamponya Abimeleki, mke wake, na wajakazi wake ili waweze kupata watoto tena, ");
INSERT INTO swhonmm_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kwa kuwa Mwenyezi Mungu alikuwa amefunga tumbo za wanawake wote wa nyumba ya Abimeleki kwa sababu ya Sara, mke wa Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Wakati huu Mwenyezi Mungu akamrehemu Sara kama alivyokuwa amesema, na Mwenyezi Mungu akamtendea Sara kama alivyoahidi. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara akapata mimba, na akamzalia Ibrahimu mwana katika uzee wake, katika majira yale Mungu alikuwa amemwahidi. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahimu akampa huyo mwana ambaye Sara alimzalia jina Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaka alipokuwa na umri wa siku nane, Ibrahimu akamtahiri, kama Mungu alivyomwamuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahimu alikuwa na umri wa miaka mia moja Isaka mwanawe alipozaliwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara akasema, “Mungu ameniletea kicheko, na kila mmoja atakayesikia jambo hili atacheka pamoja nami.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Akaongeza kusema, “Nani angemwambia Ibrahimu kuwa Sara angenyonyesha watoto? Lakini nimemzalia mwana katika uzee wake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mtoto akakua na akaachishwa kunyonya. Siku ile Isaka aliyoachishwa kunyonya, Ibrahimu alifanya sherehe kubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lakini Sara aliona kuwa mwana ambaye Hajiri Mmisri alimzalia Ibrahimu alikuwa anadhihaki. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Hivyo Sara akamwambia Ibrahimu, “Mwondoe mjakazi huyu mtumwa pamoja na mwanawe, kwa kuwa mwana wa mjakazi huyo kamwe hatarithi na mwanangu Isaka.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Jambo hili lilimhuzunisha sana Ibrahimu kwa sababu lilimhusu mwanawe. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lakini Mungu akamwambia, “Usihuzunike hivyo kwa sababu ya kijana huyo na mjakazi wako. Sikiliza lolote Sara analokuambia, kwa sababu uzao wako utahesabiwa kupitia kwake Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nitamfanya huyu mwana wa mjakazi wako kuwa taifa pia, kwa sababu naye ni uzao wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kesho yake asubuhi na mapema, Ibrahimu akachukua chakula na kiriba cha maji, akampa Hajiri. Akaviweka begani mwa Hajiri, akamwondoa pamoja na kijana. Hajiri akashika njia, akatangatanga katika jangwa la Beer-Sheba. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Maji yalipokwisha kwenye kiriba, Hajiri akamwacha kijana chini ya kichaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kisha akaenda akaketi kama umbali wa kutupa mshale, akawaza, “Siwezi kumwangalia kijana akifa.” Akiwa ameketi pale, akaanza kulia kwa huzuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mungu akamsikia kijana akilia. Malaika wa Mungu akamwita Hajiri kutoka mbinguni na kumwambia, “Kuna nini, Hajiri? Usiogope, Mungu amesikia kijana akilia akiwa amelala pale. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mwinue kijana na umshike mkono, kwa maana nitamfanya kuwa taifa kubwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ndipo Mungu akamfumbua Hajiri macho, akaona kisima cha maji. Hivyo akaenda akajaza kiriba maji na kumpa kijana anywe. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mungu akawa pamoja na huyo kijana alipokuwa akiendelea kukua. Aliishi jangwani na akawa mpiga upinde. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Alipokuwa akiishi katika Jangwa la Parani, mama yake akamtwalia mke kutoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Wakati huo Abimeleki na Fikoli mkuu wa majeshi yake wakamwambia Ibrahimu, “Mungu yu pamoja nawe katika kila kitu unachofanya. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Sasa niapie hapa mbele za Mungu kwamba hutanitenda hila mimi, watoto wangu wala wazao wangu. Nitendee mimi na nchi ambayo unaishi kama mgeni wema ule ule ambao nimekutendea.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahimu akasema, “Ninaapa hivyo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ndipo Ibrahimu akalalamika kwa Abimeleki kuhusu kisima cha maji ambacho watumishi wa Abimeleki walikuwa wamemnyang’anya. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Lakini Abimeleki akasema, “Sijui ni nani ametenda hili. Hukuniambia, leo tu ndipo ninasikia habari zake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hivyo Ibrahimu akaleta kondoo na ng’ombe, akampa Abimeleki, nao watu hawa wawili wakafanya mapatano. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahimu akatenga kondoo jike saba kutoka kwa kundi. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki akamuuliza Ibrahimu, “Ni nini maana ya hawa kondoo jike saba uliowatenga peke yao?” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibrahimu akamjibu, “Pokea hawa kondoo jike saba kutoka mkononi mwangu kama ushahidi kuwa nilichimba kisima hiki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hivyo mahali pale pakaitwa Beer-Sheba, kwa sababu watu hao wawili waliapiana hapo. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Baada ya mapatano kufanyika huko Beer-Sheba, Abimeleki na Fikoli mkuu wa majeshi yake wakarudi nchi ya Wafilisti. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahimu akapanda mti wa mkwaju huko Beer-Sheba, na hapo akaliitia jina la Mwenyezi Mungu, Mungu wa milele. ");
INSERT INTO swhonmm_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Naye Ibrahimu akakaa nchi ya Wafilisti kwa muda mrefu. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Baadaye Mungu akamjaribu Ibrahimu. Akamwambia, “Ibrahimu!” Ibrahimu akamjibu, “Mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kisha Mungu akamwambia, “Mchukue mwanao, mwana wako wa pekee umpendaye, Isaka, uende nchi ya Moria. Mtoe kama sadaka ya kuteketezwa juu ya mlima nitakaokuambia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibrahimu akaamka asubuhi na mapema siku iliyofuata, akamtayarisha punda wake. Akawachukua watumishi wake wawili pamoja na Isaka mwanawe. Baada ya kuchanja kuni za kutosha kwa ajili ya hiyo sadaka ya kuteketezwa, akaondoka kuelekea mahali Mungu alipokuwa amemwambia. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siku ya tatu Ibrahimu akainua macho, akapaona mahali pale kwa mbali. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Akawaambia watumishi wake, “Kaeni hapa pamoja na punda, wakati mimi na kijana tunaenda kule. Tutaabudu na kisha tutawarudia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahimu akachukua kuni kwa ajili ya sadaka ya kuteketezwa, akamtwika Isaka mwanawe, naye mwenyewe akachukua moto na kisu. Walipokuwa wakienda pamoja, ");
INSERT INTO swhonmm_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka akamwambia Ibrahimu baba yake, “Baba yangu!” Ibrahimu akaitika, “Mimi hapa, mwanangu.” Isaka akasema, “Moto na kuni zipo. Je, yuko wapi mwana-kondoo kwa ajili ya sadaka ya kuteketezwa?” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahimu akajibu, “Mwanangu, Mungu mwenyewe atajipatia mwana-kondoo kwa ajili ya hiyo sadaka ya kuteketezwa.” Nao hawa wawili wakaendelea mbele pamoja. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Walipofika mahali pale alipokuwa ameambiwa na Mungu, Ibrahimu akajenga madhabahu hapo, akaziweka kuni juu yake. Akamfunga Isaka mwanawe na akamlaza kwenye madhabahu, juu ya zile kuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kisha akanyoosha mkono wake na akachukua kisu ili amchinje mwanawe. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Lakini malaika wa Mwenyezi Mungu akamwita kutoka mbinguni, akamwambia, “Ibrahimu! Ibrahimu!” Akajibu, “Mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Akamwambia, “Usimdhuru kijana, wala usimtendee jambo. Sasa ninajua kwamba unamcha Mungu, kwa sababu hukunizuilia mwanao, mwana wako wa pekee.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahimu akainua macho, akaona nyuma yake kondoo dume akiwa amenaswa pembe zake katika kichaka. Akaenda akamchukua huyo kondoo dume, akamtoa awe sadaka ya kuteketezwa badala ya mwanawe. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahimu akapaita mahali pale Yehova-Yire. Hadi leo inasemekana, “Katika mlima wa Mwenyezi Mungu itapatikana.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Basi malaika wa Mwenyezi Mungu akamwita Ibrahimu kutoka mbinguni mara ya pili, ");
INSERT INTO swhonmm_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","akasema, “Ninaapa kwa nafsi yangu, asema Mwenyezi Mungu, kwa sababu umefanya jambo hili na hukunizuilia mwanao, mwana wako wa pekee: ");
INSERT INTO swhonmm_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Hakika nitakubariki, na nitauzidisha uzao wako kama nyota za angani na kama mchanga wa pwani. Wazao wako watamiliki miji ya adui zao, ");
INSERT INTO swhonmm_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","na kupitia uzao wako mataifa yote duniani yatabarikiwa, kwa sababu umenitii.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ndipo Ibrahimu akawarudia watumishi wake, wakaondoka wote, wakaenda hadi Beer-Sheba. Naye Ibrahimu akaishi huko Beer-Sheba. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Baada ya muda, Ibrahimu akaambiwa, “Milka pia amepata watoto; amemzalia ndugu yako Nahori wana: ");
INSERT INTO swhonmm_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usi mzaliwa wake wa kwanza, Buzi nduguye, Kemueli (baba wa Aramu), ");
INSERT INTO swhonmm_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Hazo, Pildashi, Yidlafu na Bethueli.” ");
INSERT INTO swhonmm_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethueli akamzaa Rebeka. ");
INSERT INTO swhonmm_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Suria wake Nahori aliyeitwa Reuma pia alizaa wana: Teba, Gahamu, Tahashi na Maaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara aliishi miaka mia moja na ishirini na saba (127). ");
INSERT INTO swhonmm_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara akafa huko Kiriath-Arba (yaani Hebroni) katika nchi ya Kanaani, naye Ibrahimu akalia na kumwomboleza Sara. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ndipo Ibrahimu akainuka kutoka pale penye maiti ya mke wake. Akazungumza na Wahiti, akasema, ");
INSERT INTO swhonmm_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mimi ni mpitaji na mgeni miongoni mwenu. Niuzieni sehemu ya ardhi yenu ili niweze kumzika maiti wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahiti wakamjibu Ibrahimu, ");
INSERT INTO swhonmm_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Bwana, tusikilize. Wewe ni mtawala mkuu sana miongoni mwetu. Zika maiti wako katika kaburi unalolipenda kati ya makaburi yetu. Hakuna mtu wa kwetu atakayekuzuia kaburi lake ili kuzika maiti wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibrahimu akainuka, akasujudu mbele ya Wahiti, wenyeji wa nchi hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Akawaambia, “Kama mnaniruhusu kumzika maiti wangu, basi nisikilizeni, mkamsihi Efroni mwana wa Sohari kwa niaba yangu ");
INSERT INTO swhonmm_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ili aniuzie pango la Makpela, lililo mali yake, nalo liko mwisho wa shamba lake. Mwambieni aniuzie kwa bei kamili atakayosema ili liwe mahali pangu pa kuzikia miongoni mwenu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efroni Mhiti alikuwa ameketi miongoni mwa watu wake; akamjibu Ibrahimu mbele ya Wahiti wote waliokuwa katika lango la mji: ");
INSERT INTO swhonmm_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“La, bwana wangu, nisikilize. Nakupa shamba, na pia nakupa pango lililo ndani yake. Nakupa mbele ya watu wangu, uzike maiti wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahimu akasujudu tena mbele ya wenyeji wa nchi, ");
INSERT INTO swhonmm_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","akamwambia Efroni wale watu wakiwa wanasikia, “Tafadhali nisikilize. Nitakulipa fedha za hilo shamba. Kubali kuzipokea ili niweze kumzika maiti wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni akamjibu Ibrahimu, ");
INSERT INTO swhonmm_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Nisikilize, bwana wangu, thamani ya ardhi hiyo ni shekeli mia nne za fedha, lakini hiyo ni nini kati yako na mimi? Mzike maiti wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahimu akakubali masharti ya Efroni, akampimia ile fedha aliyotaja masikioni mwa Wahiti: shekeli mia nne za fedha kulingana na viwango vya uzito vilivyokuwa vikitumika wakati huo na wafanyabiashara. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Hivyo shamba la Efroni huko Makpela karibu na Mamre, yaani shamba pamoja na pango lililokuwamo, nayo miti yote iliyokuwa ndani ya mipaka ya shamba hilo, vilikabidhiwa ");
INSERT INTO swhonmm_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kwa Ibrahimu kuwa mali yake mbele ya Wahiti wote waliokuwa wamekuja kwenye lango la mji. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Baada ya hayo Ibrahimu akamzika Sara mkewe kwenye pango ndani ya shamba la Makpela karibu na Mamre (huko Hebroni) katika nchi ya Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hivyo Wahiti wakamkabidhi Ibrahimu shamba pamoja na pango lililokuwa humo kuwa mahali pa kuzikia. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Wakati huu Ibrahimu alikuwa mzee mwenye miaka mingi, naye Mwenyezi Mungu alikuwa amembariki katika mambo yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibrahimu akamwambia mtumishi wake mkuu katika nyumba yake, aliyekuwa msimamizi wa mali yake yote, “Weka mkono wako chini ya paja langu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ninataka uape kwa Mwenyezi Mungu, Mungu wa mbingu na Mungu wa nchi, kwamba hutamtwalia mwanangu mke kutoka binti za Wakanaani, ambao ninaishi miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bali nenda katika nchi yangu na jamaa zangu umpatie Isaka mwanangu mke.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yule mtumishi akamuuliza, “Je, itakuwaje huyo mwanamke akikataa kuja nami katika nchi hii? Je, nimrudishe mwanao katika hiyo nchi uliyotoka?” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahimu akasema, “Hakikisha kwamba hutamrudisha mwanangu huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mwenyezi Mungu, Mungu wa mbingu, alinitoa nyumbani mwa baba yangu na nchi yangu niliyozaliwa. Ndiye alisema nami na akaniahidi kwa kiapo, akasema, ‘Nitawapa uzao wako nchi hii.’ Yeye atatuma malaika wake akutangulie ili umtwalie mwanangu mke kutoka huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Huyo mwanamke asipokubali kufuatana nawe, basi utafunguliwa kutoka kiapo nilichokuapisha. Ila usimrudishe mwanangu huko.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Basi yule mtumishi akaweka mkono wake chini ya paja la bwana wake Ibrahimu, akamwapia kuhusu shauri hili. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ndipo huyo mtumishi akachukua ngamia kumi miongoni mwa ngamia wa bwana wake, akaondoka, akiwa amechukua aina zote za vitu vizuri kutoka kwa bwana wake. Akaelekea Mesopotamia, akaenda hadi mji wa Nahori. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Akawapigisha ngamia magoti karibu na kisima cha maji nje ya mji; ilikuwa inaelekea jioni, wakati wanawake huteka maji. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kisha akaomba, “Ee Mwenyezi Mungu, Mungu wa bwana wangu Ibrahimu, nipatie ushindi leo, uoneshe ukarimu kwa bwana wangu Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tazama, nimesimama karibu na kisima hiki cha maji, nao binti za watu wa mji huu wanakuja kuteka maji. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Basi na iwe hivi, nitakapomwambia binti mmoja, ‘Tafadhali tua mtungi wako nipate kunywa maji’; naye akisema, ‘Kunywa, nitawanywesha na ngamia wako pia’: basi na awe ndiye uliyemchagulia mtumishi wako Isaka. Kwa hili nitajua umemtendea bwana wangu ukarimu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ikawa kabla hajamaliza kuomba, Rebeka akatokea akiwa na mtungi begani mwake. Alikuwa binti Bethueli. Bethueli alikuwa mwana wa Milka, aliyekuwa mke wa Nahori ndugu wa Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Huyu msichana alikuwa mzuri sana wa sura, bikira, ambaye hakuna mwanaume aliyekuwa amekutana naye kimwili. Aliteremka kisimani, akajaza mtungi wake, tena akapanda juu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ndipo yule mtumishi akaharakisha kukutana naye, akamwambia, “Tafadhali nipe maji kidogo katika mtungi wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Yule msichana akasema, “Kunywa, bwana wangu.” Akashusha kwa haraka mtungi mkononi mwake na akampa, akanywa. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Baada ya kumpa yule mtumishi yale maji, akamwambia, “Nitawatekea ngamia wako maji pia hadi wote watosheke.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Akafanya haraka kumimina maji kwenye birika ya kunyweshea wanyama, akakimbia kisimani kuteka maji mengine, na akateka ya kuwatosha ngamia wake wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Pasipo kusema neno, yule mtumishi akamtazama kwa makini aone kama Mwenyezi Mungu ameifanikisha safari yake, au la. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ikawa ngamia walipokwisha kunywa wote, yule mtumishi akampa huyo msichana pete ya puani ya dhahabu yenye uzito wa beka moja, na bangili mbili za dhahabu zenye uzito wa shekeli kumi. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kisha akamuuliza, “Wewe ni binti ya nani? Tafadhali niambie. Je, kuna nafasi katika nyumba ya baba yako tunapoweza kulala?” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Yule msichana akamjibu, “Mimi ni binti ya Bethueli, mwana wa Milka aliyemzalia Nahori.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Akaendelea kusema, “Kwetu kuna majani mengi na malisho, tena kuna nafasi kwa ajili yenu kulala.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Yule mtumishi akasujudu na kumwabudu Mwenyezi Mungu, ");
INSERT INTO swhonmm_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","akisema, “Atukuzwe Mwenyezi Mungu, Mungu wa bwana wangu Ibrahimu, ambaye hakuondoa wema na uaminifu wake kwa bwana wangu. Mimi nami, Mwenyezi Mungu ameniongoza safarini, akanifikisha nyumbani kwa jamaa za bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Yule msichana akakimbia, akawaeleza watu wa nyumbani mwa mama yake kuhusu mambo haya. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka alikuwa na kaka aliyeitwa Labani; huyo akaharakisha kukutana na yule mtumishi kule kisimani. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mara alipoiona ile pete puani, na bangili mikononi mwa dada yake, na kusikia yale maneno Rebeka aliyoambiwa na huyo mtumishi, alimwendea huyo mtumishi, akamkuta amesimama karibu na ngamia wake pale karibu na kisima. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Akamwambia, “Karibu nyumbani wewe uliyebarikiwa na Mwenyezi Mungu. Kwa nini unasimama huko nje? Mimi nimekuandalia nyumba na mahali kwa ajili ya ngamia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hivyo yule mtumishi akaingia nyumbani, nayo mizigo ikaondolewa juu ya ngamia. Majani na malisho yakaletwa kwa ajili ya ngamia, na maji kwa ajili yake na watu wake ili kunawa miguu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ndipo chakula kikaandaliwa kwa ajili yake, lakini akasema, “Sitakula hadi niwe nimewaambia yale niliyo nayo ya kusema.” Labani akasema, “Basi tuambie.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hivyo akasema, “Mimi ni mtumishi wa Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mwenyezi Mungu amembariki sana bwana wangu, amekuwa tajiri. Amempa kondoo na ng’ombe, fedha na dhahabu, watumishi wa kiume na wa kike, ngamia na punda. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara mkewe bwana wangu amemzalia mwana katika uzee wake, naye amempa kila kitu alichokuwa nacho. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Naye bwana wangu ameniapisha na akasema, ‘Kamwe usimtwalie mwanangu mke katika binti za Wakanaani, ambao ninaishi katika nchi yao, ");
INSERT INTO swhonmm_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ila uende hadi kwa jamaa ya baba yangu na ukoo wangu mwenyewe, ukamtwalie mwanangu mke huko.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Kisha nikamuuliza bwana wangu, ‘Je, kama huyo mwanamke hatakubali kurudi nami?’ ");
INSERT INTO swhonmm_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Akanijibu, ‘Mwenyezi Mungu, ambaye nimetembea mbele zake, atatuma malaika wake pamoja nawe, na kuifanikisha safari yako, ili uweze kupata mke kwa ajili ya mwanangu katika ukoo wangu na kutoka jamaa ya baba yangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kisha, utakapoenda kwenye ukoo wangu, utakuwa umefunguliwa kutoka kiapo changu. Hata wakikataa kukupa huyo binti, utakuwa umefunguliwa kutoka kiapo changu.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Nilipokuja kisimani leo nilisema, ‘Ee Mwenyezi Mungu, Mungu wa bwana wangu Ibrahimu, ikikupendeza, naomba uifanikishe safari niliyoijia. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tazama, ninasimama kando ya kisima hiki. Mwanamwali akija kuteka maji, nami nikimwambia: Tafadhali niruhusu ninywe maji kidogo kutoka mtungi wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Naye akiniambia, “Kunywa, nami nitawatekea ngamia wako maji pia,” basi huyo awe ndiye mke Mwenyezi Mungu amemchagulia mwana wa bwana wangu.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kabla sijamaliza kuomba moyoni mwangu, Rebeka akatokea, na mtungi begani mwake. Akashuka kisimani, akateka maji, nami nikamwambia, ‘Tafadhali nipe maji ninywe.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Akafanya haraka kushusha mtungi wake begani na kusema, ‘Kunywa, na nitawanywesha ngamia wako pia.’ Basi nikanywa, naye akawanywesha na ngamia pia. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Nikamuuliza, ‘Wewe ni binti ya nani?’ “Akasema, ‘Mimi ni binti ya Bethueli, mwana wa Nahori, Milka aliyemzalia.’ “Ndipo nilipotia pete puani mwake na bangili mikononi mwake, ");
INSERT INTO swhonmm_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","nikasujudu na nikamwabudu Mwenyezi Mungu. Nikamtukuza Mwenyezi Mungu, Mungu wa bwana wangu Ibrahimu, aliyeniongoza katika njia sahihi ili nimtwalie mwana na bwana wangu mke katika jamaa zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ikiwa mtaonesha wema na uaminifu kwa bwana wangu, mniambie; la sivyo, mniambie, ili niweze kujua njia ya kugeukia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani na Bethueli wakajibu, “Jambo hili limetoka kwa Mwenyezi Mungu; hatuwezi kukuambia jambo lolote baya au jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka yuko hapa, mchukue na uende, awe mke wa mwana wa bwana wako, sawasawa na Mwenyezi Mungu alivyoongoza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ikawa huyo mtumishi wa Ibrahimu aliposikia waliyosema, alisujudu, uso wake ukagusa chini mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ndipo huyo mtumishi akatoa vitu vilivyotengenezwa kwa dhahabu na kwa fedha, pamoja na mavazi, akampa Rebeka; pia akawapa zawadi za thamani kubwa nduguye na mamaye. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kisha yeye na wale watu waliokuwa pamoja naye wakala, wakanywa na kulala palepale. Walipoamka asubuhi, yule mtumishi akasema, “Nipeni ruhusa nirudi kwa bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Lakini ndugu yake Rebeka pamoja na mama yake wakajibu, “Acha binti akae kwetu siku kumi au zaidi, ndipo mwondoke.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lakini yule mtumishi akawaambia, “Msinicheleweshe, kwa kuwa Mwenyezi Mungu amefanikisha safari yangu. Nipeni ruhusa nirudi kwa bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ndipo wakasema, “Acha tumwite huyo binti tumuulize, tusikie atakavyosema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kwa hiyo wakamwita Rebeka na kumuuliza, “Je, utaenda na mtu huyu?” Akasema, “Nitaenda.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hivyo wakamwaga ndugu yao Rebeka aondoke, pamoja na mjakazi wake, na mtumishi wa Ibrahimu na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wakambariki Rebeka, wakamwambia, “Ndugu yetu, uwe wewe kumi elfu, mara elfu nyingi; nao wazao wako wamiliki malango ya adui zao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka na vijakazi wake wakajiandaa, wakapanda ngamia wao, wakafuatana na yule mtu. Hivyo yule mtumishi akamchukua Rebeka, wakaondoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Basi Isaka alikuwa ametoka Beer-Lahai-Roi, kwa kuwa alikuwa akiishi nchi ya Negebu. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaka akaenda shambani kutafakari wakati wa jioni; alipoinua macho yake, akaona ngamia wanakuja. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka pia akainua macho, akamwona Isaka. Akashuka kutoka ngamia wake, ");
INSERT INTO swhonmm_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","akamuuliza yule mtumishi, “Ni nani mtu yule kule shambani anayekuja kutulaki?” Yule mtumishi akajibu, “Huyu ndiye bwana wangu.” Hivyo Rebeka akachukua shela yake, akajifunika. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kisha yule mtumishi akamweleza Isaka mambo yote aliyoyatenda. ");
INSERT INTO swhonmm_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka akamwingiza Rebeka katika hema la Sara mama yake. Isaka akamchukua Rebeka, hivyo akawa mke wake. Isaka akampenda; akafarijika baada ya kifo cha mama yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahimu alioa mke mwingine aliyeitwa Ketura. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Huyu alimzalia Zimrani, Yokshani, Medani, Midiani, Ishbaki na Shua. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokshani alikuwa baba wa Sheba na Dedani; wazao wa Dedani walikuwa Waashuru, Waletushi na Waleumi. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wana wa Midiani walikuwa Efa, Eferi, Hanoki, Abida na Eldaa. Hawa wote walikuwa uzao wa Ketura. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahimu akamwachia Isaka kila kitu alichokuwa nacho. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Lakini Ibrahimu alipokuwa bado hai, akawapa watoto wa masuria wake zawadi, kisha akawaondoa waende kuishi pande za mashariki mbali na mwanawe Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Kwa jumla, Ibrahimu aliishi miaka mia moja na sabini na tano (175). ");
INSERT INTO swhonmm_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ndipo Ibrahimu akapumua pumzi ya mwisho na akafa akiwa mwenye umri mzuri, mzee aliyeshiba siku; naye akakusanywa pamoja na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Watoto wake Isaka na Ishmaeli wakamzika katika pango la Makpela karibu na Mamre, katika shamba lililokuwa la Efroni mwana wa Sohari Mhiti, ");
INSERT INTO swhonmm_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","shamba ambalo Ibrahimu alilinunua kwa Wahiti. Hapo ndipo Ibrahimu alipozikwa pamoja na mkewe Sara. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Baada ya kifo cha Ibrahimu, Mungu akambariki mwanawe Isaka, ambaye baadaye aliishi karibu na Beer-Lahai-Roi. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hivi ndivyo vizazi vya Ishmaeli mwana wa Ibrahimu, ambaye Hajiri Mmisri, mjakazi wa Sara, alimzalia Ibrahimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Haya ndiyo majina ya wana wa Ishmaeli, walioorodheshwa kulingana na jinsi walivyozaliwa: Mzaliwa wa kwanza wa Ishmaeli ni Nebayothi, akafuatia Kedari, Adbeeli, Mibsamu, ");
INSERT INTO swhonmm_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO swhonmm_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yeturi, Nafishi na Kedema. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hawa walikuwa wana wa Ishmaeli, na haya ni majina ya viongozi wa makabila yao kumi na mbili, kufuatana na makazi yao na kambi zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kwa jumla Ishmaeli aliishi miaka mia moja na thelathini na saba (137). Akapumua pumzi ya mwisho, akafa, naye akakusanywa pamoja na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Wazao wa Ishmaeli waliishi kuanzia nchi ya Havila hadi Shuri, karibu na mpaka wa Misri, kuelekea Ashuru. Hao waliishi kwa uhasama na ndugu zao wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hivi ndivyo vizazi vya Isaka mwana wa Ibrahimu. Ibrahimu akamzaa Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka alikuwa na umri wa miaka arobaini alipomwoa Rebeka binti Bethueli Mwaramu kutoka Padan-Aramu, nduguye Labani Mwaramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka akamwomba Mwenyezi Mungu kwa ajili ya mke wake, kwa sababu alikuwa tasa. Mwenyezi Mungu akajibu maombi yake na Rebeka mkewe akapata mimba. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Watoto wakashindana tumboni mwake, naye akasema, “Kwa nini haya yanatokea kwangu?” Kwa hiyo akaenda kumuuliza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mwenyezi Mungu akamjibu, “Mataifa mawili yamo tumboni mwako, na mataifa hayo mawili kutoka ndani yako watatenganishwa. Mmoja atakuwa na nguvu kuliko mwingine, na yule mkubwa atamtumikia yule mdogo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wakati wake wa kujifungua ulipotimia, walikuwepo mapacha wa kiume tumboni mwake. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wa kwanza kuzaliwa alikuwa mwekundu, na mwili wake wote ulikuwa kama mtu aliyevaa vazi lenye nywele; wakamwita jina Esau. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Baadaye, ndugu yake akatoka, mkono wake ukiwa umemshika Esau kisigino; akaitwa jina Yakobo. Isaka alikuwa na umri wa miaka sitini Rebeka alipowazaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Watoto wakakua. Esau akawa mwindaji hodari, mtu wa mbugani, naye Yakobo akawa mtu mtulivu, mwenye kukaa nyumbani. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka, aliyekuwa anapendelea zaidi nyama za porini, alimpenda Esau, bali Rebeka alimpenda Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Siku moja Yakobo alipika mchuzi wa dengu. Esau akarudi kutoka porini akiwa na njaa kali. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau akamwambia Yakobo, “Haraka, nipe huo mchuzi mwekundu! Nina njaa kali sana!” (Hii ndiyo sababu pia aliitwa Edomu.) ");
INSERT INTO swhonmm_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo akamjibu, “Niuzie kwanza haki yako ya mzaliwa wa kwanza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau akasema, “Tazama, mimi niko karibu kufa, itanifaa nini haki ya mzaliwa wa kwanza?” ");
INSERT INTO swhonmm_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo akamwambia, “Niapie kwanza.” Hivyo Esau akamwapia, akamuuzia Yakobo haki yake ya mzaliwa wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ndipo Yakobo akampa Esau mkate na ule mchuzi wa dengu, naye akala na kunywa, kisha akainuka akaenda zake. Kwa hiyo Esau akaidharau haki yake ya mzaliwa wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Basi njaa kubwa ikatokea katika nchi hiyo, mbali na njaa iliyotokea wakati wa Ibrahimu. Isaka akaenda kwa Abimeleki mfalme wa Wafilisti huko Gerari. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mwenyezi Mungu akamtokea Isaka, akamwambia, “Usiende Misri, bali ukae katika nchi nitakayokuambia. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kaa katika nchi hii kwa kitambo; mimi nitakuwa pamoja na wewe na nitakubariki. Kwa maana nitakupa wewe na uzao wako nchi hizi zote, na nitatimiza kiapo nilichomwapia Ibrahimu baba yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nitafanya wazao wako kuwa wengi kama nyota za angani, nami nitawapa nchi hizi zote, na kupitia uzao wako mataifa yote yatabarikiwa, ");
INSERT INTO swhonmm_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kwa sababu Ibrahimu alinitii mimi, na akatenda yote niliyomwagiza, akahifadhi amri zangu, na hukumu zangu, pamoja na sheria zangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hivyo Isaka akaishi huko Gerari. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wanaume wa mahali pale walipomuuliza habari za mke wake, akasema, “Huyu ni dada yangu,” kwa sababu aliogopa kusema, “Huyu ni mke wangu.” Alifikiri, “Wanaume wa huku wanaweza kuniua kwa sababu ya Rebeka, kwa kuwa ni mzuri wa sura.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka alipokuwa amekaa huko siku nyingi, Abimeleki mfalme wa Wafilisti akachungulia dirishani, akaona Isaka akimpapasa Rebeka, mke wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki akamwita Isaka, akamwambia, “Hakika huyu ni mke wako! Mbona uliniambia, ‘Huyu ni dada yangu’?” Isaka akamjibu, “Kwa sababu nilifikiri ningeweza kuuawa kwa sababu yake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ndipo Abimeleki akamjibu, “Ni nini hiki ulichotutendea? Ingewezekana mtu yeyote akakutana kimwili na mke wako, nawe ungeleta hatia kwetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hivyo Abimeleki akatoa amri kwa watu wote, akisema, “Yeyote atakayemnyanyasa mtu huyu au mkewe hakika atauawa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka akapanda mazao katika nchi hiyo, na kwa mwaka huo huo akavuna mara mia, kwa sababu Mwenyezi Mungu alimbariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka akawa tajiri, nayo mali yake ikaendelea kuongezeka hata akawa tajiri sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Akawa na mifugo ya kondoo na ng’ombe, na watumishi wengi sana, kiasi kwamba Wafilisti wakamwonea wivu. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kwa hiyo visima vyote vilivyochimbwa na watumishi wakati wa Ibrahimu baba yake, Wafilisti wakavifukia, wakavijaza udongo. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ndipo Abimeleki akamwambia Isaka, “Ondoka kwetu, kwa maana umetuzidi nguvu sana.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Basi Isaka akatoka huko, akajenga kambi katika Bonde la Gerari, akaishi huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ndipo Isaka akavichimbua tena vile visima vya maji ambavyo vilichimbwa siku zile za Ibrahimu baba yake, ambavyo Wafilisti walivifukia baada ya Ibrahimu kufa, akavipa majina yale yale ambayo baba yake alikuwa amevipa. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Watumishi wa Isaka wakachimba katika lile bonde, wakagundua huko kisima chenye maji safi. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lakini wachungaji wa Gerari wakagombana na wachungaji wa Isaka wakisema, “Maji haya ni yetu!” Ndipo akakiita kile kisima Eseki, kwa sababu waligombana naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kisha wakachimba kisima kingine, lakini hata hicho pia wakakigombania; akakiita Sitna. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Akaondoka huko, akachimba kisima kingine, wala hakuna yeyote aliyekigombania. Akakiita Rehobothi, akisema, “Sasa Mwenyezi Mungu ametufanyia nafasi, nasi tutastawi katika nchi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kutoka pale akaenda Beer-Sheba. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Usiku ule Mwenyezi Mungu akamtokea, akamwambia, “Mimi ndimi Mungu wa Ibrahimu baba yako. Usiogope, kwa maana mimi niko pamoja nawe. Nitakubariki na kuongeza idadi ya wazao wako kwa ajili ya Ibrahimu mtumishi wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka akajenga madhabahu huko, akaliitia jina la Mwenyezi Mungu. Akapiga hema lake huko, nao watumishi wake wakachimba kisima. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Wakati huo, Abimeleki alikuwa amemjia kutoka Gerari, akifuatana na Ahuzathi mshauri wake, pamoja na Fikoli jemadari wa majeshi yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka akawauliza, “Mbona mmekuja kwangu, na ninyi mlinichukia na kunifukuza?” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wakamjibu, “Tuliona wazi kuwa Mwenyezi Mungu alikuwa pamoja nawe, kwa hiyo tukasema, ‘Inabidi kuwe na kiapo cha mapatano kati yetu,’ yaani kati yetu na wewe. Na tufanye mkataba pamoja nawe, ");
INSERT INTO swhonmm_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kwamba hutatudhuru, kama vile nasi hatukuwanyanyasa bali tuliwatendea mema wakati wote, na tukawaaga kwa amani. Tena sasa umebarikiwa na Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Basi Isaka akawaandalia karamu, nao wakala na kunywa. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kesho yake asubuhi na mapema wakaapiana. Kisha Isaka akawaruhusu waende zao, wakamwacha kwa amani. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siku hiyo watumishi wa Isaka wakaja, wakampa habari kuhusu kisima walichokuwa wamekichimba, wakamwambia, “Tumepata maji!” ");
INSERT INTO swhonmm_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Naye akakiita Shiba; hadi leo mji huo unaitwa Beer-Sheba. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau alipokuwa na umri wa miaka arobaini, akamwoa Yudithi binti Beeri Mhiti, kisha akamwoa Basemathi binti Eloni Mhiti. ");
INSERT INTO swhonmm_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Hawa walikuwa chanzo cha huzuni kwa Isaka na Rebeka. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka alipokuwa mzee na macho yake yakapofuka kwa kukosa nguvu, akamwita Esau mwanawe mkubwa, akamwambia, “Mwanangu.” Akajibu, “Mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka akasema, “Mimi sasa ni mzee na sijui siku ya kufa kwangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sasa basi chukua silaha zako, podo na upinde, uende nyikani, ukaniwindie mawindo. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Uniandalie chakula kitamu nikipendacho uniletee nile, ili nikubariki kabla sijafa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka alikuwa akisikiliza Isaka akizungumza na mwanawe Esau. Basi Esau alipoenda nyikani kuwinda mawindo ayalete, ");
INSERT INTO swhonmm_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka akamwambia Yakobo mwanawe, “Tazama, nimemsikia baba yako akimwambia ndugu yako Esau, ");
INSERT INTO swhonmm_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Niletee mawindo, kisha ukaniandalie chakula kitamu nile, ili nikubariki mbele za Mwenyezi Mungu kabla sijafa.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Sasa mwanangu, nisikilize kwa makini na ufanye yale ninayokuambia: ");
INSERT INTO swhonmm_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nenda sasa katika kundi ukaniletee wana-mbuzi wawili wazuri, ili nimwandalie baba yako chakula kitamu kile anachokipenda. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kisha umpelekee baba yako ale, ili akubariki kabla hajafa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobo akamwambia Rebeka mama yake, “Lakini ndugu yangu Esau ana nywele mwilini, nami nina ngozi nyororo. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Itakuwaje baba yangu akinigusa? Ataona kama ninamfanyia ujanja, nami nijiletee laana badala ya baraka.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mama yake akamwambia, “Mwanangu, laana na iwe juu yangu. Fanya tu ninalokuambia: nenda ukaniletee hao wana-mbuzi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kwa hiyo alienda akawaleta, akampa mama yake, naye Rebeka akaandaa chakula kitamu, kile alichokipenda baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kisha Rebeka akachukua nguo nzuri za Esau mwanawe wa kwanza, alizokuwa nazo nyumbani, akamvika Yakobo mwanawe mdogo. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Pia akamfunika mikononi na sehemu laini ya shingo kwa ngozi za mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hatimaye akampa Yakobo hicho chakula kitamu pamoja na mkate aliouoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobo akaenda kwa baba yake, akasema, “Baba yangu.” Akajibu, “Naam, mwanangu. Wewe ni nani?” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo akamwambia baba yake, “Mimi ni Esau mzaliwa wako wa kwanza. Nimefanya kama ulivyoniambia. Tafadhali uketi, ule sehemu ya mawindo yangu ili unibariki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka akamuuliza mwanawe, “Umepataje mawindo haraka hivi, mwanangu?” Akajibu, “Mwenyezi Mungu, Mungu wako, amenifanikisha.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kisha Isaka akamwambia Yakobo, “Mwanangu, tafadhali sogea karibu nami ili nikupapase, nione kama hakika ndiwe Esau mwanangu, au la.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo akasogea karibu na baba yake Isaka, ambaye alimpapasa na kusema, “Sauti ni ya Yakobo, bali mikono ni ya Esau.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hakumtambua, kwa sababu mikono yake ilikuwa na nywele kama ya ndugu yake Esau, kwa hiyo akambariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Akamuuliza, “Kweli wewe ni mwanangu Esau?” Akajibu, “Ni mimi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kisha Isaka akasema, “Mwanangu, niletee sehemu ya mawindo yako nile, ili nikubariki.” Yakobo akamletea, naye akala; kisha akamletea na divai akanywa. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ndipo Isaka baba yake akamwambia, “Njoo hapa, mwanangu, unibusu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kwa hiyo akamwendea akambusu. Isaka aliposikia harufu ya nguo zake, akambariki, akasema, “Aha, harufu ya mwanangu ni kama harufu ya shamba ambalo Mwenyezi Mungu amelibariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mungu na akupe umande wa mbinguni na utajiri wa duniani: wingi wa nafaka na divai mpya. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mataifa yakutumikie, na mataifa yakusujudie. Uwe bwana juu ya ndugu zako, na wana wa mama yako wakusujudie. Walaaniwe wale wanaokulaani, na wabarikiwe wale wanaokubariki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Baada ya Isaka kumbariki Yakobo, na punde tu alipoondoka kwa baba yake, ndugu yake Esau akaingia kutoka mawindoni. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Naye pia akaandaa chakula kitamu, akamletea baba yake. Kisha akamwambia, “Baba yangu, keti ule sehemu ya mawindo yangu, ili upate kunibariki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka baba yake akamuuliza, “Wewe ni nani?” Akamjibu, “Mimi ni mwanao, mzaliwa wako wa kwanza, Esau.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka akatetemeka kwa nguvu sana, akasema, “Alikuwa nani basi, ambaye aliwinda mawindo akaniletea? Nilikula kabla tu hujaja na nikambariki, naye hakika atabarikiwa!” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau aliposikia maneno haya ya baba yake, akalia kwa sauti kubwa na ya uchungu, na kumwambia baba yake, “Nibariki! Nibariki mimi pia, baba yangu!” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lakini akamjibu, “Ndugu yako amekuja kwa udanganyifu, akachukua baraka yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau akasema, “Si ndiyo sababu anaitwa Yakobo? Amenidanganya mara hizi mbili: Alichukua haki yangu ya kuzaliwa na sasa amechukua baraka yangu!” Kisha akauliza, “Hukubakiza hata baraka moja kwa ajili yangu?” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka akamjibu Esau, “Nimemfanya yeye kuwa bwana juu yako; pia nimewafanya ndugu zako wote kuwa watumishi wake, na nimemtegemeza kwa nafaka na divai mpya. Sasa nitaweza kukufanyia nini, mwanangu?” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau akamwambia baba yake, “Je, baba yangu una baraka moja tu? Unibariki mimi pia, baba yangu!” Kisha Esau akalia kwa sauti kubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Baba yake Isaka akamjibu, “Makao yako yatakuwa mbali na utajiri wa dunia, mbali na umande wa mbinguni. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Utaishi kwa upanga, nawe utamtumikia ndugu yako. Lakini utakapokuwa umejikomboa, utatupa nira yake kutoka shingoni mwako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau akawa na kinyongo dhidi ya Yakobo kwa ajili ya baraka ambazo baba yake alikuwa amembariki. Akasema moyoni mwake, “Siku za kuomboleza kwa ajili ya baba yangu zimekaribia; ndipo nitamuua ndugu yangu Yakobo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka alipoambiwa yale Esau mwanawe mkubwa aliyoyasema, akamtumania Yakobo mwanawe mdogo, akamwambia, “Ndugu yako Esau anajifariji kwa wazo la kukuua. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Sasa basi, mwanangu, fanya nisemalo: Kimbilia haraka kwa Labani ndugu yangu kule Harani. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ukae naye kwa muda hadi ghadhabu ya ndugu yako itulie. ");
INSERT INTO swhonmm_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ndugu yako atakapokuwa hana hasira nawe tena na amesahau uliyomtendea, nitakupelekea ujumbe urudi. Kwa nini niwapoteze nyote wawili siku moja?” ");
INSERT INTO swhonmm_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kisha Rebeka akamwambia Isaka, “Nimechukia maisha kwa sababu ya hawa wanawake Wahiti. Ikiwa Yakobo ataoa mke miongoni mwa wanawake wa nchi hii, wanawake Wahiti kama hawa, sitaona haja ya kuendelea kuishi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Basi Isaka akamwita Yakobo, akambariki na akamwamuru, akisema, “Usioe mwanamke Mkanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nenda mara moja hadi Padan-Aramu, kwenye nyumba ya Bethueli, baba wa mama yako. Uchukue mke kati ya binti za Labani ambaye ni ndugu wa mama yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mungu Mwenyezi na akubariki, uwe na uzao, uongezeke idadi yako hadi upate kuwa jamii kubwa ya watu. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Akupe wewe na uzao wako baraka aliyopewa Ibrahimu, upate kumiliki nchi unayoishi sasa kama mgeni, nchi ambayo Mungu alimpa Ibrahimu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kisha Isaka akamuaga Yakobo, naye akaenda Padan-Aramu, kwa Labani mwana wa Bethueli Mwaramu, ndugu wa Rebeka, mama yao Yakobo na Esau. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Basi Esau akajua kuwa Isaka amembariki Yakobo na kumtuma Padan-Aramu ili achukue mke huko, na kwamba alipombariki alimwamuru, akisema, “Usioe mke katika binti za Wakanaani,” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","tena kwamba Yakobo amewatii baba yake na mama yake, naye ameenda Padan-Aramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau akatambua jinsi baba yake Isaka alivyowachukia binti za Wakanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ndipo Esau akaenda kwa Ishmaeli, akamwoa Mahalati, ndugu wa Nebayothi na binti ya Ishmaeli mwana wa Ibrahimu, kuongezea wale wake wengine aliokuwa nao. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo akatoka Beer-Sheba kwenda Harani. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Alipofika mahali fulani, akalala hapo kwa sababu jua lilikuwa limetua. Akachukua jiwe moja la mahali pale, akaliweka chini ya kichwa chake, akajinyoosha na akalala usingizi. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akaota ndoto, na katika ndoto hiyo aliona ngazi imesimamishwa juu ya ardhi, ncha yake ikiwa imefika mbinguni. Nao malaika wa Mungu walikuwa wakipanda na kushuka kwa ngazi hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Juu yake alisimama Mwenyezi Mungu, akasema, “Mimi ni Mwenyezi Mungu, Mungu wa baba yako Ibrahimu, na Mungu wa Isaka. Nchi ambayo umelala juu yake, nitakupa wewe na uzao wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Uzao wako utakuwa kama mavumbi ya nchi, nawe utaenea upande wa magharibi na mashariki, kaskazini na kusini. Kupitia wewe na uzao wako, mataifa yote ya duniani yatabarikiwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Niko pamoja nawe, nami nitakulinda popote utakapoenda, na nitakurudisha katika nchi hii. Sitakuacha hadi nitakapofanya hayo niliyokuahidi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo alipoamka kutoka usingizi, akawaza, “Hakika Mwenyezi Mungu yuko mahali hapa, wala mimi sikujua.” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kwa hiyo akaogopa, akasema, “Mahali hapa panatisha kama nini! Bila shaka hapa ndipo nyumba ya Mungu ilipo; hili ni lango la mbinguni.” ");
INSERT INTO swhonmm_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kesho yake asubuhi na mapema, Yakobo akalichukua lile jiwe aliloliweka chini ya kichwa chake, akalisimamisha kama nguzo, na kumimina mafuta juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Mahali pale akapaita Betheli, ingawa mji ule hapo awali uliitwa Luzu. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kisha Yakobo akaweka nadhiri, akisema, “Mungu akiwa pamoja nami na kunilinda katika safari hii, akinipa chakula nile na nguo nivae, ");
INSERT INTO swhonmm_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na nirudi salama nyumbani mwa baba yangu, hapo ndipo Mwenyezi Mungu atakuwa Mungu wangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nalo jiwe hili nililolisimamisha kama nguzo litakuwa nyumba ya Mungu, na katika yote utakayonipa nitakutolea sehemu ya kumi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kisha Yakobo akaendelea na safari yake, na akafika nchi ya watu wa mashariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Huko akaona kisima katika shamba, pamoja na makundi matatu ya kondoo yamelala karibu na kisima hicho, kwa sababu walikuwa wakinyweshwa kutoka kisima hicho. Jiwe lililokuwa juu ya mdomo wa kisima lilikuwa kubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kondoo walipokusanyika hapo, wachungaji walilivingirisha jiwe hilo kutoka mdomo wa kisima. Kisha walilirudisha jiwe mahali pake juu ya mdomo wa kisima. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo aliwauliza wachungaji, “Ndugu zangu, ninyi mmetoka wapi?” Wakamjibu, “Tumetoka Harani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Akawauliza, “Je, mnamfahamu Labani, mjukuu wa Nahori?” Wakamjibu, “Ndiyo, tunamfahamu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kisha Yakobo akawauliza, “Je, yeye ni mzima?” Wakasema, “Ndiyo, ni mzima; na hapa yuaja Raheli binti yake akiwa na kondoo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Akawaambia, “Tazama, jua bado liko juu, si wakati wa kukusanya mifugo. Nywesheni kondoo na mwarudishe malishoni.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Wakamjibu, “Haiwezekani, hadi kondoo wote wakusanyike, nalo jiwe livingirishwe kutoka mdomo wa kisima. Ndipo tutawanywesha kondoo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Alipokuwa akizungumza nao, Raheli akaja na kondoo wa baba yake, kwa maana alikuwa mchunga kondoo. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo alipomwona Raheli binti Labani, ndugu wa mama yake, pamoja na kondoo wa Labani, alienda na kulivingirisha jiwe kutoka mdomo wa kisima na kuwanywesha kondoo wa mjomba wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kisha Yakobo akambusu Raheli, na akaanza kulia kwa sauti. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo alikuwa amemwambia Raheli kuwa yeye alikuwa jamaa ya baba yake, na kwamba ni mwana wa Rebeka. Basi Raheli alikimbia na kumweleza baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mara Labani aliposikia habari kuhusu Yakobo, mwana wa ndugu yake, aliharakisha kwenda kumlaki. Akamkumbatia na kumbusu, halafu akamleta nyumbani mwake, naye Yakobo akamwambia mambo hayo yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ndipo Labani akamwambia, “Wewe ni mwili wangu na damu yangu mwenyewe.” Baada ya Yakobo kukaa kwa Labani mwezi mzima, ");
INSERT INTO swhonmm_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani akamwambia, “Kwa vile wewe ni jamaa yangu, ndiyo sababu unifanyie kazi bila ujira? Niambie ujira wako utakuwa nini.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani alikuwa na binti wawili; binti mkubwa aliitwa Lea, naye binti mdogo aliitwa Raheli. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea alikuwa na macho dhaifu, lakini Raheli alikuwa na umbo la kupendeza na mzuri wa sura. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo akampenda Raheli; akamwambia Labani, “Nitakutumikia kwa miaka saba kwa ajili ya kumpata Raheli binti yako mdogo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani akasema, “Ni bora zaidi nikupe Raheli kuliko kumpa mtu mwingine yeyote. Kaa pamoja na mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kwa hiyo Yakobo akatumika miaka saba ili kumpata Raheli, lakini ilionekana kwake kama siku chache tu kwa sababu ya upendo wake kwa Raheli. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ndipo Yakobo akamwambia Labani, “Nipe mke wangu. Muda wangu umekamilika, nami nataka niingie kwake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Basi Labani akaalika watu wote wa mahali pale na akafanya karamu. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Lakini ilipofika jioni, akamchukua Lea binti yake, akampa Yakobo, naye Yakobo akakutana naye kimwili. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Naye Labani akamtoa Zilpa mjakazi wake kuwa mtumishi wa Lea, binti yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kesho yake asubuhi, Yakobo akagundua kuwa amepewa Lea! Basi Yakobo akamwambia Labani, “Ni jambo gani hili ulilonitendea? Nilikutumikia kwa ajili ya Raheli, sivyo? Kwa nini umenidanganya?” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani akajibu, “Si desturi yetu kumwoza binti mdogo kabla ya kumwoza binti mkubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Maliza juma la arusi ya binti huyu, kisha pia nitakupa huyu binti mdogo, kwa kutumika miaka mingine saba.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Naye Yakobo akafanya hivyo. Akamaliza juma na Lea, kisha Labani akampa Raheli binti yake kuwa mke wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani akamtoa Bilha mjakazi wake kwa Raheli ili kuwa mtumishi wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Pia Yakobo akakutana na Raheli kimwili, naye akampenda Raheli kuliko Lea. Yakobo akamtumikia Labani kwa miaka mingine saba. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mwenyezi Mungu alipoona kwamba Lea hapendwi, akamwezesha kupata watoto, lakini Raheli alikuwa tasa. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea akapata mimba, akazaa mwana. Akamwita jina Reubeni, kwa maana alisema, “Ni kwa sababu Mwenyezi Mungu ameona huzuni yangu. Hakika mume wangu sasa atanipenda.” ");
INSERT INTO swhonmm_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Akapata tena mimba, naye alipozaa mwana akasema, “Kwa sababu Mwenyezi Mungu alisikia kwamba sipendwi, amenipa tena huyu mwana.” Kwa hiyo akamwita jina Simeoni. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Akapata tena mimba, naye alipozaa mwana akasema, “Sasa mume wangu ataambatana na mimi, kwa sababu nimemzalia wana watatu.” Kwa hiyo akamwita jina Lawi. ");
INSERT INTO swhonmm_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Akapata tena mimba, naye alipozaa mwana akasema, “Wakati huu nitamsifu Mwenyezi Mungu.” Kwa hiyo akamwita jina Yuda. Kisha akaacha kuzaa watoto. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raheli alipoona hamzalii Yakobo watoto, akamwonea dada yake wivu. Hivyo akamwambia Yakobo, “Nipe watoto, la sivyo nitakufa!” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo akamkasirikia, akamwambia, “Je, mimi ni badala ya Mungu, ambaye amekuzuia kuzaa watoto?” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ndipo Raheli akamwambia, “Hapa yupo Bilha, mjakazi wangu. Kutana naye kimwili ili aweze kunizalia watoto, na kupitia kwake mimi pia niweze kuwa na uzao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hivyo Raheli akampa Yakobo Bilha awe mke wake. Yakobo akakutana naye kimwili, ");
INSERT INTO swhonmm_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","naye Bilha akapata mimba, akamzalia Yakobo mwana. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ndipo Raheli akasema, “Mungu amenipa haki yangu; amesikiliza maombi yangu na kunipa mwana.” Kwa hiyo akamwita jina Dani. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha mjakazi wa Raheli akapata mimba tena, akamzalia Yakobo mwana wa pili. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ndipo Raheli akasema, “Nilikuwa na mashindano makubwa na dada yangu, nami nimeshinda.” Kwa hiyo akamwita jina Naftali. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea alipoona kuwa amekoma kuzaa watoto, alimchukua mjakazi wake Zilpa, naye akampa Yakobo awe mke wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa mjakazi wa Lea akamzalia Yakobo mwana. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ndipo Lea akasema, “Hii ni bahati nzuri aje!” Kwa hiyo akamwita jina Gadi. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mjakazi wa Lea akamzalia Yakobo mwana wa pili. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ndipo Lea akasema, “Nina furaha kiasi gani! Wanawake wataniita furaha.” Kwa hiyo akamwita jina Asheri. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Msimu wa kuvuna ngano, Reubeni akaenda shambani akachuma tunguja ambazo alizileta kwa Lea mama yake. Raheli akamwambia Lea, “Tafadhali nakuomba unipe baadhi ya tunguja za mwanao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lakini Lea akamwambia, “Haikukutosha kuninyang’anya mume wangu? Je, utachukua na tunguja za mwanangu pia?” Raheli akasema, “Vema sana! Yakobo atakutana nawe kimwili leo usiku, kwa malipo ya tunguja za mwanao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kwa hiyo Yakobo alipokuja kutoka shambani jioni ile, Lea akaenda kumlaki, akamwambia, “Lazima ukutane nami kimwili. Nimekukodisha kwa tunguja za mwanangu.” Kwa hiyo akakutana naye kimwili usiku ule. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mungu akamsikiliza Lea, naye akapata mimba, akamzalia Yakobo mwana wa tano. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ndipo Lea akasema, “Mungu amenizawadia kwa kumpa mume wangu mjakazi wangu.” Kwa hiyo akamwita jina Isakari. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea akapata mimba tena, akamzalia Yakobo mwana wa sita. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ndipo Lea aliposema, “Mungu amenizawadia kwa zawadi ya thamani sana. Sasa mume wangu ataniheshimu kwa sababu nimemzalia wana sita.” Kwa hiyo akamwita jina Zabuloni. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Baadaye akamzaa mtoto wa kike, akamwita jina Dina. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ndipo Mungu akamkumbuka Raheli, akasikia maombi yake na akafungua tumbo lake. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Akapata mimba na akamzaa mwana; akasema, “Mungu ameniondolea aibu yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Akamwita jina Yusufu, akasema, “Mwenyezi Mungu na anipe mwana mwingine.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Baada ya Raheli kumzaa Yusufu, Yakobo akamwambia Labani, “Nipe ruhusa nirudi katika nchi yangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nipe wake zangu na watoto, ambao nimetumika kuwapata, nami niende zangu. Unajua kazi niliyokufanyia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lakini Labani akamwambia, “Ikiwa nimepata kibali machoni pako, tafadhali ukae. Nimegundua kwa uaguzi kwamba Mwenyezi Mungu amenibariki kwa sababu yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Akaongeza kumwambia, “Taja ujira wako nami nitakulipa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo akamwambia, “Unajua jinsi nimekutumikia na jinsi wanyama wako walivyolishwa vizuri chini ya uangalizi wangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kidogo ulichokuwa nacho kabla sijaja kimeongezeka sana, naye Mwenyezi Mungu amekubariki popote nilipokuwa. Lakini sasa, ni lini nitashughulikia mambo ya nyumba yangu mwenyewe?” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani akamuuliza, “Nikupe nini?” Yakobo akamjibu, “Usinipe chochote, lakini kama utanifanyia jambo hili moja, nitaendelea kuchunga na kuyaangalia makundi yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Niruhusu nipite katika makundi yako yote leo niondoe humo kila kondoo mwenye mabaka mabaka au madoadoa, kila mwana-kondoo mweusi, na kila mbuzi mwenye madoadoa au mabaka mabaka. Hawa watakuwa ujira wangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Uadilifu wangu utanishuhudia siku zijazo, kila utakapochunguza ujira ambao umenilipa mimi. Mbuzi yeyote wangu ambaye hana mabaka mabaka wala madoadoa, au mwana-kondoo ambaye si mweusi, atahesabika ameibwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani akasema, “Ninakubali; na iwe kama ulivyosema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Siku ile ile Yakobo akawaondoa beberu wote waliokuwa na mistari au madoadoa, na mbuzi jike wote waliokuwa na mistari au madoadoa (wote waliokuwa na alama nyeupe juu yao), na wana-kondoo weusi wote, akawaweka chini ya uangalizi wa wanawe. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kisha Labani akamwacha Yakobo kwa mwendo wa safari ya siku tatu, naye Yakobo akaendelea kuchunga lile kundi la Labani lililobaki. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lakini Yakobo akachukua fito mbichi zilizokatwa wakati huo huo za miti ya mlubna, mlozi na mwaramoni, akazibambua ili mistari myeupe ionekane katika fito hizo. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kisha akaweka fito hizo katika mabirika yote ya kunyweshea mifugo, ili ziwe mbele ya makundi walipokuja kunywa maji. Wanyama walipokuja kunywa maji, hali wakiwa wanahitaji mbegu, ");
INSERT INTO swhonmm_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","wakapandwa hizo fito zikiwa mbele yao. Wanyama waliopata mimba mbele ya hizo fito walizaa wanyama wenye mistari, madoadoa na mabaka mabaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo akawatenga wadogo wa kundi peke yao, lakini akazielekeza nyuso za hao waliobaki kwenye wale wenye mistari na weusi waliokuwa mali ya Labani. Hivyo akatenga makundi yake mwenyewe, wala hakuwachanganya na wanyama wa Labani. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kila mara wanyama wenye nguvu walipohitaji mbegu, Yakobo aliweka zile fito kwenye mabirika mbele ya hao wanyama, ili wapandwe karibu na hizo fito, ");
INSERT INTO swhonmm_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","lakini ikiwa wanyama walikuwa wadhaifu hakuziweka hizo fito. Hivyo wanyama wadhaifu wakawa wa Labani, na wanyama wenye nguvu wakawa wa Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hivyo Yakobo akastawi sana, tena akawa na makundi makubwa, mjakazi na watumishi, na ngamia na punda. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo akawasikia wana wa Labani wakisema, “Yakobo amechukua mali yote ya baba yetu, naye amepata utajiri huu wote kutokana na mali ya baba yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo akatambua kwamba moyo wa Labani kwake umebadilika. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ndipo Mwenyezi Mungu akamwambia Yakobo, “Rudi katika nchi ya baba zako na kwa jamaa zako, nami nitakuwa pamoja nawe.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hivyo Yakobo akatuma ujumbe kwa Raheli na Lea waje malishoni kwenye makundi yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Akawaambia, “Naona moyo wa baba yenu kwangu umebadilika, lakini Mungu wa baba yangu amekuwa pamoja nami. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mnajua kwamba nimemtumikia baba yenu kwa nguvu zangu zote, ");
INSERT INTO swhonmm_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","lakini baba yenu amenidanganya kwa kubadilisha ujira wangu mara kumi. Hata hivyo, Mungu hakumruhusu kunidhuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aliposema, ‘Wenye madoadoa watakuwa ujira wako,’ basi makundi yote yalizaa wenye madoadoa. Aliposema, ‘Wenye mistari watakuwa ujira wako,’ basi makundi yote yalizaa wenye mistari. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hivyo Mungu amechukua mifugo ya baba yenu na amenipa mimi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Majira ya kuzaliana niliota ndoto. Niliinua macho na kuona kwamba wale beberu waliokuwa wakiwapanda mbuzi walikuwa wana mistari, madoadoa na mabaka mabaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika wa Mungu akaniita katika ndoto, ‘Yakobo.’ Nikamjibu, ‘Mimi hapa.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Akaniambia, ‘Inua macho yako uone wale beberu wote wanaowapanda mbuzi wana mistari, madoadoa au mabaka mabaka, kwa maana nimeona yale yote Labani amekutendea. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mimi ndiye Mungu wa Betheli, ulikomiminia nguzo mafuta, na ukaniwekea nadhiri. Sasa ondoka katika nchi hii mara moja urudi katika nchi uliyozaliwa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ndipo Raheli na Lea wakajibu, “Je bado tunalo fungu lolote katika urithi wa nyumba ya baba yetu? ");
INSERT INTO swhonmm_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Je, yeye hatuhesabu sisi kama wageni? Sio kwamba ametuuza tu, bali ametumia hata mali tuliyolipiwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hakika utajiri wote ambao Mungu ameuchukua kutoka kwa baba yetu ni mali yetu na watoto wetu. Hivyo fanya lolote lile Mungu alilokuambia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ndipo Yakobo akawapandisha watoto wake na wake zake juu ya ngamia. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Naye akawaswaga wanyama wote mbele yake, pamoja na mali yote aliyokuwa amepata huko Padan-Aramu ili aende kwa baba yake Isaka katika nchi ya Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani alipokuwa ameenda kukata kondoo wake manyoya, Raheli aliiba miungu ya nyumbani mwa baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Zaidi ya hayo, Yakobo alimdanganya Labani Mwaramu kwa kutokumwambia kwamba anakimbia. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Hivyo akakimbia pamoja na vitu vyote alivyokuwa navyo na kuvuka Mto, akaelekea nchi ya vilima ya Gileadi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Siku ya tatu, Labani akaambiwa kwamba Yakobo amekimbia. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Akiwachukua jamaa zake, akamfuatia Yakobo kwa siku saba na kumkuta kwenye nchi ya vilima ya Gileadi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ndipo Mungu akamjia Labani Mwaramu katika ndoto usiku na kumwambia, “Jihadhari usiseme neno lolote kwa Yakobo, liwe zuri au baya.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakobo alikuwa amepiga hema lake katika nchi ya vilima ya Gileadi wakati Labani alimfikia; naye Labani na jamaa yake wakapiga kambi huko pia. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ndipo Labani akamwambia Yakobo, “Umefanya nini? Umenidanganya na umewachukua binti zangu kama mateka katika vita. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kwa nini ulikimbia kwa siri na kunidanganya? Kwa nini hukuniambia ili nikuage kwa furaha na nyimbo za matari na vinubi? ");
INSERT INTO swhonmm_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hata hukuniruhusu niwabusu wajukuu zangu na kuwaaga binti zangu. Umefanya kitu cha kipumbavu. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nina uwezo wa kukudhuru, lakini usiku uliopita Mungu wa baba yako alisema nami, akaniambia, ‘Jihadhari, usiseme neno lolote kwa Yakobo, liwe zuri au baya.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sasa umeondoka kwa sababu umetamani kurudi nyumbani mwa baba yako. Lakini kwa nini umeiiba miungu yangu?” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo akamjibu Labani, “Niliogopa, kwa sababu nilifikiri ungeweza kuninyang’anya binti zako kwa nguvu. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Lakini ukimkuta yeyote na miungu yako, huyo mtu hataishi. Mbele ya jamaa zetu, angalia mwenyewe uone kama kuna chochote chako hapa nilicho nacho; kama kipo, kichukue.” Basi Yakobo hakujua kwamba Raheli alikuwa ameiiba hiyo miungu. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kwa hiyo Labani akaingia ndani ya hema la Yakobo, na ndani ya hema la Lea, na ndani ya hema la wajakazi wale wawili, lakini hakuipata hiyo miungu. Baadaye alipotoka hema la Lea, akaingia hema la Raheli. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Basi Raheli ndiye alikuwa ameichukua ile miungu ya nyumbani mwao na kuiweka katika matandiko ya ngamia, na kukalia. Labani akatafuta kila mahali kwenye hema lakini hakupata chochote. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raheli akamwambia baba yake, “Usikasirike bwana wangu, kwa kuwa siwezi kusimama ukiwepo, niko katika hedhi.” Labani akatafuta lakini hakuweza kuipata miungu ya nyumbani mwake. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo akakasirika na kumshutumu Labani, akisema, “Uhalifu wangu ni nini?” Akamuuliza Labani, “Ni dhambi gani niliyofanya hata unaniwinda? ");
INSERT INTO swhonmm_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sasa kwa kuwa umepekua vitu vyangu vyote, umepata nini kilicho cha nyumbani mwako? Kiweke hapa mbele ya jamaa yako na yangu, nao waamue kati yetu. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Hadi sasa nimekuwa pamoja nawe miaka ishirini. Kondoo wako na mbuzi wako hawajaharibu mimba, wala sijala kondoo dume kutoka makundi yako. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sijakuletea mfugo aliyeraruliwa na wanyama pori, bali nimegharimia hasara mwenyewe. Tena umenidai malipo kwa chochote kilichoibwa mchana au usiku. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Hali yangu imekuwa hivi: Nimechomwa kwa joto la mchana, na kupigwa na baridi usiku, pia usingizi ulinipotea. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Imekuwa hivi kwa miaka ile ishirini niliyokuwa nyumbani kwako. Nilikutumikia miaka ile kumi na nne kwa ajili ya binti zako wawili, na miaka sita kwa ajili ya makundi yako, nawe ulibadilisha ujira wangu mara kumi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kama Mungu wa baba yangu, Mungu wa Ibrahimu na Hofu ya Isaka, hakuwa pamoja nami, hakika ungenifukuza mikono mitupu. Lakini Mungu ameona taabu yangu na kazi ngumu ya mikono yangu, naye usiku uliopita amekukemea.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani akamjibu Yakobo, “Wanawake hawa ni binti zangu, watoto hawa ni watoto wangu, na makundi haya ni makundi yangu. Vyote unavyoviona ni vyangu. Lakini hata hivyo ninaweza kufanya nini kuhusu hawa binti zangu, au kuhusu watoto waliowazaa? ");
INSERT INTO swhonmm_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Njoo sasa na tufanye agano, wewe na mimi, na liwe kama shahidi kati yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hivyo Yakobo akachukua jiwe, akalisimamisha kama nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Akawaambia jamaa yake, “Kusanyeni mawe.” Hivyo wakachukua mawe na kuyakusanya yakawa lundo; wakala chakula hapo karibu na hilo lundo. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani akaliita Yegar-Sahadutha na Yakobo akaliita Galeedi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani akasema, “Lundo hili ni shahidi kati yako na mimi leo.” Ndiyo maana likaitwa Galeedi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Pia liliitwa Mispa, kwa sababu alisema, “Mwenyezi Mungu na aweke ulinzi kati yako na mimi wakati hatuko pamoja. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ukiwatenda mabaya binti zangu au ukioa wake wengine zaidi ya binti zangu, hata ingawa hakuna hata mmoja aliye pamoja nasi, kumbuka kwamba Mungu ni shahidi kati yako na mimi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pia Labani akamwambia Yakobo, “Hili ndilo lundo, na hii ndiyo nguzo niliyoisimamisha kati yako na mimi. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Lundo hili ni shahidi na nguzo hii ni shahidi, kwamba sitavuka lundo hili kuja upande wako kukudhuru, nawe kwamba hutavuka lundo hili na nguzo hii kuja upande wangu kunidhuru. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mungu wa Ibrahimu na Mungu wa Nahori, Mungu wa baba zao, aamue kati yetu.” Hivyo Yakobo akaapa kwa jina la Hofu ya baba yake Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo akatoa dhabihu huko nchi ya vilima na akawaalika jamaa zake kula chakula. Baada ya kula, wakalala huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kesho yake asubuhi na mapema, Labani akawabusu wajukuu zake na binti zake, na kuwabariki. Kisha akaondoka, akarudi nyumbani. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo pia akaondoka akaenda zake, nao malaika wa Mungu wakakutana naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo alipowaona, akasema, “Hii ni kambi ya Mungu!” Kwa hiyo akapaita mahali pale Mahanaimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo akatuma wajumbe kumtangulia kwa Esau ndugu yake huko Seiri, katika nchi ya Edomu. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akawaagiza, akisema: “Hili ndilo mtakalomwambia bwana wangu Esau: ‘Mtumishi wako Yakobo anasema: nimekuwa nikiishi pamoja na Labani na nimekuwa huko hadi sasa. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ninao ng’ombe na punda, kondoo na mbuzi, watumishi wa kiume na wa kike. Sasa ninatuma ujumbe huu kwa bwana wangu, ili nipate kibali machoni pako.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wajumbe waliporudi kwa Yakobo, wakamwambia, “Tulienda kuonana na ndugu yako Esau, naye sasa anakuja kukulaki akifuatana na wanaume mia nne.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kwa hofu kuu na huzuni, Yakobo akagawanya watu aliokuwa nao katika makundi mawili; pia akagawanya makundi ya kondoo na mbuzi, na vilevile ng’ombe na ngamia. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobo alifikiri, “Kama Esau akija na kushambulia kundi moja, kundi lililobaki litanusurika.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ndipo Yakobo akaomba, “Ee Mungu wa baba yangu Ibrahimu, Mungu wa baba yangu Isaka, Ee Mwenyezi Mungu, ndiwe uliniambia, ‘Rudi katika nchi yako na jamaa yako, nami nitakufanya ustawi.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Sistahili fadhili na uaminifu wako wote ulionitendea mimi, mtumishi wako. Nilikuwa na fimbo tu mkononi mwangu nilipovuka mto huu wa Yordani, lakini sasa nimekuwa makundi mawili. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nakuomba uniokoe kutoka kwa mkono wa ndugu yangu Esau, kwa maana ninaogopa kuwa atakuja kunishambulia, pia kina mama pamoja na watoto wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lakini umeshasema, ‘Hakika nitakufanya ustawi na kuufanya uzao wako kuwa mwingi kama mchanga wa baharini ambao hauwezi kuhesabika!’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Akalala pale usiku ule. Miongoni mwa vitu alivyokuwa navyo, akachagua zawadi kwa ajili ya Esau ndugu yake: ");
INSERT INTO swhonmm_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","beberu ishirini na mbuzi jike mia mbili, kondoo dume ishirini na kondoo jike mia mbili, ");
INSERT INTO swhonmm_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamia jike thelathini pamoja na ndama zao, ng’ombe arobaini na mafahali kumi, punda jike ishirini, na punda wa kiume kumi. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Akaviweka chini ya uangalizi wa watumishi wake, kila kundi peke yake, na kuwaambia, “Nitangulieni na kuacha nafasi kati ya makundi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Akamwagiza yule aliyetangulia hivi, “Ndugu yangu Esau atakapokutana nawe na kukuuliza, ‘Wewe ni wa nani? Unaenda wapi? Wanyama hawa wote mbele yako ni mali ya nani?’ ");
INSERT INTO swhonmm_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","utamjibu hivi, ‘Ni mali ya mtumishi wako Yakobo. Ni zawadi iliyotumwa kwa bwana wangu Esau, naye anakuja nyuma yetu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Akamwagiza pia yule mtumishi wa kundi la pili, na wa kundi la tatu, na kila mtumishi wa yale mengine yaliyofuata, hivi: “Mtamwambia Esau maneno hayo hayo mtakapokutana naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Hakikisheni mmesema, ‘Mtumishi wako Yakobo anakuja nyuma yetu.’ ” Kwa kuwa alifikiri, “Nitaweza kumtuliza kwa zawadi hizi ninazotanguliza; hatimaye nitakapomwona, huenda atanikubali.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kwa hiyo zawadi za Yakobo zilitangulia mbele yake, lakini yeye mwenyewe alilala kambini usiku ule. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Usiku ule Yakobo akaamka, akawachukua wake zake wawili, wajakazi wake wawili, na wanawe kumi na mmoja, akavuka kivuko cha Mto Yaboki. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Baada ya kuwavusha ng’ambo ya kijito, alivusha pia mali yake yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kwa hiyo Yakobo akaachwa peke yake; naye mtu mmoja akashikana naye mweleka hadi mapambazuko. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yule mtu alipoona kuwa hawezi kumshinda, aligusa kiungio cha nyonga ya Yakobo; kwa hiyo nyonga yake ikateguka alipokuwa akishikana mweleka na yule mtu. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ndipo yule mtu akasema, “Niache niende, kwa kuwa ni mapambazuko.” Lakini Yakobo akajibu, “Sitakuacha uende usiponibariki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yule mtu akamuuliza, “Jina lako ni nani?” Akamjibu, “Ni Yakobo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ndipo yule mtu akasema, “Jina lako halitakuwa tena Yakobo, bali Israeli, kwa sababu umeshindana na Mungu na watu pia, nawe umeshinda.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo akasema, “Tafadhali niambie jina lako.” Lakini akajibu, “Kwa nini kuniuliza Jina langu?” Ndipo akambariki huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kwa hiyo Yakobo akapaita mahali pale Penieli, akisema, “Ni kwa sababu nimemwona Mungu uso kwa uso, na bado uhai wangu umehifadhiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jua lilikuwa linachomoza Yakobo alipoondoka Penueli, naye alikuwa akichechemea kwa sababu ya nyonga yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kwa hiyo hadi leo Waisraeli hawali mshipa ulioungana na kiungio cha nyonga, kwa sababu kiungio cha nyonga ya Yakobo kiliteguliwa karibu na mshipa huo. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo akainua macho, akamwona Esau akija na watu wake mia nne. Kwa hiyo akawagawanya watoto kati ya Lea, Raheli na wale wajakazi wake wawili. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Akawaweka wale wajakazi na watoto wao mbele, Lea na watoto wake wakafuata, nao Raheli na Yusufu wakaja nyuma. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yeye mwenyewe akatangulia mbele na kusujudu hadi chini mara saba alipomkaribia ndugu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Lakini Esau akamkimbilia Yakobo kumlaki na kumkumbatia, akamwangukia shingoni na kumbusu. Nao wakalia. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau akainua macho, akawaona wale wanawake na watoto. Akauliza, “Hawa waliofuatana nawe ni nani?” Yakobo akamjibu, “Ni watoto ambao Mungu amempa mtumishi wako kwa neema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kisha wale wajakazi na watoto wao wakakaribia na kusujudu. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kisha Lea na watoto wake wakaja na kusujudu. Mwisho wa wote wakaja Yusufu na Raheli, nao pia wakasujudu. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau akauliza, “Makundi hayo yote niliyokutana nayo yana maana gani?” Akasema, “Ni ili kupata kibali machoni pako, bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lakini Esau akamwambia, “Ndugu yangu, tayari nina wingi wa mali. Ulivyo navyo viwe vyako mwenyewe.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo akasema, “La hasha! Tafadhali, kama nimepata kibali machoni pako, upokee zawadi hii kutoka kwangu. Kwa maana kuuona uso wako ni kama kuuona uso wa Mungu, kwa kuwa umenipokea kwa kibali kikubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tafadhali kubali zawadi iliyoletwa kwako, kwa kuwa Mungu amenineemesha na ninavyo vyote ninavyohitaji.” Kwa sababu Yakobo alisisitiza, Esau akapokea. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ndipo Esau akasema, “Tuendelee na safari; nitakusindikiza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Lakini Yakobo akamwambia, “Bwana wangu, unajua kwamba watoto ni wachanga na kwamba ni lazima nitunze hawa ng’ombe na kondoo wanaonyonyesha. Wakipelekwa kwa haraka hata kama ni kwa siku moja tu, wanyama wote watakufa. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hivyo bwana wangu, mtangulie mtumishi wako, nami nije polepole kwa mwendo wa makundi yaliyo mbele yangu na mwendo wa watoto, hadi nifike kwa bwana wangu huko Seiri.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau akamwambia, “Basi kubali nikuachie baadhi ya watu wangu.” Yakobo akauliza, “Lakini kwa nini ufanye hivyo? Niache tu nipate kibali machoni pa bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hivyo siku hiyo Esau akashika njia, akarudi Seiri. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pamoja na hayo, Yakobo akaenda Sukothi. Akajijengea makazi na pia vibanda vya mifugo yake. Hii ndiyo sababu mahali pale panaitwa Sukothi. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Baada ya Yakobo kutoka Padan-Aramu, alifika salama katika mji wa Shekemu huko Kanaani, na kuweka kambi yake karibu na mji huo. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Akanunua kiwanja kutoka kwa wana wa Hamori, baba wa Shekemu, kwa bei ya vipande mia moja vya fedha, akapiga hema lake hapo. ");
INSERT INTO swhonmm_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Akajenga madhabahu pale na kupaita El-Elohe-Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Basi Dina, binti Yakobo aliyezaliwa na Lea, akaenda kuwatembelea wanawake wa nchi ile. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ikawa Shekemu mwana wa Hamori Mhivi, mtawala wa eneo lile, alipomwona, akamchukua na kumnajisi. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Moyo wake ukavutwa sana kwa Dina binti Yakobo, akampenda huyu msichana na akazungumza naye kwa kumbembeleza. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekemu akamwambia Hamori, baba yake, “Nipatie msichana huyu awe mke wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo aliposikia kwamba binti yake Dina amenajisiwa, wanawe walikuwa mashambani wakichunga mifugo yake. Kwa hiyo akalinyamazia jambo hilo hadi waliporudi nyumbani. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kisha Hamori baba yake Shekemu akaenda kuzungumza na Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Basi wana wa Yakobo wakarudi kutoka mashambani mara tu waliposikia kilichotukia. Walijawa na huzuni na ghadhabu, kwa sababu Shekemu alikuwa amefanya jambo la aibu katika Israeli kwa kukutana kimwili na binti Yakobo, jambo ambalo halikupasa kutendwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Lakini Hamori akawaambia, “Moyo wa mwanangu Shekemu umeelekea kwa binti yenu. Tafadhali mpeni awe mke wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Oaneni na sisi; tupeni binti zenu, nanyi mchukue binti zetu. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mwaweza kuishi nasi, nchi ni wazi kwenu. Ishini ndani yake, mfanye biashara humu na mjipatie mali.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kisha Shekemu akamwambia baba yake Dina pamoja na ndugu zake, “Naomba nipate kibali machoni penu, nami nitawapa chochote mtakachosema. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Niambieni kiasi cha mahari na zawadi nitakayoileta, hata iwe kubwa kiasi gani, nami nitawalipa chochote mtakachodai. Nipeni tu huyu msichana awe mke wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kwa sababu dada yao Dina alikuwa amenajisiwa, wana wa Yakobo wakajibu kwa udanganyifu walipozungumza na Shekemu pamoja na Hamori, baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wakawaambia, “Hatuwezi kufanya jambo kama hili. Hatuwezi kumtoa dada yetu kwa mtu ambaye hajatahiriwa. Hiyo itakuwa aibu kwetu. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tutakuruhusu kwa sharti moja tu, kwamba mtakuwa kama sisi kwa kuwatahiri wanaume wenu wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kisha tutawapa binti zetu na sisi tutawachukua binti zenu. Tutaishi kwenu na tutakuwa watu wamoja nanyi. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Lakini mkikataa kutahiriwa, tutamchukua dada yetu na kuondoka.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Pendekezo lao likakubalika kwa Hamori na Shekemu mwanawe. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kijana huyo, aliyekuwa ameheshimiwa kati ya wote walioishi nyumbani mwa baba yake, hakupoteza muda kufanya waliyoyasema, kwa sababu alikuwa amependezwa sana na binti Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kwa hiyo Hamori na Shekemu mwanawe walienda kwenye lango la mji kuzungumza na wanaume wa mji wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Wakasema, “Hawa wanaume ni rafiki zetu. Tuwaruhusu waishi katika nchi yetu na kufanya biashara ndani yake; nchi ina nafasi tele kwa ajili yao. Tunaweza kuoa binti zao, nao wanaweza kuoa binti zetu. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lakini wanaume hawa watakubali kuishi nasi kama watu wamoja nao kwa sharti kwamba wanaume wetu watahiriwe, kama wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Je, si mifugo yao, mali yao na wanyama wao wengine wote watakuwa wetu? Basi tukubali sharti lao, nao wataishi miongoni mwetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wanaume wote waliotoka nje ya lango la mji walikubaliana na Hamori na Shekemu mwanawe, na kila mwanaume katika mji ule akatahiriwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Baada ya siku tatu, wakati wote wakiwa wangali katika maumivu, wana wawili wa Yakobo, yaani Simeoni na Lawi, ndugu zake Dina, wakachukua panga zao na kuvamia mji ambao haukutazamia vita, wakaua kila mwanaume. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wakawaua Hamori na Shekemu mwanawe kwa panga, kisha wakamchukua Dina kutoka nyumba ya Shekemu na kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wana hao wengine wa Yakobo wakaingia mji uliojaa maiti na kuteka nyara katika mji huo dada yao alikuwa amenajisiwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wakateka kondoo na mbuzi, ng’ombe, punda, na kila kitu kilichokuwa ndani ya mji ule na mashambani. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Waliteka utajiri wao wote, pamoja na wanawake na watoto wao, wakapora kila kitu ndani ya nyumba zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kisha Yakobo akawaambia Simeoni na Lawi, “Mmenitaabisha kwa kunifanya ninuke kama uvundo kwa Wakanaani na Waperizi, watu wanaoishi nchi hii. Sisi ni wachache; wakiunganisha nguvu zao dhidi yangu na kunishambulia, mimi na nyumba yangu tutaangamizwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Lakini wakamjibu, “Je, ilikuwa vyema kumtendea dada yetu kama kahaba?” ");
INSERT INTO swhonmm_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kisha Mungu akamwambia Yakobo, “Panda uende Betheli ukakae huko. Ukamjengee Mungu madhabahu huko, Yeye aliyekutokea ulipokuwa unamkimbia Esau ndugu yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Hivyo Yakobo akawaambia watu wa nyumbani mwake pamoja na wote waliokuwa naye, “Iondoeni miungu ya kigeni mliyo nayo, mjitakase na mkabadilishe nguo zenu. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kisha njooni, twende Betheli, mahali nitakapomjengea Mungu madhabahu, aliyenijibu katika siku ya shida yangu, ambaye amekuwa pamoja nami popote nilipoenda.” ");
INSERT INTO swhonmm_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kwa hiyo wakampa Yakobo miungu yote ya kigeni waliyokuwa nayo, pamoja na pete zilizokuwa masikioni mwao. Yakobo akavizika chini ya mwaloni ulio Shekemu. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kisha wakaondoka, na utisho wa Mungu ukaipata miji yote iliyowazunguka. Kwa hiyo hakuna aliyewafuatia wana wa Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo na watu wote waliokuwa pamoja naye wakafika Luzu (ndio Betheli), katika nchi ya Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Huko akajenga madhabahu na akapaita mahali pale El-Betheli, kwa sababu mahali pale ndipo Mungu alijifunua kwake alipokuwa akimkimbia ndugu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wakati huu Debora, mlezi wa Rebeka, akafa na akazikwa chini ya mwaloni ulio nje ya Betheli. Kwa hiyo pakaitwa Alon-Bakuthi. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Baada ya Yakobo kurudi kutoka Padan-Aramu, Mungu alimtokea tena na kumbariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mungu akamwambia, “Jina lako ni Yakobo. Lakini hutaitwa tena Yakobo; jina lako litakuwa Israeli.” Kwa hiyo akamwita Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Mungu akamwambia, “Mimi ndimi Mungu Mwenyezi; ukazae na kuongezeka. Taifa na jamii ya mataifa itatoka kwako, nao wafalme watatoka viunoni mwako. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nchi niliyowapa Ibrahimu na Isaka nakupa wewe pia, nami nitawapa wazao wako baada yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kisha Mungu akapanda juu kutoka kwake mahali pale alipozungumza naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo akasimamisha nguzo ya jiwe mahali pale Mungu alipozungumza naye, akamimina sadaka ya kinywaji juu yake, pia akamimina mafuta juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo akapaita mahali pale Mungu alipozungumza naye Betheli. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kisha wakaondoka Betheli. Kabla hawajafika Efrata, Raheli akaanza kujifungua na akapata shida kuu. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Alipokuwa katika shida hii katika kujifungua, mkunga akamwambia, “Usiogope, kwa sababu umempata mwana mwingine.” ");
INSERT INTO swhonmm_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hapo alipopumua pumzi yake ya mwisho, kwa maana alikuwa akifa, akamwita mwanawe jina Benoni. Lakini babaye akamwita jina Benyamini. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kwa hiyo Raheli akafa, na akazikwa kando ya njia iendayo Efrata (ndio Bethlehemu). ");
INSERT INTO swhonmm_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo akasimamisha nguzo juu ya kaburi lake, ambayo hadi leo inatambulisha kaburi la Raheli. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israeli akaendelea tena na safari yake na kupiga hema baada ya kupita Mnara wa Ederi. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israeli alipokuwa akiishi katika nchi ile, Reubeni mwanawe alikutana kimwili na suria wa baba yake aliyeitwa Bilha, naye Israeli akasikia jambo hilo. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wana wa Lea walikuwa: Reubeni mzaliwa wa kwanza wa Yakobo, Simeoni, Lawi, Yuda, Isakari na Zabuloni. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wana wa Raheli walikuwa: Yusufu na Benyamini. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wana waliozaliwa na Bilha mjakazi wa Raheli walikuwa: Dani na Naftali. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wana waliozaliwa na Zilpa mjakazi wa Lea walikuwa: Gadi na Asheri. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo akarudi nyumbani mwa baba yake Isaka huko Mamre, karibu na Kiriath-Arba (yaani Hebroni), ambapo walikuwa wameishi Ibrahimu na Isaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka aliishi miaka mia moja na themanini. ");
INSERT INTO swhonmm_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kisha Isaka akapumua pumzi yake ya mwisho, akafa; akakusanywa pamoja na watu wake akiwa mzee aliyeshiba siku. Nao Esau na Yakobo, wanawe, wakamzika. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hivi ndivyo vizazi vya Esau (yaani Edomu). ");
INSERT INTO swhonmm_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau akaoa wake kutoka miongoni mwa wanawake wa Kanaani: Ada binti Eloni Mhiti, Oholibama binti Ana, mjukuu wa kike wa Sibeoni Mhivi; ");
INSERT INTO swhonmm_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","pia akaoa Basemathi binti Ishmaeli, dada yake Nebayothi. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada akamzalia Esau Elifazi; Basemathi akamzaa Reueli; ");
INSERT INTO swhonmm_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama akawazaa Yeushi, Yalamu na Kora. Hawa ndio wana wa Esau waliozaliwa kwake huko Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau akawachukua wake zake, watoto wake wa kiume na wa kike, na watu wote wa nyumbani mwake, mifugo yake pamoja na wanyama wake wengine wote, na mali yake yote ambayo alikuwa ameipata akiwa Kanaani, akahamia katika nchi iliyo mbali na Yakobo ndugu yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Mali yao ilikuwa nyingi sana kiasi kwamba haikuwa rahisi wao kuishi pamoja; nchi waliyokuwa wakiishi isingewatosha wote kwa ajili ya mifugo yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kwa hiyo Esau (ambaye ni Edomu) aliishi katika nchi ya vilima ya Seiri. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hivi ndivyo vizazi vya Esau, baba wa Waedomu, katika nchi ya vilima ya Seiri. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Haya ndiyo majina ya wana wa Esau: Elifazi, mwana wa Esau ambaye mkewe Ada alimzalia; na Reueli, mwana wa Esau ambaye mkewe Basemathi alimzalia. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifazi ni: Temani, Omari, Sefo, Gatamu na Kenazi. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi mwana wa Esau alikuwa pia na suria aliyeitwa Timna, aliyemzalia Amaleki. Hao walikuwa wajukuu wa Ada mke wa Esau. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wana wa Reueli ni: Nahathi, Zera, Shama na Miza. Hao walikuwa wajukuu wa Basemathi mkewe Esau. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wana wa Oholibama binti Ana, mkewe Esau, aliyekuwa mjukuu wa Sibeoni, aliomzalia Esau ni: Yeushi, Yalamu na Kora. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hawa walikuwa wakuu miongoni mwa wazao wa Esau: Wakuu wa wana wa Elifazi, mzaliwa wa kwanza wa Esau ni: Temani, Omari, Sefo, Kenazi, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu na Amaleki. Hao walikuwa wakuu waliotoka kwa Elifazi huko Edomu; walikuwa wajukuu wa kiume wa Ada. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Wakuu wa wana wa Reueli, mwana wa Esau ni: Nahathi, Zera, Shama na Miza. Hawa ndio wakuu waliotoka kwa Reueli huko Edomu; walikuwa wajukuu wa kiume wa Basemathi mkewe Esau. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wakuu wa wana wa Esau ambao mkewe Oholibama alimzalia ni: Yeushi, Yalamu na Kora. Hawa ndio wakuu waliotoka kwa mke wa Esau, Oholibama binti Ana. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hao walikuwa wana wa Esau (ndiye Edomu), na hao walikuwa wakuu wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hawa walikuwa wana wa Seiri Mhori, walioishi katika nchi ile: Lotani, Shobali, Sibeoni, Ana, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Eseri na Dishani. Hawa ndio wana wa Seiri huko Edomu waliokuwa wakuu kwa Wahori. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani walikuwa: Hori na Homamu. Timna alikuwa dada yake Lotani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wana wa Shobali walikuwa: Alvani, Manahathi, Ebali, Shefo na Onamu. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wana wa Sibeoni walikuwa: Aya na Ana. (Huyu Ana ndiye aligundua chemchemi ya maji moto jangwani alipokuwa akichunga punda wa Sibeoni, baba yake.) ");
INSERT INTO swhonmm_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Watoto wa Ana walikuwa: Dishoni na Oholibama binti Ana. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wana wa Dishoni walikuwa: Hemdani, Eshbani, Ithrani na Kerani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wana wa Eseri walikuwa: Bilhani, Zaavani na Akani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wana wa Dishani walikuwa: Usi na Arani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hawa walikuwa wakuu wa Wahori: Lotani, Shobali, Sibeoni, Ana, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoni, Eseri na Dishani. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wafuatao ni wafalme waliotawala Edomu kabla ya mfalme yeyote wa Israeli kutawala: ");
INSERT INTO swhonmm_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Beori alikuwa mfalme wa Edomu. Mji wake uliitwa Dinhaba. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela alipofariki, Yobabu mwana wa Zera kutoka Bosra akawa mfalme baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu alipofariki, Hushamu kutoka nchi ya Watemani akawa mfalme baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu alipofariki, Hadadi mwana wa Bedadi, aliyeshinda Midiani katika nchi ya Moabu, akawa mfalme baada yake. Mji wake uliitwa Avithi. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi alipofariki, Samla kutoka Masreka akawa mfalme baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla alipofariki, Shauli kutoka Rehobothi ng’ambo ya Mto Frati akawa mfalme baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli alipofariki, Baal-Hanani mwana wa Akbori akawa mfalme baada yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanani mwana wa Akbori alipofariki, Hadadi akawa mfalme baada yake. Mji wake uliitwa Pau, na mkewe aliitwa Mehetabeli binti Matredi, binti Me-Zahabu. ");
INSERT INTO swhonmm_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hawa ndio wakuu waliotokana na Esau, kwa majina, kufuatana na koo zao na nchi zao: Timna, Alva, Yethethi, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinoni, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mibsari, ");
INSERT INTO swhonmm_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdieli na Iramu. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo akaishi Kanaani katika nchi ambayo baba yake alikuwa ameishi. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Hivi ndivyo vizazi vya Yakobo. Yusufu, kijana wa miaka kumi na saba, alikuwa akichunga makundi ya kondoo na mbuzi pamoja na ndugu zake, yaani wana wa Bilha, na wana wa Zilpa, wake za baba yake, naye akamletea baba yao taarifa mbaya kuhusu hao ndugu zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Basi Israeli akampenda Yusufu kuliko ndugu zake wote, kwa sababu alikuwa mwanawe wa uzeeni; akamshonea joho lililofumwa vizuri sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ndugu zake walipoona kwamba baba yao anampenda Yusufu kuliko yeyote kati yao, walimchukia na hawakusema naye neno lolote jema. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu akaota ndoto, naye alipowaeleza ndugu zake, wakamchukia zaidi. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Akawaambia, “Sikilizeni ndoto niliyoota: ");
INSERT INTO swhonmm_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tulikuwa tukifunga miganda ya nafaka shambani. Ghafula mganda wangu ukasimama wima, nayo miganda yenu ikauzunguka na kuuinamia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ndugu zake wakamwambia, “Wewe unakusudia kututawala? Hivi kweli wewe utatutawala sisi?” Wakazidi kumchukia kwa sababu ya ndoto yake, pamoja na yale aliyowaambia. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kisha akaota ndoto nyingine, akawaambia ndugu zake, akisema, “Sikilizeni: nimeota ndoto nyingine. Wakati huu jua, mwezi na nyota kumi na moja zilikuwa zinanisujudia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Alipomwambia baba yake pamoja na ndugu zake, baba yake akamkemea akisema, “Ni ndoto gani hii uliyoota? Hivi kweli mama yako, na mimi, na ndugu zako tutakuja kukusujudia wewe?” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ndugu zake wakamwonea wivu, lakini baba yake akaliweka jambo hilo moyoni. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Basi ndugu zake walikuwa wameenda kuchunga makundi ya baba yao karibu na Shekemu. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israeli akamwambia Yusufu, “Kama ujuavyo, ndugu zako wanachunga makundi huko karibu na Shekemu. Njoo, nitakutuma kwao.” Yusufu akajibu, “Vema sana, niko tayari.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kwa hiyo akamwambia, “Nenda uone kama ndugu zako wako salama, na makundi pia, kisha uniletee habari.” Basi akamtuma Yusufu kutoka Bonde la Hebroni. Yusufu alipofika Shekemu, ");
INSERT INTO swhonmm_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mtu mmoja akamkuta akizungukazunguka mashambani, akamuuliza, “Unatafuta nini?” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Akamjibu, “Ninawatafuta ndugu zangu. Unaweza kuniambia wanachunga wapi makundi yao?” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yule mtu akajibu, “Wamehama hapa. Nilisikia wakisema, ‘Twendeni Dothani.’ ” Kwa hiyo Yusufu akawafuatilia ndugu zake na kuwakuta karibu na Dothani. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ndugu zake walipomwona akiwa mbali, kabla hajawafikia, wakapanga njama za kumuua. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wakaambiana, “Yule mwota ndoto anakuja! ");
INSERT INTO swhonmm_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Njooni sasa, tumuue na kumtupa katika shimo mojawapo, na tuseme kwamba mnyama mkali amemrarua. Kisha tutaona matokeo ya ndoto zake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reubeni aliposikia jambo hili, akajaribu kumwokoa kutoka mikononi mwao, akasema, “Tusimuue. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Msimwage damu yoyote. Mtupeni katika shimo lililoko hapa jangwani, lakini msimguse.” Reubeni alisema hivyo ili amwokoe kutoka mikononi mwao, kisha amrudishe nyumbani mwa baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kwa hiyo Yusufu alipowafikia ndugu zake, walimvua lile joho lake, lile joho lililofumwa vizuri alilokuwa amevaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kisha wakamchukua, wakamtupa katika shimo. Hilo shimo lilikuwa tupu, halikuwa na maji. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Walipokaa ili wale chakula chao, wakainua macho wakaona msafara wa Waishmaeli ukija kutoka Gileadi. Ngamia wao walikuwa wamepakizwa mizigo ya vikolezo, uvumba na manemane, nao walikuwa njiani kuvipeleka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda akawaambia ndugu zake, “Tutafaidi nini tukimuua ndugu yetu na kuificha damu yake? ");
INSERT INTO swhonmm_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Njooni, tumuuze kwa hawa Waishmaeli. Tusimguse, kwa kuwa hata hivyo yeye ni ndugu yetu, mwili wetu na damu yetu wenyewe.” Ndugu zake wakakubali. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kwa hiyo wale wafanyabiashara Wamidiani walipofika pale, ndugu zake wakamtoa Yusufu kutoka lile shimo, na kumuuza kwa shekeli ishirini za fedha kwa wale Waishmaeli, ambao walimpeleka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reubeni aliporudi kutazama kwenye lile shimo na kuona kwamba Yusufu hayupo, alirarua nguo zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Akawarudia ndugu zake na kusema, “Kijana hayuko mle! Nielekee wapi sasa?” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kisha wakalichukua lile joho la Yusufu, wakachinja mbuzi na kulichovya katika damu. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wakalichukua lile joho lililofumwa vizuri na kulipeleka kwa baba yao na kusema, “Tumeliokota hili joho. Uchunguze uone kama ni la mwanao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Baba yao akalitambua, akasema, “Hili ni joho la mwanangu! Mnyama mkali amemrarua. Hakika Yusufu ameraruliwa vipande vipande.” ");
INSERT INTO swhonmm_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kisha Yakobo akararua nguo zake, akavaa gunia na kumwombolezea mwanawe kwa siku nyingi. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanawe wote wa kiume na wa kike wakaja kumfariji, lakini hakukubali kufarijiwa. Akasema, “Hapana, nitamwombolezea mwanangu hadi nimfikie kaburini.” Kwa hiyo baba yake akaendelea kumlilia. ");
INSERT INTO swhonmm_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Basi Wamidiani wakamuuza Yusufu huko Misri kwa Potifa, mmoja wa maafisa wa Farao, aliyekuwa mkuu wa walinzi. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Wakati ule, Yuda akawaacha ndugu zake, akaenda kuishi na Hira Mwadulami. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Huko Yuda akakutana na binti ya Mkanaani aitwaye Shua. Akamwoa na akakutana naye kimwili, ");
INSERT INTO swhonmm_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","naye akapata mimba, na akamzaa mwana, aliyeitwa jina Eri. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Akapata mimba tena, akamzaa mwana na kumwita jina Onani. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Akamzaa mwana mwingine tena, akamwita jina Shela. Huyu alimzalia huko Kezibu. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda akamtwalia Eri, mzaliwa wake wa kwanza, mke aliyeitwa Tamari. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Lakini Eri, mzaliwa wa kwanza wa Yuda, alikuwa mwovu machoni pa Mwenyezi Mungu, kwa hiyo Mwenyezi Mungu akamuua. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kisha Yuda akamwambia Onani, “Kutana kimwili na mke wa ndugu yako, na utimize wajibu wako kwake kama mke wa ndugu yako, ili umpatie ndugu yako uzao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Lakini Onani alijua kwamba uzao haungekuwa wake, kwa hiyo kila alipokutana kimwili na mke wa ndugu yake, alimwaga mbegu chini ili asimpatie ndugu yake uzao. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Alichofanya kilikuwa kiovu machoni pa Mwenyezi Mungu, hivyo Mwenyezi Mungu akamuua Onani pia. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kisha Yuda akamwambia Tamari mkwewe, “Ishi kama mjane nyumbani mwa baba yako hadi mwanangu Shela atakapokua.” Kwa maana alifikiri, “Anaweza kufa pia kama ndugu zake.” Kwa hiyo Tamari akaenda kuishi nyumbani mwa baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Baada ya muda mrefu, mke wa Yuda, binti Shua, akafariki. Baada ya msiba, Yuda alienda Timna kwa watu waliokuwa wakikata kondoo wake manyoya, naye alifuatana na rafiki yake Hira Mwadulami. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamari alipoambiwa, “Baba mkwe wako yuko njiani akielekea Timna kukata kondoo wake manyoya,” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","alivua mavazi yake ya ujane, akajifunika kwa shela ili asifahamike. Akaketi kwenye mlango wa Enaimu, njiani ya kuelekea Timna. Akafanya hivyo kwa sababu aliona kwamba ingawa Shela sasa alikuwa mtu mzima, bado hajakabidhiwa kwake kuwa mkewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda alipomwona alifikiri ni kahaba, kwa sababu alikuwa amefunika uso wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Pasipo kutambua kwamba alikuwa mkwe wake, akamwendea kando ya njia na kumwambia, “Njoo sasa, nikutane na wewe kimwili.” Yule mkwewe akamuuliza, “Utanipa nini nikikutana nawe kimwili?” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Akamwambia, “Nitakutumia mwana-mbuzi kutoka kundi langu.” Akamuuliza, “Utanipa amana hadi utakapompeleka?” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Akamuuliza, “Nikupe amana gani?” Akamjibu, “Pete yako na kamba yake pamoja na fimbo iliyo mkononi mwako.” Kwa hiyo akampa vitu hivyo, kisha akakutana naye kimwili, naye akapata mimba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamari akaondoka, akavua shela yake, akavaa tena nguo zake za ujane. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Baadaye Yuda akamtuma rafiki yake Mwadulami apeleke yule mwana-mbuzi ili arudishiwe amana yake kutoka kwa yule mwanamke, lakini yule rafiki yake hakumkuta yule mwanamke. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Akawauliza watu walioishi mahali pale, “Yuko wapi yule kahaba wa mahali pa ibada za sanamu aliyekuwa kando ya barabara hapa Enaimu?” Wakamjibu, “Hakujawahi kuwa kahaba wa mahali pa ibada za sanamu hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kwa hiyo akamrudia Yuda na kumwambia, “Sikumpata. Zaidi ya hayo, watu wanaoishi mahali pale walisema, ‘Hakujawahi kuwa kahaba wa mahali pa ibada za sanamu hapa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kisha Yuda akasema, “Mwache avichukue vitu hivyo, ama sivyo tutaaibika. Hata hivyo, nilimpelekea mwana-mbuzi, lakini hukumkuta.” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Baada ya miezi mitatu, Yuda akaambiwa, “Tamari mkweo ana hatia ya kuwa kahaba, na sasa ana mimba.” Yuda akasema, “Mtoeni nje, achomwe moto hadi afe!” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Alipokuwa akitolewa nje, akatuma ujumbe kwa baba mkwe wake kusema, “Nina mimba ya mtu mwenye vitu hivi.” Akaongeza kusema, “Angalia kama utatambua pete hii na kamba yake pamoja na fimbo hii ni vya nani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda akavitambua na kusema, “Yeye ana haki kuliko mimi, kwa kuwa sikumkabidhi kwa mwanangu Shela ili awe mkewe.” Tangu hapo hakukutana naye kimwili tena. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wakati ulipofika wa kujifungua, kukawa na wana mapacha tumboni mwake. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Alipokuwa akijifungua, mmoja akatoa mkono wake nje, kwa hiyo mkunga akachukua uzi mwekundu na kuufunga mkononi mwa yule mtoto, akasema, “Huyu ametoka kwanza.” ");
INSERT INTO swhonmm_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Lakini alipourudisha mkono wake, ndugu yake akatangulia kutoka, naye mkunga akasema, “Hivi ndivyo ulivyotoka kwa nguvu!” Akaitwa Peresi. ");
INSERT INTO swhonmm_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kisha ndugu yake, aliyekuwa na uzi mwekundu mkononi, akatoka, naye akaitwa Zera. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Wakati huu Yusufu alikuwa amechukuliwa hadi Misri. Mmisri aliyeitwa Potifa, mmoja wa maafisa wa Farao, na aliyekuwa mkuu wa walinzi, akamnunua Yusufu kutoka kwa Waishmaeli waliomleta Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mwenyezi Mungu alikuwa pamoja na Yusufu, naye akastawi. Yusufu akaishi nyumbani mwa bwana wake Mmisri. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifa alipoona kuwa Mwenyezi Mungu alikuwa pamoja na Yusufu, na kwamba Mwenyezi Mungu alimfanikisha kwa kila kitu alichokifanya, ");
INSERT INTO swhonmm_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu alipata kibali machoni pa Potifa, akamfanya mhudumu wake. Potifa akamweka kuwa msimamizi wa nyumba yake, naye akamweka kuwa mwangalizi wa mali yake yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kuanzia wakati huo Potifa alipomweka Yusufu kuwa msimamizi wa nyumba na mali yake yote aliyokuwa nayo, Mwenyezi Mungu aliibariki nyumba ya Mmisri huyo kwa sababu ya Yusufu. Baraka ya Mwenyezi Mungu ilikuwa juu ya kila kitu alichokuwa nacho Potifa, nyumbani na shambani. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kwa hiyo Potifa akamwachia Yusufu uangalizi wa kila kitu alichokuwa nacho. Yusufu alipokuwa msimamizi wa mali yake, Potifa hakujishughulisha na kitu chochote isipokuwa chakula alichokula. Yusufu alikuwa mwenye umbo zuri na sura ya kuvutia. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Baada ya kitambo, mke wa Potifa akamtamani Yusufu, akamwambia, “Njoo, ukutane nami kimwili!” ");
INSERT INTO swhonmm_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Lakini Yusufu akakataa. Akamwambia yule mwanamke, “Mimi nikiwa msimamizi, bwana wangu hajishughulishi na kitu chochote katika nyumba hii; kila kitu alicho nacho amenikabidhi. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hapa nyumbani hakuna aliye mkuu kuliko mimi. Bwana wangu hakunizuilia kitu chochote isipokuwa wewe, kwa kuwa wewe ni mke wake. Nitawezaje basi kufanya uovu huu na kutenda dhambi dhidi ya Mungu?” ");
INSERT INTO swhonmm_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ingawa yule mwanamke aliendelea kumshawishi Yusufu siku baada ya siku, Yusufu alikataa kukutana naye kimwili wala kukaa karibu naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Siku moja Yusufu akaingia ndani ya nyumba kufanya kazi zake, wala hapakuwa mfanyakazi yeyote ndani ya nyumba. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mke wa Potifa akashika vazi Yusufu alilokuwa amevaa, akamwambia, “Njoo tukutane kimwili!” Lakini Yusufu akaacha vazi lake mkononi mwa huyo mwanamke, akatoka nje ya nyumba akikimbia. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yule mwanamke alipoona kwamba Yusufu amemwachia vazi lake mkononi na kukimbilia nje ya nyumba, ");
INSERT INTO swhonmm_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","akawaita watumishi wake wa nyumbani, akawaambia, “Tazameni! Huyu Mwebrania ameletwa hapa kutudhihaki! Aliingia hapa ndani ili akutane nami kimwili, lakini nikapiga yowe. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Aliposikia nikipiga yowe, akaacha vazi lake kando yangu, akakimbilia nje.” ");
INSERT INTO swhonmm_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yule mwanamke akaliweka lile vazi karibu naye hadi Potifa aliporudi nyumbani. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mwanamke akamweleza mumewe kisa hiki, akisema: “Yule mtumwa Mwebrania uliyemleta kwetu alinijia ili kunidhihaki. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Lakini mara nilipopiga yowe kuomba msaada, akaliacha vazi lake kando yangu, akakimbia nje ya nyumba.” ");
INSERT INTO swhonmm_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifa aliposikia kisa alichosimuliwa na mkewe, akisema, “Hivi ndivyo mtumwa wako alivyonitenda,” hasira yake ikawaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifa akamchukua Yusufu na kumtia gerezani, mahali wahalifu wa mfalme walipokuwa wamefungwa. Lakini Yusufu alipokuwa huko gerezani, ");
INSERT INTO swhonmm_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mwenyezi Mungu alikuwa pamoja naye, akamhurumia na kumpa kibali mbele ya msimamizi wa gereza. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kwa hiyo msimamizi wa gereza akamweka Yusufu awe mkuu wa wafungwa pamoja na kusimamia yote ambayo yalitendeka mle gerezani. ");
INSERT INTO swhonmm_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Msimamizi wa gereza hakujishughulisha tena na kitu chochote kilichokuwa chini ya uangalizi wa Yusufu, kwa sababu Mwenyezi Mungu alikuwa pamoja na Yusufu, akimfanikisha kwa kila alichofanya. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Baada ya muda, mnyweshaji na mwokaji wa mfalme wa Misri wakamkosea bwana wao, mfalme wa Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao akawakasirikia hawa maafisa wake wawili, mnyweshaji mkuu na mwokaji mkuu. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Akawaweka chini ya ulinzi katika nyumba ya mkuu wa walinzi, katika gereza lile lile alimofungwa Yusufu. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mkuu wa walinzi akawakabidhi kwa Yusufu, naye akawahudumia. Walipokuwa wamekaa chini ya ulinzi kwa muda, ");
INSERT INTO swhonmm_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","kila mmoja wa hao wawili waliokuwa wamewekwa gerezani, yaani mnyweshaji na mwokaji wa mfalme wa Misri, waliota ndoto usiku mmoja, na kila ndoto ilikuwa na maana yake tofauti. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu alipowajia asubuhi yake, akawaona kwamba walikuwa na huzuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ndipo Yusufu akawauliza maafisa hao wa Farao waliokuwa chini ya ulinzi pamoja naye nyumbani mwa bwana wake hivi, “Mbona nyuso zenu zimejaa huzuni leo?” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wakamjibu, “Sisi sote tumeota ndoto, lakini hakuna wa kuzifasiri.” Ndipo Yusufu akawaambia, “Je, kufasiri ndoto si ni kazi ya Mungu? Niambieni ndoto zenu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Basi mkuu wa wanyweshaji akamweleza Yusufu ndoto yake. Akamwambia, “Katika ndoto yangu niliona mzabibu mbele yangu, ");
INSERT INTO swhonmm_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nao mzabibu ulikuwa na matawi matatu. Mara tu ulipoanza kuchipua, maua yalichanua na vishada vyake vikawa zabibu zilizoiva. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kikombe cha Farao kilikuwa mkononi mwangu. Nikazitwaa zabibu, nikazikamua katika kikombe cha Farao, na nikaweka kikombe mkononi mwake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu akamwambia, “Hii ndiyo maana yake: Matawi matatu ni siku tatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Baada ya siku tatu, Farao atakutoa gerezani na kukurudisha kwenye nafasi yako, nawe utaweka kikombe cha Farao mkononi mwake, jinsi ulivyofanya ulipokuwa mnyweshaji wake awali. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lakini mambo yako yatakapokuwa mazuri, unikumbuke, unifanyie wema. Useme mema kunihusu kwa Farao ili unitoe huku gerezani. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kwa maana nilichukuliwa kwa nguvu kutoka nchi ya Waebrania, na hata hapa nilipo sikufanya lolote linalostahili niwekwe gerezani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Yule mwokaji mkuu alipoona kuwa Yusufu amefasiri vizuri, akamwambia Yusufu, “Mimi pia niliota ndoto. Kichwani mwangu kulikuwa vikapu vitatu vya mikate. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Katika kikapu cha juu kulikuwa na aina zote za vyakula vilivyookwa kwa ajili ya Farao, lakini ndege walikuwa wakivila kutoka kikapu nilichobeba kichwani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu akamwambia, “Hii ndiyo maana yake: Vikapu vitatu ni siku tatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Baada ya siku tatu, Farao atakata kichwa chako na kukutundika juu ya mti. Nao ndege watakula nyama ya mwili wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Siku ya tatu ilikuwa kumbukumbu ya kuzaliwa kwa Farao, naye akawaandalia maafisa wake wote karamu. Akawatoa gerezani mnyweshaji mkuu na mwokaji mkuu, akawaweka mbele ya maafisa wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ndipo akamrudisha mnyweshaji mkuu kwenye nafasi yake, ili aweke kikombe mkononi mwa Farao tena. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lakini akamwangika yule mwokaji mkuu, kama Yusufu alivyowafasiria. ");
INSERT INTO swhonmm_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lakini mnyweshaji mkuu hakumkumbuka Yusufu, bali alimsahau. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Baada ya miaka miwili kamili kupita, Farao aliota ndoto. Tazama alikuwa amesimama kando ya Mto Naili, ");
INSERT INTO swhonmm_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","wakati ng’ombe saba, wazuri na wanono, walitokea mtoni wakajilisha kwenye matete. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Baada yao ng’ombe wengine saba, wabaya na waliokonda, wakatokea Mto Naili, wakasimama kando ya wale wanono ukingoni mwa mto. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Wale ng’ombe wabaya na waliokonda wakawala wale saba wazuri na wanono. Kisha Farao akaamka. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Farao akaingia usingizini tena, akaota ndoto ya pili. Akaona masuke saba ya nafaka, yenye afya na mazuri, yanakua katika bua moja. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Baadaye, masuke mengine saba yakachipua, yakiwa membamba yaliyokaushwa na upepo wa mashariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Masuke yale membamba yakameza yale masuke saba yenye afya na yaliyojaa. Basi Farao akaamka kutoka usingizini, na kumbe ilikuwa ndoto. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kesho yake asubuhi, alifadhaika akilini. Hivyo akawaita waaguzi wote pamoja na watu wenye busara wa Misri. Walipokuja, Farao akawaeleza ndoto zake, lakini hakuna hata mmoja aliyeweza kumfasiria. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ndipo mnyweshaji mkuu alimwambia Farao, “Leo nimekumbushwa kosa langu. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao alipowakasirikia watumishi wake, alinifunga mimi na mwokaji mkuu katika nyumba ya mkuu wa walinzi. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Katika usiku mmoja, kila mmoja wetu aliota ndoto, na kila ndoto ilikuwa na maana yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Basi kuna kijana Mwebrania aliyekuwa pamoja nasi huko, mtumishi wa mkuu wa walinzi. Tulimweleza ndoto zetu, naye akatufasiria, akitupatia kila mtu tafsiri ya ndoto yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nayo mambo yakawa jinsi alivyotufasiria ndoto zetu: Mimi nilirudishwa kazini mwangu, naye huyo mwingine akaangikwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Basi, Farao akatuma Yusufu aitwe, naye akatolewa kifungoni haraka. Baada ya kunyoa na kubadilisha nguo zake, akaenda mbele ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao akamwambia Yusufu, “Nimeota ndoto, wala hakuna mtu hata mmoja anayeweza kuifasiri. Lakini nimesikia habari yako kwamba unapoelezwa ndoto unaweza kuifasiri.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu akamjibu Farao, “Siwezi kuifasiri, lakini Mungu atampa Farao jibu analolihitaji.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kisha Farao akamwambia Yusufu, “Katika ndoto yangu nilikuwa nimesimama ukingoni mwa Mto Naili. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nikawaona ng’ombe saba, wazuri na wanono, wakijitokeza kutoka mtoni, wakaja kujilisha kwenye matete. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Baada ya hao, ng’ombe wengine saba wadhaifu wakatokea, wabaya sana na waliokonda. Kamwe sikuwahi kuona ng’ombe wabaya jinsi hiyo katika nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Hao ng’ombe waliokonda na wabaya sana wakawala wale ng’ombe saba walionona waliojitokeza kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Lakini hata baada ya kuwala, hakuna mtu ambaye angeweza kusema kwamba wamekula, bado walionekana wabaya kama mwanzoni. Kisha nikaamka kutoka usingizini. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Pia katika ndoto zangu niliona masuke saba ya nafaka, yamejaa na mazuri, yanakua katika bua moja. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Baada ya hayo, masuke mengine saba yakachipua, yaliyonyauka, membamba na yamekaushwa na upepo wa mashariki. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yale masuke membamba ya nafaka yakayameza yale masuke saba mazuri yaliyojaa nafaka. Nimewaeleza waaguzi, wala hakuna yeyote aliyeweza kunifasiria.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ndipo Yusufu akamwambia Farao, “Ndoto za Farao ni ndoto hiyo hiyo moja. Mungu amemfunulia Farao jambo analokusudia kufanya karibuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ng’ombe saba wazuri ni miaka saba, nayo masuke saba mazuri yaliyojaa nafaka ni miaka saba; ni ndoto hiyo hiyo moja. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ng’ombe saba waliokonda na wabaya waliojitokeza baadaye ni miaka saba, vivyo hivyo masuke saba ya ngano yaliyodhoofika na kukaushwa na upepo wa mashariki: Ni miaka saba ya njaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ni kama nilivyomwambia Farao. Mungu amemwonesha Farao jambo analokusudia kufanya karibuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Miaka saba ya shibe inakuja katika nchi yote ya Misri, ");
INSERT INTO swhonmm_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","lakini itafuata miaka saba ya njaa. Ndipo shibe yote ya Misri itasahaulika na njaa itaikumba nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","“Shibe iliyokuwa katika nchi haitakumbukwa, kwa sababu njaa itakayofuata itakuwa kali mno. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sababu ya ndoto kumjia Farao kwa namna mbili ni kwamba jambo hilo Mungu ameshaamua kwa hakika, naye Mungu atalifanya karibuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Basi sasa Farao na atafute mtu mwenye akili na hekima ili amweke kuwa msimamizi wa nchi ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao na aweke wasimamizi nchini kote, wakusanye sehemu ya tano ya mavuno ya Misri katika miaka hii saba ya shibe. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Wakusanye chakula chote katika miaka hii saba ya neema inayokuja na kuhifadhi nafaka chini ya mamlaka ya Farao, iwe akiba ya chakula katika miji. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chakula hiki kitakuwa akiba ya tahadhari kwa ajili ya nchi, ili kitumike katika ile miaka saba ya njaa itakayokuja Misri, ili nchi isiharibiwe na njaa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Mpango huu ulionekana mzuri kwa Farao na kwa maafisa wake wote. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hivyo Farao akawauliza, “Je, tunaweza kumpata yeyote kama mtu huyu, aliye na Roho wa Mungu ndani yake?” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ndipo Farao akamwambia Yusufu, “Maadamu Mungu amekufunulia haya yote, hakuna yeyote mwenye akili na hekima kama wewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wewe utakuwa msimamizi wa jumba langu la kifalme, na watu wangu wote watatii amri zako. Ni kuhusu kiti cha ufalme tu nitakuwa mkuu kuliko wewe.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kwa hiyo Farao akamwambia Yusufu, “Sasa nakuweka uwe msimamizi wa nchi yote ya Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ndipo Farao akaivua pete yake ya muhuri kutoka kidoleni mwake na kuivalisha katika kidole cha Yusufu. Akamvika majoho mazuri ya kitani safi na mkufu wa dhahabu shingoni mwake. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Akampandisha katika gari lake la vita kama msaidizi wake; watu wakamtangulia wakipaza sauti na kusema, “Fungueni njia!” Ndivyo Farao alimweka Yusufu kuwa msimamizi wa nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kisha Farao akamwambia Yusufu, “Mimi ni Farao, lakini pasipo neno lako, hakuna mtu mwenye ruhusa kuinua mkono au mguu katika nchi yote ya Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao akamwita Yusufu jina Safenath-Panea; pia akampa Asenathi binti Potifera, kuhani wa mji wa Oni, kuwa mke wake. Ndipo Yusufu akaitembelea nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu alikuwa na umri wa miaka thelathini alipoingia katika utumishi wa Farao, mfalme wa Misri. Naye Yusufu akatoka mbele ya Farao akasafiri katika nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Katika ile miaka saba ya shibe nchi ilizaa mazao kwa wingi sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu akakusanya chakula chote kilichozalishwa katika ile miaka saba ya shibe nchini Misri, akakihifadhi katika miji. Katika kila mji kulihifadhiwa chakula kilichozalishwa katika mashamba yaliyouzunguka mji huo. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu alihifadhi nafaka nyingi, mfano wa mchanga wa bahari; ilikuwa nyingi mno kiasi kwamba walishindwa kuweka kumbukumbu kwa sababu akiba ilizidi kipimo. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kabla ya miaka ya njaa kuanza, Asenathi binti Potifera, kuhani wa mji wa Oni, alimzalia Yusufu wana wawili wa kiume. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu akamwita mzaliwa wake wa kwanza jina Manase, akisema, “Ni kwa sababu Mungu amenifanya nisahau taabu zangu zote pamoja na jamaa yote ya nyumba ya baba yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana wa pili akamwita jina Efraimu, akisema, “Ni kwa sababu Mungu amenistawisha katika nchi ya mateso yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ile miaka saba ya shibe huko Misri ikaisha, ");
INSERT INTO swhonmm_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","nayo miaka ile saba ya njaa ikaanza, sawasawa na alivyosema Yusufu. Kulikuwa na njaa katika nchi nyingine zote, bali katika nchi yote ya Misri kulikuwa na chakula. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nchi yote ya Misri ilipopatwa na njaa, watu wakamlilia Farao ili awape chakula. Ndipo Farao aliwaagiza Wamisri wote, “Nendeni kwa Yusufu, nanyi mfanye anachowaambia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Njaa ilipokuwa imeenea katika nchi yote, Yusufu akafungua maghala ya vyakula na kuwauzia Wamisri nafaka, kwa sababu njaa ilikuwa kali mno katika nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pia nchi nyingine zote zilikuja Misri kununua nafaka kutoka kwa Yusufu, kwa sababu njaa ilikuwa kali mno duniani kote. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo alipofahamu kuwa kuna nafaka kule Misri, akawaambia wanawe, “Mbona mnakaa tu hapa mkitazamana?” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Akaendelea kuwaambia, “Nimesikia kuwa huko Misri kuna nafaka. Teremkeni huko mkatununulie chakula, ili tuweze kuishi wala tusife.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ndipo ndugu kumi wa Yusufu wakateremka huko Misri kununua nafaka. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lakini Yakobo hakumtuma Benyamini, ndugu yake Yusufu, pamoja na wengine, kwa sababu aliogopa asije akapatwa na madhara. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hivyo wana wa Israeli walikuwa miongoni mwa wale walioenda Misri kununua nafaka, kwani njaa ilikuwa katika nchi ya Kanaani pia. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Wakati huo Yusufu alikuwa mtawala wa nchi ya Misri, na ndiye aliwauzia watu wote nafaka. Kwa hiyo wakati ndugu zake Yusufu walifika, wakamsujudia hadi nyuso zao zikagusa ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mara Yusufu alipowaona ndugu zake, akawatambua. Lakini akajifanya mgeni na kuzungumza nao kwa ukali, akiwauliza, “Ninyi mnatoka wapi?” Wakamjibu, “Tumetoka nchi ya Kanaani kuja kununua chakula.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ingawa Yusufu aliwatambua ndugu zake, wao hawakumtambua. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ndipo Yusufu alipokumbuka ndoto zake kuwahusu, akawaambia, “Ninyi ni wapelelezi! Mmekuja kuangalia mahali nchi yetu haina ulinzi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wakamjibu, “Sivyo, bwana. Watumishi wako wamekuja kununua chakula. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sisi sote ni wana wa baba mmoja. Watumishi wako ni watu waaminifu, wala sio wapelelezi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Akawaambia, “La, hasha! Mmekuja kuangalia mahali nchi yetu haina ulinzi.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Lakini wakamjibu, “Watumishi wako walikuwa ndugu kumi na wawili, wana wa mtu mmoja ambaye anaishi katika nchi ya Kanaani. Sasa mdogo wetu wa mwisho yupo na baba yetu, na mwingine alikufa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu akawaambia, “Kama nilivyowaambia: Ninyi ni wapelelezi! ");
INSERT INTO swhonmm_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hivi ndivyo mtakavyojaribiwa: Hakika kama Farao aishivyo, hamtaondoka mahali hapa hadi ndugu yenu mdogo aje hapa. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumeni mmoja wenu akamlete huyo ndugu yenu. Wengine mtawekwa gerezani, ili maneno yenu yajaribiwe kuona kama mnasema kweli. La sivyo, hakika kama Farao aishivyo ninyi ni wapelelezi!” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Akawaweka wote chini ya ulinzi kwa siku tatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Siku ya tatu, Yusufu akawaambia, “Fanyeni hili nanyi mtaishi, kwa maana namwogopa Mungu: ");
INSERT INTO swhonmm_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ikiwa ninyi ni watu waaminifu, mmoja wa ndugu zenu na abaki kifungoni, nanyi wengine pelekeni nafaka kwa jamaa yenu wanaoteseka kwa njaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Lakini lazima mniletee ndugu yenu mdogo hapa, ili maneno yenu yathibitike na kwamba msife.” Wakakubali kufanya hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wakaambiana wao kwa wao, “Hakika tunaadhibiwa kwa sababu ya ndugu yetu. Tuliona jinsi alivyohuzunika alipokuwa anatusihi kuokoa maisha yake, lakini hatukumsikiliza. Hiyo ndiyo sababu dhiki hii imetupata.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reubeni akawajibu, “Sikuwaambieni msitende dhambi dhidi ya kijana? Lakini hamkunisikiliza! Sasa ni lazima tuadhibiwe kwa ajili ya damu yake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hawakujua kuwa Yusufu angewaelewa, kwa sababu alitumia mkalimani. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu akajitenga nao, akaanza kulia, kisha akawarudia na kuzungumza nao tena. Akaamuru Simeoni akamatwe na kufungwa mbele yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu akatoa amri ya kujaza magunia yao nafaka na kuweka fedha ya kila mmoja ndani ya gunia lake, kisha wapewe chakula cha njiani. Baada ya kutendewa hayo yote, ");
INSERT INTO swhonmm_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","wakapakiza nafaka juu ya punda wao, wakaondoka. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Walipofika mahali pa kulala huko njiani, mmoja wao akafungua gunia lake ili amlishe punda wake; akakuta fedha yake ndani ya gunia lake. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Akawaambia ndugu zake, “Fedha yangu imerudishwa. Iko ndani ya gunia langu.” Mioyo yao ikazimia, na kila mmoja akamgeukia mwenzake wakitetemeka, wakaulizana, “Ni nini hiki Mungu alichotufanyia?” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Walipofika kwa Yakobo baba yao katika nchi ya Kanaani, wakamweleza mambo yote yaliyowapata. Wakasema, ");
INSERT INTO swhonmm_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Huyo mtu aliye bwana katika nchi hiyo alisema nasi kwa ukali, akatutendea kana kwamba sisi tulikuwa tunaipeleleza nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Lakini tulimwambia, ‘Sisi ni watu waaminifu, sio wapelelezi. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tulizaliwa ndugu kumi na wawili, wana wa baba mmoja. Mmoja alikufa, na mdogo wetu wa mwisho yupo na baba yetu huko Kanaani.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ndipo huyo mtu aliye bwana katika nchi hiyo alipotuambia, ‘Hivi ndivyo nitafahamu kuwa ninyi ni watu waaminifu: Mwacheni mmoja wa ndugu zenu hapa kwangu, kisha nendeni mpeleke chakula kwa jamaa yenu inayoteseka kwa njaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Lakini mleteni huyo ndugu yenu mdogo kwangu. Ndipo nitajua kuwa ninyi sio wapelelezi, ila ni watu waaminifu. Kisha nitamrudisha ndugu yenu, nanyi mtaweza kufanya biashara katika nchi hii.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Walipokuwa wanamimina nafaka kutoka magunia yao, tazama! Wakapata ndani ya gunia la kila mtu mfuko wa fedha. Wakati wao na baba yao waliona mifuko ya fedha, wakaogopa. ");
INSERT INTO swhonmm_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo baba yao akawaambia, “Ninyi mmenipokonya watoto wangu. Yusufu hayupo na Simeoni hayupo; tena na sasa mnataka kumchukua Benyamini. Kila kitu ni kinyume nami!” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ndipo Reubeni akamwambia baba yake, “Unaweza kuwaua wanangu wote wawili, ikiwa sitamrudisha Benyamini kwako. Mkabidhi Benyamini katika uangalizi wangu, nami nitamrudisha.” ");
INSERT INTO swhonmm_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lakini Yakobo akasema, “Mwanangu hatashuka huko pamoja nanyi; ndugu yake amekufa, naye ndiye peke yake aliyebaki. Akipatwa na madhara katika safari mnayoiendea, mtashusha kichwa changu chenye mvi kaburini kwa masikitiko.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Wakati huu njaa ilikuwa bado ni kali mno katika nchi. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Hivyo wakati walikuwa wamemaliza kula nafaka yote waliyoileta kutoka Misri, baba yao akawaambia, “Rudini Misri mkatununulie chakula kingine.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lakini Yuda akamwambia, “Mtu yule alituonya kwa msisitizo, ‘Hamtauona uso wangu tena hadi mje na ndugu yenu.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kama utakubali ndugu yetu aende pamoja nasi, tutaenda kuwanunulia chakula. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Lakini ikiwa hutamruhusu aende, hatutaenda, kwa sababu mtu yule alituambia, ‘Hamtauona uso wangu tena hadi mje na ndugu yenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israeli akauliza, “Kwa nini mkaniletea taabu hii kwa kumwambia yule mtu mlikuwa na ndugu mwingine?” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wakamjibu, “Yule mtu alituhoji kwa undani sana habari zetu na za jamaa yetu. Alituuliza, ‘Je, baba yenu bado angali hai? Je, mnaye ndugu mwingine?’ Sisi tulimjibu maswali yake tu. Tungewezaje kujua kwamba angesema, ‘Mleteni mdogo yenu hapa’?” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ndipo Yuda akamwambia baba yake Israeli, “Mtume kijana pamoja nami, nasi tutaondoka mara moja, ili sisi na wewe pamoja na watoto wetu tuweze kuishi, wala tusife. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mimi mwenyewe nitakuhakikishia usalama wake; mimi mwenyewe nitawajibika kumrudisha. Nisipomrudisha kwako na kumweka mbele yako, nitakuwa mwenye lawama mbele yako maisha yangu yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hakika, kama hatukuchelewa kuondoka, tungekuwa tumeenda na kurudi mara mbili.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Basi baba yao Israeli akawaambia, “Kama ni lazima iwe hivyo, basi fanyeni hivi: Wekeni sehemu ya bidhaa bora za nchi katika mifuko yenu, na mmpelekee yule mtu kama zawadi: zeri kidogo, asali kidogo, vikolezo, manemane, kungu na lozi. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Chukueni fedha mara mbili, kwa kuwa mtazirudisha zile fedha zilizowekwa midomoni mwa magunia yenu. Labda ziliwekwa kwa makosa. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mchukueni ndugu yenu pia, mrudi kwa huyo mtu mara moja. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Naye Mungu Mwenyezi awajalie rehema mbele ya huyo mtu ili apate kumwachia yule ndugu yenu na Benyamini mweze kurudi pamoja. Kwangu mimi, kama nikufiwa, nimefiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Basi hao watu wakazichukua zile zawadi na zile fedha mara mbili pamoja na Benyamini. Wakafanya haraka kwenda Misri na wakajionesha kwa Yusufu. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu alipomwona Benyamini pamoja nao, akamwambia msimamizi wa nyumba yake, “Wachukue watu hawa nyumbani mwangu, mchinje mnyama na kuandalia chakula, kwa kuwa watakula chakula cha mchana pamoja nami.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Msimamizi akafanya kama Yusufu alivyomwambia na akawachukua wale watu nyumbani mwa Yusufu. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Basi watu hao wakaogopa walipopelekwa nyumbani mwa Yusufu. Wakafikiri, “Tumeletwa hapa kwa ajili ya zile fedha zilizorudishwa katika magunia yetu mara ile ya kwanza. Anataka kutushambulia na kutushinda, atuchukue sisi kama watumwa, na atwae hawa punda wetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hivyo wakamwendea msimamizi wa nyumba wa Yusufu na kuzungumza naye kwenye ingilio la nyumba. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wakasema, “Tafadhali bwana, tulikuja hapa mara ya kwanza kununua chakula. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lakini mahali pale tulipotua wakati wa jioni tulifungua magunia yetu, na kila mmoja wetu akakuta fedha zake katika gunia lake, kiasi kile kile tulicholeta. Kwa hiyo tumezirudisha. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Pia tumeleta fedha nyingine kwa ajili ya kununulia chakula. Hatujui ni nani aliziweka fedha hizo katika magunia yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Akawaambia, “Vema, msiogope. Mungu wenu, Mungu wa baba yenu, amewapa ninyi hazina katika magunia yenu; mimi nilipokea fedha yenu.” Ndipo akawaletea Simeoni. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Msimamizi akawapeleka wale watu nyumbani mwa Yusufu, akawapa maji ya kunawa miguu, na kuwapa punda wao majani. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wakaandaa zawadi zao ili wampe Yusufu atakapofika adhuhuri, kwa kuwa walikuwa wamesikia kwamba watakula chakula huko. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu alipokuja nyumbani, walimkabidhi zile zawadi ambazo walikuwa wamezileta mle nyumbani, nao wakamsujudia. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Akawauliza kuhusu hali yao, kisha akawaambia, “Yule baba yenu mzee mliyeniambia habari zake, yu hali gani? Je, bado yu hai?” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wakamjibu, “Mtumishi wako, baba yetu, bado anaishi na ni mzima.” Kisha wakainama, wakamsujudia. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Alipotazama na kumwona Benyamini ndugu yake, mwana wa mama yake hasa, akauliza, “Je, huyu ndiye ndugu yenu wa mwisho, ambaye mlinieleza habari zake?” Ndipo akasema, “Mungu na akufadhili, mwanangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Akiwa ameguswa sana kwa kumwona ndugu yake, Yusufu akaondoka kwa haraka na kutafuta mahali pa kulilia. Akaingia kwenye chumba chake cha pekee na kulilia humo. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Baada ya kunawa uso wake, akarudi; huku akijizuia kulia, akasema, “Pakueni chakula.” ");
INSERT INTO swhonmm_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wakampakulia Yusufu peke yake, nao ndugu zake peke yao, na Wamisri waliokula pamoja naye peke yao, kwa sababu Wamisri wasingeweza kula pamoja na Waebrania, kwa maana ilikuwa ni chukizo kwa Wamisri. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Watu hao walikuwa wameketi mbele yake kwa mfuatano wa umri wao, kuanzia mzaliwa wa kwanza hadi mzaliwa wa mwisho, wakatazamana wao kwa wao kwa mshangao. ");
INSERT INTO swhonmm_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Walipopelekewa sehemu ya chakula kutoka meza ya Yusufu, sehemu ya Benyamini ilikuwa mara tano zaidi ya sehemu ya wale wengine. Kwa hiyo wakanywa na kufurahi pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kisha Yusufu akampa yule msimamizi wa nyumbani mwake maagizo haya: “Jaza magunia ya watu hawa kiasi cha chakula ambacho wanaweza kuchukua, na uweke fedha ya kila mtu katika gunia lake. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kisha weka kikombe changu kile cha fedha katika gunia la yule mdogo wa wote, pamoja na fedha zake ambazo alinunulia nafaka yake.” Naye akafanya kama Yusufu alivyosema. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kulipopambazuka, hao watu wakaruhusiwa kuondoka pamoja na punda wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kabla hawajafika mbali kutoka mjini, Yusufu akamwambia mtumishi wake, “Wafuatilie wale watu mara moja; utakapowakuta, waambie, ‘Kwa nini mmelipiza wema kwa ubaya? ");
INSERT INTO swhonmm_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Je, kikombe hiki sicho anachonywea bwana wangu, na pia hukitumia kwa kubashiri? Hili ni jambo ovu mlilolitenda.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Alipowafikia, akarudia maneno haya kwao. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Lakini wakamwambia mtumishi, “Kwa nini bwana wangu anasema maneno kama haya? Liwe mbali na watumishi wako kufanya jambo kama hilo! ");
INSERT INTO swhonmm_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tazama, tulikurudishia zile fedha kutoka nchi ya Kanaani ambazo tulizikuta kwenye magunia yetu. Hivyo, kwa nini tuibe fedha au dhahabu kutoka nyumbani mwa bwana wako? ");
INSERT INTO swhonmm_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ikiwa yeyote miongoni mwa watumishi wako atapatikana nacho, auawe, na sisi wengine tutakuwa watumwa wa bwana wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Akajibu, “Vema sana; na iwe kama msemavyo. Yeyote atakayekutwa nacho atakuwa mtumwa wangu, lakini ninyi wengine mtakuwa hamna lawama.” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kila mmoja wao akafanya haraka kushusha gunia lake chini na kulifungua. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ndipo msimamizi akaendelea kutafuta, akianzia kwa mkubwa wa wote na akaishia kwa mdogo wa wote. Basi kikombe kikapatikana katika gunia la Benyamini. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kwa hilo, wakararua nguo zao. Ndipo wote wakapakiza mizigo yao juu ya punda wao na kurudi mjini. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusufu alikuwa bado yuko nyumbani mwake Yuda na ndugu zake walipoingia. Wote wakajitupa chini mbele yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu akawaambia, “Ni jambo gani hili mlilolifanya? Hamjui kuwa mtu kama mimi anaweza kufahamu mambo kwa njia ya kubashiri?” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda akajibu, “Tuseme nini kwa bwana wangu? Tutaweza kuzungumza nini? Tutawezaje kuthibitisha kwamba hatuna hatia? Mungu amefunua hatia ya watumishi wako. Sasa sisi tu watumwa wa bwana wangu, sisi pamoja na yule aliyepatikana na kikombe.” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lakini Yusufu akasema, “Liwe mbali nami kufanya jambo kama hili! Mtu yule tu aliyekutwa na kikombe ndiye atakuwa mtumwa wangu. Ninyi wengine rudini kwa baba yenu kwa amani.” ");
INSERT INTO swhonmm_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ndipo Yuda akamwendea na kumwambia: “Tafadhali bwana wangu, mruhusu mtumishi wako aseme neno kwa bwana wangu. Usimkasirikie mtumishi wako, ingawa wewe ni sawa na Farao mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Bwana wangu aliwauliza watumishi wake, ‘Mnaye baba au ndugu?’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nasi tukakujibu, ‘Tunaye baba yetu ambaye ni mzee; pia yupo mwanawe mdogo aliyezaliwa katika uzee wake. Ndugu yake amekufa, na huyu mdogo ndiye mwana pekee kwa mama yake aliyebaki, naye baba yake anampenda.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ndipo ulipowaambia watumishi wako, ‘Mleteni kwangu ili niweze kumwona kwa macho yangu mwenyewe.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nasi tukamwambia bwana wangu, ‘Kijana hawezi kumwacha baba yake; akimwacha, baba yake atakufa.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lakini ukawaambia watumishi wako, ‘Ndugu yenu mdogo asiposhuka pamoja nanyi, hamtauona uso wangu tena.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tuliporudi kwa mtumwa wako baba yangu, tulimwambia lile bwana wangu alilokuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ndipo baba yetu alisema, ‘Rudini Misri mkanunue chakula kingine.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Lakini tukamwambia, ‘Hatuwezi kushuka Misri hadi ndugu yetu mdogo awe pamoja nasi ndipo tutaenda. Hatutaweza kuuona uso wa yule mtu hadi ndugu yetu mdogo awe pamoja nasi.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Mtumwa wako baba yangu alituambia, ‘Mnajua mke wangu alinizalia wana wawili. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mmoja alipotea, nami nikasema, “Hakika ameraruliwa vipande vipande.” Nami sijamwona tangu wakati huo. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ikiwa mtaniondolea huyu tena na akapatwa na madhara, mtashusha kichwa changu chenye mvi kaburini nikiwa mwenye huzuni.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Hivyo sasa, kama kijana hatakuwa pamoja nasi nitakaporudi kwa mtumishi wako baba yangu, na kama baba yangu, ambaye maisha yake yamefungamanishwa na uhai wa kijana huyu, ");
INSERT INTO swhonmm_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","akiona kijana hayupo nasi, atakufa. Watumishi wako watashusha kichwa chenye mvi cha baba yetu kaburini kwa huzuni. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mtumwa wako alimhakikishia baba yangu usalama wa kijana. Nikamwambia, ‘Kama sitamrudisha kwako, nitakuwa mwenye lawama mbele yako, baba yangu, maisha yangu yote!’ ");
INSERT INTO swhonmm_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Sasa basi, tafadhali mruhusu mtumishi wako abaki hapa kama mtumwa wa bwana wangu badala ya kijana, naye kijana umruhusu arudi na ndugu zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ninawezaje kurudi kwa baba yangu kama kijana hatakuwa pamoja nami? La hasha! Usiniache nikaone huzuni ile itakayompata baba yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Basi Yusufu hakuweza kujizuia tena mbele ya wote waliokuwa wamesimama karibu naye. Akapaza sauti, akasema, “Mwondoeni kila mtu mbele yangu!” Kwa hiyo hapakuwa mtu mwingine na Yusufu alipojitambulisha kwa ndugu zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Naye akalia kwa sauti kubwa kiasi kwamba Wamisri walimsikia, hata watu wa nyumbani mwa Farao wakapata hizo habari. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu akawaambia ndugu zake, “Mimi ni Yusufu! Je, baba yangu angali hai bado?” Lakini ndugu zake hawakuweza kumjibu, kwa sababu walipatwa na hofu kuu mbele yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ndipo Yusufu akawaambia ndugu zake, “Sogeeni karibu nami.” Waliposogea, akasema, “Mimi ni ndugu yenu Yusufu, yule ambaye mlimuuza Misri! ");
INSERT INTO swhonmm_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sasa msihuzunike wala msijichukie wenyewe kwa kuniuza huku, kwa sababu ilikuwa ni ili kuokoa maisha ya watu ndiyo sababu Mungu alinituma niwatangulie ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kwa miaka miwili sasa njaa imekuwa katika nchi, pia kwa miaka mitano ijayo hapatakuwa na kulima wala kuvuna. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Lakini Mungu alinitanguliza mbele yenu ili kuwahifadhia mabaki katika nchi, na kuokoa maisha yenu kwa wokovu mkuu. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Kwa hiyo basi, si ninyi mlionileta huku, bali ni Mungu. Alinifanya kama baba kwa Farao, bwana wa watu wa nyumbani mwake wote, na mtawala wa Misri yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Sasa rudini haraka kwa baba yangu, mkamwambie, ‘Hili ndilo mwanao Yusufu asemalo: Mungu amenifanya mimi kuwa mtawala wa Misri yote. Shuka uje kwangu, wala usikawie. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nawe utaishi katika nchi ya Gosheni na kuwa karibu nami: wewe, watoto wako na wajukuu wako, makundi yako ya kondoo, mbuzi na ng’ombe, pamoja na vyote ulivyo navyo. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nitawatunza huko, kwa sababu bado iko miaka mingine mitano inayokuja ya njaa. La sivyo, wewe na nyumba yako na wote ulio nao mtakuwa fukara.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Mnaweza kujionea wenyewe, hata ndugu yangu Benyamini, kwamba hakika ni mimi ninayezungumza nanyi. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mwambieni baba yangu kuhusu heshima yote niliyopewa huku Misri, na kuhusu kila kitu mlichokiona. Mleteni baba yangu huku haraka.” ");
INSERT INTO swhonmm_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ndipo akamkumbatia Benyamini ndugu yake na kulia, naye Benyamini akamkumbatia akilia. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Pia akawabusu ndugu zake wote, huku akilia. Baada ya hayo, ndugu zake wakazungumza naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Habari zilipofika kwenye jumba la Farao kwamba ndugu zake Yusufu wamefika, Farao na maafisa wake wote wakafurahi. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao akamwambia Yusufu, “Waambie ndugu zako, ‘Fanyeni hivi: Pakieni wanyama wenu mrudi hadi nchi ya Kanaani, ");
INSERT INTO swhonmm_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","mkamlete baba yenu na jamaa zenu kwangu. Nitawapa sehemu nzuri sana ya nchi ya Misri, nanyi mtafurahia unono wa nchi.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Mnaagizwa pia kuwaambia, ‘Fanyeni hivi: Chukueni magari ya kukokotwa kutoka Misri kwa ajili ya watoto wenu na wake zenu, mkamchukue baba yenu mje. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Msijali kamwe kuhusu mali yenu, kwa sababu mema yote ya Misri yatakuwa yenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Hivyo wana wa Israeli wakafanya hivyo. Yusufu akawapa magari ya kukokotwa kama Farao alivyoagiza, na pia akawapa chakula cha safari yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Akampa kila mmoja mavazi mapya, lakini Benyamini akampa shekeli mia tatu za fedha, na jozi tano za nguo. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Hivi ndivyo vitu alivyotuma kwa baba yake: punda kumi waliobeba vitu vizuri vya Misri, punda jike kumi waliobeba nafaka, mikate na mahitaji mengine ya safari. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Akaagana na ndugu zake walipokuwa wakiondoka, akawaambia, “Msigombane njiani!” ");
INSERT INTO swhonmm_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Basi wakatoka Misri na kufika kwa baba yao Yakobo katika nchi ya Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wakamwambia baba yao, “Yusufu angali hai! Ukweli ni kwamba yeye ndiye mtawala wa Misri yote.” Yakobo akapigwa na bumbuazi; hakuwasadiki. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lakini walipokwisha kumweleza kila kitu ambacho Yusufu alikuwa amewaambia, na alipoona magari ya kukokotwa Yusufu aliyokuwa amempelekea ya kumchukua aende Misri, roho ya baba yao Yakobo ikahuishwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ndipo Israeli akasema, “Nimesadiki! Mwanangu Yusufu bado yu hai. Nitaenda nikamwone kabla sijafa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Hivyo Israeli akaondoka na mali yake yote. Alipofika Beer-Sheba, akamtolea dhabihu Mungu wa Isaka baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mungu akanena na Israeli katika maono usiku na kusema, “Yakobo! Yakobo!” Akamjibu, “Mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mungu akamwambia, “Mimi ndimi Mungu wa baba yako. Usiogope kushuka Misri, kwa maana huko nitakufanya taifa kubwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nitashuka Misri pamoja nawe, nami hakika nitakurudisha tena Kanaani. Mikono ya Yusufu mwenyewe ndiyo itakayofunga macho yako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ndipo Yakobo akaondoka Beer-Sheba, nao wana wa Israeli wakamchukua baba yao Yakobo, na watoto wao na wake zao katika magari ya kukokotwa yale Farao alikuwa amempelekea kumsafirisha. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wakachukua pia mifugo yao na mali walizokuwa wamezipata Kanaani; Yakobo na uzao wake wote wakashuka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Akawachukua wanawe na binti zake, wajukuu wake wa kiume na wa kike, yaani uzao wake wote hadi Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Haya ndiyo majina ya wana wa Israeli (Yakobo na wazao wake), walioenda Misri: Reubeni mzaliwa wa kwanza wa Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Wana wa Reubeni ni: Hanoki, Palu, Hesroni, na Karmi. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Wana wa Simeoni ni: Yemueli, Yamini, Ohadi, Yakini, Sohari, na Shauli mwana wa mwanamke Mkanaani. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Wana wa Lawi ni: Gershoni, Kohathi, na Merari. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wana wa Yuda ni: Eri, Onani, Shela, Peresi, na Zera (lakini Eri na Onani walifariki katika nchi ya Kanaani). Wana wa Peresi ni: Hesroni na Hamuli. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wana wa Isakari ni: Tola, Puva, Yashubu, na Shimroni. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wana wa Zabuloni ni: Seredi, Eloni, na Yaleeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hawa ndio wana wa Lea aliomzalia Yakobo huko Padan-Aramu, pamoja na binti yake Dina. Jumla ya hawa wanawe wa kiume na wa kike walikuwa thelathini na watatu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wana wa Gadi ni: Sefoni, Hagi, Shuni, Esboni, Eri, Arodi, na Areli. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wana wa Asheri ni: Imna, Ishva, Ishvi, na Beria. Dada yao alikuwa Sera. Wana wa Beria ni: Heberi na Malkieli. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hawa ndio watoto Zilpa aliomzalia Yakobo, ambaye Labani alimpa binti yake Lea; jumla yao walikuwa kumi na sita. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Wana wa Raheli mke wa Yakobo ni: Yusufu na Benyamini. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Huko Misri, Asenathi binti Potifera, aliyekuwa kuhani wa mji wa Oni, alimzalia Yusufu wana wawili: Manase na Efraimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wana wa Benyamini ni: Bela, Bekeri, Ashbeli, Gera, Naamani, Ehi, Roshi, Mupimu, Hupimu, na Ardi. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hawa ndio wana wa Raheli aliomzalia Yakobo; jumla yao ni kumi na wanne. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana wa Dani ni: Hushimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wana wa Naftali ni: Yaseeli, Guni, Yeseri, na Shilemu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hawa walikuwa wana wa Bilha aliomzalia Yakobo, ambaye Labani alikuwa amempa Raheli binti yake; jumla yao walikuwa saba. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wote walioenda Misri pamoja na Yakobo, waliokuwa wazao wake hasa pasipo kuhesabu wakwe wake, walikuwa watu sitini na sita. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pamoja na wana wawili waliozaliwa na Yusufu huko Misri, jumla ya jamaa ya Yakobo walioenda Misri walikuwa sabini. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Basi Yakobo akamtanguliza Yuda aende kwa Yusufu ili amwelekeze njia ya Gosheni. Walipofika nchi ya Gosheni, ");
INSERT INTO swhonmm_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu aliandaa gari lake la vita, na akaenda Gosheni kumlaki baba yake, Israeli. Mara Yusufu alipofika mbele yake, alimkumbatia baba yake, akalia kwa muda mrefu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israeli akamwambia Yusufu, “Sasa niko tayari kufa, kwa kuwa nimejionea mwenyewe kwamba bado uko hai.” ");
INSERT INTO swhonmm_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ndipo Yusufu akawaambia ndugu zake na watu wa nyumbani mwa baba yake, “Nitapanda kwa Farao na kumwambia, ‘Ndugu zangu na watu wa nyumbani mwa baba yangu, walioishi katika nchi ya Kanaani, wamekuja kwangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Watu hao ni wafugaji; wao huchunga mifugo, na wamekuja na makundi ya kondoo, mbuzi na ng’ombe, pamoja na kila kitu walicho nacho.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Farao atakapowaita na kuwauliza, ‘Kazi yenu ni nini?’ ");
INSERT INTO swhonmm_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mjibuni, ‘Watumishi wako wamekuwa wafugaji wa wanyama tangu ujana wetu hadi sasa, kama baba zetu walivyokuwa.’ Ndipo mtaruhusiwa kukaa katika nchi ya Gosheni, kwa kuwa wafugaji wote ni chukizo kwa Wamisri.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu akaenda na kumwambia Farao, “Baba yangu na ndugu zangu wamekuja kutoka nchi ya Kanaani wakiwa na makundi yao ya kondoo, mbuzi na ng’ombe, pamoja na kila kitu walicho nacho, nao sasa wako Gosheni.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Akawachagua ndugu zake watano na kuwapeleka mbele ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao akawauliza hao ndugu zake, “Kazi yenu ni nini?” Wakamjibu, “Watumishi wako ni wafugaji, kama baba zetu walivyokuwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pia wakamwambia Farao, “Tumekuja kukaa huku kwa muda mfupi, kwa sababu njaa ni kali huko Kanaani, na mifugo ya watumishi wako haina malisho. Kwa hiyo sasa, tafadhali uruhusu watumishi wako wakae huko Gosheni.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao akamwambia Yusufu, “Baba yako na ndugu zako wamekuja kwako, ");
INSERT INTO swhonmm_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","nayo nchi ya Misri ipo mbele yako; wakalishe baba yako na ndugu zako katika sehemu iliyo bora kupita zote katika nchi. Na waishi Gosheni. Kama unawafahamu walio na uwezo maalum miongoni mwao, wafanye kuwa wasimamizi wa mifugo yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ndipo Yusufu akamleta Yakobo baba yake na kumtambulisha mbele ya Farao. Baada ya Yakobo kumbariki Farao, ");
INSERT INTO swhonmm_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao akamuuliza, “Je, una umri gani?” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Naye Yakobo akamwambia Farao, “Siku za miaka ya kusafiri kwangu ni miaka mia moja na thelathini. Miaka yangu imekuwa michache na ya taabu, wala haikufikia miaka ya maisha ya baba zangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakobo akambariki Farao, kisha akaondoka mbele yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ndipo Yusufu akawakalisha baba yake na ndugu zake katika nchi ya Misri, akawapa milki katika sehemu bora sana ya nchi, ile wilaya ya Ramesesi, kama Farao alivyoelekeza. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Pia Yusufu akampa baba yake, na ndugu zake, na wote wa nyumbani mwa baba yake vyakula, kulingana na hesabu ya watoto wao. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hata hivyo, hapakuwa na chakula katika eneo lote; kwa kuwa njaa ilikuwa kali sana; Misri na Kanaani zote zikaharibiwa kwa sababu ya njaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu akakusanya fedha zote zilizopatikana kutoka mauzo ya nafaka huko Misri na Kanaani, akazileta kwenye jumba la kifalme la Farao. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Fedha za watu wa Misri na Kanaani zilipokwisha, Wamisri wote wakamjia Yusufu na kumwambia, “Tupatie chakula. Kwa nini tufe mbele ya macho yako? Fedha zetu zimekwisha.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu akawaambia, “Basi leteni mifugo yenu. Nitawauzia chakula kwa kubadilisha na mifugo yenu, kwa kuwa fedha zenu zimekwisha.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kwa hiyo wakaleta mifugo yao kwa Yusufu, naye akawapa chakula kwa kubadilishana na farasi, kondoo na mbuzi, ng’ombe, na punda wao. Katika mwaka huo wote Yusufu akawapa chakula kwa kubadilishana na mifugo yao yote. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka ule ulipokwisha, wakamjia mwaka uliofuata na kumwambia, “Hatuwezi kuficha ukweli mbele za bwana wetu kwamba, kwa kuwa fedha zetu zimekwisha na wanyama wetu ni mali yako, sasa hakuna chochote kilichosalia kwa ajili ya bwana wetu isipokuwa miili yetu na ardhi yetu. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kwa nini tuangamie mbele ya macho yako, sisi pamoja na nchi yetu? Tununue sisi pamoja na ardhi yetu ili kubadilishana kwa chakula. Nasi pamoja na nchi yetu tutakuwa watumwa wa Farao. Tupe sisi mbegu ili tuweze kuishi wala tusife, nchi yetu isije ikawa ukiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kwa hiyo Yusufu akamnunulia Farao nchi yote ya Misri. Wamisri, mmoja baada ya mwingine, waliuza mashamba yao, kwa sababu njaa ilikuwa kali sana kwao. Nchi ikawa mali ya Farao, ");
INSERT INTO swhonmm_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","naye Yusufu akawafanya watu watumike kama watumwa, kuanzia upande mmoja wa Misri hadi upande mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hata hivyo hakununua nchi ya makuhani, kwa sababu walipokea mgawo wao wa kawaida kutoka kwa Farao, nao walikuwa na chakula cha kuwatosha kutokana na mgawo waliopewa na Farao. Hii ndiyo sababu hawakuuza ardhi yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu akawaambia watu, “Kwa vile nimewanunua ninyi pamoja na nchi yenu leo kuwa mali ya Farao, hapa kuna mbegu kwa ajili yenu ili mweze kuziotesha. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Lakini wakati mazao yatakapokuwa tayari, mpeni Farao sehemu ya tano. Sehemu hizo nne zitakazobaki mtaziweka kama mbegu kwa ajili ya mashamba, na kwa ajili ya chakula chenu wenyewe, na cha watu wa nyumbani mwenu na watoto wenu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wakamwambia, “Umeokoa maisha yetu. Basi na tupate kibali mbele ya macho ya bwana wetu; tutakuwa watumwa wa Farao.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Basi Yusufu akaiweka iwe sheria ya ardhi katika nchi ya Misri, ambayo inatumika hata leo, kwamba sehemu ya tano ya mazao ni mali ya Farao. Ni ardhi ya makuhani tu ambayo haikuwa ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Basi Waisraeli wakaishi Misri katika nchi ya Gosheni. Wakapata mali huko, wakastawi na kuongezeka kwa idadi. ");
INSERT INTO swhonmm_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo akaishi Misri miaka kumi na saba, nayo miaka ya maisha yake ilikuwa mia moja na arobaini na saba (147). ");
INSERT INTO swhonmm_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wakati ulipokaribia wa Israeli kufa, akamwita mwanawe Yusufu na kumwambia, “Kama nimepata kibali machoni pake, weka mkono wako chini ya paja langu na uniahidi kuwa utanifanyia fadhili na uaminifu. Usinizike Misri, ");
INSERT INTO swhonmm_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","lakini nitakapopumzika na baba zangu, unichukue kutoka Misri, ukanizike walipozikwa.” Yusufu akamwambia, “Nitafanya kama unavyosema.” ");
INSERT INTO swhonmm_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Akamwambia, “Niapie.” Ndipo Yusufu akamwapia, naye Israeli akaabudu akiwa ameegemea juu ya kichwa cha fimbo yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Baada ya muda Yusufu akaambiwa, “Baba yako ni mgonjwa.” Kwa hiyo akawachukua wanawe wawili Manase na Efraimu pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo alipoambiwa, “Mwanao Yusufu amekuja kukuona,” Israeli akajitia nguvu, akaketi kitandani. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo akamwambia Yusufu, “Mungu Mwenyezi alinitokea huko Luzu katika nchi ya Kanaani. Akanibariki, ");
INSERT INTO swhonmm_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","naye akaniambia, ‘Nitakufanya ustawi na uongezeke kwa idadi. Nitakufanya kuwa jamii ya mataifa, nami nitakupa nchi hii uimiliki milele, wewe na wazao wako baada yako.’ ");
INSERT INTO swhonmm_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Sasa basi, wanao wawili waliozaliwa kwako huku Misri kabla sijaja hapa kwako watahesabiwa kuwa wangu; Efraimu na Manase watakuwa wangu, vile Reubeni na Simeoni walivyo wangu. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Lakini watoto utakaowazaa baada yao watakuwa wako. Katika nchi watakayoirithi, watatambuliwa kwa jina la ndugu zao. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nilipokuwa ninarudi kutoka Padani, nilihuzunika sana kwa sababu Raheli alifariki katika nchi ya Kanaani tulipokuwa tukisafiri, tukiwa karibu kufika Efrata. Kwa hiyo nilimzika huko, kando ya njia iendayo Efrata” (yaani Bethlehemu). ");
INSERT INTO swhonmm_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israeli alipowaona wana wa Yusufu, akauliza, “Hawa ni nani?” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu akamjibu baba yake, “Hawa ni wana ambao Mungu amenipa nikiwa huku.” Ndipo Israeli akasema, “Walete kwangu ili niwabariki.” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Basi macho ya Israeli yalikuwa hayaoni vizuri kwa sababu ya uzee, naye aliona kwa shida. Kwa hiyo Yusufu akawaleta wanawe karibu na baba yake, naye Israeli akawabusu na kuwakumbatia. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israeli akamwambia Yusufu, “Kamwe sikutazamia kuuona uso wako tena, lakini sasa Mungu ameniruhusu kuwaona watoto wako pia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ndipo Yusufu akawaondoa wanawe magotini mwa Israeli, naye akasujudu, uso wake ukagusa chini. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu akachukua wale wana wawili, Efraimu kwenye mkono wake wa kuume akimwelekeza kwenye mkono wa kushoto wa Israeli, na Manase katika mkono wake wa kushoto akimwelekeza kwenye mkono wa kuume wa Israeli, akawaleta karibu na babu yao. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Lakini Israeli akaupeleka mkono wake wa kuume, akauweka juu ya kichwa cha Efraimu, ingawa ndiye alikuwa mdogo; nao mkono wake wa kushoto, ukipishana na mkono wa kuume, akauweka juu ya kichwa cha Manase, ingawa Manase ndiye alikuwa mzaliwa wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ndipo akambariki Yusufu akisema, “Mungu ambaye baba zangu Ibrahimu na Isaka walimtii, Mungu ambaye amekuwa mchungaji wa maisha yangu yote hadi leo, ");
INSERT INTO swhonmm_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malaika ambaye aliniokoa kutoka madhara yote, yeye na awabariki vijana hawa. Na waitwe kwa jina langu na kwa majina ya baba zangu Ibrahimu na Isaka, wao na waongezeke kwa wingi katika dunia.” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu alipoona baba yake akiweka mkono wa kuume juu ya kichwa cha Efraimu, hakupendezwa, kwa hiyo akauchukua mkono wa baba yake kutoka kichwa cha Efraimu na kuuweka juu ya kichwa cha Manase. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu akamwambia, “Hapana, baba yangu, huyu ndiye mzaliwa wa kwanza; uweke mkono wako wa kuume juu ya kichwa chake.” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lakini baba yake akakataa, akasema, “Ninajua, mwanangu, ninajua. Yeye pia atakuwa taifa, naye pia atakuwa mkuu. Hata hivyo, ndugu yake mdogo atakuwa mkuu kuliko yeye, nao wazao wake watakuwa kundi la mataifa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Akawabariki siku ile na kusema, “Kwa jina lenu Israeli watatamka baraka hii: ‘Mungu na awafanye kama Efraimu na Manase.’ ” Kwa hiyo akamtanguliza Efraimu mbele ya Manase. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ndipo Israeli akamwambia Yusufu, “Ninakaribia kufa, lakini Mungu atakuwa pamoja nanyi, na atawarudisha katika nchi ya baba zenu. ");
INSERT INTO swhonmm_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kwako wewe, kama aliye juu ya ndugu zako, ninakupa sehemu moja zaidi ya ndugu zako, lile eneo nililoteka kwa Waamori kwa upanga wangu na upinde wangu.” ");
INSERT INTO swhonmm_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ndipo Yakobo akawaita wanawe na kusema: “Kusanyikeni, mnizunguke ili niweze kuwaambia yale yatakayowatokea siku zijazo. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Kusanyikeni na msikilize, enyi wana wa Yakobo; msikilizeni baba yenu Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reubeni, wewe ni mzaliwa wangu wa kwanza, nguvu zangu, tunda la kwanza la nguvu zangu; umepita kwa heshima, umepita kwa uwezo. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Usiyezuiwa kama maji, basi hutakuwa mkuu tena, kwa kuwa ulipanda kwenye kitanda cha baba yako, kwenye kitanda changu na kukinajisi. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Lawi ni ndugu: panga zao ni silaha za jeuri. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mimi na nisiingie katika baraza lao, nami nisiunganike katika kusanyiko lao, kwa kuwa wamewaua watu katika hasira yao, na kukata mishipa ya miguu ya mafahali kama walivyopenda. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Hasira yao na ilaaniwe, kwa kuwa ni kali mno, nayo ghadhabu yao ni ya ukatili! Nitawatawanya katika Yakobo, na kuwasambaza katika Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, ndugu zako watakusifu; mkono wako utakuwa shingoni mwa adui zako; wana wa baba yako watakusujudia. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ee Yuda, wewe ni mwana simba; unarudi toka mawindoni, mwanangu. Kama simba hunyemelea na kulala chini, kama simba jike: nani athubutuye kumwamsha? ");
INSERT INTO swhonmm_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Fimbo ya ufalme haitaondoka kwa Yuda, wala fimbo ya mtawala kati ya miguu yake, hadi aje yeye ambaye milki ni yake, ambaye utii wa mataifa ni wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Atamfunga punda wake katika mzabibu, naye mwana-punda wake kwenye tawi lililo bora zaidi; atafua mavazi yake katika divai, majoho yake katika damu ya mizabibu. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Macho yake yatakuwa mekundu kwa divai, meno yake yatakuwa meupe kwa maziwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabuloni ataishi pwani ya bahari na kuwa bandari za kuegesha meli; mpaka wake utapanuka kuelekea Sidoni. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakari ni punda mwenye nguvu ambaye amelala kati ya mizigo yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Aonapo palivyo pazuri mahali pake pa kupumzika na jinsi nchi yake inavyopendeza, atainamisha bega lake kwenye mzigo na kujitolea kwa ajili ya kazi ngumu. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani atahukumu watu wake kwa haki kama mmoja wa makabila ya Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani atakuwa nyoka kando ya barabara, nyoka mwenye sumu kando ya njia, yule aumaye visigino vya farasi ili yule ampandaye aanguke chali. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ee Mwenyezi Mungu, nautafuta wokovu wako. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi atashambuliwa ghafula na kundi la washambuliaji, lakini yeye atawageukia na kuwashinda kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Chakula cha Asheri kitakuwa kinono, naye atatoa chakula kitamu kinachomfaa mfalme. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali ni kulungu jike aliyeachiwa huru azaaye watoto wazuri. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu ni mzabibu uzaao, mzabibu uzaao ulio kando ya chemchemi, ambao matawi yake hutanda ukutani. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kwa uchungu wapiga mshale walimshambulia, wakampiga mshale kwa ukatili. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Lakini upinde wake ulibaki imara, mikono yake ikatiwa nguvu, na mkono wa Mwenye Nguvu wa Yakobo, kwa sababu ya Mchungaji, Mwamba wa Israeli, ");
INSERT INTO swhonmm_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","kwa sababu ya Mungu wa baba yako, anayekusaidia, kwa sababu ya Mwenyezi, yeye anayekubariki kwa baraka za juu mbinguni, baraka za kilindi kilichoko chini, baraka za matitini na za tumbo la uzazi. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Baraka za baba yako ni kubwa kuliko baraka za milima ya kale, nyingi kuliko vilima vya kale. Baraka hizo zote na zikae juu ya kichwa cha Yusufu, juu ya paji la yule mkuu miongoni mwa ndugu zake. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamini ni mbwa-mwitu mwenye njaa kuu; asubuhi hurarua mawindo yake, jioni hugawa nyara.” ");
INSERT INTO swhonmm_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Haya yote ndiyo makabila kumi na mawili ya Israeli, na hivi ndivyo baba yao alivyowaambia alipowabariki, akimpa kila mmoja baraka iliyomfaa. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ndipo alipowapa maelekezo haya: “Mimi niko karibu kukusanywa kwa watu wangu. Mnizike pamoja na baba zangu kwenye pango katika shamba la Efroni, Mhiti, ");
INSERT INTO swhonmm_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","pango lililoko katika shamba la Makpela, karibu na Mamre huko Kanaani, ambalo Ibrahimu alinunua liwe mahali pa kuzikia kutoka kwa Efroni, Mhiti, pamoja na shamba. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Huko ndiko Ibrahimu na Sara mkewe walikozikwa, huko akazikwa Isaka na Rebeka mkewe, na huko nilimzika Lea. ");
INSERT INTO swhonmm_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Shamba hilo na pango lililo ndani yake lilinunuliwa kutoka kwa Wahiti.” ");
INSERT INTO swhonmm_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Baada ya Yakobo kumaliza kutoa maelekezo hayo kwa wanawe, akarudisha miguu yake kitandani, akapumua pumzi ya mwisho, na akakusanywa kwa watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Basi Yusufu akamwangukia baba yake, akalilia juu yake na akambusu. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ndipo Yusufu akawaagiza matabibu waliokuwa wakimhudumia, wamtie baba yake Israeli dawa asioze. Hivyo matabibu wakamtia dawa asioze, ");
INSERT INTO swhonmm_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","wakatumia siku arobaini, muda uliohitajika kutia dawa asioze. Nao Wamisri wakamwombolezea Yakobo kwa siku sabini. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Siku za kumwombolezea zilipokwisha, Yusufu akawaambia washauri wa Farao, “Kama nimepata kibali machoni penu semeni na Farao kwa ajili yangu. Mwambieni, ");
INSERT INTO swhonmm_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baba yangu aliniapisha na kuniambia, “Mimi niko karibu kufa; unizike katika kaburi lile nililochimba kwa ajili yangu mwenyewe katika nchi ya Kanaani.” Sasa nakuomba uniruhusu niende kumzika baba yangu, nami nitarudi.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao akasema, “Panda, uende kumzika baba yako, kama alivyokuapiza kufanya.” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Hivyo Yusufu akapanda kwenda kumzika baba yake. Maafisa wote wa Farao wakaenda pamoja naye, watu mashuhuri wa baraza lake, na watu mashuhuri wote wa Misri. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Hawa ni mbali na watu wote wa nyumbani mwa Yusufu, na ndugu zake, na wale wote wa nyumbani mwa baba yake. Ni watoto wao, makundi yao ya kondoo, mbuzi na ng’ombe tu waliobakia katika nchi ya Gosheni. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Magari ya vita na wapanda farasi pia walipanda pamoja naye. Likawa kundi kubwa sana. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Walipofika kwenye sakafu ya kupuria nafaka ya Atadi, karibu na Yordani, wakalia kwa sauti na kwa uchungu. Yusufu akakaa huko kwa siku saba kumwombolezea baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wakanaani walioishi huko walipoona maombolezo yaliyofanyika katika sakafu ile ya kupuria ya Atadi, wakasema, “Wamisri wanafanya maombolezo makubwa.” Kwa hiyo mahali pale karibu na Yordani pakaitwa Abel-Mizraimu. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hivyo wana wa Yakobo wakafanya kama baba yao alivyowaagiza: ");
INSERT INTO swhonmm_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wakamchukua hadi nchi ya Kanaani, wakamzika kwenye pango katika shamba la Makpela, karibu na Mamre, ambalo Ibrahimu alilinunua kutoka kwa Efroni Mhiti pamoja na shamba liwe mahali pa kuzikia. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Baada ya Yusufu kumzika baba yake, akarudi Misri pamoja na ndugu zake na wale wote waliokuwa wameenda naye kumzika baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ndugu zake Yusufu walipoona kwamba baba yao amekufa, wakasema, “Itakuwaje kama Yusufu ataweka kinyongo dhidi yetu na kutulipa mabaya yote tuliyomtendea?” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kwa hiyo wakampelekea Yusufu ujumbe, wakasema, “Kabla baba yako hajafa aliacha maagizo haya: ");
INSERT INTO swhonmm_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Hili ndilo mtakalomwambia Yusufu: Ninakuomba uwasamehe ndugu zako dhambi na mabaya kwa vile walivyokutenda vibaya.’ Sasa tafadhali samehe dhambi za watumishi wa Mungu wa baba yako.” Ujumbe huu ulipomfikia, Yusufu akalia. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ndipo ndugu zake wakaja na kujitupa chini mbele yake. Wakasema, “Sisi ni watumwa wako.” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lakini Yusufu akawaambia, “Msiogope. Je, mimi ni badala ya Mungu? ");
INSERT INTO swhonmm_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mlikusudia kunidhuru, lakini Mungu alikusudia mema, ili litimie hili linalofanyika sasa, kuokoa maisha ya watu wengi. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hivyo basi, msiogope. Mimi nitawatunza ninyi nyote pamoja na watoto wenu.” Akawafariji na kusema nao kwa wema. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu akakaa katika nchi ya Misri, yeye pamoja na jamaa yote ya baba yake. Akaishi miaka mia moja na kumi, ");
INSERT INTO swhonmm_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","naye akaona kizazi cha tatu cha watoto wa Efraimu. Pia akaona watoto wa Makiri mwana wa Manase, wakawekwa magotini mwa Yusufu walipozaliwa. ");
INSERT INTO swhonmm_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ndipo Yusufu akawaambia ndugu zake, “Mimi ninakaribia kufa. Lakini kwa hakika Mungu atawasaidia na kuwachukueni kutoka nchi hii na kuwapeleka katika nchi aliyomwahidi kwa kiapo Ibrahimu, Isaka na Yakobo.” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Naye Yusufu akawaapisha wana wa Israeli na kuwaambia, “Hakika Mungu atawasaidia, nanyi ni lazima mhakikishe mmepandisha mifupa yangu kutoka mahali hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kwa hiyo Yusufu akafa akiwa na umri wa miaka mia moja na kumi. Baada ya kumtia dawa asioze, akawekwa kwenye jeneza huko Misri.");
INSERT INTO swhonmm_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Haya ndiyo majina ya wana wa Israeli waliokwenda Misri pamoja na Yakobo, kila mmoja na jamaa yake: ");
INSERT INTO swhonmm_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reubeni, Simeoni, Lawi na Yuda; ");
INSERT INTO swhonmm_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zabuloni na Benyamini; ");
INSERT INTO swhonmm_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani na Naftali, Gadi na Asheri. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Wazao wote wa Yakobo walikuwa watu sabini; Yusufu alikuwa tayari yuko Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Basi Yusufu na kaka zake wote na kizazi kile chote walikufa, ");
INSERT INTO swhonmm_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","lakini Waisraeli walikuwa wamezaana na kuongezeka sana, idadi yao ikawa kubwa mno, hadi wakaijaza nchi. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kisha mfalme mwingine ambaye hakufahamu habari za Yusufu akatawala Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Akawaambia watu wake, “Tazameni, Waisraeli wamekuwa wengi mno kwa idadi kuliko sisi. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Njooni, ni lazima tuwashughulikie kwa uangalifu, la sivyo watazidi kuwa wengi zaidi, na ikiwa patatokea vita, watajiunga na adui zetu kupigana nasi, na kuondoka katika nchi hii.” ");
INSERT INTO swhonmm_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Basi Wamisri wakaweka wasimamizi wa kuwasimamia na kuwatesa Waisraeli kwa kazi ngumu, nao wakajenga miji ya Pithomu na Ramesesi ya kuweka akiba ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lakini walivyozidi kuteswa, ndivyo walivyozidi kuongezeka na kuenea katika nchi. Wamisri wakawaogopa Waisraeli, ");
INSERT INTO swhonmm_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","kwa hiyo wakawatumikisha kwa ukatili. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wakafanya maisha ya Waisraeli kuwa machungu kwa kufanya kazi ngumu ya kutengeneza lami na kufyatua matofali, na kazi zote za mashambani; katika kazi zao zote ngumu, Wamisri waliwatumia Waisraeli kwa ukatili. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mfalme wa Misri akawaita wakunga waliowazalisha Waebrania, ambao majina yao yalikuwa Shifra na Pua, akawaambia, ");
INSERT INTO swhonmm_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mtakapowazalisha wanawake Waebrania, chunguzeni wanapojifungua. Ikiwa ni mtoto wa kiume, muueni; lakini ikiwa ni msichana, mwacheni aishi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lakini hao wakunga walimcha Mungu na hawakufanya kile mfalme wa Misri alichowaambia kufanya, bali wakawaacha watoto wa kiume waishi. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ndipo mfalme wa Misri akawaita hao wakunga, akawauliza, “Kwa nini mmefanya hivi? Mbona mmeacha watoto wa kiume waishi?” ");
INSERT INTO swhonmm_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Wakunga wakamjibu Farao, “Wanawake wa Waebrania ni tofauti na wanawake wa Misri; wao wana nguvu, nao hujifungua watoto kabla wakunga hawajafika.” ");
INSERT INTO swhonmm_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kwa hiyo Mungu akawatendea mema wakunga hao. Waisraeli wakaongezeka na kuendelea kuwa wengi zaidi. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kwa vile hao wakunga walimcha Mungu, Mungu akawajalia kuwa na jamaa zao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kisha Farao akatoa agizo hili kwa watu wake wote: “Kila mtoto wa kiume atakayezaliwa kwa Waebrania lazima atupwe katika Mto Naili, bali kila mtoto wa kike aachwe aishi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Basi mtu mmoja wa nyumba ya Lawi akaoa mwanamke Mlawi, ");
INSERT INTO swhonmm_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","naye mwanamke huyo akapata mimba, akazaa mtoto wa kiume. Alipoona mtoto huyo ni mzuri, akamficha kwa miezi mitatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Lakini alipoona hawezi kuendelea kumficha, akamtengenezea kisafina cha mafunjo, akakipaka lami. Kisha akamweka huyo mtoto ndani yake, akakificha kwenye matete kando ya ukingo wa Mto Naili. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Dada ya huyo mtoto akasimama mbali ili kuona kitakachompata mtoto. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ndipo binti Farao akateremka kwenye Mto Naili kuoga, nao wahudumu wake wakawa wanatembea ukingoni mwa mto. Binti Farao akaona kisafina kwenye matete, akamtuma mmoja wa wajakazi wake kukichukua. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Alifungua kisafina akaona mtoto ndani yake. Mtoto alikuwa akilia, akamhurumia. Akasema, “Huyu ni mmoja wa watoto wa Waebrania.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ndipo dada wa huyo mtoto akamuuliza binti Farao, “Je, niende nikakutafutie mmoja wa wanawake wa Waebrania akulelee huyu mtoto?” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Binti Farao akamjibu, “Ndiyo, nenda.” Yule msichana akaenda akamleta mama wa mtoto. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Binti Farao akamwambia, “Mchukue huyu mtoto unisaidie kumlea, nami nitakulipa.” Basi yule mwanamke akamchukua mtoto na kumlea. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mtoto alipokua, akampeleka kwa binti Farao, naye akawa mwanawe. Akamwita jina Musa, akisema, “Nilimtoa kwenye maji.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Siku moja, Musa alipokuwa mtu mzima, alienda mahali walipokuwa ndugu zake, na akaona jinsi walivyokuwa wakifanyishwa kazi ngumu. Akamwona Mmisri akimpiga Mwebrania, mmoja wa watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa akatazama huku na huko asione mtu yeyote, akamuua yule Mmisri, akamficha kwenye mchanga. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kesho yake akatoka, akaona Waebrania wawili wakipigana. Akamuuliza yule aliyekosa, “Mbona unampiga Mwebrania mwenzako?” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Yule mtu akamjibu, “Ni nani aliyekufanya mtawala na mwamuzi juu yetu? Je, unataka kuniua kama ulivyomuua yule Mmisri?” Ndipo Musa akaogopa na kuwaza, “Jambo lile nililofanya lazima limefahamika.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao aliposikia jambo hili, alijaribu kumuua Musa, lakini Musa akamkimbia Farao na kwenda kuishi katika nchi ya Midiani, akaketi kando ya kisima. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Kuhani wa Midiani alikuwa na binti saba, nao wakaja kisimani ili kuchota maji na kujaza birika kwa ajili ya kunyweshea mifugo ya baba yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Baadhi ya wachungaji wakaja wakawafukuza hao wasichana. Ndipo Musa akainuka, akawasaidia kunywesha mifugo yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wasichana hao waliporudi nyumbani, baba yao Reueli akawauliza, “Imekuwaje leo mmerudi mapema hivyo?” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wakamjibu, “Mmisri mmoja alituokoa kutoka mikono ya wachungaji. Pia mtu huyo alituchotea maji na kunywesha mifugo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Akawauliza binti zake, “Yuko wapi? Mbona mmemwacha? Mkaribisheni ale chakula.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa akakubali kukaa kwa huyo mtu, ambaye alimpa Musa binti yake aliyeitwa Sipora amwoe. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipora alizaa mtoto wa kiume, naye Musa akamwita jina Gershomu, akisema, “Nimekuwa mgeni katika nchi ya kigeni.” ");
INSERT INTO swhonmm_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Baada ya muda mrefu, mfalme wa Misri akafa. Waisraeli wakalia kwa huzuni katika utumwa wao, walilia na kilio chao cha kutaka msaada kwa ajili ya utumwa kikamfikia Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mungu akasikia kilio chao cha huzuni, akakumbuka agano alilofanya na Ibrahimu pamoja na Isaka na Yakobo. ");
INSERT INTO swhonmm_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Kwa hiyo Mungu akawaangalia Waisraeli na kuwahurumia. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Basi Musa alikuwa anachunga mifugo ya Yethro mkwewe, kuhani wa Midiani. Musa akapeleka mifugo mbali nyuma ya jangwa, naye akafika Horebu, mlima wa Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Huko malaika wa Mwenyezi Mungu akamtokea Musa katika mwali wa moto kutoka kichakani. Musa akaona kwamba ingawa kile kichaka kilikuwa kinawaka moto, kilikuwa hakiteketei. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ndipo Musa akawaza, “Nitageuka sasa nione kitu hiki cha ajabu, nami nione ni kwa nini kichaka hiki hakiteketei.” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mwenyezi Mungu alipoona kuwa amegeuka ili aone, Mungu akamwita kutoka ndani ya kile kichaka, “Musa! Musa!” Naye Musa akajibu, “Mimi hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mungu akamwambia, “Usikaribie zaidi. Vua viatu vyako, kwa maana mahali unaposimama ni patakatifu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kisha akamwambia, “Mimi ni Mungu wa baba yako, Mungu wa Ibrahimu, Mungu wa Isaka, na Mungu wa Yakobo.” Musa aliposikia hayo, akafunika uso wake kwa sababu aliogopa kumtazama Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mwenyezi Mungu akamwambia, “Hakika nimeona mateso ya watu wangu katika Misri. Nimesikia kilio chao kwa sababu ya wasimamizi wao, nami nimeguswa na mateso yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Basi nimeshuka niwaokoe kutoka mkono wa Wamisri, niwatoe na kuwapandisha kutoka nchi hiyo, niwapeleke katika nchi nzuri na kubwa, nchi inayotiririka maziwa na asali, nchi ya Wakanaani, Wahiti, Waamori, Waperizi, Wahivi na Wayebusi. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sasa kilio cha Waisraeli kimenifikia, nami nimeona jinsi Wamisri wanavyowatesa. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Basi, sasa nenda. Ninakutuma kwa Farao ili kuwatoa watu wangu Waisraeli kutoka Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lakini Musa akamwambia Mungu, “Mimi ni nani hata niende kwa Farao kuwatoa Waisraeli nchini Misri?” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Naye Mungu akasema, “Mimi nitakuwa pamoja nawe. Hii itakuwa ishara kwako kwamba ni Mimi nimekutuma: Utakapokuwa umewatoa watu Misri, mtamwabudu Mungu katika mlima huu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa akamwambia Mungu, “Ikiwa nitawaendea Waisraeli na kuwaambia, ‘Mungu wa baba zenu amenituma kwenu,’ nao wakiniuliza, ‘Jina lake ni nani?’ Nitawaambia nini?” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mungu akamwambia Musa, “Mimi niko ambaye niko. Hivyo ndivyo utakavyowaambia Waisraeli: ‘Mimi niko amenituma kwenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Vilevile Mungu akamwambia Musa, “Waambie Waisraeli, ‘Mwenyezi Mungu, Mungu wa baba zenu, Mungu wa Ibrahimu, Mungu wa Isaka, na Mungu wa Yakobo amenituma kwenu.’ “Hili ndilo Jina langu milele, Jina ambalo mtanikumbuka kwalo kizazi hadi kizazi. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Nenda, ukawakusanye wazee wa Israeli, uwaambie, ‘Mwenyezi Mungu, Mungu wa baba zenu, Mungu wa Ibrahimu, Isaka na Yakobo, alinitokea akaniambia: Nimewatazama, nami nimeona mliyotendewa huku Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nami nimeahidi kuwapandisha kutoka kwenye mateso yenu katika nchi ya Misri, niwapeleke nchi ya Wakanaani, Wahiti, Waamori, Waperizi, Wahivi na Wayebusi, nchi inayotiririka maziwa na asali.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Wazee wa Israeli watakusikiliza. Kisha wewe na wazee mtaenda kwa mfalme wa Misri na kumwambia, ‘Mwenyezi Mungu, Mungu wa Waebrania, ametutokea. Turuhusu twende safari ya siku tatu huko jangwani kutoa dhabihu kwa Mwenyezi Mungu, Mungu wetu.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Lakini nafahamu kwamba mfalme wa Misri hatawaruhusu kwenda, hadi mkono wenye nguvu umlazimishe. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kwa hiyo nitaunyoosha mkono wangu na kuwapiga Wamisri kwa maajabu yote nitakayofanya miongoni mwao. Baada ya hayo, atawaruhusu mwondoke. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nami nitawapa hawa watu upendeleo mbele ya Wamisri, kwa hiyo mtakapoondoka nchini hamtaondoka mikono mitupu. ");
INSERT INTO swhonmm_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kila mwanamke Mwisraeli atamwomba jirani yake Mmisri na mwanamke yeyote anayeishi nyumbani mwake ampe vyombo vya fedha, dhahabu na mavazi, ambavyo mtawavika wana wenu wa kiume na wa kike. Hivyo mtawateka nyara Wamisri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa akamjibu, “Itakuwaje wasiponiamini au kunisikiliza, waseme, ‘Mwenyezi Mungu hakukutokea’?” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ndipo Mwenyezi Mungu akamuuliza, “Ni nini hicho kilicho mkononi mwako?” Akamjibu, “Ni fimbo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mwenyezi Mungu akasema, “Itupe chini.” Musa akaitupa fimbo chini, nayo ikawa nyoka, naye akaikimbia. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kisha Mwenyezi Mungu akamwambia, “Nyoosha mkono wako umkamate kwenye mkia.” Basi Musa akanyoosha mkono akamkamata yule nyoka, naye akabadilika tena kuwa fimbo mkononi mwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mwenyezi Mungu akasema, “Hivi ndivyo Waisraeli watakavyoamini kuwa Mwenyezi Mungu, Mungu wa baba zao, Mungu wa Ibrahimu, Mungu wa Isaka, na Mungu wa Yakobo, amekutokea wewe.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kisha Mwenyezi Mungu akamwambia, “Weka mkono wako ndani ya joho lako.” Basi Musa akaweka mkono wake ndani ya joho lake, naye alipoutoa, ulikuwa na ukoma, mweupe kama theluji. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mungu akamwambia, “Sasa urudishe tena huo mkono ndani ya joho lako.” Basi Musa akaurudisha mkono wake ndani ya joho lake na alipoutoa, ulikuwa mzima, kama sehemu zingine za mwili wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ndipo Mwenyezi Mungu akamwambia, “Kama hawatakuamini wewe, au kutojali ishara ya kwanza, wataamini ishara ya pili. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Lakini kama hawataamini ishara hizi mbili au hawatawasikiliza ninyi, chukua kiasi cha maji kutoka Mto Naili uyamimine juu ya ardhi kavu. Maji mtakayotoa mtoni yatakuwa damu juu ya ardhi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa akamwambia Mwenyezi Mungu, “Ee Bwana, kamwe sijapata kuwa msemaji kwa ufasaha hapo awali, wala tangu ulipoanza kuzungumza na mtumishi wako. Ulimi wangu ni mzito kuzungumza.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mwenyezi Mungu akamwambia, “Ni nani aliyempa mwanadamu kinywa? Ni nani aliyemfanya mtu kuwa kiziwi au bubu? Ni nani anayempa mtu uwezo wa kuona au upofu? Je, si mimi, Mwenyezi Mungu? ");
INSERT INTO swhonmm_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Sasa nenda, nitakusaidia kusema, nami nitakufundisha jambo la kusema.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lakini Musa akasema, “Ee Bwana, tafadhali mtume mtu mwingine kufanya kazi hiyo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ndipo hasira ya Mwenyezi Mungu ikawaka dhidi ya Musa, akamwambia, “Vipi kuhusu ndugu yako, Haruni Mlawi? Ninajua yeye anaweza kuzungumza vizuri. Naye yuko tayari njiani kukulaki, na moyo wake utafurahi wakati atakapokuona. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Utazungumza naye na kuweka maneno kinywani mwake. Nitawasaidia ninyi wawili kusema, nami nitawafundisha jambo la kufanya. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haruni ataongea na watu badala yako na itakuwa kwamba yeye amekuwa kinywa chako nawe utakuwa kama Mungu kwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Lakini chukua fimbo hii mkononi mwako ili uweze kuitumia kufanya ishara hizo za ajabu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kisha Musa akarudi kwa Yethro mkwewe akamwambia, “Niruhusu nirudi kwa watu wangu Misri kuona kama yuko hata mmoja wao ambaye bado anaishi.” Yethro akamwambia, “Nenda, nami nakutakia mema.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Basi Mwenyezi Mungu alikuwa amemwambia Musa huko Midiani, “Rudi Misri kwa maana watu wote waliotaka kukuua wamekufa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Basi Musa akamchukua mkewe na wanawe, akawapandisha juu ya punda na kuanza safari kurudi Misri. Naye akaichukua ile fimbo ya Mungu mkononi mwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mwenyezi Mungu akamwambia Musa, “Utakaporudi Misri, hakikisha kwamba utafanya mbele ya Farao maajabu yote niliyokupa uwezo wa kuyafanya. Lakini nitafanya moyo wake kuwa mgumu ili asiwaruhusu watu waende. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kisha mwambie Farao, ‘Hili ndilo asemalo Mwenyezi Mungu: Israeli ni mwanangu mzaliwa wa kwanza, ");
INSERT INTO swhonmm_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","nami nilikuambia, “Ruhusu mwanangu aondoke, ili aweze kuniabudu mimi.” Lakini ukakataa kumruhusu aende; basi nitaua mwana wako mzaliwa wa kwanza.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Musa alipokuwa mahali pa kulala wageni akiwa njiani kurudi Misri, Mwenyezi Mungu akakutana naye, akataka kumuua. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Lakini Sipora akachukua kisu cha gumegume, akakata govi la mwanawe na kugusa miguu ya Musa nalo. Sipora akasema, “Hakika wewe ni bwana arusi wa damu kwangu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Sipora alipomwita Musa, “Bwana arusi wa damu”, alikuwa anamaanisha ile tohara.) Baada ya hayo Mwenyezi Mungu akamwacha. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mwenyezi Mungu akamwambia Haruni, “Nenda jangwani ukamlaki Musa.” Basi akakutana na Musa kwenye mlima wa Mungu, akambusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kisha Musa akamwambia Haruni kila kitu Mwenyezi Mungu alichomtuma kusema, vilevile habari za ishara na maajabu alizokuwa amemwamuru kufanya. ");
INSERT INTO swhonmm_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa na Haruni wakawakusanya wazee wote wa Waisraeli, ");
INSERT INTO swhonmm_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","naye Haruni akawaambia kila kitu Mwenyezi Mungu alichokuwa amemwambia Musa. Pia akafanya ishara mbele ya watu, ");
INSERT INTO swhonmm_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","nao wakaamini. Nao waliposikia kuwa Mwenyezi Mungu anajishughulisha nao, na kwamba ameona mateso yao, walisujudu na kuabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Baadaye Musa na Haruni wakaenda kwa Farao, wakamwambia, “Hili ndilo asemalo Mwenyezi Mungu, Mungu wa Israeli: ‘Waruhusu watu wangu waende, ili waweze kunifanyia sikukuu huko jangwani.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao akasema, “Huyo Mwenyezi Mungu ni nani, hata nimtii na kuruhusu Waisraeli waende? Simjui huyo Mwenyezi Mungu wala sitawaruhusu Waisraeli waende.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ndipo Musa na Haruni wakasema, “Mungu wa Waebrania amekutana nasi. Sasa turuhusu tuwe na safari ya siku tatu ya jangwani ili tukamtolee Mwenyezi Mungu, Mungu wetu, dhabihu, la sivyo aweza kutupiga sisi kwa tauni au kwa upanga.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lakini mfalme wa Misri akasema, “Mbona ninyi Musa na Haruni mnawaondoa watu kutoka kwenye kazi zao? Rudini kwenye kazi zenu!” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kisha Farao akasema, “Tazama, sasa watu hawa ni wengi, nanyi mnawazuia kufanya kazi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siku hiyo hiyo, Farao akatoa amri hii kwa viongozi wa watumwa na wasimamizi wa watu, akawaambia: ");
INSERT INTO swhonmm_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Tangu sasa msiwape hawa watu nyasi za kutengenezea matofali; wakusanye nyasi zao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Lakini watakeni kutengeneza matofali kiasi kile kile cha mwanzo, kiwango kisipunguzwe. Wao ni wavivu, ndiyo sababu wanalia, wakisema, ‘Turuhusiwe twende kumtolea Mungu wetu dhabihu.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Fanyeni kazi kuwa ngumu zaidi kwa watu hao ili wakazane na kazi na kuacha kusikiliza uongo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Basi viongozi wa watumwa na wasimamizi wakaenda kuwaambia watu, “Hivi ndivyo Farao asemavyo: ‘Sitawapa nyasi tena. ");
INSERT INTO swhonmm_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nendeni mkatafute nyasi wenyewe popote mnapoweza kuzipata, lakini kazi yenu haitapunguzwa hata kidogo.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Basi watu wakatawanyika kote nchini Misri kukusanya mabua ya kutumia badala ya nyasi. ");
INSERT INTO swhonmm_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Viongozi wa watumwa wakasisitiza wakisema, “Timizeni kazi mnayotakiwa kwa kila siku, kama wakati ule mlipokuwa mkipewa nyasi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wasimamizi wa Waisraeli waliochaguliwa na viongozi wa watumwa wa Farao walipigwa na kuulizwa, “Kwa nini hamkutimiza kiwango chenu cha kutengeneza matofali jana na leo, kama mwanzoni?” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ndipo wasimamizi wa Waisraeli wakaenda kumlilia Farao, wakisema: “Mbona umewatendea watumishi wako hivi? ");
INSERT INTO swhonmm_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Watumishi wako hawapewi nyasi, hata hivyo tumeambiwa, ‘Tengenezeni matofali!’ Watumishi wako wanapigwa, lakini kosa ni la watu wako wenyewe.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao akasema, “Ninyi ni wavivu ndiyo sababu mnasema, ‘Turuhusu twende tukamtolee Mwenyezi Mungu dhabihu.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sasa nendeni kazini. Hamtapewa nyasi zozote, nanyi ni lazima mtengeneze matofali.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Wasimamizi wa Waisraeli walitambua kuwa wako taabani walipoambiwa, “Hamtakiwi kupunguza idadi ya matofali mliotakiwa kutengeneza kila siku.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Walipoondoka kwa Farao, wakawakuta Musa na Haruni wakingojea kukutana nao, ");
INSERT INTO swhonmm_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","wakawaambia Musa na Haruni, “Mwenyezi Mungu na awaangalie awahukumu ninyi! Mmetufanya tuwe chukizo kwa Farao na maafisa wake, nanyi mmeweka upanga mikononi mwao ili kutuua sisi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa akarudi kwa Mwenyezi Mungu na kumwambia, “Ee Bwana, mbona umewaletea watu hawa taabu? Kwa nini basi ukanituma mimi? ");
INSERT INTO swhonmm_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tangu nilipokwenda kuzungumza na Farao kwa jina lako, amewaletea watu hawa taabu, nawe kamwe hujawakomboa watu wako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kisha Mwenyezi Mungu akamwambia Musa, “Sasa utaona kitu nitakachomfanyia Farao: Kwa sababu ya mkono wangu wenye nguvu atawaachia watu waende; kwa sababu ya mkono wangu wenye nguvu atawafukuza waondoke nchini mwake.” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Pia Mungu akamwambia Musa, “Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nilimtokea Ibrahimu, na Isaka, na Yakobo kama Mungu Mwenyezi, ingawa kwa Jina langu, Yehova, sikujitambulisha kwao. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Pia niliweka agano langu nao kuwapa nchi ya Kanaani, ambako waliishi kama wageni. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Zaidi ya hayo, nimesikia kilio cha huzuni cha Waisraeli ambao Wamisri wamewatia utumwani, nami nimelikumbuka agano langu. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kwa hiyo, waambie Waisraeli: ‘Mimi ndimi Mwenyezi Mungu, nami nitawatoa katika nira ya Wamisri. Nitawaweka huru mtoke kuwa watumwa wao, nami nitawakomboa kwa mkono ulionyooshwa pamoja na matendo makuu ya hukumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nitawachukua ninyi kuwa watu wangu mwenyewe, nami nitakuwa Mungu wenu. Ndipo mtajua kuwa mimi ndimi Mwenyezi Mungu, Mungu wenu, niliyewatoa chini ya nira ya Wamisri. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nami nitawaleta hadi nchi niliyoapa kwa mkono ulioinuliwa kumpa Ibrahimu, Isaka na Yakobo. Nitawapa iwe milki yenu. Mimi ndimi Mwenyezi Mungu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa akawaarifu Waisraeli jambo hili, lakini hawakumsikiliza kwa sababu ya kuvunjika moyo na kazi yao ngumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ndipo Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Nenda, mwambie Farao mfalme wa Misri awaachie Waisraeli waondoke nchini mwake.” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Lakini Musa akamwambia Mwenyezi Mungu, “Ikiwa Waisraeli hawatanisikiliza, kwa nini yeye Farao anisikilize mimi, ambaye huzungumza kwa kigugumizi?” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ndipo Mwenyezi Mungu akanena na Musa na Haruni kuhusu Waisraeli na Farao mfalme wa Misri, naye akawaamuru wawatoe Waisraeli kutoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hawa walikuwa wakuu wa jamaa zao: Wana wa Reubeni, mzaliwa wa kwanza wa kiume wa Israeli walikuwa: Hanoki na Palu, Hesroni na Karmi. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wana wa Simeoni walikuwa: Yemueli, Yamini, Ohadi, Yakini, Sohari na Shauli mwana wa mwanamke Mkanaani. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Haya ndiyo majina ya wana wa Lawi, kulingana na orodha zao: Gershoni, Kohathi na Merari. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana wa Gershoni kwa koo walikuwa: Libni na Shimei. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana wa Kohathi walikuwa: Amramu, Ishari, Hebroni na Uzieli. Kohathi aliishi miaka mia moja na thelathini na tatu (133). ");
INSERT INTO swhonmm_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana wa Merari walikuwa: Mahli na Mushi. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramu akamwoa Yokebedi, shangazi yake, aliyemzalia Haruni na Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wana wa Ishari walikuwa: Kora, Nefegi na Zikri. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana wa Uzieli walikuwa: Mishaeli, Elisafani na Sithri. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruni akamwoa Elisheba binti Aminadabu, ndugu yake Nashoni, naye akamzalia Nadabu na Abihu, Eleazari na Ithamari. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wana wa Kora walikuwa: Asiri, Elkana na Abiasafu. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazari mwana wa Haruni akamwoa mmoja wa binti za Putieli, naye akamzalia Finehasi. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Hawa walikuwa Haruni na Musa, wale wale ambao Mwenyezi Mungu aliwaambia, “Watoeni Waisraeli katika nchi ya Misri kwa vikosi vyao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Hao ndio waliozungumza na Farao, mfalme wa Misri kuhusu kuwatoa Waisraeli Misri. Ilikuwa ni huyo Musa na huyo Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mwenyezi Mungu aliponena na Musa huko Misri, ");
INSERT INTO swhonmm_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","akamwambia, “Mimi ndimi Mwenyezi Mungu. Mwambie Farao mfalme wa Misri kila kitu nikuambiacho.” ");
INSERT INTO swhonmm_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lakini Musa akamwambia Mwenyezi Mungu, “Kwa kuwa mimi huzungumza kwa kigugumizi, Farao atanisikiliza mimi?” ");
INSERT INTO swhonmm_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kisha Mwenyezi Mungu akamwambia Musa, “Tazama, nimekufanya kama Mungu kwa Farao, naye Haruni ndugu yako atakuwa nabii wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Utasema kila kitu nitakachokuagiza, naye Haruni ndugu yako atamwambia Farao awaachie Waisraeli watoke katika nchi yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lakini nitaufanya moyo wa Farao kuwa mgumu. Ingawa nitazidisha ishara na maajabu katika Misri, ");
INSERT INTO swhonmm_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","hatawasikiliza. Kisha nitaupeleka mkono wangu juu ya Misri, na kwa matendo makuu ya hukumu nitavitoa vikosi vyangu, watu wangu Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nao Wamisri watajua kuwa Mimi ndimi Mwenyezi Mungu nitakapounyoosha mkono wangu dhidi ya Misri na kuwatoa Waisraeli humo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Haruni wakafanya sawasawa na jinsi Mwenyezi Mungu alivyowaamuru. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa alikuwa na umri wa miaka themanini na Haruni alikuwa na umri wa miaka themanini na tatu walipozungumza na Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mwenyezi Mungu akamwambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Farao atakapowaambia, ‘Fanyeni muujiza,’ basi mwambie Haruni, ‘Chukua fimbo yako na uitupe chini mbele ya Farao,’ nayo fimbo itakuwa nyoka.” ");
INSERT INTO swhonmm_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ndipo Musa na Haruni wakaenda kwa Farao, wakafanya sawasawa na jinsi Mwenyezi Mungu alivyoagiza. Haruni akaitupa ile fimbo yake chini mbele ya Farao na maafisa wake, nayo ikawa nyoka. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao naye akawaita watu wenye maarifa na wachawi na waganga wa Misri, nao wakafanya vivyo hivyo kwa siri ya uganga wao. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kila mmoja alitupa fimbo yake chini, nayo ikawa nyoka. Lakini fimbo ya Haruni ikazimeza zile fimbo zao. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hata hivyo, moyo wa Farao ukawa mgumu, naye hakuwasikiliza Musa na Haruni, kama vile Mwenyezi Mungu alivyokuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kisha Mwenyezi Mungu akamwambia Musa, “Moyo wa Farao ni mgumu; anakataa kuwaacha watu waondoke. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nenda kwa Farao asubuhi anapoenda mtoni. Ngoja ukingoni mwa Mto Naili ili uonane naye, na uchukue mkononi mwako fimbo ile iliyobadilishwa kuwa nyoka. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kisha umwambie, ‘Mwenyezi Mungu, Mungu wa Waebrania, amenituma nikuambie: Waachie watu wangu waende, ili wapate kuniabudu jangwani. Lakini hadi sasa hujasikiliza. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Hili ndilo asemalo Mwenyezi Mungu: Kwa hili utajua kuwa Mimi ndimi Mwenyezi Mungu: Kwa fimbo iliyo mkononi mwangu nitapiga maji ya Mto Naili, nayo yatabadilika kuwa damu. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Samaki walio katika Mto Naili watakufa, nao mto utanuka vibaya; Wamisri hawataweza kunywa maji yake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mwenyezi Mungu akamwambia Musa, “Mwambie Haruni, ‘Chukua ile fimbo yako unyooshe mkono wako juu ya maji ya Misri, juu ya chemchemi na mifereji, juu ya madimbwi na mabwawa yote,’ navyo vitabadilika kuwa damu. Damu itakuwa kila mahali katika Misri, hata kwenye vyombo vya miti na vya mawe.” ");
INSERT INTO swhonmm_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Haruni wakafanya kama vile Mwenyezi Mungu alivyokuwa amewaagiza. Akainua fimbo yake machoni pa Farao na maafisa wake na kuyapiga maji ya Mto Naili, na maji yote yakabadilika kuwa damu. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Samaki katika Mto Naili wakafa, nao mto ukanuka vibaya sana kiasi kwamba Wamisri hawakuweza kunywa maji yake. Damu ilikuwa kila mahali katika nchi ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lakini waganga wa Misri kwa kutumia siri ya uganga wao wakafanya vivyo hivyo, nao moyo wa Farao ukawa mgumu, hakuwasikiliza Musa na Haruni, kama vile Mwenyezi Mungu alivyokuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Badala yake, Farao akageuka, akaenda kwenye jumba lake la kifalme, wala hakulitia hili moyoni. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nao Wamisri wote wakachimba kandokando ya Mto Naili kupata maji ya kunywa, kwa sababu hawakuweza kunywa maji ya mto. ");
INSERT INTO swhonmm_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zilipita siku saba baada ya Mwenyezi Mungu kuyapiga maji ya Mto Naili. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ndipo Mwenyezi Mungu akamwambia Musa, “Nenda kwa Farao ukamwambie, ‘Hili ndilo asemalo Mwenyezi Mungu: Waachie watu wangu waende, ili wapate kuniabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ukikataa kuwaruhusu kuondoka, basi nitaipiga nchi yako yote kwa kuwaletea vyura. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mto Naili utafurika vyura. Watakuja kwenye jumba lako la kifalme na katika chumba chako cha kulala na kitandani mwako, katika nyumba za maafisa wako na kwa watu wako, vyura hao wataingia katika meko yenu na kwenye vyombo vya kukandia unga. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Vyura watapanda juu yako, juu ya watu wako na maafisa wako wote.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ndipo Mwenyezi Mungu akamwambia Musa, “Mwambie Haruni, ‘Nyoosha mkono wako ukiwa na ile fimbo yako juu ya vijito, mifereji na madimbwi, fanya vyura waje juu ya nchi ya Misri.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ndipo Haruni akaunyoosha mkono wake juu ya maji ya Misri, nao vyura wakatokea na kuifunika nchi. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lakini waganga wakafanya vivyo hivyo kwa siri ya uganga wao, nao pia wakafanya vyura kuja juu ya nchi ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ndipo Farao akamwita Musa na Haruni na kusema, “Mwombeni Mwenyezi Mungu awaondoe vyura kutoka kwangu na kwa watu wangu, nami nitawaachia watu wenu waende kumtolea Mwenyezi Mungu dhabihu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa akamwambia Farao, “Ninakupa heshima ya kuamua ni wakati gani wa kukuombea wewe, maafisa wako, na watu wako ili vyura watoke kwenu na kwenye nyumba zenu, isipokuwa wale walio katika Mto Naili.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao akasema, “Kesho.” Musa akamjibu, “Itakuwa kama unavyosema, ili upate kujua kwamba hakuna yeyote kama Mwenyezi Mungu, Mungu wetu. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Vyura wataondoka kwako na katika nyumba zako, kwa maafisa wako na kwa watu wako, ila watabakia katika Mto Naili tu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Baada ya Musa na Haruni kuondoka kwa Farao, Musa akamlilia Mwenyezi Mungu kuhusu vyura aliokuwa amewaleta kwa Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Naye Mwenyezi Mungu akafanya lile Musa alilomwomba. Vyura wakafia ndani ya nyumba, viwanjani na mashambani. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wakayakusanya malundo, nchi nzima ikanuka. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lakini Farao alipoona pametokea nafuu, akaushupaza moyo wake na hakuwasikiliza Musa na Haruni, kama vile Mwenyezi Mungu alivyokuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ndipo Mwenyezi Mungu akamwambia Musa, “Mwambie Haruni, ‘Nyoosha fimbo yako uyapige mavumbi ya ardhi,’ nayo nchi yote ya Misri mavumbi yatakuwa viroboto.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wakafanya hivyo, Haruni aliponyoosha mkono wake wenye fimbo na kuyapiga mavumbi ya nchi, viroboto wakawajia watu na wanyama. Mavumbi yote katika nchi ya Misri yakawa viroboto. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Lakini waganga walipojaribu kutengeneza viroboto kwa siri ya uganga wao, hawakuweza. Nao viroboto walikuwa juu ya watu na wanyama. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Waganga wale wakamwambia Farao, “Hiki ni kidole cha Mungu.” Lakini moyo wa Farao ukawa mgumu naye hakuwasikiliza, kama vile Mwenyezi Mungu alivyokuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kisha Mwenyezi Mungu akamwambia Musa, “Amka asubuhi na mapema, usimame mbele ya Farao wakati anapoenda mtoni, umwambie, ‘Hili ndilo asemalo Mwenyezi Mungu: Waachie watu wangu waende, ili wapate kuniabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Usipowaruhusu watu wangu waondoke, nitatuma makundi ya inzi juu yako na maafisa wako, juu ya watu wako, na ndani ya nyumba zenu. Nyumba za Wamisri zitajaa inzi; hata ardhi itafunikwa na inzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Lakini siku ile nitafanya kitu tofauti katika nchi ya Gosheni, ambapo watu wangu wanaishi, hapatakuwa na makundi ya inzi, ili mpate kujua kwamba Mimi, Mwenyezi Mungu, niko katika nchi hii. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nitaweka tofauti kati ya watu wangu na watu wenu. Ishara hii ya ajabu itatokea kesho.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Naye Mwenyezi Mungu akafanya hivyo. Makundi makubwa ya inzi walimiminika katika jumba la kifalme la Farao na katika nyumba za maafisa wake, pia nchi yote ya Misri ikaharibiwa na inzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ndipo Farao akamwita Musa na Haruni na kuwaambia, “Nendeni mkamtolee Mungu wenu dhabihu katika nchi hii.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lakini Musa akamwambia, “Hilo halitakuwa sawa. Dhabihu tutakazomtolea Mwenyezi Mungu, Mungu wetu, zitakuwa chukizo kwa Wamisri. Tukitoa dhabihu ambazo ni chukizo mbele yao, je, hawatatupiga mawe? ");
INSERT INTO swhonmm_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ni lazima twende mwendo wa siku tatu hadi tufike jangwani ili tumtolee Mwenyezi Mungu, Mungu wetu, dhabihu, kama alivyotuagiza.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao akamwambia, “Nitawaruhusu mwende kumtolea Mwenyezi Mungu, Mungu wenu, dhabihu huko jangwani, lakini hamna ruhusa kwenda mbali sana. Sasa mniombee.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa akajibu, “Mara tu nitakapoondoka, nitamwomba Mwenyezi Mungu na kesho inzi wataondoka kwa Farao, kwa maafisa wake, na kwa watu wake. Ila hakikisha kwamba Farao hatatenda kwa udanganyifu tena kwa kutokuwaachia watu waende kumtolea Mwenyezi Mungu dhabihu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ndipo Musa akamwacha Farao na kumwomba Mwenyezi Mungu, ");
INSERT INTO swhonmm_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","naye Mwenyezi Mungu akafanya lile Musa alilomwomba. Inzi wakaondoka kwa Farao, kwa maafisa wake na kwa watu wake, wala hakuna hata inzi aliyebakia. ");
INSERT INTO swhonmm_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lakini wakati huu pia Farao akaufanya moyo wake kuwa mgumu, wala hakuwaruhusu Waisraeli waondoke. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ndipo Mwenyezi Mungu akamwambia Musa, “Nenda kwa Farao ukamwambie, ‘Hili ndilo Mwenyezi Mungu, Mungu wa Waebrania, asemalo: “Waachie watu wangu waende ili wapate kuniabudu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Usipowaachia waende, nawe ukiendelea kuwashikilia, ");
INSERT INTO swhonmm_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mkono wa Mwenyezi Mungu utaleta pigo baya kwa mifugo yako, juu ya farasi wako, punda, ngamia, ng’ombe wako, kondoo na mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lakini Mwenyezi Mungu ataweka tofauti kati ya mifugo ya Israeli na ile ya Misri, kwamba hakuna mnyama wa Mwisraeli atakayekufa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mwenyezi Mungu akaweka wakati na kusema, “Kesho Mwenyezi Mungu atalitenda hili katika nchi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Siku iliyofuata Mwenyezi Mungu akalitenda: Mifugo yote ya Wamisri ikafa, lakini hakuna hata mnyama mmoja wa Waisraeli aliyekufa. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao akatuma watu kuchunguza, nao wakakuta kuwa hakuna hata mnyama mmoja wa Waisraeli aliyekufa. Lakini moyo wa Farao haukukubali kuwaachia watu waende. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kisha Mwenyezi Mungu akamwambia Musa na Haruni, “Chukueni majivu ya tanuru, naye Musa ayarushe angani mbele ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yatakuwa vumbi jepesi juu ya nchi yote ya Misri, pia yatatokea majipu yenye kufura kwenye miili ya watu na ya wanyama katika nchi yote.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Basi wakachukua majivu kwenye tanuru na kusimama mbele ya Farao. Musa akayarusha hewani, nayo majipu yenye kufura yakatokea kwenye miili ya watu na ya wanyama. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Waganga hawakuweza kusimama mbele ya Musa kwa sababu ya majipu yaliyokuwa kwenye miili yao, na kwenye miili ya Wamisri wote. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Lakini Mwenyezi Mungu akaufanya moyo wa Farao kuwa mgumu, naye hakuwasikiliza Musa na Haruni, kama vile Mwenyezi Mungu alivyokuwa amemwambia Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kisha Mwenyezi Mungu akamwambia Musa, “Amka asubuhi na mapema, usimame mbele ya Farao, umwambie, ‘Hili ndilo asemalo Mwenyezi Mungu, Mungu wa Waebrania: Waachie watu wangu waende, ili waweze kuniabudu, ");
INSERT INTO swhonmm_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","au wakati huu nitaleta mapigo yangu yenye nguvu dhidi yako, maafisa wako na watu wako, ili upate kujua kuwa hakuna mwingine kama mimi duniani kote. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kwa kuwa hadi sasa ningekuwa nimenyoosha mkono wangu na kukupiga wewe na watu wako kwa pigo ambalo lingekufutilia mbali juu ya nchi. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Lakini nimekuinua wewe kwa kusudi hili hasa, ili nikuoneshe uwezo wangu, na jina langu litangazwe duniani kote. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Bado unaendelea kujiinua dhidi ya watu wangu, wala hutaki kuwaachia waende. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Hivyo basi, kesho wakati kama huu nitaleta mvua mbaya sana ya mawe ambayo haijapata kunyesha katika nchi ya Misri, tangu siku ilipoumbwa hadi leo. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sasa toa amri mifugo yako na kila kitu ulicho nacho shambani, kipelekwe mahali pa usalama. Kwa sababu mvua ya mawe itamwangukia kila mtu na mnyama ambaye hajaletwa ndani, na ambaye bado yuko nje shambani; nao watakufa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wale maafisa wa Farao ambao waliliogopa neno la Mwenyezi Mungu wakafanya haraka kuwaleta watumwa wao na mifugo yao ndani. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lakini wale waliopuuza neno la Mwenyezi Mungu wakawaacha watumwa wao na mifugo yao shambani. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ndipo Mwenyezi Mungu akamwambia Musa, “Nyoosha mkono wako kuelekea angani ili mvua ya mawe inyeshe Misri yote: juu ya watu, wanyama, na juu ya kila kitu kinachoota katika mashamba ya Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa alipoinyoosha fimbo yake kuelekea angani, Mwenyezi Mungu akatuma ngurumo na mvua ya mawe; mwanga wa radi ukamulika hadi nchi. Kwa hiyo Mwenyezi Mungu akanyesha mvua ya mawe juu ya nchi ya Misri; ");
INSERT INTO swhonmm_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","mvua ya mawe ikanyesha, na radi ikamulika pote. Ikawa dhoruba ya kutisha zaidi, ambayo haijawahi kutokea katika Misri tangu nchi hiyo iwe taifa. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mvua ya mawe ikaharibu kila kitu katika nchi ya Misri kilichokuwa katika mashamba: watu na wanyama; ikaharibu kila kitu kilichoota mashambani na kung’oa kila mti. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mahali pekee ambapo mvua ya mawe haikunyesha ni nchi ya Gosheni, ambako Waisraeli waliishi. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ndipo Farao akawaita Musa na Haruni akawaambia, “Wakati huu nimetenda dhambi. Mwenyezi Mungu ni mwenye haki, mimi na watu wangu ni wakosaji. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mwombeni Mwenyezi Mungu, kwa kuwa tumepata ngurumo na mvua za mawe za kutosha. Nitawaachia mwondoke; hamtahitaji kungoja zaidi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa akamjibu, “Nitakapokuwa nimetoka nje ya mji, nitanyoosha mikono yangu juu kumwomba Mwenyezi Mungu. Ngurumo zitakoma na hapatakuwa mvua ya mawe tena, ili upate kujua kuwa nchi ni mali ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lakini ninajua kuwa wewe na maafisa wako bado hammwogopi Bwana Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Kitani na shayiri viliharibiwa, kwa kuwa shayiri ilikuwa na masuke, na kitani ilikuwa imechanua maua. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Hata hivyo, ngano na kusemethi hazikuharibiwa kwa sababu zilikuwa hazijakomaa.) ");
INSERT INTO swhonmm_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kisha Musa akaondoka kwa Farao, akaenda nje ya mji. Musa akanyoosha mikono yake kuelekea kwa Mwenyezi Mungu, ngurumo na mvua ya mawe vikakoma, mvua haikuendelea tena kunyesha nchini. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao alipoona kwamba mvua ya mawe na ngurumo zimekoma, akafanya dhambi tena. Yeye na maafisa wake wakafanya mioyo yao kuwa migumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kwa hiyo, moyo wa Farao ukawa mgumu, wala hakuwaachia Waisraeli waende, kama vile Mwenyezi Mungu alivyokuwa amesema kupitia Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ndipo Mwenyezi Mungu akamwambia Musa, “Nenda kwa Farao, kwa kuwa nimeufanya moyo wake kuwa mgumu na mioyo ya maafisa wake ili nipate kutenda ishara hizi zangu za ajabu miongoni mwao, ");
INSERT INTO swhonmm_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ili upate kuwaeleza watoto wako na wajukuu wako jinsi nilivyowatendea Wamisri kwa ukali, na jinsi nilivyofanya ishara zangu miongoni mwao, nanyi mpate kujua kuwa Mimi ndimi Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kwa hiyo Musa na Haruni wakaenda kwa Farao na kumwambia, “Hili ndilo Mwenyezi Mungu, Mungu wa Waebrania, asemalo: ‘Utaendelea hata lini kukataa kunyenyekea mbele yangu? Waachie watu wangu waende, ili waniabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ukikataa kuwaachia waende, kesho nitaleta nzige katika nchi yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nao watafunika uso wa ardhi hata usionekane. Watatafuna mabaki machache yaliyobakizwa baada ya ile mvua ya mawe, yaani pamoja na kila mti unaoota katika mashamba yenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Nzige hao watajaza nyumba zako, za maafisa wako wote na za Wamisri wote. Jambo ambalo baba zenu wala babu zenu hawajapata kuona tangu siku ile walipoanza kuishi katika nchi hii hadi leo.’ ” Ndipo Musa akageuka na kumwacha Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Maafisa wa Farao wakamwambia, “Hadi lini huyu mtu atakuwa tanzi kwetu? Waachie hao watu waende zao, ili wapate kumwabudu Mwenyezi Mungu, Mungu wao. Je, bado hutambui kuwa Misri imeangamia?” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ndipo Musa na Haruni wakaletwa kwa Farao. Farao akawaambia, “Nendeni, mkamwabudu Mwenyezi Mungu, Mungu wenu. Lakini ni nani hasa watakaoenda?” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa akajibu, “Tutaenda na vijana wetu na wazee, pamoja na wana wetu na binti zetu, pia pamoja na mbuzi, kondoo, na ng’ombe wetu kwa sababu tutaadhimisha sikukuu kwa Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao akasema, “Kama kweli nitawaruhusu mwondoke pamoja na wanawake wenu na watoto wenu, Mwenyezi Mungu awe pamoja nanyi! Ni wazi kwamba mna makusudi mabaya. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","La hasha! Wanaume peke yao na waende, wakamwabudu Mwenyezi Mungu, kwa kuwa hilo ndilo mmekuwa mkiomba.” Kwa hiyo Musa na Haruni wakaondolewa mbele ya Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Basi Mwenyezi Mungu akamwambia Musa, “Nyoosha mkono wako juu ya Misri, ili kundi la nzige liweze kuvamia nchi na kutafuna kila kitu kinachoota katika mashamba na kila kitu kilichosazwa na ile mvua ya mawe.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kwa hiyo Musa akanyoosha fimbo yake juu ya Misri, Mwenyezi Mungu akauleta upepo wa mashariki ukavuma katika nchi yote mchana wote na usiku kucha, kufikia asubuhi upepo ukawa umeleta nzige. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Wakaivamia Misri yote na kukaa katika kila eneo la nchi kwa wingi. Kamwe halijapata kutokea pigo la nzige kama hilo, wala halitakuwa tena. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Wakafunika ardhi yote hata ardhi ikawa nyeusi. Wakatafuna kila kilichokuwa kimebakizwa na ile mvua ya mawe: kila kitu kilichoota shambani, pamoja na matunda kwenye miti. Hakuna kitu chochote cha kijani kilichosalia katika miti au mmea katika nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Farao akawaita Musa na Haruni kwa haraka na kuwaambia, “Nimetenda dhambi dhidi ya Mwenyezi Mungu, Mungu wenu, na dhidi yenu pia. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sasa unisamehe dhambi yangu mara moja tena na umwombe Mwenyezi Mungu, Mungu wako, aondoe pigo hili baya kwangu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kisha Musa akaondoka kwa Farao akamwomba Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Naye Mwenyezi Mungu akaugeuza upepo kuwa upepo mkali sana kutoka magharibi, ambao uliwaondoa wale nzige na kuwapeleka kwenye Bahari ya Shamu. Hakuna nzige hata mmoja aliyebaki popote katika nchi ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lakini Mwenyezi Mungu akaufanya moyo wa Farao kuwa mgumu, wala hakuwaachia Waisraeli waondoke. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kisha Mwenyezi Mungu akamwambia Musa, “Nyoosha mkono wako kuelekea angani ili giza litande katika nchi ya Misri, giza ambalo watu wanaweza kulipapasa na kulihisi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kwa hiyo Musa akaunyoosha mkono wake kuelekea angani, na giza nene likafunika pote katika nchi ya Misri kwa muda wa siku tatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hakuna mtu yeyote aliyeweza kumwona mwenzake, wala kuondoka mahali alipokuwa kwa muda wa siku tatu. Lakini Waisraeli wote walikuwa na mwanga katika maeneo waliyokuwa wanaishi. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ndipo Farao akamwita Musa na kusema, “Nendeni, mkamwabudu Mwenyezi Mungu. Hata wanawake na watoto wenu mwaweza kwenda nao pia, lakini kondoo, mbuzi na ng’ombe wenu waacheni.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Lakini Musa akasema, “Huna budi kuturuhusu tuwe na dhabihu, na sadaka za kuteketezwa za kutoa mbele za Mwenyezi Mungu, Mungu wetu. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Sisi ni lazima tuondoke na mifugo yetu pia, wala hakuna ukwato utakaoachwa nyuma. Inatupasa kutumia baadhi ya hiyo mifugo katika kumwabudu Mwenyezi Mungu, Mungu wetu, kwa kuwa hadi tutakapofika huko, hatutakuwa tumefahamu ni nini tutakachotumia katika kumwabudu Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lakini Mwenyezi Mungu akaufanya moyo wa Farao kuwa mgumu, hakuwa radhi kuwaachia waondoke. ");
INSERT INTO swhonmm_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao akamwambia Musa, “Ondoka mbele yangu! Hakikisha kuwa hutakuja mbele yangu tena! Siku ile utakapouona uso wangu utakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa akamjibu, “Iwe kama ulivyosema! Kamwe sitauona uso wako tena.” ");
INSERT INTO swhonmm_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Basi Mwenyezi Mungu alikuwa amemwambia Musa, “Nitaleta pigo moja zaidi kwa Farao na katika nchi ya Misri. Baada ya hilo, atawaacha mwondoke hapa na atakapofanya hivyo, atawafukuza mtoke kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Waambie watu wote kwamba kila mwanaume na kila mwanamke amwombe jirani yake vitu vya fedha na vya dhahabu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Mwenyezi Mungu akawafanya Wamisri wawe na moyo wa ukarimu kwa Waisraeli, naye Musa mwenyewe akaheshimiwa sana na maafisa wa Farao na watu wote katika nchi ya Misri.) ");
INSERT INTO swhonmm_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kwa hiyo Musa akasema, “Hili ndilo asemalo Mwenyezi Mungu: ‘Usiku wa manane, Mimi nitapita katika nchi yote ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kila mwanaume kifungua mimba katika Misri atakufa, kuanzia mzaliwa wa kwanza wa kiume wa Farao, anayeketi kwenye kiti cha ufalme, hadi mzaliwa wa kwanza wa kiume wa mjakazi, anayesaga nafaka kwa jiwe, pamoja na kila mzaliwa wa kwanza wa mifugo. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kutakuwa na kilio kikubwa katika nchi yote ya Misri, kilio ambacho hakijakuwa, wala kamwe hakitakuwa tena. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lakini miongoni mwa Waisraeli hakuna hata mbwa atakayembwekea mwanadamu wala mnyama yeyote.’ Ndipo mtajua kuwa Mwenyezi Mungu huweka tofauti kati ya Misri na Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Maafisa hawa wako wote watanijia, wakisujudu mbele yangu, wakisema, ‘Ondoka, wewe pamoja na watu wako wote wanaokufuata!’ Baada ya haya nitaondoka.” Kisha Musa, akiwa amewaka hasira, akamwacha Farao. ");
INSERT INTO swhonmm_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mwenyezi Mungu alikuwa amemwambia Musa, “Farao atakataa kukusikiliza, ili maajabu yangu yapate kuongezeka katika nchi ya Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Haruni wakafanya maajabu haya yote mbele ya Farao, lakini Mwenyezi Mungu akaufanya moyo wa Farao kuwa mgumu, wala hakuwaachia Waisraeli waondoke katika nchi yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mwenyezi Mungu akamwambia Musa na Haruni katika nchi ya Misri, ");
INSERT INTO swhonmm_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi huu utakuwa mwanzo wa miezi kwenu, yaani mwezi wa kwanza wa mwaka wenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Iambie jumuiya yote ya Israeli kwamba katika siku ya kumi ya mwezi huu, kila mtu atatwaa mwana-kondoo mmoja kwa ajili ya jamaa yake, mmoja kwa kila nyumba. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ikiwa nyumba yoyote ina watu wachache wasioweza kumaliza huyo mwana-kondoo mzima, nyumba hiyo itabidi ishirikiane na nyumba ya jirani wa karibu, baada ya kuzingatia idadi ya watu waliomo. Mtaangalia ni kiasi gani cha nyama kitahitajika kulingana na mahitaji ya kila mtu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Wanyama mtakaowachagua, lazima wawe wa kiume wa umri wa mwaka mmoja wasiokuwa na dosari, mwaweza kuwachukua kati ya kondoo au mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tunzeni wanyama hao hadi siku ya kumi na nne ya mwezi, ambapo lazima watu wa jumuiya yote ya Israeli wachinje wanyama hao wakati wa jioni. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ndipo watakapochukua sehemu ya hiyo damu na kuipaka kwenye vizingiti vya juu, na miimo ya milango ya nyumba ambamo watakula wana-kondoo hao. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Usiku huo huo watakula nyama iliyookwa kwenye moto, pamoja na mboga chungu za majani na mikate isiyotiwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Msile nyama mbichi wala iliyochemshwa, lakini iwe imeokwa kwenye moto, kichwa, miguu na nyama zake za ndani. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Msibakize nyama yoyote hadi asubuhi; nazo kama zitabakia hadi asubuhi, lazima mziteketeze kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Hivi ndivyo mtakavyokula: Mtajifunga mikanda viunoni, mtakuwa mmevaa viatu vyenu miguuni na kushika fimbo zenu mkononi mwenu. Mle kwa haraka; hii ni Pasaka ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Usiku huo huo nitapita katika nchi yote ya Misri na kumuua kila mzaliwa wa kwanza, wa wanadamu na wa wanyama, nami nitaihukumu miungu yote ya Misri. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Damu itakuwa ishara kwa ajili yenu ya kuonesha nyumba ambazo mtakuwamo; nami nitakapoiona damu, nitapita juu yenu. Hakuna pigo la uharibifu litakalowagusa ninyi nitakapoipiga Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Siku hii itakuwa kumbukumbu kwenu, mtaiadhimisha kuwa sikukuu kwa Mwenyezi Mungu, katika vizazi vyenu vyote: mtalishika kuwa agizo la kudumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kwa siku saba mtakula mikate isiyotiwa chachu. Katika siku ya kwanza mtaondoa chachu yote ndani ya nyumba zenu, kwa maana yeyote atakayekula chochote chenye chachu kuanzia siku ya kwanza hadi ya saba lazima akatiliwe mbali kutoka Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Katika siku ya kwanza mtakuwa na kusanyiko takatifu, na kusanyiko jingine katika siku ya saba. Katika siku hizo msifanye kazi kamwe isipokuwa kutayarisha chakula cha kila mmoja; hilo ndilo tu mtakalofanya. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mtaadhimisha Sikukuu ya Mikate Isiyotiwa Chachu, kwa sababu hiyo ndiyo siku ile niliyovitoa vikosi vyenu kutoka Misri. Mtaiadhimisha siku hii kwa vizazi vyenu vyote kuwa agizo la kudumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Katika mwezi wa kwanza mtakula mikate isiyotiwa chachu, kuanzia jioni ya siku ya kumi na nne hadi jioni ya siku ya ishirini na moja. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kwa muda wa siku saba isionekane chachu yoyote katika nyumba zenu. Yeyote alaye chochote chenye chachu ndani yake, lazima akatiliwe mbali kutoka jumuiya ya Israeli, akiwa ni mgeni au mzawa. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Msile chochote kilichotiwa chachu. Popote mnapoishi, ni lazima mle mikate isiyotiwa chachu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ndipo Musa akawaita wazee wote wa Israeli na kuwaambia, “Nendeni mara moja mkachague wanyama kwa ajili ya jamaa zenu, mkachinje mwana-kondoo wa Pasaka. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Chukueni kitawi cha hisopo, mkichovye kwenye damu iliyopo kwenye sinia, na kuipaka sehemu ya hiyo damu kwenye vizingiti, na kwenye miimo yote miwili ya milango. Mtu yeyote asitoke nje ya mlango wa nyumba yake hadi asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mwenyezi Mungu apitapo katika nchi yote kuwapiga Wamisri, ataiona damu juu ya vizingiti na kwenye miimo ya milango, naye atapita juu, wala hatamruhusu mwangamizi kuingia katika nyumba zenu na kuwapiga ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Shikeni maagizo haya yawe kanuni ya kudumu kwenu na kwa ajili ya wazao wenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mtakapoingia katika nchi Mwenyezi Mungu atakayowapa kama alivyoahidi, shikeni desturi hii. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Watoto wenu watakapowauliza, ‘Sikukuu hii ina maana gani kwenu?’ ");
INSERT INTO swhonmm_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Basi waambieni, ‘Hii ni dhabihu ya Pasaka kwa Mwenyezi Mungu, ambaye alipita juu ya nyumba za Waisraeli katika nchi ya Misri, na hakudhuru nyumba zetu alipowapiga Wamisri.’ ” Ndipo Waisraeli walisujudu na kuabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Waisraeli wakafanya kama vile Mwenyezi Mungu alivyomwagiza Musa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ilipofika usiku wa manane, Mwenyezi Mungu akawapiga wazaliwa wa kwanza wote katika Misri, kuanzia mzaliwa wa kwanza wa Farao, mrithi wa kiti cha ufalme, hadi mzaliwa wa kwanza wa mfungwa, aliyekuwa gerezani, na wazaliwa wa kwanza wa mifugo yote pia. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao, na maafisa wake wote, na Wamisri wote wakaamka usiku, na kulikuwa na kilio kikubwa katika nchi ya Misri, kwa kuwa hapakuwa nyumba hata moja ambayo hakufa mtu. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Wakati huo Farao akawaita Musa na Haruni na kuwaambia, “Ondokeni! Tokeni kwa watu wangu, ninyi pamoja na Waisraeli! Nendeni mkamwabudu Mwenyezi Mungu kama mlivyoomba. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Chukueni makundi yenu ya kondoo na mbuzi pamoja na ng’ombe, kama mlivyosema, nanyi mwende zenu. Nanyi pia mnibariki.” ");
INSERT INTO swhonmm_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisri wakawahimiza Waisraeli waondoke kwa haraka na kuacha nchi yao. Kwa kuwa walisema, “La sivyo, tutakufa wote!” ");
INSERT INTO swhonmm_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hivyo watu wakachukua donge lao la unga kabla ya kutiwa chachu, wakaweka ndani ya mabakuli ya kukandia, wakayaviringisha katika mavazi na kuyabeba mabegani mwao. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Waisraeli wakafanya kama Musa alivyowaelekeza, nao wakawaomba Wamisri wawapatie vitu vya fedha, dhahabu na mavazi. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Basi Mwenyezi Mungu alikuwa amewafanya Wamisri kuwa wakarimu kwa hawa watu, wakawapatia Waisraeli vile walivyotaka kwao; kwa hiyo wakawateka nyara Wamisri. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waisraeli wakasafiri kutoka Ramesesi hadi Sukothi. Walikuwa wanaume wapatao elfu mia sita waliotembea kwa miguu, bila kuhesabu wanawake na watoto. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Watu wengine wengi wakafuatana nao, pamoja na makundi makubwa ya mifugo, wakiwemo kondoo, mbuzi na ng’ombe. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Wakatengeneza maandazi yasiyotiwa chachu kwa ule unga uliokandwa waliokuwa wameutoa Misri, donge hilo la unga halikuwa limetiwa chachu, kwa kuwa walikuwa wameondolewa Misri kwa haraka nao hawakuwa na muda wa kujiandalia chakula. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waisraeli waliishi Misri kwa muda wa miaka mia nne na thelathini (430). ");
INSERT INTO swhonmm_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Siku ya mwisho ya hiyo miaka mia nne na thelathini (430), vikosi vyote vya Mwenyezi Mungu viliondoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kwa sababu Mwenyezi Mungu aliutenga usiku ule ili kuwatoa Waisraeli katika nchi ya Misri, basi Waisraeli wote wanapaswa kuadhimisha usiku huu kwa kukesha ili kumheshimu Mwenyezi Mungu katika vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mwenyezi Mungu akawaambia Musa na Haruni, “Haya ndio masharti kwa ajili ya Pasaka: “Mgeni hataruhusiwa kula Pasaka. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mtumwa yeyote ambaye mmemnunua aweza kuila kama mmemtahiri, ");
INSERT INTO swhonmm_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","lakini kibarua yeyote au msafiri haruhusiwi kula. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Sharti iliwe ndani ya nyumba; msichukue nyama yoyote nje ya nyumba hiyo. Msiuvunje mfupa wowote. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Jumuiya yote ya Israeli ni lazima waiadhimishe Pasaka hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Mgeni aishiye miongoni mwenu ambaye anataka kuadhimisha Pasaka ya Mwenyezi Mungu ni lazima wanaume wote waliomo nyumbani mwake wawe wametahiriwa, ndipo aweze kushiriki kama mzawa. Mwanaume yeyote asiyetahiriwa haruhusiwi kuila. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sheria hiyo hiyo itamuhusu mzawa na mgeni anayeishi miongoni mwenu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waisraeli wote walifanya kama vile Mwenyezi Mungu alivyomwagiza Musa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Siku ile ile Mwenyezi Mungu akawatoa Waisraeli katika nchi ya Misri kwa vikosi vyao. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Niwekeeni wakfu kila mzaliwa wa kwanza wa kiume. Kila mtoto wa kwanza aliye kifungua mimba miongoni mwa Waisraeli ni mali yangu, akiwa wa mwanadamu au wa mnyama.” ");
INSERT INTO swhonmm_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ndipo Musa akawaambia watu, “Ikumbukeni siku hii, siku ambayo mlitoka katika nchi ya Misri, katika nchi ya utumwa, kwa sababu Mwenyezi Mungu aliwatoa humo kwa mkono wenye nguvu. Msile chochote kilichotiwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Leo, katika mwezi wa Abibu, mnatoka. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mwenyezi Mungu atakapokuleta katika nchi ya Wakanaani, Wahiti, Waamori, Wahivi na Wayebusi, nchi aliyowaapia baba zako kukupa, nchi inayotiririka maziwa na asali, utaiadhimisha sikukuu hii katika mwezi huu: ");
INSERT INTO swhonmm_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwa siku saba utakula mikate isiyotiwa chachu na katika siku ya saba utamfanyia Mwenyezi Mungu sikukuu. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kwa muda wa siku saba utakula mikate isiyotiwa chachu, pasionekane kitu chochote kilicho na chachu miongoni mwako, wala chachu yoyote isionekane popote ndani ya mipaka yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Siku ile utamwambia mwanao, ‘Nafanya hivi kwa sababu ya jambo ambalo Mwenyezi Mungu alinitendea nilipotoka katika nchi ya Misri.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Adhimisho hili, litakuwa kama alama kwenye mkono wako na ukumbusho katika paji lako la uso, kwamba sheria ya Mwenyezi Mungu inapaswa iwe kinywani mwako. Kwa kuwa Mwenyezi Mungu alikutoa katika nchi ya Misri kwa mkono wake wenye nguvu. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ni lazima ulishike agizo hili kwa wakati uliopangwa mwaka baada ya mwaka. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Baada ya Mwenyezi Mungu kukuingiza katika nchi ya Wakanaani na kukupa nchi hiyo, kama alivyokuahidi kwa kiapo na kwa baba zako, ");
INSERT INTO swhonmm_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","inakupasa kumtolea Mwenyezi Mungu kila mzaliwa wa kwanza. Wazaliwa wote wa kwanza wa kiume wa mifugo yako ni mali ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kila mzaliwa wa kwanza wa punda utamkomboa kwa mwana-kondoo, lakini kama hutamkomboa, utamvunja shingo yake. Kila mzaliwa wa kwanza mwanaume miongoni mwa wana wenu utamkomboa. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Katika siku zijazo, mwanao akikuuliza, ‘Hii ina maana gani?’ Mwambie, ‘Kwa mkono wenye nguvu Mwenyezi Mungu alitutoa katika nchi ya Misri, kutoka nchi ya utumwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao alipokataa kwa ukaidi kuturuhusu kuondoka, Mwenyezi Mungu aliua kila mzaliwa wa kwanza wa Wamisri, mwanadamu na wa mnyama. Hii ndiyo sababu ninatoa dhabihu kwa Mwenyezi Mungu mzaliwa wa kwanza wa kiume wa kila tumbo, na kumkomboa kila mzaliwa wa kwanza wa wana wangu.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Jambo hili litakuwa kama ishara kwenye mkono wako na kama alama kwenye paji la uso wako, kwamba Mwenyezi Mungu alikutoa katika nchi ya Misri kwa mkono wake wenye nguvu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao alipowaachia watu waende, Mungu hakuwaongoza kufuata njia ipitayo katika nchi ya Wafilisti, ingawa njia hiyo ilikuwa fupi zaidi. Kwa maana Mungu alisema, “Wakikabiliana na vita, wanaweza kubadili mawazo yao na kurudi Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kwa hiyo Mungu akawaongoza watu kupitia njia ya kuzunguka kupitia jangwani, kuelekea Bahari ya Shamu. Waisraeli walipanda kutoka nchi ya Misri wakiwa wamejiandaa kwa vita. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa akachukua mifupa ya Yusufu kwa sababu Yusufu alikuwa amewaapisha wana wa Israeli. Alikuwa amewaambia, “Hakika Mungu atakuja kuwasaidia, nanyi ni lazima mwichukue mifupa yangu mwende nayo kutoka mahali hapa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Baada ya Waisraeli kuondoka Sukothi wakapiga kambi huko Ethamu pembeni mwa jangwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Wakati wa mchana Mwenyezi Mungu aliwatangulia kwa nguzo ya wingu kuwaongoza katika njia yao, na wakati wa usiku aliwatangulia kwa nguzo ya moto kuwaangazia, ili waweze kusafiri mchana au usiku. ");
INSERT INTO swhonmm_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ile nguzo ya wingu wakati wa mchana au ile nguzo ya moto wakati wa usiku haikuondoka mahali pake mbele ya watu. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ndipo Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Waambie Waisraeli wageuke nyuma na wapige kambi karibu na Pi-Hahirothi, kati ya Migdoli na bahari. Watapiga kambi kando ya bahari, mkabala na Baal-Sefoni. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao atafikiri kwamba, ‘Hao Waisraeli wanatangatanga katika nchi kwa kuchanganyikiwa, nalo jangwa limewafungia.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nami nitaufanya moyo wa Farao mgumu, naye atawafuatilia. Lakini nitajipatia utukufu kwa ajili yangu mwenyewe kupitia Farao na jeshi lake lote, nao Wamisri watajua kuwa mimi ndimi Mwenyezi Mungu.” Kwa hiyo Waisraeli wakafanya hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mfalme wa Misri alipoambiwa kuwa Waisraeli wamekimbia, Farao na maafisa wake wakabadili nia zao kuhusu Waisraeli, wakasema, “Tumefanya nini? Tumewaachia Waisraeli waende zao na tumeukosa utumishi wao!” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kwa hiyo akaandaliwa gari lake la vita, naye akaenda pamoja na jeshi lake. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Akachukua magari ya vita mia sita bora, pamoja na magari ya vita mengine yote ya Misri, pamoja na maafisa wa magari hayo yote. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mwenyezi Mungu akaufanya moyo wa Farao mfalme wa Misri kuwa mgumu, kwa hiyo akawafuatia Waisraeli, waliokuwa wakiondoka Misri kwa ujasiri. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nao Wamisri, yaani farasi wote wa Farao na magari ya vita, wapanda farasi na vikosi vya askari, wakawafuatia Waisraeli, wakawakuta karibu na Pi-Hahirothi, mkabala na Baal-Sefoni walipokuwa wamepiga kambi kando ya bahari. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Farao alipokaribia, Waisraeli wakainua macho yao, wakawaona Wamisri wakija nyuma yao. Wakashikwa na hofu, wakamlilia Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wakamwambia Musa, “Je, ni kwamba hakukuwa na makaburi huko Misri hata umetuleta tufe huku jangwani? Umetufanyia nini kututoa Misri? ");
INSERT INTO swhonmm_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Hatukukuambia tulipokuwa huko Misri, ‘Tuache tuwatumikie Wamisri’? Ingekuwa vyema zaidi kwetu kuwatumikia Wamisri kuliko kufa jangwani!” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa akawajibu Waisraeli, “Msiogope. Simameni imara, nanyi mtauona wokovu Mwenyezi Mungu atakaowapatia leo. Hao Wamisri mnaowaona leo kamwe hamtawaona tena. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mwenyezi Mungu atawapigania ninyi, nanyi mnatakiwa kutulia tu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ndipo Mwenyezi Mungu akamwambia Musa, “Kwa nini wewe unanililia? Waambie Waisraeli waendelee mbele. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Inua fimbo yako na unyooshe mkono wako juu ya bahari ili kuyagawa maji, ili Waisraeli wapate kupita mahali pakavu baharini. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nitaifanya mioyo ya Wamisri kuwa migumu kusudi waingie baharini wakiwafuatia. Nami nitajipatia utukufu kupitia Farao pamoja na jeshi lake lote, kupitia magari yake ya vita na wapanda farasi wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nao Wamisri watajua kwamba Mimi ndimi Mwenyezi Mungu nitakapojipatia utukufu kupitia Farao, magari yake ya vita na wapanda farasi wake.” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ndipo malaika wa Mungu, aliyekuwa akisafiri mbele ya jeshi la Israeli, akaondoka akakaa nyuma yao. Pia ile nguzo ya wingu ikaondoka hapo mbele yao na kusimama nyuma, ");
INSERT INTO swhonmm_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ikakaa kati ya majeshi ya Misri na Israeli. Usiku kucha wingu likaleta giza upande mmoja na nuru kwa upande mwingine, kwa hiyo hakuna aliyemkaribia mwenzake usiku kucha. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ndipo Musa akanyoosha mkono wake juu ya bahari, naye Mwenyezi Mungu akayasukuma maji ya bahari nyuma kwa upepo mkali wa mashariki usiku ule wote na kupafanya nchi kavu. Maji yakagawanyika, ");
INSERT INTO swhonmm_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","nao Waisraeli wakapita baharini mahali pakavu, maji yakiwa ukuta upande wao wa kuume na upande wao wa kushoto. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wamisri wakawafuatia ndani ya bahari, pamoja na farasi wote wa Farao, magari ya vita na wapanda farasi. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kukaribia mapambazuko, Mwenyezi Mungu akaliangalia jeshi la Wamisri kutoka ile nguzo ya moto na ya wingu, akalifadhaisha. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Mungu akayaondoa magurudumu ya magari yao ya vita, kwa hivyo wakayaendesha kwa shida. Nao Wamisri wakasema, “Tuachane na Waisraeli! Mwenyezi Mungu anawapigania dhidi ya Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ndipo Mwenyezi Mungu akamwambia Musa, “Nyoosha mkono wako juu ya bahari ili maji yarudi yawafunike Wamisri, magari yao ya vita, na wapanda farasi wao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa akanyoosha mkono wake juu ya bahari, kulipopambazuka bahari ikarudi mahali pake. Wamisri wakajaribu kuyakimbia maji, lakini Mwenyezi Mungu akawasukumia ndani ya bahari. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maji yakarudiana na kuyafunika magari ya vita na wapanda farasi pamoja na jeshi lote la Farao lililokuwa limewafuata Waisraeli ndani ya bahari. Hakuna hata mmoja wao aliyenusurika. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lakini Waisraeli wakapita baharini mahali pakavu, ukiwepo ukuta wa maji upande wao wa kuume na upande wao wa kushoto. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Siku ile Mwenyezi Mungu akawaokoa Waisraeli kutoka mikononi mwa Wamisri, nao Waisraeli wakawaona Wamisri wamelala ufuoni mwa bahari wakiwa wamekufa. ");
INSERT INTO swhonmm_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Basi Waisraeli walipoona uwezo mkubwa Mwenyezi Mungu aliodhihirisha dhidi ya Wamisri, watu wakamwogopa Mwenyezi Mungu na wakaweka tumaini lao kwake na kwa Musa mtumishi wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ndipo Musa na Waisraeli wakamwimbia Mwenyezi Mungu wimbo huu: “Nitamwimbia Mwenyezi Mungu, kwa kuwa ametukuzwa sana. Farasi na mpanda farasi amewatosa baharini. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Mwenyezi Mungu ni nguvu zangu na wimbo wangu; amekuwa wokovu wangu. Yeye ni Mungu wangu, nami nitamsifu, Mungu wa baba yangu, nami nitamtukuza. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mwenyezi Mungu ni shujaa wa vita; Mwenyezi Mungu ndilo jina lake. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Magari ya vita ya Farao na jeshi lake amewatosa baharini. Maafisa wa Farao walio bora sana wamezamishwa katika Bahari ya Shamu. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Maji yenye kina yamewafunika, wamezama vilindini kama jiwe. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mkono wako wa kuume, Ee Mwenyezi Mungu ulitukuka kwa uweza. Mkono wako wa kuume, Ee Mwenyezi Mungu, ukamponda adui. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Katika ukuu wa utukufu wako, ukawaangusha chini wale waliokupinga. Uliachia hasira yako kali, ikawateketeza kama kapi. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kwa pumzi ya pua yako maji yalijilundika. Mawimbi ya maji yakasimama imara kama ukuta, vilindi vikagandamana ndani ya moyo wa bahari. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Adui alijivuna, ‘Nitawafuatia, nitawapata. Nitagawanya nyara; nitajishibisha kwao. Nitafuta upanga wangu na mkono wangu utawaangamiza.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lakini ulipuliza kwa pumzi yako, bahari ikawafunika. Wakazama kama risasi kwenye maji makuu. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ni nani miongoni mwa miungu aliye kama wewe, Ee Mwenyezi Mungu? Ni nani kama Wewe: uliyetukuka katika utakatifu, utishaye katika utukufu, ukitenda maajabu? ");
INSERT INTO swhonmm_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Uliunyoosha mkono wako wa kuume na nchi ikawameza. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Katika upendo wako usiokoma utawaongoza watu uliowakomboa. Katika nguvu zako utawaongoza hadi makao yako matakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mataifa watasikia na kutetemeka, uchungu utawakamata Wafilisti. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Wakuu wa Edomu wataogopa, viongozi wa Moabu watatetemeka kwa hofu, Wakanaani watayeyuka, ");
INSERT INTO swhonmm_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","vitisho na hofu vitawaangukia. Kwa nguvu ya mkono wako watatulia kama jiwe, hadi watu wako wapite, Ee Mwenyezi Mungu, hadi watu uliowanunua wapite. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Utawaingiza na kuwapandikiza juu ya mlima wa urithi wako: hapo mahali, Ee Mwenyezi Mungu, ulipopafanya kuwa makao yako, mahali patakatifu, Ee Mwenyezi Mungu, ulipopajenga kwa mikono yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Mwenyezi Mungu atatawala milele na milele.” ");
INSERT INTO swhonmm_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farasi wa Farao, magari yake ya vita na wapanda farasi wake walipoingia baharini, Mwenyezi Mungu aliyarudisha maji ya bahari yakawafunika, lakini Waisraeli walipita baharini mahali pakavu. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kisha Miriamu yule nabii mke, ndugu yake Haruni, akachukua matari mkononi mwake na wanawake wote wakamfuata na matari yao wakicheza. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu akawaimbia: “Mwimbieni Mwenyezi Mungu, kwa maana ametukuka sana. Farasi na mpanda farasi amewatosa baharini.” ");
INSERT INTO swhonmm_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kisha Musa akawaongoza Israeli kutoka Bahari ya Shamu na kuingia katika Jangwa la Shuri. Kwa siku tatu walisafiri jangwani bila kupata maji. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Walipofika Mara, hawakuweza kunywa maji yake kwa sababu yalikuwa machungu. (Ndiyo sababu mahali hapo panaitwa Mara.) ");
INSERT INTO swhonmm_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kwa hiyo watu wakamnung’unikia Musa, wakisema, “Tunywe nini?” ");
INSERT INTO swhonmm_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ndipo Musa akamlilia Mwenyezi Mungu, naye Mwenyezi Mungu akamwonesha kipande cha mti. Akakitupa ndani ya maji, nayo maji yakawa matamu. Huko Mwenyezi Mungu akawapa amri na sheria na huko akawajaribu. ");
INSERT INTO swhonmm_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Mungu akasema, “Mkisikiliza kwa makini sauti ya Mwenyezi Mungu, Mungu wenu, na kuyafanya yaliyo mema machoni pake, na mkiyatii maagizo yake na kuzishika amri zake zote, sitaleta juu yenu ugonjwa wowote niliowaletea Wamisri, kwa kuwa Mimi ndimi Mwenyezi Mungu, niwaponyaye.” ");
INSERT INTO swhonmm_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kisha wakafika Elimu, mahali palipokuwa na chemchemi kumi na mbili, na miti sabini ya mitende, wakapiga kambi huko karibu na maji. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Jumuiya yote ya Waisraeli wakaondoka Elimu, wakafika Jangwa la Sini, lililokuwa kati ya Elimu na Sinai, siku ya kumi na tano ya mwezi wa pili baada ya kutoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Huko jangwani, jumuiya yote wakawanung’unikia Musa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Waisraeli wakawaambia, “Laiti tungekufa kwa mkono wa Mwenyezi Mungu huko Misri! Huko tuliketi tukizunguka masufuria ya nyama na tukala vyakula tulivyovitaka, lakini ninyi mmetuleta huku jangwani ili mpate kuua mkutano huu wote kwa njaa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kisha Mwenyezi Mungu akamwambia Musa, “Tazama! Nitawanyeshea mikate kutoka mbinguni. Watu watatoka kila siku na kukusanya kitakachowatosha kwa siku ile, kwa njia hii, nitawajaribu nione kama watafuata maelekezo yangu. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Siku ya sita watatayarisha kile waletacho ndani, nacho kitakuwa mara mbili kuliko ya kile walichokusanya kila siku.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kwa hiyo Musa na Haruni wakawaambia Waisraeli wote, “Jioni mtajua kuwa Mwenyezi Mungu ndiye aliwatoa Misri, ");
INSERT INTO swhonmm_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","kisha asubuhi mtauona utukufu wa Mwenyezi Mungu, kwa sababu amesikia manung’uniko yenu dhidi yake. Sisi ni nani hata mtunung’unikie?” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kisha Musa akasema, “Mtajua kuwa alikuwa Mwenyezi Mungu wakati atakapowapa nyama mle ifikapo jioni na mikate yote mtakayohitaji asubuhi kwa sababu amesikia manung’uniko yenu dhidi yake. Sisi ni nani? Hamnung’uniki dhidi yetu, bali dhidi ya Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kisha Musa akamwambia Haruni, “Iambie jumuiya yote ya Waisraeli kwamba, ‘Mje mbele zake Mwenyezi Mungu, kwa maana amesikia manung’uniko yenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haruni alipokuwa akizungumza na jumuiya yote ya Waisraeli, wakatazama kuelekea jangwani, na huko wakaona utukufu wa Mwenyezi Mungu ukitokeza katika wingu. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nimesikia manung’uniko ya Waisraeli. Waambie, ‘Jioni mtakula nyama, na asubuhi mtashiba mikate. Ndipo mtajua kuwa Mimi ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Jioni ile kware wakaja wakaifunika kambi na asubuhi kulikuwa na utando wa umande kuzunguka kambi. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Umande ulipoondoka, vipande vidogo vidogo kama theluji vilionekana juu ya mchanga wa jangwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Waisraeli walipoona, wakaambiana, “Hiki ni nini?” Kwa kuwa hawakujua kilikuwa kitu gani. Musa akawaambia, “Huu ndio mkate ambao Mwenyezi Mungu amewapa mle. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hivi ndivyo Mwenyezi Mungu ameamuru: ‘Kila mmoja akusanye kiasi anachohitaji. Chukueni pishi moja kwa kila mtu mliye naye katika hema lenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Waisraeli wakafanya kama walivyoambiwa; baadhi yao wakakusanya zaidi, wengine pungufu. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nao walipopima katika pishi, yule aliyekusanya zaidi hakuwa na ziada, wala aliyekusanya kidogo hakupungukiwa. Kila mmoja alikusanya kiasi alichohitaji. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kisha Musa akawaambia, “Mtu yeyote asibakize chochote hadi asubuhi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Hata hivyo, wengine hawakuzingatia aliyosema Musa, wakahifadhi kiasi fulani hadi asubuhi, lakini kile alichohifadhi kikajaa mabuu na kuanza kunuka. Kwa hiyo Musa akawakasirikia. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kila asubuhi, kila mmoja alikusanya kiasi alichohitaji na jua lilipokuwa kali, iliyeyuka. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Siku ya sita, wakakusanya mara mbili, kiasi cha pishi mbili kwa kila mtu, nao viongozi wa jumuiya wakaja kumwarifu Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa akawaambia, “Hivi ndivyo alivyoagiza Mwenyezi Mungu: ‘Kesho itakuwa Sabato ya mapumziko, Sabato takatifu kwa Mwenyezi Mungu. Kwa hiyo okeni kile mnachotaka kuoka na mchemshe kile mnachotaka kuchemsha. Hifadhini chochote kinachobaki na mkiweke hadi asubuhi.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kwa hiyo wakavihifadhi hadi asubuhi, kama Musa alivyoagiza, na havikunuka wala kuwa na mabuu. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa akawaambia, “Kuleni leo, kwa sababu leo ni Sabato kwa Mwenyezi Mungu. Hamtapata chochote juu ya nchi leo. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kwa siku sita mtakusanya, lakini siku ya saba, yaani Sabato, hakutakuwa chochote.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hata hivyo, baadhi ya watu wakatoka kwenda kukusanya siku ya saba, lakini hawakupata chochote. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ndipo Mwenyezi Mungu akamwambia Musa, “Je, mtaacha kushika maagizo na maelekezo yangu hadi lini? ");
INSERT INTO swhonmm_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Fahamuni kuwa Mwenyezi Mungu amewapa ninyi Sabato, ndiyo sababu katika siku ya sita amewapa mikate ya siku mbili. Kila mmoja inampasa kukaa pale alipo katika siku ya saba. Hata mmoja haruhusiwi kutoka.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kwa hiyo watu wakapumzika siku ya saba. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waisraeli wakaita ile mikate mana. Ilikuwa myeupe kama mbegu za mtama, na ladha yake ilikuwa kama mkate mwembamba uliotengenezwa kwa asali. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa akasema, “Hivi ndivyo alivyoagiza Mwenyezi Mungu: ‘Chukueni pishi ya mana na kuhifadhi kwa ajili ya vizazi vijavyo ili vione mikate niliyowapa mle jangwani nilipowatoa katika nchi ya Misri.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kwa hiyo Musa akamwambia Haruni, “Chukua gudulia na uweke pishi moja ya mana ndani yake. Kisha uweke mbele za Mwenyezi Mungu ili kihifadhiwe kwa ajili ya vizazi vijavyo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kama Mwenyezi Mungu alivyomwagiza Musa, hatimaye Haruni aliiweka ile mana ndani ya Sanduku la Ushuhuda ili aweze kuihifadhi. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Waisraeli wakala mana kwa miaka arobaini, mpaka walipofika katika nchi iliyokaliwa na watu; walikula mana hadi walipofika mpakani mwa Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Pishi moja ni sehemu ya kumi ya kipimo cha efa.) ");
INSERT INTO swhonmm_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Jumuiya yote ya Israeli ikaondoka kutoka Jangwa la Sini, ikisafiri kutoka sehemu moja hadi nyingine kama Mwenyezi Mungu alivyoagiza. Wakapiga kambi huko Refidimu, lakini hapakuwa na maji ya watu kunywa. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kwa hiyo wakagombana na Musa wakisema, “Tupe maji ya kunywa.” Musa akajibu, “Mbona mnagombana nami? Kwa nini mnamjaribu Mwenyezi Mungu?” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lakini watu walikuwa na kiu huko, wakanung’unika dhidi ya Musa, wakisema, “Kwa nini ulitutoa kule Misri, ukatuleta hapa utuue kwa kiu sisi, watoto wetu na mifugo yetu?” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kisha Musa akamlilia Mwenyezi Mungu, akasema, “Niwafanyie nini watu hawa? Sasa wanakaribia kunipiga kwa mawe.” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mwenyezi Mungu akamjibu Musa, “Nenda mbele ya watu. Wachukue pamoja nawe baadhi ya wazee wa Israeli, na uchukue mkononi mwako ile fimbo uliyopiga nayo Mto Naili, nawe uende. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Huko nitasimama mbele yako karibu na mwamba wa Horebu. Uupige mwamba na maji yatatoka ndani yake kwa ajili ya watu kunywa.” Kwa hiyo Musa akafanya haya mbele ya wazee wa Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Naye akapaita mahali pale Masa na Meriba, kwa sababu Waisraeli waligombana na kumjaribu Mwenyezi Mungu wakisema, “Je, Mwenyezi Mungu yu pamoja nasi au la?” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Waamaleki wakaja na kuwashambulia Waisraeli huko Refidimu. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa akamwambia Yoshua, “Chagua baadhi ya watu wetu na uende kupigana na Waamaleki. Kesho nitasimama juu ya kilima nikiwa na fimbo ya Mungu mkononi mwangu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kwa hiyo Yoshua akapigana na Waamaleki kama Musa alivyomwagiza, nao Musa, Haruni na Huri wakapanda juu ya kilima. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ikawa wakati wote Musa alipokuwa amenyanyua mikono yake, Waisraeli walikuwa wakishinda, lakini kila aliposhusha mikono yake Waamaleki walishinda. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mikono ya Musa ilipochoka, wakachukua jiwe na kumpa alikalie. Haruni na Huri wakaishikilia juu mikono ya Musa, mmoja upande huu na mwingine upande huu. Wakaitegemeza mikono yake ikabaki thabiti hadi jua lilipozama. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kwa hiyo Yoshua akalishinda jeshi la Waamaleki kwa upanga. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kisha Mwenyezi Mungu akamwambia Musa, “Andika mambo haya katika kitabu ili yakumbukwe, na uhakikishe kwamba Yoshua amesikia, kwa sababu nitafuta kabisa kumbukumbu la Amaleki chini ya mbingu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa akajenga madhabahu na kuiita Yehova Nisi. ");
INSERT INTO swhonmm_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa akasema, “Kwa maana mikono iliinuliwa dhidi ya kiti cha enzi cha Mwenyezi Mungu, sasa Mwenyezi Mungu atakuwa na vita dhidi ya Waamaleki kizazi hadi kizazi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Basi Yethro, kuhani wa Midiani, baba mkwe wa Musa, akawa amesikia kila kitu Mungu alichomfanyia Musa na watu wake wa Israeli, pia jinsi Mwenyezi Mungu alivyowatoa Israeli Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Baada ya Musa kumrudisha mkewe Sipora, Yethro baba mkwe wake alimpokea ");
INSERT INTO swhonmm_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","pamoja na wanawe wawili. Jina la mmoja aliitwa Gershomu, kwa kuwa Musa alisema, “Nimekuwa mgeni katika nchi ya kigeni.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mwingine aliitwa Eliezeri, kwa kuwa alisema, “Mungu wa baba yangu alikuwa msaada wangu, akaniokoa kutoka upanga wa Farao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yethro, baba mkwe wa Musa, pamoja na wana wawili wa Musa na mkewe, wakamjia Musa huko jangwani, mahali alipokuwa amepiga kambi karibu na mlima wa Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yethro alikuwa ametuma ujumbe kwake Musa, kusema, “Mimi Yethro baba mkwe wako ninakuja kwako pamoja na mke wako na wanao wawili.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kwa hiyo Musa akatoka kumlaki baba mkwe wake, akainama na kumbusu. Wakasalimiana, kisha wakaingia kwenye hema. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa akamwambia baba mkwe wake kuhusu kila kitu Mwenyezi Mungu alichomfanyia Farao na Wamisri kwa ajili ya Israeli, na pia kuhusu shida zote walizokutana nazo njiani, na jinsi Mwenyezi Mungu alivyowaokoa. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yethro akafurahishwa sana kusikia kuhusu mambo yote mazuri Mwenyezi Mungu aliyowatendea Waisraeli kuwaokoa kutoka mkono wa Wamisri. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yethro akasema, “Ahimidiwe Mwenyezi Mungu, aliyekuokoa wewe kutoka mikononi mwa Wamisri na Farao, na aliyewaokoa watu kutoka mikononi mwa Wamisri. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sasa najua ya kuwa Mwenyezi Mungu ni mkuu kuliko miungu mingine yote, kwa kuwa amewatendea hivi wale waliowatenda Israeli kwa ujeuri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kisha Yethro, baba mkwe wa Musa, akaleta sadaka ya kuteketezwa na dhabihu nyingine kwa Mungu, naye Haruni pamoja na wazee wote wa Israeli wakaja kula chakula pamoja na baba mkwe wa Musa mbele za Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Siku iliyofuata, Musa akachukua nafasi yake kama hakimu wa watu, nao wakasimama kumzunguka kuanzia asubuhi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Baba mkwe wake alipoona yote Musa anayowafanyia watu, akasema, “Ni nini hiki unachowafanyia watu? Kwa nini wewe unakuwa mwamuzi wa watu hawa peke yako, wakati watu hawa wamesimama wakikuzunguka tangu asubuhi hadi jioni?” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa akamjibu, “Kwa sababu watu wananijia kutaka mapenzi ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kila wakiwa na shauri huletwa kwangu, nami huamua kati ya mtu na mwenzake, na kuwaeleza hukumu na sheria zake Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Baba mkwe wa Musa akamjibu, “Unachofanya sio kizuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Wewe pamoja na watu hawa wanaokujia mtajichosha bure. Kazi ni nzito sana kwako, huwezi kuibeba mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sasa nisikilize mimi, nitakupa ushauri, naye Mungu na awe pamoja nawe. Yapasa wewe uwe mwakilishi wa watu mbele za Mungu na ulete mashauri yao kwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Wafundishe hukumu na sheria zake, na uwaoneshe jinsi wanavyopaswa kuishi, na jinsi wanavyopaswa kuenenda. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Lakini uchague watu wenye uwezo miongoni mwa watu wote, watu wanaomwogopa Mungu, watu waaminifu wanaochukia mali ya dhuluma, uwateuwe wawe maafisa juu ya maelfu, mamia, hamsini na makumi. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Waweke wawe waamuzi wa watu kwa wakati wote, lakini waambie wakuletee kila shauri lililo gumu; yale yaliyo rahisi wayaamue wao wenyewe. Hii itafanya mzigo wako kuwa mwepesi, kwa sababu watashirikiana nawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ukifanya hivi, na ikiwa Mungu ameagiza hivyo, utaweza kushinda uchovu, nao watu hawa wote watarudi nyumbani wameridhika.” ");
INSERT INTO swhonmm_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa akamsikiliza baba mkwe wake na kufanya kila kitu alichosema. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa akawachagua watu wenye uwezo kutoka Israeli yote, akawafanya wawe viongozi wa watu, maafisa juu ya maelfu, mamia, hamsini na makumi. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wakatumika kama waamuzi wa watu kwa wakati wote. Mashauri magumu wakayaleta kwa Musa, lakini yale yaliyo rahisi wakayaamua wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kisha Musa akaagana na Yethro baba mkwe wake, naye akarudi kwa nchi yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Siku ya kwanza ya mwezi wa tatu baada ya Waisraeli kuondoka Misri, walifika Jangwa la Sinai siku hiyo hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Baada ya kuondoka Refidimu, waliingia katika Jangwa la Sinai na Israeli wakapiga kambi pale jangwani mbele ya mlima. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kisha Musa akakwea kwenda kwa Mungu, naye Mwenyezi Mungu akamwita kutoka ule mlima, akasema, “Hivi ndivyo utakavyosema na nyumba ya Yakobo na utakachowaambia Waisraeli: ");
INSERT INTO swhonmm_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ninyi wenyewe mmeona nililofanya huko Misri, jinsi nilivyowabeba kwenye mabawa ya tai na kuwaleta kwangu. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sasa, mkinitii kikamilifu na kutunza agano langu, basi ninyi mtakuwa hazina yangu ya pekee miongoni mwa mataifa yote. Ijapokuwa dunia yote ni mali yangu, ");
INSERT INTO swhonmm_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ninyi mtakuwa kwangu ufalme wa makuhani na taifa takatifu.’ Haya ndio maneno utakayosema kwa Waisraeli.” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kwa hiyo Musa akarudi, akawaita wazee wa watu na kuwaambia maneno yote ambayo Mwenyezi Mungu alikuwa amemwamuru ayaseme. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Watu wote wakajibu kwa pamoja, “Tutafanya kila kitu Mwenyezi Mungu alichokisema.” Naye Musa akarudisha majibu yao kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mwenyezi Mungu akamwambia Musa, “Nitakujia katika wingu zito, ili watu wanisikie nikinena nawe na kila mara waweke tumaini lao kwako.” Kisha Musa akamwambia Mwenyezi Mungu yale ambayo watu walikuwa wamesema. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Naye Mwenyezi Mungu akamwambia Musa, “Nenda kwa watu ukawaweke wakfu leo na kesho. Waambie wafue nguo zao ");
INSERT INTO swhonmm_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","na wawe tayari siku ya tatu, kwa sababu siku hiyo, Mwenyezi Mungu atashuka juu ya Mlima Sinai machoni pa watu wote. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Weka mipaka kuzunguka mlima kwa ajili ya watu, uwaambie, ‘Mwe waangalifu, msije mkapanda mlimani au kuugusa. Yeyote atakayeugusa mlima atauawa. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hakika atapigwa mawe au kupigwa mishale; mkono wa mtu hautamgusa. Akiwa mwanadamu au mnyama, hataruhusiwa kuishi.’ Ila tu wakati baragumu itakapopigwa kwa mfululizo, ndipo watu wote watakapopanda mlimani.” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Baada ya Musa kushuka kutoka mlimani akawaendea watu na kuwaweka wakfu, wakafua nguo zao. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kisha akawaambia watu, “Jitayarisheni kwa ajili ya siku ya tatu. Mwanaume yeyote asimkaribie mwanamke.” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Asubuhi ya siku ya tatu kulikuwa na ngurumo na radi pamoja na wingu nene juu ya mlima na mlio mkubwa sana wa tarumbeta. Kila mmoja aliyekuwa kambini akatetemeka. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kisha Musa akawaongoza watu kutoka kambini kukutana na Mungu, nao wakasimama chini ya mlima. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mlima Sinai ulikuwa umefunikwa na moshi, kwa sababu Mwenyezi Mungu alishuka juu yake katika moto. Moshi wa moto huo ulipanda juu kama moshi kutoka tanuru kubwa, na mlima wote ukatetemeka kwa kishindo, ");
INSERT INTO swhonmm_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","nayo sauti ya tarumbeta ikawa kubwa zaidi na zaidi. Kisha Musa akazungumza, nayo sauti ya Mungu ikamjibu. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mwenyezi Mungu akashuka juu ya Mlima Sinai na akamwita Musa apande juu mlimani. Kwa hiyo Musa akapanda juu, ");
INSERT INTO swhonmm_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","naye Mwenyezi Mungu akamwambia Musa, “Shuka ukawaonye watu ili wasijipenyeze kutafuta kumwona Mwenyezi Mungu, na wengi wao wakaangamia. ");
INSERT INTO swhonmm_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hata makuhani, watakaomkaribia Mwenyezi Mungu ni lazima wajiweke wakfu, la sivyo Mwenyezi Mungu atawaadhibu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa akamwambia Mwenyezi Mungu, “Watu hawawezi kupanda Mlima Sinai kwa sababu wewe mwenyewe ulituonya ukisema, ‘Wekeni mipaka kuuzunguka mlima na kuutenga kama patakatifu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mwenyezi Mungu akajibu, “Shuka ukamlete Haruni pamoja nawe. Lakini makuhani pamoja na watu wasije wakalazimisha kuja kwa Mwenyezi Mungu, nisije nikawaadhibu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Basi Musa akashuka kwa watu na kuwaambia lile aliloambiwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ndipo Mungu akasema maneno haya yote: ");
INSERT INTO swhonmm_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mimi ndimi Mwenyezi Mungu, Mungu wako, niliyekutoa Misri, kutoka nchi ya utumwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Usiwe na miungu mingine ila mimi. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Usijitengenezee sanamu katika umbo la kitu chochote kilicho juu mbinguni, au duniani chini, au ndani ya maji. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Usivisujudie wala kuviabudu; kwa kuwa Mimi, Mwenyezi Mungu, Mungu wako, ni Mungu mwenye wivu, ninayewaadhibu watoto kwa ajili ya dhambi za baba zao hadi kizazi cha tatu na cha nne cha wanaonichukia, ");
INSERT INTO swhonmm_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","lakini ninaonesha upendo kwa maelfu ya vizazi vya wale wanaonipenda na kuzishika amri zangu. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Usilitaje bure jina la Mwenyezi Mungu, Mungu wako, kwa kuwa Mwenyezi Mungu hataacha kumhesabia hatia yeye alitajaye jina lake bure. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ikumbuke siku ya Sabato, uitakase. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kwa siku sita utafanya kazi na kutenda shughuli zako zote, ");
INSERT INTO swhonmm_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lakini siku ya saba ni Sabato kwa Mwenyezi Mungu, Mungu wako. Siku hiyo hutafanya kazi yoyote, wewe, wala mwanao au binti yako, wala mtumishi wako wa kiume au wa kike, wala wanyama wako, wala mgeni aliye ndani ya malango yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kwa kuwa kwa siku sita, Mwenyezi Mungu aliumba mbingu na nchi, bahari na vyote vilivyomo, lakini akapumzika siku ya saba. Kwa hiyo Mwenyezi Mungu akaibariki siku ya Sabato na kuifanya takatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Waheshimu baba yako na mama yako, ili upate kuishi siku nyingi katika nchi anayokupa Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Usiue. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Usizini. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Usiibe. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Usimshuhudie jirani yako uongo. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Usiitamani nyumba ya jirani yako. Usimtamani mke wa jirani yako, wala mtumishi wake wa kiume au wa kike, wala ng’ombe wake au punda wake, wala chochote kile alicho nacho jirani yako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Watu walipoona ngurumo na radi, na kusikia mlio wa tarumbeta, na kuuona mlima katika moshi, walitetemeka kwa woga. Wakasimama mbali ");
INSERT INTO swhonmm_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","na wakamwambia Musa, “Sema nasi wewe mwenyewe, nasi tutakusikiliza. Lakini usimwache Mungu aseme nasi, la sivyo tutakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa akawaambia watu, “Msiogope! Mungu amekuja kuwajaribu, ili hofu ya Mungu iwe nanyi kuwasaidia msitende dhambi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Watu wakabaki mbali, wakati Musa alipolisogelea lile giza nene mahali pale Mungu alipokuwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kisha Mwenyezi Mungu akamwambia Musa, “Waambie Waisraeli hivi: ‘Mmejionea wenyewe kwamba nimesema nanyi kutoka mbinguni: ");
INSERT INTO swhonmm_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Msijifanyizie miungu yoyote na kuilinganisha nami, msijitengenezee miungu ya fedha wala miungu ya dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Utanitengenezea madhabahu ya udongo, na juu yake utoe sadaka za kuteketezwa kwa moto na sadaka za amani, kondoo na mbuzi, na ng’ombe wako. Popote nitakapofanya Jina langu liheshimiwe, nitakuja kwenu na kuwabariki. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ikiwa unanitengenezea madhabahu ya mawe, usiijenge kwa mawe ya kuchonga, maana mkitumia chombo cha kuchongea mtaitia unajisi. ");
INSERT INTO swhonmm_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Usitumie ngazi kupanda kwenye madhabahu yangu, uchi wako usije ukadhihirika kwa chini.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Hizi ndizo sheria utakazoweka mbele ya Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ukimnunua mtumwa Mwebrania, atakutumikia kwa miaka sita. Lakini katika mwaka wa saba, atakuwa huru naye ataenda zake pasipo kulipa chochote. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Akija peke yake, ataenda huru peke yake, lakini akija na mke, ataondoka pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ikiwa bwana wake alimpatia mke naye akamzalia wana au binti, mwanamke pamoja na watoto wake watakuwa mali ya bwana wake, na huyo mwanaume ataondoka peke yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Lakini mtumishi akisema, ‘Ninampenda bwana wangu, mke wangu pamoja na watoto na sitaki kuwa huru,’ ");
INSERT INTO swhonmm_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","basi bwana wake atalazimika kumpeleka mbele ya waamuzi. Kisha atampeleka kwenye mlango, au kizingiti na kutoboa sikio lake kwa shazia. Naye atamtumikia bwana wake maisha yake yote. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Mtu akimuuza binti yake kuwa mtumwa, hataachwa huru kama watumwa wa kiume wanavyoachiwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kama hakumpendeza bwana wake aliyemchagua, huyo bwana atamwacha akombolewe. Hatakuwa na haki ya kumuuza kwa wageni, kwa sababu huyo bwana atakuwa amekosa uaminifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Akimchagua aolewe na mwanawe, ni lazima ampe haki za kuwa binti yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ikiwa huyo mwana aliyeozwa mtumwa mwanamke ataoa mwanamke mwingine, ni lazima aendelee kumtosheleza huyo mke wa kwanza kwa chakula, mavazi na haki zote za ndoa. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Iwapo hatamtosheleza kwa mambo hayo matatu, huyo mke wa kwanza ataondoka na kuwa huru bila malipo yoyote ya fedha. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Yeyote anayempiga mtu na kumuua ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Hata hivyo, kama hakumuua kwa makusudi, lakini Mungu akaruhusu itendeke, basi atakimbilia mahali nitakapomchagulia. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lakini kama mtu akipanga na kumuua mwingine kwa makusudi, mwondoe katika madhabahu yangu na kumuua. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Yeyote anayemshambulia baba yake au mama yake ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Yeyote anayemteka nyara mwingine akamuuza au akamweka kwake, akikamatwa ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Yeyote atakayemlaani baba yake au mama yake ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Watu wakigombana, naye mmoja akampiga mwingine kwa jiwe au kwa ngumi yake na hakufa, bali akaugua na kulala kitandani, ");
INSERT INTO swhonmm_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","yule aliyempiga ngumi hatahesabiwa kuwa na hatia ikiwa mwenzake ataamka na kujikongoja kwa fimbo yake, lakini hata hivyo, ni lazima amlipe fidia ya muda aliopoteza na awajibike hadi apone kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Mtu akimpiga mtumwa wake wa kiume au wa kike kwa fimbo na mtumwa huyo akafa papo hapo, ni lazima aadhibiwe ");
INSERT INTO swhonmm_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","lakini ikiwa mtumwa ataamka baada ya siku moja au mbili, hataadhibiwa, kwa sababu yule mtumwa ni mali yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Watu wawili wakipigana na wakamuumiza mwanamke mjamzito, naye akazaa kabla ya wakati lakini hakuna majeraha makubwa, mhalifu atatozwa mali kiasi cha madai ya mume wa yule mwanamke, na jinsi mahakama itakavyoamua. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Lakini kukiwa na jeraha kubwa, ni lazima ulipe uhai kwa uhai, ");
INSERT INTO swhonmm_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","jicho kwa jicho, jino kwa jino, mkono kwa mkono, mguu kwa mguu, ");
INSERT INTO swhonmm_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kuchomwa moto kwa kuchomwa moto, jeraha kwa jeraha, mchubuko kwa mchubuko. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Mtu akimpiga mtumwa wa kiume au wa kike kwenye jicho na kuliharibu, ni lazima amwache huru yule mtumwa kama fidia ya hilo jicho. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Akimvunja jino mtumwa wa kiume au wa kike, ni lazima amwache huru huyo mtumwa kwa kufidia hilo jino. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Fahali akimuua mwanaume au mwanamke kwa kumpiga kwa pembe, fahali huyo ni lazima auawe kwa kupigwa mawe, na nyama yake haitaliwa. Lakini mwenye fahali huyo hatawajibika. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lakini hata hivyo, ikiwa huyo fahali amekuwa na tabia ya kupiga kwa pembe, na mwenyewe ameonywa na hakutaka kumfungia naye akamuua mwanaume au mwanamke, huyo fahali ni lazima auawe kwa mawe na mwenye fahali pia auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Lakini ikiwa malipo yatatakiwa kwake, basi anaweza kulipa kinachodaiwa ili kuukomboa uhai wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Sheria hii pia itatumika ikiwa fahali atampiga kwa pembe mwana au binti. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Fahali akimpiga mtumwa wa kike au wa kiume, mwenye fahali atalipa shekeli thelathini za fedha kwa bwana mwenye mtumwa, na fahali ni lazima auawe kwa mawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Mtu akiacha shimo wazi, ama akachimba shimo kisha asilifukie, na ng’ombe au punda akatumbukia ndani yake, ");
INSERT INTO swhonmm_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwenye shimo ni lazima alipe hasara iliyotokea; ni lazima amlipe mwenye mnyama. Mnyama aliyekufa atakuwa wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Fahali wa mtu fulani akimuumiza fahali wa mtu mwingine na akafa, watamuuza yule aliye hai na wagawane sawa fedha pamoja na mnyama aliyekufa. ");
INSERT INTO swhonmm_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Hata hivyo, ikifahamika kwamba fahali huyo alikuwa na tabia ya kupiga kwa pembe na mwenyewe hakumfunga, ni lazima mwenye fahali alipe mnyama kwa mnyama, na mnyama aliyekufa atakuwa wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Mtu yeyote akiiba maksai au kondoo na kumchinja au kumuuza, ni lazima alipe ng’ombe watano badala ya maksai mmoja na kondoo wanne badala ya kondoo mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Mwizi akishikwa akivunja nyumba akapigwa hata akafa, aliyemuua hana hatia ya kumwaga damu; ");
INSERT INTO swhonmm_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","lakini jambo hilo likitokea wakati jua limechomoza, huyo mtu atakuwa na hatia ya kumwaga damu. “Mwizi huyo sharti alipe, lakini kama hana kitu, lazima auzwe ili alipe kwa ajili ya wizi wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Mnyama aliyeibwa akikutwa hai mkononi mwake, iwe ni maksai au punda au kondoo, lazima alipe mara mbili. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Mtu akichunga mifugo yake katika shamba au shamba la mizabibu, na akawaachia walishe katika shamba la mtu mwingine, ni lazima alipe vitu bora kutoka shamba lake mwenyewe au kutoka shamba lake la mizabibu. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Moto ukiwaka na kuenea kwenye vichaka vya miiba na kuteketeza miganda ya nafaka au nafaka ambayo haijavunwa, au kuteketeza shamba lote, mtu yule aliyewasha moto lazima alipe. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Mtu akimpa jirani yake fedha au mali nyingine amtunzie, vitu vile vikiibwa kutoka nyumba ya huyo jirani, kama mwizi akishikwa, lazima alipe mara mbili. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lakini mwizi asipopatikana, mwenye nyumba atafika mbele ya waamuzi ili kuthibitisha kuwa hakuchukua mali ya mwenzake. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Pakiwepo jambo lolote la mali isiyo halali, iwe ni maksai, punda, kondoo, mavazi, ama mali yoyote iliyopotea, ambayo mtu fulani atasema, ‘Hii ni mali yangu,’ kila upande utaleta shauri lake mbele ya waamuzi. Yule ambaye waamuzi watathibitisha kuwa ana hatia atamlipa jirani yake mara mbili. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Mtu akimpa jirani yake punda, ng’ombe, kondoo au mnyama mwingine yeyote amtunzie, yule mnyama akifa, au akijeruhiwa, au akiibiwa bila mtu kuona, ");
INSERT INTO swhonmm_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","jambo hili kati yao wawili litaamuliwa kwa kuapa mbele za Mwenyezi Mungu, kwamba huyo jirani hakuhusika na wizi wa mali ya jirani yake. Mwenye mali itampasa akubali jambo hili, na hakuna malipo yatakayohitajika. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lakini kama mnyama aliibwa kwa jirani, itampasa amlipe mwenye mnyama. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kama ameraruliwa na mnyama pori, ataleta mabaki ya mnyama kama ushahidi, naye hatadaiwa mnyama aliyeraruliwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Mtu akiazima mnyama kutoka kwa jirani yake, huyo mnyama akiumia au akafa na mwenye mnyama hayupo, lazima amlipe huyo mnyama. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lakini mwenye mnyama akiwa bado ako na mnyama wake, aliyeazima hatalazimika kumlipa. Kama mnyama alikuwa amekodishwa, fedha iliyolipwa kwa kukodisha inatosha kwa kufidia hasara. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Mtu akimshawishi bikira ambaye hajaposwa na akalala naye, lazima alipe mahari, kisha atamwoa msichana huyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Baba wa msichana akikataa katakata kumpa huyo mtu binti yake, bado ni lazima huyo mtu atalipa mahari kama inavyostahili malipo ya ubikira. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Usiruhusu mwanamke mchawi aishi. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Mtu yeyote aziniye na mnyama lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Mtu yeyote anayemtolea mungu mwingine dhabihu isipokuwa Mwenyezi Mungu, lazima aangamizwe. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Usimtendee mgeni vibaya au kumdhulumu, kwa kuwa nanyi mlikuwa wageni huko Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Usimdhulumu mjane wala yatima. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ukifanya hivyo nao wakinililia, hakika nitasikia kilio chao. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Hasira yangu itawaka, nami nitawaua kwa upanga, wake zenu watakuwa wajane na watoto wenu watakuwa yatima. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ukimkopesha mmoja wa watu wangu fedha ambaye ni mhitaji, usiwe kama mtu mkopesha fedha; usimtoze riba. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ukichukua vazi la jirani kama rehani, ulirudishe kwake kabla jua kuzama, ");
INSERT INTO swhonmm_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kwa kuwa vazi lake ndilo pekee alilo nalo la kumfunika mwili wake. Ni nini kingine atajifunika nacho? Atakaponililia, nitasikia, kwa kuwa nina huruma. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Usimkufuru Mungu au kumlaani mtawala wa watu wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Usiache kutoa sadaka kutoka ghala lako au mapipa yako. “Lazima unipe mzaliwa wa kwanza wa wana wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ufanye vivyo hivyo kwa ng’ombe wako na kwa kondoo wako. Waache wakae na mama zao kwa siku saba, lakini siku ya nane unipe. ");
INSERT INTO swhonmm_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ninyi mtakuwa watu wangu watakatifu. Kwa hiyo msile nyama ya mnyama aliyeraruliwa na wanyama pori; mtupieni mbwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Usieneze habari za uongo. Usimsaidie mtu mwovu kwa kuwa shahidi mwenye nia ya kudhuru wengine. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Usifuate umati wa watu katika kutenda mabaya. Unapotoa ushahidi kwenye mashtaka, usipotoshe haki ukijumuika na umati wa watu, ");
INSERT INTO swhonmm_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","nawe usimpendelee mtu maskini katika mashtaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ukikutana na maksai au punda wa adui yako anapotea, hakikisha umemrudisha kwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ukiona punda wa mtu anayekuchukia ameanguka na mzigo wake, usimwache hapo alipoangukia; hakikisha kuwa umemsaidia. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Usiwanyime haki watu wako walio maskini katika mashtaka yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ujiepushe na mashtaka ya uongo, wala usimuue mtu asiye na hatia au mtu mwaminifu, kwa maana sitamhesabia hana hatia yeye aliye na hatia. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Usipokee rushwa, kwa kuwa rushwa hupofusha wale waonao, na kupinda maneno ya wenye haki. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Usimdhulumu mgeni; ninyi wenyewe mnajua jinsi mgeni anavyojisikia, kwa sababu mlikuwa wageni Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kwa muda wa miaka sita mtapanda mashamba yenu na kuvuna mazao, ");
INSERT INTO swhonmm_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","lakini katika mwaka wa saba usiilime ardhi wala kuitumia, ili watu walio maskini miongoni mwenu waweze kupata chakula kwenye hayo mashamba, nao wanyama pori wapate chakula kwa yale mabaki watakayobakiza. Utafanya hivyo katika shamba lako la mizabibu na la mizeituni. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kwa siku sita fanya kazi zako, lakini siku ya saba usifanye kazi, ili maksai wako na punda wako wapate kupumzika, naye mtumwa aliyezaliwa nyumbani mwako, pamoja na mgeni, wapate kuburudishwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Uzingatie kutenda kila kitu nilichokuambia. Usiombe kwa majina ya miungu mingine, wala usiyaruhusu kusikika kinywani mwako. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Mara tatu kwa mwaka utanifanyia sikukuu. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Utaadhimisha Sikukuu ya Mikate Isiyotiwa Chachu; kwa siku saba utakula mikate isiyotiwa chachu kama nilivyokuagiza. Fanya jambo hili kwa wakati uliopangwa katika mwezi wa Abibu, kwa sababu katika mwezi huo ulitoka Misri. “Mtu yeyote asije mbele yangu mikono mitupu. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Utaadhimisha Sikukuu ya Mavuno kwa malimbuko ya mazao yako uliyopanda katika shamba lako. “Utaadhimisha Sikukuu ya Kukusanya mavuno mwishoni mwa mwaka, unapokusanya mavuno yako toka shambani. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Mara tatu kwa mwaka wanaume wote watakuja mbele za Bwana Mungu Mwenyezi. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Msitoe damu ya dhabihu kwangu pamoja na kitu chochote kilicho na chachu. “Mafuta ya mnyama wa sadaka ya sikukuu yangu yasibakizwe hadi asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Utaleta malimbuko bora ya ardhi yako katika nyumba ya Mwenyezi Mungu, Mungu wako. “Usimchemshe mwana-mbuzi katika maziwa ya mama yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Tazama, ninamtuma malaika akutangulie mbele yako akulinde njiani na kukuleta mahali nilipoandaa. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mtamtii na kusikiliza kile anachokisema. Usiasi dhidi yake; hatakusamehe uasi wako, kwa maana Jina langu limo ndani yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ukizingatia atakachosema na kufanya yote ninayosema, nitakuwa adui wa adui zako, na nitawapinga wale wakupingao. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaika wangu atatangulia mbele yako na kukuleta katika nchi ya Waamori, Wahiti, Waperizi, Wakanaani, Wahivi na Wayebusi, nami nitawafutilia mbali. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Usiisujudie miungu yao, au kuiabudu, wala kufuata desturi yao. Utayabomoa kabisa na kuvunjavunja mawe yao ya ibada vipande vipande. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Utamwabudu Mwenyezi Mungu, Mungu wako, na baraka zake zitakuwa juu ya vyakula vyako na maji yako. Nami nitaondoa maradhi miongoni mwako, ");
INSERT INTO swhonmm_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","na hakuna atakayeharibu mimba wala atakayekuwa tasa katika nchi yako. Nami nitakupa maisha makamilifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nitapeleka utisho wangu mbele yako na kufadhaisha kila taifa utakalolifikia. Nitafanya adui zako wote wakupe kisogo na kukimbia. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nitatanguliza nyigu mbele yako kuwafukuza Wahivi, Wakanaani na Wahiti waondoke njiani mwako. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Lakini sitawafukuza kwa mara moja, kwa sababu nchi itabaki ukiwa na wanyama pori watakuwa wengi mno kwako. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nitawafukuza kidogo kidogo mbele yako, hadi uwe umeongezeka kiasi cha kutosha kuimiliki nchi. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Nitaweka mipaka ya nchi yako kuanzia Bahari ya Shamu hadi Bahari ya Wafilisti, na kuanzia jangwani hadi Mto. Nitawatia watu wanaoishi katika nchi hizo mikononi mwako, nawe utawafukuza watoke mbele yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Usifanye agano lolote nao wala na miungu yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Usiwaache waishi katika nchi yako, la sivyo watakusababisha utende dhambi dhidi yangu, kwa sababu ibada ya miungu yao hakika itakuwa mtego kwako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kisha Mungu akamwambia Musa, “Njooni huku juu kwa Mwenyezi Mungu, wewe na Haruni, Nadabu na Abihu, pamoja na wazee sabini wa Israeli. Mniabudu kwa mbali, ");
INSERT INTO swhonmm_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","lakini Musa peke yake ndiye atakayemkaribia Mwenyezi Mungu; wengine wasije karibu. Nao watu wasije wakapanda pamoja naye.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa alipoenda na kuwaambia watu maneno yote na sheria zote za Mwenyezi Mungu, wakaitikia kwa sauti moja, “Kila kitu alichosema Mwenyezi Mungu tutakifanya.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ndipo Musa akaandika kila kitu Mwenyezi Mungu alichokuwa amesema. Akaamka kesho yake asubuhi na mapema na kujenga madhabahu chini ya mlima na kusimamisha nguzo kumi na mbili za mawe kuwakilisha makabila kumi na mawili ya Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kisha akawatuma vijana wanaume Waisraeli, nao wakatoa sadaka za kuteketezwa na dhabihu za mafahali wachanga kuwa sadaka za amani kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa akachukua nusu ya damu ya wale wanyama na kuiweka kwenye mabakuli, na nusu nyingine akainyunyiza juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kisha akachukua kile Kitabu cha Agano na kuwasomea watu. Nao wakajibu, “Tutafanya kila kitu alichosema Mwenyezi Mungu, nasi tutatii.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ndipo Musa akachukua ile damu, akawanyunyizia wale watu, akasema, “Hii ni damu ya agano ambalo Mwenyezi Mungu amelifanya nanyi kufuatana na maneno haya yote.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa na Haruni, Nadabu na Abihu, pamoja na wazee sabini wa Israeli wakapanda mlimani, ");
INSERT INTO swhonmm_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","nao wakamwona Mungu wa Israeli. Chini ya miguu yake kulikuwa na kitu kama sakafu ya mawe ya yakuti samawi, iliyo safi kama anga angavu. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Lakini Mungu hakuinua mkono wake dhidi ya hawa viongozi wa Waisraeli; walimwona Mungu, nao wakala na kunywa. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mwenyezi Mungu akamwambia Musa, “Panda uje kwangu huku mlimani na ukae hapa, nami nitakupa vibao vya mawe, vyenye sheria na amri ambazo nimeziandika ziwe mwongozo wao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Basi Musa akaondoka na Yoshua mtumishi wake, naye Musa akapanda juu kwenye mlima wa Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa akawaambia wazee wa Israeli, “Tungojeni hapa hadi tutakapowarudia. Haruni na Huri wako pamoja nanyi, na kila aliye na shauri aweza kuwaendea wao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa alipopanda juu mlimani, wingu liliufunika huo mlima, ");
INSERT INTO swhonmm_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","nao utukufu wa Mwenyezi Mungu ukatua juu ya Mlima Sinai. Kwa muda wa siku sita wingu lilifunika mlima, na siku ya saba Mwenyezi Mungu akamwita Musa kutoka kati ya lile wingu. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Kwa Waisraeli utukufu wa Mwenyezi Mungu ulionekana kama moto uteketezao juu ya mlima. ");
INSERT INTO swhonmm_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Kisha Musa akaingia ndani ya lile wingu alivyokuwa akipanda mlimani. Naye akakaa huko mlimani kwa muda wa siku arobaini, usiku na mchana. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Waambie Waisraeli waniletee sadaka. Utapokea sadaka kwa niaba yangu kutoka kwa kila mtu ambaye moyo wake wapenda kutoa. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Hizi ndizo sadaka utakazozipokea kutoka kwao: “dhahabu, fedha na shaba; ");
INSERT INTO swhonmm_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nyuzi za rangi ya buluu, za zambarau, za rangi nyekundu, pamoja na kitani safi; singa za mbuzi; ");
INSERT INTO swhonmm_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ngozi za kondoo dume zilizopakwa rangi nyekundu, na ngozi za pomboo; mbao za mshita; ");
INSERT INTO swhonmm_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta ya zeituni kwa ajili ya taa; vikolezo kwa ajili ya mafuta ya upako, pamoja na uvumba wa harufu nzuri; ");
INSERT INTO swhonmm_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na vito vya shohamu na vito vingine vya thamani vya kuweka kwenye kizibau na kile kifuko cha kifuani. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Kisha uwaamuru wanitengenezee mahali patakatifu, nami nitakaa miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tengeneza Maskani hii na vyombo vyake vyote sawasawa na kielelezo nitakachokuonesha. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Nao watatengeneza Sanduku la mbao za mshita, lenye urefu wa dhiraa mbili na nusu, upana wa dhiraa moja na nusu, na kimo cha dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Utalifunika hilo Sanduku kwa dhahabu safi ndani na nje, na kulifanyia ukingo wa dhahabu juu yake kulizunguka. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Utalisubu kwa pete nne za dhahabu na kuzifungia kwenye miguu yake minne, pete mbili kwa upande mmoja na pete mbili kwa upande mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kisha utatengeneza mipiko ya mti wa mshita na kuzifunika kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Utaiingiza hiyo mipiko kwenye zile pete katika pande mbili za Sanduku ili kulibeba. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Hiyo mipiko itabakia daima katika hizo pete za hilo Sanduku; haitaondolewa. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kisha weka ndani ya hilo Sanduku ule Ushuhuda nitakaokupa. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Tengeneza kifuniko cha upatanisho cha dhahabu safi, chenye urefu wa dhiraa mbili na nusu, na upana wa dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tengeneza makerubi wawili wa dhahabu iliyofuliwa katika miisho ya hicho kifuniko. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tengeneza kerubi mmoja kwenye mwisho mmoja, na kerubi mwingine kwenye mwisho mwingine; watengeneze makerubi hao wawe kitu kimoja na hicho kifuniko katika miisho hiyo miwili. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Makerubi hao watakuwa wametandaza mabawa kuelekea juu, wakitia kivuli hicho kifuniko. Makerubi hao wataelekeana, wakitazama hicho kifuniko. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Weka huo Ushuhuda nitakaokupa ndani ya hilo Sanduku la Agano, na uweke hicho kifuniko juu ya hilo Sanduku. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Hapo juu ya hicho kifuniko, kati ya hao makerubi wawili walio juu ya hilo Sanduku la Ushuhuda, hapo ndipo nitakutana nawe na kukupa maagizo yangu kwa ajili ya Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Tengeneza meza ya mbao za mshita yenye urefu wa dhiraa mbili, upana wa dhiraa moja, na kimo cha dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ifunike kwa dhahabu safi, na kuitengenezea ukingo wa dhahabu kuizunguka pande zote. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kisha tengeneza upapi wenye upana wa nyanda moja, na ufanyie ule upapi ukingo wa dhahabu kuuzunguka pande zote. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tengeneza pete nne za dhahabu kwa ajili ya meza hiyo, na uzifungie kwenye pembe nne, pale penye miguu yake minne. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Pete hizo zitakuwa karibu na ukingo ule ili kuishikilia ile mipiko itakayotumika kuibebea hiyo meza. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tengeneza mipiko hiyo kwa mbao za mshita, uifunike na dhahabu, uitumie kubeba hiyo meza. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tengeneza sahani zake na masinia yake kwa dhahabu safi, pamoja na bilauri na bakuli zake kwa ajili ya kumiminia sadaka. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Utaweka mikate ya Wonesho juu ya meza hii iwe mbele yangu daima. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Tengeneza kinara cha taa cha dhahabu safi iliyofuliwa vizuri katika kitako chake na ufito wake; vikombe vyake vinavyofanana na ua, matovu yake na maua yake viwe kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Matawi sita yatatokeza kuanzia ule ufito wa katikati wa kinara cha taa: matawi matatu upande mmoja na matatu upande mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Vikombe vitatu vya mfano wa maua ya mlozi yenye matovu na maua vitakuwa katika tawi moja, vikombe vitatu katika tawi jingine, na vivyo hivyo kwa matawi yote sita yanayotokeza kwenye kile kinara cha taa. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Juu ya kinara chenyewe vitakuwa vikombe vinne vya mfano wa maua ya mlozi, yakiwa na matovu yake na maua yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Tovu moja litakuwa chini ya jozi ya kwanza ya matawi yaliyotokeza kwenye kinara cha taa, tovu la pili chini ya jozi ya pili, nalo tovu la tatu chini ya jozi ya tatu, yaani matawi sita kwa jumla. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Matovu na matawi yote yatakuwa kitu kimoja na kile kinara cha taa, yakifuliwa kwa dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Kisha tengeneza taa zake saba na uziweke juu ya kinara hicho ili ziangaze mbele yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mikasi ya kusawazishia tambi, pamoja na masinia, zote zitakuwa za dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Utatumia talanta moja ya dhahabu safi kutengeneza hicho kinara na vifaa vyake vyote. ");
INSERT INTO swhonmm_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hakikisha kuwa umevitengeneza sawasawa na ule mfano uliooneshwa kule mlimani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Tengeneza maskani ya Mungu kwa mapazia kumi ya kitani iliyosokotwa vizuri na nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu, naye fundi stadi atatarizi makerubi kwenye mapazia hayo. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mapazia yote yatatoshana kwa ukubwa: kila moja litakuwa na urefu wa dhiraa ishirini na nane, na upana wa dhiraa nne. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Unganisha mapazia matano pamoja; fanya vivyo hivyo kwa hayo mengine matano. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tengeneza vitanzi vya kitambaa cha buluu kwenye upindo wa pazia la mwisho la fungu la kwanza, na ufanye vivyo hivyo na pazia la fungu la mwisho. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fanya vitanzi hamsini katika pazia mmoja, na vitanzi vingine hamsini kwenye pazia la mwisho la fungu hilo lingine, navyo vitanzi vyote vielekeane. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kisha tengeneza vifungo hamsini vya dhahabu ili vitumike kufunga na kuunganisha mapazia pamoja kufanya maskani ya Mungu iwe kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Tengeneza mapazia kumi na moja ya singa za mbuzi kwa ajili ya kufunika Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Mapazia hayo kumi na moja yatakuwa na kipimo sawa, yaani urefu wa dhiraa thelathini, na upana wa dhiraa nne. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Unganisha hayo mapazia matano yawe fungu moja, na hayo mengine sita yawe fungu lingine. Kunja hilo pazia la sita mara mbili mbele ya Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tengeneza vitanzi hamsini kwenye upindo wa pazia la mwisho la fungu moja, na vivyo hivyo kwenye upindo wa pazia la mwisho la fungu hilo lingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kisha tengeneza vifungo hamsini vya shaba, uviingize katika vile vitanzi ili kukaza hema pamoja kuwa kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kuhusu kile kipande cha ziada cha pazia za hema, nusu ya hilo pazia lililobaki litaning’inizwa upande wa nyuma wa maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Mapazia ya hema yatakuwa na urefu wa dhiraa moja zaidi pande zote, sehemu itakayobaki itaning’inia pande zote za Maskani ili kuifunika. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tengeneza kifuniko cha hema kwa ngozi za kondoo dume zilizotiwa rangi nyekundu, na juu yake kifuniko cha ngozi za pomboo. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Tengeneza mihimili ya kusimamisha ya mti wa mshita kwa ajili ya maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kila mhimili uwe na urefu wa dhiraa kumi na upana wa dhiraa moja na nusu, ");
INSERT INTO swhonmm_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","zikiwa na ndimi mbili zilizo sambamba kila mmoja na mwingine. Tengeneza mihimili yote ya Maskani jinsi hii. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tengeneza mihimili ishirini kwa ajili ya upande wa kusini wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","kisha tengeneza vitako arobaini vya fedha vya kuweka chini ya hiyo mihimili, vitako viwili kwa kila mhimili, kimoja chini ya kila ulimi. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kuhusu upande wa kaskazini wa Maskani, tengeneza mihimili ishirini ");
INSERT INTO swhonmm_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vitako arobaini vya fedha, viwili chini ya kila mhimili. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kisha tengeneza mihimili sita kwa mwisho ulio mbali, yaani upande wa magharibi wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","na pia utengeneze mihimili miwili ya pembe za upande ulio mbali. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Katika pembe hizi mbili ni lazima mihimili yake iwe miwili kuanzia chini hadi juu, na iingizwe kwenye pete moja; mihimili ya pembe hizi mbili itafanana. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kwa hiyo kutakuwa mihimili nane, na vitako kumi na sita vya fedha, viwili chini ya kila mhimili. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Pia tengeneza mataruma ya mti wa mshita: matano kwa ajili ya mihimili ya upande mmoja wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","matano kwa ajili ya mihimili ya upande mwingine, na matano kwa ajili ya mihimili ya upande wa magharibi, mwisho kabisa mwa Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Taruma la katikati litapenya katikati ya mihimili kutoka mwisho mmoja hadi mwisho mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Funika hiyo mihimili kwa dhahabu, kisha tengeneza pete za dhahabu ambazo zitashikilia hayo mataruma. Pia funika hayo mataruma kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Simamisha maskani ya Mungu sawasawa na mfano uliooneshwa kule mlimani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tengeneza pazia la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu na kitani safi iliyosokotwa vizuri, naye fundi stadi atirizi makerubi kwenye hilo pazia. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Litundike kwa kulabu za dhahabu kwenye nguzo nne za mti wa mshita ambazo zimefunikwa kwa dhahabu, zikiwa zimesimamishwa kwenye vitako vinne vya fedha. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ning’iniza pazia hilo kwenye vifungo, kisha weka Sanduku la Ushuhuda nyuma ya pazia. Pazia litatenganisha Mahali Patakatifu kutoka Patakatifu pa Patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Weka kifuniko cha kiti cha rehema juu ya Sanduku la Ushuhuda ndani ya Patakatifu pa Patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Weka meza nje ya pazia upande wa kaskazini wa maskani ya Mungu, kisha weka kinara cha taa upande wa kusini wa maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Kwa ajili ya ingilio la hema, tengeneza pazia la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu na kitani safi iliyosokotwa vizuri, kazi ya mtarizi. ");
INSERT INTO swhonmm_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tengeneza kulabu za dhahabu kwa ajili ya hilo pazia, na nguzo tano za mshita zilizofunikwa kwa dhahabu. Kisha subu vitako vitano vya shaba kwa ajili yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Jenga madhabahu ya mbao za mti wa mshita, kimo chake kiwe dhiraa tatu; itakuwa mraba, urefu wake dhiraa tano, na upana wake dhiraa tano. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tengeneza upembe kwenye kila pembe ya hizo pembe nne, ili zile pembe na madhabahu ziwe zimeungana, na ufunike madhabahu kwa shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tengeneza vyombo vyake vyote kwa shaba: vyungu vyake vya kuondolea majivu, masepetu, mabakuli ya kunyunyizia, uma za nyama, na vyombo vya kuchukulia moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kisha tengenezea hayo madhabahu wavu wa shaba, na utengeneze pete za shaba kwenye kila moja ya hizo pembe nne za huo wavu. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Weka wavu huo chini ya ukingo wa madhabahu ili ufikie nusu ya kimo cha madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tengeneza mipiko ya mti wa mshita kwa ajili ya madhabahu, na uifunike kwa shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Hiyo mipiko itaingizwa kwenye zile pete ili iwe pande mbili za madhabahu inapobebwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tengeneza madhabahu yawe na uvungu ndani yake ukitumia mbao. Utaitengeneza sawasawa na vile ulivyooneshwa mlimani. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Tengeneza ua kwa ajili ya Hema la Kukutania. Upande wa kusini utakuwa na urefu wa dhiraa mia moja, na utakuwa na mapazia ya kitani iliyosokotwa vizuri, ");
INSERT INTO swhonmm_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","pamoja na nguzo ishirini na vitako vya shaba ishirini, na kulabu na tepe za fedha juu ya hizo nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Upande wa kaskazini utakuwa na urefu wa dhiraa mia moja, nao utakuwa na mapazia, pamoja na nguzo ishirini na vitako vya shaba ishirini, pamoja na kulabu na tepe za fedha juu ya hizo nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Upande wa magharibi wa ua utakuwa na upana wa dhiraa hamsini, nao utakuwa na mapazia, na nguzo kumi na vitako vyake kumi. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Upande wa mwisho wa mashariki jua linakochomoza, ua pia utakuwa na upana wa dhiraa hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Mapazia yenye urefu wa dhiraa kumi na tano yatakuwa upande mmoja wa ingilio, pamoja na nguzo tatu na vitako vitatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kutakuwa na mapazia ya dhiraa kumi na tano kwa upande mwingine wa ingilio, pamoja na nguzo tatu na vitako vitatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Kuhusu ingilio la ua, weka pazia lenye urefu wa dhiraa ishirini la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu pamoja na kitani iliyosokotwa vizuri, kazi ya mtarizi. Pazia hilo litashikiliwa na nguzo nne na vitako vinne. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Nguzo zote zinazozunguka ua zitakuwa na tepe na kulabu za fedha, na vitako vya shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ua utakuwa na urefu wa dhiraa mia moja na upana wa dhiraa hamsini, ukiwa na mapazia ya kitani yaliyosokotwa vizuri yenye urefu wa dhiraa tano kwenda juu na vitako vya shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Vyombo vingine vyote vinavyotumika katika maskani ya Mungu kwa shughuli yoyote, pamoja na vigingi vyote na hata vile vya ua, vitakuwa vya shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Utawaamuru Waisraeli wakuletee mafuta safi ya zeituni yaliyokamuliwa kwa ajili ya mwanga ili zile taa ziwake mfululizo. ");
INSERT INTO swhonmm_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Katika Hema la Kukutania, nje ya pazia lililo mbele ya Sanduku la Ushuhuda, Haruni na wanawe watahakikisha kuwa taa hizo zinawaka kuanzia jioni hadi asubuhi mbele za Mwenyezi Mungu. Hili litakuwa agizo la milele miongoni mwa Waisraeli kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Mtwae Haruni ndugu yako aliyeletwa kwako kutoka miongoni mwa Waisraeli, pamoja na wanawe Nadabu, Abihu, Eleazari na Ithamari, ili wanitumikie katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mshonee Haruni ndugu yako mavazi matakatifu ili yampe ukuu na heshima. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Waambie mafundi stadi wote niliowapa hekima katika shughuli hiyo wamtengenezee Haruni mavazi hayo, ili awekwe wakfu, anitumikie katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Haya ndio mavazi watakayoshona: kifuko cha kifuani, kizibau, kanzu, joho lililofumwa, kilemba na mshipi. Mavazi haya yatashonwa kwa ajili ya ndugu yako Haruni na wanawe ili wanitumikie katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Waambie watumie dhahabu na nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu pamoja na kitani safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Tengeneza kizibau cha dhahabu, na nyuzi za rangi ya buluu, za zambarau, za rangi nyekundu na kitani safi iliyosokotwa, kazi ya fundi stadi. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kitakuwa na vipande viwili vya mabegani vilivyoshikizwa kwenye pembe zake mbili ili kufungia kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mshipi wa kiunoni uliofumwa kwa ustadi utafanana nacho: utakuwa kitu kimoja na hicho kizibau, nao utengenezwe kwa dhahabu na nyuzi za rangi ya buluu, za zambarau, na nyekundu na kwa kitani iliyosokotwa vizuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Chukua vito viwili vya shohamu, na uchore juu yake majina ya wana wa Israeli ");
INSERT INTO swhonmm_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kufuatana na walivyozaliwa: majina sita katika kito kimoja, na mengine sita katika kito kingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Yachore majina ya wana wa Israeli juu ya vito hivyo viwili kama vile sonara anavyochonga muhuri. Kisha uvitie vito hivyo katika vijalizo vya dhahabu, ");
INSERT INTO swhonmm_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","na uvifungie juu ya vipande vya mabega ya kizibau yawe kama vito vya ukumbusho kwa wana wa Israeli. Haruni atavaa majina hayo mabegani mwake kama kumbukumbu mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tengeneza vijalizo vya dhahabu ");
INSERT INTO swhonmm_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu miwili ya dhahabu safi iliyosokotwa kama kamba, na uifunge mikufu hiyo kwenye vijalizo. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Tengeneza kifuko cha kifuani kwa ajili ya kufanya maamuzi, kazi ya fundi stadi. Kitengeneze kama kile kizibau: cha dhahabu, na nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu, cha kitani safi iliyosokotwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kitakuwa cha mraba, chenye urefu wa shibiri moja na upana wa shibiri moja, na kikunjwe mara mbili. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kisha weka safu nne za vito vya thamani juu yake. Safu ya kwanza itakuwa na akiki, yakuti manjano na zabarajadi; ");
INSERT INTO swhonmm_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","katika safu ya pili itakuwa na almasi, yakuti samawi na zumaridi; ");
INSERT INTO swhonmm_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","safu ya tatu itakuwa na hiakintho, akiki nyekundu na amethisto; ");
INSERT INTO swhonmm_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","na safu ya nne itakuwa na krisolitho, shohamu na yaspi. Yote yatiwe kwenye vijalizo vya dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Patakuwa na vito kumi na viwili, kila kimoja kwa jina mojawapo la wana wa Israeli, kila kimoja kichorwe kama muhuri kikiwa na jina mojawapo la yale makabila kumi na mawili. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kwa ajili ya kile kifuko cha kifuani, tengeneza mikufu ya dhahabu safi, iliyosokotwa kama kamba. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tengeneza pete mbili za dhahabu kwa ajili yake, uzifungie kwenye pembe mbili za hicho kifuko cha kifuani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Funga ile mikufu miwili ya dhahabu kwenye hizo pete zilizo katika pembe za hicho kifuko cha kifuani, ");
INSERT INTO swhonmm_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","nazo zile ncha nyingine za mkufu zifunge kwenye vile vijalizo viwili, na uziunganishe na vile vipande vya mabega vya kile kizibau upande wa mbele. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tengeneza pete mbili za dhahabu, uziunganishe kwenye pembe mbili za chini, upande wa ndani wa kifuko cha kifuani karibu na kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Tengeneza pete nyingine mbili za dhahabu, na uziunganishe sehemu ya chini ya vipande vya mabega, upande wa mbele wa kile kizibau, karibu na pindo, juu kidogo ya mshipi wa kiunoni wa kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Pete za kifuko cha kifuani zitafungwa kwenye pete zile za kizibau kwa kamba ya buluu, ziunganishwe na ule mshipi wa kiunoni, ili kifuko cha kifuani kisisogee kutoka kwa kile kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Wakati wowote Haruni anapoingia Mahali Patakatifu, atakuwa na yale majina ya wana wa Israeli moyoni mwake juu ya kile kifuko cha kifuani cha uamuzi, kama kumbukumbu ya kudumu mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Pia weka Urimu na Thumimu ndani ya kifuko cha kifuani, yawe juu ya moyo wa Haruni kila mara aingiapo mbele za Mwenyezi Mungu. Kwa hiyo siku zote Haruni atakuwa na uwezo kufanya maamuzi kwa ajili ya Waisraeli mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Shona joho la kizibau lote kwa kitambaa cha rangi ya buluu tupu, ");
INSERT INTO swhonmm_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","na katikati uweke nafasi ya kuingizia kichwa. Kutakuwa na utepe uliofumwa, unaofanana na ukosi kuizunguka nafasi hiyo, ili isichanike. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Tengeneza makomamanga ya nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu kuzunguka pindo la hilo joho, na uweke pia vikengele vya dhahabu kati ya hayo makomamanga. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hivyo vikengele vya dhahabu na makomamanga vitapishana kuzunguka upindo wa joho lile. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ni lazima Haruni alivae anapofanya huduma. Sauti ya hivyo vikengele itasikika anapoingia na kutoka Mahali Patakatifu mbele za Mwenyezi Mungu, ili asije akafa. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Tengeneza bamba la dhahabu safi na uchore juu yake maneno haya kama vile muhuri huchorwa: Mtakatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Lifunge hilo bamba kwa kamba ya buluu kwenye kilemba, nalo ni lazima liwe mbele ya kilemba. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Haruni alivae bamba hilo kwenye paji la uso wake, naye atachukua hatia kuhusu sadaka takatifu za Waisraeli wanazoweka wakfu, sadaka za aina yoyote. Litakuwa kwenye paji la uso wa Haruni daima ili zikubalike kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Fuma koti la kitani safi na ufanye kilemba cha kitani safi. Mshipi uwe ni kazi ya mtarizi. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Watengenezee wana wa Haruni makoti, mishipi na kofia, ili kuwapa ukuu na heshima. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Baada ya kumvika Haruni ndugu yako pamoja na wanawe nguo hizi, wapake mafuta na kuwabariki. Waweke wakfu ili wanitumikie katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Watengenezee nguo za ndani za kitani zitakazofunika mwili, kutoka kiunoni hadi mapajani. ");
INSERT INTO swhonmm_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruni na wanawe ni lazima wavae haya kila wanapoingia katika Hema la Kukutania au wanaposogelea madhabahu wakati wa kutoa huduma katika Mahali Patakatifu, ili wasije wakafanya kosa wakafa. “Haya yawe maagizo ya kudumu kwa Haruni na vizazi vyake. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Hili ndilo utakalofanya ili kuwaweka wakfu makuhani ili wanitumikie mimi katika kazi ya ukuhani: Chukua fahali mchanga mmoja na kondoo dume wawili wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Kutokana na unga laini wa ngano usiotiwa chachu, tengeneza mikate na maandazi yaliyokandwa kwa mafuta, pamoja na mikate myembamba iliyopakwa mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Viwekwe vyote ndani ya kikapu na kuvitoa pamoja na yule fahali na wale kondoo dume wawili. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kisha mlete Haruni na wanawe kwenye lango la Hema la Kukutania na uwaoshe kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Chukua yale mavazi na umvike Haruni koti, joho la kizibau, na kizibau chenyewe, pamoja na kile kifuko cha kifuani. Mfungie hicho kizibau kwa ule mshipi wa kiunoni uliofumwa kwa ustadi. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Weka kilemba kichwani mwake na kuweka taji takatifu lishikamane na hicho kilemba. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Chukua yale mafuta ya upako umimine juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Walete wanawe na uwavike makoti, ");
INSERT INTO swhonmm_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","pia uwavike zile tepe za kichwani. Ndipo uwafunge Haruni na wanawe mishipi. Ukuhani ni wao kwa agizo la kudumu. Kwa njia hii utamweka wakfu Haruni na wanawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Mlete yule fahali mbele ya Hema la Kukutania, naye Haruni na wanawe wataweka mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mchinje huyo fahali mbele za Mwenyezi Mungu kwenye mlango wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Chukua sehemu ya damu ya huyo fahali na kuipaka kwenye pembe za hayo madhabahu kwa kidole chako, na damu iliyobaki uimwage sehemu ya chini ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kisha chukua mafuta yote ya huyo mnyama ya sehemu za ndani, na kipande kirefu cha ini, na figo zote mbili pamoja na mafuta yake, uviteketeze juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Lakini nyama ya huyo fahali na ngozi yake na matumbo yake utavichoma nje ya kambi. Hii ni sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Chukua mmoja wa wale kondoo dume, naye Haruni na wanawe wataweka mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mchinje huyo kondoo dume, chukua damu yake na uinyunyize pande zote za hayo madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mkate huyo kondoo dume vipande vipande na usafishe sehemu za ndani pamoja na miguu, ukiviweka pamoja na kichwa na vipande vingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kisha mteketeze huyo kondoo dume mzima juu ya madhabahu. Hii ni sadaka ya kuteketezwa kwa Mwenyezi Mungu, harufu ya kupendeza, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Mchukue yule kondoo dume mwingine, naye Haruni na wanawe waweke mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mchinje, uchukue sehemu ya damu yake na kuipaka kwenye masikio ya Haruni na wanawe, kwenye vidole gumba vya mikono yao ya kuume, pia kwenye vidole gumba vya miguu yao ya kuume. Kisha nyunyiza hiyo damu pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Pia chukua sehemu ya damu iliyo juu ya madhabahu na sehemu ya mafuta ya upako, umnyunyizie Haruni na mavazi yake, pia wanawe na mavazi yao. Ndipo Haruni na wanawe pamoja na mavazi yao watakuwa wamewekwa wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Chukua mafuta ya huyu kondoo dume, mafuta ya mkia, mafuta ya sehemu za ndani, kipande kirefu cha ini, figo zote mbili na mafuta yake, pamoja na paja la kulia. (Huyo ndiye kondoo dume kwa ajili ya kuwaweka wakfu.) ");
INSERT INTO swhonmm_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kutoka kwa kile kikapu chenye mikate iliyotengenezwa bila chachu, kilichoko mbele za Mwenyezi Mungu, chukua mkate, andazi lililokandwa kwa mafuta, na mkate mwembamba. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Viweke vitu hivi vyote mikononi mwa Haruni na wanawe na uviinue mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kisha vichukue vitu hivyo kutoka mikononi mwao, uviteketeze juu ya madhabahu pamoja na sadaka ya kuteketezwa kuwa harufu nzuri ya kupendeza kwa Mwenyezi Mungu, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Baada ya kuchukua kidari cha huyo kondoo dume wa kuwekwa wakfu kwa Haruni, kiinue mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa, nayo itakuwa fungu lako. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Weka wakfu zile sehemu za kondoo dume aliyetumika kwa kumweka wakfu Haruni na wanawe: kidari kile kilichoinuliwa na lile paja lililotolewa. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Siku zote hili litakuwa fungu la milele kutoka kwa Waisraeli kwa ajili ya Haruni na wanawe. Hili ni toleo la Waisraeli watakalotoa kwa Mwenyezi Mungu kutoka sadaka zao za amani. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Mavazi matakatifu ya Haruni yatakuwa ya wazao wake ili waweze kupakwa mafuta na kuwekwa wakfu wakiwa wameyavaa. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana atakayeingia mahali pake kuwa kuhani na kuja kwenye Hema la Kukutania kuhudumu katika Mahali Patakatifu atayavaa kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Chukua nyama ya huyo kondoo dume wa kuwaweka wakfu uipike katika Mahali Patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruni na wanawe wataila ile nyama ya huyo kondoo dume pamoja na ile mikate iliyo kwenye hicho kikapu wakiwa hapo ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Watakula sadaka hizi ambazo upatanisho ulifanywa kwazo kwa ajili ya kuwaweka wakfu na kuwatakasa. Lakini hakuna mtu mwingine yeyote anayeruhusiwa kuvila, kwa sababu ni vitakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ikiwa nyama yoyote ya huyo kondoo dume iliyotumika kwa kuwaweka wakfu au mkate wowote umebaki hadi asubuhi, vichomwe. Kamwe visiliwe, kwa sababu ni vitakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Hivyo utamfanyia Haruni na wanawe kila kitu kama vile nilivyokuamuru: Utachukua muda wa siku saba kuwaweka wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Utatoa dhabihu ya fahali kila siku kuwa sadaka ya dhambi ili kufanya upatanisho. Takasa madhabahu kwa kufanya upatanisho kwa ajili yake, nayo uipake mafuta na kuiweka wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kwa muda wa siku saba fanya upatanisho kwa ajili ya madhabahu na kuiweka wakfu. Ndipo madhabahu itakuwa takatifu sana na chochote kitakachoigusa kitakuwa kitakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Kwa kawaida hiki ndicho utakachotoa juu ya madhabahu kila siku: wana-kondoo wawili wenye umri wa mwaka mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Utamtoa mmoja asubuhi na huyo mwingine jioni. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pamoja na mwana-kondoo wa kwanza utatoa efa moja ya unga wa ngano laini uliochanganywa na robo ya hini ya mafuta yaliyokamuliwa, pamoja na robo ya hini ya divai kuwa sadaka ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Huyo mwana-kondoo mwingine mtoe dhabihu wakati wa machweo pamoja na sadaka za unga na za kinywaji kama vile ulivyofanya asubuhi, kuwa harufu ya kupendeza, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Kwa vizazi vijavyo itakuwa kawaida kutoa sadaka hii ya kuteketezwa kila mara kwenye ingilio la Hema la Kukutania mbele za Mwenyezi Mungu. Hapo ndipo nitakapokutana na ninyi na kusema nanyi, ");
INSERT INTO swhonmm_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Huko ndipo nitakapokutana na Waisraeli, nalo Hema la Kukutania litatakaswa na utukufu wangu. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Kwa hiyo nitaliweka wakfu Hema la Kukutania pamoja na madhabahu, nami nitamweka wakfu Haruni na wanawe ili wanitumikie mimi katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ndipo nitakapofanya makao miongoni mwa Waisraeli na kuwa Mungu wao. ");
INSERT INTO swhonmm_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Nao watajua kuwa Mimi Ndimi Mwenyezi Mungu, Mungu wao, aliyewatoa Misri ili nipate kufanya makao miongoni mwao. Mimi Ndimi Mwenyezi Mungu, Mungu wao. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Tengeneza madhabahu kwa mbao za mshita kwa ajili ya kufukizia uvumba. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Madhabahu hayo yawe mraba, urefu na upana wake dhiraa moja, na kimo cha dhiraa mbili, nazo pembe zake zitakuwa kitu kimoja nayo. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Funika hayo madhabahu juu na pande zote na pia pembe zake kwa dhahabu safi, na uifanyizie ukingo wa dhahabu kuizunguka. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tengeneza pete mbili za dhahabu kwa ajili ya madhabahu chini ya huo ukingo, ziwe mbili kila upande, za kushikilia hiyo mipiko itumikayo kuibebea madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tengeneza mipiko kwa miti ya mshita na uifunike kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Weka hayo madhabahu mbele ya lile pazia lililo mbele ya Sanduku la ule Ushuhuda, lililo mbele ya kiti cha rehema kilicho juu ya ule Ushuhuda, mahali nitakapokutana nawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Itampasa Haruni kufukiza uvumba wenye harufu nzuri juu ya madhabahu kila siku asubuhi wakati anapowasha zile taa. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Itampasa afukize uvumba tena wakati anapowasha taa wakati wa machweo ili uvumba ufukizwe daima mbele za Mwenyezi Mungu kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Usifukize uvumba mwingine wowote juu ya madhabahu haya au sadaka nyingine yoyote ya kuteketezwa wala sadaka ya nafaka, wala usimimine sadaka ya kinywaji juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mara moja kwa mwaka Haruni atafanya upatanisho juu ya pembe za hayo madhabahu. Upatanisho huu wa mwaka lazima ufanywe kwa damu ya sadaka ya upatanisho kwa ajili ya dhambi kwa vizazi vijavyo. Ni takatifu sana kwa Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Naye Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Utakapowahesabu Waisraeli, kila mmoja lazima alipe kwa Mwenyezi Mungu fidia kwa ajili ya nafsi yake wakati wa kuhesabiwa kwake. Ndipo hakutakuwa na pigo juu yao unapowahesabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kila mmoja anayeenda upande wa wale waliokwisha hesabiwa atatoa nusu shekeli, kulingana na shekeli ya mahali patakatifu, ambayo ina uzito wa gera ishirini. Hii nusu shekeli ni sadaka kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wote wanaovuka, wenye umri wa miaka ishirini au zaidi, watatoa sadaka kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Matajiri hawatalipa zaidi ya nusu shekeli, nao maskini hawatatoa pungufu wakati mnatoa sadaka kwa Mwenyezi Mungu kwa kufanya upatanisho wa nafsi zenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Utapokea fedha ya upatanisho kutoka kwa Waisraeli na uzitumie kwa ajili ya huduma ya Hema la Kukutania. Itakuwa ni ukumbusho kwa Waisraeli mbele za Mwenyezi Mungu kufanya upatanisho kwa ajili ya nafsi zenu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kisha Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tengeneza sinia la shaba lenye kitako cha shaba kwa ajili ya kunawia. Liweke kati ya Hema la Kukutania na madhabahu, kisha uweke maji ndani yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruni na wanawe watanawa mikono na miguu yao kwa maji ya hilo sinia. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wakati wowote wanapoingia katika Hema la Kukutania, watanawa kwa maji ili wasije wakafa. Pia, wanapokaribia madhabahu ili kuhudumu kwa kuleta sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","watanawa mikono na miguu yao ili wasije wakafa. Hili litakuwa agizo la kudumu kwa Haruni na wazao wake kwa vizazi vijavyo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kisha Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Chukua vikolezo bora vifuatavyo: shekeli mia tano za manemane ya maji, shekeli mia mbili na hamsini za mdalasini wenye harufu nzuri, shekeli mia mbili na hamsini za miwa yenye harufu nzuri, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","shekeli mia tano za aina nyingine ya mdalasini, vyote kulingana na shekeli ya mahali patakatifu, pia hini ya mafuta ya zeituni. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Vitengeneze vikolezo hivi kuwa mafuta matakatifu ya upako yenye harufu nzuri, kazi ya mtengeneza manukato. Yatakuwa mafuta matakatifu ya upako. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kisha yatumie kupaka hilo Hema la Kukutania, Sanduku la Ushuhuda, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meza na vifaa vyake vyote, kinara cha taa na vifaa vyake vyote, madhabahu ya kufukizia uvumba, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","madhabahu ya sadaka ya kuteketezwa na vyombo vyake vyote na sinia pamoja na kitako chake. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Utaviweka wakfu ili viwe vitakatifu sana na kila kitakachoigusa kitakuwa kitakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Mpake Haruni na wanawe mafuta na uwaweke wakfu ili waweze kunitumikia katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Waambie Waisraeli, ‘Haya yatakuwa mafuta matakatifu yangu ya upako kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Usiyamimine juu ya miili ya wanadamu wala usitengeneze mafuta ya aina nyingine kwa utaratibu huu. Ni mafuta matakatifu na ni lazima myaone kuwa ni matakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mtu yeyote atakayetengeneza manukato kama hayo na kuyamimina juu ya mtu ambaye si kuhani atakatiliwa mbali na watu wake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kisha Mwenyezi Mungu akamwambia Musa, “Chukua vikolezo vyenye harufu nzuri vifuatavyo: natafi, shekelethi, kelbena na uvumba safi vyote vikiwa na vipimo sawa, ");
INSERT INTO swhonmm_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","pia tengeneza mchanganyiko wa uvumba wenye harufu nzuri, kazi ya mtengeneza manukato. Utiwe chumvi ili upate kuwa safi na mtakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Saga baadhi yake kuwa unga na uweke mbele ya Sanduku la Ushuhuda ndani ya Hema la Kukutania, mahali nitakapokutana nawe. Itakuwa takatifu sana kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Msitengeneze uvumba mwingine wowote wa namna hii kwa ajili yenu wenyewe; uoneni kuwa ni mtakatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Yeyote atakayetengeneza uvumba kama huu ili kufurahia harufu yake nzuri lazima akatiliwe mbali na watu wake.” ");
INSERT INTO swhonmm_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ndipo Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tazama, nimemchagua Bezaleli mwana wa Uri, mwana wa Huri, wa kabila la Yuda, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","nami nimemjaza Roho wa Mungu, pamoja na ustadi, uwezo na ujuzi katika aina zote za ufundi, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ili kubuni michoro ya kupendeza katika ufundi wa dhahabu, fedha na shaba, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kuchonga vito na kuvitia mahali, kufanya ufundi kwa mbao, na kujishughulisha na aina zote za ufundi. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tena nimemteua Oholiabu mwana wa Ahisamaki, wa kabila la Dani, ili kumsaidia. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Hema la Kukutania, Sanduku la Ushuhuda pamoja na kiti cha rehema juu yake, pia na vifaa vyote vya kwenye hema: ");
INSERT INTO swhonmm_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meza na vifaa vyake, kinara cha taa cha dhahabu safi na vifaa vyake vyote, madhabahu ya kufukizia uvumba, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","madhabahu ya sadaka ya kuteketezwa na vyombo vyake vyote, sinia na kinara chake, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pamoja na mavazi matakatifu yaliyofumwa ya kuhani Haruni, na mavazi kwa ajili ya wanawe wakati wanahudumu katika kazi ya ukuhani, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","pia mafuta ya upako na uvumba wenye harufu nzuri kwa ajili ya Mahali Patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kisha Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Waambie Waisraeli, ‘Ninyi ni lazima mzishike Sabato zangu. Hii itakuwa ni ishara kati yangu na ninyi kwa vizazi vijavyo, ili mpate kujua kwamba Mimi Ndimi Mwenyezi Mungu, niwafanyaye ninyi watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Mtaishika Sabato, kwa sababu ni takatifu kwenu. Yeyote atakayeinajisi lazima auawe, yeyote atakayefanya kazi siku hiyo lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kwa siku sita, mtafanya kazi, lakini siku ya saba ni Sabato ya mapumziko, takatifu kwa Mwenyezi Mungu. Yeyote afanyaye kazi yoyote siku ya Sabato ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Waisraeli wataishika Sabato, kuiadhimisha kwa vizazi vijavyo kuwa agano la milele. ");
INSERT INTO swhonmm_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Itakuwa ishara kati yangu na Waisraeli milele, kwa kuwa kwa muda wa siku sita Mwenyezi Mungu aliumba mbingu na dunia, akapumzika siku ya saba, akastarehe.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mwenyezi Mungu alipomaliza kusema na Musa juu ya Mlima Sinai, Mungu akampa vile vibao viwili vya Ushuhuda, vibao vya mawe vilivyoandikwa kwa kidole cha Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Watu walipoona kuwa Musa amekawia sana kushuka kutoka mlimani, walimsonga Haruni na kumwambia, “Njoo, tutengenezee miungu itakayotutangulia. Kwa maana huyu jamaa yetu Musa aliyetupandisha kutoka Misri, hatujui yaliyompata.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruni akawajibu, “Vueni vipuli vya dhahabu ambavyo wake zenu, wana wenu, na binti zenu wamevaa, mkaniletee.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kwa hiyo watu wote wakavua vipuli vyao, wakavileta kwa Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Akavichukua vile vitu walivyomkabidhi, akasubu sanamu yenye umbo la ndama, akaichonga kwa kutumia chombo. Kisha wakasema, “Hii ndiyo miungu yenu, ee Israeli, iliyowapandisha kutoka Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruni alipoona hili, akajenga madhabahu mbele ya yule ndama na kutangaza, “Kesho kutakuwa na sikukuu kwa Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kwa hiyo siku iliyofuata watu wakaamka asubuhi na mapema na kutoa sadaka za kuteketeza na sadaka za amani. Baadaye watu wakaketi kula na kunywa, nao wakasimama, wakajizamisha katika sherehe. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kisha Mwenyezi Mungu akamwambia Musa, “Shuka, kwa sababu watu wako, uliowatoa Misri, wamepotoka. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wamekuwa wepesi kugeuka na kuacha niliyowaamuru, na wamejitengenezea sanamu ya kusubu yenye umbo la ndama. Wameisujudia na kuitolea dhabihu, nao wamesema, ‘Hii ndiyo miungu yenu, ee Israeli iliyokupandisha kutoka Misri.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mwenyezi Mungu akamwambia Musa, “Nimeona watu hawa, nao ni watu wenye shingo ngumu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sasa niache ili hasira yangu ipate kuwaka dhidi yao, nami nipate kuwaangamiza. Kisha nitakufanya wewe kuwa taifa kubwa.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lakini Musa akamsihi Mwenyezi Mungu, Mungu wake, akasema, “Ee Mwenyezi Mungu, kwa nini hasira yako iwake dhidi ya watu wako, wale uliowatoa Misri kwa uweza mkuu na mkono wenye nguvu? ");
INSERT INTO swhonmm_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kwa nini Wamisri waseme, ‘Ni kwa nia mbaya aliwatoa Misri, ili awaue milimani na kuwafuta usoni mwa dunia’? Achilia mbali hasira yako kali, waonee huruma na usilete maafa juu ya watu wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wakumbuke watumishi wako Ibrahimu, Isaka na Israeli, ambao uliwaapia kwa nafsi yako mwenyewe: ‘Nitawafanya uzao wako kuwa wengi kama nyota za angani, nami nitawapa wazao wako nchi hii yote niliyowaahidia, nayo itakuwa urithi wao milele.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kisha Mwenyezi Mungu akawaonea huruma, wala hakuleta juu ya watu wake maafa aliyokuwa amekusudia. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa akageuka, akateremka kutoka mlimani akiwa na vile vibao viwili vya Ushuhuda mikononi mwake. Vilikuwa vimeandikwa pande zote mbili, mbele na nyuma. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Vibao hivyo vilikuwa kazi ya Mungu; maandishi yalikuwa mwandiko wa Mungu, yaliyochorwa kama muhuri juu ya vibao. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua aliposikia sauti za watu wakipiga kelele, akamwambia Musa, “Kuna sauti ya vita kambini.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa akajibu: “Si sauti ya ushindi, wala si sauti ya kushindwa; ni sauti ya kuimba ninayosikia.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa alipoikaribia kambi na kuona yule ndama na ile michezo, hasira yake ikawaka, akatupa vile vibao vilivyokuwa mikononi mwake, akavipasua vipande vipande pale chini ya mlima. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kisha akamchukua yule ndama waliokuwa wamemtengeneza na kumchoma kwenye moto, kisha akamsaga kuwa unga, akanyunyiza kwenye maji na kuwafanya Waisraeli wanywe. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa akamwambia Haruni, “Watu hawa walikufanyia nini, hata ukawaongoza kufanya dhambi kubwa hivyo?” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruni akamwambia, “Usikasirike bwana wangu. Unajua jinsi watu hawa walivyo tayari kwa maovu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Waliniambia, ‘Tufanyie miungu itakayotuongoza. Kwa kuwa huyu jamaa yetu Musa aliyetupandisha kutoka Misri, hatujui yaliyompata.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kwa hiyo nikawaambia, ‘Yeyote aliye na kito chochote cha dhahabu avue.’ Kisha wakanipa hiyo dhahabu, nami nikaitupa motoni, akatokea huyu ndama!” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa akaona kuwa watu wameasi, kwa kuwa Haruni alikuwa amewaacha waasi, na hivyo kuwa kichekesho kwa adui zao. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kwa hiyo Musa akasimama kwenye ingilio la kambi, akasema, “Yeyote aliye upande wa Mwenyezi Mungu, aje upande wangu.” Walawi wote wakamjia. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ndipo alipowaambia, “Hili ndilo Mwenyezi Mungu, Mungu wa Israeli, asemalo: ‘Kila mmoja wenu ajifunge upanga wake kiunoni aende huku na huko kambi yote mwisho hadi mwisho mwingine, kila mmoja amuue ndugu yake, na rafiki yake na jirani yake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Walawi wakafanya kama Musa alivyoamuru, siku ile wakafa watu wapatao elfu tatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kisha Musa akasema, “Leo mmewekwa wakfu kwa Mwenyezi Mungu, kwa kuwa mlikuwa kinyume na wana wenu wenyewe na ndugu zenu, naye Mungu amewabariki leo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Siku iliyofuata Musa akawaambia watu, “Mmefanya dhambi kubwa. Lakini sasa nitapanda juu kwa Mwenyezi Mungu, labda nitaweza kufanya upatanisho kwa ajili ya dhambi yenu.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Hivyo Musa akarudi kwa Mwenyezi Mungu na kumwambia, “Lo! Hawa watu wamefanya dhambi kubwa namna gani! Wamejitengenezea miungu ya dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Lakini sasa nakusihi, wasamehe dhambi yao; lakini kama sivyo, basi nifute kutoka kitabu ulichoandika.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mwenyezi Mungu akamjibu Musa, “Yeyote aliyenitenda dhambi ndiye nitakayemfuta kutoka kitabu changu. ");
INSERT INTO swhonmm_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sasa nenda, uongoze hao watu hadi mahali nilipokuambia, naye malaika wangu atakutangulia. Pamoja na hayo, wakati utakapofika wa mimi kuwaadhibu, nitawaadhibu kwa ajili ya dhambi yao.” ");
INSERT INTO swhonmm_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ndipo Mwenyezi Mungu akawapiga watu kwa ugonjwa wa tauni kwa sababu ya yale waliyoyafanya na ndama yule ambaye alitengenezwa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kisha Mwenyezi Mungu akamwambia Musa, “Ondoka mahali hapa, wewe pamoja na hao watu uliowapandisha kutoka Misri, mpande hadi nchi niliyomwahidi Ibrahimu, Isaka na Yakobo kwa kiapo, nikisema, ‘Nitawapa wazao wenu nchi hii.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nitamtuma malaika mbele yenu, naye atawafukuza Wakanaani, Waamori, Wahiti, Waperizi, Wahivi na Wayebusi. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pandeni mwende katika nchi inayotiririka maziwa na asali. Lakini mimi sitaenda pamoja nanyi, kwa sababu ninyi ni watu wenye shingo ngumu, nisije nikawaangamiza njiani.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Watu waliposikia habari hizo za huzuni, wakaanza kuomboleza wala hakuna mtu aliyevaa mapambo yoyote. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kwa kuwa Mwenyezi Mungu alikuwa amemwambia Musa, “Waambie Waisraeli, ‘Ninyi ni watu wenye shingo ngumu. Kama ningefuatana nanyi hata kwa muda mfupi, ningewaangamiza. Sasa vueni mapambo yenu, nami nitaamua nitakalowatendea.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Hivyo Waisraeli wakavua mapambo yao katika Mlima Horebu. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Basi Musa alikuwa na desturi ya kuchukua hema na kuliweka wakfu nje ya kambi umbali kiasi, akaliita “Hema la Kukutania”. Kila aliyekuwa akiulizia shauri kwa Mwenyezi Mungu, angeenda hadi Hema la Kukutania, nje ya kambi. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Wakati wowote Musa alipoenda kwenye Hema, watu wote waliinuka na kusimama kwenye maingilio ya mahema yao, wakimwangalia Musa hadi aingie kwenye Hema. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kila mara Musa alipoingia ndani ya Hema, nguzo ya wingu ingeshuka chini na kukaa kwenye ingilio, wakati Mwenyezi Mungu akizungumza na Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kila mara watu walipoona hiyo nguzo ya wingu ikiwa imesimama kwenye ingilio la Hema, wote walisimama wakaabudu, kila mmoja kwenye ingilio la hema lake. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mwenyezi Mungu angezungumza na Musa uso kwa uso, kama vile mtu anavyozungumza na rafiki yake. Kisha Musa angerudi kambini, lakini msaidizi wake kijana Yoshua mwana wa Nuni hakuondoka kwenye Hema. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa akamwambia Mwenyezi Mungu, “Umekuwa ukiniambia, ‘Ongoza watu hawa,’ lakini hujanifahamisha ni nani utakayemtuma pamoja nami. Umesema, ‘Ninakujua wewe kwa jina lako, nawe umepata kibali mbele zangu.’ ");
INSERT INTO swhonmm_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ikiwa umependezwa nami, nifundishe njia zako ili nipate kukujua, nami nizidi kupata kibali mbele zako. Kumbuka kuwa taifa hili ni watu wako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mwenyezi Mungu akajibu, “Uso wangu utaenda pamoja nawe, nami nitakupa raha.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kisha Musa akamwambia, “Kama Uso wako hauendi pamoja nasi, usituondoe hapa. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mtu yeyote atajuaje kuwa mimi pamoja na watu wako tumepata kibali mbele zako, usipoenda pamoja nasi? Ni nini kingine kitakachoweza kututofautisha mimi na watu wako miongoni mwa watu wengine wote walio katika uso wa dunia?” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mwenyezi Mungu akamwambia Musa, “Nitakufanyia jambo lile uliloomba, kwa sababu ninapendezwa nawe, nami ninakujua kwa jina lako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kisha Musa akasema, “Basi nioneshe utukufu wako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ndipo Mwenyezi Mungu akasema, “Nitapitisha wema wangu wote mbele yako, nami nitalitangaza Jina langu, Mwenyezi Mungu, mbele ya uso wako. Nitamrehemu yeye nimrehemuye, na pia nitamhurumia yeye nimhurumiaye.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Lakini Mungu akasema, “Hutaweza kuuona uso wangu, kwa kuwa hakuna mtu yeyote awezaye kuniona akaishi.” ");
INSERT INTO swhonmm_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kisha Mwenyezi Mungu akasema, “Kuna mahali karibu nami ambapo unaweza kusimama juu ya mwamba. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Utukufu wangu unapopita, nitakuweka gengeni kwenye mwamba, na kukufunika kwa mkono wangu hadi nitakapokuwa nimepita. ");
INSERT INTO swhonmm_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kisha nitaondoa mkono wangu nawe utaona mgongo wangu; lakini kamwe uso wangu hautaonekana.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mwenyezi Mungu akamwambia Musa, “Chonga vibao viwili vya mawe kama vile vya kwanza, nami nitaandika juu yake maneno yale yaliyokuwa kwenye vile vibao vya kwanza, ulivyovivunja. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Uwe tayari asubuhi, kisha upande juu ya Mlima Sinai. Uje mbele zangu kukutana nami huko juu ya mlima. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mtu yeyote asije nawe, wala asionekane mtu popote mlimani; wala kondoo na mbuzi au ng’ombe wasilishe mbele ya huo mlima.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kwa hiyo Musa akachonga vibao viwili vya mawe kama vile vya kwanza, naye akapanda juu ya Mlima Sinai asubuhi na mapema, kama Mwenyezi Mungu alivyokuwa amemwagiza, akachukua vile vibao viwili vya mawe mikononi mwake. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kisha Mwenyezi Mungu akashuka katika wingu akasimama pamoja naye huko, akalitangaza jina lake, Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mwenyezi Mungu akapita mbele ya Musa, akitangaza, “Mwenyezi Mungu, Mwenyezi Mungu, Mungu mwenye huruma na neema, asiye mwepesi wa hasira, mwingi wa upendo na uaminifu, ");
INSERT INTO swhonmm_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","akidumisha upendo kwa maelfu, pia akisamehe uovu, uasi na dhambi. Lakini haachi kuadhibu mwenye hatia; huwaadhibu watoto na watoto wao kwa ajili ya dhambi ya baba zao hata katika kizazi cha tatu na cha nne.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mara Musa akasujudu na kuabudu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Musa akasema, “Ee Bwana, kama nimepata kibali mbele zako, basi Bwana uende pamoja nasi. Ingawa watu hawa ni wenye shingo ngumu, samehe uovu wetu na dhambi yetu, tuchukue kuwa urithi wako.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kisha Mwenyezi Mungu akasema: “Tazama, ninafanya agano nanyi. Mbele ya watu wako wote nitafanya maajabu ambayo hayajafanyika katika taifa lolote katika ulimwengu wote. Watu wale mnaoishi miongoni mwao wataona jinsi ilivyo ya kushangaza kazi nitakayowafanyia Mimi, Mwenyezi Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tii yale ninayokuamuru leo. Tazama nawafukuza mbele yako Waamori, Wakanaani, Wahiti, Waperizi, Wahivi na Wayebusi. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Uwe mwangalifu, usifanye agano na wale wanaokaa katika nchi ile unayoiendea, la sivyo watakuwa mtego katikati yako. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Bomoa madhabahu yao, vunja mawe yao ya kuabudia, na ukatekate nguzo zao za Ashera. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Usiabudu mungu mwingine, kwa kuwa Mwenyezi Mungu, ambaye jina lake ni Wivu, ni Mungu mwenye wivu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Uwe mwangalifu usifanye agano na wale watu wanaoishi katika nchi, kwa maana wakati wanapojifanyia ukahaba kwa miungu yao na kuwatolea kafara, watakualika wewe, nawe utakula sadaka za matambiko yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Unapowachagua baadhi ya binti zao kuwa wake wa wana wenu na binti hao wakajifanyia ukahaba kwa miungu yao, watawaongoza wana wenu kufanya vivyo hivyo. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Usijifanyie sanamu za kusubu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Utaadhimisha Sikukuu ya Mikate Isiyotiwa Chachu. Kwa siku saba mtakula mikate isiyotiwa chachu, kama nilivyokuamuru. Fanya hivi kwa wakati ulioamriwa, katika mwezi wa Abibu, ndio mwezi wa nne, kwa kuwa katika mwezi huo ndipo wewe ulipotoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Mzaliwa wa kwanza wa kila tumbo ni mali yangu, pamoja na wazaliwa wa kwanza wote wa kiume wa mifugo yako, ikiwa ni wa ng’ombe au wa kondoo au mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Utakomboa mzaliwa wa kwanza wa punda kwa mwana-kondoo, lakini kama humkomboi, utavunja shingo yake. Utakomboa wazaliwa wako wa kwanza wote wa kiume. “Mtu yeyote asije mbele zangu mikono mitupu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kwa siku sita utafanya kazi, lakini siku ya saba utapumzika, hata ikiwa ni majira ya kulima au ya kuvuna lazima upumzike. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Utaadhimisha Sikukuu ya Majuma kwa malimbuko ya mavuno ya ngano, na Sikukuu ya Mavuno mwishoni mwa mwaka. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mara tatu kwa mwaka wanaume wako wote watakuja mbele za Bwana Mungu Mwenyezi, Mungu wa Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nitawafukuza mataifa mbele yako na kupanua mipaka ya nchi yako, wala hakuna mtu yeyote atakayeitamani nchi yako wakati unapoenda mara tatu kila mwaka kuonana na Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Usinitolee damu ya dhabihu pamoja na kitu chochote chenye chachu, wala usibakize dhabihu yoyote ya Sikukuu ya Pasaka hadi asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Leta matunda ya kwanza yaliyo bora zaidi ya ardhi yako katika nyumba ya Mwenyezi Mungu, Mungu wako. “Usimchemshe mwana-mbuzi katika maziwa ya mama yake.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kisha Mwenyezi Mungu akamwambia Musa, “Andika maneno haya, kwa maana kulingana na maneno haya, nimefanya agano na wewe pamoja na Israeli.” ");
INSERT INTO swhonmm_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa alikuwa huko pamoja na Mwenyezi Mungu kwa siku arobaini usiku na mchana bila kula chakula wala kunywa maji. Naye akaandika juu ya vibao maneno ya agano, yaani zile Amri Kumi. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa alipoteremka kutoka Mlima Sinai akiwa na vile vibao viwili vya Ushuhuda mikononi mwake, hakujua kuwa uso wake ulikuwa uking’aa, kwa sababu alikuwa amezungumza na Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruni na Waisraeli wote walipomwona Musa, kuwa uso wake unang’aa, waliogopa kumkaribia. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lakini Musa akawaita, kwa hiyo Haruni na viongozi wote wa jumuiya wakarudi, naye akazungumza nao. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Baadaye Waisraeli wote wakamkaribia, naye akawapa amri zote Mwenyezi Mungu alizompa katika Mlima Sinai. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa alipomaliza kuzungumza nao, akaweka utaji kwenye uso wake. ");
INSERT INTO swhonmm_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Lakini kila wakati Musa alipoingia mbele za Mwenyezi Mungu kuzungumza naye, aliondoa ule utaji hadi alipotoka nje. Naye alipotoka nje na kuwaambia Waisraeli lile ambalo ameagizwa, ");
INSERT INTO swhonmm_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","waliona kuwa uso wake unang’aa. Kisha Musa angerudisha utaji juu ya uso wake hadi alipoingia ili kuzungumza na Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa akakusanya jumuiya yote ya Waisraeli na kuwaambia, “Haya ndio mambo ambayo Mwenyezi Mungu amewaamuru ninyi mfanye: ");
INSERT INTO swhonmm_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kwa siku sita, mtafanya kazi, lakini siku ya saba itakuwa takatifu kwenu, Sabato ya mapumziko kwa Mwenyezi Mungu. Yeyote atakayefanya kazi yoyote siku hiyo ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Msiwashe moto mahali popote katika makazi yenu siku ya Sabato.” ");
INSERT INTO swhonmm_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa akaiambia jumuiya yote ya Waisraeli, “Hili ndilo Mwenyezi Mungu aliloamuru: ");
INSERT INTO swhonmm_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Toeni sadaka kwa Mwenyezi Mungu kutoka mali mliyo nayo. Kila mmoja aliye na moyo wa kupenda atamletea Mwenyezi Mungu sadaka ya: “dhahabu, fedha na shaba; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nyuzi za rangi ya buluu, za zambarau, za rangi nyekundu na kitani safi; singa za mbuzi; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ngozi za kondoo dume zilizopakwa rangi nyekundu, na ngozi za pomboo; mbao za mshita; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta ya zeituni kwa ajili ya taa; vikolezo kwa ajili ya mafuta ya upako, pamoja na uvumba wa harufu nzuri; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","vito vya shohamu, na vito vingine vya thamani vya kuweka kwenye kizibau na kile kifuko cha kifuani. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Wote wenye ujuzi miongoni mwenu inawapasa kuja na kutengeneza kila kitu Mwenyezi Mungu alichoamuru: ");
INSERT INTO swhonmm_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Maskani ya Mungu pamoja na hema lake na kifuniko chake, vibanio, mihimili, mataruma, nguzo na vitako; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Sanduku la Agano pamoja na mipiko yake, kifuniko cha kiti cha rehema na pazia linalokizuia; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meza na mipiko yake, pamoja na vyombo vyake vyote, mikate ya Wonesho; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kinara cha taa kwa ajili ya mwanga pamoja na vifaa vyake vyote, taa na mafuta kwa ajili ya mwanga; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","madhabahu ya kufukiza uvumba pamoja na mipiko yake, mafuta ya upako na uvumba wenye harufu nzuri; pazia la mlangoni mahali pa kuingilia ndani ya Maskani; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","madhabahu ya sadaka za kuteketeza pamoja na wavu wake wa shaba, mipiko yake pamoja na vyombo vyake vyote; sinia la shaba pamoja na tako lake; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","pazia la eneo la ua pamoja na nguzo zake na vitako vyake, na pazia la ingilio la ua; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","vigingi vya hema kwa ajili ya Maskani pamoja na ua na kamba zake; ");
INSERT INTO swhonmm_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","mavazi yaliyofumwa yanayovaliwa wakati wa huduma katika mahali patakatifu, yaani mavazi matakatifu kwa ajili ya kuhani Haruni, na mavazi kwa ajili ya wanawe watakapokuwa wakihudumu katika kazi ya ukuhani.” ");
INSERT INTO swhonmm_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ndipo jumuiya yote ya Waisraeli ilipoondoka mbele ya Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","na kila mmoja aliyependa na ambaye moyo wake ulimsukuma alikuja na kuleta sadaka kwa Mwenyezi Mungu, kwa ajili ya kazi katika Hema la Kukutania, kwa ajili ya huduma yake yote na kwa ajili ya mavazi matakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Wote waliopenda, wanaume na wanawake, wakaja wakaleta vito vya dhahabu vya kila aina: vipini, vipuli, pete na mapambo. Wote wakatoa dhahabu zao kuwa sadaka ya kuinuliwa kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kila mmoja aliyekuwa na nyuzi za rangi ya buluu, za zambarau, au za rangi nyekundu au kitani safi, au singa za mbuzi, ngozi za kondoo dume zilizotiwa rangi nyekundu, au ngozi za pomboo, wakavileta. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Wale waliotoa sadaka ya fedha au shaba wakavileta kama sadaka kwa Mwenyezi Mungu, na kila aliyekuwa na mti wa mshita kwa ajili ya kazi yoyote ile akauleta. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kila mwanamke aliyekuwa na ujuzi alisokota kwa mikono yake na alileta kile alichosokota, iwe ni nyuzi za rangi ya buluu, za zambarau, au za rangi nyekundu au kitani safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Wanawake wote waliopenda na waliokuwa na ujuzi wakasokota singa za mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Viongozi wakaleta vito vya shohamu pamoja na vito vingine vya thamani kwa ajili ya kuweka kwenye kizibau na kwenye kifuko cha kifuani. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wakaleta pia vikolezo na mafuta ya zeituni kwa ajili ya mwanga, kwa ajili ya mafuta ya upako na kwa ajili ya uvumba wenye harufu nzuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Waisraeli wote, wanaume na wanawake, waliopenda wakaleta mbele za Mwenyezi Mungu kwa hiari yao wenyewe sadaka kwa ajili ya kazi yote ya Mwenyezi Mungu aliyokuwa amewaagiza kuifanya kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kisha Musa akawaambia Waisraeli, “Tazameni, Mwenyezi Mungu amemchagua Bezaleli mwana wa Uri, mwana wa Huri, wa kabila la Yuda, ");
INSERT INTO swhonmm_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","naye amemjaza Roho wa Mungu, pamoja na ustadi, na uwezo na ujuzi katika aina zote za ufundi, ");
INSERT INTO swhonmm_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ili kubuni michoro ya kupendeza katika ufundi wa dhahabu, fedha na shaba, ");
INSERT INTO swhonmm_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kuchonga vito na kuvitia mahali, kufanya ufundi kwa mbao, na kujishughulisha na aina zote za ufundi wa kupendeza. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Tena amempa yeye pamoja na Oholiabu, mwana wa Ahisamaki, wa kabila la Dani, uwezo wa kufundisha wengine. ");
INSERT INTO swhonmm_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Amewajaza ustadi wa kufanya kazi za aina zote zinazofanywa na mafundi, na wenye kubuni michoro, pia na watarizi kwa rangi za buluu, zambarau, nyekundu na kitani safi, na wafumaji: wote wakiwa mafundi na wabunifu hodari. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kwa hiyo Bezaleli, Oholiabu na kila mtu Mwenyezi Mungu aliyempa ustadi na uwezo wa kujua jinsi ya kufanya kazi zote za kujenga mahali patakatifu wataifanya hiyo kazi kama vile Mwenyezi Mungu alivyoagiza.” ");
INSERT INTO swhonmm_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ndipo Musa akawaita Bezaleli na Oholiabu na kila mtu mwenye ustadi ambaye Mwenyezi Mungu alikuwa amempa uwezo na mwenye kupenda kuja na kufanya kazi. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wakapokea kutoka kwa Musa sadaka zote ambazo Waisraeli walikuwa wameleta ili kuifanya kazi ya ujenzi wa Mahali Patakatifu. Nao watu wakaendelea kuleta sadaka za hiari kila asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ikafika wakati mafundi wote wenye ujuzi waliokuwa wakiifanya kazi yote ya mahali patakatifu wakasimamisha kazi zao, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","wakaja na kumwambia Musa, “Watu wanaleta vitu vingi kuliko tunavyohitaji kwa ajili ya kazi hii ambayo Mwenyezi Mungu ameagiza ifanyike.” ");
INSERT INTO swhonmm_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ndipo Musa akatoa agizo, nao wakapeleka neno hili katika kambi yote: “Mwanaume au mwanamke yeyote asilete tena kitu chochote kwa ajili ya sadaka ya mahali patakatifu.” Hivyo watu wakazuiliwa kuleta zaidi, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kwa sababu walivyokuwa navyo tayari vilitosha na kuzidi kuifanya kazi yote. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Watu wote wenye ustadi miongoni mwa wafanyakazi wote wakatengeneza maskani ya Mungu kwa mapazia kumi ya kitani iliyosokotwa vizuri, na nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu, naye fundi stadi akatirizi makerubi kwenye mapazia hayo. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mapazia yote yalitoshana kwa ukubwa: kila moja lilikuwa na urefu wa dhiraa ishirini na nane, na upana wa dhiraa nne. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Wakayaunganisha mapazia matano pamoja, pia wakafanya vivyo hivyo kwa hayo mengine matano. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kisha wakatengeneza vitanzi vya kitambaa cha buluu kwenye upindo wa pazia la mwisho la fungu la kwanza, pia wakafanya vivyo hivyo na pazia la fungu la mwisho. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Wakatengeneza pia vitanzi hamsini katika pazia mmoja, na vitanzi vingine hamsini kwenye pazia la mwisho la fungu hilo lingine, navyo vitanzi vyote vikaelekeana. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Kisha wakatengeneza vifungo hamsini vya dhahabu, na wakavitumia kufunga na kuunganisha zile fungu mbili za mapazia pamoja ili maskani ya Mungu ipate kuwa kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Wakatengeneza mapazia kumi na moja ya singa za mbuzi kwa ajili ya kufunika Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Mapazia hayo kumi na moja yalikuwa na kipimo sawa, yaani urefu wa dhiraa thelathini, na upana wa dhiraa nne. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Wakaunganisha mapazia matano kuwa fungu moja, na hayo mengine sita kuwa fungu lingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Kisha wakatengeneza vitanzi hamsini kwenye upindo wa pazia la mwisho la fungu moja, na vivyo hivyo kwenye upindo wa pazia la mwisho la fungu hilo lingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Wakatengeneza vifungo hamsini vya shaba ili kukaza hema pamoja kuwa kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kisha wakatengeneza kifuniko cha hema kwa ngozi za kondoo dume zilizotiwa rangi nyekundu, na juu yake kifuniko cha ngozi za pomboo. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wakatengeneza mihimili ya kusimamisha ya mti wa mshita kwa ajili ya maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kila mhimili ulikuwa na urefu wa dhiraa kumi, na upana wa dhiraa moja na nusu, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","zikiwa na ndimi mbili zilizokuwa sambamba kila mmoja na mwingine. Wakatengeneza mihimili yote ya Maskani jinsi hii. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Wakatengeneza mihimili ishirini kwa ajili ya upande wa kusini wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na wakatengeneza vitako arobaini vya fedha vya kuweka chini ya hiyo mihimili, vitako viwili kwa kila mhimili, kimoja chini ya kila ulimi. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kwa upande wa kaskazini wa Maskani wakatengeneza mihimili ishirini ");
INSERT INTO swhonmm_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vitako arobaini vya fedha, viwili chini ya kila mhimili. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Wakatengeneza mihimili sita kwa mwisho ulio mbali, yaani upande wa magharibi wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","na mihimili miwili ikatengenezwa kwa ajili ya pembe za Maskani za upande uliokuwa mbali. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Katika pembe hizi mbili mihimili yake ilikuwa miwili kuanzia chini hadi juu, na ikaingizwa kwenye pete moja; mihimili ya pembe hizi mbili ilifanana. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kwa hiyo kulikuwa na mihimili nane, na vitako kumi na sita vya fedha, viwili chini ya kila mhimili. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Wakatengeneza pia mataruma kwa mti wa mshita: matano kwa ajili ya mihimili ya upande mmoja wa Maskani, ");
INSERT INTO swhonmm_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","matano kwa ajili ya mihimili ya upande mwingine, na matano kwa ajili mihimili ya upande wa magharibi, mwisho kabisa mwa Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wakatengeneza taruma la katikati, likapenya katikati ya mihimili kutoka mwisho mmoja hadi mwisho mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Wakaifunika hiyo mihimili kwa dhahabu, na wakatengeneza pete za dhahabu za kushikilia hayo mataruma. Pia wakayafunika hayo mataruma kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wakatengeneza pazia la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu na kitani safi iliyosokotwa vizuri, naye fundi stadi akatirizi makerubi kwenye hilo pazia. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Wakatengeneza nguzo nne za mti wa mshita kwa ajili yake na kuzifunika kwa dhahabu. Wakatengeneza kulabu za dhahabu kwa ajili ya nguzo hizo, na kusubu vitako vinne vya fedha. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kwa ajili ya ingilio la hema wakatengeneza pazia la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu na kitani safi iliyosokotwa vizuri, kazi ya mtarizi. ");
INSERT INTO swhonmm_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Pia wakatengeneza nguzo tano zenye kulabu. Wakafunika ncha za juu za hizo nguzo pamoja na tepe zake kwa dhahabu, na pia wakatengeneza vitako vyake vitano vya shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli akatengeneza Sanduku la mbao za mshita: urefu wake ulikuwa dhiraa mbili na nusu, upana wake dhiraa moja na nusu, na kimo chake dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Akalifunika kwa dhahabu safi ndani na nje, na kulizungushia ukingo wa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Akasubu pete nne za dhahabu na kuzifungia kwenye miguu yake minne, pete mbili kwa upande mmoja na pete mbili kwa upande mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kisha akatengeneza mipiko ya mti wa mshita na kuzifunika kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Akaiingiza hiyo mipiko kwenye zile pete katika pande mbili za Sanduku ili kulibeba. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Akatengeneza kifuniko cha upatanisho kwa dhahabu safi: urefu wake ulikuwa dhiraa mbili na nusu, na upana wake dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kisha akatengeneza makerubi wawili wa dhahabu iliyofuliwa katika miisho ya hicho kifuniko. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Akatengeneza kerubi mmoja kwenye mwisho mmoja, na kerubi mwingine kwenye mwisho mwingine; akawatengeneza kuwa kitu kimoja na hicho kifuniko katika miisho hiyo miwili. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Makerubi hao walikuwa wametandaza mabawa kuelekea juu, wakitia kivuli hicho kifuniko. Makerubi hao walielekeana, wakitazama hicho kifuniko. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Akatengeneza meza ya mbao za mshita yenye urefu wa dhiraa mbili, upana wa dhiraa moja, na kimo cha dhiraa moja na nusu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kisha akaifunika kwa dhahabu safi, na kuitengenezea ukingo wa dhahabu kuizunguka pande zote. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Pia akatengeneza upapi wenye upana wa nyanda moja, na kuufanyia ule upapi ukingo wa dhahabu kuuzunguka pande zote. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Akasubu pete nne za dhahabu kwa ajili ya meza hiyo, na kuzifungia kwenye pembe nne, pale penye miguu yake minne. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Pete hizo ziliwekwa karibu na ukingo ule ili kuishikilia ile mipiko iliyotumika kuibebea hiyo meza. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mipiko hiyo ya kubebea meza ilitengenezwa kwa mti wa mshita, na ilikuwa imefunikwa kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Vyombo vyote vya mezani vilitengenezwa kwa dhahabu safi: yaani sahani zake, masinia, na bakuli na bilauri zake kwa ajili ya kumiminia sadaka za vinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Akatengeneza kinara cha taa cha dhahabu safi iliyofuliwa vizuri katika kitako chake na ufito wake; vikombe vyake vilivyofanana na ua, matovu na maua vilikuwa kitu kimoja. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Matawi sita yalitokeza kuanzia ule ufito wa katikati wa kinara cha taa: matawi matatu upande mmoja na matatu upande mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Vikombe vitatu vya mfano wa maua ya mlozi yenye matovu na maua vilikuwa katika tawi moja, vikombe vitatu katika tawi jingine, na vivyo hivyo kwa matawi yote sita yaliyotokeza kwenye kile kinara cha taa. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Juu ya kinara chenyewe kulikuwa vikombe vinne vya mfano wa maua ya mlozi yakiwa na matovu yake na maua yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Tovu moja lilikuwa chini ya jozi ya kwanza ya matawi yaliyotokeza kwenye kinara cha taa, tovu la pili chini ya jozi ya pili, nalo tovu la tatu chini ya jozi ya tatu, yaani matawi sita kwa jumla. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Matovu na matawi yote yalikuwa kitu kimoja na kile kinara cha taa, yakiwa yamefuliwa kwa dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Akatengeneza taa zake saba, na pia mikasi ya kusawazishia tambi, pamoja na masinia, zote kwa dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Akatengeneza kinara hicho cha taa pamoja na vifaa vyake vyote kutumia talanta moja ya dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Akatengeneza madhabahu ya kufukizia uvumba kwa mbao za mshita. Ilikuwa ya mraba, urefu na upana wake dhiraa moja, na kimo cha dhiraa mbili, nazo pembe zake zilikuwa kitu kimoja nayo. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Akafunika hayo madhabahu juu na pande zote na pia zile pembe zake kwa dhahabu safi, na akayafanyizia ukingo wa dhahabu kuizunguka. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Akatengeneza pete mbili za dhahabu kwa ajili ya madhabahu chini ya huo ukingo, zikiwa mbili kila upande, za kushikilia mipiko iliyotumika kubebea madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Akatengeneza mipiko kwa miti ya mshita na kuifunika kwa dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Pia akatengeneza mafuta matakatifu ya upako, na uvumba safi wenye harufu nzuri, kazi ya mtengeneza manukato. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Akatengeneza madhabahu ya sadaka ya kuteketezwa kwa mbao za mti wa mshita, kimo chake dhiraa tatu; nayo ilikuwa mraba, urefu wake dhiraa tano, na upana wa dhiraa tano. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Akatengeneza upembe kwenye kila pembe ya hizo pembe nne, ili zile pembe na madhabahu zikawa zimeungana, akafunika madhabahu kwa shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Akatengeneza vyombo vyake vyote kwa shaba: vyungu vyake vya kuondolea majivu, masepetu, mabakuli ya kunyunyizia, uma za nyama na vyombo vya kuchukulia moto. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Akatengeneza wavu wa shaba chini ya ukingo wa madhabahu ili ufikie nusu ya kimo cha madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Akasubu pete za shaba za kushikilia ile mipiko kwa ajili ya zile pembe nne za huo wavu wa shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Akatengeneza mipiko ya mti wa mshita na kuifunika kwa shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Akaiingiza ile mipiko kwenye zile pete, ili iwe pande mbili za madhabahu kwa ajili ya kuibeba. Akaitengeneza madhabahu yenye uvungu ndani yake akitumia mbao. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Akatengeneza sinia la shaba lenye kitako cha shaba kutoka kwa vioo vya shaba vilivyotolewa na wanawake waliohudumu pale ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kisha akatengeneza ua. Upande wa kusini ulikuwa na urefu wa dhiraa mia moja, na ulikuwa na mapazia ya kitani iliyosokotwa vizuri, ");
INSERT INTO swhonmm_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","pamoja na nguzo ishirini na vitako vya shaba ishirini, na kulabu na tepe za fedha juu ya hizo nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Upande wa kaskazini ulikuwa na urefu wa dhiraa mia moja, pamoja na nguzo ishirini na vitako vya shaba ishirini, pamoja na kulabu na tepe za fedha juu ya hizo nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Upande wa mwisho wa magharibi ulikuwa na upana wa dhiraa hamsini, na ulikuwa na mapazia, na nguzo kumi na vitako vyake kumi, pamoja na kulabu na tepe za fedha juu ya hizo nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Upande wa mwisho wa mashariki jua linakochomoza, pia ulikuwa na upana wa dhiraa hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mapazia yenye urefu wa dhiraa kumi na tano yalikuwa upande mmoja wa ingilio, pamoja na nguzo tatu na vitako vitatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Mapazia yenye urefu wa dhiraa kumi na tano yalikuwa upande mwingine wa ingilio la ua, pamoja na nguzo tatu na vitako vitatu. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mapazia yote yaliyozunguka ua yalikuwa ya kitani iliyosokotwa vizuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Vitako vya nguzo vilikuwa vya shaba. Kulabu na tepe juu ya nguzo zilikuwa za fedha, na ncha zake zilifunikwa kwa fedha. Kwa hiyo nguzo zote za ua zilikuwa na tepe za fedha. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Pazia la ingilio la ua lilikuwa la nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu pamoja na kitani iliyosokotwa vizuri, kazi ya mtarizi. Pazia hilo lilikuwa na urefu wa dhiraa ishirini kama zile za kwenye ua, na kimo chake kilikuwa dhiraa tano, ");
INSERT INTO swhonmm_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","likiwa na nguzo nne na vitako vinne vya shaba. Kulabu zake na tepe zake zilikuwa za fedha, na ncha zake zilikuwa zimefunikwa kwa fedha. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vigingi vyote vya maskani ya Mungu na vya ua ulioizunguka vilikuwa vya shaba. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ifuatayo ni orodha ya vifaa vilivyotumika kwa ajili ya ujenzi wa maskani ya Mungu, hiyo Maskani ya Ushuhuda, ambavyo vilitayarishwa na Walawi kama alivyoagiza Musa, chini ya usimamizi wa Ithamari, mwana wa kuhani Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Bezaleli mwana wa Uri, mwana wa Huri, wa kabila la Yuda, alifanya kila kitu Mwenyezi Mungu alichomwamuru Musa, ");
INSERT INTO swhonmm_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","akiwa pamoja na Oholiabu mwana wa Ahisamaki, wa kabila la Dani, fundi stadi wa kutia nakshi, kubuni michoro, mtarizi kwa rangi ya buluu, ya zambarau, nyekundu na kitani safi.) ");
INSERT INTO swhonmm_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Jumla ya dhahabu iliyopatikana kutokana na sadaka ya kuinuliwa kwa ajili ya kazi ya mahali patakatifu ilikuwa na uzito wa talanta ishirini na tisa na shekeli mia saba na thelathini (730), kulingana na shekeli ya mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Fedha iliyopatikana kutokana na jumuiya ya watu waliohesabiwa ilikuwa yenye uzito wa talanta mia moja na shekeli elfu moja mia saba sabini na tano (1,775), kulingana na shekeli ya mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kila mtu alitoa beka moja, ambayo ni sawa na nusu shekeli ya fedha, kwa kazi ya mahali patakatifu, kutoka kwa kila mtu aliyekuwa amehesabiwa mwenye umri wa miaka ishirini au zaidi, ambao jumla yao walikuwa wanaume elfu mia sita na tatu mia tano na hamsini (603,550). ");
INSERT INTO swhonmm_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Talanta hizo mia moja za fedha zilitumika kusubu vile vitako mia moja kwa ajili ya mahali patakatifu na pazia: vitako mia moja kwa talanta mia, yaani talanta moja kwa kila kitako. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Akatumia hizo shekeli elfu moja mia saba sabini na tano (1,775) kutengeneza kulabu za nguzo, kufunika ncha za nguzo, na kutengeneza vitanzi vyake. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Shaba iliyopatikana kutokana na sadaka ya kuinuliwa ilikuwa na uzito wa talanta sabini na shekeli elfu mbili mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Akaitumia hiyo shaba kutengeneza vitako vya ingilio la Hema la Kukutania, madhabahu ya shaba pamoja na ule wavu wake na vyombo vyake vyote, ");
INSERT INTO swhonmm_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","vile vitako vya ule ua uliozunguka na vile vya ingilio, na vigingi vyote vya maskani ya Mungu, pamoja na vigingi vya ule ua uliozunguka. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kutokana na nyuzi za rangi ya buluu, ya zambarau na nyekundu akatengeneza mavazi yaliyofumwa kwa ajili ya kuhudumu katika mahali patakatifu. Pia akamshonea Haruni mavazi matakatifu, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Akatengeneza kizibau cha dhahabu, na nyuzi za rangi ya buluu, za zambarau, na nyekundu na kitani iliyosokotwa vizuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Akafua vipande vyembamba vya dhahabu kwa nyundo na kutengeneza nyuzi nyembamba ili kuzifuma pamoja na hizo nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu na kitani safi, kazi ya fundi stadi. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Akatengeneza vipande vya mabegani vya kizibau, vilivyounganishwa kwenye pembe zake mbili kwa ajili ya kufungia. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mshipi wa kiunoni uliofumwa kwa ustadi ulifanana nacho: ulikuwa kitu kimoja na hicho kizibau, nao ulitengenezwa kwa dhahabu na nyuzi za rangi ya buluu, za zambarau, na nyekundu na kwa kitani iliyosokotwa vizuri, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Akatengeneza vito vya shohamu vilivyowekwa katika vijalizo vya dhahabu, navyo vilichorwa na majina ya wana wa Israeli kama vile muhuri huchorwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kisha akavifungia kwenye vipande vya mabega ya kizibau kuwa vito vya ukumbusho kwa wana wa Israeli, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Akatengeneza kifuko cha kifuani, kazi ya fundi stadi. Akakitengeneza kama kile kizibau: cha dhahabu, na nyuzi za rangi ya buluu, za zambarau, na za rangi nyekundu, cha kitani safi iliyosokotwa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kifuko hicho kilikuwa cha mraba, chenye urefu wa shibiri moja na upana wa shibiri moja, nacho kilikunjwa mara mbili. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kifuko hicho kilipambwa kwa safu nne za vito vya thamani. Safu ya kwanza ilikuwa na akiki, yakuti manjano na zabarajadi; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","safu ya pili ilikuwa na almasi, yakuti samawi na zumaridi; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","safu ya tatu ilikuwa na hiakintho, akiki nyekundu na amethisto; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","katika safu ya nne ilikuwa na krisolitho, shohamu na yaspi. Vito hivyo vilitiwa kwenye vijalizo vya dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kulikuwa na vito kumi na viwili, kimoja kwa kila jina la wana wa Israeli; kila kimoja kilichorwa kama muhuri kwa jina mojawapo la makabila yale kumi na mawili. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kwa ajili ya kile kifuko cha kifuani alitengeneza mikufu ya dhahabu safi, iliyosokotwa kama kamba. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Akatengeneza vijalizo viwili vya dhahabu na pete mbili za dhahabu, na kuzifungia pete hizo kwenye pembe mbili za hicho kifuko cha kifuani. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Akafunga hiyo mikufu miwili ya dhahabu kwenye hizo pete katika pembe za hicho kifuko cha kifuani, ");
INSERT INTO swhonmm_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","nazo zile ncha nyingine za mkufu akazifunga kwenye vile vijalizo viwili, na kuziunganisha na vile vipande vya mabega vya kile kizibau upande wa mbele. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Akatengeneza pete mbili za dhahabu na kuziunganisha kwenye pembe mbili za chini, upande wa ndani wa kifuko cha kifuani karibu na kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kisha akatengeneza pete nyingine mbili za dhahabu na kuziunganisha sehemu ya chini ya vipande vya mabega upande wa mbele wa kile kizibau, karibu na pindo juu kidogo ya mshipi wa kiunoni wa kizibau. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Akafunga pete za hicho kifuko cha kifuani kwenye pete za kizibau kwa kamba ya buluu, wakiziunganisha na ule mshipi wa kiunoni, ili kifuko cha kifuani kisisogee kutoka kwa kile kizibau, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Akashona joho la kizibau lote kwa kitambaa cha rangi ya buluu tupu, kazi ya mfumaji, ");
INSERT INTO swhonmm_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","na lilikuwa na nafasi ya shingo katikati ya joho lile iliyofanana na ukosi, na utepe ulioshonwa kuizunguka nafasi hiyo ili isichanike. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Akatengeneza makomamanga ya nyuzi za rangi ya buluu, za zambarau, na nyekundu na ya kitani iliyosokotwa vizuri kuzunguka pindo la hilo joho. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Kisha akatengeneza vikengele vya dhahabu safi na kuviunganisha kuzunguka pindo hilo kati ya hayo makomamanga. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Hivyo vikengele na makomamanga vilipishana kuzunguka upindo wa joho ili livaliwe kwa kuhudumu, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Pia akamtengenezea Haruni na wanawe makoti ya kitani safi, kazi ya mfumaji, ");
INSERT INTO swhonmm_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","na kilemba cha kitani safi, tepe za kichwani za kitani, na nguo za ndani za kitani iliyosokotwa vizuri. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Mshipi ulikuwa wa kitani iliyosokotwa vizuri ya rangi ya buluu, na zambarau, na nyekundu, kazi ya mtarizi, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Kisha akatengeneza lile bamba, taji takatifu, kwa dhahabu safi na kuchora juu yake maneno haya kama vile muhuri huchorwa: Mtakatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kisha wakalifunga kwa kamba ya rangi ya buluu ili kuliunganisha na kile kilemba, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Kwa hiyo kazi yote ya maskani ya Mungu, lile Hema la Kukutania, ikakamilika. Waisraeli wakafanya kila kitu sawasawa na jinsi Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ndipo wakaleta maskani ya Mungu kwa Musa: hema pamoja na vifaa vyake vyote, vibanio vyake, mihimili yake, mataruma yake, nguzo na vitako vyake; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kifuniko cha ngozi za kondoo dume kilichotiwa rangi nyekundu, na kifuniko cha ngozi za pomboo, na pazia la kufunikia; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Sanduku la Ushuhuda pamoja na mipiko yake na kiti cha rehema, ");
INSERT INTO swhonmm_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meza pamoja na vyombo vyake vyote, na mikate ya Wonesho; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kinara cha taa cha dhahabu safi, safu zake za taa pamoja na vifaa vyake vyote, pamoja na mafuta kwa ajili ya taa; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","madhabahu ya dhahabu, mafuta ya upako, uvumba wenye harufu nzuri, na pazia la ingilio la hema; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","madhabahu ya shaba, pamoja na wavu wa shaba, nguzo zake na vyombo vyake vyote, sinia, na tako lake; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","mapazia ya ua pamoja na nguzo na vitako vyake, pia na pazia la ingilio la ua; kamba zake na vigingi vya hema kwa ajili ya ua; vyombo vyote vilivyohitajiwa kwa ajili ya maskani ya Mungu, lile Hema la Kukutania; ");
INSERT INTO swhonmm_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na mavazi yaliyofumwa yanayovaliwa wakati wa huduma katika mahali patakatifu, yaani mavazi matakatifu ya kuhani Haruni na mavazi ya wanawe watakapokuwa wakihudumu katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Waisraeli walikuwa wamefanya kazi yote sawasawa na vile Mwenyezi Mungu alivyokuwa amemwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa akakagua kazi na kuona kuwa walikuwa wameifanya sawasawa na jinsi Mwenyezi Mungu alivyokuwa ameagiza. Kwa hiyo Musa akawabariki. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kisha Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Simika maskani ya Mungu, lile Hema la Kukutania, katika siku ya kwanza ya mwezi wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Weka Sanduku la Ushuhuda ndani yake na ulifunike kwa pazia. Ingiza meza na kupanga vitu vyake juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kisha ingiza kinara cha taa na uweke taa zake juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Weka madhabahu ya dhahabu ya kufukizia uvumba mbele ya Sanduku la Ushuhuda kisha uweke pazia kwenye lango la maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Weka madhabahu ya sadaka za kuteketezwa mbele ya lango la maskani ya Mungu, yaani Hema la Kukutania; ");
INSERT INTO swhonmm_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","weka sinia kati ya Hema la Kukutania na madhabahu, na uweke maji ndani yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tengeneza ua kuzunguka maskani ya Mungu, na uweke pazia penye ingilio la ua. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Chukua mafuta ya upako, upake maskani ya Mungu pamoja na kila kitu kilicho ndani yake; iweke wakfu pamoja na vitu vyote vilivyomo, nayo itakuwa takatifu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kisha yapake mafuta hayo madhabahu ya kuteketezea sadaka pamoja na vifaa vyake vyote; weka wakfu madhabahu nayo yatakuwa takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Paka sinia mafuta pamoja na kishikilio chake na uviweke wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Mlete Haruni na wanawe kwenye ingilio la Hema la Kukutania na uwaoshe kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kisha mvike Haruni yale mavazi matakatifu, umpake mafuta na kumweka wakfu ili apate kunitumikia kama kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Walete wanawe na uwavike makoti. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kisha wapake mafuta kama ulivyomtia baba yao, ili nao pia wanitumikie katika kazi ya ukuhani. Kupakwa mafuta kwao kutakuwa kwa ajili ya ukuhani utakaoendelea kwa vizazi vyote vijavyo.” ");
INSERT INTO swhonmm_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa akafanya kila kitu sawa kama vile Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kwa hiyo maskani ya Mungu ilisimikwa katika siku ya kwanza ya mwezi wa kwanza, katika mwaka wa pili. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa alipoweka wakfu maskani ya Mungu, aliweka vitako mahali pake, akasimamisha mihimili, akatia mataruma na kusimamisha nguzo. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Kisha akalitandaza hema juu ya maskani ya Mungu na kuifunika hema, kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Akachukua ule Ushuhuda na kuuweka ndani ya Sanduku la Agano, akaweka ile mipiko ya kubebea hilo Sanduku na kuweka kiti cha rehema juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kisha Musa akalileta Sanduku ndani ya maskani ya Mungu, akatundika pazia ili kulifunika Sanduku la Ushuhuda, kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa akaweka meza ndani ya Hema la Kukutania, upande wa kaskazini mwa maskani ya Mungu nje ya pazia ");
INSERT INTO swhonmm_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na kupanga mikate juu yake mbele za Mwenyezi Mungu, kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Akaweka kinara cha taa ndani ya Hema la Kukutania mkabala na meza upande wa kusini mwa maskani ya Mungu ");
INSERT INTO swhonmm_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","na kuziweka taa mbele za Mwenyezi Mungu, kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa akaweka madhabahu ya dhahabu ndani ya Hema la Kukutania mbele ya pazia, ");
INSERT INTO swhonmm_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na akafukiza uvumba wenye harufu nzuri, kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kisha akaweka pazia kwenye ingilio la maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Musa akaweka madhabahu ya sadaka za kuteketezwa karibu na ingilio la maskani ya Mungu, yaani Hema la Kukutania, na kutoa juu yake sadaka za kuteketezwa na sadaka za nafaka kama Mwenyezi Mungu alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Akaweka sinia kati ya Hema la Kukutania na madhabahu, akaweka maji ndani yake kwa ajili ya kunawia. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Naye Musa, Haruni na wanawe wakayatumia kwa kunawia mikono na miguu yao. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Wakanawa kila walipoingia katika Hema la Kukutania au walipoikaribia madhabahu, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kisha Musa akatengeneza ua kuizunguka maskani ya Mungu na madhabahu, na pia akaweka pazia kwenye ingilio la huo ua. Hivyo Musa akaikamilisha kazi. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ndipo wingu likafunika Hema la Kukutania, na utukufu wa Mwenyezi Mungu ukaijaza maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa hakuweza kuingia ndani ya Hema la Kukutania kwa sababu wingu lilikuwa limetua juu ya Hema, nao utukufu wa Mwenyezi Mungu ukaijaza maskani ya Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Katika safari yote ya Waisraeli, kila wakati wingu lilipoinuka kutoka juu ya maskani ya Mungu, wangeondoka; ");
INSERT INTO swhonmm_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","lakini kama wingu halikuinuka, hawakuondoka, hadi siku lilipoinuka. ");
INSERT INTO swhonmm_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kwa hiyo wingu la Mwenyezi Mungu lilikuwa juu ya maskani ya Mungu mchana, na moto ulikuwa katika hilo wingu wakati wa usiku, machoni pa nyumba yote ya Israeli siku zote za safari zao.");
INSERT INTO swhonmm_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mwenyezi Mungu akamwita Musa na kusema naye kutoka Hema la Kukutania, akamwambia, ");
INSERT INTO swhonmm_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Sema na Waisraeli, uwaambie, ‘Yeyote miongoni mwenu anayeleta sadaka kwa Mwenyezi Mungu, alete mnyama kama sadaka yake kutoka kundi lake la ng’ombe, au la kondoo na mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Ikiwa sadaka hiyo ni sadaka ya kuteketezwa kutoka kundi la ng’ombe, atamtoa ng’ombe dume asiye na dosari. Ni lazima amlete kwenye ingilio la Hema la Kukutania ili aweze kukubalika kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ataweka mkono wake juu ya kichwa cha sadaka ya kuteketezwa, nayo itakubaliwa kwa niaba yake ili kufanya upatanisho kwa ajili yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Atamchinja yule fahali mchanga mbele za Mwenyezi Mungu, kisha wana wa Haruni walio makuhani wataleta damu na kuinyunyiza pande zote za madhabahu yaliyo penye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ataichuna hiyo sadaka ya kuteketezwa na kuikata vipande vipande. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Wana wa Haruni kuhani wataweka moto juu ya madhabahu na kupanga kuni juu ya huo moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kisha hao wana wa Haruni walio makuhani watapanga vile vipande vya nyama, pamoja na kichwa na mafuta ya huyo mnyama, juu ya zile kuni zinazowaka juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ataziosha sehemu za ndani za yule mnyama pamoja na miguu yake kwa maji; naye kuhani atavichoma vyote juu ya madhabahu. Hii ni sadaka ya kuteketezwa, sadaka iliyotolewa kwa moto, yenye harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Ikiwa sadaka ni sadaka ya kuteketezwa kutoka kundi la kondoo au mbuzi, atamtoa dume asiye na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Atamchinjia upande wa kaskazini wa madhabahu mbele za Mwenyezi Mungu, nao wana wa Haruni walio makuhani watanyunyizia damu yake pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Atamkata vipande vipande, naye kuhani atavipanga, pamoja na kichwa na mafuta ya mnyama juu ya zile kuni zinazowaka juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ataosha sehemu za ndani na miguu kwa maji, naye kuhani atavileta vyote na kuvichoma juu ya madhabahu. Hii ni sadaka ya kuteketezwa, sadaka iliyotolewa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Ikiwa sadaka inayotolewa kwa Mwenyezi Mungu ni sadaka ya kuteketezwa ya ndege, atamtoa hua au kinda la njiwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kuhani atamleta kwenye madhabahu, naye atamvunja shingo na kumnyofoa kichwa na kumchoma juu ya madhabahu. Damu yake itachuruzishwa ubavuni mwa madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ataondoa kifuko cha chakula pamoja na uchafu wake na kuvitupa upande wa mashariki wa madhabahu, mahali pale penye majivu. ");
INSERT INTO swhonmm_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Atampasua na kumweka wazi katika mabawa yake, lakini asimwachanishe kabisa, kisha kuhani ataichoma juu ya zile kuni zinazowaka juu ya madhabahu. Hii ni sadaka ya kuteketezwa, sadaka iliyotolewa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Mtu yeyote aletapo sadaka ya nafaka kwa Mwenyezi Mungu, sadaka yake itakuwa ya unga laini. Atamimina mafuta juu yake, aweke uvumba juu yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","naye atapeleka kwa makuhani wana wa Haruni. Kuhani atachukua konzi moja unga laini na mafuta, pamoja na uvumba wote, na kuviteketeza kama sehemu ya kumbukumbu juu ya madhabahu, sadaka iliyotolewa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Sadaka ya nafaka iliyobaki ni ya Haruni na wanawe; ni sehemu ya sadaka iliyo takatifu sana iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Kama utaleta sadaka ya nafaka iliyookwa, itakuwa ya unga laini: iwe maandazi yaliyotengenezwa bila kutiwa chachu, yaliyochanganywa na mafuta, au mikate myembamba iliyotengenezwa bila kutiwa chachu na iliyopakwa mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Iwapo sadaka yako ya nafaka imeandaliwa kwenye kikaango, itakuwa ni ya unga laini uliochanganywa na mafuta, bila chachu. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Vunjavunja na kumimina mafuta juu yake; hii ni sadaka ya nafaka. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ikiwa sadaka yako ya nafaka imepikwa kwenye sufuria, itatengenezwa kwa unga laini na mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ilete hiyo sadaka ya nafaka iliyotengenezwa kwa vitu hivi kwa Mwenyezi Mungu; mkabidhi kuhani, ambaye ataipeleka madhabahuni. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Naye atatoa ile sehemu ya kumbukumbu katika hiyo sadaka ya nafaka, na kuiteketeza juu ya madhabahu kuwa sadaka iliyotolewa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Sadaka ya nafaka iliyobaki ni ya Haruni na wanawe; ni sehemu ya sadaka takatifu sana kati ya sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Kila sadaka ya nafaka unayoleta kwa Mwenyezi Mungu ni lazima ifanywe bila kutiwa chachu, kwa kuwa huna ruhusa kuchoma chachu yoyote au asali katika sadaka inayotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unaweza kuzileta kwa Mwenyezi Mungu kuwa sadaka ya malimbuko, lakini haziwezi kutolewa juu ya madhabahu kama harufu nzuri ya kupendeza. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Koleza sadaka zako zote za nafaka kwa chumvi. Usiache kuweka chumvi ya agano la Mungu wako katika sadaka zako za nafaka; weka chumvi kwenye sadaka zako zote. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Ukileta malimbuko ya sadaka ya nafaka kwa Mwenyezi Mungu, utatoa masuke yaliyopondwa ya nafaka mpya iliyookwa kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Weka mafuta na uvumba juu yake; ni sadaka ya nafaka. ");
INSERT INTO swhonmm_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kuhani atateketeza ile sehemu ya kumbukumbu katika hiyo sadaka ya nafaka iliyopondwa, na mafuta, pamoja na uvumba wote, kuwa sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Ikiwa mtu anatoa sadaka ya amani, naye akatoa ng’ombe, akiwa dume au jike, atamleta mnyama asiye na dosari mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ataweka mkono wake juu ya kichwa cha sadaka yake na kumchinja penye ingilio la Hema la Kukutania. Ndipo makuhani, wana wa Haruni, watanyunyiza damu ya huyo mnyama pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Katika hiyo sadaka ya amani ataleta sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto: sehemu za ndani na mafuta yote yanayoungana nazo, ");
INSERT INTO swhonmm_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","figo zote pamoja na mafuta yaliyozifunika karibu na kiuno, na kipande kirefu cha ini; utayaondoa pamoja na figo. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kisha wana wa Haruni wataiteketeza juu ya madhabahu, juu ya ile sadaka ya kuteketezwa iliyo juu ya kuni zinazowaka; ni sadaka ya kuteketezwa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Akitoa kondoo au mbuzi kutoka kundi kuwa sadaka ya amani kwa Mwenyezi Mungu, atamtoa dume au jike asiye na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Akimtoa mwana-kondoo, atamleta mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ataweka mkono wake juu ya kichwa cha sadaka yake, naye atamchinja mbele ya Hema la Kukutania. Kisha wana wa Haruni watanyunyiza damu ya huyo mnyama pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Katika hiyo sadaka ya amani ataleta dhabihu iliyotolewa kwa Mwenyezi Mungu kwa moto: mafuta yake, mafuta yote ya mkia uliokatwa karibu na uti wa mgongo, mafuta yote yanayofunika sehemu za ndani au yale yanayounganika nazo, ");
INSERT INTO swhonmm_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","figo mbili pamoja na mafuta yanayozifunika yaliyo karibu na kiuno, na kipande kirefu cha ini, ambayo utayaondoa pamoja na figo. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kuhani ataviteketeza juu ya madhabahu viwe chakula, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ikiwa sadaka yake ni mbuzi, ataileta mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ataweka mkono wake juu ya kichwa chake na kumchinja mbele ya Hema la Kukutania. Kisha wana wa Haruni watanyunyiza damu ya huyo mnyama pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Katika ile sadaka anayotoa, atatoa hii sadaka ya kuteketezwa kwa Mwenyezi Mungu: mafuta yote yanayofunika sehemu za ndani na yale yanayoungana nazo, ");
INSERT INTO swhonmm_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","figo zote mbili pamoja na mafuta yaliyo juu yake karibu na kiuno, na kipande kirefu cha ini, ambayo atayaondoa pamoja na figo. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kuhani ataviteketeza juu ya madhabahu viwe chakula, sadaka iliyotolewa kwa moto, harufu nzuri. Mafuta yote ya mnyama ni ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Hili ni agizo la kudumu kwa vizazi vijavyo, popote mnapoishi: Msile mafuta yoyote ya mnyama wala damu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Waambie Waisraeli: ‘Mtu yeyote afanyapo dhambi bila kukusudia na akatenda lile lililokatazwa katika amri yoyote ya Mwenyezi Mungu: ");
INSERT INTO swhonmm_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ikiwa kuhani aliyepakwa mafuta amefanya dhambi na kuwaletea watu hatia, lazima alete kwa Mwenyezi Mungu fahali mchanga asiye na dosari, kuwa sadaka ya dhambi kwa ajili ya dhambi aliyotenda. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Atamkabidhi huyo fahali kwenye ingilio la Hema la Kukutania mbele za Mwenyezi Mungu. Ataweka mkono wake juu ya kichwa cha huyo fahali na kumchinja mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kisha kuhani huyo aliyepakwa mafuta atachukua sehemu ya damu ya huyo fahali na kuileta katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Atachovya kidole chake katika hiyo damu, na kuinyunyiza sehemu yake mara saba mbele za Mwenyezi Mungu, mbele ya pazia la mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kisha kuhani atatia sehemu ya hiyo damu juu ya pembe za madhabahu ya kufukizia uvumba wenye harufu nzuri iliyo mbele za Mwenyezi Mungu katika Hema la Kukutania. Damu iliyobaki ya huyo fahali ataimwaga chini ya hayo madhabahu ya kuteketezea sadaka kwenye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Atayaondoa mafuta yote ya fahali huyo wa sadaka ya dhambi: mafuta yale yanayofunika sehemu za ndani au zile zinazounganika nazo, ");
INSERT INTO swhonmm_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","figo zote mbili na mafuta yaliyo juu yake karibu na kiuno, na kipande kirefu cha ini, ambayo atayaondoa pamoja na figo zote, ");
INSERT INTO swhonmm_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kama vile mafuta yanavyoondolewa kutoka kwa ng’ombe aliyetolewa sadaka ya amani. Kisha kuhani ataviteketeza juu ya madhabahu ya sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Lakini ngozi ya huyo fahali na nyama zake zote, pamoja na kichwa na miguu yake, sehemu za ndani na matumbo, ");
INSERT INTO swhonmm_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yaani sehemu nyingine zote zilizobaki za huyo fahali, lazima azitoe nje ya kambi hadi mahali palipo safi, ambapo majivu hutupwa; naye atamchoma kwa moto wa kuni juu ya lundo la majivu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ikiwa jumuiya yote ya Israeli watatenda dhambi pasipo kukusudia na kufanya lile lililokatazwa katika amri yoyote ya Mwenyezi Mungu, hata kama jumuiya hawafahamu jambo hilo, wana hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Wanapotambua dhambi waliyoitenda, lazima kusanyiko walete fahali mchanga kuwa sadaka ya dhambi, na kuikabidhi mbele ya Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Wazee wa jumuiya wataweka mikono yao juu ya kichwa cha huyo fahali mbele za Mwenyezi Mungu, naye huyo fahali atachinjwa mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kisha kuhani aliyepakwa mafuta ataingiza sehemu ya damu ya huyo fahali ndani ya Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Atachovya kidole chake kwenye damu na kuinyunyiza mara saba mbele za Mwenyezi Mungu mbele ya hilo pazia. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Atatia sehemu ya hiyo damu juu ya pembe za madhabahu yaliyo mbele za Mwenyezi Mungu katika Hema la Kukutania. Damu iliyobaki ataimwaga chini ya madhabahu ya kuteketezea sadaka, penye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Atayaondoa mafuta yote ya yule fahali na kuyateketeza juu ya madhabahu, ");
INSERT INTO swhonmm_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","naye atamfanyia fahali huyu kama alivyomfanyia yule fahali mwingine wa sadaka ya dhambi. Kwa njia hii kuhani atawafanyia watu upatanisho, nao watasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kisha atamchukua yule fahali nje ya kambi na kumteketeza kama alivyomteketeza yule wa kwanza. Hii ni sadaka ya dhambi kwa ajili ya jumuiya. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Wakati kiongozi ametenda dhambi bila kukusudia na kufanya yaliyokatazwa katika amri yoyote ya Mwenyezi Mungu, Mungu wake, ana hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Atakapofahamishwa dhambi aliyotenda, ni lazima alete beberu asiye na dosari kuwa sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ataweka mkono wake juu ya kichwa cha yule mbuzi na kumchinja mahali pale sadaka za kuteketezwa huchinjiwa mbele za Mwenyezi Mungu. Hii ni sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kisha kuhani atachukua sehemu ya damu ya sadaka ya dhambi kwa kidole chake na kuitia kwenye pembe za madhabahu ya sadaka ya kuteketeza, na kuimwaga damu iliyobaki chini ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Atayateketeza mafuta yote juu ya madhabahu, kama alivyoteketeza mafuta ya mnyama wa sadaka ya amani. Kwa njia hii kuhani atafanya upatanisho wa dhambi kwa ajili ya yule mtu, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Kama mtu katika jumuiya ametenda dhambi pasipo kukusudia, na kufanya lile lililokatazwa katika amri yoyote ya Mwenyezi Mungu, yeye ana hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Atakapofahamishwa dhambi aliyoitenda, ni lazima alete mbuzi jike asiye na dosari kuwa sadaka yake kwa ajili ya dhambi aliyotenda. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ataweka mkono wake juu ya kichwa cha sadaka ya dhambi na kumchinjia mahali pa kuteketezea sadaka. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kisha kuhani atachukua sehemu ya ile damu kwa kidole chake na kuitia kwenye pembe za madhabahu ya sadaka ya kuteketezwa na kuimwaga damu iliyobaki chini ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Atayaondoa mafuta yote, kama vile mafuta yaondolewavyo kwenye sadaka ya amani, naye kuhani atayateketeza juu ya madhabahu kama harufu nzuri ya kumpendeza Mwenyezi Mungu. Kwa njia hii kuhani atafanya upatanisho kwa ajili yake, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Akileta mwana-kondoo kuwa sadaka yake ya dhambi, atamleta jike asiye na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ataweka mkono wake juu ya kichwa cha huyo mwana-kondoo na kumchinja kwa ajili ya sadaka ya dhambi mahali ambako sadaka ya kuteketezwa huchinjiwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kisha kuhani atachukua sehemu ya damu ya sadaka ya dhambi kwa kidole chake na kuitia juu ya pembe za madhabahu ya sadaka ya kuteketezwa, na ile damu iliyobaki ataimwaga chini ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ataondoa mafuta yote, kama vile mafuta yaondolewavyo kutoka kwa mwana-kondoo wa sadaka ya amani, naye kuhani atayateketeza juu ya madhabahu juu ya zile sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto. Kwa njia hii kuhani atafanya upatanisho kwa ajili yake kwa dhambi aliyoitenda, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ikiwa mtu ametenda dhambi kwa sababu hakusema alipotakiwa kutoa ushahidi hadharani kuhusu jambo aliloona au kujua habari zake, yeye atastahili adhabu. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Au mtu akitambua kuwa ana hatia, kama vile akigusa kitu chochote ambacho ni najisi, iwe ni mizoga ya wanyama pori walio najisi, au ya wanyama wafugwao walio najisi, au ya viumbe vinavyotambaa ardhini, hata akiwa hana habari, amekuwa najisi na mwenye hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Au akigusa kitu kilicho kichafu kinachotokana na binadamu, kitu chochote kile kinachoweza kumfanya awe najisi, hata akiwa hana habari, atakapofahamu atakuwa na hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Au kama mtu ameapa kufanya kitu chochote bila kufikiri, kiwe chema au kibaya, kwa vyovyote mtu aweza kuapa bila kujali, hata akiwa hana habari, atakapofahamu atakuwa na hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Mtu yeyote atakapokuwa na hatia katika mojawapo ya haya, ni lazima akiri ni kwa njia gani ametenda dhambi, ");
INSERT INTO swhonmm_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na kama adhabu ya dhambi aliyoitenda, ni lazima alete kwa Mwenyezi Mungu kondoo jike au mbuzi jike kutoka kundi lake kuwa sadaka ya dhambi; naye kuhani atafanya upatanisho kwa ajili yake kwa dhambi yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Lakini kama huyo mtu hataweza kumtoa mwana-kondoo, ataleta hua wawili au makinda wawili wa njiwa kwa Mwenyezi Mungu ikiwa ni adhabu kwa ajili ya dhambi yake: mmoja wa hao ndege kwa ajili ya sadaka ya dhambi, na wa pili kwa ajili ya sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Atawaleta kwa kuhani, ambaye atamtoa kwanza ndege mmoja kwa ajili ya sadaka ya dhambi. Atamvunja shingo na kuacha kichwa chake kikining’inia, ");
INSERT INTO swhonmm_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","naye atanyunyiza sehemu ya hiyo damu ya sadaka ya dhambi kwenye pembe za madhabahu. Damu iliyobaki lazima ichuruzwe chini ya madhabahu. Hii ni sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kisha kuhani atamtoa yule ndege wa pili kama sadaka ya kuteketezwa kwa kufuata utaratibu uliowekwa, na hivyo kufanya upatanisho kwa ajili yake kwa dhambi aliyoitenda, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Ikiwa basi hawezi kupata hua wawili au makinda wawili wa njiwa, ataleta sehemu ya kumi ya efa ya unga laini kwa ajili ya sadaka ya dhambi. Kamwe asiweke mafuta wala uvumba juu yake, kwa sababu ni sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Atauleta unga kwa kuhani, ambaye atachukua konzi moja kama sehemu ya kumbukumbu na atauteketeza kwenye madhabahu juu ya sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto. Hii ni sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kwa njia hii kuhani atafanya upatanisho kwa ajili yake kwa dhambi yoyote ya hizo alizotenda, naye atasamehewa. Sadaka iliyobaki itakuwa ya kuhani, kama ilivyokuwa ile sadaka ya nafaka.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Mtu anapokiuka na kutenda dhambi pasipo kukusudia kuhusu mojawapo ya mambo matakatifu ya Mwenyezi Mungu, huyo mtu ataleta kwa Mwenyezi Mungu kama adhabu kondoo dume mmoja kutoka kundi lake, asiye na dosari, na mwenye thamani halisi ya fedha kulingana na shekeli ya mahali patakatifu. Hii ni sadaka ya hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ni lazima alipe kwa yale aliyoshindwa kufanya kuhusu vitu vitakatifu, kwa kuongeza sehemu ya tano ya thamani ile na kuitoa yote kwa kuhani, ambaye atamfanyia upatanisho kwa huyo kondoo dume kama sadaka ya dhambi, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Kama mtu akifanya dhambi, na kutenda yaliyokatazwa katika mojawapo ya amri za Mwenyezi Mungu, hata ikiwa hajui, yeye ana hatia na anastahili adhabu. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Atamletea kuhani kama sadaka ya hatia kondoo dume kutoka kundi lake, kondoo asiye na dosari na mwenye thamani halisi. Kwa njia hii, kuhani atafanya upatanisho kwa ajili yake kwa kosa alilotenda bila kukusudia, naye atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hii ni sadaka ya hatia; amekuwa na hatia kwa kufanya kosa dhidi ya Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Mtu yeyote akitenda dhambi, naye si mwaminifu kwa Mwenyezi Mungu kwa kumdanganya jirani yake kuhusu kitu fulani alichokabidhiwa, au kimeachwa chini ya utunzaji wake, au kimeibwa, au kama akimdanganya, ");
INSERT INTO swhonmm_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","au akiokota mali iliyopotea na akadanganya kuihusu, au kuapa kwa uongo, au kama akitenda dhambi yoyote ambayo watu wanaweza kuitenda; ");
INSERT INTO swhonmm_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","wakati akitenda dhambi hizo na kuwa mwenye hatia, ni lazima arudishe kile alichokuwa amekiiba au amekichukua kwa dhuluma, au alichokuwa amekabidhiwa, au mali iliyokuwa imepotea akaipata, ");
INSERT INTO swhonmm_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","au chochote alichokuwa amekiapia kwa uongo. Lazima akirudishe kikamilifu, na aongeze sehemu ya tano ya thamani yake, vyote ampe mwenye mali siku ile anapeleka sadaka yake ya hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Kisha kama adhabu lazima amletee kuhani, yaani kwa Mwenyezi Mungu, kuwa sadaka yake ya hatia, kondoo dume kutoka kundi lake asiye na dosari, mwenye thamani kamili. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kwa njia hii kuhani atafanya upatanisho kwa ajili yake mbele za Mwenyezi Mungu, naye atasamehewa kwa kosa lolote katika mambo aliyoyatenda lililomfanya kuwa na hatia.” ");
INSERT INTO swhonmm_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mpe Haruni na wanawe agizo hili: ‘Haya ndio masharti kwa ajili ya sadaka ya kuteketezwa: Sadaka ya kuteketezwa itabaki kwenye moto juu ya madhabahu usiku kucha, hadi asubuhi, nao moto lazima uwe unaendelea kuwaka juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kisha kuhani atavaa mavazi yake ya kitani, pamoja na nguo za ndani za kitani mwilini wake, na aondoe majivu ya sadaka ya kuteketezwa ambayo moto umeteketeza juu ya madhabahu, na kuyaweka kando ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Kisha atayavua mavazi haya na kuvaa mengine, naye achukue yale majivu nje ya kambi na kuyapeleka mahali palipo safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto ulio juu ya madhabahu lazima uwe unaendelea kuwaka; kamwe usizimike. Kila asubuhi kuhani ataongeza kuni na kupanga sadaka ya kuteketezwa juu ya moto, na kuteketeza mafuta ya wanyama wa sadaka za amani juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto lazima uendelee kuwaka juu ya madhabahu mfululizo, kamwe usizimike. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Haya ndio masharti ya sadaka ya nafaka: Wana wa Haruni wataileta mbele za Mwenyezi Mungu, mbele za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kuhani atachukua konzi moja ya unga laini na mafuta, pamoja na uvumba wote ulio juu ya sadaka ya nafaka, na kuteketeza sehemu hiyo ya kumbukumbu juu ya madhabahu kama harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruni na wanawe watakula sehemu iliyobaki, lakini italiwa bila kutiwa chachu mahali patakatifu, nao wataila katika ua wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Kamwe haitaokwa na chachu; nimewapa kama fungu lao la sadaka iliyotolewa kwangu kwa moto. Ni takatifu sana, kama vile ilivyo sadaka ya dhambi na ya hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Kila mwanaume mzao wa Haruni aweza kuila. Ni fungu lake milele la sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto kwa vizazi vijavyo. Chochote kinachozigusa kitakuwa kitakatifu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Tena Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Hii ni sadaka ambayo Haruni na wanawe wanapaswa kuleta kwa Mwenyezi Mungu siku atakapopakwa mafuta: sehemu ya kumi ya efa ya unga laini kama sadaka ya kawaida ya nafaka. Nusu yake ataitoa asubuhi na nusu nyingine jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Iandae kwa mafuta kwenye kikaango; ilete ikiwa imechanganywa vizuri, na utoe hiyo sadaka ya nafaka ikiwa imevunjwa vipande vipande kuwa harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mwanawe atakayeingia mahali pake kama kuhani aliyepakwa mafuta ndiye atakayeiandaa. Ni fungu la milele la Mwenyezi Mungu, nalo litateketezwa kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kila sadaka ya nafaka ya kuhani itateketezwa kabisa; kamwe haitaliwa.” ");
INSERT INTO swhonmm_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Mwambie Haruni na wanawe: ‘Haya ndio masharti kwa ajili ya sadaka ya dhambi: Sadaka ya dhambi itachinjiwa mbele za Mwenyezi Mungu mahali sadaka ya kuteketezwa huchinjiwa; ni takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kuhani anayeitoa ndiye atakayeikula; itakuliwa katika mahali patakatifu, katika ua wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chochote kitakachogusa nyama yoyote ya hiyo sadaka kitakuwa kitakatifu; na kama damu ya hiyo sadaka itadondokea juu ya vazi, lazima ulifulie mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Chungu cha udongo kitakachopikiwa nyama lazima kivunjwe, lakini kama imepikiwa kwenye chombo cha shaba, chombo hicho kitasuguliwa na kusuuzwa kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kila mwanaume katika jamaa ya kuhani aweza kula nyama hiyo; ni takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Lakini kila sadaka ya dhambi ambayo damu yake imeletwa ndani ya Hema la Kukutania kufanya upatanisho katika Mahali Patakatifu kamwe haitaliwa; lazima iteketezwe. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Haya ndio masharti kwa ajili ya sadaka ya hatia, ambayo ni takatifu sana: ");
INSERT INTO swhonmm_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Sadaka ya hatia itachinjiwa mahali pale sadaka ya kuteketezwa huchinjiwa, nayo damu yake itanyunyizwa pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mafuta yake yote yatatolewa sadaka: mafuta ya mkia, na mafuta yale yanayofunika sehemu za ndani, ");
INSERT INTO swhonmm_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","figo zote mbili pamoja na mafuta yanayozifunika karibu na kiuno, na kipande kirefu cha ini, ambayo yataondolewa pamoja na hizo figo. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kuhani atayateketeza juu ya madhabahu kuwa sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. Hii ni sadaka ya hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mwanaume yeyote katika jamaa ya kuhani aweza kuila, lakini lazima iliwe mahali patakatifu; ni takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Sheria hii ya sadaka ya hatia ni sawasawa na ile ya sadaka ya dhambi: Nyama ya yule mnyama aliyetolewa sadaka ni ya yule kuhani anayesimamia ibada ya upatanisho. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kuhani anayetoa sadaka ya kuteketezwa kwa ajili ya mtu yeyote anaweza kuichukua ngozi ya mnyama yule aliyetolewa iwe yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kila sadaka ya nafaka iliyookwa jikoni au kupikwa katika sufuria au katika kikaango itakuwa ya kuhani anayeitoa. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nayo kila sadaka ya nafaka, iwe imechanganywa na mafuta au iko kavu, itakuwa ya wana wa Haruni, nayo itagawanywa sawa kati yao. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Haya ndio masharti kwa ajili ya sadaka ya amani ambayo mtu aweza kuileta kwa Mwenyezi Mungu: ");
INSERT INTO swhonmm_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Ikiwa mtu atatoa sadaka ya amani kwa ajili ya kuonesha shukrani, pamoja na sadaka hii ya shukrani, atatoa maandazi yasiyotiwa chachu yaliyochanganywa na mafuta, mikate myembamba isiyotiwa chachu na iliyopakwa mafuta, na maandazi ya unga laini uliokandwa vizuri na kuchanganywa na mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pamoja na sadaka yake ya amani ya shukrani, ataleta sadaka ya maandazi yaliyotengenezwa kwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ataleta moja ya kila aina ya andazi kuwa sadaka, matoleo kwa Mwenyezi Mungu; hii ni ya kuhani anayenyunyiza damu ya sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama ya sadaka ya amani kwa ajili ya shukrani lazima iliwe siku hiyo hiyo inapotolewa; hutabakiza kitu chochote hadi asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Lakini ikiwa sadaka yake ni kwa ajili ya nadhiri au ni sadaka ya hiari, sadaka hiyo italiwa siku hiyo inapotolewa, lakini chochote kinachobakia kinaweza kuliwa kesho yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nyama yoyote ya sadaka inayobaki hadi siku ya tatu lazima iteketezwe kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kama nyama yoyote ya sadaka ya amani italiwa siku ya tatu, Mwenyezi Mungu hataikubali. Haitahesabiwa kwake huyo aliyeitoa, kwa kuwa ni najisi. Mtu atakayekula sehemu yake yoyote atahesabiwa hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Nyama inayogusa chochote kilicho najisi kamwe haitaliwa; lazima iteketezwe kwa moto. Kuhusu nyama nyingine, mtu yeyote aliyetakaswa anaweza kuila. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Lakini kama mtu yeyote najisi akila nyama yoyote ya sadaka ya amani iliyotolewa kwa Mwenyezi Mungu, huyo mtu lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kama mtu yeyote akigusa kitu kilicho najisi, iwe ni uchafu wa mwanadamu, au mnyama najisi, au kitu chochote kilicho najisi, kitu cha kuchukiza, kisha akala nyama yoyote ya sadaka ya amani iliyotolewa kwa Mwenyezi Mungu, mtu huyo ni lazima akatiliwe mbali na watu wake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Waambie Waisraeli: ‘Msile mafuta yoyote ya ng’ombe, kondoo wala mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta ya mnyama aliyekutwa amekufa au ameraruliwa na wanyama pori yanaweza kutumika kwa kazi nyingine yoyote, lakini kamwe msiyale. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Mtu yeyote alaye mafuta ya mnyama ambaye ametolewa sadaka kwa Mwenyezi Mungu kwa moto ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Popote mtakapoishi, kamwe msile damu ya ndege yeyote wala ya mnyama. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Mtu yeyote atakayekula damu lazima akatiliwe mbali na watu wake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Waambie Waisraeli: ‘Mtu yeyote aletaye sadaka ya amani kwa Mwenyezi Mungu ataleta sehemu ya sadaka hiyo kama dhabihu yake kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ataleta sadaka kwa mikono yake mwenyewe iliyotolewa kwa Mwenyezi Mungu kwa moto; ataleta mafuta ya huyo mnyama pamoja na kidari, naye atainua hicho kidari mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kuhani atayateketeza hayo mafuta juu ya madhabahu, lakini kidari kitakuwa cha Haruni na wanawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Paja la kulia la sadaka zako za amani utampa kuhani kama matoleo. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mwana wa Haruni atoaye damu na mafuta ya mnyama wa sadaka ya amani ndiye atakayepewa paja hilo la kulia kuwa fungu lake. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kutoka kwa sadaka za amani za Waisraeli, mimi Mungu nimepokea kidari kile kilichoinuliwa, pamoja na lile paja lililotolewa, nami nimevitoa kwa kuhani Haruni na wanawe kuwa fungu lao la milele kutoka kwa Waisraeli.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hii ndiyo sehemu ya sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto, ambazo zilitengwa kwa ajili ya Haruni na wanawe siku ile walipowekwa wakfu ili kumtumikia Mwenyezi Mungu katika kazi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Siku ile walipopakwa mafuta, Mwenyezi Mungu aliagiza kwamba Waisraeli wawape hili kama fungu lao la milele kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Basi haya ndio masharti kuhusu sadaka ya kuteketezwa, sadaka ya nafaka, sadaka ya dhambi, sadaka ya hatia, sadaka ya kuwekwa wakfu, na sadaka ya amani, ");
INSERT INTO swhonmm_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ambayo Mwenyezi Mungu alimpa Musa juu ya Mlima Sinai siku ile alipowaagiza Waisraeli walete sadaka zao kwa Mwenyezi Mungu, katika Jangwa la Sinai. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Waletee Haruni na wanawe mavazi yao, mafuta ya upako, fahali kwa ajili ya sadaka ya dhambi, kondoo dume wawili na kikapu chenye mikate iliyotengenezwa bila chachu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kisha kusanya watu wote kwenye ingilio la Hema la Kukutania.” ");
INSERT INTO swhonmm_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa akafanya kama Mwenyezi Mungu alivyomwagiza, na watu wakakusanyika kwenye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa akawaambia kusanyiko, “Hili ndilo Mwenyezi Mungu ameagiza lifanyike.” ");
INSERT INTO swhonmm_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Kisha Musa akamleta Haruni na wanawe mbele, akawaosha kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Akamvika Haruni koti, akamfunga mshipi, akamvika joho, na kumvalisha kizibau. Pia akamfunga hicho kizibau kiunoni mwake kwa mshipi uliofumwa kwa ustadi. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Akaweka kifuko cha kifuani juu yake, na kuweka Urimu na Thumimu kwenye hicho kifuko. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Kisha akamvika Haruni kilemba kichwani pake, akaweka lile bamba la dhahabu, lile taji takatifu, upande wa mbele wa kilemba, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kisha Musa akachukua mafuta ya upako, na kuipaka maskani ya Mungu na kila kitu kilichokuwamo; hivyo akaviweka wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Akanyunyiza sehemu ya mafuta juu ya madhabahu mara saba, akaipaka madhabahu mafuta na vyombo vyake vyote, pamoja na sinia na kinara chake, ili kuviweka wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Akamimina sehemu ya hayo mafuta ya upako kichwani mwa Haruni, akampaka mafuta ili kumweka wakfu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kisha akawaleta wana wa Haruni mbele, akawavika makoti, akawafunga mishipi na kuwavika vilemba, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kisha akamtoa fahali kwa ajili ya sadaka ya dhambi, nao Haruni na wanawe wakaweka mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa akamchinja yule fahali na akachukua sehemu ya hiyo damu, kisha kwa kidole chake akaitia kwenye pembe zote za madhabahu ili kutakasa madhabahu. Akaimwaga damu iliyobaki chini ya madhabahu. Kwa hiyo akayaweka wakfu ili kufanya upatanisho kwa ajili ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Pia Musa akachukua mafuta yote yanayofunika sehemu za ndani, na kipande kirefu cha ini, na figo zote mbili pamoja na mafuta yake, akayateketeza juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Lakini fahali, ikiwa pamoja na ngozi yake na nyama yake na sehemu zake za ndani na matumbo, akaiteketeza nje ya kambi, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kisha Musa akamleta kondoo dume kwa ajili ya sadaka ya kuteketezwa, naye Haruni na wanawe wakaweka mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ndipo Musa akamchinja yule kondoo dume na kunyunyiza damu yake pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Musa akamkata yule kondoo dume vipande vipande na kukiteketeza kichwa, vile vipande na yale mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Kisha akamsafisha sehemu za ndani na miguu kwa maji, na kumteketeza yule kondoo dume mzima juu ya madhabahu kuwa sadaka ya kuteketezwa, harufu nzuri ya kupendeza, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kisha Musa akamleta yule kondoo dume wa pili, ndiye kondoo dume kwa ajili ya kuwaweka wakfu, naye Haruni na wanawe wakaweka mikono yao juu ya kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa akamchinja yule kondoo dume, akaichukua sehemu ya damu yake na kuipaka juu ya ncha ya sikio la kuume la Haruni, na juu ya kidole gumba cha mkono wake wa kuume na juu ya kidole kikubwa cha mguu wake wa kuume. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Pia Musa akawaleta hao wana wa Haruni mbele, akaipaka sehemu ya hiyo damu kwenye ncha za masikio yao ya kuume, juu ya vidole gumba vya mikono yao ya kuume, na juu ya vidole vikubwa vya miguu yao ya kuume. Kisha akanyunyiza damu pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Akachukua mafuta ya mnyama, mafuta ya mkia, mafuta yote yanayofunika sehemu za ndani, kipande kirefu cha ini, figo zote mbili pamoja na mafuta yake, na paja la kulia. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Kisha kutoka kwa kikapu cha mikate iliyotengenezwa bila chachu, kilichokuwa mbele za Mwenyezi Mungu, akachukua andazi moja, na jingine lililotengenezwa kwa mafuta, na mkate mwembamba; akaviweka hivi vyote juu ya mafungu ya mafuta ya mnyama, na juu ya lile paja la kulia. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Akaviweka hivi vyote mikononi mwa Haruni na wanawe, na kuviinua mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kisha Musa akavichukua kutoka mikononi mwao na kuviteketeza juu ya madhabahu ya sadaka ya kuteketezwa kuwa sadaka ya kuwekwa wakfu, harufu nzuri ya kupendeza, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kisha akachukua kidari, kilicho fungu la Musa la kondoo dume kwa ajili ya kuwekwa wakfu, na kukiinua mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kisha Musa akachukua sehemu ya mafuta ya upako, na sehemu ya damu kutoka madhabahu, na kuvinyunyiza juu ya Haruni na mavazi yake, na juu ya wanawe na mavazi yao. Kwa hiyo akamweka Haruni na mavazi yake wakfu, pamoja na wanawe na mavazi yao. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kisha Musa akamwambia Haruni na wanawe, “Pikeni hiyo nyama kwenye ingilio la Hema la Kukutania, na muile hapo pamoja na mkate kutoka kikapu cha sadaka ya kuweka wakfu, kama nilivyoagiza: ‘Haruni na wanawe wataila.’ ");
INSERT INTO swhonmm_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kisha mteketeze nyama na mikate iliyobaki. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Msitoke kwenye ingilio la Hema la Kukutania kwa muda wa siku saba, hadi siku zenu za kuwekwa wakfu ziwe zimetimia, kwa kuwa muda wenu wa kuwekwa wakfu utakuwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Lile lililofanyika leo liliagizwa na Mwenyezi Mungu ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Lazima mkae kwenye ingilio la Hema la Kukutania usiku na mchana kwa siku saba, na kufanya lile Mwenyezi Mungu analolitaka, ili msife; kwa kuwa hilo ndilo nililoamriwa.” ");
INSERT INTO swhonmm_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Kwa hiyo Haruni na wanawe wakafanya kila kitu Mwenyezi Mungu alichoamuru kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Katika siku ya nane, Musa akawaita Haruni na wanawe, na wazee wa Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Akamwambia Haruni, “Chukua ndama dume kwa ajili ya sadaka yako ya dhambi, na kondoo dume kwa sadaka yako ya kuteketezwa, wote wawili wasiwe na dosari, nao uwalete mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kisha waambie Waisraeli: ‘Chukueni beberu kwa ajili ya sadaka ya dhambi, na ndama na mwana-kondoo, wote wawili wawe wa umri wa mwaka mmoja, na wasio na dosari, kwa ajili ya sadaka ya kuteketezwa, ");
INSERT INTO swhonmm_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na pia maksai na kondoo dume kwa ajili ya sadaka ya amani, ili kutoa dhabihu mbele za Mwenyezi Mungu, pamoja na sadaka ya nafaka iliyochanganywa na mafuta. Kwa kuwa leo Mwenyezi Mungu atawatokea.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Wakavileta vile vitu Musa alivyowaagiza mbele ya Hema la Kukutania, na kusanyiko lote wakakaribia na kusimama mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ndipo Musa akasema, “Hili ndilo Mwenyezi Mungu alilowaagiza mlifanye, ili utukufu wa Mwenyezi Mungu upate kuonekana kwenu.” ");
INSERT INTO swhonmm_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa akamwambia Haruni, “Njoo madhabahuni utoe dhabihu ya sadaka ya dhambi na sadaka ya kuteketezwa, kuwa upatanisho kwa ajili yako mwenyewe na kwa ajili ya watu. Kisha utoe sadaka ya upatanisho kwa ajili ya watu, kama vile Mwenyezi Mungu alivyoagiza.” ");
INSERT INTO swhonmm_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Hivyo Haruni akaja madhabahuni na kumchinja yule ndama kuwa sadaka ya dhambi kwa ajili yake mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Wanawe wakamletea damu, naye akachovya kidole chake katika hiyo damu, akaitia kwenye pembe za madhabahu, nayo damu iliyobaki akaimwaga chini ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Juu ya madhabahu akateketeza mafuta, figo na kipande kirefu cha ini kutoka hiyo sadaka ya dhambi, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Akateketeza nyama na ngozi nje ya kambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Kisha Haruni akachinja sadaka ya kuteketezwa. Wanawe wakamletea damu, naye akainyunyiza pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wakamletea sadaka ya kuteketezwa kipande kwa kipande, pamoja na kichwa, naye akaviteketeza juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Akasafisha sehemu za ndani na miguu, akaviteketeza juu ya sadaka ya kuteketezwa juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kisha Haruni akaleta sadaka ile iliyokuwa kwa ajili ya watu. Akachukua yule mbuzi wa sadaka ya dhambi kwa ajili ya watu, akamchinja na kumtoa kwa ajili ya sadaka ya dhambi, kama alivyofanya kwa ile ya kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Haruni akaleta sadaka ya kuteketezwa na kuitoa kama ilivyoelekezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Pia akaleta sadaka ya nafaka, akachukua konzi moja na kuiteketeza juu ya madhabahu, pamoja na sadaka ya kuteketezwa ya asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Akachinja maksai na kondoo dume kuwa sadaka ya amani kwa ajili ya watu. Wanawe Haruni wakampa ile damu, naye akainyunyiza pande zote za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Lakini sehemu zile za mafuta ya yule maksai na ya yule kondoo dume, yaani mafuta ya mkia, yaliyofunika tumbo, ya figo na kipande kirefu cha ini, ");
INSERT INTO swhonmm_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","hivi vyote wakaviweka juu ya vidari, kisha Haruni akayateketeza hayo mafuta ya wanyama juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haruni akaviinua vile vidari na paja la kulia mbele za Mwenyezi Mungu ili viwe sadaka ya kuinuliwa, kama Musa alivyoagiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kisha Haruni akainua mikono yake kuwaelekea watu na kuwabariki. Naye baada ya kutoa dhabihu ya sadaka ya dhambi, sadaka ya kuteketezwa, na sadaka ya amani, akashuka chini. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Kisha Musa na Haruni wakaingia kwenye Hema la Kukutania. Walipotoka nje, wakawabariki watu. Nao utukufu wa Mwenyezi Mungu ukawatokea watu wote. ");
INSERT INTO swhonmm_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moto ukaja kutoka kwa uwepo wa Mwenyezi Mungu, ukaiteketeza ile sadaka ya kuteketezwa, pamoja na sehemu ya mafuta yaliyokuwa juu ya madhabahu. Watu wote walipoona jambo hili, wakashangilia kwa furaha na kusujudu. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu na Abihu, wana wa Haruni, wakachukua vyetezo vyao, wakaweka moto ndani yake na kuongeza uvumba; kisha wakamtolea Mwenyezi Mungu moto usio halali, kinyume na agizo la Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hivyo moto ukaja kutoka kwa uwepo wa Mwenyezi Mungu na kuwateketeza, nao wakafa mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kisha Musa akamwambia Haruni, “Hili ndilo alilonena Mwenyezi Mungu, aliposema: “ ‘Miongoni mwa wale watakaonikaribia nitajionesha kuwa mtakatifu; machoni pa watu wote nitaheshimiwa.’ ” Haruni akanyamaza. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa akawaita Mishaeli na Elisafani, wana wa Uzieli mjomba wake Haruni, akawaambia, “Njooni hapa. Ondoeni miili ya ndugu zenu mbele ya mahali patakatifu, mkaipeleke nje ya kambi.” ");
INSERT INTO swhonmm_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Hivyo wakaja na kuwaondoa, wakiwa bado wamevalia makoti yao ya ibada, wakawapeleka nje ya kambi, kama Musa alivyoamuru. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ndipo Musa akamwambia Haruni pamoja na wanawe, Eleazari na Ithamari, “Msifunue vichwa vyenu wala msirarue mavazi yenu, la sivyo mtakufa na Mwenyezi Mungu ataikasirikia jumuiya nzima. Lakini ndugu zenu, nyumba yote ya Israeli, wanaweza kuwaombolezea wale ambao Mwenyezi Mungu amewaangamiza kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Msitoke nje ya ingilio la Hema la Kukutania, la sivyo mtakufa, kwa sababu mafuta ya Mwenyezi Mungu ya upako yako juu yenu.” Hivyo wakafanya kama vile Musa alivyosema. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kisha Mwenyezi Mungu akamwambia Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Wewe na wanao msinywe mvinyo wala kinywaji kingine kilichochachuka wakati mwingiapo katika Hema la Kukutania, la sivyo mtakufa. Hili litakuwa agizo la kudumu kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ni lazima mtenganishe kati ya kilicho kitakatifu na kilicho cha kawaida, kati ya kilicho najisi na kilicho safi, ");
INSERT INTO swhonmm_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","na lazima mwafundishe Waisraeli amri zote ambazo Mwenyezi Mungu aliwapa kupitia Musa.” ");
INSERT INTO swhonmm_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa akamwambia Haruni pamoja na wanawe waliosalia, Eleazari na Ithamari, “Chukueni sadaka ya nafaka iliyobaki kutoka kwa sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto, muile hapo kando ya madhabahu ikiwa imeandaliwa bila chachu, kwa sababu ni takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mtaila katika mahali patakatifu kwa sababu ni fungu lenu na fungu la wana wenu la sadaka zilizotolewa kwa Mwenyezi Mungu kwa moto, kwa maana hivyo ndivyo nilivyoamriwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Lakini wewe na wanao na binti zako mwaweza kula kidari kile kilichoinuliwa na paja lile lililotolewa. Mtavila katika mahali patakatifu; mmepewa wewe na wanao kuwa fungu lenu la sadaka za amani za Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Paja lile lililotolewa na kidari kile kilichoinuliwa lazima viletwe pamoja na sehemu za mafuta ya wanyama wa sadaka za kuteketezwa kwa moto, ili kuinuliwa mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. Hili litakuwa fungu lako na wanao milele, kama Mwenyezi Mungu alivyoagiza.” ");
INSERT INTO swhonmm_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa alipouliza kuhusu mbuzi aliyetolewa sadaka ya dhambi na kugundua kwamba ameteketezwa, aliwakasirikia Eleazari na Ithamari, wana wa Haruni waliobaki. Akawauliza, ");
INSERT INTO swhonmm_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Kwa nini hamkula sadaka ya dhambi katika eneo la mahali patakatifu? Ni takatifu sana. Mlipewa ninyi ili kuondoa hatia ya jumuiya kwa ajili ya kuwafanyia upatanisho mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kwa kuwa damu yake haikuletwa ndani ya Mahali Patakatifu, mngemla mbuzi huyo katika sehemu ya mahali patakatifu kama nilivyoagiza.” ");
INSERT INTO swhonmm_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruni akamjibu Musa, “Leo wanangu wametoa sadaka zao za dhambi na sadaka zao za kuteketezwa mbele za Mwenyezi Mungu, lakini mambo kama haya yamenitokea mimi. Je, Mwenyezi Mungu angependezwa kama ningekuwa nimekula sadaka ya dhambi leo?” ");
INSERT INTO swhonmm_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa aliposikia haya, akaridhika. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Waambieni Waisraeli: ‘Kati ya wanyama wote wanaoishi juu ya nchi, hawa ndio mtakaowala: ");
INSERT INTO swhonmm_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mwaweza kula mnyama yeyote mwenye kwato zilizogawanyika sehemu mbili na ambaye hucheua. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Kuna wanyama wengine ambao hucheua tu au wenye kwato zilizogawanyika tu, lakini hao kamwe msiwale. Ngamia ingawa hucheua, hana kwato zilizogawanyika; huyo ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pelele ingawa hucheua hana kwato zilizogawanyika; huyo ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Sungura ingawa hucheua hana kwato zilizogawanyika; huyo ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Naye nguruwe ingawa anazo kwato zilizogawanyika sehemu mbili, hacheui; huyo ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kamwe msile nyama yao wala kugusa mizoga yao; wao ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Kuhusu viumbe wote wanaoishi ndani ya maji ya bahari na vijito, mtakula wale wote wenye mapezi na magamba. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Lakini viumbe wote ndani ya bahari au vijito wasio na mapezi na magamba, wakiwa miongoni mwa makundi au viumbe wote ndani ya maji, hao ni machukizo kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nao watakuwa machukizo kwenu. Msile nyama yao, nayo mizoga yao itakuwa machukizo. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chochote kinachoishi ndani ya maji ambacho hakina mapezi na magamba kitakuwa chukizo kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Wafuatao ndio ndege watakaokuwa machukizo kwenu, hivyo msiwale kwa sababu ni chukizo: tai, furukombe, kipungu, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mwewe mwekundu, aina zote za mwewe mweusi, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","aina zote za kunguru, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","mbuni, kiruka-njia, dudumizi, kipanga, shakwe, aina zote za kipanga, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bundi, mnandi, bundi mkubwa, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","mumbi, mwari, nderi, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","korongo, koikoi wa aina yoyote, hudihudi na popo. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Wadudu wote warukao ambao hutembea kwa miguu minne watakuwa chukizo kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Lakini kuna viumbe wenye mabawa ambao hutembea kwa miguu minne mtakaowala: wale wenye vifundo katika miguu yao ya kurukaruka juu ya ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Miongoni mwa hawa, mtakula nzige wa aina zote, senene, parare au panzi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Lakini viumbe wengine wote wenye mabawa na wenye miguu minne ni machukizo kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Mtajinajisi kwa wanyama hawa. Yeyote agusaye mizoga yao atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Yeyote atakayebeba mizoga ya viumbe hawa ni lazima afue nguo zake, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Kila mnyama mwenye ukwato ulioachana lakini haukugawanyika kabisa, au yule asiyecheua, huyo ni najisi kwenu; yeyote agusaye mzoga wowote wa hao atakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Miongoni mwa wanyama wote wanaotembea kwa miguu minne, wale wanaotembea kwa vitanga vyao ni najisi kwenu; yeyote agusaye mizoga yao atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Yeyote atakayebeba mizoga yao ni lazima afue nguo zake, naye atakuwa najisi hadi jioni. Wanyama hawa ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Kuhusu wanyama watambaao juu ya ardhi, hawa ni najisi kwenu: kicheche, panya, aina yoyote ya mijusi mikubwa, ");
INSERT INTO swhonmm_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","guruguru, kenge, mijusi ya ukutani, goromoe na kinyonga. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Miongoni mwa wanyama wote wanaotambaa juu ya ardhi, hawa ni najisi kwenu. Yeyote agusaye mizoga yao atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ikiwa mmoja wao atakufa na kuangukia juu ya kitu fulani, chombo hicho, hata kikiwa cha matumizi gani, kitakuwa najisi, kiwe kimetengenezwa kwa mti, nguo, ngozi au gunia. Kiweke ndani ya maji; kitakuwa najisi hadi jioni, kisha kitakuwa safi tena. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ikiwa mmoja wa wanyama aliyekufa ataangukia ndani ya chungu, kila kilichomo katika chungu hicho kitakuwa najisi, nawe ni lazima uvunje chungu hicho. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chakula chochote ambacho chaweza kuliwa lakini kikawa kimeingia maji kutoka chungu hicho ni najisi, na kitu chochote cha majimaji ambacho chaweza kunyweka kutoka chungu hicho ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chochote ambacho mzoga utaangukia kitakuwa najisi. Jiko au chungu cha kupikia ni lazima kivunjwe. Ni najisi, nawe ni lazima uvihesabu kuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lakini chemchemi au kisima, mahali yanapokusanyika maji, patakuwa safi; lakini yeyote atakayegusa moja ya mizoga hii ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kama mzoga ukianguka juu ya mbegu zozote ambazo ni za kupanda, zinabaki safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lakini kama mbegu imetiwa maji na mzoga ukaanguka juu yake, hiyo mbegu ni najisi kwenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Kama mnyama ambaye mnaruhusiwa kumla akifa, yeyote atakayeugusa mzoga wake atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Yeyote atakayekula sehemu ya mzoga huo ni lazima afue nguo zake, naye atakuwa najisi hadi jioni. Yeyote atakayebeba mzoga huo ni lazima afue nguo zake, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Kila kiumbe kinachotambaa juu ya ardhi ni chukizo; kisiliwe. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Msile kiumbe chochote kinachotambaa juu ya ardhi, kiwe kinachotambaa kwa tumbo lake, au kinachotambaa kwa miguu minne au kwa miguu mingi; ni chukizo. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Msijitie unajisi kwa kiumbe chochote kati ya hivi. Msijitie unajisi kwa viumbe hivyo au kutiwa unajisi navyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mimi ndimi Mwenyezi Mungu, Mungu wenu; jitakaseni mwe watakatifu, kwa sababu mimi ni mtakatifu. Msijitie unajisi kwa kiumbe chochote kile kiendacho juu ya ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mimi ndimi Mwenyezi Mungu niliyewapandisha mtoke Misri ili niwe Mungu wenu. Kwa hiyo kuweni watakatifu kwa sababu Mimi ni mtakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Haya ndio masharti kuhusu wanyama, ndege, kila kiumbe hai kiendacho ndani ya maji, na kila kiumbe kiendacho juu ya ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ni lazima mpambanue kati ya kilicho najisi na kilicho safi, kati ya viumbe hai vinavyoweza kuliwa na vile visivyoweza kuliwa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Waambie Waisraeli: ‘Mwanamke ambaye atapata mimba na kuzaa mtoto wa kiume atakuwa najisi kwa siku saba, kama anavyokuwa najisi wakati wa siku zake za hedhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Naye huyo mtoto atatahiriwa siku ya nane. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Kisha ni lazima huyo mwanamke asubiri kwa siku thelathini na tatu, ndipo atakaswe kutoka damu kwake. Hataruhusiwa kugusa kitu chochote kilicho kitakatifu au kuingia mahali patakatifu, hadi siku za kutakaswa kwake zimetimia. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kama alimzaa mtoto wa kike, mwanamke huyo atakuwa najisi kwa majuma mawili, kama wakati wake wa hedhi. Kisha atasubiri kwa siku sitini na sita, ndipo atatakaswa kutoka damu kwake. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Siku zake za utakaso kwa ajili ya mwana au binti zitakapotimia, mwanamke huyo atamletea kuhani kwenye ingilio la Hema la Kukutania mwana-kondoo mwenye umri wa mwaka mmoja kwa ajili ya sadaka ya kuteketezwa, na kinda la njiwa au hua kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Atavitoa mbele za Mwenyezi Mungu ili kufanya upatanisho kwa ajili yake, na kisha atatakasika kutokana na kutokwa na damu. “ ‘Haya ndio masharti kwa ajili ya mwanamke atakayezaa mtoto wa kiume au wa kike. ");
INSERT INTO swhonmm_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kama huyo mwanamke hana uwezo wa kumpata mwana-kondoo, ataleta hua wawili au makinda wawili wa njiwa, mmoja kwa ajili ya sadaka ya kuteketezwa na mwingine kwa ajili ya sadaka ya dhambi. Kwa njia hii, kuhani atafanya upatanisho kwa ajili yake, naye atakuwa safi.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Iwapo mtu yeyote atakuwa na uvimbe, au upele, au alama nyeupe juu ya ngozi yake, ambayo yaweza kuwa ugonjwa wa ngozi wa kuambukiza, ni lazima aletwe kwa kuhani Haruni, au kwa mmoja wa wanawe, hao makuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kuhani atachunguza hicho kidonda kilichopo juu ya ngozi yake, na kama nywele za mahali palipo na kidonda zimebadilika kuwa nyeupe, na ikiwa kidonda kimeingia ndani ya ngozi, basi ni ugonjwa wa ngozi wa kuambukiza, yaani ukoma. Kuhani atakapomchunguza, atamtangaza mtu huyo kuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kama alama juu ya ngozi yake ni nyeupe, lakini haionekani kuingia ndani ya ngozi, na nywele kwenye alama hiyo hazijageuka kuwa nyeupe, kuhani atamtenga mtu aliyeambukizwa kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Siku ya saba, kuhani atamchunguza, na kama hakuona badiliko kwenye kile kidonda na hakijaenea juu ya ngozi, atamtenga kwa siku nyingine saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Siku ya saba kuhani atamchunguza tena, na kama kidonda kimepungua na hakijaenea juu ya ngozi, kuhani atamtangaza mtu huyo kuwa ni safi; ni upele tu. Ni lazima mtu huyo afue mavazi yake, naye atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lakini ikiwa ule upele utaenea katika ngozi yake baada ya yeye kujionesha kwa kuhani na kutangazwa kuwa safi, ni lazima aende tena kwa kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kuhani atamchunguza, na kama upele umeenea kwenye ngozi, atamtangaza kuwa najisi, kwani ni ugonjwa wa ngozi wa kuambukiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Wakati mtu yeyote ana ugonjwa wa ngozi wa kuambukiza, ni lazima aletwe kwa kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kuhani atamchunguza na kama kuna uvimbe mweupe katika ngozi ambao umefanya nywele kuwa nyeupe, na kama kuna nyama mbichi ndani ya uvimbe, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ni ugonjwa sugu wa ngozi, na kuhani atamtangaza kuwa najisi. Hatamtenga tena kwa sababu ni najisi tayari. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Ikiwa ugonjwa utakuwa umeenea kwenye ngozi yake yote kwa kadiri kuhani atakavyoweza kuona, kwamba umeenea kwenye ngozi yote ya huyo mgonjwa kutoka kichwani hadi wayo, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kuhani atamchunguza, na kama ugonjwa umeenea mwili mzima, atamtangaza huyo mtu kuwa safi. Kwa kuwa mwili wote umekuwa mweupe, yeye ni safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lakini itokeapo nyama mbichi kwenye ngozi yake, atakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kuhani atakapoiona hiyo nyama mbichi, atamtangaza mtu huyo kuwa najisi. Hiyo nyama mbichi ni najisi, ana ugonjwa wa kuambukiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Hiyo nyama mbichi ikigeuka na kuwa nyeupe, ni lazima amwendee kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kuhani atamchunguza, na kama vidonda vimekuwa vyeupe, kuhani atamtangaza mgonjwa huyo kuwa safi; kisha atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Wakati mtu ana jipu juu ya ngozi yake nalo likapona, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","napo mahali palipokuwa na jipu pakatokea uvimbe mweupe, au alama yenye wekundu na weupe, ni lazima akajioneshe kwa kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kuhani atapachunguza, na kama uvimbe umeingia ndani ya ngozi, na nywele zimegeuka kuwa nyeupe, kuhani atamtangaza mtu huyo kuwa najisi. Ni ugonjwa wa ngozi wa kuambukiza uliojitokeza pale jipu lilipokuwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lakini ikiwa kuhani anapopachunguza pakawa hapana nywele nyeupe ndani yake, wala hapakuingia ndani ya ngozi, na pameanza kupungua, basi kuhani atamtenga mtu huyo kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kama unaenea kwenye ngozi, kuhani atamtangaza kuwa najisi; ni ugonjwa wa ngozi wa kuambukiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Lakini ikiwa ile alama haijabadilika wala kuenea, ni kovu tu kutokana na jipu, kuhani atamtangaza kuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Wakati mtu ameungua kwenye ngozi yake, pakatokea alama yenye wekundu na weupe, au alama nyeupe ikaonekana penye nyama mbichi pale palipoungua, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kuhani ataichunguza ile alama, na kama nywele zilizo juu yake zimegeuka kuwa nyeupe, na panaonekana kuingia ndani ya ngozi, basi huo ni ugonjwa wa ngozi wa kuambukiza ambao umetokea katika jeraha la moto. Kuhani atamtangaza kuwa najisi; ni ugonjwa wa ngozi wa kuambukiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lakini kuhani akipachunguza na akaona kwamba hakuna nywele nyeupe kwenye alama ile, wala hapakuingia ndani ya ngozi, na pamepungua, basi kuhani atamtenga kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Siku ya saba kuhani atamchunguza tena, na kama unaenea kwenye ngozi, kuhani atamtangaza kuwa najisi; ni ugonjwa wa ngozi wa kuambukiza. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Lakini, kama alama ile haikubadilika na wala haijaenea kwenye ngozi, napo pamepungua, ni uvimbe kutokana na jeraha la moto, na kuhani atamtangaza kuwa safi; ni kovu tu kutokana na kuungua. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ikiwa mwanaume au mwanamke ana kidonda juu ya kichwa au juu ya kidevu, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kuhani atakichunguza kile kidonda, na kama ataona kuwa kimeingia ndani ya ngozi, na nywele zilizo juu yake ni njano na nyembamba, kuhani atamtangaza mtu huyo kuwa najisi; ni ugonjwa wa ngozi wa kuambukiza wa kichwa au kidevu. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Lakini kama kuhani akichunguza aina hii ya kidonda, kionekane kuwa hakijaingia ndani ya ngozi, na hakuna nywele nyeusi juu yake, basi atamtenga mtu huyo kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Siku ya saba kuhani atachunguza kidonda kile, na kama hakijaenea, na hakuna nywele za manjano juu yake, wala haukuingia ndani ya ngozi, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","mtu huyo ni lazima anyolewe, isipokuwa mahali palipo na ugonjwa, naye kuhani atamtenga kwa siku nyingine saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Siku ya saba kuhani atachunguza tena kidonda kile; ikiwa hakijaenea kwenye ngozi na hakikuingia ndani ya ngozi, kuhani atamtangaza kuwa safi. Lazima afue nguo zake, naye atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lakini ikiwa kidonda kitaenea katika ngozi baada ya kutangazwa kuwa safi, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kuhani atamchunguza, na kama kidonda kimeenea kwenye ngozi, kuhani hana haja ya kutazama kama kuna nywele za manjano; mtu huyo ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Hata hivyo, katika uchunguzi wake akiona hapajabadilika, na nywele nyeusi zimeota juu yake, huyo mtu amepona. Yeye si najisi; kuhani atamtangaza kuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ikiwa mwanaume au mwanamke ana alama nyeupe juu ya ngozi yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kuhani atamchunguza, na kama alama hizo zina weupe uliofifia, ni vipele visivyo na madhara vilivyojitokeza kwenye ngozi; mtu huyo ni safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Wakati mwanaume hana nywele naye ana upara, yeye ni safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ikiwa hana nywele kwenye ngozi ya kichwa chake, na ana upara kwenye paji, ni safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lakini kama ana kidonda chenye wekundu na weupe kwenye kichwa chake chenye upara, au kwenye paji la uso, ni ugonjwa wa ngozi wa kuambukiza unaojitokeza kichwani au kwenye paji lake la uso. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kuhani atamchunguza, na kama kidonda kilichovimba juu ya kichwa chake au kwenye paji la uso ni chekundu au cheupe kama ugonjwa wa ngozi wa kuambukiza, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","mtu huyo ni mgonjwa, na ni najisi. Kuhani atamtangaza kuwa najisi kwa sababu ya kidonda kwenye kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Mtu mwenye ugonjwa kama huo wa kuambukiza ni lazima avae nguo zilizoraruka, awachilie nywele zake bila kuzichana, afunike sehemu ya chini ya uso wake, na apige kelele, ‘Najisi! Najisi!’ ");
INSERT INTO swhonmm_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kwa muda wote atakaokuwa na ugonjwa huo wa kuambukiza atabaki kuwa najisi. Ni lazima aishi peke yake; ni lazima aishi nje ya kambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kuhusu vazi lolote lililoharibiwa na maambukizo ya ukoma, liwe ni vazi la sufu au kitani, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","vazi lolote lililofumwa au kusokotwa la kitani au sufu, ngozi yoyote au chochote kilichotengenezwa kwa ngozi: ");
INSERT INTO swhonmm_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ikiwa maambukizo kwenye vazi, ngozi, au vazi lililofumwa au kusokotwa la kitani au sufu, au kitu chochote cha ngozi, ni rangi ya kijani au nyekundu, huo ni ukoma unaoenea, na ni lazima kuhani aoneshwe. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kuhani atachunguza ukoma huo na kulitenga vazi hilo kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Siku ya saba atalichunguza, na kama ukoma umeenea kwenye vazi, au vazi lililofumwa au kusokotwa, au ngozi, kwa vyovyote vile itumikavyo, ni ukoma wa kuangamiza; vazi hilo ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ni lazima achome vazi hilo, liwe ni la sufu au kitani kilichofumwa au kusokotwa, au kitu chochote cha ngozi chenye maambukizo; kwa kuwa ni ukoma wa kuangamiza, vazi lote ni lazima lichomwe moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Lakini kuhani akilichunguza na akaona kuwa ule ukoma haujaenea kwenye vazi, au vazi lililofumwa au kusokotwa, au kitu cha ngozi, ");
INSERT INTO swhonmm_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ataagiza kwamba vazi lenye maambukizo lisafishwe. Kisha atalitenga kwa siku nyingine saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Baada ya vazi lenye maambukizo kusafishwa, kuhani atalichunguza, na kama ukoma haujaonesha badiliko lolote, hata kama haujaenea, ni najisi. Lichome kwa moto, iwe ukoma umeenea upande mmoja au mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kama kuhani ataona kuwa ile alama imefifia baada ya kuoshwa, basi atararua sehemu iliyoambukizwa ya vazi, au ngozi, au vazi lililofumwa au kusokotwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Lakini ikijitokeza tena kwenye vazi, au vazi lililofumwa au kusokotwa, ama kitu cha ngozi, ule ni ukoma unaoenea; chochote chenye ukoma ni lazima kichomwe kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Vazi, au vazi lililofumwa au kusokotwa, au kitu chochote cha ngozi, baada ya kusafishwa na kuondolewa ukoma, ni lazima lioshwe tena, ili liwe safi.” ");
INSERT INTO swhonmm_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Haya ndio masharti kuhusu maambukizo ya ukoma kwenye mavazi ya sufu au kitani, mavazi yaliyofumwa au kusokotwa, ama kitu chochote cha ngozi, kwa ajili ya kuvitangaza kuwa safi au najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Haya ndio masharti yanayomhusu mtu mgonjwa wakati wa ibada yake ya utakaso, anapoletwa kwa kuhani: ");
INSERT INTO swhonmm_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kuhani ataenda kumchunguza nje ya kambi. Kama mtu huyo atakuwa amepona ugonjwa wake wa ngozi wa kuambukiza, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","kuhani ataagiza vitu vifuatavyo viletwe kwa ajili ya mtu atakayetakaswa: ndege wawili safi walio hai, mti wa mwerezi, kitani nyekundu, na hisopo. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kisha kuhani ataagiza kwamba mmoja wa ndege wale achinjwe kwenye chungu chenye maji safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kisha kuhani atamchukua ndege aliye hai na kumtumbukiza pamoja na mti wa mwerezi, kitani nyekundu na hisopo ndani ya damu ya yule ndege aliyechinjiwa kwenye maji safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Atamnyunyizia yule mwenye ugonjwa wa kuambukiza maji hayo mara saba, na kumtangaza kuwa safi. Kisha atamwachia yule ndege aliye hai aende zake kwenye mashamba. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Huyo mtu atakayetakaswa ni lazima afue nguo zake, anyoe nywele zake zote, na aoge kwa maji; ndipo atakapotakasika. Baada ya hili anaweza kuingia kambini, lakini ni lazima akae nje ya hema lake kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Siku ya saba ni lazima anyoe nywele zake zote; yaani anyoe nywele za kichwa, ndevu zake, kope zake na nywele nyingine zote. Ni lazima afue nguo zake, na aoge kwa maji, naye atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Siku ya nane, ni lazima alete kondoo dume wawili na kondoo jike mmoja, wote wa mwaka mmoja na wasio na dosari, pamoja na sehemu tatu za kumi ya efa ya unga laini uliochanganywa na mafuta, kwa ajili ya sadaka ya nafaka, na logi moja ya mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kuhani anayemtangaza kuwa safi atamkabidhi mtu huyo atakayetakaswa pamoja na sadaka zake zote mbele za Mwenyezi Mungu katika ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Kisha kuhani atamchukua mmoja wa wale kondoo dume na kumtoa kuwa sadaka ya hatia, pamoja na ile logi moja ya mafuta; ataviinua mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Atamchinja huyo kondoo katika mahali patakatifu ambapo sadaka ya dhambi na ile ya kuteketezwa huchinjiwa. Kama ilivyo sadaka ya dhambi, sadaka ya hatia ni ya kuhani; ni takatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kuhani atachukua sehemu ya damu ya sadaka ya hatia na kuitia kwenye ncha ya sikio la kuume la yule atakayetakaswa, kwenye kidole gumba cha mkono wake wa kuume, na kidole kikubwa cha mguu wake wa kuume. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kisha kuhani atachukua sehemu ya ile logi ya mafuta, ayamimine kwenye kiganja cha mkono wake mwenyewe wa kushoto, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","na achovye kidole chake cha shahada cha mkono wake wa kuume kwenye mafuta yaliyo kwenye kiganja chake, na kwa kidole hicho anyunyize mafuta hayo mara saba mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kuhani atampaka yule anayetakaswa sehemu ya mafuta yaliyobaki kiganjani kwenye ncha ya sikio lake la kuume, kwenye kidole gumba cha mkono wake wa kuume, na kidole kikubwa cha mguu wake wa kuume, mahali palepale alipompaka damu ya sadaka ya kuondoa hatia. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kuhani atayapaka mafuta yaliyobaki kwenye kiganja chake juu ya kichwa cha yule anayetakaswa, na kufanya upatanisho kwa ajili yake mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Kisha kuhani atatoa dhabihu ya sadaka ya dhambi na kufanya upatanisho kwa ajili ya yule atakayetakaswa kutoka unajisi wake. Baada ya hayo, kuhani atachinja sadaka ya kuteketezwa ");
INSERT INTO swhonmm_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","na kuitoa juu ya madhabahu, pamoja na sadaka ya nafaka ili kumfanyia upatanisho, naye atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Hata hivyo, kama ni maskini na hawezi kupata vitu hivi, lazima achukue mwana-kondoo wa kiume mmoja kuwa sadaka ya hatia ipate kuinuliwa ili kumfanyia upatanisho, pamoja na sehemu ya kumi ya efa ya unga laini uliochanganywa na mafuta kwa ajili ya sadaka ya nafaka, logi moja ya mafuta, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","na hua wawili au makinda wawili wa njiwa, kile atakachoweza kupata, mmoja kwa sadaka ya dhambi, na mwingine kwa sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Katika siku ya nane, lazima avilete vitu hivyo kwa kuhani, kwa ajili ya kutakaswa kwake kwenye ingilio la Hema la Kukutania mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kuhani atamchukua mwana-kondoo kwa ajili ya sadaka ya hatia, pamoja na ile logi ya mafuta ya kuinuliwa mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Atamchinja huyo mwana-kondoo kwa ajili ya sadaka ya hatia. Kisha ataichukua sehemu ya damu yake na kuipaka kwenye ncha ya sikio la kuume la yule anayetakaswa, na aipake pia kwenye kidole gumba cha mkono wa kuume wa huyo mtu, na kidole kikubwa cha mguu wake wa kuume. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kuhani atamiminia sehemu ya mafuta kwenye kiganja chake cha mkono wa kushoto, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na kwa kidole chake cha shahada cha mkono wa kuume, atamnyunyizia yule anayetakaswa yale mafuta yaliyo kwenye kiganja chake mara saba mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Atampaka mafuta yaliyobaki kwenye kiganja chake katika sehemu zote, kama alivyompaka damu ya sadaka ya hatia: yaani kwenye ncha ya sikio la kuume la yule anayetakaswa, kwenye kidole gumba cha mkono wake wa kuume, na kidole kikubwa cha mguu wake wa kuume. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kuhani atayapaka mafuta yaliyobaki katika kiganja chake kwenye kichwa cha yule anayetakaswa, na kufanya upatanisho kwa ajili yake mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Kisha atatoa dhabihu wale hua ama makinda wa njiwa ambao yule mtu ataweza kuwapata, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","mmoja kwa ajili ya sadaka ya dhambi, na mwingine kuwa sadaka ya kuteketezwa, pamoja na sadaka ya nafaka. Kwa njia hii kuhani atafanya upatanisho mbele za Mwenyezi Mungu kwa ajili ya yule anayetakaswa.” ");
INSERT INTO swhonmm_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Haya ndio masharti kwa mtu yeyote mwenye ugonjwa wa ngozi wa kuambukiza, na ambaye hana uwezo wa kutoa sadaka za kawaida kwa ajili ya kutakaswa kwake. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Mtakapoingia katika nchi ya Kanaani ninayowapa kuwa milki yenu, nami nikaweka ukoma unaoenea kwenye nyumba katika nchi ile, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ni lazima mwenye nyumba hiyo akamwambie kuhani, ‘Nimeona kitu fulani kinachofanana na ukoma kwenye nyumba yangu.’ ");
INSERT INTO swhonmm_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kuhani ataagiza vitu vyote vitolewe ndani ya nyumba, kabla hajaenda kuchunguza kama ina ukoma huo, ili kitu chochote ndani ya nyumba kisitangazwe kuwa najisi. Baada ya hili, kuhani ataingia ndani na kuikagua hiyo nyumba. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Atachunguza ukoma huo katika kuta za nyumba hiyo, nazo kama zina rangi ya kijani kibichi au wekundu, na kuna mibonyeo ndani ya ukuta, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","kuhani atatoka na kufunga mlango wa nyumba hiyo kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Siku ya saba, kuhani atarudi kuikagua nyumba. Kama ukoma umeenea juu ya kuta, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ataagiza kwamba mawe yote yaliyoambukizwa yaondolewe na kutupwa katika eneo lililo najisi nje ya mji. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kuta zote za ndani ya nyumba hiyo ni lazima zikwanguliwe, na kifusi chake kitupwe mahali najisi nje ya mji. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Kisha watachukua mawe mengine na kujenga palipobomolewa kwa udongo mpya wa mfinyanzi, na wapake nyumba hiyo chokaa. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ikiwa ukoma huo utatokea tena ndani ya ile nyumba baada ya mawe kuondolewa, na nyumba kukwanguliwa na kupakwa chokaa, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kuhani ataenda kuikagua, na kama ukoma umeenea ndani ya nyumba, basi ni ukoma unaoharibu; nyumba hiyo ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ni lazima ibomolewe: mawe yake, mbao na chokaa yote; vyote vikatupwe nje ya mji mahali palipo najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Yeyote atakayeingia katika nyumba hiyo ikiwa imefungwa, atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Yeyote atakayelala au kula ndani ya nyumba hiyo ni lazima afue nguo zake. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Lakini ikiwa kuhani atakuja kuikagua na kukuta kuwa ukoma haujaenea tena baada ya nyumba kupakwa chokaa, ataitangaza nyumba ile kuwa safi, kwa sababu ukoma umekwisha. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ili kuitakasa nyumba hiyo, mwenye nyumba ataleta ndege wawili, mti wa mwerezi, kitani nyekundu na hisopo. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Atamchinja mmoja wa wale ndege kwenye chungu chenye maji safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kisha atachukua mti wa mwerezi, hisopo, kitani nyekundu na ndege aliye hai, na kuvitumbukiza ndani ya damu ya ndege aliyechinjwa pamoja na maji safi, na kuinyunyizia nyumba ile mara saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ataitakasa nyumba kwa damu ya yule ndege, maji safi, ndege aliye hai, mti wa mwerezi, hisopo na uzi mwekundu. ");
INSERT INTO swhonmm_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kisha atamwachia yule ndege aliye hai huru mashambani nje ya mji. Kwa njia hii atafanya upatanisho kwa ajili ya nyumba ile, nayo itakuwa safi.” ");
INSERT INTO swhonmm_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Haya ndio masharti kuhusu aina yoyote ya ugonjwa wa ngozi wa kuambukiza, kidonda chochote, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ukoma katika vazi au ndani ya nyumba, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kwa uvimbe, upele, au alama nyeupe katika ngozi, ");
INSERT INTO swhonmm_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kupambanua wakati kitu fulani ni safi au najisi. Haya ndio masharti kuhusu magonjwa ya ngozi ya kuambukiza na ukoma. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Semeni na Waisraeli mwaambie: ‘Mtu yeyote anapotokwa na usaha mwilini, usaha huo ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Iwe unaendelea kutiririka kutoka mwilini mwake au umeziba, utamfanya najisi. Hivi ndivyo usaha wake utakavyomletea unajisi: ");
INSERT INTO swhonmm_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Kitanda chochote atakacholalia mtu mwenye kutokwa na usaha kitakuwa najisi, na chochote atakachokalia kitakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Yeyote atakayegusa kitanda chake ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Yeyote atakayeketi juu ya kitu chochote alichokalia mwenye kutokwa na usaha, ni lazima afue nguo zake, na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Yeyote atakayemgusa mtu mwenye kutokwa na usaha, ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Ikiwa mtu mwenye kutokwa na usaha atamtemea mate mtu ambaye ni safi, mtu huyo ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Kila tandiko ambalo mtu huyo atalikalia wakati wa kupanda mnyama litakuwa najisi, ");
INSERT INTO swhonmm_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","na yeyote atakayegusa kitu chochote alichokuwa amekalia atakuwa najisi hadi jioni. Yeyote atakayeinua vitu hivyo ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Yeyote atakayeguswa na mtu anayetokwa na usaha bila kunawa mikono yake kwa maji, ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Chungu cha udongo kitakachoguswa na mtu huyo ni lazima kivunjwe, na kifaa chochote cha mbao kitaoshwa kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Mtu atakapotakasika kutoka usaha wake, atahesabu siku saba kwa utakaso wake. Ni lazima afue nguo zake na aoge kwa maji safi, naye atatakasika. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Siku ya nane, atachukua hua wawili au makinda wawili wa njiwa, aje mbele za Mwenyezi Mungu kwenye ingilio la Hema la Kukutania, na kumpa kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kuhani atawatoa dhabihu, mmoja kwa ajili ya sadaka ya dhambi, na huyo mwingine kwa ajili ya sadaka ya kuteketezwa. Kwa njia hii atafanya upatanisho mbele za Mwenyezi Mungu kwa ajili ya huyo mtu kwa sababu ya kutokwa usaha kwake. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Mtu akitokwa na shahawa, ni lazima aoge mwili mzima kwa maji, na atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Vazi lolote ama ngozi yoyote yenye shahawa juu yake ni lazima ioshwe kwa maji, na itakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ikiwa mtu atalala na mwanamke, na kukawa na kutoka kwa shahawa, ni lazima wote waoge kwa maji, nao watakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Ikiwa mwanamke atatokwa na damu ya kawaida ya mwezi, atakuwa najisi kwa siku saba, na yeyote atakayemgusa atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Chochote atakacholalia wakati wake wa hedhi kitakuwa najisi, na chochote atakachokikalia kitakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Yeyote atakayegusa kitanda chake ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Yeyote atakayegusa chochote atakachokalia ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kiwe ni kitanda ama chochote alichokuwa amekikalia, ikiwa mtu yeyote atakigusa, atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Ikiwa mwanaume atalala naye na ile damu ya mwezi ikamgusa, atakuwa najisi kwa siku saba; kitanda chochote atakachokilalia huyo mwanaume kitakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Ikiwa mwanamke atatokwa na damu kwa siku nyingi zaidi ya siku zake za mwezi, au amekuwa na damu inayoendelea zaidi ya kipindi chake, atakuwa najisi kwa kipindi chote cha shida hiyo, kama ilivyokuwa katika siku za hedhi yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kitanda chochote atakachokilalia huyo mwanamke wakati anaendelea kutokwa na damu kitakuwa najisi, kama kilivyokuwa kitanda chake wakati wa siku zake za hedhi, na chochote atakachokalia kitakuwa najisi, kama wakati wake wa hedhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Yeyote agusaye vitu hivyo atakuwa najisi; ni lazima afue nguo zake na kuoga kwa maji, naye atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Atakapotakasika kutoka hedhi yake, ni lazima ahesabu siku saba, na baada ya hapo atakuwa ametakasika kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Siku ya nane ni lazima achukue hua wawili au makinda wawili wa njiwa, na kumletea kuhani kwenye mlango wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kuhani atatoa dhabihu, mmoja kwa ajili ya sadaka ya dhambi, na huyo mwingine kwa ajili ya sadaka ya kuteketezwa. Kwa njia hii, atafanya upatanisho kwa ajili yake mbele za Mwenyezi Mungu kwa sababu ya unajisi wa kutokwa damu kwake. ");
INSERT INTO swhonmm_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Ni lazima uwatenge Waisraeli kutokana na vitu ambavyo vinawafanya najisi, ili wasife katika unajisi wao kwa kunajisi makao yangu yaliyo katikati yao.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Haya ni masharti kwa ajili ya mtu mwenye kutokwa na usaha, kwa ajili ya yeyote atakayetokwa na shahawa, ");
INSERT INTO swhonmm_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kwa ajili ya mwanamke katika siku zake za hedhi, kwa ajili ya mwanaume au mwanamke atokwaye na usaha, na kwa ajili ya mwanaume alalaye na mwanamke ambaye ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mwenyezi Mungu akasema na Musa baada ya kifo cha wale wana wawili wa Haruni waliokufa walipokaribia mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mwenyezi Mungu akamwambia Musa: “Mwambie ndugu yako Haruni asije wakati wowote anaotaka ndani ya Patakatifu pa Patakatifu, nyuma ya pazia pale mbele ya kiti cha rehema kile kilicho juu ya Sanduku la Agano, la sivyo atakufa, kwa sababu huwa ninatokea ndani ya wingu juu ya kile kiti cha rehema. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Hivi ndivyo Haruni atakavyoingia katika Mahali Patakatifu: atachukua fahali mchanga kwa ajili ya sadaka ya dhambi, na kondoo dume kwa ajili ya sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Atavaa koti takatifu la kitani, pamoja na nguo za ndani za kitani; atafunga mshipi wa kitani kiunoni, na kuvaa kilemba cha kitani. Haya ni mavazi matakatifu, kwa hiyo ni lazima aoge kwa maji kabla ya kuyavaa mavazi hayo. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Atachukua beberu wawili kutoka kwa jumuiya ya Israeli kwa ajili ya sadaka ya dhambi, na kondoo dume kwa ajili ya sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Haruni atamtoa huyo fahali kwa ajili ya sadaka yake ya dhambi ili afanye upatanisho kwa ajili yake mwenyewe na nyumba yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Kisha atawachukua wale beberu wawili na kuwaleta mbele za Mwenyezi Mungu kwenye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Haruni atapiga kura kwa ajili ya hao mbuzi wawili, mmoja kwa ajili ya Mwenyezi Mungu na mwingine kwa ajili ya kubebeshwa dhambi za Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haruni atamleta yule mbuzi ambaye kura ya Mwenyezi Mungu imemwangukia na kumtoa dhabihu kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Lakini mbuzi aliyechaguliwa kwa kura kuwa wa kubebeshwa dhambi atatolewa akiwa hai mbele za Mwenyezi Mungu, atumike kwa kufanya upatanisho kwa kumwacha aende jangwani akiwa amebebeshwa dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Haruni atamleta yule fahali kwa ajili ya sadaka ya dhambi yake mwenyewe, ili kufanya upatanisho kwa ajili yake na nyumba yake, naye atamchinja huyo fahali kwa ajili ya sadaka ya dhambi yake mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Atachukua chetezo kilichojaa makaa yanayowaka kutoka madhabahuni mbele za Mwenyezi Mungu, na konzi mbili za uvumba laini uliosagwa vizuri wenye harufu, na kuvipeleka nyuma ya pazia. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ataweka uvumba juu ya moto mbele za Mwenyezi Mungu, na moshi wa uvumba utafunika kile kiti cha rehema kilicho juu ya Ushuhuda, ili asife. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Atachukua sehemu ya damu ya fahali, na kwa kidole chake atanyunyiza sehemu ya mbele ya kiti cha rehema; kisha atanyunyiza sehemu ya hiyo damu kwa kidole chake mara saba mbele ya kiti cha rehema. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Kisha atamchinja mbuzi wa sadaka ya dhambi kwa ajili ya watu, na kuichukua damu yake nyuma ya pazia, na aifanyie kama alivyofanya kwa damu ya fahali: Atanyunyiza juu ya kiti cha rehema na mbele yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kwa njia hii atafanya upatanisho kwa ajili ya Patakatifu pa Patakatifu kwa sababu ya unajisi na uasi wa Waisraeli, kwa dhambi zao zozote. Atafanya hivyo kwa ajili ya Hema la Kukutania, ambalo liko miongoni mwao katikati ya unajisi wao. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mtu yeyote haruhusiwi kuwa ndani ya Hema la Kukutania, kuanzia wakati Haruni anapoingia kufanya upatanisho katika Patakatifu pa Patakatifu, hadi atakapotoka nje, baada ya kujifanyia upatanisho yeye mwenyewe na nyumba yake, pamoja na jumuiya yote ya Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Kisha atatoka aje kwenye madhabahu yaliyo mbele za Mwenyezi Mungu na kufanya upatanisho kwa ajili yake. Atachukua sehemu ya damu ya fahali na sehemu ya damu ya mbuzi, na kuiweka kwenye pembe za madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Atanyunyiza sehemu ya hiyo damu juu ya madhabahu kwa kidole chake mara saba, ili kuitakasa na kuiweka wakfu kutokana na unajisi wa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Haruni atakapokuwa amemaliza kufanya upatanisho kwa ajili ya Patakatifu pa Patakatifu, Hema la Kukutania na madhabahu, atamleta mbele yule mbuzi aliye hai. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruni ataweka mikono yake miwili juu ya kichwa cha mbuzi aliye hai, na kuungama juu yake uovu wote na uasi wa Waisraeli, yaani dhambi zao zote, ili kuziweka juu ya kichwa cha huyo mbuzi. Atamwachia huyo mbuzi akimbilie jangwani kwa uangalizi wa mtu aliyepewa wajibu huo. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Yule mbuzi atachukua juu yake dhambi zao zote hadi mahali pasipo na watu; naye yule mtu atamwachia akimbilie jangwani. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Kisha Haruni ataenda ndani ya Hema la Kukutania na kuvua yale mavazi ya kitani aliyoyavaa kabla ya kuingia katika Patakatifu pa Patakatifu, naye atayaacha pale. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ataoga kwa maji katika mahali patakatifu na kuvaa mavazi yake ya kawaida. Kisha atatoka na kutoa dhabihu ya sadaka ya kuteketezwa kwa ajili yake na sadaka ya kuteketezwa kwa ajili ya watu, ili kufanya upatanisho kwa ajili yake mwenyewe, na kwa ajili ya watu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Pia atachoma mafuta ya mnyama wa sadaka ya dhambi juu ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Yule mtu anayemwachia yule mbuzi wa kubebeshwa dhambi ni lazima afue nguo zake na kuoga kwa maji; baadaye anaweza kuingia kambini. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Yule fahali na mbuzi waliotolewa kwa ajili ya sadaka za dhambi, ambao damu yao ilikuwa imeletwa Patakatifu pa Patakatifu kwa ajili ya kufanya upatanisho, ni lazima watolewe nje ya kambi. Ngozi zao, nyama, na matumbo vitateketezwa kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Mtu atakayevichoma ni lazima afue nguo zake na aoge kwa maji; baadaye ataweza kuingia kambini. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Hili litakuwa agizo la kudumu kwa ajili yenu: Katika siku ya kumi ya mwezi wa saba ni lazima mfunge, wala msifanye kazi yoyote, iwe mzawa au mgeni anayeishi miongoni mwenu, ");
INSERT INTO swhonmm_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","kwa sababu siku hii upatanisho utafanyika kwa ajili yenu ili kuwatakasa. Kisha mtakuwa safi mbele za Mwenyezi Mungu kutokana na dhambi zenu zote. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ni Sabato ya mapumziko, na lazima mfunge; ni agizo la kudumu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kuhani ambaye amepakwa mafuta na kuwekwa wakfu ili kuingia mahali pa baba yake kama kuhani mkuu atafanya upatanisho. Atavaa mavazi matakatifu ya kitani, ");
INSERT INTO swhonmm_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na kufanya upatanisho kwa ajili ya Patakatifu pa Patakatifu, Hema la Kukutania na madhabahu, na pia kwa ajili ya makuhani, pamoja na jumuiya yote ya watu. ");
INSERT INTO swhonmm_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Hili litakuwa agizo la kudumu kwa ajili yenu: Upatanisho utafanywa mara moja tu kwa mwaka kwa ajili ya dhambi zote za Waisraeli.” Ndivyo ilivyofanyika, kama vile Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Sema na Haruni na wanawe, pamoja na Waisraeli wote, uwaambie: ‘Hili ndilo Mwenyezi Mungu aliloagiza: ");
INSERT INTO swhonmm_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mwisraeli yeyote atakayetoa dhabihu ya ng’ombe, mwana-kondoo au mbuzi ndani ya kambi au nje yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","badala ya kuileta kwenye ingilio la Hema la Kukutania ili kuileta kama sadaka kwa Mwenyezi Mungu mbele ya Maskani ya Mwenyezi Mungu, mtu huyo atahesabiwa kuwa na hatia ya kumwaga damu; amemwaga damu, na ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hii ni ili Waisraeli wamletee Mwenyezi Mungu dhabihu wanazozifanya sasa mahali pa wazi mashambani. Ni lazima wazilete kwa makuhani, yaani kwa Mwenyezi Mungu, katika ingilio la Hema la Kukutania, na kutoa dhabihu kuwa sadaka za amani. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kuhani atanyunyiza damu kwenye madhabahu ya Mwenyezi Mungu katika ingilio la Hema la Kukutania, na kuyateketeza mafuta ya hiyo dhabihu kuwa harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kamwe wasitoe tena dhabihu zao kwa sanamu za mbuzi ambazo wamekuwa wakijifanyia nazo ukahaba. Hili litakuwa agizo la kudumu kwao na kwa vizazi vijavyo.’ ");
INSERT INTO swhonmm_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Waambie: ‘Mwisraeli yeyote au mgeni yeyote anayeishi miongoni mwao atakayetoa sadaka ya kuteketezwa au dhabihu ");
INSERT INTO swhonmm_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","bila kuileta kwenye ingilio la Hema la Kukutania ili kutoa dhabihu kwa Mwenyezi Mungu, mtu huyo ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Mwisraeli yeyote au mgeni anayeishi miongoni mwao ambaye atakula damu yoyote, nitakuwa kinyume chake, na nitamkatilia mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kwa kuwa uhai wa kiumbe uko ndani ya damu, nami nimewapa hiyo damu ili mfanyie upatanisho kwa ajili yenu wenyewe juu ya madhabahu; damu ndiyo ifanyayo upatanisho kwa ajili ya maisha ya mtu. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kwa hiyo, ninawaambia Waisraeli, “Hakuna hata mmoja wenu anayeruhusiwa kula damu, wala mgeni anayeishi miongoni mwenu haruhusiwi kula damu.” ");
INSERT INTO swhonmm_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Mwisraeli yeyote au mgeni anayeishi miongoni mwenu ambaye atamwinda mnyama au ndege anayeruhusiwa kuliwa ni lazima aimwage damu na kuifunika kwa udongo, ");
INSERT INTO swhonmm_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","kwa sababu uhai wa kila kiumbe ni damu yake. Ndiyo sababu nimewaambia Waisraeli, “Kamwe msile damu ya kiumbe chochote, kwa sababu uhai wa kila kiumbe ni damu yake; yeyote atakayekula damu lazima akatiliwe mbali.” ");
INSERT INTO swhonmm_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Mtu yeyote, awe mzawa au mgeni, ambaye atakula mzoga wa kitu chochote ama kilichouawa na wanyama mwitu ni lazima afue nguo zake na aoge kwa maji, naye atakuwa najisi hadi jioni; kisha atakuwa ametakaswa. ");
INSERT INTO swhonmm_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Lakini kama hakufua nguo zake na kuoga, atakuwa na hatia kwa kosa hilo.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Sema na Waisraeli uwaambie: ‘Mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Msifanye kama wafanyavyo huko Misri, mahali mlipokuwa mnaishi, wala msifanye kama wanavyofanya katika nchi ya Kanaani, mahali ninapowapeleka. Msifuate matendo yao. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ni lazima mzitii sheria zangu, na mwe waangalifu kuzifuata amri zangu. Mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Zishikeni amri zangu na sheria zangu, kwa maana mtu anayezitii ataishi kwa hizo. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Hakuna mtu yeyote atakayemsogelea ndugu wa karibu ili kukutana naye kimwili. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Usimvunjie heshima baba yako kwa kukutana kimwili na mama yako. Yeye ni mama yako; usiwe na mahusiano kama hayo naye. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Usikutane kimwili na mke wa baba yako; hiyo itamvunjia heshima baba yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Usikutane kimwili na dada yako, wala binti ya baba yako, au binti ya mama yako, awe amezaliwa katika nyumba hiyo au mahali pengine. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Usikutane kimwili na binti ya mwanao ama binti ya binti yako; utajivunjia heshima. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Usikutane kimwili na binti ya mke wa baba yako, aliyezaliwa na baba yako; huyo ni dada yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Usikutane kimwili na dada wa baba yako; ni ndugu wa karibu wa baba yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Usikutane kimwili na dada wa mama yako, kwa sababu ni ndugu wa mama yako wa karibu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Usimvunjie heshima ndugu wa baba yako, kwa kukutana kimwili na mke wake; yeye ni shangazi yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Usikutane kimwili na mkwe wako, yeye ni mke wa mwanao; usiwe na mahusiano kama hayo naye. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Usikutane kimwili na mke wa kaka yako; utamvunjia heshima kaka yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Usikutane kimwili na mwanamke kisha na binti yake. Usikutane kimwili na binti ya mwanawe au binti ya binti yake; hao ni ndugu zake wa karibu. Huo ni uovu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Usimchukue dada wa mke wako kuwa mke mwenza, na kukutana naye kimwili wakati bado mke wako anaishi. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Usimsogelee mwanamke ili kukutana naye kimwili wakati wa unajisi wa siku zake za mwezi. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Usikutane kimwili na mke wa jirani yako na kujitia naye unajisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Usimtoe kafara mtoto wako yeyote kwa Moleki, kwani hutalinajisi kamwe jina la Mungu wako. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Usikutane kimwili na mwanaume vile mwanaume anavyokutana kimwili na mwanamke; hilo ni chukizo. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Usikutane kimwili na mnyama na kujitia unajisi kwake. Mwanamke asijipeleke kwa mnyama ili kukutana naye kimwili; huo ni upotovu. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Msijitie unajisi kwa njia yoyote katika hizi, kwa sababu hivi ndivyo mataifa nitakayoyafukuza mbele yenu yalivyojitia unajisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Hata nchi ilitiwa unajisi, hivyo nikaiadhibu kwa dhambi zake, nayo nchi ikawatapika wakazi wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Lakini ni lazima mzitunze amri zangu na sheria zangu. Wazawa na wageni wanaoishi miongoni mwenu kamwe wasifanye mambo yoyote ya machukizo haya, ");
INSERT INTO swhonmm_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","kwa kuwa mambo haya yote yalifanywa na watu walioishi katika nchi hii kabla yenu, na nchi ikawa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Mkiinajisi nchi, itawatapika kama ilivyowatapika mataifa yaliyowatangulia. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Kila mtu atakayefanya mojawapo ya machukizo haya, watu hao ni lazima wakatiliwe mbali na watu wao. ");
INSERT INTO swhonmm_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Shikeni maagizo yangu, wala msifuate desturi za machukizo yoyote yaliyofanywa kabla hamjafika katika nchi hii, na kujitia unajisi kwa hayo. Mimi ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Sema na kusanyiko lote la Waisraeli, uwaambie: ‘Kuweni watakatifu, kwa kuwa mimi, Mwenyezi Mungu, Mungu wenu, ni mtakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Kila mmoja wenu ni lazima amheshimu mama yake na baba yake, na pia ni lazima kuzishika Sabato zangu. Mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Msiabudu sanamu, wala msijitengenezee miungu ya kusubu. Mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Mnapotoa dhabihu ya sadaka ya amani kwa Mwenyezi Mungu, toeni kwa namna ambayo itakubaliwa kwa niaba yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Sadaka hiyo italiwa siku hiyo hiyo mnayoitoa, au kesho yake; chochote kitakachobaki hadi siku ya tatu lazima kiteketezwe kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kama sehemu yoyote ya sadaka hiyo italiwa siku ya tatu, itakuwa si safi, nayo haitakubaliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Yeyote atakayekula atawajibishwa, kwa sababu amenajisi kitu kilicho kitakatifu kwa Mwenyezi Mungu; mtu huyo lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Unapovuna mavuno ya nchi yako, usivune hadi kwenye mipaka ya shamba lako, wala usikusanye mabaki ya mavuno yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Usirudi mara ya pili katika shamba lako la mizabibu, wala usiokote zabibu zilizoanguka chini. Ziache kwa ajili ya maskini na mgeni. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Usiibe. “ ‘Usiseme uongo. “ ‘Msidanganyane. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Usiape kwa uongo kwa Jina langu, na hivyo kulinajisi jina la Mungu wako. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Usimdhulumu wala kumwibia jirani yako. “ ‘Usishikilie mshahara wa kibarua usiku kucha hadi asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Usimlaani kiziwi, wala usiweke kikwazo mbele ya kipofu, lakini umche Mungu wako. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Usipotoshe haki; usioneshe kumpendelea maskini, wala upendeleo kwa mwenye cheo, bali mwamulie jirani yako kwa haki. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Usieneze uchochezi miongoni mwa watu wako. “ ‘Usifanye kitu chochote kile kinachohatarisha maisha ya jirani yako. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Usimchukie ndugu yako moyoni mwako. Karipia jirani yako kwa uwazi ili usishiriki hatia yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Usijilipizie kisasi wala kuwa na kinyongo dhidi ya mmoja wa jamaa yako, lakini mpende jirani yako kama unavyojipenda mwenyewe. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Mtazishika amri zangu. “ ‘Usiwaache mifugo wako wakazaana na wa aina tofauti. “ ‘Usipande mbegu za aina mbili katika shamba lako. “ ‘Usivae vazi lililofumwa kwa nyuzi za aina mbili tofauti. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Kama mwanaume anakutana kimwili na mjakazi aliyeposwa na mwanaume mwingine, ambaye hajakombolewa wala hajapewa uhuru, lazima iwepo adhabu inayofaa. Hata hivyo hawatauawa, kwa sababu msichana alikuwa bado hajaachwa huru. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Lakini huyo mtu lazima alete kondoo dume kwenye ingilio la Hema la Kukutania kwa ajili ya sadaka ya hatia kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kupitia kwa huyo kondoo dume wa sadaka ya hatia, kuhani atafanya upatanisho kwa ajili yake mbele za Mwenyezi Mungu kwa ajili ya dhambi aliyotenda, naye atasamehewa dhambi yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Mtakapoingia katika hiyo nchi na kupanda aina yoyote ya mti wa matunda, hesabuni matunda yake kama yaliyokatazwa. Kwa miaka mitatu mtayahesabu kwamba yamekatazwa; hayaruhusiwi kuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Katika mwaka wa nne matunda yote ya mti huo yatakuwa matakatifu, sadaka ya sifa kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Bali katika mwaka wa tano mnaweza kula matunda ya mti huo. Kwa njia hii mavuno yenu yataongezewa. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Msile nyama yoyote yenye damu ndani yake. “ ‘Msifanye uaguzi wala uchawi. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Msikate nywele za kichwa denge, wala kunyoa pembe za ndevu zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Msichanje chale miili yenu kwa ajili ya mfu, wala msijichore alama juu ya miili yenu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Usimdhalilishe binti yako kwa kumfanya kahaba, la sivyo nchi itageukia ukahaba na kujaa uovu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Shika Sabato zangu na kuheshimu mahali pangu patakatifu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Msiende kwa waaguzi, wala msitafute wapunga pepo, kwa maana watawanajisi. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Ukiwa mbele ya mzee, simama ili kuonesha heshima kwa wazee, nawe umche Mungu wako. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Wakati mgeni anaishi pamoja nawe katika nchi yako, usimnyanyase. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mgeni anayeishi pamoja nawe ni lazima umtendee kama mmoja wa wazawa wa nchi yako. Mpende kama unavyojipenda mwenyewe, kwa maana ulikuwa mgeni katika nchi ya Misri. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Usitumie vipimo vya udanganyifu unapopima urefu, kupima uzito, wala kupima wingi. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tumia mizani halali, mawe ya kupimia uzito halali, efa halali, na hini halali. Mimi ndimi Mwenyezi Mungu, Mungu wako, ambaye alikutoa katika nchi ya Misri. ");
INSERT INTO swhonmm_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Shika amri zangu zote na sheria zangu zote, nawe uzifuate. Mimi ndimi Mwenyezi Mungu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Waambie Waisraeli: ‘Mwisraeli yeyote au mgeni anayeishi Israeli atakayemtoa kafara mtoto wake yeyote kwa Moleki lazima auawe. Watu wa jumuiya hiyo watampiga kwa mawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mimi nitauelekeza uso wangu dhidi ya mtu huyo, nami nitamkatilia mbali na watu wake. Kwa maana kwa kumtoa kafara mmoja wa watoto wake kwa Moleki, amenajisi madhabahu yangu na kulinajisi Jina langu takatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ikiwa watu wa jumuiya watafumba macho yao wakati mtu huyo anapomtoa kafara mmoja wa watoto wake kwa Moleki, nao wakaacha kumuua, ");
INSERT INTO swhonmm_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mimi nitauelekeza uso wangu dhidi ya mtu huyo pamoja na jamaa yake, nami nitawakatilia mbali yeye na watu wote waliofanya ukahaba na Moleki. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Mimi nitauelekeza uso wangu dhidi ya mtu anayeenda kwa waaguzi na wenye pepo, na hivyo kujifanyia ukahaba kwa kuwafuata, nami nitamkatilia mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Jitakaseni basi, nanyi kuweni watakatifu, kwa sababu mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Shikeni amri zangu na kuzifuata. Mimi ndimi Mwenyezi Mungu, niwafanyaye ninyi watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Ikiwa mtu yeyote atamlaani baba yake au mama yake, lazima auawe. Amemlaani baba yake au mama yake, nayo damu yake itakuwa juu ya kichwa chake mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Ikiwa mtu atazini na mke wa mtu mwingine, yaani mke wa jirani yake, wazinzi hao wawili lazima wauawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Kama mtu atakutana kimwili na mke wa baba yake, hakumheshimu baba yake. Mwanaume huyo na mwanamke huyo wote wauawe; damu yao itakuwa juu ya vichwa vyao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Ikiwa mtu atakutana kimwili na mke wa mwanawe, lazima wote wawili wauawe. Walichokifanya ni upotovu; damu yao itakuwa juu ya vichwa vyao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Kama mwanaume akikutana kimwili na mwanaume mwenzake kama vile mwanaume afanyavyo na mwanamke, wanaume hao wawili wamefanya lililo chukizo sana. Lazima wauawe; nayo damu yao itakuwa juu ya vichwa vyao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Ikiwa mwanaume ataoa binti pamoja na mama yake, huo ni uovu. Wote watatu ni lazima wachomwe moto, ili pasiwepo na uovu kati yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Kama mwanaume akikutana kimwili na mnyama, ni lazima auawe, na pia ni lazima mnyama huyo auawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Kama mwanamke atamsogelea mnyama kukutana naye kimwili, muueni mwanamke huyo pamoja na mnyama pia. Lazima wauawe; damu yao itakuwa juu ya vichwa vyao wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Ikiwa mtu atamwoa dada yake, binti aliyezaliwa na baba yake au mama yake, nao wakakutana kimwili, ni aibu. Lazima wakatiliwe mbali machoni pa watu wao. Huyo mwanaume amemwaibisha dada yake, hivyo atawajibika kwa ajili ya uovu huo. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Ikiwa mwanaume atakutana kimwili na mwanamke aliye katika hedhi yake, amefunua mtiririko wa hedhi yake, naye huyo mwanamke amejifunua uchi wake. Wote wawili lazima wakatiliwe mbali na watu wao. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Usikutane kimwili na dada wa mama yako wala wa baba yako, kwa maana hilo litamwaibisha jamaa wa karibu; ninyi wawili mtawajibika kwa ajili ya uovu huo. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Ikiwa mwanaume atakutana kimwili na shangazi yake, amemwaibisha mjomba wake. Nao watawajibika kwa ajili ya uovu huo; watakufa bila kuzaa mtoto. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Ikiwa mwanaume ataoa mke wa ndugu yake, hili ni tendo chafu; amemwaibisha ndugu yake. Nao hawatazaa mtoto. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Zishikeni amri na sheria zangu zote na kuzifuata, ili nchi ninayowaleta kuishi isiwatapike. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kamwe msiishi kwa kufuata desturi za mataifa nitakayoyafukuza mbele yenu. Kwa sababu walifanya mambo haya yote, nilichukizwa sana nao. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Lakini niliwaambia ninyi, “Mtaimiliki nchi yao; nitawapa ninyi kuwa urithi, nchi inayotiririka maziwa na asali.” Mimi ndimi Mwenyezi Mungu, Mungu wenu, ambaye amewatenga kutoka mataifa. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Kwa hiyo, ninyi lazima mweze kutofautisha kati ya wanyama walio safi na wasio safi, pia kati ya ndege wasio safi na walio safi. Msijitie unajisi kutokana na mnyama yeyote, au ndege, wala kiumbe chochote kinachotambaa juu ya ardhi, ambavyo nimevitenga kuwa najisi kwa ajili yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mtakuwa watakatifu kwangu, kwa sababu Mimi, Mwenyezi Mungu, ni mtakatifu, nami nimewatenga kutoka mataifa kuwa wangu mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Mwanaume au mwanamke ambaye ni mchawi, mwaguzi au mwenye kupunga pepo miongoni mwenu lazima auawe. Mtawapiga kwa mawe; nayo damu yao itakuwa juu ya vichwa vyao wenyewe.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mwenyezi Mungu akamwambia Musa, “Sema na makuhani, wana wa Haruni, uwaambie: ‘Kamwe kuhani asijitie unajisi kwa ajili ya mtu wake yeyote anayekufa, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","isipokuwa jamaa wake wa karibu, kama vile mama yake au baba yake, mwanawe au binti yake, ndugu yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","au dada yake asiyeolewa ambaye anamtegemea kwa kuwa hana mume, kwa ajili ya hao aweza kujitia unajisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kamwe asijitie unajisi mwenyewe kutokana na wale watu ambao anahusiana nao kwa kuoana, na hivyo kujitia unajisi. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Kamwe makuhani wasinyoe nywele za vichwa vyao wala wasinyoe pembeni mwa ndevu zao, au kuweka chale kwenye miili yao. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Lazima wawe watakatifu kwa Mungu wao, na kamwe wasilinajisi jina la Mungu wao. Kwa sababu ndio wanaotoa sadaka za kuteketezwa kwa moto kwa Mwenyezi Mungu, chakula cha Mungu wao, hivyo lazima wawe watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Kamwe wasioe wanawake waliojinajisi kwa ukahaba, au waliopewa talaka na waume wao, kwa sababu makuhani ni watakatifu kwa Mungu wao. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Waoneni kuwa watakatifu, kwa sababu ndio wanaotoa chakula cha Mungu wenu. Kumbukeni kuwa ni watakatifu, kwa sababu Mimi Mwenyezi Mungu ni mtakatifu, Mimi niwafanyaye ninyi kuwa watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ikiwa binti ya kuhani anajitia unajisi kwa kufanya ukahaba, anamwaibisha baba yake; lazima achomwe kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Kuhani mkuu, yule miongoni mwa ndugu zake ambaye amekwisha kupakwa mafuta kwa kumiminiwa juu ya kichwa chake, na ambaye amewekwa wakfu kuvaa mavazi ya ukuhani, kamwe asiache nywele zake bila kufunikwa, wala asirarue nguo zake. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kamwe asiingie mahali palipo maiti ndani. Kamwe asijitie unajisi, hata kwa ajili ya baba yake au mama yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","wala asiondoke mahali patakatifu pa Mungu wake au kupanajisi, kwa sababu amewekwa wakfu kwa mafuta ya Mungu wake. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Mwanamke atakayeolewa na kuhani lazima awe bikira. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Kamwe asimwoe mjane, au mwanamke aliyepewa talaka, wala mwanamke aliyejinajisi kwa ukahaba, bali atamwoa tu bikira kutoka miongoni mwa watu wake, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","na hivyo hatawatia unajisi wazao wake miongoni mwa watu wake. Mimi ndimi Mwenyezi Mungu, nimfanyaye mtakatifu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Mwambie Haruni: ‘Kwa vizazi vijavyo, hakuna mzao wako mwenye dosari atakayekaribia kutoa chakula cha Mungu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Hakuna mtu mwenye dosari yoyote awezaye kukaribia: hakuna mtu aliye kipofu au kiwete, au aliyeharibika uso au asiye na viungo kamili, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","hakuna mtu mwenye mguu au mkono uliolemaa, ");
INSERT INTO swhonmm_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","au mwenye kibiongo au aliyedumaa, au aliye na tatizo la macho, au aliye na uvimbe wenye usaha au majipu, au aliyehasiwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Hakuna mzao wa kuhani Haruni mwenye kilema chochote atakayekaribia kutoa sadaka ya kuteketezwa kwa moto kwa Mwenyezi Mungu. Kama ana kilema, kamwe asikaribie kutoa chakula cha Mungu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Anaweza kula chakula kitakatifu sana cha Mungu wake, pia hata chakula kitakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Lakini kwa sababu ya kilema chake, kamwe asikaribie pazia wala kukaribia madhabahu, asije akanajisi mahali patakatifu pangu. Mimi ndimi Mwenyezi Mungu, niwafanyaye watakatifu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Basi Musa akanena na Haruni, na wanawe, na Waisraeli wote. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Mwambie Haruni na wanawe kushughulikia kwa uangalifu sadaka takatifu Waisraeli wanazoziweka wakfu kwangu, ili wasilinajisi Jina langu takatifu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Waambie: ‘Katika vizazi vijavyo, ikiwa yeyote wa wazao wako ni najisi, naye akakaribia sadaka takatifu zile Waisraeli wanazoweka wakfu kwa Mwenyezi Mungu, mtu huyo lazima akatiliwe mbali na uso wangu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Ikiwa mzao wa Haruni ana ugonjwa wa ngozi unaoambukiza au anatokwa na usaha mwilini, hawezi kula sadaka takatifu hadi atakasike. Pia atakuwa najisi akigusa kitu chochote kilicho najisi kutokana na kugusa maiti, au akigusa mtu aliyetokwa na shahawa, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","au akigusa kitu chochote kinachotambaa kimfanyacho mtu najisi, au mtu yeyote awezaye kumtia unajisi, hata unajisi uwe gani. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Mtu anayegusa kitu chochote cha aina hiyo atakuwa najisi hadi jioni. Kamwe hatakula sadaka yoyote takatifu hadi yeye mwenyewe awe ameoga kwa maji. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Jua linapotua, atakuwa safi, na baadaye anaweza kula sadaka takatifu, kwa kuwa ni vyakula vyake. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kamwe asile nyama ya mzoga wala iliyoraruliwa na wanyama pori, naye akatiwa unajisi kwa hilo. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Makuhani lazima washike maagizo yangu ili wasiwe na hatia, wakafa kwa kuyadharau. Mimi ndimi Mwenyezi Mungu ninayewafanya watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Hakuna mtu yeyote asiye wa jamaa ya kuhani anayeruhusiwa kula sadaka takatifu, hata mgeni wa kuhani au mfanyakazi wake haruhusiwi kuila. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Lakini ikiwa kuhani amenunua mtumwa kwa fedha, au mtumwa amezaliwa katika nyumba ya kuhani huyo, mtumwa huyo aweza kula chakula cha huyo kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ikiwa binti ya kuhani ameolewa na mtu asiye kuhani, binti huyo haruhusiwi kula chochote cha matoleo matakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lakini ikiwa binti ya kuhani amekuwa mjane au amepewa talaka, naye hana watoto, na akarudi kuishi na jamaa ya baba yake kama wakati wa usichana wake, binti huyo anaweza kula chakula cha baba yake. Hata hivyo, mtu asiyeruhusiwa hawezi kula chochote katika chakula hiki. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Ikiwa mtu yeyote amekula sadaka takatifu kwa makosa, lazima atoe malipo ya sadaka hiyo kwa kuhani na kuongeza sehemu ya tano ya thamani ya sadaka hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kamwe makuhani wasiinajisi sadaka takatifu ambayo Waisraeli wameitoa kwa Mwenyezi Mungu ");
INSERT INTO swhonmm_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kwa kuwaruhusu kuzila sadaka hizo takatifu, na hivyo kuwaletea hatia ya kudaiwa malipo. Mimi ndimi Mwenyezi Mungu niwafanyaye watakatifu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sema na Haruni na wanawe, na Waisraeli wote uwaambie: ‘Ikiwa mmoja wenu, aliye Mwisraeli au mgeni anayeishi katika nchi ya Israeli, atatoa matoleo kwa ajili ya sadaka ya kuteketezwa kwa moto kwa Mwenyezi Mungu, iwe kutimiza nadhiri au kuwa sadaka ya hiari, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","lazima amtoe mnyama dume asiye na dosari, akiwa ng’ombe, mbuzi au kondoo, ili aweze kukubalika kwa niaba yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kamwe usitoe kitu chochote chenye dosari kwa sababu hakitakubaliwa kwa niaba yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mtu yeyote aletapo sadaka ya amani kwa Mwenyezi Mungu kutoka kundi la ng’ombe au la mbuzi ili kutimiza nadhiri maalum au sadaka ya hiari, lazima sadaka hiyo isiwe na dosari au waa ili ikubalike. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kamwe usimtolee Mwenyezi Mungu mnyama aliye kipofu, aliyejeruhiwa wala aliye kilema, au chochote kilicho na uvimbe, au chenye upele au vidonda vinavyotoka usaha. Kamwe chochote cha aina hii kisiwekwe juu ya madhabahu kuwa sadaka iliyotolewa kwa Mwenyezi Mungu ya kuteketezwa kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Lakini unaweza ukamtoa ng’ombe au kondoo mwenye kilema au aliyedumaa kuwa sadaka ya hiari, lakini hii haitakubalika kuwa sadaka ya kutimiza nadhiri. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kamwe usimtolee Mwenyezi Mungu mnyama ambaye mapumbu yake yamejeruhiwa, au kuhasiwa, au kuraruliwa au kukatwa. Kamwe usifanye hivi katika nchi yako mwenyewe, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","na kamwe usikubali wanyama wa aina hii kutoka mkono wa mgeni ili kuwatoa wanyama hao kuwa chakula kwa Mungu wako. Wanyama hao hawatakubaliwa kwa niaba yako, kwa sababu wana vilema, nao wana dosari.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ndama, mwana-kondoo au mwana-mbuzi anapozaliwa, atabaki na mama yake kwa siku saba. Kuanzia siku ya nane na kuendelea anaweza kukubaliwa kuwa sadaka iliyotolewa kwa Mwenyezi Mungu kwa kuteketezwa kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Usimchinje ng’ombe na ndama wake, au kondoo na kitoto chake siku moja. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Unapomtolea Mwenyezi Mungu dhabihu ya shukrani, itoe kwa namna ambayo itakubalika kwa niaba yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ni lazima iliwe siku hiyo hiyo, pasipo kubakiza chochote hadi asubuhi. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Shikeni maagizo yangu na kuyafuata. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Msilinajisi Jina langu takatifu. Lazima nikubalike kuwa mtakatifu kwa Waisraeli. Mimi ndimi Mwenyezi Mungu ninayewafanya watakatifu, ");
INSERT INTO swhonmm_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","na niliyewatoa katika nchi ya Misri niwe Mungu wenu. Mimi ndimi Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Sema na Waisraeli na uwaambie: ‘Hizi ndizo sikukuu zangu zilizoamriwa, sikukuu zilizoamriwa za Mwenyezi Mungu, ambazo mtazitangaza kuwa makusanyiko matakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Kuna siku sita mnazoweza kufanya kazi, lakini siku ya saba ni Sabato ya kupumzika, siku ya kusanyiko takatifu. Hamtafanya kazi yoyote. Popote mnapoishi, ni Sabato kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Hizi ni sikukuu za Mwenyezi Mungu zilizoamriwa, makusanyiko matakatifu mtakayoyatangaza kwa nyakati zilizoamriwa: ");
INSERT INTO swhonmm_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Pasaka ya Mwenyezi Mungu huanza jioni ya siku ya kumi na nne ya mwezi wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Siku ya kumi na tano ya mwezi huo wa kwanza, Sikukuu ya Mwenyezi Mungu ya Mikate Isiyotiwa Chachu huanza; kwa siku saba, mtakula mikate isiyotiwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Katika siku ya kwanza, mtakuwa na kusanyiko takatifu, na msifanye kazi zenu za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwa siku saba mtamletea Mwenyezi Mungu sadaka ya kuteketezwa kwa moto. Kwenye siku hiyo ya saba mtafanya kusanyiko takatifu, na msifanye kazi zenu za kawaida.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Sema na Waisraeli na uwaambie: ‘Mtakapoingia katika nchi nitakayowapa na kuvuna mazao ya nchi hiyo, leteni kwa kuhani mganda wa nafaka ya kwanza mtakayovuna. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Naye atauinua huo mganda mbele za Mwenyezi Mungu ili ukubaliwe kwa niaba yenu; kuhani ataupunga siku inayofuata Sabato. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Siku hiyo mtakapoinua huo mganda, lazima mtoe kwa Mwenyezi Mungu dhabihu ya kuteketezwa kwa moto ya mwana-kondoo wa mwaka mmoja asiye na dosari, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","pamoja na sadaka yake ya nafaka ya sehemu mbili za kumi ya efa ya unga laini uliochanganywa na mafuta, sadaka iliyotolewa kwa Mwenyezi Mungu kwa kuteketezwa kwa moto; hii itakuwa sadaka iliyo harufu nzuri ya kupendeza, na sadaka yake ya kinywaji ya robo ya hini ya divai. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kamwe msile mkate wowote, au nafaka iliyokaangwa au nafaka mpya, hadi siku ile mtakayomletea Mungu wenu sadaka hii. Hili litakuwa agizo la kudumu kwa vizazi vijavyo, popote mnapoishi. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Tangu siku ile iliyofuata Sabato, siku mliyotoa sadaka ya mganda wa kuinuliwa, hesabuni majuma saba kamili. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mtahesabu siku hamsini hadi siku inayofuata Sabato ya saba, ndipo mtatoa sadaka ya nafaka mpya kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kutoka popote mnapoishi, mtaleta mikate miwili iliyotengenezwa kwa sehemu mbili za kumi ya efa moja ya unga laini, uliookwa kwa chachu, kuwa sadaka ya kuinuliwa ya malimbuko kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Toeni pamoja na hiyo mikate wana-kondoo saba, kila mmoja wa mwaka mmoja asiye na dosari, na fahali mchanga, na kondoo dume wawili. Watakuwa sadaka ya kuteketezwa kwa moto iliyotolewa kwa Mwenyezi Mungu, pamoja na sadaka za nafaka na sadaka za vinywaji, sadaka iliyotolewa kwa moto yenye harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kisha toeni dhabihu ya beberu mmoja kwa ajili ya sadaka ya dhambi, na wana-kondoo wawili, kila mmoja wa mwaka mmoja, kwa ajili ya sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kuhani atawainua hao wana-kondoo wawili mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa, pamoja na mkate wa malimbuko. Ni sadaka takatifu kwa Mwenyezi Mungu kwa ajili ya kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Siku hiyo hiyo mtatangaza kusanyiko takatifu, na msifanye kazi zenu za kawaida. Hili litakuwa agizo la kudumu kwa vizazi vijavyo, popote mtakapoishi. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Mnapovuna mavuno ya ardhi yenu, msivune hadi mpakani mwa shamba lenu, au kukusanya masazo ya mavuno yenu. Hayo utayaacha kwa ajili ya maskini na mgeni. Mimi ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Waambie Waisraeli: ‘Katika siku ya kwanza ya mwezi wa saba mtakuwa na Sabato ya mapumziko, kusanyiko takatifu la ukumbusho litakaloadhimishwa kwa kupiga tarumbeta. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Msifanye kazi zenu zozote za kawaida, lakini toeni sadaka kwa Mwenyezi Mungu iliyoteketezwa kwa moto.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Siku ya kumi ya mwezi huu wa saba ni Siku ya Upatanisho. Mtafanya kusanyiko takatifu, mfunge, na kutoa sadaka ya kuteketezwa kwa moto kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Msifanye kazi siku hiyo, kwa sababu ni Siku ya Upatanisho, ambapo upatanisho unafanyika kwa ajili yenu mbele za Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mtu ambaye hatafunga siku hiyo ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mtu atakayefanya kazi siku hiyo nitamwangamiza kutoka miongoni mwa watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Hamtafanya kazi kamwe. Hili litakuwa agizo la kudumu kwa vizazi vijavyo popote mnapoishi. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ni Sabato ya mapumziko kwenu, na lazima mfunge. Tangu jioni ya siku ya tisa ya mwezi hadi jioni inayofuata, mtaishika Sabato yenu.” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Waambie Waisraeli: ‘Katika siku ya kumi na tano ya mwezi wa saba, Sikukuu ya vibanda itaanza, nayo itaadhimishwa kwa siku saba kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Siku ya kwanza ni kusanyiko takatifu, msifanye kazi zenu za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwa siku saba toeni sadaka kwa Mwenyezi Mungu za kuteketezwa kwa moto. Kwenye siku ya nane fanyeni kusanyiko takatifu, na kutoa sadaka ya kuteketezwa kwa moto kwa Mwenyezi Mungu. Ni kusanyiko la mwisho, msifanye kazi zenu za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Hizi ni sikukuu za Mwenyezi Mungu zilizoamriwa, ambazo mtazitangaza kuwa makusanyiko matakatifu kwa kuleta sadaka kwa Mwenyezi Mungu za kuteketeza kwa moto: sadaka za kuteketezwa na sadaka za nafaka, dhabihu na sadaka za vinywaji zitahitajika kila siku. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Sadaka hizi ni nyongeza ya zile mnazozitoa katika Sabato za Mwenyezi Mungu, na pia ni nyongeza ya matoleo yenu ya chochote mlichoweka nadhiri, na sadaka zenu zote za hiari mnazozitoa kwa Mwenyezi Mungu.) ");
INSERT INTO swhonmm_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Basi kuanzia siku ya kumi na tano ya mwezi wa saba, baada ya kuvuna mazao yote ya nchi, mtaadhimisha sikukuu kwa Mwenyezi Mungu kwa siku saba; siku ya kwanza ni Sabato ya mapumziko, na pia siku ya nane ni Sabato ya mapumziko. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Siku ya kwanza mtachukua matunda mazuri ya miti, matawi ya mitende, matawi yenye majani mengi, na matawi ya mirebi, nanyi mtashangilia mbele za Mwenyezi Mungu, Mungu wenu, kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mtaadhimisha siku hii kuwa sikukuu kwa Mwenyezi Mungu kwa siku saba kila mwaka. Hili litakuwa agizo la kudumu kwa vizazi vijavyo; iadhimisheni mwezi wa saba. ");
INSERT INTO swhonmm_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mtaishi katika vibanda kwa siku saba: Wazawa wote wa Waisraeli wataishi katika vibanda, ");
INSERT INTO swhonmm_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ili wazao wenu wajue kuwa niliwafanya Waisraeli waishi kwenye vibanda nilipowatoa Misri. Mimi ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kwa hiyo Musa akawatangazia Waisraeli sikukuu zilizoamriwa na Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Waagize Waisraeli wakuletee mafuta safi ya zeituni yaliyokamuliwa kwa ajili ya mwanga ili taa ziwe zinawaka daima. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Nje ya pazia la Sanduku la Ushuhuda ndani ya Hema la Kukutania, Haruni ataziwasha taa mbele za Mwenyezi Mungu kuanzia jioni hadi asubuhi daima. Hili litakuwa agizo la kudumu kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Taa zilizo juu ya kinara cha dhahabu safi mbele za Mwenyezi Mungu lazima zihudumiwe daima. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Chukua unga laini, uoke mikate kumi na miwili, ukitumia sehemu mbili za kumi ya efa ya unga kwa kila mkate. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Iweke katika mistari miwili, kila mstari mikate sita, uiweke mbele za Mwenyezi Mungu juu ya meza iliyotengenezwa kwa dhahabu safi. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kando ya kila mstari, weka uvumba safi kama sehemu ya kumbukumbu ili kuwakilisha mikate kuwa sadaka iliyotolewa kwa Mwenyezi Mungu kwa kuteketezwa kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mikate hii itawekwa mbele za Mwenyezi Mungu kila wakati, Sabato baada ya Sabato, kwa niaba ya Waisraeli, kuwa agano la kudumu. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hii ni mali ya Haruni na wanawe, watakaoila katika mahali patakatifu, kwa sababu ni sehemu takatifu sana ya fungu lao milele la sadaka iliyotolewa kwa Mwenyezi Mungu kwa kuteketezwa kwa moto.” ");
INSERT INTO swhonmm_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Basi mwana wa mama Mwisraeli na baba Mmisri alienda miongoni mwa Waisraeli, nayo mapigano yakatokea ndani ya kambi kati yake na Mwisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Huyu mwana wa mwanamke Mwisraeli akalikufuru Jina la Mwenyezi Mungu kwa kulaani; kwa hiyo wakamleta kwa Musa. (Mama yake aliitwa Shelomithi binti Dibri, wa kabila la Dani.) ");
INSERT INTO swhonmm_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Nao wakamweka mahabusu hadi mapenzi ya Mwenyezi Mungu yawe wazi kwao. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ndipo Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mchukue huyo aliyekufuru nje ya kambi. Wale wote waliomsikia akikufuru wataweka mikono juu ya kichwa chake, kisha kusanyiko lote watampiga mawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Waambie Waisraeli: ‘Ikiwa mtu yeyote atamlaani Mungu wake, atakuwa na hatia kwa uovu wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Yeyote atakayekufuru Jina la Mwenyezi Mungu ni lazima auawe. Kusanyiko lote watampiga kwa mawe. Iwe ni mgeni au mzawa, atakapolikufuru Jina la Mwenyezi Mungu, ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Kama mtu yeyote atamuua mtu mwingine, ni lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mtu yeyote auaye mnyama wa mtu mwingine lazima afidie, uhai kwa uhai. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ikiwa mtu yeyote atamjeruhi jirani yake, chochote alichomtenda naye atatendewa: ");
INSERT INTO swhonmm_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","iwapo amemvunja mfupa atavunjwa mfupa, jicho kwa jicho, jino kwa jino. Kama alivyomjeruhi mwenzake, vivyo hivyo ndivyo atakavyojeruhiwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Yeyote auaye mnyama wa mtu lazima alipe fidia, lakini yeyote auaye mtu, lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mtakuwa na sheria hiyo hiyo kwa mgeni na kwa mzawa. Mimi ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kisha Musa akasema na Waisraeli, nao wakamchukua yule aliyekufuru nje ya kambi na kumpiga mawe. Waisraeli wakafanya kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mwenyezi Mungu akamwambia Musa katika Mlima Sinai, ");
INSERT INTO swhonmm_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Sema na Waisraeli uwaambie: ‘Mtakapoingia katika nchi ninayowapa ninyi, nchi yenyewe ni lazima ishike sabato kwa ajili ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kwa miaka sita mtapanda mazao katika mashamba yenu, nanyi kwa miaka sita mtaikata mizabibu yenu matawi na kuvuna mazao yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Lakini katika mwaka wa saba, nchi lazima iwe na sabato ya mapumziko, sabato kwa Mwenyezi Mungu. Msipande mbegu katika mashamba yenu, wala msikate mizabibu yenu matawi. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Msivune chochote kinachoota chenyewe, wala kuvuna zabibu zenu ambazo hamkuzihudumia. Nchi lazima iwe na mwaka wa mapumziko. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Chochote nchi itoacho katika mwaka wa sabato kitakuwa chakula chenu wenyewe, watumishi wenu wa kiume na wa kike, mfanyakazi aliyeajiriwa, na mkazi wa muda anayeishi miongoni mwenu, ");
INSERT INTO swhonmm_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","vilevile malisho ya mifugo yenu na wanyama pori katika nchi yenu. Chochote nchi itakachozalisha kinaweza kuliwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Hesabu sabato saba za miaka saba, yaani miaka saba mara saba, ili sabato saba za miaka saba ziwe muda wa miaka arobaini na tisa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ndipo tarumbeta itapigwa kila mahali katika siku ya kumi ya mwezi wa saba. Katika Siku ya Upatanisho, piga tarumbeta katika nchi yako yote. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mwaka wa hamsini mtauweka wakfu na kutangaza uhuru katika nchi kwa wakazi wake wote. Itakuwa ni Yubile kwenu; kila mmoja wenu atairudia mali ya jamaa yake, na kila mmoja kurudi kwenye ukoo wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mwaka wa hamsini utakuwa Yubile kwenu, msipande wala msivune kile kinachoota chenyewe, au kuvuna zabibu zisizohudumiwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kwa kuwa ni Yubile, nayo itakuwa takatifu kwenu; mtakula tu kile kilichotoka moja kwa moja mashambani. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Katika huu Mwaka wa Yubile, kila mmoja atarudi kwenye mali yake mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Ikiwa utauza ardhi kwa mmoja wa wazawa wa nchi yako, au ukinunua ardhi kutoka kwake, mmoja asimpunje mwingine. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Utanunua ardhi kwa mzawa wa nchi yako kulingana na hesabu ya miaka baada ya Yubile. Naye muuzaji ataiuza kwako kulingana na hesabu ya miaka iliyobaki ya kuvuna mavuno. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Miaka inapokuwa mingi, utaongeza bei, nayo miaka ikiwa michache, utapunguza bei, kwa sababu kile anachokuuzia kwa hakika ni hesabu ya mazao. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mmoja asimpunje mwingine, bali utamcha Mungu wako. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Fuateni amri zangu na mwe waangalifu kutii amri zangu, nanyi mtaishi salama katika nchi. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kisha nchi itazaa matunda yake, nanyi mtakula na kushiba na kuishi humo kwa salama. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mwaweza kuuliza, “Tutakula nini katika mwaka wa saba ikiwa hatutapanda wala kuvuna mazao yetu?” ");
INSERT INTO swhonmm_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Nitawaletea baraka ya pekee katika mwaka wa sita, ili nchi iweze kuzalisha mazao ya kuwatosha kwa miaka mitatu. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mnapopanda mwaka wa nane, mtakula mavuno ya miaka iliyopita, na mtaendelea kuyala mazao hayo hadi mvune mavuno ya mwaka wa tisa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Kamwe ardhi isiuzwe kwa mkataba wa kudumu, kwa sababu nchi ni mali yangu, nanyi ni wageni na wapangaji wangu. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Katika nchi yote mtakayoshika kuwa milki yenu, ni lazima mtoe ukombozi wa ardhi. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Ikiwa mmoja wa wazawa wa nchi yako amekuwa maskini na akauza baadhi ya mali yake, ndugu yake wa karibu atakuja na kukomboa kile ndugu yake alichokiuza. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Iwapo mtu huyo hana jamaa wa karibu wa kukomboa mali hiyo kwa ajili yake, lakini yeye mwenyewe akafanikiwa na kupata mali itoshayo kuikomboa, ");
INSERT INTO swhonmm_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ataamua tena thamani yake kwa miaka tangu alipoiuza, na kurudisha kiasi kilichobaki cha thamani kwa mtu aliyekuwa amemuuzia mali hiyo, naye ataweza kuirudia mali yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lakini kama hatapata njia ya kumlipa mnunuzi, ile mali aliyouza itabaki kumilikiwa na mnunuzi hadi Mwaka wa Yubile. Mali hiyo itarudishwa Mwaka wa Yubile, naye ataweza kuirudia mali yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Ikiwa mtu atauza nyumba iliyo ndani ya mji uliozungukwa kwa ukuta, yeye anayo haki ya kuikomboa mwaka mzima baada ya mauzo ya hiyo nyumba. Wakati huo anaweza kuikomboa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ikiwa haikukombolewa kabla ya mwaka mmoja kamili kupita, nyumba iliyo ndani ya mji uliozungukwa kwa ukuta itakuwa mali ya kudumu ya mnunuzi na wazao wake. Haitarudishwa Mwaka wa Yubile. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lakini nyumba zilizo vijijini bila ya kuwa na kuta zilizozizunguka zitahesabiwa kama mashamba. Zinaweza kukombolewa, nazo zirudishwe Mwaka wa Yubile. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Walawi siku zote wana haki ya kukomboa nyumba zao katika miji ya Walawi wanayoimiliki. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kwa hiyo mali ya Mlawi inaweza kukombolewa, yaani nyumba iliyouzwa katika mji wowote wanaoushikilia itarudishwa Mwaka wa Yubile, kwa sababu nyumba zilizo katika miji ya Walawi ni mali yao miongoni mwa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lakini maeneo ya malisho yaliyo mali ya miji yao kamwe yasiuzwe, ni milki yao ya kudumu. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Ikiwa mmoja wa wazawa wa nchi yako amekuwa maskini, naye akashindwa kujitegemeza mwenyewe kati yako, msaidie vile ungemsaidia mgeni au mkazi wa muda, ili aweze kuendelea kuishi kati yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Usichukue riba wala faida yoyote kutoka kwake, bali utamwogopa Mungu wako, ili mzawa wa nchi yako aweze kuendelea kuishi kati yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Usimkopeshe fedha ili alipe na riba, wala usimuuzie chakula kwa faida. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mimi ndimi Mwenyezi Mungu, Mungu wako, niliyekuleta kutoka nchi ya Misri nikupe nchi ya Kanaani, nami niwe Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Ikiwa mmoja wa wazawa wa nchi yako amekuwa maskini kati yako, naye akajiuza kwako, usimfanye atumike kama mtumwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Atatendewa kama mfanyakazi aliyeajiriwa, au kama mkazi wa muda katikati yako; naye atatumika hadi Mwaka wa Yubile. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ndipo yeye na watoto wake wataachiwa, naye atarudi kwa watu wa ukoo wake, na kwenye mali ya baba zake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kwa sababu Waisraeli ni watumishi wangu niliowaleta kutoka nchi ya Misri, kamwe wasiuzwe kama watumwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Usiwatawale kwa ukatili, lakini utamcha Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Watumwa wako wa kiume na wa kike watatoka katika mataifa yanayokuzunguka; unaweza kununua watumwa kutoka kwao. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Pia unaweza kununua baadhi ya wakazi wa muda wanaoishi kati yako, na jamaa ya koo zao waliozaliwa katika nchi yako; nao watakuwa mali yako. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Unaweza kuwafanya hao kuwa urithi wa watoto wako, na unaweza kuwafanya watumwa kwa maisha yao yote. Lakini usiwatawale ndugu zako Waisraeli kwa ukatili. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Ikiwa mgeni au mkazi wa muda katikati yako atakuwa tajiri, na mmoja wa wazawa wa nchi yako akawa maskini, naye akajiuza kwa yule mgeni anayeishi katikati yako, au kwa mmoja wa jamaa wa koo za wageni, ");
INSERT INTO swhonmm_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","anayo haki ya kukombolewa baada ya kujiuza. Mmoja wa jamaa zake aweza kumkomboa: ");
INSERT INTO swhonmm_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mjomba wake, au binamu yake, au yeyote aliye ndugu wa damu katika ukoo wake aweza kumkomboa. Au akifanikiwa, anaweza kujikomboa mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yeye na huyo aliyemnunua watahesabu muda kuanzia mwaka aliojiuza hadi Mwaka wa Yubile. Bei ya kuachiwa kwake itakadiriwa kulingana na ujira unaolipwa mfanyakazi wa kuajiriwa kwa idadi ya hiyo miaka. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ikiwa imebaki miaka mingi, ni lazima atalipia ukombozi wake fungu kubwa la bei iliyolipwa kumnunua. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ikiwa miaka iliyobaki ni michache kufikia Mwaka wa Yubile, atafanya hesabu yake, naye atalipa malipo yanayostahili kwa ajili ya ukombozi wake. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Atatendewa kama mtu wa kuajiriwa mwaka hadi mwaka; lazima uone kwamba yule aliyemnunua hamtawali kwa ukatili. ");
INSERT INTO swhonmm_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Hata ikiwa hakukombolewa kwa njia mojawapo ya hizi, yeye na watoto wake wataachiwa katika Mwaka wa Yubile, ");
INSERT INTO swhonmm_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","kwa kuwa kwangu, Waisraeli ni watumishi. Ni watumishi wangu niliowatoa kutoka nchi ya Misri. Mimi ndimi Mwenyezi Mungu, Mungu wako. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Msijitengenezee sanamu, au kusimamisha sanamu ya kuchonga, au jiwe la kuabudia, na pia msijiwekee jiwe lililochongwa katika nchi yenu ili kulisujudia. Mimi ndimi Mwenyezi Mungu, Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Zishikeni Sabato zangu na kuheshimu mahali patakatifu pangu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Ikiwa mtafuata amri zangu na kuwa waangalifu kutii maagizo yangu, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nitawanyeshea mvua katika majira yake, nayo ardhi itatoa mazao yake, na miti ya mashambani itazaa matunda yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kupura nafaka kwenu kutaendelea hadi wakati wa kuvuna zabibu. Na kuvuna zabibu kutaendelea hadi wakati wa kupanda mbegu, nanyi mtakula na kushiba, na mtaishi salama katika nchi yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Nitawapa amani katika nchi, mpate kulala pasipo kutiwa hofu na yeyote. Nitawaondoa wanyama wakali watoke kwenye nchi, nao upanga hautapita katika nchi yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mtawafukuza adui zenu, nanyi mtawaua kwa upanga mbele yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Watu wenu watano watafukuza adui mia moja, na watu wenu mia moja watafukuza adui elfu kumi, nao adui zenu wataanguka kwa upanga mbele yenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Nitawaangalia kwa upendeleo na kuwafanya mzae na kuzidisha idadi yenu, nami nitalishika agano langu na ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Wakati wa kuvuna mtakuwa bado mnakula mavuno ya mwaka uliopita, na itawalazimu kuyaondoa ghalani ili mpate nafasi ya mavuno mapya. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nitafanya makao yangu miongoni mwenu, nami sitawachukia. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nitatembea kati yenu niwe Mungu wenu, nanyi mtakuwa watu wangu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mimi ndimi Mwenyezi Mungu, Mungu wenu, niliyewatoa katika nchi ya Misri ili msiendelee kuwa watumwa wa Wamisri, nikavunja nira yenu, na kuwawezesha kutembea mkiwa mmeinua vichwa vyenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Lakini kama hamtanisikiliza na kutimiza maagizo haya yote, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","nanyi kama mtazikataa amri zangu na kuzichukia sheria zangu, tena mkishindwa kutimiza amri zangu zote, na hivyo mkavunja agano langu, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ndipo nitakapowafanyia hili: Nitawaletea juu yenu hofu ya ghafula, magonjwa ya kudhoofisha, na homa itakayopofusha macho yenu na kuwaondolea uhai wenu. Mtapanda mbegu bila mafanikio, kwa sababu adui zenu watazila. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nitauelekeza uso wangu dhidi yenu ili mshindwe na adui zenu; wale wanaowachukia watawatawala, nanyi mtakimbia ingawa hakuna mtu anayewafukuza. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Kama baada ya haya yote hamtanisikiliza, nitawaadhibu mara saba zaidi kwa ajili ya dhambi zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nitakivunja kiburi chenu cha ukaidi, na kuifanya anga iliyo juu yenu iwe kama chuma, na ardhi yenu kama shaba. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nguvu zenu zitatumika bila ya mafanikio, kwa sababu ardhi yenu haitawazalia mazao yake, wala miti ya nchi yenu haitazaa matunda yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Kama mtaendelea kuwa na uadui nami, na kukataa kunisikiliza, nitawazidishia mateso yenu mara saba zaidi, kama dhambi zenu zinavyostahili. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nitawatuma wanyama mwitu dhidi yenu, nao watawaibieni watoto wenu, watawaangamiza ng’ombe wenu, na kuifanya idadi yenu kuwa ndogo, hivi kwamba barabara zenu zitakuwa hazina watu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Ikiwa pamoja na mambo haya hamtakubali maonyo yangu lakini mkaendelea kuweka uadui nami, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mimi mwenyewe nitaweka uadui nanyi, na kuwatesa kwa ajili ya dhambi zenu mara saba zaidi. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nitawaletea upanga juu yenu ili kuwapatiliza kwa kuvunja agano langu. Mtakapokimbilia mijini mwenu, nitatuma tauni kati yenu, nanyi mtatiwa mikononi mwa adui zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nitakapowaondolea upatikanaji wa mkate wenu, wanawake kumi wataoka mkate wenu katika tanuru moja, nao wataugawa mkate kidogo kwa kupima. Mtakula, lakini hamtashiba. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Kama hata baada ya haya bado hamtanisikiliza lakini mkaendelea kuweka uadui nami, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ndipo katika hasira yangu nitaweka uadui nanyi, nami mwenyewe nitawaadhibu mara saba kwa ajili ya dhambi zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mtakula nyama ya wana wenu na nyama ya binti zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nitaharibu mahali penu pa juu pa kuabudia, nibomoe madhabahu yenu ya kufukizia uvumba, na kuzilundika maiti zenu juu ya sanamu zenu zisizo na uhai, nami nitawachukia ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nitaifanya miji yenu kuwa magofu, na kuharibu mahali patakatifu penu pa kuabudia, nami sitapendezwa na harufu nzuri ya sadaka zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nitaiharibu nchi, ili adui zenu watakaoishi humo washangae. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nitawatawanya ninyi miongoni mwa mataifa, na kuufuta upanga wangu na kuwafuatia. Nchi yenu itaharibiwa, nayo miji yenu itakuwa magofu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ndipo nchi itafurahia sabato zake muda wote ule itakapokuwa ukiwa, nanyi mkiwa katika nchi ya adui zenu. Ndipo nchi itapumzika na kufurahia sabato zake. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Wakati wote nchi itakapobaki ukiwa, itapumzika na kufurahia sabato zake ambazo haikuzipata mlipokuwa mnaishi humo. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Kwa habari ya wenzenu wale watakaobaki, nitaifanya mioyo yao kuwa na hofu kuu katika nchi za adui zao, kiasi kwamba sauti ya jani linalopeperushwa na upepo itawafanya wakimbie. Watakimbia kana kwamba wanakimbia upanga, nao wataanguka, ijapokuwa hakuna anayewafukuza. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Watajikwaa mmoja juu ya mwingine kama watu wakimbiao upanga, hata ingawa hakuna anayewafuatia. Hivyo hamtaweza kusimama mbele ya adui zenu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mtaangamia kati ya mataifa; nchi ya adui zenu itawala. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wenzenu watakaobaki wataangamia katika nchi za adui zao kwa sababu ya dhambi zao; pia kwa sababu ya dhambi za baba zao wataangamia. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Lakini kama watatubu dhambi zao na dhambi za baba zao, udanganyifu wao dhidi yangu na uadui wao kwangu, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ambao ulinifanya niwe na uadui nao hata nikawapeleka katika nchi ya adui zao, wakati mioyo yao isiyotahiriwa itanyenyekea na kutubu dhambi yao, ");
INSERT INTO swhonmm_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nami nitakumbuka agano langu na Yakobo, na agano langu na Isaka, na agano langu na Ibrahimu, nami nitaikumbuka nchi. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Kwa kuwa wataiacha nchi ukiwa, nayo itafurahia sabato zake wakati itakuwa ukiwa bila wao. Wataadhibiwa kwa ajili ya dhambi zao, kwa sababu walizikataa sheria zangu na kuzichukia amri zangu. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Lakini pamoja na hili, wakati watakuwa katika nchi ya adui zao, sitawakataa wala kuwachukia kiasi cha kuwaangamiza na kuvunja agano langu nao. Mimi ndimi Mwenyezi Mungu, Mungu wao. ");
INSERT INTO swhonmm_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Lakini kwa ajili yao nitalikumbuka agano langu na baba zao, ambao niliwatoa Misri mbele ya mataifa ili niwe Mungu wao. Mimi ndimi Mwenyezi Mungu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hizi ndizo amri, sheria na pia masharti ambazo Mwenyezi Mungu alifanya kati yake mwenyewe na Waisraeli katika Mlima Sinai kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Sema na Waisraeli uwaambie: ‘Kama mtu yeyote ataweka nadhiri maalum ili kuweka watu wakfu kwa Mwenyezi Mungu, kwa kutoa kiasi cha thamani inayolingana, ");
INSERT INTO swhonmm_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","thamani ya kukomboa mwanaume mwenye kati ya umri wa miaka ishirini na miaka sitini itakuwa shekeli hamsini za fedha, kulingana na shekeli ya mahali patakatifu; ");
INSERT INTO swhonmm_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ikiwa ni mwanamke, weka thamani yake kwa shekeli thelathini. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kama ni mtu mwenye umri wa miaka kati ya mitano na ishirini, weka thamani ya mwanaume kuwa shekeli ishirini, na mwanamke shekeli kumi. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kama ni mtu mwenye umri kati ya mwezi mmoja na miaka mitano, weka thamani ya mwanaume kuwa shekeli tano za fedha, na ile ya mwanamke kuwa shekeli tatu za fedha. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kama ni mtu mwenye miaka sitini na zaidi, weka thamani ya mwanaume kuwa shekeli kumi na tano, na mwanamke shekeli kumi. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kama mtu yeyote anayeweka nadhiri ni maskini mno kuweza kulipa kiasi kilichowekwa, atampeleka huyo mtu kwa kuhani, ambaye ataweka thamani yake kulingana na kile yule anayeweka nadhiri anaweza kulipa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Kama kile mtu alichokiwekea nadhiri ni mnyama anayekubalika kama sadaka kwa Mwenyezi Mungu, mnyama huyo aliyetolewa kwa Mwenyezi Mungu anakuwa mtakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Mtu haruhusiwi kumbadilisha au kutoa mnyama mzuri kwa mbaya, au mnyama mbaya kwa mzuri. Kama atatoa mnyama badala ya mwingine, wanyama wote wawili, yaani yule aliyetolewa na yule aliyebadiliwa, ni watakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kama alichokiwekea nadhiri ni mnyama aliye najisi, yaani yule asiyekubalika kuwa sadaka kwa Mwenyezi Mungu, huyo mnyama lazima aletwe kwa kuhani, ");
INSERT INTO swhonmm_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ambaye ataamua ubora wa mnyama huyo, kama ni mzuri au mbaya. Thamani yoyote atakayoweka kuhani, hivyo ndivyo itakavyokuwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kama mwenye mnyama atapenda kumkomboa mnyama huyo, lazima aongeze sehemu ya tano ya thamani yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Kama mtu ataweka nyumba yake wakfu kama kitu kitakatifu kwa Mwenyezi Mungu, kuhani ataamua ubora wa nyumba hiyo, kama ni nzuri au mbaya. Thamani yoyote kuhani atakayoweka, basi hivyo ndivyo itakavyokuwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kama mtu aliyeweka nyumba yake wakfu ataikomboa, lazima aongeze sehemu ya tano ya thamani yake, nayo nyumba itakuwa yake tena. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Ikiwa mtu ataweka sehemu ya ardhi ya jamaa yake wakfu kwa Mwenyezi Mungu, thamani yake itawekwa kulingana na kiasi cha mbegu inayohitajiwa kupandwa katika ardhi hiyo, yaani homeri moja ya mbegu za shayiri kwa shekeli hamsini za fedha. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Akiweka shamba lake wakfu katika Mwaka wa Yubile, ile thamani iliyokwisha wekwa itakuwa hiyo hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Lakini akiliweka shamba lake wakfu baada ya Yubile, kuhani ataweka thamani kulingana na idadi ya miaka iliyobaki kufikia Mwaka wa Yubile unaofuata, na thamani yake iliyoamuliwa itapunguzwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kama mtu anayeweka wakfu shamba anataka kulikomboa, lazima aongeze sehemu ya tano ya thamani yake, nalo shamba litakuwa lake tena. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kama pengine halikomboi shamba hilo, au kama ameliuza kwa mtu mwingine, kamwe haliwezi kukombolewa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Shamba hilo litakapoachiwa Mwaka wa Yubile, litakuwa takatifu, kama shamba lililotolewa kwa Mwenyezi Mungu, nalo litakuwa mali ya makuhani. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Kama mtu ameweka wakfu kwa Mwenyezi Mungu shamba alilonunua, ambalo si sehemu ya ardhi ya jamaa yake, ");
INSERT INTO swhonmm_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kuhani ataamua thamani yake hadi Mwaka wa Yubile, naye huyo mtu lazima alipe thamani yake siku hiyo kama kitu kitakatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Katika Mwaka wa Yubile, shamba litarudishwa kwa mtu yule ambaye lilinunuliwa kutoka kwake, yule ambaye ardhi ilikuwa mali yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Kila thamani lazima iwekwe kulingana na shekeli ya mahali patakatifu: gera ishirini kwa shekeli. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Hata hivyo, hakuna mtu atakayemweka wakfu mzaliwa wa kwanza wa mnyama, kwa kuwa mzaliwa wa kwanza tayari ni mali ya Mwenyezi Mungu; awe ng’ombe au kondoo, ni wa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kama ni mmoja wa wanyama walio najisi, aweza kumnunua kwa bei iliyowekwa, akiongeza sehemu ya tano ya thamani yake. Kama hatamkomboa, mnyama huyo atauzwa kwa bei iliyowekwa. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Lakini chochote kile mtu alicho nacho na akakiweka wakfu kwa Mwenyezi Mungu, iwe ni binadamu, au mnyama, au ardhi ya jamaa, hakiwezi kuuzwa au kukombolewa. Chochote kilichowekwa wakfu ni kitakatifu sana kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Mtu yeyote aliyewekwa wakfu ili kuangamizwa, hawezi kukombolewa. Mtu kama huyo lazima auawe. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Zaka ya kila kitu kutoka shambani, iwe ni nafaka kutoka kwa ardhi, au tunda kutoka kwa miti, ni mali ya Mwenyezi Mungu; ni takatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kama mtu akikomboa chochote cha zaka yake, lazima aongeze sehemu ya tano ya thamani yake. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Zaka yote ya kundi la ng’ombe au la kondoo na mbuzi, kila mnyama wa kumi apitaye chini ya fimbo ya yule awachungaye, atakuwa kitu kitakatifu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Yule mnyama wa kumi hatachaguliwa kwa kigezo cha uzuri au ubaya, naye haruhusiwi kubadiliwa. Akimbadili, basi mnyama yule wa kwanza na huyo aliyebadiliwa wote watahesabiwa kuwa watakatifu, na haiwezekani kuwakomboa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Haya ndio maagizo Mwenyezi Mungu aliyompa Musa juu ya Mlima Sinai kwa ajili ya Waisraeli.");
INSERT INTO swhonmm_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mwenyezi Mungu alisema na Musa katika Jangwa la Sinai, katika Hema la Kukutania, siku ya kwanza ya mwezi wa pili, katika mwaka wa pili baada ya Waisraeli kutoka nchi ya Misri. Akamwambia, ");
INSERT INTO swhonmm_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Hesabu watu wa jumuiya yote ya Waisraeli kwa kufuata koo zao na jamaa zao, ukiorodhesha kila mwanaume kwa jina lake, mmoja mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Wewe na Haruni mtawahesabu kwa migawanyo yao wanaume wote katika Israeli wenye miaka ishirini na kuendelea wanaoweza kutumika katika jeshi. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mwanaume mmoja kutoka kila kabila, kila aliye kiongozi wa jamaa yake, atawasaidia. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Haya ndiyo majina ya wanaume watakaowasaidia: “kutoka Reubeni, ni Elisuri mwana wa Shedeuri; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kutoka Simeoni, ni Shelumieli mwana wa Surishadai; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kutoka Yuda, ni Nashoni mwana wa Aminadabu; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kutoka Isakari, ni Nethaneli mwana wa Suari; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kutoka Zabuloni, ni Eliabu mwana wa Heloni; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kutoka wana wa Yusufu: kutoka Efraimu, ni Elishama mwana wa Amihudi; kutoka Manase, ni Gamalieli mwana wa Pedasuri; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kutoka Benyamini, ni Abidani mwana wa Gideoni; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kutoka Dani, ni Ahiezeri mwana wa Amishadai; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kutoka Asheri, ni Pagieli mwana wa Okrani; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kutoka Gadi, ni Eliasafu mwana wa Deueli; ");
INSERT INTO swhonmm_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kutoka Naftali, ni Ahira mwana wa Enani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hawa walikuwa wanaume walioteuliwa kutoka jumuiya, viongozi wa makabila ya baba zao. Walikuwa wakuu wa koo za Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Haruni wakawachukua wanaume hao waliokuwa wamepewa majina yao, ");
INSERT INTO swhonmm_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","wakaita jumuiya yote pamoja katika siku ya kwanza ya mwezi wa pili. Watu wakaonesha nasaba zao kwa koo zao na jamaa zao, nao wanaume waliokuwa na miaka ishirini au zaidi waliorodheshwa kwa majina, mmoja mmoja, ");
INSERT INTO swhonmm_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kama Mwenyezi Mungu alivyomwagiza Musa. Hivyo aliwahesabu katika Jangwa la Sinai: ");
INSERT INTO swhonmm_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kutoka wazao wa Reubeni, mzaliwa wa kwanza wa kiume wa Israeli: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, mmoja mmoja, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Idadi kutoka kabila la Reubeni ilikuwa watu elfu arobaini na sita na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kutoka wazao wa Simeoni: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi walihesabiwa na kuorodheshwa kwa majina, mmoja mmoja, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Idadi kutoka kabila la Simeoni walikuwa watu elfu hamsini na tisa na mia tatu. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kutoka wazao wa Gadi: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Idadi kutoka kabila la Gadi walikuwa watu elfu arobaini na tano, mia sita na hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kutoka wazao wa Yuda: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Idadi kutoka kabila la Yuda walikuwa watu elfu sabini na nne na mia sita. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kutoka wazao wa Isakari: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Idadi kutoka kabila la Isakari walikuwa watu elfu hamsini na nne na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kutoka wazao wa Zabuloni: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Idadi kutoka kabila la Zabuloni walikuwa watu elfu hamsini na saba na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kutoka wana wa Yusufu: Kutoka wazao wa Efraimu: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Idadi kutoka kabila la Efraimu walikuwa watu elfu arobaini na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kutoka wazao wa Manase: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Idadi kutoka kabila la Manase walikuwa watu elfu thelathini na mbili na mia mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kutoka wazao wa Benyamini: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Idadi kutoka kabila la Benyamini walikuwa watu elfu thelathini na tano na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kutoka wazao wa Dani: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Idadi kutoka kabila la Dani walikuwa watu elfu sitini na mbili na mia saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kutoka wazao wa Asheri: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Idadi kutoka kabila la Asheri walikuwa watu elfu arobaini na moja na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kutoka wazao wa Naftali: Wanaume wote waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi waliorodheshwa kwa majina, kufuatana na kumbukumbu za koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Idadi kutoka kabila la Naftali walikuwa watu elfu hamsini na tatu na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hawa walikuwa wanaume waliohesabiwa na Musa, Haruni na viongozi kumi na wawili wa Israeli, kila mmoja akiwakilisha jamaa yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Wanaume wote Waisraeli waliokuwa na miaka ishirini au zaidi ambao waliweza kutumika katika jeshi la Israeli walihesabiwa kufuatana na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Jumla ya hesabu yao ilikuwa watu elfu mia sita na tatu mia tano na hamsini (603,550). ");
INSERT INTO swhonmm_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Hata hivyo, jamaa ya kabila la Lawi hawakuhesabiwa pamoja na wengine. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Mwenyezi Mungu alikuwa amemwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kamwe usihesabu kabila la Lawi wala kuwaweka pamoja katika hesabu ya Waisraeli wengine. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Badala yake, waweke Walawi kuwa viongozi wa Maskani ya Ushuhuda, juu ya samani zake na kila kitu kilicho ndani yake. Wao watabeba Maskani na samani zake zote; wataitunza na kupiga kambi kuizunguka. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wakati wowote Maskani inapohamishwa, Walawi wataifungua, na wakati wowote Maskani inapotakiwa kusimamishwa, Walawi watafanya kazi hiyo. Mtu yeyote mwingine ambaye atasogea karibu nayo atauawa. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Waisraeli watapiga mahema yao kwa makundi makundi, kila mwanaume katika kambi yake mwenyewe chini ya bendera yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Hata hivyo, Walawi watapiga mahema yao kuzunguka Maskani ya Ushuhuda ili ghadhabu isiipate jumuiya ya Waisraeli. Walawi watawajibika kwa utunzaji wa Maskani ya Ushuhuda.” ");
INSERT INTO swhonmm_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Waisraeli walifanya haya yote kama Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mwenyezi Mungu aliwaambia Musa na Haruni: ");
INSERT INTO swhonmm_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Waisraeli watapiga kambi zao kuzunguka Hema la Kukutania kwa umbali kiasi, kila mwanaume akiwa chini ya beramu yake, pamoja na bendera ya jamaa yake.” ");
INSERT INTO swhonmm_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kwa upande wa mashariki kuelekea mawio ya jua, kambi ya makundi ya Yuda watapiga kambi chini ya beramu yao. Kiongozi wa watu wa Yuda ni Nashoni mwana wa Aminadabu. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Kundi lake lina watu elfu sabini na nne na mia sita. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kabila la Isakari watapiga kambi karibu na Yuda. Kiongozi wa watu wa Isakari ni Nethaneli mwana wa Suari. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Kundi lake lina watu elfu hamsini na nne na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kabila la Zabuloni litafuata. Kiongozi wa watu wa Zabuloni ni Eliabu mwana wa Heloni. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Kundi lake lina watu elfu hamsini na saba na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Wanaume wote walio katika kambi ya Yuda, kufuatana na makundi yao, ni elfu mia moja themanini na sita na mia nne. Wao watatangulia kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Kwa upande wa kusini kutakuwa na kambi ya makundi ya Reubeni chini ya beramu yao. Kiongozi wa watu wa Reubeni ni Elisuri mwana wa Shedeuri. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Kundi lake lina watu elfu arobaini na sita na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Kabila la Simeoni watapiga kambi karibu na Reubeni. Kiongozi wa watu wa Simeoni ni Shelumieli mwana wa Surishadai. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Kundi lake lina watu elfu hamsini na tisa na mia tatu. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kabila la Gadi litafuata. Kiongozi wa watu wa Gadi ni Eliasafu mwana wa Deueli. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Kundi lake lina watu elfu arobaini na tano mia sita na hamsini. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Wanaume wote walio katika kambi ya Reubeni, kufuatana na makundi yao, ni elfu mia moja hamsini na moja na mia nne na hamsini (151,450). Nao watakuwa nafasi ya pili kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kisha Hema la Kukutania na kambi ya Walawi vitakuwa katikati ya kambi zote. Wao watasafiri kwa utaratibu ule ule kama walivyopiga kambi, kila mmoja mahali pake mwenyewe chini ya beramu yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Upande wa magharibi kutakuwa na kambi ya makundi ya Efraimu chini ya beramu yao. Kiongozi wa watu wa Efraimu ni Elishama mwana wa Amihudi. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Kundi lake lina watu elfu arobaini na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Kabila la Manase litafuata baada ya Efraimu. Kiongozi wa watu wa Manase ni Gamalieli mwana wa Pedasuri. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Kundi lake lina watu elfu thelathini na mbili na mia mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kabila la Benyamini litafuata baada ya Manase. Kiongozi wa watu wa Benyamini ni Abidani mwana wa Gideoni. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Kundi lake lina watu elfu thelathini na tano na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wanaume wote walio katika kambi ya Efraimu kufuatana na makundi yao ni elfu mia moja na nane na mia moja. Nao watakuwa nafasi ya tatu kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Upande wa kaskazini kutakuwa na makundi ya kambi ya Dani, chini ya beramu yao. Kiongozi wa watu wa Dani ni Ahiezeri mwana wa Amishadai. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Kundi lake lina watu elfu sitini na mbili na mia saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Kabila la Asheri watapiga kambi karibu na Dani. Kiongozi wa watu wa Asheri ni Pagieli mwana wa Okrani. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Kundi lake lina watu elfu arobaini na moja na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kabila la Naftali litafuata. Kiongozi wa watu wa Naftali ni Ahira mwana wa Enani. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Kundi lake lina watu elfu hamsini na tatu na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Wanaume wote walio katika kambi ya Dani ni elfu mia moja hamsini na saba na mia sita. Wao watakuwa wa mwisho kuondoka chini ya beramu yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hawa ndio Waisraeli, wakiwa wamehesabiwa kufuatana na jamaa zao. Wote walio kambini kwa makundi yao ni watu elfu mia sita na tatu mia tano na hamsini (603,550). ");
INSERT INTO swhonmm_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Hata hivyo, Walawi hawakuhesabiwa pamoja na Waisraeli wengine, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kwa hiyo Waisraeli wakafanya kila kitu Mwenyezi Mungu alichomwamuru Musa. Hivyo ndivyo walivyopiga kambi chini ya beramu zao. Pia hivyo ndivyo walivyoondoka, kila mmoja akiwa na ukoo wake na jamaa yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hivi ndivyo vizazi vya Haruni na Musa kwa wakati ambao Mwenyezi Mungu alizungumza na Musa katika Mlima Sinai. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Majina ya wana wa Haruni yalikuwa: Nadabu mzaliwa wa kwanza na Abihu, Eleazari na Ithamari. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hayo yalikuwa majina ya wana wa Haruni, makuhani wapakwa mafuta, waliokuwa wamesimikwa kuhudumu kama makuhani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Hata hivyo Nadabu na Abihu walikufa mbele za Mwenyezi Mungu walipotoa sadaka kwa moto usioruhusiwa mbele zake katika Jangwa la Sinai. Hawakuwa na wana; kwa hiyo Eleazari na Ithamari walihudumu peke yao kama makuhani wakati wote wa maisha ya Haruni baba yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Walete kabila la Lawi mbele ya Haruni kuhani ili wamsaidie. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Watafanya huduma kwa ajili yake na kwa jumuiya yote katika Hema la Kukutania kwa kufanya kazi za Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Watatunza samani zote za Hema la Kukutania, wakitimiza wajibu wa kuhudumia Waisraeli kwa kufanya kazi ya Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Wakabidhi Walawi kwa Haruni na wanawe; hao ndio Waisraeli ambao wanakabidhiwa kwake kabisa. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Waweke Haruni na wanawe kuhudumu kama makuhani; mtu mwingine yeyote atakayesogea mahali patakatifu atauawa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Nimewatwaa Walawi kutoka miongoni mwa Waisraeli badala ya mzaliwa wa kwanza wa kiume wa kila mwanamke wa Mwisraeli. Walawi ni wangu, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kwa kuwa wazaliwa wote wa kwanza ni wangu. Nilipowaua wazaliwa wa kwanza huko Misri, nilimtenga kila mzaliwa wa kwanza katika Israeli awe wangu, akiwa mwanadamu au mnyama. Watakuwa wangu. Mimi ndimi Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mwenyezi Mungu akamwambia Musa katika Jangwa la Sinai, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Wahesabu Walawi kwa jamaa zao na koo zao. Mhesabu kila mwanaume mwenye umri wa mwezi mmoja au zaidi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Kwa hiyo Musa akawahesabu, kama alivyoamriwa na neno la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Haya yalikuwa majina ya wana wa Lawi: Gershoni, Kohathi na Merari. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Haya ndio yaliyokuwa majina ya koo za Wagershoni: Libni na Shimei. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Koo za Wakohathi zilikuwa ni: Amramu, Ishari, Hebroni na Uzieli. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Koo za Wamerari zilikuwa ni: Mahli na Mushi. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kulikuwa na koo za Walibni na Washimei kwa Gershoni; hizo zilikuwa koo za Wagershoni. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Idadi ya wanaume wote wa umri wa mwezi mmoja au zaidi waliohesabiwa walikuwa elfu saba na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ukoo wa Wagershoni walitakiwa kuweka kambi zao upande wa magharibi, nyuma ya Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Kiongozi wa jamaa za Wagershoni alikuwa Eliasafu mwana wa Laeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Katika Hema la Kukutania, Wagershoni walikuwa na wajibu wa kutunza Maskani na hema, vifuniko vyake, pazia katika mlango wa kuingilia ndani ya Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","mapazia ya ua, pazia katika ingilio la ua unaozunguka Maskani na madhabahu, pamoja na kamba, na kila kinachohusika kwa matumizi yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kwa Kohathi kulikuwa koo za Waamrami, Waishari, Wahebroni na Wauzieli; hizo zilikuwa koo za Wakohathi. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Hesabu ya wanaume wote wenye umri wa mwezi mmoja au zaidi, walikuwa elfu nane na mia sita. Wakohathi waliwajibika kutunza mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Koo za Wakohathi zilitakiwa kuweka kambi zao upande wa kusini wa Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kiongozi wa jamaa za koo za Wakohathi alikuwa Elisafani mwana wa Uzieli. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Waliwajibika kutunza Sanduku la Agano, meza, kinara cha taa, madhabahu, na vile vyombo vya mahali patakatifu vinavyotumika kuhudumu, pazia, na kila kitu kinachohusika na matumizi yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kiongozi mkuu wa Walawi alikuwa Eleazari mwana wa kuhani, Haruni. Aliwekwa juu ya wale waliowajibika kutunza mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Kwa Merari kulikuwa na koo za Wamahli na Wamushi; hizi zilikuwa koo za Merari. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Hesabu ya wanaume wote wenye umri wa mwaka mmoja au zaidi waliohesabiwa, walikuwa elfu sita na mia mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Kiongozi wa jamaa za koo za Wamerari alikuwa Surieli mwana wa Abihaili. Hawa walitakiwa kuweka kambi zao upande wa kaskazini mwa Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Wamerari waliwekwa kutunza miimo ya Maskani, mataruma yake, nguzo, vitako na vifaa vyake vyote na kila kitu kilichohusika na matumizi yake, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","na pia nguzo za ua unaozunguka pamoja na vitako vyake, vigingi vya hema na kamba zake. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa, na Haruni na wanawe walitakiwa kuweka kambi zao mashariki mwa Maskani, kuelekea mawio ya jua, mbele ya Hema la Kukutania. Wao walihusika na utunzaji wa mahali patakatifu kwa niaba ya Waisraeli. Mtu mwingine yeyote aliyepasogelea mahali patakatifu angeuawa. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Jumla ya hesabu ya Walawi waliohesabiwa na Musa na Haruni kwa amri ya Mwenyezi Mungu, kufuatana na koo zao, pamoja na kila mwanaume mwenye umri wa mwezi mmoja au zaidi, walikuwa elfu ishirini na mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mwenyezi Mungu akamwambia Musa, “Wahesabu wazaliwa wa kwanza wa kiume wote wa Waisraeli wenye umri wa mwezi mmoja au zaidi na uorodheshe majina yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nitwalie Walawi badala ya wazaliwa wa kwanza wa Waisraeli, nayo mifugo ya Walawi badala ya wazaliwa wa mifugo ya Waisraeli. Mimi ndimi Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Hivyo Musa akawahesabu wazaliwa wa kwanza wote wa Waisraeli, kama Mwenyezi Mungu alivyomwamuru. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Jumla ya hesabu ya wazaliwa wa kwanza wanaume wenye umri wa mwezi mmoja au zaidi, walioorodheshwa kwa majina, walikuwa elfu ishirini na mbili na mia mbili na sabini na watatu (22,273). ");
INSERT INTO swhonmm_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Watwae Walawi badala ya wazaliwa wa kwanza wote wa Israeli, nayo mifugo ya Walawi badala ya mifugo yao. Walawi watakuwa wangu. Mimi ndimi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ili kukomboa wazaliwa wa kwanza mia mbili na sabini na watatu (273) wa Waisraeli ambao wamezidi hesabu ya Walawi, ");
INSERT INTO swhonmm_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","kusanya shekeli tano kwa kila mmoja, kufuatana na shekeli ya mahali patakatifu, ambayo ina uzito wa gera ishirini. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Mpe Haruni na wanawe hizo fedha kwa ajili ya ukombozi wa idadi ya Waisraeli waliozidi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kwa hiyo Musa akakusanya fedha za ukombozi kutoka kwa wale ambao hesabu yao ilizidi wale waliokombolewa na Walawi. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kutokana na wazaliwa wa kwanza wa Waisraeli alikusanya fedha yenye uzito wa shekeli elfu moja na mia tatu sitini na tano (1,365) kufuatana na shekeli ya mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa akampa Haruni na wanawe ile fedha ya ukombozi, kama alivyoamriwa na neno la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Wahesabu Wakohathi walio sehemu ya Walawi kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Wahesabu wanaume wote wenye umri wa miaka thelathini hadi hamsini wanaokuja kutumika katika kazi ya Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Hii ndiyo kazi ya Wakohathi katika Hema la Kukutania: Watatunza vitu vilivyo vitakatifu sana. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kambi inapohamishwa, Haruni na wanawe wataingia ndani na kushusha lile pazia la kuzuilia na kufunika nalo Sanduku la Ushuhuda. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Kisha watafunika juu yake na ngozi za pomboo, na kutandaza juu yake kitambaa cha rangi ya buluu iliyokolea na kuingiza mipiko mahali pake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Juu ya meza ya mikate ya Wonesho watatandaza kitambaa cha buluu na waweke sahani juu yake, masinia, bakuli na magudulia kwa ajili ya sadaka za kinywaji; mkate ule ambao upo hapa daima utabaki juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Juu ya hivyo vitu watatandaza kitambaa chekundu na kufunika kwa ngozi za pomboo na kuweka mipiko yake mahali pake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Watachukua kitambaa cha buluu na kufunika kinara cha taa kilicho kwa ajili ya nuru, pamoja na taa zake, mikasi yake, sinia zake, magudulia yake yote yaliyotumika kuwekea mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kisha watakisokotea pamoja na vifaa vyake vyote katika ngozi za pomboo na kukiweka kwenye jukwaa lake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Juu ya madhabahu ya dhahabu watatandaza kitambaa cha buluu na kukifunika kwa ngozi za pomboo na kuweka mipiko yake mahali pake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Watavichukua vyombo vyote vinavyotumika kuhudumia mahali patakatifu, watavisokotea kwenye kitambaa cha buluu na kufunika kwa ngozi za pomboo, na kuviweka juu ya miti ya kuchukulia. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Wataondoa majivu kutoka madhabahu ya shaba na kutandaza kitambaa cha zambarau juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kisha wataweka vyombo vyote juu yake vinavyotumika kwa kuhudumia madhabahuni pamoja na vyombo vya kutolea moto, nyuma, miiko na mabakuli ya kunyunyizia. Juu yake watatandaza ngozi za pomboo ya kufunika, na kuweka mipiko mahali pake. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Baada ya Haruni na wanawe kumaliza kazi ya kufunika samani takatifu na vyombo vyake vyote, watu watakapokuwa tayari kung’oa kambi, Wakohathi watakuja kufanya kazi ya kubeba. Lakini wasije wakagusa vitu vitakatifu la sivyo watakufa. Wakohathi ndio watakaobeba vile vitu vilivyomo katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazari mwana wa Haruni, kuhani, ndiye atakayesimamia mafuta kwa ajili ya taa, uvumba wenye harufu nzuri, sadaka za kila siku za nafaka na mafuta ya upako. Ndiye atakayekuwa msimamizi wa maskani yote ya Mungu na kila kitu kilicho ndani yake, pamoja na samani takatifu na vyombo vyake.” ");
INSERT INTO swhonmm_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Mwenyezi Mungu akawaambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Hakikisheni kwamba koo za kabila la Wakohathi hawatengwi kutoka Walawi. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ili wapate kuishi wala wasife wanapokaribia vitu vitakatifu sana, uwafanyie hivi: Haruni na wanawe wataenda mahali patakatifu na kumgawia kila mtu kazi yake, na kwamba ni nini atakachochukua. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Lakini Wakohathi hawaruhusiwi kuingia ndani ili kuangalia vitu vitakatifu, hata kwa kitambo kidogo, la sivyo watakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Wahesabu pia Wagershoni kwa jamaa zao na koo zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Wahesabu wanaume wote wenye umri wa miaka thelathini hadi hamsini ambao huja kutumika katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Hii ndiyo huduma ya koo za Wagershoni wakati wanapofanya kazi na kubeba mizigo. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Watabeba mapazia ya maskani ya Mungu, yaani Hema la Kukutania, kifuniko chake na kifuniko cha nje cha ngozi za pomboo, mapazia ya maingilio ya Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","mapazia ya ua unaozunguka Maskani na madhabahu, pazia la maingilio, kamba na vifaa vyote vinavyotumika katika huduma yake. Wagershoni watafanya yote yatakiwayo kufanyika na vitu hivi. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Utumishi wao wote ukiwa ni kuchukua au wa kufanya kazi nyingine, utafanyika chini ya maelekezo ya Haruni na wanawe. Mtawapangia kama wajibu wao yote watakayoyafanya. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hii ndiyo huduma ya koo za Wagershoni katika Hema la Kukutania. Wajibu wao utakuwa chini ya maelekezo ya Ithamari mwana wa kuhani Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Wahesabu Wamerari kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Wahesabu wanaume wote kuanzia umri wa miaka thelathini hadi hamsini ambao watakuja kutumika katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Huu ndio wajibu wao wanapofanya huduma katika Hema la Kukutania: kubeba miimo ya Maskani, mataruma yake, nguzo na vitako, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nguzo za ua unaozunguka pamoja na vitako vyake, vigingi vya hema, kamba, vifaa vyake vyote na kila kitu kinachohusiana na matumizi yake. Kila mtu mpangie vitu maalum vya kubeba. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huu ndio utumishi wa koo za Merari kama watakavyofanya kazi katika Hema la Kukutania, chini ya maelekezo ya Ithamari mwana wa kuhani, Haruni.” ");
INSERT INTO swhonmm_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Haruni na viongozi wa jumuiya wakawahesabu Wakohathi kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Wanaume wote kuanzia umri wa miaka thelathini hadi hamsini ambao walikuja kutumika katika Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","waliohesabiwa kwa koo zao, walikuwa elfu mbili na mia saba hamsini (2,750). ");
INSERT INTO swhonmm_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hii ilikuwa ndiyo jumla ya wote wale wa koo za Wakohathi ambao walitumika katika Hema la Kukutania. Musa na Haruni waliwahesabu kufuatana na amri ya Mwenyezi Mungu kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Wagershoni walihesabiwa kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Watu wote kuanzia umri wa miaka thelathini hadi hamsini ambao walikuja kutumika katika Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","waliohesabiwa kwa koo zao na jamaa zao, walikuwa elfu mbili na mia sita na thelathini (2,630). ");
INSERT INTO swhonmm_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hii ilikuwa ndiyo jumla ya wale wa koo za Gershoni ambao walitumika katika Hema la Kukutania. Musa na Haruni waliwahesabu kufuatana na amri ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Wamerari walihesabiwa kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Wanaume wote kuanzia umri wa miaka thelathini hadi miaka hamsini ambao walikuja kutumika katika Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","waliohesabiwa kwa koo zao, walikuwa elfu tatu na mia mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hii ilikuwa ndiyo jumla ya wale wa koo za Wamerari. Musa na Haruni waliwahesabu kufuatia amri ya Mwenyezi Mungu kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hivyo Musa, Haruni na viongozi wa Israeli waliwahesabu Walawi wote kwa koo zao na jamaa zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Wanaume wote wenye umri wa kuanzia miaka thelathini hadi hamsini waliokuja kufanya kazi ya kuhudumu na kubeba Hema la Kukutania ");
INSERT INTO swhonmm_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","walikuwa elfu nane na mia tano themanini (8,580). ");
INSERT INTO swhonmm_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kwa amri ya Mwenyezi Mungu kupitia Musa, kila mmoja aligawiwa kazi yake na kuambiwa kitu cha kubeba. Hivyo ndivyo walivyohesabiwa kama Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Waamuru Waisraeli kumtoa nje ya kambi mtu yeyote mwenye ugonjwa wa ngozi uambukizao, au anayetokwa na majimaji ya aina yoyote, au ambaye ni najisi kwa sababu ya maiti. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hii itakuwa ni kwa wote, yaani wanaume na wanawake; watoeni nje ya kambi ili wasije wakanajisi kambi yao, ambamo ninaishi miongoni mwao”. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Waisraeli wakafanya hivyo; wakawatoa nje ya kambi. Wakafanya kama vile Mwenyezi Mungu alivyokuwa amemwelekeza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Waambie Waisraeli, ‘Mwanaume au mwanamke akimkosea mwenzake kwa njia yoyote, na kwa hivyo akawa si mwaminifu kwa Mwenyezi Mungu, mtu huyo ana hatia, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","na ni lazima atubu dhambi aliyoifanya. Ni lazima atoe malipo kamili kwa ajili ya kosa lake, aongeze sehemu ya tano juu ya malipo hayo na kutoa yote kwa mtu aliyemkosea. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Lakini ikiwa mtu huyo hana jamaa ya karibu ambaye malipo yanaweza kufanywa kwa ajili ya kosa, malipo yatakuwa mali ya Mwenyezi Mungu, nayo ni lazima apewe kuhani, pamoja na kondoo dume ambaye anatumika kufanyia upatanisho kwa ajili yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Matoleo yote matakatifu ya Waisraeli wanayoleta kwa kuhani yatakuwa yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kila kitu cha mtu kilichowekwa wakfu ni chake mwenyewe, lakini kile atoacho kwa kuhani kitakuwa cha kuhani.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Kisha Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Nena na Waisraeli uwaambie: ‘Ikiwa mke wa mtu amepotoka na si mwaminifu kwa mumewe, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kwa kukutana kimwili na mwanaume mwingine, tendo hili likafichika kwa mumewe na unajisi wake usigundulike (kwa kuwa hakuna ushahidi dhidi yake, naye hakukamatwa katika tendo hilo), ");
INSERT INTO swhonmm_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","nazo hisia za wivu zikamjia mumewe na kumshuku mkewe, naye mke yule ni najisi, au mumewe ana wivu na akamshuku ingawa si najisi, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","basi atampeleka mkewe kwa kuhani. Huyo mume itampasa apeleke pia sadaka ya unga wa shayiri kiasi cha sehemu ya kumi ya efa kwa niaba ya mkewe. Huyo mwanaume kamwe asimimine mafuta juu ya huo unga wala asiweke uvumba juu yake, kwa sababu ni sadaka ya nafaka kwa ajili ya wivu, sadaka ya ukumbusho ili kukumbushia uovu. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Kuhani atamleta huyo mwanamke na kumsimamisha mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kisha kuhani atachukua sehemu ya maji matakatifu ndani ya gudulia la udongo na kuchanganya na baadhi ya vumbi kutoka sakafu ya Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Baada ya kuhani kumsimamisha huyo mwanamke mbele za Mwenyezi Mungu, atazifungua nywele za huyo mwanamke na kuweka sadaka ya ukumbusho mikononi mwake, ile sadaka ya nafaka kwa ajili ya wivu, huku kuhani mwenyewe akishikilia yale maji machungu yaletayo laana. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kisha kuhani atamwapiza huyo mwanamke, akimwambia, “Ikiwa hakuna mwanaume mwingine aliyekutana kimwili nawe, wala hujapotoka na kuwa najisi wakati ukiwa umeolewa na mumeo, maji haya machungu yaletayo laana na yasikudhuru. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lakini ikiwa umepotoka wakati ukiwa umeolewa na mume wako na umejinajisi mwenyewe kwa kukutana kimwili na mwanaume mwingine asiyekuwa mumeo”; ");
INSERT INTO swhonmm_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","hapa kuhani atamweka huyo mwanamke chini ya laana ya kiapo akisema: “Mwenyezi Mungu na awafanye watu wako wakulaani na kukukataa, wakati Mwenyezi Mungu atakapolifanya paja lako kupooza na tumbo lako kuvimba. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Maji haya yaletayo laana na yaingie ndani ya mwili wako ili tumbo lako livimbe na paja lako lipooze.” “ ‘Kisha mwanamke atasema, “Amen. Iwe hivyo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Kuhani ataandika laana hizi kwenye kitabu, kisha atazioshea laana hizo kwenye yale maji machungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Kuhani atamnywesha yule mwanamke yale maji machungu yaletayo laana, nayo maji haya yatamwingia na kumsababishia maumivu makali. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kuhani atachukua sadaka ya nafaka kwa ajili ya wivu kutoka mikononi mwa huyo mwanamke, naye ataipunga mbele za Mwenyezi Mungu na kuileta madhabahuni. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kisha kuhani atachota sadaka ya nafaka mkono uliojaa kama sehemu ya kumbukumbu na kuiteketeza juu ya madhabahu, baada ya hayo, atamtaka huyo mwanamke anywe yale maji. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kama amejitia unajisi na kukosa uaminifu kwa mumewe, wakati anapotakiwa anywe maji yale yaletayo laana, yatamwingia na kusababisha maumivu makali; tumbo lake litavimba na paja lake litapooza, naye atakuwa amelaaniwa miongoni mwa watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Hata hivyo, ikiwa huyo mwanamke hakujitia unajisi, naye ni safi, atasafishwa hatia na ataweza kuzaa watoto. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Basi, hii ndiyo sheria ya wivu mwanamke anapopotoka na kujitia unajisi akiwa ameolewa na mumewe, ");
INSERT INTO swhonmm_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","au hisia za wivu zinapomjia mwanaume kwa sababu ya kumshuku mkewe. Kuhani atamfanya huyo mwanamke kusimama mbele za Mwenyezi Mungu na atatumia sheria hii yote kwa huyo mwanamke. ");
INSERT INTO swhonmm_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mume atakuwa hana hatia ya kosa lolote, bali mwanamke atayachukua matokeo ya dhambi yake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Sema na Waisraeli na uwaambie: ‘Ikiwa mwanaume au mwanamke anataka kuweka nadhiri maalum, nadhiri ya kutengwa kwa ajili ya Mwenyezi Mungu kama Mnadhiri, ");
INSERT INTO swhonmm_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ni lazima ajitenge na mvinyo na kinywaji kingine chochote chenye chachu, na kamwe asinywe siki itokanayo na mvinyo au itokanayo na kinywaji kingine chenye chachu. Kamwe asinywe maji ya zabibu wala kula zabibu mbichi au kavu. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Kwa muda wote atakaokuwa Mnadhiri, kamwe hatakula chochote kitokanacho na mzabibu, sio mbegu wala maganda. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Kwa muda wote wa nadhiri yake ya kujitenga kwa ajili ya Mwenyezi Mungu, wembe hautapita kichwani mwake. Ni lazima awe mtakatifu hadi kipindi cha kujitenga kwake kwa ajili ya Mwenyezi Mungu kiishe; ni lazima aache nywele za kichwa chake zirefuke. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kwa kipindi chochote cha kujitenga kwa ajili ya Mwenyezi Mungu, Mnadhiri hatakaribia maiti. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hata kama baba yake mwenyewe au mama au kaka au dada akifa, hatajinajisi mwenyewe kwa ajili yao, kwa sababu ishara ya kujiweka wakfu kwake kwa Mungu ipo katika kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kwa kipindi chote cha kujitenga kwake, yeye ni wakfu kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Kama mtu yeyote akifa ghafula karibu na Mnadhiri, atakuwa ametiwa unajisi nywele zake alizoziweka wakfu, hivyo ni lazima anyoe nywele zake siku ya utakaso wake, yaani siku ya saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Kisha siku ya nane ni lazima alete hua wawili au makinda wawili wa njiwa kwa kuhani katika mlango wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kuhani atatoa mmoja kuwa sadaka ya dhambi, na mwingine kuwa sadaka ya kuteketezwa ili kufanya upatanisho kwa ajili ya Mnadhiri kwa sababu ametenda dhambi kwa kuwa mbele ya maiti. Siku hiyo hiyo atakiweka wakfu tena kichwa chake. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ni lazima ajitoe kabisa kwa Mwenyezi Mungu kwa kipindi cha kujitenga kwake, na ni lazima atoe mwana-kondoo wa kiume wa mwaka mmoja kuwa sadaka ya hatia. Siku zilizopita hazitahesabiwa kwa sababu alijitia unajisi katika siku zake za kujitenga. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Basi hii ndiyo sheria kwa ajili ya Mnadhiri baada ya kipindi chake cha kujitenga kupita. Ataletwa kwenye ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Hapo atatoa sadaka zake kwa Mwenyezi Mungu: mwana-kondoo wa mwaka mmoja asiye na waa kwa ajili ya sadaka ya kuteketezwa, kondoo jike wa mwaka mmoja asiye na waa kwa ajili ya sadaka ya dhambi, kondoo dume asiye na waa kwa ajili ya sadaka ya amani, ");
INSERT INTO swhonmm_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","pamoja na sadaka zake za nafaka na za vinywaji, na kikapu cha mikate isiyotiwa chachu, yaani maandazi yaliyotengenezwa kwa unga laini uliochanganywa na mafuta, na mikate myembamba iliyopakwa mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Kuhani atavileta vitu hivyo mbele za Mwenyezi Mungu na kufanya sadaka ya dhambi na sadaka ya kuteketezwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ataleta pia kikapu cha mikate isiyotiwa chachu, na atatoa dhabihu kondoo dume kuwa sadaka ya amani kwa Mwenyezi Mungu, pamoja na sadaka yake ya nafaka, na ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Kisha kwenye ingilio la Hema la Kukutania, Mnadhiri ni lazima anyoe nywele zake ambazo alikuwa ameziweka wakfu. Atazichukua hizo nywele na kuziweka ndani ya moto ulio chini ya dhabihu ya sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Baada ya Mnadhiri kunyoa hizo nywele zake za kujitenga kwake, kuhani atampa mikononi mwake bega la kondoo dume lililochemshwa, na pia andazi na mkate mwembamba kutoka kikapu, vyote vikiwa vimetengenezwa bila kuwekwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kisha kuhani ataviinua mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa; ni vitakatifu na ni mali ya kuhani, pamoja na kile kidari kilichoinuliwa, na lile paja lililotolewa. Baada ya hayo, Mnadhiri anaweza kunywa divai. ");
INSERT INTO swhonmm_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Hii ndiyo sheria ya Mnadhiri ambaye anaweka nadhiri kwa matoleo yake kwa Mwenyezi Mungu kufuatana na kujitenga kwake, zaidi ya chochote kile anachoweza kupata. Ni lazima atimize nadhiri aliyoiweka kufuatana na sheria ya Mnadhiri.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Mwambie Haruni na wanawe, ‘Hivi ndivyo mtakavyowabariki Waisraeli. Waambieni: ");
INSERT INTO swhonmm_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Mwenyezi Mungu akubariki na kukulinda; ");
INSERT INTO swhonmm_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mwenyezi Mungu akuangazie nuru ya uso wake na kukufadhili; ");
INSERT INTO swhonmm_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mwenyezi Mungu akugeuzie uso wake na kukupa amani.” ’ ");
INSERT INTO swhonmm_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Hivyo wataliweka Jina langu juu ya Waisraeli, nami nitawabariki.” ");
INSERT INTO swhonmm_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa alipomaliza kuisimamisha Maskani, aliipaka mafuta na kuiweka wakfu pamoja na samani zake zote. Pia alitia madhabahu mafuta na kuiweka wakfu, pamoja na vyombo vyake vyote. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ndipo viongozi wa Israeli, wale wakuu wa jamaa waliokuwa viongozi wa kabila wasimamizi wa wale waliohesabiwa, wakatoa sadaka. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Walizileta kama matoleo yao mbele za Mwenyezi Mungu: magari sita ya kukokotwa yaliyofunikwa, pamoja na maksai kumi na wawili; yaani maksai mmoja kutoka kwa kila kiongozi, na gari moja la kukokotwa kutoka kwa kila viongozi wawili. Haya waliyaleta mbele ya Maskani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Vikubali vitu hivi kutoka kwao, ili viweze kutumika katika kazi kwenye Hema la Kukutania. Wapatie Walawi kama kazi ya kila mtu itakavyohitaji.” ");
INSERT INTO swhonmm_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hivyo Musa akachukua yale magari ya kukokotwa pamoja na maksai, na kuwapa Walawi. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Aliwapa Wagershoni magari mawili ya kukokotwa na maksai wanne, kama walivyohitaji kwa kazi yao, ");
INSERT INTO swhonmm_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","na pia aliwapa Wamerari magari manne ya kukokotwa na maksai wanane, kama kazi yao ilivyohitaji. Wote walikuwa chini ya maelekezo ya Ithamari mwana wa kuhani, Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Lakini Musa hakuwapa Wakohathi chochote kati ya hivyo, kwa sababu walitakiwa kubeba vitu vitakatifu mabegani mwao, vile walikuwa wanawajibika. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Madhabahu yalipopakwa mafuta, viongozi walileta sadaka zao kwa ajili ya kule kuwekwa wakfu kwake na kuziweka mbele ya madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kwa maana Mwenyezi Mungu alikuwa amemwambia Musa, “Kila siku kiongozi mmoja ataleta sadaka yake ili kuwekwa wakfu madhabahu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Yule ambaye alileta sadaka yake siku ya kwanza alikuwa Nashoni, mwana wa Aminadabu, wa kabila la Yuda. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Sadaka yake ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Siku ya pili yake Nethaneli mwana wa Suari, kiongozi wa Isakari, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Siku ya tatu Eliabu mwana wa Heloni, kiongozi wa watu wa Zabuloni, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Siku ya nne Elisuri mwana wa Shedeuri, kiongozi wa watu wa Reubeni, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Siku ya tano Shelumieli mwana wa Surishadai, kiongozi wa watu wa Simeoni, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Siku ya sita Eliasafu mwana wa Deueli, kiongozi wa watu wa Gadi, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Siku ya saba Elishama mwana wa Amihudi, kiongozi wa watu wa Efraimu, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Siku ya nane Gamalieli mwana wa Pedasuri, kiongozi wa watu wa Manase, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Siku ya tisa Abidani mwana wa Gideoni, kiongozi wa watu wa Benyamini, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Siku ya kumi Ahiezeri mwana wa Amishadai, kiongozi wa watu wa Dani, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Siku ya kumi na moja Pagieli mwana wa Okrani, kiongozi wa watu wa Asheri, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Siku ya kumi na mbili Ahira mwana wa Enani, kiongozi wa watu wa Naftali, alileta sadaka yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Sadaka aliyoleta ilikuwa: sahani moja ya fedha yenye uzito wa shekeli mia moja na thelathini, na bakuli moja la fedha la kunyunyizia lenye uzito wa shekeli sabini, vyote kulingana na shekeli ya mahali patakatifu, vikiwa vimejazwa unga laini uliochanganywa na mafuta kuwa sadaka ya nafaka; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","sinia moja la dhahabu lenye uzito wa shekeli kumi, likiwa limejazwa uvumba; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","fahali mmoja mchanga, kondoo dume mmoja na mwana-kondoo dume mmoja wa mwaka mmoja, kwa ajili ya sadaka ya kuteketezwa; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","beberu mmoja kwa ajili ya sadaka ya dhambi; ");
INSERT INTO swhonmm_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","maksai wawili, kondoo dume watano, beberu watano na wana-kondoo dume watano wa mwaka mmoja, ili vitolewe dhabihu kama sadaka ya amani. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Hizi ndizo sadaka zilizotolewa na viongozi wa Israeli madhabahu yalipowekwa wakfu, wakati yalipakwa mafuta: sahani kumi na mbili za fedha, bakuli kumi na mbili za fedha za kunyunyizia, na masinia kumi na mawili ya dhahabu. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Kila sahani ya fedha ilikuwa na uzito wa shekeli mia moja na thelathini, na kila bakuli la fedha la kunyunyizia lilikuwa na uzito wa shekeli sabini. Masinia yote kumi na mawili yalikuwa na uzito wa shekeli elfu mbili na mia nne kulingana na shekeli ya mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Sahani kumi na mbili za dhahabu zilizojazwa uvumba zilikuwa na uzito wa shekeli kumi kila moja, kulingana na shekeli ya mahali patakatifu. Kwa jumla, sahani za dhahabu zilikuwa na uzito wa shekeli mia moja na ishirini. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Jumla ya wanyama waliotolewa kwa ajili ya sadaka ya kuteketezwa walikuwa fahali kumi na wawili wachanga, kondoo dume kumi na wawili, na wana-kondoo dume kumi na wawili wa mwaka mmoja, pamoja na sadaka zao za nafaka. Beberu kumi na wawili walitolewa kwa ajili ya sadaka za dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Jumla ya wanyama kwa ajili ya dhabihu ya sadaka ya amani walikuwa maksai ishirini na wanne, kondoo dume sitini, beberu wa mwaka mmoja sitini, na wana-kondoo dume wa mwaka mmoja sitini. ");
INSERT INTO swhonmm_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa alipoingia kwenye Hema la Kukutania kuzungumza na Mwenyezi Mungu, alisikia sauti ikisema naye kutoka kati ya wale makerubi wawili waliokuwa juu ya kile kiti cha rehema, juu ya Sanduku la Ushuhuda. Musa akazungumza na Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Sema na Haruni umwambie, ‘Utakapoziweka zile taa saba, zinatakiwa kuangaza eneo lililo mbele ya kinara cha taa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruni akafanya hivyo; akaziweka zile taa ili zielekee mbele kwenye kinara cha taa, kama vile Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hivi ndivyo kinara cha taa kilivyotengenezwa: Kilitengenezwa kwa dhahabu iliyofuliwa, kuanzia kwenye kitako chake hadi kwenye maua yake. Kinara cha taa kilitengenezwa sawasawa kabisa na kielelezo ambacho Mwenyezi Mungu alikuwa amemwonesha Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Watwae Walawi kutoka miongoni mwa Waisraeli wengine na uwatakase. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ili kuwatakasa, fanya hivi: Nyunyizia maji ya utakaso juu yao; kisha uwaambie wanyoe nywele kwenye mwili mzima, wafue nguo zao na hivyo wajitakase wenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Waambie wamchukue fahali mchanga pamoja na sadaka yake ya nafaka ya unga laini uliochanganywa na mafuta; kisha utamchukua fahali mchanga wa pili kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Walete Walawi mbele ya Hema la Kukutania na ukusanye jumuiya yote ya Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Utawaleta Walawi mbele za Mwenyezi Mungu, na Waisraeli wataweka mikono yao juu ya Walawi. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haruni atawaweka Walawi mbele za Mwenyezi Mungu wawe sadaka ya kuinuliwa kutoka kwa Waisraeli, ili wawe tayari kuifanya kazi ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Baada ya Walawi kuweka mikono yao juu ya vichwa vya hao mafahali wawili, tumia mmoja kwa ajili ya sadaka ya dhambi kwa Mwenyezi Mungu, na mwingine kuwa sadaka ya kuteketezwa, ili kufanya upatanisho kwa ajili ya Walawi. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Waambie hao Walawi wasimame mbele ya Haruni na wanawe, kisha wawatoe wawe sadaka ya kuinuliwa kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kwa njia hii utakuwa umewatenga Walawi kutoka kwa Waisraeli wengine, nao Walawi watakuwa wangu. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Utakapokuwa umekwisha kuwatakasa Walawi na kuwatoa wawe sadaka ya kuinuliwa, watakuja kufanya kazi yao katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Wao ndio Waisraeli ambao watatolewa kabisa kwangu. Nimewatwaa kama mali yangu mwenyewe badala ya mzaliwa wa kwanza, mzaliwa wa kwanza wa kiume kutoka kwa kila mwanamke Mwisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kila mzaliwa wa kwanza wa kiume katika Israeli, awe wa mwanadamu au mnyama, ni wangu. Nilipowaua wazaliwa wote wa kwanza huko Misri, niliwatenga kwa ajili yangu mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nami nimewatwaa Walawi badala ya wazaliwa wote wa kwanza wa kiume katika Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kati ya Waisraeli wote, nimempa Haruni na wanawe Walawi kama zawadi ili wafanye kazi katika Hema la Kukutania kwa niaba ya Waisraeli, na kufanya upatanisho kwa ajili yao ili pasiwepo na pigo lolote litakalowapata Waisraeli wakati watakapokaribia mahali patakatifu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Haruni na jumuiya yote ya Waisraeli wakawafanyia Walawi kama Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Walawi wakajitakasa wenyewe na wakafua nguo zao. Kisha Haruni akawasogeza mbele za Mwenyezi Mungu kuwa sadaka ya kuinuliwa, na kufanya upatanisho kwa ajili yao ili kuwatakasa. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Baada ya hayo, Walawi walikuja kufanya kazi yao katika Hema la Kukutania chini ya usimamizi wa Haruni na wanawe. Waliwafanyia Walawi kama vile Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Hili linawahusu Walawi: Wanaume wenye umri wa miaka ishirini na tano au zaidi watakuja kushiriki katika kazi kwenye Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","lakini watakapofika umri wa miaka hamsini, ni lazima waache kazi zao za kawaida wala wasiendelee. ");
INSERT INTO swhonmm_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Wanaweza kuwasaidia ndugu zao kufanya wajibu wao katika Hema la Kukutania, lakini wao wenyewe kamwe hawatafanya hiyo kazi. Basi, hivi ndivyo utakavyogawa wajibu kwa Walawi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Mwenyezi Mungu akasema na Musa katika Jangwa la Sinai katika mwezi wa kwanza wa mwaka wa pili baada ya Waisraeli kutoka Misri. Akasema, ");
INSERT INTO swhonmm_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Waamuru Waisraeli waadhimishe Pasaka katika wakati ulioamriwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Adhimisheni wakati ulioamriwa, yaani wakati wa kuzama jua siku ya kumi na nne ya mwezi huu, kulingana na desturi zake zote na masharti yake.” ");
INSERT INTO swhonmm_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Hivyo Musa akawaambia Waisraeli waiadhimishe Pasaka, ");
INSERT INTO swhonmm_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","nao wakafanya hivyo kwenye Jangwa la Sinai wakati wa kuzama jua siku ya kumi na nne ya mwezi wa kwanza. Waisraeli wakafanya kila kitu kama vile Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Lakini baadhi yao hawakuweza kuadhimisha Pasaka siku ile kwa sababu walikuwa najisi kwa ajili ya kugusa maiti. Kwa hiyo wakamwendea Musa na Haruni siku ile ile, ");
INSERT INTO swhonmm_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","wakamwambia Musa, “Tumekuwa najisi kwa sababu tumegusa maiti, lakini kwa nini tuzuiliwe kumtolea Mwenyezi Mungu sadaka yake pamoja na Waisraeli wengine katika wakati ulioamriwa?” ");
INSERT INTO swhonmm_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa akawajibu, “Ngojeni hadi nitafute kile Mwenyezi Mungu anachoagiza kuwahusu ninyi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ndipo Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Waambie Waisraeli: ‘Mmoja wenu au wazao wenu wanapokuwa najisi kwa sababu ya maiti au wakiwa safarini, hata hivyo wanaweza kuadhimisha Pasaka ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Wataiadhimisha wakati wa kuzama jua siku ya kumi na nne ya mwezi wa pili. Watamla mwana-kondoo, pamoja na mkate usiotiwa chachu, na mboga chungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Wasibakize chochote hadi asubuhi wala wasivunje mifupa ya mwana-kondoo. Wanapoiadhimisha Pasaka, hawana budi kufuata masharti yote. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Lakini mtu aliyetakasika na hayuko safarini asipoiadhimisha Pasaka, mtu huyo hana budi kukatiliwa mbali na watu wake kwa sababu hakutoa sadaka ya Mwenyezi Mungu kwa wakati ulioamriwa. Mtu huyo atawajibika kubeba matokeo ya dhambi yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Mgeni anayeishi miongoni mwenu ambaye anataka kuiadhimisha Pasaka ya Mwenyezi Mungu, lazima afanye hivyo kwa kufuata desturi na masharti. Lazima masharti yawe sawasawa kwa mgeni na mzawa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Katika siku hiyo ambayo Maskani, Hema la Ushuhuda, iliposimamishwa, wingu liliifunika. Kuanzia jioni hadi asubuhi wingu lililokuwa juu ya Maskani lilionekana kama moto. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hivyo ndivyo lilivyoendelea kuwa; wingu liliifunika wakati wa mchana, na usiku lilionekana kama moto. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Wakati wowote wingu lilipoinuka kutoka juu ya Hema, nao Waisraeli waliondoka; mahali popote wingu lilipotua, Waisraeli walipiga kambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Kwa amri ya Mwenyezi Mungu Waisraeli waliondoka, na kwa amri yake walipiga kambi. Kwa muda wote wingu lilipokaa juu ya Maskani, Waisraeli walibaki kambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Wingu lilipobaki juu ya Maskani kwa muda mrefu, Waisraeli walitii amri ya Mwenyezi Mungu nao hawakuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Wakati mwingine wingu lilikuwa juu ya Maskani kwa siku chache tu; kwa amri ya Mwenyezi Mungu wangepiga kambi na kisha kwa amri yake wangeondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wakati mwingine wingu lilikaa kuanzia jioni hadi asubuhi tu; lilipoinuka asubuhi, nao waliondoka. Iwe ni mchana au usiku, wakati wowote wingu lilipoinuka, waliondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ikiwa wingu lilikaa juu ya Maskani kwa siku mbili au mwezi au mwaka, Waisraeli wangebaki wamepiga kambi na hawakuondoka; lakini lilipoinuka, wangeondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kwa amri ya Mwenyezi Mungu walipiga kambi, na kwa amri ya Mwenyezi Mungu waliondoka. Walitii amri ya Mwenyezi Mungu, kufuatana na agizo lake kupitia Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tengeneza tarumbeta mbili za fedha ya kufua, uzitumie kwa kuita jumuiya pamoja na wakati wa kuvunja makambi ili kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Tarumbeta zote mbili zikipigwa, jumuiya yote itakusanyika mbele yako katika ingilio la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kama tarumbeta moja tu ikipigwa, viongozi, yaani wakuu wa koo za Israeli, ndio watakaokusanyika mbele yako. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Mlio wa kujulisha hatari ukipigwa, makabila yaliyo na makambi upande wa mashariki yataondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Mlio wa pili ukipigwa, walio kwenye makambi ya kusini wataondoka. Mlio huo wa kujulisha hatari utakuwa ishara ya kuondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ili kuwakusanya watu, piga tarumbeta zote, lakini siyo kwa mlio wa kujulisha hatari. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Wana wa Haruni, makuhani, ndio watakaopiga hizo tarumbeta. Hili litakuwa agizo la kudumu kwa ajili yenu na kwa vizazi vijavyo. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Mtakapopigana vita katika nchi yenu wenyewe dhidi ya adui anayewaonea, piga tarumbeta kwa mlio wa kujulisha hatari. Ndipo utakumbukwa na Mwenyezi Mungu, Mungu wenu, na kuokolewa kutoka kwa adui zenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Pia nyakati za furaha yenu, yaani sikukuu zenu zilizoamriwa na sikukuu za Mwezi Mwandamo, mtapiga tarumbeta juu ya sadaka zenu za kuteketezwa na sadaka zenu za amani, nazo zitakuwa ukumbusho kwa ajili yenu mbele za Mungu wenu. Mimi ndimi Mwenyezi Mungu, Mungu wenu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Katika siku ya ishirini ya mwezi wa pili wa mwaka wa pili, wingu liliinuka kutoka juu ya Maskani ya Ushuhuda. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ndipo Waisraeli wakaondoka kutoka Jangwa la Sinai wakasafiri kutoka sehemu moja hadi nyingine hadi wingu lilipotua katika Jangwa la Parani. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Waliondoka kwa mara ya kwanza kwa agizo la Mwenyezi Mungu kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Vikosi vya kambi ya Yuda vilitangulia kwanza chini ya beramu yao. Nashoni mwana wa Aminadabu alikuwa kiongozi wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneli mwana wa Suari alikuwa kiongozi wa kabila la Isakari, ");
INSERT INTO swhonmm_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","naye Eliabu mwana wa Heloni alikuwa kiongozi wa kabila la Zabuloni. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ndipo Maskani iliposhushwa, nao wana wa Gershoni na wana wa Merari ambao waliibeba wakaondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Vikosi vya kambi ya Reubeni vilifuata, chini ya beramu yao. Elisuri mwana wa Shedeuri alikuwa kiongozi wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mwana wa Surishadai aliongoza kikosi cha kabila la Simeoni, ");
INSERT INTO swhonmm_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","naye Eliasafu mwana wa Deueli aliongoza kikosi cha kabila la Gadi. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kisha Wakohathi wakaondoka, wakichukua vitu vitakatifu. Maskani ilipaswa kusimamishwa kabla wao hawajafika. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Vikosi vya kambi ya Efraimu vilifuata, chini ya beramu yao. Elishama mwana wa Amihudi alikuwa kiongozi wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwana wa Pedasuri aliongoza kikosi cha kabila la Manase, ");
INSERT INTO swhonmm_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","naye Abidani mwana wa Gideoni alikuwa kiongozi wa kikosi cha kabila la Benyamini. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Mwishowe, kama kikosi cha nyuma cha ulinzi wa vikosi vyote, vikosi vya kambi ya Dani viliondoka chini ya beramu yao. Ahiezeri mwana wa Amishadai alikuwa kiongozi wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mwana wa Okrani aliongoza kikosi cha kabila la Asheri, ");
INSERT INTO swhonmm_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","naye Ahira mwana wa Enani aliongoza kikosi cha kabila la Naftali. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Huu ndio ulikuwa utaratibu wa kuondoka wa vikosi vya Waisraeli walipokuwa wanaondoka. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Basi Musa akamwambia Hobabu mwana wa Reueli, Mmidiani, mkwewe Musa, “Tunaondoka kwenda mahali ambapo Mwenyezi Mungu amesema ‘Nitawapa ninyi mahali hapo.’ Twende pamoja, nasi tutakutendea mema, kwa maana Mwenyezi Mungu ameahidi mambo mema kwa Israeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Akajibu, “Hapana, sitaenda; nitarudi kwenye nchi yangu mwenyewe na watu wangu mwenyewe.” ");
INSERT INTO swhonmm_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Lakini Musa akasema, “Tafadhali usituache. Wewe unajua mahali yatupasa kupiga kambi jangwani, nawe unaweza kuwa macho yetu. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ikiwa utafuatana nasi, tutashirikiana nawe mema yoyote tutakayopewa na Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Hivyo waliondoka kutoka mlima wa Mwenyezi Mungu, nao wakasafiri kwa siku tatu. Sanduku la Agano la Mwenyezi Mungu liliwatangulia kwa zile siku tatu ili kuwatafutia mahali pa kupumzika. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wingu la Mwenyezi Mungu lilikuwa juu yao wakati wa mchana walipoondoka kambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Wakati wowote Sanduku lilipoondoka, Musa alisema, “Ee Mwenyezi Mungu, inuka! Watesi wako na watawanyike; adui zako na wakimbie mbele zako.” ");
INSERT INTO swhonmm_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Wakati wowote Sanduku liliposimama, alisema, “Ee Mwenyezi Mungu, rudi, kwa maelfu ya Waisraeli wasiohesabika.” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Basi watu wakalalamika kwa habari ya taabu zao masikioni mwa Mwenyezi Mungu, naye alipowasikia, hasira yake ikawaka. Ndipo moto kutoka kwa Mwenyezi Mungu ukawaka miongoni mwao na kuteketeza baadhi ya viunga vya kambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Watu walipomlilia Musa, akamwomba Mwenyezi Mungu, nao moto ukazimika. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Hivyo mahali pale pakaitwa Tabera, kwa sababu moto kutoka kwa Mwenyezi Mungu uliwaka miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Umati wa watu wenye zogo waliokuwa miongoni mwao walitamani sana chakula kingine, Waisraeli wakaanza kulia tena na kusema, “Laiti tungekuwa na nyama tule! ");
INSERT INTO swhonmm_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tunakumbuka wale samaki tuliokula huko Misri bila gharama, pia yale matango, matikitimaji, mboga, vitunguu, na vitunguu saumu. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Lakini sasa tumepoteza hamu ya chakula; hatuoni kitu kingine chochote isipokuwa hii mana!” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ilifanana kama mbegu za giligilani, nayo ilikuwa na rangi ya manjano iliyopauka. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Hao watu walienda kukusanya, kisha waliisaga kwa mawe ya kusagia ya mkono au kuitwanga kwenye vinu. Waliipika vyunguni au kutengeneza maandazi. Ladha yake ilikuwa kama kitu kilichotengenezwa kwa mafuta ya zeituni. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Umande ulipoanguka kambini wakati wa usiku, pia mana ilianguka pamoja nao. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa akasikia watu wa kila jamaa wakilia, kila mmoja kwenye mlango wa hema lake. Mwenyezi Mungu akakasirika mno, naye Musa akafadhaika. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Akamuuliza Mwenyezi Mungu, “Kwa nini umeleta taabu hii juu ya mtumishi wako? Nimekufanyia nini cha kukuchukiza hata ukaweka mzigo huu wa watu hawa wote juu yangu? ");
INSERT INTO swhonmm_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Je, watu hawa wote mimi ndiye niliyewatungisha mimba? Je, ni mimi niliyewazaa? Kwa nini unaniambia niwachukue mikononi mwangu, kama vile mlezi abebavyo mtoto mchanga, hadi kwenye nchi uliyowaahidi baba zao? ");
INSERT INTO swhonmm_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nitapata wapi nyama kwa ajili ya watu wote hawa? Wanaendelea kunililia wakisema, ‘Tupe nyama tule!’ ");
INSERT INTO swhonmm_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mimi siwezi kuwabeba watu hawa wote peke yangu, mzigo ni mzito sana kwangu. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kama hivi ndivyo unavyonitendea, uniue sasa hivi, yaani kama nimepata kibali machoni pako, wala usiniache nione maangamizi yangu mwenyewe.” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mwenyezi Mungu akamwambia Musa: “Niletee wazee sabini wa Israeli, unaowafahamu kama viongozi na maafisa miongoni mwa watu. Walete katika Hema la Kukutania, ili waweze kusimama huko pamoja nawe. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nami nitashuka na kusema nawe huko. Nami nitachukua sehemu ya Roho yangu iliyo juu yako na kuiweka juu yao. Watakusaidia kubeba mzigo wa watu hao ili usije ukaubeba peke yako. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Waambie hao watu: ‘Jiwekeni wakfu wenyewe kwa ajili ya kesho, wakati mtakapokula nyama. Mwenyezi Mungu aliwasikia mlipolia, mkisema, “Laiti tungekuwa na nyama tule! Tulikuwa na hali nzuri zaidi katika nchi ya Misri!” Sasa Mwenyezi Mungu atawapa nyama, nanyi mtaila. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hamtaila kwa siku moja tu, au siku mbili, au tano, kumi au siku ishirini, ");
INSERT INTO swhonmm_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","bali kwa mwezi mzima hadi iwatokee puani, nanyi mtaichukia kabisa, kwa kuwa mmemkataa Mwenyezi Mungu, ambaye yupo miongoni mwenu, nanyi mmelia mbele zake, mkisema, “Hivi kwa nini tulitoka Misri?” ’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Lakini Musa alisema, “Mimi niko hapa miongoni mwa watu elfu mia sita wanaotembea kwa miguu, nawe umesema, ‘Nitawapa nyama ya kula kwa mwezi mzima!’ ");
INSERT INTO swhonmm_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Je, wangeweza kupata nyama ya kuwatosha hata kama makundi ya kondoo na ya ng’ombe yangechinjwa kwa ajili yao? Je, wangetosheka hata kama samaki wote wa baharini wangevuliwa kwa ajili yao?” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mwenyezi Mungu akamjibu Musa, “Je, mkono wa Mwenyezi Mungu ni mfupi sana? Sasa utaona kama jambo nililolisema litatimizwa kwa ajili yako au la.” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kwa hiyo Musa akatoka na kuwaambia watu lile ambalo Mwenyezi Mungu alikuwa amesema. Akawakusanya wazee wao sabini, akawasimamisha kuzunguka Hema. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kisha Mwenyezi Mungu akashuka katika wingu na kunena na Musa, naye akachukua sehemu ya Roho yake iliyokuwa juu ya Musa na kuiweka juu ya wale wazee sabini. Roho wa Mungu aliposhuka juu yao, wakatoa unabii, lakini hawakufanya hivyo tena. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Lakini watu wawili, ambao majina yao ni Eldadi na Medadi, walibaki kambini. Walikuwa wameorodheshwa miongoni mwa wale wazee sabini, lakini hawakutoka kwenda kwenye Hema. Lakini Roho wa Mungu pia alishuka juu yao, nao wakatabiri huko kambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mwanaume mmoja kijana alikimbia na kumwambia Musa, “Eldadi na Medadi wanatoa unabii kambini.” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yoshua mwana wa Nuni, aliyekuwa msaidizi wa Musa tangu ujana wake, akajibu, akasema, “Musa bwana wangu, wanyamazishe!” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Lakini Musa akajibu, “Je, unaona wivu kwa ajili yangu? Ningetamani watu wote wa Mwenyezi Mungu wangekuwa manabii na kwamba Mwenyezi Mungu angeweka Roho yake juu yao!” ");
INSERT INTO swhonmm_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ndipo Musa na wale wazee wa Israeli wakarudi kambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kisha ukatokea upepo kutoka kwa Mwenyezi Mungu, nao ukawaletea kware kutoka baharini. Ukawaangusha kwenye eneo lote linalozunguka kambi na kujaa ardhini kimo cha mita moja hivi kutoka ardhini kwenye eneo la umbali wa mwendo wa siku moja kila upande. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mchana kutwa na usiku kucha pamoja na siku nzima iliyofuata watu walitoka kwenda kuokota kware. Hakuna mtu yeyote aliyekusanya chini ya homeri kumi. Kisha wakazianika kuzunguka kambi yote. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Lakini walipokuwa wakila nyama, ilipokuwa ingali kati ya meno yao na kabla hawajamaliza kula, hasira ya Mwenyezi Mungu ikawaka dhidi ya watu, naye akawapiga kwa tauni. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kwa hiyo mahali hapo pakaitwa Kibroth-Hataava, kwa sababu huko ndiko walipowazika watu ambao walitamani sana chakula kingine. ");
INSERT INTO swhonmm_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kutoka Kibroth-Hataava watu wakasafiri hadi Haserothi na kukaa huko. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu na Haruni walianza kuzungumza dhidi ya Musa kwa sababu ya mke wake Mkushi, kwa kuwa alikuwa ameoa Mkushi. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Waliuliza, “Je, Mwenyezi Mungu amesema kupitia Musa peke yake? Je, hajasema kutupitia sisi pia?” Naye Mwenyezi Mungu akasikia hili. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Basi Musa alikuwa mtu mnyenyekevu sana, mnyenyekevu kuliko mtu mwingine yeyote katika uso wa dunia.) ");
INSERT INTO swhonmm_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ghafula Mwenyezi Mungu akawaambia Musa, Haruni na Miriamu, “Njooni katika Hema la Kukutania, ninyi nyote watatu.” Kwa hiyo wote watatu wakaenda. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kisha Mwenyezi Mungu akashuka katika nguzo ya wingu, akasimama kwenye ingilio la Hema, akawaita Haruni na Miriamu. Waliposogea mbele, ");
INSERT INTO swhonmm_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Mwenyezi Mungu akawaambia, “Sikilizeni maneno yangu: “Akiwepo nabii wa Mwenyezi Mungu miongoni mwenu, nitajifunua kwake kwa maono, nitanena naye katika ndoto. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lakini sivyo kwa mtumishi wangu Musa; yeye ni mwaminifu katika nyumba yangu yote. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Kwake nitanena naye uso kwa uso, waziwazi wala si kwa mafumbo; yeye ataona umbo la Mwenyezi Mungu. Kwa nini basi ninyi hamkuogopa kuzungumza kinyume cha mtumishi wangu Musa?” ");
INSERT INTO swhonmm_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Hasira ya Mwenyezi Mungu ikawaka dhidi yao, akawaacha. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Hilo wingu lilipoinuka kutoka juu ya Hema, Miriamu akawa tayari ana ukoma, mweupe kama theluji. Haruni akamgeukia, akaona ana ukoma. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kisha Haruni akamwambia Musa, “Tafadhali, bwana wangu, usituhesabie dhambi hii ambayo tumeifanya kwa upumbavu. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Usimwache awe kama mtoto mchanga aliyezaliwa akiwa mfu, ambaye nusu ya mwili wake imeharibika hapo atokapo katika tumbo la mama yake.” ");
INSERT INTO swhonmm_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Hivyo Musa akamlilia Mwenyezi Mungu akisema, “Ee Mungu, nakuomba umponye!” ");
INSERT INTO swhonmm_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mwenyezi Mungu akamjibu Musa, “Je, kama baba yake angemtemea usoni, asingeona aibu kwa siku saba? Mfungie nje ya kambi kwa siku saba; baada ya hapo anaweza kurudishwa kambini.” ");
INSERT INTO swhonmm_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kwa hiyo Miriamu akafungiwa nje ya kambi kwa siku saba, nao watu hawakuendelea na safari hadi aliporudishwa kambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Baada ya hayo, watu waliondoka Haserothi, wakapiga kambi katika Jangwa la Parani. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Watume baadhi ya watu wakaipeleleze nchi ya Kanaani, ninayowapa Waisraeli. Kutoka kwa kila kabila la baba zao, tuma mwanaume aliye mmoja wa viongozi wao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Hivyo kwa agizo la Mwenyezi Mungu Musa akawatuma kutoka Jangwa la Parani. Wote walikuwa viongozi wa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Haya ndiyo majina yao: kutoka kabila la Reubeni, Shamua mwana wa Zakuri; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","kutoka kabila la Simeoni, Shafati mwana wa Hori; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","kutoka kabila la Yuda, Kalebu mwana wa Yefune; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","kutoka kabila la Isakari, Igali mwana wa Yusufu; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","kutoka kabila la Efraimu, Hoshea mwana wa Nuni; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","kutoka kabila la Benyamini, Palti mwana wa Rafu; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","kutoka kabila la Zabuloni, Gadieli mwana wa Sodi, ");
INSERT INTO swhonmm_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","kutoka kabila la Manase (kabila la Yusufu), Gadi mwana wa Susi; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","kutoka kabila la Dani, Amieli mwana wa Gemali; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","kutoka kabila la Asheri, Sethuri mwana wa Mikaeli; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","kutoka kabila la Naftali, Nabi mwana wa Wofsi; ");
INSERT INTO swhonmm_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kutoka kabila la Gadi, Geueli mwana wa Maki. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Haya ndiyo majina ya watu ambao Musa aliwatuma kuipeleleza nchi. (Musa akampa Hoshea mwana wa Nuni jina Yoshua.) ");
INSERT INTO swhonmm_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa alipowatuma wakaipeleleze Kanaani, alisema, “Pandeni kupitia Negebu, mwende hadi nchi ya vilima. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mwone nchi ni ya namna gani, na kama watu wanaoishi humo wana nguvu au ni wadhaifu, iwapo ni wachache au wengi. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Wanaishi katika nchi ya namna gani? Je, ni nzuri au mbaya? Wanaishi katika miji ya namna gani? Je, haina kuta au ngome? ");
INSERT INTO swhonmm_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ardhi ikoje? Ina rutuba au la? Je, kuna miti ndani yake au la? Jitahidini kadiri mnavyoweza kuleta baadhi ya matunda ya nchi.” (Ulikuwa msimu wa kuiva zabibu za kwanza.) ");
INSERT INTO swhonmm_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Hivyo wakapanda na kuipeleleza nchi kutoka Jangwa la Sini hadi Rehobu, kuelekea Lebo-Hamathi. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wakapanda kupitia Negebu hadi wakafika Hebroni, mahali ambapo Ahimani, Sheshai na Talmai, wazao wa Anaki, waliishi. (Hebroni ulikuwa umejengwa miaka saba kabla ya mji wa Soani ulioko Misri.) ");
INSERT INTO swhonmm_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Walipofika katika Bonde la Eshkoli, walikata tawi lililokuwa na kishada kimoja cha zabibu. Wawili wao wakalichukua lile tawi kwenye mti, pamoja na komamanga na tini. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Eneo lile likaitwa Bonde la Eshkoli kwa sababu ya kile kishada cha zabibu ambacho Waisraeli walikikata huko. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Baada ya siku arobaini, wakarudi kutoka kuipeleleza nchi. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wakarudi kwa Musa, Haruni na jumuiya yote ya Waisraeli huko Kadeshi kwenye Jangwa la Parani. Hapo ndipo walipotoa habari kwao na kwa kusanyiko lote na kuwaonesha matunda ya hiyo nchi. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wakampa Musa taarifa hii: “Tuliingia katika nchi uliyotutuma, nayo inatiririka maziwa na asali! Hili hapa tunda lake. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Lakini watu wanaoishi huko ni wenye nguvu, na miji yao ina ngome na ni mikubwa sana. Huko tuliona hata wazao wa Anaki. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Waamaleki wanaishi Negebu; Wahiti, Wayebusi na Waamori wanaishi katika nchi ya vilima; nao Wakanaani wanaishi karibu na bahari na kando ya Yordani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kisha Kalebu akawanyamazisha watu mbele ya Musa na kusema, “Imetupasa kupanda na kuimiliki nchi, kwa maana hakika tunaweza kufanya hivyo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lakini watu waliokuwa wamepanda pamoja naye wakasema, “Hatuwezi kuwashambulia wale watu; wana nguvu kuliko sisi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Wakaeneza taarifa mbaya miongoni mwa Waisraeli kuhusu nchi waliyoipeleleza. Wakasema, “Nchi tuliyoipeleleza hula watu wanaoishi ndani yake. Watu wote tuliowaona huko ni majitu. ");
INSERT INTO swhonmm_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tuliwaona Wanefili huko (wazao wa Anaki wanatokana na Wanefili). Tulijiona kama panzi machoni petu wenyewe, nao ndivyo walivyotuona.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Usiku ule watu wote wa jumuiya walipaza sauti zao na kulia kwa sauti kuu. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Waisraeli wote wakanung’unika dhidi ya Musa na Haruni, na kusanyiko lote wakawaambia, “Laiti tungekuwa tumefia humo nchi ya Misri! Au humu kwenye hili jangwa! ");
INSERT INTO swhonmm_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kwa nini Mwenyezi Mungu anatuleta katika nchi hii ili tufe kwa upanga? Wake zetu na watoto wetu watachukuliwa kama nyara. Je, isingekuwa bora kwetu kurudi Misri?” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Wakasemezana wao kwa wao, “Inatupasa kumchagua kiongozi na kurudi Misri.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ndipo Musa na Haruni wakaanguka kifudifudi mbele ya kusanyiko lote la Waisraeli waliokusanyika hapo. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshua mwana wa Nuni na Kalebu mwana wa Yefune, waliokuwa miongoni mwa watu wale walioenda kuipeleleza nchi, wakararua nguo zao, ");
INSERT INTO swhonmm_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","wakasema na kusanyiko lote la Waisraeli, wakawaambia, “Nchi tuliyopita kati yake kuipeleleza ni nzuri sana. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ikiwa Mwenyezi Mungu anapendezwa nasi, atatuongoza kuingia katika nchi ile, nchi inayotiririka maziwa na asali, naye atatupatia nchi hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ila tu msimwasi Mwenyezi Mungu. Wala msiwaogope watu wa nchi hiyo, kwa sababu tutawameza. Ulinzi wao umeondoka, lakini Mwenyezi Mungu yupo pamoja nasi. Msiwaogope.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Lakini kusanyiko lote wakazungumza kuhusu kuwapiga kwa mawe. Ndipo utukufu wa Mwenyezi Mungu ukaonekana katika Hema la Kukutania kwa Waisraeli wote. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mwenyezi Mungu akamwambia Musa, “Watu hawa watanidharau hadi lini? Wataendelea kukataa kuniamini mimi hadi lini, ingawa nimetenda ishara za miujiza miongoni mwao? ");
INSERT INTO swhonmm_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nitawapiga kwa tauni na kuwaangamiza, lakini nitakufanya wewe kuwa taifa kubwa lenye nguvu kuliko wao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa akamwambia Mwenyezi Mungu, “Ndipo Wamisri watasikia juu ya jambo hili! Kwa uweza wako uliwapandisha watu hawa kutoka miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Nao watawaambia wenyeji wa nchi hii jambo hili. Wao tayari wameshasikia kwamba wewe, Ee Mwenyezi Mungu, upo pamoja na watu hawa, na kuwa wewe, Ee Mwenyezi Mungu, umeonekana uso kwa uso, nalo wingu lako hukaa juu yao. Tena wewe unawatangulia kwa nguzo ya wingu mchana na kwa nguzo ya moto usiku. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ikiwa utawaua watu hawa wote mara moja, mataifa ambayo yamesikia taarifa hii kukuhusu wewe watasema, ");
INSERT INTO swhonmm_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mwenyezi Mungu alishindwa kuwaingiza watu hawa katika nchi aliyowaahidi kwa kiapo; hivyo akawaua jangwani.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Basi sasa nguvu za Bwana na zionekane, sawasawa na ulivyosema: ");
INSERT INTO swhonmm_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Mwenyezi Mungu si mwepesi wa hasira, ni mwingi wa upendo na mwenye kusamehe dhambi na uasi. Lakini haachi kumwadhibu mwenye hatia, huadhibu watoto kwa ajili ya dhambi ya baba zao hata kizazi cha tatu na cha nne.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kwa kadiri ya upendo wako mkuu, usamehe dhambi ya watu hawa, kama vile ulivyowasamehe tangu walipotoka Misri hadi sasa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mwenyezi Mungu akajibu, “Nimewasamehe kama ulivyoomba. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Hata hivyo, kwa hakika kama niishivyo, na kwa hakika kama utukufu wa Mwenyezi Mungu uijazavyo dunia yote, ");
INSERT INTO swhonmm_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","hakuna hata mmoja wa watu hawa ambao waliuona utukufu wangu na ishara za miujiza niliyotenda huko Misri na huko jangwani, lakini ambaye hakunitii na akanijaribu mara hizi kumi, ");
INSERT INTO swhonmm_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","hakuna hata mmoja wao atakayeona nchi niliyowaahidi baba zao kwa kiapo. Hakuna hata mmoja ambaye amenidharau atakayeiona. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lakini kwa sababu mtumishi wangu Kalebu ana roho ya tofauti na ananifuata kwa moyo wote, nitamwingiza katika nchi aliyoiendea, nao wazao wake watairithi. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kwa kuwa Waamaleki na Wakanaani wanaishi katika mabonde, kesho geukeni mwelekee jangwani kwa kufuata njia iendayo Bahari ya Shamu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mwenyezi Mungu akamwambia Musa na Haruni: ");
INSERT INTO swhonmm_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Jumuiya hii ovu itanung’unika dhidi yangu hadi lini? Nimesikia malalamiko ya hawa Waisraeli wanaonung’unika. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hivyo waambie, ‘Hakika kama niishivyo, asema Mwenyezi Mungu, nitawafanyia vitu vilevile nilivyosikia mkisema: ");
INSERT INTO swhonmm_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kila mmoja wenu mwenye umri wa miaka ishirini au zaidi ambaye alihesabiwa na amenung’unika dhidi yangu, miili yenu itaanguka katika jangwa hili. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Hakuna hata mmoja wenu atakayeingia katika nchi niliyoapa kwa mkono ulioinuliwa kuwa makao yenu, isipokuwa Kalebu mwana wa Yefune, na Yoshua mwana wa Nuni. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Lakini watoto wenu ambao mlisema watachukuliwa mateka, nitawaingiza humo ili waifurahie nchi ambayo ninyi mmeikataa. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Bali ninyi, miili yenu itaanguka katika jangwa hili. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Watoto wenu watakuwa wachungaji wa mifugo hapa kwa miaka arobaini, wakiteseka kwa ajili ya kukosa uaminifu kwenu, hadi mwili wa mtu wenu wa mwisho ulale katika jangwa hili. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kwa miaka arobaini, mwaka mmoja kwa kila siku katika zile siku arobaini mlizoipeleleza nchi, mtateseka kwa ajili ya dhambi zenu, na kujua jinsi ilivyo vibaya kunifanya mimi kuwa adui yenu.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mimi Mwenyezi Mungu nimesema, na hakika nitafanya mambo haya kwa jumuiya hii yote ovu, ambayo imefungamana pamoja dhidi yangu. Watakutana na mwisho wao katika jangwa hili; hapa ndipo watafia.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Hivyo watu wale ambao Musa alikuwa amewatuma kuipeleleza nchi, waliorudi na kuifanya jumuiya nzima kunung’unika dhidi ya Musa kwa kueneza taarifa mbaya kuhusu hiyo nchi: ");
INSERT INTO swhonmm_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","watu hawa waliohusika kueneza taarifa mbaya kuhusu hiyo nchi walipigwa na kuanguka kwa tauni mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Miongoni mwa watu walioenda kuipeleleza hiyo nchi, ni Yoshua mwana wa Nuni, na Kalebu mwana wa Yefune peke yao waliosalia. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa alipotoa taarifa hii kwa Waisraeli wote, waliomboleza kwa uchungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Asubuhi na mapema siku iliyofuata, walipanda kilele kirefu cha nchi ya vilima, wakasema, “Tumetenda dhambi. Tutakwea hadi mahali Mwenyezi Mungu alipotuahidi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Lakini Musa akasema, “Kwa nini hamtii amri ya Mwenyezi Mungu? Jambo hili halitafanikiwa! ");
INSERT INTO swhonmm_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Msipande juu, kwa kuwa Mwenyezi Mungu hayupo pamoja nanyi. Mtashindwa na adui zenu, ");
INSERT INTO swhonmm_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","kwa kuwa Waamaleki na Wakanaani watapambana nanyi huko. Kwa sababu mmemwacha Mwenyezi Mungu, hatakuwa pamoja nanyi, ninyi mtaanguka kwa upanga.” ");
INSERT INTO swhonmm_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Hata hivyo, kwa kiburi chao walipanda juu kuelekea nchi ya vilima virefu, ijapokuwa Musa hakutoka kambini wala Sanduku la Agano la Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ndipo Waamaleki na Wakanaani walioishi katika hiyo nchi ya vilima wakateremka na kuwashambulia, wakawapiga njia yote hadi Horma. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Sema na Waisraeli uwaambie: ‘Baada ya ninyi kuingia katika nchi ninayowapa kama nyumbani, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","nanyi mkitoa sadaka za kuteketezwa kwa moto, kutoka makundi ya ng’ombe au kondoo, kama harufu nzuri inayompendeza Mwenyezi Mungu, ikiwa ni sadaka za kuteketezwa au dhabihu, kwa ajili ya nadhiri maalum ama sadaka ya hiari au sadaka ya sikukuu zenu, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ndipo yeye aletaye sadaka yake ataiweka mbele za Mwenyezi Mungu sadaka ya nafaka, sehemu ya kumi ya efa ya unga laini uliochanganywa na robo ya hini ya mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pamoja na kila mwana-kondoo kwa ajili ya sadaka ya kuteketezwa au dhabihu, andaa robo ya hini ya divai kwa sadaka ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Pamoja na kondoo dume, andaa sadaka ya nafaka ya sehemu mbili za kumi ya efa ya unga laini uliochanganywa na theluthi moja ya hini ya mafuta, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","na theluthi moja ya hini ya divai kuwa sadaka ya kinywaji. Vitoe kama harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Unapoandaa fahali mchanga kama sadaka ya kuteketezwa au dhabihu, kwa ajili ya nadhiri maalum au sadaka ya amani kwa Mwenyezi Mungu, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","leta pamoja na huyo fahali sadaka ya nafaka ya unga laini sehemu tatu za kumi ya efa uliochanganywa na nusu ya hini ya mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Pia utaleta nusu ya hini ya divai kuwa sadaka ya kinywaji. Itakuwa sadaka iliyoteketezwa kwa moto, harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Kila fahali au kondoo dume, kila mwana-kondoo au mbuzi mchanga, atatayarishwa kwa njia hii. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Fanyeni hivi kwa ajili ya kila mmoja, kwa kadiri ya wingi wa mtakavyoandaa. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Kila mmoja ambaye ni mzawa ni lazima afanye vitu hivi kwa njia hii hapo aletapo sadaka ya kuteketezwa kwa moto kama harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kwa vizazi vijavyo, wakati wowote mgeni au mtu mwingine yeyote anayeishi miongoni mwenu aletapo sadaka ya kuteketezwa kuwa harufu nzuri ya kumpendeza Mwenyezi Mungu, ni lazima afanye sawasawa kabisa na jinsi mnavyofanya ninyi. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Jumuiya itakuwa na sheria hizo hizo kwenu na kwa mgeni aishiye miongoni mwenu; hili ni agizo la kudumu kwa vizazi vijavyo. Ninyi na mgeni mtakuwa sawa mbele za Mwenyezi Mungu: ");
INSERT INTO swhonmm_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sheria hizo na masharti hayo vitawahusu ninyi na pia mgeni aishiye miongoni mwenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Sema na Waisraeli na uwaambie: ‘Mtakapoingia katika nchi ninayowapeleka, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","nanyi mkala chakula cha nchi hiyo, toeni sehemu ya chakula hicho kuwa sadaka kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Toeni andazi kutoka kwa malimbuko ya chakula chenu kitokacho katika ardhi, na mkitoe kama sadaka kutoka sakafu ya kupuria nafaka. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kwa vizazi vyote vijavyo hamna budi kutoa sadaka hii kwa Mwenyezi Mungu kutoka kwa malimbuko ya unga wenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Basi kama pasipo kukusudia umeshindwa kushika mojawapo katika amri hizi ambazo Mwenyezi Mungu alimpa Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","amri yoyote ya Mwenyezi Mungu kwenu kupitia Musa, tangu siku ile Mwenyezi Mungu alipowapa na inaendelea hadi vizazi vyote vijavyo; ");
INSERT INTO swhonmm_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ikiwa hili limefanyika pasipo kukusudia bila jumuiya kuwa na habari nalo, basi jumuiya yote itatoa fahali mchanga kuwa sadaka ya kuteketezwa ikiwa harufu nzuri inayompendeza Mwenyezi Mungu, pamoja na sadaka ya nafaka na ya kinywaji zilizoamriwa kwayo, na beberu kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kuhani atafanya upatanisho kwa ajili ya jumuiya yote ya Waisraeli, nao watasamehewa, kwa kuwa haikuwa makusudi nao wamemletea Mwenyezi Mungu sadaka iliyoteketezwa kwa moto na sadaka ya dhambi kwa ajili ya kosa lao. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Jumuiya yote ya Waisraeli pamoja na wageni wanaoishi miongoni mwao watasamehewa, kwa sababu watu wote walihusika katika kosa lile lisilokusudiwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Lakini kama mtu mmoja peke yake akitenda dhambi pasipo kukusudia, ni lazima alete mbuzi jike wa mwaka mmoja kwa ajili ya sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kuhani atafanya upatanisho mbele za Mwenyezi Mungu kwa ajili ya yule aliyekosa kwa kufanya dhambi pasipo kukusudia, upatanisho utakapofanywa kwa ajili yake, atasamehewa. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Sheria hiyo moja itamhusu kila mmoja ambaye ametenda dhambi pasipo kukusudia, awe Mwisraeli mzawa ama mgeni. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Lakini yeyote ambaye amefanya dhambi kwa dharau awe mzawa au mgeni, anamkufuru Mwenyezi Mungu, naye mtu huyo ni lazima akatiliwe mbali na watu wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Kwa sababu amelidharau neno la Mwenyezi Mungu na kuvunja amri zake, mtu huyo ni lazima akatiliwe mbali; hatia yake inabaki juu yake.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Waisraeli walipokuwa jangwani, mtu mmoja alikutwa akikusanya kuni siku ya Sabato. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wale waliomkuta akikusanya kuni wakamleta kwa Musa, na Haruni na kusanyiko lote, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","nao wakamweka kifungoni, kwa sababu haikufahamika kwa wazi kwamba afanyiwe nini. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ndipo Mwenyezi Mungu akamwambia Musa, “Huyo mtu ni lazima afe. Kusanyiko lote lazima wampige mawe nje ya kambi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Hivyo kusanyiko wakamtoa nje ya kambi na kumpiga mawe hadi akafa, kama Mwenyezi Mungu alivyomwamuru Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Sema na Waisraeli uwaambie: ‘Kwa vizazi vyote vijavyo jifanyieni vifundo katika pindo za mavazi yenu vikiwa na uzi wa buluu kwenye kila kifundo. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mtakuwa mkivitazama vifundo hivyo ili mpate kukumbuka amri zote za Mwenyezi Mungu, ili mpate kuzitii msije mkajitia uzinzi wenyewe kwa kuzifuata tamaa za mioyo yenu na za macho yenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ndipo mtakumbuka kuzitii amri zangu zote nanyi mtawekwa wakfu kwa Mungu wenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mimi Ndimi Mwenyezi Mungu, Mungu wenu, niliyewatoa Misri niwe Mungu wenu. Mimi Ndimi Mwenyezi Mungu, Mungu wenu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora mwana wa Ishari, mwana wa Kohathi, mwana wa Lawi, pamoja na baadhi ya Wareubeni, yaani Dathani na Abiramu, wana wa Eliabu, na Oni mwana wa Pelethi, wakachukua baadhi ya watu, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","wakainuka dhidi ya Musa. Pamoja nao walikuwa wanaume Waisraeli mia mbili na hamsini, watu waliojulikana, viongozi wa jumuiya waliokuwa wameteuliwa kuwa wakuu wa kusanyiko. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wakaja kama kikundi kuwapinga Musa na Haruni, wakawaambia, “Ninyi mmejitukuza sana! Kusanyiko hili wote ni watakatifu, kila mmoja wao, naye Mwenyezi Mungu yu pamoja nao. Kwa nini basi mmejitukuza wenyewe juu ya kusanyiko la Mwenyezi Mungu?” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa aliposikia jambo hili, akaanguka kifudifudi. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Kisha akamwambia Kora na wafuasi wake wote: “Asubuhi Mwenyezi Mungu ataonesha ni nani aliye wake na ni nani aliye mtakatifu, tena atamtaka mtu huyo aje kwake. Mtu yule ambaye atamchagua atamfanya kuja karibu naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wewe Kora na wafuasi wako wote mtafanya hivi: Chukueni vyetezo, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","kesho wekeni moto na uvumba kwenye hivyo vyetezo mbele za Mwenyezi Mungu. Mtu ambaye Mwenyezi Mungu atamchagua atakuwa ndiye mtakatifu. Ninyi Walawi mmejitukuza sana!” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Pia Musa akamwambia Kora, “Enyi Walawi! Sasa nisikilizeni. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Haiwatoshi ninyi kwamba Mungu wa Israeli amewateua ninyi kutoka kusanyiko lote la Israeli, na kuwaleta karibu naye mpate kufanya kazi kwenye Maskani ya Mwenyezi Mungu, na kusimama mbele ya kusanyiko ili kuwahudumia? ");
INSERT INTO swhonmm_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Amekuleta wewe na ndugu zako Walawi mwe karibu naye; lakini sasa unajaribu kuchukua ukuhani pia. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Wewe na wafuasi wako wote mmekusanyika pamoja kinyume cha Mwenyezi Mungu. Haruni ni nani kwamba ninyi mnung’unike dhidi yake?” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kisha Musa akawaita Dathani na Abiramu, wana wa Eliabu. Lakini wao wakasema, “Sisi hatuji! ");
INSERT INTO swhonmm_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Haitoshi tu kwamba wewe umetuleta kutoka nchi inayotiririka maziwa na asali ili kutuua sisi jangwani? Nawe sasa pia unataka kuwa mkuu juu yetu? ");
INSERT INTO swhonmm_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Zaidi ya hayo, hujatuingiza katika nchi inayotiririka maziwa na asali, wala hujatupatia urithi wa mashamba na mashamba ya mizabibu. Je, utayang’oa macho ya watu hawa? Hapana, sisi hatuji!” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ndipo Musa akakasirika sana na kumwambia Mwenyezi Mungu, “Usiikubali sadaka yao. Mimi sikuchukua chochote, hata punda kutoka kwao, wala sijamkosea hata mmoja wao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa akamwambia Kora, “Wewe na wafuasi wako wote kesho mtatokea mbele za Mwenyezi Mungu: wewe na hao wenzako, pamoja na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kila mtu atachukua chetezo chake na kuweka uvumba ndani, vyetezo mia mbili na hamsini kwa jumla, na kukileta mbele za Mwenyezi Mungu. Wewe na Haruni mtaleta vyetezo vyenu pia.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kwa hiyo kila mtu akachukua chetezo chake, akaweka moto na uvumba ndani, na kusimama pamoja na Musa na Haruni kwenye mlango wa Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora alipokuwa amekusanya wafuasi wake wote kuwapinga Musa na Haruni kwenye mlango wa Hema la Kukutania, utukufu wa Mwenyezi Mungu ukatokea kwa kusanyiko lote. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mwenyezi Mungu akamwambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Jitengeni na kusanyiko hili ili nipate kuwaangamiza mara moja.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Lakini Musa na Haruni wakaanguka kifudifudi na kulia kwa sauti, wakasema, “Ee Mungu, Mungu wa roho za wanadamu wote, utakuwa na hasira na kusanyiko lote wakati ni mtu mmoja tu ametenda dhambi?” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ndipo Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Waambie kusanyiko, ‘Ondokeni hapo karibu na mahema ya Kora, Dathani na Abiramu.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa akainuka na kuwaendea Dathani na Abiramu, nao wazee wa Israeli wakafuatana naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa akawaonya kusanyiko, “Sogeeni nyuma mbali na mahema ya hawa watu waovu! Msiguse kitu chochote kilicho mali yao, la sivyo mtafagiliwa mbali kwa sababu ya dhambi zao zote.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hivyo wakaondoka karibu na mahema ya Kora, Dathani na Abiramu. Dathani na Abiramu walikuwa wametoka nje, nao walikuwa wamesimama pamoja na wake zao, watoto wao na wale wanyonyao kwenye mlango wa mahema yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ndipo Musa akasema, “Hivi ndivyo mtakavyojua kuwa Mwenyezi Mungu amenituma kufanya mambo haya, na kwamba halikuwa wazo langu. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ikiwa watu hawa watakufa kifo cha kawaida na kupatwa na yale ya kawaida yanayowapata wanadamu, basi Mwenyezi Mungu hakunituma mimi. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Lakini ikiwa Mwenyezi Mungu ataleta jambo jipya kabisa, ardhi ikifunua kinywa chake na kuwameza wao, pamoja na kila kitu kilicho mali yao, nao washuke chini kaburini wakiwa hai, ndipo mtafahamu kuwa watu hawa wamemdharau Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mara Musa alipomaliza kusema haya yote, ardhi iliyokuwa chini yao ikapasuka, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","nchi ikafunua kinywa chake na kuwameza wao, pamoja na jamaa zao, na watu wote wa Kora na mali yao yote. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wakashuka chini kaburini wakiwa hai, pamoja na kila kitu walichokuwa nacho; nchi ikajifunika juu yao, nao wakaangamia wakatoweka kutoka kwa kusanyiko. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Kutoka kilio chao, Waisraeli wote waliowazunguka walikimbia, wakipaza sauti, “Nchi inatumeza na sisi pia!” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Moto ukaja kutoka kwa Mwenyezi Mungu, ukawateketeza wale watu mia mbili na hamsini waliokuwa wakifukiza uvumba. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mwambie Eleazari mwana wa kuhani Haruni, atoe vyetezo kwenye mabaki ya moto na kutawanya makaa mbali kiasi, kwa maana vyetezo ni vitakatifu: ");
INSERT INTO swhonmm_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","vyetezo vya watu waliofanya dhambi iliyowagharimu maisha yao. Fua vyetezo hivyo kuwa bamba ili kufunika madhabahu, kwa maana vimeletwa mbele za Mwenyezi Mungu na vimekuwa vitakatifu. Navyo viwe ishara kwa Waisraeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Hivyo kuhani Eleazari akavikusanya vile vyetezo vya shaba vilivyoletwa na wale waliokuwa wameteketezwa kwa moto, naye akavifua kufunika madhabahu, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","kama vile Mwenyezi Mungu alivyomwelekeza kupitia Musa. Hili lilikuwa kuwakumbusha Waisraeli kwamba hakuna mtu hata mmoja, isipokuwa mzao wa Haruni, awezaye kuja kufukiza uvumba mbele za Mwenyezi Mungu, la sivyo, angekuwa kama Kora na wafuasi wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Siku iliyofuata jumuiya yote ya Waisraeli wakanung’unika dhidi ya Musa na Haruni, wakisema, “Mmewaua watu wa Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Lakini kusanyiko walipokusanyika kupingana na Musa na Haruni, nao wakageuka kuelekea Hema la Kukutania, ghafula wingu likafunika Hema, nao utukufu wa Mwenyezi Mungu ukatokea. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ndipo Musa na Haruni wakaenda mbele ya Hema la Kukutania, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","naye Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Jitenge mbali na kusanyiko hili ili niweze kuwaangamiza mara moja.” Wakaanguka kifudifudi. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kisha Musa akamwambia Haruni, “Chukua chetezo chako na uweke uvumba ndani, pamoja na moto kutoka madhabahuni, nawe uende haraka kwenye kusanyiko ili kufanya upatanisho kwa ajili yao. Ghadhabu imekuja kutoka kwa Mwenyezi Mungu, na tauni imeanza.” ");
INSERT INTO swhonmm_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Hivyo Haruni akafanya kama Musa alivyosema, akakimbilia katikati ya kusanyiko. Tauni ilikuwa tayari imeanza miongoni mwa watu, lakini Haruni akafukiza uvumba na kufanya upatanisho kwa ajili yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Haruni akasimama kati ya waliokuwa hai na waliokufa, nayo tauni ikakoma. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Lakini walikufa watu elfu kumi na nne na mia saba kutokana na tauni hiyo, licha ya wale waliokuwa wamekufa kwa sababu ya Kora. ");
INSERT INTO swhonmm_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ndipo Haruni akamrudia Musa kwenye mlango wa Hema la Kukutania, kwa maana tauni ilikuwa imekoma. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Sema na Waisraeli, na ujipatie fimbo kumi na mbili kutoka kwao, moja kutoka kwa kila mmoja wa viongozi wa makabila ya baba zao. Andika jina la kila mtu kwenye fimbo yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Kwenye fimbo ya Lawi andika jina la Haruni, kwa maana ni lazima iwepo fimbo moja kwa kila kiongozi kwa ajili ya kila kabila la baba zao. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ziweke hizo fimbo ndani ya Hema la Kukutania mbele ya Sanduku la Ushuhuda, mahali nikutanapo nawe. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Fimbo ya mtu nitakayemchagua itachipuka, nami mwenyewe nitayakomesha haya manung’uniko ya mara kwa mara ya Waisraeli dhidi yako.” ");
INSERT INTO swhonmm_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hivyo Musa akasema na Waisraeli, nao viongozi wao wakampa fimbo kumi na mbili, fimbo moja kwa ajili ya kila kabila la baba zao, nayo fimbo ya Haruni ikiwa miongoni mwa hizo. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa akaziweka hizo fimbo mbele za Mwenyezi Mungu ndani ya Hema la Ushuhuda. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Siku iliyofuata Musa aliingia kwenye Hema la Ushuhuda akaona ile fimbo ya Haruni ambayo iliwakilisha jamaa ya Lawi haikuwa tu imechipuka, bali pia ilikuwa imetoa machipukizi, kuchanua maua na kuzaa malozi. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ndipo Musa akaleta zile fimbo zote kwa Waisraeli wote kutoka mbele za Mwenyezi Mungu. Wakaziangalia, na kila mtu akaichukua fimbo yake mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mwenyezi Mungu akamwambia Musa, “Rudisha fimbo ya Haruni mbele ya Sanduku la Ushuhuda, ili ihifadhiwe kama alama kwa waasi. Hili litakomesha manung’uniko yao dhidi yangu, ili wasife.” ");
INSERT INTO swhonmm_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa akafanya kama Mwenyezi Mungu alivyomwamuru. ");
INSERT INTO swhonmm_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Waisraeli wakamwambia Musa, “Tutakufa! Tumepotea, sote tumepotea! ");
INSERT INTO swhonmm_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Yeyote akaribiaye Maskani ya Mwenyezi Mungu atakufa. Je, sisi sote tutakufa?” ");
INSERT INTO swhonmm_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mwenyezi Mungu akamwambia Haruni, “Wewe, wanao na jamaa ya baba yako mtawajibika kwa makosa dhidi ya mahali patakatifu, na wewe na wanao peke yenu ndio mtakaowajibika kwa makosa dhidi ya ukuhani. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Walete Walawi wenzako kutoka kabila la baba zako ili waungane nanyi na kuwasaidia wakati wewe na wanao mnapohudumu mbele ya Hema la Ushuhuda. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Watawajibika kwenu na watafanya kazi zote za Hema, lakini kamwe wasisogelee vifaa vya patakatifu au madhabahu, la sivyo wao na ninyi mtakufa. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Watajiunga nanyi na watawajibika kwa utunzaji wa Hema la Kukutania, yaani kazi zote kwenye Hema, wala hakuna mtu mwingine yeyote atakayeweza kusogea karibu hapo mlipo. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Mtawajibika katika utunzaji wa mahali patakatifu na madhabahu, ili ghadhabu isiwaangukie Waisraeli tena. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mimi mwenyewe nimewachagua Walawi wenzenu kutoka miongoni mwa Waisraeli kama zawadi kwenu, waliowekwa wakfu kwa Mwenyezi Mungu ili kufanya kazi katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lakini ni wewe tu na wanao mtakaoweza kutumika kama makuhani kuhusiana na kila kitu kwenye madhabahu na ndani ya pazia. Ninawapa utumishi wa ukuhani kama zawadi. Mtu mwingine yeyote atakayekaribia mahali patakatifu ni lazima auawe.” ");
INSERT INTO swhonmm_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Kisha Mwenyezi Mungu akamwambia Haruni, “Mimi mwenyewe nimekuweka kuwa mwangalizi wa sadaka zote zitakazotolewa kwangu; matoleo yote matakatifu Waisraeli wanayonipa ninakupa wewe na wanao kuwa sehemu yenu na fungu lenu la milele. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mtachukua sehemu ya yale matoleo matakatifu sana ambayo hayateketezwi kwa moto. Kutoka kwa matoleo yote wanayoniletea kama sadaka takatifu sana, ziwe za nafaka, au za dhambi, au za makosa, sehemu ile itakuwa yako na wanao. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mtaila kama kitu kilicho kitakatifu sana; kila mwanaume ataila. Ni lazima mtaiheshimu kama takatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Hiki pia ni chako: chochote kilichotengwa kutoka matoleo yote ya sadaka za kuinuliwa za Waisraeli. Haya ninakupa wewe, na wanao wa kiume na wa kike kuwa sehemu yenu ya milele. Kila mmoja wa nyumba yako ambaye ametakasika anaweza kuyala. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ninawapa mafuta ya zeituni yaliyo bora kuliko yote, na divai mpya iliyo bora kuliko zote na nafaka wanazompa Mwenyezi Mungu kama malimbuko katika mavuno yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Malimbuko yote ya nchi ambayo wanamletea Mwenyezi Mungu yatakuwa yenu. Kila mmoja nyumbani mwako ambaye ametakasika anaweza kula. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kila kitu katika Israeli ambacho kimetolewa kwa Mwenyezi Mungu ni chenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Kila mzaliwa wa kwanza wa mwanadamu na wa mnyama, ambaye ametolewa kwa Mwenyezi Mungu ni wenu. Lakini ni lazima mtamkomboa kila mwana mzaliwa wa kwanza na kila mzaliwa wa kwanza wa kiume wa wanyama wasio safi. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Watakapokuwa na umri wa mwezi mmoja, ni lazima mtawakomboa kwa bei ya ukombozi iliyowekwa, kwa shekeli tano za fedha, kulingana na shekeli ya mahali patakatifu, yenye uzito wa gera ishirini. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Lakini kamwe usimkomboe mzaliwa wa kwanza wa maksai, kondoo au mbuzi; hawa ni watakatifu. Nyunyizia damu yao juu ya madhabahu na uchome mafuta yao kuwa sadaka inayotolewa kwa moto, harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama zao zitakuwa chakula chenu, kama ilivyokuwa kidari cha kuinuliwa na paja la mguu wa kulia. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Chochote kitakachotengwa kutoka sadaka takatifu ambazo Waisraeli wanamtolea Mwenyezi Mungu, ninakupa wewe, na wanao wa kiume na wa kike kuwa fungu lenu la milele. Ni agano la milele la chumvi mbele za Mwenyezi Mungu, kwako na wazao wako.” ");
INSERT INTO swhonmm_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mwenyezi Mungu akamwambia Haruni, “Hutakuwa na urithi wowote katika nchi yao, wala hutakuwa na sehemu miongoni mwao; Mimi ni fungu lako na urithi wako miongoni mwa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Ninawapa Walawi zaka yote katika Israeli kama urithi wao kuwa kama malipo kwa kazi wanayoifanya wakati wanapohudumu katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kuanzia sasa, kamwe Waisraeli wasisogelee karibu na Hema la Kukutania, la sivyo watabeba matokeo ya dhambi zao, nao watakufa. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ni Walawi watakaofanya kazi katika Hema la Kukutania na kubeba wajibu wa makosa dhidi yake. Hili ni agizo la kudumu kwa vizazi vijavyo. Hawatapokea urithi wowote miongoni mwa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Badala yake, ninawapa Walawi zaka zote zinazotolewa na Waisraeli kama sadaka kwa Mwenyezi Mungu kuwa urithi wao. Hiyo ndiyo sababu nimesema hivi kuwahusu: ‘Hawatakuwa na urithi miongoni mwa Waisraeli.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Sema na Walawi na uwaambie: ‘Mtakapopokea zaka kutoka kwa Waisraeli ninayowapa kama urithi wenu kutoka kwao, ni lazima mtoe sehemu ya kumi ya hiyo zaka kuwa sadaka kwa Mwenyezi Mungu, iwe zaka ya hiyo zaka. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Sadaka yenu itahesabiwa kwenu kama nafaka kutoka sakafu ya kupuria, au divai kutoka shinikizo la kukamulia zabibu. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Kwa njia hii, ninyi pia mtatoa sadaka kwa Mwenyezi Mungu kutoka zaka zote mtakazopokea kutoka kwa Waisraeli. Kutoka kwa zaka hizi, ni lazima mtoe sehemu ya Mwenyezi Mungu kwa Haruni, kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ni lazima mtoe kama sehemu ya Mwenyezi Mungu iliyo nzuri sana tena ile sehemu iliyo takatifu sana kuliko zote ya kile kitu mlichopewa.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Waambie Walawi: ‘Mtakapotoa sehemu zilizo bora sana, itahesabiwa kwenu kama mazao ya sakafu ya kupuria nafaka, au ya shinikizo la kukamulia zabibu. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ninyi na watu wa nyumbani mwenu mnaweza kula sehemu iliyobaki mahali popote, kwani ndio ujira wenu kwa ajili ya kazi yenu katika Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kwa kutoa sehemu zake zilizo bora sana, hamtakuwa na hatia katika jambo hili; ndipo hamtatia unajisi sadaka takatifu za Waisraeli, nanyi hamtakufa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mwenyezi Mungu akamwambia Musa na Haruni: ");
INSERT INTO swhonmm_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Hivi ndivyo sheria ambayo Mwenyezi Mungu ameagiza itakavyo: Waambie Waisraeli wakuletee mtamba mwekundu asiye na dosari wala waa, na ambaye hajapata kufungwa nira. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mpeni kuhani Eleazari huyo mtamba; naye atatolewa nje ya kambi na kuchinjwa mbele yake huyo kuhani. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kisha kuhani Eleazari atachukua sehemu ya damu yake kwenye kidole chake, na kuinyunyiza mara saba kuelekea upande wa mbele ya Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Wakati angali akitazama, mtamba huyo atateketezwa: ngozi yake, nyama yake, damu na sehemu zake za ndani. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kuhani atachukua kuni za mti wa mwerezi, hisopo na sufu nyekundu, na kuvitupa kwenye huyo mtamba anayeungua. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Baada ya hayo, kuhani lazima afue nguo zake, na aoge mwili wake kwa maji. Kisha anaweza kurudi kambini, lakini atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mtu amchomaye huyo mtamba lazima naye pia afue nguo zake na kuoga kwa maji, naye pia atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Mtu ambaye ametakaswa atakusanya majivu ya mtamba huyo na kuyaweka mahali nje ya kambi palipo safi. Yatahifadhiwa na jumuiya ya Waisraeli kwa matumizi katika maji ya utakaso; ni kwa ajili ya kutakasa kutoka dhambini. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mtu akusanyaye majivu ya huyo mtamba ni lazima pia afue nguo zake, kadhalika naye pia atakuwa najisi hadi jioni. Hili litakuwa agizo la kudumu kwa Waisraeli na kwa wageni wanaoishi miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Mtu yeyote agusaye maiti ya mtu yeyote atakuwa najisi kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ni lazima ajitakase mwenyewe kwa maji katika siku ya tatu na siku ya saba, ndipo atakuwa safi. Lakini kama hatajitakasa mwenyewe katika siku ya tatu na ya saba, hatakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Mtu yeyote agusaye maiti ya mtu yeyote na kushindwa kujitakasa mwenyewe hunajisi Maskani ya Mwenyezi Mungu. Mtu huyo ni lazima akatiliwe mbali na Israeli. Kwa sababu hajanyunyiziwa maji ya utakaso, yeye ni najisi; unajisi wake unabaki juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Hii ndiyo sheria itumikayo wakati mtu amekufa ndani ya hema: Yeyote aingiaye ndani ya hema hilo na yeyote aliye ndani yake watakuwa najisi kwa muda wa siku saba, ");
INSERT INTO swhonmm_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","nacho kila chombo kisicho na kifuniko juu yake kitakuwa najisi. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Mtu yeyote aliye nje mahali pa wazi agusaye mtu aliyeuawa kwa upanga au mtu aliyekufa kwa kifo cha kawaida, au mtu yeyote agusaye mfupa wa mtu aliyekufa au kaburi, atakuwa najisi kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Kwa mtu aliye najisi, weka majivu ya sadaka ya utakaso wa dhambi ndani ya chombo, umimine maji safi juu yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kisha mtu aliyetakasika atachukua hisopo, achovye ndani ya maji, na kunyunyizia hema na vifaa vyote pamoja na watu ambao walikuwamo. Pia ni lazima amnyunyizie mtu yeyote ambaye amegusa mfupa wa mtu aliyekufa, au kaburi, au mtu aliyeuawa, au mtu ambaye amekufa kifo cha kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mtu ambaye ni safi ndiye atakayemnyunyizia yeyote ambaye ni najisi siku ya tatu na siku ya saba, na katika siku ya saba atamtakasa mtu huyo. Mtu ambaye ametakaswa lazima afue nguo zake na kuoga kwa maji, na jioni ile atakuwa safi. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Lakini ikiwa mtu ambaye ni najisi hakujitakasa mwenyewe, ni lazima akatiliwe mbali na jumuiya, kwa sababu ameinajisi Maskani ya Mwenyezi Mungu. Maji ya utakaso hayajanyunyizwa juu yake, naye ni najisi. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hili ni agizo la kudumu kwao. “Mtu anayenyunyiza yale maji ya utakaso lazima pia afue nguo zake, na yeyote anayegusa maji ya utakaso atakuwa najisi hadi jioni. ");
INSERT INTO swhonmm_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kitu chochote anachogusa mtu aliye najisi kitakuwa najisi, na yeyote akigusaye huwa najisi hadi jioni.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Katika mwezi wa kwanza, jumuiya yote ya Waisraeli walifika kwenye Jangwa la Sini, nao wakakaa Kadeshi. Miriamu akafa huko na kuzikwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Mahali hapo hapakuwa na maji kwa ajili ya jumuiya hiyo, nao wakakusanyika ili kumpinga Musa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Watu wakagombana na Musa, na kusema, “Laiti tungekufa ndugu zetu walipokufa mbele za Mwenyezi Mungu! ");
INSERT INTO swhonmm_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Kwa nini mmewaleta jumuiya ya Mwenyezi Mungu kwenye jangwa hili, ili tufe humu, sisi na mifugo yetu? ");
INSERT INTO swhonmm_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kwa nini mmetupandisha kutoka Misri hadi mahali hapa pa kutisha? Hapa hakuna nafaka wala tini, zabibu au makomamanga. Wala hapa hakuna maji ya kunywa!” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Haruni wakaondoka pale kwenye kusanyiko hadi kwenye mlango wa Hema la Kukutania na kuanguka kifudifudi, nao utukufu wa Mwenyezi Mungu ukawatokea. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Chukua ile fimbo, na wewe na ndugu yako Haruni mkawakusanye watu wote. Nena na ule mwamba mbele ya macho yao, nao utatoa maji yake. Utatoa maji kutoka huo mwamba kwa ajili ya jumuiya ili wao na mifugo yao waweze kunywa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kwa hiyo Musa akaichukua hiyo fimbo kutoka pale ilipokuwa mbele za Mwenyezi Mungu kama alivyomwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Haruni wakakusanya kusanyiko pamoja mbele ya huo mwamba, naye Musa akawaambia, “Sikilizeni, enyi waasi. Je, ni lazima tuwatoleeni maji kutoka mwamba huu?” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ndipo Musa akainua mkono wake na kuupiga mwamba mara mbili kwa fimbo yake. Maji yakabubujika, nayo jumuiya na mifugo yao wakanywa. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Lakini Mwenyezi Mungu akamwambia Musa na Haruni, “Kwa sababu hamkuniamini mimi kiasi cha kuniheshimu kama mtakatifu machoni pa Waisraeli, hamtaiingiza jumuiya hii katika nchi ninayowapa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Haya yalikuwa maji ya Meriba, ambapo Waisraeli waligombana na Mwenyezi Mungu, naye akajionesha kuwa mtakatifu kati yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa akawatuma wajumbe kutoka Kadeshi kwenda kwa mfalme wa Edomu, akisema: “Hili ndilo ndugu yako Israeli asemalo: Wewe unafahamu juu ya taabu zote ambazo zimetupata. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Baba zetu walishuka Misri, nasi tumeishi huko miaka mingi. Wamisri walitutesa sisi na baba zetu, ");
INSERT INTO swhonmm_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","lakini tulipomlilia Mwenyezi Mungu, alisikia kilio chetu na akamtuma malaika akatutoa Misri. “Sasa tupo hapa Kadeshi, mji ulio mpakani mwa nchi yako. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tafadhali turuhusu tupite katika nchi yako. Hatutapita katika shamba lolote, wala shamba la mizabibu, au kunywa maji kwenye kisima chochote. Tutasafiri kufuata njia kuu ya mfalme, na hatutageuka kulia wala kushoto hadi tuwe tumeshapita nchi yako.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lakini mfalme wa Edomu akajibu: “Hamtapita hapa. Mkijaribu kupita, tutatoka na kuwashambulia kwa upanga.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Waisraeli wakajibu: “Sisi tutafuata njia kuu; tena ikiwa sisi au mifugo yetu tutakunywa tone la maji yenu, tutalilipia. Sisi tunataka tu kupita kwa miguu, wala si kitu kingine chochote.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Watu wa Edomu wakajibu tena: “Hamwezi kupita hapa.” Ndipo watu wa Edomu wakatoka dhidi ya Waisraeli, jeshi kubwa lenye nguvu. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Kwa kuwa Waedomu waliwakatalia Waisraeli kupita katika nchi yao, Israeli wakageuka, wakawaacha. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Jumuiya yote ya Waisraeli wakaondoka Kadeshi, wakafika kwenye Mlima Hori. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Kwenye Mlima Hori, karibu na mpaka wa Edomu, Mwenyezi Mungu akamwambia Musa na Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Haruni atakusanywa pamoja na watu wake. Hataingia katika nchi ninayowapa Waisraeli, kwa sababu ninyi wawili mliasi dhidi ya agizo langu kwenye maji ya Meriba. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Watwae Haruni na Eleazari mwanawe, na uwapandishe juu katika Mlima Hori. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mvue Haruni mavazi yake, na umvike Eleazari mwanawe, kwa maana Haruni atakusanywa pamoja na watu wake; atakufa huko.” ");
INSERT INTO swhonmm_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa akafanya kama Mwenyezi Mungu alivyomwagiza: Wakapanda Mlima Hori mbele ya macho ya jumuiya yote ya Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa akamvua Haruni mavazi yake na kumvika mwanawe Eleazari mavazi hayo. Naye Haruni akafia pale juu ya mlima. Kisha Musa na Eleazari wakateremka kutoka mlimani. ");
INSERT INTO swhonmm_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Jumuiya yote walipofahamu kwamba Haruni amekufa, Waisraeli wote wakamwomboleza kwa siku thelathini. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mfalme wa Aradi, aliyekuwa Mkanaani aliyeishi huko Negebu, aliposikia kwamba Waisraeli walikuwa wanakuja kwa njia ya Atharimu, aliwashambulia Waisraeli na kuwateka baadhi yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ndipo Israeli akaweka nadhiri hii kwa Mwenyezi Mungu: “Ikiwa utawatia watu hawa mikononi mwetu, tutaiangamiza kabisa miji yao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mwenyezi Mungu akasikiliza ombi la Waisraeli, naye akawapa ushindi juu ya Wakanaani. Wakawaangamiza kabisa na miji yao; hivyo mahali pale pakaitwa Horma. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Waisraeli wakasafiri kutoka Mlima Hori kupitia njia inayoelekea Bahari ya Shamu, kuizunguka Edomu. Lakini watu wakakosa uvumilivu njiani, ");
INSERT INTO swhonmm_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","wakamnung’unikia Mungu na Musa, wakisema, “Kwa nini umetupandisha kutoka Misri ili tufe jangwani? Hakuna mkate! Hakuna maji! Nasi tunachukia sana chakula hiki duni!” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ndipo Mwenyezi Mungu akapeleka nyoka wenye sumu kati yao; wakawauma watu, nao Waisraeli wengi wakafa. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Watu wakamjia Musa na kusema, “Tumetenda dhambi wakati tuliponena dhidi ya Mwenyezi Mungu na dhidi yako. Mwombe Mwenyezi Mungu ili atuondolee hawa nyoka.” Hivyo Musa akawaombea hao watu. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mwenyezi Mungu akamwambia Musa, “Tengeneza nyoka wa shaba na umweke juu ya mti; yeyote aliyeumwa na nyoka anaweza kumtazama na akaishi tena.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kwa hiyo Musa akatengeneza nyoka wa shaba na kumweka juu ya mti. Kisha wakati mtu yeyote aliumwa na nyoka, naye akamtazama yule nyoka wa shaba, aliishi. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Waisraeli waliendelea na safari yao na wakapiga kambi huko Obothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kisha wakaondoka Obothi na kupiga kambi huko Iye-Abarimu, katika jangwa linalotazamana na Moabu kuelekea mawio ya jua. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kutoka hapo waliendelea mbele wakapiga kambi kwenye Bonde la Zeredi. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Wakasafiri kutoka hapo na kupiga kambi kando ya Mto Arnoni, ambao uko katika jangwa lililoenea hadi nchi ya Waamori. Mto Arnoni ni mpaka wa Moabu, kati ya Moabu na Waamori. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ndiyo sababu Kitabu cha Vita vya Mwenyezi Mungu kinasema: “Wahebu nchini Sufa, na mabonde, Mto Arnoni, ");
INSERT INTO swhonmm_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na miteremko ya mabonde inayofika hadi makazi ya Ari, na kuegemea mpakani mwa Moabu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kutoka hapo waliendelea mbele hadi kisima cha Beeri; kwenye kisima ambacho Mwenyezi Mungu alimwambia Musa, “Wakusanye watu pamoja, nami nitawapa maji.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Kisha Israeli akaimba wimbo huu: “Bubujika, ee kisima! Imba kuhusu maji, ");
INSERT INTO swhonmm_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","kuhusu kisima ambacho kilichimbwa na wakuu, ambacho watu mashuhuri walikifukua, watu mashuhuri wakiwa na fimbo za utawala na bakora.” Kisha wakatoka jangwani kwenda Matana, ");
INSERT INTO swhonmm_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kutoka Matana wakafika Nahalieli, kutoka Nahalieli wakafika Bamothi, ");
INSERT INTO swhonmm_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kutoka Bamothi wakafika kwenye bonde lililoko Moabu, mahali kilele cha Pisga kinatazamana na nyika. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israeli akawatuma wajumbe kumwambia Sihoni mfalme wa Waamori: ");
INSERT INTO swhonmm_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Uturuhusu tupite katika nchi yako. Hatutageuka kando kwenda katika mashamba au mashamba ya mizabibu, ama kunywa maji kutoka kisima chochote. Tutasafiri kwenye njia kuu ya mfalme hata tutakapokuwa tumekwisha kupita katika nchi yako.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Lakini Sihoni hakumruhusu Israeli apite katika nchi yake. Alilikutanisha jeshi lake lote, wakaondoka kwenda jangwani ili kupigana na Israeli. Alipofika huko Yahazi, akapigana na Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Hata hivyo, Israeli walimshinda kwa upanga na kuimiliki nchi yake kutoka Mto Arnoni hadi Mto Yaboki, lakini ni kufikia nchi ya Waamoni tu, kwa sababu mipaka yake ilikuwa imezungushwa ukuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israeli wakaiteka miji yote ya Waamori na kuimiliki, pamoja na Heshboni na makazi yote yanayoizunguka. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshboni ulikuwa mji wa Sihoni mfalme wa Waamori, aliyekuwa amepigana dhidi ya mfalme wa Moabu aliyetangulia, na akawa amechukua ardhi yake yote hadi Mto Arnoni. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ndiyo sababu watunga mashairi husema: “Njoo Heshboni na ujengwe tena; mji wa Sihoni na ufanywe upya. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Moto uliwaka kutoka Heshboni, mwali wa moto kutoka mji wa Sihoni. Uliteketeza Ari ya Moabu, raia wa mahali pa Arnoni palipoinuka. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ole wako, ee Moabu! Umeharibiwa, enyi watu wa Kemoshi! Amewatoa wanawe kuwa wakimbizi, na binti zake kama mateka kwa Mfalme Sihoni wa Waamori. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Lakini tumewashinda; Heshboni umeharibiwa hadi Diboni. Tumebomoa hadi kufikia Nofa, ulioenea hadi Medeba.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Kwa hiyo Israeli akaishi katika nchi ya Waamori. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Baada ya Musa kutuma wapelelezi kwenda mji wa Yazeri, Waisraeli waliteka makazi ya mji huo, na kuwafukuza Waamori walioishi huko. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kisha wakageuka na kwenda katika njia inayoelekea Bashani, naye Ogu mfalme wa Bashani pamoja na jeshi lake lote wakatoka kupigana nao huko Edrei. ");
INSERT INTO swhonmm_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mwenyezi Mungu akamwambia Musa, “Usimwogope Ogu, kwa sababu nimeshamkabidhi mikononi mwako, pamoja na jeshi lake lote na nchi yake. Mtendee kama ulivyomtendea Sihoni mfalme wa Waamori, ambaye alitawala huko Heshboni.” ");
INSERT INTO swhonmm_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Kwa hiyo wakamuua, pamoja na wanawe na jeshi lake lote, bila ya kumwacha hata mtu mmoja hai. Nao wakaimiliki nchi yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Kisha Waisraeli wakasafiri katika tambarare za Moabu na kupiga kambi kando ya Mto Yordani, ng’ambo ya Yeriko. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Basi Balaki mwana wa Sipori, aliona mambo yale yote ambayo Israeli aliwatendea Waamori, ");
INSERT INTO swhonmm_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moabu aliogopa, kwa kuwa walikuwa watu wengi sana. Hakika, Moabu alijawa na hofu kubwa kwa sababu ya Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Wamoabu wakawaambia wazee wa Midiani, “Umati huu wa watu unaenda kuramba kila kitu kinachotuzunguka, kama maksai anavyoramba majani ya shambani.” Kwa hiyo Balaki mwana wa Sipori, aliyekuwa mfalme wa Moabu wakati huo, ");
INSERT INTO swhonmm_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","akatuma wajumbe kwenda kumwita Balaamu mwana wa Beori, aliyekuwa huko Pethori, karibu na Mto, katika nchi yake ya kuzaliwa. Balaki akasema: “Taifa limekuja kutoka Misri, nao wamefunika uso wa nchi, nao wamekaa karibu nami. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Sasa uje kuwalaani watu hawa, kwa kuwa wana nguvu sana kuliko mimi. Kisha huenda nikaweza kuwashinda na kuwatoa nje ya nchi. Kwa kuwa ninajua kwamba, wale unaowabariki wanabarikiwa na wale unaowalaani wanalaaniwa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Wazee wa Moabu na wa Midiani wakaondoka, wakiwa wamechukua ada ya uaguzi. Walipoenda kwa Balaamu, wakamweleza kile Balaki alikuwa amesema. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu akawaambia, “Mlale hapa usiku huu, nami nitawaletea jibu lile Mwenyezi Mungu atakalonipa.” Kwa hiyo wakuu wa Moabu wakakaa naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mungu akamjia Balaamu na kumuuliza, “Watu gani hawa walio pamoja nawe?” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu akamwambia Mungu, “Balaki mwana wa Sipori, mfalme wa Moabu, alinipelekea ujumbe huu: ");
INSERT INTO swhonmm_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Taifa ambalo limekuja kutoka Misri limefunika uso wa nchi. Sasa uje unilaanie hao watu. Kisha huenda nitaweza kupigana nao na kuwafukuza.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Lakini Mungu akamwambia Balaamu, “Usiende pamoja nao. Hupaswi kulaani watu hao, kwa kuwa wamebarikiwa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Asubuhi iliyofuata Balaamu akaamka, akawaambia wakuu wa Balaki, “Rudini katika nchi yenu, kwa kuwa Mwenyezi Mungu amenikataza nisiende pamoja nanyi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kwa hiyo wakuu wa Moabu wakarudi kwa Balaki na kumwambia, “Balaamu amekataa kuja pamoja nasi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Kisha Balaki akatuma wakuu wengine, wengi zaidi na wanaoheshimiwa kuliko wale wa kwanza. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wakafika kwa Balaamu na kumwambia: “Balaki mwana wa Sipori amesema hivi: Usiruhusu kitu chochote kikuzuie kuja kwangu, ");
INSERT INTO swhonmm_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","kwa sababu nitakulipa vizuri sana na kufanya lolote usemalo. Njoo unilaanie watu hawa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Lakini Balaamu akawajibu, “Hata kama Balaki angenipa jumba lake la kifalme likiwa limejazwa fedha na dhahabu, singeweza kufanya kitu chochote kikubwa au kidogo ili kutenda kitu nje ya agizo la Mwenyezi Mungu, Mungu wangu. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mlale hapa usiku huu kama wale wengine walivyofanya, nami nitatafuta ni nini kingine Mwenyezi Mungu atakachoniambia.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Usiku ule Mungu akamjia Balaamu na kumwambia, “Kwa kuwa watu hawa wamekuja kukuita wewe, nenda nao, lakini ufanye tu lile nitakalokuambia.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu akaamka asubuhi, akatandika punda wake akaenda pamoja na wakuu wa Moabu. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Lakini Mungu alikasirika sana alipoenda, naye malaika wa Mwenyezi Mungu akasimama barabarani kumpinga. Balaamu alikuwa amepanda punda wake, na watumishi wake wawili walikuwa pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Punda alipomwona malaika wa Mwenyezi Mungu akiwa amesimama barabarani, na upanga ukiwa mkononi mwake, punda akageukia upande kuelekea shambani. Balaamu akampiga ili amrudishe barabarani. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ndipo malaika wa Mwenyezi Mungu akasimama katika njia nyembamba iliyo kati ya mashamba mawili ya mizabibu, yakiwa na kuta pande zote mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Punda alipomwona malaika wa Mwenyezi Mungu, alijisukumiza karibu na ukuta, na kugandamiza mguu wa Balaamu ukutani. Ndipo Balaamu akampiga tena punda. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kisha malaika wa Mwenyezi Mungu akaendelea mbele na kusimama mahali pembamba ambapo hapakuwa na nafasi ya kugeuka mkono wa kulia wala wa kushoto. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Punda alipomwona malaika wa Mwenyezi Mungu, alilala chini Balaamu angali amempanda, naye Balaamu akakasirika na kumpiga kwa fimbo yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Kisha Mwenyezi Mungu akakifungua kinywa cha punda, akamwambia Balaamu, “Nimekutendea nini kinachokufanya unipige mara hizi tatu?” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu akamjibu punda, “Umenifanya mjinga! Kama ningekuwa na upanga mkononi mwangu, ningekuua sasa hivi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Punda akamwambia Balaamu, “Je, mimi si punda wako mwenyewe, ambaye umenipanda siku zote, hadi leo? Je, nimekuwa na tabia ya kufanya hivi kwako?” Akajibu, “Hapana.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kisha Mwenyezi Mungu akafungua macho ya Balaamu, naye akamwona malaika wa Mwenyezi Mungu amesimama barabarani akiwa ameufuta upanga wake. Balaamu akainama, akaanguka kifudifudi. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malaika wa Mwenyezi Mungu akamuuliza Balaamu, “Kwa nini umempiga punda wako mara tatu hizi? Nimekuja kukuzuia kwa sababu njia yako imepotoka mbele yangu. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Punda aliniona na kunikwepa mara hizi tatu. Kama punda hangenikwepa, hakika ningekuwa nimeshakuua sasa, lakini ningemwacha punda hai.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu akamwambia malaika wa Mwenyezi Mungu, “Nimetenda dhambi. Sikutambua kuwa umesimama barabarani kunizuia. Basi kama haikupendezi, nitarudi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malaika wa Mwenyezi Mungu akamwambia Balaamu, “Uende na watu hao, lakini useme tu lile nikuambialo.” Kwa hiyo Balaamu akaenda na wale wakuu wa Balaki. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki aliposikia kuwa Balaamu anakuja, akatoka kumlaki katika mji wa Moabu, katika mpaka wa Mto Arnoni, ukingoni mwa nchi yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki akamwambia Balaamu, “Je, sikukupelekea jumbe za haraka? Kwa nini hukuja kwangu? Hivi kweli mimi siwezi kukulipa?” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu akajibu, “Vema, sasa nimekuja kwako. Lakini kwani nina uwezo wa kusema tu chochote? Ni lazima niseme tu kile ambacho Mungu ataweka kinywani mwangu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Kisha Balaamu alienda na Balaki hadi Kiriath-Husothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki akatoa dhabihu ya ng’ombe na kondoo; baadhi yake akampa Balaamu na wakuu waliokuwa pamoja naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Asubuhi iliyofuata Balaki akamchukua Balaamu hadi Bamoth-Baali, na kutoka huko Balaamu akawaona baadhi ya watu. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu akasema, “Nijengee hapa madhabahu saba, mnitayarishie mafahali saba na kondoo dume saba.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki akafanya kama Balaamu alivyosema; hao wawili kila mmoja wao akatoa fahali mmoja na kondoo dume mmoja juu ya kila madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kisha Balaamu akamwambia Balaki, “Kaa hapa kando ya sadaka yako wakati mimi ninaenda kando. Huenda Mwenyezi Mungu atakuja kukutana nami. Lolote atakalonifunulia, nitakuambia.” Basi akaenda hata mahali peupe palipoinuka. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mungu akakutana naye, kisha Balaamu akasema, “Nimekwisha kutengeneza madhabahu saba, na juu ya kila madhabahu nimetoa sadaka ya fahali mmoja na kondoo dume mmoja.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mwenyezi Mungu akaweka ujumbe katika kinywa cha Balaamu na kusema, “Rudi kwa Balaki umpe ujumbe huu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Basi Balaamu akarudi kwa Balaki, akamkuta amesimama kando ya sadaka yake akiwa na wakuu wote wa Moabu. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ndipo Balaamu akasema ujumbe wake: “Balaki amenileta kutoka Aramu, mfalme wa Moabu kutoka milima ya mashariki. Akasema, ‘Njoo, unilaanie Yakobo; njoo unishutumie Israeli.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nitawezaje kuwalaani, hao ambao Mungu hajawalaani? Nitawezaje kuwashutumu hao ambao Mwenyezi Mungu hakuwashutumu? ");
INSERT INTO swhonmm_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kutoka vilele vya miamba ninawaona, kutoka mahali palipoinuka ninawatazama. Ninaliona taifa ambalo wanaishi peke yao, nao hawahesabiwi kama mojawapo ya mataifa. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ni nani awezaye kuhesabu mavumbi ya Yakobo, au kuhesabu robo ya Israeli? Mimi na nife kifo cha mtu mwenye haki, na mwisho wangu na uwe kama wao!” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki akamwambia Balaamu, “Ni nini ulichonitendea? Nimekuleta ulaani adui zangu, lakini wewe badala yake umewabariki!” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu akajibu, “Je, hainipasi kusema kile Mwenyezi Mungu anachoweka katika kinywa changu?” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ndipo Balaki akamwambia, “Twende pamoja mahali pengine ambapo unaweza kuwaona; utawaona baadhi tu wala si wote. Nawe kutoka huko, unilaanie hao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Basi akampeleka kwenye shamba la Sofimu, juu ya kilele cha Mlima Pisga. Pale akajenga madhabahu saba na kutoa sadaka ya fahali na kondoo dume mmoja juu ya kila madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu akamwambia Balaki, “Kaa hapa kando ya sadaka yako wakati ninapoenda kuonana na Mungu kule.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mwenyezi Mungu akakutana na Balaamu, akaweka ujumbe katika kinywa chake akasema, “Rudi kwa Balaki umpe ujumbe huu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Basi Balaamu akarudi kwa Balaki, akamkuta amesimama kando ya sadaka yake, akiwa na wakuu wa Moabu. Balaki akamuuliza, “Je, Mwenyezi Mungu amesema nini?” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ndipo Balaamu akasema ujumbe wake: “Balaki, inuka na usikilize, nisikie mimi, wewe mwana wa Sipori. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mungu si mtu, hata aseme uongo, wala yeye si mwanadamu, hata ajute. Je, anasema, kisha asitende? Je, anaahidi, asitimize? ");
INSERT INTO swhonmm_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nimepokea agizo kubariki; amebariki, nami siwezi kubadilisha. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Haijaonekana bahati mbaya katika Yakobo, wala taabu katika Israeli. Mwenyezi Mungu, Mungu wao, yu pamoja nao, nayo sauti kuu ya Mfalme imo kati yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mungu aliwatoa kutoka Misri; wao wana nguvu kama za nyati. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Hakuna uchawi dhidi ya Yakobo, wala hakuna uaguzi dhidi ya Israeli. Sasa itasemwa kuhusu Yakobo na Israeli, ‘Tazama yale Mungu aliyotenda!’ ");
INSERT INTO swhonmm_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Taifa lainuka kama simba jike; linajiinua kama simba ambaye hatulii hadi amalize kurarua mawindo yake na kunywa damu ya mawindo yake.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Kisha Balaki akamwambia Balaamu, “Usiwalaani kabisa, wala usiwabariki kabisa!” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaamu akajibu, “Je, sikukuambia ni lazima nifanye lolote analosema Mwenyezi Mungu?” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Basi Balaki akamwambia Balaamu, “Njoo, nikupeleke mahali pengine. Huenda itampendeza Mungu kukuruhusu unilaanie hao watu kutoka mahali hapo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki akamchukua Balaamu juu ya Mlima Peori, unaotazamana na nyika. ");
INSERT INTO swhonmm_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu akasema, “Nijengee hapa madhabahu saba, uandae mafahali saba na kondoo dume saba kwa ajili yangu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki akafanya kama Balaamu alivyosema, kisha akatoa sadaka ya fahali mmoja na kondoo dume mmoja juu ya kila madhabahu. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Basi Balaamu alipoona imempendeza Mwenyezi Mungu kubariki Israeli, hakuendelea tena kutafuta uchawi kama nyakati nyingine, bali aligeuza uso wake kuelekea nyikani. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaamu alipotazama nje na kuona Israeli amepiga kambi kabila kwa kabila, Roho wa Mungu akawa juu yake, ");
INSERT INTO swhonmm_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","naye akatoa ujumbe wake: “Ujumbe wa Balaamu mwana wa Beori, ujumbe wake yeye ambaye jicho lake linaona vizuri; ");
INSERT INTO swhonmm_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ujumbe wake yeye anayesikia maneno ya Mungu, anayeona maono kutoka kwa Mwenyezi, ambaye husujudu, na macho yake yamefunguka: ");
INSERT INTO swhonmm_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Tazama jinsi yalivyo mazuri mahema yako, ee Yakobo, maskani zako, ee Israeli! ");
INSERT INTO swhonmm_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Kama mabonde, yanaenea, kama bustani kando ya mto, kama miti ya udi iliyopandwa na Mwenyezi Mungu, kama mierezi kando ya maji. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Maji yatatiririka kutoka ndoo zake; mbegu yake itakuwa na maji tele. “Mfalme wake atakuwa mkuu kuliko Mfalme Agagi; ufalme wake utatukuka. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Mungu alimleta kutoka Misri; yeye ana nguvu kama nyati. Anayararua mataifa yaliyo adui zake, na kuvunja mifupa yao vipande vipande; huwachoma kwa mishale yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Hujikunyata na kuvizia kama simba, kama simba jike; nani anayethubutu kumwamsha? “Abarikiwe kila akubarikiye, na alaaniwe kila akulaaniye!” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ndipo hasira ya Balaki ikawaka dhidi ya Balaamu. Akapiga mikono yake pamoja, akamwambia Balaamu, “Nilikuita uje kuwalaani adui zangu, lakini umewabariki mara hizi tatu. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Sasa ondoka upesi uende nyumbani! Mimi nilisema nitakuzawadia vizuri sana, lakini Mwenyezi Mungu amekuzuia usizawadiwe.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu akamwambia Balaki, “Je, hukumbuki jinsi nilivyowaambia wajumbe uliowatuma kwangu? Niliwaambia hivi, ");
INSERT INTO swhonmm_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Hata ikiwa Balaki angenipa jumba lake la kifalme likiwa limejazwa fedha na dhahabu, nisingeweza kufanya kitu chochote kwa matakwa yangu, kikiwa kizuri au kibaya, kwenda kinyume na agizo la Mwenyezi Mungu, nami imenipasa kusema tu kile Mwenyezi Mungu atakachosema’? ");
INSERT INTO swhonmm_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sasa ninarudi kwa watu wangu. Lakini njoo, nikuonye kuhusu kile watu hawa watakachowatenda watu wako siku zijazo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Kisha Balaamu akatoa ujumbe wake: “Ujumbe wa Balaamu mwana wa Beori, ujumbe wake yeye ambaye jicho lake linaona vizuri; ");
INSERT INTO swhonmm_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ujumbe wake yeye ambaye husikia maneno ya Mungu, mwenye maarifa kutoka kwa Aliye Juu Sana, aonaye maono kutoka kwa Mwenyezi, na kuanguka kifudifudi nayo macho yake yamefunguliwa: ");
INSERT INTO swhonmm_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Namwona yeye, lakini si sasa; namtazama yeye, lakini si karibu. Nyota itatoka kwa Yakobo, fimbo ya ufalme itainuka kutoka kwa Israeli. Atawaponda Wamoabu paji za nyuso, na mafuvu yote ya wana wa Shethi. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edomu itamilikiwa, Seiri, adui yake, itamilikiwa, lakini Israeli atakuwa na nguvu. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mtawala atakuja kutoka kwa Yakobo na kuangamiza walionusurika katika mji.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Kisha Balaamu akawaona watu wa Amaleki, na kutoa ujumbe wake: “Amaleki alikuwa ya kwanza miongoni mwa mataifa, lakini mwisho wake ataangamizwa milele.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kisha akawaona Wakeni, akatoa ujumbe wake: “Makao yenu ni salama, kiota chenu kiko kwenye mwamba. ");
INSERT INTO swhonmm_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Hata hivyo ninyi Wakeni mtaangamizwa Ashuru atakapowachukua mateka.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ndipo akatoa ujumbe wake: “Ole wao! Ni nani ataweza kuishi Mungu atakapofanya hili? ");
INSERT INTO swhonmm_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Meli zitakuja kutoka pwani za Kitimu, zitaitiisha Ashuru na Eberi, lakini nao pia wataangamizwa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kisha Balaamu akainuka na kurudi nyumbani mwake, naye Balaki akashika njia yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israeli alipokuwa akikaa Shitimu, wanaume wa Israeli walianza kuzini na wanawake wa Moabu, ");
INSERT INTO swhonmm_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ambao waliwaalika kushiriki katika sadaka kwa miungu yao. Watu wakala na kusujudu mbele ya miungu hiyo. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Kwa hiyo Israeli akaungana katika kumwabudu Baali wa Peori. Hasira ya Mwenyezi Mungu ikawaka dhidi yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Mwenyezi Mungu akamwambia Musa, “Uwachukue viongozi wote wa watu hawa, uwaue hadharani mbele za Mwenyezi Mungu, ili hasira kali ya Mwenyezi Mungu iweze kuondoka kwa Israeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kwa hiyo Musa akawaambia waamuzi wa Israeli, “Kila mmoja wenu lazima awaue wale wanaume wenu, walioshiriki katika kumwabudu Baali wa Peori.” ");
INSERT INTO swhonmm_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ndipo mwanaume Mwisraeli akamleta mwanamke Mmidiani katika jamaa yake palepale mbele ya Musa na mkutano wote wa Israeli walipokuwa wakilia kwenye lango la Hema la Kukutania. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwana wa Eleazari, mwana wa kuhani Haruni, alipoona jambo hili, akaondoka kwenye kusanyiko, akachukua mkuki mkononi mwake, ");
INSERT INTO swhonmm_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","akamfuata yule Mwisraeli ndani ya hema. Akawachoma mkuki wote wawili kwa pamoja, ukapenya kwenye mwili wa yule Mwisraeli na mwili wa yule mwanamke. Ndipo tauni dhidi ya Waisraeli ikakoma. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Lakini wale waliokufa kwa hiyo tauni walikuwa watu elfu ishirini na nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eleazari, mwana wa kuhani Haruni, amegeuza hasira yangu mbali na Waisraeli, kwa sababu alikuwa na wivu kama nilio nao kwa heshima yangu miongoni mwao, hata kwamba kwa wivu wangu sikuwaangamiza. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kwa hiyo mwambie Finehasi ninafanya agano langu la amani naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Yeye pamoja na wazao wake watakuwa na agano la ukuhani milele, kwa sababu alikuwa na wivu kwa ajili ya heshima ya Mungu wake, na akafanya upatanisho kwa Waisraeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Jina la Mwisraeli ambaye aliuawa pamoja na mwanamke Mmidiani ni Zimri mwana wa Salu, kiongozi wa jamaa ya Simeoni. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Jina la mwanamke Mmidiani aliyeuawa ni Kozbi binti Suri, aliyekuwa mkuu wa kabila la jamaa ya Wamidiani. ");
INSERT INTO swhonmm_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Watendeeni Wamidiani kama adui na mwaue, ");
INSERT INTO swhonmm_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kwa sababu wao waliwatendea kama adui wakati waliwadanganya katika tukio la Peori na dada yao Kozbi, binti ya kiongozi Mmidiani, mwanamke ambaye aliuawa wakati tauni ilikuja kama matokeo ya tukio la Peori.” ");
INSERT INTO swhonmm_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Baada ya hiyo tauni, Mwenyezi Mungu akamwambia Musa na Eleazari mwana wa kuhani Haruni, ");
INSERT INTO swhonmm_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Hesabu jumuiya yote ya Waisraeli kufuatana na jamaa zao, wale wote wenye umri wa miaka ishirini na zaidi, wanaoweza kutumika katika jeshi la Israeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Hivyo Musa na kuhani Eleazari wakazungumza na watu kwenye nchi tambarare ya Moabu, ng’ambo ya Yordani kutokea Yeriko, wakasema, ");
INSERT INTO swhonmm_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Hesabuni wanaume wenye umri wa miaka ishirini na zaidi, kama Mwenyezi Mungu alivyomwagiza Musa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Wazao wa Reubeni, mwana mzaliwa wa kwanza wa Israeli, walikuwa: kutoka kwa Hanoki, ukoo wa Wahanoki; kutoka kwa Palu, ukoo wa Wapalu; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kutoka kwa Hesroni, ukoo wa Wahesroni; kutoka kwa Karmi, ukoo wa Wakarmi. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hizi zilikuwa ndizo koo za Reubeni; wale waliohesabiwa walikuwa elfu arobaini na tatu mia saba na thelathini (43,730). ");
INSERT INTO swhonmm_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwana wa Palu alikuwa Eliabu, ");
INSERT INTO swhonmm_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","nao wana wa Eliabu walikuwa Nemueli, Dathani na Abiramu. Hawa wawili Dathani na Abiramu ndio walikuwa maafisa wa jumuiya ambao walimwasi Musa na Haruni, na walikuwa miongoni mwa wafuasi wa Kora wakati walimwasi Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ardhi ilifunua kinywa chake na kuwameza pamoja na Kora, ambaye wafuasi wake walikufa wakati moto ulipowateketeza wanaume mia mbili na hamsini. Nao walikuwa kama alama ya onyo. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Pamoja na hayo, hao ukoo wa Kora hawakufa. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Wazao wa Simeoni kwa koo zao walikuwa: kutoka kwa Nemueli, ukoo wa Wanemueli; kutoka kwa Yamini, ukoo wa Wayamini; kutoka wa Yakini, ukoo wa Wayakini; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kutoka kwa Zera, ukoo wa Wazera; kutoka kwa Shauli, ukoo wa Washauli. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hizi ndizo koo za Simeoni; walikuwa watu elfu ishirini na mbili na mia mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Wazao wa Gadi kwa koo zao walikuwa: kutoka kwa Sifoni, ukoo wa Wasifoni; kutoka kwa Hagi, ukoo wa Wahagi; kutoka kwa Shuni, ukoo wa Washuni; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kutoka kwa Ozni, ukoo wa Waozni; kutoka kwa Eri, ukoo wa Waeri; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","kutoka kwa Arodi, ukoo wa Waarodi; kutoka kwa Areli, ukoo wa Waareli. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hizo zilikuwa koo za Gadi; wale waliohesabiwa walikuwa elfu arobaini na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri na Onani walikuwa wana wa Yuda, lakini walifia huko Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Wazao wa Yuda kwa koo zao walikuwa: kutoka kwa Shela, ukoo wa Washela; kutoka kwa Peresi, ukoo wa Waperesi; kutoka kwa Zera, ukoo wa Wazera. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Wazao wa Peresi walikuwa: kutoka kwa Hesroni, ukoo wa Wahesroni; kutoka kwa Hamuli, ukoo wa Wahamuli. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hizo zilikuwa koo za Yuda; wale waliohesabiwa walikuwa elfu sabini na sita na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Wazao wa Isakari kwa koo zao walikuwa: kutoka kwa Tola, ukoo wa Watola; kutoka kwa Puva, ukoo wa Wapuva; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kutoka kwa Yashubu, ukoo wa Wayashubu; kutoka kwa Shimroni, ukoo wa Washimroni. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hizo zilikuwa koo za Isakari; wale waliohesabiwa walikuwa elfu sitini na nne na mia tatu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Wazao wa Zabuloni kwa koo zao walikuwa: kutoka kwa Seredi, ukoo wa Waseredi; kutoka kwa Eloni, ukoo wa Waeloni; kutoka kwa Yaleeli, ukoo wa Wayaleeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hizo zilikuwa koo za Zabuloni; wale waliohesabiwa walikuwa elfu sitini na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Wazao wa Yusufu kwa koo zao kutoka kwa Manase na kwa Efraimu walikuwa: ");
INSERT INTO swhonmm_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Wazao wa Manase: kutoka kwa Makiri, ukoo wa Wamakiri (Makiri alikuwa baba wa Gileadi); kutoka kwa Gileadi, ukoo wa Wagileadi. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Hawa walikuwa wazao wa Gileadi: kutoka kwa Iezeri, ukoo wa Waiezeri; kutoka kwa Heleki, ukoo wa Waheleki; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kutoka kwa Asirieli, ukoo wa Waasirieli; kutoka kwa Shekemu, ukoo wa Washekemu; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kutoka kwa Shemida, ukoo wa Washemida; kutoka kwa Heferi, ukoo wa Waheferi. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Selofehadi mwana wa Heferi hakuzaa wana, bali alikuwa na watoto wa kike tu, ambao majina yao yalikuwa Mahla, Noa, Hogla, Milka na Tirsa.) ");
INSERT INTO swhonmm_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hizo zilikuwa koo za Manase; wale waliohesabiwa walikuwa elfu hamsini na mbili na mia saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Hawa walikuwa wazao wa Efraimu kwa koo zao: kutoka kwa Shuthela, ukoo wa Washuthela; kutoka kwa Bekeri, ukoo wa Wabekeri; kutoka kwa Tahani, ukoo wa Watahani; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Hawa walikuwa wazao wa Shuthela: kutoka kwa Erani, ukoo wa Waerani. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hizo zilikuwa koo za Efraimu; wale waliohesabiwa walikuwa elfu thelathini na mbili na mia tano. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Wazao wa Benyamini kwa koo zao walikuwa: kutoka kwa Bela, ukoo wa Wabela; kutoka kwa Ashbeli, ukoo wa Waashbeli; kutoka kwa Ahiramu, ukoo wa Waahiramu; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kutoka kwa Shufamu, ukoo wa Washufamu; kutoka kwa Hufamu, ukoo wa Wahufamu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Wazao wa Bela kutoka kwa Ardi na Naamani walikuwa: kutoka kwa Ardi, ukoo wa Waardi; kutoka kwa Naamani, ukoo wa Wanaamani. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hizo zilikuwa koo za Benyamini; wale waliohesabiwa walikuwa elfu arobaini na tano na mia sita. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Hawa walikuwa wazao wa Dani kwa koo zao: kutoka kwa Shuhamu, ukoo wa Washuhamu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Wote walikuwa koo za Washuhamu; wale waliohesabiwa walikuwa elfu sitini na nne na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Wazao wa Asheri kwa koo zao walikuwa: kutoka kwa Imna, ukoo wa Waimna; kutoka kwa Ishvi, ukoo wa Waishvi; kutoka kwa Beria, ukoo wa Waberia; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","kutoka kwa wazao wa Beria: kutoka kwa Heberi, ukoo wa Waheberi; kutoka kwa Malkieli, ukoo wa Wamalkieli. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheri alikuwa na binti aliyeitwa Sera. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hizo zilikuwa koo za Asheri; wale waliohesabiwa walikuwa elfu hamsini na tatu na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Wazao wa Naftali kwa koo zao walikuwa: kutoka kwa Yaseeli, ukoo wa Wayaseeli; kutoka kwa Guni, ukoo wa Waguni; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kutoka kwa Yeseri, ukoo wa Wayeseri; kutoka kwa Shilemu, ukoo wa Washilemu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hizo zilikuwa koo za Naftali; wale waliohesabiwa walikuwa elfu arobaini na tano na mia nne. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Jumla ya hesabu ya wanaume wa Israeli ilikuwa elfu mia sita na moja mia saba na thelathini (601,730). ");
INSERT INTO swhonmm_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Watagawiwa nchi kama urithi kulingana na hesabu ya majina. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kundi kubwa zaidi lipe urithi mkubwa zaidi, na kundi dogo zaidi lipewe urithi mdogo zaidi; kila kundi litapokea urithi wake kulingana na hesabu ya wale walioorodheshwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Hakikisha kuwa nchi inagawanywa kwa kura. Kile kitakachorithiwa na kila kikundi kitakuwa kwa kulingana na majina ya kabila la babu yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Kila urithi utagawanywa kwa kura miongoni mwa makundi makubwa na madogo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hawa walikuwa Walawi ambao walihesabiwa kwa koo zao: kutoka kwa Gershoni, ukoo wa Wagershoni; kutoka kwa Kohathi, ukoo wa Wakohathi; kutoka kwa Merari, ukoo wa Wamerari. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hizi pia zilikuwa koo za Walawi: ukoo wa Walibni; ukoo wa Wahebroni; ukoo wa Wamahli; ukoo wa Wamushi; ukoo wa wana wa Kora. (Kohathi alikuwa baba aliyemzaa Amramu; ");
INSERT INTO swhonmm_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","jina la mke wa Amramu ni Yokebedi, naye pia alikuwa mzao wa Lawi, ambaye alizaliwa kwa Walawi nchini Misri. Alimzalia Amramu: Haruni, Musa na dada yao Miriamu. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruni alikuwa baba yake Nadabu na Abihu, Eleazari na Ithamari. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Lakini Nadabu na Abihu walikufa wakati walitoa sadaka mbele za Mwenyezi Mungu kwa moto usioruhusiwa.) ");
INSERT INTO swhonmm_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Wanaume wote wa Walawi wa umri wa mwezi mmoja na zaidi walikuwa elfu ishirini na tatu. Wao hawakuhesabiwa pamoja na Waisraeli wengine kwa sababu hawakupokea urithi miongoni mwao. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Hawa ndio walioorodheshwa na Musa na kuhani Eleazari wakati waliwahesabu Waisraeli kwenye nchi tambarare ya Moabu, kando ya Yordani, ng’ambo ya Yeriko. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Hakuna hata mmoja wao aliyekuwa miongoni mwa wale waliohesabiwa na Musa na kuhani Haruni wakati waliwahesabu Waisraeli katika Jangwa la Sinai. ");
INSERT INTO swhonmm_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kwa maana Mwenyezi Mungu alikuwa amewaambia hao Waisraeli hakika wangekufa huko jangwani, wala hakuna mmoja wao aliyeachwa, isipokuwa Kalebu mwana wa Yefune na Yoshua mwana wa Nuni. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Binti za Selofehadi mwana wa Heferi, mwana wa Gileadi, mwana wa Makiri, mwana wa Manase, walikuwa wa koo za Manase mwana wa Yusufu. Majina ya hao binti yalikuwa Mahla, Noa, Hogla, Milka na Tirsa. Walikaribia ");
INSERT INTO swhonmm_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ingilio la Hema la Kukutania na kusimama mbele ya Musa, kuhani Eleazari, viongozi na kusanyiko lote, wakasema, ");
INSERT INTO swhonmm_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baba yetu alikufa jangwani. Hakuwa miongoni mwa wafuasi wa Kora, ambao walifungamana pamoja dhidi ya Mwenyezi Mungu, lakini alikufa kwa ajili ya dhambi yake mwenyewe na hakuacha wana. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kwa nini jina la baba yetu lifutike kutoka ukoo wake kwa sababu hakuwa na mwana? Tupatie milki miongoni mwa ndugu za baba yetu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Kwa hiyo Musa akaleta shauri lao mbele za Mwenyezi Mungu, ");
INSERT INTO swhonmm_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","naye Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Wanachosema binti za Selofehadi ni sawa. Ni lazima kwa hakika uwape milki kama urithi miongoni mwa ndugu za baba yao, na kubadili urithi wa baba yao uwe wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Waambie Waisraeli, ‘Ikiwa mtu atakufa naye hakuacha mwana, utampa binti yake urithi wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ikiwa hana binti, wape ndugu zake wa kiume urithi wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ikiwa hana ndugu wa kiume toa urithi wake kwa ndugu za baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ikiwa baba yake hakuwa na ndugu wa kiume, toa urithi wake kwa ndugu wa karibu katika ukoo wake, ili aumiliki. Hili litakuwa dai la sheria kwa Waisraeli, kama Mwenyezi Mungu alivyomwamuru Musa.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Kisha Mwenyezi Mungu akamwambia Musa, “Kwea mlima huu katika safu za Abarimu uione nchi ninayowapa Waisraeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Baada ya kuiona, wewe pia utakusanywa pamoja na watu wako kama ndugu yako Haruni alivyokusanywa, ");
INSERT INTO swhonmm_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kwa kuwa jumuiya ilipoasi amri yangu kwenye maji katika Jangwa la Sini, wakati jumuiya ilipogombana nami, nyote wawili mliacha kuitii amri yangu ya kuniheshimu kama mtakatifu mbele ya macho yao.” (Haya yalikuwa maji ya Meriba huko Kadeshi, katika Jangwa la Sini.) ");
INSERT INTO swhonmm_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa akamwambia Mwenyezi Mungu, ");
INSERT INTO swhonmm_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Mwenyezi Mungu, Mungu wa roho zote za wanadamu, na amteue mtu juu ya jumuiya hii ");
INSERT INTO swhonmm_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ili atoke na kuingia mbele yao, atakayewaongoza katika kutoka kwao na kuingia kwao, ili watu wa Mwenyezi Mungu wasiwe kama kondoo wasio na mchungaji.” ");
INSERT INTO swhonmm_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kwa hiyo Mwenyezi Mungu akamwambia Musa, “Mchukue Yoshua mwana wa Nuni, mtu ambaye Roho wa Mungu yuko ndani yake, uweke mkono juu yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Msimamishe mbele ya kuhani Eleazari pamoja na kusanyiko lote, umpe maagizo mbele yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Mpe sehemu ya mamlaka yako ili jumuiya yote ya Waisraeli wapate kumtii. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Atasimama mbele ya kuhani Eleazari, ambaye atapokea maamuzi kwa ajili yake, kwa kuuliza mbele za Mwenyezi Mungu kwa Urimu. Kwa amri yake, yeye na jumuiya yote ya Waisraeli watatoka, na kwa amri yake, wataingia.” ");
INSERT INTO swhonmm_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa akafanya kama Mwenyezi Mungu alivyomwagiza. Akamtwaa Yoshua na kumsimamisha mbele ya kuhani Eleazari na kusanyiko lote. ");
INSERT INTO swhonmm_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Kisha akaweka mikono yake juu ya kichwa cha Yoshua na kumpa maagizo, kama vile Mwenyezi Mungu alivyoelekeza kupitia kwa Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Wape Waisraeli agizo hili, uwaambie: ‘Hakikisheni kwamba mnaniletea mimi kwa wakati uliowekwa chakula kwa ajili ya sadaka za kuteketezwa kwa moto, kama harufu nzuri ya kupendeza.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Waambie: ‘Hii ni sadaka ya kuteketezwa kwa moto mnayomtolea Mwenyezi Mungu: wana-kondoo wawili wa mwaka mmoja wasio na dosari, kuwa sadaka ya kawaida ya kuteketezwa kila siku. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Andaa mwana-kondoo mmoja asubuhi na mwingine jioni, ");
INSERT INTO swhonmm_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","kila mmoja atolewe pamoja na sadaka ya nafaka sehemu ya kumi ya efa ya unga laini uliochanganywa pamoja na robo ya hini ya mafuta ya zeituni. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hii ni sadaka ya kawaida ya kuteketezwa iliyoanzishwa katika Mlima Sinai kama harufu nzuri ya kupendeza, sadaka iliyotolewa kwa Mwenyezi Mungu kwa moto. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Sadaka ya kinywaji itakayotolewa pamoja na kila mwana-kondoo ni robo ya hini ya kinywaji kilichochachuka. Mimina sadaka ya kinywaji kwa Mwenyezi Mungu mahali patakatifu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Andaa yule mwana-kondoo wa pili jioni, pamoja na sadaka ya nafaka na sadaka ya kinywaji kama ulivyofanya kwa ile sadaka nyingine ya asubuhi. Hii ni sadaka iliyotolewa kwa kuteketezwa kwa moto, harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Siku ya Sabato, utatoa sadaka ya wana-kondoo wawili wa mwaka mmoja wasiokuwa na dosari pamoja na sadaka yake ya kinywaji na sadaka ya nafaka yenye uzito wa sehemu mbili za kumi ya efa ya unga laini uliochanganywa na mafuta. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hii ni sadaka ya kuteketezwa itakayotolewa kwa ajili ya kila Sabato, pamoja na sadaka ya kawaida ya kuteketezwa na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Siku ya kwanza ya kila mwezi, mtamletea Mwenyezi Mungu sadaka ya kuteketezwa ya fahali wawili wachanga, kondoo dume mmoja na wana-kondoo saba wa mwaka mmoja, wote wasiokuwa na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Pamoja na kila fahali, kutakuwa na sadaka ya nafaka ya unga laini sehemu tatu za kumi ya efa, uliochanganywa na mafuta, pamoja na kondoo dume mmoja, sadaka ya nafaka ya unga laini uliochanganywa na mafuta; ");
INSERT INTO swhonmm_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","pamoja na kila mwana-kondoo, sadaka ya nafaka yenye uzito wa sehemu ya kumi ya efa ya unga laini uliochanganywa na mafuta. Hii ni kwa ajili ya sadaka ya kuteketezwa, harufu nzuri, sadaka ya kuteketezwa iliyotolewa kwa moto kwa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Pamoja na kila fahali kutakuwa na sadaka ya kinywaji nusu ya hini ya divai; pamoja na kila kondoo dume, theluthi moja ya hini; na pamoja na kila mwana-kondoo, robo hini. Hii ni sadaka ya kuteketezwa ya kila mwezi itakayotolewa kila mwandamo wa mwezi kwa mwaka. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Zaidi ya sadaka ya kawaida ya kuteketezwa pamoja na sadaka yake ya kinywaji, mbuzi mmoja dume atatolewa kwa Mwenyezi Mungu kuwa sadaka ya dhambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Katika siku ya kumi na nne ya mwezi wa kwanza, itafanyika Pasaka ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Katika siku ya kumi na tano ya mwezi huo itakuwa sikukuu; kwa siku saba mtakula mikate isiyotiwa chachu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Katika siku ya kwanza mtakuwa na kusanyiko takatifu, msifanye kazi za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Leteni mbele za Mwenyezi Mungu sadaka ya kuteketezwa, sadaka ya kuteketezwa ya mafahali wawili wachanga, kondoo dume mmoja na wana-kondoo dume saba wenye umri wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pamoja na kila fahali, andaa sadaka ya nafaka sehemu tatu za kumi ya efa ya unga laini uliochanganywa na mafuta; pamoja na kondoo dume, andaa sehemu mbili za kumi ya efa; ");
INSERT INTO swhonmm_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","pia pamoja na kila mmoja wa wale wana-kondoo saba, andaa sehemu ya kumi ya efa. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Pia mtoe beberu mmoja kuwa sadaka ya dhambi ambaye atafanya upatanisho kwa ajili yenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Andaa hizi licha ya zile sadaka za kawaida za kuteketezwa za kila asubuhi. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Kwa njia hii andaa chakula cha sadaka ya kuteketezwa kila siku, kwa siku saba kama harufu nzuri impendezayo Mwenyezi Mungu. Hii itaandaliwa licha ya ile sadaka ya kawaida ya kuteketezwa ya kila siku pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Siku ya saba mwe na kusanyiko takatifu na msifanye kazi zenu za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Siku ya malimbuko, mnapomletea Mwenyezi Mungu sadaka ya nafaka mpya wakati wa Sikukuu ya Majuma, mwe na kusanyiko takatifu na msifanye kazi zenu za kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mlete sadaka ya kuteketezwa ya mafahali wawili wachanga, kondoo dume mmoja, na pia wana-kondoo saba wenye umri wa mwaka mmoja, kama harufu nzuri ya kumpendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pamoja na kila fahali itatolewa sadaka ya nafaka ya unga laini sehemu tatu za kumi ya efa uliochanganywa na mafuta; pamoja na kondoo dume, andaa sehemu mbili za kumi ya efa ya unga laini; ");
INSERT INTO swhonmm_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na sehemu ya kumi ya efa ya unga laini kwa kila mmoja wa wana-kondoo saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ongeza beberu mmoja kwa kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Andaa hizi sadaka pamoja na sadaka zake za vinywaji, kuwa nyongeza ya sadaka za kawaida za kuteketezwa, pamoja na sadaka yake ya nafaka. Hakikisha kuwa wanyama hao hawana dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Katika siku ya kwanza ya mwezi wa saba mtakuwa na kusanyiko takatifu na msifanye kazi ya kawaida. Ni siku kwa ajili yenu ya kupiga tarumbeta. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mtatayarisha sadaka ya kuteketezwa kama harufu nzuri impendezayo Mwenyezi Mungu ya fahali mmoja mchanga, kondoo dume mmoja, na wana-kondoo saba wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pamoja na fahali, andaeni sadaka ya nafaka sehemu tatu za kumi ya efa ya unga laini uliochanganywa na mafuta; kwa kondoo dume, andaa unga sehemu mbili za kumi ya efa; ");
INSERT INTO swhonmm_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na pamoja na wana-kondoo saba kila mmoja aandaliwe na sehemu ya kumi ya efa ya unga. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ongeza beberu mmoja kuwa sadaka ya dhambi, ili kufanya upatanisho kwa ajili yenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Hivi ni nyongeza ya sadaka za kuteketezwa kila mwezi na kila siku, pamoja na sadaka zake za nafaka, na sadaka za vinywaji kama ilivyoainishwa. Ni sadaka zinazotolewa kwa Mwenyezi Mungu kwa moto, harufu inayopendeza. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Kwenye siku ya kumi ya mwezi huu wa saba mtakuwa na kusanyiko takatifu. Mtajikana wenyewe na msifanye kazi. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Toeni sadaka ya kuteketezwa ya fahali mmoja mchanga, kondoo dume mmoja, na wana-kondoo saba wa mwaka mmoja, wote wasio na dosari, kama harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Pamoja na fahali, andaeni sadaka ya nafaka sehemu tatu za kumi ya efa ya unga laini uliochanganywa na mafuta; pamoja na kondoo dume, sehemu mbili za kumi ya efa ya unga laini; ");
INSERT INTO swhonmm_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na kwa kila mmoja wa wana-kondoo saba andaa sehemu ya kumi ya unga laini kwa kila mmoja. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ongeza beberu mmoja kuwa sadaka ya dhambi, katika nyongeza ya sadaka ya dhambi kwa ajili ya upatanisho, na sadaka ya kawaida ya kuteketezwa pamoja na sadaka yake ya nafaka, na sadaka zake za vinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Katika siku ya kumi na tano ya mwezi wa saba, mtakuwa na kusanyiko takatifu, na hamtafanya kazi za kawaida. Adhimisheni sikukuu kwa Mwenyezi Mungu kwa siku saba. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Toeni sadaka ya kuteketezwa mafahali wachanga kumi na watatu, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari, kama harufu nzuri inayompendeza Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Pamoja na hao mafahali kumi na watatu, kila mmoja aandaliwe na sadaka ya nafaka sehemu tatu za kumi ya efa ya unga laini uliochanganywa na mafuta; kwa kondoo dume wawili, kila mmoja aandaliwe sehemu mbili za kumi ya efa ya unga laini; ");
INSERT INTO swhonmm_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na kwa wana-kondoo kumi na wanne, kila mmoja aandaliwe sehemu ya kumi ya efa ya unga laini. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya sadaka ya kawaida ya kuteketezwa pamoja na sadaka yake ya nafaka, na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Katika siku ya pili, andaeni mafahali wachanga kumi na wawili, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Pamoja na mafahali, kondoo dume, na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya kawaida ya sadaka ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka zake za vinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Katika siku ya tatu, andaeni mafahali wachanga kumi na wawili, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Pamoja na mafahali, kondoo dume, na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya kawaida ya sadaka ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Katika siku ya nne, andaeni mafahali wachanga kumi na wawili, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Pamoja na mafahali, kondoo dume, na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya kawaida ya sadaka ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Katika siku ya tano, andaeni mafahali tisa, kondoo dume wawili na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Pamoja na mafahali, kondoo dume na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za kinywaji kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya sadaka ya kawaida ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Katika siku ya sita, andaeni mafahali wachanga kumi na wawili, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Pamoja na mafahali, kondoo dume, na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya kawaida ya sadaka ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Katika siku ya saba, andaeni mafahali wachanga kumi na wawili, kondoo dume wawili, na wana-kondoo kumi na wanne wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Pamoja na mafahali, kondoo dume, na wana-kondoo, andaeni sadaka zao za nafaka na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Ongeza beberu mmoja kuwa sadaka ya dhambi, kwa nyongeza ya kawaida ya sadaka ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Katika siku ya nane, mtakuwa na kusanyiko, na msifanye kazi ya kawaida. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Toeni sadaka ya kuteketezwa kama harufu nzuri inayompendeza Mwenyezi Mungu, sadaka ya kuteketezwa ya fahali mmoja, kondoo dume mmoja, na wana-kondoo dume saba wa mwaka mmoja, wote wasio na dosari. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Pamoja na fahali, kondoo dume na wana-kondoo, andaeni sadaka zao za nafaka, na sadaka za vinywaji, kulingana na idadi iliyoainishwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ongeza beberu mmoja kuwa sadaka ya dhambi, katika nyongeza ya sadaka ya kawaida ya kuteketezwa na sadaka yake ya nafaka, pamoja na sadaka yake ya kinywaji. ");
INSERT INTO swhonmm_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Zaidi ya kile unachoweka nadhiri na sadaka zenu za hiari, andaeni hizi kwa ajili ya Mwenyezi Mungu kwenye sikukuu zenu zilizoamriwa: sadaka zenu za kuteketezwa, sadaka za nafaka, sadaka za vinywaji, pamoja na sadaka zenu za amani.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa akawaambia Waisraeli yale yote Mwenyezi Mungu alimwagiza. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa akawaambia viongozi wa makabila ya Israeli: “Hili ndilo Mwenyezi Mungu analoagiza: ");
INSERT INTO swhonmm_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mwanaume awekapo nadhiri kwa Mwenyezi Mungu, au anapoapa kujifunga kwa ahadi, kamwe asitangue neno lake, bali ni lazima afanye kila kitu alichosema. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Mwanamwali anayeishi bado nyumbani mwa baba yake atakapoweka nadhiri kwa Mwenyezi Mungu, ama akajifunga mwenyewe kwa ahadi, ");
INSERT INTO swhonmm_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na baba yake akasikia kuhusu nadhiri au ahadi yake lakini asimwambie lolote, ndipo nadhiri zake zote na kila ahadi aliyoiweka na kujifunga kwayo itathibitika. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Lakini kama baba yake akimkataza wakati anapoisikia, hakuna nadhiri wala ahadi yake yoyote aliyojifunga kwayo itakayosimama; Mwenyezi Mungu atamweka huru huyo mwanamwali kwa sababu baba yake amemkataza. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Akiolewa baada ya kuweka nadhiri au baada ya midomo yake kutamka ahadi fulani bila kufikiri akawa amejifunga hivyo, ");
INSERT INTO swhonmm_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na mume wake akasikia habari hiyo asimwambie neno lolote, ndipo nadhiri zake ama ahadi zake ambazo alikuwa amejifunga nazo zitathibitika. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Lakini ikiwa mume wake atamkataza atakaposikia kuhusu hilo, atakuwa ametangua nadhiri ambazo zilikuwa zimemfunga mkewe, ama ahadi aliyotamka pasipo kufikiri ambayo amejifunga kwayo, naye Mwenyezi Mungu atamweka huru yule mwanamke. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Nadhiri yoyote ama patano ambalo limefanywa na mjane ama mwanamke aliyeachwa vitakuwa vimemfunga. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Ikiwa mwanamke anayeishi na mumewe ataweka nadhiri ama kujifunga mwenyewe kwa ahadi chini ya kiapo, ");
INSERT INTO swhonmm_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na mumewe akasikia kuhusu jambo hili lakini asimwambie lolote wala hakumkataza, ndipo viapo vyake vyote au ahadi zinazomfunga zitakapothibitika. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Lakini ikiwa mumewe atabatilisha nadhiri hizo baada ya kuzisikia, basi hakuna nadhiri au ahadi zozote alizoziweka kwa midomo yake zitakazothibitika. Mumewe atakuwa amezibatilisha, na Mwenyezi Mungu atamweka huru yule mwanamke. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mumewe anaweza kuthibitisha au kutangua nadhiri yoyote anayoweka, au ahadi yoyote aliyoweka kwa kuapa ili kujikana mwenyewe. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Lakini ikiwa mumewe hasemi lolote kwake kuhusu jambo hilo siku baada ya siku, basi mumewe atakuwa amethibitisha nadhiri zote, na ahadi zote zinazomfunga mkewe. Anavithibitisha kwa kutokusema lolote kwa mkewe anapoyasikia hayo. ");
INSERT INTO swhonmm_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Hata hivyo, ikiwa mumewe atavibatilisha baada ya kusikia hayo, basi atawajibika kwa hatia ya mkewe.” ");
INSERT INTO swhonmm_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Haya ndio masharti ambayo Mwenyezi Mungu alimpa Musa kuhusu mahusiano kati ya mtu na mkewe, na kati ya baba na binti yake ambaye bado anaishi nyumbani mwa baba yake. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Uwalipize kisasi Wamidiani kwa ajili ya Waisraeli. Halafu baada ya hayo, utakufa.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kwa hiyo Musa akawaambia watu, “Waandaeni baadhi ya wanaume wenu waende vitani kupigana na Wamidiani ili wawalipize kisasi cha Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Peleka wanaume elfu moja vitani kutoka kila kabila la Israeli.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Kwa hiyo waliandaliwa wanaume elfu kumi na mbili kwa vita, wanaume elfu moja kutoka kila kabila, walitolewa kutoka koo za Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa aliwatuma vitani, watu elfu moja kutoka kila kabila, pamoja na Finehasi mwana wa kuhani Eleazari, ambaye alichukua vyombo vya mahali patakatifu na tarumbeta za kuashiria. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Walipigana dhidi ya Wamidiani, kama Mwenyezi Mungu alivyomwagiza Musa, nao waliua kila mwanaume. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Miongoni mwa watu waliouawa walikuwa wafalme watano wa Midiani: Evi, Rekemu, Suri, Huri na Reba. Vilevile walimuua Balaamu mwana wa Beori kwa upanga. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Waisraeli waliwateka wanawake wa Midiani pamoja na watoto wao, na wakachukua makundi ya ng’ombe, kondoo na mali yao kama nyara. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Walichoma moto miji yote ambayo Wamidiani walikuwa wanaishi, pamoja na kambi zao zote. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Walichukua nyara zote na mateka, pamoja na watu na wanyama, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","nao waliwaleta wafungwa mateka na nyara kwa Musa na kwa kuhani Eleazari, nao Waisraeli walikusanyika kwenye kambi zao katika tambarare za nchi ya Moabu, kando ya Yordani, ng’ambo ya Yeriko. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, kuhani Eleazari na viongozi wote wa jumuiya wakatoka kuwalaki nje ya kambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa aliwakasirikia maafisa wa jeshi, yaani hao wakuu wa jeshi wa maelfu na wakuu wa jeshi wa mamia, ambao walirudi kutoka vitani. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa akawauliza, “Je, mmewaacha wanawake wote hai? ");
INSERT INTO swhonmm_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Wanawake hao ndio waliofuata ushauri wa Balaamu, nao ndio waliowasababisha Waisraeli wamwasi Mwenyezi Mungu kwa kile kilichotokea kule Peori, na kwa hiyo pigo liliwapata watu wa Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Sasa waue wavulana wote. Pia muue kila mwanamke ambaye alikwisha fanya tendo la ndoa, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","lakini mwacheni hai kwa ajili yenu kila msichana ambaye hajawahi kulala na mwanaume. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ninyi nyote ambao mmeua mtu yeyote au kumgusa mtu ambaye ameuawa, lazima mkae nje ya kambi kwa muda wa siku saba. Katika siku ya tatu na ya saba lazima mjitakase wenyewe pamoja na wafungwa wenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Takaseni kila vazi pamoja na kila kitu kilichotengenezwa kwa ngozi, kwa singa za mbuzi au kwa mti.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kisha kuhani Eleazari aliwaambia askari waliokuwa wameenda vitani, “Haya ndio matakwa ya sheria ambayo Mwenyezi Mungu alimpa Musa: ");
INSERT INTO swhonmm_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Dhahabu, fedha, shaba, chuma, bati, risasi, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na kitu kingine chochote ambacho kinaweza kuhimili moto lazima mkipitishe kwenye moto, kisha kitakuwa safi. Lakini ni lazima pia kitakaswe kwa maji ya utakaso. Kitu chochote kisichoweza kuhimili moto lazima kipitishwe kwenye yale maji ya utakaso. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Katika siku ya saba fueni nguo zenu, nanyi mtakuwa safi. Kisha mtaweza kuingia kambini.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Wewe na kuhani Eleazari pamoja na viongozi wa jamaa ya jumuiya mtahesabu watu wote na wanyama ambao walitekwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Gawanyeni hizo nyara kati ya askari ambao walishiriki katika vita na kwa jumuiya. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kutoka fungu la wale walioenda kupigana vitani, tenga kama ushuru kwa ajili ya Mwenyezi Mungu kitu kimoja kati ya kila mia tano, ikiwa ni wanadamu, ng’ombe, punda, kondoo au mbuzi. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Chukua ushuru huu kutoka fungu lao, umpe kuhani Eleazari kuwa sehemu ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kutoka fungu la Waisraeli, chukua kitu kimoja kati ya kila hamsini, ikiwa ni wanadamu, ng’ombe, punda, kondoo, mbuzi au wanyama wengine. Hivyo uwape Walawi, ambao wanawajibika kutunza Maskani ya Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Kwa hiyo Musa na kuhani Eleazari wakafanya kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Nyara zilizobaki kutoka mateka ambayo askari walichukua ni kondoo elfu mia sita na sabini na tano, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ng’ombe elfu sabini na mbili, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","punda elfu sitini na moja, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na wanawake elfu thelathini na mbili ambao hawakuwahi kulala na mwanaume. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nusu ya fungu la wale waliopigana vitani lilikuwa: Kondoo elfu mia tatu na thelathini na saba na mia tano, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ambao ushuru kwa ajili ya Mwenyezi Mungu ulikuwa kondoo mia sita na sabini na watano (675); ");
INSERT INTO swhonmm_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ng’ombe elfu thelathini na sita, ambao ushuru kwa ajili ya Mwenyezi Mungu ulikuwa ng’ombe sabini na wawili; ");
INSERT INTO swhonmm_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","punda elfu thelathini na mia tano, ambao ushuru kwa ajili ya Mwenyezi Mungu ulikuwa punda sitini na mmoja; ");
INSERT INTO swhonmm_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Watu elfu kumi na sita, ambao ushuru kwa ajili ya Mwenyezi Mungu ulikuwa watu thelathini na wawili. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa alimpa kuhani Eleazari ushuru kuwa sehemu ya Mwenyezi Mungu, kama Mwenyezi Mungu alivyomwagiza Musa. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ile nusu iliyokuwa ya Waisraeli, ambayo Musa aliitenga kutoka kwa ile ya watu waliopigana vitani, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nusu iliyokuwa ya jumuiya, ilikuwa kondoo elfu mia tatu na thelathini na saba na mia tano, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ng’ombe elfu thelathini na sita, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","punda elfu thelathini na mia tano, ");
INSERT INTO swhonmm_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","na wanadamu elfu kumi na sita. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kutoka hiyo nusu iliyokuwa ya Waisraeli, Musa alichagua moja kati ya kila hamsini ya wanadamu na wanyama, kama Mwenyezi Mungu alivyomwagiza, naye aliwapa Walawi, ambao waliwajibika kutunza Maskani ya Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kisha maafisa waliokuwa juu ya vikosi vya jeshi, wakuu wa jeshi wa maelfu na wakuu wa jeshi wa mamia, walimwendea Musa ");
INSERT INTO swhonmm_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","na kumwambia, “Watumishi wako wamehesabu askari walio chini ya amri yetu na hakuna hata mmoja aliyekosekana. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Kwa hiyo tumeleta sadaka kwa Mwenyezi Mungu ya vyombo vya dhahabu kila mmoja wetu alivyopata, yaani vikuku, bangili, pete za muhuri, vipuli na mikufu, ili kufanya upatanisho kwa ajili yetu mbele za Mwenyezi Mungu.” ");
INSERT INTO swhonmm_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa na kuhani Eleazari wakapokea kutoka kwao dhahabu, yaani vyombo vyote vilivyonakshiwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Dhahabu yote kutoka kwa wakuu wa jeshi wa maelfu na wakuu wa jeshi wa mamia ambavyo Musa na kuhani Eleazari walimletea Mwenyezi Mungu kama zawadi ilikuwa shekeli elfu kumi na sita, mia saba na hamsini (16,750). ");
INSERT INTO swhonmm_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kila askari alikuwa amejichukulia nyara zake binafsi. ");
INSERT INTO swhonmm_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa na kuhani Eleazari walipokea dhahabu kutoka kwa wakuu wa jeshi wa maelfu na wakuu wa jeshi wa mamia, wakazileta katika Hema la Kukutania kama ukumbusho kwa Waisraeli mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Basi Wareubeni na Wagadi, waliokuwa na makundi makubwa ya ng’ombe, kondoo na mbuzi, waliona kuwa nchi ya Yazeri na nchi ya Gileadi ni nzuri kwa mifugo. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Hivyo walimjia Musa, na kuhani Eleazari na viongozi wa jumuiya, na kuwaambia, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarothi, Diboni, Yazeri, Nimra, Heshboni, Eleale, Sebamu, Nebo na Beoni, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","nchi ambayo Mwenyezi Mungu ameishinda mbele ya Waisraeli, inafaa kwa mifugo, nao watumishi wako wana mifugo. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Kama tumepata kibali mbele ya macho yako, nchi hii na ipewe watumishi wako kama milki yetu. Usitufanye tuvuke Yordani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa akawaambia Wagadi na Wareubeni, “Je, watu wa nchi yenu wataenda vitani wakati ninyi mmeketi hapa? ");
INSERT INTO swhonmm_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kwa nini mmewakatisha Waisraeli tamaa wasivuke katika nchi ambayo Mwenyezi Mungu amewapa? ");
INSERT INTO swhonmm_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Hivi ndivyo baba zenu walivyofanya wakati nilipowatuma kutoka Kadesh-Barnea kuipeleleza nchi. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Baada ya kufika kwenye Bonde la Eshkoli na kuitazama nchi, waliwakatisha tamaa Waisraeli wasiingie katika nchi ambayo Mwenyezi Mungu alikuwa amewapa. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Siku ile hasira ya Mwenyezi Mungu iliwaka naye akaapa kiapo hiki: ");
INSERT INTO swhonmm_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Kwa kuwa hawakunifuata kwa moyo wote, hakuna mtu yeyote mwenye miaka ishirini au zaidi ambaye alikuja kutoka Misri atakayeona nchi niliyoahidi kwa kiapo kwa Ibrahimu, Isaka na Yakobo; ");
INSERT INTO swhonmm_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","hakuna hata mmoja isipokuwa Kalebu mwana wa Yefune, Mkenizi, na Yoshua mwana wa Nuni, kwa sababu walimfuata Mwenyezi Mungu kwa moyo wote.’ ");
INSERT INTO swhonmm_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Hasira ya Mwenyezi Mungu iliwaka dhidi ya Waisraeli na akawafanya watangetange katika jangwa kwa miaka arobaini, hadi kizazi chote cha wale waliofanya maovu mbele yake kimeangamia. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Nanyi mko hapa, uzao wa wenye dhambi, mkisimamia mahali pa baba zenu na mkimfanya Mwenyezi Mungu kuwakasirikia Waisraeli hata zaidi. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mkigeuka na kuacha kumfuata, atawaacha tena watu hawa wote jangwani, na mtakuwa sababu ya maangamizi yao.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ndipo wakamjia Musa na kumwambia, “Tungetaka kujenga mazizi hapa kwa ajili ya mifugo yetu na miji kwa ajili ya wanawake wetu na watoto. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Lakini sisi tuko tayari kuchukua silaha zetu na kutangulia mbele ya Waisraeli hadi tutakapowaleta mahali pao. Wakati huo wanawake wetu na watoto wataishi katika miji yenye ngome, kwa ajili ya ulinzi dhidi ya wenyeji wa nchi. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Hatutarudi nyumbani mwetu hadi kila Mwisraeli apokee urithi wake. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Hatutapokea urithi wowote pamoja nao ng’ambo ya Yordani, kwa sababu urithi wetu umekuja kwetu upande wa mashariki mwa Yordani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kisha Musa akawaambia, “Kama mtafanya jambo hili, kama mtajivika silaha mbele za Mwenyezi Mungu kwa ajili ya vita, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","na kama ninyi nyote mtaenda mmejivika silaha ng’ambo ya Yordani mbele za Mwenyezi Mungu hadi awe amewafukuza adui zake mbele zake, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","hadi wakati nchi itakapokuwa imeshindwa mbele za Mwenyezi Mungu, ndipo mtaweza kurudi na kuwa huru kutoka masharti yenu kwa Mwenyezi Mungu na Israeli. Nayo nchi hii itakuwa milki yenu mbele za Mwenyezi Mungu. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Lakini mkishindwa kufanya hili, mtakuwa mnatenda dhambi dhidi ya Mwenyezi Mungu; nanyi kuweni na hakika kuwa dhambi yenu itawapata. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Jengeni miji kwa ajili ya wanawake na watoto wenu, na mazizi kwa ajili ya mbuzi na kondoo wenu, lakini fanyeni yale mliyoahidi.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Wagadi na Wareubeni wakamwambia Musa, “Sisi watumishi wako tutafanya kama bwana wetu anavyotuagiza. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Watoto na wake zetu, makundi ya mbuzi na kondoo, na makundi ya ng’ombe wetu, watabaki hapa katika miji ya Gileadi. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Lakini watumishi wenu, kila mwanaume aliyevaa silaha za vita, watavuka ng’ambo kupigana mbele za Mwenyezi Mungu, sawa kama bwana wetu asemavyo.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Kisha Musa akatoa amri kuwahusu kwa kuhani Eleazari, na Yoshua mwana wa Nuni, na viongozi wa jamaa za makabila ya Israeli. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa akawaambia, “Ikiwa Wagadi na Wareubeni, kila mwanaume aliyevaa silaha za vita, atavuka Yordani pamoja nanyi mbele za Mwenyezi Mungu, basi mtakapoishinda nchi iliyo mbele yenu, wapeni nchi ya Gileadi kama milki yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lakini kama hawatavuka pamoja nanyi wakiwa wamevaa silaha za vita, lazima wakubali kupokea milki yao pamoja nanyi katika nchi ya Kanaani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Wagadi na Wareubeni wakajibu, “Watumishi wako watafanya lile Mwenyezi Mungu alilosema. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tutavuka mbele za Mwenyezi Mungu kuingia Kanaani tukiwa tumevaa silaha za vita, lakini mali tutakayoirithi itakuwa ng’ambo hii ya Yordani.” ");
INSERT INTO swhonmm_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Kisha Musa akawapa Wagadi, Wareubeni, na nusu ya kabila la Manase mwana wa Yusufu ufalme wa Sihoni mfalme wa Waamori, na ufalme wa Ogu mfalme wa Bashani, nchi yote pamoja na miji yake, na nchi inayowazunguka. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Wagadi wakajenga Diboni, Atarothi, Aroeri, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-Shofani, Yazeri, Yogbeha, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth-Nimra na Beth-Harani kama miji iliyozungushiwa ngome, tena wakajenga mazizi kwa ajili ya makundi yao ya mbuzi na kondoo. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Nao Wareubeni wakajenga upya miji ya Heshboni, Eleale na Kiriathaimu, ");
INSERT INTO swhonmm_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","pia Nebo na Baal-Meoni (majina ya hiyo miji yalibadilishwa) na Sibma. Miji waliyoijenga upya waliipa majina. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Wazao wa Makiri mwana wa Manase walienda Gileadi, wakaiteka nchi na kuwafukuza Waamori waliokuwa huko. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Kwa hiyo Musa akawapa Wamakiri, wazao wa Manase, nchi ya Gileadi, nao wakakaa huko. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yairi, mzao wa Manase, akateka makazi yao, akayaita Hawoth-Yairi. ");
INSERT INTO swhonmm_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Naye Noba akateka Kenathi na makazi yaliyoizunguka, akayaita Noba kwa jina lake. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hivi ndivyo vituo katika safari ya Waisraeli walipotoka Misri kwa vikosi chini ya uongozi wa Musa na Haruni. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kwa agizo la Mwenyezi Mungu, Musa aliweka kumbukumbu ya vituo katika safari yao. Hivi ndivyo vituo katika safari yao: ");
INSERT INTO swhonmm_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Waisraeli walisafiri kutoka Ramesesi katika siku ya kumi na tano ya mwezi wa kwanza, siku iliyofuata Pasaka. Walitembea kwa ujasiri wazi mbele ya Wamisri wote, ");
INSERT INTO swhonmm_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","waliokuwa wakizika wazaliwa wao wa kwanza wote, ambao Mwenyezi Mungu alikuwa amewaua kati yao, kwa kuwa Mwenyezi Mungu alikuwa ameleta hukumu juu ya miungu yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Waisraeli waliondoka Ramesesi na kupiga kambi huko Sukothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wakaondoka Sukothi na kupiga kambi huko Ethamu, pembeni mwa jangwa. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wakaondoka Ethamu, wakageuka wakarudi Pi-Hahirothi, hadi mashariki mwa Baal-Sefoni, wakapiga kambi yao karibu na Migdoli. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wakaondoka Pi-Hahirothi wakapita katikati ya bahari hadi jangwani, na baada ya kusafiri kwa siku tatu katika Jangwa la Ethamu, walipiga kambi huko Mara. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wakaondoka Mara wakaenda Elimu, mahali ambapo palikuwa na chemchemi kumi na mbili na mitende sabini, huko wakapiga kambi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wakaondoka Elimu na kupiga kambi kando ya Bahari ya Shamu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wakaondoka kando ya Bahari ya Shamu na kupiga kambi katika Jangwa la Sini. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wakaondoka katika Jangwa la Sini, wakapiga kambi huko Dofka. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wakaondoka Dofka, wakapiga kambi huko Alushi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wakaondoka Alushi, wakapiga kambi Refidimu, mahali ambapo hapakuwa na maji ya watu kunywa. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wakaondoka Refidimu na kupiga kambi katika Jangwa la Sinai. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wakaondoka katika Jangwa la Sinai na kupiga kambi huko Kibroth-Hataava. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wakaondoka Kibroth-Hataava na kupiga kambi huko Haserothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wakaondoka Haserothi na kupiga kambi huko Rithma. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wakaondoka Rithma na kupiga kambi huko Rimon-Peresi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wakaondoka Rimon-Peresi na kupiga kambi huko Libna. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wakaondoka Libna na kupiga kambi huko Risa. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wakaondoka Risa na kupiga kambi huko Kehelatha. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wakaondoka Kehelatha na kupiga kambi kwenye mlima Sheferi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wakaondoka kwenye mlima Sheferi na kupiga kambi huko Harada. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wakaondoka Harada na kupiga kambi huko Makelothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wakaondoka Makelothi na kupiga kambi huko Tahathi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wakaondoka Tahathi na kupiga kambi huko Tera. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wakaondoka Tera na kupiga kambi huko Mithka. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wakaondoka Mithka na kupiga kambi huko Hashmona. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wakaondoka Hashmona na kupiga kambi Moserothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wakaondoka Moserothi na kupiga kambi huko Bene-Yaakani. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wakaondoka Bene-Yaakani na kupiga kambi huko Hor-Hagidgadi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wakaondoka Hor-Hagidgadi na kupiga kambi huko Yotbatha. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wakaondoka Yotbatha na kupiga kambi huko Abrona. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wakaondoka Abrona na kupiga kambi huko Esion-Geberi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wakaondoka Esion-Geberi na kupiga kambi huko Kadeshi katika Jangwa la Sini. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wakaondoka Kadeshi na kupiga kambi kwenye Mlima Hori, mpakani mwa Edomu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kwa amri ya Mwenyezi Mungu, kuhani Haruni alipanda Mlima Hori, mahali alipofia katika siku ya kwanza ya mwezi wa tano, mwaka wa arobaini baada ya Waisraeli kutoka Misri. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruni alikufa juu ya Mlima Hori akiwa na umri wa miaka mia moja ishirini na tatu (123). ");
INSERT INTO swhonmm_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mfalme Mkanaani wa Aradi, ambaye aliishi huko Negebu ya Kanaani, akasikia kwamba Waisraeli wanakuja. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Wakaondoka kwenye mlima Hori na kupiga kambi huko Salmona. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wakaondoka Salmona, wakapiga kambi huko Punoni. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wakaondoka Punoni, wakapiga kambi huko Obothi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wakaondoka Obothi, wakapiga kambi huko Iye-Abarimu, mipakani mwa Moabu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wakaondoka Iye-Abarimu, wakapiga kambi huko Dibon-Gadi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wakaondoka Dibon-Gadi na kupiga kambi huko Almon-Diblathaimu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wakaondoka Almon-Diblathaimu na kupiga kambi katika milima ya Abarimu, karibu na Nebo. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wakaondoka kwenye milima ya Abarimu na kupiga kambi kwenye tambarare ya Moabu, kando ya Yordani, ng’ambo ya Yeriko. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Huko kwenye tambarare za Moabu walipiga kambi kandokando ya Mto Yordani, kuanzia Beth-Yeshimothi hadi Abel-Shitimu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Katika tambarare za Moabu kando ya Yordani, ng’ambo ya Yeriko, Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Sema na Waisraeli uwaambie: ‘Mtakapovuka Mto Yordani kuingia Kanaani, ");
INSERT INTO swhonmm_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","wafukuzeni wakazi wote wa nchi iliyo mbele yenu. Haribuni sanamu zao zote za kuchongwa, na sanamu zilizotengenezwa kwa kusubu, na kubomoa mahali pao pa juu pa kuabudia. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mtaimiliki nchi hiyo na kukaa huko, kwa kuwa nimewapeni ninyi kuimiliki. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mtaigawanya nchi hiyo kwa kupiga kura, kufuatana na koo zenu. Kwa kundi kubwa zaidi toa urithi mkubwa zaidi, na kwa kundi dogo zaidi urithi mdogo zaidi. Chochote kinachowaangukia kwa kura kitakuwa chao. Mtaigawanya nchi kufuatana na makabila ya babu zenu. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Lakini kama hamkuwafukuza wenyeji wa nchi hiyo, wale mtakaowaruhusu wabaki watakuwa kama sindano kwenye macho yenu na miiba kwenu kila upande. Watawasumbua katika nchi mtakayoishi. ");
INSERT INTO swhonmm_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Kisha nitawatenda ninyi kile ambacho nimepanga kuwatenda wao.’ ” ");
INSERT INTO swhonmm_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Waamuru Waisraeli na uwaambie: ‘Mtakapoingia nchi ya Kanaani, nchi ambayo itagawanywa kwenu kama urithi itakuwa na mipaka ifuatayo: ");
INSERT INTO swhonmm_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Upande wenu wa kusini utajumuisha sehemu ya Jangwa la Sini kufuata mpaka wa Edomu. Upande wa mashariki mpaka wenu wa kusini utaanzia mwisho wa Bahari ya Chumvi, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","katiza kusini mwa Pito la Akrabimu, kuendelea hadi Sini na kwenda kusini mwa Kadesh-Barnea. Kisha mpaka huo utaenda hadi Hasar-Adari hadi Azmoni, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","mahali mpaka utapinda, na kuunganika na Kijito cha Misri, na kumalizikia kwenye Bahari ya Kati. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Mpaka wenu wa magharibi utakuwa Bahari ya Kati. Huu utakuwa mpaka wenu upande wa magharibi. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Kwa mpaka wenu wa kaskazini, wekeni alama kuanzia Bahari ya Kati hadi mlima Hori, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","na kutoka mlima Hori hadi Pito la Hamathi. Kisha mpaka utaenda hadi Sedadi, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","kuendelea hadi Zifroni, na kuishia Hasar-Enani. Huu utakuwa mpaka wenu upande wa kaskazini. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Kwa mpaka wenu wa mashariki, wekeni alama kuanzia Hasar-Enani hadi Shefamu. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Mpaka utaelekea kusini kuanzia Shefamu hadi Ribla upande wa mashariki wa Aini, na kuendelea kwenye miteremko mashariki mwa Bahari ya Kinerethi. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Kisha mpaka utashuka kuelekea Mto Yordani na kuishia katika Bahari ya Chumvi. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musa akawaamuru Waisraeli: “Gawanyeni nchi hii kwa kura kama urithi. Mwenyezi Mungu ameagiza kwamba itolewe kwa yale makabila tisa na nusu, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","kwa sababu jamaa ya kabila la Reubeni, kabila la Gadi, na nusu ya kabila la Manase wamekwishapokea urithi wao. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Haya makabila mawili na nusu wamekwishapokea urithi wao upande wa mashariki wa Yordani ng’ambo ya Yeriko, kuelekea mawio ya jua.” ");
INSERT INTO swhonmm_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Mwenyezi Mungu akamwambia Musa, ");
INSERT INTO swhonmm_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Haya ndiyo majina ya watu ambao watakusaidia kugawanya nchi kama urithi: Eleazari kuhani na Yoshua mwana wa Nuni. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Tena uteue kiongozi mmoja kutoka kila kabila kusaidia kuigawanya nchi. ");
INSERT INTO swhonmm_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Haya ndiyo majina yao: “Kalebu mwana wa Yefune, kutoka kabila la Yuda; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shemueli mwana wa Amihudi, kutoka kabila la Simeoni; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidadi mwana wa Kisloni, kutoka kabila la Benyamini; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki mwana wa Yogli, kiongozi kutoka kabila la Dani; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanieli mwana wa Efodi, kiongozi kutoka kabila la Manase mwana wa Yusufu; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemueli mwana wa Shiftani, kiongozi kutoka kabila la Efraimu mwana wa Yusufu; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elisafani mwana wa Parnaki, kiongozi kutoka kabila la Zabuloni; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltieli mwana wa Azani, kiongozi kutoka kabila la Isakari; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihudi mwana wa Shelomi, kiongozi kutoka kabila la Asheri; ");
INSERT INTO swhonmm_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedaheli mwana wa Amihudi, kiongozi kutoka kabila la Naftali.” ");
INSERT INTO swhonmm_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Hawa ndio watu ambao Mwenyezi Mungu aliamuru wagawanye urithi kwa Waisraeli katika nchi ya Kanaani. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mwenyezi Mungu akamwambia Musa katika nchi tambarare ya Moabu, kando ya Mto Yordani kuvukia Yeriko, ");
INSERT INTO swhonmm_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Waagize Waisraeli kuwapa Walawi miji ya kuishi kutoka urithi ambao Waisraeli wataumiliki. Wape maeneo ya malisho kuzunguka hiyo miji. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Kisha watakuwa na miji ya kuishi na maeneo ya malisho kwa ajili ya ng’ombe wao, mbuzi na kondoo wao, na mifugo yao mingine yote. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Maeneo ya malisho kuzunguka miji hiyo ambayo mtawapa Walawi yataenea dhiraa elfu moja kutoka ukuta wa miji. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Nje ya mji, pima dhiraa elfu mbili upande wa mashariki, upande wa kusini dhiraa elfu mbili, upande wa magharibi dhiraa elfu mbili, na upande wa kaskazini dhiraa elfu mbili, na mji utakuwa katikati. Eneo hili litakuwa lao la malisho. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Miji sita mtakayowapa Walawi itakuwa ya makimbilio, ambayo mtu anayemuua mwenzake aweza kukimbilia humo. Zaidi ya hiyo, wapeni miji mingine arobaini na mbili. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Kwa jumla inawapasa kuwapa Walawi miji arobaini na nane, pamoja na maeneo ya malisho yao. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Miji ambayo mtawapa Walawi kutoka nchi ambayo Waisraeli wanamiliki itatolewa kwa uwiano wa urithi wa kila kabila. Chukua miji mingi kutoka lile kabila lenye miji mingi, lakini uchukue miji michache kutoka kwa kabila lile lenye miji michache.” ");
INSERT INTO swhonmm_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Kisha Mwenyezi Mungu akamwambia Musa: ");
INSERT INTO swhonmm_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Sema na Waisraeli, uwaambie: ‘Mtakapovuka Yordani kuingia Kanaani, ");
INSERT INTO swhonmm_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","chagueni baadhi ya miji iwe miji yenu ya makimbilio, ambayo mtu ambaye ameua mwenzake bila kukusudia aweza kukimbilia humo. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Itakuwa mahali pa kukimbilia kutoka mlipiza kisasi, ili mtu aliyeshtakiwa kwa mauaji asife kabla ya kujitetea mbele ya mkutano. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Miji hii sita mtakayoitoa itakuwa miji yenu ya makimbilio. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mtatoa miji mitatu ng’ambo hii ya Yordani na miji mingine mitatu upande wa Kanaani kama miji ya makimbilio. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Miji hii sita itakuwa mahali pa makimbilio kwa ajili ya Waisraeli, wageni na watu wengine wanaoishi kati yenu, ili mtu ambaye ameua mtu mwingine pasipo kukusudia aweze kukimbilia humo. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Kama mtu akimpiga mwenzake kwa chuma naye mtu huyo akafa, mtu huyo ni muuaji; muuaji sharti atauawa. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Au kama mtu analo jiwe mkononi mwake, naye akampiga mwenzake nalo akafa, yeye ni muuaji; muuaji huyo sharti atauawa. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Au kama mtu ana chombo cha mti mkononi mwake ambacho chaweza kuua, naye akampiga mwenzake akafa, yeye ni muuaji; muuaji huyo sharti atauawa. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mlipiza kisasi cha damu atamuua muuaji; wakati akikutana naye, atamuua. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ikiwa mtu ana chuki ya siku nyingi na mwenzake akamsukuma au akamtupia kitu kwa kukusudia naye akafa, ");
INSERT INTO swhonmm_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","au ikiwa katika uadui akampiga ngumi naye akafa, mtu yule sharti atauawa; yeye ni muuaji. Mlipiza kisasi cha damu atamuua muuaji atakapokutana naye. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Lakini kama mtu akimsukuma mwenziwe ghafula pasipo chuki, au kumtupia kitu pasipo kukusudia, ");
INSERT INTO swhonmm_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","au, pasipo kumwona, akimwangushia jiwe ambalo laweza kumuua naye akafa, basi kwa kuwa hakuwa adui yake naye hakukusudia kumuumiza, ");
INSERT INTO swhonmm_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","kusanyiko lazima waamue kati yake na mlipiza kisasi wa damu kufuatana na sheria hizi. ");
INSERT INTO swhonmm_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Kusanyiko lazima wamlinde yule anayeshtakiwa kuua kutoka kwa mlipiza kisasi wa damu, na kumrudisha katika mji wa maki