﻿USE sofia;
DROP TABLE IF EXISTS sofia.swh1850_vpl;
CREATE TABLE swh1850_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swh1850_vpl WRITE;
INSERT INTO swh1850_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo alikuwa mzawa wa Daudi, mzawa wa Abrahamu. Hii ndiyo orodha ya ukoo wake: ");
INSERT INTO swh1850_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamu alimzaa Isaka, Isaka alimzaa Yakobo, Yakobo alimzaa Yuda na ndugu zake, ");
INSERT INTO swh1850_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda alimzaa Faresi na Zera (mama yao alikuwa Tamari), Faresi alimzaa Hesroni, Hesroni alimzaa Rami, ");
INSERT INTO swh1850_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami alimzaa Aminadabu, Aminadabu alimzaa Nashoni, Nashoni alimzaa Salmoni, ");
INSERT INTO swh1850_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoni alimzaa Boazi (mama yake Boazi alikuwa Rahabu). Boazi na Ruthi walikuwa wazazi wa Obedi, Obedi alimzaa Yese, ");
INSERT INTO swh1850_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","naye Yese alimzaa Mfalme Daudi. Daudi alimzaa Solomoni (mama yake Solomoni alikuwa mke wa Uria). ");
INSERT INTO swh1850_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni alimzaa Rehoboamu, Rehoboamu alimzaa Abiya, Abiya alimzaa Asa, ");
INSERT INTO swh1850_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa alimzaa Yehoshafati, Yehoshafati alimzaa Yoramu, Yoramu alimzaa Uzia, ");
INSERT INTO swh1850_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia alimzaa Yothamu, Yothamu alimzaa Ahazi, Ahazi alimzaa Hezekia, ");
INSERT INTO swh1850_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia alimzaa Manase, Manase alimzaa Amoni, Amoni alimzaa Yosia, ");
INSERT INTO swh1850_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia alimzaa Yekonia na ndugu zake. Huo ulikuwa wakati Wayahudi walipopelekwa uhamishoni Babuloni. ");
INSERT INTO swh1850_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baada ya Wayahudi kupelekwa uhamishomi Babuloni: Yekonia alimzaa Shealtieli, Shealtieli alimzaa Zerobabeli, ");
INSERT INTO swh1850_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerobabeli alimzaa Abiudi, Abiudi alimzaa Eliakimu, Eliakimu alimzaa Azori, ");
INSERT INTO swh1850_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori alimzaa Zadoki, Zadoki alimzaa Akimu, Akimu alimzaa Eliudi, ");
INSERT INTO swh1850_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi alimzaa Eleazeri, Eleazeri alimzaa Mathani, Mathani alimzaa Yakobo, ");
INSERT INTO swh1850_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo alimzaa Yosefu, aliyekuwa mume wake Maria, mama yake Yesu, aitwaye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Basi, kulikuwa na vizazi kumi na vinne tangu Abrahamu mpaka Daudi, vizazi kumi na vinne tangu Daudi mpaka Wayahudi walipochukuliwa mateka Babuloni, na vizazi kumi na vinne tangu kuchukuliwa mateka mpaka wakati wa Kristo. ");
INSERT INTO swh1850_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Basi, hivi ndivyo Yesu Kristo alivyozaliwa: Maria, mama yake, alikuwa ameposwa na Yosefu. Lakini kabla hawajakaa pamoja kama mume na mke, alionekana kuwa mja mzito kwa uwezo wa Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefu, mumewe, kwa vile alikuwa mwadilifu, hakutaka kumwaibisha hadharani; hivyo alikusudia kumwacha kwa siri. ");
INSERT INTO swh1850_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Alipokuwa bado anawaza jambo hilo, malaika wa Bwana alimtokea katika ndoto, akamwambia, “Yosefu, mwana wa Daudi, usiogope kumchukua Maria awe mke wako, maana amekuwa mja mzito kwa uwezo wa Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Atajifungua mtoto wa kiume, nawe utampa jina Yesu, kwa kuwa yeye atawaokoa watu wake kutoka katika dhambi zao.” ");
INSERT INTO swh1850_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Basi, haya yote yalitukia ili litimie lile neno Bwana alilosema kwa njia ya nabii: ");
INSERT INTO swh1850_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Bikira atachukua mimba, atamzaa mtoto wa kiume, naye ataitwa Emanueli” (maana yake, “Mungu yu pamoja nasi”). ");
INSERT INTO swh1850_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hivyo, Yosefu alipoamka usingizini alifanya kama malaika huyo alivyomwambia, akamchukua mke wake nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lakini hakumjua kamwe kimwili hata Maria alipojifungua mtoto wa kiume. Naye Yosefu akampa jina Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu alizaliwa mjini Bethlehemu, mkoani Yudea, wakati Herode alipokuwa mfalme. Punde tu baada ya kuzaliwa kwake, wataalamu wa nyota kutoka mashariki walifika Yerusalemu, ");
INSERT INTO swh1850_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wakauliza, “Yuko wapi mtoto, Mfalme wa Wayahudi, aliyezaliwa? Tumeiona nyota yake ilipotokea mashariki, tukaja kumwabudu.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mfalme Herode aliposikia hayo, alifadhaika, yeye pamoja na wakazi wote wa Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basi akawaita pamoja makuhani wakuu wote na walimu wa Sheria, akawauliza, “Kristo atazaliwa wapi?” ");
INSERT INTO swh1850_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nao wakamjibu, “Mjini Bethlehemu, mkoani Yudea. Ndivyo nabii alivyoandika: ");
INSERT INTO swh1850_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ewe Bethlehemu katika nchi ya Yuda, kwa vyovyote wewe si mdogo kabisa kati ya viongozi wa Yuda; maana kwako atatokea kiongozi atakayewaongoza watu wangu, Israeli.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hapo, Herode aliwaita faraghani hao wataalamu wa nyota, akawauliza wakati hasa ile nyota ilipowatokea. ");
INSERT INTO swh1850_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kisha akawatuma Bethlehemu akisema, “Nendeni mkachunguze kwa makini habari za mtoto huyo. Mkisha mpata nileteeni habari ili nami niende nikamwabudu.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baada ya kumsikiliza mfalme, hao wataalamu wa nyota wakaenda. Kumbe ile nyota waliyokuwa wameiona upande wa mashariki iliwatangulia hata ikaenda kusimama juu ya mahali pale alipokuwa mtoto. ");
INSERT INTO swh1850_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Walipoiona hiyo nyota, walifurahi mno. ");
INSERT INTO swh1850_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Basi, wakaingia nyumbani, wakamwona yule mtoto pamoja na Maria mama yake; wakapiga magoti, wakamsujudia. Kisha wakafungua hazina zao, wakampa zawadi: dhahabu, ubani na manemane. ");
INSERT INTO swh1850_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mungu aliwaonya katika ndoto wasimrudie Herode; hivyo wakarudi makwao kwa njia nyingine. ");
INSERT INTO swh1850_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baada ya wale wageni kuondoka, malaika wa Bwana alimtokea Yosefu katika ndoto, akamwambia, “Amka! Mchukue mtoto pamoja na mama yake, mkimbilie Misri. Kaeni huko mpaka nitakapokwambia, maana Herode anakusudia kumwua huyu mtoto.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hivyo, Yosefu aliamka, akamchukua mtoto pamoja na mama yake, akaondoka usiku, akaenda Misri. ");
INSERT INTO swh1850_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akakaa huko mpaka Herode alipokufa. Jambo hilo lilifanyika ili neno alilosema Bwana kwa njia ya nabii litimie: “Nilimwita Mwanangu kutoka Misri.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herode alipogundua kwamba wale wataalamu wa nyota walikuwa wamemhadaa, alikasirika sana. Akaamuru watoto wote wa kiume mjini Bethlehemu na kandokando yake wenye umri wa miaka miwili na chini yake wauawe. Alifanya hivyo kufuatana na muda aliopata kujua kutoka kwa wale wataalamu wa nyota. ");
INSERT INTO swh1850_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndivyo yalivyotimia maneno yaliyosemwa kwa njia ya nabii Yeremia: ");
INSERT INTO swh1850_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sauti imesikika mjini Rama, kilio na maombolezo mengi. Raheli anawalilia watoto wake, wala hataki kutulizwa, maana wote wamefariki.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baada ya kifo cha Herode, malaika wa Bwana alimtokea Yosefu katika ndoto kule Misri, ");
INSERT INTO swh1850_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamwambia, “Amka! Mchukue mtoto pamoja na mama yake, urudi tena katika nchi ya Israeli, maana wale waliotaka kumwua mtoto huyo wamekwisha kufa.” ");
INSERT INTO swh1850_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Basi, Yosefu aliamka, akamchukua mtoto pamoja na mama yake, akarejea katika nchi ya Israeli. ");
INSERT INTO swh1850_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini Yosefu aliposikia kwamba Arkelao mwanawe Herode alikuwa mfalme wa Yudea mahali pa baba yake, aliogopa kwenda huko. Naye baada ya kuonywa katika ndoto, alikwenda katika mkoa wa Galilaya, ");
INSERT INTO swh1850_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akahamia katika mji uitwao Nazareti. Ndivyo yalivyotimia maneno yaliyonenwa kwa njia ya manabii: “Ataitwa Mnazare.” ");
INSERT INTO swh1850_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Siku hizo Yohane Mbatizaji alitokea, akaanza kuhubiri katika jangwa la Yudea: ");
INSERT INTO swh1850_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tubuni, maana Ufalme wa mbinguni umekaribia.” ");
INSERT INTO swh1850_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Huyu Yohane ndiye yule ambaye nabii Isaya alinena juu yake aliposema: “Sauti ya mtu imesikika jangwani: Mtayarishieni Bwana njia yake, nyoosheni vijia vyake.” ");
INSERT INTO swh1850_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane alivaa vazi lililoshonwa kwa manyoya ya ngamia, na ukanda wa ngozi kiunoni mwake. Chakula chake kilikuwa nzige na asali ya mwituni. ");
INSERT INTO swh1850_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Basi, watu kutoka Yerusalemu, kutoka mkoa wote wa Yudea na sehemu zote za kandokando ya mto Yordani, walimwendea, ");
INSERT INTO swh1850_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","wakaziungama dhambi zao, naye akawabatiza katika mto Yordani. ");
INSERT INTO swh1850_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lakini alipowaona Mafarisayo wengi na Masadukayo wanamjia ili awabatize, aliwaambia, “Enyi kizazi cha nyoka! Ni nani aliyewadokezea kwamba mnaweza kuiepuka ghadhabu inayokuja? ");
INSERT INTO swh1850_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Onyesheni basi kwa matendo, kwamba mmetubu kweli. ");
INSERT INTO swh1850_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Msidhani kwamba mtaweza kujitetea kwa kusema, Baba yetu ni Abrahamu! Nawaambieni hakika, Mungu anaweza kuyafanya mawe haya yawe watoto wa Abrahamu. ");
INSERT INTO swh1850_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Basi, shoka liko tayari kuikata mizizi ya miti; hivyo, kila mti usiozaa matunda mazuri, utakatwa na kutupwa motoni. ");
INSERT INTO swh1850_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mimi ninawabatizeni kwa maji kuonyesha kwamba mmetubu. Lakini yule anayekuja baada yangu ana uwezo kuliko mimi. Mimi sistahili hata kubeba viatu vyake. Yeye atawabatizeni kwa Roho Mtakatifu na kwa moto. ");
INSERT INTO swh1850_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yeye anashika mkononi chombo cha kupuria nafaka, ili aipure nafaka yake; akusanye ngano ghalani, na makapi ayachome kwa moto usiozimika.” ");
INSERT INTO swh1850_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wakati huo Yesu alitoka Galilaya akafika katika mto Yordani, akamwendea Yohane ili abatizwe naye. ");
INSERT INTO swh1850_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohane alijaribu kumzuia akisema, “Je, wewe unakuja kwangu? Mimi hasa ndiye ninayehitaji kubatizwa nawe.” ");
INSERT INTO swh1850_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lakini Yesu akamjibu, “Acha tu iwe hivyo kwa sasa, maana kwa namna hii inafaa tuyatekeleze yale yote Mungu anayotaka.” Hapo Yohane akakubali. ");
INSERT INTO swh1850_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mara tu Yesu alipokwisha batizwa, alitoka majini; na ghafla mbingu zikafunguka, akaona Roho wa Mungu akishuka kama njiwa na kutua juu yake. ");
INSERT INTO swh1850_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sauti kutoka mbinguni ikasema, “Huyu ndiye Mwanangu mpendwa, nimependezwa naye.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kisha Roho alimwongoza Yesu mpaka jangwani ili ajaribiwe na Ibilisi. ");
INSERT INTO swh1850_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akafunga siku arubaini mchana na usiku, na mwishowe akaona njaa. ");
INSERT INTO swh1850_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Basi, mshawishi akamjia, akamwambia, “Ikiwa wewe ni Mwana wa Mungu, amuru mawe haya yawe mikate.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu akamjibu, “Imeandikwa katika Maandiko Matakatifu: Binadamu hataishi kwa mikate tu, ila kwa kila neno asemalo Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kisha Ibilisi akamchukua mpaka Yerusalemu, mji mtakatifu, akamweka juu ya mnara wa hekalu, ");
INSERT INTO swh1850_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamwambia, “Ikiwa wewe ni Mwana wa Mungu, jitupe chini; maana imeandikwa: Mungu atawaamuru malaika wake kwa ajili yako; watakuchukua mikononi mwao, usije ukajikwaa kwenye jiwe.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akamwambia, “Imeandikwa pia: Usimjaribu Bwana, Mungu wako.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kisha Ibilisi akamchukua mpaka juu ya mlima mrefu, akamwonyesha falme zote za ulimwengu na fahari zake, ");
INSERT INTO swh1850_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akamwambia, “Hivi vyote nitakupa kama tu ukipiga magoti na kuniabudu.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hapo, Yesu akamwambia, “Nenda zako Shetani! Imeandikwa: Utamwabudu Bwana Mungu wako na kumtumikia yeye peke yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Basi, Ibilisi akamwacha, na malaika wakaja, wakamhudumia. ");
INSERT INTO swh1850_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu aliposikia kwamba Yohane ametiwa gerezani alikwenda Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aliondoka Nazareti, akaenda Kafarnaumu, mji ulio kando ya bahari ya Genesareti, mpakani mwa wilaya za Zabuloni na Naftali, akakaa huko. ");
INSERT INTO swh1850_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ndivyo lilivyotimia lile neno lililosemwa kwa njia ya nabii Isaya: ");
INSERT INTO swh1850_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nchi ya Zabuloni na nchi ya Naftali, kuelekea baharini ng'ambo ya mto Yordani, Galilaya nchi ya watu wa Mataifa! ");
INSERT INTO swh1850_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Watu waliokaa gizani wameona mwanga mkubwa. Nao walioishi katika nchi ya giza na kivuli cha kifo, mwanga umewaangazia!” ");
INSERT INTO swh1850_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tangu wakati huo Yesu alianza kuhubiri akisema, “Tubuni, maana ufalme wa mbinguni umekaribia!” ");
INSERT INTO swh1850_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu alipokuwa anatembea kando ya ziwa Galilaya, aliwaona ndugu wawili wavuvi; Simoni (aitwae Petro) na Andrea, ndugu yake; walikuwa wakivua samaki kwa nyavu ziwani. ");
INSERT INTO swh1850_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Basi, akawaambia, “Nifuateni, nami nitawafanya ninyi wavuvi wa watu.” ");
INSERT INTO swh1850_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mara wakaziacha nyavu zao, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Alipokwenda mbele kidogo, aliwaona ndugu wengine wawili: Yakobo na Yohane, wana wa Zebedayo. Hao walikuwa ndani ya mashua pamoja na baba yao Zebedayo, wakitengeneza nyavu zao. Basi Yesu akawaita, ");
INSERT INTO swh1850_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nao mara wakaiacha mashua pamoja na baba yao, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu alikuwa anakwenda kila mahali wilayani Galilaya, akifundisha katika masunagogi na kuhubiri Habari Njema juu ya ufalme wa Mungu. Aliponya kila namna ya maradhi na magonjwa waliyokuwa nayo watu. ");
INSERT INTO swh1850_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Habari zake zikaenea katika mkoa wote wa Siria. Wagonjwa wote wenye maradhi ya kila namna na wale waliosumbuliwa na kila namna ya taabu: waliopagawa na pepo, wenye kifafa na watu waliokuwa wamelemaa, walipelekwa kwake; naye akawaponya wote. ");
INSERT INTO swh1850_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Makundi mengi ya watu kutoka Galilaya, Dekapoli, Yerusalemu, Yudea na ng'ambo ya mto Yordani, walimfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu alipoyaona makundi ya watu, alipanda mlimani, akaketi. Wanafunzi wake wakamwendea, ");
INSERT INTO swh1850_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","naye akaanza kuwafundisha: ");
INSERT INTO swh1850_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Heri walio maskini rohoni, maana ufalme wa mbinguni ni wao. ");
INSERT INTO swh1850_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Heri walio na huzuni, maana watafarijiwa. ");
INSERT INTO swh1850_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Heri walio wapole, maana watairithi nchi. ");
INSERT INTO swh1850_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Heri wenye njaa na kiu ya kufanya atakavyo Mungu, maana watashibishwa. ");
INSERT INTO swh1850_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Heri walio na huruma, maana watahurumiwa. ");
INSERT INTO swh1850_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Heri wenye moyo safi, maana watamwona Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Heri wenye kuleta amani, maana wataitwa watoto wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Heri wanaoteswa kwa sababu ya kufanya atakavyo Mungu, maana ufalme wa mbinguni ni wao. ");
INSERT INTO swh1850_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Heri yenu ninyi watu wakiwatukana, wakiwadhulumu na kuwasingizia kila aina ya uovu kwa ajili yangu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Furahini na kushangilia maana tuzo lenu ni kubwa mbinguni. Hivyo ndivyo walivyowadhulumu manabii waliokuwako kabla yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ninyi ni chumvi ya dunia! Lakini chumvi ikipoteza ladha yake itakolezwa na nini? Haifai kitu tena, ila hutupwa nje na kukanyagwa na watu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ninyi ni mwanga wa ulimwengu! Mji uliojengwa juu ya mlima hauwezi kufichika. ");
INSERT INTO swh1850_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wala watu hawawashi taa na kuifunika kwa chungu, ila huiweka juu ya kinara ili iwaangazie wote waliomo nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vivyo hivyo, ni lazima mwanga wenu uangaze mbele ya watu, ili wayaone matendo yenu mema, wamtukuze Baba yenu aliye mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Msidhani ya kuwa nimekuja kutangua Sheria ya Mose na mafundisho ya manabii. Sikuja kutangua bali kukamilisha. ");
INSERT INTO swh1850_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kweli nawaambieni, mpaka hapo mbingu na dunia zitakapopita, hakuna hata nukta moja au sehemu ndogo kabisa ya Sheria itakayoondolewa, mpaka yote yametimia. ");
INSERT INTO swh1850_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Basi, yeyote atakayevunja hata amri moja ndogo kuliko zote, na kuwafundisha wengine wafanye hivyo, huyo atakuwa mdogo kabisa katika Ufalme wa mbiguni. Lakini yule atakayezishika na kuwafundisha wengine, huyo atakuwa mkubwa katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndiyo maana nawaambieni, wema wenu usipozidi ule wa Mafarisayo na walimu wa Sheria, hamtaingia kamwe katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mmekwisha sikia ya kuwa watu wa kale waliambiwa: Usiue! Atakayeua lazima ahukumiwe. ");
INSERT INTO swh1850_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini mimi nawaambieni, yeyote anayemkasirikia ndugu yake, lazima ahukumiwe. Anayemdharau ndugu yake atapelekwa mahakamani. Anayemwita ndugu yake: Pumbavu atastahili kuingia katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Basi, ukipeleka sadaka yako mbele ya madhabahu na hapo ukakumbuka kwamba ndugu yako ana ugomvi nawe, ");
INSERT INTO swh1850_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","iache sadaka yako mbele ya madhabahu, nenda kwanza ukapatane na ndugu yako, ndipo urudi ukatoe sadaka yako. ");
INSERT INTO swh1850_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Patana na mshtaki wako upesi mkiwa bado njiani, kwenda mahakamani. La sivyo, mshtaki wako atakukabidhi kwa hakimu, naye hakimu atakukabidhi kwa askari, nawe utafungwa gerezani. ");
INSERT INTO swh1850_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kweli nakwambia, hutatoka humo mpaka umemaliza kulipa senti ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mmesikia ya kuwa watu waliambiwa: Usizini! ");
INSERT INTO swh1850_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini mimi nawaambieni, atakayemtazama mwanamke kwa kumtamani, amekwisha zini naye moyoni mwake. ");
INSERT INTO swh1850_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Basi, kama jicho lako la kulia linakukosesha, ling'oe ukalitupe mbali. Afadhali zaidi kwako kupoteza kiungo kimoja cha mwili wako, kuliko mwili wako wote kutupwa katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na kama mkono wako wa kulia unakukosesha, ukate ukautupe mbali. Afadhali zaidi kupoteza kiungo kimoja cha mwili, kuliko mwili wako wote uende katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ilikwisha semwa pia: Anayemwacha mke wake, yampasa ampe hati ya talaka. ");
INSERT INTO swh1850_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini mimi nawaambieni, anayempa mkewe talaka, isipokuwa kwa sababu ya uzinzi, anamfanya azini; na mtu akimwoa mwanamke aliyepewa talaka, anazini. ");
INSERT INTO swh1850_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tena mmesikia kuwa watu wa kale waliambiwa: Usivunje kiapo chako, bali ni lazima utimize kiapo chako kwa Bwana. ");
INSERT INTO swh1850_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini mimi nawaambieni, msiape kamwe; wala kwa mbingu, maana ni kiti cha enzi cha Mungu; ");
INSERT INTO swh1850_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala kwa dunia, maana ni kiti chake cha kuwekea miguu; wala kwa Yerusalemu, maana ni mji wa Mfalme mkuu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala usiape kwa kichwa chako, maana huwezi kuufanya hata unywele mmoja kuwa mweupe au mweusi. ");
INSERT INTO swh1850_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ukisema, Ndiyo, basi iwe Ndiyo; ukisema Siyo, basi iwe kweli Siyo. Chochote kinachozidi hayo hutoka kwa yule Mwovu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mmesikia kwamba ilisemwa: Jicho kwa jicho, jino kwa jino. ");
INSERT INTO swh1850_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini mimi nawaambieni, usimlipize kisasi mtu mbaya. Mtu akikupiga kofi shavu la kulia, mgeuzie pia shavu la pili. ");
INSERT INTO swh1850_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mtu akikupeleka mahakamani kutaka kukuchukulia shati lako, mwache achukue pia koti lako. ");
INSERT INTO swh1850_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mtu akikulazimisha kubeba mzigo wake kilomita moja, ubebe kilomita mbili. ");
INSERT INTO swh1850_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akuombaye mpe, na mtu akitaka kukukopa kitu usimnyime. ");
INSERT INTO swh1850_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mmesikia kwamba ilisemwa: Mpende jirani yako na kumchukia adui yako. ");
INSERT INTO swh1850_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini mimi nawaambieni, wapendeni adui zenu na kuwaombea wale wanaowadhulumu ninyi ");
INSERT INTO swh1850_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ili mpate kuwa watoto wa Baba yenu aliye mbinguni. Kwa maana yeye huwaangazia jua lake watu wabaya na wema, na kuwanyeshea mvua watu wanyofu na waovu. ");
INSERT INTO swh1850_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Je, mtapata tuzo gani kwa kuwapenda tu wale wanaowapenda ninyi? Hakuna! Kwa maana hata watoza ushuru hufanya hivyo! ");
INSERT INTO swh1850_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kama mkiwasalimu ndugu zenu tu, je, mmefanya kitu kisicho cha kawaida? Hata watu wasiomjua Mungu nao hufanya vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Basi, muwe wakamilifu kama Baba yenu wa mbinguni alivyo mkamilifu. ");
INSERT INTO swh1850_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Jihadharini msije mkafanya matendo yenu mema mbele ya watu kusudi mwonekane nao. La sivyo, Baba yenu aliye mbinguni hatawapeni tuzo. ");
INSERT INTO swh1850_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Basi, unapomsaidia maskini, usijitangaze. Usifanye kama wanafiki wafanyavyo katika masunagogi na njiani ili watu wawasifu. Kweli nawaambieni, hao wamekwisha pata tuzo lao. ");
INSERT INTO swh1850_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini wewe unapomsaidia maskini, fanya hivyo kwamba hata rafiki yako asijue ufanyalo. ");
INSERT INTO swh1850_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Toa msaada wako kwa siri, na Baba yako aonaye yaliyofichika, atakutuza. ");
INSERT INTO swh1850_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mnaposali, msifanye kama wanafiki. Wao hupenda kusimama na kusali katika masunagogi na katika pembe za njia ili watu wawaone. Kweli nawaambieni, hao wamekwisha pata tuzo lao. ");
INSERT INTO swh1850_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini wewe unaposali, ingia chumbani mwako, funga mlango, kisha umwombe Baba yako asiyeonekana. Naye Baba yako aonaye yaliyofichika, atakutuza. ");
INSERT INTO swh1850_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mnaposali, msipayuke maneno kama watu wasiomjua Mungu. Wao hudhani kwamba Mungu atawasikiliza ati kwa sababu ya maneno mengi. ");
INSERT INTO swh1850_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Msiwe kama wao. Baba yenu anajua mnayoyahitaji hata kabla ya kumwomba. ");
INSERT INTO swh1850_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Basi, hivi ndivyo mnavyopaswa kusali: Baba yetu uliye mbinguni: Jina lako litukuzwe. ");
INSERT INTO swh1850_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ufalme wako ufike. Utakalo lifanyike duniani kama mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupe leo chakula chetu tunachohitaji. ");
INSERT INTO swh1850_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utusamehe makosa yetu, kama nasi tunavyowasamehe waliotukosea. ");
INSERT INTO swh1850_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usitutie katika majaribu, lakini utuokoe na yule Mwovu. is Baadhi ya makala za zamani zina; Kwa kuwa ufalme ni wako, na nguvu, na utukufu, hata milele. Amina. ");
INSERT INTO swh1850_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Maana mkiwasamehe watu makosa yao, Baba yenu wa mbinguni atawasamehe ninyi pia. ");
INSERT INTO swh1850_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini msipowasamehe watu makosa yao, naye Baba yenu hatawasamehe ninyi makosa yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mnapofunga, msiwe na huzuni kama wanafiki. Wao hukunja nyuso zao wapate kuonekana na watu kuwa wanafunga. Nawaambieni hakika, hao wamekwisha pata tuzo lao. ");
INSERT INTO swh1850_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wewe lakini unapofunga, paka kichwa chako mafuta, nawa uso wako, ");
INSERT INTO swh1850_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili mtu yeyote asijue kwamba unafunga, ila ujulikane tu kwa Baba yako asiyeonekana. Naye Baba yako aonaye yaliyofichika atakutuza. ");
INSERT INTO swh1850_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Msijiwekee hazina hapa duniani ambako nondo na kutu huharibu, na wezi huingia na kuiba. ");
INSERT INTO swh1850_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jiwekeeni hazina mbinguni ambako nondo na kutu hawawezi kuiharibu, wala wezi hawaingii wakaiba. ");
INSERT INTO swh1850_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maana pale ilipo hazina yako, ndipo pia utakapokuwa moyo wako. ");
INSERT INTO swh1850_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Jicho ni taa ya mwili. Kama jicho lako ni zima, mwili wako wote utakuwa katika mwanga. ");
INSERT INTO swh1850_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini ikiwa jicho lako ni bovu, mwili wako wote utakuwa katika giza. Basi, ikiwa mwanga ulioko ndani yako ni giza, basi, hilo ni giza la kutisha mno. ");
INSERT INTO swh1850_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hakuna mtu awezaye kutumikia mabwana wawili. Maana atamchukia mmoja na kumpenda huyo wa pili; au ataambatana na mmoja na kumdharau huyo mwingine. Hamwezi kumtumikia Mungu na mali pamoja. ");
INSERT INTO swh1850_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndiyo maana nawaambieni, msiwe na wasiwasi juu ya chakula na kinywaji mnavyohitaji ili kuishi, wala juu ya mavazi mnayohitaji kwa ajili ya miili yenu. Je, maisha ni chakula tu au zaidi? Na mwili, je, si zaidi ya mavazi? ");
INSERT INTO swh1850_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Waangalieni ndege wa mwituni: hawapandi, hawavuni, wala hawana ghala yoyoye. Hata hivyo, Baba yenu wa mbinguni huwalisha. Je, ninyi si wa thamani kuliko hao? ");
INSERT INTO swh1850_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni nani miongoni mwenu kwa kuwa na wasiwasi sana anaweza kuuongeza muda wa maisha yake? ");
INSERT INTO swh1850_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na kuhusu mavazi, ya nini kuwa na wasiwasi? Tazameni maua ya porini jinsi yanavyostawi. Hayafanyi kazi wala hayasokoti. ");
INSERT INTO swh1850_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lakini nawaambieni, hata Solomoni mwenyewe na fahari zake zote hakupata kuvikwa vizuri kama ua mojawapo. ");
INSERT INTO swh1850_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ikiwa basi Mungu hulivika hivyo jani la shambani ambalo leo liko na kesho latupwa motoni, je, hatafanya zaidi kwenu ninyi? Enyi watu wenye imani haba! ");
INSERT INTO swh1850_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Basi, msiwe na wasiwasi: Tutakula nini, tutakunywa nini, tutavaa nini! ");
INSERT INTO swh1850_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maana hayo yote yanahangaikiwa na watu wasiomjua Mungu. Baba yenu wa mbinguni anajua kwamba mnahitaji vitu hivyo vyote. ");
INSERT INTO swh1850_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bali, zingatieni kwanza Ufalme wa Mungu na matakwa yake, na hayo mengine yote mtapewa kwa ziada. ");
INSERT INTO swh1850_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Basi, msiwe na wasiwasi juu ya kesho; kesho inayo yake. Matatizo ya siku moja yanawatosheni kwa siku hiyo. ");
INSERT INTO swh1850_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Msiwahukumu wengine, msije nanyi mkahukumiwa na Mungu; ");
INSERT INTO swh1850_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kwa maana jinsi mnavyowahukumu wengine, ndivyo nanyi mtakavyohukumiwa; na kipimo kilekile mnachotumia kwa wengine ndicho Mungu atakachotumia kwenu. ");
INSERT INTO swh1850_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kwa nini wakiona kibanzi kilicho jichoni mwa ndugu yako, na papo hapo huioni boriti iliyoko jichoni mwako? ");
INSERT INTO swh1850_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Au, wawezaje kumwambia ndugu yako, Ndugu, ngoja nikuondoe kibanzi jichoni mwako, wakati wewe mwenyewe unayo boriti jichoni mwako? ");
INSERT INTO swh1850_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mnafiki wewe! Ondoa kwanza boriti iliyoko jichoni mwako na hapo ndipo utaona waziwazi kiasi cha kuweza kuondoa kibanzi kilichoko jichoni mwa ndugu yako. ");
INSERT INTO swh1850_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Msiwape mbwa vitu vitakatifu wasije wakageuka na kuwararua ninyi; wala msiwatupie nguruwe lulu zenu wasije wakazikanyaga. ");
INSERT INTO swh1850_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ombeni, nanyi mtapewa; tafuteni, nanyi mtapata; bisheni, nanyi mtafunguliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maana, aombaye hupewa, atafutaye hupata, na abishaye hufunguliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Je, kuna yeyote miongoni mwenu ambaye mtoto wake akimwomba mkate, atampa jiwe? ");
INSERT INTO swh1850_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au je, akimwomba samaki, atampa nyoka? ");
INSERT INTO swh1850_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kama basi ninyi, ingawa ni waovu, mwajua kuwapa watoto wenu vitu vizuri, hakika Baba yenu wa mbinguni atafanya zaidi: atawapa mema wale wanaomwomba. ");
INSERT INTO swh1850_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Watendeeni wengine yale mnayotaka wao wawatendee ninyi. Hii ndiyo maana ya Sheria ya Mose na mafundisho ya manabii. ");
INSERT INTO swh1850_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ingieni kwa kupitia mlango mwembamba. Kwa maana njia inayoongoza kwenye maangamizi ni pana, na mlango wa kuingilia humo ni mpana; waendao njia hiyo ni wengi. ");
INSERT INTO swh1850_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lakini njia inayoongoza kwenye uzima ni nyembamba, na mlango wa kuingilia humo ni mwembamba; ni watu wachache tu wanaoweza kuigundua njia hiyo. ");
INSERT INTO swh1850_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Jihadharini na manabii wa uongo. Wao huja kwenu wakionekana kama kondoo kwa nje, lakini kwa ndani ni mbwa mwitu wakali. ");
INSERT INTO swh1850_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mtawatambua kwa matendo yao. Je, watu huchuma zabibu katika miti ya miiba, au tini katika mbigili? La! ");
INSERT INTO swh1850_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Basi, mti mwema huzaa matunda mema, na mti mbaya huzaa matunda mabaya. ");
INSERT INTO swh1850_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mti mwema hauwezi kuzaa matunda mabaya, wala mti mbaya hauwezi kuzaa matunda mema. ");
INSERT INTO swh1850_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila mti usiozaa matunda mema utakatwa na kutupwa motoni. ");
INSERT INTO swh1850_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kwa hiyo, mtawatambua kwa matendo yao. ");
INSERT INTO swh1850_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Si kila aniambiaye, Bwana, Bwana, ataingia katika Ufalme wa mbinguni; ila ni yule tu anayetimiza mapenzi ya Baba yangu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wengi wataniambia Siku ile ya hukumu: Bwana, Bwana! kwa jina lako tulitangaza ujumbe wako, na kwa jina lako tuliwatoa pepo na kufanya miujiza mingi. ");
INSERT INTO swh1850_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hapo nitawaambia: Sikuwajua ninyi kamwe; ondokeni mbele yangu, enyi watenda maovu. ");
INSERT INTO swh1850_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kwa sababu hiyo, kila mtu anayeyasikia maneno yangu na kuyazingatia, anafanana na mtu mwenye busara, aliyejenga nyumba yake juu ya mwamba. ");
INSERT INTO swh1850_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvua ikanyesha, mito ikafurika, pepo kali zikavuma na kuipiga nyumba hiyo. Lakini haikuanguka kwa sababu ilikuwa imejengwa juu ya mwamba. ");
INSERT INTO swh1850_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lakini yeyote anayesikia maneno yangu haya bila kuyazingatia, anafanana na mtu mpumbavu aliyejenga nyumba yake juu ya mchanga. ");
INSERT INTO swh1850_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvua ikanyesha, mito ikafurika, pepo kali zikavuma na kuipiga nyumba hiyo, nayo ikaanguka; tena kwa kishindo kikubwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu alipomaliza kusema maneno hayo, umati wa watu ukashangazwa na mafundisho yake. ");
INSERT INTO swh1850_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hakuwa kama walimu wao wa Sheria, bali alifundisha kwa mamlaka. ");
INSERT INTO swh1850_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu aliposhuka kutoka mlimani, makundi mengi ya watu yalimfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Basi, akaja mtu mmoja mwenye ukoma, akamsujudia akisema, “Bwana, ukitaka, waweza kunitakasa!” ");
INSERT INTO swh1850_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu akanyosha mkono wake, akamgusa na kusema, “Nataka! Takasika.” Mara huyo mtu akapona ukoma wake. ");
INSERT INTO swh1850_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kisha Yesu akamwambia, “Sikiliza, usimwambie mtu yeyote, ila nenda ukajionyeshe kwa kuhani, na ukatoe sadaka iliyoamriwa na Mose kuwathibitishia kwamba umepona.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu alipokuwa anaingia mjini Kafarnaumu, ofisa mmoja Mroma alimwendea, akamsihi ");
INSERT INTO swh1850_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akisema, “Mheshimiwa, mtumishi wangu amelala nyumbani, mgonjwa wa kupooza na anaumwa sana.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu akamwambia, “Nitakuja kumponya.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Huyo ofisa akamwambia, “Mheshimiwa, sistahili uingie nyumbani mwangu. Lakini sema tu neno, na mtumishi wangu atapona. ");
INSERT INTO swh1850_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maana, hata mimi niliye mtu chini ya mamlaka ya wengine, ninao askari chini yangu. Namwambia mmoja, Nenda! naye huenda; na mwingine, Njoo! naye huja; na mtumishi wangu, Fanya kitu hiki! naye hufanya.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu aliposikia hayo, alistaajabu, akawaambia watu waliokuwa wanamfuata, “Kweli nawaambieni, sijapata kumwona mtu yeyote katika Israeli aliye na imani kama hii. ");
INSERT INTO swh1850_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Basi, nawaambieni kwamba watu wengi watakuja kutoka mashariki na magharibi, nao wataketi karamuni pamoja na Abrahamu, Isaka na Yakobo katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini wale ambao wangalipaswa kuwa katika Ufalme huo watatupwa nje, gizani, ambako watalia na kusaga meno.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kisha Yesu akamwambia huyo ofisa Mroma, “Nenda nyumbani; na iwe kama ulivyoamini.” Na mtumishi wake akapona saa ileile. ");
INSERT INTO swh1850_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu alifika nyumbani kwa Petro, akamkuta mama mkwe wa Petro amelala kitandani, ana homa kali. ");
INSERT INTO swh1850_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Basi, Yesu akamgusa huyo mama mkono, na homa ikamwacha; akasimama, akamtumikia. ");
INSERT INTO swh1850_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ilipokuwa jioni, walimletea watu wengi waliokuwa wamepagawa na pepo; naye, kwa kusema neno tu, akawafukuza hao pepo. Aliwaponya pia watu wote waliokuwa wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alifanya hivyo ili yale aliyosema nabii Isaya yatimie: “Yeye mwenyewe ameondoa udhaifu wetu, ameyachukua magonjwa yetu.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu alipoona kundi la watu limemzunguka, aliwaamuru wanafunzi wake waende ng'ambo ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mwalimu mmoja wa Sheria akamwendea, akamwambia, “Mwalimu, mimi nitakufuata kokote uendako.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu akamjibu, “Mbweha wana mapango, na ndege wana viota; lakini Mwana wa Mtu hana mahali pa kupumzikia.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kisha mtu mwingine miongoni mwa wanafunzi wake akamwambia, “Bwana, niruhusu kwanza niende nikamzike baba yangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu akamwambia, “Nifuate! Waache wafu wazike wafu wao.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu alipanda mashua, na wanafunzi wake wakaenda pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ghafla, dhoruba kali ikatokea ziwani, hata mawimbi yakaanza kuifunika mashua. Yesu alikuwa amelala usingizi. ");
INSERT INTO swh1850_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanafunzi wakamwendea, wakamwamsha wakisema, “Bwana, tuokoe, tunaangamia!” ");
INSERT INTO swh1850_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu akawaambia, “Enyi watu wenye imani haba; mbona mnaogopa?” Basi, akainuka, akazikemea pepo na mawimbi; kukawa shwari kabisa. ");
INSERT INTO swh1850_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Watu wakashangaa, wakasema, “Ni mtu wa namna gani huyu? Hata pepo na mawimbi vinamtii!” ");
INSERT INTO swh1850_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu alifika katika nchi ya Wagerasi, ng'ambo ya ziwa, na huko watu wawili waliopagawa na pepo wakakutana naye wakitokea makaburini. Watu hawa walikuwa wenye kutisha mno, hata hakuna mtu aliyethubutu kupita katika njia hiyo. ");
INSERT INTO swh1850_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nao wakaanza kupiga kelele, “Una shauri gani nasi, wewe Mwana wa Mungu? Je, umekuja kututesa kabla ya wakati wake?” ");
INSERT INTO swh1850_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Karibu na mahali hapo kulikuwa na nguruwe wengi wakichungwa. ");
INSERT INTO swh1850_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Basi, hao pepo wakamsihi, “Ikiwa utatutoa, basi uturuhusu tuwaingie nguruwe wale.” ");
INSERT INTO swh1850_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu akawaambia, “Haya, nendeni.” Hapo wakawatoka watu hao, wakawaingia nguruwe. Kundi lote la nguruwe likaporomoka kwenye ule mteremko mkali, likatumbukia ziwani; nguruwe wote wakafa maji. ");
INSERT INTO swh1850_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wachungaji wa hao nguruwe walikimbia, wakaenda mjini. Huko walitoa habari zote na mambo yaliyowapata wale watu waliokuwa wamepagawa. ");
INSERT INTO swh1850_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Basi, watu wote katika mji ule walitoka, wakamwendea Yesu; na walipomwona, wakamsihi aondoke katika nchi yao. ");
INSERT INTO swh1850_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu alipanda mashua, akavuka ziwa na kufika katika mji wake. ");
INSERT INTO swh1850_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hapo watu walimletea mtu mmoja aliyepooza mwili, amelazwa juu ya kitanda. Yesu alipoona imani yao, akamwambia huyo mtu aliyepooza, “Jipe moyo mwanangu! Umesamehewa dhambi zako.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Baadhi ya walimu wa Sheria wakaanza kufikiri, “Mtu huyu anamkufuru Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu aliyajua mawazo yao, akasema, “Kwa nini mnawaza mabaya mioyoni mwenu? ");
INSERT INTO swh1850_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni lipi lililo rahisi zaidi: kusema, Umesamehewa dhambi zako, au kusema, Simama, utembee? ");
INSERT INTO swh1850_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Basi, nataka mjue kwamba Mwana wa Mtu anao uwezo wa kuwasamehe watu dhambi duniani.” Hapo akamwambia huyo mtu aliyepooza, “Inuka, chukua kitanda chako, uende nyumbani kwako.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Huyo mtu aliyekuwa amepooza akainuka, akaenda nyumbani kwake. ");
INSERT INTO swh1850_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Watu wote katika ule umati walipoona hayo, walishangaa na kuogopa; wakamtukuza Mungu aliyewapa binadamu uwezo wa namna hiyo. ");
INSERT INTO swh1850_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu aliondoka hapo, na alipokuwa anakwenda zake, alimwona mtu mmoja aitwaye Mathayo, ameketi katika ofisi ya ushuru. Basi, Yesu akamwambia, “Nifuate.” Naye Mathayo akainuka, akamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu alipokuwa nyumbani ameketi kula chakula, watoza ushuru wengi na wahalifu walikuja wakaketi pamoja naye na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafarisayo walipoona hayo, wakawaambia wanafunzi wake, “Mbona mwalimu wenu anakula pamoja na watoza ushuru na wenye dhambi?” ");
INSERT INTO swh1850_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu aliwasikia, akasema, “Watu wenye afya hawahitaji daktari; wanaomhitaji ni wale walio wagonjwa. Sikuja kuwaita watu wema, ila wenye dhambi. ");
INSERT INTO swh1850_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Basi, kajifunzeni maana ya maneno haya: Nataka huruma, wala si dhabihu. Sikuja kuwaita watu wema, bali wenye dhambi.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kisha wanafunzi wa Yohane mbatizaji walimwendea Yesu, wakamwuliza, “Sisi na Mafarisayo hufunga mara nyingi; mbona wanafunzi wako hawafungi?” ");
INSERT INTO swh1850_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akawajibu, “Je, walioalikwa arusini wanaweza kuomboleza wakati bwana arusi yupo pamoja nao? La hasha! Lakini wakati utafika ambapo bwana arusi ataondolewa kati yao; wakati huo ndipo watakapofunga. ");
INSERT INTO swh1850_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Hakuna mtu atiaye kiraka cha nguo mpya katika vazi kuukuu. Maana kiraka hicho kitararua hilo vazi kuukuu, na pale palipokuwa pameraruka pataongezeka. ");
INSERT INTO swh1850_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wala hakuna mtu awekaye divai mpya katika viriba vikuukuu. Akifanya hivyo, viriba hupasuka na divai ikamwagika, navyo viriba vikaharibika. Ila divai mpya hutiwa katika viriba vipya, na vyote viwili, viriba na divai, vikahifadhiwa salama.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu alipokuwa akisema hayo, ofisa mmoja Myahudi alifika, akamwinamia na kusema, “Binti yangu amekufa sasa hivi. Lakini, tafadhali njoo umwekee mkono wako naye ataishi.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu akaondoka pamoja na wanafunzi wake, akamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mama mmoja, mgonjwa wa kutokwa damu kwa muda wa miaka kumi na miwili, alimfuata Yesu nyuma, akagusa pindo la vazi lake. ");
INSERT INTO swh1850_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Alifanya hivyo kwani alifikiri moyoni: “Nikigusa tu vazi lake, nitapona.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Basi, Yesu akageuka akamwona, akamwambia, “Binti, jipe moyo! Imani yako imekuponya.” Mama huyo akapona saa ileile. ");
INSERT INTO swh1850_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kisha Yesu akaingia nyumbani kwa yule ofisa. Na alipowaona wapiga filimbi na umati wa watu wanaofanya matanga, ");
INSERT INTO swh1850_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","akasema, “Ondokeni hapa! Msichana huyu hakufa, amelala tu.” Nao wakamcheka. ");
INSERT INTO swh1850_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Basi, umati wa watu ulipoondolewa, Yesu aliingia ndani, akamshika huyo msichana mkono, naye akasimama. ");
INSERT INTO swh1850_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Habari hiyo ikavuma sana katika nchi ile yote. ");
INSERT INTO swh1850_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu aliondoka hapo, na alipokuwa anakwenda, vipofu wawili walimfuata wakipiga kelele, “Mwana wa Daudi, utuhurumie!” ");
INSERT INTO swh1850_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu alipoingia nyumbani, vipofu hao wawili wakamwendea, naye akawauliza, “Je, mnaamini kwamba naweza kuwafanyia jambo hilo?” Nao wakamjibu, “Naam, Mheshimiwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hapo Yesu akayagusa macho yao, akasema, “Na iwe kwenu kama mnavyoamini.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Macho yao yakafunguliwa. Naye Yesu akawaonya kwa ukali: “Msimwambie mtu yeyote jambo hili.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini wao wakaondoka, wakaeneza habari za Yesu katika nchi ile yote. ");
INSERT INTO swh1850_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Watu walipokuwa wanakwenda zao, wengine walimletea Yesu mtu mmoja aliyekuwa bubu kwa sababu alikuwa amepagawa na pepo. ");
INSERT INTO swh1850_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mara tu huyo pepo alipotolewa, mtu huyo aliyekuwa bubu akaanza kuongea tena. Watu wakashangaa na kusema, “Jambo kama hili halijapata kuonekana katika Israeli!” ");
INSERT INTO swh1850_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Mafarisayo wakawa wanasema, “Anawatoa pepo kwa nguvu ya mkuu wa pepo wabaya.” ");
INSERT INTO swh1850_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu alitembelea miji yote na vijiji, akafundisha katika masunagogi yao akihubiri Habari Njema ya Ufalme wa Mungu, na kuponya magonjwa yote na udhaifu wa kila namna. ");
INSERT INTO swh1850_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Basi, alipowaona watu, makundi kwa makundi, aliwaonea huruma kwa sababu walikuwa hoi na wenye wasiwasi kama kondoo wasio na mchungaji. ");
INSERT INTO swh1850_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hapo akawaambia wanafunzi wake, “Mavuno ni mengi, lakini wavunaji ni wachache. ");
INSERT INTO swh1850_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kwa hivyo mwombeni mwenye shamba atume wavunaji shambani mwake.” ");
INSERT INTO swh1850_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu aliwaita wanafunzi wake kumi na wawili, akawapa uwezo wa kutoa pepo wachafu na kuponya magonjwa na maradhi yote. ");
INSERT INTO swh1850_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Majina ya hao mitume kumi na wawili ni haya: wa kwanza ni Simoni aitwae Petro, na Andrea ndugu yake; Yakobo mwana wa Zebedayo, na Yohane ndugu yake; ");
INSERT INTO swh1850_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Bartholomayo, Thoma na Mathayo aliyekuwa mtoza ushuru; Yakobo mwana wa Alfayo, na Thadayo; ");
INSERT INTO swh1850_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Mkanaani, na Yuda Iskarioti ambaye alimsaliti Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu aliwatuma hao kumi na wawili na kuwapa maagizo haya: “Msiende kwa watu wa mataifa mengine, wala msiingie katika mji wa Wasamaria. ");
INSERT INTO swh1850_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila nendeni kwa watu wa Israeli waliopotea kama kondoo. ");
INSERT INTO swh1850_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mnapokwenda hubirini hivi: Ufalme wa mbinguni umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ponyeni wagonjwa, fufueni wafu, takaseni wenye ukoma, toeni pepo. Mmepewa bure, toeni bure. ");
INSERT INTO swh1850_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Msichukue mifukoni mwenu dhahabu, wala fedha, wala sarafu za shaba. ");
INSERT INTO swh1850_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Msichukue mkoba wa kuombea njiani, wala koti la ziada, wala viatu, wala fimbo. Maana mfanyakazi anastahili riziki yake. ");
INSERT INTO swh1850_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mkiingia katika mji wowote au kijiji, tafuteni humo mtu yeyote aliye tayari kuwakaribisheni, na kaeni naye mpaka mtakapoondoka mahali hapo. ");
INSERT INTO swh1850_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mnapoingia nyumbani wasalimuni wenyeji wake. ");
INSERT INTO swh1850_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kama wenyeji wa nyumba hiyo wakiipokea salamu hiyo, basi, amani yenu itakaa pamoja nao. Lakini ikiwa hawaipokei, basi amani yenu itawarudia ninyi. ");
INSERT INTO swh1850_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kama mtu yeyote atakataa kuwakaribisheni au kuwasikilizeni, basi mtokapo katika nyumba hiyo au mji huo, yakung'uteni mavumbi miguuni mwenu kama onyo kwao. ");
INSERT INTO swh1850_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kweli nawaambieni, Siku ya hukumu mji huo utapata adhabu kubwa kuliko ile iliyoipata miji ya Sodoma na Gomora. ");
INSERT INTO swh1850_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Sasa, mimi nawatuma ninyi kama kondoo kati ya mbwa mwitu. Muwe na busara kama nyoka, na wapole kama njiwa. ");
INSERT INTO swh1850_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jihadharini na watu, maana watawapeleka ninyi mahakamani na kuwapiga viboko katika masunagogi yao. ");
INSERT INTO swh1850_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mtapelekwa mbele ya watawala na wafalme kwa sababu yangu, mpate kutangaza Habari Njema kwao na kwa mataifa. ");
INSERT INTO swh1850_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Basi, watakapowapeleka ninyi mahakamani, msiwe na wasiwasi mtasema nini au namna gani; wakati utakapofika, mtapewa la kusema. ");
INSERT INTO swh1850_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maana si ninyi mtakaosema, bali ni Roho wa Baba yenu asemaye ndani yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndugu atamsaliti ndugu yake auawe, na baba atamsaliti mwanawe, nao watoto watawashambulia wazazi wao na kuwaua. ");
INSERT INTO swh1850_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Watu wote watawachukieni kwa sababu ya jina langu. Lakini atakayevumilia mpaka mwisho, ataokolewa. ");
INSERT INTO swh1850_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Watu wakiwadhulumu katika mji mmoja, kimbilieni mji mwingine. Kweli nawaambieni, hamtamaliza ziara yenu katika miji yote ya Israeli kabla Mwana wa Mtu hajafika. ");
INSERT INTO swh1850_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanafunzi si mkuu kuliko mwalimu wake, wala mtumishi si mkuu kuliko bwana wake. ");
INSERT INTO swh1850_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yatosha mwanafunzi kuwa kama mwalimu wake, na mtumishi kuwa kama bwana wake. Ikiwa wamemwita mkubwa wa jamaa Beelzebuli, je hawatawaita watu wengine wa jamaa hiyo majina mabaya zaidi? ");
INSERT INTO swh1850_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Basi, msiwaogope watu hao. Kila kilichofunikwa kitafunuliwa, na kila kilichofichwa kitafichuliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ninalowaambieni ninyi katika giza, lisemeni katika mwanga; na jambo mlilosikia likinong'onezwa, litangazeni hadharani. ");
INSERT INTO swh1850_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Msiwaogope wale wauao mwili, lakini hawawezi kuiua roho. Afadhali zaidi kumwogopa yule awezaye kuuangamiza mwili pamoja na roho katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Shomoro wawili huuzwa kwa senti tano. Lakini hata mmoja wao haanguki chini bila kibali cha Baba yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakini kwa upande wenu, hata nywele za vichwa vyenu zimehesabiwa zote. ");
INSERT INTO swh1850_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kwa hiyo msiogope; ninyi mu wa thamani kuliko shomoro wengi. ");
INSERT INTO swh1850_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila mtu anayekiri hadharani kwamba yeye ni wangu, mimi pia nitamkiri mbele ya Baba yangu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini yeyote atakayenikana hadharani, nami nitamkana mbele ya Baba yangu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Msidhani kwamba nimekuja kuleta amani duniani. Sikuja kuleta amani bali upanga. ");
INSERT INTO swh1850_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Maana nimekuja kuleta mafarakano kati ya mtu na baba yake, kati ya binti na mama yake, kati ya mkwe na mkwe wake. ");
INSERT INTO swh1850_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na maadui wa mtu ni watu wa nyumbani mwake. ");
INSERT INTO swh1850_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ampendaye baba au mama yake kuliko anipendavyo mimi, hanistahili. Ampendaye mwana au binti kuliko mimi, hanistahili. ");
INSERT INTO swh1850_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mtu asiyechukua msalaba wake na kunifuata, hanistahili. ");
INSERT INTO swh1850_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Anayeyashikilia maisha yake, atayapoteza; lakini anayeyapoteza maisha yake kwa ajili yangu, atayapata. ");
INSERT INTO swh1850_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Anayewakaribisha ninyi, ananikaribisha mimi; na anayenikaribisha mimi, anamkaribisha yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Anayemkaribisha nabii kwa sababu ni nabii, atapokea tuzo la nabii. Anayemkaribisha mtu mwema kwa sababu ni mtu mwema, atapokea tuzo la mtu mwema. ");
INSERT INTO swh1850_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kweli nawaambieni, yeyote atakayempa mmojawapo wa wadogo hawa kikombe cha maji baridi kwa sababu ni mfuasi wangu, hatakosa kamwe kupata tuzo lake.” ");
INSERT INTO swh1850_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu alipomaliza kuwapa wanafunzi kumi na wawili maagizo, alitoka hapo, akaenda kufundisha na kuhubiri katika miji yao. ");
INSERT INTO swh1850_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane mbatizaji akiwa gerezani alipata habari juu ya matendo ya Kristo. Basi, Yohane akawatuma wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wamwulize: “Je, wewe ni yule anayekuja, au tumngoje mwingine?” ");
INSERT INTO swh1850_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu akawajibu, “Nendeni mkamwambie Yohane mambo mnayoyasikia na kuyaona: ");
INSERT INTO swh1850_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","vipofu wanaona, viwete wanatembea, wenye ukoma wanatakaswa na viziwi wanasikia, wafu wanafufuliwa na maskini wanahubiriwa Habari Njema. ");
INSERT INTO swh1850_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Heri mtu yule asiyekuwa na mashaka nami.” ");
INSERT INTO swh1850_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Basi, hao wajumbe wa Yohane walipokuwa wanakwenda zao, Yesu alianza kuyaambia makundi ya watu habari za Yohane: “Mlikwenda kutazama nini kule jangwani? Je, mlitaka kuona mwanzi unaotikiswa na upepo? ");
INSERT INTO swh1850_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lakini mlikwenda kuona nini? Mlikwenda kumtazama mtu aliyevaa mavazi maridadi? Watu wanaovaa mavazi maridadi hukaa katika nyumba za wafalme. ");
INSERT INTO swh1850_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Basi, mlikwenda kuona nini? Nabii? Naam, hakika ni zaidi ya nabii. ");
INSERT INTO swh1850_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Huyu ndiye anayesemwa katika Maandiko Matakatifu: Tazama, hapa namtuma mjumbe wangu, asema Bwana, akutangulie na kukutayarishia njia yako. ");
INSERT INTO swh1850_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kweli nawaambieni, miongoni mwa watoto wote wa watu, hajatokea aliye mkuu kuliko Yohane mbatizaji. Hata hivyo, yule aliye mdogo kabisa katika Ufalme wa mbinguni, ni mkubwa kuliko yeye. ");
INSERT INTO swh1850_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tangu wakati wa Yohane mbatizaji mpaka leo hii, Ufalme wa mbinguni unashambuliwa vikali, na watu wakali wanajaribu kuunyakua kwa nguvu. ");
INSERT INTO swh1850_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mafundisho yote ya manabii na sheria yalibashiri juu ya nyakati hizi. ");
INSERT INTO swh1850_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kama mwaweza kukubali basi, Yohane ndiye Eliya ambaye angekuja. ");
INSERT INTO swh1850_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mwenye masikio na asikie! ");
INSERT INTO swh1850_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Basi, nitakifananisha kizazi hiki na kitu gani? Ni kama vijana waliokuwa wamekaa uwanjani, wakawa wakiambiana kikundi kimoja kwa kingine: ");
INSERT INTO swh1850_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tumewapigieni ngoma lakini hamkucheza; tumeimba nyimbo za huzuni lakini hamkulia! ");
INSERT INTO swh1850_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwa maana Yohane alikuja, akafunga na wala hakunywa divai, nao wakasema: Amepagawa na pepo. ");
INSERT INTO swh1850_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Mtu akaja, anakula na kunywa, nao wakasema: Mtazameni huyu, mlafi na mlevi, rafiki yao watoza ushuru na wahalifu! Hata hivyo, hekima ya Mungu inathibitishwa kuwa njema kutokana na matendo yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kisha Yesu akaanza kuilaumu miji ambayo, ingawaje alifanya miujiza mingi humo, watu wake hawakutaka kubadili nia zao mbaya: ");
INSERT INTO swh1850_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ole wako Korazini! Ole wako Bethsaida! Maana, kama miujiza iliyofanyika kwako ingalifanyika kule Tiro na Sidoni, watu wake wangalikwisha vaa mavazi ya gunia na kujipaka majivu zamani, ili kuonyesha kwamba wametubu. ");
INSERT INTO swh1850_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hata hivyo nawaambieni, Siku ya hukumu, ninyi mtapata adhabu kubwa kuliko Tiro na Sidoni. ");
INSERT INTO swh1850_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na wewe Kafarnaumu, je, utajikweza mpaka mbinguni? Utaporomoshwa mpaka Kuzimu! Maana, kama miujiza iliyofanyika kwako ingalifanyika kule Sodoma, mji huo ungalikuwako mpaka hivi leo. ");
INSERT INTO swh1850_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakini nawaambieni, Siku ya hukumu itakuwa nafuu zaidi kwa watu wa Sodoma, kuliko kwako wewe.” ");
INSERT INTO swh1850_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wakati huo Yesu alisema, “Nakushukuru ee Baba, Bwana wa mbingu na dunia, maana umewaficha wenye hekima mambo haya, ukawafumbulia watoto wadogo. ");
INSERT INTO swh1850_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Naam Baba, ndivyo ilivyokupendeza. ");
INSERT INTO swh1850_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Baba yangu amenikabidhi vitu vyote. Hakuna amjuaye Mwana ila Baba, wala amjuaye Baba ila Mwana, na yeyote yule ambaye Mwana atapenda kumjulisha. ");
INSERT INTO swh1850_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Njoni kwangu ninyi nyote msumbukao na kulemewa na mizigo, nami nitawapumzisha. ");
INSERT INTO swh1850_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jifungeni nira yangu, mkajifunze kwangu, maana mimi ni mpole na mnyenyekevu wa moyo, nanyi mtatulizwa rohoni mwenu. ");
INSERT INTO swh1850_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maana, nira niwapayo mimi ni laini, na mzigo wangu ni mwepesi.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakati huo, Yesu alikuwa anapita katika mashamba ya ngano siku ya Sabato. Basi, wanafunzi wake wakaona njaa, wakaanza kukwanyua masuke ya ngano, wakala punje zake. ");
INSERT INTO swh1850_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafarisayo walipoona hayo, wakamwambia Yesu, “Tazama, wanafunzi wako wanafanya jambo ambalo si halali siku ya Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu akawajibu, “Je, hamjasoma alivyofanya Daudi pamoja na wenzake wakati walipokuwa na njaa? ");
INSERT INTO swh1850_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yeye aliingia katika Nyumba ya Mungu pamoja na wenzake, wakala ile mikate iliyowekwa mbele ya Mungu. Yeye wala hao wenzake hawakuruhusiwa kula mikate hiyo isipokuwa tu makuhani peke yao. ");
INSERT INTO swh1850_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Au je, hamjasoma katika Sheria kwamba kila siku ya Sabato makuhani huivunja Sheria Hekaluni, lakini hawafikiriwi kuwa na hatia? ");
INSERT INTO swh1850_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Basi, nawaambieni kwamba hapa pana kikuu kuliko Hekalu. ");
INSERT INTO swh1850_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kama tu mngejua maana ya maneno haya: Nataka huruma wala si dhabihu, hamngewahukumu watu wasio na hatia. ");
INSERT INTO swh1850_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maana Mwana wa Mtu ni Bwana wa Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu alitoka hapo, akaenda katika sunagogi lao. ");
INSERT INTO swh1850_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kulikuwa na mtu mmoja mwenye mkono uliopooza. Basi, watu wakamwuliza Yesu, “Je, ni halali kumponya mtu siku ya Sabato?” Walimwuliza hivyo wapate kisa cha kumshtaki. ");
INSERT INTO swh1850_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lakini Yesu akawaambia, “Tuseme mmoja wenu ana kondoo wake ambaye ametumbukia shimoni; je, hatamshika na kumtoa humo siku ya Sabato? ");
INSERT INTO swh1850_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mtu ana thamani kuliko kondoo! Basi, ni halali kutenda mema siku ya Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kisha akamwambia yule mtu, “Nyosha mkono wako.” Akaunyosha, nao ukawa mzima kabisa kama ule mwingine. ");
INSERT INTO swh1850_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Basi, Mafarisayo wakatoka nje, wakashauriana jinsi watakavyomwangamiza Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lakini Yesu alipojua jambo hilo, akatoka mahali pale. Watu wengi walimfuata, akawaponya wagonjwa wote, ");
INSERT INTO swh1850_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","akawaamuru wasiwaambie watu habari zake, ");
INSERT INTO swh1850_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ili yale aliyosema nabii Isaya yatimie: ");
INSERT INTO swh1850_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hapa ni mtumishi wangu niliyemteua, mpendwa wangu anipendezaye moyoni. Nitaiweka Roho yangu juu yake, naye atatangaza hukumu yangu kwa mataifa yote. ");
INSERT INTO swh1850_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hatakuwa na ubishi wala kupiga kelele, wala sauti yake haitasikika barabarani. ");
INSERT INTO swh1850_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mwanzi uliopondeka hatauvunja, wala utambi ufukao moshi hatauzima, mpaka atakapoifanya hukumu ya haki itawale. ");
INSERT INTO swh1850_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Katika jina lake mataifa yatakuwa na tumaini.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hapo watu wakamletea Yesu kipofu mmoja ambaye alikuwa bubu kwa sababu alikuwa amepagawa na pepo. Yesu akamponya hata, akaweza kusema na kuona. ");
INSERT INTO swh1850_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Umati wote wa watu ulishangaa ukasema, “Je, huenda ikawa huyu ndiye Mwana wa Daudi?” ");
INSERT INTO swh1850_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini Mafarisayo waliposikia hayo, wakasema, “Mtu huyu anawafukuza pepo kwa uwezo wa Beelzebuli, mkuu wa pepo.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu, akiwa anayajua mawazo yao, akawaambia, “Ufalme wowote uliogawanyika makundimakundi yanayopingana, hauwezi kudumu, na mji wowote au jamaa yoyote iliyogawanyika makundimakundi yanayopingana, itaanguka. ");
INSERT INTO swh1850_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikiwa Shetani anamfukuza Shetani, anajipinga mwenyewe. Basi, ufalme wake utasimamaje? ");
INSERT INTO swh1850_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ninyi mnasema ati nawafukuza pepo kwa uwezo wa Beelzebuli; je, watoto wenu huwafukuza kwa uwezo wa nani? Kwa sababu hiyo wao ndio watakaowahukumu ninyi. ");
INSERT INTO swh1850_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakini ikiwa ninawafukuza pepo kwa nguvu ya Roho wa Mungu, basi jueni kwamba Ufalme wa Mungu umekwisha fika kwenu. ");
INSERT INTO swh1850_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Au, anawezaje mtu kuivamia nyumba ya mtu mwenye nguvu na kumnyang'anya mali yake, bila kwanza kumfunga huyo mtu mwenye nguvu? Hapo ndipo atakapoweza kumnyang'anya mali yake. ");
INSERT INTO swh1850_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yeyote asiyejiunga nami, anapingana nami; na yeyote asiyekusanya pamoja nami, hutawanya. ");
INSERT INTO swh1850_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa sababu hiyo, nawaambieni, watu watasamehewa dhambi na kufuru zao zote, lakini hawatasamehewa dhambi ya kumkufuru Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tena, asemaye neno la kumpinga Mwana wa Mtu atasamehewa, lakini yule asemaye neno la kumpinga Roho Mtakatifu, hatasamehewa, wala katika ulimwengu huu, wala katika ulimwengu ujao. ");
INSERT INTO swh1850_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ufanyeni mti kuwa mzuri na matunda yake yatakuwa mema; ufanyeni kuwa mbaya na matunda yake yatakuwa mabaya. Mti hujulikana kwa matunda yake. ");
INSERT INTO swh1850_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Enyi kizazi cha nyoka! Mnawezaje kusema mambo mema hali ninyi ni waovu? Maana mtu husema kutokana na yale yaliyojaa moyoni. ");
INSERT INTO swh1850_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mtu mwema hutoa mambo mema katika hazina yake njema; na mtu mbaya hutoa mambo mabaya katika hazina yake mbaya. ");
INSERT INTO swh1850_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Basi, nawaambieni, Siku ya hukumu watu watapaswa kujibu juu ya kila neno lisilofaa wanalosema. ");
INSERT INTO swh1850_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maana kwa maneno yako, utakubaliwa kuwa mwadilifu, na kwa maneno yako, utahukumiwa kuwa na hatia.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kisha baadhi ya walimu wa Sheria na Mafarisayo wakamwambia Yesu, “Mwalimu, tunataka kuona ishara kutoka kwako.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naye akawajibu, “Kizazi kiovu kisicho na uaminifu! Mnataka ishara; hamtapewa ishara nyingine, ila tu ile ishara ya nabii Yona. ");
INSERT INTO swh1850_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jinsi Yona alivyokaa siku tatu kutwa kucha tumboni mwa nyangumi, ndivyo naye Mwana wa Mtu atakavyokaa ndani ya ardhi siku tatu kutwa kucha. ");
INSERT INTO swh1850_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Watu wa Ninewi watatokea siku ya hukumu, nao watakihukumu kizazi hiki kwamba kina hatia. Maana Waninewi walitubu kwa sababu ya mahubiri ya Yona, na kumbe hapa kuna kikuu kuliko Yona! ");
INSERT INTO swh1850_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Malkia wa kusini atatokea wakati kizazi hiki kitakapohukumiwa, naye atakihukumu kwamba kina hatia. Maana yeye alisafiri kutoka mbali akaja kusikiliza maneno ya hekima ya Solomoni, na kumbe hapa kuna kikuu kuliko Solomoni. ");
INSERT INTO swh1850_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pepo mchafu akifukuzwa kwa mtu, huzururazurura jangwani akitafuta mahali pa kupumzika asipate. ");
INSERT INTO swh1850_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hapo hujisemea: Nitarudi nyumbani kwangu nilikotoka. Lakini anaporudi na kuikuta tupu, imefagiwa na kupambwa, ");
INSERT INTO swh1850_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","huenda kuwachukua pepo wengine saba, wabaya kuliko yeye; na wote huja wakamwingia huyo mtu. Na hali ya mtu huyo sasa huwa mbaya kuliko hapo mwanzo. Ndivyo itakavyokuwa kwa watu hawa waovu.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu alikuwa bado anasema na umati wa watu wakati mama yake na ndugu zake walipofika na kusimama nje, wakitaka kusema naye. ");
INSERT INTO swh1850_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Basi, mtu mmoja akamwambia, “Mama yako na ndugu zako wako nje, wanataka kusema nawe.” ");
INSERT INTO swh1850_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu akamjibu mtu huyo, “Mama yangu ni nani? Na ndugu zangu ni kina nani?” ");
INSERT INTO swh1850_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kisha akaunyosha mkono wake kuelekea wanafunzi wake, akasema, “Hawa ndio mama yangu na ndugu zangu! ");
INSERT INTO swh1850_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maana yeyote anayefanya anavyotaka Baba yangu aliye mbinguni, huyo ndiye ndugu yangu, dada yangu na mama yangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Siku hiyohiyo, Yesu alitoka katika ile nyumba, akaenda na kuketi kando ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Makundi makubwa ya watu yalimzunguka hata Yesu akapanda mashua, akaketi. Hao watu walisimama kwenye ukingo wa ziwa, ");
INSERT INTO swh1850_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","naye Yesu akawaambia mambo mengi kwa mifano. “Sikilizeni! Mpanzi alikwenda kupanda mbegu. ");
INSERT INTO swh1850_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Alipokuwa akipanda, nyingine zilianguka njiani, ndege wakaja wakazila. ");
INSERT INTO swh1850_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nyingine zilianguka penye mawe pasipokuwa na udongo mwingi. Zikaota mara kwa kuwa udongo haukuwa na kina. ");
INSERT INTO swh1850_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jua lilipochomoza, zilichomeka; na kwa kuwa mizizi yake haikuwa na nguvu, zikanyauka. ");
INSERT INTO swh1850_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nyingine zilianguka kwenye miti ya miiba, nayo ikakua na kuzisonga. ");
INSERT INTO swh1850_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lakini nyingine zilianguka penye udongo mzuri, zikaota, zikazaa: nyingine punje mia moja, nyingine sitini na nyingine thelathini. ");
INSERT INTO swh1850_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mwenye masikio na asikie!” ");
INSERT INTO swh1850_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wanafunzi wake wakamwendea, wakamwuliza, “Kwa nini unasema na watu kwa mifano?” ");
INSERT INTO swh1850_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akawajibu, “Ninyi mmejaliwa kuzijua siri za Ufalme wa mbinguni, lakini wao hawakujaliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maana, aliye na kitu atapewa na kuzidishiwa; lakini yule asiye na kitu, hata kile alicho nacho kitachukuliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndiyo maana ninasema nao kwa mifano, kwa sababu wanatazama lakini hawaoni, wanasikiliza lakini hawasikii, wala hawaelewi. ");
INSERT INTO swh1850_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwao yametimia yale aliyosema nabii Isaya: Kusikia mtasikia, lakini hamtaelewa; Kutazama mtatazama, lakini hamtaona. ");
INSERT INTO swh1850_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maana akili za watu hawa zimepumbaa, wameyaziba masikio yao, wameyafumba macho yao. La sivyo, wangeona kwa macho yao. wangesikia kwa masikio yao, wangeelewa kwa akili zao, na kunigeukia, asema Bwana, nami ningewaponya. ");
INSERT INTO swh1850_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lakini heri yenu ninyi, maana macho yenu yanaona na masikio yenu yanasikia. ");
INSERT INTO swh1850_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kweli nawaambieni, manabii na watu wengi wema walitamani kuyaona yale mnayoyaona, wasiyaone, na kuyasikia yale mnayoyasikia, wasiyasikie. ");
INSERT INTO swh1850_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Basi, ninyi sikilizeni maana ya mfano huo wa mpanzi. ");
INSERT INTO swh1850_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yeyote asikiaye ujumbe wa ufalme bila kuuelewa, ni kama zile mbegu zilizoanguka njiani; yule Mwovu huja na kunyakua kile kilichopandwa moyoni mwake. ");
INSERT INTO swh1850_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ile mbegu iliyopandwa penye mawe ni mfano wa mtu asikiaye ujumbe huo na mara akaupokea kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lakini haumwingii na kuwa na mizizi ndani yake; huendelea kuuzingatia ujumbe huo kwa kitambo tu, na wakati taabu au udhalimu vinapotokea kwa sababu ya ujumbe huo, anakata tamaa mara. ");
INSERT INTO swh1850_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ile mbegu iliyoanguka kati ya miti ya miiba, ni mfano wa mtu asikiaye huo ujumbe, lakini wasiwasi wa ulimwengu huu na anasa za mali huusonga ujumbe huo, naye hazai matunda. ");
INSERT INTO swh1850_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ile mbegu iliyopandwa katika udongo mzuri ni mfano wa mtu ausikiaye ujumbe huo na kuuelewa, naye huzaa matunda; mmoja mia, mwingine sitini na mwingine thelathini.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu akawaambia watu mfano mwingine: “Ufalme wa mbinguni unafanana na mtu aliyepanda mbegu nzuri katika shamba lake. ");
INSERT INTO swh1850_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lakini watu wakiwa wamelala, adui yake akaja akapanda magugu kati ya ngano, akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Basi, mimea ilipoota na kuanza kuchanua, magugu pia yakaanza kuonekana. ");
INSERT INTO swh1850_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Watumishi wa yule mwenye shamba wakamwendea, wakamwambia, Mheshimiwa, bila shaka ulipanda mbegu nzuri katika shamba lako. Sasa magugu yametoka wapi? ");
INSERT INTO swh1850_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yeye akawajibu, Adui ndiye aliyefanya hivyo. Basi, watumishi wake wakamwuliza, Je, unataka twende tukayang'oe ");
INSERT INTO swh1850_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naye akawajibu, La, msije labda mnapokusanya magugu, mkang'oa na ngano pia. ");
INSERT INTO swh1850_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Acheni vikue pamoja mpaka wakati wa mavuno. Wakati huo nitawaambia wavunaji: kusanyeni kwanza magugu mkayafunge mafungumafungu ya kuchomwa. Lakini ngano ikusanyeni mkaiweke ghalani mwangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu akawaambia watu mfano mwingine: “Ufalme wa mbinguni unafanana na mbegu ya haradali aliyotwaa mtu mmoja, akaipanda katika shamba lake. ");
INSERT INTO swh1850_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yenyewe ni ndogo kuliko mbegu zote, lakini ikishaota huwa kubwa kuliko mimea yote. Hukua ikawa mti, na ndege wa angani huja na kujenga viota katika matawi yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu akawaambia mfano mwingine: “Ufalme wa mbinguni umefanana na chachu aliyotwaa mama mmoja, akaichanganya na unga pishi tatu, hata unga wote ukaumuka.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu aliwaambia watu hayo yote kwa mifano. Hakuwaambia chochote bila kutumia mifano, ");
INSERT INTO swh1850_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ili jambo lililonenwa na nabii litimie: “Nitasema kwa mifano; nitawaambia mambo yaliyofichika tangu kuumbwa ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kisha Yesu aliwaaga wale watu, akaingia nyumbani. Wanafunzi wake wakamwendea, wakamwambia, “Tufafanulie ule mfano wa magugu shambani.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu akawaambia, “Mpanzi wa zile mbegu nzuri ni Mwana wa Mtu. ");
INSERT INTO swh1850_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lile shamba ni ulimwengu. Zile mbegu nzuri ni watu wale ambao Ufalme ni wao. Lakini yale magugu ni wale watu wa yule Mwovu. ");
INSERT INTO swh1850_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Adui aliyepanda yale magugu ni Ibilisi. Mavuno ni mwisho wa nyakati na wavunaji ni malaika. ");
INSERT INTO swh1850_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kama vile magugu yanavyokusanywa kuchomwa moto, ndivyo itakavyokuwa mwishoni mwa nyakati; ");
INSERT INTO swh1850_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Mtu atawatuma malaika wake wawakusanye kutoka katika Ufalme wake wale wote wenye kusababisha dhambi, na wote wenye kutenda maovu, ");
INSERT INTO swh1850_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuwatupa katika tanuru ya moto, na huko watalia na kusaga meno. ");
INSERT INTO swh1850_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kisha, wale wema watang'ara kama jua katika Ufalme wa Baba yao. Sikieni basi, kama mna masikio! ");
INSERT INTO swh1850_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ufalme wa mbinguni umefanana na hazina iliyofichika shambani. Mtu mmoja aliigundua, akaificha tena. Alifurahi sana hata akaenda kuuza yote aliyokuwa nayo, akalinunua shamba lile. ");
INSERT INTO swh1850_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Tena, Ufalme wa mbinguni umefanana na mfanyabiashara mmoja mwenye kutafuta lulu nzuri. ");
INSERT INTO swh1850_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Alipopata lulu moja ya thamani kubwa, alienda akauza yote aliyokuwa nayo, akainunua lulu ile. ");
INSERT INTO swh1850_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tena, Ufalme wa mbinguni unafanana na wavu uliotupwa baharini, ukanasa samaki wa kila aina. ");
INSERT INTO swh1850_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ulipojaa, watu waliuvuta pwani, wakaketi, wakachagua samaki wazuri wakawaweka ndani ya vikapu vyao, na wabaya wakawatupa. ");
INSERT INTO swh1850_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ndivyo itakavyokuwa mwishoni mwa nyakati: malaika watatokea, watawatenganisha watu wabaya na watu wema, ");
INSERT INTO swh1850_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuwatupa hao wabaya katika tanuru ya moto. Huko watalia na kusaga meno.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu akawauliza, “Je, mmeelewa mambo haya yote?” Wakamjibu, “Naam.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naye akawaambia, “Hivyo basi, kila mwalimu wa Sheria aliye mwanafunzi wa Ufalme wa mbinguni anafanana na mwenye nyumba atoaye katika hazina yake vitu vipya na vya kale.” ");
INSERT INTO swh1850_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu alipomaliza kusema mifano hiyo alitoka mahali hapo, ");
INSERT INTO swh1850_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akaenda kijijini kwake. Huko akawa anawafundisha watu katika sunagogi hata wakashangaa, wakasema, “Huyu amepata wapi hekima hii na maajabu? ");
INSERT INTO swh1850_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Je, huyu si yule mwana wa seremala? Je, mama yake si anaitwa Maria, na ndugu zake si kina Yakobo, Yosefu, Simoni na Yuda? ");
INSERT INTO swh1850_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na dada zake je, si wote wako hapa pamoja nasi? Basi amepata wapi haya yote?” ");
INSERT INTO swh1850_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Basi, wakawa na mashaka naye. Lakini Yesu akawaambia, “Nabii hakosi kuheshimiwa, isipokuwa katika nchi yake na nyumbani mwake!” ");
INSERT INTO swh1850_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwa hiyo, hakutenda miujiza mingi pale kwa sababu ya kutoamini kwao. ");
INSERT INTO swh1850_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wakati huo, mtawala Herode alisikia sifa za Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Basi, akawaambia watumishi wake, “Mtu huyu ni Yohane mbatizaji, amefufuka kutoka wafu; ndiyo maana nguvu za miujiza zinafanya kazi ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herode ndiye aliyekuwa amemtia Yohane nguvuni, akamfunga minyororo na kumtia gerezani kwa sababu ya Herodia, mke wa Filipo, ndugu yake. Sababu hasa ni ");
INSERT INTO swh1850_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kwamba alikuwa amemwambia Herode, “Si halali kwako kuishi na huyo mwanamke!” ");
INSERT INTO swh1850_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herode alitaka kumwua Yohane, lakini aliogopa watu kwa sababu kwao Yohane alikuwa nabii. ");
INSERT INTO swh1850_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Katika sherehe za sikukuu ya kuzaliwa kwake Herode, binti ya Herodia alicheza mbele ya wageni. Herode alifurahiwa, ");
INSERT INTO swh1850_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hata akaahidi kwa kiapo kumpa huyo msichana chochote atakachoomba. ");
INSERT INTO swh1850_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naye, huku akichochewa na mama yake, akaomba, “Nipe papahapa katika sinia kichwa cha Yohane mbatizaji.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mfalme alihuzunika, lakini kwa sababu ya kile kiapo chake na kwa sababu ya wale wageni karamuni, akaamuru apewe. ");
INSERT INTO swh1850_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Basi, Herode akatuma mtu gerezani amkate kichwa Yohane. ");
INSERT INTO swh1850_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kichwa chake kikaletwa katika sinia, wakampa yule msichana, naye akampelekea mama yake. ");
INSERT INTO swh1850_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanafunzi wa Yohane wakaja, wakauchukua mwili wake, wakauzika. Kisha wakaenda kumpasha habari Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu alipopata habari hiyo, aliondoka mahali pale kwa mashua, akaenda mahali pa faragha peke yake. Lakini watu walipata habari, wakamfuata kwa miguu toka mijini. ");
INSERT INTO swh1850_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Basi, aliposhuka pwani, aliona umati mkubwa wa watu, akawaonea huruma, akawaponya wagonjwa wao. ");
INSERT INTO swh1850_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kulipokuwa jioni, wanafunzi wake walimwendea wakamwambia, “Mahali hapa ni nyikani, na saa zimepita. Basi, uwaage watu ili waende vijijini wakajinunulie chakula.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu akawaambia, “Si lazima waende, wapeni ninyi chakula.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lakini wao wakamwambia, “Tunayo mikate mitano tu na samaki wawili.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu akawaambia, “Nileteeni hapa.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akawaamuru watu waketi katika nyasi. Kisha akaitwaa ile mikate mitano na wale samaki wawili, akatazama juu mbinguni, akamshukuru Mungu. Halafu akaimega hiyo mikate, akawapa wanafunzi wake, nao wakawapa watu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Watu wote wakala, wakashiba. Kisha wanafunzi wakakusanya mabaki, wakajaza vikapu kumi na viwili. ");
INSERT INTO swh1850_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jumla ya waliokula ilikuwa wanaume wapatao elfu tano, bila kuhesabu wanawake na watoto. ");
INSERT INTO swh1850_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mara, Yesu akawaamuru wanafunzi wake wapande mashua, wamtangulie ng'ambo ya ziwa wakati yeye anawaaga watu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baada ya kuwaaga, alipanda mlimani peke yake kusali. Ilipokuwa jioni, yeye alikuwa huko peke yake, ");
INSERT INTO swh1850_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na wakati huo ile mashua ilikwishafika karibu katikati ya ziwa, lakini ilikuwa inakwenda mrama kwa sababu upepo ulikuwa unaipinga. ");
INSERT INTO swh1850_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Usiku, karibu na mapambazuko, Yesu aliwaendea wanafunzi akitembea juu ya maji. ");
INSERT INTO swh1850_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanafunzi wake walipomwona akitembea juu ya maji waliingiwa na hofu, wakasema, “Ni mzimu!” Wakapiga kelele kwa hofu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mara, Yesu akasema nao, “Tulieni, ni mimi. Msiogope!” ");
INSERT INTO swh1850_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petro akamwambia, “Bwana, ikiwa ni wewe kweli, amuru nitembee juu ya maji nije kwako.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akasema, “Haya, njoo.” Basi, Petro akashuka kutoka ile mashua, akatembea juu ya maji, akamwendea Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini alipouona ule upepo, aliogopa, akaanza kuzama; akalia kwa sauti, “Bwana, niokoe!” ");
INSERT INTO swh1850_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hapo, Yesu akaunyosha mkono wake, akamshika na kumwambia, “Ewe mwenye imani haba! Kwa nini uliona shaka?” ");
INSERT INTO swh1850_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Basi, wakapanda mashuani, na upepo ukatulia. ");
INSERT INTO swh1850_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wote waliokuwa ndani ya mashua walimsujudia, wakasema, “Hakika wewe ni Mwana wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Walivuka ziwa, wakafika nchi ya Genesareti. ");
INSERT INTO swh1850_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Watu wa huko walipomtambua, wakaeneza habari pote katika sehemu hizo. Basi, wakamletea Yesu wagonjwa wote, ");
INSERT INTO swh1850_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","wakamwomba awaruhusu waguse tu pindo la vazi lake; wote waliomgusa walipona. ");
INSERT INTO swh1850_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kisha Mafarisayo na walimu wa Sheria wakafika kutoka Yerusalemu, wakamwendea Yesu, wakamwuliza, ");
INSERT INTO swh1850_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwa nini wanafunzi wako hawajali mapokeo tuliyopokea kutoka kwa wazee wetu? Hawanawi mikono yao kama ipasavyo kabla ya kula!” ");
INSERT INTO swh1850_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akawajibu, “Kwa nini nanyi mnapendelea mapokeo yenu wenyewe na hamuijali Sheria ya Mungu? ");
INSERT INTO swh1850_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mungu amesema: Waheshimu baba yako na mama yako, na Anayemkashifu baba yake au mama yake, lazima auawe. ");
INSERT INTO swh1850_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini ninyi mwafundisha ati mtu akiwa na kitu ambacho angeweza kuwasaidia nacho baba au mama yake, lakini akasema: Kitu hiki nimemtolea Mungu, ");
INSERT INTO swh1850_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","basi, hapaswi tena kumheshimu baba yake! Ndivyo mnavyodharau neno la Mungu kwa kufuata mafundisho yenu wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enyi wanafiki! Isaya alitabiri sawa kabisa juu yenu: ");
INSERT INTO swh1850_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Watu hawa, asema Mungu, huniheshimu kwa maneno tu, lakini mioyoni mwao wako mbali nami. ");
INSERT INTO swh1850_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kuniabudu kwao hakufai, maana mambo wanayofundisha ni maagizo ya kibinadamu tu.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu aliuita ule umati wa watu, akawaambia, “Sikilizeni na muelewe! ");
INSERT INTO swh1850_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kitu kinachomtia mtu najisi si kile kiingiacho kinywani, bali kile kitokacho kinywani. Hicho ndicho kimtiacho mtu najisi.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kisha wanafunzi wakamwendea, wakamwambia, “Je, unajua kwamba Mafarisayo walichukizwa waliposikia maneno yako?” ");
INSERT INTO swh1850_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lakini yeye akawajibu, “Kila mmea ambao Baba yangu aliye mbinguni hakuupanda, utang'olewa. ");
INSERT INTO swh1850_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waacheni wenyewe! Wao ni vipofu, viongozi wa vipofu; na kipofu akimwongoza kipofu, wote wawili hutumbukia shimoni.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro akadakia, “Tufafanulie huo mfano.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu akasema, “Hata nyinyi hamwelewi? ");
INSERT INTO swh1850_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Je, hamwelewi kwamba kila kinachoingia kinywani huenda tumboni na baadaye hutupwa nje chooni? ");
INSERT INTO swh1850_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini yale yatokayo kinywani hutoka moyoni, na hayo ndiyo yanayomtia mtu najisi. ");
INSERT INTO swh1850_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maana moyoni hutoka mawazo maovu yanayosababisha uuaji, uzinzi, uasherati, wizi, ushahidi wa uongo na kashfa. ");
INSERT INTO swh1850_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hayo ndiyo yanayomtia mtu najisi. Lakini kula chakula bila kunawa mikono hakumtii mtu najisi.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu aliondoka mahali hapo akaenda kukaa katika sehemu za Tiro na Sidoni. ");
INSERT INTO swh1850_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Basi, mama mmoja Mkaanani wa nchi hiyo alimjia, akapaaza sauti: “Mheshimiwa, Mwana wa Daudi, nionee huruma! Binti yangu anasumbuliwa na pepo.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu hakumjibu neno. Basi, wanafunzi wake wakamwendea, wakamwambia, “Mwambie aende zake kwa maana anatufuatafuata akipiga kelele.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akajibu, “Sikutumwa ila kwa watu wa Israeli waliopotea kama kondoo.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hapo huyo mama akaja, akapiga magoti mbele yake, akasema, “Mheshimiwa, nisaidie.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu akamjibu, “Si sawa kuchukua chakula cha watoto na kuwatupia mbwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Huyo mama akajibu, “Ni kweli, Mheshimiwa; lakini hata mbwa hula makombo yanayoanguka kutoka meza ya bwana wao.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hapo Yesu akamjibu, “Mama, imani yako ni kubwa; basi, ufanyiwe kama unavyotaka.” Yule binti yake akapona tangu saa hiyo wakati huohuo. ");
INSERT INTO swh1850_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu alitoka hapo akaenda kando ya ziwa Galilaya, akapanda mlimani, akaketi. ");
INSERT INTO swh1850_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Watu wengi sana wakamjia wakiwaleta vilema, vipofu, viwete, bubu na wengine wengi waliokuwa wagonjwa, wakawaweka mbele ya miguu yake, naye Yesu akawaponya. ");
INSERT INTO swh1850_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Umati ule wa watu ulishangaa sana ulipoona bubu wakiongea, waliokuwa wamelemaa wamepona, viwete wakitembea na vipofu wakiona; wakamsifu Mungu wa Israeli. ");
INSERT INTO swh1850_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basi, Yesu aliwaita wanafunzi wake, akasema, “Nawaonea watu hawa huruma kwa sababu kwa siku tatu wamekuwa nami, wala hawana chakula. Sipendi kuwaacha waende bila kula wasije wakazimia njiani.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanafunzi wakamwambia, “Hapa tuko nyikani; tutapata wapi chakula cha kuwatosha watu wengi hivi?” ");
INSERT INTO swh1850_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu akawauliza, “Mnayo mikate mingapi?” Wakamjibu, “Saba na visamaki vichache.” ");
INSERT INTO swh1850_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Basi, Yesu akawaamuru watu wakae chini. ");
INSERT INTO swh1850_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akaitwaa ile mikate saba na vile visamaki, akamshukuru Mungu, akavimega, akawapa wanafunzi, nao wakawagawia watu. ");
INSERT INTO swh1850_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wote wakala, wakashiba. Kisha wakakusanya makombo, wakajaza vikapu saba. ");
INSERT INTO swh1850_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hao waliokula walikuwa wanaume elfu nne, bila kuhesabu wanawake na watoto. ");
INSERT INTO swh1850_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basi, Yesu akawaaga watu, akapanda mashua, akaenda katika eneo la Magadani. ");
INSERT INTO swh1850_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisayo na Masadukayo walimwendea Yesu, na kwa kumjaribu, wakamwomba afanye ishara itokayo mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu akawajibu, “Wakati wa jioni ukifika ninyi husema: Hali ya hewa itakuwa nzuri kwa maana anga ni jekundu! ");
INSERT INTO swh1850_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na alfajiri mwasema: Leo hali ya hewa itakuwa ya dhoruba, maana anga ni jekundu na tena mawingu yametanda! Basi, ninyi mnajua sana kusoma majira kwa kuangalia anga, lakini kutambua dalili za nyakati hizi hamjui. ");
INSERT INTO swh1850_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kizazi kiovu kisicho na uaminifu! Mnataka ishara, lakini hamtapewa ishara yoyote isipokuwa tu ile ya Yona.” Basi, akawaacha, akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanafunzi wake walipokwisha vukia upande wa pili wa ziwa, walijikuta wamesahau kuchukua mikate. ");
INSERT INTO swh1850_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu akawaambia, “Muwe macho na mjihadhari na chachu ya Mafarisayo na Masadukayo!” ");
INSERT INTO swh1850_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lakini wao wakawa wanajadiliana: “Anasema hivyo kwa kuwa hatukuchukua mikate.” ");
INSERT INTO swh1850_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu alijua mawazo yao, akawaambia, “Enyi watu wenye imani haba! Mbona mnajadiliana juu ya kutokuwa na mikate? ");
INSERT INTO swh1850_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Je, hamjaelewa bado? Je, hamkumbuki nilipoimega ile mikate mitano kwa ajili ya wale watu elfu tano? Je, mlijaza vikapu vingapi vya makombo? ");
INSERT INTO swh1850_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Au, ile mikate saba waliyogawiwa wale watu elfu nne, je, mlikusanya vikapu vingapi vya mabaki? ");
INSERT INTO swh1850_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Inawezekanaje hamwelewi ya kwamba sikuwa nikisema juu ya mikate? Jihadharini na chachu ya Mafarisayo na Masadukayo!” ");
INSERT INTO swh1850_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hapo wanafunzi wakafahamu kwamba aliwaambia wajihadhari siyo na chachu ya mikate, bali na mafundisho ya Mafarisayo na Masadukayo. ");
INSERT INTO swh1850_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu alipofika pande za Kaisarea Filipi, aliwauliza wanafunzi wake, “Watu wanasema Mwana wa Mtu kuwa ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wakamjibu, “Wengine wanasema kuwa ni Yohane mbatizaji, wengine Eliya, wengine Yeremia au mmojawapo wa manabii.” ");
INSERT INTO swh1850_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu akawauliza, “Na ninyi je, mwasema mimi ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petro akajibu, “Wewe ndiwe Kristo, Mwana wa Mungu aliye hai.” ");
INSERT INTO swh1850_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akasema, “Heri wewe Simoni mwana wa Yona, kwa maana si binadamu aliyekufunulia ukweli huu, ila Baba yangu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nami nakwambia: wewe ni Petro, na juu ya mwamba huu nitalijenga kanisa langu; wala kifo chenyewe hakitaweza kulishinda. ");
INSERT INTO swh1850_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nitakupa funguo za Ufalme wa mbinguni; kila utakachofunga duniani, kitafungwa pia mbinguni; kila utakachofungua duniani, kitafunguliwa pia mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kisha akawaonya wanafunzi wasimwambie mtu yeyote kwamba yeye ndiye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tangu wakati huo Yesu alianza kuwajulisha waziwazi wanafunzi wake: “Ni lazima mimi niende Yerusalemu, na huko nikapate mateso mengi yatakayosababishwa na wazee, makuhani wakuu na walimu wa Sheria. Nitauawa, na siku ya tatu nitafufuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hapo Petro akamchukua kando, akaanza kumkemea: “Isiwe hivyo Bwana! Jambo hili halitakupata!” ");
INSERT INTO swh1850_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu akageuka, akamwambia Petro, “Ondoka mbele yangu Shetani! Wewe ni kikwazo kwangu. Mawazo yako si ya mungu bali ni ya kibinadamu!” ");
INSERT INTO swh1850_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kisha Yesu akawaambia wanafunzi wake, “Kama mtu yeyote anataka kuwa mfuasi wangu, ni lazima ajikane mwenyewe, auchukue msalaba wake, anifuate. ");
INSERT INTO swh1850_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maana, mtu anayetaka kuyaokoa maisha yake mwenyewe, atayapoteza; ");
INSERT INTO swh1850_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","lakini mtu anayeyapoteza maisha yake kwa ajili yangu, atayapata. Je, mtu atafaidi nini akiupata utajiri wote wa ulimwengu na hali amepoteza maisha yake? Au, mtu atatoa kitu gani kiwe badala ya maisha yake? ");
INSERT INTO swh1850_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maana, Mwana wa Mtu atakuja katika utukufu wa Baba yake pamoja na malaika wake, na hapo ndipo atakapomlipa kila mtu kadiri ya matendo yake. ");
INSERT INTO swh1850_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kweli nawaambieni, wako wengine papahapa ambao hawatakufa kabla ya kumwona Mwana wa Mtu akija katika Ufalme wake.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Baada ya siku sita, Yesu aliwachukua Petro, Yakobo na Yohane nduguye, akaenda nao peke yao juu ya mlima mrefu. ");
INSERT INTO swh1850_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huko, wakiwa wanamtazama, akageuka sura, uso wake ukang'aa kama jua na mavazi yake yakawa meupe kama nuru. ");
INSERT INTO swh1850_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mose na Eliya wakawatokea, wakawa wanazungumza naye. ");
INSERT INTO swh1850_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hapo Petro akamwambia Yesu, “Bwana, ni vizuri sana kwamba tupo hapa! Ukipenda nitajenga vibanda vitatu: kimoja chako, kimoja cha Mose na kimoja cha Eliya.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Alipokuwa bado anasema hivyo, wingu jeupe likawafunika, na sauti ikasikika kutoka katika hilo wingu: “Huyu ni Mwanangu mpendwa, ninayependezwa naye, msikilizeni.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanafunzi waliposikia hivyo wakaanguka kifudifudi, wakaogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu akawaendea, akawagusa, akasema, “Simameni, msiogope!” ");
INSERT INTO swh1850_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Walipoinua macho yao hawakumwona mtu, ila Yesu peke yake. ");
INSERT INTO swh1850_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Basi, walipokuwa wanashuka mlimani, Yesu akawaonya: “Msimwambie mtu mambo mliyoyaona mpaka Mwana wa Mtu atakapofufuliwa kutoka wafu.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kisha wanafunzi wakamwuliza, “Mbona walimu wa Sheria wanasema ati ni lazima kwanza Eliya aje?” ");
INSERT INTO swh1850_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akawajibu, “Kweli, Eliya atakuja kutayarisha mambo yote. ");
INSERT INTO swh1850_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini nawaambieni, Eliya amekwisha kuja nao hawakumtambua, bali walimtendea jinsi walivyotaka. Mwana wa Mtu atateswa vivyo hivyo mikononi mwao.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hapo hao wanafunzi wakafahamu kwamba alikuwa akiwaambia juu ya Yohane mbatizaji. ");
INSERT INTO swh1850_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Walipojiunga tena na ule umati wa watu, mtu mmoja alimwendea Yesu, akampigia magoti, ");
INSERT INTO swh1850_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akasema, “Mheshimiwa, mwonee huruma mwanangu kwa kuwa ana kifafa, tena anateseka sana; mara nyingi yeye huanguka motoni na majini. ");
INSERT INTO swh1850_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nilimleta kwa wanafunzi wako lakini hawakuweza kumponya.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu akajibu, “Enyi kizazi kisicho na imani, kilichopotoka! Nitakaa nanyi mpaka lini? Nitawavumilia ninyi mpaka lini? Mleteni hapa huyo mtoto.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Basi, Yesu akamkemea huyo pepo, naye akamtoka, na yule mtoto akapona wakati huohuo. ");
INSERT INTO swh1850_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kisha wanafunzi wakamwendea Yesu kwa faragha, wakamwuliza, “Kwa nini sisi hatukuweza kumtoa yule pepo?” ");
INSERT INTO swh1850_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akawajibu, “Kwa sababu ya imani yenu haba. Nawaambieni kweli, kama tu mkiwa na imani, hata iwe ndogo kama mbegu ya haradali, mtaweza kuuambia mlima huu: Toka hapa uende pale, nao utakwenda. Hakuna chochote ambacho hakingewezekana kwenu.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Pepo wa namna hii hawezi kuondolewa ila kwa sala na kufunga.” ");
INSERT INTO swh1850_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Walipokuwa pamoja huko Galilaya, Yesu aliwaambia, “Mwana wa Mtu atakabidhiwa kwa watu. ");
INSERT INTO swh1850_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Watamuua, lakini siku ya tatu atafufuliwa.” Wanafunzi wakahuzunika mno. ");
INSERT INTO swh1850_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Walipofika Kafarnaumu watu wenye kukusanya fedha ya zaka ya Hekalu walimwendea Petro, wakamwuliza, “Je, mwalimu wenu hulipa fedha ya zaka?” ");
INSERT INTO swh1850_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro akajibu, “Naam, hulipa.” Basi, Petro alipoingia ndani ya nyumba, kabla hata hajasema neno, Yesu akamwuliza, “Simoni, wewe unaonaje? Wafalme wa dunia hukusanya ushuru au kodi kutoka kwa kina nani? Kutoka kwa wananchi ama kutoka kwa wageni?” ");
INSERT INTO swh1850_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro akajibu, “Kutoka kwa wageni.” Yesu akamwambia, “Haya basi, wananchi hawahusiki. ");
INSERT INTO swh1850_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini kusudi tusiwakwaze, nenda ziwani ukatupe ndoana; chukua samaki wa kwanza atakayenaswa, fungua kinywa chake, na ndani utakuta fedha taslimu ya zaka. Ichukue ukawape kwa ajili yangu na kwa ajili yako.” ");
INSERT INTO swh1850_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakati ule wanafunzi walimwendea Yesu, wakamwuliza, “Ni nani aliye mkuu katika Ufalme wa mbinguni?” ");
INSERT INTO swh1850_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu akamwita mtoto mmoja, akamsimamisha kati yao, ");
INSERT INTO swh1850_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kisha akasema, “Nawaambieni kweli, msipogeuka na kuwa kama watoto, hamtaingia kamwe katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yeyote anayejinyenyekesha kama mtoto huyu, huyo ndiye aliye mkubwa katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yeyote anayemkaribisha mtoto mmoja kama huyu kwa jina langu, ananikaribisha mimi. ");
INSERT INTO swh1850_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yeyote atakayemkosesha mmoja wa hawa wadogo wanaoniamini, ingekuwa afadhali afungwe shingoni jiwe kubwa la kusagia na kuzamishwa kwenye kilindi cha bahari. ");
INSERT INTO swh1850_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ole wake ulimwengu kwa sababu ya vikwazo vinavyowaangusha wengine. Vikwazo hivyo ni lazima vitokee lakini ole wake mtu yule atakayevisababisha. ");
INSERT INTO swh1850_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kama mkono au mguu wako ukikukosesha, ukate na kuutupa mbali nawe. Ni afadhali kwako kuingia katika uzima bila mkono au mguu, kuliko kutupwa katika moto wa milele ukiwa na mikono miwili na miguu yako miwili. ");
INSERT INTO swh1850_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na kama jicho lako likikukosesha, ling'oe na kulitupa mbali nawe. Ni afadhali kwako kuingia katika uzima ukiwa chongo, kuliko kutupwa katika moto wa Jehanamu ukiwa na macho yako yote mawili. ");
INSERT INTO swh1850_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jihadharini! Msimdharau mmojawapo wa wadogo hawa. Nawaambieni, malaika wao huko mbinguni wako daima mbele ya Baba yangu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maana Mwana wa Mtu alikuja kuwaokoa wale waliopotea. ");
INSERT INTO swh1850_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mnaonaje? Mtu akiwa na kondoo mia, akimpoteza mmoja, hufanyaje? Huwaacha wale tisini na tisa mlimani, na huenda kumtafuta yule aliyepotea. ");
INSERT INTO swh1850_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Akimpata, nawaambieni kweli, humfurahia huyo kuliko awafurahiavyo wale tisini na tisa ambao hawakupotea. ");
INSERT INTO swh1850_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hali kadhalika, Baba yenu wa mbinguni hapendi hata mmoja wa hawa wadogo apotee. ");
INSERT INTO swh1850_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ndugu yako akikukosea, mwendee ukamwonye mkiwa ninyi peke yenu. Akikusikia utakuwa umempata ndugu yako. ");
INSERT INTO swh1850_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Asipokusikia, chukua mtu mmoja au wawili pamoja nawe, ili kwa mawaidha ya mashahidi wawili au watatu, kila tatizo litatuliwe. ");
INSERT INTO swh1850_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Asipowasikia hao, liambie kanisa. Na kama hatalisikia kanisa, na awe kwako kama watu wasiomjua Mungu na watoza ushuru. ");
INSERT INTO swh1850_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nawaambieni kweli, mtakachofunga duniani kitafungwa mbinguni, na mtakachofungua duniani kitafunguliwa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tena nawaambieni, wawili miongoni mwenu wakikubaliana hapa duniani kuhusu jambo lolote la kuomba, Baba yangu wa mbinguni atawafanyia jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwa maana popote pale wanapokusanyika wawili au watatu kwa jina langu, mimi nipo hapo kati yao.” ");
INSERT INTO swh1850_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kisha Petro akamwendea Yesu, akamwuliza, “Je, ndugu yangu akinikosea, nimsamehe mara ngapi? Mara saba?” ");
INSERT INTO swh1850_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akamjibu, “Sisemi mara saba tu, bali sabini mara saba. ");
INSERT INTO swh1850_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndiyo maana Ufalme wa mbinguni umefanana na mfalme mmoja aliyeamua kukagua hesabu za watumishi wake. ");
INSERT INTO swh1850_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ukaguzi ulipoanza, akaletewa mtu mmoja aliyekuwa na deni la fedha talanta elfu kumi. ");
INSERT INTO swh1850_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mtu huyo hakuwa na chochote cha kulipa; hivyo bwana wake aliamuru wauzwe, yeye, mke wake, watoto wake na vitu vyote alivyokuwa navyo, ili deni lilipwe. ");
INSERT INTO swh1850_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Basi, huyo mtumishi akapiga magoti mbele yake, akasema, Unisubiri nami nitakulipa deni lote. ");
INSERT INTO swh1850_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yule bwana alimwonea huruma, akamsamehe lile deni, akamwacha aende zake. ");
INSERT INTO swh1850_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lakini huyo mtumishi akaondoka, akamkuta mmoja wa watumishi wenzake aliyekuwa na deni lake fedha denari mia moja. Akamkamata, akamkaba koo akisema, Lipa deni lako! ");
INSERT INTO swh1850_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Huyo mtumishi mwenzake akapiga magoti, akamwomba, Unisubiri nami nitalipa deni langu lote. ");
INSERT INTO swh1850_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini yeye hakutaka, bali alimtia gerezani mpaka hapo atakapolipa lile deni. ");
INSERT INTO swh1850_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Basi, watumishi wenzake walipoona jambo hilo walisikitika sana, wakaenda kumpasha habari bwana wao juu ya mambo hayo yaliyotukia. ");
INSERT INTO swh1850_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hapo yule bwana alimwita huyo mtumishi, akamwambia, Wewe ni mtumishi mbaya sana! Uliniomba, nami nikakusamehe deni lako lote. ");
INSERT INTO swh1850_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Je, haikukupasa nawe kumhurumia mtumishi mwenzako kama nilivyokuhurumia? ");
INSERT INTO swh1850_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Basi, huyo bwana alikasirika sana, akamtoa huyo mtumishi aadhibiwe mpaka hapo atakapolipa deni lote. ");
INSERT INTO swh1850_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na baba yangu aliye mbinguni atawafanyieni vivyo hivyo kama kila mmoja wenu hatamsamehe ndugu yake kwa moyo wake wote.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu alipomaliza kusema maneno hayo, alitoka Galilaya, akaenda katika mkoa wa Yudea, ng'ambo ya mto Yordani. ");
INSERT INTO swh1850_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Watu wengi walimfuata huko, naye akawaponya. ");
INSERT INTO swh1850_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafarisayo kadhaa walimjia, wakamwuliza kwa kumtega, “Je, ni halali mume kumpa talaka mkewe kwa kisa chochote?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akawajibu, “Je, hamkusoma katika Maandiko Matakatifu kwamba Mungu aliyemuumba mtu tangu mwanzo alimfanya mwanamume na mwanamke, ");
INSERT INTO swh1850_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na akasema: Kwa sababu hiyo mwanamume atamwacha baba yake na mama yake, ataungana na mke wake, nao wawili watakuwa mwili mmoja? ");
INSERT INTO swh1850_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwa hiyo wao si wawili tena, bali mwili mmoja. Basi, alichounganisha Mungu, binadamu asikitenganishe.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lakini wao wakamwuliza, “Kwa nini basi, Mose alituagiza mwanamke apewe hati ya talaka na kuachwa?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu akawajibu, “Mose aliwaruhusu kuwaacha wake zenu kwa sababu ya ugumu wa mioyo yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lakini haikuwa hivyo tangu mwanzo. Basi nawaambieni, yeyote atakayemwacha mke wake isipokuwa kwa sababu ya uzinzi, akaoa mke mwingine, anazini.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanafunzi wake wakamwambia, “Ikiwa mambo ya mume na mkewe ni hivyo, ni afadhali kutooa kabisa.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu akawaambia, “Si wote wanaoweza kulipokea fundisho hili, isipokuwa tu wale waliojaliwa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maana kuna sababu kadhaa za kutoweza kuoa: wengine ni kwa sababu wamezaliwa hivyo, wengine kwa sababu wamefanywa hivyo na watu, na wengine wameamua kutooa kwa ajili ya Ufalme wa mbinguni. Awezaye kulipokea fundisho hili na alipokee.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kisha watu wakamletea Yesu watoto wadogo ili awawekee mikono na kuwaombea. Lakini wanafunzi wakawakemea. ");
INSERT INTO swh1850_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu akasema, “Waacheni hao watoto waje kwangu, wala msiwazuie; maana Ufalme wa mbinguni ni wa watu walio kama watoto hawa.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Basi, akawawekea mikono, kisha akaondoka mahali hapo. ");
INSERT INTO swh1850_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mtu mmoja alimjia Yesu, akamwuliza, “Mwalimu, nifanye kitu gani chema ili niupate uzima wa milele?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akamwambia, “Mbona unaniuliza kuhusu jambo jema? Kuna mmoja tu aliye mwema. Ukitaka kuingia katika uzima, shika amri.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yule mtu akamwuliza, “Amri zipi?” Yesu akasema, “Usiue, usizini, usiibe, usitoe ushahidi wa uongo, ");
INSERT INTO swh1850_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","waheshimu baba yako na mama yako; na, mpende jirani yako kama unavyojipenda mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Huyo kijana akamwambia, “Hayo yote nimeyazingatia tangu utoto wangu; sasa nifanye nini zaidi?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu akamwambia, “Kama unapenda kuwa mkamilifu, nenda ukauze mali yako uwape maskini hiyo fedha, nawe utakuwa na hazina mbinguni, kisha njoo unifuate.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Huyo kijana aliposikia hayo, alienda zake akiwa mwenye huzuni, maana alikuwa na mali nyingi. ");
INSERT INTO swh1850_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hapo Yesu akawaambia wanafunzi wake, “Kweli nawaambieni, itakuwa vigumu sana kwa tajiri kuingia katika Ufalme wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tena nawaambieni, ni rahisi zaidi kwa ngamia kupita katika tundu la sindano, kuliko kwa tajiri kuingia katika Ufalme wa mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wale wanafunzi waliposikia hivyo walishangaa, wakamwuliza, “Ni nani basi, awezaye kuokoka?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akawatazama, akasema, “Kwa binadamu jambo hili haliwezekani, lakini kwa Mungu mambo yote huwezekana.” ");
INSERT INTO swh1850_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kisha Petro akasema, “Na sisi je? Tumeacha yote tukakufuata; tutapata nini basi?” ");
INSERT INTO swh1850_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akawaambia, “Nawaambieni kweli, Mwana wa Mtu atakapoketi katika kiti cha enzi cha utukufu wake katika ulimwengu mpya, ninyi mlionifuata mtaketi katika viti kumi na viwili mkiyahukumu makabila kumi na mawili ya Israeli. ");
INSERT INTO swh1850_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kila aliyeacha nyumba, au ndugu, au dada, au baba, au mama, au watoto, au mashamba, kwa ajili yangu, atapokea mara mia zaidi, na kupata uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini walio wa kwanza watakuwa wa mwisho, na walio wa mwisho watakuwa wa kwanza. ");
INSERT INTO swh1850_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ufalme wa mbinguni unafanana na mtu mwenye shamba la mizabibu, ambaye alitoka asubuhi na mapema kuwaajiri wafanyakazi katika shamba lake. ");
INSERT INTO swh1850_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akapatana nao kuwalipa dinari moja kwa siku, kisha akawapeleka katika shamba lake la mizabibu. ");
INSERT INTO swh1850_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akatoka mnamo saa tatu asubuhi, akaona watu wengine wamesimama sokoni, hawana kazi. ");
INSERT INTO swh1850_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akawaambia, Nendeni nanyi mkafanye kazi katika shamba la mizabibu, nami nitawapeni haki yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Basi, wakaenda. Huyo mwenye shamba akatoka tena mnamo saa sita na saa tisa, akafanya vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hata mnamo saa kumi na moja jioni, akatoka tena; akakuta watu wengine wamesimama pale sokoni. Basi, akawauliza, Mbona mmesimama hapa mchana kutwa bila kazi? ");
INSERT INTO swh1850_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wakamjibu: Kwa sababu hakuna mtu aliyetuajiri. Yeye akawaambia, Nendeni nanyi mkafanye kazi katika shamba la mizabibu. ");
INSERT INTO swh1850_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kulipokuchwa, huyo mwenye shamba alimwambia mtunza hazina wake, Waite wafanyakazi ukawalipe mshahara wao, ukianzia na wale walioajiriwa mwisho, na kumalizia na wale wa kwanza. ");
INSERT INTO swh1850_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Basi, wakaja wale walioajiriwa mnamo saa kumi na moja, wakapokea kila mmoja dinari moja. ");
INSERT INTO swh1850_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wale wa kwanza walipofika, walikuwa wanadhani watapewa zaidi; lakini hata wao wakapewa kila mmoja dinari moja. ");
INSERT INTO swh1850_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wakazipokea fedha zao, wakaanza kumnung'unikia yule bwana. ");
INSERT INTO swh1850_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wakasema, Watu hawa walioajiriwa mwisho walifanya kazi kwa muda wa saa moja tu, mbona umetutendea sawa na wao hali sisi tumevumilia kazi ngumu kutwa na jua kali? ");
INSERT INTO swh1850_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Hapo yule bwana akamjibu mmoja wao, Rafiki, sikukupunja kitu! Je, hukupatana nami mshahara wa denari moja? ");
INSERT INTO swh1850_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chukua haki yako, uende zako. Napenda kumpa huyu wa mwisho sawa na wewe. ");
INSERT INTO swh1850_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Je, sina haki ya kufanya na mali yangu nipendavyo? Je, unaona kijicho kwa kuwa mimi ni mwema?” ");
INSERT INTO swh1850_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu akamaliza kwa kusema, “Hivyo, walio wa mwisho watakuwa wa kwanza na wa kwanza watakuwa wa mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu alipokuwa anakwenda Yerusalemu, aliwachukua wale wanafunzi kumi na wawili faraghani, na njiani akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sikilizeni! Tunakwenda Yerusalemu, na huko Mwana wa Mtu atakabidhiwa kwa makuhani wakuu na walimu wa Sheria, nao watamhukumu auawe. ");
INSERT INTO swh1850_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Watamkabidhi kwa watu wa mataifa mengine ili adhihakiwe, apigwe viboko na kusulubiwa; lakini siku ya tatu atafufuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hapo mama yao wana wa Zebedayo alimjia Yesu pamoja na wanawe, akapiga magoti mbele yake na kumwomba kitu. ");
INSERT INTO swh1850_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu akamwuliza, “Unataka nini?” Huyo mama akamwambia, “Ahidi kwamba katika Ufalme wako, hawa wanangu wawili watakaa mmoja upande wako wa kulia na mwingine upande wako wa kushoto.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu akajibu, “Hamjui mnaomba nini. Je, mnaweza kunywa kikombe nitakachokunywa mimi?” Wakamjibu, “Tunaweza.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu akawaambia, “Kweli mtakunywa kikombe changu, lakini kuketi kulia au kushoto kwangu si kazi yangu kupanga; jambo hilo watapewa wale waliowekewa tayari na Baba yangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wale wanafunzi wengine kumi waliposikia hayo, wakawakasirikia hao ndugu wawili. ");
INSERT INTO swh1850_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hivyo Yesu akawaita, akawaambia, “Mnajua kwamba watawala wa mataifa hutawala watu wao kwa mabavu na wakuu hao huwamiliki watu wao. ");
INSERT INTO swh1850_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini kwenu isiwe hivyo, ila yeyote anayetaka kuwa mkuu kati yenu sharti awe mtumishi wa wote; ");
INSERT INTO swh1850_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na anayetaka kuwa wa kwanza kati yenu sharti awe mtumishi wenu. ");
INSERT INTO swh1850_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jinsi hiyohiyo, Mwana wa Mtu hakuja kutumikiwa, bali kutumikia na kutoa maisha yake kuwa fidia ya watu wengi.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu alipokuwa anaondoka mjini Yeriko, umati wa watu ulimfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Basi, kulikuwa na vipofu wawili wameketi kando ya njia, na waliposikia kwamba Yesu alikuwa anapitia hapo, walipaaza sauti: “Mheshimiwa, Mwana wa Daudi, utuhurumie!” ");
INSERT INTO swh1850_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ule umati wa watu ukawakemea na kuwaambia wanyamaze. Lakini wao wakazidi kupaaza sauti: “Mheshimiwa, Mwana wa Daudi, utuhurumie!” ");
INSERT INTO swh1850_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu akasimama, akawaita na kuwauliza, “Mnataka niwafanyie nini?” ");
INSERT INTO swh1850_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wakamjibu, “Mheshimiwa, tunaomba macho yetu yafumbuliwe.” ");
INSERT INTO swh1850_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Basi, Yesu akawaonea huruma, akawagusa macho yao, na papo hapo wakaweza kuona, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wanafunzi wake walipokaribia Yerusalemu na kufika Bethfage katika mlima wa Mizeituni, aliwatuma wanafunzi wake wawili, ");
INSERT INTO swh1850_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akawaambia, “Nendeni hadi kijiji kilicho mbele yenu na mtamkuta punda amefungwa na mtoto wake. Wafungueni mkawalete kwangu. ");
INSERT INTO swh1850_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kama mtu akiwauliza sababu, mwambieni, Bwana anawahitaji, naye atawaachieni mara.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jambo hili lilifanyika ili yale yaliyosemwa na nabii yatimie: ");
INSERT INTO swh1850_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Uambieni mji wa Sioni: Tazama, Mfalme wako anakujia! Ni mpole na amepanda punda, mwana punda, mtoto wa punda.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hivyo, wale wanafunzi walienda wakafanya kama Yesu alivyowaagiza. ");
INSERT INTO swh1850_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wakamleta yule punda na mtoto wake, wakatandika nguo zao juu yao na Yesu akaketi juu yake. ");
INSERT INTO swh1850_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Umati mkubwa wa watu ukatandaza nguo zao barabarani, na watu wengine wakakata matawi ya miti wakayatandaza barabarani. ");
INSERT INTO swh1850_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Makundi ya watu waliomtangulia na wale waliomfuata wakapaaza sauti: “Hosana Mwana wa Daudi! Abarikiwe huyo ajaye kwa jina la Bwana! Hosana Mungu juu mbinguni!” ");
INSERT INTO swh1850_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu alipokuwa anaingia Yerusalemu, mji wote ukajaa ghasia. Watu wakawa wanauliza, “Huyu ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Watu katika ule umati wakasema, “Huyu ni nabii Yesu, kutoka Nazareti katika mkoa wa Galilaya.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Basi, Yesu akaingia Hekaluni, akawafukuza nje watu waliokuwa wanauza na kununua vitu ndani ya Hekalu; akazipindua meza za wale waliokuwa wanavunja fedha, na viti vya wale waliokuwa wanauza njiwa. ");
INSERT INTO swh1850_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akawaambia, “Imeandikwa katika Maandiko Matakatifu: Nyumba yangu itaitwa nyumba ya sala. Lakini ninyi mmeifanya kuwa pango la wanyang'anyi.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vipofu na vilema walimwendea huko Hekaluni, naye Yesu akawaponya. ");
INSERT INTO swh1850_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Basi, makuhani wakuu na walimu wa Sheria walipoyaona maajabu aliyoyafanya Yesu, na pia watoto walipokuwa wanapaaza sauti zao Hekaluni wakisema: “Sifa kwa Mwana wa Daudi,” wakakasirika. ");
INSERT INTO swh1850_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hivyo wakamwambia, “Je, husikii wanachosema?” Yesu akawajibu, “Naam, nasikia! Je hamjasoma Maandiko haya Matakatifu? Kwa vinywa vya watoto wadogo na wanyonyao unajipatia sifa kamilifu.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Basi, akawaacha, akatoka nje ya mji na kwenda Bethania, akalala huko. ");
INSERT INTO swh1850_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu alipokuwa anarudi mjini asubuhi na mapema, aliona njaa. ");
INSERT INTO swh1850_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akauona mtini mmoja kando ya njia, akauendea; lakini aliukuta hauma chochote ila majani matupu. Basi akauambia, “Usizae tena matunda milele!” Papo hapo huo mtini ukanyauka. ");
INSERT INTO swh1850_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanafunzi walipouona walishangaa wakisema, “Kwa nini mtini huu umenyauka ghafla?” ");
INSERT INTO swh1850_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu akawajibu, “Kweli nawaambieni, kama mkiwa na imani bila kuwa na mashaka, mnaweza si tu kufanya hivyo, bali hata mkiuambia mlima huu: Ng'oka ukajitose baharini, itafanyika hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na mkiwa na imani, chochote mtakachoomba katika sala, mtapata.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu aliingia Hekaluni, akawa anafundisha. Alipokuwa akifundisha, makuhani wakuu na wazee wa watu wakamwuliza, “Unafanya mambo haya kwa mamlaka gani? Nani amekupa mamlaka haya?” ");
INSERT INTO swh1850_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akawajibu, “Na mimi nitawaulizeni swali moja; mkinijibu, basi nami nitawaambieni ninafanya mambo haya kwa mamlaka gani. ");
INSERT INTO swh1850_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Je, mamlaka ya Yohane ya kubatiza yalitoka kwa nani? Je, yalitoka mbinguni ama kwa watu?” Lakini wakajadiliana wao kwa wao hivi: “Tukisema, Yalitoka mbinguni, atatuuliza, Basi, mbona hamkumsadiki? ");
INSERT INTO swh1850_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na tukisema, Yalitoka kwa watu, tunaogopa umati wa watu maana wote wanakubali kwamba Yohane ni nabii.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Basi, wakamjibu, “Hatujui!” Naye Yesu akawaambia, “Nami pia sitawaambieni ninafanya mambo haya kwa mamlaka gani. ");
INSERT INTO swh1850_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ninyi mnaonaje; mtu mmoja alikuwa na wana wawili. Akamwambia yule wa kwanza, Mwanangu, leo nenda ukafanye kazi katika shamba la mizabibu. ");
INSERT INTO swh1850_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yule kijana akamwambia, Sitaki! Lakini baadaye akabadili nia, akaenda kufanya kazi. ");
INSERT INTO swh1850_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yule baba akamwambia mtoto wake wa pili vivyo hivyo, naye akamjibu, Naam baba! Lakini hakwenda kazini. ");
INSERT INTO swh1850_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Je, ni nani kati ya hawa wawili aliyetimiza matakwa ya baba yake?” Wakamjibu, “Yule mtoto wa kwanza.” Basi, Yesu akawaambia, “Kweli nawaambieni, watoza ushuru na waasherati wataingia katika Ufalme wa Mungu kabla yenu. ");
INSERT INTO swh1850_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maana Yohane alikuja kwenu akawaonyesha njia njema ya kuishi, nanyi hamkumwamini; lakini watoza ushuru na waasherati walimwamini. Hata baada ya kuona hayo yote ninyi hamkubadili mioyo yenu, na hamkusadiki.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu akasema, “Sikilizeni mfano mwingine. Mtu mmoja mwenye nyumba alilima shamba la mizabibu; akalizungushia ukuta, akachimba kisima cha kusindikia divai, akajenga humo mnara pia. Kisha akalikodisha kwa wakulima, akasafiri kwenda nchi ya mbali. ");
INSERT INTO swh1850_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wakati wa mavuno ulipofika, aliwatuma watumishi wake kwa wale wakulima, ili wakachukue sehemu ya mavuno yake. ");
INSERT INTO swh1850_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wale wakulima wakawakamata hao watumishi; mmoja wakampiga, mwingine wakamwua na mwingine wakampiga mawe. ");
INSERT INTO swh1850_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Huyo mtu akawatuma tena watumishi wengine, wengi kuliko wa safari ya kwanza. Wale wakulima wakawatendea namna ileile. ");
INSERT INTO swh1850_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwishowe akamtuma mwanawe huku akifikiri: Watamheshimu mwanangu. ");
INSERT INTO swh1850_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini wale wakulima walipomwona mwanawe wakasemezana wao kwa wao: Huyu ndiye mrithi; na tumuue ili tuuchukue urithi wake! ");
INSERT INTO swh1850_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Basi, wakamkamata, wakamtoa nje ya lile shamba la mizabibu, wakamwua. ");
INSERT INTO swh1850_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Sasa, huyo mwenye shamba la mizabibu atakapokuja, atawafanyaje hao wakulima?” ");
INSERT INTO swh1850_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wao wakamjibu, “Atawaangamiza vibaya hao waovu, na lile shamba atawapa wakulima wengine ambao watampa sehemu ya mavuno wakati wa mavuno.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hapo Yesu akawaambia, “Je, hamkusoma jambo hili katika Maandiko Matakatifu? Jiwe walilokataa waashi sasa limekuwa jiwe kuu la msingi. Bwana ndiye aliyefanya jambo hili, nalo ni la ajabu sana kwetu! ");
INSERT INTO swh1850_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kwa hiyo nawaambieni, Ufalme wa Mungu utaondolewa kwenu na kupewa watu wa mataifa mengine wenye kutoa matunda yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Atakayeanguka juu ya jiwe hilo atavunjika vipandevipande; na likimwangukia mtu yeyote, litamponda.” ");
INSERT INTO swh1850_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Makuhani wakuu na Mafarisayo waliposikia hiyo mifano yake walitambua kwamba alikuwa anawasema wao. ");
INSERT INTO swh1850_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kwa hiyo wakawa wanatafuta njia ya kumtia nguvuni, lakini waliwaogopa watu kwa sababu wao walimtambua yeye kuwa nabii. ");
INSERT INTO swh1850_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu alisema nao tena kwa kutumia mifano: ");
INSERT INTO swh1850_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ufalme wa mbinguni umefanana na mfalme aliyemwandalia mwanawe karamu ya arusi. ");
INSERT INTO swh1850_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Basi, akawatuma watumishi kuwaita walioalikwa waje arusini, lakini walioalikwa hawakutaka kufika. ");
INSERT INTO swh1850_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akawatuma tena watumishi wengine, akisema, Waambieni wale walioalikwa: karamu yangu iko tayari sasa; fahali wangu na ng'ombe wanono wamekwisha chinjwa; kila kitu ni tayari, njoni arusini. ");
INSERT INTO swh1850_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini wao hawakujali, wakaenda zao; mmoja shambani kwake, mwingine kwenye shughuli zake, ");
INSERT INTO swh1850_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na wengine wakawakamata wale watumishi wakawatukana, wakawaua. ");
INSERT INTO swh1850_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yule mfalme akakasirika, akawatuma askari wake wakawaangamize wauaji hao na kuuteketeza mji wao. ");
INSERT INTO swh1850_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kisha akawaambia watumishi wake: Karamu ya arusi iko tayari kweli, lakini walioalikwa hawakustahili. ");
INSERT INTO swh1850_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Basi, nendeni kwenye barabara na wowote wale mtakaowakuta waiteni waje arusini. ");
INSERT INTO swh1850_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wale watumishi wakatoka, wakaenda njiani, wakawaleta watu wote, wabaya na wema. Nyumba ya arusi ikajaa wageni. ");
INSERT INTO swh1850_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mfalme alipoingia kuwaona wageni, akamwona mtu mmoja ambaye hakuvaa mavazi ya arusi. ");
INSERT INTO swh1850_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mfalme akamwuliza, Rafiki, umeingiaje hapa bila vazi la arusi? Lakini yeye akakaa kimya. ");
INSERT INTO swh1850_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hapo mfalme akawaambia watumishi, Mfungeni miguu na mikono mkamtupe nje gizani; huko atalia na kusaga meno.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu akamaliza kwa kusema, “Wengi wamealikwa, lakini wachache wameteuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kisha, Mafarisayo wakaenda zao, wakashauriana jinsi ya kumnasa Yesu kwa maneno yake. ");
INSERT INTO swh1850_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Basi, wakawatuma wafuasi wao pamoja na wafuasi wa kikundi cha Herode. Wakamwuliza, “Mwalimu, tunajua kwamba wewe ni mtu mwaminifu, na kwamba wafundisha njia ya Mungu kwa uaminifu; humwogopi mtu yeyote, maana cheo cha mtu si kitu kwako. ");
INSERT INTO swh1850_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haya, twambie maoni yako. Je, ni halali au la, kulipa Kaisari?” ");
INSERT INTO swh1850_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lakini Yesu alitambua uovu wao, akawaambia, “Enyi ");
INSERT INTO swh1850_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nionyesheni fedha ya kulipia kodi.” Nao wakamtolea sarafu ya fedha. sarafu ya fedha. ");
INSERT INTO swh1850_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Basi, Yesu akawauliza, “Sura na chapa hii ni ya nani?” ");
INSERT INTO swh1850_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wakamjibu, “Ni vya Kaisari.” Hapo Yesu akawaambia, “Basi, mpeni Kaisari yaliyo yake Kaisari, na Mungu yaliyo yake Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Waliposikia hivyo wakashangaa; wakamwacha, wakaenda zao. ");
INSERT INTO swh1850_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Siku hiyo, baadhi ya Masadukayo walimwendea Yesu. Hao ndio wale wasemao kwamba wafu hawafufuki. ");
INSERT INTO swh1850_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Basi, wakamwambia, “Mwalimu, Mose alisema mtu aliyeoa akifa bila kuacha watoto, lazima ndugu yake amwoe huyo mama mjane, amzalie ndugu yake watoto. ");
INSERT INTO swh1850_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sasa, hapa petu palikuwa na ndugu saba. Wa kwanza alioa kisha akafa bila kujaliwa watoto, akamwachia ndugu yake huyo mke wake mjane. ");
INSERT INTO swh1850_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ikawa vivyo hivyo kwa ndugu wa pili, na wa tatu, mpaka wa saba. ");
INSERT INTO swh1850_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Baada ya ndugu hao wote kufa, akafa pia yule mama. ");
INSERT INTO swh1850_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Je, siku wafu watakapofufuka mama huyo atakuwa mke wa nani miongoni mwa wale ndugu saba? Maana Wote saba walimwoa.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu akawajibu, “Kweli mmekosea kwa sababu hamjui Maandiko Matakatifu wala nguvu ya Mungu! ");
INSERT INTO swh1850_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maana wafu watakapofufuliwa hawataoa wala kuolewa, watakuwa kama malaika mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini kuhusu suala la wafu kufufuka, hamjasoma yale aliyowaambieni Mungu? ");
INSERT INTO swh1850_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Aliwaambia, Mimi ni Mungu wa Abrahamu, Isaka na Yakobo! Basi, yeye si Mungu wa wafu, bali ni Mungu wa walio hai.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ule umati wa watu uliposikia hivyo ukayastaajabia mafundisho yake. ");
INSERT INTO swh1850_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafarisayo waliposikia kwamba Yesu alikuwa amewanyamazisha Masadukayo, wakakutana pamoja. ");
INSERT INTO swh1850_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mmoja wao, mwanasheria, akamwuliza Yesu kwa kumjaribu, ");
INSERT INTO swh1850_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwalimu, ni amri ipi iliyo kuu katika Sheria ya Mose?” ");
INSERT INTO swh1850_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akamjibu, “Mpende Bwana Mungu wako kwa moyo wako wote, kwa roho yako yote na kwa akili yako yote. ");
INSERT INTO swh1850_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hii ndiyo amri kuu ya kwanza. ");
INSERT INTO swh1850_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya pili inafanana na hiyo: Mpende jirani yako kama unavyojipenda wewe mwenyewe. ");
INSERT INTO swh1850_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sheria yote ya Mose na mafundisho ya manabii vinategemea amri hizi mbili.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafarisayo walipokusanyika pamoja, Yesu aliwauliza, ");
INSERT INTO swh1850_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ninyi mwaonaje juu ya Kristo? Je, ni mwana wa nani?” Wakamjibu, “Wa Daudi.” ");
INSERT INTO swh1850_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu akawaambia, “Basi, inawezekanaje kwamba kwa nguvu ya Roho Mtakatifu Daudi anamwita yeye Bwana? Maana alisema: ");
INSERT INTO swh1850_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bwana alimwambia Bwana wangu: keti upande wangu wa kulia, mpaka niwaweke adui zako chini ya miguu yako. ");
INSERT INTO swh1850_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Basi, ikiwa Daudi anamwita Kristo Bwana, anawezaje kuwa mwanawe?” ");
INSERT INTO swh1850_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hakuna mtu yeyote aliyeweza kumjibu neno. Na tangu siku hiyo hakuna aliyethubutu tena kumwuliza swali. ");
INSERT INTO swh1850_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kisha Yesu akauambia umati wa watu pamoja na wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Walimu wa Sheria na Mafarisayo wana mamlaka ya kufafanua Sheria ya Mose. ");
INSERT INTO swh1850_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwa hiyo shikeni na kutekeleza chochote watakachowaambieni. Lakini msiyaige matendo yao, maana hawatekelezi yale wanayoyahubiri. ");
INSERT INTO swh1850_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hufunga mizigo mizito na kuwatwika watu mabegani, lakini wao wenyewe hawataki kunyosha hata kidole wapate kuibeba. ");
INSERT INTO swh1850_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wao hufanya matendo yao yote ili watu wawaone. Huvaa tepe zenye maandishi ya Sheria juu ya panda la uso na mikononi na hupanua pindo za makoti yao. ");
INSERT INTO swh1850_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hupenda nafasi za heshima katika karamu na viti vya heshima katika masunagogi. ");
INSERT INTO swh1850_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hupenda kusalimiwa kwa heshima sokoni na kupendelea kuitwa na watu: Mwalimu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini ninyi msiitwe kamwe Mwalimu, maana mwalimu wenu ni mmoja tu, nanyi nyote ni ndugu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wala msimwite mtu yeyote Baba hapa duniani, maana Baba yenu ni mmoja tu aliye mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala msiitwe Viongozi, maana kiongozi wenu ni mmoja tu, ndiye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aliye mkubwa miongoni mwenu ni lazima awe mtumishi wenu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Anayejikweza atashushwa, na anayejishusha atakwezwa. ");
INSERT INTO swh1850_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnaufunga mlango wa Ufalme wa mbinguni mbele ya macho ya watu. Ninyi wenyewe hamwingii ndani, wala hamwaruhusu wanaotaka kuingia waingie. ");
INSERT INTO swh1850_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnawanyonya wajane na kujisingizia kuwa watu wema kwa kusali sala ndefu. Kwa sababu hiyo mtapata adhabu kali. ");
INSERT INTO swh1850_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnasafiri baharini na nchi kavu ili kumpata mtu mmoja afuate dini yenu. Mnapompata, mnamfanya astahili maradufu kwenda katika moto wa Jehanamu kuliko ninyi wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ole wenu viongozi vipofu! Ninyi mwasema ati mtu akiapa kwa Hekalu, kiapo hicho si kitu; lakini akiapa kwa dhahabu ya Hekalu, kiapo hicho kinamshika. ");
INSERT INTO swh1850_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Enyi vipofu wapumbavu! Kipi kilicho cha maana zaidi: dhahabu au Hekalu linalofanya hiyo dhahabu kuwa takatifu? ");
INSERT INTO swh1850_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tena mwasema ati mtu akiapa kwa madhabahu si kitu; lakini akiapa kwa zawadi iliyowekwa juu ya madhabahu, kiapo hicho humshika. ");
INSERT INTO swh1850_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Enyi vipofu! Ni kipi kilicho cha maana zaidi: ile zawadi, au madhabahu ambayo hufanya hiyo zawadi kuwa takatifu? ");
INSERT INTO swh1850_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anayeapa kwa madhabahu ameapa kwa hiyo madhabahu, na kwa chochote kilichowekwa juu yake. ");
INSERT INTO swh1850_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na anayeapa kwa Hekalu ameapa kwa hilo Hekalu na pia kwa yule akaaye ndani yake. ");
INSERT INTO swh1850_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na anayeapa kwa mbingu ameapa kwa kiti cha enzi cha Mungu, na kwa huyo aketiye juu yake. ");
INSERT INTO swh1850_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnatoza watu zaka, hata juu ya majani yenye harufu nzuri, bizari na jira, na huku mnaacha mambo muhimu ya Sheria kama vile haki, huruma na imani. Haya ndiyo hasa mliyopaswa kuyazingatia bila kusahau yale mengine. ");
INSERT INTO swh1850_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Viongozi vipofu! Mnatoa nzi katika kinywaji, lakini mnameza ngamia! ");
INSERT INTO swh1850_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnasafisha kikombe na bakuli kwa nje, lakini ndani mnaacha kumejaa vitu mlivyopata kwa unyang'anyi na uchoyo. ");
INSERT INTO swh1850_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mfarisayo kipofu! Kisafishe kikombe ndani kwanza na nje kutakuwa safi pia. ");
INSERT INTO swh1850_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mko kama makaburi yaliyopakwa chokaa ambayo kwa nje yanaonekana kuwa mazuri, lakini ndani yamejaa mifupa ya maiti na kila namna ya uchafu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hali kadhalika ninyi mnaonekana na watu kwa nje kuwa wema, lakini kwa ndani mmejaa unafiki na uovu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ole wenu walimu wa Sheria na Mafarisayo, wanafiki! Mnajenga makaburi ya manabii na kuyapamba makaburi ya watu wema. ");
INSERT INTO swh1850_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwasema: Kama sisi tungaliishi nyakati za wazee wetu hatungalishirikiana nao katika mauaji ya manabii! ");
INSERT INTO swh1850_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hivyo mnathibitisha ninyi wenyewe kwamba ninyi ni watoto wa watu waliowaua manabii. ");
INSERT INTO swh1850_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haya, kamilisheni ile kazi wazee wenu waliyoianza! ");
INSERT INTO swh1850_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Enyi kizazi cha nyoka wenye sumu! Mnawezaje kuiepa hukumu ya moto wa Jehanamu? ");
INSERT INTO swh1850_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndiyo maana mimi ninawapelekea ninyi manabii, watu wenye hekima na walimu; mtawaua na kuwasulubisha baadhi yao, na wengine mtawapiga viboko katika masunagogi yenu na kuwasaka katika kila mji. ");
INSERT INTO swh1850_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hivyo lawama yote itawapateni kwa ajili ya damu yote ya watu wema iliyomwagwa juu ya ardhi. Naam, tangu kuuawa kwa Abeli ambaye hakuwa na hatia, mpaka kuuawa kwa Zakariya, mwana wa Barakia, ambaye mlimuua Hekaluni kati ya patakatifu na madhabahu. ");
INSERT INTO swh1850_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nawaambieni kweli, kizazi hiki kitapata adhabu kwa sababu ya mambo haya. ");
INSERT INTO swh1850_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalemu, Ee Yerusalemu! Unawaua manabii na kuwapiga mawe wale waliotumwa kwako. Mara ngapi nimejaribu kuwakusanya watoto wako kwangu, kama vile kuku anavyokusanya vifaranga vyake chini ya mabawa yake, lakini hukutaka. ");
INSERT INTO swh1850_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Haya basi, nyumba yako itaachwa mahame. ");
INSERT INTO swh1850_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nakwambia kweli, hutaniona tena mpaka wakati utakaposema: Abarikiwe huyo ajaye kwa jina la Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu alitoka Hekaluni, na alipokuwa akienda zake, wanafunzi wake walimwendea, wakamwonyesha majengo ya Hekalu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu akawaambia, “Sawa, mnaweza kuyatazama haya yote! Kweli nawaambieni, hakuna hata jiwe moja litakalosalia hapa juu ya lingine; kila kitu kitaharibiwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu alipokuwa ameketi juu ya mlima wa Mizeituni, wanafunzi walimwendea faraghani, wakamwuliza, “Twambie mambo haya yatatukia lini? Ni ishara gani itakayoonyesha kuja kwako na mwisho wa nyakati?” ");
INSERT INTO swh1850_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu akawajibu, “Jihadharini msije mkadanganywa na mtu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maana wengi watatokea na kulitumia jina langu wakisema: Mimi ndiye Kristo, nao watawapotosha watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mtasikia juu ya vita na fununu za vita; lakini msifadhaike, maana hayo hayana budi kutokea, lakini mwisho wenyewe ungali bado. ");
INSERT INTO swh1850_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Taifa moja litapigana na taifa lingine; ufalme mmoja utapigana na ufalme mwingine. Hapa na pale patakuwa na njaa na mitetemeko ya ardhi. ");
INSERT INTO swh1850_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yote hayo ni kama mwanzo wa maumivu ya kujifungua mtoto. ");
INSERT INTO swh1850_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kisha watawatoeni ili mteswe na kuuawa. Mataifa yote yatawachukieni kwa ajili ya jina langu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tena, wengi wataiacha imani yao, watasalitiana na kuchukiana. ");
INSERT INTO swh1850_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Watatokea manabii wengi wa uongo watakaowapotosha watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa sababu ya ongezeko la uhalifu, upendo wa watu wengi utafifia. ");
INSERT INTO swh1850_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini atakayevumilia mpaka mwisho, ataokoka. ");
INSERT INTO swh1850_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ila, kabla ya mwisho kufika, hii Habari Njema ya Ufalme wa Mungu itahubiriwa ulimwenguni kote kama ushuhuda kwa mataifa yote. ");
INSERT INTO swh1850_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Basi, mtakapoona Chukizo Haribifu lililonenwa na nabii Danieli limesimama mahali patakatifu, (msomaji na atambue maana yake), ");
INSERT INTO swh1850_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","hapo, walioko Yudea na wakimbilie milimani. ");
INSERT INTO swh1850_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aliye juu ya paa la nyumba yake asishuke kuchukua kitu nyumbani mwake. ");
INSERT INTO swh1850_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aliye shambani asirudi nyuma kuchukua vazi lake. ");
INSERT INTO swh1850_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ole wao kina mama waja wazito na wanaonyonyesha siku hizo! ");
INSERT INTO swh1850_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ombeni ili kukimbia kwenu kusiwe siku za baridi au siku ya Sabato! ");
INSERT INTO swh1850_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maana wakati huo kutakuwa na dhiki kuu ambayo haijapata kuwako tangu mwanzo wa ulimwengu mpaka leo, wala haitapata kutokea tena. ");
INSERT INTO swh1850_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kama siku hizo hazingalipunguzwa, hakuna binadamu yeyote ambaye angeokoka; lakini siku hizo zitapunguzwa kwa ajili ya wale walioteuliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Basi, mtu akiwaambieni siku hizo: Kristo yuko hapa au Yuko pale, msimsadiki. ");
INSERT INTO swh1850_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maana watatokea kina Kristo wa uongo na manabii wa uongo. Watafanya ishara kubwa na maajabu ya kuweza kuwapotosha ikiwezekana hata wateule wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sikilizeni, nimekwisha kuwaonya kabla ya wakati. ");
INSERT INTO swh1850_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Basi, wakiwaambieni, Tazameni, yuko jangwani, msiende huko; au, Tazameni, amejificha ndani, msisadiki; ");
INSERT INTO swh1850_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","maana, kama vile umeme uangazavyo toka mashariki hadi magharibi, ndivyo kutakavyokuwa kuja kwake Mwana wa Mtu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pale ulipo mzoga, ndipo watakapokusanyika tai. ");
INSERT INTO swh1850_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mara baada ya dhiki ya siku hizo, jua litatiwa giza, mwezi hautaangaza, nyota zitaanguka kutoka angani, na nguvu za mbingu zitatikiswa. ");
INSERT INTO swh1850_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kisha, ishara ya Mwana wa Mtu itaonekana angani, na hapo makabila yote duniani yatalalamika; watamwona Mwana wa Mtu akija juu ya mawingu ya angani mwenye nguvu na utukufu mwingi. ");
INSERT INTO swh1850_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naye atawatuma malaika wake wenye tarumbeta la kuvuma sana, nao watawakusanya wateule wake kutoka pande zote nne za dunia, toka mwisho huu wa mbingu hadi mwisho huu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kwa mtini jifunzeni mfano huu: Mara tu matawi yake yanapoanza kuwa laini na kuchanua majani, mnajua kwamba wakati wa kiangazi umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hali kadhalika nanyi mtakapoona mambo haya yote yakitendeka, jueni kwamba yuko karibu sana. ");
INSERT INTO swh1850_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nawaambieni kweli, kizazi hiki hakitapita kabla ya mambo hayo yote kutukia. ");
INSERT INTO swh1850_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Naam, mbingu na dunia zitapita, lakini maneno yangu hayatapita kamwe. ");
INSERT INTO swh1850_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lakini, juu ya siku au saa hiyo, hakuna mtu ajuaye itakuja lini; wala malaika wa mbinguni, wala Mwana, ila Baba peke yake ndiye ajuaye. ");
INSERT INTO swh1850_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwa maana kama ilivyokuwa nyakati za Noa, ndivyo itakavyokuwa kuja kwake Mwana wa Mtu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maana nyakati hizo, kabla ya gharika kuu, watu walikuwa wakila na kunywa, wakioa na kuolewa, mpaka Noa alipoingia ndani ya ile safina. ");
INSERT INTO swh1850_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hawakujua kuna nini mpaka ile gharika ilipotokea, ikawakumba wote. Ndivyo itakavyokuwa wakati Mwana wa Mtu atakapokuja. ");
INSERT INTO swh1850_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakati huo watu wawili watakuwa shambani; mmoja atachukuliwa na mwingine ataachwa. ");
INSERT INTO swh1850_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kina mama wawili watakuwa wanasaga nafaka, mmoja atachukuliwa na mwingine ataachwa. ");
INSERT INTO swh1850_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Basi, kesheni, kwa maana hamjui siku atakayokuja Bwana wenu. ");
INSERT INTO swh1850_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini kumbukeni jambo hili: kama mwenye nyumba angejua siku mwizi atakapofika, angekesha, wala hangeiacha nyumba yake ivunjwe. ");
INSERT INTO swh1850_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa hiyo, nanyi pia muwe tayari, kwa maana Mwana wa Mtu atakuja saa msiyoitazamia.” ");
INSERT INTO swh1850_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu akaendelea kusema, “Ni nani basi mtumishi mwaminifu na mwenye busara, ambaye bwana wake atamweka juu ya watu wake, awape chakula kwa wakati wake? ");
INSERT INTO swh1850_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Heri mtumishi yule ambaye bwana wake atakapokuja atamkuta akifanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kweli nawaambieni, atamweka mtumishi huyo aisimamie mali yake yote. ");
INSERT INTO swh1850_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini kama mtumishi mbaya akijisemea moyoni: Bwana wangu anakawia kurudi, ");
INSERT INTO swh1850_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kisha akaanza kuwapiga watumishi wenzake, akaanza kula na kunywa pamoja na walevi, ");
INSERT INTO swh1850_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","bwana wake atakuja siku asiyoitazamia na saa asiyoijua. ");
INSERT INTO swh1850_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atamkatilia mbali na kumweka kundi moja na wanafiki. Huko kutakuwa na kilio na kusaga meno. ");
INSERT INTO swh1850_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Wakati huo, Ufalme wa mbinguni utafanana na wasichana kumi waliochukua taa zao, wakaenda kumlaki bwana arusi. ");
INSERT INTO swh1850_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Watano miongoni mwao walikuwa wapumbavu na watano walikuwa wenye busara. ");
INSERT INTO swh1850_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wale wapumbavu walichukua taa zao, lakini hawakuchukua akiba ya mafuta. ");
INSERT INTO swh1850_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lakini wale wenye busara walichukua mafuta katika chupa pamoja na taa zao. ");
INSERT INTO swh1850_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwa kuwa bwana arusi alikawia kuja, wale wanawali wote wote walisinzia, wakalala. ");
INSERT INTO swh1850_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Usiku wa manane kukawa na kelele: Haya, haya! Bwana arusi anakuja; nendeni kumlaki. ");
INSERT INTO swh1850_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hapo wale wanawali wote wakaamka, wakazitayarisha taa zao. ");
INSERT INTO swh1850_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wale wapumbavu wakawaambia wale wenye busara: Tupeni mafuta yenu kidogo maana taa zetu zinazimika. ");
INSERT INTO swh1850_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini wale wenye busara wakawaambia, Hayatatutosha sisi na ninyi! Afadhali mwende dukani mkajinunulie wenyewe! ");
INSERT INTO swh1850_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Basi, wale wanawali wapumbavu walipokwenda kununua mafuta, bwana arusi akafika, na wale wanawali waliokuwa tayari wakaingia pamoja naye katika jumba la arusi, kisha mlango ukafungwa. ");
INSERT INTO swh1850_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baadaye wale wanawali wengine wakaja, wakaita: Bwana, bwana, tufungulie! ");
INSERT INTO swh1850_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini yeye akawajibu, Nawaambieni kweli, siwajui ninyi.” ");
INSERT INTO swh1850_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kisha Yesu akasema, “Kesheni basi, kwa maana hamjui siku wala saa. ");
INSERT INTO swh1850_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Itakuwa kama mtu mmoja aliyetaka kusafiri ng'ambo: aliwaita watumishi wake, akawakabidhi mali yake. ");
INSERT INTO swh1850_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Alimpa kila mmoja kadiri ya uwezo wake: mmoja sarafu tano za fedha ziitwazo talanta, mwingine talanta mbili na mwingine talanta moja, kisha akasafiri. ");
INSERT INTO swh1850_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mara yule aliyekabidhiwa talanta tano akafanya kazi nazo akapata faida talanta tano. ");
INSERT INTO swh1850_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hali kadhalika na yule aliyekabidhiwa talanta mbili akapata faida talanta mbili. ");
INSERT INTO swh1850_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini yule aliyekabidhiwa talanta moja akaenda akachimba shimo ardhini, akaificha fedha ya bwana wake. ");
INSERT INTO swh1850_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Baada ya muda mrefu, yule bwana alirudi, akaanza kukagua hesabu ya matumizi na mapato ya fedha yake. ");
INSERT INTO swh1850_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mtumishi aliyekabidhiwa talanta tano akaja amechukua zile talanta tano faida, akamwambia, Bwana, ulinikabidhi talanta tano, hapa pana talanta tano zaidi faida niliyopata. ");
INSERT INTO swh1850_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bwana wake akamwambia, Vema, mtumishi mwema na mwaminifu. Umekuwa mwaminifu katika mambo madogo nitakukabidhi makubwa. Njoo ufurahi pamoja na bwana wako. ");
INSERT INTO swh1850_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mtumishi aliyekabidhiwa talanta mbili akaja, akatoa talanta mbili faida, akisema, Bwana, ulinikabidhi talanta mbili. Chukua talanta mbili zaidi faida niliyopata. ");
INSERT INTO swh1850_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bwana wake akamwambia, Vema, mtumishi mwema na mwaminifu. Umekuwa mwaminifu katika mambo madogo, nitakukabidhi makubwa. Njoo ufurahi pamoja na bwana wako. ");
INSERT INTO swh1850_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Lakini yule aliyekabidhiwa talanta moja akaja, akasema, Bwana, najua wewe ni mtu mgumu; wewe huvuna pale ambapo hukupanda, na kukusanya pale ambapo hukutawanya. ");
INSERT INTO swh1850_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Niliogopa, nikaificha fedha yako katika ardhi. Chukua basi mali yako. ");
INSERT INTO swh1850_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bwana wake akamwambia, Wewe ni mtumishi mwovu na mvivu! Unajua kuwa mimi huvuna mahali ambapo sikupanda, na hukusanya pale ambapo sikutawanya. ");
INSERT INTO swh1850_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ilikupasa basi, kuiweka fedha yangu katika benki, nami ningelichukua mtaji wangu na faida yake! ");
INSERT INTO swh1850_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Basi, mnyang'anyeni hiyo fedha mkampe yule mwenye talanta kumi. ");
INSERT INTO swh1850_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maana, aliye na kitu atapewa na kuzidishiwa. Lakini yule asiye na kitu, hata kile alicho nacho kitachukuliwa. ");
INSERT INTO swh1850_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na kuhusu huyu mtumishi asiye na faida, mtupeni nje gizani! Huko kutakuwa na kilio na kusaga meno. ");
INSERT INTO swh1850_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wakati Mwana wa Mtu atakapokuja katika utukufu wake na malaika wote wakiwa pamoja naye, hapo ataketi juu ya kiti chake cha enzi kitukufu, ");
INSERT INTO swh1850_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","na mataifa yote yatakusanyika mbele yake, naye atawatenganisha watu kama mchungaji anavyotenganisha kondoo na mbuzi. ");
INSERT INTO swh1850_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atawaweka kondoo upande wake wa kulia na mbuzi upande wake wa kushoto. ");
INSERT INTO swh1850_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kisha Mfalme atawaambia wale walio upande wake wa kulia, Njoni enyi mliobarikiwa na Baba yangu; pokeeni Ufalme mliotayarishiwa tangu kuumbwa kwa ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maana nilikuwa na njaa nanyi mkanipa chakula; nilikuwa na kiu nanyi mkanipa maji; nilikuwa mgeni nanyi mkanikaribisha; ");
INSERT INTO swh1850_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nilikuwa uchi, mkanivika; nilikuwa mgonjwa nanyi mkaja kunitazama; nilikuwa gerezani nanyi mkaja kunitembelea. ");
INSERT INTO swh1850_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hapo, hao watu wema watamjibu mfalme Bwana, ni lini tulikuona mwenye njaa nasi tukakupa chakula, au ukiwa na kiu nasi tukakunywesha maji? ");
INSERT INTO swh1850_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni lini tulikuona ukiwa mgeni nasi tukakukaribisha, au bila nguo nasi tukakuvika? ");
INSERT INTO swh1850_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni lini tulikuona ukiwa mgonjwa au mfungwa nasi tukaja kukutazama? ");
INSERT INTO swh1850_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfalme atawajibu, Kweli nawaambieni, kila kitu mlichomtendea mmojawapo wa hawa ndugu zangu wadogo, mlinitendea mimi. ");
INSERT INTO swh1850_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kisha atawaambia wale walio upande wake wa kushoto, Ondokeni mbele yangu enyi mliolaaniwa! Nendeni katika moto wa milele aliotayarishiwa Ibilisi na malaika wake. ");
INSERT INTO swh1850_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maana nilikuwa na njaa nanyi hamkunipa chakula; nilikuwa na kiu nanyi hamkunipa maji. ");
INSERT INTO swh1850_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nilikuwa mgeni nanyi hamkunikaribisha; nilikuwa mgonjwa na mfungwa nanyi hamkuja kunitazama. ");
INSERT INTO swh1850_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hapo nao watajibu, Bwana, ni lini tulikuona ukiwa na njaa au kiu, ukiwa mgeni au bila nguo, ukiwa mgonjwa au mfungwa, nasi hatukuja kukuhudumia? ");
INSERT INTO swh1850_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naye atawajibu, Nawaambieni kweli, kila mlipokataa kumtendea mambo haya mmojawapo wa hawa wadogo, mlikataa kunitendea mimi. ");
INSERT INTO swh1850_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Basi, hawa watakwenda kwenye adhabu ya milele, lakini wale waadilifu watakwenda kwenye uzima wa milele.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu alipomaliza kusema hayo yote, aliwaambia wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mnajua kwamba baada ya siku mbili tutakuwa na sikukuu ya Pasaka, na Mwana wa Mtu atatolewa ili asulubiwe.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wakati huo makuhani wakuu na wazee wa watu walikutana pamoja katika ukumbi wa Kayafa, Kuhani Mkuu. ");
INSERT INTO swh1850_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wakashauriana jinsi ya kumtia Yesu nguvuni kwa hila wamuue. ");
INSERT INTO swh1850_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lakini wakaamua jambo hilo lisifanyike wakati wa sikukuu, kusije kukatokea ghasia kati ya watu. ");
INSERT INTO swh1850_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu alipokuwa Bethania, nyumbani kwa Simoni, aitwaye Mkoma, ");
INSERT INTO swh1850_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mama mmoja aliyekuwa na chupa ya alabasta yenye marashi ya thamani kubwa, alimjia pale mezani alipokuwa amekaa kula chakula, akammiminia hayo marashi kichwani. ");
INSERT INTO swh1850_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanafunzi wake walipoona hayo wakakasirika, wakasema, “Ya nini hasara hii? ");
INSERT INTO swh1850_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Marashi haya yangaliweza kuuzwa kwa bei kubwa, maskini wakapewa hizo fedha.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu alitambua mawazo yao, akawaambia, “Mbona mnamsumbua huyu mama? Yeye amenitendea jambo jema. ");
INSERT INTO swh1850_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maskini mnao daima pamoja nanyi, lakini mimi sitakuwapo pamoja nanyi daima. ");
INSERT INTO swh1850_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Huyu mama amenimiminia marashi ili kunitayarisha kwa maziko. ");
INSERT INTO swh1850_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nawaambieni kweli, popote ambapo hii Habari Njema itahubiriwa ulimwenguni, kitendo hiki alichofanya mama huyu kitatajwa kwa kumkumbuka yeye.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kisha, Yuda Iskarioti, mmoja wa wale kumi na wawili, akaenda kwa makuhani wakuu, ");
INSERT INTO swh1850_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akawaambia, “Mtanipa kitu gani kama nikimkabidhi Yesu kwenu?” Wakamhesabia sarafu thelathini za fedha; ");
INSERT INTO swh1850_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","na tangu wakati huo Yuda akawa anatafuta nafasi ya kumsaliti. ");
INSERT INTO swh1850_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Siku ya kwanza kabla ya Sikukuu ya Mikate Isiyotiwa Chachu, wanafunzi walimwendea Yesu wakamwuliza, “Unataka tukuandalie wapi chakula cha Pasaka?” ");
INSERT INTO swh1850_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeye akawajibu, “Nendeni mjini kwa mtu fulani, mkamwambie: Mwalimu anasema, wakati wangu umefika; kwako nitakula Pasaka pamoja na wanafunzi wangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanafunzi wakafanya kama Yesu alivyowaagiza, wakaandaa Pasaka. ");
INSERT INTO swh1850_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kulipokuwa jioni, Yesu akakaa mezani pamoja na wanafunzi wake kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Walipokuwa wakila, Yesu akasema, “Nawaambieni kweli, mmoja wenu atanisaliti.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanafunzi wakahuzunika sana, wakaanza kuuliza mmojammoja, “Bwana! Je, ni mimi?” ");
INSERT INTO swh1850_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu akajibu, “Atakayechovya mkate pamoja nami katika bakuli ndiye atakayenisaliti. ");
INSERT INTO swh1850_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naam, Mwana wa Mtu anakwenda zake kama Maandiko Matakatifu yasemavyo, lakini ole wake mtu yule atakayemsaliti Mwana wa Mtu! Ingalikuwa afadhali kwa mtu huyo kama hangalizaliwa.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ambaye ndiye aliyetaka kumsaliti, akamwuliza, “Mwalimu! Je, ni mimi?” Yesu akamjibu, “Wewe umesema.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Walipokuwa wanakula, Yesu akatwaa mkate, akashukuru, akaumega, akawapa wanafunzi wake akisema, “Twaeni mle; huu ni mwili wangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kisha akatwaa kikombe, akamshukuru Mungu, akawapa akisema, “Nyweni nyote; ");
INSERT INTO swh1850_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","maana hii ni damu yangu inayothibitisha agano, damu inayomwagwa kwa ajili ya watu wengi ili kuwaondolea dhambi. ");
INSERT INTO swh1850_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nawaambieni, sitakunywa tena divai ya zabibu mpaka siku ile nitakapoinywa mpya pamoja nanyi katika Ufalme wa Baba yangu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Baada ya kuimba wimbo, wakaondoka, wakaenda katika mlima wa Mizeituni. ");
INSERT INTO swh1850_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kisha Yesu akawaambia, “Usiku huu wa leo, ninyi nyote mtakuwa na mashaka nami, maana Maandiko Matakatifu yasema: Nitampiga mchungaji, na kondoo wa kundi watatawanyika. ");
INSERT INTO swh1850_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini baada ya kufufuka kwangu, nitawatangulieni Galilaya.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro akamwambia Yesu “Hata kama wote watakuwa na mashaka nawe na kukuacha, mimi sitakuacha kamwe.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu akamwambia, “Kweli nakwambia, usiku huu kabla jogoo hajawika, utanikana mara tatu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro akamwambia, “Hata kama ni lazima nife pamoja nawe, sitakukana kamwe.” Wale wanafunzi wengine wote wakasema vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kisha Yesu akaenda pamoja nao bustanini Gethsemane, akawaambia wanafunzi wake, “Kaeni hapa nami niende pale mbele kusali.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akawachukua Petro na wana wawili wa Zebedayo, akaanza kuwa na huzuni na mahangaiko. ");
INSERT INTO swh1850_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hapo akawaambia, “Nina huzuni kubwa moyoni hata karibu kufa. Kaeni hapa mkeshe pamoja nami.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Basi, akaenda mbele kidogo, akaanguka kifudifudi, akasali: “Baba yangu, kama inawezekana, aacha kikombe hiki cha mateso kinipite; lakini isiwe nitakavyo mimi, ila utakavyo wewe.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akawaendea wale wanafunzi, akawakuta wamelala. Akamwambia Petro, “Ndiyo kusema hamkuweza kukesha pamoja nami hata saa moja? ");
INSERT INTO swh1850_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kesheni na kusali ili msije mkaingia katika majaribu. Roho i tayari lakini mwili ni dhaifu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akaenda tena mara ya pili akasali: “Baba yangu, kama haiwezekani kikombe hiki kinipite bila mimi kukinywa, basi, mapenzi yako yafanyike.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akawaendea tena, akawakuta wamelala, maana macho yao yalikuwa yamebanwa na usingizi. ");
INSERT INTO swh1850_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Basi, akawaacha, akaenda tena kusali mara ya tatu kwa maneno yaleyale. ");
INSERT INTO swh1850_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kisha akawaendea wale wanafunzi, akawaambia, “Je, mngali mmelala na kupumzika? Tazameni! Saa yenyewe imefika, na Mwana wa Mtu atatolewa kwa watu wenye dhambi. ");
INSERT INTO swh1850_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amkeni, twendeni zetu. Tazameni! Anakuja yule atakayenisaliti.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Basi, Yesu alipokuwa bado anasema nao, mara akaja Yuda, mmoja wa wale kumi na wawili. Pamoja naye walikuja watu wengi wenye mapanga na marungu ambao walitumwa na makuhani wakuu na wazee wa watu. ");
INSERT INTO swh1850_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Huyo aliyetaka kumsaliti Yesu, alikuwa amekwisha wapa ishara akisema: “Yule nitakayembusu ndiye; mkamateni.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Basi, Yuda akamkaribia Yesu, akamwambia, “Shikamoo, Mwalimu!” Kisha akambusu. ");
INSERT INTO swh1850_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu akamwambia, “Rafiki, fanya ulichokuja kufanya.” Hapo wale watu wakaja, wakamkamata Yesu, wakamtia nguvuni. ");
INSERT INTO swh1850_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mmoja wa wale waliokuwa pamoja na Yesu akanyosha mkono, akauchomoa upanga wake, akampiga mtumishi wa Kuhani Mkuu, akamkata sikio. ");
INSERT INTO swh1850_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hapo Yesu akamwambia, “Rudisha upanga wako alani, maana yeyote anayeutumia upanga, atakufa kwa upanga. ");
INSERT INTO swh1850_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Je, hamjui kwamba ningeweza kumwomba Baba yangu naye mara angeniletea zaidi ya majeshi kumi na mawili ya malaika? ");
INSERT INTO swh1850_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini yatatimiaje Maandiko Matakatifu yasemayo kwamba ndivyo inavyopaswa kuwa?” ");
INSERT INTO swh1850_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wakati huohuo Yesu akauambia huo umati wa watu waliokuja kumtia nguvuni, “Je, mmekuja kunikamata kwa mapanga na marungu kama kwamba mimi ni mnyang'anyi? Kila siku nilikuwa Hekaluni nikifundisha, na hamkunikamata! ");
INSERT INTO swh1850_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini haya yote yametendeka ili Maandiko ya manabii yatimie.” Kisha wanafunzi wote wakamwacha, wakakimbia. ");
INSERT INTO swh1850_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Basi, hao watu waliomkamata Yesu walimpeleka nyumbani kwa Kayafa, Kuhani Mkuu, walikokusanyika walimu wa Sheria na wazee. ");
INSERT INTO swh1850_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro alimfuata kwa mbali mpaka uani kwa Kuhani Mkuu, akaingia ndani pamoja na walinzi ili apate kuona mambo yatakavyokuwa. ");
INSERT INTO swh1850_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basi, makuhani wakuu na Baraza lote wakatafuta ushahidi wa uongo dhidi ya Yesu wapate kumwua, ");
INSERT INTO swh1850_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","lakini hawakupata ushahidi wowote, ingawa walikuja mashahidi wengi wa uongo. Mwishowe wakaja mashahidi wawili, ");
INSERT INTO swh1850_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wakasema, “Mtu huyu alisema: Ninaweza kuliharibu Hekalu la Mungu na kulijenga tena kwa siku tatu.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kuhani Mkuu akasimama, akamwuliza Yesu, “Je, hujibu neno? Watu hawa wanashuhudia nini dhidi yako?” ");
INSERT INTO swh1850_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu akakaa kimya. Kuhani Mkuu akamwambia, “Nakuapisha kwa Mungu aliye hai, twambie kama wewe ndiwe Kristo, Mwana wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akamwambia, “Wewe umesema! Lakini nawaambieni, tangu sasa mtamwona Mwana wa Mtu ameketi upande wa kulia wa Mwenyezi, akija juu ya mawingu ya mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hapo, Kuhani Mkuu akararua mavazi yake, akasema, “Amekufuru! Tuna haja gani tena ya mashahidi? Sasa mmesikia kufuru yake. ");
INSERT INTO swh1850_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ninyi mwaonaje?” Wao wakamjibu, “Anastahili kufa!” ");
INSERT INTO swh1850_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kisha wakamtemea mate usoni, wakampiga makofi. Wengine wakiwa wanampiga makofi, ");
INSERT INTO swh1850_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wakasema, “Haya Kristo, tutabirie; ni nani amekupiga!” ");
INSERT INTO swh1850_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petro alikuwa ameketi nje uani. Basi, mtumishi mmoja wa kike akamwendea, akasema, “Wewe ulikuwa pamoja na Yesu wa Galilaya.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petro akakana mbele ya wote akisema, “Sijui hata unasema nini.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Alipokuwa akitoka mlangoni, mtumishi mwingine wa kike akamwona, akawaambia wale waliokuwa pale, “Mtu huyu alikuwa pamoja na Yesu wa Nazareti.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petro akakana tena kwa kiapo: “Simjui mtu huyo.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Baadaye kidogo, watu waliokuwa pale wakamwendea Petro, wakamwambia, “Hakika, wewe pia ni mmoja wao, maana msemo wako unakutambulisha.” ");
INSERT INTO swh1850_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hapo Petro akaanza kujilaani na kuapa akisema, “Simjui mtu huyo!” Mara jogoo akawika. ");
INSERT INTO swh1850_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petro akakumbuka maneno aliyoambiwa na Yesu: “Kabla jogoo hajawika, utanikana mara tatu.” Basi, akatoka nje akalia sana. ");
INSERT INTO swh1850_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kulipopambazuka, makuhani wakuu wote na wazee wa watu walifanya mashauri juu ya Yesu wapate kumwua. ");
INSERT INTO swh1850_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wakamfunga pingu, wakamchukua, wakamkabidhi kwa Pilato, mkuu wa mkoa. ");
INSERT INTO swh1850_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hapo, Yuda ambaye ndiye aliyemsaliti, alipoona kwamba wamekwisha mhukumu Yesu, akajuta, akawarudishia makuhani wakuu zile sarafu thelathini za fedha. ");
INSERT INTO swh1850_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akawaambia, “Nimekosa kwa kumtoa mtu asiye na hatia auawe.” Lakini wao wakasema, “Yatuhusu nini sisi? Hilo ni shauri lako.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naye akazitupa zile fedha Hekaluni, akatoka nje, akaenda akajinyonga. ");
INSERT INTO swh1850_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Makuhani wakuu wakazichukua zile fedha, wakasema, “Haifai kuziweka katika hazina ya Hekalu kwa maana ni fedha za damu.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Basi, wakashauriana, wakazitumia kununua shamba la mfinyanzi liwe mahali pa kuzika wageni. ");
INSERT INTO swh1850_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndiyo maana mpaka leo shamba hilo linaitwa Shamba la Damu. ");
INSERT INTO swh1850_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hivyo maneno ya nabii Yeremia yakatimia: “Walizichukua sarafu thelathini za fedha, thamani ya yule ambaye watu wa Israeli walipanga bei, ");
INSERT INTO swh1850_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","wakanunua nazo shamba la mfinyanzi, kama Bwana alivyoniagiza.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu alisimamishwa mbele ya mkuu wa mkoa. Basi, mkuu wa mkoa akamwuliza, “Je, wewe ndiwe Mfalme wa Wayahudi?” Yesu akamwambia, “Wewe umesema.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini makuhani wakuu na wazee walipokuwa wanamshtaki, hakujibu neno. ");
INSERT INTO swh1850_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hivyo Pilato akamwuliza, “Je, husikii mashtaka hayo yote wanayotoa juu yako?” ");
INSERT INTO swh1850_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini Yesu hakumjibu hata neno moja; hata huyo mkuu wa mkoa akashangaa sana. ");
INSERT INTO swh1850_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ilikuwa kawaida wakati wa Sikukuu ya Pasaka mkuu wa mkoa kuwafungulia Wayahudi mfungwa mmoja waliyemtaka. ");
INSERT INTO swh1850_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wakati huo kulikuwa na mfungwa mmoja, jina lake Baraba. ");
INSERT INTO swh1850_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hivyo, watu walipokusanyika pamoja, Pilato akawauliza, “Mwataka nimfungue yupi kati ya wawili hawa, Baraba ama Yesu aitwae Kristo?” ");
INSERT INTO swh1850_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Alisema hivyo maana alijua wazi kwamba walimleta kwake kwa sababu ya wivu. ");
INSERT INTO swh1850_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato alipokuwa amekaa katika kiti cha hukumu, mke wake akampelekea ujumbe: “Usijitie katika shauri la mtu huyu mwema, maana leo nimeteseka sana katika ndoto kwa sababu yake.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakini makuhani wakuu na wazee wakawashawishi watu waombe Baraba afunguliwe na Yesu auawe. ");
INSERT INTO swh1850_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mkuu wa mkoa akawauliza, “Ni yupi kati ya hawa wawili mnayetaka nimfungue?” Wakamjibu, “Baraba!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato akawauliza, “Sasa, nifanye nini na Yesu aitwaye Kristo?” Wote wakasema, “Asulubiwe!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato akauliza, “Kwa nini? Amefanya kosa gani?” Wao wakazidi kupaaza sauti: “Asulubiwe!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Basi, Pilato alipotambua kwamba hafanikiwi chochote na kwamba maasi yalikuwa yanaanza, alichukua maji, akanawa mikono mbele ya ule umati wa watu, akasema, “Mimi sina lawama juu ya kifo cha mtu huyu; shauri lenu wenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Watu wote wakasema, “Damu yake na iwe juu yetu na juu ya watoto wetu!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hapo Pilato akawafungulia Baraba kutoka gerezani, lakini akamtoa Yesu asulubiwe. ");
INSERT INTO swh1850_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kisha askari wa mkuu wa mkoa wakamwingiza Yesu ndani ya ikulu, wakamkusanyikia kikosi kizima. ");
INSERT INTO swh1850_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wakamvua nguo zake, wakamvika joho la rangi nyekundu. ");
INSERT INTO swh1850_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kisha wakasokota taji ya miiba, wakamvika kichwani, wakamwekea pia mwanzi katika mkono wake wa kulia. Wakapiga magoti mbele yake, wakamdhihaki wakisema, “Shikamoo mfalme wa Wayahudi!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wakamtemea mate, wakauchukua ule mwanzi, wakampiga nao kichwani. ");
INSERT INTO swh1850_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baada ya kumdhihaki, wakamvua lile joho, wakamvika nguo zake, kisha wakampeleka kumsulubisha. ");
INSERT INTO swh1850_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Walipokuwa wakienda, wakamkuta mtu mmoja jina lake Simoni, mwenyeji wa Kurene, wakamlazimisha kuuchukua msalaba wake Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Walipofika mahali paitwapo Golgotha, maana yake, “Mahali pa Fuvu la kichwa,” ");
INSERT INTO swh1850_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wakampa mchanganyiko wa divai na nyongo. Lakini Yesu alipoonja akakataa kunywa. ");
INSERT INTO swh1850_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Walimsulubisha, kisha wakagawana mavazi yake kwa kuyapigia kura. ");
INSERT INTO swh1850_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wakaketi, wakawa wanamchunga. ");
INSERT INTO swh1850_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Juu ya kichwa chake wakaweka shtaka dhidi yake lilioandikwa, “Huyu ni Yesu, Mfalme wa Wayahudi.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wanyang'anyi wawili walisulubishwa pia pamoja naye, mmoja upande wa kushoto na mwingine upande wa kulia. ");
INSERT INTO swh1850_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Watu waliokuwa wanapita mahali hapo walimtukana wakitikisa vichwa vyao na kusema, ");
INSERT INTO swh1850_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wewe! Si ulijidai kulivunja Hekalu na kulijenga kwa siku tatu? Sasa jiokoe mwenyewe. Kama wewe ni Mwana wa Mungu, basi shuka msalabani!” ");
INSERT INTO swh1850_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hali kadhalika na makuhani wakuu pamoja na walimu wa Sheria na wazee walimdhihaki wakisema, ");
INSERT INTO swh1850_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aliwaokoa wengine, lakini kujiokoa mwenyewe hawezi! Eti yeye ni mfalme wa Wayahudi! Basi, sasa na ashuke msalabani, nasi tutamwamini. ");
INSERT INTO swh1850_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Alimtumainia Mungu na kusema eti yeye ni Mwana wa Mungu; basi, Mungu na amwokoe kama anamtaka.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hali kadhalika na wale waliosulubiwa pamoja naye wakamtukana. ");
INSERT INTO swh1850_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tangu saa sita mchana mpaka saa tisa, nchi yote ikawa katika giza. ");
INSERT INTO swh1850_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mnamo saa tisa Yesu akalia kwa sauti kubwa, “Eli, Eli, lema sabakthani?” Maana yake, “Mungu wangu, Mungu wangu, mbona umeniacha?” ");
INSERT INTO swh1850_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lakini wale waliosimama pale waliposikia hivyo wakasema, “Anamwita Eliya.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mmoja wao akakimbia, akachukua sifongo, akaichovya katika siki, akaiweka juu ya mwanzi, akampa anywe. ");
INSERT INTO swh1850_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wengine wakasema, “Acha tuone kama Eliya anakuja kumwokoa.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Basi, Yesu akalia tena kwa sauti kubwa, akakata roho. ");
INSERT INTO swh1850_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hapo pazia la Hekalu likapasuka vipande viwili, toka juu mpaka chini; nchi ikatetemeka; miamba ikapasuka; ");
INSERT INTO swh1850_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","makaburi yakafunguka na watu wengi wa Mungu waliokufa wakafufuliwa; ");
INSERT INTO swh1850_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","nao, baada ya kufufuka kwake, wakatoka makaburini, wakaingia katika Mji Mtakatifu, wakaonekana na watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Basi, jemadari na wale waliokuwa wakimlinda Yesu walipoona tetemeko la ardhi na yale mambo yaliyotukia, wakaogopa sana, wakasema, “Hakika mtu huyu alikuwa Mwana wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mahali hapo walikuwapo wanawake wengi wakitazama kwa mbali. Hao ndio wale waliomfuata Yesu kutoka Galilaya wakimtumikia. ");
INSERT INTO swh1850_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Miongoni mwao walikuwa Maria Magdalene, Maria mama yao Yakobo na Yosefu, pamoja na mama yao wana wa Zebedayo. ");
INSERT INTO swh1850_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ilipokuwa jioni, akaja mtu mmoja tajiri mwenyeji wa Armathaya, jina lake Yosefu. Yeye pia alikuwa mwanafunzi wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Akamwendea Pilato, akaomba apewe mwili wa Yesu. Basi, Pilato akaamuru apewe. ");
INSERT INTO swh1850_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosefu akauchukua ule mwili akauzungushia sanda safi ya kitani, ");
INSERT INTO swh1850_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","akauweka ndani ya kaburi lake jipya alilokuwa amelichonga katika mwamba. Kisha akavingirisha jiwe kubwa mbele ya mlango wa kaburi, akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalene na yule Maria mwingine walikuwa wameketi kulielekea kaburi. ");
INSERT INTO swh1850_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kesho yake, yaani siku iliyofuata ile ya Maandalio, makuhani wakuu na Mafarisayo walimwendea Pilato, ");
INSERT INTO swh1850_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wakasema, “Mheshimiwa, tunakumbuka kwamba yule mdanganyifu alisema kabla ya kufa ati, Baada ya siku tatu nitafufuka. ");
INSERT INTO swh1850_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa hiyo amuru kaburi lilindwe mpaka siku ya tatu ili wanafunzi wake wasije wakamwiba na kuwaambia watu kwamba amefufuka. Uongo huu wa mwisho utakuwa mbaya kuliko ule wa awali.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato akawaambia, “Haya, mnao walinzi; nendeni mkalinde kadiri mjuavyo.” ");
INSERT INTO swh1850_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basi, wakaenda, wakalilinda kaburi, wakatia mhuri juu ya lile jiwe na kuacha hapo askari walinzi. ");
INSERT INTO swh1850_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Baada ya Sabato, karibu na mapambazuko ya siku ile ya Jumapili, Maria Magdalene na yule Maria mwingine walikwenda kutazama lile kaburi. ");
INSERT INTO swh1850_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ghafla kutatokea tetemeko kubwa la nchi; malaika wa Bwana alishuka kutoka mbinguni, akalivingirisha lile jiwe, akalikalia. ");
INSERT INTO swh1850_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Alionekana kama umeme na mavazi yake yalikuwa meupe kama theluji. ");
INSERT INTO swh1850_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Walinzi wa lile kaburi wakatetemeka kwa hofu kubwa, hata wakawa kama wamekufa. ");
INSERT INTO swh1850_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lakini yule malaika akawaambia wale wanawake, “Ninyi msiogope! Najua kwamba mnamtafuta Yesu aliyesulubiwa. ");
INSERT INTO swh1850_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hayupo hapa maana amefufuka kama alivyosema. Njoni mkaone mahali alipokuwa amelala. ");
INSERT INTO swh1850_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Basi, nendeni upesi mkawaambie wanafunzi wake kwamba amefufuka kutoka wafu, na sasa anawatangulieni kule Galilaya; huko mtamwona. Haya, mimi nimekwisha waambieni.” ");
INSERT INTO swh1850_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wakiwa wenye hofu na furaha kubwa, hao wanawake walitoka upesi kaburini, wakakimbia kwenda kuwaambia wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mara, Yesu akakutana nao, akawasalimu: “Salamu.” Hao wanawake wakamwendea, wakapiga magoti mbele yake, wakashika miguu yake. ");
INSERT INTO swh1850_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kisha Yesu akawaambia, “Msiogope! Nendeni mkawaambie ndugu zangu waende Galilaya, na huko wataniona.” ");
INSERT INTO swh1850_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wale wanawake walipokuwa wanakwenda zao, baadhi ya walinzi wa lile kaburi walikwenda mjini kutoa taarifa kwa makuhani wakuu juu ya mambo yote yaliyotukia. ");
INSERT INTO swh1850_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Basi, wakakutana pamoja na wazee, na baada ya kushauriana, wakawapa wale askari kiasi kikubwa cha fedha ");
INSERT INTO swh1850_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wakisema, “Ninyi mtasema hivi: Wanafunzi wake walikuja usiku, wakamwiba sisi tukiwa tumelala. ");
INSERT INTO swh1850_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na kama mkuu wa mkoa akijua jambo hili, sisi tutasema naye na kuhakikisha kuwa ninyi hamtapata matatizo.” ");
INSERT INTO swh1850_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wale walinzi wakazichukua zile fedha, wakafanya kama walivyofundishwa. Habari hiyo imeenea kati ya Wayahudi mpaka leo. ");
INSERT INTO swh1850_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wale wanafunzi kumi na mmoja walikwenda Galilaya kwenye ule mlima aliowaagiza Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Walipomwona, wakamwabudu, ingawa wengine walikuwa na mashaka. ");
INSERT INTO swh1850_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akaja karibu, akawaambia, “Nimepewa mamlaka yote mbinguni na duniani. ");
INSERT INTO swh1850_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nendeni basi, mkawafanye watu wa mataifa yote wawe wanafunzi wangu; mkiwabatiza kwa jina la Baba, na la Mwana, na la Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wafundisheni kushika maagizo yote niliyowapeni. Nami nipo pamoja nanyi siku zote; naam, mpaka mwisho wa nyakati.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Habari Njema ya Yesu Kristo, Mwana wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ilianza kama ilivyoandikwa katika kitabu cha nabii Isaya: “Tazama, namtuma mjumbe wangu akutangulie; yeye atakutayarishia njia yako. ");
INSERT INTO swh1850_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sauti ya mtu imesikika jangwani: Mtayarishieni Bwana njia yake, nyoosheni mapito yake.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohane Mbatizaji alitokea jangwani, akahubiri kwamba ni lazima watu watubu na kubatizwa ili Mungu awasamehe dhambi zao. ");
INSERT INTO swh1850_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Watu kutoka sehemu zote za Yudea na wenyeji wote wa Yerusalemu walimwendea, wakaziungama dhambi zao, naye akawabatiza katika mto Yordani. ");
INSERT INTO swh1850_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane alikuwa amevaa vazi lililofumwa kwa manyoya ya ngamia, na mkanda wa ngozi kiunoni mwake. Chakula chake kilikuwa nzige na asali ya mwituni. ");
INSERT INTO swh1850_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naye alihubiri akisema, “Baada yangu anakuja mwenye uwezo zaidi kuliko mimi, ambaye mimi sistahili hata kuinama na kufungua kamba za viatu vyake. ");
INSERT INTO swh1850_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mimi ninawabatiza kwa maji, lakini yeye atawabatiza kwa Roho Mtakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Siku hizo, Yesu alifika kutoka Nazareti, mji wa Galilaya, akabatizwa na Yohane katika mto Yordani. ");
INSERT INTO swh1850_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mara tu alipotoka majini, aliona mbingu zimefunguliwa, na Roho akishuka juu yake kama njiwa. ");
INSERT INTO swh1850_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sauti ikasikika kutoka mbinguni: “Wewe ni Mwanangu mpendwa, nimependezwa nawe.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mara akaongozwa na Roho kwenda jangwani, ");
INSERT INTO swh1850_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","akakaa huko siku arubaini akijaribiwa na Shetani. Alikuwa huko pamoja na wanyama wa porini, nao malaika wakawa wanamtumikia. ");
INSERT INTO swh1850_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohane alipokwisha fungwa gerezani, Yesu alikwenda Galilaya, akahubiri Habari Njema ya Mungu, akisema, ");
INSERT INTO swh1850_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Wakati umetimia, na Ufalme wa Mungu umekaribia. Tubuni na kuiamini Habari Njema!” ");
INSERT INTO swh1850_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Alipokuwa anapita kando ya ziwa Galilaya, aliwaona wavuvi wawili: Simoni na Andrea ndugu yake wakivua samaki kwa wavu. ");
INSERT INTO swh1850_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu akawaambia, “Nifuateni nami nitawafanya ninyi wavuvi wa watu.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mara wakaziacha nyavu zao, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Alipokwenda mbele kidogo, aliwaona Yakobo na Yohane, wana wa Zebedayo. Nao pia walikuwa ndani ya mashua yao wakizitengeneza nyavu zao. ");
INSERT INTO swh1850_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu akawaita mara, nao wakamwacha baba yao Zebedayo katika mashua pamoja na wafanyakazi, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wakafika mjini Kafarnaumu, na mara ilipofika Sabato, Yesu akaingia katika Sunagogi, akaanza kufundisha. ");
INSERT INTO swh1850_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Watu wote waliomsikia walishangazwa na mafundisho yake, maana hakuwa anafundisha kama walimu wao wa Sheria, bali kama mtu mwenye mamlaka. ");
INSERT INTO swh1850_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mara akatokea mle ndani ya sunagogi mtu mmoja mwenye pepo mchafu, ");
INSERT INTO swh1850_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akapaaza sauti, “Una nini nasi, wewe Yesu wa Nazareti? Je, umekuja kutuangamiza? Najua wewe ni nani: wewe ni Mtakatifu wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu akamkemea, “Nyamaza! Mtoke mtu huyu.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Basi, huyo pepo mchafu akamtikisatikisa mtu huyo, kisha akalia kwa sauti kubwa, akamtoka. ");
INSERT INTO swh1850_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Watu wote wakashangaa, wakaulizana, “Ni mambo gani haya? Je, ni mafundisho mapya? Mtu huyu anayo mamlaka ya kuamuru hata pepo wachafu, nao wanamtii!” ");
INSERT INTO swh1850_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Habari za Yesu zikaenea upesi kila mahali katika wilaya ya Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wakatoka katika sunagogi, wakaenda moja kwa moja hadi nyumbani kwa Simoni na Andrea; Yakobo na Yohane walikwenda pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Basi, mama mmoja, mkwewe Simoni, alikuwa kitandani ana homa kali. Wakamwarifu Yesu mara alipowasili. ");
INSERT INTO swh1850_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu akamwendea huyo mama, akamshika mkono, akamwinua. Na ile homa ikamwacha, akaanza kuwatumikia. ");
INSERT INTO swh1850_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jioni, jua lilipokwisha tua, wakamletea Yesu wagonjwa wote na watu waliopagawa na pepo. ");
INSERT INTO swh1850_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Watu wote wa mji ule wakakusanyika nje ya mlango. ");
INSERT INTO swh1850_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Naye Yesu akawaponya watu wengi waliokuwa na magonjwa mbalimbali; aliwafukuza pepo wengi, lakini hakuwaruhusu kusema kitu maana walikuwa wanamjua yeye ni nani. ");
INSERT INTO swh1850_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kesho yake, kabla ya mapambazuko, Yesu alitoka, akaenda mahali pa faragha kusali. ");
INSERT INTO swh1850_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na wenzake wakaenda kumtafuta. ");
INSERT INTO swh1850_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Walipomwona wakamwambia, “Kila mtu anakutafuta.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu akawaambia, “Twendeni katika miji mingine ya jirani nikahubiri huko pia, maana nimekuja kwa sababu hiyo.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basi, akaenda kila mahali Galilaya akihubiri katika masunagogi na kufukuza pepo. ");
INSERT INTO swh1850_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mtu mmoja mwenye ukoma alimwendea Yesu, akapiga magoti, akamwomba, “Ukitaka, waweza kunitakasa!” ");
INSERT INTO swh1850_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu akamwonea huruma, akanyosha mkono wake, akamgusa na kumwambia, “Nataka, takasika!” ");
INSERT INTO swh1850_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mara ukoma ukamwacha mtu huyo, akatakasika. ");
INSERT INTO swh1850_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kisha Yesu akamwambia aende zake upesi na kumwonya vikali, ");
INSERT INTO swh1850_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Usimwambie mtu yeyote jambo hili, ila nenda ukajionyeshe kwa kuhani; kisha utoe sadaka kwa ajili ya kutakasika kwako kama alivyoamuru Mose, iwe uthibitisho kwao kwamba umepona.” ");
INSERT INTO swh1850_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini huyo mtu akaenda, akaanza kueneza habari hiyo kila mahali na kusema mambo mengi hata Yesu hakuweza tena kuingia katika mji wowote waziwazi; ikamlazimu kukaa nje, mahali pa faragha. Hata hivyo, watu wakamwendea kutoka kila upande. ");
INSERT INTO swh1850_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Baada ya siku kadhaa, Yesu alirudi Kafarnaumu, watu wakapata habari kwamba alikuwa nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Basi, wakaja watu wengi sana hata nafasi yoyote ikakosekana mlangoni. Yesu alikuwa akiwahubiria ujumbe wake, ");
INSERT INTO swh1850_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","wakati mtu mmoja aliyepooza alipoletwa kwake akiwa amechukuliwa na watu wanne. ");
INSERT INTO swh1850_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwa sababu ya huo umati wa watu, hawakuweza kumpeleka karibu na Yesu. Basi, wakatoboa sehemu ya dari iliyokuwa juu ya mahali alipokuwa Yesu. Walipokwisha pata nafasi, wakamteremsha huyo mtu akiwa amelala juu ya mkeka. ");
INSERT INTO swh1850_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu alipoona imani yao, akamwambia huyo mtu aliyepooza, “Mwanangu, umesamehewa dhambi zako.” ");
INSERT INTO swh1850_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Baadhi ya walimu wa Sheria waliokuwa wameketi hapo wakawaza mioyoni mwao, ");
INSERT INTO swh1850_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anathubutuje kusema hivyo? Anamkufuru Mungu! Hakuna mtu awezaye kusamehe dhambi isipokuwa Mungu peke yake.” ");
INSERT INTO swh1850_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu alitambua mara mawazo yao, akawaambia, “Mbona mnawaza hivyo mioyoni mwenu? ");
INSERT INTO swh1850_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni lipi lililo rahisi zaidi: kumwambia mtu huyu aliyepooza, Umesamehewa dhambi zako, au kumwambia, Inuka! Chukua mkeka wako utembee? ");
INSERT INTO swh1850_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Basi, nataka mjue kwamba Mwana wa Mtu anayo mamlaka ya kuwasamehe watu dhambi duniani.” Hapo akamwambia huyo mtu aliyepooza, ");
INSERT INTO swh1850_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nakwambia simama, chukua mkeka wako uende nyumbani!” ");
INSERT INTO swh1850_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mara, watu wote wakiwa wanamtazama, huyo mtu akainuka, akauchukua mkeka wake, akaenda zake. Watu wote wakashangaa na kumtukuza Mungu wakisema, “Hatujapata kamwe kuona jambo kama hili.” ");
INSERT INTO swh1850_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu alikwenda tena kando ya ziwa. Umati wa watu ukamwendea, naye akaanza kuwafundisha. ");
INSERT INTO swh1850_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Alipokuwa akipita, akamwona Lawi mwana wa Alfayo, ameketi katika ofisi ya ushuru. Yesu akamwambia, “Nifuate!” Lawi akasimama, akamfuata. ");
INSERT INTO swh1850_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Baadaye, Yesu alikuwa amekaa mezani, nyumbani kwa Lawi, kula chakula. Watoza ushuru wengi na wenye dhambi walikuwa wamemfuata Yesu na wengi wao wakawa wamekaa mezani pamoja naye na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Basi, baadhi ya walimu wa Sheria ambao walikuwa Mafarisayo walipomwona Yesu akila pamoja na watu wenye dhambi na watoza ushuru, wakawauliza wanafunzi wake, “Kwa nini anakula pamoja na watoza ushuru na wenye dhambi?” ");
INSERT INTO swh1850_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu alipowasikia, akawaambia, “Watu wenye afya hawahitaji daktari; wanaomhitaji ni wale walio wagonjwa. Sikuja kuwaita watu wema, ila wenye dhambi.” ");
INSERT INTO swh1850_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wakati mmoja wanafunzi wa Yohane na wanafunzi wa Mafarisayo walikuwa wanafunga. Basi, watu wakaja, wakamwuliza Yesu, “Kwa nini wanafunzi wa Yohane na wa Mafarisayo wanafunga, lakini wanafunzi wako hawafungi?” ");
INSERT INTO swh1850_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akajibu, “Walioalikwa harusini wanawezaje kufunga kama bwana harusi yupo pamoja nao? Wakati wote wawapo pamoja na bwana harusi hawawezi kufunga. ");
INSERT INTO swh1850_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini wakati utafika ambapo bwana harusi ataondolewa kati yao; wakati huo ndipo watakapofunga. ");
INSERT INTO swh1850_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hakuna mtu anayekata kiraka kutoka katika nguo mpya na kukishonea katika nguo kuukuu. Kama akifanya hivyo, hicho kiraka kipya kitararuka kutoka hilo vazi kuukuu, nalo litaharibika zaidi. ");
INSERT INTO swh1850_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wala hakuna mtu atiaye divai mpya katika viriba vikuukuu. Kama akifanya hivyo, divai itavipasua hivyo viriba, nayo divai pamoja na hivyo viriba vitaharibika. Divai mpya hutiwa katika viriba vipya!” ");
INSERT INTO swh1850_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Siku moja ya Sabato, Yesu alikuwa anapita katika mashamba ya ngano. Walipokuwa wanatembea, wanafunzi wake wakaanza kukwanyua masuke ya ngano. ");
INSERT INTO swh1850_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafarisayo wakawaambia, “Tazama! Kwa nini wanafanya jambo ambalo si halali kufanya wakati wa Sabato?” ");
INSERT INTO swh1850_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu akawajibu, “Je, hamjapata kusoma juu ya kile alichofanya Daudi wakati alipohitaji chakula? Yeye pamoja na wenzake waliona njaa, ");
INSERT INTO swh1850_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","naye akaingia ndani ya Nyumba ya Mungu, akala ile mikate iliyowekwa mbele ya Mungu. Jambo hili lilifanyika wakati Abiathari alikuwa Kuhani Mkuu. Na ni makuhani tu peke yao waliokuwa wameruhusiwa kula mikate hiyo. Lakini Daudi aliila, tena akawapa na wenzake.” ");
INSERT INTO swh1850_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Basi, Yesu akawaambia, “Sabato iliwekwa kwa ajili ya binadamu na si binadamu kwa ajili ya Sabato! ");
INSERT INTO swh1850_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kwa hiyo, Mwana wa Mtu ni Bwana hata wa Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu aliingia tena katika sunagogi na mle ndani mlikuwa na mtu aliyekuwa na mkono uliopooza. ");
INSERT INTO swh1850_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Humo baadhi ya watu walimngojea amponye mtu huyo siku ya sabato ili wapate kumshtaki. ");
INSERT INTO swh1850_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu akamwambia huyo mtu aliyekuwa na mkono uliopooza, “Njoo hapa katikati.” ");
INSERT INTO swh1850_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kisha, akawauliza, “Je, ni halali siku ya Sabato kutenda jambo jema au kutenda jambo baya; kuokoa maisha au kuua?” Lakini wao hawakusema neno. ");
INSERT INTO swh1850_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hapo akawatazama wote kwa hasira, akaona huzuni kwa sababu ya ugumu wa mioyo yao. Kisha akamwambia huyo mtu, “Nyosha mkono wako!” Naye akaunyosha mkono wake, ukawa mzima tena. ");
INSERT INTO swh1850_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mara Mafarisayo wakatoka nje, wakafanya shauri pamoja na watu wa kikundi cha Herode jinsi ya kumwangamiza Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu aliondoka hapo pamoja na wanafunzi wake, akaenda kando ya ziwa, na umati wa watu ukamfuata. Watu hao walikuwa wametoka Yerusalemu, Yudea, ");
INSERT INTO swh1850_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Idumea, ng'ambo ya mto Yordani, Tiro na Sidoni. Watu hao wengi walimwendea Yesu kwa sababu ya kusikia mambo mengi aliyokuwa ameyatenda. ");
INSERT INTO swh1850_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu akawaambia wanafunzi wake wamtayarishie mashua moja, ili umati wa watu usije ukamsonga. ");
INSERT INTO swh1850_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Alikuwa amewaponya watu wengi, na wagonjwa wote wakawa wanamsonga ili wapate kumgusa. ");
INSERT INTO swh1850_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na watu waliokuwa wamepagawa na pepo wachafu walipomwona, walijitupa chini mbele yake na kupaaza sauti, “Wewe ni Mwana wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakini Yesu akawaamuru kwa ukali wasimjulishe kwa watu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu alipanda kilimani, akawaita wale aliowataka. Basi, wakamwendea, ");
INSERT INTO swh1850_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","naye akawateua watu kumi na wawili ambao aliwaita mitume, wakae naye, awatume kuhubiri ");
INSERT INTO swh1850_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na wawe na mamlaka ya kuwafukuza pepo. ");
INSERT INTO swh1850_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Basi, hao kumi na wawili walioteuliwa ndio hawa: Simoni (ambaye Yesu alimpa jina, Petro), ");
INSERT INTO swh1850_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na Yohane, wana wa Zebedayo (Yesu aliwapa hawa ndugu wawili jina Boanerge, maana yake “wanangurumo”), ");
INSERT INTO swh1850_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea na Filipo, Batholomayo, Mathayo, Thoma, Yakobo mwana wa Alfayo, Thadayo, Simoni Mkanani na ");
INSERT INTO swh1850_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda Iskarioti ambaye alimsaliti Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kisha Yesu alikwenda nyumbani. Umati wa watu ukakusanyika tena, hata Yesu na wafuasi wake wasiweze kupata nafasi ya kula chakula. ");
INSERT INTO swh1850_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Basi, watu wa jamaa yake walipopata habari hiyo wakatoka kwenda kumchukua maana walikuwa wanasema kwamba amepatwa na wazimu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nao walimu wa Sheria waliokuwa wametoka Yerusalemu, wakasema, “Ana Beelzebuli! Tena, anawafukuza pepo kwa nguvu ya mkuu wa pepo.” ");
INSERT INTO swh1850_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hapo Yesu akawaita, akawaambia kwa mifano, “Shetani anawezaje kumfukuza Shetani? ");
INSERT INTO swh1850_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ikiwa utawala mmoja umegawanyika makundimakundi yanayopigana, utawala huo hauwezi kudumu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tena, ikiwa jamaa moja imegawanyika makundimakundi yanayopingana, jamaa hiyo itaangamia. ");
INSERT INTO swh1850_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ikiwa basi, utawala wa Shetani umegawanyika vikundivikundi hauwezi kudumu, bali utaangamia kabisa. ");
INSERT INTO swh1850_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hakuna mtu awezaye kuivamia nyumba ya mtu mwenye nguvu na kumnyang'anya mali yake, isipokuwa kwanza amemfunga huyo mtu mwenye nguvu; hapo ndipo atakapoweza kumnyang'anya mali yake. ");
INSERT INTO swh1850_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kweli nawaambieni, watu watasamehewa dhambi zao zote na kufuru zao zote; ");
INSERT INTO swh1850_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lakini anayesema mabaya dhidi ya Roho Mtakatifu, hatasamehewa kamwe; ana hatia ya dhambi ya milele.” ");
INSERT INTO swh1850_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Yesu alisema hivyo kwa sababu walikuwa wanasema, “Ana pepo mchafu.”) ");
INSERT INTO swh1850_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mama yake Yesu na ndugu zake walifika hapo, wakasimama nje, wakampelekea ujumbe kutaka kumwona. ");
INSERT INTO swh1850_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Umati wa watu ulikuwa umekaa hapo kumzunguka. Basi, wakamwambia, “Mama yako na ndugu zako wako nje, wanataka kukuona.” ");
INSERT INTO swh1850_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu akawaambia, “Mama yangu na ndugu zangu ni kina nani?” ");
INSERT INTO swh1850_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hapo akawatazama watu waliokuwa wamemzunguka, akasema, “Tazameni! Hawa ndio mama yangu na ndugu zangu. ");
INSERT INTO swh1850_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mtu yeyote anayefanya anayotaka Mungu, huyo ndiye kaka yangu, dada yangu na mama yangu.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu alianza kufundisha tena akiwa kando ya ziwa. Umati mkubwa wa watu ulimzunguka hata ikambidi aingie katika mashua na kuketi. Watu wakawa wamekaa katika nchi kavu, kando ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aliwafundisha mambo mengi kwa mifano, na katika mafundisho yake aliwaambia, ");
INSERT INTO swh1850_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sikilizeni! Mpanzi alikwenda kupanda mbegu. ");
INSERT INTO swh1850_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Alipokuwa akipanda, nyingine zilianguka njiani, ndege wakaja wakazila. ");
INSERT INTO swh1850_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nyingine zilianguka penye mawe pasipokuwa na udongo mwingi. Mbegu hizo ziliota mara kwa kuwa udongo haukuwa na kina. ");
INSERT INTO swh1850_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jua lilipochomoza, zikachomeka; na kwa kuwa mizizi yake haikuwa na nguvu, zikanyauka. ");
INSERT INTO swh1850_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nyingine zilianguka kwenye miti ya miiba, nayo ikakua na kuzisonga, nazo hazikuzaa nafaka. ");
INSERT INTO swh1850_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nyingine zilianguka katika udongo mzuri, zikakua na kuzaa: moja punje thelathini, moja sitini na nyingine mia.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kisha akawaambia, “Mwenye masikio na asikie!” ");
INSERT INTO swh1850_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu alipokuwa peke yake, baadhi ya wale waliomsikia walimwendea pamoja na wale kumi na wawili, wakamwuliza juu ya hiyo mifano. ");
INSERT INTO swh1850_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naye akawaambia, “Ninyi mmejaliwa kujua siri ya Utawala wa Mungu, lakini wale walio nje wataambiwa kila kitu kwa mifano, ");
INSERT INTO swh1850_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ili, Watazame kweli, lakini wasione. Wasikie kweli, lakini wasielewe. La sivyo, wangemgeukia Mungu, naye angewasamehe.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Basi, Yesu akawauliza, “Je, ninyi hamwelewi mfano huu? Mtawezaje basi, kuelewa mfano wowote? ");
INSERT INTO swh1850_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpanzi hupanda neno la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Watu wengine ni kama wale walio njiani ambapo mbegu zilianguka. Hawa hulisikia hilo neno lakini mara Shetani huja na kuliondoa neno hilo lililopandwa ndani yao. ");
INSERT INTO swh1850_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Watu wengine ni kama zile mbegu zilizopandwa penye mawe. Mara tu wanapolisikia hilo neno hulipokea kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lakini haliwaingii na kuwa na mizizi ndani yao; huendelea kulizingatia kwa kitambo tu, na wakati taabu au udhalimu vinapotokea kwa sababu ya hilo neno mara wanakata tamaa. ");
INSERT INTO swh1850_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Watu wengine ni kama zile mbegu zilizoanguka penye miti ya miiba. Huo ni mfano wa wale wanaolisikia hilo neno, ");
INSERT INTO swh1850_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lakini wasiwasi wa ulimwengu huu, anasa za mali na tamaa za kila namna huwaingia na kulisonga hilo neno, nao hawazai matunda. ");
INSERT INTO swh1850_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lakini wengine ni kama zile mbegu zilizopandwa katika udongo mzuri. Hawa hulisikia hilo neno, wakalipokea, wakazaa matunda: wengine thelathini, wengine sitini na wengine mia moja.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu akaendelea kuwaambia, “Je, watu huwasha taa wakaileta ndani na kuifunika kwa pishi au kuiweka mvunguni? La! Huiweka juu ya kinara. ");
INSERT INTO swh1850_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Basi, kila kilichofichwa kitafichuliwa, na kila kilichofunikwa kitafunuliwa. ");
INSERT INTO swh1850_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mwenye masikio na asikie!” ");
INSERT INTO swh1850_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akawaambia pia, “Sikilizeni kwa makini mnachosikia! Kipimo kilekile mnachowapimia watu wengine, ndicho mtakachopimiwa; tena mtazidishiwa. ");
INSERT INTO swh1850_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aliye na kitu atapewa zaidi; asiye na kitu, hata kile alicho nacho kitachukuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu akaendelea kusema, “Ufalme wa Mungu ni kama ifuatavyo. Mtu hupanda mbegu shambani. ");
INSERT INTO swh1850_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Usiku hulala, mchana yu macho na wakati huo mbegu zinaota na kukua; yeye hajui inavyofanyika. ");
INSERT INTO swh1850_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Udongo wenyewe huiwezesha mimea kukua na kuzaa matunda: kwanza huchipua jani changa, kisha suke, na mwishowe nafaka ndani ya suke. ");
INSERT INTO swh1850_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nafaka inapoiva, huyo mtu huanza kutumia mundu wake, maana wakati wa mavuno umefika.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tena, Yesu akasema, “Tuufananishe Utawala wa Mungu na nini? Tuueleze kwa mifano gani? ");
INSERT INTO swh1850_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ni kama mbegu ya haradali ambayo ni ndogo kuliko mbegu zote. ");
INSERT INTO swh1850_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lakini ikisha pandwa, huota na kuwa mmea mkubwa kuliko mimea yote ya shambani. Matawi yake huwa makubwa hata ndege wa angani huweza kujenga viota vyao katika kivuli chake.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu aliwahubiria ujumbe wake kwa mifano mingine mingi ya namna hiyo; aliongea nao kadiri walivyoweza kusikia. ");
INSERT INTO swh1850_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hakuongea nao chochote bila kutumia mifano; lakini alipokuwa pamoja na wanafunzi wake peke yao alikuwa akiwafafanulia kila kitu. ");
INSERT INTO swh1850_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jioni, siku hiyohiyo, Yesu aliwaambia wanafunzi wake, “Tuvuke ziwa, twende ng'ambo.” ");
INSERT INTO swh1850_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basi, wakauacha ule umati wa watu, wakamchukua Yesu katika mashua alimokuwa. Palikuwapo pia mashua nyingine hapo. ");
INSERT INTO swh1850_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Basi, dhoruba kali ikaanza kuvuma, mawimbi yakaipiga ile mashua hata ikaanza kujaa maji. ");
INSERT INTO swh1850_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu alikuwa sehemu ya nyuma ya mashua, amelala juu ya mto. Basi, wanafunzi wakamwamsha na kumwambia, “Mwalimu, je, hujali kwamba sisi tunaangamia?” ");
INSERT INTO swh1850_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Basi, akaamka, akaukemea ule upepo na kuyaamrisha mawimbi ya ziwa, “Kimya! Tulia!” Hapo upepo ukakoma, kukawa shwari kabisa. ");
INSERT INTO swh1850_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kisha Yesu akawaambia wanafunzi wake, “Mbona mnaogopa? Je, bado hamna imani?” ");
INSERT INTO swh1850_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nao wakaogopa sana, wakawa wanaulizana, “Huyu ni nani basi, hata upepo na mawimbi vinamtii?” ");
INSERT INTO swh1850_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Basi, wakafika katika nchi ya Wagerase, ng'ambo ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mara tu Yesu aliposhuka mashuani, mtu mmoja aliyepagawa na pepo mchafu alitoka makaburini, akakutana naye. ");
INSERT INTO swh1850_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mtu huyo alikuwa akiishi makaburini wala hakuna mtu aliyeweza tena kumfunga kwa minyororo. ");
INSERT INTO swh1850_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mara nyingi walimfunga kwa pingu na minyororo lakini kila mara aliweza kuikata hiyo minyororo na kuzivunja hizo pingu, wala hakuna mtu aliyeweza kumzuia. ");
INSERT INTO swh1850_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mchana na usiku alikaa makaburini na milimani akipaaza sauti na kujikatakata kwa mawe. ");
INSERT INTO swh1850_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Alipomwona Yesu kwa mbali, alimkimbilia, akamwinamia ");
INSERT INTO swh1850_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","akisema kwa sauti kubwa, “Una shauri gani nami, wewe Yesu Mwana wa Mungu aliye juu? Kwa jina la Mungu, nakusihi usinitese!” ");
INSERT INTO swh1850_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Alisema hivyo kwa kuwa Yesu alikuwa amemwambia, “Pepo mchafu, mtoke mtu huyu.”) ");
INSERT INTO swh1850_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Basi, Yesu akamwuliza, “Jina lako nani?” Naye akajibu, “Jina langu ni Jeshi, maana sisi tu wengi.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kisha akamsihi Yesu asiwafukuze hao pepo katika nchi ile. ");
INSERT INTO swh1850_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kulikuwa na kundi kubwa la nguruwe malishoni kwenye mteremko wa mlima. ");
INSERT INTO swh1850_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Basi, hao pepo wakamsihi, “Utupeleke kwa hao nguruwe, tuwaingie.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naye akawaruhusu. Basi, hao pepo wachafu wakatoka, wakawaingia wale nguruwe. Kundi lote la nguruwe wapatao elfu mbili likaporomoka kwenye ule mteremko mkali mpaka ziwani, likatumbukia majini. ");
INSERT INTO swh1850_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wachungaji wa hao nguruwe walikimbia, wakatangaza jambo hilo mjini na mashambani. Watu wakafika kuona yaliyotukia. ");
INSERT INTO swh1850_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wakamwendea Yesu, wakamwona na mtu yuleyule aliyekuwa amepagawa na jeshi la pepo ameketi chini, amevaa nguo na ana akili yake sawa, wakaogopa. ");
INSERT INTO swh1850_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Watu walishuhudia tukio hilo wakaeleza wengine mambo yaliyompata huyo mtu aliyekuwa amepagawa na pepo na juu ya wale nguruwe. ");
INSERT INTO swh1850_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Basi, wakaanza kumwomba aondoke katika nchi yao. ");
INSERT INTO swh1850_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu alipokuwa anapanda mashuani, yule mtu aliyekuwa amepagawa na pepo akamwomba amruhusu kwenda naye. ");
INSERT INTO swh1850_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini Yesu akamkatalia. Badala yake akamwambia, “Nenda nyumbani kwa jamaa yako, ukawaambie mambo yote Bwana aliyokutendea na jinsi alivyokuonea huruma.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basi, huyo mtu akaenda, akaanza kutangaza huko Dekapoli mambo yote Yesu aliyomtendea; watu wote wakashangaa. ");
INSERT INTO swh1850_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu alivukia tena upande wa pili wa ziwa kwa mashua. Umati mkubwa wa watu ukakusanyika mbele yake, naye akawa amesimama kando ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hapo akaja mmojawapo wa maofisa wa sunagogi, jina lake Yairo. Alipomwona Yesu, akajitupa mbele ya miguu yake, ");
INSERT INTO swh1850_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akamsihi akisema, “Binti yangu mdogo ni mgonjwa karibu kufa. Twende tafadhali, ukamwekee mikono yako, apate kupona na kuishi.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Basi, Yesu akaondoka pamoja naye. Watu wengi sana wakamfuata, wakawa wanamsonga kila upande. ");
INSERT INTO swh1850_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mmojawapo alikuwa mwanamke mwenye ugonjwa wa kutokwa damu kwa muda wa miaka kumi na miwili. ");
INSERT INTO swh1850_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mwanamke huyo alikuwa amekwisha sumbuka sana kuwaendea waganga wengi. Na ingawa alikuwa amekwisha tumia mali yake yote, hakupata nafuu bali hali yake ilizidi kuwa mbaya. ");
INSERT INTO swh1850_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Alikuwa amesikia habari za Yesu, na hivyo akaupenya msongamano wa watu kutoka nyuma, akagusa vazi lake. ");
INSERT INTO swh1850_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Alifanya hivyo, maana alijisemea, “Nikigusa tu vazi lake, nitapona.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mara chemchemi ya damu yake ikakauka, akajisikia mwilini mwake kwamba ameponywa ugonjwa wake. ");
INSERT INTO swh1850_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu alitambua mara kwamba nguvu imemtoka. Basi akaugeukia ule umati wa watu, akauliza, “Nani aliyegusa mavazi yangu?” ");
INSERT INTO swh1850_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanafunzi wake wakamjibu, “Unaona jinsi watu wanavyokusonga; mbona wauliza nani aliyekugusa?” ");
INSERT INTO swh1850_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu akaendelea kutazama amwone huyo aliyefanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hapo huyo mwanamke, akifahamu yaliyompata, akajitokeza akitetemeka kwa hofu, akajitupa chini mbele ya Yesu na kusema ukweli wote. ");
INSERT INTO swh1850_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu akamwambia, “Binti, imani yako imekuponya. Nenda kwa amani, upone kabisa ugonjwa wako.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu alipokuwa bado anaongea, watu walifika kutoka nyumbani kwa yule ofisa wa sunagogi, wakamwambia, “Binti yako amekwisha kufa. Ya nini kuendelea kumsumbua Mwalimu?” ");
INSERT INTO swh1850_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lakini, bila kujali walichosema, Yesu akamwambia mkuu wa sunagogi, “Usiogope, amini tu.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wala hakumruhusu mtu yeyote kufuatana naye ila Petro, Yakobo na Yohane nduguye Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wakafika nyumbani kwa ofisa wa sunagogi naye Yesu akasikia makelele, kilio na maombolezo mengi. ");
INSERT INTO swh1850_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Akaingia ndani, akawaambia, “Mbona mnapiga kelele na kulia? Msichana hakufa, amelala tu.” ");
INSERT INTO swh1850_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lakini wao wakamcheka. Basi, akawaondoa wote nje, akawachukua baba na mama ya huyo msichana na wale wanafunzi wake, wakaingia chumbani alimokuwa huyo msichana. ");
INSERT INTO swh1850_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kisha akamshika mkono, akamwambia, “Talitha, kumi,” maana yake, “Msichana, nakwambia, amka!” ");
INSERT INTO swh1850_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mara msichana akasimama, akaanza kutembea. (Alikuwa na umri wa miaka kumi na miwili.) Hapo watu wakashangaa kupita kiasi. ");
INSERT INTO swh1850_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu akawakataza sana wasimjulishe mtu jambo hilo. Kisha akawaambia wampe huyo msichana chakula. ");
INSERT INTO swh1850_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu aliondoka hapo akaenda katika kijiji chake, akifuatwa na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Siku ya Sabato ilipofika, alianza kufundisha katika sunagogi. Wengi waliomsikia walishangaa, wakasema, “Je, ameyapata wapi mambo haya? Ni hekima gani hii aliyopewa? Tena, anatendaje maajabu haya anayoyafanya? ");
INSERT INTO swh1850_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Je, huyu si yule seremala mwana wa Maria, na ndugu yao kina Yakobo, Yose, Yuda na Simoni; Je, dada zake si wanaishi papa hapa kwetu?” Basi, wakawa na mashaka naye. ");
INSERT INTO swh1850_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu akawaambia, “Nabii hakosi heshima isipokuwa katika nchi yake, kwa jamaa zake na nyumbani mwake.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hakuweza kutenda miujiza hapo, ila aliwawekea mikono wagonjwa wachache, akawaponya. ");
INSERT INTO swh1850_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Alishangaa sana kwa sababu ya kutoamini kwao. Kisha Yesu alivitembelea vijiji vya pale karibu akiwafundisha watu. ");
INSERT INTO swh1850_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aliwaita wale wanafunzi kumi na wawili, akaanza kuwatuma wawiliwawili. Aliwapa uwezo wa kuwatoa pepo wachafu, ");
INSERT INTO swh1850_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","na kuwaamuru, “Msichukue chochote mnapokwenda isipokuwa fimbo tu. Msichukue mkate, wala mkoba, wala fedha kibindoni. ");
INSERT INTO swh1850_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Vaeni viatu lakini msivae kanzu mbili.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tena aliwaambia, “Popote mtakapokaribishwa nyumbani, kaeni humo mpaka mtakapoondoka mahali hapo. ");
INSERT INTO swh1850_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mahali popote ambapo watu watakataa kuwakaribisheni au kuwasikiliza, ondokeni hapo na kuyakung'uta mavumbi miguuni mwenu kama onyo kwao.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basi, wakaondoka, wakahubiri watu watubu. ");
INSERT INTO swh1850_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Waliwafukuza pepo wengi wabaya; wakawapaka mafuta wagonjwa wengi, wakawaponya. ");
INSERT INTO swh1850_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Basi, mfalme Herode alisikia juu ya hayo yote, maana sifa za Yesu zilienea kila mahali. Baadhi ya watu walikuwa wakisema, “Yohane Mbatizaji amefufuka kutoka wafu, ndiyo maana nguvu za miujiza zinafanya kazi ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wengine walisema, “Mtu huyu ni Eliya.” Wengine walisema, “Huyu ni nabii kama mmojawapo wa manabii wa kale.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lakini Herode alipopata habari hizi alisema, “Huyu ni Yohane! Nilimkata kichwa, lakini amefufuka.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hapo awali Herode mwenyewe alikuwa ameamuru Yohane atiwe nguvuni, akamfunga gerezani. Herode alifanya hivyo kwa sababu ya Herodia ambaye Herode alimwoa ingawaje alikuwa mke wa Filipo, ndugu yake. ");
INSERT INTO swh1850_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohane alikuwa amemwambia Herode, “Si halali kwako kumchukua mke wa ndugu yako.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Basi Herodia alimchukia sana Yohane, akataka kumwua, asiweze. ");
INSERT INTO swh1850_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode alimwogopa Yohane kwa maana alijua kwamba yeye ni mtu mwema na mtakatifu, na hivyo akamlinda. Herode alipenda kumsikiliza Yohane, ingawaje baada ya kumsikiliza, alifadhaika sana. ");
INSERT INTO swh1850_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ikapatikana nafasi, wakati wa sikukuu ya kuzaliwa kwake Herode. Herode aliwafanyia karamu wazee wa baraza lake, majemadari na viongozi wa Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Basi, binti yake Herodia aliingia, akacheza, akawafurahisha sana Herode na wageni wake. Mfalme akamwambia huyo msichana, “Niombe chochote utakacho, nami nitakupa.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tena akamwapia, “Chochote utakachoniomba, nitakupa: hata ikiwa ni nusu ya ufalme wangu.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hapo huyo msichana akatoka, akamwuliza mama yake, “Niombe nini?” Naye akamjibu, “Kichwa cha Yohane mbatizaji.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Msichana akamrudia mfalme mbio akamwomba, “Nataka unipe sasa hivi katika sinia kichwa cha Yohane mbatizaji.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mfalme akahuzunika sana, lakini kwa sababu ya kiapo chake, na kwa ajili ya wale wageni wake karamuni, hakutaka kumkatalia. ");
INSERT INTO swh1850_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Basi, mfalme akamwamuru askari kukileta kichwa cha Yohane. Askari akaenda, akamkata kichwa Yohane mle gerezani, ");
INSERT INTO swh1850_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","akakileta katika sinia, akampa msichana naye msichana akampa mama yake. ");
INSERT INTO swh1850_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanafunzi wa Yohane walipopata habari, walikwenda wakachukua mwili wake, wakauzika kaburini. ");
INSERT INTO swh1850_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wale mitume walirudi, wakakusanyika mbele ya Yesu wakamwarifu yote waliyotenda na kufundisha. ");
INSERT INTO swh1850_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Alisema hivyo kwa kuwa kulikuwa na watu wengi mno walikuwa wanafika hapo na kuondoka hata Yesu na wanafunzi wake hawakuweza kupata nafasi ya kula chakula. Basi, Yesu akawaambia, “Twendeni peke yetu mahali pa faragha kula chakula, mkapumzike kidogo.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Basi, Wakaondoka peke yao kwa mashua, wakaenda mahali pa faragha. ");
INSERT INTO swh1850_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini watu wengi waliwaona wakienda, wakawatambua. Hivyo wengi wakatoka katika kila mji, wakakimbilia huko Yesu na wanafunzi wake walikokuwa wanakwenda, wakawatangulia kufika. ");
INSERT INTO swh1850_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Waliposhuka pwani, Yesu aliona umati mkubwa wa watu, akawahurumia, kwa sababu walikuwa kama kondoo wasio na mchungaji. Akaanza kuwafundisha mambo mengi. ");
INSERT INTO swh1850_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Saa za mchana zilikwisha pita. Basi, wanafunzi wakamwendea Yesu, wakamwambia, “Hapa ni nyikani, na sasa kunakuchwa. ");
INSERT INTO swh1850_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Afadhali uwaage watu waende mashambani na katika vijiji vya jirani, wanunue chakula.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lakini Yesu akawaambia, “Wapeni ninyi chakula.” Nao wakamwuliza, “Je, twende kununua mikate kwa fedha dinari mia mbili, na kuwapa chakula?” ");
INSERT INTO swh1850_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu akawauliza, “Mnayo mikate mingapi? Nendeni mkatazame.” Walipokwisha tazama, wakamwambia, “Kuna mikate mitano na samaki wawili.” ");
INSERT INTO swh1850_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Basi, Yesu akawaamuru wanafunzi wawaketishe watu wote makundimakundi penye nyasi. ");
INSERT INTO swh1850_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nao wakaketi makundimakundi ya watu mia moja na ya watu hamsini. ");
INSERT INTO swh1850_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kisha Yesu akaitwaa ile mikate mitano na wale samaki wawili, akatazama juu mbinguni, akamshukuru Mungu, akaimega mikate, akawapa wanafunzi wake wawagawie watu. Na wale samaki wawili pia akawagawia wote. ");
INSERT INTO swh1850_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Watu wote wakala, wakashiba. ");
INSERT INTO swh1850_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wakaokota mabaki ya mikate na samaki pia, wakajaza vikapu kumi na viwili. ");
INSERT INTO swh1850_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nao waliokula hiyo mikate walikuwa wanaume elfu tano. ");
INSERT INTO swh1850_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mara Yesu akawaamuru wanafunzi wake wapande mashua, wamtangulie kwenda Bethsaida, ng'ambo ya ziwa, wakati yeye anauaga umati wa watu. ");
INSERT INTO swh1850_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Baada ya kuwaaga watu alikwenda mlimani kusali. ");
INSERT INTO swh1850_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ilipokuwa jioni, mashua ilikuwa katikati ya ziwa, naye alikuwa peke yake katika nchi kavu. ");
INSERT INTO swh1850_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Basi, akawaona wanafunzi wake wakitaabika kwa kupiga makasia, maana upepo ulikuwa unawapinga. Karibu na mapambazuko, Yesu aliwaendea akitembea juu ya maji. Alitaka kuwapita. ");
INSERT INTO swh1850_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lakini walimwona akitembea juu ya maji, wakadhani ni mzimu, wakapiga yowe. ");
INSERT INTO swh1850_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maana wote walipomwona waliogopa sana. Mara Yesu akasema nao, “Tulieni, ni mimi. Msiogope!” ");
INSERT INTO swh1850_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kisha akapanda mashuani walimokuwa, na upepo ukatulia. Nao wakashangaa sana. ");
INSERT INTO swh1850_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","maana hawakuwa bado wameelewa maana ya ile mikate. Akili zao zilikuwa bado zimepumbazika. ");
INSERT INTO swh1850_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Walivuka ziwa, wakafika nchi ya Genesareti, wakatia nanga. ");
INSERT INTO swh1850_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Walipotoka mashuani, mara watu wakamtambua Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Basi, kwa haraka wakazunguka katika nchi ile yote, wakaanza kuwachukua wagonjwa wamelala juu ya mikeka yao, wakawapeleka kila mahali waliposikia Yesu yupo. ");
INSERT INTO swh1850_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila mahali Yesu alipokwenda, vijijini, mijini, au mashambani, watu waliwaweka wagonjwa uwanjani, wakamsihi waguse walau pindo la vazi lake. Nao wote waliomgusa walipona. ");
INSERT INTO swh1850_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Baadhi ya Mafarisayo na walimu wa Sheria waliokuwa wametoka Yerusalemu walikusanyika mbele ya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waliona kwamba baadhi ya wanafunzi wake walikula mikate kwa mikono najisi, yaani bila kunawa. ");
INSERT INTO swh1850_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Maana Mafarisayo na Wayahudi wengine wote huzingatia mapokeo ya wazee wao: hawali kitu kabla ya kunawa mikono ipasavyo. ");
INSERT INTO swh1850_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tena hawali kitu chochote kutoka sokoni mpaka wamekiosha kwanza. Kuna pia desturi nyingine walizopokea kama vile namna ya kuosha vikombe, sufuria na vyombo vya shaba. ");
INSERT INTO swh1850_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Basi, Mafarisayo na walimu wa Sheria wakamwuliza Yesu, “Mbona wanafunzi wako hawayajali mapokeo tuliyopokea kwa wazee wetu, bali hula chakula kwa mikono najisi?” ");
INSERT INTO swh1850_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu akawajibu, “Wanafiki ninyi! Nabii Isaya alitabiri ukweli juu yenu alipoandika: Watu hawa, asema Mungu, huniheshimu kwa maneno matupu, lakini mioyoni mwao wako mbali nami. ");
INSERT INTO swh1850_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kuniabudu kwao hakufai, maana mambo wanayofundisha ni maagizo ya kibinadamu tu. ");
INSERT INTO swh1850_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ninyi mnaiacha amri ya Mungu na kushikilia maagizo ya watu.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu akaendelea kusema, “Ninyi mnajua kuepa kwa ujanja sheria ya Mungu kwa ajili ya kufuata mapokeo yenu. ");
INSERT INTO swh1850_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maana Mose aliamuru: Waheshimu baba yako na mama yako, na, Anayemlaani baba au mama, lazima afe. ");
INSERT INTO swh1850_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini ninyi mwafundisha, Kama mtu anacho kitu ambacho angeweza kuwasaidia nacho baba au mama yake, lakini akasema kwamba kitu hicho ni Korbani (yaani ni zawadi kwa Mungu), ");
INSERT INTO swh1850_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","basi, halazimiki tena kuwasaidia wazazi wake. ");
INSERT INTO swh1850_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hivyo ndivyo mnavyodharau neno la Mungu kwa ajili ya mafundisho mnayopokezana. Tena mnafanya mambo mengi ya namna hiyo.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu aliuita tena ule umati wa watu, akawaambia, “Nisikilizeni nyote, mkaelewe. ");
INSERT INTO swh1850_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hakuna kitu kinachoingia ndani ya mtu toka nje ambacho chaweza kumtia mtu najisi. Lakini kinachotoka ndani ya mtu ndicho kinachomtia mtu najisi.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mwenye masikio na asikie! ");
INSERT INTO swh1850_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Alipouacha umati wa watu na kuingia nyumbani, wanafunzi wake walimwuliza maana ya huo mfano. ");
INSERT INTO swh1850_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Naye akawaambia, “Je, hata ninyi hamwelewi? Je, hamwelewi kwamba kitu kinachomwingia mtu toka nje hakiwezi kumtia unajisi, ");
INSERT INTO swh1850_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwa maana hakimwingii moyoni, ila tumboni, na baadaye hutolewa nje chooni?” (Kwa kusema hivyo, Yesu alivihalalisha vyakula vyote.) ");
INSERT INTO swh1850_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akaendelea kusema, “Kinachotoka ndani ya mtu ndicho kinachomtia najisi. ");
INSERT INTO swh1850_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa maana kutoka ndani, katika moyo wa mtu, hutoka mawazo mabaya, uasherati, wizi, uuaji, ");
INSERT INTO swh1850_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uzinzi, uchoyo, uovu, udanganyifu, ufisadi, wivu, kashfa, kiburi na upumbavu. ");
INSERT INTO swh1850_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maovu hayo yote yatoka ndani ya mtu, nayo humtia mtu najisi.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu aliondoka hapo, akaenda hadi wilaya ya Tiro. Huko aliingia katika nyumba moja na hakutaka mtu ajue; lakini hakuweza kujificha. ");
INSERT INTO swh1850_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mwanamke mmoja ambaye binti yake alikuwa na pepo, alisikia habari za Yesu. Basi, akaja akajitupa chini mbele ya miguu yake. ");
INSERT INTO swh1850_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mama huyo alikuwa Mgiriki, mwenyeji wa Sirofoinike. Basi, akamwomba Yesu amtoe binti yake pepo mchafu. ");
INSERT INTO swh1850_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu akamwambia, “Kwanza watoto washibe; kwa maana si vizuri kuchukua chakula cha watoto na kuwatupia mbwa.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lakini huyo mama akasema, “Sawa, Bwana, lakini hata mbwa walio chini ya meza hula makombo ya watoto.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu akamwambia, “Kwa sababu ya neno hilo, nenda. Pepo amemtoka binti yako!” ");
INSERT INTO swh1850_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Basi, akaenda nyumbani kwake, akamkuta mtoto amelala kitandani, na pepo amekwisha mtoka. ");
INSERT INTO swh1850_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kisha Yesu aliondoka wilayani Tiro, akapitia Sidoni, akafika ziwa Galilaya kwa kupitia nchi ya Dekapoli. ");
INSERT INTO swh1850_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Basi, wakamletea bubu-kiziwi, wakamwomba amwekee mikono. ");
INSERT INTO swh1850_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu akamtenga na umati wa watu, akamtia vidole masikioni, akatema mate na kumgusa ulimi. ");
INSERT INTO swh1850_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kisha akatazama juu mbinguni, akapiga kite, akamwambia, “Efatha,” maana yake, “Funguka.” ");
INSERT INTO swh1850_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mara masikio yake yakafunguka na ulimi wake ukafunguliwa, akaanza kusema sawasawa. ");
INSERT INTO swh1850_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu akawaamuru wasimwambie mtu juu ya jambo hilo. Lakini kadiri alivyowakataza, ndivyo walivyozidi kutangaza habari hiyo. ");
INSERT INTO swh1850_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Watu walishangaa sana, wakasema, “Amefanya yote vyema: amewajalia viziwi kusikia, na bubu kusema!” ");
INSERT INTO swh1850_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wakati huo umati mkubwa wa watu ulikusanyika tena, na hawakuwa na chakula. Basi, Yesu akawaita wanafunzi wake, akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nawahurumia watu hawa kwa sababu wamekuwa nami kwa muda wa siku tatu, wala hawana chakula. ");
INSERT INTO swh1850_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nikiwaacha waende nyumbani wakiwa na njaa watazimia njiani, maana baadhi yao wametoka mbali.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanafunzi wake wakamwuliza, “Hapa nyikani itapatikana wapi mikate ya kuwashibisha watu hawa wote?” ");
INSERT INTO swh1850_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu akawauliza, “Mnayo mikate mingapi?” Nao wakamjibu, “Saba.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Basi, akawaamuru watu wakae chini. Akaitwaa ile mikate saba, akamshukuru Mungu, akaimega, akawapa wanafunzi wake wawagawie watu, nao wakawagawia. ");
INSERT INTO swh1850_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Walikuwa pia na visamaki vichache. Yesu akavibariki, akaamuru vigawiwe watu vilevile. ");
INSERT INTO swh1850_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Watu wakala, wakashiba. Wakaokota mabaki yaliyosalia wakajaza makapu saba. ");
INSERT INTO swh1850_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nao waliokula walikuwa watu wapatao elfu nne. Yesu akawaaga, ");
INSERT INTO swh1850_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na mara akapanda mashua pamoja na wanafunzi wake, akaenda wilaya ya Dalmanutha. ");
INSERT INTO swh1850_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafarisayo walikuja, wakaanza kujadiliana na Yesu. Kwa kumjaribu, wakamtaka awafanyie ishara kuonyesha anayo idhini kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu akahuzunika rohoni, akasema, “Mbona kizazi hiki kinataka ishara? Kweli nawaambieni, kizazi hiki hakitapewa ishara yoyote!” ");
INSERT INTO swh1850_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basi, akawaacha, akapanda tena mashua, akaanza safari kwenda ng'ambo ya pili ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanafunzi walikuwa wamesahau kuchukua mikate; walikuwa na mkate mmoja tu katika mashua. ");
INSERT INTO swh1850_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu akawaonya, “Angalieni sana! Jihadharini na chachu ya Mafarisayo na chachu ya Herode.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wanafunzi wakaanza kujadiliana wao kwa wao, “Anasema hivyo kwa kuwa hatuna mikate.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu alitambua hayo, akawaambia, “Mbona mnajadiliana juu ya kutokuwa na mikate? Je, bado hamjafahamu, wala hamjaelewa? Je, mioyo yenu imeshupaa? ");
INSERT INTO swh1850_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Je, Mnayo macho na hamwoni? Mnayo masikio na hamsikii? Je, hamkumbuki ");
INSERT INTO swh1850_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","wakati ule nilipoimega ile mikate mitano na kuwapa watu elfu tano? Mlikusanya vikapu vingapi vya mabaki ya makombo?” Wakamjibu, “Kumi na viwili.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na nilipoimega ile mikate saba na kuwapa watu elfu nne, mlikusanya makapu mangapi ya makombo?” Wakamjibu, “Saba.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Basi, akawaambia, “Na bado hamjaelewa?” ");
INSERT INTO swh1850_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu alifika Bethsaida pamoja na wanafunzi wake. Huko watu wakamletea kipofu mmoja, wakamwomba amguse. ");
INSERT INTO swh1850_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu akamshika mkono huyo kipofu, akampeleka nje ya kijiji. Akamtemea mate machoni, akamwekea mikono, akamwuliza, “Je, unaweza kuona kitu?” ");
INSERT INTO swh1850_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Huyo kipofu akatazama, akasema, “Ninawaona watu wanaoonekana kama miti inayotembea.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kisha Yesu akamwekea tena mikono machoni, naye akakaza macho, uwezo wake wa kuona ukamrudia, akaona kila kitu sawasawa. ");
INSERT INTO swh1850_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu akamwambia aende zake nyumbani na kumwamuru, “Usirudi kijijini!” ");
INSERT INTO swh1850_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kisha Yesu na wanafunzi wake walikwenda katika vijiji vya Kaisarea Filipi. Walipokuwa njiani, Yesu aliwauliza wanafunzi wake, “Watu wanasema mimi ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wakamjibu, “Wengine wanasema wewe ni Yohane Mbatizaji, wengine Eliya na wengine mmojawapo wa manabii.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naye akawauliza, “Na ninyi je, mnasema mimi ni nani?” Petro akamjibu, “Wewe ndiwe Kristo.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kisha Yesu akawaonya wasimwambie mtu yeyote habari zake. ");
INSERT INTO swh1850_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu alianza kuwafundisha wanafunzi wake: “Ni lazima Mwana wa Mtu apatwe na mateso mengi na kukataliwa na wazee na makuhani wakuu na walimu wa Sheria. Atauawa na baada ya siku tatu atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu aliwaambia jambo hilo waziwazi. Basi, Petro akamchukua kando, akaanza kumkemea. ");
INSERT INTO swh1850_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lakini Yesu akageuka, akawatazama wanafunzi wake, akamkemea Petro akisema, “Ondoka mbele yangu, Shetani! Fikira zako si za kimungu ila ni za kibinadamu!” ");
INSERT INTO swh1850_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kisha akauita umati wa watu pamoja na wanafunzi wake, akawaambia, “Mtu yeyote akitaka kuwa mfuasi wangu, lazima ajikane mwenyewe, auchukue msalaba wake, anifuate. ");
INSERT INTO swh1850_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maana mtu anayetaka kuyaokoa maisha yake mwenyewe, atayapoteza, lakini mtu atakayepoteza maisha yake kwa ajili yangu na kwa ajili ya Habari Njema, atayaokoa. ");
INSERT INTO swh1850_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Je, kuna faida gani mtu kuupata ulimwengu wote na kuyapoteza maisha yake? ");
INSERT INTO swh1850_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ama mtu atatoa kitu gani badala ya maisha yake? ");
INSERT INTO swh1850_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mtu yeyote katika kizazi hiki kiovu na kisichomjali Mungu anayenionea aibu mimi na mafundisho yangu, Mwana wa Mtu atamwonea aibu mtu huyo wakati atakapokuja katika utukufu wa Baba yake pamoja na malaika watakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akaendelea kuwaambia, “Kweli nawaambieni, wako wengine papa hapa ambao hawatakufa kabla ya kuuona Ufalme wa Mungu ukija kwa enzi.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Baada ya siku sita, Yesu aliwachukua Petro, Yakobo na Yohane juu ya mlima mrefu peke yao. Huko, Yesu akageuka sura mbele yao, ");
INSERT INTO swh1850_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mavazi yake yakang'aa, yakawa meupe sana, jinsi dobi yeyote duniani asingeweza kuyafanya meupe. ");
INSERT INTO swh1850_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliya na Mose wakawatokea, wakazungumza na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petro akamwambia Yesu, “Mwalimu, ni vizuri sana kwamba tuko hapa. Basi, afadhali tujenge vibanda vitatu: kimoja chako, kimoja cha Mose na kimoja cha Eliya.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yeye na wenzake waliogopa hata hakujua la kusema. ");
INSERT INTO swh1850_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kisha likatokea wingu likawafunika, na sauti ikasikika kutoka katika hilo wingu, “Huyu ni Mwanangu mpendwa, msikilizeni.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mara wanafunzi hao wakatazama tena, lakini hawakumwona mtu mwingine, ila Yesu peke yake pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Walipokuwa wakishuka mlimani, Yesu aliwakataza wasimwambie mtu yeyote mambo waliyoyaona, mpaka Mwana wa Mtu atakapokuwa amefufuka kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Basi, wakashika agizo hilo, lakini wakawa wanajadiliana wao kwa wao maana ya kufufuka kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wakamwuliza Yesu, “Mbona walimu wa Sheria wanasema kwamba ni lazima Eliya aje kwanza?” ");
INSERT INTO swh1850_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naye akawajibu, “Naam, Eliya anakuja kwanza kutayarisha yote. Hata hivyo, kwa nini basi imeandikwa katika Maandiko Matakatifu kwamba Mwana wa Mtu atapatwa na mateso mengi na kudharauliwa? ");
INSERT INTO swh1850_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakini nawaambieni, Eliya amekwisha kuja, nao wakamtendea walivyotaka kama ilivyoandikwa juu yake.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Walipowafikia wale wanafunzi wengine, waliona umati mkubwa wa watu hapo. Na baadhi ya walimu wa Sheria walikuwa wanajadiliana nao. ");
INSERT INTO swh1850_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mara tu ule umati wa watu ulipomwona, wote walishangaa sana, wakamkimbilia wamsalimu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu akawauliza, “Mnajadiliana nini nao?” ");
INSERT INTO swh1850_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hapo mtu mmoja katika ule umati wa watu akamjibu, “Mwalimu, nimemleta mwanangu kwako, ana pepo aliyemfanya kuwa bubu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila mara anapomvamia, humwangusha chini na kumfanya atokwe na povu kinywani, akisaga meno na kuwa mkavu mwili wote. Niliwaomba wanafunzi wako wamtoe huyo pepo lakini hawakuweza.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu akawaambia, “Enyi kizazi kisicho na imani! Nitakaa nanyi mpaka lini? Nitawavumilia mpaka lini? Mleteni kwangu.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wakampeleka. Mara tu huyo pepo alipomwona Yesu, alimtia mtoto kifafa, naye mtoto akaanguka chini, akagaagaa na kutoka povu kinywani. Yesu akamwuliza baba yake huyo mtoto, ");
INSERT INTO swh1850_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Amepatwa na mambo hayo tangu lini?” Naye akamjibu, “Tangu utoto wake. ");
INSERT INTO swh1850_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na mara nyingi pepo huyo amemwangusha motoni na majini, ili amwangamize kabisa. Basi, ikiwa waweza, utuhurumie na kutusaidia!” ");
INSERT INTO swh1850_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akamwambia, “Eti ikiwa waweza! Mambo yote yanawezekana kwa mtu aliye na imani.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hapo, huyo baba akalia kwa sauti, “Naamini! Lakini imani yangu haitoshi, nisaidie!” ");
INSERT INTO swh1850_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu alipouona umati wa watu unaongezeka upesi mbele yake, alimkemea yule pepo mchafu, “Pepo unayemfanya huyu mtoto kuwa bubu-kiziwi, nakuamuru, mtoke mtoto huyu wala usimwingie tena!” ");
INSERT INTO swh1850_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hapo huyo pepo alipaaza sauti, akamwangusha huyo mtoto chini, kisha akamtoka. Mtoto alionekana kama maiti, hata wengine walisema, “Amekufa!” ");
INSERT INTO swh1850_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu akamshika mkono, akamwinua, naye akasimama. ");
INSERT INTO swh1850_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu alipoingia nyumbani, wanafunzi wake walimwuliza kwa faragha, “Kwa nini sisi hatukuweza kumtoa?” ");
INSERT INTO swh1850_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naye akawaambia, “Pepo wa aina hii hawezi kutoka isipokuwa kwa sala tu.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanafunzi wake waliondoka hapo, wakaendelea na safari kupitia wilaya ya Galilaya. Yesu hakupenda watu wajue alipokuwa, ");
INSERT INTO swh1850_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwa sababu alikuwa anawafundisha wanafunzi wake. Aliwaambia, “Mwana wa Mtu atakabidhiwa kwa watu ambao watamuua; lakini siku ya tatu baada ya kuuawa atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wanafunzi hawakufahamu jambo hilo. Wakaogopa kumwuliza. ");
INSERT INTO swh1850_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Basi, walifika Kafarnaumu. Na alipokuwa nyumbani, aliwauliza, “Mlikuwa mnajadiliana nini njiani?” ");
INSERT INTO swh1850_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakini wao wakanyamaza, maana njiani walikuwa wamebishana ni nani aliye mkuu kati yao. ");
INSERT INTO swh1850_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu akaketi chini, akawaita wale kumi na wawili, akawaambia, “Yeyote anayetaka kuwa wa kwanza lazima awe wa mwisho na kuwa mtumishi wa wote.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kisha akamchukua mtoto mdogo, akamsimamisha kati yao, akamku mbatia, halafu akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Anayempokea mtoto kama huyu kwa jina langu, ananipokea mimi; na anayenipokea mimi, hanipokei mimi tu, bali anampokea yule aliyenituma.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane akamwambia, “Mwalimu, tumemwona mtu mmoja akitoa pepo kwa kulitumia jina lako, nasi tukajaribu kumkataza kwa kuwa yeye si mmoja wetu.” ");
INSERT INTO swh1850_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lakini Yesu akasema, “Msimkataze, maana hakuna mtu anayefanya muujiza kwa jina langu, na papo hapo akaweza kusema mabaya juu yangu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maana, asiyepingana nasi, yuko upande wetu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mtu yeyote atakeyewapeni kikombe cha maji ya kunywa kwa sababu ninyi ni watu wake Kristo, hakika hatakosa kupata tuzo lake. ");
INSERT INTO swh1850_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mtu yeyote atakayemfanya mmoja wa hawa wadogo wanaoniamini atende dhambi, ingekuwa afadhali kwa mtu huyo kufungiwa shingoni mwake jiwe kubwa la kusagia na kutupwa baharini. ");
INSERT INTO swh1850_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mkono wako ukikukosesha, ukate! Afadhali kuingia kwenye uzima bila mkono mmoja, kuliko kuwa na mikono miwili na kwenda katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Humo, wadudu wake hawafi na moto hauzimiki. ");
INSERT INTO swh1850_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na mguu wako ukikukosesha, ukate! Afadhali kuingia katika uzima bila mguu mmoja, kuliko kuwa na miguu yote miwili na kutupwa katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Humo, wadudu wake hawafi na moto hauzimiki. ");
INSERT INTO swh1850_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na jicho lako likikukosesha, ling'oe! Afadhali kuingia katika utawala wa Mungu ukiwa na jicho moja tu, kuliko kuwa na macho yako yote mawili na kutupwa katika moto wa Jehanamu. ");
INSERT INTO swh1850_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Humo wadudu wake hawafi, na moto hauzimiki. ");
INSERT INTO swh1850_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Maana kila mmoja atakolezwa kwa moto. ");
INSERT INTO swh1850_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Chumvi ni nzuri, lakini ikipoteza ladha yake, itakolezwa na nini? Muwe na chumvi ndani yenu na kudumisha amani kati yenu.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu alitoka hapo akaenda mkoani Yudea na hata ng'ambo ya mto Yordani. Umati wa watu ukamwendea tena, naye akawafundisha tena kama ilivyokuwa desturi yake. ");
INSERT INTO swh1850_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Basi, Mafarisayo wakamwendea, na kwa kumjaribu wakamwuliza, “Je, ni halali mtu kumpa talaka mkewe?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akawajibu, “Mose aliwapa maagizo gani?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nao wakasema, “Mose aliagiza mume kumpatia mkewe hati ya talaka na kumwacha.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu akawaambia, “Mose aliwaandikia amri hiyo kwa sababu ya ugumu wa mioyo yenu. ");
INSERT INTO swh1850_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lakini tangu kuumbwa ulimwengu, Mungu aliumba mwanamume na mwanamke. ");
INSERT INTO swh1850_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hivyo mwanamume atawaacha baba yake na mama yake, ataungana na mkewe, ");
INSERT INTO swh1850_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nao wawili watakuwa mwili mmoja. Kwa hiyo, wao si wawili tena bali mwili mmoja. ");
INSERT INTO swh1850_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Basi, alichounganisha Mungu, binadamu asitenganishe.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Walipoingia tena ndani ya nyumba, wanafunzi wake walimwuliza juu ya jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naye akawaambia, “Anayemwacha mkewe na kuoa mwingine, anazini dhidi ya mkewe. ");
INSERT INTO swh1850_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na mwanamke anayemwacha mumewe na kuolewa na mwingine anazini.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Watu walimletea Yesu watoto wadogo ili awaguse, lakini wanafunzi wakawakemea. ");
INSERT INTO swh1850_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu alipoona hivyo, alikasirika akawaambia, “Waacheni hao watoto waje kwangu, wala msiwazuie, kwa maana Ufalme wa Mungu ni kwa ajili ya watu walio kama watoto hawa. ");
INSERT INTO swh1850_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nawaambieni kweli, mtu yeyote asiyeupokea Ufalme wa Mungu kama mtoto mdogo hataingia katika Ufalme huo.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kisha akawapokea watoto hao, akawawekea mikono, akawabariki. ");
INSERT INTO swh1850_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu alipoanza tena safari yake, mtu mmoja alimjia mbio, akapiga magoti mbele yake, akamwuliza, “Mwalimu mwema, nifanyeje ili niupate uzima wa milele?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu akamjibu, “Mbona unaniita mwema? Hakuna aliye mwema ila Mungu peke yake. ");
INSERT INTO swh1850_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Unazijua amri: Usizini; Usiue; Usiibe; Usitoe ushahidi wa uongo; Usidanganye; Waheshimu baba na mama yako.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naye akamjibu, “Mwalimu, hayo yote nimeyazingatia tangu ujana wangu.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu akamtazama, akampenda, akamwambia, “Umepungukiwa na kitu kimoja: nenda ukauze vitu ulivyo navyo, uwape maskini, nawe utakuwa na hazina mbinguni; kisha njoo unifuate.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aliposikia hayo, alisikitika, akaenda zake akiwa na huzuni, kwa maana alikuwa na mali nyingi. ");
INSERT INTO swh1850_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu akatazama pande zote, akawaambia wanafunzi wake, “Jinsi gani itakavyokuwa vigumu kwa matajiri kuingia katika Ufalme wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanafunzi walishangazwa na maneno yake. Yesu akawaambia tena, “Watoto wangu, ni vigumu sana kuingia katika Ufalme wa Mungu! ");
INSERT INTO swh1850_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni rahisi zaidi ngamia kupenya katika tundu la sindano, kuliko tajiri kuingia katika Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanafunzi wake wakashangaa sana wakaulizana, “Ni nani basi, atakayeweza kuokoka?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu akawatazama, akawaambia, “Kwa binadamu haiwezekani, lakini kwa Mungu si hivyo, maana kwa Mungu mambo yote huwezekana.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petro akamwambia, “Na sisi je? Tumeacha yote, tukakufuata!” ");
INSERT INTO swh1850_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu akasema, “Kweli nawaambieni, kila mtu aliyeacha nyumba, au ndugu, au dada, au mama, au baba, au watoto au mashamba kwa ajili yangu na kwa ajili ya Habari Njema, ");
INSERT INTO swh1850_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","atapokea mara mia zaidi wakati huu wa sasa nyumba, ndugu, dada, mama, watoto na mashamba pamoja na mateso; na katika wakati ujao atapokea uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakini wengi walio wa kwanza watakuwa wa mwisho, na walio wa mwisho watakuwa wa kwanza.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Basi, walikuwa njiani kwenda Yerusalemu, na Yesu alikuwa anawatangulia. Wanafunzi wake walijawa na hofu, na watu waliofuata waliogopa. Yesu akawachukua tena kando wale kumi na wawili, akaanza kuwaambia yale yatakayompata: ");
INSERT INTO swh1850_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Sikilizeni! Tunakwenda Yerusalemu, na huko Mwana wa Mtu atakabidhiwa kwa makuhani wakuu na walimu wa Sheria, nao watamhukumu auawe na kumkabidhi kwa watu wa mataifa. ");
INSERT INTO swh1850_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nao watamdhihaki; watamtemea mate, watampiga mijeledi na kumwua. Na baada ya siku tatu atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo na Yohane, wana wa Zebedayo, walimwendea Yesu wakamwambia, “Mwalimu, tunataka utufanyie kitu tutakachokuomba.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu akawauliza, “Mnataka niwafanyie nini?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wakamjibu, “Uturuhusu tuketi mmoja upande wako wa kulia na mwingine upande wako wa kushoto katika utukufu wa Ufalme wako.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu akawaambia, “Hamjui mnachoomba! Je, mnaweza kunywa kikombe nitakachokunywa, au kubatizwa kama nitakavyobatizwa?” ");
INSERT INTO swh1850_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wakamjibu, “Tunaweza.” Yesu akawaambia, “Kikombe nitakachokunywa mtakinywa kweli, na mtabatizwa kama nitakavyobatizwa. ");
INSERT INTO swh1850_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lakini ni nani atakayeketi kulia au kushoto kwangu si wajibu wangu kupanga, bali nafasi hizo watapewa wale waliotayarishiwa.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wale wanafunzi wengine kumi waliposikia hayo, walianza kuchukizwa na Yakobo na Yohane. ");
INSERT INTO swh1850_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu akawaita, akawaambia, “Mnajua kwamba wale wanaofikiriwa kuwa watawala wa mataifa huwatawala watu wao kwa mabavu, na wakuu hao huwamiliki watu wao. ");
INSERT INTO swh1850_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini kwenu isiwe hivyo, ila anayetaka kuwa mkuu kati yenu, sharti awe mtumishi wenu. ");
INSERT INTO swh1850_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Anayetaka kuwa wa kwanza, sharti awe mtumishi wa wote. ");
INSERT INTO swh1850_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maana Mwana wa Mtu hakuja kutumikiwa, ila alikuja kutumikia, na kutoa maisha yake kuwa fidia ya watu wengi.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Basi, wakafika Yeriko, naye Yesu alipokuwa anatoka katika mji huo akiwa na wanafunzi wake pamoja na umati mkubwa wa watu, kipofu mwombaji aitwaye Bartimayo mwana wa Timayo alikuwa ameketi kando ya barabara. ");
INSERT INTO swh1850_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aliposikia kwamba ni Yesu wa Nazareti aliyekuwa anapita mahali hapo, alianza kupaaza sauti, “Yesu, Mwana wa Daudi, nihurumie!” ");
INSERT INTO swh1850_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Watu wengi walimkemea ili anyamaze, lakini yeye akazidi kupaaza sauti, “Mwana wa Daudi, nihurumie!” ");
INSERT INTO swh1850_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu alisimama, akasema, “Mwiteni.” Basi, wakamwita huyo kipofu, wakamwambia, “Jipe moyo! Simama, anakuita.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naye akatupilia mbali vazi lake, akaruka juu, akamwendea Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu akamwuliza, “Unataka nikufanyie nini?” Huyo kipofu akamwambia, “Mwalimu, naomba nipate kuona.” ");
INSERT INTO swh1850_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu akamwambia, “Nenda, imani yako imekuponya.” Mara huyo kipofu akaweza kuona, akamfuata Yesu njiani. ");
INSERT INTO swh1850_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Walipokuwa wanakaribia Yerusalemu walifika Bethfage na Bethania, karibu na mlima wa Mizeituni. Hapo aliwatuma wawili wa wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akawaambia, “Nendeni katika kijiji kilicho mbele yenu. Mtakapokuwa mnaingia humo, mtakuta mwana punda amefungwa ambaye bado hajatumiwa na mtu. Mfungueni mkamlete. ");
INSERT INTO swh1850_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kama mtu akiwauliza, Mbona mnafanya hivyo? Mwambieni, Bwana anamhitaji na atamrudisha hapa mara.” ");
INSERT INTO swh1850_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Basi, wakaenda, wakamkuta mwana punda barabarani amefungwa mlangoni. Walipokuwa wakimfungua, ");
INSERT INTO swh1850_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","baadhi ya watu waliokuwa wamesimama hapo wakawauliza “Kwa nini mnamfungua huyo mwana punda?” ");
INSERT INTO swh1850_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wanafunzi wakajibu kama Yesu alivyokuwa amewaambia; nao wakawaacha waende zao. ");
INSERT INTO swh1850_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wakampelekea Yesu huyo mwana punda. Wakatandika mavazi yao juu ya huyo mwana punda, na Yesu akaketi juu yake. ");
INSERT INTO swh1850_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Watu wengi wakatandaza mavazi yao barabarani; wengine wakatandaza matawi ya miti waliyoyakata mashambani. ");
INSERT INTO swh1850_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Watu wote waliotangulia na wale waliofuata wakapaaza sauti zao wakisema, “Hosana! Abarikiwe huyo ajaye kwa jina la Bwana! ");
INSERT INTO swh1850_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ubarikiwe Ufalme ujao wa baba yetu Daudi. Hosana juu mbinguni!” ");
INSERT INTO swh1850_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu aliingia mjini Yerusalemu akaenda moja kwa moja mpaka Hekaluni, akatazama kila kitu kwa makini. Lakini kwa vile ilikwisha kuwa jioni, akaenda Bethania pamoja na wale kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kesho yake, walipokuwa wanatoka Bethania, Yesu aliona njaa. ");
INSERT INTO swh1850_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Basi, akaona kwa mbali mtini wenye majani mengi. Akauendea ili aone kama ulikuwa na tunda lolote. Alipoufikia, aliukuta bila tunda lolote ila majani matupu, kwa vile hayakuwa majira ya mtini kuzaa matunda. ");
INSERT INTO swh1850_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hapo akauambia mtini, “Tangu leo hata milele mtu yeyote asile matunda kwako.” Nao wanafunzi wake walisikia maneno hayo. ");
INSERT INTO swh1850_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Basi, wakafika Yerusalemu. Yesu akaingia Hekaluni, akaanza kuwafukuza nje watu waliokuwa wanauza na kununua vitu humo ndani. Akazipindua meza za wale waliokuwa wakibadilishana fedha na viti vya wale waliokuwa wakiuza njiwa. ");
INSERT INTO swh1850_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hakumruhusu mtu yeyote kupitia Hekaluni akichukua kitu. ");
INSERT INTO swh1850_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kisha akawafundisha, “Imeandikwa: Nyumba yangu itaitwa nyumba ya sala kwa ajili ya mataifa yote! Lakini ninyi mmeifanya kuwa pango la wanyang'anyi!” ");
INSERT INTO swh1850_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makuhani wakuu na walimu wa Sheria waliposikia hayo, walianza kutafuta njia ya kumwangamiza. Lakini walimwogopa kwa sababu umati wa watu ulishangazwa na mafundisho yake. ");
INSERT INTO swh1850_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ilipokuwa jioni, Yesu na wanafunzi wake waliondoka mjini. ");
INSERT INTO swh1850_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Asubuhi na mapema, walipokuwa wanapita, waliuona ule mtini umenyauka wote, hata mizizi. ");
INSERT INTO swh1850_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro aliukumbuka, akamwambia Yesu, “Mwalimu, tazama! Ule mtini ulioulaani, umenyauka!” ");
INSERT INTO swh1850_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu akawaambia, “Mwaminini Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nawaambieni kweli, mtu akiuambia mlima huu: Ng'oka ukajitose baharini bila kuona shaka moyoni mwake, ila akaamini kwamba mambo yote anayosema yanafanyika, atafanyiwa jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa hiyo nawaambieni, mnaposali na kuomba kitu, aminini kwamba mmekipokea, nanyi mtapewa. ");
INSERT INTO swh1850_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mnaposimama kusali, sameheni kila mtu aliyewakosea chochote, ili Baba yenu aliye mbinguni awasamehe ninyi makosa yenu. ");
INSERT INTO swh1850_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lakini msipowasamehe wengine, hata Baba yenu aliye mbinguni hatawasamehe ninyi makosa yenu.” ");
INSERT INTO swh1850_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Basi, wakafika tena Yerusalemu. Yesu alipokuwa akitembea Hekaluni, makuhani wakuu, walimu wa Sheria na wazee walimwendea, ");
INSERT INTO swh1850_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wakamwuliza, “Unafanya mambo haya kwa mamlaka gani? Nani aliyekupa mamlaka ya kufanya mambo haya?” ");
INSERT INTO swh1850_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lakini Yesu akawaambia, “Nitawaulizeni swali moja; mkinijibu, na pia nitawaambieni ni kwa mamlaka gani ninafanya mambo haya. ");
INSERT INTO swh1850_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Je, mamlaka ya Yohane ya kubatiza yalitoka mbinguni ama kwa watu? Nijibuni.” ");
INSERT INTO swh1850_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wakaanza kujadiliana, “Tukisema, Yalitoka mbinguni, atatuuliza, Basi, mbona hamkumsadiki? ");
INSERT INTO swh1850_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tukisema, Yalitoka kwa watu...” (Waliogopa umati wa watu maana wote waliamini kwamba Yohane alikuwa kweli nabii.) ");
INSERT INTO swh1850_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Basi, wakamjibu Yesu, “Sisi hatujui.” Naye Yesu akawaambia, “Nami pia sitawaambieni ninafanya mambo haya kwa mamlaka gani.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu alianza kusema nao kwa mifano: “Mtu mmoja alilima shamba la mizabibu. Akalizungushia ukuta, na katikati yake akachimba kisima cha kusindikia divai, akajenga mnara pia. Akalikodisha shamba hilo kwa wakulima, akasafiri hadi nchi ya mbali. ");
INSERT INTO swh1850_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wakati wa mavuno, alimtuma mtumishi wake kwa wale wakulima akamletee sehemu ya mazao ya shamba lake. ");
INSERT INTO swh1850_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wale wakulima wakamkamata, wakampiga, wakamrudisha mikono mitupu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akatuma tena mtumishi mwingine; huyu wakamuumiza kichwa na kumtendea vibaya. ");
INSERT INTO swh1850_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwenye shamba akatuma mtumishi mwingine tena, na huyo wakamuua. Wengine wengi waliotumwa, baadhi yao walipigwa, na wengi wakauawa. ");
INSERT INTO swh1850_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Alibakiwa bado na mtu mmoja, yaani mwanawe mpendwa. Mwishowe akamtuma huyo akisema, Watamheshimu mwanangu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini hao wakulima wakaambiana, Huyu ndiye mrithi, basi, tumuue ili urithi wake uwe wetu! ");
INSERT INTO swh1850_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kwa hiyo wakamkamata, wakamuua na kumtupa nje ya lile shamba la mizabibu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Basi, mwenye shamba atafanya nini? Atakuja kuwaangamiza hao wakulima na kulikodisha hilo shamba la mizabibu kwa watu wengine. ");
INSERT INTO swh1850_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Je, hamjasoma Maandiko haya? Jiwe walilokataa waashi sasa limekuwa jiwe kuu la msingi. ");
INSERT INTO swh1850_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bwana ndiye aliyefanya jambo hili, nalo ni la ajabu sana kwetu.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Makuhani wakuu, walimu wa Sheria na wazee walifahamu ya kwamba mfano huo ulikuwa unawahusu. Kwa hiyo walijaribu kumtia nguvuni, lakini waliogopa umati wa watu. Basi, wakamwacha wakaenda zao. ");
INSERT INTO swh1850_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Basi, baadhi ya Mafarisayo na wafuasi wa kikundi cha Herode walitumwa ili wamtege Yesu kwa maneno yake. ");
INSERT INTO swh1850_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wakamwendea, wakamwambia, “Mwalimu, tunajua kwamba wewe ni mtu mwaminifu unayesema ukweli mtupu, wala humjali mtu yeyote. Wala cheo cha mtu si kitu kwako, lakini wafundisha ukweli kuhusu njia ya Mungu. Je, ni halali kulipa kodi kwa Kaisari, au la? Tulipe au tusilipe?” ");
INSERT INTO swh1850_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini Yesu alijua unafiki wao, akawaambia, “Mbona mnanijaribu? Nionyesheni sarafu.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wakamwonyesha. Naye akawauliza, “Sura na chapa hii ni ya nani?” Wakamjibu, “Ni ya Kaisari.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Basi, Yesu akawaambia, “Mpeni Kaisari yaliyo yake Kaisari na Mungu yaliyo yake Mungu.” Wakashangazwa sana naye. ");
INSERT INTO swh1850_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Masadukayo wasemao kwamba hakuna ufufuo walimwendea Yesu, wakamwuliza, ");
INSERT INTO swh1850_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimu, Mose alituagiza hivi: Mtu akifa na kuacha mke bila mtoto, ndugu yake lazima amchukue huyo mama mjane amzalie watoto ndugu yake marehemu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Basi, kulikuwa na ndugu saba. Wa kwanza alioa, akafa bila kuacha mtoto. ");
INSERT INTO swh1850_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndugu wa pili akamwoa huyo mjane, naye pia akafa bila kuacha mtoto; na ndugu watatu hali kadhalika. ");
INSERT INTO swh1850_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wote saba walikufa bila kuacha mtoto. Mwishowe yule mama mjane naye akafa. ");
INSERT INTO swh1850_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Basi, siku watu watakapofufuka, mama huyo atakuwa mke wa nani? Maana wote saba walikuwa wamemwoa.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akawaambia, “Ninyi mmekosea sana, kwa sababu hamjui Maandiko Matakatifu wala nguvu ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maana wafu watakapofufuka, hawataoa wala kuolewa; watakuwa kama malaika wa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lakini kuhusu kufufuliwa kwa wafu, je, hamjasoma kitabu cha Mose katika sehemu inayohusu kile kichaka kilichokuwa kinawaka moto? Mungu alimwambia Mose, Mimi ni Mungu wa Abrahamu, Mungu wa Isaka, na Mungu wa Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Basi, yeye si Mungu wa wafu, bali ni Mungu wa walio hai. Ninyi mmekosea sana!” ");
INSERT INTO swh1850_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mmojawapo wa walimu wa Sheria alifika, akasikia mabishano yao. Alipoona kwamba Yesu aliwajibu vyema, akajitokeza akamwuliza, “Katika amri zote ni ipi iliyo ya kwanza?” ");
INSERT INTO swh1850_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akamjibu, “Ya kwanza ndiyo hii: Sikiliza, Israeli! Bwana Mungu wetu ndiye peke yake Bwana. ");
INSERT INTO swh1850_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mpende Bwana Mungu wako kwa moyo wako wote, kwa roho yako yote, kwa akili yako yote na kwa nguvu zako zote. ");
INSERT INTO swh1850_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na ya pili ndiyo hii: Mpende jirani yako kama unavyojipenda mwenyewe. Hakuna amri nyingine iliyo kuu kuliko hizi.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Basi, yule mwalimu wa Sheria akamwambia, “Vyema Mwalimu! Umesema kweli kwamba Mungu ni mmoja tu wala hakuna mwingine ila yeye. ");
INSERT INTO swh1850_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na ni lazima mtu kumpenda Mungu kwa moyo wote, kwa akili yote, na kwa nguvu zote, na kumpenda jirani yake kama anavyojipenda mwenyewe. Jambo hili ni muhimu zaidi kuliko dhabihu na sadaka zote za kuteketezwa.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu alipoona kwamba huyu mtu alimjibu kwa ujasiri, akamwambia, “Wewe huko mbali na Ufalme wa Mungu.” Baada ya hayo, hakuna mtu aliyethubutu tena kumwuliza kitu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wakati Yesu alipokuwa akifundisha Hekaluni, aliuliza, “Mbona walimu wa Sheria wanasema ya kwamba Kristo ni mwana wa Daudi? ");
INSERT INTO swh1850_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwenyewe akiongozwa na Roho Mtakatifu alisema: Bwana alimwambia Bwana wangu: Keti upande wangu wa kulia, Mpaka nitakapowaweka adui zako chini ya miguu yako.” ");
INSERT INTO swh1850_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi mwenyewe anamwita Kristo Bwana. Basi, Kristo atakuwaje mwanae?” Umati wa watu ulikuwa ukimsikiliza kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Katika mafundisho yake, Yesu alisema, “Jihadharini na walimu wa Sheria ambao hupenda kupitapita wamejivalia kanzu ndefu na kusalimiwa na watu kwa heshima sokoni; hupenda kuketi mahali pa heshima katika masunagogi, ");
INSERT INTO swh1850_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kuchukua nafasi za heshima katika karamu. ");
INSERT INTO swh1850_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Huwanyonya wajane huku wakijisingizia kusali sala ndefu. Siku ya hukumu watapata adhabu kali!” ");
INSERT INTO swh1850_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu alikuwa ameketi karibu na sanduku la hazina. Akawa anatazama jinsi watu wengi walivyokuwa wakitoa fedha na kuzitia katika hazina ya Hekalu. Matajiri wengi walitoa fedha nyingi. ");
INSERT INTO swh1850_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hapo akaja mama mmoja mjane maskini, akatoa sarafu mbili ndogo za fedha. ");
INSERT INTO swh1850_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu akawaita wanafunzi wake, akawaambia, “Kweli nawaambieni, huyu mama mjane maskini ametoa zaidi kuliko wengine wote waliotia fedha katika sanduku la hazina. ");
INSERT INTO swh1850_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Maana wote walitoa kutokana na ziada ya mali zao, lakini huyu mama, ingawa ni maskini, ametoa yote aliyokuwa nayo, ametoa kila kitu alichohitaji kwa kuishi.” ");
INSERT INTO swh1850_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu alipokuwa anatoka Hekaluni, mmoja wa wanafunzi wake alimwambia, “Mwalimu, tazama jinsi mawe haya na majengo haya yalivyo ya ajabu!” ");
INSERT INTO swh1850_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu akamwambia, “Je, unayaona majengo haya makubwa? Hakuna hata jiwe moja litakalosalia juu ya lingine; kila kitu kitabomolewa.” ");
INSERT INTO swh1850_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu alipokuwa ameketi juu ya mlima wa Mizeituni akielekea Hekalu, Petro, Yakobo, Yohane na Andrea wakamwuliza kwa faragha, ");
INSERT INTO swh1850_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Twambie mambo haya yatatukia lini? Ni ishara gani itakayoonyesha kwamba mambo haya karibu yatimizwe?” ");
INSERT INTO swh1850_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akaanza kuwaambia, “Jihadharini msije mkadanganywa na mtu. ");
INSERT INTO swh1850_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maana wengi watakuja wakilitumia jina langu, wakisema, Mimi ndiye! nao watawapotosha watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mtakaposikia juu ya vita na fununu za vita, msifadhaike. Mambo hayo lazima yatokee, lakini mwisho wenyewe ungali bado. ");
INSERT INTO swh1850_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Taifa moja litapigana na taifa lingine; utawala mmoja utapigana na utawala mwingine; kila mahali kutakuwa na mitetemeko ya ardhi na njaa. Mambo haya ni kama tu maumivu ya kwanza ya kujifungua mtoto. ");
INSERT INTO swh1850_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Lakini ninyi jihadharini. Maana watu watawapelekeni mahakamani, na kuwapigeni katika masunagogi. Mtapelekwa mbele ya watawala na wafalme kwa sababu yangu ili mpate kunishuhudia kwao. ");
INSERT INTO swh1850_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lakini lazima kwanza Habari Njema ihubiriwe kwa mataifa yote. ");
INSERT INTO swh1850_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nao watakapowatieni nguvuni na kuwapeleka mahakamani, msiwe na wasiwasi juu ya yale mtakayosema; saa ile itakapofika, semeni chochote mtakachopewa, maana si ninyi mtakaosema, bali Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndugu atamsaliti ndugu yake auawe; baba atamsaliti mwanae; watoto watawashambulia wazazi wao na kuwaua. ");
INSERT INTO swh1850_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Watu wote watawachukieni ninyi kwa sababu ya jina langu. Lakini atakayevumilia mpaka mwisho ndiye atakayeokolewa. ");
INSERT INTO swh1850_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mtakapoona Chukizo Haribifu limesimama mahali ambapo si pake, (msomaji na atambue maana yake!) Hapo watu walioko Yudea wakimbilie milimani. ");
INSERT INTO swh1850_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mtu aliye juu ya paa la nyumba asishuke kuingia nyumbani mwake kuchukua kitu. ");
INSERT INTO swh1850_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aliye shambani asirudi nyuma kuchukua vazi lake. ");
INSERT INTO swh1850_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ole wao waja wazito na wanaonyonyesha siku hizo! ");
INSERT INTO swh1850_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ombeni ili mambo hayo yasitukie nyakati za baridi. ");
INSERT INTO swh1850_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maana wakati huo kutakuwa na dhiki ambayo haijatokea tangu Mungu alipoumba ulimwengu mpaka leo, wala haitatokea tena. ");
INSERT INTO swh1850_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kama Bwana asingepunguza siku hizo, hakuna binadamu ambaye angeokolewa. Lakini kwa ajili ya wateule wake, Bwana amezipunguza siku hizo. ");
INSERT INTO swh1850_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Basi mtu akiwaambieni, Tazama, Kristo yupo hapa! au Yupo pale! msimsadiki. ");
INSERT INTO swh1850_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maana watatokea kina Kristo wa uongo na manabii wa uongo, watafanya ishara na maajabu, ili kuwapotosha wateule wa Mungu, kama ikiwezekana. ");
INSERT INTO swh1850_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lakini ninyi jihadharini. Mimi nimewaambieni mambo yote kabla hayajatokea. ");
INSERT INTO swh1850_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Basi, siku hizo baada ya dhiki hiyo, jua litatiwa giza na mwezi hautaangaza. ");
INSERT INTO swh1850_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyota zitaanguka kutoka angani, na nguvu za mbingu zitatikiswa. ");
INSERT INTO swh1850_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hapo watamwona Mwana wa Mtu akija katika mawingu kwa nguvu nyingi na utukufu. ");
INSERT INTO swh1850_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kisha atawatuma malaika wake; atawakusanya wateule wake kutoka pande zote nne za dunia, kutoka mwisho wa dunia mpaka mwisho wa mbingu. ");
INSERT INTO swh1850_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kwa mtini jifunzeni mfano huu: Mara tu matawi yake yanapoanza kuwa laini na kuchanua majani, mnajua kwamba wakati wa kiangazi umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hali kadhalika nanyi mtakapoona mambo hayo yakitendeka, jueni kwamba Mwana wa Mtu yuko karibu sana. ");
INSERT INTO swh1850_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nawaambieni kweli, kizazi hiki hakitapita kabla ya mambo hayo yote kutukia. ");
INSERT INTO swh1850_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbingu na dunia zitapita, lakini maneno yangu hayatapita kamwe. ");
INSERT INTO swh1850_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lakini hakuna mtu ajuaye siku au saa hiyo itakuja lini; wala malaika wa mbinguni, wala Mwana; Baba peke yake ndiye ajuaye. ");
INSERT INTO swh1850_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muwe waangalifu na kesheni, maana hamjui wakati huo utafika lini. ");
INSERT INTO swh1850_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Itakuwa kama mtu anayeondoka nyumbani kwenda safari akiwaachia watumishi wake madaraka, kila mmoja na kazi yake; akamwambia mlinzi wa mlango awe macho. ");
INSERT INTO swh1850_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kesheni, basi, kwa maana hamjui mwenye nyumba atarudi lini; huenda ikawa jioni, usiku wa manane, alfajiri au asubuhi. ");
INSERT INTO swh1850_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kesheni ili akija ghafla asije akawakuta mmelala. ");
INSERT INTO swh1850_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ninayowaambieni ninyi, nawaambia wote: Kesheni!” ");
INSERT INTO swh1850_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ilikuwa siku mbili tu kabla ya sikukuu ya Pasaka na ya Mikate Isiyotiwa Chachu. Makuhani wakuu na walimu wa Sheria walikuwa wakitafuta njia ya kumtia Yesu nguvuni kwa hila wamuue. ");
INSERT INTO swh1850_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lakini walisema, “Tusimtie nguvuni wakati wa sikukuu, watu wasije wakafanya ghasia.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu alikuwa Bethania, nyumbani kwa Simoni, Mkoma. Alipokuwa mezani kula chakula, mama mmoja aliyekuwa na chupa ya alabasta yenye marashi ya nardo safi ya thamani kubwa alikuja, akaivunja hiyo chupa, akammiminia Yesu marashi hayo kichwani. ");
INSERT INTO swh1850_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Baadhi ya watu waliokuwa hapo walikasirika wakajisemea, “Kwa nini kupoteza ovyo marashi haya? ");
INSERT INTO swh1850_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yangaliweza kuuzwa kwa fedha kiasi cha denari mia tatu, wakapewa maskini!” Wakamkemea huyo mama. ");
INSERT INTO swh1850_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lakini Yesu akawaambia, “Mwacheni; kwa nini mnamsumbua? Amenitendea jambo jema. ");
INSERT INTO swh1850_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maskini mnao daima pamoja nanyi; mnaweza kuwasaidia wakati wowote mnaopenda. Lakini mimi sitakuwapo pamoja nanyi daima. ");
INSERT INTO swh1850_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yeye amefanya alivyoweza; ameupaka mwili wangu marashi kuutayarisha kwa maziko. ");
INSERT INTO swh1850_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nawaambieni kweli, popote ulimwenguni Habari Njema itakapohubiriwa, kitendo hiki alichofanya kitatajwa kwa ajili ya kumkumbuka.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kisha Yuda Iskarioti, mmoja wa wale kumi na wawili, alienda kwa makuhani wakuu ili kumsaliti Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Makuhani wakuu waliposikia habari hiyo, walifurahi, wakaahidi kumpa fedha. Basi, Yuda akaanza kutafuta nafasi ya kumsaliti Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Siku ya kwanza ya sikukuu ya Mikate Isiyotiwa Chachu, wakati ambapo mwana kondoo wa Pasaka huchinjwa, wanafunzi wake walimwuliza, “Wataka tukuandalie wapi karamu ya Pasaka?” ");
INSERT INTO swh1850_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Basi Yesu akawatuma wawili wa wanafunzi wake akiwaambia, “Nendeni mjini, nanyi mtakutana na mtu anayebeba mtungi wa maji. Mfuateni ");
INSERT INTO swh1850_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka katika nyumba atakayoingia, mkamwambie mwenye nyumba, Mwalimu anasema: wapi chumba changu ambamo nitakula Pasaka pamoja na wanafunzi wangu? ");
INSERT INTO swh1850_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naye atawaonyesha chumba kikubwa ghorofani kilichotayarishwa na kupambwa. Tuandalieni humo.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanafunzi wakaondoka, wakaenda mjini, wakakuta kila kitu sawa kama Yesu alivyokuwa amewaambia. Wakaandaa karamu ya Pasaka. ");
INSERT INTO swh1850_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ilipokuwa jioni, Yesu alifika pamoja na wanafunzi wake kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Walipokuwa mezani wakila, Yesu alisema, “Kweli nawaambieni, mmoja wenu anayekula pamoja nami, atanisaliti.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hapo wanafunzi wake wakaanza kuhuzunika, wakamwuliza mmojammoja, “Je, ni mimi?” ");
INSERT INTO swh1850_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu akawaambia, “Ni mmoja wenu ninyi kumi na wawili, anayechovya mkate pamoja nami katika bakuli. ");
INSERT INTO swh1850_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kweli Mwana wa Mtu anakwenda zake kama Maandiko Matakatifu yanavyosema juu yake; lakini, ole wake mtu yule anayemsaliti Mwana wa Mtu! Ingalikuwa afadhali kwa mtu huyo kama hangalizaliwa!” ");
INSERT INTO swh1850_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Walipokuwa wanakula, Yesu alitwaa mkate, akashukuru, akaumega na kuwapa wanafunzi wake akisema, “Twaeni; huu ni mwili wangu.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kisha akatwaa kikombe, akamshukuru Mungu, akawapa; nao wote wakanywa katika kikombe hicho. ");
INSERT INTO swh1850_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akawaambia, “Hii ni damu yangu inayothibitisha agano la Mungu, damu inayomwagwa kwa ajili ya watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kweli nawaambieni, sitakunywa tena divai ya zabibu mpaka siku ile nitakapoinywa upya katika Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kisha wakaimba wimbo, wakaondoka, wakaenda katika mlima wa Mizeituni. ");
INSERT INTO swh1850_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu akawaambia wanafunzi wake, “Ninyi nyote mtakuwa na mashaka nami; maana Maandiko Matakatifu yasema: Nitampiga mchungaji nao kondoo watatawanyika. ");
INSERT INTO swh1850_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini nikisha fufuka, nitawatangulieni kule Galilaya.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro akamwambia “Hata kama wote watakuwa na mashaka nawe na kukuacha, mimi sitakukana kamwe!” ");
INSERT INTO swh1850_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu akamwambia, “Kweli nakwambia, usiku huu, kabla jogoo hajawika mara mbili, utanikana mara tatu.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petro akasisitiza, “Hata kama ni lazima nife pamoja nawe, sitakuacha kamwe.” Wanafunzi wote pia wakasema vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Basi, wakafika katika bustani iitwayo Gethsemane. Yesu akawaambia wanafunzi wake, “Kaeni hapa wakati mimi nasali.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kisha akawachukua Petro, Yakobo na Yohane; akaanza kufadhaika sana na kuhangaika. ");
INSERT INTO swh1850_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akawaambia, “Nina huzuni kubwa moyoni hata karibu kufa. Kaeni hapa mkeshe.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akaenda mbele kidogo, akajitupa chini kifudifudi, akasali kwamba, kama ingewezekana, asiipitie saa hiyo ya mateso. ");
INSERT INTO swh1850_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akasema, “Baba yangu, kwako mambo yote yanawezekana. Uniondolee kikombe hiki; lakini isiwe kama nitakavyo mimi, bali utakavyo wewe.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kisha akarudi kwa wanafunzi wale watatu, akawakuta wamelala. Basi, akamwuliza Petro, “Simoni, je umelala? Hukuweza kukesha hata saa moja?” ");
INSERT INTO swh1850_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kisha akawaambia, “Kesheni na kusali ili msije mkaingia katika majaribu. Roho i radhi, lakini mwili ni dhaifu.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akaenda kusali tena akirudia maneno yaleyale. ");
INSERT INTO swh1850_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kisha akarudi tena, akawakuta wamelala. Macho yao yalikuwa yamebanwa na usingizi. Hawakujua la kumjibu. ");
INSERT INTO swh1850_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Alipowajia mara ya tatu aliwaambia, “Mnalala bado na kupumzika? Sasa imetosha! Saa imefika! Mwana wa Mtu anakabidhiwa kwa watu waovu. ");
INSERT INTO swh1850_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amkeni, twendeni zetu. Tazameni, yule atakayenisaliti amekaribia.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu alipokuwa bado anasema, Yuda, mmoja wa wale kumi na wawili, akafika pamoja na umati wa watu wenye mapanga na marungu. Watu hao walikuwa wametumwa na makuhani wakuu, walimu wa Sheria na wazee. ");
INSERT INTO swh1850_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Msaliti Yuda alikuwa amewapa ishara: “Yule nitakayembusu ndiye; mkamateni, mkampeleke chini ya ulinzi.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda alipofika tu, alimwendea Yesu moja kwa moja, akasema, “Mwalimu!” Kisha akambusu. ");
INSERT INTO swh1850_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Basi, hao watu wakamkamata Yesu, wakamtia nguvuni. ");
INSERT INTO swh1850_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mmoja wa wale waliokuwa wamesimama hapo pamoja na Yesu akauchomoa upanga wake, akampiga mtumishi wa Kuhani Mkuu, akamkata sikio. ");
INSERT INTO swh1850_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu akawaambia, “Je, mmekuja na mapanga na marungu kunikamata kana kwamba mimi ni mnyang'anyi? ");
INSERT INTO swh1850_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila siku nilikuwa pamoja nanyi nikifundisha Hekaluni, wala hamkunikamata. Lakini sasa lazima Maandiko Matakatifu yatimie.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hapo wanafunzi wote wakamwacha, wakakimbia. ");
INSERT INTO swh1850_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kulikuwa na kijana mmoja aliyekuwa anamfuata Yesu akiwa amevaa shuka. Nao wakajaribu kumkamata. ");
INSERT INTO swh1850_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lakini yeye akaponyoka, akaiachilia ile shuka, akakimbia uchi. ");
INSERT INTO swh1850_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Basi, wakampeleka Yesu kwa Kuhani Mkuu ambapo makuhani wakuu wote, wazee na walimu wa Sheria walikuwa wamekutanika. ");
INSERT INTO swh1850_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro alimfuata Yesu kwa mbali, akaingia ndani ya ya wa Kuhani Mkuu, akaketi pamoja na walinzi akiota moto. ");
INSERT INTO swh1850_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Makuhani wakuu na Baraza lote wakatafuta ushahidi wa kumshtaki Yesu wapate kumwua, lakini hawakupata. ");
INSERT INTO swh1850_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Watu wengi walitoa ushahidi wa uongo juu ya Yesu, lakini ushahidi wao haukupatana. ");
INSERT INTO swh1850_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kisha wengine walisimama, wakatoa ushahidi wa uongo wakisema: ");
INSERT INTO swh1850_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tulimsikia mtu huyu akisema, Nitaliharibu Hekalu hili lililojengwa kwa mikono, na kwa siku tatu nitajenga lingine lisilojengwa kwa mikono.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lakini hata hivyo, ushahidi wao haukupatana. ");
INSERT INTO swh1850_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Basi, Kuhani Mkuu akasimama katikati yao, akamwuliza Yesu, “Je, hujibu neno? Watu hawa wanashuhudia nini dhidi yako?” ");
INSERT INTO swh1850_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini yeye akakaa kimya; hakusema hata neno moja. Kuhani Mkuu akamwuliza tena, “Je, wewe ndiwe Kristo, Mwana wa Mungu Mtukufu?” ");
INSERT INTO swh1850_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akajibu, “Naam, mimi ndiye. Tena, mtamwona Mwana wa Mtu amekaa upande wa kulia wa Mwenyezi, akija katika mawingu ya mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hapo Kuhani Mkuu akararua joho lake, akasema, “Tuna haja gani tena ya mashahidi? ");
INSERT INTO swh1850_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mmesikia kufuru yake! Ninyi mwaonaje?” Wote wakaamua kwamba anastahili kuuawa. ");
INSERT INTO swh1850_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Basi, baadhi yao wakaanza kumtemea mate, wakamfunika uso, wakampiga na kumwambia, “Bashiri ni nani aliyekupiga!” Hata watumishi wakamchukua, wakampiga makofi. ");
INSERT INTO swh1850_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petro alipokuwa bado chini ukumbini, mmoja wa wajakazi wa kuhani Mkuu alikuja. ");
INSERT INTO swh1850_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Alipomwona Petro akiota moto, alimtazama, akamwambia, “Hata wewe ulikuwa pamoja na Yesu Mnazareti.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini Petro akakana, “Sijui, wala sielewi unayosema!” Kisha Petro akaondoka, akaenda nje uani. Hapo jogoo akawika. ");
INSERT INTO swh1850_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yule mjakazi alipomwona tena Petro, akaanza tena kuwaambia watu waliokuwa wamesimama hapo, “Mtu huyu ni mmoja wao.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petro akakana tena. Baadaye kidogo, watu waliokuwa wamesimama hapo wakamwambia Petro, “Hakika wewe ni mmoja wao, maana wewe ni Mgalilaya.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lakini Petro akaanza kulaani na kuapa akisema, “Mimi simjui mtu huyu mnayesema habari zake.” ");
INSERT INTO swh1850_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hapo jogoo akawika mara ya pili. Basi, Petro akakumbuka jinsi Yesu alivyokuwa amemwambia: “Kabla jogoo hajawika mara mbili, utanikana mara tatu.” Petro akabubujika machozi. ");
INSERT INTO swh1850_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kulipopambazuka, makuhani wakuu walifanya shauri pamoja na wazee, walimu wa Sheria na Baraza lote, wakamfunga Yesu pingu, wakampeleka na kumkabidhi kwa Pilato. ");
INSERT INTO swh1850_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato akamwuliza Yesu, “Je, wewe ni mfalme wa Wayahudi?” Yesu akajibu, “Wewe umesema.” ");
INSERT INTO swh1850_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Makuhani wakuu wakamshtaki Yesu mambo mengi. ");
INSERT INTO swh1850_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato akamwuliza tena Yesu, “Je, hujibu neno? Tazama wanavyotoa mashtaka mengi juu yako.” ");
INSERT INTO swh1850_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu hakujibu neno, hata pilato akashangaa. ");
INSERT INTO swh1850_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila wakati wa sikukuu ya Pasaka, Pilato alikuwa na desturi ya kuwafungulia mfungwa mmoja waliyemtaka. ");
INSERT INTO swh1850_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Basi, kulikuwa na mtu mmoja aitwaye Baraba, ambaye alikuwa amefungwa pamoja na waasi wengine kwa kusababisha uasi na mauaji. ");
INSERT INTO swh1850_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Watu wengi wakamwendea Pilato wakamwomba awafanyie kama kawaida yake. ");
INSERT INTO swh1850_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato akawauliza, “Je, mwataka niwafungulieni Mfalme wa Wayahudi?” ");
INSERT INTO swh1850_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Alisema hivyo kwa sababu alijua wazi kwamba makuhani wakuu walimkabidhi Yesu kwake kwa sababu ya wivu. ");
INSERT INTO swh1850_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini makuhani wakuu wakawachochea watu wamwombe Pilato awafungulie Baraba. ");
INSERT INTO swh1850_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato akawauliza tena, “Basi, sasa mwataka nifanye nini na mtu huyu mnayemwita Mfalme wa Wayahudi?” ");
INSERT INTO swh1850_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Watu wote wakapaaza sauti tena: “Msulubishe!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lakini Pilato akawauliza, “Kwa nini! Amefanya kosa gani?” Lakini wao wakazidi kupaaza sauti, “Msulubishe!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato alitaka kuuridhisha huo umati wa watu; basi, akamwachilia Baraba kutoka gerezani. Akaamuru Yesu apigwe viboko, kisha akamtoa asulubiwe. ");
INSERT INTO swh1850_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kisha askari walimpeleka Yesu ndani ukumbini, katika ikulu, wakakusanya kikosi kizima cha askari. ");
INSERT INTO swh1850_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wakamvika vazi la rangi ya zambarau, wakasokota taji ya miiba, wakamwekea kichwani. ");
INSERT INTO swh1850_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wakaanza kumsalimu, “Shikamoo Mfalme wa Wayahudi!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wakampiga kichwani kwa mwanzi, wakamtemea mate; wakampigia magoti na kumsujudia. ");
INSERT INTO swh1850_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baada ya kumdhihaki, walimvua lile joho, wakamvika nguo zake, kisha wakampeleka kumsulubisha. ");
INSERT INTO swh1850_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Walipokuwa njiani, walikutana na mtu mmoja aitwaye Simoni, mwenyeji wa Kurene. Yeye alikuwa baba wa Aleksanda na Rufo, na wakati huo alikuwa akitoka shambani. Basi, wakamlazimisha auchukue msalaba wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kisha wakampeleka Yesu mpaka mahali palipoitwa Golgotha, maana yake, “Mahali pa Fuvu la Kichwa.” ");
INSERT INTO swh1850_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wakampa divai iliyochanganywa na manemane, lakini yeye akaikataa. ");
INSERT INTO swh1850_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Basi, wakamsulubisha, wakagawana mavazi yake kwa kuyapigia kura waamue nani angepata nini. ");
INSERT INTO swh1850_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ilikuwa saa tatu asubuhi walipomsulubisha. ");
INSERT INTO swh1850_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na mshtaka wake ulikuwa umeandikwa: “Mfalme wa Wayahudi.” ");
INSERT INTO swh1850_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pamoja naye waliwasulubisha wanyang'anyi wawili, mmoja upande wake wa kulia na mwingine upande wake wa kushoto. ");
INSERT INTO swh1850_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hapo yakatimia Maandiko Matakatifu yanayosema, “Aliwekwa kundi moja na waovu.” ");
INSERT INTO swh1850_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Watu waliokuwa wanapita mahali hapo walimtukana, wakitikisa vichwa vyao na kusema, “Aha! Wewe mwenye kuvunja Hekalu na kulijenga kwa siku tatu! ");
INSERT INTO swh1850_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sasa, shuka msalabani ujiokoe mwenyewe!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nao makuhani wakuu pamoja na walimu wa Sheria walimdhihaki wakisema, “Aliwaokoa wengine, lakini kujiokoa mwenyewe hawezi! ");
INSERT INTO swh1850_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eti yeye ni Kristo, Mfalme wa Israeli! Basi, na ashuke msalabani ili tuone na kuamini.” Hata watu wale waliosulubiwa pamoja naye walimtukana. ");
INSERT INTO swh1850_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tangu saa sita mchana mpaka saa tisa kulikuwa giza nchini kote. ");
INSERT INTO swh1850_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa alasiri Yesu akalia kwa sauti kubwa, “Eloi, Eloi, lema sabakthani?” Maana yake, “Mungu wangu, Mungu wangu, mbona umeniacha?” ");
INSERT INTO swh1850_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Baadhi ya watu waliosimama pale waliposikia hivyo, walisema, “Sikiliza! Anamwita Eliya!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mtu mmoja akakimbia, akachovya sifongo katika siki, akaiweka juu ya mwanzi, akampa anywe akisema, “Hebu tuone kama Eliya atakuja kumteremsha msalabani!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu akapaaza sauti kubwa, akakata roho. ");
INSERT INTO swh1850_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Basi, pazia la Hekalu likapasuka vipande viwili toka juu mpaka chini. ");
INSERT INTO swh1850_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jemadari mmoja aliyekuwa amesimama mbele yake aliona jinsi Yesu alivyolia kwa sauti na kukata roho, akasema, “Kweli mtu huyu alikuwa Mwana wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Walikuwako pia wanawake waliotazama kwa mbali, miongoni mwao akiwa Maria toka mji wa Magdala, Salome, na Maria mama wa kina Yakobo mdogo na Yose. ");
INSERT INTO swh1850_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hawa walimfuata Yesu alipokuwa Galilaya na kumtumikia. Kulikuwa na wanawake wengine wengi waliokuja Yerusalemu pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wakati wa jioni ulikuwa umekwisha fika. Hiyo ilikuwa siku ya Maandalio, yaani siku inayotangulia Sabato. ");
INSERT INTO swh1850_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hapo akaja Yosefu mwenyeji wa Armathaya, mjumbe wa Baraza Kuu, aliyeheshimika sana. Yeye pia alikuwa anatazamia kuja kwa Ufalme wa Mungu. Basi, alimwendea Pilato bila uoga, akaomba apewe mwili wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato alishangaa kusikia kwamba Yesu alikuwa amekwisha kufa. Basi, akamwita jemadari, akamwuliza kama Yesu alikuwa amekufa kitambo. ");
INSERT INTO swh1850_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato alipoarifiwa na huyo jemadari kwamba Yesu alikuwa amekwisha kufa, akamruhusu Yosefu auchukue mwili wake. ");
INSERT INTO swh1850_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hapo Yosefu akanunua sanda ya kitani, akauteremsha chini huo mwili, akauzungushia sanda. Akauweka katika kaburi lililokuwa limechongwa mwambani, kisha akavingirisha jiwe kubwa mbele ya mlango. ");
INSERT INTO swh1850_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nao Maria Magdalene na Maria mama yake Yose walipaona hapo alipolazwa. ");
INSERT INTO swh1850_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Baada ya siku ya Sabato, Maria Magdalene, Salome na Maria mama yake Yakobo walinunua manukato ili wakaupake mwili wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Basi, alfajiri na mapema siku ya Jumapili, jua lilipoanza kuchomoza, walienda kaburini. ");
INSERT INTO swh1850_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nao wakawa wanaambiana, “Nani atakayetuondolea lile jiwe mlangoni mwa kaburi?” ");
INSERT INTO swh1850_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lakini walipotazama, waliona jiwe limekwisha ondolewa. (Nalo lilikuwa kubwa mno.) ");
INSERT INTO swh1850_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Walipoingia kaburini, walimwona kijana mmoja aliyevaa vazi jeupe, ameketi upande wa kulia; wakashangaa sana. ");
INSERT INTO swh1850_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lakini huyo kijana akawaambia, “Msishangae. Mnamtafuta Yesu wa Nazareti aliyesulubiwa. Amefufuka, hayumo hapa. Tazameni mahali walipokuwa wamemlaza. ");
INSERT INTO swh1850_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nendeni mkawaambie wanafunzi wake pamoja na Petro ya kwamba anawatangulieni kule Galilaya. Huko mtamwona kama alivyowaambieni.” ");
INSERT INTO swh1850_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Basi, wakatoka pale kaburini mbio, maana walitetemeka kwa hofu na kushangaa. Hawakumwambia mtu yeyote kitu, kwa sababu waliogopa mno. ");
INSERT INTO swh1850_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu alipofufuka mapema Jumapili, alijionyesha kwanza kwa Maria Magdalene, ambaye Yesu alikuwa amemtoa pepo saba. ");
INSERT INTO swh1850_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Magdalene akaenda, akawajulisha wale waliokuwa pamoja na Yesu, na wakati huo walikuwa wanaomboleza na kulia. ");
INSERT INTO swh1850_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lakini waliposikia ya kwamba Yesu yu hai na kwamba Maria Magdalene amemwona, hawakuamini. ");
INSERT INTO swh1850_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baadaye Yesu aliwatokea wanafunzi wawili akiwa na sura nyingine. Wanafunzi hao walikuwa wanakwenda shambani. ");
INSERT INTO swh1850_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nao pia wakaenda wakawaambia wenzao. Hata hivyo hawakuamini. ");
INSERT INTO swh1850_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mwishowe, Yesu aliwatokea wanafunzi kumi na mmoja walipokuwa pamoja mezani. Akawakemea sana kwa sababu ya kutoamini kwao na ukaidi wao, maana hawakuwaamini wale waliokuwa wamemwona baada ya kufufuka. ");
INSERT INTO swh1850_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Basi, akawaambia, “Nendeni ulimwenguni kote mkahubiri Habari Njema kwa kila mtu. ");
INSERT INTO swh1850_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Anayeamini na kubatizwa ataokolewa; asiyeamini atahukumiwa. ");
INSERT INTO swh1850_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ishara hizi zitaandamana na wale wanaoamini: kwa jina langu watatoa pepo na watasema kwa lugha mpya. ");
INSERT INTO swh1850_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wakishika nyoka au wakinywa kitu chochote chenye sumu, hakitawadhuru. Watawawekea wagonjwa mikono, nao watapona.” ");
INSERT INTO swh1850_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Basi, Bwana Yesu alipokwisha sema nao, akachukuliwa mbinguni, akaketi upande wa kulia wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wanafunzi wakaenda wakihubiri kila mahali. Bwana akafanya kazi pamoja nao na kuimarisha ujumbe huo kwa ishara zilizoandamana nao. ");
INSERT INTO swh1850_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mheshimiwa Theofilo: Watu wengi wamejitahidi kuandika juu ya mambo yale yaliyotendeka kati yetu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Waliandika kama tulivyoelezwa na wale walioyaona kwa macho yao tangu mwanzo, na waliotangaza ujumbe huo. ");
INSERT INTO swh1850_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Inafaa nami pia, Mheshimiwa, baada ya kuchunguza kwa makini mambo yote tangu mwanzo, nikuandikie kwa mpango, ");
INSERT INTO swh1850_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ili nawe uweze kujionea mwenyewe ukweli wa mambo yale uliyofundishwa. ");
INSERT INTO swh1850_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wakati Herode alipokuwa mfalme wa Yudea, kulikuwa na kuhani mmoja jina lake Zakaria, wa kikundi cha Abia. Mke wake alikuwa anaitwa Elisabeti, naye alikuwa wa ukoo wa kuhani Aroni. ");
INSERT INTO swh1850_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wote wawili walikuwa wanyofu mbele ya Mungu, wakiishi kwa kufuata amri na maagizo yote ya Bwana bila lawama. ");
INSERT INTO swh1850_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lakini hawakuwa wamejaliwa watoto kwa vile Elisabeti alikuwa tasa, nao wote wawili walikuwa wazee sana. ");
INSERT INTO swh1850_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Siku moja, ilipokuwa zamu yake ya kutoa huduma ya ukuhani mbele ya Mungu, ");
INSERT INTO swh1850_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakariya alichaguliwa kwa kura, kama ilivyokuwa desturi, kuingia hekaluni ili afukize ubani. ");
INSERT INTO swh1850_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Watu, umati mkubwa, walikuwa wamekusanyika nje wanasali wakati huo wa kufukiza ubani. ");
INSERT INTO swh1850_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Malaika wa Bwana akamtokea humo ndani, akasimama upande wa kulia wa madhabahu ya kufukizia ubani. ");
INSERT INTO swh1850_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya alipomwona alifadhaika, hofu ikamwingia. ");
INSERT INTO swh1850_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini malaika akamwambia, “Zakariya, usiogope, kwa maana sala yako imesikilizwa, na Elisabeti mkeo atakuzalia mtoto wa kiume, nawe utampa jina Yohane. ");
INSERT INTO swh1850_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Utakuwa na furaha kubwa na watu wengi watashangilia kwa sababu ya kuzaliwa kwake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Atakuwa mkuu mbele ya Bwana. Hatakunywa divai wala kileo, atajazwa Roho Mtakatifu tangu tumboni mwa mama yake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Atawaelekeza wengi wa watu wa Israeli kwa Bwana Mungu wao. ");
INSERT INTO swh1850_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Atamtangulia Bwana akiongozwa na nguvu na roho kama Eliya. Atawapatanisha kina baba na watoto wao; atawafanya wasiotii wawe na fikira za uadilifu, na hivyo amtayarishie Bwana watu wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya akamwambia huyo malaika, “Ni kitu gani kitakachonihakikishia jambo hilo? Mimi ni mzee, hali kadhalika na mke wangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika akamjibu, “Mimi ni Gabrieli, nisimamaye mbele ya Mungu, na nimetumwa niseme nawe, nikuletee hii habari njema. ");
INSERT INTO swh1850_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sikiliza, utakuwa bubu kwa sababu huyasadiki haya maneno yatakayotimia kwa wakati wake. Hutaweza kusema mpaka hayo niliyokuambia yatakapotimia.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wakati huo, wale watu walikuwa wanamngoja Zakariya huku wakishangaa juu ya kukawia kwake Hekaluni. ");
INSERT INTO swh1850_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Alipotoka nje, hakuweza kusema nao. Ikawa dhahiri kwao kwamba alikuwa ameona maono Hekaluni. Lakini akawa anawapa ishara kwa mikono, akabaki bubu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zamu yake ya kuhudumu ilipokwisha, alirudi nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baadaye Elisabeti mkewe akapata mimba. Akajificha nyumbani kwa muda wa miezi mitano, akisema: ");
INSERT INTO swh1850_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Hivi ndivyo alivyonitendea Bwana; ameniangalia na kuniondolea aibu niliyokuwa nayo mbele ya watu.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mnamo mwezi wa sita, malaika Gabrieli alitumwa na Mungu aende kwenye mji uitwao Nazareti huko Galilaya, ");
INSERT INTO swh1850_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa msichana mmoja aitwaye Maria, mchumba wa mtu mmoja jina lake Yosefu, wa ukoo wa Daudi. ");
INSERT INTO swh1850_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika akamwendea, akamwambia, “Salamu Maria! Umejaliwa neema nyingi! Bwana yu pamoja nawe.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria aliposikia maneno hayo alifadhaika sana, akawaza: maneno haya yanamaanisha nini? ");
INSERT INTO swh1850_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika akamwambia, “Usiogope Maria, kwa maana Mungu amekujalia neema. ");
INSERT INTO swh1850_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Utachukua mimba, utamzaa mtoto wa kiume na utampa jina Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yeye atakuwa mkuu na ataitwa Mwana wa Mungu Mkuu. Bwana Mungu atampa kiti cha mfalme Daudi, babu yake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kwa hivyo atautawala ukoo wa Yakobo milele, na ufalme wake hautakuwa na mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria akamjibu, “Yatawezekanaje hayo, hali mimi ni bikira?” ");
INSERT INTO swh1850_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika akamjibu, “Roho Mtakatifu atakushukia, na uwezo wake Mungu Mkuu utakujia kama kivuli; kwa sababu hiyo, mtoto atakayezaliwa ataitwa Mtakatifu, Mwana wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ujue pia kwamba hata Elisabeti, jamaa yako, naye amepata mimba ingawa ni mzee, na sasa ni mwezi wa sita kwake yeye ambaye watu walimfahamu kuwa tasa. ");
INSERT INTO swh1850_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwa maana hakuna jambo lisilowezekana kwa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria akasema, “Mimi ni mtumishi wa Bwana, nitendewe kama ulivyosema.” Kisha yule malaika akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Siku kadhaa baadaye, Maria alifunga safari akaenda kwa haraka hadi mji mmoja ulioko katika milima ya Yuda. ");
INSERT INTO swh1850_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Huko, aliingia katika nyumba ya Zakariya, akamsalimu Elisabeti. ");
INSERT INTO swh1850_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mara tu Elisabeti aliposikia sauti ya Maria, mtoto mchanga tumboni mwake Elisabeti akaruka. Naye Elisabeti akajazwa Roho Mtakatifiu, ");
INSERT INTO swh1850_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","akasema kwa sauti kubwa, “Umebarikiwa kuliko wanawake wote, naye utakayemzaa amebarikiwa. ");
INSERT INTO swh1850_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mimi ni nani hata mama wa Bwana wangu afike kwangu? ");
INSERT INTO swh1850_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nakwambia, mara tu niliposikia sauti yako, mtoto mchanga tumboni mwangu aliruka kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Heri yako wewe uliyesadiki kwamba yatatimia yale Bwana aliyokwambia.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Naye Maria akasema, ");
INSERT INTO swh1850_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Moyo wangu wamtukuza Bwana, roho yangu inafurahi kwa sababu ya Mungu Mwokozi wangu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwa kuwa amemwangalia kwa huruma mtumishi wake mnyenyekevu. Hivyo tangu sasa watu wote wataniita mwenye heri. ");
INSERT INTO swh1850_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwa kuwa Mwenyezi Mungu amenitendea makuu, jina lake ni takatifu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Huruma yake kwa watu wanaomcha hudumu kizazi hata kizazi. ");
INSERT INTO swh1850_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Amefanya mambo makuu kwa mkono wake: amewatawanya wenye kiburi katika mawazo ya mioyo yao; ");
INSERT INTO swh1850_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","amewashusha wenye nguvu kutoka vitu vyao vya enzi, akawakweza wanyenyekevu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wenye njaa amewashibisha mema, matajiri amewaacha waende mikono mitupu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amemsaidia Israeli mtumishi wake, akikumbuka huruma yake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kama alivyowaahidia wazee wetu Abrahamu na wazawa wake hata milele.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria alikaa na Elisabeti kwa muda upatao miezi mitatu, halafu akarudi nyumbani kwake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wakati wa kujifungua kwake Elisabeti ulifika, akajifungua mtoto wa kiume. ");
INSERT INTO swh1850_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jirani na watu wa jamaa yake walipopata habari kwamba Bwana amemwonea huruma kubwa, walifurahi pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Halafu siku ya nane walifika kumtahiri mtoto, wakataka kumpa jina la baba yake, Zakariya. ");
INSERT INTO swh1850_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lakini mama yake akasema, “La, sivyo, bali ataitwa Yohane.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wakamwambia, “Mbona hakuna yeyote katika ukoo wake mwenye jina hilo?” ");
INSERT INTO swh1850_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Basi, wakamwashiria baba yake wapate kujua alitaka mtoto wake apewe jina gani. ");
INSERT INTO swh1850_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naye akaomba kibao cha kuandikia, akaandika hivi: “Yohane ndilo jina lake.” Wote wakastaajabu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Papo hapo midomo na ulimi wake Zakariya vikafunguliwa, akawa anaongea akimsifu Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hofu ikawaingia jirani wote, na habari hizo zikaenea kila mahali katika milima ya Yudea. ");
INSERT INTO swh1850_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wote waliosikia mambo hayo waliyatafakari mioyoni mwao wakisema: “Mtoto huyu atakuwa mtu wa namna gani?” Maana, hakika nguvu ya Bwana ilikuwa pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya, baba yake mtoto, akajazwa Roho Mtakatifu, akatamka ujumbe wa Mungu: ");
INSERT INTO swh1850_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Asifiwe Bwana Mungu wa Israeli, kwani amekuja kuwasaidia na kuwakomboa watu wake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ametupatia Mwokozi shujaa, mzawa wa Daudi mtumishi wake. ");
INSERT INTO swh1850_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aliahidi hapo kale kwa njia ya manabii wake watakatifu, ");
INSERT INTO swh1850_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kwamba atatuokoa mikononi mwa adui zetu na kutoka mikononi mwa wote wanaotuchukia. ");
INSERT INTO swh1850_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Alisema atawahurumia wazee wetu, na kukumbuka agano lake takatifu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kiapo alichomwapia Abrahamu baba yetu, ni kwamba atatujalia sisi ");
INSERT INTO swh1850_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tukombolewe kutoka adui zetu, tupate kumtumikia bila hofu, ");
INSERT INTO swh1850_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa unyofu na uadilifu mbele yake, siku zote za maisha yetu. ");
INSERT INTO swh1850_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nawe mwanangu, utaitwa, nabii wa Mungu Mkuu, utamtangulia Bwana kumtayarishia njia yake; ");
INSERT INTO swh1850_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kuwatangazia watu kwamba wataokolewa kwa kuondolewa dhambi zao. ");
INSERT INTO swh1850_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mungu wetu ni mpole na mwenye huruma. Atasababisha pambazuko angavu la ukombozi litujie kutoka juu, ");
INSERT INTO swh1850_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kuwaangazia wote wanaokaa katika giza kuu la kifo, aongoze hatua zetu katika njia ya amani.” ");
INSERT INTO swh1850_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mtoto akakua, akapata nguvu rohoni. Alikaa jangwani mpaka alipojionyesha rasmi kwa watu wa Israeli. ");
INSERT INTO swh1850_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Siku zile, tangazo rasmi lilitolewa na Kaisari Augusto kuwataka watu wote chini ya utawala wake wajiandikishe. ");
INSERT INTO swh1850_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuandikishwa huku kulikuwa mara ya kwanza, wakati Kirenio alipokuwa mkuu wa mkoa wa Siria. ");
INSERT INTO swh1850_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Basi, wote waliohusika walikwenda kujiandikisha, kila mtu katika mji wake. ");
INSERT INTO swh1850_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefu pia alifanya safari kutoka mjini Nazareti mkoani Galilaya. Kwa kuwa alikuwa wa jamaa na ukoo wa Daudi alikwenda mjini Bethlehemu mkoani Yuda alikozaliwa Mfalme Daudi. ");
INSERT INTO swh1850_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Alikwenda kujiandikisha pamoja na mchumba wake Maria ambaye alikuwa mja mzito. ");
INSERT INTO swh1850_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Walipokuwa huko, siku yake ya kujifungua ikawadia, ");
INSERT INTO swh1850_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","akajifungua mtoto wake wa kwanza wa kiume, akamvika nguo za kitoto, akamlaza horini kwa sababu hawakupata nafasi katika nyumba ya wageni. ");
INSERT INTO swh1850_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Katika sehemu hizo, walikuwako wachungaji wakikesha usiku mbugani kulinda mifugo yao. ");
INSERT INTO swh1850_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaika wa Bwana akawatokea ghafla, na utukufu wa Bwana ukawaangazia pande zote. Wakaogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malaika akawaambia, “Msiogope! Nimewaleteeni habari njema ya furaha kuu kwa watu wote. ");
INSERT INTO swh1850_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwa maana, leo hii katika mji wa Daudi, amezaliwa Mwokozi kwa ajili yenu, ndiye Kristo Bwana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na hiki kitakuwa kitambulisho kwenu: mtamkuta mtoto mchanga amevikwa nguo za kitoto, amelazwa horini.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mara kundi kubwa la jeshi la mbinguni likajiunga na huyo malaika, wakamsifu Mungu wakisema: ");
INSERT INTO swh1850_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Utukufu kwa Mungu juu mbinguni, na amani duniani kwa watu aliopendezwa nao!” ");
INSERT INTO swh1850_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Baada ya hao malaika kuondoka na kurudi mbinguni, wachungaji wakaambiana: “Twendeni moja kwa moja mpaka Bethlehemu tukalione tukio hili Bwana alilotujulisha.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Basi, wakaenda mbio, wakamkuta Maria na Yosefu na yule mtoto mchanga amelazwa horini. ");
INSERT INTO swh1850_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hao wachungaji walipomwona mtoto huyo wakawajulisha wote habari waliyokuwa wamesikia juu yake. ");
INSERT INTO swh1850_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wote waliosikia hayo walishangaa juu ya habari walizoambiwa na wachungaji. ");
INSERT INTO swh1850_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Maria aliyaweka na kuyatafakari mambo hayo yote moyoni mwake. ");
INSERT INTO swh1850_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wale wachungaji walirudi makwao huku wakimtukuza na kumsifu Mungu kwa yote waliyokuwa wamesikia na kuona; yote yalikuwa kama walivyokuwa wameambiwa. ");
INSERT INTO swh1850_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Siku nane baadaye, wakati wa kumtahiri mtoto ulipofika, walimpa jina Yesu, jina ambalo alikuwa amepewa na malaika kabla hajachukuliwa mimba. ");
INSERT INTO swh1850_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Siku zilipotimia za Yosefu na Maria kutakaswa kama walivyotakiwa na Sheria ya Mose, wazazi hao walimchukua mtoto, wakaenda naye Yerusalemu ili wamweke mbele ya Bwana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Katika Sheria ya Bwana imeandikwa: “Kila mzaliwa wa kwanza wa kiume atawekwa wakfu kwa Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pia walikwenda ili watoe sadaka: hua wawili au makinda wawili ya njiwa, kama ilivyotakiwa katika Sheria ya Bwana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wakati huo huko Yerusalemu kulikuwa na mtu mmoja, mwema na mcha Mungu, jina lake Simeoni. Yeye alikuwa akitazamia kwa hamu ukombozi wa Israeli. Roho Mtakatifu alikuwa pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roho Mtakatifu alikuwa amemhakikishia kwamba hatakufa kabla ya kumwona Masiha wa Bwana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Basi, akiongozwa na Roho Mtakatifu, Simeoni aliingia Hekaluni; na wazazi wa Yesu walipomleta Hekaluni mtoto wao ili wamfanyie kama ilivyotakiwa na Sheria, ");
INSERT INTO swh1850_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni alimpokea mtoto Yesu mikononi mwake huku akimtukuza Mungu na kusema: ");
INSERT INTO swh1850_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sasa Bwana, umetimiza ahadi yako, waweza kumruhusu mtumishi wako aende kwa amani. ");
INSERT INTO swh1850_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Maana kwa macho yangu nimeuona wokovu utokao kwako, ");
INSERT INTO swh1850_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ambao umeutayarisha mbele ya watu wote: ");
INSERT INTO swh1850_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mwanga utakaowaangazia watu wa mataifa, na utukufu kwa watu wako Israeli.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baba na mama yake Yesu walikuwa wakistaajabia maneno aliyosema Simeoni juu ya mtoto. ");
INSERT INTO swh1850_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeoni akawabariki, akamwambia Maria mama yake, “Mtoto huyu atakuwa sababu ya kupotea na kuokoka kwa watu wengi katika Israeli. Naye atakuwa ishara itakayopingwa na watu; ");
INSERT INTO swh1850_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na hivyo mawazo ya watu wengi yataonekana wazi. Nawe mwenyewe, uchungu ulio kama upanga mkali utauchoma moyo wako.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Palikuwa na nabii mmoja mwanamke, mzee sana, jina lake Ana, binti Fanueli, wa kabila la Asheri. Alikuwa ameishi na mumewe kwa miaka saba tangu alipoolewa. ");
INSERT INTO swh1850_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Halafu alibaki mjane hadi wakati huo akiwa mzee wa miaka themanini na minne. Wakati huo wote alikaa Hekaluni akifunga na kusali usiku na mchana. ");
INSERT INTO swh1850_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saa hiyohiyo alijitokeza mbele, akamshukuru Mungu, na akaeleza habari za huyo mtoto kwa watu wote waliokuwa wanatazamia ukombozi wa Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hao wazazi walipokwisha fanya yote yaliyoamriwa na Sheria ya Bwana, walirudi makwao Nazareti, mkoani Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mtoto akakua, akazidi kupata nguvu, akajaa hekima, na neema ya Mungu ilikuwa pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wazazi wa Yesu walikuwa na desturi ya kwenda Yerusalemu kila mwaka wakati wa sikukuu ya Pasaka. ");
INSERT INTO swh1850_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mtoto alipokuwa na umri wa miaka kumi na miwili, wote walikwenda kwenye sikukuu hiyo kama ilivyokuwa desturi. ");
INSERT INTO swh1850_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baada ya sikukuu, walianza safari ya kurudi makwao, lakini Yesu alibaki Yerusalemu bila wazazi wake kuwa na habari. ");
INSERT INTO swh1850_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Walidhani alikuwa pamoja na kundi la wasafiri, wakaenda mwendo wa kutwa, halafu wakaanza kumtafuta miongoni mwa jamaa na marafiki. ");
INSERT INTO swh1850_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kwa kuwa hawakumwona, walirudi Yerusalemu wakimtafuta. ");
INSERT INTO swh1850_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Siku ya tatu walimkuta Hekaluni kati ya walimu, akiwasikiliza na kuwauliza maswali. ");
INSERT INTO swh1850_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wote waliosikia maneno yake walistaajabia akili yake na majibu yake ya hekima. ");
INSERT INTO swh1850_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wazazi wake walipomwona walishangaa. Maria, mama yake, akamwuliza, “Mwanangu, kwa nini umetutenda hivyo? Baba yako na mimi tumekuwa tukikutafuta kwa huzuni.” ");
INSERT INTO swh1850_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yeye akawajibu, “Kwa nini mlinitafuta? Hamkujua kwamba inanipasa kuwa katika nyumba ya Baba yangu?” ");
INSERT INTO swh1850_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini wazazi wake hawakuelewa maana ya maneno aliyowaambia. ");
INSERT INTO swh1850_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Basi, akarudi pamoja nao hadi Nazareti, akawa anawatii. Mama yake akaweka mambo hayo yote moyoni mwake. ");
INSERT INTO swh1850_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naye Yesu akaendelea kukua katika hekima na kimo; akazidi kupendwa na Mungu na watu. ");
INSERT INTO swh1850_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa kumi na tano wa utawala wa Kaisari Tiberio, Pontio Pilato alikuwa anatawala mkoa wa Yudea. Herode alikuwa mkuu wa mkoa wa Galilaya, na Filipo, ndugu yake, alikuwa mkuu wa mikoa ya Iturea na Trakoniti. Lusania alikuwa mkuu wa mkoa wa Abilene, ");
INSERT INTO swh1850_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa walikuwa makuhani wakuu mjini Yerusalem. Wakati huo ndipo neno la Mungu lilipomjia Yohane, mwana wa Zakariya, kule jangwani. ");
INSERT INTO swh1850_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Basi, Yohane akaenda katika sehemu zote zilizopakana na mto Yordani, akihubiri watu watubu na kubatizwa ili Mungu awaondolee dhambi. ");
INSERT INTO swh1850_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ndivyo ilivyoandikwa katika kitabu cha nabii Isaya: “Sauti ya mtu imesikika jangwani: Mtayarishieni Bwana njia yake; nyosheni mapito yake. ");
INSERT INTO swh1850_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila bonde litafukiwa, kila mlima na kilima vitasawazishwa; palipopindika patanyooshwa, njia mbaya zitatengenezwa. ");
INSERT INTO swh1850_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na, watu wote watauona wokovu utokao kwa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Basi, Yohane akawa anawaambia watu wengi waliofika ili awabatize: “Enyi kizazi cha nyoka! Ni nani aliyewadokezea kwamba mngeweza kuiepuka ghadhabu inayokuja? ");
INSERT INTO swh1850_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Basi, onyesheni kwa matendo kwamba mmetubu. Msianze sasa kusema: Sisi ni watoto wa Abrahamu. Nawaambieni hakika, Mungu anaweza kuyageuza mawe haya yawe watoto wa Abrahamu! ");
INSERT INTO swh1850_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lakini, sasa hivi shoka limewekwa tayari kukata mizizi ya miti. Kila mti usiozaa matunda mazuri utakatwa na kutupwa motoni.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Umati wa watu ukamwuliza, “Tufanye nini basi?” ");
INSERT INTO swh1850_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akawajibu, “Aliye na nguo mbili amgawie yule asiye na nguo; aliye na chakula afanye vivyo hivyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nao watoza ushuru wakaja pia ili wabatizwe, wakamwuliza, “Mwalimu, tufanye nini?” ");
INSERT INTO swh1850_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naye akawaambia, “Msitoze ushuru zaidi ya kima kilichowekwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nao askari wakamwuliza, “Na sisi tufanye nini?” Naye akawajibu, “Msichukue vitu vya mtu yeyote kwa nguvu wala kumshtaki yeyote kwa uongo. Toshekeni na mishahara yenu.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wote walikuwa wanatazamia kitu fulani; basi, wakaanza kujiuliza mioyoni mwao kuhusu Yohane: kuwa labda yeye ndiye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hapo Yohane akawaambia wote, “Mimi ninawabatiza kwa maji, lakini anakuja mwenye uwezo zaidi kuliko mimi ambaye sistahili hata kumfungulia kamba za viatu vyake. Yeye atawabatizeni kwa Roho Mtakatifu na kwa moto. ");
INSERT INTO swh1850_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yeye ni kama mtu anayeshika mikononi mwake chombo cha kupuria nafaka, aipure nafaka yake, akusanye ngano ghalani mwake, na makapi ayachome kwa moto usiozimika.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hivyo, pamoja na mawaidha mengine mengi, Yohane aliwahimiza watu akiwahubiria Habari Njema. ");
INSERT INTO swh1850_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lakini Yohane alimgombeza Herode, mkuu wa mkoa, kwa sababu alikuwa amemchukua Herodia, mke wa ndugu yake, na kumfanya mke wake; na pia kwa ajili ya mabaya yote aliyokuwa amefanya. ");
INSERT INTO swh1850_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kisha Herode akazidisha ubaya wake kwa kumtia Yohane gerezani. ");
INSERT INTO swh1850_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Watu wote walipokuwa wamekwisha batizwa, Yesu naye alibatizwa. Na alipokuwa akisali, mbingu zilifunguka, ");
INSERT INTO swh1850_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Roho Mtakatifu akamshukia akiwa na umbo kama la njiwa. Sauti ikasikika kutoka mbinguni: “Wewe ndiwe Mwanangu mpendwa, nimependezwa nawe.” ");
INSERT INTO swh1850_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu alipoanza kazi yake hadharani, alikuwa na umri upatao miaka thelathini, na watu walidhani yeye ni mwana wa Yosefu, mwana wa Heli. ");
INSERT INTO swh1850_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli alikuwa mwana wa Mathati, mwana wa Lawi, mwana wa Melki, mwana wa Yanai, mwana wa Yosefu, ");
INSERT INTO swh1850_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwana wa Matathia, mwana wa Amosi, mwana wa Nahumu, mwana wa Hesli, mwana wa Nagai, ");
INSERT INTO swh1850_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Maathi, mwana wa Matathia, mwana wa Shemeni, mwana wa Yoseki, mwana wa Yuda, ");
INSERT INTO swh1850_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwana wa Yohanani, mwana wa Resa, mwana wa Zerubabeli, mwana wa Shealtieli, mwana wa Neri, ");
INSERT INTO swh1850_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Melki, mwana wa Adi, mwana wa Kosamu, mwana wa Elmadamu, mwana wa Eri, ");
INSERT INTO swh1850_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana wa Yoshua, mwana wa Eliezeri, mwana wa Yorimu, mwana wa Mathati, mwana wa Lawi, ");
INSERT INTO swh1850_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana wa Simeoni, mwana wa Yuda, mwana wa Yosefu, mwana wa Yonamu, mwana wa Eliakimu, ");
INSERT INTO swh1850_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana wa Melea, mwana wa Mena, mwana wa Matatha, mwana wa Nathani, mwana wa Daudi, ");
INSERT INTO swh1850_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana wa Yese, mwana wa Obedi, mwana wa Boazi, mwana wa Salmoni, mwana wa Nashoni, ");
INSERT INTO swh1850_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana wa Aminadabu, mwana wa Admini, mwana wa Arni, mwana wa Hesroni, mwana wa Feresi, mwana wa Yuda, ");
INSERT INTO swh1850_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana wa Yakobo, mwana wa Isaka, mwana wa Abrahamu, mwana wa Tera, mwana wa Nahori, ");
INSERT INTO swh1850_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana wa Serugi, mwana wa Reu, mwana wa Pelegi, mwana wa Eberi, mwana wa Sala, ");
INSERT INTO swh1850_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana wa Kainani, mwana wa Arfaksadi, mwana wa Shemu, mwana wa Noa, mwana wa Lameki, ");
INSERT INTO swh1850_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana wa Mathusala, mwana wa Henoki, mwana wa Yaredi, mwana wa Mahalaleli, mwana wa Kenani, ");
INSERT INTO swh1850_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Enosi, mwana wa Sethi, mwana wa Adamu, aliyekuwa wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu alitoka katika mto Yordani akiwa amejaa Roho Mtakatifu, akaongozwa na Roho mpaka jangwani. ");
INSERT INTO swh1850_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Huko alijaribiwa na Ibilisi kwa muda wa siku arubaini. Wakati huo wote hakula chochote, na baada ya siku hizo akasikia njaa. ");
INSERT INTO swh1850_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ndipo Ibilisi akamwambia, “Kama wewe ni Mwana wa Mungu, amuru jiwe hili liwe mkate.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu akamjibu, “Imeandikwa: Mtu haishi kwa mkate tu.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kisha Ibilisi akamchukua hadi mahali pa juu, akamwonyesha kwa mara moja falme zote za ulimwengu. Huyo Shetani akamwambia, ");
INSERT INTO swh1850_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Nitakupa uwezo juu ya falme zote hizi na fahari zake, kwa maana nimepewa hivi vyote; nikitaka kumpa mtu ninaweza. ");
INSERT INTO swh1850_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hivi vyote vitakuwa mali yako wewe, kama ukiniabudu.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu akamjibu, “Imeandikwa: Utamwabudu Bwana Mungu wako, na utamtumikia yeye peke yake.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibilisi akamchukua mpaka Yerusalemu, kwenye mnara wa Hekalu, akamwambia, “Kama wewe ni Mwana wa Mungu, ");
INSERT INTO swh1850_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwa maana imeandikwa: Atawaamuru malaika wake wakulinde, ");
INSERT INTO swh1850_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na tena, Watakuchukua mikononi mwao usije ukajikwaa mguu wako kwenye jiwe.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lakini Yesu akamjibu, “Imeandikwa: Usimjaribu Bwana Mungu wako.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibilisi alipokwishamjaribu kwa kila njia, akamwacha kwa muda. ");
INSERT INTO swh1850_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu alirudi Galilaya akiwa amejaa nguvu za Roho Mtakatifu, na habari zake zikaenea katika sehemu zote za jirani. ");
INSERT INTO swh1850_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naye akawa anawafundisha watu katika masunagogi yao, akasifiwa na wote. ");
INSERT INTO swh1850_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Basi, Yesu alikwenda Nazareti, mahali alipolelewa, na siku ya Sabato, aliingia katika sunagogi, kama ilivyokuwa desturi yake. Akasimama ili asome Maandiko Matakatifu kwa sauti. ");
INSERT INTO swh1850_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akapokea kitabu cha nabii Isaya, akakifungua na akakuta mahali palipoandikwa: ");
INSERT INTO swh1850_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Roho wa Bwana yu juu yangu, kwani amenipaka mafuta niwahubirie maskini Habari Njema. Amenituma niwatangazie mateka watapata uhuru, vipofu watapata kuona tena; amenituma niwakomboe wanaoonewa, ");
INSERT INTO swh1850_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kutangaza mwaka wa neema ya Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Baada ya kusoma, akafunga kile kitabu, akampa mtumishi, kisha akaketi; watu wote wakamkodolea macho. ");
INSERT INTO swh1850_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naye akaanza kuwaambia, “Andiko hili mlilosikia likisomwa, limetimia leo.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wote wakavutiwa sana naye, wakastaajabia maneno mazuri aliyosema. Wakanena, “Je, huyu si mwana wa Yosefu?” ");
INSERT INTO swh1850_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naye akawaambia, “Bila shaka mtaniambia msemo huu: Mganga jiponye mwenyewe, na pia mtasema: Yote tuliyosikia umeyafanya kule Kafarnaumu, yafanye hapa pia katika kijiji chako.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akaendelea kusema, “Hakika nawaambieni, nabii hatambuliwi katika kijiji chake. ");
INSERT INTO swh1850_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lakini, sikilizeni! Kweli kulikuwa na wajane wengi katika nchi ya Israeli nyakati za Eliya. Wakati huo mvua iliacha kunyesha kwa muda wa miaka mitatu na nusu; kukawa na njaa kubwa katika nchi yote. ");
INSERT INTO swh1850_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata hivyo, Eliya hakutumwa kwa mjane yeyote ila kwa mwanamke mjane wa Sarepta, Sidoni. ");
INSERT INTO swh1850_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tena, katika nchi ya Israeli nyakati za Elisha kulikuwa na wenye ukoma wengi. Hata hivyo, hakuna yeyote aliyetakaswa ila tu Naamani, mwenyeji wa Siria.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wote waliokuwa katika lile sunagogi waliposikia hayo walikasirika sana. ");
INSERT INTO swh1850_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wakasimama, wakamtoa nje ya mji wao uliokuwa umejengwa juu ya kilima, wakampeleka mpaka kwenye ukingo wa kilima hicho ili wamtupe chini. ");
INSERT INTO swh1850_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini Yesu akapita katikati yao, akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kisha Yesu akashuka mpaka Kafarnaumu katika mkoa wa Galilaya, akawa anawafundisha watu siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wakastaajabia uwezo aliokuwa nao katika kufundisha. ");
INSERT INTO swh1850_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na katika lile sunagogi kulikuwa na mtu aliyekuwa amepagawa na roho ya pepo mchafu; akapiga ukelele wa kuziba masikio: ");
INSERT INTO swh1850_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“We! Yesu wa Nazareti! Kwa nini unatuingilia? Je, umekuja kutuangamiza? Ninakufahamu wewe ni nani. Wewe ni mjumbe Mtakatifu wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Lakini Yesu akamkemea huyo pepo akisema: “Nyamaza! Mtoke mtu huyu!” Basi, huyo pepo baada ya kumwangusha yule mtu chini, akamtoka bila kumdhuru hata kidogo. ");
INSERT INTO swh1850_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Watu wote wakashangaa, wakawa wanaambiana, “Hili ni jambo la ajabu, maana kwa uwezo na nguvu anawaamuru pepo wachafu watoke, nao wanatoka!” ");
INSERT INTO swh1850_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Habari zake zikaenea mahali pote katika mkoa ule. ");
INSERT INTO swh1850_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu alitoka katika lile sunagogi, akaenda nyumbani kwa Simoni. Mama mmoja, mkwewe Simoni, alikuwa na homa kali; wakamwomba amponye. ");
INSERT INTO swh1850_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu akaenda akasimama karibu naye, akaikemea ile homa, nayo ikamwacha. Mara yule mama akainuka, akawatumikia. ");
INSERT INTO swh1850_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jua lilipokuwa linatua, wote waliokuwa na wagonjwa wao mbalimbali waliwaleta kwake; naye akaweka mikono yake juu ya kila mmoja wao, akawaponya wote. ");
INSERT INTO swh1850_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pepo waliwatoka watu wengi, wakapiga kelele wakisema: “Wewe u Mwana wa Mungu!” Lakini Yesu akawakemea, wala hakuwaruhusu kusema, maana walimfahamu kwamba yeye ndiye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kesho yake asubuhi Yesu aliondoka akaenda mahali pa faragha. Watu wakawa wanamtafuta, na walipofika mahali alipokuwa, wakajaribu kumzuia ili asiondoke kwao. ");
INSERT INTO swh1850_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini yeye akawaambia, “Ninapaswa kuhubiri Habari Njema za Ufalme wa Mungu katika miji mingine pia, maana nilitumwa kwa ajili hiyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Akawa anahubiri katika masunagogi ya Yudea. ");
INSERT INTO swh1850_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Siku moja Yesu alikuwa amesimama kando ya ziwa Genesareti, na watu wengi walikuwa wamemzunguka wakisongana wanalisikiliza neno la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akaona mashua mbili ukingoni mwa ziwa; wavuvi wenyewe walikuwa wametoka, wanaosha nyavu zao. ");
INSERT INTO swh1850_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Baada ya Yesu kuingia katika mashua moja, iliyokuwa ya Simoni, alimtaka Simoni aisogeze majini, mbali kidogo na ukingo wa ziwa. Akaketi, akafundisha umati wa watu akiwa ndani ya mashua. ");
INSERT INTO swh1850_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Alipomaliza kufundisha, akamwambia Simoni, “Peleka mashua mpaka kilindini, mkatupe nyavu zenu mpate kuvua samaki.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akamjibu, “Bwana, tumejitahidi kuvua samaki usiku kucha bila kupata kitu, lakini kwa kuwa umesema, nitatupa nyavu.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baada ya kufanya hivyo, wakavua samaki wengi, hata nyavu zao zikaanza kukatika. ");
INSERT INTO swh1850_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wakawaita wenzao waliokuwa katika mashua nyingine waje kuwasaidia. Wakaja, wakazijaza mashua zote mbili samaki, hata karibu zingezama. ");
INSERT INTO swh1850_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petro alipoona hayo, akapiga magoti mbele ya Yesu akisema, “Ondoka mbele yangu, ee Bwana, kwa kuwa mimi ni mwenye dhambi!” ");
INSERT INTO swh1850_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni pamoja na wenzake wote walishangaa kwa kupata samaki wengi vile. ");
INSERT INTO swh1850_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hali kadhalika Yakobo na Yohane, wana wa Zebedayo, waliokuwa wavuvi wenzake Simoni. Yesu akamwambia Simoni, “Usiogope; tangu sasa utakuwa ukivua watu.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Basi, baada ya kuzileta zile mashua ukingoni mwa ziwa, wakaacha yote, wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ikawa, Yesu alipokuwa katika mmojawapo wa miji ya huko, mtu mmoja mwenye ukoma mwili mzima akamwona. Basi, mtu huyo akaanguka kifudifudi akamwomba Yesu: “Mheshimiwa, ukitaka, waweza kunitakasa.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu akaunyosha mkono wake, akamgusa na kusema, “Nataka, takasika!” Mara ule ukoma ukamwacha. ");
INSERT INTO swh1850_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu akamwamuru: “Usimwambie mtu yeyote; bali nenda ukajionyeshe kwa kuhani, ukatoe sadaka kwa ajili ya kutakasika kwako kama inavyotakiwa na Sheria ya Mose, iwe uthibitisho kwao kwamba umepona.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini habari za Yesu zilizidi kuenea kila mahali. Watu makundi mengi wakakusanyika ili kumsikiliza na kuponywa magonjwa yao. ");
INSERT INTO swh1850_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini yeye alikwenda zake mahali pasipo na watu, akawa anasali huko. ");
INSERT INTO swh1850_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Siku moja Yesu alikuwa akifundisha. Mafarisayo na walimu wa Sheria kutoka katika kila kijiji cha Galilaya, Yudea na Yerusalemu, walikuwa wameketi hapo. Nguvu ya Bwana ilikuwa pamoja naye kwa ajili ya kuponyea wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mara watu wakaja wamemchukua mtu mmoja aliyepooza maungo, amelala kitandani; wakajaribu kumwingiza ndani wamweke mbele ya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lakini kwa sababu ya wingi wa watu, hawakuweza kuingia ndani. Basi, wakapanda juu ya dari, wakaondoa vigae, wakamshusha huyo aliyepooza pamoja na kitanda chake, wakamweka mbele ya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu alipoona jinsi walivyokuwa na imani kubwa, akamwambia huyo mtu, “Rafiki, umesamehewa dhambi zako.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Walimu wa Sheria na Mafarisayo wakaanza kujiuliza: “Nani huyu anayemkufuru Mungu kwa maneno yake? Hakuna mtu awezaye kusamehe dhambi ila Mungu peke yake!” ");
INSERT INTO swh1850_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu alitambua mawazo yao, akawauliza, “Mnawaza nini mioyoni mwenu? ");
INSERT INTO swh1850_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni lipi lililo rahisi zaidi: kusema, Umesamehewa dhambi, au kusema, Simama utembee? ");
INSERT INTO swh1850_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Basi, nataka mjue kwamba Mwana wa Mtu anao uwezo wa kusamehe dhambi duniani.” Hapo akamwambia huyo mtu aliyepooza, “Simama, chukua kitanda chako uende zako nyumbani.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mara, huyo mtu aliyepooza akasimama mbele yao wote, akachukua kitanda chake akaenda zake nyumbani huku akimtukuza Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wote wakashangaa na kushikwa na hofu; wakamtukuza Mungu wakisema: “Tumeona maajabu leo.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baada ya hayo, Yesu akatoka nje, akamwona mtoza ushuru mmoja aitwaye Lawi, ameketi ofisini. Yesu akamwambia, “Nifuate!” ");
INSERT INTO swh1850_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi akaacha yote, akamfuata. ");
INSERT INTO swh1850_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kisha Lawi akamwandalia Yesu karamu kubwa nyumbani mwake; na kundi kubwa la watoza ushuru na watu wengine walikuwa wameketi pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafarisayo na walimu wa Sheria wakawanung'unikia wafuasi wake wakisema: “Mbona mnakula na kunywa pamoja na watoza ushuru na wenye dhambi?” ");
INSERT INTO swh1850_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akawajibu, “Wenye afya hawahitaji daktari, lakini wanaomhitaji ni wale walio wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sikuja kuwaita watu wema, bali wenye dhambi, ili wapate kutubu.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Watu wengine wakamwambia Yesu, “Wafuasi wa Yohane mbatizaji hufunga mara nyingi na kusali; hata wafuasi wa Mafarisayo hufanya vivyo hivyo. Lakini wafuasi wako hula na kunywa.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akawajibu, “Je, mnaweza kuwataka wale walioalikwa arusini wafunge hali bwana arusi yuko pamoja nao? ");
INSERT INTO swh1850_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini wakati utafika ambapo bwana arusi ataondolewa kati yao, na wakati huo ndipo watakapofunga.” ");
INSERT INTO swh1850_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu akawaambia mfano huu: “Hakuna mtu akataye kiraka cha nguo mpya na kukitia katika vazi kuukuu; kama akifanya hivyo, atakuwa amelikata hilo vazi jipya, na hicho kiraka hakitachukuana na hilo vazi kuukuu. ");
INSERT INTO swh1850_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wala hakuna mtu atiaye divai mpya katika viriba vikuukuu; kwani hiyo divai mpya itavipasua hivyo viriba, divai itamwagika, na viriba vitaharibika. ");
INSERT INTO swh1850_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Divai mpya hutiwa katika viriba vipya! ");
INSERT INTO swh1850_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wala hakuna mtu ambaye hutamani kunywa divai mpya baada ya kunywa ya zamani, kwani husema: Ile ya zamani ni nzuri zaidi.” ");
INSERT INTO swh1850_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Siku moja ya Sabato, Yesu alikuwa anapita katika mashamba ya ngano, na wanafunzi wake wakaanza kukwanyua masuke ya ngano, wakaondoa punje zake kwa mikono, wakala. ");
INSERT INTO swh1850_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Baadhi ya Mafarisayo wakawauliza, “Mbona mnafanya jambo ambalo si halali siku ya Sabato?” ");
INSERT INTO swh1850_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu akawajibu, “Je, hamjasoma jinsi alivyofanya Daudi pamoja na wenzake wakati walipokuwa na njaa? ");
INSERT INTO swh1850_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yeye aliingia ndani ya nyumba ya Mungu, akachukua ile mikate iliyowekwa mbele ya Mungu, akala na kuwapa wenzake. Kisheria, ni makuhani tu peke yao ndio walioruhusiwa kula mikate hiyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hivyo akawaambia, “Mwana wa Mtu ni Bwana wa Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Siku nyingine ya Sabato, Yesu aliingia katika sunagogi, akafundisha. Mle ndani mlikuwa na mtu ambaye mkono wake wa kuume ulikuwa umepooza. ");
INSERT INTO swh1850_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Walimu wa Sheria na Mafarisayo walitaka kupata kisingizio cha kumshtaki Yesu na hivyo wakawa wanangojea waone kama angemponya mtu siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini Yesu alijua mawazo yao, akamwambia yule mwenye mkono uliopooza, “Inuka, simama katikati.” Yule mtu akaenda akasimama katikati. ");
INSERT INTO swh1850_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kisha Yesu akawaambia, “Nawaulizeni, je, ni halali siku ya Sabato kutenda jambo jema au kutenda jambo baya; kuokoa maisha au kuyaangamiza?” ");
INSERT INTO swh1850_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Baada ya kuwatazama wote waliokuwa pale, akamwambia yule mtu, “Nyosha mkono wako.” Naye akafanya hivyo, na mkono wake ukawa mzima tena. ");
INSERT INTO swh1850_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini wao wakakasirika sana, wakajadiliana jinsi ya kumtendea Yesu maovu. ");
INSERT INTO swh1850_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Siku moja Yesu alikwenda mlimani kusali, akakesha huko usiku kucha akimwomba Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kesho yake aliwaita wanafunzi wake, na miongoni mwao akachagua kumi na wawili ambao aliwaita mitume: ");
INSERT INTO swh1850_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni (ambaye Yesu alimpa jina Petro) na Andrea ndugu yake, Yakobo na Yohane, Filipo na Bartholomayo, ");
INSERT INTO swh1850_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayo na Thoma, Yakobo wa Alfayo na Simoni (aliyeitwa Zelote), ");
INSERT INTO swh1850_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda wa Yakobo na Yuda Iskarioti ambaye baadaye alikuwa msaliti. ");
INSERT INTO swh1850_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Baada ya kushuka mlimani pamoja na mitume, Yesu alisimama mahali palipokuwa tambarare. Hapo palikuwa na kundi kubwa la wanafunzi wake na umati wa watu waliotoka pande zote za Yudea na Yerusalemu na pwani ya Tiro na Sidoni. Wote walifika kumsikiliza Yesu na kuponywa magonjwa yao. ");
INSERT INTO swh1850_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aliwaponya pia wote waliokuwa wanasumbuliwa na pepo wachafu. ");
INSERT INTO swh1850_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Watu wote walitaka kumgusa, kwa maana nguvu ilikuwa inatoka ndani yake na kuwaponya wote. ");
INSERT INTO swh1850_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu akawageukia wanafunzi wake, akasema: “Heri ninyi mlio maskini, maana Ufalme wa Mungu ni wenu. ");
INSERT INTO swh1850_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Heri ninyi mnaosikia njaa sasa, maana baadaye mtashiba. Heri ninyi mnaolia sasa, maana baadaye mtacheka kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Heri yenu ninyi iwapo watu watawachukia, watawatenga, watawatukana na kuwaharibieni jina kwa ajili ya Mwana wa Mtu! ");
INSERT INTO swh1850_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wakati hayo yatakapotokea, furahini na kucheza, maana hakika tuzo lenu ni kubwa mbinguni. Kwa maana wazee wao waliwatendea manabii vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini ole wenu ninyi mlio matajiri, maana mmekwisha pata faraja yenu. ");
INSERT INTO swh1850_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ole wenu ninyi mnaoshiba sasa, maana baadaye mtasikia njaa. Ole wenu ninyi mnaocheka kwa furaha sasa, maana baadaye mtaomboleza na kulia. ");
INSERT INTO swh1850_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ole wenu ninyi iwapo watu wote wanawasifu, maana wazee wao waliwafanyia manabii wa uongo vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lakini nawaambieni ninyi mnaonisikiliza: wapendeni adui zenu, watendeeni mema wale wanaowachukieni. ");
INSERT INTO swh1850_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Watakieni baraka wale wanaowalaani, na waombeeni wale wanaowatendea vibaya. ");
INSERT INTO swh1850_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mtu akikupiga shavu moja mgeuzie na la pili. Mtu akikunyang'anya koti lako mwachie pia shati lako. ");
INSERT INTO swh1850_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yeyote anayekuomba mpe, na mtu akikunyang'anya mali yako usimtake akurudishie. ");
INSERT INTO swh1850_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Watendeeni wengine kama mnavyotaka wawatendee ninyi. ");
INSERT INTO swh1850_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na ikiwa mnawapenda tu wale wanaowapenda ninyi, je, mtapata tuzo gani? Hakuna! Kwa maana hata wenye dhambi huwapenda wale wanaowapenda wao. ");
INSERT INTO swh1850_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tena, kama mkiwatendea mema wale tu wanaowatendeeni mema, mtapata tuzo gani? Hata wenye dhambi hufanya vivyo hivyo! ");
INSERT INTO swh1850_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na kama mnawakopesha wale tu mnaotumaini watawalipeni, je, mtapata tuzo gani? Hata wenye dhambi huwakopesha wenye dhambi wenzao ili warudishiwe kima kilekile! ");
INSERT INTO swh1850_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ila nyinyi wapendeni adui zenu, na kuwatendea mema; kopesheni bila kutazamia malipo, na tuzo lenu litakuwa kubwa, nanyi mtakuwa watoto wa Mungu aliye juu. Kwa maana yeye ni mwema kwa wale wasio na shukrani na walio wabaya. ");
INSERT INTO swh1850_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na huruma kama Baba yenu alivyo na huruma. ");
INSERT INTO swh1850_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Msiwahukumu wengine, nanyi hamtahukumiwa; msiwalaumu wengine, nanyi hamtalaumiwa; wasameheni wengine, nanyi mtasamehewa. ");
INSERT INTO swh1850_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wapeni wengine wanavyohitaji, nanyi mtapewa. Naam, mtapokea mikononi mwenu kipimo kilichojaa, kikashindiliwa na kusukwasukwa hata kumwagika. Kwa maana kipimo kilekile mnachotumia kwa wengine ndicho ambacho Mungu atatumia kwenu.” ");
INSERT INTO swh1850_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Akawaambia mfano huu: “Je, kipofu anaweza kumwongoza kipofu mwenzake? La! Wote wataanguka shimoni. ");
INSERT INTO swh1850_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanafunzi hamshindi mwalimu wake, lakini kila mwanafunzi akisha hitimu huwa kama mwalimu wake. ");
INSERT INTO swh1850_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Unawezaje kukiona kibanzi kilicho katika jicho la mwenzio, usione boriti iliyo katika jicho lako mwenyewe? ");
INSERT INTO swh1850_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Au, unawezaje kumwambia mwenzako, Ndugu, ngoja nikuondoe kibanzi katika jicho lako, na huku huioni boriti iliyoko katika jicho lako mwenyewe? Mnafiki wewe! Toa kwanza boriti iliyoko jichoni mwako, na hivyo utaona sawasawa kiasi cha kuweza kuondoa kibanzi kilicho katika jicho la ndugu yako. ");
INSERT INTO swh1850_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mti mwema hauzai matunda mabaya, wala mti mbaya hauzai matunda mazuri. ");
INSERT INTO swh1850_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Watu huutambua mti kutokana na matunda yake. Ni wazi kwamba watu hawachumi tini katika michongoma, wala hawachumi zabibu katika mbigili. ");
INSERT INTO swh1850_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mtu mwema hutoa yaliyo mema kutoka katika hazina bora iliyo moyoni mwake; na mtu mbaya hutoa yaliyo mabaya katika hazina mbaya iliyo moyoni mwake, kwa maana mtu huongea kutokana na yale yaliyojaa moyoni mwake. ");
INSERT INTO swh1850_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mbona mwaniita Bwana, Bwana, na huku hamtimizi yale ninayosema? ");
INSERT INTO swh1850_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nitawapeni mfano unaofaa kuonyesha alivyo yeyote yule anayekuja kwangu, akasikia maneno yangu na kuyatimiza: ");
INSERT INTO swh1850_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Huyo anafanana na mtu ajengaye nyumba, ambaye amechimba chini na kuweka msingi wake juu ya mwamba; kukatokea mafuriko ya mto, mkondo wa maji ukaipiga nyumba ile, lakini haukuweza kuitikisa, kwa sababu ilikuwa imejengwa imara. ");
INSERT INTO swh1850_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini yeyote anayesikia maneno yangu lakini asifanye chochote, huyo anafanana na mtu aliyejenga nyumba juu ya udongo, bila msingi. Mafuriko ya mto yakatokea, mkondo wa maji ukaipiga nyumba ile, ikaanguka na kuharibika kabisa!” ");
INSERT INTO swh1850_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baada ya kusema yale aliyotaka watu wasikie, Yesu alikwenda Kafarnaumu. ");
INSERT INTO swh1850_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Huko kulikuwa na jemadari mmoja Mroma ambaye alikuwa na mtumishi wake aliyempenda sana. Huyu mtumishi alikuwa mgonjwa karibu kufa. ");
INSERT INTO swh1850_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yule jemadari aliposikia habari za Yesu, aliwatuma wazee fulani Wayahudi waende kumwomba aje amponye mtumishi wake. ");
INSERT INTO swh1850_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Walipofika kwa Yesu, walimsihi sana, wakasema: “Huyu anastahili afanyiwe jambo hilo, ");
INSERT INTO swh1850_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","maana analipenda taifa letu, na ndiye aliyetujengea lile sunagogi.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Basi, Yesu akaenda pamoja nao. Alipokuwa karibu kufika nyumbani kwa yule jemadari Mroma, yule jemadari aliwatuma marafiki zake wamwambie Yesu: “Bwana, usijisumbue zaidi, maana mimi sistahili uingie nyumbani mwangu. ");
INSERT INTO swh1850_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndio maana sikujiona nastahili hata kuja kwako; amuru tu, na mtumishi wangu atapona. ");
INSERT INTO swh1850_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mimi pia ni mtu niliye chini ya mamlaka, na ninao askari chini yangu. Namwambia mmoja, Nenda!, naye huenda; namwambia mwingine, Njoo! naye huja; na nikimwambia mtumishi wangu, Fanya hiki!, hufanya.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu aliposikia hayo, alishangaa; halafu akauelekea ule umati wa watu uliokuwa unamfuata, akasema, “Sijaona imani kubwa namna hii hata katika Israeli.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wale watu walipowasili nyumbani walimkuta yule mtumishi hajambo kabisa. ");
INSERT INTO swh1850_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Baadaye kidogo Yesu alikwenda katika mji mmoja uitwao Naini, na wafuasi wake pamoja na kundi kubwa la watu waliandamana naye. ");
INSERT INTO swh1850_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Basi, alipokuwa anakaribia lango la mji, walitokea watu wamebeba maiti ya kijana mmoja, mtoto wa pekee wa mama mjane. Watu wengi wa mji ule walikuwa pamoja na huyo mama. ");
INSERT INTO swh1850_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bwana alipomwona mama huyo, alimwonea huruma, akamwambia, “Usilie.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kisha akaenda, akaligusa lile jeneza, na wale waliokuwa wanalichukua wakasimama. Halafu akasema, “Kijana! Nakuamuru, amka!” ");
INSERT INTO swh1850_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yule aliyekufa akaketi, akaanza kuongea. Na Yesu akamkabidhi kwa mama yake. ");
INSERT INTO swh1850_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Watu wote walishikwa na hofu, wakawa wanamtukuza Mungu wakisema: “Nabii mkuu ametokea kati yetu. Mungu amekuja kuwakomboa watu wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Habari hizo zikaenea kote katika Uyahudi na katika nchi za jirani. ");
INSERT INTO swh1850_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanafunzi wa Yohane walimpa habari Yohane juu ya mambo hayo yote. Naye Yohane, baada ya kuwaita wawili kati ya wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aliwatuma kwa Bwana wamwulize: “Wewe ndiye yule ajaye, au tumtazamie mwingine?” ");
INSERT INTO swh1850_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wale wanafunzi walipomfikia Yesu wakamwambia, “Yohane Mbatizaji ametutuma kwako tukuulize: Wewe ndiye yule ajaye, au tumtazamie mwingine?” ");
INSERT INTO swh1850_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wakati huohuo, Yesu alikuwa anawaponya watu wengi waliokuwa wanateseka kwa magonjwa na waliopagawa na pepo wabaya, akawawezesha vipofu wengi kuona tena. ");
INSERT INTO swh1850_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Basi, Yesu akawajibu, “Nendeni mkamwambie Yohane yale mliyojionea na kuyasikia: vipofu wanaona, viwete wanatembea, wenye ukoma wanatakaswa, viziwi wanasikia, wafu wanafufuliwa, na maskini wanahubiriwa Habari njema. ");
INSERT INTO swh1850_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Heri mtu yule ambaye hana mashaka nami!” ");
INSERT INTO swh1850_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hapo wajumbe wa Yohane walipokwisha kwenda zao, Yesu alianza kuyaambia makundi ya watu juu ya Yohane: “Mlikwenda kule jangwani, hivi mlitaka kuona kitu gani? Mlitaka kuona unyasi unaotikiswa na upepo? ");
INSERT INTO swh1850_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Basi, mlikwenda kuona nini? Mlikwenda kumwona mtu aliyevalia mavazi maridadi? La hasha! Wanaovaa mavazi maridadi na kuishi maisha ya anasa, hukaa katika majumba ya wafalme! ");
INSERT INTO swh1850_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Basi, niambieni, mlikwenda kuona nini? Mlikwenda kumwona nabii? Naam, hakika ni zaidi ya nabii. ");
INSERT INTO swh1850_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Huyu Yohane ndiye anayesemwa katika Maandiko Matakatifu: Hapa ni mtumishi wangu, asema Bwana; ninamtuma akutangulie, akutayarishie njia.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu akamalizia kwa kusema, “Nawaambieni, kati ya binadamu wote hakuna aliye mkubwa zaidi kuliko Yohane Mbatizaji. Hata hivyo, yule aliye mdogo kabisa katika ufalme wa Mungu ni mkubwa zaidi kuliko yeye.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Waliposikia hayo watu wote na watoza ushuru waliusifu wema wa Mungu; hao ndio wale waliokuwa wameupokea ubatizo wa Yohane. ");
INSERT INTO swh1850_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Mafarisayo na walimu wa Sheria walikataa mpango wa Mungu uliowahusu wakakataa kubatizwa na Yohane. ");
INSERT INTO swh1850_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu akaendelea kusema, “Basi, nitawafananisha watu wa kizazi hiki na kitu gani? Ni watu wa namna gani? ");
INSERT INTO swh1850_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ni kama vijana waliokuwa wamekaa sokoni na kuambiana, kikundi kimoja na kingine: Tumewapigieni ngoma, lakini hamkucheza! Tumeomboleza, lakini hamkulia! ");
INSERT INTO swh1850_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwa maana Yohane alikuja, yeye alifunga na hakunywa divai, nanyi mkasema: Amepagawa na pepo! ");
INSERT INTO swh1850_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Akaja Mwana wa Mtu; anakula na kunywa, mkasema: Mwangalieni mlafi huyu na mlevi; rafiki ya watoza ushuru na wenye dhambi! ");
INSERT INTO swh1850_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hata hivyo, hekima ya Mungu imethibitishwa kuwa njema na wote wale wanaoikubali.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfarisayo mmoja alimwalika Yesu kula chakula nyumbani kwake. Akaingia nyumbani mwa huyo Mfarisayo, akakaa kula chakula. ");
INSERT INTO swh1850_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Basi, katika mji ule kulikuwa na mama mmoja aliyekuwa anaishi maisha mabaya. Alipopata habari kwamba Yesu yuko nyumbani kwa huyo Mfarisayo, alichukua chupa ya alabasta yenye marashi. ");
INSERT INTO swh1850_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akaja, akasimama karibu na miguu yake Yesu, akilia, na machozi yake yakamdondokea Yesu miguuni. Huyo mwanamke akaipangusa miguu ya Yesu kwa nywele zake. Kisha akaibusu na kuipaka yale marashi. ");
INSERT INTO swh1850_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yule Mfarisayo aliyemwalika Yesu alipoona hayo, akawaza moyoni mwake, “Kama mtu huyu angekuwa kweli nabii angejua huyu mwanamke ni wa namna gani, ya kwamba ni mwenye dhambi.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu akamwambia huyo Mfarisayo, “Simoni, ninacho kitu cha kukwambia.” Naye Simoni akamwambia, “Ndio Mwalimu, sema.” Yesu akasema, ");
INSERT INTO swh1850_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Watu wawili walikuwa wamemkopa mtu fedha: mmoja alikuwa amekopa dinari mia tano, na mwingine hamsini. ");
INSERT INTO swh1850_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Waliposhindwa kulipa madeni yao, huyo mtu aliwasamehe wote wawili. Sasa ni yupi kati ya hao wawili atampenda zaidi huyo bwana?” ");
INSERT INTO swh1850_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni akamjibu, “Ni dhahiri kwamba yule aliyesamehewa deni kubwa zaidi atampenda zaidi yule bwana.” Yesu akamwambia, “Sawa.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Halafu akamgeukia yule mwanamke na kumwambia Simoni, “Unamwona huyu mwanamke, sivyo? Basi, mimi nilipoingia hapa nyumbani kwako hukunipa maji ya kunawa miguu yangu; lakini mwanamke huyu ameniosha miguu yangu kwa machozi yake na kunipangusa kwa nywele zake. ");
INSERT INTO swh1850_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wewe hukunisalimu kwa kunibusu, lakini huyu mwanamke tangu nilipoingia hapa amekuwa akiibusu miguu yangu. ");
INSERT INTO swh1850_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wewe hukunionyesha ukarimu wako kwa kunipaka mafuta kichwani, lakini huyu mwanamke amefanya hivyo kwa kunipaka mafuta miguu yangu. ");
INSERT INTO swh1850_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa hiyo nakwambia amesamehewa dhambi zake nyingi kwa kuwa ameonyesha upendo mkubwa. Mwenye kusamehe kidogo, hupenda kidogo.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Basi, Yesu akamwambia yule mwanamke, “Umesamehewa dhambi zako.” ");
INSERT INTO swh1850_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na hapo wale waliokuwa pamoja naye mezani wakaulizana, “Ni mtu wa namna gani huyu awezaye kusamehe dhambi?” ");
INSERT INTO swh1850_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naye Yesu akamwambia yule mwanamke, “Imani yako imekuokoa; nenda kwa amani.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Baada ya hayo, Yesu alipitia katika miji na vijiji akitangaza Habari Njema za Ufalme wa Mungu. Wale kumi na wawili waliandamana naye. ");
INSERT INTO swh1850_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pia wanawake kadhaa ambao Yesu alikuwa amewatoa pepo wabaya na kuwaponya magonjwa, waliandamana naye. Hao ndio akina Maria (aitwaye Magdalene), ambaye alitolewa pepo wabaya saba; ");
INSERT INTO swh1850_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana, mke wa Kuza, mfanyakazi mkuu wa Herode; Susana na wengine kadhaa. Hao wanawake walikuwa wakiwatumikia kwa mali yao wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kundi kubwa la watu lilikuwa linakusanyika, na watu walikuwa wanamjia Yesu kutoka kila mji. Naye akawaambia mfano huu: ");
INSERT INTO swh1850_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mpanzi alikwenda kupanda mbegu zake. Alipokuwa akipanda zile mbegu, nyingine zilianguka njiani, na wapita njia wakazikanyaga, na ndege wakazila. ");
INSERT INTO swh1850_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nyingine zilianguka penye mawe, na baada ya kuota zikanyauka kwa kukosa maji. ");
INSERT INTO swh1850_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nyingine zilianguka kati ya miti ya miiba. Ile miti ya miiba ilipoota ikazisonga. ");
INSERT INTO swh1850_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nyingine zilianguka katika udongo mzuri, zikaota na kuzaa asilimia mia.” Baada ya kusema hayo, akapaaza sauti, akasema, “Mwenye masikio na asikie!” ");
INSERT INTO swh1850_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanafunzi wake wakamwuliza Yesu maana ya mfano huo. ");
INSERT INTO swh1850_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naye akajibu, “Ninyi mmejaliwa kujua siri za Ufalme wa Mungu, lakini hao wengine sivyo; ila hao huambiwa kwa mifano, ili wakitazama wasiweze kuona, na wakisikia wasifahamu. ");
INSERT INTO swh1850_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Basi, maana ya mfano huu ni hii: mbegu ni neno la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Zile zilizoanguka njiani zinaonyesha watu wale wanaosikia lile neno, halafu Ibilisi akaja na kuliondoa mioyoni mwao wasije wakaamini na hivyo wakaokoka. ");
INSERT INTO swh1850_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Zile zilizoanguka penye mawe zinaonyesha watu wale ambao wanaposikia juu ya lile neno hulipokea kwa furaha. Hata hivyo, kama zile mbegu, watu hao hawana mizizi maana husadiki kwa kitambo tu, na wanapojaribiwa hukata tamaa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zile zilizoanguka kwenye miti ya miiba ni watu wale wanaosikia lile neno, lakini muda si muda, wanapokwenda zao, husongwa na wasiwasi, mali na anasa za maisha, na hawazai matunda yakakomaa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na zile zilizoanguka kwenye udongo mzuri ndio watu wale wanaolisikia lile neno, wakalizingatia kwa moyo mwema na wa utii. Hao huvumilia mpaka wakazaa matunda. ");
INSERT INTO swh1850_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Watu hawawashi taa na kuifunika kwa chombo au kuiweka mvunguni. Lakini huiweka juu ya kinara ili watu wanapoingia ndani wapate kuona mwanga. ");
INSERT INTO swh1850_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Chochote kilichofichwa kitafichuliwa na siri yoyote itagunduliwa na kujulikana hadharani. ");
INSERT INTO swh1850_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kwa hiyo, jihadharini jinsi mnavyosikia; maana aliye na kitu ataongezewa, lakini yule asiye na kitu, hata kile anachodhani kuwa anacho, kitachukuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hapo mama na ndugu zake Yesu wakamjia, lakini hawakuweza kumkaribia kwa sababu ya umati wa watu. ");
INSERT INTO swh1850_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yesu akapewa habari kwamba mama na ndugu zake walikuwa nje, wanataka kumwona. ");
INSERT INTO swh1850_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lakini Yesu akawaambia watu wote, “Mama yangu na ndugu zangu ni wale wanaolisikia neno la Mungu na kulishika.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Siku moja, Yesu alipanda mashua pamoja na wanafunzi wake, akawaambia, “Tuvuke ziwa twende mpaka ng'ambo.” Basi, wakaanza safari. ");
INSERT INTO swh1850_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Walipokuwa wanasafiri kwa mashua, Yesu alishikwa na usingizi, akalala. Dhoruba kali ikaanza kuvuma, maji yakaanza kuingia ndani ya mashua, wakawa katika hatari. ");
INSERT INTO swh1850_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wale wanafunzi wakamwendea Yesu, wakamwamsha wakisema, “Bwana, Bwana! Tunaangamia!” Yesu akaamka, akaikemea dhoruba na mawimbi, navyo vikatulia, kukawa shwari. ");
INSERT INTO swh1850_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kisha akawaambia, “Iko wapi imani yenu?” Lakini wao walishangaa na kuogopa huku wakiambiana, “Huyu ni nani basi, hata anaamuru dhoruba na mawimbi, navyo vinamtii?” ");
INSERT INTO swh1850_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wakaendelea na safari, wakafika pwani ya nchi ya Wagerase inayokabiliana na Galilaya, ng'ambo ya ziwa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Alipokuwa anashuka pwani, mtu mmoja aliyekuwa amepagawa na pepo alimjia kutoka mjini. Kwa muda mrefu mtu huyo, hakuwa anavaa nguo, wala hakuwa anaishi nyumbani bali makaburini. ");
INSERT INTO swh1850_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Alipomwona Yesu, alipiga kelele na kujitupa chini mbele yake, na kusema kwa sauti kubwa “We, Yesu Mwana wa Mungu Aliye Juu una shauri gani nami? Ninakusihi usinitese!” ");
INSERT INTO swh1850_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alisema hivyo kwa kuwa Yesu alikwishamwambia huyo pepo mchafu amtoke mtu huyo. Pepo huyo mchafu alikuwa anamvamia mtu huyo mara nyingi, na ingawa watu walimweka ndani na kumfunga kwa minyororo na pingu, lakini kila mara alivivunja vifungo hivyo, akakimbizwa na pepo huyo mchafu hadi jangwani. ");
INSERT INTO swh1850_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Basi, Yesu akamwuliza, “Jina lako nani?” Yeye akajibu, “Jina langu ni Jeshi” —kwa sababu pepo wengi walikuwa wamempagaa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hao pepo wakamsihi asiwaamuru wamtoke na kwenda kwenye shimo lisilo na mwisho. ");
INSERT INTO swh1850_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kulikuwa na kundi kubwa la nguruwe wakilisha mlimani. Basi, hao pepo wakamsihi awaruhusu wawaingie. Naye Yesu akawapa ruhusa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kwa hiyo pepo hao wakamtoka yule mtu, wakawaingia wale nguruwe, nao wakaporomoka kwenye ule mteremko mkali, wakatumbukia ziwani, wakazama majini. ");
INSERT INTO swh1850_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wale wachungaji walipoona yote yaliyotokea walikimbia, wakaenda kuwapa watu habari, mjini na mashambani. ");
INSERT INTO swh1850_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Watu wakaja kuona yaliyotokea. Wakamwendea Yesu, wakamwona yule mtu aliyetokwa na pepo ameketi karibu na Yesu, amevaa nguo, ana akili zake, wakaogopa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wale watu walioshuhudia tukio hilo waliwaeleza hao jinsi yule mtu alivyoponywa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wakazi wa nchi ya Gerase walishikwa na hofu kubwa. Kwa hiyo wakamwomba Yesu aondoke, aende zake. Hivyo Yesu alipanda tena mashua, akaondoka. ");
INSERT INTO swh1850_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yule mtu aliyetokwa na wale pepo akamsihi aende pamoja naye. Lakini Yesu hakumruhusu, bali akamwambia, ");
INSERT INTO swh1850_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Rudi nyumbani ukaeleze yote Mungu aliyokutendea.” Basi, yule mtu akaenda akitangaza kila mahali katika mji ule mambo yote Yesu aliyomtendea. ");
INSERT INTO swh1850_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu aliporudi upande mwingine wa ziwa, kundi la watu lilimkaribisha, kwa maana wote walikuwa wanamngojea. ");
INSERT INTO swh1850_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hapo akaja mtu mmoja aitwaye Yairo, ofisa wa sunagogi. Alijitupa miguuni pa Yesu, akamwomba aende nyumbani kwake, ");
INSERT INTO swh1850_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwa kuwa binti yake wa pekee, mwana wa pekee mwenye umri wa miaka kumi na miwili, alikuwa mahututi. Yesu alipokuwa akienda, watu wakawa wanamsonga kila upande. ");
INSERT INTO swh1850_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kulikuwa na mwanamke mmoja kati ya lile kundi la watu, ambaye alikuwa na ugonjwa wa kutokwa damu kwa muda wa miaka kumi na miwili, ingawa alikuwa amekwisha tumia mali yake yote kwa waganga, hakuna aliyefaulu kumponya. ");
INSERT INTO swh1850_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Huyo mwanamke alimfuata Yesu nyuma, akagusa pindo la vazi lake. Papo hapo akaponywa ugonjwa wake wa kutokwa damu. ");
INSERT INTO swh1850_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu akasema, “Ni nani aliyenigusa?” Wote wakasema kwamba hapakuwa na mtu aliyemgusa. Naye Petro akasema, “Mwalimu, umati wa watu umekuzunguka na kukusonga!” ");
INSERT INTO swh1850_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu akasema, “Kuna mtu aliyenigusa, maana nimehisi nguvu imenitoka.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yule mwanamke alipoona kwamba hawezi kujificha, akajitokeza akitetemeka kwa hofu, akajitupa mbele ya Yesu. Hapo akaeleza mbele ya wote kisa cha kumgusa Yesu na jinsi alivyoponyeshwa mara moja. ");
INSERT INTO swh1850_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu akamwambia, “Binti, imani yako imekuponya. Nenda kwa amani.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Alipokuwa bado akiongea, Yairo akaletewa habari kutoka nyumbani: “Binti yako ameshakufa, ya nini kumsumbua Mwalimu zaidi?” ");
INSERT INTO swh1850_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu aliposikia hayo akamwambia Yairo, “Usiogope; amini tu, naye atapona.” ");
INSERT INTO swh1850_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Alipofika nyumbani hakumruhusu mtu kuingia ndani pamoja naye, isipokuwa Petro, Yohane, Yakobo na wazazi wa huyo msichana. ");
INSERT INTO swh1850_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Watu wote walikuwa wakilia na kuomboleza kwa ajili yake. Lakini Yesu akawaambia, “Msilie, kwa maana mtoto hajafa, amelala tu!” ");
INSERT INTO swh1850_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nao wakamcheka kwa sababu walijua kwamba alikuwa amekufa. ");
INSERT INTO swh1850_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini Yesu akamshika mkono akasema, “Mtoto amka!” ");
INSERT INTO swh1850_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Roho yake ikamrudia, akaamka mara. Yesu akaamuru wampe chakula. ");
INSERT INTO swh1850_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wazazi wake walishangaa, lakini Yesu akawaamuru wasimwambie mtu yeyote hayo yaliyotendeka. ");
INSERT INTO swh1850_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu aliwaita wale kumi na wawili, akawapa uwezo juu ya pepo wote, na uwezo wa kuponya wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Halafu akawatuma waende kuhubiri Ufalme wa Mungu na kuponya wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akawaambia, “Mnaposafiri msichukue chochote: msichukue fimbo, wala mkoba, wala chakula, wala fedha, wala hata koti la ziada. ");
INSERT INTO swh1850_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yoyote mtakayoingia na kukaribishwa, kaeni humo mpaka mtakapoondoka katika kijiji hicho. ");
INSERT INTO swh1850_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Watu wakikataa kuwakaribisha, tokeni katika mji huo, nanyi mnapotoka kung'uteni mavumbi miguuni mwenu kama onyo kwao.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Basi, wakaanza safari, wakapitia vijijini wakihubiri Habari Njema na kuponya wagonjwa kila mahali. ");
INSERT INTO swh1850_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sasa, mtawala Herode, alipata habari za mambo yote yaliyokuwa yanatendeka, akawa na wasiwasi kwa vile walikuwa wakisema: “Yohane amefufuka kutoka wafu!” ");
INSERT INTO swh1850_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wengine walisema kwamba Eliya ametokea, na wengine walisema kwamba mmojawapo wa manabii wa kale amerudi duniani. ");
INSERT INTO swh1850_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lakini Herode akasema, “Huyo Yohane nilimkata kichwa; sasa ni nani huyu ninayesikia habari zake?” Akawa na hamu ya kumwona. ");
INSERT INTO swh1850_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wale mitume waliporudi, walimweleza yote waliyoyafanya. Yesu akawachukua, wakaenda peke yao mjini Bethsaida. ");
INSERT INTO swh1850_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini wale watu walipojua alikokwenda, walimfuata. Yesu akawakaribisha akawazungumzia juu ya Ufalme wa Mungu, akawaponya wale waliohitaji kuponywa. ");
INSERT INTO swh1850_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jua lilipokuwa linaanza kutua, wale kumi na wawili walimwendea wakamwambia, “Waage watu waende kwenye vijiji na mashamba ya karibu, wakajipatie chakula na mahali pa kulala, kwa maana hapa tulipo ni nyikani.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini Yesu akawaambia, “Wapeni ninyi chakula.” Wakamjibu, “Hatuna chochote ila mikate mitano na samaki wawili. Labda twende wenyewe tukawanunulie chakula watu wote hawa!” ");
INSERT INTO swh1850_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Walikuwepo pale wanaume wapatao elfu tano.) Basi, Yesu akawaambia wanafunzi wake, “Waambieni watu waketi katika makundi ya watu hamsinihamsini.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanafunzi wakafanya walivyoambiwa, wakawaketisha wote. ");
INSERT INTO swh1850_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kisha Yesu akaitwaa ile mikate mitano na wale samaki wawili, akatazama juu mbinguni, akamshukuru Mungu, akavimega, akawapa wanafunzi wake wawagawie watu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wakala wote, wakashiba; wakakusanya makombo ya chakula, wakajaza vikapu kumi na viwili. ");
INSERT INTO swh1850_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Siku moja, Yesu alikuwa anasali peke yake, na wanafunzi wake walikuwa karibu. Basi, akawauliza, “Eti watu wanasema mimi ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nao wakamjibu, “Wengine wanasema kuwa wewe ni Yohane mbatizaji, wengine wanasema wewe ni Eliya, hali wengine wanasema kuwa wewe ni mmoja wa manabii wa kale ambaye amefufuka.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hapo akawauliza, “Na ninyi je, mwasema mimi ni nani?” Petro akajibu, “Wewe ndiwe Kristo wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Halafu Yesu akawaamuru wasimwambie mtu yeyote habari hiyo. ");
INSERT INTO swh1850_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akaendelea kusema: “Ni lazima Mwana wa Mtu apate mateso mengi na kukataliwa na wazee na makuhani wakuu na walimu wa Sheria; atauawa, lakini siku ya tatu atafufuliwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kisha akawaambia watu wote, “Mtu yeyote akitaka kuwa mfuasi wangu, ni lazima ajikane nafsi yake, auchukue msalaba wake kila siku, anifuate. ");
INSERT INTO swh1850_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maana, mtu anayetaka kuyaokoa maisha yake mwenyewe, atayapoteza; lakini atakayeyapoteza maisha yake kwa ajili yangu, atayaokoa. ");
INSERT INTO swh1850_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Je, kuna faida gani mtu kuupata utajiri wote wa dunia kwa kujipoteza au kujiangamiza yeye mwenyewe? ");
INSERT INTO swh1850_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mtu akinionea aibu mimi na mafundisho yangu, Mwana wa Mtu atamwonea aibu mtu huyo wakati atakapokuja katika utukufu wake na wa Baba na wa malaika watakatifu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nawaambieni kweli, kuna wengine papa hapa ambao hawatakufa kabla ya kuuona Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yapata siku nane baada ya kusema hayo, Yesu aliwachukua Petro, Yohane na Yakobo, akaenda nao mlimani kusali. ");
INSERT INTO swh1850_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Alipokuwa akisali, sura yake ilibadilika, mavazi yake yakawa meupe na kung'aa sana. ");
INSERT INTO swh1850_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na watu wawili wakaonekana wakizungumza naye, nao ni Mose na Eliya, ");
INSERT INTO swh1850_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ambao walitokea wakiwa wenye utukufu, wakazungumza naye juu ya kifo chake ambacho angekikamilisha huko Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro na wenzake walikuwa wamelemewa na usingizi mzito, hata hivyo waliamka, wakauona utukufu wake, wakawaona na wale watu wawili waliokuwa wamesimama pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Basi, watu hao wawili walipokuwa wakiondoka, Petro alimwambia Yesu, “Bwana, ni vizuri kwamba tupo hapa: basi, tujenge vibanda vitatu: kimoja chako, kimoja cha Mose na kimoja cha Eliya.” —Kwa kweli hakujua anasema nini. ");
INSERT INTO swh1850_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petro alipokuwa akisema hayo, mara wingu likatokea na kuwafunika; na wingu hilo lilipowajia, wale wanafunzi waliogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauti ikasikika kutoka katika hilo wingu: “Huyu ndiye Mwanangu niliyemchagua, msikilizeni.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baada ya hiyo sauti kusikika, Yesu alionekana akiwa peke yake. Wanafunzi walikaa kimya juu ya tukio hilo, na wakati ule hawakumwambia mtu yeyote mambo hayo waliyoyaona. ");
INSERT INTO swh1850_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kesho yake walipokuwa wakishuka kutoka kule mlimani, kundi kubwa la watu lilikutana na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hapo, mtu mmoja katika lile kundi akapaaza sauti, akasema, “Mwalimu! Ninakusihi umwangalie mwanangu—mwanangu wa pekee! ");
INSERT INTO swh1850_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pepo huwa anamshambulia, na mara humfanya apige kelele; humtia kifafa, na povu likamtoka kinywani. Huendelea kumtesa sana, asimwache upesi. ");
INSERT INTO swh1850_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niliwaomba wanafunzi wako wamfukuze, lakini hawakuweza.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu akasema, “Enyi kizazi kisicho na imani, kilichopotoka! Nitakaa nanyi na kuwavumilia mpaka lini?” Kisha akamwambia huyo mtu, “Mlete mtoto wako hapa.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wakati mtoto huyo alipokuwa anamjia Yesu, yule pepo alimwangusha chini na kumtia kifafa. Lakini Yesu akamkemea yule pepo mchafu akamponya mtoto na kumkabidhi kwa baba yake. ");
INSERT INTO swh1850_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Watu wote wakashangazwa na uwezo mkuu wa Mungu. Wale watu walipokuwa bado wanashangaa juu ya mambo yote aliyofanya, Yesu aliwaambia wanafunzi wake, ");
INSERT INTO swh1850_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tegeni masikio, myasikie mambo haya: Mwana wa Mtu anakwenda kutiwa mikononi mwa watu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini wao hawakuelewa maana ya usemi huo. Jambo hilo lilikuwa limefichwa kwao ili wasitambue; nao wakaogopa kumwuliza juu ya msemo huo. ");
INSERT INTO swh1850_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kukatokea majadiliano kati ya wale wanafunzi kuhusu nani kati yao aliyekuwa mkuu zaidi. ");
INSERT INTO swh1850_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu aliyajua mawazo yaliyokuwa mioyoni mwao; basi akamchukua mtoto mdogo akamweka karibu naye, ");
INSERT INTO swh1850_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","akawaambia, “Mtu yeyote anayempokea mtoto huyu mdogo kwa jina langu, ananipokea mimi; na yeyote anayenipokea mimi, anampokea yule aliyenituma. Maana yule aliye mdogo kuliko wote kati yenu ndiye aliye mkubwa kuliko wote.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohane alidakia na kusema, “Bwana, tumemwona mtu mmoja akitoa pepo kwa kulitumia jina lako nasi tukajaribu kumkataza kwa kuwa yeye si mmoja wetu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu akamwambia, “Msimkataze; kwani asiyepingana nanyi yuko upande wenu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wakati ulipokaribia ambapo Yesu angechukuliwa juu mbinguni, yeye alikata shauri kwenda Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Basi, akawatuma wajumbe wamtangulie, nao wakaenda wakaingia kijiji kimoja cha Wasamaria ili wamtayarishie mahali. ");
INSERT INTO swh1850_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini wenyeji wa hapo hawakutaka kumpokea kwa sababu alikuwa anaelekea Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Basi, wanafunzi wake, kina Yohane na Yakobo, walipoona hayo, wakasema, “Bwana, wataka tuamuru moto ushuke kutoka mbinguni uwateketeze?” ");
INSERT INTO swh1850_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lakini yeye akawageukia, akawakemea akasema, “Hamjui ni roho ya namna gani mliyo nayo; ");
INSERT INTO swh1850_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kwa maana Mwana wa Mtu hakuja kuyaangamiza maisha ya watu, bali kuyaokoa.” Wakatoka, wakaenda kijiji kingine. ");
INSERT INTO swh1850_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Walipokuwa wakisafiri njiani, mtu mmoja akamwambia Yesu, “Nitakufuata kokote utakakokwenda.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akasema, “Mbweha wana mapango, na ndege wana viota; lakini Mwana wa Mtu hana mahali pa kupumzikia.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kisha akamwambia mtu mwingine, “Nifuate.” Lakini huyo akasema, “Bwana, niruhusu kwanza niende kumzika baba yangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu akamwambia, “Waache wafu wazike wafu wao; bali wewe nenda ukatangaze Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mtu mwingine akamwambia, “Nitakufuata, lakini niruhusu kwanza nikawaage wale walio nyumbani kwangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu akamwambia, “Yeyote anayeshika jembe tayari kulima na huku anaangalia nyuma, hafai kwa Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baada ya hayo, Bwana aliwachagua wengine sabini na wawili, akawatuma wawiliwawili, wamtangulie katika kila kijiji na mahali ambapo yeye mwenyewe alitaka kwenda. ");
INSERT INTO swh1850_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akawaambia, “Mavuno ni mengi, lakini wavunaji ni wachache. Kwa hivyo, mwombeni mwenye shamba atume wavunaji shambani mwake. ");
INSERT INTO swh1850_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sasa nendeni; fahamuni kwamba ninawatuma ninyi kama kondoo wanaokwenda kati ya mbwa mwitu. ");
INSERT INTO swh1850_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Msichukue mfuko wa fedha, mkoba, wala viatu; msimsalimu mtu yeyote njiani. ");
INSERT INTO swh1850_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mkiingia katika nyumba yoyote, kwanza wasalimuni hivi: Amani iwe katika nyumba hii! ");
INSERT INTO swh1850_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kama akiwako mwenye kupenda amani, amani yenu itakaa naye, la sivyo, itawarudieni. ");
INSERT INTO swh1850_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kaeni katika nyumba hiyo mkila na kunywa wanavyowapeni, maana mfanyakazi anastahili mshahara wake. Msiende mara nyumba hii mara nyumba ile. ");
INSERT INTO swh1850_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kama mkifika mji fulani na watu wakiwakaribisha, kuleni wanavyowapeni. ");
INSERT INTO swh1850_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ponyeni wagonjwa walioko huko, waambieni watu: Ufalme wa Mungu umekaribia kwenu. ");
INSERT INTO swh1850_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini mkiingia katika mji wowote, wasipowakaribisheni, tokeni; nanyi mpitapo katika barabara zao semeni: ");
INSERT INTO swh1850_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hata mavumbi ya mji wenu yaliyoshikamana na miguu yetu tunawakung'utieni. Lakini, jueni kwamba Ufalme wa Mungu umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hakika nawaambieni, siku ile mji huo utapata adhabu kubwa zaidi kuliko ile ya watu wa Sodoma. ");
INSERT INTO swh1850_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ole wako Korazini! Ole wako Bethsaida! Maana, kama miujiza iliyofanyika kwenu ingalifanyika kule Tiro na Sidoni, watu wake wangalikwishavaa mavazi ya gunia kitambo, na kukaa katika majivu kuonyesha kwamba wametubu. ");
INSERT INTO swh1850_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hata hivyo, Siku ya Hukumu ninyi mtapata adhabu kubwa zaidi kuliko ile ya watu wa Tiro na Sidoni. ");
INSERT INTO swh1850_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na wewe Kafarnaumu, unataka kujikweza mpaka mbinguni? La; utaporomoshwa mpaka Kuzimu.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Halafu akasema, “Anayewasikiliza ninyi, ananisikiliza mimi; na anayekataa kuwapokea ninyi, anakataa kunipokea mimi. Yeyote anayekataa kunipokea, anakataa kumpokea yule aliyenituma.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baadaye, wale sabini na wawili walirudi wamejaa furaha, wakisema, “Bwana, hata pepo wametutii tulipolitaja jina lako.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeye akawaambia, “Nilimwona Shetani jinsi alivyokuwa anaporomoka kama umeme kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naam, nimewapeni uwezo wa kukanyaga nyoka na ng'e, na uwezo juu ya nguvu zote za yule adui; hakuna chochote kitakachowadhuru. ");
INSERT INTO swh1850_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hata hivyo, msifurahi kwa sababu pepo wamewatii, bali furahini kwa sababu majina yenu yameandikwa mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saa ileile, Yesu akafurahi kwa uwezo wa Roho Mtakatifu, akasema, “Nakushukuru ee Baba, Bwana wa mbingu na dunia, kwa kuwa umewaficha wenye hekima na elimu mambo haya, ukawafumbulia wadogo. Naam, Baba, ndivyo ilivyokupendeza.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kisha akasema, “Baba yangu ameweka yote mikononi mwangu. Hakuna amjuaye Mwana ni nani ila Baba, wala amjuaye Baba ni nani ila Mwana, na yeyote yule ambaye Mwana anataka kumfunulia hayo.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Halafu akawaelekea wafuasi wake akawaambia, “Heri wanaoona yale mnayoyaona ninyi! ");
INSERT INTO swh1850_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hakika, manabii na wafalme walitamani kuona yale mnayoyaona ninyi wasiyaone, na kusikia yale mnayoyasikia wasiyasikie.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Baadaye mwalimu mmoja wa Sheria alisimama akamwuliza akitaka kumtega, “Mwalimu, nifanye nini ili nipate uzima wa milele?” ");
INSERT INTO swh1850_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu akamwuliza, “Imeandikwa nini katika Sheria? Unaelewaje?” ");
INSERT INTO swh1850_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akamjibu, “Mpende Bwana Mungu wako kwa moyo wako wote, kwa roho yako yote, kwa nguvu zako zote na kwa akili yako yote. Na, mpende jirani yako kama unavyojipenda mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu akawaambia, “Vema! Fanya hivyo, nawe utaishi.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini yeye akitaka kujihakikishia kuwa mwema akamwuliza Yesu, “Na jirani yangu ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akamjibu, “Mtu mmoja alikuwa anashuka kutoka Yerusalemu kwenda Yeriko. Alipokuwa njiani, alivamiwa na majambazi, wakamnyang'anya mali yake na kumpiga, wakamwacha amelala pale nusu mfu. ");
INSERT INTO swh1850_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kumbe, kuhani mmoja akawa anapita barabara ileile, akamwona, akapita kando. ");
INSERT INTO swh1850_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hali kadhalika na Mlawi mmoja, alipofika mahali akamwona, akapita kando. ");
INSERT INTO swh1850_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini Msamaria mmoja aliyekuwa anasafiri, alifika pale yule mtu alipokuwa, naye alipomwona, alimwonea huruma. ");
INSERT INTO swh1850_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akamwendea, akamtibu majeraha yake kwa kumtia mafuta na divai; na kuyafunga halafu akampandisha juu ya punda wake akampeleka katika nyumba moja ya wageni akamuuguza. ");
INSERT INTO swh1850_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kesho yake akatoa fedha dinari mbili akampa yule mwenye nyumba, akamwambia, Muuguze mtu huyu; na chochote utakachotumia zaidi, nitakulipa nitakaporudi.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kisha Yesu akauliza, “Kati ya hao watatu, ni yupi aliyeonyesha kuwa jirani yake yule aliyevamiwa na majambazi?” ");
INSERT INTO swh1850_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yule mwalimu wa Sheria akamjibu, “Ni yule aliyemwonea huruma.” Yesu akamwambia, “Nenda ukafanye vivyo hivyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Walipokuwa safarini, waliingia katika kijiji kimoja na mwanamke mmoja, aitwaye Martha, alimkaribisha nyumbani kwake. ");
INSERT INTO swh1850_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha alikuwa na dada yake aitwaye Maria; huyu aliketi karibu na Yesu akisikiliza mafundisho yake. ");
INSERT INTO swh1850_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Martha alikuwa anashughulika na mambo mengi. Basi, akamwendea Yesu, akamwambia, “Bwana, hivi hujali kwamba dada yangu ameniacha nishughulike peke yangu? Mwambie basi, anisaidie.” ");
INSERT INTO swh1850_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Bwana akamjibu, “Martha, Martha, unahangaika na kusumbuka kwa mambo mengi. ");
INSERT INTO swh1850_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kitu kimoja tu ni muhimu. Maria amechagua kitu bora zaidi ambacho hakuna mtu atakayemnyag'anya.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Siku moja, Yesu alikuwa mahali fulani akisali. Alipomaliza kusali, mmoja wa wanafunzi wake akamwambia, “Bwana, tunakuomba utufundishe kusali kama Yohane mbatizaji alivyowafundisha wanafunzi wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu akawaambia, “Mnaposali, semeni: Baba! Jina lako litukuzwe; Ufalme wako ufike. ");
INSERT INTO swh1850_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupe daima chakula chetu cha kila siku. ");
INSERT INTO swh1850_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utusamehe dhambi zetu, maana sisi tunawasamehe wote waliotukosea; wala usitutie katika majaribu.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kisha akawaambia, “Tuseme mmoja wenu anaye rafiki, akaenda kwake usiku wa manane, akamwambia: Rafiki, tafadhali niazime mikate mitatu, ");
INSERT INTO swh1850_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwa kuwa rafiki yangu amepitia kwangu akiwa safarini nami sina cha kumpa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naye, akiwa ndani angemjibu: Usinisumbue! Nimekwisha funga mlango. Mimi na watoto wangu tumelala; siwezi kuamka nikupe! ");
INSERT INTO swh1850_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hakika, ingawa hataamka ampe kwa sababu yeye ni rafiki yake, lakini, kwa sababu ya huyo mtu kuendelea kumwomba, ataamka ampe chochote anachohitaji. ");
INSERT INTO swh1850_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kwa hiyo, ombeni, nanyi mtapewa, tafuteni, nanyi mtapata, bisheni nanyi mtafunguliwa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maana yeyote aombaye hupewa, atafutaye hupata na abishaye hufunguliwa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mtoto akimwomba baba yake samaki, je, atampa nyoka badala ya samaki? ");
INSERT INTO swh1850_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na kama akimwomba yai, je, atampa ng'e? ");
INSERT INTO swh1850_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ninyi, ingawa ni waovu, mnajua kuwapa watoto wenu vitu vizuri. Basi, baba yenu wa mbinguni atafanya zaidi; atawapa Roho Mtakatifu wale wanaomwomba.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Siku moja Yesu alikuwa anamfukuza pepo aliyemfanya mtu mmoja kuwa bubu. Basi, huyo pepo alipomtoka, yule mtu akaweza kuongea hata umati wa watu ukashangaa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini baadhi ya watu hao wakasema, “Anamfukuza pepo kwa uwezo wa Beelzebuli, mkuu wa pepo.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wengine, wakimjaribu, wakamtaka afanye ishara kuonyesha kama alikuwa na idhini kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini yeye, akiwa anayajua mawazo yao, akawaambia, “Ufalme wowote uliofarakana wenyewe, hauwezi kudumu; kadhalika, jamaa yeyote inayofarakana huangamia. ");
INSERT INTO swh1850_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kama Shetani anajipinga mwenyewe, utawala wake utasimamaje? Mnasemaje, basi, kwamba ninawafukuza pepo kwa uwezo wa Beelzebuli? ");
INSERT INTO swh1850_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kama ninafukuza pepo kwa uwezo wa Beelzebuli, watoto wenu huwafukuza kwa uwezo wa nani? Kwa sababu hiyo, wao ndio watakaowahukumu ninyi. ");
INSERT INTO swh1850_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini ikiwa ninawafukuza pepo kwa uwezo wa Mungu, basi jueni kwamba Ufalme wa Mungu umekwisha fika kwenu. ");
INSERT INTO swh1850_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mtu mwenye nguvu anapolinda jumba lake kwa silaha, mali yake yote iko salama. ");
INSERT INTO swh1850_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini akija mwenye nguvu zaidi akamshambulia na kumshinda, huyo huziteka silaha zake alizotegemea na kugawanya nyara. ");
INSERT INTO swh1850_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yeyote asiyejiunga nami, ananipinga; na yeyote asiyekusanya pamoja nami, hutawanya. ");
INSERT INTO swh1850_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Pepo mchafu akifukuzwa kwa mtu fulani, huzururazurura jangwani akitafuta mahali pa kupumzikia. Asipopata, hujisemea: Nitarudi kwenye makao yangu nilikotoka. ");
INSERT INTO swh1850_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Anaporudi, huikuta ile nyumba imefagiwa na kupambwa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Basi, huenda na kuwachukua pepo wengine saba waovu zaidi kuliko yeye; wote huenda na kumwingia mtu yule. Hivyo, basi hali ya mtu huyo sasa huwa mbaya zaidi kuliko pale mwanzo.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Alipokuwa akisema hayo, mwanamke mmoja katika lile kundi la watu, akasema kwa sauti kubwa: “Heri tumbo lililokuzaa, na maziwa yaliyokunyonyesha!” ");
INSERT INTO swh1850_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini Yesu akasema, “Lakini heri zaidi wale wanaolisikia neno la Mungu na kulishika.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Umati wa watu ulipozidi kuongezeka, Yesu akawaambia, “Kizazi hiki ni kizazi kiovu. Kinataka ishara, lakini hakitapewa ishara yoyote isipokuwa ile ya Yona. ");
INSERT INTO swh1850_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jinsi Yona alivyokuwa ishara kwa watu wa Ninewi, ndivyo pia Mwana wa Mtu atakavyokuwa ishara kwa kizazi hiki. ");
INSERT INTO swh1850_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Malkia wa kusini atatokea wakati kizazi hiki kitakapohukumiwa, naye atashuhudia kwamba kina hatia. Yeye alisafiri kutoka mbali, akaja kusikiliza maneno ya hekima ya Solomoni; kumbe hapa pana mkuu zaidi kuliko Solomoni. ");
INSERT INTO swh1850_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Watu wa Ninewi watatokea wakati kizazi hiki kitakapohukumiwa, na watashuhudia kwamba kizazi hiki kina hatia. Hao watu wa Ninewi walitubu kwa sababu ya mahubiri ya Yona; na hapa pana mkuu zaidi kuliko Yona! ");
INSERT INTO swh1850_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hakuna mtu anayewasha taa na kuifunika kwa pishi, bali huiweka juu ya kinara ili watu wanaoingia ndani wapate kuona mwanga. ");
INSERT INTO swh1850_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jicho lako ni kama taa ya mwili wako; likiwa zima, mwili wako wote utakuwa katika mwanga. Jicho lako likiwa bovu, na mwili wako pia utakuwa katika giza. ");
INSERT INTO swh1850_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Uwe mwangalifu basi mwanga ulio ndani yako usije ukawa giza. ");
INSERT INTO swh1850_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Basi, kama mwili wako wote una mwanga, bila kuwa na sehemu yoyote yenye giza, mwili huo utang'aa kikamilifu kama vile taa inavyokuangazia kwa mwanga wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu alipokuwa akiongea, Mfarisayo mmoja alimkaribisha chakula nyumbani kwake, naye akaenda, akaketi kula chakula. ");
INSERT INTO swh1850_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Huyo Mfarisayo alistaajabu kuona kwamba alikula chakula bila kunawa. ");
INSERT INTO swh1850_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bwana akamwambia, “Ninyi Mafarisayo huosha kikombe na sahani kwa nje, lakini ndani mmejaa udhalimu na uovu. ");
INSERT INTO swh1850_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wapumbavu ninyi! Je, aliyetengeneza nje si ndiye aliyetengeneza ndani pia? ");
INSERT INTO swh1850_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Toeni kwa maskini vile vitu vilivyomo ndani, na vingine vyote vitakuwa halali kwenu. ");
INSERT INTO swh1850_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lakini ole wenu Mafarisayo, kwa sababu mnatoza watu zaka hata juu ya majani ya kukolezea chakula, mchicha na majani mengine, na huku hamjali juu ya haki na upendo kwa Mungu. Mambo haya iliwapasa muwe mmeyazingatia bila kuyasahau yale mengine. ");
INSERT INTO swh1850_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ole wenu ninyi Mafarisayo, kwa sababu mnapenda kuketi mbele mahali pa heshima katika masunagogi, na kusalimiwa kwa heshima hadharani. ");
INSERT INTO swh1850_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ole wenu, kwa sababu mko kama makaburi yaliyofichika; watu hutembea juu yake bila kufahamu.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mmoja wa walimu wa Sheria akamwambia, “Mwalimu, maneno yako yanatukashifu na sisi pia.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akamjibu, “Na ninyi walimu wa Sheria, ole wenu; maana mnawatwika watu mizigo isiyochukulika, huku ninyi wenyewe hamnyoshi hata kidole kuwasaidia. ");
INSERT INTO swh1850_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ole wenu, kwa kuwa mnajenga makaburi ya manabii wale ambao wazee wenu waliwaua. ");
INSERT INTO swh1850_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwa hiyo mnashuhudia na kukubaliana na matendo ya wazee wenu; maana wao waliwaua hao manabii, nanyi mnajenga makaburi yao. ");
INSERT INTO swh1850_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwa hiyo, Hekima ya Mungu ilisema hivi: Nitawapelekea manabii na mitume, lakini watawaua baadhi yao, na kuwatesa wengine. ");
INSERT INTO swh1850_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Matokeo yake ni kwamba kizazi hiki kitaadhibiwa kwa sababu ya damu ya manabii wote iliyomwagika tangu mwanzo wa ulimwengu; ");
INSERT INTO swh1850_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tangu kumwagwa damu ya Abeli mpaka kifo cha Zakariya ambaye walimuua kati ya madhabahu na mahali patakatifu. Naam, hakika kizazi hiki kitaadhibiwa kwa matendo haya. ");
INSERT INTO swh1850_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ole wenu ninyi walimu wa Sheria, kwa sababu mmeuficha ule ufunguo wa mlango wa elimu; ninyi wenyewe hamkuingia na mmewazuia waliokuwa wanaingia wasiingie.” ");
INSERT INTO swh1850_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Alipokuwa akitoka pale, wale Mafarisayo na walimu wa Sheria wakaanza kumshambulia vikali na kumsonga kwa maswali mengi ");
INSERT INTO swh1850_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ili wapate kumnasa kwa maneno yake. ");
INSERT INTO swh1850_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wakati watu kwa maelfu walipokuwa wamekusanyika hata wakawa wanakanyagana, Yesu aliwaambia kwanza wanafunzi wake, “Jihadharini na chachu ya Mafarisayo, yaani unafiki. ");
INSERT INTO swh1850_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila kilichofunikwa kitafunuliwa, kila kilichofichika kitafichuliwa. ");
INSERT INTO swh1850_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa hiyo, kila mliyosema gizani, watu watayasikia katika mwanga, na kila mliyonong'ona faraghani milango imefungwa, yatatangazwa juu ya nyumba. ");
INSERT INTO swh1850_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nawaambieni ninyi rafiki zangu: msiwaogope wale wanaoua mwili, wasiweze kufanya kitu kingine zaidi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nitawaonyesheni yule ambaye ni lazima kumwogopa: mwogopeni yule ambaye baada ya kuua ana uwezo wa kumtupa mtu katika moto wa Jehanamu. Naam, ninawaambieni, mwogopeni huyo. ");
INSERT INTO swh1850_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Inajulikana kwamba shomoro watano huuzwa kwa senti kumi, au sivyo? Lakini mbele ya Mungu hasahauliki hata mmoja. ");
INSERT INTO swh1850_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lakini hata nywele za vichwa vyenu zimehesabiwa zote. Msiogope, basi, ninyi mna thamani zaidi kuliko shomoro wengi! ");
INSERT INTO swh1850_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nawaambieni kweli, kila mtu anayekiri hadharani kwamba yeye ni wangu, Mwana wa Mtu naye atakiri mbele ya malaika wa Mungu kwamba mtu huyo ni wake. ");
INSERT INTO swh1850_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini, mtu yeyote anayenikana mbele ya watu, naye atakanwa mbele ya malaika wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yeyote anayesema neno la kumpinga Mwana wa Mtu atasamehewa; lakini anayemkufuru Roho Mtakatifu hatasamehewa. ");
INSERT INTO swh1850_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Watakapowapeleka ninyi mbele ya masunagogi na mbele ya wakuu na watawala msiwe na wasiwasi juu ya jinsi mtakavyojitetea au jinsi mtakavyosema. ");
INSERT INTO swh1850_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwa maana wakati huo Roho Mtakatifu atawafundisheni kile mnachopaswa kusema.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mtu mmoja katika ule umati wa watu akamwambia, “Mwalimu, mwambie ndugu yangu tugawane urithi aliotuachia baba.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akamjibu, “Rafiki, ni nani aliyeniweka mimi mwamuzi au msuluhishi kati yenu?” ");
INSERT INTO swh1850_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Basi, akawaambia wote, “Jihadharini na kila aina ya tamaa; maana uzima wa mtu hautegemei wingi wa vitu alivyo navyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kisha akawaambia mfano: “Kulikuwa na tajiri mmoja ambaye shamba lake lilizaa mavuno mengi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tajiri huyo akafikiri moyoni mwake: Nitafanyaje nami sina mahali pa kuhifadhia mavuno yangu? ");
INSERT INTO swh1850_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nitafanya hivi: nitabomoa ghala zangu na kujenga kubwa zaidi, na humo nitahifadhi mavuno yangu yote na mali yangu. ");
INSERT INTO swh1850_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hapo nitaweza kuiambia roho yangu: sasa unayo akiba ya matumizi kwa miaka na miaka. Ponda mali, ule, unywe na kufurahi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Mungu akamwambia: Mpumbavu wewe; leo usiku roho yako itachukuliwa. Na vitu vile vyote ulivyojilundikia vitakuwa vya nani?” ");
INSERT INTO swh1850_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu akamaliza kwa kusema “Ndivyo ilivyo kwa mtu anayejilundikia mali kwa ajili yake mwenyewe, lakini si tajiri mbele ya Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kisha Yesu akawaambia wanafunzi wake, “Kwa sababu hiyo nawaambieni, msiwe na wasiwasi juu ya chakula mnachohitaji ili kuishi, wala juu ya mavazi mnayohitaji kwa ajili ya miili yenu. ");
INSERT INTO swh1850_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwa sababu uzima ni bora kuliko chakula, na mwili ni bora kuliko mavazi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chukueni kwa mfano, kunguru: hawapandi, hawavuni wala hawana ghala yoyote. Hata hivyo, Mungu huwalisha. Ninyi mna thamani zaidi kuliko ndege! ");
INSERT INTO swh1850_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni nani kati yenu kwa kuwa na wasiwasi anaweza kuongeza urefu wa maisha yake? ");
INSERT INTO swh1850_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Basi, kama hamwezi kufanya jambo dogo kama hilo, kwa nini kuwa na wasiwasi juu ya yale mengine? ");
INSERT INTO swh1850_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Angalieni maua jinsi yanavyomea. Hayafanyi kazi wala hayafumi. Hata hivyo, nawahakikishieni kwamba hata Solomoni mwenyewe na fahari zake zote hakupata kuvikwa vizuri kama ua mojawapo. ");
INSERT INTO swh1850_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lakini, kama Mungu hulivika vizuri jani la shambani ambalo leo liko na kesho latupwa motoni, je, hatawafanyia ninyi zaidi? Enyi watu wenye imani haba! ");
INSERT INTO swh1850_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Basi, msivurugike akili, mkihangaika daima juu ya mtakachokula au mtakachokunywa. ");
INSERT INTO swh1850_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwa maana hayo yote ndiyo yanayohangaikiwa na watu wasiomjua Mungu. Baba yenu anajua kwamba mnahitaji vitu hivyo. ");
INSERT INTO swh1850_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Shughulikieni kwanza Ufalme wa Mungu, na hayo yote mtapewa kwa ziada. ");
INSERT INTO swh1850_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Msiogope, enyi kundi dogo! Maana Baba yenu amependa kuwapeni Ufalme. ");
INSERT INTO swh1850_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Uzeni mali yenu mkawape maskini misaada. Jifanyieni mifuko isiyochakaa, na jiwekeeni hazina mbinguni ambako haitapungua. Huko wezi hawakaribii, wala nondo hawaharibu. ");
INSERT INTO swh1850_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pale ilipo hazina yako, ndipo pia utakapokuwa moyo wako. ");
INSERT INTO swh1850_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Muwe tayari! Jifungeni mkanda kiunoni, na taa zenu ziwe zinawaka; ");
INSERT INTO swh1850_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","muwe kama watumishi wanaomngojea bwana wao arudi kutoka arusini, ili wamfungulie mara atakapobisha hodi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Heri yao watumishi wale ambao bwana wao atakaporudi atawakuta wanakesha! Nawaambieni hakika, huyo bwana atajifunga mkanda kiunoni, atawaketisha mezani na kuwahudumia. ");
INSERT INTO swh1850_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Heri yao watumishi hao ikiwa bwana wao atawakuta wanakesha hata ikiwa atarudi usiku wa manane au alfajiri. ");
INSERT INTO swh1850_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jueni kwamba, kama mwenye nyumba angejua saa ambayo mwizi atakuja, angekesha, wala hangeiacha nyumba yake ivunjwe. ");
INSERT INTO swh1850_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nanyi, kadhalika muwe tayari, maana Mwana wa Mtu atakuja saa msiyoitazamia.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro akamwambia, “Bwana, mfano huo ni kwa ajili yetu tu, au ni kwa ajili ya watu wote?” ");
INSERT INTO swh1850_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bwana akajibu, “Ni nani basi, mtumishi aliye mwaminifu na mwenye busara, ambaye bwana wake atamweka juu ya watumishi wake ili awape chakula wakati ufaao? ");
INSERT INTO swh1850_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Heri yake mtumishi huyo ikiwa bwana wake atakaporudi atamkuta akifanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hakika atampa madaraka juu ya mali yake yote. ");
INSERT INTO swh1850_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini, kama mtumishi huyo atafikiri moyoni mwake: na kusema: Bwana wangu amekawia sana kurudi halafu aanze kuwapiga watumishi wenzake, wa kiume au wa kike, na kula, kunywa na kulewa, ");
INSERT INTO swh1850_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bwana wake atarudi siku asiyoitazamia na saa asiyoijua; atamkatilia mbali na kumweka fungu moja na wasioamini. ");
INSERT INTO swh1850_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mtumishi ambaye anajua matakwa ya bwana wake lakini hajiweki tayari kufanya anavyotakiwa, atapigwa sana. ");
INSERT INTO swh1850_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini yule afanyaye yanayostahili adhabu bila kujua, atapigwa kidogo. Aliyepewa vingi atatakiwa vingi; aliyekabidhiwa vingi zaidi atatakiwa kutoa vingi zaidi. ");
INSERT INTO swh1850_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nimekuja kuwasha moto duniani, laiti ungekuwa umewaka tayari! ");
INSERT INTO swh1850_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ninao ubatizo ambao inanipasa niupokee; jinsi gani ninavyohangaika mpaka ukamilike! ");
INSERT INTO swh1850_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mnadhani nimekuja kuleta amani duniani? Hata kidogo; si amani bali utengano. ");
INSERT INTO swh1850_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na tangu sasa, jamaa ya watu watano itagawanyika; watatu dhidi ya wawili, na wawili dhidi ya watatu. ");
INSERT INTO swh1850_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baba atakuwa dhidi ya mwanawe, mwana dhidi ya baba yake; mama dhidi ya bintiye, binti dhidi ya mama yake; mama mkwe dhidi ya mke wa mwanawe na huyo dhidi ya mama mkwe wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu akayaambia tena makundi ya watu, “Mnapoona mawingu yakitokea upande wa magharibi, mara mwasema: Mvua itanyesha, na kweli hunyesha. ");
INSERT INTO swh1850_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mnapoona upepo wa kusi unavuma, mwasema Kutakuwa na hali ya joto na ndivyo inavyokuwa. ");
INSERT INTO swh1850_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enyi wanafiki! Mnajua kutabiri hali ya hewa kwa kuangalia dunia na anga; kwa nini basi, hamwezi kujua maana ya nyakati hizi? ");
INSERT INTO swh1850_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na kwa nini hamwezi kujiamulia wenyewe jambo jema la kufanya? ");
INSERT INTO swh1850_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maana kama mshtaki wako anakupeleka mahakamani, ingekuwa afadhali kwako kupatana naye mkiwa bado njiani, ili asije akakupeleka mbele ya hakimu, naye hakimu akakutoa kwa polisi, nao wakakutia ndani. ");
INSERT INTO swh1850_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Hakika hutatoka huko nakwambia, mpaka utakapomaliza kulipa senti ya mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wakati huo watu fulani walikuja, wakamweleza Yesu juu ya watu wa Galilaya ambao Pilato alikuwa amewaua wakati walipokuwa wanachinja wanyama wao wa tambiko. ");
INSERT INTO swh1850_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naye Yesu akawaambia, “Mnadhani Wagalilaya hao walikuwa wahalifu zaidi kuliko Wagalilaya wengine, ati kwa sababu wameteseka hivyo? ");
INSERT INTO swh1850_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nawaambieni hakika sivyo; lakini nanyi, hali kadhalika, msipotubu, mtaangamia kama wao. ");
INSERT INTO swh1850_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au wale kumi na wanane walioangukiwa na mnara kule Siloamu wakafa; mnadhani wao walikuwa wakosefu zaidi kuliko wengine wote walioishi Yerusalemu? ");
INSERT INTO swh1850_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nawaambieni sivyo; lakini nanyi msipotubu, mtaangamia kama wao.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kisha, Yesu akawaambia mfano huu: “Mtu mmoja alikuwa na mtini katika shamba lake. Mtu huyu akaenda akitaka kuchuma matunda yake, lakini akaukuta haujazaa hata tunda moja. ");
INSERT INTO swh1850_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Basi, akamwambia mfanyakazi wake: Angalia! Kwa miaka mitatu nimekuwa nikija kuchuma matunda ya mtini huu, nami nisiambulie kitu. Ukate! Kwa nini uitumie ardhi bure? ");
INSERT INTO swh1850_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lakini naye akamjibu: Bwana, tuuache tena mwaka huu; nitauzungushia mtaro na kuutilia mbolea. ");
INSERT INTO swh1850_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kama ukizaa matunda mwaka ujao, vema; la sivyo, basi utaweza kuukata.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu alikuwa akifundisha katika sunagogi moja siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na hapo palikuwa na mwanamke mmoja aliyekuwa mgonjwa kwa miaka kumi na minane kutokana na pepo aliyekuwa amempagaa. Kwa sababu hiyo, mwili wake ulikuwa umepindika vibaya hata asiweze kusimama wima. ");
INSERT INTO swh1850_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu alipomwona, alimwita, akamwambia, “Mama, umeponywa ugonjwa wako.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akamwekea mikono, na mara mwili wake ukawa wima tena, akawa anamtukuza Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini mkuu wa sunagogi alikasirika kwa sababu Yesu alikuwa amemponya siku ya Sabato. Hivyo akawaambia wale watu walikusanyika pale, “Mnazo siku sita za kufanya kazi. Basi, fikeni siku hizo mkaponywe magonjwa yenu; lakini msije siku ya Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hapo Bwana akamjibu, “Enyi wanafiki! Nani kati yenu hangemfungua ng'ombe au punda wake kutoka zizini ampeleke kunywa maji, hata kama siku hiyo ni ya Sabato? ");
INSERT INTO swh1850_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sasa, hapa yupo binti wa Abrahamu ambaye Shetani alimfanya kilema kwa muda wa miaka kumi na minane. Je, haikuwa vizuri kumfungulia vifungo vyake siku ya Sabato?” ");
INSERT INTO swh1850_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Alipokwisha sema hayo, wapinzani wake waliona aibu lakini watu wengine wote wakajaa furaha kwa sababu ya mambo yote aliyotenda. ");
INSERT INTO swh1850_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu akauliza: “Ufalme wa Mungu unafanana na nini? Nitaulinganisha na nini? ");
INSERT INTO swh1850_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","NI kama mbegu ya haradali aliyotwaa mtu mmoja na kuipanda shambani mwake; ikaota hata ikawa mti. Ndege wa angani wakajenga viota vyao katika matawi yake.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tena akauliza: “Nitaulinganisha Ufalme wa Mungu na nini? ");
INSERT INTO swh1850_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ni kama chachu aliyoitwaa mama mmoja na kuichanganya pamoja na unga debe moja kisha unga wote ukaumuka wote.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu alindelea na safari yake kwenda Yerusalemu huku akipitia mijini na vijijini, akihubiri. ");
INSERT INTO swh1850_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mtu mmoja akamwuliza, “Je, Mwalimu, watu watakaookoka ni wachache?” ");
INSERT INTO swh1850_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesu akawaambia, “Jitahidini kuingia kwa kupitia mlango mwembamba; maana nawaambieni, wengi watajaribu kuingia lakini hawataweza. ");
INSERT INTO swh1850_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Wakati utakuja ambapo mwenye nyumba atainuka na kufunga mlango. Ninyi mtasimama nje na kuanza kupiga hodi mkisema: Bwana, tufungulie mlango. Lakini yeye atawajibu: Sijui mmetoka wapi. ");
INSERT INTO swh1850_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nanyi mtaanza kumwambia: Sisi ndio wale tuliokula na kunywa pamoja nawe; na wewe ulifundisha katika vijiji vyetu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini yeye atasema: Sijui ninyi mmetoka wapi; ondokeni mbele yangu, enyi nyote watenda maovu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ndipo mtakuwa na kulia na kusaga meno, wakati mtakapowaona Abrahamu, Isaka na Yakobo, na manabii wote wapo katika Ufalme wa Mungu, lakini ninyi wenyewe mmetupwa nje! ");
INSERT INTO swh1850_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Watu watakuja kutoka mashariki na magharibi, kutoka kaskazini na kusini, watakuja na kukaa kwenye karamu katika Ufalme wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Naam, wale walio wa mwisho watakuwa wa kwanza; na wale walio wa kwanza watakuwa wa mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wakati huohuo, Mafarisayo na watu wengine walimwendea Yesu wakamwambia, “Ondoka hapa uende mahali pengine, kwa maana Herode anataka kukuua.” ");
INSERT INTO swh1850_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akawajibu, “Nendeni mkamwambie huyo mbweha hivi: Leo na kesho ninafukuza pepo na kuponya wagonjwa, na siku ya tatu nitakamilisha kazi yangu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata hivyo, kwa leo, kesho na kesho kutwa, ni lazima niendelee na safari yangu, kwa sababu si sawa nabii auawe nje ya Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalemu! We Yerusalemu! Unawaua manabii na kuwapiga mawe wale waliotumwa kwako! Mara ngapi nimetaka kuwakusanya watoto wako pamoja kama kuku anavyokusanya vifaranga vyake chini ya mabawa yake, Lakini wewe umekataa. ");
INSERT INTO swh1850_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haya, utaachiwa mwenyewe nyumba yako. Naam, hakika nawaambieni, hamtaniona mpaka wakati utakapofika mseme: Abarikiwe huyo ajaye kwa jina la Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Siku moja ya Sabato, Yesu alikwenda kula chakula nyumbani kwa mmoja wa viongozi wa Mafarisayo; watu waliokuwapo hapo wakawa wanamchunguza. ");
INSERT INTO swh1850_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mbele yake Yesu palikuwa na mtu mmoja aliyekuwa na ugonjwa wa kuvimba mwili. ");
INSERT INTO swh1850_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu akawauliza walimu wa Sheria na Mafarisayo, “Je, ni halali au la kumponya mtu siku ya sabato?” ");
INSERT INTO swh1850_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini wao wakakaa kimya. Yesu akamshika huyo mgonjwa, akamponya, akamwacha aende zake. ");
INSERT INTO swh1850_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Halafu akawaambia, “Ni nani kati yenu ambaye mtoto wake au ng'ombe wake akitumbukia shimoni, hangemtoa hata kama ni siku ya Sabato?” ");
INSERT INTO swh1850_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nao hawakuweza kumjibu swali hilo. ");
INSERT INTO swh1850_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu aliona jinsi wale walioalikwa walivyokuwa wanajichagulia nafasi za heshima, akawaambia mfano: ");
INSERT INTO swh1850_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kama mtu akikualika arusini, usiketi mahali pa heshima isije ikawa amealikwa mwingine mheshimiwa kuliko wewe; ");
INSERT INTO swh1850_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na mwenyeji wenu ninyi wawili atakuja na kukwambia: Mwachie huyu nafasi. Hapo utaaibika mbele ya wote na kulazimika kwenda kuchukua nafasi ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bali ukialikwa kwenye karamu, keti mahali pa mwisho, ili mwenyeji wako atakapokuja akwambie: Rafiki, njoo hapa mbele, mahali pazuri zaidi. Hapo utakuwa umeheshimika mbele ya wote wanaoketi pamoja nawe. ");
INSERT INTO swh1850_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwa maana yeyote anayejikweza atashushwa, na anayejishusha, atakwezwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Halafu akamwambia na yule aliyemwalika, “Kama ukiwaandalia watu karamu mchana au jioni, usiwaalike rafiki zako au jamaa zako au jirani zako walio matajiri, wasije nao wakakualika nawe ukawa umelipwa kile ulichowatendea. ");
INSERT INTO swh1850_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Badala yake, unapofanya karamu, waalike maskini, vilema viwete na vipofu, ");
INSERT INTO swh1850_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nawe utakuwa umepata baraka, kwa kuwa hao hawana cha kukulipa. Maana Mungu atakupa tuzo lako wakati watu wema watakapofufuka.” ");
INSERT INTO swh1850_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mmoja wa wale waliokuwa wameketi pamoja na Yesu akasema, “Ana heri mtu yule atakayekula chakula katika Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu akamjibu, “Mtu mmoja alifanya karamu kubwa, akaalika watu wengi. ");
INSERT INTO swh1850_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakati wa karamu ulipofika alimtuma mtumishi wake awaambie walioalikwa, Njoni, kila kitu ni tayari. ");
INSERT INTO swh1850_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakini wote, kwa namna moja, wakaanza kuomba radhi. Wa kwanza akamwambia mtumishi: Nimenunua shamba, kwa hiyo sina budi kwenda kuliangalia; nakuomba uniwie radhi. ");
INSERT INTO swh1850_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mwingine akasema: Nimenunua ng'ombe jozi tano wa kulima; sasa nimo njiani kwenda kuwajaribu; nakuomba uniwie radhi. ");
INSERT INTO swh1850_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na mwingine akasema: Nimeoa mke, kwa hiyo siwezi kuja. ");
INSERT INTO swh1850_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mtumishi huyo akarudi na kumwarifu bwana wake jambo hilo. Yule mwenye nyumba alikasirika, akamwambia mtumishi wake: Nenda upesi kwenye barabara na vichochoro vya mji, uwalete hapa ndani maskini, viwete, vipofu na waliolemaa. ");
INSERT INTO swh1850_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Baadaye, mtumishi huyo akasema: Bwana mambo yamefanyika kama ulivyoamuru, lakini bado iko nafasi. ");
INSERT INTO swh1850_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yule bwana akamwambia mtumishi: Nenda katika barabara na vichochoro vya mji uwashurutishe watu kuingia ili nyumba yangu ijae. ");
INSERT INTO swh1850_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwa maana, nawaambieni, hakuna hata mmoja wa wale walioalikwa atakayeonja karamu yangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hapo, makundi mengi yakawa yanaandamana pamoja na Yesu. Basi, akawageukia akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mtu yeyote akija kwangu, asipowachukia baba na mama yake, mke wake, watoto, ndugu na dada zake, naam, hata na nafsi yake mwenyewe, hawezi kuwa mwanafunzi wangu. ");
INSERT INTO swh1850_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mtu asipochukua msalaba wake na kunifuata hawezi kuwa mwanafunzi wangu. ");
INSERT INTO swh1850_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kwa maana, ni nani miongoni mwenu ambaye akitaka kujenga mnara hataketi kwanza akadirie gharama zake ili ajue kama ana kiasi cha kutosha cha kumalizia? ");
INSERT INTO swh1850_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","La sivyo, baada ya kuweka msingi na kushindwa kumaliza, watu watamcheka ");
INSERT INTO swh1850_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wakisema: Mtu huyu alianza kujenga, lakini hakumalizia. ");
INSERT INTO swh1850_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Au, ni mfalme gani ambaye, akitaka kwenda kupigana na mfalme mwingine, hataketi kwanza chini na kufikiri kama ataweza, kwa askari wake elfu ishirini? ");
INSERT INTO swh1850_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kama anaona hataweza, atawatuma wajumbe kutaka masharti ya amani wakati mfalme huyo mwingine angali mbali. ");
INSERT INTO swh1850_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Vivyo hivyo, basi, hakuna hata mmoja wenu atakayekuwa mwanafunzi wangu kama asipoachilia kila kitu alicho nacho. ");
INSERT INTO swh1850_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Chumvi ni nzuri; lakini ikipoteza ladha yake, itakolezwa na nini? ");
INSERT INTO swh1850_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haifai kitu wala kwa udongo wala kwa mbolea. Watu huitupilia mbali. Sikieni basi, kama mna masikio!” ");
INSERT INTO swh1850_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Siku moja, watoza ushuru na wahalifu wengi walikwenda kumsikiliza Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafarisayo na walimu wa Sheria wakaanza kunung'unika: “Mtazameni mtu huyu! Anawakaribisha wenye dhambi, na tena anakula nao.” ");
INSERT INTO swh1850_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu akawajibu kwa mfano: ");
INSERT INTO swh1850_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hivi, mtu akiwa na kondoo mia, akigundua kwamba mmoja wao amepotea, atafanya nini? Atawaacha wale tisini na tisa mbugani, na kwenda kumtafuta yule aliyepotea mpaka ampate. ");
INSERT INTO swh1850_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Akimpata, atambeba mabegani kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Anapofika nyumbani, atawaita rafiki zake akiwaambia, Furahini pamoja nami, kwa sababu nimempata yule kondoo wangu aliyepotea. ");
INSERT INTO swh1850_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kadhalika nawaambieni, ndivyo kutakavyokuwa na furaha mbinguni kwa ajili ya kutubu kwa mwenye dhambi mmoja, kuliko kwa ajili ya watu tisini na tisa wanaojiona kuwa wema, wasiohitaji kutubu. ");
INSERT INTO swh1850_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Au mwaonaje? Tuseme mwanamke fulani ana sarafu kumi za fedha, akipoteza moja, atafanya nini? Atawasha taa, aifagie nyumba na kuitafuta kwa uangalifu mpaka aipate. ");
INSERT INTO swh1850_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akiipata, atawaita rafiki na jirani zake akisema, Furahini pamoja nami, kwa sababu nimeipata ile sarafu yangu iliyopotea. ");
INSERT INTO swh1850_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kadhalika nawaambieni, ndivyo watakavyofurahi malaika wa Mungu kwa sababu ya mwenye dhambi mmoja anayetubu.” ");
INSERT INTO swh1850_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu akaendelea kusema, “Kulikuwa na mtu mmoja mwenye wana wawili. ");
INSERT INTO swh1850_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yule mdogo, alimwambia baba yake: Baba, nipe urithi wangu. Naye akawagawia mali yake. ");
INSERT INTO swh1850_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Baada ya siku chache, yule mdogo aliuza urithi wake, akasafiri na fedha aliyopata, akaenda nchi ya mbali ambako aliitumia ovyo. ");
INSERT INTO swh1850_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Alipomaliza kutumia kila kitu, kukatokea njaa kali katika nchi ile, naye akaanza kuhangaika. ");
INSERT INTO swh1850_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akaomba kazi kwa mwananchi mtu mmoja wa huko naye akampeleka shambani mwake kulisha nguruwe. ");
INSERT INTO swh1850_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Alitamani kula maganda waliyokula wale nguruwe, ila hakuna mtu aliyempa kitu. ");
INSERT INTO swh1850_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Alipoanza kupata akili akafikiri: Mbona kuna wafanyakazi wengi wa baba yangu wanaokula na kusaza, nami ninakufa njaa? ");
INSERT INTO swh1850_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nitarudi kwa baba yangu na kumwambia: Baba, nimemkosea Mungu, na nimekukosea wewe pia. ");
INSERT INTO swh1850_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sistahili hata kuitwa mwanao. Nifanye kama mmoja wa wafanyakazi wako. ");
INSERT INTO swh1850_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Basi, akaanza safari ya kurudi kwa baba yake. Alipokuwa bado yu mbali, baba yake alimwona, na kwa moyo wa huruma alimkimbilia, akamkumbatia na kumbusu. ");
INSERT INTO swh1850_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mwanawe akamwambia: Baba, nimemkosea Mungu, na nimekukosea wewe pia. Sistahili hata kuitwa mwanao. ");
INSERT INTO swh1850_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lakini baba yake akawaambia watumishi wake: Haraka! Leteni nguo nzuri mkamvike! Mvisheni pete na viatu! ");
INSERT INTO swh1850_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mchinjeni ndama mnono; tule kusherehekea! ");
INSERT INTO swh1850_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa sababu huyu mwanangu alikuwa amekufa, kumbe yu mzima alikuwa amepotea, lakini sasa amepatikana. Wakaanza kufanya sherehe. ");
INSERT INTO swh1850_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wakati huo kaka yake alikuwa bado shambani. Alipokuwa akirudi na kukaribia nyumbani akasikia vifijo na ngoma. ");
INSERT INTO swh1850_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akamwita mmoja wa watumishi, akamwuliza: Kuna nini? ");
INSERT INTO swh1850_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Huyo mtumishi akamwambia: Ndugu yako amerudi nyumbani, na baba yako amemchinjia ndama mnono kwa kuwa amempata akiwa salama salimini. ");
INSERT INTO swh1850_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Huyo kijana mkubwa akawaka hasira hata akakataa kuingia nyumbani. Baba yake akatoka nje na kumsihi aingie. ");
INSERT INTO swh1850_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lakini yeye akamjibu: Kumbuka! Miaka yote nimekutumikia, sijavunja amri yako hata mara moja. Umenipa nini? Hujanipa hata mwana mbuzi mmoja nikafanye sherehe pamoja na rafiki zangu! ");
INSERT INTO swh1850_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini mtoto wako huyu aliyekula mali yako pamoja na makahaba, mara tu alipokuja umemchinjia yule ndama mnono. ");
INSERT INTO swh1850_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baba yake akamjibu: Mwanangu, wewe uko pamoja nami siku zote, na kila nilicho nacho ni chako. ");
INSERT INTO swh1850_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ilitubidi kufanya sherehe na kufurahi, kwa sababu huyu ndugu yako alikuwa amekufa, kumbe yu mzima; alikuwa amepotea, lakini sasa amepatikana.” ");
INSERT INTO swh1850_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu aliwaambia wanafunzi wake: “Tajiri mmoja alikuwa na karani wake. Huyu karani alichongewa kwamba alitumia ovyo mali ya tajiri wake. ");
INSERT INTO swh1850_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yule tajiri akamwita akamwambia: Ni mambo gani haya ninayosikia juu yako? Toa hesabu ya mapato na matumizi ya mali yangu, kwa maana huwezi kuwa karani tena. ");
INSERT INTO swh1850_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yule karani akafikiri: Bwana wangu amenifukuza kazi ya ukarani; nitafanya nini? Kwenda kulima siwezi; kwenda kuombaomba kama maskini ni aibu. ");
INSERT INTO swh1850_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naam, najua la kufanya, ili nitakapofukuzwa kazi, watu waweze kunikaribisha nyumbani kwao. ");
INSERT INTO swh1850_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Basi, akawaita wadeni wa bwana wake, mmoja mmoja, akamwambia yule wa kwanza: Unadaiwa kiasi gani na bwana wangu? ");
INSERT INTO swh1850_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yeye akamjibu: Mapipa mia ya mafuta ya zeituni. Yule karani akamwambia: Chukua hati yako ya deni, keti haraka, andika hamsini. ");
INSERT INTO swh1850_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kisha akamwuliza mdeni mwingine: Wewe unadaiwa kiasi gani? Yeye akamjibu: Magunia mia ya ngano. Yule karani akamwambia: Chukua hati yako ya deni, andika themanini. ");
INSERT INTO swh1850_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Basi, yule bwana akamsifu huyo karani asiye mwaminifu, kwa kuwa alitumia busara. Kwa maana watu wa dunia hii wana busara zaidi na mambo yao kuliko watu wa mwanga.” ");
INSERT INTO swh1850_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Naye Yesu akaendelea kusema, “Nami nawaambieni, jifanyieni marafiki kutokana na mali ya dunia, ili zitakapowaishieni, mweze kupokewa nao katika makao ya milele. ");
INSERT INTO swh1850_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yeyote aliye mwaminifu katika mambo madogo, atakuwa mwaminifu katika mambo makubwa; na yeyote asiye mwaminifu katika mambo madogo, hatakuwa mwaminifu katika mambo makubwa. ");
INSERT INTO swh1850_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kama basi, ninyi si hamjawa waaminifu mali mbaya za dunia, ni nani atakayewakabidhi zile mali za kweli? ");
INSERT INTO swh1850_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kama hamjakuwa waaminifu katika mali ya mtu mwingine, ni nani atakayewakabidhi mali yenu wenyewe? ");
INSERT INTO swh1850_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Hakuna mtumishi awezaye kuwatumikia mabwana wawili; kwa maana atamchukia mmoja na kumpenda mwingine, au ataambatana na mmoja na kumdharau mwingine. Hamwezi kumtumikia Mungu na mali.” ");
INSERT INTO swh1850_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lakini Mafarisayo waliposikia hayo, kwa vile wao walikuwa wanapenda sana fedha, wakamdharau Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hapo akawaambia, “Ninyi mnajifanya wema mbele ya watu, lakini Mungu anaijua mioyo yenu. Kwa maana kile kinachoonekana kuwa kitukufu mbele ya watu, Mungu anakiona kuwa takataka. ");
INSERT INTO swh1850_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sheria na maandishi ya manabii vilikuweko mpaka wakati wa Yohane mbatizaji. Tangu hapo, Ufalme wa Mungu unahubiriwa, na kila mmoja anauingia kwa nguvu. ");
INSERT INTO swh1850_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini ni rahisi zaidi mbingu na dunia kupita, kuliko hata herufi moja ya Sheria kufutwa. ");
INSERT INTO swh1850_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yeyote anayemwacha mke wake na kuoa mwingine, anazini; na yeyote anayemwoa mwanamke aliyepewa talaka, anazini. ");
INSERT INTO swh1850_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Palikuwa na mtu mmoja tajiri, ambaye alikuwa anavaa mavazi ya bei kubwa sana ya rangi ya zambarau, na ya kitani safi, na kufanya sherehe kila siku. ");
INSERT INTO swh1850_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kulikuwa pia na maskini mmoja jina lake Lazaro, aliyekuwa amejaa vidonda na alikuwa analazwa mlangoni pa nyumba ya huyo tajiri. ");
INSERT INTO swh1850_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazaro alitamani kula makombo yaliyoanguka kutoka meza ya tajiri; na zaidi ya hayo, mbwa walikuwa wanakuja na kulamba vidonda vyake! ");
INSERT INTO swh1850_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ikatokea kwamba huyo maskini akafa, malaika wakamchukua, wakamweka karibu na Abrahamu. Na yule tajiri pia akafa, akazikwa. ");
INSERT INTO swh1850_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Huyo tajiri, alikuwa na mateso makali huko kuzimu, akainua macho yake, akamwona Abrahamu kwa mbali na Lazaro karibu naye. ");
INSERT INTO swh1850_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Basi, akaita kwa sauti: Baba Abrahamu, nionee huruma; umtume Lazaro angalau achovye ncha ya kidole chake katika maji, auburudishe ulimi wangu, maana ninateseka mno katika moto huu. ");
INSERT INTO swh1850_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lakini Abrahamu akamjibu: Kumbuka mwanangu, kwamba ulipokea mema yako katika maisha, naye Lazaro akapokea mabaya. Sasa lakini, yeye anatulizwa, nawe unateswa. ");
INSERT INTO swh1850_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Licha ya hayo, kati yetu na ninyi kumewekwa shimo kubwa, ili wanaotaka kuja kwenu kutoka huku wasiweze, wala wanaotaka kutoka kwenu kuja kwetu wasiweze. ");
INSERT INTO swh1850_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Huyo aliyekuwa tajiri akasema: Basi baba, nakuomba umtume aende nyumbani kwa baba yangu, ");
INSERT INTO swh1850_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","maana ninao ndugu watano, ili awaonye wasije wakaja huku kwenye mateso. ");
INSERT INTO swh1850_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lakini Abrahamu akamwambia: Ndugu zako wanao Mose na manabii; waache wawasikilize hao. ");
INSERT INTO swh1850_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lakini yeye akasema: Sivyo baba Abrahamu, ila kama mtu atafufuka kutoka wafu na kuwaendea, watatubu. ");
INSERT INTO swh1850_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naye Abrahamu akasema: Kama hawawasikilizi Mose na manabii, hawatajali hata kama mtu angefufuka kutoka wafu.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kisha, Yesu akawaambia wanafunzi wake, “Haiwezekani kabisa kusitokee vikwazo vinavyosababisha dhambi; lakini ole wake mtu yule atakayevisababisha. ");
INSERT INTO swh1850_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ingekuwa afadhali kwake kufungiwa shingoni jiwe kubwa la kusagia na kutoswa baharini, kuliko kumkwaza mmoja wa wadogo hawa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jihadharini! Kama ndugu yako akikukosea, mwonye; akitubu, msamehe. ");
INSERT INTO swh1850_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na kama akikukosea mara saba kwa siku, na kila mara akarudi kwako akisema Nimetubu, lazima umsamehe.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mitume wakamwambia Bwana, “Utuongezee imani.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naye Bwana akajibu, “Kama imani yenu ingekuwa ndogo hata kama chembe ndogo ya haradali, mngeweza kuuambia mti huu wa mkuyu: Ng'oka ukajipandikize baharini, nao ungewatii. ");
INSERT INTO swh1850_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tuseme mmoja wenu ana mtumishi ambaye analima shambani au anachunga kondoo. Je, anaporudi kutoka shambani, atamwambia: Haraka, njoo ule chakula? ");
INSERT INTO swh1850_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","La! Atamwambia: Nitayarishie chakula, ujifunge tayari kunitumikia mpaka nitakapomaliza kula na kunywa, ndipo nawe ule na unywe. ");
INSERT INTO swh1850_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Je utamshukuru huyo mtumishi kwa sababu ametimiza aliyoamriwa? ");
INSERT INTO swh1850_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hali kadhalika na ninyi mkisha fanya yote mliyoamriwa, semeni: Sisi ni watumishi tusio na faida, tumetimiza tu yale tuliyotakiwa kufanya.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu akiwa safarini kwenda Yerusalemu alipitia mipakani mwa Samaria na Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Alipokuwa anaingia katika kijiji kimoja, watu kumi wenye ukoma walikutana naye, wakasimama kwa mbali. ");
INSERT INTO swh1850_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wakapaza sauti wakisema, “Yesu Mwalimu, tuonee huruma!” ");
INSERT INTO swh1850_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Alipowaona akawaambia, “Nendeni mkajionyeshe kwa makuhani.” Basi, ikawa walipokuwa wanakwenda, wakatakasika. ");
INSERT INTO swh1850_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmoja wao alipoona kwamba ameponywa alirudi akimtukuza Mungu kwa sauti kubwa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akajitupa chini mbele ya miguu ya Yesu huku akimshukuru. Huyo alikuwa Msamaria. ");
INSERT INTO swh1850_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hapo Yesu akasema, “Je, si watu kumi walitakaswa? Wale tisa wako wapi? ");
INSERT INTO swh1850_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hakupatikana mwingine aliyerudi kumtukuza Mungu ila tu huyu mgeni?” ");
INSERT INTO swh1850_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Halafu akamwambia huyo mtu, “Simama, uende zako; imani yako imekuponya.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wakati mmoja, Mafarisayo walimwuliza Yesu, “Ufalme wa Mungu utakuja lini?” Naye akawajibu, “Ufalme wa Mungu hauji kwa namna itakayoweza kuonekana. ");
INSERT INTO swh1850_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala hakuna atakayeweza kusema, Uko hapa, au Uko pale. Kwa kweli Ufalme wa Mungu uko kati yenu.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Halafu akawaambia wanafunzi wake, “Siku zinakuja ambapo mtatamani kuona mojawapo ya siku za Mwana wa Mtu, lakini hamtaiona. ");
INSERT INTO swh1850_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na watu watawaambieni: Tazameni yuko hapa; ninyi msitoke wala msiwafuate. ");
INSERT INTO swh1850_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwa maana kama vile umeme unavyotokea ghafla na kuangaza anga upande mmoja hadi mwingine, ndivyo Mwana wa Mtu atakavyokuwa siku yake. ");
INSERT INTO swh1850_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini kabla ya hayo, itambidi ateseke sana na kukataliwa na kizazi hiki. ");
INSERT INTO swh1850_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kama ilivyokuwa nyakati za Noa, ndivyo itakavyokuwa katika siku za Mwana wa Mtu. ");
INSERT INTO swh1850_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Watu waliendelea kula na kunywa, kuoa na kuolewa mpaka wakati ule Noa alipoingia katika safina. Gharika ikatokea na kuwaangamiza wote. ");
INSERT INTO swh1850_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Itakuwa kama ilivyotokea wakati wa Loti. Watu waliendelea kula na kunywa, kununua na kuuza, kupanda mbegu na kujenga. ");
INSERT INTO swh1850_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini siku ile Loti alipoondoka Sodoma, moto na kiberiti vikanyesha kama mvua kutoka mbinguni na kuwaangamiza wote. ");
INSERT INTO swh1850_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndivyo itakavyokuwa siku ile Mwana wa Mtu atakapofunuliwa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Siku hiyo, yeyote atakayekuwa juu ya paa asishuke nyumbani kuchukua mali yake. Kadhalika, naye atakayekuwa shambani asirudi nyuma. ");
INSERT INTO swh1850_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukeni yaliyompata mke wa Loti. ");
INSERT INTO swh1850_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yeyote anayetaka kuiokoa nafsi yake, ataipoteza; na yeyote anayeipoteza, ataiokoa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nawaambieni, siku ile usiku watu wawili watakuwa wanalala pamoja, mmoja atachukuliwa na yule mwingine ataachwa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wanawake wawili watakuwa wakisaga nafaka pamoja; mmoja atachukuliwa na mwingine ataachwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Watu wawili watakuwa shambani; mmoja atachukuliwa na mwingine ataachwa. ");
INSERT INTO swh1850_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hapo wakamwuliza, “Ni wapi Bwana?” Naye akawaambia, “Ulipo mzoga, ndipo tai watakapokusanyikia.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Basi, Yesu aliwasimulia mfano kuonyesha kwamba ni lazima kusali daima bila kukata tamaa. ");
INSERT INTO swh1850_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Alisema: “Katika mji mmoja kulikuwa na hakimu ambaye hakuwa anamcha Mungu wala kumjali binadamu. ");
INSERT INTO swh1850_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Katika mji huohuo, kulikuwa pia na mama mmoja mjane, ambaye alimwendea huyo hakimu mara nyingi akimwomba amtetee apate haki yake kutoka kwa adui yake. ");
INSERT INTO swh1850_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa muda mrefu huyo hakimu hakupenda kumtetea huyo mjane; lakini, mwishowe akajisemea: Ingawa mimi simchi Mungu wala simjali binadamu, ");
INSERT INTO swh1850_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kwa vile huyu mjane ananisumbua, nitamtetea; la sivyo ataendelea kufika hapa, na mwisho atanichosha kabisa!” ");
INSERT INTO swh1850_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Basi, Bwana akaendelea kusema, “Sikieni jinsi alivyosema huyo hakimu mbaya. ");
INSERT INTO swh1850_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Je, ndio kusema Mungu hatawatetea wale aliowachagua, ambao wanamlilia mchana na usiku? Je, atakawia kuwasikiliza? ");
INSERT INTO swh1850_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nawaambieni atawatetea upesi. Hata hivyo, je, kutakuwako na imani duniani wakati Mwana wa Mtu atakapokuja?” ");
INSERT INTO swh1850_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Halafu Yesu aliwaambia pia mfano wa wale ambao walijiona kuwa wema na kuwadharau wengine. ");
INSERT INTO swh1850_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Watu wawili walipanda kwenda Hekaluni kusali: mmoja Mfarisayo, na mwingine mtoza ushuru. ");
INSERT INTO swh1850_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Huyo Mfarisayo akasimama, akasali kimoyomoyo: Ee Mungu, nakushukuru kwa vile mimi si kama watu wengine: walafi, wadanganyifu au wazinzi. Nakushukuru kwamba mimi si kama huyu mtoza ushuru. ");
INSERT INTO swh1850_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nafunga mara mbili kwa juma, natoa zaka sehemu ya kumi ya pato langu. ");
INSERT INTO swh1850_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini yule mtoza ushuru, akiwa amesimama kwa mbali bila hata kuinua macho yake mbinguni, ila tu akijipiga kifua kwa huzuni, alisema: Ee Mungu, unionee huruma mimi mwenye dhambi. ");
INSERT INTO swh1850_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nawaambieni, huyu mtoza ushuru alirudi nyumbani akiwa amesamehewa. Lakini yule mwingine, sivyo. Kwa maana kila anayejikweza atashushwa, na kila anayejishusha atakwezwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Watu walimletea Yesu watoto wadogo ili awawekee mikono yake. Wanafunzi walipowaona, wakawazuia kwa maneno makali. ");
INSERT INTO swh1850_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu akawaita kwake akisema: “Waacheni hao watoto waje kwangu, wala msiwazuie, kwa maana Ufalme wa Mungu ni kwa ajili ya watu kama hawa. ");
INSERT INTO swh1850_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nawaambieni kweli, mtu yeyote asiyeupokea Ufalme wa Mungu kama mtoto mdogo, hataingia katika Ufalme huo.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kiongozi mmoja, Myahudi, alimwuliza Yesu, “Mwalimu mwema, nifanye nini ili niweze kuupata uzima wa milele?” ");
INSERT INTO swh1850_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akamwambia, “Mbona waniita mwema? Hakuna aliye mwema ila Mungu peke yake. ");
INSERT INTO swh1850_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Unazijua amri: Usizini; usiue; usiibe; usitoe ushahidi wa uongo; waheshimu baba yako na mama yako.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yeye akasema, “Hayo yote nimeyazingatia tangu ujana wangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu aliposikia hayo akamwambia, “Unatakiwa bado kufanya kitu kimoja: uza kila ulicho nacho, wagawie maskini, na hivyo utakuwa na hazina yako mbinguni; halafu njoo unifuate.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini huyo mtu aliposikia hayo, alihuzunika sana kwa sababu alikuwa tajiri sana. ");
INSERT INTO swh1850_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu alipoona akihuzunika hivyo, akasema, “Jinsi gani ilivyo vigumu kwa matajiri kuingia katika Ufalme wa Mungu! ");
INSERT INTO swh1850_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Naam, ni rahisi zaidi kwa ngamia kupita katika tundu la sindano, kuliko tajiri kuingia katika Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wale watu waliposikia hayo, wakasema, “Nani basi, atakayeokolewa?” ");
INSERT INTO swh1850_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu akajibu, “Yasiyowezekana kwa binadamu, yanawezekana kwa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naye Petro akamwuliza, “Na sisi je? Tumeacha vitu vyote tukakufuata!” ");
INSERT INTO swh1850_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu akawaambia, “Kweli nawaambieni, mtu yeyote aliyeacha nyumba au mke au kaka au wazazi au watoto kwa ajili ya Ufalme wa Mungu, ");
INSERT INTO swh1850_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","atapokea mengi zaidi wakati huu wa sasa, na kupokea uzima wa milele wakati ujao.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu aliwachukua kando wale kumi na wawili, akawaambia, “Sikilizeni! Tunakwenda Yerusalemu na huko kila kitu kilichoandikwa na manabii kuhusu Mwana wa Mtu kitakamilishwa. ");
INSERT INTO swh1850_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwa maana atakabidhiwa kwa watu wa mataifa nao watamtendea vibaya na kumtemea mate. ");
INSERT INTO swh1850_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Watampiga mijeledi, watamuua; lakini siku ya tatu atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lakini wao hawakuelewa hata kidogo jambo hilo; walikuwa wamefichwa maana ya maneno hayo, na hawakutambua yaliyosemwa. ");
INSERT INTO swh1850_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wakati Yesu alipokaribia Yeriko, kulikuwa na mtu mmoja kipofu ameketi njiani akiomba. ");
INSERT INTO swh1850_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aliposikia umati wa watu ukipita aliuliza, “Kuna nini?” ");
INSERT INTO swh1850_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wakamwambia, “Yesu wa Nazareti anapita.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naye akapaza sauti akisema, “Yesu, Mwana wa Daudi, nihurumie!” ");
INSERT INTO swh1850_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wale watu waliotangulia wakamkemea wakimwambia anyamaze; lakini yeye akazidi kupaza sauti: “Mwana wa Daudi, nihurumie;” ");
INSERT INTO swh1850_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu alisimama, akaamuru wamlete mbele yake. Yule kipofu alipofika karibu, Yesu akamwuliza, ");
INSERT INTO swh1850_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Unataka nikufanyie nini?” Naye akamjibu, “Bwana, naomba nipate kuona tena.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu akamwambia, “Ona! Imani yako imekuponya.” ");
INSERT INTO swh1850_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na mara yule aliyekuwa kipofu akapata kuona, akamfuata Yesu akimtukuza Mungu. Watu wote walipoona hayo, wakamsifu Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu aliingia mjini Yeriko, akawa anapita katika njia za mji huo. ");
INSERT INTO swh1850_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kulikuwa na mtu mmoja mjini, jina lake Zakayo ambaye alikuwa mkuu wa watoza ushuru tena mtu tajiri. ");
INSERT INTO swh1850_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Alitaka kuona Yesu alikuwa nani, lakini kwa sababu ya umati wa watu, na kwa vile alikuwa mfupi, hakufaulu. ");
INSERT INTO swh1850_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hivyo, alitangulia mbio, akapanda juu ya mkuyu ili aweze kumwona Yesu, kwa maana alikuwa apitie hapo. ");
INSERT INTO swh1850_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Basi, Yesu alipofika mahali pale, aliangalia juu akamwambia, “Zakayo, shuka upesi, maana leo ni lazima nishinde nyumbani mwako.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo akashuka haraka, akamkaribisha kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Watu wote walipoona hayo, wakaanza kunung'unika wakisema, “Amekwenda kukaa kwa mtu mwenye dhambi.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lakini Zakayo akasimama akamwambia Yesu, “Sikiliza Bwana! Mimi nitawapa maskini nusu ya mali yangu, na kama nimenyang'anya mtu yeyote kitu, nitamrudishia mara nne.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu akamwambia, “Leo wokovu umefika katika nyumba hii, kwa vile huyu pia ni wa ukoo wa Abrahamu. ");
INSERT INTO swh1850_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa maana Mwana wa Mtu amekuja kutafuta na kuokoa waliopotea.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wakati watu walipokuwa bado wanasikiliza hayo, Yesu akawaambia mfano. (Hapo alikuwa anakaribia Yerusalemu, na watu wale walidhani kwamba muda si muda, Ufalme wa Mungu ungefika.) ");
INSERT INTO swh1850_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hivyo akawaambia, “Kulikuwa na mtu mmoja wa ukoo wa kifalme aliyefanya safari kwenda nchi ya mbali ili apokee madaraka ya ufalme, halafu arudi. ");
INSERT INTO swh1850_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Basi, kabla ya kuondoka aliwaita watumishi wake kumi, akawapa kiasi cha fedha kila mmoja na kumwambia: Fanyeni nazo biashara mpaka nitakaporudi. ");
INSERT INTO swh1850_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini wananchi wenzake walimchukia na hivyo wakatuma wajumbe waende wakaseme: Hatumtaki huyu atutawale. ");
INSERT INTO swh1850_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Huyo mtu mashuhuri alirudi nyumbani baada ya kufanywa mfalme, na mara akaamuru wale watumishi aliowapa zile fedha waitwe ili aweze kujua kila mmoja amepata faida gani. ");
INSERT INTO swh1850_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mtumishi wa kwanza akatokea, akasema: Mheshimiwa, faida iliyopatikana ni mara kumi ya zile fedha ulizonipa. ");
INSERT INTO swh1850_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naye akamwambia: Vema; wewe ni mtumishi mwema. Kwa kuwa umekuwa mwaminifu katika jambo dogo, utakuwa na madaraka juu ya miji kumi! ");
INSERT INTO swh1850_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mtumishi wa pili akaja, akasema: Mheshimiwa, faida iliyopatikana ni mara tano ya zile fedha ulizonipa. ");
INSERT INTO swh1850_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naye akamwambia pia: Nawe utakuwa na madaraka juu ya miji mitano. ");
INSERT INTO swh1850_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mtumishi mwingine akaja, akasema: Chukua fedha yako; niliificha salama katika kitambaa, ");
INSERT INTO swh1850_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kwa maana niliogopa kwa sababu wewe ni mtu mkali. Wewe ni mtu ambaye huchukua yasiyo yako, na huchuma ambacho hukupanda. ");
INSERT INTO swh1850_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naye akamwambia: Nakuhukumu kutokana na msemo wako, ewe mtumishi mbaya! Ulijua kwamba mimi ni mtu mkali, ambaye huchukua yasiyo yangu na kuchuma nisichopanda. ");
INSERT INTO swh1850_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kwa nini basi, hukuiweka fedha yangu benki, nami ningeichukua pamoja na faida baada ya kurudi kwangu? ");
INSERT INTO swh1850_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hapo akawaambia wale waliokuwa pale: Mnyang'anyeni hizo fedha, mkampe yule aliyepata faida mara kumi. ");
INSERT INTO swh1850_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nao wakamwambia: Lakini Mheshimiwa, huyo ana faida ya kiasi hicho mara kumi! ");
INSERT INTO swh1850_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naye akawajibu: Kila aliye na kitu atapewa na kuzidishiwa. Lakini yule asiye na kitu, hata kile alicho nacho kitachukuliwa. ");
INSERT INTO swh1850_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na sasa, kuhusu hao maadui wangu ambao hawapendi niwe mfalme wao, waleteni hapa, mkawaue papa hapa mbele yangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu alisema hayo, kisha akatangulia mbele yao kuelekea Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Alipokaribia kufika Bethfage na Bethania, karibu na mlima wa Mizeituni, aliwatuma wanafunzi wake wawili, ");
INSERT INTO swh1850_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akawaambia: “Nendeni katika kijiji kilicho mbele yenu. Mtakapokuwa mnaingia kijijini, mtamkuta mwana punda amefungwa ambaye hajatumiwa na mtu. Mfungeni, mkamlete hapa. ");
INSERT INTO swh1850_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kama mtu akiwauliza, kwa nini mnamfungua, mwambieni, Bwana ana haja naye.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Basi, wakaenda, wakakuta sawa kama alivyowaambia. ");
INSERT INTO swh1850_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Walipokuwa wanamfungua yule mwana punda, wenyewe wakawauliza, “Kwa nini mnamfungua mwana punda huyu?” ");
INSERT INTO swh1850_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nao wakawajibu, “Bwana anamhitaji.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Basi, wakampelekea Yesu yule mwana punda. Kisha wakatandika mavazi yao juu yake wakampandisha Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu akaendelea na safari, na watu wakatandaza mavazi yao barabarani. ");
INSERT INTO swh1850_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Alipofika karibu na Yerusalemu, katika mteremko wa mlima wa Mizeituni, umati wote na wanafunzi wake, wakaanza kushangilia na kumtukuza Mungu kwa sauti kubwa, kwa sababu ya mambo makuu waliyoyaona; ");
INSERT INTO swh1850_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","wakawa wanasema: “Abarikiwe Mfalme ajaye kwa jina la Bwana. Amani mbinguni, na utukufu juu mbinguni!” ");
INSERT INTO swh1850_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hapo baadhi ya Mafarisayo waliokuwako katika lile kundi la watu, wakamwambia Yesu, “Mwalimu, wanyamazishe wanafunzi wako!” ");
INSERT INTO swh1850_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akawajibu, “Nawaambieni, kama hawa wakinyamaza, hakika hayo mawe yatapaza sauti.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Alipokaribia zaidi na kuuona ule mji, Yesu aliulilia ");
INSERT INTO swh1850_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akisema: “Laiti ungelijua leo hii yale yaletayo amani! Lakini sasa yamefichika machoni pako. ");
INSERT INTO swh1850_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maana siku zaja ambapo adui zako watakuzungushia maboma, watakuzingira na kukusonga pande zote. ");
INSERT INTO swh1850_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Watakupondaponda wewe pamoja na watoto wako ndani ya kuta zako; hawatakuachia hata jiwe moja juu jingine, kwa sababu hukuutambua wakati Mungu alipokujia kukuokoa.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kisha, Yesu aliingia Hekaluni, akaanza kuwafukuzia nje wafanyabiashara ");
INSERT INTO swh1850_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akisema, “Imeandikwa: Nyumba yangu itakuwa nyumba ya sala; lakini ninyi mmeifanya kuwa pango la wanyang'anyi.” ");
INSERT INTO swh1850_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu akawa anafundisha kila siku Hekaluni. Makuhani wakuu, walimu wa Sheria na viongozi wa watu walitaka kumwangamiza, ");
INSERT INTO swh1850_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lakini hawakuwa na la kufanya, maana watu wote walikuwa wakimsikiliza kwa makini kabisa. ");
INSERT INTO swh1850_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Siku moja, Yesu alipokuwa akiwafundisha watu Hekaluni na kuwahubiria juu ya Habari Njema, makuhani wakuu na walimu wa Sheria pamoja na wazee walifika, ");
INSERT INTO swh1850_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wakasema, “Tuambie! Unafanya mambo haya kwa mamlaka gani?” ");
INSERT INTO swh1850_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu akawaambia, “Na mimi nitawaulizeni swali: ");
INSERT INTO swh1850_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mamlaka ya Yohane ya kubatiza yalitoka kwa Mungu au kwa watu?” ");
INSERT INTO swh1850_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini wao wakajadiliana hivi: “Tukisema yalitoka mbinguni, yeye atatuuliza: Mbona hamkumsadiki? ");
INSERT INTO swh1850_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tukisema yalitoka kwa binadamu, watu wote hapa watatupiga mawe, maana wote wanaamini kwamba Yohane alikuwa nabii.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Basi, wakamwambia, “Hatujui mamlaka hayo yalitoka wapi.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu akawaambia, “Hata mimi sitawaambia ninafanya mambo haya kwa mamlaka gani.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu akaendelea kuwaambia watu mfano huu: “Mtu mmoja alilima shamba la mizabibu, akalikodisha kwa wakulima; kisha akasafiri hadi nchi ya mbali, akakaa huko kwa muda mrefu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wakati wa mavuno, mtu huyo alimtuma mtumishi wake kwa wale wakulima, akachukue sehemu ya matunda ya shamba la mizabibu. Lakini wale wakulima wakampiga mtumishi huyo wakamrudisha mikono mitupu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yule bwana akamtuma tena mtumishi mwingine; lakini wao wakampiga huyo vilevile na kumtendea vibaya, wakamrudisha mikono mitupu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akamtuma tena wa tatu; huyu naye, baada ya kumwumiza, wakamfukuza. ");
INSERT INTO swh1850_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yule mwenye shamba akafikiri: Nitafanya nini? Nitamtuma mwanangu mpenzi; labda watamjali yeye. ");
INSERT INTO swh1850_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wale wakulima walipomwona tu, wakasemezana: Huyu ndiye mrithi. Basi, tumwue ili urithi wake uwe wetu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Basi, wakamtoa nje ya lile shamba la mizabibu, wakamwua.” Yesu akauliza, “Yule mwenye shamba atawafanya nini hao wakulima? ");
INSERT INTO swh1850_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Atakuja kuwaangamiza wakulima hao, na atawapa wakulima wengine hilo shamba la mizabibu.” Watu waliposikia maneno hayo, walisema: “Hasha! Yasitukie hata kidogo!” ");
INSERT INTO swh1850_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu akawatazama, akawaambia, “Maandiko haya Matakatifu yana maana gani basi? Jiwe walilokataa waashi, sasa limekuwa jiwe kuu la msingi! ");
INSERT INTO swh1850_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mtu yeyote akianguka juu ya jiwe hilo, atavunjika vipandevipande; na likimwangukia mtu yeyote, litamsaga kabisa.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Walimu wa Sheria na makuhani wakuu walifahamu kwamba mfano huo ulikuwa unawahusu, na hivyo walitaka kumkamata palepale, ila tu waliogopa watu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Basi, wakawa wanatafuta wakati wa kufaa. Wakawahonga watu fulani wajisingizie kuwa wema, wakawatuma wamnase Yesu kwa maswali, na hivyo waweze kumtia nguvuni na kumpeleka kwa wakuu wa serikali. ");
INSERT INTO swh1850_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hao wapelelezi wakamwambia, “Mwalimu, tunajua kwamba unasema na kufundisha mambo ya kweli; tunajua kwamba wewe huna ubaguzi; wewe wafundisha ukweli juu ya njia ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Basi, twambie kama ni halali, au la, kulipa kodi kwa Kaisari!” ");
INSERT INTO swh1850_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu alitambua mtego wao, akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nionyesheni sarafu. Je, sura na chapa ni vya nani?” ");
INSERT INTO swh1850_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nao wakamjibu, “Ni vya Kaisari.” Yesu akawaambia, “Basi, mpeni Kaisari vilivyo vyake Kaisari, na Mungu vilivyo vyake Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hawakufaulu kumnasa kwa neno lolote pale mbele ya watu na hivyo wakakaa kimya wakilistaajabia jibu lake. ");
INSERT INTO swh1850_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kisha Masadukayo, ambao husema kwamba wafu hawafufuki, wakamjia Yesu, wakasema: ");
INSERT INTO swh1850_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mwalimu, Mose alituandikia kwamba kama ndugu ya mtu fulani akifa na kumwacha mjane wake bila watoto, ni lazima ndugu yake amchukue huyo mama mjane, amzalie watoto ndugu yake marehemu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sasa, wakati mmoja kulikuwa na ndugu saba. Yule wa kwanza alioa na baadaye akafa bila kuacha mtoto. ");
INSERT INTO swh1850_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yule ndugu wa pili akamwoa yule mjane, naye pia, akafa; ");
INSERT INTO swh1850_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na ndugu wa tatu vilevile. Mambo yakawa yaleyale kwa wote saba—wote walikufa bila kuacha watoto. ");
INSERT INTO swh1850_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwishowe akafa pia yule mwanamke. ");
INSERT INTO swh1850_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Je, siku wafu watakapofufuliwa, mwanamke huyo atakuwa mke wa nani? Alikuwa ameolewa na wote saba.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akawaambia, “Watu wa nyakati hizi huoa na kuolewa; ");
INSERT INTO swh1850_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lakini wale ambao Mungu atawawezesha kushiriki ule wakati wa ufufuo, hawataoa wala kuolewa. ");
INSERT INTO swh1850_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ama hakika, hawawezi kufa tena, kwa sababu watakuwa kama malaika, na ni watoto wa Mungu kwa vile wamefufuliwa katika wafu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini, kwamba kuna kufufuka kutoka wafu, hata Mose alithibitisha jambo hilo katika Maandiko Matakatifu. Katika sehemu ya Maandiko Matakatifu juu ya kile kichaka kilichokuwa kinawaka moto, anamtaja Bwana kama Mungu wa Abrahamu, Isaka na Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Basi, yeye si Mungu wa wafu, bali ni Mungu wa wale walio hai; maana wale aliowaita kwake, wanaishi naye.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baadhi ya wale walimu wa Sheria wakasema, “Mwalimu, umejibu vema kabisa.” ");
INSERT INTO swh1850_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Walisema hivyo kwa sababu hawakuthubutu kumwuliza tena maswali mengine. ");
INSERT INTO swh1850_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu akawauliza, “Yasemekanaje kwamba Kristo ni mwana wa Daudi? ");
INSERT INTO swh1850_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maana Daudi mwenyewe anasema katika Zaburi: Bwana alimwambia Bwana wangu: Keti upande wangu wa kulia ");
INSERT INTO swh1850_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka niwafanye adui zako kama kiti cha kuwekea miguu yako. ");
INSERT INTO swh1850_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ikiwa Daudi anamwita yeye, Bwana, basi atakuwaje mwanawe?” ");
INSERT INTO swh1850_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu aliwaambia wanafunzi wake mbele ya watu wote, ");
INSERT INTO swh1850_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Jihadharini na walimu wa Sheria ambao hupenda kupitapita wamevalia kanzu. Hupenda kusalimiwa na watu kwa heshima masokoni, huketi mahali pa heshima katika masunagogi na kuchukua nafasi za heshima katika karamu. ");
INSERT INTO swh1850_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Huwadhulumu wajane huku wakisingizia kuwa wema kwa kusali sala ndefu. Hao watapata hukumu kali zaidi!” ");
INSERT INTO swh1850_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu alitazama kwa makini, akawaona matajiri walivyokuwa wanatia sadaka zao katika hazina ya Hekalu, ");
INSERT INTO swh1850_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","akamwona pia mama mmoja mjane akitumbukiza humo sarafu mbili ndogo. ");
INSERT INTO swh1850_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Basi, akasema, “Nawaambieni kweli, mama huyu mjane ametia zaidi katika hazina kuliko wote. ");
INSERT INTO swh1850_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa maana, wengine wote wametoa sadaka zao kutokana na ziada ya mali zao, lakini huyu mama, ingawa ni maskini, ametoa kila kitu alichohitaji kwa kuishi.” ");
INSERT INTO swh1850_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Baadhi ya wanafunzi walikuwa wanazungumza juu ya Hekalu, jinsi lilivyopambwa kwa mawe ya thamani, pamoja na sadaka zilizotolewa kwa Mungu. Yesu akasema, ");
INSERT INTO swh1850_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Haya yote mnayoyaona—zitakuja siku ambapo hakuna hata jiwe moja litakalosalia juu ya lingine; kila kitu kitaharibiwa.” ");
INSERT INTO swh1850_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Basi, wakamwuliza, “Mwalimu, mambo hayo yatatokea lini? Na ni ishara gani zitakazoonyesha kwamba karibu mambo hayo yatokee?” ");
INSERT INTO swh1850_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu akawajibu, “Jihadharini, msije mkadanganyika. Maana wengi watatokea na kulitumia jina langu wakisema: Mimi ndiye, na, Wakati ule umekaribia. Lakini ninyi msiwafuate! ");
INSERT INTO swh1850_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Basi, mtakaposikia habari za vita na misukosuko, msitishike; maana ni lazima hayo yatokee kwanza, lakini mwisho wa yote, bado.” ");
INSERT INTO swh1850_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Halafu akaendelea kusema: “Taifa moja litapigana na taifa lingine, na ufalme mmoja utapigana na ufalme mwingine. ");
INSERT INTO swh1850_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kila mahali kutakuwa na mitetemeko mikubwa ya ardhi, kutakuwa na njaa na tauni. Kutakuwa na vituko vya kutisha na ishara kubwa angani. ");
INSERT INTO swh1850_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakini kabla ya kutokea hayo yote, watawatieni nguvuni, watawatesa na kuwapelekeni katika masunagogi na kuwatia gerezani; mtapelekwa mbele ya wafalme na watawala kwa ajili ya jina langu. ");
INSERT INTO swh1850_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hii itawapeni fursa ya kushuhudia Habari Njema. ");
INSERT INTO swh1850_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Muwe na msimamo huu mioyoni mwenu: hakuna kufikiria kabla ya wakati juu ya jinsi mtakavyojitetea, ");
INSERT INTO swh1850_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kwa sababu mimi mwenyewe nitawapeni ufasaha wa maneno na hekima, hivyo kwamba zenu hawataweza kustahimili wala kupinga. ");
INSERT INTO swh1850_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wazazi wenu, ndugu, jamaa na rafiki zenu watawasaliti ninyi; na baadhi yenu mtauawa. ");
INSERT INTO swh1850_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Watu wote watawachukieni kwa sababu ya jina langu. ");
INSERT INTO swh1850_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini, hata unywele mmoja wa vichwa vyenu hautapotea. ");
INSERT INTO swh1850_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa uvumilivu wenu, mtayaokoa maisha yenu. ");
INSERT INTO swh1850_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mtakapoona mji wa Yerusalemu umezungukwa na majeshi, ndipo mtambue ya kwamba wakati umefika ambapo mji huo utaharibiwa. ");
INSERT INTO swh1850_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hapo walioko Yudea wakimbilie milimani; wale walio mjini watoke; na wale walio mashambani wasirudi mjini. ");
INSERT INTO swh1850_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwa maana siku hizo ni siku za adhabu, ili yote yaliyoandikwa yatimie. ");
INSERT INTO swh1850_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ole wao waja wazito na wanyonyeshao siku hizo! Kwa maana kutakuwa na dhiki kubwa katika nchi, na hasira ya Mungu itawajia watu hawa. ");
INSERT INTO swh1850_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wengine watauawa kwa upanga, wengine watachukuliwa mateka katika nchi zote; na mji wa Yerusalemu utakanyagwa na watu wa mataifa mengine, hadi nyakati zao zitakapotimia. ");
INSERT INTO swh1850_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kutakuwa na ishara katika jua na mwezi na nyota. Mataifa duniani yatakuwa na dhiki kwa sababu ya wasiwasi kutokana na mshindo wa mawimbi ya bahari. ");
INSERT INTO swh1850_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Watu watazirai kwa sababu ya uoga, wakitazamia mambo yatakayoupata ulimwengu; kwa maana nguvu za mbingu zitatikiswa. ");
INSERT INTO swh1850_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Halafu, watamwona Mwana wa Mtu akija katika wingu, mwenye nguvu na utukufu mwingi. ");
INSERT INTO swh1850_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wakati mambo hayo yatakapoanza kutukia, simameni na kuinua vichwa vyenu juu, kwa maana ukombozi wenu umekaribia.” ");
INSERT INTO swh1850_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kisha akawaambia mfano: “Angalieni mtini na miti mingine yote. ");
INSERT INTO swh1850_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mnapoona kwamba imeanza kuchipua majani, mwatambua kwamba wakati wa kiangazi umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vivyo hivyo, mtakapoona mambo hayo yanatendeka, mtatambua kwamba Ufalme wa Mungu umekaribia. ");
INSERT INTO swh1850_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nawaambieni hakika, kizazi hiki cha sasa hakitapita kabla ya hayo yote kutendeka. ");
INSERT INTO swh1850_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mbingu na dunia vitapita, lakini maneno yangu hayatapita. ");
INSERT INTO swh1850_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Muwe macho, mioyo yenu isije ikalemewa na anasa, ulevi na shughuli za maisha haya. La sivyo, Siku ile itawajieni ghafla. ");
INSERT INTO swh1850_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwa maana itawajia kama mtego, wote wanaoishi duniani pote. ");
INSERT INTO swh1850_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Muwe waangalifu basi, na salini daima ili muweze kupata nguvu ya kupita salama katika mambo haya yote yatakayotokea, na kusimama mbele ya Mwana wa Mtu.” ");
INSERT INTO swh1850_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wakati wa mchana, siku hizo, Yesu alikuwa akifundisha watu Hekaluni; lakini usiku alikuwa akienda katika mlima wa Mizeituni na kukaa huko. ");
INSERT INTO swh1850_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Watu wote walikuwa wanakwenda Hekaluni asubuhi na mapema, wapate kumsikiliza. ");
INSERT INTO swh1850_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sikukuu ya Mikate Isiyotiwa chachu, iitwayo Pasaka, ilikuwa inakaribia. ");
INSERT INTO swh1850_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Makuhani wakuu na walimu wa Sheria wakawa wanatafuta njia ya kumwua Yesu, lakini waliwaogopa watu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Basi, Shetani akamwingia Yuda aitwae Iskarioti, mmoja wa wale mitume kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda akaenda akajadiliana na makuhani wakuu na walinzi wa Hekalu kuhusu atakavyomsaliti Yesu kwao. ");
INSERT INTO swh1850_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nao wakafurahi na kupatana naye kumlipa fedha. ");
INSERT INTO swh1850_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda akakubali, na akawa anatafuta nafasi nzuri ya kumkabidhi kwao bila umati wa watu kujua. ");
INSERT INTO swh1850_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Basi, siku ya Mikate Isiyotiwa chachu ikafika. Hiyo ndiyo siku ambayo mwana kondoo wa Pasaka huchinjwa. ");
INSERT INTO swh1850_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hivyo Yesu akawatuma Petro na Yohane, akawaambia, “Nendeni mkatuandalie karamu ili tupate kula Pasaka.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nao wakamwuliza, “Unataka tuiandae wapi?” ");
INSERT INTO swh1850_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akawaambia, “Sikilizeni! Mtakapokuwa mnakwenda mjini, mtakutana na mwanamume anayebeba mtungi wa maji. Mfuateni mpaka ndani ya nyumba atakayoingia. ");
INSERT INTO swh1850_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwambieni mwenye nyumba: Mwalimu anakuuliza, kiko wapi kile chumba ambamo nitakula Pasaka pamoja na wanafunzi wangu? ");
INSERT INTO swh1850_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naye atawaonyesheni chumba kikubwa ghorofani ambacho kimepambwa. Andalieni humo.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Basi, wakaenda, wakakuta kila kitu sawa kama Yesu alivyokuwa amewaambia; wakaandaa karamu ya Pasaka. ");
INSERT INTO swh1850_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saa ilipotimia, Yesu akakaa kula chakula pamoja na mitume wake. ");
INSERT INTO swh1850_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akawaambia, “Nimetamani sana kula Pasaka hii pamoja nanyi kabla ya kuteswa kwangu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Maana nawaambieni, sitaila tena hadi hapo itakapokamilika katika Ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kisha akatwaa kikombe, akashukuru akasema, “Pokeeni, mgawanye ninyi kwa ninyi. ");
INSERT INTO swh1850_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwa maana nawaambieni, sitakunywa tena divai ya zabibu mpaka Ufalme wa Mungu utakapokuja.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Halafu akatwaa mkate, akashukuru, akaumega, akawapa akisema, “Huu ni mwili wangu, unaotolewa kwa ajili yenu. Fanyeni hivi kwa kunikumbuka.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akafanya vivyo hivyo na kikombe, baada ya chakula, akisema, “Kikombe hiki ni agano jipya linalothibitishwa kwa damu yangu inayomwagika kwa ajili yenu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lakini, tazameni! Yule atakayenisaliti yuko nami hapa mezani. ");
INSERT INTO swh1850_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kweli Mwana wa Mtu anakwenda kuuawa kama ilivyopangwa, lakini ole wake mtu anayemsaliti.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hapo wakaanza kuulizana wao kwa wao ni nani kati yao atakayefanya jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kulitokea ubishi kati ya hao mitume kuhusu nani miongoni mwao anayefikiriwa kuwa mkuu zaidi kuliko wengine. ");
INSERT INTO swh1850_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu akawaambia, “Wafalme wa mataifa huwatawala watu wao kwa mabavu, nao huitwa wafadhili wa watu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini isiwe hivyo kati yenu; bali, yule aliye mkuu kati yenu ni lazima awe mdogo wa wote, na aliye kiongozi lazima awe kama mtumishi. ");
INSERT INTO swh1850_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwa maana, ni nani aliye mkuu: yule anayeketi mezani kula chakula, ama yule anayetumikia? Bila shaka ni yule anayeketi mezani kula chakula! Hata hivyo, mimi niko hapa kati yenu kama mtumishi. ");
INSERT INTO swh1850_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ninyi ndio mliobaki nami wakati wote wa majaribu yangu; ");
INSERT INTO swh1850_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","na, kama vile Baba yangu alivyonikabidhi Ufalme, vivyo hivyo nami nitawakabidhi ninyi Ufalme. ");
INSERT INTO swh1850_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mtakula na kunywa mezani pangu katika ufalme wangu, na mtaketi katika viti vya enzi kuyahukumu makabila kumi na mawili ya Israeli. ");
INSERT INTO swh1850_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Sikiliza! Shetani alitaka kuwapepeta ninyi kama mtu anavyopepeta ngano. ");
INSERT INTO swh1850_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini mimi nimekuombea ili imani yako isipungue. Nawe utakaponirudia, watie moyo ndugu zako.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naye Petro akamjibu, “Bwana, mimi niko tayari kwenda pamoja nawe gerezani, na hata kufa.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu akamjibu, “Nakwambia wewe Petro, kabla jogoo hajawika leo utakuwa umenikana mara tatu.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kisha, Yesu akawauliza wanafunzi wake, “Wakati nilipowatuma bila mfuko wa fedha wala mkoba wala viatu, mlitindikiwa chochote?” Wakajibu, “La.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naye akawaambia, “Lakini sasa, yule aliye na mfuko wa fedha auchukue; na aliye na mkoba, hali kadhalika. Na yeyote asiye na upanga, auze koti lake anunue mmoja. ");
INSERT INTO swh1850_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Maana nawaambieni, haya maneno ya Maandiko Matakatifu: Aliwekwa kundi moja na wahalifu, ni lazima yatimie. Naam, yale yanayonihusu yanafikia ukamilifu wake.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nao wakasema, “Bwana, tazama; hapa kuna panga mbili.” Naye akasema, “Basi!” ");
INSERT INTO swh1850_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu akatoka, na kama ilivyokuwa desturi yake, akaenda katika mlima wa Mizeituni; wanafunzi wake wakamfuata. ");
INSERT INTO swh1850_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Alipofika huko akawaambia, “Salini, msije mkaingia katika kishawishi.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kisha akawaacha, akaenda umbali wa mtu kuweza kutupa jiwe, akapiga magoti, akasali: ");
INSERT INTO swh1850_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baba, kama wapenda, ukiondoe kwangu kikombe hiki; hata hivyo, mapenzi yako yatimizwe, wala siyo yangu.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hapo, malaika kutoka mbinguni, akamtokea ili kumtia moyo. ");
INSERT INTO swh1850_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akiwa katika uchungu mkubwa, alisali kwa bidii zaidi; na jasho likamtoka, kama matone ya damu, likatiririka mpaka chini. ");
INSERT INTO swh1850_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Baada ya kusali, aliwarudia wanafunzi wake, akawakuta wamelala, kwani walikuwa na huzuni. ");
INSERT INTO swh1850_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akawaambia, “Mbona mnalala? Amkeni msali, msije mkaingia katika kishawishi.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Alipokuwa bado anaongea, kundi la watu likaja likiongozwa na yule aliyeitwa Yuda, mmoja wa wale mitume kumi na wawili. Yuda akaenda kumsalimu Yesu kwa kumbusu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lakini Yesu akamwambia, “Yuda! Je, unamsaliti Mwana wa Mtu kwa kumbusu?” ");
INSERT INTO swh1850_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wale wanafunzi wake walipoona hayo wakasema, “Bwana, tutumie panga zetu?” ");
INSERT INTO swh1850_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na mmoja wao akampiga upanga mtumishi wa Kuhani Mkuu, akamkata sikio lake la kulia. ");
INSERT INTO swh1850_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hapo, Yesu akasema, “Acha! Hii inatosha.” Akaligusa sikio la mtu huyo akaliponya. ");
INSERT INTO swh1850_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kisha Yesu akawaambia makuhani wakuu, wakubwa wa walinzi wa Hekalu na wazee waliokuja kumkamata: “Je, mmekuja na mapanga na marungu kunikamata kana kwamba mimi ni mnyang'anyi? ");
INSERT INTO swh1850_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nilipokuwa pamoja nanyi kila siku Hekaluni hamkunitia nguvuni. Lakini, huu ndio wakati wenu hasa, ndio wakati wa utawala wa giza.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Basi, wakamkamata, wakamchukua na kwenda naye nyumbani kwa Kuhani Mkuu. Petro akawa anamfuata nyuma kwa mbali. ");
INSERT INTO swh1850_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Moto ulikuwa umewashwa katikati ya ua, nao wakawa wameketi pamoja Petro akiwa miongoni mwao. ");
INSERT INTO swh1850_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mjakazi mmoja alipomwona Petro ameketi karibu na moto, akamkodolea macho, akasema, “Mtu huyu alikuwa pia pamoja na Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petro akakana akisema, “Wee! simjui mimi.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Baadaye kidogo, mtu mwingine akamwona Petro, akasema, “Wewe ni mmoja wao.” Lakini Petro akajibu “Bwana we; si mimi!” ");
INSERT INTO swh1850_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kama saa moja baadaye, mtu mwingine akasisitiza, “Hakika huyu alikuwa pamoja naye; ametoka Galilaya ati.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petro akasema, “Bwana wee; sijui hata unachosema!” Na papo hapo, akiwa bado anaongea, jogoo akawika. ");
INSERT INTO swh1850_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bwana akageuka na kumtazama Petro, naye Petro akakumbuka yale aliyokuwa ameambiwa na Bwana: “Leo kabla jogoo hajawika, utanikana mara tatu.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hapo akatoka nje, akalia sana. ");
INSERT INTO swh1850_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wale watu waliokuwa wanamchunga Yesu, walimpiga na kumdhihaki. ");
INSERT INTO swh1850_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Walimfunga kitambaa usoni, wakawa wanamwuliza, “Ni nani aliyekupiga? Hebu bashiri tuone!” ");
INSERT INTO swh1850_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wakamtolea maneno mengi ya matusi. ");
INSERT INTO swh1850_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kulipokucha, kikao cha wazee wa watu kilifanyika, ambacho kilihudhuriwa na makuhani wakuu na walimu wa Sheria. Yesu akaletwa mbele ya Baraza hilo. ");
INSERT INTO swh1850_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nao wakamwambia, “Twambie! Je, wewe ndiwe Kristo?” Lakini Yesu akawaambia, “Hata kama nikiwaambieni, hamtasadiki; ");
INSERT INTO swh1850_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na hata kama nikiwaulizeni swali, hamtanijibu. ");
INSERT INTO swh1850_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini tangu sasa, Mwana wa Mtu atakuwa ameketi upande wa kulia wa Mungu Mwenyezi.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hapo wote wakasema, “Ndiyo kusema wewe ni Mwana wa Mungu?” Naye akasema, “Ninyi mnasema kwamba mimi ndiye.” ");
INSERT INTO swh1850_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nao wakasema, “Je, tunahitaji ushahidi mwingine? Sisi wenyewe tumesikia akisema kwa mdomo wake mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kisha, wote kwa jumla, wakasimama, wakampeleka Yesu mbele ya Pilato. ");
INSERT INTO swh1850_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wakaanza kumshtaki wakisema: “Tulimkuta mtu huyu akiwapotosha watu wetu, akipinga kulipa kodi kwa Kaisari na kujiita ati yeye ni Kristo, Mfalme.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato akamwuliza Yesu, “Wewe ni Mfalme wa Wayahudi?” Yesu akamjibu, “Wewe umesema.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato akawaambia makuhani wakuu na umati wa watu, “Sioni kosa lolote katika mtu huyu.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini wao wakasisitiza wakisema: “Anawachochea watu kwa mafundisho yake katika nchi yote ya Yudea; alianza Galilaya, na sasa yuko hapa.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato aliposikia hayo, akauliza, “Je, mtu huyu ni mwenyeji wa Galilaya?” ");
INSERT INTO swh1850_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Alipojua kwamba Yesu alikuwa chini ya utawala wa Herode, akampeleka kwa Herode, ambaye wakati huo alikuwa Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode alifurahi sana alipomwona Yesu. Alikuwa amekwisha sikia habari zake, na hivyo alikuwa anatazamia kwa muda mrefu kumwona kwa macho yake mwenyewe. Zaidi ya hayo, alikuwa anatumaini kumwona Yesu akitenda mwujiza. ");
INSERT INTO swh1850_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Basi, akamwuliza maswali mengi kwa muda mrefu, lakini Yesu hakumjibu neno. ");
INSERT INTO swh1850_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makuhani wakuu na walimu wa Sheria wakajitokeza mbele, wakatoa mashtaka yao kwa nguvu sana. ");
INSERT INTO swh1850_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Basi, herode pamoja na maaskari wake, wakamwaibisha Yesu na kumfanyia mzaha; kisha wakamvika vazi la kifalme, wakamrudisha kwa Pilato. ");
INSERT INTO swh1850_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herode na Pilato, ambao hapo awali walikuwa maadui, tangu siku hiyo wakawa marafiki. ");
INSERT INTO swh1850_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Basi, Pilato akaitisha mkutano wa makuhani wakuu, viongozi na watu, ");
INSERT INTO swh1850_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akawaambia, “Mmemleta mtu huyu kwangu mkisema kwamba alikuwa anawapotosha watu. Sasa sikilizeni! Baada ya kuchunguza jambo hilo mbele yenu, sikumpata na kosa lolote kuhusu mashtaka yenu juu yake. ");
INSERT INTO swh1850_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala si mimi tu, bali hata Herode hakuona kosa lolote, kwa maana amemrudisha kwangu. Ni dhahiri kwamba mtu huyu hakufanya chochote kinachostahili adhabu ya kifo. ");
INSERT INTO swh1850_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hivyo, nitaamuru apigwe viboko, halafu nitamwachilia.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila sikukuu ya Pasaka, ilimlazimu Pilato kuwafungulia mfungwa mmoja. ");
INSERT INTO swh1850_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini wote wakapiga kelele pamoja: “Mwondoe huyo, utufungulie Baraba!” ");
INSERT INTO swh1850_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba alikuwa ametiwa ndani kwa kusababisha uasi katika mji na pia kwa sababu ya kuua.) ");
INSERT INTO swh1850_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato alitaka kumwachilia Yesu, hivyo akasema nao tena; ");
INSERT INTO swh1850_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","lakini wao wakapiga kelele: “Msulubishe, msulubishe!” ");
INSERT INTO swh1850_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato akawaambia mara ya tatu, “Amefanya kosa gani? Sioni kosa lolote kwake linalomstahili auawe; kwa hiyo nitampiga viboko, halafu nimwachilie.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini wao wakazidi kupiga kelele kwa nguvu sana, kwamba Yesu ni lazima asulubiwe. Mwishowe, sauti zao zikashinda. ");
INSERT INTO swh1850_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Basi, Pilato akaamua kwamba matakwa yao yatimizwe. ");
INSERT INTO swh1850_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akamfungua kutoka gerezani yule waliyemtaka, ambaye alikuwa ametiwa gerezani kwa sababu ya uasi na kuua; akamtoa Yesu kwao, wamfanyie walivyotaka. ");
INSERT INTO swh1850_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Walipokuwa wakimpeleka, walikutana na mtu mmoja, aitwaye Simoni wa Kurene, aliyekuwa anatoka shambani. Basi, walimkamata, wakamtwika ule msalaba auchukue nyuma ya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Watu, umati kwa umati, walimfuata; miongoni mwao wakiwemo wanawake waliokuwa wanaomboleza na kumlilia. ");
INSERT INTO swh1850_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu akawageukia, akasema, “Enyi kina mama wa Yerusalemu! Msinililie mimi, ila lieni kwa ajili yenu wenyewe na kwa ajili ya watoto wenu. ");
INSERT INTO swh1850_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maana, hakika siku zitakuja ambapo watasema: Heri yao wale walio tasa, ambao hawakupata kuzaa wala kunyonyesha watoto! ");
INSERT INTO swh1850_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wakati huo, ndipo watu wataanza kuiambia milima: Tuangukieni! na vilima, Tufunikeni! ");
INSERT INTO swh1850_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwa maana, kama watu wanautendea mti mbichi namna hiyo, itakuwaje kwa mti mkavu?” ");
INSERT INTO swh1850_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Waliwachukua pia watu wengine wawili, wahalifu, wauawe pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Walipofika mahali paitwapo, “Fuvu la Kichwa,” ndipo wakamsulubisha Yesu pamoja na wale wahalifu wawili, mmoja upande wake wa kulia na mwingine upande wake wa kushoto. ");
INSERT INTO swh1850_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu akasema, “Baba, uwasamehe kwa maana hawajui wanalofanya.” Kisha wakagawana mavazi yake kwa kuyapigia kura. ");
INSERT INTO swh1850_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Watu wakawa wamesimama pale wakitazama. Nao viongozi wakamdhihaki wakisema: “Amewaokoa wengine; sasa na ajiokoe mwenyewe, kama yeye ndiye Kristo, mteule wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Askari nao walimdhihaki pia; walimwendea wakampa siki ");
INSERT INTO swh1850_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wakisema: “Kama kweli wewe ni Mfalme wa Wayahudi, jiokoe mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vilevile maandishi haya yalikuwa yameandikwa na kuwekwa juu yake: “Huyu ndiye Mfalme wa Wayahudi.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mmoja wa wale wahalifu waliotundikwa msalabani, alimtukana akisema: “Je, si kweli kwamba wewe ndiwe Kristo? Basi, jiokoe mwenyewe, utuokoe na sisi pia.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini yule mhalifu mwingine akamkemea mwenzake akisema: “Wewe humwogopi Mungu hata kidogo? Wewe umepata adhabu hiyohiyo. ");
INSERT INTO swh1850_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wewe na mimi tunastahili, maana haya ni malipo ya yale tuliyotenda. Lakini mtu huyu hakufanya chochote kibaya.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kisha akasema, “Ee Yesu! Unikumbuke wakati utakapoingia katika ufalme wako.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu akamwambia, “Nakwambia kwa hakika, leo utakuwa pamoja nami peponi.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ilikuwa yapata saa sita mchana; jua likaacha kuangaza, giza likafunika nchi yote mpaka saa tisa, ");
INSERT INTO swh1850_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na pazia lililokuwa limetundikwa Hekaluni likapasuka vipande viwili. ");
INSERT INTO swh1850_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu akalia kwa sauti kubwa: “Baba, naiweka roho yangu mikononi mwako.” Alipokwisha sema hayo, akakata roho. ");
INSERT INTO swh1850_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hapo, yule jemadari alipoona yaliyotukia akamsifu Mungu akisema: “Hakika huyu alikuwa mtu mwema.” ");
INSERT INTO swh1850_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Watu wale wote waliokuwa wamekusanyika hapo kwa ajili ya tukio hilo, walipoona hayo yaliyotukia, walirudi makwao wakijipiga vifua kwa huzuni. ");
INSERT INTO swh1850_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Marafiki zake wote pamoja na wale wanawake walioandamana naye kutoka Galilaya, walisimama kwa mbali kutazama tukio hilo. ");
INSERT INTO swh1850_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kulikuwa na mtu mmoja jina lake Yosefu, mwenyeji wa kijiji kimoja cha Wayahudi kiitwacho Armathaya. Alikuwa mtu mwema anayeheshimika; ");
INSERT INTO swh1850_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Alikuwa akitazamia kuja kwa Ufalme wa Mungu. Ingawa alikuwa mmoja wa Baraza kuu la Wayahudi, hakuwa amekubaliana nao katika kitendo chao. ");
INSERT INTO swh1850_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Basi, yeye alikwenda kwa Pilato, akaomba apewe mwili wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kisha, akaushusha mwili huo kutoka msalabani, akauzungushia sanda ya kitani, akauweka katika kaburi lililokuwa limechongwa kwenye mwamba, ambalo halikuwa limetumika. ");
INSERT INTO swh1850_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Siku hiyo ilikuwa Ijumaa, na maandalio ya siku ya Sabato yalikuwa yanaanza. ");
INSERT INTO swh1850_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wale wanawake walioandamana na Yesu kutoka Galilaya walimfuata Yosefu, wakaliona lile kaburi na jinsi mwili wake Yesu ulivyowekwa ");
INSERT INTO swh1850_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Halafu, walirudi nyumbani, wakatayarisha manukato na marashi kuyapaka mwili wa Yesu. Siku ya Sabato walipumzika kama ilivyoamriwa na sheria. ");
INSERT INTO swh1850_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili, alfajiri na mapema, wale wanawake walikwenda kaburini wakichukua yale manukato waliyotayarisha. ");
INSERT INTO swh1850_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Walikuta lile jiwe limeviringishwa mbali na kaburi. ");
INSERT INTO swh1850_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Walipoingia ndani, hawakuona mwili wa Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Walipokuwa bado wanashangaa juu ya jambo hilo, mara watu wawili waliovaa mavazi yenye kung'aa sana, wakasimama karibu nao. ");
INSERT INTO swh1850_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hao wanawake wakaingiwa na hofu, wakainama chini. Ndipo wale watu wakawaambia, “Kwa nini mnamtafuta aliye hai kati ya wafu? ");
INSERT INTO swh1850_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hayuko hapa; amefufuka. Kumbukeni aliyowaambieni alipokuwa kule Galilaya: ");
INSERT INTO swh1850_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ni lazima Mwana wa Mtu atolewe kwa watu waovu, nao watamsulubisha, na siku ya tatu atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hapo wanawake wakayakumbuka maneno yake, ");
INSERT INTO swh1850_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wakarudi kutoka kaburini, wakawapa mitume wale kumi na mmoja na wengine habari za mambo hayo yote. ");
INSERT INTO swh1850_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hao waliotoa habari hizo kwa mitume ni: Maria Magdalene, Yoana na Maria mama wa Yakobo, pamoja na wanawake wengine walioandamana nao. ");
INSERT INTO swh1850_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mitume waliyachukua maneno hayo kama yasiyo na msingi, hivyo hawakuamini. ");
INSERT INTO swh1850_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakini Petro alitoka, akaenda mbio hadi kaburini. Alipoinama kuchungulia ndani, akaiona tu ile sanda. Akarudi nyumbani huku akiwa anashangaa juu ya hayo yaliyotokea. ");
INSERT INTO swh1850_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Siku hiyohiyo, wawili kati ya wafuasi wake Yesu wakawa wanakwenda katika kijiji kimoja kiitwacho Emau, umbali wa kilomita kumi na moja kutoka Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wakawa wanazungumza juu ya hayo yote yaliyotukia. ");
INSERT INTO swh1850_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Walipokuwa wakizungumza na kujadiliana, Yesu mwenyewe akatokea, akatembea pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Walimwona kwa macho, lakini hawakumtambua. ");
INSERT INTO swh1850_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Akawauliza, “Mnazungumza nini huku mnatembea?” Nao wakasimama kimya, nyuso zao wamezikunja kwa huzuni. ");
INSERT INTO swh1850_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmoja, aitwaye Kleopa, akamjibu, “Je, wewe ni mgeni peke yako Yerusalemu ambaye hujui yaliyotukia huko siku hizi?” ");
INSERT INTO swh1850_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naye akawajibu, “Mambo gani?” Wao wakamjibu, “Mambo yaliyompata Yesu wa Nazareti. Yeye alikuwa nabii mwenye uwezo wa kutenda na kufundisha mbele ya Mungu na mbele ya watu wote. ");
INSERT INTO swh1850_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Makuhani na watawala wetu walimtoa ahukumiwe kufa, wakamsulubisha. ");
INSERT INTO swh1850_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lakini sisi tulitumaini kwamba yeye ndiye angeikomboa Israeli. Zaidi ya hayo yote, leo ni siku ya tatu tangu mambo hayo yalipotendeka. ");
INSERT INTO swh1850_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tena, wanawake wengine wa kwetu wametushtua. Walikwenda kaburini mapema asubuhi, ");
INSERT INTO swh1850_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wasiukute mwili wake. Wakarudi wakasema kwamba walitokewa na malaika waliowaambia kwamba alikuwa hai. ");
INSERT INTO swh1850_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wengine wetu walikwenda kaburini wakashuhudia yale waliyosema hao wanawake; ila yeye hawakumwona.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kisha Yesu akawaambia, “Mbona mu wapumbavu kiasi hicho na mioyo yenu ni mizito hivyo kusadiki yote yaliyonenwa na manabii? ");
INSERT INTO swh1850_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Je, haikumpasa Kristo kuteswa, na hivyo aingie katika utukufu wake?” ");
INSERT INTO swh1850_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Akawafafanulia mambo yote yaliyomhusu yeye katika Maandiko Matakatifu kuanzia Mose hadi manabii wote. ");
INSERT INTO swh1850_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Walipokikaribia kile kijiji walikokuwa wanakwenda, Yesu akafanya kana kwamba anaendelea na safari; ");
INSERT INTO swh1850_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","lakini wao wakamsihi wakisema, “Kaa pamoja nasi, maana kunakuchwa, na usiku unakaribia.” Basi, akaingia kijijini, akakaa pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Alipoketi kula chakula pamoja nao, akachukua mkate, akaubariki, akaumega, akawapa. ");
INSERT INTO swh1850_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mara macho yao yakafumbuliwa, wakamtambua; lakini yeye akatoweka kati yao. ");
INSERT INTO swh1850_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Basi, wakaambiana, “Je, mioyo yetu haikuwa inawaka ndani yetu wakati alipokuwa anatufafanulia Maandiko Matakatifu kule njiani?” ");
INSERT INTO swh1850_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wakaondoka saa ileile, wakarudi Yerusalemu: wakawakuta wale mitume kumi na mmoja na wale wengine waliokuwa pamoja nao, wamekusanyika ");
INSERT INTO swh1850_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wakisema, “Hakika Bwana amefufuka, amemtokea Simoni.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Basi, hao wafuasi wawili wakawajulisha yale yaliyowapata njiani, na jinsi walivyomtambua katika kumega mkate. ");
INSERT INTO swh1850_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wanafunzi wote wawili walipokuwa wakiwaambia hayo, Yesu mwenyewe akasimama kati yao, akawaambia “Amani kwenu.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wakashtuka na kushikwa na hofu wakidhani wameona mzimu. ");
INSERT INTO swh1850_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lakini yeye akawaambia, “Kwa nini mnafadhaika? Mbona mnakuwa na mashaka mioyoni mwenu? ");
INSERT INTO swh1850_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Angalieni mikono na miguu yangu, ya kwamba ni mimi mwenyewe. Nipapaseni mkanione, maana mzimu hauna mwili na mifupa kama mnionavyo.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Baada ya kusema hayo, akawaonyesha mikono na miguu. ");
INSERT INTO swh1850_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wakiwa bado katika hali ya kutosadiki kwa sababu ya furaha yao, na wakiwa wanastaajabu, akawauliza, “Mnacho chakula chochote hapa?” ");
INSERT INTO swh1850_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wakampa kipande cha samaki wa kuokwa. ");
INSERT INTO swh1850_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Akakichukua, akala, wote wakimwona. ");
INSERT INTO swh1850_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Halafu akawaambia, “Hii ndiyo maana ya maneno niliyowaambia nilipokuwa pamoja nanyi: kwamba ilikuwa lazima kukamilisha yote yaliyoandikwa juu yangu katika Sheria ya Mose na katika vitabu vya manabii na katika kitabu cha Zaburi.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kisha, akaziangazia akili zao ili wapate kuelewa Maandiko Matakatifu. ");
INSERT INTO swh1850_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akawaambia, “Ndivyo ilivyoandikwa, kwamba Kristo atateswa na siku ya tatu atafufuka kutoka wafu, ");
INSERT INTO swh1850_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na kwamba ni lazima, kwa jina lake, mataifa yote kuanzia na Yerusalemu yahubiriwe juu ya kutubu na kusamehewa dhambi. ");
INSERT INTO swh1850_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ninyi ni mashahidi wa mambo hayo. ");
INSERT INTO swh1850_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nami mwenyewe nitawapelekeeni yule ambaye Baba aliahidi kumtuma, lakini ngojeni huku mjini mpaka mtakapopewa ile nguvu itokayo juu.” ");
INSERT INTO swh1850_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kisha akawaongoza nje ya mji hadi Bethania, akainua mikono yake juu, akawabariki. ");
INSERT INTO swh1850_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Alipokuwa anawabariki, akawaacha; akachukuliwa mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wao wakamwabudu, wakarudi Yerusalemu wakiwa na furaha kubwa: ");
INSERT INTO swh1850_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","wakakaa muda wote Hekaluni wakimsifu Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hapo Mwanzo, Neno alikuwako; naye alikuwa na Mungu, naye alikuwa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tangu mwanzo Neno alikuwa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kwa njia yake vitu vyote viliumbwa; hakuna hata kiumbe kimoja kilichoumbwa pasipo yeye. ");
INSERT INTO swh1850_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yeye alikuwa chanzo cha uhai na uhai huo ulikuwa mwanga wa watu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na mwanga huo huangaza gizani, nalo giza halikuweza kuushinda. ");
INSERT INTO swh1850_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mungu alimtuma mtu mmoja jina lake Yohane, ");
INSERT INTO swh1850_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ambaye alikuja kuwaambia watu juu ya huo mwanga. Alikuja ili kwa ujumbe wake watu wote wapate kuamini. ");
INSERT INTO swh1850_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yeye hakuwa huo mwanga, ila alikuja tu kuwaambia watu juu ya huo mwanga. ");
INSERT INTO swh1850_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huu ndio mwanga halisi, mwanga unaokuja ulimwenguni, na kuwaangazia watu wote. ");
INSERT INTO swh1850_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Basi, Neno alikuwako ulimwenguni; na kwa njia yake ulimwengu uliumbwa, lakini ulimwengu haukumtambua. ");
INSERT INTO swh1850_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Alikuja katika nchi yake mwenyewe, nao walio wake hawakumpokea. ");
INSERT INTO swh1850_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakini wale wote waliompokea na kumwamini, hao aliwapa uwezo wa kuwa watoto wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hawa wamekuwa watoto wa Mungu si kwa uwezo wa kibinadamu, wala kwa nguvu za kimwili, wala kwa mapenzi ya mtu, bali Mungu mwenyewe ndiye baba yao. ");
INSERT INTO swh1850_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naye Neno akawa mwanadamu, akakaa kwetu. Nasi tumeuona utukufu wake, utukufu wake yeye aliye Mwana wa pekee wa Baba; amejaa neema na ukweli. ");
INSERT INTO swh1850_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane aliwaambia watu habari zake, akasema kwa sauti, “Huyu ndiye niliyemtaja wakati niliposema: Anakuja mtu mmoja baada yangu ambaye ni mkuu kuliko mimi, maana alikuwako kabla mimi sijazaliwa.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kutokana na ukamilifu wake sisi tumepokea neema mfululizo. ");
INSERT INTO swh1850_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Maana Mungu alitoa Sheria kwa njia ya Mose, lakini neema na kweli vimekuja kwa njia ya Kristo. ");
INSERT INTO swh1850_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hakuna mtu aliyemwona Mungu wakati wowote ule. Mwana wa pekee aliye sawa na Mungu ambaye ameungana na Baba, ndiye aliyetujulisha habari za Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Huu ndio ushahidi Yohane alioutoa wakati viongozi wa Wayahudi kule Yerusalemu walipowatuma makuhani wa Walawi kwake wamwulize: “Wewe u nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane hakukataa kujibu swali hilo, bali alisema waziwazi, “Mimi siye Kristo.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hapo wakamwuliza, “Basi, wewe ni nani? Je, wewe ni Eliya?” Yohane akajibu, “La, mimi siye.” Wakamwuliza, “Je, wewe ni yule nabii?” Yohane akawajibu, “La!” ");
INSERT INTO swh1850_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nao wakamwuliza, “Basi, wewe ni nani? Wasema nini juu yako mwenyewe? Tuambie, ili tuwapelekee jibu wale waliotutuma.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane akawajibu, “Mimi ndiye yule ambaye nabii Isaya alisema habari zake: Sauti ya mtu imesikika jangwani: Nyoosheni njia ya Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hao watu walikuwa wametumwa na Mafarisayo. ");
INSERT INTO swh1850_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Basi, wakamwuliza Yohane, “Kama wewe si Kristo, wala Eliya, wala yule nabii, mbona wabatiza?” ");
INSERT INTO swh1850_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane akawajibu, “Mimi nabatiza kwa maji, lakini yuko mmoja kati yenu, msiyemjua bado. ");
INSERT INTO swh1850_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Huyo anakuja baada yangu, lakini mimi sistahili hata kumfungua kamba za viatu vyake.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mambo haya yalifanyika huko Bethania, ng'ambo ya mto Yordani ambako Yohane alikuwa anabatiza. ");
INSERT INTO swh1850_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kesho yake, Yohane alimwona Yesu akimjia, akasema, “Huyu ndiye Mwana-kondoo wa Mungu aondoaye dhambi ya ulimwengu! ");
INSERT INTO swh1850_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Huyu ndiye niliyesema juu yake: Baada yangu anakuja mtu mmoja aliye mkuu zaidi kuliko mimi, maana alikuwako kabla mimi sijazaliwa! ");
INSERT INTO swh1850_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mimi mwenyewe sikumfahamu, lakini nimekuja kubatiza kwa maji ili watu wa Israeli wapate kumjua.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Huu ndio ushahidi Yohane alioutoa: “Nilimwona Roho akishuka kama njiwa kutoka mbinguni na kutua juu yake. ");
INSERT INTO swh1850_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mimi sikumjua, lakini yule aliyenituma nikabatize watu kwa maji alikuwa ameniambia: Mtu yule utakayemwona Roho akimshukia kutoka mbinguni na kukaa juu yake, huyo ndiye anayebatiza kwa Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mimi nimeona na ninawaambieni kwamba huyu ndiye Mwana wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kesho yake, Yohane alikuwa tena mahali hapo pamoja na wanafunzi wake wawili. ");
INSERT INTO swh1850_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Alipomwona Yesu akipita akasema, “Tazameni! Huyu ndiye Mwana-kondoo wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hao wanafunzi walimsikia Yohane akisema maneno hayo, wakamfuata Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Basi, Yesu aligeuka, na alipowaona hao wanafunzi wanamfuata, akawauliza, “Mnatafuta nini?” Nao wakamjibu, “Rabi (yaani Mwalimu), unakaa wapi?” ");
INSERT INTO swh1850_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu akawaambia, “Njoni, nanyi mtaona.” Hao wanafunzi wakamfuata, wakaona mahali alipokuwa anakaa, wakashinda naye siku hiyo. Ilikuwa yapata saa kumi jioni. ");
INSERT INTO swh1850_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrea, nduguye Simoni Petro, alikuwa mmoja wa hao wawili waliokuwa wamemsikia Yohane akisema hivyo, wakamfuata Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrea alimkuta kwanza Simoni, ndugu yake, akamwambia, “Tumemwona Masiha” (maana yake Kristo). ");
INSERT INTO swh1850_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kisha akampeleka Simoni kwa Yesu. Naye Yesu akamtazama Simoni akasema, “Wewe ni Simoni mwana wa Yohane. Sasa utaitwa Kefa.” (maana yake ni Petro, yaani, “Mwamba.”) ");
INSERT INTO swh1850_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kesho yake Yesu aliamua kwenda Galilaya. Basi, akamkuta Filipo, akamwambia, “Nifuate.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo alikuwa mwenyeji wa Bethsaida, mji wa akina Andrea na Petro. ");
INSERT INTO swh1850_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naye Filipo akamkuta Nathanieli, akamwambia, “Tumemwona yule ambaye Mose aliandika juu yake katika kitabu cha Sheria, na ambaye manabii waliandika habari zake, yaani Yesu Mwana wa Yosefu, kutoka Nazareti.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naye Nathanieli akamwuliza Filipo, “Je, kitu chema chaweza kutoka Nazareti?” Filipo akamwambia, “Njoo uone.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu alipomwona Nathanieli akimjia alisema juu yake, “Tazameni! Huyo ni Mwisraeli halisi: hamna hila ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naye Nathanieli akamwuliza, “Umepataje kunijua?” Yesu akamwambia, “Ulipokuwa chini ya mtini hata kabla Filipo hajakuita, nilikuona.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hapo Nathanieli akamwambia, “Mwalimu, wewe ni Mwana wa Mungu. Wewe ni Mfalme wa Israeli!” ");
INSERT INTO swh1850_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu akamwambia, “Je, umeamini kwa kuwa nimekwambia kwamba nilikuona chini ya mtini? Utaona makubwa zaidi kuliko haya.” ");
INSERT INTO swh1850_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu akaendelea kusema, “Nawaambieni kweli, mtaona mbingu zinafunguka na malaika wa Mungu wakipanda na kushuka juu ya Mwana wa Mtu.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Siku ya tatu kulikuwa na arusi mjini Kana, mkoani Galilaya. Mama yake Yesu alikuwapo, ");
INSERT INTO swh1850_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","naye Yesu alikuwa amealikwa arusini pamoja na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai ilipokwisha, mama yake akamwambia, “Hawana divai!” ");
INSERT INTO swh1850_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu akamjibu, “Mama, usiniambie la kufanya. Saa yangu bado.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hapo mama yake akawaambia watumishi, “Lolote atakalowaambieni, fanyeni.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hapo palikuwa na mitungi sita ya mawe, ambayo kila mmoja uliweza kuchukua kiasi cha madebe mawili au matatu. Ilikuwa imewekwa hapo kufuatana na desturi ya Kiyahudi ya kutawadha. ");
INSERT INTO swh1850_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu akawaambia, “Ijazeni mitungi hiyo maji.” Nao wakaijaza mpaka juu. ");
INSERT INTO swh1850_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kisha akawaambia, “Sasa choteni mkampelekee mkuu wa karamu.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mkuu wa karamu alipoonja hayo maji, kumbe yalikuwa yamegeuka kuwa divai. Yeye hakujua ilikotoka, (lakini wale watumishi waliochota maji walijua). Mkuu wa karamu akamwita bwana arusi, ");
INSERT INTO swh1850_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akamwambia, “Kila mtu huandaa divai nzuri kwanza hata wakisha tosheka huandaa ile hafifu. Lakini wewe umeiweka divai nzuri mpaka sasa!” ");
INSERT INTO swh1850_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu alifanya ishara hii ya kwanza huko Kana, Galilaya, akaonyesha utukufu wake; nao wanafunzi wake wakamwamini. ");
INSERT INTO swh1850_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baada ya hayo, Yesu alishuka pamoja na mama yake, ndugu zake na wanafunzi wake, wakaenda Kafarnaumu ambako walikaa kwa siku chache. ");
INSERT INTO swh1850_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sikukuu ya Wayahudi ya Pasaka ilikuwa imekaribia; hivyo Yesu akaenda Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hekaluni aliwakuta watu wakiuza ng'ombe, kondoo na njiwa, na wavunja fedha walikuwa wamekaa kwenye meza zao. ");
INSERT INTO swh1850_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Akatengeneza mjeledi wa kamba, akawafukuza wote nje ya Hekalu pamoja na kondoo na ng'ombe wao, akazimwaga sarafu za wenye kuvunja fedha na kupindua meza zao. ");
INSERT INTO swh1850_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akawaambia wale waliokuwa wanauza njiwa, “Ondoeni vitu hivi hapa. Msiifanye nyumba ya Baba yangu kuwa soko!” ");
INSERT INTO swh1850_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanafunzi wake wakakumbuka kwamba Maandiko yasema: “Upendo wangu kwa nyumba yako waniua.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Baadhi ya Wayahudi wakamwuliza Yesu, “Utafanya muujiza gani kuonyesha kwamba unayo haki kufanya mambo haya?” ");
INSERT INTO swh1850_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akawaambia, “Vunjeni Hekalu hili, nami nitalijenga kwa siku tatu.” ");
INSERT INTO swh1850_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hapo Wayahudi wakasema, “Hekalu hili lilijengwa kwa muda wa miaka arobaini na sita. Je, wewe utalijenga kwa siku tatu?” ");
INSERT INTO swh1850_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakini Yesu alikuwa anaongea juu ya Hekalu ambalo ni mwili wake. ");
INSERT INTO swh1850_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Basi, alipofufuliwa kutoka wafu, wanafunzi wake walikumbuka kwamba alikuwa amesema hayo, wakaamini Maandiko Matakatifu na yale maneno aliyokuwa akisema Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu alipokuwa Yerusalemu kwa sikukuu ya Pasaka, watu wengi walimwamini walipoona ishara alizozifanya. ");
INSERT INTO swh1850_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu hakuwa na imani nao kwa sababu aliwajua wote. ");
INSERT INTO swh1850_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hakuhitaji kuambiwa chochote juu ya watu, maana aliyajua barabara mambo yote yaliyomo mioyoni mwao. ");
INSERT INTO swh1850_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kulikuwa na kiongozi mmoja Myahudi, wa kikundi cha Mafarisayo, jina lake Nikodemo. ");
INSERT INTO swh1850_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Siku moja alimwendea Yesu usiku, akamwambia, “Rabi, tunajua kwamba wewe ni mwalimu uliyetumwa na Mungu, maana hakuna mtu awezaye kufanya ishara unazozifanya Mungu asipokuwa pamoja naye.” ");
INSERT INTO swh1850_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu akamwambia, “Kweli nakwambia, mtu asipozaliwa upya hataweza kuuona ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo akamwuliza, “Mtu mzima awezaje kuzaliwa tena? Hawezi kuingia tumboni mwa mama yake na kuzaliwa mara ya pili!” ");
INSERT INTO swh1850_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu akamjibu, “Kweli nakwambia, mtu asipozaliwa kwa maji na Roho, hawezi kamwe kuingia katika ufalme wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mtu huzaliwa kimwili kwa baba na mama, lakini huzaliwa kiroho kwa Roho. ");
INSERT INTO swh1850_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usistaajabu kwamba nimekwambia kuwa ni lazima kuzaliwa upya. ");
INSERT INTO swh1850_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Upepo huvuma kuelekea upendako; waisikia sauti yake, lakini hujui unakotoka wala unakokwenda. Ndivyo ilivyo kwa mtu aliyezaliwa kwa Roho.” ");
INSERT INTO swh1850_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo akamwuliza, “Mambo haya yanawezekanaje?” ");
INSERT INTO swh1850_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akamjibu, “Je, wewe ni mwalimu katika Israel na huyajui mambo haya? ");
INSERT INTO swh1850_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kweli nakwambia, sisi twasema tunayoyajua na kushuhudia tuliyoyaona, lakini ninyi hamkubali ujumbe wetu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ikiwa nimewaambieni mambo ya kidunia nanyi hamniamini, mtawezaje kuamini nikiwaambieni mambo ya mbinguni? ");
INSERT INTO swh1850_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hakuna mtu aliyepata kwenda juu mbinguni isipokuwa Mwana wa Mtu ambaye ameshuka kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kama vile Mose alivyomwinua juu nyoka wa shaba kule jangwani, naye Mwana wa Mtu atainuliwa juu vivyo hivyo, ");
INSERT INTO swh1850_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili kila anayemwamini awe na uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Maana Mungu aliupenda ulimwengu hivi hata akamtoa Mwana wake wa pekee, ili kila amwaminiye asipotee, bali awe na uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Maana Mungu hakumtuma Mwanae ulimwenguni ili auhukumu ulimwengu, bali aukomboe ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Anayemwamini Mwana hahukumiwi; asiyemwamini amekwisha hukumiwa kwa sababu hakumwamini Mwana wa pekee wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na hukumu yenyewe ndiyo hii: Mwanga umekuja ulimwenguni lakini watu wakapenda giza kuliko mwanga, kwani matendo yao ni maovu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mtu atendaye maovu anauchukia mwanga, wala haji kwenye mwanga, maana hapendi matendo yake maovu yamulikwe. ");
INSERT INTO swh1850_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini mwenye kuuzingatia ukweli huja kwenye mwanga, ili matendo yake yaonekane yametendwa kwa kumtii Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baada ya hayo, Yesu alifika mkoani Yudea pamoja na wanafunzi wake. Alikaa huko pamoja nao kwa muda, akibatiza watu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane pia alikuwa akibatiza watu huko Ainoni, karibu na Salemu, maana huko kulikuwa na maji mengi. Watu walimwendea, naye akawabatiza. ");
INSERT INTO swh1850_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Wakati huo Yohane alikuwa bado hajafungwa gerezani.) ");
INSERT INTO swh1850_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ubishi ulitokea kati ya baadhi ya wanafunzi wa Yohane na Myahudi mmoja kuhusu desturi za kutawadha. ");
INSERT INTO swh1850_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Basi, wanafunzi hao wakamwendea Yohane na kumwambia, “Mwalimu, yule mtu aliyekuwa pamoja nawe ng'ambo ya Yordani na ambaye wewe ulimshuhudia, sasa naye anabatiza, na watu wote wanamwendea.” ");
INSERT INTO swh1850_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane akawaambia, “Mtu hawezi kuwa na kitu asipopewa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nanyi wenyewe mwaweza kushuhudia kuwa nilisema: Mimi siye Kristo, lakini nimetumwa ili nimtangulie! ");
INSERT INTO swh1850_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bibiarusi ni wake bwanaarusi, lakini rafiki yake bwana arusi, anayesimama na kusikiliza, hufurahi sana anapomsikia bwana arusi akisema. Ndivyo furaha yangu ilivyokamilishwa. ");
INSERT INTO swh1850_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni lazima yeye azidi kuwa maarufu, na mimi nipungue. ");
INSERT INTO swh1850_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Anayekuja kutoka juu ni mkuu kuliko wote; atokaye duniani ni wa dunia, na huongea mambo ya kidunia. Lakini anayekuja kutoka mbinguni ni mkuu kuliko wote. ");
INSERT INTO swh1850_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yeye husema yale aliyoyaona na kuyasikia, lakini hakuna mtu anayekubali ujumbe wake. ");
INSERT INTO swh1850_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lakini mtu yeyote anayekubali ujumbe wake anathibitisha kwamba Mungu ni kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yule aliyetumwa na Mungu husema maneno ya Mungu, maana Mungu humjalia mtu huyo Roho wake bila kipimo. ");
INSERT INTO swh1850_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba anampenda Mwana na amemkabidhi vitu vyote. ");
INSERT INTO swh1850_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Anayemwamini Mwana anao uzima wa milele; asiyemtii Mwana hatakuwa na uzima wa milele, bali ghadhabu ya Mungu hubaki juu yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafarisayo walisikia kwamba Yesu alikuwa anabatiza na kuwapata wanafunzi wengi kuliko Yohane. ");
INSERT INTO swh1850_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Lakini ukweli ni kwamba Yesu hakuwa anabatiza ila wanafunzi wake.) ");
INSERT INTO swh1850_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Basi, Yesu aliposikia hayo, alitoka Yudea akarudi Galilaya; ");
INSERT INTO swh1850_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","na katika safari hiyo ilimbidi apitie Samaria. ");
INSERT INTO swh1850_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Basi, akafika Sukari, mji mmoja wa Samaria, karibu na shamba ambalo Yakobo alikuwa amempa mwanawe, Yosefu. ");
INSERT INTO swh1850_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mahali hapo palikuwa na kisima cha Yakobo, naye Yesu, kutokana na uchovu wa safari, akaketi kando ya kisima. Ilikuwa yapata saa sita mchana. ");
INSERT INTO swh1850_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Basi, mwanamke mmoja Msamaria akafika kuteka maji. Yesu akamwambia, “Nipatie maji ninywe.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Wakati huo wanafunzi wake walikuwa wamekwenda mjini kununua chakula.) ");
INSERT INTO swh1850_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Lakini huyo mwanamke akamwambia, “Wewe ni Myahudi; mimi ni mwanamke Msamaria! Unawezaje kuniomba maji?” (Wayahudi hawakuwa na ushirikiano na Wasamaria katika matumizi ya vitu.) ");
INSERT INTO swh1850_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akamjibu, “Kama tu ungalijua zawadi ya Mungu na ni nani anayekwambia: Nipatie maji ninywe, ungalikwisha mwomba, naye angekupa maji yaliyo hai.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Huyo mama akasema, “Mheshimiwa, wewe huna chombo cha kutekea maji, nacho kisima ni kirefu; utapata wapi maji yaliyo hai? ");
INSERT INTO swh1850_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Au, labda wewe wajifanya mkuu kuliko babu yetu Yakobo? Yeye alitupa sisi kisima hiki; na yeye mwenyewe, watoto wake na mifugo yake walikunywa maji ya kisima hiki.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akamjibu, “Kila anayekunywa maji haya ataona kiu tena. ");
INSERT INTO swh1850_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lakini atakayekunywa maji nitakayompa mimi, hataona kiu milele. Maji nitakayompa yatakuwa ndani yake chemchemi ya maji ya uzima na kumpatia uzima wa milele.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Huyo mwanamke akamwambia, “Mheshimiwa, nipe maji hayo ili nisione kiu tena; nisije tena mpaka hapa kuteka maji.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu akamwambia, “Nenda ukamwite mumeo uje naye hapa.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Huyo mwanamke akamwambia, “Mimi sina mume.” Yesu akamwambia, “Umesema kweli, kwamba huna mume. ");
INSERT INTO swh1850_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Maana umekuwa na waume watano, na huyo unayeishi naye sasa si mume wako. Hapo umesema kweli.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Huyo Mwanamke akamwambia, “Mheshimiwa, naona ya kuwa wewe u nabii. ");
INSERT INTO swh1850_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Babu zetu waliabudu juu ya mlima huu, lakini ninyi mwasema kwamba mahali pa kumwabudu Mungu ni kule Yerusalemu.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu akamwambia, “Niamini; wakati unakuja ambapo hamtamwabudu Baba juu ya mlima huu, wala kule Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ninyi Wasamaria mnamwabudu yule msiyemjua, lakini sisi tunamjua huyo tunayemwabudu, kwa maana wokovu unatoka kwa Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakini wakati unakuja, tena umekwisha fika, ambapo wanaoabudu kweli, watamwabudu Baba kwa nguvu ya Roho; watu wanaomwabudu hivyo ndio Baba anaotaka. ");
INSERT INTO swh1850_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mungu ni Roho, na watu wataweza tu kumwabudu kweli kwa nguvu ya Roho wake.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Huyo mama akamwambia, “Najua kwamba Masiha, aitwaye Kristo, anakuja. Atakapokuja atatujulisha kila kitu.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu akamwambia, “Mimi ninayesema nawe, ndiye.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hapo wanafunzi wake wakarudi, wakastaajabu sana kuona anaongea na mwanamke. Lakini hakuna mtu aliyesema: “Unataka nini?” au, “Kwa nini unaongea na mwanamke?” ");
INSERT INTO swh1850_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Huyo mama akauacha mtungi wake pale, akaenda mjini na kuwaambia watu, ");
INSERT INTO swh1850_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Njoni mkamwone mtu aliyeniambia mambo yote niliyotenda! Je, yawezekana kuwa yeye ndiye Kristo?” ");
INSERT INTO swh1850_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Watu wakatoka mjini, wakamwendea Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wakati huohuo wanafunzi wake walikuwa wanamsihi Yesu: “Mwalimu, ule chakula.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini Yesu akawaambia, “Mimi ninacho chakula msichokijua ninyi.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wanafunzi wake wakaulizana, “Je, kuna mtu aliyemletea chakula?” ");
INSERT INTO swh1850_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu akawaambia, “Chakula changu ni kufanya anachotaka yule aliyenituma na kuitimiza kazi yake. ");
INSERT INTO swh1850_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ninyi mwasema: Bado miezi minne tu, na wakati wa mavuno utafika! Lakini mimi nawaambieni, yatazameni mashamba; mazao yako tayari kuvunwa. ");
INSERT INTO swh1850_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mvunaji anapata mshahara wake, na anakusanya mavuno kwa ajili ya uzima wa milele; hivyo mpandaji na mvunaji watafurahi pamoja. ");
INSERT INTO swh1850_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa sababu hiyo msemo huu ni kweli: Mmoja hupanda na mwingine huvuna. ");
INSERT INTO swh1850_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mimi nimewatuma mkavune mavuno ambayo hamkuyatolea jasho, wengine walifanya kazi, lakini ninyi mnafaidika kutokana na jasho lao.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamaria wengi wa kijiji kile waliamini kwa sababu ya maneno aliyosema huyo mama: “Ameniambia mambo yote niliyofanya.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wasamaria walimwendea Yesu wakamwomba akae nao; naye akakaa hapo siku mbili. ");
INSERT INTO swh1850_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Watu wengi zaidi walimwamini kwa sababu ya ujumbe wake. ");
INSERT INTO swh1850_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wakamwambia yule mama, “Sisi hatuamini tu kwa sababu ya maneno yako; sisi wenyewe tumesikia, na tunajua kwamba huyu ndiye kweli Mwokozi wa ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Baada ya siku mbili Yesu aliondoka hapo, akaenda Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Maana Yesu mwenyewe alisema waziwazi kwamba, “Nabii hapati heshima katika nchi yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Basi, alipofika Galilaya, Wagalilaya wengi walimkaribisha. Maana nao pia walikuwa kwenye sikukuu ya Pasaka, wakayaona mambo yote Yesu aliyotenda huko Yerusalemu wakati wa sikukuu hiyo. ");
INSERT INTO swh1850_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu alifika tena huko mjini Kana, mkoani Galilaya, mahali alipogeuza maji kuwa divai. Kulikuwa na ofisa mmoja aliyekuwa na mtoto mgonjwa huko Kafarnaumu. ");
INSERT INTO swh1850_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Basi, huyo ofisa aliposikia kuwa Yesu alikuwa ametoka Yudea na kufika Galilaya, alimwendea akamwomba aende kumponya mtoto wake aliyekuwa mgonjwa mahututi. ");
INSERT INTO swh1850_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu akamwambia, “Msipoona ishara na maajabu hamtaamini!” ");
INSERT INTO swh1850_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Huyo ofisa akamwambia, “Mheshimiwa, tafadhali twende kabla mwanangu hajafa.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akamwambia, “Nenda tu, mwanao yu mzima.” Huyo mtu akaamini maneno ya Yesu, akaenda zake. ");
INSERT INTO swh1850_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Alipokuwa bado njiani, watumishi wake walikutana naye, wakamwambia kwamba mwanawe alikuwa mzima. ");
INSERT INTO swh1850_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naye akawauliza saa mtoto alipopata nafuu; nao wakamwambia, “Jana saa saba mchana, homa ilimwacha.” ");
INSERT INTO swh1850_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Huyo baba akakumbuka kwamba ilikuwa ni saa ileile ambapo Yesu alimwambia: “Mwanao yu mzima.” Basi, yeye akaamini pamoja na jamaa yake yote. ");
INSERT INTO swh1850_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hii ilikuwa ishara ya pili aliyoifanya Yesu alipokuwa anatoka Yudea kwenda Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baada ya hayo kulikuwa na sikukuu ya Wayahudi, naye Yesu akaenda Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Huko Yerusalemu, karibu na mlango uitwao Mlango wa Kondoo, kulikuwa na bwawa la maji liitwalo kwa Kiebrania Bethzatha, ambalo lilikuwa na baraza tano zenye matao. ");
INSERT INTO swh1850_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Humo barazani mlikuwa na wagonjwa wengi wamekaa: vipofu, viwete na waliopooza. Walikuwa wakingojea maji yatibuliwe, ");
INSERT INTO swh1850_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","maana mara kwa mara malaika alishuka majini nyakati fulani na kuyatibua. Mtu yeyote aliyekuwa wa kwanza kuingia majini baada ya maji kutibuliwa, alipona ugonjwa wowote aliokuwa nao. ");
INSERT INTO swh1850_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Basi, hapo palikuwa na mtu mmoja aliyekuwa mgonjwa kwa muda wa miaka thelathini na minane. ");
INSERT INTO swh1850_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Naye alipomwona huyo mtu amelala hapo, akatambua kwamba alikuwa amekaa hapo kwa muda mrefu, akamwuliza, “Je, wataka kupona?” ");
INSERT INTO swh1850_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Naye akajibu, “Mheshimiwa, mimi sina mtu wa kunipeleka majini wakati yanapotibuliwa. Kila nikijaribu kuingia, mtu mwingine hunitangulia.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu akamwambia, “Inuka, chukua mkeka wako utembee.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mara huyo mtu akapona, akachukua mkeka wake, akatembea. Jambo hili lilifanyika siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kwa hiyo baadhi ya Wayahudi wakamwambia huyo mtu aliyeponywa, “Leo ni Sabato, si halali kubeba mkeka wako.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lakini yeye akawaambia, “Yule mtu aliyeniponya ndiye aliyeniambia: Chukua mkeka wako, tembea.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nao wakamwuliza, “Huyo mtu aliyekwambia: Chukua mkeka wako, tembea, ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lakini yeye hakumjua huyo mtu aliyemponya, maana Yesu alikuwa amekwisha ondoka mahali hapo, kwani palikuwa na umati mkubwa wa watu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Basi, baadaye Yesu alimkuta huyo aliyeponywa Hekaluni, akamwambia, “Sasa umepona; usitende dhambi tena, usije ukapatwa na jambo baya zaidi.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Huyo mtu akaenda, akawaambia viongozi wa Wayahudi kwamba Yesu ndiye aliyemponya. ");
INSERT INTO swh1850_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa vile Yesu alifanya jambo hilo siku ya Sabato, Wayahudi walianza kumdhulumu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Basi, Yesu akawaambia, “Baba yangu anafanya kazi daima, nami pia nafanya kazi.” ");
INSERT INTO swh1850_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa sababu ya maneno haya, viongozi wa Wayahudi walizidi kutafuta njia ya kumwua Yesu: si kwa kuwa aliivunja Sheria ya Sabato tu, bali pia kwa kuwa alisema kwamba Mungu ni Baba yake, na hivyo akajifanya sawa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu akawaambia, “Kweli nawaambieni, Mwana hawezi kufanya kitu peke yake; anaweza tu kufanya kile anachomwona Baba akikifanya. Maana kile anachofanya Baba, Mwana hukifanya vilevile. ");
INSERT INTO swh1850_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Baba ampenda Mwana, na humwonyesha kila kitu anachokifanya yeye mwenyewe, tena atamwonyesha mambo makuu kuliko haya, nanyi mtastaajabu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kama vile Baba huwafufua wafu na kuwapa uzima, vivyo hivyo naye Mwana huwapa uzima wale anaopenda. ");
INSERT INTO swh1850_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baba hamhukumu mtu yeyote; shughuli yote ya hukumu amemkabidhi Mwana, ");
INSERT INTO swh1850_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili watu wote wamheshimu Mwana kama vile wanavyomheshimu Baba. Asiyemheshimu Mwana hamheshimu Baba ambaye amemtuma. ");
INSERT INTO swh1850_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kweli nawaambieni, anayesikia neno langu, na kumwamini yule aliyenituma, anao uzima wa milele. Hatahukumiwa kamwe, bali amekwisha pita kutoka kifo na kuingia katika uzima. ");
INSERT INTO swh1850_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kweli nawaambieni, wakati unakuja, tena umekwisha fika, ambapo wafu wataisikia sauti ya Mwana wa Mungu, nao watakaoisikia, wataishi. ");
INSERT INTO swh1850_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kama vile Baba alivyo asili ya uhai, ndivyo pia alivyomjalia Mwanawe kuwa asili ya uhai. ");
INSERT INTO swh1850_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tena amempa mamlaka ya kuhukumu kwa sababu yeye ni Mwana wa Mtu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Msistaajabie jambo hili; maana wakati unakuja ambapo wote waliomo makaburini wataisikia sauti yake, ");
INSERT INTO swh1850_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nao watafufuka: wale waliotenda mema watafufuka na kuishi, na wale waliotenda maovu watafufuka na kuhukumiwa. ");
INSERT INTO swh1850_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mimi siwezi kufanya kitu kwa uwezo wangu mwenyewe. Mimi nina hukumu kama ninavyosikia kutoka kwa Baba, nayo hukumu yangu ni ya haki. Nia yangu si kufanya nipendavyo mwenyewe, bali apendavyo yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nikijishuhudia mimi mwenyewe, ushahidi wangu hauwezi kukubaliwa kuwa wa kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lakini yuko mwingine ambaye hutoa ushahidi juu yangu, nami najua kwamba yote anayosema juu yangu ni ya kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ninyi mlituma ujumbe kwa Yohane naye aliushuhudia ukweli. ");
INSERT INTO swh1850_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Si kwamba mimi nautegemea ushahidi wa wanadamu, lakini nasema mambo haya ili mpate kuokolewa. ");
INSERT INTO swh1850_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane alikuwa kama taa iliyokuwa ikiwaka na kuangaza, nanyi mlikuwa tayari kufurahia mwanga huo kwa kitambo. ");
INSERT INTO swh1850_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Lakini mimi nina ushahidi juu yangu ambao ni mkuu zaidi kuliko ule wa Yohane. Kwa maana kazi ninazofanya, kazi alizonipa Baba nizifanye, ndizo zinazonishuhudia kwamba Baba ndiye aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naye Baba aliyenituma hunishuhudia. Ninyi hamjapata kamwe kusikia sauti yake, wala kuuona uso wake, ");
INSERT INTO swh1850_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na ujumbe wake haukai ndani yenu maana hamkumwamini yule aliyemtuma. ");
INSERT INTO swh1850_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ninyi huyachunguza Maandiko Matakatifu mkidhani kwamba ndani yake mtapata uzima wa milele; na kumbe maandiko hayohayo yananishuhudia! ");
INSERT INTO swh1850_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hata hivyo, ninyi hamtaki kuja kwangu ili mpate uzima. ");
INSERT INTO swh1850_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Shabaha yangu si kupata sifa kutoka kwa watu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini nawajua ninyi, najua kwamba upendo kwa Mungu haumo mioyoni mwenu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mimi nimekuja kwa mamlaka ya Baba yangu, lakini hamnipokei; bali mtu mwingine akija kwa mamlaka yake mwenyewe, mtampokea. ");
INSERT INTO swh1850_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwawezaje kuamini, hali ninyi mnapenda kupokea sifa kutoka kwenu ninyi wenyewe, wala hamtafuti sifa kutoka kwake yeye aliye peke yake Mungu? ");
INSERT INTO swh1850_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Msifikiri kwamba mimi nitawashtaki kwa Baba. Mose ambaye ninyi mmemtumainia ndiye atakayewashtaki. ");
INSERT INTO swh1850_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kama kweli mngemwamini Mose, mngeniamini na mimi pia; maana Mose aliandika juu yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lakini hamuyaamini yale aliyoandika, mtawezaje basi, kuamini maneno yangu?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Baada ya hayo, Yesu alivuka ziwa Galilaya (au Ziwa Tiberia). ");
INSERT INTO swh1850_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Umati mkubwa wa watu ulimfuata kwa sababu watu hao walikuwa wameona ishara alizokuwa akifanya kwa kuwaponya wagonjwa. ");
INSERT INTO swh1850_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu alipanda mlimani, akaketi pamoja na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sikukuu ya Wayahudi iitwayo Pasaka ilikuwa imekaribia. ");
INSERT INTO swh1850_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Basi, Yesu na alipotazama na kuona umati wa watu ukija kwake, alimwambia Filipo, “Tununue wapi mikate ili watu hawa wapate kula?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Alisema hivyo kwa kumjaribu Filipo, kwani alijua mwenyewe atakalofanya.) ");
INSERT INTO swh1850_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo akamjibu, “Mikate ya denari mia mbili za fedha haiwatoshi watu hawa hata kama ila mmoja atapata kipande kidogo tu!” ");
INSERT INTO swh1850_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mmoja wa wanafunzi wake aitwaye Andrea, nduguye Simoni Petro, akamwambia, ");
INSERT INTO swh1850_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yupo hapa mtoto mmoja aliye na mikate mitano ya shayiri na samaki wawili; lakini hivi vyatosha nini kwa watu wengi kama hawa?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu akasema, “Waketisheni watu.” Palikuwa na nyasi tele mahali hapo. Basi, watu wakaketi, jumla yapata wanaume elfu tano. ");
INSERT INTO swh1850_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu akaitwaa ile mikate, akamshukuru Mungu, akawagawia watu waliokuwa wameketi; akafanya vivyo hivyo na wale samaki, kila mtu akapata kadiri alivyotaka. ");
INSERT INTO swh1850_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Watu waliposhiba Yesu akawaambia wanafunzi wake, “Kusanyeni vipande vilivyobaki visipotee.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Basi, wakakusanya vipande vya mikate ya shayiri walivyobakiza wale watu waliokula, wakajaza vikapu kumi na viwili. ");
INSERT INTO swh1850_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Watu walipoiona ishara hiyo aliyoifanya Yesu, wakasema, “Hakika huyu ndiye nabii anayekuja ulimwenguni.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu akajua ya kuwa watu walitaka kumchukua wamfanye mfalme, akaondoka tena, akaenda mlimani peke yake. ");
INSERT INTO swh1850_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ilipokuwa jioni wanafunzi wake waliteremka hadi ziwani, ");
INSERT INTO swh1850_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wakapanda mashua ili wavuke kwenda Kafarnaumu. Giza lilikuwa limeingia, na Yesu alikuwa hajawafikia bado. ");
INSERT INTO swh1850_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ziwa likaanza kuchafuka kwa sababu upepo mkali ulikuwa unavuma. ");
INSERT INTO swh1850_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wanafunzi walipokuwa wamekwenda umbali wa kilomita tano au sita, walimwona Yesu akitembea juu ya maji, anakaribia mashua; wakaogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu akawaambia, “Ni mimi, msiogope!” ");
INSERT INTO swh1850_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Walifurahi kumchukua Yesu katika mashua; na mara mashua ikawasili nchi kavu walipokuwa wanakwenda. ");
INSERT INTO swh1850_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kesho yake umati wa watu wale waliobaki upande wa pili wa ziwa walitambua kwamba kulikuwa na mashua moja tu pale, na Yesu hakuingia katika mashua pamoja na wanafunzi wake, ila wanafunzi hao walikuwa wamekwenda zao peke yao. ");
INSERT INTO swh1850_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mashua nyingine kutoka Tiberia zilifika mahali hapo watu walipokula ile mikate, Bwana alipokwisha mshukuru Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Basi, hao watu walipogundua kwamba Yesu na wanafunzi wake hawakuwapo mahali hapo, walipanda mashua, wakaenda Kafarnaumu wakimtafuta. ");
INSERT INTO swh1850_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wale watu walipomkuta Yesu ng'ambo ya pili wa ziwa walimwuliza, “Mwalimu, ulifika lini hapa?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu akawajibu, “Kweli nawaambieni, mnanitafuta si kwa kuwa mmeona ishara, bali kwa sababu mlikula ile mikate mkashiba. ");
INSERT INTO swh1850_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Msikishughulikie chakula kiharibikacho; kishugulikieni chakula kidumucho kwa ajili ya uzima wa milele. Mwana wa Mtu ambaye Baba amemthibitisha atawapeni chakula hicho.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wao wakamwuliza, “Tufanye nini ili tuweze kuzitenda kazi za Mungu?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akawajibu, “Hii ndiyo kazi anayotaka Mungu muifanye: kumwamini yule aliyemtuma.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hapo wakamwambia, “Utafanya ishara gani ili tuione tupate kukuamini? Utafanya kitu gani? ");
INSERT INTO swh1850_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wazee wetu walikula mana kule jangwani, kama yasemavyo Maandiko: Aliwalisha mkate kutoka mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu akawaambia, “Kweli nawaambieni, Mose hakuwapeni mkate kutoka mbinguni; Baba yangu ndiye awapaye ninyi mkate halisi kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Maana mkate wa Mungu ni yule ashukaye kutoka mbinguni na aupaye ulimwengu uzima.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Basi, wakamwambia, “Mheshimiwa, tupe daima mkate huo.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu akawaambia, “Mimi ndimi mkate wa uzima. Anayekuja kwangu hataona njaa; anayeniamini hataona kiu kamwe. ");
INSERT INTO swh1850_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lakini niliwaambieni kwamba ingawa mmeniona hamniamini. ");
INSERT INTO swh1850_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wote anaonipa Baba watakuja kwangu; nami sitamtupa nje yeyote anayekuja kwangu, ");
INSERT INTO swh1850_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kwani nimeshuka kutoka mbinguni si kwa ajili ya kufanya matakwa yangu, ila kutimiza matakwa ya yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na matakwa ya yule aliyenituma ndiyo haya: nisimpoteze hata mmoja kati ya wale alionipa, ila niwafufue wote Siku ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maana anachotaka Baba yangu ndicho hiki: kila amwonaye Mwana na kumwamini awe na uzima wa milele; nami nitamfufua Siku ya mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Basi, Wayahudi wakaanza kunung'unika kwa kuwa alisema: “Mimi ni mkate ulioshuka kutoka mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wakasema, “Je, huyu si mwana wa Yosefu? Tunawajua baba yake na mama yake! Basi, anawezaje kusema kwamba ameshuka kutoka mbinguni?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu akawaambia, “Acheni kunung'unika ninyi kwa ninyi. ");
INSERT INTO swh1850_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hakuna mtu awezaye kuja kwangu, Baba aliyenituma asipomvuta kwangu; nami nitamfufua mtu huyo Siku ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Manabii wameandika: Watu wote watafundishwa na Mungu. Kila mtu anayemsikia Baba na kujifunza kutoka kwake, huja kwangu. ");
INSERT INTO swh1850_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hii haina maana kwamba yupo mtu aliyemwona Baba, isipokuwa yule aliyetoka kwa Mungu; huyo ndiye aliyemwona Baba. ");
INSERT INTO swh1850_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kweli, nawaambieni, anayeamini anao uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mimi ni mkate wa uzima. ");
INSERT INTO swh1850_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wazee wenu walikula mana kule jangwani, lakini walikufa. ");
INSERT INTO swh1850_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Huu ndio mkate kutoka mbinguni; mkate ambao anayekula hatakufa. ");
INSERT INTO swh1850_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mimi ni mkate hai ulioshuka kutoka mbinguni. Mtu yeyote akila mkate huu ataishi milele. Na mkate nitakaompa ni mwili wangu ninaoutoa kwa ajili ya uzima wa ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndipo Wayahudi wakaanza kubishana kati yao: ");
INSERT INTO swh1850_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu akawaambia, “Kweli nawaambieni, msipokula mwili wa Mwana wa Mtu na kunywa damu yake, hamtakuwa na uzima ndani yenu. ");
INSERT INTO swh1850_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Anayekula mwili wangu na kunywa damu yangu anao uzima wa milele nami nitamfufua siku ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maana mwili wangu ni chakula cha kweli, na damu yangu ni kinywaji cha kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aulaye mwili wangu na kunywa damu yangu, akaa ndani yangu, nami nakaa ndani yake. ");
INSERT INTO swh1850_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baba aliye hai alinituma, nami naishi kwa sababu yake; vivyo hivyo anilaye mimi ataishi pia kwa sababu yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Basi, huu ndio mkate ulioshuka kutoka mbinguni; si kama mana waliyokula babu zetu, wakafa. Aulaye mkate huu ataishi milele.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu alisema hayo alipokuwa akifundisha katika sunagogi kule Kafarnaumu. ");
INSERT INTO swh1850_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Basi, wengi wa wafuasi wake waliposikia hayo, wakasema, “Haya ni mambo magumu! Nani awezaye kuyasikiliza?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu alijua bila kuambiwa na mtu kwamba wanafunzi wake walikuwa wananung'unika juu ya jambo hilo, akawauliza, “Je, jambo hili linawafanya muwe na mashaka? ");
INSERT INTO swh1850_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Itakuwaje basi, mtakapomwona Mwana wa Mtu akipanda kwenda kule alikokuwa kwanza? ");
INSERT INTO swh1850_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Roho ndiye atiaye uzima; binadamu peke yake hawezi. Maneno niliyowaambieni ni Roho, ni uzima. ");
INSERT INTO swh1850_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hata hivyo, wako baadhi yenu wasioamini.” (Yesu alisema hivyo kwani alijua tangu mwanzo ni kina nani wasioamini, na pia ni nani atakayemsaliti.) ");
INSERT INTO swh1850_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kisha akasema, “Ndiyo maana niliwaambieni kwamba hakuna awezaye kuja kwangu asipowezeshwa na Baba yangu.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kutokana na hayo, wengi wa wafuasi wake walirudi nyuma wasiandamane naye tena. ");
INSERT INTO swh1850_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Basi, Yesu akawauliza wale kumi na wawili, “Je, nanyi pia mwataka kwenda zenu?” ");
INSERT INTO swh1850_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petro akamjibu, “Bwana, tutakwenda kwa nani? Wewe unayo maneno yaletayo uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sisi tunaamini, na tunajua kwamba wewe ndiwe yule Mtakatifu wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akawaambia, “Je, sikuwachagua ninyi kumi na wawili? Hata hivyo, mmoja wenu ni Ibilisi!” ");
INSERT INTO swh1850_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu alisema hayo juu ya Yuda, mwana wa Simoni Iskarioti; maana huyu alikuwa ndiye atakayemsaliti, ingawa alikuwa mmoja wa wale kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Baada ya hayo, Yesu alikuwa akitembea katika Galilaya. Hakutaka kutembea mkoani Yudea kwa sababu viongozi wa Wayahudi walikuwa wanataka kumwua. ");
INSERT INTO swh1850_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sikukuu ya Vibanda ya Wayahudi ilikuwa imekaribia. ");
INSERT INTO swh1850_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Basi ndugu zake wakamwambia, “Ondoka hapa uende Yudea ili wanafunzi wako wazione kazi unazozifanya. ");
INSERT INTO swh1850_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mtu hafanyi mambo kwa siri kama anataka kujulikana kwa watu. Maadam unafanya mambo haya, basi, jidhihirishe kwa ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Hata ndugu zake hawakumwamini!) ");
INSERT INTO swh1850_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Basi, Yesu akawaambia, “Wakati wangu ufaao haujafika bado. Lakini kwenu ninyi kila wakati unafaa. ");
INSERT INTO swh1850_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ulimwengu hauwezi kuwachukia ninyi, lakini mimi wanichukia kwa sababu mimi nauambia wazi kwamba matendo yake ni maovu. ");
INSERT INTO swh1850_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ninyi nendeni kwenye sikukuu hiyo. Mimi siendi kwenye sikukuu hiyo, maana saa yangu ifaayo haijafika.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Alisema hayo kisha akabaki huko Galilaya. ");
INSERT INTO swh1850_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Baada ya ndugu zake kwenda kwenye sikukuu, Yesu naye alikwenda, lakini hakuenda kwa hadhara bali kwa siri. ");
INSERT INTO swh1850_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Viongozi wa Wayahudi walikuwa wanamtafuta kwenye sikukuu hiyo; Wakauliza: “Yuko wapi?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kulikuwa na minong'ono mingi katika umati wa watu. Baadhi yao walisema, “Ni mtu mwema.” Wengine walisema, “La! Anawapotosha watu.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hata hivyo hakuna mtu aliyethubutu kusema, habari zake hadharani kwa kuwaogopa viongozi wa Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sikukuu hiyo ilipofikia katikati, Yesu naye alikwenda Hekaluni, akaanza kufundisha. ");
INSERT INTO swh1850_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Basi, Wayahudi wakashangaa na kusema “Mtu huyu amepataje elimu naye hakusoma shuleni?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hapo Yesu akawajibu, “Mafundisho ninayofundisha si yangu, bali ni yake yeye aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mtu anayependa kufanya yale anayotaka Mungu, atajua kama mafundisho yangu yametoka kwa Mungu, au mimi najisemea tu mwenyewe. ");
INSERT INTO swh1850_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yeye anayejisemea tu mwenyewe anatafuta sifa yake mwenyewe; lakini anayetafuta sifa ya yule aliyemtuma, huyo ni mwaminifu, na ndani yake hamna uovu wowote. ");
INSERT INTO swh1850_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Je, Mose hakuwapeni Sheria? Hata hivyo, hakuna hata mmoja wenu anayeishika Sheria. Kwa nini mnataka kuniua?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hapo watu wakamjibu, “Una wazimu wewe! Nani anataka kukuua?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akawajibu, “Kuna jambo moja nililofanya, nanyi mnalistaajabia. ");
INSERT INTO swh1850_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose aliwapeni ile desturi ya kutahiri. (Si kwamba desturi hiyo ilitoka kwa Mose, bali ilitoka kwa mababu). Sasa ninyi humtahiri mtu hata siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ikiwa basi, mtu hutahiriwa hata siku ya Sabato kusudi Sheria ya Mose isivunjwe, mbona mnanikasirikia kwa sababu nimemfanya mtu kuwa mzima kabisa siku ya Sabato? ");
INSERT INTO swh1850_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Msihukumu mambo kwa nje tu; toeni hukumu ya haki.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Baadhi ya watu wa Yerusalemu walisema, “Je, yule mtu wanayemtafuta wamuue si huyu? ");
INSERT INTO swh1850_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tazameni sasa! Anawaonya hadharani, wala hakuna mtu anayemwambia hata neno. Je, yawezekana kuwa viongozi wametambua kweli kwamba huyu ndiye Kristo? ");
INSERT INTO swh1850_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kristo atakapokuja hakuna mtu atakayejua mahali alikotoka, lakini sisi tunajua alikotoka mtu huyu!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Basi, Yesu alipokuwa anafundisha Hekaluni alipaaza sauti na kusema, “Ati mnanijua; hata nilikotoka mnakujua! Hata hivyo, sikuja kwa mamlaka yangu mwenyewe; ila yeye aliyenituma mimi ni wa kweli, nanyi hamumjui. ");
INSERT INTO swh1850_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Lakini mimi namjua kwa sababu nimetoka kwake, naye ndiye aliyenituma.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Basi, watu wakataka kumtia nguvuni, lakini hakuna mtu aliyethubutu kumkamata kwa sababu saa yake ilikuwa haijafika bado. ");
INSERT INTO swh1850_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wengi katika ule umati wa watu walimwamini, wakasema, “Je, Kristo akija atafanya ishara kubwa zaidi kuliko alizozifanya huyu?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarisayo waliwasikia watu wakinong'ona maneno hayo juu ya Yesu. Basi, wao pamoja na makuhani wakuu wakawatuma walinzi wamtie nguvuni. ");
INSERT INTO swh1850_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu akasema, “Bado niko nanyi kwa muda mfupi, kisha nitamwendea yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mtanitafuta lakini hamtaniona, maana pale nitakapokuwa ninyi hamwezi kufika.” ");
INSERT INTO swh1850_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Viongozi wa Wayahudi wakasema wao kwa wao, “Mtu huyu atakwenda wapi ambapo hatutaweza kumpata? Atakwenda kwa Wayahudi waliotawanyika kati ya Wagiriki, na kuwafundisha Wagiriki? ");
INSERT INTO swh1850_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ana maana gani anaposema: Mtanitafuta lakini hamtanipata, na mahali nitakapokuwa ninyi hamwezi kufika?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Siku ya mwisho ya sikukuu hiyo ilikuwa siku maalum. Yesu alisimama, akasema kwa sauti kubwa, “Aliye na kiu na aje kwangu anywe. ");
INSERT INTO swh1850_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kama yasemavyo Maandiko Matakatifu: Anayeniamini mimi, mito ya maji yenye uzima itatiririka kutoka moyoni mwake!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Alisema hayo kumhusu Roho ambaye wale waliomwamini yeye watampokea. Wakati huo Roho alikuwa hajafika kwa sababu Yesu alikuwa hajatukuzwa bado.) ");
INSERT INTO swh1850_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Baadhi ya watu katika ule umati walisikia maneno hayo, wakasema, “Kweli mtu huyu ndiye yule nabii!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wengine wakasema, “Huyu ndiye Kristo!” Lakini wengine walisema, “Je, yawezekana Kristo akatoka Galilaya? ");
INSERT INTO swh1850_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiko Matakatifu yasemaje? Yanasema: Kristo atatoka katika ukoo wa Daudi, na atazaliwa Bethlehemu, mji wa Daudi!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Basi, kukatokea mafarakano juu yake katika ule umati wa watu. ");
INSERT INTO swh1850_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Baadhi ya watu walitaka kumtia nguvuni lakini hakuna aliyejaribu kumkamata. ");
INSERT INTO swh1850_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kisha wale walinzi wakarudi kwa makuhani wakuu na Mafarisayo; nao wakawauliza, “Kwa nini hamkumleta?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Walinzi wakawajibu, “Hakuna mtu aliyepata kamwe kusema kama asemavyo mtu huyu!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafarisayo wakawauliza, “Je, nanyi pia mmedanganyika? ");
INSERT INTO swh1850_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Je, mmekwisha mwona hata mmoja wa viongozi wa watu, au mmoja wa Mafarisayo aliyemwamini? ");
INSERT INTO swh1850_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lakini umati huu haujui Sheria ya Mose; umelaaniwa!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mmoja wao alikuwa Nikodemo ambaye hapo awali alikuwa amemwendea Yesu. Basi, yeye akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Je, Sheria yetu humhukumu mtu kabla ya kumsikia kwanza na kujua anafanya nini?” ");
INSERT INTO swh1850_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nao wakamjibu, “Je, wewe pia umetoka Galilaya? Haya, kayachunguze Maandiko Matakatifu nawe utaona kwamba Galilaya hakutoki kamwe nabii!” ");
INSERT INTO swh1850_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Basi, wote wakaondoka, kila mtu akaenda zake; ");
INSERT INTO swh1850_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","lakini Yesu akaenda kwenye mlima wa Mizeituni. ");
INSERT INTO swh1850_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kesho yake asubuhi na mapema alikwenda tena Hekaluni. Watu wote wakamwendea, naye akaketi akawa anawafundisha. ");
INSERT INTO swh1850_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Basi, walimu wa Sheria na Mafarisayo wakamletea mwanamke mmoja aliyefumaniwa katika uzinzi. Wakamsimamisha katikati yao. ");
INSERT INTO swh1850_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kisha wakamwuliza Yesu, “Mwalimu! Mwanamke huyu alifumaniwa katika uzinzi. ");
INSERT INTO swh1850_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Katika Sheria yetu Mose alituamuru mwanamke kama huyu apigwe mawe. Basi, wewe wasemaje?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Walisema hivyo kumjaribu, wapate kisa cha kumshtaki. Lakini Yesu akainama chini, akaandika ardhini kwa kidole. ");
INSERT INTO swh1850_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Walipozidi kumwuliza, Yesu akainuka, akawaambia, “Mtu asiye na dhambi miongoni mwenu na awe wa kwanza kumpiga jiwe.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kisha akainama tena, akawa anaandika ardhini. ");
INSERT INTO swh1850_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waliposikia hivyo, wakaanza kutoweka mmojammoja, wakitanguliwa na wazee. Yesu akabaki peke yake, na yule mwanamke amesimama palepale. ");
INSERT INTO swh1850_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu alipoinuka akamwuliza huyo mwanamke, “Wako wapi wale watu? Je, hakuna hata mmoja aliyekuhukumu?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Huyo mwanamke akamjibu, “Mheshimiwa, hakuna hata mmoja!” Naye Yesu akamwambia, “Wala mimi sikuhukumu. Nenda zako; na tangu sasa usitende dhambi tena.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu alipozungumza nao tena, aliwaambia, “Mimi ndimi mwanga wa ulimwengu. Anayenifuata mimi hatembei kamwe gizani, bali atakuwa na mwanga wa uzima.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Basi, Mafarisayo wakamwambia, “Wewe unajishuhudia mwenyewe; kwa hiyo ushahidi wako si halali.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu akawajibu, “Hata kama ninajishuhudia mwenyewe, ushahidi wangu ni wa kweli kwa sababu mimi najua nilikotoka na ninakokwenda. Lakini ninyi hamjui nilikotoka wala ninakokwenda. ");
INSERT INTO swh1850_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ninyi mnahukumu kwa fikira za kibinadamu, lakini mimi simhukumu mtu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hata nikihukumu, hukumu yangu ni ya haki kwa sababu mimi siko peke yangu; Baba aliyenituma yuko pamoja nami. ");
INSERT INTO swh1850_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Imeandikwa katika Sheria yenu ya kwamba ushahidi wa watu wawili ni halali. ");
INSERT INTO swh1850_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mimi najishuhudia mwenyewe, naye Baba aliyenituma, ananishuhudia pia.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hapo wakamwuliza, “Baba yako yuko wapi?” Yesu akawajibu “Ninyi hamnijui mimi wala hamumjui Baba. Kama mngenijua mimi, mngemjua na Baba yangu pia.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu alisema maneno hayo kwenye chumba cha hazina alipokuwa anafundisha Hekaluni. Wala hakuna mtu aliyemtia nguvuni, kwa sababu saa yake ilikuwa haijafika bado. ");
INSERT INTO swh1850_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu akawaambia tena, “Naenda zangu nanyi mtanitafuta, lakini mtakufa katika dhambi zenu. Niendako mimi, ninyi hamwezi kufika.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Basi, viongozi wa Wayahudi wakasema, “Je, atajiua? Mbona anasema: Niendako ninyi hamwezi kufika?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu akawaambia, “Ninyi mmetoka papa hapa chini, mimi nimetoka juu; ninyi ni wa ulimwengu huu, mimi si wa ulimwengu huu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndiyo maana niliwaambieni mtakufa katika dhambi zenu. Kama msipoamini kwamba Mimi ndimi, mtakufa katika dhambi zenu.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nao wakamwuliza, “Wewe ni nani?” Yesu akawajibu, “Nimewaambieni tangu mwanzo! ");
INSERT INTO swh1850_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ninayo mengi ya kusema na kuhukumu juu yenu. Lakini yule aliyenituma ni kweli; nami nauambia ulimwengu mambo yale tu niliyoyasikia kutoka kwake.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hawakuelewa kwamba Yesu alikuwa akisema nao juu ya Baba. ");
INSERT INTO swh1850_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Basi, Yesu akawaambia, “Mtakapokwisha mwinua Mwana wa Mtu hapo ndipo mtakapojua kwamba Mimi ndimi, na kwamba sifanyi chochote mimi mwenyewe, ila nasema tu yale Baba aliyonifundisha. ");
INSERT INTO swh1850_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yule aliyenituma yuko pamoja nami; yeye hakuniacha peke yangu kwani nafanya daima yale yanayompendeza.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Baada ya kusema hayo watu wengi walimwamini. ");
INSERT INTO swh1850_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Basi, Yesu akawaambia wale Wayahudi waliomwamini, “Kama mkiyazingatia mafundisho yangu mtakuwa kweli wanafunzi wangu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mtaujua ukweli, nao ukweli utawapeni uhuru.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nao wakamjibu, “Sisi ni wazawa wa Abrahamu, na hatujapata kamwe kuwa watumwa wa mtu yeyote yule. Una maana gani unaposema: mtakuwa huru?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu akawajibu, “Kweli nawaambieni, kila mtu anayetenda dhambi ni mtumwa wa dhambi. ");
INSERT INTO swh1850_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mtumwa hana makao ya kudumu nyumbani, lakini mwana anayo makao ya kudumu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kama mwana akiwapeni uhuru mtakuwa huru kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Najua kwamba ninyi ni wazawa wa Abrahamu. Hata hivyo, mnataka kuniua kwa sababu hamuyakubali mafundisho yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mimi nasema yale aliyonionyesha Baba, lakini ninyi mwafanya yale aliyowaambieni baba yenu.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wao wakamjibu, “Baba yetu ni Abrahamu!” Yesu akawaambia, “Kama ninyi mngekuwa watoto wa Abrahamu, mngefanya kama alivyofanya Abrahamu, ");
INSERT INTO swh1850_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mimi nimewaambieni ukweli niliousikia kwa Mungu; hata hivyo, ninyi mwataka kuniua. Abrahamu hakufanya hivyo! ");
INSERT INTO swh1850_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ninyi mnafanya mambo yaleyale aliyofanya babu yenu.” Wao wakamwambia, “Sisi si watoto haramu! Tunaye baba mmoja tu, yaani Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu akawaambia, “Kama Mungu angekuwa Baba yenu, mngenipenda mimi, maana mimi nilitoka kwa Mungu na sasa niko hapa. Sikuja kwa mamlaka yangu mwenyewe, ila yeye alinituma. ");
INSERT INTO swh1850_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwa nini hamwelewi hayo ninayosema? Ni kwa kuwa hamwezi kuusikiliza ujumbe wangu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ninyi ni watoto wa baba yenu Ibilisi na mnataka tu kutekeleza tamaa za baba yenu. Yeye alikuwa muuaji tangu mwanzo; hana msimamo katika ukweli, kwani ukweli haumo ndani yake. Kila asemapo uongo, husema kutokana na hali yake ya maumbile, maana yeye ni mwongo na baba wa uongo. ");
INSERT INTO swh1850_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mimi nasema ukweli, na ndiyo maana ninyi hamniamini. ");
INSERT INTO swh1850_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nani kati yenu awezaye kuthibitisha kuwa mimi nina dhambi? Ikiwa basi nasema ukweli, kwa nini hamniamini? ");
INSERT INTO swh1850_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aliye wa Mungu husikiliza maneno ya Mungu. Lakini ninyi hamsikilizi kwa sababu ninyi si (watu wa) Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi wakamwambia, “Je, hatukusema kweli kwamba wewe ni Msamaria, na tena una pepo?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu akajibu, “Mimi sina pepo; mimi namheshimu Baba yangu, lakini ninyi hamniheshimu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mimi sijitafutii utukufu wangu mwenyewe; yuko mmoja mwenye kuutafuta utukufu huo, naye ni hakimu. ");
INSERT INTO swh1850_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kweli nawaambieni, anayeuzingatia ujumbe wangu hatakufa milele.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Basi, Wayahudi wakasema, “Sasa tunajua kweli kwamba wewe ni mwendawazimu! Abrahamu alikufa, na manabii pia walikufa, nawe wasema ati, Anayeuzingatia ujumbe wangu hatakufa milele! ");
INSERT INTO swh1850_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Je, unajifanya mkuu zaidi kuliko baba yetu Abrahamu ambaye alikufa? Hata na manabii walikufa. Wewe unajifanya kuwa nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akawajibu, “Nikijitukuza mwenyewe, utukufu wangu si kitu. Baba yangu ambaye ninyi mwasema ni Baba yenu, ndiye anayenitukuza. ");
INSERT INTO swh1850_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ninyi hamjapata kumjua, lakini mimi namjua. Na, nikisema simjui, nitakuwa mwongo kama ninyi. Mimi namjua na ninashika neno lake. ");
INSERT INTO swh1850_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abrahamu, baba yenu, alishangilia aione siku yangu; naye aliiona, akafurahi.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Basi, Wayahudi wakamwambia, “Wewe hujatimiza miaka hamsini bado, nawe umemwona Abrahamu?” ");
INSERT INTO swh1850_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu akawaambia, “Kweli nawaambieni, kabla Abrahamu hajazaliwa, mimi niko.” ");
INSERT INTO swh1850_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hapo wakaokota mawe ili wamtupie, lakini Yesu akajificha, akatoka Hekaluni. ");
INSERT INTO swh1850_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu alipokuwa akipita alimwona mtu mmoja, kipofu tangu kuzaliwa. ");
INSERT INTO swh1850_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Basi, wanafunzi wakamwuliza, “Mwalimu! Ni nani aliyetenda dhambi: mtu huyu, ama wazazi wake, hata akazaliwa kipofu?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akajibu, “Jambo hili halikutukia kwa sababu ya dhambi zake yeye, wala dhambi za wazazi wake; ila alizaliwa kipofu ili nguvu ya Mungu ionekane ikifanya kazi ndani yake. ");
INSERT INTO swh1850_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kukiwa bado mchana yatupasa kuendelea kufanya kazi za yule aliyenituma; maana usiku unakuja ambapo mtu hawezi kufanya kazi. ");
INSERT INTO swh1850_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wakati ningali ulimwenguni, mimi ni mwanga wa ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Baada ya kusema hayo, akatema mate chini, akafanyiza tope, akampaka yule kipofu machoni, ");
INSERT INTO swh1850_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","akamwambia, “Nenda ukanawe katika bwawa la Siloamu.” (maana ya jina hili ni “aliyetumwa”). Basi, huyo kipofu akaenda, akanawa, kisha akarudi akiwa anaona. ");
INSERT INTO swh1850_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Basi, jirani zake na wale waliokuwa wanajua kwamba hapo awali alikuwa maskini mwombaji, wakasema, “Je, huyu siye yule maskini aliyekuwa akiketi na kuomba?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Baadhi yao wakasema, “Ndiye.” Wengine wakasema, “La! Ila anafanana naye.” Lakini huyo aliyekuwa kipofu akasema, “Ni mimi!” ");
INSERT INTO swh1850_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Basi, wakamwuliza, “Sasa, macho yako yalipataje kufumbuliwa?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naye akawajibu, “Yule mtu aitwaye Yesu alifanya tope, akanipaka machoni na kuniambia: Nenda ukanawe katika bwawa la Siloamu. Basi, mimi nikaenda, nikanawa, nikapata kuona.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wakamwuliza, “Yeye yuko wapi?” Naye akawajibu, “Mimi sijui!” ");
INSERT INTO swh1850_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kisha wakampeleka huyo mtu aliyekuwa kipofu kwa Mafarisayo. ");
INSERT INTO swh1850_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Siku hiyo Yesu alipofanya tope na kumfumbua macho mtu huyo, ilikuwa siku ya Sabato. ");
INSERT INTO swh1850_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Basi, Mafarisayo wakamwuliza mtu huyo, “Umepataje kuona?” Naye akawaambia, “Alinipaka tope machoni, nami nikanawa na sasa naona.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Baadhi ya Mafarisayo wakasema, “Mtu huyu hakutoka kwa Mungu, maana hashiki sheria ya Sabato.” Lakini wengine wakasema, “Mtu mwenye dhambi awezaje kufanya ishara za namna hii?” Kukawa na mafarakano kati yao. ");
INSERT INTO swh1850_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wakamwuliza tena huyo mtu aliyekuwa kipofu, “Maadam yeye amekufungua macho, wasemaje juu yake?” Naye akawaambia, “Yeye ni nabii!” ");
INSERT INTO swh1850_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Viongozi wa Wayahudi hawakusadiki kwamba mtu huyo alikuwa kipofu hapo awali na sasa anaona mpaka walipowaita wazazi wake. ");
INSERT INTO swh1850_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Basi, wakawauliza hao wazazi, “Je, huyu ndiye mtoto wenu ambaye ninyi mwasema alizaliwa kipofu? Sasa amepataje kuona?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wazazi wake wakajibu, “Tunajua kwamba huyu ni mtoto wetu, na kwamba alizaliwa kipofu. ");
INSERT INTO swh1850_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lakini amepataje kuona, hatujui; na wala hatumjui yule aliyemfumbua macho. Mwulizeni yeye mwenyewe; yeye ni mtu mzima, anaweza kujitetea mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wazazi wake walisema hivyo kwa sababu waliwaogopa viongozi wa Wayahudi kwani viongozi hao walikuwa wamepatana ya kwamba mtu yeyote atakayekiri kwamba Yesu ni Kristo atafukuzwa nje ya sunagogi. ");
INSERT INTO swh1850_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndiyo maana wazazi wake walisema: “Yeye ni mtu mzima, mwulizeni.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Basi, wakamwita tena aliyekuwa kipofu, wakamwambia, “Sema ukweli mbele ya Mungu! Sisi tunajua kwamba mtu huyu ni mwenye dhambi.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yeye akajibu, “Kama ni mwenye dhambi mimi sijui. Lakini kitu kimoja najua: Nilikuwa kipofu, na sasa naona.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Basi, wakamwuliza, “Alikufanyia nini? Alikufumbuaje macho yako?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Huyo mtu akawajibu, “Nimekwisha waambieni, nanyi hamkusikiliza; kwa nini mwataka kusikia tena? Je, ninyi pia mnataka kuwa wafuasi wake?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lakini wao wakamtukana wakisema, “Wewe ni mfuasi wake; sisi ni wafuasi wa Mose. ");
INSERT INTO swh1850_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sisi tunajua kwamba Mungu alisema na Mose, lakini mtu huyu hatujui ametoka wapi!” ");
INSERT INTO swh1850_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naye akawajibu, “Hili ni jambo la kushangaza! Ninyi hamjui ametoka wapi, lakini amenifumbua macho yangu! ");
INSERT INTO swh1850_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tunajua kwamba Mungu hawasikilizi watu wenye dhambi, ila humsikiliza yeyote mwenye kumcha na kutimiza mapenzi yake. ");
INSERT INTO swh1850_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tangu mwanzo wa ulimwengu haijasikika kwamba mtu ameyafumbua macho ya mtu aliyezaliwa kipofu. ");
INSERT INTO swh1850_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kama mtu huyu hakutoka kwa Mungu, hangeweza kufanya chochote!” ");
INSERT INTO swh1850_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wao wakamjibu, “Wewe ulizaliwa na kulelewa katika dhambi; unawezaje kutufundisha sisi?” Basi, wakamfukuzia mbali. ");
INSERT INTO swh1850_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu alisikia kwamba walikuwa wamemfukuzia mbali, naye alipomkuta akamwuliza, “Je, wewe unamwamini Mwana wa Mtu?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Huyo mtu akajibu, “Mheshimiwa, niambie yeye ni nani, ili nipate kumwamini.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu akamwambia, “Umekwisha mwona, naye ndiye anayesema nawe sasa.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Basi, huyo mtu akasema, “Ninaamini Bwana!” Akamsujudia. ");
INSERT INTO swh1850_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu akasema, “Mimi nimekuja ulimwenguni kutoa hukumu, kusudi wasioona wapate kuona, na wale wanaoona wawe vipofu.” ");
INSERT INTO swh1850_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Baadhi ya Mafarisayo waliokuwa pamoja naye walisikia maneno hayo, wakamwuliza, “Je, sisi pia ni vipofu?” ");
INSERT INTO swh1850_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akawajibu, “Kama mngekuwa vipofu, hamngekuwa na hatia; lakini sasa ninyi mwasema: Sisi tunaona, na hiyo yaonyesha kwamba mna hatia bado. ");
INSERT INTO swh1850_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu alisema “Kweli nawaambieni, yeyote yule asiyeingia katika zizi la kondoo kwa kupitia mlangoni, bali hupenya na kuingia kwa njia nyingine, huyo ni mwizi na mnyang'anyi. ");
INSERT INTO swh1850_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lakini anayeingia kwa kupitia mlangoni, huyo ndiye mchungaji wa kondoo. ");
INSERT INTO swh1850_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mngoja mlango wa zizi humfungulia, na kondoo husikia sauti yake, naye huwaita kondoo wake kila mmoja kwa jina lake na kuwaongoza nje. ");
INSERT INTO swh1850_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akisha watoa nje huwatangulia mbele nao kondoo humfuata, kwani wanaijua sauti yake. ");
INSERT INTO swh1850_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kondoo hao hawawezi kumfuata mgeni, bali watamkimbia kwa sababu hawaijui sauti yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu aliwaambia mfano huo, lakini wao hawakuelewa alichotaka kuwaambia. ");
INSERT INTO swh1850_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Basi, akasema tena, “Kweli nawaambieni, mimi ni mlango wa kondoo. ");
INSERT INTO swh1850_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wale wengine wote waliokuja kabla yangu ni wezi na wanyang'anyi, nao kondoo hawakuwasikiliza. ");
INSERT INTO swh1850_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mimi ni mlango. Anayeingia kwa kupitia kwangu ataokolewa; ataingia na kutoka, na kupata malisho. ");
INSERT INTO swh1850_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwizi huja kwa shabaha ya kuiba, kuua na kuharibu. Mimi nimekuja mpate kuwa na uzima—uzima kamili. ");
INSERT INTO swh1850_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mimi ni mchungaji mwema. Mchungaji mwema huutoa uhai wake kwa ajili ya kondoo wake. ");
INSERT INTO swh1850_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mtu wa kuajiriwa ambaye si mchungaji, na wala kondoo si mali yake, anapoona mbwa mwitu anakuja, huwaacha kondoo na kukimbia. Kisha mbwa mwitu huwakamata na kuwatawanya. ");
INSERT INTO swh1850_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yeye hajali kitu juu ya kondoo kwa sababu yeye ni mtu wa mshahara tu. ");
INSERT INTO swh1850_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mimi ni mchungaji mwema. Nawajua walio wangu, nao walio wangu wananijua mimi, ");
INSERT INTO swh1850_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kama vile Baba anijuavyo, nami nimjuavyo Baba. Mimi nayatoa maisha yangu kwa ajili yao. ");
INSERT INTO swh1850_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tena ninao kondoo wengine ambao hawamo zizini humu. Inanibidi kuwaleta hao pia, nao wataisikia sauti yangu, na kutakuwako kundi moja na mchungaji mmoja. ");
INSERT INTO swh1850_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Baba ananipenda kwani nautoa uhai wangu ili nipate kuupokea tena. ");
INSERT INTO swh1850_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hakuna mtu anayeninyang'anya uhai wangu; mimi na nautoa kwa hiari yangu mwenyewe. Ninao uwezo wa kuutoa na uwezo wa kuuchukua tena. Hivi ndivyo Baba alivyoniamuru nifanye.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kukawa tena na mafarakano kati ya Wayahudi kwa sababu ya maneno haya. ");
INSERT INTO swh1850_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wengi wao wakasema, “Ana pepo; tena ni mwendawazimu! Ya nini kumsikiliza?” ");
INSERT INTO swh1850_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wengine wakasema, “Haya si maneno ya mwenye pepo. Je, pepo anaweza kuyafumbua macho ya vipofu?” ");
INSERT INTO swh1850_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Huko Yerusalemu kulikuwa na sikukuu ya Kutabaruku. Wakati huo ulikuwa wa baridi. ");
INSERT INTO swh1850_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naye Yesu akawa anatembea Hekaluni katika ukumbi wa Solomoni. ");
INSERT INTO swh1850_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Basi, Wayahudi wakamzunguka, wakamwuliza, “Utatuacha katika mashaka mpaka lini? Kama wewe ndiye Kristo, basi, tuambie wazi.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu akawajibu, “Nimewaambieni, lakini hamsadiki. Kazi ninazozifanya mimi kwa jina la Baba yangu zinanishuhudia. ");
INSERT INTO swh1850_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lakini ninyi hamsadiki kwa sababu ninyi si kondoo wangu. ");
INSERT INTO swh1850_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kondoo wangu huisikia sauti yangu; mimi nawajua, nao hunifuata. ");
INSERT INTO swh1850_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mimi nawapa uzima wa milele; nao hawatapotea milele, wala hakuna mtu atakayeweza kuwatoa mkononi mwangu. ");
INSERT INTO swh1850_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baba yangu ambaye ndiye aliyenipa hao ni mkuu kuliko wote, wale hakuna awezaye kuwatoa mikononi mwake Baba. ");
INSERT INTO swh1850_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mimi na Baba, tu mmoja.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Basi, Wayahudi wakachukua mawe ili wamtupie. ");
INSERT INTO swh1850_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu akawaambia, “Nimewaonyesheni kazi nyingi kutoka kwa Baba. Ni ipi kati ya hizo inayowafanya mnipige mawe?” ");
INSERT INTO swh1850_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahudi wakamjibu, “Hatukupigi mawe kwa ajili ya tendo jema, ila kwa sababu ya kukufuru! Maana wajifanya kuwa Mungu hali wewe ni binadamu tu.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akawajibu, “Je, haikuandikwa katika Sheria yenu: Mimi nimesema, ninyi ni miungu? ");
INSERT INTO swh1850_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mungu aliwaita miungu wale waliopewa neno lake; nasi twajua kwamba Maandiko Matakatifu yasema ukweli daima. ");
INSERT INTO swh1850_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Je, yeye ambaye Baba alimweka wakfu na kumtuma ulimwenguni, mnamwambia: Unakufuru, eti kwa sababu nilisema: Mimi ni Mwana wa Mungu? ");
INSERT INTO swh1850_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kama sifanyi kazi za Baba yangu msiniamini. ");
INSERT INTO swh1850_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lakini ikiwa ninazifanya, hata kama hamniamini, walau ziaminini hizo kazi mpate kujua na kutambua kwamba Baba yuko ndani yangu, nami niko ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wakajaribu tena kumkamata lakini akachopoka mikononi mwao. ");
INSERT INTO swh1850_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu akaenda tena ng'ambo ya mto Yordani, mahali Yohane alipokuwa akibatiza, akakaa huko. ");
INSERT INTO swh1850_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Watu wengi walimwendea wakasema, “Yohane hakufanya ishara yoyote. Lakini yale yote Yohane aliyosema juu ya mtu huyu ni kweli kabisa.” ");
INSERT INTO swh1850_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Watu wengi mahali hapo wakamwamini. ");
INSERT INTO swh1850_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mtu mmoja aitwaye Lazaro, mwenyeji wa Bethania, alikuwa mgonjwa. (Kijiji cha Bethania kilikuwa mahali walipokaa Maria na Martha, dada yake. ");
INSERT INTO swh1850_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ndiye yule aliyempaka Bwana marashi na kumpangusa kwa nywele zake. Lazaro, kaka yake, ndiye aliyekuwa mgonjwa.) ");
INSERT INTO swh1850_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Basi, hao dada wakatuma ujumbe huu kwa Yesu: “Bwana, rafiki yako ni mgonjwa!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu aliposikia hivyo akasema, “Ugonjwa huo hautaleta kifo, ila ni kwa ajili ya kumtukuza Mungu; ameugua ili kwa njia hiyo Mwana wa Mungu atukuzwe.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu aliwapenda Martha, dada yake na Lazaro. ");
INSERT INTO swh1850_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Alipopata habari kwamba Lazaro ni mgonjwa, Yesu aliendelea kukaa mahali hapo alipokuwa kwa siku mbili zaidi. ");
INSERT INTO swh1850_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kisha akawaambia wanafunzi wake, “Twendeni tena Yudea!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanafunzi wakamwambia, “Mwalimu! Muda mfupi tu umepita tangu Wayahudi walipotaka kukuua kwa mawe, nawe unataka kwenda huko tena?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akajibu, “Je, saa za mchana si kumi na mbili? Basi, mtu akitembea mchana hawezi kujikwaa kwa kuwa anauona mwanga wa ulimwengu huu. ");
INSERT INTO swh1850_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lakini mtu akitembea usiku atajikwaa kwa maana mwanga haumo ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu alipomaliza kusema maneno hayo, akawaambia, “Rafiki yetu Lazaro amelala, lakini mimi nitakwenda kumwamsha.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanafunzi wake wakamwambia, “Bwana, ikiwa amelala, basi atapona.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wao walidhani kwamba alikuwa amesema juu ya kulala usingizi, kumbe alikuwa amesema juu ya kifo cha Lazaro. ");
INSERT INTO swh1850_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Basi, Yesu akawaambia waziwazi, “Lazaro amekufa; ");
INSERT INTO swh1850_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lakini nafurahi kwa ajili yenu kwamba sikuwako huko, ili mpate kuamini. Haya, twendeni kwake.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thoma (aitwaye Pacha) akawaambia wanafunzi wenzake, “Twendeni nasi tukafe pamoja naye!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu alipofika huko alikuta Lazaro amekwisha kaa kaburini kwa siku nne. ");
INSERT INTO swh1850_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kijiji cha Bethania kilikuwa karibu na Yerusalemu umbali upatao kilomita tatu. ");
INSERT INTO swh1850_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wayahudi wengi walikuwa wamefika kwa Martha na Maria kuwafariji kwa kifo cha kaka yao. ");
INSERT INTO swh1850_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Basi, Martha aliposikia kwamba Yesu alikuwa anakuja, akaenda kumlaki; lakini Maria alibaki nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha akamwambia Yesu, “Bwana, kama ungalikuwa hapa, kaka yangu hangalikufa! ");
INSERT INTO swh1850_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakini najua kwamba hata sasa chochote utakachomwomba Mungu, atakupa.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu akamwambia, “Kaka yako atafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha akamjibu, “Najua kwamba atafufuka wakati wa ufufuo, siku ya mwisho.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu akamwambia, “Mimi ndimi ufufuo na uzima. Anayeniamini mimi hata kama anakufa, ataishi: ");
INSERT INTO swh1850_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na kila anayeishi na kuniamini, hatakufa kamwe. Je, waamini hayo?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha akamwambia, “Ndiyo Bwana! Naamini kwamba wewe ndiwe Kristo, Mwana wa Mungu, yule ajaye ulimwenguni.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Baada ya kusema hayo, Martha alikwenda kumwita Maria, dada yake, akamwabia faraghani, “Mwalimu yuko hapa, anakuita.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naye aliposikia hivyo, akainuka mara, akamwendea Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu alikuwa hajaingia kijijini, ila alikuwa bado mahali palepale Martha alipomlaki. ");
INSERT INTO swh1850_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Basi, Wayahudi waliokuwa nyumbani pamoja na Maria wakimfariji walipomwona ameinuka na kutoka nje ghafla, walimfuata. Walidhani alikuwa anakwenda kaburini kuomboleza. ");
INSERT INTO swh1850_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Basi, Maria alipofika mahali pale Yesu alipokuwa na kumwona, alipiga magoti, akamwabia, “Bwana, kama ungalikuwa hapa, kaka yangu hangalikufa!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu alipomwona analia, na wale Wayahudi waliokuja pamoja naye wanalia pia, alijawa na huzuni na kufadhaika moyoni. ");
INSERT INTO swh1850_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kisha akawauliza, “Mlimweka wapi?” Wakamwambia, “Bwana, njoo uone.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu akalia machozi. ");
INSERT INTO swh1850_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Basi, Wayahudi wakasema, “Tazameni jinsi alivyompenda!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakini baadhi yao wakasema, “Je, huyu aliyemfumbua macho yule kipofu, hakuweza kumfanya Lazaro asife?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Basi, Yesu akiwa amehuzunika tena moyoni, akafika kaburini. Kaburi lenyewe lilikuwa pango, na lilikuwa limefunikwa kwa jiwe. ");
INSERT INTO swh1850_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu akasema, “Ondoeni hilo jiwe!” Martha, dada yake huyo aliyekufa, akamwambia, “Bwana, amekwishaanza kunuka; amekaa kaburini siku nne!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu akamwambia, “Je, sikukwambia kwamba ukiamini utaona utukufu wa Mungu?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Basi, wakaliondoa lile jiwe. Yesu akatazama juu mbinguni, akasema, “Nakushukuru Baba kwa kuwa wewe wanisikiliza. ");
INSERT INTO swh1850_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Najua kwamba unanisikiliza daima. Lakini nimesema hayo kwa ajili ya watu hawa waliopo hapa ili wapate kuamini kwamba wewe ndiwe uliyenituma.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Alipokwisha sema hayo, akaita kwa sauti kubwa: “Lazaro! Toka nje!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Huyo aliyekuwa amekufa akatoka nje, huku amefungwa sanda miguu na mikono, na uso wake umefunikwa. Yesu akawaambia, “Mfungueni, mkamwache aende zake.” ");
INSERT INTO swh1850_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Basi, Wayahudi wengi waliokuwa wamefika kwa Maria walipoona kitendo hicho alichokifanya Yesu wakamwamini. ");
INSERT INTO swh1850_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lakini baadhi yao walikwenda kwa Mafarisayo wakatoa taarifa ya jambo hilo alilofanya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","kwa hiyo makuhani wakuu na Mafarisayo wakafanya kikao cha Baraza kuu, wakasema, “Tufanye nini? Mtu huyu anafanya ishara nyingi mno. ");
INSERT INTO swh1850_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tukimwacha tu watu wote watamwamini, nao Waroma watakuja kuliharibu Hekalu letu na taifa letu!” ");
INSERT INTO swh1850_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hapo, mmoja wao aitwaye Kayafa, ambaye alikuwa Kuhani Mkuu mwaka huo, akawaambia, “Ninyi hamjui kitu! ");
INSERT INTO swh1850_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Je, hamwoni kwamba ni afadhali kwenu mtu mmoja afe kwa ajili ya watu, kuliko taifa zima liangamizwe?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yeye hakusema hivyo kwa hiari yake mwenyewe, bali kwa vile alikuwa Kuhani Mkuu mwaka huo, alibashiri kwamba Yesu atakufa kwa ajili ya taifa lao; ");
INSERT INTO swh1850_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na wala si kwa ajili yao tu, bali pia apate kuwaleta pamoja watoto wa Mungu waliotawanyika. ");
INSERT INTO swh1850_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Basi, tangu siku hiyo viongozi wa Wayahudi walifanya mipango ya kumwua Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwa hiyo, Yesu hakutembea tena hadharani kati ya Wayahudi, bali alitoka hapo, akaenda mahali karibu na jangwa, katika mji uitwao Efraimu. Akakaa huko pamoja na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sikukuu ya Wayahudi ya Pasaka ilikuwa karibu, na watu wengi walikwenda Yerusalemu ili wajitakase kabla ya sikukuu hiyo. ");
INSERT INTO swh1850_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Basi, wakawa wanamtafuta Yesu; nao walipokusanyika pamoja Hekaluni wakaulizana, “Mwaonaje? Yaonekana kwamba haji kabisa kwenye sikukuu, au sivyo?” ");
INSERT INTO swh1850_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Makuhani wakuu na Mafarisayo walikuwa wametoa amri kwamba mtu akijua mahali aliko Yesu awaarifu kusudi wamtie nguvuni. ");
INSERT INTO swh1850_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Siku sita kabla ya sikukuu ya Pasaka, Yesu alifika Bethania alikoishi Lazaro ambaye Yesu alikuwa amemfufua kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Huko walimwandalia chakula cha jioni, naye Martha akawa anawatumikia. Lazaro alikuwa mmoja wa wale waliokuwa mezani pamoja na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Basi, Maria alichukua chupa ya marashi ya nardo safi ya thamani kubwa, akampaka Yesu miguu na kuipangusa kwa nywele zake. Nyumba yote ikajaa harufu ya marashi. ");
INSERT INTO swh1850_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Basi, Yuda Iskarioti, mmoja wa wale kumi na wawili ambaye ndiye atakayemsaliti Yesu, akasema, ");
INSERT INTO swh1850_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwa nini marashi hayo hayakuuzwa kwa fedha dinari mia tatu, wakapewa maskini?” ");
INSERT INTO swh1850_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Alisema hivyo, si kwa kuwa alijali chochote juu ya maskini, bali kwa sababu alikuwa mweka hazina, na kwa kuwa alikuwa mwizi, mara kwa mara aliiba kutoka katika hiyo hazina. ");
INSERT INTO swh1850_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lakini Yesu akasema, “Msimsumbue huyu mama! Mwacheni ayaweke kwa ajili ya siku ya mazishi yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maskini mtakuwa nao siku zote, lakini hamtakuwa nami siku zote.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi wengi walisikia kwamba Yesu alikuwa Bethania. Basi, wakafika huko si tu kwa ajili ya kumwona Yesu, ila pia wapate kumwona Lazaro ambaye Yesu alimfufua kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Makuhani wakuu waliamua pia kumwua Lazaro, ");
INSERT INTO swh1850_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Maana kwa sababu ya Lazaro Wayahudi wengi waliwaasi viongozi wao, wakamwamini Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kesho yake, kundi kubwa la watu waliokuja kwenye sikukuu walisikia kuwa Yesu alikuwa njiani kuja Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Basi, wakachukua matawi ya mitende, wakatoka kwenda kumlaki; wakapaaza sauti wakisema: “Hosana! Abarikiwe huyo ajaye kwa jina la Bwana. Abarikiwe mfalme wa Israeli.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu akampata mwana punda mmoja akapanda juu yake kama yasemavyo Maandiko: ");
INSERT INTO swh1850_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Usiogope mji wa Sioni! Tazama, Mfalme wako anakuja, Amepanda mwana punda.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wakati huo wanafunzi wake hawakuelewa mambo hayo, lakini Yesu alipokwisha tukuzwa, ndipo walipokumbuka kwamba hayo yalikuwa yameandikwa juu yake, na kwamba watu walikuwa wamemtendea hivyo. ");
INSERT INTO swh1850_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kundi la watu wale waliokuwa pamoja naye wakati alipomwita Lazaro kutoka kaburini, akamfufua kutoka wafu, walisema yaliyotukia. ");
INSERT INTO swh1850_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwa hiyo umati huo wa watu ulimlaki, maana wote walisikia kwamba Yesu alikuwa amefanya ishara hiyo. ");
INSERT INTO swh1850_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Basi, Mafarisayo wakaambiana, “Mnaona? Hatuwezi kufanya chochote! Tazameni, ulimwengu wote unamfuata.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kulikuwa na Wagiriki kadhaa miongoni mwa watu waliokuwa wamefika Yerusalemu kuabudu wakati wa sikukuu hiyo. ");
INSERT INTO swh1850_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hao walimwendea Filipo, mwenyeji wa Bethsaida katika Galilaya, wakasema, “Mheshimiwa, tunataka kumwona Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo akaenda akamwambia Andrea, nao wawili wakaenda kumwambia Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akawaambia, “Saa ya kutukuzwa kwa Mwana wa Mtu imefika! ");
INSERT INTO swh1850_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kweli nawaambieni, punje ya ngano hubaki punje tu isipokuwa ikianguka katika udongo na kufa. Kama ikifa, basi huzaa matunda mengi. ");
INSERT INTO swh1850_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anayependa maisha yake, atayapoteza; anayeyachukia maisha yake katika ulimwengu huu, atayaweka kwa ajili ya uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Anayetaka kunitumikia ni lazima anifuate, hivyo kwamba popote pale nilipo mimi ndipo na mtumishi wangu atakapokuwa. Mtu yeyote anayenitumikia Baba yangu atampa heshima. ");
INSERT INTO swh1850_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sasa roho yangu imefadhaika, na niseme nini? Je, niseme: Baba, usiruhusu saa hii inifikie? Lakini ndiyo maana nimekuja—ili nipite katika saa hii. ");
INSERT INTO swh1850_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, ulitukuze jina lako.” Hapo sauti ikasema kutoka mbinguni, “Nimelitukuza, na nitalitukuza tena.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Umati wa watu waliokuwa wamesimama hapo walisikia sauti hiyo, na baadhi yao walisema, “Malaika ameongea naye!” ");
INSERT INTO swh1850_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lakini Yesu akawaambia, “Sauti hiyo haikutokea kwa ajili yangu mimi, ila kwa ajili yenu. ");
INSERT INTO swh1850_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sasa ndio wakati wa ulimwengu huu kuhukumiwa; sasa mtawala wa ulimwengu huu atapinduliwa. ");
INSERT INTO swh1850_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nami nitakapoinuliwa juu ya nchi nitamvuta kila mmoja kwangu.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Kwa kusema hivyo alionyesha atakufa kifo gani). ");
INSERT INTO swh1850_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Basi, umati huo ukamjibu, “Sisi tunaambiwa na Sheria yetu kwamba Kristo atadumu milele. Wawezaje basi, kusema ati Mwana wa Mtu anapaswa kuinuliwa? Huyo Mwana wa Mtu ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu akawaambia, “Mwanga bado uko nanyi kwa muda mfupi. Tembeeni mngali mnao huo mwanga ili giza lisiwapate; maana atembeaye gizani hajui aendako. ");
INSERT INTO swh1850_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Basi, wakati mnao huo mwanga uaminini ili mpate kuwa watu wa mwanga.” Baada ya kusema maneno hayo, Yesu alikwenda zake na kujificha mbali nao. ");
INSERT INTO swh1850_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ingawa Yesu alifanya miujiza hii yote mbele yao, wao hawakumwamini. ");
INSERT INTO swh1850_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hivyo maneno aliyosema nabii Isaya yakatimia: “Bwana, nani aliyeuamini ujumbe wetu? Na uwezo wa Bwana umedhihirishwa kwa nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hivyo hawakuweza kuamini, kwani Isaya tena alisema: ");
INSERT INTO swh1850_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mungu ameyapofusha macho yao, amezipumbaza akili zao; wasione kwa macho yao, wasielewe kwa akili zao; wala wasinigeukie, asema Bwana, ili nipate kuwaponya.” ");
INSERT INTO swh1850_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya alisema maneno haya kwa sababu aliuona utukufu wa Yesu, akasema habari zake. ");
INSERT INTO swh1850_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata hivyo, wengi wa viongozi wa Wayahudi walimwamini Yesu. Lakini kwa sababu ya Mafarisayo, hawakumkiri hadharani kwa kuogopa kwamba watatengwa na sunagogi. ");
INSERT INTO swh1850_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Walipendelea kusifiwa na watu kuliko kusifiwa na Mungu ");
INSERT INTO swh1850_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kisha Yesu akasema kwa sauti kubwa, “Mtu aliyeniamini, haniamini mimi tu, ila anamwamini pia yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Anayeniona mimi anamwona pia yule aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mimi ni mwanga, nami nimekuja ulimwenguni ili wote wanaoniamini wasibaki gizani. ");
INSERT INTO swh1850_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anayeyasikia maneno yangu lakini hayashiki mimi sitamhukumu; maana sikuja kuhukumu ulimwengu bali kuuokoa. ");
INSERT INTO swh1850_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Asiyeyashika maneno yangu anaye wa kumhukumu: neno lile nililosema ni hakimu wake siku ya mwisho. ");
INSERT INTO swh1850_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mimi sikunena kwa mamlaka yangu mwenyewe, ila Baba aliyenituma ndiye aliyeniamuru niseme nini na niongee nini. ");
INSERT INTO swh1850_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nami najua kuwa amri yake huleta uzima wa milele. Basi, mimi nasema tu yale Baba aliyoniagiza niyaseme.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ilikuwa kabla ya sikukuu ya Pasaka. Yesu alijua kwamba saa yake ya kuondoka ulimwenguni na kwenda kwa Baba ilikuwa imefika. Alikuwa amewapenda daima watu wake walioko duniani; naam, aliwapenda mpaka mwisho! ");
INSERT INTO swh1850_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Basi, Yesu na wanafunzi wake walikuwa mezani kwa chakula cha jioni. Ibilisi alikwisha mtia Yuda, mwana wa Simoni Iskarioti, nia ya kumsaliti Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu alijua kwamba Baba alikuwa amemkabidhi kila kitu, na kwamba alikuwa ametoka kwa Mungu na anarudi kwa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Basi, Yesu aliondoka mezani, akaweka kando vazi lake, akachukua kitambaa na kujifunga kiunoni. ");
INSERT INTO swh1850_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kisha akatia maji katika bakuli, akaanza kuwaosha wanafunzi wake miguu na kuipangusa kwa kile kitambaa alichojifungia. ");
INSERT INTO swh1850_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Basi, akamfikia Simoni Petro; naye Petro akasema, “Bwana, wewe utaniosha miguu mimi?” ");
INSERT INTO swh1850_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akamjibu, “Huelewi sasa ninachofanya lakini utaelewa baadaye.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro akamwambia, “Wewe hutaniosha miguu kamwe!” Yesu akamjibu, “Nisipokuosha hutakuwa na uhusiano nami tena.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petro akamwambia, “Bwana, nioshe, si miguu tu, bali na mikono yangu na kichwa pia.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu akamwambia, “Aliyekwisha oga hana lazima ya kunawa isipokuwa miguu, maana amekwisha takata mwili wote. Ninyi mmetakata, lakini si nyote.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesu alimjua yule ambaye atamsaliti, ndiyo maana alisema: “Ninyi mmetakata, lakini si nyote.”) ");
INSERT INTO swh1850_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Alipokwisha waosha miguu na kuvaa tena vazi lake, aliketi mezani, akawaambia, “Je, mmeelewa hayo niliyowatendeeni? ");
INSERT INTO swh1850_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ninyi mwaniita Mwalimu na Bwana, nanyi mwasema vyema, kwa kuwa ndimi. ");
INSERT INTO swh1850_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Basi, ikiwa mimi niliye Bwana na Mwalimu, nimewaosha ninyi miguu, nanyi pia mnapaswa kuoshana miguu. ");
INSERT INTO swh1850_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nimewapeni mfano, ili nanyi pia mfanye kama nilivyowafanyieni. ");
INSERT INTO swh1850_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kweli nawaambieni, mtumishi si mkuu zaidi kuliko bwana wake, wala mtume si mkuu zaidi kuliko yule aliyemtuma. ");
INSERT INTO swh1850_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Basi, ikiwa mwayajua hayo, mtakuwa na heri mkiyatekeleza. ");
INSERT INTO swh1850_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Haya nisemayo hayawahusu ninyi nyote. Mimi nawajua wale niliowachagua. Lakini lazima yatimie Maandiko Matakatifu yasemayo: Yule aliyeshiriki chakula changu amegeuka kunishambulia. ");
INSERT INTO swh1850_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mimi nimewaambieni mambo haya sasa kabla hayajatokea, ili yatakapotokea mpate kuamini kuwa mimi ndimi. ");
INSERT INTO swh1850_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kweli nawaambieni anayempokea yule ninayemtuma anaponipokea mimi; na anayenipokea mimi, anampokea yule aliyenituma.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Alipokwisha sema hayo, Yesu alifadhaika sana rohoni, akasema wazi, “Kweli nawaambieni, mmoja wenu atanisaliti!” ");
INSERT INTO swh1850_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wanafunzi wakatazama wasiweze kabisa kujua anasema nani. ");
INSERT INTO swh1850_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mmoja wa wanafunzi, ambaye Yesu alikuwa anampenda sana, alikuwa ameketi karibu na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Basi, Simoni Petro akamwashiria na kusema: “Mwulize anasema juu ya nani.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mwanafunzi huyo akasogea karibu zaidi na Yesu, akamwuliza, “Bwana, ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu akajibu, “Yule nitakayempa kipande cha mkate nilichochovya katika sahani, ndiye.” Basi, akatwaa kipande cha mkate, akakichovya katika sahani, akampa Yuda, mwana wa Simoni Iskarioti. ");
INSERT INTO swh1850_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda alipokwisha pokea kipande hicho, Shetani akamwingia. Basi Yesu akamwambia, “Unachotaka kufanya, kifanye haraka!” ");
INSERT INTO swh1850_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lakini hakuna hata mmoja wa wale waliokaa pale mezani aliyefahamu kwa nini alikuwa amemwambia hivyo. ");
INSERT INTO swh1850_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwa kuwa Yuda alikuwa na wajibu wa kuutunza mfuko wa fedha, baadhi yao walidhani kwamba Yesu alikuwa amemwambia anunue vilivyohitajiwa kwa sikukuu, au kwamba alikuwa amemwambia akatoe chochote kwa maskini. ");
INSERT INTO swh1850_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Basi, Yuda alipokwisha twaa kile kipande cha mkate, akatoka nje mara. Na ilikuwa usiku. ");
INSERT INTO swh1850_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Baada ya Yuda kuondoka, Yesu akasema, “Sasa Mwana wa Mtu ametukuzwa, naye Mungu ametukuzwa ndani yake. ");
INSERT INTO swh1850_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na kama utukufu wa Mungu umefunuliwa ndani ya Mwana, basi, naye Mungu ataudhihirisha utukufu wa Mwana ndani yake mwenyewe, na atafanya hivyo mara. ");
INSERT INTO swh1850_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Watoto wangu, bado niko nanyi kwa muda mfupi tu. Mtanitafuta, lakini sasa nawaambieni yale niliyowaambia viongozi wa Wayahudi: Niendako ninyi hamwezi kwenda! ");
INSERT INTO swh1850_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nawapeni amri mpya: pendaneni; pendaneni kama nilivyowapenda ninyi. ");
INSERT INTO swh1850_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mkipendana, watu wote watajua kwamba ninyi ni wanafunzi wangu.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petro akamwuliza, “Bwana, unakwenda wapi?” Yesu akajibu, “Niendako huwezi kunifuata sasa, lakini utanifuata baadaye.” ");
INSERT INTO swh1850_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro akamwambia “Bwana, kwa nini siwezi kukufuata sasa? Niko tayari kufa kwa ajili yako!” ");
INSERT INTO swh1850_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu akajibu, “Je, uko tayari kweli kufa kwa ajili yangu? Kweli nakwambia, kabla jogoo hajawika utanikana mara tatu!” ");
INSERT INTO swh1850_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu aliwaambia, “Msifadhaike mioyoni mwenu. Mwaminini Mungu, niaminini na mimi pia. ");
INSERT INTO swh1850_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nyumbani mwa Baba yangu mna makao mengi; la sivyo ningalikwisha waambieni. Sasa nakwenda kuwatayarishieni nafasi. ");
INSERT INTO swh1850_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nikienda na kuwatayarishieni nafasi, nitarudi na kuwachukueni kwangu, ili nanyi muwe pale nilipo mimi. ");
INSERT INTO swh1850_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mnajua njia ya kwenda huko ninakokwenda.” ");
INSERT INTO swh1850_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thoma akamwuliza, “Bwana, hatujui unakokwenda, tutawezaje basi, kuijua hiyo njia?” ");
INSERT INTO swh1850_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu akamjibu, “Mimi ni njia, na ukweli na uzima. Hakuna awezaye kwenda kwa Baba ila kwa kupitia kwangu. ");
INSERT INTO swh1850_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ikiwa mnanijua mimi mnamjua na Baba yangu pia. Na tangu sasa, mnamjua, tena mmekwisha mwona.” ");
INSERT INTO swh1850_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo akamwambia, “Bwana, tuonyeshe Baba, nasi tutatosheka.” ");
INSERT INTO swh1850_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akamwambia, “Filipo, nimekaa nanyi muda wote huu, nawe hujanijua? Aliyekwisha niona mimi amemwona Baba. Unawezaje basi, kusema: Tuonyeshe Baba? ");
INSERT INTO swh1850_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Je, huamini kwamba mimi niko ndani ya Baba, naye Baba yuko ndani yangu? Maneno ninayowaambieni nyote siyasemi kwa mamlaka yangu; Baba aliye ndani yangu anafanya kazi yake. ");
INSERT INTO swh1850_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mnapaswa kuniamini ninaposema kwamba mimi niko ndani ya Baba naye Baba yuko ndani yangu. Ama sivyo, aminini kwa sababu ya mambo ninayofanya. ");
INSERT INTO swh1850_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kweli nawaambieni, anayeniamini atafanya mambo ninayofanya mimi; naam, atafanya hata makuu zaidi, maana nakwenda kwa Baba. ");
INSERT INTO swh1850_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na chochote mtakachoomba kwa jina langu nitafanya, ili Baba atukuzwe ndani ya Mwana. ");
INSERT INTO swh1850_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mkiniomba chochote kwa jina langu, nitawafanyieni. ");
INSERT INTO swh1850_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mkinipenda mtazishika amri zangu. ");
INSERT INTO swh1850_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nami nitamwomba Baba naye atawapeni Msaidizi mwingine, atakayekaa nanyi milele. ");
INSERT INTO swh1850_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yeye ni Roho wa kweli. Ulimwengu hauwezi kumpokea kwa sababu hauwezi kumwona wala kumjua. Lakini ninyi mnamjua kwa sababu anabaki nanyi na yu ndani yenu. ");
INSERT INTO swh1850_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Sitawaacha ninyi yatima; nitakuja tena kwenu. ");
INSERT INTO swh1850_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bado kidogo nao ulimwengu hautaniona tena, lakini ninyi mtaniona; na kwa kuwa mimi ni hai, nanyi pia mtakuwa hai. ");
INSERT INTO swh1850_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Siku ile itakapofika mtajua kwamba mimi niko ndani ya Baba, nanyi mko ndani yangu, nami ndani yenu. ");
INSERT INTO swh1850_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Azipokeaye amri zangu na kuzishika, yeye ndiye anipendaye. Naye anipendaye mimi atapendwa na Baba yangu, nami nitampenda na kujidhihirisha kwake.” ");
INSERT INTO swh1850_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (si yule Iskarioti) akamwambia, “Bwana, itawezekanaje wewe kujidhihirisha kwetu na si kwa ulimwengu?” ");
INSERT INTO swh1850_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu akamjibu, “Mtu akinipenda atashika neno langu, na Baba yangu atampenda, nasi tutakuja kwake na kukaa naye. ");
INSERT INTO swh1850_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Asiyenipenda hashiki maneno yangu. Na neno mlilosikia si langu, bali ni lake Baba aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nimewaambieni mambo haya nikiwa bado pamoja nanyi ");
INSERT INTO swh1850_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","lakini Msaidizi, Roho Mtakatifu, ambaye Baba atamtuma kwa jina langu, atawafundisheni kila kitu na kuwakumbusheni yote niliyowaambieni. ");
INSERT INTO swh1850_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nawaachieni amani; nawapeni amani yangu. Siwapi ninyi kama vile ulimwengu ufanyavyo. Msiwe na wasiwasi, wala msifadhaike. ");
INSERT INTO swh1850_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mlikwisha sikia nikiwaambieni: Ninakwenda zangu, kisha nitarudi tena kwenu. Kama mngalinipenda mngalifurahi kwa sababu ninakwenda kwa Baba, maana yeye ni mkuu kuliko mimi. ");
INSERT INTO swh1850_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nimewaambieni haya sasa kabla hayajatokea, ili yatakapotokea mpate kuamini. ");
INSERT INTO swh1850_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sitasema nanyi tena mambo mengi, maana mtawala wa ulimwengu huu anakuja. Kwangu mimi hawezi kitu; ");
INSERT INTO swh1850_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini ulimwengu unapaswa kujua kwamba nampenda Baba, na ndiyo maana nafanya kila kitu kama Baba alivyoniamuru. Simameni, tutoke hapa!” ");
INSERT INTO swh1850_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mimi ni mzabibu wa kweli, na Baba yangu ndiye mkulima. ");
INSERT INTO swh1850_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yeye huliondoa ndani yangu kila tawi lisilozaa matunda, na kila tawi lizaalo hulisafisha lipate kuzaa zaidi. ");
INSERT INTO swh1850_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ninyi mmekwisha kuwa safi kwa sababu ya ule ujumbe niliowaambieni. ");
INSERT INTO swh1850_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaeni ndani yangu, nami nikae ndani yenu. Tawi haliwezi peke yake kuzaa matunda lisipokaa katika mzabibu hali kadhalika nanyi hamwezi kuzaa matunda msipokaa ndani yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mimi ni mzabibu, nanyi ni matawi yake. Akaaye ndani yangu, nami ndani yake, huyo atazaa matunda mengi, maana bila mimi hamwezi kufanya chochote. ");
INSERT INTO swh1850_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mtu yeyote asipokaa ndani yangu hutupwa nje kama tawi litupwalo nje hata likakauka. Watu huliokota tawi la namna hiyo na kulitupa motoni liungue. ");
INSERT INTO swh1850_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mkikaa ndani yangu na maneno yangu yakikaa ndani yenu, basi, ombeni chochote mtakacho nanyi mtapewa. ");
INSERT INTO swh1850_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Baba yangu hutukuzwa kama mkizaa matunda mengi na kuwa wanafunzi wangu. ");
INSERT INTO swh1850_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mimi nimewapenda ninyi kama vile Baba alivyonipenda mimi. Kaeni katika pendo langu. ");
INSERT INTO swh1850_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mkizishika amri zangu mtakaa katika pendo langu, kama vile nami nilivyozishika amri za Baba yangu na kukaa katika pendo lake. ");
INSERT INTO swh1850_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nimewaambieni mambo haya ili furaha yangu ikae ndani yenu, na furaha yenu ikamilike. ");
INSERT INTO swh1850_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hii ndiyo amri yangu: pendaneni; pendaneni kama nilivyowapenda ninyi. ");
INSERT INTO swh1850_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hakuna upendo mkuu zaidi kuliko upendo wa mtu atoaye uhai wake kwa ajili ya rafiki zake. ");
INSERT INTO swh1850_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ninyi ni rafiki zangu mkifanya ninayowaamuru. ");
INSERT INTO swh1850_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ninyi siwaiti tena watumishi, maana mtumishi hajui anachofanya bwana wake. Lakini mimi nimewaita ninyi rafiki, kwa sababu nimewajulisha yote ambayo nimeyasikia kutoka kwa Baba yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ninyi hamkunichagua mimi; mimi niliwachagueni na kuwatuma mwende mkazae matunda, matunda yadumuyo, naye Baba apate kuwapa ninyi chochote mumwombacho kwa jina langu. ");
INSERT INTO swh1850_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Basi, amri yangu kwenu ndiyo hii: pendaneni. ");
INSERT INTO swh1850_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kama ulimwengu ukiwachukia ninyi, kumbukeni kwamba umenichukia mimi kabla haujawachukia ninyi. ");
INSERT INTO swh1850_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kama mngalikuwa watu wa ulimwengu, ulimwengu ungaliwapenda ninyi kama watu wake. Lakini kwa vile ninyi si wa ulimwengu, ila mimi nimewachagueni kutoka ulimwenguni, kwa sababu hiyo ulimwengu unawachukieni. ");
INSERT INTO swh1850_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukeni niliyowaambieni: mtumishi si mkuu zaidi kuliko bwana wake. Ikiwa wamenitesa mimi, watawatesa na ninyi pia; kama wameshika neno langu, watalishika na lenu pia. ");
INSERT INTO swh1850_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lakini hayo yote watawatendeeni ninyi kwa sababu ya jina langu, kwani hawamjui yeye aliyenituma. ");
INSERT INTO swh1850_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kama nisingalikuja na kusema nao wasingalikuwa na hatia; lakini sasa hawawezi kujitetea kwamba hawana dhambi. ");
INSERT INTO swh1850_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Anayenichukia mimi, anamchukia na Baba yangu pia. ");
INSERT INTO swh1850_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kama nisingalifanya kwao mambo ambayo hakuna mtu mwingine amekwisha yafanya wasingalikuwa na hatia; lakini sasa wameona niliyoyafanya wakinichukia mimi, wakamchukia na Baba yangu pia. ");
INSERT INTO swh1850_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na hivi ni lazima yatimie yale yaliyoandikwa katika Sheria yao: Wamenichukia bure! ");
INSERT INTO swh1850_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Atakapokuja huyo Msaidizi nitakayemtuma kwenu kutoka kwa Baba, huyo Roho wa kweli atokaye kwa Baba, yeye atanishuhudia mimi. ");
INSERT INTO swh1850_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nanyi pia mtanishuhudia kwa kuwa mmekuwa nami tangu mwanzo. ");
INSERT INTO swh1850_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nimewaambieni hayo kusudi msiiache imani yenu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Watu watawatenga ninyi na masunagogi yao. Tena, wakati unakuja ambapo kila atakayewaua ninyi atadhani anamhudumia Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Watawatendeeni mambo hayo kwa sababu hawamjui Baba, wala hawanijui mimi. ");
INSERT INTO swh1850_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Basi, nimewaambieni mambo haya ili saa yake itakapofika mkumbuke kwamba niliwaambieni. “Sikuwaambieni mambo haya tangu mwanzo kwa sababu nilikuwa pamoja nanyi. ");
INSERT INTO swh1850_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lakini sasa namwendea yule aliyenituma; na hakuna hata mmoja wenu anayeniuliza: Unakwenda wapi? ");
INSERT INTO swh1850_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa kuwa nimewaambieni mambo hayo mmejaa huzuni mioyoni mwenu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakini, nawaambieni ukweli: afadhali kwenu mimi niende zangu, maana nisipokwenda Msaidizi hatakuja kwenu. Lakini nikienda, basi, nitamtuma kwenu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naye atakapokuja atawathibitishia walimwengu kwamba wamekosea kuhusu dhambi, uadilifu na hukumu ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wamekosea kuhusu dhambi kwa sababu hawaniamini; ");
INSERT INTO swh1850_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kuhusu uadilifu, kwa sababu naenda zangu kwa Baba, nanyi hamtaniona tena; ");
INSERT INTO swh1850_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","kuhusu hukumu kwa sababu mkuu wa ulimwengu huu amekwisha hukumiwa. ");
INSERT INTO swh1850_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ninayo bado mengi ya kuwaambieni, ila kwa sasa hamwezi kuyastahimili. ");
INSERT INTO swh1850_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini atakapokuja huyo Roho wa kweli atawaongoza kwenye ukweli wote; maana hatasema kwa mamlaka yake mwenyewe, bali atawaambieni yote atakayosikia, na atasema mambo yatakayokuwa yanakuja. ");
INSERT INTO swh1850_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yeye atanitukuza mimi kwa kuwa atawaambieni yale atakayopata kutoka kwangu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vyote alivyo navyo Baba ni vyangu; ndiyo maana nimesema kwamba huyo Roho Mtakatifu atawaambieni yale atakayopata kutoka kwangu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Bado kitambo kidogo nanyi hamtaniona; na baada ya kitambo kidogo tena mtaniona!” ");
INSERT INTO swh1850_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hapo baadhi ya wanafunzi wake wakaulizana, “Ana maana gani anapotwambia: Bado kitambo kidogo nanyi hamtaniona; na baada ya kitambo kidogo tena mtaniona? Tena anasema: Kwa kuwa ninakwenda kwa Baba!” ");
INSERT INTO swh1850_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Basi, wakawa wanaulizana, “Ana maana gani anaposema: Bado kitambo kidogo? Hatuelewi anaongelea nini.” ");
INSERT INTO swh1850_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu alijua kwamba walitaka kumwuliza, basi akawaambia, “Je, mnaulizana juu ya yale niliyosema: Bado kitambo kidogo nanyi hamtaniona; na baada ya kitambo kidogo tena mtaniona? ");
INSERT INTO swh1850_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nawaambieni kweli, ninyi mtalia na kuomboleza, lakini ulimwengu utafurahi: mtaona huzuni lakini huzuni yenu itageuka kuwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wakati mama anapojifungua huona huzuni kwa sababu saa ya maumivu imefika; lakini akisha jifungua hayakumbuki tena maumivu hayo kwa sababu ya furaha kwamba mtu amezaliwa duniani. ");
INSERT INTO swh1850_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ninyi pia mna huzuni sasa; lakini nitawajieni tena, nanyi mtajaa furaha mioyoni mwenu, na furaha hiyo hakuna mtu atakayeiondoa kwenu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Siku hiyo hamtaniomba chochote. Kweli nawaambieni, chochote mtakachomwomba Baba kwa jina langu, atawapeni. ");
INSERT INTO swh1850_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka sasa hamjaomba chochote kwa jina langu. Ombeni nanyi mtapata ili furaha yenu ikamilike. ");
INSERT INTO swh1850_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nimewaambieni mambo hayo kwa mafumbo. Lakini wakati utakuja ambapo sitasema tena nanyi kwa mafumbo, bali nitawaambieni waziwazi juu ya Baba. ");
INSERT INTO swh1850_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Siku hiyo mtaomba kwa jina langu, na siwaambii kwamba nitamwomba Baba kwa niaba yenu; ");
INSERT INTO swh1850_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","maana yeye mwenyewe anawapenda ninyi, kwa sababu ninyi mmenipenda mimi na mmeamini kwamba nimetoka kwa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mimi nilitoka kwa Baba, nikaja ulimwenguni; na sasa nauacha ulimwengu na kurudi kwa Baba.” ");
INSERT INTO swh1850_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Basi, wanafunzi wake wakamwambia, “Ahaa! Sasa unasema waziwazi kabisa bila kutumia mafumbo. ");
INSERT INTO swh1850_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sasa tunajua kwamba wewe unajua kila kitu, na huna haja ya kuulizwa maswali na mtu yeyote; kwa hiyo tunaamini kwamba umetoka kwa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akawajibu, “Je, mnaamini sasa? ");
INSERT INTO swh1850_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wakati unakuja, tena umekwisha fika, ambapo ninyi nyote mtatawanyika kila mtu kwake, nami nitaachwa peke yangu. Kumbe, lakini mimi siko peke yangu, maana Baba yu pamoja nami. ");
INSERT INTO swh1850_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nimewaambieni mambo haya ili mpate kuwa na amani katika kuungana nami. Ulimwenguni mtapata masumbuko; lakini jipeni moyo! Mimi nimeushinda ulimwengu!” ");
INSERT INTO swh1850_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu alipokwisha sema hayo, alitazama juu mbinguni, akasema, “Baba, saa imefika! Mtukuze Mwanao ili naye Mwana apate kukutukuza. ");
INSERT INTO swh1850_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Maana ulimpa Mwanao mamlaka juu ya watu wote ili awape uzima wa milele wote hao uliompa. ");
INSERT INTO swh1850_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na uzima wa milele ndio huu: kukujua wewe uliye peke yako Mungu wa kweli, na kumjua Yesu Kristo uliyemtuma. ");
INSERT INTO swh1850_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mimi nimekutukuza hapa duniani; nimeikamilisha ile kazi uliyonipa nifanye. ");
INSERT INTO swh1850_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sasa, Baba, nitukuze mbele yako kwa ule utukufu niliokuwa nao kabla ya kuumbwa ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nimekufanya ujulikane kwa watu wale ulionipa kutoka duniani. Walikuwa watu wako, nawe ukanipa wawe wangu; nao wamelishika neno lako. ");
INSERT INTO swh1850_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sasa wanajua kwamba kila ulichonipa kimetoka kwako. ");
INSERT INTO swh1850_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mimi nimewapa ule ujumbe ulionipa nao wameupokea; wanajua kwamba kweli nimetoka kwako, na wanaamini kwamba wewe ulinituma. ");
INSERT INTO swh1850_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nawaombea hao; siuombei ulimwengu, ila nawaombea hao ulionipa, maana ni wako. ");
INSERT INTO swh1850_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yote niliyo nayo ni yako, na yako ni yangu; na utukufu wangu umeonekana ndani yao. ");
INSERT INTO swh1850_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na sasa naja kwako; simo tena ulimwenguni, lakini wao wamo ulimwenguni. Baba Mtakatifu! Kwa nguvu ya jina lako ulilonipa, tafadhali uwaweke salama ili wawe kitu kimoja kama sisi tulivyo mmoja. ");
INSERT INTO swh1850_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nilipokuwa nao, mimi niliwaweka salama kwa nguvu ya jina lako ulilonipa. Mimi nimewalinda, wala hakuna hata mmoja wao aliyepotea, isipokuwa yule aliyelazimika kupotea ili Maandiko Matakatifu yapate kutimia. ");
INSERT INTO swh1850_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Basi, sasa naja kwako, na nimesema mambo haya ulimwenguni, ili waweze kushiriki kikamilifu furaha yangu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mimi nimewapa neno lako, nao ulimwengu ukawachukia, kwa sababu wao si wa ulimwengu kama vile nami nisivyo wa ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Siombi uwatoe ulimwenguni, bali naomba uwakinge na yule Mwovu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wao si wa ulimwengu, kama vile nami nisivyo wa ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Waweke wakfu kwa ukweli; neno lako ni ukweli. ");
INSERT INTO swh1850_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kama vile ulivyonituma ulimwenguni, nami pia nimewatuma wao ulimwenguni; ");
INSERT INTO swh1850_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","na kwa ajili yao mimi mwenyewe najiweka wakfu ili nao pia wafanywe wakfu katika ukweli. ");
INSERT INTO swh1850_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Siwaombei hao tu, bali nawaombea pia wote watakaoamini kutokana na ujumbe wao. ");
INSERT INTO swh1850_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Naomba ili wote wawe kitu kimoja. Baba! Naomba wawe ndani yetu kama vile wewe ulivyo ndani yangu nami ndani yako. Naomba wawe kitu kimoja kusudi ulimwengu upate kuamini kwamba wewe ulinituma. ");
INSERT INTO swh1850_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mimi nimewapa utukufu uleule ulionipa mimi, ili wawe kitu kimoja kama nasi tulivyo mmoja; ");
INSERT INTO swh1850_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mimi niwe ndani yao, nawe uwe ndani yangu; naomba wakamilishwe na kuwa kitu kimoja, ili ulimwengu upate kujua kwamba wewe ulinituma, na kwamba unawapenda wao kama unavyonipenda mimi. ");
INSERT INTO swh1850_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Baba! Nataka wao ulionipa wawe pamoja nami pale nilipo, ili wauone utukufu wangu ulionipa; kwa kuwa ulinipenda kabla ya kuumbwa ulimwengu. ");
INSERT INTO swh1850_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba Mwema! Ulimwengu haukujui, lakini mimi nakujua. Hawa nao wanajua kwamba wewe ulinituma. ");
INSERT INTO swh1850_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nimekufanya ujulikane kwao na nitaendelea kufanya hivyo, ili upendo ulio nao kwangu uwe ndani yao, nami niwe ndani yao.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu alipokwisha sema hayo, alikwenda ng'ambo ya kijito Kedroni, pamoja na wanafunzi wake. Mahali hapo palikuwa na bustani, naye Yesu akaingia humo pamoja na wanafunzi wake. ");
INSERT INTO swh1850_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, aliyemsaliti Yesu, alipajua mahali hapo kwani mara nyingi Yesu alikutana na wanafunzi wake huko. ");
INSERT INTO swh1850_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Basi, Yuda alichukua kikosi cha askari na walinzi kutoka kwa makuhani wakuu na Mafarisayo, akaja nao bustanini wakiwa na taa, mienge na silaha. ");
INSERT INTO swh1850_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, hali akijua yote yatakayompata, akatokea, akawauliza, “Mnamtafuta nani?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nao wakamjibu, “Yesu wa Nazareti!” Yesu akawaambia, “Mimi ndiye.” Msaliti Yuda alikuwa amesimama hapo pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Basi, Yesu alipowaambia: “Mimi ndiye”, wakarudi nyuma, wakaanguka chini. ");
INSERT INTO swh1850_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu akawauliza tena, “Mnamtafuta nani?” Wakamjibu, “Yesu wa Nazareti!” ");
INSERT INTO swh1850_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akawaambia, “Nimekwisha waambieni kwamba mimi ndiye. Basi, kama mnanitafuta mimi, waacheni hawa waende zao.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Alisema hayo ili yapate kutimia yale aliyosema: “Wale ulionipa sikumpoteza hata mmoja.”) ");
INSERT INTO swh1850_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petro alikuwa na upanga; basi, akauchomoa, akamkata sikio la kulia mtumishi wa Kuhani Mkuu. Mtumishi huyo aliitwa Malko. ");
INSERT INTO swh1850_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Basi, Yesu akamwambia Petro, “Rudisha upanga wako alani. Je, nisinywe kikombe alichonipa Baba?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kile kikosi cha askari, mkuu wake na walinzi wa Wayahudi walimkamata Yesu, wakamfunga ");
INSERT INTO swh1850_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","na kumpeleka kwanza kwa Anasi; Anasi alikuwa baba mkwe wa Kayafa ambaye alikuwa Kuhani Mkuu mwaka huo. ");
INSERT INTO swh1850_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Huyo Kayafa ndiye aliyekuwa amewashauri Wayahudi kwamba ni afadhali mtu mmoja afe kwa ajili ya taifa. ");
INSERT INTO swh1850_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petro pamoja na mwanafunzi mwingine walimfuata Yesu. Huyo mwanafunzi mwingine alikuwa anajulikana kwa Kuhani Mkuu, hivyo aliingia pamoja na Yesu ndani ya ukumbi wa Kuhani Mkuu. ");
INSERT INTO swh1850_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lakini Petro alikuwa amesimama nje, karibu na mlango. Basi, huyo mwanafunzi mwingine aliyekuwa anajulikana kwa Kuhani Mkuu alitoka nje akasema na mjakazi, mngoja mlango, akamwingiza Petro ndani. ");
INSERT INTO swh1850_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Huyo msichana mngoja mlango akamwuliza Petro, “Je, nawe pia ni mmoja wa wanafunzi wa mtu huyu?” Petro akamwambia, “Si mimi!” ");
INSERT INTO swh1850_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Watumishi na walinzi walikuwa wamewasha moto kwa sababu kulikuwa na baridi, wakawa wanaota moto. Naye Petro alikuwa amesimama pamoja nao akiota moto. ");
INSERT INTO swh1850_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Basi, Kuhani akamwuliza Yesu juu ya wanafunzi wake na mafundisho yake. ");
INSERT INTO swh1850_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akamjibu, “Nimesema na kila mtu daima hadharani. Kila mara nimefundisha katika masunagogi na Hekaluni, mahali wakutanikiapo Wayahudi wote; na wala sijasema chochote kwa siri. ");
INSERT INTO swh1850_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwa nini waniuliza mimi? Waulize wale waliosikia nini niliwaambia. Wao wanajua nilivyosema.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Alipokwisha sema hayo mlinzi mmoja aliyekuwa amesimama hapo akampiga kofi akisema, “Je, ndivyo unavyomjibu Kuhani Mkuu?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu akamjibu, “Kama nimesema vibaya, onyesha huo ubaya; lakini ikiwa nimesema vema, mbona wanipiga?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Basi, Anasi akampeleka Yesu akiwa amefungwa, kwa Kuhani Mkuu Kayafa. ");
INSERT INTO swh1850_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petro alikuwa hapo akiota moto. Basi, wakamwuliza, “Je, nawe pia si mmoja wa wanafunzi wake?” Yeye akakana na kusema, “Si mimi!” ");
INSERT INTO swh1850_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mmoja wa watumishi wa Kuhani Mkuu, jamaa wa yule aliyekatwa sikio na Petro, akamwuliza, “Je, mimi sikukuona wewe bustanini pamoja naye?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro akakana tena; mara jogoo akawika. ");
INSERT INTO swh1850_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Basi, walimchukua Yesu kutoka kwa Kayafa, wakampeleka ikulu. Ilikuwa alfajiri, nao ili waweze kula Pasaka, hawakuingia ndani ya ikulu wasije wakatiwa najisi. ");
INSERT INTO swh1850_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwa hiyo, Pilato aliwaendea nje, akasema, “Mna mashtaka gani juu ya mtu huyu?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wakamjibu, “Kama huyu hangalikuwa mwovu hatungalimleta kwako.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato akawaambia, “Haya, mchukueni ninyi wenyewe, mkamhukumu kufuatana na Sheria yenu.” Wayahudi wakamjibu, “Sisi hatuna mamlaka ya kumwua mtu yeyote.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ilifanyika hivyo yapate kutimia maneno aliyosema Yesu kuonyesha atakufa kifo gani.) ");
INSERT INTO swh1850_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato akaingia tena ndani ya ikulu, akamwita Yesu na kumwuliza: “Ati wewe ndiye Mfalme wa Wayahudi?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu akamjibu, “Je, hayo ni maneno yako au wengine wamekwambia habari zangu?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato akamjibu, “Je, ni Myahudi mimi? Taifa lako na makuhani wamekuleta kwangu. Umefanya nini?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akamjibu, “Ufalme wangu si wa ulimwengu huu. Kama ufalme wangu ungekuwa wa ulimwengu huu watumishi wangu wangenipigania nisitiwe mikononi mwa Wayahudi. Lakini sasa ufalme wangu si wa hapa.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hapo Pilato akamwambia, “Basi, wewe ni Mfalme?” Yesu akajibu, “Wewe umesema kwamba mimi ni Mfalme. Mimi nimezaliwa kwa ajili hiyo; na kwa ajili hiyo nimekuja ulimwenguni kuwaambia watu juu ya ukweli. Kila mtu wa ukweli hunisikiliza.” ");
INSERT INTO swh1850_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato akamwambia, “Ukweli ni kitu gani?” Pilato alipokwisha sema hayo, aliwaendea tena Wayahudi nje, akawaambia, “Mimi sioni hatia yoyote kwake. ");
INSERT INTO swh1850_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lakini, mnayo desturi kwamba mimi niwafungulie mfungwa mmoja wakati wa Pasaka. Basi, mwataka niwafungulieni Mfalme wa Wayahudi?” ");
INSERT INTO swh1850_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hapo wakapiga kelele: “La! Si huyu ila Baraba!” Naye Baraba alikuwa mnyang'anyi. ");
INSERT INTO swh1850_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Basi, Pilato akaamuru Yesu achukuliwe, apigwe viboko. ");
INSERT INTO swh1850_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nao askari wakasokota taji ya miiba, wakamtia kichwani, wakamvika na joho la rangi ya zambarau. ");
INSERT INTO swh1850_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wakawa wanakuja mbele yake na kusema: “Shikamoo, Mfalme wa Wayahudi!” Wakampiga makofi. ");
INSERT INTO swh1850_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato akatoka tena nje, akawaambia, “Tazameni, namleta nje kwenu, mpate kujua kwamba mimi sikuona hatia yoyote kwake.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Basi, Yesu akatoka nje amevaa taji ya miiba na joho la rangi ya zambarau. Pilato akawaambia, “Tazameni! Mtu mwenyewe ni huyo.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Makuhani wakuu na walinzi walipomwona wakapaaza sauti: “Msulubishe! Msulubishe!” Pilato akawaambia, “Mchukueni basi, ninyi wenyewe mkamsulubishe, kwa maana mimi sikuona hatia yoyote kwake.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wakamjibu, “Sisi tunayo Sheria, na kufuatana na Sheria hiyo, ni lazima afe, kwa sababu alijifanya kuwa Mwana wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato aliposikia maneno hayo akazidi kuogopa. ");
INSERT INTO swh1850_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Basi, akaingia tena ndani ya ikulu, akamwuliza Yesu, “Umetoka wapi wewe?” Lakini Yesu hakumjibu neno. ");
INSERT INTO swh1850_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hivyo Pilato akamwambia, “Husemi nami? Je, hujui kwamba ninayo mamlaka ya kukufungua na mamlaka ya kukusulubisha?” ");
INSERT INTO swh1850_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akamjibu, “Hungekuwa na mamlaka yoyote juu yangu kama hungepewa na Mungu. Kwa sababu hiyo, yule aliyenikabidhi kwako ana dhambi kubwa zaidi.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tangu hapo, Pilato akawa anatafuta njia ya kumwachilia, lakini Wayahudi wakapiga kelele: “Ukimwachilia huyu mtu, wewe si rafiki yake Kaisari; kila mtu anayejifanya kuwa Mfalme humpinga Kaisari!” ");
INSERT INTO swh1850_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Basi, Pilato aliposikia maneno hayo akamleta Yesu nje, akaketi juu ya kiti cha hukumu, mahali paitwapo: “Sakafu ya Mawe” (kwa Kiebrania, Gabatha). ");
INSERT INTO swh1850_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ilikuwa yapata saa sita mchana, siku ya maandalio ya Pasaka. Pilato akawaambia Wayahudi, “Tazameni, Mfalme wenu!” ");
INSERT INTO swh1850_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wao wakapaaza sauti: “Mwondoe! Mwondoe! Msulubishe!” Makuhani wakuu wakajibu, “Sisi hatuna Mfalme isipokuwa Kaisari!” ");
INSERT INTO swh1850_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Basi, hapo Pilato akamtia Yesu mikononi mwao ili asulubiwe. Basi, wakamchukua Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Naye akatoka akiwa amejichukulia msalaba wake kwenda mahali paitwapo “Fuvu la Kichwa”, (kwa Kiebrania Golgotha). ");
INSERT INTO swh1850_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hapo ndipo walipomsulubisha, na pamoja naye waliwasulubisha watu wengine wawili; mmoja upande wake wa kulia na mwingine upande wake wa kushoto, naye Yesu katikati. ");
INSERT INTO swh1850_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato aliandika ilani akaiweka juu ya msalaba. Nayo ilikuwa imeandikwa hivi: “Yesu wa Nazareti, Mfalme wa Wayahudi.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi wengi waliisoma ilani hiyo, maana mahali hapo aliposulubiwa Yesu palikuwa karibu na mji. Tena ilani hiyo ilikuwa imeandikwa kwa Kiebrania, Kilatini, na Kigiriki. ");
INSERT INTO swh1850_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Basi, makuhani wakuu wakamwambia Pilato, “Usiandike: Mfalme wa Wayahudi, ila Yeye alisema, Mimi ni Mfalme wa Wayahudi.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato akajibu, “Niliyoandika, nimeandika!” ");
INSERT INTO swh1850_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Askari walipokwisha msulubisha Yesu, walizichukua nguo zake, wakazigawa mafungu manne, fungu moja kwa kila askari. Walichukua pia na kanzu yake; kanzu hiyo ilikuwa imefumwa kwa kipande kimoja tu, bila mshono. ");
INSERT INTO swh1850_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Basi, hao askari wakashauriana: “Tusiipasue, ila tuipigie kura itakuwa ya nani.” Jambo hilo lilifanyika ili yatimie Maandiko Matakatifu yasemayo: “Waligawana mavazi yangu, na nguo yangu wakaipigia kura.” Basi, ndivyo walivyofanya hao askari. ");
INSERT INTO swh1850_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Karibu na msalaba wake Yesu walikuwa wamesimama mama yake, na dada ya mama yake, Maria mke wa Kleopa, na Maria Magdalene. ");
INSERT INTO swh1850_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu alipomwona mama yake, na karibu naye amesimama yule mwanafunzi aliyempenda, akamwambia mama yake: “Mama! Tazama, huyo ndiye mwanao.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Halafu akamwambia yule mwanafunzi: “Tazama, huyo ndiye mama yako.” Na tangu saa ile huyo mwanafunzi alimchukua akae nyumbani kwake. ");
INSERT INTO swh1850_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu alijua kwamba yote yalikuwa yametimia; na, ili Maandiko Matakatifu yapate kutimia, akasema, “Naona kiu.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hapo palikuwa na bakuli limejaa siki. Basi, wakachovya sifongo katika hiyo siki, wakaitia juu ya ufito wa husopo, wakamwekea mdomoni. ");
INSERT INTO swh1850_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu alipokwisha pokea hiyo siki, akasema, “Yametimia!” Kisha akainama kichwa, akatoa roho. ");
INSERT INTO swh1850_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ilikuwa Ijumaa, siku ya Maandalio. Kwa hiyo, kusudi miili isikae msalabani siku ya Sabato, maana siku hiyo ya Sabato ilikuwa siku kubwa, Wayahudi walimwomba Pilato miguu ya hao waliosulubiwa ivunjwe na miili yao iondolewe. ");
INSERT INTO swh1850_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Basi, askari walikwenda, wakaivunja miguu ya yule mtu wa kwanza na yule wa pili ambao walikuwa wamesulubiwa pamoja na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lakini walipomfikia Yesu waliona kwamba alikwisha kufa, na hivyo hawakumvunja miguu. ");
INSERT INTO swh1850_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakini askari mmoja alimtoboa ubavuni kwa mkuki, na mara ikatoka damu na maji. ");
INSERT INTO swh1850_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Naye aliyeona tukio hilo ametoa habari zake ili nanyi mpate kuamini. Na hayo aliyosema ni ukweli, tena yeye anajua kwamba anasema ukweli.) ");
INSERT INTO swh1850_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jambo hilo lilitendwa ili Maandiko Matakatifu yatimie: “Hapana hata mfupa wake mmoja utakaovunjwa.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tena Maandiko mengine yanasema: “Watamtazama yule waliyemtoboa.” ");
INSERT INTO swh1850_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baada ya hayo, Yosefu, mwenyeji wa Armathaya, alimwomba Pilato ruhusa ya kuuchukua mwili wa Yesu. (Yosefu alikuwa mfuasi wa Yesu, lakini kwa siri, maana aliwaogopa viongozi wa Wayahudi). Basi, Pilato akamruhusu. Hivyo Yosefu alikwenda, akauondoa mwili wa Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naye Nikodemo ambaye hapo awali alikuwa amemwendea Yesu usiku, akaja akiwa amechukua mchanganyiko wa manemane na ubani kiasi cha kilo thelathini. ");
INSERT INTO swh1850_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Basi, waliutwaa mwili wa Yesu, wakaufunga sanda pamoja na manukato kufuatana na desturi ya Wayahudi katika kuzika. ");
INSERT INTO swh1850_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mahali hapo aliposulubiwa Yesu palikuwa na bustani, na katika bustani hiyo kulikuwa na kaburi jipya ambalo hakutiwa bado mtu yeyote ndani yake. ");
INSERT INTO swh1850_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Basi, kwa sababu ya shughuli za Wayahudi za maandalio ya Sabato, na kwa vile kaburi hilo lilikuwa karibu, wakamweka Yesu humo. ");
INSERT INTO swh1850_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Alfajiri na mapema Jumapili, kukiwa bado na giza, Maria Magdalene alikwenda kaburini, akaliona lile jiwe limeondolewa mlangoni pa kaburi. ");
INSERT INTO swh1850_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Basi, akaenda mbio hadi kwa Petro na yule mwanafunzi mwingine ambaye Yesu alimpenda, akawaambia, “Wamemwondoa Bwana kaburini, na wala hatujui walikomweka.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petro pamoja na yule mwanafunzi mwingine wakaenda kaburini. ");
INSERT INTO swh1850_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wote wawili walikimbia lakini yule mwanafunzi mwingine alikimbia mbio zaidi kuliko Petro, akatangulia kufika kaburini. ");
INSERT INTO swh1850_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Alipoinama na kuchungulia ndani, aliona sanda, lakini hakuingia ndani. ");
INSERT INTO swh1850_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petro naye akaja akimfuata, akaingia kaburini; humo akaona sanda, ");
INSERT INTO swh1850_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kile kitambaa alichofungwa Yesu kichwani. Hicho kitambaa hakikuwekwa pamoja na hiyo sanda, bali kilikuwa kimekunjwa na kuwekwa mahali peke yake. ");
INSERT INTO swh1850_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kisha yule mwanafunzi mwingine aliyemtangulia kufika kaburini, akaingia pia ndani, akaona, akaaamini. ");
INSERT INTO swh1850_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Walikuwa bado hawajaelewa Maandiko Matakatifu yaliyosema kwamba ilikuwa lazima afufuke kutoka wafu). ");
INSERT INTO swh1850_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Basi, hao wanafunzi wakarudi nyumbani. ");
INSERT INTO swh1850_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria alikuwa amesimama nje ya kaburi, akilia. Huku akiwa bado analia, aliinama na kuchungulia kaburini, ");
INSERT INTO swh1850_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akawaona malaika wawili waliovaa mavazi meupe, wameketi pale mwili wa Yesu ulipokuwa umelazwa, mmoja kichwani na wa pili miguuni. ");
INSERT INTO swh1850_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hao malaika wakamwuliza, “Mama, kwa nini unalia?” Naye akawaambia, “Wamemwondoa Bwana wangu, na wala sijui walikomweka!” ");
INSERT INTO swh1850_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Baada ya kusema hayo, aligeuka nyuma, akamwona Yesu amesimama hapo, lakini asitambue ya kuwa ni Yesu. ");
INSERT INTO swh1850_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu akamwuliza, “Mama, kwa nini unalia? Unamtafuta nani?” Maria, akidhani kwamba huyo ni mtunza bustani, akamwambia, “Mheshimiwa, kama ni wewe umemwondoa, niambie ulikomweka, nami nitamchukua.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu akamwambia, “Maria!” Naye Maria akageuka, akamwambia kwa Kiebrania, “Raboni” (yaani “Mwalimu”). ");
INSERT INTO swh1850_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu akamwambia, “Usinishike; sijakwenda bado juu kwa Baba. Lakini nenda kwa ndugu zangu uwaambie: nakwenda juu kwa Baba yangu na Baba yenu, Mungu wangu na Mungu wenu.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hivyo Maria Magdalene akaenda akawapa habari wale wanafunzi kuwa amemwona Bwana, na kwamba alikuwa amemwambia hivyo. ");
INSERT INTO swh1850_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ilikuwa jioni ya siku hiyo ya Jumapili. Wanafunzi walikuwa wamekutana pamoja ndani ya nyumba, na milango ilikuwa imefungwa kwa sababu waliwaogopa viongozi wa Wayahudi. Basi, Yesu akaja, akasimama kati yao, akawaambia, “Amani kwenu!” ");
INSERT INTO swh1850_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Alipokwisha sema hayo, akawaonyesha mikono yake na ubavu wake. Basi, hao wanafunzi wakafurahi mno kumwona Bwana. ");
INSERT INTO swh1850_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu akawaambia tena, “Amani kwenu! Kama vile Baba alivyonituma mimi, nami nawatuma ninyi.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Alipokwisha sema hayo, akawapulizia na kuwaambia, “Pokeeni Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mkiwasamehe watu dhambi zao, wamesamehewa; msipowaondolea, hawasamehewi.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thoma mmoja wa wale kumi na wawili (aitwaye Pacha), hakuwa pamoja nao wakati Yesu alipokuja. ");
INSERT INTO swh1850_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Basi, wale wanafunzi wengine wakamwambia, “Tumemwona Bwana.” Thoma akawaambia, “Nisipoona mikononi mwake alama za misumari, na kutia kidole changu katika kovu hizo, na kutia mkono wangu ubavuni mwake, sitasadiki.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Basi, baada ya siku nane hao wanafunzi walikuwa tena pamoja mle ndani, na Thoma alikuwa pamoja nao. Milango ilikuwa imefungwa, lakini Yesu akaja, akasimama kati yao, akasema, “Amani kwenu!” ");
INSERT INTO swh1850_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kisha akamwambia Thoma, “Lete kidole chako hapa uitazame mikono yangu; lete mkono wako ukautie ubavuni mwangu. Usiwe na mashaka, ila amini!” ");
INSERT INTO swh1850_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thoma akamjibu, “Bwana wangu na Mungu wangu!” ");
INSERT INTO swh1850_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu akamwambia, “Je, unaamini kwa kuwa umeniona? Heri yao wale ambao hawajaona, lakini wameamini.” ");
INSERT INTO swh1850_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu alifanya mbele ya wanafunzi wake ishara nyingine nyingi ambazo hazikuandikwa katika kitabu hiki. ");
INSERT INTO swh1850_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lakini hizi zimeandikwa ili mpate kuamini kwamba Yesu ni Kristo, Mwana wa Mungu; na kwa kuamini mpate kuwa na uzima kwa nguvu ya jina lake. ");
INSERT INTO swh1850_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baada ya hayo Yesu aliwatokea tena wanafunzi wake kando ya ziwa Tiberia. Aliwatokea hivi: ");
INSERT INTO swh1850_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petro, Thoma (aitwaye Pacha), na Nathanieli mwenyeji wa Kana Galilaya, wana wawili wa Zebedayo na wanafunzi wake wengine wawili, walikuwa wote pamoja. ");
INSERT INTO swh1850_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petro aliwaambia, “Nakwenda kuvua samaki.” Nao wakamwambia, “Nasi tutafuatana nawe.” Basi, wakaenda, wakapanda mashua, lakini usiku huo hawakupata chochote. ");
INSERT INTO swh1850_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kulipoanza kupambazuka, Yesu alisimama kando ya ziwa, lakini wanafunzi hawakujua kwamba alikuwa yeye. ");
INSERT INTO swh1850_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Basi, Yesu akawauliza, “Vijana, hamjapata samaki wowote sio?” Wao wakamjibu, “La! Hatujapata kitu.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu akawaambia, “Tupeni wavu upande wa kulia wa mashua nanyi mtapata samaki.” Basi, wakatupa wavu lakini sasa hawakuweza kuuvuta tena kwa wingi wa samaki. ");
INSERT INTO swh1850_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hapo yule mwanafunzi aliyependwa na Yesu akamwambia Petro, “Ni Bwana!” Simoni Petro aliposikia ya kuwa ni Bwana, akajifunga vazi lake (maana hakuwa amelivaa), akarukia majini. ");
INSERT INTO swh1850_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lakini wale wanafunzi wengine walikuja pwani kwa mashua huku wanauvuta wavu uliojaa samaki; hawakuwa mbali na nchi kavu, ila walikuwa yapata mita mia moja kutoka ukingoni. ");
INSERT INTO swh1850_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Walipofika nchi kavu waliona moto wa makaa umewashwa na juu yake pamewekwa samaki na mkate. ");
INSERT INTO swh1850_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu akawaambia, “Leteni hapa baadhi ya samaki mliovua.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Basi, Simoni Petro akapanda mashuani, akavuta hadi nchi kavu ule wavu uliokuwa umejaa samaki wakubwa mia moja na hamsini na watatu. Na ingawa walikuwa wengi hivyo wavu haukukatika. ");
INSERT INTO swh1850_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu akawaambia, “Njoni mkafungue kinywa.” Hakuna hata mmoja wao aliyethubutu kumwuliza: “Wewe ni nani?” Maana walijua alikuwa Bwana. ");
INSERT INTO swh1850_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu akaja, akatwaa mkate akawapa; akafanya vivyo hivyo na wale samaki. ");
INSERT INTO swh1850_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hii ilikuwa mara ya tatu Yesu kuwatokea wanafunzi wake baada ya kufufuka kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Walipokwisha kula, Yesu alimwuliza Simoni Petro, “Simoni, mwana wa Yohane! Je, wanipenda mimi zaidi kuliko hawa?” Naye akajibu, “Naam, Bwana; wajua kwamba mimi nakupenda.” Yesu akamwambia, “Tunza wana kondoo wangu.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kisha akamwambia mara ya pili, “Simoni mwana wa Yohane! Je, wanipenda?” Petro akamjibu, “Naam, Bwana; wajua kwamba nakupenda.” Yesu akamwambia, “Tunza kondoo wangu.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamwuliza mara ya tatu, “Simoni mwana wa Yohane! Je, wanipenda?” Hapo Petro akahuzunika kwa sababu alimwuliza mara ya tatu: “Wanipenda?” akamwambia, “Bwana, wewe wajua yote; wewe wajua kwamba mimi nakupenda.” Yesu akamwambia, “Tunza kondoo wangu! ");
INSERT INTO swh1850_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kweli nakwambia, ulipokuwa kijana ulizoea kujifunga mshipi na kwenda kokote ulikotaka. Lakini utakapokuwa mzee utanyosha mikono yako, na mtu mwingine atakufunga na kukupeleka usikopenda kwenda.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Kwa kusema hivyo, alionyesha jinsi Petro atakavyokufa na kumtukuza Mungu.) Kisha akamwambia, “Nifuate.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hapo Petro akageuka, akamwona yule mwanafunzi ambaye Yesu alimpenda, anafuata (Huyu mwanafunzi ndiye yule ambaye wakati wa chakula cha jioni, alikaa karibu sana na Yesu na kumwuliza: “Bwana ni nani atakayekusaliti?”) ");
INSERT INTO swh1850_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Basi, Petro alipomwona huyo akamwuliza Yesu, “Bwana, na huyu je?” ");
INSERT INTO swh1850_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu akamjibu, “Kama nataka abaki mpaka nitakapokuja, yakuhusu nini? Wewe nifuate mimi.” ");
INSERT INTO swh1850_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Basi, habari hiyo ikaenea miongoni mwa wale ndugu kwamba mwanafunzi huyo hafi. Lakini Yesu hakumwambia kwamba mwanafunzi huyo hafi, ila, “Kama nataka abaki mpaka nitakapokuja, yakuhusu nini?” ");
INSERT INTO swh1850_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Huyo ndiye yule aliyeshuhudia mambo haya na kuyaandika. Nasi twajua kwamba aliyoyasema ni kweli. ");
INSERT INTO swh1850_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuna mambo mengine mengi aliyofanya Yesu, ambayo kama yangeandikwa yote, moja baada ya lingine, nadhani hata ulimwengu wenyewe usingetosha kuviweka vitabu ambavyo vingeandikwa. ");
INSERT INTO swh1850_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ndugu Theofilo, Katika kitabu cha kwanza niliandika juu ya mambo yote Yesu aliyotenda na kufundisha tangu mwanzo wa kazi yake ");
INSERT INTO swh1850_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka siku ile alipochukuliwa mbinguni. Kabla ya kuchukuliwa mbinguni aliwapa maagizo kwa njia ya Roho Mtakatifu wale mitume aliowachagua. ");
INSERT INTO swh1850_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa muda wa siku arobaini baada ya kifo chake aliwatokea mara nyingi kwa namna ambazo zilithibitisha kabisa kwamba alikuwa hai. Walimwona, naye aliongea nao juu ya ufalme wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wakati walipokutana pamoja aliwaamuru hivi: “Msiondoke Yerusalemu, bali ngojeeni ile zawadi aliyoahidi Baba, zawadi ambayo mlikwisha nisikia nikiongea juu yake. ");
INSERT INTO swh1850_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwani Yohane alibatiza kwa maji, lakini baada ya siku chache, ninyi mtabatizwa kwa Roho Mtakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Basi, mitume walipokutana pamoja na Yesu, walimwuliza, “Je Bwana, wakati huu ndipo utakaporudisha ule ufalme kwa Israeli?” ");
INSERT INTO swh1850_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lakini Yesu akawaambia, “Nyakati na majira ya mambo hayo viko chini ya mamlaka ya Baba yangu, wala si shauri lenu kujua yatakuwa lini. ");
INSERT INTO swh1850_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini wakati Roho Mtakatifu atakapowashukieni ninyi, mtajazwa nguvu na mtakuwa mashahidi wangu katika Yerusalemu, katika nchi yote ya Yudea na Samaria, na hata miisho ya dunia.” ");
INSERT INTO swh1850_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Baada ya kusema hayo, wote wakiwa wanamtazama, alichukuliwa mbinguni; wingu likamficha wasimwone tena. ");
INSERT INTO swh1850_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Walipokuwa bado wanatazama juu angani, akiwa anakwenda zake, mara watu wawili waliokuwa wamevaa nguo nyeupe walisimama karibu nao, ");
INSERT INTO swh1850_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","wakasema, “Enyi wananchi wa Galilaya! Mbona mnasimama mkitazama angani? Yesu huyu ambaye amechukuliwa kutoka kwenu kwenda mbinguni atakuja tena namna hiyohiyo mliivyomwona akienda mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kisha mitume wakarudi Yerusalemu kutoka mlima wa Mizeituni ulioko karibu kilomita moja kutoka mjini. ");
INSERT INTO swh1850_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Walipofika mjini waliingia katika chumba ghorofani ambamo walikuwa wanakaa; nao walikuwa Petro, Yohane, Yakobo, Andrea, Filipo na Thoma, Bartholomayo na Mathayo, Yakobo mwana wa Alfayo, Simoni Zelote na Yuda mwana wa Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hawa wote walikusanyika pamoja kusali, pamoja na wanawake kadha wa kadha, na Maria mama yake Yesu, na ndugu zake. ");
INSERT INTO swh1850_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Siku chache baadaye, kulikuwa na mkutano wa waumini, karibu watu mia moja na ishirini. Petro alisimama mbele yao, ");
INSERT INTO swh1850_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akasema, “Ndugu zangu, ilikuwa lazima ile sehemu ya Maandiko Matakatifu itimie, sehemu ambayo Roho Mtakatifu, kwa maneno ya Daudi, alibashiri habari za Yuda ambaye aliwaongoza wale waliomtia Yesu nguvuni. ");
INSERT INTO swh1850_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda alikuwa mmoja wa kikundi chetu maana alichaguliwa ashiriki huduma yetu. ");
INSERT INTO swh1850_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(“Mnajua kwamba yeye alinunua shamba kwa zile fedha alizopata kutokana na kitendo chake kiovu. Akaanguka chini, akapasuka na matumbo yake yakamwagika nje. ");
INSERT INTO swh1850_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila mtu katika Yerusalemu alisikia habari za tukio hilo na hivyo, kwa lugha yao, wakaliita lile shamba Hekeli Dama, maana yake, Shamba la Damu.) ");
INSERT INTO swh1850_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Basi, imeandikwa katika kitabu cha Zaburi: Nyumba yake ibaki mahame; mtu yeyote asiishi ndani yake. Tena imeandikwa: Mtu mwingine achukue nafasi yake katika huduma hiyo. ");
INSERT INTO swh1850_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kwa hiyo, ni lazima mtu mwingine ajiunge nasi kama shahidi wa ufufuo wake Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Anapaswa kuwa mmoja wa wale waliokuwa katika kundi letu wakati wote Bwana alipokuwa anasafiri pamoja nasi, tangu wakati Yohane alipokuwa anabatiza mpaka siku ile Yesu alipochukuliwa kutoka kwetu kwenda mbinguni.” ");
INSERT INTO swh1850_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Basi, wakataja majina ya watu wawili; wa kwanza Yosefu aliyeitwa Barsaba (au pia Yusto), na wa pili Mathia. ");
INSERT INTO swh1850_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kisha wakasali: “Bwana, wewe unajua mioyo ya watu wote. Hivyo, utuonyeshe ni yupi kati ya hawa wawili uliyemchagua ");
INSERT INTO swh1850_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ili achukue nafasi hii ya huduma ya kitume aliyoacha Yuda akaenda mahali pake mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hapo, wakapiga kura; kura ikampata Mathia, naye akaongezwa katika idadi ya wale mitume wengine kumi na mmoja. ");
INSERT INTO swh1850_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Siku ya Pentekoste ilipofika, waumini wote walikuwa wamekusanyika pamoja. ");
INSERT INTO swh1850_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ghafla, sauti ikasikika kutoka angani; sauti iliyokuwa kama ya upepo mkali, ikajaza ile nyumba yote walimokuwa wamekaa. ");
INSERT INTO swh1850_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kisha, vikatokea vitu vilivyoonekana kama ndimi za moto, vikagawanyika na kutua juu ya kila mmoja wao. ");
INSERT INTO swh1850_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wote wakajazwa Roho Mtakatifu, wakaanza kusema lugha mbalimbali kadiri Roho alivyowawezesha. ");
INSERT INTO swh1850_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na huko Yerusalemu walikuwako Wayahudi, watu wamchao Mungu, waliotoka katika kila nchi duniani. ");
INSERT INTO swh1850_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Waliposikia sauti hiyo, kundi kubwa la watu lilikusanyika. Wote walishtuka sana kwani kila mmoja wao aliwasikia hao waumini wakisema kwa lugha yake mwenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Walistaajabu na kushangaa, wakisema, “Je, hawa wote tunaowasikia wakisema hivi, si wenyeji wa Galilaya? ");
INSERT INTO swh1850_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Imekuwaje, basi, kwamba kila mmoja wetu anawasikia wakisema kwa lugha yake mwenyewe? ");
INSERT INTO swh1850_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Baadhi yetu ni Waparthi, Wamedi na Waelami; wengine ni wenyeji wa Mesopotamia, Yudea, Kapadokia, Ponto na Asia, ");
INSERT INTO swh1850_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frugia na Pamfulia, Misri na sehemu za Libya karibu na Kurene; wengine wetu ni wageni kutoka Roma, ");
INSERT INTO swh1850_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wayahudi na watu walioongokea dini ya Kiyahudi; wengine wametoka Krete na Arabia. Sisi sote tunasikia wakisema kwa lugha zetu wenyewe mambo makuu ya Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wote walishangaa na kufadhaika huku wakiulizana, “Hii ina maana gani?” ");
INSERT INTO swh1850_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini wengine wakawadhihaki wakisema, “Watu hawa wamelewa divai mpya!” ");
INSERT INTO swh1850_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lakini Petro alisimama pamoja na wale kumi na mmoja akaanza kuwahutubia watu kwa sauti kubwa: “Ndugu Wayahudi nanyi nyote mnaokaa hapa Yerusalemu, sikilizeni kwa makini maneno yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Watu hawa hawakulewa kama mnavyodhani; mbona ni saa tatu tu asubuhi? ");
INSERT INTO swh1850_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ukweli ni kwamba jambo hili ni lile alilosema nabii Yoeli: ");
INSERT INTO swh1850_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Katika siku zile za mwisho, asema Bwana, nitawamiminia binadamu wote Roho wangu. Watoto wenu, wanaume kwa wanawake, watautangaza ujumbe wangu; vijana wenu wataona maono, na wazee wenu wataota ndoto. ");
INSERT INTO swh1850_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Naam, hata watumishi wangu, wanaume kwa wanawake, nitawamiminia Roho wangu, siku zile, nao watautangaza ujumbe wangu. ");
INSERT INTO swh1850_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nitatenda miujiza juu angani, na ishara chini duniani; kutakuwa na damu, moto na moshi mzito; ");
INSERT INTO swh1850_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","jua litatiwa giza, na mwezi utakuwa mwekundu kama damu, kabla ya kutokea ile siku kuu na tukufu ya Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hapo, yeyote atakayeomba kwa jina la Bwana, ataokolewa. ");
INSERT INTO swh1850_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wananchi wa Israeli, sikilizeni maneno haya! Yesu wa Nazareti alikuwa mtu ambaye mamlaka yake ya kimungu yalithibitishwa kwenu kwa miujiza, maajabu na ishara Mungu alizofanya kati yenu kwa njia yake, kama mnavyojua. ");
INSERT INTO swh1850_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kufuatana na mpango wake mwenyewe Mungu alikwisha amua kwamba Yesu angetiwa mikononi mwenu; nanyi mkamuua kwa kuwaachia watu wabaya wamsulubishe. ");
INSERT INTO swh1850_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lakini Mungu alimfufua kutoka wafu akamwokoa katika maumivu ya kifo kwa maana haingewezekana kabisa kifo kimfunge. ");
INSERT INTO swh1850_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Maana Daudi alisema juu yake hivi: Nilimwona Bwana mbele yangu daima; yuko nami upande wangu wa kulia, na hivyo sitatikisika. ");
INSERT INTO swh1850_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa hiyo, moyo wangu ulifurahi; tena nilipiga vigelegele vya furaha. Mwili wangu utakaa katika tumaini; ");
INSERT INTO swh1850_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwa kuwa hutaiacha roho yangu katika kuzimu, wala kumruhusu mtakatifu wako aoze. ");
INSERT INTO swh1850_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Umenionyesha njia za kuufikia uzima, kuwako kwako kwanijaza furaha! ");
INSERT INTO swh1850_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ndugu zangu, napenda kuwaambieni waziwazi juu ya mambo yaliyompata Daudi, babu yetu. Yeye alikufa, akazikwa, tena kaburi lake liko papa hapa petu mpaka leo. ");
INSERT INTO swh1850_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lakini kwa vile Daudi alikuwa nabii, alijua kuwa Mungu alimwapia kiapo kwamba atamtawaza mmoja wa uzawa wake kuwa mfalme mahali pake. ");
INSERT INTO swh1850_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi aliona kabla mambo yatakayofanywa na Mungu na hivyo akasema juu ya ufufuo wa Kristo wakati aliposema: Hakuachwa kuzimu, mwili wake haukuoza. ");
INSERT INTO swh1850_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Basi, Mungu alimfufua huyo Yesu na sisi sote ni mashahidi wa tukio hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu aliinuliwa juu mpaka upande wa kulia wa Mungu, akapokea kutoka kwa Baba ile zawadi aliyoahidi yaani Roho Mtakatifu; na mnachoona sasa na kusikia ni mmiminiko wa huyo Roho. ");
INSERT INTO swh1850_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Maana Daudi mwenyewe, hakupanda mpaka mbinguni; ila yeye alisema: Bwana alimwambia Bwana wangu: Keti upande wangu wa kulia, ");
INSERT INTO swh1850_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hadi nitakapowafanya adui zako kibao cha kukanyagia miguu yako. ");
INSERT INTO swh1850_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Watu wote wa Israeli wanapaswa kufahamu kwa hakika kwamba huyo Yesu mliyemsulubisha ninyi, ndiye huyo ambaye Mungu amemfanya kuwa Bwana na Kristo.” ");
INSERT INTO swh1850_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Basi, watu waliposikia hayo, walichomwa moyo, wakawauliza Petro na wale mitume wenzake: “Ndugu zetu, tufanye nini?” ");
INSERT INTO swh1850_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petro akajibu, “Tubuni na kila mmoja wenu abatizwe kwa jina la Yesu Kristo ili mpate kuondolewa dhambi zenu na kupokea ile zawadi ya Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maana, ahadi ile ilikuwa kwa ajili yenu, kwa ajili ya watoto wenu, kwa ajili ya wote wanaokaa mbali; na kwa ajili ya kila mtu ambaye Bwana Mungu wetu atamwita kwake.” ");
INSERT INTO swh1850_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa maneno mengine mengi, Petro alisisitiza na kuwahimiza watu akisema, “Jiokoeni katika kizazi hiki kiovu.” ");
INSERT INTO swh1850_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wengi waliyakubali maneno yake, wakabatizwa. Watu wapatao elfu tatu wakaongezeka katika kile kikundi siku hiyo. ");
INSERT INTO swh1850_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hawa wote waliendelea kujifunza kutoka kwa mitume, kuishi pamoja kidugu, kumega mkate na kusali. ");
INSERT INTO swh1850_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Miujiza na maajabu mengi yalifanyika kwa njia ya mitume hata kila mtu akajawa na hofu. ");
INSERT INTO swh1850_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Waumini wote waliendelea kuwa kitu kimoja na mali zao waligawana pamoja. ");
INSERT INTO swh1850_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Walikuwa wakiuza mali na vitu vyao kisha wakagawana fedha kadiri ya mahitaji ya kila mmoja. ");
INSERT INTO swh1850_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waliendelea kukutana pamoja kila siku Hekaluni. Lakini wakati wa kumega mkate, walikutana katika nyumba zao na wakakishiriki chakula hicho kwa furaha na moyo mkunjufu. ");
INSERT INTO swh1850_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Walimtukuza Mungu, wakapendwa na watu wote. Kila siku Bwana aliwaongezea idadi ya watu waliokuwa wakiokolewa. ");
INSERT INTO swh1850_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Siku moja, saa tisa alasiri, Petro na Yohane walikuwa wanakwenda Hekaluni, wakati wa sala. ");
INSERT INTO swh1850_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na pale karibu na mlango wa Hekalu uitwao “Mlango Mzuri”, palikuwa na mtu mmoja, kiwete tangu kuzaliwa. Watu walimbeba huyo mtu kila siku na kumweka hapo ili aombe chochote kwa wale waliokuwa wakiingia Hekaluni. ");
INSERT INTO swh1850_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Alipowaona Petro na Yohane wakiingia Hekaluni, aliwaomba wampe chochote. ");
INSERT INTO swh1850_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petro na Yohane walimkodolea macho, naye Petro akamwambia, “Tutazame!” ");
INSERT INTO swh1850_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naye akawageukia, akitazamia kupata kitu kutoka kwao. ");
INSERT INTO swh1850_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kisha Petro akamwambia, “Sina fedha wala dhahabu lakini kile nilicho nacho nitakupa. Kwa jina la Yesu Kristo wa Nazareti, tembea!” ");
INSERT INTO swh1850_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Halafu, akamshika mkono wa kulia, akamwinua. Papo hapo miguu na magoti yake yakapata nguvu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akaruka, akasimama na kuanza kutembea. Halafu akaingia pamoja nao Hekaluni, akitembea na kurukaruka huku akimtukuza Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Watu wote waliokuwa hapo walimwona akitembea na kumsifu Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Walipomtambua kuwa ndiye yule aliyekuwa anaombaomba karibu na ule “Mlango Mzuri” wa Hekalu, wakashangaa mno hata wasiweze kuelewa yaliyompata. ");
INSERT INTO swh1850_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Watu wote, wakiwa na mshangao mkubwa wakaanza kukimbilia mahali palipoitwa “Ukumbi wa Solomoni,” ambapo yule mtu alikuwa bado anaandamana na Petro na Yohane. ");
INSERT INTO swh1850_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Basi, Petro alipowaona watu hao akawaambia, “Wananchi wa Israeli, kwa nini mnashangazwa na jambo hili? Mbona mnatukodolea macho kana kwamba ni kwa nguvu zetu au utakatifu wetu sisi wenyewe tumemfanya mtu huyu aweze kutembea? ");
INSERT INTO swh1850_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mungu wa Abrahamu, Isaka na Yakobo, Mungu wa baba zetu amemtukuza Yesu mtumishi wake. Yeye ndiye yuleyule mliyemtia mikononi mwa wakuu na kumkataa mbele ya Pilato hata baada ya Pilato kuamua kumwacha huru. ");
INSERT INTO swh1850_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Alikuwa mtakatifu na mwema; lakini ninyi mlimkataa, mkataka mtu mwingine aliyekuwa muuaji afunguliwe. ");
INSERT INTO swh1850_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Basi, mlimuua yule ambaye ni chanzo cha uzima. Lakini Mungu alimfufua, na sisi ni mashahidi wa tukio hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jina la Yesu na imani katika jina hilo ndivyo vilivyompa nguvu mtu huyu mnayemwona na kumfahamu. Imani kwa Yesu ndiyo iliyomponya kabisa mtu huyu kama mnavyoona nyote. ");
INSERT INTO swh1850_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sasa ndugu zangu, nafahamu kwamba ninyi na wakuu wenu mlitenda hayo kwa sababu ya kutojua kwenu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lakini ndivyo Mungu alivyotimiza yale aliyotangaza zamani kwa njia ya manabii wote, kwamba ilikuwa lazima Kristo wake ateseke. ");
INSERT INTO swh1850_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Basi, tubuni mkamrudie Mungu ili afute dhambi zenu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Fanyeni hivyo ili Bwana awape nyakati za kuburudika rohoni na kuwaletea yule Kristo aliyemteua ambaye ndiye Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ni lazima yeye abaki huko mbinguni mpaka utakapofika wakati wa kurekebishwa vitu vyote, kama Mungu alivyosema kwa njia ya manabii wake watakatifu wa tangu zamani. ");
INSERT INTO swh1850_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwa maana Mose alisema, Bwana Mungu wenu atawapelekeeni nabii kama mimi kutoka kati yenu ninyi wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yeyote yule ambaye hatamsikiliza nabii huyo atatengwa mbali na watu wa Mungu na kuangamizwa. ");
INSERT INTO swh1850_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Manabii wote, kuanzia Samweli na wale waliomfuata, walitangaza habari za mambo haya ambayo yamekuwa yakitendeka siku hizi. ");
INSERT INTO swh1850_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ahadi zile Mungu alizotoa kwa njia ya manabii ni kwa ajili yenu; na mnashiriki lile agano Mungu alilofanya na babu zenu, kama alivyomwambia Abrahamu: Kwa njia ya wazawa wako, jamaa zote za dunia zitabarikiwa. ");
INSERT INTO swh1850_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Basi, ilikuwa kwa ajili yenu kwanza kwamba Mungu alimfufua mtumishi wake, alimtuma awabariki kwa kumfanya kila mmoja wenu aachane kabisa na maovu yake.” ");
INSERT INTO swh1850_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petro na Yohane walipokuwa bado wanawahutubia watu, makuhani na mkuu wa walinzi wa Hekalu pamoja na Masadukayo walifika. ");
INSERT INTO swh1850_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Walikasirika sana, maana hao mitume walikuwa wanawahubiria watu kwamba Yesu alifufuka, jambo ambalo linaonyesha wazi kwamba wafu watafufuka. ");
INSERT INTO swh1850_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Basi, waliwatia nguvuni na kwa kuwa usiku ulikuwa umekaribia, wakawaweka chini ya ulinzi mpaka kesho yake. ");
INSERT INTO swh1850_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini wengi kati ya wale waliosikia ujumbe wao waliamini, na idadi ya waumini ikawa imefika karibu elfu tano. ");
INSERT INTO swh1850_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kesho yake, viongozi wa Wayahudi, wazee na walimu wa Sheria, walikusanyika pamoja huko Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Walikutana pamoja na Anasi, Kayafa, Yohane, Aleksanda na wengine waliokuwa wa ukoo wa Kuhani Mkuu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Waliwasimamisha mitume mbele yao, wakawauliza, “Ninyi mmefanya jambo hili kwa nguvu gani na kwa jina la nani?” ");
INSERT INTO swh1850_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hapo, Petro, akiwa amejawa na Roho Mtakatifu, akawaambia, “Viongozi na wazee wa watu! ");
INSERT INTO swh1850_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ikiwa mnatuuliza leo juu ya kile kitendo chema alichofanyiwa yule mtu aliyekuwa kiwete na jinsi alivyopata kuwa mzima, ");
INSERT INTO swh1850_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","basi, ninyi na watu wote wa Israeli mnapaswa kujua kwamba mtu huyu anasimama mbele yenu leo, mzima kabisa, kwa nguvu ya jina lake Yesu wa Nazareti ambaye ninyi mlimsulubisha, lakini Mungu akamfufua kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Huyu ndiye ambaye Maandiko Matakatifu yanasema: Jiwe mlilokataa ninyi waashi, sasa limekuwa jiwe kuu la msingi. ");
INSERT INTO swh1850_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wokovu haupatikani kwa mtu mwingine yeyote, kwa maana duniani pote, binadamu hawakupewa jina la mtu mwingine ambaye sisi tunaweza kuokolewa naye.” ");
INSERT INTO swh1850_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hao wazee wa baraza, wakiwa wanajua kwamba Petro na Yohane walikuwa watu wasio na kisomo wala elimu yoyote, walishangaa juu ya jinsi walivyosema kwa uhodari. Wakatambua kwamba walikuwa wamejiunga na Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lakini walipomwona yule mtu aliyeponywa amesimama pamoja nao, hawakuweza kusema kitu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hivyo, waliwaamuru watoke nje ya baraza, nao wakabaki ndani wakizungumza kwa faragha. ");
INSERT INTO swh1850_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wakaulizana, “Tufanye nini na watu hawa? Kila mtu anayeishi Yerusalemu anajua kwamba mwujiza huu wa ajabu umefanyika, nasi hatuwezi kukana jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini ili tupate kuzuia jambo hili lisienee zaidi kati ya watu, tuwaonye wasiongee na mtu yeyote kwa jina la Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kwa hiyo wakawaita tena ndani, wakawaonya wasiongee tena hadharani, wala kufundisha kwa jina la Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petro na Yohane wakawajibu, “Amueni ninyi wenyewe kama ni haki mbele ya Mungu kuwatii ninyi kuliko kumtii yeye. ");
INSERT INTO swh1850_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwa maana hatuwezi kuacha kusema juu ya mambo yale tuliyoyaona na kuyasikia.” ");
INSERT INTO swh1850_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Basi, hao wazee wa Baraza wakawaonya kwa ukali zaidi, halafu wakawaacha huru. Hawakuweza kuwapa adhabu kwa sababu watu wote walikuwa wakimtukuza Mungu kwa sababu ya tukio hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Huyo mtu aliyeponywa alikuwa na umri wa miaka zaidi ya arobaini. ");
INSERT INTO swh1850_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mara tu walipoachwa huru, Petro na Yohane walirudi kwa wenzao, wakawaeleza yale waliyoambiwa na makuhani wakuu na wazee. ");
INSERT INTO swh1850_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Waliposikia habari hiyo waliungana pamoja katika kumwomba Mungu wakisema, “Bwana, wewe ni Muumba wa mbingu na nchi, bahari na vyote vilivyomo! ");
INSERT INTO swh1850_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ndiwe uliyemfanya mtumishi wako, babu yetu Daudi, aseme kwa nguvu ya Roho Mtakatifu: Kwa nini mataifa yameghadhibika? Mbona watu wamefanya mipango ya bure? ");
INSERT INTO swh1850_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wafalme wa dunia walijiweka tayari, na watawala walikutana pamoja, ili kumwasi Bwana na Kristo wake. ");
INSERT INTO swh1850_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Maana, kwa hakika, ndivyo Herode, Pontio Pilato, watu wa Israeli na watu wa mataifa walivyokutanika papa hapa mjini, kumpinga Yesu Mtumishi wako Mtakatifu ambaye umemtia mafuta. ");
INSERT INTO swh1850_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naam, walikutana ili wafanye yale ambayo ulikusudia na kupanga tangu mwanzo kwa uwezo wako na mapenzi yako. ");
INSERT INTO swh1850_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lakini sasa, ee Bwana, angalia vitisho vyao. Utuwezeshe sisi watumishi wako kuhubiri neno lako kwa uhodari. ");
INSERT INTO swh1850_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyosha mkono wako uponye watu. Fanya ishara na maajabu kwa jina la Yesu Mtumishi wako Mtakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Walipomaliza kusali, pale mahali walipokuwa wamekutanika pakatikiswa, nao wote wakajazwa Roho Mtakatifu. Wote wakaanza kuhubiri neno la Mungu bila uoga. ");
INSERT INTO swh1850_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jumuiya yote ya waumini ilikuwa moyo mmoja na roho moja. Hakuna hata mmoja aliyekuwa na kitu chochote akakiweka kuwa mali yake binafsi, ila waligawana vyote walivyokuwa navyo. ");
INSERT INTO swh1850_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mitume walishuhudia kwa nguvu nyingi kufufuka kwa Bwana Yesu, naye Mungu akawapa baraka nyingi. ");
INSERT INTO swh1850_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hakuna mtu yeyote aliyetindikiwa kitu, maana waliokuwa na mashamba au nyumba walikuwa wanaviuza ");
INSERT INTO swh1850_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kuwakabidhi mitume fedha hizo, zikagawiwa kila mmoja kadiri ya mahitaji yake. ");
INSERT INTO swh1850_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kulikuwa na Mlawi mmoja, mzaliwa wa Kupro, jina lake Yosefu, ambaye mitume walimwita jina Barnaba (maana yake, “Mtu mwenye kutia moyo”). ");
INSERT INTO swh1850_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yeye pia alikuwa na shamba lake, akaliuza; akazichukua zile fedha, akawakabidhi mitume. ");
INSERT INTO swh1850_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mtu mmoja aitwaye Anania na mkewe Safira waliuza shamba lao vilevile. ");
INSERT INTO swh1850_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lakini, mkewe akiwa anajua, Anania akajiwekea sehemu ya fedha alizopata na ile sehemu nyingine akawakabidhi mitume. ");
INSERT INTO swh1850_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Basi, Petro akamwuliza, “Anania, mbona Shetani ameuingia moyo wako na kukufanya umdanganye Roho Mtakatifu kwa kujiwekea sehemu ya fedha ulizopata kutokana na lile shamba? ");
INSERT INTO swh1850_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kabla ya kuliuza lilikuwa mali yako, na baada ya kuliuza, bado hizo fedha zilikuwa zako uzitumie utakavyo. Kwa nini basi, uliamua moyoni mwako kufanya jambo la namna hii? Hukumdanganya mtu; umemdanganya Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania aliposikia hayo, akaanguka chini, akafa. Watu wote waliosikia habari ya tukio hilo waliogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Vijana wakafika wakaufunika mwili wake, wakamtoa nje, wakamzika. ");
INSERT INTO swh1850_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Baada ya muda wa saa tatu hivi, mke wake, bila kufahamu mambo yaliyotukia, akaingia mle ndani. ");
INSERT INTO swh1850_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro akamwambia, “Niambie! Je, kiasi hiki cha fedha ndicho mlichopata kwa kuuza lile shamba?” Yeye akamjibu, “Naam, ni kiasi hicho.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Naye Petro akamwambia, “Mbona mmekula njama kumjaribu Roho wa Bwana? Sikiliza! Wale watu waliokwenda kumzika mume wako, sasa wako mlangoni na watakuchukua wewe pia.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mara Safira akaanguka mbele ya miguu ya Petro, akafa. Wale vijana walipoingia, walimkuta amekwisha kufa; hivyo wakamtoa nje, wakamzika karibu na mume wake. ");
INSERT INTO swh1850_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kanisa lote pamoja na wote waliosikia habari ya tukio hilo, waliogopa sana. ");
INSERT INTO swh1850_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mitume walifanya miujiza na maajabu mengi kati ya watu. Waumini walikuwa wakikutana pamoja katika ukumbi wa Solomoni. ");
INSERT INTO swh1850_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mtu yeyote mwingine ambaye hakuwa mwamini hakuthubutu kujiunga nao. Hata hivyo, watu wengine wasiokuwa wa imani hiyo waliwasifu. ");
INSERT INTO swh1850_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Idadi ya watu waliomwamini Bwana, wanaume kwa wanawake, iliongezeka zaidi na zaidi. ");
INSERT INTO swh1850_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwa sababu hiyo, watu walikuwa wakipeleka wagonjwa barabarani na kuwalaza juu ya vitanda na mikeka ili Petro akipita, walau kivuli chake kiwaguse baadhi yao. ");
INSERT INTO swh1850_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Watu wengi walifika kutoka katika miji ya kando kando ya Yerusalemu, wakiwaleta wagonjwa wao na wale waliokuwa na pepo wachafu, nao wote wakaponywa. ");
INSERT INTO swh1850_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kisha, Kuhani Mkuu na wenzake waliokuwa wa kikundi cha Masadukayo wa mahali hapo, wakawaonea mitume wivu. ");
INSERT INTO swh1850_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Basi, wakawatia nguvuni, wakawafunga ndani ya gereza kuu. ");
INSERT INTO swh1850_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lakini usiku malaika wa Bwana aliifungua milango ya gereza, akawatoa nje, akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nendeni mkasimame Hekaluni na kuwaambia watu kila kitu kuhusu maisha haya mapya.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mitume walitii, wakaingia Hekaluni asubuhi na mapema, wakaanza kufundisha. Kuhani Mkuu na wenzake walipofika, waliita mkutano wa Baraza kuu, yaani halmashauri yote ya wazee wa Wayahudi halafu wakawatuma watu gerezani wawalete wale mitume. ");
INSERT INTO swh1850_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini hao watumishi walipofika huko hawakuwakuta mle gerezani. Hivyo walirudi, wakatoa taarifa mkutanoni, ");
INSERT INTO swh1850_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","wakisema, “Tulikuta gereza limefungwa kila upande na walinzi wakilinda milango. Lakini tulipofungua hatukumkuta mtu yeyote ndani.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mkuu wa walinzi wa Hekalu na makuhani wakuu waliposikia habari hiyo wakawa na wasiwasi, wasijue yaliyowapata. ");
INSERT INTO swh1850_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Akafika mtu mmoja, akawaambia, “Wale watu mliowafunga gerezani, hivi sasa wamo Hekaluni, wanawafundisha watu.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hapo mkuu wa walinzi wa Hekalu pamoja na watu wake walikwenda Hekaluni, akawaleta. Lakini hawakuwakamata kwa kutumia nguvu, maana waliogopa kwamba watu wangewapiga mawe. ");
INSERT INTO swh1850_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Basi, wakawapeleka, wakawasimamisha mbele ya Baraza. Kuhani Mkuu akawaambia, ");
INSERT INTO swh1850_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tuliwakatazeni waziwazi kufundisha kwa jina la mtu huyu; sasa mmeyaeneza mafundisho yenu pote katika Yerusalemu na mnakusudia kutuwekea lawama ya kifo cha mtu huyo.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hapo Petro, akiwa pamoja na wale mitume wengine, akajibu, “Lazima tumtii Mungu, na siyo binadamu. ");
INSERT INTO swh1850_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mungu wa babu zetu alimfufua Yesu baada ya ninyi kumwua kwa kumtundika msalabani. ");
INSERT INTO swh1850_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Huyu ndiye yule aliyekwezwa na Mungu mpaka upande wake wa kulia, akawa kiongozi na Mwokozi, ili awawezeshe watu wa Israeli watubu, wapate kusamehewa dhambi zao. ");
INSERT INTO swh1850_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sisi ni mashahidi wa tukio hilo, naye Roho Mtakatifu ambaye Mungu amewapa wale wanaomtii, anashuhudia pia tukio hilo.” ");
INSERT INTO swh1850_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wajumbe wote wa lile Baraza waliposikia hayo, wakawaka hasira, hata wakaamua kuwaua. ");
INSERT INTO swh1850_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini Mfarisayo mmoja aitwaye Gamalieli ambaye alikuwa mwalimu wa Sheria na aliyeheshimika sana mbele ya watu wote, alisimama mbele ya lile Baraza, akataka wale mitume watolewe nje kwa muda mfupi. ");
INSERT INTO swh1850_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kisha akawaambia wale wajumbe wa Baraza, “Wananchi wa Israeli, tahadhari kabla ya kutekeleza hicho mnachotaka kuwatenda watu hawa! ");
INSERT INTO swh1850_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Zamani kidogo, kulitokea mtu mmoja jina lake Theuda, akajisema kuwa mtu wa maana na watu karibu mia nne wakajiunga naye. Lakini aliuawa, kisha wafuasi wake wote wakatawanyika na kikundi chake kikafa. ");
INSERT INTO swh1850_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tena, baadaye, wakati ule wa kuhesabiwa watu, alitokea Yuda wa Galilaya. Huyu naye, aliwavuta watu wakamfuata; lakini naye pia aliuawa, na wafuasi wake wakatawanyika. ");
INSERT INTO swh1850_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na sasa pia mimi nawaambieni, msiwachukulie watu hawa hatua yoyote; waacheni! Kwa maana, ikiwa mpango huu au shughuli hii yao imeanzishwa na binadamu, itatoweka yenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini kama imeanzishwa na Mungu, siyo tu kwamba hamtaweza kuwashinda, bali mtajikuta mnapigana na Mungu.” Basi, wakakubaliana naye. ");
INSERT INTO swh1850_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hivyo wakawaita wale mitume, wakaamuru wachapwe viboko na kuwaonya wasifundishe tena kwa jina la Yesu; kisha wakawaacha waende zao. ");
INSERT INTO swh1850_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Basi, mitume wakatoka nje ya ule mkutano wa halmashauri wakiwa wamejaa furaha, kwani walistahili kuaibishwa kwa ajili ya jina la Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wakaendelea kila siku kufundisha na kuhubiri Habari Njema ya Kristo, Hekaluni na nyumbani mwa watu. ");
INSERT INTO swh1850_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Baadaye, idadi ya wanafunzi ilipokuwa inazidi kuongezeka, kulitokea manung'uniko kati ya wanafunzi waliosema Kigiriki na wale waliosema Kiebrania. Wale waliosema Kigiriki walinung'unika kwamba wajane wao walikuwa wanasahauliwa katika ugawaji wa mahitaji ya kila siku. ");
INSERT INTO swh1850_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kwa hiyo, mitume kumi na wawili waliita jumuiya yote ya wanafunzi, wakasema, “Si vizuri sisi tuache kulihubiri neno la Mungu ili tushughulikie ugawaji wa mahitaji. ");
INSERT INTO swh1850_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hivyo, ndugu zetu, chagueni miongoni mwenu watu saba wenye sifa njema, waliojawa na Roho na wenye hekima; nasi tutawakabidhi jukumu hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sisi, lakini, tutashughulika na sala na kazi ya kuhubiri neno la Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jambo hilo likaipendeza jumuiya yote ya waumini. Wakawachagua Stefano, mtu mwenye imani kubwa na mwenye kujawa na Roho Mtakatifu, Filipo, Prokoro, Nikanora, Timona, Parmena na Nikolao wa Antiokia ambaye hapo awali alikuwa ameongokea dini ya Kiyahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wakawaweka mbele ya mitume, nao wakawaombea na kuwawekea mikono. ");
INSERT INTO swh1850_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Neno la Mungu likazidi kuenea na idadi ya waumini huko Yerusalemu ikaongezeka zaidi, na kundi kubwa la makuhani wakaipokea imani. ");
INSERT INTO swh1850_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mungu alimjalia Stefano neema tele, akampa nguvu nyingi hata akawa anatenda miujiza na maajabu kati ya watu. ");
INSERT INTO swh1850_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini watu fulani wakatokea ili wabishane na Stefano. Baadhi ya watu hao walikuwa wa sunagogi moja lililoitwa “Sunagogi la Watu Huru”, nao walitoka Kurene na Aleksandria; wengine walitoka Kilikia na Asia. ");
INSERT INTO swh1850_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini hawakuweza kumshinda kwa sababu ya hekima yake na kwa sababu ya yule Roho aliyeongoza maneno yake. ");
INSERT INTO swh1850_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kwa hiyo waliwahonga watu kadhaa waseme: “Tumemsikia Stefano akisema maneno ya kumkashifu Mose na kumkashifu Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa namna hiyo, waliwachochea watu, wazee na walimu wa Sheria. Basi, wakamjia Stefano, wakamkamata na kumleta mbele ya Baraza kuu. ");
INSERT INTO swh1850_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Walileta Barazani mashahidi wa uongo ambao walisema, “Mtu huyu haachi kamwe kusema maneno ya kupakashifu mahali hapa patakatifu na Sheria ya Mose. ");
INSERT INTO swh1850_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwa maana tulikwisha msikia akisema eti huyo Yesu wa Nazareti atapaharibu kabisa mahali hapa na kufutilia mbali desturi zile tulizopokea kutoka kwa Mose.” ");
INSERT INTO swh1850_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wote waliokuwa katika kile kikao cha Baraza walimkodolea macho Stefano, wakauona uso wake umekuwa kama wa malaika. ");
INSERT INTO swh1850_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Basi, Kuhani Mkuu akamwuliza, “Je, mambo haya ni kweli?” ");
INSERT INTO swh1850_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Naye Stefano akasema, “Ndugu zangu na akina baba, nisikilizeni! Mungu alimtokea baba yetu Abrahamu alipokuwa kule Mesopotamia kabla hajaenda kukaa kule Harani. ");
INSERT INTO swh1850_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mungu alimwambia: Ondoka katika nchi yako; waache watu wa ukoo wako; nenda katika nchi nitakayokuonyesha! ");
INSERT INTO swh1850_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kwa hivyo, Abrahamu alihama nchi ya Kaldayo, akaenda kukaa Harani. Baada ya kifo cha baba yake, Mungu alimtoa tena Harani akaja kukaa katika nchi hii mnayokaa sasa. ");
INSERT INTO swh1850_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mungu hakumpa hata sehemu moja ya nchi hii iwe mali yake; hata hivyo, alimwahidia kumpa nchi hii iwe yake na ya wazawa wake, ingawaje wakati huu hakuwa na mtoto. ");
INSERT INTO swh1850_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mungu alimwambia hivi: Wazao wako watapelekwa katika nchi inayotawaliwa na watu wengine, na huko watafanywa watumwa na kutendewa vibaya kwa muda wa miaka mia nne. ");
INSERT INTO swh1850_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lakini mimi nitalihukumu taifa hilo litakalowafanya watumwa. Kisha nitawatoa katika nchi hiyo ili waje kuniabudu mahali hapa. ");
INSERT INTO swh1850_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Halafu Mungu aliifanya tohara iwe ishara ya agano. Hivyo, Abrahamu alimtahiri mtoto wake Isaka, siku ya nane baada ya kuzaliwa. Na Isaka, vivyo hivyo, alimtahiri Yakobo. Naye Yakobo aliwatendea wale mababu kumi na wawili vivyo hivyo. ");
INSERT INTO swh1850_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Wale mababu walimwonea wivu Yosefu, wakamuuza utumwani Misri. Lakini Mungu alikuwa pamoja naye, ");
INSERT INTO swh1850_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akamwokoa katika taabu zake zote. Mungu alimjalia fadhili na hekima mbele ya Farao, mfalme wa Misri, hata Farao akamweka awe mkuu wa ile nchi na nyumba ya kifalme. ");
INSERT INTO swh1850_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kisha, kulizuka njaa kubwa katika nchi yote ya Misri na Kanaani, ikasababisha dhiki kubwa. Babu zetu hawakuweza kupata chakula chochote. ");
INSERT INTO swh1850_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Basi, Yakobo alipopata habari kwamba huko Misri kulikuwa na nafaka, aliwatuma watoto wake, yaani babu zetu, waende huko Misri mara ya kwanza. ");
INSERT INTO swh1850_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Katika safari yao ya pili, Yosefu alijitambulisha kwa ndugu zake, na Farao akaifahamu jamaa ya Yosefu. ");
INSERT INTO swh1850_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefu alituma ujumbe kwa baba yake na jamaa yote, jumla watu sabini na tano, waje Misri. ");
INSERT INTO swh1850_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hivyo, Yakobo alikwenda Misri ambako yeye na babu zetu wengine walikufa. ");
INSERT INTO swh1850_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Miili yao ililetwa mpaka Shekemu, ikazikwa katika kaburi Abrahamu alilonunua kutoka kwa kabila la Hamori kwa kiasi fulani cha fedha. ");
INSERT INTO swh1850_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Wakati ulipotimia Mungu aitimize ahadi aliyompa Abrahamu, idadi ya wale watu kule Misri ilikwisha ongezeka na kuwa kubwa zaidi. ");
INSERT INTO swh1850_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mwishowe, mfalme mmoja ambaye hakumtambua Yosefu alianza kutawala huko Misri. ");
INSERT INTO swh1850_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Alilifanyia taifa letu ukatili, akawatendea vibaya babu zetu kwa kuwalazimisha waweke nje watoto wao wachanga ili wafe. ");
INSERT INTO swh1850_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mose alizaliwa wakati huo. Alikuwa mtoto mzuri sana. Alilelewa nyumbani kwa muda wa miezi mitatu, ");
INSERT INTO swh1850_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na alipotolewa nje, binti wa Farao alimchukua, akamlea kama mtoto wake. ");
INSERT INTO swh1850_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose alifundishwa mambo yote ya hekima ya Wamisri akawa mashuhuri kwa maneno na matendo. ");
INSERT INTO swh1850_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Alipokuwa na umri wa miaka arobaini aliamua kwenda kuwaona ndugu zake Waisraeli. ");
INSERT INTO swh1850_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Huko alimwona mmoja wao akitendewa vibaya, akaenda kumwokoa, na kulipiza kisasi, akamuua yule Mmisri. ");
INSERT INTO swh1850_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Alidhani kwamba Waisraeli wenzake wangeelewa kwamba Mungu angemtumia yeye kuwakomboa, lakini hawakuelewa hivyo.) ");
INSERT INTO swh1850_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kesho yake, aliwaona Waisraeli wawili wakipigana, akajaribu kuwapatanisha, akisema: Ninyi ni ndugu; kwa nini basi, kutendeana vibaya ninyi kwa ninyi? ");
INSERT INTO swh1850_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yule aliyekuwa anampiga mwenzake alimsukuma Mose kando akisema: Ni nani aliyekuweka wewe kuwa kiongozi na mwamuzi wa watu? ");
INSERT INTO swh1850_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Je, unataka kuniua kama ulivyomuua yule Mmisri jana? ");
INSERT INTO swh1850_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Baada ya kusikia hayo Mose alikimbia, akaenda kukaa katika nchi ya Midiani na huko akapata watoto wawili. ");
INSERT INTO swh1850_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Miaka arobaini ilipotimia, malaika wa Bwana alimtokea Mose katika kichaka kilichokuwa kinawaka moto kule jangwani karibu na mlima Sinai. ");
INSERT INTO swh1850_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose alistaajabu sana kuona jambo hilo hata akasogea karibu ili achungulie; lakini alisikia sauti ya Bwana: ");
INSERT INTO swh1850_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Mimi ni Mungu wa baba zako, Mungu wa Abrahamu, Isaka na Yakobo! Mose akatetemeka kwa hofu na wala hakuthubutu kutazama zaidi. ");
INSERT INTO swh1850_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bwana akamwambia: Vua viatu vyako maana hapa unaposimama ni mahali patakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nimeyaona mabaya wanayotendewa watu wangu kule Misri. Nimesikia kilio chao, nami nimekuja kuwaokoa. Basi sasa, nitakutuma Misri. ");
INSERT INTO swh1850_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Huyu Mose ndiye yule watu wa Israeli waliyemkataa waliposema: Ni nani aliyekuweka wewe kuwa kiongozi na mwamuzi wetu? Kwa njia ya yule malaika aliyemtokea katika kichaka kilichokuwa kinawaka moto, Mungu alimtuma Mose huyo awe kiongozi na mkombozi. ");
INSERT INTO swh1850_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndiye aliyewaongoza wale watu watoke Misri kwa kufanya miujiza na maajabu katika nchi ya Misri, katika bahari ya Shamu na jangwani kwa muda wa miaka arobaini. ");
INSERT INTO swh1850_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose ndiye aliyewaambia watu wa Israeli: Mungu atawateulieni nabii kama mimi kutoka katika ndugu zenu ninyi wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wakati watu wa Israeli walipokutana pamoja kule jangwani, Mose ndiye aliyekuwako huko pamoja nao. Alikuwa huko pamoja na babu zetu na yule malaika aliyeongea naye mlimani Sinai; ndiye aliyekabidhiwa yale maneno yaletayo uzima atupe sisi. ");
INSERT INTO swh1850_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakini yeye ndiye babu zetu waliyemkataa kumsikiliza; walimsukuma kando, wakatamani kurudi Misri. ");
INSERT INTO swh1850_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Walimwambia Aroni: Tutengenezee miungu itakayotuongoza njiani, maana hatujui yaliyompata Mose huyu aliyetuongoza kutoka Misri! ");
INSERT INTO swh1850_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hapo ndipo walipojitengenezea sanamu ya ndama, wakaitambikia na kukifanyia sherehe kitu ambacho ni kazi ya mikono yao wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lakini Mungu aliondoka kati yao, akawaacha waabudu nyota za anga, kama ilivyoandikwa katika kitabu cha manabii: Enyi watu wa Israeli! Si mimi mliyenitolea dhabihu na sadaka kwa muda wa miaka arobaini kule jangwani! ");
INSERT INTO swh1850_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ninyi mlikibeba kibanda cha mungu Moloki, na sanamu ya nyota ya mungu wenu Refani. Sanamu mlizozifanya ndizo mlizoabudu. Kwa sababu hiyo nitakupeleka mateka mbali kupita Babuloni! ");
INSERT INTO swh1850_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kule jangwani babu zetu walikuwa na lile hema lililoshuhudia kuweko kwa Mungu. Lilitengenezwa kama Mungu alivyomwambia Mose alifanye; nakala kamili ya kile alichoonyeshwa. ");
INSERT INTO swh1850_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kisha babu zetu walilipokezana wao kwa wao mpaka wakati wa Yoshua, walipoinyakua ile nchi kutoka kwa mataifa ambayo Mungu aliyafukuza mbele yao. Hapo lilikaa mpaka nyakati za Daudi. ");
INSERT INTO swh1850_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi alipata upendeleo kwa Mungu, akamwomba Mungu ruhusa ya kumjengea makao yeye aliye Mungu wa Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Solomoni ndiye aliyemjengea Mungu nyumba. ");
INSERT INTO swh1850_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hata hivyo, Mungu Mkuu haishi katika nyumba zilizojengwa na binadamu; kama nabii asemavyo: ");
INSERT INTO swh1850_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Bwana asema: Mbingu ni kiti changu cha enzi na dunia ni kiti changu cha kuwekea miguu. ");
INSERT INTO swh1850_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ni nyumba ya namna gani basi mnayoweza kunijengea, na ni mahali gani nitakapopumzika? Vitu hivi vyote ni mimi nimevifanya, au sivyo? ");
INSERT INTO swh1850_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Enyi wakaidi wakuu! Mioyo na masikio yenu ni kama ya watu wa mataifa. Ninyi ni kama baba zenu. Siku zote mnampinga Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Je, yuko nabii yeyote ambaye baba zenu hawakumtesa? Waliwaua hao Mungu aliowatuma watangaze kuja kwake yule Mwenye Haki. Na sasa, ninyi mmemsaliti, mkamuua. ");
INSERT INTO swh1850_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ninyi mliipokea ile Sheria iliyoletwa kwenu na Malaika, lakini hamkuitii.” ");
INSERT INTO swh1850_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wale wazee wa Baraza waliposikia hayo, walighadhibika sana, wakamsagia meno kwa hasira. ");
INSERT INTO swh1850_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini Stefano akiwa amejawa na Roho Mtakatifu, akatazama juu mbinguni, akauona utukufu wa Mungu na Yesu amekaa upande wa kulia wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Akasema, “Tazameni! Ninaona mbingu zimefunuliwa na Mwana wa Mtu amesimama upande wa kulia wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hapo, watu wote katika kile kikao cha Baraza, wakapiga kelele na kuziba masikio yao kwa mikono yao. Kisha wakamrukia wote kwa pamoja, ");
INSERT INTO swh1850_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wakamtoa nje ya mji, wakampiga mawe. Wale mashahidi wakayaweka makoti yao chini ya ulinzi wa kijana mmoja jina lake Saulo. ");
INSERT INTO swh1850_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Waliendelea kumpiga mawe Stefano, huku akiwa anasali: “Bwana Yesu, ipokee roho yangu!” ");
INSERT INTO swh1850_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akapiga magoti, akalia kwa sauti kubwa: “Bwana, usiwalaumu kwa sababu ya dhambi hii.” Baada ya kusema hivyo, akafa. ");
INSERT INTO swh1850_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo naye alikiona kitendo hicho cha kumwua Stefano kuwa sawa. Siku hiyo kanisa la Yerusalemu lilianza kuteswa vibaya. Waumini wote, isipokuwa tu wale mitume, walilazimika kutawanyika katika sehemu za mashambani za Yudea na Samaria. ");
INSERT INTO swh1850_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Watu wamchao Mungu, walimzika Stefano na kumfanyia maombolezo makubwa. ");
INSERT INTO swh1850_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wakati huohuo, Saulo alijaribu kuliangamiza kanisa. Alikwenda katika kila nyumba, akawatoa nje waumini, wanaume kwa wanawake, akawatia gerezani. ");
INSERT INTO swh1850_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wale waumini waliotawanyika, walikwenda kila mahali wakihubiri ule ujumbe. ");
INSERT INTO swh1850_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Naye Filipo aliingia katika mji wa Samaria na kumhubiri Kristo kwa wenyeji wa hapo. ");
INSERT INTO swh1850_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Watu walijiunga kusikiliza kwa makini ule ujumbe wa Filipo na kuona ile miujiza aliyoifanya. ");
INSERT INTO swh1850_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Maana pepo wachafu waliokuwa wamewapagaa watu wengi waliwatoka wakipiga kelele kubwa; na pia watu wengi waliokuwa wamepooza viungo na waliolemaa waliponywa. ");
INSERT INTO swh1850_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kukawa na furaha kubwa katika mji ule. ");
INSERT INTO swh1850_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Basi, kulikuwa na mtu mmoja aitwaye Simoni ambaye alikuwa amekwisha fanya uchawi wake katika mji huo kwa muda na kuwashangaza watu wa Samaria, akijiona kuwa yeye ni mtu maarufu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Watu wote, wadogo na wakubwa, walimsikiliza kwa makini wakisema, “Simoni ndiye ile nguvu ya kimungu inayoitwa Nguvu Kubwa.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Walivutiwa sana naye kwa vile alikuwa amewashangaza kwa uchawi wake kwa muda mrefu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini walipouamini ujumbe wa Filipo juu ya Habari Njema ya Ufalme wa Mungu na jina la Yesu Kristo, walibatizwa, wanawake na wanaume. ");
INSERT INTO swh1850_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hata Simoni aliamini; baada ya kubatizwa ilikuwa akiandamana na Filipo, akastaajabia maajabu na miujiza iliyokuwa inafanyika. ");
INSERT INTO swh1850_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wale mitume waliokuwa kule Yerusalemu walipopata habari kwamba wenyeji wa Samaria nao wamelipokea neno la Mungu, waliwatuma kwao Petro na Yohane. ");
INSERT INTO swh1850_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Walipofika waliwaombea hao waumini ili wampokee Roho Mtakatifu; ");
INSERT INTO swh1850_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","maana wakati huo Roho Mtakatifu hakuwa ameshukia yeyote kati yao; walikuwa wamebatizwa tu kwa jina la Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Basi, Petro na Yohane wakawawekea mikono hao waumini, nao wakampokea Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hapo Simoni aling'amua kwamba kwa kuwekewa mikono ya mitume waumini walipewa Roho Mtakatifu. Hivyo aliwapa Petro na Yohane fedha akisema, ");
INSERT INTO swh1850_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nipeni na mimi uwezo huo ili yeyote nitakayemwekea mikono, apokee Roho Mtakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lakini Petro akamjibu, “Potelea mbali na fedha zako kwa vile unafikiri kwamba unaweza kununua karama ya Mungu kwa fedha! ");
INSERT INTO swh1850_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Huna sehemu yoyote wala haki katika kazi hiyo kwa maana moyo wako hauko sawa mbele ya macho ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwa hiyo, tubu ubaya wako huu na umwombe Bwana naye anaweza kukusamehe fikira kama hizo. ");
INSERT INTO swh1850_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ni dhahiri kwangu kwamba umejaa wivu mkali na mfungwa wa dhambi!” ");
INSERT INTO swh1850_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni akajibu, “Tafadhali, niombeeni kwa Bwana lisije likanipata lolote kati ya hayo mliyosema.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Baada ya Petro na Yohane kutoa ushuhuda wao na kuutangaza ujumbe wa Bwana, walirudi Yerusalemu. Walipokuwa wanarudi walihubiri Habari Njema katika vijiji vingi vya Samaria. ");
INSERT INTO swh1850_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaika wa Bwana alimwambia Filipo, “Jitayarishe uende kusini kupitia njia inayotoka Yerusalemu kwenda Gaza.” (Njia hiyo hupita jangwani.) ");
INSERT INTO swh1850_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Basi, Filipo akajiweka tayari, akaanza safari. Wakati huohuo kulikuwa na Mwethiopia mmoja, towashi, ambaye alikuwa anasafiri kuelekea nyumbani. Huyo mtu alikuwa ofisa maarufu wa hazina ya Kandake, malkia wa Ethiopia. Alikuwa amekwenda huko Yerusalemu kuabudu na wakati huo alikuwa anarudi akiwa amepanda gari la kukokotwa. ");
INSERT INTO swh1850_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Alipokuwa anasafiri, alikuwa akijisomea kitabu cha nabii Isaya. ");
INSERT INTO swh1850_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Basi, Roho Mtakatifu akamwambia Filipo, “Nenda karibu na gari hilo ukafuatane nalo.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo akakimbilia karibu na gari, akamsikia huyo mtu akisoma katika kitabu cha nabii Isaya. Hapo Filipo akamwuliza, “Je, unaelewa hayo unayosoma?” ");
INSERT INTO swh1850_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Huyo mtu akamjibu, “Ninawezaje kuelewa bila mtu kunielewesha?” Hapo akamwalika Filipo apande juu, aketi pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Basi, sehemu ya Maandiko Matakatifu aliyokuwa anasoma ilikuwa hii: “Alikuwa kama kondoo anayepelekwa kuchinjwa; kimya kama vile mwana kondoo anaponyolewa manyoya, yeye naye hakutoa sauti hata kidogo. ");
INSERT INTO swh1850_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Alifedheheshwa na kunyimwa haki. Hakuna atakayeweza kuongea juu ya kizazi chake, kwa maana maisha yake yameondolewa duniani.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Huyo Mwethiopia akamwambia Filipo, “Niambie, huyu nabii anasema juu ya nani? Anasema mambo haya juu yake yeye mwenyewe au juu ya mtu mwingine?” ");
INSERT INTO swh1850_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Basi, Filipo akianzia na sehemu hiyo ya Maandiko Matakatifu, akamweleza Habari Njema juu ya Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Walipokuwa bado wanaendelea na safari walifika mahali penye maji na huyo ofisa akasema, “Mahali hapa pana maji; je, kuna chochote cha kunizuia nisibatizwe?” ");
INSERT INTO swh1850_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo akasema, “Kama unaamini kwa moyo wako wote unaweza kubatizwa.” Naye akajibu, “Naam, ninaamini kwamba Yesu Kristo ni Mwana wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Basi, huyo ofisa akaamuru lile gari lisimame; na wote wawili, Filipo na huyo ofisa wakashuka majini, naye Filipo akambatiza. ");
INSERT INTO swh1850_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Walipotoka majini Roho wa Bwana akamfanya Filipo atoweke. Na huyo Mwethiopia hakumwona tena; lakini akaendelea na safari yake akiwa amejaa furaha. ");
INSERT INTO swh1850_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo akajikuta yuko Azoto, akapita katika miji yote akihubiri Habari Njema mpaka alipofika Kaisarea. ");
INSERT INTO swh1850_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wakati huo Saulo alikuwa akizidisha vitisho vikali vya kuwaua wafuasi wa Bwana. Alikwenda kwa Kuhani Mkuu, ");
INSERT INTO swh1850_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akaomba apatiwe barua za utambulisho kwa masunagogi ya Kiyahudi kule Damasko, ili akikuta huko wanaume au wanawake wanaofuata Njia ya Bwana, awakamate na kuwaleta Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lakini alipokuwa njiani karibu kufika Damasko, ghafla mwanga kutoka angani ulimwangazia pande zote. ");
INSERT INTO swh1850_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akaanguka chini na kusikia sauti ikimwambia: “Saulo, Saulo! Kwa nini unanitesa?” ");
INSERT INTO swh1850_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naye Saulo akauliza, “Ni nani wewe Bwana?” Na ile sauti ikajibu, “Mimi ni Yesu ambaye wewe unamtesa. ");
INSERT INTO swh1850_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lakini simama sasa, uingie mjini na huko utaambiwa unachopaswa kufanya.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wale watu waliokuwa wanasafiri pamoja na Saulo walisimama pale, wakiwa hawana la kusema; walisikia ile sauti lakini hawakumwona mtu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo aliinuka, na alipofumbua macho yake hakuweza kuona chochote; hivyo wale watu wakamwongoza kwa kumshika mkono mpaka mjini Damasko. ");
INSERT INTO swh1850_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saulo alikaa siku tatu bila kuona, na wakati huo hakula au kunywa chochote. ");
INSERT INTO swh1850_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Basi, huko Damasko kulikuwa na mfuasi mmoja aitwaye Anania. Bwana akamwambia katika maono, “Anania!” Anania akaitika, “Niko hapa, Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Naye Bwana akamwambia, “Jitayarishe uende kwenye barabara inayoitwa Barabara ya Moja kwa Moja, na katika nyumba ya Yuda umtake mtu mmoja kutoka Tarso aitwaye Saulo. Sasa anasali; ");
INSERT INTO swh1850_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na katika maono ameona mtu aitwaye Anania akiingia ndani na kumwekea mikono ili apate kuona tena.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lakini Anania akajibu, “Bwana, nimesikia habari za mtu huyu kutoka kwa watu wengi; nimesikia juu ya mabaya aliyowatendea watu wako huko Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na amekuja hapa akiwa na mamlaka kutoka kwa makuhani wakuu kuwatia nguvuni wote wanaoomba kwa jina lako.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Bwana akamwambia, “Nenda tu, kwa maana nimemchagua awe chombo changu, alitangaze jina langu kwa mataifa na wafalme wao na kwa watu wa Israeli. ");
INSERT INTO swh1850_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mimi mwenyewe nitamwonyesha mengi yatakayomlazimu kuteswa kwa ajili ya jina langu.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Basi, Anania akaenda, akaingia katika hiyo nyumba. Kisha akaweka mikono yake juu ya Saulo, akasema, “Ndugu Saulo, Bwana ambaye ndiye Yesu mwenyewe aliyekutokea ulipokuwa njiani kuja hapa, amenituma ili upate kuona tena na kujazwa Roho Mtakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mara vitu kama magamba vikaanguka kutoka macho ya Saulo, akaweza kuona tena. Akasimama, akabatizwa. ");
INSERT INTO swh1850_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na baada ya kula chakula, nguvu zake zikamrudia. Saulo alikaa siku chache pamoja na wafuasi huko Damasko. ");
INSERT INTO swh1850_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mara alianza kuhubiri katika masunagogi kwamba Yesu ni Mwana wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Watu wote waliomsikia walishangaa, wakasema, “Je, mtu huyu si yuleyule aliyewaua wale waliokuwa wanaomba kwa jina hili kule Yerusalemu? Tena alikuja hapa akiwa na madhumuni ya kuwatia nguvuni watu hao na kuwapeleka kwa makuhani!” ");
INSERT INTO swh1850_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo alizidi kupata nguvu, na kwa jinsi alivyothibitisha wazi kwamba Yesu ndiye Kristo, Wayahudi wa huko Damasko walivurugika kabisa. ");
INSERT INTO swh1850_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Baada ya siku nyingi kupita, Wayahudi walikusanyika na kufanya mpango wa kumwua Saulo. ");
INSERT INTO swh1850_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini Saulo alipata habari ya mpango huo. Usiku na mchana walilinda milango ya kuingia mjini ili wapate kumwua. ");
INSERT INTO swh1850_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini wakati wa usiku wanafunzi wake walimchukua, wakamteremsha chini ndani ya kapu kubwa kwa kupitia nafasi iliyokuwako ukutani. ");
INSERT INTO swh1850_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo alipofika Yerusalemu alijaribu kujiunga na wale wanafunzi. Lakini wote walimwogopa, na hawakuweza kuamini kwamba yeye amekuwa mfuasi. ");
INSERT INTO swh1850_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hapo, Barnaba alikuja akamchukua Saulo, akampeleka kwa mitume na kuwaeleza jinsi Saulo alivyomwona Bwana njiani na jinsi Bwana alivyoongea naye. Aliwaambia pia jinsi Saulo alivyokuwa amehubiri bila uoga kule Damasko. ");
INSERT INTO swh1850_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Basi, Saulo alikaa pamoja nao, akatembelea Yerusalemu yote akihubiri neno la Bwana bila hofu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pia aliongea na kubishana na Wayahudi wasemao Kigiriki, lakini wao walijaribu kumwua. ");
INSERT INTO swh1850_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wale ndugu walipogundua jambo hilo walimchukua Saulo, wakampeleka Kaisarea, wakamwacha aende zake Tarso. ");
INSERT INTO swh1850_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wakati huo kanisa likawa na amani popote katika Yudea, Galilaya, na Samaria. Lilijengwa na kukua katika kumcha Bwana, na kuongezeka likitiwa moyo na Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro alipokuwa anasafirisafiri kila mahali alifika pia kwa watu wa Mungu waliokuwa wanaishi Luda. ");
INSERT INTO swh1850_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Huko alimkuta mtu mmoja aitwaye Enea ambaye kwa muda wa miaka minane alikuwa amelala kitandani kwa sababu alikuwa amepooza. ");
INSERT INTO swh1850_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Basi, Petro akamwambia, “Enea, Yesu Kristo anakuponya. Amka utandike kitanda chako.” Enea akaamka mara. ");
INSERT INTO swh1850_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wakazi wote wa Luda na Saroni walimwona Enea, na wote wakamgeukia Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kulikuwa na mfuasi mmoja mwanamke mjini Yopa aitwaye Tabitha (kwa Kigiriki ni Dorka, maana yake, Paa). Huyo mwanamke alikuwa akitenda mema na kuwasaidia maskini daima. ");
INSERT INTO swh1850_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wakati huo ikawa kwamba aliugua, akafa. Watu wakauosha mwili wake, wakauzika katika chumba ghorofani. ");
INSERT INTO swh1850_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa si mbali sana na Luda; kwa hiyo wafuasi waliposikia kwamba Petro alikuwa Luda, wakawatuma watu wawili kwake na ujumbe: “Njoo kwetu haraka iwezekanavyo.” ");
INSERT INTO swh1850_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Basi, Petro akaenda pamoja nao. Alipofika alipelekwa ghorofani katika kile chumba. Huko wajane wengi walimzunguka Petro wakilia na kumwonyesha makoti na nguo ambazo Dorka alikuwa akitengeneza wakati alipokuwa hai. ");
INSERT INTO swh1850_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro aliwatoa nje wote, akapiga magoti, akasali. Kisha akamgeukia yule maiti, akasema, “Tabitha, amka” Naye akafumbua macho yake na alipomwona Petro, akaketi. ");
INSERT INTO swh1850_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petro akamsaidia kusimama, halafu akawaita wale watu wa Mungu na wale wajane, akamkabidhi kwao akiwa mzima. ");
INSERT INTO swh1850_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Habari ya tukio hili ilienea kila mahali huko Yopa, na watu wengi wakamwamini Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro alikaa siku kadhaa huko Yopa, akiishi kwa mtu mmoja mtengenezaji wa ngozi aitwaye Simoni. ");
INSERT INTO swh1850_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kulikuwa na mtu mmoja huko Kaisarea aitwaye Kornelio, Jemadari wa kikosi kimoja kiitwacho “Kikosi cha Italia.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Alikuwa mtu mwema; naye pamoja na jamaa yake yote walimcha Mungu; alikuwa anafanya mengi kusaidia maskini wa Kiyahudi na alikuwa anasali daima. ");
INSERT INTO swh1850_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yapata saa tisa mchana, aliona dhahiri katika maono malaika wa Mungu akiingia ndani na kumwambia, “Kornelio!” ");
INSERT INTO swh1850_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelio alimkodolea macho huyo malaika kwa hofu, akamwambia, “Kuna nini Mheshimiwa?” Huyo malaika akamwambia, “Mungu amezipokea sala na sadaka zako kwa maskini. ");
INSERT INTO swh1850_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sasa, watume watu Yopa wakamwite mtu mmoja aitwaye Simoni, kwa jina lingine Petro. ");
INSERT INTO swh1850_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yeye yumo nyumbani kwa Simoni mtengenezaji wa ngozi ambaye nyumba yake iko karibu na bahari.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Huyo malaika aliyesema hayo alipokwisha kwenda zake, Kornelio aliwaita watumishi wawili wa nyumbani na mmoja wa askari zake ambaye alikuwa mcha Mungu, ");
INSERT INTO swh1850_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","akawaeleza yote yaliyotukia, akawatuma Yopa. ");
INSERT INTO swh1850_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kesho yake, hao watu watatu wakiwa bado safarini, lakini karibu kufika Yopa, Petro alipanda juu ya paa la nyumba yapata saa sita mchana ili kusali. ");
INSERT INTO swh1850_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Aliona njaa, akatamani kupata chakula. Chakula kilipokuwa kinatayarishwa, alipatwa na usingizi mzito akaona maono. ");
INSERT INTO swh1850_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aliona mbingu zimefunguliwa na kitu kama shuka kubwa inateremshwa chini ikiwa imeshikwa pembe zake nne. ");
INSERT INTO swh1850_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ndani ya shuka hiyo kulikuwa na kila aina ya wanyama: wanyama wenye miguu minne, wanyama watambaao na ndege wa angani. ");
INSERT INTO swh1850_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Akasikia sauti ikimwambia: “Petro, amka uchinje, ule!” ");
INSERT INTO swh1850_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petro akajibu, “La, Bwana; mimi sijaonja kamwe chochote ambacho ni najisi au kichafu.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ile sauti ikasikika tena ikimwambia: “Usiviite najisi vitu ambavyo Mungu amevitakasa!” ");
INSERT INTO swh1850_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jambo hili lilifanyika mara tatu, kisha ile shuka ikarudishwa juu mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petro alipokuwa bado anashangaa juu ya maana ya hilo maono alilokuwa ameliona, wale watu waliotumwa na Kornelio, baada ya kuigundua nyumba ya Simoni, walifika mlangoni, ");
INSERT INTO swh1850_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wakaita kwa sauti: “Je, kuna mgeni humu aitwaye Simoni Petro?” ");
INSERT INTO swh1850_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petro alikuwa bado anajaribu kuelewa lile maono, na hapo Roho akamwambia, “Sikiliza! kuna watu watatu hapa, wanakutafuta. ");
INSERT INTO swh1850_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Shuka upesi na wala usisite kwenda pamoja nao kwa maana ni mimi niliyewatuma.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Basi, Petro akateremka chini, akawaambia hao watu, “Mimi ndiye mnayemtafuta. Kwa nini mmekuja?” ");
INSERT INTO swh1850_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wao wakamjibu, “Jemadari Kornelio ambaye ni mtu mwema, mcha Mungu na mwenye kuheshimika mbele ya Wayahudi wote ametutuma. Aliambiwa na malaika mtakatifu akualike nyumbani kwake ili asikilize chochote ulicho nacho cha kusema.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro akawaalika ndani, akawapa mahali pa kulala usiku ule. Kesho yake, Petro alianza safari pamoja nao, na baadhi ya ndugu wa huko Yopa walifuatana naye. ");
INSERT INTO swh1850_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Siku ya pili yake, walifika Kaisarea na huko Kornelio alikuwa anawangojea pamoja na jamaa na marafiki aliokuwa amewaalika. ");
INSERT INTO swh1850_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petro alipokuwa anaingia, Kornelio alitoka nje kumlaki, akapiga magoti mbele yake na kuinama chini kabisa. ");
INSERT INTO swh1850_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lakini Petro alimwinua, akamwambia, “Simama, kwa maana mimi ni binadamu tu.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petro aliendelea kuongea na Kornelio wakiwa wanaingia nyumbani ambamo aliwakuta watu wengi wamekusanyika. ");
INSERT INTO swh1850_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petro akawaambia, “Ninyi wenyewe mnajua kwamba Myahudi yeyote amekatazwa na Sheria yake ya dini kushirikiana na watu wa mataifa mengine. Lakini Mungu amenijulisha nisimfikirie mtu yeyote kuwa najisi au mchafu. ");
INSERT INTO swh1850_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa sababu hiyo, mliponiita nimekuja bila kusita. Basi, nawaulizeni: kwa nini mmeniita?” ");
INSERT INTO swh1850_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio akasema, “Siku tatu zilizopita saa kama hii, saa tisa alasiri, nilikuwa nikisali chumbani mwangu. Ghafla, mtu aliyekuwa amevaa mavazi yenye kun'gaa alisimama mbele yangu, ");
INSERT INTO swh1850_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","akasema: Kornelio! Sala yako na sadaka zako kwa maskini vimekubaliwa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mtume mtu Yopa akamwite mtu mmoja aitwaye Simoni, kwa jina lingine Petroi; yuko nyumbani kwa Simoni mtengenezaji wa ngozi karibu na bahari. ");
INSERT INTO swh1850_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kwa hiyo nilikutumia ujumbe bila kuchelewa, nawe umefanya vyema kuja. Sasa, sisi tuko mbele ya Mungu, kusikiliza chochote ambacho bwana amekuamuru kusema.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hapo Petro akaanza kusema: “Sasa nimetambua kwamba hakika Mungu hana ubaguzi. ");
INSERT INTO swh1850_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mtu wa taifa lolote anayemcha Mungu na kutenda haki anapokelewa naye. ");
INSERT INTO swh1850_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Huu ndio ule ujumbe Mungu alioupeleka kwa watu wa Israeli, akitangaza Habari Njema iletayo amani kwa njia ya Yesu Kristo ambaye ni Bwana wa wote. ");
INSERT INTO swh1850_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ninyi mnajua jambo lililotukia katika nchi yote ya Wayahudi kuanzia Galilaya baada ya ule ubatizo aliohubiri Yohane. ");
INSERT INTO swh1850_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mnajua Yesu wa Nazareti na jinsi Mungu alivyomteua kwa kummiminia Roho Mtakatifu na nguvu. Mungu alikuwa pamoja naye; yeye alikwenda huko na huko akitenda mema na kuwaponya wote waliokuwa wamevamiwa na Ibilisi. ");
INSERT INTO swh1850_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sisi ni mashahidi wa mambo yote aliyotenda katika nchi ya Wayahudi na katika Yerusalemu. Walimuua kwa kumtundika msalabani; ");
INSERT INTO swh1850_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","lakini Mungu alimfufua siku ya tatu, akamfanya aonekane ");
INSERT INTO swh1850_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","si kwa watu wote ila kwa wale Mungu aliokwisha wachagua wawe mashahidi wake, yaani sisi tuliokula na kunywa pamoja naye baada ya kufufuka kwake kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Alituamuru kuihubiri Habari Njema kwa watu wote na kushuhudia kwamba yeye ndiye aliyeteuliwa na Mungu awe Mwamuzi wa wazima na wafu. ");
INSERT INTO swh1850_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Manabii wote waliongea juu yake kwamba kila mtu atakayemwamini atasamehewa dhambi zake zote kwa jina lake.” ");
INSERT INTO swh1850_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wakati Petro alipokuwa bado anasema maneno hayo, Roho Mtakatifu aliwashukia wote waliokuwa wanasikiliza ujumbe huo. ");
INSERT INTO swh1850_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wale Wayahudi waumini waliokuja pamoja na Petro kutoka Yopa walishangaa kuona kuwa Mungu aliwamiminia zawadi ya Roho Mtakatifu watu wa mataifa mengine pia; ");
INSERT INTO swh1850_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","maana waliwasikia wakiongea kwa lugha mbalimbali wakimtukuza Mungu. Hapo Petro akasema, ");
INSERT INTO swh1850_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Watu hawa wamempokea Roho Mtakatifu kama sisi wenyewe tulivyompokea. Je, kuna yeyote atakayeweza kuwazuia wasibatizwe kwa maji?” ");
INSERT INTO swh1850_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Basi, akaamuru wabatizwe kwa jina la Yesu Kristo. Kisha wakamwomba akae nao kwa siku chache. ");
INSERT INTO swh1850_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mitume na ndugu kule Yudea walisikia kwamba watu wa mataifa mengine pia walikuwa wamelipokea neno la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Basi, Petro aliporudi Yerusalemu, wale Wayahudi waumini waliopendelea watu wa mataifa mengine watahiriwe, walimlaumu wakisema: ");
INSERT INTO swh1850_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Wewe umekwenda kukaa na watu wasiotahiriwa na hata umekula pamoja nao! ");
INSERT INTO swh1850_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hapo Petro akawaeleza kinaganaga juu ya yale yaliyotendeka tangu mwanzo: ");
INSERT INTO swh1850_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Siku moja nikiwa nasali mjini Yopa, niliona maono; niliona kitu kama shuka kubwa likishushwa chini kutoka mbinguni likiwa limeshikwa pembe zake nne, likawekwa kando yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nilichungulia ndani kwa makini nikaona wanyama wenye miguu minne, wanyama wa mwituni, wanyama watambaao na ndege wa angani. ");
INSERT INTO swh1850_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kisha nikasikia sauti ikiniambia: Petro amka, chinja, ule. ");
INSERT INTO swh1850_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lakini mimi nikasema: La, Bwana; maana chochote kilicho najisi au kichafu hakijapata kamwe kuingia kinywani mwangu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ile sauti ikasikika tena kutoka mbinguni: Usiviite najisi vitu ambavyo Mungu amevitakasa. ");
INSERT INTO swh1850_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jambo hilo lilifanyika mara tatu, na mwishowe vyote vilirudishwa juu mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ghafla, watu watatu waliokuwa wametumwa kwangu kutoka Kaisarea waliwasili kwenye nyumba niliyokuwa nakaa. ");
INSERT INTO swh1850_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roho aliniambia niende pamoja nao bila kusita. Hawa ndugu sita waliandamana nami pia kwenda Kaisarea na huko tuliingia nyumbani mwa Kornelio. ");
INSERT INTO swh1850_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yeye alitueleza jinsi alivyokuwa amemwona malaika amesimama nyumbani mwake na kumwambia: Mtume mtu Yopa akamwite mtu mmoja aitwaye Simoni, kwa jina lingine Petro. ");
INSERT INTO swh1850_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yeye atakuambia maneno ambayo kwayo wewe na jamaa yako yote mtaokolewa. ");
INSERT INTO swh1850_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na nilipoanza tu kuongea, Roho Mtakatifu aliwashukia kama alivyotushukia sisi pale awali. ");
INSERT INTO swh1850_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hapo nilikumbuka yale maneno Bwana aliyosema: Yohane alibatiza kwa maji, lakini ninyi mtabatizwa kwa Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Basi, kama Mungu amewapa pia watu wa mataifa mengine zawadi ileile aliyotupa sisi tulipomwamini Bwana Yesu Kristo, je, mimi ni nani hata nijaribu kumpinga Mungu?” ");
INSERT INTO swh1850_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Waliposikia hayo, waliacha ubishi, wakamtukuza Mungu wakisema, “Mungu amewapa watu wa mataifa mengine nafasi ya kutubu na kuwa na uzima!” ");
INSERT INTO swh1850_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kutokana na mateso yaliyotokea wakati Stefano alipouawa, waumini walitawanyika. Wengine walikwenda mpaka Foinike, Kupro na Antiokia wakihubiri ule ujumbe kwa Wayahudi tu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini baadhi ya waumini waliotoka Kupro na Kurene, walikwenda Antiokia wakautangaza huo ujumbe kwa watu wa mataifa mengine wakiwahubiria ile Habari Njema juu ya Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bwana aliwasaidia na idadi kubwa ya watu iliamini na kumgeukia Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Habari ya jambo hilo ikasikika kwa lile kanisa la Yerusalemu. Hivyo wakamtuma Barnaba aende Antiokia. ");
INSERT INTO swh1850_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Alipofika huko na kuona jinsi Mungu alivyowaneemesha wale watu, alifurahi na kuwahimiza wote wadumu katika uaminifu wao kwa Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba alikuwa mtu mwema na mwenye kujaa Roho Mtakatifu na imani. Kundi kubwa la watu lilivutwa kwa Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kisha, Barnaba alikwenda Tarso kumtafuta Saulo ");
INSERT INTO swh1850_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Alipompata, alimleta Antiokia. Nao wote wawili walikaa na lile kanisa kwa mwaka wote mzima wakifundisha kundi kubwa la watu. Huko Antiokia, ndiko, kwa mara ya kwanza, wafuasi waliitwa Wakristo. ");
INSERT INTO swh1850_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wakati huohuo, manabii kadhaa walikuja Antiokia kutoka Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Basi, mmoja wao aitwaye Agabo alisimama, na kwa uwezo wa Roho akabashiri kwamba kutakuwa na njaa kubwa katika nchi yote (Njaa hiyo ilitokea wakati Klaudio alipokuwa akitawala). ");
INSERT INTO swh1850_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wale wanafunzi waliamua kila mmoja kwa kadiri ya uwezo wake apeleke chochote ili kuwasaidia wale ndugu waliokuwa wanaishi Yudea. ");
INSERT INTO swh1850_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Basi, wakafanya hivyo na kupeleka mchango wao kwa wazee wa kanisa kwa mikono ya Barnaba na Saulo. ");
INSERT INTO swh1850_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Karibu wakati huohuo, mfalme Herode alianza kuwatesa baadhi ya Wakristo. ");
INSERT INTO swh1850_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Alimwua kwa upanga Yakobo ndugu yake Yohane. ");
INSERT INTO swh1850_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Alipoona kuwa kitendo hiki kiliwapendeza Wayahudi, aliendelea, akamkamata Petro. (Hiyo ilifanyika wakati wa sikukuu ya Mikate Isiyotiwa chachu.) ");
INSERT INTO swh1850_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Baada ya kutiwa nguvuni, Petro alifungwa gerezani, akawekwa chini ya ulinzi wa vikundi vinne vya askari wannewanne. Herode alikusudia kumtoa hadharani baada ya sikukuu ya Pasaka. ");
INSERT INTO swh1850_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Basi, Petro alipokuwa gerezani, kanisa lilikuwa linamwombea kwa Mungu kwa moyo. ");
INSERT INTO swh1850_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Usiku, kabla ya siku ile ambayo Herode angemtoa Petro hadharani, Petro alikuwa amelala kati ya askari wawili. Alikuwa amefungwa minyororo miwili, na walinzi walikuwa wanalinda lango la gereza. ");
INSERT INTO swh1850_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ghafla, malaika wa Bwana akasimama karibu naye na mwanga ukaangaza kile chumba cha gereza. Malaika akamgusa akisema, “Amka upesi!” Mara ile minyororo ikaanguka kutoka katika mikono yake. ");
INSERT INTO swh1850_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaika akamwambia, “Jifunge mshipi wako, vaa viatu vyako.” Akafanya hivyo. Kisha huyo malaika akamwambia, “Vaa koti lako, unifuate.” ");
INSERT INTO swh1850_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro akamfuata nje lakini hakujua kama hayo yaliyofanywa na huyo malaika yalikuwa ya kweli; alidhani alikuwa anaota ndoto. ");
INSERT INTO swh1850_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Walipita kituo cha kwanza cha ulinzi na cha pili, halafu wakafika kwenye mlango wa chuma wa kuingilia mjini. Huo mlango ukawafungukia wenyewe, nao wakatoka nje. Wakawa wanatembea katika barabara moja na mara yule malaika akamwacha Petro peke yake. ");
INSERT INTO swh1850_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hapo ndipo Petro alipotambua yaliyotukia, akasema, “Sasa najua kwa hakika kwamba Bwana amemtuma malaika wake akaniokoa kutoka katika mkono wa Herode na kutoka katika mambo yale yote watu wa Israeli waliyotazamia.” ");
INSERT INTO swh1850_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Alipotambua hivyo alikwenda moja kwa moja mpaka nyumbani kwa Maria mama yake Yohane aitwaye Marko. Humo watu wengi walikuwa wamekusanyika wakisali. ");
INSERT INTO swh1850_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petro alibisha mlango wa nje na mtumishi mmoja msichana aitwaye Roda, akaenda mlangoni kuitikia. ");
INSERT INTO swh1850_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Huyo msichana aliitambua sauti ya Petro akafurahi mno, hata badala ya kuufungua ule mlango, akakimbilia ndani na kuwaambia kwamba Petro alikuwa amesimama nje mlangoni. ");
INSERT INTO swh1850_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wakamwambia yule msichana, “Una wazimu!” Lakini yeye akasisitiza kwamba ilikuwa kweli. Nao wakamwambia, “Huyo ni malaika wake.” ");
INSERT INTO swh1850_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wakati huo Petro alikuwa anaendelea kupiga hodi. Mwishowe walifungua mlango, wakamwona, wakashangaa. ");
INSERT INTO swh1850_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petro aliwaashiria kwa mkono wakae kimya, akawaeleza jinsi Bwana alivyomtoa gerezani. Kisha akawaambia watoe taarifa ya jambo hilo kwa Yakobo na wale ndugu wengine, halafu akatoka akaenda mahali pengine. ");
INSERT INTO swh1850_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kulipokucha, ulitokea wasiwasi mkubwa kati ya wale askari kuhusu yaliyokuwa yamempata Petro. ");
INSERT INTO swh1850_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herode aliamuru ufanywe msako lakini hawakuweza kumpata. Hivyo aliamuru wale askari wahojiwe, akatoa amri wauawe. Halafu akatoka huko Yudea akaenda Kaisarea ambako alikaa. ");
INSERT INTO swh1850_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode alikasirishwa sana na watu wa Tiro na Sidoni. Lakini wao walimpelekea wajumbe. Nao wakafaulu kwanza kumpata Blasto awe upande wao. Blasto alikuwa msimamizi mkuu wa ikulu ya mfalme. Kisha, wakamwendea Herode wakamwomba kuwe na amani, kwa maana nchi yao ilitegemea nchi ya mfalme kwa chakula. ");
INSERT INTO swh1850_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Siku moja iliyochaguliwa, Herode akiwa amevaa mavazi rasmi na kuketi katika kiti cha kifalme aliwahutubia watu. ");
INSERT INTO swh1850_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wale watu walimpigia kelele za shangwe wakisema, “Hii ni sauti ya mungu, si ya mtu.” ");
INSERT INTO swh1850_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Papo hapo malaika wa Bwana akamwangusha Herode chini kwa sababu hakumpa Mungu hizo sifa. Akaliwa na wadudu, akafa. ");
INSERT INTO swh1850_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Neno la Mungu likazidi kuenea na kukua. ");
INSERT INTO swh1850_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baada ya Barnaba na Saulo kutekeleza shughuli zao, walitoka tena Yerusalemu wakamchukua Yohane aitwaye pia Marko. ");
INSERT INTO swh1850_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Katika kanisa la Antiokia kulikuwa na watu wengine waliokuwa manabii na walimu; miongoni mwao akiwa Barnaba, Simoni aitwaye pia Mweusi, Lukio wa Kurene, Manaeni ambaye alikuwa amelelewa pamoja na mfalme Herode, na Saulo. ");
INSERT INTO swh1850_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Walipokuwa wanafanya ibada yao kwa Bwana na kufunga, Roho Mtakatifu alisema: “Niteulieni Barnaba na Saulo kwa ajili ya kazi niliyowaitia.” ");
INSERT INTO swh1850_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Basi, baada ya kusali na kufunga zaidi, wakawawekea mikono, wakawaacha waende zao. ");
INSERT INTO swh1850_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Basi, Barnaba na Saulo walipokwisha tumwa na Roho Mtakatifu, walishuka hadi Seleukia, na kutoka huko walipanda meli hadi kisiwa cha Kupro. ");
INSERT INTO swh1850_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Walipofika Salami walihubiri neno la Mungu katika masunagogi ya Kiyahudi. Yohane (Marko) alikuwa msaidizi wao. ");
INSERT INTO swh1850_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Walitembea toka upande mmoja wa kisiwa mpaka Pafo upande wa pili, na huko walimkuta mchawi mmoja Myahudi aitwaye Baryesu ambaye alijisingizia kuwa nabii. ");
INSERT INTO swh1850_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Huyu alikuwa pamoja na Sergio Paulo, mkuu wa kile kisiwa, ambaye alikuwa mtu mwelewa sana. Sergio Paulo aliwaita Barnaba na Saulo ili asikie neno la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini huyo mchawi Elima (kama alivyokuwa anaitwa kwa Kigiriki), alijaribu kuwapinga ili kumzuia huyo mkuu wa kisiwa asije akaigeukia imani ya Kikristo. ");
INSERT INTO swh1850_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Basi, Saulo ambaye aliitwa pia Paulo, akiwa amejaa Roho Mtakatifu, alimkodolea macho huyo mchawi, ");
INSERT INTO swh1850_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","akasema, “Mdanganyifu wa kupindukia na mlaghai wewe! Wewe ni mtoto wa Ibilisi! Wewe ni adui wa chochote kile kilicho cha kweli; hukomi hata mara moja kujaribu kuzipotosha njia za Bwana zilizonyoka. ");
INSERT INTO swh1850_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sasa, mkono wa Bwana utakuadhibu: utakuwa kipofu na hutaweza kuuona mwanga wa jua kwa kitambo.” Mara kila kitu kikawa kama ukungu na giza kwake, akaanza kwenda huku na huku akitafuta mtu wa kumshika mkono amwongoze. ");
INSERT INTO swh1850_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yule mkuu wa kisiwa alipoona hayo, aliongoka akawa muumini; akastaajabia sana mafundisho aliyosikia juu ya Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kutoka Pafo, Paulo na wenzake walipanda meli wakaenda hadi Perga katika Pamfulia; lakini Yohane (Marko) aliwaacha, akarudi Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lakini wao waliendelea na safari toka Pisga hadi mjini Antiokia Pisidia. Siku ya Sabato waliingia ndani ya Sunagogi, wakakaa. ");
INSERT INTO swh1850_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Baada ya masomo katika kitabu cha Sheria ya Mose na katika maandiko ya manabii, wakuu wa lile sunagogi waliwapelekea ujumbe huu: “Ndugu, kama mnalo jambo la kuwaambia watu ili kuwapa moyo, semeni.” ");
INSERT INTO swh1850_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Basi, Paulo alisimama, akatoa ishara kwa mkono, akaanza kuongea: “Wananchi wa Israeli na wengine wote mnaomcha Mungu, sikilizeni! ");
INSERT INTO swh1850_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mungu wa taifa hili la Israeli aliwateua babu zetu na kuwafanya wawe taifa kubwa walipokuwa ugenini kule Misri. Mungu aliwatoa huko kwa uwezo wake mkuu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aliwavumilia kwa muda wa miaka arobaini kule jangwani. ");
INSERT INTO swh1850_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aliyaangamiza mataifa ya nchi ya Kanaani akawapa hao watu wake ile nchi kuwa mali yao. ");
INSERT INTO swh1850_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Miaka mia nne na hamsini ilipita, halafu akawapatia waamuzi wawaongoze mpaka wakati wa nabii Samweli. ");
INSERT INTO swh1850_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hapo wakapendelea kuwa na mfalme, na Mungu akawapa Saulo, mtoto wa Kishi wa kabila la Benyamini, awe mfalme wao kwa muda wa miaka arobaini. ");
INSERT INTO swh1850_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Baada ya kumwondoa Saulo, Mungu alimteua Daudi kuwa mfalme wao. Mungu alionyesha kibali chake kwake akisema: Nimemwona Daudi mtoto wa Yese; ni mtu anayepatana na moyo wangu; mtu ambaye atatimiza yale yote ninayotaka kuyatenda. ");
INSERT INTO swh1850_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kutokana na ukoo wake mtu huyu, Mungu, kama alivyoahidi, amewapelekea watu wa Israeli Mwokozi, ndiye Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kabla ya kuja kwake Yesu, Yohane alimtangulia akiwahubiria watu wote wa Israeli kwamba ni lazima watubu na kubatizwa. ");
INSERT INTO swh1850_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohane alipokuwa anamaliza ujumbe wake aliwaambia watu: Mnadhani mimi ni nani? Mimi si yule mnayemtazamia. Huyo anakuja baada yangu na mimi sistahili hata kuzifungua kamba za viatu vyake. ");
INSERT INTO swh1850_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ndugu, ninyi mlio watoto wa ukoo wa Abrahamu, na wengine wote mnaomcha Mungu! Ujumbe huu wa wokovu umeletwa kwetu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwa maana wenyeji wa Yerusalemu na wakuu wao hawakumtambua yeye kuwa Mwokozi. Wala hawakuelewa maneno ya manabii yanayosomwa kila Sabato. Hata hivyo, waliyafanya maneno ya manabii yatimie kwa kumhukumu Yesu adhabu ya kifo. ");
INSERT INTO swh1850_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ingawa hawakumpata na hatia inayostahili auawe, walimwomba Pilato amhukumu auawe. ");
INSERT INTO swh1850_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na baada ya kutekeleza yote yaliyokuwa yameandikwa kumhusu yeye, walimshusha kutoka msalabani, wakamweka kaburini. ");
INSERT INTO swh1850_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Mungu alimfufua kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naye, kwa siku nyingi aliwatokea wale waliofuatana naye kutoka Galilaya mpaka Yerusalemu. Hao ndio walio sasa mashahidi wake kwa watu wa Israeli. ");
INSERT INTO swh1850_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Sisi tumekuja hapa kuwaleteeni Habari Njema: jambo lile Mungu alilowaahidia babu zetu amelitimiza sasa kwa ajili yetu sisi tulio wajukuu wao kwa kumfufua Yesu kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kama ilivyoandikwa katika zaburi ya pili: Wewe ni Mwanangu, mimi leo nimekuwa baba yako. ");
INSERT INTO swh1850_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na juu ya kumfufua kutoka wafu, asipate tena kurudi huko na kuoza, Mungu alisema hivi: Nitakupa baraka takatifu na za kweli nilizomwahidia Daudi. ");
INSERT INTO swh1850_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Naam, na katika sehemu nyingine za zaburi asema: Hutamwacha Mtakatifu wako aoze. ");
INSERT INTO swh1850_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Sasa, Daudi mwenyewe alitimiza mapenzi ya Mungu wakati wake; kisha akafa na kuzikwa karibu na wazee wake, na mwili wake ukaoza. ");
INSERT INTO swh1850_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini yule ambaye Mungu alimfufua kutoka wafu hakupata kuoza. ");
INSERT INTO swh1850_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jueni wazi, ndugu zangu, kwamba ujumbe kuhusu kusamehewa dhambi unahubiriwa kwenu kwa njia ya Yesu Kristo; ");
INSERT INTO swh1850_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na ya kwamba kila mmoja anayemwamini Yesu anasamehewa dhambi zote, jambo ambalo halingewezekana kwa njia ya Sheria ya Mose. ");
INSERT INTO swh1850_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jihadharini basi, msije mkapatwa na yale yaliyosemwa na manabii: ");
INSERT INTO swh1850_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Sikilizeni enyi wenye madharau, shangaeni mpotee! Kwa maana kitu ninachofanya sasa, nyakati zenu, ni kitu ambacho hamtakiamini hata kama mtu akiwaelezeni.” ");
INSERT INTO swh1850_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Barnaba walipokuwa wanatoka katika ile sunagogi, wale watu waliwaalika waje tena siku ya Sabato iliyofuata, waongee zaidi juu ya mambo hayo. ");
INSERT INTO swh1850_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mkutano huo ulipomalizika, Wayahudi wengi na watu wa mataifa mengine waliokuwa wameongokea dini ya Kiyahudi waliwafuata Paulo na Barnaba. Hao mitume waliongea nao, wakawatia moyo waendelee kuishi wakitegemea neema ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Siku ya Sabato iliyofuata, karibu kila mtu katika ule mji alikuja kusikiliza neno la Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lakini Wayahudi walipoliona hilo kundi la watu walijaa wivu, wakapinga alichokuwa anasema Paulo na kumtukana. ");
INSERT INTO swh1850_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hata hivyo, Paulo na Barnaba waliongea kwa uhodari zaidi, wakasema, “Ilikuwa ni lazima neno la Mungu liwafikieni ninyi kwanza; lakini kwa kuwa mmelikataa na kujiona hamstahili uzima wa milele, basi, tunawaacheni na kuwaendea watu wa mataifa mengine. ");
INSERT INTO swh1850_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Maana Bwana alituagiza hivi: Nimekuteua wewe uwe mwanga kwa mataifa, uwe njia ya wokovu kwa ulimwengu wote.” ");
INSERT INTO swh1850_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Watu wa mataifa mengine waliposikia jambo hilo walifurahi, wakausifu ujumbe wa Mungu; na wale waliokuwa wamechaguliwa kupata uzima wa milele, wakawa waumini. ");
INSERT INTO swh1850_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Neno la Bwana likaenea kila mahali katika sehemu ile. ");
INSERT INTO swh1850_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lakini Wayahudi waliwachochea wanawake wa tabaka ya juu wa mataifa mengine ambao walikuwa wacha Mungu, na wanaume maarufu wa mji huo. Wakaanza kuwatesa Paulo na Barnaba, wakawafukuza kutoka katika eneo lao. ");
INSERT INTO swh1850_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Basi, mitume wakayakung'uta mavumbi yaliyokuwa katika miguu yao kama onyo, kisha wakaenda Ikonio. ");
INSERT INTO swh1850_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lakini hao wafuasi walikuwa wamejaa furaha na Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kule Ikonio, mambo yalikuwa kama yalivyokuwa kule Antiokia; Paulo na Barnaba walikwenda katika sunagogi la Wayahudi wakaongea kwa uhodari hata Wayahudi wengi na Wagiriki wakawa waumini. ");
INSERT INTO swh1850_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Wayahudi wengine waliokataa kuwa waumini walichochea na kutia chuki katika mioyo ya watu wa mataifa mengine ili wawapinge hao ndugu. ");
INSERT INTO swh1850_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo na Barnaba waliendelea kukaa huko kwa muda mrefu. Waliongea kwa uhodari juu ya Bwana, naye Bwana akathibitisha ukweli wa ujumbe walioutoa juu ya neema yake, kwa kuwawezesha kutenda miujiza na maajabu. ");
INSERT INTO swh1850_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Watu wa mji huo waligawanyika: wengine waliwaunga mkono Wayahudi, na wengine walikuwa upande wa mitume. ");
INSERT INTO swh1850_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mwishowe, baadhi ya watu wa mataifa mengine na Wayahudi, wakishirikiana na wakuu wao, waliazimu kuwatendea vibaya hao mitume na kuwapiga mawe. ");
INSERT INTO swh1850_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mitume walipogundua jambo hilo, walikimbilia Lustra na Derbe, miji ya Lukaonia, na katika sehemu za jirani, ");
INSERT INTO swh1850_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","wakawa wanahubiri Habari Njema huko. ");
INSERT INTO swh1850_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kulikuwa na mtu mmoja huko Lustra ambaye alikuwa amelemaa miguu tangu kuzaliwa, na alikuwa hajapata kutembea kamwe. ");
INSERT INTO swh1850_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mtu huyo alikuwa anamsikiliza Paulo alipokuwa anahubiri. Paulo alimtazama kwa makini, na alipoona kuwa alikuwa na imani ya kuweza kuponywa, ");
INSERT INTO swh1850_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","akasema kwa sauti kubwa, “Simama wima kwa miguu yako!” Huyo mtu aliyelemaa akainuka ghafla, akaanza kutembea. ");
INSERT INTO swh1850_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Umati wa watu walipoona alichofanya Paulo, ulianza kupiga kelele kwa lugha ya Kilukaonia: “Miungu imetujia katika sura za binadamu!” ");
INSERT INTO swh1850_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnaba akaitwa Zeu, na Paulo, kwa vile yeye ndiye aliyekuwa anaongea, akaitwa Herme. ");
INSERT INTO swh1850_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Naye kuhani wa hekalu la Zeu lililokuwa nje ya mji akaleta fahali na shada za maua mbele ya mlango mkuu wa mji, na pamoja na ule umati wa watu akataka kuwatambikia mitume. ");
INSERT INTO swh1850_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barnaba na Paulo walipopata habari hiyo waliyararua mavazi yao na kukimbilia katika lile kundi la watu wakisema kwa sauti kubwa: ");
INSERT INTO swh1850_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ndugu, kwa nini mnafanya mambo hayo? Sisi pia ni binadamu kama ninyi. Na, tuko hapa kuwahubirieni Habari Njema, mpate kuziacha hizi sanamu tupu, mkamgeukie Mungu aliye hai, Mungu aliyeumba mbingu na nchi, bahari na vyote vilivyomo. ");
INSERT INTO swh1850_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Zamani Mungu aliruhusu kila taifa lifanye lilivyopenda. ");
INSERT INTO swh1850_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata hivyo, Mungu hakuacha kujidhihirisha kwa mambo mema anayowatendea: huwanyeshea mvua toka angani, huwapa mavuno kwa wakati wake, huwapa chakula na kuijaza mioyo yenu furaha.” ");
INSERT INTO swh1850_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ingawa walisema hivyo haikuwa rahisi kuwazuia wale watu wasiwatambikie. ");
INSERT INTO swh1850_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lakini Wayahudi kadhaa walikuja kutoka Antiokia na Ikonio, wakawafanya watu wajiunge nao, wakampiga mawe Paulo na kumburuta hadi nje ya mji wakidhani amekwisha kufa. ");
INSERT INTO swh1850_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lakini waumini walipokusanyika na kumzunguka, aliamka akarudi mjini. Kesho yake, yeye pamoja na Barnaba walikwenda Derbe. ");
INSERT INTO swh1850_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baada ya Paulo na Barnabas kuhubiri Habari Njema huko Derbe na kupata wafuasi wengi, walifunga safari kwenda Antiokia kwa kupitia Lustra na Ikonio. ");
INSERT INTO swh1850_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Waliwaimarisha waumini wa miji hiyo na kuwatia moyo wabaki imara katika imani. Wakawaambia, “Ni lazima sisi sote tupitie katika taabu nyingi ili tuingie katika ufalme wa Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Waliteua wazee katika kila kanisa kwa ajili ya waumini, na baada ya kusali na kufunga, wakawaweka chini ya ulinzi wa Bwana ambaye walikuwa wanamwamini. ");
INSERT INTO swh1850_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Baada ya kupitia katika nchi ya Pisidia, walifika Pamfulia. ");
INSERT INTO swh1850_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Baada ya kuhubiri ule ujumbe huko Perga, walikwenda Atalia. ");
INSERT INTO swh1850_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kutoka huko walisafiri kwa meli wakarudi Antiokia ambako hapo awali walikuwa wamewekwa chini ya ulinzi wa neema ya Mungu kwa ajili ya kazi ambayo sasa walikuwa wameitimiza. ");
INSERT INTO swh1850_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Walipofika huko Antiokia walifanya mkutano wa kanisa la mahali hapo, wakawapa taarifa juu ya mambo Mungu aliyofanya pamoja nao, na jinsi alivyowafungulia mlango watu wa mataifa mengine mlango wa kuingia katika imani. ");
INSERT INTO swh1850_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wakakaa pamoja na wale waumini kwa muda mrefu. ");
INSERT INTO swh1850_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Basi, watu wengine walifika Antiokia kutoka Yudea wakaanza kuwafundisha wale ndugu wakisema, “Kama hamtatahiriwa kufuatana na mapokeo ya Sheria ya Mose, hamtaweza kuokolewa.” ");
INSERT INTO swh1850_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jambo hili lilisababisha ubishi mkubwa, na baada ya Paulo na Barnaba kujadiliana nao, ikaamuliwa Paulo na Barnaba pamoja na waumini kadhaa wa lile kanisa la Antiokia waende Yerusalemu kuwaona wale mitume na wazee kuhusu jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Basi, kanisa liliwaaga, nao walipokuwa wanapitia Foinike na Samaria waliwaeleza watu jinsi mataifa mengine yalivyomgeukia Mungu. Habari hizo zikawafurahisha sana ndugu hao wote. ");
INSERT INTO swh1850_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Walipofika Yerusalemu walikaribishwa na kanisa, mitume na wazee; nao wakawapa taarifa juu ya yote Mungu aliyoyafanya pamoja nao. ");
INSERT INTO swh1850_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini waumini wengine waliokuwa wa kikundi cha Mafarisayo walisimama, wakasema, “Ni lazima watu wa mataifa mengine watahiriwe na kufundishwa kuifuata Sheria ya Mose.” ");
INSERT INTO swh1850_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Basi, mitume na wazee walifanya mkutano maalum wa kuchunguza jambo hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Baada ya majadiliano marefu, Petro alisimama, akasema, “Ndugu zangu, ninyi mnafahamu kwamba hapo awali Mungu alipenda kunichagua mimi miongoni mwenu niihubiri Habari Njema, ili watu wa mataifa wapate kusikia na kuamini. ");
INSERT INTO swh1850_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naye Mungu anayejua mioyo ya watu, alithibitisha kwamba amewakubali kwa kuwapa nao Roho Mtakatifu kama alivyotupa sisi. ");
INSERT INTO swh1850_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hakufanya ubaguzi wowote kati yetu na wao; aliitakasa mioyo yao kwa imani. ");
INSERT INTO swh1850_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sasa basi, kwa nini kumjaribu Mungu kwa kuwatwika hao waumini mzigo ambao wala babu zetu, wala sisi hatukuweza kuubeba? ");
INSERT INTO swh1850_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Isiwe hivyo, ila tunaamini kwamba, sisi kama vile wao, tunaokolewa kwa njia ya neema ya Bwana Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kikundi chote kilikaa kimya, kikawasikiliza Barnaba na Paulo wakieleza miujiza na maajabu ambayo Mungu alitenda kwa mikono yao kati ya watu wa mataifa mengine. ");
INSERT INTO swh1850_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Walipomaliza kuongea, Yakobo alianza kusema: “Ndugu zangu, nisikilizeni! ");
INSERT INTO swh1850_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ameeleza jinsi Mungu hapo awali alivyojishughulisha na watu wa mataifa mengine, akachagua baadhi yao wawe watu wake. ");
INSERT INTO swh1850_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jambo hili ni sawa kabisa na maneno ya manabii, kama Maandiko Matakatifu yasemavyo: ");
INSERT INTO swh1850_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Baada ya mambo haya nitarudi. Nitaijenga tena ile nyumba ya Daudi iliyoanguka; nitayatengeneza magofu yake na kuijenga tena. ");
INSERT INTO swh1850_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hapo watu wengine wote, watu wa mataifa yote niliowaita wawe wangu, watamtafuta Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ndivyo asemavyo Bwana, aliyefanya jambo hili lijulikane tangu kale. ");
INSERT INTO swh1850_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kwa hiyo, uamuzi wangu ni huu: tusiwataabishe watu wa mataifa wanomgeukia Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bali tuwapelekee barua kuwaambia wasile vyakula vilivyotiwa najisi kwa kutambikiwa sanamu za miungu; wajiepushe na uasherati; wasile mnyama yeyote aliyenyongwa, na wasinywe damu. ");
INSERT INTO swh1850_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwa maana kwa muda mrefu maneno ya Mose yamekuwa yakihubiriwa katika kila mji na kusomwa katika masunagogi yote kila siku ya Sabato.” ");
INSERT INTO swh1850_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mitume, wazee na kanisa lote waliamua kuwachagua watu fulani miongoni mwao na kuwatuma Antiokia pamoja na Paulo na Barnaba. Basi, wakamchagua Yuda aitwaye pia Barsaba, na Sila ambao wote walikuwa wanajulikana zaidi kati ya ndugu. ");
INSERT INTO swh1850_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wakawapa barua hii: “Sisi mitume na wazee, ndugu zenu, tunawasalimuni ninyi ndugu wa mataifa mengine mlioko huko Antiokia, Siria na Kilikia. ");
INSERT INTO swh1850_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tumesikia kwamba watu wengine kutoka huku kwetu waliwavurugeni kwa maneno yao, wakaitia mioyo yenu katika wasiwasi. Lakini wamefanya hivyo bila ya idhini yoyote kutoka kwetu. ");
INSERT INTO swh1850_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hivyo, tumeamua kwa pamoja kuwachagua watu kadhaa na kuwatuma kwenu pamoja na wapenzi wetu Barnaba na Paulo, ");
INSERT INTO swh1850_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ambao wamehatarisha maisha yao kwa ajili ya jina la Bwana wetu Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa hiyo, tunawatuma Yuda na Sila kwenu; hawa watawaambieni wao wenyewe haya tuliyoandika. ");
INSERT INTO swh1850_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Basi, Roho Mtakatifu na sisi tumekubali tusiwatwike mzigo zaidi ya mambo haya muhimu: ");
INSERT INTO swh1850_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Msile vyakula vilivyotambikiwa sanamu; msinywe damu; msile nyama ya mnyama aliyenyongwa; na mjiepushe na uasherati. Mtakuwa mmefanya vema kama mkiepa kufanya mambo hayo. Wasalaam!” ");
INSERT INTO swh1850_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Baada ya kuwaaga, hao wajumbe walielekea Antiokia ambako waliita mkutano wa waumini, wakawapa hiyo barua. ");
INSERT INTO swh1850_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Walipoisoma hiyo barua, maneno yake yaliwatia moyo, wakafurahi sana. ");
INSERT INTO swh1850_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, ambao nao walikuwa manabii, walizungumza na hao ndugu kwa muda mrefu wakiwatia moyo na kuwaimarisha. ");
INSERT INTO swh1850_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baada ya kukaa huko kwa muda fulani, ndugu wa Antiokia waliwaaga wakiwatakia amani, kisha wakarudi kwa wale waliokuwa wamewatuma. ");
INSERT INTO swh1850_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lakini Sila aliamua kubaki. ");
INSERT INTO swh1850_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Barnaba walibaki huko Antiokia kwa muda; wakafundisha na kuhubiri neno la Bwana, pamoja na watu wengine wengi. ");
INSERT INTO swh1850_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Baada ya siku kadhaa, Paulo alimwambia Barnaba, “Turudi tukawatembelee wale ndugu katika kila mji tulikolihubiri neno la Bwana tukajionee jinsi wanavyoendelea.” ");
INSERT INTO swh1850_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba alitaka wamchukue pia Yohane aitwaye Marko. ");
INSERT INTO swh1850_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lakini Paulo hakupendelea kumchukua Marko, ambaye awali aliwaacha kule Pamfulia na kukataa kushiriki katika kazi yao. ");
INSERT INTO swh1850_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Basi kukatokea ubishi mkali kati yao, na wakaachana. Barnaba akamchukua Marko, wakapanda meli kwenda Kupro. ");
INSERT INTO swh1850_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Naye Paulo akamchagua Sila, na baada ya ndugu wa mahali hapo kumweka chini ya ulinzi wa neema ya Bwana, akaondoka. ");
INSERT INTO swh1850_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Katika safari hiyo alipitia Siria na Kilikia akiyaimarisha makanisa. ");
INSERT INTO swh1850_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo alifika Derbe na Lustra, ambako aliishi mfuasi mmoja aitwaye Timotheo. Mama yake ambaye pia alikuwa mfuasi, alikuwa Myahudi; lakini baba yake alikuwa Mgiriki. ");
INSERT INTO swh1850_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotheo alikuwa na sifa kubwa kati ya wale ndugu wa Lustra na Ikonio. ");
INSERT INTO swh1850_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo alitaka Timotheo aandamane naye safarini, kwa hiyo alimtahiri. Alifanya hivyo kwa sababu Wayahudi wote walioishi sehemu hizo walijua kwamba baba yake Timotheo alikuwa Mgiriki. ");
INSERT INTO swh1850_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Walipokuwa wanapita katika ile miji waliwapa watu yale maagizo yaliyotolewa na mitume na wazee kule Yerusalemu, wakawaambia wayazingatie. ");
INSERT INTO swh1850_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hivyo, yale makanisa yalizidi kuwa imara katika imani, na idadi ya waumini ikaongezeka kila siku. ");
INSERT INTO swh1850_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Walipitia sehemu za Frugia na Galatia kwani Roho Mtakatifu hakuwaruhusu kuhubiri huo ujumbe mkoani Asia. ");
INSERT INTO swh1850_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Walipofika kwenye mipaka ya Musia, walijaribu kuingia mkoani Bithunia, lakini Roho wa Yesu hakuwaruhusu. ");
INSERT INTO swh1850_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Basi, walipitia Musia, wakaenda moja kwa moja mpaka Troa. ");
INSERT INTO swh1850_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Usiku huo, Paulo aliona ono ambalo alimwona mtu mmoja wa Makedonia amesimama pale na kumwomba: “Vuka, uje Makedonia ukatusaidie.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mara baada ya Paulo kuona ono hilo, tulijitayarisha kwenda Makedonia bila kukawia, tukiwa na hakika kwamba Mungu ametuita tuwapelekee Habari Njema. ");
INSERT INTO swh1850_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kutoka Troa, tulisafiri kwa meli moja kwa moja mpaka Samothrake, na kesho yake tukatia nanga Neapoli. ");
INSERT INTO swh1850_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kutoka huko, tulikwenda mpaka Filipi, mji wa wilaya ya kwanza ya Makedonia, na ambao pia ni koloni la Waroma. Tulikaa katika mji huo siku kadhaa. ");
INSERT INTO swh1850_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Siku ya Sabato tulitoka nje ya mji, tukaenda kando ya mto ambapo tulidhani ya kuwa ni mahali pa kusali. Tuliketi, tukaongea na wanawake waliokusanyika mahali hapo. ");
INSERT INTO swh1850_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Miongoni mwa wale waliotusikiliza alikuwa mwanamke mmoja mcha Mungu aitwaye Ludia mwenyeji wa Thuatira, ambaye alikuwa mfanyabiashara ya nguo za kitani za rangi ya zambarau. Bwana aliufungua moyo wake hata akayapokea yale maneno Paulo aliyokuwa anasema. ");
INSERT INTO swh1850_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Baada ya huyo mama pamoja na jamaa yake kubatizwa, alitualika akisema, “Kama kweli mmeona kwamba mimi namwamini Bwana, karibuni nyumbani kwangu mkakae.” Akatuhimiza twende. ");
INSERT INTO swh1850_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Siku moja, tulipokuwa tunakwenda mahali pa kusali, msichana mmoja aliyekuwa na pepo mwenye uwezo wa kuagua alikutana nasi. Msichana huyo alikuwa anawapatia matajiri wake fedha nyingi kwa uaguzi wake. ");
INSERT INTO swh1850_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Basi, huyo msichana alimfuata Paulo na sisi, akipiga kelele na kusema, “Hawa watu ni watumishi wa Mungu Mkuu. Wanawatangazieni njia ya wokovu.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akawa anafanya hivyo kwa siku nyingi hata siku moja Paulo alikasirika, akamgeukia na kumwambia huyo pepo, “Nakuamuru kwa jina la Yesu Kristo, mtoke huyu!” Mara huyo pepo akamtoka. ");
INSERT INTO swh1850_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Matajiri wa yule msichana walipoona kwamba tumaini lao la kupata mali limekwisha, waliwakamata Paulo na Sila, wakawaburuta mpaka hadharani, mbele ya wakuu. ");
INSERT INTO swh1850_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wakawashtaki kwa mahakimu wakisema, “Watu hawa ni Wayahudi na wanafanya fujo katika mji wetu. ");
INSERT INTO swh1850_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wanafundisha desturi ambazo sisi raia wa Roma haturuhusiwi kuzikubali wala kuzifuata.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kundi la watu likajiunga nao, likawashambulia. Wale mahakimu wakawatatulia Paulo na Sila mavazi yao, wakaamuru wapigwe viboko. ");
INSERT INTO swh1850_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Baada ya kupigwa sana wakatiwa ndani, na askari wa gereza akaamriwa kuwaweka chini ya ulinzi mkali. ");
INSERT INTO swh1850_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kutokana na maagizo hayo, huyo askari aliwaweka katika chumba cha ndani kabisa cha gereza na kuifunga miguu yao kwenye nguzo. ");
INSERT INTO swh1850_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Karibu na usiku wa manane Paulo na Sila walikuwa wakisali na kuimba nyimbo za kumsifu Mungu, huku wafungwa wengine wakiwa wanasikiliza. ");
INSERT INTO swh1850_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ghafla, kulitokea mtetemeko mkuu wa ardhi ambao uliitikisa misingi ya gereza. Mara, milango yote ikafunguka na minyororo iliyowafunga hao wafungwa ikaachana. ");
INSERT INTO swh1850_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Askari wa gereza alipoamka na kuiona milango ya gereza imefunguliwa, alidhani kwamba wafungwa wote walikuwa wametoroka na hivyo akauchomoa upanga wake, akataka kujiua. ");
INSERT INTO swh1850_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini Paulo akaita kwa sauti kubwa: “Usijidhuru mwenyewe kwa maana sisi sote tuko hapa.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Baada ya kumwita mtu alete taa, huyo askari wa gereza alikimbilia ndani, akajitupa mbele ya miguu ya Paulo na Sila huku akitetemeka kwa hofu. ");
INSERT INTO swh1850_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Halafu aliwaongoza nje, akawauliza, “Waheshimiwa, nifanye nini nipate kuokoka?” ");
INSERT INTO swh1850_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wao wakamjibu, “Mwamini Bwana Yesu nawe utaokolewa pamoja na jamaa yako yote.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Basi, wakamhubiria neno la Bwana yeye pamoja na jamaa yake. ");
INSERT INTO swh1850_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yule askari aliwachukua saa ileile ya usiku akawasafisha majeraha yao, kisha yeye na jamaa yake wakabatizwa papo hapo. ");
INSERT INTO swh1850_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Halafu akawachukua Paulo na Sila nyumbani kwake, akawapa chakula. Yeye na jamaa yake yote wakafanya sherehe kwa vile sasa walikuwa wanamwamini Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kesho yake asubuhi, mahakimu waliwatuma maofisa wao wakisema, “Wafungueni wale watu.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yule askari wa gereza alimpasha habari Paulo: “Mahakimu wametuma ujumbe ili mfunguliwe. Sasa mnaweza kutoka na kwenda zenu kwa amani.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lakini Paulo alimjibu, “Ati nini? Ingawa hatukuwa na kosa, walitupiga viboko hadharani hali sisi ni raia wa Roma. Tena, walitutia ndani na sasa wanataka kutufungulia kwa siri! Hata kidogo! Ni lazima wao wenyewe waje hapa watufungulie.” ");
INSERT INTO swh1850_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Hao maofisa waliwapasha habari mahakimu juu ya jambo hilo, nao waliposikia kwamba Paulo na Sila walikuwa raia wa Roma, waliogopa. ");
INSERT INTO swh1850_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hivyo, walikwenda kuwataka radhi na baada ya kuwatoa ndani waliwaomba watoke katika mji ule. ");
INSERT INTO swh1850_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila walitoka gerezani, wakaenda nyumbani kwa Ludia. Huko walionana na ndugu waumini na baada ya kuwatia moyo wakaondoka. ");
INSERT INTO swh1850_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kwa kupitia Amfipoli na Apolonia, walisafiri mpaka Thesalonika ambako kulikuwa na sunagogi la Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo alijiunga nao kama ilivyokuwa desturi yake akajadiliana nao Sabato tatu mfululizo, akatumia Maandiko Matakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aliyaeleza na kuonyesha kwamba ilimbidi Kristo kuteswa na kufufuka kutoka wafu. Akawaambia, “Yesu ambaye mimi namhubiri kwenu ndiye Kristo.” ");
INSERT INTO swh1850_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Baadhi yao walikubali wakajiunga na Paulo na Sila. Kadhalika, idadi kubwa ya Wagiriki waliomcha Mungu pamoja na wanawake wengi wa tabaka la juu, walijiunga nao. ");
INSERT INTO swh1850_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini Wayahudi wakaona wivu; wakawakodi wafidhuli sokoni, wakafanya kikundi na kuzusha fujo mjini kote. Wakaivamia nyumba ya Yasoni wakitumaini kuwapata humo Paulo na Sila ili wawalete hadharani. ");
INSERT INTO swh1850_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lakini hawakuwapata na hivyo walimburuta Yasoni pamoja na ndugu wengine mpaka kwa wakuu wa mji, wakapiga kelele: “Watu hawa wamekuwa wakivuruga dunia yote na sasa wako hapa mjini. ");
INSERT INTO swh1850_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni amewakaribisha nyumbani kwake. Wote wanafanya kinyume cha amri ya Kaisari wakisema eti Kuna mfalme mwingine aitwaye Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa maneno hayo waliwatia wasiwasi wakuu wa mji na kundi la watu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Wakawafanya Yasoni na wenzake watoe dhamana, kisha wakawaacha waende zao. ");
INSERT INTO swh1850_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Usiku, wale ndugu waliwahimiza Paulo na Sila waende Berea. Mara tu walipofika huko, walikwenda katika sunagogi la Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Watu wa huko walikuwa wasikivu zaidi kuliko wale wa Thesalonika. Waliupokea ule ujumbe kwa hamu kubwa, wakawa wanayachunguza Maandiko Matakatifu kila siku, ili kuona kama yale waliyosema Paulo na Sila yalikuwa kweli. ");
INSERT INTO swh1850_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wengi wao waliamini na pia wanawake wa Kigiriki wa tabaka la juu na wanaume pia. ");
INSERT INTO swh1850_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini, Wayahudi wa Thesalonika walipogundua kwamba Paulo alikuwa anahubiri neno la Mungu huko Berea, walikwenda huko, wakaanza kufanya fujo na kuchochea makundi ya watu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wale ndugu wakamsindikiza haraka aende pwani lakini Sila na Timotheo walibaki Berea. ");
INSERT INTO swh1850_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wale ndugu waliomsindikiza Paulo walikwenda pamoja naye mpaka Athene. Kisha, wakarudi pamoja na maagizo kutoka kwa Paulo kwamba Sila na Timotheo wamfuate upesi iwezekanavyo. ");
INSERT INTO swh1850_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo alipokuwa anawasubiri Sila na Timotheo huko Athene, moyo wake ulighadhibika sana alipoona jinsi mji huo ulivyokuwa umejaa sanamu za miungu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Alijadiliana na Wayahudi na watu wengine waliomcha Mungu katika sunagogi; na kila siku alikuwa na majadiliano sokoni pamoja na wowote wale waliojitokeza. ");
INSERT INTO swh1850_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wengine waliofuata falsafa ya Epikuro na Stoiki walibishana naye. Wengine walisema, “Anataka kusema nini huyu bwanamaneno?” Kwa kuwa Paulo alikuwa anahubiri juu ya Yesu na juu ya ufufuo, wengine walisema, “Inaonekana kama anahubiri juu ya miungu ya kigeni.” ");
INSERT INTO swh1850_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Hivyo walimchukua Paulo, wakampeleka Areopago, wakasema, “Tunataka kujua jambo hili jipya ulilokuwa unazungumzia. ");
INSERT INTO swh1850_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Vitu vingine tulivyosikia kwa masikio yetu vinaonekana kuwa viroja kwetu. Tungependa kujua mambo haya yana maana gani.” ");
INSERT INTO swh1850_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wananchi wa Athene na wakazi wengine wa huko walikuwa wanatumia wakati wao wote kuhadithiana na kusikiliza habari mpyampya. ");
INSERT INTO swh1850_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Basi, Paulo alisimama mbele ya baraza la Areopago, akasema, “Wananchi wa Athene! Ninaona kwamba ninyi, kwa vyovyote, ni watu wa dini sana. ");
INSERT INTO swh1850_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sababu yenyewe ni kwamba katika pitapita yangu niliangalia sanamu zenu za ibada nikakuta madhabahu moja ambayo imeandikwa: Kwa ajili ya Mungu yule Asiyejulikana. Basi, huyo mnayemwabudu bila kujua, ndiye ninayemhubiri kwenu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mungu, aliyeumba ulimwengu na vyote vilivyomo, ni Bwana wa mbingu na nchi; yeye hakai katika hekalu zilizojengwa na watu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wala hatumikiwi kwa mikono ya watu kana kwamba anahitaji chochote kile, kwa maana yeye mwenyewe ndiye anayewapa watu uhai, anawawezesha kupumua na anawapa kila kitu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kutokana na mtu mmoja aliumba mataifa yote na kuyawezesha kuishi duniani kote. Aliamua na kupanga kabla kabisa lini na wapi mataifa hayo yangeishi. ");
INSERT INTO swh1850_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Alifanya hivyo, ili mataifa hayo yapate kumfuata, na kama vile kwa kupapasapapasa, yapate kumfikia. Hata hivyo lakini, Mungu hayuko mbali na kila mmoja wetu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kama alivyosema mtu mmoja: Ndani yake yeye sisi tunaishi, tunajimudu, na tuko! Ni kama washairi wenu wengine walivyosema: Sisi ni watoto wake. ");
INSERT INTO swh1850_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ikiwa basi, sisi ni watoto wa Mungu, haifai kumfikiria Mungu kuwa kama dhahabu, fedha au hata jiwe lililochongwa na kutiwa nakshi na binadamu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mungu alifanya kama kwamba haoni nyakati zile watu walipokuwa wajinga. Lakini sasa, anaamuru watu wote kila mahali watubu. ");
INSERT INTO swh1850_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwa maana amekwisha weka siku ambayo atauhukumu ulimwengu kwa haki kwa njia ya mtu mmoja aliyemteua. Mungu amewathibitishia wote jambo hili kwa kumfufua mtu huyo kutoka wafu!” ");
INSERT INTO swh1850_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Walipomsikia Paulo anasema juu ya jambo la kufufuka kwa wafu, wengine wao waliangua kicheko; lakini wengine walisema, “Tunataka kukusikia tena juu ya jambo hili!” ");
INSERT INTO swh1850_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hivyo, Paulo aliwaacha, akatoka barazani. ");
INSERT INTO swh1850_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini watu kadhaa waliandamana naye, wakawa waumini. Miongoni mwao walikuwa Dionisio wa Areopago, mwanamke mmoja aitwaye Damari na wengineo. ");
INSERT INTO swh1850_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Baada ya hayo, Paulo aliondoka Athene, akaenda Korintho. ");
INSERT INTO swh1850_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Huko Korintho, alimkuta Myahudi mmoja aitwaye Akula, mzaliwa wa Ponto. Akula pamoja na mkewe aitwaye Priskila, walikuwa wamerudi kutoka Italia siku hizohizo kwa sababu Kaisari Klaudio alikuwa ameamuru Wayahudi wote waondoke Roma. Paulo alikwenda kuwaona, ");
INSERT INTO swh1850_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwa vile wao walikuwa mafundi wa kushona mahema kama alivyokuwa yeye, Paulo alikaa nao akafanya kazi. ");
INSERT INTO swh1850_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Sabato alifanya majadiliano katika sunagogi akijaribu kuwavuta Wayahudi na Wagiriki. ");
INSERT INTO swh1850_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Baada ya Sila na Timotheo kuwasili kutoka Makedonia, Paulo alianza kutumia wakati wake wote kwa ajili ya kuhubiri, akawathibitishia Wayahudi kwamba Yesu ndiye Kristo. ");
INSERT INTO swh1850_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Walipompinga na kuanza kumtukana, aliyakung'uta mavazi yake mbele yao akisema, “Mkipotea ni shauri lenu wenyewe; mimi sina lawama yoyote juu ya jambo hilo. Na tangu sasa nitawaendea watu na mataifa mengine.” ");
INSERT INTO swh1850_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Basi, akatoka hapo akaenda kukaa nyumbani kwa mtu mmoja mcha Mungu aitwaye Tito Yusto. Nyumba yake Tito ilikuwa karibu na lile sunagogi. ");
INSERT INTO swh1850_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Lakini Krispo, mkuu wa sunagogi, alimwamini Bwana yeye pamoja na jamaa yake yote. Wakorintho wengi waliusikiliza ujumbe huo, wakaamini na kubatizwa. ");
INSERT INTO swh1850_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Siku moja usiku, Bwana alimwambia Paulo katika maono: “Usiogope, endelea kuhubiri tu bila kufa moyo, ");
INSERT INTO swh1850_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","maana mimi niko pamoja nawe. Hakuna mtu atakayejaribu kukudhuru maana hapa mjini pana watu wengi walio upande wangu.” ");
INSERT INTO swh1850_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Basi, Paulo alikaa huko akifundisha neno la Mungu kati yao kwa muda wa mwaka mmoja na nusu. ");
INSERT INTO swh1850_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakini wakati Galio alipokuwa mkuu wa mkoa wa Akaya, Wayahudi walimvamia Paulo kwa pamoja na kumpeleka mahakamani. ");
INSERT INTO swh1850_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wakasema, “Tunamshtaki mtu huyu kwa sababu ya kuwashawishi watu wamwabudu Mungu kwa namna inayopingana na Sheria.” ");
INSERT INTO swh1850_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kabla tu Paulo hajaanza kusema, Galio aliwaambia Wayahudi, “Sikilizeni enyi Wayahudi! Kama kweli jambo hili lingekuwa juu ya uhalifu au uovu ningekuwa tayari kuwasikilizeni. ");
INSERT INTO swh1850_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini kama ni shauri la ubishi kuhusu maneno na majina ya Sheria yenu, amueni ninyi wenyewe. Mimi sitaki kuwa hakimu wa mambo haya!” ");
INSERT INTO swh1850_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Basi, akawafukuza kutoka mahakamani. ");
INSERT INTO swh1850_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nao wote wakamkamata Sosthene ambaye alikuwa kiongozi wa sunagogi, wakampiga palepale mbele ya mahakama. Lakini Galio hakujali kitendo hicho hata kidogo. ");
INSERT INTO swh1850_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo alikaa bado na wale ndugu huko Korintho kwa siku nyingi. Kisha aliwaaga, akapanda meli kwenda Siria pamoja na Priskila na Akula. Huko Kenkrea, alinyoa nywele zake kwa sababu ya nadhiri aliyokuwa ameweka. ");
INSERT INTO swh1850_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Walifika Efeso na hapo Paulo aliwaacha Priskila na Akula, akaenda katika sunagogi, akajadiliana na Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Walimwomba akae nao muda mrefu zaidi, lakini hakupenda. ");
INSERT INTO swh1850_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bali alipokuwa anaondoka, alisema, “Mungu akipenda nitakuja kwenu tena.” Akaondoka Efeso kwa meli. ");
INSERT INTO swh1850_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Meli ilitia nanga Kaisarea, naye Paulo akaenda Yerusalemu kulisalimia lile kanisa, kisha akaenda Antiokia. ");
INSERT INTO swh1850_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Alikaa huko muda mfupi, halafu akaendelea na safari kwa kupitia sehemu za Galatia na Frugia akiwatia moyo wafuasi wote. ");
INSERT INTO swh1850_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myahudi mmoja aitwaye Apolo, mzaliwa wa Aleksandria, alifika Efeso. Alikuwa mtu mwenye ufasaha wa kuongea na mwenye ujuzi mkubwa wa Maandiko Matakatifu. ");
INSERT INTO swh1850_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Alikuwa amefundishwa juu ya hiyo njia ya Bwana, na akiwa motomoto, aliongea juu ya habari za Yesu. Akafundisha kwa usahihi ingawa alikuwa amepata ubatizo wa Yohane tu. ");
INSERT INTO swh1850_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Priskila na Akula walipomsikia akiongea kwa uhodari ndani ya sunagogi, walimchukua kwao wakamfundisha hiyo Njia ya Mungu kwa usahihi zaidi. ");
INSERT INTO swh1850_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo alipoamua kwenda Akaya, wale ndugu walimtia moyo kwa kuwaandikia wafuasi kule Akaya wampokee. Alipofika huko, aliweza kwa msaada wa neema ya Mungu, kuwasaidia sana wale ndugu waliopata kuwa waumini; ");
INSERT INTO swh1850_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kwa maana aliendelea kwa uhodari kuwashinda Wayahudi hadharani akithibitisha kwa Maandiko Matakatifu kuwa Yesu ni Kristo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wakati Apolo alipokuwa Korintho, Paulo alisafiri sehemu za bara, akafika Efeso ambako aliwakuta wanafunzi kadhaa. ");
INSERT INTO swh1850_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Akauliza, “Je, mlipopata kuwa waumini mlipokea Roho Mtakatifu?” Nao wakamjibu, “La! Hata kusikia kwamba kuna Roho Mtakatifu hatujasikia.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Naye akasema, “Sasa mlipata ubatizo wa namna gani?” Wakamjibu, “Ubatizo wa Yohane.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Naye Paulo akasema, “Ubatizo wa Yohane ulikuwa wa kuonyesha kwamba watu wametubu. Yohane aliwaambia watu wamwamini yule ambaye alikuwa anakuja baada yake, yaani Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Baada ya kusikia hayo, walibatizwa kwa jina la Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Basi, Paulo akawawekea mikono, na Roho Mtakatifu akawashukia, wakaanza kusema lugha mbalimbali na kutangaza ujumbe wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wote jumla, walikuwa watu wapatao kumi na wawili. ");
INSERT INTO swh1850_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa muda wa miezi mitatu Paulo alikuwa akienda katika sunagogi, akawa na majadiliano ya kuvutia sana juu ya Ufalme wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini wengine walikuwa wakaidi, wakakataa kuamini, wakaanza kuongea vibaya hadharani juu ya Njia ya Bwana. Hapo Paulo alivunja uhusiano nao, akawachukua pembeni wale wanafunzi wake, akawa anazungumza nao kila siku katika jumba la masomo la Turano. ");
INSERT INTO swh1850_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aliendelea kufanya hivyo kwa muda wa miaka miwili hata wakazi wote wa Asia, Wayahudi na watu wa mataifa mengine, wakaweza kusikia neno la Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mungu alifanya miujiza ya ajabu kwa mikono ya Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Watu walikuwa wakichukua leso na nguo nyingine za kazi ambazo Paulo alikuwa amezitumia, wakazipeleka kwa wagonjwa, nao wakaponywa magonjwa yao; na wale waliokuwa na pepo wabaya wakatokwa na pepo hao. ");
INSERT INTO swh1850_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi kadhaa wenye kupunga pepo wabaya, walisafiri huko na huko, wakijaribu kulitumia jina la Bwana Yesu kwa wale waliokuwa wamepagawa na pepo wabaya. Walikuwa wakisema: “Ninawaamuru kwa jina la Yesu ambaye Paulo anamhubiri.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Watoto saba wa Skewa, Kuhani Mkuu wa Kiyahudi, walikuwa miongoni mwa hao waliokuwa wanafanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lakini pepo mbaya aliwajibu, “Ninamfahamu Yesu, ninamjua pia Paulo, lakini ninyi ni nani?” ");
INSERT INTO swh1850_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kisha yule mtu aliyepagawa aliwarukia wote kwa kishindo, akawashinda nguvu. Na hao watoto wa Skewa wakakimbia kutoka ile nyumba wakiwa uchi na wamejaa majeraha. ");
INSERT INTO swh1850_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kila mtu huko Efeso, Myahudi na asiye Myahudi, alisikia juu ya tukio hilo. Wote waliingiwa na hofu, wakalitukuza jina la Bwana Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Waumini wengi walijitokeza wakakiri hadharani mambo waliyokuwa wametenda. ");
INSERT INTO swh1850_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wengine waliokuwa wameshughulikia mambo ya uchawi hapo awali, walikusanya vitabu vyao, wakavichoma mbele ya wote. Walikisia gharama ya vitabu hivyo, wakaona yafikia vipande vya fedha elfu hamsini. ");
INSERT INTO swh1850_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwa namna hiyo, neno la Bwana lilizidi kuenea na kuwa na nguvu zaidi. ");
INSERT INTO swh1850_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Baada ya mambo hayo, Paulo aliamua kwenda Yerusalemu kwa kupitia Makedonia na Akaya. Alisema, “Baada ya kufika huko, itanilazimu kuona Roma pia.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Hivyo, aliwatuma wawili wa wasaidizi wake, Timotheo na Erasto, wamtangulie kwenda Makedonia, naye akabaki kwa muda huko Asia. ");
INSERT INTO swh1850_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wakati huo ndipo kulipotokea ghasia kubwa huko Efeso kwa sababu ya hiyo Njia ya Bwana. ");
INSERT INTO swh1850_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kulikuwa na mfua fedha mmoja aitwaye Demetrio, ambaye alikuwa na kazi ya kutengeneza sanamu za nyumba ya mungu wa kike aitwaye Artemi. Shughuli hiyo iliwapatia mafundi faida kubwa. ");
INSERT INTO swh1850_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio aliwakusanya hao wafanyakazi pamoja na wengine waliokuwa na kazi kama hiyo, akawaambia, “Wananchi, mnafahamu kwamba kipato chetu kinatokana na biashara hii. ");
INSERT INTO swh1850_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Sasa, mnaweza kusikia na kujionea wenyewe mambo Paulo anayofanya, si tu hapa Efeso, ila pia kote katika Asia. Yeye amewashawishi na kuwageuza watu wakakubali kwamba miungu ile iliyotengenezwa na watu si miungu hata kidogo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hivyo iko hatari kwamba biashara yetu itakuwa na jina baya. Si hivyo tu, bali pia jambo hilo linaweza kuifanya nyumba ya mungu Artemi kuwa si kitu cha maana. Hatimaye sifa zake huyo ambaye Asia na dunia yote inamwabudu, zitakwisha.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Waliposikia hayo, waliwaka hasira, wakaanza kupiga kelele: “Mkuu ni Artemi, wa Efeso!” ");
INSERT INTO swh1850_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mji wote ukajaa ghasia. Wakawavamia Gayo na Aristarko, wenyeji wa Makedonia, ambao walikuwa wasafiri wenzake Paulo, wakakimbia nao mpaka kwenye ukumbi wa michezo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo mwenyewe alitaka kuukabili huo umati wa watu, lakini wale waumini walimzuia. ");
INSERT INTO swh1850_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Maofisa wengine wa huo mkoa wa Asia, waliokuwa rafiki zake, walimtumia Paulo ujumbe wakimsihi asijihatarishe kwa kwenda kwenye ukumbi wa michezo. ");
INSERT INTO swh1850_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wakati huo, kila mtu alikuwa anapayuka; wengine hili na wengine lile, mpaka hata ule mkutano ukavurugika. Wengi hawakujua hata sababu ya kukutana kwao. ");
INSERT INTO swh1850_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kwa vile Wayahudi walimfanya Aleksanda ajitokeze mbele, baadhi ya watu katika ule umati walidhani kuwa ndiye. Basi, Aleksanda aliwaashiria watu kwa mkono akitaka kujitetea mbele ya ule umati wa watu. ");
INSERT INTO swh1850_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini walipotambua kuwa yeye ni Myahudi, wote kwa sauti moja walipiga kelele: “Mkuu ni Artemi wa Efeso!” Wakaendelea kupayukapayuka hivyo kwa muda wa saa mbili. ");
INSERT INTO swh1850_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Hatimaye karani wa mji alifaulu kuwanyamazisha, akawaambia, “Wananchi wa Efeso, kila mtu anajua kwamba mji huu wa Efeso ni mlinzi wa nyumba ya mungu Artemi na mlinzi wa ile sanamu iliyoanguka kutoka mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hakuna anayeweza kukana mambo haya. Hivyo basi, tulieni; msifanye chochote bila hadhari. ");
INSERT INTO swh1850_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mmewaita watu hawa hapa ingawaje hawakuikufuru nyumba ya mungu wala kumtukana mungu wetu wa kike. ");
INSERT INTO swh1850_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kama, basi Demetrio na wafanyakazi wake wana mashtaka yao kuhusu watu hawa, yapo mahakama na wakuu wa mikoa; wanaweza kushtakiana huko. ");
INSERT INTO swh1850_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kama mna matatizo mengine, yapelekeni katika kikao halali. ");
INSERT INTO swh1850_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa maana tungaliweza kushtakiwa kwa kusababisha ghasia kutokana na vituko vya leo. Ghasia hii haina msingi halali na hatungeweza kutoa sababu za kuridhisha za ghasia hiyo.” ");
INSERT INTO swh1850_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Baada ya kusema hayo aliuvunja mkutano. ");
INSERT INTO swh1850_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ile ghasia ya Efeso ilipokwisha tulia Paulo aliwaita pamoja wale waumini, akawatia moyo. Kisha akawaaga, akasafiri kwenda Makedonia. ");
INSERT INTO swh1850_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Alipitia sehemu za nchi zile akiwatia watu moyo kwa maneno mengi. Halafu akafika Ugiriki. ");
INSERT INTO swh1850_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ambako alikaa kwa miezi mitatu. Alipokuwa anajitayarisha kwenda Siria, aligundua kwamba Wayahudi walikuwa wanamfanyia mpango mbaya; hivyo aliamua kurudi kwa kupitia Makedonia. ");
INSERT INTO swh1850_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatro, mwana wa Pirho kutoka Berea, aliandamana naye; pia Aristarko na Sekundo kutoka Thesalonika, Gayo kutoka Derbe, Timotheo, Tukiko na Trofimo wa mkoa wa Asia. ");
INSERT INTO swh1850_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Hao walitutangulia na kutungojea kule Troa. ");
INSERT INTO swh1850_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sisi, baada ya sikukuu ya Mikate Isiyotiwa chachu, tulipanda meli kutoka Filipi na baada ya siku tatu tukawafikia kule Troa. Huko tulikaa kwa muda wa juma moja. ");
INSERT INTO swh1850_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jumamosi jioni, tulikutana ili kumega mkate. Kwa vile Paulo alikuwa amekusudia kuondoka kesho yake, aliwahutubia watu na kuendelea kuongea nao hadi usiku wa manane. ");
INSERT INTO swh1850_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Katika chumba tulimokuwa, ghorofani, kulikuwa na taa nyingi zinawaka. ");
INSERT INTO swh1850_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kijana mmoja aitwaye Eutuko alikuwa ameketi dirishani wakati Paulo alipokuwa anaendelea kuhutubu. Eutuko alianza kusinzia kidogokidogo na hatimaye usingizi ukambana, akaanguka chini kutoka ghorofa ya tatu. Wakamwokota amekwisha kufa. ");
INSERT INTO swh1850_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lakini Paulo alishuka chini, akainama, akamkumbatia na kusema, “Msiwe na wasiwasi maana kuna uhai bado ndani yake.” ");
INSERT INTO swh1850_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kisha akapanda tena ghorofani, akamega mkate, akala. Aliendelea kuhubiri kwa muda mrefu hadi alfajiri, halafu akaondoka. ");
INSERT INTO swh1850_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wale watu walimchukua yule kijana nyumbani akiwa mzima kabisa, wakapata kitulizo kikubwa. ");
INSERT INTO swh1850_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sisi tulipanda meli tukatangulia kwenda Aso ambako tungemchukua Paulo. Ndivyo alivyopanga; maana alitaka kufika huko kwa kupitia nchi kavu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Basi, alitukuta kule Aso, tukampandisha melini, tukaenda Mitulene. ");
INSERT INTO swh1850_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kutoka huko tulisafiri tukafika Kio kesho yake. Siku ya pili, tulitia nanga Samo na kesho yake tukafika Mileto. ");
INSERT INTO swh1850_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo alikuwa amekusudia kuendelea na safari kwa meli bila kupitia Efeso ili asikawie zaidi huko Asia. Alikuwa na haraka ya kufika Yerusalemu kwa sikukuu ya Pentekoste kama ingewezekana. ");
INSERT INTO swh1850_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kutoka Mileto Paulo alituma ujumbe kwa wazee wa Efeso wakutane naye. ");
INSERT INTO swh1850_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Walipofika kwake aliwaambia, “Mnajua jinsi nilivyotumia wakati wote pamoja nanyi tangu siku ile ya kwanza nilipofika Asia. ");
INSERT INTO swh1850_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mnajua jinsi nilivyomtumikia Bwana kwa unyenyekevu wote, kwa machozi na matatizo yaliyonipata kutokana na mipango ya hila ya Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mnajua kwamba sikusita hata kidogo kuwahubiria hadharani na nyumbani mwenu na kuwafundisha chochote ambacho kingewasaidieni. ");
INSERT INTO swh1850_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Niliwaonya wote—Wayahudi kadhalika na watu wa mataifa, wamgeukie Mungu na kumwamini Bwana wetu Yesu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Sasa, sikilizeni! Mimi, nikiwa ninamtii Roho, nakwenda Yerusalemu bila kufahamu yatakayonipata huko. ");
INSERT INTO swh1850_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ninachojua tu ni kwamba Roho Mtakatifu ananithibitishia katika kila mji kwamba vifungo na mateso ndivyo vinavyoningojea. ");
INSERT INTO swh1850_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini, siuthamini uhai wangu kuwa ni kitu sana kwangu. Nataka tu nikamilishe ule utume wangu na kumaliza ile kazi aliyonipa Bwana Yesu niifanye, yaani nitangaze Habari Njema ya neema ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nimekuwa nikienda huko na huko kati yenu nikiuhubiri Ufalme wa Mungu. Sasa lakini, najua hakuna hata mmoja wenu atakayeniona tena. ");
INSERT INTO swh1850_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hivyo, leo hii ninawathibitishieni rasmi kwamba ikijatokea akapotea mmoja wenu, mimi sina lawama yoyote. ");
INSERT INTO swh1850_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwa maana sikusita hata kidogo kuwatangazieni azimio lote la Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jihadharini wenyewe; lilindeni lile kundi ambalo Roho Mtakatifu amewaweka ninyi muwe walezi wake. Lichungeni kanisa la Mungu ambalo amejipatia kwa damu ya Mwanae. ");
INSERT INTO swh1850_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nafahamu vizuri sana kwamba baada ya kuondoka kwangu mbwa mwitu wakali watawavamieni, na hawatakuwa na huruma kwa kundi hilo. ");
INSERT INTO swh1850_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata kutoka miongoni mwenu watatokea watu ambao watasema mambo ya uongo ili kuwapotosha watu na kuwafanya wawafuate wao tu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa hiyo, muwe macho mkikumbuka kwamba kwa muda wa miaka mitatu, usiku na mchana, sikuchoka kumwonya kila mmoja wenu kwa machozi. ");
INSERT INTO swh1850_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Na sasa basi, ninawaweka ninyi chini ya ulinzi wa Mungu na ujumbe wa neema yake. Yeye anao uwezo wa kuwajenga ninyi na kuwawezesha mzipate zile baraka alizowawekea watu wake. ");
INSERT INTO swh1850_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mimi sikutamani hata mara moja fedha, wala dhahabu, wala nguo za mtu yeyote. ");
INSERT INTO swh1850_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mnajua ninyi wenyewe kwamba nimefanya kazi kwa mikono yangu mwenyewe, ili kujipatia mahitaji yangu na ya wenzangu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nimekuwa nikiwapeni daima mfano kwamba kwa kufanya kazi mithili hiyo tunapaswa kuwasaidia walio dhaifu, tukikumbuka maneno ya Bwana Yesu mwenyewe: Heri zaidi kutoa kuliko kupokea.” ");
INSERT INTO swh1850_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Baada ya kusema hayo, Paulo alipiga magoti pamoja nao wote, akasali. ");
INSERT INTO swh1850_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wote walikuwa wanalia; wakamwaga kwa kumkumbatia na kumbusu. ");
INSERT INTO swh1850_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jambo lililowahuzunisha zaidi lilikuwa neno alilosema kwamba hawangemwona tena. Basi, wakamsindikiza hadi melini. ");
INSERT INTO swh1850_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tulipokwisha agana nao, tulipanda meli tukaenda moja kwa moja mpaka Kosi. Kesho yake tulifika Rodo, na kutoka huko tulikwenda Patara. ");
INSERT INTO swh1850_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Huko, tulikuta meli iliyokuwa inakwenda Foinike, hivyo tulipanda, tukasafiri. ");
INSERT INTO swh1850_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Baada ya kufika mahali ambapo tuliweza kuona Kupro, tulipitia upande wake wa kusini tukaelekea Siria. Tulitia nanga katika mji wa Tiro ambapo ile meli ilikuwa ipakuliwe shehena yake. ");
INSERT INTO swh1850_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tulikuta waumini huko, tukakaa pamoja nao kwa muda wa juma moja. Waumini hao wakawa waongea kwa nguvu ya Roho, wakamwambia Paulo asiende Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Lakini muda wetu ulipokwisha tuliondoka. Wote pamoja na wanawake na watoto wao walitusindikiza mpaka nje ya mji. Tulipofika pwani, sote tulipiga magoti tukasali. ");
INSERT INTO swh1850_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kisha tuliagana; sisi tukapanda meli nao wakarudi makwao. ");
INSERT INTO swh1850_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sisi tuliendelea na safari yetu kutoka Tiro tukafika Tolemai ambapo tuliwasalimu ndugu zetu, tukakaa nao siku moja. ");
INSERT INTO swh1850_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kesho yake tuliondoka tukaenda Kaisarea. Huko Kaisarea tulikwenda nyumbani kwa mhubiri Filipo. Yeye alikuwa mmoja wa wale saba waliochaguliwa kule Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Alikuwa na binti watatu ambao walikuwa na kipaji cha unabii. ");
INSERT INTO swh1850_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Baada ya kukaa huko siku kadhaa, nabii mmoja aitwaye Agabo alifika kutoka Yudea. ");
INSERT INTO swh1850_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Alitujia, akachukua mkanda wa Paulo, akajifunga mikono na miguu, akasema “Roho Mtakatifu asema hivi: Wayahudi kule Yerusalemu watamfunga namna hii mtu mwenye ukanda na kumtia mikononi mwa watu wa mataifa.” ");
INSERT INTO swh1850_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tuliposikia hayo, sisi na wale watu wengine waliokuwa hapo tulimsihi Paulo asiende Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lakini yeye alijibu, “Mnataka kufanya nini? Mnataka kuvunja moyo wangu kwa machozi? Niko tayari siyo tu kutiwa ndani kule Yerusalemu, ila hata kufa kwa ajili ya Bwana Yesu.” ");
INSERT INTO swh1850_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tuliposhindwa kumshawishi tulinyamaza, tukasema tu: “Mapenzi ya Bwana yafanyike” ");
INSERT INTO swh1850_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Baada ya kukaa pale kwa muda, tulifunga mizigo yetu, tukaendelea na safari kwenda Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wengine kati ya wale wafuasi wa Kaisarea walienda pamoja nasi, wakatupeleka nyumbani kwa Mnasoni ambaye tulikuwa tunakwenda kukaa naye kwa muda. Mnasoni alikuwa mwenyeji wa Kupro na alikuwa amekuwa muumini kwa siku nyingi. ");
INSERT INTO swh1850_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tulipofika Yerusalemu, ndugu waumini walitupokea vizuri sana. ");
INSERT INTO swh1850_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kesho yake Paulo alikwenda pamoja nasi kumwamkia Yakobo, na wazee wote wa kanisa walikuwako pia. ");
INSERT INTO swh1850_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Baada ya kuwasalimu, Paulo aliwapa taarifa kamili kuhusu yote Mungu aliyokuwa ametenda kati ya mataifa kwa njia ya utumishi wake. ");
INSERT INTO swh1850_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Waliposikia hayo, walimtukuza Mungu. Kisha wakamwambia Paulo, “Ndugu, unaweza kuona kwamba kuna maelfu ya Wayahudi ambao sasa wamekuwa waumini na wote hao wanashika kwa makini Sheria ya Mose. ");
INSERT INTO swh1850_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wamepata habari zako kwamba umekuwa ukiwafundisha Wayahudi wanaoishi kati ya mataifa mengine kuwa wasiijali Sheria ya Mose, wasiwatahiri watoto wao na kwamba wasizifuate mila za Wayahudi. ");
INSERT INTO swh1850_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sasa, mambo yatakuwaje? Ni dhahiri kuwa watapata habari kwamba umekwisha wasili hapa. ");
INSERT INTO swh1850_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Basi, fanya kama tunavyokushauri. Tunao hapa watu wanne ambao wameweka nadhiri. ");
INSERT INTO swh1850_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jiunge nao katika ibada ya kujitakasa, ukalipe na gharama zinazohusika, kisha wanyolewe nywele zao. Hivyo watu wote watatambua kwamba habari zile walizoambiwa juu yako hazina msingi wowote, na kwamba wewe binafsi bado unaishi kufuatana na maagizo ya Sheria za Mose. ");
INSERT INTO swh1850_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kuhusu wale watu wa mataifa mengine ambao wamekuwa waumini, tumekwisha wapelekea barua tukiwaambia mambo tuliyoamua: wasile chochote kilichotambikiwa miungu ya uongo, wasinywe damu, wasile nyama ya mnyama aliyenyongwa, na wajiepushe na uasherati.” ");
INSERT INTO swh1850_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Basi, kesho yake Paulo aliwachukua wale watu akafanya ibada ya kujitakasa pamoja nao. Kisha akaingia Hekaluni kutoa taarifa kuhusu mwisho wa siku za kujitakasa na kuhusu dhabihu itakayotolewa kwa ajili ya kila mmoja wao. ");
INSERT INTO swh1850_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wakati siku hizo saba zilipokaribia kuisha, Wayahudi waliokuwa wametoka katika mkoa wa Asia walimwona Paulo Hekaluni. Wakachochea hasira kati ya kundi lote la watu, wakamtia nguvuni ");
INSERT INTO swh1850_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","wakipiga kelele: “Wananchi wa Israeli, msaada, msaada! Huyu ndiye yule mtu anayewafundisha watu kila mahali mambo yanayopinga watu wa Israeli, yanayopinga Sheria ya Mose na mahali hapa patakatifu. Hata sasa amewaingiza watu wa mataifa mengine Hekaluni na kupatia najisi mahali hapa patakatifu.” ");
INSERT INTO swh1850_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sababu ya kusema hivyo ni kwamba walikuwa wamemwona Trofimo mwenyeji, wa Efeso, akiwa pamoja na Paulo mjini, wakadhani kwamba Paulo alikuwa amemwingiza Hekaluni. ");
INSERT INTO swh1850_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mji wote ulienea ghasia; watu wakaja kutoka pande zote, wakamkamata Paulo, wakamburuta, wakamtoa nje ya Hekalu na papo hapo milango ya Hekalu ikafungwa. ");
INSERT INTO swh1850_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Walikuwa tayari kumuua, lakini habari zilimfikia mkuu wa jeshi la Kiroma kuwa Yerusalemu yote ilikuwa imejaa ghasia. ");
INSERT INTO swh1850_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mara, mkuu wa jeshi akawachukua askari na jemadari, akalikabili lile kundi la watu. Nao walipomwona mkuu wa jeshi na askari, wakaacha kumpiga Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkuu wa jeshi alimwendea Paulo, akamtia nguvuni na kuamuru afungwe minyororo miwili. Kisha akauliza, “Ni mtu gani huyu, na amefanya nini?” ");
INSERT INTO swh1850_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wengine katika lile kundi la watu walikuwa wanapayuka kitu hiki na wengine kitu kingine. Kwa sababu ya ghasia hiyo, mkuu wa jeshi hakufaulu kujua kisa kamili. Hivyo, aliamuru watu wake wampeleke Paulo ndani ya ngome. ");
INSERT INTO swh1850_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo alipofika kwenye ngazi, askari walilazimika kumbeba kwa sababu ya fujo za watu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kwa maana kundi kubwa la watu walimfuata wakipiga kelele, “Muulie mbali!” ");
INSERT INTO swh1850_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Walipokuwa wanamwingiza ndani ya ngome, Paulo alimwomba mkuu wa jeshi akisema, “Naweza kukwambia kitu?” Yule mkuu wa jeshi akamjibu, “Je unajua Kigiriki? ");
INSERT INTO swh1850_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kwani wewe si yule Mmisri ambaye hivi majuzi alianzisha uasi na kuwaongoza majahili elfu nne hadi jangwani?” ");
INSERT INTO swh1850_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo akajibu, “Mimi ni Myahudi, mzaliwa wa Tarso katika Kilikia; mimi ni raia wa mji maarufu. Tafadhali, niruhusu niongee na watu. ");
INSERT INTO swh1850_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yule mkuu wa jeshi akamruhusu. Hivyo Paulo alisimama juu ya ngazi, akawapungia mkono wale watu na walipokaa kimya, akaanza kuongea nao kwa Kiebrania. ");
INSERT INTO swh1850_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndugu zangu na akina baba, nisikilizeni sasa nikijitetea mbele yenu!” ");
INSERT INTO swh1850_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Waliposikia akiongea nao kwa Kiebrania wakazidi kukaa kimya zaidi kuliko hapo awali. Naye Paulo akaendelea kusema, ");
INSERT INTO swh1850_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mimi ni Myahudi, mzaliwa wa Tarso katika Kilikia. Lakini nililelewa papa hapa mjini Yerusalemu chini ya mkufunzi Gamalieli. Nilifundishwa kufuata kwa uthabiti Sheria ya wazee wetu. Nilijitolea kwa moyo wote kwa Mungu kama ninyi wenyewe mlivyo hivi leo. ");
INSERT INTO swh1850_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Niliwatesa hata kuwaua wale watu waliofuata Njia hii. Niliwatia nguvuni wanaume kwa wanawake na kuwafunga gerezani. ");
INSERT INTO swh1850_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kuhani Mkuu na baraza lote la wazee wanaweza kushuhudia jambo hilo. Kutoka kwao nilipokea barua walioandikiwa wale ndugu Wayahudi waliokuwa huko Damasko. Nilikwenda Damasko ili niwatie nguvuni watu hao na kuwaleta wamefungwa mpaka Yerusalemu ili waadhibiwe. ");
INSERT INTO swh1850_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Basi, nilipokuwa njiani karibu kufika Damasko, yapata saa sita mchana, mwangu mkubwa kutoka mbinguni ulitokea ghafla ukaniangazia pande zote. ");
INSERT INTO swh1850_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hapo nilianguka chini, nikasikia sauti ikiniambia: Saulo, Saulo! Kwa nini unanitesa? ");
INSERT INTO swh1850_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nami nikauliza: Nani wewe, Bwana? Naye akaniambia: Mimi ni Yesu wa Nazareti ambaye wewe unamtesa. ");
INSERT INTO swh1850_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wale wenzangu waliuona ule mwanga lakini hawakusikia sauti ya yule aliyeongea nami. ");
INSERT INTO swh1850_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Basi, mimi nikauliza: Nifanye nini Bwana? Naye Bwana akaniambia: Simama, nenda Damasko na huko utaambiwa yote ambayo umepangiwa kufanya. ");
INSERT INTO swh1850_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kutokana na ule mwanga mkali sikuweza kuona na hivyo iliwabidi wale wenzangu kuniongoza kwa kunishika mkono mpaka nikafika Damasko. ");
INSERT INTO swh1850_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Huko kulikuwa na mtu mmoja aitwaye Anania, mtu mcha Mungu, mwenye kuitii Sheria yetu na aliyeheshimika sana mbele ya Wayahudi waliokuwa wanaishi Damasko. ");
INSERT INTO swh1850_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yeye alikuja kuniona, akasimama karibu nami, akasema: Ndugu Saulo! Ona tena. Papo hapo nikaona tena, nikamwangalia. ");
INSERT INTO swh1850_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Halafu Anania akasema: Mungu wa babu zetu amekuchagua upate kujua matakwa yake na kumwona yule mtumishi wake mwadilifu na kumsikia yeye mwenyewe akiongea. ");
INSERT INTO swh1850_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwa maana utamshuhudia kwa watu wote ukiwaambia yale uliyoyaona na kuyasikia. ");
INSERT INTO swh1850_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sasa basi, ya nini kukawia zaidi? Simama ubatizwe na uondolewe dhambi zako kwa kuliungama jina lake. ");
INSERT INTO swh1850_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Basi, nilirudi Yerusalemu, na nilipokuwa nikisali Hekaluni, niliona maono. ");
INSERT INTO swh1850_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nilimwona Bwana akiniambia: Haraka! Ondoka Yerusalemu upesi kwa maana watu wa hapa binadamu hawataukubali ushuhuda wako juu yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nami nikamjibu: Bwana, wao wanajua wazi kwamba mimi ni yule aliyekuwa anapitapita katika masunagogi na kuwatia nguvuni na kuwapiga wale waliokuwa wanakuamini. ");
INSERT INTO swh1850_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na kwamba wakati shahidi wako Stefano alipouawa, mimi binafsi nilikuwako pale nikakubaliana na kitendo hicho na kuyalinda makoti ya wale waliokuwa wanamuua. ");
INSERT INTO swh1850_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Naye Bwana akaniambia: Nenda; ninakutuma mbali kwa mataifa mengine.” ");
INSERT INTO swh1850_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mpaka hapa, wale watu walikuwa wanamsikiza, lakini aliposema maneno haya, walianza kusema kwa sauti kubwa, “Mwondoe duniani! Mtu wa namna hiyo hastahili kuishi.” ");
INSERT INTO swh1850_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Waliendelea kupayukapayuka huku wakitikisa makoti yao na kurusha vumbi angani. ");
INSERT INTO swh1850_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkuu wa jeshi aliwaamuru watu wake wampeleke Paulo ndani ya ngome, akawaambia wamchape viboko ili wapate kujua kisa cha Wayahudi kumpigia kelele. ");
INSERT INTO swh1850_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lakini walipokwisha mfunga ili wamchape viboko, Paulo alimwuliza jemadari mmoja aliyesimama hapo, “Je, ni halali kwenu kumpiga viboko raia wa Roma kabla hajahukumiwa?” ");
INSERT INTO swh1850_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yule jemadari aliposikia hayo, alimpasha habari mkuu wa jeshi akisema, “Unataka kufanya nini? Mtu huyu ni raia wa Roma!” ");
INSERT INTO swh1850_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Basi, mkuu wa jeshi alimwendea Paulo, akamwambia, “Niambie; je, wewe ni raia wa Roma?” Paulo akamjibu, “Naam.” ");
INSERT INTO swh1850_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mkuu wa jeshi akasema, “Mimi nami nimekuwa raia wa Roma kwa kulipa gharama kubwa.” Paulo akasema, “Lakini mimi ni raia wa Roma kwa kuzaliwa.” ");
INSERT INTO swh1850_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wale watu ambao walikuwa tayari kumchunguza Paulo walitoweka mara. Hata yule mkuu wa jeshi aliogopa alipojua kwamba Paulo ni raia wa Roma na kwamba alikuwa amekwisha mfunga minyororo. ");
INSERT INTO swh1850_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kesho yake, mkuu wa jeshi alitaka kujua mashtaka kamili ambayo Wayahudi walikuwa wamemwekea Paulo. Hivyo, alimfungua Paulo minyororo, akaamuru makuhani wakuu na Baraza lote wafanye kikao. Kisha alimleta Paulo, akamsimamisha mbele ya Baraza. ");
INSERT INTO swh1850_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo aliwakodolea macho wale wanabaraza, halafu akaanza kusema, “Ndugu zangu, mpaka hivi leo nimekuwa nikiishi na dhamiri njema mbele ya Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hapo Kuhani Mkuu Anania akaamuru wale waliokuwa wamesimama karibu na Paulo wampige kofi mdomoni. ");
INSERT INTO swh1850_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Basi, Paulo akamwambia, “Mungu mwenyewe atakupiga kofi wewe uliye kama ukuta uliopakwa chokaa! Unawezaje kukaa hapo ili unihukumu kisheria na huku wewe mwenyewe unaivunja Sheria kwa kuamuru nipigwe?” ");
INSERT INTO swh1850_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Watu waliokuwa wamesimama pale wakamwambia Paulo, “Unamtukana Kuhani Mkuu wa Mungu!” ");
INSERT INTO swh1850_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo akajibu, “Ndugu zangu, sikujua kama yeye ni Kuhani Mkuu. Maana Maandiko yasema hivi: Usiseme vibaya juu ya mtawala wa watu wako.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Wakati huo Paulo alikwisha tambua kwamba sehemu moja ya wanabaraza wale ilikuwa ni Masadukayo na nyingine Mafarisayo. Basi, alipaaza sauti yake mbele ya Baraza: “Ndugu zangu, mimi ni Mfarisayo, mwana wa Mfarisayo. Mimi nimeletwa mahakamani kwa kuwa ninatumaini kwamba wafu watafufuka.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Baada ya kusema hivyo, mzozo mkali ulitokea kati ya Mafarisayo na Masadukayo na mkutano ukagawanyika sehemu mbili. ");
INSERT INTO swh1850_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kisa chenyewe kilikuwa hiki: Masadukayo hushikilia kwamba wafu hawafufuki, hakuna malaika, na roho nazo hazipo. Lakini Mafarisayo husadiki hayo yote matatu. ");
INSERT INTO swh1850_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kelele ziliongezeka na baadhi ya walimu wa Sheria wa kikundi cha Mafarisayo walisimama na kutoa malalamiko yao kwa nguvu: “Hatuoni chochote kilicho kiovu katika mtu huyu; huenda ikawa kwamba roho au malaika ameongea naye.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mzozo ulizidi kuwa mwingi hata mkuu wa jeshi akaogopa kwamba Paulo angeraruliwa vipandevipande. Kwa hiyo, aliwaamuru askari wake kuingia kati ya lile kundi, wamtoe Paulo na kumrudisha ndani ya ngome. ");
INSERT INTO swh1850_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Usiku uliofuata, Bwana alisimama karibu na Paulo, akamwambia, “Jipe moyo! Umenishuhudia katika Yerusalemu, utafanya vivyo hivyo mjini Roma.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kulipokucha, Wayahudi walifanya kikao cha faragha. Wakala kiapo: “Hatutakula wala kunywa mpaka tutakapokuwa tumekwisha muua Paulo.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Watu zaidi ya arobaini ndio waliokula njama kufanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Basi, walikwenda kwa makuhani wakuu na wazee, wakasema, “Sisi tumeapa kwamba hatutaonja chochote kwa vinywa vyetu mpaka hapo tutakapokuwa tumemuua Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Sasa basi, ninyi pamoja na Baraza tumeni ujumbe kwa mkuu wa jeshi ili amlete Paulo kwenu mkijisingizia kwamba mnataka kupata habari kamili zaidi juu yake. Tuko tayari kumuua hata kabla hajafika karibu.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini mtoto wa kiume wa dada yake Paulo alisikia juu ya mpango huo; hivyo akaenda ndani ya ngome, akamjulisha Paulo juu ya njama hiyo. ");
INSERT INTO swh1850_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Hapo Paulo akamwita mmoja wa askari, akamwambia, “Mchukue kijana huyu kwa mkuu wa jeshi; ana kitu cha kumwambia.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Askari akamchukua huyo kijana, akamwongoza mpaka kwa mkuu wa jeshi, akasema, “Yule mfungwa Paulo ameniita akaniomba nimlete kijana huyu kwako kwa maana ana jambo la kukwambia.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mkuu wa jeshi alimshika huyo kijana mkono, akampeleka mahali pa faragha, akamwuliza, “Una nini cha kuniambia?” ");
INSERT INTO swh1850_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yeye akasema, “Wayahudi wamepatana wakuombe umpeleke Paulo Barazani wakijisingizia kwamba Baraza lingependa kupata habari kamili zaidi juu yake. ");
INSERT INTO swh1850_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lakini wewe usikubali kwa maana kuna watu zaidi ya arobaini walio tayari kumvamia. Wameapa kutokula wala kunywa mpaka watakapokuwa wamemuua. Sasa wako tayari, wanangojea tu uamuzi wako.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkuu wa jeshi alimwacha aende zake akimwonya asimwambie mtu yeyote kwamba amemletea habari hizo. ");
INSERT INTO swh1850_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Basi, mkuu wa jeshi aliwaita askari wawili akawaambia, “Wekeni tayari askari mia mbili, wapanda farasi sabini na askari mia mbili wa mikuki, waende Kaisarea; muwe tayari kuondoka kabla ya saa tatu leo usiku. ");
INSERT INTO swh1850_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wekeni farasi kadhaa kwa ajili ya Paulo; mfikisheni salama kwa Felisi, mkuu wa mkoa.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Halafu mkuu huyo wa jeshi akaandika barua hivi: ");
INSERT INTO swh1850_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mimi Klaudio Lusia ninakuandikia wewe Mheshimiwa Felisi, mkuu wa mkoa. Salamu! ");
INSERT INTO swh1850_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Wayahudi walimkamata mtu huyu na karibu wangemuua kama nisingalifahamishwa kwamba yeye ni raia wa Roma na hivyo nikaenda pamoja na askari nikamwokoa. ");
INSERT INTO swh1850_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nilimpeleka mbele ya Baraza lao kuu nikitaka kujua kisa cha mashtaka yao. ");
INSERT INTO swh1850_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Niligundua kwamba mashtaka yenyewe yalihusu ubishi juu ya sehemu kadha wa kadha za Sheria yao na hivyo sikuona kwamba amefanya chochote kinachostahili auawe au afungwe gerezani. ");
INSERT INTO swh1850_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nilipofahamishwa kwamba Wayahudi walikuwa wamefanya njama za kumuua, niliamua kumleta kwako. Nikamwambia washtaki wake walete mashtaka yao mbele yako.” ");
INSERT INTO swh1850_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Basi, hao askari walimchukua Paulo kama walivyoamriwa; wakampeleka usiku uleule mpaka Antipatri. ");
INSERT INTO swh1850_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kesho yake askari wa miguu walirudi ngomeni, wakawaacha wale askari wapanda farasi waendelee na safari pamoja na Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Walipofika Kaisarea walimpa mkuu wa mkoa ile barua na kumweka Paulo chini ya mamlaka yake. ");
INSERT INTO swh1850_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felisi alipoisoma hiyo barua aliwauliza Paulo ametoka mkoa gani. Alipofahamishwa kwamba alikuwa ametoka mkoa wa Kilikia, ");
INSERT INTO swh1850_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akasema, “Nitasikiliza kesi yako baada ya washtaki wako kufika.” Kisha akaamuru Paulo awekwe chini ya ulinzi ndani ya ukumbi wa Herode. ");
INSERT INTO swh1850_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Baada ya siku tano, Kuhani Mkuu Anania aliwasili Kaisarea pamoja na wazee kadhaa na wakili mmoja wa sheria aitwaye Tertulo. Walimwendea yule mkuu wa mkoa wakamweleza mashtaka yao juu ya Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo aliitwa na Tertulo akafungua mashtaka hivi: “Mheshimiwa Felisi, uongozi wako bora umeleta amani kubwa na marekebisho ya lazima yanafanywa kwa manufaa ya taifa letu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tunalipokea jambo hili kwa furaha daima na kutoa shukrani nyingi kwako kila mahali. ");
INSERT INTO swh1850_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini, bila kupoteza wakati wako zaidi, tunakusihi kwa wema wako, usikilize taarifa yetu fupi. ");
INSERT INTO swh1850_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tumegundua kwamba mtu huyu ni wa hatari mno. Yeye huanzisha ghasia kati ya Wayahudi kila mahali duniani na pia ni kiongozi wa kile chama cha Wanazareti. ");
INSERT INTO swh1850_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tena alijaribu kulikufuru Hekalu nasi tukamtia nguvuni. Kama ukimhoji wewe mwenyewe, utaweza kubainisha mambo haya yote tunayomshtaki kwayo.” Tulitaka kumhukumu kufuatana na Sheria yetu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lakini Lusia, mkuu wa jeshi, aliingilia kati, akamchukua kwa nguvu kutoka mikononi mwetu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kisha akaamuru washtaki wake waje mbele yako. ");
INSERT INTO swh1850_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nao Wayahudi waliunga mkono mashtaka hayo wakisema kwamba hayo yote yalikuwa kweli. ");
INSERT INTO swh1850_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Basi, mkuu wa mkoa alimwashiria Paulo aseme. Naye Paulo akasema, “Nafurahi kujitetea mbele yako nikijua kwamba umekuwa hakimu wa taifa hili kwa miaka mingi. ");
INSERT INTO swh1850_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Unaweza kujihakikishia kwamba si zaidi ya siku kumi na mbili tu zimepita tangu nilipokwenda kuabudu Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wayahudi hawakunikuta nikijadiliana na mtu yeyote. Hawakunikuta nikichochea watu Hekaluni wala katika masunagogi yao, wala mahali pengine popote katika mji huo. ");
INSERT INTO swh1850_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wala hawawezi kuthibitisha mashtaka waliyotoa juu yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ninachokubali mbele yako ni hiki: Mimi ninamwabudu Mungu na wazee wetu nikiishi kufuatana na Njia ile ambayo wao wanaiita chama cha uzushi. Ninaamini mambo yote yaliyoandikwa katika vitabu vya Sheria na manabii. ");
INSERT INTO swh1850_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mimi namtumainia Mungu, na wao wanalo tumaini hilo, kwamba watu, wema na wabaya, watafufuka. ");
INSERT INTO swh1850_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kwa hiyo ninajitahidi daima kuwa na dhamiri njema mbele ya Mungu na mbele ya watu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Baada ya kukaa mbali kwa miaka kadhaa, nilirudi Yerusalemu ili kuwapelekea wananchi wenzangu msaada na kutoa dhabihu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Wakati nilipokuwa nikifanya hayo ndipo waliponikuta Hekaluni, nilipokuwa nimekwisha fanya ile ibada ya kujitakasa. Hakukuwako kundi la watu wala ghasia. ");
INSERT INTO swh1850_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakini kulikuwa na Wayahudi wengine kutoka mkoa wa Asia; hao ndio wangepaswa kuwa hapa mbele yako na kutoa mashtaka yao kama wana chochote cha kusema dhidi yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au, waache hawa walio hapa waseme kosa waliloliona kwangu wakati niliposimama mbele ya Baraza lao kuu, ");
INSERT INTO swh1850_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","isipokuwa tu maneno haya niliyosema niliposimama mbele yao: Mnanihukumu leo hii kwa sababu ya kushikilia kwamba wafu watafufuliwa!” ");
INSERT INTO swh1850_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Hapo, Felisi, ambaye mwenyewe alikuwa anaifahamu hiyo Njia vizuri, aliahirisha kesi hiyo. Akawaambia, “Nitatoa hukumu juu ya kesi hiyo wakati Luisa, mkuu wa jeshi, atakapokuja hapa.” ");
INSERT INTO swh1850_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kisha akamwamuru yule jemadari amweke Paulo kizuizini, lakini awe na uhuru kiasi, na rafiki zake wasizuiwe kumpatia mahitaji yake. ");
INSERT INTO swh1850_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Baada ya siku chache, Felisi alifika pamoja na mkewe Drusila ambaye alikuwa Myahudi. Aliamuru Paulo aletwe, akamsikiliza akiongea juu ya kumwamini Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lakini wakati Paulo alipoanza kuongea juu ya uadilifu, juu ya kuwa na kiasi na juu ya siku ya hukumu inayokuja, Felisi aliogopa, akasema, “Kwa sasa unaweza kwenda; nitakuita tena nitakapopata nafasi.” ");
INSERT INTO swh1850_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wakati huohuo alikuwa anatumaini kwamba Paulo angempa fedha. Kwa sababu hii alimwita Paulo mara kwa mara na kuzungumza naye. ");
INSERT INTO swh1850_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Baada ya miaka miwili, Porkio Festo alichukua nafasi ya Felisi, akawa mkuu wa Mkoa. Kwa kuwa alitaka kujipendekeza kwa Wayahudi, Felisi alimwacha Paulo kizuizini. ");
INSERT INTO swh1850_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Siku tatu baada ya kufika mkoani, Festo alitoka Kaisarea, akaenda Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Makuhani wakuu pamoja na viongozi wa Wayahudi walimpa habari kuhusu mashtaka yaliyokuwa yanamkabili Paulo. Walimsihi Festo ");
INSERT INTO swh1850_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","awafanyie fadhili kwa kumleta Paulo Yerusalemu; walikuwa wamekula njama wamuue akiwa njiani. ");
INSERT INTO swh1850_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lakini Festo alijibu, “Paulo atabaki kizuizini kule Kaisarea na mimi nitakwenda huko karibuni. ");
INSERT INTO swh1850_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Waacheni viongozi wenu waende huko pamoja nami wakatoe mashtaka yao juu yake kama amefanya chochote kiovu.” ");
INSERT INTO swh1850_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo alikaa nao kwa muda wa siku nane au kumi hivi, kisha akarudi Kaisarea. Kesho yake alikwenda barazani, akaamuru Paulo aletwe ndani. ");
INSERT INTO swh1850_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Wakati Paulo alipofika, Wayahudi waliokuwa wametoka Yerusalemu walimzunguka wakaanza kutoa mashtaka mengi mazitomazito ambayo hawakuweza kuthibitisha. ");
INSERT INTO swh1850_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kwa kujitetea, Paulo alisema, “Mimi sikufanya kosa lolote kuhusu Sheria ya Wayahudi, wala kuhusu Hekalu, wala kumhusu Kaisari.” ");
INSERT INTO swh1850_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festo alitaka kujipendekeza kwa Wayahudi na hivyo akamwuliza Paulo, “Je, ungependa kwenda Yerusalemu na huko ukahukumiwe mbele yangu kuhusu mashtaka haya?” ");
INSERT INTO swh1850_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo akajibu, “Nasimama mbele ya mahakama ya Kaisari na papa hapa ndipo ninapopaswa kupewa hukumu. Kama unavyojua vizuri, sikuwatendea Wayahudi ubaya wowote. ");
INSERT INTO swh1850_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Basi, ikiwa nimepatikana na kosa linalostahili adhabu ya kifo, siombi kusamehewa adhabu hiyo. Lakini kama hakuna ukweli katika mashtaka waliyotoa watu hawa, hakuna awezaye kunikabidhi kwao. Nakata rufani kwa Kaisari!” ");
INSERT INTO swh1850_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Basi, baada ya Festo kuzungumza na washauri wake, akamwambia Paulo, “Umekata rufani kwa Kaisari, basi, utakwenda kwa Kaisari.” ");
INSERT INTO swh1850_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Siku chache baadaye, mfalme Agripa na Bernike walifika Kaisarea ili kutoa heshima zao kwa Festo. ");
INSERT INTO swh1850_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Walikuwa huko siku kadhaa naye Festo akamweleza mfalme kesi ya Paulo: “Kuna mtu mmoja hapa ambaye Felisi alimwacha kizuizini. ");
INSERT INTO swh1850_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nilipokwenda Yerusalemu makuhani wakuu na wazee wa Wayahudi walimshtaki na kuniomba nimhukumu. ");
INSERT INTO swh1850_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lakini mimi niliwajibu kwamba si desturi ya Waroma kumtoa mtu aadhibiwe kabla mshtakiwa hajakutana na washtaki wake ana kwa ana na kupewa fursa ya kujitetea kuhusu hayo mashtaka. ");
INSERT INTO swh1850_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Basi, walipofika hapa sikukawia, ila nilifanya kikao mahakamani kesho yake, nikaamuru mtu huyo aletwe. ");
INSERT INTO swh1850_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Washtaki wake walisimama lakini hawakutoa mashtaka maovu kama nilivyokuwa ninatazamia. ");
INSERT INTO swh1850_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ila tu walikuwa na mabishano kadhaa pamoja naye kuhusu dini yao na kuhusu mtu mmoja aitwaye Yesu ambaye alikufa, lakini Paulo anashikilia kwamba yu hai. ");
INSERT INTO swh1850_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sikujua la kufanya kuhusu shauri hilo. Basi, nilimwuliza Paulo kama angependa kwenda mahakamani kule Yerusalemu kwa ajili ya mashtaka hayo. ");
INSERT INTO swh1850_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Paulo alikata rufani, akaomba aachwe kizuizini mpaka uamuzi wa shauri hilo ufanywe na Kaisari. Kwa hiyo niliamua akae kizuizini mpaka nitakapoweza kumpeleka kwa Kaisari.” ");
INSERT INTO swh1850_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Basi Agripa akamwambia Festo, “Ningependa kumsikia mtu huyu mimi mwenyewe.” Festo akamwambia, “Utamsikia kesho.” ");
INSERT INTO swh1850_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hivyo, kesho yake, Agripa na Bernike walifika kwa shangwe katika ukumbi wa mkutano wakiwa wameandamana na wakuu wa majeshi na viongozi wa mji. Festo aliamuru Paulo aletwe ndani, ");
INSERT INTO swh1850_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Kisha akasema, “Mfalme Agripa na wote mlioko hapa pamoja nasi! Hapa mbele yenu yuko mtu ambaye jumuiya yote ya Wayahudi hapa na kule Yerusalemu walinilalamikia wakipiga kelele kwamba hastahili kuishi tena. ");
INSERT INTO swh1850_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lakini mimi sikuona kuwa alikuwa ametenda chochote kibaya hata astahili kupewa adhabu ya kifo. Lakini, kwa vile Paulo mwenyewe alikata rufani kwa Kaisari, niliamua kumpeleka. ");
INSERT INTO swh1850_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kwa upande wangu sina habari kamili ambayo naweza kumwandikia Kaisari juu yake. Ndiyo maana nimemleta hapa mbele yenu na mbele yako mfalme Agripa, ili baada ya kumchunguza, niweze kuwa na la kuandika. ");
INSERT INTO swh1850_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwa maana nadhani itakuwa kichekesho kumpeleka mfungwa bila kutaja wazi mashtaka yanayomkabili.” ");
INSERT INTO swh1850_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Basi, Agripa akamwambia Paulo, “Unaruhusiwa kujitetea.” Hapo Paulo alinyosha mkono wake akajitetea hivi: ");
INSERT INTO swh1850_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mfalme Agripa, ninajiona mwenye bahati leo kujitetea mbele yako kuhusu yale mashtaka yote ambayo Wayahudi walikuwa wamesema juu yangu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Hasa kwa vile wewe mwenyewe ni mtaalamu wa desturi za Wayahudi na migogoro yao, ninakuomba basi unisikilize kwa uvumilivu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi wanajua habari za maisha yangu tangu utoto, jinsi nilivyoishi tangu mwanzo kati ya taifa langu huko Yerusalemu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wananifahamu kwa muda mrefu, na wanaweza kushuhudia, kama wakipenda, kwamba tangu mwanzo niliishi kama mmoja wa kikundi chenye siasa kali zaidi katika dini yetu, yaani kikundi cha Mafarisayo. ");
INSERT INTO swh1850_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na sasa niko hapa nihukumiwe kwa sababu ninaitumainia ile ahadi ambayo Mungu aliwaahidia babu zetu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ahadi hiyo ndiyo ileile inayotumainiwa na makabila kumi na mawili ya taifa letu, wakimtumikia Mungu kwa dhati mchana na usiku. Mheshimiwa mfalme, Wayahudi wananishtaki kwa sababu ya tumaini hilo! ");
INSERT INTO swh1850_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwa nini ninyi mnaona shida sana kuamini kwamba Mungu huwafufua wafu? ");
INSERT INTO swh1850_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kwa kweli mimi mwenyewe niliamini kwamba ni wajibu wangu kufanya mambo mengi kulipinga jina la Yesu wa Nazareti. ");
INSERT INTO swh1850_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mambo hayo ndiyo niliyoyafanya huko Yerusalemu. Mimi binafsi, nikiwa nimepewa mamlaka kutoka kwa makuhani wakuu, nilipata kuwatia gerezani wengi wa watu wa Mungu. Nao walipohukumiwa kuuawa, nilipiga kura ya kukubali. ");
INSERT INTO swh1850_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mara nyingi niliwafanya waadhibiwe katika masunagogi yote nikiwashurutisha waikane imani yao. Hasira yangu kwao ilikuwa kubwa hata nikawasaka mpaka miji ya mbali. ");
INSERT INTO swh1850_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kwa mujibu huohuo, nilikwenda Damasko wakati mmoja, nikiwa na mamlaka na maagizo kutoka kwa makuhani wakuu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mheshimiwa, wakati nilipokuwa njiani, saa sita mchana, niliona mwanga mkubwa kuliko wa jua ukiangaza kutoka mbinguni, ukanizunguka mimi na wale wasafiri wenzangu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Sisi sote tulianguka chini, nami nikasikia sauti ikiniambia kwa Kiebrania: Saulo, Saulo! Kwa nini unanitesa? Unajiumiza bure kama punda anayepiga teke fimbo ya bwana wake. ");
INSERT INTO swh1850_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mimi nikauliza: Ni nani wewe Bwana? Naye Bwana akajibu: Mimi ni Yesu ambaye wewe unamtesa. ");
INSERT INTO swh1850_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Haidhuru, inuka sasa; simama wima. Nimekutokea ili nikuweke rasmi kuwa mtumishi wangu. Utawathibitishia watu wengine mambo uliyoyaona leo na yale ambayo bado nitakuonyesha. ");
INSERT INTO swh1850_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nitakuokoa na watu wa Israeli na watu wa mataifa mengine ambao mimi ninakutuma kwao. ");
INSERT INTO swh1850_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Utayafumbua macho yao na kuwawezesha watoke gizani na kuingia katika mwanga; watoke katika utawala wa Shetani, wamgeukie Mungu; ili kwa kuamini, wapate kusamehewa dhambi na kuchukua nafasi yao kati ya wale ambao wamepata kuwa watu wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Hivyo, mfalme Agripa, sikuweza kuwa mkaidi kwa maono hilo la mbinguni. ");
INSERT INTO swh1850_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila nilianza kuhubiri kwanza kwa watu wa Damasko, halafu kwa wale wa Yerusalemu na nchi yote ya Yudea, na pia kwa watu wa mataifa mengine. Niliwahimiza wamgeukie Mungu na kuonyesha kwa vitendo kwamba wamebadilisha mioyo yao. ");
INSERT INTO swh1850_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa sababu hiyo, Wayahudi walinikamata nikiwa Hekaluni, wakajaribu kuniua. ");
INSERT INTO swh1850_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lakini Mungu alinisaidia; na hivyo mpaka siku ya leo nimesimama imara nikitoa ushuhuda kwa wote, wakubwa na wadogo. Ninayosema ni yale ambayo manabii na Mose walisema yatatukia; ");
INSERT INTO swh1850_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","yaani ilimpasa Kristo ateseke na kuwa wa kwanza kufufuka kutoka wafu, ili atangaze kwamba mwanga wa ukombozi unawaangazia sasa watu wote, Wayahudi na pia watu wa mataifa mengine.” ");
INSERT INTO swh1850_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo alipofika hapa katika kujitetea kwake, Festo alisema kwa sauti kubwa, “Paulo! Una wazimu! Kusoma kwako kwingi kunakutia wazimu!” ");
INSERT INTO swh1850_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lakini Paulo akasema, “Sina wazimu mheshimiwa Festo: Ninachosema ni ukweli mtupu. ");
INSERT INTO swh1850_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wewe Mfalme unayafahamu mambo haya, kwa hiyo ninaweza kuongea bila uoga mbele yako. Sina mashaka kwamba matukio hayo yanajulikana kwako maana jambo hili halikutendeka mafichoni. ");
INSERT INTO swh1850_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mfalme Agripa, je, una imani na manabii? Najua kwamba unaamini.” ");
INSERT INTO swh1850_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa akamjibu Paulo, “Kidogo tu utanifanya Mkristo!” ");
INSERT INTO swh1850_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo akamjibu, “Namwomba Mungu kwamba, kwa muda mfupi au mrefu, si wewe tu bali wote wanaonisikia leo wapate kuwa kama nilivyo mimi, lakini bila hii minyororo.” ");
INSERT INTO swh1850_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hapo mfalme Agripa, mkuu wa mkoa, Bernike na wale wote waliokuwa pamoja nao, walisimama. ");
INSERT INTO swh1850_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Walipokwisha ondoka, waliambiana, “Mtu huyu hakufanya chochote kinachostahili adhabu ya kifo au kifungo.” ");
INSERT INTO swh1850_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Naye Agripa akamwambia Festo, “Mtu huyu angeweza kufunguliwa kama asingalikuwa amekata rufani kwa Kaisari.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Walipokwisha amua tusafiri mpaka Italia, walimweka Paulo pamoja na wafungwa wengine chini ya ulinzi wa Yulio aliyekuwa ofisa wa jeshi katika kikosi kiitwacho “Kikosi cha Augusto.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tulipanda meli ya Adiramito iliyokuwa inasafiri na kupitia bandari kadhaa za mkoa wa Asia, tukaanza safari. Aristarko, mwenyeji wa Makedonia kutoka Thesalonika, alikuwa pamoja nasi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kesho yake tulitia nanga katika bandari ya Sidoni. Yulio alimtendea Paulo vizuri kwa kumruhusu awaone rafiki zake na kupata mahitaji yake. ");
INSERT INTO swh1850_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kutoka huko tuliendelea na safari, lakini kwa kuwa upepo ulikuwa unavuma kwa kasi kutujia kwa mbele, tulipitia upande wa kisiwa cha Kupro ambapo upepo haukuwa mwingi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Halafu tulivuka bahari ya Kilikia na Pamfulia, tukatia nanga Mura, mji wa Lukia. ");
INSERT INTO swh1850_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Hapo yule ofisa alikuta meli moja ya Aleksandria iliyokuwa inakwenda Italia, na hivyo akatupandisha ndani. ");
INSERT INTO swh1850_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kwa muda wa siku nyingi tulisafiri polepole, na kwa shida tulifika karibu na Nido. Kwa sababu upepo ulikuwa bado unatupinga, tuliendelea mbele moja kwa moja tukapitia upande wa Krete karibu na rasi Salmone ambapo upepo haukuwa mwingi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tulipita kando yake polepole tukafika mahali paitwapo “Bandari Nzuri”, karibu na mji wa Lasea. ");
INSERT INTO swh1850_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Muda mrefu ulikuwa umepita, na hata siku ya kufunga ilikuwa imekwisha pita. Sasa ilikuwa hatari sana kusafiri kwa meli. Basi, Paulo aliwapa onyo: ");
INSERT INTO swh1850_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Waheshimiwa, nahisi kwamba safari hii itakuwa ya shida na hasara nyingi si kwa shehena na meli tu, bali pia kwa maisha yetu.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini yule ofisa alivutiwa zaidi na maoni ya nahodha na ya mwenye meli kuliko yale aliyosema Paulo. ");
INSERT INTO swh1850_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwa kuwa bandari hiyo haikuwa mahali pazuri pa kukaa wakati wa baridi, wengi walipendelea kuendelea na safari, ikiwezekana mpaka Foinike. Foinike ni bandari ya Krete inayoelekea kusini-magharibi na kaskazini-magharibi; na huko wangeweza kukaa wakati wa baridi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Basi, upepo mzuri wa kusi ulianza kuvuma, nao wakadhani wamefanikiwa lengo lao; hivyo wakang'oa nanga, wakaiendesha meli karibu sana na pwani ya Krete. ");
INSERT INTO swh1850_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakini haukupita muda, upepo mkali uitwao “Upepo wa Kaskazi” ulianza kuvuma kutoka kisiwani. ");
INSERT INTO swh1850_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Upepo uliipiga ile meli, na kwa kuwa hatukuweza kuukabili, tukaiacha ikokotwe na huo upepo. ");
INSERT INTO swh1850_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kisiwa kimoja kiitwacho Kanda kilitukinga kidogo na ule upepo; na tulipopita kusini mwake tulifaulu, ingawa kwa shida, kuusalimisha ule mtumbwi wa meli. ");
INSERT INTO swh1850_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wale wanamaji waliuvuta mtumbwi ndani, kisha wakaizungushia meli kamba na kuifunga kwa nguvu. Waliogopa kwamba wangeweza kukwama kwenye ufuko wa bahari, pwani ya Libya. Kwa hiyo walishusha matanga na kuiacha meli ikokotwe na upepo. ");
INSERT INTO swh1850_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Dhoruba iliendelea kuvuma na kesho yake wakaanza kutupa nje shehena ya meli. ");
INSERT INTO swh1850_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Siku ya tatu, wakaanza pia kutupa majini vifaa vya meli kwa mikono yao wenyewe. ");
INSERT INTO swh1850_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa muda wa siku nyingi hatukuweza kuona jua wala nyota; dhoruba iliendelea kuvuma sana, hata matumaini yote ya kuokoka yakatuishia. ");
INSERT INTO swh1850_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Baada ya kukaa muda mrefu bila kula chakula, Paulo alisimama kati yao, akasema, “Waheshimiwa, ingalikuwa afadhali kama mngalinisikiliza na kuacha kusafiri kutoka Krete. Kama mngalifanya hivyo tungaliiepuka shida hii na hasara hizi zote. ");
INSERT INTO swh1850_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lakini sasa ninawaombeni muwe na moyo; hakuna hata mmoja wenu atakayepoteza maisha yake; meli tu ndiyo itakayopotea. ");
INSERT INTO swh1850_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwa maana jana usiku malaika wa yule Mungu ambaye mimi ni wake na ambaye mimi ninamwabudu alinitokea, ");
INSERT INTO swh1850_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","akaniambia: Paulo usiogope! Ni lazima utasimama mbele ya Kaisari; naye Mungu, kwa wema wake, amekufadhili kwa kuwaokoa wote wanaosafiri nawe wasiangamie. ");
INSERT INTO swh1850_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hivyo, waheshimiwa, jipeni moyo! Maana ninamwamini Mungu kwamba itakuwa sawa kama nilivyoambiwa. ");
INSERT INTO swh1850_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini ni lazima tutatupwa ufukoni mwa kisiwa fulani.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Usiku wa siku ya kumi na nne, tulikuwa tunakokotwa huku na huku katika bahari ya Adria. Karibu na usiku wa manane wanamaji walijihisi kuwa karibu na nchi kavu. ");
INSERT INTO swh1850_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Hivyo walitafuta kina cha bahari kwa kuteremsha kamba iliyokuwa imefungiwa kitu kizito, wakapata kina cha mita arobaini. Baadaye wakapima tena wakapata mita thelathini. ");
INSERT INTO swh1850_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwa sababu ya kuogopa kukwama kwenye miamba, waliteremsha nanga nne nyuma ya meli; wakaomba kuche upesi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wanamaji walitaka kutoroka, na walikwisha kuteremsha ule mtumbwi majini, wakijisingizia kwamba wanakwenda kuteremsha nanga upande wa mbele wa meli. ");
INSERT INTO swh1850_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Paulo alimwambia yule ofisa wa jeshi na askari wake, “Kama wanamaji hawa hawabaki ndani ya meli, hamtaokoka.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Hapo wale askari walizikata kamba zilizokuwa zimeshikilia ule mtumbwi, wakauacha uchukuliwe na maji. ");
INSERT INTO swh1850_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Karibu na alfajiri, Paulo aliwahimiza wote wale chakula: “Kwa siku kumi na nne sasa mmekuwa katika mashaka na bila kula; hamjala kitu chochote. ");
INSERT INTO swh1850_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Basi, ninawasihi mle chakula kwa maana mnakihitaji ili mweze kuendelea kuishi. Maana hata unywele mmoja wa vichwa vyenu hautapotea.” ");
INSERT INTO swh1850_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Baada ya kusema hivyo, Paulo alichukua mkate, akamshukuru Mungu mbele yao wote, akaumega, akaanza kula. ");
INSERT INTO swh1850_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hapo wote wakapata moyo, nao pia wakala chakula. ");
INSERT INTO swh1850_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Jumla tulikuwa watu mia mbili na sabini na sita katika meli. ");
INSERT INTO swh1850_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Baada ya kila mmoja kula chakula cha kutosha, walipunguza uzito wa meli kwa kutupa nafaka baharini. ");
INSERT INTO swh1850_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kulipokucha, wanamaji hawakuweza kuitambua nchi ile, ila waliona ghuba moja yenye ufuko; wakaamua kutia nanga huko kama ikiwezekana. ");
INSERT INTO swh1850_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Hivyo walikata nanga na kuziacha baharini, na wakati huohuo wakazifungua kamba zilizokuwa zimeufunga usukani, kisha wakatweka tanga moja mbele kushika upepo, wakaelekea ufukoni. ");
INSERT INTO swh1850_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini walifika mahali ambapo mikondo miwili ya bahari hukutana, na meli ikakwama. Sehemu ya mbele ilikuwa imezama mchangani bila kutikisika. Sehemu ya nyuma ya meli ilianza kuvunjika vipandevipande kwa mapigo ya nguvu ya mawimbi. ");
INSERT INTO swh1850_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Askari walitaka kuwaua wafungwa wote kwa kuogopa kwamba wangeogelea hadi pwani na kutoroka. ");
INSERT INTO swh1850_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini kwa vile yule ofisajeshi alitaka kumwokoa Paulo, aliwazuia wasifanye hivyo. Aliamuru wale waliojua kuogelea waruke kutoka melini na kuogelea hadi pwani, ");
INSERT INTO swh1850_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","na wengine wafuate wakijishikilia kwenye mbao au kwenye vipande vya meli iliyovunjika. Ndivyo sisi sote tulivyofika salama pwani. ");
INSERT INTO swh1850_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tulipokwisha fika salama kwenye nchi kavu, tuligundua kwamba kile kisiwa kinaitwa Malta. ");
INSERT INTO swh1850_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wenyeji wa hapo walikuwa wema sana kwetu. Mvua ilikuwa inaanza kunyesha na kulikuwa na baridi, hivyo waliwasha moto, wakatukaribisha. ");
INSERT INTO swh1850_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo aliokota mzigo mdogo wa kuni akawa anazitia motoni. Hapo, kwa sababu ya lile joto la moto, nyoka akatoka katika kuni akamnasa Paulo mkononi na kujishikilia hapo. ");
INSERT INTO swh1850_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wenyeji wa pale walipokiona kile kiumbe kinaning'inia kwenye mkono wake waliambiana, “Bila shaka mtu huyu amekwisha ua mtu, na ingawa ameokoka kuangamia baharini, Haki haitamwacha aendelee kuishi!” ");
INSERT INTO swh1850_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini Paulo alikikung'utia kile kiumbe motoni na hakuumizwa hata kidogo. ");
INSERT INTO swh1850_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wale watu walikuwa wakitazamia kwamba angevimba au hapohapo angeanguka chini na kufa. Baada ya kungojea kwa muda mrefu bila kuona kwamba Paulo amepatwa na jambo lolote lisilo la kawaida, walibadilisha fikira zao juu yake, wakasema kuwa ni mungu. ");
INSERT INTO swh1850_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Karibu na mahali pale palikuwa na mashamba ya Publio, mkuu wa kile kisiwa. Publio alitukaribisha kirafiki, tukawa wageni wake kwa siku tatu. ");
INSERT INTO swh1850_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Basi, ikawa kwamba baba yake Publio alikuwa amelala kitandani, mgonjwa, ana homa na kuhara. Paulo alikwenda kumwona na baada ya kusali, akaweka mikono yake juu ya mgonjwa, akamponya. ");
INSERT INTO swh1850_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kutokana na tukio hilo, wagonjwa wote katika kile kisiwa walikuja wakaponywa. ");
INSERT INTO swh1850_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Watu walitupatia zawadi mbalimbali na wakati tulipoanza tena safari, walitia ndani ya meli masurufu tuliyohitaji. ");
INSERT INTO swh1850_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Baada ya miezi mitatu tulianza tena safari yetu kwa meli moja ya Aleksandria iitwayo “Miungu Pacha”. Meli hiyo ilikuwa imetia nanga kisiwani wakati wote wa baridi. ");
INSERT INTO swh1850_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tulifika katika mji wa Sirakusa, tukakaa hapo kwa siku tatu. ");
INSERT INTO swh1850_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Toka huko tuling'oa nanga, tukazunguka na kufika Regio. Baada ya siku moja, upepo ulianza kuvuma kutoka kusini, na baada ya siku mbili tulifika bandari ya Potioli. ");
INSERT INTO swh1850_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Huko tuliwakuta ndugu kadhaa ambao walituomba tukae nao kwa juma moja. Hivi ndivyo tulivyopata kufika Roma. ");
INSERT INTO swh1850_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ndugu wa kule Roma walipopata habari zetu, wakaja kutulaki kwenye soko la Apio na Mikahawa Mitatu. Paulo alipowaona alimshukuru Mungu, akapata moyo. ");
INSERT INTO swh1850_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tulipofika Roma, Paulo aliruhusiwa kukaa peke yake pamoja na askari mmoja wa kumlinda. ");
INSERT INTO swh1850_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Baada ya siku tatu, Paulo aliwaita pamoja viongozi wa Kiyahudi wa mahali hapo. Walipokusanyika, Paulo aliwaambia, “Wananchi wenzangu, mimi, ingawa sikufanya chochote kibaya wala kupinga desturi za wazee wetu, nilitiwa nguvuni kule Yerusalemu na kutiwa mikononi mwa Waroma. ");
INSERT INTO swh1850_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Waliponihoji na kuona kwamba sikuwa na hatia yeyote, walitaka kuniacha. ");
INSERT INTO swh1850_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Wayahudi wengine walipinga jambo hilo, nami nikalazimika kukata rufani kwa Kaisari, ingawa sikuwa na chochote cha kuwashtaki wananchi wenzangu. ");
INSERT INTO swh1850_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ni kwa sababu hiyo nimeomba kuonana na kuongea nanyi, maana nimefungwa minyororo hii kwa sababu ya tumaini lile la Israeli.” ");
INSERT INTO swh1850_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wao wakamwambia, “Sisi hatujapokea barua yoyote kutoka Yudea, wala hakuna ndugu yeyote aliyefika hapa na kutoa habari rasmi au kusema chochote kibaya juu yako. ");
INSERT INTO swh1850_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini tunafikiri inafaa tusikie kutoka kwako mwenyewe mambo yaliyo kichwani mwako. Kwa maana tujualo sisi kuhusu hicho kikundi ni kwamba kinapingwa kila mahali.” ");
INSERT INTO swh1850_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Basi, walipanga naye siku kamili ya kukutana, na wengi wakafika huko alikokuwa anakaa. Tangu asubuhi mpaka jioni Paulo aliwaeleza na kuwafafanulia juu ya Ufalme wa Mungu akijaribu kuwafanya wakubali habari juu ya Yesu kwa kutumia Sheria ya Mose na maandiko ya manabii. ");
INSERT INTO swh1850_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baadhi yao walikubali maneno yake, lakini wengine hawakuamini. ");
INSERT INTO swh1850_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Basi, kukawa na mtengano wa fikira kati yao. Walipokuwa wanakwenda zao, Paulo alisema jambo hili, “Kweli ni sawa yale aliyoyanena Roho Mtakatifu kwa wazee wenu kwa njia ya nabii Isaya ");
INSERT INTO swh1850_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","akisema: Nenda kwa watu hawa ukawaambie: kusikia mtasikia, lakini hamtaelewa; kutazama mtatazama, lakini hamtaona. ");
INSERT INTO swh1850_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Maana akili za watu hawa zimepumbaa, wameziba masikio yao, wamefumba macho yao. La sivyo, wangeona kwa macho yao, wangesikia kwa masikio yao. Wangeelewa kwa akili zao, na kunigeukia, asema Bwana, nami ningewaponya.” ");
INSERT INTO swh1850_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Halafu Paulo akamaliza na kusema, “Jueni basi, kwamba ujumbe wa Mungu juu ya wokovu umepelekwa kwa watu wa mataifa. Wao watasikiliza!” ");
INSERT INTO swh1850_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo alipokwisha sema hayo, Wayahudi walijiondokea huku wakiwa wanabishana vikali wao kwa wao. ");
INSERT INTO swh1850_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa muda wa miaka miwili mizima Paulo aliishi katika nyumba aliyoipanga yeye mwenyewe; akawa anawakaribisha wote waliofika kumsalimu. ");
INSERT INTO swh1850_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Alikuwa akihubiri Ufalme wa Mungu na kufundisha juu ya Bwana Yesu Kristo kwa uhodari, bila kizuizi. ");
INSERT INTO swh1850_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Kutoka kwangu mimi Paulo, mtumishi wa Kristo Yesu, na mtume niliyeteuliwa na kuitwa kwa ajili ya kuhubiri Habari Njema ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Hapo kale, Mungu aliwaahidia watu hii Habari Njema kwa njia ya manabii wake katika Maandiko Matakatifu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hii Habari Njema inamhusu Mwana wa Mungu, Bwana wetu Yesu Kristo, ambaye mintarafu ubinadamu wake, alikuwa mzawa wa Daudi; ");
INSERT INTO swh1850_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","mintarafu utakatifu wake wa kimungu, alithibitishwa kwa uwezo mkuu kwamba ni Mwana wa Mungu kwa kufufuliwa kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kwa njia yake, mimi nimepewa neema ya kuwa mtume, ili kwa ajili yake niwaongoze watu wa mataifa yote wapate kuamini na kutii. ");
INSERT INTO swh1850_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ninyi ni miongoni mwa watu hao; mmeitwa muwe watu wake Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Basi, ninawaandikia ninyi nyote mlioko Roma ambao Mungu anawapenda, akawateua muwe watu wake. Nawatakieni neema na amani kutoka kwa Mungu Baba yetu na Bwana Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Awali ya yote, namshukuru Mungu wangu kwa njia ya Yesu Kristo kwa ajili yenu nyote, kwa sababu imani yenu inasikika duniani kote. ");
INSERT INTO swh1850_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mungu, ambaye ninamtumikia kwa moyo wangu wote katika kuhubiri Habari Njema ya Mwanae, ni shahidi wangu kwamba ninawakumbukeni ");
INSERT INTO swh1850_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","daima katika sala zangu. Namwomba Mungu akipenda, anipatie nafasi nzuri ya kuja kwenu sasa. ");
INSERT INTO swh1850_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwa maana ninatamani sana kuwaoneni ili nipate kuwagawieni zawadi ya kiroho na kuwaimarisha. ");
INSERT INTO swh1850_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ndiyo kusema, tutaimarishana: imani yenu itaniimarisha mimi, na yangu itawaimarisha ninyi. ");
INSERT INTO swh1850_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ndugu zangu, nataka mjue kwamba mara nyingi nilikusudia kuwatembeleeni, lakini mpaka sasa nimezuiwa. Ningependa kupata mafanikio mema kati yenu kama nilivyopata kati ya watu wa mataifa mengine. ");
INSERT INTO swh1850_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ninalo jukumu kwa watu wote, waliostaarabika na wasiostaarabika, wenye elimu na wasio na elimu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ndiyo maana ninatamani pia kuihubiri Habari Njema kwenu ninyi mlioko huko Roma. ");
INSERT INTO swh1850_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Sioni aibu kutangaza Habari Njema; yenyewe ni nguvu ya Mungu inayowaokoa wote wanaoamini: Wayahudi kwanza, na wasio Wayahudi pia. ");
INSERT INTO swh1850_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwa maana Habari Njema inaonyesha wazi jinsi Mungu anavyowakubali watu kuwa waadilifu; jambo hili hufanyika kwa imani, tangu mwanzo mpaka mwisho. Kama ilivyoandikwa: “Mwadilifu kwa imani ataishi.” ");
INSERT INTO swh1850_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ghadhabu ya Mungu imedhihirishwa kutoka mbinguni dhidi ya uasi na uovu wote wa binadamu ambao kwa njia zao mbaya wanaupinga ukweli usijulikane. ");
INSERT INTO swh1850_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kwa maana, yote yanayoweza kujulikana juu ya Mungu ni wazi kwao; maana Mungu mwenyewe ameyadhirisha. ");
INSERT INTO swh1850_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tangu Mungu alipoumba ulimwengu, uwezo wake wa milele na uungu wake, ingawa havionekani kwa macho, vinafahamika wazi. Watu wanaweza kuyajua mambo hayo kutokana na vitu hivyo alivyoumba Mungu. Kwa hiyo hawana njia yoyote ya kujitetea! ");
INSERT INTO swh1850_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ingawa wanajua kuna Mungu, lakini hawampi heshima anayostahili, wala hawamshukuru. Badala yake, fikira zao zimekuwa batili na akili zao tupu zimejaa giza. ");
INSERT INTO swh1850_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wanajidai kuwa wenye hekima, kumbe ni wapumbavu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Wanaacha kumwabudu Mungu aishiye milele, na badala yake, wanaabudu sanamu zilizo mfano wa binadamu ambaye hufa, mfano wa wanyama, ndege, au wanyama watambaao. ");
INSERT INTO swh1850_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kwa sababu hiyo, Mungu amewaacha wafuate tamaa mbaya za mioyo yao na kufanyiana mambo ya aibu kwa miili yao. ");
INSERT INTO swh1850_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wanaubadili ukweli juu ya Mungu kwa uongo; wanaheshimu na kuabudu kiumbe badala ya Muumba mwenyewe, ambaye ndiye astahiliye sifa milele! Amina. ");
INSERT INTO swh1850_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwa hiyo, Mungu amewaacha wafuate tamaa mbaya. Hata wanawake wanabadili matumizi yanayopatana na maumbile. ");
INSERT INTO swh1850_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nao wanaume hali kadhalika, wanaacha kufuata matumizi ya maumbile ya mume na mke wakawakiana tamaa wao kwa wao. Wanaume wanafanyiana mambo ya aibu, na hivyo wanajiletea wenyewe adhabu wanayostahili kwa vitendo vyao viovu. ");
INSERT INTO swh1850_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwa vile watu walikataa kumtambua Mungu, Mungu amewaacha katika fikira zao potovu, wakafanya yale ambayo hawangestahili kufanya. ");
INSERT INTO swh1850_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wamejaa kila aina ya uovu, dhuluma, ulafi na ufisadi. Wamejaa wivu, uuaji, ugomvi, udanganyifu na nia mbaya; husengenya, ");
INSERT INTO swh1850_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","na kusingiziana; ni watu wa kuchukiza kwa Mungu, wafidhuli, wenye kiburi na majivuno; hodari sana katika kutenda mabaya, na hawawatii wazazi wao; ");
INSERT INTO swh1850_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","hawana dhamiri, hawatimizi ahadi zao, hawana wema wala huruma kwa wengine. ");
INSERT INTO swh1850_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wanajua kwamba Sheria ya Mungu yasema kwamba watu wanaoishi mithili hiyo, wanastahili kifo. Zaidi ya hayo, siyo tu kwamba wanafanya mambo hayo wao wenyewe, bali hata huwapongeza wale wanaofanya mambo hayohayo. ");
INSERT INTO swh1850_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Basi, rafiki, kama unawahukumu wengine, huwezi kamwe kujitetea haidhuru wewe ni nani. Kwa maana, kwa kuwahukumu wengine, unajilaani wewe mwenyewe kwa vile nawe unayafanya mambo yaleyale unayohukumu. ");
INSERT INTO swh1850_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tunajua kwamba hukumu ya Mungu kwa wale wanaofanya mambo kama hayo ni hukumu ya haki. ");
INSERT INTO swh1850_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lakini wewe, rafiki, unayewahukumu wale wanaofanya mambo kama hayo bali wewe pia unayafanya, je unadhani utaiepa hukumu ya Mungu? ");
INSERT INTO swh1850_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au labda unaudharau wema wake mkuu, uvumilivu wake na saburi yake, bila kutambua kwamba wema wake huo una shabaha ya kukuongoza upate kutubu? ");
INSERT INTO swh1850_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lakini unao ugumu na ukaidi wa moyo, na hivyo unajilundikia adhabu kwa Siku ile ambayo ghadhabu ya Mungu na hukumu zake za haki vitadhihirishwa. ");
INSERT INTO swh1850_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Siku hiyo Mungu atamlipa kila mmoja kufuatana na matendo yake. ");
INSERT INTO swh1850_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wale wanaozingatia kutenda mema, kutafuta utukufu na heshima ya Mungu na kutokufa, watapata uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lakini wale wengine wenye ubinafsi, wenye kukataa mambo ya haki na kufuata uovu, wataangukiwa na ghadhabu na hasira ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mateso na maumivu yatampata binadamu yeyote atendaye uovu. Yatawapata Wayahudi kwanza, na watu wa mataifa mengine pia. ");
INSERT INTO swh1850_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini Mungu atawapa utukufu, heshima na amani wale wanaotenda mema; Wayahudi kwanza, na watu wa mataifa mengine pia. ");
INSERT INTO swh1850_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Maana Mungu hambagui mtu yeyote. ");
INSERT INTO swh1850_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wale wanaotenda dhambi bila kuijua Sheria ya Mose wataangamia ingawaje hawajui Sheria. Na wale wanaotenda dhambi wakiwa wanaijua Sheria watahukumiwa kisheria. ");
INSERT INTO swh1850_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mtu hafanywi kuwa mwadilifu mbele yake Mungu kwa kuisikia Sheria, bali kwa kuitii Sheria. ");
INSERT INTO swh1850_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mathalan: watu wa mataifa mengine hawana Sheria ya Mose; lakini kila wanapotimiza matakwa ya Sheria wakiongozwa na dhamiri zao, wao wenyewe wanakuwa kipimo cha Sheria ingawa hawaijui Sheria. ");
INSERT INTO swh1850_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Mwenendo wao unaonyesha kwamba matakwa ya Sheria yameandikwa mioyoni mwao. Dhamiri zao zinashuhudia pia jambo hilo, maana fikira zao mara nyingine huwashtaki, na mara nyingine huwatetea. ");
INSERT INTO swh1850_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Hivyo, kufuatana na hii Habari Njema ninayohubiri, ndivyo itakavyokuwa wakati Mungu atakapohukumu mambo ya siri ya binadamu kwa njia ya Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Na wewe, je? Wewe mwenyewe unajiita Myahudi; unaitumainia Sheria na kujivunia kuwa wa Mungu; ");
INSERT INTO swh1850_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kwa njia ya Sheria unajua matakwa ya Mungu na unaweza kuchagua jambo jema; ");
INSERT INTO swh1850_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","wewe unajiona kuwa kiongozi wa vipofu na mwanga kwa wale walio gizani; ");
INSERT INTO swh1850_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","unajiona kuwa mkufunzi wa wajinga na mwalimu wa wale wasiokomaa bado. Unayo katika Sheria picha kamili ya elimu na ukweli. ");
INSERT INTO swh1850_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Basi, wewe unawafundisha wengine; kwa nini hujifundishi wewe mwenyewe? Unawahubiria wengine wasiibe, lakini kumbe wewe mwenyewe unaiba. ");
INSERT INTO swh1850_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Unasema: “Msizini,” na huku wewe unazini; unachukia sanamu za miungu hali wewe unajitajirisha kwa kuiba katika nyumba za miungu. ");
INSERT INTO swh1850_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kwa kujigamba ati unayo Sheria ya Mungu, je huoni kwamba kwa kuivunja Sheria unamdharau Mungu? ");
INSERT INTO swh1850_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kama vile Maandiko Matakatifu yasemavyo: “Watu wa mataifa mengine wamelikufuru jina la Mungu kwa sababu yenu ninyi Wayahudi!” ");
INSERT INTO swh1850_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kutahiriwa kwako kutakuwa na maana kama ukiitii Sheria. Lakini kama unaivunja Sheria, basi, ni afadhali ungalibaki bila kutahiriwa. ");
INSERT INTO swh1850_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kama mtu wa mataifa mengine ambaye hakutahiriwa akitimiza matakwa ya Sheria, hakika atafikiriwa kana kwamba ametahiriwa. ");
INSERT INTO swh1850_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Watu wa mataifa mengine watakuhukumu wewe Myahudi kama ukiivunja Sheria, ingawaje unayo maandishi ya Sheria na umetahiriwa, hali wao wanaitii Sheria ingawa hawakutahiriwa. ");
INSERT INTO swh1850_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ndiyo kusema, si kila anayeonekana kwa nje kuwa Myahudi ni Myahudi wa kweli, wala mtu hawi Myahudi wa kweli ati kwa kuwa ametahiriwa kimwili. ");
INSERT INTO swh1850_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Myahudi wa kweli ni yule aliye Myahudi kwa ndani, yaani yule ambaye ametahiriwa moyoni. Hili ni jambo la Roho, na si jambo la maandishi ya Sheria. Mtu wa namna hiyo anapata sifa, si kutoka kwa watu, bali kutoka kwa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Basi, Myahudi ana nini zaidi kuliko watu wengine? Au kutahiriwa kuna faida gani? ");
INSERT INTO swh1850_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Naam, iko faida kwa kila upande. Kwanza, Mungu aliwakabidhi Wayahudi ujumbe wake. ");
INSERT INTO swh1850_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lakini itakuwaje iwapo baadhi yao hawakuwa waaminifu? Je, jambo hilo litaondoa uaminifu wa Mungu? ");
INSERT INTO swh1850_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Hata kidogo! Mungu hubaki mwaminifu daima, ingawaje kila binadamu ni mwongo. Kama Maandiko Matakatifu yasemavyo: “Kila usemapo, maneno yako ni ya haki; na katika hukumu, wewe hushinda.” ");
INSERT INTO swh1850_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lakini, ikiwa uovu wetu unathibitisha kwamba Mungu anatenda kwa haki, tutasema nini? Je, tutasema kwamba anakosa haki akituadhibu? (Hapa naongea kibinadamu). ");
INSERT INTO swh1850_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hata kidogo! Ingekuwa hivyo, Mungu angewezaje kuuhukumu ulimwengu? ");
INSERT INTO swh1850_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Labda utasema: “Ikiwa ukosefu wa uaminifu kwa upande wangu unamdhihirisha Mungu kuwa mwaminifu zaidi na hivyo kumpatia utukufu, basi singepaswa kuhukumiwa kuwa mwenye dhambi!” ");
INSERT INTO swh1850_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ni sawa na kusema: tufanye maovu ili tupate mema! Ndivyo wengine walivyotukashifu kwa kutushtaki kwamba tumefundisha hivyo. Watahukumiwa wanavyostahili! ");
INSERT INTO swh1850_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tuseme nini, basi? Je, sisi Wayahudi ni bora zaidi kuliko wengine? Hata kidogo! Kwa maana nimekwisha bainisha hapo mwanzoni kwamba Wayahudi na watu wa mataifa mengine wote wako chini ya utawala wa dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kama Maandiko Matakatifu yasemavyo: “Hakuna hata mmoja aliye mwadilifu! ");
INSERT INTO swh1850_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Hakuna mtu anayeelewa, wala anayemtafuta Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wote wamepotoka wote wamekosa; hakuna atendaye mema, hakuna hata mmoja. ");
INSERT INTO swh1850_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Makoo yao ni kama kaburi wazi, ndimi zao zimejaa udanganyifu, midomoni mwao mwatoka maneno yenye sumu kama ya nyoka. ");
INSERT INTO swh1850_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Vinywa vyao vimejaa laana chungu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Miguu yao iko mbioni kumwaga damu, ");
INSERT INTO swh1850_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","popote waendapo husababisha maafa na mateso; ");
INSERT INTO swh1850_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","njia ya amani hawaijui. ");
INSERT INTO swh1850_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Hawajali kabisa kumcha Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tunajua kwamba Sheria huwahusu walio chini ya Sheria hiyo, hata hawawezi kuwa na kisingizio chochote, na ulimwengu wote uko chini ya hukumu ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Maana hakuna binadamu yeyote anayekubaliwa kuwa mwadilifu mbele yake Mungu kwa kuishika Sheria; kazi ya Sheria ni kumwonyesha tu mtu kwamba ametenda dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lakini sasa, njia ya Mungu ya kuwakubali watu kuwa waadilifu imekwisha dhihirishwa, tena bila kutegemea Sheria. Sheria na manabii hushuhudia jambo hili. ");
INSERT INTO swh1850_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mungu huwakubali watu kuwa waadilifu kwa njia ya imani yao kwa Yesu Kristo; Mungu hufanya hivyo kwa wote wanaoamini; hakuna ubaguzi wowote. ");
INSERT INTO swh1850_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Watu wote wametenda dhambi na wametindikiwa utukufu wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lakini kwa zawadi ya neema ya Mungu, watu wote hukubaliwa kuwa waadilifu kwa njia ya Yesu Kristo anayewakomboa. ");
INSERT INTO swh1850_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mungu alimtoa Yesu kusudi, kwa damu yake, awe njia ya kuwaondolea watu dhambi zao kwa imani yao kwake. Alifanya hivyo ili apate kuonyesha kwamba yeye ni mwadilifu. Hapo zamani Mungu alikuwa mvumilivu bila kuzijali dhambi za watu; ");
INSERT INTO swh1850_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","lakini sasa, wakati huu, anazikabili dhambi za watu apate kuonyesha uadilifu wake. Kwa namna hiyo Mungu mwenyewe huonyesha kwamba yeye ni mwadilifu na kwamba humkubali kuwa mwadilifu mtu yeyote anayemwamini Yesu. ");
INSERT INTO swh1850_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Basi, tunaweza kujivunia nini? Hakuna! Kwa nini? Je, kwa sababu ya kutimiza Sheria? La! Bali kwa sababu tunaamini. ");
INSERT INTO swh1850_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Maana mtu hukubaliwa kuwa mwadilifu kwa imani, wala si kwa kutimiza matakwa ya Sheria. ");
INSERT INTO swh1850_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Au je, Mungu nu Mungu wa Wayahudi tu, ama pia wa watu wa mataifa mengine? Naam, wa mataifa mengine pia. ");
INSERT INTO swh1850_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mungu ni mmoja, naye atawakubali Wayahudi kuwa waadilifu kwa imani yao, na watu wa mataifa mengine pia kwa imani yao. ");
INSERT INTO swh1850_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Je, tunaitumia imani kuibatilisha Sheria? Hata kidogo; bali tunaipa Sheria thamani yake kamili. ");
INSERT INTO swh1850_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tuseme nini basi, juu ya Abrahamu baba yetu? ");
INSERT INTO swh1850_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kama Abrahamu alikubaliwa kuwa mwadilifu kutokana na matendo yake, basi, anacho kitu cha kujivunia mbele ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kwa maana, Maandiko Matakatifu yasema: “Abrahamu alimwamini Mungu, naye Mungu akamkubali kuwa mwadilifu.” ");
INSERT INTO swh1850_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mfanyakazi hulipwa mshahara; mshahara wake si zawadi bali ni haki yake. ");
INSERT INTO swh1850_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lakini mtu asiyetegemea matendo yake mwenyewe, bali anamwamini Mungu ambaye huwasamehe waovu, basi, Mungu huijali imani ya mtu huyo, na hivi humkubali kuwa mwadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Naye Daudi asema hivi juu ya furaha ya mtu ambaye Mungu amemkubali kuwa mwadilifu bila kuyajali matendo yake: ");
INSERT INTO swh1850_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Heri wale waliosamehewa makosa yao ambao makosa yao yamefutwa. ");
INSERT INTO swh1850_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Heri mtu yule ambaye Bwana hataziweka dhambi zake katika kumbukumbu.” ");
INSERT INTO swh1850_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Je, hiyo ni kwa wale waliotahiriwa tu, ama pia kwa wale wasiotahiriwa? Ni kwa wale wasiotahiriwa pia. Kwa maana tumekwisha sema: “Abrahamu aliamini, naye Mungu akamkubali kuwa mwadilifu.” ");
INSERT INTO swh1850_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Je, Abrahamu alikubaliwa kabla ya kutahiriwa ama baada ya kutahiriwa? Kabla ya kutahiriwa, na si baada ya kutahiriwa. ");
INSERT INTO swh1850_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahamu alitahiriwa baadaye, na kutahiriwa huko kulikuwa alama iliyothibitisha kwamba Mungu alimkubali kuwa mwadilifu kwa sababu ya imani yake aliyokuwa nayo kabla ya kutahiriwa. Kwa hiyo, Abrahamu amekuwa baba wa wale wote ambao, ingawa hawakutahiriwa, wamemwamini Mungu, wakafanywa waadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Vilevile yeye ni baba wa wale waliotahiriwa; lakini si kwa kuwa wametahiriwa, bali kwa sababu wanafuata njia ileile ya imani baba yetu Abrahamu aliyofuata kabla ya kutahiriwa. ");
INSERT INTO swh1850_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mungu alimwahidi Abrahamu na wazawa wake kwamba ulimwengu ungekuwa mali yao. Ahadi hiyo haikufanywa kwa sababu Abrahamu aliitii Sheria, bali kwa kuwa aliamini, akakubaliwa kuwa mwadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Maana kama watakaopewa hayo aliyoahidi Mungu ni wale tu wanaoitii Sheria, basi, imani haina maana yoyote, nayo ahadi ya Mungu si kitu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sheria husababisha ghadhabu; lakini kama hakuna Sheria, haiwezekani kuivunja. ");
INSERT INTO swh1850_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kwa sababu hiyo, jambo hili lategemea imani, hivyo kwamba ahadi hiyo yatokana na neema ya Mungu, na kwamba ni hakika kuwa ahadi hiyo ni kwa ajili ya wote: si kwa wale tu wanaoishika Sheria, bali pia kwa wale waishio kwa imani kama Abrahamu. Yeye ni baba yetu sisi sote. ");
INSERT INTO swh1850_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kama Maandiko Matakatifu yasemavyo: “Nimekuweka uwe baba wa mataifa mengi.” Ahadi hiyo ni kweli mbele ya Mungu ambaye Abrahamu alimwamini—Mungu ambaye huwapa wafu uzima, na kwa amri yake, vitu ambavyo havikuwapo huwa. ");
INSERT INTO swh1850_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abrahamu aliamini na kutumaini ingawa hali yenyewe ilikuwa bila matumaini, na hivyo amekuwa baba wa mataifa mengi kama Maandiko Matakatifu yasemavyo: “Wazao wako watakuwa wengi kama nyota!” ");
INSERT INTO swh1850_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Alikuwa mzee wa karibu miaka mia moja, lakini imani yake haikufifia ingawa alijua kwamba mwili wake ulikuwa kama umekufa, na pia mkewe, Sara, alikuwa tasa. ");
INSERT INTO swh1850_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abrahamu hakuionea mashaka ile ahadi ya Mungu; alipata nguvu kutokana na imani, akamtukuza Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Alijua kwamba Mungu anaweza kuyatekeleza yale aliyoahidi. ");
INSERT INTO swh1850_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndiyo maana Mungu alimkubali kuwa mwadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Inaposemwa, “Alimkubali,” haisemwi kwa ajili yake mwenyewe tu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Jambo hili linatuhusu sisi pia ambao tunamwamini Mungu aliyemfufua Yesu, Bwana wetu, kutoka wafu. ");
INSERT INTO swh1850_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yeye alitolewa auawe kwa ajili ya dhambi zetu, akafufuka ili tupate kukubaliwa kuwa waadilifu na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Sasa, kwa vile tumekubaliwa kuwa wadilifu kwa imani, basi, tunayo amani na Mungu kwa ajili ya Bwana wetu Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa imani yetu, yeye ametuleta katika hali hii ya neema ya Mungu ambamo sasa tunaishi. Basi, tunajivunia tumaini tulilo nalo la kushiriki utukufu wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Naam, si hayo tu, bali tunafurahi pia katika taabu tukijua kwamba taabu huleta saburi, ");
INSERT INTO swh1850_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nayo saburi huleta uthabiti, na uthabiti huleta tumaini. ");
INSERT INTO swh1850_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Tumaini hilo haliwezi kutuhadaa, maana Mungu amekwisha miminia mioyoni mwetu upendo wake kwa njia ya Roho Mtakatifu aliyetujalia. ");
INSERT INTO swh1850_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Tulipokuwa bado wanyonge, Kristo, wakati ulipotimia, alikufa kwa ajili yetu sisi waovu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Si rahisi mtu kufa kwa ajili ya mtu mwadilifu; labda mtu anaweza kuthubutu kufa kwa ajili ya mtu mwema. ");
INSERT INTO swh1850_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini Mungu amethibitisha kwamba anatupenda, maana wakati tulipokuwa bado wenye dhambi, Kristo alikufa kwa ajili yetu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwa kuwa sasa tumekubaliwa kuwa waadilifu kwa damu ya Kristo, ni dhahiri zaidi kwamba atatuokoa katika ghadhabu ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Maana, tulipokuwa bado adui zake, Mungu alitupatanisha naye kwa kifo cha Mwanae. Na kwa vile sasa tumepatanishwa naye, ni dhahiri zaidi kwamba tutaokolewa kwa uzima wa Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Wala si hayo tu, ila tunafurahi pia katika Mungu kwa njia ya Bwana wetu Yesu Kristo ambaye ametupatanisha na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kwa njia ya mtu mmoja dhambi iliingia ulimwenguni, nayo ikasababisha kifo. Hivyo kifo kimeenea katika jumuiya yote ya binadamu, kwa maana wote wametenda dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kabla ya Sheria kuwako, dhambi ilikuwako ulimwenguni; lakini dhambi haiwekwi katika kumbukumbu bila sheria. ");
INSERT INTO swh1850_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lakini tangu wakati wa Adamu mpaka wakati wa Mose, kifo kiliwatawala hata wale ambao hawakutenda dhambi kama ile ya Adamu, ya kumwasi Mungu. Adamu alikuwa kielelezo cha yule ambaye atakuja baadaye. ");
INSERT INTO swh1850_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini ipo tofauti: neema ya Mungu si kama dhambi ya Adamu. Maana, ingawa dhambi ya mtu mmoja ilisababisha kifo kwa wote, kwa fadhili ya mtu mmoja, yaani Yesu Kristo, Mungu amewazidishia wote neema na zawadi zake. ");
INSERT INTO swh1850_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kuna tofauti baina ya zawadi ya Mungu, na dhambi ya mtu yule mmoja. Maana, baada ya kosa la mtu mmoja, Mungu alitoa hukumu; lakini baada ya makosa ya watu wengi, Mungu aliwapa zawadi yake kwa kuwasamehe. ");
INSERT INTO swh1850_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kweli, kwa dhambi ya mtu mmoja kifo kilianza kutawala kwa sababu ya huyo mtu mmoja; lakini, ni dhahiri zaidi kwamba alichokifanya yule mtu mmoja, yaani Yesu Kristo, ni bora zaidi. Wote wanaopokea neema na zawadi hiyo ya kukubaliwa kuwa waadilifu, watatawala katika uzima kwa njia ya huyo mmoja, yaani Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Basi, kama vile kosa la mtu mmoja lilivyoleta hukumu kwa binadamu wote, kadhalika kitendo kimoja kiadilifu kinawapa uhuru na uzima. ");
INSERT INTO swh1850_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na kama kwa kutotii kwa mtu mmoja watu wengi walifanywa wenye dhambi, kadhalika kutii kwa mtu mmoja kutawafanya wengi wakubaliwe kuwa waadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Sheria ilitokea, ikasababisha kuongezeka kwa uhalifu; lakini pale dhambi ilipoongezeka, neema iliongezeka zaidi. ");
INSERT INTO swh1850_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Kama vile dhambi ilivyotawala kwa kifo, kadhalika neema inatawala kwa njia ya uadilifu, na kuleta uzima wa milele kwa njia ya Yesu Kristo Bwana wetu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tuseme nini basi? Je, twendelee kubaki katika dhambi ili neema ya Mungu iongezeke? ");
INSERT INTO swh1850_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Hata kidogo! Kuhusu dhambi sisi tumekufa—tutaendeleaje kuishi tena katika dhambi? ");
INSERT INTO swh1850_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Maana, mnajua kwamba sisi tuliobatizwa tukaungana na Kristo Yesu, tulibatizwa na kuungana na kifo chake. ");
INSERT INTO swh1850_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Tulipobatizwa tuliungana na kifo chake, tukazikwa pamoja naye, ili kama vile Kristo alivyofufuliwa kutoka wafu kwa kitendo kitukufu cha Baba, sisi pia tuweze kuishi maisha mapya. ");
INSERT INTO swh1850_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Maana, kama sisi tumeungana naye katika kufa kama yeye, vivyo hivyo tutaungana naye kwa kufufuliwa kutoka wafu kama yeye. ");
INSERT INTO swh1850_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tunajua kwamba utu wetu wa kale ulisulubiwa pamoja na Kristo, ili hali ya dhambi iharibiwe, tusiwe tena watumwa wa dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwa maana, mtu aliyekufa, amenasuliwa kutoka katika nguvu ya dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Basi, ikiwa tumekufa pamoja na Kristo, tunaamini kwamba tutaishi pia pamoja naye. ");
INSERT INTO swh1850_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Maana, tunajua kwamba Kristo amekwisha fufuliwa kutoka wafu na hafi tena; kifo hakimtawali tena. ");
INSERT INTO swh1850_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hivyo, kwa kuwa alikufa—mara moja tu—dhambi haina nguvu tena juu yake; na sasa anaishi maisha yake katika umoja na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hali kadhalika nanyi lazima mjione kuwa mmekufa kuhusu dhambi, lakini kama mnaoishi katika umoja na Mungu kwa njia ya Kristo Yesu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kwa hiyo, dhambi isiitawale tena miili yenu ambayo hufa, na hivyo kuzitii tamaa zake. ");
INSERT INTO swh1850_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Wala msitoe hata sehemu moja ya miili yenu iwe chombo cha kutenda uovu na dhambi. Badala yake, jitoleeni ninyi wenyewe kwa Mungu kama watu waliofufuliwa kutoka wafu; toeni nafsi zenu zote kwa Mungu kwa ajili ya uadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Maana, dhambi haitawatawala ninyi tena, kwani hamko chini ya Sheria, bali chini ya neema. ");
INSERT INTO swh1850_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Basi, tuseme nini? Je, tutende dhambi ati kwa sababu hatuko chini ya Sheria bali chini ya neema? Hata kidogo! ");
INSERT INTO swh1850_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mnajua kwamba mkijitolea ninyi wenyewe kama watumwa na kumtii fulani, mnakuwa kweli watumwa wake mtu huyo—au watumwa wa dhambi, na matokeo yake ni kifo, au wa utii, na matokeo yake ni kukubaliwa kuwa waadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ingawa mlikuwa watumwa wa dhambi zamani, sasa lakini—namshukuru Mungu—mmetii kwa moyo wote yale maazimio na mafundisho mliyopokea. ");
INSERT INTO swh1850_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mlikombolewa kutoka utumwa wa dhambi, mkawa watumwa wa uadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Hapa natumia lugha ya kawaida ya watu kwa sababu ya udhaifu wenu wenyewe.) Kama vile wakati fulani mlivyojitolea ninyi wenyewe kutumikia uchafu na uhalifu kwa ajili ya uovu, vivyo hivyo sasa jitoleeni nafsi zenu wenyewe kutumikia uadilifu kwa ajili ya utakatifu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Mlipokuwa watumwa wa dhambi, mlikuwa huru mbali na uadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Sasa, mlipata faida gani siku zile kutokana na mambo yale ambayo mnayaonea aibu sasa? Maana, matokeo ya mambo haya ni kifo! ");
INSERT INTO swh1850_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini sasa, mmekwisha kombolewa kutoka utumwa wa dhambi na mmekuwa watumishi wa Mungu; faida mliyo nayo sasa ni utakatifu, na matokeo yake ni uzima wa milele. ");
INSERT INTO swh1850_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwa maana mshahara wa dhambi ni kifo; lakini zawadi anayotoa Mungu ni uzima wa milele katika kuungana na Kristo Yesu, Bwana wetu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ndugu zangu, bila shaka mtaelewa yafuatayo, maana ninawazungumzia watu wanaojua Sheria. Sheria humtawala mtu wakati akiwa hai. ");
INSERT INTO swh1850_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mathalan: mwanamke aliyeolewa anafungwa na sheria muda wote mumewe anapokuw hai; lakini mumewe akifa, hiyo sheria haimtawali tena huyo mwanamke. ");
INSERT INTO swh1850_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Hivyo mwanamke huyo akiishi na mwanamume mwingine wakati mumewe yungali hai, ataitwa mzinzi; lakini mumewe akifa, mwanamke huyo yu huru kisheria, na akiolewa na mwanamume mwingine, yeye si mzinzi. ");
INSERT INTO swh1850_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Hali kadhalika ninyi ndugu zangu: ninyi pia mmekufa kuhusu Sheria kwa kuwa ninyi ni sehemu ya mwili wa Kristo; sasa mmekuwa wake yeye aliyefufuliwa kutoka wafu ili tupate kuzaa matunda mema kwa ajili ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Maana, tulipokuwa tukiishi kimaumbile tu, tamaa mbaya zikichochewa na Sheria, zilifanya kazi katika miili yetu, na kuchuma pato la kifo. ");
INSERT INTO swh1850_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lakini sasa tumekuwa huru kutoka vifungo vya Sheria, kwa sababu tumekufa kuhusu lile jambo lililotufanya sisi watumwa. Sasa tunatumikia kufuatana na maisha mapya ya Roho, na si kufuatana na hali ile ya kale ya Sheria iliyoandikwa. ");
INSERT INTO swh1850_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Je, tuseme basi, kwamba Sheria ni dhambi? Hata kidogo! Lakini bila Sheria, mimi nisingalijua dhambi ni kitu gani. Maana, nisingalijua ni nini hasa kutamani mabaya, kama Sheria isingalikuwa imesema: “Usitamani.” ");
INSERT INTO swh1850_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kwa kuitumia hiyo amri, dhambi ilipata fursa ya kuamsha kila aina ya tamaa mbaya ndani yangu. Maana, bila Sheria dhambi ni kitu kilichokufa. ");
INSERT INTO swh1850_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Wakati mmoja mimi nilikuwa hai mbali na Sheria; lakini amri ilipokuja, dhambi ilifufuka, ");
INSERT INTO swh1850_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nami nikafa. Hiyo amri ambayo shabaha yake ilikuwa kuleta uhai, kwangu imeleta kifo. ");
INSERT INTO swh1850_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Maana, dhambi ilichukua fursa iliyopatiwa na amri hiyo, ikanidanganya na kuniua. ");
INSERT INTO swh1850_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Basi, Sheria yenyewe ni takatifu, na amri yenyewe ni takatifu, ni ya haki na nzuri. ");
INSERT INTO swh1850_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Je, hii inamaanisha kwamba kile kilicho kizuri kimesababisha kifo changu? Hata kidogo! Iliyo ni kwamba, dhambi, ili ionekane dhahiri kuwa ni dhambi, imekitumia kile kilicho kizuri na kusababisha kifo changu. Hivyo dhambi, kwa njia ya ile amri, ilijionyesha kikamilifu jinsi ilivyo mbaya mno. ");
INSERT INTO swh1850_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tunajua kwamba Sheria ni ya kiroho, lakini mimi ni wa kidunia, mimi nimeuzwa kuwa mtumwa wa dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sielewi nifanyacho, maana kile ninachotaka sikifanyi, bali kile ninachochukia ndicho nikifanyacho. ");
INSERT INTO swh1850_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ikiwa basi, ninatenda kinyume cha matakwa yangu, hii inamaanisha kwamba nakubali kuwa ile Sheria ni nzuri. ");
INSERT INTO swh1850_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Basi, si mimi hasa ninayefanya kitu hicho, bali ile dhambi iliyo ndani yangu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Najua kwamba hamna jema lolote ndani yangu mimi, kadiri ya ubinadamu wangu. Kwa maana, ingawa nataka kufanya jambo jema, siwezi kulitekeleza. ");
INSERT INTO swh1850_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Yaani, badala ya kufanya lile jambo jema ninalotaka, nafanya lile baya nisilotaka. ");
INSERT INTO swh1850_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Basi, kama ninafanya kinyume cha matakwa yangu, hii inamaanisha kwamba si mimi ninayefanya hayo, bali ni ile dhambi iliyo ndani yangu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Basi, nimegundua kanuni hii: ninataka kufanya jema, lakini najikuta kwamba lile lililo baya ndilo ninalochagua. ");
INSERT INTO swh1850_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ndani kabisa katika moyo wangu naifurahia sheria ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lakini naona kwamba kuna sheria nyingine inayofanya kazi mwilini mwangu, sheria ambayo inapingana na ile inayokubaliwa na akili yangu. Hiyo inanifanya niwe mtumwa wa sheria ya dhambi ifanyayo kazi mwilini mwangu. ");
INSERT INTO swh1850_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Maskini miye! Nani atakayeniokoa kutoka katika mwili huu unaonipeleka kifoni? ");
INSERT INTO swh1850_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Shukrani kwa Mungu afanyaye hayo kwa njia ya Bwana wetu Yesu Kristo! Hii basi, ndiyo hali yangu: mimi binafsi, kwa akili yangu, ninaitumikia sheria ya dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kwa hiyo, sasa hakuna hukumu kwa wale ambao katika maisha yao wameungana na Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Maana, sheria ya Roho iletayo uzima kwa kuungana na Kristo Yesu imenikomboa kutoka katika sheria ya dhambi na kifo. ");
INSERT INTO swh1850_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mungu ametekeleza jambo lile ambalo Sheria haikuweza kutekeleza kwa sababu ya udhaifu w binadamu. Mungu alimtuma Mwanae akiwa mwenye mwili sawa na miili yetu sisi wenye dhambi, ili aikabili dhambi, na kwa mwili huo akaiangamiza dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Mungu alifanya hivyo kusudi matakwa ya haki ya Sheria yatekelezwe kikamilifu ndani yetu sisi ambao tunaishi, si kwa nguvu za kibinadamu, bali kwa nguvu ya Roho. ");
INSERT INTO swh1850_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Maana, wale wanaoishi kufuatana na matakwa ya mwili, hutawaliwa na fikira za mwili. Lakini wale wanaoishi kufuatana na matakwa ya Roho Mtakatifu, hutawaliwa na fikira za Roho. ");
INSERT INTO swh1850_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Fikira za mwili huleta kifo; fikira za Roho huleta uzima na amani. ");
INSERT INTO swh1850_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Maana, mwenye kutawaliwa na fikira za mwili ni adui wa Mungu; haitii sheria ya Mungu, wala hawezi kuitii. ");
INSERT INTO swh1850_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Watu wanaotii matakwa ya mwili hawawezi kumpendeza Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Lakini ninyi hamuishi kufuatana na matakwa ya mwili, bali kufuatana na matakwa ya Roho, ikiwa Roho wa Mungu anaishi ndani yenu. Yeyote asiye na Roho wa Kristo, huyo si wake Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Lakini kama Kristo yumo ndani yenu, ingawa miili yenu itakufa kwa sababu ya dhambi, kwenu Roho ndiye uhai kwa sababu mmekubaliwa kuwa waadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ikiwa Roho wa Mungu aliyemfufua Kristo kutoka wafu anaishi ndani yenu, basi huyo aliyemfufua Kristo kutoka wafu ataipa uzima miili yenu yenye hali ya kufa; atafanya hivyo kwa njia ya Roho wake akaaye ndani yenu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Hivyo basi, ndugu zangu, tunalo jukumu, lakini si la kuishi kufuatana na maumbile ya kibinadamu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kwa maana, kama mkiishi kufuatana na matakwa ya maumbile ya kibinadamu, hakika mtakufa. Lakini, kama kwa njia ya Roho mnayaua matendo yenu maovu, basi, mtaishi. ");
INSERT INTO swh1850_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Wote wanaoongozwa na Roho wa Mungu ni watoto wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwa maana, Roho mliyempokea si Roho mwenye kuwafanya ninyi watumwa na kuwatia tena hofu; sivyo, bali mmempokea Roho mwenye kuwafanya ninyi watoto wa Mungu, na kwa nguvu ya huyo Roho, sisi tunaweza kumwita Mungu, “Aba,” yaani “Baba!” ");
INSERT INTO swh1850_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Naye Roho mwenyewe anajiunga na roho zetu na kuthibitisha kwamba sisi ni watoto wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Basi, kwa vile sisi ni watoto wa Mungu, tutapokea baraka zote Mungu alizowawekea watu wake, na tutashiriki urithi huo pamoja na Kristo; maana, tukiyashiriki mateso yake Kristo, tutaushiriki pia utukufu wake. ");
INSERT INTO swh1850_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Naona kuwa mateso ya wakati huu wa sasa si kitu kamwe kama tukiyafananisha na ule utukufu utakaodhihirishwa kwetu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Viumbe vyote vinatazamia kwa hamu Mungu awadhihirishe watoto wake. ");
INSERT INTO swh1850_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwa maana, viumbe viliwekwa katika hali ya kutojiweza kabisa, si kwa hiari yao, ila vilifanywa hivyo kwa mapenzi ya Mungu. Hata hivyo yapo matumaini, ");
INSERT INTO swh1850_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","maana hivyo viumbe navyo vitaokolewa kutoka katika utumwa wa uharibifu, vishiriki uhuru mtukufu wa watoto wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwa maana tunajua kwamba mpaka hivi sasa, viumbe vyote vinalia kwa maumivu kama ya kujifungua mtoto. ");
INSERT INTO swh1850_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Wala si hivyo viumbe peke yake, bali hata sisi tulio na huyo Roho, aliye wa kwanza wa zawadi za Mungu; sisi pia tunalalamika ndani yetu, tukitazamia kufanywa watoto wa Mungu, nazo nafsi zenu zikombolewe. ");
INSERT INTO swh1850_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Maana kwa matumaini hayo sisi tumekombolewa; lakini tumaini halina maana ikiwa tunakiona kile tunachotumainia. Maana ni nani anayetumaini kile ambacho tayari anakiona? ");
INSERT INTO swh1850_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kama tunakitumaini kile ambacho hatujakiona bado, basi, tunakingojea kwa uvumilivu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hali kadhalika, naye Roho anatusaidia katika udhaifu wetu. Maana hatujui inavyotupasa kuomba; lakini Roho mwenyewe anatuombea kwa Mungu kwa mlio wa huzuni usioelezeka. ");
INSERT INTO swh1850_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Naye Mungu aonaye mpaka ndani ya mioyo ya watu, anajua fikira ya huyo Roho; kwani huyo Roho huwaombea watu wa Mungu kufuatana na mapenzi ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tunajua kwamba, katika mambo yote, Mungu hufanya kazi na kuifanikisha pamoja na wote wampendao, yaani wale aliowaita kufuatana na kusudi lake. ");
INSERT INTO swh1850_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Maana hao aliowachagua tangu mwanzo, ndio aliowateua wapate kufanana na Mwanae, ili Mwana awe wa kwanza miongoni mwa ndugu wengi. ");
INSERT INTO swh1850_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Basi, Mungu aliwaita wale aliokuwa amewateua; na hao aliowaita aliwakubali kuwa waadilifu; na hao aliowakubali kuwa waadilifu aliwashirikisha pia utukufu wake. ");
INSERT INTO swh1850_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kutokana na hayo, tuseme nini zaidi? Ikiwa Mungu yuko upande wetu, nani awezaye kutupinga? ");
INSERT INTO swh1850_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Mungu hakumhurumia hata mwanae wa pekee, bali alimtoa kwa ajili yetu sisi sote. Ikiwa amefanya hivyo, je, hatatujalia pia mema yote? ");
INSERT INTO swh1850_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ni nani atakayewashtaki wateule wa Mungu? Mungu mwenyewe huwaondolea hatia! ");
INSERT INTO swh1850_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ni nani atakayewahukumu? Hakuna! Maana Kristo ndiye aliyekufa, tena alifufuka kutoka wafu na anakaa upande wa kulia wa Mungu. Yeye anatuombea! ");
INSERT INTO swh1850_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ni nani awezaye kututenga na mapendo ya Kristo? Je, ni taabu, au dhiki, au mateso, au njaa, au ukosefu wa nguo, au hatari, au kuuawa? ");
INSERT INTO swh1850_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kama Maandiko Matakatifu yasemavyo: “Kwa ajili yako, twakikabili kifo kutwa kucha: tunatendewa kama kondoo wa kuchinjwa.” ");
INSERT INTO swh1850_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Lakini, katika mambo haya yote, tumepata ushindi mkubwa kwa msaada wake yeye aliyetupenda. ");
INSERT INTO swh1850_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Maana ninajua hakika kwamba hakuna kitu kiwezacho kututenganisha na upendo wake: wala kifo, wala uhai; wala malaika, au nguvu nyingine za mbinguni; wala yanayotokea sasa, wala yatakayotokea baadaye; wala mamlaka; ");
INSERT INTO swh1850_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Wala ulimwengu wa juu, wala wa chini kabisa. Hakuna kiumbe chochote kitakachoweza kututenga na upendo wa Mungu kwetu kwa njia ya Kristo Yesu Bwana wetu. ");
INSERT INTO swh1850_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nasema ukweli mtupu; nimeungana na Kristo nami sisemi uongo. Dhamiri yangu ikiongozwa na Roho Mtakatifu inanithibitishia jambo hili pia. ");
INSERT INTO swh1850_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nataka kusema hivi: nina huzuni kubwa na maumivu yasiyopimika moyoni mwangu ");
INSERT INTO swh1850_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","kwa ajili ya watu wangu, walio damu moja nami! Kama ingekuwa kwa faida yao, ningekuwa radhi kulaaniwa na kutengwa na Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Hao ndio watu wa Israeli ambao Mungu aliwateua wawe watoto wake, akawashirikisha utukufu wake; aliagana nao, akawapa Sheria yake, imani ya kweli na ahadi zake. ");
INSERT INTO swh1850_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Wao ni wajukuu wa mababu, naye Kristo, kadiri ya ubinadamu wake, ametoka katika ukoo wao. Mungu atawalaye juu ya yote, na atukuzwe milele! Amina. ");
INSERT INTO swh1850_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Sisemi kwamba ahadi ya Mungu imebatilika; maana si watu wote wa Israeli ni wateule wa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Wala, si wazawa wote wa Abrahamu ni watoto wake wa kweli. Ila, kama yasemavyo Maandiko Matakatifu: “Wazao wake watatokana na Isaka.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nido kusema, wale waliozaliwa kimaumbile ndio watoto wa Mungu, bali wale waliozaliwa kutokana na ahadi ya Mungu ndio watakaoitwa watoto wake. ");
INSERT INTO swh1850_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Maana ahadi yenyewe ni hii: “Nitakujia wakati maalum, naye Sara atapata mtoto.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Tena si hayo tu ila pia Rebeka naye alipata mapacha kwa baba mmoja, yaani Isaka, babu yetu. ");
INSERT INTO swh1850_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Lakini, ili Mungu aonekane kwamba anao uhuru wa kuchagua, hata kabla wale ndugu hawajazaliwa na kabla hawajaweza kupambanua jema na baya, ");
INSERT INTO swh1850_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Rebeka aliambiwa kwamba yule mtoto wa kwanza atamtumikia yule wa nyuma. Hivyo uchaguzi wa Mungu unategemea jinsi anavyoita mwenyewe, na si matendo ya binadamu. ");
INSERT INTO swh1850_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kama Maandiko Matakatifu yasemavyo: “Yakobo nilimpenda, lakini Esau nilimchukia.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Basi, tuseme nini? Je, Mungu amekosa haki? Hata kidogo! ");
INSERT INTO swh1850_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Maana alimwambia Mose: “Nitamhurumia mtu yeyote ninayetaka kumhurumia; nitamwonea huruma mtu yeyote ninayetaka.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kwa hiyo, yote hutegemea huruma ya Mungu, na si bidii au mapenzi ya mtu. ");
INSERT INTO swh1850_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Maana Maandiko Matakatifu yasema hivi kwa Farao: “Nilikufanya mfalme ili kwa njia yako, uwezo wangu ujulikane, na jina langu litangazwe popote duniani.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ni wazi, basi, kwamba Mungu humhurumia yeyote anayetaka kumhurumia, na akipenda kumfanya mtu awe mkaidi, hufanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Labda utaniuliza: “Ikiwa mambo yako hivyo, Mungu anawezaje kumlaumu mtu? Nani awezaye kuyapinga mapenzi yake?” ");
INSERT INTO swh1850_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Lakini, ewe binadamu, u nani hata uthubutu kumhoji Mungu? Je, chungu chaweza kumwuliza mfinyanzi wake: “Kwa nini umenitengeneza namna hii?” ");
INSERT INTO swh1850_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mfinyanzi anaweza kuutumia udongo apendavyo na kufinyanga vyungu viwili kwa udongo uleule; kimoja kwa matumizi ya heshima, na kingine kwa matumizi ya kawaida. ");
INSERT INTO swh1850_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Hivyo ndivyo ilivyo kwa Mungu. Alitaka kuonyesha ghadhabu yake na kujulisha uwezo wake, Basi, alikuwa na saburi sana, akiwavumilia wale ambao walikuwa lengo la ghadhabu yake, ambao walistahili kuangamizwa. ");
INSERT INTO swh1850_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Alitaka pia kudhihirisha wingi wa utukufu wake ambao alitumiminia sisi tulio lengo la huruma yake; sisi ambao alikwisha kututayarisha kuupokea utukufu wake. ");
INSERT INTO swh1850_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Maana sisi ndio hao aliowaita, si tu kutoka miongoni mwa Wayahudi bali pia kutoka kwa watu wa mataifa mengine. ");
INSERT INTO swh1850_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Maana ndivyo asemavyo katika kitabu cha Hosea: “Wale waliokuwa Si watu wangu nitawaita: Watu wangu! Naye Sikupendi ataitwa: Mpenzi wangu! ");
INSERT INTO swh1850_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na pale walipoambiwa: Ninyi si wangu hapo wataitwa: Watoto wa Mungu hai.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Naye nabii Isaya, kuhusu Israeli anapaaza sauti: “Hata kama watoto wa Israeli ni wengi kama mchanga wa pwani, ni wachache tu watakaookolewa; ");
INSERT INTO swh1850_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","maana, Bwana ataitekeleza upesi hukumu yake kamili juu ya ulimwengu wote.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ni kama Isaya alivyosema hapo awali: “Kama Bwana Mwenye Nguvu asingalituachia baadhi ya watoto wa Israeli, tungalikwisha kuwa kama Sodoma, tungalikwisha kuwa ma Gomora.” ");
INSERT INTO swh1850_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Basi, tuseme nini? Ni hivi: watu wa mataifa ambao hawakutafuta kukubaliwa kuwa waadilifu, wamekubaliwa kuwa waadilifu kwa njia ya imani, ");
INSERT INTO swh1850_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","hali watu wa Israeli waliokuwa wakitafuta Sheria iletayo kukubaliwa kuwa waadilifu, hawakuipata. ");
INSERT INTO swh1850_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kwa nini? Kwa sababu walitegemea matendo yao badala ya kutegemea imani. Walijikwaa juu ya jiwe la kujikwaa ");
INSERT INTO swh1850_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kama yesemavyo Maandiko Matakatifu: “Tazama! Naweka huko Sioni jiwe likwazalo, mwamba utakaowafanya watu waanguke. Mtu atakayemwamini yeye aliye hilo jiwe, hataaibishwa!” ");
INSERT INTO swh1850_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ndugu zangu, ninataka na kutazamia kwa moyo wangu wote hao wananchi wenzangu wakombolewe. Tena nawaombea kwa Mungu daima. ");
INSERT INTO swh1850_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Maana naweza kuthibitisha kwa niaba yao kwamba wanayo bidii ya kumtafuta Mungu; lakini bidii hiyo haikujengwa juu ya ujuzi wa kweli. ");
INSERT INTO swh1850_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Maana hawakufahamu jinsi Mungu anavyowafanya watu wawe waadilifu, na wamejaribu kuanzisha mtindo wao wenyewe, na hivyo hawakuikubali njia hiyo ya Mungu ya kuwafanya wawe waadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Maana kwa kuja kwake Kristo, Sheria imefikia kikomo chake, ili kila mtu anayeamini akubaliwe kuwa mwadilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Kuhusu kukubaliwa kuwa mwadilifu kwa kuitii Sheria, Mose aliandika hivi: “Mtu yeyote anayetimiza matakwa ya Sheria ataishi.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lakini, kuhusu kukubaliwa kuwa mwadilifu kwa njia ya imani, yasemwa hivi: “Usiseme moyoni mwako: Nani atapanda mpaka mbinguni? (yaani, kumleta Kristo chini); ");
INSERT INTO swh1850_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","wala usiseme: Nani atashuka mpaka Kuzimu (yaani, kumleta Kristo kutoka kwa wafu).” ");
INSERT INTO swh1850_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Maandiko Matakatifu yesema hivi, “Ujumbe huo wa Mungu uko karibu nawe, uko kinywani mwako na moyoni mwako” nao ndio ile imani tunayoihubiri. ");
INSERT INTO swh1850_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kama ukikiri kwa kinywa chako kwamba Yesu ni Bwana na kuamini moyoni mwako kwamba Mungu alimfufua kutoka wafu, utaokoka. ");
INSERT INTO swh1850_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Maana tunaamini kwa moyo na kukubaliwa kuwa waadilifu; na tunakiri kwa midomo yetu na kuokolewa. ");
INSERT INTO swh1850_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Maandiko Matakatifu yasema: “Kila amwaminiye hatakuwa na sababu ya kuaibika.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Jambo hili ni kwa wote, kwani hakuna tofauti kati ya Wayahudi na wasio Wayahudi; Bwana wa wote ni mmoja, naye ni mkarimu sana kwao wote wamwombao. ");
INSERT INTO swh1850_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Maana Maandiko Matakatifu yasema: “Kila mtu atakayeomba kwa jina la Bwana, ataokolewa.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Basi, watamwombaje yeye ambaye hawamwamini? Tena, watamwaminije kama hawajapata kusikia habari zake? Na watasikiaje habari zake kama hakuna mhubiri? ");
INSERT INTO swh1850_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na watu watahubirije kama hawakutumwa? Kama yasemavyo Maandiko Matakatifu: “Ni jambo la kupendeza mno kuja kwa wale wanaohubiri Habari Njema!” ");
INSERT INTO swh1850_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lakini wote hawakuipokea hiyo Habari Njema. Maana Isaya alisema: “Bwana, ni nani aliyeamini ujumbe wetu?” ");
INSERT INTO swh1850_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hivyo basi, imani inatokana na kuusikiliza ujumbe, na huo ujumbe unatokana na neno la Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lakini nauliza: je, hawakuusikia huo ujumbe? Naam, waliusikia; kama Maandiko Matakatifu yasemavyo: “Sauti yao imeenea duniani kote; maneno yao yamefika mpaka kingo za ulimwengu.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Tena nauliza: je, yawezekana kwamba watu wa Israeli hawakufahamu? Mose mwenyewe ni kwa kwanza kujibu: “Nitawafanyeni mwaonee wivu watu ambao si taifa; nitawafanyeni muwe na hasira juu ya taifa la watu wapumbavu.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Tena Isaya anathubutu hata kusema: “Wale ambao hawakunitafuta wamenipata; nimejionyesha kwao wasiouliza habari zangu.” ");
INSERT INTO swh1850_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lakini kuhusu Israeli anasema: “Mchana kutwa niliwanyoshea mikono yangu watu waasi na wasiotii.” ");
INSERT INTO swh1850_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Basi, nauliza: je, Mungu amewakataa watu wake? Hata kidogo! Mini binafsi ni Mwisraeli mzawa wa Abrahamu, wa kabila la Benyamini. ");
INSERT INTO swh1850_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Mungu hakuwakataa watu wake aliowateua tangu mwanzo. Mnakumbuka yasemavyo Maandiko Matakatifu juu ya Eliya wakati alipomnung'unikia Mungu kuhusu Israeli: ");
INSERT INTO swh1850_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Bwana, wamewaua manabii wako na kubomoa madhabahu yako. Ni mimi tu peke yangu niliyebaki, nao wanataka kuniua?” ");
INSERT INTO swh1850_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Je, Mungu alimjibu nini? Alimwambia: “Nimejiwekea elfu saba ambao hawakumwabudu Baali.” ");
INSERT INTO swh1850_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Basi, ndivyo ilivyo pia wakati huu wa sasa: ipo idadi ya waliobaki ambao Mungu aliwateua kwa sababu ya neema yake. ");
INSERT INTO swh1850_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Uteuzi wake unatokana na neema yake, na si kwa sababu ya matendo yao. Maana, kama uteuzi wake ungetegemea matendo ya watu, neema yake haingekuwa neema tena. ");
INSERT INTO swh1850_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Sasa, je? Watu wa Israeli hawakukipata kile walichokuwa wanakitafuta; lakini wote walioteuliwa walikipata. Wengine walipumbazwa, ");
INSERT INTO swh1850_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","kama yasemavyo Maandiko Matakatifu: “Mungu ameifanya mioyo yao kuwa mizito, na mpaka leo hii hawawezi kuona kwa macho yao wala kusikia kwa masikio yao.” ");
INSERT INTO swh1850_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Naye Daudi anasema: “Karamu zao na ziwe mtego wa kuwanasa, waanguke na kuadhibiwa. ");
INSERT INTO swh1850_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Macho yao yatiwe giza wasiweze kuona. Migongo yao ipindike kwa taabu daima!” ");
INSERT INTO swh1850_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Basi, nauliza: je, Wayahudi wamejikwaa hata wakaangamia kabisa? Hata kidogo! Kutokana na kosa lao ukombozi umewajia watu wa mataifa mengine, ili Wayahudi wapate kuwaonea wivu. ");
INSERT INTO swh1850_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Kosa la Wayahudi limesababisha baraka nyingi kwa ulimwengu, na utovu wao kwa kiroho umeleta baraka nyingi kwa watu wa mataifa mengine. Basi, ni dhahiri zaidi kwamba utimilifu wao utasababisha baraka nyingi zaidi. ");
INSERT INTO swh1850_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Basi, sasa nawaambieni ninyi watu wa mataifa mengine: Maadamu mimi nimekuwa mtume kwa watu wa mataifa mengine, ninajivunia huduma yangu, ");
INSERT INTO swh1850_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","nipate kuwafanya wananchi wenzangu wawaonee ninyi wivu, na hivyo nipate kuwaokoa baadhi yao. ");
INSERT INTO swh1850_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Maana ikiwa kukataliwa kwao kulisababisha ulimwengu upatanishwe na Mungu, itakuwaje wakati watakapokubaliwa na Mungu? Wafu watafufuka! ");
INSERT INTO swh1850_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ikiwa kipande cha kwanza cha mkate kimewekwa wakfu, mkate wote umewekwa wakfu; mizizi ya mti ikiwa mizuri, na matawi yake huwa mazuri pia. ");
INSERT INTO swh1850_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Naam, baadhi ya matawi ya mzeituni bustanini yalikatwa, na mahali pake tawi la mzeituni mwitu likapandikizwa. Ninyi watu wa mataifa mengine ndio hilo tawi la mzeituni mwitu; na sasa mnashiriki nguvu na utomvu wa mzeituni bustanini. ");
INSERT INTO swh1850_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Basi, msiwadharau wale waliokatwa kama matawi! Na, hata kama kuna la kujivunia, kumbukeni kwamba si ninyi mnaoitegemeza mizizi, bali mizizi ndiyo inayowategemeza ninyi. ");
INSERT INTO swh1850_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Lakini utasema: “Matawi yalikatwa kusudi mimi nipandikizwe mahali pake.” ");
INSERT INTO swh1850_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Sawa! Yalikatwa kwa sababu ya kukosa imani, bali wewe unasimama kwa imani yako. Lakini usijivune; ila uwe na tahadhari. ");
INSERT INTO swh1850_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kwa maana, ikiwa Mungu hakuwahurumia Wayahudi ambao ni kama matawi ya asili, je, unadhani atakuhurumia wewe? ");
INSERT INTO swh1850_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kumbuka, basi, jinsi Mungu alivyo mwema na mkali. Yeye ni mkali kwa wale walioanguka, na ni mwema kwako wewe ikiwa utaendelea katika wema wake; la sivyo, nawe pia utakatwa. ");
INSERT INTO swh1850_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Nao Wayahudi, hali kadhalika; wakiacha utovu wao wa imani, watapandikizwa tena. Maana Mungu anao uwezo wa kuwapandikiza tena. ");
INSERT INTO swh1850_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ninyi watu wa mataifa mengine, kwa asili ni kama tawi la mzeituni mwitu, lakini mmeondolewa huko, mkapandikizwa katika mzeituni bustanini mahali ambapo kwa asili si penu. Lakini, Wayahudi kwa asili ni kama mzeituni bustanini, na itakuwa jambo rahisi zaidi kwao kupandikizwa tena katika mti huohuo wao. ");
INSERT INTO swh1850_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ndugu zangu, napenda mjue ukweli huu uliofichika msije mkajiona wenye akili sana. Ukaidi wa Wayahudi ulikuwa ni wa muda tu, mpaka watu wa mataifa mengine watakapokuwa wamemfikia Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hapo ndipo taifa lote la Israeli litakapookolewa, kama yesemavyo Maandiko Matakatifu: “Mkombozi atakuja kutoka Sioni, atauondoa uovu wa Yakobo. ");
INSERT INTO swh1850_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Hili ndilo agano nitakalofanya nao wakati nitakapoziondoa dhambi zao.” ");
INSERT INTO swh1850_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwa sababu wanaikataa Habari Njema, Wayahudi wamekuwa adui wa Mungu, lakini kwa faida yenu nyinyi watu wa mataifa. Lakini, kwa kuwa waliteuliwa, bado ni rafiki wa Mungu kwa sababu ya baba zao. ");
INSERT INTO swh1850_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Maana Mungu akisha wapa watu zawadi zake na kuwateua, hajuti kwamba amefanya hivyo. ");
INSERT INTO swh1850_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Hapo awali ninyi mlikuwa mmemwasi Mungu, lakini sasa mmepata huruma yake kutokana na kuasi kwao. ");
INSERT INTO swh1850_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Hali kadhalika, kutokana na huruma mliyojaliwa ninyi, Wayahudi wanamwasi Mungu sasa ili nao pia wapokee sasa huruma ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Maana Mungu amewafunga watu wote katika uasi wao ili wapate kuwahurumia wote. ");
INSERT INTO swh1850_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Utajiri, hekima na elimu ya Mungu ni kuu mno! Huruma zake hazichunguziki, na njia zake hazieleweki! Kama yasemavyo Maandiko Matakatifu: ");
INSERT INTO swh1850_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Nani aliyepata kuyajua mawazo ya Bwana? Nani awezaye kuwa mshauri wake? ");
INSERT INTO swh1850_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Au, nani aliyempa yeye kitu kwanza hata aweze kulipwa tena kitu hicho?” ");
INSERT INTO swh1850_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwa maana vitu vyote vyatoka kwake, vyote vipo kwa uwezo wake na kwa ajili yake. Utukufu na uwe kwake hata milele! Amina. ");
INSERT INTO swh1850_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kwa hiyo, ndugu zangu, maadam Mungu ni mwenye huruma nyingi, nawasihi kwa moyo wote: jitoleeni nafsi zenu kwa Mungu kama tambiko iliyo hai, takatifu na yenye kupendeza. Hii ndiyo njia yenu halisi ya kumwabudu. ");
INSERT INTO swh1850_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Msiige mitindo ya ulimwengu huu, bali Mungu afanye mabadiliko ndani yenu kwa kuzigeuza fikira zenu. Hapo ndipo mtakapoweza kuyajua mapenzi ya Mungu, kutambua jambo lililo jema, linalompendeza na kamilifu. ");
INSERT INTO swh1850_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kutokana na neema aliyonijalia Mungu, nawaambieni ninyi nyote: msijione kuwa ni kitu zaidi kuliko mnavyopaswa kuwa. Fikira zenu na ziwe na kiasi kufuatana na kipimo cha imani Mungu aliyomgawia kila mmoja. ");
INSERT INTO swh1850_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mwili una viungo vingi, kila kimoja na kazi yake. ");
INSERT INTO swh1850_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Hali kadhalika ingawa sisi ni wengi, tu mwili mmoja kwa kuungana na Kristo, na kila mmoja ni kiungo cha mwenzake. ");
INSERT INTO swh1850_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Basi, tunavyo vipaji mbalimbali kufuatana na neema tuliyopewa. Mwenye kipaji cha unabii na akitumie kadiri ya imani yake. ");
INSERT INTO swh1850_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Mwenye kipaji cha utumishi na atumikie. mwenye kipaji cha kufundisha na afundishe. ");
INSERT INTO swh1850_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Mwenye kipaji cha kuwafariji wengine na afanye hivyo. Mwenye kumgawia mwenzake alicho nacho na afanye hivyo kwa ukarimu. Msimamizi na asimamie kwa bidii; naye mwenye kutenda jambo la huruma na afanye hivyo kwa furaha. ");
INSERT INTO swh1850_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Mapendo yenu na yawe bila unafiki wowote. Chukieni jambo lolote ovu, zingatieni jema. ");
INSERT INTO swh1850_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Pendaneni kidugu; kila mmoja amfikirie mwenzake kwanza kwa heshima. ");
INSERT INTO swh1850_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Msilegee katika bidii, muwe wachangamfu rohoni katika kumtumikia Bwana. ");
INSERT INTO swh1850_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Tumaini lenu liwaweke daima wenye furaha; muwe na saburi katika shida na kusali daima. ");
INSERT INTO swh1850_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Wasaidieni watu wa Mungu katika mahitaji yao; wapokeeni wageni kwa ukarimu. ");
INSERT INTO swh1850_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Watakieni baraka wote wanaowadhulumu ninyi; naam, watakieni baraka na wala msiwalaani. ");
INSERT INTO swh1850_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Furahini pamoja na wanaofurahi, lieni pamoja na wanaolia. ");
INSERT INTO swh1850_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Muwe na wema uleule kwa kila mtu. Msijitakie makuu, bali jishugulisheni na watu wadogo. Msijione kuwa wenye hekima sana. ");
INSERT INTO swh1850_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Msilipe ovu kwa ovu. Zingatieni mambo mema mbele ya wote. ");
INSERT INTO swh1850_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Kadiri inavyowezekana kwa upande wenu, muwe na amani na watu wote. ");
INSERT INTO swh1850_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Wapenzi wangu, msilipize kisasi, bali mwachieni Mungu jambo hilo; maana Maandiko Matakatifu yasema: “Kulipiza kisasi ni shauri langu; mimi nitalipiza asema Bwana.” ");
INSERT INTO swh1850_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Tena, Maandiko yasema: “Adui yako akiwa na njaa, mpe chakula; akiwa na kiu, mpe kinywaji. Maana kwa kufanya hivyo utamfanya apate aibu kali kama makaa ya moto juu ya kichwa chake.” ");
INSERT INTO swh1850_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Usikubali kushindwa na ubaya, bali ushinde ubaya kwa wema. ");
INSERT INTO swh1850_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kila mtu anapaswa kuwatii wenye mamlaka katika serikali; maana mamlaka yote hutoka kwa Mungu; nao wenye mamlaka wamewekwa na Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Anayepinga mamlaka ya viongozi anapinga agizo la Mungu; nao wafanyao hivyo wanajiletea hukumu wenyewe, ");
INSERT INTO swh1850_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Maana, watawala hawasababishi hofu kwa watu wema, ila kwa watu wabaya. Basi, wataka usimwogope mtu mwenye mamlaka? Fanya mema naye atakusifu; ");
INSERT INTO swh1850_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","maana yeye ni mtumishi wa Mungu anayefanya kazi kwa faida yako. Lakini ukifanya mabaya, basi, huna budi kumwogopa, maana anao kweli uwezo wa kutoa adhabu. Yeye ni mtumishi wa Mungu na huitekeleza ghadhabu ya Mungu kwao watendao maovu. ");
INSERT INTO swh1850_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Kwa hiyo ni lazima kuwatii wenye mamlaka, si tu kwa sababu ya kuogopa ghadhabu ya Mungu, bali pia kwa sababu dhamiri inadai hivyo. ");
INSERT INTO swh1850_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kwa sababu hiyohiyo ninyi hulipa kodi; maana viongozi hao humtumikia Mungu ikiwa wanatimiza wajibu wao. ");
INSERT INTO swh1850_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Mpeni kila mtu haki yake; mtu wa ushuru, ushuru; wa kodi, kodi; na astahiliye heshima, heshima. ");
INSERT INTO swh1850_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Msiwe na deni kwa mtu yeyote, isipokuwa tu deni la kupendana. Ampendaye jirani yake ameitekeleza Sheria. ");
INSERT INTO swh1850_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Maana, amri hizi: “Usizini; Usiue; Usitamani;” na nyingine zote, zimo katika amri hii moja: “Mpende jirani yako kama unavyojipenda mwenyewe.” ");
INSERT INTO swh1850_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ampendaye jirani yake hamtendei vibaya. Basi, kwa mapendo Sheria yote hutimizwa. ");
INSERT INTO swh1850_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Zaidi ya hayo, ninyi mnajua tumo katika wakati gani: sasa ndio wakati wa kuamka usingizini; naam, wokovu wetu u karibu zaidi sasa kuliko wakati ule tulipoanza kuamini. ");
INSERT INTO swh1850_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Usiku unakwisha na mchana unakaribia. Basi, tutupilie mbali mambo yote ya giza, tukajitwalie silaha za mwanga. ");
INSERT INTO swh1850_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mwenendo wetu uwe wa adabu kama inavyostahili wakati wa mchana; tusiwe na ulafi na ulevi, uchafu na uasherati, ugomvi na wivu. ");
INSERT INTO swh1850_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Bwana Yesu Kristo awe vazi lenu; msishughulikie tena tamaa zenu za maumbile na kuziridhisha. ");
INSERT INTO swh1850_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Mkaribisheni kwenu mtu aliye dhaifu, lakini msibishane naye juu ya mawazo yake binafsi. ");
INSERT INTO swh1850_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Watu huhitilafiana: mmoja imani yake inamruhusu kula kila kitu; lakini mwingine ambaye imani yake ni dhaifu, hula tu mboga za majani. ");
INSERT INTO swh1850_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Mtu ambaye hula kila kitu asimdharau yule ambaye hawezi kula kila kitu; naye ambaye hula tu mboga za majani asimhukumu anayekula kila kitu, maana Mungu amemkubali. ");
INSERT INTO swh1850_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Wewe ni nani hata uthubutu kumhukumu mtumishi wa mwingine? Akisimama au akianguka ni shauri la Bwana wake; naam, atasimama imara, maana Bwana anaweza kumsimamisha. ");
INSERT INTO swh1850_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mtu anaweza kufikiria siku fulani kuwa ya maana zaidi kuliko nyingine; mtu mwingine aweza kuzifikiria siku zote kuwa sawa. Kila mmoja na afuate msimamo wa akili yake. ");
INSERT INTO swh1850_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Anayeadhimisha siku fulani anaadhimisha siku hiyo kwa ajili ya kumtukuza Mungu; naye anayekula chakula fulani anafanya hivyo kwa kumtukuza Bwana maana anamshukuru Mungu. Kadhalika naye anayeacha kula chakula fulani anafanya hivyo kwa ajili ya kumtukuza Bwana, naye pia anamshukuru Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Maana hakuna mtu yeyote miongoni mwetu aishiye kwa ajili yake mwenyewe, wala hakuna anayekufa kwa ajili yake mwenyewe ");
INSERT INTO swh1850_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","maana tukiishi twaishi kwa ajili ya Bwana; tukifa, tunakufa kwa ajili ya Bwana. Basi, kama tukiishi au tukifa, sisi ni mali yake Bwana. ");
INSERT INTO swh1850_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Maana Kristo alikufa, akafufuka ili wapate kuwa Bwana wa wazima na wafu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kwa nini, basi wewe wamhukumu ndugu yako? Nawe, kwa nini wamdharau ndugu yako? Sisi sote tutasimama mbele ya kiti cha hukumu cha Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Maana Maandiko yanasema: “Kama niishivyo, asema Bwana kila mtu atanipigia magoti, na kila mmoja atakiri kwamba mimi ni Mungu.” ");
INSERT INTO swh1850_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Kwa hiyo, kila mmoja wetu atatoa hoja yake mbele ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Basi, tuache kuhukumiana, bali tuazimie kutokuwa kamwe kikwazo kwa ndugu yetu au kumsababisha aanguke katika dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Katika kuungana na Bwana Yesu, nina hakika kwamba hakuna kitu chochote kilicho najisi kwa asili yake; lakini, mtu akidhani kwamba kitu fulani ni najisi, basi, kwake huwa najisi. ");
INSERT INTO swh1850_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kama ukimhuzunisha ndugu yako kwa sababu ya chakula unachokula, basi mwenendo wako hauongozwi na mapendo. Usikubali hata kidogo chakula chako kiwe sababu ya kupotea kwa mtu mwingine ambaye Kristo alikufa kwa ajili yake! ");
INSERT INTO swh1850_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Basi, msikubalie kitu mnachokiona kuwa kwenu ni kitu chema kidharauliwe. ");
INSERT INTO swh1850_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Maana Utawala wa Mungu si shauri la kula na kunywa, bali unahusika na kuwa na uadilifu, amani na furaha iletwayo na Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Anayemtumikia Kristo namna hiyo humpendeza Mungu, na kukubaliwa na watu. ");
INSERT INTO swh1850_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Kwa hiyo tuyazingatie daima mambo yenye kuleta amani, na yanayotusaidia kujengana. ");
INSERT INTO swh1850_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Basi, usiiharibu kazi ya Mungu kwa sababu ya ubishi juu ya chakula. Vyakula vyote ni halali, lakini haifai kula chakula ambacho kitamfanya mtu aanguke katika dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Afadhali kuacha kula nyama, kunywa divai, au kufanya chochote ambacho chaweza kumsababisha ndugu yako aanguke. ");
INSERT INTO swh1850_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Basi, shikilia unachoamini kati yako na Mungu wako. Heri mtu yule ambaye, katika kujiamulia la kufanya, haipingi dhamiri yake. ");
INSERT INTO swh1850_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Lakini mtu anayeona shaka juu ya chakula anachokula, anahukumiwa kama akila, kwa sababu msimamo wa kitendo chake haumo katika imani. Na, chochote kisicho na msingi wake katika imani ni dhambi. ");
INSERT INTO swh1850_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Sisi tulio imara katika imani tunapaswa kuwasaidia wale walio dhaifu wayakabili matatizo yao. Tusijipendelee sisi wenyewe tu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Kila mmoja wetu anapaswa kumpendeza jirani yake kwa wema ili huyo apate kujijenga katika imani. ");
INSERT INTO swh1850_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Maana Kristo hakujipendelea mwenyewe; ila alikuwa kama yasemavyo Maandiko: “Kashfa zote walizokutolea wewe zimenipata mimi.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Maana yote yalioandikwa yameandikwa kwa ajili ya kutufundisha sisi ili kutokana na saburi na faraja tupewayo na Maandiko hayo Matakatifu tupate kuwa na matumaini. ");
INSERT INTO swh1850_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Mungu aliye msingi wa saburi na faraja yote, awajalieni ninyi kuwa na msimamo mmoja kufuatana na mfano wake Kristo Yesu, ");
INSERT INTO swh1850_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ili ninyi nyote, kwa nia moja na sauti moja, mumtukuze Mungu, Baba wa Bwana wetu Yesu Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Basi, karibishaneni kwa ajili ya utukufu wa Mungu kama naye Kristo alivyowakaribisheni. ");
INSERT INTO swh1850_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Maana, nawaambieni Kristo aliwatumikia Wayahudi apate kuonyesha uaminifu wa Mungu, na zile ahadi Mungu alizowapa babu zetu zipate kutimia; ");
INSERT INTO swh1850_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ili nao watu wa mataifa mengine wapate kumtukuza Mungu kwa sababu ya huruma yake. Kama yasemavyo Maandiko Matakatifu: “Kwa sababu hiyo, nitakusifu miongoni mwa watu wa mataifa. Nitaziimba sifa za jina lako.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Tena Maandiko yasema: “Furahini, enyi watu wa mataifa; furahini pamoja na watu wake.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Na tena: “Enyi mataifa yote, msifuni Bwana; enyi watu wote, msifuni.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Tena Isaya asema: “Atatokea mtu katika ukoo wa Yese, naye atawatawala watu wa mataifa; nao watamtumainia.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Basi, Mungu aliye msingi wa matumaini, awajazeni furaha yote na amani kutokana na imani yenu; tumaini lenu lipate kuongezeka kwa nguvu ya Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ndugu zangu, mimi binafsi nina hakika kwamba ninyi pia mmejaa wema, elimu yote, na mnaweza kushauriana ninyi kwa ninyi. ");
INSERT INTO swh1850_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Lakini nimewaandikia hapa na pale katika barua hii bila woga, nipate kuwakumbusheni juu ya mambo fulani. Nimefanya hivyo kwa sababu ya neema aliyonijalia Mungu ");
INSERT INTO swh1850_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ya kuwa mtumishi wa Yesu Kristo kwa watu wa mataifa. Ni jukumu langu la kikuhani kuihubiri Habari Njema ya Mungu ili watu wa mataifa mengine wapate kuwa dhabihu inayokubaliwa na Mungu, dhabihu iliyotakaswa na Roho Mtakatifu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Kwa hiyo, nikiwa nimeungana na Kristo Yesu, naweza kujivunia huduma yangu kwa ajili ya Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Sithubutu kusema kitu kingine chochote isipokuwa tu kile ambacho Kristo Yesu amekifanya kwa kunitumia mimi ili watu wa mataifa wapate kutii. Amefanya hivyo kwa maneno na vitendo, ");
INSERT INTO swh1850_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kwa nguvu ya miujiza na maajabu, na kwa nguvu ya Roho wa Mungu. Basi, kwa kusafiri kila mahali, tangu kule Yerusalemu mpaka Iluriko, nimeihubiri kikamilifu Habari Njema ya Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Nia yangu imekuwa daima kuihubiri Habari Njema popote pale ambapo jina la Kristo halijapata kusikika, nisije nikajenga juu ya msingi wa mtu mwingine. ");
INSERT INTO swh1850_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kama yasemavyo Maandiko Matakatifu: “Watu wote ambao hawakuambiwa habari zote wataona; nao wale ambao hawajapata kusikia, wataelewa.” ");
INSERT INTO swh1850_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kwa sababu hiyo nilizuiwa mara nyingi kuja kwenu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Lakini maadam sasa nimemaliza kazi yangu pande hizi, na kwa kuwa kwa miaka mingi nimekuwa na nia kubwa ya kuja kwenu, ");
INSERT INTO swh1850_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","natumaini kufanya hivyo sasa. Ningependa kuwaoneni nikiwa safarini kwenda Spania na kupata msaada wenu kwa safari hiyo baada ya kufurahia kuwa kwa muda pamoja nanyi. ");
INSERT INTO swh1850_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Lakini, kwa sasa nakwenda kuwahudumia watu wa Mungu kule Yerusalem. ");
INSERT INTO swh1850_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maana makanisa ya Makedonia na Akaya yemeamua kutoka mchango wao kuwasaidia watu wa Mungu walio maskini huko Yerusalem. ");
INSERT INTO swh1850_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Wao wenyewe wameamua kufanya hivyo; lakini, kwa kweli, hilo ni jukumu lao kwa hao. Maana, ikiwa watu wa mataifa mengine wameshiriki baraka za kiroho za Wayahudi, wanapaswa nao pia kuwahudumia Wayahudi katika mahitaji yao ya kidunia. ");
INSERT INTO swh1850_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nitakapokwisha tekeleza kazi hiyo na kuwakabidhi mchango huo uliokusanywa kwa ajili yao, nitawatembeleeni ninyi nikiwa safarini kwenda Spania. ");
INSERT INTO swh1850_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Najua ya kuwa nikija kwenu nitawaletea wingi wa baraka za Kristo. ");
INSERT INTO swh1850_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Basi, ndugu zangu, nawasihi kwa kwa ajili ya Bwana wetu Yesu Kristo, na kwa ajili ya upendo uletwao na Roho, mniunge mkono kwa kuniombea kwa Mungu. ");
INSERT INTO swh1850_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ombeni nipate kutoka salama miongoni mwa wale wasioamini walioko Uyahudi, nayo huduma yangu huko Yerusalem ipate kukubaliwa na watu wa Mungu walioko huko. ");
INSERT INTO swh1850_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Hivyo, Mungu akipenda, nitaweza kuja kwenu na moyo wa furaha, nikapumzike pamoja nanyi. ");
INSERT INTO swh1850_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Mungu aliye chanzo cha amani na awe nanyi nyote! Amina! ");
INSERT INTO swh1850_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Napenda kumjulisha kwenu dada yetu Foibe ambaye ni mtumishi katika kanisa la Kenkrea. ");
INSERT INTO swh1850_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Mpokeeni kwa ajili ya Bwana kama iwapasavyo watu wa Mungu. Mpeni msaada wowote atakaohitaji kutoka kwenu, maana yeye amekuwa mwema sana kwa watu wengi na kwangu pia. ");
INSERT INTO swh1850_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Salamu zangu ziwafikie Priska na Akula, wafanyakazi wenzangu katika utumishi wa Kristo Yesu. ");
INSERT INTO swh1850_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Wao walihatarisha maisha yao kwa ajili yangu. Wanastahili shukrani; si tu kutoka kwangu, bali pia kutoka kwa makanisa yote ya watu wa mataifa mengine. ");
INSERT INTO sw