﻿USE sofia;
DROP TABLE IF EXISTS sofia.swessb_vpl;
CREATE TABLE swessb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swessb_vpl WRITE;
INSERT INTO swessb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ursprungsbok för Jesus Kristus, Davids son, Abrahams son: ");
INSERT INTO swessb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham avlade Isak, och Isak avlade Jakob, och Jakob avlade Juda och hans bröder. ");
INSERT INTO swessb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Och Juda avlade Peres och Sera ur Tamar. Och Peres avlade Hesron, och Hesron avlade Ram, ");
INSERT INTO swessb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","och Ram avlade Amminadab, och Amminadab avlade Nahshon, och Nahshon avlade Salmon. ");
INSERT INTO swessb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Och Salmon avlade Boas ur Rahab, och Boas avlade Obed ur Rut, och Obed avlade Ishai, ");
INSERT INTO swessb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","och Ishai avlade kung David. Och David avlade Salomo ur henne som var Urias. ");
INSERT INTO swessb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Och Salomo avlade Rehabeam, och Rehabeam avlade Abia, och Abia avlade Asa, ");
INSERT INTO swessb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","och Asa avlade Joshafat, och Joshafat avlade Joram, och Joram avlade Ussia, ");
INSERT INTO swessb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","och Ussia avlade Jotam, och Jotam avlade Ahas, och Ahas avlade Hiskia, ");
INSERT INTO swessb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","och Hiskia avlade Manasse, och Manasse avlade Amon, och Amon avlade Josia, ");
INSERT INTO swessb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","och Josia avlade Jekonja och hans bröder vid bortförandet till Babylon. ");
INSERT INTO swessb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Och efter bortförandet till Babylon avlade Jekonja Shealtiel, och Shealtiel avlade Serubbabel, ");
INSERT INTO swessb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","och Serubbabel avlade Abihud, och Abihud avlade Eljakim, och Eljakim avlade Asur, ");
INSERT INTO swessb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","och Asur avlade Sadok, och Sadok avlade Jakim, och Jakim avlade Elihud, ");
INSERT INTO swessb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","och Elihud avlade Eleasar, och Eleasar avlade Mattan, och Mattan avlade Jakob, ");
INSERT INTO swessb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","och Jakob avlade Josef, mannen till Maria. Ur henne föddes Jesus som kallas Kristus. ");
INSERT INTO swessb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Alltså är alla släktleden från Abraham till David fjorton släktled, och från David till Babylons bortförande fjorton släktled, och från Babylons bortförande till Kristus fjorton släktled. ");
INSERT INTO swessb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Och för Jesus Kristus var ursprunget så: när hans mor Maria var trolovad med Josef, innan de hade kommit samman, befanns hon havande i magen av helig Ande. ");
INSERT INTO swessb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Men Josef hennes man, som var rättfärdig och inte ville göra henne till ett exempel, beslöt sig för att i hemlighet förskjuta henne. ");
INSERT INTO swessb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Men när han tänkte på detta, se: en Herrens ängel i en dröm visade sig för honom och sade: ”Josef Davids son, du ska inte frukta att ta med dig Maria som din hustru. För det som är avlat i henne är av helig Ande. ");
INSERT INTO swessb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Och hon ska föda en son, och du ska kalla hans namn Jesus. För han ska frälsa sitt folk från deras synder.” ");
INSERT INTO swessb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Och det hela har hänt för att det skulle uppfyllas som var sagt av Herren genom profeten, som sade: ");
INSERT INTO swessb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Se: jungfrun ska vara havande i magen   och föda en son.   Och man ska kalla hans namn Immanuel, vilket är översatt: Med oss Gud. ");
INSERT INTO swessb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Och Josef reste sig från sömnen och gjorde som Herrens ängel förordnat för honom och tog med sig sin hustru. ");
INSERT INTO swessb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Och han kände henne inte ­förrän hon hade fött en son. Och han kallade hans namn Jesus. ");
INSERT INTO swessb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Men när Jesus var född i Betlehem i Judeen under kung Herodes dagar, se: mager från öst kom fram till Jerusalem ");
INSERT INTO swessb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","och sade: ”Var är han som är född judarnas kung? För vi har sett hans stjärna i Östern och har kommit för att tillbe honom.” ");
INSERT INTO swessb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Men när kung Herodes hörde det blev han oroad, och hela Jerusalem med honom. ");
INSERT INTO swessb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Och han samlade alla överstepräster och skriftlärda från folket och efterhörde från dem var Kristus föds. ");
INSERT INTO swessb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Och de sade till honom: ”I Betlehem i Judeen. För så är skrivet genom profeten: ");
INSERT INTO swessb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Och du, Betlehem i Juda land,  är ingalunda minst bland Juda styresmän.  För från dig ska det utgå en styrande  som ska vara herde för mitt folk Israel.”  ");
INSERT INTO swessb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Då kallade Herodes i hemlighet på magerna och preciserade från dem tiden för stjärnan som visade sig. ");
INSERT INTO swessb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Och han skickade dem till Betlehem och sade: ”Gå och hör er för noggrant om barnet. Och då ni funnit det, berätta för mig så att också jag kan komma och tillbe det.” ");
INSERT INTO swessb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Och de lyssnade till kungen och gick. Och se: stjärnan som de hade sett i Östern gick före dem, tills den kom och stod ovanför där barnet var. ");
INSERT INTO swessb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Och när de såg stjärnan, gladde de sig med mycket stor glädje. ");
INSERT INTO swessb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Och de gick in i huset och såg barnet med Maria dess mor, och de föll ner och tillbad honom. Och de öppnade sina skattgömmor och frambar till honom gåvor: guld och vit rökelse och myrra. ");
INSERT INTO swessb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Och sedan de fått uppenbarelse i en dröm att inte återvända till Herodes, drog de sig undan på en annan väg till sin trakt. ");
INSERT INTO swessb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Men när de hade dragit sig undan, se: en Herrens ängel visar sig i en dröm för Josef och säger: ”Res dig och ta med dig barnet och dess mor och fly till Egypten! Och var där tills jag säger till dig. För Herodes kommer att söka efter barnet för att förgöra det.” ");
INSERT INTO swessb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Och han reste sig och tog med sig barnet och dess mor i natten och drog sig undan till Egypten. ");
INSERT INTO swessb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Och han var där fram till Herodes frånfälle, för att det skulle uppfyllas som var sagt av Herren genom profeten, som sade: Ur Egypten kallade jag min son.  ");
INSERT INTO swessb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Då, när Herodes såg att han blivit förlöjligad av magerna, blev han väldigt rasande. Och han sände ut och avrättade alla gossarna i Betlehem och i hela dess område från två år och neråt, enligt den tid som han hade preciserat från magerna. ");
INSERT INTO swessb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Då uppfylldes det som var sagt genom profeten Jeremia, som sade: ");
INSERT INTO swessb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","En röst i Rama hördes,   gråt och stor klagan:   Rakel som grät över sina barn.   Och hon ville inte bli tröstad,   för de finns inte. ");
INSERT INTO swessb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Men när Herodes hade avlidit, se: en Herrens ängel visar sig i en dröm för Josef i Egypten ");
INSERT INTO swessb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","och säger: ”Res dig och ta med dig barnet och dess mor och res till Israels land. För de är döda, de som sökte barnets själ.” ");
INSERT INTO swessb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Och han reste sig och tog med sig barnet och hans mor och kom in i Israels land. ");
INSERT INTO swessb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Men när han hörde att Arkelaus regerar Judeen efter sin far Herodes, fruktade han för att gå bort dit. Och sedan han fått uppenbarelse i en dröm, drog han sig undan till Galileens trakter. ");
INSERT INTO swessb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Och han kom och bosatte sig i en stad som kallas Nasaret, för att det skulle uppfyllas som var sagt genom profeterna: att nasaréska han kal­las. ");
INSERT INTO swessb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Och i de dagarna kommer Johannes Döparen fram och förkunnar i Judeens ödemark ");
INSERT INTO swessb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","och säger: ”Ändra sinne! För himlarnas rike är nu nära.” ");
INSERT INTO swessb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","För denne är den som är sagd genom profeten Jesaja, som sade: Rösten av en som ropar i ödemarken:   Bered Herrens väg!   Gör hans stigar raka! ");
INSERT INTO swessb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Och själv hade Johannes sin klädsel av kamelhår och ett läderbälte om sin höft, och hans föda var gräshoppor och ­vildhonung. ");
INSERT INTO swessb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Då gick man ut till honom, Jerusalem och hela Judeen och hela trakten runt Jordan, ");
INSERT INTO swessb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","och de döptes i Jordanfloden av honom och erkände sina synder. ");
INSERT INTO swessb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Men när han såg många av fariseerna och saddukeerna komma till hans dop, sade han till dem: ”Huggormsyngel, vem har visat er att fly från den kommande vreden? ");
INSERT INTO swessb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gör då frukt värdig sinnesändringen. ");
INSERT INTO swessb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Och tänk er inte att säga inom er: Som far har vi Abraham. För jag säger er att Gud ur dessa stenar kan resa upp barn åt Abraham. ");
INSERT INTO swessb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Och redan ligger yxan mot trädens rot. Varje träd som inte gör fin frukt huggs alltså bort och kastas i eld. ");
INSERT INTO swessb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jag döper er i vatten till sinnesändring. Men den som kommer efter mig är starkare än jag. Hos honom är jag inte förtjänt att bära sandalerna. Han ska döpa er i helig Ande och eld. ");
INSERT INTO swessb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hans kastskovel är i hans hand, och han ska rensa sin tröskplats och samla sitt vete in i förrådet. Men agnarna ska han bränna upp med osläckbar eld.” ");
INSERT INTO swessb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Då kommer Jesus dit från Galileen till Jordan hos Johannes för att döpas av honom. ");
INSERT INTO swessb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Men Johannes började hindra honom och sade: ”Jag har behov att döpas av dig. Och du kommer till mig?” ");
INSERT INTO swessb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Men Jesus svarade och sade till honom: ”Tillåt det nu. För så är det anständigt för oss att uppfylla all rättfärdighet.” Då tillät han honom. ");
INSERT INTO swessb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Och döpt steg Jesus direkt upp ur vattnet, och se: då öppnades för honom himlarna, och han såg Guds Ande komma ner som en duva och komma över honom. ");
INSERT INTO swessb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Och se: en röst från himlarna som sade: ”Denne är min Son, den Älskade. I honom har jag funnit behag.” ");
INSERT INTO swessb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sedan fördes Jesus upp till ödemarken av Anden för att testas av djävulen. ");
INSERT INTO swessb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Och sedan han fastat fyrtio dagar och fyrtio nätter blev han till sist hungrig. ");
INSERT INTO swessb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Och frestaren kom fram och sade till honom: ”Om du är Guds Son, säg att dessa stenar ska bli bröd.” ");
INSERT INTO swessb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Men han svarade och sade: ”Det är skrivet: Det är inte bara på bröd människan ska leva, utan på varje ord som utgår genom Guds mun.” ");
INSERT INTO swessb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Då tar djävulen med honom till den heliga staden och ställde honom på templets vinge ");
INSERT INTO swessb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","och säger till honom: ”Om du är Guds Son, kasta dig ner! För det är skrivet att: Sina änglar ska han påbjuda om dig,   och på händer ska de bära dig   så att inte du stöter emot en sten med din fot.” ");
INSERT INTO swessb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus sade till honom: ”Åter är det skrivet: Du ska inte testa ut Herren din Gud.” ");
INSERT INTO swessb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Åter tar djävulen med honom till ett väldigt högt berg och visar honom världens alla riken och deras härlighet, ");
INSERT INTO swessb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","och han sade till honom: ”Allt detta ska jag ge dig, om du faller ner och tillber mig.” ");
INSERT INTO swessb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Då säger Jesus till honom: ”Bege dig, Satan! För det är skrivet: Herren din Gud ska du tillbe, och bara honom ska du dyrka.” ");
INSERT INTO swessb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Då lämnar honom djävulen, och se: änglar kom fram och betjänade honom. ");
INSERT INTO swessb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Men när han hörde att Johannes hade blivit utlämnad, drog han sig undan till Galileen. ");
INSERT INTO swessb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Och han lämnade Nasaret och kom och bosatte sig i Kapernaum vid havet i Sebulons och Naftalis område, ");
INSERT INTO swessb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","för att det skulle uppfyllas som var sagt genom profeten Jesaja, som sade: ");
INSERT INTO swessb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulons land och Naftalis land,   havsvägen, andra sidan Jordan,   folkslagens Galileen:  ");
INSERT INTO swessb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","folket som sitter i mörker   har sett ett stort ljus,   och för dem som sitter i dödens trakt och skugga  har ett ljus gått upp, för dem.  ");
INSERT INTO swessb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Från då började Jesus förkunna och säga: ”Ändra sinne! För himlarnas rike är nu nära.” ");
INSERT INTO swessb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Och vandrande längs Galileiska havet såg han två bröder, Simon som kallas Petrus och Andreas hans bror, som kastade kastnät i havet. För de var fiskare. ");
INSERT INTO swessb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Och han säger till dem: ”Kom efter mig, och jag ska göra er till människofiskare.” ");
INSERT INTO swessb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Och direkt lämnade de näten och följde honom. ");
INSERT INTO swessb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Och han gick framåt därifrån och såg två andra bröder, Jakob Sebedeus son och Johannes hans bror, i båten med Sebedeus sin far, förfärdigande sina nät. Och han kallade dem, ");
INSERT INTO swessb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","och direkt lämnade de båten och sin far och följde honom. ");
INSERT INTO swessb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Och han drog runt i hela Ga­lileen och undervisade i deras synagogor och förkunnade evange­liet om riket och botade varje åkomma och varje klenhet bland folket. ");
INSERT INTO swessb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Och det gick ut hörsägen om honom i hela Syrien, och man förde fram till honom alla som hade det illa i olika åkommor och var ansatta av plågor, och demoniserade och månsjuka och förlamade. Och han botade dem. ");
INSERT INTO swessb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Och där följde honom stora skaror från Galileen och Dekapolis och Jerusalem och Judeen och andra sidan Jordan. ");
INSERT INTO swessb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Och han såg skarorna och gick upp till berget, och när han satte sig kom hans lärjungar fram till honom. ");
INSERT INTO swessb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Och han öppnade sin mun och började undervisa dem och sade: ");
INSERT INTO swessb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","”Saliga de fattiga i anden, för deras är himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Saliga de som sörjer, för de ska bli tröstade. ");
INSERT INTO swessb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Saliga de milda, för de ska ärva landet. ");
INSERT INTO swessb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Saliga de som hungrar och törstar efter rättfärdigheten, för de ska bli mättade. ");
INSERT INTO swessb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Saliga de barmhärtiga, för de ska få barmhärtighet. ");
INSERT INTO swessb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Saliga de rena i hjärtat, för de ska se Gud. ");
INSERT INTO swessb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Saliga de som är fridsskapare, för de ska kallas Guds söner. ");
INSERT INTO swessb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Saliga de förföljda för rättfärdighets skull, för deras är himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Saliga är ni när de kritiserar er och förföljer och säger allt elakt mot er ljugande för min skull. ");
INSERT INTO swessb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gläd er och jubla, för er lön är stor i himlarna. För så förföljde de profeterna som var före er. ");
INSERT INTO swessb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ni är jordens salt. Men om saltet blir smaklöst, med vad ska det saltas? Till intet mäktar det mer, utom att kastas ut och trampas ner av människorna. ");
INSERT INTO swessb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ni är världens ljus. Inte kan en stad döljas som ligger ovanpå ett berg. ");
INSERT INTO swessb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Inte heller tänder man en lampa och sätter den under skäppan, utan på lampstället och den skiner för alla i huset. ");
INSERT INTO swessb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Så ska ert ljus skina inför människorna, så att de ser era fina gärningar och ärar er Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Anta inte att jag har kommit för att upplösa lagen eller profeterna. Jag har inte kommit för att upplösa, utan uppfylla. ");
INSERT INTO swessb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","För amen, jag säger er: Innan himlen och jorden förgår ska inte ett jota eller en hake förgå från lagen, innan allt har skett. ");
INSERT INTO swessb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Den som alltså upplöser ett av dessa minsta bud och lär människorna så ska kallas minst i himlarnas rike. Men den som gör och lär ut, denne ska kallas stor i himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","För jag säger er att om inte er rättfärdighet överflödar mer än de skriftlärdas och fariseernas, kommer ni aldrig in i himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ni har hört att det blev sagt till de urtida: Du ska inte mörda. Och den som mördar blir straffskyldig inför domen. ");
INSERT INTO swessb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Men jag säger er att var och en som vredgas på sin broder blir straffskyldig inför domen. Och den som säger till sin broder: Raká, blir straffskyldig inför Sanhedrin, och den som säger: Dåre, blir straffskyldig in i eldens Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Om du alltså bär fram din gåva vid altaret och där kommer ihåg att din broder har något emot dig, ");
INSERT INTO swessb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lämna där din gåva framför altaret och bege dig först och bli försonad med din broder. Och kom sedan och bär fram din gåva. ");
INSERT INTO swessb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Var välvillig med din motpart fort, medan du är med honom på vägen, så att inte motparten överlämnar dig till domaren och domaren till undertjänaren och du kastas i fängelse. ");
INSERT INTO swessb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Amen, jag säger dig: Du kommer aldrig ut därifrån innan du har betalat den sista quadranten. ");
INSERT INTO swessb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ni har hört att det blev sagt: Du ska inte begå äktenskapsbrott. ");
INSERT INTO swessb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Men jag säger er att var och en som ser på en kvinna för att åtrå henne har redan begått äktenskapsbrott med henne i sitt hjärta. ");
INSERT INTO swessb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Och om ditt högra öga skandaliserar dig, ta ut det och kasta ifrån dig. För det gagnar dig att en av dina lemmar går förlorad och inte hela din kropp kastas i Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Och om din högra hand skandaliserar dig, hugg bort den och kasta ifrån dig. För det gagnar dig att en av dina lemmar går förlorad och inte hela din kropp går bort till Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Och det blev sagt: Den som förskjuter sin hustru ska ge henne skilsmässa. ");
INSERT INTO swessb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Men jag säger er att var och en som förskjuter sin hustru, utom för en otuktssak, gör att hon begår äktenskaps­brott. Och den som gifter sig med en förskjuten kvinna begår äktenskapsbrott. ");
INSERT INTO swessb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Åter har ni hört att det blev sagt till de urtida: Du ska inte svära falskt, utan du ska infria till Herren dina eder. ");
INSERT INTO swessb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Men jag säger till er att inte svära alls: varken vid himlen, för den är Guds tron, ");
INSERT INTO swessb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","eller vid jorden, för den är pallen för hans fötter, eller vid Jerusalem, för det är den store Kungens stad. ");
INSERT INTO swessb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Inte heller vid ditt huvud ska du svära, för du kan inte göra ett hårstrå vitt eller svart. ");
INSERT INTO swessb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Utan ert ord ska vara ja, ja – nej, nej. Och det somär mer än detta är från det elaka. ");
INSERT INTO swessb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ni har hört att det blev sagt: Öga för öga och tand för tand. ");
INSERT INTO swessb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Men jag säger till er att inte stå emot det elaka. Nej, den som örfilar dig på din högra kind, vänd mot honom också den andra. ");
INSERT INTO swessb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Och åt den som vill gå inför rätta med dig och ta din tunika, lämna honom också manteln. ");
INSERT INTO swessb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Och den som rekvirerar dig för en mil, bege dig med honom två. ");
INSERT INTO swessb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Åt den som ber dig ska du ge, och från den som vill låna av dig ska inte du vända dig bort. ");
INSERT INTO swessb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ni har hört att det blev sagt: Du ska älska din nästa och hata din fiende. ");
INSERT INTO swessb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Men jag säger er: Älska era fiender och bed för dem som förföljer er, ");
INSERT INTO swessb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","så att ni blir söner till er Far i himlarna. För han låter sin sol gå upp över elaka och goda och regnar över rättfärdiga och orättfärdiga. ");
INSERT INTO swessb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","För om ni älskar dem som älskar er, vilken lön har ni? Gör inte också tullindrivarna detsamma? ");
INSERT INTO swessb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Och om ni hälsar bara era syskon, vad gör ni som är mer? Gör inte också hedningarna detsamma? ");
INSERT INTO swessb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ni ska alltså vara fullkomliga, såsom er himmelske Far är fullkomlig. ");
INSERT INTO swessb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Men akta er rättfärdighet, att inte göra den inför människorna för att skådas av dem. Annars har ni ingen lön hos er Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","När du alltså gör en allmosa ska du inte basunera framför dig, såsom hycklarna gör i synagogorna och i gränderna för att bli ärade av människorna. Amen, jag säger er: De har fått ut sin lön. ");
INSERT INTO swessb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Men när du gör en allmosa ska inte din vänstra hand veta vad din högra gör, ");
INSERT INTO swessb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","så att din allmosa är i det fördolda. Och din Far, som ser i det fördolda, ska löna dig. ");
INSERT INTO swessb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Och när ni beder ska ni inte vara som hycklarna, för de gillar att stå i synagogorna och i gathörnen och bedja för att visa sig för människorna. Amen, jag säger er: De har fått ut sin lön. ");
INSERT INTO swessb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Men du när du beder, gå in i din ­kammare och stäng din dörr och bed till din Far som är i det fördolda. Och din Far, som ser i det fördolda, ska löna dig. ");
INSERT INTO swessb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Och när ni beder ska ni inte rabbla ord såsom hedningarna, för de tänker sig att de genom sin mångordighet ska bli bönhörda. ");
INSERT INTO swessb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni ska alltså inte likna dem, för er Far vet vad ni har behov av ­innan ni ber honom. ");
INSERT INTO swessb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Så ska alltså ni bedja: Vår Far i himlarna,  helgat ska ditt namn bli. ");
INSERT INTO swessb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Komma ska ditt rike.  Ske ska din vilja,  som i himmel också på jord.  ");
INSERT INTO swessb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vårt tillkommande bröd ge oss idag.  ");
INSERT INTO swessb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Och förlåt oss våra skulder,   såsom också vi förlåtitvåra skyldiga. ");
INSERT INTO swessb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Och för oss inte in i frestelse, utan rädda oss från det elaka. ");
INSERT INTO swessb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","För om ni förlåter människorna deras felsteg, ska er himmelske Far förlåta också er. ");
INSERT INTO swessb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Men om ni inte förlåter människorna, ska inte heller er Far förlåta era felsteg. ");
INSERT INTO swessb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Och när ni fastar, bli inte som hycklarna, dysterögda. För de förstör sina ansikten för att visa sig för människorna fastande. Amen, jag säger er: De har fått ut sin lön. ");
INSERT INTO swessb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Men du när du fastar, smörj in ditt huvud och tvätta ditt ansikte, ");
INSERT INTO swessb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","så att du inte visar dig för människorna fastande utan för din Far, som är i det förborgade. Och din Far, som ser i det förborgade, ska löna dig. ");
INSERT INTO swessb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Samla inte ihop åt er skatter på jorden, där mal och rost förstör och där tjuvar bryter sig in och stjäl. ");
INSERT INTO swessb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Utan samla ihop åt er skatter i himlen, där varken mal eller rost förstör och där tjuvar inte bryter sig in eller stjäl. ");
INSERT INTO swessb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","För där din skatt är, där kommer också ditt hjärta att vara. ");
INSERT INTO swessb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kroppens lampa är ögat. Om nu ditt öga är oreserverat, blir hela din kropp upplyst. ");
INSERT INTO swessb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Men om ditt öga är elakt blir hela din kropp mörklagd. Om nu ljuset i dig är mörker – vilket mörker! ");
INSERT INTO swessb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ingen kan fasttjäna två herrar. För antingen kommer han att hata den ene och ­älska den andre, eller hålla tag i en och ringakta den andre. Ni kan inte fasttjäna Gud och mammon. ");
INSERT INTO swessb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Därför säger jag er: Bekymra er inte för er själ, vad ni ska äta eller vad ni ska dricka, eller för er kropp, vad ni ska iklä er. Är inte själen mer än födan och kroppen mer än klädseln? ");
INSERT INTO swessb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Se på himlens fåglar, att de inte sår eller skördar eller samlar i förråd. Och er himmelske Far ger dem näring. Är inte ni mycket viktigare än de? ");
INSERT INTO swessb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Men vem av er kan, genom att bekymra sig, lägga till sin ålder en enda aln? ");
INSERT INTO swessb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Och om klädsel, varför bekymrar ni er? Studera åkerns liljor, hur de växer. De jobbar inte eller spinner. ");
INSERT INTO swessb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Men jag säger er att inte ens Salomo i all sin härlighet klädde sig som en av dessa. ");
INSERT INTO swessb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Men om Gud så ekiperar åkerns gräs, som finns idag och imorgon kastas i en ugn, hur mycket mer då inte er, klentrogna? ");
INSERT INTO swessb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bekymra er alltså inte och säg: Vad ska vi äta? eller: Vad ska vi dricka? eller: Vad ska vi klä oss med? ");
INSERT INTO swessb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","För allt detta söker folkslagen efter, för er himmelske Far vet att ni behöver allt detta. ");
INSERT INTO swessb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Men sök först Guds rike och hans rättfärdighet, och allt detta ska tillföras er. ");
INSERT INTO swessb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bekymra er alltså inte för morgondagen, för morgondagen ska bekymra sig för sig själv. Nog för dagen är dess onda. ");
INSERT INTO swessb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Döm inte, så att ni inte blir dömda. ");
INSERT INTO swessb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","För med den dom ni dömer ska ni dömas, och med det mått ni mäter med ska det mätas åt er. ");
INSERT INTO swessb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Men varför ser du flisan i din broders öga, men bjälken i ditt öga beaktar du inte? ");
INSERT INTO swessb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eller hur ska du säga till din broder: Låt mig kasta ut flisan ur ditt öga – och se: bjälken i ditt öga! ");
INSERT INTO swessb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hycklare, kasta först ut bjälken ur ditt öga. Och då ska du se bra för att kasta ut flisan ur din broders öga. ");
INSERT INTO swessb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ni ska inte ge det heliga åt hundarna, eller kasta era pärlor framför svinen. Annars kommer de att trampa ner dem med sina fötter, och vända sig och slita sönder er. ");
INSERT INTO swessb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Be och det ska ges er. Sök och ni ska finna. Bulta och det ska öppnas för er. ");
INSERT INTO swessb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","För var och en som ber får, och den som söker finner. Och för den som bultar ska det öppnas. ");
INSERT INTO swessb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Eller vem av er är en människa som hans son ska be om bröd – inte är det en sten han kommer att ge honom? ");
INSERT INTO swessb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eller också ska han be om fisk – inte är det en orm han kommer att ge honom? ");
INSERT INTO swessb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Om nu ni som är elaka vet att ge goda gåvor till era barn, hur mycket mer ska er Far i himlarna ge goda ting till dem som ber honom? ");
INSERT INTO swessb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Alltså: allt vad ni vill att männis­korna ska göra för er, så ska ­också ni göra för dem. För detta är lagen och profeterna. ");
INSERT INTO swessb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gå in genom den trånga porten. För bred är porten och rymlig vägen som leder bort till fördärvet, och många är de som går in genom den. ");
INSERT INTO swessb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hur trång är porten och sammanpressad vägen som leder bort till livet, och få är de som finner den. ");
INSERT INTO swessb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Akta er för de falska profeterna som kommer till er i fårs klädsel, men inuti är de rovlystna vargar. ");
INSERT INTO swessb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Av deras frukter ska ni känna igen dem. Inte plockar man väl ihop druvor från törnen eller fikon från tistlar? ");
INSERT INTO swessb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Så gör varje gott träd fina frukter, men det ruttna trädet gör elaka frukter. ");
INSERT INTO swessb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ett gott träd kan inte göra elaka frukter, inte heller ett ruttet träd göra fina frukter. ");
INSERT INTO swessb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Varje träd som inte gör fin frukt huggs bort och kastas i eld. ");
INSERT INTO swessb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Alltså är det från deras frukter ni ska känna igen dem. ");
INSERT INTO swessb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Inte var och en som säger till mig: Herre, Herre, ska komma in i himlarnas rike, utan den som gör viljan hos min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Många ska säga till mig på den dagen: Herre, Herre, har inte vi med ditt namn profeterat, och med ditt namn drivit ut demoner, och med ditt namn gjort många kraftgärningar? ");
INSERT INTO swessb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Och då ska jag erkänna för dem att: Jag har aldrig känt er. Dra bort från mig, ni som utför laglösheten. ");
INSERT INTO swessb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Var och en som alltså hör dessa mina ord och gör dem ska liknas vid en klok man, som byggde sitt hus på klippan. ");
INSERT INTO swessb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Och ner kom regnet, och floderna kom och vindarna blåste och föll mot det huset. Och det föll inte, för det var grundat på klippan. ");
INSERT INTO swessb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Och var och en som hör dessa mina ord och inte gör dem ska liknas vid en dåraktig man, som byggde sitt hus på sanden. ");
INSERT INTO swessb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Och ner kom regnet, och floderna kom och vindarna blåste och stötte mot det huset. Och det föll, och dess fall var stort.” ");
INSERT INTO swessb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Och det hände sig, när Jesus hade fullbordat dessa ord, att skarorna var överväldigade vid hans undervisning. ");
INSERT INTO swessb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","För han undervisade dem som en som hade auktoritet, och inte som deras skriftlärda. ");
INSERT INTO swessb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Och när han gick ner från berget följde honom stora skaror, ");
INSERT INTO swessb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","och se: en spetälsk kom fram och tillbad honom och sade: ”Herre, om du vill, kan du rena mig.” ");
INSERT INTO swessb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Och han räckte ut handen och rörde vid honom och sade: ”Jag vill. Var renad!” Och direkt blev spetälskan renad från honom. ");
INSERT INTO swessb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Och Jesus säger till honom: ”Se till att du inte säger till någon. Nej, bege dig och visa dig för prästen och frambär den gåva som Mose har förordnat, till ett vittnes­börd för dem.” ");
INSERT INTO swessb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","När han gått in i Kapernaum, kom det fram till honom en centurion som vädjade till honom ");
INSERT INTO swessb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","och sade: ”Herre, min gosse är liggande i huset förlamad, förskräckligt plågad.” ");
INSERT INTO swessb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Och han säger till honom: ”Jag ska komma och bota honom.” ");
INSERT INTO swessb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Och centurionen svarade och sade: ”Herre, jag är inte förtjänt att du går in under mitt tak. Men säg bara med ett ord och min gosse blir helad. ");
INSERT INTO swessb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","För jag är också en människa under auktoritet och har soldater under mig, och jag säger till den: Gå, och han går, och till en annan: Kom, och han kommer, och till min fasttjänare: Gör detta, och han gör det.” ");
INSERT INTO swessb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Och när Jesus hörde det, blev han förundrad och sade till dem som följde: ”Amen, jag säger er: Hos ingen har jag funnit en så stor tro i Israel. ");
INSERT INTO swessb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Och jag säger er att många från öst och väst ska komma och ligga till bords med Abraham och Isak och Jakob i ­himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Men rikets barn ska kastas ut i det yttre mörkret. Där blir gråten och tandagnisslet.” ");
INSERT INTO swessb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Och Jesus sade till centurionen: ”Bege dig. Som du trott ska det ske för dig.” Och hans gosse blev helad i den stunden. ");
INSERT INTO swessb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Och Jesus kom till Petrus hus och såg hans svärmor liggande och febrig. ");
INSERT INTO swessb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Och han rörde vid hennes hand, och febern lämnade henne. Och hon reste sig och betjänade honom. ");
INSERT INTO swessb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Men när det blev kväll, förde man fram till honom många demoniserade. Och han drev ut andarna med ett ord, och alla som hade det illa botade han, ");
INSERT INTO swessb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","för att det skulle uppfyllas som var sagt genom profeten Jesaja, som sade: Han tog våra sjukdomar   och bar våra åkommor. ");
INSERT INTO swessb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Men när Jesus såg en skara omkring honom, befallde han att man skulle resa bort till andra sidan havet. ");
INSERT INTO swessb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Och det kom fram en skriftlärd och sade till honom: ”Lärare, jag ska följa dig varthelst du går hän.” ");
INSERT INTO swessb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Och Jesus säger till honom: ”Rävarna har lyor och himlens fåglar bon. Men Människosonen har ingenstans att luta huvudet.” ");
INSERT INTO swessb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Och en annan av hans lärjungar sade till honom: ”Herre, tillåt mig att först gå bort och begrava min far.” ");
INSERT INTO swessb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Men Jesus säger till honom: ”Följ mig. Och låt de döda begrava sina döda.” ");
INSERT INTO swessb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Och när han steg i båten följde hans lärjungar honom, ");
INSERT INTO swessb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","och se: en väldig bävning kom på havet så att båten täcktes av vågorna. Men han sov. ");
INSERT INTO swessb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Och de kom fram och väckte honom och sade: ”Herre, fräls! Vi går förlorade!” ");
INSERT INTO swessb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Och han säger till dem: ”Varför är ni fega, ni klentrogna?” Sedan reste han sig och näpste vindarna och havet, och det blev ett väldigt lugn. ");
INSERT INTO swessb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Och människorna var förundrade och sade: ”Vad för en är denne? För till och med vindarna och havet hörsammar honom!” ");
INSERT INTO swessb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Och när han kom till andra sidan, till gadarenernas trakt, mötte honom två demoniserade som kom ut från gravarna, så väldigt besvärliga att ingen mäktade att komma förbi på den vägen. ");
INSERT INTO swessb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Och se, de skrek och sade: ”Vad mellan oss och dig, Guds Son? Har du kommit hit i förtid för att plåga oss?” ");
INSERT INTO swessb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Men där fanns långt ifrån dem en hjord med många svin som vallades, ");
INSERT INTO swessb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","och demonerna vädjade till honom och sade: ”Om du driver ut oss, sänd oss in i svinens hjord.” ");
INSERT INTO swessb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Och han sade till dem: ”Bege er!” Och de kom ut och for bort in i svinen, och se: då rusade hela hjorden ner från branten i havet och dog i vattnen. ");
INSERT INTO swessb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Och de som vallade flydde, och när de kommit bort in i staden berättade de allt, också det om de demoniserade. ");
INSERT INTO swessb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Och se: hela staden kom ut till möte med Jesus. Och när de såg honom, vädjade de att han skulle gå vidare från deras område. ");
INSERT INTO swessb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Och han steg i båten och for över till andra sidan och kom till sin egen stad. ");
INSERT INTO swessb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Och se: man bar fram till honom en förlamad liggande på en bädd. Och när Jesus såg deras tro, sade han till den förlamade: ”Fatta mod, barn. Dina synder blir förlåtna.” ");
INSERT INTO swessb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Och se: några av de skriftlärda sade inom sig: ”Den där hädar!” ");
INSERT INTO swessb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Och Jesus såg deras tankar och sade: ”Varför tänker ni elakt i era hjärtan? ");
INSERT INTO swessb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","För vad är lättare, att säga: Dina synder blir förlåtna, eller att säga: Res dig och vandra? ");
INSERT INTO swessb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Men för att ni ska veta att Människosonen har auktoritet på jorden att förlåta synder” – sedan säger han till den förlamade: ”Res dig, ta din bädd och bege dig till ditt hus!” ");
INSERT INTO swessb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Och han reste sig och gick iväg till sitt hus. ");
INSERT INTO swessb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Och när skarorna såg det, fruktade de och ärade Gud som gett sådan auktoritet åt människorna. ");
INSERT INTO swessb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Och Jesus drog vidare därifrån och såg en man sittande vid tullhuset, kallad Matteus, och säger till honom: ”Följ mig!” Och han stod upp och följde honom. ");
INSERT INTO swessb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Och det hände sig, när han låg till bords i huset, och se: många tullindrivare och syndare kom och låg till bords med Jesus och hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Och fariseerna såg det och sade till hans lärjungar: ”Varför är det med tullindrivarna och syndarna er lärare äter?” ");
INSERT INTO swessb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Men han hörde det och sade: ”Inte har de starka behov av läkare, utan de som har det illa. ");
INSERT INTO swessb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Men gå och lär er vad detta är: Barmhärtighet vill jag och inte offer. För jag har inte kommit för att kalla rättfärdiga, utan syndare.” ");
INSERT INTO swessb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Då kommer Johannes lärjungar fram till honom och säger: ”Varför fastar vi och fariseerna mycket, men dina lärjungar fastar inte?” ");
INSERT INTO swessb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Och Jesus sade till dem: ”Inte kan bröllopssalens söner sörja så länge brudgummen är hos dem? Men det ska komma dagar när brudgummen tas ifrån dem, och då kommer de att fasta. ");
INSERT INTO swessb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Och ingen sätter på en lapp av okrympt tyg på en gammal mantel, för den tar bort sin fullhet från manteln och det blir en värre reva. ");
INSERT INTO swessb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Och man häller inte ungt vin i gamla läglar. Annars slits läglarna sönder och ­vinet utgjuts och läglarna går förlorade. Nej, man häller ungt vin i nya läglar, och båda bevaras.” ");
INSERT INTO swessb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Medan han talade detta till dem, se: en ledare kom och tillbad honom och sade att: ”Min dotter avled nyss. Men kom och lägg din hand på henne och hon ska leva.” ");
INSERT INTO swessb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Och Jesus reste sig och följde honom, även hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Och se: en kvinna som hade blött i tolv år kom fram bakifrån och ­rörde vid hörntofsen på hans mantel, ");
INSERT INTO swessb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","för hon sade inom sig: ”Om jag så bara rör vid hans mantel blir jag frälst.” ");
INSERT INTO swessb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Men Jesus vände sig och såg henne och sade: ”Fatta mod, dotter. Din tro har frälst dig.” Och kvinnan var frälst från den stunden. ");
INSERT INTO swessb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Och när Jesus kom till ledarens hus och såg flöjtblåsarna och skaran som väsnades, ");
INSERT INTO swessb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sade han: ”Dra er undan! För flickan har inte dött, utan sover.” Och de skrattade åt honom. ");
INSERT INTO swessb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Men när skaran hade drivits ut, gick han in och grep hennes hand. Och flickan reste sig. ");
INSERT INTO swessb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Och detta rykte gick ut i hela det landet. ");
INSERT INTO swessb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Och när Jesus drog vidare därifrån, följde honom två blinda som skrek och sade: ”Förbarma dig över oss, Davids son!” ");
INSERT INTO swessb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Och när han kommit till huset gick de blinda fram till honom, och Jesus säger till dem: ”Tror ni att jag kan göra detta?” De säger till honom: ”Ja, Herre.” ");
INSERT INTO swessb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Då rörde han vid deras ögon och sade: ”Efter er tro ska det ske för er.” ");
INSERT INTO swessb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Och deras ögon öppnades. Och Jesus frustade mot dem och sade: ”Se till att ingen ska få veta.” ");
INSERT INTO swessb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Men de gick ut och spred ryktet om honom i hela det landet. ");
INSERT INTO swessb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Men när de gick ut, se: då förde man fram till honom en stum demoniserad människa. ");
INSERT INTO swessb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Och när demonen var utdriven talade den stumme, och skarorna var förundrade och sade: ”Aldrig har det visat sig sådant i Israel!” ");
INSERT INTO swessb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Men fariseerna sade: ”Det är med demonernas furste han driver ut demonerna.” ");
INSERT INTO swessb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Och Jesus drog runt i alla städerna och byarna, och han undervisade i deras synagogor och förkunnade evangeliet om riket och botade varje åkomma och varje klenhet. ");
INSERT INTO swessb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Och när han såg skarorna kände han innerligt för dem, för de var besvärade och utsatta, som får som inte har herde. ");
INSERT INTO swessb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Då säger han till sina lärjungar: ”Skörden är stor men arbetarna få. ");
INSERT INTO swessb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bönfall då skördens Herre att han driver ut arbetare till sin skörd.” ");
INSERT INTO swessb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Och han kallade till sig sina tolv lärjungar och gav dem auktoritet över orena andar, att driva ut dem och bota varje åkomma och varje klenhet. ");
INSERT INTO swessb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Och de tolv apostlarnas namn är dessa: först Simon som kallas Petrus och Andreas hans bror, och Jakob Sebedeus son och Johannes hans bror, ");
INSERT INTO swessb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippus och Bartolomeus, Tomas och Matteus tullindrivaren, Jakob Alfeus son och Taddeus, ");
INSERT INTO swessb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Kananaios och Judas Iskariot, som också utlämnade honom. ");
INSERT INTO swessb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dessa tolv sände Jesus ut och instruerade dem och sade: ”Till folkslagens väg ska ni inte gå bort, och i en stad med samarier ska ni inte gå in. ");
INSERT INTO swessb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Utan gå snarare till de förlorade fåren av Israels hus. ");
INSERT INTO swessb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Och när ni går, förkunna och säg att himlarnas rike nu är nära. ");
INSERT INTO swessb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bota sjuka, uppväck döda, rena spetälska, driv ut demoner. Gratis har ni fått, gratis ska ni ge. ");
INSERT INTO swessb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Förvärva inte guld eller silver eller koppar till era bälten, ");
INSERT INTO swessb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","inte väska för vägen eller två tunikor eller sandaler eller stav. För arbetaren är värd sin föda. ");
INSERT INTO swessb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Och i den stad eller by till vilken ni kommer, hör er för vem i den som är värdig, och stanna där tills ni går ut. ");
INSERT INTO swessb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Och när ni kommer in i huset, hälsa det. ");
INSERT INTO swessb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Och om huset är värdigt, ska er frid komma över det. Men om det inte är värdigt ska er frid vända om till er. ");
INSERT INTO swessb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Och den som inte välkomnar er eller hör era ord, gå ut utanför det huset eller staden och skaka av dammet från era fötter. ");
INSERT INTO swessb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Amen, jag säger er: det ska bli uthärdligare för Sodoms och Gomorras land på domens dag än för den staden. ");
INSERT INTO swessb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Se: jag sänder er som får mitt bland vargar. Var då kloka som ormarna och oförvanskade som duvorna. ");
INSERT INTO swessb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Men akta er för människorna. För de ska utlämna er åt sanhedriner, och i sina synagogor ska de piska er. ");
INSERT INTO swessb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Och även inför styresmän och kungar ska ni föras för min skull, till ett vittnesbörd för dem och för folkslagen. ");
INSERT INTO swessb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Men när de utlämnar er, bekymra er inte för hur eller vad ni ska tala. För det ska ges er i den stunden vad ni ska tala. ");
INSERT INTO swessb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","För det är inte ni som talar, utan er Fars Ande som talar genom er. ");
INSERT INTO swessb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Och broder ska utlämna broder till döden och en far ett barn, och barn ska resa sig mot föräldrar och döda dem. ");
INSERT INTO swessb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Och ni ska bli hatade av alla för mitt namns skull. Men den som håller ut till slutet, denne ska bli frälst. ");
INSERT INTO swessb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Och när man förföljer er i den staden, fly till den andra. Amen, jag säger er: Ni kommer aldrig att fullborda Israels städer innan Människosonen kommer. ");
INSERT INTO swessb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","En lärjunge är inte över läraren, inte heller en fasttjänare över sin herre. ");
INSERT INTO swessb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Det är nog för lärjungen att han blir som sin lärare, och fasttjänaren som sin herre. Om de har kallat hushärskaren för Beelsebul, hur mycket mer hans husfolk? ");
INSERT INTO swessb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Frukta dem alltså inte. För det finns inget täckt som inte ska uppen­baras, och inget dolt som inte ska bli känt. ");
INSERT INTO swessb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Det jag säger er i mörkret ska ni säga i ljuset, och det ni hör i örat ska ni förkunna på taken. ");
INSERT INTO swessb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Och frukta inte för dem som dödar kroppen, men inte kan döda själen. Nej, frukta snarare honom som kan förgöra både själ och kropp i Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Säljs inte två sparvar för ett ass? Och inte en enda av dem faller till jorden utan er Far. ");
INSERT INTO swessb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Och på er är till och med alla huvudhåren räknade. ");
INSERT INTO swessb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Frukta alltså inte. Ni är viktigare än många sparvar. ");
INSERT INTO swessb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Var och en som alltså bekänner mig inför människorna, honom ska också jag bekänna inför min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Men den som förnekar mig inför människorna, honom ska också jag förneka inför min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Anta inte att jag har kommit för att sätta fred på jorden. Jag har inte kommit för att sätta fred, utan svärd. ");
INSERT INTO swessb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","För jag har kommit för att splittra en man mot sin far, och en dotter mot sin mor, och en brud mot sin svärmor. ");
INSERT INTO swessb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ochmänniskans fiender blir hans husfolk. ");
INSERT INTO swessb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Den som gillar far eller mor över mig är mig inte värdig, och den som gillar son eller dotter över mig är mig inte värdig. ");
INSERT INTO swessb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Och den som inte tar sitt kors och följer efter mig är mig inte värdig. ");
INSERT INTO swessb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Den som finner sin själ ska förlora den, och den som förlorar sin själ för min skull ska finna den. ");
INSERT INTO swessb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Den som välkomnar er välkomnar mig, och den som välkomnar mig välkomnar den som har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Den som välkomnar en profet för en profets namns skull ska få en profets lön, och den som välkomnar en rättfärdig för en rättfärdigs namns skull ska få en rättfärdigs lön. ");
INSERT INTO swessb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Och den som ger en av dessa små bara en bägare kallt att dricka, för en lärjunges namns skull – amen, jag säger er: Han ska aldrig förlora sin lön.” ");
INSERT INTO swessb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Och det hände sig, när Jesus hade fullbordat att förordna för sina tolv lärjungar, att han gick vidare därifrån för att under­visa och förkunna i deras städer. ");
INSERT INTO swessb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Men Johannes hörde i fånghäktet om Kristi gärningar, skickade genom sina lärjungar ");
INSERT INTO swessb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","och sade till honom: ”Är du han som kommer? Eller är det en annan vi ska vänta oss?” ");
INSERT INTO swessb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Och Jesus svarade och sade till dem: ”Gå och berätta för Johannes vad ni hör och ser: ");
INSERT INTO swessb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Blinda ser igen och lama går. Spetälska blir renade och döva hör, och döda uppväcks och fattiga evangeliseras. ");
INSERT INTO swessb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Och salig är den som inte skandaliseras av mig.” ");
INSERT INTO swessb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Men när dessa hade gått, började Jesus säga till skarorna om Johannes: ”Vad gick ni ut i ödemarken för att skåda? Ett vassrör skakat av vind? ");
INSERT INTO swessb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nej, vad gick ni ut för att se? En man ekiperad i mjukt? Se: de som bär det mjuka är i kungarnas hus. ");
INSERT INTO swessb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nej, vad gick ni ut för att se? En profet? Ja, jag säger er: och mycket mer än en profet. ");
INSERT INTO swessb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Denne är den om vilken det är skrivet: Se: jag sänder min ängel   framför ditt ansikte.   Han ska preparera din väg framför dig. ");
INSERT INTO swessb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Amen, jag säger er: Ingen har blivit upprest bland dem födda av kvinnor större än Johannes Döparen. Men den mindre i himlarnas rike är större än han. ");
INSERT INTO swessb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Men från Johannes Döparens dagar till nu tvingar sig himlarnas rike fram, och betvingare rycker det. ");
INSERT INTO swessb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","För alla profeterna och lagen har profeterat fram till Johannes, ");
INSERT INTO swessb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","och om ni vill motta det: han är Elia som ska komma. ");
INSERT INTO swessb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Den som har öron ska höra. ");
INSERT INTO swessb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Men vid vad ska jag likna detta släkte? Det är likt barn sittande på torgen som ropar till de andra ");
INSERT INTO swessb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","och säger: Vi flöjtade för er och ni dansade inte, vi sjöng sorgesång och ni slog inte er själva. ");
INSERT INTO swessb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","För Johannes kom och han varken åt eller drack, och man säger: Han har en demon. ");
INSERT INTO swessb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Människosonen kom och han äter och dricker, och man säger: Se människan, en frossare och vindrinkare, en vän till tullindrivare och syndare! Och Visheten har förklarats rättfärdig av sina gärningar.” ");
INSERT INTO swessb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sedan började han kritisera de städer i vilka de flesta av hans kraftgärningar skett, eftersom de inte hade ändrat sinne: ");
INSERT INTO swessb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","”Ve dig Korasin! Ve dig Betsaida! För om det var i Tyrus och Sidon de hade skett, kraftgärningarna som skett i er, hade de sedan länge i säck och aska ändrat sinne. ");
INSERT INTO swessb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Men jag säger er: För Tyrus och Sidon ska det bli uthärdligare på domens dag än för er. ");
INSERT INTO swessb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Och du Kapernaum, inte ska du bli upphöjd till himlen? Till Hades ska du gå ner. För om det var i Sodom de hade skett, kraftgärningarna som skett i dig, hade det varit kvar tills idag. ");
INSERT INTO swessb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Men jag säger er att för Sodoms land ska det bli uthärdligare på domens dag än för dig.” ");
INSERT INTO swessb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vid den tiden svarade Jesus och sade: ”Jag erkänner dig Far, himlens och jordens Herre, för att du har dolt detta för visa och förståndiga och uppenbarat det för små barn. ");
INSERT INTO swessb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ja Far, för så blev det välbehag inför dig. ");
INSERT INTO swessb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Allt har överlämnats till mig av min Far. Och ingen känner Sonen utom Fadern, inte heller känner någon Fadern utom Sonen och den för vilken Sonen önskar uppenbara honom. ");
INSERT INTO swessb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kom till mig, alla som jobbar och är belastade, och jag ska ge er ro. ");
INSERT INTO swessb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ta upp mitt ok på er och lär av mig, för jag är mild och ödmjuk i hjärtat. Och ni ska finna ro för era själar. ");
INSERT INTO swessb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","För mitt ok är snällt och min börda lätt.” ");
INSERT INTO swessb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vid den tiden gick Jesus på sab­baten genom sädesfälten, och hans lärjungar blev ­hungriga och började plocka ax och äta. ");
INSERT INTO swessb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Men fariseerna såg det och sade till honom: ”Se: dina lärjungar gör det som inte är tillåtet att göra på sabbaten.” ");
INSERT INTO swessb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Men han sade till dem: ”Har ni inte läst vad David gjorde när han blev hungrig, och de andra med honom? ");
INSERT INTO swessb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hur han gick in i Guds hus, och de åt framsättningens bröd som det inte var tillåtet för honom att äta, eller för de andra med honom, utom bara för prästerna. ");
INSERT INTO swessb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eller har ni inte läst i lagen att på sabbaten profanerar prästerna i templet sabbaten och är skuldlösa? ");
INSERT INTO swessb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Och jag säger er att något större än templet är här. ");
INSERT INTO swessb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Men om ni hade förstått vad detta är: Barmhärtighet vill jag och inte offer, hade ni inte fällt de skuldlösa. ");
INSERT INTO swessb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","För Människosonen är Herre över sabbaten.” ");
INSERT INTO swessb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Och han gick vidare därifrån och kom till deras synagoga, ");
INSERT INTO swessb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","och se: en man som hade en skrumpnad hand. Och de frågade honom och sade: ”Om det är tillåtet på sabbaten att bota?”, för att anklaga honom. ");
INSERT INTO swessb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Och han sade till dem: ”Vem av er skulle vara en människa som har ett enda får, och om detta på sabbaten faller i en grop, kommer han inte att gripa det och resa upp? ");
INSERT INTO swessb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hur mycket viktigare är då en människa än ett får? Alltså är det tillåtet på sabbaten att göra väl.” ");
INSERT INTO swessb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sedan säger han till mannen: ”Räck ut din hand.” Och han räckte ut den, och den blev återställd frisk som den andra. ");
INSERT INTO swessb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Men då gick fariseerna ut och tog beslut mot honom för att förgöra honom. ");
INSERT INTO swessb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Men Jesus förstod och drog sig undan därifrån. Och det följde honom många skaror, och han botade dem alla. ");
INSERT INTO swessb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Och han näpste dem för att de inte skulle göra honom uppenbar, ");
INSERT INTO swessb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","för att det skulle uppfyllas som var sagt genom profeten Jesaja, som sade: ");
INSERT INTO swessb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Se min gosse som jag utvalt,   min älskade till vilken min själ funnit behag.   Jag ska sätta min Ande över honom,   och han ska meddela rätt för folkslagen.  ");
INSERT INTO swessb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Han ska inte gräla eller vråla,   och ingen på gatorna ska höra hans röst.  ");
INSERT INTO swessb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ett knäckt vassrör ska han inte krossa,   och en rykande veke ska han inte släcka,   tills han drivit ut rätten till seger.  ");
INSERT INTO swessb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Och på hans namn ska folkslag hoppas.  ");
INSERT INTO swessb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sedan fördes det fram till honom en demoniserad blind och stum, och han botade honom så att den stumme talade och såg. ");
INSERT INTO swessb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Och alla skarorna blev utom sig och sade: ”Inte är väl denne Davids son?” ");
INSERT INTO swessb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Men fariseerna hörde det och sade de: ”Den där driver inte ut demonerna utom med Beelsebul, demonernas furste.” ");
INSERT INTO swessb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Men han visste deras tankar och sade till dem: ”Varje rike delat mot sig självt blir ödelagt, och varje stad eller hus delat mot sig självt kommer inte att bestå. ");
INSERT INTO swessb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Och om Satan driver ut Satan, är han delad mot sig själv. Hur ska då hans rike bestå? ");
INSERT INTO swessb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Och om det är med Beelsebul jag driver ut demonerna, med vem driver era söner ut? Därför blir de era domare. ");
INSERT INTO swessb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Men om det är med Guds Ande jag driver ut demonerna, då har Guds rike nått till er. ");
INSERT INTO swessb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Eller hur kan någon gå in i den starkes hus och rycka hans kärl, om han inte först binder den starke? Och sedan ska han länsa hans hus. ");
INSERT INTO swessb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Den som inte är med mig, är mot mig. Och den som inte samlar med mig skingrar. ");
INSERT INTO swessb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Därför säger jag er: All synd och hädelse ska förlåtas människorna, men hädelsen mot Anden kommer inte att förlåtas. ");
INSERT INTO swessb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Och den som säger ett ord mot Människosonen, det ska förlåtas honom. Men den som talar emot den heliga Anden, det kommer inte att förlåtas honom, varken i denna eon eller i den kommande. ");
INSERT INTO swessb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gör antingen trädet fint och dess frukt fin, eller gör trädet ruttet och dess frukt rutten. För från frukten kän­ns trädet. ");
INSERT INTO swessb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Huggormsyngel, hur kan ni tala gott när ni är elaka? För ur hjärtats överflöd talar munnen. ");
INSERT INTO swessb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Den goda män­niskan kastar ur sin goda skattgömma fram gott, och den elaka människan kastar ur sin elaka skattgömma fram elakt. ");
INSERT INTO swessb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Men jag säger er att varje overksamt ord som människorna kommer att tala, för det ska de avge räkenskap på domens dag. ");
INSERT INTO swessb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","För utifrån dina ord ska du förklaras rättfärdig, och utifrån dina ord ska du bli fälld.” ");
INSERT INTO swessb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Då svarade honom några av de skriftlärda och fariseerna och sade: ”Lärare, vi vill se ett tecken från dig.” ");
INSERT INTO swessb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Men han svarade och sade till dem: ”Ett elakt och otroget släkte söker ett tecken. Och ett tecken ska inte ges det, utom profeten Jonas tecken. ");
INSERT INTO swessb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","För såsom Jona var i havsmonstrets buk tre dagar och tre nätter, så ska Människosonen vara i jordens hjärta tre dagar och tre nätter. ");
INSERT INTO swessb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninevitiska män ska uppstå vid domen med detta släkte och fördöma det. För de ändrade sinne vid Jonas förkunnelse, och se: något större än Jona är här. ");
INSERT INTO swessb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Söderns drottning ska uppstå vid domen med detta släkte och fördöma det. För hon kom från jordens ändar för att höra Salomos vishet, och se: något större än Salomo är här. ");
INSERT INTO swessb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Men när den orena anden kommer ut ur människan, går den genom vattenlösa platser och söker ro och finner ingen. ");
INSERT INTO swessb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Då säger den: Till mitt hus ska jag vända om, varifrån jag kom ut. Och den kommer och finner det ledigt, sopat och tillsnyggat. ");
INSERT INTO swessb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Då går den och tar med sju andra andar elakare än den själv, och de går in och bosätter sig där. Och då blir det sista för den människan värre än det första. Så ska det bli också för detta elaka släkte.” ");
INSERT INTO swessb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Medan han ännu talade till skarorna, se: hans mor och bröder stod utanför och sökte tala med honom. ");
INSERT INTO swessb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Och någon sade till honom: ”Se: din mor och dina bröder står utanför och söker tala med dig.” ");
INSERT INTO swessb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Men han svarade och sade till den som sade det till honom: ”Vem är min mor? Och vilka är mina bröder?” ");
INSERT INTO swessb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Och han räckte ut sin hand mot sina lärjungar och sade: ”Se: min mor och mina bröder. ");
INSERT INTO swessb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","För den som gör viljan hos min Far i himlarna, han är min bror och syster och mor.” ");
INSERT INTO swessb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","På den dagen gick Jesus ut från huset och satte sig vid havet. ");
INSERT INTO swessb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Och det samlades hos honom så stora skaror att han steg i en båt och satte sig, och hela skaran stod på stranden. ");
INSERT INTO swessb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Och han talade till dem mycket i liknelser och sade: ”Se: Ut gick såningsmannen för att så. ");
INSERT INTO swessb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Och under det att han sådde föll en del vid ­vägen, och fåglarna kom och åt upp det. ");
INSERT INTO swessb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Och annat föll på det steniga där det inte hade mycket jord, och direkt kom det upp eftersom det inte hade djup jord. ");
INSERT INTO swessb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Men när solen gick upp sveddes det, och eftersom det inte hade rot vissnade det. ");
INSERT INTO swessb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Och annat föll på törnena, och upp kom törnena och kvävde det. ");
INSERT INTO swessb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Men annat föll på den fina jorden och gav gröda: dels hundra, och dels sextio, och dels trettio. ");
INSERT INTO swessb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Den som har öron ska höra.” ");
INSERT INTO swessb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Och lärjungarna kom fram och sade till honom: ”Varför talar du till dem i liknelser?” ");
INSERT INTO swessb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Och han svarade och sade till dem: ”För åt er är det givet att känna himlarnas rikes hemligheter, men åt dessa är det inte givet. ");
INSERT INTO swessb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","För den som har, åt honom ska det ges och överflöda. Men den som inte har, också det han har ska tas ifrån honom. ");
INSERT INTO swessb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Därför talar jag till dem i liknelser, för seende ser de inte, och hörande hör de inte eller förstår. ");
INSERT INTO swessb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Och för dem uppfylls Jesajas profetia som säger: Hörande ska ni höra och aldrig förstå,   och seende ska ni se och aldrig se.  ");
INSERT INTO swessb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","För detta folks hjärta har blivit förtjockat.   Och med öronen hörde de svårligen,   och med sina ögon blundade de,  så att de inte skulle se med ögonen  och med öronen höra  och med hjärtat förstå  och vända om, och jag kommer att hela dem. ");
INSERT INTO swessb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Men saliga era ögon, för de ser, och era öron, för de hör. ");
INSERT INTO swessb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","För amen, jag säger er att många profeter och rättfärdiga åtrådde att få se vad ni ser, och fick inte se, och höra vad ni hör, och fick inte höra. ");
INSERT INTO swessb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hör nu ni liknelsen om såningsmannen. ");
INSERT INTO swessb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","När var och en hör ordet om riket och inte förstår, kommer den elake och rycker det som såddes i hans hjärta. Denne är den som såddes vid vägen. ");
INSERT INTO swessb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Men den som såddes på det steniga, denne är den som hör ordet och direkt med glädje tar emot det, ");
INSERT INTO swessb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","men inte har rot inom sig utan är tillfällig. Och när det kommer nöd eller förföljelse för ordets skull, blir han direkt skandaliserad. ");
INSERT INTO swessb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Men den som såddes i törnena, denne är den som hör ordet och eonens bekymmer och rikedomens tjusning kväver ihop ordet och det blir utan frukt. ");
INSERT INTO swessb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Men den som såddes på den fina jorden, denne är den som hör ordet och förstår, som verkligen bär frukt och gör dels hundra, och dels sextio, och dels trettio.” ");
INSERT INTO swessb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","En annan liknelse lade han fram för dem och sade: ”Himlarnas rike har liknats vid en man som hade sått fin säd i sin åker. ");
INSERT INTO swessb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Men när människorna sov, kom hans fiende och sådde på ogräs mitt bland vetet och gick bort. ");
INSERT INTO swessb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Och när strået spirade och gjorde gröda, då visade sig också ogräsen. ");
INSERT INTO swessb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Och hushärskarens fasttjänare kom fram och sade till honom: Herre, var det inte fin säd du sådde i din åker? Varifrån har den då ogräs? ");
INSERT INTO swessb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Men han sade till honom: En fiendeman har gjort detta. Och fasttjänarna säger till honom: Vill du då att vi går bort och plockar ihop dem? ");
INSERT INTO swessb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Men han säger: Nej, så att ni inte när ni plockar ihop ogräsen samtidigt med dem upprotar vetet. ");
INSERT INTO swessb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Låt båda växa tillsammans fram till skörden. Och vid skördetiden ska jag säga till skördemännen: Plocka först ihop ogräsen och bind dem i buntar för att bränna upp dem. Men vetet ska ni samla in i mitt förråd.” ");
INSERT INTO swessb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","En annan liknelse lade han fram för dem och sade: ”Himlarnas rike är likt ett senapskorn, som en man tog och sådde i sin åker. ");
INSERT INTO swessb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Det är mindre än alla fröna, men när det vuxit upp är det större än köksväxterna och blir ett träd, så att himlens fåglar kommer och sätter bo bland dess grenar.” ");
INSERT INTO swessb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","En annan liknelse talade han till dem: ”Himlarnas rike är likt en surdeg, som en kvinna tog och dolde i tre sea mjöl tills det hela blev syrat.” ");
INSERT INTO swessb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Allt detta talade Jesus i liknelser till skarorna. Och utan liknelser talade han inget till dem, ");
INSERT INTO swessb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","för att det skulle uppfyllas som var sagt genom profeten, som sade: Jag ska med liknelser öppna min mun,   spotta fram ting dolda   sedan världens grundläggning. ");
INSERT INTO swessb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sedan lämnade han skarorna och gick till huset. Och hans lärjungar kom fram till honom och sade: ”Förklara för oss liknelsen om ogräsen i åkern.” ");
INSERT INTO swessb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Och han svarade och sade: ”Den som sår den fina säden är Människosonen, ");
INSERT INTO swessb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","och åkern är världen. Och den fina säden, dessa är rikets barn, och ogräsen är den elakes barn. ");
INSERT INTO swessb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Och fienden som sådde dem är djävulen, och skörden är eonens fullbordan och skördemännen är änglar. ");
INSERT INTO swessb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Såsom ogräsen då plockas ihop och i eld bränns upp, så ska det bli vid eonens fullbordan. ");
INSERT INTO swessb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Människosonen ska sända ut sina änglar, och de ska plocka ihop ur hans rike alla skandalerna och dem som gör laglösheten ");
INSERT INTO swessb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","och kasta dem i eldens ugn. Där blir gråten och tandagnisslet. ");
INSERT INTO swessb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Då ska de rättfärdiga skina fram som solen i deras Fars rike. Den som har öron ska höra. ");
INSERT INTO swessb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Himlarnas rike är likt en skatt dold i åkern, som en människa fann och gömde igen. Och av sin glädje beger han sig och säljer allt vad han har och köper den åkern. ");
INSERT INTO swessb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Åter är himlarnas rike likt en köpman som söker fina pärlor. ");
INSERT INTO swessb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Och när han fann en värdefull pärla, gick han iväg och hade sålt allt vad han hade och köpte den. ");
INSERT INTO swessb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Åter är himlarnas rike likt ett dragnät som var kastat i havet och hade samlat fisk av varje släkte. ");
INSERT INTO swessb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","När det var uppfyllt, tog man upp det på stranden och satte sig och plockade ihop de fina i kar, men de ruttna kastade man ut. ");
INSERT INTO swessb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Så ska det bli vid eonens fullbordan. Änglarna ska gå ut och skilja bort de elaka från de rättfärdigas mitt ");
INSERT INTO swessb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","och kasta dem i eldens ugn. Där blir gråten och tandagnisslet. ");
INSERT INTO swessb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Har ni förstått allt detta?” De säger till honom: ”Ja.” ");
INSERT INTO swessb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Och han sade till dem: ”Därför är varje skriftlärd som blivit lärjunge till himlarnas rike lik en hushärskande man som kastar fram ur sin skattgömma både nytt och gammalt.” ");
INSERT INTO swessb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Och det hände sig, när Jesus hade fullbordat dessa liknelser, att han tog sig bort därifrån. ");
INSERT INTO swessb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Och han kom till sin fädernebygd och undervisade dem i deras synagoga så att de blev överväldigade och sade: ”Varifrån har denne den visheten och kraftgärningarna? ");
INSERT INTO swessb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Är inte denne snickarens son? Heter inte hans mor Maria och hans bröder Jakob och Josef och Simon och Judas? ");
INSERT INTO swessb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Och hans systrar, är de inte alla hos oss? Varifrån har då denne allt detta?” ");
INSERT INTO swessb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Och de blev skandaliserade av honom. Men Jesus sade till dem: ”En profet är inte ohedrad utom i sin fädernebygd och i sitt hus.” ");
INSERT INTO swessb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Och han gjorde där inte många kraftgärningar, på grund av deras otro. ");
INSERT INTO swessb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vid den tiden hörde tetrarken Herodes hörsägen om Jesus, ");
INSERT INTO swessb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","och han sade till sina gossar: ”Denne är Johannes Döparen. Han har blivit uppväckt från de döda, och därför verkar krafterna i honom.” ");
INSERT INTO swessb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","För Herodes hade gripit Johannes och bundit honom och satt bort i fängelse på grund av Hero­dias, hustru till Filippus hans bror. ");
INSERT INTO swessb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","För Johannes hade sagt till honom: ”Det är inte tillåtet för dig att ha henne.” ");
INSERT INTO swessb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Och han ville döda honom men fruktade skaran, eftersom de höll honom som en profet. ");
INSERT INTO swessb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Men när det blev Herodes födelsedag, dansade Hero­­dias dotter i mitten och behagade Herodes, ");
INSERT INTO swessb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","varför han med ed accepterade att ge henne vad hon än skulle be om. ");
INSERT INTO swessb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Och hon, ingiven av sin mor: ”Ge mig”, säger hon, ”här på ett fat Johannes Döparens huvud.” ");
INSERT INTO swessb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Och kungen blev bedrövad, men på grund av ederna och dem som låg till bords med honom befallde han att det skulle ges. ");
INSERT INTO swessb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Och han skickade och halshögg Johannes i fängelset, ");
INSERT INTO swessb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","och då bars hans huvud på ett fat och gavs åt flickan, och hon bar det till sin mor. ");
INSERT INTO swessb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Och hans lärjungar kom fram och tog liket och begravde honom, och gick och berättade för Jesus. ");
INSERT INTO swessb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Men när Jesus fick höra, drog han sig undan därifrån med båt till en öde plats enskilt. Och när skarorna fick höra, följde de honom till fots från städerna. ");
INSERT INTO swessb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Och när han steg ur såg han en stor skara, och han kände innerligt för dem och botade de kraftlösa bland dem. ");
INSERT INTO swessb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","När det blev kväll, kom lärjungarna fram till honom och sade: ”Platsen är ­­öde och timmen är redan förbi. Skicka iväg skarorna så att de går bort till byarna och köper sig matämnen.” ");
INSERT INTO swessb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Men Jesus sade till dem: ”De har inte behov att gå bort. Ge dem ni att äta.” ");
INSERT INTO swessb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Men de säger till honom: ”Vi har inget här utom fem bröd och två fiskar.” ");
INSERT INTO swessb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Och han sade: ”Bär hit dem till mig.” ");
INSERT INTO swessb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Och han befallde skarorna att lägga sig till bords på gräset, tog de fem bröden och de två fiskarna, såg upp mot himlen och välsignade. Och han bröt och gav bröden till lärjungarna, och lärjungarna till skarorna. ");
INSERT INTO swessb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Och alla åt och blev mätta. Och man tog upp det som blev över av bitarna, tolv korgar fulla. ");
INSERT INTO swessb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Och de som åt var omkring femtusen män, förutom kvinnor och barn. ");
INSERT INTO swessb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Och direkt nödgade han lärjungarna att stiga i båten och dra före till andra sidan, medan han skickar iväg skarorna. ");
INSERT INTO swessb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Och han skickade iväg skarorna och gick upp till berget enskilt för att bedja. Och när det blev kväll var han ensam där. ");
INSERT INTO swessb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Men båten var redan många stadier från land, plågad av vågorna, för vinden var emot. ");
INSERT INTO swessb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Och vid fjärde nattväkten kom han till dem, vandrande på havet. ");
INSERT INTO swessb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Och lärjungarna, när de såg honom vandrande på havet, blev oroade och sade att: ”Det är en fantom!”, och de skrek av fruktan. ");
INSERT INTO swessb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Men direkt talade Jesus till dem och sade: ”Fatta mod! Jag Är. Frukta inte.” ");
INSERT INTO swessb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Men Petrus svarade honom och sade: ”Herre, om Du Är, befall mig att komma till dig på vattnen.” ");
INSERT INTO swessb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Och han sade: ”Kom!” Och Petrus steg ner från båten och vandrade på vattnen och kom till Jesus. ");
INSERT INTO swessb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Men när han såg vinden stark fruktade han, och han började sjunka och skrek och sade: ”Herre, fräls mig!” ");
INSERT INTO swessb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Och direkt räckte Jesus ut handen och tog tag i honom, och säger till honom: ”Klentrogne. Varför tvekade du?” ");
INSERT INTO swessb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Och när de steg upp i båten, lade sig vinden. ");
INSERT INTO swessb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Och de i båten tillbad honom och sade: ”Sannerligen är du Guds Son!” ");
INSERT INTO swessb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Och de for över till andra sidan och kom i land vid Gennesaret. ");
INSERT INTO swessb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Och männen på den platsen kände igen honom och sände ut till hela den trakten runt omkring, och man förde till honom alla som hade det illa ");
INSERT INTO swessb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","och vädjade till honom att de bara skulle få röra hörntofsen på hans mantel. Och de som rörde blev genomfrälsta. ");
INSERT INTO swessb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sedan kommer det fram till Jesus från Jerusalem fariseer och skriftlärda och säger: ");
INSERT INTO swessb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","”Varför överträder dina lärjungar de äldstes tradition? För de tvättar inte sina händer när de äter bröd.” ");
INSERT INTO swessb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Men han svarade och sade till dem: ”Varför överträder också ni Guds bud för er traditions skull? ");
INSERT INTO swessb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","För Gud har sagt: Hedra fadern och modern, och: Den som talar illa om far eller mor ska döden dö. ");
INSERT INTO swessb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Men ni säger: Den som säger till fadern eller modern: En tempelgåva är nu det du kunde fått nytta av från mig, ");
INSERT INTO swessb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ska han alls inte hedra sin far. Och ni har ogiltigförklarat Guds ord för er traditions skull. ");
INSERT INTO swessb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hycklare, väl profeterade Jesaja om er och sade: ");
INSERT INTO swessb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Detta folk hedrar mig med läpparna,   men deras hjärta är fjärran från mig. ");
INSERT INTO swessb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Och fåfängt vördar de mig,   när de lär ut läror som är människors påbud.” ");
INSERT INTO swessb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Och han kallade till sig skaran och sade till dem: ”Hör och förstå: ");
INSERT INTO swessb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Det som kommer in i munnen vanhelgar inte människan. Men det som utgår ur munnen, detta vanhelgar människan.” ");
INSERT INTO swessb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Då kommer lärjungarna fram och säger till honom: ”Vet du att fariseerna, när de hörde ordet, blev skandaliserade?” ");
INSERT INTO swessb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Men han svarade och sade: ”Varje planta som inte min himmelske Far har planterat ska upprotas. ");
INSERT INTO swessb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Låt dem vara. De är blinda vägledare för blinda. Och om en blind vägleder en blind, faller båda i gropen.” ");
INSERT INTO swessb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Och Petrus svarade och sade till honom: ”Tyd för oss denna liknelse.” ");
INSERT INTO swessb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Men han sade: ”Är fortfarande också ni oförståndiga? ");
INSERT INTO swessb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Fattar ni inte att allt som går in i munnen får rum i buken och drivs ut på avträdet? ");
INSERT INTO swessb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Men det som utgår från munnen kommer ut från hjärtat, och detta vanhelgar människan. ");
INSERT INTO swessb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","För från hjärtat kommer det ut elaka tankar, mord, äktenskapsbrott, otuktigheter, stölder, falska vittnesbörd, hädelser. ");
INSERT INTO swessb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Detta är det som vanhelgar människan. Men att äta med otvättade händer vanhelgar inte människan.” ");
INSERT INTO swessb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Och Jesus gick ut därifrån och drog sig undan till trakterna vid Tyrus och Sidon. ");
INSERT INTO swessb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Och se: en kanaaneisk kvinna från det området kom ut och skrek och sade: ”Förbarma dig över mig, Herre Davids Son! Min dotter är illa demoniserad.” ");
INSERT INTO swessb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Men han svarade henne inte med ett ord. Och hans lärjungar kom fram och frågade honom och sade: ”Skicka iväg henne. För hon skriker bakom oss.” ");
INSERT INTO swessb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Men han svarade och sade: ”Jag är inte sänd utom till de förlorade fåren av Israels hus.” ");
INSERT INTO swessb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Men hon kom och tillbad honom och sade: ”Herre, hjälp mig!” ");
INSERT INTO swessb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Men han svarade och sade: ”Det är inte fint att ta brödet från barnen och kasta åt småhundarna.” ");
INSERT INTO swessb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Men hon sade: ”Jo, Herre. För även småhundarna äter av smulorna som faller från deras herrars bord.” ");
INSERT INTO swessb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Då svarade Jesus och sade till henne: ”O kvinna, stor är din tro. Det ska ske för dig som du vill.” Och hennes dotter helades från den stunden. ");
INSERT INTO swessb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Och Jesus gick vidare därifrån och gick längs Galileiska havet, och han gick upp till berget och satte sig där. ");
INSERT INTO swessb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Och det kom fram till honom stora skaror och hade med sig lama, blinda, handikappade, stumma och många andra och slängde dem vid hans fötter. Och han botade dem, ");
INSERT INTO swessb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","så att skaran var förundrad när de såg stumma tala, handikappade friska och lama gå och blinda se. Och de ärade Israels Gud. ");
INSERT INTO swessb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Men Jesus kallade till sig sina lärjungar och sade: ”Jag känner innerligt med folket. För det är redan tre dagar de är kvar hos mig, och de har inget att äta. Och skicka iväg dem fastande vill jag inte, så att de inte blir utmattade på vägen.” ");
INSERT INTO swessb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Och lärjungarna säger till honom: ”Var­ifrån får vi i en ödetrakt så många bröd för att mätta en så stor skara?” ");
INSERT INTO swessb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Och Jesus säger till dem: ”Hur många bröd har ni?” Och de sade: ”Sju. Och lite småfiskar.” ");
INSERT INTO swessb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Och han instruerade skaran att lägga sig till bords på jorden ");
INSERT INTO swessb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","och tog de sju bröden och fiskarna. Och han tackade och bröt och gav till lärjungarna, och lärjungarna till skarorna. ");
INSERT INTO swessb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Och alla åt och blev mätta, och det som blev över av bitarna tog man upp, sju vasskorgar fulla. ");
INSERT INTO swessb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Och de som åt var fyratusen män, förutom kvinnor och barn. ");
INSERT INTO swessb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Och han skickade iväg skarorna och steg i båten och kom till Magadans område. ");
INSERT INTO swessb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Och fariseerna och saddukeerna kom fram och testade och efterfrågade från honom att visa ett tecken från himlen för dem. ");
INSERT INTO swessb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Men han svarade och sade till dem: ”När det blir kväll säger ni: Fint väder, för himlen är eldröd. ");
INSERT INTO swessb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Och på morgonen: Idag oväder, för himlen är eldröd och mulen. Himlens ansikte förstår ni att urskilja, men tidernas tecken kan ni inte. ");
INSERT INTO swessb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ett elakt och otroget släkte söker ett tecken. Och ett tecken ska inte ges det utom Jonas tecken.” Och han lämnade dem och gick iväg. ");
INSERT INTO swessb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Och när lärjungarna kom till andra sidan hade de glömt att ta bröd. ");
INSERT INTO swessb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Och Jesus sade till dem: ”Se upp och akta er för fariseernas och saddukeernas surdeg.” ");
INSERT INTO swessb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Men de funderade bland sig och sade att: ”Bröd tog vi inga.” ");
INSERT INTO swessb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Men Jesus förstod och sade: ”Var­­för funderar ni bland er, klentrogna, över att det är bröd ni inte har? ");
INSERT INTO swessb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Fattar ni fortfarande inte? Och minns ni inte de fem bröden till de femtusen och hur många korgar ni fick? ");
INSERT INTO swessb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Eller de sju bröden till de fyratusen och hur många vasskorgar ni fick? ");
INSERT INTO swessb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hur kan ni inte fatta att det inte var om bröd jag talade till er? Men akta er för fariseernas och saddukeernas surdeg.” ");
INSERT INTO swessb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Då förstod de att han inte sade till att akta sig för surdegen i bröden, utan för fariseernas och saddukeernas lära. ");
INSERT INTO swessb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Och när Jesus kom till trakterna av Cae­sarea Filippi, frågade han sina lärjungar och sade: ”Vem säger människorna att Människosonen är?” ");
INSERT INTO swessb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Och de sade: ”Några Johannes Döparen, men andra Elia. Och andra Jeremia eller en av profeterna.” ");
INSERT INTO swessb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Han säger till dem: ”Och ni? Vem säger ni att jag är?” ");
INSERT INTO swessb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Och Simon Petrus svarade och sade: ”Du är Kristus. Den levande Gudens Son.” ");
INSERT INTO swessb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Och Jesus svarade och sade till honom: ”Salig är du, Simon Bar-Jona. För kött och blod har inte uppenbarat det för dig, utan min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Och jag säger dig att du är Petrus, och på denna klippa ska jag bygga min församling, och Hades portar ska inte bli den övermäktiga. ");
INSERT INTO swessb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jag ska ge dig nycklarna till himlarnas rike, och det du binder på jorden ska vara bundet i himlarna, och det du löser på jorden ska vara löst i himlarna.” ");
INSERT INTO swessb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sedan kommenderade han lärjungarna att inte säga till någon att han är Kristus. ");
INSERT INTO swessb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Från då började Jesus visa för sina lärjungar att han måste gå bort till Jerusalem och lida mycket från de äldste och översteprästerna och de skriftlärda och bli dödad, och den tredje dagen uppväckt. ");
INSERT INTO swessb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Och Petrus tog med honom och började näpsa honom och säga: ”Gud är försonlig mot dig, Herre! Aldrig ska detta ske för dig.” ");
INSERT INTO swessb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Men han vände sig och sade till Petrus: ”Bege dig efter mig, Satan! En skandal är du för mig, för du tänker inte på Guds ting utan människors.” ");
INSERT INTO swessb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sedan sade Jesus till sina lärjungar: ”Om någon vill komma efter mig, ska han förneka sig själv och ta upp sitt kors och följa mig. ");
INSERT INTO swessb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","För den som vill frälsa sin själ ska förlora den, men den som förlorar sin själ för min skull ska finna den. ");
INSERT INTO swessb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","För vilken nytta får en människa om han vinner hela världen men mister sin själ? Eller vad ska en människa ge i utbyte för sin själ? ");
INSERT INTO swessb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","För Människosonen ska komma i sin Fars härlighet med sina änglar, och då ska han löna var och en efter hans handlande. ");
INSERT INTO swessb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Amen, jag säger er att det finns några av dem som står här som inte ska smaka döden förrän de sett Människosonen komma i sitt rike.” ");
INSERT INTO swessb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Och efter sex dagar tar Jesus med sig Petrus och Jakob och Johannes hans bror, och för upp dem på ett högt berg enskilt. ");
INSERT INTO swessb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Och han förvandlades inför dem, och hans ansikte sken som solen och hans kläder blev vita som ljuset. ");
INSERT INTO swessb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Och se: då visade sig för dem Mose och Elia och samtalade med honom. ");
INSERT INTO swessb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Men Petrus svarade och sade till Jesus: ”Herre, det är fint att vi är här. Om du vill ska jag här göra tre hyddor: åt dig en, och åt Mose en, och åt Elia en.” ");
INSERT INTO swessb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Medan han ännu talade, se: ett upplyst moln överskuggade dem. Och se: en röst ur molnet som sade: ”Denne är min Son, den Älskade, i vilken jag funnit behag. Lyssna till honom!” ");
INSERT INTO swessb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Och när lärjungarna hörde det, föll de ner på sitt ansikte och fruktade mycket. ");
INSERT INTO swessb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Och Jesus gick fram och rörde vid dem och sade: ”Res er och frukta inte.” ");
INSERT INTO swessb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Och när de lyfte sina ögon, såg de ingen utom Jesus själv ensam. ");
INSERT INTO swessb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Och när de gick ner från berget, påbjöd Jesus dem och sade: ”Säg inte till någon om synen förrän Människosonen har uppväckts från de döda.” ");
INSERT INTO swessb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Och då frågade honom lärjungarna och sade: ”Varför säger då de skriftlärda att Elia måste komma först?” ");
INSERT INTO swessb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Och han svarade och sade: ”Elia kommer och ska återställa allt. ");
INSERT INTO swessb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Men jag säger er att Elia redan har kommit. Och de kände inte igen honom, utan gjorde med honom vad de ville. Så kommer också Människosonen att lida under dem.” ");
INSERT INTO swessb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Då förstod lärjungarna att det var om Johannes Döparen han sade det till dem. ");
INSERT INTO swessb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Och när de kom till skaran, kom det fram till honom en man som knäföll för honom ");
INSERT INTO swessb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","och sade: ”Herre, förbarma dig över min son, för han är månsjuk och lider illa. För många gånger faller han i elden och många gånger i vattnet. ");
INSERT INTO swessb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Och jag förde honom till dina lärjungar, och de kunde inte bota honom.” ");
INSERT INTO swessb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Och Jesus svarade och sade: ”O otroende och förvridna släkte, hur länge ska jag vara med er? Hur länge ska jag stå ut med er? För honom hit till mig.” ");
INSERT INTO swessb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Och Jesus näpste den, och demonen kom ut ur honom. Och gossen blev botad från den stunden. ");
INSERT INTO swessb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sedan kom lärjungarna fram till Jesus enskilt och sade: ”Varför kunde inte vi driva ut den?” ");
INSERT INTO swessb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Och han säger till dem: ”På grund av er klentro. För amen, jag säger er: Om ni har tro som ett senapskorn, ska ni säga till detta berg: Gå över härifrån dit, och det ska gå över. Och ingenting ska vara omöjligt för er.” ");
INSERT INTO swessb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Men när de var hopsamlade i Galileen sade Jesus till dem: ”Människosonen kommer att utlämnas i människors händer, ");
INSERT INTO swessb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","och de ska döda honom. Och den tredje dagen ska han bli uppväckt.” Och de blev mycket bedrövade. ");
INSERT INTO swessb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Men när de kom till Kaperna­um, kom de som tog upp dubbeldrakmorna fram till Petrus och sade: ”Fullbordar inte er lärare dubbeldrakmorna?” ");
INSERT INTO swessb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Han säger: ”Jo.” Och när han kom till huset, förekom honom Jesus och sade: ”Vad tänker du dig, Simon? Jordens kungar, från vilka tar de tullar eller huvudskatt? Från sina söner eller från främlingarna?” ");
INSERT INTO swessb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Och han sade: ”Från främlingarna.” Jesus sade till honom: ”Alltså är sönerna fria. ");
INSERT INTO swessb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Men för att vi inte ska skandalisera dem, gå till havet och kasta ut en krok och ta den först uppkommande fisken. Och när du öppnar dess mun, ska du finna en stater. Ta den och ge till dem för mig och dig.” ");
INSERT INTO swessb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","I den stunden kom lärjungarna fram till Jesus och sade: ”Vem är då störst i himlarnas rike?” ");
INSERT INTO swessb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Och han kallade till sig ett barn, och ställde det mitt ibland dem ");
INSERT INTO swessb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","och sade: ”Amen, jag säger er: Om ni inte vänder om och blir som barnen, kommer ni aldrig in i himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Den som alltså ödmjukar sig som detta barn, denne är den störste i himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Och den som välkomnar ett enda sådant barn vid mitt namn tar emot mig. ");
INSERT INTO swessb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Men den som skandaliserar en av dessa små som tror på mig, honom gagnar det att det hängs en ­åsnekvarnsten runt hans hals och han sjunker i öppna havet. ");
INSERT INTO swessb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ve världen för skandalerna! För det är nödtvång att skandalerna kommer, men ve den människa genom vilken skandalen kommer. ");
INSERT INTO swessb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Men om din hand eller din fot skandaliserar dig, hugg bort den och kasta ifrån dig. Det är bra för dig att gå in i livet handikappad eller halt, hellre än att ha två händer eller två fötter och kastas i den eoniska elden. ");
INSERT INTO swessb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Och om ditt öga skandaliserar dig, ta ut det och kasta ifrån dig. Det är bra för dig att enögd gå in i livet, hellre än att ha två ögon och kastas i eldens Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Se till att ni inte ringaktar en enda av dessa små. För jag säger er att deras änglar i himlarna ständigt ser ansiktet hos min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Vad tänker ni er? Om det finns hos en människa hundra får och ett av dem förvillar sig, lämnar han inte de nittionio på bergen och går och söker det förvillade? ");
INSERT INTO swessb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Och om det händer sig att han finner det – amen, jag säger er att han gläder sig över det mer än över de nittionio som inte var förvillade. ");
INSERT INTO swessb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Så är det inte vilja inför er Far i himlarna att det ska förloras en enda av dessa små. ");
INSERT INTO swessb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Men om din broder syndar mot dig, bege dig och tillrättavisa honom mellan dig och honom ensam. Om han lyssnar på dig, har du vunnit din broder. ");
INSERT INTO swessb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Men om han inte lyssnar, ta med dig en eller två mer, för att vid två vittnens mun eller tre ska varje sak stå fast. ");
INSERT INTO swessb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Och om han ohörsammar dem, säg till församlingen. Men om han ohörsammar även församlingen, ska han vara för dig såsom hedningen och tullindrivaren. ");
INSERT INTO swessb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Amen, jag säger er: Vad ni binder på jorden ska vara bundet i himlen, och vad ni löser på jorden ska vara löst i himlen. ");
INSERT INTO swessb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Åter: Amen, jag säger er att om två av er är samstämmiga på jorden om varje ärende som de ber om, ska det ske för dem från min Far i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","För där två eller tre är samlade i mitt namn, där är jag mitt ibland dem.” ");
INSERT INTO swessb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Då kom Petrus fram och sade till honom: ”Herre, hur många gånger ska min broder synda mot mig och jag förlåta honom? Ända till sju gånger?” ");
INSERT INTO swessb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus säger till honom: ”Jag säger dig inte till sju gånger, utan till sjuttio gånger och sju. ");
INSERT INTO swessb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Därför har himlarnas rike liknats vid en kungaman som ville stämma av räkenskap med si­na fasttjänare. ");
INSERT INTO swessb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Och när han började stämma av, fördes det fram till honom en som var skyldig tiotusen talenter. ");
INSERT INTO swessb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Men när han inte hade att betala, befallde herren att han skulle säljas, även hustrun och barnen och allt vad han har, och det skulle betalas. ");
INSERT INTO swessb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Då föll fasttjänaren ner och tillbad honom och sade: Var tålmodig med mig, och jag ska betala dig allt! ");
INSERT INTO swessb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Och då kände den fasttjänarens herre innerligt och frigav honom och förlät honom skulden. ");
INSERT INTO swessb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Men när den fasttjänaren gick ut, fann han en av sina medtjänare som var skyldig honom hundra denarer. Och han grep honom och började kväva honom och sade: Betala om du är skyldig något! ");
INSERT INTO swessb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hans medtjänare föll då ner och vädjade till honom och sade: Var tålmodig med mig, och jag ska betala dig! ");
INSERT INTO swessb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Men han ville inte, utan gick bort och kastade ­honom i fängelse tills han betalat det han var skyldig. ");
INSERT INTO swessb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","När nu hans medtjänare såg det som hände, blev de mycket bedrövade och gick och förklarade för sin herre allt som hade hänt. ");
INSERT INTO swessb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Då kallade hans herre honom till sig och säger till honom: Elake fasttjänare! All den skulden förlät jag dig då du vädjade till mig. ");
INSERT INTO swessb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Borde inte också du förbarma dig över din medtjänare, såsom också jag förbarmade mig över dig? ");
INSERT INTO swessb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Och hans herre vredgades och överlämnade honom till plågarna tills han betalt allt han var skyldig. ");
INSERT INTO swessb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Så ska också min himmelske Far göra med er, om ni inte förlåter var och en sin broder av era hjärtan.” ");
INSERT INTO swessb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Och det hände sig, när Jesus hade fullbordat dessa ord, att han tog sig bort från Galileen och gick till Judeens område på andra sidan Jordan. ");
INSERT INTO swessb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Och det följde honom stora skaror, och han botade dem där. ");
INSERT INTO swessb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Och det kom fram till honom fariseer som testade honom och sade: ”Om det är tillåtet för en man att förskjuta sin hustru för varje orsak?” ");
INSERT INTO swessb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Och han svarade och sade: ”Har ni inte läst att han som skapade från begynnelsen gjorde dem till hanne och hona? ");
INSERT INTO swessb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Och han sade: Därför ska en man lämna fadern och modern och ansluta sig till sin hustru, och de två ska vara till ett kött. ");
INSERT INTO swessb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Alltså är de inte längre två, utan ett kött. Det som nu Gud har okat samman ska en människa inte skilja åt.” ");
INSERT INTO swessb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","De säger till honom: ”Varför har då Mose påbjudit att ge ett skilsmässobrev och förskjuta henne?” ");
INSERT INTO swessb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Han säger till dem att: ”Mose har för er hårdhjärtadhet tillåtit er att förskjuta era hustrur. Men från begynnelsen har det inte varit så. ");
INSERT INTO swessb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Och jag säger er att den som förskjuter sin hustru, icke för otukt, och gifter sig med en annan ­begår äktenskapsbrott.” ");
INSERT INTO swessb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Då säger honom hans lärjungar: ”Om så är saken för mannen med kvinnan, gagnar det inte att gifta sig.” ");
INSERT INTO swessb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Och han sade till dem: ”Alla har inte rum för detta ord, utan de åt vilka det blivit givet. ");
INSERT INTO swessb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","För det finns eunucker som från moderlivet är födda så, och det finns eunucker som blivit kastrerade av människorna, och det finns eunucker som har kastrerat sig själva för himlarnas rikes skull. Den som kan ha rum, ska ha rum fördet.” ");
INSERT INTO swessb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sedan bar man fram till honom barn för att han skulle lägga händerna på dem och bedja. Men lärjungarna näpste dem. ");
INSERT INTO swessb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Men Jesus sade: ”Låt barnen vara och hindra dem inte att komma till mig. För sådanas är himlarnas rike.” ");
INSERT INTO swessb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Och han lade händerna på dem och gick därifrån. ");
INSERT INTO swessb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Och se: en kom fram till honom och sade: ”Lärare, vad gott ska jag göra för att ha eoniskt liv?” ");
INSERT INTO swessb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Men han sade till honom: ”Varför frågar du mig om det goda? En är den Gode. Och om du vill gå in i livet, håll fast vid buden.” ");
INSERT INTO swessb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Han säger till honom: ”Vilka?” Och Jesus sade: ”Du ska inte mörda. Du ska inte begå äktenskapsbrott. Du ska inte stjäla. Du ska inte vittna falskt. ");
INSERT INTO swessb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hedra fadern och modern. Och du ska älska din nästa som dig själv.” ");
INSERT INTO swessb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Den unge mannen säger till honom: ”Allt detta har jag iakttagit. Vad mer saknar jag?” ");
INSERT INTO swessb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus säger till honom: ”Om du vill vara fullkomlig, bege dig, sälj det som är ditt och ge till de fattiga, och du kommer att ha en skatt i himlarna. Och kom, följ mig.” ");
INSERT INTO swessb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Men när den unge mannen hörde ordet gick han bort bedrövad, för han hade många egendomar. ");
INSERT INTO swessb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Och Jesus sade till sina lärjungar: ”Amen, jag säger er att en rik svårligen ska komma in i himlarnas rike. ");
INSERT INTO swessb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Och åter säger jag er: Det är lättare att en kamel kommer genom ett nålsöga än att en rik kommer in i Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Men när lärjungarna hörde det, blev de mycket överväldigade och sade: ”Vem kan då bli frälst?” ");
INSERT INTO swessb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Och Jesus såg på dem och sade till dem: ”För människor är detta omöjligt. Men för Gud är allt möjligt.” ");
INSERT INTO swessb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Då svarade Petrus och sade till honom: ”Se: vi har lämnat allt och följt dig. Vad blir det då för oss?” ");
INSERT INTO swessb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Och Jesus sade till dem: ”Amen, jag säger er att ni som har följt mig ska vid pånyttfödelsen, när Människosonen sätter sig på sin härlighets tron, sitta också ni på tolv troner och döma Israels tolv stammar. ");
INSERT INTO swessb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Och var och en som har lämnat hus eller bröder eller systrar eller far eller mor eller barn eller åkrar för mitt namns skull, ska få hundrafalt och ärva eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Men många första ska bli sista, och sista första. ");
INSERT INTO swessb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","För himlarnas rike är likt en hushärskande man som gick ut samtidigt som morgonen för att anställa arbetare till sin vingård. ");
INSERT INTO swessb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Och han var samstämmig med arbetarna om en denar per dag och sände ut dem till sin vingård. ");
INSERT INTO swessb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Och han gick ut runt tredje timmen och såg andra stående på torget overksamma, ");
INSERT INTO swessb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","och till dessa sade han: Bege er också ni till vingården, och vad som är rätt ska jag ge er. ");
INSERT INTO swessb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Och de gick. Och åter gick han ut runt sjätte och nionde timmen och gjorde likadant. ");
INSERT INTO swessb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Och runt den elfte timmen gick han ut och fann andra stående, och säger till dem: Varför står ni här hela dagen overksamma? ");
INSERT INTO swessb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","De säger till honom: För att ingen har anställt oss. Han säger till dem: Bege er ni också till vingården. ");
INSERT INTO swessb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Och när det blir kväll, säger vingårdens herre till sin förman: Kalla på arbetarna och betala dem lönen, och börja från de sista till de första. ");
INSERT INTO swessb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Och när de runt elfte timmen kom, fick de var sin denar. ");
INSERT INTO swessb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Och när de första kom, antog de att de skulle få mer. Och de fick var sin denar, också de. ");
INSERT INTO swessb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Och när de fick den, muttrade de mot hushärskaren ");
INSERT INTO swessb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","och sade: Dessa sista har gjort en enda timme. Och du har gjort dem lika oss som har burit dagens tyngd och hettan. ");
INSERT INTO swessb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Men han svarade en av dem och sade: Kompis, jag gör inte orätt mot dig. Var det inte en denar du var samstämmig med mig om? ");
INSERT INTO swessb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ta det som är ditt och bege dig. Men jag vill ge till denne siste såsom även till dig. ");
INSERT INTO swessb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eller är det inte tillåtet för mig att göra vad jag vill med det som är mitt? Eller är ditt öga elakt för att jag är god? ");
INSERT INTO swessb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Så ska de sista bli första och de första sista.” ");
INSERT INTO swessb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Och när Jesus gick upp till Jerusalem tog han med de tolv lärjungarna enskilt, och på vägen sade han till dem: ");
INSERT INTO swessb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","”Se: vi går upp till Jerusalem, och Människosonen ska utlämnas till översteprästerna och de skriftlärda. Och de ska fördöma honom till döden ");
INSERT INTO swessb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","och utlämna honom åt folkslagen till att förlöjliga och piska och korsfästa. Och den tredje dagen ska han uppstå.” ");
INSERT INTO swessb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Då kom modern till Sebedeus söner fram till honom med sina söner, och hon tillbad och bad om något från honom. ");
INSERT INTO swessb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Och han sade till henne: ”Vad vill du?” Hon säger till honom: ”Säg att dessa mina två söner får sitta en vid din högra sida och en vid din vänstra i ditt rike.” ");
INSERT INTO swessb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Men Jesus svarade och sade: ”Ni vet inte vad ni ber om. Kan ni dricka den ­bägare som jag ska dricka?” De säger till honom: ”Vi kan.” ");
INSERT INTO swessb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Han säger till dem: ”Min bägare ska ni dricka. Men att sitta vid min högra sida och vid vänstra, detta är inte mitt att ge, utan för dem åt vilka det beretts av min Far.” ");
INSERT INTO swessb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Och när de tio hörde, blev de indignerade över de två bröderna. ");
INSERT INTO swessb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Men Jesus kallade dem till sig och sade: ”Ni vet att folkslagens ledare dominerar dem och de stora utövar makt över dem. ");
INSERT INTO swessb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Så ska det inte vara bland er. Nej, den som bland er vill bli stor ska vara er tjänare, ");
INSERT INTO swessb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","och den som bland er vill vara först ska vara er fasttjänare, ");
INSERT INTO swessb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","såsom Människosonen inte har kommit för att bli betjänad, utan betjäna och ge sin själ till lösen för många.” ");
INSERT INTO swessb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Och när de gick ut från Jeriko följde honom en stor skara, ");
INSERT INTO swessb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","och se: två blinda satt vid vägen och hörde att Jesus passerar förbi, och de skrek och sade: ”Förbarma dig över oss, Herre, Davids son!” ");
INSERT INTO swessb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Och skaran näpste dem, att de skulle vara tysta. Men de skrek desto mer och sade: ”Förbarma dig över oss, Herre, Davids son!” ");
INSERT INTO swessb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Och Jesus stannade och ropade på dem och sade: ”Vad vill ni jag ska göra för er?” ");
INSERT INTO swessb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","De säger till honom: ”Herre, att man öppnar våra ögon!” ");
INSERT INTO swessb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Och Jesus kände innerligt och rörde vid deras ögon, och direkt såg de igen. Och de följde honom. ");
INSERT INTO swessb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Och när de närmade sig Jerusalem och kom till Betfage mot Oliv­berget, då sände Jesus ut två lärjungar ");
INSERT INTO swessb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","och sade till dem: ”Gå in i byn mittemot er, och direkt ska ni finna en åsna bunden och ett föl med henne. Lossa och led till mig. ");
INSERT INTO swessb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Och om någon säger till er något, ska ni säga att Herren har behov av dem, och direkt ska han sända dem.” ");
INSERT INTO swessb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Och detta har hänt för att det skulle uppfyllas som var sagt genom profeten, som sade: ");
INSERT INTO swessb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Säg till dottern Sion:   Se: din kung kommer till dig,   mild och uppsutten på en åsna   och på ett föl, ett lastdjurs unge. ");
INSERT INTO swessb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Och lärjungarna gick och gjorde så som Jesus hade samordnat för dem, ");
INSERT INTO swessb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","de ledde åsnan och fölet och lade på dem mantlarna. Och han satte sig ovanpå dem. ");
INSERT INTO swessb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Och den synnerligen stora skaran bredde ut sina mantlar på vägen, och andra slog kvistar från träden och bredde ut på vägen. ");
INSERT INTO swessb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Och skarorna som gick före honom och de som följde skrek och sade: ”Hosianna till Davids son! Välsignad är han som kommer i Herrens namn. Hosianna i det högsta!” ");
INSERT INTO swessb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Och när han kom in i Jerusalem, bävade hela staden och sade: ”Vem är denne?” ");
INSERT INTO swessb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Och skarorna svarade: ”Denne är Profeten, Jesus från Nasaret i Galileen.” ");
INSERT INTO swessb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Och Jesus gick in i templet och drev ut alla som sålde och köpte i templet. Och växlarnas bord välte han och stolarna för dem som sålde duvorna, ");
INSERT INTO swessb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","och han säger till dem: ”Det är skrivet: Mitt hus ska kallas ett bönens hus. Men ni gör det tillenrövargrotta!” ");
INSERT INTO swessb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Och det kom fram till honom blinda och lama i templet, och han botade dem. ");
INSERT INTO swessb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Men när översteprästerna och de skriftlärda såg det förunderliga som han gjorde och gossarna som skrek i templet och sade: ”Hosianna till Davids son!”, blev de indignerade ");
INSERT INTO swessb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","och sade till honom: ”Hör du vad dessa säger?” Och Jesus säger till dem: ”Ja. Har ni aldrig läst att: Av småbarns och diandes mun har du förfärdigat lov?” ");
INSERT INTO swessb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Och han lämnade dem och gick ut utanför staden till Betania och övernattade där. ");
INSERT INTO swessb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Men när han på morgonen satte ut mot staden blev han hungrig. ");
INSERT INTO swessb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Och han såg ett fikonträd vid vägen och gick till det, och fann inget på det utom bara löv. Och han säger till det: ”Aldrig mer ska det från dig komma frukt till eonen.” Och genast vissnade fikonträdet. ");
INSERT INTO swessb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Och när lärjungarna såg, var de förundrade och sade: ”Hur vissnade fikonträdet genast?” ");
INSERT INTO swessb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Och Jesus svarade och sade till dem: ”Amen, jag säger er: Om ni har tro och inte tvivlar, ska ni göra inte bara detta med fikonträdet. Nej, även om ni säger till detta berg: Var lyft och kastad i havet, ska det ske. ");
INSERT INTO swessb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Och allt vad ni ber om i bönen och tror ska ni få.” ");
INSERT INTO swessb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Och när han kommit till templet, kom översteprästerna och folkets äldste fram till honom medan han undervisade och sade: ”Med vilken auktoritet gör du detta? Och vem har gett dig denna auktoritet?” ");
INSERT INTO swessb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Men Jesus svarade och sade till dem: ”Jag ska fråga er, också jag, en sak. Om ni säger mig det, ska också jag säga er med vilken auktoritet jag gör detta. ");
INSERT INTO swessb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Johannes dop, varifrån var det? Från himlen? Eller från människor?” Och de funderade bland sig och sade: ”Om vi säger: Från himlen, kommer han att säga till oss: Varför trodde ni då inte på honom? ");
INSERT INTO swessb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Men om vi säger: Från människor, fruktar vi folket. För alla håller Johannes som profet.” ");
INSERT INTO swessb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Och de svarade Jesus och sade: ”Vi vet inte.” Han sade till dem, också han: ”Inte heller jag säger er med vilken auktoritet jag gör detta.” ");
INSERT INTO swessb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","”Men vad tänker ni er? En man hade två söner. Och han gick till den förste och sade: Barn, bege dig idag och arbeta i vingården. ");
INSERT INTO swessb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Men han svarade och sade: Jag vill inte. Men till sist ångrade han sig och gick iväg. ");
INSERT INTO swessb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Och han gick till den andre och sade på samma sätt. Och han svarade och sade: Jag gör det, herre. Och han gick inte iväg. ");
INSERT INTO swessb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Vem av de två gjorde faderns vilja?” De säger: ”Den förste.” Jesus säger till dem: ”Amen, jag säger er att tullindrivarna och skökorna går före er in i Guds rike. ");
INSERT INTO swessb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","För Johannes kom till er på rättfärdighetens väg, och ni trodde inte på honom. Men tullindrivarna och skökorna trodde på honom. Och ni såg det, men ångrade er inte ens till sist för att tro på honom. ");
INSERT INTO swessb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hör en annan liknelse: Det fanns en hushärskande man som planterade en vingård och satte stängsel runt den och grävde i den en vinpress och byggde ett torn och arrenderade ut den till odlare och reste bort. ");
INSERT INTO swessb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Men när frukternas tid närmade sig, sände han sina fasttjänare till odlarna för att få sina frukter. ");
INSERT INTO swessb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Och odlarna tog hans fasttjänare: en pryglade de, och en dödade de, och en kaststenade de. ");
INSERT INTO swessb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Åter sände han andra fasttjänare, fler än de första. Och de gjorde mot dem på samma sätt. ");
INSERT INTO swessb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Men till sist sände han till dem sin son och sade: De kommer att ha respekt för min son. ");
INSERT INTO swessb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Men odlarna, när de såg sonen, sade inom sig: Denne är arvtagaren! Kom, låt oss döda honom och få hans arv. ");
INSERT INTO swessb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Och de tog honom och kastade ut utanför vingården och dödade. ");
INSERT INTO swessb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","När nu vingårdens herre kommer, vad ska han göra med dessa odlare?” ");
INSERT INTO swessb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","De säger till honom: ”De onda ska han ont förgöra, och vingården ska han arrendera ut till andra odlare som avger åt honom frukterna vid sina tider.” ");
INSERT INTO swessb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus säger till dem: ”Har ni aldrig läst i Skrifterna: Stenen som husbyggarna förkastade,  den har blivit till en hörnsten.   Från Herren har den kommit,   och den är förunderlig i våra ögon.  ");
INSERT INTO swessb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Därför säger jag er att Guds rike ska tas bort från er och ges till ett folkslag som gör dess frukter. ");
INSERT INTO swessb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Och den som faller på den stenen ska bli sönderkrossad, men honom på vilken den faller ska den söndersmula.” ");
INSERT INTO swessb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Och när översteprästerna och fariseerna hörde hans liknelser, förstod de att det var om dem han talade. ");
INSERT INTO swessb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Och de sökte gripa honom men fruktade skarorna, då man höll honom för profet. ");
INSERT INTO swessb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Och Jesus svarade åter och talade i liknelser till dem och sade: ");
INSERT INTO swessb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","”Himlarnas rike har liknats vid en kungaman som gjorde bröllopsfest för sin son. ");
INSERT INTO swessb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Och han sände ut sina fasttjänare att kalla de inbjudna till bröllopsfesten. Och de ville inte komma. ");
INSERT INTO swessb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Åter sände han ut andra fasttjänare och sade: Säg till de inbjudna: Se, min lunch har jag berett. Mina tjurar och göddjur är slaktoffrade och allt är berett. Kom till bröllopsfesten! ");
INSERT INTO swessb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Men de brydde sig inte utan gick iväg: en till den egna åkern, en annan till sina affärer. ");
INSERT INTO swessb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Och de övriga grep hans fasttjänare och skymfade och dödade. ");
INSERT INTO swessb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Men kungen vredgades och skickade sina trupper och förgjorde dessa mördare, och deras stad stack han i brand. ");
INSERT INTO swessb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sedan säger han till sina fasttjänare: Bröllopet är berett, men de inbjudna var inte värdiga. ");
INSERT INTO swessb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gå nu till vägarnas utvägar, och dem ni finner, bjud dem till bröllopsfesten. ");
INSERT INTO swessb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Och dessa fasttjänare gick ut på vägarna och samlade alla som de fann, både elaka och goda. Och bröllopet fylldes med dem som låg till bords. ");
INSERT INTO swessb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Men när kungen kom in för att skåda dem som låg till bords, såg han där en man inte iklädd bröllopsklädsel. ");
INSERT INTO swessb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Och han säger till honom: Kompis, hur kom du in hit när du inte har bröllopsklädsel? Men han var tilltäppt. ");
INSERT INTO swessb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Då sade kungen till tjänarna: Bind hans fötter och händer och kasta ut honom i det yttre mörkret! Där blir gråten och tandagnisslet. ");
INSERT INTO swessb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","För många är kallade, men få är utvalda.” ");
INSERT INTO swessb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Då gick fariseerna och tog beslut om att snärja honom med ord. ");
INSERT INTO swessb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Och de sänder till honom sina lärjungar med herodianerna och säger: ”Lärare, vi vet att du är sann och lär ut Guds väg i sanning och inte bryr dig om någon, för du ser inte till människors ansikte. ");
INSERT INTO swessb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Säg oss nu, vad tycker du: Är det tillåtet att ge huvudskatt till kejsaren eller inte?” ");
INSERT INTO swessb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Men Jesus förstod deras elakhet och sade: ”Varför testar ni mig, hycklare? ");
INSERT INTO swessb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Visa mig myntet för huvudskatten.” Och de bar fram till honom en denar, ");
INSERT INTO swessb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","och han säger till dem: ”Vems är denna bild och överskrift?” ");
INSERT INTO swessb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","De säger till honom: ”Kejsarens.” Då säger han till dem: ”Avge då det som är kejsarens till kejsaren, och det som är Guds till Gud.” ");
INSERT INTO swessb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Och när de hörde det, var de förundrade och lämnade honom och gick iväg. ");
INSERT INTO swessb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Den dagen kom det fram till honom saddukeer, som säger att uppståndelse inte finns, och frågade honom ");
INSERT INTO swessb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","och sade: ”Lärare, Mose har sagt: Om någon dör och inte har barn, ska hans bror släktgifta sig med hans hustru och låta säd uppstå åt sin bror. ");
INSERT INTO swessb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Och det fanns hos oss sju bröder. Och den förste gifte sig och avled, och då han inte hade säd lämnade han sin hustru åt sin bror. ");
INSERT INTO swessb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Likaså även den andre och den tredje, till alla sju. ");
INSERT INTO swessb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Och sist av alla dog kvinnan. ");
INSERT INTO swessb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vid uppståndelsen, till vem av de sju blir hon då hustru? För alla hade henne.” ");
INSERT INTO swessb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Men Jesus svarade och sade till dem: ”Ni förvillar er, då ni inte förstår Skrifterna eller Guds makt. ");
INSERT INTO swessb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","För vid uppståndelsen varken gifter de sig eller blir bortgifta, utan är som änglar i himlen. ");
INSERT INTO swessb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Men om de dödas uppståndelse: har ni inte läst det som är sagt till er av Gud när han sade: ");
INSERT INTO swessb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Jag är Abrahams Gud och Isaks Gud och Jakobs Gud? Han är inte dödas Gud, utan levandes.” ");
INSERT INTO swessb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Och när skarorna hörde det, var de överväldigade vid hans undervisning. ");
INSERT INTO swessb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Men fariseerna hörde att han hade täppt till saddukeerna och samlades tillsammans. ");
INSERT INTO swessb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Och en av dem, en laglärd, frågade och testade honom: ");
INSERT INTO swessb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","”Lärare, vilket bud är stort i lagen?” ");
INSERT INTO swessb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Och han sade till honom: ”Du ska älska Herren din Gud med hela ditt hjärta, och med hela din själ, och med hela ditt förnuft. ");
INSERT INTO swessb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Detta är det stora och första budet. ");
INSERT INTO swessb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Och ett andra är likt det: Du ska älska din nästa som dig själv. ");
INSERT INTO swessb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","På dessa två bud hänger hela lagen och profeterna.” ");
INSERT INTO swessb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Och när fariseerna var samlade, frågade Jesus dem ");
INSERT INTO swessb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","och sade: ”Vad tänker ni er om Kristus? Vems son är han?” De säger till honom: ”Davids.” ");
INSERT INTO swessb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Han säger till dem: ”Hur kan då David i Anden kalla honom Herre och säga: ");
INSERT INTO swessb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Herren sade till min Herre:   Sitt vid min högra sida   tills jag lagt dina fiender   under dina fötter? ");
INSERT INTO swessb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Om nu David kallar honom Herre, hur är han hans son?” ");
INSERT INTO swessb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Och ingen kunde svara honom ett ord. Inte heller vågade någon från den dagen fråga honom längre. ");
INSERT INTO swessb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sedan talade Jesus till skarorna och till sina lärjungar ");
INSERT INTO swessb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","och sade: ”På Moses stol har de skriftlärda och fariseerna satt sig. ");
INSERT INTO swessb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Allt vad de säger till er ska ni därför göra och hålla fast vid. Men efter deras gärningar ska ni inte göra, för de talar och gör inte. ");
INSERT INTO swessb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Och de buntar ihop tunga och svårburna bördor och lägger på män­niskornas axlar. Men själva vill de inte med sitt finger flytta på dem. ");
INSERT INTO swessb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Och alla sina gärningar gör de för att bli skådade av människorna. För de vidgar sina böneremmar och förstorar hörntofsarna, ");
INSERT INTO swessb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","och de gillar förstaplatsen vid måltiderna och förstapositionerna i synagogorna ");
INSERT INTO swessb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","och hälsningarna på torgen och att kallas av män­niskorna rabbi. ");
INSERT INTO swessb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Men ni ska inte bli kallade ­rab­bi, för en är er lärare och alla är ni syskon. ");
INSERT INTO swessb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Och er fader ska ni inte kalla någon på jorden, för en är er Far, den himmelske. ");
INSERT INTO swessb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Inte heller ska ni kallas vägledare, för er vägledare är en, Kristus. ");
INSERT INTO swessb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nej, den som är störst av er ska vara er tjänare. ");
INSERT INTO swessb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Och den som upphöjer sig själv ska bli ödmjukad, och den som ödmjukar sig själv ska bli upphöjd. ");
INSERT INTO swessb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Men ve er, skriftlärda och fariseer, hycklare! För ni stänger himlarnas rike framför människorna. För ni går inte in, och inte heller dem som vill gå in låter ni gå in. ");
INSERT INTO swessb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ve er, skriftlärda och fariseer, hycklare! För ni far omkring havet och det torra för att göra en enda proselyt. Och när han blivit det, gör ni honom till en Gehennas son, dubbelt mer än ni. ");
INSERT INTO swessb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ve er, blinda vägledare som säger: Den som svär vid tempelbyggnaden, det är inget, men den som svär vid guldet i tempelbyggnaden är pliktig. ");
INSERT INTO swessb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dårar och blinda! För vad är störst: guldet eller tempelbyggnaden som helgat guldet? ");
INSERT INTO swessb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Och: Den som svär vid altaret, det är inget, men den som svär vid gåvan ovanpå det är pliktig. ");
INSERT INTO swessb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Blinda! För vad är störst: gåvan eller altaret som helgar gåvan? ");
INSERT INTO swessb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Den som alltså svär vid altaret svär vid det och vid allt ovanpå det, ");
INSERT INTO swessb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","och den som svär vid tempelbyggnaden svär vid den och vid honom som bor i den, ");
INSERT INTO swessb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","och den som svär vid himlen svär vid Guds tron och vid honom som sitter ovanpå den. ");
INSERT INTO swessb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ve er, skriftlärda och fariseer, hycklare! För ni ger tionde av myntan och dillen och kumminen men har lämnat det tyngre i lagen: rätten och barmhärtigheten och troheten. Men detta borde man göra och inte lämna det andra. ");
INSERT INTO swessb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Blinda vägledare, som silar myggan och uppslukar kamelen. ");
INSERT INTO swessb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ve er, skriftlärda och fariseer, hycklare! För ni renar det yttre av bägaren och fatet, men inuti är de fulla av rofferi och obehärskning. ");
INSERT INTO swessb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Blinde farisé, rena först det som är inom bägaren, så att även det utom den blir rent. ");
INSERT INTO swessb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ve er, skriftlärda och fariseer, hycklare! För ni liknar vitkalkade gravkammare, som utanpå visar sig sköna men inuti är fulla av dödas ben och all orenhet. ");
INSERT INTO swessb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Så också ni: utanpå visar ni er för människorna rättfärdiga, men inuti är ni fulla av hyckleri och laglöshet. ");
INSERT INTO swessb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ve er, skriftlärda och fariseer, hycklare! För ni bygger profeternas gravkammare och smyckar de rättfärdigas gravar ");
INSERT INTO swessb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","och säger: Om vi hade funnits under våra fäders dagar, hade vi inte varit delaktiga i profeternas blod. ");
INSERT INTO swessb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Alltså vittnar ni om er själva att ni är söner till dem som mördade profeterna. ");
INSERT INTO swessb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Uppfyll också ni era fäders mått. ");
INSERT INTO swessb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ormar, huggormsyngel, hur ska ni fly från Gehennas dom? ");
INSERT INTO swessb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Därför: se, jag sänder till er profeter och vise och skriftlärda. Några av dem kommer ni att döda och korsfästa, och några av dem kommer ni att piska i era ­synagogor och förfölja från stad till stad, ");
INSERT INTO swessb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","så att det kommer över er allt rättfärdigt blod utgjutet på jorden, från blodet av Abel den rättfärdige till blodet av Sakarja Berekjas son, som ni mördade mellan tempelbyggnaden och altaret. ");
INSERT INTO swessb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Amen, jag säger er: Allt detta ska komma över detta släkte. ");
INSERT INTO swessb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem, Jerusalem, du som dödar profeterna och kaststenar dem som är sända till dig! Hur många gånger har jag velat församla dina barn, på samma sätt som en höna församlar sina kycklingar under vingarna. Och ni ville inte. ");
INSERT INTO swessb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Se: nu lämnas åt er ert hus öde. ");
INSERT INTO swessb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","För jag säger er: Ni ska inte se mig från nu förrän ni säger: Välsignad han som kommer i Herrens namn.” ");
INSERT INTO swessb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Och Jesus gick ut från templet och började gå, och hans lärjungar kom fram för att visa honom tempelplatsens byggnader. ");
INSERT INTO swessb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Men han svarade och sade till dem: ”Ser ni inte allt detta? Amen, jag säger er: Här ska inte lämnas sten på sten som inte ska rivas ner.” ");
INSERT INTO swessb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Och när han satt på Olivberget, kom lärjungarna fram till honom enskilt och sade: ”Säg oss, när ska detta ske? Och vad blir tecknet på din närvaro och eonens fullbordan?” ");
INSERT INTO swessb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Och Jesus svarade och sade till dem: ”Se upp att ingen förvillar er. ");
INSERT INTO swessb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","För många ska komma vid mitt namn och säga: Jag är Kristus, och många ska de förvilla. ");
INSERT INTO swessb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Och ni kommer att höra krig och hörsägner om krig. Se till att ni inte blir skärrade. För det måste ske, men det är ännu inte slutet. ");
INSERT INTO swessb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","För folkslag ska resa sig mot folkslag och rike mot rike, och det ska bli svälter och jordbävningar på olika platser. ");
INSERT INTO swessb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Men allt detta är våndors begynnelse. ");
INSERT INTO swessb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Då ska man utlämna er till nöd och döda er, och ni ska bli hatade av alla folkslagen för mitt namns skull. ");
INSERT INTO swessb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Och då ska många bli skandaliserade och utlämna varandra och hata varandra. ");
INSERT INTO swessb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Och många falska profeter ska resa sig och förvilla många, ");
INSERT INTO swessb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","och eftersom laglösheten förökas ska de mångas kärlek svalna. ");
INSERT INTO swessb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Men den som håller ut till slutet, denne ska bli frälst. ");
INSERT INTO swessb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Och detta evangelium om riket ska förkunnas i hela den bebodda världen till ett vittnesbörd för alla folkslagen. Och sedan ska slutet komma. ");
INSERT INTO swessb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","När ni då ser ödeläggelsens skändlighet, sagd genom profeten Daniel, stå på helig plats – läsaren må fatta – ");
INSERT INTO swessb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","då ska de i Judeen fly till bergen. ");
INSERT INTO swessb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Den på ­taket ska inte gå ner för att ta upp något från sitt hus, ");
INSERT INTO swessb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","och den på åkern ska inte vända om bakåt för att ta upp sin mantel. ");
INSERT INTO swessb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Men ve dem som är havande i magen och dem som ammar i de dagarna! ");
INSERT INTO swessb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Och bed att er flykt inte blir under vinter eller sabbat. ");
INSERT INTO swessb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","För det ska då bli en så stor nöd som inte varit från världens begynnelse ända fram till nu, och aldrig heller kommer att ske. ");
INSERT INTO swessb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Och om inte de dagarna hade förkortats, skulle inget kött bli frälst. Men för de utvaldas skull ska de dagarna förkortas. ");
INSERT INTO swessb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Då, om någon säger till er: Se här är Kristus! eller: Här! – tro det inte. ");
INSERT INTO swessb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","För det ska resa sig falska Kristusar och falska profeter och ge stora tecken och under så att det förvillar, om möjligt, också de utvalda. ");
INSERT INTO swessb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Se: jag har förutsagt det för er. ");
INSERT INTO swessb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Om man då säger till er: Se, han är i ödemarken! – gå inte ut – Se, i kamrarna! – tro det inte. ");
INSERT INTO swessb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","För såsom blixten går ut från öster och lyser ända till väster, så ska Människosonens närvaro vara. ");
INSERT INTO swessb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Där liket är, där samlas örnarna. ");
INSERT INTO swessb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Men direkt efter nöden under de dagarna ska ­solen förmörkas och månen inte ge sitt sken, och stjärnorna falla från himlen och himlarnas makter skakas. ");
INSERT INTO swessb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Och då ska Människosonens ­tecken lysa på himlen, och då ska jordens alla stammar slå sig själva och se Människosonen komma på himlens moln med stor makt och härlighet. ");
INSERT INTO swessb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Och han ska sända ut sina änglar med en väldig basun, och de ska församla hans utvalda från de fyra vindarna, från himlarnas ändar till deras andra ändar. ");
INSERT INTO swessb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Och från fikonträdet ska ni lära er liknelsen: Redan när dess kvist blir mjuk och skjuter fram löven vet ni att sommaren är nära. ");
INSERT INTO swessb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Så också ni: när ni ser allt detta, vet ni att han är nära vid dörrarna. ");
INSERT INTO swessb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Amen, jag säger er att detta släkte inte ska förgå förrän allt detta har skett. ");
INSERT INTO swessb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Himlen och jorden ska förgå, men mina ord ska aldrig förgå. ");
INSERT INTO swessb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Men om den dagen och stunden vet ingen, varken himlarnas änglar eller Sonen, utom Fadern ensam. ");
INSERT INTO swessb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","För såsom Noas dagar, så ska Människosonens närvaro vara. ");
INSERT INTO swessb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","För såsom de var under de dagarna före störtfloden – de tuggade och drack, gifte sig och blev bortgifta ända till den dag Noa gick in i arken, ");
INSERT INTO swessb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","och de visste inte förrän störtfloden kom och tog bort allihop – så ska också Människosonens närvaro vara. ");
INSERT INTO swessb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Då ska två vara på åkern: en tas med och en lämnas. ");
INSERT INTO swessb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Två malerskor vid kvarnen: en tas med och en lämnas. ");
INSERT INTO swessb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Var då vakna, för ni vet inte vilken dag er Herre kommer. ");
INSERT INTO swessb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Men det förstår ni att om hushärskaren visste vilken nattväkt tjuven kommer, hade han varit vaken och inte låtit sitt hus bli inbrutet. ");
INSERT INTO swessb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Därför ska också ni vara beredda, för vid en stund ni inte tänker er kommer Människosonen. ");
INSERT INTO swessb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Vem är då den trogne fasttjänaren, den kloke, som Herren har satt över sitt hustjänstefolk för att ge dem födan i rätt tid? ");
INSERT INTO swessb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Salig den fasttjänaren som hans herre kommer och finner görande så. ");
INSERT INTO swessb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Amen, jag säger er att över allt som är hans ska han sätta honom. ");
INSERT INTO swessb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Men om denne onde fasttjänare säger i sitt hjärta: Min herre dröjer, ");
INSERT INTO swessb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","och han börjar slå sina medtjänare och äter och dricker med de berusade, ");
INSERT INTO swessb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ska den fasttjänarens herre komma vid en dag som han inte väntar sig och i en stund som han inte vet om, ");
INSERT INTO swessb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","och han ska hugga honom itu och sätta hans andel med hycklarna. Där blir gråten och tandagnisslet. ");
INSERT INTO swessb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Då ska himlarnas rike liknas vid tio jungfrur som tog sina lampor och gick ut till möte med brudgummen. ");
INSERT INTO swessb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Men fem av dem var dåraktiga och fem kloka. ");
INSERT INTO swessb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","För de dåraktiga tog sina lampor men tog inte med sig olja, ");
INSERT INTO swessb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","men de kloka tog olja i flaskorna med sina lampor. ");
INSERT INTO swessb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Och när brudgummen dröjde, dåsade alla till och somnade. ");
INSERT INTO swessb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Men vid midnatt kom ett skri: Se, brud­gummen! Kom ut till möte med honom! ");
INSERT INTO swessb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Då reste sig alla dessa jungfrur och snyggade till sina lampor. ");
INSERT INTO swessb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Men de dåraktiga sade till de kloka: Ge oss av er olja, för våra lampor slocknar! ");
INSERT INTO swessb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Men de kloka svarade och sade: Nej, annars räcker det aldrig till oss och till er. Gå snarare till dem som säljer och köp åt er. ");
INSERT INTO swessb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Men när de gick iväg för att köpa kom brudgummen, och de som var beredda gick in med honom till bröllopsfesten och dörren stängdes. ");
INSERT INTO swessb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Men till sist kommer också de övriga jungfrurna och säger: Herre, Herre, öppna för oss! ");
INSERT INTO swessb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Men han svarade och sade: Amen, jag säger er: Jag känner er inte. ");
INSERT INTO swessb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Var därför vakna, för ni vet inte dagen eller stunden. ");
INSERT INTO swessb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","För det blir såsom en man som reste bort och kallade de egna fasttjänarna och överlämnade åt dem det som var hans. ");
INSERT INTO swessb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Och till en gav han fem talenter, till en annan två, till en annan en, åt var och en efter den egna förmågan, och reste bort. Direkt ");
INSERT INTO swessb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","gick den som fått de fem talenterna och arbetade med dem och vann fem andra. ");
INSERT INTO swessb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","På samma sätt den med de två, han vann två andra. ");
INSERT INTO swessb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Men den som fått den enda gick bort och grävde i jorden och dolde sin herres silver. ");
INSERT INTO swessb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Och efter lång tid kommer dessa fasttjänares herre och stämmer av räkenskap med dem. ");
INSERT INTO swessb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Och den som fått de fem talenterna kom fram och bar fram fem talenter till och sade: Herre, fem talenter överlämnade du åt mig. Se: fem andra talenter har jag vunnit. ");
INSERT INTO swessb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hans herre sade till honom: Bra, gode och trogne fasttjänare! Över lite var du trogen, över mycket ska jag sätta dig. Gå in i din herres glädje! ");
INSERT INTO swessb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Och även den med de två talenterna kom fram och sade: Herre, två talenter överlämnade du åt mig. Se: två andra talenter har jag vunnit. ");
INSERT INTO swessb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hans herre sade till honom: Bra, gode och trogne fasttjänare! Över lite var du trogen, över mycket ska jag sätta dig. Gå in i din herres glädje! ");
INSERT INTO swessb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Men även den som hade fått den enda talenten kom fram och sade: Herre, jag kände dig, att du är en hård man som skördar där du inte har sått och samlar in varifrån du inte skingrat. ");
INSERT INTO swessb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Och jag fruktade och gick bort och dolde din talent i jorden. Se: du har det som är ditt. ");
INSERT INTO swessb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Men hans herre svarade och sade till honom: Elake och motige fasttjänare! Visste du att jag skördar där jag inte sått och samlar in varifrån jag inte skingrat? ");
INSERT INTO swessb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Du borde då ha satt mina silvermynt hos bankirerna, och när jag kom hade jag fått ut mitt med ränta. ");
INSERT INTO swessb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta nu ifrån honom talenten och ge till den som har de tio talenterna. ");
INSERT INTO swessb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","För åt var och en som har ska det ges och överflöda, men från den som inte har ska också det han har tas ifrån honom. ");
INSERT INTO swessb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Och den oduglige fasttjänaren ska ni kasta ut i det yttre mörkret. Där blir gråten och tandagnisslet. ");
INSERT INTO swessb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Men när Människosonen kommer i sin härlighet och alla änglarna med honom, då ska han sitta på sin härlighets tron. ");
INSERT INTO swessb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Och inför honom ska alla folkslagen samlas, och han ska skilja ut dem från varandra såsom herden skiljer ut fåren från getterna. ");
INSERT INTO swessb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Och han ska ställa fåren på sin högra sida, men getterna på vänstra. ");
INSERT INTO swessb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Då ska Kungen säga till dem på hans högra sida: Kom, ni min Fars välsignade, ärv riket berett för er sedan världens grundläggning. ");
INSERT INTO swessb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","För jag hungrade, och ni gav mig att äta. Jag törstade, och ni gav mig att dricka. Främling var jag, och ni samlade in mig. ");
INSERT INTO swessb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naken, och ni klädde mig. Jag var sjuk, och ni besökte mig. I fängelse var jag, och ni kom till mig. ");
INSERT INTO swessb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Då ska de rättfärdiga svara honom och säga: Herre, när såg vi dig hungrande och gav näring, eller törstande och gav att dricka? ");
INSERT INTO swessb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Och när såg vi dig som främling och samlade in, eller naken och klädde? ");
INSERT INTO swessb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Och när såg vi dig sjuk eller i fängelse och kom till dig? ");
INSERT INTO swessb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Och kungen ska svara och säga till dem: Amen, jag säger er: Så vitt ni gjort för ett av dessa mina minsta syskon, så har ni gjort för mig. ");
INSERT INTO swessb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sedan ska han säga även till dem på vänstra sidan: Gå ifrån mig, ni förbannade, till den eoniska elden beredd för djävulen och hans änglar. ");
INSERT INTO swessb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","För jag hungrade, och ni gav mig inte att äta. Jag törstade, och ni gav mig inte att dricka. ");
INSERT INTO swessb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Främling var jag, och ni samlade inte in mig. Naken, och ni klädde mig inte. Sjuk och i fängelse, och ni besökte mig inte. ");
INSERT INTO swessb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Då ska också de svara och säga: Herre, när såg vi dig hungrande eller törstande eller som främling eller naken eller sjuk eller i fängelse, och betjänade dig inte? ");
INSERT INTO swessb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Då ska han svara dem och säga: Amen, jag säger er: Så vitt ni inte gjort för en av dessa minsta, så har ni heller inte gjort för mig. ");
INSERT INTO swessb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Och dessa ska gå bort till eoniskt straff, men de rättfärdiga till eoniskt liv.” ");
INSERT INTO swessb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Och det hände sig, när Jesus hade fullbordat alla dessa ord, att han sade till sina lärjungar: ");
INSERT INTO swessb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”Ni vet att om två dagar blir det påsk, och Människosonen ska utlämnas för att bli korsfäst.” ");
INSERT INTO swessb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Då samlades översteprästerna och folkets äldste på innergården hos översteprästen, som hette Kaiafas, ");
INSERT INTO swessb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","och samrådde för att med list gripa och döda Jesus. ");
INSERT INTO swessb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Men de sade: ”Inte under högtiden, så att det inte blir tumult bland folket.” ");
INSERT INTO swessb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Och när Jesus var i Betania, i Simon den spetälskes hus, ");
INSERT INTO swessb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kom det fram till honom en kvinna som hade en alabasterflaska med kostlig balsam och utgöt över hans huvud medan han låg till bords. ");
INSERT INTO swessb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Men när lärjungarna såg det, blev de indignerade och sade: ”Varför detta fördärv? ");
INSERT INTO swessb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","För denna hade kunnat säljas för mycket pengar och ges till de fattiga.” ");
INSERT INTO swessb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Men Jesus förstod och sade till dem: ”Varför skaffar ni kvinnan besvär? För det är en fin gärning hon har utfört mot mig. ");
INSERT INTO swessb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","För ni har alltid de fattiga hos er, men mig har ni inte alltid. ");
INSERT INTO swessb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","För när hon hällde denna balsam över min kropp, var det för att begrava mig hon gjorde det. ");
INSERT INTO swessb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Amen, jag säger er: Varhelst detta evangelium förkunnas i hela världen ska det också talas om det hon gjorde, till minne av henne.” ");
INSERT INTO swessb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Då gick en av de tolv, han som hette Judas Iskariot, till översteprästerna ");
INSERT INTO swessb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","och sade: ”Vad vill ni ge mig, och jag utlämnar honom åt er?” Då fastställde de för honom trettio silvermynt. ");
INSERT INTO swessb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Och från då började han söka ett lägligt tillfälle för att utlämna honom. ");
INSERT INTO swessb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Och den första dagen i det osyrade brödets högtid kom lärjungarna fram till Jesus och sade: ”Var vill du vi ska bereda för dig att äta påskalammet?” ");
INSERT INTO swessb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Och han sade: ”Bege er in i staden till den och den och säg till honom: Läraren säger: Min tid är nära. Hos dig gör jag påskalammet med mina lärjungar.” ");
INSERT INTO swessb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Och lärjungarna gjorde som Jesus hade samordnat för dem och beredde påskalammet. ");
INSERT INTO swessb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Och när det blev kväll, låg han till bords med de tolv. ");
INSERT INTO swessb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Och medan de åt sade han: ”Amen, jag säger er att: En av er kommer att utlämna mig.” ");
INSERT INTO swessb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Och de blev mycket bedrövade och började säga till honom, varenda en: ”Inte är det väl jag, Herre?” ");
INSERT INTO swessb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Men han svarade och sade: ”Den som doppade handen med mig i skålen, denne ska utlämna mig. ");
INSERT INTO swessb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Människosonen beger sig liksom det är skrivet om honom, men ve den människan genom vilken Människosonen blir utlämnad! Det hade varit bra för honom om den männi­skan inte blivit född.” ");
INSERT INTO swessb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Och då svarade Judas, som skulle utlämna honom, och sade: ”Inte är det väl jag, rabbi?” Han säger till honom: ”Du sade det.” ");
INSERT INTO swessb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Och medan de åt tog Jesus ett bröd och välsignade och bröt, och han gav åt lärjungarna och sade: ”Ta. Ät. Detta är min kropp.” ");
INSERT INTO swessb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Och han tog en bägare och tackade och gav åt dem och sade: ”Drick av den alla. ");
INSERT INTO swessb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","För detta är mitt blod för förbundet som för många blir utgjutet till synders förlåtelse. ");
INSERT INTO swessb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Och jag säger er: Jag ska från nu aldrig dricka av denna vinstockens frukt förrän den dagen när jag dricker det med er nytt i min Fars rike.” ");
INSERT INTO swessb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Och när de hade sjungit hymn, gick de ut till Olivberget. ");
INSERT INTO swessb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sedan säger Jesus till dem: ”Ni alla kommer att bli skandaliserade av mig i denna natt. För det är skrivet: Jag ska slå herden,   och fåren i hjorden ska skingras. ");
INSERT INTO swessb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Men efter att jag blivit uppväckt, ska jag gå före er till Galileen.” ");
INSERT INTO swessb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Men Petrus svarade och sade till honom: ”Om alla kommer att skandaliseras av dig, ska jag aldrig bli skandaliserad.” ");
INSERT INTO swessb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus sade till honom: ”Amen, jag säger dig att i denna natt, innan en tupp gal, ska du tre gånger förneka mig.” ");
INSERT INTO swessb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus säger till honom: ”Om jag så måste dö med dig ska jag aldrig förneka dig!” Likaså sade också alla lärjungarna. ");
INSERT INTO swessb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sedan går Jesus med dem till en markbit som kallas Getsemane och säger till lärjungarna: ”Sitt här medan jag går bort dit och beder.” ");
INSERT INTO swessb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Och han tog med Petrus och de två sönerna till Sebedeus och började vara bedrövad och ängslas. ");
INSERT INTO swessb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Då säger han till dem: ”Min själ är djupt bedrövad till döds. Stanna här och var vakna med mig.” ");
INSERT INTO swessb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Och han gick fram lite och föll ner på sitt ansikte och bad och sade: ”Min Far! Om det är möjligt, låt denna bägare gå förbi från mig. Men inte som jag vill, utan som du.” ");
INSERT INTO swessb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Och han kommer till lärjungarna och finner dem sovande. Och han säger till Petrus: ”Så ni mäktade inte en timme att vara vakna med mig? ");
INSERT INTO swessb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Var vakna och bed så att ni inte kommer in i frestelse. För anden är villig, men köttet svagt.” ");
INSERT INTO swessb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Åter en andra gång gick han bort och bad och sade: ”Min Far, om den inte kan gå förbi om jag inte dricker den, ske din vilja.” ");
INSERT INTO swessb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Och han kom åter och fann dem sovande, för deras ögon var tyngda. ");
INSERT INTO swessb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Och han lämnade dem och gick åter bort och bad en tredje gång, och sade samma ord igen. ");
INSERT INTO swessb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sedan kommer han till lärjungarna och säger till dem: ”Sov ni framöver och vila er. Se: stunden är nu nära och Människosonen utlämnas i syndares händer. ");
INSERT INTO swessb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Res er, låt oss dra. Se: han som utlämnar mig är nu nära.” ");
INSERT INTO swessb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Och medan han ännu talade, se: Judas, en av de tolv, kom och med honom en stor skara med svärd och påkar från folkets översteprästerna och äldste. ");
INSERT INTO swessb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Och han som utlämnade honom hade gett dem ett tecken och sagt: ”Den jag kysser, han är det. Grip honom.” ");
INSERT INTO swessb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Och direkt gick han fram till Jesus och sade: ”Gläd dig, rabbi!”, och kysste ner honom. ");
INSERT INTO swessb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Men Jesus sade till honom: ”Kompis, för det är du här.” Då gick de fram och lade händerna på Jesus och grep honom. ");
INSERT INTO swessb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Och se: en av dem som var med Jesus räckte ut handen och drog ut sitt svärd, och han slog översteprästens fasttjänare och tog bort hans öra. ");
INSERT INTO swessb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Då säger Jesus till honom: ”Vänd bort ditt svärd till dess plats! För alla som tar till svärd ska med svärd förgöras. ");
INSERT INTO swessb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eller tänker du dig att jag inte kan vädja till min Far och han nu kommer att ställa fram för mig mer än tolv legioner änglar? ");
INSERT INTO swessb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hur ska då Skrifterna uppfyllas, att så måste ske?” ");
INSERT INTO swessb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","I den stunden sade Jesus till skarorna: ”Som mot en rövare har ni gått ut med svärd och påkar för att ta fast mig. Varje dag har jag suttit i templet och undervisat, och ni har inte gripit mig. ");
INSERT INTO swessb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Men detta hela har hänt för att profeternas skrifter ska uppfyllas.” Då lämnade alla lärjungarna honom och flydde. ");
INSERT INTO swessb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Och de som hade gripit Jesus förde bort honom till Kaiafas översteprästen, där de skriftlärda och de äldste hade samlats. ");
INSERT INTO swessb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Men Petrus följde honom långt ifrån, fram till översteprästens innergård. Och han gick in innanför och satte sig med undertjänarna för att se slutet. ");
INSERT INTO swessb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Och översteprästerna och hela Sanhedrin sökte ett falskt vittnesbörd mot Jesus för att döda honom, ");
INSERT INTO swessb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","och de fann ­inget trots att många falska vittnen kom fram. Men till sist kom det fram två ");
INSERT INTO swessb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","och sade: ”Denne har sagt: Jag kan riva ner Guds tempelbyggnad och på tre dagar bygga upp.” ");
INSERT INTO swessb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Och översteprästen stod upp och sade till honom: ”Svarar du inget på vad dessa vittnar mot dig?” ");
INSERT INTO swessb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Men Jesus var tyst. Och översteprästen sade till honom: ”Jag besvär dig vid den levande Guden att du ska säga oss om du är Kristus, Guds Son.” ");
INSERT INTO swessb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus säger till honom: ”Du sade det. Men jag säger er: Från nu ska ni se Människosonen sitta på Maktens högra sida och komma på himlens moln.” ");
INSERT INTO swessb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Då rev översteprästen sönder sina kläder och sade: ”Han har hädat! Vad mer för behov har vi av vittnen? Se: nu har ni hört hädelsen. ");
INSERT INTO swessb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Vad tycker ni?” Och de svarade och sade: ”Han är hemfallen åt döden!” ");
INSERT INTO swessb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Då spottade de i hans ansikte och pucklade på honom, och andra örfilade ");
INSERT INTO swessb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","och sade: ”Profetera för oss, Kristus! Vem är det som högg till dig?” ");
INSERT INTO swessb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Men Petrus satt ute på innergården. Och det kom fram till honom en tjänsteflicka som sade: ”Även du var med Jesus galilén.” ");
INSERT INTO swessb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Men han nekade inför alla och sade: ”Jag vet inte vad du säger.” ");
INSERT INTO swessb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Och när han gick ut i porthuset, såg honom en annan kvinna och säger till dem som var där: ”Denne var med Jesus nasarén.” ");
INSERT INTO swessb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Och åter nekade han med ed att: ”Jag känner inte människan.” ");
INSERT INTO swessb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kort därefter kom de fram som stod där och sade till Petrus: ”Sannerligen är också du en av dem. För ditt tal gör dig tydlig.” ");
INSERT INTO swessb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Då började han nedkalla förbannelse och svära att: ”Jag känner inte människan!” Och direkt gol en tupp. ");
INSERT INTO swessb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Och Petrus kom ihåg ordet som Jesus sagt, att: ”Innan en tupp gal ska du tre gånger förneka mig.” Och han gick ut utanför och grät bittert. ");
INSERT INTO swessb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Och när det blev morgon tog de beslut, alla översteprästerna och folkets äldste, mot Jesus om att döda honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Och de band och förde bort honom och utlämnade åt Pilatus, styresmannen. ");
INSERT INTO swessb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Då, när Judas som hade utlämnat honom såg att han blivit fördömd, ångrade han sig och vände sig med de trettio silvermynten till översteprästerna och de äldste ");
INSERT INTO swessb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","och sade: ”Jag har syndat och utlämnat ostraffligt blod.” Men de sade: ”Vad är det för oss? Du ska se till det.” ");
INSERT INTO swessb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Och han slängde silvermynten in i tempelbyggnaden och drog sig undan, och gick bort och hängde sig. ");
INSERT INTO swessb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Men översteprästerna tog silvermynten och sade: ”Det är inte tillåtet att lägga dem i offerkistan, då det är en blodssumma.” ");
INSERT INTO swessb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Och de tog beslut och köpte för dem Krukmakaråkern till gravplats för främlingarna. ");
INSERT INTO swessb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Därför kallades den åkern för Blodsåkern fram till idag. ");
INSERT INTO swessb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Då uppfylldes det som var sagt genom profeten Jeremia, som sade: Och jag tog de trettio silvermynten, priset för den värderade som värderades av Israels söner, ");
INSERT INTO swessb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","och jag gav dem för Krukmakaråkern, så som Herren hade samordnat för mig. ");
INSERT INTO swessb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Och Jesus ställdes inför styresmannen, och styresmannen frågade honom och sade: ”Du är judarnas kung?” Och Jesus sade: ”Du säger det.” ");
INSERT INTO swessb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Och under det att han anklagades av översteprästerna och de äldste svarade han inget. ");
INSERT INTO swessb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Då säger Pilatus till honom: ”Hör du inte hur mycket de vittnar mot dig?” ");
INSERT INTO swessb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Och han svarade honom inte på ens ett ord, så att styresmannen var väldigt förundrad. ");
INSERT INTO swessb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Men varje högtid hade styresmannen för sed att frige en fånge åt skaran, den de ville. ");
INSERT INTO swessb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Och man hade då en bemärkt fånge som hette Jesus Barabbas. ");
INSERT INTO swessb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","När de nu var samlade, sade Pilatus till dem: ”Vem vill ni jag ska frige åt er: Jesus Barabbas eller Jesus som kallas Kristus?” ");
INSERT INTO swessb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","För han visste att det var av avund de hade utlämnat honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Och medan han satt på ­domar­sätet, sände hans hustru till honom och sade: ”Inget mellan dig och den där rättfärdige! För jag led mycket idag i en dröm för hans skull.” ");
INSERT INTO swessb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Men översteprästerna och de äldste övertygade skarorna att begära Barabbas, men Jesus skulle de förgöra. ");
INSERT INTO swessb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Och styresmannen svarade och sade till dem: ”Vem vill ni av de två att jag ska frige åt er?” Och de sade: ”Bar­abbas!” ");
INSERT INTO swessb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus säger till dem: ”Vad ska jag då göra med Jesus som kallas Kristus?” Alla säger: ”Han ska korsfästas!” ");
INSERT INTO swessb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Och han sade: ”Vad för ont har han då gjort?” Men de ropade ännu mer och sade: ”Han ska korsfästas!” ");
INSERT INTO swessb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Och när Pilatus såg att inget gör nytta utan det blir mer tumult, tog han vatten och tvättade av händerna inför skaran och sade: ”Jag är ostrafflig från dennes blod. Ni ska se tilldetta.” ");
INSERT INTO swessb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Och allt folket svarade och sade: ”Hans blod över oss och över våra barn!” ");
INSERT INTO swessb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Då frigav han åt dem Barabbas, men Jesus gisslade han och utlämnade för att korsfästas. ");
INSERT INTO swessb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Då tog styresmannens soldater med sig Jesus in i pretoriet och samlade hela kohorten mot honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Och de klädde av honom och satte runt honom en scharlakansröd soldatmantel. ");
INSERT INTO swessb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Och de flätade en krans av törnen och satte på hans huvud, och en käpp i hans högra hand, och de knäföll inför honom och förlöjligade honom och sade: ”Gläd dig, judarnas kung!” ");
INSERT INTO swessb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Och de spottade på honom och tog käppen och slog mot hans ­huvud. ");
INSERT INTO swessb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Och när de hade förlöjligat honom, klädde de av honom soldatmanteln och iklädde honom hans kläder och förde bort honom för att korsfästa. ");
INSERT INTO swessb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Och när de gick ut, fann de en kyreneisk man vid namn Simon. Denne rekvirerade de för att bära hans kors. ");
INSERT INTO swessb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Och när de kom till en plats kallad Golgota, vilket är den så kallade Kranieplatsen, ");
INSERT INTO swessb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","gav de honom att dricka vin blandat med galla. Och han smakade och ville inte dricka. ");
INSERT INTO swessb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Och de korsfäste honom, och delade upp hans kläder och kastade lott, ");
INSERT INTO swessb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","och satt och bevakade honom där. ");
INSERT INTO swessb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Och de satte upp ovanför hans huvud anklagelsen mot honom, skriven: ”Denne är Jesus, judarnas kung.” ");
INSERT INTO swessb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sedan korsfästs med honom två rövare, en på högra sidan och en på vänstra. ");
INSERT INTO swessb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Och de förbipasserande smädade honom och skakade sina huvuden ");
INSERT INTO swessb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","och sade: ”Du som river ner tempelbyggnaden och på tre dagar bygger upp! Fräls dig själv, om du är Guds Son, och kom ner från korset!” ");
INSERT INTO swessb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Likaså förlöjligade honom också översteprästerna med de skriftlärda och äldste och sade: ");
INSERT INTO swessb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","”Andra har han frälst, sig själv kan han inte frälsa. Israels kung är han! Han får komma ner nu från korset och vi ska tro på honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Han förtröstar på Gud! Nu får han rädda honom, om han vill ha honom. För han har sagt att: Jag är Guds Son.” ");
INSERT INTO swessb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Och detsamma också rövarna, som var korsfästa med honom och kritiserade honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Men från sjätte timmen kom ett mörker över hela landet fram till nionde timmen. ");
INSERT INTO swessb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Och omkring den nionde timmen ropade Jesus högt med väldig röst och sade: ”Eli! Eli! Lema sabaktani?”, det vill säga: ”Min Gud! Min Gud! Varför har du övergett mig?” ");
INSERT INTO swessb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Men några av dem som stod där hörde det och sade att: ”Denne ropar på Elia!” ");
INSERT INTO swessb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Och direkt sprang en av dem och tog en tvättsvamp och fyllde med posca och satte runt en käpp och gav honom att dricka. ");
INSERT INTO swessb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Och de övriga sade: ”Låt oss se om Elia kommer och frälser honom.” ");
INSERT INTO swessb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Men Jesus skrek åter med väldig röst och lämnade ifrån sig anden. ");
INSERT INTO swessb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Och se: förhänget i tempelbyggnaden revs itu, uppifrån och ända ner, och jorden bävade och klipporna revs itu. ");
INSERT INTO swessb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Och gravarna öppnades och många kroppar av de insomnade heliga uppväcktes, ");
INSERT INTO swessb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","och de kom ut ur gravarna efter hans uppväckande och gick in i den heliga staden och framvisade sig för många. ");
INSERT INTO swessb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Och centurionen och de som med honom bevakade Jesus såg jordbävningen och det som hände, och de fruktade mycket och sade: ”Sannerligen, denne var Guds Son!” ");
INSERT INTO swessb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Och det fanns där många kvinnor som skådade långt ifrån. De hade följt Jesus från Galileen och betjänat honom. ");
INSERT INTO swessb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bland dem var Maria Magdalena och Maria som var Jakobs och Josefs mor, samt modern till Sebedeus söner. ");
INSERT INTO swessb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Och när det blev kväll, kom en rik man från Arimatea vid namn Josef som också han blivit ­lärjunge till Jesus. ");
INSERT INTO swessb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Denne gick till Pilatus och bad om Jesu kropp. Då befallde Pilatus att den skulle avges. ");
INSERT INTO swessb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Och Josef tog kroppen och vek in den i rent linnetyg ");
INSERT INTO swessb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","och lade den i sin nya grav, som han hade huggit ut i klippan. Och han rullade fram en stor sten för öppningen till graven och gick iväg. ");
INSERT INTO swessb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Och där var Maria Magdalena och den andra Maria, sittande mittemot gravkammaren. ");
INSERT INTO swessb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Men dagen därpå, vilket är efter förberedelsedagen, samlades översteprästerna och fariseerna hos Pilatus ");
INSERT INTO swessb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","och sade: ”Herre, vi kom ihåg att den förvillaren sade medan han ännu levde: Efter tre dagar uppväcks jag. ");
INSERT INTO swessb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Befall nu att gravkammaren säkras fram till tredje dagen, så att inte hans lärjungar kommer och stjäl honom och säger till folket: Han har uppväckts från de döda, och den sista villfarelsen blir värre än den första.” ");
INSERT INTO swessb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus sade till dem: ”Ni har en vaktstyrka. Bege er, säkra såsom ni vet.” ");
INSERT INTO swessb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Och de gick och ­säkrade gravkammaren och satte sigill på stenen med vaktstyrkan. ");
INSERT INTO swessb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Men sent efter sabbaten, i det gryende mot den första dagen i veckan, kom Maria Magdalena och den andra Maria för att skåda gravkammaren. ");
INSERT INTO swessb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Och se: det blev en väldig jordbävning, för en Herrens ängel kom ner från himlen och gick fram och rullade bort stenen och satte sig ovanpå den. ");
INSERT INTO swessb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Och hans utseende var som en blixt och hans klädsel vit som snö. ");
INSERT INTO swessb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Och av fruktan för honom bävade de som bevakade och blev som döda. ");
INSERT INTO swessb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Men ängeln svarade och sade till kvinnorna: ”Frukta inte ni! För jag vet att det är Jesus den korsfäste ni söker. ");
INSERT INTO swessb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Han är inte här! För han är uppväckt, så som han har sagt. Kom, se platsen där han låg. ");
INSERT INTO swessb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Och fort, gå och säg till hans lärjungar att han är uppväckt från de döda. Och se: han går före er till Galileen. Där ska ni få se honom. Se: jag har sagt er.” ");
INSERT INTO swessb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Och de gick fort iväg från graven, med fruktan och stor glädje sprang de för att berätta för hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Och se: Jesus mötte dem och sade: ”Gläd er!” Och de kom fram och grep hans fötter och tillbad honom. ");
INSERT INTO swessb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Då säger Jesus till dem: ”Frukta inte! Bege er, berätta för mina bröder att de ska gå bort till Galileen. Och där ska de få se mig.” ");
INSERT INTO swessb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Men medan de gick, se: några ur vaktstyrkan kom in i staden och berättade för översteprästerna alltihop som hade hänt. ");
INSERT INTO swessb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Och de samlades med de äldste och tog beslut att ge avsevärt med silvermynt till soldaterna ");
INSERT INTO swessb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","och sade: ”Säg att: Hans lärjungar kom på natten och stal honom medan vi sov. ");
INSERT INTO swessb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Och om detta blir hört hos styresmannen, ska vi övertyga honom och göra er fria från bekymmer.” ");
INSERT INTO swessb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Och de tog emot silvermynten och gjorde som de blivit lärda, och ryktet om detta ord spreds hos judarna ända till dagen idag. ");
INSERT INTO swessb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Och de elva lärjungarna gick till Galileen, till det berg som Jesus hade förordnat för dem. ");
INSERT INTO swessb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Och de såg honom och tillbad, men några tvekade. ");
INSERT INTO swessb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Och Jesus kom fram och talade till dem och sade: ”Åt mig har getts all auktoritet i himmel och på jorden. ");
INSERT INTO swessb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gå nu och gör alla folkslagen till lärjungar, döpande dem in i Faderns och Sonens och den heliga Andens namn, ");
INSERT INTO swessb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","lärande dem att hålla fast vid allt vad jag har påbjudit er. Och se: jag är med er alla dagarna fram till eonens fullbordan.” ");
INSERT INTO swessb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Begynnelsen av evangeliet om Jesus Kristus, Guds Son. ");
INSERT INTO swessb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Såsom det är skrivet hos profeten Jesaja: Se: jag sänder min ängel   framför ditt ansikte.   Han ska preparera din väg.  ");
INSERT INTO swessb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rösten av en som ropar i ödemarken:   Bered Herrens väg!   Gör hans stigar raka!  ");
INSERT INTO swessb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","– kom Johannes döpande i ödemarken och förkunnande ett sinnesändringens dop till syndernas förlåtelse. ");
INSERT INTO swessb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Och man gick ut till honom, hela den judeiska trakten och alla jerusalemiterna, och de döptes av honom i Jordanfloden och erkände sina synder. ");
INSERT INTO swessb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Och Johannes var iklädd kamelhår och ett läderbälte om sin höft, och åt gräshoppor och vildhonung. ");
INSERT INTO swessb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Och han förkunnade och sade: ”Det kommer den som är starkare än jag efter mig. Hoshonom är jag inte förtjänt att böja mig och lossa remmen på hans sandaler. ");
INSERT INTO swessb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jag har döpt er med vatten, men han ska döpa er i helig Ande.” ");
INSERT INTO swessb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Och det hände sig i de dagarna att Jesus från Nasa­ret i Galileen kom och blev döpt i Jordan av Johannes. ");
INSERT INTO swessb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Och direkt, när han steg upp ur vattnet, såg han himlarna rivas itu och Anden som en duva komma ner till honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Och en röst kom från himlarna: ”Du är min Son, den Älskade. I dig har jag funnit behag.” ");
INSERT INTO swessb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Och direkt driver Anden ut honom i ödemarken. ");
INSERT INTO swessb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Och han var i ödemarken fyrtio dagar, testad av Satan. Och han var hos vilddjuren, och änglarna betjänade honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Men efter att Johannes blivit utlämnad, kom Jesus till Galileen och förkunnade Guds evangelium ");
INSERT INTO swessb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","och sade att: ”Tiden är uppfylld och Guds rike är nu nära. Ändra sinne och tro på evangeliet.” ");
INSERT INTO swessb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Och när han passerade förbi längs Galileiska havet såg han Simon och Andreas, Simons bror, som kastade nät i havet. För de var fiskare. ");
INSERT INTO swessb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Och Jesus sade till dem: ”Kom efter mig, och jag ska göra så att ni blir människofiskare.” ");
INSERT INTO swessb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Och direkt lämnade de näten och ­följde honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Och han gick framåt lite och såg Jakob Sebedeus son och Johannes hans bror, och de var i båten och förfärdigade näten. ");
INSERT INTO swessb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Och direkt kallade han dem, och de lämnade sin far Sebedeus i båten med de anställda och gick iväg efter honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Och de går in i Kapernaum. Och direkt på sabbaten gick han in i syna­gogan och undervisade. ");
INSERT INTO swessb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Och de var överväldigade vid hans undervisning, för han undervisade dem som en som hade auktoritet och inte som de skriftlärda. ");
INSERT INTO swessb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Och direkt fanns i deras synagoga en man med en oren ande, och han skrek högt ");
INSERT INTO swessb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","och sade: ”Vad mellan oss och dig, Jesus nasaré? Har du kommit för att förgöra oss? Jag känner dig, vem du är: Guds Helige!” ");
INSERT INTO swessb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Och Jesus näpste honom och sade: ”Var tilltäppt och kom ut ur honom!” ");
INSERT INTO swessb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Och den orena anden ruskade honom och ropade med väldig röst och kom ut ur honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Och allihop häpnade så att de diskuterade med varann och sade: ”Vad är detta? En ny undervisning, med auktoritet! Även de orena andarna beordrar han, och de hörsammar honom.” ");
INSERT INTO swessb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Och det gick ut hörsägen om honom direkt överallt i hela trakten runt Galileen. ");
INSERT INTO swessb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Och direkt när de kom ut ur synagogan gick de till Simons och Andreas hus med Jakob och Johan­nes. ");
INSERT INTO swessb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Men Simons svärmor låg febrig, och direkt säger de till honom om henne. ");
INSERT INTO swessb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Och han gick fram och reste upp henne, sedan han gripit handen. Och febern lämnade henne, och hon betjänade dem. ");
INSERT INTO swessb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Men när det blev kväll, när solen gått ner, förde man till honom alla som hade det illa och dem som var demoniserade. ");
INSERT INTO swessb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Och hela ­staden var församlad vid dörren. ");
INSERT INTO swessb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Och han botade många som hade det illa i olika åkommor och drev ut många demoner. Och han lät inte demonerna tala, eftersom de kände honom. ");
INSERT INTO swessb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Och väldigt tidig morgon, på natten, stod han upp och gick ut och gick bort till en öde plats, och där bad han. ");
INSERT INTO swessb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Och då förföljde honom Simon och de som var med honom, ");
INSERT INTO swessb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","och de fann honom och säger till honom att: ”Alla söker dig.” ");
INSERT INTO swessb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Och han säger till dem: ”Låt oss dra någon annanstans, till de nästa bystäderna, så att jag även där kan förkunna. För det är för detta jag har gått ut.” ");
INSERT INTO swessb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Och han gick och förkunnade i deras synagogor i hela Galileen och drev ut demonerna. ");
INSERT INTO swessb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Och det kommer till honom en spetälsk, som vädjar till honom och knäfaller och säger till honom att: ”Om du vill, kan du rena mig.” ");
INSERT INTO swessb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Och han kände innerligt, räckte ut sin hand och rörde vid honom och säger till honom: ”Jag vill. Var renad!” ");
INSERT INTO swessb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Och direkt gick spetälskan bort från honom och han blev renad. ");
INSERT INTO swessb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Och han frustade mot honom, och direkt drev han ut honom ");
INSERT INTO swessb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","och säger till honom: ”Se till att du inte säger något till någon. Nej, bege dig och visa dig för prästen och frambär för din rening det som Mose har förordnat, till ett ­vittnesbörd för dem.” ");
INSERT INTO swessb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Men han gick ut och började förkunna mycket och sprida ryktet om ordet så att han inte längre kunde gå in i en stad uppenbart, utan han var ute på öde platser. Och man kom till honom från alla håll. ");
INSERT INTO swessb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Och han gick åter till Kapernaum, och efter några dagar hördes det att han är i huset. ");
INSERT INTO swessb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Och det samlades så många att de inte längre hade rum, inte ens vid dörren. Och han talade till dem ordet. ");
INSERT INTO swessb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Och de kommer bärande till honom en förlamad, lyft av fyra. ");
INSERT INTO swessb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Och när de inte kunde bära fram till honom för skarans skull, avtakade de taket där han var. Och när de hade grävt ut, firar de ner madrassen där den förlamade låg. ");
INSERT INTO swessb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Och när Jesus ser deras tro, säger han till den förlamade: ”Barn, dina synder blir förlåtna.” ");
INSERT INTO swessb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Men det fanns några av de skriftlärda där, som satt och funderade i sina hjärtan: ");
INSERT INTO swessb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","”Varför talar den där så? Han hädar! Vem kan förlåta synder utom en: Gud?” ");
INSERT INTO swessb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Och direkt insåg Jesus i sin ande att det är så de funderar inom sig, och han säger till dem: ”Varför funderar ni detta i era hjärtan? ");
INSERT INTO swessb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vad är lättare, att säga till den förlamade: Dina synder blir förlåtna, eller att säga: Res dig och ta din madrass och vandra? ");
INSERT INTO swessb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Men för att ni ska veta att Människosonen har auktoritet att förlåta synder på jorden”, säger han sedan till den förlamade: ");
INSERT INTO swessb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","”Till dig säger jag: Res dig, ta din madrass och bege dig till ditt hus!” ");
INSERT INTO swessb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Och han reste sig, och direkt tog han madrassen och gick ut inför alla, så att alla blev utom sig och ärade Gud och sade att: ”Sådant har vi aldrig sett!” ");
INSERT INTO swessb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Och han gick åter ut längs havet. Och hela skaran kom till honom, och han undervisade dem. ");
INSERT INTO swessb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Och när han passerade förbi såg han Levi Alfeus son sittande vid tullhuset, och han säger till honom: ”Följ mig!” Och han stod upp och följde honom. ");
INSERT INTO swessb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Och det händer sig att han ligger till bords i hans hus, och många tullindrivare och syndare låg till bords med Jesus och hans lärjungar. För de var många och de följde honom. ");
INSERT INTO swessb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Och de skriftlärda från fariseerna såg att han äter med syndarna och tullindrivarna, och de sade till hans lärjungar att: ”Är det med tullindrivarna och syndarna han äter?” ");
INSERT INTO swessb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Och Jesus hörde det och säger till dem att: ”Inte har de starka behov av läkare, utan de som har det illa. Jag har inte kommit för att kalla rättfärdiga, utan ­syndare.” ");
INSERT INTO swessb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Och Johannes lärjungar och fariseerna var fastande. Och de kommer och säger till honom: ”Varför fastar Johannes lärjungar och fariseernas lärjungar, men dina lärjungar fastar inte?” ");
INSERT INTO swessb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Och Jesus sade till dem: ”Inte kan bröllopssalens söner fasta under det att brudgummen är hos dem? Den tid de har brudgummen hos sig kan de inte fasta. ");
INSERT INTO swessb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Men det ska komma dagar när brudgummen tas ifrån dem, och då kommer de att fasta, på den dagen. ");
INSERT INTO swessb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ingen syr på en lapp av okrympt tyg på en gammal mantel. Annars tar den nya bort fullheten av sig från den gamla och det blir en värre reva. ");
INSERT INTO swessb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Och ingen häller ungt vin i gamla läglar. Annars sliter vinet sönder läglarna och vinet går förlorat, även läglarna. Nej, ungt vin i nya läglar.” ");
INSERT INTO swessb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Och det hände sig att han på sabbaten passerade genom sädesfälten, och hans lärjungar började göra väg plockande axen. ");
INSERT INTO swessb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Och fariseerna sade till honom: ”Se: varför gör de på sabbaten det som inte är tillåtet?” ");
INSERT INTO swessb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Och han säger till dem: ”Har ni aldrig läst vad David gjorde när han hade behov och blev hungrig, han och de som var med honom? ");
INSERT INTO swessb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hur han gick in i Guds hus vid översteprästen Ebjatar, och han åt framsättningens bröd som det inte är tillåtet att äta utom för prästerna. Och han gav också till dem som var med honom.” ");
INSERT INTO swessb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Och han sade till dem: ”Sab­bat­en blev till för människan, och inte män­niskan för sabbaten. ");
INSERT INTO swessb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Alltså är Människosonen Herre också över sabbaten.” ");
INSERT INTO swessb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Och han gick åter till synagogan. Och det fanns där en man som hade handen skrumpnad. ");
INSERT INTO swessb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Och de vaktade noga på honom, om han på sabbaten kommer att bota honom, för att anklaga honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Och han säger till mannen som har den skrumpnade handen: ”Res dig till mitten.” ");
INSERT INTO swessb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Och han säger till dem: ”Är det tillåtet på sabbaten att göra gott, eller att göra illa? Att frälsa en själ, eller att döda?” Men de var tysta. ");
INSERT INTO swessb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Och han ser sig omkring på dem med vrede, sammanbedrövad över försteningen i deras hjärta, och säger till mannen: ”Räck ut handen.” Och han räckte ut den, och hans hand blev återställd. ");
INSERT INTO swessb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Och fariseerna gick direkt ut med herodianerna och satte ett beslut mot honom för att förgöra honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Och Jesus drog sig undan med sina lärjungar mot havet, och en stor mängd från Galileen följde, och från Judeen ");
INSERT INTO swessb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","och från Jerusalem och från Idumeen och andra sidan Jordan och runt Tyrus och Sidon, en stor mängd som hörde vad han gjorde och kom till honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Och han sade åt sina lärjungar att en småbåt ständigt skulle finnas för honom på grund av skaran, för att de inte skulle pressa honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","För han botade så många att de föll över honom för att röra honom, de som hade gissel. ");
INSERT INTO swessb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Och de orena andarna, när de skådade honom, föll ner för honom och skrek och sade att: ”Du är Guds Son!” ");
INSERT INTO swessb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Och han näpste dem mycket för att de inte skulle göra honom uppenbar. ");
INSERT INTO swessb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Och han går upp till berget och kallar till sig dem som han själv ville, och de gick bort till honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Och han utsåg tolv för att vara med honom, och för att han skullesända ut dem att förkunna ");
INSERT INTO swessb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","och ha auktoritet att driva ut demonerna. ");
INSERT INTO swessb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Och han lade ett namn på Simon: Petrus, ");
INSERT INTO swessb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","och Jakob Sebedeus son och Johannes Jakobs bror och lade på dem namnen Boa­nerges, det vill säga Åsksöner, ");
INSERT INTO swessb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","samt Andreas och Filippus och Bartolomeus och Matteus och Tomas och Jakob Alfeus son och Taddeus och Simon Kananaios ");
INSERT INTO swessb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","och Judas Iskariot, som också utlämnade ­honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Och han kommer till huset. Och det kommer åter samman en skara så att de inte ens kan äta bröd. ");
INSERT INTO swessb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Och när de som stod honom nära hörde det gick de ut för att hålla kvar honom, för de sade att han var utom sig. ");
INSERT INTO swessb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Och de skriftlärda som hade kommit ner från Jerusalem sade att han har Beelsebul, och att det är med demonernas furste han driver ut demonerna. ");
INSERT INTO swessb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Och han kallade dem till sig och sade i liknelser till dem: ”Hur kan Satan ­driva ut Satan? ");
INSERT INTO swessb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Och om ett rike blir delat mot sig självt kan det riket inte bestå, ");
INSERT INTO swessb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","och om ett hus blir delat mot sig självt kommer det huset inte att kunna bestå. ");
INSERT INTO swessb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Och om Satan har stått upp mot sig själv och blivit delad, kan han inte bestå utan har nått sitt slut. ");
INSERT INTO swessb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Men ingen kan gå in i den starkes hus och länsa hans kärl om han inte först binder den starke. Och sedan ska han länsa hans hus. ");
INSERT INTO swessb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Amen, jag säger er att allt ska förlåtas människornas söner, synderna och hädelserna, hur mycket de än hädar. ");
INSERT INTO swessb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Men den som hädar mot den heliga Anden har ingen förlåtelse till eonen, utan är straffskyldig till eonisk synd.” ");
INSERT INTO swessb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","För de sade: ”En oren ande har han.” ");
INSERT INTO swessb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Och då kommer hans mor och hans bröder, och de stod utanför och sände till honom och kallade honom. ");
INSERT INTO swessb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Och det satt omkring honom en skara, och de säger till honom: ”Se: din mor och dina bröder där ute söker dig.” ");
INSERT INTO swessb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Och han svarar dem och säger: ”Vem är min mor och mina bröder?” ");
INSERT INTO swessb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Och han ser sig om på dem som sitter runt omkring honom och säger: ”Se: min mor och mina bröder. ");
INSERT INTO swessb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","För den som gör Guds vilja, denne är min bror och syster och mor.” ");
INSERT INTO swessb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Och åter började han undervisa vid havet. Och det samlades hos honom en synnerligen stor skara, så han steg i en båt och satt ute på havet, och hela skaran var vid havet på land. ");
INSERT INTO swessb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Och han undervisade dem mycket i liknelser och sade till dem i sin undervisning: ");
INSERT INTO swessb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","”Hör! Se: Ut gick såningsmannen för att så. ");
INSERT INTO swessb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Och det hände sig under det att han sådde att en del föll vid vägen. Och fåglarna kom och åt upp det. ");
INSERT INTO swessb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Och annat föll på det steniga, där det inte hade mycket jord. Och direkt kom det upp, eftersom det inte hade djup jord. ");
INSERT INTO swessb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Och när solen gick upp sveddes det, och eftersom det inte hade rot vissnade det. ");
INSERT INTO swessb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Och annat föll i törnena, och törnena kom upp och kvävde ihop det, och ingen gröda gav det. ");
INSERT INTO swessb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Och annat föll i den fina jorden, och det gav gröda när det kom upp och växte och bar, en trettio och en sextio och en hundra.” ");
INSERT INTO swessb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Och han sade: ”Den som har öron att höra med ska höra.” ");
INSERT INTO swessb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Och när han blev ensam, frågade honom de som var runt honom med de tolv om liknelserna. ");
INSERT INTO swessb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Och han sade till dem: ”Åt er är Guds rikes hemlighet given. Men för dessa som är utanför kommer allt i liknelser, ");
INSERT INTO swessb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","för att de ska seende se och inte se,   och hörande höra och inte förstå,   så att de inte vänder om och det förlåts dem.” ");
INSERT INTO swessb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Och han säger till dem: ”Förstår ni inte denna liknelse? Och hur ska ni då förstå alla de andra liknelserna? ");
INSERT INTO swessb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Såningsmannen sår ordet. ");
INSERT INTO swessb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Och dessa är de vid vägen: där ordet sås och när de hör, kommer direkt Satan och tar bort ordet som är sått i dem. ");
INSERT INTO swessb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Och dessa är likaså de som sås på det steniga: de som när de hör ordet direkt med glädje tar emot det, ");
INSERT INTO swessb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","och de har ingen rot inom sig utan är tillfälliga. Sedan, när det blir nöd eller förföljelse för ordets skull, blir de direkt skandaliserade. ");
INSERT INTO swessb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Och andra är de som sås i törnena: dessa är de som hör ordet, ");
INSERT INTO swessb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","och eonens bekymmer och rikedomens tjusning och begären kring det övriga kommer in och kväver ihop ordet och det blir utan frukt. ");
INSERT INTO swessb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Och dessa är de som är sådda på den fina jorden: de som hör ordet och godtar och bär frukt, en trettio och en sextio och en hundra.” ");
INSERT INTO swessb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Och han sade till dem: ”Inte kommer väl lampan för att sättas under skäppan eller under bädden? Är det inte för att sättas på lampstället? ");
INSERT INTO swessb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","För inget är dolt utom för att visas fram, och inget har blivit förborgat utom för att komma till det uppenbara. ");
INSERT INTO swessb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Om någon har öron att höra med ska han höra.” ");
INSERT INTO swessb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Och han sade till dem: ”Se upp vad ni hör. Med det mått ni ­mäter med ska det mätas åt er och tillföras er. ");
INSERT INTO swessb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","För den som har, åt honom ska det ges. Och den som inte har, också det han har ska tas ifrån honom.” ");
INSERT INTO swessb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Och han sade: ”Så är Guds rike, som när en människa kastar utsädet på jorden. ");
INSERT INTO swessb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Och han sover och vaknar natt och dag, och utsädet spirar och blir längre, hur vet han inte själv. ");
INSERT INTO swessb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Av sig själv bär jorden gröda: först strå, sedan ax, sedan fullt vete i axet. ");
INSERT INTO swessb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Och när grödan överlämnar sig sänder han direkt ut skäran, för skörden förestår.” ");
INSERT INTO swessb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Och han sade: ”Hur ska vi likna Guds rike? Eller med vilken liknelse ska vi lägga fram det? ");
INSERT INTO swessb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Som ett senapskorn, som när det såtts på jorden är mindre än alla fröna på jorden. ");
INSERT INTO swessb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Och när det såtts, kommer det upp och blir större än alla köksväxterna och gör så stora grenar att under dess skugga kan himlens fåglar sätta bo.” ");
INSERT INTO swessb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Och med många sådana liknelser talade han för dem ordet, så som de kunde höra. ");
INSERT INTO swessb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Och utan liknelse talade han inte till dem. Men enskilt klargjorde han allt för sina egna lärjungar. ");
INSERT INTO swessb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Och han säger till dem på den dagen, när det blivit kväll: ”Låt oss resa över till andra sidan.” ");
INSERT INTO swessb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Och de lämnade skaran och tog med honom som han var i båten, och andra båtar var med honom. ");
INSERT INTO swessb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Och det blir en väldig storm med vind, och vågorna kastade sig in över i båten så att båten redan fylls. ");
INSERT INTO swessb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Och själv var han i aktern på kudden och sov. Och de väcker honom och säger till honom: ”Lärare, bryr du dig inte att vi går förlorade?” ");
INSERT INTO swessb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Och väckt näpste han vinden och sade till havet: ”Var tyst! Var tilltäppt!” Och vinden lade sig och det blev ett väldigt lugn. ");
INSERT INTO swessb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Och han sade till dem: ”Varför är ni fega? Har ni ännu inte tro?” ");
INSERT INTO swessb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Och de fruktade med stor fruktan och sade till varandra: ”Vem är då denne? För till och med vinden och havet hörsammar honom!” ");
INSERT INTO swessb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Och de kom till andra sidan havet, till gerasenernas trakt. ");
INSERT INTO swessb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Och när han steg ur båten, direkt mötte honom från gravarna en man med en oren ande ");
INSERT INTO swessb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","som hade sin boning bland gravarna. Och inte ens med kedja kunde någon längre binda honom, ");
INSERT INTO swessb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","eftersom han många gånger med fotbojor och kedjor blivit bunden, och då hade kedjorna dragits sönder av honom och fotbojorna knäckts. Och ingen mäktade att tämja honom. ");
INSERT INTO swessb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Och ständigt, natt och dag, var han bland gravarna och i bergen och skrek och slog sig själv med stenar. ");
INSERT INTO swessb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Och när han såg Jesus långt ifrån, sprang han och tillbad honom ");
INSERT INTO swessb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","och skrek med väldig röst och säger: ”Vad mellan mig och dig, Jesus, den högste Gudens Son? Jag besvär dig vid Gud att du inte ska plåga mig!” ");
INSERT INTO swessb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","För han hade sagt till honom: ”Kom ut, orena ande, ur människan!” ");
INSERT INTO swessb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Och han frågade honom: ”Vad är ditt namn?” Och han säger till honom: ”Legion är mitt namn. För vi är många.” ");
INSERT INTO swessb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Och han vädjade till honom mycket att han inte skulle sända dem utanför trakten. ");
INSERT INTO swessb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Men det fanns där vid berget en stor svinhjord som vallades, ");
INSERT INTO swessb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","och de vädjade till honom och sade: ”Skicka oss till svinen, så att vi kan fara in i dem!” ");
INSERT INTO swessb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Och han tillät dem. Och de orena andarna kom ut och for in i svinen, och då rusade hjorden ner från branten i havet, ungefär tvåtusen, och kvävdes i havet. ");
INSERT INTO swessb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Och de som vallade dem flydde och berättade i staden och på fälten, och man kom för att se vad det är som har hänt. ");
INSERT INTO swessb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Och de kommer till Jesus och skådar den demoniserade sittande klädd och sansad, han som haft legionen, och de fruktade. ");
INSERT INTO swessb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Och då skildrade de som hade sett det för dem hur det hade hänt med den demoniserade och om svinen, ");
INSERT INTO swessb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","och de började vädja till honom att gå bort från deras område. ");
INSERT INTO swessb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Och när han steg i båten, vädjade han som varit demoniserad till honom att få vara med honom. ");
INSERT INTO swessb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Och han lät honom inte, utan säger till honom: ”Bege dig till ditt hus, till de dina, och berätta för dem vad Herren har gjort för dig och förbarmat sig över dig.” ");
INSERT INTO swessb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Och han gick bort och började förkunna i Dekapolis vad Jesus hade gjort för honom. Och alla var förundrade. ");
INSERT INTO swessb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Och när Jesus hade farit över i båten igen till andra sidan, samlades en stor skara hos honom. Och han var vid havet. ");
INSERT INTO swessb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Och då kommer en av synagogföreståndarna vid namn Jairus. Och när han ser honom, faller han ner för hans fötter ");
INSERT INTO swessb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","och vädjar till honom mycket och säger att: ”Min lilla dotter har nåttdet yttersta, så att du ska komma och lägga händerna på henne, så att hon blir frälst och får leva!” ");
INSERT INTO swessb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Och han gick iväg med honom. Och där följde honom en stor skara och pressade sig på honom. ");
INSERT INTO swessb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Och en kvinna som hade varit i blodflöde tolv år, ");
INSERT INTO swessb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","och lidit mycket under många läkare och spenderat allt hos sig och inte fått någon nytta utan snarare kommit till det sämre, ");
INSERT INTO swessb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","hade hört om Jesus och kom i skaran bak­ifrån och rörde vid hans mantel. ");
INSERT INTO swessb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","För hon sade att: ”Om jag så bara rör hans kläder blir jag frälst.” ");
INSERT INTO swessb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Och direkt torkade hennes blodkälla, och hon visste i kroppen att hon var helad från gisslet. ");
INSERT INTO swessb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Och direkt insåg Jesus inom sig kraften som hade gått ut från honom, och han vände om i skaran och sade: ”Vem rörde mina kläder?” ");
INSERT INTO swessb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Och hans lärjungar sade till honom: ”Du ser skaran som pressar sig på dig, och du säger: Vem rörde mig?” ");
INSERT INTO swessb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Och han såg sig omkring för att se henne som hade gjort detta. ");
INSERT INTO swessb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Men kvinnan fruktade och darrade, då hon visste vad som hade hänt henne, och hon kom och föll ner för honom och sade honom hela sanningen. ");
INSERT INTO swessb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Och han sade till henne: ”Dotter, din tro har frälst dig. Bege dig i frid och var frisk från ditt gissel.” ");
INSERT INTO swessb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Medan han ännu talar, kommer de från synagogföreståndaren och säger att: ”Din dotter har dött. Varför besvärar du Läraren mer?” ");
INSERT INTO swessb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Men Jesus ohörsammar ordet som talas och säger till synagogföreståndaren: ”Frukta inte. Bara tro.” ");
INSERT INTO swessb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Och han lät ingen följa med honom utom Petrus och Jakob och Johannes, Jakobs bror. ");
INSERT INTO swessb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Och de kommer till synagogföreståndarens hus, och han skådar tumult och människor som gråter och skränar mycket. ");
INSERT INTO swessb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Och han går in och säger till dem: ”Varför väsnas ni och gråter? Barnet har inte dött, utan sover.” ");
INSERT INTO swessb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Och de skrattade åt honom. Men själv driver han ut alla och tar med barnets far och mor och dem som är med honom och går in där barnet var, ");
INSERT INTO swessb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","och han griper barnets hand och säger till henne: ”Talitha koum!”, vilket är översatt: ”Flicka, dig säger jag, res dig!” ");
INSERT INTO swessb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Och direkt stod flickan upp och gick omkring, för hon var tolv år, och de blev utom sig direkt i väldig extas. ");
INSERT INTO swessb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Men han kommenderade dem mycket att ingen skulle få veta detta, och sade att det skulle ges henne något att äta. ");
INSERT INTO swessb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Och han gick ut därifrån och kommer till sin fädernebygd, och hans lärjungar följer honom. ");
INSERT INTO swessb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Och när det blev sabbat började han undervisa i synagogan. Och många som hörde var överväldigade och sade: ”Varifrån har denne detta? Och vad ärden visheten som blivit given denne? Och sådana kraftgärningar som sker genom hans händer! ");
INSERT INTO swessb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Är inte denne snickaren, son till Maria och bror till Jakob och Joses och Judas och Simon? Och är inte hans systrar här hos oss?” Och de var skandaliserade av honom. ");
INSERT INTO swessb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Och Jesus sade till dem att: ”En profet är inte ohedrad utom i sin fädernebygd och bland sina släktingar och i sitt hus.” ");
INSERT INTO swessb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Och han kunde där inte göra någon kraftgärning, utom för några få kraftlösa som han lade händerna på och botade. ");
INSERT INTO swessb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Och han var förundrad över deras otro. Och han drog runt i byarna runt omkring och undervisade. ");
INSERT INTO swessb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Och han kallar till sig de tolv och började sända ut dem två och två och gav dem auktoritet över de orena andarna. ");
INSERT INTO swessb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Och han instruerade dem att inte ta med något på vägen utom bara en stav: inte bröd, inte väska, inte koppar i bältet, ");
INSERT INTO swessb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","men skodda med sandaler: ”Och iklä er inte två tunikor!” ");
INSERT INTO swessb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Och han sade till dem: ”Där ni går in i ett hus, bli kvar där tills ni går ut därifrån. ");
INSERT INTO swessb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Och den plats som inte välkomnar er eller lyssnar till er, gå ut därifrån och skaka av stoftet under era fötter till ett vittnesbörd för dem.” ");
INSERT INTO swessb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Och de gick ut och förkunnade att man ska ändra sinne. ");
INSERT INTO swessb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Och många demoner drev de ut, och smorde in många kraftlösa med olja och botade dem. ");
INSERT INTO swessb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Och kung Herodes fick höra. För hans namn hade blivit uppenbart, och man sade att Johannes Döparen är uppväckt från de döda och därför verkar krafterna i honom. ");
INSERT INTO swessb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Men andra sade att det är Elia, och andra sade att det är en profet, som en av profeterna. ");
INSERT INTO swessb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Men när Herodes fick höra, sade han: ”Han som jag halshögg: Johannes. Denne är uppväckt.” ");
INSERT INTO swessb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","För själv hade Herodes sänt ut och gripit Johannes och bundit honom i fängelse på grund av Herodias, hustrun till Filippus hans bror, eftersom han hade gift sig med henne. ");
INSERT INTO swessb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","För Johannes sade till Herodes att: ”Det är inte tillåtet för dig att ha din brors hustru.” ");
INSERT INTO swessb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Och Herodias hade ont i sinnet mot honom och ville döda honom, och kunde inte. ");
INSERT INTO swessb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","För Herodes fruktade Johannes, då han visste att han var en rättfärdig och helig man och bevarade honom. Och när han hörde honom blev han mycket villrådig, och ändå hörde han honom gärna. ");
INSERT INTO swessb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Och när det kom en läglig dag, när Herodes på sin födelsedag gjorde en måltid för sina stormän och befälhavarna och de främsta i Galileen, ");
INSERT INTO swessb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","och när Herodias dotter kom in och dansade, behagade hon Herodes och dem som låg till bords med honom. Och kungen sade till flickan: ”Be mig om vad du vill och jag ska ge dig.” ");
INSERT INTO swessb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Och han svor till henne: ”Vad du än ber mig om ska jag ge dig. Ända till hälften av mitt rike!” ");
INSERT INTO swessb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Och hon gick ut och sade till sin mor: ”Vad ska jag be om?” Och hon sade: ”Johannes Döparens huvud.” ");
INSERT INTO swessb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Och hon gick in direkt med iver till kung­en och bad och sade: ”Jag vill att du med detsamma ger mig på ett fat Johannes Döparens huvud!” ");
INSERT INTO swessb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Och kungen blev djupt bedrövad, men på grund av ederna och dem som låg till bords ville han inte avvisa henne. ");
INSERT INTO swessb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Och direkt sände kungen ut en speculator och beordrade honom att hämta hans huvud. Och han gick bort och halshögg honom i fängelset ");
INSERT INTO swessb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","och hämtade hans huvud på ett fat och gav det till flickan, och flickan gav det till sin mor. ");
INSERT INTO swessb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Och när hans lärjungar fick höra, kom de och tog hans lik och lade det i en grav. ");
INSERT INTO swessb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Och apostlarna samlas hos Jesus, och de berättade för honom allt vad de hade gjort och vad de undervisat. ");
INSERT INTO swessb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Och han säger till dem: ”Kom ni själva enskilt till en öde plats och vila er lite.” För de som kom och de som begav sig var många, och de fick inte ens tillfälle att äta. ");
INSERT INTO swessb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Och de for bort i båten till en öde plats enskilt. ");
INSERT INTO swessb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Och man såg dem bege sig och många insåg, och till fots sprang de från alla städerna tillsammans dit och kom före dem. ");
INSERT INTO swessb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Och när han steg ur, såg han en stor skara och kände innerligt för dem, för de var som får som inte har herde. Och han började undervisa dem mycket. ");
INSERT INTO swessb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Och när timmen redan blivit mycket, kom hans lärjungar fram till honom och sade att: ”Platsen är öde och timmen redan mycket. ");
INSERT INTO swessb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Skicka iväg dem, så att de går bort till gårdarna och byarna runt omkring och köper sig något att äta.” ");
INSERT INTO swessb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Men han svarade och sade till dem: ”Ge dem ni att äta.” Och de säger till honom: ”Ska vi gå bort och köpa bröd för tvåhundra denarer och ge dem att äta?” ");
INSERT INTO swessb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Men han säger till dem: ”Hur många bröd har ni? Bege er och se.” Och de får veta och säger: ”Fem. Och två fiskar.” ");
INSERT INTO swessb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Och han beordrade dem att lägga alla till bordsi festlag efter festlag på det gröna gräset, ");
INSERT INTO swessb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","och de lade sig i grupper efter grupper om hundra och om femtio. ");
INSERT INTO swessb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Och han tog de fem bröden och de två fiskarna, såg upp mot himlen och välsignade, och han bröt bröden och gav till sina lärjungar för att de skulle sätta fram till dem. Och de två fiskarna delade han upp åt alla. ");
INSERT INTO swessb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Och alla åt och blev mätta, ");
INSERT INTO swessb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","och man tog upp bitar, tolv korgars fullheter, och från fiskarna. ");
INSERT INTO swessb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Och de som åt bröden var femtusen män. ");
INSERT INTO swessb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Och direkt nödgade han sina lärjungar att stiga i båten och fara före till andra sidan, till Betsaida, medan han själv skickar iväg skaran. ");
INSERT INTO swessb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Och han tog farväl av dem och gick bort till berget för att bedja. ");
INSERT INTO swessb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Och när det blev kväll, var båten mitt på havet och han själv ensam på land. ");
INSERT INTO swessb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Och han såg dem plågade under rodden, för vinden var emot dem, och omkring fjärde nattväkten kommer han till dem vandrande på havet, och ville gå förbi dem. ");
INSERT INTO swessb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Men när de såg honom vandrande på havet tänkte de sig att det är en fantom, och de skrek högt, ");
INSERT INTO swessb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","för alla såg honom och blev oroade. Men direkt talade han med dem och säger till dem: ”Fatta mod! Jag Är. Frukta inte.” ");
INSERT INTO swessb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Och han steg upp till dem i båten, och vinden lade sig. Och inom sig var de övermåttan väldigt utom sig. ");
INSERT INTO swessb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","För de hade inte förstått detta med bröden, utan deras hjärta var ­förstenat. ");
INSERT INTO swessb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Och de for över till andra sidan och kom till land vid Gennesaret och lade till. ");
INSERT INTO swessb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Och när de steg ur båten, kände man direkt igen honom ");
INSERT INTO swessb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","och sprang omkring i hela den trakten och började ta dem som hade det illa på madrasserna och bära omkring dit man hörde att han är. ");
INSERT INTO swessb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Och varhelst han gick in, i byar eller i städer eller i gårdar, lade man de sjuka på torgen och vädjade till honom att de skulle få röra om så bara hörntofsen på hans mantel. Och de som rörde vid honom blev frälsta. ");
INSERT INTO swessb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Och då samlas hos honom fariseerna och några av de skriftlärda som kommit från Jerusa­lem. ");
INSERT INTO swessb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Och när de ser några av hans lärjungar, att de med oheliga händer, det vill säga otvättade, äter bröden – ");
INSERT INTO swessb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","för fariseerna och alla judarna äter inte om de inte med en näve har tvättat händerna, då de håller fast vid de äldstes tradition, ");
INSERT INTO swessb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","och efter torget äter de inte om de inte har doppat sig, och det finns mycket annat som de har tagit emot för att hålla fast vid: dopp av bägare och kannor och kopparkärl och bäddar – ");
INSERT INTO swessb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","då frågar honom fariseerna och de skriftlärda: ”Varför vandrar inte dina lärjungar efter de äldstes tradition, utan äter brödet med oheliga händer?” ");
INSERT INTO swessb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Men han sade till dem: ”Väl profeterade Jesaja om er hycklare, som det är skrivet: Detta folk hedrar mig med läpparna,   men deras hjärta är fjärran från mig. ");
INSERT INTO swessb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Och fåfängt vördar de mig   när de lär ut läror som är människors påbud. ");
INSERT INTO swessb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ni överger Guds bud och håller fast vid människornas tradition.” ");
INSERT INTO swessb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Och han sade till dem: ”Väl upphäver ni Guds bud för att hålla fast vid er tradition. ");
INSERT INTO swessb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","För Mose har sagt: Hedra din far och din mor, och: Den som talar illa om far eller mor ska döden dö. ");
INSERT INTO swessb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Men ni säger: om en människa säger till fadern eller modern: Korban, det vill säga tempelgåva, är nu det du kunde fått nytta av från mig, ");
INSERT INTO swessb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","då låter ni honom inte längre göra något för fadern eller modern, ");
INSERT INTO swessb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","och ogiltigförklarar Guds ord genom er tradition som ni har fört vidare. Och mycket liknande sådant gör ni.” ");
INSERT INTO swessb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Och han kallade åter till sig skaran och sade till dem: ”Hör mig alla och förstå: ");
INSERT INTO swessb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Det finns inget som är utanför människan och kommer in i honom som kan vanhelga honom. Nej, det som utgår ur människan är det som vanhelgar människan.” ");
INSERT INTO swessb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Och när han kom in i huset från skaran, frågade hans lärjungar honom om liknelsen. ");
INSERT INTO swessb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Och han säger till dem: ”Så är också ni oförståndiga? Fattar ni inte att inget som utifrån går in i människan kan vanhelga honom? ");
INSERT INTO swessb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","För det går inte in i hans hjärta utan ner i buken och kommer ut på avträdet, renande alla matämnena.” ");
INSERT INTO swessb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Och han sade att: ”Det som utgår ur män­niskan, det vanhelgar människan. ");
INSERT INTO swessb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","För inifrån, från människornas hjärta, utgår de onda tankarna: otuktigheter, stölder, mord, ");
INSERT INTO swessb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","äktenskapsbrott, girigheter, elakheter, svek, hämningslöshet, elakt öga, hädelse, högmod, tanklöshet. ");
INSERT INTO swessb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Allt detta elaka utgår inifrån och vanhelgar människan.” ");
INSERT INTO swessb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Och därifrån stod han upp och gick bort till Tyrus område. Och han gick in i ett hus och ville att ingen skullefå veta. Och han kunde inte undgå upptäckt, ");
INSERT INTO swessb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","utan direkt hörde en kvinna om honom vars lilla dotter hade en oren ande, och hon kom och föll ner för hans fötter. ");
INSERT INTO swessb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Och kvinnan var grekisktalande, syrisk-­fenicisk till släktet. Och hon tillfrågade honom om att driva ut demonen ur hennes dotter. ");
INSERT INTO swessb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Och han sade till henne: ”Låt först barnen mätta sig. För det är inte fint att ta brödet från barnen och kasta åt småhundarna.” ");
INSERT INTO swessb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Men hon svarade och säger till honom: ”Herre, även småhundarna under bordet äter av barnens smulor.” ");
INSERT INTO swessb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Och han sade till henne: ”För det ordet: Bege dig. Den har kommit ut ur din dotter, demonen.” ");
INSERT INTO swessb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Och hon gick bort till sitt hus och fann barnet liggande på sängen och demonen utkommen. ");
INSERT INTO swessb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Och åter gick han bort från Tyrus område och gick genom Sidon till Gali­leiska havet, mitt i Dekapolisområdet. ");
INSERT INTO swessb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Och man för till ho­nom en döv och knappt talande och vädjar till honom att lägga handen på honom. ");
INSERT INTO swessb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Och han tog undan honom från skaran enskilt och satte sina fingrar i hans öron, och spottade och rörde vid hans tunga. ");
INSERT INTO swessb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Och han såg upp mot himlen och suckade, och säger till honom: ”Heppatah!”, det vill säga: ”Öppna upp dig!” ");
INSERT INTO swessb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Och då öppnades hans öron, och hans tungas boja löstes och han talade riktigt. ");
INSERT INTO swessb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Och han kommenderade dem att inte säga det till någon. Men ju mer han kommenderade dem, ännu mycket mer förkunnade de. ");
INSERT INTO swessb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Och man var övermåttan överväldigad och sade: ”Allt har han gjort väl. Även de döva får han att höra och de stumma att tala.” ");
INSERT INTO swessb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","I de dagarna, när det åter­ var en stor skara och de hade inget att äta, kallade han till sig lärjungarna och säger till dem: ");
INSERT INTO swessb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","”Jag känner innerligt för skaran. För det är redan tre dagar de är kvar hos mig, och de har inget att äta. ");
INSERT INTO swessb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Och om jag skickar iväg dem fastande till sitt hus blir de utmattade på vägen. Och några av dem har kommit långt ifrån.” ");
INSERT INTO swessb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Och då svarade honom hans lärjungar att: ”Varifrån ska någon här kunna mätta dessa med bröd i en ödetrakt?” ");
INSERT INTO swessb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Och han frågade dem: ”Hur många bröd har ni?” Och de svarade: ”Sju.” ");
INSERT INTO swessb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Och han instruerar skaran att lägga sig till bords på jorden. Och han tog de sju bröden, tackade och bröt och gav till sina lärjungar för att de skulle sätta fram, och de satte fram till skaran. ");
INSERT INTO swessb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","De hade också lite småfiskar, och han välsignade dem och sade till att sätta fram även dessa. ");
INSERT INTO swessb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Och de åt och blev mätta, och man tog upp det som blev över av bitar, sju vasskorgar. ");
INSERT INTO swessb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Och det var omkring fyratusen. Och han skickade iväg dem. ");
INSERT INTO swessb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Och direkt steg han i båten med sina lärjungar och kom till trakterna av Dalmanuta. ");
INSERT INTO swessb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Och då kom fariseerna ut och började diskutera med honom, och de sökte från honom ett tecken från himlen och testade honom. ");
INSERT INTO swessb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Och han suckade djupt i sin ande och säger: ”Varför söker detta släkte ett tecken? Amen, jag säger er: Aldrig ska det ges detta släkte ett tecken.” ");
INSERT INTO swessb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Och han lämnade dem och steg åter i båten och for iväg till andra sidan. ");
INSERT INTO swessb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Och de hade glömt ta bröd, och förutom ett enda bröd hade de inget med sig i båten. ");
INSERT INTO swessb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Och han kommenderade dem och sade: ”Se till och se upp för fariseernas surdeg och för Hero­des surdeg.” ");
INSERT INTO swessb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Och de funderade med varandra, för de hade inga bröd. ");
INSERT INTO swessb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Och han förstod och säger till dem: ”Varför funderar ni över att ni inte har bröd? Fattar ni fortfarande inte eller förstår? Har ni ert hjärta förstenat? ");
INSERT INTO swessb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Har ni ögon och ser inte, och har ni öron och hör inte? Och minns ni inte ");
INSERT INTO swessb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","när jag bröt de fem bröden till de femtusen? Hur många korgar med bitar tog ni fulla?” De säger till honom: ”Tolv.” – ");
INSERT INTO swessb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","”När det var de sju till de fyratusen, hur många vasskorgars fullheter med bitar tog ni?” Och de säger till honom: ”Sju.” ");
INSERT INTO swessb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Och han sade till dem: ”Förstår ni fortfarande inte?” ");
INSERT INTO swessb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Och de kommer till Betsaida. Och man för till honom en blind och vädjar till honom att han ska röra vid honom. ");
INSERT INTO swessb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Och han tog tag i den blindes hand och förde ut honom utanför byn. Och han spottade i hans ögon, lade händerna på honom och frågade honom: ”Om du ser något?” ");
INSERT INTO swessb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Och han såg upp och sade: ”Jag ser människorna, för jag ser som träd som går ­omkring.” ");
INSERT INTO swessb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sedan lade han åter händerna på hans ögon, och han såg bra och var återställd och såg alltihop klart. ");
INSERT INTO swessb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Och han sände honom till sitt hus och sade: ”Inte ens in i byn ska du gå in.” ");
INSERT INTO swessb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Och sedan gick Jesus och hans lärjungar ut till byarna vid Caesarea Filippi. Och på vägen frågade han sina lärjungar och sade till dem: ”Vem säger människorna att jag är?” ");
INSERT INTO swessb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Och de talade till honom och sade att: ”Johannes Döparen. Och andra Elia, och andra att det är en av profeterna.” ");
INSERT INTO swessb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Och själv frågade han dem: ”Och ni? Vem säger ni att jag är?” Petrus svarar och säger till honom: ”Du är Kristus.” ");
INSERT INTO swessb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Och han näpste dem, att de inte till någon skulle säga detta om honom. ");
INSERT INTO swessb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Och han började undervisa dem att: ”Människosonen måste lida mycket och bli förkastad av de äldste och översteprästerna och de skriftlärda och dödas. Och efter tre dagar uppstå.” ");
INSERT INTO swessb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Och öppet ­talade han ordet. Och Petrus tog med honom och började näpsa honom, ");
INSERT INTO swessb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","men han vände om och såg sina lärjungar och näpste Petrus och säger: ”Bege dig efter mig, Satan! För du tänker inte på Guds ting utan män­niskornas.” ");
INSERT INTO swessb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Och han kallade till sig skaran med sina lärjungar och sade till dem: ”Om någon vill följa efter mig, ska han förneka sig själv och ta upp sitt kors och följa mig. ");
INSERT INTO swessb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","För den som vill frälsa sin själ ska förlora den, men den som förlorar sin själ för min och evangeliets skull ska frälsa den. ");
INSERT INTO swessb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","För vilken nytta gör det för en människa att vinna hela världen och mista sin själ? ");
INSERT INTO swessb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","För vad kan en människa ge i utbyte för sin själ? ");
INSERT INTO swessb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","För den som skäms för mig och mina ord i detta otrogna och syndiga släkte, honom ska också Människosonen skämmas för när han kommer i sin Fars härlighet med de heliga änglarna.” ");
INSERT INTO swessb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Och han sade till dem: ”Amen, jag säger er att: Det finns några av dem som står här som inte ska smaka döden förrän de sett Guds rike kommet med kraft.” ");
INSERT INTO swessb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Och efter sex dagar tar Jesus med sig Petrus och Jakob och Johannes och för upp dem på ett högt berg enskilt, ensamma. Och han förvandlades inför dem, ");
INSERT INTO swessb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","och hans kläder blev väldigt glimmande vita, sådana att en tyg­beredare på jorden inte kan bleka så. ");
INSERT INTO swessb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Och då visade sig för dem Elia med Mose, och de samtalade med Jesus. ");
INSERT INTO swessb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Och då svarar Petrus och säger till Jesus: ”Rabbi, det är fint att vi är här. Och vi ska göra tre hyddor: åt dig en, och åt Mose en, och åt Elia en.” ");
INSERT INTO swessb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","För han visste inte vad han svarade, för de hade blivit skräckslagna. ");
INSERT INTO swessb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Och det kom ett moln som överskuggade dem, och det kom en röst ur molnet: ”Denne är min Son, den Älskade. Lyssna till honom!” ");
INSERT INTO swessb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Och plötsligt, när de såg sig omkring, såg de inte längre någon utom Jesus ensam med dem. ");
INSERT INTO swessb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Och när de gick ner från berget, kommenderade han dem att inte skildra för någon det de hade sett, utom när Människosonen uppstått från de döda. ");
INSERT INTO swessb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Och det ordet höll de fast vid och diskuterade med varann vad det är att uppstå från de döda. ");
INSERT INTO swessb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Och de frågade honom och sade att: ”De skriftlärda säger att Elia måste komma först?” ");
INSERT INTO swessb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Och han sade till dem: ”Elia kommer först och återställer allt. Och hur är det skrivet om Människosonen? Att han ska lida mycket och bli föraktad. ");
INSERT INTO swessb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Men jag säger er att Elia också har kommit. Och de gjorde med honom vad de ville, så som det är skrivet om honom.” ");
INSERT INTO swessb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Och de kom till lärjungarna och såg en stor skara omkring dem, och skriftlärda som diskuterade med dem. ");
INSERT INTO swessb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Och direkt, när hela skaran såg honom, var de fulla av häpnad och sprang fram och hälsade honom. ");
INSERT INTO swessb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Och han frågade dem: ”Vad diskuterar ni med dem?” ");
INSERT INTO swessb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Och då svarade honom en ur skaran: ”Lärare, jag har fört min son till dig, och han har en stum ande. ");
INSERT INTO swessb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Och varhelst den greppar honom sliter den omkull honom, och han fradgar och knirkar tänderna och skrumpnar ihop. Och jag sade till dina lärjungar att driva ut den, och de mäktade inte.” ");
INSERT INTO swessb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Och han svarar dem och säger: ”O otroende släkte, hur länge ska jag vara hos er? Hur länge ska jag stå ut med er? För honom till mig.” ");
INSERT INTO swessb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Och de förde honom till honom. Och när anden såg honom ruskade den honom direkt, och han föll till jorden och rullade sig och fradgade. ");
INSERT INTO swessb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Och han frågade hans far: ”Hur lång tid är det som detta har hänt honom?” Och han sade: ”Sedan barndomen. ");
INSERT INTO swessb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Och många gånger har den kastat honom både i eld och i vatten för att förgöra honom. Men om du kan något, hjälp oss och känn med oss!” ");
INSERT INTO swessb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Men Jesus sade till honom: ”Om du kan? Allt är möjligt för den som tror.” ");
INSERT INTO swessb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Direkt skrek barnets far och sade: ”Jag tror! Hjälp min otro!” ");
INSERT INTO swessb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Och när Jesus såg att det åter springer samman en skara, näpste han den orena anden och sade till den: ”Stumma och döva ande, jag beordrar dig: kom ut ur honom och far aldrig mer in i honom!” ");
INSERT INTO swessb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Och den skrek och ruskade mycket och kom ut. Och han blev som död, så att de flesta sade att han hade dött. ");
INSERT INTO swessb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Men Jesus grep hans hand och reste upp honom, och han stod upp. ");
INSERT INTO swessb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Och när han hade kommit in i ett hus, frågade hans lärjungar honom enskilt: ”Varför kunde inte vi driva ut den?” ");
INSERT INTO swessb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Och han sade till dem: ”Detta släkte kan inte komma ut med något utom med bön.” ");
INSERT INTO swessb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Och därifrån gick de ut och passerade genom Galileen. Och han ville inte att någon skulle veta, ");
INSERT INTO swessb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","för han undervisade sina lärjungar och sade till dem att: ”Människosonen utlämnas i män­niskors händer, och de ska döda honom. Och dödad ska han efter tre dagar uppstå.” ");
INSERT INTO swessb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Men de förstod inte ordet, och fruktade för att fråga honom. ");
INSERT INTO swessb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Och de kom till Kapernaum, och kommen i huset frågade han dem: ”Vad var det på vägen ni funderade över?” ");
INSERT INTO swessb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Men de var tysta, för med varandra hade de resonerat på vägen vem som är störst. ");
INSERT INTO swessb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Och han satte sig och ropade på de tolv, och säger till dem: ”Om någon vill vara ­först, ska han vara sist av alla och allas tjänare.” ");
INSERT INTO swessb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Och han tog ett barn och ställde det mitt ibland dem, och tog det i famnen och sade till dem: ");
INSERT INTO swessb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","”Den som välkomnar ett av dessa barn vid mitt namn välkomnar mig. Och den som välkomnar mig, välkomnar inte mig utan ­honom som har sänt mig.” ");
INSERT INTO swessb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannes sade till honom: ”Lärare, vi såg en som i ditt namn drev ut demoner. Och vi hindrade honom, eftersom han inte följde oss.” ");
INSERT INTO swessb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Men Jesus sade: ”Hindra honom inte. För det finns ingen som kommer att göra en kraftgärning vid mitt namn och sedan fort kunna tala illa om mig. ");
INSERT INTO swessb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","För den som inte är emot oss, är för oss. ");
INSERT INTO swessb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","För den som ger er en bägare vatten att dricka i namnet att ni tillhör Kristus – amen, jag säger er att han aldrig ska förlora sin lön. ");
INSERT INTO swessb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Och den som skandaliserar en av dessa små som tror på mig, för honom är det mer bra om en åsnekvarnsten fattar om hans hals och han blir kastad i havet. ");
INSERT INTO swessb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Och om din hand skandaliserar dig, hugg av den. Det är bra att du går handikappad in i livet, hellre än att ha de två händerna och gå bort till Gehenna, till den osläckbara elden. ");
INSERT INTO swessb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Och om din fot skandaliserar dig, hugg av den. Det är bra att du går in i livet halt, hellre än att ha båda fötterna och kastas i Gehenna. ");
INSERT INTO swessb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Och om ditt öga skandaliserar dig, kasta ut det. Det är bra att du enögd går in i Guds rike, hellre än att ha två ögon och kastas i Gehenna, ");
INSERT INTO swessb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","där deras mask inte dör och elden inte släcks. ");
INSERT INTO swessb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","För var och en ska med eld saltas. ");
INSERT INTO swessb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Saltet är bra, men om saltet blir osalt, med vad ska ni krydda det? Ha salt i er och var fridsamma med varandra.” ");
INSERT INTO swessb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Och därifrån står han upp och går till Judeens område och andra sidan Jordan. Och det vandrar åter skaror med varann till honom, och som han hade för sed började han åter undervisa dem. ");
INSERT INTO swessb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Och det kom fram fariseer och frågade honom om det är tillåtet för en man att förskjuta sin hustru, och de testade honom. ");
INSERT INTO swessb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Och han svarade och sade till dem: ”Vad har Mose påbjudit er?” ");
INSERT INTO swessb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Och de sade: ”Mose har tillåtit att skriva ett skilsmässobrev och förskjuta.” ");
INSERT INTO swessb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Men Jesus sade till dem: ”För er hårdhjärtadhet skrev han för er detta bud. ");
INSERT INTO swessb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Men från skapelsens begynnelse var dettill hanne och hona han gjorde dem. ");
INSERT INTO swessb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Därför ska en man lämna sin far och mor och ansluta sig till sin hustru, ");
INSERT INTO swessb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","och de två ska bli till ett kött. Alltså är de inte längre två, utan ett kött. ");
INSERT INTO swessb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vad nu Gud har okat samman ska en människa inte skilja åt.” ");
INSERT INTO swessb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Och i huset igen frågade lärjungarna honom om detta. ");
INSERT INTO swessb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Och han säger till dem: ”Den som förskjuter sin hustru och gifter sig med en annan begår äktenskapsbrott mot henne. ");
INSERT INTO swessb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Och om hon förskjuter sin man och gifter sig med en annan, begår hon äktenskapsbrott.” ");
INSERT INTO swessb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Och man bar fram till honom barn för att han skulle röra vid dem. Men lärjungarna näpste dem. ");
INSERT INTO swessb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Men när Jesus såg det, blev han indignerad och sade till dem: ”Låt barnen komma till mig! Hindra dem inte. För sådanas är Guds rike. ");
INSERT INTO swessb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Amen, jag säger er: Den som inte välkomnar Guds rike som ett barn kommer aldrig in i det.” ");
INSERT INTO swessb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Och han tog dem i famnen och välsignade dem och lade händerna på dem. ");
INSERT INTO swessb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Och när han vandrade ut på vägen, sprang en fram och knäföll för honom och frågade honom: ”Gode Lärare, vad ska jag göra för att ärva eoniskt liv?” ");
INSERT INTO swessb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Men Jesus sade till honom: ”Varför kallar du mig god? Ingen är god utom en: Gud. ");
INSERT INTO swessb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Buden kan du: Du ska inte mörda. Du ska inte begå äktenskapsbrott. Du ska inte stjäla. Du ska inte vittna falskt. Du ska inte beröva. Hedra din far och mor.” ");
INSERT INTO swessb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Men han sade till honom: ”Lärare, allt detta har jag iakttagit från min ungdom.” ");
INSERT INTO swessb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Och Jesus såg på honom och älskade honom, och han sade till honom: ”Ett saknas för dig. Bege dig, sälj vad du har och ge till de fattiga, och du kommer att ha en skatt i himlen. Och kom, följ mig.” ");
INSERT INTO swessb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Men han mulnade vid det ordet och gick bort bedrövad, för han hade många egendomar. ");
INSERT INTO swessb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Och Jesus såg sig omkring och säger till sina lärjungar: ”Hur svårt ska de som har pengarna komma in i Guds rike!” ");
INSERT INTO swessb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Och lärjungarna var häpna vid hans ord. Men Jesus svarar åter och säger till dem: ”Barn, hur svårt det är att komma in i Guds rike! ");
INSERT INTO swessb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Det är lättare att en kamel kommer in genom nålsögat än att en rik kommer in i Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Och de blev ännu mer överväldigade och sade till varann: ”Och vem kan då bli frälst?” ");
INSERT INTO swessb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus ser på dem och säger: ”För människor är det omöjligt, men inte för Gud. För allt är möjligt för Gud.” ");
INSERT INTO swessb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus började säga till honom: ”Se: vi har lämnat allt och följt dig.” ");
INSERT INTO swessb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus sade: ”Amen, jag säger er: Det finns ingen som har lämnat hus eller bröder eller systrar eller mor eller far eller barn eller åkrar för mig och för evangeliet ");
INSERT INTO swessb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","och inte får hundrafalt: nu i denna tid hus och bröder och systrar och mödrar och barn och åkrar, med förföljelser, och i den kommande eonen eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Men många första ska bli sista, och de sista första.” ");
INSERT INTO swessb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Och de var på vägen och gick upp till Jerusalem, och Jesus gick före dem. Och de var häpna, och de som följde fruktade. Och han tog åter med de tolv och började säga till dem det som skulle hända honom, ");
INSERT INTO swessb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","att: ”Se: vi går upp till Jerusalem, och Människosonen ska utlämnas till översteprästerna och de skriftlärda. Och de ska fördöma honom till döden och utlämna honom åt folkslagen, ");
INSERT INTO swessb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","och de ska förlöjliga honom och spotta på honom och piska honom och döda. Och efter tre dagar ska han uppstå.” ");
INSERT INTO swessb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Och då går Jakob och Johannes, Sebedeus söner, fram till honom och säger till honom: ”Lärare, vi vill att vadhelst vi ber dig ska du göra för oss.” ");
INSERT INTO swessb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Och han sade till dem: ”Vad vill ni att jag ska göra för er?” ");
INSERT INTO swessb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Och de sade till honom: ”Ge oss att vi får sitta en vid din högra sida och en vid vänstra i din härlighet.” ");
INSERT INTO swessb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Men Jesus sade till dem: ”Ni vet inte vad ni ber om. Kan ni dricka bägaren som jag dricker? Eller döpas med dopet med vilket jag döps?” ");
INSERT INTO swessb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Och de sade till honom: ”Vi kan.” Och Jesus sade till dem: ”Bägaren som jag dricker ska ni dricka, och dopet med vilket jag döps ska ni döpas med. ");
INSERT INTO swessb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Men att sitta vid min högra sida eller vid vänstra är inte mitt att ge, utan för dem åt vilka det beretts.” ");
INSERT INTO swessb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Och när de tio hörde det, började de bli indignerade över Jakob och Johannes. ");
INSERT INTO swessb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Och Jesus kallade till sig dem och säger till dem: ”Ni vet att de som anses leda folkslagen dominerar dem och att deras stora utövar makt över dem. ");
INSERT INTO swessb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Men så är det inte hos er. Nej, den som vill bli stor bland er ska vara er tjänare, ");
INSERT INTO swessb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","och den som bland er vill vara först ska vara allas fasttjänare. ");
INSERT INTO swessb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","För även Människosonen har inte kommit för att bli betjänad, utan betjäna och ge sin själ till lösen för många.” ");
INSERT INTO swessb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Och de kommer till Jeriko. Och när han gick ut från Jeriko med sina lärjungar och en avsevärd skara satt Timeus son Bartimeus, en blind tiggare, vid vägen. ");
INSERT INTO swessb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Och när han hörde att det är Jesus Nasarén, började han skrika och säga: ”Davids son, Jesus, förbarma dig över mig!” ");
INSERT INTO swessb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Och många näpste honom att vara tyst, men han skrek ännu mer: ”Davids son, förbarma dig över mig!” ");
INSERT INTO swessb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Och Jesus stannade och sade: ”Ropa på honom!” Och de ropar på den blinde och säger till honom: ”Fatta mod! Res dig, han ropar på dig.” ");
INSERT INTO swessb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Och han kastade av sig sin mantel, hoppade upp och kom till Jesus. ");
INSERT INTO swessb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Och Jesus svarade honom och sade: ”Vad vill du jag ska göra för dig?” Och den blinde sade till honom: ”Rabbuni, att jag ska se igen!” ");
INSERT INTO swessb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Och Jesus sade till honom: ”Bege dig. Din tro har frälst dig.” Och direkt såg han igen, och han följde honom på vägen. ");
INSERT INTO swessb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Och när de närmar sig Jerusalem mot Betfage och Beta­nia vid Olivberget, sänder han ut två av sina lärjungar ");
INSERT INTO swessb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","och säger till dem: ”Bege er till byn mittemot er. Och direkt, när ni går in i den, ska ni finna ett föl bundet på vilket ingen av människor ännu har suttit. Lossa det och hämta. ");
INSERT INTO swessb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Och om någon säger till er: Varför gör ni detta?, säg att: Herren har behov av det. Och direkt sänder han det åter hit.” ");
INSERT INTO swessb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Och de gick iväg och fann ett föl bundet vid en dörr ute på kringvägen, och de lossar det. ");
INSERT INTO swessb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Och några av dem som stod där sade till dem: ”Vad gör ni, lossar ni fölet?” ");
INSERT INTO swessb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Men de sade till dem så som Jesus hade sagt, och man tillät dem. ");
INSERT INTO swessb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Och de hämtar fölet till Jesus och kastar över det sina mantlar, och han satte sig på det. ");
INSERT INTO swessb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Och många bredde ut sina mantlar på vägen, och andra slog lövruskor från fälten. ");
INSERT INTO swessb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Och de som gick före och de som följde skrek: ”Hosianna! Välsignad är han som kommer i Herrens namn! ");
INSERT INTO swessb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Välsignat är vår fader Davids kommande rike! Hosianna i det högsta!” ");
INSERT INTO swessb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Och han kom in i Jerusalem till templet. Och när han hade sett sig omkring på allt, då det redan var kväll till timmen, gick han ut till Betania med de tolv. ");
INSERT INTO swessb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Och när de dagen därpå gick ut från Betania blev han hungrig. ");
INSERT INTO swessb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Och han såg ett fikonträd långt ifrån som hade löv, och kom ifall han då skulle finna något på det. Och när han kom till det, fann han inget utom löv. För det var inte tid för fikon. ");
INSERT INTO swessb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Och han svarade och sade till det: ”Aldrig mer till eonen må någon äta frukt från dig.” Och hans lärjungar hörde. ");
INSERT INTO swessb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Och de kommer till Jerusalem. Och han gick in i templet och började driva ut dem som sålde och dem som köpte i templet. Och växlarnas bord och stolarna för dem som sålde duvorna välte han, ");
INSERT INTO swessb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","och tillät inte att någon bar ett kärl genom templet. ");
INSERT INTO swessb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Och han undervisade och sade till dem: ”Är det inte skrivet att: Mitt hus ska kallas ett bönens hus   för alla folkslagen?   Men ni har gjort det tillen rövargrotta!” ");
INSERT INTO swessb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Och översteprästerna och de skriftlärda hörde, och de sökte hur de skulle förgöra honom. För de fruktade honom, för hela skaran var överväldigad vid hans undervisning. ");
INSERT INTO swessb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Och när det blev sent, gick han ut utanför staden. ");
INSERT INTO swessb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Och när de passerade förbi på morgonen, såg de fikonträdet vissnat från rötterna. ");
INSERT INTO swessb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Och påmind säger Petrus till honom: ”Rabbi, se! Fikonträdet som du förbannade har vissnat.” ");
INSERT INTO swessb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Och Jesus svarar och säger till dem: ”Ha tro på Gud. ");
INSERT INTO swessb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Amen, jag säger er att den som säger till detta berg: Var lyft och kastad i havet, och inte tvivlar i sitt hjärta utan tror att det han talar ska hända – det ska ske för honom. ");
INSERT INTO swessb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Därför säger jag er: Allt vad ni beder och ber om, tro att ni har fått det, och det ska ske för er. ");
INSERT INTO swessb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Och när ni står och beder, förlåt om ni har något emot någon, så att också er Far i himlarna förlåter er era felsteg.” ");
INSERT INTO swessb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Och de kommer åter in i Jerusalem. Och i templet, när han går omkring, kommer översteprästerna och de skriftlärda och de äldste fram till honom ");
INSERT INTO swessb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","och säger till honom: ”Med vilken auktoritet gör du detta? Eller vem har gett dig denna auktoritet att du ska göra detta?” ");
INSERT INTO swessb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Men Jesus sade till dem: ”Jag ska fråga er en sak. Och svara mig, och jag ska säga er med vilken auktoritet jag gör detta. ");
INSERT INTO swessb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johannes dop, var det från himlen? Eller från människor? Svara mig.” ");
INSERT INTO swessb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Och de funderade med varann och sade: ”Om vi säger: Från himlen, kommer han att säga: Varför trodde ni då inte på honom? ");
INSERT INTO swessb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Men ska vi säga: Från människor?” De fruktade folket, för allihop höll Johannes att han verkligen var profet. ");
INSERT INTO swessb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Och de svarar Jesus och säger: ”Vi vet inte.” Och Jesus säger till dem: ”Inte heller jag säger till er med vilken auktoritet jag gör detta.” ");
INSERT INTO swessb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Och han började tala till dem i liknelser: ”En man planterade en vingård och satte stängsel runt och grävde en vinpress och byggde ett torn och arrenderade ut den till odlare och reste bort. ");
INSERT INTO swessb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Och han sände till odlarna vid den bestämda tiden en fasttjänare, för att få från odlarna av vingårdens frukter. ");
INSERT INTO swessb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Och de tog honom och pryglade och sände iväg tomhänt. ");
INSERT INTO swessb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Och åter sände han till dem en annan fasttjänare. Och denne slog de i huvudet och vanhedrade. ");
INSERT INTO swessb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Och en annan sände han, och denne dödade de, och många andra: några pryglade de, andra dödade de. ");
INSERT INTO swessb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ännu hade han en enda, en älskad son. Han sände ­honom sist till dem och sade att: De kommer att ha respekt för min son. ");
INSERT INTO swessb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Men dessa odlare sade till varann att: Denne är arv­tagaren! Kom, låt oss döda honom och arvet blir vårt. ");
INSERT INTO swessb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Och de tog och dödade honom och kastade ut honom utanför vingården. ");
INSERT INTO swessb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Vad ska nu vingårdens herre göra? Han ska komma och förgöra odlarna och ge vingården till andra. ");
INSERT INTO swessb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Har ni heller inte läst denna Skrift: Stenen som husbyggarna förkastade,   den har blivit till en hörnsten.  ");
INSERT INTO swessb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Från Herren kom den,   och den är förunderlig i våra ögon.” ");
INSERT INTO swessb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Och de sökte gripa honom, och de fruktade skaran, för de förstod att det var om dem han hade talat liknelsen. Och de lämnade honom och gick iväg. ");
INSERT INTO swessb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Och de sänder till honom några av fariseerna och herodianerna för att fånga in honom med ord. ");
INSERT INTO swessb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Och de kommer och säger till honom: ”Lärare, vi vet att du är sann och inte bryr dig om någon, för du ser inte till människors ansikte utan lär i sanning ut Guds väg. Är det tillåtet att ge huvudskatt till kejsaren eller inte? Ska vi ge, eller ska vi inte ge?” ");
INSERT INTO swessb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Men han visste om deras hyckleri och sade till dem: ”Varför testar ni mig? Hämta mig en denar så att jag får se.” ");
INSERT INTO swessb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Och de hämtade, och han säger till dem: ”Vems är denna avbild och överskrift?” Och de sade till honom: ”Kejsarens.” ");
INSERT INTO swessb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Och Jesus sade till dem: ”Det som är kejsarens ska ni återge till kejsaren, och det som är Guds till Gud.” Och de var djupt förundrade över honom. ");
INSERT INTO swessb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Och det kommer saddukeer till honom, de som säger att uppståndelse inte finns. Och de frågade honom och sade: ");
INSERT INTO swessb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”Lärare, Mose skrev till oss att om någons bror dör och lämnar hustru och inte lämnar barn, att hans bror ska ta hustrun och låta säd uppstå fram åt sin bror. ");
INSERT INTO swessb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Det fanns sju bröder. Och den förste tog en hustru, och när han dog lämnade han ingen säd. ");
INSERT INTO swessb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Och den andre tog henne och dog och lämnade ingen säd. Och den tredje på samma sätt, ");
INSERT INTO swessb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","och de sju lämnade ingen säd. Sist av alla dog även kvinnan. ");
INSERT INTO swessb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vid uppståndel­sen, när de uppstår, till vem av dem blir hon hustru? För de sju hade henne som hustru.” ");
INSERT INTO swessb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus sade till dem: ”Är det inte därför ni förvillar er, då ni inte förstår Skrifterna eller Guds makt? ");
INSERT INTO swessb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","För när de uppstår från de döda varken gifter de sig eller blir bortgifta, utan de är som änglar i himlarna. ");
INSERT INTO swessb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Men om de döda, att de uppväcks: har ni inte läst i Moses bok vid törnbusken, hur Gud talade till honom och sade: Jag är Abrahams Gud och Isaks Gud och Jakobs Gud? ");
INSERT INTO swessb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Han är inte dödas Gud utan levandes. Ni förvillar er mycket.” ");
INSERT INTO swessb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Och det kom fram en av de skriftlärda som hade hört dem diskutera och sett att han svarat dem väl, och frågade honom: ”Vilket bud är först av alla?” ");
INSERT INTO swessb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus svarade att: ”Först är: Hör Israel! Herren vår Gud, Herren är en. ");
INSERT INTO swessb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Och du ska älska Herren din Gud av hela ditt hjärta, och av hela din själ, och av hela ditt förnuft, och av hela din styrka. ");
INSERT INTO swessb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ett andra är detta: Du ska älska din nästa som dig själv. Ett annat bud större än dessa finns inte.” ");
INSERT INTO swessb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Och den skriftlärde sade till honom: ”Bra, Lärare! I sanning har du sagt att han är en, och det finns ingen annan än han. ");
INSERT INTO swessb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Och att älska honom av hela hjärtat och av hela förnuftet och av hela styrkan, och att älska sin nästa som sig själv, är mycket mer än alla brännoffren och slaktoffren.” ");
INSERT INTO swessb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Och Jesus såg honom, att han svarat förnuftigt, och sade till honom: ”Du är inte långt från Guds rike.” Och ingen vågade längre fråga honom. ");
INSERT INTO swessb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Och Jesus svarade och sade när han undervisade i templet: ”Hur kan de skriftlärda säga att Kristus är Davids son? ");
INSERT INTO swessb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David själv har sagt i den heliga Anden: Herren sade till min Herre:   Sätt dig vid min högra sida   tills jag lagt dina fiender   under dina fötter. ");
INSERT INTO swessb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David själv kallar honom Herre. Och varifrån är han hans son?” Och den stora skaran hörde honom gärna, ");
INSERT INTO swessb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","och i sin undervisning sade han: ”Akta er för de skriftlärda, som vill gå omkring i dräkter och få hälsningar på torgen ");
INSERT INTO swessb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","och förstapositioner i synagogorna och förstaplatser vid måltiderna, ");
INSERT INTO swessb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","de som äter upp änkornas hus och som förevändning beder långt. Dessa ska få så mycket mer dom.” ");
INSERT INTO swessb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Och han satte sig mittemot skattkammaren och skådade hur skaran lägger koppar i skattkammaren. Och många rika lade mycket. ");
INSERT INTO swessb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Och det kom en fattig änka och lade två leptoner, det vill säga en quadrant. ");
INSERT INTO swessb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Och han kallade till sig sina ­lärjungar och sade till dem: ”Amen, jag säger er att denna fattiga änka lade mer än alla som lade i skattkammaren. ");
INSERT INTO swessb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","För alla lade av sitt överflöd, men hon lade ur sin brist allt vad hon hade, alla sina tillgångar.” ");
INSERT INTO swessb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Och när han går ut från templet, säger en av hans lärjungar till honom: ”Lärare, se hurdana stenar och hurdana byggnader!” ");
INSERT INTO swessb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Och Jesus sade till honom: ”Ser du dessa stora byggnader? Här ska inte lämnas sten på sten som inte ska rivas ner.” ");
INSERT INTO swessb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Och när han satt vid Olivberget mittemot templet, frågade honom Petrus och Jakob och Johannes och Andreas enskilt: ");
INSERT INTO swessb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","”Säg oss: När ska detta ske? Och vad blir tecknet när allt detta kommer att fullbordas?” ");
INSERT INTO swessb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Och Jesus började säga till dem: ”Se upp att ingen förvillar er. ");
INSERT INTO swessb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Många ska komma vid mitt namn och säga att: Jag Är, och många ska de förvilla. ");
INSERT INTO swessb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Men när ni hör krig och hörsägner om krig, bli inte skärrade. Det måste ske, men det är ännu inte slutet. ");
INSERT INTO swessb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","För folkslag ska resa sig mot folkslag och rike mot rike. Det ska bli jordbävningar på olika platser, det ska bli svälter. Våndors begynnelse är detta. ");
INSERT INTO swessb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Men se ni upp med er själva. De ska utlämna er till sanhedriner, och i synagogor ska ni bli pryglade och inför styresmän och kungar ska ni ställas för min skull, till ett vittnesbörd för dem. ");
INSERT INTO swessb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Och för alla folkslagen först måste evangeliet förkunnas. ");
INSERT INTO swessb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Och när de för bort och utlämnar er, bekymra er inte i förväg vad ni ska tala. Nej, vad som ges er i den stunden, tala det. För det är inte ni som talar, utan den heliga Anden. ");
INSERT INTO swessb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Och bror ska utlämna bror till döds och en far sitt barn, och barn ska resa sig mot föräldrar och döda dem. ");
INSERT INTO swessb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Och ni ska bli hatade av alla för mitt namns skull. Men den som håller ut till slutet, denne ska bli frälst. ");
INSERT INTO swessb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Men när ni ser ödeläggelsens skändlighet stå där den inte får – läsaren må fatta – då ska de i Judeen fly till bergen. ");
INSERT INTO swessb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Men den som är på taket ska inte komma ner eller gå in för att ta upp något från sitt hus, ");
INSERT INTO swessb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","och den som är på åkern ska inte vända om bakåt för att ta upp sin mantel. ");
INSERT INTO swessb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Men ve dem som är havande i magen och dem som ammar i de dagarna! ");
INSERT INTO swessb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Och bed att det inte blir under vinter. ");
INSERT INTO swessb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","För de ­dagarna ska bli en sådan nöd att en sådan inte varit från begynnelsen av skapelsen som Gud skapade fram till nu, och aldrig kommer att ske. ");
INSERT INTO swessb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Och om inte Herren hade förkortat dagarna skulle inget kött bli frälst. Men för de utvalda som han utvalt har han förkortat dagarna. ");
INSERT INTO swessb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Och då, om någon säger till er: Se här är Kristus! Se där! – tro det inte. ");
INSERT INTO swessb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","För det ska resa sig falska Kristusar och ­fal­ska profeter och ge tecken och under för att villa bort, om möjligt, de utvalda. ");
INSERT INTO swessb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Men se ni upp! Jag har förutsagt allt för er. ");
INSERT INTO swessb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Men i de dagarna, efter den nöden, ska solen förmörkas och månen inte ge sitt sken ");
INSERT INTO swessb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","och stjärnorna falla från himlen och makterna i himlarna skakas. ");
INSERT INTO swessb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Och då ska man se Människosonen komma bland moln med stor makt och härlighet. ");
INSERT INTO swessb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Och då ska han sända ut änglarna och församla sina utvalda från de fyra vindarna, från jordens ände till himlens ände. ");
INSERT INTO swessb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Och från fikonträdet ska ni lära er liknelsen: Redan när dess kvist blir mjuk och skjuter fram löven vet ni att sommaren är nära. ");
INSERT INTO swessb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Så också ni: när ni ser detta hända, vet ni att han är nära vid dörrarna. ");
INSERT INTO swessb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Amen, jag säger er att detta släkte inte ska förgå förrän allt detta har skett. ");
INSERT INTO swessb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Himlen och jorden ska förgå, men mina ord ska aldrig förgå. ");
INSERT INTO swessb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Men om den dagen eller stunden vet ingen, varken änglarna i himlen eller Sonen, utom Fadern. ");
INSERT INTO swessb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Se upp, vaka! För ni vet inte när tiden är. ");
INSERT INTO swessb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Det blir som när en bortrest man har lämnat sitt hus och gett sina fasttjänare auktoriteten, åt var och en sin gärning, och dörrvakten påbjöd han att vara vaken. ");
INSERT INTO swessb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Var därför vakna! För ni vet inte när husets herre kommer, antingen sent eller midnatt eller hanegäll eller morgon, ");
INSERT INTO swessb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","så att han inte kommer plötsligt och finner er sovande. ");
INSERT INTO swessb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Och det jag säger till er, säger jag till alla: Var vakna!” ");
INSERT INTO swessb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Men det var påsk och det osyrade brödets högtid om två dagar. Och översteprästerna och de skriftlärda sökte hur de med list skulle gripa och döda honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","För de sade: ”Inte under högtiden, så att det inte blir tumult hos folket.” ");
INSERT INTO swessb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Och när han var i Betania i Simon den spetälskes hus, när han låg till bords, kom en kvinna som hade en alabasterflaska med dyrbar äkta nardusbalsam och bröt upp alabasterflaskan och utgöt över hans huvud. ");
INSERT INTO swessb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Men några var indignerade och sade till varandra: ”Varför har detta fördärv med balsam skett? ");
INSERT INTO swessb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","För denna balsam hade kunnat säljas för över trehundra denarer och ges till de fattiga.” Och de frustade mot henne. ");
INSERT INTO swessb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Men Jesus sade: ”Låt henne vara! Varför skaffar ni henne besvär? Det är en fin gärning hon utfört för mig. ");
INSERT INTO swessb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","För ni har alltid de fattiga hos er, och när ni vill kan ni göra väl mot dem. Men mig har ni inte alltid. ");
INSERT INTO swessb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Det hon hade har hon gjort. Hon tog i förväg att myrrasmörja min kropp för begravningen. ");
INSERT INTO swessb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Och amen, jag säger er: Varhelst evangeliet förkunnas i hela världen ska också det hon gjorde talas om, till minne av henne.” ");
INSERT INTO swessb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Och Judas Iskariot, en av de tolv, gick bort till översteprästerna för att utlämna honom åt dem. ");
INSERT INTO swessb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","När de hörde det, blev de glada och lovade att ge honom silver. Och han började söka hur han lägligt kunde utlämna honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Och den första dagen i det osyrade brödets högtid, när man slaktoffrade påskalammet, säger hans lärjungar till honom: ”Vart vill du vi går bort och bereder så att du kan äta påskalammet?” ");
INSERT INTO swessb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Och han sänder ut två av sina lärjungar och säger till dem: ”Bege er in i staden och det ska möta er en man som bär en vattenkruka. Följ honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Och där han går in, säg till hushärskaren att Läraren säger: Var är mitt gästrum där jag kan äta påskalammet med mina lärjungar? ");
INSERT INTO swessb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Och han ska visa er en stor övre sal inredd och beredd. Och där ska ni bereda för oss.” ");
INSERT INTO swessb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Och lärjungarna gick ut och kom in i staden och fann så som han sagt dem. Och de beredde påskalammet. ");
INSERT INTO swessb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Och när det blir kväll, kommer han med de tolv. ");
INSERT INTO swessb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Och medan de låg till bords och åt sade Jesus: ”Amen, jag säger er att en av er kommer att utlämna mig. Den som äter med mig.” ");
INSERT INTO swessb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","De började bli bedrövade och säga till honom en efter en: ”Inte jag väl?” ");
INSERT INTO swessb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Men han sade till dem: ”En av de tolv. Den som doppar med mig i skålen. ");
INSERT INTO swessb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","För Människosonen beger sig liksom det är skrivet om honom, men ve den människan genom vilken Människosonen blir utlämnad! Det hade varit bra för honom om den människan inte blivit född.” ");
INSERT INTO swessb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Och medan de åt tog han ett bröd, välsignade och bröt och gav åt dem och sade: ”Ta. Detta är min kropp.” ");
INSERT INTO swessb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Och han tog en bägare, tackade och gav åt dem, och de drack ur den alla. ");
INSERT INTO swessb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Och han sade till dem: ”Detta är mitt blod för förbundet, utgjutet för många. ");
INSERT INTO swessb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amen, jag säger er att jag aldrig mer ska dricka av vinstockens frukt förrän den dag då jag dricker det nytt i Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Och när de hade sjungit hymn, gick de ut till Olivberget. ");
INSERT INTO swessb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Och Jesus säger till dem att: ”Alla kommer ni att skandaliseras. För det är skrivet: Jag ska slå herden,   och fåren ska skingras. ");
INSERT INTO swessb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Men efter att jag blivit uppväckt, ska jag gå före er till Galileen.” ");
INSERT INTO swessb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Men Petrus sade till honom: ”Även om alla kommer att skandaliseras, dock inte jag.” ");
INSERT INTO swessb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Och Jesus säger till honom: ”Amen, jag säger dig att du idag, denna natt innan tuppen två gånger gal, ska tre gånger förneka mig.” ");
INSERT INTO swessb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Men han talade ännu mer: ”Även om jag måste dö med dig ska jag aldrig förneka dig!” Och på samma sätt sade också alla. ");
INSERT INTO swessb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Och de kommer till en markbit vars namn är Getsemane, och han säger till sina lärjungar: ”Sitt här medan jag beder.” ");
INSERT INTO swessb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Och han tar Petrus och Jakob och Johannes med sig, och han började bli full av häpnad och ängslas, ");
INSERT INTO swessb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","och säger till dem: ”Min själ är djupt bedrövad till döds. Bli kvar här och var vakna.” ");
INSERT INTO swessb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Och han gick fram lite och föll ner på jorden och bad att, om det är möjligt, denna stund skulle gå förbi från honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Och han sade: ”Abba, Far! Allt är möjligt för dig. För bort denna bägare från mig. Men inte vad jag vill, utan vad du.” ");
INSERT INTO swessb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Och han kommer och finner dem sovande, och säger till Petrus: ”Simon, sover du? Mäktade du inte en timme att vara vaken? ");
INSERT INTO swessb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Var vakna och bed att ni inte kommer i frestelse. Anden är villig, men köttet svagt.” ");
INSERT INTO swessb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Och åter gick han bort och bad och sade samma ord. ");
INSERT INTO swessb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Och åter kom han och fann dem sovande, för deras ögon var nedtyngda och de visste inte vad de skulle svara honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Och han kommer ­tredje gången och säger till dem: ”Sov ni framöver och vila er. Det räcker, stunden har kommit. Se: nu utlämnas Män­niskosonen i syndarnas händer. ");
INSERT INTO swessb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Res er, låt oss dra. Se: han som utlämnar mig är nu nära.” ");
INSERT INTO swessb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Och direkt, medan han ännu talar, kommer Judas dit, en av de tolv, och med honom en skara med svärd och påkar från översteprästerna och de skriftlärda och de äldste. ");
INSERT INTO swessb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Och han som utlämnade honom hade gett dem en signal och sagt: ”Den jag kysser, han är det. Grip honom och för bort säkert.” ");
INSERT INTO swessb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Och han kommer och går direkt fram till honom och säger: ”Rabbi!”, och kysste ner honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Och de lade händerna på honom och grep honom. ");
INSERT INTO swessb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Men en, en av dem som stod bredvid, drog svärdet och högg till översteprästens fasttjänare och tog bort hans öra. ");
INSERT INTO swessb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Och Jesus svarade och sade till dem: ”Som mot en rövare har ni gått ut med svärd och påkar för att ta fast mig. ");
INSERT INTO swessb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Varje dag var jag hos er i templet och undervisade, och ni grep mig inte. Men, för att Skrifterna ska uppfyllas.” ");
INSERT INTO swessb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Och de lämnade honom och flydde alla. ");
INSERT INTO swessb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Och en ung man följde med honom, klädd i ett linnetyg över nakna kroppen. Och de griper honom, ");
INSERT INTO swessb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","men han lämnade kvar linnetyget och flydde naken. ");
INSERT INTO swessb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Och de förde bort Jesus till översteprästen, och där kommer alla översteprästerna och de äldste och de skriftlärda samman. ");
INSERT INTO swessb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Och Petrus följde honom långt ifrån, ända in på översteprästens innergård. Och han var och satt med undertjänarna och värmde sig vid ljuset. ");
INSERT INTO swessb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Men översteprästerna och hela Sanhedrin sökte mot Jesus ett vittnesbörd för att döda honom, och de fann inte. ");
INSERT INTO swessb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","För många vittnade falskt mot honom, och deras vittnesbörd var inte lika. ");
INSERT INTO swessb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Och några stod upp och vittnade falskt mot honom och sade ");
INSERT INTO swessb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","att: ”Vi har hört honom säga att: Jag ska riva ner denna handgjorda tempelbyggnad och på tre dagar bygga upp en annan icke handgjord.” ");
INSERT INTO swessb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Och inte heller så var deras vittnesbörd likt. ");
INSERT INTO swessb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Och översteprästen stod upp i mitten och frågade Jesus och sade: ”Svarar du inte något på vad dessa vittnar mot dig?” ");
INSERT INTO swessb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Men han var tyst och svarade inte något. Åter frågade översteprästen och säger till honom: ”Du är Kristus, den Välsignades son?” ");
INSERT INTO swessb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Och Jesus sade: ”Jag Är. Och ni ska se Människosonen sitta på Maktens högra sida och komma med himlens moln.” ");
INSERT INTO swessb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Och översteprästen rev sönder sina tunikor och säger: ”Vad mer för behov har vi av vittnen? ");
INSERT INTO swessb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni har hört hädelsen! Hur syns det för er?” Och alla fördömde honom till att vara hemfallen åt döden. ");
INSERT INTO swessb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Och då började några spotta på honom och täcka över runt hans ansikte och puckla på honom och säga till honom: ”Profetera!” Och undertjänarna tog emot honom med örfilar. ");
INSERT INTO swessb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Och medan Petrus är nere på innergården kommer en av översteprästens tjänsteflickor, ");
INSERT INTO swessb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","och när hon ser Petrus värma sig ser hon på honom och säger: ”Även du var med nasarén Jesus.” ");
INSERT INTO swessb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Men han nekade och sade: ”Jag varken förstår eller vet vad du säger.” Och han gick ut utanför på yttergården. Och en tupp gol. ");
INSERT INTO swessb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Och tjänsteflickan såg honom och började åter säga till dem som stod där att: ”Denne är en av dem.” ");
INSERT INTO swessb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Men åter nekade han. Och efter en liten stund sade åter de som stod där till Petrus: ”Sannerligen är du en av dem. För du är galilé.” ");
INSERT INTO swessb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Men han började sätta upp förbannelser och svära att: ”Jag känner inte den människan som ni säger!” ");
INSERT INTO swessb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Och direkt, en andra gång,gol en tupp. Och Petrus kom ihåg ordet, hur Jesus sagt till honom att: ”Innan en tupp gal två gånger ska du tre gånger förneka mig.” Och han satte igång att gråta. ");
INSERT INTO swessb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Och direkt på morgonen gjorde översteprästerna ett beslut med de äldste och skriftlärda och hela Sanhedrin, och de band Jesus och förde bort och utlämnade till Pilatus. ");
INSERT INTO swessb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Och Pilatus frågade honom: ”Du är judarnas kung?” Och han svarar honom och säger: ”Du säger det.” ");
INSERT INTO swessb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Och översteprästerna anklagade honom mycket, ");
INSERT INTO swessb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","och Pila­tus frågade honom åter och sade: ”Svarar du inte något? Se hur mycket de anklagar dig.” ");
INSERT INTO swessb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Men Jesus svarade inte längre något, så att Pilatus var förundrad. ");
INSERT INTO swessb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Men varje högtid brukade han frige åt dem en fånge, den de undanbad. ");
INSERT INTO swessb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Och det fanns den som hette Barabbas, fängslad med upprorsmakarna som hade begått mord under upproret. ");
INSERT INTO swessb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Och skaran kom upp och började be så som han brukade göra för dem, ");
INSERT INTO swessb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","och Pilatus svarade dem och sade: ”Vill ni att jag friger åt er judarnas kung?” ");
INSERT INTO swessb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","För han förstod att det var av ­avund översteprästerna hade utlämnat honom. ");
INSERT INTO swessb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Men översteprästerna hetsade upp skaran för att han snarare skulle frige Barabbas åt dem. ");
INSERT INTO swessb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Och Pilatus svarade åter och sade till dem: ”Vad vill ni då jag ska göra med honom som ni kallar judarnas kung?” ");
INSERT INTO swessb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Och de skrek åter: ”Korsfäst honom!” ");
INSERT INTO swessb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Och Pilatus sade till dem: ”Vad har han då gjort för ont?” Men de skrek ännu mer: ”Korsfäst honom!” ");
INSERT INTO swessb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Och Pilatus, som önskade göra det som var nog för skaran, frigav åt dem Barabbas och utlämnade och gisslade Jesus för att korsfästas. ");
INSERT INTO swessb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Och soldaterna förde bort honom in på innergården, det vill säga pretoriet, och sammankallade hela kohorten. ");
INSERT INTO swessb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Och de iklädde honom purpur och satte runt honom en törnekrans de flätat, ");
INSERT INTO swessb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","och började hälsa honom: ”Gläd dig, judarnas kung!” ");
INSERT INTO swessb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Och de slog hans huvud med en käpp och spottade på honom och satte knäna och tillbad honom. ");
INSERT INTO swessb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Och när de hade förlöjligat honom, tog de av honom purpuret och iklädde honom hans kläder. Och de förde ut honom för att korsfästa honom. ");
INSERT INTO swessb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Och de rekvirerar en förbipasserande, Simon ky­renén som kommer in från fältet, fadern till Alexander och Rufus, för att bära hans kors. ");
INSERT INTO swessb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Och de för honom till Golgotaplatsen, vilket är översatt Kranieplatsen. ");
INSERT INTO swessb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Och de gav honom myrrablandat vin, men han tog inte emot. ");
INSERT INTO swessb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Och de korsfäster honom och delar upp hans kläder och kastar lott om dem, vem ska få vad. ");
INSERT INTO swessb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Och det var tredje timmen, och de korsfäste honom. ");
INSERT INTO swessb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Och överskriften med anklagelsen mot honom var skriven: ”Judarnas kung”. ");
INSERT INTO swessb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Och med honom korsfäster de två rövare, en på högra sidan och en på hans vänstra. ");
INSERT INTO swessb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Och de förbipasserande smädade honom och skakade sina huvuden och sade: ”Ha! Du som river ner tempelbyggnaden och bygger upp på tre dagar, ");
INSERT INTO swessb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","fräls dig själv och kom ner från korset!” ");
INSERT INTO swessb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Likaså förlöjligade också översteprästerna honom för varandra med de skriftlärda och sade: ”Andra har han frälst, sig själv kan han inte frälsa. ");
INSERT INTO swessb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristus, Israels kung får komma ner nu från korset så att vi kan se och tro!” Också de som var korsfästa med honom kritiserade honom. ");
INSERT INTO swessb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Och när det blev sjätte timmen, kom ett mörker över hela landet fram till nionde timmen. ");
INSERT INTO swessb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Och vid nionde timmen ropade Jesus med väldig röst: ”Elohi! Elohi! Lema sabaktani?”, vilket är översatt: ”Min Gud! Min Gud!   Varför har du övergett mig?” ");
INSERT INTO swessb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Och några av dem som stod där hörde det och sade: ”Se: han ropar på Elia!” ");
INSERT INTO swessb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Och en sprang och fyllde en tvättsvamp med posca, satte runt en käpp och gav honom att dricka och sade: ”Låt oss se om Elia kommer för att ta ner honom.” ");
INSERT INTO swessb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Men Jesus lät ut en väldig röst och gav upp andan. ");
INSERT INTO swessb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Och förhänget i tempelbyggnaden revs itu, uppifrån och ända ner. ");
INSERT INTO swessb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Och när centurionen som stod mittemot honom såg att han så gav upp andan, sade han: ”Sannerligen, den människan var Guds Son.” ");
INSERT INTO swessb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Och det fanns även kvinnor som skådade långt ifrån, bland dem både Maria Magdalena och Maria som var Jakob den yngres och Joses mor samt Salome, ");
INSERT INTO swessb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","som när han var i Galileen hade följt honom och betjänat honom, samt många andra kvinnor som hade gått upp med honom till Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Och när det redan hade blivit kväll, då det var förberedelsedag, det vill sägadagen före sabbaten, ");
INSERT INTO swessb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","kom Josef från Arimatea, en anständig rådsherre som också han väntade på Guds rike, och vågade och gick in till Pilatus och bad om Jesu kropp. ");
INSERT INTO swessb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Men Pilatus var förundrad om han redan hade dött, och han kallade till sig centurionen och frågade honom om han hade dött sedan länge. ");
INSERT INTO swessb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Och när han fått veta från centurionen, förlänade han liket åt Josef. ");
INSERT INTO swessb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Och han köpte linnetyg, tog ner honom och svepte i linne­tyget och lade honom i en grav som var uthuggen ur klippan och rullade fram en sten för öppningen till ­graven. ");
INSERT INTO swessb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Och Maria Magdalena och Maria, Joses mor, skådade var han blev lagd. ");
INSERT INTO swessb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Och när sabbaten hade gått, köpte Maria Magdalena och Maria Jakobs mor och Salome kryddor för att gå och smörja in honom. ");
INSERT INTO swessb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Och väldigt tidig morgon, den första dagen i veckan, kommer de till graven när solen går upp. ");
INSERT INTO swessb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Och de sade till varann: ”Vem ska rulla bort för oss stenen från öppningen till graven?” ");
INSERT INTO swessb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Och när de ser upp, skådar de att stenen är bortrullad. För den var mycket stor. ");
INSERT INTO swessb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Och de gick in i graven och såg en ung man sittande på högra sidan, klädd i en vit dräkt. Och de var fulla av häpnad. ");
INSERT INTO swessb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Men han säger till dem: ”Var inte fulla av häpnad! Jesus söker ni, nasarén, den korsfäste. Han är uppväckt. Han är inte här! Se: platsen där de lade honom. ");
INSERT INTO swessb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Men bege er, säg till hans lärjungar och till Petrus att han går före er till Galileen. Där ska ni få se honom, så som han har sagt er.” ");
INSERT INTO swessb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Och de gick ut och flydde från graven, för darran och extas omfattade dem. Och till inget sade de något, för de fruktade. ");
INSERT INTO swessb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Men uppstånden på morgonen första dagen i veckan visade han sig först för Maria Magdalena, från vilken han hade drivit ut sju demoner. ");
INSERT INTO swessb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hon gick och berättade för dem som hade varit med honom, som sörjde och grät. ");
INSERT INTO swessb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Och dessa, när de hörde att han lever och skådats av henne, trodde inte. ");
INSERT INTO swessb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Och efter detta var det för två av dem som vandrade han visade sig, i annan gestalt, när de gick ut till fältet. ");
INSERT INTO swessb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Och dessa gick iväg och berättade för de övriga. Inte heller dessa trodde de. ");
INSERT INTO swessb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Och till sist för de elva när de själva låg till bords: han visade sig och kritiserade deras otro och hårdhjärtadhet, eftersom de inte hade trott på dem som skådat honom ­uppväckt. ");
INSERT INTO swessb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Och han sade till dem: ”Gå till hela världen och förkunna evangeliet för hela skapelsen. ");
INSERT INTO swessb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Den som tror och blir döpt ska bli frälst, men den som inte trott ska bli fördömd. ");
INSERT INTO swessb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Och dessa tecken ska nära följa dem som tror: I mitt namn ska de driva ut demoner, de ska tala med nya tungor ");
INSERT INTO swessb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","och med händerna ta upp ormar. Även om de dricker något dödligt ska det alls inte skada dem. På kraftlösa ska de lägga händer och de ska bli bra.” ");
INSERT INTO swessb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Herren Jesus, efter att ha talat till dem, togs nu upp till himlen och satte sig på Guds högra sida. ");
INSERT INTO swessb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Och dessa gick ut och förkunnade överallt, medan Herren samverkade och befäste ordet genom de efterföljande tecknen. (Men allt det instruerade förtalde de kortfattat för dem runt Petrus. Och efter detta sände också Jesus själv ut, från öster och ända till väster, genom dem den sakrala och oförgängliga förkunnelsen om den eoniska frälsningen. Amen.) ");
INSERT INTO swessb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Då många har tagit sig för att sammanställa en skildring om de ting som fullgjorts bland oss, ");
INSERT INTO swessb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","så som de har överlämnats åt oss avdem som från begynnelsen blev Ordets ögonvittnen och undertjänare, ");
INSERT INTO swessb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","tycktes det gott även för mig som nära följt allt från början att noggrant i ordning skriva det för dig, bäste Teofilus, ");
INSERT INTO swessb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","för att du ska inse säkerheten i de ord om vilka du blivit undervisad. ");
INSERT INTO swessb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Det fanns i Herodes dagar som kung i Judeen en präst vid namn Sakarias av Abias av­delning. Och han hade en hustru av Arons döttrar, och hennes namn var Elisabet. ");
INSERT INTO swessb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Och båda var rättfärdiga inför Gud och vandrade i Herrens alla bud och rättsregler klanderfritt. ");
INSERT INTO swessb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Och de hade inget barn, eftersom Elisabet var ofruktsam och båda var fortskridna i sina dagar. ");
INSERT INTO swessb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Men det hände sig, under det att han gjorde prästtjänst i sin avdelnings ordning inför Gud, ");
INSERT INTO swessb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","att han enligt prästerskapets sed fick på sin lott att tända rökelse när han gick in i Herrens tempelbyggnad. ");
INSERT INTO swessb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Och folkets hela mängd var bedjande utanför vid stunden för rökelsen. ");
INSERT INTO swessb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Men då visade sig för honom en Herrens ängel, stående på höger sida av rökelsealtaret. ");
INSERT INTO swessb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Och Sakarias blev oroad när han såg detta och fruktan föll över honom. ");
INSERT INTO swessb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Men ängeln sade till honom: ”Frukta inte, Sakarias. För din vädjan har blivit hörd, och din hustru Elisabet ska föda en son åt dig. Och du ska kalla hans namn Johannes. ");
INSERT INTO swessb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Och han ska bli en glädje för dig och jubel, och många ska glädja sig över hans födelse. ");
INSERT INTO swessb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","För han ska bli stor inför Herren. Och vin och rusdryck ska han aldrig dricka, och av helig Ande ska han bli fylld ännu från sin mors moderliv. ");
INSERT INTO swessb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Och många av Israels söner ska han omvända till Herren deras Gud. ");
INSERT INTO swessb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Och han ska gå före inför honom i Elias ande och kraft, för att omvända fäders hjärtan till barn och ohörsamma med rättfärdigas tanke, för att bereda åt Herren ett folk som är preparerat.” ");
INSERT INTO swessb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Och Sakarias sade till ängeln: ”Genom vad ska jag veta detta? För jag är en gammal man, och min hustru är fortskriden i sina dagar.” ");
INSERT INTO swessb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Och ängeln svarade och sade till honom: ”Jag är Gabriel som står inför Gud, och jag har sänts för att tala till dig och evangelisera dig detta. ");
INSERT INTO swessb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Och se: du ska vara tyst och inte kunna tala förrän den dag detta sker, därför att du inte trodde mina ord, som ska uppfyllas i sin tid.” ");
INSERT INTO swessb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Och folket var i förväntan på Sakarias och var förundrade över att han dröjde inne i tempelbyggnaden. ");
INSERT INTO swessb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Men när han kom ut kunde han inte tala till dem, och de insåg att han hade sett en vision i tempelbyggnaden. Och han gjorde tecken åt dem och förblev stum. ");
INSERT INTO swessb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Och det hände sig, när hans tjänstgöringsdagar var fyllda, att han gick bort till sitt hus. ");
INSERT INTO swessb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Men efter dessa dagar koncipierade Elisa­bet hans hustru. Och hon dolde sig helt i fem månader och sade ");
INSERT INTO swessb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","att: ”Så har Herren gjort med mig, under dagar då han såg till att ta bort min nesa bland människor.” ");
INSERT INTO swessb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Men i den sjätte månaden sändes ängeln Gabriel från Gud till en stad i Galileen vars namn var Nasaret, ");
INSERT INTO swessb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","till en jungfru trolovad med en man vars namn var Josef av Davids hus. Och jungfruns namn var Maria. ");
INSERT INTO swessb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Och han kom in till henne och sade: ”Gläd dig, benådade! Herren är med dig.” ");
INSERT INTO swessb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Men hon blev vid det ordet djupt oroad och funderade vad för något denna hälsning kunde vara. ");
INSERT INTO swessb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Och ängeln sade till henne: ”Frukta inte, Maria. För du har funnit nåd hos Gud. ");
INSERT INTO swessb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Och se: du ska koncipiera i magen och föda en son, och du ska kalla hans namn Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Denne ska bli stor, och den Högstes Son ska han kallas, och Herren Gud ska ge honom hans fader Davids tron. ");
INSERT INTO swessb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Och han ska regera över Jakobs hus till eonerna, och på hans rike ska det inte bli något slut.” ");
INSERT INTO swessb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Men Maria sade till ängeln: ”Hur ska detta ske, då jag inte känner en man?” ");
INSERT INTO swessb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Och ängeln svarade och sade till henne: ”Helig Ande ska komma över dig, och den Högstes kraft ska överskugga dig. Därför ska också det som avlas kallas heligt, Guds Son. ");
INSERT INTO swessb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Och se: Elisabet din släkting har också hon koncipierat en son i sin ålderdom. Och detta är sjätte månaden för henne som kallas ofruktsam. ");
INSERT INTO swessb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","För från Gud blir ingen sak omöjlig.” ");
INSERT INTO swessb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Och Maria sade: ”Se Herrens fasttjänarinna. Ske mig enligt ditt ord.” Och ängeln gick iväg från henne. ");
INSERT INTO swessb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Och Maria stod upp i de dagarna och gick till bergsbygden med iver, till en stad i Juda, ");
INSERT INTO swessb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","och gick in i Sakarias hus och hälsade på Elisabet. ");
INSERT INTO swessb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Och det hände sig, när Elisabet hörde Marias hälsning, att spädbarnet hoppade i hennes moderliv. Och Elisabet fylldes av helig Ande ");
INSERT INTO swessb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","och ropade högt med ett väldigt skri och sade: ”Välsignad är du bland kvinnor, och välsignad ditt moderlivs frukt! ");
INSERT INTO swessb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Och varifrån händer detta mig, att min Herres mor kommer till mig? ");
INSERT INTO swessb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","För se: när rösten med din hälsning kom till mina öron, hoppade spädbarnet i jubel i mitt moderliv. ");
INSERT INTO swessb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Och salig hon som trodde, för det ska bli en fullkomning av det som talats till henne från Herren.” ");
INSERT INTO swessb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Och Maria sade: ”Min själ gör Herren stor, ");
INSERT INTO swessb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","och min ande har jublat över Gud min Frälsare. ");
INSERT INTO swessb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","För han har sett till sin fasttjänarinnas låghet, för se: från nu ska alla släktena saligprisa mig. ");
INSERT INTO swessb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","För den Mäktige har gjort stora ting med mig, och heligt är hans namn. ");
INSERT INTO swessb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Och hans barmhärtighet varar till släkten och släkten för dem som fruktar honom. ");
INSERT INTO swessb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Han har gjort välde med sin arm, han har skingrat högmodiga i deras hjärtas sinne. ");
INSERT INTO swessb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Han har tagit ner makthavare från troner och upphöjt låga. ");
INSERT INTO swessb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hungrande har han fyllt med goda ting, och rika har han sänt iväg tomhänta. ");
INSERT INTO swessb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Han har tagit sig an sin gosse Israel för att komma ihåg barmhärtighet, ");
INSERT INTO swessb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","så som han har talat till våra fäder, gentemot Abraham och hans säd till eonen.” ");
INSERT INTO swessb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Och Maria blev kvar med henne omkring tre månader och återvände sedan till sitt hus. ");
INSERT INTO swessb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Men för Elisabet var tiden fylld för att hon skulle föda, och hon födde en son. ");
INSERT INTO swessb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Och då hörde hennes kringboende och släktingar att Herren hade gjort sin barmhärtighet stor med henne och gladde sig med henne. ");
INSERT INTO swessb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Och det hände sig på åttonde dagen att de kom för att omskära barnet, och de började kalla det vid hans fars namn Sakarias. ");
INSERT INTO swessb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Och hans mor svarade och sade: ”Nej, utan han ska kallas Johannes.” ");
INSERT INTO swessb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Och de sade till henne att: ”Det finns ingen från din släkt som kallas vid det namnet.” ");
INSERT INTO swessb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Och de gjorde tecken till hans far, vad han skulle vilja att det kallas. ");
INSERT INTO swessb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Och han bad om en liten tavla och skrev, sägande: ”Johannes är hans namn.” Och alla blev förundrade. ");
INSERT INTO swessb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Och då öppnades genast hans mun och hans tunga, och han talade och välsignade Gud. ");
INSERT INTO swessb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Och det kom fruktan över alla som bodde omkring dem, och i hela Judeens bergsbygd talades alla dessa saker igenom. ");
INSERT INTO swessb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Och alla som hörde satte det i sitt hjärta och sade: ”Vad ska då detta barn bli?” För Herrens hand var med honom. ");
INSERT INTO swessb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Och Sakarias hans far fylldes av helig Ande och profeterade och sade: ");
INSERT INTO swessb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","”Välsignad är Herren Israels Gud! För han har besökt och gjort återlösning för sitt folk. ");
INSERT INTO swessb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Och han har rest ett frälsningens horn för oss i sin gosse Davids hus, ");
INSERT INTO swessb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","så som han har talat genom munnen hos sina heliga profeter av eon: ");
INSERT INTO swessb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","frälsning från våra fiender och från handen hos alla som hatar oss, ");
INSERT INTO swessb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","för att göra barmhärtighet med våra fäder och komma ihåg sitt heliga förbund, ");
INSERT INTO swessb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","den ed som han svor till Abraham vår fader: att låta oss ");
INSERT INTO swessb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","utan fruktan, från fienders hand räddade, dyrka honom ");
INSERT INTO swessb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","i helgd och rättfärdighet inför honom alla våra dagar. ");
INSERT INTO swessb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Och även du, barn, ska kallas den Högstes profet. För du ska gå före inför Herren för att bereda hans vägar, ");
INSERT INTO swessb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","för att ge kunskap om frälsning åt hans folk, med förlåtelse för deras synder ");
INSERT INTO swessb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","genom vår Guds barmhärtighets innerlighet. I den ska det besöka oss en soluppgång från höjden ");
INSERT INTO swessb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","för att lysa över dem som sitter i mörker och dödsskugga, för att räta upp våra fötter in på fridens väg.” ");
INSERT INTO swessb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Och barnet växte och blev starkt i anden, och han var i ödemarkerna fram till dagen för hans framvisning inför Israel. ");
INSERT INTO swessb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Och det hände sig i de dagarna att det utgick ett edikt från kejsar Augustus att hela den bebodda världen skulle upptecknas. ");
INSERT INTO swessb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Denna första uppteckning skedde när Quirinius var styresman i Syrien. ");
INSERT INTO swessb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Och då gick alla för att upptecknas, var och en till sin stad. ");
INSERT INTO swessb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Och även Josef gick upp från Galileen, från staden Nasaret till Judeen, till Davids stad som kallas Betlehem, eftersom han var av Davids hus och ätt, ");
INSERT INTO swessb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","för att upptecknas med Maria, hans trolovade som var gravid. ");
INSERT INTO swessb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Och det hände sig, under det att de var där, att dagarna uppfylldes för att hon skulle föda, ");
INSERT INTO swessb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","och hon födde sin son, den förstfödde. Och hon lindade honom och lade honom i en krubba, eftersom det inte fanns plats för dem i gästrummet. ");
INSERT INTO swessb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Och herdar fanns i samma trakt och låg ute och vaktade nattens väkter över sin hjord. ");
INSERT INTO swessb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Och Herrens ängel stod framför dem, och Herrens härlighet sken omkring dem. Och de fruktade med stor fruktan. ");
INSERT INTO swessb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Och ängeln sade till dem: ”Frukta inte. För se: jag evangeliserar för er en stor glädje som ska vara för hela folket: ");
INSERT INTO swessb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","att det fötts åt er idag en Frälsare som är Kristus, Herren, i Davids stad. ");
INSERT INTO swessb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Och detta är för er tecknet: Ni ska finna ett spädbarn lindat och liggande i en krubba.” ");
INSERT INTO swessb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Och plötsligt fanns med ängeln en mängd av den himmelska hären som lovprisade Gud och sade: ");
INSERT INTO swessb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","”Ära i det högsta åt Gud! Och på jorden frid bland människor av välbehag.” ");
INSERT INTO swessb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Och det hände sig, när änglarna farit bort från dem till himlen, att ­herdarna talade till varandra: ”Låt oss nu gå över till Betlehem och se denna sak som har hänt, som Herren har kungjort för oss.” ");
INSERT INTO swessb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Och de gick skyndande och sökte upp både Maria och Josef och spädbarnet som låg i krubban. ");
INSERT INTO swessb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Och när de hade sett, kungjorde de om ordet som var talat till dem om detta barn. ");
INSERT INTO swessb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Och alla som hörde var förundrade över det som talats av herdarna till dem. ");
INSERT INTO swessb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Men Maria bevarade alla dessa saker och konfererade i sitt hjärta. ");
INSERT INTO swessb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Och herdarna återvände, ärande och lovprisande Gud för allt som de hade hört och sett, så som det talats till dem. ");
INSERT INTO swessb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Och när det hade uppfyllts åtta dagar för att omskära honom, kallades också hans namn Jesus: det som var kallat av ängeln före det att han koncipierats i moderlivet. ");
INSERT INTO swessb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Och när dagarna hade uppfyllts för deras rening enligt Mose lag, förde de upp honom till Jerusalem för att ställa fram inför Herren, ");
INSERT INTO swessb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","så som det är skrivet i Herrens lag, att: Varje hanne som öppnar upp skötet ska kallas helig åt Herren, ");
INSERT INTO swessb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","och för att ge ett offer enligt det som är sagt i Herrens lag: ett par turturduvor eller två duvungar. ");
INSERT INTO swessb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Och se: det fanns en man i Jeru­salem vars namn var Simeon. Och denne man var rättfärdig och vördsam och väntade på Israels tröst, och helig Ande var över honom. ");
INSERT INTO swessb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Och det var för honom uppenbarat av den heliga Anden att han inte skulle se döden innan han sett Herrens Kristus. ");
INSERT INTO swessb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Och han kom i Anden till templet, och under det att föräldrarna förde in barnet Jesus för att de skulle göra enligt det som var lagens sed för det, ");
INSERT INTO swessb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","mottog också han det i sina böjda armar och välsignade Gud och sade: ");
INSERT INTO swessb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","”Nu friger du din fasttjänare, Härskare, enligt ditt ord i frid. ");
INSERT INTO swessb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","För mina ögon har sett din frälsning ");
INSERT INTO swessb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","som du har berett inför ansiktet hos alla folken: ");
INSERT INTO swessb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ett ljus till uppenbarelse för folkslag och härlighet för ditt folk Israel.” ");
INSERT INTO swessb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Och hans far och mor var förundrade över det som talades om honom. ");
INSERT INTO swessb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Och nu välsignade dem Simeon och sade till Maria hans mor: ”Se: denne är satt till fall och uppståndelse för många i Israel, och till ett tecken som blir motsagt – ");
INSERT INTO swessb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","och även genom din egen själ ska det gå en klinga – för att det ur många hjärtan ska uppenbaras funderingar.” ");
INSERT INTO swessb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Och där fanns Hanna profetissan, Fanuels dotter av Ashers stam. Hon var fortskriden i många dagar efter att ha levt med man sju år efter sin jungfrudom, ");
INSERT INTO swessb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","och sedan själv änka fram till åttiofyra år. Hon avlägsnade sig inte från templet, utan med fastor och förböner dyrkade hon natt och dag. ");
INSERT INTO swessb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Och i samma stund stod hon där och gav Gud erkännande och talade om honom för alla som väntade på Jerusalems återlösning. ");
INSERT INTO swessb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Och när de hade fullbordat allt enligt Herrens lag ­vände de om till Galileen, till sin stad Nasaret. ");
INSERT INTO swessb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Och barnet växte och blev starkt och fylldes av vishet, och Guds nåd var över det. ");
INSERT INTO swessb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Och hans föräldrar gick varje år till Jerusalem vid påskhögtiden. ");
INSERT INTO swessb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Och när han blev tolv år, när de gick upp enligt högtidens sed ");
INSERT INTO swessb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","och hade fullkomnat dagarna, under det att de återvände, höll sig gossen Jesus kvar i Jerusalem. Och hans föräldrar visste inte. ");
INSERT INTO swessb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Men de antog att han var med i vägföljet och gick en dagsväg. Och de sökte noga efter honom bland släktingarna och de bekanta, ");
INSERT INTO swessb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","och när de inte fann honom återvände de till Jerusalem och sökte noga efter honom. ");
INSERT INTO swessb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Och det hände sig efter tre dagar att de fann honom i templet, där han satt mitt bland lärarna och lyssnade på dem och frågade dem. ");
INSERT INTO swessb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Och alla som hörde honom var utom sig över hans förstånd och svar. ");
INSERT INTO swessb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Och när de såg honom blev de överväldigade, och hans mor sade till honom: ”Barn, varför har du gjort mot oss så? Se: din far och jag har våndats och sökt efter dig.” ");
INSERT INTO swessb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Och han sade dem: ”Varför då att ni sökte efter mig? Visste ni inte att jag måste vara i det som hör till min Far?” ");
INSERT INTO swessb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Och de förstod inte ordet som han talade till dem. ");
INSERT INTO swessb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Och han gick ner med dem och kom till Nasaret och underordnade sig dem. Och hans mor bevarade noga alla sakerna i sitt hjärta. ");
INSERT INTO swessb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Och Jesus gjorde framsteg i visheten och mognad och nåd inför Gud och människor. ");
INSERT INTO swessb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Och i femtonde året av kejsar Tiberius styre, när Pontius Pilatus var styresman i Judeen och Herodes tetrark i Galileen, och Filippushans bror tetrark i Itureen och Trachonitistrakten och Lysanias tetrark i Abilene, ");
INSERT INTO swessb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","under översteprästen Hannas och Kaiafas, kom Guds ord över Johannes Sakarias son i ödemarken. ");
INSERT INTO swessb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Och han gick till hela trakten runt Jordan och förkunnade ett sinnesändringens dop till syndernas förlåtelse, ");
INSERT INTO swessb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","som det är skrivet i ­boken med profeten Jesajas ord: Rösten av en som ropar i ödemarken:   Bered Herrens väg!   Gör hans stigar raka!  ");
INSERT INTO swessb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Varje klyfta ska uppfyllas   och varje berg och kulle ödmjukas,   och det krokiga ska bli till rakt   och de skrovliga till släta vägar.  ");
INSERT INTO swessb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Och allt kött ska se Guds frälsning.  ");
INSERT INTO swessb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Han sade nu till skarorna som gick ut för att döpas av honom: ”Hugg­orms­yngel, vem har visat er att fly från den kommande vreden? ");
INSERT INTO swessb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gör då frukter värdiga sinnesändringen. Och börja inte säga inom er: Som far har vi Abraham. För jag säger er att Gud ur dessa stenar kan resa upp barn åt Abraham. ");
INSERT INTO swessb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Och redan ligger också yxan mot trädens rot. Varje träd som inte gör fin frukt huggs alltså bort och kastas i eld.” ");
INSERT INTO swessb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Och då frågade honom skarorna och sade: ”Vad ska vi alltså göra?” ");
INSERT INTO swessb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Och han svarade och sade till dem: ”Den som har två tunikor ska dela med sig till den som inte har. Och den som har matämnen ska göra likadant.” ");
INSERT INTO swessb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Men det kom också tullindrivare för att bli döpta, och de sade till honom: ”Lärare, vad ska vi göra?” ");
INSERT INTO swessb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Och han sade till dem: ”Ta inte ut något mer än det som förordnats för er.” ");
INSERT INTO swessb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Men där frågade honom också soldater och sade: ”Och vi, vad ska vi göra?” Och han sade till dem: ”Ni ska inte plundra eller utpressa någon. Och nöj er med er sold.” ");
INSERT INTO swessb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Men när folket var i förväntan och alla funderade i sina hjärtan om Johannes, att han kanske kunde vara Kristus, ");
INSERT INTO swessb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","svarade Johannes och sade till alla: ”Jag döper er med vatten. Men det kommer den som är starkare än jag. Hos honom är jag inte förtjänt att lossa remmen på hans sandaler. Han ska döpa er i helig Ande och eld. ");
INSERT INTO swessb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hans kastskovel är i hans hand, för att rensa hans tröskplats och samla vetet in i hans förråd. Men agnarna ska han bränna upp med osläckbar eld.” ");
INSERT INTO swessb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Med mycket och annat uppmanade han nu och evangeliserade folket. ");
INSERT INTO swessb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Men Herodes tetrarken, tillrättavisad av honom för Herodias, hans brors hustru, och för allt elakt som Herodes hade gjort, ");
INSERT INTO swessb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","lade även detta till alltihop och låste in Johannes i fängelse. ");
INSERT INTO swessb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Men det hände sig, under det att folket allihop döptes och även Jesus blev döpt och bad, att himlen öppnades ");
INSERT INTO swessb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","och den heliga Anden kom ner i kroppslig skepnad som en duva över honom. Och en röst från himlen kom: ”Du är min Son, den Älskade. I dig har jag funnit behag.” ");
INSERT INTO swessb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Och själv var Jesus när han började omkring trettio år. Och han var son, som det antogs, till Josef, till Eli, ");
INSERT INTO swessb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","till Mattat, till Levi, till Melki, till Jannai, till Josef, ");
INSERT INTO swessb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","till Mattatias, till Amos, till Nahum, till Hesli, till Naggai, ");
INSERT INTO swessb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","till Mahat, till Mattatias, till Shimei, till Josek, till Juda, ");
INSERT INTO swessb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","till Johanan, till Resa, till Serubbabel, till Shealtiel, till Neri, ");
INSERT INTO swessb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","till Melki, till Addi, till Kosam, till Elmadam, till Er, ");
INSERT INTO swessb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","till Josua, till Elieser, till Jorim, till Mattat, till Levi, ");
INSERT INTO swessb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","till Simeon, till Juda, till Josef, till Jonam, till Eljakim, ");
INSERT INTO swessb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","till Melea, till Menna, till Mattata, till Natan, till David, ");
INSERT INTO swessb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","till Ishai, till Obed, till Boas, till Salma, till Nahshon, ");
INSERT INTO swessb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","till Amminadab, till Admin, till Arni, till Hesron, till Peres, till Juda, ");
INSERT INTO swessb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","till Jakob, till Isak, till Abraham, till Tera, till Nahor, ");
INSERT INTO swessb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","till Serug, till Regu, till Peleg, till Eber, till Shela, till Kenan, ");
INSERT INTO swessb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","till Arpakshad, till Sem, till Noa, till Lemek, ");
INSERT INTO swessb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","till Metusela, till Henok, till Jered, till Mahalalel, till Kenan, ");
INSERT INTO swessb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","till Enosh, till Set, till Adam, till Gud. ");
INSERT INTO swessb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Men Jesus, full av helig Ande, återvände från Jordan och leddes i Anden i ödemarken ");
INSERT INTO swessb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","fyrtio dagar, testad av djävulen. Och han åt inte något under de dagarna, och när de var fullbordade blev han hungrig. ");
INSERT INTO swessb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Och djävulen sade till honom: ”Om du är Guds Son, säg till denna sten att den ska bli bröd.” ");
INSERT INTO swessb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Och Jesus svarade till honom: ”Det är skrivet att: Det är inte bara på bröd människan ska leva.” ");
INSERT INTO swessb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Och han förde upp honom och visade honom alla riken i den bebodda världen i en tidpunkt, ");
INSERT INTO swessb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","och djävulen sade till honom: ”Dig ska jag ge all denna auktoritet och deras härlighet. För åt mig är den överlämnad, och till vem jag vill ger jag den. ");
INSERT INTO swessb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Om du nu tillber inför mig, blir allt ditt.” ");
INSERT INTO swessb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Och Jesus svarade och sade till honom: ”Det är skrivet: Herren din Gud ska du tillbe, och bara honom ska du dyrka.” ");
INSERT INTO swessb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Men han förde honom till Jerusalem och ställde på templets vinge och sade till honom: ”Om du är Guds Son, kasta dig härifrån ner! ");
INSERT INTO swessb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","För det är skrivet att: Sina änglar ska han påbjuda om dig   att beskydda dig, ");
INSERT INTO swessb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","och att: På händer ska de bära dig,   så att inte du stöter emot en sten med din fot.” ");
INSERT INTO swessb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Och Jesus svarade och sade till honom att: ”Det är sagt: Du ska inte testa ut Herren din Gud.” ");
INSERT INTO swessb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Och när djävulen hade fullbordat varje test, avlägsnade han sig från honom tills det blev tillfälle. ");
INSERT INTO swessb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Och Jesus återvände i Andens kraft till Galileen, och rykte gick ut i hela trakten runt omkring om honom. ");
INSERT INTO swessb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Och han undervisade i deras synagogor, ärad av alla. ");
INSERT INTO swessb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Och han kom till Nasaret, där han var uppfödd, och gick enligt sin sed på sabbatsdagen till synagogan och stod upp för att läsa. ");
INSERT INTO swessb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Och det gavs honom profeten Jesajas bokrulle, och han rullade upp bokrullen och fann stället där det var skrivet: ");
INSERT INTO swessb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Herrens Ande är över mig,   eftersom han smort mig   att evangelisera fattiga.   Han har sänt mig   att förkunna för fångna befrielse  och för blinda återseende,   att sända ut kuvade i befrielse, ");
INSERT INTO swessb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","att förkunna ett välkommet Herrens år.  ");
INSERT INTO swessb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Och han rullade ihop bokrullen, gav tillbaka till undertjänaren och satte sig. Och allas ögon i synagogan var blickande på honom. ");
INSERT INTO swessb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Och han började säga till dem att: ”Idag har denna skrift uppfyllts i era öron.” ");
INSERT INTO swessb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Och alla vittnade om honom och var förundrade över nådens ord som utgick ur hans mun, och de sade: ”Är inte denne Josefs son?” ");
INSERT INTO swessb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Och han sade till dem: ”Visst kommer ni att tala till mig denna liknelse: Läkare, bota dig själv! Vad vi hört som hänt i Kapernaum, gör det även här i din fädernebygd!” ");
INSERT INTO swessb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Men han sade: ”Amen, jag säger er att ingen profet är välkommen i sin fädernebygd. ");
INSERT INTO swessb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Och i sanning säger jag er: Det fanns många änkor under Elias dagar i Israel, när himlen stängdes i tre år och sex månader, när det kom stor svält över hela landet. ");
INSERT INTO swessb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Och till ingen av dem skickades Elia, utan till Sarefat vid Sidon, till en änkekvinna. ");
INSERT INTO swessb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Och det fanns många spetälska i Israel under profeten Elisha, och ingen av dem blev renad, utan syriern Naaman.” ");
INSERT INTO swessb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Och då fylldes alla av raseri i synagogan när de hörde detta, ");
INSERT INTO swessb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","och de stod upp och drev ut honom utanför staden och förde honom fram till branten av berget på vilket deras stad var byggd, för att störta ner honom. ");
INSERT INTO swessb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Men han gick genom deras mitt och vandrade. ");
INSERT INTO swessb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Och han kom ner till Kapernaum, en stad i Galileen, och undervisade dem på sabbaten. ");
INSERT INTO swessb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Och de var överväldigade vid hans undervisning, för hans ord var med auktoritet. ");
INSERT INTO swessb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Och i synagogan fanns en man som hade en oren demons ande, och han skrek högt med väldig röst: ");
INSERT INTO swessb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","”Va! Vad mellan oss och dig, Jesus nasaré? Har du kommit för att förgöra oss? Jag känner dig, vem du är: Guds Helige!” ");
INSERT INTO swessb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Och då näpste honom Jesus och sade: ”Var tilltäppt och kom ut från honom!” Och demonen slängde honom i mitten och kom ut från honom utan att skada honom. ");
INSERT INTO swessb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Och det kom häpnad över alla, och de samtalade med ­varandra och sade: ”Vad är detta ord? För med auktoritet och makt beordrar han de orena andarna, och de kommer ut.” ");
INSERT INTO swessb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Och det gick ut ett dån om honom till varje plats i trakten runtomkring. ");
INSERT INTO swessb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Och han stod upp från synagogan och gick in till Simons hus. Men Simons svärmor var ansatt av väldig feber, och de frågade honom om henne. ");
INSERT INTO swessb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Och han stod där över henne och näpste febern, och den lämnade henne. Och genast stod hon upp och betjänade dem. ");
INSERT INTO swessb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Men när solen gick ner, kom allihop som hade sjuka i olika åkommor och förde dem till honom. Och på varenda en av dem lade han händerna och botade dem. ");
INSERT INTO swessb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Och det kom även ut demoner från många, vrålande och sägande att: ”Du är Guds Son!” Och han näpste och lät dem inte tala, eftersom de visste att han var Kristus. ");
INSERT INTO swessb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Men när det blev dag, gick han ut och vandrade till en öde plats. Och skarorna sökte honom, och de kom fram till honom och höll honom tillbaka för att han inte skulle gå ifrån dem. ");
INSERT INTO swessb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Men han sade till dem att: ”Även för de ­andra städerna måste jag evangelisera Guds rike. För till detta är jag utsänd.” ");
INSERT INTO swessb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Och han förkunnade i Judeens ­synagogor. ");
INSERT INTO swessb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Och det hände sig, under det att skaran låg på honom och hörde Guds ord, att han stod vid Genne­sarets sjö ");
INSERT INTO swessb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","och såg två båtar stående vid sjön, men de som fiskade hade gått ifrån dem och tvättade näten. ");
INSERT INTO swessb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Och han steg i en av båtarna, den som var Simons, och frågade honom om att lägga ut lite från land. Och han satte sig, och från ­båten undervisade han skarorna. ");
INSERT INTO swessb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Men när han hade slutat tala, sade han till Simon: ”Lägg ut på djupet och fira ner era nät till fångst.” ");
INSERT INTO swessb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Och Simon svarade och sade: ”Mästare, genom hela natten har vi jobbat och inte fått något. Men på ditt ord ska jag fira ner näten.” ");
INSERT INTO swessb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Och när de gjorde detta, inneslöt de en stor mängd fisk och deras nät höll på att rivas sönder. ");
INSERT INTO swessb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Och de tecknade åt kamraterna i den andra båten att komma och ta tag med dem, och de kom och fyllde båda båtarna så att de höll på att sjunka. ");
INSERT INTO swessb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Och när Simon Petrus såg det, föll han ner för Jesu knän och sade: ”Gå bort från mig. För jag är en syndig man, Herre.” ");
INSERT INTO swessb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","För häpnad hade omslutit honom och alla med honom vid fiskfångsten som de tagit fast, ");
INSERT INTO swessb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","och likaså även Jakob och Johannes, Sebedeus söner som var kompanjoner med Simon. Och Jesus sade till Simon: ”Frukta inte. Från nu ska du levandefånga människor.” ");
INSERT INTO swessb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Och de styrde in båtarna till land, lämnade allt och följde honom. ");
INSERT INTO swessb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Och det hände sig, under det att han var i en av städerna, och se: en man full av spetälska. Och när han såg Jesus, föll han ner på ansiktet och bönföll honom och sade: ”Herre, om du vill, kan du rena mig.” ");
INSERT INTO swessb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Och han räckte ut handen och rörde vid honom och sade: ”Jag vill. Var renad!” Och direkt gick spetälskan bort från honom. ");
INSERT INTO swessb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Och han instruerade honom att inte säga det till någon, utan: ”Gå bort och visa dig för prästen. Och frambär för din rening så som Mose har förordnat, till ett vittnesbörd för dem.” ");
INSERT INTO swessb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Men desto mer gick ordet omkring om honom, och det kom samman stora skaror för att höra och bli botade från sina sjukdomar. ");
INSERT INTO swessb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Men han drog sig undan i ödemarkerna och bad. ");
INSERT INTO swessb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Och det hände sig en av dagarna att han undervisade, och där satt fariseer och laglärare som var komna från varje by i Galileen och Judeen och från Jerusalem. Och Herrens kraft fanns för att han skulle hela. ");
INSERT INTO swessb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Och se: män bärande på en bädd en människa som var förlamad. Och de sökte föra in honom och lägga honom framför honom. ");
INSERT INTO swessb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Och när de inte fann hur de skulle föra in honom för skarans skull gick de upp på taket, och genom teglen sänkte de ner honom med båren i mitten framför Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Och han såg deras tro och sade: ”Människa, dina synder är dig förlåtna.” ");
INSERT INTO swessb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Och de började fundera, de skriftlärda och fariseerna, och säga: ”Vem är den där som talar hädelser? Vem kan förlåta synder utom bara Gud?” ");
INSERT INTO swessb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Men Jesus insåg deras funderingar och svarade och sade till dem: ”Vad är det ni funderar i era hjärtan? ");
INSERT INTO swessb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Vad är lättare, att säga: Dina synder är dig förlåtna, eller att säga: Res dig och vandra? ");
INSERT INTO swessb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Men för att ni ska veta att Människosonen har auktoritet på jorden att förlåta synder”, sade han sedan till den förlamade: ”Till dig säger jag: Res dig och ta din bår och gå till ditt hus.” ");
INSERT INTO swessb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Och genast stod han upp inför alla, tog det på vilket han legat och gick iväg till sitt hus, ärande Gud. ");
INSERT INTO swessb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Och extas tog tag i allihop, och de ärade Gud och fylldes av fruktan och sade att: ”Vi har sett en paradox idag!” ");
INSERT INTO swessb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Och efter detta gick han ut, och han skådade en tullindrivare vid namn Levi sittande vid tullhuset. Och han sade till honom: ”Följ mig.” ");
INSERT INTO swessb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Och han lämnade allt, stod upp och följde honom. ");
INSERT INTO swessb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Och Levi gjorde en stor mottagning för honom i sitt hus, och där fanns en stor skara av tullindrivare och andra som var med dem och låg till bords. ");
INSERT INTO swessb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Och då muttrade fariseerna och deras skriftlärda mot hans lärjungar och sade: ”Varför är det med tullindrivarna och syndarna ni äter och dricker?” ");
INSERT INTO swessb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Och Jesus svarade och sade till dem: ”Inte har de friska behov av läkare, utan de som har det illa. ");
INSERT INTO swessb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jag har inte kommit för att kalla rättfärdiga, utan syndare till sinnesändring.” ");
INSERT INTO swessb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Men de sade till honom: ”Johannes lärjungar fastar ofta och gör vädjanden, likaså även fariseernas. Men dina äter och dricker.” ");
INSERT INTO swessb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Men Jesus sade till dem: ”Inte kan ni få bröllopssalens söner att fasta under det att brudgummen är hos dem? ");
INSERT INTO swessb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Men det ska komma dagar, och när brudgummen tas ifrån dem, då kommer de att fasta, under de dagarna.” ");
INSERT INTO swessb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Och han talade också en liknelse till dem, att: ”Ingen river en lapp från en ny mantel och sätter på en gammal mantel. Annars kommer han både att riva den nya och så stämmer inte lappen från den nya på den gamla. ");
INSERT INTO swessb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Och ingen häller ungt vin i gamla läglar. Annars kommer det unga vinet att slita sönder läglarna, och det kommer att utgjutas och läglarna gå förlorade. ");
INSERT INTO swessb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nej, ungt vin ska i nya läglar hällas. ");
INSERT INTO swessb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Och ingen som har druckit gammalt vill ha ungt, för han säger: Det gamla är ljuvt.” ");
INSERT INTO swessb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Och det hände sig på en sabbat att han passerade genom sädesfält, och hans lärjungar plockade och åt axen, gnuggande med händerna. ");
INSERT INTO swessb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Men några av fariseerna sade: ”Varför gör ni det som inte är tillåtet på sabbaten?” ");
INSERT INTO swessb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Och Jesus svarade till dem och sade: ”Har ni heller inte läst detta som David gjorde när han blev hungrig, han och de som var med honom? ");
INSERT INTO swessb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hur han gick in i Guds hus och tog framsättningens bröd och åt och gav till de andra med honom, bröd som det inte är tillåtet att äta utom bara för prästerna.” ");
INSERT INTO swessb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Och han sade till dem: ”Människosonen är Herre över sabbaten.” ");
INSERT INTO swessb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Och det hände sig på en annan sabbat att han gick in i synagogan och undervisade, och det fanns en man där och hans högra hand var skrumpnad. ");
INSERT INTO swessb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Och vaktade noga på honom, de skriftlärda och fariseerna, om han botar på sabbaten, för att finna ett sätt att anklaga honom. ");
INSERT INTO swessb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Men han förstod deras funderingar, och han sade till mannen som hade den skrumpnade handen: ”Res dig och stå i mitten.” Och han stod upp och stod där. ");
INSERT INTO swessb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Och Jesus sade till dem: ”Jag frågar er om det är tillåtet på sabbaten att göra gott eller att göra illa? Att frälsa en själ eller att förgöra?” ");
INSERT INTO swessb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Och han såg sig omkring på dem alla och sade till honom: ”Räck ut din hand.” Och han gjorde så, och hans hand blev återställd. ");
INSERT INTO swessb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Men de fylldes av vansinne och började tala igenom med varandra vad de kunde göra med Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Och det hände sig under de dagarna att han gick ut till berget för att bedja. Och han var natten igenom i bönen till Gud. ");
INSERT INTO swessb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Och när det blev dag ropade han till sig sina lärjungar, och han utvalde från dem tolv som han också benämnde apostlar: ");
INSERT INTO swessb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon som han också benämnde Petrus, och Andreas hans bror, och Jakob och Johannes och Filippus och Bartolomeus ");
INSERT INTO swessb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","och Matteus och Tomas och Jakob Alfeus son och Simon som kallades seloten ");
INSERT INTO swessb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","och Judas Jakobs son och Judas Iskariot, som blev förrädare. ");
INSERT INTO swessb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Och han gick ner med dem och stod på en plan plats. Och där fanns en stor skara av hans lärjungar, och en stor mängd av folket från hela Judeen och Jerusalem och kusten vid Tyrus och Sidon ");
INSERT INTO swessb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","som kom för att höra honom och bli helade från sina åkommor. Och de som ofredades av orena andar blev botade, ");
INSERT INTO swessb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","och hela skaran sökte röra honom, för kraft gick ut från honom och helade alla. ");
INSERT INTO swessb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Och han lyfte upp sina ögon till sina lärjungar och sade: ”Saliga de fattiga, för ert är Guds rike. ");
INSERT INTO swessb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Saliga de som hungrar nu, för ni ska bli mättade. Saliga de som gråter nu, för ni ska få skratta. ");
INSERT INTO swessb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Saliga är ni när människorna hatar er och när de skiljer ut er och kritiserar och kastar ut ert namn som elakt för Människosonens skull. ");
INSERT INTO swessb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gläd er på den dagen och hoppa, för se: er lön är stor i himlen. För på samma sätt gjorde deras fäder mot profeterna. ");
INSERT INTO swessb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Men ve er rika, för ni har fått ut er tröst. ");
INSERT INTO swessb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ve er som är mätta nu, för ni ska få hungra. Ve dem som skrattar nu, för ni ska få sörja och gråta. ");
INSERT INTO swessb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ve när alla människorna talar väl om er! För på samma sätt gjorde deras fäder mot de falska profeterna. ");
INSERT INTO swessb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Men till er som lyssnar säger jag: Älska era fiender, gör väl mot dem som hatar er. ");
INSERT INTO swessb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Välsigna dem som förbannar er, bed för dem som okvädar er. ");
INSERT INTO swessb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mot den som slår dig på kinden ska du framhålla också den andra, och från den som tar din mantel ska du inte hindra också ­tunikan. ");
INSERT INTO swessb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Åt var och en som ber dig ska du ge, och från den som tar ditt ska du inte avkräva. ");
INSERT INTO swessb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Och så som ni vill att människorna ska göra mot er, gör mot dem likadant. ");
INSERT INTO swessb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Och om ni älskar dem som älskar er, vilken nåd är det för er? För även syndarna älskar dem som älskar dem. ");
INSERT INTO swessb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","För om ni gör gott mot dem som gör gott mot er, vilken nåd är det för er? Även syndarna gör detsamma. ");
INSERT INTO swessb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Och om ni lånar ut till dem från vilka ni hoppas få, vilken nåd är det för er? Även syndare lånar ut till syndare för att erhålla lika. ");
INSERT INTO swessb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nej, älska era fiender och gör gott och låna ut utan att hoppas få tillbaka. Och er lön ska bli stor, och ni ska bli den Högstes söner, för han är snäll mot de otacksamma och elaka. ");
INSERT INTO swessb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Var medlidande, så som också er Far är medlidande. ");
INSERT INTO swessb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Och döm inte, och ni blir aldrig dömda. Och fäll inte, och ni blir aldrig fällda. Frige och ni ska bli frigivna. ");
INSERT INTO swessb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ge, och det ska ges till er. Ett bra mått, packat, skakat, översvämmande ska man ge i er famn. För med det mått ni mäter med ska det mätas tillbaka till er.” ");
INSERT INTO swessb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Och han talade också en liknelse till dem: ”Inte kan väl en blind vägleda en blind? Faller inte båda i gropen? ");
INSERT INTO swessb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","En lärjunge är inte över läraren. Men förfärdigad blir var och en som sin lärare. ");
INSERT INTO swessb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Men varför ser du flisan i din broders öga, men bjälken i ditt eget öga beaktar du inte? ");
INSERT INTO swessb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hur kan du säga till din broder: Broder, låt mig kasta ut flisan i ditt öga, när du själv inte ser bjälken i ditt öga? Hycklare, kasta först ut bjälken ur ditt öga, och då ska du se flisan i din broders öga bra för att kasta ut den. ");
INSERT INTO swessb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","För det finns inget fint träd som gör rutten frukt, och åter inget ruttet träd som gör fin frukt. ");
INSERT INTO swessb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","För varje träd känns från sin egen frukt. För inte är det från törnen man plockar ihop fikon eller från en törnbuske man bärgar druvor? ");
INSERT INTO swessb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Den goda människan bär ur hjärtats goda skattgömma fram det goda, och den elaka bär ur det elaka fram det elaka. För av hjärtats överflöd talar hans mun. ");
INSERT INTO swessb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Men varför kallar ni mig: Herre Herre, och gör inte vad jag säger? ");
INSERT INTO swessb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Var och en som kommer till mig och hör mina ord och gör dem, jag ska visa er vem han är lik. ");
INSERT INTO swessb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Han är lik en människa som byggde ett hus, som grävde och fördjupade och lade en grund på klippan. Och när det blev översvämning bröt floden fram mot det huset, och den mäktade inte att skaka det, därför att det var väl byggt. ");
INSERT INTO swessb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Men den som hör och inte gör är lik en människa som byggde ett hus på jorden, utan grund, mot vilket floden bröt fram. Och direkt föll det samman, och det husets ras blev stort.” ");
INSERT INTO swessb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Då han hade uppfyllt alla sina ord i folkets öron, gick han in i Kapernaum. ");
INSERT INTO swessb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Men en centurions fasttjänare hade det illa och var på väg att avlida, och var uppskattad av honom. ");
INSERT INTO swessb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Och när han hörde om Jesus, sände han till honom några av judarnas äldste och frågade honom om att komma och genomfrälsa hans fasttjänare. ");
INSERT INTO swessb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Och de kom fram till Jesus och vädjade till honom ivrigt och sade att: ”Han är värd att du ska skaffa honom detta. ");
INSERT INTO swessb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","För han ­älskar vårt folkslag, och synagogan har han själv byggt åt oss.” ");
INSERT INTO swessb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Och Jesus gick med dem. Men redan när han var inte långt från huset, skickade centurionen vänner och sade till honom: ”Herre, besvära dig inte. För jag är inte förtjänt att du går in under mitt tak. ");
INSERT INTO swessb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Därför ansåg jag mig inte heller värdig att komma till dig. Men säg med ett ord och min gosse blir helad. ");
INSERT INTO swessb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","För också jag är en människa inordnad under auktoritet och har soldater under mig, och jag säger till den: Gå, och han går, och till en annan: Kom, och han kommer, och till min fasttjänare: Gör detta, och han gör det.” ");
INSERT INTO swessb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Och när Jesus hörde detta blev han förundrad över honom, och han vände sig till skaran som följde honom och sade: ”Jag säger er: Inte ens i Israel har jag funnit en så stor tro.” ");
INSERT INTO swessb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Och de utskickade återvände till huset och fann fasttjänaren frisk. ");
INSERT INTO swessb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Och det hände sig nästa dagatt han gick till en stad som kallas Nain, och med honom vandrade hans lärjungar och en stor skara. ");
INSERT INTO swessb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Men när han närmade sig stadens port, och se: det bars ut en som hade dött, en enfödd son till sin mor, och hon var änka. Och en avsevärd skara från staden var med henne. ");
INSERT INTO swessb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Och när Herren såg henne, kände han innerligt med henne och sade till henne: ”Gråt inte.” ");
INSERT INTO swessb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Och han gick fram och rörde vid likkistan. Och de som bar stan­nade, och han sade: ”Unge man, dig säger jag: Res dig!” ");
INSERT INTO swessb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Och då satte sig den döde upp och började tala, och han gav honom åt hans mor. ");
INSERT INTO swessb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Men fruktan tog tag i alla, och de ärade Gud och sade att: ”En stor profet har rest sig bland oss”, och att: ”Gud har besökt sitt folk.” ");
INSERT INTO swessb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Och detta ord gick ut i hela Judeen om honom, och i hela trakten runt omkring. ");
INSERT INTO swessb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Och för Johannes berättade hans lärjungar om allt detta. Och Johannes kallade till sig två av sina lärjungar ");
INSERT INTO swessb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","och skickade till Herren och sade: ”Är du han som kommer? Eller är det en annan vi ska vänta oss?” ");
INSERT INTO swessb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Och männen kom fram till honom och sade: ”Johannes Döparen har sänt oss till dig och säger: Är du han som kommer? Eller är det en annan vi ska vänta oss?” ");
INSERT INTO swessb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Vid den stunden botade han många från åkommor och gissel och elaka andar, och åt många blinda skänkte han att se. ");
INSERT INTO swessb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Och han svarade och sade till dem: ”Gå och berätta för Johannes det ni sett och hört: Blinda ser igen, lama går, spetälska renas och döva hör. Döda uppväcks, fattiga evangeliseras. ");
INSERT INTO swessb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Och salig är den som inte blir skandaliserad av mig.” ");
INSERT INTO swessb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Men när änglarna från Johannes hade gått iväg, började han säga till skarorna om Johannes: ”Vad gick ni ut i ödemarken för att skåda? Ett rör skakat av vind? ");
INSERT INTO swessb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nej, vad gick ni ut för att se? En man ekiperad i mjuka kläder? Se: de som är i härlig klädnad och fest finns i de kungliga palatsen. ");
INSERT INTO swessb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nej, vad gick ni ut för att se? En profet? Ja, jag säger er: och mycket mer än en profet. ");
INSERT INTO swessb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Denne är den om vilken det är skrivet: Se, jag sänder min budbärare framför ditt ansikte, och han ska preparera vägen för dig. ");
INSERT INTO swessb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jag säger er: Bland dem som fötts av kvinnor finns ingen större än Johannes. Men den mindre i Guds rike är större än han.” ");
INSERT INTO swessb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Och hela folket som lyssnade, även tullindrivarna, förklarade Gud rättfärdig och döptes med Johannes dop. ");
INSERT INTO swessb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Men fariseerna och de laglärda avvisade för sig själva Guds plan och döptes inte av honom. ");
INSERT INTO swessb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","”Vid vad ska jag då likna människorna i detta släkte? Och vad är de lika? ");
INSERT INTO swessb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","De är lika barn som sitter på torget och ropar till varandra, som det heter: Vi flöjtade för er och ni dansade inte, vi sjöng sorgesång och ni grät inte. ");
INSERT INTO swessb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","För Johannes Döparen har kommit och åt inte bröd eller drack vin, och ni säger: Han har en demon. ");
INSERT INTO swessb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Människosonen har kommit och äter och dricker, och ni säger: Se människan, en frossare och vindrinkare, en vän till tullindrivare och syndare! ");
INSERT INTO swessb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Och Visheten har förklarats rättfärdig av alla sina barn.” ");
INSERT INTO swessb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Och sedan frågade honom en av fariseerna om att äta med honom, och han gick in i fariséns hus och lutade sig till bords. ");
INSERT INTO swessb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Och se: en kvinna som fanns i staden var syndig. Och när hon insåg att han ligger till bords i fariséns hus, fick hon fram en alabasterflaska med balsam ");
INSERT INTO swessb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","och ställde sig bakom vid hans fötter, och gråtande började hon med tårarna väta hans fötter och torkade av med sitt huvudhår. Och hon kysste ner hans fötter och smorde in med balsam. ");
INSERT INTO swessb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Men när farisén som bjudit in honom såg det, talade han inom sig och sade: ”Om den där hade varit profet, hade han vetat vem och hurdan kvinnan är som rör honom. Att hon är syndig.” ");
INSERT INTO swessb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Och Jesus svarade och sade till honom: ”Simon, jag har något att säga dig.” Och han: ”Lärare, säg det”, säger han. ");
INSERT INTO swessb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","”Två var skuldsatta till en ­utlånare. Den ene var skyldig femhundra denarer, och den andre fem­tio. ");
INSERT INTO swessb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","När de inte hade att betala, efterskänkte han för båda. Vem av dem kommer då att älska honom mer?” ");
INSERT INTO swessb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon svarade och sade: ”Jag antager att det är den för vilken mer blev efterskänkt.” Och han sade till honom: ”Du har dömt riktigt.” ");
INSERT INTO swessb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Och han vände sig till kvinnan och sade till Simon: ”Ser du denna kvinna? Jag kom in i ditt hus, vatten på fötterna gav du mig inte. Men hon har med tårarna vätt mina fötter och torkat av med sitt hår. ");
INSERT INTO swessb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kyss gav du mig inte, men hon har från det att jag kom in inte upphört kyssa ner mina fötter. ");
INSERT INTO swessb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Med olja smorde du inte in mitt huvud, men hon har med balsam smort in mina fötter. ");
INSERT INTO swessb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tack vare det säger jag dig: Hennes många synder är förlåtna. För hon har älskat mycket. Men den för vilken lite blir förlåtet, älskar lite.” ");
INSERT INTO swessb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Och han sade till henne: ”Dina synder är förlåtna.” ");
INSERT INTO swessb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Och då började de som låg till bords med honom säga inom sig: ”Vem är den där som till och med förlåter synder?” ");
INSERT INTO swessb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Men han sade till kvinnan: ”Din tro har frälst dig. Gå i frid.” ");
INSERT INTO swessb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Och det hände sig i ordningen att han reste genom varje stad och by och förkunnade och evangeliserade Guds rike. Och de tolv var med honom, ");
INSERT INTO swessb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","och några kvinnor som var botade från elaka andar och sjukdomar: Maria som kal­las Magdalena, från vilken sju demoner hade kommit ut, ");
INSERT INTO swessb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","och Johanna hustru till Kusas, Herodes förman, och Susanna och många andra som betjänade dem utifrån det som var deras. ");
INSERT INTO swessb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Men när det kom samman en stor skara och de som i varje stad gick till honom, sade han genom en liknelse: ");
INSERT INTO swessb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","”Ut gick såningsmannen för att så sitt utsäde. Och under det att han sådde föll en del vid vägen och trampades ner, och himlens fåglar åt upp det. ");
INSERT INTO swessb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Och annat föll ner på klippan, och uppvuxet vissnade det eftersom det inte hade fukt. ");
INSERT INTO swessb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Och annat föll mitt bland törnena, och törnena växte upp samtidigt och kvävde ihjäl det. ");
INSERT INTO swessb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Och annat föll i den goda jorden, och uppvuxet gjorde det gröda hundrafaldigt.” När han sagt detta, ropade han: ”Den som har öron att höra med ska höra!” ");
INSERT INTO swessb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Och sedan frågade honom hans lärjungar vad denna liknelse kunde vara. ");
INSERT INTO swessb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Men han sade: ”Åt er är det givet att känna Guds rikes hemligheter. Men för de övriga är det i liknelser, för att de ska se och inte se, och höra och inte förstå. ");
INSERT INTO swessb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Men detta är liknelsen: Utsädet är Guds ord. ");
INSERT INTO swessb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Och de vid vägen är de som hör, sedan kommer djävulen och tar ordet från deras hjärtan så att de inte tror och blir frälsta. ");
INSERT INTO swessb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Och de på klippan är de som när de hör med glädje välkomnar ordet, och dessa har ingen rot: de tror för en tid och i testets stund avlägsnar de sig. ");
INSERT INTO swessb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Och det som föll bland törnena, dessa är de som hör och av bekymmer och rikedom och tillvarons njutningar kvävs ihop medan de vandrar och inte bär mogen frukt. ");
INSERT INTO swessb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Men det i den fina jorden, dessa är de som med fint och gott hjärta hör ordet och håller fast och bär frukt i uthållighet. ");
INSERT INTO swessb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Och ingen tänder en lampa och täcker den med ett kärl eller sätter under en bädd. Nej, på lampstället sätter man den, så att de som kommer in ser ljuset. ");
INSERT INTO swessb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","För det finns inget dolt som inte ska bli uppenbart, och inget förborgat som aldrig ska bli känt och komma till det uppenbara. ");
INSERT INTO swessb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Se därför upp hur ni lyssnar. För den som har, åt honom ska det ges. Och den som inte har, också det han tänker sig ha ska tas ifrån honom.” ");
INSERT INTO swessb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Och sedan kom hans mor och bröder dit till honom, och de kunde inte träffa honom för skarans skull. ");
INSERT INTO swessb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Och det berättades för honom: ”Din mor och dina bröder står utanför och vill se dig.” ");
INSERT INTO swessb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Men han ­svarade och sade till dem: ”Min mor och mina bröder, dessa är de som hör och gör Guds ord.” ");
INSERT INTO swessb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Och det hände sig en av dagarna att han steg i en båt med sina lärjungar och sade till dem: ”Låt oss fara över till andra sidan sjön.” Och de lade ut. ");
INSERT INTO swessb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Men medan de seglade somnade han ifrån. Och det kom ner en storm med vind över sjön, och de började fyllas och var i fara. ");
INSERT INTO swessb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Och de kom fram och väckte honom och sade: ”Mästare, Mästare! Vi går förlorade!” Och väckt näpste han vinden och vattnets vågsvall, och det slutade och blev ett lugn. ");
INSERT INTO swessb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Och han sade till dem: ”Var är er tro?” Och de fruktade och var förundrade och sade till varandra: ”Vem är då denne? För till och med vindarna beordrar han och vattnet, och de hörsammar honom.” ");
INSERT INTO swessb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Och de seglade ner till gerasenernas trakt, som är mitt emot Galileen. ");
INSERT INTO swessb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Men när han gick ur i land, mötte honom en man från staden som hade demoner. Och avsevärd tid hade han inte iklätt sig mantel, och han uppehöll sig inte i ett hus utan bland gravarna. ");
INSERT INTO swessb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Och när han såg Jesus, skrek han högt och föll ner för honom och sade med väldig röst: ”Vad mellan mig och dig, Jesus, den högste Gudens Son? Jag bönfaller dig, plåga mig inte!” ");
INSERT INTO swessb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","För han hade instruerat den orena anden att komma ut ur mannen. För långa tider hade den ryckt honom med sig, och han hade blivit hopbuntad med kedjor och fotbojor och vaktad, och rivit sönder bojorna och drivits av demonen ut i ödemarkerna. ");
INSERT INTO swessb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Men Jesus frågade honom: ”Vad är ditt namn?” Och han sade: ”Legion”, för det hade kommit in många demoner i honom. ");
INSERT INTO swessb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Och de vädjade till honom att inte beordra dem att fara bort till avgrunden. ");
INSERT INTO swessb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Men det fanns där en hjord med åtskilliga svin som vallades på berget, och de vädjade till honom att tillåta dem att fara in i dessa. Och han tillät dem. ");
INSERT INTO swessb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Och då kom demonerna ut ur mannen och for in i svinen, och hjorden rusade ner från branten i sjön och kvävdes ihjäl. ");
INSERT INTO swessb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Men när de som vallade såg det som hänt, flydde de och berättade i staden och på fälten. ");
INSERT INTO swessb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Och man gick ut för att se det som hade hänt. Och de kom till Jesus och fann mannen från vilken demonerna kommit ut sittande klädd och sansad vid Jesu fötter. Och de fruktade. ");
INSERT INTO swessb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Och då berättade de som hade sett för dem hur den som varit demoniserad blev frälst. ");
INSERT INTO swessb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Och då tillfrågade honom hela mängden från gerasenernas trakt där omkring om att gå bort från dem, för av stark fruktan var de ansatta. Och han steg i båten och återvände. ");
INSERT INTO swessb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Men då bönföll honom mannen från vilken demonerna kommit ut att få vara med honom. Men han skickade iväg honom och sade: ");
INSERT INTO swessb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","”Återvänd till ditt hus och skildra vad Gud har gjort för dig.” Och han gick bort och förkunnade över hela staden vad Jesus hade gjort för honom. ");
INSERT INTO swessb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Men när Jesus återvände välkomnade honom skaran, för alla var i förväntan på honom. ");
INSERT INTO swessb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Och se: det kom en man vars namn var Jairus, och denne var ledare för synagogan. Och han föll ner vid Jesu fötter och vädjade till honom att komma till hans hus, ");
INSERT INTO swessb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","för han hade en enfödd dotter, omkring tolv år, och hon höll på att dö. Men under det att han begav sig höll skarorna på att kväva ihop honom. ");
INSERT INTO swessb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Och en kvinna som varit i blodflöde sedan tolv år, som gjort slut på alla tillgångarna på läkare och inte av någon mäktat bli botad, ");
INSERT INTO swessb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","kom fram bakifrån och rörde vid hörntofsen på hans mantel. Och genast stannade hennes blodflöde. ");
INSERT INTO swessb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Och Jesus sade: ”Vem var det som rörde mig?” När alla nekade sade Petrus: ”Mästare, skarorna ansätter dig och pressar sig på.” ");
INSERT INTO swessb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Men Jesus sade: ”Någon rörde mig. För jag kände kraft som gått ut från mig.” ");
INSERT INTO swessb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Och när kvinnan såg att hon inte undgått upptäckt, kom hon darrande och föll ner för honom. Av vilken orsak hon rört honom berättade hon inför allt folket, och hur hon blivit helad genast. ");
INSERT INTO swessb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Och han sade till henne: ”Dotter, din tro har frälst dig. Gå i frid.” ");
INSERT INTO swessb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Medan han ännu talar, kommer någon från synagogföreståndaren och säger att: ”Din dotter har dött. Besvära inte Läraren mer.” ");
INSERT INTO swessb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Men när Jesus hörde det, svarade han honom: ”Frukta inte. Bara tro, och hon blir frälst.” ");
INSERT INTO swessb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Och när han kom till huset, lät han inte någon gå in med honom utom Petrus och Johannes och Jakob och tösens far och mor. ");
INSERT INTO swessb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Och alla grät och slog sig själva över henne. Men han sade: ”Gråt inte. För hon har inte dött, utan sover.” ");
INSERT INTO swessb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Och de skrattade åt honom, då de visste att hon dött. ");
INSERT INTO swessb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Men han grep hennes hand och ropade och sade: ”Tösen, res dig!” ");
INSERT INTO swessb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Och hennes ande vände om, och hon stod genast upp. Och han förordnade för henne att ges något att äta. ");
INSERT INTO swessb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Och hennes föräldrar var utom sig. Men han instruerade dem att inte säga till någon det som hade hänt. ");
INSERT INTO swessb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Och han sammankallade de tolv och gav dem makt och auktoritet över alla demonerna och att bota åkommor. ");
INSERT INTO swessb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Och han sände ut dem att förkunna Guds rike och hela de sjuka ");
INSERT INTO swessb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","och sade till dem: ”Ta inget för vägen, varken stav eller väska eller bröd eller silver eller två tunikor var att ha. ");
INSERT INTO swessb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Och i det hus där ni går in, där ska ni bli kvar och därifrån gå ut. ");
INSERT INTO swessb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Och de som inte välkomnar er, gå ut från den staden och skaka av dammet från era fötter till ett vittnesbörd för dem.” ");
INSERT INTO swessb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Och de gick ut och gick genom by efter by och evan­geliserade och botade överallt. ");
INSERT INTO swessb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Men Herodes tetrarken hörde om allt som hände och var djupt villrådig, eftersom det sades av några att Johannes blivit uppväckt från de döda, ");
INSERT INTO swessb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","men av några att Elia hade visat sig och av andra att en profet av de urtida hade uppstått. ");
INSERT INTO swessb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Och Herodes sade: ”Johannes halshögg jag. Men vem är denne om vilken jag hör sådant?” Och han sökte få se honom. ");
INSERT INTO swessb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Och apostlarna återvände och skildrade för honom vad de hade gjort. Och han tog med dem och drog sig undan enskilt till en stad som kallas Betsaida. ");
INSERT INTO swessb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Men skarorna fick veta och följde honom. Och han välkomnade dem och talade till dem om Guds rike, och dem som hade behov av bot helade han. ");
INSERT INTO swessb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Men dagen började vika, och de tolv kom fram och sade till honom: ”Skicka iväg skaran, så att de går till byarna och gårdarna runt omkring och övernattar och finner proviant. För här är vi på en öde plats.” ");
INSERT INTO swessb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Men han sade till dem: ”Ge dem ni att äta.” Men de sade: ”Vi har inte mer än fem bröd och två fiskar. Om väl inte vi ska gå och köpa matämnen för allt detta folk?” ");
INSERT INTO swessb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","För det var omkring femtusen män. Men han sade till sina lärjungar: ”Få dem att luta sig till bords i matlag. Unge­fär femtio var.” ");
INSERT INTO swessb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Och de gjorde så och fick allihop att luta sig till bords. ");
INSERT INTO swessb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Och han tog de fem bröden och de två fiskarna, såg upp mot himlen och välsignade dem. Och han bröt och gav åt lärjungarna för att sätta fram åt skaran. ");
INSERT INTO swessb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Och alla åt och blev mätta, och det togs upp som blev över för dem av bitar, tolv korgar. ");
INSERT INTO swessb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Och det hände sig, under det att han var och bad ensam, att lärjungarna var med honom. Och han frågade dem och sade: ”Vem säger skarorna att jag är?” ");
INSERT INTO swessb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Och de svarade och sade: ”Johannes Döparen. Men andra Elia, och andra att en profet av de urtida har uppstått.” ");
INSERT INTO swessb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Och han sade till dem: ”Och ni? Vem säger ni att jag är?” Och Petrus svarade och sade: ”Guds Kristus.” ");
INSERT INTO swessb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Men han näpste dem och instruerade att inte säga detta till någon, ");
INSERT INTO swessb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","och sade att: ”Människosonen måste lida mycket, och bli förkastad av de äld­ste och översteprästerna och de skriftlärda och bli dödad. Och den tredje dagen upprest.” ");
INSERT INTO swessb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Och han sade till alla: ”Om någon vill komma efter mig, ska han förneka sig själv och ta upp sitt kors varje dag och följa mig. ");
INSERT INTO swessb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","För den som vill frälsa sin själ ska förlora den, men den som förlorar sin själ för min skull, denne ska frälsa den. ");
INSERT INTO swessb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","För vilken nytta får en människa som vinner hela världen men förlorar eller mister sig själv? ");
INSERT INTO swessb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","För den som skäms för mig och mina ord, denne ska Människosonen skäm­mas för när han kommer i sin och Faderns och de heliga änglarnas härlighet. ");
INSERT INTO swessb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Men jag säger er sannerligen: Det finns några av dem som står här som inte ska smaka döden förrän de sett Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Och det hände sig efter dessa ord, ungefär åtta dagar, och han tog med Petrus och Johannes och Jakob och gick upp till berget för att bedja. ");
INSERT INTO swessb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Och det hände sig, under det att han bad, att hans ansiktes skepnad blev en annan och hans klädnad blixtrande vit. ");
INSERT INTO swessb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Och se: två män samtalade med honom. De var Mose och Elia, ");
INSERT INTO swessb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","som visade sig i härlighet och talade om hans uttåg som han skulle uppfylla i Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Men Petrus och de som var med honom var tyngda av sömn. Men när de var helt vakna, såg de hans härlighet och de två männen som stod med honom. ");
INSERT INTO swessb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Och det hände sig, under det att de skilde sig från honom, att Petrus sade till Jesus: ”Mästare, det är fint att vi är här. Och vi ska göra tre hyddor: en åt dig och en åt Mose och en åt Elia”, men han visste inte vad han säger. ");
INSERT INTO swessb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Men medan han sade detta, kom ett moln och överskuggade dem. Och de fruktade under det att de kom in i molnet. ");
INSERT INTO swessb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Och en röst kom ur molnet och sade: ”Denne är min Son, den Utvalde. Lyssna till honom!” ");
INSERT INTO swessb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Och vid det att rösten kom befanns Jesus ensam. Och de teg och berättade inte för någon under de dagarna något av vad de hade sett. ");
INSERT INTO swessb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Och det hände sig nästa dag, när de kom ner från berget, attdär mötte honom en stor skara. ");
INSERT INTO swessb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Och se: en man från skaran ropade och sade: ”Lärare, jag bönfaller dig att se till min son! För han är min enfödde, ");
INSERT INTO swessb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","och se: en ande tar honom och plötsligt skriker den och ruskar honom med fradga, och det är knappt att den drar bort från honom, den knäcker honom. ");
INSERT INTO swessb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Och jag bönföll dina lärjungar att de skulle driva ut den, och de kunde inte.” ");
INSERT INTO swessb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Och Jesus svarade och sade: ”O otroende och förvridna släkte, hur länge ska jag vara hos er och stå ut med er? För fram din son hit.” ");
INSERT INTO swessb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Men medan han ännu kom, slet demonen omkull honom och ruskade. Men Jesus näpste den orena anden och helade gossen och gav honom tillbaka till hans far. ");
INSERT INTO swessb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Och alla var överväldigade vid Guds storhet. Men när alla var förundrade över allt som han gjorde, sade han till sina lärjungar: ");
INSERT INTO swessb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","”Sätt ni i era öron dessa ord. För Människosonen kommer att utlämnas i människors händer.” ");
INSERT INTO swessb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Men de förstod inte detta ord, och det var beslöjat för dem så att de inte uppfattade det. Och de fruktade för att fråga honom om detta ord. ");
INSERT INTO swessb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Men det kom in en fundering bland dem, vem som kunde vara störst av dem. ");
INSERT INTO swessb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Men Jesus visste om funderingen i deras hjärta, och han tog tag i ett barn och ställde det bredvid sig ");
INSERT INTO swessb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","och sade till dem: ”Den som välkomnar detta barn vid mitt namn välkomnar mig. Och den som välkomnar mig, välkomnar honom som har sänt mig. För den som är mindre bland er alla, denne är stor.” ");
INSERT INTO swessb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Men Johannes svarade och sade: ”Mästare, vi såg en som i ditt namn drev ut demoner, och vi hindrade honom eftersom han inte följde tillsammans med oss.” ");
INSERT INTO swessb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Men Jesus sade till honom: ”Hindra inte. För den som inte är emot er, är för er.” ");
INSERT INTO swessb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Och det hände sig, vid det att dagarna för hans upptagande fullbordades, att han stärkte ansiktet för att gå till Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Och han sände ut änglar framför sitt ansikte, och de gick och kom in i en by med samarier för att förbereda för honom. ");
INSERT INTO swessb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Och man välkomnade honom inte, eftersom hans ansikte gick mot Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Men när lärjungarna Jakob och Johannes såg det, sade de: ”Herre, vill du vi säger att eld ska komma ner från himlen och förtära dem?” ");
INSERT INTO swessb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Men han vände sig och näpste dem. ");
INSERT INTO swessb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Och de gick till en annan by. ");
INSERT INTO swessb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Och när de vandrade på vägen, sade någon till honom: ”Jag ska följa dig vart du än går hän.” ");
INSERT INTO swessb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Och Jesus sade till honom: ”Rävarna har lyor och himlens fåglar bon, men Människosonen har ingenstans att luta huvudet.” ");
INSERT INTO swessb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Och han sade till en annan: ”Följ mig!” Men han sade: ”Herre, tillåt mig att gå bort och först begrava min far.” ");
INSERT INTO swessb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Men han sade till honom: ”Låt de döda begrava sina döda. Men gå du iväg och proklamera Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Och även en annan sade: ”Jag ska följa dig, Herre. Men först, tillåt mig att ta farväl av dem i mitt hus.” ");
INSERT INTO swessb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Och Jesus sade till honom: ”Ingen som sätter handen till plogen och sedan ser bakåt är välägnad för Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Och efter detta utpekade Herren sjuttiotvå andra och sände ut dem två och två framför sitt ansikte till varje stad och plats dit han själv skulle komma. ");
INSERT INTO swessb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Och han sade till dem: ”Skörden är stor men arbetarna få. Bönfall då skördens Herre att han driver ut arbetare till sin skörd. ");
INSERT INTO swessb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bege er! Se: jag sänder er som lamm mitt bland vargar. ");
INSERT INTO swessb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bär inte börs, inte väska, inte sandaler, och hälsa inte på någon längs vägen. ");
INSERT INTO swessb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Och i det hus där ni kommer in, säg först: Frid åt detta hus. ");
INSERT INTO swessb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Och om där finns en fridens man, ska er frid vila över honom. Och annars ska den återvända över er. ");
INSERT INTO swessb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Och i samma hus ska ni bli kvar och äta och dricka det ni får från dem, för arbetaren är värd sin lön. Gå inte vidare från hus till hus. ");
INSERT INTO swessb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Och i den stad där ni kommer in och man välkomnar er, ät det som sätts fram åt er. ");
INSERT INTO swessb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Och bota de sjuka i den och säg till dem: Guds rike är nu nära inpå er. ");
INSERT INTO swessb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Men i den stad där ni kommer in och man inte välkomnar er, gå ut på dess gator och säg: ");
INSERT INTO swessb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Till och med dammet som anslutit sig till oss från er stad på fötterna torkar vi av till er. Men det ska ni veta: att Guds rike nu är nära. ");
INSERT INTO swessb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jag säger er att för Sodom ska det på den dagen bli uthärdligare än för den staden. ");
INSERT INTO swessb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ve dig, Korasin! Ve dig, Betsaida! För om det var i Tyrus och Sidon de hade skett, kraftgärningarna som skett i er, hade de sedan länge suttit i säck och aska och ändrat sinne. ");
INSERT INTO swessb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Men för Tyrus och Sidon ska det bli uthärdligare vid domen än för er. ");
INSERT INTO swessb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Och du Kapernaum, inte ska du bli upphöjd till himlen? Till Hades ska du gå ner. ");
INSERT INTO swessb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Den som lyssnar till er lyssnar till mig, och den som avvisar er avvisar mig. Och den som avvisar mig, avvisar honom som har sänt mig.” ");
INSERT INTO swessb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Och de sjuttiotvå återvände med glädje och sade: ”Herre, till och med demonerna underordnar sig oss i ditt namn.” ");
INSERT INTO swessb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Och han sade till dem: ”Jag skådade Satan som en blixt, fallande från himlen. ");
INSERT INTO swessb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Se: jag har gett er auktoriteten att trampa ovanpå ormar och skorpioner och på all fiendens makt, och ingenting ska alls skada er. ");
INSERT INTO swessb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Men gläd er inte i detta att andarna underordnar sig er, utan gläd er att era namn är inskrivna i himlarna.” ");
INSERT INTO swessb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I samma stund jublade han i den heliga Anden och sade: ”Jag erkänner dig Far, himlens och jordens Herre, att du har förborgat detta för visa och förståndiga och uppenbarat det för små barn. Ja Far, för så blev det välbehag inför dig. ");
INSERT INTO swessb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Allt har överlämnats till mig av min Far. Och ingen vet vem Sonen är utom Fadern, och vem Fadern är utom Sonen och den för vilken Sonen önskar uppenbara det.” ");
INSERT INTO swessb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Och han vände sig till lärjungarna enskilt och sade: ”Saliga de ögon som ser det ni ser. ");
INSERT INTO swessb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","För jag säger er att många profeter och kungar ville se det ni ser och fick inte se, och höra det ni hör och fick inte höra.” ");
INSERT INTO swessb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Och se: en laglärd stod upp och testade ut honom och sade: ”Lärare, vad ska jag ha gjort så att jag ärver eoniskt liv?” ");
INSERT INTO swessb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Och han sade till honom: ”I lagen, vad är skrivet? Hur läser du?” ");
INSERT INTO swessb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Och han svarade och sade: ”Du ska älska Herren din Gud av hela ditt hjärta, och med hela din själ, och med hela din styrka,och med hela ditt förstånd. Och din nästa som dig själv.” ");
INSERT INTO swessb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Och han sade till honom: ”Du svarade riktigt. Gör detta och du ska leva.” ");
INSERT INTO swessb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Men han ville förklara sig rättfärdig och sade till Jesus: ”Och vem är min nästa?” ");
INSERT INTO swessb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus tog sig an det och sade: ”En man gick ner från Jerusalem till Jeriko och råkade ut för rövare, som både klädde av honom och lade på slag och sedan gick iväg och lämnade honom halvdöd. ");
INSERT INTO swessb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Men av ett sammanträffande gick en präst ner på den vägen. Och när han såg honom, gick han förbi mittemot. ");
INSERT INTO swessb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Och likaså kom också en levit som kom ner till platsen. Och när han såg, gick han förbi mittemot. ");
INSERT INTO swessb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Men en resande samarier kom ner till honom, och när han såg kände han innerligt. ");
INSERT INTO swessb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Och han gick fram och förband hans sår och hällde på olja och vin. Och han satte upp honom på sitt eget riddjur och förde honom till ett värdshus och hade omsorg om honom. ");
INSERT INTO swessb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Och på morgonen kastade han fram och gav två denarer till värdshusvärden och sade: Ha omsorg om honom. Och det som du spenderar mer ska jag, vid det att jag kommer tillbaka, betala dig. ");
INSERT INTO swessb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Vem av dessa tre tycks för dig ha varit en nästa för honom som råkade ut för rövarna?” ");
INSERT INTO swessb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Och han sade: ”Den som gjorde barmhärtigheten med honom.” Och Jesus sade till honom: ”Gå och gör du likadant.” ");
INSERT INTO swessb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Och under det att de vandrade kom han in i en by, och en kvinna vid namn Marta välkomnade honom hos sig. ");
INSERT INTO swessb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Och denna hade en syster som kallades Maria, som också satte sig vid Herrens fötter och hörde hans ord. ");
INSERT INTO swessb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Men Marta var distraherad kring mycket betjäning, och hon stod framför och sade: ”Herre, bryr du dig inte att min syster har lämnat mig ensam att betjäna? Säg nu till henne att hon tar tag med mig.” ");
INSERT INTO swessb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Men Herren svarade och sade till henne: ”Marta, Marta, du bekymrar dig och väsnas över mycket, ");
INSERT INTO swessb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","men av ett enda finns det behov. För Maria har utvalt den goda delen, som inte ska tas ifrån henne.” ");
INSERT INTO swessb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Och det hände sig, under det att han var på en plats och bad, att när han slutat sade en av hans lärjungar till honom: ”Herre, lär oss att bedja, så som också Johannes lärde sina lärjungar.” ");
INSERT INTO swessb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Och han sade till dem: ”När ni beder ska ni säga: Far, helgat ska ditt namn bli. Komma ska ditt rike. ");
INSERT INTO swessb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vårt tillkommande bröd ge oss var dag. ");
INSERT INTO swessb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Och förlåt oss våra synder, för också själva förlåter vi var och en som är skyldig oss. Och för oss inte in i frestelse.” ");
INSERT INTO swessb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Han sade till dem: ”Vem av er skulle ha en vän och gå till honom vid midnatt och säga till honom: Min vän, låna mig tre bröd, ");
INSERT INTO swessb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","då en vän till mig har kommit hit från vägen till mig och jag har inget att sätta fram åt honom – ");
INSERT INTO swessb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","och denne skulle svara inifrån och säga: Skaffa mig inte besvär! Dörren är redan stängd och mina barn är med mig i sängen. Jag kan inte stå upp och ge dig. ");
INSERT INTO swessb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jag säger er: Även om han inte kommer att ge ­honom och stå upp för att det är hans vän, kommer han just för hans oförskämdhet att resa sig och ge honom vad han behöver. ");
INSERT INTO swessb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Och jag säger er: Be och ni ska få. Sök och ni ska finna. Bulta och det ska öppnas för er. ");
INSERT INTO swessb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","För var och en som ber får, och den som söker finner. Och för den som bultar ska det öppnas. ");
INSERT INTO swessb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Men hos vem av er som är far kommer sonen att be om fisk, och istället för fisk kommer han att ge honom en orm? ");
INSERT INTO swessb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Eller också kommer han att be om ägg, och han kommer att ge honom en skorpion? ");
INSERT INTO swessb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Om nu ni som är elaka vet att ge goda gåvor till era barn, hur mycket mer ska er Far från himlen ge helig Ande åt dem som ber honom?” ");
INSERT INTO swessb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Och han drev ut en demon och den var stum. Och det hände sig, när demonen hade kommit ut, att den stumme talade och skarorna var förundrade. ");
INSERT INTO swessb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Men några av dem sade: ”Det är med Beelsebul, demonernas furste, han driver ut demonerna.” ");
INSERT INTO swessb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Och andra testade och sökte ett tecken från himlen från honom. ");
INSERT INTO swessb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Men han visste om deras tankebanor och sade till dem: ”Varje rike uppdelat mot sig självt blir ödelagt, och hus faller över hus. ");
INSERT INTO swessb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Men om också Satan var uppdelad mot sig själv, hur ska hans rike bestå? För ni säger att det är med Beelsebul jag driver ut demonerna. ");
INSERT INTO swessb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Men om det är med Beelsebul jag driver ut demonerna, med vem driver era söner ut? Därför blir de era domare. ");
INSERT INTO swessb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Men om det är med Guds finger jag driver ut demonerna, då har Guds rike nått till er. ");
INSERT INTO swessb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","När den starke beväpnad vaktar sin fålla är det i fred som är hans. ");
INSERT INTO swessb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Men då en som är starkare än honom kommer över och besegrar honom, tar han hans vapenrustning på vilken han förtröstade och ger ut hans krigsbyte. ");
INSERT INTO swessb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Den som inte är med mig, är mot mig. Och den som inte samlar med mig skingrar. ");
INSERT INTO swessb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","När den orena anden kommer ut från människan, går den genom vattenlösa platser och söker ro och finner ingen. Då säger den: Jag ska återvända till mitt hus varifrån jag kom ut. ");
INSERT INTO swessb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Och den kommer och finner det sopat och tillsnyggat. ");
INSERT INTO swessb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Då går den och tar med sju andra andar elakare än sig själv, och de går in och bosätter sig där. Och då blir det sista för den människan värre än det första.” ");
INSERT INTO swessb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Och det hände sig, under det att han sade detta, att en kvinna från skaran höjde sin röst och sade till honom: ”Saligt det moderliv som burit dig och de bröst som du diat!” ");
INSERT INTO swessb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Men han sade: ”Snarare: saliga de som hör Guds ord och iakttar det.” ");
INSERT INTO swessb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Men när skarorna tillhopades började han säga: ”Detta släkte är ett elakt släkte. Ett tecken söker det, och ett tecken ska inte ges det utom Jonas tecken. ");
INSERT INTO swessb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","För så som Jona blev för nineviterna ett tecken, så ska också Människosonen vara för detta släkte. ");
INSERT INTO swessb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Söderns drottning ska resa sig vid domen med männen av detta släkte och fördöma dem. För hon kom från jordens ändar för att höra Salomos vishet, och se: något större än Salomo är här. ");
INSERT INTO swessb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninevitiska män ska uppstå vid domen med detta släkte och fördöma det. För de ändrade sinne vid Jonas förkunnelse, och se: något större än Jona är här. ");
INSERT INTO swessb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ingen tänder en lampa och sätter i en källare eller under skäppan, utan på lampstället så att de som kommer in ser ljuset. ");
INSERT INTO swessb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kroppens lampa är ditt öga. När ditt öga är oreserverat är också hela din kropp upplyst. Men då det är elakt är också din kropp mörklagd. ");
INSERT INTO swessb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Observera då att inte ljuset i dig är mörker. ");
INSERT INTO swessb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Om nu hela din kropp är upplyst och inte har någon del som är mörklagd, blir hela upplyst som när lampan upplyser dig med blixtskenet.” ");
INSERT INTO swessb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Och vid det att han hade talat, frågar honom en farisé om att luncha hos honom. Och han gick in och lade sig till bords. ");
INSERT INTO swessb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Men farisén såg och var förundrad att han inte först doppade sig före lunchen. ");
INSERT INTO swessb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Men Herren sade till honom: ”Nu, ni fariseer: det yttre av bägaren och fatet renar ni, men ert inre är fullt av rofferi och elakhet. ");
INSERT INTO swessb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tanklösa, har inte han som gjort det yttre också gjort det inre? ");
INSERT INTO swessb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Men ge det som finns där inne som allmosa, och se: allt är rent för er. ");
INSERT INTO swessb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Men ve er fariseer! För ni ger tionde av myntan och vinrutan och varje köksväxt, och förbigår rätten och kärleken till Gud. Men detta borde ni göra och inte samtidigt försumma det andra. ");
INSERT INTO swessb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ve er fariseer! För ni älskar förstapositionen i synagogorna och hälsningarna på torgen. ");
INSERT INTO swessb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ve er! För ni är som de omärkta gravarna, och människorna som vandrar ovanpå vet inte om det.” ");
INSERT INTO swessb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Men då svarar en av de laglärda och säger till honom: ”Lärare, när du säger detta skymfar du även oss.” ");
INSERT INTO swessb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Men han sade: ”Även er laglärda, ve! För ni belastar människorna med svårburna bördor, och själva rör ni inte bördorna med ett av era fingrar. ");
INSERT INTO swessb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ve er! För ni bygger profeternas gravmonument, och era fäder dödade dem. ");
INSERT INTO swessb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Alltså är ni vittnen och samtycker till era fäders gärningar, för de dödade dem och ni bygger. ");
INSERT INTO swessb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Därför har också Guds vishet sagt: Jag ska sända till dem profeter och apostlar, och en del av dem ska de döda och förfölja, ");
INSERT INTO swessb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","för att blodet av alla profeterna utgjutet från världens grundläggning ska sökas från detta släkte, ");
INSERT INTO swessb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","från blodet av Abel till blodet av Sakarja som förgjordes mellan altaret och huset. Ja, jag säger er: Det ska sökas från detta släkte. ");
INSERT INTO swessb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ve er laglärda! För ni har tagit nyckeln till kunskapen. Själva har ni inte gått in, och dem som går in har ni hindrat.” ");
INSERT INTO swessb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Och när han gick ut därifrån, började de skriftlärda och fariseerna fruktansvärt ansätta och utfråga honom om mycket, ");
INSERT INTO swessb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","och de låg på lur för honom för att få fast något ur hans mun. ");
INSERT INTO swessb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","När myriaderna av skaran hade församlats så att de höll på att trampa ner varandra, började han tala till sina lärjungar först: ”Akta er för surdegen, vilket är hyckleri, hos fariseerna! ");
INSERT INTO swessb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Och inget undangömt finns som inte ska uppenbaras, och inget dolt som inte ska bli känt. ");
INSERT INTO swessb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Därför ska vad ni sagt i mörkret höras i ljuset, och det ni talat i örat i kamrarna ska förkunnas på taken. ");
INSERT INTO swessb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Och jag säger till er, mina vänner: Frukta inte för dem som dödar kroppen och efter detta inte har något mer att göra. ");
INSERT INTO swessb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Men jag ska visa er vem ni ska frukta: Frukta honom som efter dödandet har auktoritet att kasta i Gehenna. Ja, jag säger er: Denne ska ni frukta. ");
INSERT INTO swessb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Säljs inte fem sparvar för två ass? Och inte en enda av dem är glömd inför Gud. ");
INSERT INTO swessb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Men även hårstråna på ert huvud är alla räknade. Frukta inte! Ni är viktigare än många sparvar. ");
INSERT INTO swessb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Och jag säger er: Var och en som bekänner sig till mig inför människorna, honom ska också Människosonen bekänna sig till inför Guds änglar. ");
INSERT INTO swessb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Men den som förnekar mig inför människorna ska bli förnekad inför Guds änglar. ");
INSERT INTO swessb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Och var och en som kommer att säga ett ord mot Människosonen, det ska förlåtas honom. Men för den som kommer att häda mot den heliga Anden ska det inte förlåtas. ");
INSERT INTO swessb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Men när man för in er inför synagogorna och myndigheterna och auktoriteterna, bekymra er inte hur eller med vad ni ska försvara er eller vad ni ska säga. ");
INSERT INTO swessb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","För den heliga Anden ska lära er i den stunden vad man måste säga.” ");
INSERT INTO swessb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Men någon ur skaran sade till honom: ”Lärare, säg till min bror att dela arvet med mig.” ");
INSERT INTO swessb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Men han sade till honom: ”Människa, vem har satt mig till domare eller skiljeman över er?” ");
INSERT INTO swessb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Och han sade till dem: ”Se upp och vakta er för all girighet. För ens liv finns inte i att ha överflöd av det han har.” ");
INSERT INTO swessb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Och han talade en liknelse till dem och sade: ”En rik människas mark hade burit god gröda. ");
INSERT INTO swessb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Och han funderade inom sig och sade: Vad ska jag göra? För jag har ingenstans att samla mina grödor. ");
INSERT INTO swessb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Och han sade: Detta ska jag göra: Jag ska ta ner mina förråd och bygga större och samla där allt vetet och mitt goda, ");
INSERT INTO swessb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","och säga till min själ: Själ, du har mycket gott liggande för många år. Vila, ät, drick, fröjda dig. ");
INSERT INTO swessb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Men Gud sade till honom: Tanklöse, denna natt ska man avkräva din själ från dig. Och det du berett, vems blir det? ");
INSERT INTO swessb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Så är den som samlar ihop åt sig själv och inte är rik inför Gud.” ");
INSERT INTO swessb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Och han sade till sina lärjungar: ”Därför säger jag er: Bekymra er inte för själen, vad ni ska äta, eller för kroppen, vad ni ska iklä er. ");
INSERT INTO swessb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","För själen är mer än födan och kroppen mer än klädseln. ");
INSERT INTO swessb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Beakta korparna, att de inte sår eller skördar. De har inte kammare eller förråd, och Gud ger dem näring. Hur mycket mer viktiga är ni än fåglarna? ");
INSERT INTO swessb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Men vem av er kan genom att bekymra sig lägga till sin ålder en aln? ");
INSERT INTO swessb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Om ni nu inte ens kan det minsta, varför bekymrar ni er för det övriga? ");
INSERT INTO swessb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Beakta liljorna, hur de växer. De jobbar inte eller spinner. Men jag säger er: inte ens Salomo i all sin härlighet klädde sig som en av dessa. ");
INSERT INTO swessb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Men om Gud så ekiperar gräset på åkern, som finns idag och imorgon kastas i en ugn, hur mycket mer er, klentrogna? ");
INSERT INTO swessb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Och ni, sök inte vad ni ska äta och vad ni ska dricka, och var inte spända. ");
INSERT INTO swessb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","För allt detta söker världens folkslag efter, men er Far vet att ni behöver detta. ");
INSERT INTO swessb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nej, sök hans rike, och detta ska tillföras er. ");
INSERT INTO swessb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Frukta inte, lilla hjord, för er Far har behagat ge er riket. ");
INSERT INTO swessb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sälj det som är ert och ge allmosa. Gör er börsar som inte föråldras, en outtömlig skatt i himlarna där tjuv inte närmar sig eller mal fördärvar. ");
INSERT INTO swessb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","För där er skatt är, där kommer också ert hjärta att vara. ");
INSERT INTO swessb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Era höfter ska vara omgjordade och lam­porna brinnande, ");
INSERT INTO swessb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","och ni lika människor som väntar på sin herre när han ska bryta upp från bröllopsfesten för att, när han kommer och bultar, direkt öppna för honom. ");
INSERT INTO swessb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Saliga dessa fasttjänare som Herren ska komma och finna vakna. Amen, jag säger er att han ska omgjorda sig och lägga dem till bords och komma förbi och betjäna dem. ");
INSERT INTO swessb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Även om det är vid andra, även om vid tredje nattväkten han kommer och finner dem så, saliga är dessa. ");
INSERT INTO swessb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Men det förstår ni att om hushärskaren visste vilken stund tjuven kommer hade han inte låtit sitt hus bli inbrutet. ");
INSERT INTO swessb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Också ni ska vara beredda, för vid en stund ni inte tänker er kommer Människosonen.” ");
INSERT INTO swessb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Men Petrus sade: ”Herre, är det till oss du talar denna liknelse eller också till alla?” ");
INSERT INTO swessb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Och Herren sade: ”Vem är då den trogne förvaltaren, den kloke som Herren ska sätta över sitt tjänstefolk för att i rätt tid ge sädesransonen? ");
INSERT INTO swessb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Salig den fasttjänaren som hans herre ska komma och finna göra så. ");
INSERT INTO swessb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sannerligen, jag säger er att över allt som är hans ska han sätta honom. ");
INSERT INTO swessb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Men om den fasttjänaren säger i sitt hjärta: Min herre dröjer med att komma, och han börjar slå gossarna och tjänsteflickorna och både äta och dricka och berusa sig, ");
INSERT INTO swessb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ska den fasttjänarens herre komma en dag som han inte väntar sig och en stund som han inte vet om och hugga honom itu och sätta hans del med de otroende. ");
INSERT INTO swessb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Men den fasttjänaren som förstår sin herres vilja och inte förbereder eller gör något för hans vilja, ska pryglas många gånger. ");
INSERT INTO swessb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Men den som inte förstår men har gjort något som är värt slag, ska pryglas få gånger. Och var och en åt vilken det getts mycket, från honom ska mycket sökas, och den åt vilken man lagt över mycket, från honom ska man begära ännu mer. ");
INSERT INTO swessb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","En eld har jag kommit för att sätta på jorden, och vad jag vill att den redan var tänd! ");
INSERT INTO swessb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Men ett dop har jag att döpas med, och hur ansatt jag är tills det är fullbordat! ");
INSERT INTO swessb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tänker ni er att det är fred jag kommit hit för att ge på jorden? Nej, säger jag er, utan uppdelning. ");
INSERT INTO swessb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","För från nu ska fem i ett hus vara uppdelade, tre mot två och två mot tre. ");
INSERT INTO swessb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","De ska delas upp far mot son och son mot far, mor mot dottern och dotter mot modern, svärmor mot sin sons brud och brud mot svärmodern.” ");
INSERT INTO swessb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Och han sade också till skarorna: ”När ni ser molnet gå upp i väster säger ni direkt att ett regnväder kommer, och det blir så. ");
INSERT INTO swessb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Och när sunnan blåser säger ni att det blir hetta, och det blir det. ");
INSERT INTO swessb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hycklare, jordens och himlens ansikte förstår ni att pröva. Men denna tid, hur förstår ni inte att pröva den? ");
INSERT INTO swessb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Och varför dömer ni inte det rätta också av er själva? ");
INSERT INTO swessb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","För när du beger dig med din motpart till en ledare, ge aktivitet på vägen att bli kvitt med honom. Annars drar han dig inför domaren, och domaren ska överlämna dig till utföraren och utföraren kasta dig i fängelse. ");
INSERT INTO swessb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jag säger dig: Du kommer aldrig ut därifrån förrän du betalat även den sista leptonen.” ");
INSERT INTO swessb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Men några var där vid samma tid och berättade för honom om galileerna vilkas blod Pilatus hade blandat med deras offer. ");
INSERT INTO swessb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Och han svarade och sade till dem: ”Tänker ni er att dessa galileer var mer syndare än alla de andra galileerna, eftersom de fått lida detta? ");
INSERT INTO swessb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nej, säger jag er. Men om ni inte ändrar sinne ska ni alla likaså gå förlorade. ");
INSERT INTO swessb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eller dessa arton på vilka tornet i Siloam föll och dödade dem, tänker ni er att de var mer skyldiga än alla de andra människorna som bor i Jerusalem? ");
INSERT INTO swessb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nej, säger jag er. Men om ni inte ändrar sinne ska ni alla på samma sätt gå förlorade.” ");
INSERT INTO swessb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Och han talade denna liknelse: ”Någon hade ett fikonträd planterat i sin vingård. Och han kom och sökte frukt på det, och fann inte. ");
INSERT INTO swessb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Och han sade till vingårdsarbetaren: Se, det är tre år från det att jag kommer och söker frukt på detta fikonträd och inte finner. Hugg nu bort det! Varför ska det dessutom blockera jorden? ");
INSERT INTO swessb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Men han svarar och säger till honom: Herre, låt det stå även detta år, tills jag grävt runt det och kastat på gödsel, ");
INSERT INTO swessb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","om så det gör frukt till det kommande. Men om inte, ska du hugga bort det.” ");
INSERT INTO swessb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Och han undervisade i en av synagogorna på sabbaten, ");
INSERT INTO swessb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","och se: en ­kvinna som hade en ande av sjukdom i arton år, och hon var sammanböjd och kunde inte räta sig upp helt och hållet. ");
INSERT INTO swessb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Och när Jesus såg henne, ropade han henne till sig och sade till henne: ”Kvinna, du är frigiven från din sjukdom.” ");
INSERT INTO swessb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Och han lade på henne händerna, och genast blev hon åter upprätad och ärade Gud. ");
INSERT INTO swessb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Men synagogföreståndaren svarade, indignerad att det var på sabbaten Jesus botade, och sade till skaran att: ”Sex dagar finns på vilka man ska arbeta. På dem kommer ni alltså och blir botade, och inte på sabbatsdagen.” ");
INSERT INTO swessb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Men Herren svarade honom och sade: ”Hycklare! Löser inte varenda en av er på sabbaten sin oxe eller åsna från krubban och leder bort och vattnar? ");
INSERT INTO swessb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Men denna som är Abrahams dotter, som Satan har bundit – se: arton år! – skulle inte hon bli löst från denna boja på sabbatsdagen?” ");
INSERT INTO swessb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Och när han sade detta skämdes alla hans motståndare, och hela skaran gladde sig över allt det härliga som kom genom honom. ");
INSERT INTO swessb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Han sade nu: ”Vad är Guds rike likt? Och vid vad ska jag likna det? ");
INSERT INTO swessb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Det är likt ett senapskorn, som en människa tog och satte i sin trädgård. Och det växte och blev till ett träd, och himlens fåglar satte bo i dess grenar.” ");
INSERT INTO swessb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Och åter sade han: ”Vid vad ska jag likna Guds rike? ");
INSERT INTO swessb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Det är likt en surdeg som en kvinna tog och dolde in i tre sea mjöl tills det hela blev syrat.” ");
INSERT INTO swessb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Och han vandrade genom städer och byar medan han undervisade och gjorde resväg till Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Och någon sade till honom: ”Herre, om det är få som blir frälsta?” Men han sade till dem: ");
INSERT INTO swessb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","”Kämpa för att komma in genom den trånga dörren. För många, säger jag er, ska söka komma in och inte mäkta. ");
INSERT INTO swessb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Från det att hushärskaren har rest sig och stängt dörren och ni börjar stå ­utanför och bulta på dörren och säga: Herre, öppna för oss, då ska han svara och säga till er: Jag känner er inte. Varifrån är ni? ");
INSERT INTO swessb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Då kommer ni att börja säga: Vi åt inför dig och drack, och på våra gator undervisade du. ");
INSERT INTO swessb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Och han ska tala och säga till er: Jag känner er inte. Varifrån är ni? Avlägsna er från mig, alla orättens utförare. ");
INSERT INTO swessb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Där blir gråten och tandagnisslet, när ni ser Abraham och Isak och Jakob och alla profeterna i Guds rike, men ni kastas ut utanför. ");
INSERT INTO swessb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Och man ska komma från öster och väster och från norr och söder och ligga till bords i Guds rike. ");
INSERT INTO swessb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Och se: det finns sista som ska bli första, och det finns första som ska bli sista.” ");
INSERT INTO swessb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I samma stund kom det fram några fariseer och sade till honom: ”Gå ut och vandra härifrån. För Herodes vill döda dig.” ");
INSERT INTO swessb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Och han sade till dem: ”Gå och säg till den räven: Se, jag driver ut demoner och fullbordar helanden idag och imorgon, och den tredje dagen fullkomnas jag. ");
INSERT INTO swessb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Men jag måste idag och imorgon och i övermorgon vandra, för det är inte godtagbart att en profet förgörs utanför Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, Jerusalem, som dödar profeterna och kaststenar dem som är sända till dig! Hur många gånger har jag velat församla dina barn, på samma sätt som en höna sina kycklingar under vingarna? Och ni ville inte. ");
INSERT INTO swessb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Se: nu lämnas åt er ert hus. Och jag säger er: Ni kommer aldrig att se mig förrän det ska komma när ni säger: Välsignad är han som kommer i Herrens namn.” ");
INSERT INTO swessb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Och det hände sig, under det att han gick till huset hos en av de ledande fariseerna på en sabbat för att äta bröd, att de vaktade noga på honom. ");
INSERT INTO swessb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Och se: en man som var vätskesvullen fanns framför honom. ");
INSERT INTO swessb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Och Jesus svarade och talade till de laglärda och fariseerna och sade: ”Är det tillåtet på sabbaten att bota eller inte?” ");
INSERT INTO swessb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Men de höll sig stilla. Och han tog tag och helade honom och skickade iväg. ");
INSERT INTO swessb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Och till dem sade han: ”Hos vem av er kommer en son eller oxe att falla i en brunn och han drar inte direkt upp den på sabbatsdagen?” ");
INSERT INTO swessb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Och de mäktade inte att svara tillbaka på detta. ");
INSERT INTO swessb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Och han talade till de inbjudna en liknelse, när han tog fasta på hur de utvalde förstaplatserna, och sade till dem: ");
INSERT INTO swessb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","”När du blir bjuden av någon till bröllopsfest, luta dig inte till bords på förstaplatsen. Annars kanske en mer uppskattad än du är inbjuden av honom, ");
INSERT INTO swessb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","och då kommer den som bjudit dig och honom och ska säga till dig: Ge denne platsen, och då ska du med skam börja hålla den sista platsen. ");
INSERT INTO swessb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nej, när du blivit bjuden, gå och ligg till bords på den sista platsen så att, när den som bjudit dig kommer, han ska säga till dig: Min vän, gå fram högre upp. Då blir det för dig en ära inför alla som ligger till bords med dig. ");
INSERT INTO swessb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","För var och en som upphöjer sig själv ska bli ödmjukad, och den som ödmjukar sig själv ska bli upphöjd.” ");
INSERT INTO swessb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Och han sade också till den som hade ­bjudit honom: ”När du gör en lunch eller måltid, ropa inte på dina vänner eller dina syskon eller dina släktingar eller rika grannar. Annars kanske också de bjuder dig tillbaka och det blir din belöning. ");
INSERT INTO swessb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nej, när du gör en mottagning, bjud fattiga, invalidiserade, lama, blinda. ");
INSERT INTO swessb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Och salig blir du, eftersom de inte har något att återgälda dig med. För det ska återgäldas dig vid de rättfärdigas uppståndelse.” ");
INSERT INTO swessb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Och när en av de som låg till bords med honom hörde detta, sade han till honom: ”Salig den som ska äta bröd i Guds rike!” ");
INSERT INTO swessb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Men han sade till honom: ”En man gjorde en stor måltid och bjöd många. ");
INSERT INTO swessb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Och han sände ut sin fasttjänare vid stunden för måltiden för att säga till de inbjudna: Kom, för det är redan förberett. ");
INSERT INTO swessb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Och de började en efter en alla undanbe sig. Den förste sade till honom: Jag har köpt en åker och har nödtvång att gå ut och se den. Jag tillfrågar dig: håll mig undanbedd. ");
INSERT INTO swessb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Och en annan sade: Jag har köpt fem par oxar och går för att pröva dem. Jag tillfrågar dig: håll mig undanbedd. ");
INSERT INTO swessb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Och en annan sade: Jag har gift mig med en kvinna och därför kan jag inte komma. ");
INSERT INTO swessb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Och fasttjänaren kom fram och berättade för sin herre om detta. Då vredgades hushärskaren och sade till sin fasttjänare: Gå fort ut till stadens gator och gränder och för in de fattiga och invalidiserade och blinda och lama hit. ");
INSERT INTO swessb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Och fasttjänaren sade: Herre, det har skett som du beordrade, och ännu finns det plats. ");
INSERT INTO swessb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Och herren sade till fasttjänaren: Gå ut till vägarna och stängslen och nödga folk att komma in, så att mitt hus blir fullt. ");
INSERT INTO swessb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","För jag säger er att ingen av de männen som var bjudna ska smaka av min måltid.” ");
INSERT INTO swessb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Och med honom vandrade stora skaror, och han vände sig och sade till dem: ");
INSERT INTO swessb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","”Om någon kommer till mig och inte hatar sin far och mor och hustru och barnen och bröderna och systrarna och dessutom även sin egen själ, kan han inte vara min lärjunge. ");
INSERT INTO swessb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Den som inte bär sitt kors och kommer efter mig kan inte vara min lärjunge. ");
INSERT INTO swessb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","För vem av er som vill bygga ett torn sätter sig inte först och räknar ut kostnaden, om han har till färdigställandet? ");
INSERT INTO swessb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Så att inte, när han har lagt en grund och inte mäktar att fullborda, alla som skådar börjar förlöjliga honom ");
INSERT INTO swessb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","och säga att: Den där människan började bygga och mäktade inte fullborda. ");
INSERT INTO swessb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Eller vilken kung som går för att möta en annan kung i krig sätter sig inte först och ska planera om han är mäktig att med tiotusen möta den som med tjugotusen kommer emot honom? ");
INSERT INTO swessb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Och annars, me­dan han ännu är fjärran, sänder han en delegation och frågar om det som leder till fred. ");
INSERT INTO swessb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Så kan alltså ingen av er som inte tar farväl av allt som är hans vara min lärjunge. ");
INSERT INTO swessb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Saltet är alltså bra. Men om även saltet blir smaklöst, med vad ska det saltas? ");
INSERT INTO swessb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Varken för jord eller för gödsel är det välägnat. Ut kastar man det. Den som har öron att höra med ska höra.” ");
INSERT INTO swessb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Men till honom närmade sig alla tullindrivarna och syn­darna för att höra honom. ");
INSERT INTO swessb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Och då muttrade både fariseerna och de skriftlärda och sade att: ”Den där välkomnar syndare och äter med dem.” ");
INSERT INTO swessb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Men han talade till dem denna ­liknelse och sade: ");
INSERT INTO swessb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","”Vilken människa av er som har hundra får och förlorar ett av dem lämnar inte de nittionio i ödemarken och går efter det förlorade tills han finner det? ");
INSERT INTO swessb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Och när han funnit det, lägger han det över sina axlar glad, ");
INSERT INTO swessb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","och kommen till huset sammankallar han vännerna och grannarna och säger till dem: Gläd er med mig! För jag fann mitt får som var förlorat. ");
INSERT INTO swessb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jag säger er att: Så blir det glädje i himlen över en enda syndare som ändrar sinne, mer än över nittionio rättfärdiga som inte har behov av sinnesändring. ");
INSERT INTO swessb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Eller vilken kvinna som har tio drakmer, om hon förlorar en drakma, tänder inte en lampa och sopar huset och söker omsorgsfullt tills hon finner? ");
INSERT INTO swessb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Och när hon funnit, sammankallar hon väninnorna och grannkvinnor och säger: Gläd er med mig! För jag fann drakman som jag förlorade. ");
INSERT INTO swessb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Så, säger jag er, blir det glädje inför Guds änglar över en enda syndare som ändrar sinne.” ");
INSERT INTO swessb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Och han sade: ”En man hade två söner. ");
INSERT INTO swessb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Och den yngre av dem sade till fadern: Far, ge mig den del som tillfaller mig av förmögenheten. Och han för­delade åt dem tillgångarna. ");
INSERT INTO swessb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Och efter inte så många dagar samlade den yngre sonen ihop allt och reste iväg till en trakt långt bort, och där förskingrade han sin förmögenhet och levde omåttligt. ");
INSERT INTO swessb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Men när han hade spenderat allt, kom en stark svält över den trakten och han började lida brist. ");
INSERT INTO swessb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Och han gick och anslöt sig till en av medborgarna i den trakten, och han skickade honom till sina fält att valla svin. ");
INSERT INTO swessb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Och han åtrådde att mätta sig av fröskidorna som svinen åt, och ingen gav honom. ");
INSERT INTO swessb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Men när han kom till sig själv, sade han: Hur många anställda hos min far har överflöd på bröd, men jag går under här av svält! ");
INSERT INTO swessb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jag ska stå upp och gå till min far och säga till honom: Far, jag har syndat mot himlen och inför dig. ");
INSERT INTO swessb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jag är inte längre värd att kallas din son. Gör mig som en av dina anställda. ");
INSERT INTO swessb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Och han stod upp och gick till sin far. Men när han ännu var långt borta, såg honom hans far och kände innerligt. Och han sprang och föll på hans hals och kysste ner honom. ");
INSERT INTO swessb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Men sonen sade till honom: Far, jag har syndat mot himlen och inför dig. Jag är inte längre värd att kal­las din son. ");
INSERT INTO swessb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Men fadern sade till sina fasttjänare: Fort, bär ut den främsta dräkten och iklä honom, och sätt en fingerring på hans hand och sandaler på fötterna. ");
INSERT INTO swessb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Och för ut den gödda kalven, slaktoffra och vi ska äta och fröjda oss. ");
INSERT INTO swessb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","För denne min son var död och levde igen, han var förlorad och blev funnen. Och de började fröjda sig. ");
INSERT INTO swessb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Men hans äldre son var på fältet. Och när han kom och närmade sig huset, hörde han musik och danser. ");
INSERT INTO swessb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Och han kallade till sig en av gossarna och efterhörde vad detta kunde vara. ");
INSERT INTO swessb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Och han sade till honom att: Din bror har kommit, och din far har slaktoffrat den gödda kalven för att han erhållit honom frisk. ");
INSERT INTO swessb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Men han vredgades och ville inte gå in. Och hans far kom ut och vädjade till honom, ");
INSERT INTO swessb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","men han svarade och sade till sin far: Se, så många år fasttjänar jag dig och har aldrig förbigått ditt bud. Och mig har du aldrig gett en killing så att jag med mina vänner kan fröjda mig. ");
INSERT INTO swessb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Men när denne din son som ätit upp dina tillgångar med skökor kom, slaktoffrade du för honom den gödda kalven! ");
INSERT INTO swessb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Men han sade till honom: Barn, du är alltid med mig, och allt mitt är ditt. ");
INSERT INTO swessb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Men att fröjda oss och vara glada var nödvändigt, för denne din bror var död och levde igen, och förlorad och blev återfunnen.” ");
INSERT INTO swessb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Och han sade också till lärjungarna: ”Det fanns en rik man som hade en förvaltare, och denne blev beskylld inför honom som förskingrare av det som var hans. ");
INSERT INTO swessb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Och han ropade på honom och sade till honom: Vad är detta jag hör om dig? Avge räkenskapen för din förvaltning. För du kan inte förvalta mer. ");
INSERT INTO swessb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Men förvaltaren sade inom sig: Vad ska jag göra, eftersom min herre tar förvaltningen ifrån mig? Gräva mäktar jag inte. Tigga skäms jag för. ");
INSERT INTO swessb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nu har jag förstått vad jag ska göra så att man, när jag flyttas från förvaltningen, välkomnar mig i sina hus. ");
INSERT INTO swessb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Och han kallade till sig varenda en av sin herres skuldsatta och sade till den förste: Hur mycket är du skyldig min herre? ");
INSERT INTO swessb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Och han sade: Hundra bat olja. Och han sade till honom: Motta dina texter och sätt dig fort och skriv femtio. ");
INSERT INTO swessb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sedan sade han till en annan: Och du, hur mycket är du skyldig? Och han sade: Hundra korer vete. Han säger till honom: Motta dina texter och skriv åttio. ");
INSERT INTO swessb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Och herren lovordade orättens förvaltare för att han gjort det klokt. För denna eons söner är klokare än ljusets söner mot sitt eget släkte. ");
INSERT INTO swessb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Och jag säger er: Gör er vänner av orättens mammon, så att de när den tar slut välkomnar er i de eoniska boningarna. ");
INSERT INTO swessb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Den som är trogen i det minsta är trogen också i stort, och den som är orättfärdig i det minsta är orättfärdig också i stort. ");
INSERT INTO swessb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Om ni nu inte har varit trogna med den orättfärdiga mammon, vem ska anförtro er den sannfärdiga? ");
INSERT INTO swessb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Och om ni inte varit trogna med det som är en annans, vem ska ge er det som är ert? ");
INSERT INTO swessb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ingen hustjänare kan fasttjäna två herrar. För antingen kommer han att hata den ene och älska den andre, eller hålla tag i en och ringakta den andre. Ni kan inte fasttjäna Gud och mammon.” ");
INSERT INTO swessb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Men allt detta hörde fariseerna som var pengakära, och de fnös åt ­honom. ");
INSERT INTO swessb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Och han sade till dem: ”Ni är de som rättfärdigförklarar sig själva inför människorna, men Gud känner era hjärtan. För det som bland männi­skor är högt är en skändlighet inför Gud. ");
INSERT INTO swessb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lagen och profeterna var fram till Johannes. Sedan dess evangeliseras Guds rike, och var och en tvingas in i det. ");
INSERT INTO swessb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Men det är lättare att himlen och jorden förgår än att det från lagen faller en enda hake. ");
INSERT INTO swessb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Var och en som förskjuter sin hustru och gifter sig med en annan begår äktenskapsbrott. Och den som gifter sig med en kvinna förskjuten från en man begår äktenskapsbrott. ");
INSERT INTO swessb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Men det fanns en man som var rik, och han var iklädd purpur och fint linne och fröjdade sig varje dag glansfullt. ");
INSERT INTO swessb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Men en fattig vid namn Lasarus var lagd vid hans porthus, och han var varig ");
INSERT INTO swessb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","och åtrådde att mätta sig av det som föll från den rikes bord. Men till och med hundarna kom och slickade på hans variga sår. ");
INSERT INTO swessb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Och det hände sig att den fattige dog, och han fördes bort av änglarna till Abrahams famn. Men sedan dog även den rike och blev ­begravd. ");
INSERT INTO swessb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Och i Hades lyfte han sina ögon, där han var i plågor, och ser Abraham långt ifrån och Lasarus i hans famn. ");
INSERT INTO swessb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Och han ropade och sade: Fader Abraham! Förbarma dig över mig och skicka Lasarus att doppa sin fingertopp i vatten och svalka min tunga. För jag våndas i denna låga. ");
INSERT INTO swessb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Men Abraham sade: Barn, kom ihåg att du erhöll ditt goda under ditt liv, och Lasarus likaså det onda. Men nu blir han här tröstad, och du våndas. ");
INSERT INTO swessb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Och i allt detta är mellan oss och er ett stort gap stärkt, för att de som vill gå över härifrån till er inte ska kunna det, inte heller därifrån komma över till oss. ");
INSERT INTO swessb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Men han sade: Då tillfrågar jag dig, fader, att du skickar honom till min fars hus, ");
INSERT INTO swessb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","för jag har fem bröder, för att betyga för dem så att inte också de kommer till denna plågans plats. ");
INSERT INTO swessb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Men Abraham säger: De har Mose och profeterna. De ska lyssna till dem. ");
INSERT INTO swessb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Men han sade: Nej, fader Abraham, men om någon från de döda går till dem kommer de att ändra sinne. ");
INSERT INTO swessb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Men han sade till honom: Om de inte lyssnar till Mose och profeterna, kommer de inte ens om någon från de döda uppstår att bli övertygade.” ");
INSERT INTO swessb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Och han sade till sina lärjungar: ”Det är otänkbart att skandalerna inte skulle komma. Men ve den genom vilken de kommer! ");
INSERT INTO swessb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Det är mer gynnsamt för honom om en kvarnsten fattar om hans hals och han slängs i havet, än att han skandaliserar en av dessa små. ");
INSERT INTO swessb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Akta er! Om din broder syndar, näps honom. Och om han ändrar sinne, förlåt honom. ");
INSERT INTO swessb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Även om han sju gånger om dagen syndar mot dig, och sju gånger vänder om till dig och säger: Jag ändrar sinne, ska du förlåta honom.” ");
INSERT INTO swessb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Och apostlarna sade till Herren: ”Tillför oss tro!” ");
INSERT INTO swessb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Men Herren sade: ”Om ni har tro som ett senapskorn, skulle ni säga till detta mullbärsträd: Var upprotad och planterad i havet! Och det skulle hörsamma er. ");
INSERT INTO swessb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Men vem av er som har en fasttjänare som plöjer eller är herde och kommer in från åkern, kommer att säga till honom: Kom direkt förbi och lägg dig till bords? ");
INSERT INTO swessb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nej, kommer han inte att säga till honom: Förbered vad jag ska äta till måltid, och omgjorda dig och betjäna mig medan jag äter och dricker. Och efter detta ska du själv äta och dricka. ");
INSERT INTO swessb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Inte har han tack till fasttjänaren för att han gjort det som var förordnat? ");
INSERT INTO swessb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Så också ni: när ni har gjort allt som är förordnat för er, säg att: Vi är odugliga fasttjänare. Det vi är skyldiga att göra har vi gjort.” ");
INSERT INTO swessb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Och det hände sig, under det att han vandrade till Jerusalem, att han gick genom mitten av Samarien och Galileen. ");
INSERT INTO swessb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Och när han gick in i en by, mötte honom tio spetälska män som stannade fjärran ifrån, ");
INSERT INTO swessb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","och de lyfte rösten och sade: ”Jesus, Mästare! Förbarma dig över oss!” ");
INSERT INTO swessb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Och han såg och sade till dem: ”Gå och visa er för prästerna.” Och det hände sig, under det att de begav sig, att de blev renade. ");
INSERT INTO swessb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Men en av dem, när han såg att han var helad, vände tillbaka med väldig röst och ärade Gud, ");
INSERT INTO swessb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","och han föll ner på sitt ansikte vid hans fötter och tackade honom. Och han var samarier. ");
INSERT INTO swessb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Men Jesus svarade och sade: ”Blev inte de tio renade? Men var är de nio? ");
INSERT INTO swessb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Fanns det inga som vände tillbaka för att ge ära åt Gud utom denna utbörding?” ");
INSERT INTO swessb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Och han sade till honom: ”Stå upp och gå. Din tro har frälst dig.” ");
INSERT INTO swessb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Men tillfrågad av fariseerna när Guds rike kommer, svarade han dem och sade: ”Guds rike kommer inte med noggrant vaktande. ");
INSERT INTO swessb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Inte heller ska man säga: Se, här! eller: Där! För se: Guds rike är inom er.” ");
INSERT INTO swessb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Och han sade till lärjungarna: ”Det ska komma dagar då ni ska åtrå att se en enda av Människosonens dagar, och ni kommer inte att se det. ");
INSERT INTO swessb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Och man ska säga till er: Se, där! eller: Se, här! Gå inte iväg och jaga inte efter. ");
INSERT INTO swessb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","För såsom blixten blixtrar från under himlen till under himlen och skiner, så ska Människosonen vara på sin dag. ");
INSERT INTO swessb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Men först måste han lida mycket och bli förkastad av detta släkte. ");
INSERT INTO swessb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Och så som det blev under Noas dagar, så ska det vara också under Människosonens dagar. ");
INSERT INTO swessb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","De åt, drack, gifte sig, blev bortgifta ända till dagen Noa gick in i arken, och då kom störtfloden och förgjorde alla. ");
INSERT INTO swessb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Likaså som det blev under Lots dagar: de åt, drack, köpte, sålde, planterade, byggde, ");
INSERT INTO swessb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","men dagen Lot gick ut ur Sodom regnade eld och svavel från himlen och förgjorde alla. ");
INSERT INTO swessb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","På samma sätt ska det bli den dag Människosonen uppenbaras. ");
INSERT INTO swessb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","På den dagen ska den som kommer att vara på taket och ha sina redskap i huset inte gå ner och ta dem. Och den som är på åkern ska likaså inte vända om bakåt. ");
INSERT INTO swessb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Minns Lots hustru! ");
INSERT INTO swessb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Den som söker förvärva sin själ ska förlora den, men den som förlorar den ska bevara den vid liv. ");
INSERT INTO swessb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jag säger er: Den natten ska det vara två på en bädd. Den ene ska tas med och den andre lämnas. ");
INSERT INTO swessb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Det ska vara två som mal tillsammans. Den ena ska tas med, men den andra lämnas.” ");
INSERT INTO swessb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Och de svarar och säger till honom: ”Var, Herre?” Och han sade till dem: ”Där kroppen är, där ska också örnarna församlas.” ");
INSERT INTO swessb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Och han talade en liknelse till dem för att de måste alltid bedja och inte tappa modet, ");
INSERT INTO swessb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","och sade: ”Det fanns en domare i en stad, och han fruktade inte Gud och hade inte respekt för någon människa. ");
INSERT INTO swessb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Och det fanns en änka i den staden, och hon höll på och kom till honom och sade: Skipa rätt för mig från min motpart! ");
INSERT INTO swessb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Och han ville inte för en tid, men efter detta sade han inom sig: Även om jag inte fruktar Gud eller har respekt för människor, ");
INSERT INTO swessb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ska jag just för att denna änka skaffar mig besvär skipa rätt för henne, så att hon inte till slut kommer och slår mig blå under ögat.” ");
INSERT INTO swessb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Och Herren sade: ”Hör vad orättens domare säger. ");
INSERT INTO swessb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Och ska Gud då inte utföra rättskipningen för sina utvalda, som ropar till honom dag och natt och han är tålmodig med dem? ");
INSERT INTO swessb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jag säger er att han ska utföra rättskipningen för dem med hast. Men ska Människosonen, när han kommer då finna den tron på jorden?” ");
INSERT INTO swessb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Och han talade också till några, som förtröstade på sig själva att de är rättfärdiga och föraktade de övriga, denna liknelse: ");
INSERT INTO swessb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","”Två människor gick upp till templet för att bedja, den ene farisé och den andre tullindrivare. ");
INSERT INTO swessb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisén ställde sig och bad detta för sig själv: Gud, jag tackar dig att jag inte är såsom de övriga bland människorna: rof­fare, orättfärdiga, ­äktenskapsbrytare eller också som denne tullindrivare. ");
INSERT INTO swessb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jag fastar två gånger i veckan, jag ger tionde av allt jag förvärvar. ");
INSERT INTO swessb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Men tullindrivaren stod långt ifrån och ville inte ens lyfta ögonen mot himlen, utan slog mot sin bröstkorg och sade: Gud, var försonlig mot mig, syndaren. ");
INSERT INTO swessb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jag säger er: Denne gick ner rättfärdigförklarad till sitt hus, snarare än den andre. För var och en som upphöjer sig ska bli ödmjukad, men den som ödmjukar sig ska bli upphöjd.” ");
INSERT INTO swessb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Och man bar fram till honom också spädbarnen för att han skulle röra vid dem. Men när lärjungarna såg, näpste de dem. ");
INSERT INTO swessb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Men Jesus kallade dem till sig och sade: ”Låt barnen ­komma till mig och hindra dem inte. För sådanas är Guds rike. ");
INSERT INTO swessb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amen, jag säger er: Den som inte välkomnar Guds rike som ett barn kommer aldrig in i det.” ");
INSERT INTO swessb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Och då frågade honom en ledare och sade: ”Gode Lärare! Vad ska jag ha gjort för att ärva eoniskt liv?” ");
INSERT INTO swessb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Och Jesus sade till honom: ”Varför kallar du mig god? Ingen är god utom en: Gud. ");
INSERT INTO swessb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Buden kan du: Du ska inte begå äktenskapsbrott. Du ska inte mörda. Du ska inte stjäla. Du ska inte vittna falskt. Hedra din far och mor.” ");
INSERT INTO swessb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Men han sade: ”Allt detta har jag iakttagit sedan ungdomen.” ");
INSERT INTO swessb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Och när Jesus hörde det, sade han till honom: ”Ännu återstår ett för dig. Allt vad du har, sälj det och ge ut till fattiga, och du kommer att ha en skatt i himlarna. Och kom, följ mig.” ");
INSERT INTO swessb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Men när han hörde detta blev han djupt bedrövad, för han var mycket rik. ");
INSERT INTO swessb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Och Jesus såg honom bli djupt bedrövad och sade: ”Hur svårt att de som har pengarna går in i Guds rike! ");
INSERT INTO swessb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","För det är ­lättare att en ­kamel kommer in genom ett nåls­öga än att en rik kommer in i Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Men då sade de som hörde det: ”Och vem kan då bli frälst?” ");
INSERT INTO swessb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Och han sade: ”Det som är omöjligt för människor är möjligt för Gud.” ");
INSERT INTO swessb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Och Petrus sade: ”Se, vi har lämnat vårt eget och följt dig.” ");
INSERT INTO swessb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Och han sade till dem: ”Amen, jag säger er att ingen finns som har lämnat hus eller hustru eller syskon eller föräldrar eller barn för Guds rike ");
INSERT INTO swessb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","som inte erhåller mångdubbelt i denna tid, och i den kommande eonen eoniskt liv.” ");
INSERT INTO swessb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Och han tog med de tolv och sade till dem: ”Se: vi går upp till Jerusa­lem. Och allt ska fullbordas som är skrivet genom profeterna om Människo­sonen. ");
INSERT INTO swessb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","För han ska utlämnas åt folkslagen och bli förlöjligad och skymfad och spottad på, ");
INSERT INTO swessb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","och de ska piska och döda honom. Och den tredje dagen ska han uppstå.” ");
INSERT INTO swessb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Och de förstod inget av detta, och detta ord var fördolt för dem och de insåg inte det som sades. ");
INSERT INTO swessb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Och det hände sig, vid det att han närmade sig Jeriko, att en blind satt vid vägen och tiggde. ");
INSERT INTO swessb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Och när han hörde att en skara passerar igenom efterhörde han vad detta kunde vara, ");
INSERT INTO swessb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","och man berättade för honom att Jesus nasarén går förbi. ");
INSERT INTO swessb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Och han ropade och sade: ”Jesus, Davids son, förbarma dig över mig!” ");
INSERT INTO swessb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Och de som gick före näpste honom att han skulle tiga, men han skrek mycket mer: ”Davids son, förbarma dig över mig!” ");
INSERT INTO swessb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Och då stannade Jesus och befallde att han skulle föras till honom. Och när han hade närmat sig, frågade han honom: ");
INSERT INTO swessb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","”Vad vill du jag ska göra för dig?” Och han sade: ”Herre, att jag får se igen!” ");
INSERT INTO swessb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Och Jesus sade till honom: ”Se igen! Din tro har frälst dig.” ");
INSERT INTO swessb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Och genast såg han igen, och han följde honom, ärande Gud. Och allt folket såg det och gav lov till Gud. ");
INSERT INTO swessb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Och han kom in och gick genom Jeriko. ");
INSERT INTO swessb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Och se: en man som vid namn kallades Sackeus, och han var övertullindrivare och själv rik. ");
INSERT INTO swessb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Och han sökte se Jesus, vem han är, och kunde inte för skarans skull, ­eftersom han till resningen var liten. ");
INSERT INTO swessb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Och han sprang före framför och gick upp på en sykomor för att se honom, eftersom han skulle gå genom den vägen. ");
INSERT INTO swessb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Och när han kom till platsen, såg Jesus upp och sade till honom: ”Sackeus, skynda dig och kom ner! För idag måste jag bli kvar i ditt hus.” ");
INSERT INTO swessb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Och han skyndade sig och kom ner och välkomnade ­ho­nom glad hos sig. ");
INSERT INTO swessb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Och när de såg det, muttrade alla och sade att det är hos en syndig man han gått in för att övernatta. ");
INSERT INTO swessb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Men Sackeus ställde sig och sade till Herren: ”Se: hälften av det som är mitt, Herre, ger jag till de fattiga. Och om jag utpressat något från någon, ger jag tillbaka fyrdubbelt.” ");
INSERT INTO swessb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Och Jesus sade till honom att: ”Idag har frälsning kommit till detta hus, för också han är en Abrahams son. ");
INSERT INTO swessb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","För Människosonen har kommit för att söka och frälsa det förlorade.” ");
INSERT INTO swessb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Och när de hörde detta tillade han och talade en liknelse, eftersom han var nära Jerusalem och de tänkte sig att genast kommer Guds rike att skönjas. ");
INSERT INTO swessb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Alltså sade han: ”En förnäm man reste till en trakt långt bort för att få sig kungamakt och återvända. ");
INSERT INTO swessb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Och han kalla­de tio av sina fasttjänare och gav dem tio minor och sade till dem: Gör affärer under det att jag kommer. ");
INSERT INTO swessb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Men hans medborgare hatade honom och sände ut en delegation efter honom och sade: Vi vill inte att denne ska regera över oss. ");
INSERT INTO swessb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Och det hände sig, vid det att han kom tillbaka och hade fått kungamakten, att han sade att det skulle ropas in till honom dessa fasttjänare åt vilka han hade gett silvret, för att han skulle veta vad de hade ­tjänat i affärerna. ");
INSERT INTO swessb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Och den förste kom fram och sade: Herre, din mina har frambringat tio minor till. ");
INSERT INTO swessb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Och han sade till honom: Bra, gode fasttjänare. Eftersom du var trogen i det minsta, ha auktoritet över tio städer. ");
INSERT INTO swessb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Och den andre kom och sade: Din mina, herre, har gjort fem minor. ");
INSERT INTO swessb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Och han sade även till denne: Och du, var över fem städer. ");
INSERT INTO swessb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Och en annan kom och sade: Herre, se din mina som jag haft undanlagd i en duk. ");
INSERT INTO swessb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","För jag fruktade dig, eftersom du är en strikt man: du tar ut det du inte satt in och skördar det du inte sått. ");
INSERT INTO swessb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Han säger till honom: Från din mun ska jag döma dig, elake fasttjänare. Du viss­te att jag är en strikt man som tar ut det jag inte satt in och skördar det jag inte sått? ");
INSERT INTO swessb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Och varför satte du inte mitt silver på en bank, och jag hade kommit och tagit ut det med ränta? ");
INSERT INTO swessb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Och till dem som stod bredvid sade han: Ta ifrån honom minan och ge till honom som har de tio minorna. ");
INSERT INTO swessb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Och de sade till honom: Herre, han har tio minor? – ");
INSERT INTO swessb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jag säger er att åt var och en som har ska det ges, men från den som inte har ska också det han har tas. ");
INSERT INTO swessb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Men dessa mina fiender som inte ville att jag skulle regera över dem, för hit och slakta dem inför mig.” ");
INSERT INTO swessb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Och när han hade sagt detta, vandrade han före och gick upp till Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Och det hände sig, när han närmade sig Betfage och Betania vid det berg som kallas Olivernas, att han sände ut två av lärjungarna ");
INSERT INTO swessb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","och sade: ”Bege er till byn mittemot. I den ska ni, när ni går in, finna ett föl bundet på vilket ingen av människor ännu har suttit. Och lossa det och led hit. ");
INSERT INTO swessb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Och om någon frågar er: Varför lossar ni?, ska ni säga så: Eftersom Herren har behov av det.” ");
INSERT INTO swessb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Och de utsända gick iväg och fann det så som han hade sagt dem. ");
INSERT INTO swessb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Och när de lossade fölet, sade dess herrar till dem: ”Varför lossar ni fölet?” ");
INSERT INTO swessb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Men de sade: ”Eftersom Herren har behov av det.” ");
INSERT INTO swessb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Och de ledde det till Jesus och slängde sina mantlar över fölet och satte upp Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Och medan han färdades fram, bredde man ut sina mantlar undertill på vägen. ");
INSERT INTO swessb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Och när han närmade sig, redan vid nedgången från Olivberget, började hela mängden av lärjungarna glada lovprisa Gud med väldig röst för alla kraftgärningar som de sett ");
INSERT INTO swessb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","och säga: ”Välsignad är han som kommer, kungen i Herrens namn! I himlen frid och ära i det högsta!” ");
INSERT INTO swessb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Och några av fariseerna från skaran sade till honom: ”Lärare, näps dina lärjungar.” ");
INSERT INTO swessb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Och han ­svarade och sade: ”Jag säger er: om dessa är tysta kommer stenarna att skrika.” ");
INSERT INTO swessb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Och när han närmade sig och såg staden, grät han över den ");
INSERT INTO swessb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","och sade att: ”Om du hade förstått på denna dag, också du, det som leder till frid! Men nu var det dolt för dina ögon. ");
INSERT INTO swessb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","För det ska komma dagar över dig, och dina fiender ska belägra med palissad mot dig och omringa dig och ansätta dig från alla håll. ");
INSERT INTO swessb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Och de ska golva dig och dina barn i dig och inte lämna sten på sten i dig, därför att du inte förstod tiden för din översyn.” ");
INSERT INTO swessb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Och han gick in i templet och började driva ut dem som sålde ");
INSERT INTO swessb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","och säga till dem: ”Det är skrivet: Och mitt hus ska vara ett ­bönens hus. Men ni har gjort det till enrövargrotta!” ");
INSERT INTO swessb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Och han undervisade varje dag i ­templet. Men översteprästerna och de skrift­lärda sökte förgöra honom, även de främsta bland folket. ");
INSERT INTO swessb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Och de fann inte vad de skulle göra, för folket hängde på honom allihop och lyssnade. ");
INSERT INTO swessb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Och det hände sig under en av dagarna, när han undervisade folket i templet och evangeliserade, att översteprästerna och de skriftlärda stod där med de äldste ");
INSERT INTO swessb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","och talade och sade till honom: ”Säg oss: Med vilken auktoritet gör du detta? Eller vem är det som gett dig denna auktoritet?” ");
INSERT INTO swessb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Men han svarade och sade till dem: ”Jag ska fråga er, också jag, en sak. Och säg mig: ");
INSERT INTO swessb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Johannes dop, var det från himlen eller från människor?” ");
INSERT INTO swessb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","De beräknade med varann och sade att: ”Om vi säger: Från himlen, kommer han att säga: Varför trodde ni inte på honom? ");
INSERT INTO swessb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Men om vi säger: Från människor, kommer folket allihop att stena ner oss. För det är övertygat att Johannes är en profet.” ");
INSERT INTO swessb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Och de svarade att de inte visste varifrån. ");
INSERT INTO swessb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Och Jesus sade till dem: ”Inte heller jag säger till er med vilken auktoritet jag gör detta.” ");
INSERT INTO swessb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Och han började tala till folket denna liknelse: ”En man ­planterade en vingård och arrenderade ut den till odlare och reste bort avsevärda tider. ");
INSERT INTO swessb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Och vid en bestämd tid sände han till odlarna en fasttjänare för att de skulle ge honom av vingårdens frukt. Men odlarna sände iväg honom tomhänt och pryglade honom. ");
INSERT INTO swessb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Och han tillade att skicka en annan fasttjänare. Men också denne pryglade de och vanhedrade och sände iväg tomhänt. ");
INSERT INTO swessb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Och han tillade att skicka en tredje. Men även denne sargade de och kastade ut. ");
INSERT INTO swessb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Och vingårdens herre sade: Vad ska jag göra? Jag ska skicka min älskade son. Denne ska de nog ha respekt för. ");
INSERT INTO swessb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Men när odlarna såg honom, funderade de med varandra och sade: Denne är arvtagaren! Låt oss döda honom så att arvet blir vårt. ");
INSERT INTO swessb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Och de kastade ut honom utanför vingården och dödade. Vad ska nu vingårdens herre göra med dem? ");
INSERT INTO swessb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Han ska komma och förgöra dessa odlare och ge vingården till andra.” Och när de hörde det, sade de: ”Får inte ske!” ");
INSERT INTO swessb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Men han såg på dem och frågade: ”Vad är då detta som är skrivet: Stenen som husbyggarna förkastade,   den har blivit till en hörnsten? ");
INSERT INTO swessb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Var och en som faller på den stenen blir sönderkrossad, och den på vilken den faller, honom ska den söndersmula.” ");
INSERT INTO swessb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Och de skriftlärda och översteprästerna sökte lägga händerna på honom i samma stund. Och de fruktade folket, för de förstod att det var om dem han hade talat denna liknelse. ");
INSERT INTO swessb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Och de vaktade noga och sände ut spioner som låtsades vara rättfärdiga för att ta tag i hans ord, för att utlämna honom åt styresmannens myndighet och auktoritet. ");
INSERT INTO swessb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Och de frågade honom och sade: ”Lärare, vi vet att du talar och lär ut riktigt och inte tar ett ansikte utan i sanning lär ut Guds väg. ");
INSERT INTO swessb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Är det tillåtet att vi ger kejsaren skatt eller inte?” ");
INSERT INTO swessb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Men han beaktade deras slughet och sade till dem: ");
INSERT INTO swessb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","”Visa mig en denar. Vems avbild och överskrift har den?” Och de sade: ”Kejsarens.” ");
INSERT INTO swessb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Och han sade till dem: ”Återge då det som är kejsarens till kejsaren, och det som är Guds till Gud.” ");
INSERT INTO swessb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Och de mäktade inte ta tag i hans ord inför folket, och förundrade över hans svar teg de. ");
INSERT INTO swessb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Och det kom fram några av saddukeerna, som säger emot att uppståndelse inte finns, och frågade honom ");
INSERT INTO swessb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","och sade: ”Lärare, Mose skrev till oss: Om någons bror dör och har hustru och denne är barnlös, att hans bror ska ta hustrun och låta säd uppstå fram åt sin bror. ");
INSERT INTO swessb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sju bröder fanns det nu. Och den förste tog en hustru och dog barnlös. ");
INSERT INTO swessb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Även den andre ");
INSERT INTO swessb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","och den tredje tog henne, och på samma sätt även de sju: de lämnade inga barn och dog. ");
INSERT INTO swessb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Till sist dog även kvinnan. ");
INSERT INTO swessb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kvinnan vid uppståndelsen, till vem av dem blir hon då hustru? För de sju hade henne som hustru.” ");
INSERT INTO swessb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Och Jesus sade till dem: ”Denna eons söner gifter sig och blir bortgifta. ");
INSERT INTO swessb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Men de som räknats värdiga att undfå den andra eonen och uppståndelsen från de döda varken gifter sig eller blir bortgifta. ");
INSERT INTO swessb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","För inte heller kan de längre dö, för de är änglalika och är Guds söner då de är uppståndelsens söner. ");
INSERT INTO swessb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Men att de döda uppväcks har också Mose informerat om vid törnbusken, när han kallar Herren Abrahams Gud och Isaks Gud och Jakobs Gud. ");
INSERT INTO swessb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Och han är inte dödas Gud utan levandes, för alla är levande för honom.” ");
INSERT INTO swessb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Och då svarade några av de skriftlärda och sade: ”Lärare, bra sagt!” ");
INSERT INTO swessb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","För de vågade inte längre fråga honom något. ");
INSERT INTO swessb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Och han sade till dem: ”Hur kan de säga att Kristus är Davids son? ");
INSERT INTO swessb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","För David själv säger i psalmernas bok: Herren sade till min Herre:   Sätt dig vid min högra sida ");
INSERT INTO swessb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tills jag lagt dina fiender   som en fotpall för dina fötter. ");
INSERT INTO swessb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David kallar honom alltså Herre. Och hur är han då hans son?” ");
INSERT INTO swessb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Men när allt folket lyssnade sade han till sina lärjungar: ");
INSERT INTO swessb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","”Akta er för de skriftlärda, som vill gå omkring i dräkter och gillar hälsningar på torgen och förstapositioner i synagogorna och förstaplatser vid måltiderna, ");
INSERT INTO swessb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","de som äter upp änkornas hus och som förevändning beder långt. Dessa ska få mycket mer dom.” ");
INSERT INTO swessb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Och han såg upp och såg dem som lade i skattkammaren sina gåvor och var rika. ");
INSERT INTO swessb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Och han såg en arm änka som lade där två leptoner ");
INSERT INTO swessb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","och sade: ”Sannerligen, jag säger er att denna fattiga änka har lagt mer än alla. ");
INSERT INTO swessb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","För alla dessa lade av sitt överflöd till gåvorna, men hon lade ur sin brist alla tillgångarna som hon hade.” ");
INSERT INTO swessb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Och när några sade om templet att det är smyckat med fina stenar och tempelgåvor, sade han: ");
INSERT INTO swessb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","”Detta som ni skådar, det ska komma dagar under vilka det inte ska lämnas sten på sten som inte ska rivas ner.” ");
INSERT INTO swessb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Och de frågade honom och sade: ”Lärare, när ska då detta bli? Och vad blir tecknet när detta kommer att ske?” ");
INSERT INTO swessb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Och han sade: ”Se upp så att ni inte blir förvillade. För många ska komma vid mitt namn och säga: Jag är, och: Tiden är nu nära. Far inte efter dem. ");
INSERT INTO swessb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Och när ni hör krig och oroligheter, bli inte uppskrämda. För detta måste ske först, men det är inte direkt slutet.” ");
INSERT INTO swessb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sedan sade han till dem: ”Det ska resa sig folkslag mot folkslag och rike mot rike, ");
INSERT INTO swessb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","och både väldiga jordbävningar och på olika platser svälter och pester ska det bli, och både skrämmande ting och väldiga tecken från himlen ska det bli. ");
INSERT INTO swessb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Men innan allt detta ska de lägga på er sina händer och förfölja och utlämna till synagogorna och fängelserna och föra bort er inför kungar och styresmän för mitt namns skull. ");
INSERT INTO swessb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Det kommer ut för er till vittnesbörd. ");
INSERT INTO swessb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sätt då i era hjärtan att inte i förväg begrunda hur ni ska försvara er. ");
INSERT INTO swessb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","För jag ska ge er en mun och vishet som de inte ska kunna stå emot eller säga emot, alla era motståndare. ");
INSERT INTO swessb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Men ni ska bli utlämnade även av föräldrar och syskon och släktingar och vänner, och de ska döda några av er. ");
INSERT INTO swessb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Och ni ska bli hatade av alla för mitt namns skull. ");
INSERT INTO swessb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Och inte ett hår från ert huvud ska gå förlorat. ");
INSERT INTO swessb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Genom er uthållighet ska ni förvärva era själar. ");
INSERT INTO swessb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Men när ni ser Jerusalem omringas av härläger, då vet ni att hennes ödeläggelse nu är nära. ");
INSERT INTO swessb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Då ska de i Judeen fly till bergen och de mitt i henne ska utrymma och de på markerna ska inte gå in i henne, ");
INSERT INTO swessb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","för dagar av rättskipning är dessa för att allt ska uppfyllas som är skrivet. ");
INSERT INTO swessb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ve dem som är havande i magen och dem som ammar under de dagarna! För det ska bli stort nödtvång över landet och vrede mot detta folk. ");
INSERT INTO swessb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Och de ska falla för svärdsegg och göras till fångar bort till alla folkslagen, och Jerusalem ska vara trampat under folkslag tills folkslags tider är uppfyllda. ");
INSERT INTO swessb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Och det ska bli tecken i sol och måne och stjärnor, och på jorden ångest hos folkslag i rådlöshet inför dån av hav och våg, ");
INSERT INTO swessb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","när människor tappar andan av fruktan och väntan på det som kommer över den bebodda världen. För himlarnas makter ska skakas. ");
INSERT INTO swessb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Och då ska man se Männi­skosonen komma i moln med stor makt och härlighet. ");
INSERT INTO swessb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Men när detta börjar ske, räta er upp och lyft era huvuden, eftersom er återlösning närmar sig.” ");
INSERT INTO swessb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Och han talade en liknelse till dem: ”Se på fikonträdet och alla träden. ");
INSERT INTO swessb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Redan när de skjuter fram ser ni och förstår av er själva att sommaren redan är nära. ");
INSERT INTO swessb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Så också ni: när ni ser detta ske, vet ni att Guds rike är nära. ");
INSERT INTO swessb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Amen, jag säger er att detta släkte inte ska förgå förrän allt har skett. ");
INSERT INTO swessb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Himlen och jorden ska förgå, men mina ord ska aldrig förgå. ");
INSERT INTO swessb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Men akta er så att inte era ­hjär­tan tyngs med fylleri och rus och vardagslivets bekymmer och den dagen plötsligt står framför er ");
INSERT INTO swessb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","som en snara, för den ska komma in över alla som sitter över hela jor­dens ansikte. ");
INSERT INTO swessb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Men vaka vid varje tid och bönfall att ni blir övermäktiga att undkomma allt detta som kommer att ske och bestå inför Människo­sonen.” ");
INSERT INTO swessb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Och under dagarna var han i templet och undervisade, men på nätterna gick han ut och övernattade vid det berg som kallas Olivernas. ");
INSERT INTO swessb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Och hela folket kom tidigt till honom i templet för att höra honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Men nu närmade sig det osyrade brödets högtid som kallas påsk. ");
INSERT INTO swessb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Och översteprästerna och de skriftlärda sökte hur de skulle röja bort honom, för de fruktade folket. ");
INSERT INTO swessb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Men Satan for in i Judas som kal­lades Iskariot och var av de tolvs antal. ");
INSERT INTO swessb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Och han gick bort och samtalade med översteprästerna och kommendanterna hur han kunde utlämna honom åt dem. ");
INSERT INTO swessb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Och de blev glada och kom överens om att ge honom silver. ");
INSERT INTO swessb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Och han accepterade och började söka ett lägligt tillfälle att utlämna honom åt dem utan folkskara. ");
INSERT INTO swessb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Och så kom den dag i det osyrade brödets högtid på vilken påskalammet skulle slaktoffras. ");
INSERT INTO swessb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Och han sände ut Petrus och Johannes och sade: ”Gå och bered för oss påskalammet så att vi kan äta.” ");
INSERT INTO swessb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Och de sade till honom: ”Var vill du vi ska bereda?” ");
INSERT INTO swessb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Och han sade till dem: ”Se, när ni kommer in i staden ska det möta er en man som bär en vattenkruka. Följ honom till det hus i vilket han går in ");
INSERT INTO swessb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","och säg till husets hushärskare: Läraren säger dig: Var är gästrummet där jag kan äta påskalammet med mina lärjungar? ");
INSERT INTO swessb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Och denne ska visa er en stor övre sal inredd. Bered där.” ");
INSERT INTO swessb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Och de gick iväg och fann så som han hade sagt dem. Och de beredde påskalammet. ");
INSERT INTO swessb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Och när stunden kom, lade han sig till bords och apostlarna med honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Och han sade till dem: ”Med åtrå har jag åtrått att äta detta påskalamm med er innan jag lider. ");
INSERT INTO swessb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","För jag säger er att jag aldrig mer ska äta det förrän det uppfylls i Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Och han mottog en bägare, tackade och sade: ”Ta detta och dela upp åt er. ");
INSERT INTO swessb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","För jag säger er att jag från nu aldrig mer ska dricka av vinstockens frukt förrän Guds rike kommer.” ");
INSERT INTO swessb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Och han tog ett bröd, tackade och bröt och gav åt dem och sade: ”Detta är min kropp som för er blir given. Gör detta till min åminnelse.” ");
INSERT INTO swessb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Och bägaren på samma sätt efter att de ätit måltiden, och han sade: ”Denna bägare är det nya förbundet genom mitt blod som för er blir utgjutet. ");
INSERT INTO swessb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Men se: handen hos den som utlämnar mig är med mig på bordet. ");
INSERT INTO swessb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","För Människosonen går enligt det som är bestämt, men ve den människan genom vilken han blir utlämnad.” ");
INSERT INTO swessb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Och de började diskutera med varann vem det då kunde vara av dem som skulle begå detta. ");
INSERT INTO swessb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Och det kom också en trätlystnad bland dem, vem av dem som skulle anses vara störst. ");
INSERT INTO swessb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Men han sade till dem: ”Folkslagens kungar är herrar över dem, och de som har makt över dem kallar sig välgörare. ");
INSERT INTO swessb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Men ni är inte så. Nej, den störste bland er ska bli som den yngste, och den styrande som den som be­tjänar. ");
INSERT INTO swessb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","För vem är störst: den som ligger till bords eller den som betjänar? Är det inte den som ligger till bords? Men jag är mitt ibland er som den som betjänar. ");
INSERT INTO swessb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Men ni är de som har blivit kvar hos mig under mina tester. ");
INSERT INTO swessb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Och jag instiftar för er, liksom min Far har instiftat för mig, ett rike ");
INSERT INTO swessb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","för att ni ska äta och dricka vid mitt bord i mitt rike. Och ni ska sitta på troner och döma Israels tolv stammar. ");
INSERT INTO swessb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, se: Satan har utkrävt er för att sålla som vetet. ");
INSERT INTO swessb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Men jag har bönfallit för dig att din tro inte ska ta slut. Och du, när du en gång har vänt om: stärk dina syskon.” ");
INSERT INTO swessb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Men han sade till honom: ”Herre, med dig är jag beredd att gå både i fängelse och i döden.” ");
INSERT INTO swessb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Men han sade: ”Jag säger dig, Petrus: Det ska idag inte gala en tupp förrän du tre gånger förnekat att du känner mig.” ");
INSERT INTO swessb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Och han sade till dem: ”När jag sände ut er utan börs och väska och sandaler, inte saknade ni något?” Och de sade: ”Inget.” ");
INSERT INTO swessb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Och han sade till dem: ”Men nu ska den som har en börs ta upp den, likaså även väska. Och den som inte har ska sälja sin mantel och köpa ett svärd. ");
INSERT INTO swessb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","För jag säger er att detta som är skrivet måste fullbordas i mig, att: Och med laglösa blev han räknad. För det som handlar om mig har nu sitt slut.” ");
INSERT INTO swessb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Och de sade: ”Herre, se: här är två svärd.” Och han sade till dem: ”Det är nog.” ");
INSERT INTO swessb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Och han gick ut och vandrade enligt seden till Olivberget, och även lärjungarna följde honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Men kommen på platsen sade han till dem: ”Bed om att inte komma in i frestelse.” ");
INSERT INTO swessb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Och han drog sig ut från dem, ­ungefär ett stenkast, och satte knäna och bad ");
INSERT INTO swessb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","och sade: Far, om du önskar, för bort denna ­bägare från mig. Men inte min vilja, utan din ska ske.” ");
INSERT INTO swessb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Och det visade sig för honom en ängel från ­himlen och styrkte honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Och han kom i kamp och bad ihärdigare, och hans svett blev som droppar av blod som gick ner på jorden. ");
INSERT INTO swessb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Och han stod upp från bönen och kom till lärjungarna och fann dem sovande av bedrövelsen, ");
INSERT INTO swessb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","och han sade till dem: ”Varför sover ni? Stå upp och bed så att ni inte kommer in i frestelse.” ");
INSERT INTO swessb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Medan han ännu talade, se: en skara, och han som hette Judas, en av de tolv, gick före dem och närmade sig Jesus för att kyssa honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Men Jesus sade till honom: ”Judas, är det med en kyss du utlämnar Människosonen?” ");
INSERT INTO swessb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Men de omkring honom såg det som skulle komma och sade: ”Herre, om vi ska slå med svärd?” ");
INSERT INTO swessb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Och en, en av dem slog till översteprästens fasttjänare och tog bort hans högra öra. ");
INSERT INTO swessb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Men Jesus svarade och sade: ”Låt det vara med detta!” Och han rörde vid örat och helade honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Och Jesus sade till dem som hade kommit dit mot honom, överstepräster och tempelkommendanter och äldste: ”Som mot en rövare har ni gått ut med svärd och påkar. ");
INSERT INTO swessb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","När jag varje dag var med er i templet räckte ni inte ut händerna mot mig. Men detta är er stund och mörkrets auktoritet.” ");
INSERT INTO swessb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Och de tog fast honom och förde bort och förde in i översteprästens hus. Men Petrus följde långt ifrån. ");
INSERT INTO swessb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Och när de tände en eld mitt på innergården och satte sig tillsammans, satte sig Petrus mitt ibland dem. ");
INSERT INTO swessb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Och där såg honom en tjänsteflicka sitta mot ljuset, och hon blickade på honom och sade: ”Även denne var med honom.” ");
INSERT INTO swessb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Men han nekade och sade: ”Jag känner honom inte, kvinna.” ");
INSERT INTO swessb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Och kort därefter var det en annan som såg honom och sade: ”Också du är en av dem.” Men Petrus sade: ”Människa, det är jag inte!” ");
INSERT INTO swessb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Och när det gått ungefär en timme var det en annan som insisterade och sade: ”I sanning var också denne med honom, för han är galilé.” ");
INSERT INTO swessb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Men Petrus sade: ”Människa, jag vet inte vad du säger!” Och genast, medan han ännu talade, gol tuppen. ");
INSERT INTO swessb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Och Herren vände sig och såg på Petrus. Och Petrus blev påmind om Herrens ord, hur han sagt till honom att: ”Innan en tupp gal idag ska du förneka mig tre gånger.” ");
INSERT INTO swessb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Och han gick ut utanför och grät bittert. ");
INSERT INTO swessb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Och männen som ansatte honom förlöjligade honom och pryglade, ");
INSERT INTO swessb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","och de täckte över runt honom och frågade och sade: ”Profetera! Vem är det som högg till dig?” ");
INSERT INTO swessb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Och mycket annat sade de smädande till honom. ");
INSERT INTO swessb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Och när det blev dag samlades folkets äldsteråd, både överstepräster och skriftlärda. Och de förde bort honom till sin Sanhedrin ");
INSERT INTO swessb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","och sade: ”Om du är Kristus, säg oss!” Men han sade till dem: ”Om jag säger det till er tror ni det aldrig, ");
INSERT INTO swessb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","och om jag frågar svarar ni aldrig. ");
INSERT INTO swessb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Men från nu ska Människosonen sitta på Guds makts högra sida.” ");
INSERT INTO swessb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Och alla sade: ”Du är alltså Guds Son?” Och han sade till dem: ”Ni säger att Jag Är.” ");
INSERT INTO swessb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Och de sade: ”Vad mer har vi för behov av vittnebörd? För vi har själva hört det från hans mun.” ");
INSERT INTO swessb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Och hela deras mängd stod upp och förde honom till Pilatus. ");
INSERT INTO swessb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Och de började anklaga honom och säga: ”Denne har vi funnit förvrida vårt folkslag och hindra att ge skatter till kejsaren och säga sig vara Kristus, en kung.” ");
INSERT INTO swessb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Och Pilatus frågade honom och sade: ”Du är judarnas kung?” Och han svarade honom och sade: ”Du säger det.” ");
INSERT INTO swessb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Och Pilatus sade till översteprästerna och skarorna: ”Jag finner ingen sak hos denna människa.” ");
INSERT INTO swessb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Men de insisterade och sade att: ”Han uppviglar folket och undervisar över hela Judeen, och har börjat från Galileen ända hit.” ");
INSERT INTO swessb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Men när Pilatus hörde det, frågade han om människan är galilé. ");
INSERT INTO swessb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Och när han insåg att han är av Herodes auktoritet, skickade han tillbaka honom till Herodes som också han var i Jerusalem under dessa dagar. ");
INSERT INTO swessb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Och Herodes, när han såg Jesus, gladde sig väldigt. För han hade sedan avsevärda tider velat se honom eftersom han hört om honom, och hoppades få se något tecken komma av honom. ");
INSERT INTO swessb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Och han frågade honom med åtskilliga ord, men han svarade honom inget. ");
INSERT INTO swessb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Och där stod överste­prästerna och de skriftlärda och anklagade honom intensivt. ");
INSERT INTO swessb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Och då föraktade honom även Herodes med sina trupper, och han förlöjligade och klädde i en glänsande skrud och skickade tillbaka honom till Pilatus. ");
INSERT INTO swessb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Och de blev vänner, både Herodes och Pilatus, på den dagen med varandra, för tidigare hade de varit i fiendskap mot varann. ");
INSERT INTO swessb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Men Pilatus sammankallade över­stepräs­terna och ledarna och folket ");
INSERT INTO swessb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","och sade till dem: ”Ni har fört till mig denna människa som en som vänder bort folket. Och se: jag har inför er förhört och inte funnit hos denna människa den sak för vilken ni anklagar honom. ");
INSERT INTO swessb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nej, inte heller Herodes, för han har skickat tillbaka honom till oss. Och se: inget värt döden är begått av honom. ");
INSERT INTO swessb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jag ska nu tukta och frige honom.” ");
INSERT INTO swessb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Men de skrek högt allesammans och sade: ”Ta bort den där! Och frige åt oss Barabbas!” – ");
INSERT INTO swessb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","som för ett uppror som hänt i staden och för mord var kastad i fängelset. ");
INSERT INTO swessb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Men åter ropade Pilatus till dem och ville frige Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Men de utropade och sade: ”Korsfäst! Korsfäst honom!” ");
INSERT INTO swessb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Och en tredje gång sade han till dem: ”Vad för ont har då denne gjort? Ingen sak värd döden jag har funnit hos honom. Jag ska nu tukta och frige honom.” ");
INSERT INTO swessb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Men de låg på med väldiga röster och begärde att han skulle bli korsfäst, och deras röster blev övermäktiga. ");
INSERT INTO swessb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Och Pilatus fastslog att deras önskemål skulle ske. ");
INSERT INTO swessb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Och han frigav den som för uppror och mord var kastad i fängelse, den de begärde, men Jesus utlämnade han åt deras vilja. ");
INSERT INTO swessb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Och när de förde bort honom tog de tag i Simon, en kyrené som kom in från fältet, och lade på honom korset att bära efter Jesus. ");
INSERT INTO swessb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Och det följde honom en stor mängd av folket och kvinnor som slog sig själva och jämrade sig över honom. ");
INSERT INTO swessb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Men Jesus vände sig till dem och sade: ”Jerusalems döttrar, gråt inte över mig. Nej, gråt över er själva och över era barn. ");
INSERT INTO swessb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","För se: det kommer dagar under vilka man ska säga: Saliga de ofruktsamma och de moderliv som inte fött och bröst som inte gett näring. ");
INSERT INTO swessb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Då ska man börja säga till bergen: Fall över oss, och till kullarna: Täck oss! ");
INSERT INTO swessb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","För om de gör detta med det saftfulla träet, vad ska ske med det torra?” ");
INSERT INTO swessb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Och de förde även ut två andra missdådare med honom för att avrättas. ");
INSERT INTO swessb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Och när de kom till den plats som kallas Kranium, där korsfäste de honom och missdådarna, den ene på högra sidan och den andre på vänstra. ");
INSERT INTO swessb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","⟦Men Jesus sade: ”Far, förlåt dem. För de vet inte vad de gör.”⟧ Och de delade upp hans kläder och kastade lott. ");
INSERT INTO swessb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Och folket stod där och skådade, och även ledarna fnös och sade: ”Andra har han frälst. Han får frälsa sig själv, om denne är Guds Kristus, den Utvalde.” ");
INSERT INTO swessb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Och nu förlöjligade honom även soldaterna, som kom fram och bar fram posca åt honom ");
INSERT INTO swessb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","och sade: ”Om du är judarnas kung, fräls dig själv!” ");
INSERT INTO swessb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Och det fanns också en överskrift över honom: ”Judarnas kung är denne.” ");
INSERT INTO swessb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Och en av de upphängda missdådarna smädade honom och sade: ”Är inte du Kristus? Fräls dig själv och oss!” ");
INSERT INTO swessb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Men den andre svarade och näptse honom och sade: ”Fruktar inte du ens Gud, eftersom du är under samma dom? ");
INSERT INTO swessb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Och vi rättfärdigt, för vi erhåller vad det är värt för det vi begått. Men denne har inget ovettigt begått.” ");
INSERT INTO swessb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Och han sade: ”Jesus, kom ihåg mig när du kommer till ditt rike.” ");
INSERT INTO swessb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Och han sade till honom: ”Amen, jag säger dig: Idag ska du vara med mig i paradiset.” ");
INSERT INTO swessb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Och det var redan omkring sjätte timmen, och ett mörker kom över hela landet fram till nionde timmen, ");
INSERT INTO swessb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","då solen tog slut. Och då revs förhänget i tempelbyggnaden mitt itu, ");
INSERT INTO swessb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","och Jesus ropade med väldig röst och sade: ”Far! I dina händer lägger jag över min ande.” Och när han hade sagt detta, gav han upp andan. ");
INSERT INTO swessb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Men när centurionen såg det som hände ärade han Gud och sade: ”Verkligen, den där människan var rättfärdig.” ");
INSERT INTO swessb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Och alla de församlade skarorna, vid denna syn när de skådade det som hände, slog mot bröstkorgarna och återvände hem. ");
INSERT INTO swessb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Men alla hans bekanta stod långt ifrån, även kvinnorna som hade följt med honom från Galileen, och såg detta. ");
INSERT INTO swessb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Och se: en man vid namn Josef, som var rådsherre och en god och rättfärdig man – ");
INSERT INTO swessb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","denne var inte enig med deras plan och handlande – från Arimatea, en judarnas stad, som väntade på Guds rike. ");
INSERT INTO swessb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Denne gick till Pilatus och bad om Jesu kropp. ");
INSERT INTO swessb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Och han tog ner och vek in den i linnetyg och lade honom i en uthuggen grav där ingen ännu var lagd. ");
INSERT INTO swessb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Och det var förberedelsedag och sabbaten grydde. ");
INSERT INTO swessb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Men kvinnorna följde efter, de som hade kommit med honom från Galileen, och skådade graven och hur hans kropp blev lagd där. ");
INSERT INTO swessb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Och de återvände hem och beredde kryddor och balsam. Och under sabbaten höll de sig stilla enligt budet. ");
INSERT INTO swessb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Men den första dagen i veckan, i djup gryning, kom de till graven bärande kryddor som de berett. ");
INSERT INTO swessb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Men de fann stenen bortrullad från graven, ");
INSERT INTO swessb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","och när de gick in fann de inte Herren Jesu kropp. ");
INSERT INTO swessb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Och det hände sig, under det att de var villrådiga om detta, och se: två män stod framför dem i blixtrande skrud. ");
INSERT INTO swessb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Och när de blev förskräckta och böjde ansiktena mot jorden, sade de till dem: ”Varför söker ni den levande hos de döda? ");
INSERT INTO swessb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Han är inte här. Nej, han är uppväckt! Kom ihåg hur han talade till er när han ännu var i Galileen, ");
INSERT INTO swessb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","och sade om Människosonen att han måste bli ut­lämnad i syndiga människors händer och korsfäst, och den tredje dagen uppstå.” ");
INSERT INTO swessb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Och de kom ihåg hans ord. ");
INSERT INTO swessb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Och de återvände från graven och berättade allt detta för de elva och för alla de övriga. ");
INSERT INTO swessb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Och de var Maria Magdalena och Johanna och Maria Jakobs mor och de övriga kvinnorna med dem. De sade detta till apostlarna, ");
INSERT INTO swessb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","och det syntes inför dem som nonsens med dessa ord och de trodde inte på dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Men Petrus stod upp och sprang till graven. Och när han blickar in, ser han bara linnebindlarna. Och han gick iväg till sig, undrande över det som hänt. ");
INSERT INTO swessb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Och se: två av dem var samma dag vandrande till en by som är sextio stadier från Jerusalem vars namn är Emmaus. ");
INSERT INTO swessb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Och de pratade med varandra om allt detta som hade hänt. ");
INSERT INTO swessb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Och det hände sig, under det att de pratade och diskuterade, att även Jesus själv närmade sig och vandrade med dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Men deras ögon hölls kvar så att de inte kände igen honom. ");
INSERT INTO swessb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Och han sade till dem: ”Vad är dessa för ord som ni utbyter med varandra medan ni vandrar?” Och de stannade, mörka i blick. ");
INSERT INTO swessb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Och en vid namn Kleopas svarade och sade till honom: ”Är du ensam som utböling i Jerusalem och vet inte det som har hänt i henne under dessa dagar?” ");
INSERT INTO swessb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Och han sade till dem: ”Vad?” Och de sade till honom: ”Det om Jesus nasarén. Han kom som en profetman, mäktig i gärning och ord inför Gud och hela folket, ");
INSERT INTO swessb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","och hur de utlämnade honom, våra överstepräster och ledare, till en dödsdom och korsfäste honom. ");
INSERT INTO swessb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Och vi hoppades att han är den som kommer att återlösa Israel. Men dessutom med allt detta går nu den tredje dagen sedan detta hände. ");
INSERT INTO swessb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Men dessutom har några kvinnor från oss förbryllat oss, då de kom i gryningen till graven ");
INSERT INTO swessb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","och fann inte hans kropp, men kom och sade sig ha sett en vision med änglar som säger att han lever. ");
INSERT INTO swessb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Och då gick några av dem som var med oss bort till graven och fann det så liksom kvinnorna också sagt. Men honom såg de inte.” ");
INSERT INTO swessb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Och han sade till dem: ”O ni oförnuftiga och långsamma i hjärtat till att tro på allt som profeterna har talat! ");
INSERT INTO swessb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Var det inte detta Kristus måste lida och gå in i sin härlighet?” ");
INSERT INTO swessb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Och han började från Mose och från alla profeterna och uttolkade för dem i alla Skrifterna det som var om honom. ");
INSERT INTO swessb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Och de närmade sig byn dit de vandrade, och han gjorde som om han skulle vandra mer fjärran. ");
INSERT INTO swessb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Och de tvingade honom och sade: ”Bli kvar hos oss. För det är mot afton och dagen har redan vikit.” Och han gick in för att bli kvar med dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Och det hände sig, under det att han lutade sig till bords med dem, att han tog brödet och välsignade, och bröt och gav åt dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Och deras ögon öppnades upp och de kände igen honom – och han blev omärkbar för dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Och de sade till varandra: ”Var inte vårt hjärta brinnande inom oss när han talade till oss på vägen, när han ­öppnade upp för oss Skrifterna?” ");
INSERT INTO swessb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Och de stod upp i samma stund och återvände till Jerusalem och fann de elva hopade och de som var med dem, ");
INSERT INTO swessb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","som sade att: ”Verkligen, Herren har blivit upp­väckt och visat sig för Simon!” ");
INSERT INTO swessb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Och själva utlade de det som hänt på vägen och hur han blivit känd för dem vid brödsbrytelsen. ");
INSERT INTO swessb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Och medan de talade om detta, stod han själv mitt ibland dem och säger till dem: ”Frid åt er!” ");
INSERT INTO swessb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Men de blev uppskrämda och förskräckta och tyckte sig skåda en ande. ");
INSERT INTO swessb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Och han sade till dem: ”Varför är ni oroade? Och varför kommer det upp funderingar i ert hjärta? ");
INSERT INTO swessb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Se mina händer och mina fötter, att jag är densamme. Känn på mig och se. För en ande har inte kött och ben, så som ni skådar mig att jag har.” ");
INSERT INTO swessb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Och när han sagt detta visade han dem händerna och fötterna. ");
INSERT INTO swessb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Och när de fortfarande inte trodde av glädjen och var förundrade, sade han till dem: ”Har ni något ätbart här?” ");
INSERT INTO swessb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Och de gav honom en del av en stekt fisk, ");
INSERT INTO swessb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","och han tog inför dem och åt. ");
INSERT INTO swessb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Och han sade till dem: ”Dessa är mina ord som jag talade till er medan jag ännu var hos er, att allt måste uppfyllas somär skrivet i Mose lag och profeterna och psalmerna om mig.” ");
INSERT INTO swessb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sedan öppnade han upp deras sinne till att förstå Skrifterna. ");
INSERT INTO swessb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Och han sade till dem att: ”Så är skrivet: att Kristus ska lida och uppstå från de döda den tredje dagen, ");
INSERT INTO swessb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","och det ska förkunnas vid hans namn sinnesändring till syndernas förlåtelse för alla folkslagen, börjande i Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ni är vittnen om detta. ");
INSERT INTO swessb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Och se: jag sänder min Fars löfte över er. Men ni ska sitta i staden tills ni blivit iklädda från höjden med kraft.” ");
INSERT INTO swessb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Och han förde ut dem utanför ända till Betania, och han lyfte sina händer och välsignade dem. ");
INSERT INTO swessb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Och det hände sig, under det att han väl­signade dem, att han gick ifrån dem och fördes upp till himlen. ");
INSERT INTO swessb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Och de tillbad honom och återvände till Jerusalem i stor glädje, ");
INSERT INTO swessb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","och de var ständigt i templet och välsignade Gud. ");
INSERT INTO swessb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","I begynnelsen var Ordet. Och Ordet var hos Gud, och Ordet var Gud. ");
INSERT INTO swessb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Denne var i begynnelsen hos Gud. ");
INSERT INTO swessb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Allt kom genom honom, och utan honom kom inte ett enda. Det som kommit ");
INSERT INTO swessb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","i honom var liv, och livet var människornas ljus. ");
INSERT INTO swessb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Och ljuset i mörkret lyser, och mörkret har inte greppat det. ");
INSERT INTO swessb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Det kom en människa, sänd från Gud. Hans namn var Johannes. ");
INSERT INTO swessb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Denne kom till ett vittnesbörd, för att vittna om ljuset, för att alla skulle komma till tro genom honom. ");
INSERT INTO swessb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Denne var inte ljuset, utan för att vittna om ljuset. ");
INSERT INTO swessb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Det sannfärdiga ljuset, som upplyser varje människa, var kommande in i världen. ");
INSERT INTO swessb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I världen var han, och världen kom genom honom. Och världen kände honom inte. ");
INSERT INTO swessb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Till sitt eget kom han, och de egna tog inte emot honom. ");
INSERT INTO swessb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Men de som tog emot honom, åt dem gav han rättighet att bli Guds barn: åt dem som tror på hans namn, ");
INSERT INTO swessb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","som fötts inte av blod eller av kötts vilja eller av mans vilja, utan av Gud. ");
INSERT INTO swessb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Och Ordet blev kött och hade sin boning bland oss. Och vi skådade hans härlighet, en härlighet som hos en enfödd från Fadern, full av nåd och sanning. ");
INSERT INTO swessb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes vittnar om honom och har ropat och säger: ”Denne var den om vilken jag sade: Han som kommer efter mig har blivit före mig, för han var först före mig.” ");
INSERT INTO swessb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","För av hans fullhet har vi alla fått, och nåd mot nåd. ");
INSERT INTO swessb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","För lagen gavs genom Mose, nåden och sanningen kom genom Jesus Kristus. ");
INSERT INTO swessb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gud har ingen någonsin sett. Enfödd Gud som är i Faderns famn, denne har utlagt. ");
INSERT INTO swessb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Och detta är Johannes vittnesbörd, när judarna från Jerusalem sände till honom präster och leviter för att fråga honom: ”Vem är du?” ");
INSERT INTO swessb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Och han bekände och förnekade inte, och bekände att: ”Jag är inte Kristus”. ");
INSERT INTO swessb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Och de frågade honom: ”Så vad? Är du Elia?” Och han säger: ”Det är jag inte.” – ”Är du Profeten?” Och han svarade: ”Nej.” ");
INSERT INTO swessb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","De sade då till honom: ”Vem är du? Så att vi kan ge ett svar till dem som skickat oss. Vad säger du om dig själv?” ");
INSERT INTO swessb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Han sade: ”Jag ärrösten av en som ropar i ödemarken: Räta ut Herrens väg, så som profeten Jesaja har sagt.” ");
INSERT INTO swessb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Och de var utsända från fariseerna, ");
INSERT INTO swessb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","och de frågade honom och sade till honom: ”Varför döper du då, om du inte är Kristus eller Elia eller Profeten?” ");
INSERT INTO swessb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes svarade dem och sade: ”Jag döper i vatten. Mitt ibland er står en som ni inte känner, ");
INSERT INTO swessb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","han som kommer efter mig. Hos honom är jag inte värdig att lossa hans sandalrem.” ");
INSERT INTO swessb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Detta hände i Betania på andra sidan Jordan där Johannes var och döpte. ");
INSERT INTO swessb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dagen därpå ser han Jesus komma till honom och säger: ”Se: Guds Lamm som tar bort världens synd! ");
INSERT INTO swessb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Denne är den om vilken jag sade: Efter mig kommer en man som har blivit före mig, för han var först före mig. ");
INSERT INTO swessb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Och jag kände honom inte. Men för att han ska visas för Israel, därför har jag kommit och döper i vatten.” ");
INSERT INTO swessb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Och Johannes vittnade och sade att: ”Jag har skådat Anden komma ner som en duva från himlen, och den blev kvar över honom. ");
INSERT INTO swessb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Och jag kände honom inte. Men han som skickade mig att döpa i vatten, denne sade till mig: Den över vilken du ser att Anden kommer ner och blir kvar över honom, denne är den som döper i helig Ande. ");
INSERT INTO swessb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Och jag har sett och vittnat att denne är Guds Son.” ");
INSERT INTO swessb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dagen därpå stod åter Johannes där och två av hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Och han ser på Jesus som kommer vandrande och säger: ”Se: Guds Lamm!” ");
INSERT INTO swessb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Och de två lärjungarna hörde när han talade och följde Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Men Jesus vände sig och skådade dem följa efter, och säger till dem: ”Vad söker ni?” Och de sade till honom: ”Rabbi”, vilket heter översatt Lärare, ”var uppehåller du dig?” ");
INSERT INTO swessb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Han säger till dem: ”Kom och ni ska se.” De kom då och såg var han uppehåller sig, och de uppehöll sig hos ­honom den dagen. Timmen var omkring den tionde. ");
INSERT INTO swessb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, brodern till Simon Petrus, var en av de två som hade hört från Johannes och följt honom. ");
INSERT INTO swessb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Denne finner först sin egen bror Simon och säger till honom: ”Vi har funnit Messias!”, vilket är översatt Kristus. ");
INSERT INTO swessb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Han förde honom till Jesus. Jesus såg på honom och sade: ”Du är Simon, Johannes son. Du ska kallas Kefas”, vilket översätts Petrus. ");
INSERT INTO swessb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dagen därpå ville han gå ut till Galileen, och finner Filippus. Och Jesus säger till honom: ”Följ mig.” ");
INSERT INTO swessb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Och Filippus var från Betsaida, från Andreas och Petrus stad. ");
INSERT INTO swessb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus finner Natanael och säger till honom: ”Den som Mose skrev om i lagen, och även profeterna, har vi funnit: Jesus, Josefs son från Nasaret.” ");
INSERT INTO swessb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Och Natanael sade till honom: ”Från Nasaret? Kan något gott vara därifrån?” Filippus säger till honom: ”Kom och se!” ");
INSERT INTO swessb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus såg Natanael komma till honom och säger om honom: ”Se: sannerligen en ­israelit i vilken svek inte finns.” ");
INSERT INTO swessb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nata­nael säger till honom: ”Varifrån känner du mig?” Jesus svarade och sade till honom: ”Före det att Filippus ropade på dig, när du var under fikonträdet, såg jag dig.” ");
INSERT INTO swessb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Då svarade honom Natanael: ”Rabbi, du är Guds Son. Du är Israels kung!” ");
INSERT INTO swessb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus svarade och sade till honom: ”Eftersom jag sade dig att jag såg dig under fikonträdet tror du? Större än detta ska du se.” ");
INSERT INTO swessb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Och han säger till honom: ”Amen amen, jag säger er: Ni ska se himlen öppnad och Guds änglar stiga upp och stiga ner över Människosonen.” ");
INSERT INTO swessb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Och den tredje dagen blev det bröllop i Kana i Galileen, och Jesu mor var där. ");
INSERT INTO swessb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Och även Jesus och hans lärjungar blev bjudna till bröllopet. ");
INSERT INTO swessb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Och när det saknades vin, säger Jesu mor till honom: ”De har inget vin.” ");
INSERT INTO swessb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Och Jesus säger till henne: ”Vad mellan mig och dig, kvinna? Ännu har inte min stund kommit.” ");
INSERT INTO swessb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hans mor säger till tjänarna: ”Vad han än säger er, gör det.” ");
INSERT INTO swessb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Och där fanns sex vattenkärl av sten för judarnas rening liggande, som hade rum för två eller tre metreter var. ");
INSERT INTO swessb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus säger till dem: ”Fyll vattenkärlen med vatten.” Och de fyllde dem ända upp. ");
INSERT INTO swessb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Och han säger till dem: ”Ös upp nu och bär till festvärden.” Och de bar. ");
INSERT INTO swessb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Men när festvärden smakade på vattnet, som hade blivit vin – och han visste inte varifrån det är, men tjänarna visste som hade öst upp vattnet – ropar festvärden på brudgummen ");
INSERT INTO swessb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","och säger till honom: ”Varje människa sätter först fram det fina vinet, och när de är berusade det ringare. Du har bevarat det fina vinet till nu.” ");
INSERT INTO swessb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Denna tecknens begynnelse gjorde Jesus i Kana i Galileen. Och han visade sin härlighet, och hans lärjungar trodde på honom. ");
INSERT INTO swessb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Efter detta gick han ner till Kapernaum, han och hans mor och hans bröder och hans lärjungar. Och där blev de kvar inte så många dagar. ");
INSERT INTO swessb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Och judarnas påsk var nära, och Jesus gick upp till Jerusalem. ");
INSERT INTO swessb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Och han fann i templet dem som sålde oxar och får och duvor och pengaväxlarna sittande, ");
INSERT INTO swessb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","och han gjorde en piska av rep och drev ut alla från templet, både fåren och oxarna. Och han utgöt växlarnas mynt, och borden vände han upp och ner, ");
INSERT INTO swessb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","och till dem som sålde duvorna sade han: ”Ta bort detta härifrån! Gör inte min Fars hus till ett marknadshus!” ");
INSERT INTO swessb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hans lärjungar kom ihåg att det är skrivet: Niten för ditt hus ska förtära mig. ");
INSERT INTO swessb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Då svarade judarna och sade till honom: ”Vilket tecken visar du oss, att du gör detta?” ");
INSERT INTO swessb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus svarade och sade till dem: ”Riv denna tempelbyggnad, och på tre dagar ska jag resa upp den.” ");
INSERT INTO swessb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Då sade judarna: ”Fyrtio­sex år har denna tempelbyggnad byggts, och du ska på tre dagar resa upp den!” ");
INSERT INTO swessb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Men denne talade om sin kropps tempelbyggnad. ");
INSERT INTO swessb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","När han så blev uppväckt från de döda kom hans lärjungar ihåg att han sade detta, och de trodde på Skriften och på ordet som Jesus hade sagt. ");
INSERT INTO swessb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Och när han var i Jerusalem vid påsken under högtiden kom många till tro på hans namn, när de skådade hans tecken som han gjorde. ");
INSERT INTO swessb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Men själv anförtrodde sig Jesus inte åt dem, därför att han kände alla ");
INSERT INTO swessb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","och eftersom han inte hade behov att någon vittnar om människan. För han själv visste vad som fanns i människan. ");
INSERT INTO swessb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Men det fanns en man från fariseerna, Nikodemus var hans namn, en ledare för judarna. ");
INSERT INTO swessb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Denne kom till honom om natten och sade till honom: ”Rabbi, vi vet att det är från Gud du kommit som lärare. För ingen kan göra dessa tecken som du gör om inte Gud är med honom.” ");
INSERT INTO swessb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus svarade och sade till honom: ”Amen amen, jag säger dig: Om någon inte blir född från ovan kan han inte se Guds rike.” ");
INSERT INTO swessb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niko­demus säger till honom: ”Hur kan en män­niska bli född när han är gammal? Inte kan han komma in i sin mors moder­liv en andra gång och födas?” ");
INSERT INTO swessb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus svarade: ”Amen amen, jag säger dig: Om någon inte blir född av vatten och Ande kan han inte komma in i Guds rike. ");
INSERT INTO swessb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Det som är fött av köttet är kött, och det som är fött av Anden är ande. ");
INSERT INTO swessb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Var inte förundrad att jag sade till dig: Ni måste födas från ovan. ");
INSERT INTO swessb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Anden blåser vart den vill, och dess röst hör du. Men du vet inte varifrån den kommer och vart den beger sig. Så är var och en som är född av Anden.” ");
INSERT INTO swessb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus svarade och sade till honom: ”Hur kan detta ske?” ");
INSERT INTO swessb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus svarade och sade till honom: ”Du är Israels lärare, och detta förstår du inte? ");
INSERT INTO swessb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amen amen, jag säger dig att det vi vet talar vi, och det vi sett vittnar vi om. Och vårt vittnesbörd tar ni inte emot. ");
INSERT INTO swessb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Om jag har sagt er det jordiska och ni inte tror, hur om jag säger er det himmelska ska ni tro? ");
INSERT INTO swessb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Och ingen har stigit upp till himlen utom den som steg ner från himlen, Människosonen. ");
INSERT INTO swessb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Och liksom Mose upphöjde ormen i ödemarken, så måste Människosonen bli upphöjd ");
INSERT INTO swessb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","för att var och en som tror på honom ska ha eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","För så älskade Gud världen att han gav den enfödde Sonen, för att var och en som tror på honom inte ska gå förlorad utan ha eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","För Gud sände inte Sonen till världen för att döma världen, utan för att världen ska bli frälst genom honom. ");
INSERT INTO swessb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Den som tror på honom blir inte dömd. Men den som inte tror är redan dömd, eftersom han inte har trott på Guds enfödde Sons namn. ");
INSERT INTO swessb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Och detta är domen: att ljuset har kommit in i världen och människorna ­älskade mörkret mer än ljuset, för deras gärningar var elaka. ");
INSERT INTO swessb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","För var och en som utövar det usla hatar ljuset och kommer inte till ljuset, för att inte hans gärningar ska avslöjas. ");
INSERT INTO swessb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Men den som gör sanningen kommer till ljuset, för att hans gärningar ska visas fram: att det är i Gud de är utförda.” ");
INSERT INTO swessb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Efter detta gick Jesus och hans lärjungar till det judeiska landet, och där stannade han med dem och döpte. ");
INSERT INTO swessb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Men även Johannes var och döpte i Ainon nära Salim, eftersom det fanns stora vatten där. Och de kom dit och blev döpta, ");
INSERT INTO swessb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","för ännu var Johannes inte kastad i fängelset. ");
INSERT INTO swessb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Det kom då upp en diskussion från Johannes lärjungar med en jude om rening. ");
INSERT INTO swessb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Och de kom till Johannes och sade till honom: ”Rabbi, han som var med dig på andra sidan Jordan, om vilken du vittnat, se: han döper och alla går till honom!” ");
INSERT INTO swessb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes svarade och sade: ”En människa kan inte ta sig ens ett enda om det inte är honom givet från himlen. ");
INSERT INTO swessb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ni själva vittnar för mig att jag sagt att jag inte är Kristus, utan att jag är sänd framför denne. ");
INSERT INTO swessb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Den som har bruden är brudgum. Men brudgummens vän, som står och lyssnar till honom, gläds med glädje av brudgummens röst. Denna min glädje är nu uppfylld. ");
INSERT INTO swessb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Denne måste växa och jag minska. ");
INSERT INTO swessb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Den som kommer från ovan är ovanför alla. Den som är av jor­den är av jorden och talar utifrån jorden. Den som kommer från himlen är ovanför alla. ");
INSERT INTO swessb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Det han har sett och hört, det vittnar han om, och hans vittnesbörd tar ingen emot. ");
INSERT INTO swessb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Den som tar emot hans vittnesbörd har satt sigill att Gud är sann. ");
INSERT INTO swessb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","För den som Gud har sänt talar Guds ord, för det är inte utifrån mått han ger Anden. ");
INSERT INTO swessb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Fadern älskar Sonen och har gett allt i hans hand. ");
INSERT INTO swessb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Den som tror på Sonen har eoniskt liv. Men den som är ohörsam mot Sonen ska inte se liv, utan Guds vrede blir kvar över honom.” ");
INSERT INTO swessb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","När Jesus nu förstod att fariseerna hört att Jesus gör och döper fler lärjungar än Johannes – ");
INSERT INTO swessb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","även om Jesus själv inte döpte, utan hans lärjungar – ");
INSERT INTO swessb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","lämnade han Judeen och gick åter bort till Galileen. ");
INSERT INTO swessb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Men han måste gå genom Samarien. ");
INSERT INTO swessb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Han kommer nu till en stad i Samarien som kallas Sykar, granne med den markbit som Jakob gav Josef sin son. ");
INSERT INTO swessb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Och där fanns Jakobs källa. Jesus, nu matt av vägfärden, satte sig så vid källan. Timmen var omkring den sjätte. ");
INSERT INTO swessb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Det kommer en kvinna från Samarien för att ösa vatten. Jesus säger till henne: ”Ge mig att dricka.” ");
INSERT INTO swessb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","För hans lärjungar hade gått bort till staden för att köpa födoämnen. ");
INSERT INTO swessb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Då säger den samariska kvinnan till honom: ”Hur kan du, som är jude, be från mig om att dricka som är en samarisk kvinna?” För judar samsas inte med samarier. ");
INSERT INTO swessb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus svarade och sade till henne: ”Om du visste om Guds gåva och vem det är som säger dig: Ge mig att dricka, hade du bett honom och han hade gett dig levande vatten.” ");
INSERT INTO swessb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kvinnan säger till honom: ”Herre, inte ens ett öskar har du. Och brunnen är djup. Varifrån har du då det levande vattnet? ");
INSERT INTO swessb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Inte är du större än vår fader Jakob, som gav oss brun­nen och själv drack ur den, även hans söner och hans boskapsdjur?” ");
INSERT INTO swessb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus svarade och sade till henne: ”Var och en som dricker av detta vatten kommer åter att törsta. ");
INSERT INTO swessb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Men den som dricker av det vatten som jag ska ge honom ska aldrig törsta till eonen. Nej, det vatten som jag ska ge honom ska bli i honom en källa med vatten som studsar upp till eoniskt liv.” ");
INSERT INTO swessb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kvinnan säger till honom: ”Herre, ge mig det vattnet, så att jag inte måste törsta eller gå över hit för att ösa.” ");
INSERT INTO swessb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Han säger till henne: ”Bege dig, ropa på din man och kom hit.” ");
INSERT INTO swessb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kvinnan svarade och sade till honom: ”Jag har ingen man.” Jesus säger till henne: ”Du säger med rätta att: Man har jag ingen. ");
INSERT INTO swessb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","För fem män har du haft, och den du nu har är inte din man. Detta har du sagt sant.” ");
INSERT INTO swessb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kvinnan säger till honom: ”Herre, jag skådar att du är en profet. ");
INSERT INTO swessb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Våra fäder har tillbett på detta berg. Och ni säger att i Jerusalem finns platsen där man ska tillbe.” ");
INSERT INTO swessb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus säger till henne: ”Tro mig, kvinna, att det kommer en stund när det varken är på detta berg eller i Jerusalem ni ska tillbe Fadern. ");
INSERT INTO swessb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ni tillber vad ni inte känner. Vi tillber vad vi känner, eftersom frälsningen är från judarna. ");
INSERT INTO swessb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Men det kommer en stund, och det är nu, när de sannfärdiga tillbedjarna ska tillbe Fadern i ande och sanning. För Fadern söker sådana som tillber honom. ");
INSERT INTO swessb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gud är ande. Och de som tillber honom måste tillbe i ande och sanning.” ");
INSERT INTO swessb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kvinnan säger till honom: ”Jag vet att Messias kommer, han som kallas Kristus. När denne kommer ska han delge oss alltihop.” ");
INSERT INTO swessb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus säger till henne: ”Jag Är, den som talar med dig.” ");
INSERT INTO swessb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Och vid detta kom hans lärjungar, och de var förundrade att han talade med en kvinna. Ingen sade dock: ”Vad söker du?” eller: ”Varför talar du med henne?” ");
INSERT INTO swessb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kvinnan lämnade då sitt vattenkärl och gick iväg in i staden och säger till människorna: ");
INSERT INTO swessb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","”Kom, se en människa som har sagt mig allt vad jag har gjort. Denne är väl inte Kristus?” ");
INSERT INTO swessb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","De gick ut ur staden och började gå till honom. ");
INSERT INTO swessb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Däremellan frågade lärjungarna honom och sade: ”Rabbi, ät!” ");
INSERT INTO swessb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Men han sade till dem: ”Jag har mat att äta som ni inte känner.” ");
INSERT INTO swessb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Lärjungarna sade då till varandra: ”Inte har någon hämtat till honom att äta?” ");
INSERT INTO swessb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus säger till dem: ”Min mat är att göra viljan hos honom som har skickat mig och fullkomna hans verk. ");
INSERT INTO swessb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Säger inte ni att det ännu är fyra månader och så kommer skörden? Se, jag säger er: Lyft era ögon och skåda markerna, att de är vita till skörd. Redan ");
INSERT INTO swessb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","får den som skördar lön och samlar frukt till eoniskt liv, så att den som sår och den som skördar får glädjas tillsammans. ");
INSERT INTO swessb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","För i detta är ordet sannfärdigt att en annan är den som sår och en annan den som skördar. ");
INSERT INTO swessb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jag har sänt ut er att skörda det ni inte har jobbat med. Andra har jobbat och ni har gått in i deras möda.” ");
INSERT INTO swessb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Och från den staden kom många till tro på honom av samarierna, på grund av ordet från kvinnan som vittnade att: ”Han har sagt mig allt som jag har gjort.” ");
INSERT INTO swessb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","När de nu kom till honom, samarierna, tillfrågade de honom om att bli kvar hos dem. Och han blev kvar där två dagar. ");
INSERT INTO swessb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Och många fler kom till tro på grund av hans ord, ");
INSERT INTO swessb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","och till kvinnan sade de att: ”Det är inte längre på grund av ditt tal vi tror. För vi har själva hört och vet att denne sannerligen är världens Frälsare.” ");
INSERT INTO swessb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Men efter de två dagarna gick han ut därifrån till Galileen, ");
INSERT INTO swessb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","för Jesus själv vittnade att en profet inte har heder i sin egen fädernebygd. ");
INSERT INTO swessb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","När han nu kom till Galileen välkomnade galileerna honom, då de hade sett vad han gjort i Jerusalem under högtiden. För de hade också själva kommit till högtiden. ");
INSERT INTO swessb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Han kom nu åter till Kana i Galileen, där han hade gjort vattnet till vin. Och det fanns en kunglig vars son var sjuk i Kapernaum. ");
INSERT INTO swessb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Denne hörde att Jesus hade kommit från Judeen till Galileen, och gick iväg till honom och efterfrågade att han skulle komma ner och hela hans son, för han var på väg att dö. ");
INSERT INTO swessb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Då sade Jesus till honom: ”Om ni inte får se tecken och under tror ni aldrig.” ");
INSERT INTO swessb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Den kunglige säger till honom: ”Herre, kom ner innan mitt barn dör!” ");
INSERT INTO swessb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus säger till honom: ”Gå. Din son lever.” Mannen trodde ordet som Jesus sade till honom och gick. ");
INSERT INTO swessb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Och redan medan han gick neråt mötte honom hans fasttjänare som sade att hans gosse levde. ");
INSERT INTO swessb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Han efterhörde då timmen från dem vid vilken han fått det bättre. De sade då till honom att: ”Igår vid sjunde timmen lämnade honom febern.” ");
INSERT INTO swessb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Fadern förstod då att det var vid den timmen Jesus sagt till honom: ”Din son lever.” Och han och hela hans hus kom till tro. ");
INSERT INTO swessb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Och detta var åter det andra tecknet Jesus gjorde sedan han kommit från Judeen till Galileen. ");
INSERT INTO swessb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Efter detta var det en judarnas högtid, och Jesus gick upp till Jeru­salem. ");
INSERT INTO swessb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Och det finns i Jerusalem vid Fårporten en damm, som på ­hebreiska också kal­las Betesda och har fem pelargångar. ");
INSERT INTO swessb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","I dessa låg en mängd av de sjuka, blinda, lama, skrumpnade. ");
INSERT INTO swessb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Och det fanns en man där som hade trettio och åtta år i sin sjukdom. ");
INSERT INTO swessb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus såg denne liggande och förstod att han redan har lång tid, och säger till honom: ”Vill du bli frisk?” ");
INSERT INTO swessb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Den sjuke svarade honom: ”Herre, jag har ingen människa för att, när vattnet rörs upp, sätta mig i dammen. Och under det att jag kommer, stiger en annan ner före mig.” ");
INSERT INTO swessb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus säger till honom: ”Res dig. Ta upp din madrass och vandra.” ");
INSERT INTO swessb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Och direkt blev mannen frisk, och han tog upp sin madrass och vandrade. Men det var sabbat den dagen. ");
INSERT INTO swessb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judarna sade då till den botade: ”Det är sabbat. Och det är inte tillåtet för dig att ta upp din madrass.” ");
INSERT INTO swessb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Men han svarade dem: ”Han som gjort mig frisk, denne sade åt mig: Ta upp din madrass och vandra.” ");
INSERT INTO swessb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","De frågade honom: ”Vem är den människan som sade åt dig: Ta upp och vandra?” ");
INSERT INTO swessb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Men den helade visste inte vem det är, för Jesus hade väjt undan då det var en skara på platsen. ");
INSERT INTO swessb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Efter detta finner Jesus honom i templet, och han sade till honom: ”Se: du har blivit frisk. Synda inte mer, så att inget värre händer dig.” ");
INSERT INTO swessb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mannen gick iväg och delgav judarna att det är Jesus som gjort honom frisk. ");
INSERT INTO swessb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Och därför började judarna förfölja Jesus, eftersom han gjorde detta på sabbaten. ");
INSERT INTO swessb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Men Jesus svarade dem: ”Min Far verkar ännu. Även jag verkar.” ");
INSERT INTO swessb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Därför sökte judarna nu desto mer döda honom, eftersom han inte bara upplöste sabbaten utan också kallade Gud sin egen Far och gjorde sig själv lik Gud. ");
INSERT INTO swessb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus svarade då och sade till dem: ”Amen amen, jag säger er: Sonen kan inte göra något av sig själv, om han inte ser Fadern göra något. För vad denne gör, det gör även Sonen likaså. ");
INSERT INTO swessb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","För Fadern gillar Sonen och visar honom allt som han själv gör. Och större gärningar än dessa ska han visa honom, så att ni förundras. ");
INSERT INTO swessb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","För såsom Fadern uppväcker de döda och levandegör, så levandegör också Sonen dem han vill. ");
INSERT INTO swessb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","För inte heller dömer Fadern någon, utan all domen har han gett till Sonen, ");
INSERT INTO swessb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","för att alla ska hedra Sonen så som de hedrar Fadern. Den som inte hedrar Sonen hedrar inte Fadern som har skickat honom. ");
INSERT INTO swessb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Amen amen, jag säger er att den som hör mitt ord och tror på honom som har skickat mig, han har eoniskt liv. Och han kommer inte till dom, utan har gått över från döden till livet. ");
INSERT INTO swessb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amen amen, jag säger er att det kommer en stund, och det är nu, när de döda ska höra Guds Sons röst. Och de som hör ska leva. ");
INSERT INTO swessb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","För såsom Fadern har liv i sig själv, så har han också gett Sonen att ha liv i sig själv. ");
INSERT INTO swessb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Och auktoritet har han gett honom att göra dom, eftersom han är Människoson. ");
INSERT INTO swessb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Var inte förundrade över detta. För det kommer en stund vid vilken alla i gravarna ska höra hans röst ");
INSERT INTO swessb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","och komma ut: de som gjort det goda till en livets uppståndelse, och de som utövat det usla till en domens uppståndelse. ");
INSERT INTO swessb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jag kan inte göra något av mig själv. Så som jag hör dömer jag. Och min dom är rättfärdig, eftersom jag inte söker min vilja utan viljan hos honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Om jag vittnar om mig själv är mitt vittnesbörd inte sant. ");
INSERT INTO swessb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Det finns en annan som vittnar om mig, och jag vet att sant är det vittnesbörd som han vittnar om mig. ");
INSERT INTO swessb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ni har sänt till Johannes, och han har vittnat för san­ningen. ");
INSERT INTO swessb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Och jag tar inte emot vittnesbördet från en människa, men detta säger jag för att ni ska bli frälsta. ");
INSERT INTO swessb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Denne var lampan som brann och lyste, och ni ville jubla för en stund i hans ljus. ");
INSERT INTO swessb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Men jag har vittnesbördet större än Johannes. För gärningarna som Fadern har gett mig för att jag ska fullkomna dem, själva gärningarna som jag gör, vittnar om mig att Fadern har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Och Fadern som har skickat mig, denne har vittnat om mig. Och hans röst har ni aldrig någonsin hört, och hans skepnad har ni inte sett, ");
INSERT INTO swessb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","och hans ord har ni inte förblivande i er. För honom som denne har sänt, honom tror ni inte. ");
INSERT INTO swessb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ni utforskar Skrifterna, eftersom ni tänker er ha eoniskt liv i dem. Och det är dessa som vittnar om mig, ");
INSERT INTO swessb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","och ni vill inte komma till mig för att ha liv. ");
INSERT INTO swessb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ära från ­män­niskor tar jag inte emot. ");
INSERT INTO swessb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nej, jag har lärt känna er, att Guds kärlek har ni inte inom er. ");
INSERT INTO swessb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jag har kommit i min Fars namn, och ni tar inte emot mig. Om en annan kommer i sitt eget namn, denne tar ni emot. ");
INSERT INTO swessb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hur kan ni tro, när ni tar emot ära från varandra och inte söker äran från den ende Guden? ");
INSERT INTO swessb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tänk er inte att jag ska anklaga er hos Fadern. Det finns den som anklagar er: Mose, till vilken ni har satt hopp. ");
INSERT INTO swessb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","För om ni trodde Mose hade ni trott mig, för det är om mig denne har skrivit. ");
INSERT INTO swessb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Men om ni inte tror dennes texter, hur ska ni tro mina ord?” ");
INSERT INTO swessb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Efter detta for Jesus iväg till andra sidan Galileiska havet, Tiberias hav. ");
INSERT INTO swessb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Och en stor skara följde honom, eftersom de skådade tecknen som han gjorde på de sjuka. ");
INSERT INTO swessb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Men Jesus gick upp till berget, och där satt han med sina lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Och påsken var nära, judarnas högtid. ");
INSERT INTO swessb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus lyfter nu ögonen och skådar att en stor skara kommer till honom, och han säger till Filippus: ”Varifrån ska vi köpa bröd så att dessa kan äta?” ");
INSERT INTO swessb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Men detta sade han testande ­honom, för själv visste han vad han skulle göra. ");
INSERT INTO swessb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippus svarade honom: ”Bröd för tvåhundra denarer räcker inte för dem, så att var och en får något litet.” ");
INSERT INTO swessb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Då säger honom en av hans lärjungar, Andreas, bror till Simon Petrus: ");
INSERT INTO swessb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","”Det finns en liten gosse här som har fem kornbröd och två matfiskar. Men detta, vad är det till så många?” ");
INSERT INTO swessb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus sade: ”Gör så att människorna ligger till bords.” Och det fanns mycket gräs på platsen. Nu lade sig männen till bords, till antalet omkring femtusen. ");
INSERT INTO swessb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Då tog Jesus bröden och tackade och gav ut till dem som låg till bords, likaså även av matfiskarna, så mycket de ville. ");
INSERT INTO swessb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Och när de var mätta, säger han till sina lärjungar: ”Samla ihop de överblivna bitarna så att inget går förlorat.” ");
INSERT INTO swessb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","De samlade då och fyllde tolv korgar med bitar från de fem kornbröden som blev över för dem som hade spisat. ");
INSERT INTO swessb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","När människorna nu såg det han gjort som tecken, sade de att: ”Denne är sannerligen Profeten som kommer till världen!” ");
INSERT INTO swessb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus förstod då att de kommer att komma och rycka honom för att göra till kung, och han drog sig åter undan till berget, själv ensam. ");
INSERT INTO swessb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Men när det blev kväll, gick hans lärjungar ner till havet ");
INSERT INTO swessb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","och steg i en båt och började fara till andra sidan havet, till Kapernaum. Och mörker hade det redan blivit, och ännu hade inte Jesus kommit till dem. ");
INSERT INTO swessb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Och havet väcktes upp av en väldig vind som blåste. ");
INSERT INTO swessb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","När de nu hade rott omkring tjugofem eller trettio stadier, skådar de Jesus vandra på havet och komma nära båten. Och de fruktade. ");
INSERT INTO swessb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Men han säger till dem: ”Jag Är. Frukta inte!” ");
INSERT INTO swessb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","De ville då ta emot honom i båten, och direkt var båten vid det land till vilket de begav sig. ");
INSERT INTO swessb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dagen därpå såg skaran som stod på andra sidan havet att någon annan småbåt inte fanns där utom en, och att Jesus inte gått in med sina lärjungar i båten, utan att hans lärjungar ensamma farit iväg. ");
INSERT INTO swessb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Andra småbåtar kom från Tiberias, nära platsen där de ätit brödet sedan Herren tackat. ");
INSERT INTO swessb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","När skaran nu såg att Jesus inte är där, inte heller hans lärjungar, steg de själva i småbåtarna och kom till Kapernaum sökande Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Och när de fann honom på andra sidan havet, sade de till honom: ”Rabbi, när kom du hit?” ");
INSERT INTO swessb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus svarade dem och sade: ”Amen amen, jag säger er: Ni söker mig inte för att ni har sett tecken, utan för att ni åt av bröden och blev mätta. ");
INSERT INTO swessb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Arbeta inte för den mat som går förlorad, utan för den mat som består till eoniskt liv, som Människosonen ska ge er. För på honom har Fadern, Gud, satt sigill.” ");
INSERT INTO swessb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","De sade då till honom: ”Vad ska vi göra för att utföra Guds verk?” ");
INSERT INTO swessb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus svarade och sade till dem: ”Detta är Guds verk: att ni tror på denne som han har sänt.” ");
INSERT INTO swessb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","De sade då till honom: ”Vad gör då du som tecken, så att vi kan se och tro på dig? Vad utför du? ");
INSERT INTO swessb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Våra fäder åt mannat i ödemarken, liksom det är skrivet: Bröd från himlen gav han dem att äta.” ");
INSERT INTO swessb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Då sade Jesus till dem: ”Amen amen, jag säger er: Det är inte Mose som har gett er brödet från himlen, utan min Far ger er brödet från himlen, det sannfärdiga. ");
INSERT INTO swessb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","För Guds bröd är den som kommer ner från himlen och ger världen liv.” ");
INSERT INTO swessb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","De sade då till honom: ”Herre, ge oss alltid detta bröd!” ");
INSERT INTO swessb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus sade till dem: ”Jag är livets bröd. Den som kommer till mig ska aldrig hungra, och den som tror på mig ska aldrig någonsin törsta. ");
INSERT INTO swessb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Men jag har sagt er att ni till och med har sett mig och tror inte. ");
INSERT INTO swessb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Allt som Fadern ger mig ­ska komma till mig, och den som kommer till mig ska jag aldrig driva ut utanför. ");
INSERT INTO swessb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","För jag har kommit ner från himlen inte för att göra min vilja, utan viljan hos honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Och detta är viljan hos honom som skickat mig: att allt som han gett mig, jag ska inte förlora något av det utan låta det uppstå på den sista dagen. ");
INSERT INTO swessb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","För detta är min Fars vilja: att var och en som skådar Sonen och tror på honom ska ha eoniskt liv. Och jag ska låta honom uppstå på den sista dagen.” ");
INSERT INTO swessb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Då muttrade judarna över honom, att han sagt: ”Jag är brödet som kommit ner från himlen.” ");
INSERT INTO swessb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Och de sade: ”Är inte denne Jesus, Josefs son vars far och mor vi känner? Hur kan han nu säga att: Från himlen har jag kommit ner?” ");
INSERT INTO swessb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus svarade och sade till dem: ”Muttra inte med varandra. ");
INSERT INTO swessb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ingen kan komma till mig om inte Fadern som skickat mig drar honom. Och jag ska låta honom uppstå på den sista dagen. ");
INSERT INTO swessb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Det är skrivet hos profeterna: Och alla ska vara lärda av Gud. Var och en som har hört från Fadern och lärt kommer till mig. ");
INSERT INTO swessb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inte att någon har sett Fadern, utom han som är från Gud. Denne har sett Fadern. ");
INSERT INTO swessb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Amen amen, jag säger er: Den som tror har eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jag är livets bröd. ");
INSERT INTO swessb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Era fäder åt mannat i ödemarken och dog. ");
INSERT INTO swessb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Detta är brödet som kommer ner från himlen, för att man ska äta av det och inte dö. ");
INSERT INTO swessb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jag är det levande brödet som har kommit ner från himlen. Om någon äter av detta bröd ska han leva till eonen. Och brödet som jag ska ge är mitt kött, för världens liv.” ");
INSERT INTO swessb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Då bråkade judarna med varandra och sade: ”Hur kan denne ge oss sitt kött att äta?” ");
INSERT INTO swessb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus sade då till dem: ”Amen amen, jag säger er: Om ni inte äter Människosonens kött och dricker hans blod har ni inte liv i er. ");
INSERT INTO swessb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Den som tuggar mitt kött och dricker mitt blod har eoniskt liv. Och jag ska låta honom uppstå på den sista dagen. ");
INSERT INTO swessb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","För mitt kött är sann mat och mitt blod är sann dryck. ");
INSERT INTO swessb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Den som tuggar mitt kött och dricker mitt blod förblir i mig och jag i honom. ");
INSERT INTO swessb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Så som den levande Fadern har sänt mig och jag lever av Fadern, ska den som tuggar mig också den leva av mig. ");
INSERT INTO swessb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Detta är brödet som har kommit ner från himlen. Inte så som fäderna åt och dog. Den som tuggar detta bröd ska leva till eonen.” ");
INSERT INTO swessb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Detta sade han i synagogan när han under­visade i Kapernaum. ");
INSERT INTO swessb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Många av hans lärjungar som lyssnade sade då: ”Hårt är detta ord. Vem kan lyssna till honom?” ");
INSERT INTO swessb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Men Jesus visste inom sig att hans lärjungar muttrar över detta, och sade till dem: ”Detta skandaliserar er? ");
INSERT INTO swessb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Om ni då skådar Människosonen stiga upp där han var tidigare? ");
INSERT INTO swessb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anden är den som levandegör. Köttet gör ingen nytta. Orden som jag talat till er är Ande och är liv. ");
INSERT INTO swessb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Men det finns några av er som inte tror.” För Jesus visste från begynnelsen vilka det är som inte tror och vem det är som kommer att utlämna honom. ");
INSERT INTO swessb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Och han sade: ”Därför har jag sagt er att ingen kan komma till mig om det inte är honom givet från Fadern.” ");
INSERT INTO swessb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Från detta gick många av hans lärjungar bort bakåt och vandrade inte längre med honom. ");
INSERT INTO swessb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Då sade Jesus till de tolv: ”Inte vill ni också bege er?” ");
INSERT INTO swessb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus svarade honom: ”Herre, till vem ska vi gå bort? Du har ord av eoniskt liv, ");
INSERT INTO swessb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","och vi har kommit till tro och förstått att du är Guds Helige.” ");
INSERT INTO swessb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus svarade dem: ”Har inte jag utvalt er, de tolv? Och en av er är en djävul.” ");
INSERT INTO swessb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Men han talade om Judas Simon Iskariots son, för denne skulle utlämna honom: en av de tolv. ");
INSERT INTO swessb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Och efter detta vandrade Jesus i Galileen. För han ville inte vandra i Judeen, eftersom judarna sökte döda honom. ");
INSERT INTO swessb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Och judarnas högtid var nära, lövhyddohögtiden. ");
INSERT INTO swessb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hans bröder sade då till honom: ”Gå vidare härifrån och bege dig till Judeen, så att också dina lärjungar får skåda dina gärningar som du gör. ");
INSERT INTO swessb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","För ingen gör något i det fördolda och söker själv vara i öppenhet. Om du gör dessa ting, visa dig för världen.” ");
INSERT INTO swessb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","För inte heller hans bröder trodde på honom. ");
INSERT INTO swessb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus säger då till dem: ”Min tid är ännu inte här. Men er tid är alltid beredd. ");
INSERT INTO swessb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Världen kan inte hata er. Men mig hatar den, eftersom jag vittnar om den att dess gärningar är elaka. ");
INSERT INTO swessb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gå ni upp till högtiden. Jag går ännu inte upp till denna högtid, eftersom min tid ännu inte är uppfylld.” ");
INSERT INTO swessb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Och detta sade han och blev själv kvar i Galileen. ");
INSERT INTO swessb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Men när hans bröder hade gått upp till högtiden, då gick han också själv upp, inte uppenbart utan som i det fördolda. ");
INSERT INTO swessb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judarna sökte honom nu under högtiden och sade: ”Var är denne?” ");
INSERT INTO swessb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Och det var mycket muttrande om honom bland skarorna. Några sade att: ”Han är god.” Men andra sade: ”Nej, utan han förvillar skaran.” ");
INSERT INTO swessb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ingen talade dock öppet om honom, av fruktan för judarna. ");
INSERT INTO swessb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Men när det redan var i mitten av högtiden, gick Jesus upp till templet och började undervisa. ");
INSERT INTO swessb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Då blev judarna förundrade och sade: ”Hur kan denne känna texter som inte är lärd?” ");
INSERT INTO swessb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Då svarade Jesus dem och sade: ”Min undervisning är inte min, utan från honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Om någon vill göra hans vilja, ska han förstå gällande undervisningen ifall den är från Gud eller jag talar av mig själv. ");
INSERT INTO swessb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Den som talar av sig själv söker den egna äran. Men den som söker äran för honom som har skickat ­honom, denne är sann och orätt finns inte i honom. ");
INSERT INTO swessb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Har inte Mose gett er lagen? Och ingen av er gör lagen. Varför söker ni döda mig?” ");
INSERT INTO swessb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Skaran svarade: ”En demon har du. Vem söker döda dig?” ");
INSERT INTO swessb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus svarade och sade till dem: ”En enda gärning gjorde jag, och alla blev ni förundrade. ");
INSERT INTO swessb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Därför har Mose gett er omskärelsen – inte för att den är från Mose, utan från fäderna – och på sabbaten omskär ni en människa. ");
INSERT INTO swessb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Om en människa får omskärelse på sabbaten, för att Mose lag inte ska upplösas, blir ni ilskna på mig för att jag gjort en hel människa frisk på en sabbat? ");
INSERT INTO swessb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Döm inte efter åsyn, utan den rättfärdiga domen ska ni döma.” ");
INSERT INTO swessb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Då sade några av jerusalemiterna: ”Är inte denne den de söker döda? ");
INSERT INTO swessb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Och se: han talar öppet och de säger inget till honom. Kanske har ledarna sannerligen förstått att denne är Kristus? ");
INSERT INTO swessb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nej, denne känner vi varifrån han är. Men när Kristus kommer vet ingen varifrån han är.” ");
INSERT INTO swessb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus ropade då i templet medan han undervisade och sade: ”Ni både känner mig och känner varifrån jag är! Och det är inte av mig själv jag har kommit, utan det finns en sannfärdig som har skickat mig, som ni inte känner. ");
INSERT INTO swessb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jag känner honom, eftersom jag är från honom och denne har sänt mig.” ");
INSERT INTO swessb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","De sökte då fånga honom. Och ingen lade handen på honom, eftersom hans stund ännu inte hade kommit. ");
INSERT INTO swessb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Men av skaran kom många till tro på honom och sade: ”När Kristus kommer, inte ska han göra fler tecken än dem denne har gjort?” ");
INSERT INTO swessb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseerna hörde skaran muttra detta om honom, och översteprästerna och fariseerna sände ut undertjänare för att fånga honom. ");
INSERT INTO swessb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Då sade Jesus: ”Ännu en liten tid är jag hos er, och beger mig sedan till honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ni ska söka mig och inte finna mig, och dit där jag är kan ni inte komma.” ");
INSERT INTO swessb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Då sade judarna till varann: ”Vart kommer denne att gå, eftersom vi inte ska finna honom? Inte är det till grekernas diaspora han kommer att gå och undervisa grekerna? ");
INSERT INTO swessb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Vad är detta ord som han sade: Ni ska söka mig och inte finna mig, och dit där jag är kan ni inte komma?” ");
INSERT INTO swessb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Men på den sista dagen, den stora i högtiden, stod Jesus och ropade och sade: ”Om någon törstar, ska han komma till mig och dricka! ");
INSERT INTO swessb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Den som tror på mig, så som Skriften har sagt, floder ska flöda ur hans buk med levande vatten.” ");
INSERT INTO swessb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Och detta sade han om Anden, som de skulle få som trodde på honom. För ännu fanns ingen Ande, eftersom Jesus ännu inte blivit förhärligad. ");
INSERT INTO swessb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Några ur skaran som hörde dessa ord sade då: ”Denne är sannerligen Profeten.” ");
INSERT INTO swessb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Andra sade: ”Denne är Kristus”, men andra sade: ”Det är väl inte från Galileen Kristus kommer? ");
INSERT INTO swessb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Har inte Skriften sagt att det är av Davids säd och från Betlehem, byn där David var, som Kristus kommer?” ");
INSERT INTO swessb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Det blev då schism i skaran för hans skull. ");
INSERT INTO swessb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Och några av dem ville fånga honom, men ingen lade händerna på honom. ");
INSERT INTO swessb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Då kom undertjänarna till översteprästerna och fariseerna, och dessa sade till dem: ”Varför har ni inte hämtat honom?” ");
INSERT INTO swessb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Undertjänarna svarade: ”Aldrig har en människa talat så.” ");
INSERT INTO swessb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Då svarade fariseerna dem: ”Inte har ni också blivit förvillade? ");
INSERT INTO swessb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Inte har väl någon av ledarna trott på honom? Eller av ­fariseerna? ");
INSERT INTO swessb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Men denna skara som inte känner lagen, de är förbannade.” ");
INSERT INTO swessb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus säger till dem, han som kom till honom tidigare, som var en av dem: ");
INSERT INTO swessb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","”Inte dömer vår lag människan om man inte först hör från honom och förstår vad han gör?” ");
INSERT INTO swessb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","De svarade och sade till honom: ”Inte är väl också du från Galileen? Forska och se att från Galileen reses ingen profet upp.” ");
INSERT INTO swessb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","⟦Och var och en gick till sitt hus, ");
INSERT INTO swessb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","och Jesus gick till Olivberget. ");
INSERT INTO swessb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Men i gryningen kom han åter dit till templet. Och hela folket kom till honom, och han satte sig och undervisade dem. ");
INSERT INTO swessb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Men de skriftlärda och fariseerna för dit en kvinna gripen vid äktenskapsbrott. Och de ställer henne i mitten ");
INSERT INTO swessb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","och säger till honom: ”Lärare, denna kvinna är gripen på bar gärning när hon begick äktenskapsbrott. ");
INSERT INTO swessb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Och i lagen har Mose påbjudit oss att stena sådana. Vad säger då du?” ");
INSERT INTO swessb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Men detta sade de testande honom, för att ha något att anklaga honom för. Men Jesus böjde sig ner, och med fingret skrev han ner i jorden. ");
INSERT INTO swessb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Men när de fortsatte fråga honom, rätade han sig upp och sade till dem: ”Den syndfrie av er ska vara först på henne att kasta sten.” ");
INSERT INTO swessb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Och åter böjde han sig ner och skrev i jorden. ");
INSERT INTO swessb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Men när de hörde det gick de ut, en efter en, börjande från de äldste. Och han lämnades kvar ensam, och kvinnan var i mitten. ");
INSERT INTO swessb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Och Jesus rätade sig upp och sade till henne: ”Kvinna, var är de? Har ingen fördömt dig?” ");
INSERT INTO swessb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Och hon svarade: ”Ingen, Herre.” Och Jesus sade: ”Inte heller jag fördömer dig. Gå, och från nu: synda inte mer.”⟧ ");
INSERT INTO swessb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Åter talade nu Jesus till dem och sade: ”Jag är världens ljus. Den som följer mig ska aldrig vandra i mörkret, utan ha livets ljus.” ");
INSERT INTO swessb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Då sade fariseerna till honom: ”Du vittnar om dig själv. Ditt vittnesbörd är inte sant.” ");
INSERT INTO swessb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus svarade och sade till dem: ”Även om jag vittnar om mig själv är mitt vittnesbörd sant, för jag vet varifrån jag kommit och vart jag beger mig. Men ni vet inte varifrån jag kommer eller vart jag beger mig. ");
INSERT INTO swessb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ni dömer efter köttet. Jag dömer ingen. ");
INSERT INTO swessb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Men även om jag dömer är min dom sannfärdig, för jag är inte ensam, utan det är jag och Fadern som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Men även i er lag är det skrivet att två människors vittnesbörd är sant. ");
INSERT INTO swessb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jag är den som vittnar om mig själv, och vittnar om mig göräven Fadern som har skickat mig.” ");
INSERT INTO swessb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","De sade då till honom: ”Var är din Far?” Jesus svarade: ”Varken mig känner ni eller min Far. Om ni hade känt mig, hade ni också känt min Far.” ");
INSERT INTO swessb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dessa ord talade han i skattkammaren när han undervisade i templet. Och ingen fångade honom, eftersom hans stund ännu inte hade kommit. ");
INSERT INTO swessb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Han sade då åter till dem: ”Jag beger mig. Och ni kommer att söka mig, och i er synd kommer ni att dö. Dit jag beger mig kan ni inte komma.” ");
INSERT INTO swessb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Då sade judarna: ”Inte kommer han väl att döda sig själv? Eftersom han säger: Dit jag beger mig kan ni inte komma.” ");
INSERT INTO swessb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Och han sade till dem: ”Ni är nerifrån, jag är från ovan. Ni är av denna värld, jag är inte av denna värld. ");
INSERT INTO swessb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jag har nu sagt er att ni kommer att dö i era synder. För om ni inte tror att Jag Är, kommer ni att dö i era synder.” ");
INSERT INTO swessb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Då sade de till honom: ”Vem är du?” Jesus sade till dem: ”Från begynnelsen det jag också talar till er. ");
INSERT INTO swessb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mycket har jag att säga och döma om er. Men han som har skickat mig är sann, och det jag hört från honom, det talar jag till världen.” ");
INSERT INTO swessb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","De förstod inte att det var om Fadern han talade till dem. ");
INSERT INTO swessb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Då sade Jesus till dem: ”När ni har upphöjt Människosonen, då ska ni förstå att Jag Är. Och av mig själv gör jag inget, utan så som Fadern har lärt mig, det talar jag. ");
INSERT INTO swessb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Och han som har skickat mig är med mig. Han har inte lämnat mig ensam, eftersom jag gör det som är till behag för honom, alltid.” ");
INSERT INTO swessb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","När han talade detta kom många till tro på honom. ");
INSERT INTO swessb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Då sade Jesus till de judar som hade kommit till tro på honom: ”Om ni blir kvar i mitt ord är ni sannerligen mina lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Och ni ska lära känna sanningen, och sanningen ska befria er.” ");
INSERT INTO swessb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","De svarade till honom: ”Abra­hams säd är vi och har aldrig någonsin fasttjänat någon. Hur kan du säga att: Ni ska bli fria?” ");
INSERT INTO swessb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus svarade dem: ”Amen amen, jag säger er att var och en som gör synden är fasttjänare under synden. ");
INSERT INTO swessb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Och fasttjänaren blir inte kvar i huset till eonen. Sonen blir kvar till eonen. ");
INSERT INTO swessb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Om nu Sonen befriar er, blir ni verkligen fria. ");
INSERT INTO swessb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jag vet att ni är Abrahams säd. Men ni söker döda mig, eftersom mitt ord inte har rum i er. ");
INSERT INTO swessb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Det jag har sett hos Fadern talar jag. Och ni gör alltså det ni har hört från fadern.” ");
INSERT INTO swessb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","De svarade och sade till honom: ”Vår far är Abraham.” Jesus säger till dem: ”Om ni är Abrahams barn, hade ni gjort Abra­hams gärningar. ");
INSERT INTO swessb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Men nu söker ni döda mig, en människa som har talat sanningen till er som jag hört från Gud. Detta gjorde inte Abraham. ");
INSERT INTO swessb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ni gör er fars gärningar.” De sade då till honom: ”Vi är inte avlade ur otukt! Vi har en enda far: Gud.” ");
INSERT INTO swessb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus sade till dem: ”Om Gud var er Far hade ni älskat mig, för det är från Gud jag har utgått och kommit. För jag har inte kommit av mig själv, utan denne har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Varför förstår ni inte mitt tal? Eftersom ni inte kan höra mitt ord. ");
INSERT INTO swessb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ni är av fadern djävulen, och er fars begär vill ni göra. Denne var en mandråpare från begynnelsen och står inte i sanningen, för det finns ingen sanning i honom. När han talar lögnen är det utifrån sitt eget han talar, eftersom han är en lögnare och dess fader. ");
INSERT INTO swessb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Men eftersom jag säger sanningen, tror ni mig inte. ");
INSERT INTO swessb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Vem av er tillrättavisar mig för synd? Om jag talar sanning, varför tror ni mig inte? ");
INSERT INTO swessb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Den som är av Gud hör Guds ord. Därför hör ni inte, eftersom ni inte är av Gud.” ");
INSERT INTO swessb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judarna svarade och sade till honom: ”Är det inte med rätta vi säger att du är samarier och har en demon?” ");
INSERT INTO swessb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus svarade: ”Jag har inte en demon, utan jag hedrar min Far och ni vanhedrar mig. ");
INSERT INTO swessb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Och jag söker inte min ära. Det finns den som söker den och dömer. ");
INSERT INTO swessb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Amen amen, jag säger er: Om någon håller fast vid mitt ord, ska han aldrig skåda döden till eonen.” ");
INSERT INTO swessb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Då sade judarna till honom: ”Nu har vi förstått att du har en demon. Abraham dog, även profeterna. Och du säger: Om någon håller fast vid mitt ord, ska han aldrig smaka döden till eonen. ");
INSERT INTO swessb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Inte är du större än vår far Abraham, som dog? Och profeterna dog. Vem gör du dig till?” ");
INSERT INTO swessb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus svarade: ”Om jag ärar mig själv är min ära ingenting. Det är min Far som ärar mig, han som ni säger att: Han är vår Gud. ");
INSERT INTO swessb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Och ni har inte lärt känna honom, men jag känner honom. Och om jag skulle säga att jag inte känner honom blir jag lik er, en lögnare. Men jag känner honom och håller fast vid hans ord. ");
INSERT INTO swessb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham er far jublade över att få se min dag. Och han såg och gladde sig.” ");
INSERT INTO swessb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Då sade judarna till honom: ”Femtio år har du inte än, och Abraham har du sett?” ");
INSERT INTO swessb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus sade till dem: ”Amen amen, jag säger er: Innan Abraham blev till: Jag Är.” ");
INSERT INTO swessb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Då tog de upp stenar för att kasta på honom. Men Jesus dolde sig och gick ut från templet. ");
INSERT INTO swessb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Och han passerade och såg en man blind från födseln. ");
INSERT INTO swessb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Och då frågade honom hans lärjungar och sade: ”Rabbi, vem har syndat? Denne eller hans föräldrar, så att han föddes blind? ” ");
INSERT INTO swessb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus svarade: ”Det är varken denne som har syndat eller hans föräldrar, utan det är för att Guds verk ska visas genom honom. ");
INSERT INTO swessb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vi måste utföra hans gärningar som har skickat mig medan det är dag. Det kommer en natt när ingen kan verka. ");
INSERT INTO swessb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Medan jag är i världen är jag världens ljus.” ");
INSERT INTO swessb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","När han hade sagt detta, spottade han på marken och gjorde en deg av saliven och smorde på degen på hans ögon ");
INSERT INTO swessb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","och sade till honom: ”Bege dig, tvätta dig i dammen Siloam”, vilket översätts Utsänd. Han gick då iväg och tvättade sig, och kom sedan seende. ");
INSERT INTO swessb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Grannarna och de som skådade honom tidigare, att han var tiggare, sade då: ”Är inte denne han som sitter och tigger?” ");
INSERT INTO swessb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Andra sade att: ”Det är han”, andra sade: ”Nej, men han är lik honom.” Denne sade att: ”Det är jag.” ");
INSERT INTO swessb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Då sade de till honom: ”Hur öppnades då dina ögon?” ");
INSERT INTO swessb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Denne svarade: ”Mannen som kallas Jesus gjorde en deg och smorde på mina ögon och sade till mig att: Bege dig till Siloam och tvätta dig. Jag gick då iväg, och när jag tvättat mig såg jag igen.” ");
INSERT INTO swessb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Och de sade till honom: ”Var är denne?” Han säger: ”Jag vet inte.” ");
INSERT INTO swessb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","De för honom till fariseerna, den en gång blinde. ");
INSERT INTO swessb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Men det var sabbat på den dagen Jesus gjorde degen och öppnade hans ögon. ");
INSERT INTO swessb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Åter frågade honom då även fariseerna hur han såg igen. Och han sade till dem: ”En deg lade han på mina ögon, och jag tvättade mig och ser.” ");
INSERT INTO swessb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Då sade några av fariseerna: ”Inte är den där människan från Gud, eftersom han inte håller fast vid sabbaten.” Men andra sade: ”Hur kan en syndig människa göra sådana tecken?” Och det var schism bland dem. ");
INSERT INTO swessb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","De säger nu till den blinde igen: ”Vad säger du om honom, eftersom han öppnade dina ögon?” Och han sade att: ”En profet är han.” ");
INSERT INTO swessb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Då trodde inte judarna om honom att han var blind och såg igen, förrän de hade ropat dit föräldrarna till honom som såg igen ");
INSERT INTO swessb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","och frågat dem och sagt: ”Är denne er son, som ni säger att han fötts blind? Hur ser han då nu?” ");
INSERT INTO swessb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Då svarade hans föräldrar och sade: ”Vi vet att denne är vår son och att han fötts blind. ");
INSERT INTO swessb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Men hur han nu ser vet vi inte, eller vem som har öppnat hans ögon. Vi vet inte. Fråga honom. Han har åldern inne. Han ska tala för sig själv.” ");
INSERT INTO swessb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Detta sade hans föräldrar eftersom de fruktade judarna. För redan hade judarna kommit överens att om någon bekänner honom som Kristus, ska han bli avsynagogad. ");
INSERT INTO swessb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Det var därför hans föräldrar sade att: ”Han har åldern inne. Fråga honom.” ");
INSERT INTO swessb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","De ropade då dit mannen en andra gång som varit blind och sade till honom: ”Ge ära till Gud. Vi vet att den där människan är en syndare.” ");
INSERT INTO swessb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Då svarade denne: ”Om han är en syndare vet jag inte. Ett vet jag: att jag var blind och nu ser.” ");
INSERT INTO swessb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","De sade då till honom: ”Vad gjorde han med dig? Hur öppnade han dina ögon?” ");
INSERT INTO swessb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Han svarade dem: ”Jag har sagt er redan och ni har inte hört. Varför vill ni åter höra? Inte vill också ni bli hans lärjungar?” ");
INSERT INTO swessb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Och de hånade honom och sade: ”Du är dennes lärjunge! Men vi är Moses lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Vi vet att till Mose har Gud talat. Men denne vet vi inte varifrån han är.” ");
INSERT INTO swessb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mannen svarade och sade till dem: ”För i detta är det förunderliga: att ni inte vet varifrån han är, och han har öppnat mina ögon! ");
INSERT INTO swessb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vi vet att till syndare lyssnar inte Gud. Men om någon är gudsfrom och gör hans vilja, till denne lyssnar han. ");
INSERT INTO swessb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Från eonen har det aldrig hörts att någon öppnat ögonen på en som fötts blind. ");
INSERT INTO swessb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Om inte denne var från Gud, hade han inte kunnat göra någonting.” ");
INSERT INTO swessb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","De svarade och sade till honom: ”I synder föddes du helt, och du undervisar oss!” Och de drev ut ­honom utanför. ");
INSERT INTO swessb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus hörde att de hade drivit ut honom utanför, och fann honom och sade: ”Tror du på Människosonen?” ");
INSERT INTO swessb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Denne svarade och sade: ”Och vem är han, Herre? Så att jag kan tro på honom.” ");
INSERT INTO swessb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus sade till honom: ”Och du har sett honom. Och han som talar med dig, denne är det.” ");
INSERT INTO swessb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Och han sade: ”Jag tror, Herre.” Och han tillbad honom. ");
INSERT INTO swessb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Och Jesus sade: ”Till en dom har jag kommit till denna värld, för att de som inte ser ska se och de som ser ska bli blinda.” ");
INSERT INTO swessb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Då hörde några av fariseerna detta som var med honom och sade till honom: ”Inte är vi också blinda?” ");
INSERT INTO swessb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus sade till dem: ”Om ni var blinda, hade ni inte haft synd. Men nu säger ni att ni ser. Er synd är kvar. ");
INSERT INTO swessb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Amen amen, jag säger er: Den som inte kommer in genom dörren till fårens fålla utan går upp från annat håll, denne är en tjuv och en rövare. ");
INSERT INTO swessb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Men den som går in genom dörren är fårens herde. ");
INSERT INTO swessb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","För denne öppnar dörrvakten, och fåren lyssnar till hans röst. Och på sina egna får ropar han vid namn och för ut dem. ");
INSERT INTO swessb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","När han har drivit ut alla de egna går han före dem. Och fåren följer honom, eftersom de känner hans röst. ");
INSERT INTO swessb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Men en främling kommer de aldrig att följa, utan flyr från honom. För de känner inte främlingarnas röst.” ");
INSERT INTO swessb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Med denna jämförelse talade Jesus till dem, men dessa förstod inte vad det var han sade till dem. ");
INSERT INTO swessb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus sade då åter: ”Amen amen, jag säger er att: Jag är dörren för fåren. ");
INSERT INTO swessb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Alla som har kommit före mig är tjuvar och rövare, men fåren har inte lyssnat till dem. ");
INSERT INTO swessb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jag är dörren. Genom mig, om någon går in, ska han bli frälst. Och han ska gå in och gå ut och finna bete. ");
INSERT INTO swessb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tjuven kommer inte utom för att stjäla och slaktoffra och förgöra. Jag har kommit för att de ska ha liv, och ha överflöd. ");
INSERT INTO swessb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jag är den bra herden. Den bra herden lägger ner sin själ för fåren. ");
INSERT INTO swessb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Den som är anställd och inte herde, för vilken fåren inte är egna, skådar vargen komma och lämnar fåren och flyr. Och vargen rycker dem och skingrar. ");
INSERT INTO swessb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","För han är anställd och bryr sig inte om fåren. ");
INSERT INTO swessb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jag är den bra herden. Och jag känner de mina, och de mina känner mig, ");
INSERT INTO swessb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","liksom Fadern känner mig och jag känner Fadern. Och min själ lägger jag ner för fåren. ");
INSERT INTO swessb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Också andra får har jag, som inte är av denna fålla. Också dessa måste jag leda, och min röst ska de lyssna till. Och det ska bli en hjord, en herde. ");
INSERT INTO swessb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Därför älskar Fadern mig, för att jag lägger ner min själ för att åter ta den. ");
INSERT INTO swessb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ingen tar bort den från mig, utan jag lägger ner den av mig själv. Auktoritet har jag att lägga ner den, och auktoritet har jag att åter ta den. Detta bud har jag fått från min Far.” ");
INSERT INTO swessb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Åter blev det schism bland judarna på grund av dessa ord. ");
INSERT INTO swessb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Och många av dem sade: ”En demon har han och är galen. Varför lyssnar ni på honom?” ");
INSERT INTO swessb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Andra sade: ”Dessa ord är inte från en demoniserad. Inte kan en demon öppna blindas ögon?” ");
INSERT INTO swessb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sedan kom tempelinvigningshögtiden i Jerusalem. Det var vinter, ");
INSERT INTO swessb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","och Jesus vandrade omkring i templet i Salomos pelarhall. ");
INSERT INTO swessb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Då omringade honom judarna och sade till honom: ”Hur länge tar du upp vår själ? Om du är Kristus, säg oss öppet!” ");
INSERT INTO swessb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus svarade dem: ”Jag har sagt er och ni tror inte. Gärningarna som jag gör i min Fars namn, dessa vittnar om mig. ");
INSERT INTO swessb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Men ni tror inte, eftersom ni inte är av mina får. ");
INSERT INTO swessb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mina får lyssnar till min röst, och jag känner dem och de följer mig. ");
INSERT INTO swessb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Och jag ger dem eoniskt liv, och de ska aldrig gå förlorade till eonen. Och ingen ska rycka dem ur min hand. ");
INSERT INTO swessb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Min Far, det han har gett mig är större än allt, och ingen kan rycka ur Faderns hand. ");
INSERT INTO swessb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jag och Fadern är ett.” ");
INSERT INTO swessb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Åter bar judarna stenar för att stena honom. ");
INSERT INTO swessb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus svarade dem: ”Många fina gärningar har jag visat er från Fadern. För vilken gärning av dem stenar ni mig?” ");
INSERT INTO swessb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judarna svarade honom: ”Det är inte för en fin gärning vi stenar dig, utan för hädelse. Och för att du som är en människa gör dig själv till Gud.” ");
INSERT INTO swessb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus svarade dem: ”Är det inte skrivet i er lag att: Jag har sagt ni är gudar? ");
INSERT INTO swessb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Om han kallade dessa gudar till vilka Guds ord kom – och Skriften kan inte upplösas – ");
INSERT INTO swessb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","säger ni då till den som Fadern har helgat och sänt till världen att: Du hädar, eftersom jag sagt: Jag är Guds Son? ");
INSERT INTO swessb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Om jag inte gör min Fars gärningar, tro mig inte. ");
INSERT INTO swessb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Men om jag gör dem, även om ni inte tror på mig, tro på gärningarna så att ni lär känna och förstår att Fadern är i mig och jag i Fadern.” ");
INSERT INTO swessb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Då sökte de åter fånga honom, och han gick ut ur deras hand. ");
INSERT INTO swessb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Och han gick åter bort till andra sidan Jordan, till platsen där Johannes var först och döpte, och blev kvar där. ");
INSERT INTO swessb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Och många kom till honom, och de sade att: ”Johannes gjorde visserligen inget tecken, men allt vad Johannes sade om denne var sant.” ");
INSERT INTO swessb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Och många kom till tro på honom där. ");
INSERT INTO swessb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Men det fanns en sjuk, Lasarus från Betania, från byn hos Maria och Marta, hennes syster. ");
INSERT INTO swessb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Och det var Maria som smorde in Herren med balsam och torkade av hans fötter med sitt hår. Hennes bror Lasarus var sjuk. ");
INSERT INTO swessb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Då sände systrarna till honom och sade: ”Herre, se: den du gillar är sjuk.” ");
INSERT INTO swessb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Men när Jesus hörde det, sade han: ”Denna sjukdom är inte till döds utan för Guds ära, för att Guds Son ska bli förhärligad genom den.” ");
INSERT INTO swessb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Och Jesus älskade Marta och hennes syster och Lasarus. ");
INSERT INTO swessb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","När han nu hörde att han är sjuk, då blev han först kvar på platsen där han var två dagar. ");
INSERT INTO swessb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sedan efter detta säger han till lärjungarna: ”Låt oss dra till Judeen igen.” ");
INSERT INTO swessb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lärjungarna säger till honom: ”Rabbi, nu sökte judarna stena dig. Och åter beger du dig dit?” ");
INSERT INTO swessb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus svarade: ”Finns det inte tolv timmar under dagen? Om någon vandrar om dagen stöter han inte emot, eftersom han ser denna världs ljus. ");
INSERT INTO swessb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Men om någon vandrar om natten stöter han emot, eftersom ljuset inte finns i honom.” ");
INSERT INTO swessb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Detta sade han, och efter detta säger han till dem: ”Lasarus vår vän har insomnat. Men jag går för att väcka honom ur sömnen.” ");
INSERT INTO swessb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Då sade lärjungarna till honom: ”Herre, om han har insomnat ska han bli frälst.” ");
INSERT INTO swessb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Men Jesus hade sagt det om hans död, men dessa tänkte sig att det är om sömnens insomnande han talar. ");
INSERT INTO swessb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Då sade nu Jesus till dem öppet: ”Lasarus har dött. ");
INSERT INTO swessb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Och jag är glad för er skull, för att ni ska tro, att jag inte var där. Men låt oss dra till honom.” ");
INSERT INTO swessb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Då sade Tomas som kallades Tvillingen till medlärjungarna: ”Låt oss dra, också vi, för att dö med honom.” ");
INSERT INTO swessb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","När Jesus nu kom, fann han att han redan hade fyra dagar i graven. ");
INSERT INTO swessb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Och Betania var nära Jerusalem, ungefär femtio stadier bort. ");
INSERT INTO swessb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Och mån­ga av judarna hade kommit till Marta och Maria för att uppmuntra dem gällande brodern. ");
INSERT INTO swessb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta, när hon nu hörde att Jesus kommer, mötte honom. Men Maria satt i huset. ");
INSERT INTO swessb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Då sade Marta till Jesus: ”Herre, om du varit här hade inte min bror dött. ");
INSERT INTO swessb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Men också nu vet jag att vad du än ber Gud om ska Gud ge dig.” ");
INSERT INTO swessb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus säger till henne: ”Din bror ska uppstå.” ");
INSERT INTO swessb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta säger till honom: ”Jag vet att han ska uppstå. Vid uppståndelsen, på den sista dagen.” ");
INSERT INTO swessb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus sade: ”Jag är uppståndelsen och livet. Den som tror på mig, även om han dör ska han leva. ");
INSERT INTO swessb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Och var och en som lever och tror på mig ska aldrig dö till eonen. Tror du detta?” ");
INSERT INTO swessb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hon säger till honom: ”Ja Herre. Jag har kommit till tro på att du är Kristus, Guds Son som kommer till världen.” ");
INSERT INTO swessb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Och när hon sagt detta gick hon iväg och ropade på Maria, sin syster, och i hemlighet sade hon: ”Läraren är här och ropar på dig.” ");
INSERT INTO swessb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Och denna, när hon hörde, reste sig fort och gick till honom. ");
INSERT INTO swessb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Men ännu hade Jesus inte gått in i byn, utan var fortfarande på platsen där Marta mötte honom. ");
INSERT INTO swessb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judarna som var med henne i huset och uppmuntrade henne såg då Maria, att hon fort stod upp och gick ut. Och de följde henne och tänkte sig att hon beger sig till graven för att gråta där. ");
INSERT INTO swessb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria, när hon nu kom dit där Jesus var, såg honom och föll ner för hans fötter och sade till honom: ”Herre, om du varit här hade inte min bror dött.” ");
INSERT INTO swessb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus, när han nu såg henne gråtande och judarna som kommit med henne gråtande, frustade i anden och upprörde sig ");
INSERT INTO swessb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","och sade: ”Var har ni lagt honom?” De säger till honom: ”Herre, kom och se.” ");
INSERT INTO swessb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus tårades. ");
INSERT INTO swessb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Då sade judarna: ”Se hur han gillade honom!” ");
INSERT INTO swessb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Men några av dem sade: ”Kunde inte denne som öppnade ögonen på den blinde göra så att också denne inte dog?” ");
INSERT INTO swessb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus frustade då åter inom sig och går till graven. Och den var en grotta, och en sten låg över den. ");
INSERT INTO swessb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus säger: ”Ta bort stenen.” Då säger honom systern till den avlidne, Marta: ”Herre, han luktar redan. För det är fjärde dagen.” ");
INSERT INTO swessb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus säger till henne: ”Har jag inte sagt dig att om du tror, ska du få se Guds härlighet?” ");
INSERT INTO swessb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","De tog då bort stenen. Och Jesus lyfte ögonen mot ovan och sade: ”Far, jag tackar dig att du har hört mig. ");
INSERT INTO swessb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Och jag visste att du alltid hör mig. Men för skaran som står här omkring sade jag det, för att de ska tro att du har sänt mig.” ");
INSERT INTO swessb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Och när han hade sagt detta, vrålade han med väldig röst: ”Lasarus! Kom ut!” ");
INSERT INTO swessb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Den avlidne kom ut, ombunden till fötterna och händerna med bindlar, och hans åsyn var omlindad med en duk. Jesus säger till dem: ”Lös honom och låt honom bege sig.” ");
INSERT INTO swessb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Många av judarna som hade kommit till Maria och skådat det han gjort kom då till tro på honom. ");
INSERT INTO swessb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Men några av dem gick bort till fariseerna och sade till dem vad Jesus hade gjort. ");
INSERT INTO swessb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Då samlade översteprästerna och fariseerna Sanhedrin och sade: ”Vad gör vi? För den där människan gör många tecken. ");
INSERT INTO swessb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Om vi låter honom vara så kommer alla att tro på honom, och då kommer romarna att komma och ta bort från oss både platsen och folkslaget.” ");
INSERT INTO swessb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Men en viss av dem, Kaiafas som var överstepräst det året, sade till dem: ”Ni vet ingenting. ");
INSERT INTO swessb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Inte heller tänker ni att det gagnar er att en människa dör istället för folket och inte hela folkslaget går förlorat.” ");
INSERT INTO swessb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Men detta sade han inte av sig själv, utan då han var överstepräst det året profeterade han att Jesus skulle dö för folkslaget. ");
INSERT INTO swessb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Och inte bara för folkslaget, utan för att också samla Guds förskingrade barn till ett. ");
INSERT INTO swessb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Från den dagen planerade de nu för att döda honom. ");
INSERT INTO swessb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesus vandrade då inte längre öppet bland judarna, utan gick bort därifrån till trakten nära ödemarken, till Efraim som en stad hette. Och där blev han kvar med lärjungarna. ");
INSERT INTO swessb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Och judarnas påsk var nära, och många gick upp till Jerusalem från trakten före påsken för att renhelga sig. ");
INSERT INTO swessb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","De sökte då efter Jesus och talade med varandra stående i templet: ”Vad tänker ni er? Att han alls inte kommer till högtiden?” ");
INSERT INTO swessb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Men översteprästerna och fariseerna hade gett bud att om någon vet var han är, ska han informera så att de kan fånga honom. ");
INSERT INTO swessb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesus kom nu sex dagar före påsk till Betania, där Lasarus fanns som Jesus hade uppväckt från de döda. ");
INSERT INTO swessb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","De gjorde då för honom en måltid där. Och Marta betjänade, och Lasarus var en av dem som låg till bords med honom. ");
INSERT INTO swessb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria tog då en litra nardusbalsam, genuin, värdefull, och smorde in Jesu fötter och torkade med sitt hår av hans fötter. Och huset uppfylldes av balsamdoften. ");
INSERT INTO swessb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Men då säger Judas Iskariot, en av hans lärjungar, den som kommer att utlämna honom: ");
INSERT INTO swessb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","”Varför såldes inte denna balsam för trehundra denarer och gavs till de fattiga?” ");
INSERT INTO swessb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Men han sade detta inte för att han brydde sig om de fattiga, utan för att han var en tjuv och hade kassan och bar det som lades där. ");
INSERT INTO swessb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Då sade Jesus: ”Låt henne vara, så att hon kan bevara den till dagen för min begravning. ");
INSERT INTO swessb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","För de fattiga har ni alltid hos er, men mig har ni inte alltid.” ");
INSERT INTO swessb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Då fick den stora skaran av judarna veta att han är där, och de kom inte bara för Jesus utan för att också se Lasarus som han hade uppväckt från de döda. ");
INSERT INTO swessb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Men översteprästerna planerade för att döda även Lasarus, ");
INSERT INTO swessb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","eftersom många för hans skull begav sig från judarna och trodde på Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Dagen därpå, när den stora skaran som kommit till högtiden hörde att Jesus kommer till Jeru­salem, ");
INSERT INTO swessb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tog de bladen från palmerna och gick ut, honom till mötes, och vrålade: ”Hosianna! Välsignad är han som kommer i Herrens namn!” Och: ”Israels kung!” ");
INSERT INTO swessb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Och Jesus fann en liten åsna och satte sig på den, liksom det är skrivet: ");
INSERT INTO swessb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Frukta inte, dotter Sion! Se: din kung kommer, sittande på ett åsneföl. ");
INSERT INTO swessb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Detta förstod inte hans lärjungar först. Men när Jesus hade blivit förhärligad, då kom de ihåg att detta var skrivet om honom och detta gjorde man med honom. ");
INSERT INTO swessb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nu vittnade skaran som var med honom när han ropade Lasarus ut ur graven och uppväckte honom från de döda. ");
INSERT INTO swessb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Därför mötte honom också skaran, eftersom de hört att han gjort detta tecken. ");
INSERT INTO swessb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseerna sade då till varann: ”Skådar ni att ni inte gör någon nytta? Se: världen går iväg efter honom.” ");
INSERT INTO swessb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Men det fanns några greker av dem som gick upp för att tillbe vid högtiden. ");
INSERT INTO swessb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dessa kom nu till Filippus, som var från Betsaida i Galileen, och frågade honom och sade: ”Herre, vi vill se Jesus.” ");
INSERT INTO swessb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus går och säger till Andreas. Andreas och Filippus går och säger till Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Men Jesus svarar dem och säger: ”Stunden har kom­mit att Människosonen ska förhärligas. ");
INSERT INTO swessb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Amen amen, jag säger er: Om inte vetekornet faller i jorden och dör, förblir det självt ensamt. Men om det dör bär det mycket frukt. ");
INSERT INTO swessb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Den som gillar sin själ förlorar den, och den som hatar sin själ i denna värld ska till eoniskt liv beskydda den. ");
INSERT INTO swessb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Om någon betjänar mig, ska han följa mig. Och där jag är, där kommer också min tjänare att vara. Om någon betjänar mig ska Fadern hedra honom. ");
INSERT INTO swessb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nu är min själ oroad. Och vad ska jag säga? Far, fräls mig från denna stund? Nej, därför har jag kommit, för denna stund. ");
INSERT INTO swessb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Far, förhärliga ditt namn.” Då kom en röst från himlen: ”Och jag har förhärligat. Och jag ska åter förhärliga.” ");
INSERT INTO swessb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Skaran som stod och hörde sade då att det kommit åska. Andra sade: ”En ängel har talat till honom.” ");
INSERT INTO swessb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus svarade och sade: ”Det är inte för min skull denna röst har kommit, utan för er. ");
INSERT INTO swessb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nu är det dom över denna värld. Nu ska fursten över denna värld drivas ut utanför. ");
INSERT INTO swessb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Och jag, när jag upphöjs från jorden, ska dra alla till mig.” ");
INSERT INTO swessb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Och detta sade han angivande med vilken död han skulle dö. ");
INSERT INTO swessb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Då svarade honom skaran: ”Vi har hört från lagen att Kristus blir kvar till eonen. Och hur kan du säga att Människosonen måste bli upphöjd? Vem är denne Människoson?” ");
INSERT INTO swessb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Då sade Jesus till dem: ”Ännu en liten tid finns ljuset bland er. Vandra ­medan ni har ljuset, så att inte mörkret greppar er. Och den som vandrar i mörkret vet inte vart han beger sig. ");
INSERT INTO swessb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Medan ni har ljuset, tro på ljuset så att ni blir ljusets söner.” Detta talade Jesus, och han gick bort och dolde sig för dem. ");
INSERT INTO swessb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Men fast han hade gjort så många tecken framför dem trodde de inte på honom, ");
INSERT INTO swessb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","för att profeten Jesajas ord skulle uppfyllas som sade: Herre, vem trodde det som hördes från oss? Och Herrens arm, för vem blev den uppenbarad? ");
INSERT INTO swessb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Därför kunde de inte tro, för åter sade Jesaja: ");
INSERT INTO swessb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Han har förblindat deras ögonoch förstenat deras hjärta,så att de inte ser med ögonenoch fattar med hjärtatoch vänder om och jag ska hela dem. ");
INSERT INTO swessb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Detta sade Jesaja eftersom han såg hans härlighet och talade om honom. ");
INSERT INTO swessb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ändå var det dock även från ledarna många som trodde på honom. Men för fariseernas skull bekände de inte, för att inte bli avsynagogade. ");
INSERT INTO swessb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","För de älskade äran från män­niskorna mer än äran från Gud. ");
INSERT INTO swessb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Men Jesus ropade och sade: ”Den som tror på mig tror inte på mig, utan på honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Och den som skådar mig, skådar honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jag har kommit som ett ljus till världen, för att var och en som tror på mig inte ska bli kvar i mörkret. ");
INSERT INTO swessb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Och om någon hör mina ord och inte iakttar, dömer inte jag honom. För jag har inte kommit för att döma världen, utan för att frälsa världen. ");
INSERT INTO swessb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Den som avvisar mig och inte tar emot mina ord har den som dömer honom: ordet som jag talat, detta ska döma honom på den sista dagen. ");
INSERT INTO swessb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","För jag har inte talat av mig själv, utan Fadern som skickat mig har själv gett mig bud vad jag ska säga och vad jag ska tala. ");
INSERT INTO swessb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Och jag vet att hans bud är eoniskt liv. Det jag alltså talar: så som Fadern har sagt mig, så talar jag.” ");
INSERT INTO swessb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Och före påskens högtid, då Jesus visste att hans stund hade kommit för att gå vidare från denna värld till Fadern, hade han älskat sina egna i världen och till slutet älskade han dem. ");
INSERT INTO swessb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Och när det var måltid och djävulen redan hade lagt i hjärtat hos Judas, Simon Iskariots son, att utlämna honom, ");
INSERT INTO swessb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","och då han visste att allt har Fadern gett honom i händerna och att han utgått från Gud och beger sig till Gud, ");
INSERT INTO swessb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","reser han sig från måltiden och lägger bort kläderna, och han tog en linnehandduk och knöt om sig. ");
INSERT INTO swessb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sedan häller han vatten i tvättfatet, och han började tvätta lärjungarnas fötter och torka av med handduken med vilken han var omknuten. ");
INSERT INTO swessb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Han kommer nu till Simon Petrus, som säger till honom: ”Herre, är det du som tvättar mina fötter?” ");
INSERT INTO swessb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus svara­de och sade till honom: ”Det jag gör förstår du inte nu. Men du kommer att förstå efter detta.” ");
INSERT INTO swessb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus säger till honom: ”Aldrig ska du tvätta mina fötter, till eonen!” Jesus svarade honom: ”Om jag inte får tvätta dig, har du ingen del hos mig.” ");
INSERT INTO swessb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus säger till honom: ”Herre, inte bara mina fötter, utan också händerna och huvudet!” ");
INSERT INTO swessb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus säger till honom: ”Den som är badad har inte behov utom att tvätta fötterna, utan är helt ren. Och ni är rena. Men inte alla.” ");
INSERT INTO swessb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","För han kände den som utlämnar honom. Därför sade han att: ”Ni är inte alla rena.” ");
INSERT INTO swessb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","När han nu hade tvättat deras fötter och tagit sina kläder och lagt sig till bords igen, sade han till dem: ”Förstår ni vad jag har gjort med er? ");
INSERT INTO swessb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ni ropar till mig Lärare och Herre, och med rätta säger ni det, för det är jag. ");
INSERT INTO swessb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Om nu jag har tvättat era fötter, Herren och Läraren, är också ni skyldiga att tvätta varandras fötter. ");
INSERT INTO swessb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","För det är ett exempel jag har gett er, för att så som jag har gjort för er ska också ni göra. ");
INSERT INTO swessb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Amen amen, jag säger er: En fasttjänare är inte större än sin herre, och en ­apostel inte större än den som skickat honom. ");
INSERT INTO swessb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Om ni vet detta, saliga är ni om ni gör det. ");
INSERT INTO swessb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Det är inte om er alla jag talar. Jag vet vilka jag har utvalt. Men, för att Skriften ska uppfyllas: Den som tuggar mitt bröd har lyft mot mig sin häl. ");
INSERT INTO swessb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Från nu säger jag det till er innan det sker, för att ni ska tro när det sker att Jag Är. ");
INSERT INTO swessb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Amen amen, jag säger er: Den som tar emot någon jag skickar tar emot mig. Och den som tar emot mig, tar emot honom som har skickat mig.” ");
INSERT INTO swessb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","När Jesus hade sagt detta, blev han oroad i anden och vittnade och sade: ”Amen amen, jag säger er att en av er kommer att utlämna mig.” ");
INSERT INTO swessb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lärjungarna såg på varandra, villrådiga om vem han talar. ");
INSERT INTO swessb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","En av hans lärjungar låg till bords i Jesu famn, den som Jesus älskade. ");
INSERT INTO swessb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Då nickar Simon Petrus åt denne att efterhöra vem det kunde vara som han talar om. ");
INSERT INTO swessb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Denne ligger nu så på Jesu bröstkorg och säger till honom: ”Herre, vem är det?” ");
INSERT INTO swessb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus svarar: ”Det är denne för vilken jag ska doppa brödbiten och ge honom.” Han doppar nu brödbiten och tar och ger till Judas, Simon Iskariots son. ");
INSERT INTO swessb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Och efter brödbiten, då for Satan in i denne. Jesus säger nu till honom: ”Det du gör, gör det fortare!” ");
INSERT INTO swessb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Men detta var det ingen som förstod av dem som låg till bords, varför han sade så till honom. ");
INSERT INTO swessb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","För några tänkte sig, då Judas hade kassan, att Jesus säger åt honom: Köp det vi har behov av till högtiden. Eller för de fattiga, att ge något. ");
INSERT INTO swessb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nu tog denne brödbiten och gick ut direkt. Och det var natt. ");
INSERT INTO swessb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","När han nu hade gått ut, säger Jesus: ”Nu har Människosonen förhärligats, och Gud har förhärligats i honom. ");
INSERT INTO swessb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Om Gud har förhärligats i honom ska Gud också förhärliga honom i sig själv, och direkt ska han förhärliga honom. ");
INSERT INTO swessb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Barn, ännu lite är jag hos er. Ni kommer att söka mig. Och liksom jag sade till judarna, att dit jag beger mig kan ni inte komma, säger jag också till er nu. ");
INSERT INTO swessb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ett nytt bud ger jag er: att ni ska älska varandra. Så som jag har älskat er, att också ni ska älska varandra. ");
INSERT INTO swessb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","I detta ska alla förstå att ni är mina lärjungar, om ni har kärlek till varandra.” ");
INSERT INTO swessb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus säger till honom: ”Herre, vart beger du dig?” Jesus svarade honom: ”Dit jag beger mig kan du inte nu följa mig. Men du kommer att följa till sist.” ");
INSERT INTO swessb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus säger till honom: ”Herre, varför kan jag inte följa dig nu? Min själ ska jag lägga ner för dig.” ");
INSERT INTO swessb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus svarar: ”Din själ ska du lägga ner för mig? Amen amen, jag säger dig: Tuppen ska alls inte gala förrän du förnekat mig tre gånger. ");
INSERT INTO swessb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ert hjärta ska inte oroas. Tro på Gud. Tro också på mig. ");
INSERT INTO swessb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","I min Fars hus finns många boningar. Hade jag annars sagt er att jag går att bereda plats för er? ");
INSERT INTO swessb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Och om jag går och bereder plats för er, kommer jag åter och ska ta med er till mig, för att där jag är, där ska också ni vara. ");
INSERT INTO swessb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Och dit jag beger mig känner ni vägen.” ");
INSERT INTO swessb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas säger till honom: ”Herre, vi vet inte vart du beger dig. Hur kan vi känna vägen?” ");
INSERT INTO swessb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus säger till honom: ”Jag är vägen och sanningen och livet. Ingen kommer till Fadern utom genom mig. ");
INSERT INTO swessb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Om ni har lärt känna mig, ska ni också lära känna min Far. Och från nu känner ni honom och har sett honom.” ");
INSERT INTO swessb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filippus säger till honom: ”Herre, visa oss Fadern och det räcker för oss.” ");
INSERT INTO swessb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus säger till honom: ”Så mycket tid är jag hos er och du har inte lärt känna mig, Filippus. Den som har sett mig har sett Fadern. Hur kan du säga: Visa oss Fadern? ");
INSERT INTO swessb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tror du inte att jag är i Fadern och Fadern är i mig? Orden som jag säger er talar jag inte av mig själv, utan Fadern som förblir i mig gör sina gärningar. ");
INSERT INTO swessb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tro mig att jag är i Fadern och Fadern i mig. Annars, tro för själva gärningarnas skull. ");
INSERT INTO swessb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Amen amen, jag säger er: Den som tror på mig, gärningarna som jag gör ska också denne göra. Och större än dessa ska han göra, eftersom jag går till Fadern. ");
INSERT INTO swessb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Och vad ni än ber om i mitt namn, det ska jag göra, för att Fadern ska ­förhärligas i Sonen. ");
INSERT INTO swessb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Om ni ber mig om något i mitt namn ska jag göra det. ");
INSERT INTO swessb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Om ni älskar mig, kommer ni att hålla fast vid mina bud. ");
INSERT INTO swessb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Och jag ska fråga Fadern, och en annan Hjälpare ska han ge er, för att vara med er till eonen: ");
INSERT INTO swessb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","sanningens Ande, som världen inte kan ta emot eftersom den inte skådar den eller känner. Ni känner den, eftersom den förblir hos er och ska vara i er. ");
INSERT INTO swessb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jag ska inte lämna er faderlösa. Jag kommer till er. ");
INSERT INTO swessb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ännu lite och världen skådar mig inte längre. Men ni skådar mig, eftersom jag lever och ni ska leva. ");
INSERT INTO swessb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","På den dagen ska ni förstå att jag är i min Far och ni i mig och jag i er. ");
INSERT INTO swessb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Den som har mina bud och håller fast vid dem, denne är den som älskar mig. Och den som älskar mig ska bli älskad av min Far, och jag ska älska honom och framvisa för honom mig själv.” ");
INSERT INTO swessb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, inte Iskariot, säger till honom: ”Herre, och vad har hänt, att det är för oss du kommer att framvisa dig och inte för världen?” ");
INSERT INTO swessb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus svarade och sade till honom: ”Om någon älskar mig, håller han fast vid mitt ord. Och min Far ska älska honom, och till honom ska vi komma och göra oss en boning hos honom. ");
INSERT INTO swessb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Den som inte älskar mig håller inte fast vid mina ord. Och ordet som ni hör är inte mitt, utan från Fadern som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Detta har jag talat till er medan jag är kvar hos er. ");
INSERT INTO swessb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Men Hjälparen, den heliga Anden som Fadern ska skicka i mitt namn, denne ska lära er allt och påminna er om allt som jag sagt er. ");
INSERT INTO swessb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Frid lämnar jag åt er. Min frid ger jag er. Det är inte så som världen ger jag ger er. Ert hjärta ska inte vara oroat eller fegt. ");
INSERT INTO swessb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni har hört att jag har sagt er: Jag beger mig, och jag kommer till er. Om ni älskade mig vore ni glada att jag går till Fadern, för Fadern är större än jag. ");
INSERT INTO swessb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Och nu har jag sagt er innan det sker, för att ni när det sker ska tro. ");
INSERT INTO swessb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Jag ska inte tala mycket mer med er, för världens furste kommer. Och i mig har han inget, ");
INSERT INTO swessb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","men det är för att världen ska förstå att jag älskar Fadern. Och så som Fadern påbjudit mig, så gör jag. Res er, låt oss dra härifrån. ");
INSERT INTO swessb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jag är den sannfärdiga vinstocken, och min Far är odlaren. ");
INSERT INTO swessb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Varje ranka i mig som inte bär frukt, den tar han bort. Och varje som bär frukt, den renar han så att den bär mer frukt. ");
INSERT INTO swessb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Redan är ni rena på grund av ordet som jag har talat till er. ");
INSERT INTO swessb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Var kvar i mig, och jag i er. Liksom rankan inte kan bära frukt av sig själv, om den inte är kvar i vinstocken, så inte heller ni om inte ni är kvar i mig. ");
INSERT INTO swessb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Jag är vinstocken, ni rankorna. Den som är kvar i mig och jag i honom, denne bär mycket frukt. För utan mig kan ni inte göra något. ");
INSERT INTO swessb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Om någon inte är kvar i mig, har han kastats utanför som rankan och vissnat. Och man samlar dem och kastar i elden och de bränns. ");
INSERT INTO swessb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Om ni är kvar i mig och mina ord är kvar i er, be om vad ni vill och det ska ske för er. ");
INSERT INTO swessb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","I detta har min Far förhärligats, att ni bär mycket frukt och blir mina lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Så som Fadern älskat mig, har också jag älskat er. Var kvar i min kärlek. ");
INSERT INTO swessb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Om ni håller fast vid mina bud ska ni vara kvar i min kärlek, liksom jag har hållit fast vid min Fars bud och är kvar i hans kärlek. ");
INSERT INTO swessb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Detta har jag talat till er för att min glädje ska vara i er och er glädje bli uppfylld. ");
INSERT INTO swessb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Detta är mitt bud: att ni ska ­älska varandra, så som jag har älskat er. ");
INSERT INTO swessb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Större kärlek än denna har ingen, att någon lägger ner sin själ för sina vänner. ");
INSERT INTO swessb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni är mina vänner, om ni gör det jag påbjuder er. ");
INSERT INTO swessb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jag kallar er inte längre fasttjänare, för fasttjänaren vet inte vad hans herre gör. Men er har jag kallat vänner, för allt som jag hört från min Far har jag kungjort för er. ");
INSERT INTO swessb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ni har inte utvalt mig, utan jag har utvalt er och satt er för att ni ska bege er och bära frukt och er frukt bestå, så att vad ni än ber Fadern om i mitt namn ska han ge er. ");
INSERT INTO swessb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Detta påbjuder jag er: att ni ska älska varandra. ");
INSERT INTO swessb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Om världen hatar er, ska ni veta att den hatat mig före er. ");
INSERT INTO swessb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Om ni var av världen, hade världen gillat sitt eget. Men eftersom ni inte är av världen utan jag har utvalt er från världen, därför hatar världen er. ");
INSERT INTO swessb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Minns det ord som jag sagt er: en fasttjänare är inte större än sin herre. Om de förföljt mig, ska de också förfölja er. Om de hållit fast vid mitt ord, ska de också hålla fast vid ert. ");
INSERT INTO swessb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Men allt detta kommer de att göra mot er för mitt namns skull, eftersom de inte känner honom som har skickat mig. ");
INSERT INTO swessb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Om jag inte hade kommit och talat till dem, hade de inte haft synd. Men nu har de ingen förevändning för sin synd. ");
INSERT INTO swessb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Den som hatar mig, hatar också min Far. ");
INSERT INTO swessb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Om jag inte hade gjort gärningarna bland dem som ingen annan har gjort, hade de inte haft synd. Men nu har de både sett och hatat, både mig och min Far. ");
INSERT INTO swessb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Men det är för att ordet ska uppfyllas som är skrivet i deras lag, att: De har hatat mig utan orsak. ");
INSERT INTO swessb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","När Hjälparen kommer som jag ska skicka er från Fadern, sanningens Ande som utgår från Fadern, ska denne vittna om mig. ");
INSERT INTO swessb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Och även ni vittnar, eftersom ni från begynnelsen är med mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Detta har jag talat till er för att ni inte ska bli skandaliserade. ");
INSERT INTO swessb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","De kommer att göra er avsynagogade. Men det kommer en stund att var och en som dödar er ska tycka sig frambära gudstjänst åt Gud. ");
INSERT INTO swessb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Och detta kommer de att göra eftersom de inte har lärt känna Fadern eller mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Men detta har jag talat till er för att ni, när deras stund kommer, ska minnas det: att jag sagt er det. Och detta sade jag er inte från begynnelsen, eftersom jag var med er. ");
INSERT INTO swessb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Men nu beger jag mig till honom som har skickat mig, och ingen av er frågar mig: Vart beger du dig? ");
INSERT INTO swessb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Men eftersom jag talat detta till er, har bedrövelsen uppfyllt ert hjärta. ");
INSERT INTO swessb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Men jag säger er sanningen: Det gagnar er att jag går bort. För om jag inte går bort, kommer inte Hjälparen att komma till er. Men om jag går ska jag skicka honom till er. ");
INSERT INTO swessb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Och när denne kommer, ska han tillrättavisa världen om synd och om rättfärdighet och om dom. ");
INSERT INTO swessb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Om synd: att de inte tror på mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Och om rättfärdighet: att jag beger mig till Fadern och ni inte längre skådar mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Och om dom: att denna världs furste är dömd. ");
INSERT INTO swessb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mycket mer har jag att säga er, men ni kan inte bära det nu. ");
INSERT INTO swessb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Men när denne kommer, sanningens Ande, ska han vägleda er i hela sanningen. För han ska inte tala av sig själv, utan vad han hör ska han tala och det kommande ska han delge er. ");
INSERT INTO swessb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Denne ska förhärliga mig, för av mitt ska han ta och delge er. ");
INSERT INTO swessb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Allt vad Fadern har är mitt. Därför sade jag att det är av mitt han tar och ska delge er. ");
INSERT INTO swessb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Lite och ni skådar mig inte längre, och åter lite och ni ska se mig.” ");
INSERT INTO swessb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Då sade några av hans lärjungar till varandra: ”Vad är detta som han säger till oss: Lite och ni skådar mig inte, och åter lite och ni ska se mig? Och att: Jag beger mig till Fadern?” ");
INSERT INTO swessb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","De sade nu: ”Vad är detta som han säger, lite? Vi förstår inte vad han talar om.” ");
INSERT INTO swessb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus förstod att de ville fråga honom och sade till dem: ”Om detta söker ni med varandra, att jag sade: Lite och ni skådar mig inte, och åter lite och ni ska se mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Amen amen, jag säger er att ni kommer att gråta och jämra er, men världen ska glädjas. Ni kommer att bli bedrövade, men er bedrövelse ska bli till glädje. ");
INSERT INTO swessb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kvinnan, när hon föder, har bedrövelse eftersom hennes stund har kommit. Men när hon har fött barnet, minns hon inte längre nöden av glädjen att det fötts en människa till världen. ");
INSERT INTO swessb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Och ni har alltså nu bedrövelse. Men åter ska jag se er, och ert hjärta ska glädjas. Och er glädje tar ingen ifrån er. ");
INSERT INTO swessb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Och på den dagen kommer ni inte att fråga mig om något. Amen amen, jag säger er: Vad ni än ber Fadern om i mitt namn ska han ge er. ");
INSERT INTO swessb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ännu har ni inte bett om något i mitt namn. Be och ni ska få, så att er glädje blir uppfylld. ");
INSERT INTO swessb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Detta har jag talat till er i jämförelser. Det kommer en stund när jag inte längre ska tala till er i jämförelser, utan öppet berätta om Fadern för er. ");
INSERT INTO swessb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","På den dagen ska ni be i mitt namn. Och jag säger er inte att jag ska fråga Fadern för er. ");
INSERT INTO swessb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","För Fadern själv gillar er, eftersom ni har gillat mig och kommit till tro på att jag utgått från Gud. ");
INSERT INTO swessb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jag har utgått från Fadern och kommit till världen. Åter lämnar jag världen och går till Fadern.” ");
INSERT INTO swessb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hans lärjungar säger: ”Se: nu talar du öppet och talar ingen jämförelse. ");
INSERT INTO swessb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nu vet vi att du vet allt och inte har behov att någon frågar dig. I detta tror vi att du har utgått från Gud.” ");
INSERT INTO swessb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus svarade dem: ”Nu tror ni. ");
INSERT INTO swessb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Se: det kommer en stund, och den har kommit, att ni ska skingras var och en till sitt och lämna mig ensam. Och jag är inte ensam, eftersom Fadern är med mig. ");
INSERT INTO swessb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Detta har jag talat till er för att ni i mig ska ha frid. I världen har ni nöd. Men fatta mod: jag har besegrat världen.” ");
INSERT INTO swessb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Detta talade Jesus, och han lyfte sina ögon till himlen och sade: ”Far, stunden har kommit. Förhärliga din Son så att Sonen förhärligar dig, ");
INSERT INTO swessb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","liksom du gett honom auktoritet över allt kött, för att allt som du gett honom, åt dem ska han ge eoniskt liv. ");
INSERT INTO swessb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Och detta är det eoniska livet: att de känner dig, den ende sannfärdige Guden, och den som du har sänt, Jesus Kristus. ");
INSERT INTO swessb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Jag har förhärligat dig på jorden och fullkomnat det verk som du gett mig att göra. ");
INSERT INTO swessb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Och nu: förhärliga mig du, Far, hos dig själv med den härlighet som jag hade före det att världen fanns hos dig. ");
INSERT INTO swessb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jag har visat ditt namn för människorna som du gett mig från världen. Dina var de och till mig har du gett dem, och ditt ord har de hållit fast vid. ");
INSERT INTO swessb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nu har de förstått att allt vad du gett mig är från dig. ");
INSERT INTO swessb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","För orden som du gett mig har jag gett till dem, och de har tagit emot och sannerligen förstått att jag utgått från dig. Och de har trott att du har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jag frågar för dem. Det är inte för världen jag frågar utan för dem du har gett mig, eftersom de är dina. ");
INSERT INTO swessb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Och allt mitt är ditt och ditt är mitt, och jag är förhärligad i dem. ");
INSERT INTO swessb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Och jag är inte längre i världen, och de är i världen och jag kommer till dig. Helige Far, bevara dem i ditt namn som du gett mig, så att de är ett liksom vi. ");
INSERT INTO swessb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","När jag var hos dem, bevarade jag dem i ditt namn som du gett mig. Och jag beskyddade, och ingen av dem gick förlorad utom fördärvets son, för att Skriften skulle uppfyllas. ");
INSERT INTO swessb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Men nu kommer jag till dig. Och detta talar jag i världen för att de ska ha min glädje uppfylld inom sig. ");
INSERT INTO swessb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jag har gett dem ditt ord, och världen har hatat dem eftersom de inte är av världen, liksom jag inte är av världen. ");
INSERT INTO swessb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jag efterfrågar inte att du ska ta upp dem ur världen, utan att du ska bevara dem från den elake. ");
INSERT INTO swessb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Det är inte av världen de är, liksom jag inte är av världen. ");
INSERT INTO swessb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Helga dem i sanningen. Ditt ord är sanning. ");
INSERT INTO swessb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Så som du har sänt mig till världen, har också jag sänt dem till världen. ");
INSERT INTO swessb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Och för dem helgar jag mig, för att också de ska vara helgade i sanning. ");
INSERT INTO swessb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Men det är inte bara för dessa jag frågar, utan också för dem som tror genom deras ord på mig: ");
INSERT INTO swessb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","att alla ska vara ett. Liksom du Far är i mig och jag i dig, att också de ska vara i oss, för att världen ska tro att du har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Och den härlighet som du gett till mig har jag gett till dem, för att de ska vara ett liksom vi är ett. ");
INSERT INTO swessb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jag i dem och du i mig, så att de är fullkomnade till ett, så att världen förstår att du har sänt mig och älskat dem så som du har älskat mig. ");
INSERT INTO swessb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Far, det du gett mig, jag vill att där jag är ska också dessa vara med mig, för att skåda min härlighet som du har gett mig. För du har älskat mig före världens grundläggning. ");
INSERT INTO swessb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Rättfärdige Far, och världen har inte förstått dig, men jag har förstått dig, och dessa har förstått att du har sänt mig. ");
INSERT INTO swessb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Och jag har kungjort för dem ditt namn. Och jag ska kungöra, för att kärleken som du älskat mig med ska vara i dem och jag i dem.” ");
INSERT INTO swessb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","När Jesus hade sagt detta, gick han ut med sina lärjungar till andra sidan av Kidrons bäckravin, där det fanns en trädgård. I den gick han in, även hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Men även Judas som utlämnade honom kände till platsen, eftersom Jesus många gånger hade samlats där med sina lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas tog då kohorten, och från översteprästerna och från fariseerna undertjänare och kommer dit med lyktor och facklor och vapen. ");
INSERT INTO swessb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus, som visste om allt som kommer mot honom, gick nu ut och säger till dem: ”Vem söker ni?” ");
INSERT INTO swessb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","De svarade honom: ”Jesus nasarén.” Han säger till dem: ”Jag Är.” Och där stod även Judas, som utlämnade honom, med dem. ");
INSERT INTO swessb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","När han nu sade till dem: Jag Är, gick de bort bakåt och föll till marken. ");
INSERT INTO swessb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Åter frågade han dem nu: ”Vem söker ni?” Och de sade: ”Jesus nasarén.” ");
INSERT INTO swessb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus svarade: ”Jag har sagt er att Jag Är. Om det nu är mig ni söker, låt dessa bege sig”, ");
INSERT INTO swessb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","för att ordet skulle uppfyllas som han hade sagt, att: ”Av dem som du gett mig har jag inte förlorat någon.” ");
INSERT INTO swessb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus, som hade ett svärd, drog det nu och högg till översteprästens fasttjänare och högg av hans högra öra. Och namnet på fasttjänaren var Malkus. ");
INSERT INTO swessb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Då sade Jesus till Petrus: ”Sätt svärdet i skidan! Bägaren som Fadern gett mig, ska jag alls inte dricka den?” ");
INSERT INTO swessb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kohorten och befälhavaren och judarnas undertjänare tog nu fast Jesus och band honom, ");
INSERT INTO swessb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","och de förde till Hannas först, för han var svärfar till Kaiafas som var överstepräst det året. ");
INSERT INTO swessb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Och det var Kaiafas som hade samrått judarna att det gagnar att en människa dör istället för folket. ");
INSERT INTO swessb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Men efter Jesus följde Simon Petrus och en annan lärjunge. Och den lärjungen var bekant för översteprästen och kom in med Jesus till översteprästens innergård. ");
INSERT INTO swessb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Men Petrus stod vid dörren utanför. Då gick den andre lärjungen som var bekant med översteprästen ut och sade till dörrvakterskan och förde in Petrus. ");
INSERT INTO swessb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Då säger dörrvaktarflickan till Petrus: ”Inte är väl också du en av lärjungarna till den där människan?” Denne säger: ”Det är jag inte.” ");
INSERT INTO swessb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Men där stod fasttjänarna och undertjänarna och hade gjort en koleld, eftersom det var kyla, och värmde sig. Och även Petrus var med dem och stod och värmde sig. ");
INSERT INTO swessb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Översteprästen frågade nu Jesus om hans lärjungar och om hans undervisning. ");
INSERT INTO swessb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Då svarade honom Jesus: ”Jag har öppet talat till världen. Jag har alltid undervisat i synagogan och i templet där alla judarna kommer samman. Och i det fördolda har jag inte talat något. ");
INSERT INTO swessb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Varför frågar du mig? Fråga dem som har hört vad jag talat till dem. Se: dessa vet vad jag har sagt.” ");
INSERT INTO swessb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Men när han sagt detta, gav en av undertjänarna som stod där en örfil till Jesus och sade: ”Är det så du svarar översteprästen?” ");
INSERT INTO swessb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus svarade honom: ”Om jag talat illa, vittna om det onda. Men om med rätta, varför pryglar du mig?” ");
INSERT INTO swessb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Då sände Hannas honom bunden till Kaiafas översteprästen. ");
INSERT INTO swessb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Men Simon Petrus stod och värmde sig. Då sade de till honom: ”Inte är väl också du en av hans lärjungar?” Denne nekade och sade: ”Det är jag inte.” ");
INSERT INTO swessb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Då säger en av översteprästens fasttjänare, som var släkting till den från vilken Petrus högg av örat: ”Såg inte jag dig i trädgården med honom?” ");
INSERT INTO swessb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Åter nekade då Petrus – och direkt gol en tupp. ");
INSERT INTO swessb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","De för nu Jesus från Kaiafas till pretoriet. Och det var morgon. Och själva gick de inte in i ­pretoriet, för att inte bli befläckade utan få äta påsken. ");
INSERT INTO swessb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Då kom Pilatus ut utanför till dem och säger: ”Vilken anklagelse anför ni mot denna människa?” ");
INSERT INTO swessb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","De svarade och sade till honom: ”Om inte den där var en som gör det onda, hade vi inte överlämnat honom till dig.” ");
INSERT INTO swessb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Då sade Pilatus till dem: ”Ta honom ni och döm honom efter er lag.” Judarna sade till honom: ”För oss är det inte tillåtet att döda någon” – ");
INSERT INTO swessb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","för att Jesu ord skulle uppfyllas, som han sade när han angav med vilken död han skulle dö. ");
INSERT INTO swessb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Då gick Pilatus åter in i pretoriet och ropade dit Jesus och sade till honom: ”Du är judarnas kung?” ");
INSERT INTO swessb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus svarade: ”Är det av dig själv du säger det? Eller har andra sagt dig det om mig?” ");
INSERT INTO swessb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus svarade: ”Inte är väl jag jude? Ditt folkslag och översteprästerna har överlämnat dig till mig. Vad har du gjort?” ");
INSERT INTO swessb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus svarade: ”Mitt rike är inte av denna värld. Om det var av denna värld, mitt rike, hade mina undertjänare kämpat för att jag inte skulle utlämnas åt judarna. Men nu är mitt rike inte härifrån.” ");
INSERT INTO swessb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Då sade Pilatus till honom: ”Du är alltså kung?” Jesus svarade: ”Du säger att jag är kung. För detta är jag född och för detta har jag kommit till världen, för att vittna för sanningen. Var och en som är av sanningen lyssnar till min röst.” ");
INSERT INTO swessb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus säger till honom: ”Vad är sanning?” Och när han sagt detta, gick han åter ut till judarna och säger till dem: ”Jag finner inte hos honom någon sak. ");
INSERT INTO swessb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Men det finns en sedvänja hos er, att jag friger en åt er vid påsken. Önskar ni då att jag ska frige åt er judarnas kung?” ");
INSERT INTO swessb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Då vrålade de åter och sade: ”Inte den där! Utan Barabbas!” Men Barabbas var en rövare. ");
INSERT INTO swessb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Då tog nu Pilatus Jesus och piskade. ");
INSERT INTO swessb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Och soldaterna flät­ade en krans av törnen och satte på hans huvud, och i purpurmantel klädde de honom ");
INSERT INTO swessb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","och kom till honom och sade: ”Gläd dig, judarnas kung!” och gav honom örfilar. ");
INSERT INTO swessb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Och åter kom Pilatus ut utanför och säger till dem: ”Se: jag för honom till er utanför, så att ni förstår att jag ingen sak finner hos honom.” ");
INSERT INTO swessb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Då kom Jesus ut utanför, bärande törnekransen och purpurmanteln. Och han säger till dem: ”Se människan!” ");
INSERT INTO swessb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","När de nu såg honom, översteprästerna och undertjänarna, vrålade de och sade: ”Korsfäst! Korsfäst!” Pilatus säger till dem: ”Ta honom ni och korsfäst! För jag finner inte hos honom någon sak.” ");
INSERT INTO swessb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Då svarade honom judarna: ”Vi har en lag, och enligt lagen är han skyldig att dö, eftersom han gjort sig till Guds Son.” ");
INSERT INTO swessb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","När nu Pilatus hörde detta ord, fruktade han desto mer. ");
INSERT INTO swessb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Och han gick in i pretoriet igen och säger till Jesus: ”Varifrån är du?” Men Jesus gav honom inget svar. ");
INSERT INTO swessb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Då säger Pilatus till honom: ”Talar du inte med mig? Vet du inte att jag har auktoritet att frige dig, och har auktoritet att korsfästa dig?” ");
INSERT INTO swessb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus svarade honom: ”Du hade inte haft auktoritet mot mig om inte den var given dig från ovan. Därför har den som utlämnat mig åt dig större synd.” ");
INSERT INTO swessb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Från detta sökte Pilatus frige honom. Men judarna vrålade och sade: ”Om du friger den där är du inte kejsarens vän! Var och en som gör sig till kung säger emot kejsaren.” ");
INSERT INTO swessb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","När Pilatus nu hörde dessa ord, förde han ut Jesus och satte sig på ett domarsäte vid en plats som kallas Stenläggningen, och på hebreiska Gabbata. ");
INSERT INTO swessb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Och det var förberedelsedag inför påsken. Timmen var omkring sjätte. Och han säger till judarna: ”Se: er kung.” ");
INSERT INTO swessb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Då vrålade dessa: ”Ta bort! Ta bort! Korsfäst honom!” Pila­tus säger till dem: ”Ska jag korsfästa er kung?” Översteprästerna svarade: ”Vi har ingen kung utom kejsaren.” ");
INSERT INTO swessb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Då utlämnade han honom nu åt dem för att korsfästas. De tog nu med Jesus, ");
INSERT INTO swessb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","och bärande korset åt sig själv kom han ut till den så kallade Kranieplatsen, som kallas på hebreiska Golgota. ");
INSERT INTO swessb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Där korsfäste de ­honom, och med honom två andra, härifrån och härifrån, och i mitten Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Och Pilatus skrev också ett anslag och satte på korset, och det var skrivet: ”Jesus nasarén, judarnas kung.” ");
INSERT INTO swessb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Detta anslag läste nu många av judarna, eftersom platsen var nära staden där Jesus blev korsfäst och det var skrivet på hebreiska, på latin, på grekiska. ");
INSERT INTO swessb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Då sade judarnas överstepräster till Pilatus: ”Skriv inte: Judarnas kung, utan att denne har sagt: Jag är judarnas kung.” ");
INSERT INTO swessb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus svarade: ”Det jag skrivit har jag skrivit.” ");
INSERT INTO swessb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldaterna, när de nu hade korsfäst Jesus, tog hans kläder och gjorde fyra delar, åt varje soldat en del, samt tunikan. Men tunikan var sömlös, upp­ifrån vävd genom hela. ");
INSERT INTO swessb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","De sade då till varandra: ”Låt oss inte riva den utan kasta lott om dem, vems den ska bli” – för att Skriften skulle uppfyllas som säger: De delade upp mina kläder åt sig, och om min klädnad kastade de lott. Soldaterna gjorde nu detta. ");
INSERT INTO swessb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Men där stod vid Jesu kors hans mor och systern till hans mor, Maria Klopas hustru och Maria Magdalena. ");
INSERT INTO swessb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus såg nu modern och lärjungen stå där, den han älskade, och han säger till modern: ”Kvinna, se: din son.” ");
INSERT INTO swessb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sedan säger han till lärjungen: ”Se: din mor.” Och från den stunden tog lärjungen henne till det egna. ");
INSERT INTO swessb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Efter detta, då Jesus visste att allt redan var fullbordat för att Skriften skulle fullkomnas, och han säger: ”Jag törstar.” ");
INSERT INTO swessb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ett kärl stod där, fullt med posca. En tvättsvamp full med poscan satte de då runt en isop och bar fram till hans mun. ");
INSERT INTO swessb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","När han nu hade fått poscan, sade Jesus: ”Det är fullbordat.” Och han böjde huvudet och överlämnade anden. ");
INSERT INTO swessb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Judarna, då det var förberedelsedag, för att inte kropparna skulle bli kvar på korset under sabbaten – för den sabbatens dag var stor – tillfrågade nu Pilatus om att deras ben skulle krossas och de tas bort. ");
INSERT INTO swessb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Då kom soldaterna, och på den förste krossade de benen, och på den andre som var korsfäst med honom. ");
INSERT INTO swessb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Men då de kom till Jesus, när de såg att han redan hade dött, krossade de inte hans ben ");
INSERT INTO swessb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","utan en av soldaterna stack med spjut hans sida. Och det kom direkt ut blod och vatten. ");
INSERT INTO swessb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Och den som har sett har vittnat, och sannfärdigt är hans vittnesbörd. Och denne vet att han talar sant, för att också ni ska tro. ");
INSERT INTO swessb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","För detta hände för att Skriften skulle uppfyllas: Ben ska inte knäckas hos honom. ");
INSERT INTO swessb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Och åter en annan Skrift säger: De ska se till honom som de genomborrat. ");
INSERT INTO swessb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Men efter detta tillfrågade Josef från Arimatea, som var lärjunge till Jesus men fördold av fruktan för judarna, Pilatus om att få ta Jesu kropp. Och Pilatus til­lät. Han gick då och tog hans kropp. ");
INSERT INTO swessb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Och då kom även Nikodemus, som hade kommit till honom på natten först, bärande en blandning av myrra och aloe, omkring hundra litra. ");
INSERT INTO swessb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","De tog nu Jesu kropp och band om den i linnebindlar med kryddorna, så som det är sed hos judarna att begrava. ");
INSERT INTO swessb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Och det fanns på platsen där han korsfästes en trädgård, och i trädgården en ny grav i vilken ännu ingen var lagd. ");
INSERT INTO swessb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Där, på grund av judarnas förberedelsedag eftersom graven var nära, lade de nu Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Men den första dagen i veckan kommer Maria Magdalena på morgonen, medan det ännu är mörker, till graven och ser stenen borttagen från graven. ");
INSERT INTO swessb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hon springer då och kommer till Simon Petrus och till den andre lärjungen som Jesus gillade, och säger till dem: ”De har tagit Herren från graven. Och vi vet inte var de lagt honom.” ");
INSERT INTO swessb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Då kom Petrus och den ­andre lärjungen ut och kom mot graven. ");
INSERT INTO swessb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Och de två sprang tillsammans, och den andre lärjungen sprang före fortare än Petrus och kom först till graven. ");
INSERT INTO swessb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Och han blickar in och ser linnebindlarna liggande. Dock gick han inte in. ");
INSERT INTO swessb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nu kommer även Simon Petrus, som följde honom, och han gick in i graven. Och han skådar linnebindlarna liggande ");
INSERT INTO swessb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","och duken som var över hans huvud, inte liggande med linnebindlarna utan särskilt, invikt på en enda plats. ");
INSERT INTO swessb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Då gick nu även den andre lärjungen in, han som kom först till graven. Och han såg och trodde. ");
INSERT INTO swessb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","För ännu hade de inte förstått Skriften, att han måste uppstå från de döda. ");
INSERT INTO swessb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nu gick åter lärjungarna bort till sig. ");
INSERT INTO swessb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Men Maria stod vid graven utanför, gråtande. När hon nu grät, blickade hon in i graven ");
INSERT INTO swessb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","och skådar två änglar i vitt, sittande en vid huvudet och en vid fötterna där Jesu kropp hade legat. ");
INSERT INTO swessb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Och dessa säger till henne: ”Kvinna, varför gråter du?” Hon säger till dem att: ”De har tagit min Herre. Och jag vet inte var de lagt honom.” ");
INSERT INTO swessb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","När hon sagt detta, vände hon sig bakåt och skådar Jesus stående där. Och hon visste inte att det är Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus säger till henne: ”Kvinna, varför gråter du? Vem söker du?” Hon tänker sig att det är trädgårdsmästaren och säger till honom: ”Herre, om du har burit bort honom, säg mig var du lagt honom och jag ska ta honom.” ");
INSERT INTO swessb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus säger till henne: ”Maria.” Hon vänder sig och säger till honom på hebreiska: ”Rabbuni!”, vilket heter Lärare. ");
INSERT INTO swessb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus säger till henne: ”Börja inte röra mig. För ännu har jag inte stigit upp till Fadern. Men gå till mina bröder och säg till dem: Jag stiger upp till min Far och er Far, och min Gud och er Gud.” ");
INSERT INTO swessb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Då går Maria Magdalena och berättar för lärjungarna att: ”Jag har sett Herren!” och att han sagt detta till henne. ");
INSERT INTO swessb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","När det nu var kväll den dagen, den första i veckan, och dörrarna var stängda där lärjungarna var av fruktan för judarna, kom Jesus och stod i mitten och säger till dem: ”Frid åt er!” ");
INSERT INTO swessb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Och när han sagt detta, visade han händerna och sidan för dem. Då blev lärjungarna glada, när de såg Herren. ");
INSERT INTO swessb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nu sade Jesus till dem igen: ”Frid åt er! Så som Fadern har sänt mig, skickar också jag er.” ");
INSERT INTO swessb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Och när han sagt detta, blåste han in och säger till dem: ”Ta emot helig Ande. ");
INSERT INTO swessb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","De vilkas synder ni förlåter, för dem är de förlåtna. De vilkas ni kvarhåller är kvarhållna.” ");
INSERT INTO swessb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Men Tomas, en av de tolv som kal­lades Tvillingen, var inte med dem när Jesus kom. ");
INSERT INTO swessb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nu sade de andra lärjungarna till honom: ”Vi har sett Herren.” Men han sade till dem: ”Om jag inte får se i hans händer avtrycket från spikarna, och sätta mitt finger i avtrycket från spikarna och sätta min hand i hans sida, kommer jag aldrig att tro.” ");
INSERT INTO swessb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Och efter åtta dagar var åter hans lärjungar inne och Tomas med dem. Jesus kommer, medan dörrarna är stängda, och stod i mitten och sade: ”Frid åt er!” ");
INSERT INTO swessb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sedan säger han till Tomas: ”För ditt finger hit och se mina händer, och för din hand och sätt i min sida. Och var inte otroende, utan troende.” ");
INSERT INTO swessb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas svarade och sade till honom: ”Min Herre och min Gud!” ");
INSERT INTO swessb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus säger till honom: ”Eftersom du sett mig har du kommit till tro. Saliga de som inte sett och ändå trott.” ");
INSERT INTO swessb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Också många andra tecken gjorde nu Jesus inför sina lärjungar som inte är skrivna i denna bok. ");
INSERT INTO swessb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Men dessa har skrivits för att ni ska tro att Jesus är Kristus, Guds Son, och för att ni när ni tror ska ha liv i hans namn. ");
INSERT INTO swessb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Efter detta visade sig åter Jesus för lärjungarna vid Tiberiashavet, och han visade sig så: ");
INSERT INTO swessb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","De var tillsammans, Simon Petrus och Tomas som kal­lade­s Tvillingen och Natanael från Kana i Galileen och de av Sebedeus och två andra av hans lärjungar. ");
INSERT INTO swessb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus säger till dem: ”Jag beger mig ut att fiska.” De säger till honom: ”Vi kommer också vi med dig.” De gick ut och steg i båten, och under den natten fångade de ingenting. ");
INSERT INTO swessb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Men när det redan blivit morgon, stod Jesus på stranden. Dock förstod inte lärjungarna att det är Jesus. ");
INSERT INTO swessb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nu säger Jesus till dem: ”Barn, har ni inget sovel?” De svarade honom: ”Nej.” ");
INSERT INTO swessb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Och han sade till dem: ”Kasta mot högra delarna från båten med nätet och ni ska finna.” De kastade då, och mäktade inte längre dra in det för mängden av fiskarna. ");
INSERT INTO swessb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Då säger den lärjungen som Jesus älskade till Petrus: ”Det är Herren.” När Simon Petrus nu hörde att det är Herren, knöt han ytterplagget om sig, för han var naken, och kastade sig i havet. ");
INSERT INTO swessb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Men de andra lärjungarna kom med småbåten, för de var inte långt från land utan omkring tvåhundra alnar bort, släpande nätet med fiskarna. ");
INSERT INTO swessb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","När de nu steg ur i land, ser de en koleld ligga och matfisk ligga på och bröd. ");
INSERT INTO swessb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus säger till dem: ”Hämta av matfiskarna som ni fångade nu.” ");
INSERT INTO swessb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Då steg Simon Petrus upp och drog nätet upp på land, fullt av stora fiskar, hundrafemtiotre. Och fast de var så många revs inte nätet itu. ");
INSERT INTO swessb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus säger till dem: ”Kom. Ät frukost.” Och ingen vågade av lärjungarna höra sig för hos honom: ”Vem är du?”, då de visste att det är Herren. ");
INSERT INTO swessb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus kommer och tar brödet och ger till dem, och matfisken likaså. ");
INSERT INTO swessb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Detta var redan tredje gången Jesus visade sig för lärjungarna uppväckt från de döda. ");
INSERT INTO swessb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","När de nu hade ätit frukost, säger Jesus till Simon Petrus: ”Simon, Johannes son. Älskar du mig mer än dessa?” Han säger till honom: ”Ja, Herre. Du vet att jag gillar dig.” Han säger till honom: ”Valla mina lamm.” ");
INSERT INTO swessb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Han säger till honom igen, en andra gång: ”Simon, Johannes son. Älskar du mig?” Han säger till honom: ”Ja, Herre. Du vet att jag gillar dig.” Han säger till honom: ”Var herde för mina får.” ");
INSERT INTO swessb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Han säger till honom den tredje gången: ”Simon, Johannes son. Gillar du mig?” Petrus blev bedrövad att han sade till honom den tredje gången: ”Gillar du mig?”, och han säger till honom: ”Herre, allt vet du. Du förstår att jag gillar dig.” Jesus säger till honom: ”Valla mina får. ");
INSERT INTO swessb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Amen amen, jag säger dig: När du var yngre, omgjordade du dig själv och vandrade vart du ville. Men när du blir gammal ska du räcka ut dina händer, och en annan ska omgjorda och föra dig dit du inte vill.” ");
INSERT INTO swessb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Och detta sade han angivande med vilken död han kommer att ära Gud. Och när han sagt detta, säger han till honom: ”Följ mig.” ");
INSERT INTO swessb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus vänder om och ser lärjungen som Jesus älskade följa efter, han som också hade legat vid måltiden på hans bröstkorg och sagt: ”Herre, vem är den som utlämnar dig?” ");
INSERT INTO swessb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Honom ser nu Petrus och säger till Jesus: ”Herre, men han då?” ");
INSERT INTO swessb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus säger till honom: ”Om jag vill att han är kvar tills jag kommer, vad är det för dig? Följ du mig.” ");
INSERT INTO swessb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Då gick detta ord ut till syskonen att den lärjungen inte dör. Men Jesus sade inte till honom att han inte dör, utan: ”Om jag vill att han är kvar tills jag kommer – vad är det för dig?” ");
INSERT INTO swessb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Det är den lärjungen som vittnar om detta och som har skrivit detta. Och vi vet att sant är hans vittnesbörd. ");
INSERT INTO swessb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Men det finns också många andra ting som Jesus gjorde, som om de skulle skrivas en efter en jag föreställer mig inte ens själva världen skulle ha rum för de böcker som då skrivs. ");
ALTER TABLE swessb_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
