﻿USE sofia;
DROP TABLE IF EXISTS sofia.swef_vpl;
CREATE TABLE swef_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swef_vpl WRITE;
INSERT INTO swef_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," I begynnelsen skapade Gud himmel och jord. ");
INSERT INTO swef_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Jorden var öde och tom, och mörker var över djupet. Och Guds Ande svävade över vattnet. ");
INSERT INTO swef_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Gud sade: ”Varde ljus!” Och det blev ljus. ");
INSERT INTO swef_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gud såg att ljuset var gott, och han skilde ljuset från mörkret. ");
INSERT INTO swef_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gud kallade ljuset dag, och mörkret kallade han natt. Och det blev afton och det blev morgon, den första dagen. ");
INSERT INTO swef_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Gud sade: ”Mitt i vattnet ska finnas ett valv som skiljer vatten från vatten.” ");
INSERT INTO swef_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gud gjorde valvet och skilde vattnet under valvet från vattnet över valvet. Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gud kallade valvet himmel. Och det blev afton och det blev morgon, den andra dagen. ");
INSERT INTO swef_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Gud sade: ”Vattnet under himlen ska samlas till en enda plats så att det torra blir synligt.” Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gud kallade det torra land, och vattensamlingen kallade han hav. Och Gud såg att det var gott. ");
INSERT INTO swef_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Gud sade: ”Jorden ska frambringa grönska, fröbärande örter och fruktträd, som bär frukt med frö efter sina slag på jorden.” Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Jorden frambringade grönska, fröbärande örter efter sina slag och träd som bär frukt med frö efter sina slag. Och Gud såg att det var gott. ");
INSERT INTO swef_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Och det blev afton och det blev morgon, den tredje dagen. ");
INSERT INTO swef_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Gud sade: ”På himlavalvet ska finnas ljus som skiljer dagen från natten. De ska vara tecken som utmärker högtider, dagar och år, ");
INSERT INTO swef_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","och de ska vara ljus på himlavalvet som lyser över jorden.” Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gud gjorde de två stora ljusen, det större att härska över dagen och det mindre att härska över natten, och likaså stjärnorna. ");
INSERT INTO swef_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Han satte dem på himlavalvet till att lysa över jorden, ");
INSERT INTO swef_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","att härska över dagen och natten och att skilja ljuset från mörkret. Och Gud såg att det var gott. ");
INSERT INTO swef_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Och det blev afton och det blev morgon, den fjärde dagen. ");
INSERT INTO swef_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Gud sade: ”Vattnet ska vimla av levande varelser, och fåglar ska flyga över jorden på himlavalvet.” ");
INSERT INTO swef_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Och Gud skapade de stora havsdjuren och alla levande varelser som rör sig och som vattnet vimlar av, alla efter deras slag, och alla bevingade fåglar efter deras slag. Och Gud såg att det var gott. ");
INSERT INTO swef_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Gud välsignade dem och sade: ”Var fruktsamma och föröka er och uppfyll vattnet i haven. Och fåglarna ska föröka sig på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Och det blev afton och det blev morgon, den femte dagen. ");
INSERT INTO swef_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Gud sade: ”Jorden ska frambringa levande varelser efter deras slag, boskapsdjur, kräldjur och jordens vilda djur efter deras slag.” Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gud gjorde jordens vilda djur efter deras slag, boskapsdjuren efter deras slag och markens alla kräldjur efter deras slag. Och Gud såg att det var gott. ");
INSERT INTO swef_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Gud sade: ”Låt oss göra människor till vår avbild, lika oss. De ska råda över havets fiskar och himlens fåglar, över boskapsdjuren och hela jorden och alla kräldjur som rör sig på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Och Gud skapade människan till sin avbild, till Guds avbild skapade han henne, till man och kvinna skapade han dem. ");
INSERT INTO swef_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Och Gud välsignade dem och sade till dem: ”Var fruktsamma och föröka er, uppfyll jorden och lägg den under er. Råd över havets fiskar, himlens fåglar och alla djur som rör sig på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Och Gud sade: ”Se, jag ger er alla fröbärande örter på hela jorden och alla träd med frukt som har frö. Det ska ni ha till föda. ");
INSERT INTO swef_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Och åt jordens alla djur, åt himlens alla fåglar och allt som krälar på jorden, allt som har liv, ger jag alla gröna örter till föda.” Och det blev så. ");
INSERT INTO swef_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gud såg på allt som han hade gjort, och se, det var mycket gott. Och det blev afton och det blev morgon, den sjätte dagen. ");
INSERT INTO swef_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Så fullbordades himlen och jorden med hela sin härskara. ");
INSERT INTO swef_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","På sjunde dagen hade Gud fullbordat sitt skapelseverk, och han vilade på sjunde dagen från hela det verk som han gjort. ");
INSERT INTO swef_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Och Gud välsignade den sjunde dagen och helgade den, för på den dagen vilade han från hela sitt verk som han hade skapat och gjort. ");
INSERT INTO swef_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Detta är himlens och jordens fortsatta historia sedan de skapats, när Herren Gud hade gjort jord och himmel. ");
INSERT INTO swef_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Markens alla buskar fanns ännu inte på jorden och markens alla örter hade ännu inte vuxit upp, för Herren Gud hade inte låtit det regna på jorden och det fanns ingen människa som kunde bruka den. ");
INSERT INTO swef_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Men en dimma kom upp ur jorden och vattnade hela marken. ");
INSERT INTO swef_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Och Herren Gud formade människan av jord från marken och blåste in livsande i hennes näsa. Så blev människan en levande varelse. ");
INSERT INTO swef_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Herren Gud planterade en lustgård i Eden, österut, och satte där människan som han hade format. ");
INSERT INTO swef_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Och Herren Gud lät alla slags träd växa upp ur marken, ljuvliga att se på och goda att äta av. Mitt i lustgården satte han livets träd och trädet med kunskap om gott och ont. ");
INSERT INTO swef_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Från Eden gick det ut en flod som vattnade lustgården och sedan delade sig i fyra huvudgrenar. ");
INSERT INTO swef_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Den första heter Pishon. Det är den som flyter runt hela landet Havila, där det finns guld. ");
INSERT INTO swef_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Guldet i det landet är gott, och där finns också bdelliumharts och onyxsten. ");
INSERT INTO swef_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Den andra floden heter Gihon. Det är den som flyter runt hela landet Kush. ");
INSERT INTO swef_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Den tredje floden heter Tigris. Det är den som flyter öster om Assur. Den fjärde floden är Eufrat. ");
INSERT INTO swef_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Herren Gud tog mannen och satte honom i Edens lustgård för att odla och bevara den. ");
INSERT INTO swef_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Och Herren Gud gav mannen denna befallning: ”Du kan äta fritt av alla träd i lustgården, ");
INSERT INTO swef_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","men av trädet med kunskap om gott och ont ska du inte äta, för den dag du äter av det ska du döden dö.” ");
INSERT INTO swef_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Herren Gud sade: ”Det är inte bra att mannen är ensam. Jag ska göra en medhjälpare åt honom, en som är hans like.” ");
INSERT INTO swef_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Herren Gud hade format alla markens djur och himlens alla fåglar av jord. Han förde fram dem till mannen för att se vad han skulle kalla dem. Så som mannen kallade varje levande varelse, så blev dess namn. ");
INSERT INTO swef_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Och mannen gav namn åt alla boskapsdjur, åt himlens fåglar och markens alla vilda djur. Men åt Adam fanns ingen medhjälpare som var hans like. ");
INSERT INTO swef_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Då lät Herren Gud en tung sömn falla över mannen. När han hade somnat, tog han ut ett av hans revben och fyllde dess plats med kött. ");
INSERT INTO swef_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Och Herren Gud byggde en kvinna av revbenet som han tagit från mannen och förde fram henne till honom. ");
INSERT INTO swef_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Då sade mannen: ”Äntligen! Hon är ben av mina ben och kött av mitt kött. Hon ska heta kvinna, för av man är hon tagen.” ");
INSERT INTO swef_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Därför ska en man lämna sin far och sin mor och hålla sig till sin hustru, och de ska bli ett kött. ");
INSERT INTO swef_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Och mannen och hans hustru var båda nakna utan att vara blyga för varandra. ");
INSERT INTO swef_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Men ormen var listigare än alla markens djur som Herren Gud hade gjort. Han sade till kvinnan: ”Har Gud verkligen sagt att ni inte får äta av alla träd i lustgården?” ");
INSERT INTO swef_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kvinnan svarade ormen: ”Vi får äta av frukten från träden i lustgården, ");
INSERT INTO swef_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","men om frukten på trädet mitt i lustgården har Gud sagt: Ät inte av den och rör inte vid den, för då kommer ni att dö.” ");
INSERT INTO swef_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Då sade ormen till kvinnan: ”Ni ska visst inte dö! ");
INSERT INTO swef_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Men Gud vet att den dag ni äter av den kommer era ögon att öppnas, och ni blir som Gud med kunskap om gott och ont.” ");
INSERT INTO swef_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Och kvinnan såg att trädet var gott att äta av och en fröjd för ögat. Trädet var lockande eftersom det gav förstånd, och hon tog av frukten och åt. Hon gav också till sin man som var med henne, och han åt. ");
INSERT INTO swef_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Då öppnades ögonen på dem båda, och de märkte att de var nakna. Och de fäste ihop fikonlöv och gjorde sig höftskynken. ");
INSERT INTO swef_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Vid kvällsbrisen hörde de Herren Gud vandra i lustgården. Och mannen och hans hustru gömde sig för Herren Guds ansikte bland lustgårdens träd. ");
INSERT INTO swef_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Men Herren Gud kallade på mannen och sade till honom: ”Var är du?” ");
INSERT INTO swef_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Han svarade: ”Jag hörde ljudet av dig i lustgården och blev rädd eftersom jag är naken. Därför gömde jag mig.” ");
INSERT INTO swef_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Då sade han: ”Vem har berättat för dig att du är naken? Har du ätit av trädet som jag förbjöd dig att äta av?” ");
INSERT INTO swef_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mannen svarade: ”Kvinnan som du satte vid min sida, hon gav mig av trädet och jag åt.” ");
INSERT INTO swef_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Då sade Herren Gud till kvinnan: ”Vad är det du har gjort?” Kvinnan svarade: ”Ormen förledde mig och jag åt.” ");
INSERT INTO swef_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Då sade Herren Gud till ormen: ”Eftersom du gjort detta, ska du vara förbannad bland alla boskapsdjur och vilda djur. På din buk ska du gå, och jord ska du äta så länge du lever. ");
INSERT INTO swef_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Jag ska sätta fiendskap mellan dig och kvinnan och mellan din avkomma och hennes avkomma. Han ska krossa ditt huvud och du ska hugga honom i hälen.” ");
INSERT INTO swef_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Till kvinnan sade han: ”Jag ska göra din möda stor när du blir havande. Med smärta ska du föda dina barn. Till din man ska din åtrå vara, och han ska råda över dig.” ");
INSERT INTO swef_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Till Adam sade han: ”Du lyssnade på din hustru och åt av trädet som jag befallde dig att inte äta av. Därför ska marken vara förbannad för din skull. Med möda ska du livnära dig av den så länge du lever. ");
INSERT INTO swef_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Törne och tistel ska den bära åt dig, och du ska äta av markens örter. ");
INSERT INTO swef_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I ditt anletes svett ska du äta ditt bröd tills du vänder åter till jorden, för av den är du tagen. Jord är du, och jord ska du åter bli.” ");
INSERT INTO swef_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mannen gav sin hustru namnet Eva, för hon blev mor till allt levande. ");
INSERT INTO swef_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Och Herren Gud gjorde kläder av skinn åt Adam och hans hustru och klädde dem. ");
INSERT INTO swef_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Herren Gud sade: ”Se, människan har blivit som en av oss med kunskap om gott och ont. Nu får hon inte räcka ut handen och ta även av livets träd och så äta och leva för evigt.” ");
INSERT INTO swef_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Och Herren Gud skickade bort dem från Edens lustgård för att bruka jorden som de tagits från. ");
INSERT INTO swef_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Han drev ut människan, och öster om Edens lustgård satte han keruberna och det flammande svärdets lågor för att bevaka vägen till livets träd. ");
INSERT INTO swef_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Mannen låg med sin hustru Eva, och hon blev havande och födde Kain. Då sade hon: ”Jag har fått en man från Herren.” ");
INSERT INTO swef_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hon födde en son till, Abel, Kains bror. Abel blev herde och Kain blev jordbrukare. ");
INSERT INTO swef_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Efter en tid hände sig att Kain bar fram en offergåva åt Herren av markens gröda. ");
INSERT INTO swef_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Även Abel bar fram sin gåva av det förstfödda i sin hjord, av djurens fett. Och Herren såg till Abel och hans offer, ");
INSERT INTO swef_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","men till Kain och hans offer såg han inte. Då blev Kain mycket vred och hans blick blev mörk. ");
INSERT INTO swef_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Och Herren sade till Kain: ”Varför är du vred och varför är din blick så mörk? ");
INSERT INTO swef_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Är det inte så att om du gör det som är gott, ser du frimodigt upp, men om du inte gör det som är gott, då lurar synden vid dörren. Den har begär till dig, men du ska råda över den.” ");
INSERT INTO swef_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain talade med sin bror Abel, och medan de var ute på marken överföll Kain sin bror och dödade honom. ");
INSERT INTO swef_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Och Herren sade till Kain: ”Var är din bror Abel?” Han svarade: ”Jag vet inte. Ska jag hålla reda på min bror?” ");
INSERT INTO swef_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Då sade han: ”Vad har du gjort? Hör, din brors blod ropar till mig från marken! ");
INSERT INTO swef_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nu är du förbannad mer än den jord som har öppnat sin mun för att ta emot din brors blod av din hand. ");
INSERT INTO swef_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","När du brukar jorden ska den inte längre ge dig sin gröda. Rotlös och hemlös ska du vara på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain sade då till Herren: ”Mitt brott är för stort för att förlåtas. ");
INSERT INTO swef_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Se, i dag driver du mig bort från åkerjorden, och jag är dold för ditt ansikte. Rotlös och hemlös blir jag på jorden, och vem som helst som möter mig kan döda mig.” ");
INSERT INTO swef_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Men Herren sade till honom: ”Kain ska bli hämnad sju gånger om, vem som än dödar honom.” Och Herren satte ett tecken på Kain så att ingen som mötte honom skulle döda honom. ");
INSERT INTO swef_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Så gick Kain bort från Herrens ansikte och bosatte sig i landet Nod, öster om Eden. ");
INSERT INTO swef_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain låg med sin hustru, och hon blev havande och födde Henok. Och Kain byggde en stad och kallade den Henok efter sin son. ");
INSERT INTO swef_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Åt Henok föddes Irad, och Irad blev far till Mehujael. Mehujael blev far till Metushael, och Metushael blev far till Lemek. ");
INSERT INTO swef_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek tog sig två hustrur, den ena hette Ada och den andra Silla. ");
INSERT INTO swef_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada födde Jabal. Han blev stamfar till dem som bor i tält och är boskapsskötare. ");
INSERT INTO swef_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hans bror hette Jubal. Han blev stamfar till alla dem som spelar harpa och flöjt. ");
INSERT INTO swef_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla födde också en son, Tubal-Kain. Han var smed och gjorde alla slags redskap av koppar och järn. Tubal-Kains syster hette Naama. ");
INSERT INTO swef_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemek sade till sina hustrur: ”Ada och Silla, hör på mig! Ni Lemeks hustrur, lyssna till mina ord: Jag dödar en man för ett sår och en ung man för ett blåmärke. ");
INSERT INTO swef_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Om Kain blir hämnad sju gånger, blir Lemek det sjuttiosju gånger.” ");
INSERT INTO swef_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam låg återigen med sin hustru, och hon födde en son som hon gav namnet Set. Hon sade: ”Gud har gett mig en annan avkomling i stället för Abel, eftersom Kain dödade honom.” ");
INSERT INTO swef_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Också Set fick en son och han gav honom namnet Enosh. Vid den tiden började man åkalla Herrens namn. ");
INSERT INTO swef_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Detta är boken om Adams fortsatta historia. När Gud skapade människor gjorde han dem lika Gud. ");
INSERT INTO swef_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Till man och kvinna skapade han dem. Han välsignade dem och gav dem namnet människa den dag de skapades. ");
INSERT INTO swef_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","När Adam var 130 år fick han en son som var lik honom, hans avbild. Han gav honom namnet Set. ");
INSERT INTO swef_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sedan Adam fått Set, levde han 800 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adams hela ålder – den tid han levde – blev 930 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","När Set var 105 år blev han far till Enosh. ");
INSERT INTO swef_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sedan Set hade fått Enosh levde han 807 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sets hela ålder blev alltså 912 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","När Enosh var 90 år blev han far till Kenan. ");
INSERT INTO swef_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sedan Enosh hade fått Kenan levde han 815 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshs hela ålder blev alltså 905 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","När Kenan var 70 år blev han far till Mahalalel. ");
INSERT INTO swef_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sedan Kenan hade fått Mahalalel levde han 840 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenans hela ålder blev alltså 910 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","När Mahalalel var 65 år blev han far till Jered. ");
INSERT INTO swef_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sedan Mahalalel hade fått Jered levde han 830 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalels hela ålder blev alltså 895 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","När Jered var 162 år blev han far till Henok. ");
INSERT INTO swef_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sedan Jered hade fått Henok levde han 800 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jereds hela ålder blev alltså 962 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","När Henok var 65 år blev han far till Metushela. ");
INSERT INTO swef_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Och sedan Henok hade fått Metushela vandrade han med Gud i 300 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henoks hela ålder blev alltså 365 år. ");
INSERT INTO swef_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Sedan Henok så hade vandrat med Gud fann man honom inte mer, för Gud hade hämtat honom. ");
INSERT INTO swef_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","När Metushela var 187 år blev han far till Lemek. ");
INSERT INTO swef_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sedan Metushela hade fått Lemek levde han 782 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metushelas hela ålder blev alltså 969 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","När Lemek var 182 år fick han en son. ");
INSERT INTO swef_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Han gav honom namnet Noa, för han sade: ”Han ska trösta oss under vårt arbete och våra händers möda, när vi brukar jorden som Herren har förbannat.” ");
INSERT INTO swef_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sedan Lemek hade fått Noa levde han 595 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemeks hela ålder blev alltså 777 år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","När Noa var 500 år blev han far till Sem, Ham och Jafet. ");
INSERT INTO swef_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","När människorna började föröka sig på jorden och döttrar föddes åt dem, ");
INSERT INTO swef_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","såg Guds söner att människornas döttrar var vackra, och de tog till hustrur alla de ville ha. ");
INSERT INTO swef_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Då sade Herren: ”Min Ande ska inte bli kvar i människorna för alltid på grund av deras förvillelse. De är kött och deras tid ska vara hundratjugo år.” ");
INSERT INTO swef_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Vid denna tid, då Guds söner gick in till människornas döttrar och dessa födde barn åt dem, och även senare, levde våldsverkarna på jorden. Detta var forntidens väldiga män som var så ryktbara. ");
INSERT INTO swef_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Och Herren såg att människornas ondska var stor på jorden och att deras hjärtans alla tankar och avsikter ständigt var alltigenom onda. ");
INSERT INTO swef_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Då sörjde Herren att han hade gjort människorna på jorden, och han var bedrövad i sitt hjärta. ");
INSERT INTO swef_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Herren sade: ”Människorna som jag har skapat ska jag utplåna från jordens yta – både människor och fyrfotadjur, kräldjur och himlens fåglar. Jag sörjer att jag har gjort dem.” ");
INSERT INTO swef_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Men Noa hade funnit nåd inför Herrens ögon. ");
INSERT INTO swef_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Detta är Noas fortsatta historia. Noa var en rättfärdig man och fullkomlig bland sina samtida. Han vandrade med Gud. ");
INSERT INTO swef_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Och Noa blev far till tre söner, Sem, Ham och Jafet. ");
INSERT INTO swef_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Men jorden blev mer och mer fördärvad inför Gud och full av våld. ");
INSERT INTO swef_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Gud såg på jorden, och se, den var fördärvad, eftersom alla människor levde i fördärv på jorden. ");
INSERT INTO swef_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Då sade Gud till Noa: ”Jag har bestämt mig för att göra slut på allt levande, för jorden är full av våld på grund av dem. Se, jag ska förgöra dem tillsammans med jorden. ");
INSERT INTO swef_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gör dig en ark av goferträ, inred den med kamrar och bestryk den med jordbeck både på insidan och utsidan. ");
INSERT INTO swef_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Så ska du göra arken: Den ska vara trehundra alnar lång, femtio alnar bred och trettio alnar hög. ");
INSERT INTO swef_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Högst upp ska du göra en öppning för ljuset, en aln hög, runt hela arken. En dörr till arken ska du sätta på sidan. Du ska inreda den så att den får en undervåning, en mellanvåning och en övervåning. ");
INSERT INTO swef_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Se, jag ska låta floden komma med vatten över jorden för att förgöra alla varelser under himlen som har livsande. Allt på jorden ska förgås. ");
INSERT INTO swef_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Men med dig vill jag upprätta mitt förbund. Du ska gå in i arken med dina söner, din hustru och dina sonhustrur. ");
INSERT INTO swef_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Av allt levande, av alla varelser, ska du föra in ett par i arken för att de ska överleva tillsammans med dig. Hankön och honkön ska det vara. ");
INSERT INTO swef_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Av fåglarna efter deras slag, av fyrfotadjuren efter deras slag och av alla kräldjur på marken efter deras slag ska ett par av varje slag gå in till dig för att förbli vid liv. ");
INSERT INTO swef_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Och du ska ta med dig all slags föda, sådant som kan ätas, och samla i förråd. Det ska tjäna som mat för dig och dem.” ");
INSERT INTO swef_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Och Noa gjorde så. Han gjorde i allt som Gud hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Herren sade till Noa: ”Gå in i arken med hela din familj. Dig har jag nämligen funnit rättfärdig inför mig i detta släkte. ");
INSERT INTO swef_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Av alla rena fyrfotadjur ska du ta med dig sju par, hanne och hona, men av sådana fyrfotadjur som inte är rena ett par, hanne och hona, ");
INSERT INTO swef_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","likaså av himlens fåglar sju par, hanne och hona, för att en avkomma ska leva vidare över hela jorden. ");
INSERT INTO swef_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Om sju dagar ska jag låta det regna på jorden i fyrtio dagar och fyrtio nätter, och jag ska utplåna från jorden alla varelser som jag har gjort.” ");
INSERT INTO swef_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Och Noa gjorde i allt som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa var sexhundra år när floden kom med sitt vatten över jorden. ");
INSERT INTO swef_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Han gick in i arken med sina söner och sin hustru och sina sonhustrur undan flodens vatten. ");
INSERT INTO swef_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Av både rena och orena fyrfotadjur, av fåglar och av allt som krälar på marken ");
INSERT INTO swef_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gick två och två, hanne och hona, in till Noa i arken, så som Gud hade befallt Noa. ");
INSERT INTO swef_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Och efter de sju dagarna kom flodens vatten över jorden. ");
INSERT INTO swef_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Det år då Noa var sexhundra år, på sjuttonde dagen i andra månaden, bröt alla det stora djupets källor fram, himlens fönster öppnades, ");
INSERT INTO swef_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","och det regnade över jorden i fyrtio dagar och fyrtio nätter. ");
INSERT INTO swef_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Just den dagen gick Noa in i arken tillsammans med sina söner Sem, Ham och Jafet, sin hustru och sina tre sonhustrur. ");
INSERT INTO swef_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","De hade med sig alla djur efter deras slag: vilda djur och boskapsdjur, kräldjur som rör sig på jorden och fåglar, alla flygande varelser. ");
INSERT INTO swef_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","De gick in till Noa i arken, två och två av allt levande, det som hade livsande i sig. ");
INSERT INTO swef_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","De som gick in var hanne och hona av allt levande, så som Gud hade befallt Noa. Och Herren stängde igen om honom. ");
INSERT INTO swef_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Floden kom över jorden i fyrtio dagar, och vattnet steg och lyfte arken så att den höjde sig över jorden. ");
INSERT INTO swef_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Vattnet tilltog och steg högt över jorden, och arken flöt på vattnet. ");
INSERT INTO swef_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Och vattnet bredde ut sig mer och mer över jorden, tills det täckte alla höga berg under hela himlen. ");
INSERT INTO swef_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Femton alnar över topparna steg vattnet, och bergen blev övertäckta. ");
INSERT INTO swef_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Då dog allt levande på jorden: fåglar och boskapsdjur, vilda djur och alla smådjur som rörde sig på jorden, likaså alla människor. ");
INSERT INTO swef_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Allt som fanns på torr mark omkom, allt som hade livsande i sig. ");
INSERT INTO swef_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Alla levande varelser på jordens yta utplånades, både människor och fyrfotadjur, kräldjur och himlens fåglar. De utplånades från jorden. Bara Noa och de som var med honom i arken räddades. ");
INSERT INTO swef_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Och vattnet stod högt över jorden i hundrafemtio dagar. ");
INSERT INTO swef_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Men Gud tänkte på Noa och på alla vilda djur och alla boskapsdjur som var med honom i arken, och han lät en vind gå fram över jorden, så att vattnet sjönk undan. ");
INSERT INTO swef_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Djupets källor och himlens fönster stängdes och regnet från himlen upphörde. ");
INSERT INTO swef_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Vattnet drog sig tillbaka från jorden mer och mer. Efter hundrafemtio dagar började det avta. ");
INSERT INTO swef_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Den sjuttonde dagen i sjunde månaden stannade arken på Araratbergen. ");
INSERT INTO swef_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Vattnet fortsatte att minska fram till den tionde månaden. Första dagen i den månaden blev bergstopparna synliga. ");
INSERT INTO swef_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Efter fyrtio dagar öppnade Noa luckan som han hade gjort på arken ");
INSERT INTO swef_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","och lät en korp flyga ut. Den flög fram och tillbaka, tills vattnet hade torkat bort från jorden. ");
INSERT INTO swef_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Sedan lät han en duva flyga ut för att få se om vattnet hade sjunkit undan från jordens yta. ");
INSERT INTO swef_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Men duvan hittade ingen plats där hon kunde vila sin fot utan kom tillbaka till honom i arken, eftersom vatten täckte hela jorden. Då räckte Noa ut handen och tog in duvan till sig i arken. ");
INSERT INTO swef_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Sedan väntade han ytterligare sju dagar innan han lät duvan flyga ut ur arken än en gång. ");
INSERT INTO swef_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mot kvällen kom hon tillbaka till honom, och se, då hade hon ett friskt olivlöv i näbben. Noa förstod då att vattnet hade sjunkit undan från jorden. ");
INSERT INTO swef_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Men han väntade ännu sju dagar innan han lät duvan flyga ut igen. Då kom hon inte mer tillbaka till honom. ");
INSERT INTO swef_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Det sexhundraförsta året, på första dagen i den första månaden, hade vattnet torkat bort från jorden. Då tog Noa av taket på arken och såg att jordytan hade torkat. ");
INSERT INTO swef_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Och den tjugosjunde dagen i andra månaden var jorden alldeles torr. ");
INSERT INTO swef_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Då talade Gud till Noa och sade: ");
INSERT INTO swef_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","”Gå ut ur arken med din hustru, dina söner och dina sonhustrur. ");
INSERT INTO swef_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Låt alla de djur, allt levande som du har hos dig, gå med dig, både fåglar och fyrfotadjur och alla kräldjur som rör sig på marken, så att de växer till och blir fruktsamma och förökar sig på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Så gick Noa ut med sina söner, sin hustru och sina sonhustrur. ");
INSERT INTO swef_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Och alla fyrfotadjur och kräldjur, alla fåglar och alla djur som rör sig på jorden, alla efter sina slag, gick ut ur arken. ");
INSERT INTO swef_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa byggde ett altare åt Herren och tog av alla rena fyrfotadjur och av alla rena fåglar och offrade brännoffer på altaret. ");
INSERT INTO swef_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","När Herren kände den ljuvliga doften, sade han till sig själv: ”Härefter ska jag inte mer förbanna marken för människans skull, för hennes hjärtas tankar är onda ända från ungdomen. Jag ska aldrig mer döda allt levande så som jag nu har gjort. ");
INSERT INTO swef_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Så länge jorden består ska sådd och skörd, köld och värme, sommar och vinter, dag och natt aldrig upphöra.” ");
INSERT INTO swef_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gud välsignade Noa och hans söner och sade till dem: ”Var fruktsamma, föröka er och uppfyll jorden. ");
INSERT INTO swef_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Fruktan och skräck för er ska komma över alla djur på jorden och alla fåglar under himlen, över allt som krälar på marken och över alla fiskar i havet. De är givna i er hand. ");
INSERT INTO swef_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Allt som rör sig och lever ska ni ha till föda. Så som jag har gett er de gröna örterna ger jag er nu allt detta. ");
INSERT INTO swef_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Men kött som har kvar sitt liv, nämligen sitt blod, ska ni inte äta. ");
INSERT INTO swef_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Och för ert eget blod, alltså ert liv, ska jag kräva räkenskap. Jag ska utkräva det av alla djur, och likaså av människorna. Av var och en som dödar sin broder ska jag utkräva den människans liv. ");
INSERT INTO swef_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Den som spiller människoblod, hans blod ska utgjutas av människor, för Gud har gjort människan till sin avbild. ");
INSERT INTO swef_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Men var fruktsamma och föröka er. Väx till på jorden och föröka er på den.” ");
INSERT INTO swef_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Vidare sade Gud till Noa och hans söner: ");
INSERT INTO swef_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","”Se, jag ska upprätta mitt förbund med er och era efterkommande efter er ");
INSERT INTO swef_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","och med alla levande varelser som är hos er: fåglar, boskapsdjur och jordens alla vilda djur, alla som har gått ut ur arken, alla djur på jorden. ");
INSERT INTO swef_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Jag ska upprätta mitt förbund med er: Aldrig mer ska allt liv utrotas genom flodens vatten. Aldrig mer ska en flod komma och fördärva jorden.” ");
INSERT INTO swef_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Och Gud sade: ”Detta är tecknet på det förbund som jag för all framtid sluter med er och med alla levande varelser hos er: ");
INSERT INTO swef_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Min båge sätter jag i skyn, och den ska vara tecknet på förbundet mellan mig och jorden. ");
INSERT INTO swef_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","När jag låter moln stiga upp över jorden och bågen syns i skyn ");
INSERT INTO swef_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ska jag tänka på mitt förbund, det som har slutits mellan mig och er och alla levande varelser, allt liv, och vattnet ska inte mer bli en flod som utplånar allt liv. ");
INSERT INTO swef_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","När bågen syns i skyn och jag ser på den, ska jag tänka på det eviga förbundet mellan Gud och alla levande varelser, allt liv på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Och Gud sade till Noa: ”Detta är tecknet på det förbund som jag har upprättat mellan mig och allt liv på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noas söner som gick ut ur arken var Sem, Ham och Jafet. Ham var far till Kanaan. ");
INSERT INTO swef_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dessa tre var Noas söner och från dem har jordens alla folk spritt ut sig. ");
INSERT INTO swef_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa var jordbrukare och den förste som anlade en vingård. ");
INSERT INTO swef_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Men när han drack av vinet blev han berusad och låg blottad i sitt tält. ");
INSERT INTO swef_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, Kanaans far, såg sin far naken och berättade det för sina båda bröder, som var utanför tältet. ");
INSERT INTO swef_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Men Sem och Jafet tog en mantel och lade den på sina axlar, gick baklänges in och täckte över sin fars nakna kropp. De vände bort ansiktet så att de inte såg sin fars nakenhet. ");
INSERT INTO swef_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","När Noa vaknade upp ur ruset och fick veta vad hans yngste son hade gjort honom, sade han: ");
INSERT INTO swef_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","”Förbannad ska Kanaan bli, en slavars slav åt sina bröder!” ");
INSERT INTO swef_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Han sade vidare: ”Välsignad är Herren, Sems Gud! Och Kanaan ska bli hans slav. ");
INSERT INTO swef_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gud ska utvidga Jafet, han ska bo i Sems tält. Och Kanaan ska bli deras slav.” ");
INSERT INTO swef_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa levde trehundrafemtio år efter floden. ");
INSERT INTO swef_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Alltså blev Noas hela ålder niohundrafemtio år. Därefter dog han. ");
INSERT INTO swef_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Detta är Noas söners fortsatta historia, Sems, Hams och Jafets. Åt dem föddes söner efter floden. ");
INSERT INTO swef_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafets söner var Gomer, Magog, Madaj, Javan, Tubal, Meshek och Tiras. ");
INSERT INTO swef_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomers söner var Ashkenas, Rifat och Togarma. ");
INSERT INTO swef_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javans söner var Elisha och Tarshish, kitteerna och dodaneerna. ");
INSERT INTO swef_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Från dessa har folken i hedningarnas kustområden spritt ut sig i sina länder, alla med sitt språk i sina stammar och folk. ");
INSERT INTO swef_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hams söner var Kush, Misrajim, Put och Kanaan. ");
INSERT INTO swef_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Söner till Kush var Seba, Havila, Sabta, Raama och Sabteka. Raamas söner var Saba och Dedan. ");
INSERT INTO swef_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush blev far till Nimrod, som var den förste som fick stor makt på jorden. ");
INSERT INTO swef_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Han var en väldig jägare inför Herren. Därför brukar man säga: ”En väldig jägare inför Herren som Nimrod.” ");
INSERT INTO swef_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hans rike hade sin början i Babel, Erek, Akkad och Kalne i Shinars land. ");
INSERT INTO swef_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Från det landet drog han sedan ut till Assyrien och byggde Nineve, Rehobot-Ir, Kela ");
INSERT INTO swef_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","och Resen mellan Nineve och Kela. Detta är den stora staden. ");
INSERT INTO swef_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrajim blev far till ludeerna, anameerna, lehabeerna, naftuheerna, ");
INSERT INTO swef_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patroseerna, kasluheerna, den stam som filisteerna härstammar från, och kaftoreerna. ");
INSERT INTO swef_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan blev far till Sidon, som var hans förstfödde, och Het, ");
INSERT INTO swef_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","vidare jebusiterna, amoreerna, girgasheerna, ");
INSERT INTO swef_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","hiveerna, arkeerna, sineerna, ");
INSERT INTO swef_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeerna, semareerna och hamateerna. Senare utbredde sig kananeernas släkter ytterligare ");
INSERT INTO swef_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","så att deras område sträckte sig från Sidon mot Gerar ända till Gaza och mot Sodom, Gomorra, Adma och Sebojim ända till Lasha. ");
INSERT INTO swef_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Detta var Hams söner efter deras stammar och språk i deras länder och bland deras folk. ");
INSERT INTO swef_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Söner föddes också åt Sem, Jafets äldre bror, och han blev stamfar till alla Ebers söner. ");
INSERT INTO swef_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sems söner var Elam, Assur, Arpakshad, Lud och Aram. ");
INSERT INTO swef_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arams söner var Us, Hul, Geter och Mash. ");
INSERT INTO swef_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakshad blev far till Shela och Shela blev far till Eber. ");
INSERT INTO swef_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Men åt Eber föddes två söner. Den ene hette Peleg, för under hans tid blev jorden uppdelad. Hans bror hette Joktan. ");
INSERT INTO swef_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan blev far till Almodad, Shelef, Hasarmavet, Jera, ");
INSERT INTO swef_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO swef_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Saba, ");
INSERT INTO swef_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila och Jobab. Alla dessa var Joktans söner. ");
INSERT INTO swef_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","De hade sina boplatser från Mesha mot Sefar, mot bergsområdet i öster. ");
INSERT INTO swef_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Detta var Sems söner efter deras stammar och språk i deras länder och efter deras folk. ");
INSERT INTO swef_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Detta var Noas söners stammar efter deras släktled i deras folk. Från dem har folken utbrett sig på jorden efter floden. ");
INSERT INTO swef_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hela jorden hade ett enda språk och samma ord. ");
INSERT INTO swef_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Men när människorna bröt upp och drog österut, fann de en lågslätt i Shinars land och bosatte sig där. ");
INSERT INTO swef_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","De sade till varandra: ”Kom, så slår vi tegel och bränner det!” Teglet använde de som sten, och som murbruk använde de jordbeck. ");
INSERT INTO swef_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Och de sade: ”Kom, så bygger vi oss en stad och ett torn med spetsen uppe i himlen! Låt oss göra oss ett namn, så att vi inte sprids ut över hela jorden.” ");
INSERT INTO swef_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Då steg Herren ner för att se på staden och tornet som människorna byggde. ");
INSERT INTO swef_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Herren sade: ”Se, de är ett enda folk och de har ett enda språk. Detta är deras första tilltag, och härefter ska ingenting vara omöjligt för dem vad de än beslutar sig för. ");
INSERT INTO swef_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Låt oss stiga ner och förbistra deras språk, så att den ene inte förstår vad den andre säger.” ");
INSERT INTO swef_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Så spred Herren ut dem därifrån över hela jorden, och de slutade bygga på staden. ");
INSERT INTO swef_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Den fick namnet Babel, eftersom Herren där förbistrade hela jordens språk, och därifrån spred han ut dem över hela jorden. ");
INSERT INTO swef_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Detta är Sems fortsatta historia. När Sem var 100 år blev han far till Arpakshad, två år efter floden. ");
INSERT INTO swef_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sedan Sem hade fått Arpakshad levde han 500 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","När Arpakshad var 35 år blev han far till Shela. ");
INSERT INTO swef_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sedan Arpakshad hade fått Shela levde han 403 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","När Shela var 30 år blev han far till Eber. ");
INSERT INTO swef_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sedan Shela hade fått Eber levde han 403 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","När Eber var 34 år blev han far till Peleg. ");
INSERT INTO swef_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sedan Eber hade fått Peleg levde han 430 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","När Peleg var 30 år blev han far till Regu. ");
INSERT INTO swef_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sedan Peleg hade fått Regu levde han 209 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","När Regu var 32 år blev han far till Serug. ");
INSERT INTO swef_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sedan Regu hade fått Serug levde han 207 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","När Serug var 30 år blev han far till Nahor. ");
INSERT INTO swef_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sedan Serug hade fått Nahor levde han 200 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","När Nahor var 29 år blev han far till Tera. ");
INSERT INTO swef_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sedan Nahor hade fått Tera levde han 119 år och fick söner och döttrar. ");
INSERT INTO swef_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","När Tera var 70 år blev han far till Abram, Nahor och Haran. ");
INSERT INTO swef_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Detta är Teras fortsatta historia. Tera blev far till Abram, Nahor och Haran. Och Haran blev far till Lot. ");
INSERT INTO swef_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran dog hos sin far Tera i sitt fädernesland, det kaldeiska Ur. ");
INSERT INTO swef_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram och Nahor tog sig hustrur. Abrams hustru hette Saraj, och Nahors hustru hette Milka. Hon var dotter till Haran, som var far till Milka och Jiska. ");
INSERT INTO swef_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Men Saraj var ofruktsam och hade inga barn. ");
INSERT INTO swef_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Och Tera tog med sig sin son Abram och sin sonson Lot, Harans son, och sin sonhustru Saraj, som var hustru till hans son Abram. De drog tillsammans ut från det kaldeiska Ur för att bege sig till Kanaans land. Men när de kom till Harran bosatte de sig där. ");
INSERT INTO swef_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teras ålder blev tvåhundrafem år, och Tera dog i Harran. ");
INSERT INTO swef_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Herren sade till Abram: ”Gå ut från ditt land och din släkt och din fars hus och bege dig till det land som jag ska visa dig. ");
INSERT INTO swef_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Där ska jag göra dig till ett stort folk. Jag ska välsigna dig och göra ditt namn stort, och du ska bli en välsignelse. ");
INSERT INTO swef_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Jag ska välsigna dem som välsignar dig och förbanna den som förbannar dig. I dig ska jordens alla släkten bli välsignade.” ");
INSERT INTO swef_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram gav sig i väg som Herren hade sagt till honom, och Lot gick med honom. Abram var sjuttiofem år när han lämnade Harran. ");
INSERT INTO swef_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Han tog med sig sin hustru Saraj och sin brorson Lot, alla ägodelar och allt det folk de skaffat sig i Harran och gav sig av mot Kanaans land. När de kom till Kanaans land ");
INSERT INTO swef_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","fortsatte Abram in i landet ända till Shekems område, till Mores terebint. På den tiden bodde kananeerna i landet. ");
INSERT INTO swef_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Och Herren uppenbarade sig för Abram och sade: ”Åt dina efterkommande ska jag ge detta land.” Då byggde han ett altare åt Herren som hade uppenbarat sig för honom. ");
INSERT INTO swef_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Därifrån drog han vidare till berget öster om Betel och slog upp sitt tält med Betel i väster och Ai i öster. Där byggde han ett altare åt Herren och åkallade Herrens namn. ");
INSERT INTO swef_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sedan bröt Abram upp därifrån och drog sig allt längre söderut. ");
INSERT INTO swef_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Men det blev svält i landet, och Abram flyttade ner till Egypten för att bo där som främling, eftersom svälten var svår i landet. ");
INSERT INTO swef_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","När han närmade sig Egypten, sade han till sin hustru Saraj: ”Jag vet ju att du är en vacker kvinna. ");
INSERT INTO swef_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","När egyptierna får se dig kommer de att säga: Hon är hans hustru! Och så dödar de mig men låter dig leva. ");
INSERT INTO swef_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Säg därför att du är min syster, så går det bra för mig för din skull och jag får leva tack vare dig.” ");
INSERT INTO swef_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","När Abram kom till Egypten, såg egyptierna att Saraj var en mycket vacker kvinna. ");
INSERT INTO swef_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Faraos hövdingar fick se henne och prisade henne inför farao, och hon fördes in i faraos palats. ");
INSERT INTO swef_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Och det gick bra för Abram för hennes skull. Han fick får, kor och åsnor, tjänare och tjänarinnor, åsneston och kameler. ");
INSERT INTO swef_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Men Herren lät farao och hans hus drabbas av svåra plågor för Abrams hustru Sarajs skull. ");
INSERT INTO swef_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Då kallade farao till sig Abram och sade: ”Vad har du gjort mot mig! Varför berättade du inte för mig att hon är din hustru? ");
INSERT INTO swef_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Varför sade du: Hon är min syster, så att jag tog henne till hustru? Här har du din hustru. Ta henne och gå!” ");
INSERT INTO swef_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Och farao befallde sina män att skicka i väg Abram med hans hustru och allt han ägde. ");
INSERT INTO swef_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Så bröt Abram upp från Egypten och begav sig till Negev med sin hustru och allt han ägde, och Lot var med honom. ");
INSERT INTO swef_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram var mycket rik på boskap och på silver och guld. ");
INSERT INTO swef_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Han färdades från lägerplats till lägerplats, från Negev ända till Betel, platsen där hans tält hade stått förut mellan Betel och Ai ");
INSERT INTO swef_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","och där han förra gången hade rest ett altare. Där åkallade Abram Herrens namn. ");
INSERT INTO swef_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, som följde med Abram, hade också får och kor och tält, ");
INSERT INTO swef_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","och landet kunde inte livnära dem där de bodde i samma område. De hade så mycket boskap att de inte kunde bo tillsammans, ");
INSERT INTO swef_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","och det uppstod tvister mellan Abrams och Lots herdar. Dessutom bodde kananeerna och perisseerna i landet vid den tiden. ");
INSERT INTO swef_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Då sade Abram till Lot: ”Inte ska det vara någon tvist mellan mig och dig eller mellan mina herdar och dina. Vi är ju bröder. ");
INSERT INTO swef_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ligger inte hela landet öppet för dig? Skilj dig från mig. Vill du åt vänster så går jag åt höger, och vill du åt höger så går jag åt vänster.” ");
INSERT INTO swef_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot lyfte blicken och såg hela Jordanslätten, som överallt var rik på vatten. Innan Herren ödelade Sodom och Gomorra var den nämligen som en Herrens lustgård, som Egyptens land, ända till Soar. ");
INSERT INTO swef_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Och Lot valde hela Jordanslätten åt sig själv. Han bröt upp och drog österut, och de skildes från varandra. ");
INSERT INTO swef_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram bodde kvar i Kanaans land, och Lot bodde i städerna på slätten och drog med sina tält ända bort mot Sodom. ");
INSERT INTO swef_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Men Sodoms män var onda och stora syndare inför Herren. ");
INSERT INTO swef_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Herren sade till Abram efter att Lot hade skilt sig från honom: ”Lyft din blick och se dig omkring från den plats där du står, mot norr och söder, öster och väster. ");
INSERT INTO swef_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Hela det land som du ser ska jag ge åt dig och dina efterkommande för evig tid. ");
INSERT INTO swef_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Och jag ska låta dem bli som stoftet på jorden. Om någon kan räkna stoftet på jorden ska också dina efterkommande kunna räknas. ");
INSERT INTO swef_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bryt upp och vandra omkring i landet i hela dess längd och bredd, för jag ska ge det åt dig.” ");
INSERT INTO swef_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram flyttade då sina tält och kom till Mamres terebintlund vid Hebron. Där bosatte han sig och byggde ett altare åt Herren. ");
INSERT INTO swef_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Vid den tid då Amrafel var kung i Shinar, Arjok kung i Ellasar, Kedorlaomer kung i Elam och Tidal kung över Gojim, ");
INSERT INTO swef_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","förde dessa kungar krig mot Sodoms kung Bera, Gomorras kung Birsha, Admas kung Shinab, Sebojims kung Shemeber samt kungen i Bela, det vill säga Soar. ");
INSERT INTO swef_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Alla dessa förenade sig och tågade till Siddimsdalen där Döda havet nu ligger. ");
INSERT INTO swef_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","I tolv år hade de varit under Kedorlaomer, men under det trettonde året hade de gjort uppror. ");
INSERT INTO swef_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Under det fjortonde året kom Kedorlaomer tillsammans med kungarna som var på hans sida, och de slog rafaeerna i Ashterot-Karnajim, suseerna i Ham, emeerna i Shave-Kirjatajim ");
INSERT INTO swef_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","och horeerna på deras berg Seir och drev dem ända till El-Paran vid öknen. ");
INSERT INTO swef_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sedan vände de om och kom till En-Mishpat, det vill säga Kadesh, och erövrade hela amalekiternas land. De slog också amoreerna som bodde i Hasason-Tamar. ");
INSERT INTO swef_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodoms kung drog då ut tillsammans med Gomorras kung, Admas kung, Sebojims kung och kungen i Bela, det vill säga Soar. De ställde upp sig till strid mot dem i Siddimsdalen, ");
INSERT INTO swef_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mot Elams kung Kedorlaomer, Gojims kung Tidal, Shinars kung Amrafel och Ellasars kung Arjok – fyra kungar mot fem. ");
INSERT INTO swef_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Men Siddimsdalen var full av jordbecksgropar. Sodoms och Gomorras kungar flydde och föll då ner i dem. De andra flydde till bergsbygden. ");
INSERT INTO swef_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Så tog man all egendom och alla livsmedel som fanns i Sodom och Gomorra och tågade bort. ");
INSERT INTO swef_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","De tog också med sig Abrams brorson Lot och allt han ägde, eftersom han bodde i Sodom. ");
INSERT INTO swef_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Men en som lyckats fly kom och berättade detta för Abram, hebrén. Han bodde vid amorén Mamres terebintlund. Mamre var bror till Eshkol och Aner, och de var i förbund med Abram. ");
INSERT INTO swef_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","När Abram hörde att hans släkting var tillfångatagen lät han sina mest erfarna män rycka ut, trehundraarton män som var födda i hans hus, och de förföljde fienderna ända till Dan. ");
INSERT INTO swef_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Han delade upp sitt folk och överföll dem med sina tjänare om natten, slog dem och förföljde dem ända till Hoba norr om Damaskus ");
INSERT INTO swef_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","och tog tillbaka all egendom. Sin släkting Lot och hans ägodelar tog han också tillbaka, liksom kvinnorna och det övriga folket. ");
INSERT INTO swef_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","När Abram hade kommit tillbaka efter att ha slagit Kedorlaomer och kungarna som var med honom, gick Sodoms kung ut för att möta honom i Shavedalen, det vill säga Kungadalen. ");
INSERT INTO swef_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Och Melkisedek, kungen i Salem, lät bära ut bröd och vin. Han var präst åt Gud den Högste, ");
INSERT INTO swef_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","och han välsignade Abram och sade: ”Välsignad vare Abram av Gud den Högste, skapare av himmel och jord! ");
INSERT INTO swef_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Och välsignad vare Gud den Högste, som gett dina fiender i din hand!” Och Abram gav honom tionde av allt. ");
INSERT INTO swef_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodoms kung sade till Abram: ”Ge mig folket. Bytet kan du ta själv.” ");
INSERT INTO swef_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Men Abram svarade Sodoms kung: ”Jag lyfter min hand till Herren, till Gud den Högste, skapare av himmel och jord: ");
INSERT INTO swef_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Jag vill inte ta ens en tråd eller en sandalrem eller något annat av det som är ditt. Du ska inte kunna säga: Jag har gjort Abram rik. ");
INSERT INTO swef_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Jag vill inte ha något, det räcker med vad mina män har ätit och mina följeslagares andel. Aner, Eshkol och Mamre ska få sin del.” ");
INSERT INTO swef_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Därefter kom Herrens ord till Abram i en syn. Han sade: ”Var inte rädd, Abram. Jag är din sköld. Din lön ska bli mycket stor.” ");
INSERT INTO swef_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Men Abram sade: ”Herre Gud, vad ska du ge mig? Jag går ju bort barnlös, och arvinge till mitt hus är Elieser från Damaskus.” ");
INSERT INTO swef_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Och Abram fortsatte: ”Se, mig har du inte gett någon avkomling. Så det blir en av mitt husfolk som ärver mig.” ");
INSERT INTO swef_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Men Herrens ord kom till honom: ”Det är inte han som ska ärva dig. En som kommer från din egen kropp ska bli din arvinge.” ");
INSERT INTO swef_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Sedan förde han honom ut och sade: ”Se upp mot himlen och räkna stjärnorna, om du kan räkna dem.” Och han sade till honom: ”Så ska din avkomma bli.” ");
INSERT INTO swef_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Och Abram trodde på Herren, och han räknade honom det till rättfärdighet. ");
INSERT INTO swef_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Sedan sade han till honom: ”Jag är Herren, som har fört dig ut från det kaldeiska Ur för att ge dig detta land till arvedel.” ");
INSERT INTO swef_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Han svarade: ”Herre Gud, hur ska jag veta att jag kommer att ärva det?” ");
INSERT INTO swef_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Då sade han till honom: ”Hämta åt mig en treårig kviga, en treårig get, en treårig bagge, en turturduva och en ung duva.” ");
INSERT INTO swef_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Han hämtade alla dessa åt honom, styckade dem mitt itu och lade styckena mot varandra. Men fåglarna styckade han inte. ");
INSERT INTO swef_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Rovfåglar slog sig ner på de döda kropparna, men Abram drev bort dem. ");
INSERT INTO swef_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","När solen höll på att gå ner föll en tung sömn över Abram. Då kom skräck och ett stort mörker över honom. ");
INSERT INTO swef_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Och Herren sade till Abram: ”Du ska veta att dina efterkommande ska bo som främlingar i ett land som inte är deras där man ska göra dem till slavar och förtrycka dem i fyrahundra år. ");
INSERT INTO swef_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Men det folk som gör dem till slavar ska jag döma. Sedan ska de dra ut med stora ägodelar. ");
INSERT INTO swef_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Men du själv ska gå till dina fäder i frid och bli begravd vid hög ålder. ");
INSERT INTO swef_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I fjärde släktledet ska de återvända hit, för amoreerna har ännu inte fyllt sina synders mått.” ");
INSERT INTO swef_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","När solen hade gått ner och det blivit alldeles mörkt, syntes en rykande ugn med en brinnande fackla som gick fram mellan köttstyckena. ");
INSERT INTO swef_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","På den dagen slöt Herren ett förbund med Abram och sade: ”Åt dina efterkommande ska jag ge detta land, från Egyptens flod ända till den stora floden, floden Eufrat: ");
INSERT INTO swef_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","keniternas, kenisiternas, kadmoneernas, ");
INSERT INTO swef_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hetiternas, perisseernas, rafaeernas, ");
INSERT INTO swef_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amoreernas, kananeernas, girgasheernas och jebusiternas land.” ");
INSERT INTO swef_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrams hustru Saraj hade inte fött några barn åt honom. Men hon hade en egyptisk slavinna som hette Hagar. ");
INSERT INTO swef_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Och Saraj sade till Abram: ”Se, Herren har gjort mig ofruktsam. Gå in till min slavinna. Kanske kan jag få barn genom henne.” Och Abram lyssnade till Sarajs ord. ");
INSERT INTO swef_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","När Abram hade bott tio år i Kanaans land, tog hans hustru Saraj sin egyptiska slavinna Hagar och gav henne till hustru åt sin man Abram. ");
INSERT INTO swef_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Han gick in till Hagar och hon blev havande. Men när hon märkte att hon var havande, började hon förakta sin husmor. ");
INSERT INTO swef_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Då sade Saraj till Abram: ”Den kränkning jag utsätts för ska komma över dig. Jag lade själv min slavinna i din famn, men när hon märkte att hon var havande började hon förakta mig. Herren får döma mellan mig och dig.” ");
INSERT INTO swef_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram sade till Saraj: ”Se, din slavinna är i din hand. Gör med henne som du finner bäst.” När Saraj då bestraffade henne, flydde hon bort från henne. ");
INSERT INTO swef_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Men Herrens ängel fann henne vid en vattenkälla i öknen, den källa som ligger vid vägen till Shur. ");
INSERT INTO swef_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Han sade: ”Hagar, Sarajs slavinna, varifrån kommer du och vart går du?” Hon svarade: ”Jag är på flykt från min husmor Saraj.” ");
INSERT INTO swef_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Då sade Herrens ängel till henne: ”Gå tillbaka till din husmor och ödmjuka dig under henne.” ");
INSERT INTO swef_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Och Herrens ängel fortsatte: ”Jag ska göra dina efterkommande så talrika att man inte kan räkna dem.” ");
INSERT INTO swef_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sedan sade Herrens ängel till henne: ”Se, du är havande, och du ska föda en son. Du ska kalla honom Ismael, för Herren har hört hur du har lidit. ");
INSERT INTO swef_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Han ska vara som en vildåsna. Hans hand ska vara mot alla och allas hand mot honom. Och han ska bo mitt emot alla sina bröder.” ");
INSERT INTO swef_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Och hon gav ett namn åt Herren som hade talat med henne. Hon sade: ”Du är den Gud som ser mig”, för hon tänkte: ”Har jag här fått se en skymt av honom som ser mig?” ");
INSERT INTO swef_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Därför kallar man brunnen Beer-Lahaj-Roi. Den ligger mellan Kadesh och Bered. ");
INSERT INTO swef_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar födde en son åt Abram. Och Abram gav sonen som Hagar fött namnet Ismael. ");
INSERT INTO swef_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram var åttiosex år när Hagar födde Ismael åt honom. ");
INSERT INTO swef_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","När Abram var nittionio år uppenbarade sig Herren för honom och sade: ”Jag är Gud den Allsmäktige. Vandra inför mig och var fullkomlig. ");
INSERT INTO swef_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jag ska upprätta mitt förbund mellan mig och dig, och jag ska föröka dig mycket.” ");
INSERT INTO swef_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Då föll Abram ner på sitt ansikte, och Gud sade till honom: ");
INSERT INTO swef_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","”Se, detta är mitt förbund med dig: Du ska bli far till många folk. ");
INSERT INTO swef_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Därför ska du inte mer heta Abram, utan ditt namn ska vara Abraham, för jag har gjort dig till far för många folk. ");
INSERT INTO swef_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Jag ska göra dig mycket fruktsam och låta folkslag komma från dig, och kungar ska utgå från dig. ");
INSERT INTO swef_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Och jag ska upprätta mitt förbund mellan mig och dig och dina efterkommande från släkte till släkte, ett evigt förbund. Jag ska vara din Gud och dina efterkommandes Gud. ");
INSERT INTO swef_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Det land där du bor som främling, hela Kanaans land, ska jag ge åt dig och dina efterkommande som egendom för evigt. Och jag ska vara deras Gud.” ");
INSERT INTO swef_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Sedan sade Gud till Abraham: ”Du ska hålla mitt förbund, du och dina efterkommande från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Och detta är det förbund mellan mig och dig och dina efterkommande som ni ska hålla: Alla av manligt kön hos er ska omskäras. ");
INSERT INTO swef_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ni ska skära bort er förhud, och det ska vara tecknet på förbundet mellan mig och er. ");
INSERT INTO swef_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","I generation efter generation ska ni omskära alla av manligt kön bland er när de är åtta dagar gamla, både den som är född i huset och den som köpts för pengar från främmande folk och som inte är din ättling. ");
INSERT INTO swef_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Den som är född i ditt hus och den som du köpt för pengar ska omskäras. Mitt förbund ska vara på ert kött som ett evigt förbund. ");
INSERT INTO swef_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Men en oomskuren, en av manligt kön som inte fått förhuden bortskuren, han ska utrotas från sitt folk. Han har brutit mitt förbund.” ");
INSERT INTO swef_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Och Gud sade till Abraham: ”Din hustru Saraj ska du inte mer kalla Saraj, utan hennes namn ska vara Sara. ");
INSERT INTO swef_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Jag ska välsigna henne och ge dig en son också med henne. Jag ska välsigna henne så att folkslag och kungar över folk ska komma från henne.” ");
INSERT INTO swef_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Då föll Abraham ner på sitt ansikte, men han log och sade för sig själv: ”Ska det födas barn åt en man som är hundra år? Och ska Sara föda barn, hon som är nittio år?” ");
INSERT INTO swef_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Och Abraham sade till Gud: ”Låt bara Ismael få leva inför dig!” ");
INSERT INTO swef_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Men Gud sade: ”Nej, din hustru Sara ska föda en son åt dig, och du ska ge honom namnet Isak. Jag ska upprätta mitt förbund med honom, som ett evigt förbund med hans avkomma efter honom. ");
INSERT INTO swef_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Men också när det gäller Ismael har jag hört din bön. Jag ska välsigna honom och göra honom fruktsam och föröka honom mycket. Han ska bli far till tolv hövdingar, och jag ska göra honom till ett stort folk. ");
INSERT INTO swef_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Men mitt förbund ska jag upprätta med Isak, honom som Sara ska föda åt dig vid denna tid nästa år.” ");
INSERT INTO swef_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","När Gud hade talat färdigt med Abraham steg han upp från honom. ");
INSERT INTO swef_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Samma dag tog Abraham sin son Ismael och alla som var födda i hans hus och alla som var köpta för pengar, alla av manligt kön bland hans husfolk, och skar bort deras förhud så som Gud hade sagt till honom. ");
INSERT INTO swef_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham var nittionio år när han blev omskuren, ");
INSERT INTO swef_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","och hans son Ismael var tretton år när han blev omskuren. ");
INSERT INTO swef_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","På samma dag blev Abraham och hans son Ismael omskurna. ");
INSERT INTO swef_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Och alla männen i hans hus, både de som var födda i huset och de som var köpta för pengar från främmande folk, blev omskurna tillsammans med honom. ");
INSERT INTO swef_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Herren uppenbarade sig för Abraham vid Mamres terebintlund, där han satt vid tältöppningen när dagen var som hetast. ");
INSERT INTO swef_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Han såg upp, och se, tre män stod framför honom. När han fick syn på dem, skyndade han ut från tältöppningen för att möta dem. Han bugade sig till jorden ");
INSERT INTO swef_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","och sade: ”Herre, om jag har funnit nåd för dina ögon så gå inte förbi din tjänare. ");
INSERT INTO swef_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Låt mig hämta lite vatten så att ni kan tvätta era fötter och vila er under trädet. ");
INSERT INTO swef_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Jag ska också hämta lite bröd så att ni kan styrka er innan ni går vidare, när ni nu har vägen förbi er tjänare.” De sade: ”Ja, gör som du sagt.” ");
INSERT INTO swef_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham skyndade sig in i tältet till Sara och sade: ”Skynda dig, ta tre sea-mått fint mjöl! Knåda det och baka brödkakor.” ");
INSERT INTO swef_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Själv sprang Abraham bort till boskapen och tog en späd och fin ungkalv och gav den åt sin tjänare, som skyndade sig att laga till den. ");
INSERT INTO swef_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sedan tog han gräddmjölk, sötmjölk och kalven han låtit laga till och satte fram det åt dem. Och han stod hos dem under trädet medan de åt. ");
INSERT INTO swef_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sedan frågade de honom: ”Var är din hustru Sara?” Han svarade: ”Där inne i tältet.” ");
INSERT INTO swef_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Då sade han: ”Jag kommer tillbaka till dig nästa år vid denna tid, och se, då ska din hustru Sara ha en son.” Detta hörde Sara där hon stod i tältöppningen bakom honom. ");
INSERT INTO swef_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Men Abraham och Sara var gamla och hade nått hög ålder, och Sara hade inte längre det som kvinnor brukar ha. ");
INSERT INTO swef_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara log inom sig och tänkte: ”Ska jag få känna åtrå när jag är utsliten och min herre är gammal?” ");
INSERT INTO swef_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Herren sade till Abraham: ”Varför log Sara och tänkte: Ska jag föda barn, jag som är så gammal? ");
INSERT INTO swef_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Skulle något vara omöjligt för Herren? Vid den bestämda tiden nästa år kommer jag tillbaka till dig, och då ska Sara ha en son.” ");
INSERT INTO swef_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Då nekade Sara och sade: ”Jag log inte”, för hon blev rädd. Men han sade: ”Jo, du log.” ");
INSERT INTO swef_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","När männen bröt upp därifrån såg de ner mot Sodom, och Abraham följde dem en bit på vägen. ");
INSERT INTO swef_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Då sade Herren: ”Kan jag dölja för Abraham vad jag tänker göra? ");
INSERT INTO swef_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham ska ju bli ett stort och mäktigt folk, och i honom ska jordens alla folk bli välsignade. ");
INSERT INTO swef_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jag har utvalt honom för att han ska befalla sina barn och efterkommande att hålla sig till Herrens väg och handla rätt och rättfärdigt, så att Herren kan uppfylla sina löften till Abraham.” ");
INSERT INTO swef_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sedan sade Herren: ”Ropet över Sodom och Gomorra är starkt och deras synd är mycket svår. ");
INSERT INTO swef_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Därför tänker jag gå ner och se om de har gjort så som i ropet som har nått mig. Om det inte är så, vill jag veta det.” ");
INSERT INTO swef_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Männen vände sig därifrån och gick mot Sodom, men Abraham stod kvar inför Herren. ");
INSERT INTO swef_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Och Abraham gick närmare och sade: ”Ska du förgöra den rättfärdige tillsammans med den ogudaktige? ");
INSERT INTO swef_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kanske finns det femtio rättfärdiga i staden. Ska du då utplåna den och inte skona orten för de femtio rättfärdigas skull som finns där? ");
INSERT INTO swef_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aldrig att du skulle göra så, att låta den rättfärdige dö med den ogudaktige. Då skulle den rättfärdige få det som den ogudaktige. Aldrig! Skulle inte han som är hela jordens domare göra det som är rätt?” ");
INSERT INTO swef_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Herren sade: ”Om jag finner femtio rättfärdiga inne i Sodom, ska jag skona hela orten för deras skull.” ");
INSERT INTO swef_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham tog åter till orda och sade: ”Jag har vågat tala till Herren trots att jag är stoft och aska. ");
INSERT INTO swef_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kanske fattas det fem i de femtio rättfärdiga. Ska du då på grund av dessa fem förgöra hela staden?” Han svarade: ”Om jag finner fyrtiofem där, ska jag inte förgöra den.” ");
INSERT INTO swef_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Men Abraham fortsatte att tala till honom: ”Kanske finns det fyrtio där.” Han svarade: ”För dessa fyrtios skull ska jag inte göra det.” ");
INSERT INTO swef_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Då sade han: ”Herre, bli inte vred om jag talar en gång till. Kanske finns det trettio där.” Han svarade: ”Om jag finner trettio där, ska jag inte göra det.” ");
INSERT INTO swef_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Men han sade: ”Jag har vågat tala till Herren. Kanske finns det tjugo där.” Han svarade: ”För dessa tjugos skull ska jag inte förgöra den.” ");
INSERT INTO swef_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Då sade han: ”Herre, bli inte vred om jag talar bara en sista gång: Kanske finns det tio där.” Han svarade: ”För dessa tios skull ska jag inte förgöra den.” ");
INSERT INTO swef_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","När Herren hade talat färdigt med Abraham gick han därifrån, och Abraham återvände hem. ");
INSERT INTO swef_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","På kvällen kom de två änglarna till Sodom, och Lot satt då i Sodoms port. När Lot fick se dem reste han sig för att möta dem, och han föll ner med ansiktet mot jorden ");
INSERT INTO swef_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","och sade: ”Mina herrar, kom med till er tjänares hus. Tvätta era fötter och stanna över natten. Sedan kan ni fortsätta er färd tidigt i morgon.” De svarade: ”Nej, vi stannar på torget över natten.” ");
INSERT INTO swef_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Men han bad dem så enträget att de vek av och kom in i hans hus. Han ordnade en festmåltid åt dem och bakade osyrat bröd, och de åt. ");
INSERT INTO swef_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Innan de hade lagt sig omringades huset av männen i staden, Sodoms män, både unga och gamla, allt folket utan undantag. ");
INSERT INTO swef_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","De ropade på Lot och sade till honom: ”Var är männen som kom till dig i natt? Skicka ut dem till oss så att vi får ligga med dem.” ");
INSERT INTO swef_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Då gick Lot ut till dem i porten, stängde dörren efter sig ");
INSERT INTO swef_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","och sade: ”Mina bröder, gör inte så illa! ");
INSERT INTO swef_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Jag har två döttrar som aldrig har legat med någon man. Låt mig skicka ut dem till er, så kan ni göra vad ni vill med dem. Gör bara inte något mot de här männen, eftersom de har kommit i skydd under mitt tak.” ");
INSERT INTO swef_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Men de svarade: ”Flytta på dig!” De sade vidare: ”Han har kommit hit som främling, och nu vill han bli vår domare! Nu ska vi göra mer ont mot dig än mot dem.” Och de trängde sig med våld mot Lot och stormade fram för att spränga dörren. ");
INSERT INTO swef_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Då räckte männen ut sina händer och drog in Lot till sig i huset och stängde dörren. ");
INSERT INTO swef_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Männen utanför huset slog de med blindhet, både små och stora, så att de förgäves försökte finna dörren. ");
INSERT INTO swef_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Sedan sade de till Lot: ”Har du några mer här? Någon svärson, söner, döttrar eller någon annan i staden som tillhör dig? För bort dem från den här platsen, ");
INSERT INTO swef_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","för vi ska förgöra den. Deras rop har blivit så starkt inför Herren att Herren har sänt oss hit för att förgöra den.” ");
INSERT INTO swef_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Då gick Lot ut och talade med sina svärsöner, de som skulle få hans döttrar, och sade: ”Bryt upp! Ta er ut från den här platsen, för Herren tänker förgöra staden.” Men hans svärsöner trodde att han skämtade. ");
INSERT INTO swef_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","När gryningen kom skyndade änglarna på Lot och sade: ”Bryt upp, ta med dig din hustru och dina båda döttrar som är här, så att du inte går under genom stadens synd.” ");
INSERT INTO swef_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","När Lot dröjde tog männen hans hand, hans hustrus hand och hans båda döttrars händer, för Herren ville skona honom. De förde ut honom, och först när de var utanför staden släppte de honom. ");
INSERT INTO swef_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","När de hade fört ut dem, sade en av dem: ”Fly för livet! Se dig inte tillbaka och stanna inte någonstans på slätten. Fly till bergen så att du inte går under.” ");
INSERT INTO swef_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Men Lot sade till dem: ”O nej, Herre. ");
INSERT INTO swef_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Din tjänare har ju funnit nåd för dina ögon, och du har visat din stora godhet mot mig genom att rädda mitt liv. Men jag kan inte fly upp till bergen, för då kan olyckan hinna ifatt mig så att jag dör. ");
INSERT INTO swef_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Se, staden där borta ligger nära. Det är lätt att fly dit och den är liten. Låt mig fly dit, så att jag får leva. Den är ju så liten.” ");
INSERT INTO swef_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Då svarade han honom: ”Jag ska göra som du vill också i det här. Jag ska inte omstörta staden du talar om. ");
INSERT INTO swef_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Men skynda dig att fly dit, för jag kan inte göra något förrän du är där.” Därför fick staden namnet Soar. ");
INSERT INTO swef_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Solen hade gått upp över jorden när Lot kom till Soar. ");
INSERT INTO swef_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Då lät Herren svavel och eld regna ner från himlen, från Herren, över Sodom och Gomorra. ");
INSERT INTO swef_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Han ödelade dessa städer, hela slätten, alla som bodde i städerna och det som växte på marken. ");
INSERT INTO swef_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Men Lots hustru som följde efter honom såg sig tillbaka, och hon blev en saltstod. ");
INSERT INTO swef_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Tidigt nästa morgon gick Abraham till den plats där han hade stått inför Herren ");
INSERT INTO swef_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","och såg ner över Sodom och Gomorra och hela slättlandet. Då såg han rök stiga upp från landet, som röken från en smältugn. ");
INSERT INTO swef_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","När Gud ödelade städerna på slätten tänkte han på Abraham och lät Lot komma undan förödelsen, när han omstörtade städerna där Lot hade bott. ");
INSERT INTO swef_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot drog ut från Soar upp till bergsbygden och bosatte sig där med sina båda döttrar, för han vågade inte bo kvar i Soar. Han bodde med sina båda döttrar i en grotta. ");
INSERT INTO swef_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Då sade den äldre till den yngre: ”Vår far är gammal och det finns ingen man i landet som kan gå in till oss som man gör överallt på jorden. ");
INSERT INTO swef_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, vi ser till att vår far dricker vin, och sedan ligger vi med honom så att vi får barn genom vår far.” ");
INSERT INTO swef_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Så gav de sin far vin att dricka den natten, och den äldre gick in och låg med honom. Han märkte inte när hon lade sig och inte heller när hon steg upp. ");
INSERT INTO swef_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nästa dag sade den äldre till den yngre: ”Jag låg med far i natt. Nu ser vi till att han dricker vin i natt också, och sedan går du in och ligger med honom så att vi får barn genom vår far.” ");
INSERT INTO swef_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Så gav de sin far vin att dricka också den natten, och den yngre låg med honom. Han märkte inte när hon lade sig och inte heller när hon steg upp. ");
INSERT INTO swef_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Och båda Lots döttrar blev havande genom sin far. ");
INSERT INTO swef_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Den äldre födde en son som hon gav namnet Moab. Han är stamfar till de nuvarande moabiterna. ");
INSERT INTO swef_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Den yngre födde också en son som hon gav namnet Ben-Ammi. Han är stamfar till de nuvarande ammoniterna. ");
INSERT INTO swef_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham bröt upp därifrån och flyttade till Negev. Där uppehöll han sig mellan Kadesh och Shur, och han bodde en tid i Gerar. ");
INSERT INTO swef_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Och Abraham sade om sin hustru Sara att hon var hans syster. Då sände Abimelek, kungen i Gerar, bud och hämtade Sara till sig. ");
INSERT INTO swef_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Men Gud kom till Abimelek i en dröm om natten och sade till honom: ”Du kommer att dö på grund av den kvinna du tagit, för hon är hustru till en annan man.” ");
INSERT INTO swef_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Men Abimelek hade inte rört henne och han svarade: ”Herre, ska du döda även rättfärdiga människor? ");
INSERT INTO swef_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Har han inte själv sagt till mig: Hon är min syster? Och hon sade själv: Han är min bror. Jag har gjort det med uppriktigt hjärta och rena händer.” ");
INSERT INTO swef_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Då sade Gud till honom i drömmen: ”Ja, jag vet att du har gjort det med uppriktigt hjärta, och det var också jag som hindrade dig från att synda mot mig. Därför lät jag dig inte röra henne. ");
INSERT INTO swef_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Men ge nu mannen hans hustru tillbaka, för han är en profet. Han ska be för dig så att du får leva. Om du inte ger tillbaka henne, ska du veta att du själv och alla som tillhör dig kommer att döden dö.” ");
INSERT INTO swef_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tidigt nästa morgon steg Abimelek upp och kallade till sig alla sina tjänare och berättade allt för dem. Männen blev mycket förskräckta. ");
INSERT INTO swef_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek kallade på Abraham och sade till honom: ”Vad har du gjort mot oss? Och vad har jag gjort för synd mot dig, eftersom du har dragit en så stor synd över mig och mitt rike? Du har gjort sådant mot mig som ingen borde göra.” ");
INSERT INTO swef_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Och Abimelek frågade Abraham: ”Vad tänkte du när du gjorde det?” ");
INSERT INTO swef_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham svarade: ”Jag tänkte att på det här stället fruktar man nog inte Gud. De kommer att döda mig för min hustrus skull. ");
INSERT INTO swef_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Och hon är verkligen min syster, dotter till min far men inte till min mor, och hon blev min hustru. ");
INSERT INTO swef_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Men när Gud sände mig på vandring bort från min fars hus sade jag till henne: Visa mig din kärlek så att du överallt vi kommer säger att jag är din bror.” ");
INSERT INTO swef_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Då tog Abimelek får och kor, tjänare och tjänarinnor och gav till Abraham. Han gav honom också tillbaka hans hustru Sara. ");
INSERT INTO swef_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Och Abimelek sade: ”Mitt land ligger öppet för dig. Du får bo var du vill.” ");
INSERT INTO swef_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Och till Sara sade han: ”Jag ger din bror tusen siklar silver. Det är en försoningsgåva för dig inför allt ditt folk, så att du får upprättelse inför alla.” ");
INSERT INTO swef_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Och Abraham bad till Gud, och Gud botade Abimelek och hans hustru och hans slavinnor så att de kunde föda barn igen. ");
INSERT INTO swef_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Herren hade nämligen gjort alla kvinnor i Abimeleks hus ofruktsamma för Abrahams hustru Saras skull. ");
INSERT INTO swef_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Herren såg till Sara så som han hade lovat, och Herren gjorde med Sara som han hade sagt. ");
INSERT INTO swef_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara blev havande och födde en son åt Abraham på hans ålderdom, just vid den tid som Gud hade sagt honom. ");
INSERT INTO swef_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham gav namnet Isak åt sin son som han fått, som Sara hade fött åt honom. ");
INSERT INTO swef_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Och Abraham omskar sin son Isak när han var åtta dagar gammal, som Gud hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham var hundra år när hans son Isak föddes. ");
INSERT INTO swef_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara sade: ”Gud har fått mig att le. Alla som får höra det här kommer att le med mig.” ");
INSERT INTO swef_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Och hon sade: ”Vem hade kunnat säga Abraham att Sara skulle amma barn? Men nu har jag fött en son på hans ålderdom!” ");
INSERT INTO swef_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Barnet växte och blev avvant, och på dagen då Isak avvandes ordnade Abraham en stor fest. ");
INSERT INTO swef_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Men när Sara såg att den egyptiska kvinnans son hånskrattade, den son som Hagar hade fött åt Abraham, ");
INSERT INTO swef_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","sade hon till Abraham: ”Driv ut den där slavinnan och hennes son! Den där slavinnans son ska inte dela arvet med min son, med Isak.” ");
INSERT INTO swef_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham tog mycket illa vid sig eftersom det gällde hans son. ");
INSERT INTO swef_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Men Gud sade till Abraham: ”Ta inte illa vid dig för pojkens och din slavinnas skull. Lyd Sara i allt hon säger till dig, för det är genom Isak som din avkomma ska räknas. ");
INSERT INTO swef_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Men även slavinnans son ska jag göra till ett folk, eftersom han är din avkomling.” ");
INSERT INTO swef_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tidigt nästa morgon tog Abraham bröd och en lädersäck med vatten och gav det till Hagar. Han lade det på hennes axlar och lät henne gå tillsammans med pojken. Hon gav sig i väg och irrade omkring i Beer-Shebas öken. ");
INSERT INTO swef_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","När vattnet i lädersäcken hade tagit slut, övergav hon pojken under en buske ");
INSERT INTO swef_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","och gick och satte sig en bit bort, på ett bågskotts avstånd. Hon tänkte: ”Jag orkar inte se på när pojken dör.” Där satt hon en bit bort och grät högljutt. ");
INSERT INTO swef_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Då hörde Gud pojkens röst, och Guds ängel ropade till Hagar från himlen och sade till henne: ”Hur är det, Hagar? Var inte rädd! Gud har hört pojkens rop där han ligger. ");
INSERT INTO swef_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Gå och res upp honom och ta hand om honom. Jag ska göra honom till ett stort folk.” ");
INSERT INTO swef_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Och Gud öppnade hennes ögon, så att hon fick syn på en brunn med vatten. Hon gick dit och fyllde sin lädersäck med vatten och gav pojken att dricka. ");
INSERT INTO swef_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Gud var med pojken, och han växte upp och bodde i öknen och blev bågskytt. ");
INSERT INTO swef_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Han bosatte sig i öknen Paran, och hans mor tog en hustru åt honom från Egypten. ");
INSERT INTO swef_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Vid den tiden kom Abimelek med sin befälhavare Pikol och sade till Abraham: ”Gud är med dig i allt du gör. ");
INSERT INTO swef_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lova mig nu med ed inför Gud att du inte sviker mig eller mina barn och efterkommande, utan visar samma godhet mot mig och det land där du bor som främling som jag har visat dig.” ");
INSERT INTO swef_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham sade: ”Ja, jag svär.” ");
INSERT INTO swef_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Men Abraham förebrådde Abimelek för att hans tjänare hade lagt beslag på en vattenbrunn. ");
INSERT INTO swef_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek svarade: ”Jag vet inte vem som har gjort det. Själv har du ingenting sagt, och jag har inte hört något om det förrän i dag.” ");
INSERT INTO swef_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Då tog Abraham får och kor och gav åt Abimelek, och de slöt förbund med varandra. ");
INSERT INTO swef_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Men Abraham ställde sju lamm i hjorden åt sidan. ");
INSERT INTO swef_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Då sade Abimelek till Abraham: ”Vad betyder de där sju lammen som du ställt åt sidan?” ");
INSERT INTO swef_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Han svarade: ”Dessa sju lamm ska du ta emot av mig som ett vittnesbörd om att det är jag som har grävt brunnen.” ");
INSERT INTO swef_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Sedan kallades platsen Beer-Sheba, eftersom de båda svor eden där. ");
INSERT INTO swef_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Och de slöt förbund vid Beer-Sheba, och därefter bröt Abimelek och hans befälhavare Pikol upp och återvände till filisteernas land. ");
INSERT INTO swef_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planterade en tamarisk vid Beer-Sheba och åkallade där Herrens namn, den evige Guden. ");
INSERT INTO swef_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Sedan bodde Abraham som främling i filisteernas land en lång tid. ");
INSERT INTO swef_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","En tid därefter satte Gud Abraham på prov. Han sade till honom: ”Abraham!” Han svarade: ”Ja, här är jag.” ");
INSERT INTO swef_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Då sade han: ”Ta din son Isak, din ende son som du älskar, och gå till Moria land och offra honom där som brännoffer på ett berg som jag ska visa dig.” ");
INSERT INTO swef_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tidigt nästa morgon sadlade Abraham sin åsna och tog med två av sina tjänare och sin son Isak. Sedan han huggit ved till brännoffer, gav han sig i väg mot platsen dit Gud hade sagt åt honom att gå. ");
INSERT INTO swef_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","På tredje dagen lyfte Abraham blicken och fick se platsen på avstånd. ");
INSERT INTO swef_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Han sade då till sina tjänare: ”Stanna här med åsnan. Jag och pojken går dit bort för att tillbe. Sedan kommer vi tillbaka till er.” ");
INSERT INTO swef_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham tog veden till brännoffret och lade den på sin son Isak. Själv tog han elden och kniven, och de gick båda tillsammans. ");
INSERT INTO swef_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak sade till sin far Abraham: ”Far!” Han svarade: ”Jag är här, min son.” Han sade: ”Vi har eld och ved, men var är lammet till brännoffret?” ");
INSERT INTO swef_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham svarade: ”Gud kommer att utse åt sig lammet till brännoffret, min son.” Så fortsatte de sin vandring tillsammans. ");
INSERT INTO swef_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","När de kom fram till den plats som Gud hade sagt till Abraham, byggde han ett altare där och gjorde i ordning veden. Sedan band han sin son Isak och lade honom på altaret ovanpå veden. ");
INSERT INTO swef_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Och Abraham räckte ut handen och tog kniven för att slakta sin son. ");
INSERT INTO swef_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Då ropade Herrens ängel till honom från himlen: ”Abraham! Abraham!” Han svarade: ”Jag är här.” ");
INSERT INTO swef_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Då sade han: ”Lyft inte din hand mot pojken och gör inte något mot honom. Nu vet jag att du fruktar Gud, när du inte ens har undanhållit mig din ende son.” ");
INSERT INTO swef_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham såg sig omkring och fick då syn på en bagge bakom sig som hade fastnat med hornen i ett snår. Abraham gick dit och tog baggen och offrade den som brännoffer i stället för sin son. ");
INSERT INTO swef_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Och Abraham kallade platsen Herren förser. I dag säger man: Berget där Herren förser. ");
INSERT INTO swef_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Herrens ängel ropade igen till Abraham från himlen: ");
INSERT INTO swef_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","”Jag svär vid mig själv, säger Herren: Eftersom du har gjort detta och inte undanhållit mig din ende son, ");
INSERT INTO swef_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ska jag välsigna dig rikligt och göra dina efterkommande talrika som stjärnorna på himlen och som sanden på havets strand, och din avkomma ska inta sina fienders portar. ");
INSERT INTO swef_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I din avkomma ska jordens alla folk bli välsignade, därför att du lyssnade till min röst.” ");
INSERT INTO swef_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sedan vände Abraham tillbaka till sina tjänare, och de bröt upp och gick tillsammans till Beer-Sheba. Och Abraham bodde i Beer-Sheba. ");
INSERT INTO swef_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sedan berättade man för Abraham och sade: Också Milka har fött barn åt din bror Nahor: ");
INSERT INTO swef_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, hans förstfödde, och Bus, hans bror, och Kemuel, Arams far, ");
INSERT INTO swef_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","samt Kesed, Haso, Pildash, Jidlaf och Betuel. ");
INSERT INTO swef_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel blev far till Rebecka. Dessa åtta födde Milka åt Abrahams bror Nahor. ");
INSERT INTO swef_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hans bihustru, som hette Reuma, födde Teba, Gaham, Tahash och Maaka. ");
INSERT INTO swef_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara blev hundratjugosju år. Så gammal blev Sara. ");
INSERT INTO swef_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Hon dog i Kirjat-Arba, det vill säga Hebron i Kanaans land. Och Abraham kom för att sörja Sara och gråta över henne. ");
INSERT INTO swef_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sedan reste sig Abraham upp från sin döda och talade med hetiterna. Han sade: ");
INSERT INTO swef_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","”Jag är en främling och gäst hos er. Ge mig en egen gravplats hos er, så att jag kan begrava min döda.” ");
INSERT INTO swef_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hetiterna svarade Abraham: ");
INSERT INTO swef_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","”Hör på oss, herre. Du är en Guds furste bland oss. Begrav din döda i den förnämsta av våra gravar. Ingen av oss ska vägra att ge dig sin grav, så att du kan begrava din döda där.” ");
INSERT INTO swef_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Då reste sig Abraham och bugade djupt för hetiterna, landets folk, ");
INSERT INTO swef_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","och sade till dem: ”Om ni verkligen vill låta mig begrava min döda, så lyssna på mig och lägg ett ord för mig hos Efron, Sohars son, ");
INSERT INTO swef_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","så att han ger mig grottan i Makpela som tillhör honom och som ligger vid utkanten av hans mark. Jag vill att han ger mig den mot full betalning som egen gravplats bland er.” ");
INSERT INTO swef_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Men Efron satt där bland hetiterna. Och hetiten Efron svarade Abraham inför alla hetiterna som hade kommit till stadsporten: ");
INSERT INTO swef_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","”Nej, min herre, lyssna på mig. Jag ger dig fältet. Grottan som finns där skänker jag dig också. Jag ger den till dig inför mitt folk. Begrav din döda.” ");
INSERT INTO swef_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham bugade sig djupt för landets folk ");
INSERT INTO swef_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","och sade till Efron inför folket: ”Jag ber dig, lyssna på mig. Jag betalar vad marken är värd. Ta emot det av mig och låt mig begrava min döda där.” ");
INSERT INTO swef_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron svarade Abraham: ");
INSERT INTO swef_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","”Min herre, lyssna på mig. En bit mark värd fyrahundra siklar silver, vad betyder det mellan mig och dig? Begrav du din döda.” ");
INSERT INTO swef_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham lyssnade på Efron och vägde upp åt honom summan som han nämnt inför hetiterna, fyrahundra siklar silver, gångbart i handel. ");
INSERT INTO swef_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Så överläts Efrons mark i Makpela vid Mamre åt Abraham, hela markstycket, både grottan som fanns där och alla träd runt omkring på området. ");
INSERT INTO swef_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Det skedde inför hetiternas ögon, inför alla dem som hade kommit till stadsporten. ");
INSERT INTO swef_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Därefter begravde Abraham sin hustru Sara i grottan vid fältet i Makpela mitt emot Mamre, det vill säga Hebron i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Marken och grottan som fanns där överläts så av hetiterna till Abraham som egen gravplats. ");
INSERT INTO swef_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham var nu gammal och hade nått hög ålder, och Herren hade välsignat honom i allt. ");
INSERT INTO swef_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Då sade Abraham till den äldste tjänaren i sitt hus, den som hade ansvar för allt som Abraham ägde: ”Lägg din hand under min höft. ");
INSERT INTO swef_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Lova mig med ed vid Herren, himlens Gud och jordens Gud, att du inte tar en hustru åt min son från döttrarna till kananeerna som jag bor ibland, ");
INSERT INTO swef_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","utan att du går till mitt land och min släkt och där tar en hustru åt min son Isak.” ");
INSERT INTO swef_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tjänaren sade till honom: ”Men om kvinnan inte vill följa med mig till det här landet, ska jag då föra din son tillbaka till det land som du har kommit ifrån?” ");
INSERT INTO swef_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham svarade honom: ”Se till att du inte för min son tillbaka dit. ");
INSERT INTO swef_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Herren, himlens Gud som har tagit mig från min fars hus och från det land där jag föddes, han som har talat till mig och gett mig sin ed och sagt: ’Åt dina efterkommande ska jag ge detta land’, han ska sända sin ängel framför dig, så att du kan hämta en hustru åt min son därifrån. ");
INSERT INTO swef_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Men om kvinnan inte vill följa med dig, är du fri från denna ed till mig. För bara inte min son tillbaka dit!” ");
INSERT INTO swef_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Då lade tjänaren sin hand under sin herre Abrahams höft och lovade honom detta med ed. ");
INSERT INTO swef_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tjänaren tog sedan tio av sin herres kameler och gav sig i väg med alla slags dyrbara gåvor från sin herre. Han styrde sin färd mot Nahors stad i Aram-Naharajim. ");
INSERT INTO swef_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Där lät han kamelerna lägga sig ner vid en vattenbrunn utanför staden. Det var nu kväll, den tid då kvinnorna brukade komma ut och hämta vatten. ");
INSERT INTO swef_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Och han bad: ”Herre, min herre Abrahams Gud, låt mig få framgång i dag och visa nåd mot min herre Abraham. ");
INSERT INTO swef_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Jag står här vid vattenkällan, och stadens döttrar kommer hit för att hämta vatten. ");
INSERT INTO swef_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Om jag ber en flicka: Räck mig din kruka så att jag får dricka, och hon svarar: Drick! Jag ger vatten åt dina kameler också, låt henne då vara den du har bestämt åt din tjänare Isak. På så sätt ska jag veta att du har visat godhet mot min herre.” ");
INSERT INTO swef_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Och det blev så att innan han hade slutat tala, se, då kom Rebecka ut med sin kruka på axeln. Hon var dotter till Betuel som var son till Milka, Abrahams bror Nahors hustru. ");
INSERT INTO swef_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Det var en mycket vacker flicka, en ung kvinna som inte haft någon man. Hon gick ner till källan och fyllde sin kruka och steg sedan upp igen. ");
INSERT INTO swef_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Då sprang tjänaren emot henne och sade: ”Låt mig få dricka lite vatten ur din kruka.” ");
INSERT INTO swef_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","”Drick, min herre”, svarade hon, tog snabbt ner krukan i handen och gav honom att dricka. ");
INSERT INTO swef_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","När hon hade gett honom att dricka sade hon: ”Jag ska ösa upp vatten åt dina kameler också, tills de alla har fått dricka.” ");
INSERT INTO swef_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hon skyndade sig att tömma sin kruka i vattenhon och sprang sedan tillbaka till brunnen för att ösa upp vatten. Hon öste så upp vatten åt alla hans kameler. ");
INSERT INTO swef_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mannen iakttog henne under tystnad, för han ville veta om Herren hade gjort hans resa framgångsrik eller inte. ");
INSERT INTO swef_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","När alla kamelerna hade druckit tog mannen fram en näsring av guld som vägde en halv sikel och två guldarmband som vägde tio siklar, ");
INSERT INTO swef_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","och han frågade: ”Vems dotter är du? Berätta. Finns det plats för oss i din fars hus över natten?” ");
INSERT INTO swef_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hon svarade honom: ”Jag är dotter till Betuel, Milkas son som hon födde åt Nahor.” ");
INSERT INTO swef_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Och hon fortsatte: ”Vi har gott om halm och foder, och även plats där du kan övernatta.” ");
INSERT INTO swef_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Då böjde mannen sig ner och tillbad Herren ");
INSERT INTO swef_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","och sade: ”Lovad är Herren, min herre Abrahams Gud, som inte har tagit sin nåd och trofasthet från min herre! Herren har lett mig på vägen hem till min herres släkt.” ");
INSERT INTO swef_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Och flickan sprang hem och berättade alltsammans. ");
INSERT INTO swef_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebecka hade en bror som hette Laban. Han sprang i väg till mannen vid källan. ");
INSERT INTO swef_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Han hade nämligen sett näsringen och armbanden som hans syster bar, och när han hörde sin syster berätta vad mannen sagt till henne gick han ut till mannen som stod hos kamelerna vid källan. ");
INSERT INTO swef_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Han sade: ”Kom in, du Herrens välsignade! Varför står du härute? Jag har gjort huset i ordning och det finns plats för kamelerna.” ");
INSERT INTO swef_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Så kom mannen till hennes hem, och man lastade av kamelerna och tog fram halm och foder åt dem och vatten till att tvätta hans och hans följeslagares fötter. ");
INSERT INTO swef_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Man satte fram mat åt honom, men han sade: ”Jag vill inte äta förrän jag har framfört mitt ärende.” Laban sade: ”Säg det!” ");
INSERT INTO swef_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Då sade han: ”Jag är Abrahams tjänare. ");
INSERT INTO swef_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Herren har välsignat min herre rikligt, och han har blivit en mäktig man. Han har gett honom får och kor, silver och guld, tjänare och tjänarinnor, kameler och åsnor. ");
INSERT INTO swef_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Min herres hustru Sara har fött min herre en son på sin ålderdom, och honom har han gett allt han äger. ");
INSERT INTO swef_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nu har min herre bundit mig med ed och sagt: Du får inte ta en hustru åt min son bland döttrarna till kananeerna i landet där jag bor, ");
INSERT INTO swef_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","utan du ska gå till min fars hus och min släkt och där hämta en hustru åt min son. ");
INSERT INTO swef_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Då sade jag till min herre: Men om kvinnan inte vill följa med mig? ");
INSERT INTO swef_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Han svarade: Herren, som jag har vandrat inför, ska sända sin ängel med dig. Han ska göra din resa framgångsrik, så att du kan hämta en hustru åt min son från min släkt, från min fars hus. ");
INSERT INTO swef_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Först när du kommer till min släkt blir du löst från eden. Även om de vägrar att ge henne åt dig är du fri från eden till mig. ");
INSERT INTO swef_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Så kom jag i dag till källan, och jag sade: Herre, min herre Abrahams Gud, om du vill, låt den resa jag gör bli framgångsrik! ");
INSERT INTO swef_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Jag står nu här vid vattenkällan. Om det kommer en ung kvinna för att hämta vatten och jag säger till henne: Låt mig få dricka lite vatten ur din kruka, ");
INSERT INTO swef_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","och hon svarar mig: Drick du, jag öser upp åt dina kameler också, låt det då vara den kvinna som Herren har utsett åt min herres son. ");
INSERT INTO swef_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Innan jag hade slutat att säga så för mig själv, kom Rebecka ut med sin kruka på axeln och gick ner till källan för att hämta vatten. Då sade jag till henne: Låt mig få dricka! ");
INSERT INTO swef_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hon lyfte snabbt ner sin kruka från axeln och sade: Drick, och jag ska ge dina kameler vatten också. Då drack jag, och hon gav kamelerna vatten också. ");
INSERT INTO swef_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Så jag frågade henne: Vems dotter är du? Hon svarade: Jag är dotter till Betuel, Nahors son, som föddes åt honom av Milka. Då satte jag ringen i hennes näsa och armbanden på hennes armar. ");
INSERT INTO swef_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sedan böjde jag mig ner och tillbad Herren och lovade Herren, min herre Abrahams Gud, som hade fört mig på rätt väg för att få en dotter från min herres släkt åt hans son. ");
INSERT INTO swef_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Om ni vill visa min herre kärlek och trofasthet så säg mig det. Om inte, så säg mig det, så att jag kan vända mig åt något annat håll, höger eller vänster.” ");
INSERT INTO swef_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Då sade Laban och Betuel: ”Detta är från Herren. Vi kan inte säga någonting till dig, varken ont eller gott. ");
INSERT INTO swef_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Se, där står Rebecka framför dig. Ta med henne och gå, så att hon kan bli hustru åt din herres son som Herren har sagt.” ");
INSERT INTO swef_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","När Abrahams tjänare hörde det, föll han ner på marken inför Herren. ");
INSERT INTO swef_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sedan tog tjänaren fram silversmycken, guldsmycken och kläder och gav till Rebecka. Han gav också hennes bror och mor dyrbara gåvor. ");
INSERT INTO swef_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Och han och hans följeslagare åt och drack och stannade sedan över natten. Men på morgonen när de hade stigit upp, sade han: ”Låt mig nu fara till min herre.” ");
INSERT INTO swef_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Men både Rebeckas bror och hennes mor sade: ”Låt flickan stanna hos oss några dagar, tio eller så. Sedan kan du fara.” ");
INSERT INTO swef_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Men han svarade dem: ”Håll mig inte kvar när Herren nu har gjort min resa framgångsrik. Låt mig gå. Jag vill resa hem till min herre.” ");
INSERT INTO swef_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Då sade de: ”Vi kallar hit flickan och frågar henne själv.” ");
INSERT INTO swef_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","De kallade till sig Rebecka och frågade henne: ”Vill du följa med den här mannen?” Hon svarade: ”Ja.” ");
INSERT INTO swef_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Då lät de sin syster Rebecka och hennes amma resa med Abrahams tjänare och hans män. ");
INSERT INTO swef_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Och de välsignade Rebecka och sade till henne: ”Av dig, vår syster, ska komma tusen gånger tiotusen. Din avkomma ska inta sina fienders portar!” ");
INSERT INTO swef_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Så bröt Rebecka upp med sina tjänsteflickor. De red på kamelerna och följde med mannen. Och tjänaren tog med sig Rebecka och reste sin väg. ");
INSERT INTO swef_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak hade just kommit tillbaka från Beer-Lahaj-Roi, för han bodde i Negev. ");
INSERT INTO swef_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Mot kvällen när han gick och funderade ute på fältet, såg han upp och fick se kameler komma. ");
INSERT INTO swef_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","När Rebecka lyfte blicken fick hon se Isak. Hon steg ner från kamelen ");
INSERT INTO swef_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","och frågade tjänaren: ”Vem är den mannen som kommer emot oss på fältet?” Tjänaren svarade ”Det är min herre.” Då tog hon sin slöja och dolde sig. ");
INSERT INTO swef_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tjänaren berättade för Isak om allt han hade gjort. ");
INSERT INTO swef_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Sedan förde Isak in henne i sin mor Saras tält, och han tog Rebecka till sig. Hon blev hans hustru och han älskade henne. Så blev Isak tröstad i sorgen efter sin mor. ");
INSERT INTO swef_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham tog sig åter en hustru, och hon hette Ketura. ");
INSERT INTO swef_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hon födde åt honom Simran, Jokshan, Medan, Midjan, Jishbak och Shua. ");
INSERT INTO swef_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan blev far till Saba och Dedan, och Dedans söner var ashureerna, letusheerna och leummeerna. ");
INSERT INTO swef_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midjans söner var Efa, Efer, Henok, Abida och Eldaa. Alla dessa var Keturas söner. ");
INSERT INTO swef_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Och Abraham gav allt han ägde till Isak. ");
INSERT INTO swef_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Men åt sönerna till sina bihustrur gav han gåvor, och medan han ännu levde sände han bort dem från sin son Isak, österut till Österlandet. ");
INSERT INTO swef_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahams ålder blev hundrasjuttiofem år. ");
INSERT INTO swef_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Sedan gav han upp andan och dog i en god ålder, gammal och mätt på livet, och samlades till sitt folk. ");
INSERT INTO swef_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Hans söner Isak och Ismael begravde honom i grottan i Makpela mitt emot Mamre, på marken som tillhört hetiten Efron, Sohars son. ");
INSERT INTO swef_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Där på den mark som Abraham hade köpt av hetiterna begravdes Abraham och hans hustru Sara. ");
INSERT INTO swef_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Efter Abrahams död välsignade Gud hans son Isak. Och Isak bosatte sig vid Beer-Lahaj-Roi. ");
INSERT INTO swef_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Detta är Ismaels, Abrahams sons, fortsatta historia. Han föddes åt Abraham av Hagar, Saras egyptiska slavinna. ");
INSERT INTO swef_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Och detta är namnen på Ismaels söner i den ordning de föddes: Nebajot, Ismaels förstfödde, vidare Kedar, Adbeel, Mibsam, ");
INSERT INTO swef_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma och Massa, ");
INSERT INTO swef_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad och Tema, Jetur, Nafish och Kedma. ");
INSERT INTO swef_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dessa var Ismaels söner och detta var sönernas namn i deras byar och tältläger, tolv furstar för deras stammar. ");
INSERT INTO swef_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaels ålder blev hundratrettiosju år. Därefter gav han upp andan och dog och samlades till sitt folk. ");
INSERT INTO swef_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hans ättlingar bodde i områdena från Havila ända till Shur öster om Egypten, där vägen går mot Assyrien. De slog sig ner mitt emot alla sina bröder. ");
INSERT INTO swef_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Detta är Isaks, Abrahams sons, fortsatta historia. Abraham blev far till Isak, ");
INSERT INTO swef_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","och Isak var fyrtio år gammal när han tog Rebecka till hustru, dotter till aramén Betuel från Paddan-Aram och syster till aramén Laban. ");
INSERT INTO swef_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak bad till Herren för sin hustru Rebecka, eftersom hon inte kunde få barn. Och Herren bönhörde honom så att hans hustru Rebecka blev havande. ");
INSERT INTO swef_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Men barnen bråkade mycket med varandra i hennes moderliv. Då sade hon: ”Om det blir så här, varför drabbar det mig?” Och hon gick för att fråga Herren. ");
INSERT INTO swef_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Herren svarade henne: ”Två folk finns i ditt moderliv, två folkstammar ska gå skilda vägar ur ditt sköte. Det ena folket ska bli starkare än det andra, och den äldre ska tjäna den yngre.” ");
INSERT INTO swef_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","När tiden var inne för henne att föda, se, då fanns det tvillingar i hennes moderliv. ");
INSERT INTO swef_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Den som kom fram först var rödhårig och hade som en hårmantel över hela kroppen. De gav honom namnet Esau. ");
INSERT INTO swef_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sedan kom hans bror fram, och hans hand höll om Esaus häl. Därför fick han namnet Jakob. Isak var sextio år när de föddes. ");
INSERT INTO swef_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Pojkarna växte upp, och Esau blev en skicklig jägare som höll till ute i markerna. Jakob däremot blev en stillsam man som höll till vid tälten. ");
INSERT INTO swef_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak älskade Esau eftersom han hade smak för vilt. Men Rebecka älskade Jakob. ");
INSERT INTO swef_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","En gång när Jakob höll på att koka soppa, kom Esau hem från marken, alldeles utmattad. ");
INSERT INTO swef_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Han sade till Jakob: ”Låt mig få äta av det röda, det röda där, för jag är helt utmattad.” Därav fick han namnet Edom. ");
INSERT INTO swef_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Men Jakob sade: ”Sälj först din förstfödslorätt till mig.” ");
INSERT INTO swef_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau svarade: ”Jag håller ju på att dö. Vad ska jag då med förstfödslorätten till?” ");
INSERT INTO swef_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sade: ”Ge mig din ed på det först.” Han gav honom sin ed och sålde sin förstfödslorätt till Jakob. ");
INSERT INTO swef_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Och Jakob gav honom bröd och linssoppa. Han åt och drack, reste sig och gick. Så lite värdesatte Esau sin förstfödslorätt. ");
INSERT INTO swef_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Det blev svält i landet igen, efter den första svältperioden som hade inträffat på Abrahams tid. Isak begav sig då till filisteernas kung Abimelek i Gerar. ");
INSERT INTO swef_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Där uppenbarade Herren sig för honom och sade: ”Dra inte ner till Egypten utan bo kvar i det land som jag säger dig. ");
INSERT INTO swef_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stanna som främling här i landet. Jag ska vara med dig och välsigna dig, för jag ska ge dig och dina efterkommande alla dessa landområden, och jag ska hålla den ed som jag gett din far Abraham. ");
INSERT INTO swef_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Jag ska göra dina efterkommande talrika som stjärnorna på himlen, och jag ska ge dina efterkommande alla dessa landområden. Och i din avkomma ska jordens alla folk bli välsignade, ");
INSERT INTO swef_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","eftersom Abraham lyssnade till min röst och tog vara på det jag förordnat: mina befallningar, föreskrifter och lagar.” ");
INSERT INTO swef_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Så stannade Isak i Gerar. ");
INSERT INTO swef_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","När männen på orten frågade om hans hustru, sade han: ”Hon är min syster”, för han var rädd för att säga: ”min hustru”. Han tänkte: ”Männen här på platsen kan slå ihjäl mig för Rebeckas skull, eftersom hon är så vacker.” ");
INSERT INTO swef_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Men när han hade varit där en längre tid, hände det att filisteernas kung Abimelek tittade ut genom fönstret och fick se Isak kela med sin hustru Rebecka. ");
INSERT INTO swef_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek kallade till sig Isak och sade: ”Hon är ju din hustru! Hur kunde du säga att hon är din syster?” Isak svarade honom: ”Jag tänkte att jag annars kunde bli dödad för hennes skull.” ");
INSERT INTO swef_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Då sade Abimelek: ”Vad har du gjort mot oss? Hur lätt kunde inte någon i vårt folk ha legat med din hustru? Och då hade du dragit skuld över oss.” ");
INSERT INTO swef_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Sedan befallde Abimelek hela folket: ”Den som rör den här mannen eller hans hustru ska straffas med döden.” ");
INSERT INTO swef_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak sådde där i landet och fick det året hundrafalt, för Herren välsignade honom. ");
INSERT INTO swef_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Han blev en mäktig man, och hans egendom växte mer och mer. Till slut var han mycket rik. ");
INSERT INTO swef_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Han ägde så mycket får och kor och hade så många tjänare att filisteerna blev avundsjuka på honom. ");
INSERT INTO swef_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Alla brunnar som hans fars tjänare hade grävt medan hans far Abraham levde, fyllde filisteerna igen med jord. ");
INSERT INTO swef_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek sade till Isak: ”Flytta bort från oss! Du har blivit alldeles för mäktig för oss.” ");
INSERT INTO swef_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Då flyttade Isak därifrån och slog sig ner i Gerars dalgång och bodde där. ");
INSERT INTO swef_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isak grävde på nytt fram de vattenbrunnar som hade grävts på hans far Abrahams tid men fyllts igen av filisteerna efter Abrahams död. Och han gav dem samma namn som hans far hade gett dem. ");
INSERT INTO swef_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","När Isaks tjänare grävde i dalen, fann de en källa med rinnande vatten. ");
INSERT INTO swef_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Herdarna från Gerar började då tvista med Isaks herdar och sade: ”Vattnet är vårt!” Därför gav han brunnen namnet Esek, eftersom de hade grälat med honom. ");
INSERT INTO swef_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Därefter grävde Isaks tjänare en annan brunn, men de började tvista om den också. Då gav han den namnet Sitna. ");
INSERT INTO swef_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Sedan bröt han upp därifrån och grävde ännu en brunn. Den tvistade de inte om. Därför gav han den namnet Rehobot och sade: ”Nu har Herren gett oss utrymme så att vi kan växa här i landet.” ");
INSERT INTO swef_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Därifrån drog Isak upp till Beer-Sheba. ");
INSERT INTO swef_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Den natten uppenbarade sig Herren för honom och sade: ”Jag är din far Abrahams Gud. Var inte rädd! Jag är med dig, och jag ska välsigna dig och göra din avkomma talrik för min tjänare Abrahams skull”. ");
INSERT INTO swef_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Då byggde han ett altare där och åkallade Herrens namn och slog upp sitt tält. Och Isaks tjänare grävde där en brunn. ");
INSERT INTO swef_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek kom till honom från Gerar tillsammans med sin vän Ahussat och sin befälhavare Pikol. ");
INSERT INTO swef_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Men Isak sade till dem: ”Varför kommer ni till mig, ni som hatade mig och drev bort mig från er?” ");
INSERT INTO swef_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","De svarade: ”Vi har tydligt sett att Herren är med dig. Därför tänkte vi att vi borde ge varandra en ed och sluta förbund: ");
INSERT INTO swef_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Du ska inte göra oss något ont, liksom vi inte har ofredat dig utan bara gjort dig gott och låtit dig gå i frid. Du är nu välsignad av Herren.” ");
INSERT INTO swef_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Då ordnade Isak en festmåltid för dem, och de åt och drack. ");
INSERT INTO swef_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","De steg upp tidigt nästa morgon och svor varandra eden. Sedan sände Isak i väg dem, och de gick ifrån honom i frid. ");
INSERT INTO swef_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Samma dag kom Isaks tjänare och berättade för honom om brunnen som de grävt och sade till honom: ”Vi har funnit vatten.” ");
INSERT INTO swef_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Och han kallade den Shiba. Därför heter staden Beer-Sheba än i dag. ");
INSERT INTO swef_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","När Esau var fyrtio år tog han till hustrur Judit, dotter till hetiten Beeri, och Basemat, dotter till hetiten Elon. ");
INSERT INTO swef_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Men de blev en hjärtesorg för Isak och Rebecka. ");
INSERT INTO swef_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","När Isak hade blivit gammal och hans ögon var så svaga att han inte kunde se, kallade han till sig sin äldste son Esau och sade till honom: ”Min son.” Han svarade honom: ”Jag är här.” ");
INSERT INTO swef_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Då sade han: ”Jag är gammal och vet inte när jag ska dö. ");
INSERT INTO swef_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ta därför dina jaktredskap, ditt koger och din båge, och gå ut i markerna och skjut något vilt åt mig. ");
INSERT INTO swef_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Laga sedan åt mig något gott som jag tycker om och bär in det till mig, så att jag får äta och sedan välsigna dig innan jag dör.” ");
INSERT INTO swef_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebecka hörde vad Isak sade till sin son Esau. När Esau gick ut i markerna för att skjuta något vilt att ta hem, ");
INSERT INTO swef_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","sade Rebecka till sin son Jakob: ”Lyssna! Jag hörde din far säga till din bror Esau: ");
INSERT INTO swef_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Skaffa något vilt och laga åt mig något gott som jag kan äta. Sedan ska jag välsigna dig inför Herren innan jag dör. ");
INSERT INTO swef_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hör nu på mig, min son, och gör som jag säger. ");
INSERT INTO swef_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gå till hjorden och hämta två fina killingar, så ska jag laga något gott av dem åt din far, något som han tycker om. ");
INSERT INTO swef_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Den ska du bära in till din far så att han får äta den och sedan välsigna dig innan han dör.” ");
INSERT INTO swef_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Men Jakob sade till sin mor Rebecka: ”Min bror Esau är ju hårig, och jag är slät. ");
INSERT INTO swef_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tänk om far rör vid mig? Då blir jag en bedragare i hans ögon och drar förbannelse över mig i stället för välsignelse.” ");
INSERT INTO swef_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Men hans mor sade till honom: ”Den förbannelsen får komma över mig, min son. Hör bara vad jag säger och gå och hämta killingarna åt mig.” ");
INSERT INTO swef_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Då gick han och hämtade dem och tog dem till sin mor, och hon lagade en god rätt som hans far tyckte om. ");
INSERT INTO swef_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sedan tog Rebecka fram sin äldste son Esaus högtidskläder, som hon hade inne hos sig, och satte dem på sin yngste son Jakob. ");
INSERT INTO swef_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Med skinnen från killingarna täckte hon över hans händer och den bara delen av hans hals. ");
INSERT INTO swef_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sedan gav hon sin son Jakob den goda rätten och brödet som hon hade gjort i ordning. ");
INSERT INTO swef_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Han gick in till sin far och sade: ”Far.” Han svarade: ”Vad vill du? Vem är du, min son?” ");
INSERT INTO swef_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob sade till sin far: ”Jag är Esau, din förstfödde. Jag har gjort som du sade till mig. Sätt dig upp och ät av mitt vilt, så att du kan välsigna mig.” ");
INSERT INTO swef_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Men Isak sade till sin son: ”Hur kunde du finna det så snart, min son?” Han svarade: ”Herren din Gud sände det i min väg.” ");
INSERT INTO swef_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Då sade Isak till Jakob: ”Kom hit, min son, och låt mig få röra vid dig och känna om du är min son Esau eller inte.” ");
INSERT INTO swef_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob gick då fram till sin far Isak, och han rörde vid honom och sade: ”Rösten är Jakobs, men händerna är Esaus.” ");
INSERT INTO swef_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Han kände inte igen honom, för händerna var håriga som hans bror Esaus händer. Han tänkte nu välsigna honom, ");
INSERT INTO swef_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","men så frågade han: ”Är du verkligen min son Esau?” Han svarade: ”Ja.” ");
INSERT INTO swef_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Då sade han: ”Bär hit maten, min son, så att jag kan äta av viltet och välsigna dig.” Jakob bar fram den till honom och han åt. Och han räckte honom vin och han drack. ");
INSERT INTO swef_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sedan sade hans far Isak till honom: ”Kom hit och kyss mig, min son.” ");
INSERT INTO swef_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","När han då gick fram och kysste honom, kände han lukten av hans kläder. Han välsignade honom och sade: ”Doften av min son är som doften av en mark som Herren har välsignat. ");
INSERT INTO swef_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gud ska ge dig av himlens dagg och av jordens fruktbarhet, säd och vin i riklig mängd. ");
INSERT INTO swef_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Folk ska tjäna dig och folkslag falla ner för dig. Var en herre över dina bröder, din mors söner ska falla ner för dig. Förbannad den som förbannar dig och välsignad den som välsignar dig!” ");
INSERT INTO swef_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","När Isak hade gett Jakob sin välsignelse och Jakob just hade gått ut från honom, kom hans bror Esau hem från jakten. ");
INSERT INTO swef_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Också han lagade en god rätt och bar in den till sin far och sade: ”Nu kan far sätta sig upp och äta av sin sons vilt och sedan välsigna honom.” ");
INSERT INTO swef_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Hans far Isak frågade honom: ”Vem är du?” Han svarade: ”Jag är Esau, din förstfödde.” ");
INSERT INTO swef_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Då blev Isak mycket förskräckt och sade: ”Vem var då jägaren som kom med sitt vilt till mig? Jag åt av allt innan du kom och jag välsignade honom. Välsignad kommer han också att bli.” ");
INSERT INTO swef_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","När Esau hörde vad hans far sade, ropade han högt och bittert: ”Far, välsigna mig också!” ");
INSERT INTO swef_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Men han svarade: ”Din bror kom med svek och tog din välsignelse.” ");
INSERT INTO swef_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Då sade Esau: ”Heter han inte Jakob! Och nu har han bedragit mig två gånger! Han tog min förstfödslorätt och nu tog han min välsignelse också.” Och han frågade: ”Har du ingen välsignelse kvar för mig?” ");
INSERT INTO swef_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak sade då till Esau: ”Se, jag har satt honom till herre över dig och gett honom alla hans bröder till tjänare, och försett honom med säd och vin. Vad ska jag då göra för dig, min son?” ");
INSERT INTO swef_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau sade till sin far: ”Var det den enda välsignelse du hade, far? Välsigna mig också, far!” Och han började storgråta. ");
INSERT INTO swef_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Då svarade hans far Isak honom: ”Se, fjärran från jordens fruktbarhet ska din boning vara, och utan dagg från himlen där ovan. ");
INSERT INTO swef_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Av ditt svärd ska du leva och din bror ska du tjäna. Men när du blir rastlös ska du slita hans ok från din nacke.” ");
INSERT INTO swef_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau fylldes av hat mot Jakob på grund av välsignelsen som hans far hade gett Jakob. Han sade till sig själv: ”Snart kommer tiden då vi ska sörja vår far. Då ska jag döda min bror Jakob.” ");
INSERT INTO swef_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","När det berättades för Rebecka vad hennes äldre son Esau hade sagt, skickade hon efter sin yngre son Jakob och sade till honom: ”Din bror Esau tänker hämnas på dig och döda dig. ");
INSERT INTO swef_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Så lyssna nu, min son, på mig! Fly till min bror Laban i Harran ");
INSERT INTO swef_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","och stanna hos honom en tid tills din brors vrede har lagt sig. ");
INSERT INTO swef_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","När din bror inte är arg på dig längre och han har glömt vad du gjort mot honom, då ska jag skicka bud och hämta dig därifrån. Varför skulle jag mista er båda på en och samma dag?” ");
INSERT INTO swef_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sedan sade Rebecka till Isak: ”Jag är trött på livet på grund av de hetitiska kvinnorna. Om Jakob tar sig en hustru bland landets kvinnor, en hetitiska som dessa, vad ska jag då leva för?” ");
INSERT INTO swef_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Då kallade Isak till sig Jakob och välsignade honom och sade till honom: ”Du ska inte ta någon av Kanaans döttrar till hustru. ");
INSERT INTO swef_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Bryt upp och bege dig till Paddan-Aram, till din morfar Betuels hus. Ta dig en hustru därifrån, någon av döttrarna till din morbror Laban. ");
INSERT INTO swef_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gud den Allsmäktige ska välsigna dig och göra dig fruktsam och föröka dig så att du blir många folk. ");
INSERT INTO swef_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Han ska ge Abrahams välsignelse åt dig och dina efterkommande, så att du får inta det land som Gud gav åt Abraham, det land där du nu bor som främling.” ");
INSERT INTO swef_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Så sände Isak i väg Jakob, och han begav sig till Paddan-Aram, till aramén Laban, som var son till Betuel och bror till Rebecka, Jakobs och Esaus mor. ");
INSERT INTO swef_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau såg att Isak hade välsignat Jakob och sänt honom till Paddan-Aram för att hämta en hustru därifrån. Han hade välsignat honom och befallt honom: ”Du ska inte ta en hustru bland Kanaans döttrar.” ");
INSERT INTO swef_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Och Jakob hade lytt sin far och mor och begett sig till Paddan-Aram. ");
INSERT INTO swef_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Då förstod Esau att hans far Isak inte tyckte om kananeiskorna. ");
INSERT INTO swef_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Därför gick han till Ismael och tog Mahalat till hustru, utöver de hustrur han redan hade. Hon var dotter till Ismael, Abrahams son, och syster till Nebajot. ");
INSERT INTO swef_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob lämnade Beer-Sheba och begav sig mot Harran. ");
INSERT INTO swef_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Han kom till en plats där han måste stanna över natten, eftersom solen hade gått ner. Och han tog en av stenarna på platsen för att ha under huvudet och lade sig att sova. ");
INSERT INTO swef_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Då hade han en dröm. Han såg en stege rest på jorden. Den nådde ända upp till himlen, och Guds änglar steg upp och ner på den. ");
INSERT INTO swef_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Och se, Herren stod ovanför den och sade: ”Jag är Herren, din far Abrahams Gud och Isaks Gud. Det land där du ligger ska jag ge åt dig och dina efterkommande. ");
INSERT INTO swef_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Din avkomma ska bli som stoftet på jorden och du ska utbreda dig åt väster och öster, norr och söder. Genom dig och din avkomma ska jordens alla släkten bli välsignade. ");
INSERT INTO swef_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Och se, jag är med dig och ska bevara dig vart du än går, och jag ska föra dig tillbaka till detta land. Jag ska inte överge dig förrän jag har gjort vad jag lovat dig.” ");
INSERT INTO swef_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","När Jakob vaknade upp ur sömnen, sade han: ”Herren är verkligen på denna plats och jag visste det inte.” ");
INSERT INTO swef_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Han greps av fruktan och sade: ”Hur helig är inte denna plats! Det måste vara Guds boning, här är himlens port.” ");
INSERT INTO swef_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tidigt på morgonen steg Jakob upp, och han tog stenen som han hade vilat sig mot och reste den till en stod och hällde olja över den. ");
INSERT INTO swef_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Och han kallade platsen Betel. Tidigare hette denna stad Luz. ");
INSERT INTO swef_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakob gav ett löfte och sade: ”Om Gud är med mig och bevarar mig på denna resa som jag gör och ger mig bröd att äta och kläder att ta på mig, ");
INSERT INTO swef_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","och jag kommer tillbaka till min fars hus i frid, då ska Herren vara min Gud. ");
INSERT INTO swef_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Och stenen som jag har rest till en stod ska bli ett Guds hus, och av allt som du ger mig ska jag ge dig tionde.” ");
INSERT INTO swef_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Sedan fortsatte Jakob sin färd till Österlandet. ");
INSERT INTO swef_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Där fick han se en brunn på fältet, och vid den låg tre fårhjordar. Ur den brunnen brukade man nämligen ge hjordarna vatten. Stenen som låg över brunnens öppning var stor. ");
INSERT INTO swef_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Därför brukade man först samla alla hjordarna där och sedan rulla bort stenen från öppningen till brunnen och ge fåren vatten. Därefter lade man tillbaka stenen på sin plats över brunnens öppning. ");
INSERT INTO swef_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob frågade männen: ”Mina bröder, varifrån är ni?” De svarade: ”Vi är från Harran.” ");
INSERT INTO swef_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Då sade han till dem: ”Känner ni Laban, Nahors son?” ”Honom känner vi”, svarade de. ");
INSERT INTO swef_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Han frågade dem vidare: ”Är det väl med honom?” De svarade: ”Ja, det är väl. Och där kommer hans dotter Rakel med fåren.” ");
INSERT INTO swef_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jakob sade: ”Det är ju fortfarande full dag, det är inte tid än att samla in boskapen. Ge fåren vatten och för dem ut på bete igen.” ");
INSERT INTO swef_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Men de svarade: ”Vi kan inte göra det förrän alla hjordarna har samlats och de har rullat bort stenen från brunnens öppning. Då ger vi fåren vatten.” ");
INSERT INTO swef_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Medan han talade med dem kom Rakel dit med sin fars får, för hon brukade vakta dem. ");
INSERT INTO swef_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","När Jakob fick se sin morbror Labans dotter Rakel komma med Labans får, gick han fram och rullade bort stenen från öppningen till brunnen och gav vatten åt sin morbror Labans får. ");
INSERT INTO swef_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Och Jakob kysste Rakel och brast i gråt. ");
INSERT INTO swef_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Han berättade för Rakel att han var hennes fars släkting och att han var Rebeckas son. Då sprang hon i väg och berättade det för sin far. ");
INSERT INTO swef_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","När Laban fick höra om sin systerson Jakob skyndade han sig emot honom, tog honom i famn och kysste honom och förde honom in i sitt hus. Jakob berättade för Laban allt som hade hänt honom. ");
INSERT INTO swef_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Och Laban sade till honom: ”Du är verkligen av samma kött och blod som jag!” Så stannade han hos honom en månad. ");
INSERT INTO swef_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban sade till Jakob: ”Du är ju min släkting. Ska du arbeta åt mig för ingenting? Säg mig vad du vill ha i lön.” ");
INSERT INTO swef_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban hade två döttrar. Den äldre hette Lea och den yngre Rakel. ");
INSERT INTO swef_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leas ögon var matta, men Rakel var välväxt och vacker att se på. ");
INSERT INTO swef_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Och Jakob älskade Rakel. Därför sade han: ”Jag kan arbeta för dig i sju år för Rakel, din yngre dotter.” ");
INSERT INTO swef_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban svarade: ”Det är bättre att jag ger henne till dig än till någon annan. Stanna kvar hos mig.” ");
INSERT INTO swef_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Så arbetade Jakob i sju år för Rakel, men för honom var det bara som några dagar eftersom han älskade henne. ");
INSERT INTO swef_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","När tiden hade gått sade Jakob till Laban: ”Ge mig min hustru, för nu är tiden inne. Låt mig gå in till henne.” ");
INSERT INTO swef_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Då samlade Laban allt folket på orten och ordnade en fest. ");
INSERT INTO swef_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Men när kvällen kom tog han sin dotter Lea och förde henne till honom, och han gick in till henne. ");
INSERT INTO swef_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Och Laban gav sin slavinna Silpa till tjänsteflicka åt sin dotter Lea. ");
INSERT INTO swef_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","På morgonen fick Jakob se att det var Lea. Då sade han till Laban: ”Vad har du gjort mot mig? Var det inte för Rakel jag arbetade hos dig? Varför har du bedragit mig?” ");
INSERT INTO swef_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban svarade: ”Här på vår ort brukar man inte ge bort den yngre före den äldre. ");
INSERT INTO swef_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Fullfölj nu Leas bröllopsvecka. Sedan ska vi ge dig den andra också mot att du arbetar åt mig i sju år till.” ");
INSERT INTO swef_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob gick med på det och fullföljde hennes bröllopsvecka. Sedan gav han honom sin dotter Rakel till hustru. ");
INSERT INTO swef_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Och Laban gav sin slavinna Bilha till tjänsteflicka åt sin dotter Rakel. ");
INSERT INTO swef_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Så gick Jakob in till Rakel också, och han älskade Rakel mer än Lea. Sedan arbetade han hos honom i sju år till. ");
INSERT INTO swef_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Men när Herren såg att Lea inte var älskad, gjorde han henne fruktsam medan Rakel var ofruktsam. ");
INSERT INTO swef_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea blev havande och födde en son som hon gav namnet Ruben, för hon sade: ”Herren har sett mitt lidande. Nu kommer min man att älska mig.” ");
INSERT INTO swef_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Och hon blev havande igen och födde en son. Då sade hon: ”Herren har hört att jag inte är älskad. Därför har han gett mig den också.” Och hon gav honom namnet Simeon. ");
INSERT INTO swef_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Sedan blev hon havande igen och födde en son. Då sade hon: ”Nu ska äntligen min man hålla sig till mig. Jag har ju fött honom tre söner.” Därför fick han heta Levi. ");
INSERT INTO swef_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Och hon blev havande igen och födde en son. Då sade hon: ”Nu vill jag tacka Herren.” Därför gav hon honom namnet Juda. Sedan slutade hon föda. ");
INSERT INTO swef_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","När Rakel såg att hon inte födde några barn åt Jakob, blev hon avundsjuk på sin syster och sade till Jakob: ”Skaffa mig barn, annars dör jag.” ");
INSERT INTO swef_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Då blev Jakob arg på Rakel och svarade: ”Kan jag ersätta Gud? Det är han som har hindrat dig att få barn.” ");
INSERT INTO swef_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Hon sade: ”Här är min slavinna Bilha. Gå in till henne, så att hon får föda barn åt mig och jag får avkomma genom henne.” ");
INSERT INTO swef_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Så gav hon honom sin slavinna Bilha till hustru, och Jakob gick in till henne. ");
INSERT INTO swef_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha blev havande och födde en son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Då sade Rakel: ”Gud har skaffat mig rätt. Han har hört min röst och gett mig en son.” Därför gav hon honom namnet Dan. ");
INSERT INTO swef_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Och Bilha, Rakels slavinna, blev havande igen och födde en andra son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Då sade Rakel: ”Guds kamper har jag kämpat med min syster, och jag har vunnit.” Och hon gav honom namnet Naftali. ");
INSERT INTO swef_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","När Lea såg att hon hade slutat föda barn, tog hon sin slavinna Silpa och gav henne till hustru åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Och Silpa, Leas slavinna, födde en son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Då sade Lea: ”Vilken lycka!” Och hon gav honom namnet Gad. ");
INSERT INTO swef_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leas slavinna Silpa födde en andra son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Då sade Lea: ”Jag är lycklig. Ja, unga kvinnor ska prisa mig lycklig.” Och hon gav honom namnet Asher. ");
INSERT INTO swef_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","En gång under veteskörden gick Ruben ut på marken och fann kärleksäpplen som han tog med till sin mor Lea. Då sade Rakel till Lea: ”Ge mig av din sons kärleksäpplen.” ");
INSERT INTO swef_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Men hon svarade henne: ”Är det inte nog att du har tagit min man? Ska du ta min sons kärleksäpplen också?” Rakel sade: ”Han får ligga med dig i natt om jag får din sons kärleksäpplen.” ");
INSERT INTO swef_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","När Jakob kom hem från marken på kvällen, gick Lea och mötte honom och sade: ”Du ska komma in till mig, för jag har gett min sons kärleksäpplen som lön för dig.” Så låg han med henne den natten. ");
INSERT INTO swef_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gud hörde Lea, och hon blev havande och födde en femte son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Då sade Lea: ”Gud har gett mig lön för att jag gav min slavinna åt min man.” Och hon gav honom namnet Isaskar. ");
INSERT INTO swef_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea blev havande igen och födde en sjätte son åt Jakob. ");
INSERT INTO swef_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Då sade hon: ”Gud har gett mig en god gåva. Nu ska min man bo hos mig, eftersom jag har fött sex söner åt honom.” Och hon gav honom namnet Sebulon. ");
INSERT INTO swef_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Därefter födde hon en dotter och gav henne namnet Dina. ");
INSERT INTO swef_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Men Gud tänkte på Rakel. Gud hörde henne och gjorde henne fruktsam. ");
INSERT INTO swef_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Och hon blev havande och födde en son. Då sade hon: ”Gud har tagit bort min skam.” ");
INSERT INTO swef_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Och hon gav honom namnet Josef och sade: ”Herren ska ge mig en son till.” ");
INSERT INTO swef_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","När Rakel hade fött Josef, sade Jakob till Laban: ”Låt mig resa. Jag vill bege mig hem till min bygd och till mitt land. ");
INSERT INTO swef_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ge mig mina hustrur och mina barn som jag har arbetat hos dig för, så ger jag mig av. Du vet ju själv hur jag har arbetat för dig.” ");
INSERT INTO swef_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban svarade honom: ”Låt mig finna nåd för dina ögon. Genom spåtecken förstår jag att Herren har välsignat mig för din skull.” ");
INSERT INTO swef_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Han tillade: ”Bestäm vad du vill ha i lön av mig, så ska jag ge dig det.” ");
INSERT INTO swef_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakob sade till honom: ”Du vet själv hur jag har arbetat för dig och vad det har blivit av din boskap hos mig. ");
INSERT INTO swef_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Det lilla du hade innan jag kom har förökat sig och blivit mycket, för Herren har välsignat dig var jag än gått fram. Men när ska jag få göra något för mitt eget hus?” ");
INSERT INTO swef_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Han svarade: ”Vad ska jag ge dig?” Jakob sade: ”Du ska inte ge mig något alls. Om du gör som jag säger ska jag fortsätta som herde för din hjord och vakta den. ");
INSERT INTO swef_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jag vill gå igenom hela din hjord i dag och skilja ut alla spräckliga och brokiga djur – alla mörka djur bland lammen och de brokiga och spräckliga bland getterna. Det ska vara min lön. ");
INSERT INTO swef_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","När du sedan kommer för att se med egna ögon vad som blivit min lön, då ska min rättfärdighet vara mitt vittne. Alla getter hos mig som inte är spräckliga eller brokiga och alla lamm som inte är mörka ska räknas som stulna.” ");
INSERT INTO swef_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","”Det är bra”, sade Laban. ”Det får bli som du har sagt.” ");
INSERT INTO swef_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Samma dag skilde Laban ut de strimmiga och brokiga bockarna och alla spräckliga och brokiga hongetter, alla som det fanns något vitt på, och alla lamm som var mörka. Dessa lämnade han i sina söners vård. ");
INSERT INTO swef_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Han satte ett avstånd på tre dagsresor mellan sig och Jakob. Och Jakob fick sedan vakta Labans övriga hjord. ");
INSERT INTO swef_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Men Jakob tog färska käppar av poppel, mandelträd och lönn och gjorde vita ränder på dem genom att skala av barken så att det vita på käpparna syntes. ");
INSERT INTO swef_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sedan lade han käpparna som han skalat i rännorna eller vattenhoarna, så att djuren hade dem framför sig när hjordarna kom för att dricka. De brukade para sig när de kom för att dricka. ");
INSERT INTO swef_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","När djuren parade sig vid käpparna blev djurens avkomma strimmig, spräcklig och brokig. ");
INSERT INTO swef_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Sedan förde Jakob lammen åt sidan och ordnade de andra djuren så att de vände huvudena mot det strimmiga och allt det mörka i Labans hjord. Så skaffade han sig egna hjordar som han inte blandade med Labans hjord. ");
INSERT INTO swef_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Så ofta de kraftiga djuren skulle para sig, lade Jakob käpparna framför djurens ögon i rännorna så att de parade sig vid käpparna. ");
INSERT INTO swef_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Men när det var svaga djur, lade han inte dit dem. På det sättet fick Laban de svaga djuren och Jakob de kraftiga. ");
INSERT INTO swef_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Och Jakob blev mycket rik. Han fick mycket småboskap och dessutom slavinnor och slavar, kameler och åsnor. ");
INSERT INTO swef_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakob fick höra hur Labans söner sade: ”Jakob har tagit allt vår far ägde. Han har skaffat sig all den rikedomen av det som tillhör vår far.” ");
INSERT INTO swef_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakob märkte också att Laban inte såg på honom med samma ögon som förut. ");
INSERT INTO swef_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Då sade Herren till Jakob: ”Vänd tillbaka till dina fäders land och till din släkt. Jag är med dig.” ");
INSERT INTO swef_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Och Jakob skickade efter Rakel och Lea och bad dem komma ut på marken till hans hjord, ");
INSERT INTO swef_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","och han sade till dem: ”Jag märker att er far inte ser på mig med samma ögon som förut, men min fars Gud har varit med mig. ");
INSERT INTO swef_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ni vet själva att jag har tjänat er far med all min kraft. ");
INSERT INTO swef_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ändå har er far lurat mig och ändrat min lön tio gånger, men Gud har inte tillåtit honom att göra mig något ont. ");
INSERT INTO swef_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","När han sade: De spräckliga ska vara din lön, då fick hela hjorden spräcklig avkomma. Och när han sade: De strimmiga ska vara din lön, då fick hela hjorden strimmig avkomma. ");
INSERT INTO swef_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Så har Gud tagit er fars boskap och gett den åt mig. ");
INSERT INTO swef_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","När parningstiden för småboskapen kom hade jag en dröm. Jag lyfte min blick och fick se att hannarna, som betäckte småboskapen, var strimmiga, spräckliga och fläckiga. ");
INSERT INTO swef_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Och Guds ängel sade till mig i drömmen: Jakob! Jag svarade: Jag är här. ");
INSERT INTO swef_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Då sade han: Lyft blicken och se hur alla hannar som betäcker småboskapen är strimmiga, spräckliga och fläckiga. Jag har sett allt som Laban gör mot dig. ");
INSERT INTO swef_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Jag är Betels Gud. Det var där du smorde en minnessten och gav mig ett löfte. Bryt nu upp och dra ut ur detta land och vänd tillbaka till ditt fosterland.” ");
INSERT INTO swef_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Då sade Rakel och Lea: ”Har vi kvar någon lott eller arvedel i vår fars egendom? ");
INSERT INTO swef_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Är vi inte som främlingar för honom? Han har ju sålt oss och sedan gjort slut på det han fick i betalning för oss. ");
INSERT INTO swef_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hela den rikedom som Gud har tagit från vår far tillhör oss och våra barn. Gör därför allt vad Gud har sagt till dig.” ");
INSERT INTO swef_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jakob bröt då upp och satte sina barn och hustrur på kamelerna ");
INSERT INTO swef_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","och tog med sig all sin boskap och all egendom som han hade samlat, boskapen han hade förvärvat och skaffat sig i Paddan-Aram, och begav sig till sin far Isak i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Men Laban hade gått för att klippa sina får. Då stal Rakel sin fars husgudar. ");
INSERT INTO swef_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Och Jakob smög sig i väg från aramén Laban utan att låta honom märka att han tänkte fly. ");
INSERT INTO swef_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Han bröt upp och flydde med allt han hade och gick över floden och ställde sin färd mot Gileads bergsbygd. ");
INSERT INTO swef_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","På tredje dagen fick Laban veta att Jakob hade flytt. ");
INSERT INTO swef_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Då tog han med sig sina bröder och satte efter honom, och efter sju dagar hann han upp honom i Gileads bergsbygd. ");
INSERT INTO swef_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Men Gud kom till aramén Laban i en dröm om natten och sade till honom: ”Akta dig för att säga något mot Jakob, gott eller ont.” ");
INSERT INTO swef_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","När Laban hann upp Jakob, hade denne slagit läger på berget. Också Laban och hans män slog läger på Gileads berg. ");
INSERT INTO swef_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Då sade Laban till Jakob: ”Vad har du gjort? Du smög dig i väg från mig och förde bort mina döttrar likt fångar tagna med svärd. ");
INSERT INTO swef_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Varför flydde du i hemlighet och rymde från mig? När du inte lät mig veta något kunde jag inte sända i väg dig med jubel och sång, med tamburin och harpa. ");
INSERT INTO swef_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Du unnade mig inte ens att få kyssa mina barnbarn och mina döttrar. Du har betett dig som en dåre. ");
INSERT INTO swef_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Jag har makt att göra er illa, men er fars Gud sade till mig i natt: Akta dig för att säga något mot Jakob, gott eller ont. ");
INSERT INTO swef_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nu gav du dig i väg för att du längtade hem så mycket. Men varför stal du mina gudar?” ");
INSERT INTO swef_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob svarade Laban: ”Jag var rädd för dig, för jag tänkte att du skulle ta dina döttrar från mig med våld. ");
INSERT INTO swef_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Men den som du hittar dina gudar hos ska inte få leva. Här inför våra släktingar får du se efter om jag har något hos mig som är ditt, och i så fall ta det.” Jakob visste inte att Rakel hade stulit dem. ");
INSERT INTO swef_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban gick då in i Jakobs tält, och sedan in i Leas tält och de båda slavinnornas tält, men han fann inget. När han hade kommit ut ur Leas tält gick han in i Rakels tält. ");
INSERT INTO swef_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Men Rakel hade tagit husgudarna och lagt dem i kamelsadeln och satt sig på dem. Laban sökte igenom hela tältet utan att finna dem. ");
INSERT INTO swef_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Hon sade till sin far: ”Bli inte arg på mig, herre, för att jag inte kan resa mig för dig. Jag har det som kvinnor brukar ha.” Så sökte han efter husgudarna men kunde inte finna dem. ");
INSERT INTO swef_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakob blev arg och kom i gräl med Laban och sade till honom: ”Vad är mitt brott, vad är min synd, eftersom du förföljer mig så våldsamt? ");
INSERT INTO swef_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nu har du letat igenom allt jag äger. Vad har du funnit som tillhör dig? Lägg fram det inför både mina och dina släktingar här så att de får döma mellan oss båda. ");
INSERT INTO swef_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I tjugo år har jag varit hos dig. Dina tackor och getter har inte fått missfall och jag har inte ätit av baggarna i din hjord. ");
INSERT INTO swef_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jag kom aldrig med något ihjälrivet djur till dig, jag var tvungen att ersätta det själv. Du krävde ersättning av mig för det stulna, antingen det stulits på dagen eller på natten. ");
INSERT INTO swef_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Så hade jag det. Om dagen plågades jag av hetta och om natten av köld, och sömnen flydde ifrån mig. ");
INSERT INTO swef_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I tjugo år har jag varit hos dig. Jag har tjänat dig i fjorton år för dina båda döttrar och i sex år för din boskap, men du har ändrat min lön tio gånger. ");
INSERT INTO swef_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Hade inte min fars Gud varit med mig – Abrahams Gud som även Isak vördar – så hade du säkert låtit mig gå med tomma händer. Men Gud såg mitt lidande och min möda, och han fällde domen i natt.” ");
INSERT INTO swef_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban svarade Jakob: ”Döttrarna är mina döttrar, barnen är mina barn och hjordarna är mina hjordar. Allt du ser är mitt. Vad skulle jag kunna göra mot mina döttrar eller mot barnen som de fött? ");
INSERT INTO swef_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kom nu, låt oss sluta förbund med varandra. Det ska vara vittne mellan mig och dig.” ");
INSERT INTO swef_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Då tog Jakob en sten och reste den till en stod. ");
INSERT INTO swef_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Sedan sade han till sitt folk: ”Samla ihop sten.” Då tog de stenar och gjorde ett röse och höll en måltid där på röset. ");
INSERT INTO swef_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban kallade det Jegar-Sahaduta, men Jakob kallade det Galed. ");
INSERT INTO swef_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Och Laban sade: ”Detta röse ska i dag vara vittne mellan mig och dig.” Så fick det namnet Galed. ");
INSERT INTO swef_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Men det kallades också Mispa, för han sade: ”Herren ska hålla vakt mellan mig och dig när vi inte längre ser varandra. ");
INSERT INTO swef_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Om du behandlar mina döttrar illa eller tar andra hustrur vid sidan av mina döttrar, ska du komma ihåg att Gud är vittne mellan mig och dig, även om ingen människa är närvarande.” ");
INSERT INTO swef_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban sade vidare till Jakob: ”Se detta röse och se denna stod som jag rest mellan mig och dig. ");
INSERT INTO swef_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Röset här ska vara ett vittne, och stoden ska vara ett vittne att jag inte ska gå förbi röset mot dig med onda avsikter, och att inte heller du ska gå mot mig förbi röset och stoden. ");
INSERT INTO swef_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahams och Nahors Gud ska vara domare mellan oss, han som var deras fars Gud.” Och Jakob svor eden vid honom som hans far Isak vördade. ");
INSERT INTO swef_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sedan offrade Jakob slaktoffer på berget och bjöd in sina släktingar till en måltid. De åt och stannade på berget över natten. ");
INSERT INTO swef_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","På morgonen steg Laban upp tidigt, och när han hade kysst sina barnbarn och sina döttrar och välsignat dem, gav han sig i väg och återvände hem. ");
INSERT INTO swef_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Och Jakob fortsatte sin färd. Då mötte Guds änglar honom. ");
INSERT INTO swef_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","När han såg dem sade han: ”Här är Guds skara.” Och han kallade platsen Mahanajim. ");
INSERT INTO swef_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakob skickade budbärare framför sig till sin bror Esau i Seirs land på Edoms mark ");
INSERT INTO swef_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","och befallde dem: ”Så här ska ni säga till min herre Esau: Din tjänare Jakob hälsar: Jag har bott hos Laban och dröjt kvar där ända tills nu. ");
INSERT INTO swef_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Jag har oxar, åsnor, får, tjänare och tjänarinnor, och nu sänder jag bud för att låta min herre veta det, så att jag kan finna nåd för dina ögon.” ");
INSERT INTO swef_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","När budbärarna kom tillbaka till Jakob sade de: ”Vi träffade din bror Esau, och han kommer emot dig med fyrahundra man.” ");
INSERT INTO swef_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakob blev mycket förskräckt och greps av ångest. Han delade upp sitt folk och fåren, korna och kamelerna i två skaror ");
INSERT INTO swef_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","och sade: ”Om Esau överfaller den ena skaran och slår den, så kan den andra komma undan.” ");
INSERT INTO swef_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Och Jakob bad: ”Herre, min far Abrahams Gud och min far Isaks Gud, Herre, du som sade till mig: Vänd tillbaka till ditt land och till din släkt så ska jag göra dig gott. ");
INSERT INTO swef_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jag är inte värdig all den nåd och trofasthet som du har visat din tjänare. När jag gick över denna Jordan hade jag inte mer än min stav, och nu har jag blivit två skaror. ");
INSERT INTO swef_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Rädda mig från min bror Esaus hand, för jag är rädd att han kommer och dödar mig och mödrarna och barnen. ");
INSERT INTO swef_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Du har själv sagt: Jag ska göra dig mycket gott och låta dina efterkommande bli som havets sand, omöjliga att räkna.” ");
INSERT INTO swef_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jakob stannade där den natten. Från sina hjordar tog han ut gåvor till sin bror Esau: ");
INSERT INTO swef_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","tvåhundra getter och tjugo bockar, tvåhundra tackor och tjugo baggar, ");
INSERT INTO swef_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trettio kamelston som gav di och deras föl, fyrtio kor och tio tjurar samt tjugo åsneston med tio föl. ");
INSERT INTO swef_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Han lämnade dem i sina tjänares hand, var hjord för sig, och sade: ”Gå framför mig och håll ett avstånd mellan hjordarna.” ");
INSERT INTO swef_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Sedan befallde han den som gick först: ”När min bror Esau möter dig och frågar: Vem tillhör du och vart går du, och vem tillhör djuren som du driver framför dig? ");
INSERT INTO swef_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","så ska du svara: De tillhör din tjänare Jakob. Det är en gåva som han skickar till sin herre Esau, och själv kommer han efter oss.” ");
INSERT INTO swef_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Han befallde också den andre och den tredje och alla de andra som drev hjordarna: ”Som jag har sagt er ska ni säga till Esau, när ni kommer fram till honom. ");
INSERT INTO swef_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ni ska också säga: Se, din tjänare Jakob kommer efter oss.” Han tänkte nämligen: ”Jag vill beveka honom med gåvorna som kommer före mig. Sedan kommer jag själv inför hans ansikte. Kanske tar han då emot mig väl.” ");
INSERT INTO swef_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Så kom gåvorna före honom, medan han själv stannade i lägret den natten. ");
INSERT INTO swef_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Men Jakob steg upp samma natt och tog sina båda hustrur och sina båda slavinnor och sina elva söner och gick över Jabboks vadställe. ");
INSERT INTO swef_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Han tog dem och förde dem över bäckravinen tillsammans med allt annat han ägde. ");
INSERT INTO swef_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Och Jakob blev ensam kvar. Då brottades en man med honom ända tills gryningen kom. ");
INSERT INTO swef_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","När han såg att han inte kunde övervinna Jakob, slog han honom på höftleden så att höften gick ur led medan han brottades med honom. ");
INSERT INTO swef_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Och han sade: ”Släpp mig, för gryningen är här.” Men Jakob svarade: ”Jag släpper dig inte förrän du välsignar mig.” ");
INSERT INTO swef_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Då sade han till honom: ”Vad är ditt namn?” Han svarade: ”Jakob.” ");
INSERT INTO swef_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Han sade: ”Du ska inte längre heta Jakob utan Israel, för du har kämpat med Gud och med människor och segrat.” ");
INSERT INTO swef_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Och Jakob frågade: ”Låt mig få veta ditt namn.” Han svarade: ”Varför frågar du efter mitt namn?” Och han välsignade honom där. ");
INSERT INTO swef_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob kallade platsen Peniel, för han tänkte: ”Jag har sett Gud ansikte mot ansikte, och ändå har mitt liv skonats.” ");
INSERT INTO swef_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","När han hade kommit förbi Penuel såg han solen gå upp. Och han haltade på höften. ");
INSERT INTO swef_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Därför äter Israels barn än i dag inte höftsenan som ligger på höftleden, eftersom han slog Jakob på höftleden, på höftsenan. ");
INSERT INTO swef_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob lyfte blicken och fick se Esau komma med fyrahundra man. Då fördelade han sina barn på Lea och Rakel och de båda slavinnorna. ");
INSERT INTO swef_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Han lät slavinnorna med deras barn gå främst, Lea med hennes barn efter dem och Rakel med Josef sist. ");
INSERT INTO swef_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Själv gick han framför dem och bugade sig sju gånger ner till jorden innan han kom fram till sin bror. ");
INSERT INTO swef_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Men Esau sprang emot honom och tog honom i famn, föll honom om halsen och kysste honom. Och de grät. ");
INSERT INTO swef_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","När Esau fick se kvinnorna och barnen sade han: ”Vilka är de här som du har med dig?” Han svarade: ”Det är barnen som Gud har gett din tjänare.” ");
INSERT INTO swef_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Då kom slavinnorna fram med sina barn och bugade sig. ");
INSERT INTO swef_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Efter dem kom Lea fram med sina barn och bugade sig. Till sist kom Josef och Rakel fram och bugade sig. ");
INSERT INTO swef_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau frågade: ”Vad menade du med hela den skaran som jag mötte?” Han svarade: ”Jag ville finna nåd för min herres ögon.” ");
INSERT INTO swef_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Men Esau sade: ”Jag har nog. Behåll det du har, min bror.” ");
INSERT INTO swef_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","”Nej, jag ber dig”, svarade Jakob ”om jag har funnit nåd för dina ögon så ta emot gåvan av mig, eftersom jag har fått se ditt ansikte. Det är som om jag såg Guds eget ansikte när du tar emot mig så vänligt. ");
INSERT INTO swef_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ta emot gåvan som skickades till dig, för Gud har varit nådig mot mig och jag har allt.” Och han bad honom så enträget att Esau tog emot den. ");
INSERT INTO swef_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Och Esau sade: ”Nu bryter vi upp och drar vidare. Jag går framför dig.” ");
INSERT INTO swef_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Men Jakob svarade honom: ”Min herre ser själv att barnen är små och att jag har får och kor med mig som ger di. Om man driver dem för hårt en enda dag så dör hela hjorden. ");
INSERT INTO swef_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Därför ber jag min herre att gå före sin tjänare, så kommer jag efter i den takt som boskapen framför mig klarar av och som barnen orkar med, tills jag kommer till min herre i Seir.” ");
INSERT INTO swef_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Då sade Esau: ”Låt mig lämna kvar en del av mitt folk hos dig.” Men Jakob svarade: ”Varför det? Låt mig bara finna nåd för min herres ögon.” ");
INSERT INTO swef_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Samma dag vände Esau tillbaka och tog vägen till Seir. ");
INSERT INTO swef_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Men Jakob begav sig till Suckot och byggde sig där ett hus. Åt sin boskap gjorde han hyddor, och därför fick platsen namnet Suckot. ");
INSERT INTO swef_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Och Jakob kom på sin färd från Paddan-Aram välbehållen till staden Shekem i Kanaans land och slog läger utanför staden. ");
INSERT INTO swef_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Den mark där han slog upp sitt tält köpte han för hundra kesitor av sönerna till Hamor, Shekems far. ");
INSERT INTO swef_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Och han byggde där ett altare och kallade det El-Elohe-Israel. ");
INSERT INTO swef_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Men Dina, den dotter som Lea hade fött åt Jakob, gick ut för att träffa flickorna i landet. ");
INSERT INTO swef_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shekem som var son till hivén Hamor, fursten i landet, fick se henne och tog henne. Han låg med henne och förnedrade henne. ");
INSERT INTO swef_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Men hans hjärta fäste sig vid Jakobs dotter Dina. Han älskade flickan och talade vänligt med henne. ");
INSERT INTO swef_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Och Shekem sade till sin far Hamor: ”Skaffa mig den flickan till hustru.” ");
INSERT INTO swef_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob fick höra att hans dotter Dina hade blivit orenad, men eftersom hans söner var ute på marken med boskapen teg Jakob tills de kom hem. ");
INSERT INTO swef_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Men Shekems far Hamor gick ut till Jakob för att tala med honom. ");
INSERT INTO swef_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","När Jakobs söner kom hem från marken och fick höra vad som hänt, kände de sorg och vrede över vad Shekem gjort. Att han hade legat med Jakobs dotter var en dårskap i Israel, något som inte fick ske. ");
INSERT INTO swef_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Men Hamor talade med dem och sade: ”Min son Shekem har fäst sig vid er syster. Ge henne åt honom till hustru. ");
INSERT INTO swef_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Gift in er hos oss. Ge oss era döttrar så kan ni ta våra döttrar till hustrur. ");
INSERT INTO swef_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Slå er ner hos oss och landet ska ligga öppet för er. Bo här och flytta omkring och skaffa er ägodelar.” ");
INSERT INTO swef_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Och Shekem sade till hennes far och hennes bröder: ”Låt mig finna nåd för era ögon. Det ni begär vill jag ge er. ");
INSERT INTO swef_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Begär av mig hur stor brudgåva och annan gåva som helst. Jag vill ge vad ni fordrar av mig. Ge mig bara flickan till hustru.” ");
INSERT INTO swef_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jakobs söner svarade Shekem och hans far Hamor med list, eftersom han hade orenat deras syster Dina. ");
INSERT INTO swef_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","De sade till dem: ”Vi kan inte gå med på att ge vår syster åt en man som har förhud. Det skulle vara en skam för oss. ");
INSERT INTO swef_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Vi kan göra er till viljes bara på det villkoret att ni blir som vi och att alla män bland er låter omskära sig. ");
INSERT INTO swef_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Då ska vi ge er våra döttrar och ta era döttrar till hustrur, vi ska bo bland er och bli ett enda folk med er. ");
INSERT INTO swef_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Men om ni inte lyssnar till oss och inte låter er omskäras, kommer vi att ta vår syster och dra bort.” ");
INSERT INTO swef_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor och hans son Shekem tyckte att deras förslag lät bra. ");
INSERT INTO swef_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Och den unge mannen dröjde inte med att göra som de sade, eftersom han var kär i Jakobs dotter. Och han var mer ansedd i sin fars hus än någon annan. ");
INSERT INTO swef_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor och hans son Shekem gick till stadsporten och talade till männen i staden. De sade: ");
INSERT INTO swef_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","”Dessa män är fredligt sinnade mot oss. De kan få bo i landet och flytta omkring här. Landet har ju gott om utrymme för dem. Vi tar deras döttrar till hustrur åt oss och ger dem våra döttrar. ");
INSERT INTO swef_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Men endast på ett villkor kommer männen att göra oss till viljes och bo bland oss och bli ett enda folk med oss: att alla män hos oss blir omskurna liksom de är omskurna. ");
INSERT INTO swef_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Då kommer deras boskap och egendom och alla deras dragdjur att tillhöra oss. Låt oss därför göra dem till viljes så att de bor kvar bland oss.” ");
INSERT INTO swef_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Och folket lydde Hamor och hans son Shekem. Alla män som bodde innanför stadsporten lät omskära sig. ");
INSERT INTO swef_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Men på tredje dagen, när männen var sjuka av såren, tog Jakobs två söner Simeon och Levi, Dinas bröder, var sitt svärd och överföll oväntat staden och dödade alla av manligt kön. ");
INSERT INTO swef_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Även Hamor och hans son Shekem dödade de med svärd och tog med sig Dina ut ur Shekems hus och gav sig i väg. ");
INSERT INTO swef_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Och Jakobs söner gick fram över de slagna och plundrade staden eftersom deras syster hade blivit orenad. ");
INSERT INTO swef_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","De tog deras får, kor och åsnor, både det som fanns i staden och det som fanns ute på fälten. ");
INSERT INTO swef_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Alla deras ägodelar och alla deras barn och kvinnor förde de bort som byte tillsammans med allt annat som fanns i husen. ");
INSERT INTO swef_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Men Jakob sade till Simeon och Levi: ”Ni har dragit olycka över mig och gjort mig förhatlig för dem som bor i landet, kananeerna och perisseerna. Jag har bara några få män. Nu går de samman mot mig och slår ihjäl mig. Både jag och mitt hus kommer att förgöras.” ");
INSERT INTO swef_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Men de svarade: ”Ska man då få behandla vår syster som en hora?” ");
INSERT INTO swef_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Gud sade till Jakob: ”Gå upp till Betel och stanna där och res ett altare åt den Gud som uppenbarade sig för dig när du flydde för din bror Esau.” ");
INSERT INTO swef_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Då sade Jakob till sitt husfolk och till alla som var med honom: ”Gör er av med de främmande gudarna som ni har hos er. Rena er och byt kläder. ");
INSERT INTO swef_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Vi går upp till Betel. Där ska jag resa ett altare åt den Gud som svarade mig när jag var i nöd och som var med mig på vägen jag gick.” ");
INSERT INTO swef_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Och de gav Jakob alla främmande gudar de hade och alla sina örringar, och Jakob grävde ner dem under terebinten vid Shekem. ");
INSERT INTO swef_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sedan bröt de upp, och en skräck från Gud kom över städerna runt omkring så att man inte förföljde Jakobs söner. ");
INSERT INTO swef_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Och Jakob kom till Luz, det vill säga Betel, i Kanaans land med allt folket som var med honom. ");
INSERT INTO swef_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Där byggde han ett altare och kallade platsen El-Betel, därför att Gud hade uppenbarat sig för honom där när han flydde för sin bror. ");
INSERT INTO swef_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora, Rebeckas amma, dog och blev begravd under en ek nedanför Betel. Den fick namnet Gråteken. ");
INSERT INTO swef_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Gud visade sig på nytt för Jakob när han hade kommit tillbaka från Paddan-Aram, och han välsignade honom. ");
INSERT INTO swef_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Gud sade till honom: ”Ditt namn är Jakob. Men du ska inte längre heta Jakob, utan Israel ska vara ditt namn.” Och han gav honom namnet Israel. ");
INSERT INTO swef_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Gud sade till honom: ”Jag är Gud den Allsmäktige. Var fruktsam och föröka dig. Ett folk, ja, många folk ska komma från dig, och kungar ska utgå från dig. ");
INSERT INTO swef_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Det land som jag gett till Abraham och Isak ger jag till dig. Och åt dina efterkommande ska jag ge detta land.” ");
INSERT INTO swef_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sedan steg Gud upp från honom vid platsen där han hade talat med honom. ");
INSERT INTO swef_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Och Jakob reste en stod på platsen där Gud hade talat med honom, en stenstod. Han offrade dryckesoffer på den och hällde olja över den. ");
INSERT INTO swef_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakob kallade platsen där Gud hade talat med honom Betel. ");
INSERT INTO swef_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sedan bröt de upp från Betel. När det var en bit kvar till Efrata började Rakel föda, och förlossningen var svår. ");
INSERT INTO swef_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","När det var som svårast sade barnmorskan till henne: ”Var inte orolig! Du får en son den här gången också.” ");
INSERT INTO swef_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Men när hennes själ skulle lämna henne – hon var döende – gav hon honom namnet Ben-Oni. Men hans far kallade honom Benjamin. ");
INSERT INTO swef_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rakel dog och begravdes vid vägen till Efrata, det vill säga Betlehem. ");
INSERT INTO swef_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakob reste en stod på hennes grav. Det är den som än i dag kallas Rakels gravsten. ");
INSERT INTO swef_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Och Israel bröt upp därifrån och reste sitt tält på andra sidan Herdetornet. ");
INSERT INTO swef_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Medan Israel bodde där i landet hände det att Ruben gick in till sin fars bihustru Bilha och låg med henne. Och Israel fick höra det. Jakob hade tolv söner. ");
INSERT INTO swef_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leas söner var Ruben, Jakobs förstfödde, samt Simeon, Levi, Juda, Isaskar och Sebulon. ");
INSERT INTO swef_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakels söner var Josef och Benjamin. ");
INSERT INTO swef_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rakels slavinna Bilhas söner var Dan och Naftali. ");
INSERT INTO swef_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leas slavinna Silpas söner var Gad och Asher. Detta var Jakobs söner, och de föddes åt honom i Paddan-Aram. ");
INSERT INTO swef_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakob kom hem till sin far Isak i Mamre vid Kirjat-Arba, det vill säga Hebron, där Abraham och Isak hade bott som främlingar. ");
INSERT INTO swef_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Och Isak levde hundraåttio år. ");
INSERT INTO swef_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Sedan gav han upp andan och dog och samlades till sitt folk, gammal och mätt på att leva. Hans söner Esau och Jakob begravde honom. ");
INSERT INTO swef_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Detta är Esaus fortsatta historia, det vill säga Edoms. ");
INSERT INTO swef_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau hade tagit sig hustrur bland Kanaans döttrar: Ada, hetiten Elons dotter, och Oholibama, dotter till Ana och sondotter till hivén Sibon, ");
INSERT INTO swef_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","samt Basemat, dotter till Ismael och syster till Nebajot. ");
INSERT INTO swef_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada födde Elifas åt Esau, och Basemat födde Reguel. ");
INSERT INTO swef_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama födde Jeush, Jalam och Kora. Detta var Esaus söner som föddes åt honom i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau tog med sig sina hustrur, sina söner och döttrar och allt sitt husfolk, sin boskap, alla sina dragdjur och all annan egendom som han skaffat sig i Kanaans land och flyttade till ett annat land, bort från sin bror Jakob. ");
INSERT INTO swef_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","De hade nämligen så mycket ägodelar att de inte kunde bo tillsammans. Landet där de bodde räckte inte till åt dem båda, på grund av deras boskapshjordar. ");
INSERT INTO swef_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau bosatte sig i Seirs bergsbygd. Esau är densamme som Edom. ");
INSERT INTO swef_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Detta är Esaus fortsatta historia. Han blev stamfar till edomiterna i Seirs bergsbygd. ");
INSERT INTO swef_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Och detta är namnen på Esaus söner: Elifas, son till Esaus hustru Ada, och Reguel, son till Esaus hustru Basemat. ");
INSERT INTO swef_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas söner var Teman, Omar, Sefo, Gatam och Kenas. ");
INSERT INTO swef_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, som var bihustru till Elifas, Esaus son, födde Amalek åt Elifas. Dessa var söner till Esaus hustru Ada. ");
INSERT INTO swef_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reguels söner var Nahat och Sera, Shamma och Missa. Dessa var söner till Esaus hustru Basemat. ");
INSERT INTO swef_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaus hustru Oholibama, dotter till Ana och sondotter till Sibon, födde åt Esau sönerna Jeush, Jalam och Kora. ");
INSERT INTO swef_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Detta var stamfurstarna bland Esaus söner: Elifas, Esaus förstföddes, söner var furstarna Teman, Omar, Sefo, Kenas, ");
INSERT INTO swef_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam och Amalek. Dessa furstar härstammade från Elifas i Edoms land. De var söner till Ada. ");
INSERT INTO swef_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Detta var Reguels, Esaus sons, söner: furstarna Nahat, Sera, Shamma och Missa. Dessa furstar härstammade från Reguel i Edom och var söner till Esaus hustru Basemat. ");
INSERT INTO swef_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Detta var Esaus hustru Oholibamas söner: furstarna Jeush, Jalam och Kora. Dessa furstar härstammade från Oholibama, Anas dotter och Esaus hustru. ");
INSERT INTO swef_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dessa var Esaus söner och deras stamfurstar. Esau är densamme som Edom. ");
INSERT INTO swef_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Detta var horén Seirs söner, landets tidigare invånare: Lotan, Shobal, Sibon, Ana, ");
INSERT INTO swef_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Eser och Dishan. Dessa var horeernas stamfurstar, Seirs söner i Edoms land. ");
INSERT INTO swef_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotans söner var Hori och Hemam, och Lotans syster var Timna. ");
INSERT INTO swef_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobals söner var Alvan, Manahat och Ebal, Sefo och Onam. ");
INSERT INTO swef_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibons söner var Aja och Ana. Det var den Ana som fann de varma källorna i öknen när han vaktade sin far Sibons åsnor. ");
INSERT INTO swef_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anas barn var Dishon och Oholibama, Anas dotter. ");
INSERT INTO swef_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishons söner var Hemdan, Esban, Jitran och Keran. ");
INSERT INTO swef_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esers söner var Bilhan, Saavan och Akan. ");
INSERT INTO swef_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishans söner var Us och Aran. ");
INSERT INTO swef_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeernas stamfurstar var Lotan, Shobal, Sibon, Ana, ");
INSERT INTO swef_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Eser och Dishan. Dessa var horeernas stamfurstar i Seirs land, varje furste för sig. ");
INSERT INTO swef_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Detta är de kungar som regerade i Edoms land innan någon kung regerade över israeliterna. ");
INSERT INTO swef_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beors son Bela var kung i Edom, och hans stad hette Dinhaba. ");
INSERT INTO swef_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","När Bela dog blev Jobab, Seras son, från Bosra, kung efter honom. ");
INSERT INTO swef_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","När Jobab dog blev Husham från temaneernas land kung efter honom. ");
INSERT INTO swef_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","När Husham dog blev Hadad, Bedads son, kung efter honom. Det var han som slog midjaniterna på Moabs mark, och hans stad hette Avit. ");
INSERT INTO swef_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","När Hadad dog blev Samla från Masreka kung efter honom. ");
INSERT INTO swef_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","När Samla dog blev Saul från Rehobot vid floden kung efter honom. ");
INSERT INTO swef_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","När Saul dog blev Baal-Hanan, Akbors son, kung efter honom. ");
INSERT INTO swef_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","När Akbors son Baal-Hanan dog blev Hadar kung efter honom. Hans stad hette Pagu och hans hustru hette Mehetabel, dotter till Matred som var dotter till Me-Sahab. ");
INSERT INTO swef_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Detta är namnen på Esaus stamfurstar efter deras släkter och orter: furstarna Timna, Alva, Jetet, ");
INSERT INTO swef_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO swef_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibsar, ");
INSERT INTO swef_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel och Iram. Dessa var alltså Edoms furstar efter deras boplatser i landet de tog i besittning. Edom är densamme som Esau, edomiternas stamfar. ");
INSERT INTO swef_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Men Jakob bosatte sig i Kanaans land, där hans far hade bott som främling. ");
INSERT INTO swef_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Detta är Jakobs fortsatta historia. När Josef var sjutton år vallade han fåren tillsammans med sina bröder. Som ung hjälpte han sönerna till Bilha och Silpa, sin fars hustrur. Och Josef berättade för deras far allt ont som sades om dem. ");
INSERT INTO swef_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel älskade Josef mer än alla sina andra söner, eftersom han hade fått honom på sin ålderdom. Han lät göra en hellång dräkt åt honom. ");
INSERT INTO swef_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","När hans bröder såg att deras far älskade honom mer än alla hans bröder, hatade de honom och kunde inte tala vänligt med honom. ");
INSERT INTO swef_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Josef hade en dröm som han berättade för sina bröder. Efter det hatade de honom ännu mer. ");
INSERT INTO swef_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Han sade till dem: ”Hör vilken dröm jag har haft. ");
INSERT INTO swef_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Vi var och band kärvar på åkern. Då reste sig min kärve upp och blev stående, och era kärvar ställde sig runt omkring och bugade sig för min kärve.” ");
INSERT INTO swef_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Men hans bröder sade till honom: ”Ska du bli vår kung? Ska du härska över oss?” Och de hatade honom ännu mer på grund av hans drömmar och det som han sagt. ");
INSERT INTO swef_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sedan fick han en annan dröm som han berättade för sina bröder. ”Lyssna”, sade han, ”jag har haft en dröm till. Jag drömde att solen och månen och elva stjärnor bugade sig för mig.” ");
INSERT INTO swef_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","När han berättade detta för sin far och sina bröder, tillrättavisade hans far honom och sade: ”Vad är det för en dröm du har haft? Skulle jag och din mor och dina bröder komma och buga oss ner till jorden för dig?” ");
INSERT INTO swef_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bröderna blev avundsjuka på honom, men hans far lade det på minnet. ");
INSERT INTO swef_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Och hans bröder gick för att valla sin fars får i Shekem. ");
INSERT INTO swef_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Då sade Israel till Josef: ”Se, dina bröder vallar fåren i Shekem. Jag vill sända dig till dem.” Han svarade: ”Jag är redo.” ");
INSERT INTO swef_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israel sade till honom: ”Gå och se efter om allt är väl med dina bröder och med fåren. Kom sedan tillbaka till mig med besked.” Så sände han i väg honom från Hebrons dal, och han kom till Shekem. ");
INSERT INTO swef_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Där mötte han en man medan han irrade omkring på fältet. Mannen frågade honom vad han sökte. ");
INSERT INTO swef_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Han svarade: ”Jag letar efter mina bröder. Säg mig var de vallar sin hjord.” ");
INSERT INTO swef_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mannen svarade: ”De har gått härifrån. Jag hörde dem säga att de skulle gå till Dotan.” Då gick Josef vidare efter sina bröder och fann dem i Dotan. ");
INSERT INTO swef_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Men när de såg honom på avstånd, innan han kommit fram till dem, började de prata om att döda honom. ");
INSERT INTO swef_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","De sade till varandra. ”Där kommer drömmaren. ");
INSERT INTO swef_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kom nu, så dödar vi honom och kastar honom i en brunn! Sedan kan vi säga att ett vilddjur åt upp honom. Så får vi se hur det går med hans drömmar!” ");
INSERT INTO swef_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Men när Ruben hörde det, ville han rädda honom från dem och sade: ”Vi kan inte slå ihjäl honom.” ");
INSERT INTO swef_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Och han fortsatte: ”Spill inte blod! Kasta ner honom i brunnen här i öknen, men bär inte hand på honom!” Han ville nämligen rädda honom från dem och föra honom tillbaka till hans far. ");
INSERT INTO swef_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","När Josef kom fram till sina bröder, slet de av honom den hellånga dräkten som han hade på sig. ");
INSERT INTO swef_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Och de tog honom och kastade honom i brunnen. Den var tom, det fanns inget vatten i den. ");
INSERT INTO swef_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sedan satte de sig ner för att äta. Då fick de se en karavan med ismaeliter som kom från Gilead. Deras kameler var lastade med dragantgummi, balsam och ladanum, och de var på väg ner till Egypten. ");
INSERT INTO swef_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Då sade Juda till sina bröder: ”Vad vinner vi på att döda vår bror och dölja hans blod? ");
INSERT INTO swef_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kom, vi säljer honom till ismaeliterna! Vår hand ska inte komma vid honom, han är ju vår bror, vårt eget kött och blod.” Och bröderna lyssnade på honom. ");
INSERT INTO swef_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","När de midjanitiska köpmännen kom förbi, drog de upp Josef ur brunnen. De sålde honom för tjugo siklar silver till ismaeliterna, som förde Josef till Egypten. ");
INSERT INTO swef_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","När Ruben kom tillbaka till brunnen, se, då fanns inte Josef där. Då rev han sönder sina kläder ");
INSERT INTO swef_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","och gick tillbaka till sina bröder och sade: ”Pojken är inte där! Vart ska jag nu ta vägen?” ");
INSERT INTO swef_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Men de slaktade en bock och tog Josefs dräkt och doppade den i blodet. ");
INSERT INTO swef_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Sedan skickade de hem den hellånga dräkten till sin far och lät säga: ”Den här har vi hittat. Se efter om det är din sons dräkt.” ");
INSERT INTO swef_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Och han kände igen den och sade: ”Det är min sons dräkt! Ett vilddjur har ätit upp honom. Josef är säkert ihjälriven.” ");
INSERT INTO swef_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Och Jakob rev sönder sina kläder, svepte säcktyg om sina höfter och sörjde sin son under lång tid. ");
INSERT INTO swef_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Alla hans söner och döttrar kom för att trösta honom, men han ville inte låta sig tröstas utan sade: ”Jag ska med sorg fara ner i dödsriket till min son.” Så grät hans far över honom. ");
INSERT INTO swef_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Men midjaniterna sålde Josef i Egypten till Potifar, som var hovman hos farao och befälhavare för livvakterna. ");
INSERT INTO swef_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Vid den tiden lämnade Juda sina bröder och slöt sig till en man i Adullam som hette Hira. ");
INSERT INTO swef_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Där fick Juda se dottern till en kananeisk man som hette Shua. Han tog henne till sig och gick in till henne. ");
INSERT INTO swef_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Hon blev havande och födde en son som fick namnet Er. ");
INSERT INTO swef_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sedan blev hon havande igen och födde en son som hon gav namnet Onan. ");
INSERT INTO swef_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hon födde ännu en son och gav honom namnet Shela. När han föddes var Juda i Kesib. ");
INSERT INTO swef_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda tog åt Er, sin förstfödde, en hustru som hette Tamar. ");
INSERT INTO swef_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Men Judas förstfödde Er var ond i Herrens ögon, och Herren dödade honom. ");
INSERT INTO swef_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Då sade Juda till Onan: ”Gå in till din brors hustru, gift dig med henne i din brors ställe och skaffa avkomma åt din bror.” ");
INSERT INTO swef_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Men Onan visste att avkomman inte skulle bli hans egen, så han lät säden spillas på jorden varje gång han låg med sin brors hustru, detta för att inte ge avkomma åt sin bror. ");
INSERT INTO swef_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Det Onan gjorde var ont i Herrens ögon, och han dödade också honom. ");
INSERT INTO swef_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Då sade Juda till sin sonhustru Tamar: ”Stanna som änka i din fars hus tills min son Shela blir vuxen.” Han var nämligen rädd att också denne skulle dö liksom hans bröder. Tamar gick då tillbaka till sin fars hus och stannade där. ");
INSERT INTO swef_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","En lång tid därefter dog Shuas dotter, Judas hustru. Efter sorgetidens slut gick Juda med sin vän adullamiten Hira upp till Timna, till dem som klippte hans får. ");
INSERT INTO swef_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","När man berättade för Tamar att hennes svärfar var på väg till Timna för att klippa fåren, ");
INSERT INTO swef_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","lade hon av sig änkekläderna, tog på sig en slöja och satte sig vid porten till Enajim på vägen till Timna. Hon såg nämligen att Shela var fullvuxen och att man ändå inte gav henne till hustru åt honom. ");
INSERT INTO swef_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","När Juda fick se henne trodde han att hon var prostituerad, eftersom hon hade täckt för sitt ansikte. ");
INSERT INTO swef_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Han vek av till henne där hon satt vid vägen, och sade: ”Får jag gå in till dig?” Han visste inte att det var hans sonhustru. Hon svarade: ”Vad vill du ge mig för att få gå in till mig?” ");
INSERT INTO swef_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Han sade: ”Jag skickar dig en killing ur min hjord.” Hon svarade: ”Ja, om du ger mig pant tills du skickar den.” ");
INSERT INTO swef_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Han sade: ”Vad ska jag då ge dig i pant?” Hon svarade: ”Din signetring med kedja och staven som du har i handen.” Då gav han henne detta och gick in till henne, och hon blev havande genom honom. ");
INSERT INTO swef_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sedan gick hon därifrån och lade av sig slöjan och tog på sig änkekläderna igen. ");
INSERT INTO swef_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda skickade killingen med sin vän adullamiten för att få tillbaka panten av kvinnan, men denne hittade henne inte. ");
INSERT INTO swef_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Han frågade männen på platsen var tempelflickan fanns, hon som satt vid vägen i Enajim, men de svarade att det inte hade funnits någon tempelflicka där. ");
INSERT INTO swef_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Och han kom tillbaka till Juda och sade: ”Jag har inte hittat henne. Dessutom säger folket på orten att det inte funnits någon tempelflicka där.” ");
INSERT INTO swef_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Då sade Juda: ”Hon får behålla det så skämmer vi inte ut oss. Jag har nu skickat killingen, men du har inte hittat henne.” ");
INSERT INTO swef_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ungefär tre månader senare fick Juda höra: ”Din sonhustru Tamar har begått otukt och dessutom blivit havande genom sin otukt.” Då sade Juda: ”För ut henne och bränn henne!” ");
INSERT INTO swef_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Men när hon skulle föras ut skickade hon bud till sin svärfar och lät säga: ”Genom en man som äger dessa saker är jag havande. Se efter vem som äger den här signetringen med kedja och den här staven.” ");
INSERT INTO swef_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Och Juda kände igen dem och sade: ”Hon har rätten på sin sida, inte jag, eftersom jag inte har gett henne åt min son Shela.” Men han låg aldrig mer med henne. ");
INSERT INTO swef_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","När hon skulle föda, se, då fanns det tvillingar i hennes moderliv. ");
INSERT INTO swef_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Vid födseln stack den ene fram en hand. Då tog barnmorskan en röd tråd och band den om hans hand och sade: ”Han kom ut först.” ");
INSERT INTO swef_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Men när han sedan drog tillbaka handen kom hans bror ut. Då sade hon: ”Varför har du trängt dig fram?” Och han fick namnet Peres. ");
INSERT INTO swef_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Därefter kom hans bror ut, han som hade den röda tråden om sin hand. Och han fick namnet Sera. ");
INSERT INTO swef_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josef hade förts ner till Egypten. Och Potifar, en egyptisk man som var hovman hos farao och befälhavare för livvakterna, köpte honom av ismaeliterna som hade fört honom dit. ");
INSERT INTO swef_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Herren var med Josef, och han blev en man som lyckades med allt. Han var i sin egyptiske herres hus, ");
INSERT INTO swef_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","och hans herre såg att Herren var med honom, eftersom Herren lät allt han gjorde lyckas i hans hand. ");
INSERT INTO swef_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josef fann nåd för Potifars ögon och fick betjäna honom. Potifar satte honom över hela sitt hus och lämnade allt han ägde i Josefs händer. ");
INSERT INTO swef_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Från den stund han satte honom över sitt hus och alla sina ägodelar, välsignade Herren egyptierns hus för Josefs skull. Herrens välsignelse vilade över allt som var hans, både hemma och ute på marken. ");
INSERT INTO swef_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Och han lämnade allt i Josefs händer. Med honom som hjälp bekymrade han sig inte om något annat än maten som han åt. Josef var välväxt och såg bra ut. ");
INSERT INTO swef_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Efter en tid hände det att hans herres hustru kastade sina blickar på honom och sade: ”Ligg med mig!” ");
INSERT INTO swef_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Men han vägrade och sade till sin herres hustru: ”När min herre har mig i sin tjänst bekymrar han sig inte om något i huset. Allt han äger har han lämnat i mina händer. ");
INSERT INTO swef_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Här i huset har han inte större makt än jag, och han har inte nekat mig någonting, utom dig eftersom du är hans hustru. Hur skulle jag då kunna göra något så ont och synda mot Gud?” ");
INSERT INTO swef_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Och fast hon talade så till Josef dag efter dag, lyssnade han inte på henne. Han ville inte ligga hos henne eller vara tillsammans med henne. ");
INSERT INTO swef_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Men en dag kom han in i huset för att utföra sitt arbete, och ingen av husfolket var därinne. ");
INSERT INTO swef_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Då grep hon honom i manteln och sade: ”Ligg med mig!” Men han lämnade manteln i hennes hand och flydde och sprang ut. ");
INSERT INTO swef_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","När hon såg att han hade lämnat manteln i hennes hand och flytt, ");
INSERT INTO swef_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ropade hon på sitt husfolk och sade till dem: ”Se här! Han har tagit hit till oss en hebreisk man som vill roa sig med oss. Han kom in till mig och ville ligga med mig. Men jag skrek högt, ");
INSERT INTO swef_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","och när han hörde hur jag höjde rösten och skrek, lämnade han manteln hos mig och flydde och sprang ut.” ");
INSERT INTO swef_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Sedan lät hon hans mantel ligga kvar hos sig tills hans herre kom hem. ");
INSERT INTO swef_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Då berättade hon samma sak för honom. Hon sade: ”Den hebreiske tjänaren som du har tagit hit till oss, han kom in till mig för att roa sig med mig. ");
INSERT INTO swef_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Men när jag höjde rösten och ropade, lämnade han sin mantel hos mig och flydde ut.” ");
INSERT INTO swef_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","När Josefs herre hörde sin hustru berätta för honom att hans tjänare hade gjort så mot henne, blev han rasande ");
INSERT INTO swef_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","och satte Josef i fängelset, platsen där kungens fångar hölls fängslade. Där satt Josef i fängelset. ");
INSERT INTO swef_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Men Herren var med Josef, och han gav honom nåd och lät honom bli vänligt bemött av föreståndaren för fängelset. ");
INSERT INTO swef_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Han lät Josef ha ansvar för alla fångar i fängelset och göra allt som skulle göras där. ");
INSERT INTO swef_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Föreståndaren för fängelset bekymrade sig inte om något som Josef hade hand om, eftersom Herren var med honom och lät honom lyckas i allt han gjorde. ");
INSERT INTO swef_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","En tid därefter hände det att den egyptiske kungens munskänk och hans bagare förbröt sig mot sin herre, kungen av Egypten. ");
INSERT INTO swef_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao blev arg på sina båda hovmän, överste munskänken och förste bagaren, ");
INSERT INTO swef_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","och satte dem i förvar hos befälhavaren för livvakterna, i fängelset där Josef satt fången. ");
INSERT INTO swef_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Befälhavaren för livvakterna utsåg Josef att betjäna dem och de satt där i förvar en tid. ");
INSERT INTO swef_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Medan de satt i fängelset hade den egyptiske kungens munskänk och hans bagare samma natt var sin dröm, var och en med sin särskilda tydning. ");
INSERT INTO swef_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","När Josef kom in till dem på morgonen såg han att de var upprörda. ");
INSERT INTO swef_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Han frågade faraos hovmän som satt i förvar med honom i hans herres hus: ”Varför ser ni så sorgsna ut i dag?” ");
INSERT INTO swef_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","De svarade honom: ”Vi har haft en dröm och det finns ingen som kan tyda den.” Josef sade till dem: ”Att ge tydningen är Guds sak. Berätta för mig.” ");
INSERT INTO swef_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Då berättade överste munskänken sin dröm för Josef och sade: ”Jag drömde att jag såg en vinstock framför mig. ");
INSERT INTO swef_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","På vinstocken fanns tre rankor, och knappt hade den skjutit skott förrän blommorna slog ut och klasarna bar mogna druvor. ");
INSERT INTO swef_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Jag hade faraos bägare i handen, och jag tog druvorna och pressade dem i faraos bägare. Sedan satte jag bägaren i faraos hand.” ");
INSERT INTO swef_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef sade till honom: ”Här är tydningen: De tre rankorna betyder tre dagar. ");
INSERT INTO swef_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Om tre dagar ska farao upphöja ditt huvud och ge dig din plats tillbaka. Du ska få ge farao bägaren i handen som förut när du var hans munskänk. ");
INSERT INTO swef_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Men tänk på mig när det går bra för dig. Visa barmhärtighet mot mig och påminn farao om mig och hjälp mig ut ur det här huset. ");
INSERT INTO swef_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Jag blev bortrövad från hebreernas land, och här har jag heller inte gjort något som jag skulle bli satt i fängelse för.” ");
INSERT INTO swef_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","När förste bagaren såg att Josef hade gett en god tydning, sade han till honom: ”Jag hade också en dröm, och där bar jag tre korgar med vetebröd på huvudet. ");
INSERT INTO swef_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I den översta korgen fanns det alla slags bakverk som farao brukar äta. Men fåglarna åt dem ur korgen på mitt huvud.” ");
INSERT INTO swef_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Då sade Josef: ”Här är tydningen: De tre korgarna betyder tre dagar. ");
INSERT INTO swef_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Om tre dagar ska farao upphöja ditt huvud och ta av dig det. Han ska hänga upp dig på trä, och fåglarna ska äta ditt kött.” ");
INSERT INTO swef_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tre dagar därefter var det faraos födelsedag, och han höll en fest för alla sina tjänare. Då upphöjde han bland sina tjänare både överste munskänkens huvud och förste bagarens. ");
INSERT INTO swef_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Han lät överste munskänken få tillbaka sin tjänst och sätta bägaren i faraos hand igen, ");
INSERT INTO swef_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","men förste bagaren lät han hänga, så som Josef hade uttytt för dem. ");
INSERT INTO swef_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Men överste munskänken kom inte ihåg Josef utan glömde honom. ");
INSERT INTO swef_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Efter två år hände det att farao drömde att han stod vid Nilen. ");
INSERT INTO swef_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Han såg sju kor, vackra och feta, komma upp ur floden, och de betade i vassen. ");
INSERT INTO swef_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Sedan såg han sju andra kor, fula och magra, komma upp ur floden. De ställde sig bredvid de andra korna på flodstranden, ");
INSERT INTO swef_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","och de fula och magra korna åt upp de sju vackra och feta korna. Därefter vaknade farao. ");
INSERT INTO swef_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Men han somnade igen och såg då i drömmen sju ax, frodiga och vackra, som växte på samma strå. ");
INSERT INTO swef_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Sedan såg han sju andra ax skjuta upp, tunna och svedda av östanvinden. ");
INSERT INTO swef_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Och de sju tunna axen slukade de sju frodiga och fulla axen. Sedan vaknade farao, och se, det var en dröm. ");
INSERT INTO swef_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","På morgonen var han orolig till sinnes, och han skickade efter och kallade till sig Egyptens alla spåmän och vise män. Farao berättade sina drömmar för dem, men det fanns ingen som kunde tyda dem för honom. ");
INSERT INTO swef_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Då sade överste munskänken till farao: ”I dag måste jag påminna om mina synder. ");
INSERT INTO swef_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","När farao en gång var arg på sina tjänare, satte han mig och förste bagaren i förvar hos befälhavaren för livvakterna. ");
INSERT INTO swef_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Då hade vi båda samma natt var sin dröm, och våra drömmar hade var sin särskilda tydning. ");
INSERT INTO swef_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tillsammans med oss fanns där en ung hebré som var tjänare hos befälhavaren för livvakterna. Vi berättade våra drömmar för honom och han tydde dem för oss. Han tydde vad var och en av oss hade drömt, ");
INSERT INTO swef_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","och som han tydde för oss, så blev det. Jag fick tillbaka min tjänst och den andre hängdes.” ");
INSERT INTO swef_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Då skickade farao bud efter Josef. Man skyndade sig att hämta ut honom ur fängelset, och han fick raka sig och byta kläder och kom sedan inför farao. ");
INSERT INTO swef_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao sade till Josef: ”Jag har haft en dröm, och det finns ingen som kan tyda den. Men jag har hört om dig att när du får höra en dröm så kan du tyda den.” ");
INSERT INTO swef_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef sade till farao: ”Inte jag, men Gud kan ge farao ett gynnsamt svar.” ");
INSERT INTO swef_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Då sade farao till Josef: ”Jag drömde att jag stod på Nilens strand. ");
INSERT INTO swef_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Jag såg sju kor, vackra och feta, komma upp ur floden, och de betade i vassen. ");
INSERT INTO swef_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sedan såg jag sju andra kor komma upp, klena och mycket fula och magra. Jag har aldrig sett så fula kor i hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Och de magra och fula korna åt upp de sju första, feta korna. ");
INSERT INTO swef_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Men när de hade svalt dem, märktes inte att de hade ätit upp dem. De var lika fula som förut. Sedan vaknade jag. ");
INSERT INTO swef_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Men jag drömde igen och såg då sju ax, fullmatade och vackra, växa på samma strå. ");
INSERT INTO swef_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sedan såg jag sju andra ax skjuta upp, torra och tunna och svedda av östanvinden. ");
INSERT INTO swef_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Och de tunna axen slukade de sju vackra axen. Detta har jag talat om för spåmännen, men ingen kunde förklara det för mig.” ");
INSERT INTO swef_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Då sade Josef till farao: ”Faraos drömmar har en och samma betydelse. Gud har visat farao vad han tänker göra. ");
INSERT INTO swef_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De sju vackra korna betyder sju år, och de sju vackra axen betyder också sju år. Drömmarna har en och samma betydelse. ");
INSERT INTO swef_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","De sju magra och fula korna som kom upp efter dem betyder sju år, likaså de sju tomma axen som var svedda av östanvinden. Det ska komma sju hungerår. ");
INSERT INTO swef_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Det var det jag menade när jag sade till farao: Gud har låtit farao veta vad han tänker göra. ");
INSERT INTO swef_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sju år ska komma med stort överflöd över hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Men efter dem ska det komma sju hungerår så att man glömmer allt det överflöd som var i Egypten, och svälten ska ödelägga landet. ");
INSERT INTO swef_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Man ska inte minnas överflödet som var i landet på grund av den svält som sedan kommer, för den ska bli mycket svår. ");
INSERT INTO swef_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Och att farao har haft drömmen två gånger betyder att det är fast bestämt av Gud och att han låter det komma snart. ");
INSERT INTO swef_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Därför bör farao utse en förståndig och vis man och sätta honom över Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao bör också sätta förvaltare över landet och ta upp en femtedel av skörden i Egypten under de sju överflödsåren. ");
INSERT INTO swef_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Under de kommande goda åren ska de samla in allt ätbart och lagra och förvara säd under faraos tillsyn i städerna. ");
INSERT INTO swef_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Det ska finnas förråd av livsmedel för landet under de sju hungerår som ska drabba Egypten. Då behöver inte landet gå under genom svälten.” ");
INSERT INTO swef_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Detta tilltalade farao och alla hans tjänare, ");
INSERT INTO swef_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","och han sade till dem: ”Finns det någon som har Guds ande som denne man?” ");
INSERT INTO swef_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Och farao sade till Josef: ”Eftersom Gud har uppenbarat allt detta för dig, så finns det ingen som är så förståndig och vis som du. ");
INSERT INTO swef_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du ska styra över mitt hus, och allt mitt folk ska rätta sig efter dina befallningar. Bara när det gäller tronen ska jag vara högre än du.” ");
INSERT INTO swef_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Och farao sade till Josef: ”Se, jag sätter dig över hela Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Och farao tog av ringen från sin hand och satte den på Josefs hand, och han klädde honom i kläder av fint linne och hängde en kedja av guld runt hans hals. ");
INSERT INTO swef_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Han lät honom åka i vagnen närmast efter sin egen och man ropade ”Abrek!” framför honom. Så satte farao honom över hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Sedan sade farao till Josef: ”Jag är farao. Utan din vilja ska ingen i Egyptens land lyfta hand eller fot.” ");
INSERT INTO swef_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao gav Josef namnet Safenat-Panéa och gav honom till hustru Asenat, dotter till Poti-Fera, prästen i On. Sedan reste Josef omkring i Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef var trettio år när han stod inför farao, Egyptens kung. Han lämnade farao och reste omkring i hela Egypten. ");
INSERT INTO swef_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Under de sju goda åren gav landet skörd i överflöd, ");
INSERT INTO swef_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","och under dessa sju år samlade Josef in allt ätbart och lagrade det i städerna. I varje stad lagrade han den föda som kom från fälten runt omkring. ");
INSERT INTO swef_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","På så sätt samlade Josef så mycket säd som det finns sand i havet. Till sist slutade han att hålla räkning på den, för den kunde inte räknas. ");
INSERT INTO swef_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Innan hungeråren kom föddes två söner åt Josef. De föddes av Asenat, dotter till Poti-Fera, prästen i On. ");
INSERT INTO swef_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef gav den förstfödde namnet Manasse, ”för”, sade han, ”Gud har låtit mig glömma all min olycka och hela min fars hus.” ");
INSERT INTO swef_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den andre gav han namnet Efraim, ”för”, sade han, ”Gud har gjort mig fruktsam i mitt lidandes land.” ");
INSERT INTO swef_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Men de sju överflödsåren i Egypten tog slut. ");
INSERT INTO swef_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Och så började de sju hungeråren som Josef hade förutsagt. Det blev svält i alla länder, men i Egypten fanns det bröd överallt. ");
INSERT INTO swef_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Och när hela Egyptens land började hungra och folket ropade till farao efter bröd, sade han till alla egyptierna: ”Gå till Josef och gör som han säger!” ");
INSERT INTO swef_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","När svälten hade brett ut sig över hela landet, öppnade Josef alla förrådshus och sålde säd till egyptierna. Men svälten blev allt svårare i Egypten. ");
INSERT INTO swef_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Och man kom från hela världen till Josef i Egypten för att köpa säd, för svälten var svår i hela världen. ");
INSERT INTO swef_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","När Jakob fick veta att det fanns säd i Egypten, sade han till sina söner: ”Varför står ni bara och ser på varann?” ");
INSERT INTO swef_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Och han fortsatte: ”Jag har hört att det finns säd i Egypten. Res dit och köp säd åt oss, så att vi överlever och inte dör.” ");
INSERT INTO swef_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Då reste tio av Josefs bröder ner för att köpa säd i Egypten. ");
INSERT INTO swef_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jakob skickade inte Josefs bror Benjamin med de andra bröderna, för han var rädd att det skulle hända honom någon olycka. ");
INSERT INTO swef_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Så var också Israels söner bland dem som kom för att köpa säd, eftersom det rådde svält i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josef var nu den som hade makten i landet, och det var han som sålde säd till allt folket. Då kom Josefs bröder dit och bugade sig för honom med ansiktena mot jorden. ");
INSERT INTO swef_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","När Josef såg sina bröder kände han igen dem. Men han låtsades att han var en främling för dem och tilltalade dem hårt och frågade dem: ”Var kommer ni ifrån?” De svarade: ”Från Kanaans land för att köpa säd.” ");
INSERT INTO swef_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Trots att Josef kände igen sina bröder kände de inte igen honom. ");
INSERT INTO swef_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Då tänkte Josef på drömmarna som han hade haft om dem. Han sade till dem: ”Ni är spejare. Ni har kommit för att se var landet saknar skydd.” ");
INSERT INTO swef_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","De svarade honom: ”Nej, herre, dina tjänare har kommit för att köpa mat. ");
INSERT INTO swef_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Vi är alla söner till en och samme man. Vi är hederliga män, dina tjänare är inga spejare.” ");
INSERT INTO swef_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Men han sade till dem: ”Jo, ni har kommit för att ta reda på var landet saknar skydd.” ");
INSERT INTO swef_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","De svarade: ”Vi, dina tjänare, är tolv bröder, söner till en och samme man i Kanaans land. Den yngste är hemma hos vår far och en lever inte längre.” ");
INSERT INTO swef_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef sade till dem: ”Det är som jag har sagt er. Ni är spejare. ");
INSERT INTO swef_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Så här ska jag pröva er: Så sant farao lever, ni slipper inte härifrån om inte er yngste bror kommer hit. ");
INSERT INTO swef_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","En av er måste gå och hämta hit er bror, medan ni andra stannar som fångar. Så kan jag pröva om ni har talat sanning. Annars är ni spejare, så sant farao lever.” ");
INSERT INTO swef_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Sedan höll han dem i förvar i tre dagar. ");
INSERT INTO swef_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","På tredje dagen sade Josef till dem: ”Om ni vill leva så gör så här, för jag fruktar Gud. ");
INSERT INTO swef_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Om ni är hederliga män, låt då en av era bröder stanna som fånge i huset där ni satt fängslade. Men ni andra får resa i väg och ta hem säden som ni köpt till hjälp mot svälten hos er. ");
INSERT INTO swef_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ta sedan med er yngste bror hit till mig. Om ni talat sanning ska ni slippa dö.” Och de gjorde så. ");
INSERT INTO swef_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Men de sade till varandra: ”Vi har skuld efter det vi gjorde mot vår bror. Vi såg ångesten i hans själ när han bad om förbarmande, men vi ville inte lyssna på honom. Därför har vi själva kommit i denna ångest.” ");
INSERT INTO swef_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben svarade dem: ”Sade jag inte till er att ni inte skulle synda mot pojken? Men ni lyssnade inte på mig. Därför utkrävs nu hans blod.” ");
INSERT INTO swef_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Men de visste inte att Josef förstod, för han talade till dem genom tolk. ");
INSERT INTO swef_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Han vände sig bort från dem och grät. Sedan vände han sig till dem igen och talade med dem. Och han tog Simeon från dem och lät fängsla honom inför deras ögon. ");
INSERT INTO swef_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josef befallde att man skulle fylla deras säckar med säd och lägga tillbaka vars och ens pengar i hans säck och ge dem mat för resan. När man hade gjort så, ");
INSERT INTO swef_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","lastade de säden på sina åsnor och reste därifrån. ");
INSERT INTO swef_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Men när en av dem öppnade sin säck vid en rastplats för att ge sin åsna foder, fick han se sina pengar ligga överst i säcken. ");
INSERT INTO swef_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Och han sade till sina bröder: ”Jag har fått tillbaka mina pengar. Titta här! De är i min säck!” Då sjönk deras mod, och darrande av skräck sade de till varandra: ”Vad har Gud gjort mot oss?” ");
INSERT INTO swef_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","När de kom hem till sin far Jakob i Kanaans land, berättade de för honom allt som hade hänt dem och sade: ");
INSERT INTO swef_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","”Mannen som var herre där i landet talade hårt till oss och behandlade oss som om vi var spejare i landet. ");
INSERT INTO swef_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Men vi sade till honom: Vi är hederliga män, vi är inga spejare. ");
INSERT INTO swef_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Vi är tolv bröder, söner till en och samme far. En lever inte längre och den yngste är hemma hos vår far i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Men mannen som var herre i landet svarade oss: Så här ska jag ta reda på om ni är hederliga män: Lämna kvar en av era bröder hos mig. Ta det ni köpt mot svälten hemma hos er och res i väg. ");
INSERT INTO swef_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kom sedan med er yngste bror hit till mig, så att jag kan vara säker på att ni inte är spejare utan hederliga män. Då ska jag ge tillbaka er bror till er och ni ska få röra er fritt i landet.” ");
INSERT INTO swef_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","När de sedan tömde sina säckar hittade var och en sin pengapåse i sin säck. Både de och deras far blev förskräckta när de fick se pengapåsarna. ");
INSERT INTO swef_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Och deras far Jakob sade till dem: ”Ni gör mig barnlös! Josef är borta, Simeon är borta och Benjamin vill ni också ta ifrån mig. Allting är emot mig!” ");
INSERT INTO swef_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben sade då till sin far: ”Du får döda båda mina söner om jag inte för Benjamin tillbaka till dig. Anförtro honom åt mig. Jag ska föra honom tillbaka till dig.” ");
INSERT INTO swef_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Men han svarade: ”Min son får inte resa dit med er. Hans bror är död och han är ensam kvar. Om någon olycka skulle hända honom på resan ni tänker göra, skulle ni föra mina grå hår med sorg ner i dödsriket.” ");
INSERT INTO swef_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Men svälten var svår i landet. ");
INSERT INTO swef_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","När de hade ätit upp säden som de hade hämtat från Egypten, sade deras far till dem: ”Res tillbaka och köp oss lite säd.” ");
INSERT INTO swef_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Men Juda svarade honom: ”Mannen sade uttryckligen till oss: Ni får inte komma inför mitt ansikte om inte er bror är med er. ");
INSERT INTO swef_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Om du låter vår bror följa med oss, reser vi ner och köper säd åt dig. ");
INSERT INTO swef_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Men om du inte låter honom följa med oss reser vi inte, eftersom mannen sade till oss: Ni får inte komma inför mitt ansikte om inte er bror är med er.” ");
INSERT INTO swef_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Då sade Israel: ”Varför gjorde ni så illa mot mig att ni berättade för mannen att ni hade en bror till?” ");
INSERT INTO swef_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","De svarade: ”Mannen frågade noga om oss och vår släkt. Han sade: Lever er far ännu? Har ni någon bror? Då berättade vi för honom hur det var. Kunde vi veta att han skulle säga: Ta med er bror hit ner?” ");
INSERT INTO swef_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda sade då till sin far Israel: ”Låt pojken följa med mig. Vi måste ge oss i väg om vi ska överleva och inte dö, både vi och du och våra barn. ");
INSERT INTO swef_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Jag ska ansvara för honom. Du får utkräva honom av min hand. Om jag inte kommer tillbaka med honom till dig och ställer honom här inför dig, ska jag vara en syndare inför dig i alla mina dagar. ");
INSERT INTO swef_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Och hade vi inte dröjt så länge hade vi redan varit tillbaka för andra gången.” ");
INSERT INTO swef_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Då sade deras far Israel till dem: ”Om det måste bli så, gör då så här: Ta lite av landets bästa frukt i era säckar och bär ner det till mannen som gåva, lite balsam och lite honung, dragantgummi och ladanum, pistaschnötter och mandlar. ");
INSERT INTO swef_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ta med er dubbla summan pengar och återlämna pengarna ni fick tillbaka överst i era säckar. Kanske var det ett misstag. ");
INSERT INTO swef_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ta också med er bror och res genast tillbaka till mannen. ");
INSERT INTO swef_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Må Gud den Allsmäktige låta er finna barmhärtighet hos mannen så att han låter er andre bror och Benjamin följa med er hem igen. Och ska jag bli barnlös, så blir jag det.” ");
INSERT INTO swef_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Då tog männen gåvorna och den dubbla summan pengar. De tog med sig Benjamin, bröt upp och gav sig i väg till Egypten och kom inför Josef. ");
INSERT INTO swef_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","När Josef såg att Benjamin var med, sade han till sin husförvaltare: ”Ta dessa män till mitt hus. Slakta något och laga oss en måltid, för männen ska äta middag med mig.” ");
INSERT INTO swef_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mannen gjorde som Josef hade sagt och tog männen till Josefs hus. ");
INSERT INTO swef_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Men männen blev förskräckta när de visades in i Josefs hus. De sade: ”Det är på grund av pengarna som vi fick tillbaka i våra säckar förra gången som vi förs in här. Nu tänker han kasta sig över oss och övermanna oss och göra oss till slavar och ta våra åsnor.” ");
INSERT INTO swef_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","De steg fram till Josefs husförvaltare vid ingången till huset ");
INSERT INTO swef_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","och sade till honom: ”Hör på oss, herre! När vi var här nere förra gången för att köpa säd ");
INSERT INTO swef_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","och sedan kom till en rastplats och öppnade våra säckar, hittade alla vi våra pengar till deras fulla vikt överst i sin säck. Nu har vi med dem tillbaka, ");
INSERT INTO swef_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","och vi har med oss andra pengar för att köpa säd. Vi vet inte vem som lagt pengarna i våra säckar.” ");
INSERT INTO swef_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Han svarade: ”Oroa er inte, var inte rädda! Det är er Gud och er fars Gud som låtit er hitta en skatt i era säckar. Jag har fått era pengar.” Och han förde ut Simeon till dem. ");
INSERT INTO swef_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mannen förde dem in i Josefs hus. Han gav dem vatten att tvätta fötterna med och gav deras åsnor foder. ");
INSERT INTO swef_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","De gjorde i ordning sina gåvor innan Josef kom hem vid middagstiden, eftersom de hade fått höra att de skulle äta där. ");
INSERT INTO swef_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","När Josef kom hem gav de honom gåvorna som de hade med sig dit till huset, och de bugade sig till jorden för honom. ");
INSERT INTO swef_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Han hälsade på dem och frågade: ”Är det bra med er gamle far som ni talade om? Lever han än?” ");
INSERT INTO swef_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","De svarade: ”Ja, det är bra med vår far, din tjänare. Han lever än.” Och de bugade sig och föll ner för honom. ");
INSERT INTO swef_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","När han såg sig omkring och fick se sin bror Benjamin, sin mors son, frågade han: ”Är det er yngste bror som ni nämnde för mig?” Sedan sade han: ”Gud ska vara nådig mot dig, min son.” ");
INSERT INTO swef_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Djupt rörd av kärlek till sin bror skyndade Josef sig ut och letade efter en plats där han kunde gråta. Och han gick in i sin kammare och grät där. ");
INSERT INTO swef_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","När han hade tvättat ansiktet gick han ut igen, behärskade sig och sade: ”Sätt fram maten.” ");
INSERT INTO swef_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Och de satte fram särskilt för honom och särskilt för dem och särskilt för egyptierna som åt tillsammans med honom. Egyptier får nämligen inte äta tillsammans med hebreer, det anses avskyvärt bland egyptierna. ");
INSERT INTO swef_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","De fick sina platser mitt emot Josef, den förstfödde enligt sin förstfödslorätt, sedan de yngre, var och en efter sin ålder. Och männen såg förundrade på varandra. ");
INSERT INTO swef_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Han lät servera dem av rätterna på sitt bord, och Benjamin fick fem gånger så mycket som alla de andra. Och de drack sig glada tillsammans med honom. ");
INSERT INTO swef_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Därefter befallde Josef sin husförvaltare: ”Fyll männens säckar med säd så mycket de rymmer, och lägg vars och ens pengar överst i hans säck. ");
INSERT INTO swef_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Och min bägare, silverbägaren, ska du lägga överst i den yngstes säck tillsammans med pengarna för hans säd.” Han gjorde som Josef hade sagt. ");
INSERT INTO swef_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","På morgonen när det blev ljust sändes männen i väg med sina åsnor. ");
INSERT INTO swef_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Men de hade inte kommit långt utanför staden när Josef sade till sin husförvaltare: ”Sätt efter männen! När du hinner upp dem ska du säga till dem: Varför har ni lönat gott med ont? ");
INSERT INTO swef_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Det är ju den här som min herre dricker ur och som han brukar spå med. Det är en ond gärning ni har gjort.” ");
INSERT INTO swef_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","När han kom ifatt dem sade han dessa ord till dem. ");
INSERT INTO swef_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Då svarade de honom: ”Varför talar min herre så? Dina tjänare skulle aldrig kunna göra något sådant! ");
INSERT INTO swef_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Pengarna vi fann överst i våra säckar har vi ju fört tillbaka till dig från Kanaans land. Varför skulle vi då stjäla silver eller guld ur din herres hus? ");
INSERT INTO swef_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Den av dina tjänare som har bägaren ska dö, och vi andra ska bli min herres slavar.” ");
INSERT INTO swef_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Han svarade: ”Ja, det ska bli som ni har sagt. Den som bägaren finns hos ska bli min slav. Men ni andra är utan skuld.” ");
INSERT INTO swef_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Var och en skyndade sig att lyfta ner sin säck på marken och öppnade den. ");
INSERT INTO swef_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Han sökte först hos den äldste och slutade hos den yngste. Och bägaren hittades i Benjamins säck. ");
INSERT INTO swef_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Då rev de sönder sina kläder, lastade sina åsnor och vände tillbaka till staden. ");
INSERT INTO swef_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda och hans bröder gick in i Josefs hus, där han ännu var kvar, och föll ner till jorden för honom. ");
INSERT INTO swef_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Då sade Josef till dem: ”Vad har ni gjort? Förstod ni inte att en man som jag kan spå?” ");
INSERT INTO swef_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda svarade: ”Vad ska vi säga till min herre? Hur ska vi tala och hur ska vi rentvå oss? Gud har funnit dina tjänares missgärning. Vi är nu min herres slavar, både den som bägaren hittades hos och vi andra.” ");
INSERT INTO swef_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Men Josef sade: ”Nej, aldrig skulle jag göra så! Den som bägaren hittades hos ska bli min slav. Men ni andra kan resa hem till er far i frid.” ");
INSERT INTO swef_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Då steg Juda fram till honom och sade: ”Lyssna på mig, herre! Låt din tjänare säga ett ord inför min herre och bli inte arg på din tjänare, för du är som farao. ");
INSERT INTO swef_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Min herre frågade sina tjänare och sade: Har ni en far eller någon mer bror? ");
INSERT INTO swef_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Vi svarade min herre: Vi har en gammal far och en son till honom, en som är född på hans ålderdom och som fortfarande är ung. Men en bror till honom är död, så han är den ende som är kvar efter sin mor, och hans far älskar honom. ");
INSERT INTO swef_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Då sade du till dina tjänare: Ta ner honom hit till mig så att jag får se honom med egna ögon. ");
INSERT INTO swef_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Och vi svarade min herre: Pojken kan inte lämna sin far, han skulle dö om han lämnade honom. ");
INSERT INTO swef_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Men du sade till dina tjänare: Om inte er yngste bror följer med er hit så får ni inte komma inför mitt ansikte. ");
INSERT INTO swef_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","När vi kommit hem till din tjänare, min far, berättade vi för honom vad min herre hade sagt. ");
INSERT INTO swef_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Och när vår far sade: Res tillbaka och köp oss lite säd, ");
INSERT INTO swef_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","svarade vi: Vi kan inte resa dit ner. Bara på det villkoret att vår yngste bror följer med oss kan vi resa. Vi får inte komma inför mannens ansikte om inte vår yngste bror är med. ");
INSERT INTO swef_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Men din tjänare, min far, sade till oss: Ni vet själva att min hustru födde mig två söner. ");
INSERT INTO swef_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","En gick bort ifrån mig, och jag sade: Han är säkert ihjälriven. Och jag har inte sett honom sedan dess. ");
INSERT INTO swef_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Om ni tar ifrån mig den här också och det händer honom en olycka, så skickar ni ner mina grå hår med sorg i dödsriket. ");
INSERT INTO swef_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Så om jag kommer hem till din tjänare, min far, utan pojken som vår fars hjärta är så fäst vid, ");
INSERT INTO swef_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","då blir det hans död när han ser att pojken inte är med. Dina tjänare skulle då skicka ner din tjänares, vår fars, grå hår med sorg i dödsriket. ");
INSERT INTO swef_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Jag, din tjänare, har lovat min far att ansvara för pojken, och jag har sagt att om jag inte har med honom hem igen ska jag vara en syndare inför min far i alla mina dagar. ");
INSERT INTO swef_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Låt därför din tjänare stanna här hos min herre som slav i pojkens ställe, men låt honom resa hem med sina bröder. ");
INSERT INTO swef_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Hur skulle jag kunna resa hem till min far utan att ha pojken med mig? Jag klarar inte att se den sorg som då skulle drabba min far.” ");
INSERT INTO swef_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Då kunde Josef inte behärska sig längre inför alla som stod omkring honom. Han ropade: ”Gå ut härifrån allihop!” Ingen fick stanna inne hos Josef när han gav sig till känna för sina bröder. ");
INSERT INTO swef_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Han började gråta så högt att egyptierna hörde det, och faraos husfolk hörde det också. ");
INSERT INTO swef_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Och Josef sade till sina bröder: ”Jag är Josef. Lever far än?” Men hans bröder kunde inte svara, så förskräckta blev de för honom. ");
INSERT INTO swef_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Då sade Josef till dem: ”Kom hit till mig.” När de kom fram sade han: ”Jag är er bror Josef som ni sålde till Egypten. ");
INSERT INTO swef_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Men var inte ledsna och sörj inte över att ni sålde mig hit. Det var för att rädda liv som Gud sände mig hit före er. ");
INSERT INTO swef_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","I två år har det nu varit svält i landet, och det återstår fem år då man varken ska plöja eller skörda. ");
INSERT INTO swef_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Men Gud sände mig hit före er, för att låta er bli kvar på jorden och hålla er vid liv, till räddning för många. ");
INSERT INTO swef_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Det är alltså inte ni som sänt mig hit utan Gud. Han har gjort mig till en fader åt farao och till herre över hela hans hus och till härskare över hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Skynda er hem till far och säg till honom: Så säger din son Josef: Gud har satt mig till herre över hela Egypten. Kom ner till mig. Dröj inte! ");
INSERT INTO swef_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Du ska få bo i landet Goshen och vara nära mig, du och dina barn och barnbarn, dina får och kor och allt som tillhör dig. ");
INSERT INTO swef_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Det är fem hungerår kvar, men jag ska sörja för dig så att varken du eller ditt hus eller någon som tillhör dig ska lida nöd. ");
INSERT INTO swef_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ni ser ju med egna ögon, min bror Benjamin ser det också med egna ögon, att det är jag som talar till er med egen mun. ");
INSERT INTO swef_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Berätta för far om all min härlighet i Egypten och om allt ni har sett. Och skynda er att föra far hit ner.” ");
INSERT INTO swef_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Han föll sin bror Benjamin om halsen och grät, och Benjamin grät vid hans hals. ");
INSERT INTO swef_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Han kysste alla sina bröder och grät i deras armar. Därefter samtalade hans bröder med honom. ");
INSERT INTO swef_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","När ryktet spred sig i faraos palats att Josefs bröder hade kommit, gladde det farao och hans tjänare. ");
INSERT INTO swef_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Och farao sade till Josef: ”Säg till dina bröder att göra så här: Lasta era djur och res hem till Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Hämta sedan er far och ert husfolk och kom hit till mig, så ska jag ge er det bästa som finns i Egyptens land och ni ska få äta av landets överflöd. ");
INSERT INTO swef_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Du ska säga till dem att göra så här: Ta med er vagnar från Egyptens land för era små barn och era hustrur, och hämta er far och kom hit. ");
INSERT INTO swef_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bekymra er inte om era ägodelar, för det bästa som finns i hela Egyptens land ska vara ert.” ");
INSERT INTO swef_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israels söner gjorde så, och Josef gav dem vagnar som farao befallt och gav dem också reskost. ");
INSERT INTO swef_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Och han gav dem var sin högtidsdräkt, men Benjamin gav han trehundra siklar silver och fem högtidsdräkter. ");
INSERT INTO swef_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Till sin far skickade han också gåvor, tio åsnor lastade med det bästa Egypten hade och tio åsneston lastade med säd och bröd och andra livsmedel åt hans far för resan. ");
INSERT INTO swef_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Sedan lät han sina bröder resa, och de gav sig i väg. Och han sade till dem: ”Gräla inte på vägen hem!” ");
INSERT INTO swef_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","De drog upp från Egypten och kom till sin far Jakob i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","De berättade för honom: ”Josef lever än, och han är härskare över hela Egyptens land!” Då blev han alldeles lamslagen, han kunde inte tro dem. ");
INSERT INTO swef_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Men när de talade om för honom allt vad Josef hade sagt till dem och när han såg vagnarna som Josef hade skickat för att hämta honom, då fick deras far Jakob nytt liv. ");
INSERT INTO swef_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Och Israel sade: ”Det räcker. Min son Josef lever än. Jag vill ge mig av så att jag får se honom innan jag dör.” ");
INSERT INTO swef_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel bröt upp med allt han ägde. När han kom till Beer-Sheba offrade han slaktoffer åt sin far Isaks Gud. ");
INSERT INTO swef_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Och Gud talade till Israel i en syn om natten och sade: ”Jakob! Jakob!” Han svarade: ”Här är jag.” ");
INSERT INTO swef_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Då sade han: ”Jag är Gud, din fars Gud. Var inte rädd för att resa till Egypten, för jag ska där göra dig till ett stort folk. ");
INSERT INTO swef_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Jag ska själv följa med dig till Egypten och jag ska också föra dig tillbaka därifrån. Och Josefs hand ska sluta dina ögon.” ");
INSERT INTO swef_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jakob bröt upp från Beer-Sheba. Och Israels söner satte sin far Jakob, sina små barn och sina hustrur på vagnarna som farao hade skickat för att hämta honom. ");
INSERT INTO swef_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","De tog sin boskap och de ägodelar som de skaffat sig i Kanaans land och kom till Egypten, Jakob och alla hans ättlingar med honom. ");
INSERT INTO swef_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sina söner och sonsöner, sina döttrar och sondöttrar, alla sina ättlingar förde han med sig till Egypten. ");
INSERT INTO swef_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Detta är namnen på Israels barn, Jakob och hans söner, som kom till Egypten: Jakobs förstfödde var Ruben, ");
INSERT INTO swef_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","och Rubens söner var Henok, Pallu, Hesron och Karmi. ");
INSERT INTO swef_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeons söner var Jemuel, Jamin, Ohad, Jakin, Sohar och Saul, den kananeiska kvinnans son. ");
INSERT INTO swef_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levis söner var Gershon, Kehat och Merari. ");
INSERT INTO swef_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judas söner var Er, Onan, Shela, Peres och Sera, men Er och Onan dog i Kanaans land, och Peres söner var Hesron och Hamul. ");
INSERT INTO swef_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskars söner var Tola, Puva, Job och Shimron. ");
INSERT INTO swef_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulons söner var Sered, Elon och Jaleel. ");
INSERT INTO swef_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Detta var Leas söner som hon födde åt Jakob i Paddan-Aram. Dessutom födde hon åt honom dottern Dina. Sönerna och döttrarna var sammanlagt trettiotre personer. ");
INSERT INTO swef_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gads söner var Sifjon och Haggi, Shuni och Esbon, Eri och Arodi och Areli. ");
INSERT INTO swef_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ashers söner var Jimna, Jishva, Jishvi och Beria, och deras syster var Sera. Berias söner var Heber och Malkiel. ");
INSERT INTO swef_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dessa var söner till Silpa, som Laban hade gett åt sin dotter Lea. Hon födde dem åt Jakob, sexton personer. ");
INSERT INTO swef_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rakels, Jakobs hustrus, söner var Josef och Benjamin. ");
INSERT INTO swef_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","De söner som föddes åt Josef i Egyptens land var Manasse och Efraim. De föddes åt honom av Asenat, som var dotter till Poti-Fera, prästen i On. ");
INSERT INTO swef_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamins söner var Bela, Beker och Ashbel, Gera och Naaman, Ehi och Rosh, Muppim och Huppim och Ard. ");
INSERT INTO swef_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dessa var Rakels söner som föddes åt Jakob, sammanlagt fjorton personer. ");
INSERT INTO swef_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dans son var Hushim. ");
INSERT INTO swef_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalis söner var Jaseel, Guni, Jeser och Shillem. ");
INSERT INTO swef_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dessa var söner till Bilha, som Laban hade gett åt sin dotter Rakel, och hon födde dem åt Jakob, sammanlagt sju personer. ");
INSERT INTO swef_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De som kom med Jakob till Egypten, hans ättlingar, var sammanlagt sextiosex personer förutom Jakobs sonhustrur. ");
INSERT INTO swef_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Och Josefs söner, som föddes åt honom i Egypten, var två. De personer av Jakobs hus som kom till Egypten var sammanlagt sjuttio. ");
INSERT INTO swef_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakob skickade Juda i förväg till Josef för att han skulle visa honom vägen till Goshen. Och de kom till landet Goshen. ");
INSERT INTO swef_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef lät spänna för sin vagn och for till Goshen för att möta sin far Israel. När han kom fram till honom föll han honom om halsen och grät länge vid hans hals. ");
INSERT INTO swef_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Och Israel sade till Josef: ”Nu kan jag dö, när jag fått se ditt ansikte och vet att du fortfarande lever.” ");
INSERT INTO swef_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Josef sade till sina bröder och sin fars husfolk: ”Jag ska gå upp och tala med farao och säga till honom: Mina bröder och min fars husfolk, som har bott i Kanaans land, har kommit till mig. ");
INSERT INTO swef_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","De här männen är herdar och har ägnat sig åt boskapsskötsel. De har med sig sina får och kor och allt de äger. ");
INSERT INTO swef_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","När sedan farao kallar er till sig och frågar vilket yrke ni har, ");
INSERT INTO swef_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ska ni svara: Vi, dina tjänare, har sysslat med boskapsskötsel från vår ungdom och fram till nu, vi liksom våra fäder. Då kommer ni att få bo i landet Goshen, för egyptierna avskyr allt vad fåraherdar heter.” ");
INSERT INTO swef_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Och Josef kom och berättade för farao: ”Min far och mina bröder har kommit från Kanaans land med sina får och kor och allt de äger. De är nu i landet Goshen.” ");
INSERT INTO swef_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Han hade valt ut fem av sina bröder och förde fram dem inför farao. ");
INSERT INTO swef_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Då frågade farao hans bröder: ”Vad har ni för yrke?” De svarade farao: ”Dina tjänare är fåraherdar, vi liksom våra fäder.” ");
INSERT INTO swef_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","De sade också till farao: ”Vi har kommit för att bo här i landet en tid, för dina tjänare har inget bete för sina får eftersom svälten är svår i Kanaans land. Så låt dina tjänare bo i landet Goshen.” ");
INSERT INTO swef_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Då sade farao till Josef: ”Din far och dina bröder har alltså kommit till dig. ");
INSERT INTO swef_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egyptens land ligger öppet för dig. Låt din far och dina bröder bo i den bästa delen av landet, låt dem bo i landet Goshen. Och om du vet att några bland dem är dugliga män, så sätt dem till uppsyningsmän över min boskap.” ");
INSERT INTO swef_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Sedan hämtade Josef sin far Jakob och förde honom fram inför farao, och Jakob hälsade farao. ");
INSERT INTO swef_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Och farao frågade Jakob: ”Hur många år har du levt?” ");
INSERT INTO swef_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob svarade farao: ”Min vandringstid har varat i hundratrettio år. Få och svåra har mina levnadsår varit. De når inte upp till mina förfäders levnadsår under deras vandringstid.” ");
INSERT INTO swef_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Och Jakob välsignade farao och gick ut ifrån honom. ");
INSERT INTO swef_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josef lät sin far och sina bröder bo i Egyptens land och gav dem egendom i den bästa delen av landet, i Raamses område som farao befallt. ");
INSERT INTO swef_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josef försörjde sin far och sina bröder och hela sin fars hus och gav var och en underhåll efter antalet barn. ");
INSERT INTO swef_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Men det fanns inget bröd någonstans i landet eftersom svälten var mycket svår, och både Egypten och Kanaans land var svaga av hunger. ");
INSERT INTO swef_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","För den säd som folket köpte samlade Josef alla pengar som fanns i Egypten och Kanaan och förde dem in i faraos palats. ");
INSERT INTO swef_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Men när pengarna tog slut i Egypten och Kanaan, kom alla egyptier till Josef och sade: ”Ge oss bröd! Varför skulle vi dö här framför ögonen på dig? Vi har inga pengar kvar.” ");
INSERT INTO swef_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josef svarade: ”För hit er boskap, så ska jag ge er bröd för boskapen om era pengar är slut.” ");
INSERT INTO swef_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Då kom de med sin boskap till Josef, och han gav dem bröd i utbyte mot deras hästar, får, kor och åsnor. På så sätt underhöll han dem det året och gav dem bröd i utbyte mot all deras boskap. ");
INSERT INTO swef_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Så tog det året slut. Men året därpå kom de tillbaka till honom och sade: ”Vi kan inte dölja det för min herre. Pengarna är slut och boskapen vi ägde tillhör min herre. Vi har inget annat kvar än våra kroppar och vår jord. ");
INSERT INTO swef_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Varför skulle vi dö här framför dig, vi och vår åkerjord? Köp oss och vår jord för bröd, så ska vi med vår jord bli faraos slavar. Ge oss bara utsäde, så att vi får leva och inte dör och åkerjorden inte läggs öde.” ");
INSERT INTO swef_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Då köpte Josef all jord i Egypten åt farao. Alla egyptierna sålde sina åkrar eftersom svälten var så svår, och åkerjorden blev faraos egendom. ");
INSERT INTO swef_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Folket flyttade han till städerna, från ena änden av Egypten till den andra. ");
INSERT INTO swef_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Men prästernas jord köpte han inte, eftersom prästerna hade sitt bestämda underhåll av farao och levde av det som farao gav dem. Därför behövde de inte sälja sin jord. ");
INSERT INTO swef_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Och Josef sade till folket: ”Nu har jag köpt er och er jord åt farao. Här har ni utsäde så att ni kan beså jorden. ");
INSERT INTO swef_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","När skörden kommer in ska ni ge en femtedel åt farao. Men fyra femtedelar ska ni själva ha till utsäde och till mat åt er och ert husfolk och era små barn.” ");
INSERT INTO swef_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","De svarade: ”Du har räddat våra liv. Herre, låt oss finna nåd för dina ögon, så ska vi vara faraos slavar.” ");
INSERT INTO swef_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josef gjorde det till en lag som gäller än i dag för Egyptens jord, att femtedelen av skörden ska ges åt farao. Det var bara prästernas jord som inte blev faraos egendom. ");
INSERT INTO swef_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Så bodde Israel i landet Goshen i Egypten. De skaffade sig ägodelar och var fruktsamma och förökade sig mycket. ");
INSERT INTO swef_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob levde sjutton år i Egypten, och han blev hundrafyrtiosju år gammal. ");
INSERT INTO swef_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","När tiden närmade sig att Israel skulle dö, kallade han till sig sin son Josef och sade till honom: ”Om jag har funnit nåd för dina ögon, så lägg din hand under min höft och lova att visa mig kärlek och trofasthet så att du inte begraver mig i Egypten. ");
INSERT INTO swef_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","När jag gått till vila hos mina fäder, för mig då ut ur Egypten och begrav mig i deras grav.” Han svarade: ”Jag ska göra som du säger.” ");
INSERT INTO swef_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Men Jakob sade: ”Ge mig din ed!” Och han gav honom sin ed, och Israel tillbad böjd mot bäddens huvudände. ");
INSERT INTO swef_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Efter en tid sade man till Josef: ”Din far är sjuk.” Då tog han med sig sina båda söner Manasse och Efraim. ");
INSERT INTO swef_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Och man sade till Jakob: ”Din son Josef har kommit till dig.” Israel samlade då sina krafter och satte sig upp i sängen. ");
INSERT INTO swef_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Han sade till Josef: ”Gud den Allsmäktige uppenbarade sig för mig i Luz i Kanaans land. Han välsignade mig ");
INSERT INTO swef_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","och sade till mig: Jag ska göra dig fruktsam och föröka dig och låta många folk komma från dig, och jag ska ge detta land åt dina efterkommande till egendom för evigt. ");
INSERT INTO swef_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Dina båda söner, som föddes åt dig i Egyptens land innan jag kom hit till dig i Egypten, ska nu vara mina. Efraim och Manasse ska vara mina liksom Ruben och Simeon. ");
INSERT INTO swef_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Men de barn som du får efter dem ska vara dina. De ska bära sina bröders namn i deras arvedel. ");
INSERT INTO swef_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","När jag kom från Paddan dog Rakel i Kanaans land under resan, när det ännu var ett stycke kvar till Efrata, och jag begravde henne där vid vägen till Efrata.” – Platsen heter nu Betlehem. ");
INSERT INTO swef_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","När Israel fick se Josefs söner frågade han: ”Vilka är dessa?” ");
INSERT INTO swef_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef svarade sin far: ”Det är mina söner som Gud har gett mig här.” Då sade han: ”Ta hit dem till mig så att jag får välsigna dem.” ");
INSERT INTO swef_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israels ögon var svaga av ålder så att han inte kunde se. Josef förde fram dem till honom, och han kysste dem och tog dem i sin famn. ");
INSERT INTO swef_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Och Israel sade till Josef: ”Jag trodde inte att jag skulle få se ditt ansikte, men nu har Gud till och med låtit mig se dina barn!” ");
INSERT INTO swef_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Och Josef tog dem från hans knä och bugade sig till jorden. ");
INSERT INTO swef_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sedan tog Josef dem båda i handen, Efraim i sin högra hand till vänster framför Israel, och Manasse i sin vänstra hand till höger framför Israel, och förde fram dem till honom. ");
INSERT INTO swef_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Men Israel räckte ut sin högra hand och lade den på Efraims huvud trots att han var den yngre, och sin vänstra hand på Manasses huvud trots att Manasse var den förstfödde. Han lade händerna i kors. ");
INSERT INTO swef_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Och han välsignade Josef och sade: ”Den Gud som mina fäder Abraham och Isak har vandrat inför, den Gud som har varit min herde från min födelse ända till i dag, ");
INSERT INTO swef_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","den ängel som har förlossat mig från allt ont, han ska välsigna pojkarna. De ska uppkallas efter mitt namn och mina fäder Abrahams och Isaks namn, och de ska föröka sig och bli många på jorden.” ");
INSERT INTO swef_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Men när Josef såg att hans far lade sin högra hand på Efraims huvud, tyckte han inte om det. Han tog sin fars hand och ville flytta den från Efraims till Manasses huvud. ");
INSERT INTO swef_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Och Josef sade till sin far: ”Gör inte så, far. Det här är den förstfödde. Lägg din högra hand på hans huvud.” ");
INSERT INTO swef_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Men hans far ville inte det. Han sade: ”Jag vet, min son, jag vet. Också från honom ska det komma ett folk, också han ska bli stor. Men hans yngre bror ska ändå bli större än han, och flera folk ska härstamma från honom.” ");
INSERT INTO swef_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Och han välsignade dem på den dagen och sade: ”I dig ska Israel välsigna och säga: Må Gud göra dig som Efraim och Manasse.” Och han satte Efraim före Manasse. ");
INSERT INTO swef_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Därefter sade Israel till Josef: ”Se, jag dör. Men Gud ska vara med er och föra er tillbaka till era fäders land. ");
INSERT INTO swef_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Och utöver det jag ger dina bröder, ger jag dig en bergsrygg som jag tog från amoreerna med mitt svärd och min båge.” ");
INSERT INTO swef_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Och Jakob kallade sina söner till sig och sade: ”Kom hit till mig, så ska jag tala om vad som ska hända er i kommande dagar. ");
INSERT INTO swef_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Samla er och lyssna, ni Jakobs söner, hör på Israel, er far! ");
INSERT INTO swef_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, du är min förstfödde, min kraft och min styrkas förstling, främst i myndighet och främst i makt. ");
INSERT INTO swef_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Du sjuder över som vatten, du ska inte bli den främste, för du besteg din fars bädd, då vanhelgade du den. Han besteg min säng! ");
INSERT INTO swef_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon och Levi är bröder, våldet är deras vapen. ");
INSERT INTO swef_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Min själ ska inte ta del i deras råd, min själ ska inte umgås med dem, för de dödade män i sin vrede och stympade oxar i sitt övermod. ");
INSERT INTO swef_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Förbannad är deras vrede som är så våldsam och deras grymhet som är så stor! Jag ska dela upp dem i Jakob och skingra dem i Israel. ");
INSERT INTO swef_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, dig ska dina bröder prisa. Din hand ska gripa dina fienders nacke, din fars söner ska buga sig för dig. ");
INSERT INTO swef_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ett ungt lejon är Juda. Du reser dig från rivet byte, min son. Han böjer sig, han lägger sig som ett lejon, som en lejonhona – vem vågar väcka honom? ");
INSERT INTO swef_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Spiran ska inte vika från Juda, inte härskarstaven från hans fötter, förrän han som den tillhör kommer och folken lyder honom. ");
INSERT INTO swef_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Han binder sin ungåsna vid vinstocken, sitt åsneföl vid den ädla rankan. Han tvättar sina kläder i vin, sin mantel i druvors blod. ");
INSERT INTO swef_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Hans ögon är dunkla av vin, hans tänder vita av mjölk. ");
INSERT INTO swef_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon ska bo vid havets strand och bli en hamn för skepp. Sin sida ska han vända mot Sidon. ");
INSERT INTO swef_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaskar är en stark åsna som ligger i ro i sitt hägn. ");
INSERT INTO swef_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Han såg att viloplatsen var god och landet ljuvligt. Då böjde han sin rygg under bördor och blev en arbetspliktig slav. ");
INSERT INTO swef_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ska skaffa rätt åt sitt folk som en av Israels stammar. ");
INSERT INTO swef_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ska vara en orm på vägen, en huggorm på stigen som biter hästen i foten så att ryttaren faller baklänges. ");
INSERT INTO swef_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Herre, jag väntar på din frälsning! ");
INSERT INTO swef_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad ska trängas av skaror och själv tränga dem in på hälarna. ");
INSERT INTO swef_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Från Asher kommer utsökta rätter, han ska bjuda på kungliga läckerheter. ");
INSERT INTO swef_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali är en frisläppt hind som talar vackra ord. ");
INSERT INTO swef_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josef är ett ungt fruktträd, ett ungt fruktträd vid källan. Grenarna når upp över muren. ");
INSERT INTO swef_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bågskyttar oroar honom, de skjuter mot honom och ansätter honom. ");
INSERT INTO swef_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Men hans båge förblir fast och hans händer och armar spänstiga genom Jakobs Mäktige, genom Herden, Israels Klippa, ");
INSERT INTO swef_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","genom din fars Gud som ska hjälpa dig, genom den Allsmäktige som ska välsigna dig med välsignelser från himlen därovan, välsignelser från djupet som ruvar där nere, välsignelser från bröst och moderliv. ");
INSERT INTO swef_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Din fars välsignelser når högt, högre än mina fäders välsignelser, till de eviga höjdernas härlighet. De ska vara över Josefs huvud, över hjässan på fursten bland sina bröder. ");
INSERT INTO swef_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin är en glupsk varg. På morgonen äter han sitt rov, på kvällen fördelar han bytet.” ");
INSERT INTO swef_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Alla dessa är Israels tolv stammar, och detta är vad deras far sade till dem. Han välsignade dem och gav åt var och en sin särskilda välsignelse. ");
INSERT INTO swef_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sedan befallde han dem och sade: ”Jag ska nu samlas till mitt folk. Begrav mig hos mina fäder i grottan på hetiten Efrons mark, ");
INSERT INTO swef_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","i grottan vid fältet i Makpela mitt emot Mamre i Kanaans land, den som Abraham köpte till gravplats av hetiten Efron. ");
INSERT INTO swef_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Där begravdes Abraham och hans hustru Sara, där begravdes Isak och hans hustru Rebecka, och där har jag själv begravt Lea, ");
INSERT INTO swef_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","i grottan på marken som köptes av hetiterna.” ");
INSERT INTO swef_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","När Jakob hade gett sina söner dessa befallningar drog han upp fötterna i sängen. Och han gav upp andan och samlades till sitt folk. ");
INSERT INTO swef_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Då böjde Josef sig ner över sin fars ansikte och grät över honom och kysste honom. ");
INSERT INTO swef_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Josef befallde läkarna han hade i sin tjänst att balsamera hans far. Och läkarna balsamerade Israel. ");
INSERT INTO swef_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Det tog fyrtio dagar, så lång tid tar en balsamering. Och egyptierna sörjde honom i sjuttio dagar. ");
INSERT INTO swef_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","När sorgedagarna efter honom var över sade Josef till faraos husfolk: ”Om jag har funnit nåd för era ögon, ber jag er säga dessa ord till farao: ");
INSERT INTO swef_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Min far har tagit ed av mig och sagt: När jag är död, så begrav mig i den grav som jag grävt åt mig i Kanaans land. Låt mig därför resa och begrava min far och sedan komma tillbaka.” ");
INSERT INTO swef_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao svarade: ”Res dit och begrav din far enligt den ed som han tog av dig.” ");
INSERT INTO swef_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Då reste Josef för att begrava sin far. Och faraos alla tjänare reste med honom, de äldste vid hans hov och alla de äldste i Egyptens land, ");
INSERT INTO swef_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dessutom allt Josefs husfolk och hans bröder och hans fars husfolk. Bara sina små barn, sina får och sina kor lämnade de kvar i landet Goshen. ");
INSERT INTO swef_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Både vagnar och ryttare reste tillsammans med honom, och det var en mycket stor skara. ");
INSERT INTO swef_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","När de kom till Goren-Haatad på andra sidan Jordan höll de där en mycket stor och högtidlig dödsklagan, och han ordnade en sorgehögtid efter sin far i sju dagar. ");
INSERT INTO swef_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","När landets invånare kananeerna såg sorgehögtiden i Goren-Haatad sade de: ”Här har egyptierna en stor sorgehögtid.” Därför kallades platsen Abel-Misrajim. Den ligger på andra sidan Jordan. ");
INSERT INTO swef_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jakobs söner gjorde med honom som han hade befallt dem. ");
INSERT INTO swef_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","De förde honom till Kanaans land och begravde honom i grottan vid fältet i Makpela, den mark som Abraham hade köpt till gravplats av hetiten Efron mitt emot Mamre. ");
INSERT INTO swef_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","När Josef hade begravt sin far, vände han tillbaka till Egypten med sina bröder och alla som följt med honom för att begrava hans far. ");
INSERT INTO swef_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","När Josefs bröder såg att deras far var död, sade de: ”Tänk om Josef hyser agg mot oss och ger igen för allt det onda som vi gjort mot honom.” ");
INSERT INTO swef_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Därför sände de bud till Josef och lät säga: ”Din far sade så här före sin död: ");
INSERT INTO swef_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Så ska ni säga till Josef: Vi ber dig, förlåt dina bröder deras brott och synd, att de gjort så illa mot dig. Så förlåt nu den synd som din fars Guds tjänare har begått.” Josef grät när han fick deras hälsning. ");
INSERT INTO swef_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sedan kom också hans bröder och föll ner för honom och sade: ”Vi är dina slavar.” ");
INSERT INTO swef_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Men Josef sade till dem: ”Var inte rädda. Skulle jag ta Guds plats? ");
INSERT INTO swef_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ni menade ont mot mig, men Gud har menat något gott genom det, för att bevara många människor vid liv. ");
INSERT INTO swef_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Så var inte rädda. Jag ska sörja för er och era små barn.” Och han tröstade dem och talade vänligt till dem. ");
INSERT INTO swef_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef bodde kvar i Egypten med sin fars husfolk, och han blev hundratio år. ");
INSERT INTO swef_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josef fick se Efraims barn till tredje led. Även Manasses son Makirs barn lades i Josefs knä när de föddes. ");
INSERT INTO swef_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Och Josef sade till sina bröder: ”Jag dör, men Gud ska se till er och föra er från detta land till det land som han lovat med ed åt Abraham, Isak och Jakob.” ");
INSERT INTO swef_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Och Josef tog ed av Israels söner och sade: ”När Gud ser till er, för då mina ben härifrån.” ");
INSERT INTO swef_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josef dog när han var hundratio år. Och man balsamerade honom och lade honom i en kista i Egypten. ");
INSERT INTO swef_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Detta är namnen på Israels söner. De kom till Egypten tillsammans med Jakob, var och en med sitt hus: ");
INSERT INTO swef_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, Juda, ");
INSERT INTO swef_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaskar, Sebulon, Benjamin, ");
INSERT INTO swef_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad och Asher. ");
INSERT INTO swef_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","De som härstammade från Jakob var sammanlagt sjuttio personer. Josef var redan i Egypten. ");
INSERT INTO swef_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sedan dog han och alla hans bröder, hela den generationen. ");
INSERT INTO swef_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Men Israels barn var fruktsamma och blev fler, de förökade sig och blev mycket talrika så att landet blev uppfyllt av dem. ");
INSERT INTO swef_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Och det kom en ny kung i Egypten, en som inte kände till Josef. ");
INSERT INTO swef_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Han sade till sitt folk: ”Se, Israels barns folk har blivit för stort och mäktigt för oss. ");
INSERT INTO swef_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nu ska vi gå klokt till väga med dem. Annars kanske de förökar sig ännu mer, och om det blir krig kan de gå samman med våra fiender och föra krig mot oss och sedan ge sig av från landet.” ");
INSERT INTO swef_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Därför satte man arbetsledare över dem och plågade dem med tvångsarbete. De byggde förrådsstäderna Pitom och Raamses åt farao. ");
INSERT INTO swef_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Men ju mer man plågade dem, desto mer förökade de sig och desto mer spred de ut sig, så att man kände fruktan för Israels barn. ");
INSERT INTO swef_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Egyptierna tvingade israeliterna att arbeta som slavar. ");
INSERT INTO swef_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","De gjorde livet svårt för dem genom hårt arbete med murbruk och tegel och med allt arbete på fälten, med alla slags arbeten som de tvingade dem att utföra. ");
INSERT INTO swef_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kungen av Egypten talade med dem som förlöste de hebreiska kvinnorna. En av dem hette Shifra och den andra Pua, ");
INSERT INTO swef_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","och han sade: ”Se efter vad de hebreiska kvinnorna föder när ni förlöser dem: Om det är en son så döda honom, om det är en dotter så låt henne leva.” ");
INSERT INTO swef_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Men barnmorskorna fruktade Gud och gjorde inte som den egyptiske kungen hade befallt dem utan lät barnen leva. ");
INSERT INTO swef_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Då kallade kungen till sig barnmorskorna och sade till dem: ”Varför har ni gjort så här och låtit barnen leva?” ");
INSERT INTO swef_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Barnmorskorna svarade farao: ”Hebreiska kvinnor är inte som egyptiska. De är livskraftiga, de har fött innan barnmorskan kommer till dem.” ");
INSERT INTO swef_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Och Gud lät det gå väl för barnmorskorna, och folket förökades och blev mycket talrikt. ");
INSERT INTO swef_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Eftersom barnmorskorna fruktade Gud gav han dem egna familjer. ");
INSERT INTO swef_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Då befallde farao allt sitt folk: ”Alla nyfödda pojkar ska ni kasta i Nilen, men alla flickor ska ni låta leva.” ");
INSERT INTO swef_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","En man av Levi stam tog till hustru en levitisk kvinna. ");
INSERT INTO swef_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Hustrun blev havande och födde en son. Hon såg att det var ett vackert barn och höll honom gömd i tre månader. ");
INSERT INTO swef_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Men när hon inte kunde gömma honom längre, tog hon en korg av papyrus. Hon strök på beck och tjära, lade barnet i korgen och satte den i vassen vid Nilens strand. ");
INSERT INTO swef_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hans syster ställde sig på avstånd för att se hur det skulle gå med honom. ");
INSERT INTO swef_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Då kom faraos dotter ner till floden för att bada, och hennes unga hovdamer gick längs floden. När hon fick se korgen i vassen skickade hon dit sin slavinna för att hämta den. ");
INSERT INTO swef_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Hon öppnade den och fick syn på barnet – det var en pojke, och han grät. Hon kände medlidande med honom och sade: ”Det är ett av de hebreiska barnen.” ");
INSERT INTO swef_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Men hans syster frågade faraos dotter: ”Ska jag gå och hämta en hebreisk amma som kan amma barnet åt dig?” ");
INSERT INTO swef_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraos dotter svarade henne: ”Ja, gör det.” Då gick flickan och hämtade pojkens mor. ");
INSERT INTO swef_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Och faraos dotter sade till henne: ”Ta med dig det här barnet och amma det åt mig, så ska jag ge dig lön för det.” Kvinnan tog då barnet och ammade det. ");
INSERT INTO swef_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","När pojken hade vuxit upp förde hon honom till faraos dotter, och han blev hennes son. Hon gav honom namnet Mose, ”för jag drog upp honom ur vattnet”, sade hon. ");
INSERT INTO swef_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En dag när Mose hade blivit vuxen, gick han ut till sina bröder och såg på deras slavarbete. Han fick se en egyptier som slog en hebreisk man, en av hans bröder. ");
INSERT INTO swef_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Då vände han sig åt alla håll, och när han såg att ingen annan var där slog han ihjäl egyptiern och gömde honom i sanden. ");
INSERT INTO swef_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nästa dag gick han ut igen och fick då se två hebreiska män i slagsmål. Då sade han till den som var skyldig: ”Varför slår du din landsman?” ");
INSERT INTO swef_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Han svarade: ”Vem har satt dig till ledare och domare över oss? Tänker du döda mig som du dödade egyptiern?” Mose blev förskräckt och tänkte: ”Saken har alltså blivit känd!” ");
INSERT INTO swef_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao fick också höra om det och ville döda Mose. Men han flydde undan farao och bosatte sig i Midjans land. Där satte han sig vid en brunn. ");
INSERT INTO swef_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Prästen i Midjan hade sju döttrar. De kom och hämtade upp vatten och fyllde hoarna för att vattna sin fars får. ");
INSERT INTO swef_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Då kom herdarna och körde bort dem. Men Mose grep in och räddade dem och gav vatten åt deras får. ");
INSERT INTO swef_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","När de kom hem till sin far Reguel, sade han: ”Varför kommer ni hem så tidigt i dag?” ");
INSERT INTO swef_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","De svarade: ”En egyptisk man hjälpte oss mot herdarna. Han hämtade till och med upp vatten åt oss och vattnade fåren.” ");
INSERT INTO swef_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Då sade han till sina döttrar: ”Var är han? Varför gick ni ifrån honom? Bjud in honom så att han får äta med oss.” ");
INSERT INTO swef_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose bestämde sig för att stanna hos mannen, som gav honom sin dotter Sippora till hustru. ");
INSERT INTO swef_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Hon födde en son och Mose gav honom namnet Gershom, ”för”, sade han, ”jag har blivit en främling i ett främmande land.” ");
INSERT INTO swef_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Det gick en lång tid, och under den tiden dog Egyptens kung. Men Israels barn suckade över sitt slaveri och ropade på hjälp, och deras rop över slaveriet steg upp till Gud. ");
INSERT INTO swef_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Gud hörde deras klagan och kom ihåg sitt förbund med Abraham, Isak och Jakob. ");
INSERT INTO swef_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Och Gud såg till Israels barn, och Gud kändes vid dem som sina. ");
INSERT INTO swef_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose vallade fåren åt sin svärfar Jetro, prästen i Midjan. En gång drev han fåren till andra sidan öknen och kom till Guds berg Horeb. ");
INSERT INTO swef_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Där uppenbarade sig Herrens ängel för honom i en eldslåga som slog upp ur en buske. Han såg att busken brann av elden utan att busken brann upp. ");
INSERT INTO swef_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Då tänkte Mose: ”Jag måste gå dit och se den underbara synen, varför busken inte brinner upp.” ");
INSERT INTO swef_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","När Herren såg att han kom för att se efter, ropade Gud till honom ur busken: ”Mose! Mose!” Han svarade: ”Här är jag.” ");
INSERT INTO swef_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Då sade Gud: ”Kom inte närmare! Ta av dig skorna, för platsen där du står är helig mark.” ");
INSERT INTO swef_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Och han sade: ”Jag är din fars Gud – Abrahams Gud, Isaks Gud och Jakobs Gud.” Då dolde Mose ansiktet, för han bävade för att se på Gud. ");
INSERT INTO swef_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Herren sade: ”Jag har sett hur mitt folk förtrycks i Egypten, och jag har hört hur de ropar över sina plågare. Jag känner deras lidande. ");
INSERT INTO swef_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Därför har jag kommit ner för att rädda dem från egyptierna och föra dem ut ur det landet upp till ett gott och rymligt land, ett land som flödar av mjölk och honung, en plats där det bor kananeer, hetiter, amoreer, perisseer, hiveer och jebusiter. ");
INSERT INTO swef_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nu har ropet från Israels barn kommit upp till mig, och jag har sett hur egyptierna förtrycker dem. ");
INSERT INTO swef_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Så gå nu! Jag ska sända dig till farao, och du ska föra mitt folk, Israels barn, ut ur Egypten.” ");
INSERT INTO swef_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Men Mose sade till Gud: ”Vem är jag, att jag skulle gå till farao och föra Israels barn ut ur Egypten?” ");
INSERT INTO swef_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Han svarade: ”Jag ska vara med dig. Och här är ditt tecken på att det är jag som har sänt dig: När du har fört folket ut ur Egypten, ska ni hålla gudstjänst på detta berg.” ");
INSERT INTO swef_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Då sade Mose till Gud: ”Om jag kommer till Israels barn och säger till dem: Era fäders Gud har sänt mig till er, och de frågar mig: Vad är hans namn? – vad ska jag då svara dem?” ");
INSERT INTO swef_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gud sade till Mose: ”Jag är den Jag Är.” Och han fortsatte: ”Så ska du säga till Israels barn: Jag Är har sänt mig till er.” ");
INSERT INTO swef_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Och Gud sade sedan till Mose: ”Så ska du säga till Israels barn: Herren, era fäders Gud, Abrahams Gud, Isaks Gud och Jakobs Gud, har sänt mig till er. Det ska vara mitt namn för evigt och så ska man kalla mig från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Gå nu och samla de äldste i Israel och säg till dem: Herren, era fäders Gud, Abrahams Gud, Isaks Gud och Jakobs Gud, har uppenbarat sig för mig och sagt: Jag har sett till er och vet vad de har gjort mot er i Egypten. ");
INSERT INTO swef_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Därför säger jag: Jag ska föra er ut ur lidandet i Egypten och upp till kananeernas, hetiternas, amoreernas, perisseernas, hiveernas och jebusiternas land, ett land som flödar av mjölk och honung. ");
INSERT INTO swef_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","De kommer att lyssna till dina ord, och du och Israels äldste ska gå till Egyptens kung och säga till honom: Herren, hebreernas Gud, har visat sig för oss. Låt oss gå tre dagsresor in i öknen och offra åt Herren vår Gud. ");
INSERT INTO swef_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Men jag vet att Egyptens kung inte kommer att låta er gå om inte en stark hand tvingar honom. ");
INSERT INTO swef_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Därför ska jag räcka ut min hand och slå Egypten med alla slags under som jag ska göra där. Sedan kommer han att släppa er. ");
INSERT INTO swef_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Och jag ska låta detta folk finna nåd för egyptiernas ögon så att ni inte behöver gå tomhänta när ni drar bort. ");
INSERT INTO swef_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nej, varje kvinna ska be sin grannfru och kvinnorna som bor i hennes hus om föremål av silver och guld och även kläder, som ni ska sätta på era söner och döttrar. Så ska ni ta byte från egyptierna.” ");
INSERT INTO swef_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose svarade: ”Men om de inte tror mig och inte lyssnar på mina ord utan säger: Herren har inte uppenbarat sig för dig?” ");
INSERT INTO swef_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Då sade Herren till honom: ”Vad har du i handen?” ");
INSERT INTO swef_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Han svarade: ”En stav.” Han sade: ”Kasta den på marken!” När han kastade den på marken förvandlades den till en orm, och Mose flydde för den. ");
INSERT INTO swef_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Men Herren sade till Mose: ”Räck ut handen och ta den i stjärten.” Då räckte han ut handen och grep ormen, och den blev åter en stav i hans hand. ");
INSERT INTO swef_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Herren sade: ”Så ska de tro att Herren, deras fäders Gud, Abrahams Gud, Isaks Gud och Jakobs Gud, har uppenbarat sig för dig.” ");
INSERT INTO swef_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Herren sade sedan till honom: ”Stick in handen i din famn!” Han gjorde så, och när han drog ut den var handen vit som snö av spetälska. ");
INSERT INTO swef_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Sedan sade Gud: ”Stick tillbaka handen in i din famn!” Mose gjorde så, och när han drog ut den liknade den resten av hans kropp igen. ");
INSERT INTO swef_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Och Herren sade: ”Om de inte tror dig eller lyssnar till det första tecknet, så måste de tro på det andra tecknet. ");
INSERT INTO swef_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Men om de inte ens tror på dessa två tecken eller lyssnar till dina ord, ta då lite av Nilens vatten och häll ut det på torra marken. Då ska vattnet som du tog ur floden förvandlas till blod på torra marken.” ");
INSERT INTO swef_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Då sade Mose till Herren: ”Men Herre, jag är ingen ordets man, varken förr eller nu när du talat till din tjänare. Jag är trög i talet och har en trög tunga.” ");
INSERT INTO swef_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Herren sade till honom: ”Vem har gett människan munnen? Vem gör henne stum eller döv, seende eller blind? Är det inte jag, Herren? ");
INSERT INTO swef_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gå nu, jag ska vara med din mun och lära dig vad du ska säga.” ");
INSERT INTO swef_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Men Mose sade: ”Herre, jag ber dig: Sänd ditt budskap med vilken annan du vill.” ");
INSERT INTO swef_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Då upptändes Herrens vrede mot Mose och han sade: ”Har du inte din bror Aron, leviten? Jag vet att han kan tala. Och se, han är på väg ut för att möta dig, och när han får se dig ska han bli glad i sitt hjärta. ");
INSERT INTO swef_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Du ska tala till honom och lägga orden i hans mun. Och jag ska vara med din mun och hans mun, och jag ska lära er vad ni ska göra. ");
INSERT INTO swef_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Han ska tala i ditt ställe till folket. Han ska vara som din mun, och du ska vara som hans Gud. ");
INSERT INTO swef_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Och du ska ta den här staven i handen. Med den ska du göra dina tecken.” ");
INSERT INTO swef_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose återvände till sin svärfar Jetro och sade till honom: ”Låt mig vända tillbaka till mina bröder i Egypten för att se om de lever än.” Jetro sade till Mose: ”Gå i frid!” ");
INSERT INTO swef_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Och när Mose var i Midjan sade Herren till honom: ”Bege dig tillbaka till Egypten, för alla som ville ta ditt liv är döda.” ");
INSERT INTO swef_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Då tog Mose sin hustru och sina söner och satte dem på sin åsna och återvände till Egyptens land. Och Mose tog Guds stav i handen. ");
INSERT INTO swef_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Herren sade till Mose: ”När du kommer tillbaka till Egypten, se då till att du gör alla de under som jag gett dig makt att utföra inför farao. Men jag ska göra hans hjärta hårt så att han inte släpper folket. ");
INSERT INTO swef_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Du ska säga till farao: Så säger Herren: Israel är min förstfödde son, ");
INSERT INTO swef_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","och jag har sagt till dig: Släpp min son, så att han kan hålla gudstjänst åt mig. Men du vägrade att släppa honom, och därför ska jag döda din förstfödde son.” ");
INSERT INTO swef_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Under resan hände det vid en viloplats att Herren kom emot Mose och ville döda honom. ");
INSERT INTO swef_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Då tog Sippora en vass flintsten och skar bort sin sons förhud, och hon rörde vid Moses fötter med den och sade: ”Du är en blodsbrudgum för mig.” ");
INSERT INTO swef_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Och Herren lät honom vara. Det var med tanke på omskärelsen som hon sade ”blodsbrudgum”. ");
INSERT INTO swef_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Och Herren sade till Aron: ”Gå och möt Mose ute i öknen!” Han gav sig i väg och mötte Mose vid Guds berg, och han kysste honom. ");
INSERT INTO swef_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Och Mose berättade för Aron allt som Herren hade sagt när han sände honom och om alla tecken han befallt honom att göra. ");
INSERT INTO swef_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Sedan gick Mose och Aron och kallade samman alla de äldste bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Och Aron talade om allt som Herren hade sagt till Mose, och han gjorde tecknen inför folkets ögon. ");
INSERT INTO swef_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Då trodde folket, och när de hörde att Herren hade tagit sig an Israels barn och sett deras lidande, böjde de sig ner och tillbad. ");
INSERT INTO swef_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Därefter gick Mose och Aron till farao och sade: ”Så säger Herren, Israels Gud: Släpp mitt folk, så att de kan hålla högtid åt mig i öknen!” ");
INSERT INTO swef_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Men farao svarade: ”Vem är Herren? Skulle jag lyssna på honom och släppa Israel? Jag känner inte Herren, och jag tänker inte släppa Israel.” ");
INSERT INTO swef_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Då sade de: ”Hebreernas Gud har uppenbarat sig för oss. Låt oss få gå tre dagsresor in i öknen och offra åt Herren vår Gud, så att han inte kommer över oss med pest eller svärd.” ");
INSERT INTO swef_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Men kungen av Egypten sade till dem: ”Mose och Aron, varför lockar ni bort folket från deras arbete? Gå till era dagsverken!” ");
INSERT INTO swef_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Och farao fortsatte: ”Folket är redan nu många i landet. Ändå vill ni att de ska sluta med sina dagsverken!” ");
INSERT INTO swef_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Samma dag befallde farao slavdrivarna och folkets förmän: ");
INSERT INTO swef_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","”Ni ska inte ge dem halm till teglet som förut. Låt dem gå och skaffa halm själva. ");
INSERT INTO swef_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Men samma mängd tegel som de gjort förut ska ni kräva av dem, utan något avdrag. De är lata, därför ropar de: Låt oss gå och offra åt vår Gud! ");
INSERT INTO swef_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Man måste lägga hårt arbete på dessa människor, så att de har något att göra och inte lyssnar på lögner.” ");
INSERT INTO swef_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Då gick slavdrivarna och förmännen ut och sade till folket: ”Så säger farao: Jag ger er inte längre halm. ");
INSERT INTO swef_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gå själva och skaffa halm där ni hittar det. Men det blir inget avdrag i ert arbete.” ");
INSERT INTO swef_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Då spred sig folket över hela Egyptens land och samlade strå för att använda som halm. ");
INSERT INTO swef_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Slavdrivarna drev på dem och sade: ”Gör färdigt ert arbete, full kvot för varje dag, precis som när ni fick halm!” ");
INSERT INTO swef_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Och israeliternas förmän, de som faraos slavdrivare hade satt över dem, fick hugg och slag och man sade till dem: ”Varför har ni inte tillverkat full mängd tegel som förut, varken i går eller i dag?” ");
INSERT INTO swef_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Då kom israeliternas förmän och ropade till farao: ”Varför gör du så mot dina tjänare? ");
INSERT INTO swef_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ingen halm får dina tjänare, och ändå säger de åt oss att skaffa fram tegel. Se, dina tjänare får hugg och slag trots att skulden ligger hos ditt eget folk.” ");
INSERT INTO swef_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Men han svarade: ”Lata är ni, lata! Det är därför ni säger: Låt oss gå och offra åt Herren! ");
INSERT INTO swef_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nej, gå nu och arbeta! Någon halm ska ni inte få, men full mängd tegel ska ni ändå lämna.” ");
INSERT INTO swef_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israeliternas förmän insåg att de var illa ute, eftersom man hade sagt att de inte skulle få något avdrag i den dagliga tegelkvoten. ");
INSERT INTO swef_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","När de kom ut från farao träffade de Mose och Aron som stod där för att möta dem, ");
INSERT INTO swef_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","och de sade till dem: ”Må Herren se vad ni har gjort och döma er! Ni har fått farao och hans tjänare att avsky oss och satt svärd i deras hand så att de kan döda oss.” ");
INSERT INTO swef_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Då vände Mose sig på nytt till Herren och sade: ”Herre, varför har du handlat så illa mot detta folk? Varför sände du mig? ");
INSERT INTO swef_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ända sedan jag gick till farao för att tala i ditt namn har han gjort dem illa, och du har inte gjort någonting för att rädda ditt folk.” ");
INSERT INTO swef_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Men Herren sade till Mose: ”Nu ska du få se vad jag ska göra med farao. Min starka hand ska få honom att släppa dem, och min starka hand ska få honom att driva ut dem ur sitt land.” ");
INSERT INTO swef_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Och Gud sade till Mose: ”Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","För Abraham, Isak och Jakob visade jag mig som Gud den Allsmäktige, men under mitt namnHerren gjorde jag mig inte känd för dem. ");
INSERT INTO swef_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Jag upprättade också mitt förbund med dem och lovade att ge dem Kanaans land, det land där de bodde som främlingar. ");
INSERT INTO swef_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Och jag har nu hört Israels barn sucka över att egyptierna håller dem som slavar, och jag har kommit ihåg mitt förbund. ");
INSERT INTO swef_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Säg därför till Israels barn: Jag är Herren. Jag ska föra er ut från Egyptens tvångsarbete och rädda er från deras slaveri, och jag ska återlösa er med utsträckt arm och stora straffdomar. ");
INSERT INTO swef_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Och jag ska ta er till mitt folk och vara er Gud. Ni ska inse att jag är Herren er Gud, som för er ut från slavarbetet hos egyptierna. ");
INSERT INTO swef_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Och jag ska föra er till det land som jag med upplyft hand lovade ge till Abraham, Isak och Jakob. Jag ska ge er det som arvedel. Jag är Herren.” ");
INSERT INTO swef_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Allt detta talade Mose till Israels barn, men de lyssnade inte på honom på grund av sin otålighet och det hårda arbetet. ");
INSERT INTO swef_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Därefter sade Herren till Mose: ");
INSERT INTO swef_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","”Gå och säg till farao, kungen av Egypten, att han släpper Israels barn från sitt land.” ");
INSERT INTO swef_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Men Mose talade inför Herren och sade: ”Israels barn lyssnar ju inte på mig. Hur skulle då farao vilja lyssna på mig, jag som har oomskurna läppar?” ");
INSERT INTO swef_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Men Herren talade till Mose och Aron och befallde dem att säga till Israels barn och till farao, kungen av Egypten, att Israels barn skulle föras ut ur Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Detta var huvudmännen för deras familjer: Söner till Ruben, Israels förstfödde, var Henok och Pallu, Hesron och Karmi. Dessa var Rubens släkter. ");
INSERT INTO swef_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeons söner var Jemuel, Jamin, Ohad, Jakin, Sohar och Saul, den kananeiska kvinnans son. Dessa var Simeons släkter. ");
INSERT INTO swef_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Och detta är namnen på Levis söner enligt deras födelseordning: Gershon, Kehat och Merari. Levi blev 137 år. ");
INSERT INTO swef_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershons söner var Libni och Shimei efter deras släkter. ");
INSERT INTO swef_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehats söner var Amram, Jishar, Hebron och Ussiel. Kehat blev 133 år. ");
INSERT INTO swef_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meraris söner var Mahli och Mushi. Dessa var leviternas släkter enligt deras födelseordning. ");
INSERT INTO swef_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram tog sin fars syster Jokebed till hustru, och hon födde Aron och Mose. Amram blev 137 år. ");
INSERT INTO swef_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Jishars söner var Kora, Nefeg och Sikri. ");
INSERT INTO swef_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ussiels söner var Mishael, Elsafan och Sitri. ");
INSERT INTO swef_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron tog till hustru Amminadabs dotter Elisheba, syster till Nahshon, och hon födde Nadab och Abihu, Eleasar och Itamar. ");
INSERT INTO swef_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Koras söner var Assir, Elkana och Abiasaf. Dessa var koraiternas släkter. ");
INSERT INTO swef_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar, Arons son, tog en av Putiels döttrar till hustru, och hon födde Pinehas. Dessa var huvudmännen för leviternas familjer efter deras släkter. ");
INSERT INTO swef_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Det var till denne Aron och denne Mose som Herren hade sagt: ”För ut Israels barn ur Egyptens land efter deras häravdelningar.” ");
INSERT INTO swef_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Och det var de som talade med farao, kungen av Egypten, om att föra Israels barn ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Och Herren talade till Mose i Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Herren sade till honom: ”Jag är Herren. Säg till farao, kungen av Egypten, allt som jag säger till dig.” ");
INSERT INTO swef_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Men Mose sade inför Herren: ”Se, jag har oomskurna läppar. Hur skulle farao vilja lyssna på mig?” ");
INSERT INTO swef_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Men Herren sade till Mose: ”Se, jag sätter dig att vara som Gud för farao, och din bror Aron ska vara din profet. ");
INSERT INTO swef_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du ska tala allt jag befaller dig. Sedan ska din bror Aron tala med farao om att släppa Israels barn ut ur sitt land. ");
INSERT INTO swef_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Men jag ska förhärda faraos hjärta och göra många tecken och under i Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Farao kommer inte att lyssna på er, men jag ska lägga min hand på Egypten och föra mina härskaror, mitt folk, Israels barn, ut ur Egypten genom stora straffdomar. ");
INSERT INTO swef_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Och egyptierna ska inse att jag är Herren, när jag räcker ut min hand över Egypten och för Israels barn ut därifrån.” ");
INSERT INTO swef_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose och Aron gjorde så, de gjorde som Herren hade befallt dem. ");
INSERT INTO swef_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose var åttio år och Aron åttiotre när de talade med farao. ");
INSERT INTO swef_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Herren sade till Mose och Aron: ");
INSERT INTO swef_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","”När farao säger till er: Låt oss se något under! då ska du säga till Aron: Ta din stav och kasta den framför farao så ska den bli en stor orm.” ");
INSERT INTO swef_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mose och Aron gick till farao och gjorde som Herren hade befallt. Aron kastade sin stav framför farao och hans tjänare, och den blev en stor orm. ");
INSERT INTO swef_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Då kallade farao till sig sina vise män och trollkarlar, och även dessa, de egyptiska spåmännen, gjorde samma tecken genom sina magiska konster. ");
INSERT INTO swef_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Var och en kastade sin stav, och stavarna blev stora ormar. Men Arons stav slukade deras stavar. ");
INSERT INTO swef_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ändå förblev faraos hjärta hårt och han lyssnade inte på dem, precis som Herren hade sagt. ");
INSERT INTO swef_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Därefter sade Herren till Mose: ”Faraos hjärta är hårt, han vägrar att släppa folket. ");
INSERT INTO swef_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Men gå till honom på morgonen då han går ut till vattnet. Ställ dig i hans väg på stranden av Nilen och ta i din hand staven som förvandlades till en orm. ");
INSERT INTO swef_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Säg till honom: Herren, hebreernas Gud, har sänt mig till dig för att säga: Släpp mitt folk, så att de kan hålla gudstjänst åt mig i öknen. Men se, hittills har du inte velat lyssna. ");
INSERT INTO swef_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Därför säger Herren så: Genom detta ska du förstå att jag är Herren. Se, med staven som jag håller i handen ska jag slå Nilens vatten så att det förvandlas till blod. ");
INSERT INTO swef_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Fiskarna i floden ska dö, och Nilen ska stinka så att egyptierna inte kan dricka vattnet i floden.” ");
INSERT INTO swef_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Och Herren sade till Mose: ”Säg till Aron: Ta din stav och räck ut handen över Egyptens vatten, över dess strömmar, kanaler och sjöar och alla andra vattensamlingar, så ska de bli blod. Över hela Egyptens land ska det vara blod, både i träkärl och stenkärl.” ");
INSERT INTO swef_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose och Aron gjorde som Herren hade befallt. Han lyfte upp staven och slog vattnet i Nilen inför faraos och hans tjänares ögon. Då förvandlades allt vatten i floden till blod. ");
INSERT INTO swef_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Fiskarna i Nilen dog och floden stank så att egyptierna inte kunde dricka vattnet från floden. Det var blod i hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Men de egyptiska spåmännen gjorde samma tecken genom sina magiska konster. Och faraos hjärta förblev hårt så att han inte lyssnade på dem, precis som Herren hade sagt. ");
INSERT INTO swef_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao gick därifrån hem till sitt palats och brydde sig inte om det heller. ");
INSERT INTO swef_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Och i hela Egypten grävde man efter dricksvatten kring Nilen, eftersom vattnet i floden inte var drickbart. ");
INSERT INTO swef_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sedan gick det sju dagar efter att Herren hade slagit Nilen. ");
INSERT INTO swef_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Därefter sade Herren till Mose: ”Gå till farao och säg till honom: Så säger Herren: Släpp mitt folk, så att de kan hålla gudstjänst åt mig! ");
INSERT INTO swef_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Men om du vägrar att släppa dem, ska jag plåga hela ditt land med grodor. ");
INSERT INTO swef_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nilen ska vimla av grodor. De ska stiga upp och komma in i ditt hus, in i ditt sovrum och upp i din säng, in i dina tjänares hus och bland ditt folk och i dina bakugnar och baktråg. ");
INSERT INTO swef_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ja, på dig själv och ditt folk och alla dina tjänare ska grodorna hoppa upp.” ");
INSERT INTO swef_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Herren sade också till Mose: ”Säg till Aron: Räck ut handen med din stav över strömmarna, kanalerna och sjöarna och låt grodor stiga upp över Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Då räckte Aron ut handen över Egyptens vatten, och det kom upp grodor som täckte landet. ");
INSERT INTO swef_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Men spåmännen gjorde samma tecken genom sina magiska konster och lät grodor stiga upp över Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Då kallade farao till sig Mose och Aron och sade: ”Be till Herren att han tar bort grodorna från mig och mitt folk. Då ska jag släppa folket, så att de kan offra till Herren.” ");
INSERT INTO swef_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose sade till farao: ”Du ska få äran att bestämma när jag ska be för dig och dina tjänare och ditt folk, så att grodorna försvinner från dig och dina hus och bara finns kvar i Nilen.” ");
INSERT INTO swef_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Han svarade: ”I morgon.” Då sade Mose: ”Det ska bli som du har sagt, så att du förstår att ingen är som Herren vår Gud. ");
INSERT INTO swef_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Grodorna ska försvinna från dig och dina hus, från dina tjänare och ditt folk och bara finnas kvar i Nilen.” ");
INSERT INTO swef_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Därefter gick Mose och Aron ut från farao. Och Mose ropade till Herren om hjälp mot grodorna som han låtit komma över farao. ");
INSERT INTO swef_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Herren gjorde så som Mose hade begärt. Grodorna dog och försvann från husen, gårdarna och fälten. ");
INSERT INTO swef_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Man samlade ihop dem i hög på hög, och landet fylldes av stank. ");
INSERT INTO swef_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Men när farao såg att han fått lindring, förhärdade han sitt hjärta och lyssnade inte på dem, precis som Herren hade sagt. ");
INSERT INTO swef_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Sedan sade Herren till Mose: ”Säg till Aron: Räck ut din stav och slå stoftet på marken. Över hela Egyptens land ska då stoftet förvandlas till mygg.” ");
INSERT INTO swef_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","De gjorde så. Aron räckte ut sin hand med staven och slog i stoftet på marken, och det kom mygg på människor och boskap. Av allt stoft på marken blev det mygg i hela Egypten. ");
INSERT INTO swef_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Spåmännen tänkte då göra samma tecken genom sina magiska konster. De försökte få fram mygg, men de kunde inte. Och myggen kom på människor och boskap. ");
INSERT INTO swef_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Då sade spåmännen till farao: ”Det är Guds finger!” Men faraos hjärta förblev hårt och han lyssnade inte på dem, precis som Herren hade sagt. ");
INSERT INTO swef_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Herren sade till Mose: ”Träd fram inför farao tidigt på morgonen när han går ut till vattnet och säg till honom: Så säger Herren: Släpp mitt folk, så att de kan hålla gudstjänst åt mig! ");
INSERT INTO swef_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Om du inte släpper mitt folk ska jag sända flugsvärmar över dig och dina tjänare, ditt folk och dina hus. Egyptiernas hus ska fyllas av flugsvärmar, och även marken som de står på. ");
INSERT INTO swef_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Men den dagen ska jag göra ett undantag för landet Goshen där mitt folk bor. Det ska inte finnas några flugsvärmar där, för att du ska inse att jag, Herren, är här i landet. ");
INSERT INTO swef_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Jag ska göra skillnad mellan mitt folk och ditt. I morgon ska detta tecken inträffa.” ");
INSERT INTO swef_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Och Herren gjorde så. Stora flugsvärmar kom in i faraos och hans tjänares hus, och överallt i Egypten härjades landet av flugsvärmarna. ");
INSERT INTO swef_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Då kallade farao till sig Mose och Aron och sade: ”Gå och offra åt er Gud här i landet!” ");
INSERT INTO swef_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Men Mose svarade: ”Det skulle inte vara rätt att göra så, för vi offrar sådant åt Herren vår Gud som är avskyvärt för egyptierna. Om vi skulle offra sådant som egyptierna avskyr inför deras ögon skulle de säkert stena oss. ");
INSERT INTO swef_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Vi vill gå tre dagsresor ut i öknen och offra åt Herren vår Gud, så som han befaller oss.” ");
INSERT INTO swef_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Då sade farao: ”Jag släpper er så att ni kan offra åt Herren er Gud i öknen. Gå bara inte för långt bort. Be för mig!” ");
INSERT INTO swef_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose svarade: ”Ja, när jag kommer ut från dig ska jag be till Herren, att flugsvärmarna i morgon viker bort från farao, hans tjänare och hans folk. Men farao bör inte bedra oss igen och vägra släppa folket så att de kan offra åt Herren.” ");
INSERT INTO swef_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mose gick ut från farao och bad till Herren, ");
INSERT INTO swef_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","och Herren gjorde som Mose hade begärt. Han tog bort flugsvärmarna från farao, hans tjänare och hans folk, så att inte en enda fluga fanns kvar. ");
INSERT INTO swef_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Men farao förhärdade sitt hjärta den gången också och släppte inte folket. ");
INSERT INTO swef_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Herren sade till Mose: ”Gå till farao och säg till honom: Så säger Herren, hebreernas Gud: Släpp mitt folk, så att de kan hålla gudstjänst åt mig! ");
INSERT INTO swef_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","För om du vägrar släppa dem och fortfarande håller dem kvar, ");
INSERT INTO swef_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","se, då ska Herrens hand komma med en mycket svår pest över din boskap på marken: hästar, åsnor, kameler, kor och får. ");
INSERT INTO swef_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Men Herren ska göra skillnad mellan israeliternas boskap och egyptiernas, så att inget djur som tillhör Israels barn ska dö.” ");
INSERT INTO swef_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Herren bestämde en tid och sade: ”I morgon ska Herren göra detta i landet.” ");
INSERT INTO swef_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nästa dag gjorde Herren så, och all egyptiernas boskap dog. Men av israeliternas boskap dog inte ett enda djur. ");
INSERT INTO swef_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","När farao sände bud för att höra efter, se, då hade inte ett enda djur dött av Israels boskap. Men faraos hjärta förblev hårt och han släppte inte folket. ");
INSERT INTO swef_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Herren sade till Mose och Aron: ”Ta händerna fulla med sot ur smältugnen. Mose ska kasta upp det mot himlen inför faraos ögon. ");
INSERT INTO swef_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Det ska bli ett damm över hela Egyptens land, och det ska bli bölder som slår ut med blåsor på människor och boskap i hela Egypten.” ");
INSERT INTO swef_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Då tog de sot ur smältugnen och trädde fram inför farao. Mose kastade upp sotet mot himlen, och bölder slog ut med blåsor på människor och boskap. ");
INSERT INTO swef_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Och spåmännen kunde inte träda fram inför Mose för böldernas skull, för det var bölder på dem och på alla egyptier. ");
INSERT INTO swef_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Men Herren gjorde faraos hjärta hårt så att han inte lyssnade på dem, precis som Herren hade sagt till Mose. ");
INSERT INTO swef_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Därefter sade Herren till Mose: ”Stig upp tidigt på morgonen, träd fram inför farao och säg till honom: Så säger Herren, hebreernas Gud: Släpp mitt folk, så att de kan hålla gudstjänst åt mig. ");
INSERT INTO swef_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Annars ska jag den här gången sända alla mina plågor över dig själv, dina tjänare och ditt folk, så att du förstår att ingen är som jag på hela jorden. ");
INSERT INTO swef_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","För nu var jag nära att räcka ut min hand och slå dig och ditt folk med pest för att utrota dig från jorden. ");
INSERT INTO swef_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Men just därför lät jag dig uppstå, för att visa dig min makt och för att mitt namn skulle förkunnas över hela jorden. ");
INSERT INTO swef_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Om du fortsätter att lägga hinder i vägen för mitt folk och inte släpper dem, ");
INSERT INTO swef_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","se, då ska jag i morgon vid den här tiden sända ett hagel så tungt att inget liknande har hänt i Egypten från den dag det grundades ända tills nu. ");
INSERT INTO swef_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sänd därför ut folk och hämta in din boskap och allt annat du har ute på marken, för alla människor och all boskap som är ute på marken och inte har kommit under tak kommer att träffas av haglet och dödas.” ");
INSERT INTO swef_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Den av faraos tjänare som fruktade Herrens ord lät sina slavar och sin boskap söka skydd i husen, ");
INSERT INTO swef_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","men den som inte brydde sig om Herrens ord lät sina slavar och sin boskap bli kvar ute på marken. ");
INSERT INTO swef_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Herren sade till Mose: ”Lyft din hand mot himlen, så ska det falla hagel över hela Egypten, över människor och boskap och markens alla växter i Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Då räckte Mose upp sin stav mot himlen, och Herren lät det dundra och hagla och eld slog ner mot jorden. Så sände Herren hagel över Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Och det haglade och eld gick fram och tillbaka bland hagelskurarna. Haglet var så tungt att inget liknande hade hänt i hela Egyptens land sedan den tid då det blev befolkat. ");
INSERT INTO swef_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","I hela Egypten slog haglet ner allt som fanns på marken, både människor och djur. Det slog också ner markens alla växter och bröt sönder markens alla träd. ");
INSERT INTO swef_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Endast i landet Goshen, där Israels barn bodde, haglade det inte. ");
INSERT INTO swef_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Då sände farao bud efter Mose och Aron och sade till dem: ”Den här gången har jag syndat. Det är Herren som är rättfärdig, och jag och mitt folk har gjort orätt. ");
INSERT INTO swef_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Be till Herren, det är nog med Guds dunder och hagel. Jag ska släppa er, ni behöver inte bli kvar längre.” ");
INSERT INTO swef_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose svarade honom: ”När jag kommer ut ur staden ska jag sträcka mina händer mot Herren. Då ska dundret upphöra och haglet sluta, för att du ska inse att landet tillhör Herren. ");
INSERT INTO swef_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Men jag vet att du och dina tjänare ännu inte fruktar Herren Gud.” ");
INSERT INTO swef_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Det var lin och korn som slogs ner, för kornet hade gått i ax och linet stod i knopp. ");
INSERT INTO swef_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Men vetet och spältvetet slogs inte ner, eftersom de mognar senare. ");
INSERT INTO swef_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Sedan lämnade Mose farao och gick ut ur staden, och han räckte ut sina händer mot Herren. Då upphörde dundret och haglet, och regnet slutade strömma ner över jorden. ");
INSERT INTO swef_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Men när farao såg att regnet och haglet och dundret hade slutat, fortsatte han i sin synd och förhärdade sitt hjärta, både han och hans tjänare. ");
INSERT INTO swef_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Faraos hjärta förblev hårt och han släppte inte Israels barn, precis som Herren hade sagt genom Mose. ");
INSERT INTO swef_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Herren sade till Mose: ”Gå till farao, för jag har förhärdat hans och hans tjänares hjärtan för att göra dessa tecken mitt ibland dem, ");
INSERT INTO swef_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","så att du ska kunna berätta för dina barn och barnbarn vilka stora gärningar jag har utfört bland egyptierna och vilka tecken jag har gjort bland dem. Och ni ska inse att jag är Herren.” ");
INSERT INTO swef_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Då gick Mose och Aron till farao och sade till honom: ”Så säger Herren, hebreernas Gud: Hur länge ska du vägra ödmjuka dig inför mig? Släpp mitt folk så att de kan hålla gudstjänst åt mig! ");
INSERT INTO swef_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","För om du vägrar släppa mitt folk, se, då ska jag i morgon sända gräshoppor över ditt land. ");
INSERT INTO swef_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","De ska täcka marken så att man inte kan se den. Det sista som är kvar efter haglet ska de äta upp, och de ska gnaga av alla era träd som växer på marken. ");
INSERT INTO swef_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","De ska fylla dina hus och dina tjänares och alla egyptiernas hus, så att dina fäder och förfäder inte har sett något liknande från den dag de blev till på jorden ända till denna dag.” Sedan vände han sig om och gick ut från farao. ");
INSERT INTO swef_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Men faraos tjänare sade till honom: ”Hur länge ska den mannen få vara en snara för oss? Släpp männen så att de kan hålla gudstjänst åt Herren sin Gud. Förstår du fortfarande inte att Egypten går under?” ");
INSERT INTO swef_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Då hämtade man tillbaka Mose och Aron till farao, och han sade till dem: ”Gå och håll gudstjänst åt Herren er Gud! Men vilka är det som ska gå?” ");
INSERT INTO swef_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose svarade: ”Vi går både unga och gamla. Vi går med söner och döttrar, med får och kor, eftersom vi ska fira en Herrens högtid.” ");
INSERT INTO swef_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Då sade han till dem: ”Herren vare med er, lika visst som jag släpper er och era små barn! Se, ni har något ont i sikte. ");
INSERT INTO swef_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nej, ni män får ge er i väg och hålla gudstjänst åt Herren. Det var ju det ni bad om.” Och man drev ut dem från farao. ");
INSERT INTO swef_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Herren sade till Mose: ”Räck ut handen över Egypten, så att det kommer gräshoppor över Egyptens land och äter upp landets alla växter, allt som haglet lämnat kvar.” ");
INSERT INTO swef_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Då räckte Mose ut sin stav över Egyptens land, och Herren lät en östanvind blåsa över landet hela den dagen och natten. När det blev morgon förde östanvinden med sig gräshopporna. ");
INSERT INTO swef_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","De kom över hela Egypten och slog ner i stor mängd över hela Egyptens område. Så mycket gräshoppor hade aldrig förekommit och ska aldrig mer förekomma. ");
INSERT INTO swef_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","De täckte hela marken och landet blev mörkt. Och de åt upp landets alla växter, all frukt på träden och allt som haglet lämnat kvar. Inget grönt blev kvar på träden eller på markens växter i hela Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Då kallade farao snabbt till sig Mose och Aron och sade: ”Jag har syndat mot Herren er Gud och mot er. ");
INSERT INTO swef_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Men förlåt nu min synd den här enda gången och be till Herren er Gud att han bara tar bort denna dödliga plåga från mig.” ");
INSERT INTO swef_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Då gick han ut från farao och bad till Herren. ");
INSERT INTO swef_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Och Herren vände vinden och lät en mycket stark västanvind blåsa. Den tog tag i gräshopporna och kastade dem i Röda havet, så att inte en enda gräshoppa blev kvar inom hela Egyptens område. ");
INSERT INTO swef_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Men Herren gjorde faraos hjärta hårt, och han släppte inte Israels barn. ");
INSERT INTO swef_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Herren sade till Mose: ”Räck upp handen mot himlen, så ska det komma ett mörker över Egypten, ett mörker som man kan ta på.” ");
INSERT INTO swef_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Då räckte Mose upp handen mot himlen, och ett tjockt mörker kom över hela Egyptens land i tre dagar. ");
INSERT INTO swef_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ingen såg den andre och ingen steg upp från sin plats på tre dagar. Men där Israels barn bodde var det ljust överallt. ");
INSERT INTO swef_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Då kallade farao till sig Mose och sade: ”Gå och håll gudstjänst åt Herren. Bara era får och kor måste lämnas kvar. Till och med era barn får gå med er.” ");
INSERT INTO swef_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Men Mose sade: ”Du måste låta oss få slaktoffer och brännoffer att offra åt Herren vår Gud. ");
INSERT INTO swef_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Även vår boskap måste gå med oss, och inte en klöv får bli kvar. Vi tar från vår boskap när vi tjänar Herren vår Gud. Och innan vi är där vet vi inte själva vad vi ska offra åt Herren.” ");
INSERT INTO swef_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Men Herren gjorde faraos hjärta hårt så att han inte ville släppa dem. ");
INSERT INTO swef_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao sade till honom: ”Gå bort från mig! Och akta dig för att komma inför mina ögon igen. Den dag du kommer inför mina ögon ska du dö.” ");
INSERT INTO swef_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose svarade: ”Som du säger: Jag ska aldrig mer komma inför dina ögon.” ");
INSERT INTO swef_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Herren sade till Mose: ”En plåga till ska jag sända över farao och Egypten, och sedan ska han släppa er. Han ska till och med driva ut er härifrån när han släpper er. ");
INSERT INTO swef_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Säg därför till folket att alla, både män och kvinnor, ska be sina grannar om föremål av silver och guld.” ");
INSERT INTO swef_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Och Herren gjorde egyptierna vänligt sinnade mot folket. Dessutom hade mannen Mose stort anseende i Egyptens land, både hos faraos tjänare och hos folket. ");
INSERT INTO swef_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mose sade: ”Så säger Herren: Vid midnatt ska jag gå fram genom Egypten. ");
INSERT INTO swef_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Då ska allt förstfött i Egyptens land dö, från den förstfödde hos farao som sitter på tronen ända till den förstfödde hos slavinnan vid handkvarnen, och även allt förstfött bland boskapen. ");
INSERT INTO swef_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ett högt sorgerop ska höras i hela Egypten, ett sådant som aldrig har hörts och aldrig mer kommer att höras. ");
INSERT INTO swef_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Men inte en hund ska gläfsa mot någon av Israels barn, vare sig mot människor eller boskap. Ni ska då inse att Herren gör skillnad mellan Egypten och Israel. ");
INSERT INTO swef_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Då ska alla dina tjänare komma ner till mig och buga sig för mig och säga: Ge dig av, du själv och allt folket som följer dig! Sedan ska jag dra ut.” Och Mose gick ut från farao, upptänd av vrede. ");
INSERT INTO swef_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Men Herren sade till Mose: ”Farao kommer inte att lyssna på er, detta för att jag ska göra många under i Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose och Aron gjorde alla dessa under inför farao, men Herren gjorde faraos hjärta hårt så att han inte släppte Israels barn från sitt land. ");
INSERT INTO swef_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Herren sade till Mose och Aron i Egyptens land: ");
INSERT INTO swef_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","”Denna månad ska vara den främsta hos er. Den ska hos er vara den första av årets månader. ");
INSERT INTO swef_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Säg till hela Israels församling: På tionde dagen i denna månad ska varje familjefar ta sig ett lamm, så att varje hushåll får ett lamm. ");
INSERT INTO swef_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Men om hushållet är för litet för ett lamm, ska familjefadern och hans närmaste granne ta ett lamm tillsammans efter antalet personer. För varje lamm ska ni beräkna ett visst antal, efter vad var och en äter. ");
INSERT INTO swef_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ett felfritt, årsgammalt lamm av hankön ska ni välja ut och ta antingen från fåren eller getterna. ");
INSERT INTO swef_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ni ska förvara det till den fjortonde dagen i denna månad. Då ska hela Israels församlade menighet slakta det i skymningen. ");
INSERT INTO swef_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Och man ska ta av blodet och stryka det på båda dörrposterna och på övre dörrträet i husen där man äter det. ");
INSERT INTO swef_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Köttet ska ätas samma natt. Det ska vara stekt över eld och ätas med osyrat bröd och bittra örter. ");
INSERT INTO swef_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ni ska inte äta något av det rått eller kokt i vatten, utan det ska vara stekt över eld med huvud, fötter och innanmäte. ");
INSERT INTO swef_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ni ska inte lämna kvar något av köttet till morgonen. Om något av det skulle bli över till morgonen, ska ni bränna upp det i eld. ");
INSERT INTO swef_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Så ska det ätas: Ni ska ha bältet om livet, skor på fötterna och stav i handen. Och ni ska äta det snabbt. Detta är Herrens påsk. ");
INSERT INTO swef_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Den natten ska jag gå fram genom Egyptens land och slå allt förstfött i Egypten, både människor och boskap. Och jag ska hålla dom över Egyptens alla gudar. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Blodet ska vara ett tecken för er på husen där ni är. När jag ser blodet ska jag gå förbi er. Ingen straffdom ska drabba er med fördärv när jag slår Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Denna dag ska ni ha till minnesdag och fira som en Herrens högtid. Som en evig stadga ska ni fira den från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","I sju dagar ska ni äta osyrat bröd. Redan den första dagen ska ni skaffa bort all surdeg ur era hus, för var och en som äter något syrat från den första dagen till den sjunde ska utrotas ur Israel. ");
INSERT INTO swef_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","På första dagen ska ni hålla en helig sammankomst. Och på sjunde dagen ska ni hålla en helig sammankomst. Under de dagarna ska ni inte utföra något arbete utom det som hör till matlagningen för var och en. Det och inget annat får göras. ");
INSERT INTO swef_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ni ska fira det osyrade brödets högtid därför att jag just den dagen förde era härskaror ut ur Egyptens land. Det ska vara en evig stadga för er att fira denna dag från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Från kvällen den fjortonde dagen i första månaden ska ni äta osyrat bröd ända till kvällen den tjugoförsta dagen i månaden. ");
INSERT INTO swef_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Under sju dagar får ingen surdeg finnas i era hus. Var och en som äter något syrat ska utrotas ur Israels församling, vare sig han är främling eller infödd. ");
INSERT INTO swef_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Inget syrat ska ni äta. Var ni än bor ska ni äta osyrat bröd.” ");
INSERT INTO swef_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mose kallade till sig alla de äldste i Israel och sade till dem: ”Gå och hämta ett lamm för varje hushåll och slakta påskalammet! ");
INSERT INTO swef_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ta en knippa isop och doppa den i blodet som är i skålen och stryk blodet på det övre dörrträet och de båda dörrposterna. Ingen av er får gå ut genom dörren till sitt hus före morgonen, ");
INSERT INTO swef_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","för Herren ska gå fram för att slå Egypten. Men när han ser blodet på det övre dörrträet och de båda dörrposterna ska han gå förbi dörren och inte låta fördärvaren komma in i era hem och slå er. ");
INSERT INTO swef_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Detta ska ni hålla. Det ska vara en stadga för dig och dina barn för evigt. ");
INSERT INTO swef_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Och när ni kommer in i det land som Herren ska ge er, som han har sagt, ska ni fira denna gudstjänst. ");
INSERT INTO swef_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","När era barn frågar er: Vad betyder den här gudstjänsten? ");
INSERT INTO swef_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ska ni svara: Det är ett påskoffer åt Herren, för han gick förbi Israels barns hus i Egypten. När han slog egyptierna skonade han våra hus.” Då böjde folket sig ner och tillbad. ");
INSERT INTO swef_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Och Israels barn gick i väg och gjorde så som Herren hade befallt Mose och Aron. ");
INSERT INTO swef_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Vid midnatt slog Herren allt förstfött i Egyptens land, från den förstfödde hos farao som satt på tronen till den förstfödde hos fången i fängelset. Han slog allt förstfött bland boskapen. ");
INSERT INTO swef_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Då steg farao upp på natten, liksom alla hans tjänare och alla egyptier. Och det hördes ett högt sorgerop i Egypten, för det fanns inte ett hem där det inte låg någon död. ");
INSERT INTO swef_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao kallade på natten till sig Mose och Aron och sade: ”Bryt upp och dra ut från mitt folk, ni själva och Israels barn! Gå i väg och håll gudstjänst som ni har sagt. ");
INSERT INTO swef_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ta med era får och kor också, som ni har sagt, och välsigna även mig när ni drar ut.” ");
INSERT INTO swef_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egyptierna skyndade på folket för att få dem ut ur landet fort, för de sade: ”Annars dör vi allihop.” ");
INSERT INTO swef_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Och folket tog med sig sin deg, innan den ännu hade blivit syrad. De tog sina baktråg, lindade in dem i mantlarna och bar dem på sina axlar. ");
INSERT INTO swef_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israels barn hade också gjort som Mose sagt: De hade begärt föremål av silver och guld och även kläder från egyptierna. ");
INSERT INTO swef_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Och Herren hade gjort egyptierna vänligt sinnade mot israeliterna så att de gav dem vad de begärde. Så tog de byte från egyptierna. ");
INSERT INTO swef_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israels barn bröt upp och drog från Raamses till Suckot, omkring 600 000 man till fots förutom barn. ");
INSERT INTO swef_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","En stor blandad folkhop drog upp med dem, och dessutom en mycket stor hjord av får och kor. ");
INSERT INTO swef_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Av degen som de fick med sig från Egypten bakade de osyrade brödkakor. Den hade inte hunnit bli syrad, eftersom de hade drivits ut ur Egypten utan att få dröja. De hade inte heller kunnat göra i ordning någon reskost åt sig. ");
INSERT INTO swef_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Den tid som Israels barn hade bott i Egypten var 430 år. ");
INSERT INTO swef_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Just den dag då de 430 åren hade gått drog alla Herrens härskaror ut ur Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","En vakandets natt var det för Herren när han förde dem ut ur Egyptens land. Just denna Herrens natt ska alla Israels barn vaka, släkte efter släkte. ");
INSERT INTO swef_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Herren sade till Mose och Aron: ”Detta är stadgan om påskalammet: Ingen utlänning får äta av det, ");
INSERT INTO swef_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","men en slav som är köpt för pengar får äta av det efter att du omskurit honom. ");
INSERT INTO swef_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ingen som bor hos er tillfälligt och ingen daglönare får äta av det. ");
INSERT INTO swef_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","I ett och samma hus ska det ätas. Du får inte föra ut något av köttet ur huset, och ni får inte krossa något ben på det. ");
INSERT INTO swef_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hela Israels församling ska hålla detta. ");
INSERT INTO swef_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Om en främling som bor hos dig vill fira Herrens påskhögtid, ska alla av manligt kön hos honom omskäras. Sedan får han komma och fira den, och han ska då vara som en infödd. Men ingen oomskuren får äta påskalammet. ");
INSERT INTO swef_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","En och samma lag ska gälla för den infödde som för främlingen som bor mitt ibland er.” ");
INSERT INTO swef_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Alla Israels barn gjorde så. De gjorde som Herren hade befallt Mose och Aron. ");
INSERT INTO swef_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Just på den dagen förde Herren Israels barn ut ur Egyptens land efter deras härskaror. ");
INSERT INTO swef_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","”Helga allt förstfött åt mig. Allt hos Israels barn som öppnar moderlivet, både av människor och boskap, tillhör mig.” ");
INSERT INTO swef_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose sade till folket: ”Kom ihåg den här dagen då ni drog ut ur Egypten, ur träldomshuset. Med stark hand förde Herren ut er därifrån, och därför får inget syrat ätas. ");
INSERT INTO swef_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Den här dagen i månaden Aviv drar ni ut. ");
INSERT INTO swef_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Och när Herren låter dig komma in i kananeernas, hetiternas, amoreernas, hiveernas och jebusiternas land som han med ed har lovat dina fäder att ge dig, ett land som flödar av mjölk och honung, då ska du fira denna gudstjänst i den här månaden. ");
INSERT INTO swef_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","I sju dagar ska du äta osyrat bröd, och på sjunde dagen ska en Herrens högtid firas. ");
INSERT INTO swef_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Under de sju dagarna ska man äta osyrat bröd. Inget syrat ska man då se hos dig, och det får inte finnas surdeg hos dig någonstans i landet. ");
INSERT INTO swef_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","På den dagen ska du förklara för din son: Detta gör jag på grund av det som Herren gjorde för mig när jag drog ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Det ska vara som ett tecken för dig på din hand och som en påminnelse på din panna, att Herrens undervisning ska vara i din mun, för med stark hand har Herren fört dig ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Denna stadga ska du hålla på den bestämda tiden år efter år. ");
INSERT INTO swef_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","När Herren låter dig komma in och ger dig kananeernas land, som han med ed har lovat dig och dina fäder, ");
INSERT INTO swef_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","då ska du överlämna till Herren allt som öppnar moderlivet. Allt förstfött av hankön bland din boskap ska tillhöra Herren. ");
INSERT INTO swef_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Men allt som öppnar moderlivet bland åsnor ska du lösa ut med ett får, och om du inte vill lösa det ska du krossa nacken på det. Varje förstfödd son ska du lösa ut. ");
INSERT INTO swef_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","När din son i framtiden frågar dig vad det betyder, ska du svara honom: Med stark hand förde Herren oss ut ur Egypten, ur träldomshuset. ");
INSERT INTO swef_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Eftersom farao envist vägrade släppa oss, dödade Herren allt förstfött i Egyptens land, från det förstfödda bland människor till det förstfödda bland boskap. Därför offrar jag åt Herren allt av hankön som öppnar moderlivet, och varje förstfödd son löser jag ut. ");
INSERT INTO swef_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Detta ska vara som ett tecken på din hand och en påminnelse på din panna, eftersom Herren med stark hand förde oss ut ur Egypten.” ");
INSERT INTO swef_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","När farao hade släppt folket förde Gud dem inte genom filisteernas land, fast det var den närmaste vägen. Gud tänkte nämligen att folket kunde ångra sig och vända tillbaka till Egypten när de fick se krig hota. ");
INSERT INTO swef_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Därför lät han folket ta en omväg genom öknen mot Röda havet. Israels barn drog ut ur Egypten i ordnade grupper. ");
INSERT INTO swef_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Och Mose tog med sig Josefs ben, för Josef hade tagit en ed av Israels barn och sagt: ”När Gud ser till er, ta då med mina ben härifrån.” ");
INSERT INTO swef_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","De bröt upp från Suckot och slog läger i Etam vid utkanten av öknen. ");
INSERT INTO swef_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Herren gick framför dem, om dagen i en molnpelare för att visa dem vägen och om natten i en eldpelare för att ge dem ljus. På så sätt kunde de vandra både dag och natt. ");
INSERT INTO swef_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Molnpelaren upphörde inte att gå framför folket på dagen och inte heller eldpelaren på natten. ");
INSERT INTO swef_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","”Säg till Israels barn att de vänder och slår läger framför Pi-Hahirot, mellan Migdol och havet. Mitt emot Baal-Sefon ska ni slå läger vid havet. ");
INSERT INTO swef_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao kommer att säga att Israels barn har gått vilse i landet, instängda av öknen. ");
INSERT INTO swef_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Och jag ska göra faraos hjärta hårt så att han förföljer dem. Jag ska förhärliga mig på farao och hela hans här, så att egyptierna förstår att jag är Herren.” Och de gjorde så. ");
INSERT INTO swef_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","När man berättade för kungen i Egypten att folket hade flytt, förändrades faraos och hans tjänares inställning till folket och de sade: ”Vad har vi gjort? Vi släppte israeliterna så att de inte tjänar oss mer!” ");
INSERT INTO swef_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Och han lät spänna för sina vagnar och tog med sig sitt folk. ");
INSERT INTO swef_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Han tog sexhundra utvalda vagnar och alla andra vagnar som fanns i Egypten och ledande krigsmän på var och en av dem. ");
INSERT INTO swef_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Och Herren gjorde faraos, den egyptiske kungens, hjärta hårt så att han förföljde Israel när hela folket drog ut med upplyft hand. ");
INSERT INTO swef_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Egyptierna, alla faraos hästar, vagnar och ryttare och hela hans här, förföljde dem och hann upp dem där de slagit läger vid havet nära Pi-Hahirot, mitt emot Baal-Sefon. ");
INSERT INTO swef_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","När farao närmade sig, lyfte Israels barn blicken och fick se egyptierna som kom tågande efter dem. Israels barn blev mycket förskräckta och ropade till Herren. ");
INSERT INTO swef_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Och de sade till Mose: ”Fanns det inga gravar i Egypten, eftersom du har fört oss hit för att dö i öknen? Vad har du gjort mot oss? Varför förde du oss ut ur Egypten? ");
INSERT INTO swef_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Var det inte det vi sade till dig i Egypten? Vi sade: Låt oss vara, så att vi får tjäna egyptierna. Det hade varit bättre för oss att tjäna egyptierna än att dö här i öknen.” ");
INSERT INTO swef_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose svarade folket: ”Var inte rädda! Stanna upp och bevittna den frälsning som Herren i dag ska ge er. Så som ni ser egyptierna i dag ska ni aldrig någonsin se dem igen. ");
INSERT INTO swef_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Herren ska strida för er, och ni ska hålla er stilla. ");
INSERT INTO swef_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Sedan sade Herren till Mose: ”Varför ropar du till mig? Säg till Israels barn att de ska dra vidare. ");
INSERT INTO swef_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lyft din stav och räck ut handen över havet och klyv det, så att Israels barn kan gå rakt genom havet på torr mark. ");
INSERT INTO swef_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Se, jag ska förhärda egyptiernas hjärtan så att de följer efter dem, och jag ska förhärliga mig på farao och hela hans här, på hans vagnar och ryttare. ");
INSERT INTO swef_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egyptierna ska inse att jag är Herren när jag förhärligar mig på farao, på hans vagnar och ryttare.” ");
INSERT INTO swef_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Guds ängel, som hade gått framför Israels här, flyttade sig nu och gick bakom dem. Molnpelaren som hade gått framför dem flyttade sig och tog plats bakom dem, ");
INSERT INTO swef_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","så att den kom mellan egyptiernas här och israeliternas. Molnet var där med mörker, samtidigt som det lyste upp natten. Under hela natten kunde den ena hären inte komma nära den andra. ");
INSERT INTO swef_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Och Mose räckte ut handen över havet, och Herren drev då undan havet genom en stark östanvind som blåste hela natten. Han gjorde havet till torrt land, och vattnet klövs itu. ");
INSERT INTO swef_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israels barn gick rakt genom havet på torr mark, medan vattnet stod som en mur till höger och vänster om dem. ");
INSERT INTO swef_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Och egyptierna förföljde dem, alla faraos hästar, vagnar och ryttare, och kom efter dem ut till mitten av havet. ");
INSERT INTO swef_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Men vid morgonväkten såg Herren ner från pelaren av eld och moln på egyptiernas här och förvirrade den. ");
INSERT INTO swef_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Han lät hjulen på deras vagnar lossna så att det blev svårt för dem att komma fram. Då sade egyptierna: ”Vi måste fly för Israel! Herren strider för dem mot Egypten.” ");
INSERT INTO swef_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Och Herren sade till Mose: ”Räck ut handen över havet så att vattnet vänder tillbaka över egyptierna, över deras vagnar och ryttare.” ");
INSERT INTO swef_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Då räckte Mose ut handen över havet, och mot morgonen återvände vattnet till sin vanliga plats. Egyptierna flydde men möttes av det, och Herren strödde ut dem mitt i havet. ");
INSERT INTO swef_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Vattnet vände tillbaka och täckte vagnarna och ryttarna och hela faraos här som hade kommit efter dem ut i havet. Inte en enda av dem kom undan. ");
INSERT INTO swef_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Men Israels barn gick rakt genom havet på torr mark, och vattnet stod som en mur till höger och till vänster om dem. ");
INSERT INTO swef_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Så frälste Herren den dagen Israel från egyptiernas hand, och Israel såg egyptierna ligga döda på havets strand. ");
INSERT INTO swef_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","När Israels barn såg den stora makt som Herren hade visat mot egyptierna, fruktade folket Herren. Och de trodde på Herren och på hans tjänare Mose. ");
INSERT INTO swef_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Då sjöng Mose och Israels barn denna lovsång till Herren: ”Jag vill lovsjunga Herren, högt är han upphöjd. Häst och ryttare störtade han i havet. ");
INSERT INTO swef_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Herren är min styrka och min lovsång, han blev min frälsning. Han är min Gud, jag vill prisa honom, min fars Gud, jag vill upphöja honom. ");
INSERT INTO swef_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Herren är en stridsman, Herren är hans namn. ");
INSERT INTO swef_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Faraos vagnar och här kastade han i havet, hans utvalda krigsmän dränktes i Röda havet. ");
INSERT INTO swef_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Djupen täckte dem, de sjönk till botten som stenar. ");
INSERT INTO swef_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Din högra hand, Herre, är härlig i sin kraft, din högra hand, Herre, krossade fienden. ");
INSERT INTO swef_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I din stora höghet slog du ner dina motståndare, du släppte lös din glödande vrede, den förtärde dem som strå. ");
INSERT INTO swef_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Av din näsas fnysning dämdes vattnen upp, böljorna reste sig som en mur, vattenströmmarna stelnade i havets djup. ");
INSERT INTO swef_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Fienden sade: Jag ska förfölja dem, jag ska hinna upp dem, jag ska dela upp bytet, släcka min hämnd på dem. Jag ska dra mitt svärd, min hand ska förgöra dem. ");
INSERT INTO swef_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Du andades på dem och havet täckte dem, de sjönk som bly i de väldiga vattnen. ");
INSERT INTO swef_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Vem är som du bland gudarna, Herre? Vem är som du, härlig i helighet, värdig fruktan och lovsång, du som gör under? ");
INSERT INTO swef_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Du sträckte ut din högra hand, och jorden slukade dem. ");
INSERT INTO swef_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du ledde med din nåd det folk som du återlöst, du förde dem med din makt till din heliga boning. ");
INSERT INTO swef_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Folken hörde det och darrade, ångest grep Filisteens invånare. ");
INSERT INTO swef_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Då blev Edoms furstar förskräckta, Moabs hövdingar bävade, Kanaans alla invånare smälte av ångest. ");
INSERT INTO swef_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Över dem föll skräck och fruktan. Inför din mäktiga arm stod de som förstenade tills ditt folk drog förbi, Herre, tills folket drog förbi som du hade köpt. ");
INSERT INTO swef_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Du för dem in och planterar dem på din arvedels berg, den plats som du gjort till din boning, Herre, den helgedom, Herre, som dina händer berett. ");
INSERT INTO swef_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Herren ska regera alltid och för evigt.” ");
INSERT INTO swef_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","När Faraos hästar med vagnar och ryttare hade kommit ner i havet, lät Herren havets vatten vända tillbaka över dem. Men Israels barn gick rakt genom havet på torr mark. ");
INSERT INTO swef_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Och profetissan Mirjam, Arons syster, tog en tamburin i handen, och alla kvinnorna följde henne med tamburiner och dansade. ");
INSERT INTO swef_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mirjam sjöng för dem: ”Lovsjung Herren, högt är han upphöjd! Häst och ryttare störtade han i havet.” ");
INSERT INTO swef_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Därefter lät Mose Israels barn bryta upp från Röda havet, och de drog ut i öknen Shur. Under tre dagar vandrade de i öknen utan att finna vatten. ");
INSERT INTO swef_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sedan kom de till Mara, men de kunde inte dricka vattnet där, eftersom det var bittert. Därför kallade de platsen Mara. ");
INSERT INTO swef_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Då klagade folket mot Mose och sade: ”Vad ska vi dricka?” ");
INSERT INTO swef_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Men han ropade till Herren, och Herren visade honom ett visst slags trä. Han kastade det i vattnet och då blev vattnet sött. Där förelade han folket lag och rätt, och där satte han det på prov. ");
INSERT INTO swef_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Han sade: ”Om du hör Herren din Guds röst och noga lyssnar till hans bud och håller alla hans stadgar, ska jag inte lägga på dig någon av de sjukdomar som jag lade på egyptierna, för jag är Herren din läkare. ");
INSERT INTO swef_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sedan kom de till Elim, där det fanns tolv vattenkällor och sjuttio palmer. Och de slog läger där vid vattnet. ");
INSERT INTO swef_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Hela Israels församling bröt sedan upp från Elim och kom på femtonde dagen i andra månaden efter sitt uttåg ur Egypten fram till öknen Sin, mellan Elim och Sinai. ");
INSERT INTO swef_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Och hela Israels församling klagade mot Mose och Aron i öknen ");
INSERT INTO swef_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","och sade till dem: ”Om vi ändå hade fått dö för Herrens hand i Egypten! Där satt vi vid köttgrytorna och åt oss mätta. Men ni har fört oss hit ut i öknen för att låta hela församlingen dö av svält.” ");
INSERT INTO swef_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Då sade Herren till Mose: ”Se, jag ska låta det regna bröd från himlen åt er. Folket ska gå ut och samla så mycket de behöver för varje dag. Så ska jag pröva dem, om de vill vandra efter min lag eller inte. ");
INSERT INTO swef_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","När de på sjätte dagen tillagar vad de har fört hem, ska det vara dubbelt så mycket som de annars samlar varje dag.” ");
INSERT INTO swef_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Och Mose och Aron sade till alla Israels barn: ”I kväll kommer ni att förstå att det är Herren som har fört er ut ur Egyptens land, ");
INSERT INTO swef_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","och i morgon ska ni se Herrens härlighet. Herren har hört hur ni klagar mot honom. Vilka är vi, att ni skulle klaga mot oss?” ");
INSERT INTO swef_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Och Mose fortsatte: ”Herren ger er i kväll kött att äta och i morgon bröd att mätta er med, för Herren har hört hur ni klagar mot honom. Men vilka är vi? Ni klagar inte mot oss utan mot Herren.” ");
INSERT INTO swef_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Därefter sade Mose till Aron: ”Säg till hela Israels församling: Träd fram inför Herren, för han har hört hur ni klagar.” ");
INSERT INTO swef_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","När sedan Aron hade talat till hela Israels församling, vände de sig mot öknen. Och se, då visade sig Herrens härlighet i molnskyn. ");
INSERT INTO swef_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","”Jag har hört hur Israels barn klagar. Säg till dem: I skymningen ska ni få kött att äta och i morgon bröd att mätta er med. Då ska ni inse att jag är Herren er Gud.” ");
INSERT INTO swef_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","På kvällen kom vaktlar och täckte lägret, och nästa morgon låg det dagg runt omkring lägret. ");
INSERT INTO swef_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","När daggen hade försvunnit, se, då låg det på marken ute i öknen något fint som fjäll, något fint som liknade rimfrost. ");
INSERT INTO swef_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israels barn såg det, och eftersom de inte visste vad det var frågade de varandra: ”Vad är det här?” Mose sade till dem: ”Detta är brödet som Herren har gett er att äta. ");
INSERT INTO swef_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Och detta är vad Herren har befallt: Var och en ska samla så mycket av det som han behöver till mat. En gomer per person ska ni ta, efter antalet av ert husfolk. Var och en ska ta åt dem som han har i sitt tält.” ");
INSERT INTO swef_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israels barn gjorde så, den ene samlade mer och den andre mindre. ");
INSERT INTO swef_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Men när de mätte upp det med gomermåttet hade den som samlat mycket ingenting över, och den som samlat lite saknade ingenting. Var och en hade samlat så mycket som han behövde till mat. ");
INSERT INTO swef_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Och Mose sade till dem: ”Ingen får lämna kvar något av det till i morgon.” ");
INSERT INTO swef_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Men de lydde inte Mose, utan vissa sparade något av det till nästa morgon. Då växte det maskar i det och det luktade illa. Och Mose blev förargad på dem. ");
INSERT INTO swef_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","De samlade sedan in av mannat varje morgon, var och en så mycket han behövde till mat. Men när solhettan kom smälte det bort. ");
INSERT INTO swef_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","På sjätte dagen hade de samlat in dubbelt så mycket av brödet, två gomer för var och en. Folkets alla furstar kom och berättade det för Mose. ");
INSERT INTO swef_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Då sade han till dem: ”Detta är vad Herren sagt. I morgon är det sabbatsvila, en sabbat helgad åt Herren. Baka nu det ni vill baka och koka det ni vill koka. Men allt som blir över ska ni spara åt er till i morgon.” ");
INSERT INTO swef_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Och de sparade det till nästa morgon som Mose hade befallt, och nu luktade det inte illa och det kom inga maskar i det. ");
INSERT INTO swef_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose sade: ”Ät det i dag, för i dag är det Herrens sabbat och då kan ni inte finna något på marken. ");
INSERT INTO swef_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","I sex dagar ska ni samla in av det, men på sjunde dagen är det sabbat. Då kan ni inte hitta något.” ");
INSERT INTO swef_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ändå gick några ut på sjunde dagen för att samla in, men de fann ingenting. ");
INSERT INTO swef_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Då sade Herren till Mose: ”Hur länge ska ni vägra att hålla mina bud och befallningar? ");
INSERT INTO swef_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Se, Herren har gett er sabbaten. Därför ger han er på sjätte dagen bröd för två dagar. Stanna därför hemma, var och en hos sig. Gå inte hemifrån på sjunde dagen.” ");
INSERT INTO swef_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Alltså höll folket sabbat på sjunde dagen. ");
INSERT INTO swef_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israels barn kallade det manna. Det liknade korianderfrö och var vitt och smakade som tunna kakor med honung. ");
INSERT INTO swef_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Och Mose sade: ”Detta är vad Herren har befallt: Spara en gomer av det, så att era efterkommande får se det bröd jag gav er att äta i öknen när jag förde er ut ur Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Till Aron sade Mose: ”Ta ett kärl och lägg en gomer manna i det och ställ det inför Herren. Det ska bevaras för kommande släkten.” ");
INSERT INTO swef_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aron gjorde som Herren hade befallt Mose. Han ställde det framför vittnesbördet för att förvaras där. ");
INSERT INTO swef_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Och Israels barn åt manna i fyrtio år, ända tills de kom till bebott land. De åt manna tills de kom till gränsen av Kanaans land. ");
INSERT INTO swef_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","En gomer är en tiondels efa. ");
INSERT INTO swef_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","På Herrens befallning bröt hela Israels församling upp från öknen Sin och drog från lägerplats till lägerplats, och de slog läger i Refidim. Där hade folket inget vatten att dricka. ");
INSERT INTO swef_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Då grälade folket på Mose och sade: ”Ge oss vatten att dricka!” Mose svarade dem: ”Varför grälar ni med mig? Varför sätter ni Herren på prov?” ");
INSERT INTO swef_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Men folket törstade efter vatten, och de klagade på Mose och sade: ”Varför har du fört oss ut ur Egypten, så att vi och våra barn och vår boskap måste dö av törst?” ");
INSERT INTO swef_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Då ropade Mose till Herren och sade: ”Vad ska jag göra med det här folket? Snart stenar de mig!” ");
INSERT INTO swef_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Herren svarade Mose: ”Ta med dig några av de äldste i Israel och gå framför folket. Och ta i din hand staven med vilken du slog på Nilfloden och gå. ");
INSERT INTO swef_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Se, jag ska stå där framför dig på Horebs klippa, och du ska slå på klippan. Då ska vatten komma ut ur den så att folket får dricka.” Mose gjorde så inför de äldste i Israel. ");
INSERT INTO swef_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Och han gav platsen namnet Massa och Meriba, eftersom Israels barn hade klagat och satt Herren på prov och sagt: ”Är Herren ibland oss eller inte?” ");
INSERT INTO swef_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sedan kom Amalek och stred mot Israel i Refidim. ");
INSERT INTO swef_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Då sade Mose till Josua: ”Välj ut manskap åt oss och dra ut i strid mot Amalek. I morgon ska jag ställa mig överst på höjden med Guds stav i handen.” ");
INSERT INTO swef_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josua gjorde som Mose hade sagt till honom och stred mot Amalek, medan Mose, Aron och Hur steg upp överst på höjden. ");
INSERT INTO swef_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Och så länge Mose höll upp sin hand hade Israel övertaget, men när han lät handen sjunka fick Amalek övertaget. ");
INSERT INTO swef_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","När Moses händer blev tunga tog de därför en sten och lade under honom, och han satte sig på den. Sedan stödde Aron och Hur hans händer, en på var sida. Så hölls hans händer stadiga tills solen gick ner. ");
INSERT INTO swef_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Och Josua besegrade Amalek och hans folk med svärd. ");
INSERT INTO swef_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Herren sade till Mose: ”Skriv upp detta i boken så att ni inte glömmer det och inpränta det hos Josua, för jag ska utplåna minnet av Amalek så grundligt att det inte finns mer under himlen.” ");
INSERT INTO swef_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Och Mose byggde ett altare och gav det namnet Herren mitt baner. ");
INSERT INTO swef_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Han sade: ”En hand har lyfts mot Herrens tron.Herren ska strida mot Amalek från släkte till släkte.” ");
INSERT INTO swef_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moses svärfar Jetro, prästen i Midjan, fick höra om allt som Gud hade gjort med Mose och med sitt folk Israel, hur Herren hade fört dem ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Då tog Jetro, Moses svärfar, med sig Moses hustru Sippora som Mose tidigare hade sänt hem. ");
INSERT INTO swef_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Han hade också med sig hennes två söner. En av dem hade fått namnet Gershom, för Mose sade: ”Jag är främling i ett främmande land.” ");
INSERT INTO swef_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Den andre fick namnet Elieser, för Mose sade: ”Min fars Gud kom till min hjälp och räddade mig från faraos svärd.” ");
INSERT INTO swef_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","När Jetro, Moses svärfar, kom med Moses söner och hans hustru till Mose i öknen, där han slagit läger vid Guds berg, ");
INSERT INTO swef_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","sände han bud till Mose: ”Jag, din svärfar Jetro, kommer till dig med din hustru och hennes båda söner.” ");
INSERT INTO swef_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Då gick Mose ut och mötte sin svärfar, bugade sig för honom och kysste honom. När de hade hälsat varandra gick de in i tältet. ");
INSERT INTO swef_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Och Mose berättade för sin svärfar allt som Herren hade gjort med farao och egyptierna för Israels skull, och han berättade om all möda de fått utstå på vägen och hur Herren hade räddat dem. ");
INSERT INTO swef_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro gladde sig över allt det goda som Herren hade gjort mot Israel, att han hade räddat dem ur egyptiernas hand. ");
INSERT INTO swef_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Han sade: ”Lovad är Herren, som har räddat er ur egyptiernas och faraos hand och som har räddat folket från egyptiernas hand! ");
INSERT INTO swef_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu vet jag att Herren är större än alla gudarna. Det visade han när de handlade övermodigt mot detta folk.” ");
INSERT INTO swef_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetro, Moses svärfar, bar fram ett brännoffer och några slaktoffer åt Gud. Och Aron och alla de äldste i Israel kom och höll måltid inför Gud tillsammans med Moses svärfar. ");
INSERT INTO swef_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nästa dag satte Mose sig för att döma folket, och folket stod omkring honom från morgonen ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","När Moses svärfar såg allt han gjorde för folket, sade han: ”Vad är det för bestyr du har med folket? Varför sitter du här ensam, medan allt folket måste stå omkring dig från morgon till kväll?” ");
INSERT INTO swef_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose svarade sin svärfar: ”Folket kommer till mig för att fråga Gud. ");
INSERT INTO swef_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","De kommer till mig när de har någon rättssak, och då dömer jag mellan dem. Jag låter dem veta Guds stadgar och bud.” ");
INSERT INTO swef_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Då sade Moses svärfar till honom: ”Ditt sätt att arbeta är inte bra. ");
INSERT INTO swef_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Både du själv och folket som är hos dig blir ju uttröttade. Den här uppgiften är alldeles för tung för dig, och du kan inte klara av den ensam. ");
INSERT INTO swef_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Lyssna nu på mig! Jag vill råda dig, och Gud ska vara med dig. Du ska föra folkets talan inför Gud och lägga fram deras ärenden inför honom. ");
INSERT INTO swef_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Du ska upplysa dem om stadgar och bud och låta dem veta vilken väg de ska vandra och vad de ska göra. ");
INSERT INTO swef_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Men välj ut åt dig dugliga män från allt folket, män som fruktar Gud, är pålitliga och hatar oärlig vinst, och sätt dem till föreståndare för folket, några över tusen, andra över hundra, andra över femtio och andra över tio. ");
INSERT INTO swef_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","De ska alltid döma folket. Varje viktigt ärende ska överlåtas till dig, men i alla enklare mål ska de döma själva. Så ska du göra din börda lättare, genom att de bär den tillsammans med dig. ");
INSERT INTO swef_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Om du gör på det sättet och om Gud befaller dig det, så kan du hålla ut. Och allt folket här kan då också gå hem i frid.” ");
INSERT INTO swef_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose lyssnade till sin svärfars ord och gjorde allt som han sagt. ");
INSERT INTO swef_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Han valde ut dugliga män ur hela Israel och gjorde dem till huvudmän för folket, till föreståndare över tusen, över hundra, över femtio och över tio. ");
INSERT INTO swef_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dessa skulle alltid döma folket. Alla svårare ärenden skulle de överlåta till Mose, men alla enklare mål skulle de själva avgöra. ");
INSERT INTO swef_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sedan lät Mose sin svärfar resa hem, och han återvände till sitt land. ");
INSERT INTO swef_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","På den dag då den tredje månaden började efter Israels barns uttåg ur Egyptens land kom de till Sinai öken. ");
INSERT INTO swef_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","De bröt nämligen upp från Refidim och kom till Sinai öken och slog läger i öknen. Israel slog läger där mitt emot berget, ");
INSERT INTO swef_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","och Mose steg upp till Gud. Då ropade Herren till honom uppifrån berget: ”Så ska du säga till Jakobs hus, så ska du förkunna för Israels barn: ");
INSERT INTO swef_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ni har själva sett vad jag har gjort med egyptierna och hur jag har burit er på örnvingar och fört er till mig. ");
INSERT INTO swef_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Om ni nu hör min röst och håller mitt förbund, ska ni av alla folk vara min dyrbara egendom, för hela jorden är min. ");
INSERT INTO swef_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ni ska för mig vara ett rike av präster och ett heligt folk. Detta är vad du ska tala till Israels barn.” ");
INSERT INTO swef_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","När Mose återvände kallade han samman de äldste bland folket och lade fram för dem allt som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Allt folket svarade med en mun: ”Allt som Herren har sagt vill vi göra.” Mose gick då tillbaka till Herren med folkets svar. ");
INSERT INTO swef_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Och Herren sade till Mose: ”Se, jag ska komma till dig i ett tjockt moln, för att folket ska höra när jag talar med dig och sedan för alltid tro på dig.” Mose framförde folkets svar till Herren. ");
INSERT INTO swef_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Då sade Herren till Mose: ”Gå till folket och helga dem i dag och i morgon och låt dem tvätta sina kläder. ");
INSERT INTO swef_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","De ska hålla sig beredda till i övermorgon, för då ska Herren stiga ner på Sinai berg inför allt folkets ögon. ");
INSERT INTO swef_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Du ska märka ut en gräns för folket runt omkring berget och säga: Akta er för att stiga upp på berget eller komma nära dess fot. Var och en som kommer nära berget ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Men ingen hand får röra vid honom, utan han ska stenas eller skjutas. Det gäller både djur och människor: de får inte leva. När jubelhornet ljuder med utdragen ton, då får de komma upp på berget.” ");
INSERT INTO swef_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose gick ner från berget till folket. Han helgade dem och de tvättade sina kläder. ");
INSERT INTO swef_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Och han sade till folket: ”Håll er beredda till i övermorgon. Ingen får komma nära någon kvinna.” ");
INSERT INTO swef_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","På tredje dagen, när det hade blivit morgon, började det dundra och blixtra. Ett tjockt moln lade sig över berget och ett mycket starkt basunljud hördes. Allt folket i lägret bävade. ");
INSERT INTO swef_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Men Mose förde ut folket ur lägret för att möta Gud, och de ställde sig nedanför berget. ");
INSERT INTO swef_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hela Sinai berg täcktes av rök, för Herren hade stigit ner på berget i eld. Rök steg upp därifrån som röken från en smältugn, och hela berget skakade våldsamt. ");
INSERT INTO swef_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Basunljudet blev starkare och starkare. Mose talade och Gud svarade honom med hög röst. ");
INSERT INTO swef_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Och Herren steg ner på Sinai berg, på toppen av berget, och Herren kallade Mose upp till bergets topp. Då gick Mose dit upp. ");
INSERT INTO swef_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Och Herren sade till Mose: ”Gå ner och varna folket så att de inte tränger sig fram till Herren för att se, för då kommer många av dem att falla ner döda. ");
INSERT INTO swef_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Även prästerna som får komma inför Herren ska helga sig, så att inte Herrens vrede bryter ut mot dem.” ");
INSERT INTO swef_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose svarade Herren: ”Folket kan inte stiga upp på Sinai berg, för du har själv varnat oss och sagt att jag skulle märka ut en gräns omkring berget och helga det.” ");
INSERT INTO swef_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Då sade Herren till honom: ”Gå ner och kom sedan upp igen, och ha då Aron med dig. Men prästerna och folket får inte tränga sig fram för att stiga upp till Herren, så att inte Herrens vrede bryter ut mot dem.” ");
INSERT INTO swef_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mose gick då ner till folket och sade detta till dem. ");
INSERT INTO swef_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Och Gud talade alla dessa ord: ");
INSERT INTO swef_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Jag är Herren din Gud som har fört dig ut ur Egyptens land, ur träldomshuset. ");
INSERT INTO swef_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du ska inte ha andra gudar vid sidan av mig. ");
INSERT INTO swef_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du ska inte göra dig någon bildstod eller avbild av det som är uppe i himlen eller nere på jorden eller i vattnet under jorden. ");
INSERT INTO swef_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Du ska inte tillbe dem eller tjäna dem, för jag, Herren din Gud, är en nitisk Gud. Jag låter straffet för fädernas missgärning drabba barnen till tredje och fjärde led när man hatar mig, ");
INSERT INTO swef_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","men visar nåd mot tusentals när man älskar mig och håller mina bud. ");
INSERT INTO swef_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du ska inte missbruka Herren din Guds namn, för Herren ska inte låta den bli ostraffad som missbrukar hans namn. ");
INSERT INTO swef_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tänk på sabbatsdagen så att du helgar den. ");
INSERT INTO swef_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sex dagar ska du arbeta och uträtta alla dina sysslor. ");
INSERT INTO swef_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Men den sjunde dagen är Herren din Guds sabbat. Då ska du inte utföra något arbete, inte heller din son eller dotter, din tjänare eller tjänarinna eller din boskap, eller främlingen som bor hos dig inom dina portar. ");
INSERT INTO swef_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","För på sex dagar gjorde Herren himlen och jorden och havet och allt som är i dem, men på sjunde dagen vilade han. Därför har Herren välsignat sabbatsdagen och helgat den. ");
INSERT INTO swef_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hedra din far och din mor, så att du får leva länge i det land som Herren din Gud ger dig. ");
INSERT INTO swef_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du ska inte mörda. ");
INSERT INTO swef_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du ska inte begå äktenskapsbrott. ");
INSERT INTO swef_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du ska inte stjäla. ");
INSERT INTO swef_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du ska inte bära falskt vittnesbörd mot din nästa. ");
INSERT INTO swef_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Du ska inte ha begär till din nästas hus. Du ska inte ha begär till din nästas hustru, inte heller till hans tjänare eller tjänarinna, hans oxe eller hans åsna eller något annat som tillhör din nästa. ");
INSERT INTO swef_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Allt folket var vittne till dundret och eldslågorna, basunljudet och röken från berget. Och när de såg det, bävade de och höll sig på avstånd. ");
INSERT INTO swef_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","De sade till Mose: ”Tala du till oss, så ska vi höra. Men låt inte Gud tala till oss, för då kommer vi att dö.” ");
INSERT INTO swef_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Men Mose sade till folket: ”Var inte rädda! Gud har kommit för att sätta er på prov, och för att ni ska frukta honom så att ni inte syndar.” ");
INSERT INTO swef_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Folket stod på avstånd, medan Mose gick närmare töcknet där Gud var. ");
INSERT INTO swef_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Herren sade till Mose: ”Så ska du säga till Israels barn: Ni har själva sett att jag har talat till er från himlen. ");
INSERT INTO swef_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ni ska inte göra er gudar att ha vid sidan av mig. Gudar av silver eller guld ska ni inte göra åt er. ");
INSERT INTO swef_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ett altare av jord ska du göra åt mig, och på det ska du offra dina brännoffer och dina gemenskapsoffer, din småboskap och nötboskap. På varje plats där jag låter mitt namn bli ihågkommet ska jag komma till dig och välsigna dig. ");
INSERT INTO swef_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Men om du vill göra ett altare av stenar åt mig, ska du inte bygga det av huggen sten. För om du rör vid den med din mejsel vanhelgar du stenen. ");
INSERT INTO swef_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Du får inte heller stiga upp till mitt altare på trappor, så att din nakenhet blottas vid mitt altare. ");
INSERT INTO swef_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Detta är de lagar du ska lägga fram för dem: ");
INSERT INTO swef_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Om du köper en hebreisk slav ska han tjäna dig i sex år, men det sjunde året ska du ge honom fri utan lösen. ");
INSERT INTO swef_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Om han kom ensam, ska han friges ensam. Om han var gift, ska hans hustru friges tillsammans med honom. ");
INSERT INTO swef_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Om hans herre har gett honom en hustru och om hon har fött söner och döttrar åt honom, ska hustrun och hennes barn tillhöra hennes herre. Endast mannen ska ges fri. ");
INSERT INTO swef_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Men om slaven säger: ”Jag älskar min herre, min hustru och mina barn så mycket att jag inte vill bli fri”, ");
INSERT INTO swef_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","då ska hans herre föra fram honom inför Gud, ställa honom vid dörren eller dörrposten och genomborra hans öra med en syl. Sedan ska han för alltid vara sin herres slav. ");
INSERT INTO swef_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Om någon säljer sin dotter till slavinna, ska hon inte ges fri som de andra slavarna. ");
INSERT INTO swef_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Om hennes herre tycker illa om henne sedan han utsett henne åt sig själv, ska han låta henne bli friköpt. Till ett främmande folk har han inte rätt att sälja henne, eftersom han handlat trolöst mot henne. ");
INSERT INTO swef_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Men om han utser henne åt sin son, ska han ge henne en dotters rätt. ");
INSERT INTO swef_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Om han tar sig en hustru till, får han inte inskränka på den förras mat, kläder eller äktenskapliga rätt. ");
INSERT INTO swef_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Om han inte låter henne få sin rätt i dessa tre avseenden, måste han frige henne utan ersättning och utan pengar. ");
INSERT INTO swef_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Den som slår någon så att han dör ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Men om han inte avsåg att döda utan Gud lät det ske genom hans hand, ska jag anvisa dig en ort dit han kan fly. ");
INSERT INTO swef_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Men om någon blir så hatisk mot sin nästa att han dödar honom med list, ska du gripa honom även om han är vid mitt altare. Han måste dö. ");
INSERT INTO swef_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Den som slår sin far eller sin mor ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Den som rövar bort en människa ska straffas med döden, vare sig han sedan säljer den han rövat bort eller denna blir funnen hos honom. ");
INSERT INTO swef_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Den som förbannar sin far eller mor ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Om män grälar med varandra och den ene slår den andre med en sten eller med knuten hand, så att han visserligen inte dör men blir sängliggande, ");
INSERT INTO swef_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","eller om han repar sig och kan gå ute med hjälp av sin stav, då ska den som slog honom vara fri från straff. Men han måste ersätta honom för den tid han varit sängliggande och sörja för att han verkligen blir botad. ");
INSERT INTO swef_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Om någon slår sin slav eller slavinna med en käpp så att den slagne dör för hans hand, ska han straffas för det. ");
INSERT INTO swef_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Men han ska inte straffas om den slagne lever en eller två dagar. Det är ju hans egna pengar. ");
INSERT INTO swef_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Om män kommer i gräl med varandra och någon av dem stöter till en havande kvinna så att hon föder fram sitt foster, men ingen annan olycka sker, då ska han böta vad kvinnans man ålägger honom och betala efter skiljedomares prövning. ");
INSERT INTO swef_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Men om det sker en olycka ska liv ges för liv, ");
INSERT INTO swef_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","öga för öga, tand för tand, hand för hand, fot för fot, ");
INSERT INTO swef_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brännskada för brännskada, sår för sår och blåmärke för blåmärke. ");
INSERT INTO swef_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Om någon slår sin slav eller slavinna i ögat och fördärvar det, ska han släppa den skadade fri som ersättning för ögat. ");
INSERT INTO swef_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Och om någon slår ut en tand på sin slav eller slavinna, ska han släppa den skadade fri som ersättning för tanden. ");
INSERT INTO swef_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Om en oxe stångar någon till döds, man eller kvinna, ska oxen stenas, och köttet får inte ätas. Men oxens ägare ska vara fri från straff. ");
INSERT INTO swef_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Om oxen tidigare haft vanan att stångas och hans ägare har blivit varnad men ändå inte bevakat honom och oxen då dödar någon, man eller kvinna, ska oxen stenas och även hans ägare dödas. ");
INSERT INTO swef_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Men om ägaren skulle bli ålagd att betala lösepenning, ska han ge så mycket som han blir ålagd till lösen för sitt liv. ");
INSERT INTO swef_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Samma lag gäller om det är en son eller dotter som blivit stångad av oxen. ");
INSERT INTO swef_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Men om oxen stångar en slav eller slavinna, ska ägaren betala trettio siklar silver till den stångades herre och oxen ska stenas. ");
INSERT INTO swef_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Om någon öppnar en brunn eller gräver en ny brunn och inte täcker över den och sedan en oxe eller åsna faller ner i den, ");
INSERT INTO swef_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ska brunnens ägare ge ersättning i pengar till djurets ägare, men den döda kroppen ska vara hans. ");
INSERT INTO swef_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Om någon har en oxe som stångar en annan oxe så att den dör, ska de sälja den levande oxen och dela betalningen för den. Dessutom ska de dela den döda kroppen. ");
INSERT INTO swef_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Men om det var känt att oxen redan tidigare brukade stångas och hans ägare ändå inte tog vara på honom, ska han ersätta oxe med oxe, men den döda kroppen ska vara hans. ");
INSERT INTO swef_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Om någon stjäl en oxe eller ett får och slaktar eller säljer djuret, ska han ge fem oxar som ersättning för oxen och fyra får som ersättning för fåret. ");
INSERT INTO swef_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Om tjuven ertappas vid inbrottet och blir slagen till döds, vilar ingen blodskuld på den som försvarar sin egendom. ");
INSERT INTO swef_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Men om solen hade gått upp när det hände, då är det blodskuld. Tjuven ska ge full ersättning. Äger han ingenting ska han säljas, till betalning för vad han stulit. ");
INSERT INTO swef_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Om det stulna djuret påträffas levande hos honom, antingen det är oxe, åsna eller får, ska han ge dubbel ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Om någon låter en åker eller en vingård betas av eller släpper lös sin boskap så att den betar av en annans åker, ska han ersätta skadan med det bästa från sin egen åker och det bästa från sin vingård. ");
INSERT INTO swef_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Om elden kommer lös och antänder törnhäckar, och sädeskärvar eller oskuren säd eller något annat på åkern blir lågornas rov, ska den som vållat branden ge full ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Om någon anförtror åt en annan att förvara pengar eller annan egendom och det blir stulet i hans hus, ska tjuven ge dubbel ersättning om han ertappas. ");
INSERT INTO swef_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Skulle tjuven inte bli ertappad, ska husets ägare föras fram inför Gud, för att det ska fastställas om han har förgripit sig på sin nästas egendom. ");
INSERT INTO swef_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Om det blir fråga om olagligt tillgrepp – det kan gälla oxe eller åsna, får eller kläder eller något annat som har gått förlorat – och någon påstår att det är så, ska båda parternas sak komma inför Gud. Den som Gud då dömer skyldig ska ersätta den andre dubbelt. ");
INSERT INTO swef_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Om någon lämnar en åsna, en oxe eller ett får eller vilket husdjur som helst i förvar hos en annan, och djuret dör eller blir skadat eller bortrövat utan att någon ser det, ");
INSERT INTO swef_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","då ska de båda ingå en ed inför Herren, för att det ska komma fram om den ene inte har förgripit sig på den andres egendom. Denna ed ska ägaren anta, och den andre behöver inte ge någon ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Men om djuret har blivit stulet från honom, ska han ersätta ägaren för det. ");
INSERT INTO swef_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Har det blivit ihjälrivet, ska han föra fram djuret som bevis. För det ihjälrivna djuret behöver han inte ge någon ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Om någon lånar ett djur av en annan och det blir skadat eller dör då ägaren inte är närvarande, ska han ge full ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Är ägaren närvarande, behöver han inte ge någon ersättning. Om djuret var hyrt, utgör hyressumman ersättning. ");
INSERT INTO swef_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Om någon förför en jungfru som inte är trolovad och ligger med henne, ska han ge en brudgåva för henne och ta henne till hustru. ");
INSERT INTO swef_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Om hennes far vägrar att ge henne åt honom, ska mannen betala en så stor summa pengar som man brukar ge i brudgåva för en jungfru. ");
INSERT INTO swef_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","En häxa ska du inte låta leva. ");
INSERT INTO swef_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Var och en som har samlag med ett djur ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Den som offrar åt andra gudar och inte endast åt Herren ska vigas åt förintelse. ");
INSERT INTO swef_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","En främling ska du inte förödmjuka eller förtrycka. Ni har ju själva varit främlingar i Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Änkor och faderlösa ska ni inte behandla illa. ");
INSERT INTO swef_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Om ni behandlar dem illa, ska jag sannerligen höra deras rop när de ropar till mig. ");
INSERT INTO swef_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Min vrede ska upptändas och jag ska döda er med svärd, så att era egna hustrur blir änkor och era barn faderlösa. ");
INSERT INTO swef_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Om du lånar ut pengar till någon fattig hos dig som tillhör mitt folk, ska du inte handla som en ockrare mot honom. Kräv inte någon ränta av honom. ");
INSERT INTO swef_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Om du tar manteln i pant av din nästa, ska du ge den tillbaka åt honom innan solen går ner. ");
INSERT INTO swef_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Manteln är ju det enda täcke han har, och med den skyler han sin kropp. Vad ska han annars ha när han sover? Om han ropar till mig ska jag höra, för jag är barmhärtig. ");
INSERT INTO swef_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Gud ska du inte häda, och en ledare för ditt folk ska du inte förbanna. ");
INSERT INTO swef_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Du ska inte dröja att bära fram som gåva av det som fyller din lada och av det som kommer från din vinpress. Den förstfödde av dina söner ska du ge åt mig. ");
INSERT INTO swef_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","På samma sätt ska du göra med din nötboskap och småboskap. I sju dagar ska de stanna hos sina mödrar, men på åttonde dagen ska du ge dem åt mig. ");
INSERT INTO swef_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ni ska vara mina heliga. Köttet av ett djur som blivit ihjälrivet på marken ska ni inte äta utan kasta det åt hundarna. ");
INSERT INTO swef_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du ska inte sprida ett falskt rykte. Du ska inte stödja den ogudaktige genom att bli ett falskt vittne. ");
INSERT INTO swef_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du ska inte följa mängden och rätta dig efter den i det onda, så att du vränger rätten när du vittnar i något mål. ");
INSERT INTO swef_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Du ska inte vara partisk för den fattige i hans rättssak. ");
INSERT INTO swef_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Om du träffar på din fiendes oxe eller åsna, som har kommit vilse, ska du föra djuret tillbaka till honom. ");
INSERT INTO swef_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Och om du ser din oväns åsna ligga nertyngd under sin börda, ska du inte lämna mannen utan hjälp. Du måste på allt sätt hjälpa honom. ");
INSERT INTO swef_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du ska inte i någon rättssak förvanska rätten för den fattige som du har hos dig. ");
INSERT INTO swef_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Håll dig långt ifrån orätt sak. Du ska inte döda den som är oskyldig och har rätt, för jag frikänner inte någon som är skyldig. ");
INSERT INTO swef_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Du ska inte ta mutor, för mutor förblindar de klarsynta och förvränger de rättfärdigas ord. ");
INSERT INTO swef_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","En främling ska du inte förtrycka. Ni vet själva hur främlingen känner det, eftersom ni har varit främlingar i Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","I sex år ska du beså din jord och bärga dess gröda. ");
INSERT INTO swef_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Men det sjunde året ska du låta den vila och ligga i träda, för att de fattiga i ditt folk ska få sin föda från den. Det som de lämnar kvar får markens djur äta. På samma sätt ska du göra med din vingård och din olivplantering. ");
INSERT INTO swef_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Under sex dagar ska du utföra ditt arbete, men på sjunde dagen ska du vila, så att din oxe och din åsna får vila och din slavinnas son och främlingen kan återhämta sig. ");
INSERT INTO swef_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Se till att ni i allt håller det jag har sagt er. Andra gudars namn ska ni inte nämna. De får inte höras från din mun. ");
INSERT INTO swef_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tre gånger om året ska du hålla högtid åt mig. ");
INSERT INTO swef_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Det osyrade brödets högtid ska du fira. Sju dagar ska du äta osyrat bröd, som jag har befallt dig, på den bestämda tiden i månaden Aviv, eftersom det var då du drog ut ur Egypten. Men ingen ska träda fram inför mitt ansikte med tomma händer. ");
INSERT INTO swef_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Skördehögtiden ska du fira när du skördar förstlingsfrukten av ditt arbete, det du sått på marken. Bärgningshögtiden ska du fira vid årets slut, när du bärgar in frukten av ditt arbete från marken. ");
INSERT INTO swef_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tre gånger om året ska alla av manligt kön träda fram inför Herren Gud. ");
INSERT INTO swef_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du ska inte offra blodet av mitt slaktoffer tillsammans med något som är syrat. Fettet av mitt högtidsoffer får inte lämnas kvar över natten till morgonen. ");
INSERT INTO swef_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Det bästa av din marks förstlingsfrukter ska du föra till Herren din Guds hus. Du ska inte koka en killing i mjölken från dess mor. ");
INSERT INTO swef_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Se, jag sänder en ängel framför dig, och han ska bevara dig på vägen och föra dig till den plats som jag har förberett. ");
INSERT INTO swef_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ta dig till vara för honom och lyssna till hans röst. Var inte upprorisk mot honom. Han kommer inte att förlåta era överträdelser, för mitt namn är i honom. ");
INSERT INTO swef_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Men om du uppmärksamt lyssnar till hans röst och gör allt som jag säger, ska jag bli en fiende till dina fiender och en ovän till dina ovänner. ");
INSERT INTO swef_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Min ängel ska gå framför dig och föra dig till amoreernas, hetiternas, perisseernas, kananeernas, hiveernas och jebusiternas land, och jag ska utrota dem. ");
INSERT INTO swef_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Du ska inte tillbe deras gudar och inte tjäna dem eller göra som man gör där, utan du ska slå ner dem grundligt och krossa deras stoder. ");
INSERT INTO swef_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ni ska tjäna Herren er Gud, och han ska välsigna din mat och din dryck och ta bort sjukdom från dig. ");
INSERT INTO swef_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","I ditt land ska det då inte finnas någon kvinna som får missfall eller är ofruktsam. Dina dagars tal ska jag göra fullt. ");
INSERT INTO swef_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Jag ska sända skräck för mig framför dig och vålla förvirring bland alla de folk som du kommer till, och jag ska driva alla dina fiender på flykten för dig. ");
INSERT INTO swef_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Och jag ska sända panik framför dig för att jaga undan hiveerna, kananeerna och hetiterna för dig. ");
INSERT INTO swef_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Men jag ska inte driva undan dem för dig på ett enda år, för att landet inte ska bli en ödemark där vilddjuren förökar sig och blir dig övermäktiga. ");
INSERT INTO swef_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Steg för steg ska jag driva bort dem för dig, tills du har förökat dig så att du kan ta landet till din arvedel. ");
INSERT INTO swef_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Jag ska låta ditt lands gränser gå från Röda havet till filisteernas hav och från öknen till floden, för jag ska ge landets invånare i er hand och du ska driva bort dem från dig. ");
INSERT INTO swef_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du ska inte sluta förbund med dem eller deras gudar. ");
INSERT INTO swef_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","De ska inte bo kvar i ditt land. Annars kan de få dig att synda mot mig. Om du tjänar deras gudar blir det en snara för dig. ");
INSERT INTO swef_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Till Mose sade han: ”Kom upp till Herren, du själv och Aron, Nadab och Abihu samt sjuttio av de äldste i Israel. Fall ner och tillbe på avstånd. ");
INSERT INTO swef_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Endast Mose får komma fram till Herren. De andra ska inte komma fram, och folket får inte heller gå upp med honom.” ");
INSERT INTO swef_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","När Mose kom och förkunnade för folket alla Herrens ord och föreskrifter, svarade allt folket med en mun: ”Allt som Herren har sagt vill vi göra.” ");
INSERT INTO swef_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Och Mose skrev ner alla Herrens ord. Nästa morgon steg han upp tidigt och byggde ett altare nedanför berget och reste där tolv stoder för Israels tolv stammar. ");
INSERT INTO swef_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Han sände israeliternas unga män att offra tjurar som brännoffer och gemenskapsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Och Mose tog hälften av blodet och slog det i skålar och den andra hälften av blodet stänkte han på altaret. ");
INSERT INTO swef_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Han tog förbundsboken och läste upp den för folket, och de sade: ”Allt som Herren har sagt vill vi göra och lyda.” ");
INSERT INTO swef_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Då tog Mose blodet och stänkte på folket och sade: ”Se, detta är blodet för det förbund som Herren har slutit med er i enlighet med alla dessa ord.” ");
INSERT INTO swef_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mose och Aron, Nadab och Abihu och sjuttio av de äldste i Israel gick dit upp. ");
INSERT INTO swef_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","De fick se Israels Gud, och under hans fötter var som ett golv av safir, likt själva himlen i klarhet. ");
INSERT INTO swef_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Men han lät inte sin hand drabba de främsta av Israels barn. De skådade Gud, och de åt och drack. ");
INSERT INTO swef_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Herren sade till Mose: ”Stig upp till mig på berget och bli kvar där, så ska jag ge dig stentavlorna med lagen och budorden som jag har skrivit till undervisning för dem.” ");
INSERT INTO swef_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Då gav sig Mose av tillsammans med sin tjänare Josua, och Mose steg upp på Guds berg. ");
INSERT INTO swef_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Men till de äldste sade han: ”Vänta på oss här tills vi kommer tillbaka till er. Aron och Hur är hos er, och den som har en rättslig fråga får vända sig till dem.” ");
INSERT INTO swef_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose steg sedan upp på berget, och molnskyn täckte berget. ");
INSERT INTO swef_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Herrens härlighet vilade på Sinai berg och molnskyn täckte berget i sex dagar, men på sjunde dagen kallade han på Mose ur skyn. ");
INSERT INTO swef_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Och Herrens härlighet såg för Israels barn ut som en förtärande eld på toppen av berget. ");
INSERT INTO swef_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose gick mitt in i molnskyn och steg upp på berget. Sedan blev han kvar på berget i fyrtio dagar och fyrtio nätter. ");
INSERT INTO swef_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","”Säg till Israels barn att de samlar in en offergåva åt mig. Den ska samlas in från alla dem som har ett hjärta som är villigt att ge. ");
INSERT INTO swef_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Detta är den offergåva som ni ska ta av dem: guld, silver och koppar, ");
INSERT INTO swef_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mörkblått, purpurrött och karmosinrött garn, fint lingarn och gethår, ");
INSERT INTO swef_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rödfärgade fårskinn, tahasskinn, akacieträ, ");
INSERT INTO swef_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olja till ljusstaken, kryddor till smörjelseoljan och till den väldoftande rökelsen ");
INSERT INTO swef_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","samt onyxer och infattningsstenar till efoden och bröstskölden. ");
INSERT INTO swef_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","De ska göra en helgedom åt mig, så att jag kan bo mitt ibland dem. ");
INSERT INTO swef_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tabernaklet med alla dess tillbehör ska ni göra helt enligt de mönsterbilder som jag visar dig. Så ska ni göra. ");
INSERT INTO swef_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","De ska göra en ark av akacieträ, två och en halv aln lång, en och en halv aln bred och en och en halv aln hög. ");
INSERT INTO swef_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Du ska överdra den med rent guld på insidan och utsidan och du ska göra en guldkant runt den. ");
INSERT INTO swef_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Du ska gjuta fyra ringar av guld till den och sätta dem över de fyra fötterna på arken, två ringar på den ena sidan och två ringar på den andra. ");
INSERT INTO swef_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Och du ska göra stänger av akacieträ och överdra dem med guld. ");
INSERT INTO swef_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Stängerna ska du skjuta in i ringarna på sidorna av arken, så att man kan bära arken med dem, ");
INSERT INTO swef_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","och de ska sitta kvar i ringarna på arken. De får inte tas bort ur dem. ");
INSERT INTO swef_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","I arken ska du lägga vittnesbördet som jag ska ge dig. ");
INSERT INTO swef_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Du ska göra en nådastol av rent guld, två och en halv aln lång och en och en halv aln bred. ");
INSERT INTO swef_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Och du ska göra två keruber av guld. I hamrat arbete ska du göra dem och sätta dem vid de båda ändarna av nådastolen. ");
INSERT INTO swef_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Sätt en kerub vid ena änden och en vid den andra. I ett stycke med nådastolen ska ni göra keruberna vid dess båda ändar. ");
INSERT INTO swef_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Keruberna ska breda ut sina vingar uppåt så att de täcker nådastolen med sina vingar. Deras ansikten ska vara vända mot varandra. Mot nådastolen ska kerubernas ansikten vara vända. ");
INSERT INTO swef_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Du ska sätta nådastolen ovanpå arken och i arken ska du lägga vittnesbördet som jag ska ge dig. ");
INSERT INTO swef_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Där ska jag göra mig känd för dig. Och från nådastolen, från platsen mellan de båda keruberna som står på vittnesbördets ark, ska jag tala med dig om allt som jag genom dig ska befalla Israels barn. ");
INSERT INTO swef_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Du ska också göra ett bord av akacieträ, två alnar långt, en aln brett och en och en halv aln högt. ");
INSERT INTO swef_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Du ska överdra det med rent guld och du ska göra en guldkant runt omkring det. ");
INSERT INTO swef_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Runt bordet ska du göra en handsbred list och runt omkring den ska du göra en kant av guld. ");
INSERT INTO swef_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Till bordet ska du göra fyra ringar av guld och sätta ringarna i de fyra hörnen vid de fyra benen. ");
INSERT INTO swef_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ringarna ska sitta vid listen som hållare för stänger så att bordet kan bäras. ");
INSERT INTO swef_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Du ska göra stängerna av akacieträ och överdra dem med guld, och med dem ska bordet bäras. ");
INSERT INTO swef_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Till bordet ska du också göra fat, skålar, kannor och bägare som man ska utgjuta dryckesoffren med. Av rent guld ska du göra dem. ");
INSERT INTO swef_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Du ska alltid ha skådebröd på bordet inför mitt ansikte. ");
INSERT INTO swef_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Du ska göra en ljusstake av rent guld. I hamrat arbete ska den göras med sin fotställning och stam. Dess skålar, knoppar och blommor ska göras i ett stycke med den. ");
INSERT INTO swef_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Sex armar ska utgå från ljusstakens sidor, tre armar från ena sidan och tre armar från andra sidan. ");
INSERT INTO swef_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","På den ena armen ska det vara tre skålar, formade som mandelblommor, vardera bestående av en knopp och en blomma, och på den andra armen likaså tre skålar, formade som mandelblommor, vardera bestående av en knopp och en blomma. Så ska det vara på de sex armar som utgår från ljusstaken. ");
INSERT INTO swef_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Men på själva ljusstaken ska det finnas fyra skålar formade som mandelblommor med sina knoppar och blommor. ");
INSERT INTO swef_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","En knopp ska sättas under det första armparet som utgår från ljusstaken i ett stycke med den, en knopp under det andra armparet i ett stycke med den, och en knopp under det tredje armparet i ett stycke med den, alltså under de sex armar som utgår från ljusstaken. ");
INSERT INTO swef_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Och deras knoppar och armar ska vara i ett stycke med den, allt ett enda hamrat arbete av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Du ska göra sju lampor till den. Lamporna ska sättas upp så att de kastar sitt sken över platsen framför den. ");
INSERT INTO swef_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Även lamptänger och brickor till den ska du göra av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Av en talent rent guld ska man göra ljusstaken med alla dessa tillbehör. ");
INSERT INTO swef_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Se till att du gör detta efter den mönsterbild som har visats för dig på berget. ");
INSERT INTO swef_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Tabernaklet ska du göra av tio tygvåder, vävda av tvinnat fint lingarn och av mörkblått, purpurrött och karmosinrött garn. I konstvävnad med keruber på ska du göra dem. ");
INSERT INTO swef_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Varje våd ska vara tjugoåtta alnar lång och fyra alnar bred, alla våderna med samma mått. ");
INSERT INTO swef_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Fem av våderna ska fogas samman med varandra och likaså ska de andra fem våderna fogas samman med varandra. ");
INSERT INTO swef_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Du ska sätta öglor av mörkblått garn i kanten på den ena våden ytterst på det hopfogade stycket, och så ska du också göra i kanten på den våd som sitter ytterst i det andra hopfogade stycket. ");
INSERT INTO swef_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Femtio öglor ska du sätta på ena våden och femtio öglor ska du sätta ytterst på motsvarande våd i det andra hopfogade stycket, så att öglorna svarar mot varandra. ");
INSERT INTO swef_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Och du ska göra femtio hakar av guld och foga samman våderna med dem, så att tabernaklet bildar en helhet. ");
INSERT INTO swef_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Du ska göra tygvåder av gethår till ett tält över tabernaklet. Elva sådana våder ska du göra. ");
INSERT INTO swef_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Varje våd ska vara trettio alnar lång och fyra alnar bred, de elva våderna ska ha samma mått. ");
INSERT INTO swef_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Fem av våderna ska du foga samman för sig och de sex andra våderna för sig. Den sjätte våden ska du lägga dubbel på framsidan av tältet. ");
INSERT INTO swef_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Du ska sätta femtio öglor i kanten på den våd som sitter ytterst i det ena hopfogade stycket och femtio öglor i kanten på den våd som sitter ytterst i det andra hopfogade stycket. ");
INSERT INTO swef_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Du ska också göra femtio hakar av koppar och föra in dem i öglorna och foga samman tältet så att det bildar en helhet. ");
INSERT INTO swef_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Beträffande den överskjutande delen av tältets våder ska halva den våd som blir över hänga ner på baksidan av tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Den aln på vardera sidan som blir över på längden av tältets våder ska hänga ner på båda sidorna av tabernaklet för att täcka över det. ");
INSERT INTO swef_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Dessutom ska du göra ett överdrag av rödfärgade fårskinn till tältet och ett överdrag av tahasskinn att lägga ovanpå. ");
INSERT INTO swef_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Brädorna till tabernaklet ska du göra av akacieträ, och de ska stå upprätt. ");
INSERT INTO swef_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Tio alnar lång och en och en halv aln bred ska varje bräda vara. ");
INSERT INTO swef_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Varje bräda ska ha två tappar som är hopfogade med varandra. Så ska du göra med alla brädorna till tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Och av tabernaklets brädor ska du sätta tjugo på södra sidan, åt söder, ");
INSERT INTO swef_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","och göra fyrtio fotstycken av silver och sätta dem under de tjugo brädorna, två fotstycken under varje bräda för dess två tappar. ");
INSERT INTO swef_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","På tabernaklets andra sida, den norra, ska du också sätta tjugo brädor ");
INSERT INTO swef_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","med fyrtio fotstycken av silver, två fotstycken under varje bräda. ");
INSERT INTO swef_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","På tabernaklets baksida, åt väster, ska du sätta sex brädor ");
INSERT INTO swef_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","och på tabernaklets hörn, på baksidan, två brädor. ");
INSERT INTO swef_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","De ska vara dubbla nertill och även dubbla upptill, till den första ringen. Så ska det vara med dem båda. De ska sättas i de båda hörnen. ");
INSERT INTO swef_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Det blir alltså åtta brädor med sina fotstycken av silver, sexton fotstycken, två under varje bräda. ");
INSERT INTO swef_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Och du ska göra tvärstänger av akacieträ: fem till de brädor som är på tabernaklets ena sida, ");
INSERT INTO swef_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","fem tvärstänger till de brädor som är på tabernaklets andra sida och fem tvärstänger till de brädor som är på tabernaklets baksida, åt väster. ");
INSERT INTO swef_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Den mellersta tvärstången, som sitter mitt på brädorna, ska gå tvärs över från den ena änden till den andra. ");
INSERT INTO swef_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Brädorna ska du överdra med guld och ringarna på dem där tvärstängerna ska skjutas in, ska du göra av guld. Också tvärstängerna ska du överdra med guld. ");
INSERT INTO swef_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Sätt sedan upp tabernaklet som det ska vara, så som det har visats för dig på berget. ");
INSERT INTO swef_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Du ska göra ett förhänge av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. Det ska göras i konstvävnad med keruber på. ");
INSERT INTO swef_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Du ska hänga upp det på fyra stolpar av akacieträ. Stolparna ska vara överdragna med guld och ha krokar av guld, och de ska stå på fyra fotstycken av silver. ");
INSERT INTO swef_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Du ska hänga upp förhänget i hakarna och föra dit vittnesbördets ark och ställa den innanför förhänget. Förhänget ska för er skilja det heliga från det allra heligaste. ");
INSERT INTO swef_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Och du ska sätta nådastolen på vittnesbördets ark inne i det allra heligaste. ");
INSERT INTO swef_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Bordet ska du ställa utanför förhänget på tabernaklets norra sida och ljusstaken mitt emot bordet på tabernaklets södra sida. ");
INSERT INTO swef_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","För ingången till tältet ska du göra ett draperi i brokig vävnad av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Till draperiet ska du göra fem stolpar av akacieträ och överdra dem med guld. Krokarna på dem ska vara av guld, och till stolparna ska du gjuta fem fotstycken av koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Du ska göra altaret av akacieträ, fem alnar långt och fem alnar brett – altaret ska alltså vara liksidigt och fyrkantigt – och tre alnar högt. ");
INSERT INTO swef_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Och du ska göra horn till det och sätta i de fyra hörnen. Hornen ska vara i ett stycke med altaret, och du ska överdra det med koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Du ska göra kärl till det att föra bort askan i, liksom skovlar, skålar, gafflar och fyrfat. Alla dessa tillbehör ska du göra av koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Du ska göra ett galler till altaret, ett nät av koppar, och på nätet ska du sätta fyra ringar av koppar i de fyra hörnen. ");
INSERT INTO swef_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Du ska sätta det nertill under avsatsen på altaret, så att nätet når upp till mitten av altaret. ");
INSERT INTO swef_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Du ska göra stänger till altaret, stänger av akacieträ, och överdra dem med koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Stängerna ska skjutas in i ringarna, så att de sitter på båda sidorna av altaret när man bär det. ");
INSERT INTO swef_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ihåligt och av plankor ska du göra det. Så som det har visats för dig på berget ska det göras. ");
INSERT INTO swef_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Du ska också göra en förgård till tabernaklet. För den södra sidan, åt söder, ska omhängen till förgården göras av tvinnat fint lingarn, hundra alnar långa, för den ena sidan. ");
INSERT INTO swef_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Stolparna till dem ska vara tjugo med sina tjugo fotstycken av koppar, men stolparnas krokar och band ska vara av silver. ");
INSERT INTO swef_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","På samma sätt ska omhängen göras för den norra långsidan, hundra alnar långa. Stolparna till dem ska vara tjugo med tjugo fotstycken av koppar, men stolparnas krokar och band ska vara av silver. ");
INSERT INTO swef_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Förgårdens västra kortsida ska ha omhängen som är femtio alnar långa. Stolparna till dem ska vara tio med tio fotstycken. ");
INSERT INTO swef_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Förgårdens bredd på framsidan, åt öster, ska vara femtio alnar. ");
INSERT INTO swef_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Omhängena ska vara femton alnar långa på den ena sidan av den med tre stolpar och tre fotstycken. ");
INSERT INTO swef_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","På den andra sidan ska omhängena också vara femton alnar långa med tre stolpar och tre fotstycken. ");
INSERT INTO swef_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Till förgårdens port ska göras ett draperi, tjugo alnar långt, i brokig vävnad av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn, med fyra stolpar och fyra fotstycken. ");
INSERT INTO swef_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alla stolparna runt förgården ska ha band av silver och krokar av silver, men deras fotstycken ska vara av koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Förgården ska vara hundra alnar lång och femtio alnar bred utefter hela längden med fem alnar höga omhängen av tvinnat fint lingarn, och fotstyckena ska vara av koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Alla tillbehör för tjänsten i tabernaklet och alla tältpluggar till tabernaklet och förgården ska vara av koppar. ");
INSERT INTO swef_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Du ska befalla Israels barn att bära fram till dig ren olja av stötta oliver till ljusstaken, så att lamporna kan sättas upp dagligen. ");
INSERT INTO swef_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","I uppenbarelsetältet, utanför förhänget framför vittnesbördet, ska Aron och hans söner sköta den från kväll till morgon inför Herrens ansikte. Det ska vara en evig stadga från släkte till släkte bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Du ska låta din bror Aron och hans söner med honom träda fram till dig ur kretsen av Israels barn för att tjäna som präster åt mig, Aron själv och hans söner Nadab och Abihu, Eleasar och Itamar. ");
INSERT INTO swef_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Och du ska göra heliga kläder åt din bror Aron till ära och prydnad. ");
INSERT INTO swef_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Säg till alla era konstbegåvade män, som jag har fyllt med vishetens ande, att de ska göra kläder åt Aron för hans vigning till präst åt mig. ");
INSERT INTO swef_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Detta är de kläder de ska göra: bröstsköld, efod, kåpa, rutmönstrad tunika, turban och bälte. De ska göra dessa heliga kläder åt din bror Aron och hans söner för att Aron ska tjäna som präst åt mig. ");
INSERT INTO swef_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Och de ska ta av guldet och det mörkblå, purpurröda och karmosinröda garnet och det fina lingarnet. ");
INSERT INTO swef_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Efoden ska göras i konstvävnad av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Den ska ha två axelstycken som ska fästas ihop med varandra. Vid sina båda ändar ska den fästas ihop. ");
INSERT INTO swef_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Skärpet som ska sitta på efoden ska göras i samma vävnad och i ett stycke med den: av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Du ska sedan ta två onyxstenar och på dem gravera in namnen på Israels söner, ");
INSERT INTO swef_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sex av namnen på den ena stenen och de sex andra namnen på den andra, i födelseordning. ");
INSERT INTO swef_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Som när en juvelerare graverar sigill ska du rista in namnen på Israels söner på de båda stenarna och infatta dem i ett flätverk av guld. ");
INSERT INTO swef_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Du ska sätta de båda stenarna på efodens axelstycken, stenar till påminnelse för Israels barn. Aron ska bära deras namn på sina axlar inför Herrens ansikte till en påminnelse. ");
INSERT INTO swef_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Och du ska göra flätverk av guld ");
INSERT INTO swef_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","och två kedjor av rent guld. Du ska tvinna dem som snoddar, och fästa de snodda kedjorna vid flätverken. ");
INSERT INTO swef_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Du ska göra en bröstsköld för domsutslag i konstvävnad på samma sätt som efoden. Av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn ska du göra den. ");
INSERT INTO swef_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Den ska vara fyrkantig och dubbelvikt, en halv aln lång och en halv aln bred. ");
INSERT INTO swef_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Du ska förse den med infattade stenar i fyra rader: i första raden karneol, topas och smaragd, ");
INSERT INTO swef_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","i andra raden granat, safir och kalcedon, ");
INSERT INTO swef_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","i tredje raden hyacint, agat och ametist ");
INSERT INTO swef_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","och i fjärde raden krysolit, onyx och jaspis. De ska vara infattade i flätverk av guld. ");
INSERT INTO swef_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Stenarna ska vara tolv efter namnen på Israels söner, en för varje namn. Varje sten ska bära namnet på en av de tolv stammarna, ingraverat som på ett sigill. ");
INSERT INTO swef_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Till bröstskölden ska du göra flätade kedjor så som man gör snoddar, och av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Du ska göra två ringar av guld till bröstskölden och sätta dem i två av bröstsköldens hörn. ");
INSERT INTO swef_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Du ska fästa de två guldsnoddarna vid de båda ringarna i bröstsköldens hörn. ");
INSERT INTO swef_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","De båda snoddarnas andra ändar ska du fästa vid de två flätverken och sedan fästa dem på framkanten av efodens axelstycken. ");
INSERT INTO swef_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Du ska göra två ringar av guld och sätta dem i de båda andra hörnen på bröstskölden, vid den kant som är vänd in mot efoden. ");
INSERT INTO swef_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Och du ska göra två ringar av guld och fästa dem nertill på framsidan av efodens båda axelstycken där efoden fästes ihop ovanför skärpet. ");
INSERT INTO swef_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Bröstskölden ska knytas fast med en mörkblå snodd, som går från dess ringar in i efodens ringar så att den sitter ovanför efodens skärp för att inte lossna från efoden. ");
INSERT INTO swef_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aron ska bära namnen på Israels söner i domsskölden på sitt hjärta när han går in i helgedomen, till en ständig påminnelse inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I domsskölden ska du lägga urim och tummim, så att de ligger på Arons hjärta när han går inför Herren. Aron ska så alltid bära Israels barns dom på sitt hjärta inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Efodkåpan ska du göra helt och hållet i mörkblått. ");
INSERT INTO swef_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Mitt på den ska vara en öppning för huvudet, och öppningen ska omges med en vävd kant som på en pansarskjorta för att kåpan inte ska slitas sönder. ");
INSERT INTO swef_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Runt kåpans nedre fåll ska du sätta granatäpplen av mörkblått, purpurrött och karmosinrött garn, och bjällror av guld mellan dem runt om, ");
INSERT INTO swef_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","en bjällra av guld och ett granatäpple och åter en bjällra av guld och ett granatäpple runt hela fållen av kåpan. ");
INSERT INTO swef_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aron ska bära denna kåpa när han gör tjänst, så att det hörs när han går in i helgedomen inför Herrens ansikte och när han går ut. Då ska han inte dö. ");
INSERT INTO swef_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Du ska också göra en skinande platta av rent guld, och på den ska du ingravera som på ett sigill: Helgad åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Du ska fästa den med ett mörkblått snöre och den ska sitta på turbanen, på framsidan av turbanen. ");
INSERT INTO swef_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Den ska sitta på Arons panna och Aron ska bära den skuld som häftar vid de heliga offer som Israels barn bär fram, alla deras heliga gåvor. Den ska ständigt sitta på hans panna så att Herren kan ta emot dem med glädje. ");
INSERT INTO swef_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Du ska också väva tunikan i rutmönster av fint lingarn, och du ska göra en turban av fint lingarn och ett bälte i brokig väv. ");
INSERT INTO swef_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Också åt Arons söner ska du göra tunikor. Och du ska göra bälten åt dem och huvor till ära och prydnad. Detta ska du klä på din bror Aron och hans söner, ");
INSERT INTO swef_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","och du ska smörja dem och viga dem till präster och helga dem, så att de kan tjäna som präster åt mig. ");
INSERT INTO swef_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Du ska göra byxor av linne åt dem för att skyla deras kön. De ska räcka från höfterna ner på låren. ");
INSERT INTO swef_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aron och hans söner ska ha dem på sig när de går in i uppenbarelsetältet eller träder fram till altaret för att göra tjänst i helgedomen, så att de inte drar på sig skuld och drabbas av döden. Detta ska vara en evig stadga för honom och hans avkomlingar efter honom. ");
INSERT INTO swef_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Detta är vad du ska göra med dem för att helga dem till att bli mina präster: Ta en ungtjur och två baggar, felfria djur, ");
INSERT INTO swef_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","osyrat bröd och osyrade kakor bakade med olja och osyrade tunnkakor smorda med olja. Av fint vetemjöl ska du baka dem. ");
INSERT INTO swef_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Du ska lägga dem i samma korg och bära fram dem i korgen som en offergåva när du för fram tjuren och de båda baggarna. ");
INSERT INTO swef_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Sedan ska du föra fram Aron och hans söner till uppenbarelsetältets ingång och tvätta dem med vatten. ");
INSERT INTO swef_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Du ska ta kläderna och sätta på Aron tunikan, efodkåpan, själva efoden och bröstskölden och fästa ihop efoden på honom med efodens skärp. ");
INSERT INTO swef_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Du ska sätta turbanen på hans huvud och fästa det heliga diademet på turbanen. ");
INSERT INTO swef_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Och du ska ta smörjelseoljan och hälla på hans huvud och smörja honom. ");
INSERT INTO swef_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hans söner ska du föra fram och sätta på dem tunikor. ");
INSERT INTO swef_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Du ska spänna fast bälten på Aron och hans söner och sätta på dem huvor. Och de ska ha rätten till prästämbetet för evigt. Så ska du viga Aron och hans söner till präster. ");
INSERT INTO swef_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Du ska föra fram tjuren till uppenbarelsetältet, och Aron och hans söner ska lägga händerna på tjurens huvud. ");
INSERT INTO swef_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Sedan ska du slakta tjuren inför Herrens ansikte vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Du ska ta av tjurens blod och stryka det med fingret på altarets horn. Men resten av blodet ska du hälla ut vid altarets fot. ");
INSERT INTO swef_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Du ska ta allt det fett som omsluter inälvorna, leverfettet och de båda njurarna med det fett som är på dem, och bränna det på altaret. ");
INSERT INTO swef_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Men tjurens kött och hud och hans tarminnehåll ska du bränna upp i eld utanför lägret. Det är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Du ska ta den ena baggen, och Aron och hans söner ska lägga händerna på baggens huvud. ");
INSERT INTO swef_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sedan ska du slakta den och ta av dess blod och stänka det runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Men själva baggen ska du stycka och tvätta inälvorna och fötterna och lägga dem på styckena och huvudet. ");
INSERT INTO swef_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Och du ska bränna hela baggen på altaret. Det är ett brännoffer åt Herren, en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Därefter ska du ta den andra baggen, och Aron och hans söner ska lägga händerna på hans huvud. ");
INSERT INTO swef_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Och du ska slakta baggen och ta lite av blodet och stryka på Arons högra örsnibb, på hans söners högra örsnibb, på tummen på deras högra hand och på stortån på deras högra fot. Men resten av blodet ska du stänka runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Och du ska ta något av blodet på altaret och av smörjelseoljan och stänka på Aron och hans kläder och på hans söner och deras kläder. Då blir Aron själv och hans kläder heliga, och även hans söner och deras kläder blir heliga. ");
INSERT INTO swef_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Och du ska ta fettet på baggen, svansfettet och det fett som omsluter inälvorna, leverfettet och de båda njurarna med det fett som finns på dem och dessutom det högra lårstycket. Detta är prästvigningsbaggen. ");
INSERT INTO swef_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Du ska ta en rund brödkaka, en oljebrödskaka och en tunnkaka ur korgen med de osyrade bröden som står inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Och du ska lägga allt detta i händerna på Aron och hans söner och lyfta det som ett lyftoffer inför Herren. ");
INSERT INTO swef_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Sedan ska du ta det ur deras händer och bränna det på altaret, ovanpå brännoffret, till en ljuvlig doft inför Herrens ansikte. Det är ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Du ska ta bringan av Arons prästvigningsbagge och lyfta den som ett lyftoffer inför Herrens ansikte, och detta ska vara din del. ");
INSERT INTO swef_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Du ska helga lyftofferbringan och offergärdslåret, det som har lyfts och offrats som offergåva, de delar av prästvigningsbaggen som ska tillhöra Aron och hans söner. ");
INSERT INTO swef_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Aron och hans söner ska få detta av Israels barn som en rättighet för all framtid, för det är en offergåva. Det ska vara en gåva från Israels barn av deras gemenskapsoffer, deras gåva till Herren. ");
INSERT INTO swef_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Arons heliga kläder ska hans söner ha efter honom. Klädda i dem ska de bli smorda och vigda till sin tjänst. ");
INSERT INTO swef_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","I sju dagar ska den av Arons söner som blir präst i hans ställe sätta på sig dessa kläder, när han går in i uppenbarelsetältet för att göra tjänst i helgedomen. ");
INSERT INTO swef_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Du ska ta prästvigningsbaggen och koka köttet på en helig plats. ");
INSERT INTO swef_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Baggens kött och brödet som är i korgen ska Aron och hans söner äta vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","De ska äta det som användes till att bringa försoning när de vigdes till präster och helgades, men ingen främmande får äta av det eftersom det är heligt. ");
INSERT INTO swef_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Om något av prästvigningsköttet eller brödet blir över till nästa morgon ska du bränna upp det i eld. Det får inte ätas, för det är heligt. ");
INSERT INTO swef_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","I allt ska du göra med Aron och hans söner så som jag har befallt dig. I sju dagar ska deras prästvigning vara. ");
INSERT INTO swef_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Varje dag ska du offra en tjur som syndoffer till försoning och rena altaret genom att du bringar försoning för det. Och du ska smörja det för att helga det. ");
INSERT INTO swef_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","I sju dagar ska du bringa försoning för altaret och helga det. Altaret blir då högheligt, och var och en som rör vid det blir helig. ");
INSERT INTO swef_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Detta är vad du ska offra på altaret varje dag för all framtid: två årsgamla lamm. ");
INSERT INTO swef_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Det ena lammet ska du offra på morgonen och det andra i skymningen. ");
INSERT INTO swef_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Till det första lammet ska du offra en tiondels efa fint mjöl, begjutet med en fjärdedels hin olja av stötta oliver och som dryckesoffer en fjärdedels hin vin. ");
INSERT INTO swef_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Det andra lammet ska du offra i skymningen. Med likadant matoffer och dryckesoffer som på morgonen ska du offra det till en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Från släkte till släkte ska detta vara ert dagliga brännoffer inför Herrens ansikte vid ingången till uppenbarelsetältet. Där ska jag uppenbara mig för er och tala med dig. ");
INSERT INTO swef_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Där ska jag uppenbara mig för Israels barn och den platsen ska bli helgad genom min härlighet. ");
INSERT INTO swef_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Jag ska helga uppenbarelsetältet och altaret, och Aron och hans söner ska jag helga till präster åt mig. ");
INSERT INTO swef_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Jag ska bo mitt ibland Israels barn och vara deras Gud. ");
INSERT INTO swef_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Och de ska inse att jag är Herren deras Gud, som förde dem ut ur Egyptens land för att bo mitt ibland dem. Jag är Herren deras Gud. ");
INSERT INTO swef_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Du ska göra ett altare att tända rökelse på. Av akacieträ ska du göra det. ");
INSERT INTO swef_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Det ska vara fyrkantigt, en aln långt och en aln brett, och två alnar högt. Hornen ska göras i ett stycke med altaret. ");
INSERT INTO swef_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Du ska överdra det med rent guld, både ovansidan och väggarna runt omkring, likaså hornen. Du ska också göra en kant av guld runt altaret. ");
INSERT INTO swef_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Två ringar av guld ska du göra till det och sätta dem under kanten på två sidor. På två motsatta sidostycken ska du sätta dem som hållare för stänger, så att man kan bära altaret med dem. ");
INSERT INTO swef_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Stängerna ska du göra av akacieträ och överdra dem med guld. ");
INSERT INTO swef_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Du ska ställa altaret framför förhänget framför vittnesbördets ark. Det ska stå framför nådastolen som är ovanpå vittnesbördet, där jag ska uppenbara mig för dig. ");
INSERT INTO swef_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aron ska tända väldoftande rökelse på altaret. Varje morgon när han gör i ordning lamporna ska han tända rökelse. ");
INSERT INTO swef_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aron ska också tända rökelse när han sätter upp lamporna i skymningen. Detta ska vara det dagliga rökelseoffret inför Herrens ansikte från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ni ska inte låta någon främmande rökelse komma på det och inte heller brännoffer eller matoffer och ni ska inte utgjuta något dryckesoffer på det. ");
INSERT INTO swef_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","En gång om året ska Aron bringa försoning för altarets horn. Med blod från försoningssyndoffret ska han en gång om året bringa försoning för det, släkte efter släkte. Det är högheligt för Herren. ");
INSERT INTO swef_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","När du räknar antalet av Israels barn som ska mönstras, ska var och en vid mönstringen ge åt Herren en lösepenning för sitt liv så att ingen straffdom drabbar dem vid mönstringen. ");
INSERT INTO swef_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Var och en som tas upp bland de mönstrade ska ge en halv sikel efter helgedomssikelns vikt, sikeln räknad till tjugo gera, en halv sikel som offergåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Var och en som tas upp bland de mönstrade, den som är tjugo år gammal eller mer, ska ge detta som en offergåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Den rike ska inte ge mer och den fattige inte mindre än en halv sikel när ni ger offergåvan åt Herren som lösen för ert liv. ");
INSERT INTO swef_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Du ska ta emot lösensumman från Israels barn och ge den till arbetet vid uppenbarelsetältet. Detta ska vara en påminnelse för Israels barn inför Herrens ansikte, att lösen betalas för era själar. ");
INSERT INTO swef_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Du ska göra ett kar av koppar med en fotställning av koppar att användas till tvättning, och du ska ställa det mellan uppenbarelsetältet och altaret och hälla vatten i det. ");
INSERT INTO swef_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aron och hans söner ska tvätta sina händer och fötter med vatten från det. ");
INSERT INTO swef_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","När de går in i uppenbarelsetältet ska de tvätta sig med vatten för att de inte ska dö, så även när de träder fram till altaret för att göra tjänst genom att tända eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","De ska tvätta sina händer och fötter för att inte dö. Detta ska vara en evig stadga för dem, för Aron själv och hans efterkommande från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Herren sade vidare till Mose: ");
INSERT INTO swef_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Ta kryddor av finaste slag: femhundra siklar flytande myrra, hälften så mycket doftande kanel, alltså tvåhundrafemtio siklar, tvåhundrafemtio siklar doftande kalmus, ");
INSERT INTO swef_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","femhundra siklar kassia efter helgedomssikelns vikt och en hin olivolja. ");
INSERT INTO swef_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Av detta ska du göra en helig smörjelseolja, en doftande blandning, en konstmässigt beredd salva. Det ska vara en helig smörjelseolja. ");
INSERT INTO swef_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Med denna olja ska du smörja uppenbarelsetältet, vittnesbördets ark, ");
INSERT INTO swef_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","bordet med alla dess tillbehör, ljusstaken med dess tillbehör, rökelsealtaret, ");
INSERT INTO swef_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","brännofferaltaret med alla dess tillbehör och slutligen karet med dess fotställning. ");
INSERT INTO swef_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Du ska helga dessa föremål så att de blir högheliga. Och var och en som rör vid dem blir helig. ");
INSERT INTO swef_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aron och hans söner ska du smörja och helga till präster åt mig. ");
INSERT INTO swef_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Du ska säga till Israels barn: Detta ska vara min heliga smörjelseolja från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Smörj inte någon annan människas kropp med den och gör inte heller någon annan smörjelseolja med denna sammansättning. Helig är den, och helig ska den vara för er. ");
INSERT INTO swef_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Den som gör en sådan blandning och använder något av den på en obehörig ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Herren sade till Mose: Ta väldoftande kryddor, stakte, sjönagel och galbanum och dessutom rent rökelseharts, lika mycket av varje slag, ");
INSERT INTO swef_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","och gör rökelse av dem, en konstmässigt beredd blandning, saltad, ren och helig. ");
INSERT INTO swef_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","En del av den ska du stöta till pulver och lägga framför vittnesbördet i uppenbarelsetältet, där jag ska uppenbara mig för dig. Höghelig ska den vara för er. ");
INSERT INTO swef_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Den rökelse ni gör med denna sammansättning får ni inte göra åt er själva. Den ska vara helig för dig inför Herren. ");
INSERT INTO swef_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Den som gör en sådan för att njuta av doften ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Se, jag har kallat Besalel, son till Uri, son till Hur av Juda stam. ");
INSERT INTO swef_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Jag har fyllt honom med Guds Ande, med vishet och förstånd, med kunskap och med skicklighet i allt slags hantverk, ");
INSERT INTO swef_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","så att han kan tänka ut konstfulla arbeten och utföra dem i guld, silver och koppar, ");
INSERT INTO swef_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","slipa stenar för infattning och snida i trä och utföra alla slags arbeten. ");
INSERT INTO swef_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Och se, jag har gett honom Oholiab, Ahisamaks son av Dans stam, till medhjälpare. Åt alla era konstnärligt begåvade män har jag gett vishet i hjärtat att utföra allt som jag har gett dig befallning om: ");
INSERT INTO swef_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","uppenbarelsetältet, vittnesbördets ark, nådastolen på den, alla tillbehör för uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bordet med dess tillbehör, ljusstaken av rent guld med alla dess tillbehör, rökelsealtaret, ");
INSERT INTO swef_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","brännofferaltaret med alla dess tillbehör, karet med dess fotställning, ");
INSERT INTO swef_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","de vävda kläderna och prästen Arons heliga kläder, hans söners prästkläder, ");
INSERT INTO swef_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","smörjelseoljan och den väldoftande rökelsen till helgedomen. I allt ska de utföra sitt arbete så som jag har befallt dig. ");
INSERT INTO swef_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Säg till Israels barn: Mina sabbater ska ni hålla, för de är ett tecken mellan mig och er från släkte till släkte, för att ni ska veta att jag är Herren som helgar er. ");
INSERT INTO swef_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ni ska hålla sabbaten, för den är helig för er. Den som vanhelgar den ska straffas med döden, för var och en som på den dagen gör något arbete ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sex dagar ska man arbeta, men den sjunde dagen är en sabbat för vila, helgad åt Herren. Var och en som utför något arbete på sabbatsdagen ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israels barn ska hålla sabbaten och fira den släkte efter släkte som ett evigt förbund. ");
INSERT INTO swef_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Den är ett evigt tecken mellan mig och Israels barn. För på sex dagar gjorde Herren himmel och jord, men på sjunde dagen upphörde han med sitt verk och vilade. ");
INSERT INTO swef_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","När Gud hade talat färdigt med Mose på Sinai berg, gav han honom vittnesbördets två tavlor, tavlor av sten, skrivna med Guds finger. ");
INSERT INTO swef_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","När folket såg att det dröjde innan Mose kom ner från berget, samlades de kring Aron och sade till honom: ”Kom och gör oss en gud, som ska gå framför oss. För vad som har hänt den där Mose som förde oss upp ur Egyptens land, det vet vi inte.” ");
INSERT INTO swef_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Då sade Aron till dem: ”Ta guldringarna som era hustrur, era söner och era döttrar har i öronen och ge dem till mig.” ");
INSERT INTO swef_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Då tog allt folket av sig guldringarna som de hade i öronen och bar dem till Aron. ");
INSERT INTO swef_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Han tog emot guldet och formade det med en mejsel och gjorde av det en gjuten kalv. Och de sade: ”Här är din gud, Israel, som har fört dig upp ur Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","När Aron såg det, byggde han ett altare framför den och utropade: ”I morgon är det en Herrens högtid.” ");
INSERT INTO swef_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nästa dag steg de upp tidigt och offrade brännoffer och bar fram gemenskapsoffer. Folket satte sig för att äta och dricka och reste sig för att roa sig. ");
INSERT INTO swef_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Då sade Herren till Mose: ”Gå dit ner, för ditt folk som du har fört upp ur Egyptens land drar fördärv över sig. ");
INSERT INTO swef_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","De har redan vikit av från den väg som jag befallde dem att gå. De har gjort sig en gjuten kalv som de har tillbett och offrat åt och sagt: ”Här är din gud, Israel, som har fört dig upp ur Egyptens land.” ");
INSERT INTO swef_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Herren sade ytterligare till Mose: ”Jag har sett detta folk, och se, det är ett hårdnackat folk. ");
INSERT INTO swef_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Låt mig nu vara, så att min vrede kan brinna mot dem och förtära dem. Dig ska jag göra till ett stort folk.” ");
INSERT INTO swef_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Men Mose bönföll inför Herren sin Gud och sade: ”Herre, varför skulle din vrede brinna mot ditt folk, som du har fört ut ur Egyptens land med stor kraft och stark hand? ");
INSERT INTO swef_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Varför skulle egyptierna få säga: Till deras olycka har han fört ut dem för att döda dem bland bergen och utrota dem från jordens yta? Vänd dig från din glödande vrede och ångra det onda du har i sinnet mot ditt folk. ");
INSERT INTO swef_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kom ihåg Abraham, Isak och Israel, dina tjänare, som du med ed vid dig själv har lovat: Jag ska göra era efterkommande lika talrika som stjärnorna på himlen, och hela det land som jag har talat om ska jag ge åt era efterkommande. De ska få det till arvedel för evigt.” ");
INSERT INTO swef_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Då ångrade Herren det onda som han hade hotat att göra mot sitt folk. ");
INSERT INTO swef_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose vände om och gick ner från berget med vittnesbördets två tavlor i händerna. Det var skrivet på tavlornas båda sidor, både på framsidan och på baksidan. ");
INSERT INTO swef_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tavlorna var Guds verk och skriften var Guds skrift, inristad på tavlorna. ");
INSERT INTO swef_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josua hörde oväsendet när folket skrek, och han sade till Mose: ”Det hörs krigsrop i lägret.” ");
INSERT INTO swef_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Men han svarade: ”Det är inte ljudet av segerrop, och inte ljudet av nederlag. Ljudet av sång är vad jag hör.” ");
INSERT INTO swef_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","När sedan Mose kom närmare lägret och fick se kalven och dansen, upptändes hans vrede. Han kastade ifrån sig tavlorna och slog sönder dem nedanför berget. ");
INSERT INTO swef_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Och han tog kalven som de hade gjort, brände den i eld, krossade den till stoft, strödde det i vattnet och lät Israels barn dricka det. ");
INSERT INTO swef_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Och Mose sade till Aron: ”Vad har folket gjort med dig, eftersom du har förlett dem att begå en så stor synd?” ");
INSERT INTO swef_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron svarade: ”Var inte vred, herre! Du vet själv att folket är ont. ");
INSERT INTO swef_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","De sade till mig: Gör oss en gud som kan gå framför oss, för vi vet inte vad som hänt med den där Mose som förde oss upp ur Egyptens land. ");
INSERT INTO swef_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Då sade jag till dem: Den som har guld ska ta av sig det. Och de gav det åt mig. Jag kastade det i elden, och ut kom denna kalv.” ");
INSERT INTO swef_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose såg att folket var lössläppt eftersom Aron hade släppt greppet om dem, till skadeglädje för deras fiender. ");
INSERT INTO swef_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mose ställde sig i porten till lägret och ropade: ”Alla som tillhör Herren ska komma hit till mig!” Då samlades alla leviterna kring honom, ");
INSERT INTO swef_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","och han sade till dem: ”Så säger Herren, Israels Gud: Alla ska spänna på sig svärdet och gå fram och tillbaka genom lägret från port till port och döda var och en sin bror, sin vän eller släkting.” ");
INSERT INTO swef_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leviterna gjorde som Mose hade sagt, och på den dagen föll omkring tretusen män av folket. ");
INSERT INTO swef_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Och Mose sade: ”Invig er i dag till Herrens tjänst, eftersom ni har stått emot era egna söner och bröder. Så ska han i dag ge er sin välsignelse.” ");
INSERT INTO swef_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nästa dag sade Mose till folket: ”Ni har begått en stor synd. Jag ska nu stiga upp till Herren. Kanske jag kan bringa försoning för er synd.” ");
INSERT INTO swef_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mose gick tillbaka till Herren och sade: ”O, detta folk har begått en stor synd. De har gjort sig en gud av guld. ");
INSERT INTO swef_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Men förlåt dem nu deras synd. Om inte, så utplåna mig ur boken som du skriver i.” ");
INSERT INTO swef_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Men Herren svarade Mose: ”Den som har syndat mot mig, honom ska jag utplåna ur min bok. ");
INSERT INTO swef_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Gå nu och för folket dit jag har sagt dig. Se, min ängel ska gå framför dig. Men när dagen för min straffdom kommer ska jag straffa dem för deras synd.” ");
INSERT INTO swef_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Och Herren slog folket för att de hade gjort kalven, den som Aron gjorde. ");
INSERT INTO swef_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Herren sade till Mose: ”Bryt upp och dra härifrån, du själv och folket som du har fört upp ur Egypten, till det land som jag med ed lovade åt Abraham, Isak och Jakob, då jag sade: Åt din avkomma ska jag ge det. ");
INSERT INTO swef_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Jag ska sända en ängel framför dig och driva bort kananeerna, amoreerna, hetiterna, perisseerna, hiveerna och jebusiterna ");
INSERT INTO swef_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","och föra dig till ett land som flödar av mjölk och honung. Jag ska inte själv gå upp med dig. Eftersom du är ett hårdnackat folk kunde jag då förgöra dig under vägen.” ");
INSERT INTO swef_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","När folket hörde det stränga talet blev de sorgsna, och ingen tog på sig sina smycken. ");
INSERT INTO swef_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Och Herren sade till Mose: ”Säg till Israels folk: Ni är ett hårdnackat folk. Om jag bara för ett ögonblick gick med dig skulle jag förgöra dig. Men lägg nu av dig dina smycken så ska jag besluta vad jag ska göra med dig.” ");
INSERT INTO swef_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Folket tog då av sig smyckena och var utan dem alltifrån vistelsen vid berget Horeb. ");
INSERT INTO swef_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose tog tältet och slog upp det utanför lägret, långt ifrån lägret. Han kallade det uppenbarelsetältet. Var och en som ville rådfråga Herren måste gå ut till uppenbarelsetältet utanför lägret. ");
INSERT INTO swef_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Så ofta Mose gick ut till tältet stod allt folket upp. Var och en ställde sig vid ingången till sitt tält och såg efter Mose tills han hade kommit in i tältet. ");
INSERT INTO swef_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Varje gång Mose kom in i tältet sänkte molnstoden sig och blev stående vid ingången till tältet, och Herren talade med Mose. ");
INSERT INTO swef_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","När allt folket såg molnstoden stå vid ingången till tältet reste sig alla och bugade sig till marken, var och en vid ingången till sitt tält. ");
INSERT INTO swef_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Och Herren talade med Mose ansikte mot ansikte, som när en man talar med en annan. Sedan vände Mose tillbaka till lägret. Men hans tjänare Josua, Nuns son, som var en ung man, lämnade inte tältet. ");
INSERT INTO swef_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose sade till Herren: ”Se, du säger till mig: Led detta folk dit upp! Men du har inte låtit mig veta vem du vill sända med mig, fastän du har sagt: Jag känner dig vid namn och du har funnit nåd för mina ögon. ");
INSERT INTO swef_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Om jag nu har funnit nåd för dina ögon, så låt mig förstå dina vägar och lära känna dig, så att jag finner nåd för dina ögon. Och tänk på att detta folk är ditt folk.” ");
INSERT INTO swef_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Herren sade: ”Min närvaro ska gå med dig och låta dig få ro.” ");
INSERT INTO swef_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Han svarade: ”Om din närvaro inte går med ska du inte alls låta oss dra upp härifrån. ");
INSERT INTO swef_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","För hur skulle man kunna veta att jag och ditt folk har funnit nåd för dina ögon, om inte genom att du går med oss så att jag och ditt folk utmärks bland alla andra folk på jorden?” ");
INSERT INTO swef_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Herren svarade Mose: ”Det du har begärt ska jag också göra, för du har funnit nåd för mina ögon och jag känner dig vid namn.” ");
INSERT INTO swef_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose sade: ”Låt mig få se din härlighet.” ");
INSERT INTO swef_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Han svarade: ”Jag ska låta all min godhet gå förbi framför dig och jag ska ropa ut namnet ’Herren’ inför dig. Jag ska vara nådig mot den jag vill vara nådig mot och förbarma mig över den jag vill förbarma mig över. ");
INSERT INTO swef_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Men mitt ansikte kan du inte få se, för ingen människa kan se mig och leva.” ");
INSERT INTO swef_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sedan sade Herren: ”Se, här är en plats nära intill mig. Ställ dig där på klippan. ");
INSERT INTO swef_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","När min härlighet går förbi ska jag ställa dig i en klyfta i klippan, och jag ska låta min hand vara över dig tills jag har gått förbi. ");
INSERT INTO swef_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sedan ska jag ta bort min hand, och då ska du få se mig på ryggen. Men mitt ansikte kan ingen se.” ");
INSERT INTO swef_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Herren sade till Mose: ”Hugg ut två stentavlor åt dig, likadana som de förra. På dem ska jag skriva samma ord som stod på de förra tavlorna, som du slog sönder. ");
INSERT INTO swef_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Var redo tidigt i morgon. Du ska då på morgonen stiga upp på Sinai berg och ställa dig på bergets topp för att möta mig där. ");
INSERT INTO swef_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ingen får komma upp tillsammans med dig, och ingen får visa sig på hela berget. Får och kor får inte heller beta framför berget.” ");
INSERT INTO swef_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mose högg ut två stentavlor, likadana som de förra, och tidigt nästa morgon gick han upp på Sinai berg som Herren hade befallt honom. Han tog med sig de båda stentavlorna. ");
INSERT INTO swef_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Då steg Herren ner i molnskyn och ställde sig där nära intill honom och ropade ut Herrens namn. ");
INSERT INTO swef_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Och Herren gick förbi honom där han stod och ropade: ”Herren! Herren! – en barmhärtig och nådig Gud, sen till vrede och stor i nåd och sanning. ");
INSERT INTO swef_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Han bevarar nåd mot tusenden och förlåter brott, synd och skuld, men låter ingen bli ostraffad utan låter straffet för fädernas missgärning drabba barn och barnbarn till tredje och fjärde led.” ");
INSERT INTO swef_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Då böjde sig Mose hastigt ner mot jorden och tillbad. ");
INSERT INTO swef_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Han sade: ”Herre, om jag har funnit nåd för dina ögon, så må Herren gå mitt ibland oss, fastän det är ett hårdnackat folk. Och förlåt oss vår synd och skuld och gör oss till din arvedel.” ");
INSERT INTO swef_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Herren svarade: ”Se, jag sluter ett förbund: Inför hela ditt folk ska jag göra sådana under som inte har gjorts på hela jorden eller hos något folk. Och hela det folk som du är mitt ibland ska se Herrens gärning, för det som jag gör med dig är förunderligt stort. ");
INSERT INTO swef_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Rätta dig efter det jag i dag befaller dig. Se, jag ska driva bort amoreerna, kananeerna, hetiterna, perisseerna, hiveerna och jebusiterna för dig. ");
INSERT INTO swef_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ta dig till vara för att sluta förbund med invånarna i det land dit du kommer, så att de inte blir till en snara för dig. ");
INSERT INTO swef_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","I stället ska ni bryta ner deras altaren, krossa deras stoder och hugga ner deras asherapålar. ");
INSERT INTO swef_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Du ska inte tillbe någon annan gud, för Herren heter Nitisk, en nitisk Gud är han. ");
INSERT INTO swef_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Du ska inte sluta något förbund med invånarna i landet, eftersom de trolöst håller sig till sina gudar och offrar åt dem. När de då inbjuder dig kommer du att äta av deras offer. ");
INSERT INTO swef_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Du kommer också att ta deras döttrar till hustrur åt dina söner, och när då deras döttrar trolöst håller sig till sina gudar kommer de också att förleda dina söner att trolöst hålla sig till dem. ");
INSERT INTO swef_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du ska inte göra några gjutna gudar åt dig. ");
INSERT INTO swef_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Du ska fira det osyrade brödets högtid. I sju dagar ska du äta osyrat bröd, så som jag har befallt dig, på den bestämda tiden i månaden Aviv. Det var i månaden Aviv som du drog ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Allt som först kommer ut ur moderlivet är mitt, liksom allt förstfött av hankön bland din boskap, det må vara oxe eller får. ");
INSERT INTO swef_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Men ett förstfött åsneföl ska du lösa ut med ett lamm, och om du inte vill lösa ut det ska du krossa nacken på det. Varje förstfödd bland dina söner ska du lösa ut. Ingen ska träda fram inför mitt ansikte med tomma händer. ");
INSERT INTO swef_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sex dagar ska du arbeta, men på sjunde dagen ska du vila. Också under plöjningstiden och skördetiden ska du ha vilodag. ");
INSERT INTO swef_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Du ska fira veckohögtiden när du skördar det första vetet och bärgningshögtiden vid årets slut. ");
INSERT INTO swef_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tre gånger om året ska alla dina män träda fram inför Herren Gud, Israels Gud, ");
INSERT INTO swef_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","för jag ska driva undan folk för dig och utvidga ditt område. Ingen ska stå efter ditt land, när du tre gånger om året drar upp för att träda fram inför Herren din Guds ansikte. ");
INSERT INTO swef_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du ska inte offra blodet av mitt slaktoffer tillsammans med något som är syrat. Påskhögtidens slaktoffer ska inte lämnas kvar över natten till morgonen. ");
INSERT INTO swef_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Det bästa av din marks förstlingsfrukter ska du föra till Herren din Guds hus. Du ska inte koka en killing i mjölken från dess mor.” ");
INSERT INTO swef_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Herren sade till Mose: ”Skriv upp dessa ord åt dig, för i enlighet med dessa ord har jag slutit ett förbund med dig och med Israel.” ");
INSERT INTO swef_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Och han blev kvar där hos Herren i fyrtio dagar och fyrtio nätter utan att äta och dricka. Och han skrev på tavlorna förbundets ord, de tio budorden. ");
INSERT INTO swef_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","När Mose sedan kom ner från Sinai berg och hade med sig vittnesbördets båda tavlor på vägen ner, visste han inte att hans ansiktes hy strålade efter att han hade talat med Herren. ");
INSERT INTO swef_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aron och alla Israels barn såg Mose, och se, hans ansiktes hy strålade. Och de var rädda för att komma nära honom. ");
INSERT INTO swef_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Men Mose ropade till dem. Då vände Aron och församlingens alla hövdingar tillbaka till honom, och Mose talade till dem. ");
INSERT INTO swef_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sedan kom alla Israels barn fram till honom, och han gav dem alla de bud som Herren hade sagt honom på Sinai berg. ");
INSERT INTO swef_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","När Mose hade talat färdigt till dem hängde han en slöja för ansiktet. ");
INSERT INTO swef_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Varje gång som Mose trädde fram inför Herrens ansikte för att tala med honom tog han av sig slöjan tills han gick ut igen. När han kom ut, talade han till Israels barn det som han fått befallning om. ");
INSERT INTO swef_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Och Israels barn såg att Moses ansikte strålade, och Mose hängde slöjan över ansiktet igen tills han gick in för att tala med Herren. ");
INSERT INTO swef_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose samlade hela Israels församling och sade till dem: ”Detta är vad Herren har befallt er att göra. ");
INSERT INTO swef_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Under sex dagar ska ni utföra ert arbete, men den sjunde dagen ska vara helig för er, en Herrens sabbat för vila. Var och en som utför något arbete på den dagen ska dödas. ");
INSERT INTO swef_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ni ska inte göra upp eld på sabbaten, var ni än bor.” ");
INSERT INTO swef_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose sade till hela Israels församling: ”Detta är vad Herren har befallt: ");
INSERT INTO swef_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ta upp bland er en offergåva åt Herren. Var och en som har ett hjärta som är villigt till det ska bära fram denna offergåva åt Herren: guld, silver och koppar, ");
INSERT INTO swef_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","mörkblått, purpurrött och karmosinrött garn, fint lingarn och gethår, ");
INSERT INTO swef_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rödfärgade fårskinn, tahasskinn, akacieträ, ");
INSERT INTO swef_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olja till ljusstaken, kryddor till smörjelseoljan och till den väldoftande rökelsen ");
INSERT INTO swef_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","samt onyxstenar och infattningsstenar till efoden och bröstskölden. ");
INSERT INTO swef_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Alla konstnärligt begåvade män bland er ska komma och tillverka allt det som Herren har befallt: ");
INSERT INTO swef_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","tabernaklet, dess tält och överdraget till det, dess hakar, brädor, tvärstänger, stolpar och fotstycken, ");
INSERT INTO swef_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","arken med dess stänger, nådastolen och det täckande förhänget, ");
INSERT INTO swef_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","bordet med dess stänger och alla tillbehör och skådebröden, ");
INSERT INTO swef_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ljusstaken med dess tillbehör och lampor, oljan till ljusstaken, ");
INSERT INTO swef_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","rökelsealtaret med dess stänger, smörjelseoljan och den väldoftande rökelsen, draperiet för ingången till tabernaklet, ");
INSERT INTO swef_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","brännofferaltaret med det koppargaller som hör till det, stängerna och alla dess tillbehör, karet med dess fotställning, ");
INSERT INTO swef_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","omhängena till förgården, dess stolpar och fotstycken, draperiet för porten till förgården, ");
INSERT INTO swef_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tabernaklets och förgårdens tältpluggar med deras tältlinor ");
INSERT INTO swef_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","samt kläderna till tjänsten i helgedomen, prästen Arons heliga kläder och hans söners prästkläder.” ");
INSERT INTO swef_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Israels hela församling gick då bort ifrån Mose. ");
INSERT INTO swef_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Sedan kom de tillbaka, var och en som manades till det i sitt hjärta, och var och en som hade en villig ande bar fram en gåva åt Herren till arbetet på uppenbarelsetältet, till tjänsten där och till de heliga kläderna. ");
INSERT INTO swef_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","De kom, både män och kvinnor, och var och en bar med villigt hjärta fram spännen, örhängen, fingerringar och halssmycken, alla slags värdesaker av guld, var och en som kunde offra en gåva av guld åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Var och en som ägde mörkblått, purpurrött och karmosinrött garn, fint lingarn och gethår, rödfärgade fårskinn och tahasskinn bar fram det. ");
INSERT INTO swef_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Alla som kunde ge en gåva av silver eller koppar bar fram sin gåva åt Herren, och var och en som ägde akacieträ för arbetets utförande bar fram det. ");
INSERT INTO swef_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Alla konstnärligt begåvade kvinnor spann med sina händer mörkblått, purpurrött och karmosinrött garn samt fint lingarn och bar fram vad de spunnit, ");
INSERT INTO swef_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","och alla kvinnor, som manades till det i sitt hjärta och kunde konsten, spann gethår. ");
INSERT INTO swef_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Hövdingarna bar fram onyxstenar och infattningsstenar för efoden och bröstskölden, ");
INSERT INTO swef_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","kryddor och olja till ljusstaken, till smörjelseoljan och till den väldoftande rökelsen. ");
INSERT INTO swef_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Och varje man och kvinna av Israels barn som hade ett villigt hjärta att bära fram något till allt det arbete som Herren hade befallt genom Mose att man skulle göra, bar fram sin frivilliga gåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose sade till Israels barn: ”Se, Herren har kallat Besalel, son till Uri, son till Hur av Juda stam, ");
INSERT INTO swef_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","och han har fyllt honom med Guds Ande, med vishet, förstånd och kunskap och med skicklighet i allt slags hantverk, ");
INSERT INTO swef_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","så att han kan tänka ut konstfulla arbeten och utföra dem i guld, silver och koppar, ");
INSERT INTO swef_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","slipa stenar för infattning och snida i trä och utföra alla slags konstfulla arbeten. ");
INSERT INTO swef_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Åt honom och åt Oholiab, Ahisamaks son av Dans stam, har han också gett förmågan att undervisa andra. ");
INSERT INTO swef_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Han har fyllt deras hjärtan med vishet att utföra alla slags snideriarbeten och konstvävnader och brokiga vävnader av mörkblått, purpurrött och karmosinrött garn samt fint lingarn och andra vävnader, att utföra alla slags arbeten och tänka ut konstfulla verk. ");
INSERT INTO swef_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besalel och Oholiab och alla andra konstnärligt begåvade män har Herren utrustat med vishet och förstånd till att veta hur de ska utföra allt arbetet med att uppföra och färdigställa helgedomen. De ska i allt göra det så som Herren har befallt.” ");
INSERT INTO swef_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Sedan kallade Mose till sig Besalel och Oholiab och alla de andra konstnärligt begåvade män som Herren hade utrustat med vishet i hjärtat, alla som manades i sitt hjärta att träda fram för att utföra arbetet. ");
INSERT INTO swef_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Och de tog emot av Mose alla de gåvor som Israels barn hade burit fram till arbetet med att bygga helgedomen. Folket fortsatte att bära fram frivilliga gåvor till honom morgon efter morgon. ");
INSERT INTO swef_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Då kom alla de konstnärligt begåvade män som utförde allt arbete vid helgedomen, var och en från det arbete de höll på med, ");
INSERT INTO swef_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","och sade till Mose: ”Folket bär fram mer än vad som behövs för att göra det arbete som Herren har befallt oss att utföra.” ");
INSERT INTO swef_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Då befallde Mose att man skulle kungöra i lägret: ”Ingen, vare sig man eller kvinna, ska göra något mer för att ge till helgedomen.” Så hindrades folket från att bära fram fler gåvor. ");
INSERT INTO swef_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Det man hade samlat var tillräckligt för allt det arbete som skulle utföras, och mer än nog. ");
INSERT INTO swef_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Alla de konstnärligt begåvade hantverkarna gjorde nu tabernaklet av tio tygvåder. Av tvinnat fint lingarn och av mörkblått, purpurrött och karmosinrött garn gjorde de dem i konstvävnad med keruber på. ");
INSERT INTO swef_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Varje våd gjordes tjugoåtta alnar lång och fyra alnar bred, alla våderna med samma mått. ");
INSERT INTO swef_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Man fogade samman fem av våderna med varandra, och likaså fogade man samman de andra fem våderna med varandra. ");
INSERT INTO swef_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","I kanten på ena våden, ytterst på det hopfogade stycket, satte man öglor av mörkblått garn. Så gjorde man också i kanten på den våd som satt ytterst i det andra hopfogade stycket. ");
INSERT INTO swef_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Femtio öglor satte man på den ena våden och femtio öglor satte man ytterst på motsvarande våd i det andra hopfogade stycket, så att öglorna svarade mot varandra. ");
INSERT INTO swef_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Och man gjorde femtio hakar av guld och fogade samman våderna med varandra med hjälp av hakarna, så att tabernaklet bildade en helhet. ");
INSERT INTO swef_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Man gjorde också tygvåder av gethår till ett tält över tabernaklet. Elva sådana våder gjordes. ");
INSERT INTO swef_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Varje våd gjordes trettio alnar lång och fyra alnar bred, de elva våderna hade samma mått. ");
INSERT INTO swef_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Fem av våderna fogades samman för sig och de andra sex våderna för sig. ");
INSERT INTO swef_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Man satte femtio öglor i kanten på den våd som satt ytterst i det ena hopfogade stycket och femtio öglor i kanten på den våd som satt ytterst i det andra hopfogade stycket. ");
INSERT INTO swef_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Man gjorde också femtio hakar av koppar för att foga samman tältet till en helhet. ");
INSERT INTO swef_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Dessutom gjordes ett överdrag av rödfärgade fårskinn till tältet och ett överdrag av tahasskinn att lägga ovanpå. ");
INSERT INTO swef_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Brädorna till tabernaklet gjorde man av akacieträ och ställde dem upprätt. ");
INSERT INTO swef_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Varje bräda gjordes tio alnar lång och en och en halv aln bred. ");
INSERT INTO swef_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","På varje bräda sattes två tappar hopfogade med varandra. Så gjorde man på alla brädorna till tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Och av tabernaklets brädor satte man tjugo på södra sidan, åt söder, ");
INSERT INTO swef_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","och man gjorde fyrtio fotstycken av silver att sätta under de tjugo brädorna, två fotstycken under varje bräda för dess två tappar. ");
INSERT INTO swef_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","På samma sätt satte man på tabernaklets andra sida, den norra, tjugo brädor ");
INSERT INTO swef_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","med deras fyrtio fotstycken av silver, två fotstycken under varje bräda. ");
INSERT INTO swef_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","På tabernaklets baksida, åt väster, satte man sex brädor ");
INSERT INTO swef_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","och på tabernaklets hörn på baksidan två brädor. ");
INSERT INTO swef_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","De var dubbla nertill och även dubbla upptill, till den första ringen. Så gjorde man med dem båda, i de två hörnen. ");
INSERT INTO swef_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Det blev alltså åtta brädor med sina fotstycken av silver, sammanlagt sexton fotstycken, två under varje bräda. ");
INSERT INTO swef_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Man gjorde tvärstänger av akacieträ, fem till de brädor som var på tabernaklets ena sida, ");
INSERT INTO swef_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","fem till de brädor som var på tabernaklets andra sida och fem till de brädor som var på tabernaklets baksida, åt väster. ");
INSERT INTO swef_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Man satte den mellersta tvärstången så att den gick tvärs över, mitt på brädorna, från den ena änden till den andra. ");
INSERT INTO swef_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Brädorna överdrog man med guld, och ringarna på dem där tvärstängerna skulle skjutas in, gjordes av guld. Och tvärstängerna överdrogs med guld. ");
INSERT INTO swef_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Man gjorde förhänget av mörkblått, purpurrött och karmosinrött garn samt tvinnat fint lingarn. Det gjordes i konstvävnad med keruber på. ");
INSERT INTO swef_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Och till det gjorde man fyra stolpar av akacieträ och överdrog dem med guld, krokarna till dem gjordes av guld och man göt fyra fotstycken till dem av silver. ");
INSERT INTO swef_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","För ingången till tältet gjorde man ett draperi i brokig vävnad av mörkblått, purpurrött och karmosinrött garn samt tvinnat fint lingarn ");
INSERT INTO swef_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","och till detta fem stolpar med deras krokar. Deras knoppar och band överdrogs med guld och deras fem fotstycken gjordes av koppar. ");
INSERT INTO swef_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel gjorde arken av akacieträ, två och en halv aln lång, en och en halv aln bred och en och en halv aln hög. ");
INSERT INTO swef_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Han överdrog den med rent guld på insidan och utsidan och gjorde en guldkant runt den. ");
INSERT INTO swef_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Han göt fyra ringar av guld till den och satte dem över de fyra fötterna på arken, två ringar på ena sidan och två ringar på den andra. ");
INSERT INTO swef_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Och han gjorde stänger av akacieträ och överdrog dem med guld. ");
INSERT INTO swef_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Stängerna sköt han in i ringarna på sidorna av arken, så att man kunde bära den. ");
INSERT INTO swef_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Och han gjorde en nådastol av rent guld, två och en halv aln lång och en och en halv aln bred. ");
INSERT INTO swef_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Han gjorde två keruber av guld. I hamrat arbete gjorde han dem och satte dem vid de båda ändarna av nådastolen, ");
INSERT INTO swef_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","en kerub vid ena änden och en vid den andra. I ett stycke med nådastolen gjorde han keruberna vid dess båda ändar. ");
INSERT INTO swef_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Keruberna bredde ut sina vingar uppåt, så att de täckte nådastolen med sina vingar. Deras ansikten var vända mot varandra. Mot nådastolen var kerubernas ansikten vända. ");
INSERT INTO swef_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Han gjorde bordet av akacieträ, två alnar långt, en aln brett och en och en halv aln högt. ");
INSERT INTO swef_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Han överdrog det med rent guld och gjorde en guldkant runt omkring det. ");
INSERT INTO swef_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Runt bordet gjorde han en handsbred list, och runt omkring den gjorde han en kant av guld. ");
INSERT INTO swef_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Till bordet göt han fyra ringar av guld och satte ringarna i de fyra hörnen vid de fyra benen. ");
INSERT INTO swef_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ringarna sattes vid listen som hållare för stängerna, så att man kunde bära bordet. ");
INSERT INTO swef_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Han gjorde stängerna av akacieträ och överdrog dem med guld. Så kunde bordet bäras. ");
INSERT INTO swef_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Och han gjorde kärlen till bordet: faten, skålarna, bägarna och kannorna som användes till att utgjuta dryckesoffren med, allt av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Han gjorde ljusstaken av rent guld. I hamrat arbete gjorde han den med fotställning och stam. Dess skålar, knoppar och blommor gjordes i ett stycke med den. ");
INSERT INTO swef_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Sex armar utgick från ljusstakens sidor, tre armar från ena sidan och tre armar från andra sidan. ");
INSERT INTO swef_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","På den ena armen sattes tre skålar, formade som mandelblommor, vardera bestående av en knopp och en blomma, och på den andra armen likaså tre skålar, formade som mandelblommor, vardera bestående av en knopp och en blomma. Så gjordes på de sex armar som utgick från ljusstaken. ");
INSERT INTO swef_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Men på själva ljusstaken sattes fyra skålar, formade som mandelblommor med sina knoppar och blommor. ");
INSERT INTO swef_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","En knopp sattes under det första armparet som utgick från ljusstaken i ett stycke med den, en knopp under det andra armparet i ett stycke med den och en knopp under det tredje armparet i ett stycke med den, alltså under de sex armar som utgick från ljusstaken. ");
INSERT INTO swef_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Och deras knoppar och armar var i ett stycke med den, allt ett enda hamrat arbete av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Han gjorde sju lampor till den, likaså lamptänger och brickor till den av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Av en talent rent guld gjorde han ljusstaken med alla dess tillbehör. ");
INSERT INTO swef_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Han gjorde rökelsealtaret av akacieträ. Det var fyrkantigt, en aln långt och en aln brett, och två alnar högt. Hornen gjordes i ett stycke med altaret. ");
INSERT INTO swef_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Han överdrog det med rent guld, både ovansidan och väggarna runt omkring, likaså hornen. Han gjorde också en kant av guld runt altaret. ");
INSERT INTO swef_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Två ringar av guld gjorde han till det och satte dem under kanten på två sidor. På två motsatta sidostycken satte han dem som hållare för stänger, så att man kunde bära altaret med dem. ");
INSERT INTO swef_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Stängerna gjorde han av akacieträ och överdrog dem med guld. ");
INSERT INTO swef_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Han gjorde den heliga smörjelseoljan och den rena, väldoftande rökelsen, konstmässigt tillredda. ");
INSERT INTO swef_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Han gjorde brännofferaltaret av akacieträ. Det var liksidigt, fem alnar långt och fem alnar brett, och fyrkantigt och tre alnar högt. ");
INSERT INTO swef_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Han gjorde horn till det och satte dem i de fyra hörnen. Hornen gjordes i ett stycke med altaret, och han överdrog det med koppar. ");
INSERT INTO swef_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Altarets alla tillbehör gjorde han av koppar: askkärlen, skovlarna, skålarna, gafflarna och fyrfaten. ");
INSERT INTO swef_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Och han gjorde ett galler till altaret, ett nät av koppar, och satte det nertill under avsatsen på altaret, så att det nådde upp till mitten. ");
INSERT INTO swef_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Han göt också fyra ringar och satte dem i de fyra hörnen på koppargallret som hållare för stängerna. ");
INSERT INTO swef_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Och han gjorde stängerna av akacieträ och överdrog dem med koppar. ");
INSERT INTO swef_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Han sköt in stängerna i ringarna på sidorna av altaret, så att man kunde bära det med dem. Ihåligt och av plankor gjordes det. ");
INSERT INTO swef_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Han gjorde karet av koppar med en fotställning av koppar. Till det använde han speglar som hade tillhört de kvinnor som gjorde tjänst vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Han gjorde också förgården. För den södra sidan, åt söder, gjordes omhängena till förgården av tvinnat fint lingarn, hundra alnar långa. ");
INSERT INTO swef_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Till dem gjordes tjugo stolpar med tjugo fotstycken av koppar, men stolparnas krokar och band gjordes av silver. ");
INSERT INTO swef_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Även för norra sidan gjordes omhängena hundra alnar långa, och till dem gjordes tjugo stolpar med tjugo fotstycken av koppar, men stolparnas krokar och band gjordes av silver. ");
INSERT INTO swef_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","För västra sidan gjordes omhängena femtio alnar långa. Till dem gjordes tio stolpar och tio fotstycken, men stolparnas krokar och band gjordes av silver. ");
INSERT INTO swef_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Också för framsidan, åt öster, gjordes de femtio alnar långa. ");
INSERT INTO swef_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","På ena sidan om porten till förgården gjordes omhängena femton alnar långa med tre stolpar och tre fotstycken, och likaså gjordes omhängena på andra sidan femton alnar långa, med tre stolpar och tre fotstycken, alltså lika på båda sidor om porten till förgården. ");
INSERT INTO swef_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Alla omhängena runt förgården gjordes av tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Fotstyckena till stolparna gjordes av koppar, men stolparnas krokar och band var av silver, och deras knoppar överdrogs med silver. ");
INSERT INTO swef_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Alla förgårdens stolpar försågs med band av silver. ");
INSERT INTO swef_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Draperiet för porten till förgården gjordes i brokig vävnad av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn, tjugo alnar långt och fem alnar högt, efter tygets bredd, i likhet med förgårdens omhängen. ");
INSERT INTO swef_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Till förhänget gjordes fyra stolpar med fyra fotstycken av koppar, men deras krokar och band var av silver, och deras knoppar överdrogs med silver. ");
INSERT INTO swef_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Alla tältpluggarna till tabernaklet och till förgården runt omkring gjordes av koppar. ");
INSERT INTO swef_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Detta är vad som beräknas ha gått åt till tabernaklet, vittnesbördets tabernakel, enligt den beräkning som Mose gav befallning om och som utfördes genom leviterna under ledning av Itamar, prästen Arons son. ");
INSERT INTO swef_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalel, son till Uri, son till Hur av Juda stam, utförde allt som Herren hade gett Mose befallning om. ");
INSERT INTO swef_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Till medhjälpare hade han Oholiab, Ahisamaks son av Dans stam, en konsthantverkare som tänkte ut mönster och kunde göra brokiga vävnader i mörkblått, purpurrött och karmosinrött garn samt fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Det guld som använts till arbetet med att färdigställa hela helgedomen, det guld som hade getts som offer, utgjorde sammanlagt 29 talenter och 730 siklar efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Det silver som gavs av de mönstrade av folkförsamlingen utgjorde 100 talenter och 1 775 siklar efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","En beka per person, det vill säga en halv sikel efter helgedomssikelns vikt, togs upp bland de inmönstrade, var och en som var tjugo år gammal eller mer, 603 550 personer. ");
INSERT INTO swef_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","De hundra talenterna silver användes till att gjuta fotstyckena till helgedomen och till förhänget, 100 talenter till 100 fotstycken, en talent till varje fotstycke. ");
INSERT INTO swef_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","De 1 775 siklarna silver användes till att göra krokar till stolparna och till att överdra deras knoppar och göra band till dem. ");
INSERT INTO swef_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Den koppar som hade getts som offer utgjorde 70 talenter och 2 400 siklar. ");
INSERT INTO swef_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Av den gjorde man fotstyckena till uppenbarelsetältets ingång och kopparaltaret med dess koppargaller och altarets alla tillbehör, ");
INSERT INTO swef_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","vidare fotstyckena till förgården, runt omkring, och fotstyckena till förgårdens port samt tabernaklets och förgårdens alla tältpluggar, runt omkring. ");
INSERT INTO swef_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Av det mörkblå, det purpurröda och det karmosinröda garnet gjorde man vävda kläder för tjänsten i helgedomen. Man gjorde de heliga kläder som Aron skulle ha, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Efoden gjorde man av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Man hamrade ut guldet till tunna plåtar och skar dem i trådar, så att de kunde vävas in med det mörkblå, det purpurröda och det karmosinröda garnet och med det fina lingarnet i konstvävnad. ");
INSERT INTO swef_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Till efoden gjordes axelstycken som fästes ihop med varandra. Vid sina båda ändar fästes den ihop. ");
INSERT INTO swef_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Skärpet som skulle sitta på efoden och hålla ihop den gjordes i samma vävnad och i ett stycke med den: av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Onyxstenarna infattades i flätverk av guld. På dem var namnen på Israels söner ingraverade som på ett sigill. ");
INSERT INTO swef_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Man satte dem på efodens axelstycken som påminnelsestenar för Israels barn, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bröstskölden gjordes i konstvävnad av samma slag som efoden, av guld och av mörkblått, purpurrött och karmosinrött garn och tvinnat fint lingarn. ");
INSERT INTO swef_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Den gjordes fyrkantig och dubbelvikt, en halv aln lång och en halv aln bred. ");
INSERT INTO swef_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","På den satte man fyra rader stenar: i första raden karneol, topas och smaragd, ");
INSERT INTO swef_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","i andra raden granat, safir och kalcedon, ");
INSERT INTO swef_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","i tredje raden hyacint, agat och ametist ");
INSERT INTO swef_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","och i fjärde raden krysolit, onyx och jaspis. Med flätverk av guld omgavs de i sina infattningar. ");
INSERT INTO swef_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Stenarna var tolv efter namnen på Israels söner, en för varje namn. Varje sten bar namnet på en av de tolv stammarna, ingraverat på samma sätt som man graverar sigill. ");
INSERT INTO swef_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Till bröstskölden gjorde man flätade kedjor så som man gör snoddar, och av rent guld. ");
INSERT INTO swef_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Vidare gjorde man två flätverk av guld och två ringar av guld och satte de båda ringarna i två av bröstsköldens hörn. ");
INSERT INTO swef_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Man fäste de två guldsnoddarna vid de båda ringarna i bröstsköldens hörn. ");
INSERT INTO swef_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","De båda snoddarnas andra ändar fäste man vid de två flätverken och satte fast dem vid framkanten på efodens axelstycken. ");
INSERT INTO swef_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Man gjorde två ringar av guld och satte dem i de båda andra hörnen av bröstskölden, vid den kant som var vänd in mot efoden. ");
INSERT INTO swef_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Sedan gjorde man två ringar av guld och satte dem nertill på framsidan av efodens båda axelstycken där efoden fästes ihop ovanför skärpet. ");
INSERT INTO swef_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Man knöt fast bröstskölden med en mörkblå snodd som gick från dess ringar in i efodens ringar, för att den skulle sitta fast ovanför efodens skärp, så att bröstskölden inte skulle lossna från efoden, precis som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Efodkåpan gjordes i vävt tyg, helt och hållet i mörkblått. ");
INSERT INTO swef_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Mitt på kåpan gjordes en öppning, som liknade öppningen på en pansarskjorta. Öppningen hade en kant runt om för att den inte skulle slitas sönder. ");
INSERT INTO swef_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","På kåpans nedre fåll satte man granatäpplen av mörkblått, purpurrött och karmosinrött tvinnat garn. ");
INSERT INTO swef_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Man gjorde bjällror av rent guld och satte dem mellan granatäpplena runt hela fållen på kåpan mellan granatäpplena: ");
INSERT INTO swef_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","en bjällra och ett granatäpple, sedan en bjällra och ett granatäpple, runt fållen på den kåpa som skulle bäras vid tjänstgöringen, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Och man gjorde tunikorna åt Aron och hans söner av en vävnad i fint lingarn, ");
INSERT INTO swef_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","turbanen och högtidshuvorna av fint lingarn, byxorna av tvinnat fint lingarn ");
INSERT INTO swef_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","och bältet av tvinnat fint lingarn och av mörkblått, purpurrött och karmosinrött garn i brokig vävnad, allt så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Den skinande plattan till det heliga diademet gjordes av rent guld, och på den skrev man på samma sätt som man graverar sigill: Helgad åt Herren. ");
INSERT INTO swef_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Man satte fast den upptill på turbanen med en mörkblå snodd, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Så blev allt arbetet på uppenbarelsetältets tabernakel fullbordat. Israels barn utförde det, och de gjorde i allt så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Och de förde fram tabernaklet till Mose, tältet med alla dess tillbehör, hakarna, brädorna, tvärstängerna, stolparna och fotstyckena, ");
INSERT INTO swef_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","överdraget av rödfärgade fårskinn, överdraget av tahasskinn, det täckande förhänget, ");
INSERT INTO swef_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","vittnesbördets ark med dess stänger och nådastolen, ");
INSERT INTO swef_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","bordet med alla dess tillbehör och skådebröden, ");
INSERT INTO swef_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ljusstaken av rent guld, lamporna som skulle sättas på den och alla andra tillbehör till den, oljan till ljusstaken, ");
INSERT INTO swef_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","altaret av guld, smörjelseoljan och den väldoftande rökelsen, draperiet för ingången till tältet, ");
INSERT INTO swef_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kopparaltaret med tillhörande koppargaller, stänger och alla tillbehör, karet med dess fotställning, ");
INSERT INTO swef_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","omhängena till förgården, dess stolpar och fotstycken, draperiet för porten till förgården, dess linor och tältpluggar, alla redskap för arbetet vid uppenbarelsetältets tabernakel ");
INSERT INTO swef_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","samt de vävda kläderna till tjänsten i helgedomen, prästen Arons heliga kläder och hans söners prästkläder. ");
INSERT INTO swef_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Så som Herren hade befallt Mose hade Israels barn i allt utfört hela arbetet. ");
INSERT INTO swef_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose inspekterade hela arbetet, och se, de hade utfört det så som Herren hade befallt. Så hade de gjort. Och Mose välsignade dem. ");
INSERT INTO swef_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","”På första dagen i den första månaden ska du resa uppenbarelsetältets tabernakel. ");
INSERT INTO swef_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Där ska du ställa vittnesbördets ark och avskärma den med förhänget. ");
INSERT INTO swef_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Du ska bära in bordet och lägga upp det som ska vara på det. Och du ska bära in ljusstaken och sätta upp lamporna på den. ");
INSERT INTO swef_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Du ska ställa det gyllene rökelsealtaret framför vittnesbördets ark och sätta upp draperiet för ingången till tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Brännofferaltaret ska du ställa framför ingången till uppenbarelsetältets tabernakel. ");
INSERT INTO swef_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Du ska ställa karet mellan uppenbarelsetältet och altaret och hälla vatten i det. ");
INSERT INTO swef_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Du ska sätta upp förgårdens omhängen runt omkring och hänga upp draperiet för porten till förgården. ");
INSERT INTO swef_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Och du ska ta smörjelseoljan och smörja tabernaklet och allt som finns i det och helga det tillsammans med alla dess tillbehör, så att det blir heligt. ");
INSERT INTO swef_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Du ska smörja brännofferaltaret och alla dess tillbehör och helga altaret. Det blir då högheligt. ");
INSERT INTO swef_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Du ska också smörja karet och dess fotställning och helga det. ");
INSERT INTO swef_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Sedan ska du föra fram Aron och hans söner till uppenbarelsetältets ingång och tvätta dem med vatten. ");
INSERT INTO swef_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Och du ska sätta på Aron de heliga kläderna och smörja honom och helga honom till präst åt mig. ");
INSERT INTO swef_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Hans söner ska du föra fram och sätta på dem tunikor, ");
INSERT INTO swef_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","och du ska smörja dem så som du smorde deras far till att vara präster åt mig. Denna smörjelse ska för dem innebära ett evigt prästadöme, släkte efter släkte.” ");
INSERT INTO swef_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Och Mose gjorde så. Han gjorde i allt som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I första månaden av andra året, på första dagen i månaden blev tabernaklet uppsatt. ");
INSERT INTO swef_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Då satte Mose upp tabernaklet. Han lade ut dess fotstycken, ställde upp brädorna, sköt in tvärstängerna och satte upp stolparna. ");
INSERT INTO swef_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Han bredde ut tältet över tabernaklet och tältöverdragen ovanpå det, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Han tog vittnesbördet och lade in det i arken och satte stängerna på arken. Och han lade nådastolen ovanpå arken. ");
INSERT INTO swef_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sedan förde han in arken i tabernaklet och satte upp det täckande förhänget och skärmade av vittnesbördets ark, så som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Han ställde också bordet i uppenbarelsetältet, vid tabernaklets norra sida, utanför förhänget, ");
INSERT INTO swef_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","och lade upp bröd på det inför Herrens ansikte, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Och han ställde in ljusstaken i uppenbarelsetältet mitt emot bordet på tabernaklets södra sida ");
INSERT INTO swef_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","och satte upp lamporna inför Herrens ansikte, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Han ställde in det förgyllda altaret i uppenbarelsetältet framför förhänget ");
INSERT INTO swef_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","och tände väldoftande rökelse på det, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Han satte upp draperiet framför ingången till tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Brännofferaltaret ställde han vid ingången till uppenbarelsetältets tabernakel och offrade på det brännoffer och matoffer, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Han ställde karet mellan uppenbarelsetältet och altaret och fyllde det med vatten att tvätta sig i. ");
INSERT INTO swef_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose och Aron och hans söner tvättade sina händer och fötter med vatten ur det. ");
INSERT INTO swef_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","När de skulle gå in i uppenbarelsetältet eller träda fram till altaret tvättade de sig, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Och han satte upp förgårdens omhängen runt omkring tabernaklet och altaret och hängde upp draperiet framför porten till förgården. Så fullbordade Mose arbetet. ");
INSERT INTO swef_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Då täckte molnskyn uppenbarelsetältet, och Herrens härlighet uppfyllde tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose kunde inte gå in i uppenbarelsetältet, eftersom molnskyn vilade över det och Herrens härlighet uppfyllde tabernaklet. ");
INSERT INTO swef_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Så ofta molnskyn höjde sig från tabernaklet bröt Israels barn upp. Så gjorde de under hela sin vandring. ");
INSERT INTO swef_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Men så länge molnskyn inte höjde sig bröt de inte upp, förrän den dag då den höjde sig igen. ");
INSERT INTO swef_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Herrens molnsky vilade över tabernaklet om dagen, och eld var i den om natten. Så var det inför ögonen på hela Israels folk under hela deras vandring. ");
INSERT INTO swef_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Herren kallade på Mose och talade till honom från uppenbarelsetältet. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Säg till Israels barn: När någon bland er vill bära fram ett offer åt Herren ska ni ta ert offer av boskapen, antingen av nöt eller småboskap. ");
INSERT INTO swef_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Om han vill bära fram ett brännoffer från nötboskapen, ska han ta ett felfritt djur av hankön och föra fram det till uppenbarelsetältets ingång för att han ska räknas som välbehaglig inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Han ska lägga sin hand på brännofferdjurets huvud, och det blir då välbehagligt och till försoning för honom. ");
INSERT INTO swef_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Han ska slakta ungtjuren inför Herrens ansikte, och Arons söner, prästerna, ska bära fram blodet och stänka det runt omkring på altaret som står vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Sedan ska han flå brännofferdjuret och stycka det, ");
INSERT INTO swef_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","och prästen Arons söner ska göra upp eld på altaret och lägga ved på elden. ");
INSERT INTO swef_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Sedan ska Arons söner, prästerna, lägga styckena, huvudet och fettet på veden som brinner på altaret. ");
INSERT INTO swef_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Men inälvorna och fötterna ska tvättas i vatten och därefter ska prästen bränna alltsammans på altaret. Det är ett brännoffer, ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Om han vill bära fram ett brännoffer av småboskapen, av fåren eller getterna, ska han ta ett felfritt djur av hankön. ");
INSERT INTO swef_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Han ska slakta det inför Herrens ansikte vid norra sidan av altaret, och Arons söner, prästerna, ska stänka blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Han ska stycka djuret i dess delar, tillsammans med huvudet och fettet, och prästen ska lägga dem på veden som brinner på altaret. ");
INSERT INTO swef_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Men inälvorna och fötterna ska tvättas i vatten och därefter ska prästen offra alltsamman och bränna det på altaret. Det är ett brännoffer, ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Och om han vill bära fram åt Herren ett brännoffer av fåglar, ska han ta sitt offer av turturduvor eller unga duvor. ");
INSERT INTO swef_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Prästen ska bära fram djuret till altaret och vrida huvudet av det och bränna det på altaret. Blodet ska kramas ut på altarets sida. ");
INSERT INTO swef_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Men krävan med dess orenhet ska han ta ut och kasta på askhögen vid östra sidan av altaret. ");
INSERT INTO swef_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Han ska fläka upp fågeln vid vingarna, dock utan att slita loss dem, och prästen ska bränna den på altaret, på veden som ligger på elden. Det är ett brännoffer, ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","När någon vill bära fram ett matoffer åt Herren, ska hans offer bestå av fint mjöl. Han ska hälla olja på det och lägga rökelse ovanpå. ");
INSERT INTO swef_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Han ska bära fram det till Arons söner, prästerna, och prästen ska ta en handfull av mjölet och oljan samt all rökelsen och bränna det på altaret som ett påminnelseoffer. Det är ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Det som är över av matoffret ska tillhöra Aron och hans söner. Bland Herrens eldsoffer är det högheligt. ");
INSERT INTO swef_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","När du vill bära fram ett matoffer av det som bakas i ugn, ska det vara av fint mjöl, osyrade kakor blandade med olja och osyrade tunnkakor smorda med olja. ");
INSERT INTO swef_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Om ditt offer är ett matoffer som tillreds på plåt, ska det vara av fint mjöl, osyrat och blandat med olja. ");
INSERT INTO swef_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Du ska bryta sönder det i stycken och hälla olja på det. Det är ett matoffer. ");
INSERT INTO swef_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Om ditt offer är ett matoffer som tillreds i panna, ska det tillredas av fint mjöl med olja. ");
INSERT INTO swef_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Varje matoffer som är tillrett på något av dessa sätt ska du föra fram till Herren. Det ska bäras fram till prästen och han ska ta det till altaret. ");
INSERT INTO swef_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Sedan ska prästen ta den del av matoffret som utgör påminnelseoffret och bränna det på altaret. Det är ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Det som blir över av matoffret ska tillhöra Aron och hans söner. Bland Herrens eldsoffer är det högheligt. ");
INSERT INTO swef_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Inget matoffer som ni bär fram åt Herren ska vara syrat, för ni ska inte bränna något av surdeg eller honung som eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Som förstlingsoffer ska ni bära fram sådant åt Herren, men på altaret får det inte komma för att vara en ljuvlig doft. ");
INSERT INTO swef_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Alla dina matoffer ska du beströ med salt. Du ska inte låta saltet i din Guds förbund fattas på ditt matoffer. Till alla dina offer ska du offra salt. ");
INSERT INTO swef_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Om du vill bära fram ett matoffer åt Herren av den första skörden, ska du till ett sådant matoffer bära fram ax av grönskuren säd, rostade över eld och sönderstötta. ");
INSERT INTO swef_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Du ska hälla olja på offret och lägga rökelse på det. Det är ett matoffer. ");
INSERT INTO swef_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Prästen ska som påminnelseoffer bränna en del av de sönderstötta axen och oljan tillsammans med all rökelsen. Det är ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Om någon vill bära fram ett gemenskapsoffer och han då vill ta sitt offer av nötboskapen, ska han föra fram ett felfritt djur inför Herrens ansikte, antingen av hankön eller honkön. ");
INSERT INTO swef_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Han ska lägga sin hand på offerdjurets huvud och sedan slakta det vid ingången till uppenbarelsetältet, och Arons söner, prästerna, ska stänka blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Av gemenskapsoffret ska han som eldsoffer åt Herren bära fram det fett som omsluter inälvorna och allt det fett som sitter på dem, ");
INSERT INTO swef_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","de båda njurarna med det fett som sitter på dem vid höftmusklerna och leverfettet som han ska ta loss tillsammans med njurarna. ");
INSERT INTO swef_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Sedan ska Arons söner bränna det på altaret, ovanpå brännoffret som ligger på den brinnande veden. Detta är ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Om någon vill bära fram ett gemenskapsoffer åt Herren av småboskapen, ska han ta ett felfritt djur av hankön eller honkön. ");
INSERT INTO swef_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Om han vill offra ett får, ska han föra fram det inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Och han ska lägga sin hand på offerdjurets huvud och sedan slakta det framför uppenbarelsetältet och Arons söner ska stänka blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Av gemenskapsoffret ska han som eldsoffer åt Herren offra fettet, hela fettsvansen, avstyckad vid ryggraden, det fett som omsluter inälvorna och allt det fett som sitter på dem, ");
INSERT INTO swef_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","båda njurarna med det fett som sitter på dem vid höftmusklerna samt leverfettet, som han ska ta loss tillsammans med njurarna. ");
INSERT INTO swef_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Och prästen ska bränna det på altaret. Det är ett matoffer, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Om någon vill offra en get, ska han föra fram den inför Herrens ansikte, ");
INSERT INTO swef_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","lägga sin hand på dess huvud och slakta den framför uppenbarelsetältet och Arons söner ska stänka blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Som ett eldsoffer åt Herren ska han offra det fett som omsluter inälvorna och allt det fett som sitter på dem, ");
INSERT INTO swef_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","båda njurarna med det fett som sitter på dem vid höftmusklerna samt leverfettet, som han ska ta loss tillsammans med njurarna. ");
INSERT INTO swef_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sedan ska prästen bränna det på altaret. Det är ett matoffer, ett eldsoffer till en ljuvlig doft. Allt fett tillhör Herren. ");
INSERT INTO swef_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Detta ska vara en evig stadga för er från släkte till släkte, var ni än bor. Inget fett och inget blod ska ni förtära. ");
INSERT INTO swef_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Säg till Israels barn: Om någon syndar av misstag mot något av Herrens bud och gör något som inte får göras, ");
INSERT INTO swef_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ska den smorde prästen, om det är han som har syndat och därmed dragit skuld över folket, offra en felfri ungtjur åt Herren till syndoffer för den synd han har begått. ");
INSERT INTO swef_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Han ska föra fram tjuren inför Herrens ansikte till uppenbarelsetältets ingång och han ska lägga sin hand på tjurens huvud och sedan slakta tjuren inför Herren. ");
INSERT INTO swef_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Den smorde prästen ska ta av tjurens blod och bära in det i uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","och han ska doppa sitt finger i blodet och stänka det sju gånger inför Herrens ansikte framför förhänget till helgedomen. ");
INSERT INTO swef_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Därefter ska prästen stryka med blodet på hornen på den väldoftande rökelsens altare, som står inför Herrens ansikte i uppenbarelsetältet. Men resten av blodet från tjuren ska han hälla ut vid foten av brännofferaltaret, som står vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Och allt fett på syndoffertjuren ska han avlägsna, det fett som omsluter inälvorna och allt det fett som sitter på dem, ");
INSERT INTO swef_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","båda njurarna med det fett som sitter på dem vid höftmusklerna samt leverfettet, som han ska ta loss tillsammans med njurarna. ");
INSERT INTO swef_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Fettet ska tas ut så som det tas ut ur tjuren för gemenskapsoffret. Och prästen ska bränna det på brännofferaltaret. ");
INSERT INTO swef_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Men tjurens hud och allt hans kött, hans huvud, fötter, inälvor och orenhet, ");
INSERT INTO swef_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","resten av tjuren, ska han föra bort utanför lägret till en ren plats, där man slår ut askan, och bränna upp det i eld som brinner på ved. På den plats där man slår ut askan ska det brännas. ");
INSERT INTO swef_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Om Israels hela församling försyndar sig utan att folket märker det och de bryter mot något av Herrens bud och gör sådant som inte får göras och därigenom drar på sig skuld, ");
INSERT INTO swef_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","och sedan den synd de har begått blir känd, då ska församlingen offra en ungtjur till syndoffer. De ska föra fram den inför uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Och de äldste i församlingen ska lägga sina händer på tjurens huvud inför Herrens ansikte, och man ska slakta tjuren inför Herren. ");
INSERT INTO swef_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Den smorde prästen ska bära något av tjurens blod in i uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","och prästen ska doppa sitt finger i blodet och stänka sju gånger framför förhänget inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Därefter ska han stryka en del av blodet på hornen på altaret som står inför Herrens ansikte i uppenbarelsetältet. Men resten av blodet ska han hälla ut vid foten av brännofferaltaret, som står vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Allt fett ska han ta ut ur tjuren och bränna det på altaret. ");
INSERT INTO swef_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Och han ska göra med tjuren som han gjorde med syndoffertjuren, så ska han göra med den. När prästen bringar försoning för dem, får de förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Sedan ska han föra ut tjuren utanför lägret och bränna den, så som han skulle göra med den förra tjuren. Detta är syndoffret för församlingen. ");
INSERT INTO swef_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Om en ledare syndar genom att han av misstag bryter mot något av Herren sin Guds bud och gör sådant som inte får göras och han därigenom drar på sig skuld, ");
INSERT INTO swef_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","eller om han av någon får veta vilken synd han har begått, ska han som sitt offer föra fram en bock, ett felfritt djur av hankön. ");
INSERT INTO swef_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Han ska lägga sin hand på bockens huvud och sedan slakta den inför Herrens ansikte på samma plats som man slaktar brännoffret. Det är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Prästen ska ta något av syndoffrets blod på sitt finger och stryka på brännofferaltarets horn, men resten av blodet ska han hälla ut vid foten av brännofferaltaret. ");
INSERT INTO swef_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Allt fettet ska han bränna på altaret, så som man gör med fettet vid gemenskapsoffret. Och när prästen bringar försoning för honom till rening från hans synd, får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Om någon av folket i landet syndar av misstag genom att göra sådant som inte får göras enligt Herrens bud och därigenom drar på sig skuld, ");
INSERT INTO swef_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","eller om han av någon får veta vilken synd han har begått, så ska han som sitt offer för den begångna synden föra fram en felfri get av honkön. ");
INSERT INTO swef_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Han ska lägga sin hand på syndofferdjurets huvud och sedan slakta det på den plats där brännofferdjuren slaktas. ");
INSERT INTO swef_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Prästen ska ta något av blodet på sitt finger och stryka det på brännofferaltarets horn, men resten av blodet ska han hälla ut vid altarets fot. ");
INSERT INTO swef_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Allt fettet ska han ta ut så som fettet tas ut ur djuret till gemenskapsoffret och prästen ska bränna det på altaret till en ljuvlig doft för Herren. Och när prästen bringar försoning för honom, får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Men om någon vill offra ett lamm till syndoffer, ska han föra fram ett felfritt djur av honkön. ");
INSERT INTO swef_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Han ska lägga sin hand på syndofferdjurets huvud och slakta det till syndoffer på samma plats som man slaktar brännofferdjuren. ");
INSERT INTO swef_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Prästen ska ta av syndoffrets blod på sitt finger och stryka det på brännofferaltarets horn. Men resten av blodet ska han hälla ut vid altarets fot. ");
INSERT INTO swef_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Allt fettet ska han ta ut så som fettet tas ut ur lammet till gemenskapsoffret och prästen ska bränna det på altaret, ovanpå Herrens eldsoffer. Och när prästen bringar försoning för den synd han har begått, får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Om någon hör edsförpliktelsen och kan vittna om något som han själv sett eller på annat sätt fått reda på, men inte berättar det, då syndar han och bär på missgärning. ");
INSERT INTO swef_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Eller om någon utan att märka det rör vid något orent, antingen den döda kroppen av ett orent vilddjur eller den döda kroppen av ett orent boskapsdjur eller den döda kroppen av något slags orent smådjur, så blir han oren genom det och drar på sig skuld. ");
INSERT INTO swef_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Eller om han utan att märka det rör vid en människas orenhet, vad det än är som kan orena, och han sedan får veta det, så drar han på sig skuld. ");
INSERT INTO swef_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Eller om någon utan att märka det tanklöst avlägger en ed med sina läppar – att göra ont eller gott, vad man än i tanklöshet kan styrka med en ed – och han sedan kommer till insikt om vad han gjort, så har han dragit på sig skuld i något av dessa avseenden. ");
INSERT INTO swef_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Då ska han, när han dragit på sig skuld i något av dessa fall, bekänna den synd han har begått. ");
INSERT INTO swef_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Som offer för sin synd ska han föra fram åt Herren ett hondjur av småboskapen, antingen ett tacklamm eller en killing, till syndoffer. Och prästen ska bringa försoning för honom för hans synd. ");
INSERT INTO swef_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Men om han inte har råd med ett sådant djur, ska han som offer för sin synd bära fram åt Herren två turturduvor eller två unga duvor, en till syndoffer och en till brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Han ska bära fram dem till prästen, som först ska offra den som är avsedd till syndoffer. Han ska vrida huvudet av den invid halsen, men utan att ta bort det, ");
INSERT INTO swef_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","och han ska stänka något av syndoffrets blod på altarets sida. Men resten av blodet ska kramas ut vid foten av altaret. Det är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Den andra duvan ska han offra som brännoffer på föreskrivet sätt. När prästen bringar försoning för honom för den synd han har begått, får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Men om han inte har råd med två turturduvor eller två unga duvor, ska han som offer för sin synd bära fram en tiondels efa fint mjöl till syndoffer. Men han ska inte hälla någon olja på mjölet eller lägga någon rökelse på det, eftersom det är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Han ska bära fram det till prästen, och prästen ska ta en handfull av det till påminnelseoffer och bränna det på altaret, ovanpå Herrens eldsoffer. Det är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Och när prästen bringar försoning för honom för den synd han har begått i något av dessa avseenden, får han förlåtelse. Resten ska tillhöra prästen liksom vid matoffret. ");
INSERT INTO swef_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Om någon av misstag begår en trolös handling genom att undanhålla något som är helgat åt Herren, ska han som skuldoffer föra fram åt Herren en felfri bagge av småboskapen efter det värde du bestämmer i silver, ett visst antal siklar efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Han ska ersätta det han har undanhållit av det helgade och lägga till en femtedel. Detta ska han ge åt prästen, och när prästen bringar försoning för honom genom skuldofferbaggen får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Om någon syndar utan att veta det och bryter mot något Herrens bud och gör sådant som inte får göras, drar han på sig skuld och bär på missgärning. ");
INSERT INTO swef_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Han ska som skuldoffer föra fram till prästen en felfri bagge av småboskapen efter det värde du bestämmer. Och när prästen bringar försoning för honom för den synd han har begått av misstag och utan att veta det får han förlåtelse. ");
INSERT INTO swef_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Det är ett skuldoffer, eftersom han har dragit på sig skuld inför Herren. ");
INSERT INTO swef_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Om någon syndar och handlar trolöst mot Herren genom att ljuga för sin nästa om något som denne anförtrott honom eller överlämnat i hans vård, eller om något som han har tagit med våld, eller ifall han berövat sin nästa något genom utpressning, ");
INSERT INTO swef_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","eller om han har hittat något borttappat och ljuger om det och svär falskt i någon sak, vad det än är som en människa kan göra sig skyldig till, ");
INSERT INTO swef_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","då ska den som har syndat på detta sätt och därmed dragit på sig skuld återlämna det han har tagit med våld eller tillägnat sig genom utpressning eller det som anförtrotts honom, eller det borttappade som han har hittat, ");
INSERT INTO swef_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","eller vad det än gäller där han svurit falskt. Han ska ersätta det till dess fulla värde och lägga till en femtedel. Han ska ge det åt ägaren samma dag som han bär fram sitt skuldoffer. ");
INSERT INTO swef_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Han ska föra fram sitt skuldoffer inför Herren, en felfri bagge av småboskapen ska han föra fram till prästen, efter det värde du bestämmer. ");
INSERT INTO swef_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Och när prästen så bringar försoning för honom inför Herrens ansikte, får han förlåtelse för vad han än har gjort som har dragit skuld över honom. ");
INSERT INTO swef_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ge Aron och hans söner denna befallning: Detta är lagen om brännoffret: Brännoffret ska ligga på altarets härd hela natten till morgonen och elden på altaret ska därigenom hållas brinnande. ");
INSERT INTO swef_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Prästen ska klä sig i sin livrock av linne och ta på sig byxor av linne närmast kroppen. Han ska ta bort askan efter brännoffret som elden har förtärt på altaret och lägga den vid sidan av altaret. ");
INSERT INTO swef_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Sedan ska han ta av sig kläderna och klä sig i andra kläder och föra bort askan till en ren plats utanför lägret. ");
INSERT INTO swef_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Men elden på altaret ska hållas brinnande och får inte slockna. Varje morgon ska prästen där tända ny ved, och på veden ska han lägga brännoffret och bränna fettstyckena av gemenskapsoffret. ");
INSERT INTO swef_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Elden ska alltid hållas brinnande på altaret. Den får inte slockna. ");
INSERT INTO swef_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Detta är lagen om matoffret: Arons söner ska bära fram det inför Herrens ansikte till altaret. ");
INSERT INTO swef_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Och prästen ska ta en handfull av offret, av det fina mjölet som hör till matoffret och av oljan, dessutom all rökelsen som ligger på matoffret. Han ska bränna det på altaret till en ljuvlig doft, som ett påminnelseoffer till Herren. ");
INSERT INTO swef_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Det som är över av det ska Aron och hans söner äta. Osyrat ska det ätas på en helig plats. I förgården till uppenbarelsetältet ska de äta det. ");
INSERT INTO swef_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Det ska inte bakas med surdeg. Detta är deras andel som jag har gett dem av mina eldsoffer. Det är högheligt liksom syndoffret och skuldoffret. ");
INSERT INTO swef_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Alla av manligt kön bland Arons barn ska äta det. Det ska vara deras eviga rätt av Herrens eldsoffer från släkte till släkte. Var och en som rör vid det blir helig. ");
INSERT INTO swef_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Detta är den offergåva som Aron och hans söner ska offra åt Herren på den dag då någon av dem blir smord: en tiondels efa fint mjöl som det dagliga matoffret, hälften på morgonen och hälften på kvällen. ");
INSERT INTO swef_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Det ska bakas på plåt med olja, och när det är blandat ska du bära fram det. Du ska offra det sönderdelat som när man offrar ett matoffer i stycken, till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Den präst bland Arons söner som blir smord i hans ställe ska göra det. Detta ska vara en evig stadga. Som ett heloffer ska det brännas åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","En prästs matoffer ska alltid vara ett heloffer. Det får inte ätas. ");
INSERT INTO swef_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Säg till Aron och hans söner: Detta är lagen om syndoffret: På samma plats som brännofferdjuret slaktas ska syndofferdjuret slaktas inför Herrens ansikte. Det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Den präst som offrar syndoffret ska äta det. På en helig plats ska det ätas, i förgården till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Var och en som rör vid köttet blir helig. Om något av blodet stänks på någons kläder, ska man tvätta av det nerstänkta stället på en helig plats. ");
INSERT INTO swef_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Det lerkärl som offerköttet har kokats i ska slås sönder, men om det har kokats i ett kopparkärl ska det skuras och sköljas med vatten. ");
INSERT INTO swef_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Alla av manligt kön bland prästerna får äta det. Det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Men sådant syndoffer vars blod bärs in i uppenbarelsetältet för att bringa försoning i helgedomen får inte ätas. Det ska brännas upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Detta är lagen om skuldoffret: Det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","På samma plats som man slaktar brännofferdjuret ska man slakta skuldofferdjuret och man ska stänka blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Allt fettet ska man offra, svansen och det fett som omsluter inälvorna, ");
INSERT INTO swef_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","de båda njurarna med det fett som sitter på dem vid höftmusklerna samt leverfettet som man ska ta loss tillsammans med njurarna. ");
INSERT INTO swef_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Prästen ska bränna det på altaret till ett eldsoffer åt Herren. Det är ett skuldoffer. ");
INSERT INTO swef_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alla av manligt kön bland prästerna ska äta det. På en helig plats ska det ätas. Det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Det som gäller för syndoffret ska också gälla för skuldoffret. Samma lag ska gälla för dem båda. Offerköttet ska tillhöra den präst som bringar försoning med det. ");
INSERT INTO swef_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","När en präst bär fram brännoffer för någon, ska huden av brännofferdjuret som bärs fram tillhöra den prästen. ");
INSERT INTO swef_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ett matoffer som är bakat i ugn eller tillrett i gryta eller på plåt ska alltid tillfalla den präst som bär fram det. ");
INSERT INTO swef_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Men ett matoffer som är blandat med olja eller som bärs fram torrt ska alltid tillfalla Arons söner gemensamt, den ene såväl som den andre. ");
INSERT INTO swef_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Detta är lagen om gemenskapsoffret, när ett sådant bärs fram åt Herren: ");
INSERT INTO swef_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Om någon vill offra det som ett gemenskapsoffer, ska han förutom det slaktdjur som hör till gemenskapsoffret bära fram osyrade kakor blandade med olja, osyrade tunnkakor smorda med olja och fint mjöl, hopknådat i form av kakor som är blandade med olja. ");
INSERT INTO swef_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Tillsammans med kakor av syrat bröd ska han som offergåva bära fram det slaktdjur som hör till det tackoffer han offrar som gemenskapsoffer. ");
INSERT INTO swef_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Av detta ska han bära fram en kaka av varje offer som en gåva åt Herren. Denna ska tillhöra den präst som stänker gemenskapsoffrets blod på altaret. ");
INSERT INTO swef_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Köttet av det slaktdjur som hör till det gemenskapsoffer som bärs fram som gemenskapsoffer ska ätas samma dag det har offrats. Ingenting av det får lämnas kvar till nästa morgon. ");
INSERT INTO swef_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Om däremot det slaktoffer som någon vill bära fram är ett löftesoffer eller ett frivilligt offer, ska även det offerdjuret ätas samma dag som det har offrats. Men det som blivit över får ätas nästa dag. ");
INSERT INTO swef_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Skulle ändå något av offerköttet bli kvar, ska det brännas upp i eld på tredje dagen. ");
INSERT INTO swef_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Om någon på tredje dagen äter av köttet från gemenskapsoffret, blir offret inte välbehagligt. Han som offrat det får inte räkna sig det tillgodo, utan köttet anses som orent. Den som äter av det kommer att bära på skuld. ");
INSERT INTO swef_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Inte heller får man äta det kött som varit i beröring med något orent, utan det ska brännas upp i eld. I övrigt kan köttet ätas av var och en som är ren. ");
INSERT INTO swef_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Men den som äter kött av Herrens gemenskapsoffer medan han är oren, han ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Och om någon rör vid något orent, en människas orenhet eller ett orent djur eller vilken annan orenhet som helst och han ändå äter kött av Herrens gemenskapsoffer, ska han utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Säg till Israels barn: Ni ska inte äta något fett av kor, får eller getter. ");
INSERT INTO swef_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Fettet av ett självdött eller ihjälrivet djur får användas till alla slags behov, men ni ska inte äta det, ");
INSERT INTO swef_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","för var och en som äter fettet av något djur som bärs fram som eldsoffer åt Herren ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Och ni ska inte förtära något blod, varken av fåglar eller boskap, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Var och en som förtär blod ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Säg till Israels barn: Den som vill offra ett gemenskapsoffer åt Herren ska av sitt gemenskapsoffer bära fram sin offergåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Med egna händer ska han bära fram Herrens eldsoffer. Fettet och bringan ska han bära fram, och bringan ska lyftas som ett lyftoffer inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Fettet ska prästen bränna på altaret, men bringan ska tillhöra Aron och hans söner. ");
INSERT INTO swef_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Också det högra lårstycket ska ni ge åt prästen som en gåva av era gemenskapsoffer. ");
INSERT INTO swef_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Den bland Arons söner som offrar gemenskapsoffrets blod och fettet ska ha det högra lårstycket som sin andel. ");
INSERT INTO swef_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Av israeliternas gemenskapsoffer tar jag lyftofferbringan och offergärdslåret och ger dem åt prästen Aron och åt hans söner som en evig rätt från Israels barn. ");
INSERT INTO swef_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Detta är Arons och hans söners smörjelselott av Herrens eldsoffer, den lott som de fick den dag de fördes fram för att bli Herrens präster. ");
INSERT INTO swef_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Denna lott skulle de enligt Herrens befallning få av Israels barn som en evig rätt, släkte efter släkte, på den dag då han smorde dem. ");
INSERT INTO swef_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Detta är lagen om brännoffret, matoffret, syndoffret, skuldoffret, prästvigningsoffret och gemenskapsoffret. ");
INSERT INTO swef_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Herren gav denna lag åt Mose på Sinai berg den dag då han befallde Israels barn att de skulle bära fram sina offer åt Herren i Sinai öken. ");
INSERT INTO swef_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","”För fram Aron och hans söner tillsammans med honom, deras kläder och smörjelseoljan samt syndoffertjuren och de två baggarna och korgen med de osyrade bröden. ");
INSERT INTO swef_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Samla sedan hela församlingen vid ingången till uppenbarelsetältet.” ");
INSERT INTO swef_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose gjorde som Herren hade befallt honom, och församlingen samlades vid uppenbarelsetältets ingång. ");
INSERT INTO swef_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Och Mose sade till församlingen: ”Detta är vad Herren har befallt mig att göra.” ");
INSERT INTO swef_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Han förde fram Aron och hans söner och tvättade dem med vatten. ");
INSERT INTO swef_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Och han satte tunikan på Aron och spände på honom bältet, klädde på honom kåpan, satte fast efoden med efodens skärp och fäste med det ihop alltsamman på honom. ");
INSERT INTO swef_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Han satte på honom bröstskölden och lade in urim och tummim i skölden. ");
INSERT INTO swef_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Han satte också turbanen på hans huvud och framtill på turbanen satte han den skinande plattan av guld, det heliga diademet, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Och Mose tog smörjelseoljan och smorde tabernaklet och allt som fanns i det och helgade det. ");
INSERT INTO swef_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Han stänkte oljan sju gånger på altaret och smorde altaret och alla dess tillbehör och karet med dess fotställning för att helga dem. ");
INSERT INTO swef_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Han hällde en del av smörjelseoljan på Arons huvud och smorde honom för att helga honom. ");
INSERT INTO swef_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Och Mose förde fram Arons söner och satte på dem tunikor, spände på dem bälten och band på dem huvor, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mose förde fram syndoffertjuren, och Aron och hans söner lade sina händer på syndoffertjurens huvud. ");
INSERT INTO swef_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Sedan slaktades den, och Mose tog blodet och strök med sitt finger runt omkring på altarets horn och renade altaret. Men resten av blodet hällde han ut vid foten av altaret och helgade det för att bringa försoning för det. ");
INSERT INTO swef_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Och han tog allt det fett som satt på inälvorna, leverfettet och de båda njurarna med deras fett, och Mose brände det på altaret. ");
INSERT INTO swef_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Men resten av tjuren, hud och kött och orenhet, brände han upp i eld utanför lägret, så som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Och han förde fram brännofferbaggen, och Aron och hans söner lade sina händer på baggens huvud. ");
INSERT INTO swef_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Sedan slaktades den och Mose stänkte blodet runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Han styckade baggens kropp och brände huvudet och styckena och istret. ");
INSERT INTO swef_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Inälvorna och benen tvättade han i vatten. Sedan brände Mose hela baggen på altaret. Det var ett brännoffer till en ljuvlig doft, ett eldsoffer åt Herren, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Därefter förde han fram den andra baggen, prästvigningsbaggen, och Aron och hans söner lade händerna på baggens huvud. ");
INSERT INTO swef_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Sedan slaktades den och Mose tog av blodet och strök på Arons högra örsnibb, tummen på hans högra hand och stortån på hans högra fot. ");
INSERT INTO swef_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Han förde fram Arons söner och Mose strök något av blodet på deras högra örsnibb, tummen på deras högra hand och stortån på deras högra fot. Men resten av blodet stänkte Mose runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Sedan tog han fettet, svansen och allt det fett som satt på inälvorna, leverfettet och de båda njurarna med deras fett och det högra lårstycket. ");
INSERT INTO swef_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Och ur korgen med de osyrade bröden som stod inför Herrens ansikte tog han en osyrad kaka, en oljebrödskaka och en tunnkaka och lade dem på fettstyckena och det högra lårstycket. ");
INSERT INTO swef_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Allt detta lade han i händerna på Aron och hans söner, och de lyfte det som ett lyftoffer inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Sedan tog Mose det ur deras händer och brände det på altaret, ovanpå brännoffret. Det var ett prästvigningsoffer till en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Och Mose tog bringan – den var Moses del av prästvigningsoffrets bagge – och lyfte den som ett lyftoffer inför Herrens ansikte, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Och Mose tog av smörjelseoljan och av blodet på altaret och stänkte på Aron och hans kläder, på hans söner och hans söners kläder. Så helgade han Aron och hans kläder, hans söner och hans söners kläder. ");
INSERT INTO swef_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Sedan sade Mose till Aron och hans söner: ”Koka köttet vid ingången till uppenbarelsetältet, och där ska ni äta det tillsammans med brödet som är i prästvigningskorgen, så som jag har befallt: Aron och hans söner ska äta det. ");
INSERT INTO swef_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Men det som blir kvar av köttet eller av brödet ska ni bränna upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Under sju dagar ska ni inte lämna uppenbarelsetältets ingång, inte förrän era prästvigningsdagar är över, för er prästvigning ska vara i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Herren har befallt att så som det har gått till i dag ska det också ske i fortsättningen, för att försoning ska bringas för er. ");
INSERT INTO swef_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vid ingången till uppenbarelsetältet ska ni stanna kvar i sju dygn, dag och natt, och ni ska iaktta vad Herren har befallt er att iaktta för att ni inte ska dö. Detta har jag fått befallning om.” ");
INSERT INTO swef_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Och Aron och hans söner gjorde allt som Herren hade befallt genom Mose. ");
INSERT INTO swef_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","På åttonde dagen kallade Mose till sig Aron och hans söner och de äldste i Israel. ");
INSERT INTO swef_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Han sade till Aron: ”Ta dig en tjurkalv till syndoffer och en bagge till brännoffer, båda felfria, och för fram dem inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Och säg till Israels barn: Ta en bock till syndoffer och en kalv och ett lamm, båda ettåriga och felfria, till brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ta dessutom en tjur och en bagge till gemenskapsoffer för att offra dem inför Herrens ansikte och dessutom ett matoffer blandat med olja, för i dag ska Herren uppenbara sig för er.” ");
INSERT INTO swef_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","De tog det som Mose hade gett befallning om och förde fram det inför uppenbarelsetältet och hela församlingen trädde fram och ställde sig inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Då sade Mose: ”Detta är vad Herren har befallt er att göra för att Herrens härlighet ska visa sig för er.” ");
INSERT INTO swef_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Och Mose sade till Aron: ”Träd fram till altaret och offra ditt syndoffer och ditt brännoffer och bringa försoning för dig själv och för folket. Offra sedan folkets offer och bringa försoning för dem, så som Herren har befallt.” ");
INSERT INTO swef_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Då trädde Aron fram till altaret och slaktade sin syndofferkalv. ");
INSERT INTO swef_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Arons söner bar fram blodet till honom, och han doppade sitt finger i blodet och strök på altarets horn, men resten av blodet hällde han ut vid foten av altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Syndofferdjurets fett, njurar och leverfett brände han på altaret, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Men köttet och huden brände han upp i eld utanför lägret. ");
INSERT INTO swef_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Sedan slaktade han brännofferdjuret, och Arons söner räckte honom blodet som han stänkte runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","De räckte honom det styckade brännofferdjuret med dess huvud, och han brände det på altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Han tvättade inälvorna och benen och brände dem ovanpå brännoffret på altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Därefter förde han fram folkets offer. Han tog folkets syndofferbock och slaktade den och offrade den till syndoffer på samma sätt som det förra syndofferdjuret. ");
INSERT INTO swef_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Och han förde fram brännofferdjuret och offrade det på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Han bar också fram matoffret och tog en handfull av det och brände det på altaret, förutom morgonens brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Sedan slaktade han tjuren och baggen, som var folkets gemenskapsoffer, och Arons söner räckte honom blodet som han stänkte runt omkring på altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Fettstyckena av tjuren samt baggens fettsvans och det fett som omsluter inälvorna, liksom njurarna och leverfettet ");
INSERT INTO swef_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","lade de på bringorna, och han brände fettstyckena på altaret. ");
INSERT INTO swef_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Men bringorna och det högra lårstycket lyfte Aron som ett lyftoffer inför Herrens ansikte, så som Mose hade befallt. ");
INSERT INTO swef_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Och Aron lyfte upp sina händer över folket och välsignade dem. Därefter steg han ner, sedan han hade offrat syndoffret, brännoffret och gemenskapsoffret. ");
INSERT INTO swef_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Och Mose och Aron gick in i uppenbarelsetältet. Sedan gick de ut igen och välsignade folket. Då visade sig Herrens härlighet för allt folket. ");
INSERT INTO swef_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Eld gick ut från Herren och förtärde brännoffret och fettstyckena på altaret. När allt folket såg det, jublade de och föll ner på sina ansikten. ");
INSERT INTO swef_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Men Arons söner Nadab och Abihu tog var sitt fyrfat och lade eld i dem, strödde på rökelse och bar fram främmande eld inför Herrens ansikte, något som han inte hade befallt dem. ");
INSERT INTO swef_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Då gick eld ut från Herren och förtärde dem, och de dog inför Herren. ");
INSERT INTO swef_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Och Mose sade till Aron: ”Detta är vad Herren har sagt: På dem som står mig nära ska jag visa mig helig och inför allt folket visa mig härlig.” Och Aron teg stilla. ");
INSERT INTO swef_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose kallade till sig Mishael och Elsafan, söner till Arons farbror Ussiel, och sade till dem: ”Kom fram och bär ut era släktingar från helgedomen, utanför lägret.” ");
INSERT INTO swef_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Då steg de fram och bar ut dem i deras tunikor från lägret, så som Mose hade sagt. ");
INSERT INTO swef_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Sedan sade Mose till Aron och till hans söner Eleasar och Itamar: ”Ni ska inte ha ert hår oordnat eller riva sönder era kläder. Annars kan ni dö och vrede drabbar hela församlingen. Men era bröder, hela Israels hus, får gråta över den brand som Herren har tänt. ");
INSERT INTO swef_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ni ska inte lämna uppenbarelsetältets ingång, för att ni inte ska dö, för Herrens smörjelseolja är på er.” Och de gjorde enligt Moses ord. ");
INSERT INTO swef_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Herren talade till Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","”För att ni inte ska dö får varken du själv eller dina söner dricka vin eller starka drycker när ni ska gå in i uppenbarelsetältet. Det ska vara en evig stadga för er från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ni ska skilja mellan heligt och oheligt, mellan orent och rent. ");
INSERT INTO swef_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Och ni ska lära Israels barn alla de stadgar som Herren har kungjort för dem genom Mose.” ");
INSERT INTO swef_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose sade till Aron och till Eleasar och Itamar, hans kvarvarande söner: ”Ta det matoffer som har blivit över av Herrens eldsoffer och ät det osyrat vid sidan av altaret, för det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ni ska äta det på en helig plats, för det är din och dina söners lagliga rätt av Herrens eldsoffer. Den befallningen har jag fått. ");
INSERT INTO swef_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Lyftofferbringan och offergärdslåret ska ni äta på en ren plats, du och dina söner och döttrar med dig, för du har fått dem som din och dina söners lagliga rätt av Israels barns gemenskapsoffer. ");
INSERT INTO swef_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Tillsammans med eldsoffren av fettstyckena ska offergärdslåret och lyftofferbringan bäras fram för att lyftas som ett lyftoffer inför Herrens ansikte. De ska tillhöra dig och dina söner med dig som en evig rätt, så som Herren har befallt.” ");
INSERT INTO swef_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mose frågade efter syndofferbocken, och se, den var uppbränd. Då blev Mose vred på Eleasar och Itamar, Arons kvarvarande söner, och sade: ");
INSERT INTO swef_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","”Varför har ni inte ätit syndoffret på den heliga platsen? Det är ju högheligt. Han har gett er det för att ni ska ta bort församlingens skuld och bringa försoning för dem inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Se, dess blod har inte burits in i helgedomens inre. Därför skulle ni ha ätit upp köttet på helig plats, så som jag hade befallt.” ");
INSERT INTO swef_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Men Aron sade till Mose: ”Se, de har i dag offrat sitt syndoffer och brännoffer inför Herrens ansikte och du vet vad som har hänt mig. Om jag nu i dag hade ätit syndofferkött, skulle det ha varit välbehagligt för Herren?” ");
INSERT INTO swef_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","När Mose hörde det var han nöjd. ");
INSERT INTO swef_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Och Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Säg till Israels barn: Detta är de djur som ni får äta bland alla fyrfotadjur på jorden: ");
INSERT INTO swef_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alla de djur som har helt kluvna klövar och som idisslar får ni äta. ");
INSERT INTO swef_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Men av de djur som idisslar och av dem som har kluvna klövar ska ni inte äta dessa: kamelen, för den idisslar men har inte kluvna klövar, så den ska vara oren för er, ");
INSERT INTO swef_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","klippgrävlingen, för den idisslar men har inte kluvna klövar, så den ska vara oren för er, ");
INSERT INTO swef_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","haren, för den idisslar men har inte kluvna klövar, så den ska vara oren för er, ");
INSERT INTO swef_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","svinet, för det har helt kluvna klövar men idisslar inte, så det ska vara orent för er. ");
INSERT INTO swef_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Köttet av dessa djur ska ni inte äta, och ni ska inte heller röra vid deras döda kroppar. De ska vara orena för er. ");
INSERT INTO swef_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Detta får ni äta av det som är i vattnet: Allt i vattnet, sjöarna och floderna som har fenor och fjäll, det får ni äta. ");
INSERT INTO swef_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Men allt i sjöarna och floderna som inte har fenor och fjäll av allt det som rör sig och lever i vattnet, det ska ni betrakta som något avskyvärt. ");
INSERT INTO swef_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","De ska vara avskyvärda för er. Av deras kött ska ni inte äta, och deras döda kroppar ska ni avsky. ");
INSERT INTO swef_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Allt i vattnet som inte har fenor och fjäll ska vara avskyvärda för er. ");
INSERT INTO swef_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Dessa fåglar ska ni räkna som avskyvärda, de ska inte ätas, de är avskyvärda: örnen, lammgamen, havsörnen, ");
INSERT INTO swef_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","gladan, falken med dess arter, ");
INSERT INTO swef_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","korpen med dess arter, ");
INSERT INTO swef_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","strutsen, tahemasfågeln, fiskmåsen, höken med dess arter, ");
INSERT INTO swef_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ugglan, dykfågeln, uven, ");
INSERT INTO swef_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","tinsemetfågeln, pelikanen, ");
INSERT INTO swef_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","asgamen, storken, regnpiparen med dess arter, härfågeln och fladdermusen. ");
INSERT INTO swef_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alla de flygande smådjur som går på alla fyra ska vara avskyvärda för er. ");
INSERT INTO swef_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Av alla de flygande smådjur som går på alla fyra får ni endast äta dem som ovanför sina fötter har två ben att hoppa med på jorden. ");
INSERT INTO swef_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Dessa får ni äta bland gräshopporna: arbe med dess arter, soleam med dess arter, hargol med dess arter och hagab med dess arter. ");
INSERT INTO swef_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Men alla andra flygande smådjur som har fyra fötter ska vara avskyvärda för er. ");
INSERT INTO swef_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Var och en som rör vid den döda kroppen av något av följande djur drar på sig orenhet och ska vara oren ända till kvällen, ");
INSERT INTO swef_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","och var och en som har burit bort någon sådan död kropp ska tvätta sina kläder och vara oren ända till kvällen: ");
INSERT INTO swef_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Alla de fyrfotadjur som har klövar, men inte helt kluvna, och som inte idisslar, de ska vara orena för er. Var och en som rör vid dem blir oren. ");
INSERT INTO swef_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Och alla slags fyrfotadjur som går på tassar ska vara orena för er. Var och en som rör vid deras döda kroppar ska vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Den som bär bort en sådan död kropp ska tvätta sina kläder och vara oren ända till kvällen. De ska vara orena för er. ");
INSERT INTO swef_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Bland de smådjur som rör sig på marken ska dessa vara orena för er: vesslan, jordråttan, de olika slagen av ödlor, ");
INSERT INTO swef_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geckoödlan, landkrokodilen, letaödlan, sandödlan och kameleonten. ");
INSERT INTO swef_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bland alla smådjur ska dessa vara orena för er. Var och en som rör vid dem när de är döda ska vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Allt som ett sådant djur faller på när det är dött blir orent, vare sig det är något slags träkärl eller kläder, något av skinn eller en säck eller vilken annan sak det kan vara som används till något behov. Man ska lägga det i vatten, och det ska vara orent ända till kvällen, då det blir rent. ");
INSERT INTO swef_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Om något sådant faller ner i ett lerkärl blir allt som är i det orent, och ni ska slå sönder kärlet. ");
INSERT INTO swef_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","All mat man äter som är tillredd med vatten från ett sådant kärl är oren, och all dryck man dricker ur ett sådant kärl blir oren av det. ");
INSERT INTO swef_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Allt som en sådan död kropp faller på blir orent. Är det en ugn eller öppen eldstad ska den förstöras, eftersom den blir oren. Den ska vara oren för er. ");
INSERT INTO swef_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Men en källa eller en brunn, en plats dit vatten samlas, ska förbli ren. Men om någon rör vid själva den döda kroppen blir han oren. ");
INSERT INTO swef_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Om en sådan död kropp faller på något slags utsäde, något man sår, förblir det rent. ");
INSERT INTO swef_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Men om vatten har kommit på säden och en sådan död kropp sedan faller på den, ska den vara oren för er. ");
INSERT INTO swef_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Om något fyrfotadjur som får ätas av er, dör, ska den som rör vid den döda kroppen vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Den som äter kött av en sådan död kropp ska tvätta sina kläder och vara oren ända till kvällen. Den som bär bort den döda kroppen ska tvätta sina kläder och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Alla slags smådjur som rör sig på jorden är avskyvärda, de får inte ätas. ");
INSERT INTO swef_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Varken av det som går på buken eller av det som går på fyra eller flera fötter bland alla de smådjur som rör sig på jorden ska ni äta något, för de är avskyvärda. ");
INSERT INTO swef_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Gör er inte själva avskyvärda genom något av dessa kryp. Dra inte på er orenhet genom sådana, så att ni blir orena genom dem, ");
INSERT INTO swef_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","för jag är Herren er Gud. Ni ska hålla er heliga och vara heliga, för jag är helig. Orena er inte genom något av de smådjur som rör sig på jorden, ");
INSERT INTO swef_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","för jag är Herren som har fört er upp ur Egyptens land för att vara er Gud. Så ska ni nu vara heliga, för jag är helig. ");
INSERT INTO swef_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Detta är lagen om fyrfotadjuren, om fåglarna, om alla slags levande varelser som rör sig i vattnet och om alla slags smådjur som rör sig på jorden. ");
INSERT INTO swef_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Den visar hur man ska kunna skilja mellan orent och rent, mellan de djur som får ätas och de som inte får ätas. ");
INSERT INTO swef_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Säg till Israels barn: När en kvinna blir havande och föder en pojke, ska hon vara oren i sju dagar, lika många dagar som vid sin månadsrening ska hon vara oren. ");
INSERT INTO swef_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","På åttonde dagen ska hans förhud omskäras. ");
INSERT INTO swef_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sedan ska kvinnan stanna hemma i trettiotre dagar, under sitt reningsflöde. Hon får inte röra vid något som är heligt och inte heller komma till helgedomen förrän hennes reningsdagar är över. ");
INSERT INTO swef_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Men om det är en flicka som hon har fött, ska kvinnan vara oren i två veckor som vid sin månadsrening. Sedan ska hon stanna hemma i sextiosex dagar under sitt reningsflöde. ");
INSERT INTO swef_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","När hennes reningsdagar är över efter att hon fött son eller dotter ska hon komma till uppenbarelsetältets ingång, till prästen, med ett årsgammalt lamm som brännoffer och en ung duva eller turturduva som syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Prästen ska offra det inför Herrens ansikte och bringa försoning för henne, så blir hon ren från sitt blodflöde. Detta är lagen om en barnaföderska, både när hon har fött en pojke och när hon har fött en flicka. ");
INSERT INTO swef_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Men om hon inte har råd med ett får, ska hon ta två turturduvor eller två unga duvor, en till brännoffer och en till syndoffer. Prästen ska så bringa försoning för henne och hon blir ren. ");
INSERT INTO swef_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","När någon får en upphöjning på huden eller ett utslag eller en ljus fläck och det utvecklas till något som liknar spetälska på hans hud, ska han föras till prästen Aron eller någon av hans söner, prästerna. ");
INSERT INTO swef_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Prästen ska se på det angripna stället på huden. Om han då finner att håret på det angripna stället har vitnat och att det angripna stället visar sig djupare än den övriga huden på kroppen, då är det spetälska. När prästen ser det, ska han förklara honom oren. ");
INSERT INTO swef_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Och om den ljusa fläcken på hans hud är vit men inte visar sig djupare än den övriga huden och om håret på den inte har vitnat, ska prästen hålla den angripne instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Den sjunde dagen ska prästen se på honom. Om han då finner att det angripna stället är oförändrat och att det onda inte har brett ut sig på huden, ska han för andra gången hålla honom instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sedan ska prästen se på honom igen på sjunde dagen. Om det angripna stället har bleknat och det onda inte har brett ut sig på huden, ska han förklara honom ren, eftersom det då är ett vanligt utslag. När han har tvättat sina kläder är han ren. ");
INSERT INTO swef_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Men om utslaget breder ut sig på huden, sedan han visat sig för prästen för att förklaras ren, ska han visa sig för prästen en gång till. ");
INSERT INTO swef_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Om prästen ser att utslaget har brett ut sig på huden, ska prästen förklara honom oren, för då är det spetälska. ");
INSERT INTO swef_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","När någon får spetälska, ska han föras till prästen, ");
INSERT INTO swef_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","och prästen ska se på honom. Om det finns en vit upphöjning på huden och håret har vitnat där och svallkött har bildats i upphöjningen, ");
INSERT INTO swef_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","då är det gammal spetälska på hans hud, och prästen ska förklara honom oren. Han ska inte stänga in honom, för han är oren. ");
INSERT INTO swef_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Men om spetälskan har brutit ut så att hela huden är täckt av spetälska på den angripne, från huvud till fot, överallt där prästen ser, ");
INSERT INTO swef_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","då ska prästen undersöka honom. Om han då finner att spetälska täcker hela hans kropp, ska han förklara den angripne ren. Hela hans kropp har blivit vit, han är ren. ");
INSERT INTO swef_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Men så snart svallkött visar sig på honom är han oren. ");
INSERT INTO swef_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","När prästen ser svallköttet, ska han förklara honom oren. Svallköttet är orent, det är spetälska. ");
INSERT INTO swef_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Men om svallköttet förändras och stället blir vitt, ska han gå till prästen. ");
INSERT INTO swef_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Och prästen ska se på honom och om det angripna stället har blivit vitt, ska han förklara den angripne ren. Han är då ren. ");
INSERT INTO swef_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","När någon på sin hud har haft en böld som har läkts, ");
INSERT INTO swef_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","men det sedan visar sig en vit upphöjning eller en rödvit fläck på det ställe där bölden var, ska han visa sig för prästen, ");
INSERT INTO swef_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","och prästen ska se på honom. Om denne finner att stället är lägre än den övriga huden och att håret på det har vitnat, då ska han förklara honom oren, för han är angripen av spetälska som har brutit ut där bölden var. ");
INSERT INTO swef_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Men om prästen undersöker honom och finner att vitt hår saknas där, att stället inte är lägre än den övriga huden och att det är blekt, då ska prästen hålla honom instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Om då det onda breder ut sig på huden, då ska prästen förklara honom oren, för han är angripen. ");
INSERT INTO swef_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Men om den ljusa fläcken stannar kvar på sin plats och inte breder ut sig, då är det ett ärr efter bölden, och prästen ska förklara honom ren. ");
INSERT INTO swef_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Om någon får ett brännsår på sin hud och det sedan blir en rödvit eller en vit fläck av ärrbildningen i brännsåret, ");
INSERT INTO swef_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ska prästen undersöka det. Om håret på fläcken har vitnat och den visar sig vara djupare än huden, då är det spetälska som har brutit ut i brännsåret. Därför ska prästen förklara honom oren, för han är angripen av spetälska. ");
INSERT INTO swef_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Men om prästen undersöker stället och finner att vitt hår saknas på den ljusa fläcken, att stället inte är lägre än den övriga huden och att det är blekt, då ska prästen hålla honom instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Och prästen ska se på honom den sjunde dagen. Om det onda har brett ut sig på huden, då ska prästen förklara honom oren, för han är angripen av spetälska. ");
INSERT INTO swef_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Men om den ljusa fläcken stannar kvar på sin plats och inte breder ut sig på huden och förblir blek, då är det en upphöjning efter brännsåret. Prästen ska förklara honom ren, eftersom det är ett märke efter brännsåret. ");
INSERT INTO swef_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Om en man eller kvinna får en fläck på huvudet eller hakan, ");
INSERT INTO swef_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ska prästen undersöka fläcken. Om den då visar sig djupare än huden och där finns gulaktigt, tunt hår, då ska prästen förklara den angripne oren, för det är elakartad spetälskeskorv eller spetälska på huvud eller haka. ");
INSERT INTO swef_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Men om prästen ser på det ställe som angripits av skorven och det inte är djupare än huden och det inte finns något svart hår i det, då ska prästen hålla den som angripits av skorven instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Den sjunde dagen ska prästen se på det angripna stället. Om skorven då inte har brett ut sig och där inte finns något gulaktigt hår och skorven inte visar sig djupare än huden, ");
INSERT INTO swef_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","då ska den sjuke raka sig utan att raka det skorviga stället, och prästen ska för andra gången hålla honom instängd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Den sjunde dagen ska prästen se på den skorvsjuke. Om skorven inte har brett ut sig på huden och inte visar sig djupare än huden, ska prästen förklara honom ren. Han ska tvätta sina kläder och vara ren. ");
INSERT INTO swef_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Men om skorven breder ut sig på huden, sedan han har förklarats ren, ");
INSERT INTO swef_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ska prästen se på honom. Om skorven då har brett ut sig på huden behöver han inte närmare se efter om det finns något gulaktigt hår, eftersom han är oren. ");
INSERT INTO swef_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Men om skorven visar sig oförändrad och det har växt svart hår på stället, då är skorven läkt. Han är ren, och prästen ska förklara honom ren. ");
INSERT INTO swef_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","När någon, man eller kvinna, får ljusa fläckar på huden, särskilt vita, ljusa fläckar, ");
INSERT INTO swef_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ska prästen se på den angripne. Om de ljusa fläckarna på huden är blekvita, då är det ett ofarligt utslag på huden. Han är ren. ");
INSERT INTO swef_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","När håret på en mans huvud faller av, är det vanlig bakskallighet. Han är ren. ");
INSERT INTO swef_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Om håret faller av på främre delen av huvudet, är det vanlig framskallighet och han är ren. ");
INSERT INTO swef_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Men om det uppstår en rödvit fläck på det skalliga stället, baktill eller framtill, då är det spetälska som har brutit ut på det skalliga stället, baktill eller framtill, ");
INSERT INTO swef_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","och prästen ska se på honom. Om den upphöjda fläcken på det skalliga stället, bak eller fram, då är rödvit och visar sig likna spetälska på kroppens hud, ");
INSERT INTO swef_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","då är mannen spetälsk. Han är oren. Prästen ska förklara honom oren, eftersom han är angripen på sitt huvud. ");
INSERT INTO swef_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Den som är angripen av spetälska ska gå med sönderrivna kläder. Han ska ha sitt hår ovårdat och skyla sitt skägg och ropa: ”Oren! Oren!” ");
INSERT INTO swef_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Så länge han är angripen av spetälska ska han vara oren. Han är oren och ska bo avskilt. Han ska ha sin bostad utanför lägret. ");
INSERT INTO swef_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","När ett klädesplagg blir angripet av spetälska – ett plagg av ylle eller linne, ");
INSERT INTO swef_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ett vävt eller virkat tyg av linne eller ylle, ett skinn eller något som är tillverkat av skinn – ");
INSERT INTO swef_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","och det angripna stället är grönaktigt eller rödaktigt på plagget eller skinnet, det vävda eller virkade tyget eller skinnföremålet eller vad det än är, då är stället angripet av spetälska och ska visas för prästen. ");
INSERT INTO swef_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Och prästen ska se på det angripna stället och det föremål som angripits ska vara inlåst i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Den sjunde dagen ska han se på det angripna stället. Om skadan har brett ut sig på plagget eller det vävda eller virkade tyget eller skinnet eller det som är gjort av skinnet, så är stället angripet av elakartad spetälska. Det är orent. ");
INSERT INTO swef_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Man ska bränna upp plagget eller det vävda eller virkade tyget av ylle eller linne eller skinnföremålet, vad det än är som är angripet, eftersom det är elakartad spetälska. Allt ska brännas upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Men om prästen ser på stället och fläcken inte har brett ut sig på plagget eller det vävda eller virkade tyget eller skinnföremålet, vad det än är, ");
INSERT INTO swef_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ska han befalla att man tvättar den sak där det angripna stället finns, och prästen ska ha den inlåst i ytterligare sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Han ska efter tvättningen se på det angripna stället. Om fläcken då inte har ändrat utseende är saken oren, även om fläcken inte har brett ut sig. Du ska bränna upp den i eld. Det är en frätfläck, vare sig den sitter på avigsidan eller på rätsidan. ");
INSERT INTO swef_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Men om prästen ser på det angripna stället och finner att det har bleknat efter tvättningen, då ska han riva bort det från plagget eller skinnet eller det vävda eller virkade tyget. ");
INSERT INTO swef_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Om en fläck visar sig igen på plagget eller det vävda eller virkade tyget eller skinnföremålet, vad det än är, så är det spetälska som har brutit ut. Föremålet med det angripna stället ska du bränna upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Men om fläcken på plagget eller det vävda eller stickade tyget eller skinnföremålet, vad det än är, har gått bort genom tvättningen, ska plagget tvättas en andra gång och blir då rent. ");
INSERT INTO swef_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Detta är lagen om det som blir angripet av spetälska, plagg av ylle eller linne eller vävt eller virkat tyg eller skinnföremål, vad det än är. Efter denna lag ska det förklaras rent eller orent. ");
INSERT INTO swef_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Detta är lagen om den spetälske den dag han ska renas: Han ska föras till prästen ");
INSERT INTO swef_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","och prästen ska gå ut utanför lägret och se på honom. Om han är botad från sin spetälska ");
INSERT INTO swef_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ska prästen befalla att man för den som ska renas tar två levande rena fåglar, cederträ, karmosinrött garn och isop. ");
INSERT INTO swef_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Prästen ska befalla att den ena fågeln slaktas över ett lerkärl med friskt vatten. ");
INSERT INTO swef_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sedan ska han ta den levande fågeln, cederträet, det karmosinröda garnet och isopen och doppa alltsammans med den levande fågeln i blodet från fågeln som slaktades över det friska vattnet. ");
INSERT INTO swef_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Han ska stänka sju gånger på den som ska renas från spetälskan, och när han så har renat honom ska han släppa fri den levande fågeln ute på marken. ");
INSERT INTO swef_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Den som ska renas ska tvätta sina kläder och raka av allt sitt hår och bada i vatten, så blir han ren och får sedan gå in i lägret. Men han ska stanna utanför sitt tält i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","På sjunde dagen ska han raka av allt sitt hår, både huvudhåret, skägget och ögonbrynen. Allt sitt hår ska han raka av. Och han ska tvätta sina kläder och bada sin kropp i vatten, så blir han ren. ");
INSERT INTO swef_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","På åttonde dagen ska han ta två felfria lamm av hankön, ett årsgammalt felfritt lamm av honkön och tre tiondels efa fint mjöl blandat med olja till matoffer, och vidare en log olja. ");
INSERT INTO swef_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Och prästen som utför reningen ska ställa fram den som ska renas och allt det andra inför Herrens ansikte vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Prästen ska ta det ena lammet med tillhörande logmått olja och offra det till ett skuldoffer och lyfta det som ett lyftoffer inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Han ska slakta lammet på samma plats som man slaktar syndofferdjuren och brännofferdjuren, på en helig plats, för skuldoffret tillhör liksom syndoffret prästen. Det är högheligt. ");
INSERT INTO swef_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Och prästen ska ta något av skuldoffrets blod och stryka det på högra örsnibben på den som ska renas, på högra handens tumme och högra fotens stortå. ");
INSERT INTO swef_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Sedan ska prästen ta av tillhörande log olja och hälla i sin vänstra hand. ");
INSERT INTO swef_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Han ska doppa sitt högra pekfinger i oljan som han har i vänster hand och stänka något av oljan med sitt finger sju gånger inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Av den olja som är kvar i hans hand ska prästen stryka på högra örsnibben på den som ska renas, på högra handens tumme och högra fotens stortå, ovanpå skuldofferblodet. ");
INSERT INTO swef_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Det som sedan är kvar av oljan i prästens hand ska han hälla på huvudet på den som ska renas. Så ska prästen bringa försoning för honom inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Därefter ska han offra syndoffret och bringa försoning för den som ska renas, så att han blir fri från sin orenhet. Sedan ska prästen slakta brännofferdjuret. ");
INSERT INTO swef_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Han ska offra brännoffret och matoffret på altaret. När prästen så bringar försoning för honom, blir han ren. ");
INSERT INTO swef_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Men om han är fattig och inte har råd med så mycket, ska han ta endast ett lamm till skuldoffer och lyfta det för att bringa försoning för sig, och endast en tiondels efa fint mjöl, blandat med olja, till matoffer samt en log olja, ");
INSERT INTO swef_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","och dessutom två turturduvor eller två unga duvor, allt eftersom han har råd. Den ena duvan ska vara till syndoffer och den andra till brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","För att förklaras ren ska han på åttonde dagen bära allt detta till prästen, till uppenbarelsetältets ingång inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Prästen ska ta skuldofferlammet och det logmått olja som hör till det, och han ska lyfta det som ett lyftoffer inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","När skuldofferlammet har slaktats, ska prästen ta av skuldoffrets blod och stryka på högra örsnibben på den som ska renas, på högra handens tumme och högra fotens stortå. ");
INSERT INTO swef_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Sedan ska prästen hälla något av oljan i sin vänstra hand, ");
INSERT INTO swef_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","och han ska med sitt högra pekfinger stänka något av oljan som han har i vänster hand sju gånger inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Och prästen ska med oljan som han har i handen stryka på högra örsnibben på den som ska renas, på högra handens tumme och högra fotens stortå, ovanpå skuldofferblodet. ");
INSERT INTO swef_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Det som är kvar av oljan i prästens hand ska han hälla på huvudet på den som ska renas, för att bringa försoning för honom inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sedan ska han offra den ena av turturduvorna eller av de unga duvorna, vad han nu har haft råd till. ");
INSERT INTO swef_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Av det han kunnat skaffa ska han offra den ena till syndoffer och den andra till brännoffer tillsammans med matoffret. Så ska prästen bringa försoning inför Herrens ansikte för den som ska renas. ");
INSERT INTO swef_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Detta är lagen om den som har blivit angripen av spetälska men inte har råd att skaffa vad som enligt lagen hör till hans rening. ");
INSERT INTO swef_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Herren sade till Mose och Aron: ");
INSERT INTO swef_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","När ni kommer in i Kanaans land som jag ger er till arvedel, och jag låter något hus i landet ni får till arvedel bli angripet av spetälska, ");
INSERT INTO swef_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ska husets ägare anmäla det för prästen och säga: ”Mitt hus verkar vara angripet av spetälska.” ");
INSERT INTO swef_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Då ska prästen ge befallning om att man utrymmer huset innan han går in för att se på det angripna stället, detta för att inte allt som är i huset ska bli orent. Därefter ska prästen gå in för att besiktiga huset. ");
INSERT INTO swef_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Om han då, när han undersöker det angripna stället, finner att det på husets vägg har bildats grönaktiga eller rödaktiga fördjupningar som är lägre än den övriga väggen, ");
INSERT INTO swef_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ska prästen gå ut ur huset, till dörren på huset, och stänga det för sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Och prästen ska komma tillbaka på sjunde dagen och undersöka huset. Om fläcken har brett ut sig på husets vägg, ");
INSERT INTO swef_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ska han befalla att man tar bort de stenar som är angripna och kastar dem utanför staden på en oren plats. ");
INSERT INTO swef_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Men huset ska man skrapa överallt på insidan och kasta det avskrapade murbruket på en oren plats utanför staden. ");
INSERT INTO swef_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Och man ska ta andra stenar och sätta in dem i de förras ställe och ta annat murbruk och rappa huset med det. ");
INSERT INTO swef_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Om en fläck kommer fram igen på huset, efter att man tagit bort stenarna, skrapat huset och rappat det, ");
INSERT INTO swef_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ska prästen gå in och se på det. Om fläcken har brett ut sig på huset, är det elakartad spetälska. Huset är orent. ");
INSERT INTO swef_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Och man ska riva huset med dess stenar och trävirke och allt murbruk på huset och föra bort alltsammans utanför staden till en oren plats. ");
INSERT INTO swef_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Om någon har gått in i huset under den tid det skulle vara stängt, ska han vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Om någon har legat i huset ska han tvätta sina kläder, och om någon har ätit i huset ska också han tvätta sina kläder. ");
INSERT INTO swef_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Men om prästen går in och undersöker huset och ser att fläcken inte har brett ut sig på huset efter att det blivit rappat, då ska han förklara huset rent eftersom det onda är läkt. ");
INSERT INTO swef_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Till husets rening ska han ta två fåglar, cederträ, karmosinrött garn och isop. ");
INSERT INTO swef_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Och han ska slakta den ena fågeln över ett lerkärl med friskt vatten. ");
INSERT INTO swef_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sedan ska han ta cederträet, isopen, det karmosinröda garnet och den levande fågeln, doppa alltsammans i den slaktade fågelns blod och i det friska vattnet och bestänka huset sju gånger. ");
INSERT INTO swef_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Så ska han rena huset med fågelns blod och det friska vattnet och med den levande fågeln, cederträet, isopen och det karmosinröda garnet. ");
INSERT INTO swef_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Och han ska släppa den levande fågeln fri ute på marken utanför staden. När han så bringar försoning för huset, blir det rent. ");
INSERT INTO swef_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Detta är lagen om allt slags spetälskesjukdom och spetälskeskorv, ");
INSERT INTO swef_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","om spetälska på kläder och på hus, ");
INSERT INTO swef_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","om upphöjningar på huden, utslag och ljusa fläckar, ");
INSERT INTO swef_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","till undervisning om när något är orent eller rent. Detta är lagen om spetälska. ");
INSERT INTO swef_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Säg till Israels barn: ");
INSERT INTO swef_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Om någon får flytning från sin kropp är hans flytning oren. Detta är vad som gäller om hans orenhet så länge flytningen pågår: Vare sig hans kropp avsöndrar flytningen eller stänger sig för flytningen är han oren. ");
INSERT INTO swef_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Allt som den sjuke ligger på blir orent, och allt som han sitter på blir orent. ");
INSERT INTO swef_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Den som rör vid något som han legat på ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Den som sätter sig på något som den sjuke suttit på ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Den som rör vid den sjukes kropp ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Om den sjuke spottar på någon som är ren, ska denne tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Varje sadel som den sjuke sitter på när han rider blir oren. ");
INSERT INTO swef_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Var och en som rör vid något vad det än är som har legat under honom ska vara oren ända till kvällen, och den som bär bort något sådant ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Var och en som den sjuke rör vid utan att ha sköljt sina händer i vatten ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ett lerkärl som den sjuke rör vid ska slås sönder, och varje träkärl ska sköljas i vatten. ");
INSERT INTO swef_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","När den som har flytning blir fri från sin flytning, ska han räkna sju dagar för att förklaras ren. Därefter ska han tvätta sina kläder och bada sin kropp i rinnande vatten. Då blir han ren. ");
INSERT INTO swef_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","På åttonde dagen ska han ta två turturduvor eller två unga duvor och komma inför Herrens ansikte, till uppenbarelsetältets ingång, och han ska ge dem åt prästen. ");
INSERT INTO swef_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Och prästen ska offra dem, den ena till syndoffer och den andra till brännoffer. Så ska prästen bringa försoning för honom inför Herrens ansikte till rening från hans flytning. ");
INSERT INTO swef_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Om en man har haft sädesuttömning, ska han bada hela sin kropp i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Alla kläder och allt av skinn som sädesuttömningen kommit på ska tvättas i vatten och vara orent ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","När en man har legat med en kvinna och sädesuttömning har skett, ska de båda bada i vatten och vara orena ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","När en kvinna har sin flytning och det kommer blod från hennes kropp, ska hon vara oren i sju dagar. Var och en som rör vid henne ska vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Allt som hon ligger på under sin månadsrening blir orent, och allt som hon sitter på blir orent. ");
INSERT INTO swef_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Var och en som rör vid det som hon legat på ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Var och en som rör vid något som hon suttit på ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Om någon sak läggs på det som hon har legat eller suttit på och någon sedan rör vid det, ska han vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Om en man ligger med henne och något av hennes månadsblödning kommer på honom, ska han vara oren i sju dagar, och allt som han ligger på blir orent. ");
INSERT INTO swef_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Om en kvinna har blödningar under en längre tid, utan att det är hennes månadsrening, eller om hon har blödningar utöver tiden för sin månadsrening, ska samma regler gälla för henne som under tiden för hennes månadsrening. Hon är oren. ");
INSERT INTO swef_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Allt som hon ligger på så länge hennes blödningar varar ska behandlas som det hon ligger på under sin månadsrening, och allt som hon sitter på blir orent liksom under hennes månadsrening. ");
INSERT INTO swef_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Och var och en som rör vid något av det blir oren. Han ska tvätta sina kläder och bada i vatten och vara oren ända till kvällen. ");
INSERT INTO swef_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","När hon blir ren från blödningen ska hon räkna sju dagar, och sedan är hon ren. ");
INSERT INTO swef_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","På åttonde dagen ska hon ta två turturduvor eller två unga duvor och bära dem till prästen, till uppenbarelsetältets ingång. ");
INSERT INTO swef_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Prästen ska offra den ena till syndoffer och den andra till brännoffer. Så ska prästen bringa försoning för henne inför Herrens ansikte till rening från hennes orena blödning. ");
INSERT INTO swef_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ni ska skilja Israels barn från deras orenhet, så att de inte måste dö i sin orenhet, om de orenar mitt tabernakel som står mitt ibland dem. ");
INSERT INTO swef_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Detta är lagen om den som har flytning och om den som har sädesuttömning så att han därigenom blir oren, ");
INSERT INTO swef_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","och om den kvinna som har sin månadsrening och om den man eller kvinna som har någon flytning, samt om en man som ligger med en oren kvinna. ");
INSERT INTO swef_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Herren talade till Mose efter att Arons båda söner hade dött, de som dog när de trädde fram inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Och Herren sade till Mose: Säg till din bror Aron att han inte när som helst får gå in i helgedomen innanför förhänget framför nådastolen på arken, så att han inte dör. För jag kommer att uppenbara mig i molnet över nådastolen. ");
INSERT INTO swef_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Detta ska Aron ha med sig när han går in i helgedomen: en ungtjur till syndoffer och en bagge till brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Han ska ta på sig en helig tunika av linne och ha byxor av linne på sin kropp, och han ska spänna på sig ett bälte av linne och vira en turban av linne om huvudet. Detta är de heliga kläderna, och innan han tar dem på sig ska han bada sin kropp i vatten. ");
INSERT INTO swef_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Av israeliternas församling ska han ta emot två bockar till syndoffer och en bagge till brännoffer. ");
INSERT INTO swef_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Och Aron ska föra fram sin egen syndoffertjur och bringa försoning för sig själv och sitt hus. ");
INSERT INTO swef_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Sedan ska han ta de två bockarna och ställa dem inför Herrens ansikte, vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aron ska dra lott om de båda bockarna: en lott för Herren och en lott för att ta bort synden. ");
INSERT INTO swef_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Den bock som lotten bestämmer åt Herren ska Aron föra fram och offra till syndoffer. ");
INSERT INTO swef_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Men den bock som lotten bestämmer för att ta bort synden ska ställas levande inför Herrens ansikte, för att försoning ska bringas genom honom. Och sedan ska han sändas i väg ut i öknen för att ta bort synden. ");
INSERT INTO swef_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aron ska föra fram sin syndoffertjur och bringa försoning för sig själv och sitt hus. Han ska slakta sin syndoffertjur. ");
INSERT INTO swef_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Sedan ska han ta ett fyrfat, fullt med glöd från altaret som står inför Herrens ansikte. Han ska fylla sina händer med krossad, väldoftande rökelse och bära in det innanför förhänget. ");
INSERT INTO swef_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Han ska lägga rökelsen på elden inför Herren, så att ett moln av rökelse täcker nådastolen över vittnesbördet. Då ska han inte dö. ");
INSERT INTO swef_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Och han ska ta av tjurens blod och stänka det med sitt finger framtill på nådastolen. Sju gånger ska han stänka blodet framför nådastolen med sitt finger. ");
INSERT INTO swef_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Sedan ska han slakta folkets syndofferbock och bära in dess blod innanför förhänget, och han ska göra med blodet som han gjorde med tjurens blod. Han ska stänka det på nådastolen och framför nådastolen. ");
INSERT INTO swef_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Så ska han bringa försoning för helgedomen och rena den från Israels barns orenheter och brott, från alla deras synder. På samma sätt ska han göra med uppenbarelsetältet, som har sin plats hos dem mitt ibland deras orenheter. ");
INSERT INTO swef_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ingen människa får vara i uppenbarelsetältet från det att han går in för att bringa försoning i helgedomen tills han går ut. Så ska han bringa försoning för sig själv och sitt hus och för Israels hela församling. ");
INSERT INTO swef_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Sedan ska han gå ut till altaret som står inför Herrens ansikte och bringa försoning för det. Han ska ta av tjurens blod och av bockens blod och stryka på altarets horn runt omkring, ");
INSERT INTO swef_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","och han ska stänka av blodet på altaret med sitt finger sju gånger och rena och helga det från Israels barns orenheter. ");
INSERT INTO swef_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","När Aron har fullbordat försoningen för helgedomen, uppenbarelsetältet och altaret, ska han föra fram den levande bocken. ");
INSERT INTO swef_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Och Aron ska lägga båda händerna på den levande bockens huvud och bekänna över honom Israels barns alla missgärningar, alla deras brott och alla deras synder. Han ska lägga dem på bockens huvud och sedan sända i väg den ut i öknen genom en man som hålls redo för det. ");
INSERT INTO swef_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bocken ska bära alla deras missgärningar på sig ut i ödemarken, och man ska släppa bocken ute i öknen. ");
INSERT INTO swef_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Sedan ska Aron gå in i uppenbarelsetältet och ta av sig linnekläderna, som han hade klätt sig i när han gick in i helgedomen, och han ska lämna dem där. ");
INSERT INTO swef_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Han ska bada sin kropp i vatten på en helig plats och ta på sig sina vanliga kläder. Sedan ska han gå ut och offra sitt eget brännoffer och folkets brännoffer och bringa försoning för sig och för folket. ");
INSERT INTO swef_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Fettet av syndofferdjuret ska han bränna på altaret. ");
INSERT INTO swef_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Och den som sände i väg bocken för att ta bort synden ska tvätta sina kläder och bada sin kropp i vatten. Därefter får han komma in i lägret. ");
INSERT INTO swef_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Syndoffertjuren och syndofferbocken vars blod bars in för att bringa försoning i helgedomen ska föras bort utanför lägret, och man ska bränna upp dem i eld med deras hud, kött och orenhet. ");
INSERT INTO swef_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Den som bränner upp det ska tvätta sina kläder och bada sin kropp i vatten. Därefter får han komma in i lägret. ");
INSERT INTO swef_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Detta ska för er vara en evig stadga: I sjunde månaden, på tionde dagen i månaden, ska ni fasta och inte utföra något arbete, varken den infödde eller främlingen som bor ibland er. ");
INSERT INTO swef_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","För på den dagen ska försoning bringas för att rena er. Från alla era synder ska ni renas inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","En vilosabbat ska den vara för er, och ni ska fasta. Detta ska vara en evig stadga. ");
INSERT INTO swef_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Den präst som har blivit smord och invigd till att vara präst i sin fars ställe ska bringa försoning. Han ska ta på sig linnekläderna, de heliga kläderna, ");
INSERT INTO swef_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","och bringa försoning för det allra heligaste och försoning för uppenbarelsetältet och altaret, och han ska bringa försoning för prästerna och allt folket i församlingen. ");
INSERT INTO swef_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Detta ska för er vara en evig stadga, så att försoning bringas för Israels barn en gång om året för alla deras synder. Och Aron gjorde så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Säg till Aron och hans söner och alla Israels barn: Detta är vad Herren har befallt: ");
INSERT INTO swef_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Om någon av Israels hus slaktar en ko, ett lamm eller en get i eller utanför lägret ");
INSERT INTO swef_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","och inte för fram djuret till uppenbarelsetältets ingång för att bära fram det som en offergåva åt Herren framför hans tabernakel, ska det tillräknas den mannen som blodskuld. Han har spillt blod, och han ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Därför ska Israels barn komma med sina slaktdjur som de brukar slakta ute på marken, fram till Herren, till uppenbarelsetältets ingång, till prästen, och slakta dem där som ett gemenskapsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Prästen ska stänka blodet på Herrens altare vid ingången till uppenbarelsetältet och bränna fettet till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","De ska inte mer offra sina slaktoffer till de onda andar som de i trolös avfällighet håller sig till. Detta ska vara en evig stadga för dem, från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Säg till dem: Om någon av Israels hus eller av främlingarna som bor bland dem, offrar ett brännoffer eller ett slaktoffer ");
INSERT INTO swef_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","och inte för fram det till uppenbarelsetältets ingång för att offra det åt Herren, ska den mannen utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Och om någon av Israels hus eller av främlingarna som bor bland dem förtär något blod, ska jag vända mitt ansikte mot den som äter blodet och utrota honom ur hans folk. ");
INSERT INTO swef_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","För kroppens liv är i blodet, och jag har gett er det för altaret, för att bringa försoning för era själar. Det är blodet som bringar försoning genom själen som är i det. ");
INSERT INTO swef_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Därför säger jag till Israels barn: Ingen av er ska äta blod. Främlingen som bor ibland er ska inte heller äta blod. ");
INSERT INTO swef_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Om någon av Israels barn eller av främlingarna som bor bland dem fäller ett villebråd av fyrfotadjur eller en fågel av det slag som får ätas, ska han låta blodet rinna ut och täcka över det med jord. ");
INSERT INTO swef_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","För varje kropps liv är dess blod. Därför säger jag till Israels barn: Ni ska inte äta någon kropps blod, för varje kropps liv är dess blod. Var och en som äter det ska utrotas. ");
INSERT INTO swef_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Och var och en som äter ett självdött eller ihjälrivet djur, vare sig han är infödd eller främling, ska tvätta sina kläder och bada sig i vatten och vara oren ända till kvällen. Då blir han ren. ");
INSERT INTO swef_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Om han inte tvättar sina kläder och badar sin kropp, kommer han att bära på skuld. ");
INSERT INTO swef_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Säg till Israels barn: Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ni ska inte göra som de gör i Egyptens land, där ni har bott. Inte heller ska ni göra som de gör i Kanaans land, dit jag vill föra er. Ni ska inte vandra efter deras stadgar. ");
INSERT INTO swef_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mina domslut ska ni följa och mina stadgar ska ni handla noggrant efter. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ni ska hålla fast vid mina stadgar och lagar, för den människa som följer dem ska leva genom dem. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ingen av er ska röra en kvinna som är hans nära släkting och blotta hennes nakenhet. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Du ska inte blotta din fars nakenhet genom att blotta din mors nakenhet. Hon är din mor, och du ska inte blotta hennes nakenhet. ");
INSERT INTO swef_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Du ska inte blotta nakenheten hos din fars hustru, för det är din fars nakenhet. ");
INSERT INTO swef_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Du ska inte blotta din systers nakenhet, vare sig hon är din fars dotter eller din mors dotter, vare sig hon är född hemma eller ute. ");
INSERT INTO swef_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Du ska inte blotta din sondotters eller din dotterdotters nakenhet, för det är din egen nakenhet. ");
INSERT INTO swef_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Du ska inte blotta nakenheten hos dottern till din fars hustru, för hon är av din fars släkt och hon är din syster. ");
INSERT INTO swef_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Du ska inte blotta nakenheten hos din fars syster, för hon är din fars nära släkting. ");
INSERT INTO swef_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Du ska inte blotta nakenheten hos din mors syster, för hon är din mors nära släkting. ");
INSERT INTO swef_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Du ska inte blotta nakenheten hos din fars bror, och du ska inte röra hans hustru, för hon är din fars syster. ");
INSERT INTO swef_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Du ska inte blotta din svärdotters nakenhet. Hon är din sons hustru, och hennes nakenhet ska du inte blotta. ");
INSERT INTO swef_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Du ska inte blotta nakenheten hos din brors hustru, för det är din brors nakenhet. ");
INSERT INTO swef_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Du ska inte blotta en kvinnas nakenhet och dessutom hennes dotters. Du ska inte heller ta till hustru hennes sondotter eller dotterdotter och blotta deras nakenhet. Det vore en skam, för de är ju dina nära släktingar. ");
INSERT INTO swef_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Du ska inte ta till hustru en kvinna som är syster till din hustru, så att du väcker fiendskap mellan dem genom att du blottar också hennes nakenhet medan din hustru lever. ");
INSERT INTO swef_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Du ska inte röra en kvinna och blotta hennes nakenhet när hon är oren under sin månadsrening. ");
INSERT INTO swef_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Du ska inte ligga med din nästas hustru, så att du genom henne orenar dig. ");
INSERT INTO swef_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Du ska inte offra något av dina barn åt Molok. Du ska inte ohelga din Guds namn. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Du ska inte ligga med en man som en man ligger med en kvinna. Det är avskyvärt. ");
INSERT INTO swef_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Du ska inte ligga med något djur, så att du genom det blir oren. Inte heller ska en kvinna ställa sig framför ett djur för att para sig med det. Det är naturvidrigt. ");
INSERT INTO swef_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ni ska inte orena er med något av detta, för med allt sådant har de hednafolk orenat sig som jag driver bort för er. ");
INSERT INTO swef_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Genom detta har landet blivit orenat, och jag har straffat det för dess missgärning så att landet har spytt ut sina invånare. ");
INSERT INTO swef_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ni ska därför hålla fast vid mina stadgar och lagar, och ingen av er ska ägna sig åt något av detta avskyvärda, vare sig han är infödd eller är en främling som bor ibland er. ");
INSERT INTO swef_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Alla dessa avskyvärda ting har landets invånare gjort, de som var där före er, och landet har blivit orenat. ");
INSERT INTO swef_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Gör inte något sådant så att landet spyr ut er, liksom det har spytt ut det folk som har bott där före er. ");
INSERT INTO swef_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","För var och en som gör något av allt detta avskyvärda ska utrotas ur sitt folk, alla som gör sådant. ");
INSERT INTO swef_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Håll därför fast vid vad jag har befallt er att iaktta, så att ni inte följer någon av de avskyvärda seder som man har följt före er och så orenar er genom dem. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Säg till Israels barns hela församling: Ni ska vara heliga, för jag, Herren er Gud, är helig. ");
INSERT INTO swef_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Var och en av er ska visa respekt för sin mor och sin far. Mina sabbater ska ni hålla. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ni ska inte vända er till avgudar och inte göra er några gjutna gudar. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","När ni vill offra gemenskapsoffer åt Herren, ska ni offra det på sådant sätt att ni räknas som välbehagliga. ");
INSERT INTO swef_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Det ska ätas samma dag som ni offrar det eller nästa dag. Det som blir över till tredje dagen ska brännas upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Om det äts på tredje dagen, är det avskyvärt och blir inte mottaget. ");
INSERT INTO swef_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Den som äter av det måste bära sin skuld, för han har ohelgat det som var helgat åt Herren. Han ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","När ni bärgar skörden i ert land, ska du inte skörda till den yttersta kanten av åkern och inte plocka upp ströaxen efter din skörd. ");
INSERT INTO swef_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Inte heller i din vingård ska du göra någon efterskörd, och de druvor som fallit av i din vingård ska du inte plocka upp. Du ska lämna kvar det åt den fattige och åt främlingen. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ni ska inte stjäla eller ljuga eller bedra varandra. ");
INSERT INTO swef_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ni ska inte svära falskt vid mitt namn. Då ohelgar du din Guds namn. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du ska inte förtrycka din nästa eller plundra honom. Du ska inte undanhålla daglönaren hans lön över natten till morgonen. ");
INSERT INTO swef_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du ska inte uttala förbannelser över en döv eller lägga något framför en blind som han kan snava över. Du ska frukta din Gud. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Du ska inte göra orätt när du dömer. Du ska inte hålla med någon för att han är fattig och du ska inte vara partisk för den som har makt. Du ska döma din nästa med rättvisa. ");
INSERT INTO swef_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du ska inte gå med förtal bland ditt folk. Du ska inte stå efter din nästas blod. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du ska inte hata din broder i ditt hjärta, men du ska tillrättavisa din nästa så att du inte bär på synd för hans skull. ");
INSERT INTO swef_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du ska inte hämnas och inte hysa agg mot någon i ditt folk, utan du ska älska din nästa som dig själv. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mina stadgar ska ni hålla: Du ska inte låta två slags djur av din boskap para sig med varandra. Du ska inte så två slags säd i din åker och inte ta på dig klädesplagg av två olika slags garn. ");
INSERT INTO swef_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Om en man har legat med en kvinna som är en annan mans slavinna och sädesuttömning har skett, och hon inte har blivit friköpt eller frigiven, ska de straffas men inte dödas eftersom hon inte var fri. ");
INSERT INTO swef_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Han ska föra fram sitt skuldoffer, en skuldofferbagge, inför Herren, till uppenbarelsetältets ingång. ");
INSERT INTO swef_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","När prästen med skuldofferbaggen bringar försoning för honom inför Herrens ansikte, får han förlåtelse för den synd han har begått. ");
INSERT INTO swef_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","När ni kommer in i landet och planterar olika slags träd med ätbar frukt, ska ni se deras frukt som deras förhud. I tre år ska ni betrakta dem som oomskurna och inte äta deras frukt. ");
INSERT INTO swef_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Under det fjärde året ska all deras frukt vara helig som ett tackoffer till Herren, ");
INSERT INTO swef_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","och först under det femte året ska ni äta deras frukt. Så ska ni göra för att de ska ge så mycket större avkastning åt er. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ni ska inte äta något som innehåller blod. Ni ska inte befatta er med spådom eller trolldom. ");
INSERT INTO swef_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ni ska inte rundklippa kanten av ert hår, och inte heller ska du stympa kanten av ditt skägg. ");
INSERT INTO swef_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ni ska inte rista märken på er kropp för någon död och inte heller bränna in skrivtecken på er. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Vanära inte din dotter genom att låta henne bli prostituerad, så att landet blir fördärvat av otukt och uppfyllt av skamligheter. ");
INSERT INTO swef_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mina sabbater ska ni hålla, och för min helgedom ska ni visa vördnad. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Vänd er inte till andebesvärjare eller till spåmän. Sök inte sådana så att ni blir orena genom dem. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","För ett grått huvud ska du resa dig upp, och den gamle ska du ära. Du ska frukta din Gud. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","När en främling bor hos er i ert land, ska ni inte förtrycka honom. ");
INSERT INTO swef_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Främlingen som bor ibland er ska räknas som infödd hos er. Du ska älska honom som dig själv. Ni har ju själva varit främlingar i Egyptens land. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ni ska inte göra orätt när ni dömer i fråga om längd, vikt eller rymd. ");
INSERT INTO swef_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Rätt våg, rätta vikter, rätt efa, rätt hin-mått ska ni ha. Jag är Herren er Gud, som har fört er ut ur Egyptens land. ");
INSERT INTO swef_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Så ska ni nu hålla alla mina stadgar och alla mina lagar och följa dem. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Du ska säga till Israels barn: Om någon av Israels barn eller av främlingarna som bor i Israel ger något av sina barn åt Molok, ska han straffas med döden. Folket i landet ska stena honom. ");
INSERT INTO swef_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Jag ska vända mitt ansikte mot den mannen och utrota honom ur hans folk, därför att han gett ett av sina barn åt Molok och orenat min helgedom och ohelgat mitt heliga namn. ");
INSERT INTO swef_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Om folket i landet ser mellan fingrarna med den mannen när han ger ett av sina barn åt Molok och inte dödar honom, ");
INSERT INTO swef_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","så ska jag själv vända mitt ansikte mot den mannen och mot hans släkt. Och jag ska utrota honom ur folket tillsammans med alla som följt honom och i trolös avfällighet dyrkat Molok. ");
INSERT INTO swef_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Om någon vänder sig till andebesvärjare för att i trolös avfällighet hålla sig till dem, ska jag vända mitt ansikte mot honom och utrota honom ur hans folk. ");
INSERT INTO swef_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ni ska helga er och vara heliga, för jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ni ska hålla mina bud och följa dem. Jag är Herren som helgar er. ");
INSERT INTO swef_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Om någon förbannar sin far eller mor ska han straffas med döden. Han har förbannat sin far och sin mor, han bär på blodskuld. ");
INSERT INTO swef_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Om någon begår äktenskapsbrott med en annan mans hustru, ska den som begår äktenskapsbrott med sin nästas hustru straffas med döden, både äktenskapsbrytaren och äktenskapsbryterskan. ");
INSERT INTO swef_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Om någon ligger med en kvinna som är hans fars hustru, blottar han sin fars nakenhet. De ska båda straffas med döden. De bär på blodskuld. ");
INSERT INTO swef_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Om någon ligger med sin svärdotter, ska de båda straffas med döden. De har begått en avskyvärd handling. De bär på blodskuld. ");
INSERT INTO swef_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Om en man ligger med en annan man som en man ligger med en kvinna, begår de en avskyvärd handling. De ska straffas med döden. De bär på blodskuld. ");
INSERT INTO swef_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Om någon till hustru tar en kvinna och dessutom hennes mor, så är det en skändlighet. Man ska bränna upp både honom och dem i eld, för att ingen skändlighet ska finnas ibland er. ");
INSERT INTO swef_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Om en man ligger med ett djur ska han straffas med döden, och djuret ska ni döda. ");
INSERT INTO swef_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Om en kvinna gör närmande mot något djur för att para sig med det, ska du döda både kvinnan och djuret. De ska straffas med döden. De bär på blodskuld. ");
INSERT INTO swef_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Om någon tar sin syster till hustru, sin fars dotter eller sin mors dotter och ser hennes nakenhet, och hon ser hans nakenhet, är det en skamlig gärning. De ska utrotas inför sitt folks ögon. Han bär på missgärning, eftersom han har blottat sin systers nakenhet. ");
INSERT INTO swef_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Om någon ligger med en kvinna som har sin månadsrening och blottar hennes nakenhet, blottar han hennes blodflöde. De ska båda utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Du ska inte blotta nakenheten hos din mors syster eller din fars syster, för den som gör det blottar en nära släktings nakenhet. De kommer att bära på missgärning. ");
INSERT INTO swef_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Om någon ligger med sin farbrors hustru blottar han sin farbrors nakenhet. De kommer att bära på missgärning, och de kommer att dö barnlösa. ");
INSERT INTO swef_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Om någon tar sin brors hustru är det en oren gärning. Han blottar då sin brors nakenhet, och de ska bli barnlösa. ");
INSERT INTO swef_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ni ska hålla alla mina stadgar och lagar och följa dem, för att landet inte ska spy ut er, det land dit jag nu för er så att ni får bo där. ");
INSERT INTO swef_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ni ska inte följa sederna hos de folk som jag driver undan för er, för just därför att de gjort som de gjort avskyr jag dem. ");
INSERT INTO swef_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Därför har jag sagt till er: Ni ska ärva deras land, för jag ska ge er det till arvedel, ett land som flödar av mjölk och honung. Jag är Herren er Gud, som har avskilt er från andra folk. ");
INSERT INTO swef_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Gör alltså skillnad mellan rena och orena fyrfotadjur och mellan rena och orena fåglar, så att ni inte gör er själva avskyvärda på grund av dessa fyrfotadjur eller fåglar eller kräldjur som rör sig på marken, alla dessa djur som jag har avskilt från er som orena. ");
INSERT INTO swef_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ni ska vara heliga inför mig, för jag, Herren, är helig. Och jag har avskilt er från andra folk för att ni ska tillhöra mig. ");
INSERT INTO swef_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","När någon, man eller kvinna, befattar sig med andebesvärjelse eller spådom, ska den personen straffas med döden. Han bär på blodskuld och ska stenas. ");
INSERT INTO swef_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Herren sade till Mose: Tala till prästerna, Arons söner, och säg: En präst får inte orena sig genom någon död bland sitt folk ");
INSERT INTO swef_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","utom genom sina närmaste släktingar: sin mor, sin far, sin son, sin dotter, sin bror ");
INSERT INTO swef_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","eller genom sin syster, om hon var jungfru och stod honom nära och inte tillhörde någon man. I sådant fall får han dra på sig orenhet genom henne. ");
INSERT INTO swef_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Eftersom han är en ledare bland sitt folk, får han inte dra på sig orenhet och göra sig ohelig. ");
INSERT INTO swef_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Prästerna får inte som tecken på sorg raka någon del av sitt huvud, raka av kanten av sitt skägg eller rista något märke på sin kropp. ");
INSERT INTO swef_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","De ska vara heliga inför sin Gud och får inte ohelga sin Guds namn, för de bär fram Herrens eldsoffer, sin Guds mat. Därför ska de vara heliga. ");
INSERT INTO swef_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ingen av dem ska ta till hustru en prostituerad eller en vanärad kvinna. De ska inte heller ta till hustru en kvinna som blivit förskjuten av sin man, för prästen är helgad åt sin Gud. ");
INSERT INTO swef_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Därför ska du hålla honom helig, för han bär fram din Guds mat. Han ska vara helig för dig, för jag, Herren som helgar er, är helig. ");
INSERT INTO swef_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Om en dotter till en präst vanärar sig genom att begå otukt, vanärar hon sin far. Hon ska brännas upp i eld. ");
INSERT INTO swef_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Den som är överstepräst bland sina bröder, den som fått smörjelseoljan utgjuten på sitt huvud och blivit vigd med rätt att bära prästkläderna, ska inte ha sitt hår oordnat eller riva sönder sina kläder. ");
INSERT INTO swef_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Han ska inte gå in till någon död. Varken genom sin far eller sin mor får han orena sig. ");
INSERT INTO swef_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Han ska inte heller gå ut ur helgedomen och inte ohelga sin Guds helgedom, för den vigning han fick genom sin Guds smörjelseolja är över honom. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Till hustru ska han ta en kvinna som är jungfru. ");
INSERT INTO swef_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Han får inte ta en änka eller en frånskild kvinna, eller en vanärad kvinna, en prostituerad. Han ska ta en jungfru av sitt eget folk till hustru, ");
INSERT INTO swef_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","så att han inte ohelgar sina efterkommande bland sitt eget folk, för jag är Herren som helgar honom. ");
INSERT INTO swef_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Säg till Aron: Av dina avkomlingar i kommande släkten ska ingen som har någon defekt träda fram för att frambära sin Guds mat. ");
INSERT INTO swef_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ingen som har någon defekt får träda fram, ingen som är blind eller halt eller vanställd i ansiktet eller har någon lem för stor, ");
INSERT INTO swef_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ingen med bruten arm eller brutet ben, ");
INSERT INTO swef_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ingen som har puckelrygg eller är dvärg eller som har fel på ögat eller skabb eller något annat utslag eller är kastrerad. ");
INSERT INTO swef_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Av prästen Arons avkomlingar ska ingen som har någon defekt gå fram för att offra Herrens eldsoffer. Har han en defekt får han inte gå fram för att offra sin Guds mat. ");
INSERT INTO swef_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Han får äta sin Guds mat, både det som är högheligt och det som är heligt. ");
INSERT INTO swef_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Men eftersom han har en defekt ska han inte gå in till förhänget eller gå fram till altaret så att han ohelgar mina heliga ting, för jag är Herren som helgar dem. ");
INSERT INTO swef_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Detta talade Mose till Aron och hans söner och alla Israels barn. ");
INSERT INTO swef_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Säg till Aron och hans söner att de ska hålla sig borta från de heliga gåvor som Israels barn bär fram åt mig, så att de inte ohelgar mitt heliga namn. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Säg till dem: Om någon av era avkomlingar i kommande släkten rör vid de heliga gåvor som Israels barn bär fram åt Herren medan han är oren, ska han utrotas ur min åsyn. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Om någon av Arons avkomlingar är spetälsk eller har flytning, ska han inte äta av de heliga gåvorna förrän han har blivit ren. Och den som rör vid någon som blivit oren genom en död eller som haft sädesuttömning, ");
INSERT INTO swef_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","eller den som rör vid ett smådjur som orsakar orenhet eller vid en människa som man blir oren av, hur hon än har blivit oren – ");
INSERT INTO swef_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","den som rör vid något sådant ska vara oren ända till kvällen och ska inte äta av de heliga gåvorna förrän han har badat sin kropp i vatten. ");
INSERT INTO swef_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Men när solen har gått ner är han ren, och sedan kan han äta av de heliga gåvorna, eftersom det är hans mat. ");
INSERT INTO swef_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ett självdött eller ihjälrivet djur ska han inte äta så att han blir oren genom det. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","De ska hålla fast vid det jag har befallt dem iaktta, så att de inte bär på synd på grund av det heliga och drabbas av döden därför att de ohelgar det. Jag är Herren som helgar dem. ");
INSERT INTO swef_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ingen främling får äta av det heliga. En inneboende hos prästen eller en daglönare ska inte äta av det heliga. ");
INSERT INTO swef_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Men när en präst har köpt en slav för sina pengar får denne äta av det, liksom den slav som är född i hans hus. De får äta av prästens mat. ");
INSERT INTO swef_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Om en dotter till en präst gifter sig med en lekman får hon inte äta av det heliga som har getts som offergåva. ");
INSERT INTO swef_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Men om dottern till en präst har blivit änka eller blivit förskjuten och inte har några barn och hon kommer tillbaka till sin fars hus och bor där som i sin ungdom, då får hon äta av sin fars mat. Men ingen obehörig ska äta av den. ");
INSERT INTO swef_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Om någon av misstag äter av det heliga, ska han ge en helig offergåva till prästen och lägga till en femtedel. ");
INSERT INTO swef_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Prästerna ska inte ohelga de heliga gåvor som Israels barn offrar åt Herren ");
INSERT INTO swef_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","och därigenom dra missgärning och skuld över dem när de äter av deras heliga gåvor, för jag är Herren som helgar dem. ");
INSERT INTO swef_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Säg till Aron och hans söner och alla Israels barn: Om någon av Israels hus eller av främlingarna i Israel vill bära fram något offer, ett löftesoffer eller ett frivilligt offer, som de vill offra åt Herren som brännoffer, ska ni göra det på sådant sätt att ni blir välbehagliga. ");
INSERT INTO swef_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Offret ska vara ett felfritt handjur av nötboskapen, fåren eller getterna. ");
INSERT INTO swef_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ni ska inte offra ett djur som har någon defekt, för genom ett sådant offer blir ni inte välbehagliga. ");
INSERT INTO swef_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Och när någon vill offra ett gemenskapsoffer åt Herren av nöt- eller av småboskap, antingen för att fullgöra ett löfte eller som ett frivilligt offer, ska det vara felfritt för att bli välbehagligt. Ingen defekt får finnas på offerdjuret. ");
INSERT INTO swef_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Det som är blint eller brutet, stympat eller sårigt eller har skabb eller utslag ska ni inte offra åt Herren. Eldsoffer av något sådant ska ni inte lägga på altaret åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ett djur av nöt eller småboskap som har någon lem för stor eller för liten kan du offra som frivilligt offer, men som löftesoffer blir det inte välbehagligt. ");
INSERT INTO swef_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ni får inte offra åt Herren ett djur vars testiklar blivit klämda, krossade, avslitna eller bortskurna. Sådant ska ni inte göra i ert land. ");
INSERT INTO swef_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Inte heller av en utlänning ska ni ta emot och offra sådana djur till mat åt er Gud, för de är skadade, de har en defekt. Genom sådana blir ni inte välbehagliga. ");
INSERT INTO swef_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","När en kalv, ett lamm eller en killing har fötts, ska djuret dia sin mor i sju dagar. Men från den åttonde dagen är det välbehagligt som eldsoffergåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ni ska inte slakta något djur, vare sig av nöt eller småboskap, på samma dag som dess avkomma. ");
INSERT INTO swef_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","När ni vill offra ett gemenskapsoffer åt Herren, ska ni offra det på sådant sätt att ni blir välbehagliga. ");
INSERT INTO swef_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Det ska ätas samma dag. Ni ska inte lämna något av offret kvar till nästa morgon. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Ni ska hålla mina bud och följa dem. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ni ska inte ohelga mitt heliga namn, för jag ska hållas helig bland Israels barn. Jag är Herren som helgar er ");
INSERT INTO swef_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","och som har fört er ut ur Egyptens land för att vara er Gud. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Säg till Israels barn: Herrens högtider ska ni utlysa som heliga sammankomster, de är mina högtider. ");
INSERT INTO swef_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Under sex dagar ska arbete utföras, men den sjunde dagen är vilosabbat, en dag för helig sammankomst. Inget arbete ska ni då utföra. Det är Herrens sabbat, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Detta är Herrens högtider, de heliga sammankomster som ni ska utlysa på bestämda tider: ");
INSERT INTO swef_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","I första månaden, på kvällen den fjortonde dagen i månaden, är Herrens påsk. ");
INSERT INTO swef_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Och på femtonde dagen i samma månad är Herrens osyrade bröds högtid. Då ska ni äta osyrat bröd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","På den första dagen ska ni hålla en helig sammankomst och inte utföra något arbete. ");
INSERT INTO swef_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Och ni ska offra eldsoffer åt Herren i sju dagar. På sjunde dagen ska ni återigen hålla en helig sammankomst och inte utföra något arbete. ");
INSERT INTO swef_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Säg till Israels barn: När ni kommer in i det land som jag ger er och ni bärgar in dess skörd, ska ni ta den kärve som är det första av er skörd och bära den till prästen. ");
INSERT INTO swef_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Den kärven ska han lyfta inför Herrens ansikte så att ni räknas som välbehagliga. Dagen efter sabbaten ska prästen lyfta den. ");
INSERT INTO swef_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Den dag ni lyfter kärven ska ni offra ett felfritt, årsgammalt lamm som brännoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Som matoffer till det ska ni offra två tiondels efa fint mjöl, blandat med olja, ett eldsoffer åt Herren till en ljuvlig doft, och som dryckesoffer till det en fjärdedels hin vin. ");
INSERT INTO swef_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ni ska inte äta något av den nya skörden, varken bröd eller rostade ax eller korn av grönskuren säd, inte förrän den dagen då ni har burit fram offergåvan åt er Gud. Detta ska vara en evig stadga för er från släkte till släkte, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Sedan ska ni räkna sju hela sabbater från dagen efter sabbaten, från den dag då ni bar fram lyftofferkärven. ");
INSERT INTO swef_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Femtio dagar ska ni räkna, fram till dagen efter den sjunde sabbaten. Då ska ni bära fram ett nytt matoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Från de orter där ni bor ska ni bära fram lyftofferbröd, två kakor gjorda av två tiondels efa fint mjöl, bakade med surdeg. De är en förstlingsgåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Och tillsammans med brödet ska ni föra fram sju felfria, årsgamla lamm, en ungtjur och två baggar som brännoffer åt Herren, med det matoffer och dryckesoffer som hör till. Det är ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Dessutom ska ni offra en bock som syndoffer och två årsgamla lamm som gemenskapsoffer. ");
INSERT INTO swef_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Prästen ska lyfta dem som ett lyftoffer inför Herrens ansikte tillsammans med förstlingsbröden som bärs fram med de båda lammen. De ska vara helgade åt Herren och tillhöra prästen. ");
INSERT INTO swef_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Och samma dag ska ni utlysa en helig sammankomst, som ni ska hålla. Inget arbete ska ni då utföra. Detta ska vara en evig stadga för er från släkte till släkte, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","När ni bärgar skörden i ert land ska du inte skörda till yttersta kanten av din åker, och du ska inte heller plocka ströaxen efter din skörd. Du ska lämna kvar det åt den fattige och åt främlingen. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Säg till Israels barn: I sjunde månaden, på första dagen i månaden, ska ni hålla sabbatsvila, en minneshögtid med basunklang, en helig sammankomst. ");
INSERT INTO swef_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Inget arbete ska ni då utföra, och ni ska offra eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Men på tionde dagen i samma sjunde månad är försoningsdagen. Då ska ni hålla en helig sammankomst, och ni ska fasta och offra eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","På den dagen ska ni inte utföra något arbete, för det är en försoningsdag då försoning bringas för er inför Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Var och en som inte fastar på denna dag ska utrotas ur sin släkt. ");
INSERT INTO swef_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Och var och en som utför något arbete på just den dagen ska jag utrota ur hans folk. ");
INSERT INTO swef_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Inget arbete ska ni utföra. Detta ska vara en evig stadga för er från släkte till släkte, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","En vilosabbat ska den vara för er, och ni ska då fasta. På kvällen den nionde dagen i månaden ska ni hålla denna sabbatsvila, från kväll till kväll. ");
INSERT INTO swef_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Säg till Israels barn: På femtonde dagen i samma sjunde månad är det Herrens lövhyddohögtid i sju dagar. ");
INSERT INTO swef_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","På den första dagen ska man hålla en helig sammankomst och inte utföra något arbete. ");
INSERT INTO swef_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","I sju dagar ska ni offra eldsoffer åt Herren. På åttonde dagen ska ni hålla en helig sammankomst och offra eldsoffer åt Herren. Det är en högtidsförsamling. Inget arbete ska ni då utföra. ");
INSERT INTO swef_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Detta är Herrens högtider. Ni ska utlysa dem som heliga sammankomster och offra eldsoffer åt Herren, brännoffer och matoffer, slaktoffer och dryckesoffer, varje dag de bestämda offren för den dagen. ");
INSERT INTO swef_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Detta är utöver Herrens sabbater och era övriga gåvor och alla era löftesoffer och alla era frivilliga offer som ni ger åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Alltså ska ni på femtonde dagen i sjunde månaden, när ni har hämtat in landets skörd, fira Herrens högtid i sju dagar. Den första dagen är en sabbatsvila, och den åttonde dagen är också en sabbatsvila. ");
INSERT INTO swef_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","På första dagen ska ni ta frukt av era vackraste träd, kvistar av palmer och grenar av lummiga träd och av pilträd, och ni ska glädja er i sju dagar inför Herren er Guds ansikte. ");
INSERT INTO swef_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ni ska fira denna högtid som en Herrens högtid sju dagar om året. Detta ska vara en evig stadga för er från släkte till släkte. I sjunde månaden ska ni fira den. ");
INSERT INTO swef_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Då ska ni bo i lövhyddor i sju dagar. Alla infödda i Israel ska bo i lövhyddor, ");
INSERT INTO swef_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","för att era efterkommande ska veta att jag lät Israels barn bo i lövhyddor när jag förde dem ut ur Egyptens land. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Och Mose talade till Israels barn om Herrens högtider. ");
INSERT INTO swef_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Befall Israels barn att bära till dig ren olja av stötta oliver till ljusstaken, så att lamporna kan sättas upp varje dag. ");
INSERT INTO swef_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Utanför förhänget framför vittnesbördet i uppenbarelsetältet ska Aron ständigt sköta den inför Herrens ansikte, från kväll till morgon. Det ska vara en evig stadga för er från släkte till släkte. ");
INSERT INTO swef_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Lamporna på den gyllene ljusstaken ska han ständigt sköta inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Du ska ta fint mjöl och baka tolv kakor av det. Varje kaka ska innehålla två tiondels efa. ");
INSERT INTO swef_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Du ska lägga upp dem i två rader, sex i var rad, på det förgyllda bordet inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","På varje rad ska du lägga ren rökelse, och den ska vara ett påminnelseoffer för bröden, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sabbatsdag efter sabbatsdag ska man ständigt lägga upp dem inför Herrens ansikte, en gåva av Israels barn till ett evigt förbund. ");
INSERT INTO swef_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","De ska tillhöra Aron och hans söner, och de ska äta dem på helig plats, för de är högheliga och är hans del av Herrens eldsoffer. Detta är en evig stadga. ");
INSERT INTO swef_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","En man som var son till en israelitisk kvinna och en egyptisk man gick ut bland Israels barn. Den israelitiska kvinnans son och en israelitisk man kom då i gräl med varandra i lägret. ");
INSERT INTO swef_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Och den israelitiska kvinnans son smädade Namnet och hädade. Då förde de honom fram till Mose. Hans mor hette Shelomit, dotter till Dibri, av Dans stam. ");
INSERT INTO swef_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","De satte honom i förvar för att få ett bestämt uttalande från Herrens mun. ");
INSERT INTO swef_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","För ut hädaren utanför lägret. Sedan ska alla som hörde hädelsen lägga sina händer på hans huvud, och hela församlingen ska stena honom. ");
INSERT INTO swef_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Till Israels barn ska du säga: Om någon hädar sin Gud kommer han att bära på synd. ");
INSERT INTO swef_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Och den som smädar Herrens namn ska straffas med döden. Hela församlingen ska stena honom. Vare sig det är en främling eller en infödd som smädar Namnet ska han dödas. ");
INSERT INTO swef_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Den som slår ihjäl en människa ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Och den som slår ihjäl ett boskapsdjur ska ersätta det: liv för liv. ");
INSERT INTO swef_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Om någon tillfogar sin nästa kroppsskada, ska man göra mot honom som han själv har gjort: ");
INSERT INTO swef_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","bruten lem för bruten lem, öga för öga, tand för tand. Samma skada som han har vållat en annan, ska han själv tillfogas. ");
INSERT INTO swef_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Den som slår ihjäl ett boskapsdjur ska ersätta det, och den som slår ihjäl en människa ska dödas. ");
INSERT INTO swef_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","En och samma lag ska gälla för er, såväl för främlingen som för den infödde, för jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose talade detta till Israels barn. Och de förde ut hädaren utanför lägret och stenade honom. Israels barn gjorde så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Herren talade till Mose på Sinai berg. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Säg till Israels barn: När ni kommer in i det land som jag ger er, ska landet hålla sabbat åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sex år ska du beså din åker och i sex år beskära din vingård och skörda avkastningen från jorden, ");
INSERT INTO swef_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","men under det sjunde året ska landet ha sabbatsvila, en Herrens sabbat. Då ska du inte beså din åker och inte beskära din vingård. ");
INSERT INTO swef_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Det som växer upp av spillsäden efter din skörd ska du inte bärga, och druvorna som växer på dina obeskurna vinstockar ska du inte skörda. Det ska vara ett år av sabbatsvila för landet. ");
INSERT INTO swef_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Vad landets sabbat ändå ger ska ni ha till föda, du själv, din slav och din slavinna, din daglönare och din inneboende, alla som bor hos dig. ");
INSERT INTO swef_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Din boskap och de vilda djuren i ditt land ska också ha sin föda av all dess avkastning. ");
INSERT INTO swef_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Du ska räkna sju årssabbater, det vill säga sju gånger sju år, så att tiden för de sju årssabbaterna blir fyrtionio. ");
INSERT INTO swef_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Då ska du i sjunde månaden på tionde dagen i månaden låta basunen ljuda med kraftig ton. På försoningsdagen ska ni låta basunen ljuda över hela ert land. ");
INSERT INTO swef_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ni ska helga det femtionde året och utropa frihet i landet för alla dess invånare. Det ska vara ett jubelår för er. Var och en av er ska då återvända till sin arvedel och var och en av er ska återvända till sin släkt. ");
INSERT INTO swef_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ett jubelår ska detta femtionde år vara för er. Då ska ni inte så något, och det som växer upp av spillsäden ska ni inte skörda, och ni ska inte samla in druvorna från era oskurna vinstockar, ");
INSERT INTO swef_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","för det är ett jubelår. Heligt ska det vara för er. Av markens egen avkastning ska ni få er föda. ");
INSERT INTO swef_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Under ett sådant jubelår ska var och en av er återvända till sin arvedel. ");
INSERT INTO swef_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Om ni alltså säljer något till er nästa eller köper något av honom, ska ni inte göra varandra orätt. ");
INSERT INTO swef_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Efter antalet år från jubelåret ska du betala din nästa och efter antalet årsgrödor ska han få betalning av dig. ");
INSERT INTO swef_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ju fler åren är, desto högre pris ska du betala, och ju färre de är, desto lägre pris ska du betala. Det är ju ett visst antal grödor han säljer till dig. ");
INSERT INTO swef_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ni ska inte göra varandra orätt, du ska frukta din Gud, för jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ni ska följa mina stadgar och mina lagar ska ni ta vara på och följa. Ni kommer då att bo trygga i landet. ");
INSERT INTO swef_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Och landet kommer att ge sin frukt, så att ni har att äta i överflöd, och ni kan bo där i trygghet. ");
INSERT INTO swef_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Om ni frågar: ”Vad ska vi äta under det sjunde året, om vi varken får så eller bärga vår gröda?” ");
INSERT INTO swef_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","så ska ni veta att jag ska befalla min välsignelse att komma över er under det sjätte året, så att det ger gröda för tre år. ");
INSERT INTO swef_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ännu när ni sår under det åttonde året ska ni ha av den gamla grödan att äta. Ända tills grödan har kommit in på det nionde året ska ni ha gammal säd att äta. ");
INSERT INTO swef_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","När ni säljer jord ska ni inte sälja den för all framtid, för landet är mitt. Ni är främlingar och gäster hos mig. ");
INSERT INTO swef_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","I hela det land ni får till besittning ska ni medge rätt att köpa tillbaka jordegendom. ");
INSERT INTO swef_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Om din broder blir fattig och säljer något av sin besittning, ska hans återlösare komma till honom och lösa tillbaka det brodern har sålt. ");
INSERT INTO swef_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Om någon inte har någon återlösare, men själv får möjlighet att skaffa vad som behövs för återköp, ");
INSERT INTO swef_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ska han räkna efter hur många år som gått efter försäljningen och betala lösen för de återstående åren till den han sålde åt. Han ska så återvända till sin egendom. ");
INSERT INTO swef_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Men om han inte kan skaffa vad som behövs för att betala honom, ska det han har sålt förbli i köparens hand till jubelåret. Men på jubelåret ska det frånträdas, och han ska återvända till sin arvedel. ");
INSERT INTO swef_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Om någon säljer ett hus i en stad som är omgiven av murar, ska han ha rätt att återlösa det inom ett år efter försäljningen. Hans rätt att återlösa det är då begränsad till viss tid. ");
INSERT INTO swef_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Men om det inte har köpts tillbaka när ett helt år har gått ska huset, om det ligger i en stad som är omgiven av murar, förbli köparens och hans efterkommandes egendom för alltid. Det ska då inte frånträdas på jubelåret. ");
INSERT INTO swef_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Men hus i byar som inte är omgivna av murar ska räknas till landets åkermark. De ska kunna återlösas, och på jubelåret ska de frånträdas. ");
INSERT INTO swef_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Angående leviternas städer ska leviterna ha evig rätt att återlösa husen i de städer som är deras arvsbesittning. ");
INSERT INTO swef_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Även om någon annan levit löser in det sålda huset i den stad där han har sin egendom ska det frånträdas på jubelåret, för husen i levitstäderna är leviternas arvsbesittning bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Och ett fält som är betesmark utanför någon av deras städer får inte säljas, för det är deras eviga arvedel. ");
INSERT INTO swef_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Om din broder blir fattig och inte kan försörja sig hos dig, ska du ta dig an honom. Som en främling eller inneboende ska han få leva hos dig. ");
INSERT INTO swef_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Du ska inte ockra mot honom eller ta ränta, utan du ska frukta din Gud och låta din broder leva hos dig. ");
INSERT INTO swef_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Du ska inte låna honom pengar mot ockerränta eller ge honom av din mat mot ränta. ");
INSERT INTO swef_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Jag är Herren er Gud, som har fört er ut ur Egyptens land för att ge er Kanaans land och vara er Gud. ");
INSERT INTO swef_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Om din broder råkar i fattigdom hos dig och säljer sig åt dig, ska du inte låta honom utföra slavarbete. ");
INSERT INTO swef_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Som en daglönare och en inneboende ska han vara hos dig. Fram till jubelåret ska han tjäna hos dig. ");
INSERT INTO swef_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Då ska han lämna dig, han själv och hans barn tillsammans med honom, och han ska återvända till sin släkt och till sina fäders arvedel. ");
INSERT INTO swef_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","De är ju mina tjänare som jag har fört ut ur Egyptens land. De ska inte säljas som man säljer slavar. ");
INSERT INTO swef_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Och du ska inte härska över dem med hårdhet. Du ska frukta din Gud. ");
INSERT INTO swef_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Men om du vill skaffa dig en slav eller slavinna, ska du köpa en sådan från hednafolken som bor runt omkring er. ");
INSERT INTO swef_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ni kan också köpa slavar bland barnen till dem som bor ibland er och bland deras släktingar som ni har hos er och som är födda i ert land. De ska förbli er egendom. ");
INSERT INTO swef_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Dem kan ni ha att lämna som arv åt era barn efter er, till egendom och besittning. Dem kan ni ha till slavar för all framtid. Men bland era bröder, Israels barn, ska ingen härska över den andre med hårdhet. ");
INSERT INTO swef_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Om en främling eller inneboende hos dig kommer till välstånd och en av dina bröder råkar i fattigdom hos honom och säljer sig åt främlingen som bor hos dig, eller åt någon annan som tillhör en främmande släkt, ");
INSERT INTO swef_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ska han kunna bli friköpt sedan han har sålt sig. Någon av hans bröder kan friköpa honom. ");
INSERT INTO swef_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Eller också kan hans farbror eller hans kusin friköpa honom, eller någon annan nära släkting, eller han själv om han klarar det och kan köpa sig fri. ");
INSERT INTO swef_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Då ska han tillsammans med den som köpt honom räkna efter hur lång tid som gått, från det år då han sålde sig, fram till jubelåret. Det pris han såldes för ska uppskattas efter årens antal. Hans arbetstid hos honom ska beräknas till samma värde som en daglönares. ");
INSERT INTO swef_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Om det ännu är många år kvar, ska han som lösen för sig betala en motsvarande del av det pengabelopp som han köptes för. ");
INSERT INTO swef_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Om däremot bara några få år återstår till jubelåret, ska han tillgodoräkna sig det och betala lösen för sig efter antalet av sina år. ");
INSERT INTO swef_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Han ska behandlas som en daglönare som anställs år för år. Ingen får inför dina ögon härska över honom med hårdhet. ");
INSERT INTO swef_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Men om han inte blir löst på något av de nämnda sätten ska han friges på jubelåret, han själv och hans barn tillsammans med honom, ");
INSERT INTO swef_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","för Israels barn är mina tjänare. De är mina tjänare som jag har fört ut ur Egyptens land. Jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ni ska inte göra er några avgudar och inte resa upp åt er någon avbild eller stod och inte heller i ert land sätta upp några stenar med bilder för att tillbe dem, för jag är Herren er Gud. ");
INSERT INTO swef_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mina sabbater ska ni hålla, och min helgedom ska ni vörda. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Om ni vandrar efter mina stadgar och håller mina bud och följer dem, ");
INSERT INTO swef_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ska jag ge er regn i rätt tid så att jorden ger sin gröda och träden på marken bär sin frukt. ");
INSERT INTO swef_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Trösktiden ska hos er räcka till vinbärgningen, och vinbärgningen ska räcka till såningstiden, och ni ska ha bröd nog för att äta er mätta och ni ska bo trygga i ert land. ");
INSERT INTO swef_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Och jag ska ge frid i landet, ni ska få ro och ingen ska skrämma er. Jag ska göra slut på vilddjuren i landet, och inget svärd ska gå fram genom ert land. ");
INSERT INTO swef_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ni ska jaga era fiender framför er, och de ska falla för era svärd. ");
INSERT INTO swef_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Fem av er ska jaga hundra framför sig, och hundra av er ska jaga tiotusen, och era fiender ska falla för era svärd. ");
INSERT INTO swef_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Jag ska vända mig till er och göra er fruktsamma och föröka er, och jag ska upprätthålla mitt förbund med er. ");
INSERT INTO swef_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Gammal gröda, som legat inne länge, ska ni ha att äta. Ni ska tvingas skaffa undan den gamla för den nya. ");
INSERT INTO swef_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Och jag ska resa upp min boning mitt ibland er, och jag ska inte avvisa er. ");
INSERT INTO swef_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Jag ska vandra bland er och vara er Gud, och ni ska vara mitt folk. ");
INSERT INTO swef_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Jag är Herren er Gud som förde er ut ur Egyptens land, för att ni inte skulle vara slavar där. Jag har brutit sönder ert ok och låtit er gå med upprätt huvud. ");
INSERT INTO swef_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Men om ni inte hör på mig och inte gör efter alla dessa bud, ");
INSERT INTO swef_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","om ni föraktar mina stadgar och avvisar mina lagar, så att ni inte följer alla mina bud utan bryter mitt förbund, ");
INSERT INTO swef_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","då ska också jag handla på samma sätt mot er. Jag ska straffa er med skräck, med tärande sjukdom och feber, så att era ögon försmäktar och er själ tynar bort. Och ni ska så er säd förgäves, för era fiender ska äta den. ");
INSERT INTO swef_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Jag ska vända mitt ansikte mot er, och ni ska bli slagna av era fiender. De som hatar er ska råda över er, och ni ska fly, även om ingen förföljer er. ");
INSERT INTO swef_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Om ni trots detta inte lyssnar till mig, ska jag tukta er sjufalt värre för era synders skull. ");
INSERT INTO swef_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Jag ska krossa er stolta makt och låta er himmel bli som järn och er jord som koppar. ");
INSERT INTO swef_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Er möda ska vara förgäves, för er jord ska inte ge sin gröda och träden i landet ska inte bära frukt. ");
INSERT INTO swef_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Om ni ändå gör mig emot och inte vill lyssna på mig, ska jag slå er sjufalt värre, som era synder förtjänar. ");
INSERT INTO swef_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Jag ska sända över er vilddjur, som ska döda era barn och fördärva er boskap och få er att minska i antal så att era vägar blir öde. ");
INSERT INTO swef_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Om ni trots detta inte låter varna er av mig utan står mig emot, ");
INSERT INTO swef_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ska också jag stå er emot och slå er sjufalt för era synders skull. ");
INSERT INTO swef_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Jag ska låta er drabbas av ett hämndens svärd som ska hämnas mitt förbund, och ni ska samlas i städerna. Men där ska jag sända pest ibland er, och ni ska bli överlämnade i fienders hand. ");
INSERT INTO swef_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Jag ska fördärva ert livsuppehälle så att ert bröd ska kunna bakas i en enda ugn av tio kvinnor. Brödet ska lämnas ut efter vikt, och när ni äter ska ni inte bli mätta. ");
INSERT INTO swef_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Om ni trots detta inte lyssnar till mig utan står mig emot, ");
INSERT INTO swef_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ska också jag i vrede stå er emot och tukta er sjufalt för era synders skull. ");
INSERT INTO swef_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ni ska tvingas äta era söners och döttrars kött. ");
INSERT INTO swef_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Jag ska ödelägga era offerhöjder och utrota era solstoder. Jag ska kasta era döda kroppar på era eländiga avgudars döda kroppar, och jag ska visa er ifrån mig. ");
INSERT INTO swef_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Jag ska göra era städer till ruiner och ödelägga era helgedomar, och jag ska inte mer med välbehag känna doften av era offer. ");
INSERT INTO swef_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Jag ska själv ödelägga landet, så att era fiender som bor där ska häpna över det. ");
INSERT INTO swef_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Men er ska jag sprida ut bland hednafolken och jag ska förfölja er med draget svärd. Så ska ert land bli en ödemark och era städer ruiner. ");
INSERT INTO swef_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Då ska landet få gottgörelse för sina sabbater under hela den tid som det ligger öde och ni är i era fienders land. Ja, då ska landet vila och få gottgörelse för sina sabbater. ");
INSERT INTO swef_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Hela den tid det ligger öde ska det hålla sabbat och få den vila det inte fick på era sabbater, då ni bodde där. ");
INSERT INTO swef_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Och åt dem som blir kvar av er, ska jag ge försagda hjärtan där de är i sina fienders länder, så att de jagas på flykten av ett prasslande löv som rörs av vinden. De ska fly som om de flydde för svärd och falla, även om ingen förföljer dem. ");
INSERT INTO swef_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","De ska stupa på varandra som om de stupade för svärd, även om ingen förföljer dem. Ni ska inte kunna hålla stånd mot era fiender. ");
INSERT INTO swef_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ni ska förgås bland hednafolken, och era fienders land ska förtära er. ");
INSERT INTO swef_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","De som blir kvar av er ska genom sin egen missgärning tyna bort i era fienders land. Också genom sina fäders missgärning ska de tyna bort, liksom dessa har gjort. ");
INSERT INTO swef_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","De ska bekänna den missgärning de själva har begått och den deras fäder har begått, att de har handlat trolöst mot mig och stått emot mig, ");
INSERT INTO swef_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","så att också jag måste stå emot dem och föra bort dem till deras fienders land. Då ska deras oomskurna hjärtan tvingas att ödmjuka sig, och de ska få lida för sin missgärning. ");
INSERT INTO swef_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Då ska jag tänka på mitt förbund med Jakob, och jag ska också tänka på mitt förbund med Isak och på mitt förbund med Abraham. Och jag ska tänka på landet, ");
INSERT INTO swef_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","för landet ska överges av dem och få gottgörelse för sina sabbater genom att ligga öde när folket är borta. Själva ska de få lida för sin missgärning, just därför att de förkastade mina lagar och därför att de avvisade mina stadgar. ");
INSERT INTO swef_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Men när de är i sina fienders land ska jag trots detta inte förkasta eller avvisa dem så att jag förgör dem och bryter mitt förbund med dem, för jag är Herren deras Gud. ");
INSERT INTO swef_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nej, dem till godo ska jag tänka på förbundet med fäderna, som jag förde ut ur Egyptens land inför hednafolkens ögon, för att jag skulle vara deras Gud. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dessa är de stadgar, domslut och lagar som Herren fastställde mellan sig och Israels barn på Sinai berg genom Mose. ");
INSERT INTO swef_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Säg till Israels barn: Om någon ger ett heligt löfte, ska du bestämma lösensumman åt Herren för personerna. ");
INSERT INTO swef_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Gäller det en man mellan tjugo och sextio år gammal ska du bestämma det till femtio siklar silver efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Gäller det en kvinna ska du fastställa värdet till trettio siklar. ");
INSERT INTO swef_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Gäller det någon som är mellan fem och tjugo år gammal, ska värdet du fastställer vara tjugo siklar för en pojke och tio siklar för en flicka. ");
INSERT INTO swef_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Gäller det någon som är mellan en månad och fem år gammal, ska värdet du bestämmer vara fem siklar silver för en pojke och tre siklar silver för en flicka. ");
INSERT INTO swef_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Gäller det någon som är sextio år gammal eller över, ska värdet du bestämmer vara femton siklar för en man och tio siklar för en kvinna. ");
INSERT INTO swef_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Om någon är så fattig att han inte kan betala det värde du bestämmer ska han ställas fram inför prästen, som ska fastställa ett värde för honom. Efter vad den som gjort löftet kan betala ska prästen fastställa värdet för honom. ");
INSERT INTO swef_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Om det gäller boskap av de slag man får bära fram som offer åt Herren, ska allt sådant vara heligt sedan man gett det åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Man får inte utväxla eller byta ut det, varken ett bättre mot ett sämre eller ett sämre mot ett bättre. Om någon ändå byter ut ett djur mot ett annat, ska både det förra och det som lämnats i utbyte vara heligt. ");
INSERT INTO swef_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Men om det gäller ett orent djur som man inte får bära fram som offer åt Herren, ska djuret ställas fram inför prästen. ");
INSERT INTO swef_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Han ska fastställa dess värde med hänsyn till om det är bättre eller sämre. Som du, prästen, fastställer det, så ska det vara. ");
INSERT INTO swef_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Om ägaren vill lösa djuret, ska han till värdet du har bestämt lägga en femtedel av värdet. ");
INSERT INTO swef_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Om någon helgar sitt hus som något heligt åt Herren, ska prästen fastställa dess värde med hänsyn till om det är bättre eller sämre. Som han fastställer dess värde, så ska det vara. ");
INSERT INTO swef_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Om den som har helgat sitt hus vill lösa det, ska han till det värde i pengar som du har bestämt lägga en femtedel. Då blir det hans. ");
INSERT INTO swef_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Om någon helgar åt Herren en åkermark av den egendom han ärvt, ska du bestämma dess värde efter utsädet på den. Varje homer utsäde ska motsvara femtio siklar silver. ");
INSERT INTO swef_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Om han helgar sin åker ända från jubelåret, ska det förbli vid det värde du bestämmer. ");
INSERT INTO swef_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Men om han helgar sin åker efter jubelåret, ska prästen beräkna pengavärdet åt honom efter det antal år som återstår till nästa jubelår. Ett motsvarande avdrag ska göras på det värde du förut har bestämt. ");
INSERT INTO swef_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Om den som har helgat åkern vill lösa den, ska han lägga till en femtedel till det pris du har bestämt. Då förblir den hans. ");
INSERT INTO swef_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Om han inte löser åkern utan säljer den till någon annan får åkern sedan inte lösas, ");
INSERT INTO swef_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","utan när den frånträds på jubelåret ska den vara helgad åt Herren som vigd mark. Hans egendom tillfaller då prästen. ");
INSERT INTO swef_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Om någon helgar åt Herren en åker som han har köpt och som inte hör till den egendom han ärvt, ");
INSERT INTO swef_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ska prästen räkna ut det bestämda värdet åt honom fram till jubelåret, och samma dag ska han erlägga den summa som du har bestämt. Den ska vara helgad åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Men på jubelåret ska åkern gå tillbaka till den som den köpts ifrån, till den som ägde den som sin egendom. ");
INSERT INTO swef_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","När du bestämmer ett värde ska det alltid bestämmas i helgedomssiklar, sikeln räknad till tjugo gera. ");
INSERT INTO swef_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Det som är förstfött bland boskap och som tillhör Herren redan som förstfött ska ingen helga. Vare sig det är en oxe eller ett får tillhör det redan Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Men om det är fråga om något orent djur, ska man lösa det efter det värde du bestämmer och lägga till femtedelen av värdet. Om det inte blir löst, ska det säljas efter det värde du bestämmer. ");
INSERT INTO swef_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Gäller det något vigt som någon har avskilt åt Herren från det han äger, antingen en människa eller ett boskapsdjur eller den åker som han har fått i arv, får det varken säljas eller lösas. Allt som är vigt är högheligt och tillhör Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","En människa som är vigd åt förintelse får aldrig lösas. Hon måste dödas. ");
INSERT INTO swef_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Allt tionde av jorden tillhör Herren, både av markens säd och av trädens frukt. Den är helgad åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Om någon vill lösa något av sitt tionde ska han lägga till femtedelen av värdet. ");
INSERT INTO swef_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","För tionde av nöt eller småboskap gäller följande: Av allt som går under herdestaven ska vart tionde djur vara helgat åt Herren. ");
INSERT INTO swef_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Man ska inte undersöka om det är bättre eller sämre, och man får inte byta ut det. Om någon ändå byter ut djuret, ska både detta och det som har lämnats i utbyte vara helgat åt Herren. Det får inte lösas. ");
INSERT INTO swef_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dessa är de bud som Herren genom Mose gav Israels barn på Sinai berg. ");
INSERT INTO swef_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Herren talade till Mose i Sinai öken, i uppenbarelsetältet, på första dagen i andra månaden av det andra året efter deras uttåg ur Egyptens land. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","”Räkna antalet av Israels barn, hela deras församling efter deras släkter och familjer. Skriv upp namnen på alla män, varje person för sig, ");
INSERT INTO swef_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","alla vapenföra i Israel från tjugo år och uppåt. Du och Aron ska mönstra dem efter deras häravdelningar. ");
INSERT INTO swef_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","En man från varje stam ska vara med er, den som är huvudman för sin stams familjer. ");
INSERT INTO swef_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Detta är namnen på de män som ska bistå er: Från Ruben: Elisur, Shedeurs son, ");
INSERT INTO swef_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","från Simeon: Shelumiel, Surishaddajs son, ");
INSERT INTO swef_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","från Juda: Nahshon, Amminadabs son, ");
INSERT INTO swef_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","från Isaskar: Netanel, Suars son, ");
INSERT INTO swef_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","från Sebulon: Eliab, Helons son, ");
INSERT INTO swef_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","från Josefs barn: från Efraim: Elishama, Ammihuds son, från Manasse: Gamliel, Pedasurs son, ");
INSERT INTO swef_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","från Benjamin: Abidan, Gideonis son, ");
INSERT INTO swef_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","från Dan: Ahieser, Ammishaddajs son, ");
INSERT INTO swef_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","från Asher: Pagiel, Okrans son, ");
INSERT INTO swef_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","från Gad: Eljasaf, Deguels son, ");
INSERT INTO swef_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","från Naftali: Ahira, Enans son.” ");
INSERT INTO swef_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Dessa var utvalda från församlingen. De var ledare för sina fäders stammar, stamhövdingar i Israel. ");
INSERT INTO swef_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mose och Aron tog med sig dessa namngivna män. ");
INSERT INTO swef_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","De samlade hela församlingen på första dagen i andra månaden, och folket infördes i förteckningen efter sina släkter och familjer. Var och en blev räknad, de som var tjugo år eller äldre, varje person för sig, ");
INSERT INTO swef_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","så som Herren hade befallt Mose. Och han mönstrade dem i Sinai öken. ");
INSERT INTO swef_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Avkomlingarna till Rubens, Israels förstföddes, söner upptecknades efter sina släkter och familjer. Var och en räknades, var person för sig, alla vapenföra män från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","De mönstrade av Rubens stam var 46 500. ");
INSERT INTO swef_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Avkomlingarna till Simeons söner mönstrades och upptecknades efter sina släkter och familjer. Var och en räknades, var person för sig, alla vapenföra män från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","De mönstrade av Simeons stam var 59 300. ");
INSERT INTO swef_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Avkomlingarna till Gads söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","De mönstrade av Gads stam var 45 650. ");
INSERT INTO swef_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Avkomlingarna till Judas söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","De mönstrade av Juda stam var 74 600. ");
INSERT INTO swef_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Avkomlingarna till Isaskars söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","De mönstrade av Isaskars stam var 54 400. ");
INSERT INTO swef_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Avkomlingarna till Sebulons söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","De mönstrade av Sebulons stam var 57 400. ");
INSERT INTO swef_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Avkomlingarna till Josefs söner: Avkomlingarna till Efraims söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","De mönstrade av Efraims stam var 40 500. ");
INSERT INTO swef_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Avkomlingarna till Manasses söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","De mönstrade av Manasse stam var 32 200. ");
INSERT INTO swef_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Avkomlingarna till Benjamins söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","De mönstrade av Benjamins stam var 35 400. ");
INSERT INTO swef_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Avkomlingarna till Dans söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","De mönstrade av Dans stam var 62 700. ");
INSERT INTO swef_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Avkomlingarna till Ashers söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","De mönstrade av Ashers stam var 41 500. ");
INSERT INTO swef_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Avkomlingarna till Naftalis söner upptecknades efter sina släkter och familjer. Var och en räknades, alla vapenföra från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","De mönstrade av Naftali stam var 53 400. ");
INSERT INTO swef_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dessa var de mönstrade, de som mönstrades av Mose och Aron och Israels hövdingar, tolv män som var och en företrädde sin stamfamilj. ");
INSERT INTO swef_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Och alla Israels barn mönstrades efter deras familjer, alla vapenföra i Israel från tjugo år och uppåt. ");
INSERT INTO swef_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Alla de mönstrade var tillsammans 603 550. ");
INSERT INTO swef_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Men leviterna i sin fädernestam mönstrades inte med de andra, ");
INSERT INTO swef_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","för Herren hade sagt till Mose: ");
INSERT INTO swef_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Endast Levi stam ska du inte mönstra, och du ska inte räkna deras antal med Israels barn, ");
INSERT INTO swef_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","utan du ska ge leviterna ansvar för vittnesbördets tabernakel med alla dess föremål och tillbehör. De ska bära tabernaklet och alla dess föremål och göra tjänst vid det. Runt omkring tabernaklet ska de ha sitt läger. ");
INSERT INTO swef_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","När tabernaklet ska bryta upp ska leviterna ta ner det, och när tabernaklet ska sättas upp ska leviterna sätta upp det. Om någon annan kommer nära det ska han dödas. ");
INSERT INTO swef_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israels barn ska resa sina tält var och en i sitt läger och var och en under sitt baner, efter sina häravdelningar. ");
INSERT INTO swef_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Men leviterna ska slå läger runt omkring vittnesbördets tabernakel, så att inte vrede drabbar Israels barns församling. Och leviterna ska ha ansvaret för vittnesbördets tabernakel och dess skötsel. ");
INSERT INTO swef_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israels barn gjorde så. I allt gjorde de som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","”Israels barn ska slå läger, var och en under sitt baner, vid de fälttecken som hör till deras särskilda familjer. Runt omkring uppenbarelsetältet ska de slå läger, en bit bort. ");
INSERT INTO swef_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","På framsidan, österut, ska Juda slå läger under sitt baner efter sina häravdelningar. Ledare för Juda barn ska vara Nahshon, Amminadabs son, ");
INSERT INTO swef_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","med de mönstrade som utgör hans här, 74 600 man. ");
INSERT INTO swef_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Bredvid honom ska Isaskars stam slå läger. Ledare för Isaskars barn ska vara Netanel, Suars son, ");
INSERT INTO swef_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","med de mönstrade som utgör hans här, 54 400 man. ");
INSERT INTO swef_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Därnäst Sebulons stam, och ledare för Sebulons barn ska vara Eliab, Helons son, ");
INSERT INTO swef_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","med de mönstrade som utgör hans här, 57 400 man. ");
INSERT INTO swef_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Alla de mönstrade som tillhör Juda läger utgör 186 400 man, delade i sina häravdelningar. De ska bryta upp först. ");
INSERT INTO swef_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ruben ska slå läger under sitt baner söderut efter sina häravdelningar. Ledare för Rubens barn ska vara Elisur, Shedeurs son, ");
INSERT INTO swef_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","med de mönstrade som utgör hans här, 46 500 man. ");
INSERT INTO swef_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Bredvid honom ska Simeons stam slå läger, och ledare för Simeons barn ska vara Shelumiel, Surishaddajs son, ");
INSERT INTO swef_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","med de mönstrade som utgör hans här, 59 300 man. ");
INSERT INTO swef_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Därnäst Gads stam, och ledare för Gads barn ska vara Eljasaf, Reguels son, ");
INSERT INTO swef_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","med de mönstrade som utgör hans här, 45 650 man. ");
INSERT INTO swef_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Alla de mönstrade som tillhör Rubens läger utgör 151 450 man, delade i sina häravdelningar. De ska bryta upp som nummer två. ");
INSERT INTO swef_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sedan ska uppenbarelsetältet gå med leviternas läger i mitten av lägren. I den ordning de slår läger ska de också gå, var och en på sin plats, under sina baner. ");
INSERT INTO swef_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraim ska slå läger under sitt baner västerut, efter sina häravdelningar. Ledare för Efraims barn ska vara Elishama, Ammihuds son, ");
INSERT INTO swef_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","med de mönstrade som utgör hans här, 40 500 man. ");
INSERT INTO swef_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Bredvid honom ska Manasse stam slå läger, och ledare för Manasse barn ska vara Gamliel, Pedasurs son, ");
INSERT INTO swef_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","med de mönstrade som utgör hans här, 32 200 man. ");
INSERT INTO swef_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Därnäst Benjamins stam, och ledare för Benjamins barn ska vara Abidan, Gideonis son, ");
INSERT INTO swef_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","med de mönstrade som utgör hans här, 35 400 man. ");
INSERT INTO swef_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Alla de mönstrade som tillhör Efraims läger utgör 108 100 man, delade i sina häravdelningar. De ska bryta upp som nummer tre. ");
INSERT INTO swef_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan ska slå läger under sitt baner norrut, efter sina häravdelningar. Ledare för Dans barn ska vara Ahieser, Ammishaddajs son, ");
INSERT INTO swef_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","med de mönstrade som utgör hans här, 62 700 man. ");
INSERT INTO swef_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Bredvid honom ska Ashers stam slå läger, och ledare för Ashers barn ska vara Pagiel, Okrans son, ");
INSERT INTO swef_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","med de mönstrade som utgör hans här, 41 500 man. ");
INSERT INTO swef_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Därnäst Naftali stam, och ledare för Naftalis barn ska vara Ahira, Enans son, ");
INSERT INTO swef_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","med de mönstrade som utgör hans här, 53 400 man. ");
INSERT INTO swef_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Alla de mönstrade som tillhör Dans läger utgör 157 600 man. De ska bryta upp sist, under sitt baner.” ");
INSERT INTO swef_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Dessa var de av Israels barn som mönstrades efter sina familjer. Alla som efter sina häravdelningar mönstrades i lägren utgjorde 603 550 man. ");
INSERT INTO swef_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Men leviterna mönstrades inte med de andra israeliterna, för så hade Herren befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israels barn gjorde i allt så som Herren hade befallt Mose. De slog läger under sina baner, och de bröt upp var och en i sin släkt, efter sin familj. ");
INSERT INTO swef_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Detta är berättelsen om Arons och Moses släkt vid den tid då Herren talade med Mose på Sinai berg. ");
INSERT INTO swef_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arons söner hette Nadab, den förstfödde, och Abihu, Eleasar och Itamar. ");
INSERT INTO swef_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Detta var namnen på Arons söner, de smorda prästerna, som hade invigts till att vara präster. ");
INSERT INTO swef_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Men Nadab och Abihu dog inför Herrens ansikte när de bar fram främmande eld inför Herren i Sinai öken, och de hade inga söner. Därför var Eleasar och Itamar präster under sin far Aron. ");
INSERT INTO swef_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","”Levi stam ska du föra hit och låta dem stå inför prästen Aron för att betjäna honom. ");
INSERT INTO swef_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","De ska utföra det som åligger honom och hela församlingen inför uppenbarelsetältet genom att göra tjänst vid tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Och de ska ha vården om uppenbarelsetältets alla tillbehör och iaktta det som åligger Israels barn genom att tjänstgöra vid tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Du ska ge leviterna åt Aron och hans söner. De ska ges åt honom som en gåva från Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Men Aron och hans söner ska du sätta till att ansvara för prästtjänsten. Om någon främmande inkräktar på den ska han dödas.” ");
INSERT INTO swef_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","”Se, jag har själv bland Israels barn tagit ut leviterna i stället för alla förstfödda bland Israels barn, alla som öppnar moderlivet. Leviterna ska tillhöra mig, ");
INSERT INTO swef_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","för alla förstfödda tillhör mig. Den dag jag slog allt förstfött i Egyptens land helgade jag åt mig allt förstfött i Israel, både bland människor och boskap. De tillhör mig. Jag är Herren.” ");
INSERT INTO swef_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Herren talade till Mose i Sinai öken. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","”Mönstra Levi barn efter deras familjer och släkter. Alla av manligt kön som är en månad eller äldre ska du räkna.” ");
INSERT INTO swef_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mose mönstrade dem enligt Herrens ord så som han hade blivit befalld. ");
INSERT INTO swef_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Och detta är Levis söner, de hette: Gershon, Kehat och Merari. ");
INSERT INTO swef_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Detta är namnen på Gershons söner efter sina släkter: Libni och Shimei. ");
INSERT INTO swef_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehats söner efter sina släkter var Amram och Jishar, Hebron och Ussiel. ");
INSERT INTO swef_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Meraris söner efter sina släkter var Mahli och Mushi. Dessa var leviternas släkter efter deras familjer. ");
INSERT INTO swef_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Från Gershon härstammade libniternas släkt och shimeiternas släkt. Dessa var gershoniternas släkter. ");
INSERT INTO swef_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","De som mönstrades, när man räknat in alla av manligt kön från en månad och uppåt, var 7 500. ");
INSERT INTO swef_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershoniternas släkter hade sitt läger bakom tabernaklet, västerut. ");
INSERT INTO swef_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Furste för gershoniternas stamfamilj var Eljasaf, Laels son. ");
INSERT INTO swef_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershons barn skulle vid uppenbarelsetältet ansvara för tabernaklet och tältet med dess överdrag, och för draperiet framför ingången till uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","förgårdens omhängen och draperiet framför ingången till förgården som omgav tabernaklet och altaret, dessutom för alla tältlinor och allt arbete som hörde till detta. ");
INSERT INTO swef_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Från Kehat härstammade amramiternas släkt, jishariternas släkt, hebroniternas släkt och ussieliternas släkt. Dessa var kehatiternas släkter. ");
INSERT INTO swef_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","När man räknade alla av manligt kön från en månad och uppåt var de 8 600. Dessa skulle ansvara för de heliga föremålen. ");
INSERT INTO swef_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehatiternas släkter hade sitt läger vid södra sidan av tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ledare för de kehatitiska släkternas stamfamilj var Elisafan, Ussiels son. ");
INSERT INTO swef_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","De skulle ansvara för arken, bordet, ljusstaken, altarna och de tillbehör till de heliga föremålen som användes vid tjänsten, likaså draperiet och allt arbete med det. ");
INSERT INTO swef_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Men högste ledare för alla leviterna var Eleasar, prästen Arons son. Han hade tillsyn över dem som ansvarade för helgedomen och dess skötsel. ");
INSERT INTO swef_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Från Merari härstammade mahliternas släkt och mushiternas släkt. Dessa var merariternas släkter. ");
INSERT INTO swef_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","De mönstrade, när man räknat in alla av manligt kön från en månad och uppåt, var 6 200. ");
INSERT INTO swef_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ledare för de meraritiska släkternas stamfamilj var Suriel, Abihails son. De hade sitt läger vid norra sidan av tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Och Meraris barn fick till uppgift att ha vården om brädorna till tabernaklet, dess tvärstänger, stolpar och fotstycken och om alla dess tillbehör – allt arbete med dessa föremål, ");
INSERT INTO swef_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","likaså om stolparna till förgården runt omkring med deras fotstycken, pluggar och linor. ");
INSERT INTO swef_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mitt för tabernaklet på framsidan, mitt för uppenbarelsetältet österut, hade Mose och Aron och hans söner sitt läger. På Israels barns vägnar var de ansvariga för vården av helgedomen. Men om någon främmande kom nära det heliga, skulle han dödas. ");
INSERT INTO swef_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","De mönstrade leviterna, som Mose och Aron på Herrens befallning mönstrade efter deras släkter, alla av manligt kön som var en månad eller äldre, utgjorde tillsammans 22 000. ");
INSERT INTO swef_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Herren sade till Mose: ”Mönstra alla förstfödda av manligt kön bland Israels barn, alla som är en månad eller äldre, och räkna antalet namn. ");
INSERT INTO swef_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Och ta ut åt mig leviterna – för jag är Herren – i stället för alla förstfödda bland Israels barn, och leviternas boskap i stället för allt förstfött bland Israels barns boskap.” ");
INSERT INTO swef_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mose mönstrade alla förstfödda bland Israels barn, så som Herren hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Och de förstfödda av manligt kön, varje namn räknat av de mönstrade från en månad och uppåt, var 22 273. ");
INSERT INTO swef_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","”Ta ut leviterna i stället för allt förstfött bland Israels barn och leviternas boskap i stället för deras boskap. Leviterna ska tillhöra mig. Jag är Herren. ");
INSERT INTO swef_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Men för att lösa de 273 personer av Israels barns förstfödda som överstiger leviternas antal, ");
INSERT INTO swef_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ska du ta fem siklar silver per person. Du ska ta upp dem efter helgedomssikelns vikt, sikeln räknad till tjugo gera. ");
INSERT INTO swef_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Dessa pengar ska du ge åt Aron och hans söner till lösen för de övertaliga bland dem.” ");
INSERT INTO swef_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mose tog lösensumman från de övertaliga, när man räknade dem som var lösta genom leviterna. ");
INSERT INTO swef_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Av Israels barns förstfödda tog han emot pengarna, 1 365 siklar efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Och Mose gav lösensumman åt Aron och hans söner, efter Herrens ord och befallning till Mose. ");
INSERT INTO swef_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","”Räkna antalet av Kehats söner bland leviterna efter deras släkter och familjer, ");
INSERT INTO swef_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","från trettio år och upp till femtio år, alla arbetsföra män som kan göra tjänst vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Detta är den tjänst som kehatiterna ska ha vid uppenbarelsetältet: att ta vård om de högheliga föremålen. ");
INSERT INTO swef_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","När lägret bryter upp ska Aron och hans söner gå in och ta ner det täckande förhänget och med det ska de täcka vittnesbördets ark. ");
INSERT INTO swef_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Över förhänget ska de lägga ett överdrag av tahasskinn och över det breda ut en vävnad, helt mörkblå. Sedan ska de sätta in stängerna. ");
INSERT INTO swef_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Över skådebrödsbordet ska de breda en mörkblå vävnad, och på den ska de ställa faten, skålarna och bägarna samt kannorna till dryckesoffren. Där ska även det ständiga brödet ligga. ");
INSERT INTO swef_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Över detta ska de breda en karmosinröd vävnad och täcka över den med ett överdrag av tahasskinn. Sedan ska de sätta in stängerna. ");
INSERT INTO swef_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Och de ska ta en mörkblå vävnad och täcka över ljusstaken och dess lampor, lamptänger och brickor samt alla de oljekärl som hör till den och som används vid tjänstgöringen. ");
INSERT INTO swef_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Sedan ska de lägga den med alla dess tillbehör i ett överdrag av tahasskinn och lägga allt på en bår. ");
INSERT INTO swef_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Över det gyllene altaret ska de breda en mörkblå vävnad och täcka över den med ett överdrag av tahasskinn. Sedan ska de sätta in stängerna. ");
INSERT INTO swef_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Och de ska ta alla föremål vid tjänstgöringen, de som används vid tjänstgöringen i helgedomen, och lägga dem i en mörkblå vävnad och täcka över dem med ett överdrag av tahasskinn och lägga dem på en bår. ");
INSERT INTO swef_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","De ska också ta bort askan från altaret och breda en purpurröd vävnad över det, ");
INSERT INTO swef_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","och där ska de lägga alla tillbehör som används under tjänstgöringen vid det: eldfaten, gafflarna, skovlarna och skålarna, altarets alla tillbehör. Över detta ska de breda ett överdrag av tahasskinn och sedan sätta in stängerna. ");
INSERT INTO swef_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","När lägret ska bryta upp och Aron och hans söner har täckt över de heliga föremålen och alla dess tillbehör, ska därefter Kehats barn komma för att bära. Men de får inte röra vid de heliga föremålen, för då kommer de att dö. Detta är vad Kehats barn har att bära av det som hör till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleasar, prästen Arons son, ska ha ansvar för oljan till ljusstaken, den väldoftande rökelsen, det dagliga matoffret och smörjelseoljan. Han har ansvaret för hela tabernaklet och för allt som finns i det, de heliga föremålen och deras tillbehör.” ");
INSERT INTO swef_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Och Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","”Låt inte kehatiternas släktgren utrotas ur leviternas stam, ");
INSERT INTO swef_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","utan gör så här med dem, för att de ska leva och inte dö när de kommer nära de högheliga föremålen: Aron och hans söner ska gå in och anvisa var och en av dem vad han har att göra eller bära. ");
INSERT INTO swef_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Men själva får de inte gå in och se de heliga föremålen, inte ens ett ögonblick, för då kommer de att dö.” ");
INSERT INTO swef_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","”Räkna också antalet av Gershons barn efter deras familjer och släkter. ");
INSERT INTO swef_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Mönstra dem som är från trettio år och upp till femtio år, alla arbetsföra män som kan göra tjänst vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Detta är den tjänst gershoniternas släkter ska ha, vad de ska göra och vad de ska bära: ");
INSERT INTO swef_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","De ska bära tabernaklets tygvåder, uppenbarelsetältet och dess överdrag och överdraget av tahasskinn som ligger ovanpå det, och draperiet framför ingången till uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","dessutom förgårdens omhängen, draperiet framför porten till förgården som omger tabernaklet och altaret, samt dess linor och alla föremål till arbetet med tabernaklet. De ska utföra allt som behöver göras med dessa ting. ");
INSERT INTO swef_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Allt i gershoniternas tjänstgöring ska utföras på order av Aron och hans söner, när det gäller allt som de ska bära och göra. Ni ska överlämna allt de ska bära i deras vård. ");
INSERT INTO swef_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Detta är den tjänst som gershoniternas släkter ska ha vid uppenbarelsetältet. Och de ska utföra sin tjänst under ledning av Itamar, prästen Arons son. ");
INSERT INTO swef_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Meraris barn ska du mönstra efter deras släkter och familjer. ");
INSERT INTO swef_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Mönstra dem som är från trettio år och upp till femtio år, alla arbetsföra som ska tjänstgöra vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Och detta är vad de har till uppgift att bära, allt som hör till deras tjänstgöring vid uppenbarelsetältet: brädorna till tabernaklet, dess tvärstänger, stolpar och fotstycken, ");
INSERT INTO swef_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","liksom stolparna till förgården runt omkring med deras fotstycken, pluggar och linor, med alla deras tillbehör och allt som hör till arbetet vid det. Ni ska göra en lista över de föremål var och en har att bära. ");
INSERT INTO swef_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Detta är den tjänst merariternas släkter ska ha, allt som hör till deras tjänst vid uppenbarelsetältet. Och de ska utföra den under ledning av Itamar, prästen Arons son.” ");
INSERT INTO swef_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mose och Aron och församlingens furstar mönstrade Kehats barn efter deras släkter och familjer, ");
INSERT INTO swef_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","dem som var från trettio år och upp till femtio år, alla arbetsföra som ska tjänstgöra vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Och de mönstrade efter deras släkter var 2 750. ");
INSERT INTO swef_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Dessa var de mönstrade av kehatiternas släkter, alla de som skulle göra tjänst vid uppenbarelsetältet, de som Mose och Aron mönstrade efter Herrens befallning genom Mose. ");
INSERT INTO swef_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershons barn mönstrades efter sina släkter och familjer, ");
INSERT INTO swef_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","de som var från trettio år och upp till femtio år, alla arbetsföra som skulle tjänstgöra vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","De som mönstrades efter sina släkter och familjer var 2 630. ");
INSERT INTO swef_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Dessa var de mönstrade av gershoniternas släkter, alla de som skulle tjänstgöra vid uppenbarelsetältet, de som Mose och Aron mönstrade efter Herrens befallning. ");
INSERT INTO swef_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Meraris barns släkter mönstrades efter sina släkter och familjer, ");
INSERT INTO swef_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","de som var från trettio år och upp till femtio år, alla arbetsföra män som skulle tjänstgöra vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","De som mönstrades efter sina släkter var 3 200. ");
INSERT INTO swef_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Dessa var de mönstrade av Meraris barns släkter, de som Mose och Aron mönstrade efter Herrens befallning genom Mose. ");
INSERT INTO swef_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Leviterna mönstrades av Mose och Aron och Israels furstar efter deras släkter och familjer, ");
INSERT INTO swef_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","de som var från trettio år och upp till femtio år, alla arbetsföra som skulle tjänstgöra eller bära vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","De som mönstrades var 8 580. ");
INSERT INTO swef_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Efter Herrens befallning blev de mönstrade genom Mose, var och en till det som han skulle göra eller bära. Var och en fick den uppgift som Herren befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","”Befall Israels barn att de för bort ur lägret var och en som är spetälsk eller har flytning och var och en som blivit oren genom en död kropp. ");
INSERT INTO swef_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","En sådan, vare sig man eller kvinna, ska ni föra bort utanför lägret. För bort dem, så att de inte orenar deras läger där jag bor mitt ibland dem.” ");
INSERT INTO swef_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Och Israels barn gjorde så, de förde dem utanför lägret. Så som Herren hade sagt till Mose, så gjorde Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","”Säg till Israels barn: När en man eller kvinna begår någon av de synder som människor kan begå och handlar trolöst mot Herren och drar på sig skuld, ");
INSERT INTO swef_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ska han bekänna den synd han har begått och ersätta det orätta till dess fulla belopp och till det lägga en femtedel av värdet. Detta ska han ge till den som han har gjort orätt emot. ");
INSERT INTO swef_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Men om den drabbade inte har någon nära släkting som kan ta emot gottgörelsen, ska ersättningen ges åt Herren och tillhöra prästen, utöver den försoningsbagge med vilken försoning bringas för den skyldige. ");
INSERT INTO swef_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Och alla heliga gåvor som Israels barn bär fram till prästen ska tillhöra honom. ");
INSERT INTO swef_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","De heliga gåvor som var och en ger tillhör honom. Vad någon ger åt prästen tillhör honom.” ");
INSERT INTO swef_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","”Säg till Israels barn: Det kan hända att en mans hustru kommer på avvägar och är otrogen mot sin man, ");
INSERT INTO swef_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","genom att någon annan ligger med henne och har sädesuttömning. Hennes man har inte sett något, och hon håller det hemligt att hon blivit orenad. Det finns inget vittne mot henne, och hon har inte blivit tagen på bar gärning. ");
INSERT INTO swef_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Om han då drabbas av svartsjukans ande och misstänker att hans hustru blivit orenad, eller om han drabbas av svartsjukans ande och misstänker sin hustru fastän hon inte blivit orenad, ");
INSERT INTO swef_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","då ska mannen föra sin hustru till prästen och bära fram en tiondels efa kornmjöl som offer för henne. Men han ska inte hälla någon olja eller lägga någon rökelse på offret, för det är ett misstankeoffer, ett påminnelseoffer som ska påminna om en missgärning. ");
INSERT INTO swef_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Och prästen ska föra fram henne och ställa henne inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Han ska ta heligt vatten i ett lerkärl och ta lite av stoftet från tabernaklets golv och lägga i vattnet. ");
INSERT INTO swef_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Prästen ska ställa fram kvinnan inför Herrens ansikte och lösa upp hennes hår och lägga påminnelseoffret i hennes händer, det vill säga misstankeoffret. I sin hand ska prästen ha det bittra vattnet som för med sig förbannelse. ");
INSERT INTO swef_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Därefter ska prästen ta ed av kvinnan och säga till henne: Om ingen har legat med dig och du inte har kommit på avvägar och orenat dig medan du var under din man, så ska du inte ta skada av det bittra förbannelsebringande vattnet. ");
INSERT INTO swef_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Men om du har kommit på avvägar medan du var under din man, och orenat dig genom att någon annan än din man har legat med dig” ");
INSERT INTO swef_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","– prästen ska nu läsa upp förbannelseeden för kvinnan och säga till henne: – ”så ska Herren göra dig till en förbannelse och en ed bland ditt folk. Herren ska låta ditt moderliv skrumpna och din buk svälla upp, ");
INSERT INTO swef_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","och det förbannelsebringande vattnet ska gå in i dina inälvor och få din buk att svälla upp och ditt moderliv att skrumpna.” Och kvinnan ska säga: ”Amen, amen.” ");
INSERT INTO swef_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Sedan ska prästen skriva upp dessa förbannelser i en bokrulle och tvätta av dem i det bittra vattnet. ");
INSERT INTO swef_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Och han ska ge kvinnan att dricka av det bittra förbannelsebringande vattnet, och det förbannelsebringande vattnet ska gå in i henne och orsaka bitter smärta. ");
INSERT INTO swef_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Prästen ska ta misstankeoffret ur kvinnans hand och lyfta det inför Herrens ansikte och bära fram det till altaret. ");
INSERT INTO swef_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Och prästen ska ta en handfull av offret som ett påminnelseoffer och bränna det på altaret. Därefter ska han ge kvinnan vattnet att dricka. ");
INSERT INTO swef_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","När han har gett henne vattnet att dricka, ska detta ske: Om hon har låtit orena sig och varit otrogen mot sin man, ska det förbannelsebringande vattnet gå in i henne och orsaka bitter smärta. Hennes buk ska svälla upp och hennes moderliv skrumpna, och kvinnan ska bli en förbannelse bland sitt folk. ");
INSERT INTO swef_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Men om kvinnan inte har låtit orena sig utan är ren, ska inget skada henne och hon ska kunna bli havande. ");
INSERT INTO swef_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Detta är lagen om svartsjuka, när en gift kvinna kommer på avvägar och orenar sig ");
INSERT INTO swef_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","eller när svartsjukans ande drabbar en man så att han misstänker sin hustru. Han ska då ställa fram hustrun inför Herrens ansikte, och prästen ska göra med henne allt som denna lag påbjuder. ");
INSERT INTO swef_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Så ska mannen vara fri från skuld och hustrun får själv ta konsekvenserna av sin missgärning.” ");
INSERT INTO swef_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","”Tala till Israels barn och säg till dem: Om en man eller en kvinna avlägger ett löfte, ett nasirlöfte att avskilja sig för Herren, ");
INSERT INTO swef_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ska han avhålla sig från vin och starka drycker. Han får inte dricka någon syrad dryck av vin eller någon annan syrad stark dryck. Han får inte dricka druvsaft och inte heller äta druvor, vare sig färska eller torkade. ");
INSERT INTO swef_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Så länge hans nasirtid varar ska han inte äta något som kommer från vinstocken, inte ens dess kart eller späda skott. ");
INSERT INTO swef_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Så länge hans nasirlöfte varar ska ingen rakkniv komma på hans huvud. Fram till slutet av de dagar som han är avskild för Herren ska han vara helig och låta håret växa fritt på sitt huvud. ");
INSERT INTO swef_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Så länge han är avskild för Herren får han inte komma nära en död kropp. ");
INSERT INTO swef_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Inte ens genom sin far eller mor, sin bror eller syster får han orena sig om de skulle dö, för han bär på sitt huvud tecknet på att han är sin Guds nasir. ");
INSERT INTO swef_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Så länge hans nasirtid varar är han helgad åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Men om någon helt plötsligt dör i hans närhet och därigenom orenar hans huvud där han bär nasirtecknet, ska han raka sitt huvud den dag han blir ren. På sjunde dagen ska han raka det. ");
INSERT INTO swef_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","På åttonde dagen ska han bära fram två turturduvor eller två unga duvor till prästen vid uppenbarelsetältets ingång. ");
INSERT INTO swef_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Och prästen ska offra en till syndoffer och en till brännoffer och bringa försoning för honom, på grund av den synd han dragit på sig genom den döda kroppen. Sedan ska han samma dag helga sitt huvud. ");
INSERT INTO swef_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Han ska inviga sig till nasir åt Herren samma antal dagar som han förut avskilt sig och han ska föra fram ett årsgammalt lamm till skuldoffer. Den förra löftestiden faller bort, eftersom hans nasirat blev orenat. ");
INSERT INTO swef_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Detta är lagen om en nasir: Den dag hans nasirtid är slut ska han föras fram till uppenbarelsetältets ingång, ");
INSERT INTO swef_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","och han ska som sitt offer åt Herren bära fram ett årsgammalt felfritt lamm av hankön till brännoffer, ett årsgammalt felfritt lamm av honkön till syndoffer och en felfri bagge till gemenskapsoffer, ");
INSERT INTO swef_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","dessutom en korg med osyrat bröd, kakor av fint mjöl blandade med olja, osyrade tunnkakor smorda med olja samt det matoffer och dryckesoffer som hör till. ");
INSERT INTO swef_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Prästen ska bära fram det inför Herrens ansikte och offra hans syndoffer och brännoffer. ");
INSERT INTO swef_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Baggen ska han offra som gemenskapsoffer åt Herren tillsammans med korgen med de osyrade bröden. Prästen ska också offra det matoffer och dryckesoffer som hör till. ");
INSERT INTO swef_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Och vid ingången till uppenbarelsetältet ska nasiren raka sitt huvud på vilket han bär nasirtecknet. Han ska ta sitt huvudhår, sitt nasirtecken, och lägga det på elden som brinner under gemenskapsoffret. ");
INSERT INTO swef_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","När nasiren har rakat av sig nasirtecknet, ska prästen ta den kokta bogen av baggen och dessutom en osyrad kaka och en osyrad tunnkaka ur korgen och lägga det på nasirens händer. ");
INSERT INTO swef_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Och prästen ska lyfta det som ett lyftoffer inför Herrens ansikte. Det ska vara helgat åt prästen tillsammans med lyftofferbringan och offergärdslåret. Sedan får nasiren dricka vin igen. ");
INSERT INTO swef_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Detta är lagen om den som har avlagt ett nasirlöfte, och vad han enligt nasirlöftet ska offra åt Herren, förutom vad han i övrigt kan skaffa. Han måste uppfylla det löfte han har avlagt enligt lagen om hans nasirat.” ");
INSERT INTO swef_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","”Säg till Aron och hans söner: När ni välsignar Israels barn ska ni säga till dem: ");
INSERT INTO swef_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Herren välsigne dig och bevare dig. ");
INSERT INTO swef_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Herren låte sitt ansikte lysa över dig och vare dig nådig. ");
INSERT INTO swef_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Herren vände sitt ansikte till dig och give dig frid. ");
INSERT INTO swef_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Så ska de lägga mitt namn på Israels barn, och jag ska då välsigna dem.” ");
INSERT INTO swef_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mose hade nu satt upp tabernaklet och smort och helgat det med alla dess tillbehör. Likaså hade han satt upp altaret med alla dess tillbehör och smort och helgat dem. ");
INSERT INTO swef_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Och Israels ledare, huvudmännen för sina familjer, stamhövdingarna, de som stod i spetsen för de mönstrade, bar fram sina offergåvor. ");
INSERT INTO swef_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Som sin offergåva förde de fram inför Herrens ansikte sex täckta vagnar och tolv oxar, en vagn för två ledare och en oxe för varje ledare. De förde fram dem inför tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","”Ta emot det av dem och använd det till tjänsten vid uppenbarelsetältet. Och du ska ge det till leviterna efter behoven i vars och ens tjänst.” ");
INSERT INTO swef_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mose tog emot vagnarna och oxarna och gav dem till leviterna. ");
INSERT INTO swef_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Två vagnar och fyra oxar gav han till Gershons barn efter behoven i deras tjänst. ");
INSERT INTO swef_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Fyra vagnar och åtta oxar gav han till Meraris barn efter behoven i den tjänst de utförde under ledning av Itamar, prästen Arons son. ");
INSERT INTO swef_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Till Kehats barn däremot gav han ingenting, för de hade hand om de heliga föremålen som de skulle bära på axlarna. ");
INSERT INTO swef_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ledarna förde fram gåvor till altarets invigning den dag då det smordes. När ledarna förde fram dessa offergåvor inför altaret, ");
INSERT INTO swef_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","sade Herren till Mose: ”Låt ledarna en i sänder, var och en på sin dag, föra fram sina offergåvor till altarets invigning.” ");
INSERT INTO swef_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Den som på första dagen förde fram sin offergåva var Nahshon, Amminadabs son av Juda stam. ");
INSERT INTO swef_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","en bock till syndoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Nahshons, Amminadabs sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","På andra dagen förde Netanel, Suars son, ledaren för Isaskar, fram sin gåva. ");
INSERT INTO swef_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Som sin offergåva förde han fram ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Netanels, Suars sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","På tredje dagen kom ledaren för Sebulons barn, Eliab, Helons son. ");
INSERT INTO swef_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Eliabs, Helons sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","På fjärde dagen kom ledaren för Rubens barn, Elisur, Shedeurs son. ");
INSERT INTO swef_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Elisurs, Shedeurs sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","På femte dagen kom ledaren för Simeons barn, Shelumiel, Surishaddajs son. ");
INSERT INTO swef_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Shelumiels, Surishaddajs sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","På sjätte dagen kom ledaren för Gads barn, Eljasaf, Deguels son. ");
INSERT INTO swef_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Eljasafs, Deguels sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","På sjunde dagen kom ledaren för Efraims barn, Elishama, Ammihuds son. ");
INSERT INTO swef_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Elishamas, Ammihuds sons offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","På åttonde dagen kom ledaren för Manasse barn, Gamliel, Pedasurs son. ");
INSERT INTO swef_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Gamliels, Pedasurs sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","På nionde dagen kom ledaren för Benjamins barn, Abidan, Gideonis son. ");
INSERT INTO swef_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Abidans, Gideonis sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","På tionde dagen kom ledaren för Dans barn, Ahieser, Ammishaddajs son. ");
INSERT INTO swef_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Ahiesers, Ammishaddajs sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","På elfte dagen kom ledaren för Ashers barn, Pagiel, Okrans son. ");
INSERT INTO swef_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Pagiels, Okrans sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","På tolfte dagen kom ledaren för Naftali barn, Ahira, Enans son. ");
INSERT INTO swef_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Hans offergåva var ett silverfat som vägde 130 siklar och en silverskål på 70 siklar efter helgedomssikelns vikt, båda fulla med fint mjöl blandat med olja till matoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","en guldskål på tio siklar full med rökelse, ");
INSERT INTO swef_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","dessutom en ungtjur, en bagge och ett årsgammalt lamm till brännoffer, ");
INSERT INTO swef_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","en bock till syndoffer ");
INSERT INTO swef_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","samt två tjurar, fem baggar, fem bockar och fem årsgamla lamm till gemenskapsoffer. Detta var Ahiras, Enans sons, offergåva. ");
INSERT INTO swef_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Detta var vad Israels ledare skänkte till altarets invigning när det smordes: tolv silverfat, tolv silverskålar och tolv guldskålar. ");
INSERT INTO swef_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Varje silverfat vägde 130 siklar och varje skål 70 siklar, och silvret i kärlen vägde tillsammans 2400 siklar efter helgedomssikelns vikt. ");
INSERT INTO swef_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","De tolv guldskålarna fulla av rökelse vägde var och en tio siklar efter helgedomssikelns vikt, och guldet i skålarna vägde sammanlagt 120 siklar. ");
INSERT INTO swef_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Antalet djur till brännoffer var tolv tjurar, tolv baggar, tolv årsgamla lamm med tillhörande matoffer, och tolv bockar till syndoffer. ");
INSERT INTO swef_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Antalet djur till gemenskapsoffer var tjugofyra tjurar, sextio baggar, sextio bockar och sextio årsgamla lamm. Detta var offergåvorna till altarets invigning sedan det hade blivit smort. ");
INSERT INTO swef_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","När Mose gick in i uppenbarelsetältet för att tala med honom, hörde han rösten tala till honom från nådastolen ovanpå vittnesbördets ark, mellan de två keruberna. Och han talade till honom. ");
INSERT INTO swef_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","”Tala till Aron och säg till honom: När du sätter upp de sju lamporna, ska du sätta upp dem så att de kastar sitt sken över platsen framför ljusstaken.” ");
INSERT INTO swef_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Och Aron gjorde så. Han satte upp lamporna så att de kastade sitt sken över platsen framför ljusstaken, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ljusstaken var gjord av hamrat guld. Från dess fotställning till blommorna var den i hamrat arbete. Efter den förebild som Herren hade visat Mose gjorde han ljusstaken. ");
INSERT INTO swef_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","”Bland Israels barn ska du ta ut leviterna och rena dem. ");
INSERT INTO swef_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","På följande sätt ska du göra för att rena dem: Stänk reningsvatten på dem, och låt dem raka hela sin kropp och tvätta sina kläder. Så ska de rena sig. ");
INSERT INTO swef_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Sedan ska de ta en ungtjur med tillhörande matoffer av fint mjöl blandat med olja. Du ska ta en annan ungtjur till syndoffer. ");
INSERT INTO swef_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Och du ska föra fram leviterna inför uppenbarelsetältet och samla hela Israels församling. ");
INSERT INTO swef_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","När du har fört fram leviterna inför Herrens ansikte, ska Israels barn lägga sina händer på dem. ");
INSERT INTO swef_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Och Aron ska föra fram leviterna inför Herrens ansikte som ett lyftoffer från Israels barn, så att de kan förrätta Herrens tjänst. ");
INSERT INTO swef_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Leviterna ska lägga sina händer på tjurarnas huvuden, och den ena ska du offra till syndoffer och den andra till brännoffer åt Herren för att bringa försoning för leviterna. ");
INSERT INTO swef_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Sedan ska du ställa leviterna inför Aron och hans söner och föra fram dem som ett lyftoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Så ska du bland Israels barn avskilja leviterna så att de tillhör mig. ");
INSERT INTO swef_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Sedan du har renat leviterna och fört fram dem som ett lyftoffer ska de gå in och göra tjänst vid uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","för de är givna åt mig som en gåva bland Israels barn. I stället för allt som öppnar moderlivet, allt förstfött bland Israels barn, har jag tagit ut dem åt mig. ");
INSERT INTO swef_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Allt förstfött bland Israels barn tillhör mig, både människor och boskap. På den dag då jag slog allt förstfött i Egyptens land helgade jag dem åt mig. ");
INSERT INTO swef_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Jag har tagit leviterna i stället för allt förstfött bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Och jag har bland Israels barn gett leviterna som gåva åt Aron och hans söner, till att förrätta Israels barns tjänst vid uppenbarelsetältet och bringa försoning för Israels barn, för att ingen plåga ska drabba dem när de kommer nära helgedomen.” ");
INSERT INTO swef_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose, Aron och hela Israels församling gjorde med leviterna i allt så som Herren hade befallt Mose angående dem. Så gjorde Israels barn med dem. ");
INSERT INTO swef_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leviterna renade sig och tvättade sina kläder, och Aron förde fram dem som ett lyftoffer inför Herrens ansikte, och Aron bringade försoning för dem och renade dem. ");
INSERT INTO swef_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Sedan gick leviterna in och gjorde tjänst vid uppenbarelsetältet under Aron och hans söner. Så som Herren hade befallt Mose angående leviterna, så gjorde de med dem. ");
INSERT INTO swef_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","”Detta gäller för leviterna: De som är tjugofem år eller äldre ska infinna sig och göra tjänst med arbete vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Men när leviten blir femtio år ska han vara fri från sin tjänst, och han ska då inte tjänstgöra längre. ");
INSERT INTO swef_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Han kan hjälpa sina bröder vid uppenbarelsetältet i deras uppgifter, men någon tjänst ska han inte inneha. Så ska du göra med leviterna när det gäller deras ansvarsuppgifter.” ");
INSERT INTO swef_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Herren talade till Mose i Sinai öken i första månaden av det andra året efter deras uttåg ur Egyptens land. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","”Israels barn ska fira påskhögtid på den bestämda tiden. ");
INSERT INTO swef_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","På fjortonde dagen i denna månad, i skymningen, ska ni fira den, på bestämd tid. I enlighet med alla stadgar och föreskrifter ska ni fira den.” ");
INSERT INTO swef_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Och Mose sade till Israels barn att de skulle fira påskhögtiden. ");
INSERT INTO swef_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","De firade den på fjortonde dagen i första månaden, i skymningen, i Sinai öken. Israels barn gjorde i allt så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Men det fanns några män som hade blivit orena genom en död människa så att de inte kunde fira påskhögtid på den dagen. De vände sig därför samma dag till Mose och Aron ");
INSERT INTO swef_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","och sade till Mose: ”Vi har blivit orena genom en död människa. Ska vi därför nekas att bland Israels barn frambära Herrens offergåva på bestämd tid?” ");
INSERT INTO swef_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose svarade dem: ”Stanna här, så ska jag höra vad Herren befaller om er.” ");
INSERT INTO swef_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","”Säg till Israels barn: Om någon bland er eller era efterkommande har blivit oren genom en död människa, eller är ute på resa långt borta, kan han ändå fira Herrens påskhögtid. ");
INSERT INTO swef_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","De ska då fira den i andra månaden, på fjortonde dagen, i skymningen. Med osyrat bröd och bittra örter ska de äta påskalammet. ");
INSERT INTO swef_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Inget av det ska lämnas kvar till morgonen, och inget ben på det ska krossas. De ska fira påskhögtiden enligt alla dess föreskrifter. ");
INSERT INTO swef_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Men den som är ren och inte är på resa men ändå underlåter att fira påskhögtiden, han ska utrotas ur sitt folk, därför att han inte har burit fram Herrens offergåva på bestämd tid. Den mannen får själv svara för sin synd. ");
INSERT INTO swef_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Om en främling bor hos er och vill fira Herrens påskhögtid, ska han fira den enligt de stadgar och föreskrifter som gäller för påskhögtiden. Ni ska ha en och samma stadga för främlingen och för den infödde i landet.” ");
INSERT INTO swef_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","På den dag då tabernaklet sattes upp täckte molnskyn tabernaklet, vittnesbördets tält. Från kvällen till morgonen var den över tabernaklet och den såg ut som eld. ");
INSERT INTO swef_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Så var det alltid: Molnskyn täckte det, och om natten såg den ut som eld. ");
INSERT INTO swef_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Så ofta molnskyn höjde sig från tältet bröt Israels barn upp, och på den plats där molnskyn stannade slog Israels barn läger. ");
INSERT INTO swef_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","På Herrens befallning bröt Israels barn upp, och på Herrens befallning slog de läger. Så länge molnskyn vilade över tabernaklet låg de kvar i lägret. ");
INSERT INTO swef_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Om molnskyn stannade en längre tid över tabernaklet, iakttog Israels barn det Herren befallde dem och bröt inte upp. ");
INSERT INTO swef_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ibland stannade molnskyn över tabernaklet bara några få dagar. På Herrens befallning låg de då kvar i lägret, och på Herrens befallning bröt de sedan upp. ");
INSERT INTO swef_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ibland stannade molnskyn bara från kvällen till morgonen. När molnskyn höjde sig på morgonen bröt de upp. Om molnskyn stannade en dag och en natt, bröt de upp när molnskyn höjde sig. ");
INSERT INTO swef_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Om molnskyn stannade två dagar eller en månad, eller om molnskyn blev kvar en längre tid över tabernaklet, så låg Israels barn stilla i läger och bröt inte upp. Men när den höjde sig bröt de upp. ");
INSERT INTO swef_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","På Herrens befallning slog de läger, och på Herrens befallning bröt de upp. De följde Herrens påbud i enlighet med Herrens befallning genom Mose. ");
INSERT INTO swef_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","”Gör dig två silvertrumpeter, i hamrat arbete ska du göra dem. Du ska använda dem när församlingen ska sammankallas och när lägren ska bryta upp. ");
INSERT INTO swef_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","När man stöter i dem båda ska hela församlingen samlas hos dig vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Men när man stöter bara i den ena, ska furstarna, huvudmännen för Israels ätter, samlas hos dig. ");
INSERT INTO swef_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","När ni blåser en larmsignal, ska de läger som ligger österut bryta upp. ");
INSERT INTO swef_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Och när ni blåser larmsignal för andra gången, ska de läger som ligger söderut bryta upp. När lägren ska bryta upp ska man blåsa larmsignal. ");
INSERT INTO swef_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Men när församlingen ska sammankallas, ska ni inte blåsa larmsignal utan stöta i trumpeterna. ");
INSERT INTO swef_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Det är Arons söner, prästerna, som ska blåsa i trumpeterna. Detta ska vara en evig stadga för er, släkte efter släkte. ");
INSERT INTO swef_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","När ni i ert land drar ut till strid mot någon fiende som angriper er, ska ni blåsa larmsignal i trumpeterna. Då ska ni bli ihågkomna inför Herren er Guds ansikte, och bli räddade från era fiender. ");
INSERT INTO swef_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Och i dagar av glädje, vid era högtider och nymånader, ska ni stöta i trumpeterna vid era brännoffer och gemenskapsoffer. De ska göra att ni blir ihågkomna inför er Gud. Jag är Herren er Gud.” ");
INSERT INTO swef_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Andra året, i andra månaden, på tjugonde dagen, höjde sig molnskyn från vittnesbördets tabernakel. ");
INSERT INTO swef_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Då bröt Israels barn upp från Sinai öken och gick från plats till plats, och molnskyn stannade i öknen Paran. ");
INSERT INTO swef_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","När de nu första gången bröt upp efter Herrens befallning genom Mose, ");
INSERT INTO swef_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","var det Juda barns läger under sitt baner som först bröt upp, häravdelning efter häravdelning. Anförare för denna här var Nahshon, Amminadabs son. ");
INSERT INTO swef_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Och anförare för den här som utgjordes av Isaskars stam var Netanel, Suars son. ");
INSERT INTO swef_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Anförare för den här som utgjordes av Sebulons stam var Eliab, Helons son. ");
INSERT INTO swef_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Sedan tabernaklet hade tagits ner, bröt Gershons och Meraris barn upp och bar tabernaklet. ");
INSERT INTO swef_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Därefter bröt Rubens läger upp under sitt baner, häravdelning efter häravdelning. Anförare för denna här var Elisur, Shedeurs son. ");
INSERT INTO swef_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Anförare för den här som utgjordes av Simeons stam var Shelumiel, Surishaddajs son. ");
INSERT INTO swef_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Anförare för den här som utgjordes av Gads stam var Eljasaf, Deguels son. ");
INSERT INTO swef_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Sedan bröt kehatiterna upp, de bar de heliga föremålen. Och tabernaklet sattes upp innan de hann fram. ");
INSERT INTO swef_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Därefter bröt Efraims läger upp under sitt baner, häravdelning efter häravdelning. Anförare för denna här var Elishama, Ammihuds son. ");
INSERT INTO swef_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Anförare för den här som utgjordes av Manasse stam var Gamliel, Pedasurs son. ");
INSERT INTO swef_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Och anförare för den här som utgjordes av Benjamins stam var Abidan, Gideonis son. ");
INSERT INTO swef_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Därefter bröt Dans läger upp under sitt baner som en eftertrupp för alla läger, häravdelning efter häravdelning. Anförare för denna här var Ahieser, Ammishaddajs son. ");
INSERT INTO swef_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Anförare för den här som utgjordes av Ashers stam var Pagiel, Okrans son. ");
INSERT INTO swef_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Och anförare för den här som utgjordes av Naftalis stam var Ahira, Enans son. ");
INSERT INTO swef_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Detta var ordningen när Israels barn bröt upp, häravdelning efter häravdelning. ");
INSERT INTO swef_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mose sade till Hobab, som var son till midjaniten Reguel, Moses svärfar: ”Vi bryter nu upp och går till det land som Herren har lovat att ge oss. Följ med oss, så ska vi göra gott mot dig. Herren har lovat Israel allt gott.” ");
INSERT INTO swef_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Men han svarade honom: ”Jag vill inte följa med, utan jag vill gå hem till mitt land och min släkt.” ");
INSERT INTO swef_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose sade: ”Nej, lämna oss inte. Du vet bäst var vi kan slå läger i öknen, du ska bli vårt öga. ");
INSERT INTO swef_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Om du följer med oss ska vi låta dig få del av det goda som Herren gör med oss.” ");
INSERT INTO swef_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Och de bröt upp från Herrens berg och vandrade tre dagsresor. Herrens förbundsark gick framför dem de tre dagarna för att utse en rastplats åt dem. ");
INSERT INTO swef_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Herrens molnsky svävade över dem om dagen när de bröt upp från sin lägerplats. ");
INSERT INTO swef_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Och så ofta arken bröt upp, sade Mose: ”Res dig, Herre! Låt dina fiender skingras, låt dem som hatar dig fly för ditt ansikte.” ");
INSERT INTO swef_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Och när den sattes ner, sade han: ”Vänd åter, Herre, till Israels ätters många tusenden.” ");
INSERT INTO swef_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Folket började klaga högljutt inför Herren hur illa de hade det. När Herren hörde det, upptändes hans vrede och hans eld började brinna ibland dem och förtärde dem som var ytterst i lägret. ");
INSERT INTO swef_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Folket ropade då till Mose och han bad till Herren, och elden dog ut. ");
INSERT INTO swef_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Platsen fick namnet Tabeera, därför att Herrens eld hade brunnit ibland dem. ");
INSERT INTO swef_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Den blandade hopen som följde dem greps av stort begär, och även Israels barn började gråta igen och sade: ”Vem kan ge oss kött att äta? ");
INSERT INTO swef_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Vi minns fisken som vi åt gratis i Egypten, och gurkorna, melonerna, purjolöken, rödlöken och vitlöken. ");
INSERT INTO swef_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Men nu försmäktar vår själ, för här finns inget att se utom detta manna.” ");
INSERT INTO swef_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannat liknade korianderfrö och såg ut som bdelliumharts. ");
INSERT INTO swef_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Folket gick omkring och samlade det och malde det på handkvarn eller stötte det i mortel. De kokade det i gryta eller bakade kakor av det. Och det smakade som fint bakverk med olja. ");
INSERT INTO swef_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","När daggen föll över lägret om natten, föll också mannat över det. ");
INSERT INTO swef_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose hörde hur folket i de olika familjerna grät, var och en vid ingången till sitt tält. Då upptändes Herrens vrede, och Mose blev illa till mods. ");
INSERT INTO swef_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Och Mose sade till Herren: ”Varför har du gjort så illa mot din tjänare? Varför har jag inte funnit nåd inför dina ögon? Du har ju lagt bördan av hela detta folk på mig! ");
INSERT INTO swef_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Har jag burit och fött hela detta folk, eftersom du säger till mig: ’Bär dem i din famn så som vårdaren bär spädbarnet’, in i det land som du med ed har lovat åt deras fäder? ");
INSERT INTO swef_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Var ska jag få kött att ge åt hela detta folk? De kommer gråtande till mig och säger: Ge oss kött, så att vi får äta! ");
INSERT INTO swef_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Jag orkar inte bära hela folket själv, det är för tungt för mig. ");
INSERT INTO swef_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Om det är så här du vill göra mot mig, döda mig då direkt om jag funnit nåd inför dina ögon, och låt mig slippa se mitt elände!” ");
INSERT INTO swef_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Då sade Herren till Mose: ”Kalla samman sjuttio män av de äldste i Israel, sådana som du vet är folkets äldste och deras förmän. För fram dem till uppenbarelsetältet och låt dem ställa sig där hos dig. ");
INSERT INTO swef_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Där ska jag då stiga ner och tala med dig, och jag ska ta av den Ande som är över dig och låta den komma över dem. De ska tillsammans med dig bära bördan av folket, så att du slipper bära den ensam. ");
INSERT INTO swef_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Säg till folket: Helga er till i morgon, så ska ni få kött att äta. Ni har gråtit inför Herren och sagt: Vem ska ge oss kött att äta? I Egypten hade vi det så bra. Därför ska nu Herren ge er kött att äta. ");
INSERT INTO swef_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ni ska få äta, inte bara en dag, inte två dagar, inte fem dagar, inte tio dagar, inte tjugo dagar, ");
INSERT INTO swef_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","utan en hel månad, ända tills köttet kommer ut genom näsan på er och det äcklar er. Ni har förkastat Herren, som är mitt ibland er, och gråtit inför hans ansikte och sagt: Varför drog vi alls ut ur Egypten?” ");
INSERT INTO swef_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mose sade: ”Sexhundratusen man till fots har jag omkring mig, och du säger: Jag ska ge dem kött att äta under en månad! ");
INSERT INTO swef_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Finns det får och kor att slakta så att det räcker åt dem? Eller ska alla fiskar i havet fångas så att det räcker åt dem?” ");
INSERT INTO swef_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Herren svarade Mose: ”Är Herrens arm för kort? Nu ska du få se om det jag har sagt ska hända dig eller inte.” ");
INSERT INTO swef_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mose gick ut och talade om för folket vad Herren hade sagt. Och han kallade samman sjuttio män av de äldste i folket och lät dem ställa sig runt omkring tältet. ");
INSERT INTO swef_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Då steg Herren ner i molnskyn och talade till honom, och tog av den Ande som var över honom och lät den komma över de sjuttio äldste. När Anden nu vilade över dem började de profetera, men det gjorde de sedan inte mer. ");
INSERT INTO swef_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Två män hade stannat kvar i lägret. Den ene hette Eldad och den andre Medad. Även över dem vilade Anden, för de var bland de uppskrivna men hade inte gått ut till tältet. Och de profeterade i lägret. ");
INSERT INTO swef_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Då skyndade en ung man bort och berättade för Mose: ”Eldad och Medad profeterar i lägret.” ");
INSERT INTO swef_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josua, Nuns son, som hade varit Moses tjänare från sin ungdom, sade då: ”Mose, min herre, förbjud dem!” ");
INSERT INTO swef_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Men Mose sade till honom: ”Ivrar du för mig? Om ändå hela Herrens folk blev profeter genom att Herren lät sin Ande komma över dem!” ");
INSERT INTO swef_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Sedan gick Mose tillbaka till lägret med de äldste i Israel. ");
INSERT INTO swef_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Och en stormvind gick ut från Herren. Den förde med sig vaktlar från havet och drev dem över lägret, omkring en dagsresa i varje riktning från lägret och två alnar över marken. ");
INSERT INTO swef_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Folket gick då hela den dagen och natten och nästa dag och samlade vaktlar. Det minsta någon samlade var tio homer, och de bredde ut dem åt sig runt omkring lägret. ");
INSERT INTO swef_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Men medan de ännu hade köttet mellan tänderna och det ännu var otuggat, upptändes Herrens vrede mot folket och Herren slog dem med en mycket svår plåga. ");
INSERT INTO swef_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Platsen fick namnet Kibrot-Hattaava, eftersom man där begravde dem av folket som hade gripits av begär. ");
INSERT INTO swef_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Från Kibrot-Hattaava bröt folket upp och drog till Haserot, och där stannade de. ");
INSERT INTO swef_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam och Aron talade illa om Mose på grund av den kushitiska kvinnan som han hade tagit till hustru, för han hade tagit en kushitisk kvinna till hustru. ");
INSERT INTO swef_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","De sade: ”Är Mose den ende som Herren talar genom? Talar han inte också genom oss?” Och Herren hörde det. ");
INSERT INTO swef_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mose var en mycket ödmjuk man, mer än någon annan människa på jorden. ");
INSERT INTO swef_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Genast sade Herren till Mose, Aron och Mirjam: ”Gå ut, ni tre, till uppenbarelsetältet.” Och de gick dit ut alla tre. ");
INSERT INTO swef_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Då steg Herren ner i en molnpelare och ställde sig vid ingången till tältet. Han kallade på Aron och Mirjam, och de gick båda dit. ");
INSERT INTO swef_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Och han sade: ”Hör nu mina ord. Om det finns en Herrens profet ibland er, ger jag mig till känna för honom i en syn och talar med honom i en dröm. ");
INSERT INTO swef_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Men så gör jag inte med min tjänare Mose. I hela mitt hus är han betrodd. ");
INSERT INTO swef_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Jag talar med honom ansikte mot ansikte, tydligt och inte i gåtor, och han får se Herrens gestalt. Varför var ni då inte rädda för att tala illa om min tjänare Mose?” ");
INSERT INTO swef_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Och Herrens vrede upptändes mot dem, och han lämnade dem. ");
INSERT INTO swef_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","När molnskyn drog sig tillbaka från tältet, se, då var Mirjam vit som snö av spetälska. Aron vände sig till Mirjam och såg att hon var spetälsk. ");
INSERT INTO swef_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Då sade Aron till Mose: ”O, min herre, lägg inte på oss denna synd som vi i vår dårskap har begått. ");
INSERT INTO swef_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Låt henne inte bli som ett dödfött foster vars kropp är till hälften förtärd när det kommer ut ur moderlivet.” ");
INSERT INTO swef_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Då ropade Mose till Herren: ”O, Gud, gör henne frisk!” ");
INSERT INTO swef_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Herren svarade Mose: ”Om hennes far hade spottat henne i ansiktet, skulle hon då inte ha fått skämmas i sju dagar? Håll henne därför instängd utanför lägret i sju dagar. Sedan ska hon tas emot igen.” ");
INSERT INTO swef_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","I sju dagar hölls Mirjam instängd utanför lägret, och folket bröt inte upp förrän Mirjam hade förts tillbaka. ");
INSERT INTO swef_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Sedan bröt folket upp från Haserot och slog läger i öknen Paran. ");
INSERT INTO swef_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","”Sänd ut män för att speja i Kanaans land som jag ger åt Israels barn. En man för varje fädernestam ska ni sända. Var och en av dem ska vara en ledare.” ");
INSERT INTO swef_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","På Herrens befallning sände Mose ut dem från öknen Paran. Alla var huvudmän bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Deras namn var: Av Rubens stam: Shammua, Sackurs son, ");
INSERT INTO swef_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","av Simeons stam: Shafat, Horis son, ");
INSERT INTO swef_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","av Juda stam: Kaleb, Jefunnes son, ");
INSERT INTO swef_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","av Isaskars stam: Jigal, Josefs son, ");
INSERT INTO swef_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","av Efraims stam: Hosea, Nuns son, ");
INSERT INTO swef_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","av Benjamins stam: Palti, Rafus son, ");
INSERT INTO swef_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","av Sebulons stam: Gaddiel, Sodis son, ");
INSERT INTO swef_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","av Josefs stam, av Manasse stam: Gaddi, Susis son, ");
INSERT INTO swef_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","av Dans stam: Ammiel, Gemallis son, ");
INSERT INTO swef_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","av Ashers stam: Setur, Mikaels son, ");
INSERT INTO swef_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","av Naftali stam: Nahbi, Vofsis son, ");
INSERT INTO swef_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","av Gads stam: Geuel, Makis son. ");
INSERT INTO swef_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Dessa var namnen på de män som Mose sände i väg för att speja i landet. Men Mose gav Hosea, Nuns son, namnet Josua. ");
INSERT INTO swef_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mose sände i väg dem för att speja i Kanaans land och sade till dem: ”Dra upp till Negev och vidare upp till Bergsbygden. ");
INSERT INTO swef_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Se efter hur landet är, om folket som bor där är starkt eller svagt, om de är få eller många, ");
INSERT INTO swef_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","om landet där de bor är gott eller dåligt, om städerna där de bor är som läger eller om de är befästa, ");
INSERT INTO swef_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","om jorden är fet eller mager och om det finns träd där eller inte. Visa er modiga och ta med er hit av landets frukt.” Det var den tid då de första druvorna mognade. ");
INSERT INTO swef_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","De gav sig av och spejade i landet från öknen Zin ända till Rehob där vägen går till Hamat. ");
INSERT INTO swef_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","De drog upp till Negev och kom till Hebron. Där bodde Ahiman, Sheshaj och Talmaj, Anaks avkomlingar. – Hebron byggdes sju år före Soan i Egypten. – ");
INSERT INTO swef_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","De kom till Druvdalen. Där skar de av en gren med en ensam druvklase. Den bars sedan på en stång av två man. Dessutom tog de granatäpplen och fikon. ");
INSERT INTO swef_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Platsen kallades sedan Druvdalen på grund av den druvklase som Israels barn skar av där. ");
INSERT INTO swef_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Efter fyrtio dagar vände de tillbaka sedan de hade spejat i landet. ");
INSERT INTO swef_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","De gav sig i väg och kom till Mose och Aron och hela Israels församling i öknen Paran i Kadesh, där de avgav rapport för dem och hela församlingen och visade dem landets frukt. ");
INSERT INTO swef_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Och de sade till Mose: ”Vi kom till det land som du sände oss till. Det flödar verkligen av mjölk och honung, och här är frukt därifrån. ");
INSERT INTO swef_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Men folket som bor i landet är starkt, och städerna är befästa och mycket stora. Dessutom såg vi avkomlingar av Anak där. ");
INSERT INTO swef_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Amalekiterna bor i Negev, hetiterna, jebusiterna och amoreerna bor i bergsbygden, och kananeerna bor vid havet och utmed Jordan.” ");
INSERT INTO swef_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Men Kaleb lugnade folket inför Mose och sade: ”Låt oss genast dra dit upp och inta landet. Sannerligen, vi kan göra det!” ");
INSERT INTO swef_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Men männen som hade gått upp med honom sade: ”Vi kan inte dra upp mot det folket, för de är för starka för oss.” ");
INSERT INTO swef_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Inför Israels barn talade de illa om landet där de hade spejat och sade: ”Landet som vi har vandrat igenom och spejat i är ett land som förtär sina inbyggare, och allt folk som vi såg där var resliga män. ");
INSERT INTO swef_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Vi såg också jättarna där – Anaks barn kom från jättestammen – och vi var som gräshoppor i våra egna ögon, och så var vi också i deras ögon.” ");
INSERT INTO swef_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Då började hela församlingen ropa och skrika, och folket grät den natten. ");
INSERT INTO swef_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Alla Israels barn klagade på Mose och Aron, och hela församlingen sade till dem: ”Om vi ändå hade fått dö i Egyptens land, eller om vi ändå hade fått dö här i öknen! ");
INSERT INTO swef_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Varför leder Herren oss in i detta land där vi kommer att falla för svärd och våra hustrur och barn blir fiendens byte? Vore det inte bättre för oss att vända tillbaka till Egypten?” ");
INSERT INTO swef_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Och de sade till varandra: ”Vi väljer en ledare och vänder tillbaka till Egypten.” ");
INSERT INTO swef_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Då föll Mose och Aron ner på sina ansikten inför Israels barns hela folk och församling. ");
INSERT INTO swef_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Och Josua, Nuns son, och Kaleb, Jefunnes son, som var med bland dem som hade spejat i landet, rev sönder sina kläder ");
INSERT INTO swef_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","och sade till hela Israels församling: ”Landet som vi har vandrat igenom och spejat i är ett mycket, mycket gott land. ");
INSERT INTO swef_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Om Herren har behag till oss, ska han föra oss in i det landet och ge det åt oss, ett land som flödar av mjölk och honung. ");
INSERT INTO swef_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Men var inte upproriska mot Herren och var inte rädda för folket i landet, för de ska bli som en munsbit för oss. Deras beskydd har vikit ifrån dem, men Herren är med oss. Var inte rädda för dem.” ");
INSERT INTO swef_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Men hela församlingen ropade att man skulle stena dem. Då visade sig Herrens härlighet i uppenbarelsetältet för alla Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Och Herren sade till Mose: ”Hur länge ska detta folk förakta mig? Och hur länge ska de vägra tro på mig trots alla de tecken jag har gjort ibland dem? ");
INSERT INTO swef_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Jag ska slå dem med pest och utrota dem, men dig vill jag göra till ett folk som är större och mäktigare än dem.” ");
INSERT INTO swef_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose sade till Herren: ”Egyptierna har ju hört att du med din kraft har fört detta folk ut från dem hit upp, ");
INSERT INTO swef_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","och de har talat om det för dem som bor här i landet. De har hört att du, Herre, är mitt ibland detta folk, att du, Herre, visar dig ansikte mot ansikte, att din molnsky står över dem och att du går framför dem i en molnpelare om dagen och i en eldpelare om natten. ");
INSERT INTO swef_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Om du dödar detta folk, alla på en gång, kommer hednafolken som hört talas om dig att säga: ");
INSERT INTO swef_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","’Herren lyckades inte föra in detta folk i det land som han med ed hade lovat dem, och därför har han slaktat dem i öknen.’ ");
INSERT INTO swef_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nej, låt nu Herrens kraft visa sig stor, så som du själv har sagt: ");
INSERT INTO swef_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Herren är sen till vrede och rik på nåd, han förlåter missgärning och överträdelse men låter ingen bli ostraffad, utan låter straffet för fädernas missgärning drabba barnen till tredje och fjärde led. ");
INSERT INTO swef_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Förlåt nu folkets missgärning efter din stora nåd, så som du har låtit din förlåtelse följa detta folk allt ifrån Egypten och ända hit.” ");
INSERT INTO swef_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Då sade Herren: ”Jag förlåter dem enligt ditt ord. ");
INSERT INTO swef_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Men så sant jag lever och så sant Herrens härlighet uppfyller hela jorden: ");
INSERT INTO swef_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Av alla de män som har sett min härlighet och sett de tecken jag har gjort i Egypten och i öknen, och som nu tio gånger har frestat mig och inte lyssnat till min röst, ");
INSERT INTO swef_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","av dem ska ingen få se det land som jag med ed har lovat deras fäder. Ingen av dem som har föraktat mig ska få se det. ");
INSERT INTO swef_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Men i min tjänare Kaleb är en annan ande, och han har i allt följt mig. Därför ska jag föra honom in i det land där han nu har varit, och hans avkomlingar ska ta det i besittning. ");
INSERT INTO swef_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Men eftersom amalekiterna och kananeerna bor i dalen, så vänd er i morgon åt ett annat håll och dra ut i öknen mot Röda havet.” ");
INSERT INTO swef_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","”Hur länge ska denna onda församling klaga mot mig? Jag har hört hur Israels barn ständigt klagar mot mig. ");
INSERT INTO swef_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Säg nu till dem: Så sant jag lever, säger Herren, jag ska göra med er så som ni själva har sagt inför mig. ");
INSERT INTO swef_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Här i öknen ska era döda kroppar falla, alla ni som har blivit mönstrade och är tjugo år eller äldre, eftersom ni har klagat mot mig. ");
INSERT INTO swef_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ingen av er ska komma in i det land som jag med upplyft hand lovade er att få bo i, ingen utom Kaleb, Jefunnes son, och Josua, Nuns son. ");
INSERT INTO swef_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Men era barn, som ni sade skulle bli fiendens byte, dem ska jag föra in där, och de ska lära känna det land som ni har förkastat. ");
INSERT INTO swef_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Men era döda kroppar ska falla här i öknen. ");
INSERT INTO swef_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Och era barn ska vara herdar i öknen i fyrtio år och få lida för er trolöshet tills era döda kroppar har förmultnat i öknen. ");
INSERT INTO swef_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Så som ni under fyrtio dagar har spejat i landet ska ni under fyrtio år – ett år för varje dag – bära på era synder. Ni ska då få erfara att jag har tagit min hand ifrån er. ");
INSERT INTO swef_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Jag, Herren, har talat. Jag ska i sanning göra så med hela denna onda församling som har rotat sig samman mot mig. Här i öknen ska de omkomma, här ska de dö.” ");
INSERT INTO swef_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","De män som Mose hade sänt för att speja i landet och som vid sin återkomst hade fått hela församlingen att klaga mot honom genom att tala illa om landet, ");
INSERT INTO swef_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","dessa män som hade talat illa om landet dog genom en hemsökelse inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Av de män som hade gått ut för att speja i landet överlevde bara Josua, Nuns son, och Kaleb, Jefunnes son. ");
INSERT INTO swef_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose talade detta till alla Israels barn, och folket sörjde mycket. ");
INSERT INTO swef_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","De steg upp tidigt nästa morgon för att bege sig upp mot den övre bergsbygden och sade: ”Se, här är vi. Vi har syndat, men nu vill vi dra upp till den plats som Herren har talat om.” ");
INSERT INTO swef_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Men Mose sade: ”Varför vill ni bryta mot Herrens befallning? Det kommer inte att lyckas. ");
INSERT INTO swef_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Herren är inte med er. Därför ska ni inte dra dit upp, så att ni inte blir slagna inför era fiender. ");
INSERT INTO swef_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalekiterna och kananeerna kommer att möta er där och ni faller för svärd, för ni har vänt er bort från Herren och därför kommer Herren inte att vara med er.” ");
INSERT INTO swef_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","I sitt övermod drog de ändå upp mot den övre bergsbygden, men Herrens förbundsark och Mose lämnade inte lägret. ");
INSERT INTO swef_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalekiterna och kananeerna, som bodde där i bergsbygden, kom då ner och slog dem och drev dem på flykten ända till Horma. ");
INSERT INTO swef_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","”Tala till Israels barn och säg till dem: När ni kommer in i det land som jag ger er att bo i, ");
INSERT INTO swef_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","och ni vill offra ett eldsoffer åt Herren, ett brännoffer eller ett slaktoffer av nöt eller småboskap, för att bereda Herren en ljuvlig doft – vare sig det gäller att fullgöra ett löfte eller om det är ett frivilligt offer eller era högtidsoffer – ");
INSERT INTO swef_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","så ska den som bär fram ett sådant offer åt Herren, också som matoffer bära fram en tiondels efa fint mjöl, blandat med en fjärdedels hin olja, ");
INSERT INTO swef_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","och som dryckesoffer ska du offra en fjärdedels hin vin för varje lamm tillsammans med brännoffret eller slaktoffret. ");
INSERT INTO swef_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Till en bagge ska du som matoffer offra två tiondels efa fint mjöl, blandat med en tredjedels hin olja, ");
INSERT INTO swef_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","och som dryckesoffer ska du bära fram en tredjedels hin vin till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","När du offrar en ungtjur till brännoffer eller slaktoffer för att fullgöra ett löfte eller som gemenskapsoffer åt Herren, ");
INSERT INTO swef_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ska du tillsammans med tjuren som matoffer bära fram tre tiondels efa fint mjöl, blandat med en halv hin olja, ");
INSERT INTO swef_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","och som dryckesoffer ska du bära fram en halv hin vin, det är ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Så ska man göra med varje tjur, varje bagge, varje lamm eller killing. ");
INSERT INTO swef_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Efter det antal ni offrar, ska ni göra så med var och en efter deras antal. ");
INSERT INTO swef_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Varje infödd ska göra så när han bär fram ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","När en främling som bor hos er eller någon som vistas ibland er i kommande släkten vill offra ett eldsoffer till en ljuvlig doft för Herren, ska han göra så som ni gör. ");
INSERT INTO swef_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Inom församlingen ska samma stadga gälla för er och för främlingen hos er, en evig stadga från släkte till släkte. Som det är för er, så ska det vara för främlingen inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Samma lag och samma rätt ska gälla för er och för främlingen som bor hos er.” ");
INSERT INTO swef_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","”Tala till Israels barn och säg till dem: När ni kommer in i det land dit jag för er, ");
INSERT INTO swef_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","då ska ni, när ni äter av landets bröd, ge Herren en offergåva av det. ");
INSERT INTO swef_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Av det första ni bakar ska ni ge en kaka till offergåva, som en offergåva från er loge ska ni ge den. ");
INSERT INTO swef_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ni ska ge åt Herren en offergåva, släkte efter släkte, av det första ni bakar. ");
INSERT INTO swef_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Om ni försyndar er och inte håller alla dessa bud som Herren kungjorde för Mose ");
INSERT INTO swef_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","– allt det som Herren befallde er genom Mose, från den dag då Herren gav sina befallningar och allt framgent, släkte efter släkte, – ");
INSERT INTO swef_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","om det gjordes av misstag utan att församlingen visste det, ska hela församlingen offra en ungtjur som brännoffer, till en ljuvlig doft för Herren, med matoffret och dryckesoffret på föreskrivet sätt, och likaså en bock till syndoffer. ");
INSERT INTO swef_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Och prästen ska bringa försoning för hela Israels församling, och de ska få förlåtelse. Det var en synd av misstag, och de har burit fram sitt offer, ett eldsoffer åt Herren och sitt syndoffer inför Herrens ansikte för sitt misstag. ");
INSERT INTO swef_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Hela Israels församling och främlingen som bor bland dem ska få förlåtelse, eftersom hela folket hade del i synden som gjordes av misstag. ");
INSERT INTO swef_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Om en enskild person av misstag syndar, ska han som syndoffer föra fram en årsgammal get. ");
INSERT INTO swef_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Prästen ska bringa försoning för den som har felat genom att av misstag synda inför Herrens ansikte. Så blir han försonad och får förlåtelse. ");
INSERT INTO swef_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Både för den infödde bland Israels barn och för främlingen som bor ibland dem ska samma lag gälla när någon begår en synd av misstag. ");
INSERT INTO swef_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Men den som begår något med berått mod, vare sig han är infödd eller främling, han hånar Herren och ska utrotas ur sitt folk. ");
INSERT INTO swef_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Eftersom han har föraktat Herrens ord och brutit mot hans bud, måste han utrotas. Hans missgärning vilar på honom.” ");
INSERT INTO swef_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Medan Israels barn var i öknen, ertappades en man med att samla ved på sabbatsdagen. ");
INSERT INTO swef_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","De som ertappade honom med att samla ved förde honom till Mose och Aron och hela församlingen. ");
INSERT INTO swef_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Då det inte var klart utsagt vad som borde göras med honom, satte de honom i förvar. ");
INSERT INTO swef_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Och Herren sade till Mose: ”Mannen ska straffas med döden. Hela församlingen ska stena honom utanför lägret.” ");
INSERT INTO swef_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Då förde hela församlingen ut honom utanför lägret och stenade honom till döds, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","”Tala till Israels barn och säg till dem att de, släkte efter släkte, ska göra tofsar i hörnen på sina kläder och sätta ett mörkblått snöre på varje hörntofs. ");
INSERT INTO swef_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ni ska ha sådana tofsar, och när ni ser dem ska ni tänka på alla Herrens bud och göra efter dem och inte följa era egna hjärtan och ögon, som lockar er till otrohet. ");
INSERT INTO swef_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Så ska ni tänka på och göra efter alla mina bud och vara heliga inför er Gud. ");
INSERT INTO swef_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Jag är Herren er Gud, som förde er ut ur Egyptens land för att vara er Gud. Jag är Herren er Gud.” ");
INSERT INTO swef_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora, son till Jishar, son till Kehat, son till Levi, tog med sig både Datan och Abiram, Eliabs söner, och On, Pelets son, av Rubens söner, ");
INSERT INTO swef_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","och gjorde uppror mot Mose. Tvåhundrafemtio män av Israels barn följde dem, furstar i församlingen, utvalda från folkförsamlingen, ansedda män. ");
INSERT INTO swef_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","De samlade sig mot Mose och Aron och sade till dem: ”Nu får det vara nog! Hela församlingen är helig, allesammans, och Herren är mitt ibland dem. Varför upphöjer ni er över Herrens församling?” ");
INSERT INTO swef_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","När Mose hörde det föll han ner på sitt ansikte. ");
INSERT INTO swef_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Sedan talade han till Kora och hela hans grupp och sade: ”I morgon ska Herren visa vem som tillhör honom, vem som är helig och vem som får komma inför honom. Den han utväljer ska få komma inför honom. ");
INSERT INTO swef_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Gör så här: Ta era fyrfat, du Kora och hela din grupp, ");
INSERT INTO swef_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","och lägg eld i dem och strö rökelse på dem inför Herrens ansikte i morgon. Den man som Herren då utväljer, han är den helige. Nu får det vara nog, ni Levi söner!” ");
INSERT INTO swef_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Och Mose sade till Kora: ”Hör, ni Levi söner! ");
INSERT INTO swef_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Är det inte nog för er att Israels Gud har avskilt er från Israels församling för att låta er komma inför sig och göra tjänst i Herrens tabernakel och stå inför församlingen och betjäna den. ");
INSERT INTO swef_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Han har låtit dig och alla dina bröder, Levi söner, jämte dig komma inför sig. Och nu begär ni också prästämbetet! ");
INSERT INTO swef_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Det är därför som du och hela din grupp har gaddat ihop er mot Herren. Vem är Aron att ni skulle klaga mot honom?” ");
INSERT INTO swef_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mose sände bud efter Datan och Abiram, Eliabs söner. Men de sade: ”Vi kommer inte. ");
INSERT INTO swef_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Är det inte nog att du har fört oss hit upp från ett land som flödar av mjölk och honung för att låta oss dö i öknen? Nu vill du också göra dig till herre över oss! ");
INSERT INTO swef_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Du har sannerligen inte fört oss in i ett land som flödar av mjölk och honung eller gett oss åkrar och vingårdar till arvedel. Tänker du sticka ut ögonen på dessa människor? Nej, vi kommer inte!” ");
INSERT INTO swef_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Då blev Mose mycket vred och sade till Herren: ”Se inte till deras offergåva. Inte en enda åsna har jag tagit av dem, och ingen av dem har jag gjort något ont.” ");
INSERT INTO swef_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose sade till Kora: ”I morgon ska du och hela din grupp träda fram inför Herrens ansikte, du själv och de och Aron. ");
INSERT INTO swef_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Och var och en av er ska ta sitt fyrfat och lägga rökelse på det och bära sitt fyrfat fram inför Herrens ansikte, tvåhundrafemtio fyrfat. Du själv och Aron ska också ta var sitt fyrfat.” ");
INSERT INTO swef_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Och de tog var och en sitt fyrfat och lade eld på det och strödde på rökelse och ställde sig vid ingången till uppenbarelsetältet tillsammans med Mose och Aron. ");
INSERT INTO swef_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora samlade hela församlingen mot dem vid ingången till uppenbarelsetältet. Då visade sig Herrens härlighet för hela församlingen. ");
INSERT INTO swef_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Och Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","”Skilj er från denna församling, så ska jag förgöra dem på ett ögonblick.” ");
INSERT INTO swef_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Då föll de ner på sina ansikten och sade: ”O Gud, du Gud som råder över anden i allt kött! Ska du bli vred på hela församlingen för att en enda man syndar?” ");
INSERT INTO swef_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Då talade Herren till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","”Säg till församlingen: Dra er bort från lägerplatsen kring Kora, Datan och Abiram.” ");
INSERT INTO swef_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mose steg upp och gick till Datan och Abiram, och de äldste i Israel följde honom. ");
INSERT INTO swef_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mose talade till församlingen. Han sade: ”Vik bort från dessa ogudaktiga människors tält och rör inte något som tillhör dem, så att ni inte förgås genom alla deras synder.” ");
INSERT INTO swef_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Då drog de sig bort från lägerplatsen kring Kora, Datan och Abiram. Men Datan och Abiram kom ut och ställde sig vid ingången till sina tält med sina hustrur och barn, stora och små. ");
INSERT INTO swef_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Och Mose sade: ”Av detta ska ni förstå att det är Herren som har sänt mig att göra alla dessa gärningar. Jag har inte handlat efter eget tycke. ");
INSERT INTO swef_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Om dessa dör på samma sätt som andra människor och får samma straff som alla andra, då har Herren inte sänt mig. ");
INSERT INTO swef_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Men om Herren gör något nytt genom att marken spärrar upp sitt gap och slukar dem med allt de äger så att de far levande ner i dödsriket, då ska ni förstå att dessa människor har föraktat Herren.” ");
INSERT INTO swef_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Just när han hade sagt detta, rämnade marken under dem. ");
INSERT INTO swef_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Jorden öppnade sitt gap och slukade dem och deras hus, allt Koras folk och alla deras ägodelar. ");
INSERT INTO swef_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","De föll levande ner i dödsriket med allt de ägde, och jorden täckte över dem. Så utrotades de ur församlingen. ");
INSERT INTO swef_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Hela Israel som stod runt omkring dem flydde vid deras rop, för de sade: ”Annars slukas vi också av jorden!” ");
INSERT INTO swef_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Och eld gick ut från Herren och förtärde de tvåhundrafemtio männen som hade burit fram rökelse. ");
INSERT INTO swef_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","”Säg till Eleasar, prästen Arons son, att han ska ta ut fyrfaten ur branden och kasta elden långt bort, för de har blivit heliga. ");
INSERT INTO swef_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Och dessa fyrfat som tillhörde männen som syndade och miste sina liv, dem ska man hamra ut till plåtar och täcka altaret med, för de har varit framburna inför Herrens ansikte och har därför blivit heliga. De ska vara ett tecken för Israels barn.” ");
INSERT INTO swef_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Då tog prästen Eleasar de fyrfat av koppar som de uppbrända hade burit fram, och man hamrade ut dem för att täcka altaret. ");
INSERT INTO swef_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","De skulle vara till en påminnelse för Israels barn att ingen främling som inte var av Arons släkt skulle träda fram och tända rökelse inför Herrens ansikte, för att inte bli som Kora och hans grupp – allt i enlighet med vad Herren hade sagt honom genom Mose. ");
INSERT INTO swef_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Men dagen efter klagade hela Israels församling mot Mose och Aron och sade: ”Det är ni som har dödat Herrens folk!” ");
INSERT INTO swef_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Och det hände att när församlingen samlades mot Mose och Aron och de vände sig mot uppenbarelsetältet, se, då täcktes det av molnskyn och Herrens härlighet visade sig. ");
INSERT INTO swef_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mose och Aron gick fram inför uppenbarelsetältet, ");
INSERT INTO swef_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","”Gå bort ifrån denna församling, så ska jag i ett ögonblick förgöra dem.” Då föll de ner på sina ansikten. ");
INSERT INTO swef_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Och Mose sade till Aron: ”Ta ditt fyrfat och lägg eld från altaret på det och strö på rökelse och bär det genast till församlingen och bringa försoning för dem, eftersom vrede har gått ut från Herrens ansikte. Hemsökelsen har börjat.” ");
INSERT INTO swef_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron tog det Mose hade sagt och skyndade mitt in i församlingen. Och se, hemsökelsen hade redan börjat bland folket. Aron lade på rökelse och bringade försoning för folket. ");
INSERT INTO swef_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Han stod mellan de döda och de levande, och hemsökelsen upphörde. ");
INSERT INTO swef_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","De som hade dött genom hemsökelsen utgjorde 14 700 förutom de som dog för Koras skull. ");
INSERT INTO swef_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Sedan vände Aron tillbaka till Mose vid uppenbarelsetältets ingång, eftersom hemsökelsen hade upphört. ");
INSERT INTO swef_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","”Tala till Israels barn och ta från dem en stav för varje stam. Från alla deras stamhövdingar ska du ta tolv stavar och skriva vars och ens namn på hans stav. ");
INSERT INTO swef_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Arons namn ska du skriva på Levis stav, för huvudmannen för denna stams familjer ska ha en stav. ");
INSERT INTO swef_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Sedan ska du lägga in dem i uppenbarelsetältet framför vittnesbördet där jag möter er. ");
INSERT INTO swef_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Då ska det ske att den man som jag utväljer, hans stav ska grönska. Så ska jag göra slut på Israels barns klagan, eftersom de ständigt klagar mot er.” ");
INSERT INTO swef_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mose talade till Israels barn, och alla stamhövdingarna gav honom var och en sin stav, tolv stavar, och Arons stav var med bland deras stavar. ");
INSERT INTO swef_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Och Mose lade stavarna inför Herrens ansikte i vittnesbördets tält. ");
INSERT INTO swef_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nästa dag gick Mose in i vittnesbördets tält, och se, Arons stav för Levi hus grönskade, och den hade knoppar och utslagna blommor och mogna mandlar. ");
INSERT INTO swef_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mose bar ut alla stavarna från Herrens ansikte till alla Israels barn. De såg på dem, och var och en tog sin stav. ");
INSERT INTO swef_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Och Herren sade till Mose: ”Lägg tillbaka Arons stav framför vittnesbördet. Den ska förvaras som ett tecken för de upproriska. Så ska du göra slut på deras klagande mot mig så att de inte dör.” ");
INSERT INTO swef_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose gjorde det. Så som Herren hade befallt honom, så gjorde han. ");
INSERT INTO swef_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israels barn sade till Mose: ”Se, vi dör, vi går under, vi går under allihop! ");
INSERT INTO swef_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Alla som kommer i närheten av Herrens tabernakel kommer att dö. Ska vi dö allihop?” ");
INSERT INTO swef_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Herren sade till Aron: ”Du och dina söner och din fars hus med dig ska bära den missgärning som hör till helgedomen, och du och dina söner med dig ska bära den missgärning som hör till ert prästämbete. ");
INSERT INTO swef_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Men också dina bröder av Levi stam, din fars stam, ska du låta få tillträde dit tillsammans med dig, och de ska hålla sig till dig och betjäna dig medan du och dina söner med dig gör tjänst vid vittnesbördets tält. ");
INSERT INTO swef_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","De ska sköta vad du har att sköta och vad som hör till skötseln av tältet. Men de får inte komma nära de heliga föremålen eller altaret, för att inte både de och ni ska dö. ");
INSERT INTO swef_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","De ska hålla sig till dig och sköta vad som hör till uppenbarelsetältet, under all tjänstgöring vid tältet. Ingen främling får komma nära dig. ");
INSERT INTO swef_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ni ska iaktta vad som hör till skötseln av helgedomen och altaret, för att inte vrede åter ska komma över Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Det är jag som har utvalt era bröder leviterna bland Israels barn. De är en gåva åt er, givna åt Herren till att förrätta tjänsten vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Men du och dina söner med dig ska sköta vad som hör till ert prästämbete, i allt som avser altaret och det som är innanför förhänget. Så ska ni göra tjänst. Jag ger er prästämbetet som en gåva. Om en obehörig inkräktar på det ska han dödas.” ");
INSERT INTO swef_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Herren sade till Aron: ”Se, jag överlämnar åt dig att ta hand om det som offras åt mig. Av Israels barns alla heliga gåvor ger jag detta som en ämbetslott åt dig och dina söner, som en evig rätt. ");
INSERT INTO swef_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Av det högheliga som inte lämnas åt elden ska detta tillhöra dig: Alla deras offergåvor, alla matoffer, syndoffer eller skuldoffer som de offrar åt mig. Detta är högheligt och tillhör dig och dina söner. ");
INSERT INTO swef_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","På en höghelig plats ska du äta det. Alla av manligt kön ska äta det. Det ska vara heligt för dig. ");
INSERT INTO swef_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Också Israels barns alla lyftoffer som bärs fram som gåvor ska tillhöra dig. Som en evig rättighet ger jag dem åt dig och dina söner och döttrar med dig. Var och en i ditt hus som är ren kan äta det. ");
INSERT INTO swef_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Allt det bästa av oljan och det bästa av det nya vinet och av säden, det första av det som de ger åt Herren, ger jag åt dig. ");
INSERT INTO swef_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","De första frukterna av allt som växer i deras land och som de bär fram åt Herren ska tillhöra dig. Var och en i ditt hus som är ren kan äta av det. ");
INSERT INTO swef_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Allt i Israel som vigs åt Herren ska tillhöra dig. ");
INSERT INTO swef_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Allt som öppnar moderlivet, varje varelse, människa eller djur, som de för fram till Herren ska tillhöra dig. Men du ska friköpa det förstfödda bland människor och även friköpa det förstfödda bland orena djur. ");
INSERT INTO swef_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","När de är en månad gamla ska du friköpa dem med lösensumman som är bestämd till fem siklar silver, efter helgedomssikelns vikt som är tjugo gera. ");
INSERT INTO swef_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Men det förstfödda bland kor, får eller getter ska du inte friköpa. Det är heligt. Deras blod ska du stänka på altaret, och deras fett ska du förbränna som ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Men deras kött ska tillhöra dig, liksom även lyftofferbringan och det högra lårstycket ska tillhöra dig. ");
INSERT INTO swef_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alla heliga gåvor som Israels barn offrar åt Herren ger jag åt dig och dina söner och döttrar med dig som en evig rätt. Detta ska vara ett evigt saltförbund inför Herrens ansikte, för dig och för dina avkomlingar.” ");
INSERT INTO swef_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Herren sade till Aron: ”I deras land ska du inte ha någon arvedel, och du ska inte ha någon lott bland dem. Jag ska vara din lott och din arvedel bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Se, jag ger åt Levi barn allt tionde i Israel till arvedel, som lön för den tjänst de utför, tjänsten vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Och Israels barn ska härefter inte komma nära uppenbarelsetältet, för de kommer då att bära på synd och måste dö. ");
INSERT INTO swef_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Det är leviterna som ska förrätta tjänsten vid uppenbarelsetältet, och de ska själva bära sina missgärningar. Det ska vara en evig stadga från släkte till släkte: De ska inte ha någon arvedel bland Israels barn, ");
INSERT INTO swef_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","för jag ger tiondet som Israels barn offrar som gåva åt Herren till arvedel åt leviterna. Det är därför jag säger om dem: De ska inte ha någon arvedel bland Israels barn.” ");
INSERT INTO swef_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","”Tala till leviterna och säg: När ni av Israels barn tar emot det tionde som jag har bestämt att ni ska få av dem som er arvedel, då ska ni av det ge en gåva åt Herren, ett tionde av tiondena. ");
INSERT INTO swef_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Denna er gåva ska räknas som om det vore brödsäd från logen och den fulla avkastningen från vinpressen. ");
INSERT INTO swef_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Så ska också ni ge en gåva åt Herren av allt tionde som ni tar emot av Israels barn. Denna Herrens gåva av tionden ska ni ge åt prästen Aron. ");
INSERT INTO swef_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Av alla gåvor ni får ska ni offra åt Herren allt det som tillhör honom, det bästa av gåvorna, den del som är helig. ");
INSERT INTO swef_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Du ska säga till dem: När ni ger som gåva det bästa, ska leviternas gåva räknas som om det vore vad loge och press avkastar. ");
INSERT INTO swef_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ni får äta det var som helst med ert husfolk, för det är er lön för er tjänstgöring vid uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","När ni offrar det bästa av det ska ni inte bära på synd. Då ska ni inte ohelga Israels barns heliga gåvor, så att ni måste dö.” ");
INSERT INTO swef_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Herren talade till Mose och Aron. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","”Detta är en lagstadga som Herren har befallt: Säg till Israels barn att de skaffar fram åt dig en röd kviga som är felfri och inte har någon defekt och som inte har burit något ok. ");
INSERT INTO swef_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ni ska ge den åt prästen Eleasar, och man ska föra den utanför lägret och slakta den i hans åsyn. ");
INSERT INTO swef_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Och prästen Eleasar ska ta något av blodet från kvigan på sitt finger och stänka det sju gånger mot framsidan av uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Sedan ska man bränna upp kvigan inför hans ögon. Hud och kött och blod ska brännas upp tillsammans med hennes orenlighet. ");
INSERT INTO swef_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Och prästen ska ta cederträ, isop och karmosinrött garn och kasta det i elden där kvigan bränns upp. ");
INSERT INTO swef_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Sedan ska prästen tvätta sina kläder och bada sin kropp i vatten. Därefter får han gå in i lägret, men han ska vara oren till kvällen. ");
INSERT INTO swef_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Också den som brände upp kvigan ska tvätta sina kläder i vatten och bada sin kropp i vatten och vara oren till kvällen. ");
INSERT INTO swef_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","En man som är ren ska samla ihop askan efter kvigan och lägga den utanför lägret på en ren plats. Den ska förvaras åt Israels barns församling för att användas i reningsvattnet. Detta är ett syndoffer. ");
INSERT INTO swef_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Den som samlade ihop askan efter kvigan ska tvätta sina kläder och vara oren till kvällen. Detta ska vara en evig stadga för Israels barn och för främlingen som bor ibland dem. ");
INSERT INTO swef_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Den som rör vid en död människa ska vara oren i sju dagar. ");
INSERT INTO swef_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Han ska rena sig med vattnet på tredje dagen och på sjunde dagen, och så blir han ren. Men om han inte renar sig på tredje dagen och på sjunde dagen, blir han inte ren. ");
INSERT INTO swef_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Var och en som rör vid ett lik, vid en död människa, och inte renar sig, han orenar Herrens tabernakel och ska utrotas ur Israel. Eftersom reningsvattnet inte blivit stänkt på honom är han oren. Hans orenhet är alltjämt kvar. ");
INSERT INTO swef_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Detta är lagen när en människa dör i ett tält: Var och en som kommer in i tältet, och var och en som redan är i tältet ska vara oren i sju dagar. ");
INSERT INTO swef_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Alla öppna kärl som inte har stått övertäckta ska vara orena. ");
INSERT INTO swef_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Och var och en som ute på marken rör vid någon som har dräpts med svärd eller dött på annat sätt, eller rör vid människoben eller en grav, ska vara oren i sju dagar. ");
INSERT INTO swef_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","För den som är oren ska man ta av askan efter det uppbrända syndoffret och hälla friskt vatten över det i ett kärl. ");
INSERT INTO swef_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","En man som är ren ska ta isop och doppa i vattnet och stänka på tältet, på alla kärlen, på de personer som varit där, på den som rört vid benen, på den dräpte och på den som dött på annat sätt eller på graven. ");
INSERT INTO swef_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Och den som är ren ska på tredje dagen och på sjunde dagen bestänka den som har blivit oren. När han så på sjunde dagen har renat honom, ska han tvätta sina kläder och bada i vatten, så blir han ren om kvällen. ");
INSERT INTO swef_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Men om någon har blivit oren och sedan inte renar sig ska han utrotas ur församlingen, för han har orenat Herrens helgedom. Reningsvattnet har inte blivit stänkt på honom. Han är oren. ");
INSERT INTO swef_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Detta ska vara en evig stadga för dem. Mannen som stänkte reningsvattnet ska tvätta sina kläder, och om någon rör vid detta reningsvatten ska han vara oren till kvällen. ");
INSERT INTO swef_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Allt som den orene rör vid ska vara orent, och den som rör vid honom ska vara oren till kvällen.” ");
INSERT INTO swef_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israels barn, hela församlingen, kom in i öknen Zin i den första månaden, och folket stannade i Kadesh. Där dog Mirjam, och där begravdes hon. ");
INSERT INTO swef_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Och församlingen saknade vatten, och därför slöt de sig samman mot Mose och Aron. ");
INSERT INTO swef_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Folket klagade på Mose och sade: ”Om vi ändå hade fått dö när våra bröder dog inför Herrens ansikte! ");
INSERT INTO swef_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Varför har ni låtit Herrens församling komma in i denna öken, så att vi och vår boskap måste dö här? ");
INSERT INTO swef_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Varför har ni fört oss upp ur Egypten och låtit oss komma till denna hemska plats? Här växer varken säd eller fikon, vindruvor eller granatäpplen, och här finns inget vatten att dricka.” ");
INSERT INTO swef_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Men Mose och Aron gick bort från församlingen till uppenbarelsetältets ingång och föll ner på sina ansikten. Då visade sig Herrens härlighet för dem. ");
INSERT INTO swef_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Och Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","”Ta staven och kalla samman församlingen, du och din bror Aron, och tala till klippan inför deras ögon, och den ska ge vatten. Så skaffar du fram vatten åt dem ur klippan och ger församlingen och dess boskap att dricka.” ");
INSERT INTO swef_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Då tog Mose staven som låg inför Herrens ansikte, så som han hade befallt honom. ");
INSERT INTO swef_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Och Mose och Aron kallade samman församlingen framför klippan, och han sade till dem: ”Lyssna, ni upproriska! Kan vi ur denna klippa skaffa fram vatten åt er?” ");
INSERT INTO swef_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Sedan lyfte Mose upp sin hand och slog med sin stav två gånger på klippan, och mycket vatten kom ut så att både folket och boskapen fick dricka. ");
INSERT INTO swef_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Men Herren sade till Mose och Aron: ”Eftersom ni inte litade på mig och inte höll mig helig inför Israels barns ögon, ska ni inte få föra in denna församling i det land som jag gett dem.” ");
INSERT INTO swef_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Detta var Meribas vatten, där Israels barn tvistade med Herren och där han visade sig helig bland dem. ");
INSERT INTO swef_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mose skickade sändebud från Kadesh till kungen i Edom och lät säga: ”Så säger din broder Israel: Du känner alla de vedermödor som har drabbat oss. ");
INSERT INTO swef_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Våra fäder drog ner till Egypten, vi bodde i Egypten under lång tid och vi och våra fäder blev illa behandlade av egyptierna. ");
INSERT INTO swef_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Men vi ropade till Herren, och han hörde vår röst och sände en ängel som förde oss ut ur Egypten. Och se, nu är vi i Kadesh, en stad som gränsar till ditt område. ");
INSERT INTO swef_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Låt oss tåga igenom ditt land. Vi ska inte gå över åkrar och vingårdar och inte dricka vatten ur brunnarna. Vi ska ta Kungsvägen utan att vika av vare sig åt höger eller vänster förrän vi har kommit igenom ditt område.” ");
INSERT INTO swef_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Men Edom svarade honom: ”Du får inte tåga igenom mitt land. Om du gör det ska jag komma mot dig med svärd.” ");
INSERT INTO swef_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israels barn sade till honom: ”Vi ska hålla oss på den allmänna vägen och om vi eller vår boskap dricker av ditt vatten, ska jag betala för det. Jag begär bara att få gå till fots genom landet, ingenting annat.” ");
INSERT INTO swef_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Han svarade: ”Nej, du får inte gå härigenom.” Och Edom drog ut mot Israel med mycket folk och med stor makt. ");
INSERT INTO swef_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Eftersom Edom inte lät Israel ta vägen igenom deras område, vek Israel undan för dem. ");
INSERT INTO swef_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Och Israels barn, hela församlingen, bröt upp från Kadesh och kom till berget Hor. ");
INSERT INTO swef_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Herren talade då till Mose och Aron på berget Hor vid gränsen till Edoms land. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","”Aron ska samlas till sitt folk. Han ska inte komma in i det land som jag har gett åt Israels barn, för ni trotsade min befallning vid Meribas vatten. ");
INSERT INTO swef_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ta Aron och hans son Eleasar och för dem upp på berget Hor, ");
INSERT INTO swef_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","och ta av Aron hans kläder och sätt dem på hans son Eleasar. Aron kommer att samlas till sitt folk och dö där.” ");
INSERT INTO swef_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mose gjorde som Herren hade befallt, och de steg upp på berget Hor inför ögonen på hela församlingen. ");
INSERT INTO swef_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mose tog av Aron hans kläder och satte dem på hans son Eleasar. Och Aron dog där uppe på bergets topp. Sedan steg Mose och Eleasar ner från berget. ");
INSERT INTO swef_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","När hela församlingen såg att Aron var död, sörjde hela Israel honom i trettio dagar. ");
INSERT INTO swef_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","När den kananeiske kungen av Arad, som bodde i Negev, hörde att Israel närmade sig på Atarimvägen, gav han sig i strid med Israel och tog några av dem till fånga. ");
INSERT INTO swef_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Då gav Israel ett löfte till Herren: ”Om du ger detta folk i min hand, ska jag viga deras städer åt förintelse.” ");
INSERT INTO swef_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Herren lyssnade till Israels röst och gav kananeerna i deras hand, och de vigde dem och deras städer åt förintelse. Och platsen fick namnet Horma. ");
INSERT INTO swef_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","De bröt upp från berget Hor och tog vägen mot Röda havet för att gå omkring Edoms land. Men under vägen blev folket otåligt. ");
INSERT INTO swef_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Och folket talade mot Gud och mot Mose och sade: ”Varför har ni fört oss upp ur Egypten så att vi måste dö i öknen? Här finns ju varken bröd eller vatten, och vår själ avskyr den eländiga mat vi får!” ");
INSERT INTO swef_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Då sände Herren giftiga ormar bland folket, och de bet folket och många i Israel dog. ");
INSERT INTO swef_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Då kom folket till Mose och sade: ”Vi har syndat genom att vi talade mot Herren och mot dig. Be till Herren att han tar bort dessa ormar från oss.” Och Mose bad för folket. ");
INSERT INTO swef_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Herren sade till Mose: ”Gör dig en orm och sätt upp den på en påle. Den som har blivit ormbiten och ser på den ska leva.” ");
INSERT INTO swef_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mose gjorde då en kopparorm och satte upp den på en påle. Om någon blev biten av en orm, fäste han blicken på kopparormen och fick leva. ");
INSERT INTO swef_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israels barn bröt upp och slog läger i Obot. ");
INSERT INTO swef_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Från Obot bröt de upp och slog läger vid Ije-Haabarim i öknen framför Moab, österut. ");
INSERT INTO swef_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Därifrån bröt de upp och slog läger i Sereds dal. ");
INSERT INTO swef_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Därifrån bröt de upp och slog läger på andra sidan Arnon som går genom öknen och kommer från amoreernas område. Arnon utgör Moabs gräns, mellan Moab och amoreerna. ");
INSERT INTO swef_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Därför heter det i Boken om Herrens krig: ”Vaheb i Sufa, och Arnons bäckravin, ");
INSERT INTO swef_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","och bäckravinens sidor som går ner till Ars bosättning och lutar sig mot Moabs gräns.” ");
INSERT INTO swef_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Därifrån drog de till Beer. Det var om den brunnen som Herren sade till Mose: ”Samla folket så ska jag ge dem vatten.” ");
INSERT INTO swef_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Då sjöng Israel denna sång: ”Flöda, du brunn! Sjung om den! ");
INSERT INTO swef_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Brunnen som hövdingar grävde, som folkets främste grävde ut med spiran, med sina stavar.” Från öknen drog de till Mattana, ");
INSERT INTO swef_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","från Mattana till Nahaliel, från Nahaliel till Bamot, ");
INSERT INTO swef_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","från Bamot till den dal som ligger på Moabs mark, till Pisgas topp, där man ser ut över Jeshimon. ");
INSERT INTO swef_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel skickade då sändebud till Sichon, amoreernas kung, och lät säga: ");
INSERT INTO swef_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","”Låt mig tåga igenom ditt land. Vi ska inte vika av in på åkrar eller in i vingårdar och inte dricka vatten ur brunnarna. Vi ska gå Kungsvägen tills vi har kommit igenom ditt område.” ");
INSERT INTO swef_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Men Sichon tillät inte Israel att gå igenom hans område. Sichon samlade allt sitt folk och drog ut mot Israel i öknen. När han kom till Jahas gav han sig i strid med Israel. ");
INSERT INTO swef_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Men Israel slog honom med svärd och intog hans land från Arnon till Jabbok, ända fram till ammoniterna, för deras gräns var befäst. ");
INSERT INTO swef_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Och Israel intog alla städerna där och bosatte sig i amoreernas alla städer, i Heshbon med alla dess underlydande orter. ");
INSERT INTO swef_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon var nämligen den amoreiske kungen Sichons stad, för han hade fört krig mot den förre kungen i Moab och tagit ifrån honom hela hans land ända till Arnon. ");
INSERT INTO swef_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Därför säger skalderna: ”Kom till Heshbon, Bygg och befäst Sichons stad, ");
INSERT INTO swef_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","för en eld gick ut från Heshbon, en låga från Sichons stad. Den förtärde Ar i Moab, herrarna på Arnons höjder. ");
INSERT INTO swef_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ve dig, Moab! Förlorat är du, Kemoshs folk! Han lät sina söner bli flyktingar och sina döttrar gå i fångenskap, till amoreernas kung, Sichon. ");
INSERT INTO swef_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Vi sköt ner dem. Förlorat var Heshbon, ända till Dibon. Vi härjade ända till Nofa som når till Medeba.” ");
INSERT INTO swef_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Så bosatte sig Israel i amoreernas land. ");
INSERT INTO swef_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mose sände ut några att speja vid Jaeser, och de intog dess underlydande orter, och han fördrev amoreerna som bodde där. ");
INSERT INTO swef_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Sedan vek de av och drog upp mot Bashan. Och Bashans kung Og drog med allt sitt folk ut till strid mot dem, vid Edrei. ");
INSERT INTO swef_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Men Herren sade till Mose: ”Var inte rädd för honom, för jag har gett honom i din hand med allt hans folk och hans land. Du ska göra med honom som du gjorde med Sichon, amoreernas kung, som bodde i Heshbon.” ");
INSERT INTO swef_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Och de slog honom och hans söner och allt hans folk tills ingen överlevande fanns kvar och tog hans land i besittning. ");
INSERT INTO swef_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israels barn bröt upp och slog läger på Moabs hedar, på andra sidan Jordan mitt emot Jeriko. ");
INSERT INTO swef_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, Sippors son, såg allt som Israel hade gjort mot amoreerna. ");
INSERT INTO swef_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Och Moab var rädda för folket därför att det var så talrikt. Moab gruvade sig för Israels barn ");
INSERT INTO swef_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","och sade till de äldste i Midjan: ”Nu kommer denna skara att äta upp allt omkring oss, liksom oxen äter upp gräset på marken.” På den tiden var Balak, Sippors son, kung i Moab. ");
INSERT INTO swef_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Han skickade sändebud till Bileam, Beors son, i Petor vid floden där hans folk bodde för att kalla honom till sig, och han lät säga: ”Nu har ett folk dragit ut ur Egypten, det täcker markens yta och har slagit sig ner mitt emot mig. ");
INSERT INTO swef_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kom nu därför och förbanna det folket åt mig, för det är starkare än jag. Kanske kan jag då slå det och driva bort det ur landet. Jag vet ju att den du välsignar är välsignad, och den du förbannar är förbannad.” ");
INSERT INTO swef_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","De äldste i Moab och de äldste i Midjan gav sig i väg och hade med sig spådomslön. De kom till Bileam och framförde till honom vad Balak hade sagt. ");
INSERT INTO swef_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bileam sade till dem: ”Stanna här över natten, så ska jag komma tillbaka till er med de ord som Herren talar till mig.” Då stannade Moabs hövdingar kvar hos Bileam. ");
INSERT INTO swef_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Och Gud kom till Bileam och sade: ”Vilka är de män du har hos dig?” ");
INSERT INTO swef_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileam svarade Gud: ”Balak, Sippors son, kung av Moab, har sänt mig detta bud: ");
INSERT INTO swef_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Nu har ett folk dragit ut ur Egypten, och det täcker markens yta. Kom nu och förbanna det åt mig. Kanske kan jag då strida mot det och driva bort det.” ");
INSERT INTO swef_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Men Gud sade till Bileam: ”Du ska inte gå med dem. Du ska inte förbanna detta folk, för det är välsignat.” ");
INSERT INTO swef_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","När Bileam steg upp på morgonen, sade han till Balaks hövdingar: ”Gå hem till ert land, för Herren tillåter mig inte att följa med er.” ");
INSERT INTO swef_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Då återvände Moabs hövdingar till Balak och sade: ”Bileam vägrar att följa med oss.” ");
INSERT INTO swef_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Men Balak skickade återigen hövdingar, fler och av högre rang än de förra. ");
INSERT INTO swef_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","De kom till Bileam och sade till honom: ”Så säger Balak, Sippors son: Låt ingenting hindra dig från att komma till mig, ");
INSERT INTO swef_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","för jag vill visa dig mycket stor ära, och allt du säger till mig ska jag göra. Kom nu och förbanna det folket åt mig.” ");
INSERT INTO swef_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam svarade Balaks tjänare: ”Även om Balak skulle ge mig så mycket silver och guld som hans palats rymmer, kan jag inte överträda Herren min Guds befallning, vare sig i smått eller stort. ");
INSERT INTO swef_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Men stanna också ni kvar här över natten, så att jag får reda på vad Herren mer har att säga mig.” ");
INSERT INTO swef_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Om natten kom Gud till Bileam och sade till honom: ”Om männen har kommit för att kalla på dig, så bryt upp och följ med dem. Men du ska endast göra det som jag säger dig.” ");
INSERT INTO swef_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Och Bileam steg upp på morgonen, sadlade sitt åsnesto och följde med Moabs hövdingar. ");
INSERT INTO swef_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Men då han nu följde med dem upptändes Guds vrede, och Herrens ängel ställde sig på vägen för att hindra honom. Bileam red på sin åsna och två av hans tjänare var med honom. ");
INSERT INTO swef_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","När åsnan fick se Herrens ängel stå på vägen med ett draget svärd i handen, vek hon av från vägen och gick ut på åkern. Men Bileam slog åsnan för att driva henne tillbaka in på vägen. ");
INSERT INTO swef_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Herrens ängel ställde sig då på en trång väg mellan vingårdarna, med murar på båda sidor. ");
INSERT INTO swef_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Åsnan såg Herrens ängel och trängde sig mot muren och klämde Bileams fot mot muren, och han slog henne ännu en gång. ");
INSERT INTO swef_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Herrens ängel gick åter längre fram och ställde sig på ett trångt ställe, där det inte fanns någon möjlighet att vika undan vare sig åt höger eller vänster. ");
INSERT INTO swef_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","När åsnan nu fick se Herrens ängel, lade hon sig ner under Bileam. Bileam blev arg och slog åsnan med staven. ");
INSERT INTO swef_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Då öppnade Herren åsnans mun, och hon sade till Bileam: ”Vad har jag gjort mot dig, eftersom du tre gånger har slagit mig?” ");
INSERT INTO swef_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam svarade åsnan: ”Du har gjort mig till åtlöje! Hade jag haft ett svärd i handen skulle jag nu ha dödat dig.” ");
INSERT INTO swef_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Men åsninnan sade till Bileam: ”Är inte jag din egen åsna som du ridit på i hela ditt liv ända tills i dag? Har jag någonsin förut brukat göra så mot dig?” Han svarade: ”Nej.” ");
INSERT INTO swef_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Då öppnade Herren Bileams ögon, så att han såg Herrens ängel stå på vägen med ett draget svärd i handen. Och han bugade sig och föll ner på sitt ansikte. ");
INSERT INTO swef_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Herrens ängel sade till honom: ”Varför har du dessa tre gånger slagit din åsna? Se, jag har gått ut för att hindra dig, för jag ser att den här vägen leder till fördärvet. ");
INSERT INTO swef_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Åsnan såg mig och har dessa tre gånger vikit undan för mig. Hade hon inte vikit undan för mig, skulle jag nu i sanning ha dödat dig men låtit henne leva.” ");
INSERT INTO swef_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Då sade Bileam till Herrens ängel: ”Jag har syndat, för jag visste inte att det var du som stod mig emot på vägen. Om det jag gör är orätt i dina ögon, så vill jag vända tillbaka.” ");
INSERT INTO swef_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Men Herrens ängel svarade Bileam: ”Följ med männen, men endast de ord jag säger till dig får du tala.” Och Bileam följde med Balaks hövdingar. ");
INSERT INTO swef_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","När Balak hörde att Bileam var på väg, gick han för att möta honom vid den stad i Moab som ligger i Arnondalen och utgör den yttersta gränsen. ");
INSERT INTO swef_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Och Balak sade till Bileam: ”Sände jag inte enträget bud till dig för att kalla hit dig? Varför ville du inte komma till mig? Skulle jag inte kunna visa dig ära?” ");
INSERT INTO swef_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam svarade Balak: ”Se, jag har nu kommit till dig. Men kan jag överhuvudtaget säga något? Vad Gud lägger i min mun, det måste jag säga.” ");
INSERT INTO swef_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Sedan följde Bileam med Balak, och de kom till Kirjat-Husot. ");
INSERT INTO swef_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Där offrade Balak oxar och får och sände av det till Bileam och de hövdingar som var med honom. ");
INSERT INTO swef_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Balak tog nästa morgon Bileam med sig och förde honom upp på Bamot-Baal. Från den platsen kunde han se en del av folket. ");
INSERT INTO swef_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bileam sade till Balak: ”Bygg här sju altaren åt mig och skaffa fram åt mig sju tjurar och sju baggar.” ");
INSERT INTO swef_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak gjorde som Bileam sade, och Balak och Bileam offrade en tjur och en bagge på varje altare. ");
INSERT INTO swef_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Sedan sade Bileam till Balak: ”Stanna kvar vid ditt brännoffer medan jag går i väg. Kanske Herren kommer och möter mig. Vad han än låter mig se ska jag meddela dig.” Och han gick upp på en kal höjd. ");
INSERT INTO swef_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Och Gud mötte Bileam, som sade till honom: ”De sju altarna har jag ställt i ordning, och på varje altare har jag offrat en tjur och en bagge.” ");
INSERT INTO swef_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Då lade Herren ett ord i Bileams mun och sade: ”Gå tillbaka till Balak, och så ska du säga.” ");
INSERT INTO swef_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","När han kom tillbaka till Balak, fann han honom stående vid sitt brännoffer tillsammans med alla Moabs hövdingar. ");
INSERT INTO swef_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Då framförde han detta budskap: ”Balak hämtade mig från Aram, Moabs kung från österns berg. Kom, förbanna åt mig Jakob, kom, fördöm Israel! ");
INSERT INTO swef_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Hur kan jag förbanna den som Gud inte förbannar? Hur kan jag fördöma den som Herren inte fördömer? ");
INSERT INTO swef_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Från klippornas topp ser jag honom, från höjderna skådar jag honom. Se, ett folk som bor avskilt och inte räknar sig bland folken. ");
INSERT INTO swef_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Vem kan räkna Jakobs stoft, räkna fjärdedelen av Israel? Låt mig dö de rättfärdigas död och mitt slut bli som deras!” ");
INSERT INTO swef_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Då sade Balak till Bileam: ”Vad har du gjort mot mig? Jag tog hit dig för att du skulle förbanna mina fiender, men se, du har välsignat dem!” ");
INSERT INTO swef_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Men han svarade: ”Ska jag inte vara noga med att tala det som Herren lägger i min mun?” ");
INSERT INTO swef_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak sade till Bileam: ”Följ med mig till en annan plats där du kan se dem. Du kan därifrån se bara en del av dem, du kan inte se dem alla. Därifrån ska du förbanna dem åt mig.” ");
INSERT INTO swef_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Och han tog honom till Väktarplatsen på toppen av Pisga. Där byggde han sju altaren och offrade en tjur och en bagge på varje altare. ");
INSERT INTO swef_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Sedan sade han till Balak: ”Stanna kvar här vid ditt brännoffer medan jag går för att möta honom där borta.” ");
INSERT INTO swef_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Och Herren mötte Bileam och lade ett ord i hans mun, och han sade: ”Gå tillbaka till Balak, och så ska du säga.” ");
INSERT INTO swef_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","När han kom tillbaka till Balak fann han honom stående vid sitt brännoffer tillsammans med Moabs hövdingar. Balak frågade honom: ”Vad har Herren talat?” ");
INSERT INTO swef_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Då framförde han detta budskap: ”Res dig, Balak, och hör, lyssna till mig, du Sippors son. ");
INSERT INTO swef_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gud är inte en människa, så att han skulle ljuga, inte en människoson, så att han skulle ångra sig. Säger han något utan att göra det, talar han något utan att fullborda det? ");
INSERT INTO swef_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Se, att välsigna är mitt uppdrag. Han har välsignat, och jag kan inte ändra det. ");
INSERT INTO swef_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ingen ofärd kan skådas i Jakob, ingen olycka kan ses i Israel. Herren hans Gud är med honom, en kungs jubel hörs bland dem. ");
INSERT INTO swef_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gud förde dem ut ur Egypten. Hans styrka är som vildoxens. ");
INSERT INTO swef_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ingen trolldom hjälper mot Jakob, ingen spådom mot Israel. När tiden är inne ska det sägas om Jakob och Israel: Vad har inte Gud gjort! ");
INSERT INTO swef_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Se, ett folk reser sig som en lejonhona, stiger upp som ett lejon. Det vilar inte förrän det ätit rov och druckit blod av slagna.” ");
INSERT INTO swef_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Då sade Balak till Bileam: ”Kan du inte förbanna dem, så välsigna dem inte!” ");
INSERT INTO swef_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Men Bileam sade till Balak: ”Har jag inte sagt dig att jag måste göra allt som Herren säger?” ");
INSERT INTO swef_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Sedan sade Balak till Bileam: ”Kom, jag vill ta med dig till en annan plats. Kanske behagar det Gud att du därifrån förbannar dem åt mig.” ");
INSERT INTO swef_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak tog Bileam med sig upp på toppen av Peor, med utsikt över Jeshimon. ");
INSERT INTO swef_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Och Bileam sade till Balak: ”Bygg här sju altaren åt mig, och gör i ordning sju tjurar och sju baggar åt mig.” ");
INSERT INTO swef_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak gjorde som Bileam sade, och han offrade en tjur och en bagge på varje altare. ");
INSERT INTO swef_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","När Bileam såg att det behagade Herren att välsigna Israel, gick han inte som förut bort och såg efter spåtecken, utan vände sig mot öknen. ");
INSERT INTO swef_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Och när Bileam höjde blicken, såg han Israel i sina läger efter sina stammar. Och Guds Ande kom över honom. ");
INSERT INTO swef_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Då framförde han detta budskap: ”Så säger Bileam, Beors son, så säger mannen med det slutna ögat, ");
INSERT INTO swef_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","så säger han som hör Guds ord, han som skådar syner från den Allsmäktige, han som faller ner och får sina ögon öppnade. ");
INSERT INTO swef_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hur sköna är inte dina tält, o Jakob, dina boningar, o Israel! ");
INSERT INTO swef_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Likt dalar utbreder de sig, likt trädgårdar vid en ström, likt aloeträd planterade av Herren, likt cedrar vid vatten. ");
INSERT INTO swef_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Vatten flödar ur hans ämbar, hans sådd blir rikligen vattnad. Större än Agag ska hans kung vara, upphöjt är hans kungadöme. ");
INSERT INTO swef_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gud förde honom ut ur Egypten. Hans styrka är som vildoxens. Han ska sluka hednafolken, hans fiender. Han ska krossa deras ben, med sina pilar genomborra dem. ");
INSERT INTO swef_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Han har lagt sig ner, han vilar som ett lejon, som en lejonhona, vem vågar oroa honom? Välsignad är den som välsignar dig, förbannad är den som förbannar dig!” ");
INSERT INTO swef_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Då upptändes Balaks vrede mot Bileam, och han slog ihop händerna. Han sade till Bileam: ”Jag kallade hit dig för att förbanna mina fiender, men se, du har välsignat dem rikligt tre gånger. ");
INSERT INTO swef_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ge dig nu av hem igen! Jag sade att jag skulle visa dig stor ära, men se, Herren har hindrat att du skulle bli ärad.” ");
INSERT INTO swef_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam svarade Balak: ”Sade jag inte till sändebuden som du skickade till mig: ");
INSERT INTO swef_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Även om Balak skulle ge mig så mycket silver och guld som ryms i hans palats, kan jag ändå inte överträda Herrens befallning av egen vilja i vare sig gott eller ont. Vad Herren säger, det måste jag tala. ");
INSERT INTO swef_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Se, jag går nu hem till mitt folk. Kom, jag vill varna dig för vad detta folk kommer att göra mot ditt folk i kommande dagar.” ");
INSERT INTO swef_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Och han framförde detta budskap: ”Så säger Bileam, Beors son, så säger mannen med det slutna ögat, ");
INSERT INTO swef_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","så säger han som hör Guds ord och har kunskap från den Högste. Han ser syner från den Allsmäktige när han faller ner och får sina ögon öppnade. ");
INSERT INTO swef_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Jag ser honom, men inte nu, jag skådar honom, men inte nära. En stjärna stiger fram ur Jakob, en spira höjer sig ur Israel. Den krossar Moabs tinningar och slår ner alla söner till Set. ");
INSERT INTO swef_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Han ska få till besittning Edom och Seir, sina fiender. Och Israel ska göra mäktiga ting. ");
INSERT INTO swef_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ur Jakob ska en härskare komma, och de överlevande ska han utrota ur staden.” ");
INSERT INTO swef_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Han fick se Amalek. Då framförde han detta budskap: ”Den förste bland hednafolken är Amalek, men slutet för honom blir undergång.” ");
INSERT INTO swef_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Han fick se keniterna. Då framförde han detta budskap: ”Säker är din boning, lagt på klippan är ditt näste. ");
INSERT INTO swef_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Likväl ska Kain skövlas när Assur för dig bort i fångenskap.” ");
INSERT INTO swef_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Och han framförde detta budskap: ”O, vem kan bli vid liv när Gud låter detta ske? ");
INSERT INTO swef_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Skepp ska komma från kitteernas kust, de ska kuva Assur och kuva Eber. Men också de ska drabbas av undergång.” ");
INSERT INTO swef_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Sedan stod Bileam upp och vände tillbaka hem. Också Balak for sin väg. ");
INSERT INTO swef_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Medan Israel uppehöll sig i Shittim, började folket begå otukt med Moabs döttrar. ");
INSERT INTO swef_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Dessa inbjöd folket till sina gudars offermåltider, och folket åt och tillbad deras gudar. ");
INSERT INTO swef_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Och Israel slöt sig till Baal-Peor. Då upptändes Herrens vrede mot Israel. ");
INSERT INTO swef_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Och Herren sade till Mose: ”Hämta folkets alla huvudmän och häng upp dem i solen inför Herren så att Herrens glödande vrede vänds ifrån Israel.” ");
INSERT INTO swef_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Då sade Mose till Israels domare: ”Var och en av er ska bland sina män döda dem som har slutit sig till Baal-Peor.” ");
INSERT INTO swef_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Och se, då kom en man av Israels barn och förde in bland sina bröder en midjanitisk kvinna inför ögonen på Mose och hela Israels församling, medan de stod och grät vid ingången till uppenbarelsetältet. ");
INSERT INTO swef_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","När Pinehas, son till Eleasar, son till prästen Aron, såg det, reste han sig i församlingen och tog ett spjut i handen. ");
INSERT INTO swef_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Han följde efter den israelitiske mannen in i tältet och genomborrade dem båda, den israelitiske mannen och kvinnan genom hennes underliv. Då upphörde hemsökelsen bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Men de som omkom genom hemsökelsen utgjorde 24 000. ");
INSERT INTO swef_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","”Pinehas, son till Eleasar, son till prästen Aron, har vänt bort min vrede från Israels barn genom att han brann av min lidelse bland dem. Därför har jag inte i min lidelse utrotat Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Säg därför: Se, jag sluter med honom ett fridsförbund. ");
INSERT INTO swef_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","För honom och för hans avkomlingar efter honom ska detta vara ett förbund till ett evigt prästämbete, eftersom han brann för sin Gud och bringade försoning för Israels barn.” ");
INSERT INTO swef_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Namnet på den dödade israelitiske mannen, han som dödades tillsammans med den midjanitiska kvinnan, var Simri, Salus son, och han var furste för en familj bland simeoniterna. ");
INSERT INTO swef_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Namnet på den dödade midjanitiska kvinnan var Kosbi, dotter till Sur, som var huvudman för en stamfamilj i Midjan. ");
INSERT INTO swef_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","”Anfall midjaniterna och slå dem, ");
INSERT INTO swef_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","för de har anfallit er genom sitt lömska bedrägeri mot er i saken med Peor och med deras syster Kosbi, den midjanitiska furstedottern som dödades på den dag då hemsökelsen drabbade er för Peors skull.” ");
INSERT INTO swef_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Efter hemsökelsen sade Herren till Mose och till Eleasar, prästen Arons son: ");
INSERT INTO swef_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","”Räkna antalet av Israels barn, hela församlingen, de män som är tjugo år eller äldre, efter deras familjer, alla i Israel som kan göra krigstjänst.” ");
INSERT INTO swef_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mose och prästen Eleasar talade då till dem på Moabs hedar vid Jordan mitt emot Jeriko och sade: ");
INSERT INTO swef_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","”Räkna dem som är tjugo år eller äldre”, enligt vad Herren hade befallt Mose. Dessa var de israeliter som drog ut ur Egyptens land: ");
INSERT INTO swef_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben var Israels förstfödde. Rubens barn var: Av Henok henokiternas släkt, av Pallu palluiternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","av Hesron hesroniternas släkt, av Karmi karmiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dessa var rubeniternas släkter. De mönstrade var 43 730. ");
INSERT INTO swef_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallus söner var Eliab. ");
INSERT INTO swef_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliabs söner var Nemuel, Datan och Abiram. Det var den Datan och den Abiram, båda utvalda från församlingen, som gjorde uppror mot Mose och Aron tillsammans med gruppen kring Kora när dessa gjorde uppror mot Herren. ");
INSERT INTO swef_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Då öppnade jorden sitt gap och slukade dem tillsammans med Kora, och hans grupp omkom genom att elden förtärde de 250 männen, och de blev ett varnande exempel. ");
INSERT INTO swef_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Men Koras söner omkom inte. ");
INSERT INTO swef_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeons barn, efter deras släkter, var: Av Nemuel nemueliternas släkt, av Jamin jaminiternas släkt, av Jakin jakiniternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","av Sera seraiternas släkt, av Saul sauliternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Dessa var simeoniternas släkter, 22 200. ");
INSERT INTO swef_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gads barn, efter deras släkter, var: Av Sefon sefoniternas släkt, av Haggi haggiternas släkt, av Shuni shuniternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","av Osni osniternas släkt, av Eri eriternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","av Arod aroditernas släkt, av Areli areliternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Dessa var Gads barns släkter. De mönstrade var 40 500. ");
INSERT INTO swef_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judas söner var Er och Onan, men Er och Onan dog i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Juda barn, efter deras släkter, var: Av Shela shelaiternas släkt, av Peres peresiternas släkt, av Sera seraiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peres barn var: Av Hesron hesroniternas släkt, av Hamul hamuliternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Dessa var Juda släkter. De mönstrade var 76 500. ");
INSERT INTO swef_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isaskars barn, efter deras släkter, var: Av Tola tolaiternas släkt, av Puva puniternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","av Jashub jashubiternas släkt, av Simron simroniternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Dessa var Isaskars släkter. De mönstrade var 64 300. ");
INSERT INTO swef_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sebulons barn, efter deras släkter, var: Av Sered serediternas släkt, av Elon eloniternas släkt, av Jaleel jaleeliternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Dessa var sebuloniternas släkter. De mönstrade var 60 500. ");
INSERT INTO swef_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Josefs barn, efter deras släkter, var Manasse och Efraim. ");
INSERT INTO swef_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasses barn var: Av Makir makiriternas släkt. Och Makir blev far till Gilead. Av Gilead kom gileaditernas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dessa var Gileads barn: Av Ieser ieseriternas släkt, av Helek helekiternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","av Asriel asrieliternas släkt, av Shekem sikemiternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","av Shemida shemidaiternas släkt, av Hefer heferiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Men Selofhad, Hefers son, hade inga söner utan endast döttrar. Selofhads döttrar hette Mahela, Noa, Hogla, Milka och Tirsa. ");
INSERT INTO swef_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Dessa var Manasses släkter. De mönstrade var 52 700. ");
INSERT INTO swef_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Dessa var Efraims barn, efter deras släkter: Av Shutela shutelaiternas släkt, av Beker bekeriternas släkt, av Tahan tahaniternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutelas barn var: Av Eran eraniternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Dessa var Efraims barns släkter. De mönstrade var 32 500. Dessa var Josefs barn, efter deras släkter. ");
INSERT INTO swef_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjamins barn, efter deras släkter, var: Av Bela belaiternas släkt, av Ashbel ashbeliternas släkt, av Ahiram ahiramiternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","av Shufam shufamiternas släkt, av Hufam hufamiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belas söner var Ard och Naaman: av Ard arditernas släkt, av Naaman naamiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dessa var Benjamins barn, efter deras släkter. De mönstrade var 45 600. ");
INSERT INTO swef_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dessa var Dans barn, efter deras släkter: Av Shuham shuhamiternas släkt. Dessa var Dans släkter efter deras släkter. ");
INSERT INTO swef_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Suhamiternas släkter som mönstrades var 64 400. ");
INSERT INTO swef_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ashers barn, efter deras släkter, var: Av Jimna jimnaiternas släkt, av Jisvi jisviternas släkt, av Beria beriaiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Av Berias barn: Av Heber heberiternas släkt, av Malkiel malkieliternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ashers dotter hette Sera. ");
INSERT INTO swef_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Dessa var Ashers barns släkter. De mönstrade var 53 400. ");
INSERT INTO swef_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naftali barn, efter deras släkter, var: Av Jaseel jaseeliternas släkt, av Guni guniternas släkt, ");
INSERT INTO swef_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","av Jeser jeseriternas släkt, av Shillem shillemiternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Dessa var Naftalis släkter efter deras släkter. De mönstrade var 45 400. ");
INSERT INTO swef_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Dessa var de mönstrade av Israels barn, 601 730. ");
INSERT INTO swef_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","”Åt dessa ska landet utskiftas till arvedel, efter antalet namn. ");
INSERT INTO swef_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Åt en större stam ska du ge en större arvedel och åt en mindre stam en mindre arvedel. Varje stam ska få sin arvedel efter antalet av dem som mönstrats. ");
INSERT INTO swef_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Men landet ska utskiftas genom lottkastning. Efter namnen på sina fädernestammar ska de få sina arvedelar. ");
INSERT INTO swef_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Efter lottens utslag ska varje stam, större eller mindre, få sin arvedel.” ");
INSERT INTO swef_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Dessa var de av Levi stam som mönstrades efter sina släkter: Av Gershon gershoniternas släkt, av Kehat kehatiternas släkt, av Merari merariternas släkt. ");
INSERT INTO swef_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dessa var leviternas släkter: libniternas släkt, hebroniternas släkt, mahliternas släkt, mushiternas släkt, koraiternas släkt. Och Kehat var far till Amram. ");
INSERT INTO swef_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amrams hustru hette Jokebed, Levis dotter, som föddes åt Levi i Egypten. Hon födde åt Amram: Aron, Mose och deras syster Mirjam. ");
INSERT INTO swef_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Åt Aron föddes Nadab och Abihu, Eleasar och Itamar. ");
INSERT INTO swef_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Men Nadab och Abihu dog när de bar fram främmande eld inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","De mönstrade var 23 000, alla av manligt kön som var en månad gamla eller äldre. De hade inte blivit mönstrade bland Israels barn, eftersom de inte hade fått någon arvedel bland Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Dessa var de som mönstrades av Mose och prästen Eleasar, när de mönstrade Israels barn på Moabs hedar vid Jordan mitt emot Jeriko. ");
INSERT INTO swef_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Bland dessa fanns ingen av dem som förut hade mönstrats av Mose och prästen Aron när de mönstrade Israels barn i Sinai öken, ");
INSERT INTO swef_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","för om dem hade Herren sagt: ”De ska dö i öknen.” Ingen fanns kvar av dem förutom Kaleb, Jefunnes son, och Josua, Nuns son. ");
INSERT INTO swef_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Döttrarna till Selofhad trädde fram. Selofhad var son till Hefer, son till Gilead, son till Makir, son till Manasse, av Manasses, Josefs sons, släkter. Döttrarna hette Mahla, Noa, Hogla, Milka och Tirsa. ");
INSERT INTO swef_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","De stod inför Mose och prästen Eleasar, furstarna och hela församlingen vid ingången till uppenbarelsetältet och sade: ");
INSERT INTO swef_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","”Vår far dog i öknen, men han tillhörde inte Koras grupp som gaddade ihop sig mot Herren. Han dog genom egen synd, och han hade inga söner. ");
INSERT INTO swef_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Varför skulle vår fars namn försvinna ur hans släkt bara för att han inte hade någon son? Ge oss nu en besittning bland vår fars bröder.” ");
INSERT INTO swef_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mose bar fram deras sak inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Och Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","”Selofhads döttrar har rätt i vad de säger. Du ska ge dem en arvsbesittning bland deras fars bröder genom att låta deras fars arvedel gå över till dem. ");
INSERT INTO swef_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Du ska säga till Israels barn: Om en man dör och han inte efterlämnar någon son, ska ni låta hans arvedel gå över till hans dotter. ");
INSERT INTO swef_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Men om han inte har någon dotter, ska ni ge hans arvedel åt hans bröder. ");
INSERT INTO swef_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Har han inte några bröder, ska ni ge hans arvedel åt hans fars bröder. ");
INSERT INTO swef_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Men om hans far inte har några bröder, ska ni ge hans arvedel åt närmaste släkting som då ska ta den i besittning. Detta ska vara en laglig rätt för Israels barn, så som Herren har befallt Mose.” ");
INSERT INTO swef_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Herren sade till Mose: ”Stig upp på Abarimberget och se det land som jag har gett åt Israels barn. ");
INSERT INTO swef_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Men när du har sett det ska också du samlas till ditt folk, liksom din bror Aron, ");
INSERT INTO swef_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","för ni var upproriska mot mitt ord i öknen Zin när församlingen tvistade med mig. Ni höll mig inte helig inför deras ögon vid vattnet, Meribas vatten vid Kadesh i öknen Zin.” ");
INSERT INTO swef_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose talade till Herren. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","”Må Herren, den Gud som råder över anden i allt kött, sätta en man över församlingen ");
INSERT INTO swef_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","som kan gå i spetsen för dem när de drar ut och kommer tillbaka, och som kan vara deras ledare och anförare så att Herrens församling inte blir som får utan herde.” ");
INSERT INTO swef_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Herren svarade Mose: ”Ta Josua, Nuns son, en man som har Anden, och lägg din hand på honom. ");
INSERT INTO swef_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Du ska ställa honom inför prästen Eleasar och hela församlingen och insätta honom i hans tjänst inför deras ögon. ");
INSERT INTO swef_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ge honom något av din auktoritet så att hela Israels församling lyder honom. ");
INSERT INTO swef_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Han ska stå inför prästen Eleasar, som genom urims dom ska hämta svar åt honom inför Herrens ansikte. Efter hans ord ska de dra ut och efter hans ord komma tillbaka, han själv och alla Israels barn med honom, hela församlingen.” ");
INSERT INTO swef_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose gjorde som Herren hade befallt honom. Han tog Josua och förde fram honom inför prästen Eleasar och hela församlingen. ");
INSERT INTO swef_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Och Eleasar lade sina händer på honom och insatte honom i hans tjänst, så som Herren hade sagt genom Mose. ");
INSERT INTO swef_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","”Befall Israels barn och säg till dem: Var noga med att ni på bestämd tid bär fram mina offer, min mat av mina eldsoffer, till en ljuvlig doft för mig. ");
INSERT INTO swef_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Och säg till dem: Detta är vad ni ska offra åt Herren som eldsoffer: två felfria årsgamla lamm som ständigt återkommande brännoffer varje dag. ");
INSERT INTO swef_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Det ena lammet ska du offra på morgonen, och det andra lammet ska du offra i skymningen. ");
INSERT INTO swef_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Och som matoffer ska du offra en tiondels efa fint mjöl, blandat med en fjärdedels hin olja av stötta oliver. ");
INSERT INTO swef_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Detta är det dagliga brännoffret som offrades på Sinai berg till en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Som dryckesoffer till det ska du offra en fjärdedels hin för varje lamm. I helgedomen ska dryckesoffer av stark dryck utgjutas åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Det andra lammet ska du offra i skymningen. Med likadant matoffer och dryckesoffer som på morgonen ska du offra det, ett eldsoffer till en ljuvlig doft för Herren. ");
INSERT INTO swef_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","På sabbatsdagen ska du offra två felfria årsgamla lamm och två tiondels efa fint mjöl blandat med olja som matoffer, med tillhörande dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Detta är sabbatsbrännoffret, som ska offras varje sabbat utöver det dagliga brännoffret, med tillhörande dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","På era nymånadsdagar ska ni som brännoffer åt Herren offra två ungtjurar, en bagge och sju felfria årsgamla lamm ");
INSERT INTO swef_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","samt tre tiondels efa fint mjöl blandat med olja som matoffer till varje tjur, och två tiondels efa fint mjöl blandat med olja som matoffer till baggen, ");
INSERT INTO swef_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","och en tiondels efa fint mjöl blandat med olja som matoffer till varje lamm. Detta är ett brännoffer till en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","De tillhörande dryckesoffren ska vara en halv hin vin till varje tjur, en tredjedels hin till baggen och en fjärdedels hin till varje lamm. Detta är nymånadsbrännoffret som ska offras i var och en av årets månader. ");
INSERT INTO swef_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Dessutom ska ni offra en bock till syndoffer åt Herren. Den ska offras tillsammans med det dagliga brännoffret, med tillhörande dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","I första månaden, på fjortonde dagen i månaden, är Herrens påsk. ");
INSERT INTO swef_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","På femtonde dagen i samma månad är högtid. Då ska man äta osyrat bröd i sju dagar. ");
INSERT INTO swef_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","På den första dagen ska man hålla en helig sammankomst. Då ska inget arbete utföras. ");
INSERT INTO swef_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Och som eldsoffer, som brännoffer åt Herren, ska ni offra: två ungtjurar, en bagge och sju årsgamla lamm, som ska vara felfria. ");
INSERT INTO swef_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Som matoffer till det ska ni offra fint mjöl blandat med olja. Tre tiondels efa ska ni offra till varje ungtjur, två tiondels efa till baggen, ");
INSERT INTO swef_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","och en tiondels efa ska du offra till vart och ett av de sju lammen. ");
INSERT INTO swef_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Dessutom ska ni offra en syndofferbock som ska bringa försoning för er. ");
INSERT INTO swef_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Detta ska ni offra förutom morgonens brännoffer, som utgör det dagliga brännoffret. ");
INSERT INTO swef_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Likadana offer ska ni offra varje dag i sju dagar, matoffer och eldsoffer till en ljuvlig doft för Herren. Tillsammans med det dagliga brännoffret ska detta offras med tillhörande dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","På den sjunde dagen ska ni hålla en helig sammankomst. Då ska inget arbete utföras. ");
INSERT INTO swef_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","På den dag då förstlingsskörden bärgas, då ni vid er veckohögtid bär fram ett offer åt Herren av den nya grödan, ska ni hålla en helig sammankomst. Då ska inget arbete utföras. ");
INSERT INTO swef_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Som brännoffer till en ljuvlig doft för Herren ska ni då offra två ungtjurar, en bagge och sju årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","och som matoffer till det fint mjöl blandat med olja: tre tiondels efa till varje tjur, två tiondels efa till baggen, ");
INSERT INTO swef_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","och en tiondels efa till vart och ett av de sju lammen. ");
INSERT INTO swef_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Dessutom ska ni offra en bock som ska bringa försoning för er. ");
INSERT INTO swef_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Förutom det dagliga brännoffret med tillhörande matoffer ska ni offra detta, med tillhörande dryckesoffer. Djuren ska vara felfria. ");
INSERT INTO swef_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","I sjunde månaden, på första dagen i månaden, ska ni hålla en helig sammankomst. Då ska inget arbete utföras. Den ska för er vara en dag med basunklang. ");
INSERT INTO swef_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Som brännoffer till en ljuvlig doft för Herren ska ni offra en ungtjur, en bagge, sju felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","och som matoffer till det fint mjöl blandat med olja: tre tiondels efa till tjuren, två tiondels efa till baggen, ");
INSERT INTO swef_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","och en tiondels efa till vart och ett av de sju lammen. ");
INSERT INTO swef_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Dessutom ska ni offra en bock som syndoffer som ska bringa försoning för er, ");
INSERT INTO swef_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","förutom nymånadsbrännoffret med tillhörande matoffer, det dagliga brännoffret med tillhörande matoffer och dryckesoffren i enlighet med föreskrifterna för dem, allt till en ljuvlig doft, ett eldsoffer åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","På tionde dagen i samma sjunde månad ska ni hålla en helig sammankomst. Ni ska då fasta och inte utföra något arbete. ");
INSERT INTO swef_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Som brännoffer till en ljuvlig doft för Herren ska ni offra en ungtjur, en bagge, sju felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","och som matoffer till det fint mjöl blandat med olja: tre tiondels efa till tjuren, två tiondels efa till baggen, ");
INSERT INTO swef_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","och en tiondels efa till vart och ett av de sju lammen. ");
INSERT INTO swef_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Dessutom ska ni offra en bock som syndoffer, utöver försoningssyndoffret och det dagliga brännoffret med tillhörande matoffer och deras dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","På femtonde dagen i sjunde månaden ska ni hålla en helig sammankomst. Då ska inget arbete utföras, utan ni ska fira en Herrens högtid i sju dagar. ");
INSERT INTO swef_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Och som brännoffer, som eldsoffer, ska ni då till en ljuvlig doft för Herren offra tretton ungtjurar, två baggar, fjorton felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","och som matoffer till det fint mjöl blandat med olja: tre tiondels efa till var och en av de tretton tjurarna, två tiondels efa till var och en av de två baggarna, ");
INSERT INTO swef_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","och en tiondels efa till vart och ett av de fjorton lammen. ");
INSERT INTO swef_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Dessutom ska ni offra en bock till syndoffer, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","På andra dagen ska ni offra tolv ungtjurar, två baggar och fjorton felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Dessutom ska ni offra en bock som syndoffer, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","På tredje dagen ska ni offra elva tjurar, två baggar, fjorton felfria årsgamla lamm ");
INSERT INTO swef_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Dessutom ska ni offra en bock som syndoffer, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","På fjärde dagen ska ni offra tio tjurar, två baggar och fjorton felfria årsgamla lamm ");
INSERT INTO swef_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Dessutom ska ni offra en bock som syndoffer, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","På femte dagen ska ni offra nio tjurar, två baggar och fjorton felfria årsgamla lamm ");
INSERT INTO swef_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Dessutom ska ni offra en syndofferbock, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","På sjätte dagen ska ni offra åtta tjurar, två baggar och fjorton felfria årsgamla lamm ");
INSERT INTO swef_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Dessutom ska ni offra en syndofferbock, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","På sjunde dagen ska ni offra sju tjurar, två baggar och fjorton felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjurarna, baggarna och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Dessutom ska ni offra en syndofferbock, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","På åttonde dagen ska ni hålla en högtidssamling. Då ska inget arbete utföras. ");
INSERT INTO swef_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Som brännoffer, som eldsoffer, ska ni då offra till en ljuvlig doft för Herren en tjur, en bagge, sju felfria årsgamla lamm, ");
INSERT INTO swef_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","med det matoffer och dryckesoffer som ska offras tillsammans med dem, med tjuren, baggen och lammen efter deras antal på föreskrivet sätt. ");
INSERT INTO swef_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Dessutom ska ni offra en syndofferbock, utöver det dagliga brännoffret med tillhörande matoffer och dryckesoffer. ");
INSERT INTO swef_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Detta ska ni offra åt Herren vid era högtider förutom era löftesoffer och frivilliga offer, vare sig det är brännoffer, matoffer, dryckesoffer eller gemenskapsoffer.” ");
INSERT INTO swef_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose sade detta till Israels barn, precis som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mose talade till huvudmännen för Israels barns stammar. Han sade: ”Detta är vad Herren har befallt: ");
INSERT INTO swef_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Om en man ger ett löfte åt Herren eller svär en ed med en bestämd förpliktelse, får han inte bryta sitt ord. Han ska i allt göra vad hans mun har talat. ");
INSERT INTO swef_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Om en kvinna ger ett löfte åt Herren medan hon bor kvar i sin fars hus och ännu är ung, och därmed förpliktar sig till något, ");
INSERT INTO swef_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","och hennes far har hört hennes löfte och den förpliktelse hon åtagit sig och han inte säger något till henne, så ska alla hennes löften ha gällande kraft och alla förpliktelser hon åtagit sig stå kvar. ");
INSERT INTO swef_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Men om hennes far samma dag han hör det säger nej till det, ska hennes löften och förpliktelser vara utan gällande kraft, och Herren ska förlåta henne eftersom hennes far sade nej till henne. ");
INSERT INTO swef_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Om hon gifter sig, och löften vilar på henne, eller något obetänksamt ord från hennes läppar binder henne, ");
INSERT INTO swef_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","och hennes man får höra om det men inte talar med henne om det samma dag han hör det, då ska hennes löften ha gällande kraft och hennes förpliktelser stå kvar. ");
INSERT INTO swef_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Men om hennes man samma dag han får höra det säger nej till det, då upphäver han hennes löfte och det obetänksamma ord från hennes läppar som hon bundit sig med, och Herren ska förlåta henne. ");
INSERT INTO swef_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Men ett löfte från en änka eller en frånskild kvinna ska ha gällande kraft för henne, vad hon än har förbundit sig till. ");
INSERT INTO swef_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Om en kvinna som lever med sin man ger ett löfte eller med ed förpliktar sig till något, ");
INSERT INTO swef_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","och hennes man hör det men inte säger något till henne om det och inte säger nej till henne, då ska alla hennes löften ha gällande kraft och alla hennes förpliktelser stå kvar. ");
INSERT INTO swef_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Men om hennes man upphäver dem samma dag han hör dem, då ska allt som hennes läppar har talat vara utan gällande kraft, om det än gäller löften eller någon bestämd förpliktelse. Hennes man har upphävt dem, därför ska Herren förlåta henne. ");
INSERT INTO swef_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Varje löfte och varje edlig förpliktelse att fasta kan hennes man stadfästa eller upphäva. ");
INSERT INTO swef_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Men om hennes man inte den dagen eller nästa dag säger något till henne om det, stadfäster han alla hennes löften och alla hennes förpliktelser. Han ger dem gällande kraft genom att inte säga något till henne samma dag han hör dem. ");
INSERT INTO swef_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Men om han upphäver dem en tid efter det att han har hört dem, då kommer han att bära på hennes missgärning.” ");
INSERT INTO swef_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Detta är de stadgar som Herren gav Mose angående en man och hans hustru, och angående en far och hans dotter, medan hon ännu är ung och bor i sin fars hus. ");
INSERT INTO swef_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","”Ta hämnd på midjaniterna för Israels barn. Därefter ska du samlas till ditt folk.” ");
INSERT INTO swef_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Och Mose sade till folket: ”Låt några av era män beväpna sig till strid. De ska rycka ut mot Midjan och utföra Herrens hämnd på Midjan. ");
INSERT INTO swef_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Tusen man från var och en av Israels alla stammar ska ni sända ut i striden.” ");
INSERT INTO swef_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Då avskiljdes ur Israels ätter tusen man av varje stam, tolvtusen man beväpnade till strid. ");
INSERT INTO swef_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Dessa sände Mose ut i striden, tusen man ur varje stam, tillsammans med Pinehas, prästen Eleasars son, som tog de heliga föremålen och larmtrumpeterna i sin hand. ");
INSERT INTO swef_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","De gick i krig mot Midjan, så som Herren hade befallt Mose, och de dödade alla av manligt kön. ");
INSERT INTO swef_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Tillsammans med andra som blev slagna av dem dödades också de midjanitiska kungarna Evi, Rekem, Sur, Hur och Reba, fem midjanitiska kungar. Också Bileam, Beors son, dödade de med svärd. ");
INSERT INTO swef_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israels barn förde bort Midjans kvinnor och barn som fångar, och alla deras dragdjur, all deras boskap och allt deras gods tog de som byte. ");
INSERT INTO swef_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Alla deras städer där de bodde och alla deras tältläger brände de upp i eld. ");
INSERT INTO swef_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","De tog med sig allt bytet och allt de hade rövat, både människor och boskap, ");
INSERT INTO swef_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","och förde fångarna och det rövade och bytet till Mose och prästen Eleasar och till Israels barns församling i lägret på Moabs hedar, vid Jordan mitt emot Jeriko. ");
INSERT INTO swef_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose och prästen Eleasar och församlingens alla furstar gick för att möta dem utanför lägret. ");
INSERT INTO swef_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Men Mose blev upprörd över krigsbefälet, både överbefälen och underbefälen, när de kom tillbaka från kriget. ");
INSERT INTO swef_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mose sade till dem: ”Lät ni alla kvinnor leva? ");
INSERT INTO swef_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Det var ju de som efter Bileams råd förledde Israels barn till otrohet mot Herren i saken med Peor, så att hemsökelsen drabbade Herrens församling. ");
INSERT INTO swef_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Döda nu alla pojkar, och döda alla kvinnor som har legat med en man. ");
INSERT INTO swef_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Men alla flickor som inte har legat med en man ska ni låta leva och spara åt er själva. ");
INSERT INTO swef_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Och ni ska vara utanför lägret i sju dagar. Var och en som har dödat någon människa, och var och en som har rört vid någon slagen ska rena sig på tredje dagen och på sjunde dagen. Det gäller er själva och era fångar. ");
INSERT INTO swef_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ni ska rena alla kläder, allt som är tillverkat av skinn, allt som är gjort av gethår och alla föremål av trä.” ");
INSERT INTO swef_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Prästen Eleasar sade till de stridsmän som hade deltagit i kriget: ”Detta är den lagstadga som Herren har befallt Mose: ");
INSERT INTO swef_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Guld och silver, koppar, järn, tenn och bly, ");
INSERT INTO swef_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","allt som tål eld ska ni låta gå genom eld så att det blir rent. Men det ska också renas med reningsvatten. Och allt som inte tål eld ska ni låta gå genom vatten. ");
INSERT INTO swef_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","På sjunde dagen ska ni tvätta era kläder och så vara rena. Därefter får ni gå in i lägret.” ");
INSERT INTO swef_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Herren sade till Mose: ");
INSERT INTO swef_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","”Tillsammans med prästen Eleasar och huvudmännen för församlingen ska du göra en beräkning över det tagna bytet av människor och boskap. ");
INSERT INTO swef_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Sedan ska du dela bytet i två delar mellan de krigare som deltagit i striden och hela församlingen. ");
INSERT INTO swef_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Som skatt åt Herren ska du ta från det krigsfolk som har varit med i striden: en av var femhundrade av människor, kor, åsnor och får. ");
INSERT INTO swef_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ta detta av deras hälft och ge det åt prästen Eleasar som en offergåva åt Herren. ");
INSERT INTO swef_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Och från Israels barns hälft ska du ta var femtionde av människor, kor, åsnor, får och all boskap och ge det till leviterna, som ska ha vården om Herrens tabernakel.” ");
INSERT INTO swef_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mose och prästen Eleasar gjorde som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Och bytet, resten av det som krigsfolket hade tagit, utgjorde: av får 675 000, ");
INSERT INTO swef_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","av kor 72 000, ");
INSERT INTO swef_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","av åsnor 61 000 ");
INSERT INTO swef_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","och av människor, kvinnor som inte legat med någon man, tillsammans 32 000. ");
INSERT INTO swef_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Hälften av bytet, den del som tillföll dem som deltagit i striden, utgjorde: av får 337 500, ");
INSERT INTO swef_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","varav skatten åt Herren utgjorde 675 får, ");
INSERT INTO swef_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","av kor 36 000, varav skatten åt Herren utgjorde 72, ");
INSERT INTO swef_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","av åsnor 30 500, varav skatten åt Herren utgjorde 61, ");
INSERT INTO swef_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","av människor 16 000, varav skatten åt Herren utgjorde 32 personer. ");
INSERT INTO swef_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Och skatten, den för Herren bestämda gåvan, gav Mose åt prästen Eleasar, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Den hälft som tillföll Israels barn och som Mose hade avskilt från krigsfolkets del, ");
INSERT INTO swef_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","den hälft som tillföll församlingen, utgjorde: av får 337 500, ");
INSERT INTO swef_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","av kor 36 000, ");
INSERT INTO swef_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","av åsnor 30 500 ");
INSERT INTO swef_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","och av människor 16 000. ");
INSERT INTO swef_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ur den hälft som tillföll israeliterna tog Mose ut var femtionde, både av människor och boskap, och gav det till leviterna som hade ansvar för Herrens tabernakel, så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Befälhavarna över härens avdelningar, både överbefälen och underbefälen, kom fram till Mose ");
INSERT INTO swef_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","och sade till honom: ”Dina tjänare har räknat antalet krigsmän som vi har haft under vårt befäl, och ingen man fattas bland oss. ");
INSERT INTO swef_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Därför har nu var och en av oss som en offergåva åt Herren burit fram det som han kommit över av guldsmycken – armband, ringar, örhängen och halssmycken – för att bringa försoning för oss inför Herrens ansikte.” ");
INSERT INTO swef_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mose och prästen Eleasar tog emot guldet från dem, alla slags klenoder. ");
INSERT INTO swef_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Guldet som gavs som gåva åt Herren av överbefälen och underbefälen utgjorde sammanlagt 16 750 siklar. ");
INSERT INTO swef_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Krigsfolket hade tagit byte, var och en för sig. ");
INSERT INTO swef_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Och Mose och prästen Eleasar tog emot guldet från överbefälen och underbefälen och bar in det i uppenbarelsetältet, för att det skulle bringa Israels barn i åminnelse inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubens barn och Gads barn hade stora och mycket talrika boskapshjordar. När de såg Jaesers land och Gileads land fann de att det var en god trakt för boskap. ");
INSERT INTO swef_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Gads barn och Rubens barn kom då till Mose och prästen Eleasar och församlingens furstar och sade: ");
INSERT INTO swef_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","”Atarot, Dibon, Jaeser, Nimra, Heshbon, Eleale, Sebam, Nebo och Beon, ");
INSERT INTO swef_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","det land som Herren har vunnit åt Israels församling, är ett land för boskap, och dina tjänare har boskap.” ");
INSERT INTO swef_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","De sade vidare: ”Om vi har funnit nåd inför dina ögon, så ge detta land till dina tjänare som besittning. Låt oss slippa gå över Jordan.” ");
INSERT INTO swef_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Men Mose sade till Gads barn och Rubens barn: ”Ska ni stanna här medan era bröder drar ut i krig? ");
INSERT INTO swef_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Varför vill ni göra Israels barn modlösa så att de inte vill gå över floden in i det land som Herren har gett dem? ");
INSERT INTO swef_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Så gjorde också era fäder när jag sände dem från Kadesh-Barnea för att bese landet. ");
INSERT INTO swef_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","När de hade dragit upp till Druvdalen och sett landet, gjorde de Israels barn modlösa så att de inte ville gå in i det land som Herren hade gett dem. ");
INSERT INTO swef_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Herrens vrede blossade upp den dagen, och han svor denna ed: ");
INSERT INTO swef_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Av de män som drog upp ur Egypten ska ingen som är tjugo år eller äldre få se det land som jag med ed har lovat Abraham, Isak och Jakob, eftersom de inte i allt har följt mig, ");
INSERT INTO swef_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ingen utom Kaleb, kenisiten Jefunnes son, och Josua, Nuns son, för de har i allt följt Herren. ");
INSERT INTO swef_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Så brann Herrens vrede mot Israel, och han lät dem irra omkring i öknen i fyrtio år tills hela släktet var borta som hade gjort det som var ont i Herrens ögon. ");
INSERT INTO swef_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Och se, ni har trätt i era fäders ställe, ni syndiga mäns avkomma, och ökar än mer Herrens glödande vrede mot Israel! ");
INSERT INTO swef_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Om ni vänder er bort ifrån honom, kommer han att låta dem bli kvar i öknen ännu längre och ni drar fördärv över hela detta folk.” ");
INSERT INTO swef_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Då kom de fram till Mose och sade: ”Låt oss här bygga inhägnader åt vår boskap och städer åt våra barn. ");
INSERT INTO swef_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Själva ska vi genast beväpna oss och dra ut i spetsen för Israels barn tills vi har fört dem till deras plats. Under tiden kan våra barn bo i de befästa städerna, trygga från landets invånare. ");
INSERT INTO swef_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Vi ska inte återvända hem förrän Israels barn har fått var och en sin arvedel. ");
INSERT INTO swef_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Vi vill nämligen inte ha vår arvedel med dem, på andra sidan Jordan och längre bort, utan vår arvedel har tillfallit oss här på denna sida av Jordan, på östra sidan.” ");
INSERT INTO swef_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mose svarade dem: ”Om ni gör detta, om ni beväpnar er inför Herren till kriget ");
INSERT INTO swef_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","så att alla era beväpnade män går över Jordan inför Herren, tills han har fördrivit sina fiender inför sig ");
INSERT INTO swef_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","och landet blivit underkuvat inför Herren, då kan ni sedan vända tillbaka och vara utan skuld mot Herren och mot Israel. Detta land ska då bli er besittning inför Herrens ansikte. ");
INSERT INTO swef_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Men om ni inte gör detta, se, då syndar ni mot Herren, och ni ska veta att er synd ska drabba er. ");
INSERT INTO swef_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bygg städer åt era barn och inhägnader åt er boskap och gör som ni har sagt.” ");
INSERT INTO swef_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gads barn och Rubens barn sade till Mose: ”Dina tjänare ska göra så som min herre befaller. ");
INSERT INTO swef_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Våra barn, våra hustrur, vår boskap och alla våra dragdjur ska bli kvar här i Gileads städer. ");
INSERT INTO swef_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Men dina tjänare, alla som är beväpnade för krig, ska dra över dit och strida inför Herrens ansikte så som min herre har sagt.” ");
INSERT INTO swef_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Mose gav då befallning om dem åt prästen Eleasar och åt Josua, Nuns son, och åt huvudmännen för familjerna inom Israels barns stammar. ");
INSERT INTO swef_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mose sade till dem: ”Om Gads barn och Rubens barn går över Jordan med er, alla de som är beväpnade till strid inför Herrens ansikte, och landet blir kuvat inför er, då ska ni ge dem landet Gilead till besittning. ");
INSERT INTO swef_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Men om de inte drar beväpnade över med er, ska de få sin besittning bland er i Kanaans land.” ");
INSERT INTO swef_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gads barn och Rubens barn svarade: ”Vad Herren har sagt till dina tjänare, det vill vi göra. ");
INSERT INTO swef_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Inför Herrens ansikte ska vi beväpnade dra över till Kanaans land men få vår arvsbesittning här på denna sidan Jordan.” ");
INSERT INTO swef_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mose gav åt dem, åt Gads barn och Rubens barn och ena hälften av Manasse, Josefs sons, stam: amoreernas kung Sichons rike, och Bashans kung Ogs rike. Han gav dem landet med städer och områdena kring städerna. ");
INSERT INTO swef_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gads barn byggde upp Dibon, Atarot, Aroer, ");
INSERT INTO swef_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Shofan, Jaeser, Jogbeha, ");
INSERT INTO swef_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra och Bet-Haran, befästa städer med inhägnader för boskap. ");
INSERT INTO swef_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubens barn byggde upp Heshbon, Eleale, Kirjatajim, ");
INSERT INTO swef_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo och Baal-Meon, vilkas namn har ändrats, och Sibma. Och de gav namn åt städerna som de byggde upp. ");
INSERT INTO swef_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Makirs, Manasses sons, barn drog bort till Gilead och intog det och fördrev amoreerna som bodde där. ");
INSERT INTO swef_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mose gav Gilead åt Makir, Manasses son, och han bosatte sig där. ");
INSERT INTO swef_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Och Jair, Manasses son, drog ut och intog deras byar och kallade dem Jairs byar. ");
INSERT INTO swef_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba drog ut och intog Kenat med dess underlydande orter och kallade det Noba efter sitt eget namn. ");
INSERT INTO swef_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Detta är Israels barns lägerplatser, när de med sina härskaror drog ut ur Egyptens land, under ledning av Mose och Aron. ");
INSERT INTO swef_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","På Herrens befallning upptecknade Mose de platser som de på sina vandringar bröt upp från. Detta var deras vandringar, efter de platser som de bröt upp från: ");
INSERT INTO swef_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","De bröt upp från Raamses i första månaden, på femtonde dagen i första månaden. Dagen efter påskhögtiden drog Israels barn orädda ut inför ögonen på alla egyptier, ");
INSERT INTO swef_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","medan egyptierna begravde alla de förstfödda som Herren hade slagit bland dem när Herren höll dom över deras gudar. ");
INSERT INTO swef_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Israels barn bröt upp från Raamses och slog läger i Suckot. ");
INSERT INTO swef_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","De bröt upp från Suckot och slog läger i Etam, där öknen börjar. ");
INSERT INTO swef_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","De bröt upp från Etam och vände tillbaka till Pi-Hahirot som ligger mitt emot Baal-Sefon, och slog läger framför Migdol. ");
INSERT INTO swef_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","De bröt upp från Hahirot och gick rakt genom havet in i öknen och vandrade tre dagsresor i Etams öken, och slog läger i Mara. ");
INSERT INTO swef_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","De bröt upp från Mara och kom till Elim. I Elim fanns tolv vattenkällor och sjuttio palmträd, och de slog läger där. ");
INSERT INTO swef_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","De bröt upp från Elim och slog läger vid Röda havet. ");
INSERT INTO swef_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","De bröt upp från Röda havet och slog läger i öknen Sin. ");
INSERT INTO swef_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","De bröt upp från öknen Sin och slog läger i Dofka. ");
INSERT INTO swef_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","De bröt upp från Dofka och slog läger i Alush. ");
INSERT INTO swef_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","De bröt upp från Alush och slog läger i Refidim, där det inte fanns vatten för folket att dricka. ");
INSERT INTO swef_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","De bröt upp från Refidim och slog läger i Sinai öken. ");
INSERT INTO swef_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","De bröt upp från Sinai öken och slog läger i Kibrot-Hattaava. ");
INSERT INTO swef_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","De bröt upp från Kibrot-Hattaava och slog läger i Haserot. ");
INSERT INTO swef_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","De bröt upp från Haserot och slog läger i Ritma. ");
INSERT INTO swef_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","De bröt upp från Ritma och slog läger i Rimmon-Peres. ");
INSERT INTO swef_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","De bröt upp från Rimmon-Peres och slog läger i Libna. ");
INSERT INTO swef_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","De bröt upp från Libna och slog läger i Rissa. ");
INSERT INTO swef_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","De bröt upp från Rissa och slog läger i Kehelata. ");
INSERT INTO swef_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","De bröt upp från Kehelata och slog läger vid berget Shefer. ");
INSERT INTO swef_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","De bröt upp från berget Shefer och slog läger i Harada. ");
INSERT INTO swef_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","De bröt upp från Harada och slog läger i Makhelot. ");
INSERT INTO swef_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","De bröt upp från Makhelot och slog läger i Tahat. ");
INSERT INTO swef_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","De bröt upp från Tahat och slog läger i Tera. ");
INSERT INTO swef_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","De bröt upp från Tera och slog läger i Mitka. ");
INSERT INTO swef_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","De bröt upp från Mitka och slog läger i Hashmona. ");
INSERT INTO swef_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","De bröt upp från Hashmona och slog läger i Moserot. ");
INSERT INTO swef_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","De bröt upp från Moserot och slog läger i Bene-Jaakan. ");
INSERT INTO swef_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","De bröt upp från Bene-Jaakan och slog läger i Hor-Haggidgad. ");
INSERT INTO swef_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","De bröt upp från Hor-Haggidgad och slog läger i Jotbata. ");
INSERT INTO swef_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","De bröt upp från Jotbata och slog läger i Abrona. ");
INSERT INTO swef_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","De bröt upp från Abrona och slog läger i Esjon-Geber. ");
INSERT INTO swef_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","De bröt upp från Esjon-Geber och slog läger i öknen Zin, det vill säga Kadesh. ");
INSERT INTO swef_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","De bröt upp från Kadesh och slog läger vid berget Hor på gränsen till Edoms land. ");
INSERT INTO swef_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","På Herrens befallning steg prästen Aron upp på berget Hor och dog där i det fyrtionde året efter Israels barns uttåg ur Egyptens land, i femte månaden, på första dagen i månaden. ");
INSERT INTO swef_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aron var hundratjugotre år gammal när han dog på berget Hor. ");
INSERT INTO swef_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Den kananeiske kungen av Arad, som bodde i Negev i Kanaans land, fick nu höra att Israels barn var på väg. ");
INSERT INTO swef_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","De bröt upp från berget Hor och slog läger i Salmona. ");
INSERT INTO swef_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","De bröt upp från Salmona och slog läger i Punon. ");
INSERT INTO swef_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","De bröt upp från Punon och slog läger i Obot. ");
INSERT INTO swef_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","De bröt upp från Obot och slog läger i Ije-Haabarim vid Moabs gräns. ");
INSERT INTO swef_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","De bröt upp från Ijim och slog läger i Dibon-Gad. ");
INSERT INTO swef_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","De bröt upp från Dibon-Gad och slog läger i Almon-Diblatajma. ");
INSERT INTO swef_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","De bröt upp från Almon-Diblatajma och slog läger vid Abarimbergen framför Nebo. ");
INSERT INTO swef_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","De bröt upp från Abarimbergen och slog läger på Moabs hedar vid Jordan mitt emot Jeriko. ");
INSERT INTO swef_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Deras läger vid Jordan sträckte sig från Bet-Hajesimot ända till Abel-Hashittim på Moabs hedar. ");
INSERT INTO swef_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Herren talade till Mose på Moabs hedar vid Jordan mitt emot Jeriko och sade: ");
INSERT INTO swef_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","”Säg till Israels barn: När ni har gått över Jordan in i Kanaans land, ");
INSERT INTO swef_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ska ni driva bort landets alla invånare för er och förstöra alla deras bildstoder. Alla deras gjutna avgudabilder ska ni förstöra och alla deras offerhöjder ska ni ödelägga. ");
INSERT INTO swef_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ni ska erövra landet och bosätta er där, för jag har gett er landet till besittning. ");
INSERT INTO swef_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ni ska utskifta landet åt er som arvedel genom lottkastning efter era släkter. Åt en större stam ska ni ge en större arvedel och åt en mindre stam en mindre arvedel. Var och en ska få sin del efter vad lotten bestämmer. Efter era fädernestammar ska ni utskifta landet mellan er. ");
INSERT INTO swef_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Men om ni inte driver bort landets invånare för er, då ska de som ni låter vara kvar bli törnen i era ögon och taggar i era sidor, och de ska tränga er i landet där ni bor. ");
INSERT INTO swef_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Och då ska jag göra med er så som jag hade tänkt göra med dem.” ");
INSERT INTO swef_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","”Befall Israels barn och säg till dem: När ni kommer till Kanaans land, då är detta det land som ska tillfalla er som arvedel: Kanaans land, så långt dess gränser når. ");
INSERT INTO swef_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","I söder ska ert land sträcka sig från öknen Zin utmed Edom, och er södra gräns ska börja vid änden av Salthavet i öster. ");
INSERT INTO swef_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Sedan ska er gräns vända sig söder om Skorpionhöjden och gå fram till Zin och gå ut söder om Kadesh-Barnea, och vidare till Hasar-Addar och fram till Asmon. ");
INSERT INTO swef_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Från Asmon ska gränsen vända sig mot Egyptens bäckravin och gå ut vid havet. ");
INSERT INTO swef_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Er gräns i väster ska vara Stora havet. Det ska vara er gräns i väster. ");
INSERT INTO swef_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Och detta ska vara er gräns i norr: Från Stora havet ska ni dra er gränslinje till berget Hor. ");
INSERT INTO swef_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Från berget Hor ska ni dra er gränslinje dit där vägen går till Hamat, och gränsen ska gå ut till Sedad. ");
INSERT INTO swef_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Sedan ska gränsen gå till Sifron och sluta vid Hasar-Enan. Detta ska vara er gräns i norr. ");
INSERT INTO swef_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Som er gräns i öster ska ni dra en linje från Hasar-Enan till Shefam. ");
INSERT INTO swef_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Och från Shefam ska gränsen gå ner till Haribla, öster om Ajin, och vidare ner längs östra sluttningen av Kinneretsjön. ");
INSERT INTO swef_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Sedan ska gränsen gå ner till Jordan och ut vid Salthavet. Detta ska vara ert land med dess gränser runt omkring.” ");
INSERT INTO swef_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Och Mose gav Israels barn denna befallning: ”Detta är det land som ni genom lottkastning ska utskifta som arvedel åt er. Herren har befallt att det ska ges åt de nio stammarna och den ena halva stammen, ");
INSERT INTO swef_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","för familjerna av Rubens stam och Gads stam och den andra hälften av Manasse stam har redan fått sin arvedel. ");
INSERT INTO swef_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Dessa två stammar och denna halva stam har fått sin arvedel på andra sidan Jordan mitt emot Jeriko, österut mot solens uppgång.” ");
INSERT INTO swef_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","”Detta är namnen på de män som åt er ska utskifta landet i arvslotter: prästen Eleaser och Josua, Nuns son. ");
INSERT INTO swef_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Och ni ska ta en furste ur varje stam för att utskifta landet i arvslotter. ");
INSERT INTO swef_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Detta är männens namn: Från Juda stam Kaleb, Jefunnes son, ");
INSERT INTO swef_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","från Simeons stam Samuel, Ammihuds son, ");
INSERT INTO swef_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","från Benjamins stam Elidad, Kislons son, ");
INSERT INTO swef_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","från Dans stam en furste, Bucki, Joglis son, ");
INSERT INTO swef_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","från Josefs barn: från Manasse stam en furste, Hanniel, Efods son, ");
INSERT INTO swef_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","och från Efraims stam en furste, Kemuel, Shiftans son, ");
INSERT INTO swef_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","från Sebulons stam en furste, Elisafan, Parnaks son, ");
INSERT INTO swef_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","från Isaskars stam en furste, Paltiel, Assans son, ");
INSERT INTO swef_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","från Ashers stam en furste, Ahihud, Shelomis son, ");
INSERT INTO swef_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","från Naftali stam en furste, Pedael, Ammihuds son.” ");
INSERT INTO swef_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Dessa är de män som Herren befallde att utskifta arvslotterna åt Israels barn i Kanaans land. ");
INSERT INTO swef_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Herren talade till Mose på Moabs hedar vid Jordan mitt emot Jeriko. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","”Befall Israels barn att de av de arvslotter de får till besittning ska ge städer åt leviterna att bo i. Ni ska också ge betesmarker åt dem omkring dessa städer. ");
INSERT INTO swef_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Städerna ska de själva bo i, och betesmarkerna ska vara för deras dragdjur och boskap och alla andra djur. ");
INSERT INTO swef_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Städernas betesmarker som ni ska ge leviterna ska sträcka sig tusen alnar från stadsmuren utåt åt alla sidor. ");
INSERT INTO swef_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Och utanför staden ska ni mäta upp på östra sidan tvåtusen alnar, på södra sidan tvåtusen alnar, på västra sidan tvåtusen alnar och på norra sidan tvåtusen alnar, med staden i mitten. Detta ska de ha som betesmarker till sina städer. ");
INSERT INTO swef_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","De städer som ni ger åt leviterna ska vara sex fristäder dit en dråpare kan fly. Utöver dessa ska ni ge dem fyrtiotvå andra städer. ");
INSERT INTO swef_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Åt leviterna ska ni ge sammanlagt fyrtioåtta städer med betesmarker omkring. ");
INSERT INTO swef_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Av de städer som ni ska ge av Israels barns besittningar, ska ni ta fler från de större stammarna och färre från de mindre. Varje stam ska ge åt leviterna några av sina städer, motsvarande den arvedel den själv har fått.” ");
INSERT INTO swef_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Herren talade till Mose. Han sade: ");
INSERT INTO swef_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","”Säg till Israels barn: När ni har gått över Jordan in i Kanaans land, ");
INSERT INTO swef_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ska ni utse åt er städer som ska vara fristäder för er, dit en dråpare som av misstag dödat någon ska kunna fly. ");
INSERT INTO swef_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Dessa städer ska ni ha som tillflyktsorter undan blodshämnaren, så att dråparen inte dör innan han har stått till rätta inför församlingen. ");
INSERT INTO swef_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Av de städer ni ger dem ska sex städer vara fristäder. ");
INSERT INTO swef_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tre städer ska ni utvälja på andra sidan Jordan och tre städer i Kanaans land. De ska vara fristäder. ");
INSERT INTO swef_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Israels barn och främlingen och den inneboende bland dem ska ha dessa sex städer som tillflyktsorter, dit var och en som av misstag dödat någon ska kunna fly. ");
INSERT INTO swef_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Men om någon slår en annan till döds med ett föremål av järn, då är han en mördare. En sådan ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Eller om någon har i sin hand en sten som kan döda och slår någon till döds med den, då är han en mördare. En sådan ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Eller om någon har i sin hand ett träredskap som kan döda och slår någon till döds med det, då är han en mördare. En sådan ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Blodshämnaren ska döda mördaren. Varhelst han träffar på honom ska han döda honom. ");
INSERT INTO swef_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Likaså om någon av hat stöter till en annan eller med berått mod kastar något på honom så att han dör, ");
INSERT INTO swef_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","eller av fiendskap slår honom till döds med handen, då ska den som gav slaget straffas med döden, för han är en mördare. Blodshämnaren ska döda honom när han träffar honom. ");
INSERT INTO swef_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Men om någon plötsligt och utan att hysa fiendskap stöter till någon, eller utan berått mod kastar något föremål på honom, ");
INSERT INTO swef_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","eller utan att se honom träffar med en sten som kan döda och döden följer, och det sker utan fiendskap och utan avsikt att skada, ");
INSERT INTO swef_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","då ska församlingen döma mellan den som gav slaget och blodshämnaren, enligt dessa föreskrifter. ");
INSERT INTO swef_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Församlingen ska rädda dråparen ur blodshämnarens hand och sända honom tillbaka till fristaden dit han hade flytt. Där ska han stanna tills översteprästen som är smord med den heliga oljan är död. ");
INSERT INTO swef_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Men om dråparen går utanför området för den fristad dit han flytt, ");
INSERT INTO swef_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","och blodshämnaren finner honom utanför det område som är hans fristad och dräper honom, då vilar ingen blodsskuld på blodshämnaren. ");
INSERT INTO swef_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","En dråpare ska stanna kvar i sin fristad tills översteprästen dör. Men efter översteprästens död får dråparen vända tillbaka till den ort där han har sin besittning. ");
INSERT INTO swef_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Detta ska vara en rättsstadga för er från släkte till släkte, var ni än bor. ");
INSERT INTO swef_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Om någon dödar en annan, ska mördaren dödas efter vittnens utsago. Men en enda persons vittnesmål är inte nog för att döma någon till döden. ");
INSERT INTO swef_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ni ska inte friköpa en mördares liv om han är skyldig till döden, utan han ska straffas med döden. ");
INSERT INTO swef_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ni ska inte heller friköpa den som har flytt till en fristad, för att han ska få vända tillbaka och bo i landet före prästens död. ");
INSERT INTO swef_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ni ska inte vanhelga det land där ni bor. Genom blod vanhelgas landet, och landet kan inte få försoning för det blod som spillts där utom genom blodet av den som har spillt det. ");
INSERT INTO swef_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ni ska inte orena landet där ni bor och i vars mitt jag har min boning, för jag, Herren, bor mitt ibland Israels barn.” ");
INSERT INTO swef_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Huvudmännen för familjerna som härstammade från Gilead, son till Makir, Manasses son, av Josefs barns släkter, trädde fram och talade inför Mose och de furstar som var huvudmän för israeliternas familjer. ");
INSERT INTO swef_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","De sade: ”Herren har befallt min herre att genom lottkastning ge landet som arvedel åt Israels barn, och min herre har fått befallning av Herren att ge vår broder Selofhads arvedel åt hans döttrar. ");
INSERT INTO swef_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Men om de blir gifta med någon ur en annan israelitisk stam, så tas deras arvedel bort från våra fäders arvedel. Den läggs till den stam de kommer att tillhöra och tas från vår arvslott. ");
INSERT INTO swef_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","När sedan jubelåret kommer för Israels barn, blir deras arvedel lagd till den stam som de kommer att tillhöra, men deras arvedel tas från vår fädernestams arvedel.” ");
INSERT INTO swef_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Efter Herrens ord befallde då Mose Israels barn: ”Josefs barns stam har talat rätt. ");
INSERT INTO swef_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Detta är vad Herren befaller angående Selofhads döttrar: De får gifta sig med vem de vill, men de ska gifta sig inom en släkt i sin egen fädernestam. ");
INSERT INTO swef_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ingen arvedel bland Israels barn får gå över från en stam till en annan, utan Israels barn ska behålla var och en sin fädernestams arvedel. ");
INSERT INTO swef_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Varje kvinna som äger en arvedel bland någon av Israels barns stammar ska gifta sig med någon från en släkt i hennes egen fädernestam, så att Israels barn får behålla var och en sina fäders arvedel. ");
INSERT INTO swef_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ingen arvedel får gå över från en stam till en annan, utan Israels barns stammar ska behålla var och en sin arvedel.” ");
INSERT INTO swef_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofhads döttrar gjorde så som Herren hade befallt Mose. ");
INSERT INTO swef_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Selofhads döttrar Mahla, Tirsa, Hogla, Milka och Noa gifte sig med sina farbröders söner. ");
INSERT INTO swef_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","De blev gifta inom Manasses, Josefs sons, släkter, och deras arvedel blev kvar inom deras fädernesläkts stam. ");
INSERT INTO swef_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Detta är de bud och stadgar som Herren gav Israels barn genom Mose på Moabs hedar vid Jordan mitt emot Jeriko. ");
INSERT INTO swef_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Detta är de ord som Mose talade till hela Israel i öknen på andra sidan Jordan, på hedmarken mitt emot Suf mellan Paran och Tofel, Laban, Haserot och Di-Sahab. ");
INSERT INTO swef_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Det är elva dagsresor från Horeb längs vägen över Seirs bergsbygd till Kadesh-Barnea. ");
INSERT INTO swef_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","I det fyrtionde året, på första dagen i elfte månaden, talade Mose till Israels barn allt som Herren hade befallt honom att säga dem. ");
INSERT INTO swef_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Det var efter att han hade slagit Sichon, amoreernas kung som bodde i Heshbon, och Og, Bashans kung som bodde i Ashtarot vid Edrei. ");
INSERT INTO swef_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","På andra sidan Jordan i Moabs land började Mose förklara denna undervisning. Han sade: ");
INSERT INTO swef_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Herren vår Gud talade till oss vid Horeb och sade: ”Ni har stannat länge nog vid detta berg. ");
INSERT INTO swef_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Bryt nu upp och gå till amoreernas bergsbygd och till alla deras grannfolk på Hedmarken, i Bergsbygden, i Låglandet, i Negev och i kustlandet vid havet. Gå till kananeernas land och till Libanon ända till den stora floden, floden Eufrat. ");
INSERT INTO swef_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Se, jag har lagt landet framför er. Gå nu och inta det land som Herren med ed har lovat era fäder Abraham, Isak och Jakob att ge åt dem och deras efterkommande efter dem.” ");
INSERT INTO swef_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","På den tiden sade jag till er: ”Jag kan inte bära er ensam. ");
INSERT INTO swef_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Herren er Gud har förökat er, och se, i dag är ni lika talrika som stjärnorna på himlen. ");
INSERT INTO swef_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Må Herren, era fäders Gud, föröka er tusenfalt och välsigna er, så som han har lovat er. ");
INSERT INTO swef_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Men hur ska jag ensam kunna bära era bekymmer, bördor och tvister? ");
INSERT INTO swef_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Utse åt er visa, förståndiga och kunniga män inom era stammar, så ska jag sätta dem till huvudmän över er.” ");
INSERT INTO swef_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ni svarade mig: ”Ditt förslag är gott.” ");
INSERT INTO swef_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Då tog jag huvudmännen i era stammar, visa och kunniga män, och satte dem till huvudmän över er. De blev befälhavare över tusen, över hundra, över femtio eller över tio, och förmän i era stammar. ");
INSERT INTO swef_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Vid den tiden befallde jag era domare och sade: ”Hör efter vad tvisten gäller mellan era bröder och döm rättvist mellan en man och hans bror eller främlingen hos honom. ");
INSERT INTO swef_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","När ni dömer ska ni inte vara partiska utan lyssna både till den ringe och den höge. Ni ska inte frukta för någon människa, för domen tillhör Gud. Och om något fall blir för svårt för er, ska ni lägga fram det för mig så att jag får höra det.” ");
INSERT INTO swef_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Jag befallde er på den tiden allt ni skulle göra. ");
INSERT INTO swef_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Vi bröt upp från Horeb och vandrade genom hela denna stora och fruktansvärda öken som ni har sett, på vägen till amoreernas bergsbygd, så som Herren vår Gud hade befallt oss. Och vi kom till Kadesh-Barnea. ");
INSERT INTO swef_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Där sade jag till er: ”Ni har nu kommit till amoreernas bergsbygd som Herren vår Gud vill ge oss. ");
INSERT INTO swef_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Se, Herren din Gud har lagt landet framför dig. Dra dit upp och inta det så som Herren, dina fäders Gud, har befallt dig. Var inte rädd eller modlös.” ");
INSERT INTO swef_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Då kom ni alla fram till mig och sade: ”Låt oss sända i väg några män framför oss som kan utforska landet åt oss, och sedan komma tillbaka till oss med uppgift om vägen vi ska ta dit upp och om de städer vi ska komma till.” ");
INSERT INTO swef_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Jag tyckte att förslaget var gott, och jag tog ut tolv män bland er, en från varje stam. ");
INSERT INTO swef_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","De gav sig i väg och drog upp till Bergsbygden och kom till Druvdalen och spejade i landet. ");
INSERT INTO swef_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","De tog med sig av landets frukt och förde det ner till oss och lämnade sin rapport till oss och sade: ”Det är ett gott land som Herren vår Gud ger oss.” ");
INSERT INTO swef_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Men ni ville inte dra dit upp utan trotsade Herren er Guds befallning. ");
INSERT INTO swef_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ni klagade i era tält och sade: ”Herren hatar oss, därför har han fört oss ut ur Egyptens land och gett oss i amoreernas hand för att förgöra oss. ");
INSERT INTO swef_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Vart ska vi ta vägen? Våra bröder har gjort oss modlösa, för de säger: Folket är större och resligare än vi, städerna är stora och befästa upp till himlen, och dessutom såg vi anakiter där.” ");
INSERT INTO swef_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Då svarade jag er: ”Bli inte förskräckta, var inte rädda för dem! ");
INSERT INTO swef_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Herren er Gud som går framför er ska själv strida för er, precis som han gjorde för er i Egypten inför era ögon. ");
INSERT INTO swef_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Och i öknen såg du hur Herren din Gud bar dig, så som en man bär sin son, hela den väg ni vandrade tills ni kom till denna plats.” ");
INSERT INTO swef_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Men trots detta trodde ni inte på Herren er Gud, ");
INSERT INTO swef_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","som gick framför er på vägen för att utse lägerplatser åt er – om natten i eld för att visa er vägen ni skulle gå och om dagen i molnskyn. ");
INSERT INTO swef_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","När nu Herren hörde era ord, blev han vred och svor en ed: ");
INSERT INTO swef_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","”Ingen av dessa män i detta onda släkte ska få se det goda land som jag med ed har lovat att ge era fäder, ");
INSERT INTO swef_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ingen utom Kaleb, Jefunnes son. Han ska få se det, och åt honom och hans barn ska jag ge det land som han har satt sin fot på, därför att han i allt har följt Herren.” ");
INSERT INTO swef_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Också på mig blev Herren vred för er skull. Han sade: ”Inte heller du ska komma dit in. ");
INSERT INTO swef_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josua, Nuns son, din tjänare, han ska komma dit in. Ge honom mod, för han ska dela landet åt Israel som arv. ");
INSERT INTO swef_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Och era barn som ni sade skulle bli fiendens byte, och era söner som i dag varken förstår gott eller ont, de ska komma dit in. Åt dem ska jag ge landet, och de ska ta det i besittning. ");
INSERT INTO swef_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Men ni ska vända om och bege er mot öknen i riktning mot Röda havet.” ");
INSERT INTO swef_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Då svarade ni mig: ”Vi har syndat mot Herren. Vi vill dra upp och strida, precis som Herren vår Gud har befallt oss.” Och var och en spände på sig sina vapen och tänkte att det skulle vara lätt att dra upp mot bergsbygden. ");
INSERT INTO swef_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Men Herren sade till mig: ”Säg till dem: Ni ska inte gå dit upp och ge er in i strid så att ni blir slagna av era fiender, för jag är inte med er.” ");
INSERT INTO swef_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Jag talade till er, men ni lyssnade inte på mig utan trotsade Herrens befallning och drog i övermod upp mot bergsbygden. ");
INSERT INTO swef_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Och amoreerna som bodde i den bergsbygden drog ut mot er och jagade er som bin gör, och slog er i Seir och drev er ända till Horma. ");
INSERT INTO swef_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Då vände ni tillbaka och ni grät inför Herrens ansikte. Men Herren hörde inte er röst, han lyssnade inte till er. ");
INSERT INTO swef_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Därför måste ni stanna i Kadesh så många dagar som ni gjorde. ");
INSERT INTO swef_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Så vände vi om och gick mot öknen, på vägen mot Röda havet, så som Herren hade sagt till mig. Det tog lång tid att ta oss runt Seirs bergsbygd. ");
INSERT INTO swef_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Då sade Herren till mig: ");
INSERT INTO swef_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","”Länge nog har ni gått runt om denna bergsbygd. Vänd er nu mot norr. ");
INSERT INTO swef_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Och säg till folket: Ni kommer att dra fram genom det område som tillhör era bröder, Esaus barn som bor i Seir. De är rädda för er, men var försiktiga. ");
INSERT INTO swef_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ni ska inte gå i strid med dem, för av deras land ska jag inte ge er ens så mycket som en fotsbredd, eftersom jag redan har gett Seirs bergsbygd till besittning åt Esau. ");
INSERT INTO swef_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ni ska köpa mat att äta av dem för pengar, och köpa vatten att dricka av dem för pengar, ");
INSERT INTO swef_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","för Herren din Gud har välsignat dig i allt du företagit dig. Han har tagit hand om dig under din vandring i denna stora öken. I dessa fyrtio år har Herren din Gud varit med dig och ingenting har fattats dig.” ");
INSERT INTO swef_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Så drog vi bort från våra bröder, Esaus barn, som bodde i Seir, och lämnade Hedmarksvägen och Elat och Esjon-Geber. Vi vek av och tog vägen mot Moabs öken. ");
INSERT INTO swef_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Och Herren sade till mig: ”Du ska inte angripa Moab eller gå i strid med dem, för av deras land ska jag inte ge dig något till besittning, eftersom jag redan har gett Ar till Lots barn.” ");
INSERT INTO swef_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Förr bodde emeerna där, de var ett folk som var stort, talrikt och resligt som anakiterna. ");
INSERT INTO swef_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Liksom anakiterna räknas också de för rafaeer, men moabiterna kallar dem emeer. ");
INSERT INTO swef_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","I Seir bodde tidigare horeerna, men Esaus barn drev bort dem och förgjorde dem och bosatte sig i deras land, alldeles som Israel gjorde med det land som Herren hade gett dem till besittning. ");
INSERT INTO swef_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","”Så bryt nu upp och gå över bäcken Sered.” Vi gick då över den bäckravinen. ");
INSERT INTO swef_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Från den tid vi lämnade Kadesh-Barnea tills vi gick över bäcken Sered gick det trettioåtta år. Under den tiden dog hela det släkte av stridsmän som fanns i lägret, så som Herren med ed hade förklarat för dem. ");
INSERT INTO swef_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Herrens hand var emot dem, och han utrotade dem ur lägret så att de dog. ");
INSERT INTO swef_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","När nu alla stridsmän i folket hade dött, ");
INSERT INTO swef_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","sade Herren till mig: ");
INSERT INTO swef_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","”Du ska i dag gå över Moabs gräns vid Ar ");
INSERT INTO swef_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","och ska då komma i närheten av ammoniterna. Men du ska inte angripa dem eller gå i strid med dem, för jag kommer inte att ge dig något i ammoniternas land till besittning, eftersom jag redan har gett det till Lots barn.” ");
INSERT INTO swef_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Också detta räknas till rafaeernas land. Rafaeer bodde där tidigare, men ammoniterna kallar dem samsummiter. ");
INSERT INTO swef_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","De var ett folk som var stort, talrikt och resligt som anakiterna. Men Herren förgjorde dem för ammoniterna, som fördrev dem och bosatte sig i deras land. ");
INSERT INTO swef_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","På samma sätt gjorde han för Esaus barn som bor i Seir, när han förgjorde horeerna för dem. De drev bort dem och bosatte sig i deras land, där de bor än i dag. ");
INSERT INTO swef_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Även aveerna som bodde i byar ända fram till Gaza blev förgjorda av kaftoreerna, som drog ut från Kaftor och sedan bodde i deras land. ");
INSERT INTO swef_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","”Bryt nu upp och gå över floden Arnon. Se, jag har gett amorén Sichon, kungen i Heshbon, och hans land i din hand. Börja att inta det och ge dig i strid med honom. ");
INSERT INTO swef_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Redan i dag ska jag börja att inge fruktan och skräck för dig hos alla folk under himlen, så att de darrar och bävar för dig när de hör berättas om dig.” ");
INSERT INTO swef_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Och jag skickade sändebud från Kedemots öken till Sichon, kungen i Heshbon, med fridsamma ord och lät säga: ");
INSERT INTO swef_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","”Låt mig gå igenom ditt land. Jag ska strikt följa vägen utan att vika av åt höger eller vänster. ");
INSERT INTO swef_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Jag ska äta den mat som du vill sälja till mig för pengar och dricka det vatten som du vill ge mig för pengar. Låt mig bara passera igenom till fots ");
INSERT INTO swef_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","– på samma sätt som Esaus barn, Seirs invånare, och moabiterna, Ars invånare, handlade mot mig – så att jag kan gå över Jordan in i det land som Herren vår Gud vill ge oss.” ");
INSERT INTO swef_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Men Sichon, kungen i Heshbon, var inte villig att låta oss gå igenom hans land, för Herren din Gud hade förhärdat hans ande och gjort hans hjärta hårt för att ge honom i din hand, så som det är i dag. ");
INSERT INTO swef_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Och Herren sade till mig: ”Se, jag börjar nu att ge Sichon och hans land till dig. Börja inta det så att du får hans land till besittning.” ");
INSERT INTO swef_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sichon drog då emot oss med allt sitt folk för att strida mot oss vid Jahas. ");
INSERT INTO swef_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Men Herren vår Gud överlämnade honom till oss, och vi slog honom, hans söner och allt hans folk. ");
INSERT INTO swef_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Vi intog vid den tiden alla hans städer och vigde alla män, kvinnor och barn i varje stad åt förintelse. Vi lät ingen komma undan. ");
INSERT INTO swef_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Bara boskapen tog vi som byte tillsammans med rovet från de städer vi intog. ");
INSERT INTO swef_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Från Aroer vid floden Arnons strand, och från staden i dalen ända till Gilead fanns ingen stad vars murar var för höga för oss. Herren vår Gud gav allt till oss. ");
INSERT INTO swef_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Men ammoniternas land lät du vara ifred, hela landsträckan längs Jabboks dalsänka och städerna i bergsbygden, alldeles som Herren vår Gud hade befallt. ");
INSERT INTO swef_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Sedan vek vi av och drog upp mot Bashan. Och Og, kungen i Bashan, kom ut med allt sitt folk för att strida mot oss vid Edrei. ");
INSERT INTO swef_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Men Herren sade till mig: ”Var inte rädd för honom, för jag har gett honom och allt hans folk och hans land i din hand. Du ska göra med honom som du gjorde med Sichon, amoreernas kung, som bodde i Heshbon.” ");
INSERT INTO swef_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Herren vår Gud gav också Og, kungen i Bashan, och allt hans folk i vår hand. Vi slog honom och lät ingen överleva. ");
INSERT INTO swef_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Och vi intog vid den tiden alla hans städer. Det fanns ingen stad som vi inte tog ifrån dem: sextio städer, hela landsträckan Argob, Ogs rike i Bashan. ");
INSERT INTO swef_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Alla dessa städer var befästa med höga murar, med portar och bommar. Dessutom fanns det en stor mängd byar. ");
INSERT INTO swef_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Vi vigde dem åt förintelse, liksom vi hade gjort med kung Sichon i Heshbon. I varje stad vigde vi alla män, kvinnor och barn åt förintelse, ");
INSERT INTO swef_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","men all boskap och bytet från städerna tog vi för egen räkning. ");
INSERT INTO swef_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Från amoreernas två kungar, som härskade på andra sidan Jordan, tog vi vid den tiden deras land, från Arnons dalsänka ända till berget Hermon ");
INSERT INTO swef_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","– sidonierna kallar Hermon för Sirjon, medan amoreerna kallar det Senir. ");
INSERT INTO swef_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Vi tog alla städerna på slätten och hela Gilead och hela Bashan, ända till Salka och Edrei, städerna i Ogs rike i Bashan. ");
INSERT INTO swef_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Og, kungen i Bashan, var den ende som fanns kvar av rafaeerna. Hans säng var gjord av järn, och finns nu i Rabba i ammoniternas land. Den är nio alnar lång och fyra alnar bred, alnen beräknad efter en mans underarm. ");
INSERT INTO swef_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Av det land som vi hade erövrat vid den tiden gav jag den del som breder ut sig från Aroer, vid Arnons dalsänka, samt hälften av Gileads bergsbygd med dess städer åt rubeniterna och gaditerna. ");
INSERT INTO swef_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Resten av Gilead och hela Bashan, Ogs rike, gav jag åt ena hälften av Manasse stam: hela landsträckan Argob och hela Bashan. Detta kallas rafaeernas land. ");
INSERT INTO swef_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, Manasses son, tog hela landsträckan Argob ända till geshureernas och maakateernas område, och efter sitt eget namn kallade han Bashan för Jairs byar, som det heter än i dag. ");
INSERT INTO swef_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Åt Makir gav jag Gilead. ");
INSERT INTO swef_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Och åt rubeniterna och gaditerna gav jag landet från Gilead ända till Arnons dalsänka – gränsen gick mitt i floden – och till Jabboks dalsänka som är ammoniternas gräns, ");
INSERT INTO swef_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","vidare Hedmarken med Jordan som gräns från Kinneret ända till Hedmarkshavet, Salthavet nedanför Pisgas sluttningar i öster. ");
INSERT INTO swef_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Jag befallde er på den tiden och sade: ”Herren er Gud har gett er detta land till besittning. Men nu ska ni, alla tappra stridsmän, beväpna er och gå över i spetsen för era bröder, Israels barn. ");
INSERT INTO swef_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Men era hustrur och barn och er boskap – jag vet att ni har mycket boskap – ska stanna kvar i de städer som jag har gett er ");
INSERT INTO swef_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","tills Herren har låtit era bröder få ro, liksom ni har fått ro, när också de har tagit i besittning det land som Herren er Gud vill ge dem på andra sidan Jordan. Sedan kan ni vända tillbaka till de besittningar jag har gett var och en av er.” ");
INSERT INTO swef_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","På den tiden befallde jag Josua och sade: ”Du har med egna ögon sett allt som Herren er Gud har gjort med dessa båda kungar. Så ska också Herren göra med alla riken där du drar fram. ");
INSERT INTO swef_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Var inte rädda för dem, för Herren er Gud ska själv strida för er.” ");
INSERT INTO swef_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","På den tiden bad jag så till Herren: ");
INSERT INTO swef_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","”Herre Gud, du har börjat att låta din tjänare se din storhet och din starka hand. Vilken gud i himlen eller på jorden kan göra sådana verk och sådana väldiga gärningar som du? ");
INSERT INTO swef_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Låt mig nu få gå över dit och se det goda landet på andra sidan Jordan, detta vackra bergiga land och Libanon.” ");
INSERT INTO swef_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Men Herren hade blivit vred på mig för er skull, och han lyssnade inte på mig utan sade till mig: ”Det är nog. Tala inte mer till mig om denna sak. ");
INSERT INTO swef_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Stig upp på toppen av Pisga och lyft upp dina ögon mot väster och norr, mot söder och öster. Se med dina ögon, för du ska inte gå över denna Jordan. ");
INSERT INTO swef_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Anförtro Josua ditt uppdrag och styrk honom och ge honom mod. Det är han som ska gå över dit i spetsen för detta folk, och han ska ge dem i arv det land du ser.” ");
INSERT INTO swef_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Vi stannade sedan i dalen mitt emot Bet-Peor. ");
INSERT INTO swef_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Och nu Israel, lyssna till de stadgar och föreskrifter som jag vill lära er att följa, för att ni ska leva och komma in i och ta i besittning det land som Herren, era fäders Gud, vill ge er. ");
INSERT INTO swef_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ni ska inte lägga något till det som jag befaller er och inte ta något därifrån utan hålla Herren er Guds bud som jag ger er. ");
INSERT INTO swef_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ni har med egna ögon sett vad Herren har gjort i fråga om Baal-Peor. Herren din Gud utrotade ur ditt folk var och en som följde Baal-Peor. ");
INSERT INTO swef_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Men ni som höll fast vid Herren er Gud ni lever alla än i dag. ");
INSERT INTO swef_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Se, jag har lärt er stadgar och föreskrifter så som Herren min Gud har befallt mig, för att ni ska följa dem i det land dit ni kommer för att ta det i besittning. ");
INSERT INTO swef_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ni ska hålla och följa dem, och det ska tillräknas er som vishet och förstånd av andra folk. När de får höra om alla dessa lagar ska de säga: ”Detta stora folk är verkligen ett vist och förståndigt folk!” ");
INSERT INTO swef_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Finns det något annat stort folk som har gudar som är lika nära det som Herren vår Gud är nära oss så ofta vi åkallar honom? ");
INSERT INTO swef_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Och finns det något annat stort folk som har stadgar och föreskrifter som är så rättfärdiga som hela denna lag som jag i dag lägger fram för er? ");
INSERT INTO swef_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Men ta dig till vara och akta dig noga så att du inte glömmer vad dina ögon såg eller låter det vika från ditt hjärta under alla dina livsdagar. Berätta för dina barn och barnbarn ");
INSERT INTO swef_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","vad som hände den dag du stod inför Herren din Gud vid Horeb, när Herren sade till mig: ”Samla folket till mig. Jag vill låta dem höra mina ord, och de ska lära sig dem så att de fruktar mig så länge de lever på jorden. Och de ska lära sina barn dem.” ");
INSERT INTO swef_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Då kom ni fram och stannade vid bergets fot. Berget brann i eld ända upp till himlen, och där var mörker, moln och töcken. ");
INSERT INTO swef_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Och Herren talade till er ur elden. Ni hörde orden men såg ingen gestalt, ni hörde bara rösten. ");
INSERT INTO swef_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Han förkunnade för er sitt förbund som han befallde er att hålla, de tio orden, och han skrev dem på två stentavlor. ");
INSERT INTO swef_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Herren befallde mig på den tiden att jag skulle lära er stadgar och föreskrifter som ni skulle följa i det land dit ni går för att ta det i besittning. ");
INSERT INTO swef_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Eftersom ni inte såg någon gestalt den dag då Herren talade till er på Horeb ur elden ska ni noga akta er, ");
INSERT INTO swef_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","så att ni inte försyndar er genom att ni gör åt er något beläte, något slags avgudabild, en bild av man eller kvinna ");
INSERT INTO swef_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","eller en bild av något djur på jorden eller någon bevingad fågel som flyger under himlen ");
INSERT INTO swef_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","eller något kräldjur på marken eller någon fisk i vattnet under jorden. ");
INSERT INTO swef_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Och när du lyfter din blick mot himlen och ser solen, månen och stjärnorna, himlens hela härskara, låt dig då inte förledas att tillbe dem och tjäna dem, för Herren din Gud har gett dem åt alla folk under hela himlen som deras del. ");
INSERT INTO swef_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Men er har Herren tagit och han har fört er ut ur smältugnen, ut ur Egypten, för att ni ska vara hans egendomsfolk, så som ni är i dag. ");
INSERT INTO swef_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Herren blev vred på mig för er skull och svor att jag inte skulle gå över Jordan och inte komma in i det goda land som Herren din Gud vill ge dig till arvedel. ");
INSERT INTO swef_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Jag kommer att dö i detta land och inte gå över Jordan, men ni ska gå över den och ta det goda landet i besittning. ");
INSERT INTO swef_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Akta er så att ni inte glömmer det förbund som Herren er Gud har slutit med er, så att ni inte gör er en avgud, en bild tvärtemot vad Herren din Gud har befallt dig, ");
INSERT INTO swef_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","för Herren din Gud är en förtärande eld, han är en nitisk Gud. ");
INSERT INTO swef_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","När du har fött barn och barnbarn och ni bott länge i landet, om ni då försyndar er genom att ni gör er en avgud, ett slags bild, och därmed gör det som är ont i Herren din Guds ögon och väcker hans vrede, ");
INSERT INTO swef_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","då tar jag i dag himmel och jord till vittne mot er att ni snart kommer att utrotas ur det land dit ni nu går över Jordan för att ta det i besittning. Ni kommer inte att leva där länge utan kommer att helt förgöras. ");
INSERT INTO swef_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Och Herren ska skingra er bland folken, och endast ett litet antal av er ska bli kvar bland de hednafolk som Herren ska driva er bort till. ");
INSERT INTO swef_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Där ska ni tjäna gudar som blivit gjorda av människohänder, gudar av trä och sten. De kan varken se eller höra, äta eller lukta. ");
INSERT INTO swef_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Men om ni där söker Herren din Gud ska du finna honom, om du söker honom av hela ditt hjärta och av hela din själ. ");
INSERT INTO swef_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","När du är i nöd och allt detta händer dig i kommande dagar ska du vända om till Herren din Gud och lyda hans röst, ");
INSERT INTO swef_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","för Herren din Gud är en barmhärtig Gud. Han ska inte överge dig eller förgöra dig. Han ska inte glömma det förbund han med ed har ingått med dina fäder. ");
INSERT INTO swef_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Fråga tider som varit, tider som varit före dig, från den dag då Gud skapade människor på jorden, fråga från himlens ena ände till den andra: Har det någonsin hänt något så stort som detta, eller har man hört talas om något som liknar det? ");
INSERT INTO swef_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Har något folk hört Guds röst tala ur elden, så som du har hört, och överlevt? ");
INSERT INTO swef_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Eller har någon gud försökt att gå och ta ett folk åt sig ur ett annat folk, genom prövningar, tecken och under, genom krig, genom stark hand och uträckt arm och genom stora och fruktansvärda gärningar, allt detta som Herren er Gud har gjort med er i Egypten inför dina ögon? ");
INSERT INTO swef_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Du har själv fått se det, för att du skulle veta att Herren är Gud: Det finns ingen annan än han. ");
INSERT INTO swef_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Från himlen lät han dig höra sin röst för att undervisa dig, och på jorden lät han dig se sin stora eld, och du har hört hans ord ur elden. ");
INSERT INTO swef_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Eftersom han älskade dina fäder och utvalde deras avkomlingar efter dem, förde han genom sin närvaro och stora kraft dig ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Han drev bort för dig folk, större och mäktigare än du, och förde dig in i deras land och gav det åt dig till arvedel, så som det är i dag. ");
INSERT INTO swef_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Därför ska du i dag veta och lägga på hjärtat att Herren är Gud uppe i himlen och nere på jorden: Det finns ingen annan. ");
INSERT INTO swef_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Och du ska hålla hans stadgar och bud som jag i dag ger dig, så att det går väl för dig och dina barn efter dig och du får leva länge i det land som Herren din Gud vill ge dig för all framtid. ");
INSERT INTO swef_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Vid denna tid avskilde Mose tre städer i öster på andra sidan Jordan ");
INSERT INTO swef_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","dit en dråpare skulle kunna fly om han hade dödat någon utan vett och vilja och utan att förut ha burit hat till honom. Genom att fly till någon av dessa städer skulle han få leva. ");
INSERT INTO swef_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","De var: Beser i öknen på slättlandet för Rubens stam, Ramot i Gilead för Gads stam och Golan i Bashan för Manasse stam. ");
INSERT INTO swef_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Detta är den undervisning som Mose lade fram för Israels barn, ");
INSERT INTO swef_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","och dessa är de vittnesbörd, stadgar och föreskrifter som Mose kungjorde för Israels barn efter att de hade dragit ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Det var på andra sidan Jordan i dalen mitt emot Bet-Peor, i amoreerkungen Sichons land, han som bodde i Heshbon och som Mose och Israel slog när de hade dragit ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","De intog hans land och landet som tillhörde kung Og i Bashan, de två amoreiska kungarnas länder i öster på andra sidan Jordan, ");
INSERT INTO swef_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","från Aroer vid floden Arnons strand ända till berget Sion, det vill säga Hermon, ");
INSERT INTO swef_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","och hela Hedmarken i öster på andra sidan Jordan, ända till Hedmarkshavet nedanför Pisgas sluttningar. ");
INSERT INTO swef_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mose kallade samman hela Israel och sade till dem: Hör, Israel, de stadgar och föreskrifter som jag i dag kungör för er. Lär er dem och håll fast vid och följ dem. ");
INSERT INTO swef_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Herren vår Gud slöt ett förbund med oss på Horeb. ");
INSERT INTO swef_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Det var inte med våra fäder Herren slöt förbundet, utan med oss som står här i dag, oss alla som nu lever. ");
INSERT INTO swef_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Ansikte mot ansikte talade Herren till er ur elden på berget. ");
INSERT INTO swef_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Jag stod då mellan Herren och er för att förkunna Herrens ord för er, för ni var rädda för elden och steg inte upp på berget. Han sade: ");
INSERT INTO swef_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Jag är Herren din Gud som har fört dig ut ur Egyptens land, ur träldomshuset. ");
INSERT INTO swef_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Du ska inte ha andra gudar vid sidan av mig. ");
INSERT INTO swef_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Du ska inte göra dig någon bildstod eller avbild av det som är uppe i himlen eller nere på jorden eller i vattnet under jorden. ");
INSERT INTO swef_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Du ska inte tillbe dem eller tjäna dem, för jag, Herren din Gud, är en nitisk Gud. Jag låter straffet för fädernas missgärning drabba barnen till tredje och fjärde led när man hatar mig, ");
INSERT INTO swef_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","men visar nåd mot tusentals när man älskar mig och håller mina bud. ");
INSERT INTO swef_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Du ska inte missbruka Herren din Guds namn, för Herren ska inte låta den bli ostraffad som missbrukar hans namn. ");
INSERT INTO swef_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Håll sabbatsdagen så att du helgar den, så som Herren din Gud har befallt dig. ");
INSERT INTO swef_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Sex dagar ska du arbeta och uträtta alla dina sysslor. ");
INSERT INTO swef_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Men den sjunde dagen är Herren din Guds sabbat. Då ska du inte utföra något arbete, inte heller din son eller dotter, din tjänare eller tjänarinna, din oxe eller åsna eller något av dina dragdjur, eller främlingen som bor hos dig inom dina portar. Din tjänare och din tjänarinna ska få vila liksom du. ");
INSERT INTO swef_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Kom ihåg att du var slav i Egyptens land, och att Herren din Gud har fört dig ut därifrån med stark hand och uträckt arm. Därför har Herren din Gud befallt dig att hålla sabbatsdagen. ");
INSERT INTO swef_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Hedra din far och din mor, så som Herren din Gud har befallt dig, så att du får leva länge och det går dig väl i det land som Herren din Gud ger dig. ");
INSERT INTO swef_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Du ska inte mörda. ");
INSERT INTO swef_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Du ska inte begå äktenskapsbrott. ");
INSERT INTO swef_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Du ska inte stjäla. ");
INSERT INTO swef_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Du ska inte bära falskt vittnesbörd mot din nästa. ");
INSERT INTO swef_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Du ska inte ha begär till din nästas hustru. Du ska inte ha begär till din nästas hus eller åker, hans tjänare eller tjänarinna, hans oxe eller åsna eller något annat som tillhör din nästa. ");
INSERT INTO swef_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Dessa ord talade Herren med hög röst till hela er församling på berget, ur elden, molnskyn och töcknet, och han tillade inget mer. Och han skrev orden på två stentavlor som han gav åt mig. ");
INSERT INTO swef_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","När ni hörde rösten ur mörkret medan berget brann i eld, kom ni fram till mig, alla huvudmän för era stammar samt era äldste. ");
INSERT INTO swef_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Och ni sade: ”Se, Herren vår Gud har låtit oss se sin härlighet och sin storhet, och vi har hört hans röst ur elden. I dag har vi sett att Gud kan tala med en människa och ändå låta henne leva. ");
INSERT INTO swef_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Varför ska vi nu dö? Den stora elden kommer att förtära oss. Om vi får höra mer av Herren vår Guds röst kommer vi att dö. ");
INSERT INTO swef_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","För vem bland allt kött har hört den levande Gudens röst tala ur elden, som vi har gjort, och överlevt? ");
INSERT INTO swef_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Träd du fram och hör allt som Herren vår Gud säger, och tala du till oss allt som Herren vår Gud talar till dig, så vill vi höra det och göra därefter.” ");
INSERT INTO swef_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Herren hörde era ord när ni talade till mig, och Herren sade till mig: ”Jag har hört de ord som detta folk har talat till dig. De har rätt i allt de säger. ");
INSERT INTO swef_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Om de ändå kunde ha sådana hjärtan att de fruktar mig och alltid håller alla mina bud! Då skulle det alltid gå väl för dem och deras barn. ");
INSERT INTO swef_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Gå och säg till dem: Vänd tillbaka till era tält. ");
INSERT INTO swef_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Men du ska stanna kvar här hos mig, så ska jag tala till dig alla de bud och stadgar och föreskrifter som du ska lära dem, så att de följer dem i det land som jag ger dem till besittning.” ");
INSERT INTO swef_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Var noga med att göra vad Herren er Gud har befallt er. Vik inte av, varken åt höger eller åt vänster. ");
INSERT INTO swef_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Den väg som Herren er Gud har befallt er att gå ska ni alltid följa, så att ni får leva och det går väl för er och ni får ett långt liv i det land som ni ska ta i besittning. ");
INSERT INTO swef_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Dessa är de bud, stadgar och föreskrifter som Herren er Gud har befallt mig att lära er, för att ni ska följa dem i det land dit ni går för att ta det i besittning. ");
INSERT INTO swef_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","I hela ditt liv ska du frukta Herren din Gud så att du håller alla hans stadgar och bud som jag ger dig, du och din son och din sonson, så att du får ett långt liv. ");
INSERT INTO swef_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Du ska lyssna, Israel, och vara noga med att följa dem, så att det går väl för dig och ni blir mycket talrika, så som Herren, dina fäders Gud, har lovat dig i landet som flödar av mjölk och honung. ");
INSERT INTO swef_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Hör, Israel! Herren vår Gud, Herren är en. ");
INSERT INTO swef_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Och du ska älska Herren din Gud av hela ditt hjärta och av hela din själ och av hela din kraft. ");
INSERT INTO swef_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Dessa ord som jag i dag befaller dig ska du lägga på hjärtat. ");
INSERT INTO swef_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Du ska inskärpa dem hos dina barn och tala om dem när du sitter i ditt hus och när du går på vägen, när du lägger dig och när du stiger upp. ");
INSERT INTO swef_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Du ska binda dem som ett tecken på din hand, och de ska vara som en påminnelse på din panna. ");
INSERT INTO swef_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Och du ska skriva dem på dörrposterna i ditt hus och på dina  portar. ");
INSERT INTO swef_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","När Herren din Gud låter dig komma in i det land som han med ed lovade dina fäder Abraham, Isak och Jakob att ge dig, med stora och vackra städer som du inte har byggt, ");
INSERT INTO swef_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","och hus fulla med allt gott som du inte har fyllt, och uthuggna brunnar som du inte har huggit ut, och vingårdar och olivlundar som du inte har planterat – när du då äter och blir mätt ");
INSERT INTO swef_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ska du se till att du inte glömmer Herren som har fört dig ut ur Egyptens land, ur träldomshuset. ");
INSERT INTO swef_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Herren din Gud ska du vörda, honom ska du tjäna, och i hans namn ska du ge din ed. ");
INSERT INTO swef_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ni ska inte följa andra gudar, någon gud som dyrkas av de folk som bor runt omkring er, ");
INSERT INTO swef_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","för Herren din Gud är en nitisk Gud i din mitt. Se därför till att inte Herren din Guds vrede blir upptänd mot dig och han utrotar dig från jordens yta. ");
INSERT INTO swef_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ni ska inte fresta Herren er Gud, så som ni frestade honom i Massa. ");
INSERT INTO swef_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ni ska troget hålla Herren er Guds bud och de vittnesbörd och stadgar som han har gett dig. ");
INSERT INTO swef_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Du ska göra det som är rätt och gott i Herrens ögon, så att det går väl för dig och du får komma in och ta i besittning det goda land som Herren med ed har lovat dina fäder. ");
INSERT INTO swef_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Han ska driva bort alla dina fiender för dig, så som Herren har lovat. ");
INSERT INTO swef_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","När din son i framtiden frågar dig: Vad betyder de vittnesbörd, stadgar och bud som Herren vår Gud har gett er? ");
INSERT INTO swef_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","då ska du svara honom: Vi var faraos slavar i Egypten, men med stark hand förde Herren oss ut ur Egypten. ");
INSERT INTO swef_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Och Herren gjorde stora och ödeläggande tecken och under i Egypten på farao och hela hans hus inför våra ögon. ");
INSERT INTO swef_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Men oss förde han ut därifrån för att leda oss in i och ge oss det land som han med ed hade lovat våra fäder. ");
INSERT INTO swef_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Herren befallde oss att följa alla dessa stadgar och frukta Herren vår Gud, så att det alltid går väl för oss och han bevarar oss vid liv, så som han gjort till denna dag. ");
INSERT INTO swef_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Det ska vara vår rättfärdighet, att vi noga följer alla dessa bud inför Herren vår Guds ansikte så som han har befallt oss. ");
INSERT INTO swef_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","När Herren din Gud låter dig komma in i det land dit du nu går för att ta det i besittning, och när han driver bort många hednafolk för dig, hetiterna, girgasheerna, amoreerna, kananeerna, perisseerna, hiveerna och jebusiterna, sju folk som är större och mäktigare än du, ");
INSERT INTO swef_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","och när Herren din Gud ger dem till dig och du slår dem, då ska du viga dem åt förintelse. Du ska inte sluta förbund med dem eller visa dem nåd. ");
INSERT INTO swef_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Du ska inte ingå släktskap med dem. Du ska inte ge dina döttrar åt deras söner och inte ta deras döttrar åt dina söner, ");
INSERT INTO swef_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","för de kommer då att leda dina söner bort från mig till att tjäna andra gudar, och Herrens vrede ska då upptändas mot er och han ska snabbt förgöra dig. ");
INSERT INTO swef_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Utan så här ska ni göra med dem: Ni ska bryta ner deras altaren, slå sönder deras stoder, hugga ned deras asherapålar och bränna upp deras avgudabilder i eld, ");
INSERT INTO swef_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","för du är ett heligt folk inför Herren din Gud. Dig av alla folk på jordens yta har Herren din Gud utvalt att vara hans egendomsfolk. ");
INSERT INTO swef_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Det var inte för att ni var större än alla andra folk som Herren fäste sig vid er och utvalde er, ni var tvärtom mindre än alla andra folk. ");
INSERT INTO swef_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Utan det var därför att Herren älskade er och höll den ed som han hade gett era fäder som Herren förde er ut med stark hand och befriade dig ur träldomshuset, ur den egyptiske kungens hand, ur faraos hand. ");
INSERT INTO swef_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Så ska du veta att endast Herren din Gud är Gud, den trofaste Guden som håller fast vid sitt förbund och sin nåd i tusen släktled när man älskar honom och håller hans bud. ");
INSERT INTO swef_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Men den som hatar honom ska han vedergälla med undergång, ansikte mot ansikte. Han ska inte tveka när det gäller dem som hatar honom. Ansikte mot ansikte ska han vedergälla dem. ");
INSERT INTO swef_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Håll därför de bud, stadgar och föreskrifter som jag i dag befaller dig att följa. ");
INSERT INTO swef_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Om ni nu hör dessa föreskrifter och håller fast vid dem och följer dem, ska Herren din Gud hålla fast vid sitt förbund och sin nåd så som han med ed har lovat dina fäder. ");
INSERT INTO swef_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Han ska älska dig och välsigna dig och föröka dig. Han ska välsigna din livsfrukt och din marks frukt, din säd, ditt nya vin och din olja, dina kors kalvar och dina tackors lamm i det land som han med ed har lovat dina fäder att ge dig. ");
INSERT INTO swef_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Du ska bli välsignad framför alla andra folk. Bland dina män och kvinnor ska ingen vara ofruktsam, inte heller bland din boskap. ");
INSERT INTO swef_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Herren ska låta varje sjukdom vika från dig. Ingen av Egyptens alla svåra sjukdomar som du känner till ska han lägga på dig, men han ska lägga dem på alla som hatar dig. ");
INSERT INTO swef_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Du ska förgöra alla de folk som Herren din Gud ger dig. Du ska inte visa dem någon skonsamhet. Och du ska inte tjäna deras gudar, för det skulle bli en snara för dig. ");
INSERT INTO swef_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Även om du säger i ditt hjärta: ”Dessa hednafolk är större än jag, hur ska jag kunna driva bort dem?”, ");
INSERT INTO swef_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","så var inte rädd för dem. Tänk bara på vad Herren din Gud gjorde med farao och med hela Egypten. ");
INSERT INTO swef_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Tänk på de stora hemsökelser som dina ögon har sett. Tänk på de tecken och under, på den starka hand och uträckta arm med vilken Herren din Gud förde dig ut. Så ska Herren din Gud göra med alla de folk som du är rädd för. ");
INSERT INTO swef_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Dessutom ska Herren din Gud sända panik bland dem, tills de som är kvar och håller sig gömda för dig blir utrotade. ");
INSERT INTO swef_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Var inte förskräckt för dem, för Herren din Gud är mitt ibland dig, en stor och fruktansvärd Gud. ");
INSERT INTO swef_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Och Herren din Gud ska jaga i väg dessa folk för dig, undan för undan. Du får inte förgöra dem med en gång, för att inte vilddjuren på marken ska bli för många för dig. ");
INSERT INTO swef_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Herren din Gud ska ge dem till dig och sända stor förvirring ibland dem tills de blir förgjorda. ");
INSERT INTO swef_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Han ska ge deras kungar i din hand, och du ska utplåna deras namn under himlen. Ingen ska kunna stå dig emot, till dess att du har utrotat dem. ");
INSERT INTO swef_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Deras avgudabilder ska du bränna upp i eld. Du ska inte ha begär till det silver och guld som finns på dem och inte ta något av det själv så att du blir snärjd av det, för det är avskyvärt för Herren din Gud. ");
INSERT INTO swef_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Du ska inte låta något avskyvärt komma 