﻿USE sofia;
DROP TABLE IF EXISTS sofia.swe_vpl;
CREATE TABLE swe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swe_vpl WRITE;
INSERT INTO swe_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","I begynnelsen (som en början/startpunkt) skapade (hebr. bara) Gud (Elohim) himlarna och jorden hela universum. ");
INSERT INTO swe_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Jorden var ännu öde och tom (obebodd, ogästvänlig – hebr. tóho vabóho) med mörker över djupet, men Guds Ande hovrade (var i rörelse, svävade) över vattnen. Uttrycket ”himlar och jord” beskriver all materia som existerar – hela universum, det är en så kallad merism (ett uttryck med kontraster som beskriver en helhet). Vers 1-2 är en introduktion som ger förutsättningarna innan Gud börjar göra jorden beboelig och fylla den med liv i och med vers 3. Då inleds den första av skapelsedagarna på samma sätt som alla andra dagar med ”Och Gud sa”. Även om universum är skapat så är jorden ännu obeboelig och olämplig för liv, enbart mörker vilar över jordens vattentäckta yta.  Ordet hovra (hebr. rachaf) används bara här och i 5 Mos 32:11 där det beskriver en örn som svävar över sitt bo och lockar sina ungar till att pröva sina vingar. Samma rot återfinns även i Jer 23:9 där hans ben ”darrar”. Här beskriver det nu hur Guds Ande är i rörelse, manifesterad på ett dallrande, vibrerande sätt – redo för nästa steg.  Jesus i skapelsen  Det första ordet i Bibeln (hebr. bereshit) inleds med prefixet be- som kan betyda i, men också med eller genom (t.ex. som att man skriver med hjälp av pennan eller genom någons insats är det möjligt). Sedan följer reshit som betyder begynnelsen och det första, men även det bästa, förnämsta eller finaste. Det är antagligen detta första ord som Paulus anspelar på när han i Kol 1:16 säger:  För i honom skapades allt i himlarna och på jorden, det synliga liksom det osynliga.  Frasen ”i honom” kan man härleda just från bereshit som även kan tolkas som ”genom/i den förste, den bäste” – den enfödde Sonen Jesus – skapade Gud himlar och jord.  Bibelns första vers är matematiskt fulländad i flera nivåer. Den består av 7 hebreiska ord och 28 (4 x 7) bokstäver:  bereshit bara Elohim et hashamaijm veet haarets.  Det mittersta ordet et består av två bokstäver, alef–tav, den första och sista bokstaven i det hebreiska alfabetet. Ordet et är en objektpartikel som indikerar att nästföljande ord, som är ”himlarna”, är objekt i satsen. I Upp 1:8 säger Jesus att han är alfa och omega, den första och sista bokstaven i det grekiska alfabetet, alltså motsvarigheten till alef–tav på hebreiska. Även om detta bara är en språklig grammatisk detalj i hebreiskan går det att göra tolkningen att Jesus även finns representerad mitt i Bibelns första vers, dessutom vid Guds sida – et följer direkt på Elohim (Gud). Intressant nog skrevs bokstaven alef ursprungligen som en bild av huvudet av en oxe. Oxen användes till syndoffer för hela folket. Offerdjuret (oxen) kombineras sedan med ett kors (ett kryss), det var så bokstaven tav ursprungligen skrevs.  Man kan se detta som tillfälligheter. Objektpartikeln förekommer otaliga gånger och tanken är inte att varje gång den används representeras Jesus. Men i Nya testamentets ljus kan man ana att det redan i Bibelns första vers, centralt placerad, finns en antydan om ”den förste och den siste” som en dag ska dö en försoningsdöd på korset.  ");
INSERT INTO swe_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Och Gud (Elohim) sa: ”Låt det bli ljus” – och det blev ljus över jordens yta. ");
INSERT INTO swe_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Och Gud (Elohim) betraktade ljuset: Ja emfas, det var gott (ändamålsenligt, vackert)! Och Gud skilde (separerade) ljuset från mörkret jordens rotation kom igång. ");
INSERT INTO swe_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gud (Elohim) kallade ljuset dag och mörkret kallade han natt. Det blev kväll och det blev morgon – en hel dag (dag ett – hebr. jom echad). Den första dagen beskrivs annorlunda än de övriga dagarna (som benämns en andra, en tredje, en fjärde, osv). I stället för ordningstalet ”första” används grundtalet ”ett” (hebr. echad). Ordet beskriver en enhet som utgörs av olika delar. En man och en kvinna är två enheter som tillsammans bildar ett kött (1 Mos 2:24). Uttrycket jom echad beskriver alltså en hel dag, ett dygn, som består av en period ljus och en period mörker. Det är samtidigt den första ”hela dagen” som beskrivs (från jordens perspektiv). Precis som på svenska kan ordet ”dag” (hebr. jom) betyda den ljusa delen av dygnet, ett helt dygn eller en del av en dag (t.ex. arbetsdag).  Frasen ”det blev kväll och det blev morgon” återkommer som en avslutning av de första sex dagarna, se vers 8, 13, 19, 23, 31. Att kvällen nämns före morgonen menar många ligger till grund för att en ny dag inom judendomen inleds på kvällen. I skapelseberättelsen inleder dock ljuset varje dag (förutom den första). Gud verkar när det är ljust, först därefter blir det mörkt (kväll) och dagen är fullkomnad när ljuset bryter fram (morgon) nästa dag.  Skapelsedagarna  Inget tidsintervall anges från det att universum skapas i begynnelsen i vers 1 fram till den första dagen, då Gud låter det bli ljus (vers 3). Solen och månen, som har uppgiften att markera dagar och tid, får den uppgiften den fjärde dagen, se vers 14.  Det finns åtminstone tre sätt som de sex skapelsedagarna kan förstås utifrån hebreiskan:  • Sex 24-timmars dygn som följer direkt efter varandra.  • Sex 24-timmars dygn, men dagarna följer inte varandra. Först kommer dag ett, en okänd tid passerar, sedan kommer en andra dag, osv.  • De sex dagarna är ett litterärt vackert sätt att beskriva det Gud gör i sex distinkta skeden och i en speciell ordning, men dagarna ska inte förstås som bokstavliga dygn även om de litterärt beskrivs som sådana.  Utöver dessa tre sätt förekommer också tanken att ordet dag (hebr. jom) avser en period av obestämd längd. När jom kombineras med prefixet be (bejom) finns den betydelsen ibland. Den vanligaste betydelsen är ”den dag” (138 ggr) och syftar på något som sker inom ramen av ett dygn (Jos 8:25). Vid ett trettiotal tillfällen är betydelsen en obestämd längd och inte en specifik dag, t.ex. en tid av nöd (Ps 77:3). Utöver det är bejom det uttryck som hebreiskan använder för ”när” eller ”om” (1 Mos 2:16, 17; 2 Mos 10:28; 3 Mos 14:57; Ps 20:10). Det är sammanhanget som avgör betydelsen. I skapelseberättelsen används inte bejom, utan endast jom och dessutom i kombination med morgon och kväll. Den naturliga tolkningen är därför att författarens avsikt var att beskriva vanliga dagar. Den sjunde dagen beskrivs som att den inte har ett slut (ingen kväll eller morgon) och skulle kunna fortsätta ännu. Det är korrekt, men de sex skapelsedagarna avslutas alla med ”det blev kväll och det blev morgon” vilket gör något av de tre alternativen ovan mer troligt. ");
INSERT INTO swe_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Och Gud (Elohim) sa: ”Låt det bli en utsträckning (någonting som expanderats, bretts ut och gjorts tunt – hebr. raqia) dvs. atmosfären, se vers 8 mitt i vattnet, som skiljer (separerar) vatten från vatten.” ");
INSERT INTO swe_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gud (Elohim) gjorde (hebr. asah) utsträckningen atmosfären. Och han skilde vattnet som var under utsträckningen från vattnet som var ovan (kom från) utsträckningen. Och det skedde så. ");
INSERT INTO swe_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gud (Elohim) kallade utsträckningen (det som gjorts tunt) himmel (hebr. shamajim). Det blev kväll och det blev morgon – en andra dag (hebr. jom sheni). Ordet ”utsträckning” är hebr. raqia, se vers 6-8 och 14-17. Traditionellt har ord som valv, fäste eller himlavalv använts, men ordet används för att beskriva något (oavsett material) som utvidgas, sträcks ut, görs tunt och expanderas. Verbet raqa används om att spänna ut en tältduk eller hamra ut en tunn plåt (2 Mos 39:3). Här i skapelseberättelsen beskriver ordet det som sträckts ut och kan appliceras på den tunna expansionen som vi kallar atmosfär.  Det hebreiska ordet för himmel är shamajim. Den sista delen (majim) är vatten. För den första delen (sha) finns olika teorier. Det kan komma från sham som betyder ”där” och då blir betydelsen ”vattnet där (uppe)”. En rabbinsk förklaring är att det kommer från ordet för eld (esh) och då blir himlen ”eld-vattnen” (som en beskrivning på en eldröd himmel när solen går upp eller ner). I hebreiskan står himmel alltid i dual-formen och översätts därför ibland som ”himlar”, se Ps 115:16. Himlen används om stjärnhimlen (1 Mos 15:5), himlen där fåglarna flyger och vindarna blåser (5 Mos 4:17) och platsen där Gud bor (1 Kung 8:30; 2 Kor 12:2). I grekiskan används både singular och plural, se Matt 6:9-10. ");
INSERT INTO swe_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Och Gud (Elohim) sa: ”Låt vattnet under himlen samlas till en plats, och låt torr mark bli synlig (framträda).” Och det skedde så. ");
INSERT INTO swe_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Och Gud (Elohim) kallade det torra land och det samlade vattnet kallade han hav. Och Gud (Elohim) betraktade det han åstadkommit: Ja emfas, det var gott (ändamålsenligt, vackert)! ");
INSERT INTO swe_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Och Gud (Elohim) sa: Låt jorden grönska (spira – hebr. dasha) av grönska (vegetation – hebr. deshe): fröbärande växter, fruktträd som bär (gör – hebr. asah) frukt enligt sitt slag (sin sort; klassificering – hebr. min) som har frö i sig utöver jorden. Och så blev det. ");
INSERT INTO swe_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ja, jorden frambringade grönska (vegetation) – fröbärande växter enligt sitt slag och träd som bär frukt enligt sitt slag. Vers 11 är formad som en kiasm där den första raden hör ihop med den sista, den andra med den näst sista, osv. Frasen ”Låt jorden grönska av grönska” hör ihop med ”utöver jorden”. I nästa nivå hör fröbärande växter ihop med frasen ”som har frö i sig”. Centralt står ”fruktträd som bär frukt enligt sitt slag”.  Hebr. deshe är ett generellt ord för grönska. Hebr. min kommer från en rot med betydelsen ”dela upp, portionera ut”, ordet används för den bibliska klassificeringen av växter och djur. Begreppet används såväl för stora huvudgrupper av djur som för specifika arter, se vers 11, 12, 21, 24 och 25. Se även 1 Mos 6:20. Att jorden (hebr. erets) grönskar innebär att marken nu får vegetation, men här ingår även alla vattenväxter i havet, se vers 9-10. Och Gud (Elohim) betraktade det han åstadkommit: Ja emfas, det var gott (ändamålsenligt, vackert)! ");
INSERT INTO swe_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Det blev kväll och det blev morgon – en tredje dag (hebr. jom shlishi). Detta är den enda dagen då Gud säger ”det var gott” två gånger, se vers 10 och 12. Inom judendomen anses just därför tisdagen, den tredje dagen, vara en extra bra dag att starta något nytt på. Judiska bröllop sker därför än i dag ofta på tisdagar. Jesus gick på ett bröllop i Kana, just på ”tredje dagen”, se Joh 2:1. Det finns en parallell symmetri mellan de tre första dagarna (dag 1-3) och de tre följande dagarna (dag 4-6):  • Ljus och tid – Första dagen fokuserar på ljuset och natt avskiljs från dag, tiden startar. Fjärde dagen tilldelas himlakropparna sin funktion som ljusbärare och tecken för dagar, månader och år.  • Vatten och luft – Andra dagen handlar om vattnet och atmosfären som bildar ett livsutrymme (luften). Femte dagen fylls vattnet och luften med liv.  • Torr mark – Tredje dagen träder marken fram och börjar grönska. Den sjätte dagen fylls den med liv. ");
INSERT INTO swe_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Och Gud (Elohim) sa: ”Låt ljusen (ljuskällorna, ljusbärarna – hebr. maor) på himlens (skyarnas) utsträckning (expansion – hebr. raqia) vara för att göra åtskillnad (separera) mellan dagen och natten, och de ska vara som tecken för att indikera sammankomster (särskilda tider, högtider – hebr. moadim) 3 Mos 23 och för dagar och år. ");
INSERT INTO swe_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ja, de ska vara som ljus (hebr. maor) på himlens utsträckning (himlavalvet), för att lysa över jorden”. Och det skedde så. ");
INSERT INTO swe_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Och Gud (Elohim) satte (tillförordnade – hebr. asah) de två ljusen, det större solen för att råda över dagen, och det mindre månen för att råda över natten – liksom stjärnorna gör. Himlakropparna som tidigare skapats (vers 1) tillskrivs nu sina uppgifter. Två olika hebreiska ord för att skapa/göra används i skapelseberättelsen:  • Bara används vid nya dramatiska skeden som när hela universum skapas (vers 1), när djurlivet börjar skapas (vers 21), när människan skapas (tre ggr i vers 26) och sist i berättelsens sista sammanfattande vers (1 Mos 2:3).  • Asah är vanligt i GT och används om att göra, tillverka eller placera/sätta något på ett visst sätt eller till en viss funktion. Men även för att färdigställa, ordna eller arrangera något, att insätta eller tillförordna någon/något i en uppgift eller funktion, vilket är betydelsen här, se vers 7, 11, 12, 16, 25, 26, 31 och 1 Mos 2:2. ");
INSERT INTO swe_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ja, Gud (Elohim) gav (hebr. natan) dessa solen, månen och stjärnorna på himlens utsträckning (himlavalvet) för att lysa över jorden ");
INSERT INTO swe_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","och för att råda över dagen och natten samt för att göra åtskillnad (separera) mellan ljuset och mörkret dagen och natten, se vers 14. Och Gud (Elohim) betraktade det han åstadkommit: Ja emfas, det var gott (ändamålsenligt, vackert)! ");
INSERT INTO swe_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Det blev kväll och det blev morgon – en fjärde dag (hebr. jom revii). Alla andra av skapelsens dagar namnger Gud det han gjort (dag 1-3, se vers 5, 8 och 10) eller välsignar (dag 5-6, se vers 22 och 28). Dag fyra sker inget av detta. Himlakropparna blir inte till, det enda som sker är att deras funktion proklameras. De ska tjäna skapelsen på jorden, inte vägleda genom stjärntecken och astrologi. De är inte heller gudar som ska tillbes, se 2 Kung 21:3.  Tid och rum  I början på 1900-talet formulerade Einstein relativitetsteorin där tiden är den fjärde dimensionen. Här i Bibelns första verser anar vi hur Gud kan stå utanför tiden och känna till slutet från början (Jes 46:10), och samtidigt finnas i tiden.  Himlakropparna är grunden för vår tidsuppfattning och tideräkning. Ett år är den tid som det tar för jorden att fullborda ett helt varv runt solen. En månad är den tid det tar för månen att snurra ett varv kring jorden. Ett dygn är den tid det tar för jorden att snurra ett varv runt sin egen axel. Att vi har en vecka på sju dagar är egentligen ologiskt, sju är inte delbart med antal dagar i vare sig en månad eller ett år. Trots detta har mänskligheten alltid använt sig av den bibliska sjudagarsveckan.  Det hebreiska ordet för år (shana. se vers 14) består av tre bokstäver (shin–nun–he) vars numeriska värde är 355 (300+50+5). I vår gregorianska solbaserade kalender är ett år 365 och 1/4 dagar. Ett normalår i den hebreiska kalendern har 355 dagar, vilket exakt motsvarar det numeriska värdet. Den hebreiska kalendern har tolv månader, men kompenserar för detta genom att lägga till en extra 13:e månad vart annat eller tredje år. Se även 2 Mos 12:2 för mer om månaderna. Substantivet vimlare (från verbet att vimla) talar om mångfalden av allt liv i haven, från plankton till stora fiskstim. Substantivet ”flygande varelser” (från verbet för att flyga) innefattar allt från insekter, fåglar till fladdermöss. De beskrivs från jordens perspektiv, när man tittar upp mot himlen. ");
INSERT INTO swe_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Och Gud (Elohim) sa: ”Låt vattnet vimla av vimlande levande varelser och låt flygande varelser flyga över jorden mot himlens utsträckning (ordagrant: på ansiktet av himlens utsträckning).” Skapelseberättelsen har ett ”jordiskt” perspektiv. Fåglarna ses från jorden, som när man tittar upp på flygande fåglar med ”himlen” som bakgrund. ");
INSERT INTO swe_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ja, Gud (Elohim) skapade (hebr. bara) de stora havsdjuren (hebr. tanin gadol), och alla levande rörliga varelser som vimlar i vattnet enligt sitt slag (sin sort; klassificering – hebr. min), på samma sätt varje bevingad flygande varelse, enligt sitt slag. Och Gud (Elohim) betraktade det han åstadkommit: Ja emfas, det var gott (ändamålsenligt, vackert)! ");
INSERT INTO swe_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Och Gud (Elohim) välsignade dem genom att säga: ”Var fruktsamma och föröka er och fyll vattnen i haven; och flygande varelser (fåglar, insekter) föröka er på (utöver) jorden.” ");
INSERT INTO swe_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Det blev kväll och det blev morgon – en femte dag (hebr. jom chamishi). När landdjuren beskrivs används tre olika hebreiska ord som beroende av vad de kontrasteras mot eller kompletteras med ska förstås på olika sätt. Alla tre kan användas för att beskriva allt djurliv på land:  • Chajah betyder ”levande” och används för djur i allmänhet. Det kombineras två gånger med jorden (hebr. chajat haarets). I vers 24 kontrasteras det mot boskapsdjuren (hebr. behemah) och ska därför förstås som de vilda djuren. Då används översättningen ”markens djur”. I vers 30 kontrasteras det mot himmelens flygande varelser och avser då alla landdjur. Då används översättningen ”allt levande på jorden”.  • Behemah beskriver boskapsdjur (tamdjur) om det kontrasteras till markens djur (vilda djur). Men är kontrasten till kräldjur och andra smådjur (hebr. remes) avses alla större djur på land och då används översättningen ”fyrfotadjur”. Om behemah kontrasteras till flygande varelser och fisk är betydelsen alla djur på torra land – landdjur.  • Remes betyder något som ”rör sig” ”krälar” eller ”kryper”. Det kan specifikt beskriva djur som rör sig eller krälar nära marken. Det syftar då på kräldjur, groddjur, små däggdjur, spindlar med mera. Men ordet kan även fungera som en sammanfattning av alla djur – allt som rör sig. Remes hör ihop med verbet ramas som betyder ”röra sig, slingra sig, kräla”. ");
INSERT INTO swe_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Och Gud (Elohim) sa: ”Låt jorden frambringa levande varelser enligt sitt slag: boskapsdjur (tamdjur – hebr. behemah) och kräldjur (smådjur – hebr. remes) och markens djur vilda djur enligt sitt slag.” Och det skedde så. ");
INSERT INTO swe_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ja, Gud (Elohim) gjorde (hebr. asah) markens djur vilda djur enligt sitt slag och boskapsdjuren tamdjur enligt sitt slag och allt som kryper (krälar, rör sig – hebr. remes) på marken enligt sitt slag. Och Gud (Elohim) betraktade det han åstadkommit: Ja emfas, det var gott (ändamålsenligt, vackert)!  Människan  Nu kommer berättelsens absoluta höjdpunkt: Människan ska skapas. Detta lyfts fram på flera sätt. Gud använder första person plural ”låt oss” när han talar. Det förekommer endast här i skapelseberättelsen. Samma sätt för Gud att tala förekommer bara två gånger till i Moseböckerna, även då när något utöver det vanliga sker, se 1 Mos 3:22; 11:7. En naturlig tolkning är att Gud talar med de andra personerna i treenigheten: Sonen och Anden (alternativt till hela det himmelska hovet, inklusive änglarna).  Till skillnad från alla djur skapas människan som Guds avbild. De två hebreiska orden tselem och demot används. Ordet avbild (hebr. tselem) kan avse fysiska avbildningar, t.ex. avgudabilder (4 Mos 33:52; Hes 7:20). Det avbilden representerade menade man var närvarande i avbilden, hans ande bodde där. Men ”avbild” används också om den funktion farao hade som representant för solguden Ra på jorden. Att människan skapas till Guds avbild – till Guds likhet – kan man förstå som att människan skapas för att fungera som Guds representant på jorden. Det är människan som ska råda över resten av skapelsen. Människan är en avbild av Gud även genom att hon är en andlig varelse, som Guds Ande kan bo i (Joh 4:24). Att avbild kombineras med ”till hans likhet” (hebr. demot) gör också att människan har en viss yttre likhet med Gud. Genomgående i Bibeln när någon ser Gud i en syn så beskrivs han som ”människolik” (han sitter på en tron, bär en mantel, osv), alla olikheter till trots. ");
INSERT INTO swe_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Och Gud (Elohim) sa: ”Låt oss göra (hebr. asah) människan (hebr. adam) som vår avbild (hebr. tselem), till att vara oss lika (påminna om oss – hebr. demot). Människan – man och kvinna tillsammans – ska fungera som Guds representant på jorden. De ska råda (ha auktoritet, ansvara) över havets fiskar och över himmelens flygande varelser och över landdjuren (hebr. behemah). Ja, över hela jorden och över alla rörliga varelser som rör sig på jorden allt djurliv.” ");
INSERT INTO swe_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ja, Gud skapade människan som sin avbild, som Guds avbild skapade han henne. Man och kvinna skapade han dem. ______ Denna vers utgör höjdpunkten i Guds skapelseverk. Vackert strukturerad i två bekräftande kiasmer slår den fast att människan (hebr. adam) skapas som Guds (hebr. Elohim) avbild och att människan, Guds avbild, utgörs av mannen och kvinnan tillsammans. Detta är helt unikt bland alla kända skapelseberättelser. Även den trefaldiga repetitionen av skapa (hebr. bara) gör denna vers till berättelsens höjdpunkt. I den första kiasmen ramar Gud in att han skapade människan som sin avbild. I den andra kiasmen är istället verbet skapar centralt, och det som utgör människan ramar in meningen:  Gud skapade människan  som sin avbild,  som Guds avbild  skapade han henne.  Man och kvinna  skapade han  dem. ");
INSERT INTO swe_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Och Gud (Elohim) välsignade dem. Ja, Gud (Elohim) sa till dem: ”Var fruktsamma, föröka er och uppfyll jorden. Lägg den under er använd dess resurser för att tjäna Gud och människor och råd (ha auktoritet) över havets fiskar och över himmelens flygande varelser och över allt levande som rör sig på jorden torra land.” ");
INSERT INTO swe_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Och Gud (Elohim) sa: ”Se lyssna; hebr. hinneh – ger betoning åt det som följer, jag ger er varje fröbärande växt på hela jorden och varje träd som har fröbärande frukt – åt er ska de bli som föda. ");
INSERT INTO swe_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ja, även för allt levande på jorden alla landdjur och för alla himmelens flygande varelser. Ja, för allt som rör sig på jorden som har livets anda i sig: varje grön växt är till föda.” Ja, så blev det. ");
INSERT INTO swe_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Och Gud (Elohim) betraktade allt som han hade gjort (hebr. asah) undersökte allt noggrant. Och se hebr. vehinneh – perspektivbyte, vi får betrakta skapelsen från Guds perspektiv: Mycket gott (helt perfekt, färdigt, komplett och fullbordat)! Detta är den enda dagen då något är mycket gott (hebr. tóv meód), jfr vers 10, 12, 18 och 21. Det blev kväll och det blev morgon – den sjätte dagen (hebr. jom ha-shishi). De första fem dagarna står i obestämd form: dag ett (vers 5), en andra dag (vers 8), en tredje dag (vers 13), en fjärde dag (vers 19), en femte dag (vers 23). Sedan bryts mönstret och bestämd artikel används: den sjätte dagen (vers 31) och den sjunde dagen (1 Mos 2:2, 3). Även på detta sätt sticker de två sista dagarna ut som speciella dagar. ");
INSERT INTO swe_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nu var himlarna och jorden fullbordade (färdiga) med hela dess härskara med allt som universum rymmer. Ordet härskara (hebr. tsava) beskriver en stor mängd. Ordet kan användas om stjärnor (5 Mos 4:19), änglar (1 Kung 22:19) och soldater i en armé (Dom 4:2). Eftersom inga änglar nämns i skapelsen (de antyds redan vara skapade, se Job 38:6-7) så avser ordet här allt skapat som fyller universum, från de minsta elementarpartiklar till de största av galaxer. ");
INSERT INTO swe_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ja, Gud (Elohim) var färdig den sjunde dagen med det arbete som han hade gjort (arbetat med; färdigställt – hebr. asah). Ja, han upphörde (avstod – hebr. shavat) den sjunde dagen med allt arbete som han hade gjort (hebr. asah). ");
INSERT INTO swe_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Och Gud (Elohim) välsignade den sjunde dagen. Ja, han helgade (avskilde) den för på den hade han upphört (hebr. shavat) med allt arbete som Gud (Elohim) hade skapat (hebr. bara) för att färdigställa (för att göra – hebr. asah).  Sabbaten  Den första dagen i judiska kalendrar är söndag. Den kallas jom rishon (dag ett). Sedan fortsätter veckan med jom sheni (dag två), jom shlishi (dag tre), jom revii (dag fyra), jom chamishi (dag fem) och jom shishi (dag sex). Den sjunde dagen (lördagen) bryter mönstret och kallas inte jom shevii (dag sju), istället används bara ordet shabbat. Det är en dag då människans arbetande ”ska upphöra”. Sabbaten instiftas inte här, men när den nämns bland budorden refereras till de sex skapelsedagarna och att arbetet sedan upphörde den sjunde dagen, 2 Mos 20:9-11. Sabbaten, och vad som räknas som arbete eller inte, var något som ofta diskuterades på Jesu tid, se Mark 2:27; Matt 12:10-12, och än idag bland rabbiner. ");
INSERT INTO swe_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Här inleds den andra övergripande litterära enheten i och med att toledot-formeln används första gången, se 1 Mos 5:1; 6:9; 10:1; 11:10, 27; 25:12, 19; 36:1, 9; 37:2 och bokens inledning. Denna nya enhet är litterärt starkt sammanlänkad till skapelseberättelsen på flera sätt:  - De tre huvudord som avslutar skapelseberättelsen – skapa (hebr. bara), Gud (Elohim) och färdigställa (hebr. asah) – återkommer direkt i den första meningen, men i varierad ordning (jfr 1 Mos 2:3 och 1 Mos 2:4).  - Den inledande meningen i bägge berättelser har sju ord (jfr 1 Mos 1:1 och 1 Mos 2:4).  - Liksom i skapelseberättelsens första mening förekommer ”himlar och jord”, men nu varierat, skrivet i omvänd ordning och utan bestämd artikel.  - Bägge berättelserna inleds med samma allitteration (två ord som börjar på samma bokstav, i detta fall b): bereshit bara, respektive behibaram bejom.  - Ordet dag är ett centralt begrepp i skapelseberättelsen, det finns också i den första meningen som bejom som ordagrant är ”den dag”. I det här sammanhanget har bejom betydelsen ”när” på svenska.  - Det enda ord som inte förekommer i skapelseberättelsen är Guds personnamn JHVH. Här i Edenberättelsen specificeras att den Gud som avses verkligen är JHVH och ingen annan. Båda berättelsernas introduktioner har många likheter. Först finns ett konstaterande vad gäller tid ”i begynnelsen” (1 Mos 1:1) och ”vid skapandet av dem” (vers 4b), alltså under den pågående processen. Sedan beskrivs situationen i något negativa termer ”men jorden var öde och tom” (1 Mos 1:2a) och ”men ännu var inte all vegetation där och det hade inte regnat” (vers 5). Sist kommer en positiv avslutning ”Guds Ande hovrade över vattnen” (1 Mos 1:2b) och ”ett flöde steg upp från jorden och vattnade den” (vers 6).  Denna första toledot-enhet består av två huvuddelar som har samma tema: Edenberättelsen (kap 2–3) och Historien om Kain och Abel (kap 4). Här ges bakgrunden till hur världen kan se ut som den gör i dag om Gud är både allsmäktig och god. Människan valde att inte följa Guds goda föreskrifter utan valde istället olydnadens väg med de följder som synden alltid får: skadade eller förstörda relationer till Gud, andra människor och naturen. Men i allt detta lyser Guds oförtjänta nåd igenom och löftet om en frälsare lyser starkt i mörkret.  Edenberättelsen är ingen andra skapelseberättelse även om människans skapelse nu beskrivs mycket mera detaljerat än i den övergripande skapelseberättelsen. Att författaren återvänder i tid till något som föregår vad som redan beskrivits förekommer även i Noas söners fortsatta historia (1 Mos 10:1-11:9) som först beskriver hur mänskligheten spridits ut över jorden varefter det i 1 Mos 11 konstateras att alla människor fortfarande bodde i samma område. Genom berättelsen om Babels torn i kapitel 11 ges orsaken till den situationen som beskrivits i kapitel 10. Detta är den fortsatta historien (berättelsen – hebr. toledot) om himlarna och jorden. Vid skapandet (hebr. bara) av dem – när Herren Gud (Jahveh Elohim) färdigställde (höll på att göra, insätta, organisera – hebr. asah) jord och himlar, ");
INSERT INTO swe_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","men innan alla fältets växter (buskar; träd; vild vegetation – hebr. siach) ännu fanns på jorden. Ja, innan alla fältens gröna grönska för föda till djur och människor ännu hade sprungit upp, för Herren Gud (Jahveh Elohim) hade ännu inte låtit det regna över (ovanifrån och ner på – hebr. al) jorden, och det fanns ingen människa som kunde bruka marken (jordens mylla). ");
INSERT INTO swe_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Men underjordiska vattenkällor höjde sig i marken (dimma steg upp från marken) och vattnade hela ytan (ansiktet) av marken (jordens mylla). Det första hebreiska ordet ed används bara här och i Job 36:27 där det är dimma/moln. Den grekiska översättningen Septuaginta översätter med källa/flöde. Det nämns inte att det regnar på jorden förrän i 1 Mos 7:12. Klimatet var alltså annorlunda än nu på jorden, vilket kan förklara varför människorna levde längre och förekomsten av stora djur som dinosaurier. Kanske kan det liknas vid ett stort växthus. Den närmsta klimatzonen som har några av dessa karaktärsdrag i vår tid är Redwoodskogen i norra Kalifornien. De tusenåriga träden där är över 100 meter höga. Anledningen till det gynnsamma klimatet är den ihållande dimman från Stilla havet som kyler träden under sommaren och minskar avdunstningen. ");
INSERT INTO swe_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Herren Gud (Jahveh Elohim) formade (designade, skulpterade – hebr. jatsar) människan (hebr. adam) av stoft (material) från jorden (hebr. adamah) och andades in livsande i hennes näsa, och människan blev en levande varelse (själ – hebr. nefesh). Det hebreiska ordet för människa, adam, är snarlikt ordet för jordens mylla, adamah. Människans kropp formades från redan skapat material och får också del av Guds livsande. Det hebreiska ordet nefesh, här översatt ”levande varelse”, beskriver helheten med betoning på det inre livet och människans själ. Samma hebreiska ord används även om djur, se 1 Mos 1:20, 21, 24, 30. Den hebreiska betydelsen av själ skiljer sig från den grekiska filosofiska tanken om en odödlig själ skild från kroppen, som beskrivs i Platons och Aristoteles antika skrifter.  Guds skaparhand är synlig i skapelsen och människan. Jordens yta består till 70% av saltvatten. Samma proportioner återfinns hos människan. Ett nyfött barn består till 80% av vatten och en vuxen människa 60%, och det är också salt.  Ordet för liv är chajim. Det är plural men böjs som singular, precis som orden för vatten, himmel och ansikte. Exakt varför dessa ord skrivs så är inte fastlagt. En teori är att det är ett sätt i hebreiskan att visa att allt som finns i ordet inte kan rymmas i singular. Vattnet kan vara stilla eller storma, varje solnedgång är unik och ansiktet är inte statiskt med bara en form. På samma sätt är det med livet, det har olika skiften och skeenden. ");
INSERT INTO swe_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Herren Gud (Jahveh Elohim) planterade en trädgård (fruktträdgård) i Eden betyder behaglig, lustfylld, åt öster, och där satte han människan som han hade format (designat, skulpterat). ");
INSERT INTO swe_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Herren Gud (Jahveh Elohim) lät alla slags träd, ljuvliga (tilltalande) att se på och goda (perfekt anpassade) som mat, växa upp ur marken, också livets träd Upp 2:7; 22:2, 14, 19 mitt (centralt) i trädgården och kunskapens träd – gott och ont. Bland alla träd nämns speciellt två träd, kunskapens träd och livets träd. Ordet för kunskap kommer från verbet att veta, känna och ha en intim kunskap (hebr. jada). Substantivets betydelse är alltså att känna till eller kunna göra olika saker. Det används t.ex. för att uttrycka att Esau var en skicklig jägare: Han ”kunde” jakt (1 Mos 25:27). Det mest troliga är inte heller att det handlar om att kunskap kan användas till både bra och dåliga saker. Gott och ont kan förstås som en merism, två ytterligheter som uttrycker en helhet. I så fall går det att förstå kunskapens träd – gott och ont i betydelsen att man ska kunna göra, klara av, vad som helst – allt. Det går också att förstå det som ett träd som innebär ett val. När kunskapens träd – gott och ont nämns är det första gången ordet ”ont” förekommer. Människan står inför ett val, ska hon välja gott eller väljer hon ont? Kunskapens träd nämns bara här och i vers 17 där funktionen primärt verkar vara att ge Adam och Eva ett sätt att visa sin lydnad mot Gud.  Livets träd däremot nämns här och 1 Mos 3:22, 24. I Ordspråksboken används det bildligt för något som ger liv (Ords 3:18; 11:30; 13:12; 15:4) medan referenserna i Uppenbarelseboken handlar om ett nyskapat Eden (Upp 2:7; 22:2, 14, 19). Mitt i behöver inte betyda exakt ”mitten” rent fysiskt utan kan också ha betydelsen att det är något ”centralt” i skapelsen. ");
INSERT INTO swe_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Och en flod rinner från Eden hela området där trädgården fanns hette också Eden för att vattna trädgården och därifrån delas den och blir till fyra källflöden. Man kan förstå det som att fyra floder förenas i området Eden och blir en enda flod när den rinner genom trädgården Eden. ");
INSERT INTO swe_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Den första heter Pishon betyder: tillväxt, det är den som flyter runt (meandrar, slingar sig omkring – hebr. savav) hela landet Havila (hebr. Chavila), där det finns guld, ");
INSERT INTO swe_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","och landets guld är gott (vackert, av hög kvalité). Där finns också bdelliumharts antagligen en sorts vitaktig pärla och onyxsten ädelsten. Guld är den första metallen som nämns i Bibeln. Här även tillsammans med ordet för gott (hebr. tóv). Sedan skapelsen är guld det första som kallas gott, se 1 Mos 1:4, 10, 12, 18, 21, 25, 31. Genom alla tider har just guld ansetts vara den mest värdefulla metallen. I 4 Mos 11:7 jämförs färgen på mannat, som troligtvis var vitaktigt, med bdelliumharts. ");
INSERT INTO swe_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Den andra floden heter Gichon betyder: bryta, välla fram, det är den som flyter runt (meandrar) hela landet Kush. Senare i GT syftar Kush på området i övre Nilen (nuvarande Etiopien/Sudan), här syftar det troligen på kassiternas land i Mesopotamien öster om Tigris. ");
INSERT INTO swe_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Den tredje floden heter Chideqel betyder: snabb; det grekiska namnet är ”Tigris”, det är den som har sitt lopp öster om Assyrien (Ashor). Den fjärde floden är Eufrat betyder: fruktsam, flöda över, ge i överflöd. ");
INSERT INTO swe_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Herren Gud (Jahveh Elohim) tog mannen och placerade honom (satte honom på en permanent boningsplats) i Edens trädgård, för att bruka (arbeta) den och bevara (underhålla, skydda) den. ");
INSERT INTO swe_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Herren Gud (Jahveh Elohim) gav denna befallning den första föreskriften till mannen genom att säga: ”Av alla trädgårdens träd får du verkligen äta infinitiv absolutus – med säkerhet äta, ");
INSERT INTO swe_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","men kunskapens träd – gott och ont – får du inte äta av, för om (hebr. bejom) du äter av det kommer du sannerligen att dö infinitiv absolutus – döden dö, med all säkerhet dö.” I vers 16 finns det positiva budet att äta från alla andra träd – som är en förutsättning för att ”leva livet levande”. I vers 17 finns undantaget. Gud tvingar ingen till gemenskap med honom, därför måste kunskapens träd (vers 9) finnas där så att människan kan göra ett aktivt val för eller emot livet, se även 5 Mos 30:15, 19. I hebreiskan dubbleras verben äta och dö. Ordagrant står det ”att äta du ska äta” och ”dö ska du dö”. Konstruktionen förstärker att människan verkligen fritt får äta. Det går också att se det dubbla behovet av både andlig och fysisk mat, jfr Matt 6:11; Joh 4:32. Död har en andlig och fysisk aspekt. Paulus skriver hur skapelsen är lagd under förgängelsen, se Rom 8:20. När Adam äter av kunskapens träd dör han en andlig död, som även får konsekvenser för hans fysiska kropp som blir dödlig. Fram tills nu har allting varit gott eller mycket gott. För första gången är nu något ”inte bra”, och det är Adams brist på en kompanjon. ");
INSERT INTO swe_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Herren Gud (Jahveh Elohim) sa: ”Det är inte gott ändamålsenligt, optimalt, som sig bör att mannen ska vara ensam, jag vill göra (hebr. asah) en hjälpare (hebr. ezer) anpassad för honom.” Sista frasen (hebr. ezer kenegdo) beskriver en hjälpare vid hans sida. Hebr. ezer har innebörden att komma till någons hjälp och att assistera. Det behöver inte beskriva hierarki, Gud själv kallas Israels hjälpare i Hos 13:9, se även 5 Mos 33:7. Här beskrivs ett partnerskap mellan en man och en kvinna. Samma fras återkommer i vers 20. ");
INSERT INTO swe_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Av jord formade (skulpterade, designade – hebr. jatsar) Herren Gud (Jahveh Elohim) alla fältets djur och alla himlens flygande varelser, och förde dem till mannen för att se vad han skulle ge dem för namn. Hebr. kol som översätts ”alla” kan också innebära en mängd eller många. Det namn mannen gav varje levande varelse blev dess namn. ");
INSERT INTO swe_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Och mannen gav namn åt alla boskapsdjur, alla himlens flygande varelser, och alla vilda djur på fältet. Men för mannen fanns ingen hjälpare anpassad för honom. ");
INSERT INTO swe_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Då lät Herren Gud (Jahveh Elohim) en tung sömn falla över mannen – och han sov. Och han tog en del från hans sida (hebr. echad tsela) och slöt till kött efter den. Ordet tsela betyder sida och används om sidan av en byggnad eller struktur (2 Mos 26:20; 27:7; 38:7; Hes 41:5, 6). Ofta är det något med plankor som är ihåligt. Enligt den grekiska filosofen Platon (428-348 f.Kr.), och även senare judisk tradition, sägs att människan skapades androgyn, och sedan delades upp i man och kvinna. Men det är inte vad denna vers lär. Det är även tydligt i 1 Mos 1:27 där det står: ”Man och kvinna skapade han dem”. Ordet sida här syftar på en ospecificerad del på mannens sida. Utifrån vers 23, där mannen säger ”ben av mina ben” och ”kött från mitt kött”, är det inte så långsökt att det är ett revben, men då inte bara benet, utan också köttet runt som avses. ");
INSERT INTO swe_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Och Herren Gud (Jahveh Elohim) byggde upp (modellerade skickligt – hebr. bana) sidan som han tagit från mannen till en kvinna, och han förde henne till mannen. Fyra olika hebreiska ord används kring skapandet av människan: asah (1 Mos 1:26), bara (1 Mos 1:27), jatsar (1 Mos 2:7, 19) och bana här. Både man och kvinna är Guds avbild, se 1 Mos 1:27. ");
INSERT INTO swe_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Då sa mannen (hebr. ha-Adam): ”Denna (hon) – äntligen (till sist)! Ben av mina ben, kött (kropp) från mitt kött (min kropp). Hon (denna) ska kallas kvinna (hebr. ishah) det hebreiska ordet för man/make är ish, för av man (hebr. ish) är hon (denna) tagen.” För första gången beskrivs vad en människa säger i Bibeln, och det är ett utrop i glädje över gemenskapen mellan en man och en kvinna! Det hebreiska ordet för man/make beskriver med sin maskulina form en individ av mankön, medan ishah beskriver en individ av honkön, och då också kan avse en hustru. Själva ordet ish avser en individ. ");
INSERT INTO swe_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Därför ska en man lämna sin far och sin mor ”lösa upp” sitt känslomässiga (och även ekonomiska) beroende av dem och hålla sig till (ansluta sig till, bli sammanförd med) sin hustru (kvinna), och de ska bli ett kött (hebr. basar echad) en förenad kropp – en ny familjeenhet. Jesus citerar denna vers när han talar om Guds plan för äktenskapet, se Matt 19:4-5. Äktenskapet är av Gud ämnat för en man och en kvinna – från två olika familjer – för hela livet. Texten beskriver något som upplöses, förenas och får publikt erkännande. Att lämna (hebr. azab) och att hålla fast (hebr. dabaq) är termer som ofta används vid förbund, se 5 Mos 28:20; Hos 4:10. Äktenskapet är inte bara en privat angelägenhet utan en institution som också involverar omgivningen. Ceremonier, ringar och löften inför vittnen är viktiga beståndsdelar i ett bröllop.  I denna kultur var det, liksom i de flesta andra genom historien, kvinnan som lämnade sin familj och rent fysiskt flyttade till mannens hus (ofta i anslutning till hans familj och hans släktingar). Denna bibeltext visar på Guds sätt att se på ansvarstagande. Mannen, som historiskt sett ofta haft fördelar och privilegier i samhället, uppmanas här därför att lämna det som varit bakom – hans fru ska bli hans närmaste släkting och de ska bilda en helt ny familj. ");
INSERT INTO swe_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","De var båda oskylda (oskyldiga, nakna – hebr. aróm), mannen och hans kvinna, och de skämdes (blygdes) inte inför varandra. ");
INSERT INTO swe_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Men ormen var listig (hebr. arom) 1 Mos 2:25, mer än alla markens djur som Herren Gud (Jahveh Elohim) hade gjort (hebr. asah). Författaren leker med olika ord som låter nästan lika men betyder olika saker. Här är det oskyld (hebr. aróm) och listig (hebr. arom). Senare (vers 7) används ytterligare ett snarlikt ord för naken (hebr. eróm) men till skillnad från aróm, som innebär att vara oskyldigt oskyld, hör eróm ihop med skam, att vara blottad. Han sa till kvinnan: ”Har Gud verkligen sagt att ni inte får äta av alla träden i trädgården?” Det är uppenbart att det inte är en vanlig orm, utan en representant för den Onde, se Upp 20:2. ");
INSERT INTO swe_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kvinnan sa till ormen: ”Vi får äta frukterna från träden i trädgården, ");
INSERT INTO swe_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","men om frukten från trädet mitt i trädgården har Gud (Elohim) sagt: Ni ska inte äta av det, inte heller ska ni röra det, då dör ni.” Gud hade sagt att de fick äta fritt av alla träd utom ett, se 1 Mos 2:16-17. Eva lägger till att de inte ens får röra trädet. ");
INSERT INTO swe_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Då sa ormen till kvinnan: ”Ni ska verkligen inte dö infinitiv absolutus. ");
INSERT INTO swe_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nej (hebr. ki – ger emfas), Gud (Elohim) vet att om ni äter av den så kommer era ögon att öppnas och ni blir som Gud (Elohim) – som förstår har kunskap om gott och ont.” De kan göra allt, inklusive ta egna beslut om vad som är rätt och fel. Ordagrant: ”bli som Gud kunnande/vetande gott och ont”. Man kan förstå ”gott och ont” som en merism som uttrycker ”allt” eller ”vad som helst”. Ormen hävdar att de ska bli kvitt sin mänskliga begränsning och kunna göra allt det som Gud kan, inklusive själva kunna besluta om vad som är gott och ont, utan att behöva bry sig om vad Gud säger. ");
INSERT INTO swe_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","När kvinnan såg att trädet hade frukt som var gott (väl lämpat för) att äta och det var behagligt (attraktivt, en lust) för ögonen, och att det var ett begärligt (önskvärt, lockande) träd eftersom man skulle få förstånd (insikt), tog hon av dess frukt och åt. Hon gav också till sin man som var alldeles intill och han åt också. I denna vers finns fyra verb: såg, tog, åt och gav. Synintrycken (såg ut att vara gott och den yttre attraktionen) tillsammans med de inre känslorna (löftet om att ge högre förstånd) ledde till ett ödesdigert beslut, se Jak 1:15; 1 Joh 2:16. Sökandet av vishet utan Gud har också att göra med stolthet, se Ords 11:2. Ordet för begärligt är samma som används i förbudet mot begär, se 2 Mos 20:17. ");
INSERT INTO swe_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Då öppnades båda deras ögon, och de förstod (insåg – hebr. jada) att de var nakna. De band ihop (flätade, sydde) löv (grenar) från fikonträd som gördlar för att täcka livet. Människans försök att i egen kraft täcka sin egen nakenhet räcker inte i längden, löven vissnar, så Gud ger dem kläder att bära, se vers 21. ");
INSERT INTO swe_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","De hörde Herren Gud (Jahveh Elohim) vandra (röra sig) i trädgården när det började bli kväll (vid kvällsbrisen). Mannen och hans kvinna gömde sig för Herren Guds (Jahveh Elohims) närvaro (ansikte) bland träden i trädgården. ");
INSERT INTO swe_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Herren Gud (Jahveh Elohim) kallade på Adam (människan) och sa till honom: ”Var är du?” Gud som är allvetande, vet mycket väl var människan gömmer sig. I denna berättelse blir det tydligt att Gud söker en relation och dialog med människan. ");
INSERT INTO swe_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Han svarade: ”Jag hörde din röst (vinden; hörde ljudet när du rörde dig) i trädgården, men jag blev rädd eftersom jag var naken, så jag gömde mig.” ");
INSERT INTO swe_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Då sa han: ”Vem har berättat (upplyst er om) att ni är nakna? Ordet naken har samma hebreiska rot som ordet för listig, se 1 Mos 3:1. Åt ni från trädet som jag förbjöd er att äta från?” 1 Mos 2:16-17 ");
INSERT INTO swe_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mannen svarade: ”Kvinnan som du har satt vid min sida, hon gav mig frukt från trädet, och jag åt.” ");
INSERT INTO swe_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Då sa Herren Gud (Jahveh Elohim) till kvinnan: ”Vad är det du har gjort?” Kvinnan svarade: ”Ormen lurade (bedrog, förledde) mig, och jag åt.” Namnet Adam betyder människa och Eva betyder liv. Översätter man betydelsen av namnen blir Guds fråga i vers 9: ”Människa, var är du?” och människornas sammanfattade svar i de följande verserna: ”Livet bedrog mig”. ");
INSERT INTO swe_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Herren Gud (Jahveh Elohim) sa till ormen: ”Eftersom du har gjort detta är du fördömd (ständigt förbannad) mer än alla boskapsdjur, och alla vilda djur på fältet. På din buk ska du kräla (gå), och du ska äta stoft det som finns på marken så länge du lever. ");
INSERT INTO swe_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Jag ska sätta fiendskap mellan dig och kvinnan och mellan din avkomma (säd, barn, släkte – hebr. zera) och hennes avkomma (säd, barn, släkte), han Jesus ska attackera (trampa, krossa) ditt huvud och du ska ligga på lur och attackera hans häl orsaka Jesu lidande.” Innan Gud fortsätter med domen till Adam och Eva ger han hopp om att ondskan ska krossas. Att det står kvinnans säd, och inte mannens säd, antyder också Jesu jungfrufödsel. Denna vers brukar kallas protoevangelium. Detta är en sammansättning av två grekiska ord, protos som betyder ”först” och evangelion som betyder ”goda nyheter” eller ”evangelium”. Se även Upp 12:5 där det motsvarande grekiska ordet för hebreiska zera används. ");
INSERT INTO swe_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Han sa till kvinnan: ”Jag ska öka din (fysiska och emotionella) möda när du är havande, i smärta ska du föda dina barn. Och till din man är din åtrå (längtan; den du sträcker dig efter), men han ska råda över dig.” Det hebreiska ordet för åtrå/längtan teshoqa används bara tre gånger i GT, se 1 Mos 4:7 och Höga V 7:10. Ordet betyder ”att sträcka sig efter något”, och kan ibland ha en sexuell innebörd, som i Höga Visan, medan ordets mer generella och sensuella innebörd finns i 1 Mos 4:7. ");
INSERT INTO swe_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Och till mannen sa han: ”Därför att du lydde din kvinnas ord och åt av trädet, som jag hade befallt dig att inte äta av, därför är marken fördömd (förbannad) på grund av dig. I (fysisk och emotionell) möda ska du äta av dess frukt så länge du lever. ");
INSERT INTO swe_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Törne och tistel ska den producera åt dig, och du ska äta markens grödor (växter). ");
INSERT INTO swe_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Med svettig panna (efter hårt arbete) ska du äta ditt bröd tills du återvänder till jorden (hebr. adamah), för från den var du tagen. Du är stoft, och till stoft ska du åter gå.” ");
INSERT INTO swe_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mannen kallade sin kvinna Eva betyder livskälla, den som lever för hon var mor till allt levande. ");
INSERT INTO swe_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Och Herren Gud (Jahveh Elohim) gjorde kläder (tunikor, heltäckande kläder, långa kappor) av skinn åt Adam och hans kvinna (hebr. ishah). Ja, han klädde dem. 1 Mos 3:7 Det är oklart exakt hur kläderna såg ut, men ordet ”kläder” beskriver något som är heltäckande. Samma ord används nästa gång i 1 Mos 37:3 om Josefs speciella ”fotsida dräkt” som han fick av sin far Jakob. Denna klädnad av skinn som Gud ger Adam och Eva, där ett djur blivit offrat, ger också en föraning om offertanken där djur kommer att täcka människors synd och skuld. Det pekar också fram mot Jesu offer som fullständigt täcker människans synd. ");
INSERT INTO swe_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Herren Gud (Jahveh Elohim) sa: ”Betänk (hebr. hen), människan har blivit som en av oss vad gäller att förstå ha kunskap om gott och ont kan göra vad som helst. Och nu: vad händer om hon kommer att sträcka ut sin hand och även ta från livets träd. Och äta. Och leva för evigt.” Man kan förstå ”gott och ont” som en merism för ”vad som helst” – allt, se vers 5. Människan har demonstrerat sin villighet att välja det onda. Hur skulle det bli om hon i detta tillstånd skulle äta av livets träd och leva för evigt – i synd och uppror. ");
INSERT INTO swe_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Så Herren Gud förvisade människan från Edens trädgård och lät henne bruka jorden från vilken hon var tagen. ");
INSERT INTO swe_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","När han drev ut människan, satte han keruberna änglar och det flammande svärdet ett svärd som rörde sig från sida till sida på den östra sidan om Edens trädgård för att vakta vägen (hebr. derech) till livets träd. Här är första gången ordet derech används. Det beskriver en fysisk väg/vandringsväg, men används även som en metafor om den personliga vägen genom livet, inklusive alla livsval och sätt vi gör saker på. Här ”stänger” Gud vägen till livets träd. Det är intressant att Jesus kallar sig ”vägen och sanningen och livet” (Joh 14:6). Han är den som öppnar upp vägen tillbaka till Gud. De första kristna kallades också ”vägen”, se Apg 9:2. ");
INSERT INTO swe_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Men mannen hade känt (haft sexuellt umgänge med – hebr. jada) Eva, sin kvinna. Och hon blev gravid och födde Kain (hebr. Qajin) betyder: jag har förvärvat. Då sa hon: ”Jag har förvärvat (fått – hebr. qanah) en man med Herrens hjälp.” Verbet harah betyder att bli eller vara gravid. Även om ordet är en egen rot finns en koppling till substantivet har som betyder berg. Det uppenbara är att den gravida magen ser ut som ett berg. Dock finns även en annan koppling till orden. I hebreiska tankevärlden är ett berg inte något som är högt, ett berg är mycket av något som samlats. Ett berg synonymt med en stor grupp människor (Jer 51:25), eller till och med gudar (Jes 14:13). Denna tanke finns även med i att bli med barn, det blir en ny grupp människor. ");
INSERT INTO swe_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Och hon fortsatte genom att föda hans bror Abel (hebr. Hevel – betyder vindpust/meningslöshet). Abel vallade får (blev fåraherde) medan Kain brukade marken (blev en jordbrukare). Förutom Kain, Abel och deras tredje son Set, fick de många söner och döttrar, se 1 Mos 5:3-4. Det hebreiska namnet Kain låter nästan likadant som det hebreiska qanah, som betyder köpa, få och skapa. Här är ett exempel på en ordlek då båda dessa ord används i vers 1. Abel betyder andetag, dimma, rök – dvs. något kort och flyktigt. Förutom den bokstavliga betydelsen finns även meningslöshet, fåfängligt och tomhet i ordet, se Pred 1:2. Kanske Eva var missmodig efter första sonen som inte visade sig vara löftet i 1 Mos 3:15. En annan möjlig etymologi är att ordet anknyter till det Akkadiska Ap/blu som betyder son. ");
INSERT INTO swe_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Då tiden var inne. Ordagrant ”vid dagarnas slut” eller ”en tidsperiods slut”, kan syfta på skördetiden eller årets slut. Då bar Kain fram ett offer till Herren av markens frukt. ");
INSERT INTO swe_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel bar också fram den förstfödda av sin hjord, den bästa delen (de feta delarna). Herren såg med välvilja till (respekterade, tog emot) Abel och hans offer, ");
INSERT INTO swe_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","men inte till Kain och hans offer. Då blev Kain väldigt arg, och han sänkte blicken (hans yttre uttryck föll, han blev deprimerad). Anledningen till att Gud inte tog emot Kains offer var att det inte skedde i tro, se Heb 11:4. Abel offrade det bästa han hade, medan det verkar som om Kain inte gjorde det. Kains hjärta och motiv var inte rätt. I Jes 1:10-20 är det uppenbart att Gud hatar religiöst hyckleri. På ett symboliskt och profetiskt plan talar Abels blodsoffer också om att bara Jesu blod kan rena från synd. ");
INSERT INTO swe_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Och Herren (Jahveh) sa till Kain resonerar i kärlek med honom, vill få honom att ändra sitt hjärta: ”Varför är din vrede upptänd, ja varför har ditt ansikte fallit? ");
INSERT INTO swe_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Är det inte så att om du gör rätt (gott) är det ditt ansikte upplyft, men om du inte gör rätt, då lurar (väntar, ligger) synden vid dörren som ett vilddjur. Ja, den åtrår (längtar, sträcker sig efter) att dominera dig, men du måste råda (regera) över den.” ");
INSERT INTO swe_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Men Kain talade med (blev vred på – hebr. amar) Abel, sin bror. Och det hände medan de var ute på fältet. Kain reste sig upp mot Abel, sin bror. Och han dräpte (slaktade – hebr. harag) honom. Versen inleds med ”Och Kain sa”, dock följer inte vad han säger, så t.ex. den grekiska översättningen Septuaginta lägger till frasen ”Låt oss gå ut till fältet”. Dock inleds den andra raden med vajehi som är en markör för ett nytt avsnitt eller en avslutning. Behåller man förståelsen ”talade med” får man veta att Kain talade med Abel, men inte vad han sade. Det kan vara en teknik (som bibliska författarna använder sig av i andra sammanhang) som kallas ”gap”. Ett gap är något jag som läsare vill veta, men författaren avslöjar det inte. Det väcker nyfikenhet och inbjuder till tolkningsmöjligheter. Vad sa de till varandra? Bad de om förlåtelse? Grälade de? Hade de teologiska diskussioner? Läsaren får inga svar, men nyfikenheten väcks. Ett annat sätt att tolka verbet amar är att Kain håller utkik efter Abel. En tredje möjlighet är att verbet är polart och kan betyda såväl prisa, ära som även förakta eller vara arg på, vilket skulle kunna passa i sammanhanget. ");
INSERT INTO swe_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Och Herren (Jahveh) sa till Kain: ”Var är din bror Abel?” Han svarade: ”Jag vet inte! Är jag min brors beskyddare (ska jag ta hand om honom)?” ");
INSERT INTO swe_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Då sa Herren (Jahveh): ”Vad har du gjort? Din brors blod ropar till mig från marken. ");
INSERT INTO swe_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Du är nu fördömd (förbannad) från marken, som har öppnat sin mun för att ta emot din brors blod från din hand. ");
INSERT INTO swe_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","När du försöker bruka marken ska den inte längre ge goda skördar. Du ska bli ostadig (instabil) och ständigt vandra från plats till plats på jorden.” ");
INSERT INTO swe_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Då sa Kain till Herren (Jahveh): ”Min skuld (missgärning; straff på grund av synd – hebr. avon) är större än vad jag kan bära (lyfta upp – hebr. nasa). ");
INSERT INTO swe_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Betänk (hebr. hen), eftersom du idag har fördrivit mig från jordens ansikte och jag måste vara dold från ditt ansikte (din närvaro), kommer jag att vara en rastlös vandrare på jorden, vem som helst som finner mig ska dräpa mig.” ");
INSERT INTO swe_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Men Herren (Jahveh) sa till honom: ”Om det inträffar att någon dräper (avrättar) Kain ska han bli hämnad sju gånger.” Ja, Herren (Jahveh) satte ett tecken (märke) på Kain så att den som fann honom inte skulle slå ner honom. Tecknet kan också vara ett löfte, se Jos 2:12. ");
INSERT INTO swe_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Därefter lämnade Kain Herrens (Jahvehs) ansikte (närvaro) och bodde i vandrarnas land (i exil), öster om Eden. Här används den feminina formen för öster (hebr. kedem). Det är ett rikt ord som inte bara har betydelsen av ett väderstreck utan också används för att beteckna när en människa gör bokslut i sitt liv och ser både bakåt och framåt. Detta är en plats där Kain har möjlighet att tänka över sitt liv och göra upp med sig själv kring det som inträffat. Detta ord erbjuder också en möjlighet till en ny start. Nu följer en släktlista för Kain i sju led. ");
INSERT INTO swe_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Och Kain kände sin hustru hade sexuellt umgänge med henne och hon blev havande. Ja, hon födde Henok (hebr. Chanoch) betyder: invigd/tillägnad och han Henok blev stadsbyggare. Och man uppkallade staden efter sonens namn: Henok. En skandinavisk form av namnet är Enok och den engelska stavningen är Enoch, se även 1 Mos 5:18; 25:4; 46:9 ");
INSERT INTO swe_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Till Henok föddes Irad enligt den sumeriska traditionen är Eridu den första staden, och Irad fick Mechojael, och Mechojael fick Metoshael, och Metoshael fick Lemech den förste polygamisten. Det finns två Lemech i urhistorien. Den förste Lemech, som nämns här, är en ättling till brodermördaren Kain. Denne Lemech var den första polygamisten och han lovade att döda för ett sår, se vers 23-24. Han är den sjätte generationen från Kain (sjunde generationen från Adam och Eva). Den andre Lemech i Sets linje är den nionde generationen från Adam. Han är Noas far och en rättfärdig man, se 1 Mos 5:25-28. ");
INSERT INTO swe_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemech tog sig två hustrur, den ena hette Ada och den andra hette Tsilla. Namnet Ada härrör troligtvis från adi som betyder ornament och Tsilla från det hebreiska sel (skugga), sil (plinga/ljuda) eller silsul (cymbal). Kanske förknippades de båda med skönhet och sång, se Höga V 2:14. ");
INSERT INTO swe_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada födde Javal, han blev far (stamfader) till dem som bor i tält och har boskap. ");
INSERT INTO swe_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hans brors namn var Joval betyder: ”ström/fors”; snarlikt ordet för vädurshorn och shofar (hebr. jovel), han blev far (stamfader) till alla som hanterar (spelar) kinnor-harpa (kithara – hebr. kinnor) en mindre harpa och flöjter. ");
INSERT INTO swe_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Också Tsilla födde Toval-Kain, som smidde (hamrade, slipade, vässade – hebr. latash) alla slags verktyg av brons och järn. Här saknas ”far till”, vilket visar att han var en av flera som arbetade med metaller. Han var en smed och tillverkade jordbruksredskap men även vapen. Hans namn, som har med brodermördaren Kains namn, tillsammans med släktskapet med Lemech, antyder att hans hantverk kunde bli använt också till ondska. Och Toval-Kains syster var Naama betyder: ”tilltalande/vacker”. ");
INSERT INTO swe_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemech sa till sina hustrur Ada och Tsilla: ”Hör min röst ni Lemechs hustrur, ge akt på mitt löftesord (tal, löfte/hot – hebr. imrah): En man dräper jag för mitt sår och en yngling för min skråma. ");
INSERT INTO swe_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ja, sjufalt hämnad blir Kain vers 15, men Lemech sjuttio och sju (sjuttio-sju-falt).” Lemech uttalande består av crescendon som intensifieras. För ett sår kommer han att döda en man (hebr. ish), och en yngling (barn – hebr. jeled) redan för en skråma. Hämnden ökar från Kains sjufaldiga till Lemechs sjuttio och sju. Det är detta påstående Jesus anknyter till i Matt 18:22 när han talar om förlåtelse. En Jesu efterföljare ska alltså vara lika benägen att förlåta som Lemech var att hämnas. På samma sätt som Lemech ville att straffet skulle överstiga brottet, vill Jesus att förlåtelsen vida ska överstiga brottet. ");
INSERT INTO swe_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam kände sin hustru (hade sexuellt umgänge med henne) igen 1 Mos 4:1 och hon födde en son och kallade honom Set (hebr. Shet) betyder: kompensation/ersättning, hon sa: ”för Gud har utsett (hebr. shat) en annan säd till mig istället för Abel, som Kain dräpte.” ");
INSERT INTO swe_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Åt Set (hebr. Shet) föddes också en son, och han kallade honom Enosh. På den tiden började man åkalla Herrens (Jahvehs) namn.  Intressanta ordfrekvenser  Gud nämns totalt 35 gånger (5 x 7) som Gud (Elohim), Herren (Jahveh) eller Herren Gud (Jahveh Elohim). Eftersom Gud (Elohim) nämns 35 gånger även i skapelseberättelsen innebär detta att Gud nämns 70 ggr (10 x 7) i Bibelns två första enheter, kap 1–4. Även de olika benämningarna på Gud förekommer med en iögonenfallande frekvens: Elohim – 40 gånger, Jahveh Elohim – 20 gånger och Jahveh – 10 gånger. Den sjuttionde gången Gud nämns är: Då började man åkalla Herrens (Jahvehs) namn, se vers 26. ");
INSERT INTO swe_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Detta är skriften (den skrivna redogörelsen) om människans (Adams) fortsatta historia (hebr. toledot). Den dag (hebr. bejom) Gud (Elohim) skapade människan (hebr. adam), till Guds likhet (hebr. demot elohim) gjorde han henne – ");
INSERT INTO swe_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","man och kvinna skapade han dem. Och han välsignade dem och gav dem namnet ”människa” (hebr. adam) den dag de skapades. När hebr. adam står i obestämd form är det ofta personen Adam som åsyftas, här i vers 1-2 är betydelsen människan och mänsklighetens fortsatta historia, se även 1 Mos 1:27-28; 1 Mos 2:7. ");
INSERT INTO swe_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","I den här släktlistan presenteras 10 generationer mellan Adam och Noa. Gud hade sagt att om ni äter av kunskapens träd, kommer ni att dö (1 Mos 2:17). Att det verkligen blev så bekräftas med frasen ”Och han dog” som avslutar sex generationer, se vers 5, 8, 11, 14, 17, 20. Det kommer också fram att de födde ett okänt antal söner och döttrar som inte nämnts i de tidigare kapitlen. Hebreiska verbet jalad har betydelse att föda och används om när en kvinna föder ett barn (1 Mos 35:16; 38:27-28; 2 Mos 1:19; 1 Kung 3:17-18). Släktlistan är detaljrik och man kan räkna 15 unika variationer, men fem generationer följer samma mönster (generation 2-6). Precis som i Kains släktlista låter författaren ett antal monotona generationer föregå den generation han vill lyfta fram. I det här fallet är det generation sju: Henok – som vandrade med Gud. Och Adam levde i 130 år 30 och 100 år. Och han blev vid den åldern far till en som var honom lik (hebr. demot), hans avbild (hebr. tselem). Och han gav honom namnet Set hebr. Shet – Ersättaren, se 1 Mos 4:25. ");
INSERT INTO swe_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Och Adams dagar sedan han blivit far till Set var 800 år. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Och Adams alla dagar som han levde var 930 år 900 år och 30 år. Och han dog. ");
INSERT INTO swe_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Och Set(hebr. Shet) levde i 105 år 5 år och 100 år. Och han blev vid den åldern far till Enosh. ");
INSERT INTO swe_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Och Set levde 807 år 7 år och 800 år efter att han blivit far till Enosh. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sets hela livslängd (alla hans dagar) var 912 år 12 år och 900 år. Och han dog. När åldrar skrivs är det vanligast att först ange tiotalet som sedan adderas till hundratalet, se vers 3, 7 och 8. Notera variationer där ”år” läggs till även mellan tal, något som normalt sett inte behövs. I vers 5 är ordningen omvänd där det högre talet anges först. Genom att ha talet 30 ”ytterst” blir det ett inclusio som ramar in beskrivningen om Adam. Nu följer fyra generationer till. Beskrivningen följer samma format som användes för Set som den andra generationen. ");
INSERT INTO swe_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Och Enosh levde i 90 år. Och han blev vid den åldern far till Kenan. ");
INSERT INTO swe_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Och Enosh levde 815 år 15 år och 800 år sedan han blivit far till Kenan. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Och Enoshs hela livslängd (alla hans dagar) var 905 år 5 år och 900 år. Och han dog. ");
INSERT INTO swe_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Och Kenan levde i 70 år. Och han blev vid den åldern far till Mahalalel. ");
INSERT INTO swe_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Och Kenan levde 840 år 40 år och 800 år efter att han blivit far till Mahalalel. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Och Kenans hela livslängd (alla hans dagar) var 910 år 10 år och 900 år. Och han dog. ");
INSERT INTO swe_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Och Mahalalel levde i 65 år 5 år och 60 år. Och han blev vid den åldern far till Jared. ");
INSERT INTO swe_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Och Mahalalel levde 830 år 30 år och 800 år efter att han blivit far till Jared. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Och Mahalalels hela livslängd (alla hans dagar) var 895 år 5 och 90 år och 800 år. Och han dog. ");
INSERT INTO swe_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Och Jared levde i 162 år 2 och 60 år och 100 år. Och han blev vid den åldern far till Henok (hebr. Chanoch). ");
INSERT INTO swe_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Och Jared levde 800 år efter att han blivit far till Henok (Chanoch). Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Och Jareds hela livslängd (alla hans dagar) var 962 år 2 och 60 år och 900 år. Och han dog. ");
INSERT INTO swe_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Och Henok(hebr. Chanoch) betyder: tillägnad/invigd levde i 65 år 5 och 60 år. Och han blev vid den åldern far till Metoshelach. ");
INSERT INTO swe_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Och Henok vandrade levde i gemenskap med Gud (hebr. ha-Elohim) i 300 år efter att han blivit far till Metoshelach. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Och Henoks hela livslängd (alla hans dagar) var 365 år 5 och 60 och 300 år. Nu kommer inte frasen ”Och han dog”. ");
INSERT INTO swe_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Och Henok vandrade med Gud (hebr. ha-Elohim) och var inte mer man fann honom inte, för Gud (Elohim) hade hämtat honom. Heb 11:5 I det sjunde ledet bryts mönstret i hur personernas liv beskrivs. Istället för att säga att Henok ”levde” (jfr vers 10, 13, 16 och 19), beskrivs hur han ”vandrade med Gud” (vers 22). Det är samma ord som används om hur Gud vandrade i trädgården, se 1 Mos 3:8. ");
INSERT INTO swe_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Och Metoshelachbetyder: spjutets man levde i 187 år 7 och 80 år och 100 år. Och han blev vid den åldern far till Lemech. ");
INSERT INTO swe_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Och Metoshelach levde 782 år 2 och 80 år och 700 år efter att han blivit far till Lemech. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Och Metoshelachs hela livslängd (alla hans dagar) var 969 år 9 och 60 år och 900 år. Och han dog. Hans ålder är den högsta som finns angiven i Bibeln. Han var med och såg hur arken byggdes och dog samma år som floden kom. Det vet vi eftersom Noa var 600 år då floden kom, se 1 Mos 7:11. Metoshelach fick Lemech då han var 187 år. Ytterligare 182 år senare föddes Noa, se 1 Mos 5:25-29. Summan av 187 + 182 + 600 är 969. ");
INSERT INTO swe_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Och Lemechbetyder: kraftfull levde i 182 år 2 och 80 år och 100 år. Och han blev vid den åldern far till en son. ");
INSERT INTO swe_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Och han gav honom namnet Noa (hebr. Noach) genom att säga: ”Denne ska lätta (hebr. nacham) oss från vårt arbete, ja, från våra händers möda (slitsamma smärta – hebr. itsavon) med den mark när vi brukar jorden som Herren (Jahveh) har förbannat.” Här bryts mönstret, istället för att direkt ange namnet beskrivs namngivningen mer detaljerat. Det hebreiska namnet Noach förknippas med det hebreiska verbet noach (vila), och används när arken stannade på berget Ararat. Här använder Lemech ordet nacham som betyder att lätta på bördan. Dessa hebreiska ord har en gemensam rot som beskriver att andas ut, vila och att ligga ned. ");
INSERT INTO swe_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Och Lemech levde 595 år 5 och 90 år och 500 år sedan han blivit far till Noa. Och han blev far till söner och döttrar. ");
INSERT INTO swe_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Och Lemechs hela livslängd (alla hans dagar) var 777 år 7 och 70 år och 700 år. Och han dog. Det finns två Lemech i den urhistorien. Den förste Lemech är en ättling till brodermördaren Kain. Denne Lemech var den första polygamisten och han skröt över att ha dödat en människa, se 1 Mos 4:19-24. Han var den sjunde generationen från Adam och Eva. Den andre Lemech beskrivs här och var Noas far. Hans ålder blev exakt 777 år vilket kan tolkas som att han var en rättfärdig man. Han är den nionde generationen från Adam och Eva och en ättling till Set. Det är mycket troligt att Lemech såg arken som hans son byggde. Han dog fem år innan floden kom. ");
INSERT INTO swe_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Och var – Noas ålder – 500 år. Och Noa blev far till Shem (Sem), Cham (Ham) och Jafet. För första gången förekommer hebr. ben framför åldersangivelsen. Frasen blir ordagrant: Noach, en son av 500 år, se även 1 Mos 7:6; 11:10; 1 Sam 13:1. Noas namn upprepas också här, vilket är unikt, i tidigare generationer används ”han”. Här avbryts Noas formel. Slutet återfinns först i slutet av Noas fortsatta historia i 1 Mos 9:28-29. ");
INSERT INTO swe_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","När människosläktet började föröka sig på jorden och döttrar föddes åt dem, ");
INSERT INTO swe_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","såg Guds söner att människornas döttrar var vackra. De tog sig hustrur som det behagade dem. Vilka var ”Guds söner”? Frasen används bara här i 1 Mos 6:2, 4 och i Job 1:6; 2:1; 38:7. I Jobs bok refererar det till änglaliknande varelser. Kontrasten till människosläktet talar för denna tolkning. I så fall tog dessa fallna änglar mänsklig gestalt eller besatte människor och fick barn som kallades jättar, se vers 4. En annan syn är att ”Guds söner” är Sets ättlingar medan ”människors döttrar” var Kains ättlingar. Se även Jesu undervisning om änglar i Matt 22:30. ");
INSERT INTO swe_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Då sa Herren (Jahveh): ”Min Ande min livgivande ande, se 1 Mos 2:7 ska inte bli kvar i vara ansvarig för människorna för alltid. De är kött och deras tid ska vara 120 år.”  Människans livslängd är 120 år  På 1800-talet började forskare upptäcka och beskriva celldelning i växter och djur. Länge trodde man att cellerna kunde dela sig i all oändlighet, dock upptäckte den amerikanske mikrobiologen Leonard Hayflick på 1960-talet att mänskliga celler slutade dela sig efter 40-60 delningar. Denna gräns kom att kallas Hayflicks begränsning. Vetenskapliga beräkningar ger alltså en biologisk maximal livslängd för människan på just 120 år plus minus några år! Den äldsta personen som nämns i Bibeln är Metoshelach som blev 969 år (1 Mos 5:27). Efter floden minskar åldern gradvis över tid till att bli maximalt 120 år. Mose blev just 120 år (5 Mos 31:2) och hans efterträdare Josua blev 110 år (Jos 24:29), se även Jes 38:5 där 15 år läggs till Hiskias liv. ");
INSERT INTO swe_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nefilimerna (jättarna, ordagrant ”de fallna”, eller ”de som orsakar andra att falla på jorden”) fanns på jorden på den tiden – och även senare – när Guds söner hade sexuella relationer med människornas döttrar och dessa födde barn åt dem. Dessa var urtidens väldiga män (krigare, hjältar – hebr. gibborim), och deras rykte var stort. ");
INSERT INTO swe_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Men Herren (Jahveh) såg att människornas ondska hade blivit stor på jorden. Deras hjärtans alla tankar och avsikter var alltid och alltigenom onda. ");
INSERT INTO swe_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Då ångrade (sorg-tröstade – hebr. nacham) Herren (Jahveh) verkligen att han gjort människorna på jorden, ja, han var sårad (det smärtade) – rakt in i sitt hans hjärta. Ordet för att ”ångra” (hebr. nacham) innebär inte att Gud ångrar sitt första beslut i betydelsen ”inser att det var fel”. Ordet betyder både att känna sorg och att trösta, och själva skeendet då man går från sorg till att ge tröst. Profeten Nahums namn, som betyder tröst, har samma hebreiska rot (nhm), se även Nah 3:7; Ps 23:4; 71:21. Gud känner sorg över att människan föll i synd, men det finns hopp och tröst och räddning! Jesus valde att verka utifrån Kapernaum (Jes 9:1; Matt 4:13), som på hebreiska är Kfar Nachum – ordagrant ”tröstens by”!  I denna vers förekommer tre verb (nacham, asah och itsavon/asav) som på hebreiska återklingar det som Lemech uttalade över Noa i 1 Mos 5:29. De förekommer också i exakt samma ordning. Det enda som skiljer är grammatiken, vilket gör att betydelsen ändras. ");
INSERT INTO swe_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Herren sa: ”Jag ska förgöra (utrota) människorna som jag har skapat från jordens yta – inte bara människan utan boskapsdjur, kräldjur och himlens fåglar – jag känner sorg över (ångrar, sorg-tröstar – hebr. nacham) att jag har gjort dem.” ");
INSERT INTO swe_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Men Noa (hebr. Noach) hade funnit nåd (oförtjänt kärlek; favör – chen) inför Herrens (Jahvehs) ögon. Här finns det hebreiska ordet chen första gången. Betydelsen är nåd, oförtjänt kärlek och favör. Ordet förekommer även i formerna chanan och chanon. Ordet chanan betyder samma sak med tillägget extraordinär vänlighet, medan chanon i huvudsak betyder nåd och favör. Chanon återfinns bara 13 gånger i GT medan chen och chanan finns 67 respektive 72 gånger. Förutom nåd är den särskilda betoningen på dessa ord att det handlar om den oförtjänta kärleken. Ingen handling kan på något sätt göra oss värdiga att få denna typ av nåd. I denna vers finns också namnet Noa (hebr. Noach), samma två bokstäver som nåd, fast spegelvänt. Här kommer en ny ”toledot-enhet” (den fjärde i Första Moseboken). Det hebreiska ordet toledot används elva gånger i Första Moseboken, se 1 Mos 2:4; 5:1; 6:9; 10:1; 11:10, 27; 25:12, 19; 36:1, 9; 37:2. Användningen av siffor och tal är speciellt och binder ihop denna enhet. Ordet ”jorden” används 40 gånger. Talet sju och multipler av sju är också vanligt. Herren (Jahveh) nämns sju gånger. Gud (Elohim) nämns 14 ggr (7 x 2). Gud talar sju gånger till Noa, det finns sju ”göra” i samband med instruktionerna. Verbet fördärva (som återfinns i början och i slutet) används sju gånger. I avslutningen används ordet ”förbund” sju gånger. Talet sju används vid sju tillfällen (två gånger dubbleras det så det står ”sju-sju”; totalt används ordet 9 gånger). Vatten nämns 21 gånger (3 x 7) och kött nämns 14 gånger (2 x 7). ");
INSERT INTO swe_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Detta är Noas (hebr. Noachs) fortsatta historia (hans genealogi/släkttavla – hebr. toledot). Noa var en rättfärdig man och fullkomlig bland sina samtida. Noa vandrade i ständig gemenskap med Gud (Elohim). Här är första gången ordet rättfärdig (hebr. tsadik) används. Ett närbesläktat ord från samma rot är tsedaqah som ofta översätts med en frivillig gåva till fattiga och behövande. Bibeln nämner särskilt änkor, föräldralösa/faderlösa barn och främlingen inom dina portar. Att ge tsedaqah är något som i princip alla religiösa judar gör i någon form. Rättfärdighet och att vara rättfärdig eller leva ett rättfärdigt liv hör alltså intimt ihop med att se till att de behövande i min närhet, genom mina frivilliga gåvor, har det de behöver. ");
INSERT INTO swe_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa blev far till tre söner: Shem (Sem), Cham (Ham) och Jafet. ");
INSERT INTO swe_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Men jorden blev mer och mer fördärvad inför Gud (Elohim) och full av laglöshet (våld, terror – hebr. chamas). ");
INSERT INTO swe_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Gud (Elohim) såg på jorden, och se, den var fördärvad, eftersom alla människor levde i fördärv på jorden. ");
INSERT INTO swe_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Då sa Gud (Elohim) till Noa: ”Jag har beslutat att göra slut på allt levande ordagrant ’slutet på allt kött är här’, för på grund av dem är jorden fylld av laglöshet (våld, terror – hebr. chamas). Betänk (hebr. hen), nu ska jag förgöra döma dem tillsammans med jorden. ");
INSERT INTO swe_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bygg en ark av goferträ. Allmänt antas detta vara trä från den äkta cypressen, vanligt förekommande som båtvirke kring Medelhavet, men det kan också syfta på bearbetningen av träet, t.ex. att det ska vara hyvlat eller laminerat. Inred arken med olika kamrar (nästen, boningar – hebr. qen), och täck (bestryk) den med täckning (jordbeck) inuti och utanpå. Verbet täck och substantivet täckning har samma hebreiska rot som också betyder försoning och att försona. Det används om offerblodet i 3 Mos 17:11. Arken är en fin skuggbild av Jesus. Den blev tätad så att syndaflodens vatten inte trängde in, på samma sätt som Jesu blod ’tätar’ från domen mot synden. ");
INSERT INTO swe_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Så ska du bygga den: 300 alnar 156 meter lång, 50 alnar 26 meter bred och 30 alnar 15,6 meter hög. ");
INSERT INTO swe_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gör ett tak (hebr. tsohar) till båten och lämna ett utrymme på en aln 0,52 meter mellan taket och sidorna som en öppning för ljus. Sätt en dörr till arken på ena sidan. Inred arken så den får en undervåning, en mellanvåning och en övervåning. Ett ovanligt ord för tak används här, det liknar ’mitt på dagen’, och kan beskriva ett välvt tak som skyddar från regn och sol. En del översätter med ’fönster’, men det är ett annat ord i 1 Mos 8:6. Inte heller används det vanliga ordet för ett ’platt’ tak.  Kort eller lång aln?  Ordet för aln (hebr. ammah) härstammar från ordet för mor (hebr. imma). Man skulle kunna översätta ’modern till alla mått’, vilket är ett lämpligt namn för ett av de äldsta måtten. Som det brukar vara med antika mått utgår de från kroppen. En aln motsvarar längden på en mans underarm – avståndet mellan armbågen och långfingret. Enheten användes redan tidigt i historien hos sumererna i Mesopotamien och sedan i Egypten och Israel. Det användes i Romarriket och fanns i Sverige på medeltiden fram till slutet på 1800-talet, då det metriska systemet infördes efter franska revolutionen. I de antika kulturerna finns alnen i två varianter:     • en vanlig kort aln (44-45 cm)     • en kunglig lång aln (50-52 cm)  Det äldsta arkeologiska fyndet av en aln är en måttstock från staden Nippur i Sumer (nuvarande Irak). Den dateras till 2650 f.Kr. och mäter 51,85 cm. Detta mått motsvarar den längre kungliga alnen som också användes för pyramiderna i Egypten. Forskare kommer fram till olika resultat, men troligast är ändå att alnen som Noa använde sig av är det längre, äldre måttet av alnen. Den fullskaliga modellen av Noas ark i Kentucky i USA som blev klar 2016 använder detta längre mått (51,8 cm), medan holländaren Huibers modell från 2012 använder det kortare (44,45 cm). Arkens dimensioner med den kortare alnen är 133 x 22 x 13 meter. ");
INSERT INTO swe_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Jag ska låta floden översvämma jorden och förgöra alla levande varelser under himlarna. Allt på jorden ska dö, ");
INSERT INTO swe_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","men jag ska bekräfta mitt förbund med dig. Du ska gå in i arken tillsammans med dina söner, din hustru och dina sonhustrur. ");
INSERT INTO swe_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Du ska ta med dig ett par av alla levande varelser, hane och hona, för att de ska överleva tillsammans med dig. ");
INSERT INTO swe_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Flygande varelser (hebr. of) av sina slag, boskapsdjur och markens kräldjur ska ett par av varje komma till dig, så att de kan överleva. ");
INSERT INTO swe_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Du måste också lägga upp ett förråd av all slags mat som man äter. Det ska bli mat för dig och för dem.” ");
INSERT INTO swe_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa gjorde allt som Gud hade befallt honom att göra, ja, han gjorde allt detta. Upprepningen betonar Noas lydnad. ");
INSERT INTO swe_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Herren (Jahveh) sa till Noa (hebr. Noach): ”Gå till arken, du och hela din familj. Jag har sett att du är rättfärdig inför mig i detta släkte (denna generation). ");
INSERT INTO swe_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Av alla rena fyrfotadjur boskapsdjuren ska du ta med dig sju par (ordagrant: sju sju), hane och hona som sedan kan offras, se 1 Mos 8:20, men av sådana fyrfotadjur som inte är rena ett par, hane och hona, ");
INSERT INTO swe_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","också av himlens fåglar sju par, hane och hona, för att en avkomma ska leva vidare över hela jorden. ");
INSERT INTO swe_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Om sju dagar ska jag låta det regna på jorden i 40 dagar och 40 nätter, och jag ska utplåna allt som finns till från jordens yta, allt som jag har gjort.” Gud ger senare sitt folk instruktioner om vilka djur som är rena och orena, se 3 Mos 11; 5 Mos 14. Vissa djur är rituellt rena till offer och också lämpliga till mat, av dessa tar Noa med sig sju par, för att klara sig det dryga år som de befinner sig i arken, jfr 1 Mos 7:11; 8:14. ");
INSERT INTO swe_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Och Noa gjorde allt som Gud hade befallt honom att göra. ");
INSERT INTO swe_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Och Noa var 600 år när floden skulle översvämma jorden. ");
INSERT INTO swe_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa gick in i arken tillsammans med sina söner, sin hustru och sina sonhustrur, undan flodens vatten. Totalt var de åtta personer, se 1 Pet 3:20. ");
INSERT INTO swe_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Av de rena fyrfotadjuren och av de fyrfotadjur som inte är rena, av fåglarna och av allt det som krälar på marken ");
INSERT INTO swe_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kom ett par av varje art in till Noa i arken, hane och hona, så som Gud hade befallt Noa. ");
INSERT INTO swe_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Det närmade sig sju dagar innan flodens vatten kom över jorden. ");
INSERT INTO swe_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Det år då Noa blev 600 år, i den 2:a månaden under den 17:e dagen, denna dag brister (delas, rämnar) alla det stora djupets (hebr. tehom) 1 Mos 1:2 källor och himlens dammluckor (slussar) öppnas. Vattnet strömmar både underifrån och ovanifrån, se 1 Mos 1:6-7. Tidsangivelsen utgår som vanligt från Noas ålder, men detta är en ny variation, jfr vers 6. Den andra månaden kan antingen vara en vår- eller höstmånad. Det religiösa judiska året inleds på våren med månaden aviv (2 Mos 12:2) och den andra månaden är ijar som infaller maj/april. Åsyftas det civila judiska året (som även omgivande nationer använde sig av) startar det på hösten, och då är den andra månaden cheshvan som infaller i okt/nov. ");
INSERT INTO swe_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Det regnade på jorden under 40 dagar och 40 nätter. ");
INSERT INTO swe_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Samma dag gick Noa (hebr. Noach) och hans tre söner Shem (Sem), Cham (Ham) och Jafet, och Noas hustru och hans tre sonhustrur in i arken. De hade påbörjat ombordstigningen sju dagar tidigare, nu på sjunde dagen när vattnet började komma gick de ombord. Både vad gäller djur och människor refereras de i par (man/kvinna och hane/hona, se 1 Mos 6:19-20; 7:2-3; 8-9). Polygami förekom i samhället, men omnämns i negativa ordalag, se Lemech i 1 Mos 4:19-24. ");
INSERT INTO swe_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","De de 8 människorna och allt liv (alla levande varelser) enligt sitt slag (sin art), ja, alla boskapsdjur enligt sitt slag (sin art) och alla kräldjur som krälar på jorden, enligt sitt slag (sin art) och alla flygande varelser (djur som flyger – hebr. of) enligt sitt slag (sin art) – alla fåglar (kvittrare – hebr. tsipor), allt som har vingar. ");
INSERT INTO swe_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ja, de kom till Noa, till arken, två och två (par om par) av allt det kött som hade livsande (ande av liv). ");
INSERT INTO swe_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","De kom, hane och hona av alla slags djur, så som Gud (Elohim) hade befallt Noa. Sedan stängde Herren (Jahveh) igen dörren om honom. Jorden och vattnet växlas i beskrivningen. ");
INSERT INTO swe_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Floden regnet som öste ner, se vers 12 varade i 40 dagar över jorden. Vattnet steg och lyfte arken så den flöt över jorden. ");
INSERT INTO swe_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Vattnet steg högt över jorden, och arken drev (ordagrant ”vandrade”) på vattnet. I den ordagranna lydelsen finns en profetisk föraning som pekar på Jesus som också vandrade på vattnet, se Matt 14:25. Jesus är arken som försonar och ”tätar” mot synd och går på vattnet, se också Job 9:8. ");
INSERT INTO swe_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Allt högre steg vattnet över jorden, tills det täckte även de högsta bergen under himlen. ");
INSERT INTO swe_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Vattnet steg mer än 15 alnar 7 meter över bergen. ");
INSERT INTO swe_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Alla varelser som rörde sig på jorden gick under – fåglar och tama boskapsdjur och vilda djur, allt liv som jorden vimlade av, och alla människor. ");
INSERT INTO swe_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Allt på landytan som hade livsande i sin näsa dog. ");
INSERT INTO swe_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Herren utplånade allt som fanns till på jorden, människor och fyrfotadjur, kräldjur och himlens fåglar: allt utplånades från jorden. Kvar blev bara Noa och de som var med honom i arken. ");
INSERT INTO swe_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Vattnet besegrade mäktigt jorden under 150 dagar. Verbet ”besegrade mäktigt” är på hebreiska gavgaar, samma rot som ”mäktig hjälte” i 1 Mos 6:4. Ordvalet knyter samman hur Gud under fem månaders tid segrar över dem som verkade vara jordens mäktiga och hjältar. ");
INSERT INTO swe_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Då kom Gud (Elohim) ihåg tänkte han på; fullföljde han sitt förbund med Noa (hebr. Noach) och alla de vilda och tama djur som var med honom i arken. Han lät en vind blåsa över jorden och vattnet började sjunka undan. ");
INSERT INTO swe_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Djupets källor och himlens dammluckor stängdes, regnet upphörde. ");
INSERT INTO swe_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Vattnet drog sig efter hand bort från jorden, så att det efter 150 dagar hade minskat. Efter att ha ökat i 150 dagar, se 1 Mos 7:24. ");
INSERT INTO swe_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","På 17:e dagen i 7:e månaden tishri – sept/okt blev arken vilande (hebr. noach – snarlikt Noas namn Noach) på Araratbergen. Datumet är väldigt exakt återgivet. Den 7:e månaden är den viktigaste månaden med alla de tre hösthögtiderna. Den 17:e dagen är mitt i lövhyddohögtiden (hebr. sukkah) som firas 15:e-22:a tishri. Platsen är mer vagt beskriven, berg står i plural, men syftar på bergsområdet i gränstrakten av Turkiet och Armenien. ");
INSERT INTO swe_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Vattnet fortsatte hela tiden att minska fram till den 10:e månaden tevet – dec/jan. På den första dagen i den 10:e månaden blev bergens toppar synliga. Den 10:e månaden är tevet som infaller dec/jan. Det har nu gått tre månader (73 dagar om det är 30 dagar i varje månad) från det att arken strandade på Araratbergen och flera berg blir synliga. I den kiastiska strukturen täcktes bergen i 1 Mos 7:19, nu syns de. ");
INSERT INTO swe_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Efter ytterligare fyrtio dagar öppnade Noa ett fönster som han hade gjort på arken, ");
INSERT INTO swe_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","och släppte ut en korp. Den flög fram och åter till dess vattnet torkat upp på jorden. ");
INSERT INTO swe_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Sedan släppte han ut en duva (hebr. jonah) för att se om vattnet hade sjunkit undan från marken. ");
INSERT INTO swe_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Men duvan fann ingen viloplats för sin fot, så hon kom tillbaka till honom i arken, för vattnet täckte fortfarande landytan. Då sträckte Noa ut handen och tog henne till sig – in i arken. ");
INSERT INTO swe_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa väntade ytterligare sju dagar, sedan släppte han ut duvan ur arken ännu en gång. ");
INSERT INTO swe_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Och duvan kom tillbaka till honom när det led mot kväll strax innan skymningen. Och se hebr. vehinneh – perspektivbyte, vi får se med Noas ögon: Ett friskt olivlöv i hennes näbb! Då förstod (insåg) Noa: Vattnet hade verkligen äntligen sjunkit undan från jorden. ");
INSERT INTO swe_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Han väntade ytterligare sju dagar, sedan släppte han ut duvan igen. Denna gång kom den inte tillbaka till honom. ");
INSERT INTO swe_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Och det hände, i det 601:a året 1 + 600 år; av Noas livsdagar, i den första månaden, på den första dagen, att vattnet hade torkat upp från jorden. Noa tog bort taket från arken, och såg, och se hebr. vehinneh – perspektivbyte, vi får nu se med Noas ögon: Marken hade torkat upp! ");
INSERT INTO swe_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","I den 2:a månaden på den 27:e dagen var marken helt torr. ");
INSERT INTO swe_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Då talade Gud till Noa genom att säga: ");
INSERT INTO swe_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Det är dags! ”Gå ut ur arken tillsammans med din hustru, dina söner och sonhustrur. ");
INSERT INTO swe_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Släpp ut alla de djur av alla slag som du har hos dig, fåglar, fyrfotadjur och alla kräldjur som finns på jorden, så att de kan sprida ut sig över hela jorden och vara fruktsamma och föröka sig.” ");
INSERT INTO swe_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Då gick Noa ut tillsammans med sin hustru och sina söner och sonhustrur efter att ha varit i arken i ett år och tio dagar. ");
INSERT INTO swe_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Alla levande varelser fyrfotadjur, alla kräldjur och alla fåglar, allt som myllrar på jorden – efter sin familj (släkt, art) – gick de ut ur arken. ");
INSERT INTO swe_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa byggde ett altare åt Herren (Jahveh). Han tog fyrfotadjur och fåglar av alla rena arter och offrade dem som brännoffer på altaret. ");
INSERT INTO swe_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","När Herren kände den välbehagliga doften, sa han till sig själv: ”Aldrig mer ska min förbannelse drabba marken för människans skull, för att hon alltifrån ungdomen har ett ont uppsåt. Jag ska aldrig mer förgöra allt levande, så som jag nu har gjort. ");
INSERT INTO swe_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Så länge jorden finns kvar ska: sådd och skörd (hebr. qatsir), köld och hetta, sommar (skördetid – hebr. qajits) och vinter, dag och natt aldrig upphöra (ordagrant: ’inte ha sabbat’ – hebr. lo shavat).” Vers 22 avslutas med fyra par. Talet fyra är jordens tal (fyra väderstreck, osv). Centralt står hetta och sommar som hör ihop, vilket ramas in av köld och vinter. ");
INSERT INTO swe_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gud (Elohim) välsignade Noa (hebr. Noach) och hans söner och sa till dem: ”Var fruktsamma och föröka er och uppfyll jorden. ");
INSERT INTO swe_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Fruktan och skräck för er ska komma över alla djur på jorden och alla fåglar under himlen, över allt som krälar på marken och över alla fiskar i havet. De är givna i er hand (ni har fått auktoritet att råda över dem). ");
INSERT INTO swe_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Allt som lever och rör sig ska vara er föda, på samma sätt som jag gav er de gröna växterna 1 Mos 1:30, ger jag er allting. Välsignelsen som Gud ger Noa speglar den välsignelse som Adam fick i 1 Mos 1:28. En skillnad är att nu finns synden i världen, och människan ska inte längre råda över djuren. I stället för ett frivilligt underordnande så finns nu en komponent av rädsla hos djuren. Även om att äta kött tidigare var tillåtet, t.ex. Abels blodsoffer var välbehagligt inför Gud och Noas rena djur under deras år i arken, så blir det nu en tydligt uttalad tillåtelse att använda djur till föda. ");
INSERT INTO swe_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Men kött som har liv, det vill säga blod, i sig ska ni inte äta. ");
INSERT INTO swe_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Och för ert eget blod mänskligt liv, ska jag utkräva (begära – hebr. darash) vedergällning, av varje djur ska jag utkräva (begära) vedergällning och från människans (hebr. adam) hand, från varje broder, ska jag utkräva (begära) vedergällning för mänskligt liv. ");
INSERT INTO swe_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Den som utgjuter blod av en människa, genom en människa ska hans förövarens blod utgjutas, för Gud (Elohim) gjorde människan till sin avbild. Hebreiskan har inga prepositioner och de första sex orden formar en tydlig kiasm: shofech dam haadam baadam damo jishafech. Texten betonar ordet människa, som både offer och den instans som ska vedergälla brottet, genom att placera hebr. adam centralt. Att frasen också har sex ord för också tankarna till människans tal som är sex. Att utgjuta blod används i betydelsen överlagt mord, se 1 Mos 37:22; 1 Kung 2:31; Hes 22:4. Allt liv är heligt, och speciellt mänskligt liv. Anledningen till att Gud ser detta så viktigt är att människan är skapad till hans avbild. Att mörda en annan människa är ett angrepp på den människans skapare som är Gud själv. ");
INSERT INTO swe_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Var fruktsamma och föröka er och uppfyll jorden.” ");
INSERT INTO swe_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Och Gud (Elohim) sa till Noa och hans söner: ");
INSERT INTO swe_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","”Se, jag upprättar nu ett förbund med er och era efterkommande, ");
INSERT INTO swe_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","och med alla levande varelser som finns hos er – fåglar, boskap och alla vilda djur – alla de som gick ut ur arken tillsammans med er. ");
INSERT INTO swe_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Jag upprättar mitt förbund med er: Aldrig mer ska allt liv (kött) utrotas genom vatten från en världsvid översvämning. Aldrig mer ska en översvämning komma och fördärva jorden.” ");
INSERT INTO swe_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Gud sa: ”Detta är tecknet på det förbund jag instiftar mellan mig och er och alla levande varelser som är med er, för alla kommande släktled: ");
INSERT INTO swe_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Jag har placerat min båge regnbågen i skyn, och det ska vara tecknet för förbundet mellan mig och jorden. ");
INSERT INTO swe_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","När jag härefter sänder moln över jorden, och bågen då syns bland molnen, ");
INSERT INTO swe_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ska jag komma ihåg mitt förbund mellan mig och er och alla levande varelser av alla slag, och vattnet ska aldrig bli till en översvämning som fördärvar allt levande. ");
INSERT INTO swe_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","När bågen visar sig i skyn ska jag se den och tänka på det eviga förbundet mellan Gud (Elohim) och alla levande varelser, allt liv (kött) på jorden.” ");
INSERT INTO swe_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Gud (Elohim) sa till Noa: ”Detta är tecknet regnbågen, som antagligen var synlig för Noa just när Gud talade dessa ord på det förbund som jag upprättar mellan mig och allt liv på jorden.” ");
INSERT INTO swe_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noas söner som gick ut ur arken var Shem (Sem), Cham (Ham) och Jafet. Cham (Ham) var far till Kanaan som föddes senare. ");
INSERT INTO swe_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dessa tre var Noas söner och från dem har jordens alla folk spritt ut sig. Se släktträdet i 1 Mos 10. ");
INSERT INTO swe_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Och Noa, en man av jorden, började plantera en vingård. ");
INSERT INTO swe_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Han drack av vinet och blev drucken, och han var naken (utan täcke) mitt i sitt tält. ");
INSERT INTO swe_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham (Ham), far till Kanaan, såg sin fars nakenhet genitalier – hebr. ervah och berättade det för sina två bröder utanför (tältet). ");
INSERT INTO swe_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem och Jafet tog ett skynke och lade på sina båda axlar och gick baklänges och dolde sin fars nakenhet. Deras båda ansikten var bortvända så att de inte såg sin fars nakenhet. Vad hade Cham gjort för något? Att se någons nakenhet är en hebreisk omskrivning för en sexuell handling, se 3 Mos 18:6-19. Eftersom vers 24 säger att Cham ”gjorde” något med Noa kan det tolkas som att han inte bara såg, utan också förnedrade sin far på något sätt. En del judiska kommentatorer noterar att det inte nämns att Noa får några fler barn, så kanske kastrerade Cham honom. Andra har föreslagit en homosexuell akt, men där används andra ord i 3 Mos 18:22. Straffet blir också väldigt allvarligt, vilket kan tyda på att han inte bara såg. Samtidigt är nakenhet något skamfyllt i den hebreiska kulturen, se 1 Mos 2:25; 3:7. Att medvetet blotta sina föräldrar var allvarligt, se 2 Mos 20:12. Vad som talar för att han ”bara” såg är att samma ord ”se” används om bröderna Shem och Jafet som inte såg och fysiskt täckte över sin far. Vers 22-23 är strukturerat som en kiasm där den första frasen är ”och såg ... sin fars nakenhet” och den avslutas med att bröderna ”och sin fars nakenhet inte såg”. ");
INSERT INTO swe_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa vaknade från sitt vin och han visste vad hans yngsta son hade gjort mot honom, ");
INSERT INTO swe_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","och han sa: ”Förbannad är Kanaan, en tjänares tjänare (slav) ska han vara för sina bröder!” ");
INSERT INTO swe_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Och han sa vidare: ”Välsignad är Herren (Jahveh), Shems Gud, och låt Kanaan bli hans tjänare. ");
INSERT INTO swe_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Må Gud (Elohim) utvidga Jafet och han ska bo i Shems tält och låta Kanaan bli deras tjänare.” Dessa två avslutande verser har samma struktur som 1 Mos 5:32, och ramar fint in denna sektion om Noa. ");
INSERT INTO swe_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa levde 350 år 300 år och 50 år efter floden. ");
INSERT INTO swe_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Och var – alla Noas dagar – 950 år 900 år och 50 år. Sedan dog han. Det finns åtskilliga flodberättelser över hela världen, vilket vittnar om ett gemensamt avlägset minne av en sådan världsvid katastrof. Bibelns flodberättelse är dock unik vad gäller dess totala avsaknad av mytologi, exakta angivelsen av arkens mått och hur länge floden varade. ");
INSERT INTO swe_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Detta är Noas (hebr. Noachs) söners fortsatta historia (deras genealogi/släkttavla – hebr. toledot), Shem (Sem), Cham (Ham) och Jafet. Söner föddes till dem Noas tre söner efter floden. Noas tre söner var:  - Jafet – troligtvis äldste sonen, se 1 Mos 10:21. Han föddes när Noa var 500 år gammal, se 1 Mos 5:32.  - Shem (Sem) – troligtvis mellansonen. Han var 100 år gammal två år efter floden, se 1 Mos 11:10. Eftersom floden kom när Noa var 600 år, måste han varit född när Noa var 502 år, och är alltså två år yngre än Jafet. Anledningen till att han nämns först i alla uppräkningar, här i vers 1 och i 1 Mos 5:32; 6:10; 7:13; 1 Krön 1:4, är att hans släktträd leder till Abraham och slutligen till Messias, se Luk 3:34-36!  - Cham (Ham) – den yngste sonen, se 1 Mos 9:24. Hur mycket yngre han är anges inte, men han var född före floden. I vers 1 var ordningen Shem, Cham och Jafet. När deras släktled beskrivs nedan i vers 2-32 blir ordningen omvänd med först Jafet (vers 2), sedan Cham (vers 6) och sist Shem (vers 21). Det är ett typiskt kiastiskt mönster i flera led som gör att berättelsen om Babels torn, se 1 Mos 11:1-9, ramas in av Shems släkttavla som fortsätter i 1 Mos 11:10-26. Totalt 14 ättlingar till Jafet nämns. Jafets söner är huvudsakligen folken i norr och väster, i Mindre Asien och på Medelhavets öar och kuster. Det motsvarar dagens Europa och även delar av norra Mellanöstern. ");
INSERT INTO swe_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafets söner var: Gomer kimmererna vid Svarta havet; nuvarande Turkiet och Magog kring Svarta havet, nuvarande Georgien och Madaj förfader till mederna; sydväst om Kaspiska havet; området kring nuvarande Teheran i Iran och Javan jonierna, grekerna; Grekland och Tubal (hebr. Toval) folk i östra Mindre Asien; nuvarande centrala Turkiet och Meshech folk i östra Mindre Asien och Tiras nuvarande Italien. ");
INSERT INTO swe_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomers söner var: Ashekkenaz kanske skyterna; vid Svarta havet och Rifat och Togarma folk i östra Mindre Asien; nuvarande Turkiet. ");
INSERT INTO swe_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javans söner var: Elisha folkslag på ön Cypern och Tarshish ett fenikiskt folk från västra Medelhavet, Spanien, osv., Kittim folkslag på ön Cypern och Dodanim rodaneerna, folkslag på ön Rhodos, se 1 Krön 1:7. ");
INSERT INTO swe_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Från dessa blev öarnas folk (kustregionernas folkslag – hebr. i ha-goj) uppdelade (har de utbretts) i sina länder (områden – hebr. erets), var och en efter sitt språk och efter sina familjer (släkter – hebr. mishpachah), bland sina folk (hebr. goj). Dessa kan syfta på Javans söner (vers 4) men troligtvis är det alla Jafets söner som åsyftas (vers 2-4). Ländernas öar skulle kunna syfta på kontinenterna, men här finns även en bildlig tolkning att varje nation är en egen ”ö” som integrerar med andra nationer. Hebr. goj syftar på ett folk som bor på en viss plats, det kan innehålla olika etniska folkgrupper, men ofta är det en folkgrupp. Den grekiska formen av Jafet är Iapetos, och enligt grekisk tradition är det grekernas förfader. Det hebreiska namnet Javan betyder ”ung” men också landet Grekland, se Dan 8:21; 10:20. Jafet är alltså troligtvis förfader till ”sjöfolken” som spred ut sig runt Medelhavet. Totalt 30 ättlingar till Cham (Ham) nämns. Chams söner rör sig främst sydväst mot Egypten och norra Afrika, men även arabiska halvön. Kanaan (som bodde i Kanaans land som israeliterna intog) hör även till denna grupp. ");
INSERT INTO swe_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Chams (Hams) söner var: Kush betyder ”svart”; motsvarar det afrikanska riket Nubien; nuvarande södra Egypten, Etiopien och Sudan och Mitsrajim Egypten och Put (hebr. Pot) motsvarar nuvarande Libyen, se Jer 46:9; Hes 30:5; 38:4-6 och Kanaan nuvarande Israel. ");
INSERT INTO swe_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Chams första son Kushs söner var: Seva (Seba) övre Egypten (södra Egypten) och Havila (hebr. Chavila) ismaeliterna, se 1 Mos 25:18; östra Arabien och Persiska viken och Savetta folk i Arabien och Raama folk i Arabien och Savettecha. Kushs fjärde son Raamas söner var: Sheva betyder ”sju” eller ”ed”; troligtvis Saba i nuvarande Jemen eller Aksum i Etiopien och Dedan folk i Arabien; nuvarande Saudiarabien. ");
INSERT INTO swe_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush Chams första son, se vers 6 födde Nimrod. Han blev en mäktig på jorden. Namnet Nimrod härstammar från verbet marad som betyder ”att göra uppror” och förknippas med Babels torn, se 1 Mos 11:1-9, se även 1 Krön 1:10; Mika 5:5. ");
INSERT INTO swe_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Han var en mäktig (våldsam) jägare inför Herrens (Jahvehs) ansikte. Därför finns talesättet: ”Likt Nimrod, en mäktig jägare inför Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Och det förnämsta (de första – hebr. reshit) i hans kungarike var de fyra städerna Babylon och Erech och Akkad och Chalne i Shinars land. ");
INSERT INTO swe_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Från det landet kom Ashor fram och byggde Nineve och staden Rechovot och Kalach ");
INSERT INTO swe_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","och Resen mellan Nineve och Kalach (Nimrod), som är en stor stad. ");
INSERT INTO swe_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsrajim Chams andra son, vers 6 fick: Lodim och Anamim och Lehavim och Nafettuchim ");
INSERT INTO swe_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","och Patrusim och Kasluchim, som blev (stamfar till) filistéerna, och Kafettorim. ");
INSERT INTO swe_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan Chams fjärde son som Noa förbannade, se 1 Mos 9:25-27 fick: Sidon hebr. Tsidon, från verbet tsod att jaga/fiska; även namnet på kuststaden Sidon i nuvarande Libanon, hans förstfödde, och Chet förfader till hettiterna, ");
INSERT INTO swe_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","och jevusiterna (jebuséerna – hebr. jevosi) folket som bodde i Jerusalem innan israeliterna kom dit och amoréerna (hebr. emori) och girgaseerna (hebr. girgashi) ");
INSERT INTO swe_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","och hivéerna och arkiterna fenikiskt folk och siniterna fenikiskt folk ");
INSERT INTO swe_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","och arvaditerna fenikiskt folk och tsemariterna fenikiskt folk och hammatiterna fenikiskt folk. Dessa folk bodde i landet innan israeliterna kom dit. Därefter blev kanaanéernas familjer (klaner) utspridda (långt utanför sina tidigare gränser). ");
INSERT INTO swe_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaanéernas gränser sträckte sig från Sidon kuststaden i Syrien i norr, ner mot Gerar, till Gaza i söder vidare bort mot Sodom och Gomorra och Admah betyder: röd jord och Tsevojim betyder: gaseller ända till Lasha. ");
INSERT INTO swe_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Detta är Chams (Hams) söner efter deras familjer, efter deras språk i sina landområden och i sina folkslag. Totalt 26 ättlingar till Shem nämns. Till Sems söner (”semiterna”) hör hebréerna (Evers ättlingar, se vers 21), araméerna, assyrierna m.fl. Områdena de rör sig till är främst österut och motsvarar Mesopotamien och Arabien. Introduktionen till Shem är annorlunda än för hans bröder Jafet och Chem (vers 2 och 6) där det bara står ”Jafets söner” och ”Chems söner”. Här betonas denna del av släktträdet genom att ha en längre skrivning ”till Shem föddes barn”. Det är via Shem, Arppacheshad, Shelach, Ever, Peleg som sedan Abraham kommer födas. Redan i inledningen betonas Ever som är den fjärde generationen från Noa, det släktled som kommer leda fram till Abraham och Messias. ");
INSERT INTO swe_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Till Shem föddes också barn. Shem var förfader till alla Evers barn fyra generationer framåt, se vers 24-25, ordet betyder ”gå över” och har gett upphov till ordet ”hebré” och Jafets bror den äldre. Ordagrant avslutas den hebreiska meningen med ”broder Jafet äldre”. Det går att tolka det hebreiska adjektivet hagadol så betydelsen blir: ”Jafet var den äldre brodern”. Så gör den grekiska översättningen Septuaginta och många judiska rabbiner. Andra tolkar frasen som ”Jafets äldre broder” och att det är Shem som är Jafets äldre broder. Liknande formulering finns i Dom 1:13 där Kenas är Kalebs yngre bror. Den syriska, latinska och många moderna översättningar väljer denna tolkning. Kärnbibeln lutar sig mot 1 Mos 11:10 och 1 Mos 11:26 där det verkar som om Jafet är äldst, se även vers 1. ");
INSERT INTO swe_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shems barn var: Elam elamiterna; öster om Tigris och Ashor assyrierna och Arppacheshad babylonierna? och Lod och Aram araméerna; Syrien. ");
INSERT INTO swe_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arams söner var: Us (hebr. Ots) och Chol och Geter och Mash. ");
INSERT INTO swe_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arppacheshad Chems tredje son, se vers 22 fick: Shelach. Shelach fick: Ever ”hebréerna”. ");
INSERT INTO swe_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Till Ever föddes två söner: Namnet på den ena var Peleg snarlikt ordet för ”delad”, för under hans dagar delades (hebr. pilag) jorden, och hans bror hette Joktan. Pelegs fortsatta släktled fortsätter i 1 Mos 11:16-26 och leder fram till Abrahams far Tera. Peleg betyder delning. Det skulle mycket väl kunna vara så att det som står här, att jorden delades under hans dagar, kan syfta på uppdelningen av Pangea i de olika kontinenterna med hav emellan, som vi känner dem idag. I så fall inträffade denna delning ungefär 100 år efter floden. Se även slutet på vers 32. ");
INSERT INTO swe_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Evers andra son Joktan fick: Almodad och Shelef och Chatsarmavet folk i Sydarabien och Jerach ");
INSERT INTO swe_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","och Hadoram och Ozal och Dikla ");
INSERT INTO swe_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","och Oval och Avimael och Sheva ");
INSERT INTO swe_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","och Ofir och Havila (hebr. Chavila) och Jovav, alla dessa var Joktans söner. ");
INSERT INTO swe_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","De hade sina boplatser från Mesha som går mot Sefar till bergen i öster. Här används hebr. kedem för öster. Det är ett rikt ord som inte bara har betydelsen av ett väderstreck utan också används för att beteckna när en människa gör bokslut i sitt liv och ser både bakåt och framåt. Vi får göra upp med det som har varit och se visioner och planera för framtiden i detta väderstreck. Det finns också mycket annat knutet till öster som soluppgången med alla dess typologier, morgonstjärnan i öster och så vidare. ");
INSERT INTO swe_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Detta vers 22-30 är Shems söner efter deras familjer, efter deras språk i sina landområden och i sina folkslag. Denna vers avslutar och ramar in stycket om Shems söner. ");
INSERT INTO swe_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Detta vers 1-30 är Noas söners familjer, efter släktled (hebr. toledot) plural i deras folk. Och från dessa finns de folk som utbrett sig på jorden efter floden. Denna vers ramar in hela kapitlet om Noas söner. Frasen och den avslutande refrängen ”efter deras språk i sina landområden och i sina länder” återkommer i vers 5, 20 och 31. ");
INSERT INTO swe_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hela jorden (världen) talade ett gemensamt språk och man uttryckte sig på samma sätt (hade ett gemensamt språk för både tal och skrift). ");
INSERT INTO swe_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","När de flyttade österut hittade de en slätt i Sinear och bosatte sig där. Området är den bördiga dalen mellan floderna Eufrat och Tigris, det som senare kom att bli Babylon, nuvarande Irak. ");
INSERT INTO swe_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sedan sa de till varandra: ”Kom, låt oss göra tegel och bränna det (härda det ordentlig).” Man använde tegel i stället för sten, och jordbeck i stället för murbruk. ");
INSERT INTO swe_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","De sa: ”Kom, låt oss bygga en stad och ett torn (hebr. migdal) som når ända upp i himlen. Då ska vårt namn bli känt, och vi behöver inte bli kringspridda över hela jorden.” Detta går helt emot vad Gud sagt om att de skulle uppfylla hela jorden, se 1 Mos 9:1, 7. Ett ziggurat är ett religiöst tempeltorn. Det är byggt på liknande sätt som en pyramid, men med en trappa som leder till toppen. Högst upp var den plats som kallades Babilu – ”Porten till Gud”. Här fanns ett rum med en bädd och ett bord. Man ville hålla sig väl med sina gudar genom att ge dem en plats där de kunde vila och äta. Både bokstavligt och bildligt försöker människan själv nå Gud på sina villkor genom att bygga ett torn med en trappa upp till Gud. ");
INSERT INTO swe_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Men Herren steg ner för att se staden och tornet som människorna hade börjat bygga. ");
INSERT INTO swe_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Herren sa: ”Folket är helt enat och de talar alla ett och samma språk. Detta är bara början på vad de kommer att göra som går emot min vilja. Ingenting de beslutar sig för att göra kommer att vara omöjligt för dem. Det finns inga gränser för hur långt de kommer att fortsätta i sin synd. ");
INSERT INTO swe_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kom, låt oss gå ner och förvirra (röra ihop) deras språk så att de inte förstår varandra.” Resultatet av enhet som utelämnar Gud är förvirring. ");
INSERT INTO swe_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Så spridde Herren (Jahveh) människorna över hela jorden, och de slutade att bygga staden. ");
INSERT INTO swe_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Därför fick den namnet Babel, eftersom det var där Herren (Jahveh) förvirrade jordens gemensamma språk till ett obegripligt ”babbel”, och därifrån spridde Herren (Jahveh) ut människorna över hela jorden. Hebr. bavel betyder att ”förvirra” och är snarlikt det babyloniska ordet babilu som betyder ”porten till Gud”. Vårt svenska ord ”babbel” kommer just från detta ord. Här kommer en ny ”toledot-enhet” som formar den sjätte litterära enheten (av tolv) i Första Moseboken. ");
INSERT INTO swe_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Detta är Shems (Sems) fortsatta historia (hans genealogi/släkttavla – hebr. toledot). Nu följer tio generationer från Shem fram till Abram. När Shem var 100 år gammal blev han far till Arppacheshad, två år efter floden hade startat. ");
INSERT INTO swe_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Och Shem levde 500 år efter att han blivit far till Arppacheshad. Och han blev far till söner och döttrar. Shem blev 600 år. ");
INSERT INTO swe_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Och Arppacheshad levde 35 år innan han blev far till Shelach. ");
INSERT INTO swe_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Och Arppacheshad levde 403 3 år och 400 år efter att han blivit far till Shelach. Och han blev far till söner och döttrar. Arppacheshad blev 438 år. ");
INSERT INTO swe_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Och Shelach levde 30 år innan han blev far till Ever. ");
INSERT INTO swe_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Och Shelach levde 403 år 3 år och 400 år efter att han blivit far till Ever. Och han blev far till söner och döttrar. Shelach blev 433 år. ");
INSERT INTO swe_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Och Ever levde 34 år innan han blev far till Peleg. ");
INSERT INTO swe_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Och Ever levde 430 år 30 år och 400 år sedan han blivit far till Peleg. Och han blev far till söner och döttrar. Ever blev 463 år. ");
INSERT INTO swe_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Och Peleg levde 30 år innan han blev far till Reo. ");
INSERT INTO swe_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Och Peleg levde 209 år 9 år och 200 år efter att han blivit far till Reo. Och han blev far till söner och döttrar. Peleg blev 239 år. ");
INSERT INTO swe_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Och Reo levde 32 år innan han blev far till Serog. ");
INSERT INTO swe_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Och Reo levde 207 år 7 år och 200 år efter att han blivit far till Serog. Och han blev far till söner och döttrar. Reo blev 239 år. ");
INSERT INTO swe_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Och Serog levde 30 år innan han blev far till Nachor. ");
INSERT INTO swe_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Och Serog levde 200 år efter att han blivit far till Nachor. Och han blev far till söner och döttrar. Serog blev 230 år. ");
INSERT INTO swe_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Och Nachor levde 27 år innan han blev far till Terach. ");
INSERT INTO swe_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Och Nachor levde 119 år 19 år och 100 år efter att han blivit far till Terach. Och han blev far till söner och döttrar. Nachor blev 146 år. ");
INSERT INTO swe_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Och Terach levde 70 år innan han blev far till Abram, Nachor och Haran. Här kommer en ny ”toledot-enhet” som formar den sjunde litterära enheten (av tolv) i Första Moseboken. ");
INSERT INTO swe_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Detta är Terachs (Teras) fortsatta historia (hans genealogi/släkttavla – hebr. toledot). Terach blev far till Abram, Nachor och Haran, och Haran blev far till Lot. ");
INSERT INTO swe_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran dog inför sin far Terachs ansikte i landet där han föddes, i Ur i Kaldéen. ");
INSERT INTO swe_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram och Nachor tog sig hustrur. Abrams hustru hette Saraj och Nachors hustru hette Milkah betyder: ”drottning”, Harans dotter – far till Milkah och far till Iskah betyder: ”någon som vakar och är observant”. ");
INSERT INTO swe_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Men Saraj var ofruktsam, hon hade ingen livsfrukt (avkomma – hebr. valad). Ovanligt ord för livsfrukt som bara används här i GT. Det betonar en manlig avkomma som kan föra släkten vidare. Det vanliga ordet är hebr. jeled. ");
INSERT INTO swe_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terach tog Abram, sin son och Lot, Harans son, och Saraj, sin svärdotter, Abrams hustru, och de vandrade iväg från Ur i Kaldéen och de kom till Haran (hebr. Charan) där de vistades. ");
INSERT INTO swe_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Alla dagar som Terach levde var 205 år, sedan dog Terach i Haran. ");
INSERT INTO swe_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nu sa Herren (Jahveh) till Abram: ”Gå du (själv) ut (hebr. lech lecha) från ditt land Haran i Mesopotamien och från din släkt (hemort) och från din fars hus Tera och hans familj, se 1 Mos 11:31-32 till landet jag ska visa dig. Att lämna allt och följa Gud krävde tro, se Heb 11:8-10. I det hebreiska uttrycket lech lecha finns också betydelsen att ”gå till sig själv”, dvs. att hitta sig själv i processen. Ordet släkt (hebr. moledet) betyder inte bara släkt utan även ”platsen för din födelse” och ”ursprung”. Det syftar på en längre historia bakåt än bara din egen livstid. Liknande fras använder Jesus när han kallar, se Matt 10:37. Tre gånger upprepas frasen ”från”, vilket följs av tre löften: ett nytt land, ett nytt folkslag och välsignelse till både honom själv och flera. ");
INSERT INTO swe_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Jag ska göra dig till ett stort folkslag en stor familj och jag ska välsigna dig och göra ditt namn stort (dig ärbar) och du ska bli en välsignelse. ");
INSERT INTO swe_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Och jag ska välsigna dem som välsignar dig, och den singular som vanärar dig (ringaktar, inte respekterar; ordagrant: ”tar lätt på dig”) ska jag förbanna (helt förgöra), och välsignade – ska alla jordens familjer (släkter, nationer) bli i dig Abram.” Vers 2-3 formar en kiasm i flera nivåer. Den yttre ramen handlar om folkslag/familjer, se vers 2a och 3c. Den andra nivån har att göra med välsignelse. Centralt i vers 3a finns en kiastisk struktur som rör sig från välsigna till förbanna. Den hebreiska roten för välsigna (hebr. barach) har även betydelsen att böja knä. Helheten i dessa två verser ger sju rader där välsignelse är nyckelord:  Jag ska göra dig till ett stort folkslag    Jag ska välsigna dig      Jag ska göra ditt namn stort        Du ska bli till en välsignelse      Jag ska välsigna dem som välsignar dig    Jag ska förbanna den som vanärar dig  I dig ska jordens alla folk bli välsignade ");
INSERT INTO swe_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram gick som Herren (Jahveh) hade talat till honom och Lot gick med honom. Abram var 75 år gammal när han gick från Haran (hebr. Charan) 1 Mos 11:31. ");
INSERT INTO swe_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram tog Saraj, sin hustru, och Lot, sin brorson, och alla sina tillhörigheter som de hade samlat och människorna (tjänstefolk, bokstavligt ”själarna”) som de hade fått i Haran. De gick iväg för att gå till landet Kanaan, och till landet Kanaan kom de. ");
INSERT INTO swe_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram gick genom landet till platsen Shechem, till Mores terebint ordagrant: ”lärarens ek”. På den tiden bodde kanaanéerna i landet. Shechem betyder skuldra/axel och beskriver platsen väl rent geografiskt då bergen Gerizim och Ebal ligger på var sin sida som två skuldror. Detta är första gången Shechem nämns i Bibeln. Nästa omnämnande är 200 år senare, när Abrahams barnbarn Jakob kommer hit. Den arkeologiska platsen Tell Balata hittades 1903 och har bekräftats vara Shechem. Intressant är att fynden visar att platsen har varit bebodd sedan tidig bronsålder (3500 f.Kr.), men murarna är från 1900 f.Kr. När Abraham kommer hit (strax före 2000 f.Kr.) används frasen platsen (hebr. maqom) Shechem, medan i 1 Mos 33:18 är det staden (hebr. ir) Shechem. Det hebreiska ordet ir beskriver en befäst stad. Något som också bekräftas av att dess port omnämns, se 1 Mos 34:20. Centralt i staden har fynd gjorts av ett heligt tempel med ett stort stenbelagt torg, det kan vara där den speciella eken (Mores terebint) som det refereras till, stod. Bara 500 meter söder om staden finns Jakobs brunn, se Joh 4:4. ");
INSERT INTO swe_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Herren (Jahveh) visade sig för Abram och sa: ”Till din säd alla dina efterkommande barn ska jag ge detta land.” Och han byggde ett altare där till Herren (Jahveh) som hade visat sig för honom. ");
INSERT INTO swe_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Och han flyttade från den platsen Shechem till bergen öster om Betel och slog upp sitt tält så att han hade Betel i väster och Ai i öster. Där byggde han ett altare åt Herren (Jahveh) och åkallade Herrens (Jahvehs) namn. ");
INSERT INTO swe_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram drog upp tältpinnarna och fortsatte vandra mot Negev (söderut). ");
INSERT INTO swe_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Det blev hungersnöd i landet och Abram gick ner till Egypten (hebr. Mitsrajim) för att vistas där eftersom hungersnöden var svår (tung) i landet. ");
INSERT INTO swe_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Det hände när han gick in i Egypten att han sa till sin hustru Saraj: ”Se, jag vet att du är en mycket vacker kvinna att se på. ");
INSERT INTO swe_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Det kommer att hända att när egyptierna ser dig så kommer de att säga; ’Det är hans hustru,’ och de kommer att döda mig, men låta dig leva. ");
INSERT INTO swe_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Snälla, jag ber dig, säg att du är min syster, så att det går väl med mig för din skull, så att min själ får leva på grund av dig.” 1 Mos 20:1-18; 26; Abram litar inte på att Gud ska beskydda honom. ");
INSERT INTO swe_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Och det blev så att när Abram kom till Egypten, såg egyptierna kvinnan och att hon var mycket vacker. ");
INSERT INTO swe_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Faraos prinsar såg henne och prisade henne inför farao och kvinnan togs till faraos hus. Saraj var 65 år (1 Mos 17:7; 12:4) och levde tills hon blev 127 år (1 Mos 23:1), vilket gör att hon var i medelåldern. ");
INSERT INTO swe_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Han behandlade Abram väl för hennes skull. Han hade småboskap och boskapshjordar och åsnor (hebr. chamor; hankön) och tjänare och tjänarinnor och åsneston (hebr. aton) och kameler. ");
INSERT INTO swe_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Herren (Jahveh) plågade farao och hans hus med svåra plågor för Abrams hustru Sarajs skull. ");
INSERT INTO swe_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Farao kallade till sig Abram och sa: ”Vad är det du har gjort mot mig? Varför berättade du inte att hon är din hustru? ");
INSERT INTO swe_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Varför sa du: ’hon är min syster’, så att jag tog henne till hustru. Här är din hustru, ta henne och gå härifrån!” ");
INSERT INTO swe_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farao gav sina män befallningar om honom Abram, och de förde bort honom och hans hustru och alla deras tillhörigheter. Texten berättar inte helt tydligt om plågorna förhindrar farao att fullborda äktenskapet med Saraj. Abram blir given får, kor, tjänare och tjänarinnor, åsneston och kameler, vilket talar för att han får betalt för henne. Samtidigt blir farao arg över vad Abram gjort när han drabbas av plågorna. När Abram på liknande sätt sviker Saraj ännu en gång (1 Mos 20:17-18) verkar det som om någon typ av sjukdom gjort att kvinnorna inte kunde få barn, det kan vara en parallell till plågorna i 1 Mos 12:17 som drabbar farao, något som talar för att Gud bevarade Saraj. ");
INSERT INTO swe_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram drog upp från Egypten (hebr. Mitsrajim), han och hans hustru Saraj, tillsammans med allt som tillhörde honom, även brorsonen Lot var med honom fram till Negev södra området i Kanaan. ");
INSERT INTO swe_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram var mycket rik (ordagrant ”mycket tung”) på hjordar egendom i form av boskap och på silver och guld. ");
INSERT INTO swe_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Han vandrade från lägerplats till lägerplats från Negev vidare till Betel, till platsen där hans tält hade stått första gången, mellan Betel och Ai, ");
INSERT INTO swe_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","till platsen för altaret som han gjort rest där först. Och där åkallade Abram i Herrens (Jahvehs) namn. Abram, Saraj och Lot (Abrams bror Harans son, se 1 Mos 11:27) kom nu tillbaka till den första platsen de stannat till på när de kom till Kanaans land från Haran, se 1 Mos 12:6-8. Här i Beit-el, som betyder Guds hus, åkallar Abram Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Även Lot, som gick med Abram, hade småboskap och boskapshjordar och tält. ");
INSERT INTO swe_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Men landet kunde inte försörja (bära, lyfta – hebr. nasa) dem så att de kunde bo tillsammans. Ja, det var så att deras egendomar var så väldiga att de inte kunde bo tillsammans. ");
INSERT INTO swe_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Det uppstod en dispyt mellan herdarna över Abrams hjordar och herdarna över Lots hjordar – kanaanéerna och perisséerna bodde också i landet. ");
INSERT INTO swe_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram sa till Lot: ”Låt det nu inte råda någon osämja mellan dig och mig eller mellan mina herdar och dina herdar – vi är ju bröder. ");
INSERT INTO swe_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ligger inte hela landet framför dig? Separera dig från mig nu. Om du väljer vänster går norrut, då tar jag höger då går jag söderut, och om du tar höger, då tar jag vänster.” ");
INSERT INTO swe_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot lyfte upp sina ögon. Och han betraktade hela Jordanslätten öster om Betel, se 1 Mos 12:8. Ja, hela slätten (dess helhet) var rik på vatten överallt innan Herren ödelade Sodom och Gomorra – som en Herrens trädgård, som Egyptens land, hela vägen ner till Tsoar. Tsoar var en av de fem städerna i detta område. Det var hit Lot flydde från Sodom och Gomorra (1 Mos 19:22-23). Namnet betyder ”obetydlighet”, och den hette tidigare Bela som betyder ”förstörelse”. Namnen verkar indikera att det var en mindre stad. ");
INSERT INTO swe_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Så Lot valde hela Jordanslätten åt sig. Och Lot bröt upp (begav sig av) österut. Och de skiljdes åt, som en man från sin bror. ");
INSERT INTO swe_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram slog sig ner i Kanaans land medan Lot slog sig ned vid städerna på slätten. Fem städer nämns vid Jordanslätten, se 1 Mos 14:2, 8. Ja, han Lot satte upp sitt tält invid Sodom. ");
INSERT INTO swe_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Men männen i Sodom var väldigt onda plural och stora (fruktansvärda) syndare inför Herren (Jahveh). Onda (hebr. raim) står i plural vilket förstärker att de var ”väldigt onda”. Tankarna förs tillbaka till Noas tid, se 1 Mos 6:5; 8:2. Detta är första gången substantivet syndare (hebr. chata) används. Ordet kommer från verbet chata vars bokstavliga betydelse är ”att missa målet”, se Dom 20:16. Hesekiel beskriver Sodoms sexuella synder, men också deras högmod och skamlösa behandlande av den fattige och nödställde, se Hes 16:49-50. ");
INSERT INTO swe_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Efter att Lot hade skilt sig från honom, sa Herren (Jahveh) till Abram: ”Lyft nu dina ögon! Och blicka ut från platsen där du är – mot norr och mot söder längden och mot öster och mot väster bredden. ");
INSERT INTO swe_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ja, allt (hela) det land som du ser, åt dig ska jag ge det och åt din säd alla dina efterkommande barn, till evig tid. ");
INSERT INTO swe_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Jag ska göra din säd som stoftet på jorden; kan någon räkna stoftet på jorden, då ska din säd också kunna räknas. ");
INSERT INTO swe_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Stå upp! Vandra genom landet Jos 1:3 – i hela dess längd och dess bredd. Ja, till dig ska jag ge det!” Vers 14b-17 formar en inclusio som ramas in av två parallella satser i vers 14b-15a och vers 17. Uppmaningen att lyfta upp ögonen och blicka ut över landet hör ihop med att stå upp och vandra genom landet, som båda avslutas med ett löfte att det ska ges. Centralt i vers 16 finns en kiasm som ramas in av ordet säd (hebr. zera) som jämförs med ”stoftet på jorden” som är ett uttryck som beskriver allt finfördelat material (som sand, jord och grus) över hela jorden! Poängen är att lika oräkneliga ska Abrams efterkommande bli! ");
INSERT INTO swe_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Och Abram slog ihop sitt tält, och han for i väg, och han slog sig ner vid Mamres terebintlund (stora träd – hebr. elon) som ligger vid (i) Hebron, och där byggde han ett altare åt Herren (Jahveh). Den hebreiska texten har flera verb i tät följd, vilket indikerar en hastig rörelse och visar på Abrams omedelbara handling och övertygelse om att löftet kommer att uppfyllas snabbt! Hebron (hebr. Chevron) ligger tre mil söder om Jerusalem och är knutpunkten för vägen från öst (med städer som Lachish) och söder (området i Negev). Exakta positionen av Mamre ges inte, men det är en eklund i eller nära Hebron (intill finns även en grotta, se 1 Mos 25:9). Omnämnande av ett fält (1 Mos 23:17; 23:19) gör att det kan ha varit strax utanför Hebron. ");
INSERT INTO swe_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Det hände sig i de dagar då Amrafel var kung i Shinar Babylon, Arjoch var kung i Ellasar troligtvis i Mesopotamien, Kedarlaomer var kung i Elam nuvarande Iran och Tidal var kung i Gojim pluralformen av gojim används generellt för hednanationer. ");
INSERT INTO swe_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","De fyra kungarna gick till krig mot fem andra kungar: Bera ”ondskans son”, kung i staden Sodom, och med Birsha ”med ondska”, kung i staden Gomorra, Shinav ”faderns prakt/glans”, kung i staden Admah, och Shemevel ”storslagen vinge/flykt”, kung i staden Tsevoim, och kungen i staden Bela – det är nuvarande Tsoar. Exakt var dessa städer låg är inte känt, men det är troligt att alla dessa fem allierade kungar och deras städer låg nära varandra i området kring nuvarande Döda havet. ");
INSERT INTO swe_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Alla dessa kom samman i Siddimsdalen, som nu (numera) är Salthavet (Döda havet) 1 Mos 13:10; 19:25. ");
INSERT INTO swe_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","I 12 år tjänade de Kedarlaomer kungen i Elam, men i det 13:e året gjorde de uppror. ");
INSERT INTO swe_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Och i det 14:e året kom Kedarlaomer och de kungar, som var med honom, och de slog rafaéerna i Asterot-Karnaim och suséerna ”de rovlystna vilddjuren” i Ham troligtvis Tell Ham i närheten av Irbid i nuvarande Jordanien och eméerna ”skräck-folket”; ett resligt folkslag (jättar) i Moab, se 5 Mos 2:10-11 i Save-Kirjataim ");
INSERT INTO swe_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","och horéerna (ordagrant: ”grottinvånare” – hebr. chori) på deras berg Seir sydöst om Döda havet i Edom, intill El-Paran, som är vid öknen. ");
INSERT INTO swe_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sedan vände de om och kom till Ein-Mishpat betyder: ”rättvisans källa”, det vill säga Kadesh, och erövrade hela amalekiternas land. De slog också amoréerna som bodde i Hasason-Tamar. ");
INSERT INTO swe_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodoms kung drog då ut tillsammans med Gomorras kung, Admahs kung, Tsevojims kung och kungen i Bela, det vill säga Tsoar. De ställde upp sig till strid mot dem i Siddimsdalen, ");
INSERT INTO swe_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mot Elams kung Kedarlaomer, Gojims kung Tidal, Shinars kung Amrafel och Ellasars kung Arjoch – fyra kungar mot fem. ");
INSERT INTO swe_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Men Siddimsdalen var full av jordbecksgropar. Sodoms och Gomorras kungar flydde och föll då ner i dem. De andra flydde till bergsbygden. ");
INSERT INTO swe_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Så tog man de fyra segrande kungarna all egendom och all mat (proviant) som fanns i Sodom och Gomorra och tågade bort. ");
INSERT INTO swe_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","De tog också med sig Abrams brorson Lot och allt han ägde, eftersom han bodde i Sodom. ");
INSERT INTO swe_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Men en som lyckats fly kom och berättade detta för Abram, hebréen. Han bodde vid amoréen Mamres terebintlund. Mamre var bror till Eshkol och Aner, och de var i förbund med Abram. ");
INSERT INTO swe_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","När Abram hörde att hans broder släktingen Lot var tillfångatagen lät han sina mest erfarna män rycka ut, 318 män som var födda i hans hus, och de förföljde fienderna ända till Dan i norr. ");
INSERT INTO swe_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Den natten delade han upp sitt folk i grupper och överföll dem med sina tjänare, slog dem och förföljde dem ända till Hoba, norr om Damaskus i Syrien ");
INSERT INTO swe_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","och tog tillbaka all egendom. Sin broder släkting Lot och hans ägodelar tog han också tillbaka, liksom kvinnorna och det övriga folket. ");
INSERT INTO swe_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","När Abram hade kommit tillbaka efter att ha slagit Kedarlaomer och kungarna som var med honom, gick Sodoms kung ut för att möta honom i Shavedalen, det vill säga Kungadalen alldeles i närheten av Jerusalem. ");
INSERT INTO swe_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek, kungen i Salem Jerusalem; hebr. shalem betyder frid och helhet, bar ut bröd och vin. Han var präst åt den Högste Guden (El Elion). Det hebreiska namnet Malki-zedek betyder: ”Min kung är rättfärdig”. Se även Ps 110; Heb 5:6-10; 6:20-7:28. Kopplingen mellan hans namn och staden finns också i orden ”rättfärdighet” och ”frid”. Dessa två ord återfinns ofta tillsammans, se Ps 85:11; Jes 9:7; 32:17; 48:18; 60:17. ");
INSERT INTO swe_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Och han välsignade honom och sa: ”Välsignad är Abram av Gud den Högste (El Elion), Skapare av himlarna och jorden, ");
INSERT INTO swe_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","och välsignad är Gud den Högste (El Elion) som har gett dina fiender i din hand.” Och han Abram gav honom Melkisedek tionde av allt som han fört tillbaka som krigsbyte från slaget. Heb 7:4-11 ");
INSERT INTO swe_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Och Sodoms kung sa till Abram: ”Ge mig folket och ta godset för dig själv.” ");
INSERT INTO swe_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Men Abram sa till Sodoms kung: ”Jag har lyft upp min hand till Herren (Jahveh) Gud den Högste (El Elion), skapare av himlarna och jorden, ");
INSERT INTO swe_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","att jag inte ska ta en tråd, inte ens en rem till en sandal, eller något som är ditt, för att du inte ska säga: ’Jag har gjort Abram rik.’ ");
INSERT INTO swe_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Jag ska inte behålla något förutom det som ynglingarna (tonåringarna – hebr. naar) har ätit. När det gäller männen (hebr. enosh) som gick med mig – Aner, Eshkol och Mamre – låt dem ta sin del.” ");
INSERT INTO swe_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","En tid därefter kom Herrens ord till Abram i en syn: ”Var inte rädd, Abram (Avram)! Jag är din sköld, din belöning, mycket stor.” Den sista delen kan tolkas som att Abrams belöning ska bli stor eller att Herren är hans stora belöning. Utifrån sammanhanget verkar det till en början syfta på en materiell belöning, men det kan vara en medveten dubbeltydighet i den hebreiska texten. Abram hade nyligen avböjt erbjudandet från Sodoms kung att behålla ett krigsbyte och han har gett tionde till Melkisedek. Utifrån svaret i nästa vers, verkar det som att Abram tolkar det som en materiell belöning, men undrar vad detta spelar för roll när han inte har någon arvinge. Gud har däremot något mycket större än bara rikedom för Abram – han ska bli Abraham och kallas ”trons far” och få Herren som sin belöning. ");
INSERT INTO swe_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram sa: ”Herre Herre (Adonai Jahveh), vad ska du ge mig? Du ser att jag går bort barnlös och han som ska ta över ägodelarna i mitt hus är Eliezer från Damaskus.” ");
INSERT INTO swe_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram sa vidare: ”Se, till mig har du inte gett någon säd (arvinge, eget barn) och en som är född i mitt hushåll ska bli min arvinge” Tjänarna i ett hushåll på denna tid kunde räknas som ”tillhörigheter” i hushållet eftersom de hade en form av slavstatus. Att Abram har för avsikt att låta en av dessa ärva honom i brist på egna barn säger ganska mycket om hans sätt att se på dessa människor. Abram var en god herre för sina tjänare. ");
INSERT INTO swe_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Men Herrens (Jahvehs) ord kom till honom, han sa: ”Denne man ska inte bli din arvinge, utan den som kommer från din egen kropp mage, tarm – hebr. meeh; syftar på nedre regionen av kroppen, inte enbart genitalierna, men de är inkluderade i uttrycket ska bli din arvinge.” ");
INSERT INTO swe_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Herren förde ut Abram från tältet till den stjärnklara natten och sa: ”Blicka upp mot himlen och räkna stjärnorna, om du kan!” Sedan sa han till honom: ”Så talrika ska dina ättlingar bli.” ");
INSERT INTO swe_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram trodde (litade, förtröstade) på Herren (Jahveh), och Herren (Jahveh) räknade honom som rättfärdig (tillskrevs rättfärdighet – han gjordes fri från synd och skuld, fick det rätt ställt med Gud). Abram trodde på löftet om ett barn, och talrika ättlingar, han trodde att Messias skulle komma genom hans säd och han trodde på honom som sin Frälsare, se Joh 8:56. I både GT och NT finns det bara ett sätt att bli rättfärdig på, nämligen av nåd genom tro, se Rom 4:3. ");
INSERT INTO swe_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Han sa till honom: ”Jag är Herren (Jahveh) som har fört dig ut från Ur i Kaldéen för att ge dig detta land som arv.” 2 Mos 12:1-3 ");
INSERT INTO swe_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Han sa: ”Herre Herre (Adonai Jahveh), hur ska jag veta (kunna känna till) att jag ska ärva det?” ");
INSERT INTO swe_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Han sa till honom: ”Ta till mig en tre år gammal kviga, och en tre år gammal get av honkön, och en tre år gammal bagge, och en turturduva och en ung duva.” ");
INSERT INTO swe_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Han tog allt detta till honom och delade dem på mitten och lade varje halva mitt emot varandra, men fåglarna delade han inte. ");
INSERT INTO swe_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Och rovfåglarna kom ner på kadavren men Abram drev bort dem. ");
INSERT INTO swe_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Och det hände när solen hade gått ner att en djup sömn föll över Abram och även fruktan och stort mörker föll över honom. ");
INSERT INTO swe_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Han sa till Abram: ”Du ska veta (känna väl till) att din säd (dina arvingar, efterkommande) ska bli främlingar i ett land som inte är deras, och ska tjäna dem och de ska vara plågade av dem i 400 år, ");
INSERT INTO swe_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","och även det folk egyptierna, som de ska tjäna som slavar, ska jag döma. Efteråt ska de komma ut med stora rikedomar. 2 Mos 12:33-36 ");
INSERT INTO swe_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Men du ska gå till dina fäder i frid. Du ska bli begraven vid en god (hög) ålder. ");
INSERT INTO swe_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I den fjärde generationen ska de komma tillbaka hit, för amoréernas missgärning är inte full än. Deras synders mått har inte uppnått mängden som krävs för dom, se 3 Mos 18:24-25; 20:23-24.” ");
INSERT INTO swe_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Och det hände när solen gick ner och där var ett tjockt mörker, att då syntes en rykande ugn och en flammande fackla som passerade mellan styckena (de delade djuren). Här beskrivs en del av den ritual som hör till när man ingår ett blodsförbund med varandra ");
INSERT INTO swe_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Den dagen skar Herren ett förbund med Abram (ingick ett blodsförbund) och sa: ”Till din säd (din avkomma, dina arvingar) har jag gett detta land, från Egyptens flod till den stora floden, floden Eufrat, ");
INSERT INTO swe_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","keniterna och keniziterna och kadmoneerna ");
INSERT INTO swe_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","och hettiterna och perisséerna och rafaeerna ");
INSERT INTO swe_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","och amoréerna och kanaanéerna och girgashéerna och jevusiterna.” Namnen på de folkslag som levde i Kanaan innan israeliterna kom dit. Det unika med förbundet som ingås mellan Gud och Abram är att det ingås ensidigt. Gud bär det fullständiga och hela ansvaret för detta förbund! Ritualerna som ingår i ett blodsförbund är:  1. Byta mantel – iklä sig den andra personen.  2. Byta bälte – vapen/redskap.  3. Skära – dela djur i halvor. Vandra mellan dem. Ett blodsförbund skärs alltid.  4. Byta/ta varandras namn.  5. Göra ett ärr (Blanda blod – handflatorna mot varandra).  6. Ge förbundslöften.  7. Äta minnesmåltid – dela bröd och vin.  8. Plantera ett minnesträd/vårdträd bestänkt med blod från djuren.  När Gud säger till Abram ”Jag är din sköld” (se vers 1) tar Gud initiativet till att ge Abram sin mantel och sitt bälte. Manteln är inte fysisk i det här sammanhanget men den representerar personen, så det Gud säger är att han ger sig själv till Abram. Ärret som ska göras blir i Abrams fall omskärelsen. Eftersom ett blodsförbund kan gå i arv så måste varje ny son som föds själv välja om han vill vara kvar i förbundet. Detta sker varje gång en judisk son blir omskuren (för icke-judar motsvaras det av hjärtats omskärelse). Förbundslöftet är sonen, Isak, och att avkomman ska bli som stjärnorna och sandkornen och att alla folk ska bli välsignade genom honom. Det sker ett namnbyte när Abram blir Abraham, se 1 Mos 17:5. Han får också Guds eget namn tillagt i sitt eget och Gud kallas i fortsättningen för Abrahams Gud, vilket senare när förbundet förnyas med Isak och Jakob får tilläggen Isaks Gud och Jakobs Gud. Förbundsmåltiden sker när Abraham möter Melkisedek och de delar bröd och vin, se 1 Mos 14:18. Melkisedek (som betyder rättfärdighetens kung) är sannolikt Jesus själv som kommer till Abram vid detta tillfälle. ");
INSERT INTO swe_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram och hans hustru Saraj var barnlösa. I denna kultur var detta något skamfullt. Gud hade dock lovat dem ett eget barn som skulle bli deras arvinge, se 1 Mos 12:2. Tio år tidigare hade Abram försökt adoptera sin tjänare Elieser för att få en arvinge, men Gud förtydligade då sitt löfte att det verkligen skulle vara hans egen son, se 1 Mos 15:2-4. Abram är nu 85 år och Saraj 75 år, se 1 Mos 12:4; 17:17. Saraj hade en egyptisk tjänstekvinna som hette Hagar som de troligen fått av farao när de var i Egypten, se 1 Mos 12:16. ");
INSERT INTO swe_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraj sa till Abram: ”Eftersom Herren har gjort så att jag inte kan få barn, så ligg med min tjänarinna. Kanske kan jag få en familj genom henne.” Saraj följde den dåtida kulturens tradition att ge en av sina tjänarinnor till sin man för att bli surrogatmor. Abram lyssnade på Sarajs ord (lydde henne). ");
INSERT INTO swe_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Efter tio år i Kanaans land gav Saraj, Abrams fru, sin egyptiska tjänarinna Hagar till sin man som en andra fru. ");
INSERT INTO swe_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram låg med Hagar och hon blev gravid. När Hagar fick reda på att hon var gravid började hon se ner på (förakta) sin föreståndarinna (härskarinna, överordnade). ");
INSERT INTO swe_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Då sa Saraj till Abram: ”Det är ditt fel att all denna orätt (kränkning, laglöshet, terror, destruktiva kraft – hebr. chamas) har drabbat mig. Jag tillät min tjänarinna att ligga med dig, men när hon såg att hon var gravid började hon förakta mig. Låt Herren döma mellan mig och dig.” Sista delen kan också översättas: ”Låt Gud straffa dig för det här.” ");
INSERT INTO swe_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram sa till Saraj: ”Eftersom du bestämmer över din tjänarinna, så gör vad du vill med henne.” Då började Saraj gå så hårt åt Hagar att hon flydde bort från Saraj. Abram tar inte ansvar, utan låter Saraj agera utifrån sin bitterhet. ");
INSERT INTO swe_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Herrens ängel (budbärare) hittade Hagar nära en vattenkälla i öknen, källan som ligger på vägen mot öknen Sur. ");
INSERT INTO swe_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ängeln frågade: ”Hagar, Sarajs tjänarinna, varifrån kommer du och vart är du på väg?” Hon svarade: ”Jag flyr från min föreståndarinna, Saraj.” Vattenkällan ligger på väg till Egypten, Hagar försökte kanske ta sig hem till sitt land, en sträcka på ca 25 mil. Att ensam och dessutom gravid försöka göra denna resa i oländig öken är dömt att misslyckas, vilket hon förstått eftersom hon inte svarar på frågan vart hon är på väg. Hon flyr mållöst från sina problem. Frågan ”varifrån kommer du?” betyder på hebreiska inte så mycket från vilken plats, utan snarare från vilka omständigheter kommer du, vilken situation lämnar du? ");
INSERT INTO swe_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Då sa Herrens ängel till henne: ”Vänd tillbaka till din föreståndarinna och ödmjuka dig under henne.” ");
INSERT INTO swe_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Herrens ängel sa: ”Jag ska göra din ätt (ditt släkte) mycket stor. Den ska bli så stor att ingen kan räkna dem alla.” ");
INSERT INTO swe_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sedan sa Herrens ängel till henne: ”Du är nu gravid och ska snart föda en son. Du ska ge honom namnet Ismael (hebr. Jishmael) betyder: ”Herren hör”, för Herren (Jahveh) har hört (hebr. shama) hur du plågats (varit under andras våld). ");
INSERT INTO swe_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Din son ska bli en vild man (omöjlig att tämja, som en vildåsna); hans hand ska vara emot alla, och alla ska vara emot honom (det ska vara ständig konflikt runt omkring honom). Han ska bo borta (österut) från alla sina bröder.” ");
INSERT INTO swe_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar gav Herren (Jahveh), som hade talat med henne, ett namn: ”Du är en Gud som ser (hebr. El-Roi).” Hon sa (tänkte): ”Har jag verkligen fått se en skymt (ryggen) av honom som ser (hebr. raah) mig?” Hagar var uppväxt i Egypten och van vid gudar gjorda av trä och sten som varken talade eller såg. Nu hade hon med egna ögon fått möta den levande Guden. ");
INSERT INTO swe_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Därför fick källan namnet ”Den levandes brunn han som ser mig (hebr. Beer lachai-roi)”, den ligger mellan Kadesh och Bared. Det är vid samma källa eller brunn som Isak möter sin hustru Rebecka första gången, se 1 Mos 24:62. ");
INSERT INTO swe_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar födde en son till Abram och Abram gav sin son, som Hagar fött, namnet Ismael. ");
INSERT INTO swe_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram levde 86 år innan Hagar födde Ismael åt Abram. ");
INSERT INTO swe_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","När Abram var 99 år gammal, visade sig Herren (Jahveh) för Abram och sa till honom: ”Jag är Gud Allsmäktig (El Shaddaj), vandra inför mig (framför mitt ansikte) och var fullkomlig. Ordet fullkomlig står här i plural vilket förstärker att det gäller alla områden i hela livet. ");
INSERT INTO swe_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jag ska förnya förbundet mellan mig och dig och jag ska göra det mycket, mycket stort (omfattande).” ");
INSERT INTO swe_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram föll ner på sitt ansikte och Gud (Elohim) talade med honom och sa: ");
INSERT INTO swe_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","”Se, för min del är mitt förbund med dig, och du ska bli till en far för många folk (folkslag, nationer – hebr. gojim). Här gör Gud klart att det inte är någon annan än Abram han vill göra förbund med. Det är alltså en bekräftelse på utkorelsen. ");
INSERT INTO swe_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Du ska inte längre heta Abram, utan ditt namn ska vara Abraham. Gud lägger till bokstaven h (hebr. he), så namnet blir Abra ham. Detta är signifikant eftersom hebreiska bokstaven he uttalas som en utandning. Det låter som när man blåser ut luft för att putsa ett par glasögon. Gud blåser in sin Ande in i Abrahams namn! Med Guds Andes hjälp ska undret ske! På hebreiska uttalas namnen Avram och Avraham. Även Saraj får ett nytt namn – Sarah, se vers 15. För jag ska låta dig bli en far för många folk (nationer). ");
INSERT INTO swe_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Jag ska göra dig mycket, mycket fruktsam och jag ska skapa folkslag från dig och kungar ska komma från dig (bli dina ättlingar), ");
INSERT INTO swe_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","och jag ska upprätta (etablera) mitt förbund mellan mig och dig och din säd (dina efterkommande, ättlingar) efter dig, genom deras generationer som ett evigt förbund, för att vara Gud (Elohim) till dig och till din säd efter dig, ");
INSERT INTO swe_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","och jag ska ge till dig och till din säd efter dig (dina ättlingar) landet som du vandrat runt i, hela Kanaans land, till en evig besittning, och jag ska vara deras Gud (Elohim).” ");
INSERT INTO swe_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Gud sa till Abraham: ”Vad gäller dig, ska du hålla mitt förbund, du och din säd (dina efterkommande, ättlingar) efter dig, genom deras generationer. ");
INSERT INTO swe_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Detta är mitt förbund, som ni ska hålla, mellan mig och dig och din säd (dina efterkommande, ättlingar) efter dig, varje man bland er ska bli omskuren. ");
INSERT INTO swe_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ni ska bli omskurna på ert kött, på er förhud, och det ska vara en symbol på förbundet mellan mig och er. ");
INSERT INTO swe_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Sonen som är åtta dagar gammal ska bli omskuren bland er, alla män i alla generationer, han som är född i huset eller köpt för pengar av någon främling, den som inte är din säd (egna barn). ");
INSERT INTO swe_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Han som är född i ditt hus och han som är köpt med dina pengar måste bli omskuren. Mitt förbund ska vara på ditt kött som ett evigt förbund. ");
INSERT INTO swe_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Den oomskurne mannen som inte är omskuren på köttet på sin förhud, den mannen (bokstavligt själen) ska bli avhuggen (utesluten) från sitt folk, han har brutit mitt förbund.” ");
INSERT INTO swe_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Sedan sa Gud till Abraham: ”Din hustru ska inte längre heta Saraj, utan hennes namn ska vara Sarah. ");
INSERT INTO swe_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Jag ska välsigna henne och ska tillsammans med dig ge henne en son. Jag ska välsigna henne och hon ska bli en mor till många folkslag (nationer – hebr. gojim). Kungar över folk (hebr. am) ska komma från henne!” På samma sätt som Gud lägger till bokstaven h, ”He”, i Abrahams namn (se vers 5), så gör Gud på samma sätt med Saraj så hennes namn blir Sara h. Detta är signifikant eftersom bokstaven he uttalas som en utandning. Gud blåser sitt liv in i Sarajs namn och med Guds Andes hjälp ska undret ske! ");
INSERT INTO swe_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Då föll Abraham ner på sitt ansikte och skrattade (hebr. tsachaq) den första av tre gånger ordet för att skratta som har samma rot som Isaks namn Jitschaq används, se även 1 Mos 18:12; 21:6 och sa i sitt hjärta (för sig själv): ”Skulle en som är 100 år gammal bli far? Och kan Sarah, som är 90 år, föda barn?” Ordagrant står det ”en son på 100 år” och ”en dotter på 90 år”. ");
INSERT INTO swe_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Och Abraham sa till Gud (Elohim): ”Måtte Ismael leva inför dig!” ");
INSERT INTO swe_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Gud svarade: ”Nej, men Sarah, din hustru, ska föda en son och du ska ge honom namnet Isak hebr. Jits-chak från verbet för att skratta, och jag ska upprätta (etablera) mitt förbund med honom som ett evigt förbund för honom och hans säd (efterkommande, ättlingar) efter honom. ");
INSERT INTO swe_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Vad angår Ismael har jag hört dig, och se jag har välsignat honom och ska göra honom fruktsam och ska föröka honom rikligt. Tolv prinsar (furstar) ska han få och jag ska göra honom till ett stort folk. ");
INSERT INTO swe_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Men mitt förbund ska jag upprätta (etablera) med Isak, som Sarah ska föda åt dig vid denna bestämda (avtalade, överenskomna) tid nästa år.” ");
INSERT INTO swe_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Han slutade tala med honom och Gud (Elohim) steg upp från Abraham. ");
INSERT INTO swe_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham tog sin son Ismael och alla som var födda i hans hus och alla som var köpta med hans pengar, varje manlig person i Abrahams hus, och omskar dem på köttet, på deras förhud, denna samma dag, såsom Gud (Elohim) hade talat till honom. ");
INSERT INTO swe_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham var 99 år när han blev omskuren på köttet, på sin förhud. ");
INSERT INTO swe_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Hans son Ismael var 13 år gammal när han blev omskuren på köttet, på sin förhud. ");
INSERT INTO swe_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","På en och samma dag blev Abraham och hans son Ismael omskurna. ");
INSERT INTO swe_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Alla män i hans hus, de som var födda där och de som hade köpts av främlingar för pengar, blev omskurna med honom. ");
INSERT INTO swe_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Herren (Jahveh) uppenbarade sig igen för Abraham vid de stora träden (ekarna eller terebinterna) i Mamre strax utanför Hebron, tre mil söder om Jerusalem. Abraham satt vid tältets öppning (dörr) under den hetaste delen av dagen på eftermiddagen, mellan två och fem. ");
INSERT INTO swe_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Han lyfte sin blick och tittade, och se, där stod tre män framför på ett visst avstånd från honom. De verkar ha dykt upp från ingenstans, på en gång reser han sig upp. När han såg dem sprang han från tältets öppning emot dem och bugade sig mot marken för att hälsa dem välkomna och visa vördnad. ");
INSERT INTO swe_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Han Abraham sa: ”Min Herre (Adonai), om jag har funnit nåd för dina ögon så gå inte förbi din tjänare. ");
INSERT INTO swe_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Låt mig hämta lite vatten så att ni kan tvätta av era fötter och vila er under trädet här. ");
INSERT INTO swe_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Låt mig hämta en bit bröd så ni kan styrka er nu när ni ändå har kommit förbi er tjänares hem. Sedan kan ni fortsätta igen.” De svarade: ”Ja, gör som du talat!” ");
INSERT INTO swe_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham skyndade in i tältet till Sarah och sa: ”Skynda dig och ta tre sea-mått totalt 20-30 liter fint mjöl och baka runda bröd.” En oväntad stor volym! ");
INSERT INTO swe_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Sedan sprang Abraham bort till boskapen, tog en späd och fin speciellt utvald tjurkalv och gav den till en ung tjänare (yngling – hebr. naar), som skyndade sig att tillreda den. Bröd bakades dagligen för familjens behov. Det gick snabbt. Mjöl blandades med vatten och bakades på golvet över glödande kol. Dagsbehovet för en person, enligt 2 Mos 16:16, var en omer (som är 3/10 sea-mått), så tre sea-mått var långt mycket mer än vad som behövdes för tre gäster, Abraham och Sarah. Abrahams löfte i vers 5 nämner inget om något slaktat djur eller extravagant måltid. Ordagrant är hebreiskan: ”son av boskap, späd och god/vacker”. I Abrahams handlande finns en princip och lärdom: Lova inte för mycket för tidigt! Istället för att göra någon besviken, genom att inte uppfylla sitt löfte, är det mycket bättre att överraska med mer än vad man först har sagt. ");
INSERT INTO swe_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sedan när köttet var klart tog han smör (ost) och mjölk och kalven som han tillrett och satte fram åt dem. Själv stod han som en betjänt under trädet medan de åt. ");
INSERT INTO swe_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","De trion sa till honom: ”Var är din hustru Sarah?” Han svarade: ”Där (se – hebr. hinneh), i tältet.” Troligen gestikulerade Abraham och pekade inåt tältet. ");
INSERT INTO swe_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Och han Herren sa: ”Jag ska absolut komma tillbaka till dig när tiden har gått runt (om ett år) och se, då ska din hustru Sarah ha en son”. Sarah hörde detta där hon stod vid tältets öppning, som var bakom honom. ");
INSERT INTO swe_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nu var Abraham och Sarah gamla och hade nått hög ålder och Sarah hade slutat att ha det på kvinnors vis. ");
INSERT INTO swe_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah skrattade (hebr. tsachaq) inom sig (för sig själv) och sa: ”Skulle jag som blivit gammal ägna mig åt njutning? Min herre är också gammal.” ");
INSERT INTO swe_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Herren (Jahveh) sa till Abraham: ”Varför skrattar Sarah och säger: Ska jag som är gammal verkligen bära ett barn? ");
INSERT INTO swe_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Är någonting för svårt för Herren (Jahveh)? På den bestämda (avtalade) tiden ska jag komma tillbaka till dig, när tiden har gått runt (om ett år) och då ska Sarah ha en son”. ");
INSERT INTO swe_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah nekade och sa: ”Jag skrattade inte”, för hon var rädd. Han sa: ”Jo, du skrattade.” Följande stycke ramas in av att Abraham ”går med” besökarna, se vers 16, och sedan ”återvänder” till sitt tält i vers 33. Två olika perspektiv framträder, Gud som hör ropet från staden (vers 17-21) och hur Abraham ser staden (vers 22-32). ");
INSERT INTO swe_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Männen reste sig därifrån och såg ut mot Sodom och Abraham gick med dem för att se till så de kom lyckligt iväg. ");
INSERT INTO swe_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Herren (Jahveh) sa: ”Ska jag dölja för Abraham vad jag tänker göra? ");
INSERT INTO swe_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham ska verkligen bli ett stort och mäktigt folk och alla (andra) folk ska bli välsignade i honom. ");
INSERT INTO swe_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jag har låtit honom lära känna mig (på ett förtroligt och intimt sätt) så att han för alltid ska befalla sina söner och (hela) sitt hushåll efter honom (alla hans ättlingar, födda, köpta och adopterade) att de ska hålla sig till Herrens väg, för att göra det som är rätt och rättfärdigt genom alla tider. Så ska Herren ge till Abraham allt som han har talat om honom.” ");
INSERT INTO swe_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Herren (Jahveh) sa: ”Ropet från Sodom betyder: brinna och Gomorra betyder: dop; grundordet handel, tyranni är verkligen enormt och deras synd är överväldigande (mycket tung – hebr. kaved meód). ");
INSERT INTO swe_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nu vill jag gå ner och se huruvida de förtjänar förintelse så som ropet har kommit till mig. Om inte kommer jag att veta (få kunskap om) det.” ");
INSERT INTO swe_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Männen gick därifrån och gick till Sodom, men Abraham stod fortfarande inför (framför ansiktet på) Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham kom närmare och sa: ”Vill du verkligen svepa bort de rättfärdiga med de onda? ");
INSERT INTO swe_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tänk om det finns 50 rättfärdiga i staden, vill du verkligen svepa bort dem och inte ge förlåtelse till platsen för de 50 rättfärdigas skull som finns därinne? ");
INSERT INTO swe_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Må det vara fjärran ifrån dig att göra så och slå de rättfärdiga tillsammans med de onda, så att de rättfärdiga behandlas som de onda. Låt det vara fjärran från dig! Ska inte domaren över hela jorden vara rättvis?” Här tilltalar Abraham Gud som hela jordens domare. ");
INSERT INTO swe_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Herren (Jahveh) svarade: ”Om det finns 50 rättfärdiga i staden Sodom så ska jag rädda hela platsen för deras skull.” ");
INSERT INTO swe_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Sedan frågade Abraham: ”Eftersom jag har beslutat mig för att börja tala med Herren (Adonai) så fortsätter jag, trots att jag bara är stoft och aska. ");
INSERT INTO swe_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tänk om det fattas 5 för att det ska bli 50 rättfärdiga, kommer du att förgöra hela staden för dessa 5 människors skull?” Han Herren svarade: ”Jag ska inte förgöra den om det finns 45 rättfärdiga där.” ");
INSERT INTO swe_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham talade till honom igen: ”Vad händer om det bara är 40 där?” Han svarade: ”Jag ska inte göra det på grund av de 40.” ");
INSERT INTO swe_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Då sa Abraham: ”Herre (Adonai), bli inte upprörd över att jag fortsätter fråga! Vad händer om det bara är 30 där?” Han svarade: ”Jag ska inte göra det på grund av de 30.” ");
INSERT INTO swe_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham sa: ”Eftersom jag har beslutat mig för att börja tala med Herren så fortsätter jag. Vad händer om det bara är 20 där?” Han svarade: ”Jag ska inte göra det på grund av de 20.” ");
INSERT INTO swe_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Till sist sa Abraham: ”Herre (Adonai), bli inte upprörd över att jag frågar en gång till! Vad händer om det bara är 10 rättfärdiga, se vers 26 där?” Han svarade: ”Jag ska inte göra det på grund av de 10.” ");
INSERT INTO swe_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Och Herren (Jahveh) gick sin väg så fort han hade slutat samtala med Abraham, och Abraham återvände till sin plats tillbaka hem till Mamre utanför Hebron, se vers 1. Sedan Abrahams första vädjan (vers 23-25) har Herren svarat sex gånger (vers 26, 28b, 29b, 30b, 31b, 32b). Det fanns inte tio rättfärdiga i staden. I Jer 5:1 finns en liknande bön, men samma Jeremia skriver i Jer 31:29-30 att varje generation är själv ansvarig för konsekvenserna av sin skuld, se även Hes 14:12-23; 18:2-4. ");
INSERT INTO swe_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","De två änglarna kom till Sodom på kvällen och Lot satt i Sodoms port och Lot såg dem och reste sig upp och mötte dem och han föll ned med sitt ansikte mot marken. Att buga sig djupt var en dåtida vanlig hedersbevisning. ");
INSERT INTO swe_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Han Lot sa: ”Se vänligen, mina herrar budbärare, jag ber er, vänd om och gå in i er tjänares hus och stanna där hela natten och tvätta era fötter, så kan ni stiga upp tidigt och gå vidare.” De svarade: ”Nej, men vi ska stanna på torget (den öppna platsen) över natten.” Det var inte ovanligt att resenärer sov på gatan insvept i sin mantel. ");
INSERT INTO swe_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Han vädjade intensivt till dem och de vände om till honom och gick in i hans hus och han gjorde en festmåltid åt dem och bakade osyrat bröd och de åt. ");
INSERT INTO swe_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Men innan de lade sig omringade stadens män huset, Sodoms män, både ynglingar (tonåringar) och äldre, allt folk från varje kvarter. ");
INSERT INTO swe_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","De ropade på Lot och sa till honom: ”Var är männen som kom in till dig i natt? För ut dem till oss så att vi kan känna (ha en sexuell relation med) dem.” ");
INSERT INTO swe_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Och Lot gick ut till dem vid dörren och stängde dörren bakom sig. ");
INSERT INTO swe_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Och han sa: ”Jag ber er, mina bröder, gör inte denna ondska. ");
INSERT INTO swe_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Se, jag har två döttrar som inte har känt (haft en sexuell relation med) någon man, låt mig, jag ber er, föra ut dem till er och ni kan göra vad ni finner för gott i era ögon med dem, gör bara ingenting mot dessa män, så sant som de har kommit under skuggan av mitt tak (är under mitt beskydd).” ");
INSERT INTO swe_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Och de svarade: ”Flytta på dig” och de sa: ”Dessa kom hit på genomresa och han Lot vill vara domare! Nu ska vi behandla dig värre än dem.” Och de pressade sig hårt mot mannen, mot Lot, och kom nära för att bryta sönder dörren. ");
INSERT INTO swe_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Men männen änglarna stack ut sina händer och drog in Lot till sig i huset och dörren stängde de. Den mer ovanliga hebreiska meningsbyggnaden med verbet sist, indikerar att dörren inte förseglas på ett vanligt sätt utan övernaturligt. ");
INSERT INTO swe_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Och de slog männen utanför dörren med blindhet ordet används bara här och i 2 Kung 6:18, kan syfta på både fysisk och mental blindhet, både små och stora, så att de tröttade ut sig själva på att finna dörren. ");
INSERT INTO swe_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Och männen de himmelska besökarna sa till Lot: ”Har du några hos dig här, svärsöner, dina söner och dina döttrar och vem du än har i staden, för ut dem från denna plats, ");
INSERT INTO swe_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","för vi ska fördärva den här platsen, eftersom deras rop har vuxit sig stort inför Herrens (Jahvehs) ansikte och Herren (Jahveh) har sänt oss för att fördärva den.” ");
INSERT INTO swe_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Och Lot gick ut och talade till sina blivande svärsöner som skulle gifta sig hade gift sig med hans döttrar och sa: ”Upp, gå bort från den här platsen, för Herren (Jahveh) ska fördärva staden.” Men han var för sina svärsöner som en som skämtar (skojar, driver med). Hebreiska texten är utan tempus. Den grekiska översättningen Septuaginta översätter med ”redan gifta svärsöner” vilket skulle syfta på andra döttrar (än de två som nämns i vers 8) som redan var gifta, men eftersom döttrarna bor med honom är mer troligt att de är trolovade och texten syftar på blivande svärsöner (så översätter latinska översättningen Vulgata). Oavsett är huvudpoängen att de inte lyssnade och trodde inte att han menade allvar. Samma verb beskriver Saras svar, se 1 Mos 18:12, 13, 15. ");
INSERT INTO swe_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Och när morgonen grydde skyndade änglarna på Lot och sa: ”Stå upp, ta din hustru och dina två döttrar som är här, annars blir du bortsvept med stadens överträdelser.” ");
INSERT INTO swe_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Men han Lot dröjde sig kvar och männen tog tag i hans hand och i hans hustrus hand och i händerna på hans två döttrar, Herren (Jahveh) var barmhärtig mot honom. Och de förde ut honom och ställde honom utanför staden. ");
INSERT INTO swe_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Och när de hade fört ut dem utanför sa han: ”Fly för ert liv, se er inte tillbaka och stanna inte i slättlandet, fly till bergen, annars sveps ni bort.” Slättlandet var förmodligen det område som omstörtades och bildade Döda havet. ");
INSERT INTO swe_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot sa till dem: ”Inte så min herre, ");
INSERT INTO swe_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","se till att din tjänare har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon, och du har visat stor nåd (omsorgsfull kärlek – hebr. chesed) mot mig genom att du har räddat mitt liv. Jag kan inte hinner inte fly till bergen för att inte ondskan ska komma ikapp mig och jag dör. Lot förhandlar med huvudängeln på liknande sätt som Abraham med sina gäster, se 1 Mos 18:22-33. Han önskar fly till den lilla staden Tsoar. Här finns det hebreiska ordet chesed för första gången i GT. Det betyder nåd, omsorgsfull kärlek och trofasthet. Även ordet chen för nåd används här, men det beskrivs ingående i 1 Mos 6:8. Chesed är det vanligaste ordet för nåd i GT. Det förekommer 241 gånger. Totalt finns det fem olika rötter som betyder nåd fast på lite olika sätt i hebreiskan. Chesed är den typen av nåd som beskriver en omsorgsfull kärlek och även trofasthet. Det är nåden som bryr sig om på ett praktiskt sätt, driven av äkta kärlek som håller över tid. Chesed är en nåd som aldrig sviker. ");
INSERT INTO swe_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Se nu, denna stad är nära att fly till och den är liten (oansenlig) Tsoar var den minsta av de fem städerna i detta område, se 1 Mos 10:19, så skona den, låt mig fly till den – är den inte oansenlig? – och jag (min själ) ska leva.” ");
INSERT INTO swe_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Och han sa till honom: ”Se jag har gått med på din önskan också i denna sak, så jag ska inte omstörta staden som du talar om. ");
INSERT INTO swe_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Skynda dig, fly dit, för jag kan inte göra något förrän du kommit dit.” Därför kallas staden Tsoar. Tsoar betyder oansenlig, anspråkslös, ringa eller liten. ");
INSERT INTO swe_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Solen hade gått upp över jorden när Lot kom till Tsoar. ");
INSERT INTO swe_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Då lät Herren (Jahveh) eld och brinnande svavel regna över Sodom och Gomorra. Det sändes ner från himlarna av Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Han omstörtade dessa städer och hela slätten och städernas invånare och det som växte på marken. Förmodligen är denna omstörtning av hela slätten orsaken till att Salthavet (Döda havet) bildas, se 1 Mos 13:10; 14:3. ");
INSERT INTO swe_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Men hans hustru såg sig om bakom honom och hon blev en saltpelare. ");
INSERT INTO swe_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Och Abraham steg upp tidigt på morgonen på den plats där han hade stått inför Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Och han såg ut mot Sodom och Gomorra och mot slättlandet. Och se (hebr. vehinneh)! Perspektivbyte, vi får se med Abrahams ögon: Röken från landet steg upp som röken från en ugn. ");
INSERT INTO swe_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Och det hände när Gud (Elohim) fördärvade slättlandets städer att Gud (Elohim) kom ihåg Abraham och skickade ut Lot från mitten av omstörtningen, när han omstörtade städerna som Lot hade bott i. 5 Mos 29:23; Jes 1:9; 13:19; Jer 50:40; Amos 4:11; Matt 10:15; 11:23-24; Jud 1:7; Upp 11:8 ");
INSERT INTO swe_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Och Lot drog upp från Tsoar och bodde i bergen och hans två döttrar med honom, för han var rädd för att bo i Tsoar och han bodde i en grotta, han och hans två döttrar. ");
INSERT INTO swe_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Den förstfödde äldre sa till den yngre: ”Vår far är gammal och det finns inte en enda man på jorden som vill komma in till oss (ta oss till hustrur) på jordens vägar (kan betyda ”att ingen kommer gående på de vägar som gör det möjligt för dem att träffas” eller ”i enlighet med de världsliga traditionerna”). ");
INSERT INTO swe_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, låt oss ge vår far vin att dricka så han blir berusad och tappar omdömet, och sedan ligger vi med honom, så att vi kan bevara vår fars säd.” Tidigare var fadern villig att använda sina döttrar för sexuella ändamål utan deras samtycke. Nu använder de sin far för sexuella ändamål utan hans samtycke, se vers 8. Avsikten att bevara släktlinjen var ärbar, men sättet det gjordes på var avskyvärt. Att de var tvungna att berusa sin far visar att de visste att incest var fel, se 3 Mos 18:6-18; 1 Mos 38:13-26. ");
INSERT INTO swe_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Och de gav vin till sin far den natten och berusade honom. Och den förstfödda gick in och låg med sin far, och han visste inte när hon lade sig ner eller när hon steg upp. ");
INSERT INTO swe_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","På morgonen sa den förstfödda till den yngre: ”Se, jag låg i natt med min far. Låt oss ge honom vin att dricka i kväll också och gå du in och ligg med honom, så att vi kan bevara vår fars säd.” ");
INSERT INTO swe_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Och de gav sin far vin att dricka den natten också. Och den yngre steg upp och låg med honom, och han visste inte när hon lade sig ner eller när hon steg upp. ");
INSERT INTO swe_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Så blev båda Lots döttrar gravida med sin far. ");
INSERT INTO swe_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Och den förstfödda födde en son och gav honom namnet Moab, denne är moabiternas stamfar till denna dag. Moabiterna blev ett folk som bosatte sig öster om Döda havet i nuvarande Jordanien; namnet låter som ”från fadern” på hebreiska. ");
INSERT INTO swe_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Och den yngre födde också en son och gav honom namnet Ben-Ammi låter som ”min släktings son”, denne är stamfar till ammoniternas söner till denna dag. Ammoniterna bosatte sig norr om Moab; både Moab och Ammon var fiender till Israel. ");
INSERT INTO swe_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham vandrade därifrån Hebron, se 1 Mos 13:18 söderut i landet Negev, se 1 Mos 13:1 och bodde mellan Kadesh 1 Mos 16:14 och Shor 1 Mos 16:7 och han vandrade omkring i Gerar. ");
INSERT INTO swe_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham sa om sin hustru Sarah: ”Hon är min syster.” 1 Mos 12:13 Och Avimelech, Gerars kung, sände efter och tog Sarah. Abraham upprepar samma misstag som han gjort tidigare, se 1 Mos 12:10-20. Även hans son Isak gör på liknande sätt, se 1 Mos 26:1-11. ");
INSERT INTO swe_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Men Gud (Elohim) kom till Avimelech i en dröm på natten och sa till honom: ”Se, du ska dö på grund av kvinnan som du har tagit, för hon är en annan mans hustru.” ");
INSERT INTO swe_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Avimelech hade inte kommit nära (inte haft något intimt umgänge eller samlag med) henne och han sa: ”Herre (Adonai), vill du dräpa även ett rättfärdigt land? ");
INSERT INTO swe_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Sa han inte själv till mig: ’Hon är min syster’ och hon sa själv: ’Han är min bror’. I mitt hjärtas enfald och med mina händers oskyldighet har jag gjort detta.” ");
INSERT INTO swe_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Och Gud (Elohim) sa till honom i drömmen: ”Ja, jag vet att det är i ditt hjärtas enfald (okunnighet) som du har gjort detta och det är också därför som jag hindrar dig från att synda mot mig. Därför tillät jag inte att du rörde henne. ");
INSERT INTO swe_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Men ge nu mannen hans hustru tillbaka, för han är en profet och han ska be för dig så att du ska leva. Abraham den första personen i GT som kallas profet. Men om du inte ger tillbaka henne ska du veta att du med säkerhet ska dö, du och allt som hör till dig.” ");
INSERT INTO swe_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimelech steg upp tidigt på morgonen och kallade (ropade) på alla sina tjänare och talade alla dessa ord i deras öron redogjorde noggrant allt han drömt för dem och männen blev mycket rädda. ");
INSERT INTO swe_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Sedan kallade Avimelech på Abraham och sa till honom: ”Vad har du gjort mot oss? I vad har jag syndat mot dig eftersom du har fört denna stora synd över mig och mitt kungarike? Du har gjort sådant mot mig som inte ska göras!” ");
INSERT INTO swe_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Och Avimelech sa vidare till Abraham: ”Hur förklarar du att du har gjort detta?” ");
INSERT INTO swe_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Och Abraham sa: ”Eftersom jag tänkte att gudsfruktan finns säkert inte på denna plats och de kommer att döda mig för min hustrus skull. ");
INSERT INTO swe_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Dessutom är hon verkligen min syster, dotter till min far men inte dotter till min mor, och så blev hon min hustru. ");
INSERT INTO swe_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Och det hände när Gud (Elohim) fick mig att vandra bort från min fars hus (min släkt) 1 Mos 12:1 att jag sa till henne: ’Detta är den nåd (omsorgsfulla kärlek) som jag vill att du visar mig, att på varje plats som vi kommer till, ska du säga om mig att jag är din bror.’ ” Ordet ”vandra” (hebr. taah) betyder att vandra men även irra omkring både konkret och i sina tankar, vilket gör det möjligt att det var redan under den första tiden efter att Abraham lämnat Ur som han i sina funderingar kom fram till denna ståndpunkt. ");
INSERT INTO swe_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Och Avimelech tog får och oxar och tjänare och tjänarinnor och gav dem till Abraham och återlämnade hans hustru Sarah till honom. ");
INSERT INTO swe_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Och Avimelech sa: ”Se, mitt land ligger framför dig, bo där det behagar dig.” ");
INSERT INTO swe_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Och till Sarah sa han: ”Se, jag har gett din bror 1 000 shekel silver, det är ett skydd (täcke) för dina ögon, till alla som är med dig, och inför alla män så att de ska veta att du är försvarad.” ");
INSERT INTO swe_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Och Abraham bad till Guden (den ende Guden – hebr. ha-elohim), och Gud (Elohim) botade Avimelech och hans hustru och hans tjänstekvinnor slavinnor, bihustrur, så att de kunde få barn igen. ");
INSERT INTO swe_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","För Herren (Jahveh) hade stängt alla livmödrar i Avimelechs hus på grund av Abrahams hustru Sarah. Här beskrivs det första helandet i Bibeln. Här finns flera lärdomar:  • Abraham får be för någon annan som lider av samma problem som han själv har innan han själv blir helad. Det är först efter denna händelse, i nästa kapitel (1 Mos 21:2), som Sarah blir gravid!  • Abraham var inte syndfri när han bad, det var hans halvlögn (1 Mos 20:2) som orsakat situationen med Avimelech. Gud kan använda oss att be för andra trots våra egna brister.  • Resultatet av helandet syntes inte på en gång. Helandet skedde när Abraham bad, men det var först senare när kvinnorna började föda barn som man kunde se det synliga beviset på helandet!  Principen ”första förekomst”  Första gången någonting nämns i Bibeln presenteras ofta viktiga lärdomar och grundläggande sanningar på det ämnet. Inom bibeltolkningen kallas denna princip ”första förekomst”. Ett exempel är blod (hebr. damm), som när det nämns i 1 Mos 4:10 också likställs med mänskligt liv. Jesus använder principen om första förekomst när han undervisar om äktenskapet i Matt 19:4-5 och säger att ”från början” gjorde Skaparen människan till man och kvinna, se 1 Mos 1:27; 2:24. Rent generellt lägger också undervisningen i Moseböckerna en grund för resten av Bibeln, se Matt 5:17-48. Notera! Som med alla principer för bibeltolkning är det viktigt med balans och att alltid läsa texten i sitt sammanhang. Ett ord behöver inte betyda samma sak varje gång det nämns. Första gången ormen (hebr. nachash) nämns förknippas den med Satan, men kopparormen (4 Mos 21:9) är också en tydlig referens till Jesus (Joh 3:14). När Jesus uppmanar de troende att vara som ormar blir betydelsen, just från första förekomsten, att en troende ska ifrågasätta ideologier och tänkesätt som inte är från Gud och skapa tvivel kring falska föreställningar. Dock balanseras den negativa betydelsen, men det ska ske på ett oskyldigt och rent sätt (som en duva), se Matt 10:16. Ibland kan det också vara svårt att veta om något nämns först kronologiskt eller tematiskt. Ordningen på böckerna i GT är också annorlunda i den hebreiska Bibeln än i våra västerländska biblar. ");
INSERT INTO swe_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Och Herren (Jahveh) kom ihåg Sarah som han hade sagt och Herren (Jahveh) gjorde mot Sarah som han hade talat. ");
INSERT INTO swe_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Och Sarah blev havande och födde en son till Abraham vid hans höga ålder, vid den bestämda tiden som Gud (Elohim) hade talat till honom. ");
INSERT INTO swe_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Och Abraham gav sin son, som föddes åt honom, som Sarah födde till honom, namnet Isak. Isak (hebr. Jits-chak) betyder han skrattar. Då Isak är en viktig bild på Jesus är det värt att notera kopplingen till att han kommer med glädje. ");
INSERT INTO swe_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Och Abraham omskar sin son Isak när han var åtta dagar gammal som Gud (Elohim) hade befallt honom. ");
INSERT INTO swe_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Och Abraham var 100 år gammal när hans son Isak föddes åt honom. ");
INSERT INTO swe_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Och Sarah sa: ”Gud (Elohim) har gjort ett skratt (hebr. tsechoq) åt mig, alla som hör detta ska skratta med mig.” ");
INSERT INTO swe_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Och hon sa: ”Vem skulle ha sagt (flödat fram ord från hjärtat – hebr. malal) till Abraham att Sarah ska amma ett barn? För jag har fött honom en son vid hans höga ålder.” Dessa händelser 2000 f.Kr. är profetiska. Isaks liv är fyllt med skuggbilder för den kommande Messias:  Båda föds på ett mirakulöst sätt – Sarah hade för hög ålder, Jesus genom jungfrufödsel (Matt 1:18)  Båda mödrarna frågar hur det ska gå till (1 Mos 17:18; 18:12; Luk 1:34)  Namnges innan födseln (1 Mos 17:19; Matt 1:21)  Föds vid förutsagd tid (1 Mos 21:1; Gal 4:4)  Enfödd son (1 Mos 22:2; Joh 3:16)  Älskad av sin far (1 Mos 22:2; Joh 3:35)  Tas upp på Moria berg för att offras (1 Mos 22:2)  Tjänarna följer inte med upp (1 Mos 22:5; Joh 13:36)  Båda ska komma tillbaka (1 Mos 22:5; Matt 20:17-19)  Red på en åsna innan offret (1 Mos 22:5; Matt 21:1-11; Sak 9:9)  Bär på trä till offerplatsen (1 Mos 22:6; Joh 19:17)  Underordnade sig sin faders vilja (1 Mos 22:6, 9; Matt 26:42)  Båda var i trettioårsåldern (1 Mos 22:1-5; Luk 3:21)  Båda levde efter offret (Upp 1:18)  Efter sonens död och uppståndelse sänder hans far ut tjänare för att hitta en brud åt honom (1 Mos 24:14; Ef 5:23-32; Upp 19:6-7)  Båda ber för sin hustru och framtida barn (1 Mos 25:21; Joh 1:12; 17:20) ");
INSERT INTO swe_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Barnet växte och blev avvant. Och Abraham gjorde en stor fest på den dagen då Isak blev avvand. Förmodligen först vid 4-5 års ålder. ");
INSERT INTO swe_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Och Sarah såg egyptiskan Hagars son, som hon hade fött åt Abraham, skratta (roa sig, ”skojbråka” – hebr. tsachaqt). ");
INSERT INTO swe_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Därför sa hon till Abraham: ”Driv ut denna tjänstekvinna och hennes son, för tjänstekvinnans son ska inte vara arvtagare tillsammans med min son, min Isak.” ");
INSERT INTO swe_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Denna sak var mycket smärtsam (sorglig, bedrövande) i Abrahams ögon på grund av hans son. ");
INSERT INTO swe_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Och Gud (Elohim) sa till Abraham: ”Låt inte detta vara smärtsamt (sorgligt, bedrövligt) i dina ögon på grund av ynglingen och på grund av din tjänstekvinna. I allt som Sarah sagt till dig ska du lyssna på hennes röst (det hon sagt), för i (genom) Isak ska säd (avkomlingar, framtida generationer) uppkallas efter dig. ");
INSERT INTO swe_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Men också av tjänstekvinnans son ska jag göra ett folk, eftersom han är din säd.” ");
INSERT INTO swe_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Och Abraham steg upp tidigt på morgonen och tog bröd och ett skinn med vatten och gav det till Hagar, lade det på hennes skuldra och barnet, och sände iväg henne och hon gick iväg och irrade omkring i Beer-Shevas öken. ");
INSERT INTO swe_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Och vattnet i skinnet tog slut och hon övergav barnet under en buske (träd – hebr. siach). Ovanligt ord för buske eller träd, kan vara en tamariskbuske, se även 1 Mos 2:5. ");
INSERT INTO swe_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Hon gick och satte sig ner mitt emot, ett gott stycke bort, så det var ett bågskott emellan, för hon sa: ”Låt mig inte se när barnet dör.” Och hon satt mitt emot honom och lyfte upp sin röst och grät. ");
INSERT INTO swe_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Och Gud (Elohim) hörde ynglingens röst och Guds (Elohims) ängel (budbärare) ropade på Hagar från himlarna och sa till henne: ”Vad plågar dig Hagar? Frukta inte, för Gud (Elohim) har hört ynglingens röst där han är. ");
INSERT INTO swe_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Res på dig, lyft upp ynglingen och håll fast honom i din hand, för jag ska göra honom till ett stort folkslag (nation).” ");
INSERT INTO swe_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Och Gud (Elohim) öppnade hennes ögon och hon såg en vattenkälla. Och hon gick och fyllde skinnet med vatten och gav ynglingen att dricka. ");
INSERT INTO swe_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Och Gud (Elohim) var med ynglingen och han växte och han bodde i öknen och blev en bågskytt. ");
INSERT INTO swe_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Och han bodde i Parans öken och hans mor tog (hämtade ut) en hustru åt honom från Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Och det hände vid den tiden att Avimelech och Pichol, ledaren för hans här, talade med Abraham och sa: ”Gud (Elohim) är med dig i allt som du gör. ");
INSERT INTO swe_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ge mig därför din ed (löfte) vid Gud (Elohim) att du inte agerar falskt (gör fel) mot mig, inte mot mina söner, inte mot mina sonsöner (barnbarn), utan i enlighet med den nåd (omsorgsfulla kärlek – hebr. chesed) som jag har visat (gjort mot) dig, så ska du göra mot mig och mot landet som du har vandrat omkring i.” ");
INSERT INTO swe_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Och Abraham sa: ”Jag lovar (svär, avlägger en ed)” ");
INSERT INTO swe_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Och Abraham tillrättavisade Avimelech på grund av vattenkällorna (brunnarna – hebr. beer) som Avimelechs tjänare med våld tagit bort (fördärvat) förmodligen fyllt med jord och sten. ");
INSERT INTO swe_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Och Avimelech sa: ”Jag vet inte vem som har gjort detta, inte heller har du berättat för mig, jag har inte hört något om detta förrän idag.” ");
INSERT INTO swe_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Och Abraham tog får och oxar och gav dem till Avimelech och de två skar ett förbund. De ingick blodsförbund med varandra, vilket var relativt vanligt vid denna tid. ");
INSERT INTO swe_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Och Abraham tog sju lamm av honkön från flocken och placerade avsides. ");
INSERT INTO swe_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Och Avimelech sa till Abraham: ”Vad betyder dessa sju lamm av honkön som du placerat för sig själva?” ");
INSERT INTO swe_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Och han svarade: ”Dessa sju lamm av honkön ska du ta ur min hand, så att det blir ett vittnesbörd för mig att jag har grävt dessa sju brunnar (sju vattenkällor – hebr. beer sheva).” ");
INSERT INTO swe_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Därför kallas platsen Beer-Sheva eftersom de båda avlade en ed (gav varandra löften). Hebr. beer betyder källa och sheva har betydelsen sju och ed eller löfte. Att svära en ed kan också bokstavligt uttryckas som ”att sjua sig själv”. Talet sju hör ihop med fullbordan, fullkomlighet och tillfredsställelse. Det handlar också om perfektion, myckenhet och överflöd. Ordet inkluderar även att allt detta är med glädje, alltså något positivt. ");
INSERT INTO swe_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Så skar de ett förbund i Beer-Sheva och Avimelech och Pichol, ledaren för hans här, reste sig och de återvände till filistéernas land. ");
INSERT INTO swe_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Och Abraham planterade en tamarisk i Beer-Sheva och åkallade Herrens (Jahvehs) namn på platsen, den Evige Guden (El Olam). Tamarisken växer långsamt, det tar 400 år innan den når full höjd. Ett träd planteras inte för sin egen skull, utan för kommande generationer. Detta är en profetisk handling av Abraham som säger att här ska kommande generationer bo och de ska få svalka sig i skuggan av detta träd! Tamarisken växer i jord med hög salthalt och är därför det enda träd som kan växa kring Döda havet. Under dagen utsöndrar trädet salt på sina löv, en process som kräver mycket vatten. Under natten absorberar saltet vatten, som sedan på morgonen avdunstar och ger en naturlig kylande effekt. Detta är en anledning till varför detta träd är populärt att plantera i trädgårdar. Se även 1 Sam 22:6; 31:13. ");
INSERT INTO swe_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Och Abraham vandrade omkring i filistéernas land under många dagar. ");
INSERT INTO swe_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Och det hände sig därefter att Gud prövade Abraham och sa till honom: ”Abraham” och han svarade: ”Här är jag.” Här är jag (hebr. hineni) är ett uttryck som inte i första hand handlar om att tala om var man befinner sig rent fysiskt eller geografiskt. Det är ett ord som istället innebär att ”jag står till förfogande” eller ”jag är beredd att ta ansvar”. Här i 1 Mos 22:1 förekommer ordet för första gången i Bibeln. Ordet förekommer tre gånger i detta kapitel, se vers 7 och 11. Både Abraham och alla andra som ger detta svar är exempel på personer som går in i någon form av ledarroll när de säger hineni – här är jag. Isak säger det i 1 Mos 22:7, Jakob i 1 Mos 31:11, Mose i 2 Mos 3:4, profeten Samuel säger det i 1 Sam 3:4, profeten Jesaja i Jes 6:8, m.fl. ");
INSERT INTO swe_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Han (Gud) sa: ”Ta nu (jag ber dig) din son, din ende (dyrbare – hebr. jachid) son som du älskar (hebr. ahava) – Isak, och gå till Morias land och offra honom där som brännoffer (hebr. olah) till mig, på ett berg som jag ska berätta för dig om.” I den här versen används ordet jachid för första gången. Ordet beskriver något som är dyrbart. Abraham hade ju även Ismael, men Isak är den ende, enfödde sonen till Sarah. Även ordet för älska ahava används första gången i GT här. Ahava betyder att älska eller kärlek. Det är signifikativt att på samma sätt som Abraham älskar Isak, är Jesus Guds älskade Son. Hela detta kapitel är en bild på hur Gud kommer att offra Jesus för hela mänskligheten. In i minsta detalj ser vi här många förebilder till det som kommer ske längre fram. Gud bevisade sin kärlek till oss genom att han utgav sin ende Son. Faktum är att här finns en viktig förutsättning för fortsättningen på det förbund som Gud ingick med Abraham i 1 Mos 15. Om Abraham är villig att offra sin son är Gud beredd att göra samma sak, vilket också sker 2000 år senare. I ett blodsförbund måste båda parter vara villiga till samma uppoffringar för varandra. ");
INSERT INTO swe_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham steg upp tidigt nästa morgon och sadlade sin åsna. Han tog med sig två av sina unga män (hebr. naar) tjänstefolk och Isak, hans son. Han klöv ved till brännoffret, steg upp och gick till den plats som Gud hade talat om för honom. ");
INSERT INTO swe_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","På tredje dagen, lyfte Abraham sin blick och såg platsen långt borta. ");
INSERT INTO swe_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham sa till sina unga män (tjänstefolk): ”Vänta här med åsnan, jag och ynglingen (hebr. naar) går vidare, vi ska tillbe (ordagrant: ”buga, böja oss i vördnad” – hebr. shachah) och kommer tillbaka till er.” Isak är inte en ung pojke utan en vuxen man. Det hebreiska ordet naar används om tonåringar och yngre män. Samma ord används både om Abrahams tjänare som var unga män och hans son Isak, se vers 3, 5, 12, 19. Han hade lätt kunnat göra motstånd och övermannat sin gamle far, men går villigt med på att låta sig bindas. Isaks agerande utgör en förebild till Jesu offer på Golgata. Isak bär själv upp veden till offret, på samma sätt som Jesus själv bär tvärslån. Platsen är också den samma, Moria berg är höjden i Jerusalem där templet stod i den södra ändan av åsen som sträcker sig norrut, vilket möjliggör att Jesus faktiskt korsfästes på precis samma plats som Abraham byggde altaret. Utifrån Sarahs ålder kan vi se att Isak inte var äldre än 37 år. Hon dog 127 år gammal, se 1 Mos 23:1, och födde Isak då hon var 90 år, se 1 Mos 17:17; 21:1-5. Även orden ”många dagar” i 1 Mos 21:34 och ”efter detta” i 1 Mos 22:1 antyder att händelsen inte sker när han är ett barn, utan när han är vuxen. Det skulle inte vara otroligt om Isak var 33 år, vilket i så fall exakt sammanfaller med Jesu ålder. ");
INSERT INTO swe_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham tog veden till brännoffret och lade den på sin son Isak. Han tog elden i sin hand och kniven och de gick båda tillsammans. ");
INSERT INTO swe_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak pratade med sin far Abraham och sa: ”Min far” och han svarade: ”Här är jag, min son.” Han sa: ”Vi har eld och ved men var är lammet till brännoffret?” Detta är andra gången som Abraham säger ”här är jag” i detta kapitel, se även vers 1 och 11. ");
INSERT INTO swe_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham svarade: ”Gud (Elohim) ska själv förse sig med lammet till brännoffret, min son.” De gick båda vidare tillsammans. Att hebreiskan här uttrycker att Gud ska förse sig själv, talar profetiskt även om att Gud förser sig själv med det perfekta offret när han senare ger sin son Jesus som det fullkomliga offret för världens och alla människors synder. ");
INSERT INTO swe_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Och de kom till platsen som Gud (Elohim) hade berättat för honom om och Abraham byggde ett altare där och lade i ordning veden. Sedan band (hebr. aqed) han Isak, sin son, och lade honom på altaret ovanpå veden. Inom judendomen har denna berättelse fått namnet Akedah – ”bindandet” av Isak. ");
INSERT INTO swe_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Och Abraham sträckte ut sin hand och tog kniven för att slakta sin son. ");
INSERT INTO swe_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Då ropade en Herrens (Jahvehs) ängel till honom från himlen och sa: ”Abraham, Abraham” och han svarade: ”Här är jag.” Det är nu tredje gången som Abraham säger ”här är jag” i detta kapitel, se även vers 1 och 7. ");
INSERT INTO swe_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Då sa han Herrens ängel: ”Lägg inte din hand på ynglingen (hebr. naar), gör ingenting mot honom, för nu vet har jag personligen fått erfara att du är en gudfruktig man (att du fruktar Elohim). Du har ju inte ens undanhållit din son, din ende son, från mig.” Heb 11:17-19; Jak 2:21-23 ");
INSERT INTO swe_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham såg sig omkring (lyfte upp sina ögon och tittade) och se, bakom honom var en bagge som hade fastnat med sina horn i snåret. Då gick Abraham och tog baggen och offrade den som brännoffer istället för sin son. ");
INSERT INTO swe_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Och Abraham kallade den platsen (gav den platsen namnet) Herren (Jahveh) ser (förser, utser – hebr. raah), eller som man säger än i denna dag om berget: ”Herren kommer att uppenbara sig (Jahveh jeraeh).” Sista frasen kan också översättas: ”på Herrens (Jahvehs) berg ska det förses.” Det finns ett flertal beskrivande namn på Gud i GT. Jahveh-Jireh – ”Herren vår försörjare” är ett av dem, se även 1 Mos 16:13; 17:1; 2 Mos 17:15; Ps 23:1; Dom 6:24; Jer 23:6. ");
INSERT INTO swe_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Herrens (Jahvehs) ängel (budbärare) 1 Mos 16:7 ropade till Abraham från himlen en andra gång ");
INSERT INTO swe_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","och sa: ”Vid mig själv har jag svurit (gett min ed) förkunnar (säger, proklamerar) Herren (Jahveh), eftersom du har gjort denna sak och inte har undanhållit din son, din ende son, ");
INSERT INTO swe_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","som en välsignelse ska jag välsigna dig och föröka, jag ska föröka din säd som stjärnorna på himlen och som sanden som finns på havets strand, och din säd ska besitta sin fiendes port. ");
INSERT INTO swe_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I din säd ska alla jordens folkslag vara välsignade, eftersom du har lyssnat till min röst.” ");
INSERT INTO swe_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham återvände till sina unga män (tjänstefolk) och de steg upp och gick tillsammans till Beer-Sheva och Abraham bodde i Beer-Sheva. 1 Mos 21:14 ");
INSERT INTO swe_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Och det hände sig efter dessa händelser att man berättade för Abraham och sa: ”Se, Milkah har fött åtta barn till din bror Nachor.” 1 Mos 11:29 ");
INSERT INTO swe_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us (hebr. Ots), hans förstfödde och Boz hans bror och Kemoel, Arams far, ");
INSERT INTO swe_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","och Kesed och Chazo och Pileddash och Jidlaf och Betoel. ");
INSERT INTO swe_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Och Betoel födde Rebecka, dessa åtta födde Milkah åt Nachor, Abrahams bror. ");
INSERT INTO swe_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hans konkubin som hette Reoma födde Tevach och Gacham och Tachash och Maacha. ");
INSERT INTO swe_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah blev 127 år 100 år och 20 år och 7 år gammal, detta var åren som Sarah levde. Sarahs ålder skrivs här på ett ovanligt sätt med ordet år (hebr. shanah) mellan varje del av sifforna. Ordagrant står det i hebreiskan: ”hundra år och tjugo år och sju år”, det mer vanliga hebreiska sättet skulle ha varit att skriva ”hundra och tjugo och sju år”. En tolkning är att det indikerar olika perioder i hennes liv. ");
INSERT INTO swe_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah dog i Kirjat Arba, det är Hebron i Kanaans land, och Abraham kom för att sörja Sarah och gråta över henne. ");
INSERT INTO swe_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham reste sig upp från sin döda frus kropp och talade till Chets söner folkslaget hettiterna; ättlingar till Chet som var Kaanans son, se 1 Mos 10:15; 15:20; Jos 1:4 och sa: ");
INSERT INTO swe_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","”Jag är en främling och en besökare bland er, ge mig en bit mark som begravningsplats hos er, så att jag kan begrava min döda i min närhet.” ");
INSERT INTO swe_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Chets söner svarade Abraham och sa till honom: ");
INSERT INTO swe_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","”Lyssna min herre, du är en mäktig furste ibland oss, välj bland våra gravar och begrav din döda, ingen av oss ska vägra att ge dig sin grav, utan du ska kunna begrava din döda hustru Sarah.” ");
INSERT INTO swe_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham reste sig och böjde sig ner i respekt och vördnad inför landets folk, Chets söner. ");
INSERT INTO swe_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Han talade med dem och sa: ”Om det är er önskan att jag ska få begrava min döda i min närhet, så lyssna på mig och bönfall för min räkning inför Efron, Tsoars son, ");
INSERT INTO swe_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","att han ska ge mig Machpelas grotta som han äger och som ligger vid ändan av hans fält. Låt honom ge mig den till fullt pris, i er mitt (med er som vittnen), till en egendom som begravningsplats.” ");
INSERT INTO swe_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nu satt Efron mitt bland Chets söner, och hettiten Efron svarade Abraham så att alla Chets söner hörde vad han sa, alla som gått in i stadens port. Den plats där alla viktiga affärsuppgörelser gjordes på denna tid. Han sa: ");
INSERT INTO swe_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","”Nej, min herre, lyssna på mig, fältet ger jag dig och grottan som finns där. Jag ger det till dig inför sönerna av mitt folk (som vittnen) ger jag det till dig. Begrav din döda.” ");
INSERT INTO swe_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham böjde sig bugade för att visa respekt och vördnad inför folket i landet. ");
INSERT INTO swe_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Han talade till Efron så att folket i landet hörde det och sa: ”Om du önskar, ber jag dig (vädjar) lyssna på mig, jag ska ge dig full betalning för fältet, ta emot det av mig och jag ska sedan begrava min döda där.” ");
INSERT INTO swe_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron svarade Abraham och sa: ");
INSERT INTO swe_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","”Min herre, lyssna på mig, en bit land värt 400 shekel totalt 4,6 kg silver, vad är det mellan oss? Begrav därför din döda.” ");
INSERT INTO swe_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham hörsammade Efron och Abraham vägde upp silvret till Efron, som han hade talat så att Chets söner hade hört det. 400 shekel totalt 4,6 kg silver i aktuell valuta som köpmännen använder. ");
INSERT INTO swe_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Efrons fält, som finns i Machpela, som ligger framför Mamre, fältet och grottan som är där och alla träd som är på fältet, det som fanns inom dess gränser runtom fastställdes ");
INSERT INTO swe_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","som Abrahams egendom inför Chets söner, inför alla (vittnen) som hade gått in i stadens port. ");
INSERT INTO swe_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Därefter begravde Abraham sin hustru Sarah i grottan på Machpelas fält framför Mamre, det är Hebron i Kanaans land. ");
INSERT INTO swe_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Fältet och grottan fastställdes som Abrahams egendom, till en begravningsplats, av Chets söner. Detta är det första, och enda, markområdet i Israel som juridiskt blir judarnas egendom genom Abraham. Det kan betraktas som en förstlingsfrukt och försäkran om att resten av Guds löfte om landet också kommer att uppfyllas. Så sker när folket intar landet under Josuas ledning 300 år senare. De fulla gränser som Bibeln nämner har dock aldrig varit i judarnas ägo, det är förmodligen de gränser Israel kommer att ha under tusenårsriket. ");
INSERT INTO swe_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham var gammal, han hade kommit till många dagar (levt länge) och Herren (Jahveh) hade välsignat Abraham i allt (på alla områden, på allt sätt, i allt han gjort). ");
INSERT INTO swe_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham sa till sin tjänare, den äldste i hans hus, som han hade satt att förvalta allt han hade: ”Jag ber dig, lägg din hand under min höft. ");
INSERT INTO swe_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Jag vill att du ska avlägga en ed inför Herren (Jahveh), himmelens Gud (Elohim) och jordens Gud (Elohim), att du inte ska ta en hustru åt min son från kanaanéernas döttrar, bland dem som bor här. ");
INSERT INTO swe_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Istället ska det vara någon från mitt land och från mina släktingar och du ska ta (söka upp, leta reda på) en hustru åt min son Isak.” ");
INSERT INTO swe_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tjänaren sa till honom: ”Om kvinnan inte är villig att följa med mig till det här landet, blir jag då tvungen att föra din son tillbaka till det land som du har kommit ifrån?” ");
INSERT INTO swe_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham svarade honom: ”Passa dig noga så att du inte för tillbaka min son dit. ");
INSERT INTO swe_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Herren (Jahveh), himmelens Gud (Elohim) som har tagit mig ut från min fars hus och från det land där jag föddes och som har talat till mig och gett sin ed och sagt: ’Till din säd alla dina efterkommande barn ska jag ge detta land’, han ska sända sin ängel framför dig och du ska ta en hustru åt min son därifrån. ");
INSERT INTO swe_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Om kvinnan inte är villig att följa med dig ska du vara fri från min ed. Det enda du (för alltid) ska lova är att inte föra tillbaka min son dit.” ");
INSERT INTO swe_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tjänaren lade sin hand under Abrahams, hans herres, höft och svor eden till honom i enlighet med dessa ord. ");
INSERT INTO swe_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tjänaren tog 10 kameler av sin herres kameler och reste iväg. Han hade allt gott (många dyrbara gåvor) från sin herres hand. Han stod upp och vandrade till Aram-Naharim (betyder: de två flodernas Aram) norra Mesopotamien, till staden Nachor. ");
INSERT INTO swe_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","På kvällen lät han kamelerna lägga sig (bokstavligt gå ner på knä) vid vattenkällan utanför staden, vid den tiden då kvinnorna går ut för att hämta vatten. Måste vara ungefär sista timmen före solnedgången eftersom det inte går att hämta vatten när det blivit mörkt. Man vill heller inte utföra denna tunga syssla när dagen är som varmast. ");
INSERT INTO swe_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Han sa: ”Herre (Jahveh), min herre Abrahams Gud (Elohim) jag ber dig (vädjar till dig) låt idag något gott komma framför mitt ansikte och visa nåd (omsorgsfull kärlek) mot min herre Abraham. ");
INSERT INTO swe_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Se, jag står vid vattenkällan och stadens döttrar ska komma ut och dra upp vatten. ");
INSERT INTO swe_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Låt det ske att den unga kvinna till vilken jag ska säga: Ställ ner din kruka så att jag får dricka, hon ska då svara: Drick och jag ska även ge dina kameler att dricka, låt det vara den som är utvald för din tjänare, för Isak, så att jag kan veta att du har visat nåd (omsorgsfull kärlek) mot min herre.” ");
INSERT INTO swe_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Och det hände att medan han fortfarande talade kom Rebecka ut redan innan han avslutat sin bön, hon var född till Betoel, Milkahs son, hustru till Nachor, och hon hade sin kruka på axeln. ");
INSERT INTO swe_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Den unga kvinnan (tonårstjejen 14-17 år – hebr. naarah) var vacker att se på, en jungfru (avskild – hebr. betolah), ingen man hade känt henne, och hon gick ner till källan och fyllde sin kruka och kom upp. ");
INSERT INTO swe_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tjänaren sprang mot henne och sa: ”Jag ber dig, ge mig lite vatten att dricka ur din kruka.” ");
INSERT INTO swe_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Hon svarade: ”Drick, min herre” och hon skyndade sig att ta ner krukan från axeln och gav honom att dricka. ");
INSERT INTO swe_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","När hon hade gett honom att dricka sa hon: ”Jag ska dra upp vatten till kamelerna också till dess att de har druckit” En kamel kan dricka upp till 40 liter vatten vid ett och samma tillfälle, om 10 kameler ska dricka sig otörstiga betyder det att Rebecka kan ha dragit upp så mycket som 400 liter vatten. Det är alltså ingen självklarhet att hon skulle erbjuda sig detta. ");
INSERT INTO swe_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hon skyndade sig att hälla krukan i tråget och sprang tillbaka till källan och drog upp vatten till alla hans kameler. ");
INSERT INTO swe_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mannen iakttog henne hela tiden och var tyst (förblev stilla) för att få veta om Herren (Jahveh) hade gjort hans resa framgångsrik eller inte. ");
INSERT INTO swe_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","När kamelerna hade druckit klart tog mannen fram en guldring som vägde en beka 5,8 gram – motsvarar en halv shekel, se 2 Mos 38:26 och två armband till hennes händer som vägde 10 shekel 115 gram i guld. ");
INSERT INTO swe_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Han sa: ”Vems dotter är du? Berätta, jag ber dig. Finns det plats i din fars hus för oss att övernatta?” ");
INSERT INTO swe_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hon svarade honom: ”Jag är dotter till Betoel, son till Milkah som hon födde till Nachor.” ");
INSERT INTO swe_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Vidare sa hon: ”Vi har både hö och tillräckligt med foder och rum att övernatta i.” ");
INSERT INTO swe_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mannen böjde sitt huvud och tillbad (kastade sig till marken inför) Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Han sa: ”Välsignad är Herren (Jahveh), min herre Abrahams Gud (Elohim), som inte har försummat sin nåd (omsorgsfulla kärlek) och sin sanning mot min herre. Herren (Jahveh) har lett mig på vägen (har varit min vägvisare så att jag kom rätt) till min herres brors hus.” Nåd och sanning (hebr. chesed ve emet) hör oskiljaktigt ihop. De presenteras alltid i samma inbördes ordning och återfinns i Guds eget vittnesbörd, se 2 Mos 34:6. Nåd utan sanning blir uddlös, medan sanning utan nåd blir obarmhärtig. ");
INSERT INTO swe_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Den unga kvinnan sprang iväg och berättade alla dessa ord i sin mors hus. ");
INSERT INTO swe_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebecka hade en bror som hette Laban, och Laban sprang ut till mannen vid källan. ");
INSERT INTO swe_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Det hände sig att när han såg ringen och armbanden på sin systers händer och när han hörde orden som Rebecka, hans syster, talade då hon sa: ”Så talade mannen med mig”, så han kom ut till mannen och se, han stod med kamelerna vid källan. ");
INSERT INTO swe_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Han sa: ”Kom in, du välsignade av Herren (Jahveh), varför står du här ute? Jag har gjort i ordning huset och gjort plats för dina kameler.” ");
INSERT INTO swe_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mannen kom in i huset och sadlade av sina kameler och han gav kamelerna hö och foder. Han fick vatten till att tvätta sina fötter och fötterna på de män som var med honom. ");
INSERT INTO swe_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Man satte fram mat för att han skulle äta men han sa: ”Jag vill inte äta förrän jag har framfört mitt ärende.” Han (Laban) sa: ”Tala” ");
INSERT INTO swe_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Då sa han: ”Jag är Abrahams tjänare. ");
INSERT INTO swe_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Herren (Jahveh) har välsignat min herre rikligt och han har blivit stor. Han har gett honom småboskap och boskapshjordar (av nötkreatur), silver och guld och tjänare och tjänarinnor och kameler och åsnor. ");
INSERT INTO swe_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Och Sarah, min herres hustru, födde en son till min herre på sin ålderdom, och till honom har han givit allt han har. ");
INSERT INTO swe_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Min herre har tagit en ed av mig och sagt: ’Du ska inte ta en hustru till min son från kanaanéernas döttrar i vars land jag bor. ");
INSERT INTO swe_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Istället ska du gå till min fars hus och till mina släktingar och ta en hustru till min son.’ ");
INSERT INTO swe_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Jag sa till min herre: ’Men om kvinnan inte vill följa med mig?’ ");
INSERT INTO swe_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Då sa han till mig: ’Herren (Jahveh) som jag vandrar inför, ska sända sin ängel med dig och göra din väg lyckosam, och du ska ta en hustru till min son bland mina släktingar och från min fars hus. ");
INSERT INTO swe_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Sedan ska du vara fri från din ed när du kommer till mina släktingar. Om de inte ger henne till dig ska du vara fri från min ed.’ ");
INSERT INTO swe_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Så idag kom jag till källan och sa: Herre (Jahveh), min herre Abrahams Gud (Elohim), låt nu den väg jag har gått vara lyckosam, ");
INSERT INTO swe_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","se, jag står vid vattenkällan, låt det ske att den unga kvinna till vilken jag ska säga: ’Jag ber dig, ge mig lite vatten att dricka ur din kruka’, ");
INSERT INTO swe_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","hon ska då svara: ’Drick och jag ska även ge dina kameler att dricka’, låt det vara den kvinna som Herren (Jahveh) har utvalt till min herres son. ");
INSERT INTO swe_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Och innan jag slutat tala till mitt hjärta, se, då kom Rebecka med sin kruka på axeln och hon gick ner till källan och drog. Och jag sa till henne: ’Låt mig dricka, jag ber dig’. ");
INSERT INTO swe_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hon skyndade sig att ta ner krukan från axeln och sa: ’Drick, jag ska ge dina kameler att dricka också.’ Då drack jag, och hon gav kamelerna vatten också. ");
INSERT INTO swe_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Jag frågade henne och sa: ’Vems dotter är du?’ och hon svarade: ’Jag är dotter till Betoel, Nachors son, som Milkah födde till honom.’ Då satte jag ringen i hennes näsa och armbanden på hennes handleder. ");
INSERT INTO swe_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Så böjde jag mitt huvud och kastade mig till marken inför Herren (Jahveh) och välsignade Herren (Jahveh), min herre Abrahams Gud (Elohim), som har lett mig på den rätta vägen (har varit min vägvisare så att jag kom rätt) till min herres brorsdotters hus för hans son. ");
INSERT INTO swe_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Om ni vill vara nådiga (visa omsorgsfull kärlek) och sanna (trofasta) se vers 27 mot min herre så berätta det, och om inte så berätta det för mig, så att jag kan gå till höger eller till vänster.” Nåd och sanning (hebr. chesed ve emet) hör oskiljaktigt ihop. De presenteras alltid i samma inbördes ordning och återfinns i Guds eget vittnesbörd, se 2 Mos 34:6. Här används uttrycket mellan människor. Nåd utan sanning blir uddlös, medan sanning utan nåd blir obarmhärtig. ");
INSERT INTO swe_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Då svarade Laban och Betoel och sa: ”Det som kommer från Herren (Jahveh) kan vi inte tala ont eller gott om. ");
INSERT INTO swe_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Se, Rebecka är framför dig, ta henne och gå, och låt henne bli din herres sons hustru, så som Herren (Jahveh) har talat.” ");
INSERT INTO swe_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","När Abrahams tjänare hörde dessa ord böjde han sig ner till marken, till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tjänaren tog fram juveler av silver och juveler av guld och vackra kläder och gav till Rebecka, han gav också dyrbara ting till hennes bror och hennes mor. ");
INSERT INTO swe_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","De åt och drack, männen som var med honom och dröjde kvar hela natten. När de steg upp på morgonen sa han: ”Skicka iväg mig till min herre.” ");
INSERT INTO swe_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hennes bror och hennes mor sa: ”Låt den unga kvinnan vara hos oss några få dagar, åtminstone 10. Sedan ska hon gå.” ");
INSERT INTO swe_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Han sa till dem: ”Försena mig inte, se Herren (Jahveh) har gjort min resa lyckosam, sänd iväg mig så att jag kan gå till min herre.” ");
INSERT INTO swe_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","De sa: ”Vi ska kalla på den unga kvinnan och fråga hennes egen mun.” ");
INSERT INTO swe_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","De kallade på Rebecka och sa till henne: ”Vill du följa med denne man?” Hon svarade: ”Jag vill gå.” ");
INSERT INTO swe_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","De sände iväg Rebecka, sin syster, och hennes barnskötare Deborah, se 1 Mos 35:8 och Abrahams tjänare och hans män. ");
INSERT INTO swe_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","De välsignade Rebecka och sa till henne: ”Vår syster, må du bli mor till tusen och tiotusen och låt din säd (dina barn) inta portarna hos dessa som hatar dem.” ");
INSERT INTO swe_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebecka reste sig med sina tjänarinnor och de red på kamelerna och följde mannen. Tjänaren tog Rebecka och gick sin väg. ");
INSERT INTO swe_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak kom på vägen från Beer Lachaj Roi, för han bodde i landet i söder (Negev). ");
INSERT INTO swe_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Vid aftontiden gick Isak ut på fältet och funderade (var försjunken i tankar) och han lyfte upp sin blick och såg, och se där kom kameler (gående). ");
INSERT INTO swe_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecka lyfte upp sin blick och när hon såg Isak steg hon av sin kamel. ");
INSERT INTO swe_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Hon sa till tjänaren: ”Vilken man är det som går på fältet för att möta oss?” Tjänaren svarade: ”Det är min herre.” Hon tog sin slöja och dolde sig själv. ");
INSERT INTO swe_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tjänaren återgav (räknade upp – hebr. safar) för Isak allt vad han hade gjort. ");
INSERT INTO swe_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak tog in henne i sin mor Sarahs tält och äktade Rebecka och hon blev hans hustru och han älskade henne. Isak blev tröstad efter sin mor. ");
INSERT INTO swe_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham tog en annan hustru. Hennes namn var Keturah (hebr. Qetorah; betyder: rökelse/offer). I 1 Krön 1:32 kallas hon bihustru och antyder att detta skedde tidigare. ");
INSERT INTO swe_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hon födde sex barn åt honom: Zimran och Jokshan och Medan och Midjan förfäder till midjaniterna; Sippora var från den stammen, se 2 Mos 2:21; 3:1 och Jishbak och Shoach. ");
INSERT INTO swe_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan Abrahams andra son med Keturah fick Sheva och Dedan Jes 21:13; Jer 49:8; Hes 27:20. Dedans söner var Ashorim och Letoshim och Leummim. ");
INSERT INTO swe_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Abrahams fjärde son med Keturah Midjans söner var Ejfa och Efer och Henok (hebr. Chanoch) och Avida och Eldaa. Alla dessa var Keturahs söner. ");
INSERT INTO swe_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Men Abraham gav allt han ägde till Isak. ");
INSERT INTO swe_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Men till konkubinernas söner, som Abraham hade, gav Abraham gåvor. Och han sände iväg dem, bort från sin son Isak, medan han ännu levde, österut, till de östra områdena. ");
INSERT INTO swe_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Och detta är dagarna och åren i Abrahams liv som han levde, 175 år. ");
INSERT INTO swe_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham drog sitt sista andetag och dog i en god, hög ålder, gammal och tillfredsställd. Sedan samlades han till sitt folk. ");
INSERT INTO swe_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isak och Ismael, hans söner, begravde honom i grottan i Machpela på fältet som ligger framför Mamre, det som (tidigare) tillhört Efron, Tsoars son, hettiten. ");
INSERT INTO swe_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Fältet som Abraham köpte av Chets söner 1 Mos 23:1-20, där som Abraham begravde sin hustru Sarah. ");
INSERT INTO swe_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Efter Abrahams död välsignade Gud (Elohim) hans son Isak, och Isak bodde i Beer Lachaj Roi. Här kommer en ny ”toledot-enhet” som inleder den åttonde litterära enheten av tolv i Första Moseboken, se 1 Mos 2:4; 5:1; 6:9; 10:1; 11:10, 27; 25:12, 19; 36:1, 9; 37:2. ");
INSERT INTO swe_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Detta är Ismaels (hebr. Jishmaels) fortsatta historia (hans genealogi/släkttavla – toledot) enligt den ordning de föddes. Abrahams son som egyptiskan Hagar, Sarahs tjänarinna, födde åt Abraham. ");
INSERT INTO swe_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Och detta är namnen på Ismaels tolv söner efter deras namn enligt deras släktled. Ismaels förstfödde Nevajot och Kedar och Adbeel och Mivsam ");
INSERT INTO swe_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","och Mishma och Doma och Massa ");
INSERT INTO swe_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Chadad och Teima, Jetor, Nafish och Kedma. ");
INSERT INTO swe_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Detta är Ismaels söner och detta är deras namn efter deras byar och efter deras boplatser. Tolv furstar 1 Mos 17:20 efter deras nationer. ");
INSERT INTO swe_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Detta är åren för Ismaels liv, 137 år. Han drog sitt sista andetag och dog och samlades till sitt folk. 1 Mos 25:8 ");
INSERT INTO swe_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","De bodde från Havila (hebr. Chavila) till Shor, som ligger före Egypten som sträcker sig mot Assyrien området från norra Sinai till gränsen mot västra Mesopotamien. Han Ishamael, se 1 Mos 16:12 föll (fick sin lott; bosattes sig; kom i strid; dog) mot (ansikte, öster om) sina bröder. Här kommer en ny ”toledot-enhet” (den nionde av tolv i Första Moseboken). Skapelseberättelsen inleder och sedan följer 11 enheter som börjar med det hebreiska ordet toledot, se 1 Mos 2:4; 5:1; 6:9; 10:1; 11:10, 27; 25:12, 19; 36:1, 9; 37:2. Berättelsen tar vid från kapitlet 1 Mos 24 där Isak får sin hustru Rebecka. Den nya information som läsaren får här är att Isak var 40 år när han tog Rebecka till hustru. ");
INSERT INTO swe_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Detta är Isaks, Abrahams sons, redogörelse (fortsatta historia – hebr. toledot). Abraham blev far till Isak. ");
INSERT INTO swe_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Och det var så (hebr. vajehi) att Isak var 40 år gammal när han tog Rebecka, dotter till araméen Betuel från Paddan-Aram och syster till araméen Laban, som hustru åt sig. Detta var området kring Haran i övre Mesopotamien. Isak blir 180 år (1 Mos 35:28), vilket gör att han fortfarande har 140 år kvar av sitt jordeliv när han gifter sig. Inom den judiska kulturen är mannen kring 18-20 och kvinnan ofta 14-15 år vid giftermålet, men då är livslängden 70-80 år. ");
INSERT INTO swe_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak bönföll (bad till – hebr. atar) Herren (Jahveh) för sin hustru, eftersom hon var ofruktsam. Herren (Jahveh) bönhörde (hebr. atar) honom och Rebecka blev havande. Isak var 40 år när han gifte sig med Rebecka och 60 år när bönesvaret kom, se vers 20 och 26. Det var en uthållig bön under närmare 20 års tid. Ordet för bön här är ovanligt. ");
INSERT INTO swe_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Men barnen bråkade med varandra sparkade varandra våldsamt inom henne på ett ovanligt och troligtvis smärtsamt sätt. Så hon sa: ”Varför ska det vara så här för mig?” Ordagrant: Om så här, varför detta jag. Varför ska jag drabbas av det här? Och hon gick för att utkräva (begära svar – hebr. darash) av Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Herren (Jahveh) sa till henne: ”Två folk (hebr. gojim) finns i ditt moderliv (hebr. beten) ja, två stammar (etniska grupper – hebr. leom) ska breda ut sig (hebr. parad) från ditt sköte (hebr. meeh). Den ena stammen ska vara starkare än den andra och den äldre ska tjäna den yngre.” Rom 9:10-13 Samma ord för utbredas används i översikten av nationerna, se 1 Mos 10:32. ");
INSERT INTO swe_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","När tiden var inne (dagarna var fyllda) för henne att föda. Och se hebr. vehinneh – perspektivbyte, läsaren förflyttas in i tältet där hon ska föda: Det var tvillingar i hennes moderliv! ");
INSERT INTO swe_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Och ut kom den förste, rödaktig (hebr. admoni) var hela han, som en hårig (hebr. sear) klädnad mantel. Och de gav honom namnet Esau. Hans rödaktiga färg är snarlikt ordet för edomit (hebr. adomi) det folkslag som ska komma från honom, se vers 23. Även ordet för hårig anspelar på namnet för det område Esau skulle bo på, Seirs bergsbygd, se 1 Mos 36:8. ");
INSERT INTO swe_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Och efter kommer hans bror – och hans hand håller tag om Esaus häl (hebr. akev). Och man gav honom namnet Jakob (hebr. Jaaqov). Isak var 60 år gammal när de föddes. Båda sönernas namn finns med i ordlekar. Jakobs namn anspelar på att han ”håller hälen”. Den äldre brodern benämns alltså efter sitt utseende och den yngre efter sina handlingar. Esau är född rödaktig och Jakob är född att ta någon i hälen. Verbet aqav har en negativ betydelse att tränga undan, bedra och ta undan, se 1 Mos 27:36; Jer 9:4. ");
INSERT INTO swe_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Och pojkarna växte upp. Och Esau blev en man som behärskade jakt väl förtrogen med jakt och blev en skicklig jägare – en fältets man, medan Jakob blev en stillsam (hebr. tam) man som höll sig bland tälten. Kontrasterna mellan bröderna fortsätter. Esau är äventyrlig och gillar att vara ute, medan Jakob är förnöjd med att vara hemma. Ordet tam har också betydelsen oklanderlig, men här är det mer i betydelsen av ”helhet” i tillvaron, han är nöjd med att vara hemma. ");
INSERT INTO swe_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Och Isak älskade Esau, eftersom han fick äta av hans villebråd ordagrant: för villebråd i hans mun, medan Rebecka älskade Jakob. ");
INSERT INTO swe_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jakob hade kokat (hebr. zid) ett hopkok (soppa – hebr. nazid), just då kom Esau in från fältet och han var utmattad. Ordet för att koka (hebr. zid) är snarlikt ordet för att jaga (hebr. tsod). Det är den enda likheten i vad de gör. ");
INSERT INTO swe_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Och Esau sa till Jakob: ”Låt mig genast få glufsa i mig (sluka, svälja ner – hebr. laat) av det röda (hebr. edom), det där röda där, för jag är utmattad!” Därför gav man honom namnet Edom. Ordet för att äta används bara här i GT. I senare rabbinsk litteratur används det om djur som äter. Esau förmår sig inte heller att säga ”soppan”, han kallar det bara ”det röda” och vill ha det på en gång. ");
INSERT INTO swe_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Och Jakob svarade: ”Först (denna dag), sälj din förstfödslorätt (hebr. bechorah) till mig.” Den förstfödde sonen fick dubbel arvslott, se 5 Mos 21:17. ");
INSERT INTO swe_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau sa: ”Se, jag är döende, så vad betyder den då för mig – förstfödslorätten?” ");
INSERT INTO swe_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sa: ”Först (denna dag), ge mig din ed.” Och han gav honom sin ed. Ja, han Esau sålde sin förstfödslorätt till Jakob. Jfr vers 31, samma uttryck att först göra något. Jakobs ”ge mig din ed” här skiljer sig dramatiskt från den i 1 Mos 47:31 där han är en äldre man, helt beroende av sin son Josef för sin sista önskan. ");
INSERT INTO swe_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Och Jakob ger Esau bröd och linssoppa. Då åt han. Då drack han. Sedan steg han upp. Och så gav han sig iväg. Så föraktade Esau lättvindigt övergav sin förstfödslorätt. Verben i versen (5 på rad) förstärker hur Esau agerar utan att tänka på konsekvenserna. Förstfödslorätten var en gåva från Herren (Jahveh). Hans lättsinne blir ett varnande exempel på någon som är oandlig, se Heb 12:16-17. ");
INSERT INTO swe_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Det blev hungersnöd i landet, en annan hungersnöd än den som var under Abrahams dagar. Isak gick till Avimelech, filistéernas kung, till Gerar. Gerar markerade den södra gränsen av Kanaan och låg nära Gaza, se 1 Mos 10:19. ");
INSERT INTO swe_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Herren (Jahveh) visade sig för honom och sa: ”Gå inte ner till Egypten så som Abraham gjorde när det blev hungersnöd, se 1 Mos 12:10. Slå läger (hebr. shachan) i landet som jag ska berätta för dig om peka ut till dig. ");
INSERT INTO swe_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stanna (bo – hebr. gor) lev där som en gäst, inte permanent – vandra runt i detta land. Jag ska vara med dig och jag ska välsigna dig, för till dig och till din säd (avkomma, ättlingar) ska jag ge detta land. Vilket sker flera hundra år senare. Jag ska stadfästa den ed som jag svor till din far Abraham 1 Mos 15:18-19, ");
INSERT INTO swe_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","och jag ska föröka din säd (avkomma, ättlingar) till att bli som stjärnorna på himlen och till din säd ska jag ge alla dessa länder. Genom din säd (avkomma, ättlingar) ska alla jordens folkslag (hednafolk) bli välsignade 1 Mos 12:1-3, ");
INSERT INTO swe_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","eftersom Abraham lyssnade på min röst och vaktade (höll; vakade över; levde efter) det som skulle vaktas (hebr. mishmar): mina budord (hebr. mitzvot), mina förordningar (hebr. chuqim; ordagrant ’saker inristat’) och min undervisning (hebr. Torah).” Redan här används fyra olika hebreiska uttryck för Guds ord som inte ges till folket förrän Mose skriver ner de fem Moseböckerna:  • mishmar – generellt ord för något som ska iakttas och efterlevas  • mitzvot – budord, klara tydliga befallningar  • chuqim – förordningar, ordagrant ”saker inristat” vilket indikerar permanenta oföränderliga lagar, beskrivs ofta som bud som inte har en rationell förklaring  • Torah – undervisning, vägledning och instruktioner.  Det tycks självklart att redan Abraham, som den förste israeliten, lever efter dessa Guds ord och bud. ");
INSERT INTO swe_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Så Isak vistades (hebr. jashav) i Gerar. ");
INSERT INTO swe_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Männen på platsen frågade honom om hans hustru och han sa: ”Hon är min syster”, för han fruktade att säga: ”Min hustru.” – Han tänkte: ”Annars skulle männen på platsen döda mig för Rebeckas skull, eftersom hon var så vacker att se på.” Isak gör på samma sätt som hans far Abraham gjort två gånger tidigare, se 1 Mos 12:13-19; 20:2-5. På samma sätt som i Abrahams fall var fruktan orsaken till lögnen. ");
INSERT INTO swe_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Det hände när han hade varit där en lång tid att filistéernas kung Avimelech tittade ut genom ett fönster och såg och se, Isak (hebr. Jitschaq) skrattade (kelade, roade sig, vänslades, ”skojbråkade” – hebr. tsachaq) med Rebecka, sin hustru. Hebr. tsachaq är snarlikt Isaks namn som betyder skratt, se 1 Mos 17:17, 19. Samma ord används av Potifars hustru när hon anklagar Josef för att ha antastat henne, se 1 Mos 39:14, 17. Ordet används också om hur Ismael förlöjligade Isak, se 1 Mos 21:9. Allt detta förstärker hur Isak ignorerade och ”förlöjligade” Guds löfte om beskydd, och ljög för att skydda sig själv. ");
INSERT INTO swe_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimelech kallade på Isak och sa: ”Se, hon är verkligen din hustru, hur kunde du säga: Hon är min syster?” Isak svarade honom: ”Eftersom jag sa för mig själv: Annars dör jag för hennes skull.” ");
INSERT INTO swe_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimelech sa: ”Vad är det du har gjort mot oss? En av vårt folk kunde enkelt ha legat med din hustru och du skulle ha dragit skuld över oss.” ");
INSERT INTO swe_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Avimelech befallde allt folket och sa: ”Den som rör denne man eller hans hustru ska sannerligen döden dö.” ");
INSERT INTO swe_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak sådde i landet och fick samma år en hundrafaldig skörd den största avkastningen man kan få, se Matt 13:8 och Herren (Jahveh) välsignade honom. ");
INSERT INTO swe_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mannen blev stor och växte mer och mer till dess han blev mycket stor. ");
INSERT INTO swe_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Han hade boskapshjordar och kreatursbesättningar och ett stort hushåll och filistéerna avundades honom. ");
INSERT INTO swe_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Alla brunnar som han fars tjänare hade grävt under hans far Abrahams dagar, hade filistéerna lagt igen och fyllt med stoft löst material som sten, grus och jord. ");
INSERT INTO swe_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Avimelech sa till Isak: ”Gå ifrån oss för du är mycket mäktigare än vi.” ");
INSERT INTO swe_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak lämnade området och slog läger i Gerars dal (wadi – hebr. nachal) och bosatte sig där. ");
INSERT INTO swe_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isak grävde på nytt upp brunnarna med vatten, som de hade grävt under hans far Abrahams dagar, eftersom filistéerna hade lagt igen dem efter Abrahams död. Han gav dem namn efter de namn som hans far hade gett dem. ");
INSERT INTO swe_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaks tjänare grävde i dalen och fann en plats med en källa med levande (friskt) vatten. ");
INSERT INTO swe_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerars herdar tvistade med Isaks herdar och sa: ”Vattnet är vårt”. Han gav källan namnet Esek som betyder argument, tvist eller strid, eftersom de tvistade med honom. ");
INSERT INTO swe_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","De grävde en annan brunn och de tvistade om den också. Han gav den namnet Sitna. Hebr. sitna betyder anklagelse, beskyllning eller kiv. ");
INSERT INTO swe_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Han lämnade området och grävde en annan brunn. Om den tvistade de inte. Han gav den namnet Rechovot som betyder ”mycket rymligt” och han sa: ”Nu har Herren (Jahveh) gett oss utrymme och vi ska bli fruktsamma i landet.” Hebr. rechovot betyder vid, stor och rymlig och står här i plural, alltså mycket gott om plats! Isak är som nämnts tidigare den stora förebilden på Jesus bland patriarkerna. En av många saker som han gör är att både gräva nya brunnar och öppna upp gamla brunnar som blivit igenfyllda av fienden. Detta är en bild på Jesus som säger att han är det levande vattnet, brunnen och källflödet för det levande vattnet, se Joh 7:38. Precis som Jesaja profeterar om att ösa vatten med fröjd ur frälsningens källor, se Jes 12:3. ");
INSERT INTO swe_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Han gick upp från den platsen till Beer-Sheva 1 Mos 21:14. ");
INSERT INTO swe_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Herren (Jahveh) visade sig för honom samma natt och sa: ”Jag är din fader Abrahams Gud. Frukta inte, för jag är med dig och ska välsigna dig och föröka din säd (dina ättlingar) för min tjänare Abrahams skull.” ");
INSERT INTO swe_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Han byggde ett altare där och åkallade Herrens (Jahvehs) namn och slog upp sitt tält på platsen och Isaks tjänare grävde en brunn på platsen. ");
INSERT INTO swe_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sedan gick Avimelech till honom från Gerar med Achuzat, hans rådgivare (personlige vän – hebr. merea), och Pichol, officer över hans här. ");
INSERT INTO swe_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak sa till dem: ”Varför kommer ni till mig, ni som hatar mig och har sänt bort mig från er?” ");
INSERT INTO swe_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","De svarade: ”Vi såg tydligt att Herren (Jahveh) var med dig, och vi tänkte (sa) att det borde vara en ed mellan oss, mellan oss och dig, så låt oss skära ett förbund med dig, ");
INSERT INTO swe_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","så att du inte skadar oss, såsom vi inte har rört dig. Så som vi inte har gjort annat än gott mot dig och har sänt iväg dig i frid, så är du nu Herrens (Jahvehs) välsignade.” ");
INSERT INTO swe_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Han gjorde en måltid för dem och de åt och drack. Denna notis om att de åt och drack och sedan på morgonen avlägger förbundseden är alla tydliga hänvisningar till att de ingår ett komplett blodsförbund. ");
INSERT INTO swe_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Och de steg upp på morgonen och svor (ingick förbundsed) till varandra och Isak sände iväg dem och de lämnade honom i frid. ");
INSERT INTO swe_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Det hände samma dag att Isaks tjänare kom och berättade för honom angående brunnarna som de hade grävt och sa till honom: ”Vi har funnit vatten.” ");
INSERT INTO swe_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Han kallade den (brunnen) Shiva. Därför är namnet på staden Beer-Sheva än idag. Ordet shiva eller sheva, samma rot med olika vokaler, betyder både sju och ed/löfte. Betydelsen av Beer-Sheva brukar översättas sju brunnar. Det är mest naturligt då det är det antal brunnar som Abraham ursprungligen lät gräva på platsen. Men det är lika rätt att översätta namnet till löftesbrunnen, och då kan man hänvisa till den ed som Isak ingick med Gerars kung. Alla namn i det hebreiska språket har en betydelse som gör det till mer än enbart ett namn. När det som i detta fall har mer än en betydelse går det som regel också att hänvisa till flera olika händelser som är orsaker till namngivningen. ");
INSERT INTO swe_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","När Esau var 40 år gammal tog han Judit till hustru, dotter till hettiten Beeri och Basmat, dotter till hettiten Eilon. ");
INSERT INTO swe_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Dessa kvinnor blev en källa till bitterhet (en sorg, ordet kan även betyda uppror) för Isak och Rebecka. Att bara den äldre brodern Esau nämns, och att föräldrarna är besvikna på honom, gör att läsaren anar att detta kommer att utvecklas mer i nästa kapitel. Esaus ingifte hos hettiterna används av Rebecka som en täckmantel för att skicka iväg Jakob till Paddan Aram för att hitta en hustru till honom, se 1 Mos 27:46; 28:5. ");
INSERT INTO swe_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","När Isak var gammal och hans ögon var skumma förmodligen av starr så att han inte kunde se, kallade han på Esau, sin äldre son och sa till honom: ”Min son” och han svarade: ”Här är jag.” Hebr. hineni – jag står till förfogande, jag är beredd att ta ansvar, se 1 Mos 22:1. ");
INSERT INTO swe_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Och han sa: ”Se, nu är jag gammal, men jag vet inte vilken dag jag ska dö. ");
INSERT INTO swe_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Därför, ber jag dig, ta dina vapen, ditt koger och din båge, och gå ut på fältet och fäll ett villebråd åt mig. ");
INSERT INTO swe_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Och tillred (gör – hebr. asah) något läckert en välsmakande måltid med viltstek och tillbehör åt mig, något som jag älskar. Och för det till mig. Och jag ska äta. Gör detta så att jag kan ordagrant: min själ välsigna dig innan jag dör.” ");
INSERT INTO swe_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebecka hörde när Isak talade med sin son Esau. Och Esau gick ut på fältet för att jaga en hjort och ta hem den. ");
INSERT INTO swe_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebecka talade med sin son Jakob och sa: ”Se, jag hörde din far tala med din bror Esau och säga: ");
INSERT INTO swe_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","’Hämta ett villebråd till mig och tillred (gör) något läckert så att jag kan äta och välsigna dig inför Herren (Jahveh) innan jag dör.’ ");
INSERT INTO swe_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Därför, min son, lyssna noga och gör som jag befaller dig. ");
INSERT INTO swe_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gå till flocken och hämta därifrån till mig två fina killingar av getterna och av dem ska jag tillreda (göra) något läckert åt din far, något som han tycker om. ");
INSERT INTO swe_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Och du ska ge det till din far så att han kan äta, så att han kan välsigna dig innan han dör.” ");
INSERT INTO swe_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob sa till sin mor Rebecka: ”Se, min bror Esau är en hårig man och jag är en slät man. ");
INSERT INTO swe_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Min far kan till äventyrs vilja känna på mig och då blir jag som ett hån för honom och jag drar en förbannelse över mig och inte en välsignelse.” ");
INSERT INTO swe_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hans mor Rebecka svarade honom: ”Över mig ska den förbannelsen komma, min son, lyssna bara på min röst och gå och hämta dem åt mig.” ");
INSERT INTO swe_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Och han gick och hämtade och förde dem till sin mor och hans mor tillredde något läckert (en lyxig måltid), en sådan som hans far älskade. ");
INSERT INTO swe_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Och Rebecka tog Esaus, sin äldre sons, utvalda (finaste, bästa) kläder någon form av högtidsdräkt som hon hade hos sig i huset, och satte dem på sin yngre son Jakob. ");
INSERT INTO swe_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Och hon satte skinn från killingarna på hans händer och på den lena (hårlösa) delen av hans nacke. ");
INSERT INTO swe_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Och hon gav den läckra rätten och bröd som hon gjort i ordning i sin son Jakobs händer. ");
INSERT INTO swe_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Och han kom till sin far och sa: ”Min far!” Han sa: ”Här är jag, vem är du, min son?” ");
INSERT INTO swe_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Då sa Jakob till sin far och ljög: ”Jag är Esau, din förstfödde. Jag har gjort som du talat till mig (det du bett mig om). Stå upp och kom, jag ber dig, sitt och ät av min anrättning villebråd, så att du (din själ) kan välsigna mig.” ");
INSERT INTO swe_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Men Isak frågade sin son: ”Hur har du funnit det så snabbt, min son?” Han svarade: ”Eftersom Herren din Gud (Jahveh Elohim) lät mig ha god jaktlycka (ordagrant: sände mig framför hans ansikte).” ");
INSERT INTO swe_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Då sa Isak till Jakob: ”Kom nära, jag ber dig, så att jag får känna på dig min son, om du verkligen är min son Esau eller inte.” ");
INSERT INTO swe_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Och Jakob gick nära sin far Isak och han kände på honom och sa: ”Rösten är Jakobs röst, men händerna är Esaus händer.” ");
INSERT INTO swe_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Och han kände inte igen honom eftersom hans händer var håriga som hans bror Esaus händer, och han välsignade honom. ");
INSERT INTO swe_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Och han sa: ”Är du verkligen min son Esau?” Och han svarade: ”Det är jag.” ");
INSERT INTO swe_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Och han sa: ”För det nära mig och jag ska äta av min sons anrättning så att min själ (hela min person) kan välsigna dig.” Och han ställde det nära honom och han åt och han gav honom vin och han drack. ");
INSERT INTO swe_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Och hans far Isak sa till honom: ”Kom nära nu och kyss mig min son.” ");
INSERT INTO swe_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Och han kom nära och kysste honom. Och han kände doften av hans kläder och välsignade honom och sa: ”Se, doften av min son är som doften av fälten som Herren (Jahveh) har välsignat. ");
INSERT INTO swe_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Må Gud (Elohim) ge dig himlarnas dagg och jordens feta rika/välsignade platser, och överflöd av säd och vin. ");
INSERT INTO swe_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Låt folken (hebr. am) tjäna dig och folkgrupper (etniska grupper – hebr. leom) böja sig inför dig i respekt och vördnad. Var en herre över dina bröder, och låt din mors son böja sig inför dig. Förbannad (hebr. arar) är var och en som förbannar (arar) dig, och välsignad är var och en som välsignar dig. 1 Mos 12:3” ");
INSERT INTO swe_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Och det skedde att så snart Isak hade avslutat välsignelsen av Jakob, lämnade Jakob sin fars närhet och Esau, hans bror kom in från sin jakt. ");
INSERT INTO swe_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Och även han tillredde (gjorde) något läckert en välsmakande måltid med viltstek och tillbehör och bar in till sin far och han sa till sin far: ”Låt min far stå upp och äta av sin sons anrättning, så att han kan välsigna mig.” ");
INSERT INTO swe_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Och Isak hans far sa till honom: ”Vem är du?” Han svarade: ”Jag är din son, din förstfödde, Esau.” ");
INSERT INTO swe_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Och Isak darrade våldsamt och sa: ”Vem är då han som tog viltkött och gav det till mig, och jag har ätit allt av det innan du kom, och har välsignat honom? Ja, och han ska vara välsignad.” ");
INSERT INTO swe_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","När Esau hörde sin fars ord, skrek han ett högt (mycket stort) och bittert skrik och han sa till sin far: ”Välsigna mig, även mig, min far!” ");
INSERT INTO swe_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Men han Isak svarade: ”Din bror Jakob kom med list och har tagit din välsignelse.” ");
INSERT INTO swe_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Och han Esau sa: ”Heter han inte med rätta Jakob? Jakob betyder ”den som håller i hälen” eller ”den som tränger undan”. För han har trängt undan mig dessa två gånger. Han tog min förstfödslorätt och se, nu har han tagit bort välsignelsen.” Sedan frågade han: ”Har du någon annan välsignelse för mig?” ");
INSERT INTO swe_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Och Isak svarade och sa till Esau: ”Se, jag har gjort honom till herre, och alla hans bröder har jag gett till honom som tjänare, och med säd och vin har jag försett honom, och vad mer ska jag göra för dig, min son?” ");
INSERT INTO swe_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Och Esau sa till sin far: ”Har du inte någon välsignelse, min far? Välsigna mig, även mig, min far.” Och Esau lyfte upp sin röst och grät. ");
INSERT INTO swe_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Och Isak, hans far, svarade och sa till honom: ”Se, fjärran från jordens feta rika/välsignade platser ska din boning vara och utan himlarnas dagg från ovan. ");
INSERT INTO swe_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Med hjälp av (genom) ditt svärd ska du leva genom att plundra och röva, se Amos 1:11, och du Esau och dina efterkommande – edomiterna ska tjäna din bror Jakob/Israel, och det ska ske när du bryter dig loss (irrar runt) att du skakar av dig hans ok från din nacke.” Denna anti-välsignelse är hälften så lång som den som först var tänkt för den äldste sonen, se vers 28-29. Orden här är motsatta, jfr vers 39 med vers 28 där även ordningen av dagg/feta är reverserad till feta/dagg. Orden här blir en profetia över Esaus ättlingar, edomiterna. De försöker slå sig fria under Salomos regeringstid, se 1 Kung 11:14-22. Deras frigörelse kommer i revolten mot kung Jehoram, se 2 Kung 8:20-22; 2 Krön 21:8-10. ");
INSERT INTO swe_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Och Esau hatade Jakob på grund av välsignelsen som hans far välsignat honom med. Och Esau sa (tänkte) i sitt hjärta: ”Låt sorgedagarna efter min far passera, sedan ska jag döda min bror Jakob.” ");
INSERT INTO swe_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Och Esaus, hennes äldre sons, ord, berättades för Rebecka och hon skickade efter Jakob, sin yngre son, och sa till honom: ”Se, din bror Esau som rör vid dig, sorg-tröstar sig själv (hebr. nacham) känner sorg, men kommer snart att agera och har för avsikt att döda dig. ");
INSERT INTO swe_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Lyssna därför, min son, till min röst och stig upp, fly till Laban, min bror i Haran (hebr. Charan), ");
INSERT INTO swe_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","och stanna hos honom några dagar till dess din brors raseri har lagt sig, ");
INSERT INTO swe_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","till dess hans vrede har vänts bort från dig, och han glömmer det som du har gjort mot honom. Sedan ska jag sända och hämta dig därifrån, varför skulle jag berövas er båda på samma dag?” ");
INSERT INTO swe_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Och Rebecka sa till Isak: ”Jag är avskyr mitt liv (är trött på livet) på grund av Chets döttrar som Esau gift sig med, se 1 Mos 26:34-35. Om nu också Jakob tar en hustru av Chets döttrar, en som dessa av döttrarna från landet, varför skulle jag då leva?” ");
INSERT INTO swe_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Och Isak kallade på Jakob och välsignade honom och förmanade honom och sa till honom: ”Du ska inte ta en hustru från Kanaans döttrar. ");
INSERT INTO swe_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Stå upp och gå till Paddan-Aram i norr; övre Mesopotamien, nuvarande sydöstra Turkiet till Betoels hus, din mors far, och ta dig en hustru därifrån, från Labans döttrar, din mors bror. Laban och Rebecka var syskon, och deras far hette Betoel, se 1 Mos 22:23. ");
INSERT INTO swe_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Och Allsmäktig Gud (El Shaddaj) välsignar dig och gör dig fruktsam och förökar dig så att du blir en församling av folk, ");
INSERT INTO swe_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","och ger till dig Abrahams välsignelser och till din säd med dig, så att du kan ärva landet som du vistats i, som Gud (Elohim) gav till Abraham.” ");
INSERT INTO swe_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Och Isak sände iväg Jakob och han gick till Paddan-Aram, till araméen Laban, som var son till Betoel och bror till Rebecka, Jakobs och Esaus mor. ");
INSERT INTO swe_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","När Esau såg att Isak hade välsignat Jakob och sänt iväg honom till Paddan-Aram för att ta sig en hustru därifrån, och att han välsignat honom och förmanat honom och sagt: ”Du ska inte ta dig en hustru av Kanaans döttrar”, ");
INSERT INTO swe_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","och att Jakob lyssnat till sin far och till sin mor och hade gått till Paddan-Aram, ");
INSERT INTO swe_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","och Esau såg att Kanaans döttrar inte behagade hans far, ");
INSERT INTO swe_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","då gick han till Ismael och tog Machalat, Ismaels dotter, Abrahams son, Nevajots syster, till att bli hans hustru, utöver de fruar han hade. ");
INSERT INTO swe_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob lämnade sina föräldrar Isak och Rebecka och sin bror Esau i Beer-Sheva och begav sig mot Haran. Haran ligger i Mesopotamien, ca 80 mil norr om Beer-Sheva, minst en månads vandring till fots. Rebeckas plan att klaga över Esaus kanaaneiska hustrur hade lyckats. Hon fick sin man Isak att skicka i väg hennes favoritson Jakob för att hitta en hustru långt i norr, och på så vis skydda honom från att bli dödad av sin tvillingbror Esau. ");
INSERT INTO swe_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Jakob kom till platsen en speciell plats som kommer att bli en helig plats där han måste stanna över natten eftersom solen hade gått ner. Han tog en av stenarna på platsen, placerade den vid huvudet och lade sig ned för att sova på platsen. I hebreiskan används ”platsen” i bestämd form tre ggr. Allteftersom berättelsen utvecklas blir det till den heliga platsen Betel (se vers 19) som betyder ”Guds hus”. Det är 3-4 dagars vandring från Beer-Sheva till Betel som ligger 2,5 mil norr om Jerusalem. Stenen kan ha använts som kudde, eller tjänat något annat syfte. Det verkar inte som om Jakob ännu var helt övertygad om att Herren var den ende Guden, se vers 20-21. Många folk över hela jorden ser vissa stenar som magiska och heliga, och kanske hade han också sådana föreställningar. Här går solen ner, det är först i 1 Mos 32:31 (20 år senare) när Jakob kommer tillbaka, försonad med Gud och på väg att försonas med sin bror, som solen går upp igen. Det är en mörk tid med 14 år som livegen slav åt Laban, se 1 Mos 31:41. ");
INSERT INTO swe_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Han drömde den natten en gudomligt inspirerad dröm och såg en stege vara rest på jorden. Toppen nådde ända upp till himlarna och han såg hur Guds (Elohims) änglar steg upp och ner på den. Jesus är denna stege, se Joh 1:51. Han är den som förbinder himlen med jorden, det övernaturliga med det naturliga! Det är också intressant att notera att riktningen är att änglar ”stiger upp” och sedan ner. Texten säger inte om det är samma änglar som först går upp och sedan ner. De kan ha kommit för att rapportera slutförda uppdrag för att sedan stiga ner med nya uppgifter. Judiska rabbiner lär att änglarna i landet steg upp till himlen, och änglarna som verkar utanför Israel steg ner. ");
INSERT INTO swe_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Plötsligt såg han Herren (Jahveh) själv stå högst upp och säga: ”Jag är Herren (Jahveh), din fader förfader Abrahams Gud och din far Isaks Gud. Notera att ännu har Gud inte blivit Jakobs Gud, det är först efter brottningskampen i 1 Mos 32:24-28. Marken som du nu ligger på ska jag ge åt dig och din säd efterkommande. ");
INSERT INTO swe_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Din avkomma ska bli talrik som stoftet på jorden och du ska utbreda dig åt havet till Medelhavet i väster och öster, och norr, och till Negev öknen i söder. Genom dig och din avkomma ska alla folkslag på jorden bli välsignade. 1 Mos 12:3; 15:5; 22:16-18 ");
INSERT INTO swe_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Se, jag är med dig och ska bevara dig vart du än går, och jag ska föra dig tillbaka till detta land. Jag ska inte överge dig intill dess att jag har gjort vad jag har talat till dig.” Jakob hade ännu inte någon fru, men skulle bli far till tolv söner (nationen Israel) och finns med i släktledet för den utlovade Messias – Jesus. ");
INSERT INTO swe_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Drömmen tog slut och Jakob vaknade upp ur sömnen och sa: ”Herren är verkligen på denna plats och jag visste det inte.” ");
INSERT INTO swe_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Han greps av fruktan och sa: ”Hur helig är inte denna plats! Det måste vara Guds boning, ja, här är himlarnas port.” ");
INSERT INTO swe_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Och Jakob steg upp tidigt på morgonen och tog stenen som han haft under sitt huvud och reste upp den som en pelare och hällde ut olja ovanpå den. ");
INSERT INTO swe_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Och han gav platsen namnet Betel. Men likväl (en skarp betoning och kontrast mellan något som varit och något som är – hebr. olam) var Loz stadens namn till en början. ");
INSERT INTO swe_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Och Jakob avlade ett löfte och sa: ”Om Gud (Elohim) är med mig och håller (vaktar, skyddar, bevarar) mig på den väg jag går och ger mig bröd att äta och kläder att klä mig med, ");
INSERT INTO swe_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","så att jag kommer tillbaka till min fars hus i frid (shalom), då ska Herren (Jahveh) vara min Gud (Elohim), ");
INSERT INTO swe_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","och denna sten som jag har rest upp som en pelare ska vara Guds (Elohims) hus, och av allt som du ger mig ska jag ge tionde till dig.” ");
INSERT INTO swe_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Och Jakob lyfte sin fot (fortsatte sin färd) från Betel mot Paddan-Aram, se 1 Mos 28:1, 19 och kom till österns söner bred term för folkslagen öster om Kanaan. Uttrycket ”lyfta upp sin fot” är ovanligt. Ordet lyfta upp (hebr. nasa) brukar användas om ”att lyfta upp sina ögon”. Kanske är det författarens sätt att förbereda läsaren att vara uppmärksam på nästa gång detta ord används, vilket är i vers 11. Det kan även vara en koppling till drömmen föregående natt då han blickade upp och såg stegen och änglarna och fick ett möte med Gud, se 1 Mos 28:12-13. ");
INSERT INTO swe_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Och han såg och se, en källa på fältet, och tre flockar med får låg vid den. För från den källan gav de flockarna vatten att dricka. Och stenen över källans öppning var stor. ");
INSERT INTO swe_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Och dit samlades alla flockar och de rullade stenen från källans öppning och gav fåren att dricka och lade tillbaka stenen över källans öppning på sin plats. ");
INSERT INTO swe_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob frågade dem: ”Mina bröder, vilka är ni?” De svarade: ”Vi är från Haran.” 1 Mos 11:31 ");
INSERT INTO swe_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Då frågade han dem: ”Känner ni Laban (hebr. Lavan – betyder ”vit”), Nachors son?” De svarade: ”Vi känner honom.” ");
INSERT INTO swe_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Han frågade dem: ”Är det väl med honom?” Och de svarade: ”Det är väl, och se, Rakel (hebr. Rachel), hans dotter, kommer med fåren.” ");
INSERT INTO swe_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Han sa: ”Det är fortfarande mitt på dagen och inte tid att samla ihop boskapen. Ge fåren vatten och valla dem (för dem ut på bete).” ");
INSERT INTO swe_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Men de svarade: ”Vi kan inte förrän alla flockar har samlats ihop och de rullar undan stenen från källans öppning, sedan vattnar vi fåren.” ");
INSERT INTO swe_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Medan han fortfarande talade med dem kom Rakel med sin fars får, för hon vallade dem. ");
INSERT INTO swe_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Och det hände att när Jakob såg Rakel, hans morbror Labans dotter, och hans får, kom Jakob nära och rullade undan stenen från källans öppning och gav Labans flock vatten. ");
INSERT INTO swe_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Och Jakob kysste Rakel och han höjde (lyfte upp – hebr. nasa) sin röst och grät. ");
INSERT INTO swe_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Och Jakob berättade för Rakel att han var hennes fars släkting och att han var Rebeckas son. Då sprang hon i väg och berättade det för sin far. ");
INSERT INTO swe_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Och det skedde när Laban hörde nyheten om Jakob, hans systers son, att han sprang och mötte honom och omfamnade honom och kysste honom och förde honom till sitt hus. Och han återgav (räknade upp) allting för Laban. ");
INSERT INTO swe_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Och Laban sa till honom: ”Med säkerhet är du mina ben och mitt kött.” Och han vistades hos honom i en månads tid. ");
INSERT INTO swe_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Och Laban sa till Jakob: ”Eftersom du är min släkting (bror – hebr. ach), ska du inte tjäna (arbeta för, betjäna – hebr. avad) mig för ingenting. Berätta för mig vilken lön jag ska ge dig.” Ordet för att tjäna (hebr. avad) betyder att odla och arbeta (2 Mos 20:9; 2 Mos 1:13) men också att tillbe (2 Mos 7:16). I grekisk filosofi och tänkande, som influerat mycket av västvärlden, anses arbete vara något ont och det andliga gott. I Bibeln hör tillbedjan och arbete ihop. ");
INSERT INTO swe_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Och Laban hade två döttrar, den äldre hette Leah och den yngre var Rakel. ");
INSERT INTO swe_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Och Leahs ögon var svaga men Rakel hade en vacker gestalt och var vacker att se på. ");
INSERT INTO swe_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Och Jakob älskade Rakel och han sa: ”Jag vill tjäna dig sju år för din yngre dotter Rakel.” ");
INSERT INTO swe_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban svarade: ”Det är bättre att jag ger henne till dig än att jag ska ge henne till någon annan man, stanna hos mig.” ");
INSERT INTO swe_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Så Jakob tjänade sju år för Rakel, men i hans ögon var det bara som några få dagar, på grund av den kärlek han hade till henne. ");
INSERT INTO swe_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sedan sju år senare sa Jakob till Laban: ”Ge mig min hustru, för mina dagar är fyllda, så att jag kan gå in till henne.” ");
INSERT INTO swe_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Så Laban samlade ihop alla platsens män och gjorde en fest. ");
INSERT INTO swe_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Och det skedde på kvällen att han tog sin dotter Leah och förde till honom, och hon kom in till honom. ");
INSERT INTO swe_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Och Laban gav sin tjänarinna Zilpah som tjänarinna till sin dotter Leah. ");
INSERT INTO swe_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Och det hände på morgonen att se, det var Leah, och han sa till Laban: ”Vad är detta du har gjort mot mig? Har jag inte tjänat dig för Rakel? Varför har du bedragit mig?” ");
INSERT INTO swe_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban svarade: ”Vi gör inte så här (det är inte vår sed) att vi ger den yngre före den förstfödda äldre. ");
INSERT INTO swe_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Fullfölj veckorna för denna och vi ska även ge dig den andra för det arbete som du ska göra i ytterligare sju år.” ");
INSERT INTO swe_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Och Jakob gjorde så och fullföljde sina veckor, och han gav honom Rakel, sin dotter, till hustru. ");
INSERT INTO swe_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Och Laban gav sin tjänarinna Bilhah (betyder: bekymrad) som tjänarinna till sin dotter Rakel. ");
INSERT INTO swe_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Och han Jakob gick in även till Rakel och han Jakob älskade Rakel mer än Leah, och tjänade hos honom Laban ytterligare sju år. Att Jakob älskar Rakel mer än Leah leder till avundsjuka, se 1 Mos 29:31, 33; 30:1, 15. Jakob arbetar sju år före giftermålet med Leah och Rakel. Han förbinder sig sedan att arbeta sju år till, dvs. totalt 14 år. Följande stycke beskriver nu de sju åren efter giftermålet med Leah och Rakel. De 11 sönerna (och dottern Dina) som räknas upp här föds inom en sjuårsperiod, se 1 Mos 31:41; 30:25-26. Texten innehåller kontraster som älskad/hatad och fruktsam/ofruktsam. I det hebreiska språkbruket innebär det inte att Jakob aktivt ”hatade” Leah (Klag 3:8; Amos 5:15), han älskade Rakel mer, som han arbetat två sjuårsperioder för att få gifta sig med. Betydelsen är snarare oälskad, negligerad och avvisad, se Jes 54:6; Mal 1:2-3. Se även 5 Mos 21:15-17; 1 Sam 1:5-6. I Ordspråksboken är en av fyra saker som får jorden att darra, just en ”hatad” kvinna som blir gift, se Ords 30:23. Denna obalans blir tydlig där konflikten i familjen fortsätter mellan barnen. Senare föds Benjamin, se 1 Mos 35:18. ");
INSERT INTO swe_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Och Herren (Jahveh) såg att Leah var hatad (oälskad, motbjudande, avvisad), och han öppnade hennes livmoder, men Rakel var ofruktsam. ");
INSERT INTO swe_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Så blev Leah gravid och födde en son och hon gav honom namnet Ruben hebr. Reoven – betyder: ”Se, en son!”, för hon sa: ”Eftersom Herren (Jahveh) har sett till min nöd (misär; mitt elände – hebr. oni) så kommer min man nu att älska mig.” ");
INSERT INTO swe_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Och hon Leah blev gravid igen och födde en son och sa: ”Eftersom Herren (Jahveh) har hört (hebr. shama) att jag är hatad (oälskad, motbjudande, avvisad), har han gett mig även denna son.” Och hon gav honom namnet Simeon (hebr. Shimon – betyder: ”höra”). ");
INSERT INTO swe_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Och hon Leah blev gravid igen och födde en son och sa: ”Nu, denna gång ska min man förenas med (vara nära – hebr. lava) mig eftersom jag har fött honom tre söner.” Därför gav hon honom namnet Levi betyder: ”förenad med”. ");
INSERT INTO swe_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Och hon Leah blev gravid igen och födde en son och hon sa: ”Denna gång ska jag prisa (hebr. jada) Herren (Jahveh).” Därför gav hon honom namnet Juda betyder: ”prisa” och hon slutade att bli gravid. ");
INSERT INTO swe_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Och när Rakel såg att hon inte födde några barn till Jakob avundades hon sin syster och hon sa till Jakob: ”Ge mig barn, annars dör jag.” ");
INSERT INTO swe_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Och Jakobs vrede upptändes mot Rakel och han svarade henne: ”Är jag i Guds (Elohims) ställe, som inte har låtit dig få frukt i din livmoder?” ");
INSERT INTO swe_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Då sa hon: ”Se min tjänstekvinna Bilhah, gå in till henne och hon kan föda och lägga det på mina två knän bli mitt barn, så att även jag kan bygga min familj (ordagrant: jag blir uppbyggd) genom henne.” Det fanns en sed att lägga det nyfödda barnet på knäna, först på fadern (som genom att ta emot det erkände barnet som sitt eget) och sedan på modern. I det här fallet ska Bilhah lägga sitt barn på Jakobs och Rakels knän så det blir deras barn. Se även 1 Mos 50:23. ");
INSERT INTO swe_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Så hon gav honom Bilhah, sin tjänstekvinna till hustru, och Jakob gick in till henne. ");
INSERT INTO swe_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Och Bilhah blev gravid och födde en son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Och Rakel sa: ”Gud (Elohim) har dömt (hebr. danan) mig och även hört min röst och har gett mig en son.” Därför gav (kallade) hon honom namnet Dan betyder: domare. ");
INSERT INTO swe_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Och Bilhah, Rakels tjänstekvinna blev gravid igen och födde en andra son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Och Rakel sa: ”Guds närkamper har jag utkämpat (stretat, ’vridit mig’; brottats) med min syster och jag har verkligen fått överhanden (övervunnit).” Så gav (kallade) hon honom namnet Naftali betyder: ”min kamp”; eller möjligtvis ”slug närkamp”. ");
INSERT INTO swe_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","När Leah såg att hon hade lämnat (slutat) att bli gravid, tog hon Zilpah sin tjänstekvinna, och gav henne till Jakob som bihustru. ");
INSERT INTO swe_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Och Zilpah, Leahs tjänstekvinna födde en son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Och Leah sa: ”Lyckan (hebr. gad) har kommit!” Och hon gav (kallade) honom namnet Gad. Namnet betyder lycka eller förmögenhet, men kan också betyda skara eller trupp. ");
INSERT INTO swe_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Och Zilpah, Leahs tjänstekvinna födde en andra son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Och Leah sa: ”Jag är glad (välsignad – hebr. asher) för döttrarna ska kalla mig lycklig.” Och hon gav (kallade) honom namnet Asher. Asher betyder glad och att känna sig välsignad, men även att vara ärlig och gå rakt fram. ");
INSERT INTO swe_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Och Ruben Jakobs förstfödde (med Leah), som nu var i 4-5 års åldern gick ut till veteskörden på dagarna och hittade alrunor (mandragora; ”kärleksäpplen” – hebr. dodaj) på fältet och tog hem det till sin mor Leah. Då sa Rakel till Leah: ”Ge mig, jag ber dig, från din sons alrunor.” Alla 11 söner (och dottern Dina) som räknas upp i 1 Mos 29:32-30:34 föds inom en sjuårsperiod (av fyra olika mödrar). Sedan Leah fött Ruben får hon tre barn till i rask följd. Sedan sker ett uppehåll då denna händelse inträffar. Ruben måste då vara 4-5 år, men inte äldre eftersom hon sedan får ytterligare tre barn i rask följd.  Alruna (Mandragora officinarum) är en art i familjen potatisväxter. Örten har grova rötter som ofta kan få former som påminner om nakna människokroppar. De användes ibland som husgudar (hebr. terafim). Från roten växer långa mörkgröna blad som bildar som en rosett. Den bildar blekt purpurblå blommor som under våren blir till små gul/röda frukter. Frukten har beskrivits som ett gult fågelägg i ett genomskinligt bo. Vid den här tiden på våren, då veteskörden bärgas, är frukten mogen och den doftar också, se Höga V 7:13. Frukten kan skalas och ätas. Mest troligt är att den unge Ruben bara plockar frukten och tar med sig den hem. Det finns antika berättelser hur hundar och åsnor användes för att dra upp de djupa rötterna, så med tanke på hans ålder, är det inte troligt att han gräver upp roten. Dess frukter ansågs verka som ett afrodisiakum med en stärkande effekt på könsdriften. Araberna kallade frukten ”djävulens äpplen” och i den grekiska världen fick den smeknamnet ”kärleksäpple”. Kopplingen till kärlek finns även i det hebreiska namnet dodaj (som också delar rot med namnet David), som är snarlikt ordet för kärlek (hebr. dod) och ”min älskade” i Höga Visan, se Höga V 2:2. Den grekiska naturforskaren Dioskorides (40-90 e.Kr.) skriver hur mandragoraroten kunde kokas i vin och ges som smärtlindrande medel. Det verkade även mot sömnlöshet och användes inför operativa ingrepp. Mandragora växer än idag på fälten i Israel. ");
INSERT INTO swe_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Och hon Leah sa till henne Rakel: ”Är det en liten sak (är det inte tillräckligt illa) att du har tagit min man från mig? Ska du nu också ta min sons alrunor (’kärleksäpplen’)?” Så Rakel sa: ”Låt gå (ordagrant: därför), han kan ligga med dig i natt för i utbyte mot din sons alrunor.” ");
INSERT INTO swe_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","När Jakob kom från fältet på kvällen gick Leah ut och mötte honom och sa: ”Du måste komma in till mig, för jag har verkligen köpt dig med min sons alrunor.” Leah väntade inte hemma utan gick ut och mötte Jakob. Och han låg hos henne den natten. Här används inte känna (hebr. jada, se 1 Mos 4:1) som är det ord som brukar användas om äktenskapligt samliv, utan ”ligga” som oftare har med utomäktenskaplig sex att göra, se 1 Mos 39:12. De fyra första sönerna som Leah föder står det bara att hon föder (1 Mos 29:32, 33, 34, 35), men de två sista föder hon ”till Jakob” (vers 17 och 19), precis som Bilhah (vers 5 och 7) och Zilpah (vers 10 och 12). Även Josef och Benjamin har annorlunda formulering och saknar frasen ”till Jakob”, se vers 23 och 1 Mos 35:18. ");
INSERT INTO swe_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Och Gud (Elohim) lyssnade till Leah och hon blev gravid och födde en femte son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Och Leah sa: ”Gud (Elohim) har gett mig min lön (hebr. shachar) eftersom jag gav min tjänstekvinna till min man. Och hon gav (kallade) honom namnet Isaskar (hebr. Jisashchar).” Betyder det finns lön, kompensation eller belöning. ");
INSERT INTO swe_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Och Leah blev gravid igen och födde en sjätte son till Jakob. ");
INSERT INTO swe_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Och Leah sa: ”Gud (Elohim) har skänkt (hebr. zavad) mig en god hemgift (hebr. zeved), nu ska min man umgås (hebr. zaval) med mig, eftersom jag har fött honom sex söner.” Och hon gav (kallade) honom namnet Sebulon (hebr. Zevolun). Namnet betyder upphöjd, men även boplats, habitat. ");
INSERT INTO swe_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Därefter födde hon Leah en dotter. Och hon gav (kallade) henne namnet Dina. Dina betyder rätt eller domare, den feminina formen av Dan. ");
INSERT INTO swe_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gud (Elohim) kom ihåg Rakel och Gud (Elohim) lyssnade till henne och öppnade hennes livmoder. ");
INSERT INTO swe_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hon blev gravid och födde en son och sa: ”Gud (Elohim) har tagit bort min förebråelse (vanära, skam).” ");
INSERT INTO swe_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Och hon gav (kallade) honom namnet Josef och sa: ”Herren (Jahveh) har förökat (hebr. josef) till mig ännu en son.” Josef betyder Herren förökar. Rakel får ännu ett barn, men hon dör i barnsäng när hon får honom, se 1 Mos 35:18. Han får namnet Benjamin och blir den tolfte av Jakobs söner. ");
INSERT INTO swe_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Och det skedde när Rakel hade fött Josef att Jakob sa till Laban: ”Sänd iväg mig så att jag kan gå till min plats och till mitt land. ");
INSERT INTO swe_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ge mig mina fruar och mina barn för vilka jag har tjänat dig och låt mig gå, för du känner mycket väl till hur jag har tjänat dig.” ");
INSERT INTO swe_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Och Laban sa till honom: ”Om, jag ber dig, jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon, jag har observerat tecknen, och Herren (Jahveh) har välsignat mig för din skull.” ");
INSERT INTO swe_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Och han sa (vidare): ”Utse åt mig din lön och jag ska ge dig den.” ");
INSERT INTO swe_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Och han sa till honom: ”Du vet (har god kännedom om, är väl förtrogen med) hur jag har tjänat dig och hur din boskap har haft det med mig. ");
INSERT INTO swe_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Innan jag kom hade du lite och den har förökat sig och blivit talrik, och Herren (Jahveh) har välsignat dig oavsett vart du har vänt dig. Och nu ska jag förse även mitt eget hus (hushåll).” ");
INSERT INTO swe_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Och han sa: ”Vad ska jag ge dig?” Och Jakob sa: ”Du ska inte ge mig vad som helst, om du vill göra detta för mig, ska jag igen valla vara en herde för din flock och vakta den. ");
INSERT INTO swe_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jag ska idag gå igenom dina hjordar och ta bort därifrån varje spräckligt och fläckigt, och alla mörka bland fåren, och de fläckiga och spräckliga från getterna, och de ska vara min lön. ");
INSERT INTO swe_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Så ska min rättfärdighet vittna mot mig idag och framåt, när du kommer för att se över min lön som är inför dig. Alla som inte är fläckiga och spräckliga bland getterna och mörka bland fåren, om de blir funna hos mig ska de räknas som stulna.” ");
INSERT INTO swe_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Och Laban sa: ”Se till dig ska det vara enligt dina ord.” ");
INSERT INTO swe_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Och den dagen tog han bort alla getter av hankön som var strimmiga och fläckiga och alla getter av honkön som var spräckliga och fläckiga, alla som hade något vitt (i pälsen), och alla de mörka bland fåren, och gav dem i sina söners hand. ");
INSERT INTO swe_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Och han lät det vara tre dagresor mellan sig själv och Jakob. Och Jakob vallade tog hand om och skötte resten av Labans flockar. ");
INSERT INTO swe_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Och Jakob tog sig käppar av färska popplar och av mandelträd och av platanträd, och skalade vita ränder i dem så att det vita blev synligt på käpparna. ");
INSERT INTO swe_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Och han placerade käpparna som han hade skalat mittemot flockarna i rännorna, i vattentrågen dit flocken kom för att dricka, och de blev dräktiga när de kom för att dricka. ");
INSERT INTO swe_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Och flockarna blev dräktiga i käpparnas åsyn och flockarna födde strimmiga, spräckliga och fläckiga. ");
INSERT INTO swe_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Och Jakob skiljde lammen av hankön, och vände flockens ansikten mot det strimmiga och alla mörka i Labans flock, och han placerade sina egna flockar åt sidan och placerade dem inte i Labans flock. ");
INSERT INTO swe_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Och det skedde när de starka i flocken skulle para sig att Jakob lade käpparna framför deras ögon i flockens vattentråg, så att de blev dräktiga bland käpparna, ");
INSERT INTO swe_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","men när flocken var svag lade han inte dit dem. På det sättet blev de svaga Labans och de starka Jakobs. ");
INSERT INTO swe_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Och mannen förökades (bröt fram) väldigt mycket Jakobs välstånd ökade och hade stora flockar och tjänarinnor och tjänare och kameler och åsnor. ");
INSERT INTO swe_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakob fick höra hur Labans söner sa: ”Jakob har tagit allt vår far ägde. Han har skaffat sig all den rikedomen av det som tillhör vår far.” ");
INSERT INTO swe_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakob märkte också att Laban inte såg på honom med samma ögon som förut (hans attityd var förändrad). ");
INSERT INTO swe_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Då sa Herren (Jahveh) till Jakob: ”Vänd tillbaka till dina fäders land och till din släkt. Jag är med dig.” ");
INSERT INTO swe_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Och Jakob skickade efter Rakel och Leah och bad dem komma ut på marken till hans hjord, ");
INSERT INTO swe_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","och han sa till dem: ”Jag märker att er far inte ser på mig med samma ögon som förut, men min fars Gud (Elohim) har varit med mig. ");
INSERT INTO swe_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ni vet själva att jag har tjänat er far med all min kraft. ");
INSERT INTO swe_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ändå har er far offentligt förnedrat (lurat – hebr. talal) mig och ändrat min lön tio gånger gång på gång, men Gud (Elohim) har inte tillåtit honom att göra mig något ont. Det ovanliga ordet för att lura (hebr. talal) har samma rot som ordet tel som används om en stad som byggts upp och rivits ner. Labans sätt är som ett grymt skämt där Jakobs förväntning har byggts upp som en stad synlig för alla, för att sedan raseras, på nytt byggas upp för att igen raseras. ");
INSERT INTO swe_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","När han sa: De spräckliga ska vara din lön, då fick hela hjorden spräcklig avkomma. Och när han sa: De strimmiga ska vara din lön, då fick hela hjorden strimmig avkomma. ");
INSERT INTO swe_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Så har Gud (Elohim) tagit er fars boskap och gett den åt mig. ");
INSERT INTO swe_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","När parningstiden för småboskapen kom hade jag en dröm. Jag lyfte min blick och fick se att hannarna, som betäckte småboskapen, var strimmiga, spräckliga och fläckiga. ");
INSERT INTO swe_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Och Guds (Elohim) ängel (budbärare) sa till mig i drömmen: ’Jakob!’ Jag svarade: ’Här är jag (hebr. hineni; jag tar ansvar, står till förfogande).’ ");
INSERT INTO swe_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Då sa han: ’Lyft blicken och se hur alla hannar som betäcker småboskapen är strimmiga, spräckliga och fläckiga. Jag har sett allt som Laban gör mot dig. ");
INSERT INTO swe_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Jag är den Gud (El) som såg dig i Betel för 20 år sedan, se vers 38, där du smorde en minnessten och gav mig ett löfte 1 Mos 28:20-22. Bryt nu upp och dra ut ur detta land och vänd tillbaka till ditt fosterland.’ ” ");
INSERT INTO swe_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Då svarade Rakel och Leah: ”Har vi kvar någon lott eller arvedel i vår fars egendom? ");
INSERT INTO swe_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Är vi inte som främlingar för honom? Han har ju sålt oss och sedan gjort slut på det han fick i betalning för oss. ");
INSERT INTO swe_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hela den rikedom som Gud har tagit från vår far tillhör oss och våra barn. Gör därför allt vad Gud har sagt till dig.” ");
INSERT INTO swe_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jakob bröt då upp och satte sina barn och hustrur på kamelerna ");
INSERT INTO swe_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","och tog med sig all sin boskap och all egendom som han hade samlat, boskapen han hade förvärvat och skaffat sig i Paddan-Aram, och begav sig till sin far Isak i Kanaans land. ");
INSERT INTO swe_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Men Laban hade gått för att klippa sina får. Då stal Rakel sin fars husgudar (hebr. terafim). ");
INSERT INTO swe_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Och Jakob smög sig i väg från araméen Laban utan att berätta för honom att han tänkte fly. ");
INSERT INTO swe_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Han bröt upp och flydde med allt han hade och gick över floden Eufrat och vände sitt ansikte (begav sig av) österut mot Gileads bergsbygd. ");
INSERT INTO swe_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","På tredje dagen berättade man för Laban att Jakob hade flytt. ");
INSERT INTO swe_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Då tog han med sig sina bröder och satte efter honom, och efter sju dagar hann han upp honom i Gileads bergsbygd högplatån öster om Jordanfloden, sista anhalten innan Jakob kom till Kanaans land. ");
INSERT INTO swe_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Men Gud kom till araméen Laban i en dröm om natten och sa till honom: ”Akta dig för att tala något mot Jakob, gott eller ont.” ");
INSERT INTO swe_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","När Laban hann upp Jakob, hade denne slagit läger på berget. Också Laban och hans män slog läger på Gileads berg. ");
INSERT INTO swe_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Då sa Laban till Jakob: ”Vad har du gjort? Du smög dig i väg från mig och förde bort mina döttrar likt fångar tagna med svärd. ");
INSERT INTO swe_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Varför flydde du i hemlighet (ordagrant: gömde du dig för att fly)? Samma ord för att gömma sig används om Adam och Eva, se 1 Mos 3:8, 11. När du inte berättade tog du bort möjligheten för mig (stal du från mig) att kunna sända i väg dig med jubel och sång, med tamburin och kinnor-harpa. ");
INSERT INTO swe_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Du unnade mig inte ens att få kyssa mina barnbarn och mina döttrar. Du har betett dig dåraktigt. ");
INSERT INTO swe_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Jag har makt (kraft – hebr. el) att göra er illa, men er fars Gud (Elohim) sa till mig i natt: ’Akta dig för att tala något mot Jakob, gott eller ont.’ ");
INSERT INTO swe_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nu gav du dig i väg för att du längtade hem så mycket. Men varför stal du mina gudar?” ");
INSERT INTO swe_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob svarade Laban: ”Jag var rädd för dig, för jag tänkte att du skulle ta dina döttrar ifrån mig med våld (rycka dem ifrån mig – hebr. gazal). ");
INSERT INTO swe_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Men den som du hittar dina gudar hos ska inte få leva. Här inför våra släktingar får du se efter om jag har något hos mig som är ditt, och i så fall ta det.” Jakob visste inte att Rakel hade stulit dem. ");
INSERT INTO swe_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban gick då in i Jakobs tält, och sedan in i Leahs tält och de båda tjänstekvinnornas tält, men han fann inget. När han hade kommit ut ur Leahs tält gick han in i Rakels tält. ");
INSERT INTO swe_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Men Rakel hade tagit husgudarna och lagt dem i kamelsadeln och satt sig på dem. Laban sökte igenom hela tältet utan att finna dem. ");
INSERT INTO swe_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Och hon sa till sin far: ”Bli inte arg, herre (låt det inte vara förargelseväckande i min herres ögon), att jag inte kan resa mig inför dig, för det är med mig på kvinnors vis (jag har det som kvinnor brukar ha)” 3 Mos 15:19 Så sökte han efter husgudarna men kunde inte finna dem. ");
INSERT INTO swe_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakob blev arg och kom i gräl med Laban och sa till honom: ”Vad är mitt brott, vad är min synd, eftersom du förföljer mig så våldsamt? ");
INSERT INTO swe_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nu har du letat igenom allt jag äger. Vad har du funnit som tillhör dig? Lägg fram det inför både mina och dina släktingar här så att de får döma mellan oss båda. ");
INSERT INTO swe_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I 20 år har jag varit hos dig. Dina tackor och getter har inte fått missfall och jag har inte ätit av baggarna i din hjord. ");
INSERT INTO swe_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jag kom aldrig med något ihjälrivet djur till dig, jag var tvungen att ersätta det själv. Du krävde ersättning av mig för det stulna, antingen det stulits på dagen eller på natten. ");
INSERT INTO swe_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Så hade jag det. Om dagen plågades jag av hetta och om natten av köld, och sömnen flydde ifrån mig. ");
INSERT INTO swe_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I 20 år enligt judisk tradition år 1929-1909 f.Kr. har jag varit hos dig. Jag har tjänat dig i 14 år för dina båda döttrar och i 6 år för din boskap, men du har ändrat min lön tio gånger gång på gång, se vers 7. Jakob jobbar först 7 år för Rakel, men Laban ger honom Leah. Några veckor senare får han Rakel (1 Mos 31:20, 25), men måste jobba ytterligare 7 år (1 Mos 31:29). Jakob jobbar sedan ytterligare 6 år, men då får han lön, se 1 Mos 30:28, 43. ");
INSERT INTO swe_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Hade inte min fars Gud (Elohim) varit med mig – Abrahams Gud (Elohim) som även Isak vördar – så hade du säkert låtit mig gå med tomma händer. Men Gud såg mitt lidande och min möda, och han fällde domen i natt.” ");
INSERT INTO swe_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban svarade Jakob: ”Döttrarna är mina döttrar, barnen är mina barn och hjordarna är mina hjordar. Allt du ser är mitt. Vad skulle jag kunna göra mot mina döttrar eller mot barnen som de fött? ");
INSERT INTO swe_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kom nu, låt oss sluta förbund med varandra. Det ska vara vittne mellan mig och dig.” ");
INSERT INTO swe_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Då tog Jakob en sten och reste den till en stod. ");
INSERT INTO swe_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Sedan sa han till sitt folk: ”Samla ihop sten.” Då tog de stenar och gjorde ett röse och höll en måltid där på röset. ");
INSERT INTO swe_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban kallade det Jegar-Sahaduta, men Jakob kallade det Galed. ");
INSERT INTO swe_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Och Laban sa: ”Detta röse ska i dag vara vittne mellan mig och dig.” Så fick det namnet Galed. ");
INSERT INTO swe_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Men det kallades också Mitspah betyder: ”vaktplats, utkik”, för han sa: ”Herren ska hålla vakt mellan mig och dig när vi inte längre ser varandra. ");
INSERT INTO swe_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Om du behandlar mina döttrar illa eller tar andra hustrur vid sidan av mina döttrar, ska du komma ihåg att Gud är vittne mellan mig och dig, även om ingen människa är närvarande.” ");
INSERT INTO swe_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban sa vidare till Jakob: ”Se detta röse och se denna stod som jag rest mellan mig och dig. ");
INSERT INTO swe_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Röset här ska vara ett vittne, och stoden ska vara ett vittne att jag inte ska gå förbi röset mot dig med onda avsikter, och att inte heller du ska gå mot mig förbi röset och stoden. ");
INSERT INTO swe_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahams och Nahors Gud ska vara domare mellan oss, han som var deras fars Gud.” Och Jakob svor eden vid honom som hans far Isak vördade. ");
INSERT INTO swe_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sedan offrade Jakob slaktoffer på berget och bjöd in sina släktingar till en måltid. De åt och stannade på berget över natten. ");
INSERT INTO swe_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","På morgonen steg Laban upp tidigt, och när han hade kysst sina barnbarn och sina döttrar och välsignat dem, gav han sig i väg och återvände hem. ");
INSERT INTO swe_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Och Jakob gick sin väg och Guds (Elohims) ängel (budbärare) mötte honom. ");
INSERT INTO swe_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Och Jakob sa, när han såg dem: ”Detta är Guds (Elohims) läger.” Och han gav den platsen namnet Machanajim betyder ”två läger”, en plats i Gileads bergsbygd öster om Jordanfloden i närheten av Jabbok, se Jos 13:26, 30. ");
INSERT INTO swe_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Och Jakob sände budbärare framför sig till Esau, sin bror, till Seirs land landet öster och söder om Döda havet, Edoms fält (öppna landskap). ");
INSERT INTO swe_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Och han befallde dem och sa: ”Så ska ni säga till min herre Esau: ’Så säger din tjänare Jakob, jag har vistats hos Laban och stannat till nu. ");
INSERT INTO swe_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Och jag har oxar och åsnor och småboskap och tjänare och tjänarinnor, och jag har sänt för att berätta för min herre, för att jag ska finna nåd (oförtjänt kärlek, favör – hebr. chen) i dina ögon.’ ” ");
INSERT INTO swe_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Och budbärarna återvände till Jakob och sa: ”Vi kom till din bror Esau och nu kommer han för att möta dig och 400 män med honom.” ");
INSERT INTO swe_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakob blev mycket rädd och hade ångest. Han delade folket som var med honom, och småboskapen och kreaturen och kamelerna, i två läger. ");
INSERT INTO swe_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Och han sa: ”Om Esau kommer till det ena lägret och slår det, då kan det andra lägret som är kvar fly.” ");
INSERT INTO swe_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Och Jakob sa: ”Min far Abrahams Gud (Elohim) och min far Isaks Gud (Elohim), Herre (Jahveh), du som sagt till mig: ’Återvänd till ditt land och till din släkt och jag ska göra väl mot dig.’ ");
INSERT INTO swe_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jag är inte värdig all din nåd (omsorgsfulla kärlek – hebr. chesed) och all sanning (trofasthet – hebr. emet) som du har visat din tjänare, för med min stav gick jag över denna Jordan och nu är jag två läger. ");
INSERT INTO swe_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Befria mig, jag ber dig, från min brors hand, från Esaus hand upprepningen av hand förstärker hur han är i Esaus grepp, för jag är rädd för honom, annars kommer han att slå mig, mödrar med söner. Ordagrant: ’mor på son’ – hela familjen. ");
INSERT INTO swe_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Och du sa: ’Jag ska göra dig gott, gott (verkligen göra dig gott – hebr. jatav jatav) och göra din säd som havets sand 1 Mos 22:17, vars antal inte kan räknas.’ ” I vers 10 används orden nåd och sanning. De hör oskiljaktigt ihop och presenteras alltid i samma inbördes ordning (1 Mos 24:27; Ps 40:12; Ords 3:3; Ords 16:6; Jes 16:5). Nåd utan sanning blir uddlös, medan sanning utan nåd blir obarmhärtig. Sektionen har flera upprepningar, hand i vers 11 och gott i vers 12. ");
INSERT INTO swe_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Och han höll sig där den natten, och tog av det han hade med sig en gåva till Esau, sin bror. ");
INSERT INTO swe_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 getter av honkön och 20 getter av hankön, 200 får och 20 baggar, ");
INSERT INTO swe_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 kamelston som gav di och deras föl, 40 kor och 10 unga tjurar, 20 åsneston och 10 åsneföl. ");
INSERT INTO swe_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Och han Jakob gav dem i sina tjänares hand, varje flock för sig, och han sa till sina tjänare: ”Gå över före mig och se till att hålla ett avstånd mellan flockarna.” ");
INSERT INTO swe_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Och han befallde de första de som gick längst fram och sa: ”När Esau, min bror, möter er och frågar er och säger: ’Vilka är ni och vart går ni och vems är dessa framför er?’ ");
INSERT INTO swe_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Då ska ni svara (säga): ’De är din tjänare Jakobs, det är en gåva sänd till min herre, till Esau, och se, han är även bakom oss.’ ” ");
INSERT INTO swe_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Och han befallde även den andra och den tredje och alla som följde flockarna och sa: På detta sätt ska ni tala till Esau när ni finner honom ");
INSERT INTO swe_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","och ni ska säga: ”Se, även din tjänare Jakob är bakom oss.” För han sa (tänkte): ”Jag ska blidka honom med gåvan som går framför mig och därefter ska jag se hans ansikte, måhända ska han ta emot mig.” ");
INSERT INTO swe_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gåvan gick över före honom och själv stannade han i lägret den natten. ");
INSERT INTO swe_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Samma natt steg Jakob upp och tog sina två hustrur Leah och Rakel, sina två tjänarinnor Bilhah och Zilpah och sina elva söner och gick över Jabbok vid vadstället. ");
INSERT INTO swe_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Han tog dem och förde över dem till andra sidan forsen, och sedan skickade han över alla sina ägodelar. Jabbok har tre källor: Wadi Amman (som börjar i närheten av staden Amman i Jordanien), Wadi Suwajli och Wadi al-Dhulajl. Floden rinner från öster från bergen i Gilead och mynnar ut i Jordanfloden mitt emellan Döda havet och Galileiska sjön. Själva ordet Jabbok är väldigt snarlikt det hebreiska ordet för ”kamp”. Ordagrant betyder Jabbok ”att tömma”, ”hälla ur”. ");
INSERT INTO swe_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakob var ensam kvar på den norra flodbanken. En man Gud själv i mänsklig gestalt, se vers 30 brottades med honom fram tills solen gick upp. ");
INSERT INTO swe_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","När mannen såg att han inte kunde vinna över Jakob, rörde han vid Jakobs höftled, så att höften gick ur led medan de brottades med varandra. ");
INSERT INTO swe_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sedan sa mannen: ”Låt mig gå, för solen har börjat gå upp.” Jakob svarade: ”Jag släpper dig inte om du inte välsignar mig.” ");
INSERT INTO swe_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Då svarade mannen honom: ”Vad heter du?” Han svarade: ”Jakob.” I GT reflekterar namnet personligheten. Namnet Jakob betyder: ”svindlare, en som ligger i bakhåll och attackerar”, ordagrant ”en som tar genom hälen”. Namnet står alltså för en människa som lurar och bedrar, något som har präglat Jakobs liv och nu blir uppenbart för honom. ");
INSERT INTO swe_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mannen sa: ”Du ska inte längre heta Jakob (svindlare), utan Israel, för du har stridit mot både Gud (Elohim) och människor och vunnit (överlevt).” Namnet Israel har flera betydelser: ”att kämpa mot Gud” eller ”att Gud kämpar för oss”, ”att Gud regerar” eller ”att vi regerar tillsammans med Gud”. På hebreiska är namnen Jakob och Israel helt olika förutom en bokstav som är gemensam, nämligen bokstaven jod. Detta är den minsta av alla hebreiska bokstäver och symboliserar därför ofta ödmjukhet. Detta förstärker att det enda som finns kvar av den gamle Jakob är hans ödmjukhet, han behövde bli tömd på sin egen stolthet. Jakob kämpade med Gud och i processen blev han ödmjuk. På den grunden blir han Israel, en ärlig man och en regent tillsammans med Gud som segrar! Se även Hos 12:3-4. ");
INSERT INTO swe_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Då frågade Jakob: ”Jag ber dig, berätta ditt namn för mig”. Han sa: ”Varför frågar du efter mitt namn?” Och han välsignade honom där. ");
INSERT INTO swe_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob kallade platsen Peniel betyder: ”vänd mot Gud”. Han sa: ”För jag har sett Gud (Elohim) ansikte mot ansikte, och överlevt.” En del ser mannen som Jakob brottas med som Jesus preinkarnerad, dvs. Jesus som uppenbarar sig som en Herrens ängel innan han tar mänsklig gestalt, se även 1 Mos 16:13; Dom 13:3; Hos 12:4-5; Joh 1:14. ");
INSERT INTO swe_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","När han passerat Penoel en stad vid floden Jabbok, alternativ stavning till Peniel i vers 30 såg han solen gå upp första gången det nämns på 20 år, se 1 Mos 28:11, men han haltade på grund av sin höftskada. Efter mötet med Gud vandrade Jakob annorlunda. ");
INSERT INTO swe_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Därför äter inte Israels söner höftmuskeln som är på låret till denna dag, eftersom han rörde vid Jakobs höft, vid höftmuskeln på låret. Även om Jakob fick ett nytt namn i vers 28 används hans gamla namn i vers 29 och även framöver (1 Mos 32:1, 10; 46:2). Namnbytet innebar inte att han aldrig skulle använda det namnet igen. När Simon får ett nytt namn (Petrus, se Joh 1:42) refereras det även fortsatt till hans gamla namn. (Matt 16:17). Namnändringen har att göra med innebörden av namnet, istället för att vara en som ljuger och lurar och kämpar mot Gud blir Jakob nu Israel, en som strider tillsammans med Gud. ");
INSERT INTO swe_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Och Jakob lyfte upp sina ögon och såg, och se, Esau kom och med honom 400 män. Och han delade barnen till Leah och till Rakel och till de två tjänstekvinnorna. ");
INSERT INTO swe_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Och han ställde tjänstekvinnorna och deras barn först och Leah och hennes barn efter och Rakel och Josef längst bak. ");
INSERT INTO swe_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Själv gick han över framför dem och böjde sig till marken sju gånger till dess han kom nära sin bror. Att buga sig djupt var en dåtida vanlig hedersbevisning, se 1 Mos 18:2; 19:1; 23:7, 12; 33:6, 7. Att upprepa gesten sju gånger förstärkte underkastelsen och äran som gavs. I egyptiska texter från El Amarna (1300-talet f.Kr.) avbildas vasaller som bugar sju gånger för farao. ");
INSERT INTO swe_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Men Esau sprang och mötte honom och omfamnade honom och föll honom om halsen och kysste honom och grät. ");
INSERT INTO swe_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Och han lyfte upp sina ögon och såg kvinnorna och barnen och frågade: ”Vilka är dessa som du har med dig”? Och han Jakob svarade: ”Barnen som Gud i sin nåd (oförtjänta kärlek – hebr. chanan) har gett sin tjänare.” ");
INSERT INTO swe_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Sedan kom tjänstekvinnorna nära, de och deras barn och de böjde sig ner. ");
INSERT INTO swe_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Även Leah och hennes barn kom nära och böjde sig ner, och efter kom Josef nära och Rakel och de böjde sig ner. Samma ordning som i vers 2-3. ");
INSERT INTO swe_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Sedan frågade han Esau: ”Vad menar du med den stora skara (alla de läger) som jag mött som du sänt framför dig”? Och han Jakob svarade: ”För att finna nåd (oförtjänt kärlek – hebr. chen) i dina ögon, min herre.” ");
INSERT INTO swe_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Och Esau sa: ”Jag har nog, min bror, låt det du har vara ditt.” ");
INSERT INTO swe_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Och Jakob svarade: ”Nej, jag ber dig, om jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon, ta då emot gåvorna ur min hand, för så sant som jag har sett ditt ansikte, som när någon ser Guds (Elohims) ansikte, ger du mig nåd (villkorad nåd – hebr. ratsah). ");
INSERT INTO swe_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jag ber dig (vädjar), ta emot min gåva som jag har fört till dig, eftersom Gud (Elohim) har handlat med nåd (oförtjänt kärlek – hebr. chanan) mot mig, och eftersom jag har nog.” Och han bad enträget och han tog emot den. ");
INSERT INTO swe_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Och han sa till honom: ”Låt oss fortsätta vår resa och låt oss gå och jag ska gå före dig.” ");
INSERT INTO swe_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Och han sa till honom: ”Min herre vet att barnen är späda och att flockarna och hjordarna som ger di är viktiga för mig, och om vi driver dem för hårt en dag kan hela flocken dö. ");
INSERT INTO swe_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jag ber dig, må min herre gå över före sin tjänare och jag ska vandra vidare långsamt, efter boskapens takt (tempo) och i barnens takt (tempo), till dess jag kommer till min herre i Seir.” ");
INSERT INTO swe_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Och Esau sa: ”Låt mig lämna några från mitt folk med dig.” Och han sa: ”Varför detta? Låt mig finna nåd (oförtjänt kärlek – hebr. chen) i min herres ögon.” ");
INSERT INTO swe_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Och Esau återvände den dagen på sin väg till Seir. ");
INSERT INTO swe_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Och Jakob vandrade till Sukkot öster om Jordanfloden nära Jabbok; troligtvis nuvarande Tell Deir Alla och byggde sig ett hus och gjorde stall (hebr. sukkot) till sin boskap. Därför har den platsen namnet Sukkot. Sukkot betyder hydda och motsvarar de boskapsskydd som man byggde som stall på den här tiden. Samma ord finns i lövhyddohögtiden som heter sukkot på hebreiska. ");
INSERT INTO swe_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Och Jakob vandrade vidare västerut, över Jordan och kom välbehållen (i frid) till staden Shechem i Kanaans land när han kom från Paddan-Aram 1 Mos 25:20 och slog läger framför staden. Shechem (betyder: skuldra) är nuvarande Nablus. Staden ligger i det centrala bergsområdet ca 70 kilometer norr om Jerusalem vid bergen Gerizim och Ebal. Jakob slår upp tälten framför staden, dvs. öster om den på de bördiga fälten. ");
INSERT INTO swe_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Och han köpte den biten mark som han slog upp (bokstavligt spred ut) sina tält på, från Chamors söners hand, Shechems far, för 100 silvermynt (hebr. qesitah). ");
INSERT INTO swe_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Och han reste där ett altare och kallade det El-Elohei-Israel (Gud, Israels Gud). Värdet på silvermyntet qesitah är okänt men motsvarar troligtvis en shekel, den grekiska översättningen Septuaginta översätter ordet med lamm, som såldes för en shekel, se även Jos 24:32; Job 42:11. ");
INSERT INTO swe_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Och Dina, Leahs dotter, som hon hade fött till Jakob, gick ut för att se (träffa) landets döttrar. Hon umgås med kanaaneiska ungdomar i bygden. ");
INSERT INTO swe_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Och Shechem, Chamors son, hivéen, landets furste, såg henne och han tog henne och låg med henne och förödmjukade henne. ");
INSERT INTO swe_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Och hans själ fäste sig vid Dina, Jakobs dotter, och han älskade ungmön och talade till ungmöns hjärta. ");
INSERT INTO swe_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Och Shechem talade med sin far Chamor och sa: ”Ge mig denna ungmö till hustru.” ");
INSERT INTO swe_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nu hörde Jakob att han hade skändat hans dotter Dina och hans söner var på fältet med boskapen, och Jakob teg till dess de kom. ");
INSERT INTO swe_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Och Chamor, Shechems far, gick ut till Jakob för att tala med honom. ");
INSERT INTO swe_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Och Jakobs söner kom in från fältet när de hörde det. Och männen var bedrövade och de var mycket arga eftersom han hade gjort en vidrig gärning i Israel när han låg med Jakobs dotter, något som aldrig skulle ha gjorts. ");
INSERT INTO swe_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Och Chamor talade med dem och sa: ”Min son Shechems själ längtar efter din dotter, jag ber dig, ge henne som hustru till honom. ");
INSERT INTO swe_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Och ingå äktenskap med oss, ge era döttrar till oss och ta våra döttrar till er. ");
INSERT INTO swe_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Och ni ska bo med oss och landet finns framför er (ligger öppet för er), bo och idka handel där och få era besittningar där.” ");
INSERT INTO swe_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Och Shechem sa till hennes far och till hennes bröder: ”Låt mig finna nåd (oförtjänt kärlek – hebr. chen) i era ögon, och det ni säger till mig ska jag ge. ");
INSERT INTO swe_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Be mig om mycket, en stor hemgift, och jag ska ge er vad ni säger (begär), bara ni ger mig ungmön till hustru.” ");
INSERT INTO swe_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Och Jakobs söner svarade Shechem och hans far Chamor med list och talade eftersom han hade vanhelgat deras syster Dina ");
INSERT INTO swe_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","och sa till dem: ”Vi kan inte göra detta, att ge vår syster till någon som är oomskuren, för det är en förebråelse (vanära) mot oss. ");
INSERT INTO swe_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Endast på det villkoret kan vi samtycka med er, om ni blir som vi är, att alla era män blir omskurna, ");
INSERT INTO swe_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","sedan kan vi ge våra döttrar till er och vi kan ta era döttrar till oss och vi kan bo tillsammans med er och vi kan bli ett folk. ");
INSERT INTO swe_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Men om ni inte vill lyssna till oss och omskära er, då tar vi våra döttrar och går vår väg.” ");
INSERT INTO swe_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Och deras ord var goda i Chamors ögon och i Shechems, Chamors sons, ögon. ");
INSERT INTO swe_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Och ynglingen dröjde inte med att göra detta eftersom han älskade Jakobs dotter. Och han var upphöjd över alla i sin fars hus. ");
INSERT INTO swe_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Och Chamor och hans son Shechem kom till stadens port troligtvis den östra porten och talade med stadens män och sa: ");
INSERT INTO swe_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","”Dessa män är fridsamma mot oss, låt dem därför bo i landet och idka handel där, för se, landet är stort nog för dem, låt oss ta deras döttrar åt oss som hustrur och låt oss ge dem våra döttrar. ");
INSERT INTO swe_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bara på det villkoret ska männen samtycka med oss (bo med oss), att vi blir ett folk, om varje man bland oss blir omskuren som de är omskurna. ");
INSERT INTO swe_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ska inte deras boskap och deras ägodelar bli våra? Låt oss bara samtycka med dem så att de vill leva med oss.” ");
INSERT INTO swe_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Och alla som gick ut genom stadens port lyssnade till Chamor och till hans son Shechem, och varje man blev omskuren, alla som gick ut genom stadens port. ");
INSERT INTO swe_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Och det skedde på den tredje dagen när de var i smärta, att två av Jakobs söner, Simeon och Levi, Dinas bröder, tog var man sitt svärd och kom över staden obemärkt och slog alla dess män. ");
INSERT INTO swe_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Och de slog Chamor och hans son Shechem med svärdsegg och tog ut Dina från Shechems hus, och gick vidare. ");
INSERT INTO swe_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jakobs söner kom över de slagna och ödelade staden eftersom de hade vanhelgat deras syster. ");
INSERT INTO swe_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","De tog deras flockar och deras hjordar och deras åsnor och det som fanns i staden och det som fanns på fältet, ");
INSERT INTO swe_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","och allt deras av värde, och alla deras små och deras hustrur tog de som fångar, och ödelade allt som fanns i deras hus. ");
INSERT INTO swe_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Och Jakob sa till Simeon och Levi: ”Ni har dragit olycka över mig (skapat kaos, gett mig stora bekymmer). Nu kommer kanaanéerna och perisséerna som bor i landet att hata mig (ordagrant: jag har blivit en odör/stank bland dem). Eftersom vi är få (jag är få i antal) kommer de att förena sig mot mig och slå mig, och jag blir fördärvad, jag och mitt hus.” ");
INSERT INTO swe_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Och de sa: ”Ska någon få hantera vår syster som en sköka?” ");
INSERT INTO swe_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Och Gud (Elohim) sa till Jakob. ”Stå upp och gå upp till (hebr. alah) Betel och bo där. Och gör ett altare till Gud (El) som visade sig för dig när du flydde från din bror Esaus ansikte.” Jakob lämnar nu Shechem som han bott i under omkring 10 år (1 Mos 33:18) och beger sig till Betel 3 mil söderut. Betel var den plats där Jakob omkring 30 åt tidigare fått möta Herren, se 1 Mos 28:19. Jakob ”går upp”, vilket också stämmer rent höjdmässigt då Betel ligger 350 meter högre än Shechem. ");
INSERT INTO swe_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Då sa Jakob till sitt hushåll och till alla som var med honom: ”Ta bort avgudarna som är ibland er och rena er och byt ut era kläder ");
INSERT INTO swe_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","och låt oss stå upp och gå till Betel. Där ska jag göra ett altare till Gud (El) som svarade mig den dag jag var i nöd (var trängd), och som har varit med mig på den väg jag har vandrat.” ");
INSERT INTO swe_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Och de gav Jakob alla främmande gudar som fanns i deras hand och ringarna i sina öron, och Jakob gömde dem under terebinten som fanns i Shechem. ");
INSERT INTO swe_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Och de vandrade och en gudsfruktan kom över alla städer runtomkring dem och man förföljde inte Jakobs söner. ");
INSERT INTO swe_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Och Jakob kom till Loz som är i Kanaans land, det är detsamma som Betel Betel betyder Guds hus, se även vers 15, han och folket som var med honom. ");
INSERT INTO swe_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Och han byggde där ett altare och kallade platsen El-Betel Guds ”Guds hus”, för där hade Gud uppenbarat sig för honom när han flydde från sin brors Esaus ansikte. Tillägget här av El (som betyder Gud) till platsen Betel betonar Guds närvaro på den platsen, se även 1 Mos 28:19. ");
INSERT INTO swe_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Och Deborah (hebr. Devorah), Rebeckas barnflicka, dog, och hon begravdes nedanför Betel under eken, och den fick namnet Alon-Bachot betyder: ”eken som gråter”. ");
INSERT INTO swe_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Och Gud (Elohim) visade sig för Jakob igen när han kom från Paddan-Aram och välsignade honom. ");
INSERT INTO swe_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Och Gud (Elohim) sa till honom: ”Ditt namn är Jakob, men du ska inte längre heta Jakob, utan Israel ska vara ditt namn” och han gav honom namnet Israel. ");
INSERT INTO swe_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Och Gud (Elohim) sa till honom: ”Jag är Allsmäktig Gud (El Shaddaj). Var fruktsam och föröka dig. Ett folk och flera folk ska komma från dig och kungar ska komma från din länd. Ordet för länd syftar på hela den nedre delen av kroppen, inklusive könsorganen. ");
INSERT INTO swe_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Och landet som jag gav till Abraham och Isak, det ger jag till dig, och till din säd efter dig ska jag ge landet.” ");
INSERT INTO swe_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Och Gud (Elohim) steg upp från honom på den platsen där han talat med honom. ");
INSERT INTO swe_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Och Jakob reste en pelare på platsen där han talat med honom, en stenpelare, och han hällde ut ett drickoffer på den och hällde olja på den. ");
INSERT INTO swe_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Och Jakob kallade platsen där Gud talat med honom för Betel betyder Guds hus. ");
INSERT INTO swe_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Och de vandrade från Betel och det var fortfarande ett stycke för att komma till Efratah, och Rakel födde, men hon hade en svår förlossning. ");
INSERT INTO swe_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Och det skedde när hon var i svåra födslosmärtor att barnmorskan sa till henne: ”Frukta inte, för även detta är en son till dig.” ");
INSERT INTO swe_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Och det skedde när hennes själ var på väg att lämna henne, för hon dog, att hon kallade honom Ben-Oni, men hans far kallade honom Benjamin. Ben-Oni betyder min smärtas son, Benjamin betyder min högra hands son. ");
INSERT INTO swe_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Och Rakel dog och begravdes vid vägen till Efratah, det är Betlehem. Jfr Jer 31:15 ");
INSERT INTO swe_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Och Jakob reste en pelare över hennes grav, det är Rakels gravpelare till denna dag. ");
INSERT INTO swe_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Och Jakob vandrade och spred ut sina tält till Migdal-Eder ”tornet i Edar”; ordagrant ”flockens torn”. Platsen är troligtvis mellan Betlehem och Hebron, se även Mika 4:8. ");
INSERT INTO swe_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Och det hände när Israel som tidigare hette Jakob, se 1 Mos 32:28 bodde i landet att Ruben gick och låg (hade sexuellt umgänge) med Bilhah, sin fars bihustru som hörde till den nu avlidna Rakel, och Israel hans far hörde om det. Denna vers hör tematiskt ihop med hur Dina skändas av Shechem, se 1 Mos 34:1-2. Rubens tilltag gjorde att han blev fördömd, se 1 Mos 49:4. Detta var både ett förbjudet incestförhållande (3 Mos 18:8) och ett försök att få auktoritet över sin far. Orsakerna var troligen andra än sexuell attraktion. Bilhah var Rakels tjänstekvinna, och genom att skända henne minskar Ruben risken att hon skulle ta över Rakels roll som Jakobs favorit. Troligtvis var detta dåraktiga tilltag ett försök att hjälpa sin mor Leah. Händelsen med alrunorna (”kärleksäpplena”) kan också finnas med som bakomliggande orsak, se 1 Mos 30:14-15. Ruben är omkring 5 år när han blir indragen i bråket mellan Rakel och hans mor, och Rakel tar hans fynd från åkern. Jakob hade tolv söner: ");
INSERT INTO swe_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leahs sex egna söner: Ruben, Jakobs förstfödde, och Simeon och Levi och Juda och Isaskar och Sebulon (hebr. Zevolun). ");
INSERT INTO swe_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakels två egna söner: Josef och Benjamin. ");
INSERT INTO swe_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rakels två söner via tjänstekvinnan Bilhah: Dan och Naftali. ");
INSERT INTO swe_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leahs två söner via tjänstekvinnan Zilpah: Gad och Asher. Dessa är Jakobs söner som föddes åt honom i Paddan-Aram. Generellt uttalande för majoriteten av barnen. Benjamin föddes i Kanaan, se vers 16-17. ");
INSERT INTO swe_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Och Jakob kom till Isak, sin far, i Mamre, till Kirjat-Arba, det är Hebron (hebr. Chevrón), där Abraham och Isak vistades. ");
INSERT INTO swe_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Och Isaks dagar var 180 år. ");
INSERT INTO swe_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Och Isak drog sitt sista andetag och dog, och blev samlad till sitt folk, gammal och fullkomnad (mätt, fullkomnad; ordagrant: ”sjuad” – hebr. savea) av dagar, och Esau och Jakob, hans söner, begravde honom. Uppräkningen här av de tolv sönerna följer mödrarna (Leah, Rakel, Bilhah och Zilpah) och födelseordningen hos varje moder. Josef och Benjamin är centralt placerade. Nedan är sönerna, med även inbördes födelseordning:  Leah 1. Ruben  2. Simeon  3. Levi  4. Juda  9. Isaskar 10. Sebulon  Rakel  11. Josef  12. Benjamin  Bilhah (Rakels tjänstekvinna) 5. Dan  6. Naftali  Zilpah (Leahs tjänstekvinna) 7. Gad  8. Asher  I GT finns totalt 28 uppräkningar, se även 1 Mos 49:3-28. ");
INSERT INTO swe_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Detta är Esaus fortsatta historia (hans genealogi/släkttavla – hebr. toledot), han kallas även Edom. Han fick ge namn åt landet Edom och folkslaget edomiterna, se 1 Mos 25:30. ");
INSERT INTO swe_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau tog sig tre icke-judiska fruar från Kanaans döttrar mot sin far Isaks vilja, se 1 Mos 28:1, 6: Ada dotter till Elon, hettiten, och Oholivama, Anas dotter, hivéen Tsiveons sondotter ");
INSERT INTO swe_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","och Basmat, Ismaels dotter, syster till Nevajot. ");
INSERT INTO swe_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Och Ada födde till Esau Elifaz (Elifas), och Basmat födde Reoel, ");
INSERT INTO swe_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","och Oholivama födde Jeosh och Jalam och Korach. Detta är Esaus söner som föddes till honom i Kanaans land. ");
INSERT INTO swe_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Och Esau tog sina hustrur och sina söner och sin dotter och alla personer i sitt hus, och sin boskap och alla sina djur och alla sina ägodelar som han hade samlat i Kanaans land och gick till ett land bort från sin bror Jakob. ");
INSERT INTO swe_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","För deras ägodelar var för stora för dem för att bo tillsammans, och landet där de vistades kunde inte klara dem för all deras boskap. Betet räckte inte till alla djur. ");
INSERT INTO swe_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Och Esau bodde i Seirs bergsbygd. Esau är Edom. Här kommer en ny ”toledot-enhet” som formar den elfte litterära enheten (av tolv) i Första Moseboken. ");
INSERT INTO swe_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Det här är Esaus fortsatta historia (släktträd – hebr. toledot) som stamfar till Edom i Seirs bergsbygd. ");
INSERT INTO swe_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Detta är namnen på Esaus söner: Elifaz, son till Ada, Esaus hustru, Reoel son till Basmat, Esaus hustru. ");
INSERT INTO swe_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Och Elifaz söner: Teman, Omar, Tsefo och Gatam och Kenaz. ");
INSERT INTO swe_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Och Timna var bihustru till Elifaz, Esaus son, och hon födde Amalek till Elifaz. Dessa är söner till Ada, Esaus hustru. Amalek blir stamfar till amalekiterna. Detta folk är det första som anfaller Israels söner efter att de kommit ut ur Egypten och vandrat ungefär en månad från övergången av Vasshavet. I Refidim besegrar de amalekiterna 2 Mos 17:8-16. Senare uppmanar Mose dem att inte glömma att förgöra amalekiterna utan verkligen komma ihåg detta, se 5 Mos 25:19. Därefter är det Saul som strider mot amalekiterna och är olydig, vilket gör att han inte längre får vara kung, eftersom han inte tillspilloger hela bytet och underlåter att döda deras kung. 1 Sam 15. I Esters bok är den onde Haman ättling till en amalekit. Han vill utrota alla judar men misslyckas. Amalek är också den andemakt som genom historien har stått för/representerat all slags antisemitism, dvs. en önskan att utrota judarna. Den har tagit sig många uttryck genom historien och även ersättningsteologin (som lär att judarnas roll helt ersatts av kristendomen) är en variant av antisemitismen. ");
INSERT INTO swe_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Och dessa är Reoels söner: Nachat och Zerach, Shama och Miza. Dessa är söner till Basmat, Esaus hustru. ");
INSERT INTO swe_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Och dessa är söner till Esaus hustru Oholivama, Anas dotter, och sondotter 1 Mos 36:24-25 till Tsiveon: Och hon födde till Esau Jeosh och Jalam och Korach. ");
INSERT INTO swe_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dessa är furstarna för Esaus söner, Elifaz söner, Esaus förstfödde: fursten för Teman, fursten för Omar, fursten för Tsefo, fursten för Kenaz, ");
INSERT INTO swe_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","fursten för Korach, fursten för Gatam, fursten för Amalek. Dessa är furstarna som kommer från Elifaz i Edoms land. Dessa är Adas söner. ");
INSERT INTO swe_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Och dessa är söner till Reoel, Esaus son: fursten för Nachat, fursten för Zerach, fursten för Shama, fursten för Miza. Dessa är furstarna som kommer från Reoel i Edoms land. Dessa är söner till Basmat, Esaus hustru. ");
INSERT INTO swe_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Och dessa är sönerna till Oholivama, Esaus hustru: fursten för Jeosh, fursten för Jalam, fursten för Korach. Dessa är furstarna som kommer från Oholivama, Anas dotter, Esaus hustru. ");
INSERT INTO swe_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dessa är Esaus söner, de och deras furstar, det är Edom. ");
INSERT INTO swe_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Detta var horén (ordagrant: ”grottinvånaren” – hebr. chori) Seirs söner sydöst om Döda havet i Edom, landets tidigare invånare: Lotan, Shobal, Sibon, Ana, ");
INSERT INTO swe_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Eser och Dishan. Dessa var horéernas stamfurstar, Seirs söner i Edoms land. ");
INSERT INTO swe_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotans söner var Hori och Hemam, och Lotans syster var Timna. ");
INSERT INTO swe_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobals söner var Alvan, Manahat och Ebal, Sefo och Onam. ");
INSERT INTO swe_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibons söner var Aja och Ana. Det var den Ana som fann de varma källorna i öknen när han vaktade sin far Sibons åsnor. ");
INSERT INTO swe_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anas barn var Dishon och Oholivama, Anas dotter. ");
INSERT INTO swe_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishons söner var Hemdan, Esban, Jitran och Keran. ");
INSERT INTO swe_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esers söner var Bilhan, Saavan och Akan. ");
INSERT INTO swe_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishans söner var Us (hebr. Ots) och Aran. ");
INSERT INTO swe_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horéernas (hebr. chori) stamfurstar var Lotan, Shobal, Sibon, Ana, ");
INSERT INTO swe_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Eser och Dishan. Dessa var horéernas stamfurstar i Seirs land, varje furste för sig. ");
INSERT INTO swe_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Detta är de kungar som regerade i Edoms land innan någon kung regerade över israeliterna. ");
INSERT INTO swe_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beors son Bela var kung i Edom, och hans stad hette Dinhaba. ");
INSERT INTO swe_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","När Bela dog blev Jobab, Zerachs son, från Bosra, kung efter honom. ");
INSERT INTO swe_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","När Jobab dog blev Husham från temaneernas land kung efter honom. ");
INSERT INTO swe_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","När Husham dog blev Hadad, Bedads son, kung efter honom. Det var han som slog midjaniterna på Moabs mark, och hans stad hette Avit. ");
INSERT INTO swe_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","När Hadad dog blev Samla från Masreka kung efter honom. ");
INSERT INTO swe_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","När Samla dog blev Saul från Rehobot vid floden kung efter honom. ");
INSERT INTO swe_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","När Saul dog blev Baal-Hanan, Akbors son, kung efter honom. ");
INSERT INTO swe_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","När Akbors son Baal-Hanan dog blev Chadar andra handskrifter Chadad kung efter honom. Hans stad hette Pao och hans hustru hette Mehetavel, dotter till Matred som var dotter till Me-Sahab. ");
INSERT INTO swe_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Detta är namnen på Esaus stamfurstar efter deras släkter och orter: furstarna Timna, Alva, Jetet, ");
INSERT INTO swe_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholivama, Elah, Pinon, ");
INSERT INTO swe_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibsar, ");
INSERT INTO swe_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel och Iram. Dessa var alltså Edoms furstar efter deras boplatser i landet de tog i besittning. Edom är densamme som Esau, edomiternas stamfar. ");
INSERT INTO swe_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob bodde i landet där hans fäder vandrat runt, i Kanaans land. Här kommer en ny ”toledot-enhet” som formar den tolfte och sista litterära enheten i Första Moseboken. ");
INSERT INTO swe_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Detta är Jakobs fortsatta historia (hans genealogi/släktträd – hebr. toledot). Nu följer ett nytt stycke, se 1 Mos 2:4; 5:1; 6:9; 10:1; 11:10, 27; 25:12, 19; 36:1, 9; 37:2. Detta är den tolfte och sista sektionen i Första Moseboken. Temat är Josef som också är en förebild på Jesus. Även detta stycke följer ett kiastiskt mönster:  A Brödernas hat mot Josef (1 Mos 37:3-11)   B Josef tros vara död, Jakob sörjer (1 Mos 37:12-36)    C Mellanakt: Juda och Tamar (1 Mos 38:1-26)     D Oväntade omvända roller – Perets och Zerach (1 Mos 38:27-39:23)      E Josefs vishet (1 Mos 40:1-42:38)       F Bröderna till Egypten (1 Mos 43:1-46:7)        X Israels släkttavla (1 Mos 46:8-27)       F Flytten till Egypten (1 Mos 46:28-47:12)      E Josefs vishet (1 Mos 47:13-26)     D Oväntade omvända roller – Efraim och Manasse (1 Mos 48:1-22)    C Mellanakt: Jakob välsignar sina söner (1 Mos 49:1-28)   B Jakobs död, Josef begraver honom (1 Mos 49:29-50:14)  A Josef lugnar sina bröder (1 Mos 50:15-26) Josef, hans son, som nu var 17 år – fortfarande en yngling, vallade småboskapen tillsammans med sina äldre bröder, sönerna till Bilhah Dan och Naftali, se 1 Mos 35:25 och sönerna till Zilpah Gad och Asher, se 1 Mos 35:26, hans fars fruar. Josef lämnade (kom hem med) dåliga rapporter om dem till sin far. Josef var Jakobs elfte son, Rakels förstfödda, se 1 Mos 30:24. Jakob var 108 år. Uttrycket ”en yngling” kan tolkas att han var en hjälpreda, eller så betonas att han var ung och hade ansvar över flocken. Det anas att det är komplicerade familjerelationer, att Bilhah (Rakels tjänstekvinna) och Zilpah (Leahs tjänstekvinna) nämns påminner också om rivaliteten mellan Leah och Rakel, se 1 Mos 30:3, 9. En del har sett Josef som en skvallrare, men utifrån hur hans karaktär beskrivs i övrigt verkar det snarare vara så att han är noga med detaljer och trofast i det lilla, för att så småningom bli betrodd med mycket, se Luk 16:10. I vers 13 beskrivs hur han är redo och villig att skickas ut på uppdrag av sin far. ");
INSERT INTO swe_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel älskade Josef mer än sina andra söner eftersom han var den son som han fått på sin ålderdom 91 år, med Rakel som han älskade mer än Leah, se 1 Mos 29:30, och han lät göra en speciell mantel åt honom. Ordet för ”speciell mantel” (hebr. ketonet passim) kan betyda långärmad eller mångfärgad. Troligvis hade den invävda trådar med andra färger eller mönster. Det var en vacker utsirad mantel som väckte uppmärksamhet. ");
INSERT INTO swe_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","När hans bröder såg att deras far älskade honom mer än alla hans bröder, hatade de honom och kunde inte tala vänligt med honom.  Jakobs tolv söner, från den äldste till den yngste:  1. Ruben (Leah)  2. Simeon (Leah)  3. Levi (Leah)  4. Juda (Leah)  5. Dan (Bilhah, Rakels tjänstekvinna)  6. Naftali (Bilhah, Rakels tjänstekvinna)  7. Gad (Zilpah, Leahs tjänstekvinna)  8. Asher (Zilpah, Leahs tjänstekvinna)  9. Isaskar (Leah)  10. Sebulon (Leah)  11. Josef (Rakel)  12. Benjamin (Rakel) ");
INSERT INTO swe_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Josef drömde en dröm, och han berättade den för sina bröder, och de hatade honom ännu mer. ");
INSERT INTO swe_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Han sa till dem: ”Lyssna, detta är en dröm som jag har drömt. ");
INSERT INTO swe_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Vi band kärvar på fältet och min kärve reste på sig och stod upprätt, och se, era kärvar kom och stod runt omkring och bugade sig för min kärve.” ");
INSERT INTO swe_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Hans bröder sa till honom: ”Skulle du verkligen regera över oss? Eller ska du råda över oss?” Och de hatade honom ännu mer på grund av hans drömmar och hans ord. ");
INSERT INTO swe_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Han drömde en annan dröm och återberättade (räknade upp alla detaljer i den – hebr. safar) den för sina bröder och sa: ”Se, jag har haft ännu en dröm och solen och månen och 11 stjärnor böjde sig ner inför mig.” ");
INSERT INTO swe_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Han återberättade den för sin far och sina bröder, men hans far tillrättavisade honom och sa till honom: ”Vad är denna dröm som du drömmer? Ska jag och din mor och dina bröder verkligen komma och böja oss ner på marken inför dig?” ");
INSERT INTO swe_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Hans bröder var avundsjuka på honom men hans far kom ihåg (lade på minnet) vad han hade sagt. ");
INSERT INTO swe_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Hans bröder gick iväg för att valla sin fars hjord i Shechem (Sikem). Shechem, nuvarande Nablus, ligger 11 mil norr om Hebron. En fem dagars vandring. Troligtvis är det torrt i trakten kring Hebron och Betlehem (se t.ex. Rut 1:1), så man tar flocken nordväst på framkanten av Juda bergsbygd där det är mer nederbörd och frodigare ängsmarker. ");
INSERT INTO swe_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel sa till Josef: ”Vallar inte dina bröder flocken i Shechem (Sikem)? Kom, jag ska sända dig till dem”, och han svarade: ”Här är jag.” Hebr. hineni, har betydelsen ”jag står till förfogande” eller ”jag är beredd att ta ansvar”, se 1 Mos 22:1. ");
INSERT INTO swe_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Han sa till honom: ”Gå nu och se att allt står väl till med dina bröder och att allt är väl med småboskapen. Kom sedan tillbaka och berätta för mig.” Han sände iväg honom från Hebrons dal och han kom till Shechem (Sikem). ");
INSERT INTO swe_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","En man fann honom där och såg hur han vandrade (irrade omkring) på fälten, och frågade honom: ”Vad letar du efter?” ");
INSERT INTO swe_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","”Mina bröder letar jag efter”, sa han, ”Jag ber er, berätta för mig var de vallar sin hjord.” Den hebreiska ordföljden är ”mina bröder jag söker”. Att ”mina bröder” kommer först förstärker Josefs tillit och hur han ser dem som sin familj, något som gör brödernas svek ännu större. ");
INSERT INTO swe_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mannen i Shechem sa: ”De har gått härifrån, jag hörde dem säga: Låt oss gå till Dotan.” Josef gick efter sina bröder och fann dem i Dotan. Dotan betyder ”två källor” och var en stad omkring 3 mil norr om Shechem. Staden ligger längs med handelsrutten Via Maris (som gick mellan Egypten i söder, via Damaskus till Mesopotamien i öster). Profeten Elisha bodde senare i Dotan, se 2 Kung 6:13. Det är möjligt att bröderna var kända – särskilt i trakten kring Shechem (efter händelserna med Dina, se 1 Mos 34) – eller för storleken på flocken som gjorde att de kändes igen. I judisk tradition tolkas mannen som en ängel i mänsklig form. Läsaren blir också påmind om den man som Jakob brottades med, se 1 Mos 32:24-32. ");
INSERT INTO swe_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","De Josefs bröder såg honom på långt håll över de flacka gräsfälten – och även hans mantel måste ha utmärkt Josef och innan han kom nära dem smidde de onda planer mot honom och bestämde sig för att döda honom. ");
INSERT INTO swe_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","De sa till varandra: ”Se, där kommer den där ’drömmästaren’. ");
INSERT INTO swe_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kom nu och låt oss döda honom och kasta honom i en av brunnarna, sedan säger vi att ett rovdjur slukade honom, så får vi se vad det blir av hans drömmar.” ");
INSERT INTO swe_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Men Ruben den äldste bland bröderna hörde det och räddade honom ur deras hand och sa: ”Låt oss inte ta hans liv.” ");
INSERT INTO swe_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben fortsatte: ”Spill inget blod! Kasta honom i brunnen i ödemarken (öknen), men lägg inte er hand på honom (döda honom inte).” Han sa så för att han skulle kunna rädda Josef ur deras händer och föra tillbaka honom till hans far. ");
INSERT INTO swe_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","När Josef kom till sina bröder, ryckte de av honom manteln han hade på sig, den speciella manteln den vackra mångfärgade eller långärmade manteln som Jakob gett honom, se vers 3. ");
INSERT INTO swe_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Och de grep honom och kastade honom i en brunn, brunnen var tom, det var inget vatten i den. ");
INSERT INTO swe_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sedan satte de sig ner och åt. En måltid mättar inte bara magen, den fyller en viktig social funktion. Här blir hårdheten i brödernas hjärtan uppenbar. Josef saknade mat och vatten och de hörde hans rop, se 1 Mos 42:21. Samtidigt dukar de upp och äter alldeles intill. Drygt 20 år senare kommer dock situationen bli omvänd, då är Josef den som föder bröderna, se 1 Mos 42:3, 6. När de lyfte upp sina ögon och tittade, fick de se en karavan med ismaeliter komma från Gilead med sina kameler som bar på kryddor och balsam och myrra, som de skulle gå med till Egypten. ");
INSERT INTO swe_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda sa till sina bröder: ”Vilken vinning har vi av att döda vår bror och dölja hans blod? ");
INSERT INTO swe_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kom, så säljer vi honom till ismaeliterna och låter inte vår hand komma vid honom, han är ju trots allt vår bror, vårt kött.” Hans bröder lyssnade på honom. ");
INSERT INTO swe_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","När de midjanitiska köpmännen vers 25 gick förbi, drog de bröderna upp Josef från brunnen och sålde Josef till ismaeliterna för 20 shekel silver. Priset för en ung manlig slav var 20 silver shekel, se 3 Mos 27:5. Priset finns även dokumenterat i Hammurabis lagar, se §116, §214 och §252. Och de tog Josef till Egypten. Den ovanliga trefaldiga upprepningen av Josefs namn i denna vers ”drog upp Josef ... sålde Josef ... tog Josef” betonar och indikerar att händelsen är viktig för fortsättningen av berättelsen. Karavanen bestod troligtvis av både ismaeliter och midjaniter, se 1 Mos 17:20; 37:25, 27, 36; 39:1; Dom 8:24. Här finns också en historisk konflikt som går flera generationer tillbaka. Ismaeliterna var ättlingar till Ismael, som Abraham fick med den egyptiska Hagar omkring 180 år tidigare, se 1 Mos 21:21. Midjaniterna var också ättlingar till Abraham från hans äktenskap med Keturah och deras son Midjan, se 1 Mos 25:1-4 ");
INSERT INTO swe_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben återvände till brunnen men Josef var inte i brunnen och han rev sönder sina kläder för att visa sin sorg och upprördhet. ");
INSERT INTO swe_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Han återvände till sina bröder och sa: ”Barnet finns inte mer... och jag... vart ska jag ta vägen?” Det hebreiska ordet för barn är jeled som beskriver ett litet barn. Även om Josef var 17 år (1 Mos 37:2), så ser Ruben honom som sin skyddsling. Vi anar desperationen och villrådigheten hos Ruben, vad ska han ta sig till, ska han försöka leta efter Josef eller fly från sin far. ");
INSERT INTO swe_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","De tog Josefs mantel och dödade en bock och doppade manteln i blodet. ");
INSERT INTO swe_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","De skickade iväg den speciella manteln och tog den till deras far och sa: ”Vi har funnit denna. Vet du om det är din sons mantel eller inte?” ");
INSERT INTO swe_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Han kände igen den och sa: ”Det är min sons mantel, ett vilddjur har slukat honom. Josef är utan tvekan sliten i stycken.” ");
INSERT INTO swe_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakob rev sönder sina kläder och satte säcktyg på sina höfter och sörjde Josef i många dagar. ");
INSERT INTO swe_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Alla hans söner och hans döttrar steg upp för att trösta honom, men han lät sig inte tröstas och han sa: ”Jag ska gå ner till Sheol (graven, underjorden – de dödas plats), till min son och sörja.” Och hans far grät över honom. ");
INSERT INTO swe_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Samtidigt var Josef vid liv. Midjaniterna sålde honom i Egypten till Potifar, en av faraos generaler, chefen över livvakten. ");
INSERT INTO swe_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Vid den tiden gick Juda ner rent höjdmässigt, men även moraliskt från sina bröder i Hebron, se 1 Mos 37:14 och vände sig till (slog ner sitt tält vid) en viss adullamit som hette Chira som betyder ”ädel”. Ner till Adullam, som ligger 2 mil nordväst om Hebron, är det en höjdskillnad på över 500 meter. ");
INSERT INTO swe_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Där fick Juda se dottern till en kanaaneisk man som hette Shoa betyder ”rikedom”, han tog henne och gick in till (hade sexuellt umgänge med) henne. På liknande sätt som Esau, 1 Mos 26:34, lämnade Juda föreskrifterna och tog en hustru från en kanaaneisk familj, se 5 Mos 7:3-4; 1 Kung 11:1-2. ");
INSERT INTO swe_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Hon blev gravid och födde en son och han gav honom namnet Er. Er betyder ”vaken”, antagligen var det ett barn som inte sov så mycket! ");
INSERT INTO swe_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Hon blev gravid igen och födde en son och hon gav honom namnet Onan Uttalas ”Ånan” och betyder ”stark”. ");
INSERT INTO swe_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ännu en gång födde hon en son och gav honom namnet Shela kan anspela på att sonen var efterfrågad i bön. Han Juda var i Cheziv när hon födde honom. Cheziv, kommer från verbet kazav (ljuga, tala osanning), det var en stad i Judeen, troligen ett annat namn för Achzib/Chezeva, se Jos 15:44; Mika 1:14-15; 1 Krön 4:22. Staden ligger 1 timmes vandring norr om Adullam, se vers 1. Intressant att Juda är borta i en stad som heter ”falsk”, när den tredje sonen föds. Läsaren anar att familjeförhållandena inte är de bästa, de två äldsta sönerna växer upp och blir onda i Herrens ögon, se vers 6, 10. ");
INSERT INTO swe_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda tog en hustru till Er, sin förstfödde, och hennes namn var Tamar. ");
INSERT INTO swe_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Men Er, Judas förstfödde, var ond i Herrens (Jahvehs) ögon och Herren (Jahveh) dödade honom. ");
INSERT INTO swe_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Då sa Juda till Onan (hebr. Ónan): ”Gå in till din brors hustru och utför din plikt som hennes äkta mans bror och se till att din bror får avkomlingar (barn; ordagrant säd).” ");
INSERT INTO swe_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Men Onan (hebr. Ónan) visste att säden (barnet) inte skulle bli hans, när han därför gick in till sin brors hustru spillde han sädesvätskan på marken, så att han inte skulle ge avkomma till sin bror. ");
INSERT INTO swe_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Detta som han gjorde var ont i Herrens (Jahvehs) ögon och han dödade honom också. Här ser vi Bibelns första exempel på leviratäktenskap, se 5 Mos 25:5-10; Rut 2:20; 4:7-12; Matt 22:24. ");
INSERT INTO swe_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Efter detta sa Juda till sin svärdotter Tamar: ”Förbli änka i din fars hus till dess min son Shela har vuxit upp.” Han sa (tänkte för sig själv): Annars dör han också, som sina bröder. Och Tamar gick iväg och bodde i sin fars hus. ");
INSERT INTO swe_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Efter en tid (många dagar) dog Shoas dotter, Judas hustru. Juda blev tröstad och gick upp till sina fårskötare i Timnah, han och hans vän adullamiten Chira. ");
INSERT INTO swe_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Detta berättades för Tamar: ”Se din svärfar går upp till Timnah för att klippa sina får.” Timnah, nuvarande Tell Batash, var en stad i Juda, 2 mil nordväst om Adullam och 7 km norr om Beit-Shemesh. Det var en gränsstad för Juda stams område, se Jos 15:10. Det är här Simson så småningom tar en av filistéernas döttrar som fru, se Dom 14:1. ");
INSERT INTO swe_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Och hon tog av sig sina änkekläder. Och hon täckte sig med en slöja. Ja, hon svepte in sig gjorde så att hon inte kunde bli igenkänd. Och hon satte sig invid porten till Einaim som ligger längs vägen till Timnah, eftersom anledningen att Tamar gjorde detta var att hon hade insett att Shela hade vuxit upp, men hon hade inte blivit given till honom som hustru. Einaim betyder källorna. Kanske samma stad som benämns Enam i Jos 15:34 ");
INSERT INTO swe_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","När Juda såg henne tänkte han att hon var en tempelsköka eftersom hon hade täckt sitt ansikte. ");
INSERT INTO swe_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Han vände sig till henne vid vägen och sa: ”Kom, låt mig komma in till dig”, för han visste inte att hon var hans svärdotter. Hon svarade: ”Vad ska du ge mig för att du får komma in till mig?” ");
INSERT INTO swe_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Han sa: ”Jag ska skicka en killing från flocken”. Hon svarade: ”Vill du ge mig en pant till dess du sänder den?” ");
INSERT INTO swe_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Han sa: ”Vilken pant ska jag ge dig?” Hon svarade: ”Ditt sigill med Judas personliga stämpel och din snodd det flätade lädersnöret sigillet hängde i och staven som du håller i din hand.” Han gav dem till henne och kom in till (hade sexuellt umgänge med) henne och hon blev gravid genom honom. ");
INSERT INTO swe_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Hon steg upp och gick sin väg och tog av sig sin slöja och satte på sig sina änkekläder. ");
INSERT INTO swe_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda skickade killingen med sin vän adullamiten för att få tillbaka panten från kvinnans hand, men han fann henne inte. ");
INSERT INTO swe_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Då frågade han männen efter hennes plats och sa: ”Var är tempelskökan som satt vid vägkanten i Einaim stad i Låglandet (hebr. Shefelah), mellan Hebron och Timnah?” De svarade: ”Det har inte funnits någon tempelsköka här.” ");
INSERT INTO swe_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Han återvände till Juda och sa: ”Jag har inte hittat henne och även männen på platsen säger att det inte har varit någon tempelsköka där.” ");
INSERT INTO swe_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda svarade: ”Låt henne behålla det, annars blir vi utskämda, se, jag skickade denna killing och du har inte hittat henne.” ");
INSERT INTO swe_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Det hände ungefär tre månader senare att man berättade för Juda och sa: ”Tamar, din svärdotter har varit tempelsköka och nu har hon dessutom blivit gravid, hon är med barn genom prostitution.” Juda sa: ”Ta hit henne och låt henne brännas.” ");
INSERT INTO swe_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","När hon fördes fram lät hon säga till sin svärfar: ”Genom den man som dessa ting tillhör är jag gravid.” Hon sa vidare: ”Avgör vem som är ägare till sigillet och snodden plural – de flätade läderremmarna som sigillet var fäst i och staven.” 1 Mos 38:18 ");
INSERT INTO swe_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda kände igen dem och sa: ”Hon är mer rättfärdig än jag, eftersom jag inte gav henne min son Shela.” Han träffade henne inte mer (hade inget sexuellt umgänge med henne). ");
INSERT INTO swe_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","När tiden var inne för förlossning visade det sig att det fanns tvillingar i hennes livmoder. ");
INSERT INTO swe_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Och det kom sig att den ene stack ut sin hand och barnmorskan tog en röd tråd och band om handleden och sa: ”Denne kom ut först.” ");
INSERT INTO swe_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Men han drog tillbaka sin hand och hans bror kom ut och hon sa: ”Varför har du brutit dig fram (hebr. parats)?” Därför fick han namnet Perets. Namnet betyder brytning eller att rämna och det är samma ord som används i frågan ”Varför har du brutit dig fram?” ");
INSERT INTO swe_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Efter kom hans bror som hade den röda tråden runt sin handled. Han fick namnet Zerach (Sera). I detta kapitel finns namnen Boaz, Rut, Oved, Jishaj och David inkodade i vers 11-28 med 49 bokstävers mellanrum. De fem namn som leder upp till David i släkttavlan i avslutningen i Ruts bok, se Rut 4:21-22, återfinns alltså i exakt rätt ordning med 7 x 7 bokstävers intervall i just detta stycke som handlar om Perets, fem släktled före Boaz. Man måste vara lite försiktig med bibelkoder, men det är ändå ett märkligt sammanträffande som pekar på att Bibeln är en gudomligt inspirerad bok. ");
INSERT INTO swe_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josef fördes ner till Egypten och Potifar namnet betyder ”tillhör solen” eller ”hängiven solen”, en av faraos generaler, chefen över livvakten, en egyptier köpte honom från ismaeliternas hand, de som hade fört honom dit ner. ");
INSERT INTO swe_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Herren (Jahveh) var med Josef frasen återkommer tre gånger till, se vers 3, 21, 23 och han var en framgångsrik man. Han var i sin herres hus, egyptiern. ");
INSERT INTO swe_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Hans herre Potifar såg att Herren (Jahveh) var med honom och att Herren (Jahveh) lät allt han gjorde lyckas väl i hans hand. ");
INSERT INTO swe_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josef fann nåd (oförtjänt kärlek; favör) i hans ögon och blev hans personlige tjänare. En position som finns väl dokumenterad i egyptisk litteratur. Potifar utsåg Josef till arbetsledare (tillsyningsman) över sitt hus och allt som tillhörde honom gav han i hans hand att ansvara över. ");
INSERT INTO swe_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Från den tiden då Potifar utsåg Josef till arbetsledare i sitt hus och över allt han ägde, lät Herren (Jahveh) egyptierns hus bli välsignat på grund av Josef. Herrens välsignelse vilade över allt han ägde, i huset och på fältet. ");
INSERT INTO swe_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Så Potifar betrodde allt han ägde i Josefs hand (vård, förvaltarskap) och gjorde sig inget bekymmer om något (han litade helt på Josef), förutom valet av maten han åt. Josef hade en välskapt kropp och såg bra ut. Samma uttryck används om hans mor Rakel, se 1 Mos 29:17. ");
INSERT INTO swe_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Det hände efter en tid att hans herres Potifars hustru kastade sina blickar på Josef och sa: ”Ligg med mig!” ");
INSERT INTO swe_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Men Josef vägrade och sa till sin herres hustru: ”Se, min herre som äger mig vet inte ens vad som finns i hans hus har inte koll på alla småsaker, han har gett allt som tillhör honom i min hand (låter mig förvalta allting). ");
INSERT INTO swe_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Han är inte större i detta hus än vad jag är, inte heller har han undanhållit mig något förutom dig, eftersom du är hans hustru. Hur skulle jag då kunna göra denna stora ondska och synda mot Gud (Elohim)?” Josef argumenterar i flera punkter: Det skulle vara ett missbruk av förtroende, ett svek mot Potifar, något ondskefullt och även en synd mot Gud. Se även 2 Mos 20:14; Ords 5-7; Gal 5:23. ");
INSERT INTO swe_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Även om hon fortsatte att tala till Josef dag efter dag, lyssnade han inte på henne eller ville ligga hos henne eller ens vara (vistas i samma rum; umgås) med henne. ");
INSERT INTO swe_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","En dag hände det när han gick in i huset för att uträtta sina sysslor att ingen av de personer som brukade vara i huset var där inne. ");
INSERT INTO swe_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Då tog hon tag i hans mantel och sa: ”Ligg med mig!” Men han lämnade sin mantel i hennes hand, flydde och tog sig ut ur huset. ");
INSERT INTO swe_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","När hon såg att han hade lämnat manteln i hennes hand och flytt undan, ");
INSERT INTO swe_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ropade hon på männen i huset och talade med dem och sa: ”Se, han min man har fört in en hebré för att förnedra oss (göra oss till åtlöje). Han försökte våldta mig, men då ropade jag för full hals. ");
INSERT INTO swe_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","När han hörde att jag höjde min röst och ropade för full hals, då lämnade han sin mantel hos mig, flydde och tog sig ut.” Ibland är flykt ett tecken på svaghet, andra gånger mod. Josef förlorade sin mantel, men behöll sin integritet. ");
INSERT INTO swe_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hon lade hans mantel bredvid sig till dess att hennes herre kom hem. ");
INSERT INTO swe_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sedan talade (berättade) hon samma sak till honom: ”Den hebreiske tjänaren som du tog hit kom in till mig och ville förnedra mig (roa sig med mig). ");
INSERT INTO swe_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","När jag höjde min röst och ropade för full hals, då lämnade han sin mantel hos mig, flydde och tog sig ut.” ");
INSERT INTO swe_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","När hans herre hörde sin hustrus ord som hon talade till honom när hon sa: ”Detta gjorde din tjänare mot mig”, då upptändes hans vrede. ");
INSERT INTO swe_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Josefs herre Potifar tog honom och satte honom i fängelset, platsen där kungens fångar hölls bundna. Han var nu där i fängelset. Det är inte tydligt vem Potifar blir arg på. Kanske kände han till sin frus sätt. Enligt Yalkut Shimoni, en medeltida rabbin, gjorde Potifars dotter Asenat allt hon kunde för att upprätta och fria Josef från anklagelserna. När Josef senare blir fri från fängelset gifter han sig med Asenat som är Potifars dotter, se 1 Mos 41:45. Tiden i fängelse var en prövning för Josef, den beskrivs i Ps 105:17-19 Berättelsen om Josef är fylld med cykliska mönster och upprepningar: Han har två drömmar (kap 37), han tyder två drömmar (kap 40), hans bröder gör två resor för att se honom (kap 42-43), och här är han oskyldigt fängslad en andra gång. ");
INSERT INTO swe_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Men Herren (Jahveh) var med Josef och visade honom nåd (omsorgsfull kärlek, trofasthet – hebr. chesed) och gav honom nåd (favör, oförtjänt kärlek – hebr. chen) i fängelsechefens ögon. ");
INSERT INTO swe_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Fängelsechefen satte Josef till att ansvara för alla fångarna (han gav dem i Josefs hand) och allt som gjordes där, det gjordes beslutades, administrerades genom honom. ");
INSERT INTO swe_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Fängelsechefen tittade inte på (gjorde sig ingen oro för) något som var i hans (Josefs) hand, eftersom Herren (Jahveh) var med honom och allt som han Josef gjorde lät Herren (Jahveh) lyckas väl. ");
INSERT INTO swe_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Efter en tid hände det sig att munskänken till kungen i Egypten och hans bagare förolämpade sin herre, Egyptens kung. Deras brott nämns inte. Enligt judisk tradition var orsaken att en fluga fallit ner i faraos vin och en sten råkat hamna i hans bröd. Andra judiska kommentarer föreslår att de försökt förgifta farao. ");
INSERT INTO swe_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao var vred mot sina två förmän – mot förmannen över munskänkarna och förmannen över bagarna. ");
INSERT INTO swe_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Han satte dem i förvar i generalens hus, chefen över livvakten, i fängelset, platsen där Josef var bunden. ");
INSERT INTO swe_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Chefen över livvakten befallde Josef att vara med dem och han betjänade dem. Dagarna gick och de förblev i fängelset. Dagar kan syfta på några veckor upp till ett år. ");
INSERT INTO swe_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","En (och samma) natt hade både den egyptiske kungens munskänk och hans bagare – som båda satt fängslade – var sin dröm. Var och en med sin egen uttydning (betydelse). ");
INSERT INTO swe_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Josef kom till dem på morgonen och såg dem, och de såg bekymrade ut. ");
INSERT INTO swe_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Han frågade faraos förmän som var med honom i fängelset i hans herres hus: ”Varför ser ni så bekymrade ut idag?” ");
INSERT INTO swe_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","De sa till honom: ”Vi har drömt en dröm och det finns ingen som kan tolka den.” Josef sa till dem: ”Tillhör inte uttydningen Gud (Elohim)? Återberätta den (drömmen) för mig.” ");
INSERT INTO swe_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Munskänkarnas förman återberättade sin dröm för Josef och sa till honom: ”I min dröm såg jag en vinstock framför mig, ");
INSERT INTO swe_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","och i vinstocken var tre kvistar och på dem sköt knoppar fram, och dess klasar bar fram (mogna) druvor för skörd, ");
INSERT INTO swe_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","och faraos bägare var i min hand och jag tog druvorna och pressade dem i faraos bägare och jag gav bägaren till faraos hand.” ");
INSERT INTO swe_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef sa till honom: ”Detta är uttydningen, de tre grenarna är tre dagar. ");
INSERT INTO swe_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Om tre dagar ska farao lyfta upp ditt huvud och upprätta dig till din ställning (tjänst – hebr. ken; samma ord som översätts ”fundament” i 2 Mos 30:18), du ska ge farao bägaren i hans hand så som du tidigare gjort, när du var hans munskänk. ");
INSERT INTO swe_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Men kom ihåg mig när det går väl för dig, och visa mig nåd (omsorgsfull kärlek, trofasthet – hebr. chesed) och berätta om mig för farao och för mig ut ur detta hus. ");
INSERT INTO swe_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","För jag har verkligen blivit (oskyldigt) bortrövad från hebréernas land och inte heller här har jag gjort något som förtjänar att jag har hamnat i fängelsehålan.” Josef kände sig bortglömd. Han blev en slav som 17-åring, oskyldigt anklagad och kastad i fängelse. Först när han är 30 år blir han fri – 13 år är en lång tid! Människor kan glömma, men Gud glömmer inte Jer 29:11-13. ");
INSERT INTO swe_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","När bagarnas förman såg att uttydningen var god, sa han till Josef: ”Jag hade också en dröm, och i den såg jag tre korgar med bröd som var på mitt huvud. ");
INSERT INTO swe_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I den översta korgen fanns alla sorters bakat bröd för farao men fåglarna åt upp det i korgen på mitt huvud.” ");
INSERT INTO swe_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef svarade och sa: ”Detta är uttydningen, de tre korgarna är tre dagar. ");
INSERT INTO swe_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Om tre dagar ska farao lyfta upp (ta av) ditt huvud från dig, han ska hänga upp dig på trä och fåglarna ska äta upp allt ditt kött från din kropp.” ");
INSERT INTO swe_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tre dagar senare, på faraos födelsedag, ställde han till fest för alla sina tjänare. Han ”lyfte upp huvudet på” upphöjde sin förman över munskänkarna återinsatte honom i tjänst, se vers 13 och ”lyfte upp huvudet på” halshögg sin förman över bagarna. ");
INSERT INTO swe_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Han återinsatte förmannen för munskänkarna i hans ämbete och han gav bägaren till faraos hand. ");
INSERT INTO swe_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Men han hängde upp förmannen för bagarna på trä – dödade honom, i enlighet med det som Josef uttytt för dem. 1 Mos 40:19 ");
INSERT INTO swe_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Men förmannen för munskänkarna kom inte ihåg Josef utan glömde bort honom. ");
INSERT INTO swe_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","När två hela år hade gått sedan munskänken blivit återinsatt i sin tjänst hade farao en dröm. Han drömde att han stod vid Nilen (hebr. jeor). Ordet används generellt om flod/kanal, men också specifikt för Nilen. ");
INSERT INTO swe_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Se, sju kor kom upp ur floden, välgödda och feta, och de åt av sjögräset. ");
INSERT INTO swe_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Sju andra kor kom upp efter dem från floden, de var klena och utmärglade och stod bredvid de andra korna på flodstranden. ");
INSERT INTO swe_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","De klena och utmärglade korna åt upp de välgödda och feta korna. Sedan vaknade farao. ");
INSERT INTO swe_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Han sov och drömde en andra gång. Se, sju stjälkar med säd sköt upp, frodiga och välmatade. ");
INSERT INTO swe_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Efter dem kom sju stjälkar som var tunna och tomma, pinade av östanvinden, och sprang efter dem. ");
INSERT INTO swe_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","De sju tunna och tomma slukade de sju frodiga och välmatade. Farao vaknade och förstod att det var en dröm. Det var en skrämmande dröm. ");
INSERT INTO swe_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","På morgonen var han orolig i sitt inre och sände efter och kallade på Egyptens spåmän (skrivare, från ordet för penna) och alla visa män. Farao återgav sin dröm men det fanns ingen som kunde uttyda den för farao. ");
INSERT INTO swe_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Förmannen till munskänkarna hörde om drömmarna och kom ihåg Josef. Då talade förmannen för munskänkarna till farao och sa: ”Jag kommer ihåg mina synder idag. ");
INSERT INTO swe_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao var vred på sin tjänare och satte mig i fängelse i generalens hus, chefen över livvakten, mig och förmannen för bagarna. ");
INSERT INTO swe_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Vi båda drömde en dröm samma natt, men drömmarna hade olika betydelser. ");
INSERT INTO swe_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Med oss var en ung man, en hebré, tjänare hos chefen över livvakten 1 Mos 37:36. När vi återgav våra drömmar för honom, tydde han dem. Han gav oss var sin uttydning. ");
INSERT INTO swe_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Det skedde precis som han sagt till oss – jag blev återinsatt i mitt ämbete (ställning) av farao, se 1 Mos 40:13, men den andre bagaren blev upphängd på trä, se 1 Mos 40:19.” ");
INSERT INTO swe_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Då skickade farao efter och kallade på Josef och de skyndade sig att hämta honom från fängelsehålan. Han rakade sig och bytte kläder och kom inför farao. ");
INSERT INTO swe_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao sa till Josef: ”Jag har drömt en dröm och det finns ingen som kan uttyda den för mig. Jag har hört sägas om dig att när du hör en dröm kan du uttyda den.” ");
INSERT INTO swe_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef svarade farao och sa: ”Det är inte i min egen kraft, men Gud ska ge farao ett fridsamt (shalom) svar (ett lugnande svar).” ");
INSERT INTO swe_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farao talade till Josef: ______ ”I min dröm stod jag på stranden till Nilen. ");
INSERT INTO swe_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Se, sju kor kom upp ur floden, välgödda och feta, och de åt av sjögräset. ");
INSERT INTO swe_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sju andra kor kom upp efter dem, de var klena och utmärglade, något så anskrämligt har jag aldrig sett i Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","De klena och utmärglade korna åt upp de sju första välgödda och feta korna. ");
INSERT INTO swe_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","När de hade ätit upp dem kunde man inte förstå att de hade ätit dem, de var fortfarande lika klena och utmärglade som från början. Sedan vaknade jag. ");
INSERT INTO swe_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Jag såg i min dröm sju stjälkar med säd skjuta upp, frodiga och välmatade. ");
INSERT INTO swe_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Och se, sju stjälkar som var tunna och tomma och pinade av östanvinden sprang efter dem. ");
INSERT INTO swe_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","De tunna och tomma slukade de sju frodiga och välmatade stjälkarna. ______ Jag berättade för mina spåmän (skrivare, från ordet för penna) men det var ingen som kunde ge mig en förklaring.” ");
INSERT INTO swe_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Josef sa till farao: ”Faraos dröm är en. De två drömmarna hör ihop. Gud (Elohim) har berättat uppenbarat profetiskt för farao vad han ska göra. ");
INSERT INTO swe_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De sju välgödda och feta korna är sju år och de sju frodiga och välmatade stjälkarna är sju år. Drömmen är en (och densamma). ");
INSERT INTO swe_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","De sju klena och utmärglade korna som kom upp efter dem är sju år och även de sju stjälkarna som var tunna och tomma och pinade av östanvinden, det är sju år av hungersnöd. ");
INSERT INTO swe_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Detta är de ting jag talar med farao om, det som Gud är på gång att göra har han visat för farao. ");
INSERT INTO swe_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Se, det kommer sju år som ska ge riklig (god, överflödande) avkastning i Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Efter dem ska det komma sju år av hungersnöd och överflödet ska glömmas bort i Egyptens land och hungersnöden ska (istället) förtära landet. ");
INSERT INTO swe_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","På grund av hungersnöden som kommer efter, ska man inte komma ihåg (ordagrant inte veta om) överflödet, eftersom hungersnöden ska bli så fruktansvärd. ");
INSERT INTO swe_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Av den anledningen fick farao två drömmar, eftersom dessa ting är fastställda (beslutade) av Gud (Elohim) och Gud ska snart låta det ske.” ");
INSERT INTO swe_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Josef fortsatte: ”Därför bör farao nu utse en förståndig och vis person och sätta honom över Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Låt farao göra detta och låt honom utse tillsyningsmän över landet. Samla in en femtedel spara 20% från Egyptens land under de sju överflödande åren (då det blir stora skördar). ");
INSERT INTO swe_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Låt dem samla all mat som skördas under de överflödande åren som kommer och lagra upp säden i faraos hand i faraos lador till mat i städerna och låt dem bevara (ta väl hand om) den. ");
INSERT INTO swe_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Maten ska lagras i landet för de sju åren av hungersnöd, som ska komma i Egyptens land, så att landet inte går under genom hungersnöden.” ");
INSERT INTO swe_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Detta (förslag) syntes gott i faraos ögon och i hans tjänares ögon. ");
INSERT INTO swe_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farao sa till sina tjänare: ”Kan vi finna en man som denna, en man som har Guds (Elohims) Ande i sig?” ");
INSERT INTO swe_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farao sa till Josef: ”Eftersom Gud (Elohim) har visat dig allt detta, finns det ingen lika förståndig och vis person som du. ");
INSERT INTO swe_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du ska råda över mitt hus och i enlighet med dina ord ska allt mitt folk regeras, bara tronen ska vara större än du.” Josef blir befordrad till den högste ämbetsmannen i Egypten, bara farao själv är högre i rang. Ordagrant: ”din mun ska allt mitt folk kyssa”, jfr Ps 2:11-12. ");
INSERT INTO swe_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Vidare sa farao till Josef: ”Se jag har satt dig över hela Egyptens land.” ");
INSERT INTO swe_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao tog sin signetring från sin hand och satte den på Josefs hand och klädde honom i praktfulla dräkter av fint linne och satte en guldkedja runt hans hals. Istället för fängelsekläder får Josef fina linnekläder. Två gånger hade han förlorat sin mantel, nu får han en ny. Istället för fängelsets järnkedjor (Ps 105:18) får han nu kedjor av guld! ");
INSERT INTO swe_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Han lät honom åka i den andra vagnen (vagnen bakom faraos egen vagn) som han hade och de ropade framför honom: ”Avrech knäböj!” Och han satte honom över hela Egyptens land. Ordet avrech är troligtvis ett egyptiskt ord som är en uppmaning att böja knä, ett sätt att visa respekt som i Egypten främst gällde vördnad för gudarna. Farao betraktades som en gud och genom att visa samma respekt för Josef upphöjs även han till en gudomlig status. ");
INSERT INTO swe_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao sa till Josef: ”Jag är farao och utan din tillåtelse ska ingen man lyfta upp sin hand eller sin fot i hela Egyptens land.” ");
INSERT INTO swe_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao gav Josef namnet Tsofnat-paneach som betyder ”uppenbarare av hemligheter”, och till hustru gav han honom prästen Potiferas dotter Asenat från On. Och Josef vandrade ut över Egyptens land. Potiferas är en längre form av namnet Potifar. De tidigaste rabbinska traditionerna (Rashi, Rashbam och Alshish) säger att det var samma Potifar (1 Mos 39:4, 20) som fängslade Josef och som var general, se 1 Mos 39:1. ");
INSERT INTO swe_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef var 30 år gammal när han stod inför farao, kungen i Egypten. Josef gick ut från faraos ansikte och vandrade runt i inspekterade hela Egyptens land. Det finns flera paralleller mellan Josef och Jesus. Josef fick en brud samtidigt som han fortfarande var förkastad av sina egna bröder. Den kristna kyrkan har sedan slutet på Apostlagärningarnas tid bestått mest av hedningar, se Rom 11:25. Jesus var också 30 år när han började sin publika tjänst, se Luk 3:23 ");
INSERT INTO swe_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Under de sju överflödande åren gav marken sin gröda i stora mängder. ");
INSERT INTO swe_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Han samlade upp all mat under de sju åren som var i Egyptens land och lagrade maten i städerna nära där människorna bodde. Markens mat som fanns runtomkring varje stad samlade han strategiskt in i den staden. ");
INSERT INTO swe_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josef lagrade säd som havets sand, enorma mängder, tills det inte längre var möjligt att hålla räkning på (bokföra) allting för det var så stora mängder (bokstavligt utan siffror, omöjligt att räkna). En del språkvetare tror att Josef uppfann det första alfabetet, i syfte att förenkla bokföring över alla grödor som skulle förvaras. Fram till den här tiden användes skriftspråk i form av hieroglyfer, vilket Josef säkerligen fick lära sig när han togs i tjänst hos farao. Men om det är så att Josef istället uppfann alfabetet så var det detta som Mose fick lära sig under sina år i faraos palats, så att han sedan hade ett skriftspråk med alfabetets bokstäver när han under ökenvandringen skrev ner de fem Moseböckerna. ");
INSERT INTO swe_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Till Josef föddes två söner innan hungeråren kom, som Asenat, dotter till Potifera, prästen i On, födde åt honom. ");
INSERT INTO swe_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef gav sin förstfödda namnet Manasse (hebr. Menasheh): ”För Gud har fått mig att glömma (hebr. nashah) min träldom och min fars hus.” Namnet Manasse betyder ”få att glömma”. ");
INSERT INTO swe_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den andra gav han namnet Efraim: ”För Gud har gjort mig fruktsam i mina bedrövelsers land.” Namnet Efraim betyder ”dubbel frukt”. Guds ordning är först Manasse, sedan Efraim. Först måste vi ”glömma” och komma över det som varit, förräderiet, de falska anklagelserna, fängelset och den orättfärdiga behandlingen innan vi kan bära frukt. Istället för att söka hämnd, måste vi förlåta våra bröder och föda ”Manasse”, se Fil 4:8. ");
INSERT INTO swe_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","De sju överflödande åren som var i Egyptens land tog slut, ");
INSERT INTO swe_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","och de sju hungeråren började, precis som Josef hade sagt. Det var hungersnöd i alla länder (runt hela Medelhavet och även söderut i Afrika) men i Egypten fanns det bröd. ");
INSERT INTO swe_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","När hela Egypten svalt, ropade folket till farao efter bröd, och farao sa till alla egyptier: ”Gå till Josef och det han säger till er, gör det.” ");
INSERT INTO swe_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Hungersnöden var över hela jorden. Men Josef öppnade upp alla förrådshus och sålde till egyptierna. Hungersnöden var svår i Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Hela världen kom till Egypten, till Josef, för att köpa säd eftersom hungersnöden var svår i hela världen. ");
INSERT INTO swe_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","När nu Jakob såg (förstod) att det faktiskt fanns säd i Egypten, sa Jakob till sina söner: ”Varför ser ni på varandra?” Trots att Jakob var på väg att bli blind, se 1 Mos 48:8, hade han en klarhet att se vad som skulle göras. Brödernas oförmåga att se och agera står i skarp kontrast till Josef som både förutsåg hungersnöden och förberedde. ");
INSERT INTO swe_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Han sa: ”Se, jag har hört att det finns säd i Egypten. Gå ner dit och köp därifrån åt oss, så att vi kan leva och inte dö av hungersnöd.” ");
INSERT INTO swe_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Josefs tio bröder halvbröder gick då ner för att köpa säd från Egypten. ");
INSERT INTO swe_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Men Benjamin, Josefs yngre bror, sände Jakob inte iväg med sina bröder för han sa (tänkte för sig själv): ”Tänk om någon olycka skulle drabba honom.” Benjamin och Josef var helbröder. Rakel var deras mor. ");
INSERT INTO swe_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Israels söner kom bland alla de andra som kom den 8-10 dagar långa resan ner till Egypten för att handla, för hungersnöden var stor i Kanaans land. Josef kom som 17-åring till Egypten. Vid 30 års ålder blev han befordrad, och nu, 9 år senare, kommer hans bröder för att köpa säd av honom – 22 år efter att de sålde honom som slav. Den första drömmen som Josef haft går nu i uppfyllelse, se 1 Mos 37:5-8 – nästan. När de böjde sig för honom räknar han dem; de var tio, inte elva. Var är den elfte? ");
INSERT INTO swe_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josef var guvernör över landet, det var han som skötte försäljningen till alla människor i landet. Josefs bröder tio av dem, se vers 3 kom och bugade inför honom med sina ansikten mot marken. ");
INSERT INTO swe_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josef såg sina bröder och kände igen dem, men gjorde sig själv oigenkännlig för dem och talade hårt (med myndig röst) till dem och han sa till dem: ”Varifrån kommer ni?” och de svarade: ”Från Kanaans land för att köpa mat.” ");
INSERT INTO swe_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josef kände igen sina bröder, men de kände inte igen honom. ");
INSERT INTO swe_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Josef kom ihåg drömmarna som han hade drömt om dem 1 Mos 37:5-11 och sa till dem: ”Ni är spioner som kommer för att se landets nakenhet (var svagheterna finns).” ");
INSERT INTO swe_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","De sa till honom: ”Nej, min herre, dina tjänare har kommit för att köpa mat. ");
INSERT INTO swe_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Vi är alla en mans söner, vi är ärliga män, dina tjänare är inte några spioner.” ");
INSERT INTO swe_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Han sa till dem: ”Nej, för att se landets nakenhet (var svagheterna finns) har ni kommit.” ");
INSERT INTO swe_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","De sa: ”Vi, dina tjänare, är tolv bröder, söner till en man i Kanaans land, vår yngste är hos sin far och en finns inte längre.” ");
INSERT INTO swe_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef sa till dem: ”Det är det jag talade till er när jag sa: ’Ni är spioner.’ ");
INSERT INTO swe_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Genom detta ska ni prövas, så sant farao lever, ni ska inte gå härifrån om inte er yngste bror kommer hit. ");
INSERT INTO swe_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sänd en av er och låt honom hämta er bror och ni ska vara fängslade för att era ord ska prövas, huruvida det är sanning i er. Annars, så sant farao lever, är ni verkligen spioner.” ");
INSERT INTO swe_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Han satte dem alla tillsammans i förvar i tre dagar. ");
INSERT INTO swe_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","På tredje dagen sa Josef till dem: ”Gör detta så får ni leva, för jag fruktar (vördar) Gud (Elohim), ");
INSERT INTO swe_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","om ni är ärliga män, låt en av era bröder vara bunden i fängelset, men gå ni och ta med er säd för hungersnöden i era hus, ");
INSERT INTO swe_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","och ta med er yngste bror till mig, så ska era ord bli prövade och ni ska inte dö.” De gjorde så. Simeon, den näst äldste sonen, lämnas kvar i Egypten, se vers 36. ");
INSERT INTO swe_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Samtidigt som Josef var där började bröderna prata med varandra. De sa: ”Vi är verkligen skyldiga för vår bror, när vi såg ångesten i hans själ när han ropade efter nåd (hebr. chanan) utan att lyssna, därför har denna olycka kommit över oss.” ");
INSERT INTO swe_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben Jakobs förstfödde (med Leah) svarade dem och sa: ”Talade jag inte till er och sa att ni inte skulle synda mot barnet, men ni lyssnade inte? Därför utkrävs hans blod” ");
INSERT INTO swe_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","De visste inte att Josef förstod dem, för tolken var emellan dem. ");
INSERT INTO swe_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josef blev djupt rörd av vad han hörde. Han vände sig ifrån dem och grät. Han återvände till dem och talade till dem och tog Simeon ifrån dem och lät fängsla honom inför deras ögon. Simeon betyder ”den som hör”. Josef prövar sina bröder om de skulle överge Simeon, på samma sätt som de övergav honom. Simeon var känd för sin hårdhet, se 1 Mos 34:25; 49:5-7. Kanske var det han som var den drivande bakom hur bröderna behandlade Josef drygt 20 år tidigare. ");
INSERT INTO swe_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sedan befallde Josef att man skulle fylla deras kärl med säd och ge tillbaka varje mans pengar i hans säck och ge dem matsäck för resan, och så gjordes för dem. ");
INSERT INTO swe_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","De lastade sina åsnor med sin säd och reste därifrån. ");
INSERT INTO swe_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","När en av dem öppnade sin säck på rastplatsen för att utfodra sin åsna, upptäckte han sina pengar och se, de låg överst i säcken. ");
INSERT INTO swe_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Han sa till sina bröder: ”Mina pengar har lagts tillbaka, och de ligger i min säck.” De blev förskräckta (deras hjärtan svek dem) och de vände sig oroligt till varandra och sa: ”Vad är det som Gud (Elohim) har gjort mot oss?” ");
INSERT INTO swe_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","De kom tillbaka till sin far Jakob, i Kanaans land, och berättade för honom allt som hade hänt dem och sa: ");
INSERT INTO swe_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","”Mannen, herren i landet, talade hårt (med myndig röst) till oss och tog oss för att vilja spionera på landet. ");
INSERT INTO swe_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Vi sa till honom: Vi är ärliga män, vi är inte spioner. ");
INSERT INTO swe_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Vi är tolv bröder, söner till vår far, en finns inte och den yngste är hos sin far de här dagarna, i Kanaans land. ");
INSERT INTO swe_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mannen, herren i landet sa till oss, härigenom ska jag veta att ni är ärliga män, lämna en av era bröder hos mig och ta med er säd för hungersnöden i era hus och gå er väg. ");
INSERT INTO swe_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ta med er yngste bror till mig, då ska jag veta att ni inte är spioner utan ärliga män. Då ska jag befria er bror till er och ni kan röra er i landet.” ");
INSERT INTO swe_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","När de tömde sina säckar, fann var och en sin penningpung i sin säck. När de och deras far såg penningpungarna blev de rädda. ");
INSERT INTO swe_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jakob, deras far, sa till dem: ”Ni har berövat mig mina barn. Josef finns inte och Simeon finns inte och nu vill ni ta bort Benjamin. Över mig har allt detta kommit (allt detta har drabbat mig).” ");
INSERT INTO swe_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben talade till sin far och sa: ”Du ska dräpa mina två söner om jag inte för honom tillbaka till dig. Ge honom i min hand och jag ska föra tillbaka honom till dig.” Ruben hade fyra söner, så hebreiskan antyder ”två av mina söner”. ");
INSERT INTO swe_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jakob svarade: ”Min son Benjamin ska inte gå ner med dig, för hans bror är död och han är den ende som är kvar, om något ont drabbar honom på vägen som ni går, då störtar ni ner mina gråa hår med sorg i Sheol (graven, underjorden – de dödas plats).” Josef och Benjamin är Rakels enda söner som hon födde åt Jakob. Eftersom Rakel var hans första kärlek, se 1 Mos 29:18, är dessa två söner extra viktiga för honom. Hon dog dessutom i barnsäng när Benjamin föddes. ");
INSERT INTO swe_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Hungersnöden var svår i landet. ");
INSERT INTO swe_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","När de hade ätit upp säden som de hade hämtat från Egypten sa deras far till dem: ”Gå igen och köp oss lite mat.” ");
INSERT INTO swe_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda talade till honom och sa: ”Mannen varnade oss tydligt och sa: ’Ni ska inte se mitt ansikte utan att ha er bror med er.’ ");
INSERT INTO swe_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Om du sänder vår bror med oss ska vi gå ner och köpa dig mat, ");
INSERT INTO swe_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","men om du inte vill låta honom gå, kommer vi inte att gå, för mannen sa till oss: ’Ni ska inte se mitt ansikte utan att ha er bror med er.’ ” ");
INSERT INTO swe_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel som tidigare hette Jakob, se 1 Mos 32:28 sa: ”Varför har ni gjort så ont mot mig att ni har berättat för mannen att ni hade ännu en bror?” ");
INSERT INTO swe_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","De svarade: ”Mannen frågade detaljerat om oss och angående vår släkt och sa: Lever er far fortfarande? Har ni ytterligare en bror? Vi berättade för honom med dessa ord. Skulle vi på något sätt kunna veta att han skulle säga: För hit er bror?” ");
INSERT INTO swe_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda sa till sin far Israel: ”Sänd gossen Benjamin med mig så ska vi stå upp och gå, så att vi får leva och inte dö, både vi och du och även våra små. ");
INSERT INTO swe_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Jag ska vara garanten för honom. Från min hand ska du utkräva honom om jag inte för honom tillbaka till dig och ställer honom framför dig. Då ska jag bära skulden för det för evigt. ");
INSERT INTO swe_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Om vi inte hade dröjt oss kvar skulle vi redan ha varit tillbaka en andra gång.” Detta var ett anmärkningsvärt uttalande från Juda. Vi anar att hans hjärta var ångerfullt. Juda hade själv förlorat två söner, se 1 Mos 38:7, 10, han förstod verkligen sin fars känslor och kunde av personlig erfarenhet känna med honom. ");
INSERT INTO swe_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Deras far Israel sa till dem: ”Om det måste vara så nu, så gör detta. Ta av landets utvalda frukter i era väskor och ta med gåvor till mannen, lite balsam och lite honung, kryddor och myrra, nötter och sötmandel. Ironiskt nog är det samma varor som fanns i karavanen som förde med Josef till Egypten, se 1 Mos 37:25, som nu förs ned som gåvor till Josef. ");
INSERT INTO swe_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ta med er dubbla summan pengar i er hand och de pengarna som kom tillbaka överst i era säckar. Måhända var det ett misstag. ");
INSERT INTO swe_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ta också er bror Benjamin och stå upp och gå igen till mannen. ");
INSERT INTO swe_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Må Allsmäktig Gud (El Shaddaj) ge er evig nåd (gränslös barmhärtighet) inför den mannen som ju är Josef – ännu dold för dem, så att han befriar er andra bror Simeon, se 1 Mos 42:19, 36 och Benjamin. Och för min del – om jag blir barnlös (berövas mina barn), så är jag barnlös (berövad).” Jakob förtröstar på att Guds vilja ska få ske, se 2 Kung 7:4; Est 4:16. Detta är första gången som det hebreiska ordet rachamim förekommer i GT. Det betyder evig nåd, obegränsad barmhärtighet, gränslöst medlidande, oändligt förbarmande. Då ordet står i plural finns det ingen början och inget slut, det är omöjligt att räkna, det saknar begränsningar. Därav översättningar som på olika sätt uttrycker detta med adjektiv som evig, oändlig, gränslös m.m. Huvudbetydelsen i ordet är nåd, men hebreiskan har fem olika rötter för detta ord. Just denna rot betonar att nåden innebär barmhärtighet, medlidande och förbarmande.  Rachamim delar även rot med ordet för livmoder rechem. Det ger nåden i detta uttryck ytterligare en dimension av att vara värnande och beskyddande på samma sätt som livmodern är det lilla, hjälplösa och värnlösa barnets beskydd. På samma sätt som det ofödda barnet också är helt beroende av navelsträngen för att få näring, ligger i detta ord för nåd även en dimension som visar att vi är helt och hållet beroende av Guds eviga nåd för att ens överleva! Det gör att barmhärtigheten, medlidandet och förbarmandet får mycket djupare dimensioner än en allmän välvilja. ");
INSERT INTO swe_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Männen (hebr. enosh) Josefs bröder tog gåvorna och de tog dubbla summan pengar i sina händer samt Benjamin och steg upp och gick ner till Egypten och stod inför Josef. ");
INSERT INTO swe_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","När Josef såg Benjamin med dem sa han till dem över sitt hus betjänterna: ”För in männen i huset, slakta ett djur och gör i ordning köttet, för männen ska äta middag med mig idag.” ");
INSERT INTO swe_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mannen (hebr. ish) en av betjänterna i huset gjorde som Josef bett honom och han förde in männen (hebr. enósh) i Josefs hus. ");
INSERT INTO swe_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Männen Josefs bröder var rädda eftersom de fördes in i Josefs hus och de sa: ”På grund av pengarna som lagts tillbaka i våra säckar första gången har vi förts in, för att han ska kunna söka en anledning mot oss och överfalla oss och ta oss som slavar med våra åsnor.” ");
INSERT INTO swe_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","De kom nära betjänten i Josefs hus och de talade med honom vid dörren till huset ");
INSERT INTO swe_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","och sa: ”Min herre (hebr. adón), vi kom verkligen ner för att köpa mat första gången, ");
INSERT INTO swe_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","men det hände att när vi kom till rastplatsen, öppnade vi våra säckar och var och en fann sina pengar överst i sin säck, våra pengar i full vikt. 1 Mos 42:26-28 Vi har nu tagit med oss dem tillbaka i våra händer. ");
INSERT INTO swe_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Vi har också tagit med oss andra pengar hit ner i våra händer för att köpa mat. Vi vet inte vem som lagt våra pengar i våra säckar.” ");
INSERT INTO swe_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Då sa han: ”Frid (shalom) vare med er, frukta inte. Er Gud (Elohim) och era fäders Gud (Elohim) har gett er skatter i era säckar. Jag har fått era pengar.” Sedan förde han ut Simeon till dem. ");
INSERT INTO swe_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mannen (hebr. ish) Josefs tjänare tog in männen (hebr. enosh) i Josefs hus och gav dem vatten och de tvättade sina fötter och han gav deras åsnor foder. ");
INSERT INTO swe_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","De gjorde i ordning sina gåvor inför Josefs ankomst vid middagstiden, för de hörde att de skulle äta mat där. ");
INSERT INTO swe_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","När Josef kom hem tog de fram gåvorna som var i deras händer och förde in dem i huset och böjde sig ner inför honom, ända till marken. ");
INSERT INTO swe_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Han frågade dem om deras hälsa och sa: ”Är allting väl med er far, den gamle mannen som ni talade om? Lever han fortfarande?” ");
INSERT INTO swe_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","De svarade: ”Din tjänare, vår far, mår väl, han lever fortfarande.” Och de böjde sina huvuden i en vördnadsfull hälsning. ");
INSERT INTO swe_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Han lyfte upp sina ögon och såg sin bror Benjamin, sin egen mors Rakels son, och sa: ”Är detta er yngste bror som ni talade med mig om?” Han sa vidare: ”Må Gud (Elohim) visa nåd (oförtjänt kärlek, trofasthet – chanan) mot dig, min son.” ");
INSERT INTO swe_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josef fick bråttom att söka efter en plats där han kunde gråta, eftersom han berördes djupt av nåd (barmhärtighet, medlidande) gentemot sina bröder, och han gick in i sin kammare och grät där. ");
INSERT INTO swe_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Han tvättade sitt ansikte och kom ut (till bröderna) igen och behärskade sig och sa: ”Duka fram mat.” ");
INSERT INTO swe_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","De serverade (dukade fram) först åt honom för sig, och sedan bröderna för sig och sist egyptierna som åt med honom för sig själva. Egyptierna kan nämligen inte äta tillsammans med hebréerna, eftersom det skulle vara anstötligt för dem. Egyptierna ansåg sig förmer än andra folk, och man associerade sig inte med dem genom att äta vid samma bord. Den grekiska historikern Herodotos (484-425 f.Kr.) bekräftar att egyptierna inte ens använde kärl, knivar eller spett gjorda i Grekland. De tog inte kött uppskuret med en grekisk kniv i sin mun. Egyptierna såg också ned på folk som var boskapsskötare, se 1 Mos 46:34. ");
INSERT INTO swe_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","De satt framför honom, den förstfödde främst enligt sin förstfödslorätt, och den yngste efter sin ålder. Josef har placerat dem så att alla sitter i åldersordning. Männen de 11 bröderna tittade förundrat på varandra. De förundrades över hur Josef kunde veta deras inbördes ålder. Sannolikheten att slumpmässigt välja denna ordning är ytterst liten, en på närmare 40 miljoner. ");
INSERT INTO swe_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Framför honom delades portioner ut åt dem, men Benjamins portion var fem gånger så stor som någon av de andras. De drack och var glada med honom. Varför ger Josef Benjamin mer mat, och även senare mer pengar och 5 dräkter, se 1 Mos 45:22? Följde han sin fars spår att favorisera en av bröderna? Nej, Josef prövade bröderna för att se om de skulle bli avundsjuka igen. Hade de ödmjukat sig, kunde de glädja sig även om en broder blev mer välsignad, eller skulle de göra sig av med Benjamin på samma sätt som de försökt göra sig av med Josef? ");
INSERT INTO swe_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Han befallde husets tjänare och sa: ”Fyll männens säckar med mat, så mycket som de kan bära, och lägg vars och ens pengar överst i säcken. ");
INSERT INTO swe_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Lägg sedan min bägare, silverbägaren, överst i den yngstes säck och hans pengar för säden.” De gjorde så som Josef hade talat. ");
INSERT INTO swe_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Så snart morgonen grydde sändes männen iväg, de och deras åsnor. ");
INSERT INTO swe_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","När de hade kommit ut ur staden och inte hunnit så långt, sa Josef till sin tjänare: ”Gå efter männen och när du kommer ikapp dem ska du säga till dem: ’Varför har ni lönat gott med ont? ");
INSERT INTO swe_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Är det inte denna som min herre dricker ur och genom vilken han verkligen blir gudomlig? Ni har gjort ont som har gjort detta.’ ” ");
INSERT INTO swe_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","När han kom ikapp dem talade han dessa ord till dem. ");
INSERT INTO swe_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","De svarade honom: ”Varför talar min herre ord som dessa? Det är fjärran från dina tjänare att göra något sådant. ");
INSERT INTO swe_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Se, pengarna som vi fann överst i våra säckar har vi fört tillbaka från Kanaans land, hur skulle vi då kunna stjäla silver och guld ur din herres hus? ");
INSERT INTO swe_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Hos den av dina tjänare som den blir funnen, låt honom dö, och vi ska bli vår herres slavar.” ");
INSERT INTO swe_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Han svarade: ”Låt det nu bli som ni har sagt. Den hos vilken den blir funnen ska vara min slav och ni övriga ska vara oskyldiga.” ");
INSERT INTO swe_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Då skyndade de sig, var och en, att ta ner sin säck på marken och var och en av dem öppnade sin säck. ");
INSERT INTO swe_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Han sökte och började med den äldste och fortsatte i åldersordning till den yngste ... och bägaren blev funnen i Benjamins säck. ");
INSERT INTO swe_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","De rev sönder sina kläder i sorg och förtvivlan! Sedan lastade var och en sin åsna och de återvände till staden. ");
INSERT INTO swe_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda och hans bröder kom tillbaka till Josefs hus. Juda kommer ha en avgörande roll i denna del, så han lyfts redan nu fram i berättelsen. Han var den som lovat ta hand om Benjamin, se 1 Mos 43:9. I stycket som följer refererar han 14 ggr till sin ”far”. Josef var fortfarande kvar där i huset, han var förberedd och väntade på dem och de föll ner på marken inför honom. ");
INSERT INTO swe_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josef sa till dem: ”Vad är det ni har gjort? Vet ni inte att en man som jag verkligen är gudomlig?” ");
INSERT INTO swe_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda svarade: ”Vad kan vi säga till vår herre? Vad ska vi tala? Hur ska vi förklara oss själva (rättfärdiga oss)? Gud har funnit dina tjänares missgärningar, vi är min herres slavar, både vi och den i vars hand bägaren blev funnen.” ");
INSERT INTO swe_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Men Josef sa: ”Det skulle vara fjärran från mig att göra så. Den man i vars hand bägaren blev funnen, han ska vara min slav, men ni andra, stå upp och gå i frid (shalom) till er far.” ");
INSERT INTO swe_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda kom nära honom Josef och sa: ”Min herre, låt din tjänare, jag ber dig (vädjar), få tala ett ord i min herres öra, och låt inte din vrede upptändas mot din tjänare, för du är som farao. ");
INSERT INTO swe_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Min herre frågade sina tjänare och sa: ’Har ni en far eller en bror?’ ");
INSERT INTO swe_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Vi svarade min herre: ’Vi har en far som nu är gammal, och han har en son som han fått på gamla dagar. Pojkens bror är död. Därför är han ensam kvar efter sin mor, och hans far älskar honom.’ ");
INSERT INTO swe_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Då sa du till dina tjänare: ’För honom ner med er så att jag kan se honom med mina ögon.’ ");
INSERT INTO swe_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Vi svarade min herre: ’Ynglingen kan inte lämna sin far, för om han lämnar sin far kan hans far dö.’ ");
INSERT INTO swe_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Men du sa till dina tjänare: ’Om inte er yngste bror följer med er ner hit, ska ni inte se mitt ansikte igen.’ ");
INSERT INTO swe_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","När dina tjänare kom till vår far berättade vi min herres ord för honom. ");
INSERT INTO swe_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Och vår far sa: ’Gå igen och köp oss lite mat,’ ");
INSERT INTO swe_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","och vi svarade: ’Vi kan inte gå ner om inte vår yngste bror är med oss, då ska vi gå ner, för vi får inte se mannens ansikte om inte vår yngste bror är med oss.’ ");
INSERT INTO swe_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Då sa din tjänare, min far, till oss: ’Ni vet att min hustru födde två söner åt mig, ");
INSERT INTO swe_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","och den ene har gått ifrån mig’ och han sa: ’Han har säkert slitits i stycken och jag har inte sett honom sedan dess, ");
INSERT INTO swe_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","om ni tar denne enda ifrån mig också och något drabbar honom så för ni ner mitt gråa hår med sorg i Sheol (graven, underjorden – de dödas plats).’ ");
INSERT INTO swe_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Vet därför att när jag Juda kommer till din tjänare, min far Jakob, och ynglingen inte är med oss – eftersom hans eget liv är helt sammanfogat med hans liv ordagrant: hans själ är bunden i hans själ – ");
INSERT INTO swe_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","då kommer det bli hans död, om han ser att inte ynglingen är med. Din tjänare jag Juda kommer att dra ner de gråa håren på din tjänare, vår far Jakob, med sorg till Sheol (underjorden). ");
INSERT INTO swe_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Din tjänare blev en garant för ynglingen gentemot min far och jag sa: ’Om jag inte för tillbaka honom till dig ska jag bära skulden och skammen för min far för evigt.’ 1 Mos 43:9 ");
INSERT INTO swe_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Låt därför nu din tjänare, jag ber dig (vädjar), stanna här som slav åt min herre istället för ynglingen, och låt ynglingen gå upp med sina bröder. ");
INSERT INTO swe_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Hur ska jag kunna gå upp till min far om ynglingen inte är med mig? Annars måste jag se på det onda som kommer över min far.” ");
INSERT INTO swe_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josef kunde inte behärska sig själv framför alla dem som stod hos honom och han ropade: ”Se till att allt tjänstefolk går ut härifrån!” Ingen av hans tjänare var med honom när han gav sig till känna för sina bröder. ");
INSERT INTO swe_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Han grät högljutt så att egyptierna hörde och faraos hus hörde. ");
INSERT INTO swe_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josef sa till sina bröder på hebreiska: ”Jag är Josef! Lever min far fortfarande?” Hans bröder kunde inte svara honom, de stod där förskräckta (chockade) framför honom. ");
INSERT INTO swe_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Josef sa till sina bröder: ”Kom närmare mig”, så de kom nära så Josef kunde viska till dem utan att egyptierna skulle höra deras konversation. Då sa han i låg ton: ”Jag är Josef, er bror, som ni sålde till Egypten. 1 Mos 37:25-28 ");
INSERT INTO swe_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Var inte ledsna och arga på er själva för att ni sålde mig hit. Gud har sänt mig före er för att bevara människors liv. ");
INSERT INTO swe_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","I 2 år har det nu varit hungersnöd i landet, och i ytterligare 5 år ska man varken plöja eller skörda. ");
INSERT INTO swe_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gud har sänt mig hit före er för att bevara er och rädda era liv genom en stor befrielse. ");
INSERT INTO swe_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ja, det var Gud som skickade hit mig, inte ni 1 Mos 50:19-20; Ps 105:17. Han har gjort mig till faraos närmaste rådgivare, herre över hans hus, och härskare över hela Egyptens land. ");
INSERT INTO swe_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Skynda er att gå upp till min far och säg till honom: ’Så säger din son Josef, Gud har gjort mig till herre över hela Egypten, kom ner till mig, dröj inte. Josefs ord måste ha påmint dem om vad han sagt tidigare, se 1 Mos 37:8. ");
INSERT INTO swe_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Du ska bo i landet Goshen och du ska vara nära mig, du och dina söner och dina sonsöner och dina hjordar och dina herdar och allt det du äger. ");
INSERT INTO swe_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Jag ska försörja dig där, för det är fortfarande 5 år kvar av hungersnöden. Annars blir du fattig, du, ditt hushåll och allt som du har.’ ");
INSERT INTO swe_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Och se, era ögon ser och min bror Benjamins ögon (ser), att det är min mun som talar till er. ");
INSERT INTO swe_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ni ska berätta för min far om all min härlighet i Egypten, och om allt som ni har sett och ni ska skynda er att föra min far hit.” ");
INSERT INTO swe_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Han kastade sig om halsen på sin bror Benjamin och grät (kramade om honom, se 1 Mos 46:29) och Benjamin grät vid hans hals. ");
INSERT INTO swe_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Han kysste alla sina bröder och grät med dem. Sedan talade hans bröder med honom. ");
INSERT INTO swe_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Uppståndelsen hördes i faraos hus och man sa: ”Josefs bröder har kommit!” Det behagade farao väl, liksom hans tjänare. ");
INSERT INTO swe_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao sa till Josef: ”Säg till dina bröder: ’Detta ska ni göra; lasta era djur och gå till Kanaans land, ");
INSERT INTO swe_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","och ta er far och ert hushåll och kom till mig. Jag ska ge er det goda i Egyptens land och ni ska äta det feta i landet.’ Hes 34:3 ");
INSERT INTO swe_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Du är också befalld (får uppdraget), gör detta. Ta er vagnar från Egyptens land för era små och för era fruar och för hit er far och kom. ");
INSERT INTO swe_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Oroa er inte för era tillhörigheter, för det bästa i hela Egyptens land är ert.” ");
INSERT INTO swe_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israels söner gjorde så, och Josef gav dem vagnar i enlighet med faraos befallning, och gav dem proviant för resan. ");
INSERT INTO swe_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Till alla, varje man, gav han ett ombyte av kläder, men till Benjamin gav han 300 shekel 3,45 kg silver och fem ombyten av kläder. ");
INSERT INTO swe_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Till sin far sände han på samma sätt tio åsnor lastade med det goda från Egypten och tio åsneston lastade med säd och bröd och proviant för resan. ");
INSERT INTO swe_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Så sände han iväg sina bröder och de reste och han sa till dem: ”Se till att ni inte blir oroliga (börjar att skaka, darra) på vägen.” ");
INSERT INTO swe_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","De gick upp, ut ur Egyptens land och kom in i Kanaans land till Jakob, sin far. ");
INSERT INTO swe_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","De berättade för honom och sa: ”Josef lever fortfarande och han är ledare över hela Egyptens land.” Då lamslogs hans hjärta slutade hans hjärta nästan att slå, för han kunde inte tro dem. ");
INSERT INTO swe_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","De talade (berättade) alla Josefs ord som han hade talat till dem. När han såg vagnarna som Josef hade sänt för att bära honom, blev Jakobs, deras fars, ande förnyad (återupplivad) i honom. ");
INSERT INTO swe_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel sa: ”Det är nog. Josef min son lever fortfarande. Jag vill gå och se honom innan jag dör.” ");
INSERT INTO swe_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel Jakob gjorde resan med allt som han ägde och kom till Beer-Sheva. Där offrade han till sin far Isaks Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Gud talade till Israel i en dröm på natten och sa: ”Jakob, Jakob!” ”Här är jag”, svarade han. Det var 22 år sedan Jakob hade hört Herrens röst på detta sätt, han var nu 130 år, se 1 Mos 47:9. Hebr. hineni, har betydelsen ”jag står till förfogande” eller ”jag är beredd att ta ansvar”. Jakob svarar detta första gången i 1 Mos 31:11 när han är hos Laban och har en dröm där Gud kallar honom tillbaka till Kanaans land. Se även 1 Mos 22:1. ");
INSERT INTO swe_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Han sa: ”Jag är Gud (El), dina fäders Gud (Elohim). Frukta inte att gå ner till Egypten, för där ska jag göra dig till ett stort folkslag. ");
INSERT INTO swe_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Jag ska gå med dig ner till Egypten och jag ska också garanterat föra dig upp igen och Josef ska lägga sin hand på dina ögon.” (Josef ska tillsluta dina ögon när du dör). ");
INSERT INTO swe_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jakob steg upp från Beer-Sheva och Israels söner bar Jakob, sin far, och sina små och sina fruar i vagnarna som farao hade sänt för att bära honom. ");
INSERT INTO swe_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","De tog sin boskap och sina ägodelar, som de hade fått i Kanaans land, och kom till Egypten, Jakob och hans säd (avkomma, barn) med honom. ");
INSERT INTO swe_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sina söner och sina sonsöner, sina döttrar och sina dotterdöttrar och alla sina efterkommande tog han med sig till Egypten. Nu följer en uppräkning av Jakobs söner. Frasen ”Detta är namnet på” är en vanlig fras, se 1 Mos 25:13; 36:10; 2 Mos 6:16. Versen är uppbyggd som en kiasm. ");
INSERT INTO swe_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Och detta är namnen på sönerna till Israel som kom till Egypten, Jakob och hans söner: Leahs sex barn: Ruben, Jakobs förstfödda. ");
INSERT INTO swe_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubens söner: Chanoch (Henok) och Pallo och Chetsron (Hesron) och Karmi. 2 Mos 6:4; 5 Mos 26:5-6; 1 Krön 5:3 ");
INSERT INTO swe_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeons(Shimons) söner: Jemoel och Jamin och Ohad och Jachin och Sochar (Tsochar) och Saul (Shaol), sonen till en kanaaneisk kvinna. ");
INSERT INTO swe_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levis söner: Gershon, Kehat och Merari. ");
INSERT INTO swe_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judas söner: Er och Onan uttalas ”Ånan” och Shela och Perets och Zerach, men Er och Onan dog i Kanaans land. Perets söner var Chetsron (Hesron) och Chamol. ");
INSERT INTO swe_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskars söner: Tola och Puva och Job och Shimron. ");
INSERT INTO swe_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulons(hebr. Zevoluns) söner: Sered och Elon och Jachlel. ");
INSERT INTO swe_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Detta är Leahs söner som hon födde till Jakob i Paddan-Aram, hon födde även hans dotter Dina. Alla hans söner och hans döttrar – totalt 33 personer (liv, själar). Hälften av alla, se vers 26 – det högsta antalet i denna släkttavla. ");
INSERT INTO swe_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Leahs tjänstekvinna Zilpas två söner: Gads söner: Tsifjon och Chaggi, Shoni och Esbon, Eri och Arodi och Areli. ");
INSERT INTO swe_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ashers söner: Imna och Ishva och Ishvi och Beria. Deras syster var Serach. Berias söner: Chever och Malchiel. ");
INSERT INTO swe_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Detta är Zilpas söner, som Laban gav till sin dotter Leah, och som hon födde till Jakob – totalt 16 personer (själar, liv). ");
INSERT INTO swe_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rakels två söner: Rakels söner, Jakobs hustru: Josef och Benjamin. ");
INSERT INTO swe_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Till Josef i Egyptens land föddes Manasse och Efraim genom hans fru Asenat, prästen Potiferas dotter från On 1 Mos 41:45. ");
INSERT INTO swe_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamins 10 söner: Bela och Becher och Ashbel, Gera och Naman, Echi och Rosh, Moppim och Choppim och Ard. Se även 4 Mos 26:38-41; 1 Krön 7:6. ");
INSERT INTO swe_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Detta är Rakels söner som föddes till Jakob – totalt 14 personer (själar, liv). ");
INSERT INTO swe_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Rakels tjänstekvinna Bilhahs söner: Dans söner en son: Chushim. 4 Mos 26:42 ");
INSERT INTO swe_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalis söner: Jachtsel och Goni och Jetser och Shillem. ");
INSERT INTO swe_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dessa är Bilhahs söner, som Laban gav till sin dotter Rakel, och som hon födde till Jakob – totalt 7 personer (själar, liv). ");
INSERT INTO swe_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Sammanfattning: Alla personer (själar, liv) som tillhörde Jakob, som kom till Egypten, de som kommit från hans länd, liksom Jakobs söners hustrur – totalt var de 66 personer (själar, liv). ");
INSERT INTO swe_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josefs söner som föddes åt honom i Egypten var två – alla personer i Jakobs hus, som kom till Egypten, var totalt 70 stycken. Det finns olika sätt att se på vilka som ingår i antalet 66 och 70. En skillnad verkar belysas i formuleringen ”kom med Jakob”. I den gruppen bör Josefs två söner inte ingå. Summan av de fyra delsummorna som ges i stycket ovan är 70 personer (33 + 16 + 14 + 7), se vers 15, 18, 22 och 25. De 70 kan inkludera Jakob själv och de 71 ättlingarna (inklusive Dina, Josef, Manasse och Efraim) som räknas upp i vers 8-25, minus Er och Onan som dött, se vers 12. ");
INSERT INTO swe_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Han Jakob sände Juda vars namn betyder lovprisning före sig till Josef, för att visa vägen framför honom till Goshen och de kom till Goshens land. ");
INSERT INTO swe_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef gjorde i ordning sin vagn och gick upp för att möta sin far Israel i Goshen, och han presenterade sig själv för honom och föll honom om halsen och grät vid hans hals en lång stund. ");
INSERT INTO swe_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel sa till Josef: ”Nu kan jag dö när jag har sett ditt ansikte och att du är vid liv.” ");
INSERT INTO swe_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Josef sa till sina bröder och till sin fars hus: ”Jag ska gå upp och berätta för farao och säga till honom: ’Mina bröder och min fars hus, som var i landet Kanaan, har kommit till mig, ");
INSERT INTO swe_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","männen är herdar för de har varit boskapsskötare och de har tagit med sig sina hjordar och sin småboskap och allt som de äger.’ ");
INSERT INTO swe_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","När det händer sig att farao kallar på er och frågar: ’Vad är ert yrke?’ ");
INSERT INTO swe_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Då ska ni svara: ’Dina tjänare har varit boskapsskötare från sin ungdom till nu, både vi och våra fäder,’ så att ni kan bo i landet Goshen, för alla herdar är en styggelse för egyptierna.” ");
INSERT INTO swe_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Sedan gick Josef och berättade för farao och sa: ”Min far och mina bröder, deras boskapshjordar och deras småboskap och allt de äger har kommit från Kanaans land och nu är de i landet Goshen 1 Mos 45:10.” ");
INSERT INTO swe_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Av sina bröder tog han fem män och presenterade dem för farao. ");
INSERT INTO swe_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao sa till hans bröder: ”Vilket är ert yrke?” De svarade farao: ”Dina tjänare är herdar, både vi och våra fäder.” ");
INSERT INTO swe_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","De sa till farao: ”Vi har kommit för att vistas i landet, för det finns inget bete för dina tjänares småboskap (får) eftersom hungersnöden och torkan är stor i Kanaans land. Därför ber (vädjar) vi dig nu, låt dina tjänare bo i Goshens land.” ");
INSERT INTO swe_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao talade med Josef och sa: ”Din far och dina bröder har kommit till dig, ");
INSERT INTO swe_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egyptens land ligger framför dig, se till att din far och dina bröder bor i den bästa delen av landet. Låt dem bo i Goshens land. Om du vet om (känner till) några duktiga män ibland dem, så gör dem till chefer över min boskap.” ");
INSERT INTO swe_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Josef tog in sin far Jakob och satte honom framför farao och Jakob välsignade farao. Abraham är satt att bli en välsignelse för alla familjer på jorden, se 1 Mos 12:3. Jakob, Abrahams barnbarn, talar nu ut en välsignelse över farao. ");
INSERT INTO swe_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao sa till Jakob: ”Hur många är dagarna och åren av ditt liv?” ");
INSERT INTO swe_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob svarade farao: ”Dagarna och åren av min vandring är 130 år. Få och onda har dagarna av mitt liv varit och jag har inte uppnått dagarna och åren av mina förfäders liv, de dagar som de vistades (på jorden).” ");
INSERT INTO swe_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakob välsignade farao och gick ut från faraos ansikte. ");
INSERT INTO swe_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josef etablerade sin far och sina bröder och gav dem besittningar i Egyptens land, i den bästa delen av landet, i landet Rameses som senare blev en stad i området som också kallas Goshen vid Nilens deltaområde, se 2 Mos 1:11; 12:37, som farao hade befallt. ");
INSERT INTO swe_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josef försåg sin far och sina bröder och hela hans fars hushåll med bröd, i enlighet med vad de behövde för sina små. ");
INSERT INTO swe_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Det fanns inget bröd i hela landet för hungersnöden var mycket svår, så att Egyptens land och Kanaans land förtvinade på grund av hungersnöden. ");
INSERT INTO swe_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josef samlade in alla pengar som fanns i Egyptens land och i Kanaans land, för den säd som de köpte. Och Josef tog in pengarna till faraos hus. ");
INSERT INTO swe_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","När pengarna var spenderade i Egyptens land och i Kanaans land, kom alla egyptier till Josef och sa: ”Ge oss bröd, för varför skulle vi dö i din åsyn? För alla våra pengar är slut.” ");
INSERT INTO swe_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josef svarade: ”Kom hit med er boskap. Jag ska ge er bröd för boskapen om pengarna är slut.” ");
INSERT INTO swe_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","De förde sin boskap till Josef och Josef gav dem bröd i utbyte mot deras hästar, boskap, småboskap och deras åsnor. Han gav dem bröd i utbyte mot all deras boskap det året. ");
INSERT INTO swe_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","När det året gått till ända kom de till honom ett andra år och sa till honom: ”Vi vill inte undanhålla för vår herre hur alla våra pengar är spenderade, och småboskapen och boskapshjordarna är min herres. Ingenting är kvar i min herres åsyn förutom våra kroppar och vår mark. ");
INSERT INTO swe_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Varför skulle vi dö inför dina ögon, både vi och vår mark? Köp oss och vår mark för bröd, och vi och vår mark ska vara faraos slavar. Ge oss bröd så att vi kan leva och inte dö och så att marken inte blir ödelagd.” ");
INSERT INTO swe_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Josef köpte Egyptens mark till farao eftersom egyptierna, alla män, sålde sina fält på grund av att svälten var så svår för dem. Så blev marken faraos. ");
INSERT INTO swe_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Angående folket, förflyttade han dem stad för stad från den ena änden av Egyptens gräns till den andra. ");
INSERT INTO swe_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Endast prästernas mark köpte han inte (löste inte in), eftersom prästerna hade sin del från farao och åt den ranson som farao gav dem. Därför sålde de inte sin mark. ");
INSERT INTO swe_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Sedan sa Josef till folket: ”Se, jag har idag köpt er och er mark till farao. Här är säd åt er och ni ska beså marken. ");
INSERT INTO swe_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Det ska ske att när ni samlar in skörden, ska ni ge en femtedel till farao och fyra delar ska vara era egna till att beså fälten och till er mat för dem som är i ert hushåll och till mat för era små.” ");
INSERT INTO swe_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","De sa: ”Du har räddat våra liv. Låt oss finna nåd (oförtjänt kärlek) i min herres ögon, och vi ska vara faraos slavar.” ");
INSERT INTO swe_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josef upprättade en stadga angående Egyptens land denna dag, att farao ska ha en femtedel, bara prästernas mark ska inte tillhöra farao. ");
INSERT INTO swe_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel bodde i Egyptens land, i landet Goshen och de fick sina besittningar där och var fruktsamma och förökade sig mycket. ");
INSERT INTO swe_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob levde i Egyptens land i 17 år. Jakobs dagar, åren av hans liv blev 147 år. ");
INSERT INTO swe_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tiden närmade sig när Israel Jakob måste dö och han kallade på sin son Josef och sa till honom: ”Jag ber dig, om jag har funnit nåd (oförtjänt kärlek) i dina ögon, lägg – jag ber dig – din hand under min höft och agera välvilligt och trofast med mig. Jag ber dig, begrav mig inte i Egypten. Tre gånger används hebr. na som används som en vädjan och ofta översätts jag ber dig. ");
INSERT INTO swe_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Men när jag sover med mina fäder, ska du föra ut mig ur Egypten och begrava mig på deras begravningsplats.” Han Josef svarade sin far: ”Jag ska göra som du har sagt.” ");
INSERT INTO swe_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Han Jakob/Israel sa: ”Ge mig din ed” Och han Josef gav honom sin ed och Israel böjde sig ner och tillbad över sängens huvudända. Jfr 1 Kung 1:47 ");
INSERT INTO swe_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Efter allt detta kom man till Josef och sa: ”Se, din far är sjuk.” Då tog han med sig sina två söner Manasse och Efraim. ");
INSERT INTO swe_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Och man berättade för Jakob och sa: ”Se, din son Josef kommer till dig.” Israel styrkte sig själv (samlade ihop sina krafter) och satt på sängen. ");
INSERT INTO swe_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakob sa till Josef: ”Gud den Allsmäktige (El Shaddaj) visade sig för mig i Loz annat namn för Betel i Kanaans land och välsignade mig 1 Mos 28:19; 35:9-15, ");
INSERT INTO swe_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","och sa till mig: ’Se, jag ska göra dig fruktsam och föröka dig, och av dig ska jag göra ett helt kompani (en stor skara eller en hel armé) av människor, och jag ska ge detta land till din säd efter dig som en evig egendom.’ ");
INSERT INTO swe_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jakob fortsätter tala till Josef: Nu är dina två söner mina, de som föddes till dig i Egyptens land innan jag kom till dig i Egyptens land, Efraim och Manasse, precis som Ruben och Simeon är och ska vara mina. ");
INSERT INTO swe_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Och deras ättlingar som du ska få efter dem, ska vara dina, de ska uppkallas efter dina bröder i deras arv. ");
INSERT INTO swe_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","För mig, när jag kom från Paddan, dog Rakel ifrån mig i Kanaans land på vägen, när det fortfarande var ett stycke kvar till Efratah. Jag begravde henne där på vägen till Efratah.” Platsen heter idag Betlehem. ");
INSERT INTO swe_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","När Israel Jakob fick se Josefs söner frågade han: ”Vilka är dessa?” ");
INSERT INTO swe_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef svarade sin far: ”De är mina söner, som Gud (Elohim) har gett mig här.” Han sa: ”För fram dem, jag ber dig, till mig och jag ska välsigna dem.” ");
INSERT INTO swe_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Nu var Israels ögon grumliga på grund av hög ålder så att han inte kunde se. Han förde dem nära honom och han kysste dem och omfamnade dem. ");
INSERT INTO swe_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel sa till Josef: ”Jag trodde inte att jag skulle få se ditt ansikte och se, Gud har låtit mig se din säd (dina söner) också!” ");
INSERT INTO swe_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Josef tog ner dem från sina knän och föll ner (böjde sig) med sitt ansikte mot marken. ");
INSERT INTO swe_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josef tog dem båda, Efraim i sin högra hand mot Israels vänstra hand, och Manasse i sin vänstra hand mot Israels högra hand, och förde dem nära honom. ");
INSERT INTO swe_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel sträckte ut sin högra hand och lade den på Efraims huvud – som var den yngre – och sin vänstra hand på Manasses huvud, så att han korsade sina händer, för Manasse var den förstfödde. ");
INSERT INTO swe_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Han välsignade Josef och sa: ”Den Gud (Elohim – i bestämd form: Guden) inför vilken mina fäder Abraham och Isak vandrade, den Gud (Elohim – i bestämd form: Guden) som har varit min herde (”har vallat mig”) som har lett mig och fört mig på bete hela mitt långa liv från min födelse ända till denna dag, ");
INSERT INTO swe_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ängeln (budbäraren) Herren själv som återlöste (friköpte) mig från allt ont (all ondska) – må han välsigna ynglingarna. Och låt mitt namn nämnas i dem och mina fäders namn – Abraham och Isak, och låt dem växa till i stort antal (bli många) mitt i landet (över jorden).” 2 Mos 1:7 Här används det hebreiska verbet gaal (att återlösa) för första gången i Bibeln. Substantivet på samma rot – återlösare, är ett av namnen på Jesus. Hans uppdrag på korset var att återlösa, se Joh 1:29; Ef 1:7; Heb 9:12. Därför är det inte en slump att just uttrycket ”allt ont” finns med när gaal förekommer för första gången i Skrifterna. Det pekar profetiskt på vad som ligger i Guds frälsningsplan. ");
INSERT INTO swe_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","När Josef såg att hans far lade sin högra hand på Efraims huvud, ogillade han det (det var något ont i hans ögon), så han tog tag i sin fars hand för att flytta den från Efraims huvud till Manasses huvud. ");
INSERT INTO swe_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josef sa till sin far: ”Inte så min far, för detta är den förstfödde, lägg din högra hand över hans huvud”. ");
INSERT INTO swe_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hans far vägrade och sa: ”Jag vet (känner mycket väl till) det min son. Jag vet det. Han ska också bli ett folk och även han ska bli stor. Likväl (en skarp betoning och kontrast mellan något som varit och något som är – hebr. olam) ska hans yngre bror bli större än han och hans säd (efterkommande) ska bli en myckenhet av folk (nationer).” ");
INSERT INTO swe_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Han välsignade dem den dagen och sa: ”Av dig ska Israel välsigna och säga: ’Gud (Elohim) ska göra dig som Efraim och som Manasse.’ ” Så satte han Efraim före Manasse. ");
INSERT INTO swe_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel sa till Josef: ”Se, jag dör, men Gud (Elohim) ska vara med dig och föra dig tillbaka till dina fäders land. ");
INSERT INTO swe_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Jag ger dig nu, utöver vad dina bröder får, en bergsrygg (sluttning eller staden Shechem) som jag tagit från amoréerna med svärd och båge.” Hebr. shekhem kan syfta på en bergsrygg, sluttning eller även staden Shechem. Han kan referera till marken han köpte, se 1 Mos 33:18-19, men eftersom en strid nämns talar det för att det är händelserna i 1 Mos 34:25-29 som åsyftas. Josef begravdes senare i Shechem, se Jos 24:32.  Tolv eller tretton stammar?  Josefs söner, Efraim och Manasse, adopteras av Jakob (vers 5), så totalt blir det som om Israel hade 14 söner! När landet senare fördelas får Josef inget landområde, istället är det Manasse och Efraim som tilldelas land, och Josef ersätts alltså av sina söner. Här finns en förebild på hur Jesus återlöser två folk (judar och hedningar) och låter dessa två folk ta hans plats som ett folk, men ändå två (vers 16).  Även om det är tretton stammar som går in i det nya landet är det bara tolv stammar som får landområden. Levi har inte ett eget område (Herren är deras arv, se 5 Mos 18:19-20). Det finns flera samband mellan talet 13 och talet 1. Det hebreiska ordet för räknetalet ett är echad. Ordet består av tre bokstäver alef (talvärde 1), chet (talvärde 8) och dalet (talvärde 4). Summan av talvärdena för dessa tre bokstäver är 13. Inom judendomen är 13 det nummer som krävs för att starta något nytt. Talet ett tillsammans med tretton förekommer på många områden. När en pojke når tretton års ålder (och firar bar mitsvah) räknas han som en man och ”blir ett” med folket. ");
INSERT INTO swe_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakob kallade på sina söner och sa: Samla ihop er tillsammans, så att jag kan berätta för er vad som ska ske (hända) med er vid dagarnas slut. Redan från födseln hade Jakobs liv varit kantat med stridigheter inom familjen men även en brottningskamp med Gud, se 1 Mos 25:26, 33; 28:12; 32:25. Här i livets slutskede profeterar han från djupet av sin ande över sina söner. Profetiorna baseras både på deras karaktär och handlingar. Dessa ord är både välsignelser över sönerna och profetior om framtiden, därav uttrycket vid dagarnas slut, eftersom en del av det som sägs inte kommer att fullbordas förrän i ändens tid. ");
INSERT INTO swe_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Församla er och lyssna, Jakobs söner, till Israel, er far. Uppräkningen av de tolv sönerna i detta kapitel följer mödrarna (Leah, Bilhah, Zilpah och Rakel) och födelseordningen. I GT finns 28 uppräkningar, baserade på:  • Födelseordning (1 Mos 29:31-30:24; 35:23-26).  • Förhållande till tabernaklet (4 Mos 2).  • Tilldelat landområde (Hes 48).  • De tolv portarna (Hes 48:30-35).  I NT finns två uppräkningar i Upp 7:4-8; 21:12. ");
INSERT INTO swe_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubenbetyder ”se en son” du är min förstfödde, min makt och förstlingsfrukten av min styrka, överlägsen i värdighet och överlägsen i styrka. ");
INSERT INTO swe_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Instabil som vatten utan förmåga till självdisciplin saknar du överlägsenheten, eftersom du steg upp i din fars bädd, där orenade du den, han steg upp till min bädd. ");
INSERT INTO swe_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon och Levi är bröder – våldets vapen är deras blodsband. Simeon betyder ”att höra”; Levi ”sammanfogad med”. ");
INSERT INTO swe_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Låt inte min själ komma till deras rådslag, må aldrig min heder bli förenad med deras sällskap, för i sin vrede slaktar de män och med sin godtyckliga nåd (vilja – hebr. ratson) lemlästar de oxar. ");
INSERT INTO swe_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Förbannad är deras vrede, för den är häftig och deras ilska, för den är grym. Jag ska dela dem i Jakob och förskingra dem i Israel. ");
INSERT INTO swe_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judabetyder ”lovprisning”, dig ska dina bröder prisa, din hand ska vara på dina fienders nacke, dina fäders söner ska böja sig ner inför dig. ");
INSERT INTO swe_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda är ett lejons unge, från bytet har du stigit upp. Han lutar sig ner, han lägger sig som ett lejon, som en lejoninna – vem ska resa upp honom? ");
INSERT INTO swe_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Spiran ska inte lämna Juda, inte härskarstaven från hans fötter, så länge man kommer till Shilo (till dess han kommer som den tillhör) en referens till Messias, och till honom ska folkens lydnad vara. ");
INSERT INTO swe_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Han binder sin åsna (unga laståsna av hankön; sin unga och spänstiga åsnehanne) vid vinstocken och sitt åsneföl av hankön vid den ädla rankan som ger det utvalda vinet. Han tvättar sina kläder ordagrant: sitt klädesplagg i vin och sin dräkt sin mantel i druvans juice (blod). ");
INSERT INTO swe_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Hans ögon ska bli röda med vin och hans tänder vita med mjölk. Hebr. shiloh i vers 10 är sannolikt inte någon geografisk plats utan snarare ett uttryck för att Messias ska komma som den som rättmätigt ska styra med spiran som omnämns i denna vers. Själva ordet är den feminina formen för viloplats. Därför kan man tänka sig att spiran/härskarstaven ska vila mellan Messias fötter utifrån hur hebreiskan är formulerad här. Med den betydelsen blir det väldigt tydligt att denna välsignelse är profetisk och talar om Jesus, Lejonet av Juda, som i tusenårsriket ska ha härskarstaven i sin hand och åtnjuta folkens lydnad. ");
INSERT INTO swe_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulonhebr. Zevolun betyder ”upphöjd” ska bo vid havets strand och han ska bli en strand (hebr. chof) (säker hamn – hebr. chof) för skepp och hans sida landsgräns ska vändas mot Sidon. Sebulon välsignas före sin äldre bror Isaskar. Denna profetia är intressant eftersom det landområde som Sebulon så småningom tilldelas inte ligger varken vid Medelhavskusten eller Galileiska sjön, utan i ett litet område däremellan. Med tiden får de ändå tillgång till både Medelhavet och Galileiska sjön, eftersom Via Maris går genom deras område och de utmärker sig senare som just sjöfarare. ");
INSERT INTO swe_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaskarbetyder ”det finns gottgörelse” är en storvuxen åsna, som ligger ner mellan två fårfållor (lägerplatser, bördor). ");
INSERT INTO swe_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Han såg en viloplats, att den var god (bördig, bekväm) och att landet var tilltalande (vackert, prunkande, rofyllt). Han böjde sin skuldra (ryggen) till att bära (bördor) och blev en plikttrogen tjänare i sitt arbete. Ordet fårfållor (hebr. mispetayim) i vers 14 är svåröversatt. Ordet står i dualis, vilket verkar betyda att åsnan har lagt sig mellan två föremål/platser av samma sort. Eftersom vers 15 talar om viloplats och bördor kan betydelsen ha med dessa ord att göra. Isaskars söner omnämns som ”män som förstod tidens tecken och insåg vad Israel borde göra”, se 1 Krön 12:13. ");
INSERT INTO swe_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Danbetyder ”domare” ska döma (skaffa rätt) sitt folk som en av Israels stammar. ");
INSERT INTO swe_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ska vara en orm på vägen, en behornad orm på den vältrampade (välkända och av många använda) vägen, som biter hästens häl så att ryttaren faller baklänges. ");
INSERT INTO swe_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","På din frälsning (räddning) väntar jag, Herre (Jahveh). Mitt i välsignelsen av sina söner vänder sig Jakob direkt till Herren (Jahveh). Denna vers är första gången ordet ”frälsning” (hebr. yesua) används i Bibeln. ");
INSERT INTO swe_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadbetyder ”en som skär” – attackeraren ska skära (attackera) honom men han ska skära (attackera) dem fienden i hälen där de är sårbara, på flykten. Namnet Gad betyder korianderfrö men även trupp eller stor folkskara. Roten kommer från verbet gadad som betyder att skära, attackera eller invadera, alltså beskrivningar på vad en militär trupp gör. Tillsammans med Ruben och Manasse låg Gads område mellan moabiterna i söder, ammoniterna i öster och araméerna i nordost. På grund av alla krigen för sin existens blev de kända som krigsmän, se 1 Krön 5:18; 12:8, 12. ");
INSERT INTO swe_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Från Asherbetyder ”lycklig” kommer rikliga (överflödande, mättande) rätter och han ska ge mat till kungliga nöjen (rikligt uppdukade festbord). ");
INSERT INTO swe_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftalibetyder ”brottning” är en hind som blivit fri, han ger goda ord (talar välsignelse, uppmuntran och tröst). Detta är en profetia om att lärjungarna ska förkunna evangeliet, de goda orden, det glada budskapet. Nästan alla Jesu lärjungar kommer från Sebulons och Naftalis stammar, eftersom dessa båda stammar beblandade sig i området vid Gennesarets sjö som ursprungligen tilldelades Naftali och var området där Jesus kallade de flesta lärjungarna. Nasaret ligger i Sebulons område och Kapernaum i Naftalis område. ");
INSERT INTO swe_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josefbetyder ”låt honom förökas – vara bärare av riklig frukt” är en fruktbärande son, en fruktbärande son vid källan, döttrarna marscherar över muren. ");
INSERT INTO swe_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bågskyttarna har varit hätska mot honom och skjutit på honom och hatat honom. ");
INSERT INTO swe_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Likväl var hans båge fast (stadig, stabil) och hans armar och händer smidiga (snabba och lättrörliga), genom händerna hos den Mäktige i Jakob, därifrån (från) Herden, Israels klippa, ");
INSERT INTO swe_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","genom din fars Gud (El) som hjälper dig, och den Allsmäktige (Shaddaj) som ska välsigna dig med välsignelser från himlarna därovan, välsignelser från djupet underjordiska källor som vilar (breder ut sig) därunder, välsignelser från bröst och moderliv. ");
INSERT INTO swe_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Din fars välsignelser har vida överträffat (har varit mäktigare än) mina förfäders välsignelser, upp till den yttersta gränsen av de eviga kullarna. De ska vara över Josefs huvud, och över hjässan på honom som är avskild (helgad – hebr. nazir) från sina bröder. 5 Mos 33:16; 4 Mos 6:2 Josef är kanske den mest tydliga förebilden på Jesus i GT. Josef var en ”fruktbärande son”, se vers 22 och Jesus kallas vinstocken och de som är sammankopplade ska bära frukt, se Joh 15:5; Gal 5:22-23. Josef kallas en ”son vid källan” och Jesus är livets källa, se Joh 4:14. ");
INSERT INTO swe_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjaminbetyder ”högra sonens hand” eller ”min högra hands son” är en rovlysten varg, på morgonen slukar han bytet och på kvällen fördelar han rovet. Benjamin var den yngste och minste av Israels söner. Han har sitt område i norra Jerusalem. Tempelberget tillhör Benjamins område tillsammans med ett område norrut, medan Olivberget och Västra berget i Jerusalem tillhör Juda tillsammans med områden söderut som bland annat inkluderar Betlehem och Hebron. Gud utvalde alltså ett område för sin boning, templet här på jorden, i den minsta stammens område. Guds högra hand är också ett uttryck för hans styrka. Det kan också syfta på Jesus som är på Guds högra sida och den delen av gudomen som ska sitta på Tempelberget och regera från Jerusalem i tusenårsriket.  Benjamins stam var känd för att vara krigare. Ett par exempel på personer från Benjamins stam är Ehud (Dom 3:15) och kung Saul (1 Sam 9:21). I NT nämns Saulus som var en benjaminit som stred i trons goda kamp, se Fil 3:5; 2 Tim 4:7. ");
INSERT INTO swe_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Alla dessa är Israels tolv stammar, och detta är det som deras far talade till dem och välsignade dem, var och en i enlighet med hans välsignelse, välsignade han dem. Detta är första gången frasen ”Israels tolv stammar” används. När landet så småningom delas upp inkluderas inte Levi; däremot blir Josefs två söner ledare för två stammar. Manasse och Efraim tar Josefs och Levis plats. ");
INSERT INTO swe_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Han befallde och sa till dem: ”Jag är på väg att samlas till mitt folk, begrav mig med mina fäder i grottan som finns på hettiten Efrons fält, ");
INSERT INTO swe_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","i grottan på Machpelas fält framför Mamre, i Kanaans land, som Abraham köpte, med fältet från hettiten Efron som en egendom och begravningsplats. ");
INSERT INTO swe_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Där begravde de Abraham och Sarah, hans hustru. Där begravde de Isak och Rebecka, hans hustru, och där begravde jag Leah. ");
INSERT INTO swe_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Fältet och grottan som är där, som köptes från hettiternas söner.” ");
INSERT INTO swe_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","När Jakob hade slutat att befalla sina söner, samlade han ihop (drog upp) sina fötter i sängen och andades sitt sista andetag och blev samlad till sitt folk. ");
INSERT INTO swe_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Då föll Josef ner över sin fars ansikte, grät över honom och kysste honom. ");
INSERT INTO swe_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Josef befallde sina tjänare, läkarna, att balsamera hans far och läkarna balsamerade Israel Jakob. ");
INSERT INTO swe_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Det tog 40 dagar, vilket är så många dagar en balsamering tar. Egyptierna grät över honom i 70 dagar. De 70 dagarna inkluderar troligtvis de 40 dagar som det tog att balsamera, följt av 30 dagars sorg, se 5 Mos 34:8. ");
INSERT INTO swe_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","När sorgedagarna var över talade Josef till faraos hus och sa: ”Om jag har funnit nåd (oförtjänt kärlek) i era ögon, tala då, jag ber er, i faraos öra och säg: ");
INSERT INTO swe_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Min far tog en ed av mig och sa: ”Se, jag ska snart dö. Du måste begrava mig i min grav som jag har grävt ut för mig själv i Kanaans land” Så, vänligen, låt mig nu gå upp och begrava min far och sedan återvända.” ");
INSERT INTO swe_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao svarade: ”Gå upp och begrav din far i enlighet med eden som du gav honom.” ");
INSERT INTO swe_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Josef gick upp och begravde sin far, och med honom gick faraos tjänare upp, de äldste i hans hus och alla äldste i Egyptens land, ");
INSERT INTO swe_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","och alla av Josefs hus och hans bröder. Bara sina små (barn) och sin småboskap och hjordarna, lämnade de i Goshen. ");
INSERT INTO swe_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Med honom gick både vagnar och ryttare och det var ett stort sällskap. ");
INSERT INTO swe_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","De kom till Atads tröskplats på andra sidan floden Jordan. Där sörjde de och jämrade sig högljutt. Han sörjde sin far i sju dagar. ");
INSERT INTO swe_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","När landets invånare, kanaanéerna, såg sorgen på Atads tröskplats sa de: ”Detta är en djup sorg för egyptierna.” Därför fick den namnet Evel-Mitsraim (betyder Egyptens klagan eller sorgesång), som ligger bortom Jordan. ");
INSERT INTO swe_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hans söner gjorde mot honom i enlighet med hans befallning till dem. ");
INSERT INTO swe_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Hans söner bar honom till Kanaans land och begravde honom i grottan på Machpelas fält, som Abraham köpte med fältet som en egendom och begravningsplats från hettiten Efron, framför Mamre. ");
INSERT INTO swe_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Efter att han begravt sin far, återvände Josef till Egypten, han och hans bröder och alla som gått upp med honom för att begrava hans far. ");
INSERT INTO swe_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","När Josefs bröder såg (började inse konsekvenserna av) att deras far Jakob var död, sa de: ”Vad händer om Josef hatar oss (är bitter och långsint) och nu kommer att hämnas för allt ont vi gjort mot honom?” ");
INSERT INTO swe_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Därför skickade de ett bud till Josef som löd så här: ”Innan din far dog ");
INSERT INTO swe_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","bad han oss meddela dig, Josef, detta: ’Jag ber dig Josef, var snäll och förlåt dina bröders synder och allt illa de gjort mot dig.’ Vi, tjänare åt din fars Gud (Elohim), ber dig att förlåta oss.” När Josef hörde hur de talade brast han i gråt. ");
INSERT INTO swe_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sedan kom också hans bröder och föll ner framför honom och sa: ”Här är vi, vi är dina slavar.” ");
INSERT INTO swe_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Men Josef svarade dem: ”Var inte rädda, skulle jag ta Guds plats? ");
INSERT INTO swe_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ni ville skada mig, men som ni kan se har Gud vänt det till något gott, för att rädda många människors liv. ");
INSERT INTO swe_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Var inte rädda, jag ska försörja er och era barn.” Sedan tröstade Josef dem och talade till deras hjärta (uppmuntrade dem). Samma tanke utvecklas av Paulus i Rom 8:28. Gud vänder det som var tänkt att skada till att verka för hans syften. ");
INSERT INTO swe_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef bodde i Egypten, han och hans fars hus (hela hans släkt), och Josef blev 110 år. Enligt egyptiska inskriptioner och texter var just 110 år den idealiska åldern. Även Josua blev 110 år, se Jos 24:29. ");
INSERT INTO swe_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josef såg sin andra son Efraims söner till den tredje generationen; även Manasses son, Machir Josefs barnbarn, blev far till barn som lades på Josefs knän. Manasse var Josefs förstfödde, vars son hette Machir, se 4 Mos 26:29; 32:39-40. Att ”lägga på Josefs knän” anspelar på den sed där det nyfödda barnet lades på knäna, först på fadern, som genom att ta emot det erkände barnet som sitt eget och sedan modern, se 1 Mos 30:3. Josef adopterade sina barnbarn och barnbarnsbarn, vilket betyder att de fick del av hans välsignelse och arv, se även 1 Mos 30:3. ");
INSERT INTO swe_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josef sa till sina bröder: ”Jag dör, men Gud (Elohim) ska verkligen besöka er (hebr. paqad paqad) och föra er upp, ut ur detta land, exakt som han gav sin ed (lovade) till Abraham, till Isak och till Jakob.” ");
INSERT INTO swe_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Josef tog en ed av Israels söner och sa: ”Gud ska verkligen besöka er och då när ni lämnar Egypten ska ni bära med er mina ben härifrån” Hebr. paqad är ett rikt ord som betyder att se, besöka, komma ihåg och kan även användas för att räkna och mönstra. Ordet upprepas två gånger både här och i vers 24, detta förstärker och försäkrar att Gud ska se och beskydda israeliterna. ");
INSERT INTO swe_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Så dog Josef, han blev 110 år. De följde den egyptiska seden och balsamerade honom och lade honom i en kista i Egypten. Utifrån undersökningar av mumier var livslängden i Egypten 40-50 år. När israeliterna flera hundra år senare lämnar Egypten fullföljer Mose detta löfte, se 2 Mos 13:19, och Josef blir begravd i Shechem, se Jos 24:32. Enligt judisk tradition är det dessa män som fullföljt detta uppdrag som får möjlighet att fira pesach sheni (den andra påsken), se 4 Mos 9:6-14. Berättelsen om Josef avslutas med att israeliterna kommer till Egypten. Här lever de i generation efter generation, medvetna om att deras framtid är i ett annat land, ett löftesland, som de flesta av dem inte sett.");
INSERT INTO swe_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Och namnen på Israels söner, de som kom tillsammans med sina familjer från Kanaans land på grund av en stor hungersnöd till Egypten (hebr. Mitsrajim), var: ");
INSERT INTO swe_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben (hebr. Reoven), Simeon (hebr. Shimon), Levi och Juda (hebr. Jehoda); ");
INSERT INTO swe_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaskar (hebr. Jisashchar), Sebulon (hebr. Zevolun) och Benjamin (hebr. Binjamin); ");
INSERT INTO swe_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan och Naftali; Gad och Asher. ");
INSERT INTO swe_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","De som härstammade från Jakob hans tolv barn och barnbarn var då sammanlagt sjuttio personer. Josef var redan i Egypten. ");
INSERT INTO swe_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tiden gick och Josef dog, och det gjorde även hans bröder. Snart var hela den första generationen som kom till Egypten borta. ");
INSERT INTO swe_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Men israeliterna var fruktsamma och förökade sig, de växte till och blev mycket starka (talrika) och hela landet fylldes av dem. Gud uppfyllde sitt löfte till Abraham, Isak och Jakob – israeliterna hade blivit ett stort folk. De hade blivit så stora att de var ett eget folk bland egyptierna.  Det hebreiska namnet för Egypten är Mitsrajim. Det ordet användes inte av egyptierna själva, de hade namnet Tavi som betyder ”två länder” och troligtvis syftar på övre och nedre Egypten. Det hebreiska ordet Mitsrajim härstammar från Chams (Hams) andra son Mitsrajim (1 Mos 10:6). Ordet står i formen dual, vilket kan ha att göra med kopplingen till det övre och nedre Egypten. Betydelsen är inte helt känd, men ordet liknar det hebreiska matsor som betyder belägring och att vara inträngd. Här kan finnas en geografisk koppling till det smala ”inträngda” landet längs med floden Nilen. Civilisationen är ju centrerad kring just Nilen och landet är ”dubbelt” inträngt på var sin sida av den. Att Bibeln väljer att använda detta beskrivande ord för Egypten, gör att berättelsen blir mer generell och kan appliceras på alla möjliga situationer och områden som ”tränger in” och vill förslava en människa. Stegen för befrielse där t.ex. familjen spelar en viktig roll (den behöver samlas och återupprättas innan uttåget kan ske, se 2 Mos 12:3-4) kan även appliceras i vårt samhälle idag. ");
INSERT INTO swe_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Egypten fick en ny kung som inte kände till Josef hur han räddat landet från hungersnöd och gjort Egypten till ett mäktigt rike. Jakobs son Josef såldes som slav av sina egna bröder. Men trots motgångar välsignade Gud honom i Egypten och han blir till sist faraos högra hand. Han hade fått förmåga att tyda drömmar. Under sju goda år byggde landet upp ett spannmålslager som gjorde att de klarade sju svåra år då skördarna slog fel. Man sålde även till kringliggande länder vilket gjorde Egypten rikt, se 1 Mos 40-41. I den egyptiska historien skedde ett tydligt skifte mellan den sjuttonde och den artonde dynastin. Hyksosfolket som regerat Egypten under 100 år besegrades. Den nya kungen skulle i så fall vara farao Amose som kom till makten i det nya riket någon gång omkring 1550 f.Kr. ");
INSERT INTO swe_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kungen sa till sitt folk: ”Se, israeliterna har blivit för många och för starka för oss. ");
INSERT INTO swe_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nu måste vi handla klokt i den här situationen. Annars blir de ännu fler och om det blir krig kan de alliera sig med våra fiender och kämpa mot oss, och sedan ge sig av härifrån.” Planen för att minska folkmängden var hårt arbete och fattigdom, vilket indirekt skulle leda till att många dog i förtid. ");
INSERT INTO swe_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Därför satte man slavdrivare över israeliterna för att förtrycka dem med hårt arbete. De tvingade dem att bygga förrådsstäderna Pitom och Ramses för att härbärgera skördar åt farao. ");
INSERT INTO swe_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Men ju mer man förtryckte dem, desto fler blev de och desto mer bredde de ut sig. På grund av detta kände sig egyptierna ännu mer hotade. ");
INSERT INTO swe_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Israeliterna tvingades då till ren slavtjänst. ");
INSERT INTO swe_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Egyptierna förbittrade israeliternas liv genom att ge dem tungt arbete med lera och tegel och alla möjliga sorters arbete på fälten. De plågade sina israeliska slavar tills allt arbete var gjort. Den första åtgärden med hårt arbete fungerade inte, så farao vidtar mer direkta åtgärder för att begränsa antalet israeliska män. ");
INSERT INTO swe_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Den egyptiske kungen talade med de hebreiska barnmorskorna, en av dem hette Shifra ”den vackra” och den andra Pua ”den glänsande”. Israeliterna var så många att det är troligt att Shifra och Pua var de som ansvarade över alla hebreiska barnmorskor. Namnen på dessa två gudfruktiga kvinnor nämns i texten, medan den dåtida ”viktiga” kungen inte namnges. ");
INSERT INTO swe_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Han sa: ”När ni hjälper de hebreiska kvinnorna vid förlossningen ska ni se efter om det är en pojke eller flicka. Är det en pojke så döda honom, är det en flicka så låt henne leva.” ");
INSERT INTO swe_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Men barnmorskorna fruktade (ärade och tillbad) Gud och gjorde inte som egyptiernas kung sagt till dem, utan lät pojkarna leva. ");
INSERT INTO swe_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Då kallade kungen till sig dem igen och sa: ”Varför gör ni så att pojkarna får leva?” ");
INSERT INTO swe_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Barnmorskorna svarade farao: ”De hebreiska kvinnorna är inte som de egyptiska, de är fysiskt starkare, och de har redan fött innan barnmorskan kommer till dem.” ");
INSERT INTO swe_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Gud beskyddade barnmorskorna, och folket ökade snabbt i antal och blev stort. ");
INSERT INTO swe_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Eftersom barnmorskorna fruktade (ärade och tillbad) Gud, lät Gud deras hus växa. ");
INSERT INTO swe_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Då gav farao denna befallning till hela sitt folk: ”Alla pojkar som föds måste kastas i floden Nilen, men alla flickor kan ni låta leva.” Att gå emot detta bud var antagligen förenat med dödsstraff. ");
INSERT INTO swe_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","En man från Levis släkt gifte sig med en dotter från Levis släkt. Mannen hette Amran och kvinnan Jocheved, se 2 Mos 6:20. Levi var den stam som var avdelad att vara präster och lovsångare. Mellan vers ett och två passerar sexton år. Familjen har två barn, tonårsdottern Mirjam och sonen Aron som är tre år, se 2 Mos 2:8; 7:7. ");
INSERT INTO swe_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Hustrun blev gravid för tredje gången och födde en son. När hon såg att han var frisk (vacker, god) gömde hon honom i tre månader. Apg 7:20; Heb 11:23 ");
INSERT INTO swe_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","När hon inte längre kunde dölja honom, tog hon en korg av papyrusgräs och strök på jordbeck och tjära för att göra den vattentät. Sedan lade hon barnet i korgen (arken) och satte ut den i vassen vid strandkanten av floden Nilen. Samma hebreiska fras (tóv meód) som när Gud sa ”det är mycket gott” när han skapat människorna i 1 Mos 1:31 använder Jocheved här när hon säger att hennes barn var ”mycket vackert”. Ordet för ”korg” (hebr. teva) som Moses mor gör i ordning, används även i 1 Mos 6:14 om arken som räddade Noa och hans familj. ");
INSERT INTO swe_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hans syster tonårsdottern Mirjam ställde sig (positionerade sig) en bit därifrån för att se hur det skulle gå för honom. ");
INSERT INTO swe_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Då kom faraos dotter ner för att bada i floden. Hennes väninnor (unga kvinnor) gick vidare längs med strandkanten. När faraos dotter fick se korgen mitt i vassen skickade hon dit sin tjänarinna för att hämta den. ");
INSERT INTO swe_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","När hon öppnade den såg hon den lille pojken. Han grät och hon fick medlidande med honom och sa: ”Detta är ett av de hebreiska barnen.” ");
INSERT INTO swe_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Då sa hans syster Mirjam till faraos dotter: ”Ska jag gå och hämta en hebreisk ammande kvinna, så hon kan amma barnet åt dig?” ");
INSERT INTO swe_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraos dotter sa till henne: ”Ja gå.” Då gick den unga tonårsflickan och kallade dit barnets mor. ");
INSERT INTO swe_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Faraos dotter sa till henne Jocheved, barnets mor: ”Tag med dig detta barn och amma det åt mig, jag ska ge dig lön för det.” Så kvinnan tog barnet och ammade det. ");
INSERT INTO swe_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","När barnet blev större antagligen 3-4 år gammalt tog hon honom till faraos dotter, och han blev hennes son. Hon gav honom namnet Mose (hebr. Mosheh), för hon sa: ”Jag har dragit upp (hebr. mashah) honom från vattnet.” Namnet Mose kan relatera till egyptiska ord för ”son” eller ”att föda en son”. Här ges förklaringen till namnet hur han drogs upp, där det finns en likhet med det hebreiska verbet för att dra upp. Kanske pratade prinsessan hebreiska, eller i kontakten med Moses föräldrar och familj lärde hon sig några ord och bestämde sig för detta namn. Det är möjligt att han fick detta namn av sina föräldrar redan i samband med omskärelsen den åttonde dagen. Oavsett hur, så hedrar prinsessan medvetet sin sons hebreiska ursprung och gör honom samtidigt till en legitim egyptier med ett namn på sitt eget språk som understryker att hon adopterar en son. Berättelsen hoppar nu ungefär 36 år framåt i tiden. Mose var omkring 4 år när han blev adopterad, och är nu 40 år gammal, se Apg 7:23-30 och 2 Mos 7:7. ");
INSERT INTO swe_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En dag, när Mose hade växt upp, gick han ut till sina bröder sitt folk – israeliterna och såg deras tunga arbete. Han fick se hur en egyptisk man slog en av hans bröder. ");
INSERT INTO swe_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Han tittade sig omkring, och när ingen såg på slog han ihjäl egyptiern och gömde kroppen i sanden. ");
INSERT INTO swe_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Han gick ut nästa dag och såg två av sina hebreiska bröder slåss med varandra. Då sa Mose till den som startat bråket: ”Varför slår du din landsman?” ");
INSERT INTO swe_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Han svarade: ”Vem har satt dig till herre och domare över oss? Tänker du döda mig som du dödade egyptiern igår?” Då greps Mose av panik och tänkte: ”Det jag har gjort måste ha blivit känt.” ");
INSERT INTO swe_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Hans farhågor stämde och ryktet spred sig fort. När farao fick höra vad som hänt, ville han döda Mose. Men Mose flydde undan farao österut ända till midjaniternas land där han stannade. Där satte han sig ner vid en brunn. ");
INSERT INTO swe_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nu var det så att prästen i Midjan hade sju döttrar. Mose satt vid brunnen och vilade sig efter sin resa. Döttrarna kom och öste upp vatten och fyllde hoarna för att ge vatten till sin fars får. ");
INSERT INTO swe_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","När några herdar kom och körde i väg dem, försvarade Mose dem och hjälpte sedan till att ge vatten till deras får. ");
INSERT INTO swe_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","När döttrarna kom hem till sin far Reguel som betyder ”Guds vän”, han kallas också Jetro frågade han: ”Varför är ni hemma så tidigt i dag?” ");
INSERT INTO swe_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","De svarade: ”En egyptisk man hjälpte oss mot herdarna. De andra herdarnas trakasserier mot dem verkade vara något de var vana vid. Han öste även upp vatten åt oss och lät fåren dricka.” ");
INSERT INTO swe_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Då sa han till sina döttrar: ”Var är han nu? Varför lämnade ni honom där vid brunnen? Gå och hämta honom och bjud in honom på middag.” ");
INSERT INTO swe_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","De hittade Mose och han tackade ja till inbjudan. Mose var villig (kom överens om) att stanna hos prästen. Mose fick så småningom prästen Jetros dotter Sippora till hustru. ");
INSERT INTO swe_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Hon födde en son och han gav honom namnet Gershom, ”eftersom jag är en främling i detta land”, sa han. Mose hade nu blivit en medborgare hos midjaniterna, långt borta från både landet Egypten och hans eget folk, israeliterna. På hebreiska är ger främling och shom där, så sammantaget är Gershom ”Jag var en främling där” i det land där hans son föddes. Enligt Demetrius, en historiker i Alexandria 225 f.Kr., så kom namnet Midjan från en av Abrahams söner. Han skriver också att Mose och Sippora båda härstammade från Abraham. Mose i sjunde och Sippora i sjätte led. ");
INSERT INTO swe_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Många år senare dog Egyptens kung som var ute efter Mose liv. Israeliterna fortsatte att sucka på grund av sitt slaveri. De ropade i sin nöd, och deras klagan steg upp till Gud. ");
INSERT INTO swe_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","När Gud hörde deras jämmer tänkte han på sitt förbund med Abraham, Isak och Jakob. ");
INSERT INTO swe_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Gud såg situationen som israeliterna var i, och brydde sig om (förstod, glömde inte) dem. ");
INSERT INTO swe_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose vallade fåren åt sin svärfar Jetro (hebr. Jitro), som var präst i Midjan. En gång drev han fåren bortom öknen och kom till Guds (Elohims) berg Horeb (hebr. Chorev) annat namn på Sinai berg. Mose är nu 80 år, han lämnade Egypten vid 40-års ålder och har vallat sin svärfars får sedan dess, se Apg 7:30. Chorev delar rot med ordet för torr/öde (hebr. charev), vilket indikerar att berget och området är öken. Ordet delar även rot med ordet cherev som betyder svärd. Det får en djupare innebörd då vi vet att Guds ord beskrivs som ett svärd (Heb 4:12) och det var på detta berg som Gud senare skulle ge dem undervisningen, Torah, som är den grundläggande delen av Guds ord. ");
INSERT INTO swe_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Herrens ängel (utsände budbärare) uppenbarade sig för honom i en eldslåga mitt i en törnbuske. Den som talar ur busken kallas både Herrens ängel och Gud. En allmänt accepterad uppfattning är att det är Jesus preinkarnerad, dvs. Jesus som uppenbarar sig som en Herrens ängel innan han tar mänsklig gestalt. Mose tittade och såg att törnbusken brann av elden, men törnbusken blev inte förtärd. ");
INSERT INTO swe_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Så Mose sa (tänkte för sig själv): ”Jag går dit (lämnar flocken) för att se denna märkliga syn! Varför brinner inte törnbusken upp?” ");
INSERT INTO swe_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","När Herren såg att han gick för att se efter, ropade Gud till honom ur törnbusken: ”Mose! Mose!” Han svarade: ”Här är jag.” Det hebreiska ordet för törnbuske är seneh, snarlikt Sinai. Ordet används bara här och i 5 Mos 33:16. Den exakta arten på busken är inte känd, men ordet beskriver en buske med taggar. Antagligen är det ett mindre akaciaträd, samma träslag som Mose senare får instruktionen att använda som material för tabernaklet, förbundsarken och skådebrödsbordet, se 2 Mos 25:10, 23; 26:15. Törne är förknippat med det mänskliga och förbannelsen, se 1 Mos 3:18, men genom historien vänder Gud på den förbannelsen. Mose får se Gud ta sin boning i en oansenlig törnbuske och senare manifestera sin närvaro i förbundsarken av akaciaträ. Finalen sker då Jesus, krönt med en törnekrona, bär världens synd på korset. ");
INSERT INTO swe_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Gud sa: ”Kom inte närmare! Ta av dig dina sandaler, för den plats du står på är helig mark.” Det är på grund av Guds närvaro som det blir en helig, en från världen avskild, plats. ");
INSERT INTO swe_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Han fortsatte: ”Jag är din fars Gud, Abrahams Gud, Isaks Gud och Jakobs Gud.” Då dolde Mose sitt ansikte, för han var rädd för att se på Gud. ");
INSERT INTO swe_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Herren sa: ”Jag har verkligen sett (det har inte undgått mig) hur mitt folk plågas i Egypten. Jag har hört deras klagorop, på grund av deras slavdrivare. Jag känner väl till deras lidande. ");
INSERT INTO swe_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Därför har jag kommit ner för att befria dem från egyptierna och föra upp dem från detta land till ett land som både är gott och rymligt och som flödar av mjölk och honung, det område där det nu bor kanaanéer, hettiter, amoréer, perisséer, hivéer och jevuséer. Trots egentligen ogynnsamma förhållanden med hög luftfuktighet och hetta har Israel drastiskt ökat sin mjölkproduktion sedan 1950-talet, då en ko i genomsnitt producerade 4 000 liter mjölk per år, till otroliga 12 000 liter de senaste åren. Varje år på kvällen som inleder veckohögtiden shavuot (pingsten på våren) släpps ”mjölk- och honungsrapporten” från den israeliska statistiska centralbyrån. Israel är det land i världen som leder statistiken överlägset med över 30% över USA som kommer på andra plats. En israelisk ko producerade 2019 i genomsnitt 11 852 liter mjölk per år, medan motsvarande siffra i Sverige var omkring 9 000 liter. Genomsnittet i Europa var 6 000 liter och i Indien 1 000 liter. ");
INSERT INTO swe_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Se, israeliternas rop har nått mig, och jag har också själv sett hur egyptierna förtrycker (torterar) dem. ");
INSERT INTO swe_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Därför ska du gå nu, så jag kan sända dig till farao och du ska föra mitt folk, israeliterna, ut ur Egypten.” Nu följer en dialog mellan Mose och Gud. Mose kommer med fyra ursäkter till varför han inte vill gå och till sist säger han rent ut, sänd någon annan, se 2 Mos 4:13. ");
INSERT INTO swe_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Men Mose sa till Gud: ”Vem är jag, att jag skulle gå till farao och att jag skulle föra israeliterna ut ur Egypten?” ");
INSERT INTO swe_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Gud svarade: ”Jag ska verkligen vara med dig (jag är med nu och kommer alltid att vara med dig). Detta ska vara tecknet för dig att jag har sänt dig: När du har fört folket ut ur Egypten, ska ni tjäna Gud på detta berg.” Detta är inledningen till Guds förklaring av sitt namn. Det viktiga är inte tjänarens kvalifikationer, utan vem Gud är och att han är med sin tjänare, då är inget omöjligt. ");
INSERT INTO swe_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Men Mose sa till Gud: ”Anta att jag skulle gå till israeliterna och säga: ’Era fäders Gud har sänt mig till er’, och de frågar mig: ’Vad är hans namn?’ Vad skulle jag svara dem?” ");
INSERT INTO swe_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gud sa till Mose: ”JAG ÄR den JAG ÄR (jag har alltid varit närvarande, jag är det nu och kommer alltid att vara det). Du ska säga så här till israeliterna: ’JAG ÄR har sänt mig till er.’ ” ");
INSERT INTO swe_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Gud sa också till Mose: ”Så här ska du säga till israeliterna: ’Herren (Jahveh), era fäders Gud (Elohim) – Abrahams Gud, Isaks Gud och Jakobs Gud – har sänt mig till er.’ Detta är mitt namn för evigt, och så ska jag åkallas från släkte till släkte. ");
INSERT INTO swe_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Gå nu och kalla samman Israels äldste och säg till dem: ’Herren (Jahveh), era fäders Gud (Elohim) – Abrahams, Isaks och Jakobs Gud (Elohim) – har uppenbarat sig för mig och sagt: Jag har sett vad som händer er i Egypten, ");
INSERT INTO swe_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","och jag har beslutat att föra er bort från förtrycket i Egypten upp till kanaanéernas, hettiternas, amoréernas, perisséernas, hivéernas och jevusiternas land. Till ett land som flödar av mjölk och honung.’ ");
INSERT INTO swe_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","De Israels äldste kommer att lyssna på dig. Sedan ska du och Israels äldste gå till den egyptiska kungen och säga: Herren (Jahveh), hebréernas Gud, har visat sig för oss. Vi ber dig om tillåtelse att gå tre dagsresor in i öknen och offra åt Herren vår Gud. ");
INSERT INTO swe_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Men jag vet redan att Egyptens kung inte kommer låta er gå frivilligt. Nej, inte ens av en mäktig hand någon mänsklig armé. ");
INSERT INTO swe_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Så jag ska sträcka ut min hand och slå Egypten med en serie av iögonfallande tecken. Sedan ska han släppa er. ");
INSERT INTO swe_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Jag ska göra så att egyptierna kommer att behandla detta folk som är mitt folk väl. När ni lämnar Egypten ska ni inte gå därifrån tomhänta. ");
INSERT INTO swe_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Varje hebreisk kvinna ska fråga sin egyptiska grannfru, och andra kvinnor som råkar vara i hennes hus, efter föremål av silver och guld och även kläder. Dessa ska ni klä era söner och döttrar med. På det sättet ska ni plundra egyptierna på det som tillhör er, det som undanhållits er genom slaveriet.” ");
INSERT INTO swe_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose svarade: ”Men tänk om de inte tror mig eller lyssnar på vad jag säger, utan säger: ’Herren (Jahveh) har inte visat sig för dig’? ” ");
INSERT INTO swe_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Då sa Herren (Jahveh) till honom: ”Vad har du i din hand?” ");
INSERT INTO swe_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Han svarade: ”En fåraherdes stav.” Herren sa: ”Kasta den på marken.” Han kastade den på marken, och den förvandlades till en orm (hebr. nachash), och Mose ryggade tillbaka av rädsla. Att använda en orm som ett tecken skulle vara något som rörde om i deras begreppsvärld, eftersom kobran var en av de religiösa symbolerna i Egypten. ");
INSERT INTO swe_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Men Herren sa till Mose: ”Sträck ut din hand och ta den i stjärten.” Mose övervinner sin rädsla. Han sträckte ut sin hand och tog den, och ormen blev åter en stav i hans hand. ");
INSERT INTO swe_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Herren sa: ”Detta tecken är för att de äldste ska tro att Herren, deras fäders Gud – Abrahams, Isaks och Jakobs Gud – har visat sig för dig.” ");
INSERT INTO swe_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Herren sa också till honom och ger ett andra tecken: ”Stick handen innanför manteln!” Han stack in handen i manteln, och när han drog ut den var handen sjuk (hebr. tsara) – vit som snö. Det hebreiska ordet tsaraat är en generell term för olika sorters hudsjukdomar. Det är en sorts mögel som visar sig som ljusa fläckar och svullnader på huden, se 3 Mos 13-14. Traditionellt har ordet spetälska använts, men det motsvarar inte den sjukdom som vi idag kallar lepra eller Hansens sjukdom. ");
INSERT INTO swe_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Herren sa: ”Stick på nytt handen innanför manteln!” Han stack in handen i manteln, och när han drog ut den var handen normal igen, som resten av hans kropp. ");
INSERT INTO swe_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Herren sa: ”Om de inte tror eller bryr sig om det första tecknet med staven, så kanske de tror det andra tecknet med handen. ");
INSERT INTO swe_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Men om de inte tror på dessa två tecken eller lyssnar på dig, så ska du ta lite vatten från Nilen och hälla det på torra landet (marken – hebr. jabbashah). Detta blir det tredje tecknet. Då ska vattnet från floden förvandlas till blod på torra land (hebr. jabeshet).” Två olika hebreiska ord för ”torrt land” används i denna vers. Det första är det generella ordet som används i skapelsen och när israeliterna korsar Röda havet och Jordan torrskodda. Det sista används bara här och i Ps 95:5, där det används om hur Gud är större än alla avgudar. ");
INSERT INTO swe_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Då sa Mose och kom med ännu en ursäkt till Herren (Jahveh): ”Min Herre (Adonai, fokus på Guds storhet och makt), jag har så svårt att uttrycka mig. Jag har aldrig varit bra med ord, varken förut eller efter att du har talat till din tjänare. Jag stakar mig och stammar (är långsam att tala och har en trög tunga).” ");
INSERT INTO swe_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Herren (Jahveh) sa till honom: ”Vem har skapat människans mun? Vem skapar de stumma, de döva, de som kan se eller de som är blinda? Är det inte jag, Herren? ");
INSERT INTO swe_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Så gå nu, jag ska vara med din mun och lära dig vad du ska tala.” Ursäkterna är slut och nu säger Mose rent ut att han inte vill gå. ");
INSERT INTO swe_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Men Mose sa: ”O, min Herre (Adonai), skicka ditt budskap med någon annan, vem som helst.” ");
INSERT INTO swe_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Då blev Herren arg på Mose, och sa: ”Har du inte en bror, Aron som är 3 år äldre, se 2 Mos 7:7, leviten som är en skolad präst och van vid att tala Guds ord? Jag vet att han är duktig på att tala (ordagrant: ’talande tala’ – hebr. davar davar), dessutom är han faktiskt på väg just nu för att möta dig. När han ser dig kommer han att glädja sig i sitt hjärta. ");
INSERT INTO swe_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Du ska tala till honom och lägga orden i hans mun, och jag ska vara med din mun och med hans mun, och jag ska lära er båda två vad ni ska göra. ");
INSERT INTO swe_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Han Aron ska tala för dig vara din talesman inför folket, och det ska ske, att han ska vara din mun, och du ska vara som en gud (elohim) för honom. ");
INSERT INTO swe_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Du ska också ta denna stav i din hand, med den ska du göra tecknen.” ");
INSERT INTO swe_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose gick hem till sin svärfar Jetro (hebr. Jitro) och sa: ”Låt mig gå tillbaka till mina bröder och systrar i Egypten, jag vill se om de fortfarande lever.” Jetro sa till Mose: ”Gå i frid (var välsignad).” ");
INSERT INTO swe_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Herren sa till Mose medan han var i Midjan: ”Gå tillbaka till Egypten. Jag försäkrar dig: Alla de män som var ute efter att ta ditt liv lever inte längre.” Mose var nu åttio år gammal. De som fyrtio år tidigare ville döda Mose var nu döda, se 2 Mos 2:15. Det kan vara Amenotep I och hans efterträdare Amenotep II, och i så fall är den nuvarande farao Amenotep III. En intressant detalj är att hans förstfödda son Tutankhamon dog bara 18-19 år gammal, vilket stämmer bra in på den tionde plågan i kapitel 12. ");
INSERT INTO swe_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Då tog Mose sin hustru och sina söner Gershom och Elieser, se 2 Mos 18:2-4 och lät dem sitta upp på en åsna och återvände till Egypten. Han hade Guds (Elohims) stav i handen. Mose stav i vers 2 har nu blivit Guds stav. Det verkar som att det var ett misstag att ta med sig sin familj för detta uppdrag, i 2 Mos 18:1-6 skickar han hem dem. ");
INSERT INTO swe_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Herren sa till Mose: ”När du går tillbaka till Egypten ska du inför farao utföra alla de övernaturliga tecken som jag har gett dig makt att göra. Men jag ska förhärda hans hjärta så att han inte släpper folket. Bibeln är tydlig med att också farao själv förhärdar sitt hjärta, se 2 Mos 7:13; 8:15, 32; 9:34. ");
INSERT INTO swe_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Du ska säga till farao: ’Så säger Herren: Israel är min förstfödde son. ");
INSERT INTO swe_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Jag har sagt till dig att släppa min son, så att han kan frambära offer åt mig. Men du har vägrat, och därför ska jag döda din förstfödde son.’ ” Texten i vers 22-33 är riktad till farao. Den andra delen kan dock vara riktad till både farao och Mose. Farao släppte folket motvilligt först efter 10 plågor, men det är motvilligt Mose ger sig av tillbaka till Egypten. Det går att hitta 10 punkter där Mose förhalar och motsätter sig uppdraget. Den tionde är i nästa vers när de stannar. ");
INSERT INTO swe_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Längs med vägen mot Egypten stannade de på en plats för att övernatta. Ännu en antydan att Mose försenar sitt uppdrag. Där kom Herren emot honom och det verkade som att han ville döda honom troligtvis den förstfödde sonen Gershom. Den hebreiska texten har ”honom”. Av de fyra personerna där kan det syfta på Mose, hans förstfödde Gershom eller Elieser, se 2 Mos 18:2. ");
INSERT INTO swe_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Då tog Sippora en vass flintbit och skar bort förhuden på sin son och strök (vidrörde) honom Gershom eller Mose ned till foten med den och sa: ”Du är min blodsbrudgum.” Det hebreiska ordet för ”strök” är samma ord som används i 2 Mos 12:22 där israeliterna ”stryker” lammets blod på dörrposterna för att den förstfödde inte ska dö. ");
INSERT INTO swe_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","När han syftar antagligen på Gud lät honom Mose vara, sa Sippora ”du är min blodsbrudgum på grund av omskärelsen.” I Guds förbund med Abraham och Israels folk var omskärelsen av pojkar viktig, se 1 Mos 17:9-14. Det verkar som om Mose och Sippora hade försummat att göra detta för en av sina söner, eller för båda. Även om den exakta betydelsen av dessa verser inte är helt klar, ser vi att Gud var noga med att Mose, som skulle befria sitt folk, följde Guds bud. ");
INSERT INTO swe_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Herren sa till Aron Moses tre år äldre bror som var kvar i Egypten: ”Gå och möt Mose i öknen.” Han gick, och vid Guds berg träffade han honom och kysste honom. Det var ett kärt återseende efter fyrtio år. Det visar också att de inte hade någon osämja mellan sig eftersom kyssen på den här tiden var ett viktigt fredstecken. ");
INSERT INTO swe_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mose berättade för Aron allt som Herren hade sänt honom att säga och alla tecken han hade fått befallning att utföra. ");
INSERT INTO swe_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Sedan gick Mose och Aron därifrån till Egypten och kallade samman israeliternas äldste. ");
INSERT INTO swe_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron talade upprepade allt vad Herren (Jahveh) hade talat till Mose, och han gjorde tecknen inför folket, ");
INSERT INTO swe_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","och folket trodde på Mose och på Arons ord. När de hörde att Herren hade tagit sig an israeliterna och att han hade sett hur de led, föll de ner och böjde sig ner och tillbad i tacksägelse till Gud. ");
INSERT INTO swe_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","En tid därefter gick Mose och Aron till farao och sa: ”Så säger Herren, Israels Gud: Släpp mitt folk så att de kan fira högtid i öknen till min ära.” ");
INSERT INTO swe_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Men farao som själv ansåg sig vara en gud svarade: ”Vem är Herren (Jahveh). Varför skulle jag lyda honom och släppa Israel? Jag känner inte Herren, och jag tänker inte släppa Israel.” ");
INSERT INTO swe_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","De svarade: ”Hebréernas Gud har visat sig för oss. Låt oss få gå tre dagsresor ut i öknen och offra åt Herren, vår Gud. Annars kommer han över oss med pest eller svärd.” ");
INSERT INTO swe_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kungen i Egypten svarade dem: ”Mose och Aron, varför har ni gjort så att folket slutat arbeta gett dem falska förhoppningar? Gå tillbaka till ert slavarbete!” ");
INSERT INTO swe_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao sa till dem eller tänkte för sig själv: ”Befolkningen är stor, och ni vill att de ska slippa arbeta!” ");
INSERT INTO swe_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Samma dag kommenderade han de egyptiska slavdrivarna som var över folket och de israeliska förmännen som ledde sina landsmän, se vers 14: ");
INSERT INTO swe_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","”Ni ska inte längre ge folket halm för att göra tegel. Låt dem gå ut och hämta halm själva. ");
INSERT INTO swe_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ni ska dock kräva samma mängd tegel av dem som förut, minska inte kvoten. De är lata, det är därför de ropar: ’Låt oss gå och offra till vår Gud.’ ");
INSERT INTO swe_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Gör därför deras arbete så hårt för dem så att de inte har tid att tänka på något annat än arbete. Kanske slutar de då att lyssna på dessa lögner som Mose och Aron talar!” ");
INSERT INTO swe_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Då gick slavdrivarna över folket och förmännen ut och sa till folket: ”Så säger farao: ’Jag ger er inte någon halm. ");
INSERT INTO swe_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gå ut och hämta den bäst ni kan. Det blir inget avdrag på kvoten Ni ska producera lika mycket tegel som förut.’ ” ");
INSERT INTO swe_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Folket begav sig ut över hela Egypten för att samla strå kortare stubb från fälten för att ha som halm. ");
INSERT INTO swe_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Slavdrivarna pressade dem hårt och sa: ”Fullgör ert arbete, er dagliga kvot på samma sätt som när ni fick halm.” ");
INSERT INTO swe_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","De israeliska förmännen som faraos slavdrivare hade satt över folket, blev slagna och man sa: ”Varför har ni inte fullgjort er kvot av tegel som tidigare, varken i går eller i dag?” ");
INSERT INTO swe_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Då kom Israels förmän till farao och ropade: ”Varför behandlar du dina tjänare så här? ");
INSERT INTO swe_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Man ger ingen halm åt dina tjänare, ändå säger man: ’Gör tegel!’ Dina tjänare blir nu slagna, trots att skulden ligger hos ditt eget folk.” ");
INSERT INTO swe_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Han svarade: ”Nej, det är ni som är lata, ni är verkligen lata (overksamma)! Ni försöker komma undan ert arbete. Därför säger ni ’Låt oss gå och offra till Herren (Jahveh).’ ");
INSERT INTO swe_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ut med er, tillbaka till ert arbete! Ni ska inte få någon halm, men ni måste producera samma kvot tegel.” ");
INSERT INTO swe_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","De israeliska förmännen förstod att de var illa ute när de blev tillsagda att arbetsbördan inte skulle lätta. De var tvungna att göra lika mycket tegel varje dag som de gjort tidigare. ");
INSERT INTO swe_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","När förmännen lämnat farao gick de på en gång till Mose och Aron som väntade på dem. ");
INSERT INTO swe_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","De sa: ”Låt Herren se och döma vad ni gjort. På grund av er ser farao och hans tjänare på oss som om vi vore något motbjudande (ordagrant: ’en avskyvärd stank’). Du har satt svärdet i deras hand för att döda oss.” Nu har de en ursäkt att dräpa oss. ");
INSERT INTO swe_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Då vände sig Mose på nytt till Herren (Jahveh) och sa: ”Herre (Adonai, fokus på Guds storhet och makt), varför har du låtit så mycket elände komma över detta folk? Varför har du sänt mig? ");
INSERT INTO swe_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ända sedan jag gick till farao för att tala i ditt namn har hans ondska mot detta folk bara ökat, och du har inte gjort något för att rädda ditt folk.” ");
INSERT INTO swe_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Herren svarade Mose uppmuntrar och upprepar och förstärker sitt tidigare löfte, se 2 Mos 3:19; 4:21: ”Nu ska du få se vad jag ska göra med farao. Genom en stark hand ska han låta folket gå och inte bara det, han ska driva ut dem från sitt land genom en stark hand.” Uttrycket ”en stark hand” som används här två gånger syftar antagligen på Guds kraft, se 2 Mos 3:20. Plågorna som kom över landet gjorde att egyptierna till sist önskade att folket ska skulle gå och skickade iväg dem, se 2 Mos 12:33. ");
INSERT INTO swe_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Gud talade till Mose: ”Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Jag visade mig för Abraham, Isak och Jakob som Gud den Allsmäktige (El-Shaddaj) 1 Mos 17:1; 35:11. Dock gjorde jag mig inte känd (fick de inte erfara mig) under mitt namn Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Jag har också upprättat mitt förbund med dem och lovat att ge dem Kanaan, det land där de bodde som främlingar. ");
INSERT INTO swe_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Jag har också hört israeliternas jämmer över att egyptierna har gjort dem till slavar, och jag har tänkt på (inte glömt) mitt förbund. ");
INSERT INTO swe_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Säg därför till israeliterna: ’Jag är Herren (Jahveh). Jag ska föra er ut från förtrycket under egyptierna. Jag ska rädda er från deras slaveri. Jag ska återlösa (hebr. gaal) er med min utsträckta arm, och genom väldiga straffdomar. ");
INSERT INTO swe_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Jag ska göra er till mitt folk. Jag ska vara er Gud. Ni ska förstå att jag är Herren (Jahveh) er Gud (Elohim), som för er bort från förtrycket hos egyptierna. ");
INSERT INTO swe_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Jag ska föra er till det land som jag svor att ge åt Abraham, Isak och Jakob. Jag ska ge det åt er till arv och egendom. Jag är Herren (Jahveh).’ ” I vers 6 används hebr. gaal för första gången i Andra Moseboken. Hela denna berättelse om hur Gud befriar israeliterna ur slaveriet är den enskilt största typologin i hela GT på det som Jesus gör under påskveckan när han går till korset för oss som vår Återlösare (hebr. goel; substantivet till verbet gaal), se även Rut 2:20; Job 19:25. ");
INSERT INTO swe_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Så Mose talade så till Israels söner, men de hörde inte på honom på grund av missmod och det hårda arbetet. Ordagrant är missmod ”korta ande”. Ordet kan översättas otålig eftersom det inte finns någon ande av hopp kvar. Versen beskriver hur israeliterna både själsligt och kroppsligt var så brutna att de inte kunde ta till sig hans uppmuntrande ord. ");
INSERT INTO swe_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Herren talade till Mose: ");
INSERT INTO swe_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","”Gå och tala till farao, kungen av Egypten, att han ska förvisa Israels söner från sitt land.” ");
INSERT INTO swe_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Men Mose talade till Herren: ”Herre, se hur hopplös situationen är, israeliterna lyssnar inte på mig, varför skulle då farao lyssna? Dessutom har jag ju svårt för att tala.” Ordagrant ”har jag oomskurna läppar”. Uttrycket verkar relatera till tidigare misslyckanden, se 2 Mos 4:24-26. ");
INSERT INTO swe_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Herren (Jahveh) talade till Mose och Aron och befallde dem (gav dem uppdraget) att säga till både Israels barn och farao, kungen i Egypten, att israeliterna skulle föras ut ur Egyptens land. Här sker en paus i berättelsen. Man kan säga att det är en ”cliffhanger”, hur det ska gå? Varken israeliterna eller farao lyssnar på Mose och själv är han på gränsen att ge upp, se vers 12. Mitt i berättelsens höjdpunkt kommer en tillbakablick som visar hur Mose och Aron är den fjärde generationen från Jakob via Levis stam. Genealogin är begränsad till de tre första sönerna till Jakob: Ruben, Simeon och Levi. De följande nio sönerna är inte relevanta för att visa Moses och Arons släktskap och tas inte med. Jakob kallas också Israel, se 1 Mos 32:28. I listningen nedan är de namn som ingår i Moses och Arons släktträd fetmarkerade. ");
INSERT INTO swe_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dessa var överhuvuden var och en för sin släkt. Sönerna till Ruben, Israels Jakobs förstfödde: Chanoch (Henok) och Pallo, Chetsron (Hesron) och Karmi; detta var de rubenitiska familjerna. ");
INSERT INTO swe_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Sönerna till Simeon Shimon – Jakobs andra son: Jemuel, Jamin, Ohad, Jachin, Sochar (Tsochar) och Saul (Shaol), sonen till en kanaaneisk kvinna; detta var de simonitiska familjerna. ");
INSERT INTO swe_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Sönerna till LeviIsraels tredje son hette i åldersordning: Gershon hans söner listas i vers 17, Kehathans söner listas i vers 18 och Merari hans söner listas i vers 19. Levi blev 137 år gammal. Jakob hade tolv söner, men eftersom den här släkttavlan handlar om Mose och Aron, så räcker det att ta med sönerna fram till Jakobs tredje son Levi. Nu följer den andra generationen av Levis stam. ");
INSERT INTO swe_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Sönerna till Gershon, familj för familj: Livni och Shimi. ");
INSERT INTO swe_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Sönerna till Kehat: Amramhans söner listas i vers 20, Jishar hans söner listas i vers 21, Hebron (hebr. Chevrón) och Ussiel hans söner listas i vers 22. Kehat blev 133 år gammal. ");
INSERT INTO swe_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Sönerna till Merari: Machli och Mushi. Detta var de levitiska familjerna i åldersordning. ");
INSERT INTO swe_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram gifte sig med Jocheved, sin faster, och hon födde honom Aron och Mose. Amram blev 137 år gammal. ");
INSERT INTO swe_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Sönerna till Jishar: Korach, Nefeg och Sikri. ");
INSERT INTO swe_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Sönerna till Ussiel: Mishael, Elsafan och Sitri. ");
INSERT INTO swe_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron gifte sig med Elisheva, dotter till Amminadav och syster till Nachshon, och hon födde honom: Nadav och Avihu, Elazar och Itamar. ");
INSERT INTO swe_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Sönerna till Korach: Assir, Elkana och Aviasaf; detta var de korachitiska familjerna. Att Korach finns med här beror antagligen på det uppror han senare kom att leda, se 4 Mos 16. Rent släktmässigt hade han samma status som Mose och Aron. ");
INSERT INTO swe_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elazar, Arons son, gifte sig med en av Putiels döttrar, och hon födde honom: Pinchas. Dessa var överhuvuden för de levitiska släkterna, familj för familj. ");
INSERT INTO swe_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Det var denne Aron och denne Mose som Herren befallde att föra israeliterna ut ur Egypten, ordnade i häravdelningar. ");
INSERT INTO swe_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Det var de som talade med farao, kungen av Egypten, om att israeliterna skulle föras ut ur landet – just dessa båda, Mose och Aron. I tre verser sammanfattas nu samtalet före släkttavlan, sedan fortsätter berättelsen där Aron får föra Moses talan. ");
INSERT INTO swe_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","På den dag då Herren (Jahveh) talade till Mose i Egypten ");
INSERT INTO swe_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","talade han: ”Jag är Herren (Jahveh). Allt vad jag talar till dig ska du tala till farao, kungen av Egypten.” ");
INSERT INTO swe_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Men Mose vädjade till Herren: ”Jag har ju svårt för att tala ordagrant ’jag har oomskurna läppar’. Varför skulle farao lyssna till mig?” ");
INSERT INTO swe_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Herren svarade Mose: ”Nu gör jag dig som en gud för farao för att säga mina ord till honom, och din bror Aron ska bli din profet. ");
INSERT INTO swe_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du ska tala allt vad jag befaller dig, och din bror Aron ska tala det till farao så att han måste låta israeliterna lämna hans land. ");
INSERT INTO swe_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Men jag ska göra så att faraos hjärta förhärdas. Trots att jag kommer att göra många övernaturliga tecken och under i Egyptens land, ");
INSERT INTO swe_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ska farao inte lyssna till dig. Jag ska lägga min hand på Egypten och jag ska föra ut mina härskaror, mitt folk israeliterna, ut ur Egyptens land genom stora straffdomar. ");
INSERT INTO swe_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Då ska egyptierna förstå att jag är Herren, när jag sträcker ut min hand över Egypten och för ut israeliterna från dem.” ");
INSERT INTO swe_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose och Aron gjorde allt som Herren hade befallt dem. ");
INSERT INTO swe_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","När de talade med farao var Mose 80 år gammal och Aron 83 år. ");
INSERT INTO swe_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Herren (Jahveh) talade till Mose och Aron, han sa: ");
INSERT INTO swe_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","”När farao talar till er: ’Gör ett övernaturligt tecken. Bevisa er auktoritet.’, ska du säga till Aron: ’Kasta din stav framför farao’, så ska den bli en orm (krokodil – hebr. tanin).” Ordagrant inleds och avslutas vers 8 med verbet amar, att tala. Detta betonar hur Herren talar med Mose. ");
INSERT INTO swe_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mose och Aron gick till farao och gjorde exakt som Herren hade sagt till dem. Aron kastade sin stav inför farao och hans tjänare, och den blev en orm (krokodil – hebr. tanin). Tidigare i 2 Mos 4:3 (och i vers 15) används det vanliga ordet för orm (hebr. nachash), här används istället tanin, ett ord som kan vara ett annat ord för orm eller beskriva en krokodil. Ordet används om havsdjuren i 1 Mos 1:21. Intressant är att faraonerna ansågs vara Sobek – krokodilguden, se även Hes 29:3-5. ");
INSERT INTO swe_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Då kallade farao till sig sina visa män och magiker (trollkarlar), och dessa – de egyptiska spåmännen (skrivare, från ordet för penna) – gjorde liknande saker imiterade Guds mirakler med hjälp av magi (ockulta krafter). Enligt judisk tradition hette två av dem Jannes och Jambres, se 2 Tim 3:8. ");
INSERT INTO swe_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Var och en av dem kastade sin stav och de blev till ormar (krokodiler – hebr. tanin), men Arons stav slukade deras stavar. ");
INSERT INTO swe_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Men faraos hjärta blev förhärdat (tillslutet – hebr. chazaq) och han lyssnade inte till dem, precis som Herren (Jahveh) hade talat. Det hebreiska ordet chazaq betyder att ”förhärda” och ”tillsluta”. När det används om hjärtat beskriver det en vilja som är orubblig och hård. Den hebreiska verbformen här anger inte om det är farao själv eller Gud som initierar förhärdandet. Samma öppna skrivsätt används även i 2 Mos 7:22; 8:19; 9:7. Gud känner människans hjärta och kan förutsäga människors agerande, se Jer 17:10. När Mose först kallas berättar Herren att han vet att farao kommer göra motstånd och vägra att släppa israeliterna, se 2 Mos 3:19-20. Han har också berättat att han i slutändan kommer att förhärda faraos hjärta, se 2 Mos 4:21; 7:3.  Är farao då bara en bricka i Guds spel utan någon egen vilja? Under de tio plågorna framträder ett mönster där det sker ett gradvis förhärdande där farao själv först förhärdar sitt eget hjärta, se 2 Mos 8:15, 32; 9:13. Efter femte plågan sker ett skifte, vid den sjätte plågan står det för första gången att Gud förhärdar faraos hjärta, se 2 Mos 9:34. Vid sjunde plågan förhärdar farao på nytt sitt eget hjärta, men nu verkar han ha passerat en gräns utan återvändo. Från och med åttonde plågan och framåt är det Herren som förhärdar honom ytterligare, se 2 Mos 10:1, 20; 10:27; 11:10.  1. Blod: Faraos hjärta ”blev hårt”, se 2 Mos 7:22 2. Grodor: Farao ”förhärdade sitt eget hjärta”, se 2 Mos 8:15 3. Insekter: Faraos hjärta ”blev hårt”, se 2 Mos 8:19 4. Flugor (skalbaggar): Farao ”förhärdade sitt eget hjärta”, se 2 Mos 8:32 5. Boskap dör: Faraos hjärta blev hårt, se 2 Mos 9:7 6. Bölder: ” Herren förhärdade faraos hjärta”, se 2 Mos 9:12 7. Hagel och eld: Farao ”förhärdade sitt eget hjärta”, se 2 Mos 9:34 8. Gräshoppor: Herren säger: ” Jag har förhärdat faraos hjärta”, se 2 Mos 10:1, 20 9. Mörker: ” Herren förhärdade faraos hjärta”, se 2 Mos 10:27 10. Den förstföddes död: ” Herren förhärdade faraos hjärta”, se 2 Mos 11:10 De nio första plågorna (tecknen) kan grupperas i tre grupper med tre plågor i varje grupp. De följer ett liknande mönster: Vid de två första plågorna varnas farao, medan den tredje plågan (i varje grupp) sker utan varning. Vid de tre första plågorna är det Aron som håller ut sin stav (2 Mos 7:19; 8:6, 17). Den fjärde och femte sänds från Gud (2 Mos 8:21; 9:3). Vid den sjätte plågan använder Mose sina händer och kastar aska i luften (2 Mos 10:9) och i de tre sista sträcker han ut sin hand (2 Mos 9:23; 10:13, 22). Den tionde plågan kommer från Gud, se 2 Mos 12:29. ");
INSERT INTO swe_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Sedan sa Herren (Jahveh) till Mose: ”Faraos hjärta är hårt (tillslutet). Han vägrar att släppa folket. ");
INSERT INTO swe_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Gå till farao på morgonen, då går han ut till vattnet och du ska stå på flodstranden och möta honom. Staven som blev en orm (hebr. nachash) ska du ha i din hand. 2 Mos 4:3 ");
INSERT INTO swe_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Du ska säga till honom: ’Herren (Jahveh), hebréernas Gud (Elohim), har sänt mig till dig och säger: Släpp mitt folk så att de kan tjäna (hålla gudstjänst till) mig i öknen, och se, du har inte lyssnat. Här används det hebreiska ordet avad för att ”betjäna”. Ordet betyder att tillbe men också att arbeta. Samma ord används i vers 2 Mos 20:9 om att ”arbeta” sex dagar och om slavarbetet i 2 Mos 1:13, 14, se även 1 Mos 2:5; 15. I grekisk filosofi och tänkande, som influerat mycket av västvärlden, anses arbete vara något ont och det andliga gott. För Gud hör tillbedjan och arbete ihop. ");
INSERT INTO swe_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Detta är vad Herren säger: Genom detta ska du veta att jag är Herren (Jahveh). Se, jag ska slå på vattnet som är i floden med staven i min hand och det ska förvandlas till blod. ");
INSERT INTO swe_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Fisken som är i floden ska dö och floden ska bli stinkande av all rutten fisk och egyptierna ska avsky (tappa tålamodet; tröttas ut av) att dricka flodens vatten.’ ” Här används hebr. laa i betydelsen att de blir uttröttade, irriterade och tappar tålamodet på att söka efter rent dricksvatten. ");
INSERT INTO swe_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Herren sa till Mose: ”Säg till Aron: ’Ta din stav och sträck ut din hand över Egyptens vatten – över floderna, över dess kanaler, över dess pölar och över allt dess samlade (hebr. miqveh) vatten dvs. reservoarer, men även mindre kärl – så att det blir till blod.’ Det ska vara blod över hela Egyptens land även i träkärl och stenkärl allt vatten, både naturligt och uppsamlat, ska bli till blod.” ");
INSERT INTO swe_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose och Aron gjorde som Herren (Jahveh) hade befallt. Han lyfte upp staven och slog vattnet i Nilen inför faraos och hans tjänares ögon. Då förvandlades allt vatten i floden till blod (blev det blodrött). Hebreiskan kan tolkas så att vattnet bokstavligt blev till blod, eller att det blev färgat blodrött. Ordet symboliserar också död, vilket blev effekten eftersom fiskarna dör och folket får gräva brunnar för att få drickbart vatten, se vers 21, 24. ");
INSERT INTO swe_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Fiskarna som fanns i floden dog och floden stank (luktade och smakade) så illa att egyptierna inte kunde dricka vattnet. Blodet var överallt (i alla slags vatten) över hela Egyptens land. Plågorna var riktade ”mot alla gudar i Egypten”, se 2 Mos 12:12. Egyptierna tillbad fler än 2 000 olika gudar. Eftersom Nilen med sina årliga översvämningar skapade de bördiga förutsättningarna var flera gudar kopplade till just Nilen. Den stora skaparguden Khnum var Nilens beskyddare. Hapi var Nilens ande och guden för flodens årliga översvämning. Han ansvarade för fiskarna, fåglarna och bördigheten i marken runt floden genom översvämningarna. Dessa båda gudar sågs som livets källa, Khnum gav livet och Hapi gav mat och vatten som är förutsättningen för att livet ska bestå. Osiris var underjordens gud och Nilen ansågs vara hans blodflöde. ");
INSERT INTO swe_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Men de egyptiska spåmännen (skrivare, från ordet för penna) gjorde samma sak med sina hemliga konster. Faraos hjärta blev förhärdat (tillslutet) och han lyssnade inte på dem, precis som Herren (Jahveh) hade talat. ");
INSERT INTO swe_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao vände sig om och gick in i sitt hus utan att ens ta någon notis om dem. ");
INSERT INTO swe_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Alla egyptier grävde runt floden efter dricksvatten för de kunde inte dricka vattnet från Nilen. ");
INSERT INTO swe_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Det gick sju fulla dagar efter att Herren (Jahveh) hade slagit Nilen. En hel vecka utan drickbart vatten någonstans i hela Egypten påverkade hela samhället. Det fanns säkert vin och andra drycker i förråden som gjorde att man inte var helt utan vätska och det fanns fortfarande mat i landet, men mycket av denna mat krävde vatten för att kunna tillagas. Därför kan vi utgå ifrån att detta blev en vecka som alltmer övergick i svält för folket i landet, både i faraos palats och i alla andra hem. Att plågan varade i sju fulla dagar talar bildligt om att detta är något som kommer att bli komplett, fullbordat och fullföljt. En bild på evigt straff för den som inte vill lyda Guds vilja. Eftersom Gud är långmodig och stor i mildhet ger han fler möjligheter för farao att vända om, innan han slutgiltigt sätter sin plan i verket. Att det blir just tio plågor är också ett tal för Guds fullhet och fullbordan. ");
INSERT INTO swe_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Sedan talade Herren (Jahveh) till Mose och sa: Gå till farao och säg till honom: ”Släpp mitt folk så att de kan betjäna (hålla gudstjänst för) mig. ");
INSERT INTO swe_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Men om du vägrar låta dem gå, då ska jag slå (drabba) hela ditt land med grodor. Gudinnan Heket associerades med grodorna. Hon ansvarade för barnafödande, skapelse och att spannmålen växte. Som en vattengudinna var fertilitet och särskilt den senare delen av graviditeten och födandet viktiga delar av hennes ansvar. Hon ansågs vara Khnums hustru. Khnum gjorde människan av lera på sin drejskiva och sedan inblåste Heket livsanden i leran innan hon placerade den i kvinnans livmoder. Khnum och Hapi var källan till liv medan Heket var garanten för kommande generationer så att livet inte tar slut. ");
INSERT INTO swe_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Floden ska krylla av grodor och de ska komma upp (ur floden) och komma in i ditt hus, och komma in i ditt sovrum, och upp i din säng. De ska komma in i dina tjänares hus och i folkets hus in i deras ugnar och upp i deras baktråg. ");
INSERT INTO swe_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Grodorna ska klättra upp på dig själv, ditt folk och alla dina tjänare.” Mängder av grodor kommer att krypa omkring på kroppen på alla människor. ");
INSERT INTO swe_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Sedan talade Herren (Jahveh) till Mose: ”Säg till Aron: ’Sträck ut din hand med din stav över floden, kanalerna och pölarna så att grodor kommer upp över hela Egyptens land.’ ” ");
INSERT INTO swe_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Då sträckte Aron ut sin hand över Egyptens vatten och grodorna kom upp och täckte hela landet. ");
INSERT INTO swe_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Men spåmännen (skrivare, från ordet för penna) gjorde samma sak med sina hemliga konster och fick upp grodor över hela Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Då kallade farao på Mose och Aron och sa: ”Be till Herren (Jahveh) att han tar bort grodorna från mig och från mitt folk. Sedan ska jag låta folket gå så att de kan offra till Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose svarade farao: ”Gör mig den äran! Vid vilken tid ska jag be för dig, dina tjänare och ditt folk att grodorna ska lämna (bokstavligt bli avhuggna från) dig och ditt hus och endast finnas kvar i Nilen?” ");
INSERT INTO swe_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","”I morgon”, sa han farao. Så han Mose sa: ”Låt det ske i enlighet med ditt ord, så att du ska veta att det finns ingen like till Herren vår Gud (Jahveh Elohim). ");
INSERT INTO swe_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Grodorna ska lämna dig, ditt hus, dina tjänare och ditt folk. De ska bara finnas kvar i Nilen.” ");
INSERT INTO swe_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Efter att Mose och Aron hade gått ut från farao, ropade Mose till Herren (Jahveh) angående grodorna som han hade sänt över farao. ");
INSERT INTO swe_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Herren (Jahveh) gjorde i enlighet med Moses ord och grodorna dog från husen, från gårdarna och från fälten. ");
INSERT INTO swe_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Man samlade ihop dem i trave på trave (många stora högar) och landet stank. Det luktade vedervärdigt av döda grodor precis överallt. ");
INSERT INTO swe_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Men när farao såg lättnaden, förhärdade (tillslöt) han sitt hjärta och lyssnade inte på dem, så som Herren (Jahveh) hade talat. ");
INSERT INTO swe_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Herren (Jahveh) talade till Mose: Säg till Aron: Sträck ut din stav och slå stoftet på marken så ska det komma upp insekter (hebr. kenim) troligtvis knott eller löss; kanske myggor ur marken i hela Egypten. ");
INSERT INTO swe_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","De gjorde så. Aron sträckte ut sin hand med sin stav och slog stoftet på marken och det kom upp insekter på människor och boskap. Allt stoft på marken blev till insekter över hela Egyptens land. Den egyptiske guden Geb var markens gud i Egypten. Nu hade han plötsligt inte kontroll över marken längre när myriader av stickande insekter kom upp ur marken. Man trodde också att Geb kunde behålla dig i graven eller låta dig gå vidare till livet efter detta. Därför var det viktigt att tillbe honom så att man inte blev kvar i graven. Ordet för insekter är pluralformen av hebr. ken. Det kan syfta på knott, löss eller någon annan liten insekt som angriper både människor och djur. Eftersom Aron slår sin stav på markens stoft (hebr. afar) är det troligare att det är knott eller löss, än myggor som ofta kläcks i våtmark. Det var också något speciellt. Myggor var vanligt förekommande, eftersom Nilen varje år svämmade över vilket skapade gynnsamma förhållanden för myggor. ");
INSERT INTO swe_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","När spåmännen (skrivare, från ordet för penna) försökte göra samma sak och få fram insekter med hjälp av sina hemliga konster, kunde de inte det, de misslyckades. Nu var det fullt med insekter överallt, på både människor och boskap. ");
INSERT INTO swe_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Spåmännen (skrivare, från ordet för penna) sa till farao: ”Detta är Guds (Elohims) finger.” Men faraos hjärta blev förhärdat (tillslutet) och han lyssnade inte på dem, så som Herren (Jahveh) hade talat. ");
INSERT INTO swe_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Sedan talade Herren (Jahveh) till Mose: Stig upp tidigt på morgonen och stå (positionera dig) framför farao. När han kommer till vattnet (Nilen) ska du säga till honom: Detta är vad Herren (Jahveh) säger: Släpp mitt folk så att de kan betjäna (hålla gudstjänst för) mig. ");
INSERT INTO swe_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Annars, om du inte låter mitt folk gå, ska jag sända flugsvärmar över dig, dina tjänare, ditt folk och in i era hus. Egyptens hus ska bli fulla (så att det fullständigt kryllar) av svärmande flugor till och med i husgrunderna. Den egyptiska guden Khepri hade kontrollen över alla insekter, flugor och skalbaggar. Han hade kontroll över skapelsen och han ansågs även så mäktig att han var den som personligen flyttade solen över himlen varje dag. ");
INSERT INTO swe_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Men på den dagen ska jag göra skillnad för landet Goshen, där mitt folk bor, så att ingen flugsvärm kommer dit, för att du ska veta att jag, Herren (Jahveh), är (finns) mitt i landet (på jorden). Här gör Gud för första gången åtskillnad på egyptierna och israeliterna så att plågan inte drabbar det judiska folket. ");
INSERT INTO swe_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Jag ska göra en åtskillnad mellan mitt folk och ditt folk. I morgon ska denna plåga inträffa. Farao har dagen på sig att ångra sig, men gör det inte. ");
INSERT INTO swe_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Herren (Jahveh) gjorde precis så. En massiv flugsvärm kom in i faraos alla hus och in i hans tjänares hus. Hela Egyptens land ruinerades på grund av de enorma flugsvärmarna. ");
INSERT INTO swe_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farao kallade på Mose och Aron och sa: ”Gå, offra till er Gud i landet.” ");
INSERT INTO swe_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Men Mose svarade: ”Det skulle inte vara rätt. De offer som vi har för avsikt att offra till Herren vår Gud (Jahveh Elohim) är en styggelse för egyptierna. Skulle inte egyptierna stena oss om vi offrar vad som är en styggelse för dem? ");
INSERT INTO swe_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Vi måste vandra en tredagarsresa ut i öknen och offra till Herren vår Gud (Jahveh Elohim) precis som han har instruerat oss.” ");
INSERT INTO swe_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao sa: ”Jag ska låta er gå så att ni kan offra till Herren er Gud (Jahveh Elohim) i öknen. Gå bara inte så långt bort. Be för mig.” ");
INSERT INTO swe_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose svarade: ”Se, när jag går ut från dig ska jag be till Herren (Jahveh) att flugsvärmarna lämnar farao, hans tjänare och folket i morgon. Bara farao slutar att handla förnedrande (vara bedräglig, luras – hebr. talal) och vägrar folket gå för att offra till Herren (Jahveh).” Det ovanliga ordet för att lura (hebr. talal) har samma rot som ordet tel som används om en stad som byggts upp och rivits ner. Faraos sätt är som ett grymt skämt där faraos förväntning har byggts upp som en stad synlig för alla, för att sedan raseras, på nytt byggas upp för att igen raseras. ");
INSERT INTO swe_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Därefter gick Mose ut från farao och bad till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Herren (Jahveh) gjorde precis som Mose hade sagt och tog bort flugsvärmarna från farao, från hans tjänare och från hans folk. Ingenting blev kvar. ");
INSERT INTO swe_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Men farao förhärdade (tillslöt) sitt hjärta och lät inte folket gå. ");
INSERT INTO swe_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Sedan sa Herren (Jahveh) till Mose: ”Gå till farao och tala till honom: Detta är vad Herren (Jahveh), hebréernas Gud (Elohim), säger: Släpp mitt folk så att de kan betjäna (hålla gudstjänst för) mig. ");
INSERT INTO swe_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Om du vägrar att låta dem gå och fortsätter att hålla dem kvar, ");
INSERT INTO swe_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","se, då ska Herrens (Jahvehs) hand komma över din boskap på fälten, över hästarna, åsnorna, kamelerna, boskapsbesättningar och smådjursflockar. Det ska bli en förödande pest. ");
INSERT INTO swe_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Men Herren (Jahveh) ska göra åtskillnad på Israels boskap och Egyptens boskap så att ingenting ska dö som tillhör Israels barn (söner).” Här gör Gud på nytt skillnad mellan egyptierna och israeliterna, se även 2 Mos 8:22. Den egyptiska gudinnan Hathor var kungens amma, hon var också gudinna med ansvar för kärlek, fertilitet och kvinnor. Hon ansågs även vara den som rensade landet från dem som inte var rätt troende, hedningar i förhållande till den egyptiska gudavärlden. Detta är också en dom mot den religiösa hierarkin där kalvar, kor och oxar tillbads och var högt ansedda. ");
INSERT INTO swe_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Och Herren (Jahveh) satte ut en bestämd tid och sa: ”I morgon ska detta äga rum i landet.” ");
INSERT INTO swe_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nästa dag gjorde Herren (Jahveh) denna gärning (utförde detta ord). All boskap hästar, åsnor, kameler, får och getter, se vers 3 i Egypten dog, men av Israels barns boskap dog inte ett enda djur. ");
INSERT INTO swe_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","När farao frågade hade inte ett enda djur som tillhörde Israels barn (söner) dött. Men faraos hjärta blev förhärdat (tillslutet) och han lät inte folket gå. ");
INSERT INTO swe_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Sedan sa Herren (Jahveh) till Mose och Aron: ”Ta händerna fulla med aska från ugnen kan syfta på aska från de ugnar där man bränt kadavren efter de döda djuren och låt Mose kasta upp den mot himlen inför faraos åsyn. ");
INSERT INTO swe_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Det ska bli fint damm över hela Egyptens land och ska bli som bölder som blommar upp med sår på både människor och djur över hela landet.” Med denna sjätte plåga tar Herren itu med hela det egyptiska systemet för läkedom. I Egypten grasserade alla upptänkliga sjukdomar och krämpor. Men läkedom handlade inte om medicin utan uteslutande om magi och ockultism. Olika åkommor tillskrevs skilda gudar och gudinnor som antingen kunde förhindra eller förorsaka dessa sjukdomar. Varje åkomma hade sin egen ritual, trolldryck eller amulett för att beveka den specifika guden.  En av ritualerna för helande var särskilt grym. Den föreskrev att man skulle offra en levande människa som brändes på ett högt altare. Sedan kastade man upp askan i luften och trodde att när den spreds med vinden skulle det ge välsignelse och helande. När Mose tar aska i handen och kastar upp i luften mot himlen framför farao så är det en direkt konfrontation mot denna sed. ");
INSERT INTO swe_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Så de tog aska från ugnen och stod framför faraos ansikte. När Mose kastade upp askan mot himlen blev den till bölder som blommade upp med sår på både människor och djur över hela landet. ");
INSERT INTO swe_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Trollkarlarna kunde inte stå framför Mose på grund av bölderna, för de var på trollkarlarna precis som på alla egyptier. ");
INSERT INTO swe_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Men Herren förhärdade (tillslöt) faraos hjärta så att han inte lyssnade till dem. Så som Herren (Jahveh) hade talat till Mose 2 Mos 4:21; 7:3. Efter den 5:e plågan står det i 2 Mos 9:6 att ”all boskap dog.” Vilka djur var det då som fick bölder i den 6:e plågan, se 2 Mos 9:10, och vilken boskap är det som tas in från fälten och skyddas från haglet i den 7:e plågan, se 2 Mos 9:20-25? Det finns flera förklaringar.  Hebreiska kol, översatt ”alla” i 2 Mos 9:6, behöver inte betyda vartenda ett utan också ”alla typer”. I den grekiska översättningen Septuaginta väljs inte gr. holon, som beskriver varenda en, utan pas som beskriver ”alla sorter och olika typer”. Betydelsen blir då att den femte plågan med någon form av sjukdom påverkade alla olika sorters boskap som hästar, åsnor, kameler, boskap, får och getter. Denna tolkning stärks av att några verser innan räknas just dessa olika typer av tamboskap upp, se 2 Mos 9:3.  Bibeln anger inte heller hur lång tid som passerar mellan den femte och sjätte plågan. Om det nu verkligen var varenda en av all boskap som utplånades, kan egyptierna tagit boskap från israeliterna eller köpt från grannländer. Vad gäller haglet i den 7:e plågan varnades ”de som fruktade Herren bland faraos tjänare” att ta in sin boskap under tak för att inte dö, se 2 Mos 9:20. Även om Bibeln inte uttryckligen säger det kan dessa gudfruktiga egyptier blivit skonade även tidigare, på samma sätt som israeliterna, när den egyptiska boskapen drabbades av sjukdom redan under den 5:e plågan. ");
INSERT INTO swe_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Sedan sa Herren (Jahveh) till Mose: ”Stig upp tidigt på morgonen och stå (positionera dig) framför farao och säg till honom: ’Detta är vad Herren (Jahveh), hebréernas Gud (Elohim), säger: Släpp mitt folk så att de kan betjäna (hålla gudstjänst för) mig. ");
INSERT INTO swe_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Denna gång ska jag sända alla hemsökelser (plågor – hebr. magefa) till ditt hjärta, och till dina tjänare och till ditt folk, så att ni ska veta att det inte finns någon som jag i hela världen. ");
INSERT INTO swe_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sannerligen skulle jag nu ha kunnat sträcka ut min hand och slå dig och ditt folk med en pest som hade sopat bort dig från jordens yta. ");
INSERT INTO swe_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Likväl (en skarp betoning och kontrast mellan något som varit och något som är – hebr. olam) har jag låtit dig stå av denna anledning; för att visa dig min makt och för att mitt mäktiga namn ska återberättas (räknas – hebr. safar) över hela jorden. ");
INSERT INTO swe_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ändå upphöjer du dig själv över mitt folk genom att inte låta dem gå. ");
INSERT INTO swe_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Se, i morgon vid den här tiden ska jag låta det regna med en mycket häftig hagelstorm, vars like aldrig har skådats i Egypten sedan den dag det grundades och till nu. ");
INSERT INTO swe_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sänd ut detta ord (gör det känt i hela Egypten); Stalla in din boskap och allt som du har ute på fälten. Varje person eller djur som är kvar ute på fältet och inte tagits hem (till stallet) kommer att dö när haglet faller ner på dem.’ ” ");
INSERT INTO swe_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","De som fruktade (vördade) Herrens (Jahvehs) ord bland faraos tjänare såg till att hans egna tjänare och boskap tog skydd in i husen, ");
INSERT INTO swe_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","men de som inte fruktade (vördade) Herrens (Jahvehs) ord lämnade sina tjänare och sin boskap ute på fälten. ");
INSERT INTO swe_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Sedan sa Herren (Jahveh) till Mose: ”Sträck ut din hand mot himlen och låt det hagla över hela Egypten, på människor, på djur och allt som växer på fälten över hela landet.” Den egyptiska gudinnan Nut hörde ihop med himlen. Hon förfogade över en barriär som skilde kaos från den kosmiska ordningen i den här världen. Hon var hustru till markens gud Geb och sågs som beskyddare av jorden. Nut ansågs särskilt ansvarig för natthimlen med sina stjärnkonstellationer som kunde förutspå framtiden, det vi kallar för astrologi. Nut var en av de viktigaste gudinnorna. Egyptierna trodde att de skyddades från naturens destruktiva krafter när de tjänade henne. När haglet fördärvade både djur, grödor och människor visade sig hennes kraft verkningslös. ");
INSERT INTO swe_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mose sträckte ut sin hand mot himlen och Herren (Jahveh) sände åska och hagel. Eld kom ner på jorden när Herren (Jahveh) lät hagel falla över Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Haglet föll tungt med blixtar mitt i haglet. Dess like hade aldrig tidigare skådats över Egypten sedan landet blev till. Haglet består av både eld och is. Mirakulöst smälter inte elden isen och isen släcker inte elden. Dessa motsatta krafter verkar tillsammans för att utföra Guds vilja. Den medeltida franska rabbinen Rashi, som skrivit det mest inflytelserika kommentarverket till GT, noterar också hur ordet för himmel (hebr. shamaim) består av två ord: eld (hebr. esh) och vatten (hebr. maim). ");
INSERT INTO swe_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Haglet slog ner allt som fanns på fälten, både människor och djur, allt i hela Egyptens land. Det slog också ner alla grödor på fälten och bröt sönder alla träd. ");
INSERT INTO swe_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Bara i landet Goshen där Israels barn (söner) bodde, föll inget hagel. Här gör Gud åter skillnad på egyptier och israeliter. ");
INSERT INTO swe_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Farao kallade på Mose och Aron och sa till dem: ”Jag har syndat denna gång. Herren (Jahveh) är rättfärdig, medan jag och mitt folk är onda. ");
INSERT INTO swe_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Be till Herren (Jahveh), det räcker med Guds (Elohims) åska och hagel. Jag ska låta er gå. Ni behöver inte stanna längre.” ");
INSERT INTO swe_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose sa till honom: ”Så snart jag har gått ut ur staden ska jag sträcka ut min hand till Herren (Jahveh). Åskan ska sluta och haglet ska upphöra så att du må veta att jorden är Herrens (Jahvehs). ");
INSERT INTO swe_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Men angående dig och dina tjänare vet jag att ni fortfarande inte fruktar (vördar) Herren Gud (Jahveh Elohim).” ");
INSERT INTO swe_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Linet och kornet var fördärvat, eftersom kornet hade gått i ax och linet stod i blom. ");
INSERT INTO swe_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Men vetet och speltvetet hade inte fördärvats eftersom det skördas senare. Av dessa agrara notiser vet vi att detta måste ha ägt rum i månadsskiftet mars/april. ");
INSERT INTO swe_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mose gick ut ur staden, bort från farao, och sträckte upp sin hand till Herren (Jahveh). Då slutade åskan och haglet upphörde och regnet vräkte inte längre ner på jorden. ");
INSERT INTO swe_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Men när farao såg att regnet, haglet och åskan hade upphört, utökade han sin synd och förhärdade (tillslöt) sitt hjärta, både han och hans tjänare. ");
INSERT INTO swe_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Faraos hjärta var förhärdat (tillslutet) och han lät inte Israels barn (söner) gå, så som Herren (Jahveh) hade talat genom Moses hand. ");
INSERT INTO swe_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Sedan sa Herren (Jahveh) till Mose: ”Gå till farao, för jag har förhärdat (tillslutet) hans hjärta och hans tjänares hjärtan, så att jag kan visa mina tecken i deras mitt. ");
INSERT INTO swe_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Detta ska du återge (berätta) i öronen betoning som förstärker att tydligt undervisa för dina söner och deras söner (barn och barnbarn) hur jag har gjort Egypten till åtlöje spelat egyptierna ett spratt, liksom mina tecken plågorna som jag har gjort ibland dem, så att ni ska veta att jag är Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mose och Aron gick in till farao och sa till honom: ”Detta är vad Herren (Jahveh), hebréernas Gud (Elohim), säger: Hur länge ska du vägra att ödmjuka dig inför mig? Släpp mitt folk så att de kan betjäna (hålla gudstjänst för) mig. ");
INSERT INTO swe_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Annars, om du vägrar att låta mitt folk gå, se, i morgon ska jag föra in gräshoppor över dina gränser. ");
INSERT INTO swe_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Sedan ska de täcka jordens yta (ansikte), så att ingen ska kunna se marken. De ska äta det som undkom, det som blev kvar efter haglet och äta alla era träd ute på fälten. ");
INSERT INTO swe_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Dina hus ska fyllas (av gräshopporna), det ska också dina tjänares hus och alla egyptiers hus, på ett sätt som dina fäder eller förfäder aldrig har sett från den dag då de kom till jorden till idag.” Sedan vände han sig om och gick ut från farao. Med gräshopporna är det flera egyptiska gudar som straffas. Shu var den gud som kontrollerade vindarna och Gud sände gräshopporna med östanvinden. Nefri vaktade utsädet, Renenutet var gudinnan som vakade över skörden, Geb var markens gud så alla dessa fick se sig omintetgjorda när Gud lät gräshopporna fördärva all vegetation. Heset var överflödets gud i Egypten och även detta togs bort när inte marken gav någon gröda. Alla dessa gudar var sådana man litade på i Egypten för tillväxt och en säker och god skörd som gav välstånd. ");
INSERT INTO swe_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Faraos tjänare sa till honom: ”Hur länge ska den här mannen vara en snara för oss? Skicka iväg dessa människor så att de kan betjäna (hålla gudstjänst för) sin Gud (Elohim). Inser du inte att hela Egypten blir fördärvat?” ");
INSERT INTO swe_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mose och Aron hämtades till farao igen och han sa till dem: ”Gå och betjäna (håll gudstjänst för) Herren er Gud (Jahveh Elohim). Vilka är det som går?” ");
INSERT INTO swe_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose svarade: ”Vi ska gå med våra unga och våra gamla, våra söner och våra döttrar. Vi ska gå med våra fårflockar och boskapshjordar. För vi måste fira en Herrens (Jahvehs) högtid till honom (till Guds ära).” ");
INSERT INTO swe_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Men han sa till dem: ”Må Herren (Jahveh) vara med er om jag någonsin skulle låta er gå med era små. Se, ondska är i era ansikten. ");
INSERT INTO swe_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Inte på det viset. Gå nu, ni som är män, och betjäna (håll gudstjänst för) Herren (Jahveh), för det är vad ni önskar.” Sedan drevs de ut från faraos ansikte (närvaro). ");
INSERT INTO swe_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Sedan sa Herren (Jahveh) till Mose: ”Sträck ut din hand över Egyptens land så att gräshopporna kan komma upp över Egypten och äta varje planta som haglet har lämnat.” ");
INSERT INTO swe_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mose sträckte ut sin stav över Egyptens land och Herren (Jahveh) förde en östanvind över landet, hela den dagen och hela natten, när det blev morgon förde östanvinden med sig gräshoppssvärmarna. ");
INSERT INTO swe_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Gräshoppssvärmarna kom upp över hela Egyptens land och stannade kvar inom hela Egyptens område (innanför Egyptens samtliga gränser), så tätt att dess like aldrig varit tidigare, och inte heller ska bli igen. ");
INSERT INTO swe_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","De täckte hela marken så att den blev förmörkad, och de åt upp varenda planta i hela landet och all frukt från träden som haglet hade lämnat. Inte en enda tillstymmelse till något grönt, inget träd eller planta på fälten fanns kvar i hela Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Då kallade farao snabbt på Mose och Aron och sa: ”Jag har syndat mot Herren er Gud (Jahveh Elohim) och mot er. ");
INSERT INTO swe_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Förlåt nu min synd bara denna gång, be till Herren er Gud (Jahveh Elohim) så att han tar bort denna död ifrån mig.” ");
INSERT INTO swe_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Han Mose gick ut från farao och bad till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Då vände Herren (Jahveh) vinden så att den kom mycket starkt från väster och den förde bort gräshopporna och drev ut dem i Vasshavet (hebr. jam sof) Röda havet. Inte en enda gräshoppa blev kvar inom hela Egyptens område (innanför Egyptens samtliga gränser). ");
INSERT INTO swe_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Men Herren förhärdade (tillslöt) faraos hjärta och han lät inte Israels barn (söner) gå. ");
INSERT INTO swe_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Sedan sa Herren (Jahveh) till Mose: ”Sträck ut din hand mot himlen och det ska bli mörkt över hela Egyptens land. Ett mörker som man kan ta på.” Ps 105:28 Detta mörker var inget vanligt mörker utan ett som man fysiskt kan ta på och känna/erfara. Solguden Ra var den högsta i rang bland Egyptens gudar och nu kan han inte skingra detta mörker. Men dessutom fanns en annan gud som hette Apep som var en motståndare till Ra och som rådde över mörkret. Även han konfronterades i denna plåga eftersom Gud lät solen skina bland israeliterna och därmed visade att det var Gud som bestämde även över mörkret. ");
INSERT INTO swe_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mose sträckte ut sin hand mot himlen och det blev ett tjockt mörker över hela Egyptens land som varade i tre dagar. ");
INSERT INTO swe_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Den ene kunde inte se den andre och ingen kunde resa sig från sin plats på tre dagar. Men alla Israels söner (allt folk) hade ljus där de vistades. ");
INSERT INTO swe_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao kallade på Mose och sa: ”Gå, betjäna (håll gudstjänst för) Herren (Jahveh). Lämna bara era fårflockar och boskapshjordar, era små kan också gå med er.” ");
INSERT INTO swe_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Men Mose sa: Du måste också ge oss offer och brännoffer i våra händer, så att vi kan offra till Herren vår Gud (Jahveh Elohim). ");
INSERT INTO swe_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Vår boskap ska också gå med oss, inte en enda klöv ska lämnas bakom. Vi måste ta av dem för att betjäna Herren vår Gud (Jahveh Elohim). Själva vet vi inte hur vi ska betjäna Herren (Jahveh) förrän vi kommer dit. ");
INSERT INTO swe_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Men Herren (Jahveh) förhärdade (tillslöt) faraos hjärta och han var inte villig att låta dem gå. ");
INSERT INTO swe_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao sa till honom: ”Gå bort från mig. Akta dig för att komma inför mitt ansikte igen, för om (den dag – hebr. bejom) du ser mitt ansikte igen kommer du att dö.” ");
INSERT INTO swe_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose svarade: ”Som du talar du har nu själv sagt/önskat det, jag ska aldrig se ditt ansikte igen.” ");
INSERT INTO swe_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Sedan sa Herren (Jahveh) till Mose: ”Jag ska låta ännu en plåga komma över farao och Egypten. Därefter ska han låta er gå härifrån. När han låter er gå ska han med kraft (forcerat) kasta ut er (tvinga ut er) allihop härifrån. ");
INSERT INTO swe_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tala nu in i folkets öra och låt varje man bland er begära av sin granne, och varje kvinna av sin grannfru, juveler av silver och juveler av guld.” ");
INSERT INTO swe_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Herren (Jahveh) gav folket favör i egyptiernas ögon. Mannen Mose var verkligen, sannerligen stor i faraos tjänares ögon och i folkets ögon. I princip alla egyptier såg vid det här laget på Mose som en stor gud, kanske den störste, eftersom han, genom alla tecken som Herren låtit honom göra, nu hade visat att Egyptens alla olika gudar inte hade den makt som folket tills nu hade tillskrivit dem. ");
INSERT INTO swe_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mose sa till farao: ”Detta är vad Herren (Jahveh) säger: Vid midnatt ska jag gå ut mitt i Egypten (hebr. Mitsrajim), ");
INSERT INTO swe_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","och alla förstfödda i Egyptens land ska dö. Från faraos förstfödde som sitter på hans tron till den förstfödde bland tjänarinnorna vid kvarnen, tillsammans med allt förstfött bland boskapen. I denna plåga är det farao själv som utmanas. Farao var en av de högsta gudarna i Egypten tillsammans med gudinnan Isis som var barnens beskyddare. När det står allt förstfött gäller det oavsett ålder. Det är alltså inte bara barn som dör utan också äldre personer som är förstfödda i sin familj. Se även Heb 11:28 ");
INSERT INTO swe_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Det ska bli en stor gråt över hela Egyptens land, dess like har aldrig hörts förut och kommer inte att höras igen. ");
INSERT INTO swe_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Men inte så mycket som en hund kommer att morra (gläfsa; ordagrant: röra sin tunga) mot någon av Israels barn (söner), varken mot människa eller boskap, så att ni ska veta att Herren (Jahveh) gör åtskillnad mellan Egypten och Israel. ");
INSERT INTO swe_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Och alla dessa dina tjänare ska komma ner till mig och falla ner inför mig och säga: Dra ut, du och allt ditt folk som följer dig. Därefter ska jag gå.” Sedan gick han ut från farao i brinnande vrede. ");
INSERT INTO swe_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Herren (Jahveh) hade sagt till Mose: Farao ska inte lyssna på dig för att mina tecken ska bli mångfaldigade i Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose och Aron gjorde alla dessa tecken inför farao och Herren (Jahveh) förhärdade (tillslöt) faraos hjärta, så att han inte lät Israels barn (söner) gå ut ur hans land. ");
INSERT INTO swe_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Herren (Jahveh) hade talat till Mose och Aron i Egyptens land: ");
INSERT INTO swe_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","”Denna månad aviv/nisan – på våren ska vara den viktigaste månaden, den ska bli den första av årets månader.  Det judiska året  Israeliternas nya år ska börja med att komma ihåg uttåget från Egypten. Den första månaden är på hebreiska aviv och betyder månaden då axen mognar, det babyloniska namnet är nisan. Månaden motsvarar ungefär mars/april. De tolv månaderna från vår till vår är:  nisan (aviv), ijar (ziv), sivan, tamuz, av, elul, tishri, cheshvan, kislev, tevet, shvat och adar.  Vart annat eller tredje år läggs en 13:e månad till för att kompensera för de drygt 10 dagar som annars saknas i solåret. Denna extra månad kallas den andra adar (hebr. adar bet). För att särskilja den vanliga månaden adar kallas den för den första adar (hebr. adar alef). Högtiden purim, som alltid infaller i adar, firas i den andra adar då det är skottår, men många firar även lilla purim (hebr. purim qatan) redan under den första adar. Det judiska nyåret, då man växlar år, infaller sedan andra templets förstörelse (70 e.Kr.) dock på hösten i den 7:e månaden tishri på den första dagen som är rosh hashana (som är det namn som jom teroah, shofarhögtiden, kallas sedan 1600-talet). ");
INSERT INTO swe_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tala till hela Israels folk berätta för dem: På den 10:e dagen i denna månad ska varje familj ta ett lamm – ett lamm för varje hushåll. ");
INSERT INTO swe_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Om något hushåll är för litet för ett lamm om man är färre än tio personer, så ska mannen och hans närmsta granne dela på ett lamm. Beroende på hur mycket varje person äter och antal familjemedlemmar ska ni beräkna hur många som kan dela på ett lamm. ");
INSERT INTO swe_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Lammet ska vara felfritt (fullkomligt, oskyldigt) Heb 7:26; 1 Pet 1:19, av hankön, och ett år gammalt. Ni kan välja det bland fåren eller getterna. ");
INSERT INTO swe_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ni ska vakta (ta hand om det) fram till den 14:e i denna månad. Lammet ska vara separerat fyra dagar från de andra fåren. Sedan ska hela Israels folk slakta det vid skymningen (ordagrant: mellan de två kvällarna – hebr. ben arbajim). Mellan de två kvällarna är ett hebreiskt uttryck för tiden från det att solen börjar gå ner fram till solnedgången. I Israel är det någon gång mellan klockan tre och klockan sex på eftermiddagen. På Jesu tid hade man börjat tolka det som mellan tolv och sex, antagligen på grund av logistiska problem med att alla skulle slakta i templet och köa i stället för att alla slaktade hemma.  Detta är en förebild på Jesus som red in i Jerusalem fyra dagar före gripandet och korsfästelsen. På samma sätt som lammet här ska leva med och synas av den familj som sedan ska slakta och äta det, måste Jesus bli synad av prästerna i Jerusalem innan han kunde gå till korset. Även dörrposterna och tvärslån är en bild på korset där Jesus gav sitt blod (vers 7). Jesus var ett heloffer (vers 9). Jesu kropp togs ner från korset före kvällen (vers 19). ");
INSERT INTO swe_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","De ska ta från blodet och stryka det på de båda dörrposterna och på tvärslån över dörren i alla de husen där man ska äta det. ");
INSERT INTO swe_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","De ska äta köttet samma natt, de ska äta det stekt över eld med bröd bakat utan jäst som är en bild på att det inte har någon ondska i sig och med bittra örter för att påminna om slaveriet och lidandet i Egypten. ");
INSERT INTO swe_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ät inte köttet rått eller kokat i vatten, utan stekt över eld med huvudet, benen och innanmäte. ");
INSERT INTO swe_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ni får inte lämna kvar något till nästa morgon, det som blir kvar måste ni bränna upp i eld. ");
INSERT INTO swe_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Så här ska ni äta det: Var klädda som inför en resa ordagrant: var omgjordade kring länderna, dvs. bind upp rocken för att vara redo att ge sig av, ha sandalerna på era fötter och staven i er hand. Ni ska äta det med hast. Detta är Herrens (Jahvehs) påsk (hebr. pesach). Ordet påsk är en försvenskning av det hebreiska ordet pesach, som i sin tur går tillbaka till det hebreiska verbet pasach (vers 13, 23 och 27). En av betydelserna av verbet är att halta och hoppa (2 Sam 4:4; 1 Kung 18:21, 26) med den bildliga betydelsen att hoppa runt utan att landa i ett beslut i 1 Kung 18:21. I Jes 31:5 används pesach tillsammans med verben att beskydda, rädda, befria och flyga/sväva. Verbet används tre gånger i Andra Moseboken om påsken, där det traditionellt översätts ”passera förbi”. Dock finns ett vanligt verb avar, som betyder att passera och gå förbi. Utifrån parallellism i 2 Mos 12:12 är det förståeligt hur pesach kan ha fått denna betydelse i översättningar. Betydelsen att ”hovra över” visar hur Herren beskyddar israeliterna mot fördärvaren som går igenom landet. Parallellismen i 2 Mos 12:27 där Herren räddar, passar bättre in på att hovra och skydda än att passera. Här i 2 Mos 12:11 är första gången substantivet pesach förekommer. Totalt används det 49 (7 x 7) ggr, varav 22 är i Moseböckerna. Verbet används 7 ggr. Den bestämda formen ha-pesach (se vers 21) har talvärdet 153, jfr med Joh 21:11. ");
INSERT INTO swe_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","För samma natt ska jag passera igenom (hebr. avar) Egyptens land och attackera allt förstfött i Egypten, både människor och djur. Jag ska döma alla Egyptens gudar – Jag Är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Blodet som ni strukit på era hus ska vara ett tecken för mig på var ni är. När jag ser blodet ska jag hovra över er (hebr. pasach) sväva över och beskydda, rädda och befria, se Jes 31:5, och denna plåga ska inte komma över er och förgöra er när jag attackerar Egyptens land. På samma sätt ser Gud på oss idag när vi har accepterat Jesu försoning i våra liv. Då slipper vi straffet för våra synder eftersom Jesus tagit det i vårt ställe. ");
INSERT INTO swe_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Denna dag ska bli en dag som ni ska komma ihåg. Ni ska fira den som en Herrens (Jahvehs) högtid genom alla släktled, gör det till en sed (vana, tradition) för evigt. ");
INSERT INTO swe_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Under sju dagar ska ni äta osyrat bröd (bröd bakat utan jäst – hebr. matsa). Osyrat bröd är en bild på syndfrihet. På den första dagen måste ni ta bort all jäst (surdeg – hebr. chamets) från era hus. Den som äter bröd bakat med jäst mellan den första och sjunde dagen under högtiden ska bli utestängd (avskuren) från Israel. ");
INSERT INTO swe_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","På den första dagen av högtiden och även på den sjunde, samla alla till en helig sammankomst. Inget arbete ska göras på dessa två dagar, förutom att förbereda det som var och en behöver för att äta. ");
INSERT INTO swe_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ni ska fira det osyrade brödets högtid, därför att det var just den dagen som jag förde era härar ut ur Egypten. Det ska vara en evig stadga för er att fira denna dag från släkte till släkte. ");
INSERT INTO swe_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Från kvällen den 14:e dagen i första månaden ända till kvällen den 21:a dagen i månaden ska ni äta osyrat bröd. ");
INSERT INTO swe_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ingen jäst (surdeg) får finnas i era hus under dessa sju dagar av högtid. Den som äter något som har jäst i sig ska bli utestängd (avskuren) från Israel. Det spelar ingen roll om han är en främling eller född i landet principen gäller alla. ");
INSERT INTO swe_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Var ni än bor eller samlas, se till att inte äta bröd med jäst under den veckan.” ");
INSERT INTO swe_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Sedan kallade Mose till sig alla de äldste och sa till dem: ”Gå och tag ett småboskap (får, lamm) för varje familj, och slakta påskalammet (hebr. pesach). ");
INSERT INTO swe_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Tag en handfull isopstjälkar. Isop har en styv och förgrenad stjälk och blir upp till 0,5 meter lång. Doppa dem i skålen med blodet som ni tömt från lammet och stryk det ovanför dörren och ner på de båda dörrposterna. Ingen av er får sedan gå ut förrän nästa morgon. ");
INSERT INTO swe_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Herren (Jahveh) ska gå igenom (hebr. avar) landet under natten för att slå Egypten. Men när han ser blodet ovanför dörren och på de båda dörrposterna, ska han hovra över (hebr. pasach) beskydda, se vers 13 dörröppningen (hebr. mezozah) och inte tillåta fördärvaren dödsängeln, se även Ps 78:49; 1 Kor 10:10 att komma in i era hus och slå er. ");
INSERT INTO swe_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ni och era barn ska hålla denna händelse som en stadga för evigt. ");
INSERT INTO swe_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Även efter det att ni kommit in i det land som Herren har talat om lovat Israel, ska ni hålla (bevara) denna högtid (ceremoni, gudstjänst). ");
INSERT INTO swe_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","När era barn frågar er: ’Varför firar vi den här högtiden?’ Ordagrant: Vad betyder den här ceremonin för er? ");
INSERT INTO swe_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Då ska ni svara: ’Det är påskalammet åt Herren (Jahveh), därför att han hovrade över (hebr. pesach) beskyddade Israels barns hus i Egypten när han slog egyptierna, men räddade våra hus.’ ” Då böjde folket sig ner och tillbad. ");
INSERT INTO swe_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Sedan gick israeliterna och gjorde allt det som Herren hade befallt Mose och Aron. ");
INSERT INTO swe_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Så hände det vid midnatt att Herren (Jahveh) slog allt förstfött i Egyptens land från faraos förstfödde som sitter på hans tron till den förstfödde bland fångarna i fängelsehålan, tillsammans med allt förstfött bland boskapen. ");
INSERT INTO swe_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Då reste sig farao upp i natten, han och hans tjänare och alla egyptier och där var ett högt klagorop i Egypten, eftersom där inte fanns ett enda hus där ingen hade dött. När det gäller dateringen av uttåget finns det två teorier: den sena (1200-talet f.Kr.) och den tidiga (1400-talet f.Kr.), se 1 Kung 6:1 för mer info. Det enorma vulkanutbrottet på den grekiska ön Santorini (dåtida Thera) skulle kunna ge förklaringar på många av plågorna. Utbrottet orsakade jordbävningar, tsunamier och många kubikkilometer aska och pimpsten skakade några av Medelhavets tidiga civilisationer i grunden. Det skulle kunna förklara hur vattnet drog sig tillbaka och en enorm tsunami. Det skulle kunna synas en ”eldstod” på natten osv. Utbrottet som är det värsta någonsin har daterats till 1450 f.Kr. baserat på fynd från intilliggande civilisationer. Dateringar baserade på radiometriska mätningar placerar utbrottet tidigare 1628-1600 f.Kr. ");
INSERT INTO swe_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Han farao kallade på Mose och Aron mitt i natten och sa: ”Stå upp, gå ut från mitt folk, både ni och Israels söner (alla israeliter) och gå och betjäna (håll gudstjänst för) Herren (Jahveh) som ni har talat. ");
INSERT INTO swe_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ta era fårflockar och boskapshjordar, som ni har talat och försvinn! Men välsigna även mig.” ");
INSERT INTO swe_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nu uppmanade egyptierna folket ivrigt och enträget och skickade ut dem ur landet med hast, så fort de kunde, för de tänkte att annars dör vi allihop. ");
INSERT INTO swe_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Folket tog sin deg innan den hade hunnit jäsa och band upp sina baktråg i kläderna på sin skuldra (sina axlar). ");
INSERT INTO swe_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","På det viset gjorde Israels söner (folk) i enlighet med Moses ord. De bad egyptierna om föremål av silver och guld och kläder. ");
INSERT INTO swe_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Herren (Jahveh) gav folket favör i egyptiernas ögon så att de lät dem få allt de bad om. Så blev egyptierna plundrade. ");
INSERT INTO swe_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Sedan vandrade Israels barn (söner) från Ramses Tanis eller Zoan till Sukkot troligtvis Tell el Maskhuta, åt sydöst från Ramses, omkring 600 000 starka män över 20 år till fots, därtill barnen (familjerna). I 4 Mos 1 vid räkningen efter uttåget är de 625 550 män över 20 år. ");
INSERT INTO swe_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Också en blandad skara (icke-judar) drog upp med dem tillsammans med fårflockar, boskapshjordar och mycket nötkreatur. ");
INSERT INTO swe_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","De hade bakat osyrat (ojäst) bröd av degen som de tog med sig från Egypten. Den var ojäst eftersom de inte hann låta den jäsa när de blev utslängda från Egypten. Inte heller hade de hunnit proviantera (inför uttåget). ");
INSERT INTO swe_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tiden som Israels söner (folk) hade vistats i Egypten var 430 år. ");
INSERT INTO swe_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Och det hände sig att i slutet av de 430 åren, just på den dagen, att alla Herrens (Jahvehs) stora skaror (arméer – hebr. tsevaot) ordnade efter sina stammar drog ut från Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Det var en vaknatt för Herren (Jahveh) för att föra dem ut ur Egyptens land. Denna samma natt är en vaknatt för Herren (Jahveh), för alla Israels barn (söner) genom generationerna. ");
INSERT INTO swe_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Och Herren (Jahveh) sa till Mose och Aron: Detta är förordningen om påsken. Syftar både på högtiden och själva måltiden, påskalammet. Ingen främling får äta den, ");
INSERT INTO swe_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","men alla mäns tjänare som är köpta för pengar, när ni har omskurit dem ska de äta av det. ");
INSERT INTO swe_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","En besökare och en inhyrd tjänare ska inte äta av det. ");
INSERT INTO swe_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","I ett och samma hus ska det ätas, ni ska inte bära ut något av köttet ut ur huset, inte heller får något ben krossas. Detta avsnitt är en tydlig skuggbild av Jesus som vår påsk, vårt påskalamm, bara den som är omskuren enligt förbundets regler får äta, på samma sätt som bara den som är frälst, och därmed har sitt hjärta omskuret i det förnyade förbundet kan ta del av Jesus. Redan här förutsägs det också att inget av hans ben ska krossas och det skedde inte heller, se Joh 19:33; Ps 22:18. ");
INSERT INTO swe_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hela Israels församling måste hålla detta. ");
INSERT INTO swe_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Men om någon utomstående som bor bland er vill hålla påsken för Herren (Jahveh) måste alla män bli omskurna. Sedan kan de komma nära och hålla den. Han ska då räknas som en infödd i landet. Men ingen oomskuren ska äta av det. ");
INSERT INTO swe_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Samma undervisning (hebr. Torah) gäller för den infödde som för främlingen som bor bland er. ");
INSERT INTO swe_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Och alla Israels barn (söner) gjorde så. De gjorde precis som Herren (Jahveh) hade befallt Mose och Aron. ");
INSERT INTO swe_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Det var på exakt den dagen som Herren förde Israels barn (söner) ut ur Egyptens land som en härskara (armé – hebr. tsevaot). 2 Mos 12:17 ");
INSERT INTO swe_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","”Avskilj (helga) alla förstfödda åt mig, vad som än öppnar moderlivet bland Israels barn (söner), både bland människor och djur, det är mitt.” ");
INSERT INTO swe_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose sa till folket: ”Kom ihåg den här dagen, då ni kom ut ur Egypten, ut ur slavhuset (slaveriet), för med styrka förde Herrens (Jahvehs) hand er ut från denna plats. Inget syrat (hebr. chamets) bröd eller mat som innehåller jäst ska ätas. ");
INSERT INTO swe_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Denna dag i månaden aviv det kanaaneiska namnet på den första månaden i den bibliska kalendern (motsvarar mars/april; kallas också nisan), se 2 Mos 12:2 drog ni ut. ");
INSERT INTO swe_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Och det ska ske när Herren (Jahveh) ska föra er in i kanaanéernas och hettiternas och amoréernas och hivéernas och jevusiternas land, som han har lovat med ed till era fäder att ge er 1 Mos 12:1-3, ett land som flyter av mjölk och honung, att ni ska betjäna, hålla denna gudstjänst i denna månad. ");
INSERT INTO swe_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","I sju dagar ska du äta osyrat bröd, och den sjunde dagen ska bli en Herrens (Jahvehs) högtid. ");
INSERT INTO swe_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Alla de sju dagarna ska du äta bröd bakat utan jäst som är en bild på att det inte har någon ondska i sig, ingenting syrat får finnas hos dig och ingen surdeg någonstans i ditt land. ");
INSERT INTO swe_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","På den dagen ska du berätta för (upplysa) din son: ’Det är på grund av vad Herren (Jahveh) gjorde för mig när jag kom ut ur Egypten.’ ");
INSERT INTO swe_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Den högtiden ska vara som ett tecken på din hand och ett märke på din panna (mellan dina ögon) som ständigt påminner dig så att Herrens (Jahvehs) undervisning (hebr. Torah) alltid är i din mun, för det var med stark hand Herren förde dig ut ur Egypten. ");
INSERT INTO swe_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Därför ska du hålla denna högtid denna tid år efter år. ");
INSERT INTO swe_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Nu när Herren (Jahveh) för er in i kanaanéernas land, som han har lovat med ed till er och era fäder och ger det till er, ");
INSERT INTO swe_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","då ska ni avskilja för Herren alla förstfödda från livmodern, och alla förstfödda handjur som ni får ska tillhöra Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Varje förstfödd åsna ska du lösa ut med ett lamm, och om du inte löser ut det ska du bryta av dess nacke. Men du måste lösa ut varje förstfödd son bland dina söner. När det handlar om djuren är det alltså valfritt att lösa ut ett förstfött djur eller inte, men när det gäller människorna finns inte den valmöjligheten. Jesus är den som löser ut oss alla om vi låter oss bli utlösta. ");
INSERT INTO swe_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","När din son i framtiden frågar dig: ’Vad är detta?’ Ska du svara honom: ’Med stark hand förde Herren (Jahveh) oss ut från Egypten, ut ur träldomshuset, ");
INSERT INTO swe_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","och när farao vägrade att låta oss gå, slog Herren (Jahveh) allt förstfött i Egyptens land, både människor och boskap. Därför offrar jag allt förstfött av hankön till Herren (Jahveh) men jag löser ut alla förstfödda av mina söner.’ Ceremonin kallas Pidjon haben, hebreiska för ”friköpandet av sonen”, se 4 Mos 8:16. Seden praktiseras ännu i dag av ortodoxa judar. Fadern överlämnade sin son till en präst i templet och fick honom tillbaka mot en föreskriven symbolisk summa på fem silvermynt. En förstfödd från en prästsläkt – kohen – omfattas inte av budet, se 4 Mos 3:12. ");
INSERT INTO swe_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Så ska det bli som ett tecken på din hand och mellan dina ögon (på din panna), för med stark hand förde Herren (Jahveh) ut oss från Egypten.” ");
INSERT INTO swe_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Efter det att farao låtit folket gå, ledde Gud (Elohim) dem inte på vägen mot filistéernas land, även om den var närmast, kortast, för Gud (Elohim) sa: Folket kan ändra sig om de ser krig och vilja vända tillbaka till Egypten. Gud valde att inledningsvis skona folket från motgångar för att ge dem möjligheten att bli trygga i sin nya situation och lära sig förstå att Gud alltid är pålitlig. Men senare vill han lära oss att lita på honom även i motgång för det tillhör livet som frälst att kunna möta både med- och motgångar tillsammans med Gud. Denna vers lär oss att hjälpa nyfrälsta syskon så att vi skyddar dem från onödiga motgångar i början på sin vandring med Jesus. ");
INSERT INTO swe_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Gud lät folket gå runt genom öknen mot Vasshavet (Röda havet). Israeliterna marscherade som en krigshär (ordnade i strukturerade grupper) ut genom Egypten. Bibeln använder det generella ordet Vasshavet (hebr. jam sof) och sedan bara havet (2 Mos 14:2, 9, 16, 21, 22, 23, 26, 27, 28, 30; 15:1). I 1 Kung 9:26 refererar det till Aqabaviken och Röda havet vid nuvarande Eilat. Den grekiska översättningen Septuaginta skriver Röda havet. Eftersom Röda havet har två armar på vardera sidan om Sinaihalvön, den västra är Suezviken och den östra är Aqabaviken, finns flera förslag på exakt var israeliterna korsade Röda havet. ");
INSERT INTO swe_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose tog även med sig Josefs ben, eftersom han hade tagit en ed, ett löfte av Israels barn (söner), och sagt: Gud (Elohim) ska säkerligen komma ihåg er och då ska ni ta mina ben med er. Josef kände med säkerhet till det ord som Gud talat till Abraham när han sagt att de skulle vara slavar i Egypten under fyra generationer och sedan komma tillbaka till landet, se 1 Mos 15:13-16, därför tog han detta löfte av Israels söner som nu Mose uppfyller. ");
INSERT INTO swe_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israeliterna bröt upp från Sukkot och slog läger i Etam på gränsen till öknen. De tar inte den snabbaste havsvägen Via Maris (handelsvägen längs med havet mellan Egypten och Mesopotamien) som går genom filistéernas land, se vers 17, utan går i sydostlig riktning genom öknen Sinai. ");
INSERT INTO swe_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Herren (Jahveh) gick framför dem. På dagen i en molnstod (pelare av rök/moln) för att visa dem vägen och på natten i en eldstod (pelare av eld) för att ge dem ljus. På så sätt kunde de vandra både dag och natt. ");
INSERT INTO swe_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Han tog inte bort molnstoden på dagen och inte heller eldstoden på natten. ");
INSERT INTO swe_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Tala till israeliterna, att de ska vända om och slå läger utanför Pi Hachirot detta ord är snarlikt det hebreiska ordet herut, som betyder frihet mellan Migdol betyder torn och havet; mitt emot Baal Tsefon ska ni slå läger vid havet. ");
INSERT INTO swe_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao ska säga angående Israels söner (folk): De vandrar planlöst i landet, öknen har stängt in dem. Pi Hachirot betyder ”platsen där papyrusplantan växer” och bör vara i Egyptens lågland, troligtvis inte så långt från Nilen. En annan tolkning ger betydelsen ”ingången till grävningarna”, och i så fall refererar det till den kanal som byggdes i nordsydlig riktning, och som går genom regionen nära Qantara. Baal Tsefon är ”porten till norr”. Eftersom de vandrade söderut på Sinaihalvön var de omringade av vatten på alla sidor utom norrut och det kunde mänskligt sett verka helt meningslöst att gå den vägen, det skulle bara leda dem tillbaka till utgångspunkten om de inte hade några båtar som kunde ta dem över vattnet. ");
INSERT INTO swe_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Jag ska göra så att faraos hjärta förhärdas (tillsluts) och han ska komma efter dem, sedan ska jag bli förhärligad på farao tillsammans med hela hans armé och egyptierna ska veta att Jag Är Herren (Jahveh). Så blev det. ");
INSERT INTO swe_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","När man berättade för Egyptens kung att folket hade flytt förändrades faraos och hans tjänares hjärtan mot folket och de sa: Vad är det vi har gjort som låtit Israel lämna sin plats som våra slavar? ");
INSERT INTO swe_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Han farao gjorde i ordning sin vagn och tog sitt folk med sig. ");
INSERT INTO swe_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Han tog 600 av de finaste vagnarna tillsammans med alla andra vagnar i Egypten och härförare över dem. De flesta enheterna med vagnar under den här perioden var mellan 10 och 150, så 600 är ett stort antal, men inte orimligt. När Ramses II stred mot hettiterna vid slaget i Qadesh skröt hans fiende med 2 500 vagnar. ");
INSERT INTO swe_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Herren (Jahveh) förhärdade (tillslöt) faraos hjärta, kungen i Egypten, så att han jagade efter Israels söner (folk), eftersom Israels söner (folk) drog ut med en hög hand (självsäkert, stolt) i faraos ögon helt öppet och trotsigt. ");
INSERT INTO swe_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Men egyptierna jagade dem med alla faraos hästar och vagnar, liksom hans ryttare och hans armé, och kom ikapp dem där de var lägrade vid havet utanför Pi Hachirot mitt emot Baal Tsefon. På nytt nämns platserna, se vers 2. ");
INSERT INTO swe_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","När farao var nära, upptäckte israeliterna att egyptierna var på marsch mot dem, och israeliterna blev helt skräckslagna och ropade till Herren, ");
INSERT INTO swe_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","och de sa till Mose: ”Är det för att det inte finns några gravar i Egypten du fört oss ut hit för att dö i öknen? Varför har du behandlat oss så illa och fört oss ut ur Egypten? ");
INSERT INTO swe_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Var det inte detta ord vi talade till dig i Egypten? Vi sa: ’Lämna oss ifred så att vi kan vara slavar under egyptierna.’ Det är bättre för oss att tjäna egyptierna som slavar än att dö i öknen.” ");
INSERT INTO swe_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose sa till folket: ”Sluta att känna fruktan! Stå fasta (fly inte) och ni ska få se hur Herren befriar (frälser) er i dag. De egyptier ni ser i dag, ska ni aldrig mer se igen. Går också att översätta: ’Så som ni ser egyptierna idag, ska ni aldrig mer se dem igen.’ ");
INSERT INTO swe_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Herren ska strida för er, och ni ska vara stilla (tysta, döva; hålla er lugna; ta intryck).” Ordet stilla (hebr. charesh) har mer än en innebörd. Gud ville att israeliterna skulle stanna upp och vara tysta – dvs. upphöra med sina förskräckta rop och sitt uttalade missnöje, se vers 10, 11 och 12. De skulle vara likt dövstumma som bara skulle bevittna Guds ingripande – hur han skulle ta hand om den egyptiska armén som närmade sig. Grundordet har också betydelsen att gravera in eller plöja någonting, och i detta sammanhang handlar det om att låta hjärtat bli märkt av Guds frid och låta vetskapen om hans ingripande sjunka djupt in – mitt i och trots omständigheterna. ");
INSERT INTO swe_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Herren sa till Mose: ”Varför ropar du till mig? Tala till israeliterna att gå framåt ut i havet. ");
INSERT INTO swe_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lyft upp din stav och sträck ut din hand över havet och dela det, och israeliterna ska gå på torr mark rakt igenom havet. ");
INSERT INTO swe_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Och jag, se, skåda, jag ska förhärda (tillsluta) egyptiernas hjärtan och de ska jaga efter dem så att jag ska bli förhärligad på farao och hans armé, hans vagnar och ryttare. ");
INSERT INTO swe_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Då ska egyptierna veta att Jag Är Herren (Jahveh), när jag förhärligar mig på farao och hans vagnar och hans ryttare.” ");
INSERT INTO swe_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Guds (Elohims) ängel (budbärare), som vanligtvis gick före Israels läger (armé), flyttade sig och gick nu bakom dem, så molnstoden (pelaren av rök/moln) 2 Mos 13:21 flyttade sig från att vara framför dem och stod nu bakom dem. ");
INSERT INTO swe_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Den molnstoden, ängeln kom på det sättet emellan egyptiernas läger och israeliternas läger. Molnet var där med mörker för egyptierna, ändå gav det ljus där under natten åt israeliterna, ingen kom nära den andre på hela natten. Den hebreiska texten är inte helt tydlig i vers 20, som ordagrant lyder: ”Molnet och mörkret var där och lyste upp natten.” Den grekiska översättningen Septuaginta översätter: ”Mörkret föll, och hela natten gick utan att arméerna kom i närheten av varandra.” Poängen är att de båda lägren var åtskilda och ingen kunde passera molnstoden som var emellan dem. ");
INSERT INTO swe_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mose sträckte ut sin hand mot havet, och Herren drev undan havet med en stark vind från öster hela natten. Han förvandlade havet till torrt land och vattnet delades. ");
INSERT INTO swe_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israeliterna vandrade tvärs igenom havet på torr mark, medan vattnet stod som en mur på båda sidor om dem. Totalt är det omkring två miljoner människor som passerar genom havet den natten, se 2 Mos 12:37. ");
INSERT INTO swe_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Men egyptierna jagade efter dem och gick ut efter dem till mitten av havet, alla faraos hästar, hans vagnar och hans ryttare. ");
INSERT INTO swe_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nu hände det sig under morgonväkten den sista av de tre nattväkterna – från klockan två till klockan sex på morgonen att Herren (Jahveh) tittade ner på Egyptens armé från eldstoden och molnstoden och förorsakade panik (förvirring, tumult – hebr. hamam) i den egyptiska hären. Ordet för förvirring är snarlikt verbet för rörelse (hebr. hom) och att vråla och dåna (hebr. hamah). ");
INSERT INTO swe_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Han lät hjulen falla av den grekiska översättningen har ”fastna” deras vagnar och fick dem att köra tungt så att egyptierna sa: Gå bort från Israels ansikte (kom inte nära Israel) för Herren (Jahveh) strider för dem, mot egyptierna. ");
INSERT INTO swe_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Och Herren (Jahveh) sa till Mose: Sträck ut din hand över havet så att vattnet kommer tillbaka över egyptierna, över deras vagnar och över deras ryttare. ");
INSERT INTO swe_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Så Mose sträckte ut sin hand över havet och havet återvände till sin styrka när morgonen grydde och egyptierna flydde mot det och Herren (Jahveh) skakade ner (skingrade, kringströdde – hebr. naar) egyptierna mitt i havet. ");
INSERT INTO swe_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Och vattnet återvände och övertäckte vagnarna och ryttarna, liksom hela faraos armé som gått efter dem ut i havet, inte så mycket som en enda en av dem fanns kvar (överlevde). ");
INSERT INTO swe_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Men Israels barn (söner) vandrade på torr mark mitt i havet och vattnet stod som en mur för dem på deras högra sida och på deras vänstra sida. ");
INSERT INTO swe_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","På det sättet frälste (räddade) Herren (Jahveh) Israel ur egyptiernas hand den dagen och Israel såg egyptierna döda på stranden. ");
INSERT INTO swe_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Och Israel såg det stora verk som Herren (Jahveh) gjorde på egyptierna, och folket fruktade (vördade) Herren (Jahveh) och de trodde på Herren (Jahveh) och hans tjänare Mose. ");
INSERT INTO swe_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Då sjöng Mose och israeliterna denna sång till Herren, de sjöng: Jag vill sjunga till Herren, för han har vunnit en överväldigande seger. Häst och ryttare störtade (slungade) han ner i havet. ");
INSERT INTO swe_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Herren (Jah, kortformen av Jahveh, betecknar att han alltid har existerat) är min styrka (starkhet) och min lovsång, han blev min frälsning (räddning). Han är min Gud (El) och jag vill prisa honom, min faders Gud (Elohim) och jag vill upphöja honom. ");
INSERT INTO swe_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Herren (Jahveh) är en stridsman, Herren (Jahveh, Jag Är och har alltid existerat) är hans namn. ");
INSERT INTO swe_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Faraos vagnar och hans armé har han kastat i havet; hans högsta befälhavare dränktes också i Vasshavet (hebr. jam sof) Röda havet. ");
INSERT INTO swe_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Djupen har täckt dem, de sjönk till botten som stenar. ");
INSERT INTO swe_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Din högra hand, Herre (Jahveh), var majestätisk i kraft (helt överlägsen allt annat). Din högra hand, Herre (Jahveh), krossade fienden. ");
INSERT INTO swe_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I din stora härlighet (upphöjdhet, majestät) slog du ner dem som reste sig upp mot dig. Du släppte lös din förtärande eld (vrede) som förtärde dem som halm. Samma verb ”släpp lös” användes genomgående i kravet mot farao att ”släppa” israeliterna fria. Ironiskt nog släpps nu Guds eld lös över honom själv då han vägrade lyda Gud. ");
INSERT INTO swe_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","En fnysning från din näsa östanvinden som blåste under natten, se 2 Mos 14:21 dämde upp vattnen (staplade upp dem). det böljande (forsande vattnet) reste sig som en mur, vattenströmmarna stelnade i havets djup. ");
INSERT INTO swe_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Fienden sa: ”Jag ska jaga, jag ska hinna i kapp, jag ska fördela bytet, min vilja ska ske med dem, jag ska dra mitt svärd, min hand ska utrota dem.” ");
INSERT INTO swe_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","men du Herre blåste med din vind (andades), och havet övertäckte dem. De sjönk (virvlade ner) som bly i de väldiga vattnen. ");
INSERT INTO swe_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Vem bland gudarna alla avgudar som fanns i Egypten liknar dig, Herre (Jahveh)? Vem är som du – majestätisk i helighet (helt fullkomlig, totalt avskild från allt orent) motsatsen till all synd, värdig förundran (respekt, vördnad) under lovsång, du som gör under (förunderliga ting, mirakler)? ");
INSERT INTO swe_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Du sträckte ut din högra hand och jorden slukade dem. ");
INSERT INTO swe_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du i din nåd (omsorgsfulla kärlek) ledde folket som du återlöst (hebr. gaal) 2 Mos 6:6. Du har väglett dem i din styrka och i din heliga boning. ");
INSERT INTO swe_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","När folken hör bävar de. Ångest har tagit sitt grepp om Filistéens inbyggare. ");
INSERT INTO swe_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edoms ledare är skräckslagna. Ångest har gripit Moabs mäktiga män. Alla Kanaans invånare smälter bort. Ordet för att smälta betecknar en förändring som inte går att stå emot. Människorna skakar av skräck och kan inte göra någonting åt situationen. ");
INSERT INTO swe_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Skräck och fruktan ska falla över dem, genom din arms storhet ska de bli förstenade (bli stilla som stenar), till dess ditt folk har passerat, Herre (Jahveh), till dess folket som du friköpt passerat förbi. ");
INSERT INTO swe_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Du förde dem in och planterade dem på bergen av ditt arv, platsen, Herre (Jahveh), som du har gjort för dig själv att bo på, det heliga (templet), Herre (Adonai), som dina händer har förberett. ");
INSERT INTO swe_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Herren ska regera från evighet till evighet! ");
INSERT INTO swe_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","För faraos hästar med hans vagnar och hans ryttare gick ut i havet, men Herren (Jahveh) förde tillbaka vattnet över dem. Ändå kunde Israels söner (folk) gå mitt i havet på torr mark. ");
INSERT INTO swe_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Sedan tog profetissan Mirjam, Arons syster, en tamburin i sin hand och alla kvinnor följde henne med tamburiner och med dans, ");
INSERT INTO swe_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","medan Mirjam sjöng för dem: Sjung till Herren (Jahveh), för högt är han upphöjd! Hästen och dess ryttare har han kastat i havet! ");
INSERT INTO swe_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Sedan ledde Mose folket vidare från Vasshavet. De gick ut i öknen Shor. De gick tre dagar in i öknen och fann inget vatten. ");
INSERT INTO swe_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Och när de kom till Mara kunde de inte dricka Maras vatten för det var bittert. Därför kallades platsen Mara (som betyder bitter). ");
INSERT INTO swe_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Och folket knotade mot Mose och sa: Vad ska vi dricka? ");
INSERT INTO swe_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Och han ropade till Herren (Jahveh) och Herren (Jahveh) visade honom ett träd, och han kastade det hela, eller en del av det i vattnet och vattnet blev sött. Där gjorde han en stadga och en förordning för dem och där prövade han dem. Hebr. ets används om träd, men även grenar och bräder av trä, se Hag 1:8; Hes 37:16. Det kan vara någon mindre buske som Mose rycker upp och kastar i vattnet eller en gren från trädet. ");
INSERT INTO swe_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Han Mose sa: ”Om du hör Herren (Jahveh) din Guds (Elohim) röst och noga lyssnar till hans budord och håller alla hans förordningar, ska jag inte lägga på dig någon av de sjukdomar som jag lade på egyptierna, för jag är Herren din läkare (hebr. JHVH rafa).” Titeln Jahveh rafa är det första av förbundsnamnen som Herren låter Israels barn få veta. Det sker i den andra månaden i den hebreiska kalendern som är ijar (infaller i april/maj). På hebreiska består ordet av tre bokstäver alef–jod–resh (איר). Begynnelsebokstäverna för frasen ”Jag Herren din läkare” (tre hebreiska ord ani Jahveh rafa) är också alef, jod och resh – ijar. Frasen är alltså en akronym för månaden ijar, en månad som ofta förknippas med helande. ");
INSERT INTO swe_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sedan kom de till Elim där det fanns 12 vattenkällor och 70 palmträd. Där lägrade de sig vid vattnet. ");
INSERT INTO swe_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","När hela Israels folk vandrade ut från Elim och kom till Sinaiöknen, mellan Elim och Sinai, på femtonde dagen i andra månaden ijar – april/maj sedan de hade lämnat Egypten, ");
INSERT INTO swe_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","klagade hela Israels folk på (lade hela skulden på, ropade högljutt mot) Mose och Aron i öknen. ");
INSERT INTO swe_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israeliterna sa till dem: ”Om vi ändå hade fått dö för Herrens hand i Egyptens land, när vi satt vid köttgrytorna och hade tillräckligt med bröd, men ni har fört oss ut till den här öknen för att låta hela folket dö av hunger.” ");
INSERT INTO swe_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Då sa Herren (Jahveh) till Mose: ”Jag ska låta det regna bröd från himlen åt er. Folket ska gå ut och samla ett dagsbehov för varje dag, så jag kan pröva dem, om de vill vandra efter min undervisning (hebr. Torah) eller inte. ");
INSERT INTO swe_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","På den sjätte dagen ska de tillreda det de får in, och det ska vara dubbelt så mycket som det de samlar in de andra dagarna.” ");
INSERT INTO swe_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mose och Aron sa till israeliterna: ”I kväll ska ni veta att det är Herren (Jahveh) som har fört er ut från Egyptens land, ");
INSERT INTO swe_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","och i morgon ska ni se Herrens (Jahvehs) härlighet (ära, glans), för Herren har hört er klagan mot (oförmåga att lita på) honom. Vilka är vi Mose och Aron, att ni klagar på oss vi är bara budbärare, det är Gud ni klagat på.” ");
INSERT INTO swe_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose sa ordföljden i denna mening är i grundtexten abrupt och repeterar vers 6 och 7, det kan vara så att det återspeglar att Mose inte var en god talare: ”Ni ska förstå detta när Herren (Jahveh) ger er kött att äta på kvällen, och bröd på morgonen för att mätta er, eftersom Herren har hört er klagan, att ni klagar på honom. Vad gäller oss, vilka är vi? Er klagan är inte mot oss, utan mot Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mose sa till Aron: ”Säg till Israels folk, kom nära (samlas till gudstjänst inför) Herren (Jahveh) för han har hört hur ni har klagat.” ");
INSERT INTO swe_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Medan Aron sedan talade till israeliterna, tittade de alla mot öknen, och då syntes Herrens (Jahvehs) härlighet (ära, glans, påtagliga närvaro) i ett moln. ");
INSERT INTO swe_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","”Jag har hört israeliternas klagan. Tala till dem: ’Vid skymningen (ordagrant: mellan de två kvällarna) 2 Mos 12:6 ska ni få kött att äta, och på morgonen ska ni få bröd att äta så att ni blir mätta (får alla behov fyllda), så ska ni förstå att jag är Herren (Jahveh) er Gud (Elohim).’ ” ");
INSERT INTO swe_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Den kvällen kom det vaktlar i sådan mängd att de täckte hela lägret, och nästa morgon var öknen runt lägerplatsen våt av dagg. Vakteln är en flyttfågel, vid ett annat tillfälle förde Herren dem till lägret med hjälp av en vind, se 4 Mos 11:31. ");
INSERT INTO swe_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","När daggen var borta låg det ute i öknen något kornliknande (frasigt), tunt som rimfrost på marken. ");
INSERT INTO swe_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","När israeliterna såg det frågade de varandra: ”Vad är det här?” eftersom de inte visste vad det var. ”Vad är det här” är på hebreiska man hu, och ordet som senare används för manna är man. Mose sa till dem: ”Det är den mat som Herren ger er att äta. ");
INSERT INTO swe_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Detta är vad Herren har befallt: ’Samla in det ni behöver för att bli mätta, en omer ca 3 liter per person. Ta till alla dem som bor i ditt tält.’ ” Per person är ordagrant ”per skalle” (hebr. gul-golet) jämför ordet golgata, se Joh 19:13. Omer-måttet, som var dagsbehovet av manna för en person, definieras i vers 36 till en tiondels efa. ");
INSERT INTO swe_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israeliterna gjorde så, och några samlade mer, andra mindre. ");
INSERT INTO swe_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","När de mätte upp det med ett omer-mått, hade den som samlat mycket ingenting över, och den som hade samlat lite inte för lite. Var och en hade samlat så mycket som han behövde till mat. ");
INSERT INTO swe_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose sa också till dem: Låt ingen spara någonting av detta till morgonen. ");
INSERT INTO swe_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Likväl lyssnade (lydde) de inte på Mose. Några av dem sparade det till nästa morgon, men det växte maskar i det och det ruttnade. Och Mose blev vred (hebr. qatsaf) på dem. ");
INSERT INTO swe_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Så de samlade det morgon för morgon, var och en efter sitt eget behov, och när solen blev varm (steg högre på himlen) smälte det (bort). ");
INSERT INTO swe_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","På sjätte dagen samlade de dubbelt så mycket bröd, två omer omkring 6 liter till varje person. Och alla ledare för folket kom och berättade för Mose. ");
INSERT INTO swe_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Men han sa till dem: ”Detta är vad Herren (Jahveh) har talat. I morgon är det sabbatsvila, en helig sabbat för Herren (Jahveh). Baka allt ni har lust till och koka det ni vill koka. Lägg undan åt er allt som blir över och spara (bevara) det till i morgon.” ");
INSERT INTO swe_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Så de sparade det till morgonen, precis som Mose instruerat och det ruttnade inte och det föddes inga maskar i det. ");
INSERT INTO swe_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Sedan sa Mose: Ät detta idag, för idag är det Herrens sabbat. Idag hittar ni ingenting på marken. ");
INSERT INTO swe_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ni ska samla det under sex dagar men den sjunde dagen är sabbat, och då finns det ingenting. ");
INSERT INTO swe_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Likväl, på den sjunde dagen gick några ut för att samla, men de fann ingenting. ");
INSERT INTO swe_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Herren (Jahveh) sa till Mose: Hur länge ska ni vägra att hålla mina budord och min undervisning (hebr. Torah)? ");
INSERT INTO swe_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Se, Herren (Jahveh) har gett er sabbaten, så på den sjätte dagen ger han er bröd för två dagar. Låt var och en stanna på sin plats och låt ingen gå ut på den sjunde dagen. ");
INSERT INTO swe_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Då vilade folket på den sjunde dagen. ");
INSERT INTO swe_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israels hus gav det namnet manna. Det var vitt som korianderfrö och smakade som rån gjorda med honung. ");
INSERT INTO swe_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Sedan sa Mose: Detta är vad Herren (Jahveh) har befallt: Låt en full omer ca 3 liter av det bevaras för kommande generationer, så att de ser brödet som jag mättade er med i öknen, när jag förde er ut ur Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mose sa till Aron: Ta en kruka och fyll den med en full omer ca 3 liter av manna. Spara den inför Herren (Jahveh) så att den bevaras för kommande generationer. ");
INSERT INTO swe_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Precis som Herren (Jahveh) befallde Mose, sparade Aron det framför vittnesbördet, så att det bevarades. ");
INSERT INTO swe_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israels barn (söner) åt manna i 40 år. De åt mannat till dess de kom för att bosätta sig i landet, när de kom till gränsen av Kanaans land. Jos 5:11-12 ");
INSERT INTO swe_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","En omer ca 3 liter – dagsbehovet av manna för en person, se vers 16 är en tiondels efa. Både omer och efa var volymmått. Citat från olika antika texter visar att efa-måttet var allt från 20 till 45 liter. En tiondels efa (en omer) motsvarar då omkring 3 liter. Måttet omer används bara i detta kapitel. Det hebreiska ordet omer kommer från amar som betyder samla och binda kärvar. Måttet var troligen unikt för ökenfärden och var inte i bruk på senare tid, eftersom Mose förklarar hur många efa det motsvarar i denna kommentar i slutet på detta stycke som är som en fotnot. Omer-måttet ska inte förväxlas med chomer-måttet som används i 3 Mos 27:16; 4 Mos 11:32; Hes 45:11, 13-14. ");
INSERT INTO swe_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Hela Israels folk fortsatte sin vandring från Sinaiöknen och följde Herrens instruktioner de följde molnstoden, se 4 Mos 9:18, 19. De slog läger i Refidim, men där fanns inget vatten att dricka för folket. Detta är ett mycket torrt område i södra Sinaiöknen utan några vattenkällor. Israeliterna beräknas vara omkring två miljoner människor, se 2 Mos 12:37. ");
INSERT INTO swe_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Då började folket strida mot Mose (de ställde honom inför rätta och gjorde en rättslig tvist av denna fråga och ville avsätta honom). De sa: ”Ge oss vatten att dricka.” Mose svarade: ”Varför strider ni med mig? Varför frestar (prövar) ni Herren?” ");
INSERT INTO swe_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Men folket var så uttorkade och i desperat behov av vatten att de fortsatte att klaga på Mose och muttrade: ”Varför förde du oss ut ur Egypten? Var det för att vi, våra barn och vår boskap skulle dö av törst?” ");
INSERT INTO swe_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Då ropade Mose till Herren och sa: ”Vad ska jag ta mig till med detta folk? De är nästan redo att stena mig till döds.” ");
INSERT INTO swe_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Herren svarade Mose: ”Gå framför folket och ta med dig några av de äldste i Israel. Ta den stav i din hand som du hade då du slog på Nilen, och börja gå. ");
INSERT INTO swe_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Jag ska stå framför dig på klippan vid Horeb (hebr. Chorev) Sinai berg, och du ska slå på klippan, och då ska det komma vatten från den så att folket kan dricka.” Mose gjorde så inför de äldste i Israel. ");
INSERT INTO swe_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Han gav platsen namnet ”Massa” och ”Meriva”, eftersom israeliterna hade stridit mot Mose och Gud och eftersom de frestat (prövat) Herren, och sagt: ”Är Herren med oss eller inte?” Det hebreiska ordet massa betyder fresta och pröva. Ordet meriva betyder strida, provocera. ");
INSERT INTO swe_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sedan kom amalekiterna och stred med Israel vid Refidim betyder: ”viloplats”. Amalekiterna var ättlingar till Abraham via Esau, se 1 Mos 36:15. De var ett nomadfolk som bodde i Negev och Sinai och levde på att plundra, se Dom 3:13. De hade tämjt kamelen och använde den i sina attacker. Kamelen kan springa 70 km/h (mycket snabbare än en häst) och var väl lämpad att användas för överraskningsattacker av de amalekitiska rövargängen, se Dom 6:3, 5. Ryktet om israeliternas vandring och de tillgångar de hade med sig hade säkert nått amalekiterna som nu rörde sig söderut för att få ett lätt byte. I 5 Mos 25:17-18 beskrivs hur de på ett fegt sätt attackerade och isolerade en del av de tröttaste israeliterna som var längst bak. De beskrivs också som gudlösa. I berättelsen som följer här indikeras också att de var bättre rustade militärt sett än israelerna, och hade inte Gud gripit in på ett övernaturligt sätt när Mose, Aron och Hur bett, skulle de lätt besegrat israeliterna, se vers 11.  Den exakta platsen för Refidim är okänd. Eftersom det inte fanns vatten, kanske det inte var en oas som oftast annars rastplatserna var. Ordet Refidim är plural och kommer från hebr. refida som betyder ryggstöd och har med att ligga ner och vila men även stöd. Ordet knyter an till att det var en ”rastplats” men även till att Aron och Hur ”stöttade” Moses armar i bönen. ");
INSERT INTO swe_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose sa till Josua: ”Välj ut åt oss män, gå ut och strid med amalekiterna. I morgon ska jag stå på toppen av kullen med Guds (Elohims) stav i min hand.” ");
INSERT INTO swe_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josua gjorde som Mose hade sagt och stred med amalekiterna, medan Mose, Aron Moses bror och Hur (hebr. Chor) en vän; konstnären Betsalels farfar, se 2 Mos 31:2 gick upp till toppen av kullen (höjden – hebr. giva). ");
INSERT INTO swe_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","När Mose höll upp sin hand hade Israel övertaget, men när han lät sin hand falla (lät den vila) hade amalekiterna övertaget. ");
INSERT INTO swe_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moses hand blev tung, så de tog en sten och lade under honom och han satte sig på den. Aron och Hur (hebr. Chor) höll upp hans händer, en på ena sidan och den andra på andra sidan. Och hans händer var stadiga (stabila; ordagrant ”sanna” – hebr. emonah) till dess att solen gick ner. Detta är första gången det hebreiska ordet emonah förekommer. Det är ett rikt ord som betyder stabilitet, trofasthet och även sanning. Det kommer från ordet för sanning (hebr. emet) som rent bokstavligt också står stadigt, se inledningen till Ps 12. Emonah används totalt 49 ggr och 22 av dem i Psaltaren. ");
INSERT INTO swe_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Josua försvagade (slog ner – hebr. chalash) ovanligt ord, se Job 14:10; Jes 14:12 Amalek och hans folk med svärdseggen (bokstavligt ”svärdets mun” – hebr. peh cherev). ");
INSERT INTO swe_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Herren sa till Mose: ”Skriv ner detta som ett minne i en skrift (bokrulle), och upprepa det i Josuas öron (läs/berätta det för honom), för jag ska utplåna radera – som ett manuskript som görs rent från skrift minnet av Amalek under himlarna (ordagrant: ’från under himlarna’).” Detta är första gången som det antyds att Josua är den som kommer efterträda Mose. Skriftrullen kan syfta på Andra Moseboken, eller en annan separat bokrulle. I 5 Mos 25:17-19 upprepas denna uppmaning att inte glömma vad amalekiterna gjorde. Att Amaleks minne helt ska utplånas på jorden beskrivs utifrån Guds perspektiv – jag ska utplåna från himlarna. I Predikaren används perspektiven ”under solen” (Pred 1:1) och ”under himlarna” (Pred 3:1; 2 Kor 12:2) som är det högsta och utgår från Guds tronrum. ");
INSERT INTO swe_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Då byggde Mose ett altare och gav det namnet Herren mitt segerbaner (Jahveh Nissi). ");
INSERT INTO swe_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Han sa: ”Handen på Herrens (Jahs) tron, Herren (Jahveh) ska strida med Amalek från generation till generation (släkte till släkte).” Detta är den första fiende som Israel strider med efter uttåget. Orden här är profetiska, flera strider utkämpas med Amalek genom åren. Så småningom får kung Saul uppdraget att bekämpa amalekiterna och vid det tillfället säger profeten Samuel att allt ska tillspilloges, men Saul är olydig (1 Sam 15:1-3). Senare under drottning Esters tid heter fienden Haman, även han en amalekit (Est 3:1). Amalek är ursprunget till allt judehat och antisemitism. ");
INSERT INTO swe_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Nu hörde Jetro (hebr. Jitro), prästen i Midjan och Moses svärfar 2 Mos 2:15, om allt som Gud (Elohim) hade gjort för Mose och för sitt folk Israel och hur Herren (Jahveh) hade fört Israel ut ur Egypten (hebr. Mitsrajim – det inträngda landet). ");
INSERT INTO swe_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jetro, Moses svärfar, hade tagit hand om Moses hustru Sippora 2 Mos 2:21 efter att Mose sänt iväg henne ");
INSERT INTO swe_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","med hennes två söner 2 Mos 4:24-26. En den förstfödde hade namnet Gershom på hebreiska låter det som ”främling där”, se 2 Mos 4:22, eftersom han sa: ”Jag är en främling i ett annat land”, ");
INSERT INTO swe_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","och namnet på den andra var Elieser Eliezer, på hebreiska låter det som ”Gud – min hjälp”, eftersom han sa: ”Min faders Gud (Elohim) är min hjälp, och räddade mig från faraos svärd.” ");
INSERT INTO swe_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Så Jetro, Moses svärfar, kom med hans söner och hans hustru till Mose i öknen där han slagit läger på Guds (Elohims) berg. ");
INSERT INTO swe_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Han sa till Mose via en budbärare: ”Jag, din svärfar Jetro, kommer till dig, och din hustru och hennes två söner.” I vers 5 står det ordagrant ”hans söner” och ”hans fru”, här är det ”hennes barn”, se även vers 3. För att det ska bli deras barn behövs båda föräldrarnas medverkan i uppfostran. ");
INSERT INTO swe_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Då gick Mose ut för att möta sin svärfar och böjde sig ner och kysste honom. De frågade varandra om hur det stod till (varandras väl och ve) och de kom in i tältet. ");
INSERT INTO swe_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose återgav (räknade upp – hebr. safar) för sin svärfar allt som Herren (Jahveh) hade gjort mot farao och egyptierna för Israels skull, liksom alla prövningar som kommit över dem under vägen och hur Herren (Jahveh) hade hjälpt dem. ");
INSERT INTO swe_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro gladdes (var mycket glad) över all den godhet som Herren (Jahveh) hade visat mot Israel, eftersom han hade befriat dem ur Egyptens hand. ");
INSERT INTO swe_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Och Jetro sa: ”Välsignad är Herren (Jahveh) som har befriat er ur egyptiernas hand och ur faraos hand och har befriat folket från Egyptens hand. ");
INSERT INTO swe_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu vet jag att Herren (Jahveh) är större än alla gudar, eftersom de har handlat övermodigt mot dem. ");
INSERT INTO swe_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Sedan bar Jetro, Moses svärfar, fram ett brännoffer och offrade det till Gud (Elohim). Aron kom också, tillsammans med alla äldste från Israel, för att äta bröd med Moses svärfar inför Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nästa dag satt Mose och dömde folket och de stod runt Mose från morgonen till kvällen. ");
INSERT INTO swe_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","När Moses svärfar Jetro såg allt han gjorde för folket, sa han: ”Vad är det du gör för folket? Varför sitter du själv, ensam, med allt folket stående omkring dig från morgon till kväll?” ");
INSERT INTO swe_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose svarade sin svärfar: ”Det är för att folket kommer till mig för att fråga Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","När de har ett bekymmer kommer de till mig och jag dömer mellan en man och hans granne. På det sättet får jag dem att förstå Guds (Elohims) stadgar och undervisning (hebr. Torah) instruktionerna i de fem Moseböckerna.” ");
INSERT INTO swe_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Men Moses svärfar Jetro sa till honom: ”Det du gör är inte bra. ");
INSERT INTO swe_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Du kommer att trötta ut dig själv, liksom folket som är med dig, för uppgiften är för stor för dig. Du kan inte göra allt själv, ensam. ");
INSERT INTO swe_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Lyssna till min röst (på det som jag säger), jag ska ge dig råd och Gud (Elohim) ska vara med dig. Du representerar folket inför Gud och tar deras angelägenheter till Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Upplys dem om stadgar och undervisning, och visa dem vilken väg de måste gå och vilket arbete de måste utföra. ");
INSERT INTO swe_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Men du ska leta upp kapabla män bland allt folket, män som fruktar (vördar, respekterar) Gud (Elohim), sanningsenliga män (män som håller sig till sanningen), som hatar mutor. Utse dem till att råda över tusen, hundra, femtio och tio. ");
INSERT INTO swe_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Låt dem döma folket under alla tider. Låt sedan alla stora (komplicerade) ärenden tas till dig men alla småärenden kan de döma själva, på det sättet delar de bördan med dig (avlastar dig). ");
INSERT INTO swe_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Om du gör detta (på det sätt) som Gud (Elohim) har befallt dig, ska du kunna uthärda (klara av arbetsbördan) och alla dessa människor ska gå till sin plats i frid (shalom, tillfreds med lösningen på sina problem). ");
INSERT INTO swe_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose lyssnade på sin svärfar och gjorde allt som han sagt. ");
INSERT INTO swe_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mose valde ut dugliga män från hela Israel och gjorde dem till ledare över folket, ledare för 1 000, 100, 50 och 10. ");
INSERT INTO swe_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","De dömde folket hela tiden. De svåra (komplicerade) ärendena tog de till Mose, men alla småsaker dömde de själva. ");
INSERT INTO swe_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sedan lät Mose sin svärfar lämna och han gick sin väg till sitt eget land. ");
INSERT INTO swe_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","I den tredje månaden, efter att Israels barn (söner) hade gått ut från Egyptens land – just på den dagen vid nymåne, den 1:a sivan – kom de till Sinais öken. Israeliterna lämnade Egypten vid midnatt den 15:e nisan (2 Mos 12:31), vandrade under månaden ijar (april/maj) och kom fram till Sinai öken 2,5 månader senare den 1:a sivan. ");
INSERT INTO swe_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","De lämnade nämligen Refidim och kom till Sinais öken och slog läger i öknen. De slog läger framför berget Sinai/Horeb. Exakt var Sinaiberget (också kallat berget Horeb) ligger är inte klargjort. Enligt tidig kristen tradition är det Jebel Musa på Sinaihalvön (här finns Katarinaklostret, enligt tradition grundat 337 e.Kr. av kejsarinnan Helena). Ett annat förslag är Jabal al-lawz på arabiska halvön. Ett tredje är Hashem el-Tarif inte så långt från Eilat. Fler förslag är Jebel Sinn Bishr (norra Sinai), Helal, Jebel Serbal (södra Sinai), Karkom (Israel). De kriterier som Bibeln anger är:  • 11 dagsresor från Kadesh Barnea (5 Mos 1:2), om man går 15 km per dag motsvarar det 16 mil.  • 14 dagsturer från Elim, eftersom de kom till Sinai 50 dagar efter uttåget, se 2 Mos 16:1.  • Inte längre än att man kan föra en fårhjord från Midjan dit, se 2 Mos 3:1-22. ");
INSERT INTO swe_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose gick upp till Gud (Elohim), och Herren (Jahveh) talade till honom från berget: ”Så ska du säga till Jakobs hus (släkt) och berätta för israeliterna: ");
INSERT INTO swe_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","’Ni har själva sett vad jag gjort med egyptierna och hur jag lyfte er på örnvingar och förde er till mig själv. ");
INSERT INTO swe_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Och nu, om ni noggrant lyssnar till mig och håller mitt förbund, då ska ni vara min dyrbara egendom med speciellt privilegium, men också väldigt ansvar framför (ut från) alla andra folk, för hela jorden är min. ");
INSERT INTO swe_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Och ni ska vara ett rike av präster (hebr. kohanim) för mig och ett heligt folk avskilt för ett uppdrag.’ 2 Mos 12:1-3 Detta är vad du ska tala till israeliterna.” Uttrycket ”rike av präster” är unikt här för hela GT (även om språket är snarlikt i Jes 61:6). Ordet rike förutsätter en kung, vilket är Herren själv. En präst (hebr. kohen; plural kohanim) har i sin betydelse att vara en som tjänar en överordnad. Israeliterna har ett uppdrag att vara Guds representanter för världen, se 2 Mos 19:5. Den tolkningen stöds även i hur frasen används i NT, se 1 Pet 2:9; Upp 1:6. Den första prästen (kohen) som nämns i GT är Melkisedek, se 1 Mos 14:18. Ordet används även om präster, se 1 Mos 41:45; 2 Mos 3:1; 1 Kung 4:5. ");
INSERT INTO swe_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","När Mose kom tillbaka sammankallade han folkets äldste. Han lade fram för dem alla dessa ord som Herren (Jahveh) hade befallt honom att säga, ");
INSERT INTO swe_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","och hela folket svarade tillsammans: ”Allt som Herren (Jahveh) har talat ska vi göra.” Mose gick tillbaka till Herren (Jahveh) med folkets svar. ");
INSERT INTO swe_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Herren (Jahveh) sa till Mose: ”Jag är på väg att komma till dig i ett tjockt moln så att folket ska höra när jag talar med dig och tro på dig för alltid.” Sedan berättade Mose folkets ord för Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Herren (Jahveh) sa till Mose: ”Gå till folket och helga dem idag och i morgon. Låt dem tvätta sina kläder. ");
INSERT INTO swe_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Var redo på den tredje dagen. För på den tredje dagen ska Herren (Jahveh) komma ner på berget Sinai i folkets åsyn. ");
INSERT INTO swe_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Du ska sätta upp gränser för folket runtom och säga: ’Var noggranna med att inte gå upp på berget eller beröra dess gräns. Den som rör berget ska med säkerhet dödas. ");
INSERT INTO swe_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Inte en hand får röra det att röra vid en död kropp gjorde en person oren, se 4 Mos 5:2, utan blir stenad eller genomborrad, oavsett om det är ett djur eller en människa, ska det inte leva.’ När shofaren (vädurshornet) ljuder, ska de komma till berget.” ");
INSERT INTO swe_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Sedan gick Mose ned från berget till folket, helgade dem och sedan tvättade de sina kläder. ");
INSERT INTO swe_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Han sa till folket: ”Var redo på den tredje dagen. Kom inte nära era fruar (ha inget sexuellt umgänge).” 3 Mos 15:16-18 ");
INSERT INTO swe_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","På morgonen på den tredje dagen var det åska (röster) och blixtar (ljungeldar), ett tjockt moln på berget och tonen (ljudet) av en extraordinärt skarp (hög, ljudlig) shofar. Allt folket i lägret bävade. Det finns några intressanta kommentarer till detta avsnitt i den judiska traditionen. Rabbi Johanan skriver: ”Guds röst delades i 70 röster som talade på 70 språk så att alla länder kunde förstå. När varje land hörde rösten på sitt eget modersmål ingav det dem fruktan.” Här finns likheter till vad som skedde på pingsten, se Apg 2:1-13. ");
INSERT INTO swe_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Då förde Mose ut folket ur lägret för att möta Gud (Elohim), och de stod på den lägsta delen av berget. ");
INSERT INTO swe_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nu var hela Sinai berg höljt i rök, eftersom Herren (Jahveh) hade stigit ned på det i eld. Röken steg upp som röken från en ugn. Hela berget skakade kraftigt. ");
INSERT INTO swe_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","När ljudet av shofaren blev starkare och starkare talade Mose och Gud (Elohim) svarade honom med ett åskmullrande ljud. ");
INSERT INTO swe_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Sedan kom Herren (Jahveh) ner till berget Sinai, till toppen på berget. Herren kallade upp Mose till toppen på berget, så Mose gick upp. ");
INSERT INTO swe_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Sedan sa Herren (Jahveh) till Mose: ”Gå ner och varna folket, så att de inte bryter igenom (gränsen) och ser Herren (Jahveh) och många av dem dör. ");
INSERT INTO swe_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Även prästerna som kommer nära Herren (Jahveh) måste helga sig själva så att Herren (Jahveh) inte far ut (blir vred) mot dem.” ");
INSERT INTO swe_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose sa till Herren (Jahveh): ”Folket kan inte komma upp på berget Sinai för du är den (den ende) syftar på att Herren är en, som det står i 5 Mos 6:4 som har varnat oss och sagt: Sätt gränser runt berget och håll det helgat.” ");
INSERT INTO swe_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Sedan sa Herren (Jahveh) till honom: ”Gå ner. Du ska komma tillbaka upp, du och Aron med dig. Men låt inte prästerna och folket bryta igenom för att komma upp till Herren (Jahveh), annars ska han fara ut mot dem.” ");
INSERT INTO swe_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Så Mose gick ner till folket och berättade för dem. ");
INSERT INTO swe_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Sedan talade Gud dessa ord: ");
INSERT INTO swe_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Jag är Herren din personliga Gud (Jahveh Elohim), som förde dig ut ur Egyptens land, ut ur slavhuset (slaveriet). Det hebreiska namnet för Egypten är Mitsrajim. Det ordet användes inte av egyptierna själva, de hade namnet Tavi som betyder ”två länder” och troligtvis syftar på övre och nedre Egypten. Det hebreiska ordet Mitsrajim härstammar från namnet på Chams (Hams) andra son Mitsrajim (1 Mos 10:6). Mitsrajim står i formen dual, vilket kan ha att göra med kopplingen till det övre och nedre Egypten. Betydelsen är inte helt känd, men ordet liknar ord som belägring, inträngd osv. Genom att använda detta ord, följt av ”ur slaveriet”, blir Guds befrielseverk bredare och handlar inte bara om israeliternas fångenskap i Egypten, utan kan appliceras på alla möjliga situationer och områden som kan förslava och tränga in från den plan Gud har för en människa. Genomgående används andra person singular (din, dig) – Gud är en personlig frälsare. ");
INSERT INTO swe_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du ska inte ha några andra (främmande) plural gudar (elohim) vid sidan av mig (ordagrant: ”över mitt ansikte”; som konkurrerar med min plats). ");
INSERT INTO swe_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du ska inte göra dig någon bildstod staty i trä eller sten eller någon avbild av något uppe i himlen eller nere på jorden eller i vattnet under jorden. ");
INSERT INTO swe_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Du ska inte tillbe (böja dig inför) dem, och inte heller tjäna dem. Ordet för att tjäna (hebr. avad) betyder både att tjäna något gudomligt och att arbeta. Samma ord används i vers 9 om att ”arbeta” sex dagar, se även 1 Mos 2:5; 15. För Gud hör tillbedjan och arbete ihop och är inte åtskilda som i grekiskt tänkande där det heliga och det profana skiljs åt. Jag, Herren (Jahveh) din Gud (Elohim), är en nitälskande Gud hebr. El qana; en avundsjuk Gud (i fråga om avgudadyrkan och falsk tillbedjan) som kräver odelad lojalitet. Jag låter fädernas synd drabba (besöker, konsekvenserna av denna synd drabbar) barnen fram till tredje och fjärde släktled när man hatar mig, ");
INSERT INTO swe_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","men visar min trofasta kärlek mot tusenden i tusen generationer när man älskar mig och håller mina budord. ");
INSERT INTO swe_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du ska inte representera (ordagrant: ”lyfta upp”, ”bära”) Herrens (Jahvehs) namn (hans karaktär) på ett felaktigt sätt (tanklöst, i tomhet). Herren ska inte låta den som missbrukar hans namn vara ostraffad. Ofta har detta bud förringats till att inte nämna Guds namn på ett lättsinnigt sätt eller att inte svära. Att ”bära” Herrens namn har innebörden att inte häda hans namn, men tyngdpunkten finns i att inte representera honom och hans karaktär på ett felaktigt sätt. Detta skulle kunna beskrivas som ”religiös ondska” som sker i Guds namn. Om en ogudaktig begår onda handlingar är det illa. När någon som säger sig tro på Gud gör samma onda handling och säger att det är i Guds namn, begår denne inte bara ondska utan skadar även människors syn på Gud. Man behöver inte ha en kristen tro för att begå detta brott. En islamist som i Guds namn ropar Allahu akbar (”Gud är större” på arabiska) och mördar, gör att det är svårare för människor att tro att det kan finnas en god Gud. Ett av de vanligaste argumenten mot den kristna tron är just brott mot detta bud begångna av korsfarare förr i tiden, eller idag av islamister. ");
INSERT INTO swe_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Följande gäller dig och din familj: Kom ihåg sabbatsdagen och håll den helgad avsätt den som en speciell dag dedikerad till Gud. ");
INSERT INTO swe_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sex dagar ska du arbeta och uträtta alla dina sysslor (vardagliga arbetsuppgifter), ");
INSERT INTO swe_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","men den sjunde är Herren (Jahveh) din Guds (Elohims) sabbat. Då ska du inte utföra något arbete, varken du eller din son eller din dotter, din tjänare eller din tjänarinna, din boskap eller invandraren inom dina portar (i dina städer). ");
INSERT INTO swe_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","För under sex dagar färdigställde (gjorde, arbetade; – hebr. asah) Herren (Jahveh) himlarna och jorden, havet – ja, allt som finns inom dem. Men han vilade under den sjunde dagen. Det är därför Herren (Jahveh) har välsignat sabbatsdagen och gjort den till en helgad dag (avsatt den som en speciell dag). 1 Mos 2:2-3 Det inledande ”för” är det hebreiska ki. Det anger motiveringen till sabbaten. Hebr. asah har en vid betydelse av att göra, avskilja, ordna, arrangera, tillförordna och färdigställa. I det här fallet inkluderas allt Gud gjorde de sex skapelsedagarna. Med himlarna avses, när det specifikt kombineras med jorden och havet, allt som finns ovanför jorden.  Sabbaten – rabbinska tolkningar  Det judiska folket firar sabbat från fredag kväll då solen går ner fram till lördag kväll en timma efter solnedgången. Det är ett dygn då man avstår från arbete och istället umgås med familjen och går till synagogan. Inom judendomen finns idag ”39 melachot”. Det är 39 aktiviteter som är förbjudna att göra på sabbaten. Bland dessa regler finns beskrivet att man t.ex. inte ska skriva, radera, bygga, släcka eller starta en eld, osv. Detta innebär att sabbatsljusen måste tändas innan sabbaten börjar på fredagskvällen. Detta ska göras 18 minuter före solnedgången. Även att trycka på en strömbrytare räknas av rabbiner som att göra upp en eld (eftersom analoga brytare historiskt sett alstrade en gnista). Ortodoxa judar låter därför spisen vara påslagen på 80 grader hela sabbaten, så man kan värma maten som är tillagad och förberedd innan. Av samma anledning är det förbjudet att köra bil, inte för att bilen rör sig, utan för att motorn alstrar gnistor. Hissar har ”sabbats-läge” och stannar på varje plan, för att man inte ska behöva bryta mot de ortodoxa judarnas tolkning av sabbatsbudet att trycka på en knapp.  Dagens judiska rabbiner lär att icke-judar inte behöver följa sabbaten på samma sätt som judarna gör. Ingenstans i Nya testamentet (eller i GT för den delen) står det att man ska hålla sabbatsbudet på detta sätt. När dessa frågor diskuteras på apostlamötet i Jerusalem säger Jakob att ”inte göra det svårt för hedningarna” och sabbaten finns inte med bland de fyra punkter som nämns i brevet till hedningarna, se Apg 15:19-20. Sabbatsbudet är ett ”tecken” mellan Herren och israeliterna, se 2 Mos 31:12-13. Jesus säger att människan inte är till för sabbaten, utan att sabbaten är till för människan, se Mark 2:27. Vi behöver en dag av vila, en dag att söka Gud enskilt och fira gudstjänst tillsammans med familjen. Se även Kol 2:17; Rom 14:5; 1 Kor 8:9. ");
INSERT INTO swe_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hedra (värdera högt, visa vördnad och respekt för) din far och din mor. Då ska du få leva länge i det land som Herren (Jahveh) din Gud (Elohim) ska ge dig. Detta bud har både att göra med vördnad för Gud och vördnad för människor. För små barn är föräldrarna deras ”gud”. Ett barn lär sig att vörda Gud genom att vörda sina föräldrar. Genom livet förändras betydelsen av att ”vörda sina föräldrar”. För ett litet barn är att vörda att lyda, som vuxen att ha en jämlik relation och när föräldrarna blir äldre att ta hand om dem. ");
INSERT INTO swe_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du ska inte mörda (hebr. lo ratsach). Det finns olika hebreiska ord för att döda. Hebreiska ratsach som används här syftar på en överlagd viljemässig handling att mörda en annan människa, men inkluderar även vållande till annans död. För att avgöra om det var olyckshändelse eller mord skulle den som orsakat en annan människas död ta sig till en av de sex fristäderna och där invänta rättegång som prövade fallet, se 4 Mos 35. Eftersom brottet är allvarligt krävdes inte bara ett vittne utan två. Om det var mord var påföljden dödsstraff. Allt detta beskrivs i 4 Mos 35 där det även ges olika exempel på hur lagen ska tolkas. Västvärldens rättssystem bygger på dessa principer och i Sverige finns tre grader av brott mot liv och hälsa: mord, dråp och vållande till annans död.  Anledningen till att mord är fel ges i 1 Mos 9:6: Människan är Guds avbild, och den som tar någon annans liv gör ett angrepp på Gud själv och hans avbild. Den inflytelserika King James Bible använde det engelska ordet ”kill” istället för ”murder”, vilket lett till att detta bud ibland tolkats som ett förbud att döda något levande. Eftersom plantor ska ätas och djur kan offras kan det inte betyda att inget liv får tas. Nästa kapitel föreskriver också att en skyldig mördare ska dömas till döden efter en rättvis dom (se t.ex. 2 Mos 21:12, 14, 15) och då används ett annat hebreiskt ord för att ”döda” (hebr. mot) gärningsmannen, vilket gör att detta bud inte kan användas för att tala mot dödsstraff. Även i krig används andra hebreiska ord för att döda. Eftersom summan av Guds ord är sanning, se Ps 119:160, måste vi se vad andra stycken i Bibeln säger om dödsstraff och krig. Två passager som ger vägledning finns i Rom 13:1-5 och Matt 5:44. Medicinska framsteg har också lett till nya moraliska dilemman vad gäller dödshjälp, abort, livsuppehållande behandling osv. ");
INSERT INTO swe_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du ska inte begå äktenskapsbrott. Lagen skiljer mellan äktenskapsbrott (som handlar om sexuell otrohet mellan gifta) och otukt (som handlar om annan sexuell synd). Båda är synder, men konsekvenserna av dem är olika. Ofta benämndes äktenskapsbrott som ”den stora synden”, för den splittrar familjer och upplöser samhällen. ");
INSERT INTO swe_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du ska inte stjäla. ");
INSERT INTO swe_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du ska inte bära falskt (hebr. sheqer) vittnesbörd mot din nästa (hebr. rea). Även om det är moraliskt fel att ljuga (Ords 12:22; 15:5; Ps 101:7), så är det falskt vittnesbörd i domstolen som är huvudbetydelsen här. ");
INSERT INTO swe_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Du ska inte ha begär till (avundas, åtrå) din nästas hus (familj och ägodelar). Du ska inte ha begär till hans fru, hans tjänare, hans tjänarinna, hans oxe, hans åsna, eller något annat som tillhör din granne (bekante, vän, landsman). Detta bud går djupare än tidigare bud eftersom det berör tanken och inte den fysiska handlingen. Men varför ett förbud mot att fantisera om att vilja ha grannens oxe? Anledningen är att det är begäret som kan leda till handlingar som förbjudits i de föregående fyra buden, se vers 13-16. Att åtrå andra människor och ägodelar kan leda till äktenskapsbrott, mord, stöld och falska vittnesmål. Ett exempel på det sistnämnda finns i 1 Kung 21 där Ahab tar över Navots vingård. Jesu halvbror skriver att där det finns avund och själviskhet, där finns det också oordning och alla slags onda handlingar, se Jak 3:16. Ordet begär förekommer två gånger i denna vers, vilket har lett till att budet ibland har delats upp i två olika bud. Det är dock tydligt att uppräkningen efter det andra ordet bara är ett förtydligande när det beskriver vad som finns i huset. Ett begär är en brinnande ohälsosam längtan efter något förbjudet. Samtidigt finns det också en positiv längtan och känsla av att vilja ha mer som Bibeln uppmanar till. Paulus längtar efter att känna Herren bättre, se Fil 3:7-14, söka de andliga gåvorna, se 1 Kor 12:31 osv.  Olika indelningar  Det finns olika indelningar. I den judiska traditionen inkluderas den inledande frasen med första budet, vilket inte den lutherska, katolska eller reformerta traditionen gör. En annan skillnad är placeringen av budet att vörda sina föräldrar, beroende på om det anses höra till den första eller den andra gruppen blir det 5:e eller 6:e budet (4:e budet i Luthers katekes).  Kärnbibelns rubriker följer den judiska uppdelningen. Det finns en tematisk och tydlig strukturell struktur som talar för detta, förutom att den var den äldsta och även gällde bland de första kristna. De första fem punkterna består alla av två sektioner där den första beskriver budordet och den andra ger förklaring eller beskrivning. De första fem har också samma text ”Herren din Gud” i varje punkt. De sista fem punkterna består däremot av kortare fraser med förbud. Här nämns inte Guds namn och det finns inte heller någon tillhörande förklaring.  Det finns också ett spegelvänt mönster i båda dessa halvor som börjar med hjärtat, tar sig uttryck i tal och sedan sist i handlingar. Det är ett kiastiskt mönster där första och sista punkten handlar om en inre osynlig kvalitet; både första punkten som handlar om tron på Gud och sista som handlar om girighet, har att göra med hjärtat. Det andra temat är ord; förbudet att ingå eder och vittna falskt hör ihop. Vad hjärtat är fullt av, det talar munnen och det leder vidare till praktiska handlingar som att inte respektera vilodagen, sina föräldrar, människoliv, äktenskap och andras egendom. ");
INSERT INTO swe_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Allt folket blev vittne till åskmullret och blixtarna och ljudet från shofaren och rykandet (röken som rykte) på berget. När folket såg det blev de förskräckta och stod långt bort. ");
INSERT INTO swe_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","De sa till Mose: ”Tala du till oss så ska vi lyssna, men låt inte Gud (Elohim) tala till oss för då ska vi dö.” ");
INSERT INTO swe_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose sa till folket: ”Frukta inte, var inte rädda, för Gud (Elohim) ska pröva er, för att vördnad för honom ska finnas i er så att ni inte syndar.” ");
INSERT INTO swe_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Folket stod på behörigt avstånd när Mose gick närmare det tjocka mörkret (ett tjockt mörkt moln) där Gud (Elohim) var. ");
INSERT INTO swe_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Herren (Jahveh) sa till Mose: Detta ska du säga till Israels barn (söner); ni har själva sett att jag har talat med er från himlen. ");
INSERT INTO swe_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ni ska inte göra – vid sidan av mig – gudar av silver eller gudar av guld, det ska ni inte göra åt er. I ett kiastiskt mönster repeteras det inledande budordet att inte ha andra gudar vid Guds sida, se 2 Mos 20:3-5. Det är inte bara detta budord som åsyftas, utan det blir som en titel för hela undervisningen ovan med de tio budorden. Bibeln visar att det finns saker som inte ska göras och saker som ska göras när det gäller offer. Nu i vers 24 följer de positiva buden med vad som ska offras. ");
INSERT INTO swe_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ni ska göra ett altare av jord till mig och offra brännoffer 3 Mos 1:3-16 på det och shalomoffer ett gemenskapsoffer som alla i familjen åt tillsammans, se 3 Mos 7:11-21, dina får och dina oxar. På varje plats där jag vill att mitt namn ska bli omnämnt ska jag komma till er och välsigna er. ");
INSERT INTO swe_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Och om du gör ett altare till mig av sten, ska du inte bygga det av huggna stenar, för om du rör det med ett verktyg har du förorenat det. ");
INSERT INTO swe_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Inte heller ska du gå upp på trappsteg till mitt altare, för att din nakenhet inte ska bli avslöjad därpå. ");
INSERT INTO swe_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Detta är de påbud (bindande juridiska beslut) som du ska lägga fram för dem israeliterna. Israeliterna hade själva varit slavar i Egypten. Det är denna utsatta grupp som är först att få rättsligt skydd. Det sätt en hebré kunde bli en slav var betalning för stöld (2 Mos 22:3) och skuldsättning (3 Mos 25:39). Lagar kring utländska slavar behandlas i 3 Mos 25:45. Vid många tillfällen behandlades arbetare och slavar likvärdigt, se 2 Mos 20:10; 23:12; 3 Mos 25:6, 39, 43, 53; 5 Mos 12:18; 16:11. ");
INSERT INTO swe_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Om du köper en hebreisk slav (tjänare – hebr. eved), ska han tjäna (hebr. avad) dig i 6 år och det 7:e året ska han bli fri utan att ersätta dig utan att behöva betala för sin frihet. ");
INSERT INTO swe_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Om han kom ensam ogift ska han gå (lämna) ensam efter sex år; om han var gift när han kom ska hans hustru gå med honom. Hebr. gaf används bara här och i vers 4. Ordet kan översättas ryggen fri eller bara med sin klädnad. Han kom med kläderna han hade på sig, dvs. utan fru och barn. ");
INSERT INTO swe_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Om hans herre ger honom en hustru och hon föder söner eller döttrar till honom, ska hustrun och hennes barn vara hennes herres, och han ska gå (lämna) ensam (hebr. gaf). Det skulle dock vara väldigt smärtsamt att lämna sin familj. ");
INSERT INTO swe_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Så om tjänaren tydligt säger: ”Jag älskar min herre, min hustru och mina barn, jag vill inte gå (lämna) fri”, ");
INSERT INTO swe_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","då ska hans herre föra fram honom till Gud (Elohim) och föra honom till dörren eller till dörrposten en formell ceremoni krävdes och hans herre ska genomborra hans öra med en syl, och han ska tjäna honom för alltid.  Slaveri  På den här tiden var slaveriet utbrett i världen. Det är anmärkningsvärt att det inte finns något uttryckligt förbud mot slaveri i Bibeln. Paulus uppmanar slavar att bli fria på laglig väg om den möjligheten ges, se 1 Kor 7:21-24. Evangeliet omkullkastar inte sociala institutioner genom revolution, däremot har slaveriet avskaffats i länder som bygger på judeo-kristna värderingar. Gud förändrar människors hjärtan, vilket i sin tur förändrar samhället. I omkringliggande kulturer var det inte ovanligt att barn såldes som slavar/tjänare. I hopp om en bättre framtid kunde en fattig dotter säljas till ett rikt hushåll. Bland hebréerna var sådana försäljningar jämförelsevis sällsynta, men de ägde ändå rum ibland, till följd av extrem fattigdom (Neh 5:5). Kvinnor som såldes på detta sätt kunde kräva sin frihet efter sex år om de så önskade (5 Mos 15:17), men om de köptes för att bli hustrur fick de ytterligare ett skydd. Reglerna här skyddar flickan från att säljas vidare till andra och bli sexuellt utnyttjad. ");
INSERT INTO swe_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Och om en man säljer sin dotter till att bli en tjänarinna (hebr. amah) ska hon inte lämna som de manliga tjänarna gör. ");
INSERT INTO swe_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Om hon inte behagar sin herre som har tagit henne till hustru eller konkubin åt sig själv, då ska han låta henne bli återlöst av hennes far eller en släkting. Det står inte i hans makt att sälja henne till en främling, eftersom han då har agerat svekfullt mot henne. ");
INSERT INTO swe_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Och om han tar henne till hustru åt sin son, ska han handla med henne som med en dotter. ");
INSERT INTO swe_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Om han tar sig en annan hustru ska hennes mat, hennes kläder och hennes äktenskapliga rättigheter inte förminskas. ");
INSERT INTO swe_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Och om dessa tre åtaganden inte erbjuds (görs för) henne, då ska hon gå ut utan ersättning och utan betalning. De tre åtagandena var att erbjuda återlösning (vers 8), giftermål med någon av familjens söner (vers 9) eller giftermål med en annan hebré (vers 10).  Dödsstraff  För vissa grova brott som bl.a. mord föreskrivs dödsstraff. Såväl utdömandet som verkställandet av dödsstraffet bör ha varit ytterst ovanligt. Då två vittnen var nödvändiga blev det svårt att skaffa fram bevis. För domstolen gällde principen att hellre fria än fälla. I Talmud diskuteras de rättsliga kraven för dödsstraff mycket ingående och man fastställde betydande hinder som gjorde en sådan dom extremt svår att verkställa. Enligt Mishnah måste dödsfall avgöras av en Sanhedrin bestående av 23 domare. ");
INSERT INTO swe_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Den som slår en man så att han dör ska dödas. ");
INSERT INTO swe_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Men om en man inte ligger på lur det var inte ett överlagt mord och Gud (Elohim) låter det komma till hans hand, då ska jag utse en plats åt dig dit han kan fly. ");
INSERT INTO swe_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Men om en man avsiktligt kommer till sin granne och slår honom med svek, då ska han tas bort från mitt altare så att han kan dö. Jfr 1 Kung 1:50-51 Vers 12-14 formar en kiasm som ramas in av mord som måste straffas hårt. För att avgöra om det var olyckshändelse eller mord skulle den som orsakat en annan människas död ta sig till en av de sex fristäderna och där invänta rättegång, se 4 Mos 35. ");
INSERT INTO swe_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Och den som slår sin far eller sin mor, ska med säkerhet dödas. ");
INSERT INTO swe_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Och den som stjäl kidnappar, samma ord ganav som i 2 Mos 20:15 en människa (hebr. ish) och säljer honom, eller om han blir funnen i hans hand, ska med säkerhet dödas. ");
INSERT INTO swe_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Och den som förbannar sin far eller sin mor, ska med säkerhet dödas. Vers 15 och 17 ramar in detta stycke och handlar om att vörda sina föräldrar, se 2 Mos 20:12. Att kidnappa någon är att stjäla från familjen. Att kidnappa någon i syfte att sälja till slaveri är också ett allvarligt brott som leder till dödsstraff. ");
INSERT INTO swe_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Och om flera män tävlar (strider, duellerar) och den ene slår den andre med en sten eller med sin näve och han inte dör utan blir sängliggande, ");
INSERT INTO swe_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","om han reser sig igen och går böjd över sin stav, då ska den som slog honom vara tyst. Han ska ersätta honom för hans förlorade tid och ska ombesörja att han blir fullt återställd. ");
INSERT INTO swe_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Och om en man slår sin tjänare eller tjänarinna med en käpp ger en kroppslig bestraffning, och han dör under hans hand, ska han med säkerhet bli straffad. En herre kan inte behandla sina slavar hur som helst, människovärdet står högt, skulle en slav dö hade slavägaren begått mord. ");
INSERT INTO swe_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Om han överlever en dag eller två dagar ska han inte bli straffad, för han är hans silver (han är köpt och tillhör honom). Straffet i vers 20 var då inte tänkt att döda utan bara korrigera. ");
INSERT INTO swe_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Om män bråkar med varandra och skadar en gravid kvinna så att hon får missfall och inga andra skador uppstår, då ska han med säkerhet bli skadeståndsskyldig, i enlighet med det som kvinnans make ålägger honom, och han ska betala som domarna fastställer. ");
INSERT INTO swe_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Men om någon skada uppstår, då ska liv ges för liv, ");
INSERT INTO swe_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","öga för öga, tand för tand Matt 5:38, hand för hand, fot för fot, ");
INSERT INTO swe_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brännskada för brännskada, sår för sår, blåmärke för blåmärke. Dessa lagar begränsar straffet så det är en rimlig nivå som motsvarar den skada som skett. Denna princip, som inom juridiken kallas vedergällningsrätt (talionprincipen), begränsar hämndens utsträckning. ");
INSERT INTO swe_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Och om en man slår sin tjänare i ögat eller slår sin tjänarinna i ögat, och ögat fördärvas, ska han låta honom gå fri för ögats skull. ");
INSERT INTO swe_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Och om han slår ut sin tjänares tand eller sin tjänarinnas tand, ska han låta honom gå fri för tandens skull. ");
INSERT INTO swe_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Och om en oxe (tjur – hebr. shor) stångar en man eller en kvinna så att de dör, då ska oxen med säkerhet stenas och dess kött ska inte ätas, och oxens ägare ska förbli tyst. Hebr. shor kan syfta på en tjur eller oxe (som är en kastrerad tjur). Eftersom en oxe normalt sett är lugnare än en tjur, så verkar texten här syfta på en oxe. Oxen som dödat en människa ska dödas och ägaren varnas. Han får inte klaga över det som drabbat honom. Han måste finna sig i att förlora sin tjur/oxe som var en dyrbar och viktig tillgång på den här tiden i ett samhälle där jordbruket var centralt och oxen gjorde mycket av det tunga arbetet. En antik lertavla från Nuzi (moderna Irak, daterad till 1500 f.Kr.) omnämner ett rättsfall där en oxe dödat en människa. ");
INSERT INTO swe_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Men om oxen har stångats tidigare, och dess ägare har blivit varnad men inte brytt sig om varningen, och den dödar en man eller kvinna, då ska oxen stenas och dess ägare ska också dödas. ");
INSERT INTO swe_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Om en lösensumma läggs på honom, då ska han för sin återlösning ge allt som läggs på honom. ");
INSERT INTO swe_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Oavsett om den har stångat en son eller har stångat en dotter, efter detta påbud (bindande juridiska beslut) ska det göras mot honom. ");
INSERT INTO swe_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Om oxen stångar en tjänare eller tjänarinna, ska han ge deras herre 30 shekel 345 gram silver och oxen ska stenas. ");
INSERT INTO swe_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Och om en man öppnar en brunn, eller om en man gräver en brunn, och inte täcker över den, och en oxe eller en åsna faller i den, ");
INSERT INTO swe_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","då ska brunnens ägare betala ersättning, han ska ge silver till deras ägare och det döda djuret ska vara hans. ");
INSERT INTO swe_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Och om en mans oxe skadar en annans så att den dör, då ska han sälja den levande oxen och de ska dela på betalningen för den och de ska dela på den döda oxen. ");
INSERT INTO swe_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Eller om det blir känt att en oxe har stångats tidigare och ägaren inte har brytt sig om det, ska han med säkerhet betala (fullständigt ersätta/fullborda – hebr. shalem shalem) oxe för oxe och den döda kroppen ska vara hans. Den hebreiska texten har en vers till här (37), och en vers mindre i kapitel 20 som då bara har 30 verser. ");
INSERT INTO swe_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Om en man stjäl en oxe eller ett får och dödar det eller säljer det, ska han ersätta (hebr. shalem): 5 oxar för 1 oxe femfalt och 4 får för 1 får fyrfalt. Jfr 2 Sam 12:4. Anledningen till det högre straffet för stöld av oxen kan vara att det är ett större djur, kräver mer fräckhet eftersom det lättare kan upptäckas. Dessutom orsakade förlusten av en oxe mer skada för ägaren än förlusten av ett får, se Ords 14:4. ");
INSERT INTO swe_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Om en tjuv blir påkommen med att bryta sig in (gräva sig igenom – hebr. machteret) husväggen till stallen när det är mörkt och blir slagen så att han dör, ska det inte vara någon blodskuld för honom djurens ägare är inte skyldig till dråp. ");
INSERT INTO swe_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Men om solen gått upp över honom tjuven höll på att gräva sig in då det var ljust ska det var blodskuld för honom dråparen. Husägaren ska åtalas för mord. Han tjuven ska ersätta fullt ut (hebr. shalem shalem). Om han inte har något tillräckligt, då ska han bli såld som slav för sin stöld (stöld i smyg – hebr. genevah). Kunde han inte betala var han tvungen att betala genom att arbeta, men inte mer än sex år, se 2 Mos 21:2-4. ");
INSERT INTO swe_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Om stöldgodset djuret som han stulit i smyg påträffas levande i hans hand, vare sig det är oxe eller åsna eller får, ska han ersätta dubbelt igen. ");
INSERT INTO swe_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Om en man orsakar att ett fält eller en vingård blir avätet, därför att han har låtit sin boskap gå lös, och den har ätit på en annan mans fält, då ska han ersätta honom från sitt eget fält och från sin egen vingård. ");
INSERT INTO swe_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Om eld bryter ut och får tag i törne så att sädesskylarna eller den stående säden eller fältet slukas, ska han som tände elden ersätta den ordentligt. ");
INSERT INTO swe_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Om en man överlämnar pengar eller andra tillhörigheter till sin granne för att han ska förvara det och det blir stulet från den mannens hus, om tjuven blir funnen ska han ersätta dubbelt tillbaka. ");
INSERT INTO swe_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Om tjuven inte blir funnen, då ska husets herre komma nära Gud (Elohim) för att se om han har lagt sin hand på sin grannes tillhörigheter. ");
INSERT INTO swe_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","För varje slags överträdelse – om det gäller en oxe, en åsna, ett får, kläder eller någonting som har gått förlorat – som någon hittar det och säger: ”Det här är det som är mitt”, ska båda parters sak komma inför Gud (Elohim). Den som Gud (Elohim) dömer skyldig visar har felat ska ersätta dubbelt till sin granne. På samma sätt som i vers 4 och vers 7 eftersom det stulna också återfås, inte fyrfalt som i vers 1. ");
INSERT INTO swe_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Om en man till sin granne överlämnar en åsna eller en oxe eller ett får eller något djur för att han ska skydda (ta hand om) det och det dör eller skadas eller förs bort och ingen ser det, ");
INSERT INTO swe_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","då ska Herrens (Jahvehs) ed vara mellan dem båda för att se att han inte har lagt sin hand på sin grannes tillhörigheter, och dess ägare ska acceptera det och inte begära någon ersättning. ");
INSERT INTO swe_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Men om det är stulet från honom ska han ersätta dess ägare. ");
INSERT INTO swe_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Om det har gått sönder ska han föra fram det som bevis, han ska inte ersätta det som är trasigt. ");
INSERT INTO swe_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Och om en man lånar något av sin granne och det skadas eller dör, och dess ägare inte är där just då, ska han som lånat det ersätta det fullt ut. ");
INSERT INTO swe_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Om ägaren var närvarande när djuret skadades eller dog, ska han den som lånat det inte ersätta det. Om djuret var hyrt, utgör hyressumman ersättning. ");
INSERT INTO swe_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Och om en man förleder en ungmö som inte är förlovad, och ligger med henne, ska han med säkerhet betala en hemgift för henne så att hon blir hans hustru. ");
INSERT INTO swe_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Om hennes far vägrar att ge henne till honom, ska han betala silver efter hemgiften för en ungmö. ");
INSERT INTO swe_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Du ska inte tillåta trollkvinnor (häxor, sådana som håller på med ockulta saker) att leva. ");
INSERT INTO swe_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Den som ligger (har samlag) med ett djur ska med säkerhet dödas. ");
INSERT INTO swe_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Den som offrar till avgudar det som är sparat (undanlagt) till Herren (Jahveh), ska i grunden förgöras (hebr. charam). ");
INSERT INTO swe_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","En främling (invandrare som bor i landet – hebr. ger) ska du inte förorätta (behandla fel, utnyttja) eller förtrycka (krossa), ni har ju själva varit främlingar i Egyptens land. ");
INSERT INTO swe_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ingen änka eller faderlös ska ni förödmjuka (plåga, våldföra er på – hebr. anah). Jes 1:17; Job 31:16, 17, 21 ");
INSERT INTO swe_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Om du behandlar dem illa på något sätt – för om de ropar till mig ska jag sannerligen höra deras rop – ");
INSERT INTO swe_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ska min vrede bli het och jag ska döda dig med svärd, och din hustru ska bli änka och dina barn faderlösa. ");
INSERT INTO swe_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Om du lånar ut pengar till någon av mitt folk, till den fattige (hebr. ani) som är hos dig, ska du inte vara för honom som en kreditgivare, inte heller ska du ta ränta av honom. ");
INSERT INTO swe_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Om du tar din grannes mantel i pant ska du återlämna den till honom vid solnedgången, ");
INSERT INTO swe_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","för det är hans enda täcke, det är hans mantel för hans kropp som han ska sova under. Och det ska ske när han ropar till mig att jag ska höra, för jag är nåd (oförtjänt kärlek – hebr. chanon). ");
INSERT INTO swe_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Du ska inte smäda Gud (Elohim) och inte förbanna ditt folks ledare. ");
INSERT INTO swe_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Du ska inte fördröja att offra fullheten av din skörd och det som kommer från din press. Det förstfödda av dina söner ska du ge till mig. ");
INSERT INTO swe_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","På samma sätt ska du göra med din oxe och med ditt får. Sju dagar ska den gå med sin mor, på den åttonde dagen ska du ge den till mig. ");
INSERT INTO swe_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ni ska vara heliga män till mig, därför ska ni inte äta något kött från ett rivet djur på fältet, det ska ni kasta till hundarna. ");
INSERT INTO swe_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du ska inte sprida (skapa eller sprida vidare) ett falskt rykte. Gör inte gemensam sak med den orättfärdige (den som är skyldig till ett brott) genom att bli ett falskt (laglöst, destruktivt) vittne. Ordet ”falskt” är det hebreiska ordet chamas som har stark betoning på våld och terror. Här blir betydelsen ”en rättslig terrorist” som bryter ner rättssystemet inifrån. ");
INSERT INTO swe_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Även om majoriteten av folket gör det onda, så ska inte du göra det. Detsamma gäller när du ska ge ditt vittnesmål i en rättstvist, låt inte folket (majoriteten) pressa dig att förvränga sanningen. ");
INSERT INTO swe_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","På samma sätt ska du inte heller favorisera minoriteten i rättssalen som ofta är den fattige bara för att han är fattig. ");
INSERT INTO swe_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Om du träffar på en bortsprungen oxe eller åsna som tillhör din ovän fiende som du ligger i rättslig tvist med, ska du göra allt du kan för att föra tillbaka djuret till honom. ");
INSERT INTO swe_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Om du ser att åsnan, som tillhör någon som hatar dig, har dignat under sin last ska du inte ignorera honom utan hjälpa honom befria djuret från sin last. Djuren ska inte behöva lida på grund av att ägaren står i konflikt med dig. ");
INSERT INTO swe_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du ska inte förvränga rätten för den fattige. ");
INSERT INTO swe_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Håll dig borta från falska anklagelser som kan bli döden för den oskyldige och den som har rätt, för jag frikänner inte den skyldige. ");
INSERT INTO swe_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Du ska inte ta emot mutor, för mutan förblindar dem som ska se klart (de visa) så att de inte ser sanningen och förvränger orden hos de som skulle vara rättfärdiga. ");
INSERT INTO swe_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Förtryck (krossa) inte en främling (invandrare). I sammanhanget syftar det antagligen på en rättslig process. Ni vet hur det är att vara främlingar, ni var ju själva främlingar i Egypten. ");
INSERT INTO swe_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","I sex år ska du så din jord och skörda vad den ger, ");
INSERT INTO swe_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","men det sjunde året ska du låta marken vila och ligga i träda. Då kan de fattiga (behövande – hebr. evion) i ditt folk få sin föda från den och det som blir över kan de vilda djuren äta. På samma sätt ska du också göra med din vingård och dina olivträd. ");
INSERT INTO swe_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Under sex dagar ska du utföra ditt arbete, men på den sjunde dagen ska du vila (hålla sabbat). När du gör det får din oxe och åsna vila, vilodagen ger också tid för slavkvinnans son och främlingen (gästarbetaren) att återhämta sig. Ordet ”återhämta” är ett rikt ord som ordagrant kan översättas ”att andas ut” eller ”att någon andas på dig.” Det delar samma hebreiska rot som ordet för själ och liv, och för tankarna tillbaka till skapelsen i 1 Mos 2:7 där Gud andades in liv i den första människan. Vilodagen är en dag då vi låter Gud få andas på oss igen. Livet återhämtas och återskapas in i människan. ");
INSERT INTO swe_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ge noga akt på allt det som jag har sagt till dig. Låt inte namnet på andra gudar nämnas, låt dem inte bli hörda över din mun (låt inte ljudet av avgudanamn passera över dina läppar). ");
INSERT INTO swe_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tre gånger om året ska du hålla festhögtid åt mig till min ära. ");
INSERT INTO swe_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Det osyrade brödets högtid (hebr. chag matsah) ska du hålla (bevara; vaka över – hebr. shamar). Sju dagar ska du äta osyrat bröd (hebr. matsah) som jag har befallt dig, på den bestämda tiden i månaden aviv ett annat namn på vårmånaden nisan – motsvarar mars/april, för denna månad (ordagrant; i den) drog (gick) du ut från Egypten. Ingen ska komma inför mig tomhänt utan offergåva. Detta är den första av de stora vallfärdshögtiderna och den inleds den 15:e nisan (som är det babyloniska namnet på den första hebreiska månaden, aviv – ”månaden då axen mognar”, se 3 Mos 23:6-8). Ytterligare två högtider som förknippas med det osyrade brödets högtid infaller under dessa dagar – pesach som firas kvällen före (dvs. den 14:e nisan, se 3 Mos 23:4-5) och förstlingsfruktens högtid (bikkurim) som infaller andra eller tredje dagen under det osyrade brödets högtid, se 3 Mos 23:9-14. ");
INSERT INTO swe_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Och skördehögtiden (hebr. chag qatsir) även kallad veckohögtiden (shavuot) och pingst – en skördefest på försommaren ska du också hålla, förstlingsfrukten (hebr. bikorim) av ditt arbete i plural - korn och vete som du har sått på fälten. Detta är enda gången namnet skördehögtid används om denna högtid. Det vanligaste namnet är shavuot (veckohögtiden), se 2 Mos 34:22; 3 Mos 23:17-22; 5 Mos 16:10-12; Apg 2:1. Vårt svenska namn pingst kommer från grekiskans pentekoste (femtionde), se 3 Mos 23:16. Och insamlingshögtiden (hebr. chag asif) även kallad lövhyddohögtiden (sukkot) – en skördefest på hösten ska du också hålla i slutet av året när ni har samlat in alla grödor från era fält. En glädjefylld skördefest på hösten i oktober, se 3 Mos 23:33-43; 5 Mos 16:13-17; Neh 8:14-17; Joh 7:2. Denna högtid har uttryckligen ett bud att vara glad, se 3 Mos 23:40. ");
INSERT INTO swe_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tre gånger om året ska era män träda fram inför Herren (Adon) er Guds (Jahvehs) ansikte. Vid dessa tre högtider, som också kallas vallfartshögtiderna, samlades man en hel vecka i Jerusalem. Alla familjer skulle vara representerade av minst en manlig familjemedlem. Även kvinnor och barn var välkomna, däremot hade de inte samma plikt att komma till Jerusalem - resan kunde ju vara lång och besvärlig, speciellt för den kvinna som var gravid eller hade små barn. Att vandra långt till fots var ansträngande för mindre barn. När en pojke fyllt tolv år förväntades han dock göra sin första högtidsresa. Det var också den ålder som Jesus hade när han besökte Jerusalem första gången, se Luk 2:41. Fyra lagar med förbjudna traditioner från omkringliggande folk. ");
INSERT INTO swe_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Offra inte blodet från mina offer med syrat eller jäst bröd. Drick inte blod, se 3 Mos 17:14, blanda inte heller med bröd. Inte heller får fettet från mina fester bli kvar ute, utomhus, hela natten till morgonen 3 Mos 3:16-17. ");
INSERT INTO swe_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","För in (ta med dig) den utvalda (främsta) förstlingsfrukten från ditt land i (till) Herren (Jahveh) din Guds (Elohims) hus. Mal 1:14 Koka inte en killing i dess mors mjölk. 2 Mos 34:26; 5 Mos 14:21 Att detta förbud nämns här är troligtvis för att getter får sina killingar under våren (i mars/april), vilket sammanfaller med den andra stora högtiden – skördefesten (då korn- och veteskörden bärgats, se 2 Mos 23:16). I kanaaneiska texter nämns om ockulta ritualer där man kokar en killing i sin mors mjölk (vilket skulle gynna gethjordens fertilitet). Det kunde vara frestande för israeliterna att under högtiden också följa dessa omgivande folks seder och magiska riter.  Förbudet är väldigt specifikt angående en killing och dess mors mjölk, men säger inget om att koka en killing i t.ex. komjölk. Trots detta har rabbinska tolkningar under årens lopp gradvis utökat detta bud, vilket lett till dagens kosherlagar att inte blanda kött och mjölkprodukter i samma kök eller måltid – anledningen är just tolkningen av denna vers! ");
INSERT INTO swe_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Se, jag sänder en ängel, en budbärare, framför dig, för att vaka över dig på dina vägar och föra dig till den plats som jag har gjort i ordning (åt er). ");
INSERT INTO swe_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ge akt på honom (bokstavligt: ”bevaka från hans ansikte”), lyssna noga på hans röst. Var inte upprorisk mot honom, för han ska inte ursäkta dina överträdelser, för mitt namn är i honom. Denna ängel eller budbärare är Jesus, fast ännu inte i mänsklig gestalt. ");
INSERT INTO swe_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Men om du verkligen lyssnar till hans röst, och gör allt som jag talar (säger), då ska jag bli dina fienders fiende och dina motståndares motståndare. ");
INSERT INTO swe_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","För min ängel, min budbärare, ska gå framför dig och föra dig till amoréerna, hettiterna, perisséerna, kanaanéerna, hivéerna och jevusiterna och jag ska hugga av dem. ");
INSERT INTO swe_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Du ska inte böja dig för deras gudar eller tjäna dem, eller göra vad de gör. Tvärtom ska du i grund omstörta dem och bryta deras pelare i bitar. ");
INSERT INTO swe_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Du ska tjäna Herren din Gud (Jahveh Elohim) och han ska välsigna din mat och ditt vatten. Dessutom ska jag ta bort sjukdom mitt ibland dig. Ordagrant: ”från ibland/inre dig”. ");
INSERT INTO swe_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ingen ska få missfall och ingen ska vara ofruktsam i ditt land Job 21:10, och jag ska fylla antalet av dina dagar (låta dig leva ett helt långt liv). Ps 90:12 ");
INSERT INTO swe_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Jag ska sända min skräck framför dig och slå alla människor med panik, som du ska komma till, och göra så att alla dina fiender vänder ryggen mot dig (så att de flyr för dig). ");
INSERT INTO swe_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Jag ska sända bålgetingar (skräck, modlöshet) framför dig som kommer att driva undan hivéerna, kanaanéerna och hettiterna för dig. Bålgetingar (hebr. tsira) kan också betyda plåga, men även syfta på skräck, förvirring, modlöshet och pest, se Jos 24:12. ");
INSERT INTO swe_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Jag ska inte driva ut dem på ett år, för att inte landet ska bli öde och fältens vilda djur förökar sig mot dig. ");
INSERT INTO swe_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Lite i taget (steg för steg, långsamt) ska jag driva ut dem framför dig, till dess du har förökat dig är tillräckligt många och kan ta över (besitta) landet. ");
INSERT INTO swe_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Jag ska sätta dina gränser från Vasshavet (Röda havet) i sydöst till filistéernas hav Medelhavets kust i väst och från öknen Negev eller Sinai i syd till floden Eufrat i nordost. För jag ska lämna landets invånare i din hand, och du ska driva ut dem ifrån dig. ");
INSERT INTO swe_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Gör inga förbund med dem eller deras gudar. ");
INSERT INTO swe_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","De får inte bo i ditt land och förorsaka att du syndar mot mig, för om du tillber deras gudar, ska de bli en snara för dig. ");
INSERT INTO swe_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Sedan sa han till Mose: ”Kom upp till Herren (Jahveh), du och Aron, Nadav och Avihu och sjuttio av Israels äldste och tillbe på avstånd, ");
INSERT INTO swe_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","och Mose ensam ska komma nära intill Herren (Jahveh), men de andra ska inte komma nära, inte heller ska folket gå upp med dem.” ");
INSERT INTO swe_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose kom från berget som han gått upp på, se 2 Mos 20:21 och återgav (berättade) för folket alla Herrens (Jahvehs) ord och alla påbud (bindande juridiska beslut). Hela folket svarade med en röst och sa: ”Alla ord som Herren har talat vill vi göra.” ");
INSERT INTO swe_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","och Mose skrev ned alla Herrens ord. Tidigt nästa morgon byggde Mose ett altare nedanför berget och reste tolv stenar – en för varje stam i Israel. ");
INSERT INTO swe_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Han sände i väg unga israelitiska män och de offrade brännoffer och slaktade unga tjurar till shalomoffer (gemenskapsoffer – hebr. zevach shelamim) åt Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose tog hälften av blodet och hällde det i karen, och den andra hälften stänkte han på altaret. ");
INSERT INTO swe_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Sedan tog han förbundsakten hebr. sefer ha-brit – som nyligen hade skrivits ned, se 2 Mos 20-23 och läste upp den för folket, och de sa: ”Allt vad Herren (Jahveh) har talat vill vi göra (agera efter) följa och lyda (höra, hörsamma).” Här i vers 7 läggs nu även verbet höra/lyda/hörsamma (hebr. shama) till, jfr med vers 3. I Israels trosbekännelse Shema Jisrael (”Hör, Israel”), finns samma koppling till att hörsamma och lystra till själva innehållet genom att gensvara, se 5 Mos 6:4-9; Mark 12:29. ");
INSERT INTO swe_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Då tog Mose blodet den kvarvarande hälften som tömts i karen och stänkte det på folket de i främsta leden, eller de äldste, eftersom de var omkring två miljoner och sa: ”Detta är blodet i det förbund som Herren har slutit med er i enlighet med alla dessa ord.” Folket och Gud blev nu förenade i ett blodsförbund, som är den starkaste form av kontrakt som finns. Det som nu gällde var att din strid är min strid, dina fiender är mina fiender, mina tillgångar är dina tillgångar, vi är ett och jag kommer att beskydda dig med livet som insats. ");
INSERT INTO swe_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mose och Aron, Nadav och Avihu och sjuttio av Israels äldste gick upp på bergssidan, ");
INSERT INTO swe_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","och de såg Israels Gud (Elohim). Under hans fötter var som ett golv av safir blå ädelsten, och det var till substansen precis likt själva himlarna i klarhet (renhet, glans). ");
INSERT INTO swe_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Men han lyfte inte sin hand mot de sjuttio äldste i Israel för att hindra dem från att se honom, eller slå ner dem eftersom ingen kan leva och se Guds ansikte, se 2 Mos 33:20. De såg (som i en syn) Gud, och de åt och drack i hans närvaro. De såg antagligen en profetisk syn eller en gudomlig manifestation av Guds närvaro, men inte fullheten av hans härlighet eftersom Mose senare frågar efter att få se mer av Gud, se 2 Mos 33:18. ");
INSERT INTO swe_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Herren (Jahveh) sa till Mose: ”Kom upp till mig på berget och var kvar där, så ska jag ge dig stentavlorna med undervisningen (hebr. Torah) och budorden (hebr. mitsvot), som jag har skrivit för att undervisa folket.” De tio budorden (ordagrant ”orden” – hebr. davar) hade redan talats men skulle nu ges i skriftlig form. ");
INSERT INTO swe_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mose började gå tillsammans med sin tjänare Josua, och Mose gick upp på Guds berg. ");
INSERT INTO swe_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Han sa till de äldste: ”Vänta på oss på den här platsen tills vi kommer tillbaka. Aron och Hur (hebr. Chor) är kvar här med er. Den som behöver få en fråga avgjord en rättslig konflikt, ordagrant ”har många ord” eller ”är en mästare av ord” kan vända sig till dem.” ");
INSERT INTO swe_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose gick högre upp på berget tillsammans med Josua, och molnet täckte berget. ");
INSERT INTO swe_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Herrens härlighet vilade på berget Sinai och molnet täckte det under sex dagar. Mose följer löftet att ”vara kvar där” som han fick i vers 12. På den sjunde dagen kallade Gud på Mose inifrån molnet. ");
INSERT INTO swe_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Herrens härlighet visade sig som en förtärande eld inför israeliterna, på bergets topp. ");
INSERT INTO swe_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose gick in i mitten på molnet och steg upp på berget. Där var han fyrtio dagar och fyrtio nätter utöver de första sex dagarna som han och Josua hade väntat längre ner på berget. ");
INSERT INTO swe_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Tala till Israels söner (alla israeliter) att de ska ta upp ett offer till mig (Herren), från alla människor som har hjärtan som gjorts villiga, 2 Kor 9:7-8 ska du ta mitt offer. ");
INSERT INTO swe_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Detta är det offer du ska ta från dem: Metaller: Guld, silver och brons. ");
INSERT INTO swe_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Tyger: Blått, purpur hebr. argaman och karmosinrött garn och fint linne och gethår. ");
INSERT INTO swe_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Skinn: Vädursskinn som är färgat rött, skinn. Trä: Akaciaträ. ");
INSERT INTO swe_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Oljor: Olja till ljusbäraren (ljusstaken), kryddor till smörjelseoljan för smörjelse Ps 133 och till den väldoftande rökelsen. ");
INSERT INTO swe_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ädelstenar: Onyxstenar och stenar för infattning, till efoden 2 Mos 28:6-14 och till bröstskölden till översteprästen, se 2 Mos 28:15-30. ");
INSERT INTO swe_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Låt dem göra en helig plats (en helgedom) åt mig så att jag kan bo mitt ibland dem. Tabernaklet, som denna vers syftar på, är inte en bostad åt Gud utan en plats som möjliggör gemenskap för Gud och människan. ");
INSERT INTO swe_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","I enlighet med allt som jag har visat dig, ritningen till tabernaklet (hebr. miskan) och ritningarna till dess inredning (möblemang), precis så ska du tillverka det. Tabernaklets alla förebilder skulle inte kunna fungera som den undervisning det är, om några detaljer ”hade slarvats bort”. Dessutom visar denna vers att det är viktigt att vi inte blandar in våra egna idéer när vi utför Guds arbete på jorden.  Tabernaklets typologier Tabernaklet i öknen har många typologier till vår relation med Gud, se Kol 2:17. Psalm 100 beskriver hur vi går in i Herrens portar med tacksamhet, i hans gårdar med lov för att slutligen tillbe i det inre, se Ps 100:4. Att gå in i tabernaklet är en beskrivning på hur vi måste agera när vi vill nalkas Gud som bor i tabernaklets innersta på nådastolen som täcker arken i det allra heligaste. Vi behöver passera offeraltaret och reningskaret med tacksamhet, se på menoran, skådebrödsbordet och rökelsealtaret med lovsång för att slutligen få komma nära arken och nådastolen med tillbedjan. Gud är noga med att allting måste göras exakt enligt instruktionerna. När man ser vad alla dessa mönsterbilder/typologier betyder genom hela Bibelns frälsningshistoria förstår man varför just denna instruktion är så viktig. Här finns många förebilder på vår väg till frälsningen:  1. Tabernakelområdet – Det första steget är att komma in på området, vi måste närma oss Gud och komma inom hörhåll för ordet och frälsningen.  2. Brännofferaltaret visar att det krävs försoning för våra synder och reningskaret visar behovet av att tvätta bort det gamla livet.  3. Därefter går vi in i det heliga där skådebrödsbordet visar oss på vikten av att äta Guds ord varje dag så att vi blir bevarade i tron.  4. Menoran visar oss att Jesus är vår ljuskälla genom den helige Ande som hjälper oss.  5. Rökelsealtaret visar hur bönen är vårt personliga samtal med Gud. Detta rum utrustar oss för vår vandring med Gud här på jorden.  7. Arken och nådastolen – Slutligen kommer vi in i det allra heligaste som är förebilden på himlen och det nya Jerusalem där Gud själv bor och vi ska få bo med honom i evighet.  En annan generell typologi finns i parallellen mellan tabernaklet och pilgrimshögtiderna.  Påsken undervisar oss om återlösning och rening som återfinns på tabernaklets gård. I altaret – återlöst genom blodet och reningskaret – renad från orenhet.  Pingsten undervisar oss om vår försörjning som återfinns i det heliga i tabernaklet. Skådebrödsbordet – fysisk försörjning, menoran – den helige Ande, rökelse – tillträde till Gud genom bön.  Lövhyddohögtiden undervisar oss om Guds härlighet och att finnas i hans närvaro. I tabernaklet är detta det allra heligaste med arken och nådastolen där Gud manifesterar sin härlighet. Det första som Gud ger ritningen till är inte själva tältet utan dess viktigaste möbler. Arken och nådastolen är möblerna som Gud valt för sin personliga närvaro och genom att ge den första instruktionen om arken och nådastolen visar Gud att det är han som kommer till oss. Vi kan inte nalkas Gud om inte han först gör det möjligt för oss att nalkas honom genom att komma oss till mötes. Dessutom är detta en bild på att Gud är både först och sist och alltid måste få vara i centrum. Längdmåttet som används här är alnen, som motsvarade 45 cm. Måttet härstammar från längden på en mans underarm (avståndet mellan armbågen och långfingret). ");
INSERT INTO swe_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","De ska göra en ark av akaciaträ, dess längd ska vara 2,5 alnar 1,1 meter, dess bredd 1,5 aln 0,7 meter och dess höjd 1,5 aln 0,7 meter. Arken är en öppen låda, man ska kunna se dess innehåll. ");
INSERT INTO swe_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Du ska klä in den i rent guld, invändigt och utvändigt ska du klä in den och ovanpå den ska du göra en krona av guld runtom. Arken är en bild på Jesus, sann Gud (guldet), och sann människa (akaciaträ). Den är också en bild på Jesus som kung, kronan av guld runtom. ");
INSERT INTO swe_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Du ska gjuta fyra ringar av guld för den och sätta dem ovanpå de fyra fötterna, två ringar på den ena sidan och två ringar på den andra sidan. ");
INSERT INTO swe_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Du ska göra stavar av akaciaträ och klä in dem i guld. ");
INSERT INTO swe_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Du ska sätta stavarna i ringarna på sidorna av arken, med dem ska du bära arken. Ringarna är en bild på spikarna på korset som visar att Jesus varit korsfäst, se Upp 5:6. Vi måste bära vår korsmärkta Jesus med oss och även ut till alla omkring oss. ");
INSERT INTO swe_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Stavarna ska vara kvar (förbli) i ringarna på arken, du ska inte ta bort dem därifrån. På samma sätt som stavarna behövs för att bära arken, blir vi burna av Jesus när vi förblir i honom som grenarna på vinrankan, se Joh 15:5. ");
INSERT INTO swe_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","I arken ska du lägga vittnesbördet som jag ska ge dig. De två stentavlorna med de tio budorden. Att budorden ligger i Jesus visar att han är vår profet. Jesus kom inte för att upphäva utan för att fullborda dessa budord. Jesus var ställd under lagen, se Gal 4:4 och uppfyllde den. Lagen är helig, rättfärdig och god och undervisar oss om Guds vilja. Min mat är att göra hans vilja som har sänt mig, säger Jesus i Joh 4:34. ");
INSERT INTO swe_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Du ska göra ett lock till arken (nådastol, en försoningsplats – hebr. kapporet) av rent guld. Dess längd ska vara 2,5 alnar 1,1 meter, dess bredd ska vara 1,5 aln 0,7 meter. Locket har samma dimensioner som arken, se vers 10. Detta lock brukar även kallas för nådastolen. ");
INSERT INTO swe_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Du ska göra två keruber av guld, av drivet arbete ska du göra dem, på de båda kortsidorna av locket till arken. ");
INSERT INTO swe_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Gör en kerub på den ena sidan och en kerub på den andra sidan, i ett stycke med locket till arken ska du göra keruberna på de två kortsidorna av locket. ");
INSERT INTO swe_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Keruberna ska sprida ut sina vingar på höjden och täcka locket till arken med dem, de ska vända sina ansikten mot varandra, mot locket på arken ska de vända sina ansikten. ");
INSERT INTO swe_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Du ska sätta locket ovanpå arken, och i arken ska du lägga vittnesbördet som jag ska ge dig. ");
INSERT INTO swe_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Jag ska möta dig där, ovanför locket till arken mellan de två bevingade keruberna som är ovanpå vittnesbördets ark. Där ska jag tala med dig om allt som jag vill ge dig instruktioner om till Israels söner. Nådastolen, eller arkens lock, är ett självständigt föremål som dock hör intimt ihop med arken. Arken var en öppen låda utan lock men nådastolen som görs med samma mått som arken läggs ovanpå denna och blir därmed som ett lock till arken. Lägg märke till att nådastolen inte på något sätt fästs ihop med arken utan ligger löst ovanpå. En annan detalj i sammanhanget är det faktum att om man räknar de olika föremålen i tabernaklet blir det 6 stycken, om man betraktar arken och nådastolen som ett föremål, men 7 stycken om de behandlas som de separata föremål de faktiskt är. ");
INSERT INTO swe_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Du ska göra ett bord av akaciaträ, dess längd ska vara 2 alnar 0,9 meter och dess bredd 1 aln 0,45 meter och dess höjd ska vara 1,5 aln 0,7 meter. ");
INSERT INTO swe_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Du ska klä in det i rent guld och till det ska du göra en krona av guld runtom. Precis som med arken är även detta en bild på Jesus, sann Gud, guldet, och sann människa, akaciaträ. Den är också en bild på Jesus som kung, kronan av guld runtom. Här har vi också en bild på det som Jesus säger om sig själv: Jag är livets bröd, se Joh 6:35. ");
INSERT INTO swe_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Du ska göra en handsbred 8-9 cm bred list till det runtom och du ska göra en krona av guld till listen runtom. ");
INSERT INTO swe_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Du ska göra fyra ringar av guld till det och sätta ringarna i de fyra hörnen som är på dess fyra fötter. ");
INSERT INTO swe_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ringarna ska vara nära listen, de är till stavarna som bordet ska bäras med. Att ringarna ska vara nära listen visar oss att det Jesus gjorde på korset, ringarna symboliserar spikarna, hör intimt ihop med hans konungslighet, listen som med sin dekor är kronan. När vi bär ut brödet Jesus till människorna måste vi förkunna om honom både som det slaktade lammet och som den kung han är. ");
INSERT INTO swe_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Du ska göra stavar av akaciaträ och klä dem i guld så att bordet kan bäras med dem. Det är vi som ska bära skådebrödsbordet, se 1 Pet 2:9. Jesus, sann Gud och sann människa, både ger och uppehåller livet. Jesus uppmanar oss att be om vårt dagliga bröd, se Matt 6:11. Det är nödvändigt att ge anden i oss mat varje dag på samma sätt som vi äter för vår kropps välbefinnande. ");
INSERT INTO swe_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Du ska också göra fat, kokkärl, krukor och skålar till att utgjuta drickoffer, av rent guld ska du göra dem. Drickoffret består av vin och varje sabbat samlas prästerna för att äta brödet och dricka av vinet, alltså en bild på nattvarden. ");
INSERT INTO swe_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","På bordet ska det alltid ligga bröd inför mitt ansikte. Brödet är en bild på Guds Ord och det faktum att det alltid ska finnas bröd på bordet undervisar oss om vikten att alltid ”äta” Ordet, det vill säga ha en god daglig vana att alltid läsa Guds ord och begrunda det. Att det är inför Guds ansikte/ögon betyder att vi aldrig ska titta bort från Ordet utan istället låta Bibeln vara våra ”glasögon” som vi använder som filter framför allt annat som vi tittar på så att vi kan avgöra vad som är rent, sant, gott och Guds vilja i varje situation. ");
INSERT INTO swe_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Du ska göra en menora sjuarmad ljusstake av rent guld, i hamrat arbete ska menoran göras, också dess fot och dess stam. Dess bägare, dess knoppar och dess blommor ska göras i ett stycke med den. För att kunna göra ett drivet arbete i hamrat guld måste metallen upphettas till höga temperaturer. Det betyder att guldet inte bara bearbetas utan också renas och luttras under tillverkningsprocessen. Det är en bild på hur Gud vill forma oss så att bara det värdefulla i oss blir kvar. Menoran är också en bild på Jesus som säger att han är världens ljus, se Joh 8:12. Ytterligare en bild som menoran visar oss är den helige Ande. Lamporna kräver olja för att lysa. På samma sätt behöver vi den helige Ande för att kunna vara ljus för våra medmänniskor. Menoran är gjord som ett träd med grenar och det pekar på vad Jesus säger i Joh 15 att han är stammen och vi är grenarna. På samma sätt som menoran ska tillverkas i ett stycke måste vi vara i Jesus – ett med honom. Detta talar även Paulus om när han beskriver församlingen som den Smordes kropp, 1 Kor 12:27 ");
INSERT INTO swe_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Det ska vara sex grenar som går ut från dess sidor, tre grenar av menoran ska gå ut på ena sidan och tre grenar av menoran ska gå ut på den andra sidan. ");
INSERT INTO swe_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tre bägare gjorda som mandelblommor i en gren, en kula och en blomma, och tre bägare gjorda som mandelblommor i de andra grenarna, en kula och en blomma, och likadant i de sex grenarna som kommer ut från menoran. Mandelblomma och vaksamhet har samma rot på hebreiska shin–kof–dalet. Detta anspelar Jeremia på i Jer 1:11-12. För oss är bilden därför även att vi behöver ljuset för att kunna vara vaksamma, se Ps 119:105. ");
INSERT INTO swe_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Och i menoran fyra skålar som mandelblommor, dess kulor och dess blommor. Kulorna kan också vara blomknoppar, i så fall är det en bild på hur vi med tiden mognar i vår tro. Knoppen är vår första tid som frälsta, blomman när vi vuxit upp och mandeln när vi blir vuxna nog att bära färdig frukt. ");
INSERT INTO swe_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Och en kula under två grenar i ett stycke med den, och en kula under två grenar i ett stycke med den, och en kula under två grenar i ett stycke med den, för de sex grenarna som går ut från menoran. ");
INSERT INTO swe_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Dess kulor och dess grenar ska vara i ett stycke med den, i ett stycke av hamrat arbete av rent guld. ");
INSERT INTO swe_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Och du ska också göra sju lampor för den och de ska lysa upp över det som är framför den. Versen tolkas troligtvis som att menoran ska vara ljuskällan i rummet, det heliga i tabernaklet. ");
INSERT INTO swe_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Dess tänger och dess vektrimmare ska vara av rent guld. Verktygen som används för att sköta menoran är bilder på hur Gud på olika sätt måste få rensa och sköta om en troende. Det gamla och dåliga måste tas bort så att lågan kan lysa klart (se även Joh 15:2). Jesus säger att vi ska vara ljus för vår omvärld, se Matt 5:16. ");
INSERT INTO swe_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Av en talent (hebr. kikar) 34 kilo rent guld ska den göras med alla sina verktyg. En talent motsvarade 3 000 shekel (2 Mos 38:25). Arkeologiska fynd har visat att shekeln var 11,5 gram, vilket gör att vi vet att en talent vägde omkring 34 kg. Ordet talent betyder något runt eller cirkulärt. En talent guld motsvarar:  • Ett klot med diametern 15 cm.  • 2,8 guldtackor (en guldtacka väger 12,5 kg och är 272 mm lång, 95 mm bred och 52 mm hög). ");
INSERT INTO swe_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Se till att du gör den exakt efter ritningen som jag visade dig på berget. Sinai berg, där Mose vistades 40 dygn då han fick stentavlorna med budorden och alla andra instruktioner från Gud. Här liksom i vers 9 är det viktigt att inte göra något på sitt eget sätt utan precis som Gud vill ha det gjort. ");
INSERT INTO swe_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Du ska göra tabernaklet med 10 våder av fint tvinnat linne, och blått och purpur och scharlakansrött med keruber. Du ska låta en skicklig hantverkare göra dem. ");
INSERT INTO swe_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Längden på varje våd ska vara 28 alnar 12,5 meter och bredden på varje våd ska vara 4 alnar 1,8 meter. Alla våder ska ha ett och samma mått (vara likadana, identiska). ");
INSERT INTO swe_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Fem våder ska sammanfogas med varandra och ytterligare 5 våder ska sammanfogas med varandra. ");
INSERT INTO swe_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Du ska göra öglor av blått garn längs kanten på den våd som är ytterst i det första hopfogade stycket och på samma sätt ska du göra längs kanten på den våd som är ytterst i det andra hopfogade stycket. ");
INSERT INTO swe_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","50 öglor ska du göra på den ena våden och 50 öglor ska du göra på den andra våden som är i det andra hopfogade stycket, öglorna ska placeras mitt emot varandra. ");
INSERT INTO swe_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Och du ska göra 50 spännen av guld och koppla ihop våderna med varandra med spännena så att tabernaklet blir en helhet. ");
INSERT INTO swe_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Och du ska göra våder av gethår, till ett tält över tabernaklet, 11 våder ska du göra av dem. ");
INSERT INTO swe_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Längden på varje våd ska vara 30 alnar 13,2 m och bredden på varje våd ska vara 4 alnar 1,8 m. De 11 våderna ska ha ett och samma mått (vara likadana, identiska). ");
INSERT INTO swe_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Och du ska sammanfoga 5 våder med varandra och 6 våder ska du sammanfoga med varandra och den sjätte våden ska läggas dubbelvikt på framsidan av tältet. ");
INSERT INTO swe_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Och du ska göra 50 öglor på kanten av den ena våden som är ytterst i det första hopfogade stycket och 50 öglor på kanten av våden som är ytterst i det andra hopfogade stycket. ");
INSERT INTO swe_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Och du ska göra 50 spännen av brons och sätta spännena i öglorna och koppla ihop våderna med varandra så att tältet blir ett helt. ");
INSERT INTO swe_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Och för den överhängande delen av tältets våder ska den halva våden som återstår hänga över den bakre delen av tabernaklet. ");
INSERT INTO swe_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Och alnen på den ena sidan och alnen på den andra sidan av det som återstår av extra längd på tältets våder ska hänga över sidorna på tabernaklet, på dess ena sida och dess andra sida, för att täcka det. ");
INSERT INTO swe_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Och du ska göra ett täcke till tältet av vädursskinn som är färgat rött, och ett täcke av skinn ovanpå. ");
INSERT INTO swe_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Och du ska göra ramverket (väggarna) till tabernaklet av akaciaträ, upprättstående plankor. ");
INSERT INTO swe_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","10 alnar 4,5 m ska vara höjden på varje planka och en och en 0,5 aln 23 cm bredden på varje planka. Talet 10 står för fullkomlighet. Plankornas längd pekar på att vi är fullkomliga i Jesus. ");
INSERT INTO swe_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Det ska vara två tappar på varje planka så att de fogas samman med varandra, detta ska du göra på alla tabernaklets plankor. ");
INSERT INTO swe_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Och du ska göra plankorna till tabernaklet, 20 plankor för den södra sidan söderut, ");
INSERT INTO swe_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","och du ska göra 40 fotstycken av silver under de 20 plankorna; två fotstycken under en planka till dess två tappar, och två fotstycken under nästa planka för dess tappar. Fotstyckena av silver symboliserar grunden, se Ef 2:20-22. Att det är två fotstycken under varje planka pekar på att vi behöver både GT (profeterna) och NT, (apostlarna). Hela Bibeln är grunden. Totalt är det 100 fotstycken av silver, se 2 Mos 38:27. I Ps 12:7 liknas Herrens tal vid silver. Jesus är Ordet, se Joh 1:1. Talet 100 är ett fullkomlighetstal och i Kol 2:9 står det att Jesus är fullkomlig i allt. ");
INSERT INTO swe_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Och för den andra sidan av tabernaklet, den norra sidan, 20 plankor ");
INSERT INTO swe_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","och deras 40 fotstycken av silver, två fotstycken under en planka och två fotstycken under nästa planka. ");
INSERT INTO swe_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Och till baksidan av tabernaklet, västerut ska du göra 6 plankor. ");
INSERT INTO swe_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Och 2 plankor ska du göra till hörnen på tabernaklet på baksidan. Beskrivningen av de två plankorna till hörnen är extremt kortfattad och svårtolkad på hebreiska. Det finns många förslag på hur denna konstruktion ska se ut. Det som man kan säga med säkerhet är i alla fall att det är två plankor utöver de sex som hör till den västra sidan. ");
INSERT INTO swe_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","De ska vara dubbla i botten och även dubbla upptill, till den första ringen. Så ska det vara med dem båda. De ska sättas i de båda hörnen. ");
INSERT INTO swe_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Så ska det vara 8 plankor och deras fotstycken av silver, 16 fotstycken, två fotstycken under en planka och två fotstycken under nästa planka. ");
INSERT INTO swe_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Och du ska göra tvärstänger av akaciaträ, 5 stycken för plankorna på den ena sidan av tabernaklet, ");
INSERT INTO swe_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","och 5 tvärstänger för plankorna på den andra sidan av tabernaklet, och 5 stänger för plankorna på sidan av tabernaklet, på baksidan västerut, ");
INSERT INTO swe_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","och den mellersta tvärstången i mitten av (inuti – hebr. tavech) plankorna som ska gå igenom från den ena ändan till den andra. ");
INSERT INTO swe_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Och du ska överdra plankorna med guld och göra deras ringar av guld som hållare för tvärstängerna och du ska överdra stängerna med guld. Plankorna kan symbolisera de troende och hur de hålls samman i församlingen. Fyra stänger binder ihop plankorna utvändigt fem och fem, vilket symboliserar hur vi hör ihop i den lokala församlingen. Den femte stången binder ihop samtliga plankor inuti, vilket symboliserar hur Jesu kärlek håller samman hela hans kropp på jorden. Att de är gjorda av akaciaträ symboliserar den mänskliga (syndiga) naturen. Samtidigt är de överdragna med guld vilket symboliserar rättfärdigheten i Jesus. Tapparna som fäster i fotstycket är tron. ");
INSERT INTO swe_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Och du ska resa upp tabernaklet i enlighet med dess ritningar som jag har visat dig på berget. Man kan se på plankorna som individer i församlingen. Då är vi vända med ansiktet inåt, alltså står var och en av oss med blicken fäst på de föremål som finns inne i tabernaklet som symboliserar Jesus och Gud själv. Då står vi samtidigt skuldra vid skuldra med våra syskon i tron och vänder ryggen mot världen. De är den position som varje troende behöver ha för att ha rätt fokus i sitt liv. ");
INSERT INTO swe_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Förhänget till det allra heligaste: Och du ska göra ett förhänge av blått och purpur och karmosinrött tyg eller garn i dessa färger och fint tvinnat vitt linne, med keruber. Ett arbete som ska göras av en skicklig hantverkare. Förhängets färger representerar de smorda ämbetena profet: blått, kung: purpur och präst: karmosinrött (offertjänsten) och vitt (förbönstjänsten). ");
INSERT INTO swe_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Och du ska hänga det på 4 stolpar (pelare – hebr. amod) av akaciaträ överdragna med guld, deras krokar av guld, på 4 fotstycken av silver. ");
INSERT INTO swe_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Och du ska hänga upp förhänget under spännena som fogar ihop takvåderna, se vers 6 och där innanför förhänget ska du ställa in vittnesbördets ark, och förhänget ska skilja mellan det heliga och det allra heligaste ordagrant: heligheternas heliga – hebr. qodesh ha-qodesh. ");
INSERT INTO swe_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Och du ska placera nådastolen ovanpå vittnesbördets ark i det allra heligaste. ");
INSERT INTO swe_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Och du ska placera bordet utanför förhänget och menoran mittemot bordet på ena sidan i tabernaklet söderut, och du ska ställa bordet på den norra sidan. ");
INSERT INTO swe_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Förhänget till ingången till tabernaklet: Och du ska göra ett förhänge till tältets öppning av blått och purpur och karmosinrött tyg eller garner i dessa färger och fint tvinnat vitt linne, ett brokigt arbete av en vävare. Detta förhänge hade inga motiv av keruber, se vers 31. ");
INSERT INTO swe_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Och du ska göra 5 stolpar av akaciaträ till förhänget och överdra dem med guld, deras krokar (hakar) ska vara av guld, och du ska göra 5 fotstycken av brons för dem. Fem är talet för nåd i Bibeln. Att den yttre dörren till tabernaklet ska fästas på 5 stolpar (pelare – hebr. amod) säger oss att det är Guds nåd som gör det möjligt för oss att få träda in och ha gemenskap med Jesus och Gud själv. Precis som med det inre förhänget symboliserar färgerna de tre smorda ämbetena. Se vers 31. ");
INSERT INTO swe_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Och du ska göra altaret av akaciaträ, 5 alnar långt och 5 alnar brett 2,25 x 2,25 meter – altaret ska vara kvadratiskt – och dess höjd ska vara 3 alnar 1,35 meter. ");
INSERT INTO swe_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Och du ska göra hornen till det på dess fyra hörn, hornen ska göras i ett stycke med altaret och du ska klä in det i brons (kopparlegering). Talen som används har en symbolisk innebörd. Talet 5 är Guds nåd och altaret som bild på Jesu försoningsoffer på korset är uppfyllelsen av all slags nåd som finns. Talet 3 pekar på Gud i hans fulla treenighet – Fader, Son och Ande. Talet 4 står ofta för världen och allt skapat (det finns fyra väderstreck). Akaciaträ pekar på Jesu mänskliga natur och brons på Jesu gudomliga natur, i ringhetsgestalt, till skillnad från guld, som är Jesu gudomliga natur i härlighetsgestalt. Notera att ordet för brons (hebr. nechoshet) är snarlikt ordet för orm, se 4 Mos 21:9. ");
INSERT INTO swe_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Och du ska göra dess hinkar att föra bort askan med, dess skovlar, dess fat, och dess köttkrokar och dess eldstäder, alla redskap som hör till ska du göra i brons. ");
INSERT INTO swe_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Gör också ett bronsgaller till det och på gallret ska du göra fyra bronsringar i de fyra hörnen. ");
INSERT INTO swe_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Du ska placera det under avsatsen runt altaret, under så att det når halvvägs upp på altaret. ");
INSERT INTO swe_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Och du ska göra stänger till altaret, stänger av akaciaträ och klä in dem i brons. ");
INSERT INTO swe_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Stängerna ska sättas i ringarna och stavarna ska vara på två sidor om altaret när ni bär det. Det var viktigt att arken och bordet kunde bäras utan mänsklig direktkontakt. ");
INSERT INTO swe_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","De ska tillverka dem av plankor så de är ihåliga. Precis som jag har visat dig på berget (Sinai) så ska det tillverkas. Här är Gud åter noggrann med att vi följer hans instruktioner exakt. ");
INSERT INTO swe_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Du ska också göra en förgård till tabernaklet. På den södra sidan ska det vara förhängen till gården av fint tvinnat linne, 100 alnar 45 meter lång på en sida. ");
INSERT INTO swe_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Och stolparna till det ska vara 20 stycken och deras socklar 20 stycken av brons, krokarna (hakarna) på stolparna och deras band (kransar) ska vara av silver. ");
INSERT INTO swe_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","På samma sätt på den norra sidan. Längden på förhängena ska vara 100 alnar 45 meter och stolparna ska vara 20 stycken, och deras socklar 20 stycken av brons, och krokarna på stolparna och deras band ska vara av silver. ");
INSERT INTO swe_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Och till bredden på gården på den västra sidan ska förhänget vara 50 alnar 22,5 meter, dess stolpar 10 stycken och dess socklar 10. ");
INSERT INTO swe_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Och bredden av förhänget på den östra sidan ska vara 50 alnar 22,5 meter. ");
INSERT INTO swe_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Förhänget på den ena sidan (om porten) ska vara 15 alnar 7 meter, dess stolpar tre och dess socklar tre. ");
INSERT INTO swe_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Och för den andra sidan (om porten) ska förhänget vara 15 alnar 7 meter, dess stolpar tre och dess socklar tre. ");
INSERT INTO swe_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Och porten till gården ska vara ett draperi som är 20 alnar 9 meter av blått, av purpur, av rött och fint tvinnat linne, ett vävt arbete i färger, dess stolpar ska vara fyra och dess socklar fyra. ");
INSERT INTO swe_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alla stolpar runt hela förgården ska vara klädda med silver, dess krokar av silver och dess socklar av brons. ");
INSERT INTO swe_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Längden på förgården ska vara 100 alnar 45 meter och bredden 50 alnar 22,5 meter och höjden 5 alnar 2,25 meter, av fint tvinnat linne och dess socklar av brons. ");
INSERT INTO swe_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Alla tillbehör till tabernaklet, till all tjänstgöring där, och alla dess tältpinnar tillsammans med alla tältpinnar till förgården, ska göras av brons. ");
INSERT INTO swe_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Du ska befalla Israels barn (söner) att de bär fram till dig ren olivolja, pressad för ljusbäraren (ljusstaken), så att den menoran kan brinna oavbrutet. ");
INSERT INTO swe_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","I mötestältet, utanför förhänget som hänger framför vittnesbördet, ska Aron och hans söner göra i ordning den, till att brinna från kväll till morgon inför Herren (Jahveh). Det ska vara en evig stadga genom alla generationer för Israels söners (barns) räkning. ");
INSERT INTO swe_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ta till dig Aron, din äldre bror så att han är nära dig och hans söner med honom, från Israels söner för att de ska göra tjänst för mig i prästämbetet, Aron, Nadav och Aviho som offrade främmande eld, se 3 Mos 10, Elazar som tog över prästämbetet efter Aron, se 4 Mos 20:24-29 och Itamar, Arons söner. ");
INSERT INTO swe_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Och du ska göra heliga kläder till Aron, din bror, för prakt (glans, tyngd – hebr. kavod) och skönhet (utsmyckning, något strålande – hebr. tifarah). Den avslutande frasen återkommer i vers 40 och ramar in detta stycke. Arons kläder har dels syftet att helga honom, avskilja honom för tjänst, men de återspeglar också en aning av Guds skönhet men mest av allt är de ett undervisningsmaterial där varje detalj påminner om Arons prästuppgifter och även är en förebild i det nyare förbundet. ");
INSERT INTO swe_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Och du ska tala till alla som har visa hjärtan, som jag har fyllt med vishetens ande att de gör (tillverkar) Arons kläder för att helga (avskilja) honom så att han kan tjänstgöra för mig i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Detta är plaggen som de ska tillverka: en bröstsköld en efod en rock en tunika av rutigt arbete en huvudbonad och en gördel De ska tillverka en helig ämbetsdräkt till din bror Aron och hans söner så att han kan göra tjänst för mig i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Och de ska ta tyger i färgerna guld och blått och purpur och scharlakansrött och fint vitt linne. I hebreiskan nämns bara färgerna men det är uppenbart att dessa färger avser fina garner eller tyger i respektive färg. Fint är hebr. shesh som kommer från ett egyptiskt ord som beskriver linne av hög kvalité importerat från Egypten. Linnet är vitt. ");
INSERT INTO swe_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","De ska göra en efod av guld, av blått och purpur, scharlakansrött och fint tvinnat vitt linne, tillverkat av en yrkesskicklig man. ");
INSERT INTO swe_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Den ska ha två axeldelar, som fogas samman i ändarna så att den hålls samman. ");
INSERT INTO swe_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","De konstfullt vävda banden som är på den, som den ska bindas fast med, ska vara lika som resten av arbetet och i ett stycke med det, av guld och blått och purpur och scharlakansrött tyg eller garn och fint tvinnat vitt linne. ");
INSERT INTO swe_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Du ska ta två onyxstenar (hebr. even shoham) och på dem ska du gravera in namnen på Israels söner, ");
INSERT INTO swe_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Sex av namnen på den första stenen Ruben, Simeon, Levi, Juda, Dan och Naftali och de sex återstående namnen på den andra stenen Gad, Asher, Isaskar, Sebulon, Josef och Benjamin, efter den ordning som de är födda från den äldste till den yngste. ");
INSERT INTO swe_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Med en gravörs arbete i sten som en graverad signetring ska du gravera de två stenarna efter namnen på Israels söner. Du ska göra dem med infattningar av guld. ");
INSERT INTO swe_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Och du ska sätta de två stenarna på axelstyckena av efoden, till att vara minnesstenar för Israels söner, och Aron ska bära deras namn inför Herrens (Jahvehs) ansikte på sina två skuldror som en hågkomst. ");
INSERT INTO swe_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Och du ska göra infattningar av guld, ");
INSERT INTO swe_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","och två kedjor av rent guld, av tvinnad tråd ska du göra dem, ett kransarbete, och du ska sätta kranskedjorna på infattningen. ");
INSERT INTO swe_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Och du ska göra en rättvisans bröstsköld (hebr. choshen mishpat), arbetet av en skicklig yrkesman, som arbetet med efoden ska du göra den, av guld och purpur och scharlakansrött och fint tvinnat linne ska du göra den. ");
INSERT INTO swe_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Den ska vara kvadratisk och dubbel, 1 spann ska vara dess längd och 1 spann ska vara dess bredd 23 x 23 cm . ");
INSERT INTO swe_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Och du ska göra infattningar med stenar, fyra rader med stenar. En rad med 1karneolröd – hebr. odem, från adam som betyder rödaktig; troligtvis är det den äldste (första) sonen Ruben som ristas in på denna sten (även om rubin på svenska syftar på en hårdare sten, så finns en äldre språklig koppling mellan rubin, röd och namnet Ruben); stenen används även för att beskriva Gud i tronrummet, se Upp 4:3; grekiska översättningen Septuaginta översätter med sardion den sjätte grundstenen (centralt placerad), se Upp 21:20, 2topasolivgrön, gulaktig; hebr. pitda, okänt ursprung; grekiska översättningen Septuaginta översätter med topazion som är den nionde grundstenen, se Upp 21:20 och 3smaragdgenomskinligt grön; hebr. bareqet (från baraq att glittra, reflektera); används bara i GT om den tredje stenen i bröstskölden; grekiska översättningen Septuaginta översätter med smaragdos som är den fjärde grundsten, se Upp 21:19, den första raden. ");
INSERT INTO swe_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Och den andra raden, 4karbunkelhebr. nofesh, från ett ord som betyder att gnistra, 5safirhebr. sapir – ”en blå sten”; himmelsblå. Under antiken benämndes alla blå ädelstenar safirer och är mer sannolikt att det är den blå bergarten lapis lazuli som avses här, än den blå korund som kallas safir idag. Den romerska naturfilosofen Plinius (23-79 e.Kr.) beskriver hur sapphiros också har inslag av guldstänk (vilket lapis kan ha). Första gången stenen omnämns är i 2 Mos 24:10 där den beskrivs vara lik själva himlarna i klarhet. Den andra grundstenen, se Upp 21:19 och 6kalcedonrökfärgad, vitaktig eller ljusblå – hebr. jahalom kommer från halam som betyder slå ner, bryta sönder; det kan beskriva att det är en hårdare sten, kanske diamant. Den tredje grundstenen, se Upp 21:19. ");
INSERT INTO swe_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Och den tredje raden, 7hyacintmörkröd, lila – hebr. leshem, används bara i GT om den sjunde stenen i bröstskölden; den elfte grundstenen, se Upp 21:20, 8agathebr. shevo, används bara i GT om den sjunde stenen i bröstskölden och 9ametistpurpur och violett – hebr. achlama, används bara i GT om den nionde stenen i bröstskölden; den tolfte grundstenen, se Upp 21:20. ");
INSERT INTO swe_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Och den fjärde raden, 10krysolithebr. tarsis, troligtvis från staden Tarshish, kanske importerad från avlägset håll, och 11onyxhebr. shoham; troligtvis från ordet att bleka, samma sten som i vers 9 och 12jaspisgrön sten – hebr. jashfe; från ordet att polera; under antiken användes ordet främst för gröna (delvis genomskinliga) stenar, men idag används termen även för andra färger; denna sten är grunden i muren i det nya Jerusalem, se Upp 21:12-19.. De var ditsatta med infattningar av guld. ");
INSERT INTO swe_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Och stenarna ska vara efter namnen på Israels söner, tolv till antalet, efter deras namn, graverade som en signetring, var och en med sitt namn för de tolv stammarna. Exakt vilket namn som motsvarar varje sten definieras inte. Att Ruben kommer först är troligt. I Hes 48:30-34 räknas stammarnas placering upp. Troligtvis hade varje stams flagga inslag av stenens färg, se 4 Mos 2:2. Dessa tolv stenar återfinns också i beskrivningen av det nya Jerusalem i Uppenbarelseboken, se Upp 21:19-20. ");
INSERT INTO swe_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Och på bröstskölden ska du göra flätade kedjor, ett kransarbete av rent guld. ");
INSERT INTO swe_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Och på bröstskölden ska du göra två ringar av guld och sätta de två ringarna på de två sidorna av bröstskölden. ");
INSERT INTO swe_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Och du ska sätta de två flätade kedjorna av guld på de två ringarna på bröstsköldens sidor. ");
INSERT INTO swe_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Och de två andra ändarna på de två tvinnade kedjorna ska du sätta på de två infattningarna och sätta dem på efodens två axelstycken, på dess främre del. ");
INSERT INTO swe_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Och du ska göra två ringar av guld och sätta dem på de två ändarna av bröstskölden, på dess kant som är vända mot sidan på efodens insida. ");
INSERT INTO swe_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Och du ska göra två ringar av guld och sätta dem på efodens två axelstycken undertill, i dess framkant, nära dess sammankoppling ovanför efodens skickligt vävda band. ");
INSERT INTO swe_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Och de ska binda fast bröstskölden med dess ringar till efodens ringar med en blå snodd (flätad tråd) från de färgade trådarna i 2 Mos 25:4, så att den ska vara på efodens skickligt vävda band, så att bröstskölden inte lossnar från efoden. ");
INSERT INTO swe_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Och Aron ska bära Israels söners namn på rättvisans bröstsköld (hebr. choshen mishpat) över sitt hjärta när han går in till den heliga platsen, som en ständig (oavbruten) åminnelse inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Och du ska lägga Urim (ljus) och Tummim i rättvisans bröstsköld (hebr. choshen mishpat), och de ska vara på Arons hjärta när han går inför Herrens (Jahvehs) ansikte. Och Aron ska bära Israels söners rättvisa (hebr. mishpat) inför Herrens (Jahvehs) ansikte alltid (hela tiden, oavbrutet, kontinuerligt). Det hebreiska ordet mishpat betyder påbud och bindande juridiska beslut. Det har med rätt och rättvisa att göra och här är det Gud som svarar med sitt rätta och rättvisa domslut när Aron använder Urim och Tummim för att få veta Guds vilja i enskilda frågor. I 2 Mos 39 där Mose ger instruktionerna för bröstskölden nämns aldrig Urim och Tummim, men i 5 Mos 33:8 sägs att de tillhör Gud. Urim och Tummim är två föremål (troligtvis två mindre stenar eller stavar) som prästen bar i sin prästsköld och som antagligen användes för att kasta lott, se 4 Mos 27:21; 1 Sam 14:42; 28:6. Eftersom Urim kommer från ordet för ljus, så är en teori att det var en vit sten. Ordet Tummim kommer från ordet för sanning. ");
INSERT INTO swe_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Och du ska göra efodens rock (ämbetsdräkt) helt i blått. ");
INSERT INTO swe_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Och den ska ha ett hål för huvudet i dess mitt och den ska ha en snörning runt dess hål, som hålet på en pansarskjorta, så att det inte kan repas upp. Rocken är gjord i ett stycke och saknar alltså knäppning. ");
INSERT INTO swe_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Och på fållen längst ner på den blå klädnaden, se vers 31 ska du göra granatäpplen enligt tradition 72 st av blått och purpur och scharlakansrött runtom fållen och klockor (bjällror) av guld mellan dem runtom, ");
INSERT INTO swe_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","en guldklocka och ett granatäpple, en guldklocka och ett granatäpple runt klädnadens fåll längst ner. ");
INSERT INTO swe_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Och den ska Aron ha på sig när han tjänstgör och dess ljud ska höras när han går in till den heliga platsen inför Herrens (Jahvehs) ansikte, och när han kommer ut, för att han inte ska dö. Den exakta kopplingen mellan klockorna och frasen att han inte ska dö är inte klar. Mest troligt är att det syftar på att översteprästen ska ha hela ämbetsdräkten på sig (ovanpå de vita linnekläderna, se 3 Mos 16:4) och utföra sysslorna enligt Herrens instruktioner, se vers 31. Ljudet från klockorna gjorde att de prästerna som följt med in i det heliga också kunde höra när översteprästen rörde sig i det allra Heligaste. Även de som var i bön utanför kunde följa med i sina böner. Ljudet påminde ständigt också översteprästen om hans speciella uppdrag, och att följa alla instruktioner, som annars kunde resultera i hans död, jfr 2 Sam 6:7. ");
INSERT INTO swe_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Och du ska göra en platta av rent guld och gravera på den som man graverar en signetring: ”Helgad till Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Och du ska sätta en blå snodd (flätad tråd) i den för att fästa den ovanpå turbanen, på framsidan av turbanen ska den sitta. ");
INSERT INTO swe_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Och den ska vara över Arons panna och Aron ska bära synderna som begås med de heliga tingen, som Israels söner ska helga, till alla deras helgade gåvor, och den ska alltid vara på hans panna så att de får nåd (villkorad nåd – hebr. ratson) inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Och du ska väva tunikor av rutigt arbete i fint linne. Och du ska göra en turban av fint linne. Och du ska göra en gördel, en vävares arbete i färger. ");
INSERT INTO swe_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Och till Arons söner ska du göra tunikor, och du ska göra gördlar till dem, och huvudbonader ska du göra till dem, för prakt (glans, tyngd – hebr. kavod) och skönhet (utsmyckning, något strålande – hebr. tifarah). Samma avslutande fras som i vers 2. ");
INSERT INTO swe_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Och du ska sätta dem på Aron din bror och hans söner med honom, och du ska smörja dem och avskilja (inviga) dem och helga dem så att de kan tjänstgöra till mig i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Och du ska göra åt dem linnebyxor för att dölja nakenheten av deras kött (kroppar), de ska nå från länden (höften) till låret (vid knäna). ");
INSERT INTO swe_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Och de ska vara på Aron och hans söner när de går in i mötestältet eller när de kommer nära altaret för att tjänstgöra på den heliga platsen, så att de inte bär på synd och dör. Det ska vara en förordning (ordagrant ”saker inristat”) för evigt för honom och hans säd efter honom. ");
INSERT INTO swe_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Och dessa är de saker som du ska göra med dem för att helga dem till att tjänstgöra till mig i prästämbetet. Ta en tjur och två felfria (hebr. tamim) baggar, ");
INSERT INTO swe_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","och osyrat bröd och osyrade brödkakor blandade med olja och osyrade brödkakor ringlade med olja, av fint vete ska du göra dem. ");
INSERT INTO swe_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Och du ska lägga dem i en korg och föra fram dem i korgen med tjuren och de två baggarna. ");
INSERT INTO swe_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Och Aron och hans söner ska du föra fram till mötestältets öppning och du ska tvätta dem med vatten. ");
INSERT INTO swe_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Och du ska ta kläderna och sätta tunikan på Aron, och efodens rock och efoden och bröstskölden och omgjorda honom med efodens konstfullt vävda band. ");
INSERT INTO swe_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Och du ska sätta turbanen på honom och sätta den heliga kronan på turbanen. ");
INSERT INTO swe_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Sedan ska du ta smörjelseoljan och hälla ut över hans huvud och smörja honom. ");
INSERT INTO swe_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Och du ska föra fram hans söner och sätta på dem tunikor. ");
INSERT INTO swe_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Och du ska omgjorda dem med gördlar, Aron och hans söner och binda huvudbonader på dem, och de ska vara innehavare av prästämbetet som en evig förordning (ordagrant ”saker inristat”), och du ska avskilja (inviga) Aron och hans söner. ");
INSERT INTO swe_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Och du ska föra fram tjuren framför mötestältet och Aron och hans söner ska lägga sina händer på tjurens huvud. ");
INSERT INTO swe_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Och du ska slakta tjuren inför Herrens (Jahvehs) ansikte i mötestältets öppning. ");
INSERT INTO swe_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Och du ska ta blodet från tjuren och stryka det på altarets horn med ditt finger och du ska hälla ut hela återstoden av blodet vid altarets fot. ");
INSERT INTO swe_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Och du ska ta allt det feta som täcker inälvorna och hinnorna som är över levern och de två njurarna och fettet som är på dem och låta det bli en rök ovanpå altaret. ");
INSERT INTO swe_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Men tjurens kött och dess hud och dess avskräde (slaktrester; inälvorna som tas ur när djuret slaktas) ska du bränna i eld utanför lägret. Det är ett syndoffer. ");
INSERT INTO swe_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Du ska ta den ena baggen och Aron och hans söner ska lägga sina händer på baggens huvud. ");
INSERT INTO swe_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sedan ska du slakta baggen och du ska ta dess blod och stänka det runtomkring mot altaret. ");
INSERT INTO swe_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Och du ska dela baggen i sina delar, och tvätta inälvorna och dess ben och lägga dem med sina delar och med dess huvud. ");
INSERT INTO swe_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Och du ska göra hela baggen till en rök på altaret, det är ett brännoffer till Herren (Jahveh), det är en söt arom, ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Och du ska ta den andra baggen och Aron och hans söner ska lägga sina händer på baggens huvud. ");
INSERT INTO swe_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sedan ska du slakta baggen och ta av dess blod och stryka det på Arons högra örsnibb och på den högra örsnibben på hans söner, och på tummen på deras högra händer, och på stortån på deras högra fötter och stänka blodet mot altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Och du ska ta av blodet som är på altaret och av smörjelseoljan och stänka det över Aron och över hans kläder och över hans söner och över sönernas kläder med honom. Och han och hans kläder ska bli helgade och hans söner och hans söners kläder med honom. ");
INSERT INTO swe_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Och du ska ta bort det feta från baggen och fettsvansen och det feta som täcker inälvorna och hinnorna som är över levern och de två njurarna och fettet som är på dem och det högra lårstycket, för detta är en bagge till invigning, ");
INSERT INTO swe_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","och ta en rund brödkaka och ett oljat bröd och en tunn brödkaka ur korgen med osyrat bröd som är inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Och du ska placera alltihop över (i) Arons händer och över (i) händerna på hans söner och ska vifta dem som ett viftoffer inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Och du ska ta det från deras händer och göra det till en rök på altaret ovanpå brännoffret, som en söt arom inför Herrens (Jahvehs) ansikte, det är ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Och du ska ta bröststycket från Arons prästvigningsbagge och vifta det som ett viftoffer inför Herrens (Jahvehs) ansikte, och det ska vara deras del. ");
INSERT INTO swe_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Och du ska helga viftoffrets bröststycke och lyftoffrets lår, som är viftat och som är upplyft från prästvigningsbaggen, det som är Arons och det som är hans söners. ");
INSERT INTO swe_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Och det ska vara för Aron och hans söner som deras rättmätiga del för evigt från Israels söner, för det är ett lyftoffer (hebr. teromah), och det ska vara ett lyftoffer från Israels söner av deras shalomoffer (gemenskapsoffer – hebr. zevach shelamim), deras lyftoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Och Arons heliga kläder ska vara för hans söner efter honom, för att bli smorda i dem och för att bli invigda (avskilda) i dem. ");
INSERT INTO swe_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sju dagar ska sonen som blir präst i hans ställe ha dem på sig, han som kommer in i mötestältet för att tjänstgöra på den heliga platsen. ");
INSERT INTO swe_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Och du ska ta prästvigningsbaggen och koka dess kött på en helig plats. ");
INSERT INTO swe_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Och Aron och hans söner ska äta baggens kött och brödet som är i korgen vid mötestältets öppning. ");
INSERT INTO swe_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Och de ska äta dessa ting varmed försoning har bringats för att inviga (avskilja) och helga dem, men en främling ska inte äta av det eftersom det är heligt. ");
INSERT INTO swe_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Och om något överblivet av invigningsköttet eller av brödet finns kvar till morgonen, då ska det överblivna brännas med eld, det ska inte ätas eftersom det är heligt. ");
INSERT INTO swe_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Och du ska göra med Aron och med hans söner enligt allt det som jag har befallt dig, sju dagar ska du inviga (avskilja) dem. ");
INSERT INTO swe_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Och varje dag ska du offra en tjur som syndoffer vid sidan om de andra offren för försoning, och du ska göra reningen ovanpå altaret när du bringar försoning för det, och du ska smörja det och helga det. ");
INSERT INTO swe_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sju dagar ska du bringa försoning för altaret och helga det, så ska altaret bli högheligt, allt som vidrör altaret blir heligt. ");
INSERT INTO swe_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Detta är vad du ska offra på altaret varje dag för all framtid: Två årsgamla lamm. ");
INSERT INTO swe_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Det ena lammet ska du offra på morgonen och det andra i skymningen (ordagrant: mellan de två kvällarna) 2 Mos 12:6. ");
INSERT INTO swe_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Till det första lammet ska du offra en tiondels efa 3,5 liter fint mjöl, blandat med en fjärdedels hin 0,9 liter olja av stötta oliver och som drickoffer en fjärdedels hin 0,9 liter vin. ");
INSERT INTO swe_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Det andra lammet ska du offra vid skymningen, och gör med det som med matoffret på morgonen och som dess drickoffer, som en söt arom, ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Det ska vara ett oavbrutet brännoffer genom era generationer vid mötestältets öppning inför Herrens (Jahvehs) ansikte, där jag möter er för att tala med er. ");
INSERT INTO swe_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Och där i mötestältet ska jag möta Israels söner, och det ska bli helgat i min härlighet. Tabernaklet så väl som prästen och altaret blir helgat i Herrens närvaro, se 2 Mos 40:34-35. ");
INSERT INTO swe_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Så ska jag helga mötestältet och altaret. Jag ska även helga Aron och hans söner till att göra tjänst inför mig som präster. ");
INSERT INTO swe_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Så ska jag bo bland Israels söner och vara deras Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Då ska de veta att jag är Herren deras Gud (Jahveh Elohim), som fört dem upp och ut ur Egyptens land, så att jag kan vara (vistas, bo) bland dem. Jag är Herren deras Gud (Jahveh Elohim). ");
INSERT INTO swe_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Och du ska göra ett altare att bränna rökelse på, av akaciaträ ska du göra det. ");
INSERT INTO swe_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dess längd ska vara 1 aln och dess bredd ska vara 1 aln 45 x 45 cm, kvadratiskt ska det vara, och 2 alnar 90 cm ska vara dess höjd, dess horn ska vara i ett stycke med det. ");
INSERT INTO swe_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Och du ska plätera det med rent guld, dess ovansida och dess sidor runtom och dess horn. Och du ska göra en krona av guld runtom. ");
INSERT INTO swe_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Och två guldringar ska du göra till det, under dess krona på dess två ben, på de två sidorna av det ska du göra dem, och de ska vara hållare för stängerna som det ska bäras med. ");
INSERT INTO swe_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Och du ska göra stänger av akaciaträ och plätera dem med guld. ");
INSERT INTO swe_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Och du ska ställa det framför draperiet (förhänget) som är vid vittnesbördets ark, framför locket som täcker vittnesbördet, där jag ska möta (träffa, umgås med) dig. ");
INSERT INTO swe_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Och Aron ska bränna rökelse på det av söta kryddor, varje morgon när han gör i ordning lamporna (trimmar vekarna), ska han bränna den. ");
INSERT INTO swe_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Och när Aron tänt lamporna vid skymningen (ordagrant: mellan de två kvällarna) 2 Mos 12:6 ska han bränna den som en evig rökelse inför Herrens (Jahvehs) ansikte genom era generationer. ");
INSERT INTO swe_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ni ska inte offra främmande rökelse på det, inget brännoffer, inget matoffer och ni ska inte hälla ut något drickoffer på det. ");
INSERT INTO swe_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Och Aron ska bringa försoning över dess horn en gång om året, med blodet från syndoffret för försoning en gång om året ska han bringa försoning för det genom era generationer. Det är det allra heligaste till Herren (Jahveh). Detta är en del av arbetet som översteprästen gör på jom kippur – försoningsdagen, se 3 Mos 16. ");
INSERT INTO swe_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","”När du räknar Israels söner efter deras antal, då ska de ge, varje man en lösensumma för sin själ till Herren (Jahveh), när du räknar dem, så att ingen plåga kommer bland dem när du räknar dem. ");
INSERT INTO swe_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Detta ska de ge, var och en av dem som går förbi som är räknad, en halv shekel efter helgedomens shekel – shekeln är 20 gera – en halv shekel som ett offer till Herren (Jahveh). En shekel är en viktenhet på 11,5 gram. En gera är 1/20 shekel vilket är 0,6 gram. ");
INSERT INTO swe_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Alla som går förbi bland dem som räknas, från 20 års ålder och uppåt ska ge offret till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Den rike ska inte ge mer och den fattige ska inte ge mindre än den halva shekeln, när de ger offret till Herren (Jahveh), för att bringa försoning för sina själar. ");
INSERT INTO swe_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Och du ska ta försoningspengarna från Israels söner och helga det till arbetet i mötestältet, så att det blir ett minne för Israels söner inför Herrens (Jahvehs) ansikte, till försoning för era liv.” ");
INSERT INTO swe_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","”Du ska göra ett vattenkar av brons och dess fundament av brons, till att tvätta sig, och du ska ställa det mellan mötestältet och altaret, och du ska hälla vatten i det. ");
INSERT INTO swe_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Och Aron och hans söner ska tvätta sina händer och sina fötter i det, ");
INSERT INTO swe_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","när de går in i mötestältet ska de tvätta sig med vatten så att de inte dör, eller när de kommer nära altaret för att tjänstgöra, när de låter ett eldsoffer bli en rök till Herren (Jahveh), ");
INSERT INTO swe_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","då ska de tvätta sina händer och sina fötter så att de inte dör. Detta ska vara en förordning (ordagrant ’saker inristat’) för evigt för dem, för honom och för hans säd genom deras generationer.” ");
INSERT INTO swe_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","”Ta dig de finaste (bästa, förnämsta) kryddorna av flytande myrra 500 shekel 6 kg och av söt kanel hälften så mycket 250 3 kg, och av söt (aromatisk) vass 250 3 kg, ");
INSERT INTO swe_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","och av kryddkassia 500 6 kg, efter helgedomens shekel, och av en hin 3,5 liter olivolja. ");
INSERT INTO swe_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Och du ska göra en helig smörjelseolja av det, en parfym sammansatt med en parfymörs skicklighet, det ska vara en helig smörjelseolja. ");
INSERT INTO swe_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Och med den ska du smörja mötestältet och vittnesbördets ark, ");
INSERT INTO swe_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","och bordet och alla dess redskap och menoran och dess redskap och rökelsealtaret, ");
INSERT INTO swe_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","och brännofferaltaret med alla dess redskap och vattenkaret och dess fundament. ");
INSERT INTO swe_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Och du ska helga dem så att de blir högheliga, allt som vidrör dem ska bli heligt. ");
INSERT INTO swe_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Och du ska smörja Aron och hans söner och avskilja (helga) dem så att de kan tjänstgöra till mig i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Och du ska tala till Israels söner och säga: ’Detta är en helig smörjelseolja till mig genom era generationer. ");
INSERT INTO swe_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Den ska inte hällas på någon människas kropp, inte heller ska någon tillverka något efter dess recept, den är helig och den ska vara (förbli) helig för er. ");
INSERT INTO swe_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Den som tillverkar något likadant eller vemhelst som använder något av den på en främling, han ska bli avhuggen från sitt folk.’ ” ");
INSERT INTO swe_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Och Herren (Jahveh) sa till Mose: ”Ta dig söta kryddor, självrunnen kåda, sjönagel och galban, söta kryddor med ren rökelseharts, av varje (sort) ska du ta samma vikt. Rökelse är en bild på bön (Ps 14:2; Upp 5:8). De olika ingredienserna symboliserar skilda typer av bön. Självrunnen kåda är bilden på när vi ber och bekänner. Den andra ingrediensen, sjönagel, är skal av en mussla från havsdjupen och en bild på bön för våra behov (Ps 130:1-2; 50:15). Den tredje ingrediensen, galban, är en kåda med stark väldoft. Det är en bild på tacksägelse. Slutligen har vi rent rökelseharts som är en bild på tillbedjan. Dessutom ska denna blandning vara kryddad med salt. Det är en bild på renhet och helighet. Salt skyddar mot förruttnelse och i 3 Mos 2:13 säger Gud att saltet är ett förbundssalt. Därför ska det vara med överallt som ett förbundstecken mellan oss och Gud. ");
INSERT INTO swe_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Och du ska göra rökelse utav det, en parfym med en parfymörs skicklighet, kryddat med salt, rent och heligt. ");
INSERT INTO swe_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Och du ska mala en del av det väldigt fint och placera det framför vittnesbördet i mötestältet, där jag ska umgås med dig, det ska för dig vara högheligt. ");
INSERT INTO swe_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Och rökelsen som du ska göra efter dess recept, ska du inte göra till dig själv, det ska för dig vara helgat till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Den man som tillverkar detta bara för att själv få känna doften, ska huggas av från sitt folk.” ");
INSERT INTO swe_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Se jag har kallat vid namn Betsalel betyder: ”i skuggan av Gud” – dvs. under hans beskydd, son till Ori betyder: ”mitt ljus”, hans fulla namn var troligen Oriel eller Oriah, son till Hur (hebr. Chor) 2 Mos 17:10; 24:14, av Juda stam. ");
INSERT INTO swe_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Jag har fyllt honom med Guds Ande, med vishet (förmågan att skilja mellan rätt och fel) och förstånd (förmågan att kunna bygga och konstruera) och kunskap (en personlig erfarenhet av) att kunna utföra uppgiften, och i alla slags hantverk, ");
INSERT INTO swe_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","till att tänka ut (planera, skapa, vara kreativ i) konstfulla arbeten och utföra dem i guld, silver och brons, ");
INSERT INTO swe_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","slipa stenar för infattning och snida i trä och utföra alla slags arbeten. Betsalel är den första personen i Bibeln som blir fylld med Guds Ande. Han är en hantverkare. Här finns en profetia som Jesus uppfyller när man kallar honom ”hantverkarens son”, se Matt 13:55. Talvärdet av namnet Betsalel är 153, se Joh 21:11. Tabernaklet med alla dess möbler bestod av trä och metall (guld, silver, brons, ädelstenar) och tyg, se 2 Mos 25-30. Det hebreiska ordet nechoshet kan översättas koppar eller någon av dess legeringar som gör materialet hårdare. I GT används ordet för att beskriva brons, som är legering av omkring 90% koppar och 10% tenn. ");
INSERT INTO swe_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Och jag, se jag har gett honom Oholiav, son till Achisamach av Dans stam. Och i hjärtat på alla som har ett vist hjärta har jag gett visheten, så att de kan göra allt som jag har befallt dig i kapitel 25-30: ");
INSERT INTO swe_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","mötestältet, vittnesbördets ark, nådastolen (locket, bokstavligt ”det som täcker”) som är ovanpå och alla tältets möbler. ");
INSERT INTO swe_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Bordet och dess redskap, den rena menoran med alla dess redskap och rökelsealtaret, ");
INSERT INTO swe_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","och brännofferaltaret med alla dess redskap och vattenkaret på dess fundament, ");
INSERT INTO swe_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","och de broderade kläderna och de heliga kläderna till prästen Aron och kläderna till hans söner för att tjänstgöra i prästämbetet, ");
INSERT INTO swe_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","och smörjelseoljan, och rökelsen av söta kryddor till det heliga. I enlighet med allt som jag har befallt dig ska de göra. Enligt det mönster Herren instruerat Mose, se 2 Mos 25:9, 40; 26:30; 27:8. ");
INSERT INTO swe_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Tala till Israels söner och säg: ”Var noga med att hålla (vakta, skydda, bevara) mina sabbater, för de är ett tecken mellan mig och era söners söner till generationerna, för att ni ska veta (vara intimt förtrogna med) att jag är Herren (Jahveh) som helgar er (gör er avskilda). ");
INSERT INTO swe_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Därför ska ni hålla (vakta, skydda, bevara) sabbaten, för det är heligt för er. Den som vanhelgar den ska dödas, för alla som gör något arbete, den själen (personen) ska huggas av från sitt folk. ");
INSERT INTO swe_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sex dagar ska arbete göras men på den sjunde dagen är en sabbat med fullkomlig vila (hebr. shabbat shabbaton), helig för Herren (Jahveh). Den som gör något arbete på sabbatsdagen ska med säkerhet dödas. ");
INSERT INTO swe_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Därför ska Israels söner hålla (vakta, skydda, bevara) sabbaten och fira sabbaten genom generationerna som ett evigt förbund. ");
INSERT INTO swe_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Den är ett tecken mellan mig och Israels söner för evig tid, för på 6 dagar skapade Herren (Jahveh) himlarna och jorden och på den sjunde dagen avstod han från sitt arbete och vilade (bokstavligt sabbat).” 1 Mos 2:1-3 ");
INSERT INTO swe_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Och han gav till Mose, när han hade fullbordat talandet med honom på berget Sinai, vittnesbördets två stentavlor skrivna med Guds (Elohims) finger. ");
INSERT INTO swe_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Folket märkte att Mose dröjde kvar på berget (de blev otåliga och besvikna och skämdes för honom eftersom han var kvar längre än väntat). De samlade sig omkring (bildade en gruppering mot) Aron och sa till honom: ”Gör någonting (sitt inte bara där), gör gudar åt oss som kan gå framför oss! Vi vet inte vart den där Mose har tagit vägen, han som förde oss ut ur Egypten.” ");
INSERT INTO swe_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Så Aron sa till dem: ”Ta guldörhängen från öronen på era fruar, söner och era döttrar och kom hit med dem.” Guldet var tänkt att användas till Guds tempel, se 2 Mos 35:20-29. Kanske tänkte Aron vinna lite tid och bevara lugnet hos folket genom att sysselsätta dem fram tills Mose kom tillbaka. ");
INSERT INTO swe_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Alla gjorde detta, de tog av sig sina guldörhängen som de hade på sig och kom med dem till Aron. ");
INSERT INTO swe_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Han tog emot guldet av dem. Med hjälp av verktyg formade han avbilden som skulle göras. Antingen en träram som sedan bekläddes med guld, eller en träform som man sedan göt i. Han använde det smälta guldet och formade en kalv (en avbild av en ung tjur). Sedan sa de ledarna från folket som var initiativtagare till att göra egna gudar: ”Detta, Israel, är er gud som har fört er ut från Egypten.” Guldkalven är en skrämmande symbol. I Egypten tillbad man tjurguden Apis. Även guden Baal, som tillbads i Kanaans land, förkroppsligades och avbildades ofta som en ung oxe. Aron hade varit med och gjort så att folket bröt mot de tre första buden. De tillbad en annan Gud, de hade gjort en avbild och vanärat Herrens namn i avgudadyrkan. ");
INSERT INTO swe_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Och när Aron såg detta byggde han ett altare framför den och Aron utropade och sa: ”Fest till Herren (Jahveh) i morgon.” ");
INSERT INTO swe_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Och de steg upp tidigt nästa morgon och offrade brännoffer och förde fram shalomoffer och folket satt ner och åt och drack och steg upp och roade sig. ");
INSERT INTO swe_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Då talade Herren (Jahveh) till Mose: ”Vandra, gå ner i 5 Mos 9:12 betonas att det är bråttom, för ditt folk som du förde ut ur Egyptens land har handlat bedrägligt. ");
INSERT INTO swe_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","De har hastigt vänt sig bort från vägen som jag befallde dem, de har gjort sig en gjuten kalv och har tillbett den och har offrat till den och sagt: ’Detta är din gud Israel som har fört dig ut ur Egyptens land.’ ” ");
INSERT INTO swe_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Och Herren (Jahveh) sa till Mose: ”Jag har sett detta folk och se, det är ett styvnackat folk. ");
INSERT INTO swe_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Låt mig nu därför vara ensam så att min vrede kan bli het mot dem och jag kan förtära dem, och jag ska göra dig till ett stort folk (en stor nation).” ");
INSERT INTO swe_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Men Mose bad (vädjade) till Herren sin Gud (Jahveh Elohim) och sa: ”Herre (Jahveh) varför låter du din vrede bli het mot ditt folk som du har fört ut ur Egyptens land med stor makt och med stark (fast, säker, tapper) hand? ");
INSERT INTO swe_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Varför ska egyptierna få tala och säga ’Till ont förde han dem ut för att slakta dem i bergen och förtära dem från jordens ansikte (yta)?’ Vänd om från din brinnande vrede och ångra (sörj-trösta – hebr. nacham) denna ondska mot ditt folk. ");
INSERT INTO swe_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kom ihåg Abraham, Isak och Israel, dina tjänare, till vilka du lovade (svor, gav din ed) vid dig själv och talade till dem: ’Jag ska föröka din säd (så att den blir) som himlarnas stjärnor och hela detta land som jag har sagt att jag ska ge till din säd och de ska ärva det för evigt.’ ” ");
INSERT INTO swe_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Och Herren (Jahveh) ändrade sig om (sorg-tröstade – hebr. nacham) ondskan som han hade talat att han skulle göra mot sitt folk. Hebr. nacham i vers 12 och 14 översätts ibland till ”ångra”, men ordet betyder både att känna sorg och att trösta, och också själva ”ändringen” i själva skeendet då man går från sorg till att ge tröst. Profeten Nahums namn, som betyder tröst, har samma hebreiska rot (nhm), se även Nah 3:7; Ps 23:4; 71:21. Gud känner sorg över hur snabbt folket föll i synd, men börjar nu processen att trösta och genom att inte förgöra dem. ");
INSERT INTO swe_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Och Mose vände om och gick ner från berget med vittnesbördets två tavlor i sina händer, tavlorna som var skrivna på båda sidor, på den ena sidan var det skrivet och på den andra sidan var det skrivet. ");
INSERT INTO swe_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Och tavlorna var gjorda av Gud (Elohim) och det skrivna var skrivet av Gud (Elohim), ingraverat på tavlorna. ");
INSERT INTO swe_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Och när Josua hörde larmet av folk när de ropade, sa han till Mose: ”Det är ett ljud av strid i lägret.” ");
INSERT INTO swe_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Och han svarade: ”Det är inte röster av dem som ropar om herravälde (seger), och inte heller röster från dem som ropar för att bli övervunna, utan ljudet av dem som sjunger är vad jag hör.” ");
INSERT INTO swe_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","När Mose närmade sig lägret och han såg kalven och dansen, då blev han brinnande vred (hans vrede blev brinnande het). Han kastade tavlorna ur sina händer och bröt dem nedanför berget. ");
INSERT INTO swe_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Och han tog kalven som de hade gjort och brände den med eld och malde den till puder och strödde ut det på vattnet och tvingade Israels söner att dricka av det. ");
INSERT INTO swe_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Och Mose sa till Aron: ”Vad har detta folk gjort mot dig, så att du har fört fram en stor synd över dem?” ");
INSERT INTO swe_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Och Aron svarade: ”Låt inte min herres vrede bli brinnande het, du känner folket (är intimt förtrogen med dem) att de är inställda på (vända till) ondska. ");
INSERT INTO swe_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Så de sa till mig: ’Gör oss en gud som kan gå före oss, för vi vet inte vad det har blivit av den där mannen Mose som förde oss ut ur Egypten.’ ");
INSERT INTO swe_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Och jag sa till dem: ’Den som har något guld, låt honom bryta av det, och de gav det till mig och jag kastade det i elden och det kom ut en kalv.’ ” ");
INSERT INTO swe_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Och när Mose såg att folket var tygellöst, för Aron hade låtit dem bli tygellösa på grund av deras fienders hån, ");
INSERT INTO swe_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","då ställde sig Mose i lägrets port och sa: ”Vem är på Herrens (Jahvehs) sida, låt honom komma till mig.” Och alla Levi söner samlade sig till honom. ");
INSERT INTO swe_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Och han sa till dem: ”Så säger Herren (Jahveh), Israels Gud (Elohim): ’Må varje man sätta svärdet på sin höft och gå fram och tillbaka från port till port genom lägret och slå varje man sin bror och varje man sin vän och varje man sin granne.’ ” ");
INSERT INTO swe_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Och Levi söner gjorde efter Moses ord och 3 000 män föll den dagen. ");
INSERT INTO swe_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Och Mose sa: ”Helga er själva till Herren (Jahveh) idag, för varje man har varit emot sin son och emot sin bror, så att han kan ge en välsignelse över er idag.” ");
INSERT INTO swe_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nästa dag sa Mose till folket: ”Ni har begått en allvarlig synd, men jag ska gå till Herren (Jahveh) nu – kanske kan jag få försoning för er synd.” ");
INSERT INTO swe_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Så Mose gick tillbaka till Herren (Jahveh) och sa: ”Detta folk har begått en allvarlig synd, de har gjort sig gudar av guld. ");
INSERT INTO swe_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Om du skulle förlåta deras synd ... men om du inte gör det, utplåna mig från boken du skriver i.” Första delen av meningen är inte fullständig, den avslutas inte. Det är en ”aposiopesis”, som förstärker att det blir en känsloladdad tystnad. Det verkar som om Mose börjar fundera på vad människorna skulle kunna ge tillbaka till Gud om han förlåter deras synd? Eftersom det inte finns någonting vi kan göra för att förtjäna förlåtelse så fortsätter i stället Mose med det andra alternativet – utplåna mig från din bok. ");
INSERT INTO swe_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Herren (Jahveh) svarade Mose: ”Den som har syndat mot mig ska jag utplåna ur min bok. ");
INSERT INTO swe_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Gå tillbaka nu, led folket till den plats jag har talat med dig om. Min ängel ska gå framför dig. Men den dag kommer då jag ska gå till rätta med dem för deras synd.” ");
INSERT INTO swe_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Herren (Jahveh) straffade (skickade en plåga, prövning till) folket, på grund av kalven som de gjort – den som Aron gjorde. Ordet straff är samma ord som används om de tio plågorna mot Egypten tidigare. Målet med dessa plågor var omvändelse. Det är oklart om detta straff i denna vers syftar på de tretusen män som valde att inte gå över på Guds sida och fick betala med sina liv, se vers 26-28, eller om det är kommande plågor och prövningar som kommer över israeliterna i deras fortsatta vandring om de vägrar att lyda Gud. I nästa kapitel ställs israeliterna inför ett val att ta av sig alla smycken som ett tydligt tecken på en genuin omvändelse från deras avgudadyrkan. ");
INSERT INTO swe_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Herren (Jahveh) talade till Mose: ”Gå upp, du och folket som du har fört upp ut ur Egyptens land, till landet som jag lovade (svor, gav min ed) till Abraham, till Isak och till Jakob och sa: ’till din säd ska jag ge det’, ");
INSERT INTO swe_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","och jag ska sända en ängel (budbärare) framför er och jag ska driva ut kanaanéerna, amoréerna och hettiterna och perisséerna och hivéerna och jevusiterna, ");
INSERT INTO swe_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","till ett land som flyter av mjölk och honung, för jag ska inte gå upp mitt ibland er för ni är ett styvnackat folk, så att jag inte förtär dig under vägen.” ");
INSERT INTO swe_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Och när folket hörde dessa onda ord, sörjde de och ingen man satte på sig sina smycken. ");
INSERT INTO swe_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Och Herren (Jahveh) sa till Mose: ”Säg till Israels söner: ’Ni är ett styvnackat folk. Om jag går upp mitt ibland er för ett ögonblick, kommer jag att förtära er. Ta därför av er era smycken nu, så jag vet vad jag kan göra för er.’ ” ");
INSERT INTO swe_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Så från berget Horeb (hebr. Chorev) berget Sinai och vidare på vandringen tog Israels söner av sig (befriade de sig från) alla sina smycken. ");
INSERT INTO swe_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Och Mose tog tältet och reste det långt utanför lägret, och han kallade det ”mötestältet” (hebr. ohel moed). Var och en som ville rådfråga (söka) Herren (Jahveh) måste gå ut till mötestältet utanför lägret. Här används den hebreiska frasen ohel moed (på svenska ”mötestältet”), även kallat ”uppenbarelsetältet”. Ett annat ord är mishkan (översatt ”tabernaklet”), det hade Mose tidigare fått instruktioner om att bygga mitt i lägret (2 Mos 25). Vid detta tillfälle är det ännu inte byggt, se även 2 Mos 27:21; 3 Mos 1:1. Detta mötestält som tillhörde Mose fungerade som en temporär helgedom. ");
INSERT INTO swe_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Och när Mose gick ut (varje gång han gick) till tältet, reste sig alla upp i respekt och betraktade (studerade noggrant) Mose till dess han kommit in i tältet. Folkets förakt för Mose hade nu försvunnit, se 2 Mos 32:1, och deras respekt för honom hade återvänt. ");
INSERT INTO swe_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Varje gång Mose gick in i tältet, steg molnstoden (pelaren av rök/moln) 2 Mos 13:21-22; 14:19, 24 ned och stod vid ingången (öppningen) och han Herren talade med Mose. ");
INSERT INTO swe_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","När allt folket såg molnstoden stå vid ingången till templet, då föll allt folket ned och tillbad, var och en vid ingången till sitt tält. ");
INSERT INTO swe_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Herren (Jahveh) talade med Mose ansikte mot ansikte, som en människa talar med en vän 4 Mos 12:6-8. Sedan vände Mose tillbaka till lägret, men hans tjänare (assistent) Josua, Nuns son, en ung man, lämnade inte tältet. Mose var nu drygt 80 år, se 2 Mos 7:7. Josua, som är Moses högra hand och efterträdare, är nu troligtvis i 40-årsåldern, se Jos 1:1; 2 Mos 17:9-14; 24:13; 32:17. ");
INSERT INTO swe_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Och Mose sa till Herren (Jahveh): ”Se, du har sagt till mig: ’För upp detta folk’, och du har inte låtit mig veta vem du vill sända med mig. Och du har sagt: ’Jag känner dig vid namn och även att jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon.’ ");
INSERT INTO swe_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Därför ber (vädjar) jag till dig: Om jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon, visa mig nu dina vägar så att jag kan känna (vara intimt förtrogen med) dig till slutet (för evigt, hela vägen, fullt ut) och finner nåd (oförtjänt kärlek – hebr. chen) i dina ögon, och betänk att detta folk (denna nation – hebr. goj) är ditt folk (hebr. am).” ");
INSERT INTO swe_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Och han sa: ”Mitt ansikte (min närvaro) ska gå med dig och jag ska ge dig ro (tystnad, vila, betyder även att komma ner).” Jesus citerar denna vers, se Matt 11:28. ");
INSERT INTO swe_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Och han sa till honom: ”Om ditt ansikte (din närvaro) inte går med oss, så för oss inte upp dit. ");
INSERT INTO swe_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","För hur ska det bli känt att jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon, jag och ditt folk? Är det inte genom att du går med oss så att vi är avskilda, jag och ditt folk, från alla andra folk som finns på jordens ansikte (yta)? ");
INSERT INTO swe_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Och Herren (Jahveh) sa till Mose: ”Jag ska göra dessa ting som du har talat, för du har funnit nåd (oförtjänt kärlek – hebr. chen) i mina ögon, och jag känner dig vid namn. ");
INSERT INTO swe_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Då sa Mose: ”Låt mig få se din härlighet (närvaro, mäktiga majestät).” ");
INSERT INTO swe_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Han svarade: ”Jag ska låta min godhet (skönhet) passera inför dig och jag ska visa namnet Herren (Jahveh) inför dig. Jag ska vara nådig (ge oförtjänt favör) mot den jag vill vara nådig mot och vara barmhärtig (visa moderlig ömhet) mot den jag vill vara barmhärtig mot.” ");
INSERT INTO swe_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Han fortsatte: ”Men mitt ansikte kan du inte få se, för ingen människa kan se mig och leva.” ");
INSERT INTO swe_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sedan sa Herren: ”Här är en plats nära mig, ställ dig där på klippan. ");
INSERT INTO swe_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","När min härlighet (mäktiga närvaro) passerar dig, ska jag ställa dig i en klyfta i berget och täcka dig med min hand medan jag passerar. ");
INSERT INTO swe_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sedan ska jag ta bort min hand, och då ska du få se efterdyningarna av min närvaro ordagrant ”mina ryggar”, en metaforisk bild på efterglöden av hans närvaro, men mitt ansikte kan ingen se.” ");
INSERT INTO swe_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Herren (Jahveh) sa till Mose: ”Hugg ut två stentavlor åt dig, likadana som de första och jag ska skriva på tavlorna de ord som var på de första tavlorna som du krossade. ");
INSERT INTO swe_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Var redo på morgonen och kom upp till berget Sinai på morgonen och ställ dig på platsen högst upp på berget (ordagrant ’över bergets huvud’). ");
INSERT INTO swe_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Och ingen man ska komma upp med dig, låt inte någon man synas på hela berget, låt inte heller några flockar eller hjordar beta på berget.” ");
INSERT INTO swe_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Och han högg ut två stentavlor, likadana som de första, och Mose steg upp tidigt på morgonen och gick upp på berget Sinai som Herren (Jahveh) hade befallt honom och tog de två stentavlorna i sina händer. ");
INSERT INTO swe_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Och Herren (Jahveh) steg ned i ett moln och stod med honom där och ropade ut Herrens (Jahvehs) namn. ");
INSERT INTO swe_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Herren (Jahveh) gick förbi honom och ropade: ”Herren (Jahveh), Herren (Jahveh) är en barmhärtig och nådig Gud (El), sen till vrede och rik på nåd (omsorgsfull kärlek) och sanning (stabilitet, fasthet, trofasthet), ");
INSERT INTO swe_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","som bevarar nåd (omsorgsfull kärlek) mot tusenden i alla kommande släktled, för evigt, förlåter (lyfter upp) missgärning och överträdelse och synd. Ordet nåd (hebr. chesed) beskriver Guds nåd och trofasta kärlek. Ordet förekommer både i vers 6 och 7. Den första förekomsten beskriver Guds nåd och barmhärtighet mot Israel när han förnyar förbundet och ger dem Torah för andra gången. I vers 7 handlar det om nåd för tusenden. Det syftar på framtida släktled och även andra folk än Israel. En parallell finns i Guds löfte till Abraham i 1 Mos 12:3 där Gud lovar sin välsignelse både till honom och kommande släktled. Samma tanke finns i Joh 1:17. Nåd och sanning, hebr. chesed ve emet, hör oskiljaktigt ihop. De presenteras alltid i samma inbördes ordning (1 Mos 24:27; Ps 40:12; Ords 3:3; Ords 16:6; Jes 16:5). Nåd utan sanning blir uddlös, medan sanning utan nåd blir obarmhärtig. Samtidigt låter han inte den skyldige bli ostraffad, utan låter straffet för fädernas skuld drabba barn och barnbarn intill tredje och fjärde led.” Gud straffar inte barn och barnbarn för något som deras fäder gjort, i stället beskriver det Guds rättvisa straff för en viss synd i varje generation. Gud påminner att en generation inte kan komma undan Guds straff, eftersom Gud straffade en tidigare generation. Gud är rättvis och hans natur är både nåd och sanning, se vers 6. ");
INSERT INTO swe_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Och Mose skyndade sig och böjde sitt huvud mot marken och tillbad. ");
INSERT INTO swe_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Och han sa: ”Om jag har funnit nåd (oförtjänt kärlek – hebr. chen) i dina ögon Herre (Adonai), jag ber dig (vädjar), låt min Herre (Adonai) gå i vår mitt, för det är ett styvnackat folk, och förlåt våra överträdelser och synder, och ta oss som din arvedel.” ");
INSERT INTO swe_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Och han sa: ”Se, jag skär ett förbund, inför hela ditt folk ska jag göra under, sådana som inte har blivit gjorda i hela världen, inte i något land. Och alla de folk bland vilka du vistas, ska se Herrens (Jahvehs) gärningar som jag ska göra med dig, att de är förunderliga (fantastiska, enorma). ");
INSERT INTO swe_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Håll (vakta, skydda, bevara) det som jag befaller dig idag. Se, jag fördriver framför dig amoréerna och kanaanéerna och hettiterna och perisséerna och hivéerna och jevusiterna. ");
INSERT INTO swe_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Vakta (skydda, bevara) dig själv, så att du inte skär förbund med invånarna i landet dit du går, så att de inte blir till en snara i din mitt. ");
INSERT INTO swe_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Utan ni ska bryta ner deras altaren och slå deras obelisker i bitar och ni ska hugga ner deras aseror pålar för avgudadyrkan . ");
INSERT INTO swe_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Du ska inte falla ner för någon annan gud (hebr. el), för jag Herren (Jahveh), vars namn är Nitälskande (ett starkt känslomässigt uttryck för att vilja ha fullt ägandeskap över något – hebr. qana), är en nitälskande Gud (El), ");
INSERT INTO swe_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","för att inte skära (ingå) förbund med landets invånare och de går iväg efter andra gudar och offrar till deras gudar och de kallar på dig och du äter av deras offer, ");
INSERT INTO swe_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","och du tar deras döttrar till dina söner och deras döttrar går iväg efter deras gudar och får dina söner att gå iväg efter deras gudar. ");
INSERT INTO swe_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du ska inte göra dig några gjutna gudar. En varning mot synden med guldkalven som de nyss begått, se 2 Mos 32:4 ");
INSERT INTO swe_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Du ska hålla (vakta, skydda, bevara) det osyrade brödets högtid (hebr. chag matsah). Sju dagar ska du äta osyrat bröd som jag befallt dig, på den bestämda tiden i månaden aviv Även kallad nisan. Aviv betyder vår och anger att det är den första vårmånaden. för i månaden Aviv kom du ut ur Egypten. ");
INSERT INTO swe_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Allt som öppnar moderlivet är mitt, och av all din boskap ska du helga hanarna, det förstfödda av din oxe och får. ");
INSERT INTO swe_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Det förstfödda av en åsna ska du lösa ut med ett lamm, och om du inte vill lösa ut den ska du bryta av dess nacke. Allt förstfött av dina söner ska du lösa ut. Och ingen ska komma tomhänt inför mig. ");
INSERT INTO swe_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sex dagar ska du arbeta, men på den sjunde ska du vila, både när det är dags att plöja och när det är dags att skörda ska du vila. Sabbatsbudet gäller alltså även när vårbruket och höstbruket är som intensivast. ");
INSERT INTO swe_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Och du ska hålla (vakta, skydda, bevara) veckohögtiden (shavuot, pingst) på våren, se 2 Mos 23:16 – förstlingsfrukten av veteskörden, och även insamlingsfesten (lövhyddohögtiden, sukkot) på hösten, se 2 Mos 23:17 när året vänder (när det blir ett nytt år). Det judiska nyåret sker på rosh hashana (den första dagen i månaden tishri), strax före lövhyddohögtiden som startar den 15:e tishri. ");
INSERT INTO swe_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tre gånger om året ska alla dina män komma inför (framför ansiktet på) Herren Herren (Adonai Jahveh), Israels Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","För jag ska fördriva folkslag framför dig, och utvidga dina gränser, inte heller ska någon man ha åtrå till ditt land när du går upp till Herren (Adonai) din Gud (Elohim) tre gånger om året. Detta är Guds löfte om beskydd att ingen fiende ska anfalla när man firar Herrens (Jahvehs) högtider! ");
INSERT INTO swe_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du ska inte offra blodet av mina offer med syrat bröd. Inte heller ska något av offren som hör till påsken lämnas kvar till morgonen. Profetiskt om Jesus som togs ner från korset samma dag. ");
INSERT INTO swe_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Den utvalda förstlingsfrukten från ditt land ska du föra fram till Herren (Adonai) din Guds (Elohims) hus. Du ska inte koka en killing i dess mors mjölk.” Frasen upprepas från 2 Mos 23:19 och återkommer i 5 Mos 14:21. Rabbinska tolkningar av detta bud har lett till dagens kosherlagar för mat. ");
INSERT INTO swe_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Herren sa till Mose: ”Skriv ned dessa ord (befallningar), för i enlighet med dem har jag slutit ett förbund med dig och med Israel.” ");
INSERT INTO swe_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose var kvar hos Herren i fyrtio dagar och fyrtio nätter, utan att äta eller dricka. Han skrev förbundsorden, de tio orden, på stentavlorna. ");
INSERT INTO swe_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","När Mose kom ner från Sinai berg med vittnesbördets två stentavlor i sin hand, visste han inte om att hans ansiktes hy strålade (att ljus sköt fram som horn), därför att han hade talat med Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","När Aron och alla israeliterna såg strålglansen från Moses ansiktes hy, vågade de inte komma emot honom. ");
INSERT INTO swe_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Men Mose ropade till dem, och Aron och alla folkets ledare vände tillbaka till honom, och Mose talade till dem. ");
INSERT INTO swe_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sedan kom alla israeliterna fram till honom, och han befallde dem allt som Herren (Jahveh) hade talat på Sinai berg. ");
INSERT INTO swe_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","När Mose hade talat klart med dem hängde han en slöja för ansiktet. ");
INSERT INTO swe_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Men när Mose trädde fram inför Herrens ansikte för att tala med honom, tog han av sig slöjan till dess han gick ut igen. När han kom ut, talade han till israeliterna det som han fått befallning om. ");
INSERT INTO swe_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israeliterna såg Moses ansiktes hy, hur den strålade, så Mose hängde slöjan över ansiktet igen till dess han gick in för att tala med Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Och Mose samlade hela församlingen av Israels söner och sa till dem: ”Detta är orden som Herren (Jahveh) har befallt för att ni ska göra dem. ");
INSERT INTO swe_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sex dagar ska arbete göras men den sjunde dagen ska för er vara en helig dag, en sabbat med fullkomlig vila (hebr. shabbat shabbaton) till Herren (Jahveh). Den som gör något arbete (den dagen) ska dödas. ");
INSERT INTO swe_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ni ska inte tända någon eld i alla era boplatser på sabbatsdagen.” ");
INSERT INTO swe_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Och Mose talade till hela församlingen med Israels söner och sa: ”Detta är de ord som Herren (Jahveh) har befallt och säger: ");
INSERT INTO swe_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ta ibland er ett offer till Herren (Jahveh), alla som har ett villigt hjärta låt honom föra fram det, ett Herrens (Jahvehs) offer, guld och silver och brons, ");
INSERT INTO swe_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","och blått och purpur och scharlakansrött och fint linne och gethår, ");
INSERT INTO swe_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","och rödfärgat getskinn, och sälskinn och akaciaträ, ");
INSERT INTO swe_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","och olja till lampan och kryddor till smörjelseoljan och till den söta rökelsen, ");
INSERT INTO swe_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","och onyxstenar och stenar till infattning, till efoden och till bröstskölden. ");
INSERT INTO swe_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Och låt varje man med ett vist hjärta ibland er komma och göra (tillverka) allt det som Herren (Jahveh) har befallt, ");
INSERT INTO swe_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Tabernaklet, dess tält och dess överdrag, dess spännen och dess brädor, dess tvärstänger, dess stolpar och dess socklar, ");
INSERT INTO swe_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","arken och stängerna till den, locket (nådastolen, det som täcker arken) och draperiet (förhänget) till avskärmningen, ");
INSERT INTO swe_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","bordet och dess stänger och alla dess tillbehör och skådebröden, ");
INSERT INTO swe_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","menoran – ljusbäraren den sjuarmade ljusstaken, se 2 Mos 25:31-40 och dess redskap och dess lampor och olja till ljusbäraren, ");
INSERT INTO swe_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","och rökelsealtaret och dess stänger och smörjelseoljan och den söta rökelsen och draperiet (förhänget) till öppningen, till tabernaklets öppning, ");
INSERT INTO swe_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","brännofferaltaret med dess galler av brons, dess stänger och alla dess redskap, vattenkaret och dess fundament, ");
INSERT INTO swe_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","gårdens våder, dess stolpar och dess socklar och draperiet (förhänget) till gårdens öppning, ");
INSERT INTO swe_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tabernaklets tältpluggar och gårdens tältpluggar och dess linor, ");
INSERT INTO swe_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","de broderade kläderna för tjänstgöring på den heliga platsen, de heliga kläderna till prästen Aron och kläderna till hans söner för att göra tjänst i prästämbetet.” I vers 14 står det ordagrant: ljusbäraren menoran. Detta kan vara ett sätt att betona att det är denna specifika ljushållare som är sjuarmad. Ordet ljushållare (hebr. maor) är en generell term för en ljusbärare som kan vara allt möjligt som bär och sprider ljus, används om t.ex. solen och månen, se 1 Mos 1:14-16. ");
INSERT INTO swe_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Och hela församlingen, Israels söner, lämnade (ordagrant: ”gick bort från framför”) Mose. ");
INSERT INTO swe_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Och de kom, alla vars hjärta uppmuntrade honom, och alla vars ande gjort honom villig, och förde fram Herrens (Jahvehs) offer till arbetet med mötestältet och för all dess tjänstgöring och till de heliga kläderna. ");
INSERT INTO swe_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Och de kom, både män och kvinnor, så många som hade ett villigt hjärta och bar fram näsringar och örhängen och signetringar och gördlar, alla (slags) juveler av guld, och alla män förde fram ett offer av guld till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Och alla män hos vilka man fann blått och purpur och scharlakansrött och fint linne och gethår och rödfärgat getskinn och sälskinn, förde fram dem. ");
INSERT INTO swe_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Alla som kunde bidra med ett offer av silver eller brons förde fram Herrens (Jahvehs) offer, och alla män som hade akaciaträ till något av arbetet förde fram det. ");
INSERT INTO swe_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Och alla kvinnor som hade visa hjärtan spann med sina händer och förde fram det som de hade spunnit, blått och purpur, scharlakansrött och fint linne. Det står inte tyg eller garn i grundtexten men dessa färger syftar på det garn som kan användas till vävning. ");
INSERT INTO swe_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Och alla kvinnor vars hjärta uppmuntrade dem med vishet spann gethår. ");
INSERT INTO swe_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Och ledarna förde fram onyxstenar och stenar till infattning till efoden och till bröstskölden, ");
INSERT INTO swe_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","och kryddor och olja till ljusbäraren (ljusstaken) och till smörjelseolja och till den söta rökelsen. ");
INSERT INTO swe_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israels barn (söner) förde fram ett frivilligt offer till Herren (Jahveh), varje man och kvinna vars hjärta hade gjort dem villiga att bidra till allt arbete som Herren (Jahveh) befallt skulle göras genom Moses hand. ");
INSERT INTO swe_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Och Mose sa till Israels söner: ”Se, Herren (Jahveh) har kallat Betsalel, Oris son, Hurs (hebr. Chor) son av Juda stam, vid namn, ");
INSERT INTO swe_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","och han har fyllt honom med Guds Ande i vishet, i förståelse och i kunskap och i allt slags hantverkskunskap, ");
INSERT INTO swe_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","och till att utföra konstfullt arbete, att arbeta i (med) guld och i (med) silver och i (med) brons, ");
INSERT INTO swe_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","och att slipa stenar för infattning, och att snida i trä, till att arbeta i alla slags konstfulla tekniker. ");
INSERT INTO swe_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Och han har lagt i hans hjärta att han ska undervisa, både honom och Oholiav, Achisamachs son från Dans stam. ");
INSERT INTO swe_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Dem har han fyllt med hjärtats vishet till att utföra allt slags hantverk, gravyr och flätning och vävning med färger, i blått och i purpur, i scharlakansrött och i fint linne och vävning, till att göra allt slags konstfullt hantverk.” ");
INSERT INTO swe_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Mose talade vidare: ”Och Betsalel och Oholiav ska arbeta och varje man med ett vist hjärta i vilken Herren (Jahveh) har lagt vishet och förståelse till att veta hur man gör allt arbete för tjänsten i helgedomen enligt allt som Herren (Jahveh) har befallt.” ");
INSERT INTO swe_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Och Mose kallade på Betsalel och Oholiav och alla män med ett vist hjärta, i vars hjärta Herren (Jahveh) har lagt vishet, alla vars hjärta manade honom att komma till arbetet och utföra det. ");
INSERT INTO swe_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Och de tog av Mose emot hela offret som Israels söner hade burit fram till arbetet för tjänsten i helgedomen, det (materialet) som det skulle tillverkas av. Och de bar fortfarande fram frivilliga gåvor till honom varje morgon. ");
INSERT INTO swe_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Och alla visa män som utförde allt arbete på helgedomen, kom var man från sitt arbete som han utförde, ");
INSERT INTO swe_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","och de talade till Mose och sa: ”Folket för fram mycket mer än nog för det som behövs till arbetet som Herren (Jahveh) har befallt att göra.” ");
INSERT INTO swe_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Och Mose befallde att man skulle kungöra i lägret och säga: ”Varken man eller kvinna ska göra något mer arbete för offret till helgedomen.” Så hindrades folket från att föra fram mer. ");
INSERT INTO swe_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","För materialet som de hade var tillräckligt till allt arbete för tillverkningen och alldeles för mycket. ");
INSERT INTO swe_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Och varje man med ett vist hjärta bland dem som utförde arbetet gjorde tabernaklet med 10 våder av fint tvinnat linne och blått och purpur och scharlakansrött med keruber, ett arbete gjort av en skicklig yrkesman. ");
INSERT INTO swe_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Längden på varje våd var 28 alnar 12,6 meter och bredden på varje våd var 4 alnar 1,8 meter. Alla våder hade ett (samma) mått. ");
INSERT INTO swe_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Och han Betsalel kopplade ihop 5 våder en till en och de andra 5 våderna kopplade han en till en. Verben är i maskulin singular vilket kan syfta på Betsalel, se vers 1. En annan tolkning är att det är ”var man”. ");
INSERT INTO swe_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Och han gjorde öglor av blått på kanten av den yttersta våden i det första hopfogade stycket, på samma sätt gjorde han på den yttersta våden i det andra hopfogade stycket. ");
INSERT INTO swe_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","50 öglor gjorde han på en våd och 50 öglor gjorde han på kanten av våden som var på det andra hopfogade stycket, öglorna var mittemot varandra. ");
INSERT INTO swe_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Och han gjorde 50 hyskor av guld och kopplade ihop våderna den ena till den andra med hyskorna så att tabernaklet blev en enhet. ");
INSERT INTO swe_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Och han gjorde våder av gethår till ett tält över tabernaklet, han gjorde 11 våder. ");
INSERT INTO swe_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Längden på varje våd var 30 alnar 13,5 meter, och 4 alnar 1,8 meter var bredden på varje våd, de 11 våderna hade ett (samma) mått. ");
INSERT INTO swe_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Och han Betsalel kopplade 5 våder med varandra och 6 våder med varandra. ");
INSERT INTO swe_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Och han gjorde 50 öglor på kanten av den yttersta våden i det första hopfogade stycket och 50 öglor gjorde han på kanten av våden som var ytterst på det andra hopfogade stycket. ");
INSERT INTO swe_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Och han gjorde 50 hyskor av brons för att koppla ihop tältet så att det blev en enhet. ");
INSERT INTO swe_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Och han gjorde ett överdrag till tältet av rödfärgat getskinn och ett täcke av sälskinn ovanpå. ");
INSERT INTO swe_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Och han gjorde brädorna till tabernaklet av akaciaträ som stod upprätt. ");
INSERT INTO swe_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","10 alnar 4,5 meter var längden på en bräda och 1,5 aln 0,7 meter var bredden på varje bräda. ");
INSERT INTO swe_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Varje bräda hade två tappar sammanfogade med varandra. Dessa gjorde han till tabernaklets alla brädor. ");
INSERT INTO swe_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Och han gjorde brädorna till tabernaklet, 20 brädor för den södra sidan söderut. ");
INSERT INTO swe_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Och han gjorde 40 socklar av silver under de 20 brädorna. Två socklar under en bräda för dess två tappar och två socklar under nästa bräda för dess två tappar. ");
INSERT INTO swe_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Och till den andra sidan av tabernaklet, på den norra sidan, gjorde han 20 brädor, ");
INSERT INTO swe_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","och deras 40 socklar av silver, två socklar under en bräda och två socklar under nästa bräda. ");
INSERT INTO swe_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Och till den bakre delen av tabernaklet västerut gjorde han 6 brädor. ");
INSERT INTO swe_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Och 2 brädor gjorde han till tabernaklets hörn i den bakre delen, ");
INSERT INTO swe_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","så att de var dubbla undertill och på samma sätt skulle de vara hela vägen upp till dess topp, till den första ringen. Så gjorde han med dem båda i de två hörnen. ");
INSERT INTO swe_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Och där var 8 brädor och deras socklar av silver, 16 socklar, 2 socklar under varje bräda. ");
INSERT INTO swe_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Och han gjorde tvärstänger av akaciaträ, 5 till brädorna på den ena sidan av tabernaklet, ");
INSERT INTO swe_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","och 5 tvärstänger till brädorna på den andra sidan av tabernaklet och 5 stänger till tabernaklets brädor i den bakre delen västerut. ");
INSERT INTO swe_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Och han gjorde den mittersta tvärstången till att gå igenom mitt i brädorna från den ena sidan till den andra. ");
INSERT INTO swe_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Och han pläterade brädorna med guld och gjorde deras ringar av guld, som handtag för stängerna och pläterade stängerna med guld. ");
INSERT INTO swe_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Och han gjorde draperiet (förhänget) av blått och purpur och scharlakansrött och fint tvinnat linne, arbetet av en skicklig yrkesman, med keruber. ");
INSERT INTO swe_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Och han gjorde till detta 4 stolpar av akaciaträ och pläterade dem med guld, deras krokar (hakar) gjordes av guld och han göt 4 socklar till dem av silver. ");
INSERT INTO swe_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Och han gjorde ett draperi (förhänge) till tältets öppning av blått och purpur och scharlakansrött och fint tvinnat linne, en vävares arbete i färger, ");
INSERT INTO swe_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","och de 5 stolparna till det med deras krokar, och han pläterade brädornas huvuden och deras dekor med guld, och deras 5 socklar var av brons. ");
INSERT INTO swe_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Och Betsalel gjorde arken av akaciaträ, 2,5 alnar 1,1 meter var dess längd och 1,5 aln 0,7 meter var dess bredd och 1,5 aln 0,7 meter var dess höjd. ");
INSERT INTO swe_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Och han pläterade den med rent guld på insidan och utsidan och gjorde en krona av guld till den runtom. ");
INSERT INTO swe_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Och han göt 4 ringar av guld till den, till dess 4 fötter, 2 ringar på ena sidan och 2 ringar på andra sidan. ");
INSERT INTO swe_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Och han gjorde stänger av akaciaträ och pläterade dem med guld . ");
INSERT INTO swe_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Och han satte stängerna i ringarna på sidorna av arken för att bära arken. ");
INSERT INTO swe_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Och han gjorde ett lock av rent guld, 2,5 alnar 1,1 meter var dess längd och 1,5 aln 0,7 meter var dess bredd. ");
INSERT INTO swe_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Och han gjorde två keruber av guld, av drivet arbete gjorde han dem vid de två ändarna av locket, ");
INSERT INTO swe_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","en kerub i den ena änden och en kerub i den andra änden. I ett stycke med locket gjorde han keruberna på dess två ändar. ");
INSERT INTO swe_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Och keruberna spred ut sina vingar på höjden, så att de täckte locket med sina vingar. Med ansikte vända mot varandra var kerubernas ansikten också vända mot locket. ");
INSERT INTO swe_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Och han gjorde bordet av akaciaträ, 2 alnar var dess längd och 1 aln var dess bredd och 1,5 aln var dess höjd. ");
INSERT INTO swe_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Och han pläterade det med rent guld och gjorde en krona av guld till det runtom. ");
INSERT INTO swe_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Och han gjorde en handsbred 8-9 cm bred kant till det runtom och gjorde en krona av guld på kanten runtom. ");
INSERT INTO swe_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Och han göt 4 ringar av guld till det, och satte ringarna i de 4 hörnen som var på dess 4 fötter. ");
INSERT INTO swe_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ringarna satt nära bordet, hållare till stängerna för att bära bordet. ");
INSERT INTO swe_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Och han gjorde stänger av akaciaträ och pläterade dem med guld för att bära bordet. ");
INSERT INTO swe_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Och han gjorde redskapen som var på bordet, dess fat, dess krukor, dess skålar och dess kannor som används till att hälla ut (utgjutande), av rent guld. ");
INSERT INTO swe_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Och han gjorde menoran den sjuarmade ljusstaken av rent guld. I drivet arbete gjorde han menoran med sin fot och sin stjälk, dess skålar, dess knoppar och dess blommor, allt var gjort i ett stycke. ");
INSERT INTO swe_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Och 6 grenar gick ut från dess sidor, 3 av menorans grenar gick ut på dess ena sida och 3 av menorans grenar gick ut på dess andra sida. ");
INSERT INTO swe_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","3 skålar gjorda som en mandelblomma på en gren, en knopp och en blomma, och 3 skålar gjorda som en mandelblomma på den andra grenen, en knopp och en blomma. Så var det på de 6 grenarna som gick ut från menoran. ");
INSERT INTO swe_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Och på menoran var 4 skålar som var gjorda som en mandelblomma, dess knoppar och dess blommor, ");
INSERT INTO swe_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","och en knopp under 2 grenar i ett stycke med den, och en knopp under 2 grenar i ett stycke med den, och en knopp under 2 grenar i ett stycke med den, på de 6 grenarna som gick ut från den. ");
INSERT INTO swe_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Dess knoppar och dess grenar var gjorda i ett stycke med den. Det var gjort i ett stycke, hamrat arbete i rent guld. ");
INSERT INTO swe_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Och han gjorde dess lampor, 7 stycken, och dess tänger och dess vektrimmare av rent guld. ");
INSERT INTO swe_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Av en talent (hebr. kikar) 34 kilo, se 2 Mos 25:39 rent guld tillverkade han den och alla dess redskap. ");
INSERT INTO swe_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Och han gjorde rökelsealtaret av akaciaträ, 1 aln var dess längd och 1 aln var dess bredd 45 x 45 cm, kvadratiskt, och 2 alnar 90 cm var dess höjd, dess horn var gjorda i ett stycke med det. ");
INSERT INTO swe_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Och han pläterade det med rent guld, dess ovansida och dess sidor runtom och hornen på det. Och han gjorde en krona av guld runtom. ");
INSERT INTO swe_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Och han gjorde till det 2 guldringar under dess krona, på dess två sidor, som hållare för stängerna som det ska bäras med. ");
INSERT INTO swe_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Och han gjorde stängerna av akaciaträ och pläterade dem med guld. ");
INSERT INTO swe_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Och han gjorde den heliga smörjelseoljan och den rena rökelsen av söta kryddor, som en parfymörs hantverk. ");
INSERT INTO swe_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Och han gjorde brännofferaltaret av akaciaträ, 5 alnar var dess längd och 5 alnar var dess bredd 2,25 x 2,25 meter, kvadratiskt, och 3 alnar 1,35 meter var dess höjd. ");
INSERT INTO swe_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Och han gjorde dess horn på dess 4 hörn, dess horn var gjorda i ett stycke med det, och han pläterade det med brons. ");
INSERT INTO swe_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Och han gjorde alla altarets redskap, kärlen och skovlarna och faten och köttkrokarna och fyrfaten, alla dess redskap gjorde han av brons. ");
INSERT INTO swe_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Och till altaret gjorde han ett galler av brons, under avsatsen runtom så att det nådde halvvägs upp. ");
INSERT INTO swe_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Och han gjorde 4 ringar för de 4 hörnen av bronsgallret, som hållare för stängerna. ");
INSERT INTO swe_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Och han gjorde stänger av akaciaträ och pläterade dem med brons. ");
INSERT INTO swe_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Och han satte stängerna i ringarna på altarets sidor, för att bära det, han gjorde det ihåligt med plankor. ");
INSERT INTO swe_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Och han gjorde vattenkaret av brons och dess fundament av brons, av speglarna från de kvinnor som gjorde tjänst vid mötestältets öppning. ");
INSERT INTO swe_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Och han gjorde gården. För södra sidan söderut var gårdens våder gjorda av fint tvinnat linne 100 alnar 45 meter. ");
INSERT INTO swe_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Och stolparna var 20 stycken och deras socklar var 20 stycken av brons, krokarna på stolparna och deras hyskor var av silver. ");
INSERT INTO swe_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Och för den norra sidan 100 alnar 45 meter, dess stolpar 20 stycken, och dess socklar 20 stycken av brons, krokarna och dess hyskor var av silver. ");
INSERT INTO swe_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Och till västra sidan var våderna 50 alnar 22,5 meter, dess pelare 10 och dess socklar 10, stolparnas krokar och dess hyskor var av silver. ");
INSERT INTO swe_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Och för den östra sidan 50 alnar 22,5 meter. ");
INSERT INTO swe_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Våderna på den ena sidan var 15 alnar 7 meter, dess 3 stolpar och dess 3 socklar. ");
INSERT INTO swe_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Och för den andra sidan likadant, på den ena sidan och på den andra sidan om porten var våderna 15 alnar 7 meter, dess 3 stolpar och dess 3 socklar. ");
INSERT INTO swe_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alla våder till gården runtom var av fint tvinnat linne. ");
INSERT INTO swe_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Och socklarna till pelarna var av brons, pelarnas krokar och deras hyskor var av silver, och överdraget på pelarhuvudena var av silver, och alla gårdens stolpar var dekorerade med silver. ");
INSERT INTO swe_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Och förhänget till gårdens port var en vävares arbete i färger, av blått och purpur och scharlakansrött och fint tvinnat linne. Och 20 alnar 9 meter var dess längd och höjden var 5 alnar 2,25 meter, samma storlek som gårdens våder. ");
INSERT INTO swe_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Och dess pelare var 4 stycken och dess socklar 4 stycken, av brons. Dess krokar av silver och överdraget på pelarhuvudena och dekorationerna av silver. ");
INSERT INTO swe_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Och alla tabernaklets tältpluggar och gårdens runtom var av brons. Detta är det centrala stycket i kapitel 34-40. ");
INSERT INTO swe_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Detta är redovisningen (inventeringen, räkningen – hebr. pekodim) en summering, inspektion och förteckning av allt material som använts för tabernaklet – vittnesbördets tabernakel tabernaklet där vittnesbördets tavlor (de tio budorden) förvarades, se 2 Mos 20. Mose gav leviterna detta uppdrag (påbud) att göra denna redovisning under överseende (under handen) av Itamar, prästen Arons son. ");
INSERT INTO swe_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betsalel, Oris son, Chors son av Juda stam, gjorde allt det som Herren (Jahveh) hade befallt Mose enligt instruktionerna, se 2 Mos 25-30. ");
INSERT INTO swe_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Och med honom var Oholiav, Achisamachs son från Dans stam, en hantverkare och en skicklig yrkesman och en vävare med färger, i blått och i purpur och i scharlakansrött och fint linne. Det var leviterna som ansvarade för att sätta upp, ta ner och transportera tabernaklet under ökenfärden, se 4 Mos 3-4. Genom att på nytt även nämna Betsalel (2 Mos 31:2; 35:30; 36:1-2; 37:1) och Oholiav (2 Mos 31:6; 35:34; 36:1-2) och att de var från Juda och Dans stam, blir det en påminnelse att tabernaklet var ett projekt som involverade hela folket. I följande verser blir det också tydligt att hantverkare från olika stammar hade arbetat tillsammans. ");
INSERT INTO swe_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Allt guld som användes till arbetet i hela arbetet med helgedomen, även guldet till offret var 29 talenter och 730 shekel motsvarar 1/4 talent, efter helgedomens vikt motsvarar 1 ton – 80 guldtackor som väger 12,5 kg. Uttrycket ”helgedomens vikt” var antagligen en standardvikt som användes i mätvågen. Talenten (hebr. kikar) var den största viktenheten vid den här tiden. En talent motsvarade 3 000 shekel (hebr. sheqel), som var en viktenhet på 11,5 gram. Totala mängden guld här var alltså (29 x 3000 + 730) 87 730 shekel – motsvarar 1009 kg. ");
INSERT INTO swe_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Och silvret från dem som var räknade i församlingen var 100 talenter 3,45 ton och 1 775 shekel 20 kg, efter helgedomens vikt totalt 301 775 shekel – motsvarar 3,5 ton. ");
INSERT INTO swe_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","En beka silvermynt på 5,8 gram per huvud, det är en halv shekel efter helgedomens vikt, för varje som gick över till dem som är räknade, från 20 års ålder och uppåt, 603 550 män. Antalet är exakt samma som vid folkräkningen i 4 Mos 1:46. ");
INSERT INTO swe_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","De 100 talenterna silver den största delen användes till att gjuta helgedomens socklar och socklarna till draperiet (förhänget), 100 socklar av 100 talenter, 1 talent 34 kg för varje sockel. ");
INSERT INTO swe_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Av de återstående 1 775 sheklarna 20 kg silver gjorde han krokar till stolparna och pläterringar till deras huvuden och deras dekorationer. ");
INSERT INTO swe_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Och bronset från viftoffret (det som hade donerats vid viftoffret – hebr. tenofah) var 70 talenter och 2 400 shekel 212 400 shekel – motsvarar 2,4 ton. ");
INSERT INTO swe_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Med det gjorde han socklarna till mötestältets öppning och bronsaltaret och dess galler av brons och altarets alla redskap, ");
INSERT INTO swe_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","och socklarna till gården runtom, och alla tabernaklets tältpluggar och hela gårdens tältpluggar runtom. ");
INSERT INTO swe_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Och från blått och purpur och scharlakansrött gjorde de broderade kläder för tjänst i det heliga och gjorde heliga kläder till Aron som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Och han Betsalel, se 2 Mos 38:22 gjorde efoden av guld, blått och purpur och scharlakansrött och fint tvinnat linne. ");
INSERT INTO swe_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Och de hantverkarna eller specifikt Betsalel och Oholiav, se 2 Mos 36:1-2; 38:23 hamrade ut guldet till tunna plattor och skar det till trådar (tunna guldtrådar – hebr. patil) för att arbeta in det i det blå garnet och i det purpurfärgade garnet och i det scharlakansröda garnet och i det fina linnet, en skicklig hantverkares arbete. ");
INSERT INTO swe_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","De gjorde axelstycken för den, sammanfogade, i de två ändarna var den sammanfogad. ");
INSERT INTO swe_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Och de skickligt vävda banden som var på den, som man fäster den med, var av samma stycke och likadant arbete, av guld, av blått och purpur och scharlakansrött och fint tvinnat linne, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Och de bearbetade onyxstenarna och infattade dem i guld och graverade dem som man gör med en signetring, efter namnen på Israels söner. ");
INSERT INTO swe_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Och han satte dem på efodens axelstycken, för att vara minnesstenar till Israels söner, som Herren (Jahveh) befallt Mose. Vers 8-21 är en repris av 2 Mos 28:15-28 nästan ordagrant, förutom lite verbformer och vers 16 (jfr med 2 Mos 28:23) som nämner de två infattningar av guld och avslutningen i vers 21 som nämner ”som Herren befallt Mose”. ");
INSERT INTO swe_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Och han gjorde bröstskölden, en skicklig hantverkares arbete, på samma sätt som arbetet med efoden, av guld, av blått och purpur och scharlakansrött och fint tvinnat linne. ");
INSERT INTO swe_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Den var kvadratisk, de gjorde bröstskölden dubbel, en spann var dess längd och en spann var dess bredd 23 x 23 cm, dubbel. ");
INSERT INTO swe_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Och de satte på den fyra rader med stenar. En rad med 1 karneol röd sten – hebr. odem, 2 topas olivgrön, gulaktig 3 och smaragd hebr. bareqet (från baraq att glittra, reflektera); ordet används bara här och i 2 Mos 28:17, den första raden. ");
INSERT INTO swe_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Och den andra raden, 4 en karbunkel, 5 en safir ”en blå sten”; himmelsblå 6 och en kalcedon. ");
INSERT INTO swe_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Och den tredje raden, 7 en hyacint mörkröd, lila – hebr. leshem förekommer bara här och i 2 Mos 28:19, 8 en agat hebr. shevo förekommer bara här och i 2 Mos 28:19 9 och en ametist purpur och violett – hebr. achlama förekommer bara här och i 2 Mos 28:19. ");
INSERT INTO swe_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Och den fjärde raden, 10 en krysolit hebr. tarsis, troligtvis från staden Tarshish, kanske importerad från avlägset håll, 11 en onyx hebr. shoham; troligtvis från ordet att bleka 12 och en jaspis hebr. jashfe; från ordet att polera; under antiken användes ordet främst för gröna (delvis genomskinliga) stenar, men idag används termen även för andra färger. I Johannes syn ser han den sista och första ädelstenen i översteprästens bröstsköld, se Upp 4:3. Jaspis, den sista stenen, är också den första grundstenen i det nya Jerusalems stadsmur, se Upp 21:18-20. De var ditsatta med infattningar av guld. ");
INSERT INTO swe_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Och stenarna var, efter namnen på Israels söner, tolv till antalet, efter deras namn, graverade som en signetring, var och en med sitt namn för de tolv stammarna. ");
INSERT INTO swe_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Och de gjorde på bröstskölden flätade kedjor, ett kransarbete av rent guld. ");
INSERT INTO swe_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Och de gjorde två infattningar av guld och två guldringar och satte de två ringarna på de två sidorna av bröstskölden. ");
INSERT INTO swe_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Och de satte de två flätade kedjorna av guld på de två ringarna på bröstsköldens sidor. ");
INSERT INTO swe_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Och de två andra ändarna på de två tvinnade kedjorna satte de på de två infattningarna och satte dem på efodens två axelstycken, på dess främre del. ");
INSERT INTO swe_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Och de gjorde två ringar av guld och satte dem på de två ändarna av bröstskölden, på dess kant som var vända mot sidan på efodens insida. ");
INSERT INTO swe_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Och de gjorde två ringar av guld och satte dem på efodens två axelstycken undertill, i dess framkant, nära dess sammankoppling ovanför efodens skickligt vävda band. ");
INSERT INTO swe_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Och de band fast bröstskölden med dess ringar till efodens ringar med en blå snodd (flätad tråd), så att den ska vara på efodens skickligt vävda band, så att bröstskölden inte lossnar från efoden, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Och han gjorde efodens rock (ämbetsdräkt) av vävt arbete, helt i blått. ");
INSERT INTO swe_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Och hålet i rockens mitt som hålet på en pansarskjorta, med en snörning runt dess hål, så att det inte kan repas upp. Hålet är tänkt för att man ska kunna trä den över huvudet när man tar den av och på sig. Den är gjord i ett stycke och saknar alltså knäppning. Den blir som en hellång poncho. ");
INSERT INTO swe_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Och på fållen längst ner på den blå klädnaden, se vers 22 gjorde de granatäpplen av blått och purpur och scharlakansrött och tvinnat linne. ");
INSERT INTO swe_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Och de gjorde klockor (bjällror) av rent guld och satte klockorna mellan granatäpplena runt klädnadens fåll nertill, mellan granatäpplena, ");
INSERT INTO swe_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","en klocka och ett granatäpple, en klocka och ett granatäpple runt klädnadens fåll, till ämbetsdräkt, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Och de gjorde tunikor av fint linne, av vävt arbete, till Aron och till hans söner. ");
INSERT INTO swe_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Och turbaner av fint linne och bekväma huvudbonader av fint linne och byxor av fint tvinnat linne, ");
INSERT INTO swe_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","och gördeln av fint tvinnat linne och blått och purpur och scharlakansrött, en vävares arbete i färger, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Och de gjorde den heliga plattan, en krona av rent guld och skrev en text på den som man graverar en signetring: ”Helgad till Herren (Jahveh).” ");
INSERT INTO swe_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Och de knöt en blå snodd (flätad tråd) i den för att fästa den ovanpå turbanen, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Så avslutades allt arbete med mötestältets tabernakel och Israels söner gjorde allt i enlighet med det som Herren (Jahveh) befallt Mose, så gjorde de. ");
INSERT INTO swe_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Och de förde tabernaklet till Mose: Tältet och alla dess möbler, dess spännen, dess brädor, dess tvärstänger och dess stolpar och dess socklar, ");
INSERT INTO swe_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","och överdraget av rödfärgat getskinn och överdraget av sälskinn och avskärmningens draperi (förhänge), ");
INSERT INTO swe_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","vittnesbördets ark med dess stänger och locket (nådastolen), ");
INSERT INTO swe_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","bordet och alla dess redskap och skådebröden, ");
INSERT INTO swe_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","den rena menoran syftar både på att den sjuarmade ljusstaken är rituellt ren – hebr. tahar, men också på att den är tillverkad av enbart rent guld, dess lampor, lamporna som ska sättas i ordning och oljan till ljusbäraren (ljusstaken) ");
INSERT INTO swe_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","och guldaltaret och smörjelseoljan och den söta rökelsen och förhänget till tältets öppning, ");
INSERT INTO swe_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bronsaltaret och dess galler av brons, dess stänger och alla dess redskap, vattenkaret och dess fundament, ");
INSERT INTO swe_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","gårdens våder, dess stolpar och dess socklar och förhänget till gårdens öppning, dess linor och dess tältpluggar och alla redskap till tjänstgöringen i mötestältets tabernakel, ");
INSERT INTO swe_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","de broderade kläderna för tjänstgöring på den heliga platsen, de heliga kläderna till prästen Aron och kläderna till hans söner för att tjänstgöra i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","I enlighet med allt det som Herren (Jahveh) befallt Mose, så gjorde Israels söner hela arbetet. ");
INSERT INTO swe_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Och Mose såg allt arbete, och se, de hade gjort det som Herren (Jahveh) hade befallt, precis så hade de gjort det. Och Mose välsignade dem. Herren var mycket noggrann med att allt skulle göras exakt efter ritningarna och mönstren som Mose hade fått när han var uppe på berget Sinai, se 2 Mos 25:9, 40 m.fl. ");
INSERT INTO swe_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","”På den första dagen i den första månaden aviv/nisan ska du sätta upp mötestältets tabernakel. ");
INSERT INTO swe_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Där ska du ställa in vittnesbördets ark och du ska skärma av (dölja) arken med förhänget (draperiet). ");
INSERT INTO swe_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Du ska föra in bordet och lägga i ordning brödet på det, och du ska föra in menoran den sjuarmade ljusstaken och tända dess lampor. ");
INSERT INTO swe_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Du ska ställa altaret av guld, för rökelse, framför vittnesbördets ark och sätta upp öppningens förhänge (draperi) till tabernaklet. ");
INSERT INTO swe_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Du ska ställa brännofferaltaret framför öppningen till mötestältets tabernakel. ");
INSERT INTO swe_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Du ska ställa vattenkaret mellan mötestältet och altaret och hälla vatten i det. ");
INSERT INTO swe_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Du ska sätta upp inhägnaden runtomkring och hänga upp förhänget (draperiet) i inhägnadens port. ");
INSERT INTO swe_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Du ska ta smörjelseoljan och smörja tabernaklet och allt som är i det och ska helga (avskilja) det och alla dess möbler, och det ska vara heligt. ");
INSERT INTO swe_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Du ska smörja brännofferaltaret och alla dess redskap och helga altaret och altaret ska vara högheligt. ");
INSERT INTO swe_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Du ska smörja vattenkaret och dess fundament och helga det. ");
INSERT INTO swe_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Du ska föra Aron och hans söner till mötestältets dörr och tvätta dem med vatten. ");
INSERT INTO swe_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Du ska sätta på Aron de heliga kläderna och du ska smörja honom och helga honom så att han kan betjäna mig i prästämbetet. ");
INSERT INTO swe_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Du ska föra fram hans söner och sätta på dem prästkläder. ");
INSERT INTO swe_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Du ska smörja dem som du smorde deras far så att de kan göra tjänst för mig i prästämbetet. Och deras smörjelse ska för dem vara ett evigt prästerskap genom deras generationer.” ");
INSERT INTO swe_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Och Mose gjorde i enlighet med allt som Herren (Jahveh) befallt honom, så gjorde han. ");
INSERT INTO swe_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Och det skedde i den första månaden Aviv, på det andra året efter uttåget ur Egypten på den första dagen i månaden, att tabernaklet restes. Det är denna månad den 14:e dagen som Peasch firas följt av det osyrade brödets högtid den 15:e dagen och sju dagar. ");
INSERT INTO swe_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose reste tabernaklet och lade dess socklar och satte upp brädorna på dem och satte dit tvärstängerna och reste upp dess stolpar. ");
INSERT INTO swe_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Han bredde ut tältet över tabernaklet och lade tältets överdrag ovanpå det, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Han tog och lade vittnesbördet i arken och satte stängerna på arken och lade arkens täckning (nådastolen, locket) ovanpå arken. ");
INSERT INTO swe_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sedan förde han in arken i tabernaklet och satte upp förhänget (draperiet) och skärmade av vittnesbördets ark, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Han satte bordet i mötestältet på sidan i tabernaklet norrut, utanför förhänget ");
INSERT INTO swe_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","och gjorde i ordning en rad med bröd på det inför Herrens (Jahvehs) ansikte, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Han Mose ställde ljusstaken i mötestältet mittemot bordet på tabernaklets södra sida ");
INSERT INTO swe_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","och tände lamporna inför Herrens (Jahvehs) ansikte, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Han ställde det gyllene altaret i mötestältet framför förhänget (draperiet) ");
INSERT INTO swe_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","och brände rökelse av söta kryddor på det, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sedan satte han upp förhänget (draperiet) till tabernaklets öppning. ");
INSERT INTO swe_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Brännofferaltaret ställde han vid öppningen till mötestältets tabernakel och offrade på det brännoffer och shalomoffer, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Han ställde vattenkaret mellan mötestältet och altaret och hällde vatten i det för att tvätta sig, ");
INSERT INTO swe_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","så att Mose och Aron och hans söner kunde tvätta sina händer och sina fötter i det. ");
INSERT INTO swe_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","När de gick in i mötestältet och när de kom nära altaret skulle de tvätta sig, som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Sedan reste han inhägnaden runt om tabernaklet och altaret och satte upp förhänget (draperiet) i inhägnadens port. Så fullbordade Mose arbetet. Nu kommer själva finalen – Herrens härlighet kommer och fyller platsen med en stark gudsnärvaro. ");
INSERT INTO swe_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Sedan täckte molnet mötestältet och Herrens härlighet fyllde tabernaklet. ");
INSERT INTO swe_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose kunde inte gå in i mötestältet, eftersom molnet vilade över det och Herrens härlighet (ära, tyngd, dignitet; mättade gudsnärvaro) fyllde tabernaklet. ");
INSERT INTO swe_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Varje gång molnet höjde sig från tabernaklet bröt israeliterna upp och fortsatte sina vandringar. ");
INSERT INTO swe_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Men om molnet inte höjde sig, bröt de inte upp, de vandrade inte framåt förrän den dag det höjde sig. ");
INSERT INTO swe_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Herrens moln vilade över tabernaklet om dagen, och om natten lyste en eld i molnet inför israeliternas ögon under alla deras vandringar. Oavsett ljus eller mörker, dag eller natt var molnet som är Guds närvaro alltid där, synligt för Guds folk. Ordet ”vandringar” (vers 36 och 38) är i plural och beskriver ”uppbrott och delsträckor”. Totalt namnges 42 platser som israeliterna slår läger på under sin vandring till Kanaans land. ");
INSERT INTO swe_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Och Herren (Jahveh) kallade på Mose och talade till honom från mötestältet (hebr. óhel móed). Han sa: ");
INSERT INTO swe_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Tala till Israels söner och säg till dem: Om någon bland er vill föra fram ett offer till Herren (Jahveh) ska han föra fram sitt offer från sin hjord, från nötboskapen eller småboskapen (får och getter), och presentera det som ett blodsoffer. Frasen ”föra fram” är hebr. korban som betyder att man offrar ett blodsoffer, till skillnad från mincha (1 Mos 4:3; 3 Mos 2:1) där man offrar något utan att blod utgjuts, till exempel säd eller vin. Det önskade resultatet av dessa blodsoffer är att de tas emot välbehagligt av Herren (Jahveh). Ordet för ”nåd” här (i vers 3) är ratson som beskriver något som man skulle kunna beskriva som ”villkorad nåd”. Villkoret för nåden är att offret måste vara felfritt. Då tas det emot och då ges nåd. Jesus var det felfria lammet, se 1 Pet 1:19 och 2 Mos 12:5. Se även 5 Mos 33:16; Jes 60:1; Ps 5:13. ");
INSERT INTO swe_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Om hans offer är ett brännoffer från hjorden, ska han offra ett felfritt djur av hankön. Han ska offra det vid ingången till församlingens mötestält (hebr. óhel móed) till nåd (till behag, villkorad nåd – hebr. ratson) inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Och han ska lägga sin hand på brännoffrets huvud och det ska ge nåd (villkorad nåd – hebr. ratson) och ge försoning för (täcka över – hebr. kapar) honom. ");
INSERT INTO swe_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Och han ska döda oxen inför Herrens (Jahvehs) ansikte och Arons söner, prästerna, ska ta blodet och stänka det runtomkring över altaret som är vid ingången till församlingens mötestält. ");
INSERT INTO swe_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Och han ska flå brännoffret och dela det i sina bitar. ");
INSERT INTO swe_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Och Arons söner, prästen singular – översteprästen, ska lägga eld på altaret och lägga i ordning ved på elden. Elden skulle brinna kontinuerligt och aldrig släckas, se 3 Mos 6:13. Det kan vara anledningen till att det står präst (hebr. kohen) i singular här, medan plural kohanim i vers 5 och 8. ");
INSERT INTO swe_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","och Arons söner, prästerna, ska lägga delarna, huvudet och det feta, i ordning på veden som ligger på elden som är på altaret. ");
INSERT INTO swe_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Men inälvorna och benen ska han tvätta i vatten, och prästen ska bränna allt på altaret till ett brännoffer (hebr. olah), ett eldsoffer (hebr. isheh) till en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Och om hans offer är från småboskapen, från fåren eller från getterna som ett brännoffer, ska han föra fram ett felfritt djur av hankön. ");
INSERT INTO swe_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Och han ska döda det på den norra sidan av altaret inför Herrens (Jahvehs) ansikte och Arons söner, prästen, ska stänka dess blod runtomkring över altaret. ");
INSERT INTO swe_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Och han ska dela det i sina bitar med sitt huvud och sitt fett och prästen ska lägga dem i ordning på veden som ligger på elden som är på altaret. ");
INSERT INTO swe_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Men han ska tvätta inälvorna och benen i vatten, och prästen ska ta allt och bränna det på altaret. Det är ett brännoffer, ett eldsoffer till en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Och om brännoffret till hans offer till Herren (Jahveh) är från fågel, ska han föra fram sitt offer av duvor eller av unga turturduvor. ");
INSERT INTO swe_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Och prästen ska föra den till altaret och vrida av dess huvud och bränna den på altaret, och dess blod ska hällas ut vid sidan av altaret. ");
INSERT INTO swe_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Och han ska ta av skinnet med dess fjädrar och kasta det bredvid altaret på östra sidan på platsen för askan. ");
INSERT INTO swe_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Och han ska klyva den med dess vingar men inte dela den helt, och prästen ska bränna den på altaret, på veden som ligger på elden, som ett brännoffer, ett eldsoffer till en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Och när någon (ordagrant en själ) vill offra ett matoffer hebr. mincha till Herren (Jahveh), ska hans offer vara av fint mjöl och han ska hälla olja över det och lägga rökelse på det. ");
INSERT INTO swe_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Och han ska föra fram det till Arons söner, prästerna. Prästen ska ta en handfull dvs. en mindre del av mjölet, tillsammans med oljan med all rökelse, och han ska bränna denna minnesdel (som ett påminnelseoffer – hebr. azkarah) på altaret till ett eldsoffer som en välbehaglig doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Det som är kvar av matoffret är till ska användas av Aron och till hans söner, det mest heliga från Herrens (Jahvehs) eld. Den delen av mjölet som brändes på altaret kallades azkarah (påminnelseoffer), som en ihågkomst inför Herren (Jahveh). Resten fick prästerna använda. Ordet används 7 ggr, se 3 Mos 2:9, 16; 5:12; 6:15; 24:7; 4 Mos 5:26. I 3 Mos 6:14-23 beskrivs matoffren mer detaljerat. ");
INSERT INTO swe_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Och när du för fram ett matoffer bakat i ugnen, ska det vara osyrat bröd av fint mjöl ringlat med olja, eller kakor av fint mjöl smorda med olja. ");
INSERT INTO swe_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Och om offret är ett matoffer bakat i en panna ska det vara av fint mjöl, osyrat och ringlat med olja. ");
INSERT INTO swe_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Du ska dela det i bitar och hälla olja på det, det är ett matoffer. ");
INSERT INTO swe_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Och om ditt offer är ett matoffer bakat i en stekpanna ska det göras med fint mjöl med olja. ");
INSERT INTO swe_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Och du ska ta matoffret som du har gjort av dessa ting till Herren (Jahveh) och när det är förevisat för prästen ska han ta det till altaret. ");
INSERT INTO swe_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Och prästen ska ta från matoffret ett minne av det och ska bränna det på altaret, det är ett offer gjort av eld som en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Det som är kvar av matoffret är till ska användas av Aron och till hans söner, det mest heliga från Herrens (Jahvehs) eld. På samma sätt som mjölet i vers 3. ");
INSERT INTO swe_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Inget matoffer som ska föras fram till Herren (Jahveh) får vara gjort med jäst, för ni ska inte bränna något syrat eller någon honung i något eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Vad gäller offren av förstlingsfrukt ska ni offra dem till Herren (Jahveh), men de ska inte bli brända på altaret som en söt doft. ");
INSERT INTO swe_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Och alla offer av dina matoffer ska du krydda med salt, inte heller ska du låta din Guds (Elohims) förbundssalt saknas i något av dina matoffer, med alla dina offer ska du offra salt. Salt användes för att konservera och bevara och användes ofta symboliskt för att visa att t.ex. ett förbund var långvarigt. Att ingå saltförbund räknas som en fullvärdig motsvarighet till ett blodsförbund ");
INSERT INTO swe_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Och om du offrar ett matoffer av din förstlingsfrukt till Herren (Jahveh), ska du offra gröna ax (omogen säd) som är torkade (rostade) i eld liksom fullt mogna ax. ");
INSERT INTO swe_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Och du ska hälla olja över det och lägga rökelse på det, det är ett matoffer. ");
INSERT INTO swe_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Och prästen ska bränna minnet av det, en del av dess mogna ax och en del av dess olja med all dess rökelse. Det är ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Och om hans offer är ett shalomoffer (gemenskapsoffer – hebr. zevach shelamim), om han offrar det från hjorden – oavsett om det är en hane eller hona – ska det vara felfritt (rent – hebr. tamim) inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Och han ska lägga sin hand på huvudet på sitt offerdjur och döda det vid ingången till församlingens mötestält, och Arons söner, prästerna, ska stänka blodet över altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Och han ska offra shalomoffret, ett offer gjort av eld till Herren (Jahveh), fettet som omger inälvorna och allt dess inre fett, ");
INSERT INTO swe_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","och de två njurarna och det feta på dem, som är vid länderna, och hinnorna som är över levern (och) över njurarna, det ska han ta bort. ");
INSERT INTO swe_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Och Arons söner ska bränna det på altaret ovanpå brännoffret som är ovanpå veden som är på elden, det är ett offer gjort av eld som en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Och om hans offer till shalomoffer (gemenskapsoffer – hebr. zevach shelamim) till Herren (Jahveh) kommer från småboskapen – hane eller hona – ska det vara felfritt (rent – hebr. tamim) inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Om han offrar ett lamm som sitt offer, ska han offra det inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Och han ska lägga sin hand på huvudet på sitt offerdjur och döda det framför församlingens mötestält, och Arons söner ska stänka blodet över altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Och han ska offra shalomoffret, ett offer gjort av eld till Herren (Jahveh), dess fett och hela feta svansen fåren i Mellanöstern är kända för sina tjocka svansar ska han ta bort nära svansfästet (ryggradsslutet, korsbenet; lat. sacrum), och fettet som täcker inälvorna och allt fett som är på inälvorna, ");
INSERT INTO swe_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","och de två njurarna och det feta på dem, som är vid länderna, och hinnorna som är över levern (och) över njurarna, det ska han ta bort. ");
INSERT INTO swe_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Och prästen ska bränna det på altaret, det är matoffret gjort med eld till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Och om hans offer är en get ska han offra den inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Och han ska lägga sin hand på dess huvud och döda det framför församlingens mötestält, och Arons söner ska stänka dess blod över altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Och han ska offra sitt offer, ett eldsoffer till Herren (Jahveh), det feta som täcker inälvorna och allt fett som är på inälvorna, ");
INSERT INTO swe_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","och de två njurarna och det feta på dem, som är vid länderna, och hinnorna som är över levern (och) över njurarna, det ska han ta bort. ");
INSERT INTO swe_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Och prästen ska bränna det på altaret, det är matoffret gjort med eld som en söt doft, allt det feta är Herrens (Jahvehs). ");
INSERT INTO swe_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Det ska vara en evig stadga för era generationer överallt där ni bor, att inte äta varken fett eller blod. ");
INSERT INTO swe_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Tala till Israels söner och säg: Om någon (ordagrant en själ) skulle synda oavsiktligt mot något av Herrens (Jahvehs) budord (tydliga befallningar) angående de ting som inte borde göras, och ändå gör det mot ett av dem något av följande bud, se vers 3, 13, 27 och 32: ");
INSERT INTO swe_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Om prästen som är smord gör synd efter folkets synd, låt honom föra fram för den synd varmed han har syndat, en ung felfri (ren – hebr. tamim) tjur till Herren (Jahveh) som syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Och han ska föra fram tjuren till ingången på församlingens mötestält, inför Herrens (Jahvehs) ansikte, och han ska lägga sin hand på tjurens huvud och döda tjuren inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Och prästen som är smord ska ta av tjurens blod och föra in det i mötestältet, ");
INSERT INTO swe_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","och prästen ska doppa sitt finger i blodet och stänka blodet sju gånger inför Herrens (Jahvehs) ansikte, framför helgedomens förhänge. ");
INSERT INTO swe_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Och prästen ska stryka en del av blodet över altarets horn med söt rökelse inför Herrens (Jahvehs) ansikte, som är i mötestältet. Resten av blodet (allt blodet) från tjuren ska han hälla ut vid foten på altaret med brännoffret som står vid ingången till mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Och han ska ta bort allt det feta från tjuren till syndoffret, det feta som täcker inälvorna och allt fett som är på inälvorna, ");
INSERT INTO swe_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","och de två njurarna och det feta på dem, som är vid länderna, och hinnorna som är över levern (och) över njurarna, det ska han ta bort, ");
INSERT INTO swe_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","på samma sätt som det tas bort från oxen till shalomoffret, och prästen ska bränna dem på brännofferaltaret. ");
INSERT INTO swe_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Och huden från tjuren och allt dess kött med dess huvud och med dess ben och dess inälvor och dess avskräde (slaktrester), ");
INSERT INTO swe_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","hela tjuren ska han bära bort utanför lägret till en ren plats där askan ska spridas ut, och bränna den på ved med eld. Där askan sprids ut ska den brännas. ");
INSERT INTO swe_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Om hela Israels församling (menighet) syndar oavsiktligt, och detta göms undan från församlingens ögon, och de har gjort någonting (en sak) mot något av Herrens (Jahvehs) budord (tydliga befallningar) angående de ting som inte borde göras, och är skyldiga, ");
INSERT INTO swe_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","när synden som de har syndat blir känd, då ska församlingen offra en ung tjur (ordagrant: en son av boskapen) för synden och föra fram den framför mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Och församlingens äldste ska lägga sina händer på tjurens huvud inför Herrens (Jahvehs) ansikte, och tjuren ska dödas inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Och prästen som är smord ska föra tjurens blod till mötestältet, ");
INSERT INTO swe_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","och prästen ska doppa sitt finger i en del av blodet och stänka det sju gånger inför Herrens (Jahvehs) ansikte, framför helgedomens förhänge. ");
INSERT INTO swe_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Och han ska stryka en del av blodet över altarets horn som är inför Herrens (Jahvehs) ansikte, som är i mötestältet. Resten av blodet (allt blodet) från oxen ska han hälla ut vid foten på altaret med brännoffret som står vid ingången till mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Och han ska ta allt det feta från den och bränna det på altaret. ");
INSERT INTO swe_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Och han ska göra med tjuren som han gjorde med syndofferstjuren, så ska han göra med den, och prästen ska bringa försoning för (täcka över – hebr. kapar) dem och de ska bli förlåtna. ");
INSERT INTO swe_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Och han ska bära bort tjuren utanför lägret och bränna den som han brände den första tjuren, det är ett syndoffer för församlingen (menigheten). ");
INSERT INTO swe_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","När en ledare har syndat och gjort något oavsiktligt mot någonting (en sak) mot något av Herren (Jahveh) sin Guds (Elohims) budord (tydliga befallningar) angående de ting som inte borde göras, och är skyldig, ");
INSERT INTO swe_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","eller om hans synd som han har syndat med kommer till hans kännedom, ska han föra fram sitt offer, en felfri (ren, oskyldig – hebr. tamim) killing av hankön, ");
INSERT INTO swe_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","och han ska lägga sin hand på killingens huvud och döda den på platsen där man dödar brännoffret inför Herrens (Jahvehs) ansikte, det är ett syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Och prästen ska ta av blodet från syndoffret med sitt finger och stryka en del av blodet över brännofferaltarets horn. Resten av blodet (allt blodet) ska han hälla ut vid foten av brännofferaltaret. ");
INSERT INTO swe_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Och han ska bränna allt dess fett på altaret, som fettet från shalomoffren, och prästen ska bringa försoning för (täcka över – hebr. kapar) honom för hans synd, och han ska bli förlåten. ");
INSERT INTO swe_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Och om någon (en själ; en enskild individ – hebr. nefesh) syndar oavsiktligt när han gör någonting (en sak) mot något av Herrens (Jahvehs) budord (tydliga befallningar) angående de ting som inte borde göras, och är skyldig, ");
INSERT INTO swe_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","eller om hans synd som han har syndat med kommer till hans kännedom, ska han föra fram sitt offer, en felfri (ren, oskyldig – hebr. tamim) killing av honkön, för den synd som han har syndat. ");
INSERT INTO swe_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Och han ska lägga sin hand på syndoffrets huvud och döda syndoffret på platsen för (där man dödar) brännoffret. ");
INSERT INTO swe_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Och prästen ska ta av dess blod med sitt finger och stryka en del av blodet över brännofferaltarets horn. Resten av blodet (allt blodet) ska han hälla ut vid foten av altaret. ");
INSERT INTO swe_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Och han ska ta bort allt dess fett som fettet tas bort från shalomoffret, och prästen ska bränna det på altaret till en söt doft till Herren (Jahveh), och prästen ska bringa försoning för (täcka över – hebr. kapar) honom och han ska bli förlåten. ");
INSERT INTO swe_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Och om han för fram ett lamm som syndoffer ska han föra fram ett felfritt (rent – hebr. tamim) hondjur. ");
INSERT INTO swe_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Och han ska lägga sin hand på syndoffrets huvud och döda det som syndoffer på platsen där man dödar brännoffret. ");
INSERT INTO swe_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Och prästen ska ta av blodet från syndoffret med sitt finger och stryka en del av blodet över brännofferaltarets horn. Resten av blodet (allt blodet) ska han hälla ut vid foten av altaret. ");
INSERT INTO swe_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Och han ska ta bort allt dess fett som fettet tas bort från lammet till shalomoffret, och prästen ska bränna det på altaret i likhet med de offer som görs med eld till Herren (Jahveh), och prästen ska bringa försoning för (täcka över) hans synd som han har bekänt och han ska bli förlåten. ");
INSERT INTO swe_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Och om någon (en själ; en enskild individ – hebr. nefesh) syndar och hör rösten som svär (avlägger en ed) och är ett vittne som har sett eller känner till om det, om han inte berättar något, då ska han bära hans synd. ");
INSERT INTO swe_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Eller om någon (en själ) rör vid något orent föremål, om det är ett kadaver från ett orent djur, eller ett kadaver från oren boskap, eller ett kadaver från orena kräldjur, och om det har blivit dolt för honom, ska han också vara oren och skyldig. ");
INSERT INTO swe_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Eller om han rör vid det orena hos en människa, vilken orenhet det än är som orenar en människa, och det döljs för honom, när han känner till (får kunskap om) det ska han vara skyldig. ");
INSERT INTO swe_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Eller om någon (en själ) svär (avlägger en ed) och uttalar med sina läppar att göra ont, eller att göra gott, vad det än är som en människa säger med en ed, och det göms för honom, när han känner till (får kunskap om) det ska han vara skyldig i endera avseendet. ");
INSERT INTO swe_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Och det ska ske när han är skyldig i en av dessa saker att han ska bekänna att han har syndat i detta. ");
INSERT INTO swe_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Och han ska föra fram offret för sin överträdelse till Herren (Jahveh) för synden som han har syndat, ett hondjur från flocken, ett lamm eller en killing som syndoffer. Och prästen ska bringa försoning för (täcka över) honom för hans synd. ");
INSERT INTO swe_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Och om han inte kan föra fram ett lamm, då ska han föra fram för sin överträdelse som han har begått, två duvor eller två turturduvor till Herren (Jahveh), en som skuldoffer och den andra som brännoffer. ");
INSERT INTO swe_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Och han ska föra dem till prästen som ska offra den som är till syndoffer först, och ska vrida av dess huvud från nacken men inte dela sönder den helt. ");
INSERT INTO swe_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Och han ska stänka blodet från syndoffret på sidan av altaret, och resten av blodet ska rinna ut vid foten av altaret. Det är ett syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Och han ska offra den andra som brännoffer enligt förordningen (för brännoffer), och prästen ska bringa försoning för (täcka över) honom, för hans synd som han har syndat, och han ska bli förlåten. ");
INSERT INTO swe_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Men om han inte har möjlighet att föra fram två duvor eller två turturduvor, då ska han som har syndat föra fram som sitt offer en tiondels efa 3,5 liter fint mjöl som syndoffer, han ska inte hälla någon olja på det, inte heller ska han lägga någon rökelse på det, för det är ett syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Han ska föra fram det mjölet till prästen, sedan ska prästen ta en handfull av det som en minnesdel (som ett påminnelseoffer – hebr. azkarah) 3 Mos 2:2 och bränna det på altaret tillsammans med Herrens (Jahvehs) eldsoffer. Det är ett syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Och prästen ska bringa försoning för (täcka över) honom, angående hans synd som han syndat i något av detta, och han ska bli förlåten. Och det som är kvar ska vara prästens som matoffer. Skuldoffret handlar om synder där någon stulit, förverkat eller undanhållit egendom från medmänniskor och då ska dels det stulna återbördas och även en femtedel av värdet betalas som kompensation. ");
INSERT INTO swe_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Om någon (en själ; individ – hebr. nefesh) begår en överträdelse (missgärning) och syndar oavsiktligt med Herrens (Jahvehs) heliga ting, ska han för sin överträdelse föra fram till Herren (Jahveh) en felfri (rent – hebr. tamim) bagge från sin flock, med en enligt din värdering en av prästen uppskattad jämförbar summa silver i shekel, efter helgedomens shekel, som skuldoffer. ");
INSERT INTO swe_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Och han ska gottgöra för den skada som han åsamkat det heliga, och ska lägga till en femtedel av värdet och ge det till prästen. Och prästen ska bringa försoning för (täcka över) honom med baggen till skuldoffret, och han ska bli förlåten. ");
INSERT INTO swe_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Och om någon (en själ; en enskild individ – hebr. nefesh) syndar och begår något av dessa ting som är förbjudna att göra av Herrens (Jahvehs) budord, även om han inte kände till det är han skyldig och ska bära sin överträdelse. ");
INSERT INTO swe_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Och han ska föra fram en felfri (ren, oskyldig – hebr. tamim) bagge från sin flock, med en enligt prästen uppskattad jämförbar summa, som skuldoffer till prästen. Och prästen ska bringa försoning för (täcka över) honom angående hans oaktsamhet varmed han gjort fel utan att veta (förstå) det, och han ska bli förlåten. Jfr vers 15. ");
INSERT INTO swe_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Det är ett skuldoffer, han står verkligen i skuld till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Om någon (en själ) syndar och bekänner en överträdelse mot Herren (Jahveh) och agerar falskt mot sin granne med en handpenning, eller med pant, eller med stöld eller har förtryckt sin granne, ");
INSERT INTO swe_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","eller har funnit något förlorat och varit oärlig med det, eller ljugit under ed. Om någon människa har gjort något av allt detta och syndat, ");
INSERT INTO swe_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","då ska det ske, om han som har syndat och är skyldig, ska lämna tillbaka (återställa) det som han har stulit eller det han skaffat med förtryck, eller handpenningen eller panten som fanns hos honom, eller det förlorade som blev funnet, ");
INSERT INTO swe_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","eller vadhelst annat som han svurit falskt om. Han ska återställa det till fullo och ska lägga till en femtedel mer till det 20% extra av dess värde till den som det tillhör ska han ge det, samma dag som han befinns skyldig. ");
INSERT INTO swe_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Och han ska föra fram det förverkade till Herren (Jahveh), en felfri (ren, oskyldig – hebr. tamim) bagge från sin flock, enligt det uppskattade värdet, som skuldoffer till prästen. ");
INSERT INTO swe_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Och prästen ska bringa försoning för (täcka över) honom inför Herrens (Jahvehs) ansikte, och han ska bli förlåten angående vadhelst han därmed har gjort sig skyldig till. ");
INSERT INTO swe_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Befall Aron och hans söner och säg: Detta är undervisningen om brännoffret. Det är brännoffret ovanpå elden ovanpå altaret hela natten till morgonen och altarets eld ska vara brinnande på det. ");
INSERT INTO swe_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Och prästen ska sätta på sig sin linneklädnad, och hans linnebyxor ska han sätta på sin kropp (ordagrant över sitt kött), och ska ta upp askan som elden förtärt med brännoffret på altaret, och han ska lägga den vid sidan om altaret. ");
INSERT INTO swe_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Och han ska ta av sig sina kläder och sätta på sig andra kläder och bära ut askan utanför lägret till en ren plats. ");
INSERT INTO swe_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Och elden på altaret ska brinna på det, den ska inte släckas, och prästen ska bränna ved på det varje morgon, och lägga i ordning brännoffret över den, och han ska där bränna det feta från shalomoffret. ");
INSERT INTO swe_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Elden ska alltid brinna på altaret, den ska aldrig släckas. ");
INSERT INTO swe_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Detta är undervisningen om matoffret. Arons söner ska offra det inför Herrens (Jahvehs) ansikte, framför altaret. ");
INSERT INTO swe_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Och han ska ta sin hand full av det, av mjöl från matoffret och av dess olja, och all dess rökelse som är på matoffret och ska bränna det på altaret som en söt doft, och minnet av det till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Och resten av det ska Aron och hans söner äta. Med osyrat bröd ska det ätas på en helig plats, på mötestältets gård ska de äta det. ");
INSERT INTO swe_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Det ska inte bakas med jäst. Jag har gett det till dem som deras del av mitt eldsoffer. Det är högheligt liksom syndoffret och skuldoffret. ");
INSERT INTO swe_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Alla män av Arons söner ska äta av det. Det ska vara en evig förordning (ordagrant ”saker inristat”) i dina släktled angående Herrens (Jahvehs) eldsoffer. Var och en som rör dem (är, blir) ska vara helgad. ");
INSERT INTO swe_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Detta är Aron och hans söners offer som de ska offra till Herren (Jahveh) den dagen när han blir smord. En tiondel av en efa 3,5 liter fint mjöl som ett evigt matoffer, hälften av det på morgonen och hälften av det på kvällen. ");
INSERT INTO swe_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Det ska göras i en panna med olja, och när det är bakat ska du föra fram de bakade bitarna av matoffret och du ska offra det som en söt doft till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Och prästerna bland hans söner som är smorda i hans ställe i kommande generationer ska offra det. Det är en evig förordning (ordagrant ”saker inristat”) till Herren (Jahveh). Det ska brännas helt och hållet. ");
INSERT INTO swe_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","För alla matoffer som offras av prästerna ska brännas helt och hållet. De ska inte ätas. Det är skillnad på prästens eget offer och de offer som de hanterar på folkets vägnar. När det gäller syndoffer och skuldoffer (3 Mos 7:1-10) delas offret mellan prästen och altaret, och den som kommer med offret har ingen del av det, som han hade med gemenskapsoffret. Eftersom synd- och skuldoffer handlar om omvändelse är det mer lämpligt att fasta än att ha en festmåltid. ");
INSERT INTO swe_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Tala till Aron och till hans söner och säg: ”Detta är undervisningen om syndoffer. På den plats där brännoffret dödas ska syndoffret dödas inför Herrens (Jahvehs) ansikte. Det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Prästen som förrättar syndoffret ska äta av det, det ska ätas på en helig plats, på mötestältets gård. ");
INSERT INTO swe_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Vadhelst som berör dess kött blir helgat, och om något av blodet stänker på någon klädnad ska du tvätta det som blivit nedstänkt på en helig plats. ");
INSERT INTO swe_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Men lerkärlen som blivit nersölade ska krossas, och om det är ett bronskärl som blivit nedsölat ska det både bli skurat och sköljt i vatten. ");
INSERT INTO swe_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Alla män bland prästerna ska äta av det. Det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Men inget syndoffer vars blod burits in i mötestältet för att försona det heliga ska ätas. Det ska brännas i eld. ");
INSERT INTO swe_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Detta är undervisningen om skuldoffer (hebr. asham). Det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","På den plats där brännoffret dödas ska skuldoffret dödas, och dess blod ska stänkas runtomkring över altaret. ");
INSERT INTO swe_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Och han den som gör skuldoffret ska offra allt dess fett, bakdelen och fettet som täcker inälvorna, ");
INSERT INTO swe_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","och de två njurarna och det feta på dem, som är vid länderna, och hinnorna som är över levern (och) över njurarna, det ska han ta bort. ");
INSERT INTO swe_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Och prästen ska bränna det på altaret som ett eldsoffer till Herren (Jahveh). Det är ett skuldoffer. ");
INSERT INTO swe_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Varje man bland prästerna ska äta av det, det ska ätas på en helig plats. Det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Liksom syndoffret så är skuldoffret, det finns en undervisning om dem. Prästen som bringar försoning med det, honom ska det tillhöra. ");
INSERT INTO swe_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Och prästen som offrar någon mans brännoffer, den prästen ska ha dess skinn själv från brännoffret som han har offrat. ");
INSERT INTO swe_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Och alla matoffer som är bakade i ugnen och allt som är tillrett i stekpannan och i pannan ska tillhöra prästen som offrar det. ");
INSERT INTO swe_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Och alla matoffer, ringlade med olja och torra, ska Arons söner ha, den ene lika mycket som den andre. ");
INSERT INTO swe_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Detta är undervisningen om shalomoffer, som han ska offra till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Om han offrar det som en tacksägelsegåva, då ska han offra det med tacksägelseoffret, osyrat bröd blandat med olja, och osyrade kakor smorda med olja och stekta kakor av fint mjöl blandade med olja. ");
INSERT INTO swe_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Vid sidan av kakorna ska han offra jäst bröd med tacksägelseoffret till sitt shalomoffer. ");
INSERT INTO swe_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Och av dem ska han offra en av alla från hela offret som ett viftoffer till Herren (Jahveh), och den ska tillhöra den präst som stänker blodet från shalomoffret. ");
INSERT INTO swe_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Och köttet från hans shalomoffer som tacksägelse ska ätas samma dag som det offras, inget av det får lämnas kvar till morgonen. ");
INSERT INTO swe_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Men om offret som han offrar är en ed eller ett frivilligt offer, ska det ätas samma dag som det offras och på morgonen ska det överblivna ätas. ");
INSERT INTO swe_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Men om något av köttet från offret finns kvar till den tredje dagen ska det brännas i eld. ");
INSERT INTO swe_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Men om något av köttet från hans shalomoffer (gemenskapsoffer) äts på den tredje dagen, ska ingen nåd (villkorad nåd – hebr. ratsah) ges offret accepteras inte, det ska inte tillräknas honom som offrar, istället ska det vara en styggelse och den personen (den själ) som äter av det ska bära sin synd. ");
INSERT INTO swe_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Och kött som vidrör något orent föremål ska inte ätas, det ska brännas i eld. Och köttet, alla rena ska äta köttet. ");
INSERT INTO swe_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Men den person (själ) som äter av det kött från shalomoffret som tillhör Herren (Jahveh), han har sin orenhet över sig. Den personen (själen) ska huggas av från sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Den själ som rör vid något orent, som det orena hos en människa eller något orent djur, eller något avskyvärt orent ting, och äter av köttet som offrats som shalomoffer, som tillhör Herren (Jahveh), den själen ska huggas av från sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Tala till Israels söner och säg: Ni ska på inget sätt äta något fett, från oxe eller från lamm eller från get. ");
INSERT INTO swe_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Men det feta från självdöda djur, och fettet från det som är rivet av vilddjur, kan ni använda till andra saker, men ni får på inget sätt äta av det. ");
INSERT INTO swe_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Vem som än äter det feta från något djur som en man har offrat som ett eldsoffer till Herren (Jahveh), den person (själ) som äter det ska huggas av från sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ni ska på inget sätt äta något blod, oavsett om det kommer från en fågel eller ett djur, inte någonstans där ni bor. ");
INSERT INTO swe_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Vilken själ det än är som äter något blod, den själen ska huggas av från sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Tala till Israels söner och säg: Den som offrar ett shalomoffer (gemenskapsoffer) till Herren (Jahveh), ska föra fram sitt djuroffer till Herren (Jahveh) från sitt shalomoffer. ");
INSERT INTO swe_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Hans egna händer ska föra fram offret till Herren (Jahveh), gjort med eld. Det feta med bringan ska han föra fram så att bringan kan viftas som ett viftoffer inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Och prästen ska bränna det feta på altaret men bringan ska vara Arons och hans söners. ");
INSERT INTO swe_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Och det högra låret ska han ge till prästen som ett viftoffer från era shalomoffer (gemenskapsoffer). ");
INSERT INTO swe_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Den bland Arons söner som offrar blodet och det feta från shalomoffret, han ska ha det högra låret som sin del. ");
INSERT INTO swe_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Viftoffersbringan och viftofferslåret har jag tagit från Israels söner från deras shalomoffer (gemenskapsoffer), och gett det till Aron, prästen, och till hans söner som en förordning (ordagrant ”saker inristat”) för evigt bland Israels söner. ");
INSERT INTO swe_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Detta är delen av Arons smörjelse, och av hans söners smörjelse, från Herrens (Jahvehs) eldsoffer, den dag han ställde fram dem till tjänst inför Herrens (Jahvehs) ansikte för att tjänstgöra som präster, ");
INSERT INTO swe_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","som Herren (Jahveh) befallt att ge dem från Israels söner den dag han smorde dem som en evig förordning (ordagrant ”saker inristat”) för deras kommande generationer. Nu sammanfattas offren i kapitel 1-7. ");
INSERT INTO swe_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Detta är undervisningen om brännoffer 3 Mos 1, matoffer 3 Mos 2 och syndoffer 3 Mos 4 och skuldoffer 3 Mos 5 och invigningsoffer (fyllandet) av handen, se 3 Mos 8:33 och shalomoffer (offer för helhet och gemenskap – hebr. shelem) 3 Mos 3, ");
INSERT INTO swe_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","som Herren (Jahveh) befallde Mose på berget Sinai den dag då han befallde Israels söner att offra sina offer till Herren (Jahveh) i Sinais öken. ");
INSERT INTO swe_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","”Ta Aron tillsammans med hans söner, och kläderna och smörjelseoljan och en tjur som syndoffer 3 Mos 4:3 och två baggar och en korg med osyrat bröd, ");
INSERT INTO swe_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","och samla hela församlingen tillsammans vid ingången till mötestältet.” ");
INSERT INTO swe_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Och Mose gjorde som Herren (Jahveh) befallt och församlingen samlades tillsammans vid ingången till mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Och Mose sa till församlingen: ”Detta är de ting som Herren (Jahveh) befallt till att göras. ");
INSERT INTO swe_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Och Mose förde fram Aron och hans söner och tvättade dem i vatten. ");
INSERT INTO swe_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Och han satte på honom kläderna 2 Mos 28:39-41 och omgjordade honom med gördeln och klädde honom i ämbetsdräkten 2 Mos 28:39-41 och satte efoden 2 Mos 28:6-14 på honom och omgjordade honom med efodens praktfulla gördel och band fast den efoden på honom med den den praktfulla gördeln. ");
INSERT INTO swe_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Och han satte bröstskölden på honom 2 Mos 28:15-30, och i bröstskölden lade han ner Urim och Tummim. Urim och Tummim var namnet på de två föremål (troligtvis två mindre stenar eller stavar) som prästen bar i sin prästsköld och som troligtvis användes för att kasta lott, se 2 Mos 28:30; 1 Sam 14:42. ");
INSERT INTO swe_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Och han satte huvudbonaden på hans huvud och på hans panna satte han den gyllene plåten, den heliga kronan, som Herren (Jahveh) befallt Mose. 2 Mos 28:36 ");
INSERT INTO swe_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Sedan tog Mose smörjelseoljan och smorde tabernaklet (hebr. miskan) och allt som fanns därinne och helgade det. ");
INSERT INTO swe_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Och han stänkte därav på altaret sju gånger, och smorde altaret 2 Mos 27:1-8 och alla dess redskap, både vattenkaret 2 Mos 30:17-21 och dess fundament, till att helga dem. ");
INSERT INTO swe_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Och han hällde ut smörjelseoljan över Arons huvud Ps 133 och smorde honom, till att helga honom. ");
INSERT INTO swe_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Och Mose förde fram Arons söner och satte kläder på dem 2 Mos 28:39-41 och omgjordade dem med gördlar och satte huvudbonader på dem som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Och han förde fram tjuren för syndoffret 3 Mos 4:3, och Aron och hans söner lade sina händer på tjurens huvud för syndoffret. ");
INSERT INTO swe_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Och han slaktade den och Mose tog blodet och strök det med sitt finger på altarets horn de fyra hörnen, se 2 Mos 27:2 runtom och renade altaret och hällde blodet vid altarets fot och helgade (avskilde) det till att bringa försoning (täcka över) på det. ");
INSERT INTO swe_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Och han tog allt det feta som täcker inälvorna, och hinnorna som är över levern och de två njurarna och deras fett, och Mose brände det på altaret. ");
INSERT INTO swe_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Men tjuren och dess skinn, dess kött och dess avskräde (slaktrester) brände han med eld utanför lägret, som Herren (Jahveh) hade befallt Mose. 2 Mos 29:14 ");
INSERT INTO swe_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Och han förde fram baggen till brännoffret 3 Mos 1:1-17, och Aron och hans söner lade sina händer på baggens huvud. ");
INSERT INTO swe_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Och han slaktade den och Mose stänkte blodet på altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Och han delade baggen i bitar och Mose brände huvudet, bitarna och det feta. ");
INSERT INTO swe_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Och han tvättade inälvorna och benen i vatten, och Mose brände hela baggen på altaret. Det är ett brännoffer med en söt doft och ett eldsoffer till Herren (Jahveh), som Herren (Jahveh) hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Och han förde fram den andra baggen, baggen för invigning, och Aron och hans söner lade sina händer på baggens huvud. ");
INSERT INTO swe_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Och han slaktade den och Mose tog av dess blod och strök det på Arons högra örsnibb, och på tummen på hans högra hand, och på stortån på hans högra fot 2 Mos 29:20. ");
INSERT INTO swe_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Och han förde fram Arons söner och Mose strök blod på deras högra örsnibbar, och på tummarna på deras högra hand, och på stortårna på deras högra fot. Och Mose stänkte blodet över altaret runtomkring. ");
INSERT INTO swe_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Och han tog det feta och länden och allt det feta som var på inälvorna och hinnorna som är över levern och de två njurarna och deras fett, och det högra låret, ");
INSERT INTO swe_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","och från korgen med osyrat bröd som var inför Herrens (Jahvehs) ansikte 2 Mos 25:30, tog han en osyrad brödkaka och en kaka med inoljat bröd och en kaka och lade dem på det feta och på det högra låret. ");
INSERT INTO swe_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Och han lade allt på Arons händer och på hans söners händer och viftade dem som ett viftoffer inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Och Mose tog dem från deras händer och brände dem på altaret ovanpå brännoffret, det är invigningen som en söt doft, det är ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Och Mose tog bröstet och viftade det som ett viftoffer inför Herrens (Jahvehs) ansikte, det var Moses del av prästvigningsbaggen – som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Och Mose tog av smörjelseoljan och av blodet som var på altaret och stänkte det över Aron och över hans kläder och över hans söner och över hans söners kläder med honom, och helgade (avskilde) Aron och hans kläder och hans söner och hans söners kläder med honom. ");
INSERT INTO swe_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Och Mose sa till Aron och till hans söner: ”Koka köttet vid ingången till mötestältet och ät det där med bröd som är i korgen för invigningen som jag har befallt och sagt, Aron och hans söner ska äta det. ");
INSERT INTO swe_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Och det som blir kvar av köttet och av brödet ska ni bränna i eld. ");
INSERT INTO swe_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Och ni ska inte gå ut genom ingången till mötestältet på sju dagar, till dess dagarna för er invigning tar slut, i sju dagar ska ni helga er. ");
INSERT INTO swe_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Som han har gjort denna dag, så har Herren (Jahveh) befallt att göra för att bringa försoning för (täcka över) er. ");
INSERT INTO swe_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Därför ska ni vistas vid ingången till mötestältet dag och natt sju dagar, och vakta (vaka över) det Herren (Jahveh) förordnat, så att ni inte dör, för så har jag blivit befalld. ");
INSERT INTO swe_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Så Aron och hans söner gjorde allt som Herren (Jahveh) befallt genom Moses hand. ");
INSERT INTO swe_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Och det skedde på åttonde dagen att Mose kallade på Aron och hans söner och Israels äldste. ");
INSERT INTO swe_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Och han sa till Aron: ”Ta dig en ung kalv, en tjurkalv (ordagrant: ”son av boskap”), som syndoffer och en felfri (tamim, ren) bagge som brännoffer och offra dem inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Och till Israels söner ska du tala och säga: ”Ta en killing från getterna som syndoffer, och en kalv och ett lamm, båda årsgamla och felfria (tamim, rena) som brännoffer, ");
INSERT INTO swe_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","och en oxe och en bagge till shalomoffer, för att offra inför Herrens (Jahvehs) ansikte och matoffer ringlat med olja, för idag ska Herren (Jahveh) visa sig för er. ");
INSERT INTO swe_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Och de förde fram det som Mose befallt till öppningen på mötestältet och hela menigheten kom nära och stod inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Och Mose sa: ”Detta är det som Herren (Jahveh) befallt att göra och Herrens (Jahvehs) härlighet (tyngd) ska visa sig för er.” ");
INSERT INTO swe_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Och Mose sa till Aron: ”Gå till altaret och offra ditt syndoffer och ditt brännoffer och bringa försoning (täck över) för dig själv och för folket, och offra folkets offer och bringa försoning (täck över) för dem, som Herren (Jahveh) befallt. ");
INSERT INTO swe_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Och Aron gick till altaret och slaktade kalven för syndoffret som var för honom själv. ");
INSERT INTO swe_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Och Arons söner förde blodet till honom och han doppade sitt finger i blodet och strök det på altarets horn och hällde ut blodet vid foten av altaret. ");
INSERT INTO swe_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Men det feta och njurarna och hinnorna över levern på syndoffret brände han på altaret, som Herren (Jahveh) befallt Mose. ");
INSERT INTO swe_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Och köttet och huden brände han i eld utanför lägret. ");
INSERT INTO swe_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Och han slaktade brännoffret och Arons söner bar fram blodet till honom som han stänkte runt omkring över altaret. ");
INSERT INTO swe_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Och de bar fram brännoffret till honom med dess delar och huvudet och han brände dem på altaret. ");
INSERT INTO swe_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Och han tvättade inälvorna och benen och brände dem ovanpå brännoffret på altaret. ");
INSERT INTO swe_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Och han förde fram folkets offer och tog geten som var folkets syndoffer och slaktade den och offrade den för synd, som det första (folkets första syndoffer). ");
INSERT INTO swe_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Och han förde fram brännoffret och offrade det i enlighet med föreskrifterna. ");
INSERT INTO swe_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Och han förde fram matoffret och tog en handfull därav och brände det på altaret vid sidan av morgonens brännoffer. ");
INSERT INTO swe_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Han slaktade oxen och baggen som shalomoffer som var för folket, och Arons söner förde fram blodet till honom som han stänkte över altaret runt omkring. ");
INSERT INTO swe_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Och det feta av oxen och baggen, länden och det som täcker inälvorna och njurarna och hinnorna över levern, ");
INSERT INTO swe_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","och de lade det feta på bröststycket och han brände det feta ovanpå altaret. ");
INSERT INTO swe_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Och bröststycket och det högra låret viftade Aron som ett viftoffer inför Herrens (Jahvehs) ansikte, som Mose hade befallt. ");
INSERT INTO swe_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Och Aron lyfte upp sin hand mot folket och välsignade dem, och kom ner från syndoffret och brännoffret och shalomoffret. Aron står kvar vid altaret, som är en upphöjd plats, när han välsignar folket. ");
INSERT INTO swe_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Och Mose och Aron gick in i mötestältet och kom ut och välsignade folket. Och Herrens (Jahvehs) härlighet (tyngd) visade sig för hela folket. ");
INSERT INTO swe_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Och det kom en eld från Herrens (Jahvehs) ansikte och slukade brännoffret och det feta på altaret, som när hela folket såg det, ropade och föll ner på sina ansikten. ");
INSERT INTO swe_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Och Arons två äldsta söner Nadav betyder ”generös” och Aviho betyder ”min far (är) han” tog sina fyrfat och lade eld i dem och lade rökelse ovanpå och offrade främmande (otillåten – hebr. zarah) eld (hebr. esh) inför Herrens (Jahvehs) ansikte, som han hade befallt dem att låta bli. ");
INSERT INTO swe_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Och eld gick ut från Herren (Jahveh) och slukade dem och de dog inför Herrens (Jahvehs) ansikte. Den exakta överträdelsen är inte specificerad, men 2 Mos 30:9 förbjuder att offra främmande rökelse (hebr. ketoret zarah). Det rörde sig om rökelse som inte var förberedd på rätt sätt, se 2 Mos 30:34-38. Ett annat förslag är att de offrade på fel tid, se 2 Mos 30:7-8. Denna händelse ligger säkert till grund för uttalandet i Heb 12:29. ");
INSERT INTO swe_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Då sa Mose till Aron: ”Detta är vad Herren (Jahveh) talade och sa: ’Jag blir helgad i dem som kommer nära mig och över hela folkets ansikte ska jag förhärligas.’ ” Aron var tyst (som förstelnad, rörde sig inte, väntade – hebr. damam). Ordet används ofta vid katastrofer, se Hes 24:17. ");
INSERT INTO swe_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Och Mose kallade på Mishael och Eltsafan, Ussiels söner, farbror till Aron, och sa till dem: ”Kom nära, bär bort era bröder från helgedomens åsyn ut ur lägret.” ");
INSERT INTO swe_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","De kom nära och bar bort dem i deras kläder, ut ur lägret som Mose talat. ");
INSERT INTO swe_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Och Mose sa till Aron och till Elazar och Itamar, hans söner: ”Låt inte era huvuden vara fria ta inte av er huvudbonaden; låt inte håret vara ovårdat – visa inte yttre tecken på sorg och riv inte sönder era kläder, för att ni inte ska dö så att vreden kommer över hela folket, men låt era bröder, hela Israels hus begråta elden som dödade Nadav och Aviho som Herren (Jahveh) tände. ");
INSERT INTO swe_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ni ska inte lämna mötestältets ingång, för att inte dö, för Herrens (Jahvehs) smörjelseolja är över er. Och de gjorde enligt Moses ord.” ");
INSERT INTO swe_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Och Herren (Jahveh) talade till Aron och sa: ");
INSERT INTO swe_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","”Drick inte vin eller starka drycker, inte du eller dina söner med dig när ni går in i mötestältet för att inte dö. Det ska vara en förordning (ordagrant ’saker inristat’) för evigt genom dina generationer, ");
INSERT INTO swe_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","för att ni ska skilja mellan heligt och oheligt och mellan orent och rent här är en kiasm med heligt/rent och oheligt/orent ");
INSERT INTO swe_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","och för att ni ska undervisa Israels söner alla de förordningar (ordagrant ’saker inristat’) som Herren (Jahveh) talat till dem genom Moses hand.” ");
INSERT INTO swe_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Och Mose talade till Aron och till Elazar och Itamar, hans söner som var kvar: ”Ta matoffret som återstår av Herrens (Jahvehs) eldsoffer och ät det utan jäst bredvid altaret, för det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Och ni ska äta det på en helig plats eftersom det är din föreskrivna del och dina söners föreskrivna del av Herrens (Jahvehs) eldsoffer, för så har jag befallt. ");
INSERT INTO swe_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Och bringan som viftats och låret som viftats ska ni äta på en ren plats, du och dina söner och dina döttrar med dig, för det är din föreskrivna del och dina söners föreskrivna del som är givet av offret från Israels söners shalomoffer. ");
INSERT INTO swe_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Låret och bröstet ska de föra fram med eldsoffren av fett, för att vifta det som ett viftoffer inför Herrens (Jahvehs) ansikte, och det ska vara ditt och dina söners med dig, det är en evig förordning (ordagrant ”saker inristat”) som Herren (Jahveh) har befallt.” ");
INSERT INTO swe_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mose frågade noggrant efter (hebr. darash darash – ordagrant: ”frågande frågade”, vilket förstärker sökandet efter) syndoffersbocken 3 Mos 4:3; 9:15; 10:1, men se, den var uppbränd. Orden darash darash är den matematiska mittpunkten av alla hebreiska ord i Torah (de fem Moseböckerna). Det är intressant att det finns totalt 77 dubbelord i Torah som t.ex. ”Abraham, Abraham” (1 Mos 25:19) och ”Noa, Noa” (1 Mos 6:9). Av dessa 77 dubbelord finns det 39:e och mittersta darash, darash just här. Det är mer än en slump att i mitten av alla 304 805 ord i de fem Torah-rullarna är de två ord (ord nummer 152 402 och 152 403) också ett dubbelord som i sin tur är den mittersta av alla 77 dubbelord! Dessutom handlar denna vers om att Mose noggrant söker efter syndabocken vilket pekar på den centrala frågan – vem kan försona oss med Gud? Johannes Döparen (den störste profeten, se Matt 11:11) ger svaret: ”Se, Guds Lamm, som utplånar världens synd”, se Joh 1:29. Då blev Mose vred på Elazar och Itamar, Arons kvarvarande söner, och sa: ");
INSERT INTO swe_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","”Varför har ni inte ätit syndoffret på en helig plats? Det är högheligt, och det har getts till er att bära församlingens överträdelser, att bringa försoning för (täcka över) dem inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Se blodet av det fördes inte in i den heliga platsen, ni skulle verkligen ha ätit det på en helig plats som jag befallde. ");
INSERT INTO swe_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Och Aron talade till Mose: ”Se, denna dag har de offrat sina syndoffer och sina brännoffer inför Herrens (Jahvehs) ansikte, och sådana saker har hänt Nadav och Avihos förseelse och om jag hade ätit syndoffret idag, skulle det ha blivit accepterat i Herrens (Jahvehs) ögon? ");
INSERT INTO swe_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","När Mose hörde detta var han tillfreds. ");
INSERT INTO swe_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Herren (Jahveh) talade till Mose och Aron och sa till dem: ");
INSERT INTO swe_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Tala till Israels söner och säg: Detta är de djur som ni ska äta av alla de djur som vandrar omkring på jorden. ");
INSERT INTO swe_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alla som har klövar, som är kluvna helt igenom, och som också idisslar (för upp mat – hebr. maale gera), dem ska ni äta. Boskapsdjur, får och getter är partåiga hovdjur, vars klövar är delade i två. Detta är djur som idisslar och har ett komplext magsystem med tre eller fyra kammare. I 5 Mos 14:4-6 nämns totalt tio djur, både boskap och vilda, som är rena. Många olika förslag på vad som gör djuren rena/orena har getts. Det finns flera rent praktiska implikationer som att griskött innehåller trikiner, osv. Men kanske den enklaste förklaringen är att ”israeliternas matsedel” också ska likna ”Guds diet”. Om det inte kunde offras till Gud, då var det inte heller lämpligt att äta. Reglerna kring vad som fick ätas gjorde att israeliterna särskilde sig från andra folk. Det var svårt att ha gemenskap om man inte kunde äta tillsammans, se även Mark 7:19; Apg 10:13, 15, 28. Dessa dietbud har likheter med budet Adam och Eva fick att inte äta från ett visst träd, se 1 Mos 3:2. ");
INSERT INTO swe_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Men dessa ska ni inte äta av dem som idisslar eller av dem som har delade klövar: kamelen för den idisslar men har inte delade klövar, den är oren för er, ");
INSERT INTO swe_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","och klippgrävlingen klippdassen, klipphyraxen – hebr. shafan, för den idisslar men har inte delade klövar, den är oren för er, ");
INSERT INTO swe_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","och harhonan (hebr. arnevet) för den idisslar men har inte delade klövar, den är oren för er, ");
INSERT INTO swe_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","och grisen, den har delade klövar men den drar inte in mat genom halsen (idisslar inte – hebr. gera lo jigar), den är oren för er. Identifieringen av shafan och arnevet som klippgrävling (klipphyrax) och haren är inte helt kartlagd. Det hebreiska ordet shafan kommer från ett verb som betyder att täcka och gömma. På beskrivningen är det ett skyggt djur som ”gömmer sig” och bor i marken. Den maskulina formen är arnav har att göra med jord, och beskriver ett djur som rör sig på marken. Intressant nog används den feminina formen för honan. En tolkning är att vers 5-6 identifierar en och samma art – hanen och honan.  Ett problem med identifieringen är att varken klipphyraxen eller haren idisslar, enligt Carl von Linnés definition. Dock har haren två typer av avföring. Den första typen är mjuk och har näring kvar. Den äts upp igen av haren och då skapas den andra typen av avföring som är de hårda kulorna som vi ser som harspillning. Klipphyraxens mage är uppdelad i tre avdelningar som processar maten i flera steg. Uttrycket maale gera har använts fem ggr (vers 3, 4, 5, 6) och översätts med ”idissla”, men här den sjätte gången för grisen (vers 7) används en annan fras (hebr. gera lo jigar) som är mer generell att föra in mat genom halsen. Genom att Bibeln använder båda dessa två termer vidgas Bibelns definition av vad idissla är, vilket kan inkludera klippgrävlingens och harens beteende, även om de i modern klassificering av djur inte räknas som idisslare. ");
INSERT INTO swe_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Av deras kött ska ni inte äta och deras kadaver ska ni inte vidröra, de är orena för er. ");
INSERT INTO swe_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Detta ska ni äta av allt som finns i vattnet. Allt som har fenor och fjäll i vattnet, i haven och i floderna, det ska ni äta. ");
INSERT INTO swe_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Och allt som inte har fenor och fjäll i haven och i floderna och allt som rör sig i vattnen, och av alla levande ting som finns i vattnen, de ska vara något avskyvärt (hebr. shiqats) för er. ");
INSERT INTO swe_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","De ska vara något avskyvärt för er, ni ska inte äta av dess kött utan ni ska se dess kadaver som något avskyvärt. ");
INSERT INTO swe_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Vad det än må vara som inte har fenor och fjäll i vattnet ska vara något avskyvärt för er. Det finns olika hebreiska ord för fåglar. I 1 Mos 1:20 och här används hebr. of som beskriver något som flyger. (I parallellpassagen i 5 Mos 14:11 används tsipor som är ett ljudhärmande ord för det kvittrande lätet). Inom den moderna biologins systematik av organismer klassificeras fladdermusen (vers 19) inte som en fågel utan som ett däggdjur. Uppräkningen här uppfyller dock de hebreiska ordens betydelser. Bland de rena fåglarna räknas: höns, duva, anka, gås, ripa, vaktel, kalkon, osv. ");
INSERT INTO swe_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Och dessa är de som ni ska betrakta som något avskyvärt bland fåglarna, dem ska ni inte äta, de är något avskyvärt 20 sorters flygande varelser som är orena räknas nu upp: örnen och lammgamen och fiskgjusen ");
INSERT INTO swe_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","och slagfalken och gladan (höken) enligt sitt slag (sin art; klassificering – hebr. min), ");
INSERT INTO swe_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","alla korpar enligt sitt slag, ");
INSERT INTO swe_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","och strutshonan hebr. bat jaana och nattskärran och måsen och höken enligt sitt slag, ");
INSERT INTO swe_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","och minervaugglan en liten uggla; hebreiska ordet delar rot med kopp/bägare och skarven och ökenuven ");
INSERT INTO swe_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","och ibisen och pelikanen och smutsgamen ");
INSERT INTO swe_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","och storken och hägern enligt sitt slag, och härfågeln (hebr. dochifat) och fladdermusen. Ordet för härfågel delar rot med ord som betyder stöts, slå eller krossa. Det kan syfta på härfågelns läte; ett stötvis upprepat trestavigt ”oop-oop-oop”. Härfågeln är en relativt liten och iögonfallande vacker fågel som i modern tid har utsetts till Israels nationalfågel! Ordet dochifat betyder än idag härfågel. Det är dock tveksamt om ordets betydelse passar på härfågeln, en relativt liten fågel som knappast förknippas med att stöta eller krossa på något sätt. Kanske det istället är hackspettar som avses? Dessa har ju beteendet att hacka i träd, vilket kan ses som en form av att stöta, slå och krossa. I så fall är den aktuella arten i området balkanspett. ");
INSERT INTO swe_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alla bevingade (flygande) småkryp som går med fyra framfötter ska vara något avskyvärt för er. ");
INSERT INTO swe_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Men dessa bevingade (flygande) småkryp som går med fyra framfötter, som har två ben intill sina fyra fötter, som hoppar över jorden. Hebreiskan är väldigt exakt i sin beskrivning. Prepositionen ”fram/på” används för de fyra insekternas fyra ”fötter” (hebr. regel) i vers 21 och sedan beskrivs två kraftigare ben (hebr. kera) som den hoppar med. Totalt är det alltså sex fötter och två ben, vilket korrekt beskriver de sex gångbenen på denna grupp av insekter. ");
INSERT INTO swe_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Av dem kan ni äta dessa, den svärmande gräshoppan enligt sitt slag, den förtärande gräshoppan enligt sitt slag, och skalbaggen enligt sitt slag, och gräshoppan enligt sitt slag. ");
INSERT INTO swe_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Men alla bevingade (flygande) småkryp som har fyra fötter fram ska vara något avskyvärt för er. ");
INSERT INTO swe_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Och för dessa ska ni vara orena, vemhelst som kommer i beröring med deras kadaver ska vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Och den som bär ett kadaver av dem ska tvätta sina kläder och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Kadavret av varje djur som har delade klövar men inte idisslar är orena för dig, alla som berör dem ska vara orena. ");
INSERT INTO swe_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Och vadhelst som går på sina tassar bland alla slags fyrbenta djur, dessa är orena för er, vemhelst som kommer i beröring med dess kadaver ska vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Och han som lyfter (bär bort) ett kadaver av dem ska tvätta sina kläder och vara oren till kvällen, de är orena för er. ");
INSERT INTO swe_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Dessa ska också vara orena för er bland de krypande tingen som kryper över jorden: vesslan och musen och sköldpaddan enligt sitt slag, ");
INSERT INTO swe_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","och snoken och kameleonten och ödlan och snigeln och mullvaden. ");
INSERT INTO swe_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Dessa är orena för er bland allt som kryper, vemhelst som rör dem när de är döda ska vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Och vad som helst som råkar ramla på dem när de är döda ska vara orent, om det är ett redskap av trä eller kläder eller skinn eller säcktyg, vilket redskap det må vara som man gör något arbete med, det måste läggas i vatten och ska vara orent till kvällen, så ska det bli rent. ");
INSERT INTO swe_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Och alla lerkärl som de faller ner i, oavsett vad det innehåller, ska vara orent och ni ska krossa det. ");
INSERT INTO swe_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Och allt kött som man kan äta varpå sådant vatten kommer ska vara orent, och all dryck som man kan dricka i varje sådant kärl ska vara oren. ");
INSERT INTO swe_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Och varje ting varpå någon del av deras kadaver faller ska vara orent, oavsett om det är ugnen eller olika sorters krukor så ska de krossas, för de är orena och ska vara orena för dig. ");
INSERT INTO swe_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Men en källa (ett friskt källflöde – hebr. majan) eller brunn (hebr. bor) med samlat (hebr. miqveh) vatten ska vara ren, bara det som kommer i beröring med kadavret ska vara orent. För första gången i kapitlet nämns nu något som ska vara rent! Ordet att orena (hebr. tame) har använts 19 ggr hittills i kapitlet, men här kommer det efterlängtade ordet ren (hebr. tahor). Reningen finns i ett flödande ”levande” vatten. Det finns alltså hopp om att orenheten ska tvättas bort. Ordet miqveh används för den bassäng som kom att användas för rituella reningsdop. Samma ord miqveh översätts också med hopp, se Esra 10:2. Rotordet är qavah vars betydelse är att vänta och tvinna sig samman. Det finns hopp att orenheten ska bli ren, och profeten Jeremia använder uttrycket Israels hopp (hebr. Jisrael Miqveh) om Messias, se Jer 14:8; 17:13. ");
INSERT INTO swe_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Och om någon del av kadavret faller på något utsäde som ska sås så ska det vara rent. ");
INSERT INTO swe_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Men om något vatten hälls över säden och någon del av kadavret faller på den då ska den vara oren för dig. Anledningen kan vara att det blöta spannmålet var förberett för att användas i matlagning och bak, medan det torra inte var det. ");
INSERT INTO swe_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Och om något djur som man kan äta av dör, ska den som rör dess kadaver vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Och den som äter av dess kadaver ska tvätta sina kläder och vara oren till kvällen, också den som burit kadavret ska tvätta sina kläder och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Och alla krypande ting som kryper över jorden ska vara något avskyvärt, det ska inte ätas. ");
INSERT INTO swe_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Vadhelst som går på buken och vadhelst som går på alla fyra eller vadhelst som har fler ben bland alla krypande ting som kryper över jorden, de ska ni inte äta, för de är något avskyvärt. ");
INSERT INTO swe_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ni ska inte göra er själva styggelser med något krypande ting som kryper, inte heller ska ni göra er själva orena med dem, så att ni blir orena. ");
INSERT INTO swe_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","För jag är Herren er Gud (Jahveh Elohim), ni ska därför helga er själva och vara heliga, för jag är helig. Ni ska inte orena er själva på något sätt med något krypande ting som kryper över jorden. ");
INSERT INTO swe_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","För jag är Herren (Jahveh) som för er ut ur Egyptens land för att vara er Gud (Elohim). Ni ska därför vara heliga, för jag är helig. ");
INSERT INTO swe_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Detta är undervisningen om: djur (boskap, fyrfotadjur) vers 2-8 och om flygande varelser vers 13-19 och om alla levande varelser som rör sig i stora stim i vattnen vers 9-12 och om alla varelser som kryper på (svärmar över) jorden insekter, vers 20-23 ");
INSERT INTO swe_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","För att göra åtskillnad mellan det orena och det rena och mellan djur som kan ätas och djur som inte kan ätas. Primärt har denna distinktion att göra med att särskilja det judiska folket, se Rom 14:3-15; Apg 10:9-29. Jesus förklarar all mat ren, se Mark 7:19. ");
INSERT INTO swe_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Tala till Israels söner och säg: Om en kvinna har blivit gravid och föder (blivit befruktad och fött) en pojke, då ska hon vara oren i sju dagar enligt dagarna för avskiljning för hennes menstruation ska hon vara oren. ");
INSERT INTO swe_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Och på den åttonde dagen ska han omskäras (ordagrant: ska köttet på hans förhud omskäras) 1 Mos 17:10-14 ");
INSERT INTO swe_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","33 dagar ska hon sedan fortsätta med sin blodrening. Hon ska inte vidröra några heliga föremål och inte komma till tabernaklet förrän hennes reningsdagar är fullbordade. ");
INSERT INTO swe_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Men om hon föder en flicka ska hon vara oren två veckor som under sin menstruation och 66 dagar ska hon fortsätta med sin blodrening. ");
INSERT INTO swe_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Och när dagarna för hennes rening är fullbordade, för en son eller för en dotter, ska hon föra fram ett årsgammalt lamm som brännoffer 3 Mos 1:1-17 och en ung duva eller turturduva som syndoffer reningsoffer, se 3 Mos 4:3 vid ingången till mötestältet, till prästen ");
INSERT INTO swe_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","som ska offra det inför Herrens (Jahvehs) ansikte och bringa försoning för henne. Och hon ska vara ren från sitt blod. Detta är undervisningen om henne som har fött en pojke eller flicka. ");
INSERT INTO swe_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Om hon inte kan föra fram ett lamm ska hon föra fram två duvor eller två unga turturduvor, den ena som brännoffer, den andra som syndoffer och prästen ska bringa försoning för henne och hon ska vara ren. Det var detta offer Jesu mor Maria (Mirjam) offrade, se Luk 2:22-24. ");
INSERT INTO swe_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Följande stycke (kap 13-14) handlar om hudsjukdomar och mögel på textilier eller husväggar. Det hebreiska ordet som används är tsaraat som beskriver olika yttringar av mögelsvamp.  Eftersom den grekiska översättningen Septuaginta använde det grekiska ordet lepra, kom termen att förknippas med det engelska ordet ”leprosy” och sjukdomen spetälska (även kallad lepra eller Hansens sjukdom). Det grekiska ordet användes om fiskfjäll och beskriver också hud som flagar. Sjukdomen lepra påverkar förvisso huden, men det hebreiska ordet (och även det grekiska) är en generell term för verkningarna orsakade av mögelsvamp. Drabbas någon av tsaraat på huden (människans utsida) brukar vi kalla det en svampinfektion, däremot om det är kläder/textilier eller hus/husväggar som drabbas används ordet mögel. Kärnbibeln använder båda dessa ord. Följande personer i GT drabbades av denna sjukdom, förutom Mose (2 Mos 4:6) och fyra män (2 Kung 7:3): Mirjam (4 Mos 12:10), Ussia (2 Kung 15:5), Naaman (2 Kung 5:1) och Gechasi (2 Kung 5:27).  I den judiska traditionen är denna åkomma en varning eller ett straff från Gud för den som ägnar sig åt skvaller eller förtal. Att bli isolerad och inte kunna samtala med någon är ett lämpligt straff för den som har en ”ond tunga” (hebr. lashon hara) – ett uttryck som också brukar översättas med just skvaller eller förtal, se Ps 34:14. Mirjam drabbades av tsara när hon talade illa om sin bror Mose, se 4 Mos 12:1, 10.  På samma sätt när denna åkomma drabbar ett hus så anses det vara en varning eller ett straff för den som är snål eller ohjälpsam och inte vill dela med sig eller låna ut till sin medmänniska. Här handlar straffet om att man måste ställa ut samtliga ägodelar till allmänt beskådande utanför huset under minst en vecka (3 Mos 14:36). Då är det lätt att se om man har ljugit och sagt att man inte har det som någon annan behöver eller om man säger att man själv är fattig fast man egentligen inte är det. Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","När en människa får på huden på sin kropp (sitt kött) något som reser sig (en svullnad) eller ett utslag (skabb) eller en ljus fläck och det är på hans hud på hans kropp (kött) som en fläck med svampinfektion (mögel – hebr. tsaraat), då ska han föras fram till prästen Aron eller till en av hans söner, prästerna. ");
INSERT INTO swe_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Och prästen ska titta på fläcken på huden på kroppen (köttet), och om håret i fläcken har blivit vitt och om fläcken ser djupare ut än huden på hans kropp är det en fläck med svampinfektion (mögel), och prästen ska se på (undersöka) honom och förklara honom oren. ");
INSERT INTO swe_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Om den ljusa fläcken blir vit i huden på hans kropp och inte ser djupare ut än huden och om håret på den inte blir vitt, då ska prästen stänga in (isolera) honom som har fläcken i sju dagar. Den initiala tiden för karantän var alltid en vecka när orsaken till sjukdomen inte var uppenbar. ");
INSERT INTO swe_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Och prästen ska se på (undersöka) honom den sjunde dagen, och se, om fläcken är oförändrad när han ser på (undersöker) den och fläcken inte har spridit sig på huden, då ska han stänga in (isolera) honom i ytterligare sju dagar. Totalt två veckors karantän. ");
INSERT INTO swe_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Och prästen ska se på (undersöka) honom en andra gång den sjunde dagen, och se, om fläcken har blivit mörk och fläcken inte har spridit sig på huden, ska prästen förklara honom ren, då är det en sårskorpa och han ska tvätta sina kläder och vara ren. ");
INSERT INTO swe_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Men om sårskorpan sprider ut sig i huden efter det att prästen har synat honom för hans rening, då ska han synas av prästen ännu en gång. ");
INSERT INTO swe_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Och om prästen ser att fläcken har spridit sig på huden, då ska prästen förklara honom oren, det är en svampinfektion (mögel). ");
INSERT INTO swe_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","När fläcken med svampinfektion (mögel) finns på en människa, då ska han bli förd till prästen, ");
INSERT INTO swe_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","och prästen ska se på (undersöka) honom, och se om upphöjningen är vit i huden och om håret har blivit vitt och det finns friskt kött i upphöjningen, ");
INSERT INTO swe_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","då är det en gammal svampinfektion (mögel) på huden på hans kött och prästen ska förklara honom oren, och han ska inte stänga in (isolera) honom för han är oren. ");
INSERT INTO swe_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Och om svampinfektionen (möglet) sprider ut sig på huden och svampinfektionen (möglet) täcker hela hans hud som har fläcken, från hans huvud till hans fötter, oavsett var prästen ser (undersöker), ");
INSERT INTO swe_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","då ska prästen överväga och se om svampinfektionen (möglet) täcker hela hans kropp (kött). Han ska förklara honom ren som har plågan, allt har blivit vitt, han är ren. ");
INSERT INTO swe_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Men när det friska köttet visar sig på honom ska han vara oren. ");
INSERT INTO swe_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Och prästen ska se på (undersöka) det friska köttet och förklara honom oren, för det friska köttet är orent, det är svampinfektion (mögel). ");
INSERT INTO swe_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Om det friska köttet vänder igen och ändras till vitt, ska han komma till prästen. ");
INSERT INTO swe_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Och prästen ska se på (undersöka) honom, och se om fläcken har blivit vit, då ska prästen förklara honom ren som har haft fläcken – han är ren. Job drabbades av bölder, se Job 2:7 och en av de tio plågorna över Egypten var bölder, se 2 Mos 9:9-11. ");
INSERT INTO swe_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Och köttet där det i dess hud fanns en böld, är botat. ");
INSERT INTO swe_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Och om det på platsen för bölden istället finns en vit upphöjning, eller en ljus fläck, vit och något rödaktig, och den visas för prästen, ");
INSERT INTO swe_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","och om prästen när han ser (undersöker) den och den ser lägre ut än huden och dess hår har blivit vitt, ska prästen förklara honom oren, det är en fläck med svampinfektion (mögel) som har brutit ut från bölden. ");
INSERT INTO swe_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Men om prästen ser på (undersöker) den och ser att där inte finns några vita hår och om det inte är lägre än huden men är mörkare, då ska prästen stänga in (isolera) honom i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Och om det sprider ut sig i huden ska prästen förklara honom oren, det är en plåga (sjukdom). ");
INSERT INTO swe_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Men om de ljusa fläckarna stannar på sin plats och inte breder ut sig är det en böld och prästen ska förklara honom ren. ");
INSERT INTO swe_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Om det finns något kött i huden som är brännskadat av eld, och det friska köttet med brännsåret har en vit ljus fläck, rödaktig eller vit, ");
INSERT INTO swe_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","då ska prästen se på (undersöka) den och se om håret på den ljusa fläcken har blivit vitt och se (undersöka) om fläcken är lägre än huden. Då är det en svampinfektion (mögel) som har brutit ut i brännsåret, därför ska prästen förklara honom oren. Det är en fläck med svampinfektion (mögel). ");
INSERT INTO swe_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Men om prästen ser på (undersöker) den och ser att där inte finns några vita hår och att det inte är lägre än huden men är mörkare, då ska prästen stänga in (isolera) honom i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Och prästen ska se på (undersöka) honom den sjunde dagen, och om det har spridit ut sig över huden ska prästen förklara honom oren. Det är en fläck med svampinfektion (mögel). ");
INSERT INTO swe_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Men om den ljusa fläcken stannar på sin plats och inte sprider sig i huden men är lite mörkare, då är det en upphöjd brännskada och prästen ska förklara honom ren, för det är en inflammation i brännskadan. ");
INSERT INTO swe_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Om en man eller kvinna har en fläck på huvudet eller i skägget, ");
INSERT INTO swe_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","då ska prästen se på (undersöka) fläcken och se om den ser djupare ut än huden och om där finns gult tunt hår, då ska prästen förklara honom oren. Det är torra fjäll och svampinfektion (mögel) på huvudet eller i skägget. ");
INSERT INTO swe_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Och om prästen ser fläcken med fjäll och ser att den inte är djupare än huden och att det inte finns några svarta hår i den, då ska prästen stänga in (isolera) den som har fläcken med fjäll i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Och på sjunde dagen ska prästen se på (undersöka) fläcken och se om fjällen inte har spridit sig och om det inte finns något gult hår och om fjällen inte ser ut att ligga djupare än huden. ");
INSERT INTO swe_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Han ska bli rakad men fjällen ska han inte raka, och prästen ska stänga in (isolera) honom i ytterligare sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Och på sjunde dagen ska prästen se på (undersöka) fjällen, och se, om fjällen inte har spridit sig i huden och om de inte ser ut att vara djupare än huden, då ska prästen förklara honom ren och han ska tvätta sina kläder och vara ren. ");
INSERT INTO swe_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Men om fjällen sprider ut sig på huden efter tvättningen, ");
INSERT INTO swe_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ska prästen se på (undersöka) honom och se om fjällen har spridit sig på huden, prästen ska inte leta efter gula hår. Han är oren. ");
INSERT INTO swe_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Men om fjällen när han ser dem har stannat och det finns svarta hår som vuxit upp där, då är fjällen botade, han är ren och prästen ska förklara honom ren. ");
INSERT INTO swe_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Om en man eller kvinna har ljusa fläckar på huden på sin kropp, vita ljusa fläckar, ");
INSERT INTO swe_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","då ska prästen se på (undersöka) och se om de ljusa fläckarna på huden på deras kropp är mörkare vita. Då är det en frätande fläck som växer på huden. Han är ren. ");
INSERT INTO swe_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Den man vars hår faller av hans huvud han är skallig men han är ren. ");
INSERT INTO swe_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Och han vars hår faller av från delar av hans huvud mot ansiktet, han är pannskallig, men han är ren. ");
INSERT INTO swe_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Och om det på det skalliga huvudet eller på den skalliga pannan blir ett vitt rödaktigt sår är det en svampinfektion (mögel) som kommit fram på hans skalliga huvud eller hans skalliga panna. ");
INSERT INTO swe_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Då ska prästen se på (undersöka) och se om det upphöjda såret är vitt rödaktigt på hans skalliga huvud eller hans skalliga panna, som en svampinfektion (mögel) visar sig i huden på kroppen, ");
INSERT INTO swe_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","han är en man som lider av svampinfektion (mögel). Han är oren. Prästen ska förklara honom totalt oren (orent oren), hans fläck är på hans huvud. Detta sammanfattande stycke berör de som har blivit diagnostiserade med någon av de ovanstående sju olika fallen. ");
INSERT INTO swe_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Och den som lider av svampinfektionen (möglet), hans kläder ska rivas söner och hans huvud rakas, och han ska täcka över sin överläpp och ropa ”Oren, oren”. Hebr. tame tame! ");
INSERT INTO swe_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Alla dagar som fläcken är på honom ska han vara orenad. Han är oren. Han ska bo ensam (isolerad), utanför lägret ska han ha sin boplats. ");
INSERT INTO swe_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kläderna som plågan med möglet (svampinfektionen) är i, oavsett om det är yllekläder eller linnekläder, ");
INSERT INTO swe_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","om det är vävt eller stickat, av linne eller av ull, oavsett det är skinn eller någonting tillverkat av skinn, ");
INSERT INTO swe_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","och om fläcken är grönaktig eller rödaktig i kläderna eller på skinnet, på det vävda eller på det stickade eller på någonting tillverkat av skinn, är det en fläck med mögel (svampinfektion) och ska visas för prästen. ");
INSERT INTO swe_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Och prästen ska se på (undersöka) fläcken och stänga in (isolera) det som har fläcken i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Och han ska se på (undersöka) fläcken den sjunde dagen. Om fläcken har spridit sig i kläderna, antingen i det vävda eller i det stickade eller på skinnet eller i någonting som är tillverkat av skinn, då är fläcken ett frätande mögel (svampinfektion). Det är orent. ");
INSERT INTO swe_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Han ska därför bränna den klädnaden, oavsett om det är vävt eller stickat, av ull eller linne eller någonting av skinn där fläcken är ett frätande mögel (svampinfektion). Det ska brännas i eld. ");
INSERT INTO swe_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Men om prästen ser på (undersöker) och ser att fläcken inte har spridit sig i klädnaden, varken i det vävda eller i det stickade eller i någonting av skinn, ");
INSERT INTO swe_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","då ska prästen befalla att de tvättar det som fläcken varit på och han ska stänga in (isolera) det i ytterligare sju dagar. Totalt två veckors karantän. ");
INSERT INTO swe_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Och prästen ska se på (undersöka) fläcken efter att den är tvättad och se om färgen inte har förändrats och om fläcken inte har spritt ut sig, är den oren. Du ska bränna den i eld. Den fräter inåt antingen den är inuti eller utanpå. ");
INSERT INTO swe_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Men om prästen ser på (undersöker) och ser att fläcken har mörknat efter att den har tvättats, då ska han riva ut den ur plagget eller ur skinnet eller ur väven eller ur det stickade. ");
INSERT INTO swe_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Och om det fortfarande syns i klädnaden eller i det vävda eller i det stickade eller i någonting av skinn, då är det en fläck som sprider sig. Du ska bränna det som har fläcken med eld. ");
INSERT INTO swe_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Och klädnaden, vävd eller stickad eller vad som än är tillverkat av skinn, det som du ska tvätta, om fläcken försvinner från det, då ska det tvättas en andra gång och det ska vara rent. ");
INSERT INTO swe_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Detta är undervisningen om fläckar med mögel (svampinfektion) i kläder av ull eller linne, antingen det är vävt eller stickat, och om allting av skinn, för att förklara det rent eller för att förklara det orent. ");
INSERT INTO swe_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Detta är undervisningen för den som lidit av svampinfektionen (möglet – hebr. tsaraat) under dagarna för hans rening. Han ska föras till prästen, ");
INSERT INTO swe_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","och prästen ska komma ut från lägret och se på (undersöka) och se om fläcken med svampinfektion (mögel) är botad från svampinfektionen (möglet). ");
INSERT INTO swe_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Sedan ska prästen befalla att man tar till den som blivit ren, två fåglar, levande och rena och cederträ och karmosinröd färg hebr. toleah – färgämnet från den torkade kroppen av honan av masken coccus ilicis, se Ps 22:6 och isop. ");
INSERT INTO swe_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Och prästen ska befalla att en av fåglarna dödas i ett lerkärl över rinnande vatten. ");
INSERT INTO swe_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sedan ska han ta den levande fågeln och cederträet och det röda och isopen och ska doppa det och den levande fågeln i blodet från fågeln som dödades över det rinnande vattnet. ");
INSERT INTO swe_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Och han ska stänka det sju gånger över den som blivit fri från svampinfektionen (möglet) och han ska förklara honom ren och ska låta den levande fågeln flyga iväg över det öppna fältet (ordagrant över fältets mun). ");
INSERT INTO swe_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Och den som har blivit ren ska tvätta sina kläder och raka av allt sitt hår och tvätta sig själv i vatten så att han blir ren, och därefter ska han komma in i lägret och ska stanna utanför sitt tält i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Men på den sjunde dagen ska han raka av allt sitt hår och sitt skägg och sina ögonbryn, allt hår ska han raka av, och han ska tvätta sina kläder och han ska tvätta sin kropp och han ska vara ren. ");
INSERT INTO swe_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","På den åttonde dagen ska han ta två felfria lamm av hankön och ett lamm av honkön som är årsgammalt och felfritt, och tre tiondelars av ett efa mått av fint mjöl för ett matoffer blandat med olja och ett mått olja 0,3 liter. ");
INSERT INTO swe_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Och prästen som ska göra honom ren ska ställa fram mannen som ska bli ren och dessa ting inför Herrens (Jahvehs) ansikte vid dörren till mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Och prästen ska ta ett av lammen av hankön och offra det som ett skuldoffer och måttet av olja och vifta dem som ett viftoffer inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Och han ska slakta lammet på platsen där han ska döda syndoffret och brännoffret, på en helig plats, för liksom syndoffret är prästens så är även skuldoffret. Det är högheligt. ");
INSERT INTO swe_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Och prästen ska ta en del av blodet från skuldoffret och prästen ska stryka det på den högra örsnibben på honom som ska bli ren och på tummen på hans högra hand och på stortån på hans högra fot. 3 Mos 8:23 ");
INSERT INTO swe_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Och prästen ska ta en del av oljan och hälla den i sin vänstra handflata, ");
INSERT INTO swe_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","och prästen ska doppa sitt högra finger i oljan som är i hans vänstra hand och ska stänka av oljan med sitt finger sju gånger inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Och resten av oljan som är i hans hand ska prästen stryka på den högra örsnibben på honom som ska bli ren och på tummen på hans högra hand och på stortån på hans högra fot ovanpå blodet från skuldoffret. ");
INSERT INTO swe_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Och resten av oljan som är i prästens hand ska han hälla över huvudet på honom som ska bli ren och prästen ska bringa försoning för honom inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Och prästen ska offra syndoffret och bringa försoning för honom som ska bli ren från sin orenhet och efteråt ska han döda brännoffret. ");
INSERT INTO swe_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Och prästen ska offra brännoffret och matoffret ovanpå altaret och prästen ska bringa försoning för honom och han ska vara ren. ");
INSERT INTO swe_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Och om han är fattig och inte kan ge så mycket då ska han ta ett lamm som skuldoffer som ska viftas för att bringa försoning för honom och en tiondels fint mjöl blandat med olja som ett matoffer och ett mått olja. ");
INSERT INTO swe_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Och två turturduvor eller två unga duvor som han har möjlighet att ge, och den ena ska vara till syndoffer och den andra till brännoffer. ");
INSERT INTO swe_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Och han ska föra fram dem till prästen på den åttonde dagen för sin rening, till dörren på mötestältet inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Och prästen ska ta lammet till skuldoffer och måttet med olja och prästen ska vifta dem som ett viftoffer inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Och han ska döda lammet till skuldoffer och prästen ska ta en del av blodet från skuldoffret och stryka det på den högra örsnibben på honom som ska bli ren och på tummen på hans högra hand och på stortån på hans högra fot. ");
INSERT INTO swe_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Och prästen ska hälla av oljan i handflatan i sin vänstra hand, ");
INSERT INTO swe_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","och prästen ska stänka med sitt högra finger en del av oljan som är i hans vänstra hand sju gånger inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Och prästen ska ta av oljan som är i hans hand och stryka på den högra örsnibben på honom som ska bli ren och på tummen på hans högra hand och på stortån på hans högra fot ovanpå platsen med blodet från skuldoffret. ");
INSERT INTO swe_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Och resten av oljan som är i prästens hand ska han hälla över huvudet på honom som ska bli ren och prästen ska bringa försoning för honom inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Och han ska offra den ena turturduvan eller unga duvan, vilket han kan ge, ");
INSERT INTO swe_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","efter vad han har möjlighet att ge, den ena som syndoffer och den andra som brännoffer tillsammans med matoffret, och prästen ska bringa försoning för honom som ska bli ren inför Herrens (Jahvehs) ansikte. ");
INSERT INTO swe_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Detta är undervisningen om den som är drabbad av svampinfektion (mögel), vars hand inte har möjlighet att ge det som (egentligen) krävs för att bli ren. På samma sätt som textilier och kläder kunde drabbas av mögel (3 Mos 13:47-59), kunde även husets väggar drabbas. ");
INSERT INTO swe_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Och Herren (Jahveh) talade till Mose och till Aron och sa: ");
INSERT INTO swe_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","När ni kommer till Kanaans land som jag ska ge er som en besittning, och jag lägger fläckar av mögel (svampinfektion) på ett hus i landet för er besittning, ");
INSERT INTO swe_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","och den som äger huset ska komma och berätta för prästen och säga: ”Det ser ut som om det är fläckar i mitt hus.” ");
INSERT INTO swe_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Då ska prästen befalla att man tömmer huset innan prästen går in och ser (undersöker) fläckarna, så att allt som finns i huset inte blir orent, och därefter ska prästen gå in och se på (undersöka) huset. ");
INSERT INTO swe_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Och han ska se på (undersöka) fläckarna, om fläckarna finns på väggarna i huset med ihåliga stråk, grönaktiga eller rödaktiga, som ser ut att vara fördjupningar i väggen, ");
INSERT INTO swe_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","då ska prästen gå ut från huset till husets dörr och stänga (låsa) huset sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Och prästen ska komma tillbaka den sjunde dagen och ska låsa upp (öppna) och se (undersöka) om fläckarna har spridit sig på husväggarna. ");
INSERT INTO swe_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Då ska prästen befalla att man tar bort stenarna som fläcken finns på och man ska kasta dem på en oren plats utanför staden. ");
INSERT INTO swe_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Och han ska se till att huset blir skrapat inuti runt omkring och de ska hälla ut det lösa materialet putsen som de skrapat bort utanför staden på en oren plats. ");
INSERT INTO swe_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Och de ska ta andra stenar och sätta på platsen för dessa stenar och han ska ta annat murbruk och ska putsa (bokstavligt plåstra om) huset. ");
INSERT INTO swe_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Och om fläckarna kommer tillbaka igen och visar sig i huset efter det att han har tagit bort stenarna och efter att han har skrapat huset och efter att det är putsat, ");
INSERT INTO swe_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","då ska prästen komma och se (undersöka) och se om fläckarna har spridit sig i huset. Det är ett frätande mögel (svampinfektion) i huset. Det är orent. ");
INSERT INTO swe_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Och han ska bryta ner huset, dess stenar och dess timmer och allt murbruk från huset, och han ska bära bort det utanför staden till en oren plats. ");
INSERT INTO swe_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Dessutom ska den som har gått in i huset medan det varit stängt (låst) vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Och den som ligger i huset ska tvätta sina kläder och han som äter i huset ska tvätta sina kläder. ");
INSERT INTO swe_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Och om prästen kommer in och ser på (undersöker) den och ser att fläcken inte har spridit sig i huset efter att huset blivit putsat, då ska prästen förklara huset rent eftersom fläcken är botad. ");
INSERT INTO swe_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Och för att rena huset ska han ta två fåglar och cederträ och karmosinröd färg hebr. toleah – färgämnet från den torkade kroppen av honan av masken coccus ilicis, se Ps 22:6 och isop. ");
INSERT INTO swe_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Och han ska döda en av fåglarna i ett lerkärl över rinnande vatten. ");
INSERT INTO swe_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Och han ska ta cederträet och isopen och den karmosinröda färgen och den levande fågeln och ska doppa det i blodet från fågeln som dödades och i det rinnande vattnet och stänka det på huset sju gånger. ");
INSERT INTO swe_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Och han ska rena huset med blodet av fågeln och med det rinnande vattnet och med den levande fågeln och med cederträet och isopen och den karmosinröda färgen. ");
INSERT INTO swe_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Men han ska låta den levande fågeln flyga ut ur staden till det öppna fältet (ordagrant: över fältets mun) och bringa försoning för huset och det ska vara rent. ");
INSERT INTO swe_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Detta är undervisningen om alla sorters plågor (sjukdomar) med svampinfektion (mögel) och fjällighet, ");
INSERT INTO swe_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","och för mögel (svampinfektioner) på kläder och på hus, ");
INSERT INTO swe_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","och om upphöjningar och om fjällningar och om ljusa fläckar, ");
INSERT INTO swe_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","för att instruera om när (vilken dag) det är orent och när det är rent. Detta är undervisningen om mögel (svampinfektion – hebr. tsaraat). ");
INSERT INTO swe_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Och Herren (Jahveh) talade till Mose och till Aron och sa: ");
INSERT INTO swe_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Tala till Israels söner och säg till dem: När någon man (hebr. ish ish) har en flytning från sitt kött ofrivillig sädesuttömning, är han oren på grund av detta. Ordet kött (hebr. basar) används eufemistiskt till de manliga och kvinnliga könsorganen eller områdena av kroppen i detta kapitel. Se även Hes 16:26; 23:20. ");
INSERT INTO swe_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Och detta är hans orenhet i det här fallet, om hans kropp har en flytning eller hans kropp hindras från hans flytning, är det hans orenhet. ");
INSERT INTO swe_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Varje säng som han som har en flytning ligger på är oren, och varje möbel som han sitter på är oren. ");
INSERT INTO swe_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Och vemhelst som rör hans säng ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Och han som sitter på någonting som han med flytningen har suttit på, ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Och den som rör kroppen på honom som har en flytning ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Och om han som har en flytning spottar på honom som är ren, då ska han tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Och varje sadel som han som har en flytning rider på ska vara oren. ");
INSERT INTO swe_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Och vemhelst som vidrör något som varit under honom som har en flytning ska vara oren till kvällen, och han som har burit (flyttat på) något av dessa ting ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Och vemhelst som vidrör honom som har en flytning och inte har sköljt sina händer i vatten, han ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Och redskap av lera (keramik) som han med flytningen har kommit i beröring med ska krossas, och varje redskap av trä ska sköljas i vatten. ");
INSERT INTO swe_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Och när han som har flytningen är ren från sin flytning ska han räkna för sig själv sju dagar jfr 3 Mos 12:2; 13:4; 15:19 för sin rening och tvätta sina kläder och bada sig själv i rinnande vatten och ska vara ren. ");
INSERT INTO swe_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Och på den åttonde dagen ska han ta åt sig två turturduvor eller två unga duvor och komma inför Herrens (Jahvehs) ansikte till dörren på mötestältet och ge dem till prästen. ");
INSERT INTO swe_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Och prästen ska offra dem, den ena som syndoffer och den andra som brännoffer, och prästen ska bringa försoning för honom inför Herrens (Jahvehs) ansikte för hans flytning. ");
INSERT INTO swe_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Om någon mans säd lämnar honom (spills vid sidan) vid ett samlag, då ska han tvätta sin kropp i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Och varje plagg och varje skinn varpå (den spillda) säden från samlaget finns ska tvättas med vatten och vara orent till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Även kvinnan som mannen legat med när säden förspilldes, de ska båda bada sig själva i vatten och vara orena till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Om en kvinna har ett bekymmer och hennes bekymmer i kroppen är blod, ska hon vara avskild (separerad, isolerad) i sju dagar, och vemhelst som rör henne ska vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Allting som hon ligger på under sin avskildhet ska vara orent och allting som hon sitter på under sin avskildhet ska vara orent. ");
INSERT INTO swe_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Och vemhelst som rör hennes säng ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Och vemhelst som rör någonting som hon suttit på ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Och om det är på hennes säng eller någonting som hon suttit på, när han rör det är han oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Och om någon man ligger hos henne kommer hennes orenhet över honom, han ska vara oren i sju dagar, och hela sängen som han legat på ska vara oren. ");
INSERT INTO swe_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Om en kvinna har problem med sin menstruation många dagar utöver hennes avskildhet, eller om det rinner utöver tiden för hennes avskildhet, alla dagar av hennes orsak till orenhet ska vara som dagarna för hennes avskildhet. Hon ska vara oren. ");
INSERT INTO swe_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Varje säng som hon ligger i alla dagar som hennes blödning varar ska för henne vara som sängen för hennes avskildhet och allt som hon sitter på ska vara orent, liksom orenheten för hennes avskildhet. ");
INSERT INTO swe_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Och vemhelst som rör dessa ting ska vara oren och ska tvätta sina kläder och bada sig själv i vatten och vara oren till kvällen. ");
INSERT INTO swe_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Men om hon blir ren från sin blödning ska hon räkna sju dagar och sedan ska hon vara ren. ");
INSERT INTO swe_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Och på den åttonde dagen ska hon ta två turturduvor eller två unga duvor och föra dem till prästen till dörren på mötestältet. ");
INSERT INTO swe_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Och prästen ska offra den ena som syndoffer och den andra som brännoffer och prästen ska bringa försoning för henne inför Herrens (Jahvehs) ansikte för hennes orenhet med blödningen. ");
INSERT INTO swe_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Så ska ni avskilja Israels söner från deras orenhet för att de inte ska dö i sin orenhet när de befläckar mitt tabernakel bland dem. ");
INSERT INTO swe_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Detta är undervisningen om honom som har en flytning och om honom vars säd lämnar honom så att han blir oren av det, ");
INSERT INTO swe_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","och om henne som är oren av sin menstruation och om honom som har en flytning, om mannen och om kvinnan och om honom som ligger med henne som är oren. ");
INSERT INTO swe_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Herren (Jahveh) talade till Mose efter att Arons två söner Nadab och Abihu dött, när de offrade inför Herrens (Jahves) ansikte och dog 3 Mos 10:1-2, ");
INSERT INTO swe_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","och Herren (Jahveh) sa till Mose: Tala till Aron din bror, att inte komma när som helst in till den heliga platsen innanför förhänget 2 Mos 25:17-22, framför nådastolen som är ovanpå arken, så att han inte dör, för jag ska visa mig i molnet ovanpå nådastolen. Nådastolen var arkens lock med en 1,25 m lång och 0,75 m bred utsmyckning i rent guld, se 2 Mos 25:17. Fem djuroffer krävdes: en ung tjur, två getter och två baggar. ");
INSERT INTO swe_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Så ska Aron komma in till den heliga platsen: med en ung tjur, en tjurkalv (ordagrant: en son av boskapen), som syndoffer 3 Mos 4:3 och en bagge som brännoffer 3 Mos 1:1-17. ");
INSERT INTO swe_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Han ska klä sig i heliga linnekläder, han ska ha linnebyxor på sin kropp och ska vara omgjordad med en linnegördel och med en linneturban ska han vara klädd. Detta är de heliga kläderna, därför ska han tvätta sin kropp i vatten och sedan klä sig i dem. Översteprästen hade i vanliga fall en färggrann skrud med guld och ädelstenar, se 2 Mos 28:39-41; 39:29. De enklare vita linnekläderna var de övriga prästernas ämbetsdräkt. När nu översteprästen ska klä sig lika enkelt som alla andra präster, visar det profetiskt att Jesus måste bli som en av oss, sann människa, för att kunna ge oss försoningen. Heligheten förstärks också av att sju gånger i detta kapitel upprepas frasen ”för honom själv” när det gäller offer, se vers 6 (2 ggr), vers 11 (3 ggr), vers 17 och 24. ");
INSERT INTO swe_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Av Israels söners församling ska han ta två bockar till syndoffer och en bagge till brännoffer. ");
INSERT INTO swe_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aron ska offra sin syndofferstjur, som är för honom själv, och bringa försoning för sig själv och för sitt hushåll. ");
INSERT INTO swe_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Han ska ta två bockar och ställa fram dem inför Herrens (Jahvehs) ansikte, vid ingången till församlingens mötestält (tabernaklet). Denna vers visar profetiskt det som sker när Barabbas får byta plats med Jesus. Lotten kastas mellan två identiska getter. Barabbas betyder faderns son och Jesus är Faderns Son. Därför kan Jesus ta människans plats medan Barabbas får Jesu nåd, se Matt 27:15-26. ");
INSERT INTO swe_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aron ska kasta lott om de två bockarna, en lott för Herren (Jahveh) och en lott för syndabocken (hebr. azazel). Hebr. azazel antas komma från de hebreiska orden get (hebr. ez) och vända bort (hebr. azal). Så tolkar översättarna som översatte till grekiska 200 f.Kr. som valde översättningen ”getabocken som går bort”. En annan tolkning av ordet som ett abstrakt substantiv ”fullständigt ta bort”. Bocken som försvinner för gott och ses aldrig mer blir då en bild på synden som är helt borttagen. Inom judisk tradition tolkas azazel som en beskrivning på platsen dit bocken går (baserat på ordet gezerah i vers 22 som beskriver ett ”avhugget” land). En modernare judisk tolkning är en referens till en demon Azazel som nämns i Första Henoks bok (ca 300-100 f.Kr.), det finns dock inget i stöd i Bibeln för en sådan tolkning att demoner är involverade i att ta bort synd. ");
INSERT INTO swe_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aron ska föra fram den bock, över vilken Herrens lott fallit, och offra den som syndoffer. ");
INSERT INTO swe_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Men geten, på vilken lotten föll att bli en syndabock, ska ställas fram levande inför Herren, för att bringa försoning med den och låta den gå som syndabock ut i ödemarken (öknen). Ceremonin består av fyra huvuddelar:  1. En tjur offras som syndoffer för prästerna, se vers 11-14  2. En bock offras för folkets synd (Heb 9:21-22; 1 Tim 2:5), vers 15-17  3. Blandning av tjurens och getens blod, vers 18-19  4. Syndabocken sänds iväg, vers 20-22  Efter dessa fyra delar sker en avslutande del, se vers 23-28 ");
INSERT INTO swe_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aron ska föra fram syndofferstjuren som är för honom själv och ska bringa försoning för sig själv och för sitt hushåll och ska döda syndofferstjuren som är för honom själv. ");
INSERT INTO swe_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Han ska ta ett rökelsekar fullt med brinnande kol av eld från altaret inför Herrens ansikte och sina händer fulla av söt rökelse som finfördelats (malts) och föra det innanför förhänget. ");
INSERT INTO swe_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Han ska placera rökelsen ovanpå elden inför Herrens (Jahves) ansikte, så att molnet av rökelse kan täcka nådastolen som är ovanpå vittnesbördet (arken), så att han inte dör. ");
INSERT INTO swe_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Han ska ta av tjurens blod och stänka det med sitt finger ovanpå nådastolens ansikte österut och framför nådastolen ska han stänka av blodet med sitt finger sju gånger. Den östra sidan av nådastolen är dess framsida. Tabernaklet, och senare templet, placerades alltid så att ingången var vänd mot öster. Därav följer att även arken och nådastolen blir placerade så att de alltid vänds med framsidan mot öster. Därför kan man säga att Gud blickar österut när han sitter på nådastolen, kerubernas vingar är ju hans tron. Öster är ett väderstreck som inte bara betyder en viss riktning i förhållande till omgivningen. I detta ord, hebr. kedem, ligger många fler betydelser. Öster är ett av de två eviga väderstrecken, till skillnad från norr och söder som har sina begränsningar vid respektive pol. Öster handlar om det eviga perspektivet också på det sättet att det ser både bakåt och framåt samtidigt. Det är ett ord som knyter ihop tidens begränsning med evighetens gränslöshet. Det är också ett ord som handlar om möten, att möta sig själv och att möta Gud. Det är när man blickar bakåt ett ord som innebär att man gör bokslut med det som har varit. På samma sätt när man blickar framåt ser man profetiskt vad som ska komma. Det är även ett ord som talar om vägledning, vilket är precis det man får när man profetiskt blickar framåt. I förståelsen av ordet öster ligger inte bara människans möjlighet att se hela sitt liv, utan också förståelsen av Gud som den som står utanför tid och rum och ser allting samtidigt från sitt evighetsperspektiv. ");
INSERT INTO swe_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Sedan ska han prästen slakta folkets syndofferbock och bära in blodet bakom förhänget. Han ska göra på samma sätt som med tjurblodet: han ska stänka det ovanpå nådastolen och framför nådastolen. ");
INSERT INTO swe_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","På det sättet ska han rena det allra heligaste från Israels söners (folks) orenheter på grund av deras överträdelser i alla deras synder. På samma sätt ska han göra med församlingens mötestält uppenbarelsetältet, tabernaklet, som innehåller det heliga och allra heligaste som står mitt ibland dem och är omgivet av deras orenhet. ");
INSERT INTO swe_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ingen människa får vistas i församlingens mötestält när han Aron, översteprästen går in för att bringa försoning på den heliga platsen, till dess att han kommer ut och har bringat försoning för sig själv och för sitt hushåll och för hela Israels församling. ");
INSERT INTO swe_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Han ska gå ut till altaret som är framför Herren (Jahveh) och bringa försoning för det, och han ska ta av tjurens blod och av bockens blod och placera det ovanpå altarets horn runtom. 2 Mos 27:2. Altaret har fyra horn, ett i varje hörn. Hornen på altaret representerar makt. ");
INSERT INTO swe_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Han ska stänka av blodet ovanpå det med sitt finger sju gånger och rena det och helga det från Israels söners (folks) orenhet. ");
INSERT INTO swe_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","När han har avslutat försoningen av den heliga platsen och av församlingens mötestält och altaret, ska han föra fram den levande geten. ");
INSERT INTO swe_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aron ska lägga båda sina händer på den levande getens huvud och bekänna över den alla Israels folks missgärningar och alla deras överträdelser i alla deras synder och lägga dem på getens huvud och sända iväg den till ödemarken, i handen på en man som är redo någon som ska leda ut geten i ödemarken, det är öknen öster om Jerusalem. Här talas också profetiskt om vad som skulle ske med Jesus. När översteprästerna slår Jesus i ansiktet uppfylls denna förebild, se Matt 26:67; Mark 14:65; Joh 18:22. ");
INSERT INTO swe_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bocken ska bära alla deras missgärningar till ett obebott land, och han ska låta geten gå ut i ödemarken. ");
INSERT INTO swe_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aron ska komma in i församlingens mötestält och ska ta av sig linnekläderna som han tog på sig när han gick in till den heliga platsen och han ska lämna dem där. ");
INSERT INTO swe_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Han ska tvätta sin kropp med vatten på den heliga platsen och sätta på sig sina (egna) kläder och komma fram och offra sitt brännoffer och folkets brännoffer och bringa försoning för sig själv och för folket. ");
INSERT INTO swe_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Det feta av syndoffret ska han bränna på altaret. ");
INSERT INTO swe_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Den man som ledde ut syndabocken ska tvätta sina kläder och bada sin kropp i vatten och sedan komma in i lägret. ");
INSERT INTO swe_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Syndofferstjuren och syndoffersgeten vars blod bars in för att bringa försoning på den heliga platsen ska bäras bort utanför lägret, och de ska brännas i eld, deras hud och deras kött och deras avskräde (slaktrester). ");
INSERT INTO swe_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Den som bränner dem ska tvätta sina kläder och bada sin kropp i vatten och därefter ska han gå in i lägret. ");
INSERT INTO swe_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Detta ska vara en evig förordning (ordagrant ”saker inristat”) för er. I 7:e månaden på den 10:e dagen 10:e tishri, infaller i sept/okt ska ni rannsaka er själva ordagrant: ”ödmjuka era själar”; detta inkluderar ofta fasta, se Ps 35:13; Jes 58:3, 10 och inte utföra något arbete alls, oavsett om det är någon från ert eget land eller en främling som vistas bland er. ");
INSERT INTO swe_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","På den dagen ska översteprästen bringa försoning för er, för att rena er så att ni blir rena från alla era synder inför Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Det ska vara en sabbatsvila för er och ni ska rannsaka era själar. Det ska vara en evig förordning (ordagrant ”saker inristat”). Det ska vara en evig förordning (ordagrant ”saker inristat”) upprepas tre gånger, se vers 29, 31 och 34. När saker upprepas två gånger är det för att markera att det är extra viktigt. Här upprepas det tre gånger och därmed vet vi att det inte bara är något viktigt utan absolut nödvändigt. ");
INSERT INTO swe_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Översteprästen, som han ska smörja, och som han ska helga till tjänstgöring i översteprästens ämbete i sin fars ställe, ska bringa försoning och ska ta på sig linnekläder, de heliga kläderna. ");
INSERT INTO swe_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Han ska bringa försoning för den heliga helgedomen och han ska bringa försoning för församlingens mötestält och för altaret och han ska bringa försoning för översteprästen och för allt folket i församlingen. ");
INSERT INTO swe_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Detta ska vara en evig förordning (ordagrant ”saker inristat”) för er, för att bringa försoning för Israels söner (folk), för alla deras synder, en gång om året. Och han gjorde som Herren hade befallt Mose. ");
INSERT INTO swe_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Tala till Aron och hans söner och alla Israels söner och säg dessa ord till dem som Herren (Jahveh) har befallt. Säg: ");
INSERT INTO swe_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Om någon (ordagrant: ”och, man, man” – betonar att det är ett generellt förbud) av Israels hus slaktar en ko, ett lamm eller en get i eller utanför lägret, ");
INSERT INTO swe_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","och inte för fram djuret till mötestältets (hebr. óhel meed) ingång för att bära fram det som en offergåva åt Herren (Jahveh) framför Herrens (Jahvehs) tabernakel (hebr. miskan), ska det tillräknas den mannen som blodskuld. Han har spillt blod, och han ska utrotas ur sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Därför ska Israels barn komma med sina slaktdjur som de brukar slakta ute på marken, fram till Herren, till mötestältets ingång, till prästen, och slakta dem där som ett shalomoffer (gemenskapsoffer) åt Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Prästen ska stänka blodet på Herrens (Jahvehs) altare vid ingången till mötestältet och bränna fettet till en ljuvlig doft för Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","De ska inte mer offra sina slaktoffer till de håriga bockar (onda andar, satyrer, skogsdemoner – hebr. sair) som de i trolös avfällighet håller sig till. Detta ska vara en evig stadga för dem, från släkte till släkte. ");
INSERT INTO swe_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Och du ska säga till dem: Om någon (ordagrant: ”och, man, man”) av Israels hus eller av främlingarna som bor bland dem, offrar ett brännoffer eller ett slaktoffer ");
INSERT INTO swe_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","och inte för fram det till mötestältets ingång för att offra det åt Herren, ska den mannen utrotas ur sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Om någon (ordagrant: ”och, man, man”) av Israels hus eller av främlingarna som bor bland dem förtär något blod, ska jag vända mitt ansikte mot den som äter blodet 3 Mos 3:17 och utrota honom ur hans folk. ");
INSERT INTO swe_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","För kroppens (varje varelses) liv (själ) är i blodet, och jag har gett er det för altaret, för att bringa försoning för era liv (själar). Det är blodet som bringar försoning genom livet (själen) som är i det. ");
INSERT INTO swe_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Därför säger jag till Israels barn: Ingen av er ska äta blod. Främlingen som bor ibland er ska inte heller äta blod. ");
INSERT INTO swe_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Om någon (ordagrant: ”och, man, man”) av Israels barn eller av främlingarna som bor bland dem fäller ett villebråd av fyrfotadjur eller en fågel av det slag som får ätas, ska han låta blodet rinna ut och täcka över det med jord. ");
INSERT INTO swe_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","För varje kropps liv är dess blod. Därför säger jag till Israels barn: Ni ska inte äta någon kropps blod, för varje kropps liv är dess blod. Var och en som äter det ska utrotas. ");
INSERT INTO swe_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Och var och en som äter ett självdött eller ihjälrivet djur, vare sig han är infödd eller främling, ska tvätta sina kläder och bada sig i vatten och vara oren ända till kvällen. Då blir han ren. ");
INSERT INTO swe_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Om han inte tvättar sina kläder och badar sin kropp, kommer han att bära på skuld. ");
INSERT INTO swe_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Tala till Israels barn och säg till dem: Vers 2b-5 formar en kiasm där frasen ”Jag är Herren” både ramar in stycket och betonas centralt i vers 5. Orden göra/gör, påbud, förordningar och hålla är nyckelord som speglas i varje nivå. Jag är Herren (Jahveh), er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ni ska inte göra som man gör i Egypten, där ni har bott. Ni ska inte heller göra som man gör i Kanaans land, dit jag för er. Ni ska inte vandra i (leva efter) deras Egyptens och Kanaans stadgar (förordningar, ordagrant ”saker inristat” vilket indikerar permanenta lagar). ");
INSERT INTO swe_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mina påbud (bindande juridiska beslut) ska ni göra, och mina förordningar (ordagrant ”saker inristat”) ska ni hålla (vaka över) för att vandra efter dem. Jag är Herren(Jahveh), er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ni ska hålla (vaka över) mina förordningar (ordagrant ”saker inristat”) och mina påbud (bindande juridiska beslut); den människa som gör dem ska leva genom (i) dem. Jag är Herren (Jahveh). Incest och sexuella relationer mellan nära släktingar är förbjudna. Ordet ”närma sig” används i vers 6, 14 och 19 och ramar in stycket. Ett centralt ord som används 24 gånger i vers 6-19 är nakenhet (hebr. ervah) som även kan översättas genitalierna och används också för sexuella relationer. Totalt 11 verser (vers 7-17) börjar alla med det ordet. Det finns en tydlig struktur med flera kiasmer:  Släkting – inte närma dig, vers 6    Din mor, vers 7      Din fars hustru, vers 8        Din syster, vers 9          Ditt barns dotter, vers 10        Din halvsyster, vers 11      Din fars syster, vers 12    Din mors syster, vers 13  Din fars brors hustru – inte närma dig, vers 14    Din sons hustru, vers 15    Din brors hustru, vers 16    En kvinna och hennes dotter, vers 17    En kvinna och hennes syster, vers 18  Kvinna under menstruation – inte närma dig, vers 19  Incest tas upp även i följande passager: 1 Mos 19:30-38; 20:12; 35:22; 49:4; 2 Sam 13:1-14. Dessa bibliska regler ligger som grund för många länders lagar. I Israel straffas den som har sexuella relationer med sina egna barn med fem års fängelse. I svensk lagstiftning regleras incest i 6 kap. 7 § brottsbalken där straffet är högst två år. Mellan helsyskon är straffet fängelse i högst ett år. ");
INSERT INTO swe_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Släkting Ingen man (hebr. ish ish – upprepningen av ”man” betonar att det är ett generellt förbud) ska närma sig en nära släkting (kött av eget kött) för att blotta hennes nakenhet (ha en sexuell relation med henne). Jag är Herren (Jahveh). Vers 7-13 formar en kiasm med 7 förbjudna nära relationer. I en kiasm hör ämnen ofta parvis ihop. Första och sista, andra och näst sista, osv. Här rör sig kiasmen utåt i släktskap, från mor, far, barn och sist barnbarn. Moderns sida (vers 7, 13), faderns sida (se vers 8, 12), följt av syskon (vers 9, 11) och sist barnbarn (vers 10). ");
INSERT INTO swe_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Din mor Din fars nakenhet och din mors nakenhet ska du inte blotta, hon är din mor; du ska inte blotta hennes nakenhet (ha en sexuell relation med henne). Hör tematiskt ihop med vers 13 – incest på din mors sida av släkten är förbjudet. Se även 1 Mos 35:22; 1 Kor 5:1. ");
INSERT INTO swe_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Din fars hustru Din fars frus nakenhet ska du inte blotta (ha inte en sexuell relation med henne), hon är din fars nakenhet eftersom man och hustru är ”ett kött”, se 1 Mos 2:24; 49:4. Hör tematiskt ihop med vers 12 – incest på din fars sida av släkten är förbjudet. Detta var känt som en otillåten relation långt innan lagen, som t.ex. med Ruben, se 1 Mos 35:22. Även bland hedningar var detta inte accepterat, se 1 Kor 5:1. Trots detta var det en medveten synd av Davids son Avshalom, se 2 Sam 16:22. ");
INSERT INTO swe_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Din syster Din systers nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med din syster) – oavsett om det är din fars dotter eller din mors dotter, född hemma eller borta. Hör tematiskt ihop med vers 11 – incest mellan syskon är förbjudet. Förbudet gäller en syster på alla tänkbara sätt, tidigare äktenskap, utanför äktenskapet, osv. ");
INSERT INTO swe_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ditt barns dotter Din sondotters eller dotterdotters nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med dina barnbarn), för de är din egen nakenhet. Centralt i kiasmen (som rört sig tematiskt utåt i släktledet) förbjuds också incest med barnbarn. ");
INSERT INTO swe_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Din halvsyster Din faders hustrus dotters nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med en halvsyster), för hon är av din fars släkt och hon är din syster; du ska inte blotta hennes nakenhet (ha en sexuell relation med henne). ");
INSERT INTO swe_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Din fars syster Din faders systers nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med din faster), för hon är av din fars släkt. ");
INSERT INTO swe_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Din mors syster Din mors systers nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med din moster), för hon är av din mors släkt. ");
INSERT INTO swe_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Din fars brors hustru Din fars brors nakenhet ska du inte blotta, du ska inte närma dig hans hustru (du ska inte ha sexuellt umgänge med din farbrors hustru), för hans hustru är din ingifta faster. Ordet ”närma” ramar in den första kiasmen som började i vers 6, samtidigt inleds nästa stycke här som avslutas med ”närma dig” i vers 19. ");
INSERT INTO swe_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Din sons hustru Din sonhustrus nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med din svärdotter), hon är din sons hustru, hennes nakenhet ska du inte blotta. ");
INSERT INTO swe_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Din brors hustru Din brors hustrus nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med din svägerska), för det är din brors nakenhet. Här finns ett undantag när en broder dör och han och hans fru inte har några barn. Leviratäktenskapet beskrivs i 5 Mos 25:5-10 och är frivilligt för båda parter, dock krävs en chalitzah-ceremoni för att lösa änkan att bli fri att gifta om sig. ");
INSERT INTO swe_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kvinna och hennes dotter En kvinnas nakenhet och hennes dotters nakenhet ska du inte blotta (du ska inte ha sexuellt umgänge med en mor och hennes dotter); hennes sondotter eller hennes dotterdotters nakenhet ska du inte blotta, för de är ju nära släktingar – det är depraverat (oanständigt, en skändlighet – hebr. zimah) 3 Mos 19:29; 20:14. Hebr. zimah kommer från zamam som betyder tänka och fantisera, se även vers 22 och 23. ");
INSERT INTO swe_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kvinna och hennes syster – inte giftermål Och du ska inte ta en kvinna och hennes syster som hustru, och skapa fiendskap (rivalitet) mellan dem, och blotta båda deras nakenhet medan din första fru lever (du ska inte ha sexuellt umgänge med två systrar). Jakobs giftermål med Leah och Rakel är ett exempel på vilka problem detta skapar, se 1 Mos 29:23-30. ");
INSERT INTO swe_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Kvinna under menstruation och efter födsel Du ska inte närma dig jfr vers 6, 14 en kvinna och blotta hennes nakenhet (ha sexuellt umgänge med henne) när hon har menstruation och är ceremoniellt oren. Den ceremoniella reningen inkluderar både månadsreningen (3 Mos 15:33) och perioden på 40 respektive 80 dagar efter barnafödande (3 Mos 12:2), se även 3 Mos 15:24; 20:18. Tidigare stycke (vers 6-19) handlade om förbjudna sexuella relationer inom familjen. Nästföljande stycke (vers 20-23) behandlar förbjudna sexuella relationer utanför familjen. Här beskrivs en nedåtgående spiral i depraverat beteende, se även Rom 1:24-27. Det börjar med äktenskapsbrott, fortsätter med barnoffer, män som ligger med män, män som ligger med djur och sist en kvinna som försöker para sig med ett djur. I vers 20 och 21 används hebreiska ordet för säd, zera. Skrivsättet gör att detta stycke betonar frukten av sexualiteten, dvs. barn. Otukt med en annan kvinna producerar ett utomäktenskapligt barn (utanför släkten). Det är inte som det är tänkt med en familj, men det blir i alla fall ett mänskligt liv. Nästa steg är att ett barn offras till Molok och dödas. En sexuell relation mellan två män kan inte producera ett barn, och en man eller kvinna som har sex med ett djur (som inte ens är en människa) kan omöjligt producera en avkomma. ");
INSERT INTO swe_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Äktenskapsbrott Och med din nästas hustru ska du inte ligga (ha sexuellt umgänge med) och ge din säd, och på så sätt bli oren tillsammans med henne. Äktenskapsbrott förbjöds också i 2 Mos 20:14; 5 Mos 5:18; Joh 8:2-5 och straffades med döden för båda parter, se 3 Mos 20:10; 22:22. Allvaret i denna överträdelse beror på att äktenskapet var instiftat av Gud, se 1 Mos 2:18, 24; Ords 2:17; 18:22; Mal 2:14. ");
INSERT INTO swe_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Barnoffer till avgudar Du ska inte låta din säd dina avkomlingar, barn offras (passera) genom eld åt den ammonitiska avguden Molok som betyder ”kung”, se 1 Kung 11:7; du ska inte ohelga din Guds namn. Jag är Herren (Jahveh). Bara Gud är ”Kung” – inte ”Molok”. Den vanligaste beskrivningen av denna kanaaneiska avgud är att den var gjord av brons och ihålig – med en mänsklig kropp och en oxes huvud. Den satt på en tron av brons med händerna utsträckta, förberedda att ta emot offret. Man eldade i statyn och runt statyn så den hettades upp. Föräldrarna offrade sedan sina barn på de rödglödgade armarna medan ljudet av trummor och cymbaler dränkte barnets skrik. Enligt judisk tradition sägs att det fanns sju nivåer av tillbedjan av Molok. För att nå den första nivån krävdes ett offer av en fågel, den andra en get, den tredje ett får, den fjärde en kalv, den femte unga tjurar och den sjätte en tjur. För den sjunde och högsta ockulta nivån krävdes ett barnoffer. Bara de som offrade sin son till Molok fick tillträde dit. De ”skrin” som refereras till i Amos 5:25-27 och Apg 7:43 kan vara miniatyrer som illustrerar dessa olika nivåer. Det råder olika uppfattningar om denna beskrivning är kopplad till sederna för offret till Molok, Bibeln anger dock att det handlar om barnoffer och eld, se Hes 16:20-21; Ps 106:37-38; Jer 7:31. ");
INSERT INTO swe_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Med en man – homosexualitet Du ska inte ligga i säng med en man (ha sexuellt umgänge med honom) som med en kvinna – det är avskyvärt! I hebreiskan förstärks allvaret i varningen genom att både verbet ligga och substantivet för säng används. Att verbet står i formen yiktol förstärker också intensiteten, att en man verkligen inte ska ligga i säng och ha en fullbordad sexuell relation med honom, som han har med en kvinna. Termen avskyvärt (hebr. toeva) används bara fem gånger i den här boken, och det är i detta sammanhang, se 3 Mos 18:22, 26, 27, 29, 30; 20:13. Genom hela Bibeln fördöms den homosexuella akten, se 1 Mos 19:5; 3 Mos 20:13; Dom 19:22; Rom 1:27; 1 Kor 6:9; 1 Tim 1:10. ");
INSERT INTO swe_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Med ett djur – tidelag Du ska inte ligga (ha sexuellt umgänge) med ett djur, så att du blir oren; och ingen kvinna ska stå framför ett djur (för att ha sexuellt umgänge med det) – det är galenskap (förvirring; naturvidrigt – bryter mot naturens ordning) hebr. tevel används här och i 3 Mos 20:12! På samma sätt som förbud mot homosexualitet och tidelag står intill varandra här i Tredje Moseboken har de följts åt i svensk lagstiftning. Fram till 1944 kunde homosexuella handlingar bestraffas med straffarbete i högst två år. År 1944 avkriminaliserades både homosexualitet och tidelag, men från och med 1 april 2014 blev tidelag på nytt straffbart. Även om ordet homosexualitet är relativt nytt, så är fenomenet inte nytt. Jesus visar på äktenskapets höga standard, och hur en del har avstått för himmelrikets skull, se Matt 19:3-12. ");
INSERT INTO swe_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Orena er inte med något av detta, för med allt sådant har de folkslag orenat sig, som jag fördriver (kastar ut) för er. ");
INSERT INTO swe_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Och landet är därför orenat, och jag ska hemsöka deras missgärning på dem, så att landet själv utspyr sina invånare. 3 Mos 20:23-24 I detta kapitel beskrivs att sexuell synd är något skändligt (vers 17), avskyvärt (vers 22) och förvirrat (vers 23). Samma nedåtgående moraliska spiral beskrivs av Paulus, se Rom 1:24-32. Guds nåd och tålamod är stort 2 Pet 3:9. Här i Moseböckerna nämns Guds tålamod i fyra generationer, se 1 Mos 15:16. I Korintierbrevet lyfter Paulus fram fem sexuella synder tillsammans med avgudadyrkan och girighet och är tydlig med att ingen som lever så ska ärva Guds rike. Han fortsätter sedan med att sådana har några av er varit, men ni har tvättats rena och blivit helgade och förklarats rättfärdiga i Herren Jesu namn, se 1 Kor 6:9-11. Till äktenskapsbryterskan säger Jesus ”Inte heller jag dömer dig. Gå nu, och synda inte mer”, se Joh 8:11. ");
INSERT INTO swe_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Vers 26-30 formar en kiasm där ordet avskyvärt återkommer fyra ggr. Men ni ska hålla mina förordningar (ordagrant ”saker inristat”) och påbud (bindande juridiska beslut), och inte göra något av detta avskyvärda – det gäller både infödda och invandrare! ");
INSERT INTO swe_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","För allt detta avskyvärda gjorde landets invånare före er, och landet blev orenat. ");
INSERT INTO swe_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Gör inte så att landet spyr ut er, genom att orena det, på samma sätt som det spydde ut det folk som bodde där före er. ");
INSERT INTO swe_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","För var och en som gör något av detta avskyvärda, ska bli utstött (avskuren) från sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Lyd min befallning (mishmar – något som ska vaktas och skyddas), så att ni inte gör någon av dessa avskyvärda förordningar (traditioner, seder) som man följt före er, så att ni blir orenade genom dem! Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Det finns många likheter mellan tio Guds budord och vad som tas upp i detta kapitel:  2 Mos 20:2 – Jag är Herren – 3 Mos 19:3, 4, 10, 14, 16, 18, 25, 28, 30, 31, 34, 36, 37   2 Mos 20:4-6 – Ristade bilder – 3 Mos 19:4    2 Mos 20:7 – Guds namn – 3 Mos 19:12      2 Mos 20:8-12 – Sabbaten, älska Gud – 3 Mos 19:3, 30      2 Mos 20:12 – Vörda föräldrar, älska din nästa – 3 Mos 19:3     2 Mos 20:13 – Mord – 3 Mos 19:16    2 Mos 20:14 – Äktenskapsbrott – 3 Mos 19:29   2 Mos 20:15 – Stöld – 3 Mos 19:11, 13, 35-36  2 Mos 20:16 – Falskt vittnesbörd – 3 Mos 19:11, 16 2 Mos 20:17 – Begär – 3 Mos 19:18 Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Tala till hela Israels folk och säg: Ni ska vara heliga (rena, avskilda) för jag, Herren er Gud är helig. ");
INSERT INTO swe_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Var och en av er ska vörda sin mor och sin far älska medmänniskan och hålla mina sabbater älska Gud. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ni ska inte vända er till avgudar och inte göra er några gjutna gudar. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","När ni vill offra shalomoffer (gemenskapsoffer – hebr. zevach shelamim) åt Herren (Jahveh), ska ni offra det på sådant sätt att det tillräknas er som nåd (blir välbehagligt, villkorad nåd – hebr. ratson). ");
INSERT INTO swe_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Det ska ätas samma dag som ni offrar det eller nästa dag. Det som blir över till tredje dagen ska brännas upp i eld. ");
INSERT INTO swe_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Om det äts på tredje dagen, är det avskyvärt och ger inte nåd (blir inte välbehagligt, villkorad nåd – hebr. ratsah). ");
INSERT INTO swe_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Den som äter av det måste bära sin skuld, för han har ohelgat det som var helgat åt Herren (Jahveh). Han ska utrotas ur sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","När ni bärgar skörden i ert land, ska du inte skörda till den yttersta kanten av åkern och inte plocka upp ströaxen efter din skörd. ");
INSERT INTO swe_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Inte heller i din vingård ska du göra någon efterskörd, och de druvor som fallit av i din vingård ska du inte plocka upp. Du ska lämna kvar det åt den fattige och åt främlingen. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Följande stycke, vers 11-18, består av fyra sektioner som alla avslutas med ”Jag är Herren”. Fyra olika ord för ”medmänniska” används och de är fint fördelade i dessa verser.  Första sektionen använder ”landsman” (hebr. amit) i vers 11. I den andra sektionen används ”medmänniska” (hebr. rea), se vers 13. I den tredje sektionen används båda dessa och även ”folk” (hebr. amme), se vers 15-16. I den sista sektionen – som är crescendot – används alla dessa tre ord och även ”broder” (hebr. ben), se vers 17-18.  De två första enheterna (vers 11-12 och 13-14) avslutas båda med en uppmaning, den första uttryckt i en negation (ohelga) den andra positivt (frukta). Strukturen förstärks också av hur ordet ”inte” (hebr. lo) används. Totalt används det 18 ggr, nio gånger i första halvan, vers 11-14, nio ggr i andra halvan, vers 15-18. Ni ska inte stjäla. Ni ska inte ljuga. Ni ska inte bedra varandra, mot er landsman. ");
INSERT INTO swe_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ni ska inte svära falskt vid mitt namn; då ohelgar du singular din Guds namn. Jag är Herren (Jahveh). Den första handlingen är en fysisk gärning (stöld), följd av tre verbala handlingar. En rabbinsk tolkning är att de fyra handlingarna hör ihop och följer som konsekvens av varandra. En tjuv måste ljuga, bedra och till sist även vittna falskt för att dölja sitt brott. Genomgående i detta kapitel kopplas vårt agerande mot medmänniskor ihop med gudsrelationen, det förstärks också genom att byta från plural ”ni” till det personliga ”du” i vers 12b. ");
INSERT INTO swe_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du ska inte bedra (förtrycka) din medmänniska – inte heller råna honom. Du ska inte hålla inne arbetarens lön över natten. Han behöver den för att köpa mat åt sig och sin familj. ");
INSERT INTO swe_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du ska inte förbanna en döv person framför hans ansikte. Du ska inte lägga något i vägen för en blind så att han faller. Du ska frukta (i vördnad tillbe) din Gud (Elohim). Jag är Herren (Jahveh). Denna sektion har fem förbud. De två första är ett par att inte bedra/råna och sist finns ett par med döv/blind. Centralt står frasen att hålla inne arbetarens lön. På var sin sida om den frasen belyses två aspekter, det första är exploateringen att inte betala ut lön, den andra är hjälplösheten i offret som är utsatt. Strukturen i detta avsnitt gör att inte bara fem lagar räknas upp, uppställningen får läsaren att undersöka sambandet – inte bara lagens bokstav utan anden i undervisningen. I jämförelse med vers 11-12 så nämndes ”vittna falskt”. Där handlade det om någon som drabbades av stöld/lögn och var kapabel att ta ärendet till domstol. Här i vers 13-14 handlar det om de svaga och utsatta som inte har den möjligheten. ");
INSERT INTO swe_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ni ska inte döma partiskt – varken gynna den fattige bara för att han är fattig, eller ta den rikes parti bara för att han är rik och har inflytande. Du ska döma din landsman på ett rättvist sätt. ");
INSERT INTO swe_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du ska inte gå runt och förtala (baktala, spionera på) ditt eget folk. Du ska inte bara se på utan att ingripa om din medmänniskas liv står på spel. Ordagrant ”Du ska inte stå på din medmänniskas blod”. Jag är Herren (Jahveh). Från vers 15 återkommer hebreiska suffixet ka sju ggr, något som ökar närheten till objektet av dina handlingar. ");
INSERT INTO swe_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du ska inte hata din broder i ditt hjärta, tillrättavisa i stället honom så att du inte blir delaktig i hans synd. ");
INSERT INTO swe_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du ska inte hämnas eller bära bitterhet inom dig (bära på oförsonlighet och sårade känslor) mot någon i ditt folk, älska i stället din medmänniska som dig själv. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mina stadgar ska ni hålla. Du ska inte låta två slags djur av din boskap para sig med varandra. Du ska inte så två slags säd i din åker. Ta inte på dig klädesplagg av två olika slags garn. ");
INSERT INTO swe_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Om en man har legat med en kvinna som är en annan mans slavinna och sädesuttömning har skett, och hon inte har blivit friköpt eller frigiven, ska de straffas men inte dödas eftersom hon inte var fri. ");
INSERT INTO swe_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Han ska föra fram sitt skuldoffer, en skuldofferbagge, inför Herren, till mötestältets ingång. ");
INSERT INTO swe_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","När prästen med skuldofferbaggen bringar försoning för honom inför Herrens ansikte, får han förlåtelse för den synd han har begått. ");
INSERT INTO swe_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","När ni kommer in i landet och planterar olika slags träd med ätbar frukt, ska ni se deras frukt som deras förhud. I tre år ska ni betrakta dem som oomskurna och inte äta deras frukt. ");
INSERT INTO swe_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Under det fjärde året ska all deras frukt vara helig som ett tackoffer till Herren, ");
INSERT INTO swe_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","och först under det femte året ska ni äta deras frukt. Så ska ni göra för att de ska ge så mycket större avkastning åt er. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ni ska inte äta något som innehåller blod. Ni ska inte befatta er med spådom eller trolldom. ");
INSERT INTO swe_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ni ska inte rundklippa kanten av ert hår för att offra till de döda, se 5 Mos 14:1, inte heller ska du stympa kanten av ditt skägg. ");
INSERT INTO swe_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ni ska inte rista (tatuera) märken på er kropp för någon död och inte heller bränna in skrivtecken på er. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Vanära (ohelga) inte din dotter genom att låta henne bli prostituerad, så att landet blir fördärvat av otukt och uppfyllt av skamligheter. Ordet vanära är ett rikt ord med betydelsen att inte värdesätta, men har också betydelsen att genomborra, såra, döda och offra. I ordet finns också betydelsen ”att börja” och initiera en process. Betydelsen kan vara att ge bort sin dotter till kanaaneiska fruktbarhetsriter, se Jer 2:20; Hos 2, men också incestförhållande, se 3 Mos 18:17. ");
INSERT INTO swe_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mina sabbater ska ni hålla, och för min helgedom ska ni visa vördnad. Hör tematiskt ihop med vers 3. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ni ska inte vända er till förtroliga andar demoner som förställer sig och talar för den döde, inte heller söka efter spåmän så att ni blir orena genom dem. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","För ett grått huvud ska du resa dig upp, och den gamle ska du ära. Du ska frukta (respektera, hedra) din Gud. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","När en främling bor hos er i ert land, ska ni inte förtrycka honom. ");
INSERT INTO swe_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Främlingen som bor ibland er ska räknas som infödd hos er. Du ska älska honom som dig själv. Ni har ju själva varit främlingar i Egyptens land. Jag är Herren (Jahveh) er Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ni ska inte göra orätt i domen i mått mätning av längd, men även generellt ord för att mäta torra varor och vätska, i vikt mätning av vikt och i volym mätning av vätska (hin-måttet), se Hes 4:11, 16, men även torra varor, se 1 Krön 23:29. ");
INSERT INTO swe_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Rätt våg för att väga – även bildligt för att döma – rätta stenar vikter för balansvågen; rätt efa standardmått för att mäta torra varor – 22 liter och rätt hin standardmått för att mäta vätska – 3,5 liter ska ni ha. Dessa två verser som handlar om ärlighet i transaktioner – rätta vikter och mått. Detta stycke relaterar direkt till budorden i vers 11-18 om att inte stjäla, ljuga och bedra, utan att älska sin medmänniska. Standardiserade vikt- och måttenheter omnämns i Hammurabis lagar. Det är intressant att i ett stycke som just handlar om rätt balans står ”vikt” centralt i vers 35. Ordet vikt i vers 35 omgärdas av två ord för mått som balanserar de två måtten efa och hin i vers 36. Vers 35-36 är välbalanserad med orden våg och sten centralt. Även uppställningen av ord illustreras en rätt balanserad våg! Jag är Herren (Jahveh) er Gud (Elohim), som har fört er ut ur Egyptens land. ");
INSERT INTO swe_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Så ska ni nu hålla alla mina stadgar och alla mina lagar och följa dem. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Vers 2-27 formar en stor kiasm med flera mindre sektioner. Temat har att göra med vem som står bakom fördömandet av synden: samhället eller Herren (Jahveh).  I vers 3-6 beskrivs hur Guds straff riktas:  A Individen, v3-4    B Samhället, v5  A Individen, v6 Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Tala till Israels barn och säg till dem: Om någon av Israels barn eller av främlingarna som bor i Israel ger något av sina barn åt Molok, ska han straffas med döden. Folket i landet ska stena honom. 3 Mos 18:21; 2 Kung 3:27; Ps 106:38; Jer 32:35 ");
INSERT INTO swe_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Jag ska vända mitt ansikte mot den mannen och utrota honom ur hans folk, därför att han gett ett av sina barn åt Molok och orenat min helgedom och ohelgat mitt heliga namn. ");
INSERT INTO swe_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Om folket i landet ser mellan fingrarna med den mannen när han ger ett av sina barn åt Molok och inte dödar honom, ");
INSERT INTO swe_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","så ska jag själv vända mitt ansikte mot den mannen och mot hans släkt. Och jag ska utrota honom ur folket tillsammans med alla som följt honom och i trolös avfällighet dyrkat Molok. ");
INSERT INTO swe_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Om någon vänder sig till förtroliga andar demoner som förställer sig och talar för den döde, och spåmän, för att sälja sig till dem, så ska jag vända mitt ansikte mot honom, och utplåna honom ur hans folk. ");
INSERT INTO swe_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ni ska helga er och vara heliga, för jag är Herren (Jahveh) er Gud. ");
INSERT INTO swe_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ni ska hålla mina bud och följa dem. Jag är Herren (Jahveh) som helgar er. Fem gånger används ”blodskuld” som ordagrant är ”hans/deras blod”, se vers 9, 11, 12, 13, 16. ");
INSERT INTO swe_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Hedra dina föräldrar, se 3 Mos 19:3 Varje man (hebr. ish ish – upprepningen av ”man” betonar att det är ett generellt förbud) som förbannar sin far eller sin mor han ska straffas med döden. 2 Mos 20:12; 21:17 Han har förbannat sin far och sin mor, han bär på blodskuld. ");
INSERT INTO swe_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Man + annan mans kvinna, se 3 Mos 18:20 Om en man begår äktenskapsbrott med en annan mans hustru, ska den som begår äktenskapsbrott med sin nästas hustru straffas med döden, både äktenskapsbrytaren och äktenskapsbryterskan. ");
INSERT INTO swe_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Son + faders hustru – incest, se 3 Mos 18:8 Om en man ligger med en kvinna som är hans fars hustru så blottar han sin fars nakenhet. De ska båda straffas med döden. De bär på blodskuld. ");
INSERT INTO swe_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Far + svärdotter – incest, se 3 Mos 18:17 Om en man ligger med sin svärdotter, ska de båda straffas med döden. De har begått en avskyvärd handling. De bär på blodskuld. ");
INSERT INTO swe_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Man + man, se 3 Mos 18:22 Om en man ligger med en annan man (har sexuellt umgänge med honom) som en man ligger med en kvinna, gör de båda något avskyvärt! De ska straffas med döden. De bär på blodskuld. ");
INSERT INTO swe_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Man + kvinna + hennes mor, se 3 Mos 18:17 Om en man till hustru tar en kvinna och dessutom hennes mor, så är det en skändlighet. Man ska bränna upp både honom och dem i eld, för att ingen skändlighet ska finnas ibland er. ");
INSERT INTO swe_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Man + djur, se 3 Mos 18:23 Om en man ligger med ett djur ska han straffas med döden, och djuret ska ni döda. ");
INSERT INTO swe_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kvinna + djur, se 3 Mos 18:23 Om en kvinna gör närmanden mot något djur för att ligga med det, ska du döda både kvinnan och djuret. De ska straffas med döden. De bär på blodskuld. I följande sektion är det Gud som straffar: ");
INSERT INTO swe_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Om en man tar sin syster till hustru, sin fars dotter eller sin mors dotter och ser hennes nakenhet, och hon ser hans nakenhet, är det en skamlig gärning. 3 Mos 18:9 De kommer att försvinna (skäras bort) inför sitt folks ögon. Passivformen indikerar att Gud straffar honom. Han bär på missgärning, eftersom han har blottat sin systers nakenhet. ");
INSERT INTO swe_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Om en man ligger med en kvinna som har sin månadsrening och blottar hennes nakenhet, blottar han hennes blodflöde. De kommer att försvinna (skäras bort) ur sitt folk. Passivformen indikerar att det är Gud som straffar dem. ");
INSERT INTO swe_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Du ska inte blotta nakenheten hos din mors syster (moster) 3 Mos 18:13 eller din fars syster (faster) 3 Mos 18:12, för den som gör det blottar en nära släktings nakenhet. De kommer att bära på missgärning. ");
INSERT INTO swe_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Om en man ligger med sin farbrors hustru blottar han sin farbrors nakenhet. De kommer att bära på missgärning, och de kommer att dö barnlösa. ");
INSERT INTO swe_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Om en man tar sin brors hustru är det en oren gärning. 3 Mos 18:16 Han blottar då sin brors nakenhet, och de ska bli barnlösa. Detta gäller om brodern lever, om brodern dog barnlös skulle en bror gifta sig (leviratäktenskap) och försäkra sig att brodern fick en ättling, se 1 Mos 38:8; 5 Mos 25:5-10. ");
INSERT INTO swe_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ni ska hålla alla mina stadgar och regler och följa dem, för att landet inte ska spy ut er, det land dit jag nu för er så att ni får bo där. ");
INSERT INTO swe_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ni ska inte följa sederna hos de folk som jag driver undan för er, för just därför att de gjort som de gjort avskyr jag dem. ");
INSERT INTO swe_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Därför har jag sagt till er: Ni ska ärva deras land, för jag ska ge er det till arvedel, ett land som flödar av mjölk och honung. Jag är Herren er Gud (Jahveh Elohim), som har avskilt er från andra folk. 3 Mos 18:24-25 ");
INSERT INTO swe_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Gör alltså skillnad mellan rena och orena fyrfotadjur 3 Mos 11:2-8 och mellan rena och orena flygande varelser (hebr. of) 3 Mos 11:13-19, 20-23, så att ni inte gör er själva avskyvärda på grund av dessa fyrfotadjur eller fåglar eller kräldjur som rör sig på marken, alla dessa djur som jag har avskilt från er som orena. ");
INSERT INTO swe_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ni ska vara heliga inför mig, för jag, Herren (Jahveh), är helig. Och jag har avskilt er från andra folk för att ni ska tillhöra mig. ");
INSERT INTO swe_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","När någon – man eller kvinna – befattar sig med andebesvärjelse eller förtroliga andar demoner som förställer sig och talar för den döde, ska den personen straffas med döden. Han bär på blodskuld och ska stenas. ");
INSERT INTO swe_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Herren (Jahveh) sa till Mose: Säg till prästerna, Arons söner, säg så här till dem: Ingen ska bli orenad bland er för någon död bland folket. ");
INSERT INTO swe_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Men för hans närmaste släktingar, de som står nära honom, det är för hans mor och för hans far och för hans son och för hans dotter och för hans bror, ");
INSERT INTO swe_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","och för hans syster som är en jungfru, som står nära honom och som inte har någon man, för henne kan han bli orenad. ");
INSERT INTO swe_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Men han ska inte orena sig själv med att råda bland sitt folk och vanhelga sig själv. ");
INSERT INTO swe_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","De ska inte göra sina huvuden skalliga, inte heller ska de raka hörnen på sina skägg, och inte göra några märken på sin kropp. ");
INSERT INTO swe_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","De ska vara heliga för sin Gud (Elohim) och inte vanära deras Guds (Elohims) namn. För Herrens (Jahvehs) eldsoffer och deras Guds (Elohims) bröd som de offrar ska de vara heliga. ");
INSERT INTO swe_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","De ska inte ta en hustru som är en sköka eller hädisk, inte heller ska de ta en som är förskjuten från sin man, för han är helgad till sin Gud (Elohim). ");
INSERT INTO swe_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Därför ska du helga honom, för han offrar sin Guds (Elohims) bröd. Han ska vara helig för dig, för jag är Herren (Jahveh) som helgar dig. Jag är helig. ");
INSERT INTO swe_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Och dottern till någon präst, om hon vanhelgar sig genom att bete sig som en sköka, vanhelgar hon sin far, hon ska brännas med eld. ");
INSERT INTO swe_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Översteprästen har fler krav än en vanlig präst. Och han som är överstepräst bland sina bröder, över vars huvud smörjelseoljan är utgjuten och som är avskild för att ta på sig kläderna, ska inte avtäcka sitt huvud och inte riva sönder sina kläder. ");
INSERT INTO swe_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Han ska inte gå in till någon död kropp och inte orena sig själv för sin far eller för sin mor. ");
INSERT INTO swe_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Han ska inte gå ut från helgedomen, inte vanhelga sin Guds (Elohims) helgedom, för hans Guds (Elohims) smörjelseolja är kronan över honom. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Och han ska ta en hustru när hon är jungfru. ");
INSERT INTO swe_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","En änka eller en frånskild kvinna, eller en hädisk, eller en sköka ska han inte ta, men han ska ta en jungfru av sitt eget folk till hustru. ");
INSERT INTO swe_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Han ska inte heller vanhelga sin säd bland sitt folk, för jag är Herren (Jahveh) som helgar honom. ");
INSERT INTO swe_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Tala till Aron och säg: ”Vem han än är av din säd i dina generationer som har något lyte (en defekt), låt honom inte komma nära för att offra sin Guds (Elohims) bröd. ");
INSERT INTO swe_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","För varje man som har ett lyte (en defekt) ska inte komma nära, en blind man eller en halt eller han som har en platt näsa eller någon överflödig sak (missbildning), ");
INSERT INTO swe_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","eller en man som har deformerade fötter eller deformerade händer, ");
INSERT INTO swe_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","eller som har puckelrygg eller en dvärg eller han som har ett skadat öga eller som har hudutslag eller fjällig hud eller har skadade testiklar 5 Mos 23:1. ");
INSERT INTO swe_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ingen man som har ett lyte (en defekt) av prästen Arons säd (ättlingar) ska komma nära för att offra Herrens (Jahvehs) eldsoffer. Han som har ett lyte (en defekt), han ska inte komma nära för att offra sin Guds (Elohims) bröd. ");
INSERT INTO swe_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Han ska äta sin Guds (Elohims) bröd, både av det högheliga och av det heliga. ");
INSERT INTO swe_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Men han ska inte komma nära altaret eftersom han har en defekt, för att han inte ska vanhelga min helgedom, för jag Herren (Jahveh) helgar dem. 5 Mos 23:1 ");
INSERT INTO swe_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Och Mose talade det till Aron och till hans söner och till alla Israels söner. ");
INSERT INTO swe_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Tala till Aron och till hans söner att de ska avskilja sig själva från Israels söners heliga ting som de har helgat (avskilt) åt mig, så att de inte vanhelgar mitt heliga namn med det som de helgar till mig. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Säg till dem: ”Vemhelst han är av all er säd bland era generationer (för all framtid) som går till de heliga tingen, som Israels söner har helgat till Herren (Jahveh), och har sin orenhet på sig (som är ceremoniellt oren), den personen ska huggas bort från mitt ansikte (min närvaro) 3 Mos 7:20. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Oavsett vilken man av Arons släkt (säd, avkomma) som lider av en svampinfektion (mögel) eller ett problem med flytningar, han ska inte äta av det heliga förrän han har blivit ren. Och den som berör någonting som är orent genom de döda eller en man vars säd har lämnat honom, ");
INSERT INTO swe_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","eller vemhelst som rör något krypande djur som man blir oren av, eller en människa som är oren, oavsett vilken orenhet han har. ");
INSERT INTO swe_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Den själen som har rört något sådant ska vara oren till kvällen och ska inte äta av det heliga förrän han har tvättat sin kropp med vatten. ");
INSERT INTO swe_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Och när solen har gått ner ska han vara ren och ska därefter äta av det heliga för det är hans mat. ");
INSERT INTO swe_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Det som är självdött eller rivet av rovdjur ska han inte äta och orena sig själv med. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","De ska hålla (vakta, skydda, bevara) mina sedvänjor, annars bär de synden för det och därför dör de om de vanhelgar. Jag är Herren (Jahveh) som helgar dem. ");
INSERT INTO swe_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ingen främling som inte är av Arons prästsläkt ska äta av det heliga, en gäst hos prästen eller en inhyrd tjänare ska inte äta av det heliga. ");
INSERT INTO swe_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Men om prästen köper någon själ – en slav för sina pengar ska han äta av det, och han som är född i hans hus, de ska äta av hans kött. ");
INSERT INTO swe_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Om prästens dotter gifter sig med en främling ska hon inte äta av de heliga offren. ");
INSERT INTO swe_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Men om prästens dotter blir änka eller frånskild och inte har några barn och återvänder till sin fars hus som i sin ungdom, ska hon äta av sin fars kött. Men ingen främling ska äta av det. ");
INSERT INTO swe_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Men om en man äter av det heliga ovetandes, då ska han ge en femtedel därav (av dess värde) som syndoffer, se 3 Mos 5:16; 6:5 och ska ge det till prästen med det heliga. ");
INSERT INTO swe_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Och de ska inte vanhelga Israels söners heliga ting som de offrar till Herren (Jahveh), ");
INSERT INTO swe_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","eller låta dem bära synden av sin skuld när de äter deras heliga ting, för Jag är Herren (Jahveh) som helgar dem.” Detta stycke gäller hela folket, se vers 18. ");
INSERT INTO swe_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Herren (Jahveh) talade till Mose och sa: Denna sektion hör ihop med kapitel 1-7. Det som tas upp här är defekter på djuren som diskvalificerar dem från att offras. ");
INSERT INTO swe_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Tala till Aron och till hans söner och till alla Israels söner och säg till dem: ”Vem han än är från Israels hus eller från främlingarna i Israel, som vill offra sitt offer för alla sina löften och alla hans frivilliga gåvor som de vill offra till Herren (Jahveh) som brännoffer, ");
INSERT INTO swe_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","han ska av egen fri vilja (ordagrant med villkorad nåd) offra ett felfritt djur av hankön från nötboskapen, från fåren eller från getterna. ");
INSERT INTO swe_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Men det som har någon defekt (fel, lyte) ska ni inte offra, för det kommer inte att ge er nåd (bli välbehagligt, villkorad nåd – hebr. ratson). ");
INSERT INTO swe_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Och han som offrar ett shalomoffer till Herren (Jahveh) för att infria sitt löfte, eller ett frivilligt offer av nötboskap eller får, så måste det vara felfritt (hebr. tamim) för att ge nåd (bli välbehagligt, villkorad nåd – hebr. ratson). Det får inte ha någon defekt (fel, lyte). ");
INSERT INTO swe_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Något blint eller brutet något brutet ben eller stympat (något skuret; defekt) eller skrovligt (en utväxt, ett utslag) eller öppet sår eller fjällighet – dessa ska ni inte offra till Herren (Jahveh). Gör inget eldsoffer av dem på altaret till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","En oxe eller ett lamm som har någon missbildning (extra utväxt) eller saknar någon kroppsdel (är lemlästat), kan offras som ett frivilligt offer, men för ett löfte (som löftesoffer) ger det ingen nåd (villkorad nåd – hebr. ratsah). En oxe är en kastrerad tjur, och är därför inte giltigt som ett offerdjur, se även 5 Mos 17:1. ");
INSERT INTO swe_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ni ska inte offra till Herren (Jahveh) det som är söndermalt, eller krossat eller brutet eller skuret, inte heller ska ni göra något offer av sådant i ert land. ");
INSERT INTO swe_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Inte heller från en främlings hand ska ni offra Guds (Elohims) bröd av något av detta, eftersom deras förruttnelse är i dem och defekter (lyten) är i dem, ska de inte ge er nåd (villkorad nåd – hebr. ratsah).” ");
INSERT INTO swe_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","När ett nötboskap (tjur/oxe/ko/kalv – hebr. shor) eller ett får (hebr. kesev) eller en get förs fram, ska den stanna sju dagar med sin mor, och från den åttonde dagen och framåt ska det ge nåd (villkorad nåd – hebr. ratsah) som ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Och om det är ett nötboskap (tjur/oxe/ko/kalv – hebr. shor) eller får (lamm – hebr. seh) ska ni inte döda henne och hennes kalv på samma dag. 2 Mos 23:19; 3 Mos 22:28; 5 Mos 22:6, 7 ");
INSERT INTO swe_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Och när ni vill offra ett tacksägelseoffer till Herren (Jahveh), ska ni offra det av egen fri vilja (ordagrant med villkorad nåd). ");
INSERT INTO swe_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Det ska ätas samma dag, ni ska inte lämna något av det till morgonen. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Därför ska ni hålla (vakta, skydda, bevara) mina budord (tydliga befallningar) och göra dem. Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ni ska inte vanhelga mitt heliga namn utan jag ska vara helig bland Israels söner. Jag är Herren (Jahveh) som helgar er, ");
INSERT INTO swe_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","som förde er ut ur Egyptens land för att vara er Gud (Elohim). Jag är Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Herrens (Jahvehs) högtider är mer än bara tillfällen att fira en fest. De högtider som omnämns här är Herrens egna, som han själv har instiftat, för att på ett särskilt sätt vid olika tillfällen under året få ha en extra intim gemenskap med oss som troende och delaktiga i blodsförbundet med Gud, se 1 Mos 1:14. Sabbaten är en högtidsdag som återkommer varje vecka medan de övriga högtiderna återkommer varje år.  Sabbaten handlar om att vi regelbundet behöver avsätta tid då vi släpper vardagens sysslor för att umgås med Gud mer tid än vad som är möjligt när vi också måste ha vårt fokus på vardagligt. Dessa omsorger är i sig själva något som Gud också vill att vi ska ägna oss åt men med sabbaten markeras att vårt umgänge med Gud själv är den viktigaste prioriteringen i våra liv.  De årliga högtiderna har, förutom det som vi i varje högtid ska påminna oss om, också samtliga en tydlig profetisk dimension som pekar mot något som Gud ska göra längre fram. De tre vårhögtiderna tillsammans med pingsten pekar på Messias första besök här på jorden. De har alla fått sin fullbordan i det som Jesus gjorde när han vandrade bland oss och när apostlarna fick fullborda pingstdagen. (Dessa högtider hade då firats i storleksordningen 1 500 gånger.) De tre hösthögtiderna pekar profetiskt på det som vi fortfarande väntar på ska ske när Messias kommer tillbaka till jorden för andra gången. Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Tala till Israels söner och säg till dem: Herrens (Jahvehs) högtider (avtalade möten på bestämda tider – hebr. móed), som ni ska utropa (förkunna, proklamera) som heliga sammankomster – dessa är mina högtider (avtalade möten på bestämda tider): ");
INSERT INTO swe_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sex dagar ska arbete utföras. Sjunde dagen är sabbat för högtidlig vila, en helig sammankomst. Du ska inte utföra något arbete. Det är Herrens (Jahvehs) sabbat var du än bor. Sabbaten inleds vid solnedgången på fredagskvällen och avslutas på lördag kväll en timma efter solnedgången. Kvällen inleds med ljuständning och ofta en bönegudstjänst i synagogan. Det är ett dygn då man inte arbetar. Man umgås med familjen och går till synagogan. Ingenstans i Nya testamentet befalls de kristna att hålla sabbatsbudet på detta sätt. Jesus säger dock att människan inte är till för sabbaten, utan att sabbaten är till för människan. Vi behöver en dag av vila, en dag att söka Gud enskilt och fira gudstjänst. Se även 2 Mos 20:8-11; 31:12-17; 35:1-3; 4 Mos 28:9-10; 5 Mos 5:12-15 ");
INSERT INTO swe_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Detta är Herrens (Jahvehs) högtider (avtalade möten på bestämda tider), heliga sammankomster, som ni ska utropa (förkunna, proklamera) på deras bestämda tider. ");
INSERT INTO swe_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Under den första månaden nisan, som infaller under mars/april, vid skymningen (ordagrant: mellan de två kvällarna) 2 Mos 12:6 den 14:e i månaden är Herrens (Jahvehs) påsk (pesach). Just här beskrivs inte påsken utförligare men i 2 Mos 12 finns en detaljerad beskrivning av hur denna dag ska firas. Se även 4 Mos 28:16-23; 5 Mos 16:1-7. ");
INSERT INTO swe_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","På den 15:e dagen i samma månad nisan, på våren är Herrens (Jahvehs) det osyrade brödets högtid (hebr. chag matsah). Under sju dagar ska ni äta osyrat bröd. ");
INSERT INTO swe_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","På första dagen ska ni hålla en helig sammankomst och ni ska inte utföra något arbete. ");
INSERT INTO swe_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Istället ska ni bära fram ett eldsoffer till Herren (Jahveh) i sju dagar. På den sjunde dagen ska ni hålla en helig sammankomst och ni ska inte utföra något arbete. Det osyrade brödet är en bild på syndfrihet och talar dels om Jesus, men även om oss som genom Jesu försoningsverk har rätten att ta del av Hans syndfrihet genom frälsningen. Se även 4 Mos 28:24-25; 5 Mos 16:8. ");
INSERT INTO swe_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Tala till Israels barn (söner) och säg till dem: När ni har kommit in i landet som jag ska ge er och skördar dess gröda, då ska du ta en kärve (hebr. omer) av det första av skörden och föra det till prästen. Den första grödan som skördas är korn, därför är det en kornkärve som bärs fram som förstlingsfrukt vid detta tillfälle. ");
INSERT INTO swe_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Han ska vifta kärven inför Herrens (Jahvehs) ansikte så att den ger nåd (villkorad nåd – hebr. ratson) åt dig. På morgonen efter sabbaten ska prästen vifta den. ");
INSERT INTO swe_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Och den dag då ni viftar (lyfter) er kärve (hebr. omer) ska du offra ett felfritt årsgammalt lamm av hankön som brännoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Det tillhörande matoffret ska vara två tiondels efa totalt 5-7 liter fint mjöl blandat med olja, ett eldsoffer till Herren (Jahveh) som en behaglig väldoft. Det tillhörande dryckesoffret ska vara en fjärdedels hin 0,9 liter. ");
INSERT INTO swe_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Du ska inte äta bröd, rostad säd eller ny säd (från årets skörd) förrän denna dag, inte förrän du har burit fram offret till din Gud (Elohim). Det ska vara ett evigt påbud genom alla generationer överallt där ni bor. Bikkurim kan infalla både andra och tredje dagen under det osyrade brödets högtid, eftersom det är dagen efter sabbat. Om en vanlig veckosabbat och den högheliga sabbaten som är första dagen i det osyrade brödets högtid infaller efter varandra blir det två sabbatsdagar innan man kan fira förstlingsfruktens högtid. Det kan varit det som inträffade det året då Jesus korsfästes, se Matt 28:1; Mark 11. Pesach firas alltid 14:e nisan och den första dagen i det osyrade brödets högtid den 15:e nisan. Den tredje dagen i osyrade brödets högtid är 17:e nisan. Veckodagarna varierar år från år. År 30 e.Kr. är dock 17:e nisan en söndag. Det året sammanfaller söndagen också med förstlingsfruktens högtid, bikkurim. Tänk om samtidigt som en kärve viftades i templet som ett förstlingsoffer spreds nyheten om att Jesus var uppstånden, se 1 Kor 15:20.  När vi väljer att fira förstlingsfruktens högtid och, även att i enlighet med andra skriftställen i ämnet, ge vår förstlingsfrukt till Herren regelbundet (Ords 3:9; Hes 44:30) då är det ett sätt för oss att markera att vi alltid vill ha Gud först i våra liv. Det finns särskilda välsignelser utlovade när vi lever på det sättet, se Matt 6:19-21. ");
INSERT INTO swe_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Sedan ska du räkna från morgonen efter sabbaten samma dag som förstlingsfruktens högtid firas, samma dag som du bär fram kärven (hebr. omer) med ditt viftoffer, sju fulla sabbater. ");
INSERT INTO swe_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Till morgonen efter den sjunde sabbaten ska du räkna femtio dagar och sedan bära fram ett nytt matoffer till Herren (Jahveh). Under sju veckors tid mellan förstlingsfruktens högtid (bikkurim) och pingst (shavuot) räknas 49 dagar. Räkningen kallas omerräkningen eftersom hebr. omer både är ordet för kärve (vers 15) och det volymmått som motsvarade omkring 3 liter, dagsbehovet av manna för en person och den mängd korn man fick ut av kärven (2 Mos 16:36). Intressant är att nästa högtid, shavuot, som också kallas skördefesten (hebr. chag qatsir, se 2 Mos 23:16) har en numerologisk koppling till omerräkningens 49 dagar. Ordet för skörd (hebr. qatsir) används 49 ggr i GT, två av gångerna är i vers 22 i stycket som handlar om shavuot. ");
INSERT INTO swe_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Du ska då, på den femtionde dagen föra ut från ditt hus två stycken bröd till ett viftoffer. De ska göras av två tiondelar av en efa fint mjöl ca 5-7 liter och du ska baka dem med jäst som en förstlingsfrukt till Herren (Jahveh). Detta är det enda offret i hela Torah som inte bara får, utan ska vara gjort med jäst! Det är signifikativt på flera sätt. För det första är det två bröd som talar om judar och hedningar tillsammans. Men det är också jästen som symboliserar synden i våra liv. När pingsten får sin uppfyllelse i Apg 2 utgjuts den helige Ande över alla människor. Därmed blir det möjligt för oss som syndiga varelser att få del av rättfärdigheten från Gud genom Jesus. På så vis kan vi komma med synden inför Gud utan att bli dömda till evig död, eftersom vi nu får åberopa Jesu blod som gör oss syndfria i Guds ögon trots vår egen syndfullhet. Det är den helige Andes uppgift att övertyga oss om vår synd och behovet av frälsningen som Jesus erbjuder oss.  Denna högtid firas i modern tid bara en eller två dagar, till skillnad från pesach och sukkot som fortfarande firas i sju dagar. ");
INSERT INTO swe_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tillsammans med brödet ska du bära fram sju årsgamla, felfria lamm, en ung tjur och två baggar. De ska vara ett brännoffer till Herren (Jahveh) med deras tillhörande matoffer och dryckesoffer, ett eldsoffer till Herren (Jahveh) som en behaglig väldoft. ");
INSERT INTO swe_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Du ska också offra en get av hankön som syndoffer och två årsgamla lamm av hankön som ett shalomoffer ett gemenskapsoffer som alla i familjen åt tillsammans, se 3 Mos 7:11-21. ");
INSERT INTO swe_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Prästen ska vifta dem tillsammans med brödet från förstlingsfrukten som ett viftoffer inför Herrens (Jahvehs) ansikte, med de två lammen. De ska helgas åt Herren (Jahveh) för prästerna. ");
INSERT INTO swe_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Du ska utfärda ett påbud (förkunna, proklamera) samma dag att det ska vara en helig sammankomst, och du ska inte utföra något arbete. Det ska vara ett evigt påbud överallt där ni bor genom alla generationer. ");
INSERT INTO swe_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","När du nu skördar din hands grödor ska du inte skörda till det yttersta hörnet av din åker eller samla in efterskörden av din gröda. Istället ska du lämna detta till de fattiga och främlingarna. Jag är Herren din Gud (Jahveh Elohim). Flera exempel på detta finns i Bibeln. Rut plockade ax på Boaz åker, se Rut 2:2; Jesus och lärjungarna gick genom ett sädesfält, se Mark 2:23. Se även 3 Mos 19:9-10; 5 Mos 24:19-22. ");
INSERT INTO swe_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Tala till Israels barn (söner) och säg: I 7:e månaden tishri – sept/okt, på första dagen i månaden ska ni hålla en sabbatsvila, en minnesdag (då ni kommer ihåg) med höga ljud rop och shofarstötar, se 4 Mos 29:1, en helig sammankomst. ");
INSERT INTO swe_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Du ska inte utföra något arbete och du ska bära fram ett eldsoffer till Herren (Jahveh). Denna högtid kallas även trumpethögtiden eller basunhögtiden. Profetiskt pekar den fram mot när den sista basunen ska ljuda inför Jesu återkomst till jorden. Det är också denna högtid som markerar det judiska nyåret. I 2 Mos 12:1-2 står det tydligt att nisan (då påsken firas på våren till minne av uttåget ur Egypten och nationen föddes) ska vara den första månaden. Det är inte helt klart hur förskjutningen har gått från första månaden till den sjunde. Det kan ha att göra med att sådden sker på hösten och det agrikulturella året inleds. Sedan 1600-talet kallas högtiden även för rosh hashana (årets huvud) bland judarna. Judisk litteratur beskriver hur man i bibelns tid blåste trettio stötar med shofarerna. I modern judendom blåser man hundra gånger för att proklamera det nya året. ");
INSERT INTO swe_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Herren (Jahveh) talade till Mose och sa: ");
INSERT INTO swe_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Exakt på (hebr. ach, betonar något viktigt) den 10:e dagen i denna sjunde månad tishri är försoningsdagen (jom kippur; det bibliska namnet är jom hakippurim – ordagrant ”försoningarnas dag”), en helig sammankomst för er för att ni ska rannsaka er (era själar, hela er varelse – hebr. nefesh). Du ska bära fram ett eldsoffer till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ni ska inte utföra någon form av arbete över huvud taget denna dag, för det är försoningsdagen (jom kippur) då ni ska bringa försoning för er inför Herren er Gud (Jahveh Elohim). ");
INSERT INTO swe_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Vem det vara må ibland er, som inte rannsakar sin själ (sig själv) den dagen, ska bli avhuggen (avskiljas från) sitt folk. ");
INSERT INTO swe_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Den person (själ) som utför någon form av arbete den dagen, den personen ska jag utrota ur hans folk. ");
INSERT INTO swe_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ni ska inte göra något arbete. Det ska vara ett evigt påbud genom alla generationer överallt där ni bor. ");
INSERT INTO swe_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Det ska vara en sabbat med högtidlig vila för er och ni ska ödmjuka era själar. Efter 9:e dagen i månaden på kvällen, från afton till afton, ska ni fira er sabbat. Här är hebreiskan lite korthuggen i sitt uttryck men judarna tolkar denna vers som att man ska inleda försoningsdagen innan solen hunnit gå ner helt och därför blir detta dygn längre än 24 timmar. De tio dagarna mellan jom teroah och jom kippur är dagar då det judiska folket än idag rannsakar sig själva. Det är en tid då man försöker reda ut ouppklarade konflikter. Man tänker tillbaka på det gångna året och bekänner fel och misstag man gjort. Det är en tid då man gör allt man kan för att leva i frid med varandra, se Rom 12:18. Enligt judisk tradition är det på nyårsdagen, jom teroah (i modern hebreiska rosh hashana) som Gud avgör vem som ska skrivas i livets bok, och på jom kippur som skriften beseglas. Därav hälsningsfrasen på jom kippur: Gmar chatimah tova som betyder ”må ni bli inskrivna i livets bok”. ");
INSERT INTO swe_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Herren (Jahveh) talade till Mose och sa: För 5:e och sista gången i detta kapitel förekommer denna fras. Det är också 10:e och sista gången ordet ”talar” används. Kapitlet är en motsvarighet till tio Guds ord i 2 Mos 20. Här återfinns tio Guds ord om högtiderna! ");
INSERT INTO swe_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Tala till Israels barn (söner) och säg: På 15:e dagen i denna sjunde månad tishri är det Lövhyddohögtid sju dagar till Herren (Jahveh). ");
INSERT INTO swe_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","På första dagen ska ni hålla en helig sammankomst, då ska inget arbete utföras det är en sabbatsdag. ");
INSERT INTO swe_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","I sju dagar ska ni bära fram eldsoffer till Herren (Jahveh). Den åttonde dagen ska vara en helig sammankomst för er och ni ska föra fram ett eldsoffer till Herren (Jahveh). Det är en högtidlig sammankomst, ni ska inte utföra något arbete det är en sabbatsdag. ");
INSERT INTO swe_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Detta är Herrens (Jahvehs) högtid (avtalade möte på bestämd tid), som ni ska utropa (proklamera) som en helig sammankomst för att bära fram eldsoffer till Herren (Jahveh) ett brännoffer, ett matoffer och ett dryckesoffer, vart och ett på sin egen dag, ");
INSERT INTO swe_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","vid sidan av Herrens (Jahvehs) sabbater och vid sidan av era gåvor och alla era löften och alla era frivilliga 