﻿USE sofia;
DROP TABLE IF EXISTS sofia.suzBl_vpl;
CREATE TABLE suzBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES suzBl_vpl WRITE;
INSERT INTO suzBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","नेल्‍ल क्‍येङा ङोंइती परमप्रभुमी सरीङ नु रागी दुम्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","मिनु खप, फश, ब्‍वाक्‍कु नेल्‍ल खाल्‍सीशा, मारेइ मवाशो बाक्‍माक्‍त। मिनु मेको तारी छिङछिङ बाक्‍माक्‍त। परमप्रभु आ सोक्‍त ब्‍वाक्‍कु तारी फिल फिल पा हिम्‍सीशा बाक्‍बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","मिनु परमप्रभुमी “छेङछेङ दुमो” देंमेनु, छेङछेङ दुम्‍माक्‍त। भजन संग्रह ३३:९; हिब्रू ११:३; यसैया ४५:७ ");
INSERT INTO suzBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","मेको तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। मिनु छेङछेङ नु छिङछिङ फ्रादीम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","मिनु परमप्रभुमी छेङछेङ कली नाक्‍ती नु छिङछिङ कली नाक्‍दो, दे नें वोदा बाक्‍त। मिनु नां रिक्‍शा, नां सोव़शा, मेको ङोंइती ङा नाक्‍ती दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","मिनु परमप्रभुमी “ब्‍वाक्‍कु आ दातेमी फ्रातीक दुमो। ब्‍वाक्‍कु ब्राशा बाक्‍मल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","मोपा परमप्रभुमी सरीङ आगा ङा ब्‍वाक्‍कु नु सरीङ तारी ङा ब्‍वाक्‍कु फ्रादीम्‍सी बाक्‍त। मिनु ब्‍वाक्‍कु बुक्‍शा बाक्‍मा बाक्‍त। भजन संग्रह १९:२; भजन संग्रह १३६:६; भजन संग्रह १४८:४ ");
INSERT INTO suzBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमप्रभुमी मेको फ्रातीके कली सरीङ, दे नें वोदा बाक्‍त। मिनु नां रिक्‍शा, नां सोव़शा, मेको निक्‍शी नाक्‍त दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","मिनु परमप्रभुमी “सरीङ आगा ङा ब्‍वाक्‍कु काथा दुमीन। सोव़शो रू ग्रूङो” देंमाक्‍त। मेको यो दुम्‍माक्‍त। अय्‍युब ३८:८-११; भजन संग्रह २४:२; २पत्रुस ३:५ ");
INSERT INTO suzBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","मिनु परमप्रभुमी सोव़शो रू कली रागी नु ब्‍वाक्‍कु देम्‍शा लीशो कली समुन्‍द्र, दे नें वोदा बाक्‍त। मिनु मेको आ सेल्‍शो तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","मिनु परमप्रभुमी रागी ङा खप कली “घांस, फू नु रवापुकी दुम्‍मल। घांस नु फूपुकीम वांचेर बाक्‍मल। फल फुल सिप्‍ब रवापुकी वाशा, आंम आंम फल सिम्‍मल। मेको आन वांचेर चहिं आन फलपुकीम बाक्‍मल” देंमाक्‍त। मिनु मोदेंशो दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","रागीम घांस नु फूपुकी वाशा, आन वांचेर यो वामा बाक्‍त। फल फुल रवापुकी वाशा, आन वांचेर यो वामा बाक्‍त। मिनु परमप्रभुमी आ सेल्‍शो तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","मिनु नां रिक्‍शा, नां सोव़शा, मेको सां नाक्‍ती दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","मिनु परमप्रभुमी “नाक्‍ती नु नाक्‍दो फ्राचा कली सरीङमी छेङछेङ पा ब्राइबपुकी दुमीन। मेको ब्राइबपुकीम हिंउद नु बर्खा, नाक्‍ती नु बर्स कली फ्रातीक गेय पामेक्‍ल। ब्‍यवस्‍था ४:१९; भजन संग्रह ७४:१६; यसैया ४७:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","मिनु मेको सरीङ ङा ब्राइबपुकीम रागी कली छेङछेङ गेचा माल्‍नीम” देंमाक्‍त। मिनु मेको दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","मोपा परमप्रभुमी ठेयब बत्ती निक्‍शी सेला बाक्‍त। शुश छेङछेङ पा ब्राइब नाक्‍त कली नु इच्‍का छेङछेङ पा ब्राइब बत्ती नाक्‍दो कली वोदा बाक्‍त। सोरुल यो सेल्‍मी बाक्‍त। भजन संग्रह १३६:७-९ ");
INSERT INTO suzBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमप्रभुमी रागी छेङछेङ बाक्‍ल, दे मेको नेल्‍ल आन कली सरीङमी वोइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","नाक्‍त नु नाक्‍दो कली फ्राचा नु छेङछेङ छिङछिङ रे फ्राचा कली सरीङम वोदा बाक्‍त। परमप्रभुमी मेको तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","मिनु नां रिक्‍शा, नां सोव़शा, मेको ४ नाक्‍ती दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","मिनु परमप्रभुमी “ब्‍वाक्‍कुमी मारेइ मारेइ ब्रोंइशा बाक्‍बपुकीम ब्रीमल। रागी तारी मारेइ मारेइ चिक्‍ब सरीङम बेरमल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","मोपा परमप्रभुमी ब्‍वाक्‍कुम बाक्‍ब ठेयब हिंचा ङा जन्‍तु नु मारेइ मारेइ ब्रोंइशा बाक्‍ब सेल्‍मी बाक्‍त। मेको शुश दुम्‍शा, समुन्‍द्र ब्रीशा बाक्‍मा बाक्‍त। चिक्‍ब यो शुश दुम्‍मा बाक्‍त। मिनु परमप्रभुमी मेको तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। भजन संग्रह ७४:१३-१४; १४८:७ ");
INSERT INTO suzBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमप्रभुमी मेको नेल्‍ल आन कली आसीक गेशा “सोशा बोशा, शुश दुमीन, समुन्‍द्र ङा ब्‍वाक्‍कु ब्रीङीने” देंमाक्‍त। चिक्‍ब आन कली यो “सोशा बोशा, रागीमी शुश दुमीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","मिनु नां रिक्‍शा, नां सोव़शा, मेको ५ नाक्‍ती दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","मिनु परमप्रभुमी “रागीम मारेइ मारेइ ब्रोंइशा बाक्‍ब ग्रूचा माल्‍नीम। मार ग्रूचा माल्‍नीम देंशा हना बी ब्‍यफ, खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु मार मार ब्‍वाकी ङा जन्‍तु दुमीन” देंमाक्‍त। मिनु मेको दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","मोपा परमप्रभुमी मारेइ मारेइ ब्‍वाकी ङा जन्‍तु, मारेइ मारेइ बी ब्‍यफ, खपीम ग्रेशा गाक्‍ब नु मारेइ मारेइ आइक्‍च जन्‍तु सेल्‍मी बाक्‍त। मिनु परमप्रभुमी आ सेल्‍शो तशा “रिम्‍शो दुम्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","मिनु नोले परमप्रभुमी “इं खोदेंशो पा मुर का सेल्‍य। मिनु समुन्‍द्र ङा ङांइ, सरीङम बेरब चिक्‍ब, बी ब्‍यफ, ब्‍वाकी ङा जन्‍तु नु खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नेल्‍ल आन कली हुकुम पाइब दुम्‍ल” देंमाक्‍त। भजन संग्रह ८:६-९; एफिसी ४:२४; कलस्‍सी १:१५; याकूब ३:९ ");
INSERT INTO suzBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","मिनु परमप्रभुमी आ खोदेंशो तांइसीशो का सेला बाक्‍त। मेकोमी वोंइश मुर का नु मीश मुर का सेला बाक्‍त। उत्‍पत्ती ९:६; मत्ती १९:४ ");
INSERT INTO suzBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","मिनु परमप्रभुमी मुर आस कली आसीक गेशा “सोशा बोशा, तमी तौ थिशा, रागी प्रिंशा, रिम्‍शो पा हुकुम पस। समुन्‍द्र ङा ङांइ, सरीङम बेरब चिक्‍ब, रागीम बाक्‍ब जन्‍तु नेल्‍ल नु खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नेल्‍ल आन कली रिम्‍शो पा हुकुम पसे” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","मिनु परमप्रभुमी “नेनीस, गो इस कली वांचेर सिप्‍ब, गिग खाइ, फल सिप्‍ब नु वांचेर सेल्‍ब रवा गेतन्‍सी। मेको इस कली जचा ब्‍वचा दुम्‍ब। मत्ती ६:२५-३४ ");
INSERT INTO suzBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","मिनु गो रागीम बाक्‍ब जन्‍तु, बी ब्‍यफ, रागी ङा चिक्‍ब, खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु मारेइ मारेइ ब्रोंइशा बाक्‍ब आन कली घांस, सुवा ब्‍वचा गेतामी” देंमाक्‍त। मिनु मोदेंशो दुम्‍माक्‍त। भजन संग्रह १४५:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","मिनु परमप्रभुमी आ सेल्‍शो नेल्‍ल तशा “शुश रिम्‍शो दुम्‍त” देंमाक्‍त। मिनु नां रिक्‍शा, नां सोव़शा, मेको ६ नाक्‍त दुम्‍माक्‍त। मत्ती १९:१७; १तिमोथी ४:४ ");
INSERT INTO suzBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","मिनु मोपा परमप्रभुमी सरीङ, रागी नु मार मार बाक्‍मा, मेको नेल्‍ल सेल्‍ने थुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","मिनु ६ नाक्‍तीम आ गेय नेल्‍ल थुम्‍शा ङा मिन ७ नाक्‍तीम नांइसे बाक्‍त। हिब्रू ४:४ ");
INSERT INTO suzBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","मिनु परमप्रभुमी नाइक्‍तीक नाक्‍त कली आसीक गेवा बाक्‍त। मिनु मेको नाक्‍त आंम कली नाइक्‍चा, दे वोदा बाक्‍त। मारदे हना मेको नेल्‍ल सेल्‍तीक गेय थुम्‍शा नांइसे बाक्‍त। प्रस्‍थान २०:११; भजन संग्रह ९५:११; इजीकीएल २०:१२; हिब्रू ४:९-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","एको परमप्रभुमी सरीङ नु रागी सेल्‍ची ना ङा लोव़ बाक्‍ब। परमप्रभु यावेमी रागी नु सरीङ से‍लानु, ");
INSERT INTO suzBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","मारेइ मारेइ घांस खपीम मवाशो बाक्‍मा बाक्‍त। कोव़केली यो मदाप्‍शो बाक्‍मा बाक्‍त। मारदे हना परमप्रभु यावेमी रागीम रेउ मयिपाइश्‍शो बाक्‍माक्‍त। मिनु रूम गेय पाइब मुर यो मबाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","मेना रागी रे खोला ग्रूशा, रागी नेल्‍ल ङा खप जिप्‍पाइक्‍बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","मिनु नोले परमप्रभु यावेमी रू ङा खप के मुर का सेला बाक्‍त। मिनु मुर आ नेंमी ब्रोंइतीक सोक्‍त मुइक्‍ता बाक्‍त। मिनु मुर सोक्‍त पाइश्‍शो दुम्‍माक्‍त। उत्‍पत्ती ३:१९; अय्‍युब १०:९; अय्‍युब ३३:४; भजन संग्रह १०४:२९-३०; १कोरिन्‍थी १५:४५,४७ ");
INSERT INTO suzBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","मिनु नोले परमप्रभु यावेमी पूर्बम एदेन माइश्‍शो रू का सेला बाक्‍त। मेकेर आ सेल्‍शो मुर कली वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","मिनु परमप्रभु यावेमी मेकेर मार मार दारशो तांइसीब रवा नु जचा ब्‍वचा फल सिप्‍ब रवा वापदा बाक्‍त। ब्रोंइपाइक्‍ब का नु रिम्‍शो नु मरिम्‍शो तुइक्‍पाइक्‍ब रवा का यो रू आ दातेमी वापदा बाक्‍त। उत्‍पत्ती ३:२२; प्रकाश २:७; प्रकाश २२:२ ");
INSERT INTO suzBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","मिनु रू कली जिप्‍पाइक्‍चा, दे एदेन रे खोला का ग्रूमाक्‍त। मेको खोला नोले ब्राशा, ४ ओटा खोला दुम्‍शो बाक्‍मा बाक्‍त। इजीकीएल ४७:१-१२ ");
INSERT INTO suzBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ङोंइती ङा खोला आ नें पीशोन बाक्‍ब। मेको खोला हवीलाह रागी आ एर ओंथ रे लशो बाक्‍ब। मेको रागीमी सुन बाक्‍बाक्‍‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","मेको रागी ङा सुन रिम्‍शो बाक्‍बाक्‍माक्‍त। मेकेर गोकुल धूप नु ओनीक्‍स माइश्‍शो हीरा यो बाक्‍बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","मेको आ नोले ङा खोला आ नें गिहोन बाक्‍ब। मेको कूश माइश्‍शो रागी आ एर ओंथ हिरशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","मिनु मेको आ नोले ङा खोला आ नें टाइग्रीस बाक्‍ब। मेको खोला अस्‍सुर रागी आ पूर्ब गे लशो बाक्‍ब। मिनु नेल्‍ल क्‍येङा नोले ङा खोला आ नें युफ्रेटीस बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","मिनु परमप्रभु यावेमी मुर कली लाइश्‍शा, एदेन रू दोचा नु कोव़चा कली वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","मिनु परमप्रभु यावेमी मेको मुर कली “नेल्‍ल रवा ङा फल जने ब्‍वने चाप्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","तन्‍न रिम्‍शो नु मरिम्‍शो तुइक्‍पाइक्‍ब रवा रे ब्‍वचा मदुम्‍ब। तेको नाक्‍त ब्‍वाइनेवे, मेको नाक्‍तीन बेक्‍नेवे” दे अरेवा बाक्‍त। रोमी ६:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","मिनु परमप्रभु यावेमी “मुर का ला बाक्‍चा मरिम्‍शो दुम्‍ब। गो मेको नु बाक्‍चा कली वारच पाइब का सेल्‍नुङ” देंमाक्‍त। उपदेसक ४:३० ");
INSERT INTO suzBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","मिनु परमप्रभु यावेमी आ खप के सेल्‍शो मार मार जन्‍तु नु सरीङम बेरब चिक्‍ब आन कली मुरुम मार मार नें वोइक्‍बाक्‍मे, दे मुर आ बाक्‍तीके चाक्‍मी बाक्‍त। मिनु मुरुमी ब्रोंइशा बाक्‍ब नेल्‍ल आन कली नें वोदा बाक्‍त। मार नें वोदा, मेको नें लीमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","मुरुमी बी ब्‍यफ, सरीङम बेरब चिक्‍ब नु ब्‍वाकी ङा जन्‍तु नेल्‍ल आन कली नें वोदा बाक्‍त। तन्‍न मुर कली मेको नु बाक्‍चा कली वारच पाइब मबाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","मिनु परमप्रभु यावेमी आदम कली मारेइ मतुइक्‍चा ङा पा निन्‍द्रा पपदा बाक्‍त। मिनु मेको के जेरी का शोला बाक्‍त। मिनु मेको पोव़ला कली श्‍येमी सुवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","मिनु परमप्रभु यावेमी मेको शोल्‍शो जेरी के मीश मुर का सेल्‍शा, मुर आ बाक्‍तीकेमी चाक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","मिनु आदममी “ओहो, एको रुश, आं रां ङा रुश बाक्‍त। एको श्‍ये आं रां ङा श्‍ये बाक्‍त” दे तुइक्‍ता बाक्‍त। मिनु मेकोमी “मेको आ नें मीश मुर वोइक्‍चा माल्‍ब। मारदे हना वोंइश मुर आ रां रे शोल्‍शो बाक्‍ब” दें‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","मोपतीके वोंइश मुरुमी आ आंम आफ आस कली प्रोंइशा, आ मीश नु काथा बाक्‍ब। मेको निक्‍शी रां का दुम्‍नीस। मत्ती १९:५-६; १कोरिन्‍थी ६:१६; एफिसी ५:३१ ");
INSERT INTO suzBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मेना आदम नु आ मीश निम्‍फा शिश्रा बाक्‍सा बाक्‍त। मुने चहिं मतुइक्‍बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","मिनु परमप्रभु यावे आ सेल्‍शो जन्‍तु आन दातेमी नेल्‍ल क्‍येङा निप्‍स पाइश्‍शो बुस्‍स दुम्‍माक्‍त। मिनु बुस्‍सुमी मीश मुर कली “परमप्रभुमी इस कली ‘एको रू ङा रवा आन फल मारेइ मब्‍वसे’ देंमे?” दे हिल्‍लो पवा बाक्‍त। प्रकाश १२:९; प्रकाश २०:२ ");
INSERT INTO suzBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","मिनु मीश मुरुमी बुस्‍स कली “गो एको रू ङा रवा आन फल ब्‍वचा दुम्‍नस्‍कु। उत्‍पत्ती २:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","तन्‍न रू आ दातेमी बाक्‍शो रवा आ फल आ पर्बम परमप्रभुमी ‘मब्‍वचा, मथिचा यो। ब्‍वाइतीसी हना, गे बेक्‍नीसी’ देंत” देंमाक्‍त। उत्‍पत्ती २:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तन्‍न बुस्‍सुमी “गे बेक्‍सीन मबेक्‍नीसी। यूहन्‍ना ८:४४ ");
INSERT INTO suzBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ब्वाइतीसी हना, इस कली रिम्‍शो नु मरिम्‍शो मार बाक्‍बा तुइक्‍पाइक्‍ब। मिनु गे परमप्रभु खोदेंशो दुम्‍नीसी। मेकोन परमप्रभुमी तुइक्‍ताक्‍व” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","मिनु मीश मुरुम मेको रवा तशा ब्‍वशोनु, ब्रोव़चा ङा कोव़शोनु, दारशो, रुप्‍तीक थुं गेचा ङा तवा बाक्‍त। मोपतीके फल सेक्‍शा, ब्‍ववा बाक्‍त। मेको आ नेक्‍था बाक्‍ब आ वोंइश कली यो गेवा बाक्‍त। मेकोमी यो ब्‍ववा बाक्‍त। याकूब १:१४-१५; १तिमोथी २:१४ ");
INSERT INTO suzBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","मिनु नोले निम्‍फा शिश्रा बाक्‍शो तुइक्‍तसे बाक्‍त। मिनु फोव़शी रवा आ सफा सेक्‍शा फेक्‍तीक सेल्‍से बाक्‍त। उत्‍पत्ती २:२५ ");
INSERT INTO suzBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","मिनु नाक्‍नाक्‍दो मेको निक्‍शीमी परमप्रभु यावे रूमी हिरशो नेन्‍से बाक्‍त। मिनु “परमप्रभु यावेम मतचा ङा पा ख्रुइक्‍चा” दे रवा आन दातेमी लशा, ख्रुइक्‍ससा बाक्‍त। भजन संग्रह १३९:७-१०; येरमीया २३:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","मिनु परमप्रभु यावेमी आदम कली “ते बाक्‍ङे?” दे ब्रेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","मेकोमी “गो इन गाक्‍शो नेंता। मिनु गो शिश्रा बाक्‍तीके, हिंशा ख्रुइक्‍साक्‍यी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","मिनु “गे शिश्रा बाक्‍नेवे, दे दोपा तुइक्‍नेवे? मब्‍वचा देंशो रवा आ फल ब्‍ववी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","मिनु मुरुमी “इन गेशो मीश मुरुमी आं कली मेको रवा आ फल गेती। मिनु गो ब्‍वाता” देंमाक्‍त। २कोरिन्‍थी ११:३ ");
INSERT INTO suzBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","मिनु परमप्रभु यावेमी मेको मीश मुर कली “मार पवी?” दे हिल्‍लो पवा बाक्‍त। मीश मुरुमी “बुस्‍सुमी आं कली जोल पा ब्‍वपाइक्‍ती। मिनु गो ब्‍वाता” देंमाक्‍त। २कोरिन्‍थी ११:३ ");
INSERT INTO suzBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","मिनु परमप्रभु यावेमी बुस्‍स कली “बी ब्‍यफ नु ब्‍वाकी ङा जन्‍तु नेल्‍ल आन दातेम गे सराप राइनेवे। मारदे हना मोदेंशो मरिम्‍शो पाप्‍तीवी। इ रांमी ग्रेशा गाक्‍चा माल्‍नेवे। इ ब्रोंइतीक नाक्‍त सम्‍म खप जशा, बाक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","गे नु मेको मीश मुर जिशा, बाक्‍चा मलीसे। मेको आ युइ नु इ युइ जिशा बाक्‍नीमी। मीश मुर आ युइ कामी इ पिया दिम्‍शा प्रोल्‍ब। गे चहिं मेको आ गेंग्रेम कोक्‍नेवे” दे सराप पदा बाक्‍त। प्रकाश १२:४-५,१५-१७ ");
INSERT INTO suzBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","मिनु मेकोमी मेको मीश मुर कली “कोव़ज कुरशा, आल थिवेनु, इ कली ठेयब श्‍येत गेनुङ। आल थिचा रोइ पाइनेवे। मो हना यो इ वोंइश कली माल्‍नेवे। मिनु मेकोमी इ कली हुकुम पाइब” देंमाक्‍त। एफिसी ५:२२-२३; १तिमोथी २:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","मिनु आदम कली “मारदे हना गे इ मीश आ लोव़ नेंशा, मब्‍वचा देंशो रवा आ फल ब्‍वाप्‍तीवी, इ पतीके आ पर्बम इ रू नेल्‍लेमी सराप ताइनीम। इ जचा थोव़क श्‍येत पा ख्रुम्‍चा माल्‍नेवे। उत्‍पत्ती ८:२१-२२; अय्‍युब ३१:३८-३९ ");
INSERT INTO suzBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","इ रूमी चू नु चोंक वानीम। मिनु गे गिगी खाइ ब्‍वचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","इ कुप्‍फी रे गाल यिपाइश्‍शा शोब्‍ले जचा माल्‍नेवे। गे खप मदुमे सम्‍म मोदेंशो पचा माल्‍नेवे। मारदे हना गो इ कली खप रे सेल्‍शो नङ” दे परमप्रभु यावेमी आदम कली देंमाक्‍त। उत्‍पत्ती २:७; भजन संग्रह ९०:१०; भजन संग्रह १०४:२९; उपदेसक १२:७; २थिस्‍सलोनिकी ३:१० ");
INSERT INTO suzBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","मिनु आदममी आ मीश कली हव्‍वा नें वोदा बाक्‍त। मारदे हना मेको ब्रोंइब मुर नेल्‍ल आन ममा दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","मिनु परमप्रभु यावेमी आदम नु आ मीश आस कली कुशुल के फेक्‍तीक सेल्‍शा, फेक्‍तीम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","मिनु परमप्रभु यावेमी “मुर इं खोदेंशो दुम्‍त। रिम्‍शो नु मरिम्‍शो तुइक्‍ब दुम्‍त। मेको ब्रोंइपाइक्‍ब रवा आ फल यो सेक्‍शा, ब्‍वाप्‍तु हना, गेना हना यो ब्रोंइब, गेनायो मबेक्‍ब दुम्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","मोपतीके परमप्रभु यावेमी खप रे सेल्‍शो मुर कली एदेन माइश्‍शो रू रे ग्रुंइ‍शा, अरु रूम गेय पथ सोइक्‍ता बाक्‍त। उत्‍पत्ती २:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","परमप्रभुमी मेको आस कली खेरसी बाक्‍त। मेको आस कली खेरशा, एदेन रू ङा पूर्बमी आ स्‍वर्ग ङा करूब माइश्‍शो गेय पाइब वोदा बाक्‍त। मेकेर मी ब्रशो एर ओंथ हिरब तरवार का यो वोदा बाक्‍त। मेको ब्रोंइपाइक्‍ब रवा आ फल ब्‍वचा मताम्‍सेक्‍ल, दे कोव़ब वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","मिनु नोले आदम आ मीश हव्‍वा नु इम्‍माक्‍त। मिनु हव्‍वाम कोव़ज कुरशा, तौ का थि‍माक्‍त। हव्‍वामी “परमप्रभु यावेमी आं कली वारच पा आल का गेती” देंमाक्‍त। मिनु आ नें काइन वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","मिनु मेको आ नोले लेंशा अर्को तौ का यो थि‍माक्‍त। मेको कली हाबील नें वोदा बाक्‍त। हाबील काइन आ लोक्‍ब बाक्‍माक्‍त। मेको आल निक्‍शी कोल्‍शा, हाबील भेडा गोठला दुम्‍माक्‍त। काइन चहिं रू ङा गेय पाइब दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","काबु काइनमी आ रू ङा सिश्‍शो मारेइ मारेइ थोव़क परमप्रभु यावे कली चढ़ेवा बाक्‍त। प्रस्‍थान २३:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबीलमी आ ङोंइती गिक्‍शो पाठा आ श्‍ये नु बोंसो परमप्रभु यावे कली चढ़ेवा बाक्‍त। मिनु परमप्रभु यावेमी हाबील आ चढ़ेशो ब्रवा बाक्‍त। प्रस्‍थान ३४:१९; लेवी ३:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","तन्‍न काइन आ चढ़ेशो मब्रवा बाक्‍त। मिनु काइन आ कुल राव किक्‍पा चुरमाक्‍त। प्रस्‍थान ३३:१९; हिब्रू ११:४ ");
INSERT INTO suzBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","मिनु परमप्रभु यावेमी काइन कली “मारदे चुरे? मारदे राव किक्‍ङे? ");
INSERT INTO suzBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","गे रिम्‍शो पाप्‍तीवी हना, गो इ कली मब्राइनुङा ङा? ब्राइनुङ। गे मरिम्‍शो पाप्‍तीवी हना, मुर साइक्‍ब जन्‍तु खोदेंशो पा, पाप इ लाप्‍चोमी बाक्‍ब। मिनु इ कली माल्‍ब। गे इ मरिम्‍शो थुं कली ग्राङो” देंमाक्‍त। गलाती ५:१७; रोमी ६:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","मिनु काइनमी आ लोक्‍ब हाबील कली “रूमी लस” देंमाक्‍त। मिनु रूमी बाक्‍सानु, काइनमी हाबील कली सदा बाक्‍त। १यूहन्‍ना ३:१२,१५ ");
INSERT INTO suzBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","मिनु परमप्रभु यावेमी काइन कली “इ लोक्‍ब ते बाक्‍म?” दे हिल्‍लो पवा बाक्‍त। मिनु काइनमी “ङाद, गो आं लोक्‍ब आ गोठला नङा ङा?” देंमाक्‍त। उत्‍पत्ती ३:९ ");
INSERT INTO suzBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","मिनु मेकोमी “नेनो, मार पवी? इ लोक्‍ब आ हुशेमी आं कली खप रे ब्रेश्‍शो नेंता। भजन संग्रह ९:१३; मत्ती २३:३५; हिब्रू १२:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","मुल गे सराप रशा, इ रू रे खेरचा पुंइसीनेवे। मारदे हना इ लोक्‍ब आ हुश मेकेर जारशो बाक्‍ब। गन्‍ती ३५:३३ ");
INSERT INTO suzBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","मुल रे गे रू ङा गेय पवीनु, मारेइ मग्रेल्‍ब। रागी प्रोंइशा, गाक्‍ब मुर दुम्‍चा माल्‍नेवे” दे परमप्रभु यावेमी देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","मिनु काइनम परमप्रभु यावे कली “इन गेशो सजाइ ठेयब बाक्‍ब। मोमो श्‍येत गेतीनी हना, फाल्‍ने मचाप्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","मुलाक्‍ती आं कली आं रू रे ग्रुंइ‍ताक्‍यीनी। मिनु इन नेक्‍था बाक्‍चा मताइनुङ। गो मुल रागी प्रोंइशा, गाक्‍ब मुर दुम्‍नुङ। आं कली सुम थित्‍तेक्‍म हना यो, साइक्‍नीम” देंमाक्‍त। अय्‍युब १५:२०-२४ ");
INSERT INTO suzBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","मिनु परमप्रभु यावेमी “ममाइ, सुइमी इ कली साइक्‍तेमी हना, इ तशो सराप मेको कली ७ खेयप रचा माल्‍ब” देंमाक्‍त। मिनु परमप्रभु यावेमी “काइन कली सुइमी मसदमेक्‍ल” दे आ रांम चिनु वोदा बाक्‍त। इजीकीएल ९:६; प्रकाश ७:३-४ ");
INSERT INTO suzBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","मिनु नोले काइन परमप्रभु यावे आ ङोंइती रे लमाक्‍त। मिनु एदेन आ पूर्ब गे, नोद माइश्‍शो रागीम जाक्‍दीश्‍शा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","मिनु काइन आ मीश नु इम्‍‍माक्‍त। मिनु मेकोमी कोव़ज कुरशा, हनोक थि‍माक्‍त। मिनु काइनम सहर का सेला बाक्‍त। मेको सहर कली आ तौ हनोक आ नें खोदेंशो पा हनोक नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोकमी इराद थि‍माक्‍त। इरादमी मेहुयाएल थि‍माक्‍त। मेहुयाएल मेथुशाएल आ आफ दुम्‍माक्‍त। मेथुशाएल लमेक आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","मिनु लमेकमी मीश निक्‍शी चाक्‍गा बाक्‍त। का आ नें आदाह नु अर्को आ नें चिल्‍लाह बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","मिनु आदाहमी याबाल थि‍माक्‍त। मेको ताम्‍बुम बाक्‍ब नु गोठम बाक्‍ब बस्‍तु योव़ब आन किकी पिपी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","मेको आ लोक्‍ब आ नें यूबाल बाक्‍माक्‍त। मेको बीना नु मुइक्‍तीके ताप्‍ब आन किकी पिपी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","मिनु चिल्‍लाहमी तूबल-काइन थि‍माक्‍त। मेकोमी कांसा नु फलाम के मार मार सेल्‍तीक गेय पवा बाक्‍त। तूबल-काइन आ समी नामा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","मिनु लमेकमी आ मीश निक्‍शी आस कली “आदाह नु चिल्‍लाह, आं लोव़ नेनीस, गे लमेक आ मीश निक्‍शी, आं सेंदा नेंशा, होस पसे। गो मुर का साइक्‍ता। मारदे हना मेको ठिटामी आं कली तुप्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","काइन साइक्‍ब ७ खेयप क्‍येक्‍क लेत्‍चा पुंइसीब हना, लमेक साइक्‍ब ७७ खेयप क्‍येक्‍क लेत्‍चा पुंइसीब” देंमाक्‍त। उत्‍पत्ती ४:१५; लेवी १९:१८; ब्‍यवस्‍था ३२:३५; मत्ती १८:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","मिनु आदम लेंशा आ मीश नु इप्‍‍शा, तौ का थि‍माक्‍त। मेको कली सेथ नें वोदा बाक्‍त। हव्‍वामी “परमप्रभुमी हाबील आ पा ङा अर्को तौ का गेती। मारदे हना काइनमी हाबील कली साइक्‍तु” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","मिनु सेथमी यो तौ का थि‍माक्‍त। मिनु मेको कली एनोश नें वोदा बाक्‍त। मिनु मेना रे मुरपुकीमी परमप्रभु यावे कली पुंइचा नु ठेयब सेल्‍चा गोव़मे बाक्‍त। उत्‍पत्ती १२:८ ");
INSERT INTO suzBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","एको आदम आ चच, युइ बाक्‍नीम। परमप्रभुमी मुर सेलानु, आ खोदेंशो पा सेला बाक्‍त। लूका ३:३७-३८; उत्‍पत्ती १:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","वोंइश मुर का नु मीश मुर का सेला बाक्‍त। मिनु मेको आस कली आसीक गेशा, आस नें मुर वोंइ‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","मिनु आदम सहे का ३० बर्स दुम्‍मेनु, आ खोदेंशो तौ का थि‍‍माक्‍त। मिनु मेको कली सेथ नें वोदा बाक्‍त। भजन संग्रह ५१:७; १कोरिन्‍थी १५:४५ ");
INSERT INTO suzBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","सेथ थिशा नोले आदम ८ सहे बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","मिनु आदम नेल्‍ल पा ९ सहे ३० बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","मिनु सेथ सहे का ५ बर्स दुम्‍मेनु, तौ का थि‍‍माक्‍त। मेको कली एनोश नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश थिशा नोले ८ सहे ७ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","मिनु सेथ नेल्‍ल पा ९ सहे १२ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","मिनु एनोश ९० बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली केनान नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान थिशा नोले ८ सहे १५ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","मिनु एनोश नेल्‍ल पा ९ सहे ५ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","मिनु केनान ७० बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली मा-हालालेल नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","केनान मा-हालालेल थिशा नोले ८ सहे ४० बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","मिनु केनान नेल्‍ल पा ९ सहे १० बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","मिनु मा-हालालेल ६५ बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली यरेद नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","यरेद थिशा नोले ८ सहे ३० बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","मिनु मा-हालालेल नेल्‍ल पा ८ सहे ९५ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","मिनु यरेद सहे का ६२ बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली हनोक नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","यरेद हनोक थिशा नोले ८ सहे बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","मिनु यरेद नेल्‍ल पा ९ सहे ६२ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","मिनु हनोक ६५ बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली मेथुसेलाह नें वोदा बाक्‍त। हनोक कली हिब्रू लोव़मी एनोक देंनीम। ");
INSERT INTO suzBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","हनोक आ थुंमी परमप्रभु आ नेक्‍था बाक्‍शो बाक्‍माक्‍त। हनोक मेथुसेलाह थिशा नोले सहे सां बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। उत्‍पत्ती ६:९ ");
INSERT INTO suzBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","मिनु हनोक नेल्‍ल पा सहे सां ६५ बर्स दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमप्रभु नु गाक्‍बाक्‍माक्‍त। मिनु परमप्रभुमी हनोक कली आ बाक्‍तीक लदा बाक्‍त। मुरपुकीम हनोक कली माल्‍शा, मथिदमे बाक्‍त। २राजा २:११; हिब्रू ११:५ ");
INSERT INTO suzBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मिनु मेथुसेलाह सहे का ८७ बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। मेको कली लमेक नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","मेथुसेलाह लमेक थिशा नोले ७ सहे ८२ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मिनु मेथुसेलाह नेल्‍ल पा ९ सहे ६९ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","मिनु लमेक सहे का ८२ बर्स दुम्‍मेनु, तौ का थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","मेको कली नोआह नें वोदा बाक्‍त। मेको नें आ अर्थ थुं बारपाइक्‍तीक बाक्‍ब। मिनु लमेकमी “परमप्रभु यावेमी खप कली सराप पाप्‍तु। आं तौ रूम गेय पपाइक्‍तीके श्‍येत रे प्रोंइब बाक्‍ब” देंमाक्‍त। उत्‍पत्ती ३:१७-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","लमेक नोआह थिशा नोले ५ सहे ९५ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","मिनु लमेक नेल्‍ल पा ७ सहे ७७ बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","मिनु नोआह ५ सहे बर्स दुम्‍मेनु, शेम हाम नु यफेथ थी‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","मिनु नोले रागीमी मुर शुश दुम्‍मा बाक्‍त। मेकोपुकीमी शुश तमी थीमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","मिनु परमप्रभु आ तौपुकीमी मुर आन तमी आन कली तशा “दारशो बाक्‍नीम” दे मिम्‍तमे बाक्‍त। मिनु मेको आन दाते रे योव़शा चाक्‍ग्‍मे बाक्‍त। अय्‍युब १:६; २पत्रुस २:४; यहूदा ६ ");
INSERT INTO suzBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","मिनु परमप्रभु यावेमी “आं सोक्‍त मुर आन कली शुश बर्स बाक्‍चा मगेनुङ। मुर बेक्‍चा माल्‍नीम। आन ब्रोंइतीक सहे का २० बर्स ला दुम्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","मेना रागीमी नेफीलीम माइश्‍शो थम लाइश्‍शो मुरपुकी बाक्‍शो बाक्‍मा बाक्‍त। मिनु नोले परमप्रभु आ तौपुकीमी रागी ङा तमी आन कली चाक्‍शा, आल थीमे बाक्‍त। मेको बोल्‍यो नु ठेयब लडाइ पाइब मुर दुम्‍मा बाक्‍त। इजीकीएल ३२:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","मिनु परमप्रभु यावेमी “रागीम बाक्‍शो मुर आं अरेशो मटीब नु मरिम्‍शो पाइब ला बाक्‍नीम। मार मिम्‍ताक्‍म हना यो, मरिम्‍शो बाक्‍त” दे मिम्‍ता बाक्‍त। उत्‍पत्ती ८:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","मिनु परमप्रभु यावेमी आंम सेल्‍शो मुर आन कली तशा, शुश आ थुं मनुथु बाक्‍शो बाक्‍माक्‍त। १सामुएल १५:११-३५; येरमीया १८:७-१० ");
INSERT INTO suzBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","मिनु परमप्रभु यावेमी “आं सेल्‍शो मुर आन कली रागी रे क्‍याम्‍नुङ। मुर नु जन्‍तु नेल्‍ल क्‍याम्‍नुङ। खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु सरीङम बेरब चिक्‍ब यो क्‍याम्‍नुङ। मारदे हना गो मेको आन कली सेल्‍शा यो, आं थुं मनुङ” दे मिम्‍ता बाक्‍त। गन्‍ती २३:१९; रोमी ३:३-४; २तिमोथी २:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","मिनु परमप्रभु यावेमी नोआह तवानु, मेको कली दाक्‍ता बाक्‍त। हिब्रू ११:७ ");
INSERT INTO suzBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोआह आ तौ सां बाक्‍मा बाक्‍त। नोआह शुश रिम्‍शो मुर बाक्‍माक्‍त। मुर नेल्‍लेमी “ठीक पाइब दोस मताइब मुर बाक्‍ब” दे तुइक्‍तमे बाक्‍त। नोआह परमप्रभु नु गाक्बाक्‍माक्‍त। उत्‍पत्ती ५:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","मिनु नोआह आ तौ सां आन नें शेम, हाम नु यफेथ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमप्रभुमी मुर आन कली कोव़ङानु, नेल्‍ल मरिम्‍शो बाक्‍मा बाक्‍त। रागी नेल्‍ल हुश ख्राक्‍श पोक्‍तीकेमी ब्रीमाक्‍त। अर्को मरिम्‍शो पाइब यो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","मिनु परमप्रभुमी रागीम बाक्‍ब मुर आन कली कोव़ङानु, शुश मरिम्‍शो बाक्‍मा बाक्‍त। मुर नेल्‍लेमी आन द‍ला दाक्‍स पामे बाक्‍त। भजन संग्रह १४:२-३ ");
INSERT INTO suzBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","मिनु परमप्रभुमी नोआह कली “गो मुर नेल्‍ल आन कली क्‍याम्‍नुङमी। मारदे हना मेको आन पर्बम रागी हुश ख्राक्‍श पोक्‍तीकेमी ब्री‍त। मुर नु रागी नेल्‍ल आन कली क्‍याम्‍नुङ। आमोस ८:२ ");
INSERT INTO suzBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","गे चहिं खिं खोदेंशो पा शी के ठेयब डोंगा का सेलो। मिनु आगामी कोठापुकी सेलो। ब्‍वाक्‍कु मओव़चा ङा पा आगा नु लाङगा अल्‍कत्राम सिल्‍दो” दे नोआह कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","मिनु परमप्रभुमी “डोंगा दोपा सेल्‍चा माल्‍नेवे देंशा हना, मेको आ लाइश्‍शो सहे सां कुबीत दुम्‍चा माल्‍ब। आ ब्रेम्‍शो ५० कुबीत दुम्‍चा माल्‍ब। आ ग्‍येत्‍थ लाइश्‍शो ३० कुबीत दुम्‍चा माल्‍ब। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","मिनु छाना रे हात का प्रोंइशा, फश ग्रूतीक बोखा का सेल्‍चा माल्‍नेवे। मिनु का पटटीम लाप्‍चो का वोइक्‍चा माल्‍नेवे। आगामी खप तला का, दाते तला का नु तला तारी बाक्‍तीक का सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","आं देंशो रिम्‍शो पावो। मारदे हना गो मारेइ मारेइ साइक्‍चा कली रागी ब्‍वाक्‍कुम प्रिंनुङ। रागीम मार मार सेस बाक्‍मा, मेको नेल्‍ल बेक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तन्‍न गो इन कली कोव़नुङ, गे नु आं कबल पाइनुङ। मिनु गे, इ तौपुकी, इ मीश, नु इ चाइमीपुकी मेको डोंगामी ओव़चा माल्‍नीनी। मेको नेल्‍ल गे नु ब्रोंइचा माल्‍नीम। मेको पोथी भाले, बी ब्‍यफ नेल्‍ल निक्‍‍निक्‍शी बाक्‍चा माल्‍नीम। उत्‍पत्ती ९:९ ");
INSERT INTO suzBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","गेपुकी नु मारेइ मारेइ सेस जन्‍तु निक्‍‍निक्‍शी ओव़चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","मारेइ मारेइ चिक्‍ब, मारेइ मारेइ जन्‍तु नु मारेइ मारेइ खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु निक्‍‍निक्‍शी ब्रोंइचा, दे गे नु डोंगामी ओव़शा, बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","मिनु इन कली, मार मार जचा ब्‍वचा ओंइशा, उप्‍शा वोतो। मेको इन कली नु मेको आन कली जचा थोव़क दुम्‍ब” दे परमप्रभुमी नोआह कली अरेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","मिनु परमप्रभुमी मार मार मदा, नोआहमी नेल्‍ल टिशा, पवा बाक्‍त। हिब्रू ११:७ ");
INSERT INTO suzBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","मिनु परमप्रभु यावेमी नोआह कली “गे नु इ खिं ङा मुर नेल्‍ल शी के ठेयब डोंगामी ओव़ङीन। मारदे हना एको पाला ङा मुर आन दातेमी गे का ला ठीक पाइब बाक्‍नेवे। उत्‍पत्ती ६:८ ");
INSERT INTO suzBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","गे चढ़ेचा दुम्‍ब बी ब्‍यफ, क्‍यारश बोका, भेडा सांड रे ७ जोड लतो। उत्‍पत्ती ८:२०; लेवी ११:- ");
INSERT INTO suzBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","मिनु चढ़ेचा दुम्‍ब सरीङम बेरब चिक्‍ब यो ७ जोड लतो। भाले नु पोथी लतो। मारदे हना मेकोपुकी रागीमी ब्रोंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","गो ७ नाक्‍त नोले ४० नाक्‍त नु ४० नाक्‍दो सम्‍म रेउ यिपाइक्‍नुङ। मिनु आं सेल्‍शो रागीम मार मार ब्रोंइशा बाक्‍मा, मेको नेल्‍ल आन कली साइक्‍नुङमी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","मिनु परमप्रभु यावेमी मार मार अरेवा, नोआहमी नेल्‍ल टिशा पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","रागीमी रेउ यिचा गोवानु, नोआह ६ सहे बर्स दुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","मिनु नोआहम मार पवा बाक्‍त देंशा हना, ङोंइती आ तौपुकी, आ मीश, आ चाइमीपुकी ब्‍वाक्‍कु रे प्रोंइचा कली ठेयब डोंगामी ओव़पाइक्‍मी बाक्‍त। १ पत्रुस ३:२० ");
INSERT INTO suzBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","मिनु चढ़ेचा दुम्‍ब बस्‍तु, चढ़ेचा मदुम्‍ब बस्‍तु नु चिक्‍ब नु मारेइ मारेइ खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु, ");
INSERT INTO suzBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","निक्‍‍निक्‍शी बी ब्‍यफ, जोड जोड भाले पोथी नोआह नु ठेयब डोंगामी ओव़मा बाक्‍त। परमप्रभुमी दोपा नोआह कली अरेवा, मोपा पवा बाक्‍त। उत्‍पत्ती ६:१९-२० ");
INSERT INTO suzBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","मिनु ७ नाक्‍त नोले रागीम ब्‍वाक्‍कु ब्रीचा गोवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","मिनु रेउ यिमेनु, उइ रे यो ब्‍वाक्‍कु बारशा कुचा गोवा बाक्‍त। मेना नोआह ६ सहे बर्स, महिना निक्‍शी १७ नाक्‍त दुम नाक्‍त मोदेंशो दुम्‍माक्‍त। प्रकाश ९:१ ");
INSERT INTO suzBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","मिनु ४० नाक्‍त नु ४० नाक्‍दो शुश रेउ यिमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","मेको रेउ यिचा आ ङोंइती नाक्‍ती नोआह नु आ तौ शेम, हाम, नु यफेथ सांफा, नोआह आ मीश नु आ चाइमी सांफा मेको डोंगामी ओव़मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","मिनु मारेइ मारेइ जन्‍तु, मारेइ मारेइ बी ब्‍यफ, क्‍यारश भेडा, मारेइ मारेइ खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु मारेइ मारेइ फ्रां पाइश्‍शो, ब्रोंइशा बाक्‍ब जन्‍तु ");
INSERT INTO suzBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जोड जोड पा नोआह नु ठेयब डोंगामी ओव़मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","मिनु ब्रोंइशा बाक्‍ब नेल्‍ल जोड जोड पा, भाले पोथी नेल्‍ल ओव़मा बाक्‍त। परमप्रभुमी नोआह कली दोपा अरेवा, मोपा नेल्‍ल टिशा पवा बाक्‍त। मेको नेल्‍ल ओव़मा नोले परमप्रभु यावेमी लाप्‍चो चोक्‍गा बाक्‍त। उत्‍पत्ती ६:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","मिनु ब्‍वाक्‍कु ४० नाक्‍त सम्‍म रागीम ब्रीना ब्रीन बाक्‍माक्‍त। ब्‍वाक्‍कु शुश बारशा, ब्‍वाक्‍कुमी ठेयब डोंगा कली कुरा बाक्‍त। ब्‍वाक्‍कु रागीम शुश बारमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","मिनु रेउ यिना यिन, ब्‍वाक्‍कु बारना बारन लमेनु, मेको डोंगा ब्‍वाक्‍कु तारी गाक्‍चा गोवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","रागी नेल्‍लेम ब्‍वाक्‍कु शुश दुम्‍शा, ठेयब डांडा यो सुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","डांडा क्‍येङा यो १५ कुबीत सम्‍म ग्‍येत्‍थ सुमा बाक्‍त। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","मिनु रागीम मार मार ब्रोंइशो बाक्‍मा, बी ब्‍यफ, क्‍यारश भेडा, ब्‍वाकी ङा जन्‍तु, रागीम फोंइ‍ब, खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु मुर नेल्‍ल बेक्‍मा बाक्‍त। २पत्रुस ३:५-६ ");
INSERT INTO suzBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","रागीम ब्रोंइशा बाक्‍ब नेल्‍ल बेक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","मोपा मेकोमी रागीम ब्रोंइशा बाक्‍ब मार मार बाक्‍मा, मुर, जन्‍तु खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु सरीङम बेरब चिक्‍ब नेल्‍ल क्‍याम्‍दा बाक्‍त। नोआह नु आ खिं ङा मुर ला प्रोंइमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","मिनु मेको ब्‍वाक्‍कु सहे का ५० नाक्‍त सम्‍म रागीम बारना बारन बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","मिनु परमप्रभुमी नोआह नु ठेयब डोंगामी बाक्‍ब नेल्‍ल ब्‍वाकी ङा जन्‍तु नु बी ब्‍यफ क्‍यारश भेडा आन कली मप्रेंदीमी बाक्‍त। मिनु परमप्रभुमी रागीम फश पपदा बाक्‍त। मिनु ब्‍वाक्‍कु सोव़माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","मिनु ब्‍वाक्‍कु बुक्‍तीके नेल्‍ल सोव़ना सोव़न लमा बाक्‍त। रेउ यो देक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","मिनु मेको ब्‍वाक्‍कु सोव़ना सोव़न लशा, सहे का ५० नाक्‍त नोले शुश सोव़माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","मिनु मेको बर्स ङा ७ महिना ङा १७ नाक्‍त मेको ठेयब डोंगा आरारात माइश्‍शो डांडामी जाक्‍दीश्‍शा दिक्‍माक्‍त। उत्‍पत्ती ७:११ ");
INSERT INTO suzBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","मिनु मेको बर्स ङा १० महिना सम्‍म ब्‍वाक्‍कु सोव़ना सोव़न लमाक्‍त। १० महिना ङा ङोंइती नाक्‍ती अर्को पहाड ङा डांडा तांइसमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","मिनु ४० नाक्‍त नोले नोआहम आ सेल्‍शो डोंगा ङा झेल रोक्‍गा बाक्‍त। उत्‍पत्ती ७:१२,१७ ");
INSERT INTO suzBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","मिनु मेकेर रे खद का सोइक्‍ता बाक्‍त। मेको रागी ङा ब्‍वाक्‍कु मसोव़म सम्‍म एर ओंथ बेरशा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","मिनु नोआहमी “ब्‍वाक्‍कु नेल्‍ल सोव़मा कों” दे तुइक्‍चा कली ढुकुर का यो सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","मेको ढुकुर चहिं जुक्‍तीक मथित्‍थु लेश्‍शा, नोआह आ बाक्‍तीके जाक्‍माक्‍त। मारदे हना आ लतीकेमी ब्‍वाक्‍कुम सुम्‍शो बाक्‍माक्‍त। मिनु नोआहम गुइ दिं‍शा ताक्‍शा, मेको कली ओंइदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","मिनु अर्को ७ नाक्‍ती रिम्‍शा, मेको ढुकुर कली लेंशा डोंगा रे सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","मिनु नाक्‍नाक्‍दो ढुकुरमी आ ठुंडमी नक वाशो तेल रवा आ सफा का कुरशा जाक्‍माक्‍त। मिनु नोआहमी “ब्‍वाक्‍कु नेल्‍ल सोव़माक्‍त” दे तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","मिनु नोले यो ७ नाक्‍त रिम्‍शा, ढुकुर कली सोइक्‍ता बाक्‍त। मिनु मेको ढुकुर मलेम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","मेको नोआह ६ सहे बर्स का दुम्‍मे आ ङोंइती ङा महिना ङा ङोंइती ङा नाक्‍तीम रागीमी ब्‍वाक्‍कु सोव़माक्‍त। नोआहमी ठेयब डोंगा आ छाना थूशा, कोव़शा “लो, ब्‍वाक्‍कु नेल्‍ल सोव़माक्‍त” देंमाक्‍त। उत्‍पत्ती ७:११ ");
INSERT INTO suzBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","मिनु महिना का नु २७ नाक्‍त नोले खप नेल्‍ल सोव़माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","मिनु परमप्रभुमी नोआह कली ");
INSERT INTO suzBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“गे, इ मीश, इ तौपुकी नु इ चाइमीपुकी डोंगा रे ग्रूङीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","मिनु “मारेइ मारेइ ब्रोंइशा बाक्‍ब, चिक्‍ब, जन्‍तु नु खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नेल्‍ल आन कली यो ग्रुंइदो। मेकोपुकी सोशा बोशा रागीम शुश दुम्‍चा माल्‍नीम” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","मिनु नोआह, आ तौपुकी, आ मीश नु आ चाइमीपुकी ग्रूमा बाक्‍त। २ पत्रुस २:५ ");
INSERT INTO suzBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","मिनु जन्‍तु नेल्‍ल, खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नेल्‍ल, चिक्‍ब नेल्‍ल नु रागीम ब्रोंइशा बाक्‍ब मार मार नेल्‍ल डोंगा रे ग्रूमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","मिनु नोले नोआहम परमप्रभु यावे कली चढ़ेतीक का सेला बाक्‍त। मिनु चढ़ेचा दुम्‍ब बस्‍तु नु चढ़ेचा दुम्‍ब चिक्‍ब नेल्‍ल लाइश्‍शा चोशा चढ़ेतीक चढ़ेवा बाक्‍त। उत्‍पत्ती ७:२ ");
INSERT INTO suzBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","मिनु परमप्रभु यावेमी मेको ब्रोव़शो रिना नाम्‍शा, ग्‍येरसे बाक्‍त। आ थुंमी “मुरुम मरिम्‍शो पतीकेम खप कली मुल सराप गेनायो मपाइनुङ। मुर आ थुं मरिम्‍शो बाक्‍त हना यो, गेनायो सराप मपाइनुङ। गो ब्रोंइशा बाक्‍ब नेल्‍ल आन कली साइश्‍शा क्‍याम्‍ताक्‍ङ। मोदेंशो गेनायो लेंशा मपाइनुङ। उत्‍पत्ती ६:५; अय्‍युब १४:४; भजन संग्रह १४:३; मत्ती १५:१९; रोमी ३:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","रागी बाक्‍म सम्‍म शोक्‍चा, ख्रुम्‍चा नु रिक्‍चा तांइसीब। ग्‍यू पाइब, हुप्‍ब, हिंउद नु बर्खा दुम्‍ब। नाक्‍दो नाक्‍त दुम्‍ब” दे लोव़ पवा बाक्‍त। येरमीया ३३:२०,२५ ");
INSERT INTO suzBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","मिनु परमप्रभुमी नोआह नु आ तौ आन कली आसीक गेमी बाक्‍त। मेकोमी “तमी तौ थिशा, सोशा बोशा शुश दुमीन। रागी प्रिंदीने। उत्‍पत्ती १:२८ ");
INSERT INTO suzBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","रागी ङा जन्‍तु नेल्‍ल, सरीङम बेरब चिक्‍ब, खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु नु समुन्‍द्र ङा ङांइ नेल्‍ल, इन कली तशा, हिंचा माल्‍नीम। मेको आन कली इन गुइमी गेता। ");
INSERT INTO suzBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ङोंइती इन कली गिगी खाइ ब्‍वचा गेता। मुल गो ब्रोंइशा बाक्‍ब जन्‍तु नेल्‍ल इन कली ब्‍वचा गेतन्‍नी। उत्‍पत्ती १:२९; कलस्‍सी २:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","क्‍योरशा हुश मचुइक्‍थु चहिं मब्‍वने। मारदे हना हुशेमी ब्रोंइतीक सोक्‍त बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","मुरुमी मुर कली साइक्‍तु हना, जन्‍तुमी मुर कली साइक्‍तु हना, मेको यो साइक्‍चा पुंइसीब। मुरुमी आ लोक्‍ब साइक्‍तु हना, मेको यो साइक्‍चा पुंइसीब। लेवी ३:१७; लेवी १७:१०-१४; ब्‍यवस्‍था १२:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","सु सुमी मुर साइश्‍शा हुश जारबा, मेको यो मोपान साइश्‍शा, हुश जारचा पुंइसीब। मारदे हना गो मुर कली आं खोदेंशो पा सेल्‍ता। प्रस्‍थान २१:१२; लेवी २४:१७; गन्‍ती ३५:३३; मत्ती २६:५२; रोमी १३:४; प्रकाश १३:१० ");
INSERT INTO suzBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","गे रागीम सोशा बोशा शुश दु‍मीने” दे परमप्रभुमी नोआह कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","मिनु नोले परमप्रभुमी नोआह नु आ तौ आन कली ");
INSERT INTO suzBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“नेनीन, गे नु इन नोले ङा चच युइ नु आं कबल पाइनुङ। उत्‍पत्ती ६:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","डोंगामी ब्रोंइशा बाक्‍ब चिक्‍ब, बी ब्‍यफ, रागी ङा जन्‍तु गे नु डोंगा रे ग्रूशो नेल्‍ल नु आं कबल पाइनुङ। होसे २:२० ");
INSERT INTO suzBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","गो मार कबल पाइनुङ देंशा हना, ब्रोंइशा बाक्‍ब नेल्‍ल आन कली ब्‍वाक्‍कुम मसाइक्‍नुङ। रागी बिग्रेचा कली गेनायो ब्‍वाक्‍कु मबारपाइक्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","मिनु परमप्रभुमी “गे नु गे नु ब्रोंइशा बाक्‍ब नेल्‍ल इन कली आं कबल पतीके चिनु का गेनुङ। मेको इन नोले ङा पाला नेल्‍ल आन कली यो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","गो गोस्‍सुमी आं वाक्‍श वोइक्‍नुङ। मेको गो रागी नु कबल पशो आ चिनु बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","मिनु गो रागी तारी गोस्‍स सोइक्‍तुनु, मेको गोस्‍सुमी आं वाक्‍श तांइसीब। ");
INSERT INTO suzBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","मिनु गो गे नु मारेइ मारेइ ब्रोंइशा बाक्‍ब नु कबल पाता, दे मिम्‍नुङ। गो गेनायो ब्रोंइशा बाक्‍ब नेल्‍ल आन कली ब्‍वाक्‍कुमी मसाइक्‍‍नुङमी। यसैया ५४:७-१० ");
INSERT INTO suzBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","मेको वाक्‍श गोस्‍सुम बाक्‍मेनु, गो मेको कली ताइनुङ। मिनु गो रागीम बाक्‍ब मुर नु ब्रोंइशा बाक्‍ब नेल्‍ल नु गेना हना यो लीब कबल पाता, दे मिम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","मिनु परमप्रभुमी नोआह कली “मेको वाक्‍श कबल आ चिनु बाक्‍ब। गो गे नु रागीम ब्रोंइशा बाक्‍ब नेल्‍ल नु कबल पाता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","डोंगा रे ग्रूशो नोआह आ तौपुकी शेम, हाम नु यफेथ बाक्‍मा बाक्‍त। हाम चहिं कनान आ आफ बाक्‍माक्‍त। उत्‍पत्ती ५:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","मेको सांफा नोआह आ तौ बाक्‍मा बाक्‍त। मेको रे रागी नेल्‍ल ब्रीमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","मिनु नोआह रूमी गेय पाइब दुम्‍शा, अङगुर रू सेला बाक्‍त। मेको नेल्‍ल क्‍येङा ङोंइती अङगुर ख्रुम्‍ब मुर दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","मिनु अङगुर शांबु तूशा दुक्‍शा, आ ताम्‍बुमी शिश्रा इम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","मिनु कनान आ आफ हाममी आ आफ शिश्रा तशा, लाङगामी बाक्‍शो आ लोक्‍ब आस कली देंमाक्‍त। प्रस्‍थान २०:१२; हितोपदेस ३०:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","मेको नेंशा, शेम नु यफेथम वा का सुर सुरम ग्‍याइश्‍शा लाप्‍शा, नोले रे ग्रेना ग्रेन लशा, आस आफ आ ताम्‍बु ओव़सा बाक्‍त। मिनु आस आफ आ भेत्रे रां सुम्‍से बाक्‍त। नोले रे ग्रेशा, आस आफ आ शिश्रा रां मताम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","मिनु नोले नोआह आ दुक्‍शो रे सेंसे बाक्‍त। आ चचमी आ कली मार पवा, नेल्‍ल तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","मिनु नोआहमी “कनान सराप रल। आ लोक्‍ब आस नेल्‍ल क्‍येङा आइक्‍च वाइल दुम्‍ल” दे सराप पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","मिनु मेकोमी लेंशा “परमप्रभु, शेम आ परमप्रभु यावे ठेयब बाक्‍ब। कनान मेको आ नेल्‍ल क्‍येङा आइक्‍च वाइल दुम्‍ल” दे शेम कली आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","मिनु लेंशा “परमप्रभुमी यफेथ कली ‘सोशा बोशा शुश दुम्‍पदल। मेको शेम आ ताम्‍बुम बाक्‍चा तवल। कनान चहिं मेको आ वाइल दुम्‍ल’ ” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","मिनु ठेयब ब्‍वाक्‍कु बारशा नोले, नोआह सहे सां ५० बर्स ब्रोंइमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","मिनु नोआह नेल्‍ल पा ९ सहे ५० बर्स ब्रोंइशा बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ब्‍वाक्‍कु बारम नोले नोआह आ तौपुकी शेम, हाम नु यफेथमी तौपुकी थीमा बाक्‍त। नोआह आ तौ आन चच युइ सु सु बाक्‍मा बाक्‍त देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","यफेथ आ तौ गोमेर, मागोग, मादै, यावान, तूबल, मेशेक नु तिरास बाक्‍मा बाक्‍त। इजीकीएल २७:१३-२२; इजीकीएल ३८:२; इजीकीएल ३९:१,६ ");
INSERT INTO suzBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेर आ तौपुकी अश्‍‍केनज, रीफत नु तोगारमाह बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावान आ तौपुकी एलीशाह, कित्तीम, टारशीश नु दोदानीम बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","मेको मुरपुकी रे समुन्‍द्र आ नेक्‍था बाक्‍ब जरमेशो बाक्‍मा बाक्‍त। मेकोपुकी यफेथ आ चच युइ बाक्‍मा बाक्‍त। मेकोपुकी आंम रागीम बाक्‍शो बाक्‍मा बाक्‍त। मिनु आंम रागी रागीमी, आंम खिं खिं ङा मुरुमी आंम लोव़ ब्‍वाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम आ तौपुकी कूश, इजीप्‍त, पूत नु कनान बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूश आ तौपुकी शेबा, हवीलाह, साब्‍ताह, रामाह नु साब्‍तेका बाक्‍मा बाक्‍त। रामाह आ तौ निक्‍शी शेबा नु देदान बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","मिनु कूशमी निम्रोद यो थि‍माक्‍त। मेको बोल्‍यो नु सक्ति पाइश्‍शो मुर दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","मेको परमप्रभु यावे आ ङोंइती सक्ति पाइश्‍शो सिखारी बाक्‍माक्‍त। मोपतीके मुरुमी बोल्‍यो मुर का तशा “परमप्रभु यावे आ ङोंइती निम्रोद खोदेंशो सक्ति पाइश्‍शो सिखारी बाक्‍बाक्‍त” दे देंतीके देंमा बाक्‍त। मत्ती ५:५ ");
INSERT INTO suzBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","मिनु आ ङोंइती ङा राज्‍य बेबीलोन बाक्‍माक्‍त। अरु एरेक नु अक्‍कद सहर बाक्‍मा बाक्‍त। मेको नेल्‍ल शिनार रागीम बाक्‍बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","निम्रोद मेको रागी रे अस्‍सुर जाक्‍शा, निनवे, रेहोबोथ-इर नु कालाह सहर सेला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","निनवे नु कालाह सहर आस दातेमी रेसेन सहर सेला बाक्‍त। मेको ठेयब सहर बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","इजीप्‍त, लूदीम, अनामीम, लेहाबीम, नफ्‍तुहीम, ");
INSERT INTO suzBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पथ्रुसीम, कस्‍लुहीम नु काफ्‍तोरीम आन आफ दुम्‍माक्‍त। मेकोपुकी रे पलिस्‍ती ग्रूमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","मिनु कनानमी आ ङोंइती ङा तौ सीदोन नु नोले हेथ थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","मिनु नोले यबुसी, एमोरी, गिरगाशी, ");
INSERT INTO suzBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्‍वी, अरकी, सिनी, ");
INSERT INTO suzBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अरवादी, सेमारी नु हमाथी थि‍माक्‍त। नोले कनान रागी ङा मुर शुश दुम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनान ङा मुर आन रागी सीदोन रे गेरार गे नु गाजा सम्‍म दुम्‍माक्‍त। सोदोम नु गोमोररा गे अदमाह, सेबोयीम नु लाशा सहर सम्‍म दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","मिनु हाम आ चच युइ आन खिं खिं ङा मुर आन लोव़, आन रू नु आन रागी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम यफेथ आ लोक्‍बमी यो तौपुकी थि‍माक्‍त। शेम एबेर आ आल आन किकी पिपी बाक्‍माक्‍त। उत्‍पत्ती ११:१० ");
INSERT INTO suzBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम आ तौ चच युइ सु सु बाक्‍मा बाक्‍त देंशा हना, एलाम, अश्‍शुर, अरपक्‍शाद, लूद नु अराम बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम आ तौपुकी ऊज, हुल, गेथेर नु माश बाक्‍मा बाक्‍त। उत्‍पत्ती २२:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","मिनु अरपक्‍शाद शेलाह आ आफ दुम्‍माक्‍त। शेलाह एबेर आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेरमी तौ निक्‍शी थि‍माक्‍त। का आ नें पेलेग बाक्‍माक्‍त। मारदे हना मेना रागी योक्‍शो बाक्‍माक्‍त। पेलेग नें आ अर्थ भाग का बाक्‍माक्‍त। अर्को आ नें योकतन बाक्‍माक्‍त। उत्‍पत्ती ११:८-९; ब्‍यवस्‍था ३२:८ ");
INSERT INTO suzBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","मिनु योकतनमी अल्‍मोदाद, शेलेफ, हासार-मावेथ येराह ");
INSERT INTO suzBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, उजाल, दिकलाह, ");
INSERT INTO suzBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमा-एल, शेबा, ");
INSERT INTO suzBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफीर, हवीलाह नु योबाब आन आफ दुम्‍माक्‍त। मेको नेल्‍ल योकतन आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","मिनु आन बाक्‍तीक मेशा रे पूर्ब ङा सेफार माइश्‍शो पहाड सम्‍म दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","मिनु शेम आ चच युइ आन खिं खिं ङा मुर आन लोव़, आन रू नु आन रागी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","मिनु मेको नोआह आ तौ नेल्‍ल आन खिं खिं ङा मुर, आन चच युइ, आन आन रागी बाक्‍मा बाक्‍त। ब्‍वाक्‍कु बारशा नोले मेकोपुकी रे रागी नेल्‍ल ब्रीमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ङोंइती रागी नेल्‍ल ङा मुर लोव़ का ब्‍वाक्‍बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","मुरपुकी पूर्ब गे लना लन बाक्‍मानु, शिनार नें पाइश्‍शो रागीम ठेयब दिंम का थित्‍मे बाक्‍त। मिनु मेकेर खिं सेल्‍शा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","मिनु मुरपुकीमी “लो, इंटा सेल्‍य। मिनु मीमी रिम्‍शो पा चोय” देंमा बाक्‍त। मिनु फुल्‍लु आ पा ङा इंटा नु हिलो आ पा ङा अल्‍कत्रा ग्रुंइदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","मिनु नोले मेकोपुकीमी “गोपुकी इं कली सहर का सेल्‍सीय, ठेयब लाइश्‍शो सरीङ थिचा ङा खिं का सेल्‍य। इं नें ठेयब सेल्‍सीशा, इं मुरपुकी रागी नेल्‍लेमी मब्राथु बाक्‍य” देंमुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","मिनु परमप्रभु यावे मेको मुरपुकीमी सेल्‍शो सहर नु सरीङ थिचशो ठेयब लाइश्‍शो खिं कोव़थ यिमाक्‍त। उत्‍पत्ती १८:२१; भजन संग्रह १४:२ ");
INSERT INTO suzBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","मिनु परमप्रभु यावेमी “लो, मेको नेल्‍ल थुं का ङा मुर नमी। मेको नेल्‍ल लोव़ का ब्‍वाक्‍नीम। मेको आन नक गोशो गेय ला बाक्‍ब। मार मार मिम्‍त्‍मे, मेको नेल्‍ल पने चाप्‍नीम। प्रेरित २:१-११ ");
INSERT INTO suzBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","मुल उइ लय। मेको आन पशो लोव़ खाल्‍शा पपाइय्‍य। मिनु कामी अर्को आ लोव़ मरुबल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","मोपा परमप्रभु यावेमी मुर आन कली नेल्‍ल रागीम फ्रादीमी बाक्‍त। मिनु मेकोपुकीमी सहर सेल्‍चा प्रोन्‍मे बाक्‍त। ब्‍यवस्‍था ३२:८; लूका १:५१ ");
INSERT INTO suzBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","मोपतीके मेको सहर आ नें बाबेल वोदमे बाक्‍त। मारदे हना मेकेर रे परमप्रभु यावेमी रागी नेल्‍ल ङा मुर आन लोव़ खाल्‍दा बाक्‍त। मिनु परमप्रभु यावेमी मोपा मुर नेल्‍ल आन कली फ्रादीमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम आ आ चच युइ सु सु बाक्‍मा बाक्‍त देंशा हना, शेम सहे का बर्स दुम्‍मेनु, अरपक्‍शाद आ आफ दुम्‍माक्‍त। मेना ब्‍वाक्‍कु बारशा सोव़शो बर्स निक्‍शी दुम्‍शो बाक्‍माक्‍त। १इतिहास १:२४-२७; लूका ३:३४-३६; उत्‍पत्ती १०:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","मिनु शेम अरपक्‍शाद थिशा नोले ५ सहे बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","मिनु अरपक्‍शाद ३५ बर्स दुम्‍मेनु, शेलाह आ आफ दुम्‍माक्‍त।। ");
INSERT INTO suzBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","मिनु शेलाह थिशा नोले ४ सहे बर्स सां ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","मिनु शेलाह ३० बर्स दुम्‍मेनु, एबेर थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","मिनु शेलाह एबेर थिशा नोले ४ सहे बर्स सां ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","मिनु एबेर ३४ बर्स दुम्‍मेनु, पेलेग आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","मिनु एबेर पेलेग थिशा नोले ४ सहे ३० बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","मिनु पेलेग ३० बर्स दुम्‍मेनु, रेऊ आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","मिनु पेलेग रेऊ थिशा नोले सहे निक्‍शी ९ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","मिनु रेऊ ३२ बर्स दुम्‍मेनु, सेरूग आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","मिनु रेऊ सेरूग थिशा नोले, सहे निक्‍शी ७ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","मिनु सेरूग ३० बर्स दुम्‍मेनु, नाहोर आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","मिनु सेरूग नाहोर थिशा नोले सहे निक्‍शी बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","मिनु नाहोर २९ बर्स दुम्‍मेनु, तेराह आ आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","मिनु नाहोर तेराह थिशा नोले सहे का १९ बर्स ब्रोंइमाक्‍त। अरु तमी तौ यो थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","मिनु तेराह ७० बर्स दुम्‍मेनु, अब्राम, नाहोर नु हारान आन आफ दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेराह आ चच युइ सु सु बाक्‍मा बाक्‍त देंशा हना, तेराह अब्राम, नाहोर नु हारान आन आफ दुम्‍माक्‍त। हारानमी लोत थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान चहिं आ आफ तेराह क्‍येङा ङोंइती आ जरमेशो कल्‍दी ङा ऊर सहरमी बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","मिनु अब्राम नु नाहोर निम्‍फामी ग्‍युंबे पाम्‍से बाक्‍त। अब्राम आ मीश आ नें साराइ बाक्‍माक्‍त। नाहोर आ मीश आ नें मिल्‍का बाक्‍माक्‍त। मिल्‍का हारान आ तमी बाक्‍माक्‍त। हारान मिल्‍का नु यिस्‍का आस आफ बाक्‍माक्‍त। उत्‍पत्ती २२:२० ");
INSERT INTO suzBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","साराइ आल मथीब बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","मिनु तेराहमी आ तौ अब्राम, आ चच लोत, हारान आ तौ, नु आ चाइमी, अब्राम आ मीश साराइ आन कली लाइश्‍शा, कल्‍दी रागी ङा ऊर रे कनान रागी लचा गोव़मे बाक्‍त। मिनु हारान माइश्‍शो सहर जाक्‍दीश्‍शा बाक्‍मा बाक्‍त। यहोसु २४:२; नेहेम्‍याह ९:७ ");
INSERT INTO suzBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेराह सहे निक्‍शी ५ बर्स दुम्‍शा, हारान सहरम बेक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","मिनु परमप्रभु यावेमी अब्राम कली “इ रागी, इ खिं खिं ङा मुर नु इ आफ आ खिं रे लावो। तेको रागी लचा माल्‍नेवे, गो इ कली कोंइ‍नन। गन्‍ती २३:९; प्रेरित ७:३; हिब्रू ११:८ ");
INSERT INTO suzBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","गो इ रे पा ठेयब जात ङा मुर सेल्‍नुङमी। गो इ कली आसीक गेनन। इ नें ठेयब सेल्‍नुङ। गे अर्को आन कली आसीक दुम्‍नेवे। उत्‍पत्ती २४:१,३५; भजन संग्रह ७२:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","सुमी इ कली आसीक गेवा, गो मेको कली आसीक गेनुङ। सुम इ कली सराप पाइबा, गो मेको कली सराप पाइनुङ। इ पर्बम रागी ङा मुर नेल्‍ल आसीक ताइनीम” देंमाक्‍त। उत्‍पत्ती १८:१८; उत्‍पत्ती २२:१८; उत्‍पत्ती २६:४; उत्‍पत्ती २८:१४; प्रस्‍थान २३:२२; प्रेरित ३:२५; गलाती ३:८ ");
INSERT INTO suzBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","मिनु अब्राम परमप्रभु यावे आ लोव़ नेंशा, हारान सहर रे गाक्‍माक्‍त। लोत यो अब्राम नु गाक्‍माक्‍त। हारान सहर रे गाक्‍मेनु, अब्राम ७५ बर्स, दुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राममी आ मीश साराइ, आ लोक्‍ब आ तौ, लोत, आन मारेइ मारेइ, हारान सहरमी ग्‍याप्‍शो वाइलीम वाइल आन कली यो लदा बाक्‍त। मिनु मेको नेल्‍ल कनान रागी लचा गोव़मे बाक्‍त। मिनु लशा कनान रागी जाक्‍दीम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","मिनु अब्राम कनान रागी जाक्‍दीश्‍शा, शेकेम सहर आ नेक्‍था मोरेह माइश्‍शो मुर आ रवा आ नेक्‍था जाक्‍दीम्‍माक्‍त। मेना कनान ङा मुरपुकी रागीम बाक्‍शो बाक्‍मा बाक्‍त। उत्‍पत्ती ३५:४; यहोसु २४:२५-२६ ");
INSERT INTO suzBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","मेकेर जाक्‍दीम्‍मेनु, परमप्रभु यावे अब्राम आ ङोंइती ग्रूशा, मेको कली “एको रागी इ चच युइ आन कली गेनुङ” दे लोव़ गेवा बाक्‍त। मिनु अब्राममी “गो परमप्रभु यावे कली ताता” दे चढ़ेतीक का सेला बाक्‍त। उत्‍पत्ती १३:१५; उत्‍पत्ती १५:१८; उत्‍पत्ती १७:८; उत्‍पत्ती ३५:१२; प्रस्‍थान ६:४,८; प्रस्‍थान ३२:१३; यहोसु २१:४३; प्रेरित ७:५ ");
INSERT INTO suzBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","मेकेर रे लशा, बेथेल सहर आ पूर्ब गे ङा डांडामी आ ताम्‍बु याक्‍शा कीङा बाक्‍त। बेथेल सहर पच्‍छिम गे नु ऐ सहर पूर्ब गे बाक्‍शा, मेकेर यो परमप्रभु यावे कली चढ़ेतीक का सेल्‍शा, परमप्रभु यावे कली लोव़ पा ठेयब सेला बाक्‍त। उत्‍पत्ती ४:२६ ");
INSERT INTO suzBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","मेकेर रे लशा, नेगेब माइश्‍शो रागी आ दक्‍खिन गे लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","मिनु मेको रागीम अन्‍काल बाक्‍माक्‍त। मोपतीके मेकेर रे लशा, इजीप्‍त रागीम बाक्‍थ, लमाक्‍त। मारदे हना ठेयब अन्‍काल बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","मिनु इजीप्‍त ओव़चा क्‍येङा ङोंइती अब्राममी आ मीश साराइ कली “नेनो, गे दारशो मीश मुर बाक्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिनु इजीप्‍त ङा मुरुम इ कली तशा ‘मेको आ मीश बाक्‍ब’ दे आं कली साइक्‍नीम। इ कली चहिं ब्रोंइचा गेनीम। ");
INSERT INTO suzBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","मोपतीके ‘आ समी नङ’ देनो। मिनु इ मो देंशो आ पर्बम गो साइक्‍चा मपुंइसीनुङ, ब्रोंइचा ताइनुङ” दे आ मीश कली मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","मिनु अब्राम इजीप्‍त रागीम जाक्‍दीम्‍मेनु, इजीप्‍त ङा मुरपुकीमी साराइ आ पर्बम “मेरे मीश मुर थम दारशो बाक्‍ब” देंमुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","मिनु फाराओ माइश्‍शो पिप आ मुरपुकीमी साराइ कली तशा “थम दारशो मीश मुर का ताइतक” दे मदमे बाक्‍त। मिनु साराइ कली फाराओ आ खिं लदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","मिनु साराइ आ पर्बम अब्राम भेडा, ब्‍यफ, गधा, वाइलीम वाइल नु दलओंठ मारेइ मारेइ गेचा पुंइसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","तन्‍न परमप्रभु यावेमी फाराओ नु आ खिं ङा मुर आन कली अब्राम आ मीश साराइ आ पर्बम ठेयब श्‍येत गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","मिनु फाराओमी अब्राम कली ब्रेश्‍शा “गे आं कली मार पवी? मारदे ‘इ मीश बाक्‍ब’ मदेने? ");
INSERT INTO suzBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","मारदे ‘आं समी बाक्‍ब’ देंने? गो हेरा आं मीश सेल्‍ता। मुल इ मीश लतो। एकेर रे लावो” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","फाराओमी मेको लोव़ आ मुर आन कली माइश्‍शा, अब्राम, आ मीश नु आ नु बाक्‍ब नेल्‍ल आन कली मेकेर रे सोइक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","मिनु अब्राम, आ मीश, आ मारेइ मारेइ नेल्‍ल नु लोत यो लाइश्‍शा इजीप्‍त रे नेगेब रागी लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम शुश बी ब्‍यफ क्‍यारश भेडा नु सुन चांदी पाइश्‍शो मुर बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","मिनु दक्‍खिन ङा नेगेब रे लशा, बेथेल सहर जाक्‍दीम्‍माक्‍त। मेकेर बेथेल सहर नु ऐ सहर आस दातेमी ङोंइती आ ताम्‍बु कीतीकेम जाक्‍दीम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","मिनु इजीप्‍त लचा क्‍येङा ङोंइती मेकेर सेल्‍शो चढ़ेतीकेमी लेश्‍शा जाक्‍दीश्‍शा, परमप्रभु यावे कली लोव़ पा, ठेयब सेला बाक्‍त। उत्‍पत्ती १२:८ ");
INSERT INTO suzBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","मिनु लोत के यो क्‍यारश भेडा, बी ब्‍यफ नु ताम्‍बु शुश बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","मिनु अब्राम नु लोत आस मारेइ मारेइ शुश दुम्‍तीके मेको निक्‍शी काथा बाक्‍ने मचाप्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","मिनु अब्राम आ गोठलापुकी लोत आ गोठलापुकी नु जीमे बाक्‍त। मेना मेको रागीम कनानी नु परिज्‍‍जीपुकी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","मिनु अब्राममी लोत कली “गो पोबु नस। जिचा मदुम्‍ब। इ गोठलापुकी नु आं गोठलापुकी यो जिचा मदुम। ");
INSERT INTO suzBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","गे नु गो ब्राचा रिम्‍शो दुम्‍ब। एको रागी नेल्‍ल इ ङोंइती बाक्‍ब। गे पेरा गे लते हना, गो ग्‍युरा गे लाइनुङ। गे ग्‍युरा गे लते हना, गो पेरा गे लाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","मिनु लोतमी यर्दन खोला आ नेक्‍था ब्‍वाक्‍कु बाक्‍शो रिम्‍शो दिंम तवा बाक्‍त। मेको परमप्रभु यावे आ रू नु इजीप्‍त रागी खोदेंशो दारशो तांइसे बाक्‍त। सोआर सहर सम्‍म मोदेंशो दारशो तांइसे बाक्‍त। परमप्रभु यावेम सोदोम नु गोमोररा सहर मीम जेप्‍पाइक्‍चा क्‍येङा ङोंइती मेकेर थाम्‍पा दारशो बाक्‍माक्‍त। उत्‍पत्ती २:८-१० ");
INSERT INTO suzBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","मिनु लोत यर्दन खोला ङा दिंम योव़शा, पूर्ब गे लमाक्‍त। मोपा लोत नु अब्राम ब्रासा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","मिनु अब्राम कनान रागीम बाक्‍शो बाक्‍माक्‍त। लोत चहिं यर्दन खोला ङा दिंमम बाक्‍शो सहर आन नेक्‍था बाक्‍शा, आ ताम्‍बु याक्‍ना याक्‍न सोदोम सहर सम्‍म जाक्‍दीम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सोदोम सहर ङा मुरपुकी थम मरिम्‍शो बाक्‍मा बाक्‍त। मेकोपुकीमी परमप्रभु यावे आ ङोंइती शुश मरिम्‍शो पामे बाक्‍त। उत्‍पत्ती १८:२०; उत्‍पत्ती १९:४-९ ");
INSERT INTO suzBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोत नु अब्राम ब्रासा नोले परमप्रभु यावेमी अब्राम कली “इ बाक्‍तीके रे पूर्ब, पच्‍छिम, उत्तर, दक्‍खिन गे कोव़ङो। ");
INSERT INTO suzBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","गे तेको तेको रागी ताइनेवे, मेकोन इ कली नु इ चच युइ आन कली गेना हना यो कली गेनुङ। उत्‍पत्ती १२:७ ");
INSERT INTO suzBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","गो इ चच युइ खप ङा फुरक खोदेंशो पा शुश सेल्‍नुङ। मुरुम फुरक हिक्‍ने चाप्‍तेक्‍म हना ला, इ चच युइ आन कली यो हिक्‍ने चाप्‍नीम। तन्‍न मचाप्‍नीम। उत्‍पत्ती २८:१४; गन्‍ती २३:१०; १राजा ४:२० ");
INSERT INTO suzBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","बोक्‍को, रागी नेल्‍ल हिरशा लावो। मेको नेल्‍ल इ कली गेनन” दे परमप्रभु यावेमी लोव़ गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","मिनु अब्राममी आ ताम्‍बु याक्‍शा, हेब्रोन रागी ङा माम्रे माइश्‍शो ब्‍वाकीम कीङा बाक्‍त। मिनु मेकेर परमप्रभु यावे कली चढ़ेतीक का सेला बाक्‍त। उत्‍पत्ती १४:१३-२४ ");
INSERT INTO suzBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","मिनु शिनार ङा पिप अम्राफेल, एल्‍लासार ङा पिप अरयोक, एलाम ङा पिप केदोर-लाओमेर नु गोयीम रागी ङा पिप तिदालम सासन पामे ना, यहोसु १२:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","सोदोम ङा पिप बेरा, गोमोररा ङा पिप बिरशा, अदमाह ङा पिप शिनाब नु सेबोयीम ङा पिप शेमेबेर, बेला सहर ङा पिप नु लडाइ पामे बाक्‍त। बेला सहर कली सोआर यो देंनीम। उत्‍पत्ती १९:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","मेको नेल्‍ल सिददीम दिंममी लडाइ पथ खुम्‍सीशो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","मारदे हना मेकोपुकीमी लडाइ का ब्रुशा नोले, १२ बर्स सम्‍म श्‍येत जशा, पिप केदोर-लाओमेर कली मार मार गेचा माल्‍मा बाक्‍त। मोपतीके मेकोपुकीम १३ बर्समी “मगेय, लडाइ पय” दे सल्‍ला पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","मिनु १४ बर्समी पिप केदोर-लाओमेर नु मेको आ वारच पिपपुकी अश्‍‍तारोथ-कारनाइमम बाक्‍ब रेफाइमपुकी, हामम बाक्‍ब जूजीमपुकी, शावेह-किरयथ-थाइम बाक्‍ब एमीमपुकी, उत्‍पत्ती ३६:२०-३० ");
INSERT INTO suzBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","सेइर पहाडम बाक्‍ब होरी आ मुर नेल्‍ल आन कली एल-पारान मुर बाक्‍तीक आ नेक्‍था सम्‍म फ्रूमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","मेको ग्राब पिप आन लां लेश्‍शा, एन-मिश्‍पात जाक्‍शा, हासासोन-तामारम बाक्‍ब अमालेकी नु एमोरी आन कली फ्रूमे बाक्‍त। एन-मिश्‍पात कली कादेश यो देंनीम। ");
INSERT INTO suzBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","मेना सोदोम ङा पिप, गोमोररा ङा पिप, अदमाह ङा पिप, सेबोयीम ङा पिप नु बेला ङा पिप सल्‍ला पशा, बेला सहर कली सोआर यो देंनीम ");
INSERT INTO suzBl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","सिददीम दिंममी एलाम ङा पिप केदोर-लाओमेर गोयीम रागी ङा पिप तिदाल, शिनार ङा पिप अम्राफेल नु एल्‍लासार ङा पिप अरयोक नु लडाइ पथ जाक्‍मा बाक्‍त। ४ जना पिपपुकीम ५ जना पिप नु लडाइ पशो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","मिनु सिददीम ङा दिंममी अल्‍कत्रा खाल्‍टा शुश बाक्‍मा बाक्‍त। मिनु सोदोम नु गोमोररा ङा पिप प्रोक्‍शा, खाल्‍टा आगा दोक्‍सा बाक्‍त। लीशो मुरपुकी चहिं पहाड गे प्रोक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","मिनु केदोर-लाओमेर नु आ हुलमी सोदोम नु गोमोररा सहर ङा मुर नु आन मार मार नेल्‍ल रोइश्‍शा लदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","मिनु मेकोपुकीमी सोदोम सहरम बाक्‍शो अब्राम आ लोक्‍ब आ तौ लोत नु आ मारेइ मारेइ नेल्‍ल यो लाइश्‍शा लमा बाक्‍त। उत्‍पत्ती १३:१०-१२ ");
INSERT INTO suzBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","मिनु पहाडम प्रोक्‍शो मुर कामी हिब्रू अब्राम कली मेको लोव़ शेंदा बाक्‍त। अब्राम चहिं एमोरी माम्रे आ ब्‍वाकीम बाक्‍शो बाक्‍माक्‍त। माम्रे एश्‍कोल नु आनेर वोबु बाक्‍सा बाक्‍त। मेको अब्राम कली वारच पाइब बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","मिनु अब्राममी आ लोक्‍ब आ तौ ग्‍याइश्‍शो नेंशा, आ खिंमी जरमेशो सहे सां १८ जना लडाइ पचा कली शेंसीशो मुर कली या गेशा, ठीक पवा बाक्‍त। मिनु मेकोपुकीमी रोइक्‍ब आन कली दान सहर सम्म खेदा पामे बाक्‍त। यहोसु १९:४७; न्‍यायाधीस १८:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","नाक्‍दोमी अब्राममी आ मुर आन कली हुल निक्‍शी पशा, रोइक्‍बपुकी नु लडाइ पशा ग्राशा, होबाह सम्‍म खेदा पामे बाक्‍त। होबाह दमस्‍कस सहर आ उत्तर गे बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","मोदेंशो पा अब्राममी सोदोम नु गोमोररा रे रोइश्‍शा मारेइ मारेइ नु आ लोक्‍ब आ तौ लोत आ मारेइ मारेइ नेल्‍ल, मीश मुर नेल्‍ल नु मेको निक्‍शी सहर ङा मुर नेल्‍ल लेप्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","मोपा अब्राम केदोर-लाओमेर नु आ वारच पिपपुकी नु लडाइ पशा ग्राशा, लेश्‍शा नोले सोदोम ङा पिप शावेह माइश्‍शो दिंमम जाक्‍शा, अब्राम कली ग्रुम्‍थ जाक्‍माक्‍त। शावेह माइश्‍शो दिंम कली पिप आन दिंम यो देंनीम। हिब्रू ७:१-४ ");
INSERT INTO suzBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","मिनु सालेम ङा पिप मेल्‍कीसेदेकम अब्राम नु आ मुर आन कली शोब्‍ले नु अङगुर शांबु चाक्‍गा बाक्‍त। मेको नेल्‍ल क्‍येङा ठेयब परमप्रभु कली चढ़ेब बाक्‍माक्‍त। भजन संग्रह ११०:४; भजन संग्रह ७६:३ ");
INSERT INTO suzBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","मिनु मेकोमी अब्राम कली आसीक गेशा “सरीङ नु रागी सेल्‍ब नेल्‍ल क्‍येङा ठेयब परमप्रभु आ आसीक इ कली रल। ");
INSERT INTO suzBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","मिनु नेल्‍ल क्‍येङा ठेयब परमप्रभु मान ताइब बाक्‍ब। मारदे हना इ जोरी सत्रु इ गुइमी गेशा, इ कली ग्रापाइक्‍तु” दे ठेयब सेला बाक्‍त। मिनु अब्राममी नेल्‍ल थोव़क १० भाग ङा भाग का मेल्‍कीसेदेक कली गेवा बाक्‍त। उत्‍पत्ती २८:२२; लेवी २७:३०-३२ ");
INSERT INTO suzBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","मिनु सोदोम ङा पिपमी अब्राम कली “मुर ला गेयी। अरु मार मार इन कली दुम्‍ल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","मिनु अब्राममी सोदोम ङा पिप कली “गो आं गुइ परमप्रभु यावे, नेल्‍ल क्‍येङा ठेयब सरीङ नु रागी सेल्‍ब परमप्रभु गे पोक्‍शा कसम जाता। ");
INSERT INTO suzBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","गो इन के मारेइ मलाइक्‍नुङ। श्‍येले का, जुत्ता आ डोरी का यो मलाइक्‍नुङ। मिनु गेमी ‘गो अब्राम कली शुश शोंप पाइश्‍शो सेल्‍ता’ दे गेनायो देंने मचाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","आं गेय पाइब आन जशो चहिं लाइक्‍नुङ। गो नु गाक्‍ब आनेर, एश्‍कोल नु माम्रे आन भाग चहिं लाइक्‍चा गेन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","मिनु नोले परमप्रभु यावेमी अब्राम कली ङोमु खोदेंशो पा कोंइतीक कोंइदा बाक्‍त। मिनु मेकोमी अब्राम आ नें थिशा “अब्राम महिनो। गो इ कली कोव़नन। शुश आसीक गेनन” देंमाक्‍त। गन्‍ती २४:४,१६; भजन संग्रह ३:४ ");
INSERT INTO suzBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","तन्‍न अब्राममी “आं कली मार गेनीनी ङा? आं के आल मबाक्‍नीम। आ अङस ताइब दमस्‍कस ङा एलीएजर दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","गे आं कली तमी तौ मगेयीनी। मुल आं खिंम जरमेशो वाइलम आं अङस ताइब दुम्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","मिनु परमप्रभु यावेमी लेंशा “मेको मुरुम इ अङस मताइब। इ आंम रां ङा इ तौमी इ अङस ताइब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","मिनु मेकोमी अब्राम कली ताम्‍बु रे ग्रुंइशा “सरीङ गे कोव़ङो, सोरुल आन कली हिक्‍को। मेको हिक्‍ने चाप्‍नेवे? गिश बाक्‍मा, इ चच युइ यो मिश दुम्‍नीम” देंमाक्‍त। उत्‍पत्ती २२:१७; प्रस्‍थान ३२:१३; ब्‍यवस्‍था १:१०; हिब्रू ११:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","मिनु अब्राममी परमप्रभु यावे आ लोव़ थमा सुदा बाक्‍त। मिनु परमप्रभु यावेमी अब्राममी थमा सुइश्‍शो तशा “ठीक पाइब मुर का बाक्‍त” दे तुइक्‍ता बाक्‍त। रोमी ४:३-५; याकूब २:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","मिनु लेंशा अब्राम कली “गो परमप्रभु यावे नङ। गो एको रागी इ कली गेचा कली कल्‍दी ङा ऊर सहर रे ग्रुंइताक्‍न” देंमाक्‍त। उत्‍पत्ती ११:३१; प्रस्‍थान ३:१४; यसैया ४५:५; यूहन्‍ना ८:२४-२९ ");
INSERT INTO suzBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","मिनु अब्राममी “परमप्रभु, परमप्रभु यावे, आं के रागी दुम्ब, दे दोपा तुइक्‍नुङा ङा?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","मिनु मेकोमी “आं कली बर्स सां ङा बी का, बर्स सां ङा क्‍यारश का, बर्स सां ङा सांड का, ढुकुर का परवा आ चाइक्‍ब का चाक्‍ती” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","मिनु अब्राममी मेको नेल्‍ल चाक्‍शा क्‍योरशा, फेके पा रिक्‍शा, फेके का एर गे, फेके का ओंथ गे पा वोदा बाक्‍त। ढुकुर नु परवा चहिं फेके मसेला बाक्‍त, येरमीया ३४:१८-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","मिनु ठेयब चिक्‍बपुकी मेको श्‍ये तशा, जुक्‍तमे बाक्‍त। तन्‍न अब्राममी “हाइ हाइ” दे ग्रीशा खेरमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","मिनु नां रिक्चावानु, अब्राम मारेइ मतुइक्‍चा ङा पा निन्‍द्रा पवा बाक्‍त। मिनु शुश हिंचा माल्‍शो आ एर ओंथ नेल्‍ल छिङछिङ दुम्‍माक्‍त। उत्‍पत्ती २:२१; १सामुएल २६:१२; यसैया २९:१० ");
INSERT INTO suzBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","मिनु मेकोमी अब्राम कली “इ तौ चच युइ अर्को रागीमी अर्को रागी ङा मुर दुम्‍नीम। मेकेर बाक्‍मानु, वाइलीम वाइल यो दुम्‍नीम। मेकेर ४ सहे बर्स सम्‍म श्‍येत जाइनीम। प्रस्‍थान १:१३; प्रस्‍थान १२:४०; प्रेरित ७:६ ");
INSERT INTO suzBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","गो चहिं मेको आन बाक्‍शो रागी ङा मुर आन कली निसाफ पा सजाइ गेनुङ। मारदे हना इ मुर आन कली वाइलीम वाइल सेल्‍नीम। मिनु नोले इ मुरपुकीम मेको आन मारेइ मारेइ लाइश्‍शा, मेको रागी रे ग्रूशा लाइनीम। प्रस्‍थान ३:२१-२२; प्रेरित ७:७ ");
INSERT INTO suzBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","गे चहिं थुं नाइश्‍शा इ किकी पिपी आन बाक्‍तीक लाइनेवे। शुश बर्स दुम्‍शा बेक्‍नेवे। उत्‍पत्ती २५:७-८ ");
INSERT INTO suzBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","इ मुरपुकी ४ पाला नोले ला एकेर लेश्‍शा जाक्‍नीम। मारदे हना एमोरी आन मरिम्‍शो पशो मनुप्‍शो बाक्‍त” दे परमप्रभु यावेमी देंमाक्‍त। प्रेरित ७:७ ");
INSERT INTO suzBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","मिनु नां रिक्‍शा, छिङछिङ दुम्‍शा नोले मी ब्रशो चुप्‍लु का ग्रूमाक्‍त। मिनु ब्रशो तोव़शी का मेको श्‍ये आ एर ओंथ गाक्‍माक्‍त। प्रस्‍थान १९:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","मेको नाक्‍ती परमप्रभु यावेमी अब्राम नु कबल पशा “मेको रागी इ चच युइ आन कली गेनुङ। मेको इजीप्‍त ङा ठेयब खोला रे युफ्रेटीस सम्‍म बाक्‍ब। उत्‍पत्ती १२:७; १राजा ८:६५; १राजा ५:१ ");
INSERT INTO suzBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","मेकेर बाक्‍बपुकी केनी, केनीज्‍जी, कादमोनी, ");
INSERT INTO suzBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परि‍ज्‍जी, फाइम, ");
INSERT INTO suzBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरी, कनानी, गिरगाशी नु यबुसी आन रागी नेल्‍ल इ कली गेनुङ” दे अब्राम कली लोव़ गेशा, कबल पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम आ मीश साराइ आल मथीब बाक्‍माक्‍त। मिनु साराइ नु इजीप्‍त ङा वाइलीम का बाक्‍माक्‍त। मेको आ नें हागार बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","मिनु साराइमी अब्राम कली “नेनीन, परमप्रभु यावेमी आं कली आल मगेयी। मोपतीके आं वाइलीम नु बाक्‍कीन। मोपा गो आल ताइनुङा, कों?” देंमाक्‍त। मिनु अब्राममी आ मीशेमी मार देंमे, मेको पवा बाक्‍त। उत्‍पत्ती ३०:३,९ ");
INSERT INTO suzBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","मिनु अब्राम कनान रागीम १० बर्स बाक्‍म नोले, आ मीश साराइमी आ इजीप्‍त ङा वाइलीम हागार लाइश्‍शा, आ वोंइश कली गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","मिनु अब्राम हागार नु इम्‍‍माक्‍त। मिनु हागार कोव़ज कुरशो दुम्‍माक्‍त। मेको तुइश्‍शा, ठेयब लेश्‍शो दुम्‍शा, आ होव़पोक्म कली मटिवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","मिनु साराइमी अब्राम कली “आं कली मरिम्‍शो दुम्‍तीके इन कली दुम्‍ल। गो आं वाइलीम इन कली गेता। मुल आंम कली कोव़ज कुरशो तशा, आं कली आइक्‍च सेल्‍ती। परमप्रभु यावेमी गे नु गो, इस दातेम निसाफ पवल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","मिनु अब्राममी “नेनो, इ वाइलीम इ गुइमी बाक्‍ब। मेको कली इ दाक्‍शो पावो” दे साराइ कली देंमाक्‍त। मिनु साराइमी हागार कली हुइक्‍तानु, मेको प्रोक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी हागार कली गोरशो रागी शुर लतीक लां ङा ब्‍वाक्‍कु बुक्‍तीके आ नेक्‍था थिदा बाक्‍त। प्रस्‍थान १४:१९; प्रस्‍थान २३:२०; गन्‍ती २२:२२; १राजा १९:७; १राजा १९:७; २राजा १९:३५ ");
INSERT INTO suzBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","मिनु मेकोमी “हागार, साराइ आ वाइलीम, ते लशा पिनी?” दे हिल्‍लो पवा बाक्‍त। मिनु हागारमी “आं होव़पोक्म साराइ आ ङोंइती रे प्रोक्‍ती” दे लोव़ लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी मेको कली “इ होव़पोक्‍म आ खिं ले‍तो। मिनु मेको आ अरेशो टिशा बाक्‍को” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी लेंशा “इ चच युइ आन कली शुश दुम्‍पाइक्‍नुङ। इ मुरपुकी सुइमी हिक्‍ने मचाप्‍चा ङा पा शुश दुम्‍नीम” देंमाक्‍त। उत्‍पत्ती १७:२० ");
INSERT INTO suzBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी लेंशा “नेनो, गे कोव़ज कुरशो बाक्‍नेवे। तौ का थीनेवे। मेको कली इश्‍माएल नें वोइक्‍चा माल्‍नेवे। मारदे हना परमप्रभु यावेमी इ श्‍येत ताप्‍तु। प्रस्‍थान २:२३; अय्‍युब ३४:२८; भजन संग्रह ९:१३; यसैया ४१:१७; याकूब ५:४ ");
INSERT INTO suzBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","इ तौ जीब दुम्‍ब। मुर नेल्‍ल नु जीब। मुरपुकी यो मेको नु जीनीम। मेको आ लोक्‍बपुकी नु यो जीब दुम्‍ब” देंमाक्‍त। उत्‍पत्ती २५:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","मिनु हागारमी आ नु लोव़ पाइब परमप्रभु यावे कली “गे आं कली ताइब परमप्रभु ननी। गो थमा पा आं कली ताइब कली ताता” देंमाक्‍त। उत्‍पत्ती २२:१४; प्रस्‍थान ३:७; २राजा १३:४ ");
INSERT INTO suzBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","मोपतीके मेको ब्‍वाक्‍कु बुक्‍तीक आ नें बेयर-लहाइ-रोइ वोदमे बाक्‍त। मेको कादेश नु बेरेद आस दातेम बाक्‍ब। उत्‍पत्ती २४:६२; उत्‍पत्ती २५:११ ");
INSERT INTO suzBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","मिनु हागारम अब्राम के तौ का थि‍माक्‍त। अब्रामम मेको कली इश्‍माएल नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारम इश्‍माएल थिमेनु, अब्राम ८६ बर्स दुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","मिनु अब्राम ९९ बर्स दुम्‍मेनु, परमप्रभु यावे अब्राम आ ङोंइती ग्रूशा, मेको कली “गो नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभु नङ। गे, गो नु बाक्‍शा, ठीक पाइब दुमो। उत्‍पत्ती ३५:११; प्रस्‍थान ६:३; ब्‍यवस्‍था १०:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मिनु गो गे नु आं कबल पाइनुङ। गो इ मुर हिक्‍ने मचाप्‍चा ङा पा शुश सेल्‍नुङमी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","मिनु अब्राम खुम्‍की पा बाम्‍माक्‍त। परमप्रभुमी मेको कली ");
INSERT INTO suzBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“नेनो, मेको गो, गे नु आं कबल पतीके बाक्‍ब। गे शुश रागी ङा मुर आन किकी पिपी दुम्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","मुल रे इ नें अब्राम देंचा मदुम्‍ब। इ नें अब्राहाम दुम्‍चा माल्‍ब। मारदे हना गो इ कली शुश रागी ङा मुर आन किकी पिपी सेल्‍तन। रोमी ४:११,१७ ");
INSERT INTO suzBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","गो इ रे शुश मुर सेल्‍नुङमी, रागी रागी ङा मुर सेल्‍नुङ। इ रे पिपपुकी यो दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","मिनु गो गे नु लोव़ पा आं कबल पाइनुङ। गो इ चच युइ नु यो आं कबल पाइनुङ। मेको गेना हना यो लीब कबल बाक्‍ब। गो इ परमप्रभु नु इ चच युइ आन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","मुल गे इ बाक्‍तीक रागीमी अर्को रागी ङा मुर बाक्‍नेवे। नोले गो एको कनान रागी गेना हना यो इन कली नु इ चच युइ आन कली गेनन्‍नी। गो चहिं मेको आन परमप्रभु दुम्‍नुङ” दे अब्राहाम कली देंमाक्‍त। उत्‍पत्ती ३५:२७; हिब्रू ११:९-१०; प्रेरित ७:५ ");
INSERT INTO suzBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","मिनु परमप्रभुमी अब्राहाम कली “आं कबल पशो ङा लोव़ नेल्‍ल टिवो। मिनु इ नोले इ चच युइपुकीमी नेल्‍ल पालामी यो आं कली मिम्‍शा, टिचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","गे नु इ नोले ङा तौ चच युइ आन पचा माल्‍शो कबल मार बाक्‍त देंशा हना, इ चारतीक ङा कुशुल कुल पा ख्रोइक्‍चा माल्‍नेवे। गे नु इ चच युइ, वोंइश मुर नेल्‍ल कली कुशुल ख्रोइक्‍तीक चिनु ख्रोइक्‍चा माल्‍नीम। लेवी १२:३; यूहन्‍ना ७:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","मेको गे नु गो इस कबल पशो आ चिनु बाक्‍ब। इजीकीएल २०:१२; ब्‍यवस्‍था ३०:६; रोमी ४:११ ");
INSERT INTO suzBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","मुल रे इ पाला ङा मुरुम आन तौ कली ८ नाक्‍ती दुम्‍मानु, ख्रोइक्‍तीक चिनु ख्रोइक्‍चा माल्‍नीम। इ खिंम जरमेशो वोंइश आल, तेको तेको रागी रे ग्‍याप्‍शो इ वाइल नु आन तौ नेल्‍ल आन कली यो ख्रोइक्‍तीक चिनु ख्रोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","इ खिंम जरमेशो, इ चांदीम ग्‍याप्‍शो मुरपुकी कली यो ख्रोइक्‍तीक चिनु ख्रोइक्‍चा माल्‍नीम। मिनु आं कबल पशो ङा चिनु इ रांम बाक्‍चा माल्‍ब। मेको गेना हना यो लीब कबल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ख्रोइक्‍तीक चिनु मख्रोइश्‍शो वोंइश मुर नु वोंइश आल आन मुर आन दाते रे तिल्‍चा पुंइसीनीम। मारदे हना मेकोपुकीमी आं कबल पशो प्रोंइशो बाक्‍नीम” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","मिनु परमप्रभुमी अब्राहाम कली “गे इ मीश कली ‘साराइ’ मदेंचा, मुल रे मेको कली ‘सारा’ नें वोइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","गो मेको कली आसीक गेनुङ। गो इ कली मेको रे तौ का गेनुङ। मिनु सारा रागी रागी ङा मुर नु जात जात ङा मुर आन पिप आन ममा दुम्‍ब” दे परमप्रभुमी देंमाक्‍त। उत्‍पत्ती १२:२-३ ");
INSERT INTO suzBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","मिनु अब्राहाममी खुम्‍की पा बाप्‍शा, रिश्‍शा “सहे का बर्स ङा मुरुम आल थीबा? सारा ९० बर्स दुम्‍शा, आल थिने चाप्‍‍बा?” दे आंम कली देंमाक्‍त। उत्‍पत्ती १८:१२; उत्‍पत्ती २१:६; लूका १:१८; रोमी ४:१९-२१ ");
INSERT INTO suzBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","मिनु अब्राहाममी परमप्रभु कली “इश्‍माएल इन ङोंइती बाक्‍ल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","मिनु परमप्रभुमी “ममाइ, इ मीश सारामी थमा पा तौ का थीब। मेको आ नें इसहाक वोइक्‍चा माल्‍नेवे। मेको नु आं कबल पतीक गेना हना यो दुम्‍ब। मेको आ नोले ङा आ तौ चच युइ नु यो लीब। ");
INSERT INTO suzBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्‍माएल आ पर्बम मार देंने, गो मेको नेल्‍ल नेंता। नेनो, गो मेको कली आसीक गेनुङ। मेको सोशा बोशा, शुश दुम्‍ब। गो मेको कली १२ जना पिप आन आफ सेल्‍नुङ। गो मेको कली ठेयब जात दुम्‍पाइक्‍नुङ। उत्‍पत्ती १६:१०; उत्‍पत्ती २१:१३,१८; उत्‍पत्ती २५:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","तन्‍न आं कबल इसहाक नु पाइनुङ। सारामी बर्स का नोले इसहाक थीब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","मिनु परमप्रभु अब्राहाम नु लोव़ पने थुम्‍शा लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","मिनु परमप्रभुमी लोव़ पवा नाक्‍ती अब्राहाममी आ तौ इश्‍माएल, आ खिंमी जरमेशो नु ग्‍याप्‍शो वाइल नु आ खिं ङा वोंइश मुर नेल्‍ल आन कली ख्रोइक्‍तीक चिनु ख्रोइक्‍पाइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहाममी ख्रोइक्‍तीक चिनु ख्रोदा नाक्‍ती ९९ बर्स दुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","आ तौ इश्‍माएल ख्रोइक्‍तीक चिनु ख्रोइक्‍तीक नाक्‍ती १३ बर्स दुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","मिनु अब्राहाम नु इश्‍माएल नाक्‍त कामी ख्रोइक्‍तीक चिनु ताम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","आ खिं ङा वोंइश मुर नेल्‍ल, आ खिंम जरमेशो नु रागी रे ग्‍याप्‍शो वाइल नेल्‍लेम यो मेको नाक्‍ती ख्रोइक्‍तीक चिनु तामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","मिनु काबु नाक्‍ती अब्राहाम माम्रे आ ब्‍वाकीमी बाक्‍माक्‍त। आ ताम्‍बु आ लाप्‍चोमी निस्‍से बाक्‍त। मारदे हना शुश हुप्‍ता बाक्‍त। मेना परमप्रभु यावे मेको कली ग्रुम्‍थ जाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","मिनु मुर सां ग्रूशा, आ ङोंइती राप्‍शो तवा बाक्‍त। मेको आन कली तशा, छुल बोक्‍शा बाप्‍शा, सेउ पवा बाक्‍त। हिब्रू १३:२ ");
INSERT INTO suzBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","मिनु अब्राहाममी “आं परमप्रभु, आं कली दाक्‍ताक्‍नी हना, इन गेय पाइब रे मो मलने। ");
INSERT INTO suzBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","इन खोइल चिक्‍चा कली ब्‍वाक्‍कु गेनन्‍नी। मिनु चिक्‍शा, रवा आगाम नांइ‍सीन। ");
INSERT INTO suzBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","गो इन कली इच्‍का शोब्‍ले ब्रथ लाइनुङ। लाम्‍ज जचा माल्‍नीनी। मारदे हना गेपुकी इन गेय पाइब कली ग्रुम्‍थ जाक्‍शो बाक्‍नीनी” देंमाक्‍त। मिनु मेकोपुकीमी “इ देंशो खोदेंशो पावो” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","मिनु अब्राहाम दोरशा, ताम्‍बुम लशा, सारा कली “गे रीब पा सेआह सां रिम्‍शो फस के शोब्‍ले चोवो” देंमाक्‍त। सेआह का ७ लिटर पुक्‍तीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","अब्राहाम चहिं गोठमी दोरशा लशा, दोम्‍शो रिम्‍शो बाछा का चाक्‍शा क्‍योरपाइश्‍शा, गेय पाइब कली क्‍येपदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","मिनु दहि, दूध नु श्‍ये चाक्‍शा, मेको आन कली ख्रेत्‍तीमी बाक्‍त। मिनु मेकोपुकीमी जामेनु, अब्राहाम मेको आन नेक्‍था रवा आ पुंम राप्‍शा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","मिनु मेकोपुकीमी “इ मीश सारा ते बाक्‍मे?” दे हिल्‍लो पामे बाक्‍त। मिनु अब्राहाममी “ताम्‍बुम बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","मिनु कामी “गो एकेर लेंशा माइक्‍थ जाक्‍नुङ। मेना इ मीशेमी तौ का थिशो बाक्‍ब” देंमाक्‍त। मिनु सारा ताम्‍बु आ लाप्‍चोम मेको लोव़ पाइब आ नोले ख्रुइश्‍शा बाक्‍शा, मेको लोव़ नेना बाक्‍त। उत्‍पत्ती १७:१९; रोमी ९:९ ");
INSERT INTO suzBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम नु सारा खाल्‍पा खाल्‍पी दुम्‍शो बाक्‍सा बाक्‍त। सारा आ रां ब्रोल्‍चा यो नुप्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","मोपतीके सारामी मेको लोव़ नेंशा “गो खाल्‍पी दुम्‍ती। आं वोंइश यो खाल्‍पा दुम्‍त। मिनु आल थीनुङा ङा?” दे रिस्‍से बाक्‍त। उत्‍पत्ती १७:१७; १पत्रुस ३:६ ");
INSERT INTO suzBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","मिनु परमप्रभु यावेमी अब्राहाम कली “सारा मारदे ‘गो खाल्‍पी दुम्‍शा, आल थीनुङा ङा?’ दे रिस्‍से? ");
INSERT INTO suzBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","गो परमप्रभु यावे नङ। गो नेल्‍ल पने चाप्‍नुङ। गो माइक्‍थ लेश्‍शा जाक्‍ङानु, सारामी तौ थिशो बाक्‍ब” देंमाक्‍त। मत्ती १९:२६; लूका १:३७ ");
INSERT INTO suzBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","सारामी चहिं “गो मरिस्‍सीङ” दे जोल पवा बाक्‍त। मारदे हना हिंमाक्‍त। तन्‍न मेकोमी “गे थमा पा रिस्‍साक्‍वे” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","मिनु मेको मुर सां बोक्‍शा, सोदोम सहर गे लमा बाक्‍त। अब्राहाममी मेको आन कली आइक्‍ची सम्‍म चोव़थ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","मिनु परमप्रभु यावेमी “गो मार पचा चिक्‍तु, मेको मख्रुइक्‍थु अब्राहाम कली शेंनुङ। आमोस ३:७ ");
INSERT INTO suzBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहाम ठेयब नु बोल्‍यो रागी ङा मुर आन आफ दुम्‍ब। मिनु रागी नेल्‍ल ङा मुरपुकीमी मेको आ पर्बम आसीक ताइनीम। उत्‍पत्ती १२:३ ");
INSERT INTO suzBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","गो अब्राहाम कली तुइक्‍नुङ, आ आल नु आ चच युइ आन कली परमप्रभु यावे आ लां गाक्‍पाइक्‍चा कली अरेब। मिनु मेकोपुकी परमप्रभु यावे आ लां खोइक्‍ब दुम्‍शा, ठीक नु रिम्‍शो पचा शेंसीशा पाइ‍नीम। परमप्रभु यावेमी अब्राहाम कली मार लोव़ देंमे, मेको नेल्‍ल दुम्‍ल” देंमाक्‍त। ब्‍यवस्‍था ६:७; ब्‍यवस्‍था ३२:४६ ");
INSERT INTO suzBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","मिनु परमप्रभु यावेमी “गो सोदोम नु गोमोररा सहर निक्‍शी आस पर्बम शुश मरिम्‍शो लोव़ नेंता। मारदे हना मेकेर ङा मुर आन मरिम्‍शो पशो शुश हिंचा ङा बाक्‍त। उत्‍पत्ती १९:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मुल गो कोव़थ यीनुङ। एको नेंशो लोव़ थमा बाक्‍म कों, जोल बाक्‍म, गो तुइक्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब निक्‍शी सोदोम गे लसा बाक्‍त। अब्राहाम परमप्रभु यावे आ ङोंइती राप्‍शा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","मिनु अब्राहाम मेको आ नेक्‍था लशा “गे ठीक पाइब आन कली नु मरिम्‍शो पाइब आन कली खाल का ङा पा क्‍याम्‍नीनी? गन्‍ती १६:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","मेको सहरमी ५० जना ठीक पाइब मुर बाक्‍तेक्‍म हना, सहर कली क्‍याम्‍नीनी? मेको ५० जना ठीक पाइब मुर आन पर्बम मेको सहर मप्रोंइनीनी? ");
INSERT INTO suzBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ममाइ, गे मोदेंशो पा मक्‍याम्‍नीनी। गे ठीक पाइब नु मरिम्‍शो पाइब आन कली खाल का ङा पा मसाइक्‍नीनी। थमान, ठीक पाइब नु मरिम्‍शो मुर आन कली खाल का ङा मपाइनीनी। गे रागी रागी ङा निसाफ पाइब बाक्‍शा, ठीक निसाफ पाइनीनी” देंमाक्‍त। भजन संग्रह ८२:१; भजन संग्रह ९४:२ ");
INSERT INTO suzBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","मिनु परमप्रभु यावेमी “सोदोम सहरम ५० जना ठीक पाइब मुर बाक्‍तेक्‍म हना, गो मेको आन पर्बम सहर मक्‍याम्‍नुङ” देंमाक्‍त। यसैया ६५:८; मत्ती २४:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","मिनु अब्राहाममी “गो फुरक नु पुलु रे दुम्‍शो मुरुमी परमप्रभु नु लोव़ पाता। ");
INSERT INTO suzBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","मेको सहरम ४५ जना मुर ला ठीक पाइब बाक्‍तेक्‍म हना, गे मेको ४५ जना मुर, ५ जना मजाक्‍दीतीके सहर क्‍याम्‍नीनी?” दे हिल्‍लो पवा बाक्‍त। मिनु मेकोमी “गो मेकेर ४५ जना ठीक पाइब मुर थित्‍तामी हना, गो सहर मक्‍याम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","मिनु अब्राहाममी लेंशा “४० जना ठीक पाइब बाक्‍तेक्‍म हना?” देंमेनु, मेकोमी “गो मेको ४० जना आन पर्बम यो सहर मक्‍याम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","मिनु अब्राहाममी “परमप्रभु, मगाइक्‍तीने, गो चिनु लोव़ पाइनुङ। ३० जना ठीक पाइब मुर बाक्‍तेक्‍म हना?” देंमाक्‍त। मिनु परमप्रभुमी “३० जना बाक्‍तेक्‍म हना, मेको आन पर्बम यो मक्‍याम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","मिनु अब्राहाममी लेंशा “गो परमप्रभु इन कली लेंशा लोव़ पाइनुङ, सहरमी २० जना ला ठीक पाइब मुर बाक्‍तेक्‍म हना?” देंमाक्‍त। मिनु मेकोमी “२० जना ठीक पाइब मुर बाक्‍तेक्‍म हना यो, मेको आन पर्बमी सहर मक्‍याम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","मिनु अब्राहाममी “परमप्रभु, मगाइक्‍तीने। गो चिनु लोव़ हिल्‍लो पाइनुङ। १० जना ला ठीक पाइब मुर बाक्‍तेक्‍म हना?” देंमाक्‍त। मिनु मेकोमी “गो मेको १० जना ठीक पाइब आन पर्बम यो सहर मक्‍याम्‍नुङ” देंमाक्‍त। न्‍यायाधीस ६:३९ ");
INSERT INTO suzBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","मिनु अब्राहाम नु लोव़ पने थुम्‍शा, परमप्रभु यावे आ लां लमाक्‍त। अब्राहाम आ बाक्‍तीके लेम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","मेको परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब निक्‍शी सोदोम सहरम नाक्‍नाक्‍दो जाक्‍दीस्‍सा बाक्‍त। मेना लोत सहर आ गारो ङा ठेयब लाप्‍चो आ नेक्‍था निश्‍शा बाक्‍मेनु, ग्रुम्‍से बाक्‍त। मिनु लोतमी मेको आस कली तशा बोक्‍शा, खुम्‍की पा बाम्‍माक्‍त। उत्‍पत्ती १८:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","मिनु लोतमी “आं प्रभु निक्‍शी, नेनीसे, मुलाक्‍दो आं खिंम बाक्‍कीसे। इस खोइल चिक्‍सीसे। सुनी बोक्‍शा, इस लां लने चाप्‍नीसी” देंमाक्‍त। मेको निक्‍शीमी “ममाइ, गो मेरे लाङगाम इप्‍नस्‍कु” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","मिनु लोतमी शुश लोव़ पवा नोले आ खिंमी बास बाक्‍सा बाक्‍त। लोतमी मेको आस कली ब्रोव़ब्रोव़शो क्‍येशा, बोरब ओख्‍ती मसुप्‍शो शोब्‍ले सेला बाक्‍त। मिनु जाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","मिनु इप्‍चा क्‍येङा ङोंइती सोदोम सहर ङा वोंइश मुरपुकी खिं आ एर ओंथ खुम्‍सीशा बाक्‍मा बाक्‍त। खाल्‍पा, ठिटा सहर ङा वोंइश मुर नेल्‍ल खुम्‍सीशा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","मेकोपुकीमी लोत कली “नाक्‍नाक्‍दो इ खिंम जाक्‍शो वोंइश मुर ते बाक्‍सा। आंइ दाक्‍शो पचा कली लाङगाम सोइक्‍तो” देंमा बाक्‍त। लेवी १८:२२-२५; न्‍यायाधीस १९:२२-२४; रोमी १:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","मिनु लोत लाप्‍चो रे लाङगा ग्रूशा, आ नोले लाप्‍चो चोक्‍शा वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","मिनु मेकोमी “आं लोक्‍बपुकी, मोपा मरिम्‍शो मपने। ");
INSERT INTO suzBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","नेनीन, आं के कन्‍ने तमी निक्‍शी बाक्‍नीसी। मेको इन कली लाङगा सोइक्‍नुङ। मार मार पचा दाक्‍नीनी, मेको निक्‍शी नु पने। आं खिंमी जाक्‍शो वोंइश मुर आस कली मारेइ मपने। मारदे हना बास बाक्‍चा कली आं खिंम जाक्‍ताक्‍से” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","मेकोपुकीमी चहिं “गे लावो। गे ला एको सहरमी अर्को रागी ङा मुर बाक्‍नेवे, आंइ कली हुकुम पचा माल्‍नेवे? लो, मेको निक्‍शी आस क्‍येङा इ कली श्‍येत गेनीकी” देंमा बाक्‍त। लोत कली शुश लोव़ पशा, लाप्‍चो रोक्‍चा माल्‍मे बाक्‍त। २ पत्रुस २:७-८ ");
INSERT INTO suzBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तन्‍न आगा ङा वोंइश मुर निक्‍शीमी आस गुइ लाङगा ग्रुंइशा, लोत कली ग्‍याइश्‍शा आगा कीशा, लाप्‍चो चोक्‍‍गसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","मिनु मेको निक्‍शीमी लाङगाम बाक्‍शो मुर आन कली मिक्‍च मताइब सेल्‍से बाक्‍त। मिनु मेकोपुकीमी लाप्‍चो मथित्‍थु, माल्‍चा प्रोन्‍मे बाक्‍त। २राजा ६:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","मिनु मेको निक्‍शीमी लोत कली “गे इ के सु सु बाक्‍नीमी? चांइवा, तमी तौ नु सहरम इ मुर सु सु बाक्‍नीमी? एको सहर रे ग्रुंइदो। ");
INSERT INTO suzBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","मारदे हना गो एको सहर कली क्‍याम्‍नस्‍कु। परमप्रभु यावे आ ङोंइती एको आन ग्रांग्रा दिचा ङा गेय आ पर्बम शुश रेयके बाक्‍ब। परमप्रभु यावेमी आंस कली एको सहर क्‍याम्‍चा, दे सोइश्‍शो बाक्‍ब” देंसा बाक्‍त। उत्‍पत्ती १८:२० ");
INSERT INTO suzBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","मिनु लोतमी आ तमी आस कली ग्‍युंबे पचशो वोंइश आल आस कली ग्रुम्‍शा “बोक्‍कीस, सहर रे लसे। मारदे हना परमप्रभु यावेमी सहर क्‍याम्‍ब” दे माइक्‍सी बाक्‍त। मेको निक्‍शीमी चहिं “रित्‍चा ङा लोव़ बाक्‍त” दे मिम्‍तसे बाक्‍त। गन्‍ती १६:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","मिनु भाले ग्रीमेनु, परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब निक्‍शीमी लोत कली “बोक्‍को, इ मीश नु इ तमी निक्‍शी आस कली लाइश्‍शा, एको सहर रे प्रोक्‍कीन। मप्रोक्‍तीनी हना, एको सहर ङा मुर खोदेंशो पा क्‍याम्‍चा पुंइसीनीनी” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","मिनु लोत कली ओंखां बोक्‍शो तशा, मेको कली आ तमी निक्‍शी नु आ मीशे आन कली गुइ रे कीशा, सहर रे ग्रुंइदसे बाक्‍त। मोपा परमप्रभु यावेमी लोत नु आ खिं ङा मुर आन कली दाक्‍शा प्रोंइमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","सहर रे ग्रुंइशा, परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब कामी “ब्रोंइचा दाक्‍नीनी हना, नोले मकोव़थु प्रोक्‍कीन। दिंमम मबाक्‍कीन। पहाड गे प्रोक्‍कीन। मो मपाइतीनी हना, गे सहर ङा मुर नु क्‍याम्‍चा पुंइसीनीनी” देंमाक्‍त। मत्ती २४:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","मिनु लोतमी “आं प्रभु, गो मचबु। ");
INSERT INTO suzBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","नेनीन, गो इन शिशी ताता। गो आंइ कली दाक्‍शा, बेक्‍चा रे प्रोंइतीनी। गो पहाड प्रोक्‍ने मचबु। पहाडमी अर्को श्‍येतमी आं कली साइक्‍बा, कों। ");
INSERT INTO suzBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","नेनीन, हयु उइ ङा सहर प्रोक्‍चा कली आं नेक्‍था बाक्‍ब। आइक्‍च यो बाक्‍ब। मेकेर प्रोक्‍चा गेयीनी। मेको सहर आइक्‍च बाक्‍ब। मेकेर ब्रोंइने चाप्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","मिनु मेकोमी “लो, गो इ पुंइशो गेनुङ। इ देंशो सहर मक्‍याम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","रीब पा प्रोक्‍कीन। गे मजाक्‍दीन्‍नी सम्‍म मारेइ पने मचाप्‍नुङ” देंमाक्‍त। मेको सहर कली सोआर नें वोदा बाक्‍त। आइक्‍च कली सोआर देंसीब। ");
INSERT INTO suzBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","मिनु लोत सोआर सहर ओव़ची ना रागीमी नां दाप्‍ने थुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","मिनु नोले परमप्रभु यावेमी सोदोम नु गोमोररा सहर आस तारी सरीङ रे गन्‍धक नु मी रेउ यिशो खोदेंशो पा यिपदा बाक्‍त। ब्‍यवस्‍था २९:२२; भजन संग्रह ११:६; यसैया १:९-१०; यसैया १३:१९; आमोस ४:११; लूका १७:२९; २पत्रुस २:६; प्रकाश १४:१० ");
INSERT INTO suzBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","मिनु परमप्रभु यावेमी मेको सहर निक्‍शी, दिंम नेल्‍ल, सहर ङा मुर नेल्‍ल नु रूम मार मार वाशो बाक्‍मे, मेको नेल्‍ल क्‍याम्‍दा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लोत नु आ मुर प्रोक्‍मानु, लोत आ मीशेमी नोले बिर लेश्‍शा कोव़ङा बाक्‍त। मिनु मेको हिक्‍सी के थाम दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","मिनु अब्राहाम नाक्‍त का ङोंइती परमप्रभु यावे आ ङोंइती राप्‍शा बाक्‍तीकेम लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","मिनु सोदोम नु गोमोररा सहर ङा दिंम ङा रू नेल्‍ल कोव़ङा बाक्‍त। मिनु मेको सहर निक्‍शी नु रू नेल्‍ल रे ठेयब चुप्‍लु ङा मी खोदेंशो पा कुन ग्रूशो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","मोपा परमप्रभुमी मेको दिंम, सहर निक्‍शी क्‍याम्‍दा बाक्‍त। मेना परमप्रभुमी अब्राहाम आ पुंइशो लोव़ मिम्‍शा, लोत कली मेको सहर रे ग्रुंइशा प्रोना बाक्‍त। नोले मेकोमी मेको सहर नेल्‍ल खतम पोक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","मिनु लोत नु आ तमी निक्‍शी सोआर रे लशा, पहाड मेर लमा बाक्‍त। मारदे हना सोआर सहरम बाक्‍चा हिंमा बाक्‍त। मेको नु आ तमी निक्‍शी पहाड ङा पुक्‍खीम बाक्‍शो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","मिनु लोत आ ङोंइती जरमेशो तमीमी “इस आफ खाल्‍पा दुम्‍त। नेल्‍ल रागीमी इस कली वोंइश मुर मबाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","लो, इस आफ कली अङगुर शांबुमी दुक्‍पाइश्‍शा, इस आफ नु बाक्‍स। मोपा इस आफ कली चच युइ दुम्‍नीम” दे आ लोक्‍ब कली देंमाक्‍त। लेवी १८:७ ");
INSERT INTO suzBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","मेको नाक्‍दो आस आफ कली अङगुर शांबुम दुक्‍पदसे बाक्‍त। मिनु आ ठेयब तमी आ आफ नु इम्‍‍माक्‍त। लोतमी आ तमी आं नु इप्‍‍शो, बोक्‍शो मारेइ मतुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","मिनु आ दीसा ठेयब तमीमी आ लोक्‍ब कली “नेनो, गो सिनाक्‍दो आफ नु बाक्‍ती। गो लेंशा आफ कली अङगुर शांबुमी दुक्‍पाइक्‍स। मुलाक्‍दो गे इ‍पो। मोपा इस आफ रे चच युइ दुम्‍नीम” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","मिनु मेको निक्‍शीमी आस आफ कली मेको नाक्‍दो यो दुक्‍पदसे बाक्‍त। मिनु कान्‍छी आ आफ नु इप्‍‍थ लमाक्‍त। मिनु लोतमी आ तमी आं नु इप्‍शो, बोक्‍शो मारेइ मतुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","मिनु लोत आ तमी निक्‍शीमी आस आफ के कोव़ज कुरसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","मिनु ठेयब तमीम तौ का थि‍माक्‍त। मेको आ नें मोआब वोदा बाक्‍त। मेको मोआबी आन किकी पिपी बाक्‍माक्‍त। ब्‍यवस्‍था २:९ ");
INSERT INTO suzBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","कान्‍छीमी यो तौ का थि‍माक्‍त। मेको आ नें बेन-अम्‍मी वोदा बाक्‍त। मेको अम्‍मोनी आन किकी पिपी बाक्‍माक्‍त। ब्‍यवस्‍था २:१९; ब्‍यवस्‍था २३:४ ");
INSERT INTO suzBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","मेकेर रे अब्राहाम दक्‍खिनम बाक्‍ब नेगेब गे लमाक्‍त। मिनु कादेश नु शुर आस दाते गेरार सहरमी अर्को रागी ङा मुर दुम्‍शा बाक्‍माक्‍त। उत्‍पत्ती १२:९; उत्‍पत्ती २६:१ ");
INSERT INTO suzBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","मेकोमी मुर आन कली आ मीश, सारा आ पर्बम “आं समी बाक्‍ब” देंमाक्‍त। मिनु गेरार ङा पिप अबीमेलेकमी मेको कली ब्रथ सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","मिनु अबीमेलेकम आ ङोमुमी परमप्रभु आ ङोंइती ग्रूशो तवा बाक्‍त। मिनु “गे मीश चाक्‍शो आ पर्बम बेक्‍चा माल्‍नेवे। मारदे हना मेको ग्‍युंबे पशो मीश मुर बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","मिनु अबीमेलेकम मेको नु मइप्‍‍तीके “परमप्रभु, गे दोस मताइब मुर आन कली यो साइक्‍नीनी? ");
INSERT INTO suzBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","मेकोमी आं कली ‘आं समी बाक्‍ब’ मदेंम ङा? आ मीशेमी यो ‘आं लोक्‍ब बाक्‍ब’ देंत। गो रिम्‍शो थुं नु थमा पा मतुइक्‍तीकेमी चाक्‍ता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","मिनु परमप्रभुमी मेको आ ङोमुमी “गे रिम्‍शो थुंमी पाप्‍तीवी। गो तुइक्‍नुङ। मोपतीके गो इ कली मेको कली थिचा मगेथु, आं ङोंइती मरिम्‍शो पचा मगेङ। ");
INSERT INTO suzBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","मुल मेको मुर आ मीश लेत्‍तो। मारदे हना मेको आं लोव़ पाइब का बाक्‍ब। मेकोमी इ पर्बम पुंइब। मिनु गे ब्रोंइनेवे। गे आ मीश कली मलेत्‍ताक्‍वी हना, गे थमा पा बेक्‍चा माल्‍नेवे। इ मुर नेल्‍ल यो बेक्‍चा माल्‍नीमी, दे तुइक्‍तो” देंमाक्‍त। १राजा १३:६ ");
INSERT INTO suzBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","मोपतीके अबीमेलेक सुनी कना बोक्‍शा, आ गेय पाइब नेल्‍ल आन कली ब्रेश्‍शा, आ ङोमु नेल्‍ल शोव़ङा बाक्‍त। मिनु मुर नेल्‍ल शुश हिंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","मिनु अबीमेलेकम अब्राहाम कली यो ब्रेत्‍ता बाक्‍त। मिनु मेको कली “मारदे आंइ कली ओदेंशो पवी? गो नु आं रागी कली ओदेंशो मरिम्‍शो पपाइक्‍चा कली गो इ कली मार मरिम्‍शो पाइक्‍ना? गे मपचा ङा गेय पाप्‍तीवी। ");
INSERT INTO suzBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","गे मारदे ओदेंशो पचा मिम्‍ती?” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","मिनु अब्राहाममी “थमा पा, एको रागी ङा मुरपुकी परमप्रभु कली मान पा महिंनीमी। मिनु आं मीश आ पर्बम आं कली साइक्‍नीम, दे मिम्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","मेको थमा आं समी यो बाक्‍ब। आं आफ आ तमी बाक्‍ब। तन्‍न आं ममा आ तमी ममाइ। गो मेको कली चाक्‍ता। लेवी १८:९ ");
INSERT INTO suzBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","मिनु परमप्रभुमी आं कली आं आफ आ खिं रे गाक्‍पाइय्‍यीनु, गो आं मीश कली ‘आं कली दाक्‍नेवे हना, गो ते ते जाक्‍दीस्‍सा, मेक मेक एको आं लोक्‍ब बाक्‍ब, देनो’ दे माइक्‍ता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","मिनु अबीमेलेकमी भेडापुकी, बी ब्‍यफ नु वाइलीम वाइल आन कली लाइश्‍शा, अब्राहाम कली गेवा बाक्‍त। आ मीश सारा यो लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","मिनु “नेनीन, आं रागीमी ते ते बाक्‍चा दाक्‍नेवे, मेक मेक बाक्‍ने चाप्‍नेवे” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","मिनु सारा कली “नेनो, इ लोक्‍ब कली हजार का चांदी टुक्रा गेता। मेको इन कली इ मुर आन ङोंइती इ कली रिम्‍शो पचा कली गेता। मोपा नेल्‍ल आन ङोंइती इ कली ठीक पाता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","मिनु अब्राहामम अबीमेलेक आ पर्बम परमप्रभु कली पुना बाक्‍त। मिनु परमप्रभुमी अबीमेलेक, आ मीश नु आ गेय पाइब नेल्‍ल आन पर्बम आल मथितीक रोइ रे सापदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","मारदे हना परमप्रभु यावेमी अब्राहाम आ मीश सारा आ पर्बम अबीमेलेक आ खिं ङा मुर नेल्‍ल आन कली आल मथीब सेल्शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","मिनु परमप्रभु यावेमी सारा कली मार देंमे, मेकोन दुम्‍पदा बाक्‍त। उत्‍पत्ती १८:१० ");
INSERT INTO suzBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","मिनु सारामी खाल्‍पी दुम्‍शा, अब्राहाम के कोव़ज कुरशा, तौ का थि‍माक्‍त। परमप्रभुमी गेना थीब देंमे, मेना थि‍माक्‍त। हिब्रू ११:११ ");
INSERT INTO suzBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","मिनु अब्राहाममी सारा आ थिशो तौ कली इसहाक नें वोदा बाक्‍त। उत्‍पत्ती १७:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","मिनु अब्राहाममी आ तौ इसहाक कली ८ नाक्‍ती दुम्‍मेनु, ख्रोइक्‍तीक चिनु ख्रोदा बाक्‍त। परमप्रभुमी ङोंइती दोपा अरेवा, मोपा पवा बाक्‍त। उत्‍पत्ती १७:११-१२; प्रेरित ७:८ ");
INSERT INTO suzBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","अब्राहाम आ तौ इसहाक थिमेनु, सहे का बर्स दुम्‍शो बाक्‍माक्‍त। उत्‍पत्ती १७:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","मिनु सारामी “परमप्रभुमी आं कली रिप्‍पाइक्‍ती। सु सुम एको नेंनीमी, मेको यो गो नु रित्‍नीम। उत्‍पत्ती १८:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","सु सुमी अब्राहाम कली ‘इ मीशेमी आल कली दूध तुंइब’ देंनीमी? गो खाल्‍पा दुम्‍शो अब्राहाम के तौ का थिती” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","मिनु आल कोल्‍शा, दूध तूचा प्रोना बाक्‍त। मिनु दूध तूचा प्रोना नाक्‍ती अब्राहाममी ठेयब भोज सेल्‍शा, मुर आन कली थुल्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","मिनु सारामी इजीप्‍त ङा हागार नु अब्राहाम आस थिशो तौ इश्‍माएलमी इसहाक कली शुक्‍शी पशो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","मिनु मेकोमी अब्राहाम कली “वाइलीम नु आ तौ आस कली खेरो। मेको वाइलीम आ तौ कली, आं तौ इसहाक नु अङस योक्‍शा गेचा मदुम्‍ब” देंमाक्‍त। गलाती ४:३० ");
INSERT INTO suzBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","अब्राहामम आ लोव़ नेंशा, थुं मनुमाक्‍त। मारदे हना इश्‍माएल यो आ तौ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तन्‍न परमप्रभुमी अब्राहाम कली “वोंइश आल नु इ वाइलीम आ पर्बम सुर्ता मपावो। सारामी मार मार देंमे, मेको नेल्‍ल पावो। मारदे हना इसहाक आ चच युइ इ जात दुम्‍नीम। उत्‍पत्ती १७:२१; रोमी ९:७-८; हिब्रू ११:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","मिनु इ वाइलीम आ तौ इश्‍माएल आ चच युइ रे यो ठेयब जात का सेल्‍नुङ। मारदे हना मेको यो इ तौ बाक्‍ब” देंमाक्‍त। उत्‍पत्ती १७:२० ");
INSERT INTO suzBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","मिनु अब्राहाम सुनी कना बोक्‍शा, हागार कली शोब्‍ले नु ब्‍वाक्‍कु कुरपाइश्‍शा, आ तौ नु सोइक्‍ता बाक्‍त। मिनु हागार नु आ तौ लसा बाक्‍त। मिनु लशा, लां जाम्‍शा, बेयर-शेबा माइश्‍शो गोरशो रागीम हिरससा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","मिनु ब्‍वाक्‍कु नुप्‍शा, आ आल कली बुटा आगाम वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","मिनु हागार चहिं आइदी लशा, निस्‍से बाक्‍त। मारदे हना मेकोमी “आं आल बेक्‍शो मतङल” दे मिम्‍ता बाक्‍त। मिनु ठेयब सेंदा पा ङाक्‍माक्‍त। यसैया ४९:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","मिनु परमप्रभुमी आल आ ङाक्‍शो सेंदा नेना बाक्‍त। मिनु परमप्रभु आ स्‍वर्ग ङा गेय पाइबमी सरीङ रे “हागार, मार दुमे? महिनो। मारदे हना परमप्रभुमी उइ बाक्‍शो इ तौ आ ब्रेश्‍शो नेंतु। ");
INSERT INTO suzBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","बोक्‍को, इ तौ लाइश्‍शा गाक्‍को। गो मेको रे ठेयब जात का सेल्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","मिनु परमप्रभुमी हागार आ मिक्‍च तपदानु, ब्‍वाक्‍कु बुक्‍तीके का तवा बाक्‍त। मिनु आ ब्‍वाक्‍कु कुरतीके प्रिंशा, आ तौ कली तूपदा बाक्‍त। २राजा ६:१७,२० ");
INSERT INTO suzBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","मिनु परमप्रभु मेको वोंइश आल नु बाक्‍मेनु, मेको कोल्‍शा, गोरशो रागीमी बाक्‍शा, लिब्रा आप्‍स शुश जोक्‍ब दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","मेको गोरशो रागी आ नें पारान बाक्‍माक्‍त। मिनु आ ममामी आ तौ कली इजीप्‍त रागी ङा तमी चाक्‍शा गेवा बाक्‍त। उत्‍पत्ती १६:३ ");
INSERT INTO suzBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","मिनु काबु अबीमेलेक नु आ फौज ङा ठेयब कप्‍तान फीकोल अब्राहाम आ बाक्‍तीक जाक्‍शा, अब्राहाम कली “गे मार मार पाइनीनी, परमप्रभु गे नु बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","मोपतीके गो इन कली मार पुंइनुङ देंशा हना, आं कली, आं तमी तौ नु आं चच युइ आंइ कली श्‍येत मगेकी। गो इन कली रिम्‍शो पशो खोदेंशो पा, आं कली यो रिम्‍शो पने। इन बाक्‍शो रागी कली यो रिम्‍शो पने। ‘रिम्‍शो पाइनुङ’ दे परमप्रभु आ नें थिशा, कसम जने” दे पुना बाक्‍त। उत्‍पत्ती २०:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","मिनु अब्राहाममी “गो कसम जाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","मिनु अब्राहाममी अबीमेलेक कली हुइक्‍ता बाक्‍त। मारदे हना अबीमेलेक आ गेय पाइबपुकीमी अब्राहाम आ इनार आ पर्बम जिशा, रोइक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","मिनु अबीमेलेकमी “गो मेको मतुइक्‍तु, सुम पवा? गे यो मशेंदीनी। मुलाक्‍त ला नेंता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","मिनु अब्राहाममी भेडापुकी नु ब्‍यफपुकी अबीमेलेक कली गेवा बाक्‍त। मोपा मेको निक्‍शी सल्‍ला पाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामम ७ ओटा पाठी चहिं बगाल रे ग्रुंइशा, वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","मिनु अबीमेलेकम “मेको ७ ओटा पाठी मारदे वोइक्‍नी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","मिनु “मेको ७ ओटा पाठी आं गुइ रे लाइक्‍चा माल्‍नीनी। गो आं दोशो इनार आ सांकछी दुम्‍नीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","मिनु मेको बाक्‍तीके कली बेयर-शेबा, दे नें वोदसे बाक्‍त। मारदे हना मेको निक्‍शी मेकेर कसम जाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","मिनु बेयर-शेबामी मेको सल्‍ला पने थुम्‍शा, अबीमेलेक नु फीकोल आ ठेयब कप्‍तान पलिस्‍ती आन रागी लेस्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहाममी चहिं बेयर-शेबाम रवा का ख्रुमा बाक्‍त। मिनु मेकेर परमप्रभु यावे, गेना हना यो बाक्‍ब परमप्रभु आ नें थिशा, मेको नु लोव़ पवा बाक्‍त। उत्‍पत्ती १२:८; रोमी १६:२६ ");
INSERT INTO suzBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","मिनु पलिस्‍ती आन रागीमी अब्राहाम अर्को रागी ङा मुर दुम्‍शा, शुश नाक्‍त बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","मिनु नोले परमप्रभुमी “अब्राहामम आं कली टीबाक्‍म कों, मटीबाक्‍म” दे मिम्‍शा “अब्राहाम” दे ब्रेत्‍ता बाक्‍त। अब्राहाममी “गो एक बाक्‍ती” दे परमप्रभु कली मदा बाक्‍त। प्रस्‍थान १५:२५; प्रस्‍थान १६:४; प्रस्‍थान २०:२०; ब्‍यवस्‍था ८:२; ब्‍यवस्‍था १३:४; न्‍यायाधीस २:२२; हिब्रू ११:१७; याकूब १:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","मिनु मेकोमी “इ तौ लतो। का ला बाक्‍शो दाक्‍शो इ तौ इसहाक लतो। मिनु मोरीयाह रागी लावो। मेकेर लशा, इ तौ कली चोशा चढ़ेयी। तेको डांडाम चढ़ेचा माल्‍नेवे, गो इ कली कोंइन‍न” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","मिनु अब्राहाम सुनी कना बोक्‍शा, चढ़ेतीकेम चोचा कली शी चेश्‍शा, आ गधा ठीक पवा बाक्‍त। मिनु ठिटा निक्‍शी नु आ तौ इसहाक कली लाइश्‍शा, परमप्रभुमी देंशो पहाड लमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","लमा लमा नाक्‍त सां नोले परमप्रभु आ देंशो बाक्‍तीके ङोन रे तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","मिनु अब्राहाममी आ गेय पाइब निक्‍शी आस कली “एकेर गधा नु बाक्‍कीसे। गो आं तौ नु मिरी आइक्‍था लशा, चढ़ेशा, इस बाक्‍तीक लेत्‍नस्‍कु” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","मिनु अब्राहाममी चोशा चढ़ेतीक शी इसहाक कली कुरपदा बाक्‍त। मिनु मी नु चुक्‍ब आंमा कुरा बाक्‍त। मोपा निम्‍फा लसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","मिनु इसहाकम आ आफ कली “आं आफ” देंमाक्‍त। मिनु अब्राहाममी “गो नेंता” देंमाक्‍त। मिनु इसहाकमी “गो मी नु शी ला कुरशा गाक्‍तस, चोशा चढ़ेतीक पाठा चहिं ते बाक्‍म?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","मिनु अब्राहाममी “चोशा चढ़ेतीक पाठा परमप्रभुमी गेब” देंमाक्‍त। मोपा निम्‍फा लसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","मिनु परमप्रभुमी देंशो रागी जाक्‍दीस्‍सानु, अब्राहाममी फुल्‍लु चाक्‍शा, चढ़ेतीक सेला बाक्‍त। मिनु चढ़ेतीक तारी शी प्रोव़ङा बाक्‍त। मिनु आ तौ इसहाक कली गुइ खोइल फ्रेंशा, शी तारी वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","मिनु अब्राहाममी आ तौ क्‍योरचा कली चुक्‍ब शोइश्‍शा तरेवा बाक्‍त। मत्ती २६:३९; याकूब २:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी सरीङ रे “अब्राहाम, अब्राहाम” दे ब्रेत्‍ता बाक्‍त। मिनु अब्राहाममी “गो नेंता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","मेकोमी “इ तौ कली मक्‍योरो। मेको कली मारेइ मपतो। मारदे हना गे परमप्रभु कली मान पा हिंबाक्‍ते। गो मुल तुइक्‍ताक्‍ङ। गे इ का ला बाक्‍शो तौ आं कली गेचा ठीक पाप्‍तीवी। इ का ला तौ यो आं कली गेचा टीबाक्‍ते” देंमाक्‍त। रोमी ८:३२; हिब्रू ११:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","मिनु अब्राहाममी एर गे कोव़ङानु, सांड का आ ग्रोव़ चू लहाराम रेश्‍शा, बाक्‍शो तवा बाक्‍त। मिनु लशा सांड चाक्‍शा, आ तौ आ पा ङा मेको सांड क्‍योरशा, चोशा चढ़ेतीक चढ़ेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","मिनु अब्राहाममी मेको डांडा कली परमप्रभु यावे यीरेह, दे नें वोदा बाक्‍त। मोपतीके मुल सम्‍म मुरपुकीम “परमप्रभु यावे आ डांडाम परमप्रभु यावेमी माल्‍शो गेब” देंनीम। “परमप्रभु यावे यीरेह” आ अर्थ “परमप्रभु यावेमी आं माल्‍शो गेब” देंशो बाक्‍ब।उत्‍पत्ती १६:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी लेंशा सरीङ रे अब्राहाम कली ");
INSERT INTO suzBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“परमप्रभु यावेमी ‘गो आं नेंमी कसम जाता। मारदे हना गे इ तौ आं कली गेचा ठीक पाप्‍तीवी। प्रस्‍थान ३२:१३; यसैया ४५:२३; आमोस ६:८; मीका ७:२०; लूका १:७३; हिब्रू ६:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","मार कसम जाता देंशा हना, गो इ कली आसीक गेनुङ। इ चच युइ आन कली सोरुल नु समुन्‍द्र आ नेक्‍था ङा बाल्‍वा खोदेंशो पा शुश सेल्‍नुङमी। मिनु मेकोपुकीमी आन जोरी सत्रु आन सहर आंम के सेल्‍नीम। उत्‍पत्ती १३:१६; हिब्रू ११:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","इ चच युइ आन पर्बम रागी रागी ङा मुर नेल्‍ल आसीक राइनीम। मारदे हना गे आं देंशो टीब बाक्‍ते’ दे परमप्रभु यावेमी देंत” दे आ स्‍वर्ग ङा गेय पाइबम अब्राहाम कली लोव़ पवा बाक्‍त। उत्‍पत्ती १२:३; गलाती ३:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","मिनु अब्राहाम मेकेर रे लशा, आ गेय पाइब निक्‍शी आस रिम्‍तीके लेस्‍सा बाक्‍त। मिनु ग्रुम्‍शा, बेयर-शेबा माइक्‍तीकेम लमा बाक्‍त। मिनु अब्राहाम मेक उइ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","मिनु मेको नोले मुरुमी अब्राहाम कली “मिल्‍कामी यो इन लोक्‍ब नाहोर रे पा आल थिप्‍तु। उत्‍पत्ती ११:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","आ ङोंइती जरमेशो तौ ऊज, आ लोक्‍ब बूज, अराम आ आफ केमुएल, ");
INSERT INTO suzBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","केसेद, हाजो, पिल्‍दाश, यिदलाफ नु आ कान्‍छा बेथुएल बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बेथुएल चहिं रेबेका आ आफ बाक्‍त। मिल्‍कामी अब्राहाम आ लोक्‍ब नाहोर के ८ जना तौ थिप्‍तु। उत्‍पत्ती २४:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोर आ कान्‍छी मीश आ नें रूमा बाक्‍माक्‍त। मेकोमी तेबाह, गाहाम, ताहाश नु माकाह थिमाक्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","मिनु सारा सहे का २७ बर्स दुम्‍शो बाक्‍माक्‍त। आ ब्रोंइतीक नाक्‍त नेल्‍ल मोशोन बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","सारा कनान रागी ङा किरयथ-अरबाम बेक्‍माक्‍त। मेको कली हेब्रोन यो देंनीम। मिनु अब्राहाम सारा आ पर्बम हिंशेक पा ङाक्‍थ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","अब्राहाम सारा आ बेक्‍शो रां बाक्‍तीके रे लशा, हित्ती आ मुर आन कली ");
INSERT INTO suzBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“गो इन दातेमी अर्को रागी ङा मुर बाक्‍नुङ। गो थिम्‍तीक का ग्‍याप्‍चा दाक्‍नुङ। मारदे हना आं बेक्‍शो मुर कली थिम्‍चा माल्‍नुङ” देंमाक्‍त। उत्‍पत्ती १७:८ ");
INSERT INTO suzBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","मिनु हित्ती आ मुरपुकीमी अब्राहाम कली ");
INSERT INTO suzBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“प्रभु, आंइ लोव़ नेनीन, गे आंइ दातेमी परमप्रभुमी सेल्‍शो ठेयब मुर बाक्‍नीनी। आंइ के बेक्‍शो मुर आन कली वोइक्‍तीक पुक्‍खी शुश बाक्‍नीम। तेको दाक्‍नीनी, मेकोमी इन बेक्‍शो मुर थिमीन। इन बेक्‍शो मुर थिम्‍चा सुइमी मतेक्‍ब” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","मिनु अब्राहाम बोक्‍शा, हित्ती आ मुर आन ङोंइती सेउ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","मेको आन कली “आं बेक्‍शो मुर थिम्‍चा गेतीनी हना, आं पर्बम सोहार आ तौ एफ्रोन नु लोव़ पने। ");
INSERT INTO suzBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","मेको आ रू आ नोले बाक्‍ब माक-पेला पुक्‍खी आं कली लेयङ, दे पुंइदीन। गिश थाप्‍चा माल्‍नुङा, थाप्‍नुङ। इन दातेमी आं बेक्‍शो मुर थिम्‍तीके दुम्‍ल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","मेना एफ्रोन हित्ती आन दातेमी निश्‍‍शो बाक्‍माक्‍त। मेको आन सहर ङा गारो ङा ठेयब लाप्‍चो आ नेक्‍था बाक्‍‍शा, अब्राहाम आ लोव़ नेन्‍मेनु, मेको हित्ती एफ्रोनमी अब्राहाम कली ");
INSERT INTO suzBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“प्रभु, ममाइ, आं लोव़ नेनीन, गो इन कली मेको रू नु पुक्‍खी गेनुङ। आं मुरपुकी सांकछी बाक्‍नीम। गो इन कली गेनुङ। इन बेक्‍शो मुर थिमीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","मिनु अब्राहाममी मेको मुर आन ङोंइती सेउ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","मिनु मुर नेल्‍ल आन ङोंइती अब्राहाममी एफ्रोन कली “आं लोव़ नेनीन। गो मेको रू ङा क्‍येट थाप्‍नुङ। मेको ताक्‍कीन। गो आं मीश मेक थिम्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","मिनु एफ्रोनमी अब्राहाम कली ");
INSERT INTO suzBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“प्रभु, आं लोव़ नेनीन, मेको रू ४ सहे शेकेल चांदी ङा बाक्‍ब। मेको इस दातेमी मारेइ ममाइ। मोपतीके थिमीन” देंमाक्‍त। शेकेल का ११.५ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","मिनु अब्राहाममी एफ्रोन आ लोव़ बिस्‍से बाक्‍त। मेकोमी एफ्रोनमी हित्ती आ मुर आन ङोंइती देंशो खोदेंशो पा ४ सहे शेकेल चांदी नाक्‍शा, गेमी बाक्‍त। मेको ४ सहे शेकेल चहिं ग्‍याप्‍ब लेयब आन दातेमी मोदेंशो रू कली ठीक बाक्‍माक्‍त। शेकेल का ११.५ ग्राम चांदी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","माक-पेलामी बाक्‍शो एफ्रोन आ रू माम्रे आ पूर्ब गे बाक्‍शो बाक्‍माक्‍त। मोपा रू नु पुक्‍खी, रूमी बाक्‍शो रवा नेल्‍ल नु एर ओंथ सुरम ख्रुम्‍शो रवा यो ");
INSERT INTO suzBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","हित्ती नेल्‍ल नु ठेयब लाप्‍चोम बाक्‍ब आन ङोंइती अब्राहाम के दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","मिनु नोले अब्राहामम आ मीश सारा कली माम्रे आ नेक्‍था माक-पेलामी बाक्‍शो पुक्‍खीमी थिमा बाक्‍त। माम्रे चहिं कनान रागी ङा हेब्रोन सहर बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","मिनु मेको रू नु मेक बाक्‍शो पुक्‍खी हित्ती आ मुरपुकी रे अब्राहाम आ मुर थिम्‍तीक रू दुम्‍माक्‍त। उत्‍पत्ती २५:९-१०; उत्‍पत्ती ४७:३०; उत्‍पत्ती ४९:२९-३२; उत्‍पत्ती ५०:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","मिनु अब्राहाम शुश बर्स दुम्‍शा, खूशो दुम्‍माक्‍त। परमप्रभु यावेमी अब्राहाम कली आ पतीक नेल्‍लेमी आसीक गेवा बाक्‍त। उत्‍पत्ती १२:२ ");
INSERT INTO suzBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","मिनु अब्राहाममी आ रू खिं नेल्‍ल कोव़ब नु वाइल आन कली अरेब ठेयब वाइल कली “इ गुइ आं फिला तारी वोतो। ");
INSERT INTO suzBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","गो इ कली परमप्रभु यावे, सरीङ नु रागी ङा परमप्रभु आ नेंमी कसम जपाइक्‍नुङ। मार कसम जपाइक्‍नुङ देंशा हना, आं तौ कली आं बाक्‍शो कनान रागी ङा मीश आल मचाक्‍को। उत्‍पत्ती २८:१; प्रस्‍थान ३४:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","आं रागी नु आं जात ङा मीश आल का चाक्‍को” दे अब्राहाममी वाइल कली मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","मिनु वाइलमी “मेको मीश आल एको रागी जाक्‍चा मबिस्‍साक्‍व हना, इन तौ इन जरमेशो रागीम लाइक्‍चा माल्‍नुङा?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","मिनु अब्राहाममी “मोदेंशो गेनायो मपावो। आं तौ कली मेक मलतो। ");
INSERT INTO suzBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ङोंइती परमप्रभु यावे, सरीङ नु रागी ङा परमप्रभुम आं कली आं आफ आ खिं नु आं जात ङा रागी रे ग्रुंइशा, एक सोइक्‍ताक्‍यी। मेकोमी कसम जशा, आं कली लोव़ पाप्‍तु ‘कनान रागी इ चच युइ आन कली गेनुङमी’ दे माइक्‍ती। मेकोमी आ स्‍वर्ग ङा गेय पाइब इ ङोंइती सोइक्‍ब। आं तौ कली आं जात रे मीश आल का चाक्‍को। २इतिहास ३६:२३; नेहेम्‍याह २:२० ");
INSERT INTO suzBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","मेको मीश आल गे नु जाक्‍चा मबिस्‍साक्‍व हना, गे कसम मजशो खोदेंशो दुम्‍नेवे। आं तौ कली चहिं मलतो” दे अब्राहाममी आ वाइल कली अरेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","मिनु मेको वाइलमी आ होव़प अब्राहाम आ फिला तारी गुइ वोइश्‍शा, आ देंशो आ पर्बम कसम जवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","मिनु नोले मेको वाइलम आ होव़प आ दलओंठ १० ओटा लाइश्‍शा, आ होव़प के मारेइ मारेइ रिम्‍शो कोसेली कुरशा लमाक्‍त। मेकेर रे लशा, मेसोपोटामीया रागीमी नाहोर आ बाक्‍तीक सहर, अराम-नहराइम मेर जाक्‍दीम्‍माक्‍त। उत्‍पत्ती ११:२२-३१ ");
INSERT INTO suzBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","मिनु मेकेर जाक्‍दीश्‍शा, नाक्‍नाक्‍दो मीश मुरपुकी ब्‍वाक्‍कु दिथ जाक्‍ची ना, सहर मओव़थु, दलओंठपुकी इनार आ नेक्‍था नाइक्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","मिनु मेकोमी “परमप्रभु यावे, आं होव़प अब्राहाम आ परमप्रभु, मुलाक्‍ती आं कली वारच पने। आं होव़प कली इन गेना हना यो दाक्‍तीके कोंइदीने। मेकोन पुंइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","गो इनार आ नेक्‍था बाक्‍नुङ। मिनु सहर ङा मुर आन तमी ब्‍वाक्‍कु दिथ जाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","गो मीश आल कली ‘इ गाग्री ङा ब्‍वाक्‍कु इच्‍का तूचा गेयी’ देंनुङ। मेको मीश आलमी ‘तूङो। गो इ दलओंठ आन कली यो ब्‍वाक्‍कु तुंइनुङ’ देंत हना, मेको मीश आल इन गेय पाइब इसहाक कली योव़शो बाक्‍ल। मोदेंशो दुम्‍त हना, गे आं होव़प कली इन गेना हना यो दाक्‍तीके कोंइताक्‍नी, दे गो तुइक्‍नुङ” दे परमप्रभु कली लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","मोपा लोव़ पन पना, रेबेका माइश्‍शो मीश आल का गाग्री कुरशा जाक्‍माक्‍त। मेको रेबेका बेथुएल आ तमी बाक्‍माक्‍त। बेथुएल चहिं अब्राहाम आ लोक्‍ब नाहोर नु आ मीश मिल्‍का आस तौ बाक्‍माक्‍त। उत्‍पत्ती २२:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रेबेका थम दारशो मीश आल बाक्‍माक्‍त। मिनु ग्‍युंबे मपथु, कन्‍ने बाक्‍शो बाक्‍माक्‍त। मिनु इनारम तोइश्‍शा, आ गाग्री प्रिंशा बेप मुप्‍शा ङोंइ‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","मिनु मेको वाइल रेबेका कली ग्रुम्‍थ दोरमाक्‍त। मिनु “इ गाग्री ङा ब्‍वाक्‍कु इच्‍का तूचा गेयी” दे पुना बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","मिनु रेबेकामी आ गाग्री रीब पा नाइश्‍शा, तूचा गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","मिनु तूचा गेने थुम्‍शा “गो इन दलओंठ आन कली यो ब्‍वाक्‍कु चाक्‍शा, मरूमा सम्‍म तुंइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","मिनु आ गाग्री ङा ब्‍वाक्‍कु मेकेर बाक्‍शो शुंगुमी मोइश्‍शा, दोरशा ब्‍वाक्‍कु ब्रथ लमाक्‍त। दलओंठ नेल्‍ल आन कली मरूमा सम्‍म ब्‍वाक्‍कु तुंइदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","मिनु मेको वाइल छक लाक्‍शा, मेको कली कोव़शा, परमप्रभु यावे आ योव़शो मीश आल बाक्‍म कों मबाक्‍म, दे ब्‍वालेइ पा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","मिनु दलओंठ रूथ्री ब्‍वाक्‍कु तूङमे नोले वाइलम आधी शेकेल सुन के मुन्‍द्री नु १० शेकेल सुन के चुरा निक्‍शी शोल्‍शा, रेबेका कली गेवा बाक्‍त। शेकेल का ११.५ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","मिनु वाइलमी “गे सु का आ तमी नवे? आं कली देनो। इ आफ आ खिंम आंइ कली बास बाक्‍चा गेनीमी कों?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","मिनु रेबेकामी “गो बेथुएल आ तमी नङ। बेथुएल चहिं नाहोर नु मिल्‍का आस तौ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","आंइ खिंम नल नु जचा थोव़क शुश बाक्‍ब। बास बाक्‍तीक यो बाक्‍ब” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","मिनु वाइलमी खुम्‍की पा बाप्‍शा, परमप्रभु यावे आ ङोंइती गु बाप्‍शा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","मिनु मेकोमी “परमप्रभु यावे, आं होव़प अब्राहाम आ परमप्रभु, गे ठेयब बाक्‍नीनी। गे इन शिशी नु इन रिम्‍शो पशो मप्रोंइथु, आं होव़प कली कोंइताक्‍नी। गे आं कली आं होव़प आ लोक्‍ब आ खिं कोंइताक्‍यीनी” दे परमप्रभु यावे कली ठेयब सेला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","मिनु रेबेका दोरशा खिं लेश्‍शा, आ ममा आ खिं ङा मुर आन कली मार मार दुम्‍मे, मेको नेल्‍ल देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","मिनु लाबान माइश्‍शो, रेबेका आ लोक्‍ब का बाक्‍माक्‍त। मेको दोरशा, इनारम मेको मुर कली ग्रुम्‍थ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","मारदे हना मेकोमी आ समी आ मुन्‍द्री नु चुरा तशा “मेको मुरुम आं कली मोदेंशो लोव़ पाप्‍तु” देंशो नेंशा, लाबान मेको मुर कली ग्रुम्‍थ लमाक्‍त। मेको मुर आ दलओंठ नु इनारम बाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","मिनु लाबानम मेको कली “परमप्रभु यावे आ आसीक राइब, गे मारदे मेकेर बाक्‍नीनी? आंइ खिं पिने। गे नु इन दलओंठ आन कली मारेइ मारेइ ठीक पाता” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","मिनु वाइल खिं ओव़माक्‍त। लाबानमी दलओंठ तार वोइश्‍शो नेल्‍ल शोल्‍शा, थुल्‍चा कली नल लाप्‍ता बाक्‍त। मिनु मेको मुर नु आ गेय पाइब आन कली खोइल चिक्‍चा कली ब्‍वाक्‍कु यो गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","नोले मेको आ ङोंइती जचा थोव़क ख्रेत्‍मे बाक्‍त। मेकोमी चहिं “गो मारदे पिङा, इन कली मदेंङा सम्‍म मजाइनुङ, मब्‍वाइनुङ” देंमाक्‍त। मिनु लाबानमी “इन के मार लोव़ बाक्‍मे? लो देनीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","मिनु वाइलमी “गो अब्राहाम आ वाइल नङ। ");
INSERT INTO suzBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","मिनु परमप्रभु यावेमी आं होव़प कली शुश आसीक गेप्‍तु। मिनु शुश शोंप पाइश्‍शो दुम्‍त। मेकोमी मेको कली क्‍यारश भेडा, सुन चांदी, वाइलीम वाइल, दलओंठ नु गधा शुश गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मिनु आं होव़प आ मीश सारामी खाल्‍पी दुम्‍शा, अब्राहाम के तौ का थिप्‍तु। मिनु अब्राहामम आ तौ कली आ मारेइ मारेइ नेल्‍ल गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मिनु आं होव़पमी आं कली ‘आं तौ कली आं बाक्‍शो कनान रागी ङा मुर आन तमी मचाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","गे आं आफ आं खिं नु आं मुर आन खिं रे मीश आल का चाक्‍को’ दे कसम जपाइक्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मिनु गो आं होव़प कली ‘मीश आल एको रागी जाक्‍ने मबिप्‍बा, कोर में’ देंती। ");
INSERT INTO suzBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","मेकोमी चहिं ‘गो परमप्रभु यावे आ ङोंइती गाक्‍‍नुङ। मेकोमी आ स्‍वर्ग ङा गेय पाइब गे नु सोइक्‍ब। मेकोमी इ कली वारच पाइब। मिनु आं तौ कली आं मुर आन खिं नु आं आफ आं खिं रे मीश आल का चाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","आं खिं ङा मुर आन बाक्‍तीके जाक्‍दीश्‍शा, मीश आल का मगेतेमी हना, गे कसम मजशो खोदेंशो दुम्‍नेवे’ दे आं होव़पमी आं कली माइक्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","मिनु मुलाक्‍ती इनारम जाक्‍शा, गो ‘परमप्रभु यावे, आं होव़प, अब्राहाम आ परमप्रभु, गे आं कली वारच पने। ");
INSERT INTO suzBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","गो इनार आ नेक्‍था बाक्‍नुङ। मिनु मीश आल ब्‍वाक्‍कु दिथ जाक्‍मानु, मीश आल कली इ गाग्री ङा ब्‍वाक्‍कु इच्‍का तूचा गेयी, देंनुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","मिनु मेको मीश आलमी तूङीन, गो इन दलओंठ आन कली यो ब्‍वाक्‍कु तुंइनुङ, देंत हना, मेको मीश आल आं होव़प आ तौ कली परमप्रभु यावेमी योव़शो बाक्‍ल’ देंती। ");
INSERT INTO suzBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मिनु गो आं थुंमी लोव़ पने मथुम्‍थु, रेबेका आ गाग्री मुप्‍शा पित। मिनु इनारम ब्‍वाक्‍कु कीथ तोंइसाक्‍व। मिनु गो ‘आं कली इच्‍का तूचा गेयी’ दे माइक्‍ता। ");
INSERT INTO suzBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","मिनु मेकोमी आ गाग्री रीब पा नाइश्‍शा ‘तूङो। गो इन दलओंठ आन कली यो तुंइनुङ’ देंत। मिनु गो तूता। मेकोमी आं दलओंठ आन कली ब्‍वाक्‍कु तुंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","मिनु गो ‘गे सु का आ तमी नवे?’ दे हिल्‍लो पङानु ‘गो बेथुएल आ तमी नङ। बेथुएल नाहोर नु मिल्‍का आस तौ बाक्‍ब’ दे माइक्‍ती। मिनु गो आ नेंमी मुन्‍द्री पाइक्‍ताक्‍ङ, आ गुइमी चुरा लिक्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","मिनु गो परमप्रभु यावे आ ङोंइती गु बाप्‍शा ‘परमप्रभु यावे, आं होव़प अब्राहाम आ परमप्रभु, गे रिम्‍शो पाइब बाक्‍नीनी’ दे ठेयब सेल्‍ता। मारदे हना आं होव़प आ लोक्‍ब आ खिं ङा मुर रे आ तौ कली तमी चाक्‍चा कली रिम्‍शो लां कोंइताक्‍यी। ");
INSERT INTO suzBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","मिनु ‘गे आं होव़प कली शिशी नु रिम्‍शो पचा मप्रोंइतीनी हना, आं कली देनीन। मेको पचा मदाक्‍नीनी हना यो देनीन। मारदे हना गो ग्‍युरा पेरा गे लचा माल्‍नुङ’ ” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","मिनु लाबान नु बेथुएलमी “मेको नेल्‍ल परमप्रभु यावे आ पशो बाक्‍ब। मार पाइनस्‍कु मार देंनस्‍कु ङा। ");
INSERT INTO suzBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","लो, रेबेका कली लतो। मिनु लावो। इन होव़प आ तौ आ मीश दुम्‍ल। दोपा परमप्रभु यावेमी लोव़ पवा, मोपा दुम्‍ल” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","मिनु अब्राहाम आ वाइलम मेको लोव़ नेंशा, परमप्रभु यावे आ ङोंइती खुम्‍की पा बाप्‍शा, मेको कली ठेयब सेला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","मिनु आ गेय पाइबमी सुन नु चांदी के गहना नु दारशो वासी रेबेका कली गेमे बाक्‍त। आ लोक्‍ब नु आ ममा आस कली यो मार मार गेमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","मिनु जशा तूशा, आ गेय पाइबपुकी नु नाक्‍दो बाक्‍मा बाक्‍त। मिनु सुनी कना बोक्‍मानु, वाइलमी “आं होव़प आ बाक्‍तीक लेत्‍चा गेयीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","मिनु रेबेका आ लोक्‍ब नु आ ममामी “रेबेका १० नाक्‍त सम्‍म बाक्‍ल, कोर में। मिनु नोले लन” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","मिनु वाइलमी “परमप्रभु यावेमी आं कली आसीक गेशा, रिम्‍शो पा वारच पाइक्‍ती। मोपतीके आं कली मक्‍योल्‍यीनी। आं होव़प आ बाक्‍तीक लेत्‍चा गेयीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","मिनु मेको निक्‍शीम “रेबेकामी मार देंबा, मेको नेंय” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","मिनु रेबेका कली ब्रेश्‍शा “एको मुर नु लाइनेवे?” दे हिल्‍लो पाम्‍सेनु “गो लाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","मिनु नोले आ समी रेबेका नु आ कली वारच पाइब, अब्राहाम आ वाइल नु आ गेय पाइब आन कली सोइक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","लचा ङोंइती रेबेका कली आसीक गेशा “गे आं समी बाक्‍नेवे। सोशा बोशा, शुश दुमीने। इ चच युइ आन कली आन जोरी सत्रु आन कली ग्राङीन” दे आसीक गेमे बाक्‍त। उत्‍पत्ती २२:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","मिनु नोले रेबेका नु आ वारच पाइब बोक्‍शा, दलओंठ ङोइश्‍शा, मेको मुर नु ल‍सा बाक्‍त। मोपा वाइलमी रेबेका कली लाइश्‍शा, आ होव़प आ खिं लेम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","मिनु इसहाक बेयर-लहाइ-रोइ माइश्‍शो ब्‍वाक्‍कु बुक्‍तीके रे पिमाक्‍त। मारदे हना दक्‍खिन रागी नेगेबम बाक्‍शो बाक्‍माक्‍त। उत्‍पत्ती १६:१४; उत्‍पत्ती २५:११ ");
INSERT INTO suzBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","मिनु नाक्‍नाक्‍दो रूमी हिरथ लमाक्‍त। मिनु कोव़ङानु, ङोन रे दलओंठपुकी पिशो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","मिनु रेबेकामी इसहाक कली तशा, दलओंठ रे फ्रु तोंइसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","मिनु अब्राहाम आ वाइल कली “मेरे इं कली ग्रुम्‍थ पीब मुर सु में?” दे हिल्‍लो पवा बाक्‍त। मिनु वाइलमी “आं होव़प बाक्‍ब” देंमाक्‍त। मेको नेंशा, रेबेकामी आ कुप्‍नीम कुल सुम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","मिनु वाइलमी इसहाक कली मार मार दुम्‍मे, मार मार पवा, नेल्‍ल शेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","मिनु इसहाकम रेबेका कली आ ममा सारा आ ताम्‍बुम ओंइदा बाक्‍त। मिनु नोले ग्‍युंबे पाम्‍से बाक्‍त। मिनु इसहाकम आ मीश कली दाक्‍ता बाक्‍त। मोपा इसहाक आ ममा बेक्‍शो प्रेंदा बाक्‍त। उत्‍पत्ती २३:१-२ ");
INSERT INTO suzBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","मिनु अब्राहामम अर्को मीश चाक्‍गा बाक्‍त। मेको आ नें केतुराह बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","मिनु मेकोमी अब्राहाम रे जिम्रान, योकशान, मेदान, मिदयान, इश्‍बाक नु शुआह थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","मिनु योकशानमी शेबा नु देदान थिम्‍सी बाक्‍त। देदान आ तौपुकी अश्‍शुरीम, लेतुशीम नु ले-उम्‍मीम बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिनु मिदयान आ तौ एफाह, एफेर, हनोक, अबीदा नु एल्‍दाह बाक्‍मा बाक्‍त। मेको नेल्‍ल केतुराह आ चच युइ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","मिनु अब्राहामम आ मार मार नेल्‍ल इसहाक कली गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","अब्राहाममी आ मबेक्‍थुन अर्को मीश आन तौ आन कली मार मार कोसेली गेमी बाक्‍त। मिनु आ तौ इसहाक रे फ्राशा, पूर्ब ङा रागीम बाक्‍मल, दे पूर्ब गे सोइक्‍तीमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","मिनु अब्राहाम नेल्‍ल पा सहे का ७५ बर्स ब्रोंइमाक्‍त। उत्‍पत्ती १२:४ ");
INSERT INTO suzBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","मिनु नोले शुश बर्स ङा खाल्‍पा दुम्‍शा बेक्‍शा, आ किकी पिपी नु लमाक्‍त। उत्‍पत्ती १५:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","मिनु इसहाक नु इश्‍माएल आ तौ निक्‍शीमी आ बेक्‍शो रां माक-पेला माइश्‍शो रू ङा पुक्‍खीमी लाइश्‍शा, वोदसे बाक्‍त। ङोंइती मेको रू सोहार आ तौ एफ्रोन आ रू बाक्‍माक्‍त। एफ्रोन हित्ती का बाक्‍माक्‍त। मेको रू माम्रे आ पूर्ब गे बाक्‍माक्‍त। उत्‍पत्ती २३:१३-२० ");
INSERT INTO suzBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","अब्राहाममी मेको रू हित्ती आ मुर रे ग्‍याप्‍शो बाक्‍माक्‍त। मेकेर ङोंइती आ मीश सारा कली नोले अब्राहाम कली वोदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","मिनु अब्राहाम बेक्‍म नोले परमप्रभुमी इसहाक कली आसीक गेवा बाक्‍त। मेना इसहाक बेयर-लहाइ-रोइ माइश्‍शोमी बाक्‍शो बाक्‍माक्‍त। उत्‍पत्ती १७:१९; उत्‍पत्ती २४:६२ ");
INSERT INTO suzBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","सारा आ वाइलीम इजीप्‍त ङा हागार रे जरमेशो अब्राहाम आ तौ इश्‍माएल बाक्‍माक्‍त। उत्‍पत्ती २१:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्‍माएल आ तौ सु सु बाक्‍मा बाक्‍त देंशा हना, आ ङोंइती जरमेशो तौ नेबायोथ बाक्‍माक्‍त। मिनु नोले थिशो आन नें केदार, अदबेल, मिब्‍साम, ");
INSERT INTO suzBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्‍मा, दुमा, मस्‍सा, ");
INSERT INTO suzBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हादाद, तेमा, येतुर, नाफीश नु केदमा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","एको इश्‍माएल आ तौ आन नें, आन बाक्‍तीके आन नें बाक्‍मा बाक्‍त। मेको नेल्‍ल आन थर ङा ठेयब मुर बाक्‍शो बाक्‍मा बाक्‍त। उत्‍पत्ती १७:२०; गन्‍ती १:४४ ");
INSERT INTO suzBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्‍माएल नेल्‍ल पा सहे का ३७ बर्स ब्रोंइमाक्‍त। मिनु बेक्‍शा, आ किकी पिपी नु लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","आ तौपुकी हवीलाह रे इजीप्‍त लतीक लां शुर सम्‍म बाक्‍शो बाक्‍मा बाक्‍त। शुर रागी इजीप्‍त आ ङोंइती अस्सुर गे बाक्‍ब। इश्‍माएल चहिं आ लोक्‍ब नेल्‍ल आन दातेमी बाक्‍माक्‍त। उत्‍पत्ती १६:१२ ");
INSERT INTO suzBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","इसहाक अब्राहाम आ तौ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाक ४० बर्स दुम्‍मेनु, रेबेका चाक्‍गा बाक्‍त। रेबेका चहिं अरामी पदान-अराममी बाक्‍ब बेथुएल आ तमी, लाबान आ समी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","मिनु इसहाकमी परमप्रभु यावे कली आ मीश आ पर्बम पुना बाक्‍त। मारदे हना आल मथीब बाक्‍माक्‍त। परमप्रभु यावेमी आ पुंइशो गेवा बाक्‍त। मिनु रेबेकामी कोव़ज कुरा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","मिनु आल निक्‍शी आ कोव़जम राम्‍शी पाम्‍से बाक्‍त। मिनु रेबेकामी “मुल ओदेंशो दुम्‍ती हना, मार दुम ङा? दोपा ब्रोंइनुङा ङा?” दे मिम्‍ता बाक्‍त। मिनु परमप्रभु यावे कली “मार दुम्‍नुङा?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","मिनु परमप्रभु यावेमी मेको कली “इ कोव़जम जात निक्‍शी ङा मुर बाक्‍नीसी। मेको जात निक्‍शी फ्राचा पुंइसीनीस। का अर्को क्‍येङा बोल्‍यो बाक्‍ब। ङोंइती जरमेशो चहिं कान्‍छा आ गेय पाइब दुम्‍ब” दे शेंदा बाक्‍त। उत्‍पत्ती २७:२९; मलाकी १:२; रोमी ९:१०-१२ ");
INSERT INTO suzBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","मिनु रेबेकामी आल थिमेनु, जौंले बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","मिनु ङोंइती ङा आ रांम वा फेक्‍शो खोदेंशो पा लल चां पाइश्‍शो वोंइश आल का थिमाक्‍त। मिनु मेको कली एसाव नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","मिनु नोले आ लोक्‍बमी आ लोक्‍ब आ गेंग्रे ग्‍याइश्‍शा ग्रूमाक्‍त। मोपतीके आ नें याकूब वोदा बाक्‍त। रेबेका आल थिची ना इसहाक ६० बर्स दुम्‍शो बाक्‍माक्‍त। होसे १२:४ ");
INSERT INTO suzBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","मिनु मेको तौ निक्‍शी कोल्‍सानु, एसाव जोक्‍ब सिखारी दुम्‍माक्‍त। नेल्‍ल नाक्‍त ब्‍वाकीम बाक्‍चा दाक्‍ता बाक्‍त। याकूब चहिं ताम्‍बुम बाक्‍ब नु रू ङा गेय पा, सिक्‍सी पा बाक्‍ब दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाकम एसाव कली दाक्‍ता बाक्‍त। मारदे हना आ चाक्‍शो सिखार ब्‍ववा बाक्‍त। रेबेकामी चहिं याकूब कली दाक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","मिनु काबु याकूबमी खोले क्‍येवानु, एसाव ब्‍वाकी रे शोव़लु बेक्‍शा जाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","मिनु एसावमी याकूब कली “इ क्‍येशो लल दाल खोले इच्‍का गेयी। गो शोव़लु बेक्‍ती” देंमाक्‍त। मोपतीके एसाव कली एदोम माइश्‍शो याइनी नें वोइश्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","मिनु याकूबमी “मुलाक्‍ती ङोंइती जरमेशो तौ इ आसीक आं कली गेयी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","मिनु एसावमी “मुल गो बेक्‍चता ङोंइती जरमेशो तौ आ तचा ङा आसीकम मार दुम्‍‍बा ङा?” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","मिनु याकूबमी “गो मुलाक्‍ती गेतन, दे कसम जावो” दे मदा बाक्‍त। मिनु एसावमी याकूब कली “ङोंइती जरमेशो तौ आं आसीक इ केन दुम्‍ल” दे कसम जवा बाक्‍त। उत्‍पत्ती २७:३६; हिब्रू १२:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","मिनु नोले याकूबमी एसाव कली शोब्‍ले नु दाल खोले ख्रेत्‍ता बाक्‍त। मिनु मेको जशा तूशा बोक्‍शा लमाक्‍त। मोपा एसावमी “ङोंइती जरमेशो तौ आ ततीक आसीक ममाल्‍नुङ” दे प्रोना बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","मिनु नोले रागीमी अन्‍काल दुम्‍माक्‍त। ङोंइती अब्राहाम बाक्‍मेनु यो, अन्‍काल दुम्‍शो बाक्‍माक्‍त। मिनु इसहाक पलिस्‍ती आन पिप अबीमेलेक आ रागी ङा गेरार सहर लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","मिनु परमप्रभु यावेमी इसहाक आ ङोंइती ग्रूमाक्‍त। मिनु इसहाक कली “इजीप्‍त रागी मलावो। आं देंशो रागीम बाक्‍थ लावो। ");
INSERT INTO suzBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","मेको रागीमी अर्को रागी ङा मुर दुम्‍शा बाक्‍को। गो गे नु बाक्‍शा, इ कली आसीक गेनुङ। गो इ कली नु इ चच युइ आन कली एको रागी नेल्‍ल गेनुङ। गो इ आफ अब्राहाम नु कबल पा, कसम जाता। मुल आं कबल खाप्‍नुङ। उत्‍पत्ती १७:१९; उत्‍पत्ती २२:१६-१७ ");
INSERT INTO suzBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","इ चच युइ आन कली सरीङ ङा सोरुल खोदेंशो पा शुश सेल्‍नुङ। मेको आन कली एको रागी नेल्‍ल गेनुङ। मिनु इ चच युइ आन पर्बम रागी रागी ङा मुर नेल्‍ल आसीक ताइनीम। ");
INSERT INTO suzBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","मारदे हना अब्राहामम आं देंशो टिशा, आ पचा माल्‍शो पाप्‍तु। आं शेंशो, आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आं अरेशो नेल्‍ल पाप्‍तु” दे मदा बाक्‍त। उत्‍पत्ती १५:५ ");
INSERT INTO suzBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","मिनु इसहाक गेरार सहर उइ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","मिनु अबीमेलेक आ मुरपुकीमी इसहाक कली आ मीश आ पर्बम लोव़ पामे बाक्‍त। मेकोमी चहिं “आं समी बाक्‍ब” दे लोव़ लेत्‍ता बाक्‍त। मारदे हना रेबेका शुश दारशो मीश मुर दुम्‍तीके “आं मीश बाक्‍ब” देंचा हिंमाक्‍त। मारदे हना “मेको कली तशा, लाइक्‍चा कली आ कली साइक्‍नीम” दे हिंशो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","मिनु इसहाक मेको रागीमी शुश बाक्‍शा, काबु पलिस्‍ती आन पिप अबीमेलेकमी झेल रे इसहाक नु आ मीश रेबेका चाल्‍शो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","मोपतीके अबीमेलेकमी इसहाक कली ब्रेश्‍शा “नेनो, एको थमा पा इ मीश बाक्‍ब। दोपा ‘आं समी बाक्‍ब’ देंने?” दे हुइक्‍ता बाक्‍त। मिनु इसहाकमी “एको आ पर्बम आं कली साइक्‍नीमी, कों, दे हिंती” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","मिनु अबीमेलेकमी “आंइ कली मार पवी? आं मुर का मेको नु इप्‍शो हना, गे आंइ कली शुश मरिम्‍शो मपपदी वा?” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","मिनु अबीमेलेकमी आ मुर नेल्‍ल आन कली “सुम मेको नु आ मीश आस कली मरिम्‍शो पाइबा, मेको थमा पा साइक्‍चा पुंइसीब” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","मिनु इसहाकमी मेको रागीमी मार मार शोक्‍शा, मेको बर्सम गेडा का के सहे का गेडा सम्‍म सिप्‍पाइश्‍शा ख्रेला बाक्‍त। मारदे हना परमप्रभु यावेमी इसहाक कली आसीक गेवा बाक्‍त। हितोपदेस १०:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","मिनु शुश शोंप पाइश्‍शो दुम्‍शा, दारना दारन शुश क्‍येट थीब दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","मेको आ क्‍यारश भेडा नु बी ब्‍यफ शुश दुम्‍मा बाक्‍त। मिनु वाइलीम वाइलपुकी यो शुश दुम्‍मा बाक्‍त। मोपतीके पलिस्‍तीपुकीमी गेहे पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","मिनु पलिस्‍तीपुकीमी अब्राहाम आ गेय पाइब आन दोशो इनार खपीम प्रिंशा, ब्‍वाक्‍कु तेक्गमे बाक्‍त। उत्‍पत्ती २१:२२-३४ ");
INSERT INTO suzBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","मिनु अबीमेलेकम इसहाक कली “आंइ क्‍येङा गे बोल्‍यो बाक्‍नीनी, मोपतीके एकेर रे लने” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","मिनु इसहाक नु आ मुरपुकी मेकेर रे लशा, गेरार ङा दिंममी जाक्‍दीश्‍शा, आन ताम्‍बु कीशा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","मिनु इसहाकमी ङोंइती अब्राहाम आ दोशो इनारपुकी, लेंशा दोपाइश्‍शा, ब्‍वाक्‍कु ग्रूपदा बाक्‍त। मारदे हना अब्राहाम बेक्‍म नोले पलिस्‍तीपुकीमी मेको इनार आन कली खपीम प्रिंशो बाक्‍मा बाक्‍त। मिनु मेको इनार आन कली आ आफ आ वोइश्‍शो नें लेंशा वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","मिनु इसहाक आ गेय पाइबपुकीमी मेको दिंममी दोशा, ब्‍वाक्‍कु बुक्‍तीके थित्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","मिनु गेरार ङा गोठलापुकीमी इसहाक आ गोठला आन कली “एको ब्‍वाक्‍कु आंइ के बाक्‍ब” दे जीमे बाक्‍त। मोपतीके इसहाकम मेको इनार कली एसेक नें वोदा बाक्‍त। मारदे हना मेकोपुकी आ मुर नु जीमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","मिनु लेंशा अर्को इनार का दोव़मे बाक्‍त। मेको आ पर्बम यो जीमे बाक्‍त। मेको कली सित्‍ना नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","नोले मेकेर रे लशा, अर्को इनार का दोव़मे बाक्‍त। मेको आ पर्बम सुइमी जिचा मपोक्‍गमे बाक्‍त। मिनु मेको आ नें रेहोबोथ वोदा बाक्‍त। मिनु “मुल परमप्रभु यावेमी आंइ कली बाक्‍तीक गेवा बाक्‍त। गोपुकी एको रागीमी शुश दुम्‍कल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","मिनु मेकेर रे लशा, बेयर-शेबा जाक्‍दीम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","मिनु मेको नाक्‍दो परमप्रभु यावे ग्रूशा “गो इ आफ अब्राहाम आ परमप्रभु नङ। महिनो। गो गे नु बाक्‍नुङ, इ कली आसीक गेनन। आं गेय पाइब अब्राहाम आ पर्बम गो इ चच युइ आन कली शुश सेल्‍नुङ” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","मिनु इसहाकम मेकेर चढ़ेतीक सेल्‍शा, परमप्रभु यावे आ नें थिशा ब्रेश्‍शा, मेको नु लोव़ पवा बाक्‍त। मिनु आ ताम्‍बु मेक उइ कीङा बाक्‍त। आ गेय पाइबपुकीमी मेकेर इनार का दोव़मे बाक्‍त। उत्‍पत्ती १२:८ ");
INSERT INTO suzBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","काबु अबीमेलेक, आ अर्ती गेब अहुज्‍जाथ नु आ फौज ङा ठेयब कप्‍तान फीकोल नु गेरार सहर रे जाक्‍शा, इसहाक कली ग्रुम्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","मिनु इसहाकमी “गेपुकी आं कली मदाक्‍थु, इन बाक्‍तीके रे सोइक्‍ताक्‍यीनी। मुल मारदे आं कली ग्रुम्‍थ जाक्‍नी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","मिनु मेकोपुकीमी “परमप्रभु यावे गे नु बाक्‍ब, गो तुइक्‍नीकी। मोपतीके गोपुकीमी ‘गे नु कसम जशा, कबल पचा’ रिम्‍शो दुम्‍ब। ब्‍यवस्‍था २९:३; मत्ती १३:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","गे आंइ कली श्‍येत मगेने। गोपुकीमी यो इन कली श्‍येत मगेथु, रिम्‍शो पा लडाइ मपथु सोइक्‍ताक्‍क। गे परमप्रभु यावे आ आसीक राइब बाक्‍नीनी” दे इसहाक कली देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","मिनु इसहाकम मेको आन कली भोज सेला बाक्‍त। मिनु मेकोपुकीम जामे, तूङमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","मिनु मेकोपुकी आ दीसा सुनी कना बोक्‍शा, कसम जामे बाक्‍त। मिनु नोले इसहाकमी मेको आन कली लचा गेवा बाक्‍त। मिनु आन थुं नाइश्‍शा लमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","मेको नाक्‍ती इसहाक आ गेय पाइबपुकी जाक्‍शा, इसहाक कली “आंइ दोतीकेमी ब्‍वाक्‍कु ग्रू‍त” दे शेंदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","मिनु मेको इनार कली शिबा नें वोदा बाक्‍त। मोपतीके मेको सहर आ नें मुल सम्‍म बेयर-शेबा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसाव ४० बर्स दुम्‍मेनु, हित्ती आ मुर बेयरी आ तमी युदीथ नु हित्ती आ मुर एलोन आ तमी बासेमाथ चाक्‍सी बाक्‍त। उत्‍पत्ती ३६:२-३ ");
INSERT INTO suzBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","मिनु मेको निक्‍शी आस पर्बम इसहाक नु रेबेका थुं मनुथु, शुश सुर्ता पाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","मिनु इसहाक खाल्‍पा दुम्‍शा, ब्राब्रा पा मिक्‍च मताइब दुम्‍माक्‍त। मिनु मेकोमी आ ङोंइती जरमेशो तौ एसाव कली “आं तौ” दे ब्रेत्‍ता बाक्‍त। मिनु एसावमी “मार देंनी?” दे लोव़ लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","मिनु इसहाकमी “नेनो, गो खाल्‍पा दुम्‍ती, आं बेक्‍ची ना मतुइक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इ लिब्रा लाइश्‍शा, सिखार ग्‍यारथ लावो। मिनु आं कली सिखार चाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मिनु नोले आं दाक्‍शो ब्रोव़ब्रोव़शो क्‍येशा, गेयी। गो आं बेक्‍चा क्‍येङा ङोंइती जशा ब्‍वशा, इ कली आसीक गेनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","मिनु रेबेकामी इसहाक नु एसाव लोव़ पशो नेंशो बाक्‍माक्‍त। मिनु एसाव ब्‍वाकी सिखार ग्‍यारथ लमेनु, ");
INSERT INTO suzBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रेबेकामी आ तौ याकूब कली “आं तौ नेनो, गो इ आफोमी एसाव कली लोव़ पशो नेंता। ");
INSERT INTO suzBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","मेकोमी एसाव कली ‘आं कली सिखार चाक्‍को। ब्रोव़शो क्‍येवो। गो जशा ब्‍वशा नोले परमप्रभु यावे आ ङोंइती आं बेक्‍चा क्‍येङा ङोंइती इ कली आसीक गेनुङ’ देंत। ");
INSERT INTO suzBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","मोपतीके आं तौ, आं देंशो टिवो। दोपा अरेना, मोपा पावो। ");
INSERT INTO suzBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","मुल गोठ लावो। क्‍यारश आन दाते रे रिम्‍शो पाठा निक्‍शी चाक्‍को। मिनु गो इ आफ कली आ दाक्‍शो ब्रोव़शो क्‍येनुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","मिनु गे चहिं लाइश्‍शा, इ आफ कली ख्रेत्‍तो। मेकोमी जशा ब्‍वशा, आ बेक्‍चा क्‍येङा ङोंइती इ कली आसीक गेवल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","मिनु याकूबम आ ममा कली “नेनीन, आं लोक्‍ब एसाव शुश चां पाइश्‍शो बाक्‍ब। गो मोदेंशो मनङ। उत्‍पत्ती २५:२५ ");
INSERT INTO suzBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","मिनु आं आफोम आं कली थिशा, तुइक्‍ब। मिनु गो जोल पाइब दुम्‍शा, आसीक मतथु, सराप राइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","मिनु आ ममामी “इ कली पशो सराप गो रङल, आं तौ। गे आं देंशो पावो। पाठा निक्‍शी ब्रथ लावो” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","मिनु याकूबम गोठ लशा, पाठा निक्‍शी चाक्‍शा, आ ममा कली गेवा बाक्‍त। मिनु आ ममामी आ आफ कली आ दाक्‍शो ब्रोव़शो श्‍ये क्‍येवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","मिनु रेबेकामी आ खिंमी वोइश्‍शो आ ङोंइती जरमेशो तौ एसाव आ नक वा लाइश्‍शा, आ कान्‍छा याकूब कली फेक्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","मिनु मेको पाठा आस कुशुल याकूब आ गुइ तारी नु आ शुर तारी क्‍येप्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","मिनु आ क्‍येशो ब्रोव़शो श्‍ये नु शोब्‍ले याकूब कली गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","मिनु याकूबम आ आफ बाक्‍तीके लशा, मेको कली “आं आफ” देंमाक्‍त। मिनु “गो बाक्‍ती। आं तौ, गे सु नवे” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूबम आ आफ कली “गो इन ङोंइती जरमेशो तौ, एसाव, नङ। इन पुंइशो गो पाता। बोक्‍शा निश्‍शा, आं सिखार ब्‍वने। मिनु आं कली आसीक गेयीनी” देंमाक्‍त। लेवी १९:१४ ");
INSERT INTO suzBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","मिनु इसहाकमी “गिश रीब पा पवी, आं तौ?” दे हिल्‍लो पवा बाक्‍त। मिनु “परमप्रभु यावे, इन परमप्रभुमी सिखार आं नेक्‍था चाक्‍तु” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","मिनु इसहाकम याकूब कली “आं नेक्‍था पिवो। इ कली थीनन, आं तौ। गे थमा पा, आं तौ एसाव नवे कों, मनवे” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","मिनु याकूब आ आफ आ नेक्‍था लमाक्‍त। इसहाकम मेको कली सुल्‍शा “आ सेंदा याकूब के बाक्‍‍त, आ गुइ चहिं एसाव के बाक्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","मिनु मेको कली मतुइक्‍ता बाक्‍त। मारदे हना आ गुइ एसाव खोदेंशो पा चां पाइश्‍शो बाक्‍माक्‍त। मोपतीके आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","मिनु “गे थमा पा आं तौ एसाव नवे?” दे हिल्‍लो पवानु “गो नङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","मिनु इसहाकम “लो, इ सेल्‍शो जचा ब्‍वचा थोव़क चाक्‍को। इ कली आसीक गेनन” देंमाक्‍त। मिनु याकूबमी चाक्‍गा बाक्‍त। मिनु आ आफोम ब्‍ववा बाक्‍त। मिनु याकूबमी अङगुर शांबु यो चाक्‍शा, गेवा बाक्‍त। मिनु मेको यो तूङा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","मिनु आ आफ इसहाकम “आं नेक्‍था पिवो, आं कली पुक्‍पु पावो, आं तौ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","मिनु आ नेक्‍था लशा, पुक्‍पु पवा बाक्‍त। इसहाकमी आ वा आ रिना नाम्‍शा, आसीक गेवा बाक्‍त। मिनु मेकोमी “आं तौ आ रिना परमप्रभु यावेमी आसीक गेशो रू आ रिना खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमप्रभुमी इ कली सरीङ ङा सीत रे नु रिम्‍शो खप रे शुश चेरब नु अङगुर शांबु गेवल। ");
INSERT INTO suzBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","मुरपुकीम इ कली गेय पामेक्‍ल। रागी रागी ङा मुरपुकी इ ङोंइती खुम्‍की पा बाम्‍मल। इ लोक्‍ब आन दातेमी गे ठेयब दुमो। इ ममा आ तौपुकी इ ङोंइती बाम्‍मल। सु सुम इ कली सराप पामे, मेको आंमान रमल। सु सुम इ कली आसीक गेमे, मेको आसीक रमल” दे आसीक गेवा बाक्‍त। उत्‍पत्ती २३:२५; उत्‍पत्ती १२:३ ");
INSERT INTO suzBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","मिनु इसहाकमी आसीक गेवा नोले, याकूब आ आफ आ बाक्‍तीक रे लमेनु, आ लोक्‍ब एसाव आ सिखार ग्‍यारतीक रे जाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","मेकोमी ब्रोव़शो श्‍ये क्‍येशा, आ आफ आ बाक्‍तीके जाक्‍शा, आ आफ कली “आं आफ बोक्‍कीन। आं सिखार ब्‍वशा, आं कली आसीक गेयीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","मिनु आ आफ, इसहाकमी मेको कली “गे सु नवे?” दे हिल्‍लो पवानु “गो इन ङोंइती जरमेशो तौ, एसाव नङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","मिनु इसहाक शुश ख्रिंख्रि पा “सुमी आं कली सिखार चाक्‍गा? इ जाक्‍चा क्‍येङा ङोंइती गो जाता। मिनु आसीक गेता। आं आसीक लीब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","मिनु एसाव आ आफ आ लोव़ नेंशा, ठेयब सेंदा पा ङाक्‍माक्‍त। मिनु आ आफ कली “आं आफ, आं कली यो आसीक गेयीनी” देंमाक्‍त। हिब्रू १२:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","मिनु “इ लोक्‍ब जाक्‍शा, जोल पशा, इ आसीक रोइक्‍ताक्‍व” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","मिनु एसावमी “आ नें याकूब दुम्‍शो, ठीक बाक्‍ब। मुल आं कली निक्‍शी खेयप ठगेती। आं ङोंइती जरमेशो तौ आ अधिकार रोइक्‍ताक्‍यी। मुल आं आसीक यो लाइक्‍तु। गे आं कली आसीक महेंदीनी?” दे ङाक्‍शा, देंमाक्‍त। उत्‍पत्ती २५:२६; उत्‍पत्ती २५:३३ ");
INSERT INTO suzBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","मिनु इसहाकम एसाव कली “नेनो, गो मेको कली इ प्रभु सेल्‍ता। आ लोक्‍ब नेल्‍ल आन कली मेको आ गेय पाइब सेल्‍ता। चेरब नु अङगुर शांबु शुश ग्रेल्मल, दे लोव़ पाता। मिनु इ कली मार गेनना ङा, आं तौ?” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","मिनु एसावमी आ आफ कली “इन के आसीक का ला बाक्‍बा ङा, आं आफ? आं कली यो आसीक गेयीनी” दे शुश ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","मिनु आ आफ इसहाकम “नेनो, मलिलो खप नु सरीङ ङा सीत इ बाक्‍तीक रे ङोन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","इ तरवारम इ गेय पाइनेवे। इ लोक्‍ब कली गेय पाइनेवे। २राजा ८:२०,२२ गे बोल्‍यो दुम्‍ते हना, आ जुवा इ शुर रे ताइक्‍नेवे” दे एसाव कली यो आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","मिनु एसावमी आ आफोम याकूब कली गेशो आसीक लोव़ आ पर्बम, याकूब कली काइ मदाक्‍ता बाक्‍त। आ थुंमी “आं आफ बेक्‍शा रोंका पने थुम्‍शो नोले, आं लोक्‍ब याकूब कली साइक्‍नुङ” दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","मिनु रेबेकामी आ तौ आ लोव़ नेना बाक्‍त। मिनु मेकोमी याकूब कली ब्रेश्‍शा “नेनो, इ लोक्‍बमी इ कली साइक्‍चा कली मिम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","मोपतीके आं तौ, गे आं देंशो पावो। बोक्‍को, आं लोक्‍ब लाबान आ बाक्‍तीके, हारान सहर प्रोक्‍को। उत्‍पत्ती २४:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","इ लोक्‍ब आ गाइश्‍शो मनांइसे सम्‍म मेक उइ बाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","मिनु इ लोक्‍बमी इ पशो प्रेंशा, मचुरत हना, गो इ कली ब्रथ सोइक्‍नुङ। गो दोपा नाक्‍त कामी आं मुर निक्‍शी जाम्‍शो तने चाप्‍नुङ ङा?” दे आ तौ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","मिनु रेबेकामी इसहाक कली “गो हित्ती आ तमी आस पर्बम बेक्‍चा ङा दुम्‍ती। याकूबमी यो एको खोदेंशो पा एको रागी ङा हित्ती आ तमी का चाक्‍तु हना, गो ब्रोंइचा मदाक्‍नुङ” दे मदा बाक्‍त। उत्‍पत्ती २६:३४-३५ ");
INSERT INTO suzBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","मिनु नोले इसहाकमी याकूब कली अरेशा “गे कनान रागी ङा मीश आल मचाक्‍को। उत्‍पत्ती २४:३ ");
INSERT INTO suzBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","साशा, पदान-अराम इम्‍मा आ आफ बेथुएल आ खिं लावो। मिनु इम्‍मा आ लोक्‍ब लाबान आ तमी का चाक्‍को। उत्‍पत्ती २२:२३; उत्‍पत्ती २४:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","मिनु नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभुमी इ कली आसीक गेवल। मिनु इ कली सोशा बोशा, शुश सेलल। हिक्‍ने मचाप्‍चा ङा पा शुश दुम्‍पदल। ");
INSERT INTO suzBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","अब्राहाम कली गेशो आसीक मुल इ कली नु इ चच युइ आन कली गेव‍ल। इ मुल बाक्‍शो रागीम अर्को रागी ङा मुर बाक्‍ते, तन्‍न परमप्रभुमी अब्राहाम कली गेप्‍तु। मेको इ कली दुम्‍ल” दे आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","मोदेंशो पा इसहाकमी याकूब कली पदान-अराम ङा मुर बेथुएल आ तौ आ खिं सोइक्‍ता बाक्‍त। मेको याकूब नु एसाव आस ममा आ लोक्‍ब लाबान बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","मिनु एसावमी, इसहाकम याकूब कली आसीक गेशा, मीश चाक्‍चा कली पदान-अराम गे सोइश्‍शो तुइश्‍शा, आ आफ आ अरेशो “कनान रागी ङा तमी मचाक्‍को” दे माइश्‍शो तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","याकूबमी आम आफ आस कली टिशा, पदान-अराम गे लशो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","मिनु एसावम कनान रागी ङा तमीपुकी आ आफ इसहाकम मदाक्‍शो तुइश्‍शा, ");
INSERT INTO suzBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","इश्‍माएल आ बाक्‍तीके लमाक्‍त। मिनु मीश निक्‍शी बाक्‍शा यो, अब्राहाम आ तौ इश्‍माएल आ तमी नेबायोथ आ समी महलाथ चाक्‍गा बाक्‍त। उत्‍पत्ती १६:१६; उत्‍पत्ती २६:३४; उत्‍पत्ती २५:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","मिनु याकूब बेयर-शेबा रे गाक्‍शा, हारान सहर गे लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","मिनु बाक्‍तीके का जाक्‍दीश्‍शा, नाक्‍दो मेकेर बाक्‍माक्‍त। मारदे हना नां रिक्‍माक्‍त। मिनु फुल्‍लु तार आ पिया वोइश्‍शा इम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","मिनु इम्‍मेनु, ङोमुम खप रे सरीङ थिशो क्रेसी का तवा बाक्‍त। मेको क्रेसीमी परमप्रभु आ स्‍वर्ग ङा गेय पाइबपुकी तोइश्‍शो, ङोइश्‍शो तवा बाक्‍त। यूहन्‍ना १:५१ ");
INSERT INTO suzBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","मिनु क्रेसी आ ङरम परमप्रभु यावे राप्‍शा, याकूब कली “गो परमप्रभु यावे, इ बाजे अब्राहाम नु इ आफ इसहाक आस परमप्रभु नङ। मुल इ इप्‍शा बाक्‍तीक रागी इ कली नु इ चच युइ आन कली गेनन्‍नी। ");
INSERT INTO suzBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","इ चच युइ खप ङा फुरक खोदेंशो पा शुश दुम्‍नीम। सोशा बोशा, शुश दुम्‍शा, पूर्ब, पच्‍छिम, उत्तर, दक्‍खिनम ब्रशा बाक्‍नीमी। गे नु इ चच युइ आन पर्बम रागी नेल्‍ल ङा मुर आसीक ताइनीम। उत्‍पत्ती १३:१४-१५ ");
INSERT INTO suzBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","गो गे नु बाक्‍शा, ते लाइनेवे, गो इ कली कोव़नन। गो इ कली एको रागी लेप्‍पाइक्‍नन। मारदे हना गो इ कली मप्रोंइनन। इ कली मार मार देंङा, गो मेको नेल्‍ल पाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","मिनु याकूब आ निन्‍द्रा रे सेंसीशा “परमप्रभु यावे थमा पा एकेर बाक्‍ब। गो मतुइक्‍तु” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","मिनु हिंशा “एको हिंचा ङा बाक्‍तीके बाक्‍ब। परमप्रभु आ बाक्‍तीक खिं बाक्‍शा, सरीङ ङा लाप्‍चो बाक्‍ब” देंमाक्‍त। प्रस्‍थान ३:५ ");
INSERT INTO suzBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","मिनु याकूब सुनी कना बोक्‍शा, आ पिया आगा ङा वोइश्‍शो फुल्‍लु राप्‍पाइश्‍शा तेल लुक्‍ता बाक्‍त। उत्‍पत्ती ३५:१४-१५ ");
INSERT INTO suzBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","मिनु मेको बाक्‍तीके कली बेथेल नें वोदा बाक्‍त। ङोंइती मेको सहर आ नें लूज बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","मिनु याकूबमी “परमप्रभु गो नु बाक्‍त हना, लां कोंइशा कोव़ती हना, जचा नु फेक्‍चा यो गेती हना, ");
INSERT INTO suzBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","थुं नाइश्‍शा, आं आफ आ खिं लेत्‍चा गेती हना, परमप्रभु यावे आं परमप्रभु बाक्‍ब” दे कसम जवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","मिनु परमप्रभु कली “आं राप्‍पाइश्‍शा वोइश्‍शो फुल्‍लु परमप्रभु आ खिं दुम्‍ल। आं कली मार मार गेनी, मेको के १० भागमी भाग का थमा पा इन कली गेनन्‍नी” देंमाक्‍त। उत्‍पत्ती ३५:१ ");
INSERT INTO suzBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","मिनु याकूब लमे लमे, पूर्ब ङा मुर आन रागी जाक्‍दीम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","मिनु कोव़ङानु, दिंम कामी इनार का तवा बाक्‍त। हुल सां भेडा मेकेर बाक्‍शो बाक्‍मा बाक्‍‍त। मारदे हना मेको आन कली मेको इनार ङा ब्‍वाक्‍कु तुंइबाक्‍मा बाक्‍त। मेको इनार चहिं ठेयब फुल्‍लुमी सुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","मिनु भेडा आन हुल नेल्‍ल मेकेर खुम्‍सी‍शा, गोठलापुकीमी मेको इनार ङा फुल्‍लु क्‍युक्‍शा, भेडा आन कली ब्‍वाक्‍कु तुंइशा, नोले लेंशा इनार सुम्‍शा वोइक्‍बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","मिनु याकूबमी मेको भेडा गोठला आन कली “आं लोक्‍बपुकी गे ते ङा बाक्‍नीनी?” दे हिल्‍लो पवा बाक्‍त। मिनु मेकोपुकीमी “हारान ङा बाक्‍नीकी” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","मिनु याकूबमी “गे नाहोर आ तौ लाबान तुइक्‍नीनी?” दे हिल्‍लो पवा बाक्‍त। मिनु “गो तुइक्‍नीकी” दे लोव़ लेत्‍मे बाक्‍त। उत्‍पत्ती २४:१०,२४ ");
INSERT INTO suzBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","याकूबमी “रिम्‍शो बाक्‍मे?” दे हिल्‍लो पवानु, मेकोपुकीमी “रिम्‍शो बाक्‍ब। हयु आ तमी राहेल आ भेडा नु जाक्‍त” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","मिनु याकूबमी “चोक्‍ची मजाक्‍शो, भेडा आन कली ब्‍वाक्‍कु तुंइशा, जोपाइक्‍थ लतीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","मिनु मेकोपुकीमी “हुल नेल्‍ल मखुम्‍सीथु, इनार ङा फुल्‍लु मयाक्‍थु, भेडा आन कली ब्‍वाक्‍कु तुंइने मचाप्‍नीकी” दे लोव़ लेत्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","मिनु याकूब मेकोपुकी नु लोव़ पवा सम्‍म, राहेल आ आफ आ भेडा नु जाक्‍माक्‍त। मेको गोठाल्‍नी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","मिनु याकूबमी आ मामा, लाबान आ तमी राहेल तवा बाक्‍त। मिनु मेको कली ग्रुम्‍थ लशा, इनार ङा फुल्‍लु याक्‍ता बाक्‍त। मिनु आ मामा आ भेडा आन कली ब्‍वाक्‍कु तुंइदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","मिनु राहेल कली चुप पाइश्‍शा ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","राहेल कली “गो इ आफ आ बहिनी रेबेका आ तौ नङ” देंमाक्‍त। मिनु राहेल दोरशा लशा, आ आफ कली मेको लोव़ शेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","मिनु लाबानमी आ भानीच याकूब जाक्‍शो लोव़ नेंशा, दोरशा मेको कली ग्रुम्‍थ जाक्‍माक्‍त। मिनु मुप्‍शा, पुक्‍पु पा, आ खिं लदा बाक्‍त। मिनु याकूबमी लाबान कली शुश लोव़ शोव़ङा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","मिनु लाबानमी “गे थमा पा आं खिं ङा मुर बाक्‍नेवे” देंमाक्‍त। मिनु याकूब महिना का खोदेंशो मेकेर बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","मिनु लाबानमी याकूब कली “गे आं खिं ङा मुर बाक्‍ते हना यो, आं कली मो गेय पचा ममाल्‍नेवे। मार पुंइनेवे, देनो” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान आ तमी निक्‍शी बाक्‍सा बाक्‍त। आ ङोंइती जरमेशो आ नें लेआ नु कान्‍छी आ नें राहेल बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआ मदारशो बाक्‍माक्‍त। राहेल चहिं शुश दारशो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूबम राहेल कली दाक्‍ता बाक्‍त। मिनु लाबान कली “इन कान्‍छी तमी राहेल आ पर्बम गो इन कली ७ बर्स गेय पाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","मिनु लाबानमी “अर्को मुर कली गेचा क्‍येङा इ कली गेचा रिम्‍शो बाक्‍ब। गो नु गेय पा बाक्‍को” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","मिनु याकूबम राहेल आ पर्बम ७ बर्स गेय पवा बाक्‍त। मेको ७ बर्स याकूब कली नाक्‍त का निक्‍शी खोदेंशो पा लमाक्‍त। मारदे हना राहेल कली शुश दाक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","मिनु याकूबमी लाबान कली “आं मीश गेयीनी। ७ बर्स दुम्‍माक्‍त। मेको नु ग्युंबे पाइनुङ” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","मिनु लाबानमी सहर ङा मुर नेल्‍ल ब्रेश्‍शा, भोज गेमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","मिनु नाक्‍नाक्‍दो लाबानमी आ तमी लेआ लाइश्‍शा, याकूब कली गेवा बाक्‍त। मिनु याकूब मेको नु इम्‍‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबानमी आ तमी लेआ कली आ गेय पाइब वाइलीम जिल्‍पा गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","मिनु याकूब सुनी कना बोक्‍शा, आ मीश कोव़ङानु, लेआ बाक्‍माक्‍त। मिनु गाइश्‍शा लाबान कली “गे आं कली मार पनी? गो इन कली राहेल आ पर्बम गेय मपङा ङा? मारदे आं कली ठगेनी?” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","मिनु लाबानमी “आंइ रागीमी जेठी क्‍येङा ङोंइती कान्‍छी मगेनीकी। ");
INSERT INTO suzBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","हप्‍ता का मेको नु बाक्‍को। नोले गो इ कली अर्को यो गेनन। गे अर्को ७ बर्स गेय पचा माल्‍नेवे” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","मिनु याकूब मेको बिश्‍शा, लेआ नु हप्‍ता का बाक्‍माक्‍त। मिनु नोले लाबानमी राहेल कली यो गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबानमी आ तमी राहेल कली आ गेय पाइब वाइलीम बिल्‍हाह गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","मिनु याकूबम राहेल कली यो चाक्‍गा बाक्‍त। मिनु लेआ क्‍येङा राहेल कली शुश दाक्‍ता बाक्‍त। मिनु लाबान कली अर्को ७ बर्स गेय पवा बाक्‍त। लेवी १८:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","मिनु परमप्रभु यावेमी याकूबमी लेआ कली मदाक्‍शो तशा “आल थीब दुम्‍ल” दे आसीक गेवा बाक्‍त। तन्‍न राहेल आल मथीब बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","मिनु लेआ कोव़ज कुरशा, तौ का थि‍माक्‍त। मेको आ नें रूबेन वोदा बाक्‍त। मारदे हना “परमप्रभु यावेमी आं श्‍येत ताप्‍तु। मुल रे आं वोंइशेम आं कली दाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","मिनु लेंशा कोव़ज कुरशा, तौ का नु थि‍माक्‍त। मिनु “परमप्रभु यावेमी आं कली मदाक्‍शो तशा, अर्को तौ का यो गेती” देंशा, मेको आ नें सिमियोन वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","मिनु लेंशा कोव़ज कुरशा, अर्को तौ का थि‍माक्‍त। मिनु “मुल रे आं वोंइश गो नु बाक्‍ब। मारदे हना गो तौ सां थीतामी” देंमाक्‍त। मोपतीके आ नें लेवी वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","मिनु लेंशा कोव़ज कुरशा, तौ का नु थि‍माक्‍त। मिनु “गो परमप्रभु यावे कली ठेयब सेल्‍नुङ” दे मेको कली यहूदा नें वोदा बाक्‍त। मिनु आल थिचा नांइसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","मिनु राहेलमी “आल मथीब बाक्‍ङा बाक्‍त” दे तुइश्‍शा, आ लोक्‍ब कली गेहे पवा बाक्‍त। मिनु याकूब कली “गे आं कली आल मगेतीनी हना, गो बेक्‍नुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","मिनु याकूबमी राहेल आ लोव़ आ पर्बम गाइश्‍शा “परमप्रभुमी इ कली आल मथीब सेल्‍तु। गो मेको क्‍येङा ठेयब नङा ङा?” देंमाक्‍त। भजन संग्रह १२७:३ ");
INSERT INTO suzBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","मिनु राहेलमी “गो इन कली आं गेय पाइब बिल्‍हाह गेनुङ। मेकोमी आं कली आल थिचा माल्‍ब। मिनु आं के आल दुम्‍मल” देंमाक्‍त। उत्‍पत्ती १६:२ ");
INSERT INTO suzBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","मिनु मेकोमी याकूब कली आ गेय पाइब बिल्‍हाह गेवा बाक्‍त। मिनु याकूब मेको नु इम्‍‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","मिनु बिल्‍हाह कोव़ज कुरशा, तौ का थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","मिनु राहेलमी “परमप्रभुमी आं कली नाक्‍शा, आं पुंइशो नेंतु। मिनु आं कली तौ का गेती” देंमाक्‍त। मोपतीके आ नें दान वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","मिनु राहेल आ गेय पाइब बिल्‍हाहमी लेंशा कोव़ज कुरशा, अर्को तौ का थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","मिनु राहेलमी “गो आं लोक्‍ब नु परमप्रभु खोदेंशो पा जिशा ग्राती” देंमाक्‍त। मोपतीके मेको आ नें नाप्‍ताली वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","मिनु लेआमी “लेंशा आल मथीनुङ” दे मिम्‍शा, याकूब कली आ गेय पाइब जिल्‍पा गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","मिनु लेआ आ गेय पाइब जिल्‍पामी तौ का थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","मिनु लेआमी “रिम्‍शो दुम्‍त” दे आ नें गाद वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","मिनु लेआ आ गेय पाइब जिल्‍पामी अर्को तौ का नु थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","मिनु लेआमी “गो ग्‍येरसाक्‍यी। मारदे हना मीश मुरपुकीमी आं पर्बम ‘आसीक राइब बाक्‍ब’ देंनीम” देंमाक्‍त। मिनु आ तौ कली आशेर नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","मिनु काबु रूबेनमी चेरब रिक्‍ची ना आल थिपाइक्‍ब फल थिदा बाक्‍त। मिनु आ ममा लेआ कली गेवा बाक्‍त। मिनु राहेलमी लेआ कली “इ तौ आ चाक्‍शो फल आं कली का निक्‍शी गेयी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","मिनु मेकोमी “गे आं वोंइश आ थुं रोइक्‍चा ला ममाइ, आं तौमी चाक्‍शो फल यो रोइक्‍नेवे?” देंमाक्‍त। मिनु राहेलमी “इ तौ आ फल आ पर्बम मुलाक्‍दो याकूब इ खिंम बाक्‍ल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","मिनु नाक्‍नाक्‍दो याकूब रू रे जाक्‍मेनु, लेआम ग्रुम्‍थ लशा “गे आं खिंम बाक्‍चा माल्‍नीनी। गो आं तौ आ चाक्‍शो फल इन पर्बम थाप्‍ताक्‍ङ” देंमाक्‍त। मिनु मेको नाक्‍दो याकूब लेआ नु इम्‍‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","मिनु परमप्रभुमी लेआ आ पुंइशो गेवा बाक्‍त। मिनु याकूब के ४ जना तौ थिशा नोले अर्को तौ का नु थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","मिनु लेआमी “परमप्रभुमी आं कली रिम्‍शो पाप्‍तु। मारदे हना गो आं गेय पाइब आं वोंइश कली गेता” देंमाक्‍त। मिनु आ नें इस्‍साकार वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","मिनु लेंशा कोव़ज कुरा बाक्‍त। मिनु ५ जना तौ थिशा यो, अर्को तौ का नु थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","मिनु “परमप्रभुमी आं कली रिम्‍शो पाप्‍‍तु। मुल आं वोंइश गो नु बाक्‍ब। मारदे हना गो ६ जना तौ थीतामी” देंमाक्‍त। मिनु मेको कली जबूलून नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","मिनु नोले तमी का यो थि‍माक्‍त। मेको कली दीना नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","नोले परमप्रभुमी राहेल कली मिम्‍ता बाक्‍त। मिनु आ पुंइशो गेशा, आल थीब दुम्‍माक्‍त। १सामुएल १:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","मिनु कोव़ज कुरशा, तौ का थि‍माक्‍त। मिनु “परमप्रभुमी श्‍येत रे प्रोंइती” देंमाक्‍त। यसैया ४:१; लूका १:२५ ");
INSERT INTO suzBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","मोपतीके आ नें योसेफ वोदा बाक्‍त। मिनु “परमप्रभु यावेमी आं कली अर्को तौ का नु गेयील” दे पुना बाक्‍त। उत्‍पत्ती ३५:१७-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","मिनु राहेलमी योसेफ थिशा नोले याकूबमी लाबान कली “आं कली लचा गेयीनी। गो आं रागी, आं खिं लचा दाक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","आं मीशपुकी, आं आलपुकी नु आं कली लचा गेकी। गो एको तचा कली इन गेय पाता। गो इन कली दोदेंशो रिम्‍शो गेय पङा, मेको गे तुइक्‍नीनी” देंमाक्‍त। उत्‍पत्ती २९:२०,३०; उत्‍पत्ती ३१:४३ ");
INSERT INTO suzBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","मिनु लाबानमी “गे आं कली दाक्‍नेवे हना, इच्‍का नु बाक्‍को। मारदे हना गे एक बाक्‍शा, परमप्रभु यावेमी इ गेय पतीके आं कली आसीक गेती, दे तुइक्‍नुङ। उत्‍पत्ती ३९:५ ");
INSERT INTO suzBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","गे मार माल्‍नेवे, मेको इ कली गेनुङ” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","मिनु याकूबमी “गो दोदेंशो गेय पङा, इन बी ब्‍यफ गिश दुम्‍मा, गे तुइक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","आं जाक्‍ची ना का निक्‍शी बाक्‍तेक्‍मे, मुल शुश दुम्‍तेक्‍म। मिनु गो जाक्‍ङा रे परमप्रभु यावेमी इन कली आसीक गेप्‍तु। मिनु आं खिं गेना कोव़नुङा?” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","मिनु लाबानमी “गो मार गेचा माल्‍नुङा?” देंमेनु, याकूबमी “आं कली मारेइ गेचा ममाल्‍नीनी। आं देंशो पाइतीनी हना, गो लेंशा इन गोठला दुम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","गो मुलाक्‍ती इन क्‍यारश भेडा नेल्‍ल कोव़थ लाइनुङ। मिनु पुत्‍ले पाङग्रे नेल्‍ल ग्रुंइनुङ। क्‍यारश भेडा रे यो क्‍येर नु पुत्‍ले पाङग्रे ग्रुंइनुङ। मेको आं गाल्‍च दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","मोदेंशो दुम्‍मेनु, आं ठीक पतीके तुइक्‍नीनी। तेको क्‍यारश आन दातेमी पुत्‍ले पाङग्रे मपाइश्‍शो नु पाठा आन दातेमी क्‍येर मबाक्‍मा, मेको आं खुइ पशो, दे तुइक्‍नीनी” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","मिनु लाबानमी “इ देंशो खोदेंशो दुम्‍ल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","मिनु मेको नाक्‍ती लाबानमी गोठ नेल्‍ल रे टाटे पाङग्रे क्‍यारश बोका नेल्‍ल नु पुत्‍ले पाङग्रे भेडा सांड ग्रुंइदा बाक्‍त। तेक तेको इच्‍का बुश नु क्‍येर बाक्‍मा, मेको योव़शा, आ तौ आन गुइमी गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","मिनु आ तौ आन गोठ नु याकूब आ गोठ नाक्‍त सां गाक्‍तीक लां ङोन वोदा बाक्‍त। याकूबम चहिं लाबान आ अरु क्‍यारश भेडा कोव़ङा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","मिनु याकूबमी ब्‍वाकीम पिपल, कटुस नु अर्को रवा आन क्‍येख राशी जिक्‍शा, बुश रेखा ग्रुंइशा खेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","मिनु मेको कोक्‍केपुकी क्‍यारश नु भेडा आन ब्‍वाक्‍कु तूतीकेमी वोदा बाक्‍त। मिनु ब्‍वाक्‍कु तूशा ङा मिन ब्‍वांइ‍सीमानु, ");
INSERT INTO suzBl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","मेको आ टाटे पाङग्रे कोक्‍के तशा, टाटे पाङग्रे पाठापुकी जरमेसीमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूबमी मेको पाठा आन कली ग्रुंइशा फ्राशा आंम बगाल ङा गोठ सेला बाक्‍त। आंम क्‍यारश भेडा लाबान आ गोठम मवोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","मिनु गेना बोल्‍यो नु रिम्‍शो बोकापुकी माल्‍ची ना बाक्‍मा नु ब्‍वाक्‍कु तूथ जाक्‍मा, मेना मेको कोक्‍केपुकी तूतीकेमी आन ङोंइती वोदा बाक्‍त। मिनु “कोक्‍के आन ङोंइती ब्‍वांइ‍सीमल” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","बगाल ङा मरिम्‍शो क्‍यारश भेडा जाक्‍तेक्‍म हना, कोक्‍के मवोदा बाक्‍त। मोदेंशो पा मरिम्‍शो क्‍‍यारश भेडा लाबान कली, रिम्‍शो बोल्‍यो चहिं याकूब के दुम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","मिनु याकूब शुश शोंप पाइश्‍शो दुम्‍शा, क्‍यारश भेडा, वाइलीम वाइल, दलओंठपुकी नु गधा शुश पाइश्‍शो दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","मिनु लाबान आ तौपुकीमी “याकूबमी आंइ आफ आ मारेइ मारेइ नेल्‍ल रोइक्‍ताक्‍व। आंइ आफ आ शोंप रे शोंप पाइश्‍शो दुम्‍त” देंशो, याकूबमी नेना बाक्‍त। उत्‍पत्ती ३०:३५ ");
INSERT INTO suzBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","मिनु याकूबमी “लाबानम आं कली मदाक्‍ब दुम्‍त” दे तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","मिनु परमप्रभु यावेमी याकूब कली “इ आफ आ रागी इ मुर आन बाक्‍तीक लेश्‍शा लावो। गो गे नु बाक्‍नुङ” देंमाक्‍त। उत्‍पत्ती २८:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","मिनु याकूबमी राहेल नु लेआ आस कली गोठीम ब्रेत्‍तीम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","मिनु मेको आस कली “इस आफोम ङोंइती आं कली दाक्‍शो खोदेंशो पा मुल मदाक्‍ब, दे तुइक्‍ताक्‍ङ। आं आफ आ परमप्रभु गो नु बाक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","गो इस आफ कली दोदेंशो पा आं बोल नेल्‍लेमी गेय पङा, मेको गे निक्‍शीम तुइक्‍नीसी। ");
INSERT INTO suzBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","इस आफोमी आं कली ठगेप्‍तु। आं गेय ङा तचा माल्‍शो थोव़क १० खेयप फाइक्‍तु। तन्‍न परमप्रभुमी मेको कली आं कली श्‍येत गेचा, मगेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","इस आफोमी ‘पुत्‍ले पाङग्रे नेल्‍ल इ के दुम्‍ल’ देंमेनु, क्‍यारश भेडा नेल्‍लेमी पुत्‍ले पाङग्रे गिक्‍तेक्‍म। मेकोमी ‘रेखा पाइश्‍शो नेल्‍ल इ के दुम्‍ल’ देंमेनु, नेल्‍ल रेखा पाइश्‍शो गिक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","मोदेंशो पा परमप्रभुमी इस आफ आ क्‍यारश भेडा बी ब्‍यफ रोइश्‍शा, आं कली गेती। ");
INSERT INTO suzBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","क्‍यारश भेडा आन ब्‍वांइ‍सीची ना गो ङोमुमी बोका नेल्‍ल पुत्‍ले पाङग्रे, रेखा पाइश्‍शो नु खाल्‍शो रङ ङा तातामी। ");
INSERT INTO suzBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","मिनु परमप्रभु आ स्‍वर्ग ङा गेय पाइबमी आं कली ङोमुमी ‘याकूब’ दे ब्रेत्‍ताक्‍यी। ‘मिनु गो बाक्‍ती’ दे लोव़ लेत्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","मिनु मेकोमी आं कली ‘कोव़ङो, ब्‍वांइसीब बोका नेल्‍ल पुत्‍ले पाङग्रे, रेखा पाइश्‍शो नु खाल्‍शो रङ ङा बाक्‍नीम। मारदे हना लाबानमी इ कली मार पशो बाक्‍बा, गो नेल्‍ल ताता। ");
INSERT INTO suzBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","गो परमप्रभु नङ। गो इ कली बेथेलम ग्रुम्‍ता। गे मेकेर फुल्‍लु का कली तेल लुक्‍ताक्‍वी। मिनु आं कली कसम जाप्‍तीवी। मुल बोक्‍को, मेको रागी रे ग्रूङो। इ जरमेशो रागी ले‍तो’ दे माइक्‍ती” दे आ मीश निक्‍शी आस कली देंमाक्‍त। उत्‍पत्ती २८:१८-२२ ");
INSERT INTO suzBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","मिनु राहेल नु लेआमी “आंस आफ आ खिंमी आस थेरशो रू नु शोंप बाक्‍मा ङा? ");
INSERT INTO suzBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","आंस कली अर्को रागी ङा मुर खोदेंशो सेल्‍शा, लेयशा ताक्‍शो नेल्‍ल जाप्‍तु। उत्‍पत्ती २९:१८,२७ ");
INSERT INTO suzBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","परमप्रभुमी आंस आफ रे लाइश्‍शो शोंप, आंस कली नु आंस आल के दुम्‍त। परमप्रभुमी इन कली मार देंबा, मेकोन पने” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","मिनु याकूब सुनी कना बोक्‍शा, आ आलपुकी नु आ मीशपुकी दलओंठ तारी ङोइक्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","मिनु मारेइ मारेइ पदान-अराम रे आ गेय पा सेल्‍शो बस्‍तु भाव नेल्‍ल खुल्‍शा, आ शोंप लाइश्‍शा, आ आफ इसहाक आ खिं कनान रागी लचा गोवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान आ भेडा आन ऊन ख्रोइक्‍थ लशो बाक्‍माक्‍त। मेना राहेलमी आ आफ आ खिं ङा मूर्तिपुकी खुइ पा कुरा बाक्‍त। न्‍यायाधीस १७:५; न्‍यायाधीस १८:१७; १सामुएल १९:१३; २राजा २३:२४; जकरिया १०:२ ");
INSERT INTO suzBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकूबमी अरामी लाबान कली “गो लशो” दे मदेंथु, गाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","मोदेंशो पा याकूब आ मारेइ मारेइ कुरशा, प्रोक्‍माक्‍त। मिनु सुनी बोक्‍शा, युफ्रेटीस खोला शोक्‍समा बाक्‍त। मिनु गिलाद डांडा गे लमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","मिनु लमा आ नाक्‍त सां नोले मुरुमी “याकूब प्रोक्‍त” दे लाबान कली शेंदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","मिनु लाबानमी आ लोक्‍ब आन कली ब्रेश्‍शा, मेकोपुकी नु ७ नाक्‍ती सम्‍म याकूब कली माल्‍शा, गिलाद डांडाम ग्रुमा बाक्‍त। उत्‍पत्ती ३१:४७ ");
INSERT INTO suzBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","मिनु परमप्रभुमी अरामी लाबान कली ङोमुमी “गे होस पावो। याकूब कली मारेइ मपावो” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","मिनु लाबानमी याकूब कली ग्रुमानु, आ ताम्‍बु गिलाद ङा पहाडम कीङा बाक्‍त। याकूबम चहिं आ ताम्‍बु आइक्‍था ङा डांडाम कीशा, वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","मिनु लाबानमी याकूब कली “गे मार पवी? मारदे आं मतुइक्‍थु प्रोक्‍नी? आं तमीपुकी लडाइमी ग्‍याइश्‍शो खोदेंशो पा लाइक्‍तीवी। ");
INSERT INTO suzBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","गे मारदे ख्रुइश्‍शा गाक्‍नी? मारदे आं कली मारेइ मदेंनी? गो इन कली ग्‍येरशा, कुम्‍सो पशा, खैजडी नु बीना ताप्‍शा, लां सम्‍म चोव़दीशा सोइक्‍तन्‍नी वा। ");
INSERT INTO suzBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","गे आं कली आं चचपुकी नु आं तमीपुकी नु पुक्‍पु पाइक्‍मुचा मगेवी। मरिम्‍शो पाइब बाक्‍ते। ");
INSERT INTO suzBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","इ कली श्‍येत गेचा आं गुइमी बाक्‍ब। तन्‍न सिनाक्‍दो इ आफ आ परमप्रभुमी आं कली ‘गे होस पावो। याकूब कली मारेइ मरिम्‍शो मपावो’ दे लोव़ पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","मिनु गे इ आफ ग्रुम्‍चा शुश दाक्‍ताक्‍वी हना यो, मारदे आं खिं ङा मूर्ति खुइ पा लदी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","मिनु याकूबमी लाबान कली “गे इन तमी निक्‍शी आं गुइ रे रोइक्‍नीनी, दे हिंती। उत्‍पत्ती ३१:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","इन मूर्तिपुकी चहिं सुका आ ताम्‍बुम थित्‍नीनी, मेको मब्रोंइल। इन लोक्‍ब आन ङोंइती आं बाक्‍तीकेम इन के मार बाक्‍मे, कोव़शा लतीन” देंमाक्‍त। मारदे हना याकूबमी राहेलम मेको मूर्तिपुकी खुइ पशो, दे मतुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","मिनु लाबानमी याकूब आ ताम्‍बु, लेआ आ ताम्‍बु, गेय पाइब निक्‍शी आस ताम्‍बु ओव़शा, माल्‍शा मथिदा बाक्‍त। लेआ आ ताम्‍बु रे ग्रूशा, राहेल आ ताम्‍बु ओव़माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","मिनु राहेलम मेको खिं ङा मूर्ति आन कली दलओंठ आ तारी ङा नित्‍तीकेमी ख्रुइश्‍शा, मेको आ तारी निस्‍से बाक्‍त। मिनु लाबानमी ताम्‍बु नेल्‍लेमी माल्‍शा मथिदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","मिनु राहेलमी “आं प्रभु, मगाइक्‍तीने, गो इन ङोंइती बोक्‍ने मचाप्‍नुङ, मारदे हना गो मथिचा दुम्‍ती” देंमाक्‍त। मोपतीके माल्‍शा मथिदा बाक्‍त। लेवी १५:१९-२० ");
INSERT INTO suzBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","मिनु याकूब चुरशा, लाबान कली “मार दूली पङा। आं कली मार मरिम्‍शो पशो आ पर्बम खेदा पनी? ");
INSERT INTO suzBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","आं मारेइ मारेइम माल्‍तीनी, इन थोव़की मार थिन्‍नी? इन लोक्‍ब नु आं लोक्‍ब आन ङोंइती देनीन। एकोपुकीमी इस दातेमी निसाफ पामेक्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","गो गे नु २० बर्स बाक्‍ती। इन क्‍यारश भेडाम पाठा मशाम्‍देम। इन बगाल ङा बोका का यो मब्‍वङ। ");
INSERT INTO suzBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जन्‍तुमी साइश्‍शो यो इन कली मचाक्‍गु। गो आंमा थाप्‍ताक्‍ङ। नाक्‍दो, नाक्‍ती जन्‍तुमी साइक्‍‍तेक्‍म हना यो, गे आं कली थाप्‍पाइक्‍तीनी। प्रस्‍थान २२:११-१२ ");
INSERT INTO suzBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","नाक्‍ती हुप्‍शोम बाक्‍ती, नाक्‍दो ग्‍यू बेक्‍शा, यो मइप्‍थु, नां सोंइताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","मोदेंशो पा गो इन खिंमी २० बर्स गेय पाता। इन तमी निक्‍शी आस पर्बम गो १४ बर्स गेय पाता। ६ बर्स इन क्‍यारश भेडा आन पर्बम गेय पाता। गे आं गेय ङा तचा माल्‍शो थोव़क १० खेयप फाइक्‍तीनी। उत्‍पत्ती २९:२०,३०; उत्‍पत्ती ३०:३१-३६ ");
INSERT INTO suzBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","आं आफ आ परमप्रभु, अब्राहाम आ परमप्रभु नु इसहाक आ मान पा हिंशो परमप्रभु गो नु मबाक्‍शो हना, गे आं कली मुल श्‍येत्‍थ सोइक्‍तीनी वा। परमप्रभुमी आं श्‍येत नु आं गेय तशा, सिनाक्‍दो इन कली हुइक्‍ताक्‍व” देंमाक्‍त। उत्‍पत्ती ३१:२४,५१ ");
INSERT INTO suzBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","मिनु लाबानमी याकूब कली “एको तमी निक्‍शी आं तमी बाक्‍नीस। एको आल आं आल बाक्‍नीम। एको क्‍यारश भेडा आं के बाक्‍नीम। इ तशो नेल्‍ल आं के बाक्‍ब। आं तमी आस कली मुलाक्‍ती गो मार पने चाप्‍नुङा ङा? एको आस तौ आन कली गो मार पने चाप्‍नुङा ङा? ");
INSERT INTO suzBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","मोपतीके गे नु गो कबल पस, इस ङोंइती सांकछी बाक्‍मल” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","मिनु याकूबम फुल्‍लु का चाक्‍शा राप्‍पाइश्‍शा, ");
INSERT INTO suzBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","आ मुर आन कली यो “फुल्‍लु खुप्‍तीन” देंमाक्‍त। मिनु मेकोपुकीमी यो फुल्‍लु खुप्‍तमे बाक्‍त। मिनु मेकेर जामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","मिनु लाबानमी मेको कली येगार-सहादुता, दे नें वोदा बाक्‍त। याकूबम चहिं मेको कली गलेद, दे नें वोदा बाक्‍त। उत्‍पत्ती ३१:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","मिनु लाबानमी “एको फुल्‍लु खुप्‍तीके मुलाक्‍ती इस पशो कबल आ सांकछी बाक्‍ब” देंमाक्‍त। मोपतीके मेको कली गलेद देंनीम। गलेद आ अर्थ सांकछी ङा फुल्‍लु खुप्‍तीके बाक्‍ब। यहोसु २४:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","मिनु मेको राप्‍पाइश्‍शो फुल्‍लु कली मिस्‍पा नें वोदा बाक्‍त। मारदे हना लाबानमी “परमप्रभु यावे गे नु गो इस ब्राची ना इस कली कोव़ब बाक्‍ल। न्‍यायाधीस ११:११ ");
INSERT INTO suzBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","गे आं तमी आस कली श्‍येत गेप्‍तीवी हना, अर्को मीश चाक्‍तीवी हना, गो इस दातेमी मुर सांकछी मबाक्‍तेक्‍म हना यो, परमप्रभु इस सांकछी बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","मिनु लाबानमी लेंशा, याकूब कली “कोव़ङो, एको खुप्‍शो फुल्‍लु नु मेको लाइश्‍शो राप्‍पाइश्‍शो फुल्‍लु गो इस दातेमी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","एको खुप्‍शो फुल्‍लु गो रे इ बाक्‍तीके, गे रे आं बाक्‍तीके श्‍येत गेथ मलमल। ");
INSERT INTO suzBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहाम आ परमप्रभु, नाहोर आ परमप्रभु नु आन किकी पिपी आन परमप्रभुम इस दातेमी निसाफ पव‍ल” देंमाक्‍त। मिनु याकूबमी इसहाक आ मान पा हिंशो परमप्रभु आ नें थिशा, कसम जवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","मिनु मेको डांडामी याकूबमी चढ़ेतीके चढ़ेवा बाक्‍त। मिनु आ खिं ङा मुर आन कली “शोब्‍ले जने” दे गेवा बाक्‍त। मिनु जशा, मेको नाक्‍दो मेक उइ बाक्‍मा बाक्‍त। उत्‍पत्ती ३१:४२ ");
INSERT INTO suzBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","मिनु लाबान सुनी कना बोक्‍शा, आ तमी नु आ चच आन कली पुक्‍पु पाइश्‍शा, आसीक गेशा, आ खिं लेम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","मिनु याकूब लांमी लना लन बाक्‍मेनु, परमप्रभु आ स्‍वर्ग ङा गेय पाइबपुकी याकूब कली ग्रुम्‍थ जाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","मिनु याकूबमी मेको आन कली तशा “एकेर परमप्रभु आ लडाइ पाइब आन बाक्‍तीके बाक्‍ब” देंमाक्‍त। मोपतीके मेको ग्रुम्‍तीक रागी आ नें महा-नाइम वोदा बाक्‍त। महा-नाइम आ अर्थ चहिं “बाक्‍तीक निक्‍शी” बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","मिनु याकूबमी आ लोक्‍ब एसाव ग्रुम्‍चा कली आ ङोंइती मुरपुकी एदोम ङा सेइर रागी सोइक्‍ता बाक्‍त। उत्‍पत्ती ३६:८ ");
INSERT INTO suzBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","मेको आन कली “गे आं प्रभु एसाव कली ‘इन गेय पाइब याकूबमी इन कली लोव़ सोइक्‍ताक्‍व। गो मुल सम्‍म लाबान नु आ रागीमी अर्को रागी ङा मुर दुम्‍शा बाक्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","गो नु शुश ब्‍यफ, गधा, क्‍यारश भेडा, वाइलीम वाइल बाक्‍नीम। गो आं प्रभु, इन ङोंइती शिशी तङल, दे मुर आन कली सोइक्‍ताक्‍ङ’ देंत, देंचा माल्‍नीनी” दे अरेशा सोइक्‍तीमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","मिनु आ सोइश्‍शो मुरपुकी लेश्‍शा जाक्‍शा, याकूब कली “गोपुकी इन लोक्‍ब एसाव आ बाक्‍तीक जाक्‍दीत्‍तक। मेकोमी ४ सहे मुर नु कुशा, इन कली ग्रुम्‍थ जाक्‍ब” दे शेंदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","मिनु याकूब शुश हिंशा, सुर्ता पवा बाक्‍त। मेको नु बाक्‍ब मुर क्‍यारश भेडा, बी ब्‍यफ नु दलओंठ आन कली हुल निक्‍शी पा योक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","मेकोमी “एसावमी ङोंइती ङा हुल साइक्‍तु हना, अर्को प्रोक्‍ने चाप्‍नीम” दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","मिनु याकूबम “आं बाजे अब्राहाम आ परमप्रभु, आं आफ इसहाक आ परमप्रभु, आं कली लोव़ पाइब परमप्रभु यावे, गे आं कली ‘इ खिं ङा मुर आन बाक्‍तीक, इ रागी ले‍तो। गो इ कली रिम्‍शो पाइनुङ’ दे लोव़ पाइतीनी। उत्‍पत्ती ३१:३,१३ ");
INSERT INTO suzBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","गो, इन गेय पाइब आं कली पशो गेना हना यो दाक्‍तीक नु इन रिम्‍शो पचा मप्रोंइतीके मशिरनुङ। गो कोक्‍के का ला कुरशा, यर्दन खोला शोक्‍शा लशो नङ। मुल आं के हुल निक्‍शी दुम्‍शो बाक्‍नीम। २सामुएल ७:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","गो आं कली आं लोक्‍ब एसाव आ गुइ रे प्रोनीने। मारदे हना आं कली, आं मीश आन कली नु आल नेल्‍ल आन कली साइक्‍ब, दे हिंती। ");
INSERT INTO suzBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","गे आं कली ‘गो इ कली थमा पा रिम्‍शो पाइनुङ। इ चच युइ आन कली समुन्‍द्र ङा बाल्‍वा खोदेंशो पा, हिक्‍ने मचाप्‍चा ङा सेल्‍नुङ’ देंतीनी” दे याकूबमी परमप्रभु कली लोव़ पवा बाक्‍त। उत्‍पत्ती २८:१३-१४ ");
INSERT INTO suzBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","मिनु मेको नाक्‍दो मेकेर बाक्‍शा, आ मारेइ मारेइ रे एसाव कली कोसेली योव़ङा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","मेकोमी सहे निक्‍शी ओटा क्‍यारश, २० ओटा बोका, सहे निक्‍शी ओटा भेडा नु २० ओटा सांड, ");
INSERT INTO suzBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","मिनु ३० ओटा दूध तूब चाइक्‍ब पाइश्‍शो दलओंठ, ४० ओटा बी नु १० ओटा ब्‍यफ, २० ओटा गधैनी नु १० ओटा गधा एसाव कली योव़शा, ठीक पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","मिनु आ गेय पाइब आन कली का का पा हुल हुल पा गेवा बाक्‍त। आ गेय पाइब आन कली “गे आं ङोंइती हुल हुल पना पन गाक्‍कीन। हुल नेल्‍ल कालेमी मखुलीन। का अर्को क्‍येङा ङोन खुल्‍चा माल्‍नीनी” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","मिनु नेल्‍ल क्‍येङा ठेयब अरेतीके लोव़ “आं लोक्‍ब एसाव इन कली ग्रुम्‍थ जाक्‍त हना, मेकोमी इन कली ‘गे सुका आ मुर ननी? ते लाइनीनी? इन ङोंइती गाक्‍ब बगाल सु के नमी?’ दे हिल्‍लो पाप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","गेमी ‘एको इन गेय पाइब याकूब के नम। आ प्रभु एसाव कली कोसेली बाक्‍ब। आं यो खोइश्‍शा पिना पिन बाक्‍ब’ देंचा माल्‍नीनी” दे गेय पाइब आन कली माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","मोदेंशो पा ङोंइती गाक्‍ब, नोले गाक्‍ब नु नेल्‍ल क्‍येङा नोले गाक्‍ब नेल्‍ल आन कली अरेमी बाक्‍त। मिनु “मोदेंशो पा एसाव नु ग्रुम्‍ची ना लोव़ पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","मिनु ‘इन गेय पाइब आंइ नोले पिना पिन बाक्‍ब’ देंचा मप्रेंदीन” दे माइक्‍मी बाक्‍त। मारदे हना याकूबमी “गो आं ङोंइती सोइश्‍शो कोसेलीमी गो मेको कली लेम्‍नुङ। मिनु नोले मेको कली ग्रुम्‍नुङ, आं कली ब्राइबा कों” दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","मिनु आ कोसेली आ ङोंइती लदमे बाक्‍त। आं चहिं मेको नाक्‍दो आ मुर बाक्‍तीकेमी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","मिनु मेको नाक्‍दो बोक्‍शा, आ मीश निक्‍शी, आ गेय पाइब मीश निक्‍शी नु आ ११ जना तौ आन कली लाइश्‍शा, यब्‍बोक खोला शोक्‍पाइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","मिनु मेको आन कली शोक्‍पाइश्‍शा, आ मारेइ मारेइ यो सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","मिनु आइक्‍ची हांबुम याकूब का ला बाक्‍माक्‍त। मिनु नां रिक्‍शा, नां मसोव़म सम्‍म मुर का नु राम्‍शी पवा बाक्‍त। होसे १२:४-५ ");
INSERT INTO suzBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","मेको मुरुम याकूब नु राम्‍शी पा आं ब्रुचशो तशा, याकूब आ फिला ङा बोंइसे थिवा बाक्‍त। मिनु आ फिला ङा बोंइसे याक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","मिनु मेको मुरुमी “नां दाप्‍चावानु, मुल लचा गेयी” देंमाक्‍त। मिनु याकूबमी “आं कली आसीक मगेवी सम्‍म मप्रोंइनन” दे मदा बाक्‍त मत्ती १५:२२-२८ ");
INSERT INTO suzBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","मिनु मेकोम “इ नें मार में?” दे हिल्‍लो पवानु, याकूबमी “याकूब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","मिनु मेकोमी “मुल ङा मेरे इ नें याकूब ममाइ, इ नें इस्राएल देंचा माल्‍नीम। मारदे हना गे परमप्रभु नु राम्‍शी पा ग्राते, मुर नु राम्‍शी पा यो ग्राते” देंमाक्‍त। उत्‍पत्ती ३५:१०; येरमीया २०:७ ");
INSERT INTO suzBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","मिनु याकूबम “इन नें मार में?” दे हिल्‍लो पवा बाक्‍त। मिनु मेकोमी “आं नें मारदे माल्‍दे?” देंशा, मेको कली आसीक गेवा बाक्‍त। न्‍यायाधीस १३:१७-१८ ");
INSERT INTO suzBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","मिनु याकूबमी “गो परमप्रभु आ कुल तशा यो मबेक्‍ङ” दे मेको बाक्‍तीके आ नें पेनीएल वोदा बाक्‍त। प्रस्‍थान ३३:२० ");
INSERT INTO suzBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","मिनु नां दाप्‍‍मेनु, याकूब पेनुएल रे खोङ चेङ पा गाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","मोपतीके इस्राएलीपुकीमी मुल सम्‍म मेको बोंइसे ग्‍याइक्‍ब नारी नु मेकेर ङा श्‍ये मब्‍वाइनीमी। मारदे हना मेकोमी याकूब आ फिला ङा बोंइसे याक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","मिनु याकूबम लां गे कोव़ङानु, एसाव नु ४ सहे मुर पिन पिन पशो तवा बाक्‍त। मिनु आ आलपुकी लेआ, राहेल नु आस गेय पाइब मीश निक्‍शी नु गाक्‍पाइक्‍मी बाक्‍त। उत्‍पत्ती ३२:७ ");
INSERT INTO suzBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","मेको गेय पाइब मीश नु आस आल आन कली नेल्‍ल क्‍येङा ङोंइती गाक्‍पदा बाक्‍त। मिनु मेको आन नोले लेआ नु आ आलपुकी, नेल्‍ल क्‍येङा नोले राहेल नु योसेफ गाक्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","मिनु मेको नेल्‍ल आन ङोंइती आंमा गाक्‍माक्‍त। मिनु मेको आ लोक्‍ब ग्रुम्‍चा क्‍येङा ङोंइती ७ खेयप खुम्‍की पा बाम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","मिनु एसावमी मेको कली तशा, दोरशा ग्रुम्‍थ जाक्‍माक्‍त। मिनु आ लोक्‍ब कली मुप्‍शा पुक्‍पु पदा बाक्‍त। मिनु निम्‍फा ङाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","मिनु एसावमी कोव़शा, आलपुकी नु मीश मुर आन कली तशा “गे नु बाक्‍ब सु नमी?” दे हिल्‍लो पवा बाक्‍त। मिनु याकूबमी “परमप्रभुमी इन गेय पाइब कली शिशी पशा, गेशो आलपुकी नम” दे मदा बाक्‍त। भजन संग्रह १२७:३ ");
INSERT INTO suzBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","मिनु नोले मेको गेय पाइब मीश निक्‍शी नु आस आलपुकी जाक्‍शा, एसाव आ ङोंइती खुम्‍की पा बाम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","मिनु लेआ नु आ आलपुकी जाक्‍शा, खुम्‍की पा बाम्‍मा बाक्‍त। मिनु नोले योसेफ नु राहेल जाक्‍शा, खुम्‍की पा बाप्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","मिनु एसावमी “इ ङोंइती गाक्‍शो मार मार मारदे सोइक्‍ती?” दे हिल्‍लो पवा बाक्‍त। मिनु “आं प्रभु, इन ङोंइती शिशी तङल, दे सोइक्‍ताक्‍ङ” दे लोव़ लेत्‍ता बाक्‍त। उत्‍पत्ती ३२:१४-२१ ");
INSERT INTO suzBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","मिनु एसावमी “आं लोक्‍ब, आं कली मारेइ मारेइ गाप्‍शो बाक्‍ब। इ कली वोंइसो” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","मिनु याकूबमी “मदुम्‍ब। गो इन ङोंइती शिशी ताता हना, आं कोसेली ताक्‍कीन। मारदे हना गो इन कुल तशा, परमप्रभु आ कुल तशो खोदेंशो पा ग्‍येरसाक्‍यी। गे आं कली दाक्‍शा ब्राइतीनी। उत्‍पत्ती ३२:३१ ");
INSERT INTO suzBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","इन कली गेशो आसीक लतीन। मारदे हना परमप्रभुमी आं कली शुश शिशी पाप्‍तु। आं के मारेइ मारेइ यो गाप्‍शो बाक्‍ब” दे एसाव कली मदा बाक्‍त। मिनु याकूबमी शुश लोव़ पा एसावमी मेको नेल्‍ल ताक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","मिनु एसावमी “लो, पिन। गो गे नु लाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","मिनु याकूबमी “आं प्रभु, आं आलपुकी आइक्‍च बाक्‍नीम। क्‍यारश भेडा, बी ब्‍यफ आन चाइक्‍ब बाक्‍नीम। मेको आन कली नाक्‍ती का ला शुश गाक्‍पाइश्‍शा, श्‍येत गेता हना, नेल्‍ल बेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","आं प्रभु, गे इन गेय पाइब क्‍येङा ङोंइती गाक्‍कीन। गो बी ब्‍यफ नु आलपुकी चाप्‍चा ङा पा गाक्‍नीकी। नोले आं प्रभु आ बाक्‍तीक सेइर सहर जाक्‍नीक” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","मिनु एसावमी “आं मुर का निक्‍शी गे नु गाक्‍मल” दे मदा बाक्‍त। मिनु याकूबम “ममाल्‍नुङ। मारदे आं प्रभुम आं कली मोदेंशो रिम्‍शो पचा मिम्‍बा?” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","मिनु मेको नाक्‍ती एसाव सेइर गे लेम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकूब चहिं सुक्‍कोथ गे लमाक्‍त। मेकेर खिं का सेल्‍शा, आ बी ब्‍यफ आन कली गोठपुकी सेला बाक्‍त। मोपतीके आ बाक्‍तीके आं नें सुक्‍कोथ वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","मोपा याकूब पदान-अराम रागी रे मारेइ मदुम्‍थु रिम्‍शो पा लेश्‍शा, कनान रागी ङा शेकेम सहर जाक्‍दीम्‍माक्‍त। सहर आ नेक्‍था आ बाक्‍तीक सेला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","मिनु आ ताम्‍बु कीतीके रू हमोर आ तौ आन दाते शेकेम आ आफ रे सहे का केसीता थाप्‍शा, ग्‍यबा बाक्‍त। केसीता मेकेर ङा क्‍येट बाक्‍त। सुन के बाक्‍बा कों, चांदी के बाक्‍बा कों, गिश हेल्‍शो बाक्‍ब मतुंइसीब।यहोसु २४:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","मिनु मेकेर चढ़ेतीक का सेला बाक्‍त। मेको आ नें “एल-एलोहे-इस्राएल” दे वोदा बाक्‍त। मेको आ अर्थ परमप्रभु, इस्राएल आ परमप्रभु बाक्‍ब। उत्‍पत्ती १२:७-८ ");
INSERT INTO suzBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","मिनु लेआ आ तमी, दीना मेको रागी ङा मीश आल आन कली ग्रुम्‍थ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","हिव्‍वी ङा हमोर आ तौ शेकेम, मेको रागी ङा पिप आ तौमी दीना कली तशा, ग्‍याइश्‍शा मेको नु इप्‍‍शा, बिथोलो पवा बाक्‍त। न्‍यायाधीस ९:२८ ");
INSERT INTO suzBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","मिनु याकूब आ तमी दीना कली शुश दाक्‍शा, रिम्‍शो लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","मिनु शेकेममी आ आफ कली “मेको मीश आल आं कली चाक्‍कीन” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","मिनु याकूबमी “शेकेममी इन तमी दीना कली बिथोलो पाप्‍तु” देंशो नेना बाक्‍त। आ तौपुकी चहिं रू ङा गोठीम बाक्‍मा बाक्‍त। याकूब आ तौपुकी मजाक्‍मा सम्‍म सिक्‍सी पा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","मिनु शेकेम आ आफ हमोर याकूब नु लोव़ पचा कली जाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","मिनु मेको नेंशा, याकूब आ तौपुकी यो रू रे जाक्‍मा बाक्‍त। आन थुं मनुथु, शुश चुरमा बाक्‍त। मारदे हना शेकेमम इस्राएल आ तमी नु इप्‍‍शा, बिथोलो पशो बाक्‍माक्‍त। मो पचा मदुम्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","मिनु हमोरमी इस्राएल कली “आं तौ शेकेममी इन तमी कली शुश दाक्‍ब, चाक्‍चा गेने। ");
INSERT INTO suzBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","मिनु आंइ तमीपुकी इन तौपुकीमी चाक्‍ग्‍मेक्‍ल। इन तमीपुकी आंइ कली चाक्‍चा गेने। ");
INSERT INTO suzBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","गे गोपुकी नु बाक्‍कीन। आंइ रागी इन कली ग्‍याप्‍चा लेयचा, बाक्‍चा कली गेनीकी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","मिनु शेकेममी मीश आल आ आफ याकूब नु आ लोक्‍ब आन कली “इन ङोंइती शिशी तङल। गे मार देंनीनी इन कली गेनुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","मेको मीश आल चाक्‍चा गेतीनी हना, गो इन माल्‍शो मारेइ मारेइ गेनुङ” देंमाक्‍त। प्रस्‍थान २२:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","याकूब आ तौपुकीमी आन समी कली बिथोलो पाइब, शेकेम नु आ आफ हमोर आस कली जोल पा ");
INSERT INTO suzBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“गो आंइ समी ख्रोइक्‍तीक चिनु मख्रोइश्‍शो मुर आन कली गेने मचाप्‍नीकी। मेको आंइ कली मशिरब। ");
INSERT INTO suzBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","गे आंइ खोदेंशो पा वोंइश आल वोंइश मुर नेल्‍लेमी ख्रोइक्‍तीक चिनु ख्रोइक्‍तीनी हना, उत्‍पत्ती १७:१०-१४ ");
INSERT INTO suzBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","आंइ तमीपुकी इन कली लाइक्‍चा गेनीकी। मिनु इन तमीपुकी गो चाक्‍नीकी। मिनु गो गेपुकी नु बाक्‍शा, मुर का खोदेंशो दुम्‍नीकी। ");
INSERT INTO suzBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","गेपुकी आंइ देंशो मबिस्‍साक्‍नी हना, आंइ तमी लाइश्‍शा, गाक्‍नीकी” दे लोव़ पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","मिनु हमोर नु आ तौ शेकेम मेको आस देंशो नेंशा, ग्‍येरससा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","मिनु मेको ठिटा मेको पचा बिस्‍से बाक्‍त। मारदे हना याकूब आ तमी कली शुश दाक्‍ता बाक्‍त। मेको आ आफ आ खिं ङा नेल्‍ल क्‍येङा मान ताइब बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","मिनु हमोर नु आ तौ शेकेम आस सहर ङा लाप्‍चो ओव़शा, मेको निक्‍शीमी मुर आन कली ");
INSERT INTO suzBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“एको मुरपुकी गो नु दुशा बाक्‍चा दाक्‍नीम। मोपतीके एक बाक्‍चा गेने। मारदे हना इं रागी ठेयब बाक्‍ब। मेको आन कली यो गारब। गोपुकी मेको आन तमी चाक्‍य। इं तमी मेको आन कली गेय। ");
INSERT INTO suzBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","गो वोंइश मुर नेल्‍ल ख्रोइक्‍तीक चिनु ख्रोइक्‍साक्‍य हना ला, मेकोपुकी गो नु बाक्‍ने बित्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","मार, मेको आन बी ब्‍यफ, क्‍यारश भेडा नु आन शोंप नेल्‍ल इं के मदुम्‍बा ङा? गो मेको आन लोव़ बिश्‍शा हना, इं दातेमी बाक्‍नीम” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","मिनु सहर ङा मुर नेल्‍ल हमोर नु शेकेम आस लोव़ टिशा, ख्रोइक्‍तीक चिनु ख्रोइक्‍चा गेमे बाक्‍त। सहर नेल्‍ल ङा वोंइश मुरुम मोदेंशो पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","मिनु नाक्‍त सां नोले आन ख्रोइक्‍तीके नेल्‍ल क्‍येङा खाइक्‍मानु, याकूब आ तौ निक्‍शी, दीना आ लोक्‍ब, सिमियोन नु लेवी, आस तरवार लाइश्‍शा, सुइ आन मतुइक्‍थु, सहर ओव़शा, सहर ङा वोंइश मुर नेल्‍ल सदसे बाक्‍त। उत्‍पत्ती ४९:५-७ ");
INSERT INTO suzBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","मिनु मेको निक्‍शीमी हमोर नु शेकेम आस कली यो साइश्‍शा, दीना शेकेम आ खिं रे ग्रुंइशा, लदसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","मिनु याकूब आ अर्को तौपुकी यो सहर ओव़मा बाक्‍त। मेकोपुकीमी सहर ङा मारेइ मारेइ लदमे बाक्‍त। मारदे हना शेकेममी आन समी कली बिथोलो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","मिनु आन क्‍यारश भेडा, बी ब्‍यफ, गधा नु मार मार सहर नु आन रूमी बाक्‍मा, मेको नेल्‍ल लदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","आन शोंप नेल्‍ल, आन आलपुकी, आन मीश नु आन खिं ङा मारेइ मारेइ नेल्‍ल लदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","मिनु याकूबमी सिमियोन नु लेवी आस कली “गे आं कली श्‍येत गेतीसी। मुल एको रागी ङा मुरुमी आं कली मदाक्‍नीम। कनानी नु परि‍ज्‍जी आन दातेम आं कली मरिम्‍शो रिना पाइश्‍शो खोदेंशो सेल्‍तीसी। गोपुकी नु शुश मुर मबाक्‍नीम। इं कली लडाइ तोशा, इं खिं ङा मुर नेल्‍ल साइक्‍नीम” दे मेको आस कली हुइक्‍तीम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","मिनु मेको निक्‍शीमी “मार, मेकोमी आंस समी कली तेल्‍लेम खोदेंशो सेल्‍चा दुम्‍बा?” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","मिनु परमप्रभुमी याकूब कली “बोक्‍शा सासो। बेथेल सहर लावो। मिनु मेकेर बाक्‍को। इ लोक्‍ब एसाव रे प्रोक्‍ङेनु, इ ङोंइती ग्रूशो परमप्रभु, आं कली, चढ़ेतीक का सेलो” दे मदा बाक्‍त। उत्‍पत्ती २८:११-२२; उत्‍पत्ती ३१:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","मिनु याकूब आ खिं ङा मुर नु आ बाक्‍शो मुर नेल्‍ल आन कली “इन गुइमी बाक्‍शो मूर्ति ताइक्‍तीन। इन फेक्‍शो वा प्रुइश्‍शा, चिक्‍शा, अर्को फेक्‍सीन। उत्‍पत्ती ३१:१९; ब्‍यवस्‍था २७:१५; यहोसु २४:२३ ");
INSERT INTO suzBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","मिनु बोक्‍य, बेथेल लय। गो मेकेर जाक्‍दीश्‍शा, परमप्रभु कली चढ़ेतीक का सेल्‍नुङ। गो श्‍येत जङानु, आं पुंइशो गेप्‍तु। गो ते गाक्‍ती हना यो, मेको गो नु बाक्‍त” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","मिनु मेकोपुकीमी याकूब कली आन मूर्ति नु आन पांइशो मारवाडी नेल्‍ल गेमे बाक्‍त। याकूबमी मेको नेल्‍ल शेकेम आ नेक्‍था बाक्‍शो रवा आगाम थिमा बाक्‍त। यहोसु २४:२६; न्‍यायाधीस ९:६ ");
INSERT INTO suzBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","मिनु मेकोपुकी लचा गोव़मे बाक्‍त। परमप्रभुमी एर ओंथ ङा सहर ङा मुर आन कली हिंब सेल्‍मी बाक्‍त। मोपतीके मेकोपुकीमी मेको आन कली खेदा मपामे बाक्‍त। प्रस्‍थान २३:२७; यहोसु १०:१० ");
INSERT INTO suzBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","मिनु लशा, याकूब नु मेको नु बाक्‍ब मुर नेल्‍ल कनान रागी ङा लूज सहर जाक्‍दीम्‍मा बाक्‍त। लूज सहर कली बेथेल नें वोइश्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","याकूबम मेकेर चढ़ेतीक का सेला बाक्‍त। मेको आ नें एल-बेथेल वोदा बाक्‍त। मारदे हना आ लोक्‍ब एसाव रे प्रोक्‍मेनु, मेकेर परमप्रभुम तपांइसीशो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","मेना रेबेका कली कोव़ब देबोरा बेक्‍माक्‍त। मिनु मेको कली बेथेल आ नेक्‍था, रवा आगामी थिम्‍मे बाक्‍त। मेको कली याकूबम अल्‍लोन-बकुथ नें वोदा बाक्‍त। मेको आ अर्थ ङाक्‍चा ङा रवा बाक्‍ब। उत्‍पत्ती २४:५९ ");
INSERT INTO suzBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","पदान-अराम रे लेम्‍मेनु, परमप्रभुमी याकूब कली लेंशा ग्रुम्‍शा, मेको कली आसीक गेशा ");
INSERT INTO suzBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“इ नें याकूब बाक्‍ब। तन्‍न मुल रे याकूब मदेंचा, इ नें इस्राएल दुम्‍चा माल्‍ब” देंमाक्‍त। मोपतीके इस्राएल नें वोइश्‍शो बाक्‍माक्‍त। उत्‍पत्ती ३२:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","मिनु परमप्रभुमी मेको कली “गो नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभु नङ। गे सोशा बोशा, शुश दुमीने। गे रे रागी का ङा शुश मुर नु रागी रागी ङा मुर यो दुम्‍नीम। गे रे पिपपुकी दुम्‍नीमी। उत्‍पत्ती १७:१; उत्‍पत्ती २८:३-४; उत्‍पत्ती १७:६ ");
INSERT INTO suzBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अब्राहाम नु इसहाक कली गेशो रागी गो इ कली नु इ चच युइ आन कली गेनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","मिनु परमप्रभुमी लोव़ पने थुम्‍शा, मेको आ बाक्‍तीक रे लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","मिनु याकूबमी परमप्रभु नु लोव़ पशो मिम्‍चा कली मेकेर फुल्‍लु का राप्‍पदा बाक्‍त। मिनु मेको आ तारी तूचा थोव़क चढ़ेतीक नु तेल लुक्‍ता बाक्‍त। उत्‍पत्ती २८:१८-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","याकूबमी परमप्रभु नु लोव़ पतीक सहर कली बेथेल नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","मिनु बेथेल रे एफ्राथ जाक्‍दीत्‍चा कली गाक्‍शो बाक्‍मा बाक्‍त। मेना राहेल आल थिचा चिक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","सुत्‍केरी रोइम शुश श्‍येत जवानु, आ वारच पाइब मीश मुरुमी “महिनो, गे अर्को तौ का नु थीनेवे” दे लोव़ पवा बाक्‍त। उत्‍पत्ती ३०:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","मिनु मेको मबेक्‍थु, आ सोक्‍त लची ना आ तौ आ नें बेन-ओनी वोदा बाक्‍त। आ आफोम चहिं आ नें बेन्‍यामीन वोदा बाक्‍त। मेको आ अर्थ आं श्‍येत ङा तौ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","मिनु राहेल बेक्‍माक्‍त। मिनु एफ्राथ लतीक लांमी थिम्‍मे बाक्‍त। एफ्राथ बेथलेहेम सहरम बाक्‍ब। उत्‍पत्ती ४८:७; १सामुएल १०:२; येरमीया ३१:१५; मत्ती २:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","मिनु याकूबमी आ थिम्‍तीक तारी फुल्‍लु के थाम का राप्‍पदा बाक्‍त। मुल सम्‍म राहेल आ थिम्‍तीके तारी मेको ठेयब फुल्‍लु के थाम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","मिनु इस्राएल लना लन, आ ताम्‍बु एदेर माइश्‍शो लाइश्‍शो खिं आ नेक्‍था कीङा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","मिनु इस्राएल मेको रागीमी बाक्‍मेनु, आ तौ रूबेन आ आफ आ मीश बिल्‍हाह नु इम्‍‍माक्‍त। मिनु इस्राएलमी मेको नेना बाक्‍त। उत्‍पत्ती ४९:४ ");
INSERT INTO suzBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआ आ तौ रूबेन, याकूब आ ङोंइती जरमेशो तौ बाक्‍माक्‍त। सिमियोन, लेवी, यहूदा, इस्‍साकार नु जबूलून नेल्‍ल लेआ आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेल आ तौ योसेफ नु बेन्‍यामीन बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेल आ गेय पाइब बिल्‍हाह आ तौ दान नु नाप्‍ताली बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआ आ गेय पाइब जिल्‍पा आ तौ गाद नु आशेर बाक्‍सा बाक्‍त। मेको नेल्‍ल पदान-अराममी जरमेशो याकूब आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","मिनु याकूब, आ आफ इसहाक आ खिं माम्रे जाक्‍दीम्‍माक्‍त। मेको कली किरयथ-अरबा सहर नु हेब्रोन यो देंनीम। मेको अब्राहाम नु इसहाक आस बाक्‍तीक रागी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","मिनु इसहाक सहे का ८० बर्स दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","मिनु इसहाक शुश बर्स ङा खाल्‍पा दुम्‍शा बेक्‍माक्‍त। आ क्‍येङा ङोंइती बेक्‍शो किकी पिपी आन बाक्‍तीक लमाक्‍त। मिनु आ तौ एसाव नु याकूबम मेको कली थिम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एको एसाव आ चच युइ बाक्नीम। एसाव कली एदोम यो देंनीम। उत्‍पत्ती २५:३०; ब्‍यवस्‍था २३:८ ");
INSERT INTO suzBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावमी कनान रागी ङा मीश निक्‍शी चाक्‍गा बाक्‍त। का हित्ती ङा एलोन आ तमी आदाह, अर्को होर ङा हिव्‍वी सिबोन आ तौ अनाह आ तमी ओहोली-बामा बाक्‍माक्‍त। उत्‍पत्ती २६:३४ ");
INSERT INTO suzBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","मिनु इश्‍माएल आ तमी बासेमाथ, नेबायोथ आ समी यो चाक्‍गा बाक्‍त। उत्‍पत्ती २८:९ ");
INSERT INTO suzBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","मिनु आदाहमी एसाव के एलीफाज थि‍माक्‍त। बासेमाथमी रूएल थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ओहोली-बामामी येऊश, यालाम नु कोराह थि‍माक्‍त। मेकोपुकी कनान रागीम जरमेशो एसाव आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","मिनु एसावमी आ मीशपुकी, आ तौपुकी, आ तमीपुकी, आ खिं ङा मुर नेल्‍ल, आ बी ब्‍यफ नु बस्‍तु भाव नेल्‍ल कनान रागीम चेम्‍‍शो शोंप नेल्‍ल लाइश्‍शा, याकूब रे ङोन अर्को रागी लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","मारदे हना शुश शोंप दुम्‍तीके, बस्‍तु भाव शुश दुम्‍तीके, काथा बाक्‍ने मचाप्‍से बाक्‍त। मिनु आस बाक्‍शो रागीम शुश बस्‍तु भाव दुम्‍तीके थुल्‍ने मचाप्‍मे बाक्‍त। उत्‍पत्ती १३:६ ");
INSERT INTO suzBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","मिनु मेको एदोम माइश्‍शो एसाव सेइर ङा पहाड लशा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","एसाव आ चच युइ सेइर पहाड ङा एदोमी माइश्‍शो सु सु बाक्‍मा बाक्‍त देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव आ मीश आदाह आ तौ एलीफाज, आ मीश बासेमाथ आ तौ रूएल बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","मिनु एलीफाज आ तौपुकी तेमान, ओमार, सेफो, गाताम नु केनाज बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव आ तौ एलीफाज आ कान्‍छी मीश तिम्‍ना बाक्‍माक्‍त। मेकोमी अमालेक थि‍माक्‍त। मेकोपुकी एसाव आ मीश आदाह आ तौपुकी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","मिनु रूएल आ तौपुकी नाहाथ, जेराह, शम्‍माह नु मिज्‍जा बाक्‍मा बाक्‍त। मेको एसाव आ मीश बासेमाथ आ तौपुकी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","मिनु सिबोन आ तौ अनाह आ तमी, एसाव आ मीश ओहोली-बामा आ तौपुकी येऊश, यालाम नु कोराह बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","मिनु एसाव आ तौ आन दाते ङा ठेयब मुर सु सु बाक्‍मा बाक्‍त देंशा हना, आ ङोंइती जरमेशो तौ एलीफाज आ तौ तेमान, ओमार, सेफो नु केनाज, ");
INSERT INTO suzBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोराह, गाताम नु अमालेक, एलीफाजमी एदोम रागीमी थिशो आदाह आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","मिनु एसाव आ तौ रूएल आ तौ आन दाते ङा ठेयब मुर नाहाथ, जेराह, शम्‍माह नु मिज्‍जा बाक्‍मा बाक्‍त। मेकोपुकी रूएलमी एदोम रागीमी थिशो, एसाव आ मीश बासेमाथ आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","मिनु एसाव आ मीश ओहोली-बामा आ तौ आन दाते ङा ठेयब मुर येऊश, यालाम नु कोराह बाक्‍मा बाक्‍त। मेकोपुकी अनाह आ तमी, एसाव आ मीश ओहोली-बामाम, जरमेशो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","मेकोपुकी एदोम माइश्‍शो एसाव आ तौ आन दाते ङा ठेयब मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","मिनु ङोंइती मेको रागीम बाक्‍ब सेइर आ तौ होरीपुकी सु सु बाक्‍मा बाक्‍त देंशा हना, लोतान, शोबाल, सिबोन, अनाह उत्‍पत्ती १४:६; ब्‍यवस्‍था २:१२,२२ ");
INSERT INTO suzBl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एजेर नु दीशान बाक्‍मा बाक्‍त। मेकोपुकी एदोम रागी ङा सेइर आ तौ होरी आन दाते ङा ठेयब मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान आ तौ होरी नु हेमान बाक्‍सा बाक्‍त। लोतान आ समी तिम्‍ना बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबाल आ तौपुकी अल्‍वान, मानाहाथ, एबाल, शेफो नु ओनाम बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोन आ तौ आइयाह नु अनाह बाक्‍सा बाक्‍त। मिनु अनाहमी आ आफ सिबोन आ गधा योव़दीमेनु, गोरशो रागीमी होश ब्‍वाक्‍कु बुक्‍तीके थिदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अ‍नह आ आल दीशोन नु आ तमी ओहोली-बामा बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","मिनु दीशोन आ तौपुकी हेम्‍दान, एश्‍बान, इथ्रान नु केरान बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एजेर आ तौपुकी बिल्‍हान, जावान नु अकान बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशान आ तौ ऊज नु अरान बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी आन दाते ङा ठेयब मुरपुकी लोतान, शोबाल, सिबोन, अनाह, ");
INSERT INTO suzBl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एजेर नु दीशान बाक्‍मा बाक्‍त। मेको सेइर रागी ङा होरी आन ठेयब मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ङोंइती इस्राएल ङा मुर आन पिप मबाक्‍शो बाक्‍माक्‍त। एदोम रागीमी चहिं सासन पाइब पिपपुकी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","मिनु बेओर आ तौ बेलामी एदोम रागीमी सासन पवा बाक्‍त। मिनु मेको आ सहर आ नें दिनहाबा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","मिनु बेला बेक्‍शा नोले बोज्रा ङा जेराह आ तौ योबाब मेकेर ङा पिप दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","मिनु योबाब बेक्‍शा नोले तेमान आ मुर आन रागी ङा हुशाम पिप दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","मिनु हुशाम बेक्‍म नोले बेदाद आ तौ हादाद पिप दुम्‍माक्‍त। मेकोमी मोआब रागीमी मिदयानी नु लडाइ पशा ग्रामाक्‍त। आ सहर आ नें अवीथ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","मिनु हादाद बेक्‍म नोले मास्रेकाह ङा सम्‍ला पिप दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","मिनु सम्‍ला बेक्‍म नोले युफ्रेटीस खोला आ नेक्‍था बाक्‍शो रेहोबोथ ङा शावल पिप दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","मिनु शावल बेक्‍म नोले आकबोर आ तौ बाल-हनान पिप दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","मिनु आकबोर आ तौ बाल-हनान बेक्‍म नोले हादार पिप दुम्‍माक्‍त। आ सहर आ नें पाहु बाक्‍माक्‍त। आ मीश मेहेताबेल बाक्‍माक्‍त। मेको मात्रेद आ तमी बाक्‍माक्‍त। मात्रेद चहिं मे-जाहाब आ तमी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव रे पिशो थर आन खिं नु आन बाक्‍तीके तेको बाक्‍मा बाक्‍त देंशा हना, तिम्‍ना, अल्‍वाह, येथेथ, ");
INSERT INTO suzBl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोली-बामा, एलाह, पिनोन, ");
INSERT INTO suzBl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","केनाज, तेमान, मिब्‍सार, ");
INSERT INTO suzBl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्‍दीएल नु यिराम बाक्‍मा बाक्‍त। मेको एदोम आ थर आन बाक्‍तीक बाक्‍मा बाक्‍त। एसाव एदोमी आन किकी पिपी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब आ आफ अर्को रागीम बाक्‍शो खोदेंशो पा याकूब यो कनान रागीम बाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","एको याकूब आ खिं ङा मुर आन कथा बाक्‍ब। योसेफ १७ बर्स दुम्‍शा आ लोक्‍ब आन क्‍यारश भेडा गोठ ङा गोठला बाक्‍माक्‍त। आ आफ आ मीश बिल्‍हाह नु जिल्‍पा आस तौ कली वारच पाइब बाक्‍माक्‍त। मिनु योसेफमी मेको आन मरिम्‍शो पशो आ आफ कली शोव़बाक्‍माक्‍‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएलमी नेल्‍ल क्‍येङा योसेफ कली दाक्‍शो बाक्‍माक्‍त। मारदे हना मेकोमी खाल्‍पा दुम्‍शा थि‍माक्‍त। मिनु योसेफ कली दारशो फेक्‍तीके का फेरपदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","मिनु आ लोक्‍बपुकीमी “आफोम नेल्‍ल क्‍येङा योसेफ कली दाक्‍‍ताक्‍व” दे तुइश्‍शा, योसेफ कली मदाक्‍तमे बाक्‍त। मिनु योसेफ नु रिम्‍शो लोव़ यो मपामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","काबु नाक्‍दो योसेफमी ङोमु का तवा बाक्‍त। मिनु योसेफमी आ लोक्‍ब आन कली शेंदीमी बाक्‍त। मिनु मेकोपुकीमी ङोंइती क्‍येङा मदाक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","योसेफमी मेको आन कली “गो सिनाक्‍दो ङोमु का ताता। ");
INSERT INTO suzBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","गो नेल्‍ल रूमी चेरब मुठा फ्रेंशा बाक्‍तय। मिनु आं मुठा बोक्‍शा राप्‍त। मिनु इन मुठापुकी एर ओंथ बाक्‍शा, आं मुठा कली सेउ पाम्‍तेक्‍मे” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","आ लोक्‍बपुकीम “गे आंइ कली अरेब दुम्‍नेवे? आंइ कली हुकुम पाइब दुम्‍नेवे?” दे गाइश्‍शा देंमा बाक्‍त। मिनु योसेफ कली आ ङोमु नु आ देंशो आ पर्बम ङोंइती क्‍येङा मदाक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","मिनु नोले योसेफम लेंशा अर्को ङोमु तवा बाक्‍त। मिनु आ लोक्‍ब आन कली “नेनीन, गो अर्को ङोमु का यो ताता। नां, तास्‍ला नु ११ ओटा सोरुलपुकीम आं कली सेउ पाइक्‍तीमी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","मेको ङोमु आ आफ नु आ लोक्‍ब आन कली शेंदीमीनु, आ आफोमी “मार ङोमु तवी? गो, इ ममा नु इ लोक्‍बपुकी इ ङोंइती थमा पा खुम्‍की पा बाप्‍चा माल्‍नीकी?” दे हुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","मिनु आ लोक्‍बपुकीमी योसेफ कली मदाक्‍तमे बाक्‍त। आ आफोम चहिं योसेफ आ देंशो मिम्‍शा आ थुंमी वोदा बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","मिनु योसेफ आ लोक्‍बपुकी क्‍यारश भेडा योव़चा कली शेकेम माइश्‍शो रागीमी बाक्‍शो बाक्‍मा बाक्‍त। उत्‍पत्ती ३३:१८-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएलमी योसेफ कली “इ लोक्‍बपुकी शेकेम नेक्‍थान क्‍यारश भेडा योव़नीम। गो इ कली शेकेम सोइक्‍नन” देंमाक्‍त। मिनु योसेफम “लो, गो लाइनुङ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","मिनु “लावो, इ लोक्‍ब नु क्‍यारश भेडा नेल्‍ल रिम्‍शो बाक्‍मा कों, दोदेंशो पा बाक्‍मा, कोव़थ लावो। मिनु कोव़शा, शेंदी” देंमाक्‍त। मिनु योसेफ कली हेब्रोन बेंसी रे सोइक्‍तानु, शेकेम गे लमाक्‍त। उत्‍पत्ती ३५:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","मिनु योसेफमी लेखमी मुर का ग्रुमाक्‍त। मिनु मेकोमी “गे मार मली?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","मिनु योसेफमी “आं लोक्‍ब आन कली माल्‍थ गाक्‍ती। क्‍यारश भेडा ते योव़शो बाक्‍मा, तुइक्‍ती?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","मिनु मेको मुरुमी “मेकोपुकी एकेर रे लाम्‍तेक्‍मे। ‘दोथान लचा’ देंशो नेंता” देंमाक्‍त। मिनु योसेफम आ लोक्‍ब आन कली दोथानम थिम्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","मिनु आ लोक्‍बपुकीम योसेफ कली ङोन रे पिशो तशा, आन नेक्‍था जाक्‍चा क्‍येङा ङोंइती “मेको कली साइक्‍चा” दे सल्‍ला पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","मिनु मेकोपुकीमी “कोव़ङीन, ङोमु ताइब जाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","मुल मेको कली साइय्‍य। मिनु ढोडोङगा कामी पिक्‍य। मिनु ‘जन्‍तुम साइश्‍शा ब्‍वाप्‍तु’ देंय। आ ङोमु तशो गाप्‍बाक्‍म कों, मगाप्‍बाक्‍म तुइक्‍नय” देंमुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","मिनु रूबेनमी मेको आन लोव़ नेंशा, मेको कली “मसाइय्‍य” देंमाक्‍त। मेकोमी “आ लोक्‍बपुकी रे प्रोंइनुङ” दे मिम्‍ता बाक्‍त। उत्‍पत्ती ४२:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","रूबेनमी मेको आन कली “मसतीने। लेख ङा ढोडोङगा कामी ताइक्‍चा” दे माइक्‍मी बाक्‍त। मारदे हना योसेफ कली आन गुइ रे प्रोंइशा, आफ आ खिं सोइक्‍नुङ, दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","मिनु योसेफ आ लोक्‍ब आन बाक्‍तीके जाक्‍मेनु, मेकोपुकीमी आ नक फेरशो रिम्‍शो फेक्‍तीक वा प्रुइक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","मिनु लेख ङा ढोडोङगा कामी पिक्‍गमे बाक्‍त। मेको ढोडोङगाम ब्‍वाक्‍कु मबाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","मिनु शोब्‍ले जथ निस्‍सीमा बाक्‍त। मिनु कोव़ङमेनु, गिलाद सहर रे इश्‍माएल जात ङा ग्‍याप्‍ब लेयब मुर नु आन दलओंठपुकी पिशो तामे बाक्‍त। मेको आन दलओंठपुकीमी मस्‍लापुकी, ख्रेक्‍तीकपुकी नु धूप इजीप्‍तमी लेयचा कली लाइक्‍बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","मिनु यहूदामी आ लोक्‍ब आन कली “इं लोक्‍ब साइश्‍शा, जोल पचा, मार रिम्‍शो दुम्‍बा ङा? ");
INSERT INTO suzBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","नेनीन, इश्‍माएल आ मुर आन कली लेयशा सोइक्‍तय, मसाइय्‍य। मारदे हना इं लोक्‍ब, इं आंम मुर बाक्‍ब” देंमाक्‍त। मिनु आ लोक्‍बपुकी बिस्‍समा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","मिदयान ङा इश्‍माएली ग्‍याप्‍ब लेयब मुर पिना पिन बाक्‍मा बाक्‍त। मिनु योसेफ कली ढोडोङगा रे फेश्‍शा, इश्‍माएली आन कली चांदी के २० शेकेलम लेयङमे बाक्‍त। मिनु मेकोपुकीमी योसेफ कली इजीप्‍त लदमे बाक्‍त। शेकेल का ११.५ ग्राम, तोला खोदेंशो बाक्‍ब।उत्‍पत्ती २५:२; लेवी २७:१-८ ");
INSERT INTO suzBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","मिनु रूबेनमी योसेफ प्रोंइचा कली मेको ढोडोङगा लशा कोव़ङानु, योसेफ कली मथित्‍थु, सुर्ता पा, आ वा खाक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","मिनु आ लोक्‍ब आन कली “मेको आल मबा। दोपा आ आफ आ ङोंइती जाक्‍दीत्‍नुङा?” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","मिनु मेकोपुकीमी योसेफ आ फेक्‍शो वा लाइश्‍शा, पाठा का क्‍योरशा, आ फेक्‍शो वा हुशेम ख्रुम्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","मिनु मेको फेरशो फेक्‍शो वा आन आफ कली लाइश्‍शा गेमे बाक्‍त। मेकोपुकीमी आन आफ कली “कोव़ङीन, एको वा थित्‍तक। इन तौ आ फेक्‍शो वा कों?” दे हिल्‍लो पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","मिनु मेको वा तशा “आं तौ आ फेक्‍शो वा बाक्‍‍त, दे तुइक्‍ता बाक्‍त। मिनु ब्‍वाकी ङा जन्‍तुमी मेको कली साइश्‍शा, नेक्‍ग्‍मे बाक्‍त” दे ङाक्‍माक्‍त। उत्‍पत्ती ३७:२० ");
INSERT INTO suzBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","मिनु याकूबम आ फेक्‍शो वा खाक्‍शा, अरन्‍डी फेक्‍शा, शुश नाक्‍ती रोंका पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","आ तमी तौ आन आफ कली लेम्‍थ जाक्‍मा बाक्‍त। मिनु याकूबमी “गो आं बेक्‍ची ना सम्‍म आं तौ कली रोंका पाइनुङ” दे लेम्‍चा मगेमी बाक्‍त। मोपा आ आफ योसेफ आ पर्बम ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","मिनु मेको मिदयान ङा मुरपुकीमी योसेफ कली इजीप्‍त रागी ङा फाराओ आ नेल्‍ल क्‍येङा ठेयब गेय पाइब पोतीफर कली लेयङमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","मिनु नोले यहूदा आ लोक्‍बपुकी रे लशा, अदुल्‍लाम सहर ङा हीरा माइश्‍शो मुर आ बाक्‍तीक लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","मेकेर बाक्‍शा, यहूदामी कनानी शुआ नें पाइश्‍शो मुर आ तमी तवा बाक्‍त। मिनु मेको चाक्‍शा, मेको नु बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","मिनु मेकोमी कोव़ज कुरशा, तौ का थि‍माक्‍त। मेको आ नें एर वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","मिनु लेंशा कोव़ज कुरशा, अर्को तौ का नु थि‍माक्‍त। मेको आ नें ओनान वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","मेकोमी लेंशा कोव़ज कुरशा, अर्को तौ का नु थि‍माक्‍त। मेको आ नें शेलाह वोदा बाक्‍त। मेको आल थिची ना यहूदा केसीब माइक्‍तीकेमी बाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","मिनु यहूदामी आ ङोंइती जरमेशो तौ एर कली मीश आल का चाक्‍गा बाक्‍त। मेको आ नें तामार बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","यहूदा आ ङोंइती जरमेशो तौ एरमी परमप्रभु यावे आ ङोंइती मरिम्‍शो पना पन बाक्‍माक्‍त। मिनु परमप्रभु यावेमी मेको कली सदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","मिनु यहूदामी ओनान कली “रिउम पतीक गेय पा इ लोक्‍ब आ मीश नु बाक्‍को। इ लोक्‍ब कली आल सेलो” दे मदा बाक्‍त। ब्‍यवस्‍था २५:५-१० ");
INSERT INTO suzBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","मिनु ओनानमी आ आल मदुम्ब, दे तुइश्‍शा, आ लोक्‍ब आ मीश नु बाक्‍ची ना आ लोक्‍ब आ आल मसेल्‍चा, दे आ वांचेर खपीम ताइक्‍बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","मिनु मेको कली मो पशो तशा, परमप्रभु यावेमी मेको कली मदाक्‍शो बाक्‍माक्‍त। मोपतीके मेको कली यो सदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","मिनु यहूदामी आ चाइमी तामार कली “इ आफ आ खिंम बाक्‍शा, शेलाह मकोल्‍म सम्‍म रिम्‍दो” दे लेम्‍दा बाक्‍त। मारदे हना यहूदामी “मेको नु बाक्‍शा, आ लोक्‍ब निक्‍शी खोदेंशो पा, अर्को यो बेक्‍बा कों” दे मिम्‍ता बाक्‍त। मिनु तामार आ आफ आ खिं लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","मिनु नोले शुआ आ तमी, यहूदा आ मीश बेक्‍माक्‍त। मिनु आ रोंका पतीक नुम नोले यहूदा आ भेडा आन कली ऊन ख्रोइक्‍बपुकी ग्रुम्‍चा कली आ वारच अदुल्‍लाम सहर ङा मुर हीरा नु तिम्‍नाह लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","मिनु मुर कामी तामार कली “इ शिउ आ भेडा ऊन ख्रोइक्‍थ तिम्‍नाह कुइब” दे मदा बाक्‍त। यहोसु १५:५७ ");
INSERT INTO suzBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","मिनु आ वोंइश बेक्‍शो वा प्रुइश्‍शा, आ कुल तेल्‍लेम खोदेंशो पा सुम्‍से बाक्‍त। मिनु मोदेंशो पा तिम्‍नाह एनाइम लतीक लांमी निश्‍शा बाक्‍माक्‍त। मारदे हना शेलाह कोल्‍शा यो, यहूदामी मेको नु ग्‍युंबे मपाइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","मिनु यहूदाम मेको कली लांम तशा “तेल्‍लेम का बाक्‍ब” दे मिम्‍ता बाक्‍त। मारदे हना आ कुल सुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","मिनु मेको कली “आं कली ओव़चा गेयी” देंमाक्‍त। मारदे हना आ चाइमी बाक्ब, दे मतुइक्‍ता बाक्‍त। मिनु तामारमी “गे गो नु बाक्‍शो ङा आं कली मार गेनीनी?” दे हिल्‍लो पवा बाक्‍त। लेवी १८:१५ ");
INSERT INTO suzBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","मिनु “गो आं गोठ ङा पाठा का सोइक्‍नन” देंमाक्‍त। मिनु तामारमी “मेको मसोइक्‍तीनी सम्‍म मार गेनीनी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","मिनु यहूदामी “मार पुंइनेवे?” दे हिल्‍लो पवा बाक्‍त। मिनु मेकोमी “इन छाप, इन डोरी नु इन गुइ ङा कोक्‍के गेचा नङ” दे मदा बाक्‍त। मिनु मेको नेल्‍ल गेशा नोले मेको नु बाक्‍माक्‍त। मिनु कोव़ज कुरा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","मिनु तामार बोक्‍शा लशा, आ वोंइश बेक्‍शो ङा वा लेंशा फेक्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","मिनु यहूदामी मेको पाठा गेचा नु आ छाप, डोरी नु कोक्‍के लेत्‍चा कली आ अदुल्‍लाम ङा आ वारच कली सोइक्‍ता बाक्‍त। मेकोमी मेको मीश मुर कली मथिदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","मिनु मेकोमी मेकेर ङा मुर आन कली “एकेर एनाइम ङा लांम बाक्‍ब तेल्‍लेम ते लमे?” दे हिल्‍लो पामी बाक्‍त। मिनु मेकोपुकीमी “एकेर तेल्‍लेम मबाक्‍ब” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","मिनु मेको यहूदा आ बाक्‍तीक लेश्‍शा “मेको कली थिन्‍ने मचबु। मेकेर ङा मुरपुकीमी ‘एकेर तेल्‍लेम मबाक्‍ब’ देंतेक्‍म” दे यहूदा कली शेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","मिनु यहूदामी “मेकोन बाक्‍ल। गो मुने मदोक्‍ङल। गो पाठा का सोइक्‍ताक्‍ङ। गे मेको कली मथिदी, मार पचा ङा?” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","मिनु महिना सां नोले मुर कामी यहूदा कली “इ चाइमी तामारम तेल्‍लेम पाप्‍तु। तेल्‍लेम पा कोव़ज कुरशो बाक्‍त” देंमाक्‍त। मिनु यहूदामी “मेको चोचा कली चाक्‍कीन” दे लोव़ लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","मिनु तामार कली चाक्‍गमेनु, मेकोमी आ शिउ कली “एको छाप, डोरी नु कोक्‍के सु के बाक्‍मे मेको रे पा कोव़ज कुरशो नङ। एको छाप, डोरी नु कोक्‍के सु के बाक्‍मे, कोव़ङीन” दे लोव़ कुरब सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","मिनु यहूदा मेको छाप, डोरी नु कोक्‍के तुइश्‍शा, मेकोमी “आं क्‍येङा मेको ठीक पाइब बाक्‍त। मारदे हना गो मेको कली आं तौ शेलाह मगेङ” देंमाक्‍त। तन्‍न तामार कली मचाक्‍गा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","मिनु आल थिचा रोइ पची ना, आ कोव़जम जौंले आल बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","मिनु आल थिचावानु, आल कामी आ गुइ ग्रुंइदा बाक्‍त। मिनु आ वारच पाइब मीश मुरुमी लल श्‍येले पाइश्‍शा “एको ङोंइती ङा बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","मिनु मेको आ गुइ ओंइशा, आ लोक्‍ब जरमेसे बाक्‍त। मिनु मेको वारच पाइबमी “इ ग्रूची ना गिश ठेयब गार सेली” दे मदा बाक्‍त। मोपतीके आ नें पेरेस वोदा बाक्‍त। पेरेस आ अर्थ खाक्‍शो गार बाक्‍ब।रूथ ४:१८; मत्ती १:३ ");
INSERT INTO suzBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","मिनु नोले लल श्‍येले पाइश्‍शो आल जरमेसे बाक्‍त। मिनु मेको आ नें जेराह वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","मेको इश्‍माएल जात ङा ग्‍याप्‍ब लेयबपुकीमी योसेफ कली इजीप्‍त रागी चाक्‍दीत्‍मे बाक्‍त। मिनु इजीप्‍त रागी ङा पिप आ नेल्‍ल क्‍येङा ठेयब गेय पाइब पोतीफरमी योसेफ कली ग्‍यबा बाक्‍त। उत्‍पत्ती ३७:२८,३६ ");
INSERT INTO suzBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","मिनु परमप्रभु यावे योसेफ नु बाक्‍शो बाक्‍माक्‍त। योसेफ इजीप्‍त ङा होव़प आ खिंम बाक्‍मेनु, मार मार पवा, मेको नेल्‍ल रिम्‍शो दुम्‍शा लमाक्‍त। उत्‍पत्ती २६:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","मिनु आ होव़पमी “परमप्रभु यावे योसेफ नु बाक्‍माक्‍त। मिनु योसेफमी मार मार पवा, मेको नेल्‍ल परमप्रभु यावेमी रिम्‍शो दुम्‍पदा बाक्‍त।” दे तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","मिनु योसेफ पोतीफर आ ङोंइती शिशी तवा बाक्‍त। मिनु आ खिंमी गेय पवानु, आ ठेयब गेय पाइब सेला बाक्‍त। मिनु अर्को गेय पाइबपुकी कली अरेब यो सेला बाक्‍त। आ मारेइ मारेइ योसेफ कली कोव़पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","मिनु पोतीफरमी योसेफ कली आ खिं ङा नेल्‍ल कोव़ब मुर सेलानु, परमप्रभु यावेमी योसेफ आ पर्बम मेको कली शुश आसीक गेवा बाक्‍त। पोतीफर आ खिंम मार मार बाक्‍मा, आ रूम मार मार ब्‍वारा, मेको नेल्‍ल कली परमप्रभु यावेमी आसीक गेवा बाक्‍त। उत्‍पत्ती ३०:२७ ");
INSERT INTO suzBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","मोपा पोतीफरमी आ मार मार नेल्‍ल योसेफ आ गुइमी जिम्‍मा गेवा बाक्‍त। आ जचा ब्‍वचा ला आंमा कोव़ङा बाक्‍त। योसेफ आ रां नु कुल थम दारशो बाक्‍माक्‍त। उत्‍पत्ती ४३:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","मिनु पोतीफर आ खिंमी बाक्‍मेनु, आ होव़पोक्ममी योसेफ कली दाक्‍शा, मेको नु बाक्‍चा मला बाक्‍त। मेको मीश मुरुम योसेफ कली “पिवो, गो नु बाक्‍को” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","योसेफमी “गो गे नु मबाक्‍नुङ। आं होव़पमी आ मार मार नेल्‍ल आं कली ‘कोव़ङो’ दे जिम्‍मा गेती। ");
INSERT INTO suzBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","आं कली आ खिं ङा नेल्‍ल क्‍येङा ठेयब सेल्‍ती। मार मार बाक्‍मा, नेल्‍ल जिम्‍मा गेती। इन कली चहिं आं कली मगेयी। मारदे हना गे आ मीश ननी। गो दोपा परमप्रभु आ ङोंइती मोदेंशो मरिम्‍शो पाप पने चाप्‍नुङा? गो मपाइनुङ?” दे मदा बाक्‍त। प्रस्‍थान २०:१४; लेवी १८:२० ");
INSERT INTO suzBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","मिनु मेको मीश मुरुमी नाक्‍त किंत किंत योसेफ कली लोव़ पशा “पिवो, गो नु बाक्‍को” दे मदा बाक्‍त। योसेफम चहिं मेको आ लोव़ मटिवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","मिनु काबु योसेफ आ गेय पचा कली पोतीफर आ खिंम बाक्‍माक्‍त। खिंम गेय पाइब मुर सुइ मबाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","मिनु मेको मीश मुरुमी योसेफ आ फेक्‍शो वा ग्‍याइश्‍शा कीशा “गो नु बाक्‍को” देंमाक्‍त। मिनु योसेफ आ फेक्‍शो वा प्रोंइशा, खिं रे दोरशा लाङगा ग्रूमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","पोतीफर आ मीशेमी योसेफ आ फेक्‍शो वा आंम गुइमी प्रोंइशा वोइश्‍शा, खिं रे प्रोक्‍शो तशा, ");
INSERT INTO suzBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","खिं ङा मुर आन कली ब्रेश्‍शा “कोव़ङीन, पोतीफरमी एको हिब्रू मरिम्‍शो पपाइक्‍चा कली चाक्‍तु। एकोमी आं कली ग्‍याइक्‍ताक्‍यी ‘गो नु बाक्‍को’ दे माइक्‍ती। गो चहिं ठेयब सेंदामी वाइ ब्रेत्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","मिनु आं कली वाइ ब्रेश्‍शो तशा, आ वा प्रोंइशा प्रोक्‍त” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","मिनु मेकोमी योसेफ आ फेक्‍शो वा आ नेक्‍था वोइश्‍शा, आ वोंइश मजाक्‍म सम्‍म रिम्‍दा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","पोतीफर जाक्‍मेनु, आ मीशेमी “एको इन चाक्‍शो गेय पाइब हिब्रूमी आं कोठा ओव़शा ‘गो नु बाक्‍को’ देंत। ");
INSERT INTO suzBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","गो चहिं वाइ ब्रेत्‍ती। मिनु आ फेक्‍शो वा प्रोंइशा, खिं रे ग्रूशा प्रोक्‍त” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","मिनु आ होव़पमी आ मीश आ लोव़ नेंशा, चुरमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफ कली लाइश्‍शा, जेल्‍खानम चोक्‍पदा बाक्‍त। मेकेर पिप आ चोक्‍शो मुरपुकी यो बाक्‍मा बाक्‍त। मिनु योसेफ मेकोपुकी नु बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","मिनु परमप्रभु यावेमी योसेफ कली वारच पशा, जेल्‍खान ङा कोव़ब कली “योसेफ रिम्‍शो मुर बाक्‍ब” दे तुइक्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","मिनु मेको कोव़ब मुरुमी योसेफ कली जेल्‍खानम चोक्‍शो मुर आन कली कोव़ब सेला बाक्‍त। मिनु मेकेर बाक्‍शो गेय नेल्‍ल योसेफमी पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","मेको जेल्‍खान ङा कोव़ब मुरुमी योसेफ आ पशो यो मकोव़ङा बाक्‍त। मारदे हना परमप्रभु यावे मेको नु बाक्‍शो तुइक्‍ता बाक्‍त। मेको नेल्‍ल रिम्‍शो पाइब, दे थमा सुदा बाक्‍त। मिनु परमप्रभु यावे मेको नु बाक्‍मेनु, आ गेय नेल्‍ल रिम्‍शो दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","मिनु नोले मार दुम्‍माक्‍त देंशा हना, इजीप्‍त ङा पिप फाराओ आ खिंमी पिप कली तूचा गेब आन ठेयब मुर नु पिप कली शोब्‍ले चोइब आन ठेयब मुरुमी आस प्रभु इजीप्‍त ङा पिप कली मरिम्‍शो पाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","मिनु फाराओमी मेको तूचा गेब आन ठेयब मुर नु शोब्‍ले चोइब आन ठेयब मुर आस पर्बम गाइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","मिनु मेको निम्‍फा आस कली नेल्‍ल क्‍येङा ठेयब गेय पाइब आ जेल्‍खानमी चोक्‍सी बाक्‍त। मेकेर योसेफ यो बाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","मिनु जेल्‍खान ङा कोव़ब मुरुम योसेफ कली “मेको निम्‍फा आस कली वारच पावो” दे अरेवा बाक्‍त। मिनु वारच पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","मिनु इजीप्‍त ङा पिप आ गेय पाइब ठेयब मुर निक्‍शी जेल्‍खानमी बाक्‍सानु, काबु नाक्‍दो निम्‍फामी ङोमु ताम्‍से बाक्‍त। मेको आस ङोमु आस अर्थ निक्‍शी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","मिनु सुनी कना योसेफ मेको निक्‍शी आस कली वारच पथ, आस कोठा ओव़मेनु, निम्‍फा सुर्ता पा बाक्‍शो ताम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","मिनु योसेफमी जेल्‍खानम बाक्‍शो फाराओ आ गेय पाइब आ ठेयब मुर निक्‍शी आस कली “मारदे सुर्ता पनी?” दे हिल्‍लो पाम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","मिनु मेको निक्‍शीमी “गो ङोमु ताइतस्‍कु। मिनु मेको ङोमु आ अर्थ मरुप्‍स्‍कु। शेंब मुर मबा” देंसा बाक्‍त। मिनु योसेफमी “परमप्रभुमी मेको ङोमु मार बाक्‍बा दे शेंबा ममाइ ङा? लो, आं कली देनीन” दे माइक्‍सी बाक्‍त। उत्‍पत्ती ४१:१५-१६; दानीएल २:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","मिनु फाराओ कली तूचा गेब आन ठेयब मुरुमी “गो आं ङोमुमी आं ङोंइती अङगुर बोट का ताता। ");
INSERT INTO suzBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","मिनु मेको अङगुर बोटमी रा‍शी सां बाक्‍तेक्‍म। मिनु मेको कोच्‍वा दाप्‍शा, फू यो बोइक्‍तेक्‍मे। बोइश्‍शा ङा मिन अङगुर गेडा सिश्‍शा मी‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","मिनु आं गुइमी फाराओ आ कचौरा बाक्‍त। मिनु गो अङगुर आ गेडा आ रस फाराओ आ कचौरामी चिम्‍ता। मिनु कचौरा पिप कली गेता” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","मिनु योसेफमी “इन तशो ङोमु आ अर्थ मार बाक्‍ब देंशा हना, मेको राशी सां नाक्‍ती सां बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","मिनु सांबु नाक्‍ती फाराओम इन कली जेल्‍खान रे प्रोंइशा ङा मिन इन ङोंइती पशो गेय लेंशा गेब। मिनु गे ङोंइती ङा खोदेंशो पा फाराओ कली तूचा गेनीनी। लेंशा फाराओ कली कचौरा गेनीनी। इन तशो ङोमु आ अर्थ एको बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","इन कली रिम्‍शो दुम्‍मेनु, आं कली यो मप्रेंदीन। आं कली शिशी पने। फाराओ कली आं कली मेको जेल्‍खान रे ग्रुंइचा, दे लोव़ पने। ");
INSERT INTO suzBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ङोंइती आं कली हिब्रू रागी रे खुइ पा चाक्‍तीमी। मुल जेल्‍खानम चोक्‍तीमी। गो मारेइ मरिम्‍शो मपङ” देंमाक्‍त। उत्‍पत्ती ३७:२८ ");
INSERT INTO suzBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","मिनु फाराओ कली शोब्‍ले चोइब आन ठेयब मुरुम मेको ङोमु आ अर्थ रिम्‍शो बाक्‍त, देंशा, योसेफ कली “गो यो ङोमु का ताता। मेको ङोमुम पिरीङगा सां बुश शोब्‍ले पियाम कुरशो बाक्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","नेल्‍ल क्‍येङा आ तार ङा पिरीङगामी फाराओ कली शुश खाल ङा चोशो शोब्‍ले बाक्‍तेक्‍मे। मेको पिरीङगा ङा शोब्‍ले चिक्‍बीम खुइ पा जाम्‍तेक्‍म” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","मिनु योसेफमी “इन तशो ङोमु आ अर्थ मार बाक्‍ब देंशा हना, मेको पिरीङगा सां, नाक्‍त सां बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","सांबु नाक्‍ती फाराओमी इन कली जेल्‍खान रे ग्रुंइपाइश्‍शा, रवाम क्‍याइक्‍पाइक्‍ब। मिनु चिक्‍बीम इन श्‍ये ब्‍वाइनीम। इन तशो ङोमु आ अर्थ एको बाक्‍ब” दे शेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","मिनु आ सांबु नाक्‍ती फाराओ आ जरमेशो नाक्‍त बाक्‍माक्‍त। मिनु फाराओमी आ गेय पाइब नेल्‍ल आन कली भोज सेला बाक्‍त। मिनु आ कली तूचा गेब आन ठेयब मुर नु शोब्‍ले चोइब आन ठेयब मुर आस कली जेल्‍खान रे ग्रुंइदीम्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","मिनु आ कली तूचा गेब आन ठेयब मुर कली लेंशा ङोंइती ङा गेय पचा गेवा बाक्‍त। मिनु मेकोमी लेंशा फाराओ कली तूचा गेब दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","शोब्‍ले चोइब आन ठेयब मुर कली चहिं क्‍याइश्‍शा साइक्‍पदा बाक्‍त। योसेफमी दोदेंशो देंमे, मोदेंशो दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तन्‍न फाराओ कली तूचा गेब आन ठेयब मुरुमी योसेफ कली यु प्रेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","मिनु बर्स निक्‍शी नोले फाराओमी ङोमु निक्‍शी तवा बाक्‍त। मिनु ङोमुमी मार तवा बाक्‍त देंशा हना, आंम कली नील खोला आ नेक्‍थान राप्‍शा बाक्‍शो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","मिनु नील खोला रे ७ ओटा दारशो दोम्‍शो बी ग्रूशो तवा बाक्‍त। मेको बीपुकीमी बुदी मीलु घांस ब्‍वामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","मिनु नोले नील खोला रे ७ ओटा अर्को काइ मदारशो ग्‍येंशो बी ग्रूशो तवा बाक्‍त। मिनु मेकोपुकी अर्को बी नु नील खोला आ नेक्‍था राप्‍शा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","मिनु काइ मदारशो ग्‍येंशो बीपुकीमी दारशो दोम्‍शो बी आन कली ब्‍वामे बाक्‍त। नोले फाराओ सेंसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","मिनु फाराओ लेंशा निन्‍द्रा पवानु, लेंशा अर्को ङोमु तवा बाक्‍त। मार तवा बाक्‍त देंशा हना, चेरब बोट कामी शुश आख पाइश्‍शो ७ ओटा ग्रेल्‍शो बाला सिश्‍शो तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","मिनु नोले पूर्ब ङा फशेम बुश सेल्‍शो ७ ओटा सोप्‍पीक्‍च आइक्‍च बाला तवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","मिनु मेको आइक्‍च बालामी मेको शुश आख पाइश्‍शो ७ ओटा बाला आन कली दाक्‍ग्‍मे बाक्‍त। नोले फाराओ सेंशा, आ ङोमु तशो तुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","मिनु आ थुं मनुथु सुनी कना इजीप्‍त ङा जादू पाइब नु जोक्‍ब तुइक्‍ब नेल्‍ल आन कली ब्रेत्‍थ सोइक्‍तीमी बाक्‍त। मेको जाक्‍मानु, आ ङोमु मेको आन कली शेंदीमी बाक्‍त। तन्‍न सुइमी फाराओ कली मेको ङोमु आस अर्थ देंने मचाप्‍मे बाक्‍त। दानीएल २:३ ");
INSERT INTO suzBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","मिनु फाराओ कली तूचा गेब आन ठेयब मुरुमी आ पिप कली “मुलाक्‍ती आं मरिम्‍शो पशो मिम्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","फाराओमी आ गेय पाइब आस पर्बम चुरमेनु, गो नु शोब्‍ले चोइब आन ठेयब मुर नेल्‍ल क्‍येङा ठेयब गेय पाइब आ जेल्‍खानम चोक्‍सीशा बाक्‍स्‍कुनु, ");
INSERT INTO suzBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","गो निक्‍शीम काबु नाक्‍दो ङोमु ताइतस्‍कु। मेको ङोमु निक्‍शी के अर्थ निक्‍शी बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","मेना हिब्रू रागी ङा ठिटा का यो जेल्‍खानम बाक्‍त। मेको इन नेल्‍ल क्‍येङा ठेयब गेय पाइब आ गेय पाइब बाक्‍त। गो निक्‍शीमी तशो ङोमु मेको कली माइक्‍स्‍कुनु, योसेफमी ङोमु आ अर्थ नेल्‍ल आंस कली शेंताक्‍स्‍की। आं तशो ङोमु आ अर्थ शेंताक्‍यी। मिनु अर्को मुर आ तशो ङोमु आ अर्थ यो शेंताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","दोदेंशो पा शेंदा, मोदेंशोन दुम्‍त। आं गेय आं कली लेंशा गेतीनी। अर्को कली चहिं क्‍याइश्‍शा साइक्‍तेक्‍म” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","मिनु फाराओमी योसेफ कली ब्रथ सोइक्‍ता बाक्‍त। मेकोपुकीमी योसेफ कली रीब पा जेल्‍खान रे ग्रुंइपदमे बाक्‍त। योसेफ कली चां प्रेक्‍शा, नक वा फेक्‍पा, फाराओ आ बाक्‍तीके चाक्‍ग्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","मिनु फाराओमी योसेफ कली “गो ङोमु निक्‍शी ताता। सुइमी मेको आस अर्थ शेंने मचबेम। मिनु गो इ पर्बम लोव़ नेंता। गे मुर आन तशो ङोमु आ अर्थ शेंने चाप्‍नेवे ने” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","मिनु योसेफमी फाराओ कली “गो ङोमु ङा लोव़ मतुइक्‍नुङ। परमप्रभुमी फाराओ कली थमा पा थुं नाइक्‍चा ङा लोव़ तुइक्‍पाइक्‍ब” देंमाक्‍त। उत्‍पत्ती ४०:८ ");
INSERT INTO suzBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","मिनु फाराओमी “गो आं ङोमुमी नील खोला आ नेक्‍था बाक्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","मिनु नील खोला रे ७ ओटा दारशो दोम्‍शो बी ग्रूतेक्‍म। मिनु बुदी मीलु घांस ब्‍वाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","मिनु नोले ७ ओटा मदारशो ग्येंशो बी ग्रूतेक्‍म। गो इजीप्‍त रागी नेल्‍लेमी मोदेंशो मदारशो बी गेनायो मतङमी। ");
INSERT INTO suzBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","मिनु मदारशो गेयशो बीपुकीमी ङोंइती ग्रूशो दोम्‍शो बी आन कली ब्‍वाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","मिनु मेको आन कली ब्‍वशा यो, गेयशो बी मदोम्‍म। ङोंइती ङा खोदेंशो पा गेयस ङा गेयस बाक्‍तेक्‍म। बी ब्‍वाम्‍तेक्‍म, दे सुइमी थमा मसुदेम। मिनु नोले गो सेंसाक्‍यी। ");
INSERT INTO suzBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","मिनु लेंशा इप्‍ती। मिनु ङोमु तङानु, चेरब बोट का रे ७ ओटा ठेयब रिम्‍शो बाला पाइश्‍शो तातामी। ");
INSERT INTO suzBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","मिनु नोले अर्को बोट रे ७ ओटा पूर्ब ङा फशेम सोव़शो इम्‍चीली सोप्‍पीक्‍च बाला ताता। ");
INSERT INTO suzBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","मिनु इम्‍चीली सोप्‍पीक्‍च बालापुकीमी मेको ७ ओटा रिम्‍शो बाला आन कली दाक्‍तेक्‍म। गो एको आं ङोमु जादू पाइब आन कली माइक्‍तामी। मेकोपुकीम एको ङोमुमी मार दुम्बा, दे देंने मचबेम” दे योसेफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","मिनु योसेफमी फाराओ कली “इन ङोमु निम्‍फा कांइचीक खोदेंशो बाक्‍ब। परमप्रभुमी मार पचशो बाक्‍मे, मेको इन कली ङोमुमी कोंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","मेको ७ ओटा रिम्‍शो बी ७ ओटा बर्स बाक्‍नीम। मिनु मेको ७ ओटा रिम्‍शो बाला यो ७ बर्स बाक्‍नीम। ङोमु निक्‍शी कांइचीक खोदेंशो बाक्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","मिनु मेको आ नोले ग्रूशो ७ ओटा ग्‍येंशो बीपुकी ७ ओटा बर्स बाक्‍नीम। मिनु मेको ७ ओटा गेडा मसिश्‍शो, पूर्ब ङा फशेम सोव़शो सोप्‍पीक्‍च बाला यो ७ ओटा बर्स बाक्‍नीम। मेको ७ बर्स ङा अन्‍काल बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","आं देंशो मार बाक्‍ब देंशा हना, परमप्रभुमी मार पचा चिक्‍शो बाक्‍मे, मेको इन कली कोंइताक्‍व। मोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","नेनीन, इजीप्‍त रागी नेल्‍लेमी ७ बर्स सम्‍म शुश बाली नाली ग्रेल्‍शा, रिम्‍शो बर्स दुम्‍चा चिक्‍शो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","मिनु आ नोले ७ बर्स सम्‍म अन्‍काल दुम्‍ब। मिनु मेको मरिम्‍शो ७ बर्सम इजीप्‍त रागीमी अन्‍न ग्रेल्‍शो नेल्‍ल प्रेंनीम। मिनु मेको अन्‍कालमी रागी कली थुम्‍पाइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","मिनु मेको ठेयब अन्‍काल दुम्‍शा, ङोंइती अन्‍न ग्रेल्‍शो बर्स नेल्‍लेमी प्रेंनीम। मारदे हना मेको अन्‍काल शुश श्‍येत ङा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","मिनु इन ङोमु निक्‍शी खेयप ताइतीनी, मेको आ अर्थ मार बाक्‍ब देंशा हना, परमप्रभुमी मेको थमा पा पाइब नु पचा चिक्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","मोपतीके फाराओमी निप्‍स पाइश्‍शो मुर का इजीप्‍त रागी ङा ठेयब मुर सेलीन। ");
INSERT INTO suzBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","मिनु आं देंशो पशा, कोव़ब मुरपुकी यो वोइक्‍चा माल्‍नीनी। मेकोपुकीमी फाराओ आ सासनमी रिम्‍शो ७ बर्सम इन रागी नेल्‍ल रे अन्‍न ५ भाग तिरो पोक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","मेको रिम्‍शो बर्स ङा अन्‍न खुप्‍शा, अन्‍काल ङा बर्सम सहर ङा मुर आन कली थुल्‍चा कली उप्‍शा वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","मेको उप्‍शा वोइश्‍शो अन्‍न इजीप्‍त रागीमी अन्‍काल मदुम सम्‍म उप्‍चा माल्‍ब। मोपा वोइश्‍शोनु, अन्‍कालमी मबेक्‍नीम” दे योसेफमी फाराओ कली मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","मिनु फाराओ नु आ गेय पाइब नेल्‍लेमी “योसेफ आ देंशो लोव़ रिम्‍शो बाक्‍ब” दे मिम्‍तमे बाक्‍त। हितोपदेस १४:३५ ");
INSERT INTO suzBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","मिनु फाराओम आ गेय पाइब आन कली “गो योसेफ खोदेंशो मुर अर्को सु थिन्‍ने चाप्‍नया ङा? परमप्रभु आ सोक्‍तीम ब्रीशो मुर का थिन्‍ने चाप्‍नया ङा?” दे हिल्‍लो पामी बाक्‍त। प्रस्‍थान ३१:३; हितोपदेस २:६ ");
INSERT INTO suzBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","मिनु फाराओमी योसेफ कली “परमप्रभुमी मेको नेल्‍ल इ कली तुइक्‍पाइक्‍तु। इ खोदेंशो जोक्‍ब तुइक्‍ब मुर सुइ मथिंसीब। ");
INSERT INTO suzBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","इ कली आं रागी ङा मुर आन कली हुकुम पाइब सेल्‍नन। इ देंशो लोव़ मुर नेल्‍लेमी टिचा माल्‍नीम। गे आं सरकार ङा गेय पाइब नेल्‍ल आन क्‍येङा ठेयब मुर दुम्‍नीनी। गो सिरपेचम पतीके ला इ क्‍येङा ठेयब बाक्‍नुङ। भजन संग्रह ११३:७ ");
INSERT INTO suzBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","नेनीन, गो इ कली इजीप्‍त रागी नेल्‍ल ङा ठेयब मुर सेल्‍नन्‍नी” देंमाक्‍त। प्रेरित ७:१० ");
INSERT INTO suzBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","मिनु फाराओम आ छाप क्‍येप्‍तीक औंठी आ ब्रेप्‍चो रे प्रुइश्‍शा, योसेफ आ ब्रेप्‍चोम लिक्‍ता बाक्‍त। मिनु योसेफ कली दारशो बुश वा फेक्‍पाइश्‍शा, सुन के माला रेल्‍दा बाक्‍त। एस्‍तर ३:३०; दानीएल ५:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","मिनु फाराओमी योसेफ कली आ नोले ङा बग्‍गीमी ङोइक्‍पदा बाक्‍त। मिनु योसेफ आ ङोंइती बाक्‍बपुकीमी “योसेफ आ ङोंइती पोक्‍च थेक्‍शा, सेउ पने” दे ब्रेम्‍मा बाक्‍त। मोपा इजीप्‍त रागी ङा हुकुम पाइब सेला बाक्‍त। एस्‍तर १०:३ ");
INSERT INTO suzBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","मिनु फाराओमी “गो फाराओ नङ। इजीप्‍त रागीमी गे मार पचा देंनी, मेको ला पचा माल्‍नीम” दे योसेफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","मिनु फाराओमी योसेफ कली साफेनाथ-पानेआह, दे नक नें वोदा बाक्‍त। मिनु योसेफ कली पोतीफेरा माइश्‍शो ओन सहर ङा नाक्‍सो आ तमी आसेनाथ नु ग्‍युंबे पाइक्‍ता बाक्‍त। मिनु योसेफ इजीप्‍त रागी नेल्‍ल कोव़थ हिरचा गोवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","योसेफ फाराओ पिप आ ङोंइती लोव़ पवानु, ३० बर्स दुम्‍शो बाक्‍माक्‍त। मिनु फाराओ आ ङोंइती रे लशा, इजीप्‍त रागी नेल्‍ल हिरथ लमाक्‍त। उत्‍पत्ती ३७:२ ");
INSERT INTO suzBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","मिनु मेको रिम्‍शो बाली ग्रेल्‍तीक ७ बर्समी इजीप्‍त नेल्‍ल ङा रूमी थाम्‍पा अन्‍न ग्रेल्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","मिनु योसेफमी मेको बाली ग्रेल्‍शो ७ बर्स ङा अन्‍न सहर सहरम उप्‍शा, वोदा बाक्‍त। मेको सहरम एर ओंथ सु सु आन रू बाक्‍मे, मेकेर ङा अन्‍न मेको सहरम उप्‍शा वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","मिनु योसेफमी समुन्‍द्र ङा बाल्‍वा खोदेंशो पा अन्‍न उप्‍शा, शुश दुम्‍तीके पुक्‍चा यो प्रोना बाक्‍त। मारदे हना पुक्‍ने मचाप्‍चा ङा पा शुश बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","मिनु अन्‍काल दुम्‍चा ङोंइती योसेफ आ मीश ओन सहर ङा नाक्‍सो पोतीफेरा आ तमी आसेनाथमी तौ निक्‍शी थि‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","मिनु योसेफमी “ङोंइती श्‍येत जङानु, परमप्रभुमी आं आफ आ खिं ङा मुर आन कली प्रेंपाइक्‍ती” दे मिम्‍शा, आ ङोंइती जरमेशो तौ कली मनस्‍से नें वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","अर्को कली एफ्राइम नें वोदा बाक्‍त। मारदे हना “परमप्रभुमी आं कली रागीमी श्‍येत जङानु, शुश दुम्‍पाइक्‍ती” दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिनु इजीप्‍त रागीमी मेको रिम्‍शो अन्‍न ग्रेल्‍शो ७ बर्स नुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","मिनु योसेफ आ देंशो ७ बर्स ङा अन्‍काल दुम्‍चा गोवा बाक्‍त। मेको अन्‍काल रागी रागी नेल्‍लेमी दुम्‍माक्‍त। इजीप्‍त रागीमी चहिं अन्‍न थिंसे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","मिनु इजीप्‍त रागीमी ठेयब अन्‍काल दुम्‍शा, मुरपुकीमी फाराओ कली “अन्‍न गेकी” दे पुन्‍मे बाक्‍त। मिनु फाराओम इजीप्‍त ङा मुर आन कली “योसेफ नु पुंइथ लने। मेकोमी मार देंबा, मेको पने” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","मिनु मेको अन्‍काल रागी रागी नेल्‍लेमी दुम्‍माक्‍त। मेना योसेफमी अन्‍न वोइक्‍तीक नेल्‍ल रोक्‍चा गेवा बाक्‍त। इजीप्‍त ङा मुर आन कली अन्‍न लेयपदा बाक्‍त। रागी नेल्‍लेमी ठेयब अन्‍काल दुम्माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","मिनु अर्को रागी ङा मुरपुकी यो इजीप्‍त रागीमी अन्‍न ग्‍याप्‍थ, योसेफ आ ङोंइती जाक्‍मा बाक्‍त। मारदे हना मेको अन्‍कालम रागी नेल्‍ल ग्रोइक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","मिनु याकूबमी इजीप्‍त रागीमी अन्‍न बाक्‍ब दे तुइश्‍शा, आ तौ आन कली “गे मारदे कोव़मुशा बाक्‍नीनी? मारेइ मपाइनीनी? ");
INSERT INTO suzBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","नेनीन, इजीप्‍त रागीमी अन्‍न बाक्‍ब। मिनु गोपुकी अन्‍कालमी मबेक्‍य, ब्रोंइय अन्‍न ग्‍याप्‍थ लने” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","मिनु योसेफ आ १० जना लोक्‍बपुकी इजीप्‍त अन्‍न ग्‍याप्‍थ लमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","याकूबमी योसेफ आ लोक्‍ब बेन्‍यामीन कली चहिं श्‍येत दुम्‍बा कों, दे हिंशा, आ लोक्‍बपुकी नु मसोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","मोपा याकूब आ तौपुकी अर्को मुर नु इजीप्‍त अन्‍न ग्‍याप्‍थ जाक्‍दीम्‍मा बाक्‍त। मारदे हना कनान रागीमी यो अन्‍काल दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","मिनु योसेफ सरकार ङा ठेयब मुर दुम्‍शा, रागी नेल्‍ल ङा मुर आन कली अन्‍न लेयपदा बाक्‍त। योसेफ आ लोक्‍बपुकी जाक्‍शा, योसेफ आ ङोंइती खुम्‍की पा बाप्‍शा, सेउ पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","मिनु योसेफमी आ लोक्‍ब आन कली तशा, तुइक्‍ता बाक्‍त। तन्‍न मतुइश्‍शो खोदेंशो पा ठेयब सेंदामी “ते रे जाक्‍नी?” दे हिल्‍लो पामी बाक्‍त। मिनु मेकोपुकीमी “गो कनान रागी रे अन्‍न ग्‍याप्‍थ जाक्‍तक” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफम आ लोक्‍ब आन कली तुइक्‍ता बाक्‍त। मेकोपुकीमी चहिं योसेफ कली मतुइक्‍त्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","मिनु योसेफम आ लोक्‍ब आन पर्बम आ ङोमु मिम्‍ता बाक्‍त। मिनु मेको आन कली “गे क्‍यारी पाइब बाक्‍नीनी। एको रागीम ते रे ओव़चा, दे कोव़थ जाक्‍तीनी” दे आ लोक्‍ब आन कली माइक्‍मी बाक्‍त। उत्‍पत्ती ३७:५-९ ");
INSERT INTO suzBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","मिनु मेकोपुकीमी “ममाइ प्रभु, इन गेय पाइब अन्‍न ग्‍याप्‍थ जाक्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","गो नेल्‍ल मुर का आ तौ नकी। गोपुकी ठीक पाइब बाक्‍नीकी। इन गेय पाइब, गो क्‍यारी पाइब मनकी” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","मिनु योसेफमी “ममाइ, गे एको रागी ‘दोपा ओव़चा’ दे कोव़थ जाक्‍तीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","मिनु मेकोपुकीमी “गो इन गेय पाइब १२ जना लोक्‍ब बाक्‍नीकी। कनान रागी ङा मुर का आ तौ नकी। नेनीन, कान्‍छा मुल आ आफ नु बाक्‍ब। का चहिं मबाक्‍ब” दे योसेफ कली मदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","मिनु योसेफमी “आं देंशो खोदेंशो पा, गे क्‍यारी पाइब बाक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","गो इन कली कोव़नुङ, फाराओ आ नेंमी इन लोक्‍ब कान्‍छा मजाक्‍म सम्‍म गे एकेर रे लचा मताइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","इन दाते ङा का कली इन लोक्‍ब कान्‍छा ब्रथ सोइक्‍तीन। मेना सम्‍म गे एक जेल्‍खानम बाक्‍नीनी। इन लोव़ थमा बाक्‍म कों, जोल बाक्‍म कों, नोले तुंइ‍सीब। गे इन लोक्‍ब कान्‍छा मचाक्‍तीनी हना, फाराओ आ नेंमी गे क्‍यारी पाइब बाक्‍नीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","मेको नेल्‍ल आन कली नाक्‍त सां सम्‍म जेल्‍खानम चोक्‍मी बाक्‍त। उत्‍पत्ती ३७:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","मिनु नाक्‍त सां नोले योसेफमी “गो परमप्रभु कली मान पा हिंनुङ। मोपतीके गेपुकी ब्रोंइचा कली आं देंशो पने। ");
INSERT INTO suzBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","गे ठीक पाइब मुर बाक्‍तीनी हना, इन दाते ङा का चहिं जेल्‍खानम बाक्‍कीने। अर्को अन्‍न कुरशा, इन खिं लने। ");
INSERT INTO suzBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","इन लोक्‍ब कान्‍छा कली एक चाक्‍कीन। मिनु इन लोव़ थमा बाक्ब, दे तुंइसीब। मिनु गे बेक्‍चा ममाल्‍नीनी” दे आ लोक्‍ब आन कली माइक्‍मी बाक्‍त। मिनु आ देंशो पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","मेकोपुकीमी “गो थमा पा इं लोक्‍ब आ पर्बम ठेयब पाप पाइतय। मेकोमी इं कली तशा, शुश हिंशा, पुनानु यो, मेको आ लोव़ मनेंय। मोपतीके इं कली एको श्‍येत दुम्‍त” देंमुमा बाक्‍त। भजन संग्रह ५०:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","मिनु रूबेनमी “मेको आल कली मारेइ पाप मपने, दे गो इन कली मदेंङा ङा? तन्‍न गे आं लोव़ मनेंनी। मेको कली श्‍येत गेशो हुश आ क्‍येक्‍क लेत्‍चा पुंइसाक्‍य” दे आ लोक्‍ब आन कली देंमाक्‍त। उत्‍पत्ती ३७:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","मिनु योसेफमी मेको आन लोव़ नेल्‍ल रुप्‍तु, दे मतुइक्‍तमे बाक्‍त। मारदे हना योसेफमी मेकोपुकी नु लोव़ पवानु, आन लोव़ रुप्‍ब नु आ कली आ अर्थ देंब मुर का वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","मिनु योसेफ आ लोक्‍बपुकी रे लशा ङाक्‍माक्‍त। मिनु लेश्‍शा जाक्‍शा, मेकोपुकी नु लोव़ पशा, मेको आन ङोंइती सिमियोन कली पाइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","मिनु नोले योसेफमी आन धोक्रोम अन्‍न प्रिंपाइश्‍शा, आन गेशो क्‍येट यो लेंशा, आन धोक्रोम कुर पपाइश्‍शा, लां कली जचा थोव़क यो गेपाइक्‍मी बाक्‍त। आ लोक्‍ब आन कली मोदेंशो पाइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","मिनु मेकोपुकी अन्‍न आन गधा तारी वोइश्‍शा लमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","मिनु लांमी बास बाक्‍मानु, आन दाते ङा कामी आ गधा कली थुल्‍चा, दे आ धोक्रो रोक्‍गा बाक्‍त। मिनु आ धोक्रो आ शोव़मी आ थाप्‍शो क्‍येट थिदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","मिनु मेकोमी आ लोक्‍ब आन कली “आं क्‍येट लेत्‍मे देय मार में? आं धोक्रो आ शोव़म बाक्‍त, शां” दे लोव़ पवा बाक्‍त। मिनु नेल्‍लेमी सुर्ता पशा “परमप्रभुमी इं कली मार पवा” दे हिंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","मेकोपुकीमी आन आफ याकूब आ खिं कनान रागी जाक्‍दीश्‍शा, मार मार दुम्‍मे, नेल्‍ल शोव़ङमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","मेकोपुकीमी “मेको रागी ङा ठेयब मुरुम आंइ कली ठेयब सेंदामी लोव़ पशा, आंइ कली आन रागी क्‍यारी पाइब सुइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","गोपुकीमी ‘गो ठीक पाइब बाक्‍नीकी, गो क्‍यारी पाइब मनकी। ");
INSERT INTO suzBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","गो १२ लोक्‍ब, आफ का आ तौ नकी। का मुल मबाक्‍ब, कान्‍छा कनान रागीम आफ नु बाक्‍ब’ दे माइक्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","मिनु मेको रागी ङा ठेयब मुरुम आंइ कली ‘गो दोपा तुइक्‍नुङा, गे ठीक मुर बाक्‍नीनी, दे इन लोक्‍ब का गो नु बाक्‍चा माल्‍ब। अरु चहिं अन्‍कालम जचा कली अन्‍न कुरशा, खिं लेश्‍शा लने। उत्‍पत्ती ४२:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","मिनु इन लोक्‍ब कान्‍छा कली एक चाक्‍कीन। मेको नोले ला गेपुकी क्‍यारी पाइब मननी, दे तुइक्‍नुङ। मेना इन लोक्‍ब कली प्रोंइशा, लचा गेनुङ’ दे माइक्‍तीकी” दे आन आफ कली देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","मिनु नोले आन धोक्रो रोक्‍शा, नेल्‍लेमी आन थाप्‍शो क्‍येट आन धोक्रोमी थित्‍मे बाक्‍त। मिनु मेकोपुकी नु आन आफ मेको क्‍येट तशा, हिंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","मिनु आन आफ याकूबमी “गे आं आल कली रोइक्‍ब बाक्‍नीनी। योसेफ लत। सिमियोन लत। मुल बेन्‍यामीन लाइक्‍चा माल्‍नीनी। एको नेल्‍ल आं कली श्‍येत गेचा कली बाक्‍ब” दे आ तौ आन कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","मिनु रूबेनमी “गो बेन्‍यामीन ठीक पा मलेत्‍ताक्‍ङ हना, आं तौ निक्‍शी आस कली सतीन” दे आ आफ कली मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","मेकोमी “आं तौ गे नु लचा मगेनुङ। आ लोक्‍ब बेक्‍त, आ का ला बाक्‍ब। मेको कली लांमी मार मार दुम्‍ने चाप्‍ब। बेक्‍त हना, गेपुकीमी चां बोइश्‍शो आं कली ठेयब श्‍येत जपाइश्‍शा तुरसुम वोइक्‍चा माल्‍नीनी” दे याकूबम आ तौ आन कली माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","मिनु मेको रागीमी अन्‍काल बारना बारन ल‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","मिनु आन इजीप्‍त रे चाक्‍शो अन्‍न नेल्‍ल नुप्‍शा, आन आफोमी मेको आन कली “लेंशा इच्‍का जचा थोव़क ग्‍याप्‍थ लने” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","मिनु यहूदामी “मेको ठेयब मुरुमी ‘गे इन लोक्‍ब कान्‍छा मचाक्‍तीनी हना, आं कली ग्रुम्‍थ मजाक्‍कीन’ दे आंइ कली हुइक्‍ताक्‍व। उत्‍पत्ती ४२:१५-३४ ");
INSERT INTO suzBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","गे आंइ लोक्‍ब कान्‍छा कली गोपुकी नु सोइक्‍ताक्‍नी हना, ला लाइनीकी। ");
INSERT INTO suzBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","गे मेको कली गो नु मसोइक्‍ताक्‍नी हना, मलाइनीकी। मारदे हना मेको ठेयब मुरुमी ‘गे इन लोक्‍ब कान्‍छा मचाक्‍तीनी हना, आं कली ग्रुम्‍थ मजाक्‍कीन’ दे आंइ कली हुइक्‍ताक्‍व” दे आ आफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","मिनु इस्राएलमी “मारदे मेको मुर कली ‘आंइ लोक्‍ब कान्‍छा बाक्‍ब’ दे शेंदीनी? मिनु आं कली ओदेंशो मरिम्‍शो पाइय्‍यीनी” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","मिनु मेकोपुकीमी “मेको ठेयब मुरुमी ‘इन आफ मुल सम्‍म ब्रोंइशो बाक्‍बा? अर्को लोक्‍ब यो बाक्‍बा?’ दे आंइ कली खिं ङा मुर आन पर्बम शुश हिल्‍लो पाप्‍तु। मिनु गोपुकीमी मेकोन देंतक। ‘इन लोक्‍ब कान्‍छा चाक्‍कीन’ देंब, दे गो दोपा तुइक्‍नीकी?” दे आन आफ कली देंमा बाक्‍त। उत्‍पत्ती ४२:७-१३ ");
INSERT INTO suzBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","मिनु यहूदामी “कान्‍छा गो नु सोइक्‍तीन। गे गो नु इं आइक्‍च आल यो मबेक्मल, दे गो लाइनीकी। ");
INSERT INTO suzBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","गो एको आ जमानी दुम्‍नुङ। गो लेश्‍शा जाक्‍ङा‍नु, गो एको कली चाक्‍शा, इन ङोंइती मवोइक्‍ता हना, गेना हना यो आं पाप लील। ");
INSERT INTO suzBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","गो एको कली रिम्‍शा मबाक्‍शो नकी हना, गो खेयप निक्‍शी लने पिने थुम्‍क वा” दे आ आफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","मिनु आन आफ इस्राएलमी “मुल मो दुम्‍चा माल्‍शो बाक्‍त हना, गे मेको ठेयब मुर कली इं रागी ङा नेल्‍ल क्‍येङा रिम्‍शो फल, इच्‍का ख्रेक्‍तीक तेल, इच्‍का खुदो, मस्‍लापुकी, ब्रोव़शो रिना पाइब थोव़क, फोरो नु देसी बदाम कोसेली लतीन। हितोपदेस १८:१६ ");
INSERT INTO suzBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","मिनु इन क्‍येट नु ङोंइती ङा इन धोक्रोम बाक्‍शो क्‍येट यो लतीन। प्रेंशा मो दुम, कों? मार दुम्‍मे? उत्‍पत्ती ४२:२७, ३५ ");
INSERT INTO suzBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","इन लोक्‍ब कान्‍छा लाइश्‍शा, मेको ठेयब मुर कली लेंशा ग्रुम्‍थ लने। ");
INSERT INTO suzBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभुमी मेको मुर आ ङोंइती इन कली शिशी गेवल। मिनु इन अर्को लोक्‍ब नु बेन्‍यामीन यो सोइक्‍तल। गो श्‍येत जचान माल्‍शो बाक्‍ती हना यो, श्‍येत जङल” दे आ तौ आन कली माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","मिनु आ तौपुकीमी मेको कोसेली, ङोंइती ङा क्‍येट, अर्को क्‍येट नु बेन्‍यामीन लाइश्‍शा, इजीप्‍त रागी लशा, योसेफ आ ङोंइती जाक्‍दीम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","मिनु योसेफमी मेकोपुकी नु बेन्‍यामीन कली तशा, आ खिं ङा ठेयब गेय पाइब मुर कली “मेको मुर आन कली आं खिं लाइक्‍मी। बस्‍तु का क्‍योरशा, भोज ठीक पावो। मारदे हना मुलाक्‍ती मेकोपुकी गो नु जाइनीम” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","मिनु मेको मुरुम योसेफ आ देंशो पशा, नेल्‍ल आन कली योसेफ आ खिं ओंइदीमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","मेकोपुकी चहिं हिंमा बाक्‍त, मारदे हना योसेफ आ खिं आगा ओंइदीमी बाक्‍त। मिनु मेकोपुकीमी “मारदे हना इं ङोंइती ङा क्‍येट इं धोक्रोम थित्‍तय। मिनु इं कली वाइल सेल्‍चा नु इं गधा रोइक्‍चा कली इं कली एके ओंइताक्‍मे” देंमुमा बाक्‍त। उत्‍पत्ती ४२:२८ ");
INSERT INTO suzBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","मिनु योसेफ आ खिं ङा ठेयब गेय पाइब आ नेक्‍था लशा, लाप्‍चो रे मेको नु लोव़ पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","मिनु “हजुर, गोपुकी ङोंइती खेयप का जचा थोव़क ग्‍याप्‍थ जाक्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","मिनु गोपुकी बास बाक्‍तीके जाक्‍दीश्‍शा, आंइ धोक्रो रोक्‍शा, कोव़कानु, आंइ क्‍येट नेल्‍ल आंइ धोक्रो धोक्रोम थित्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","मुल गो लेंशा चाक्‍तक। अर्को जचा थोव़क ग्‍याप्‍चा कली यो क्‍येट चाक्‍तक। सुम आंइ क्‍येट आंइ धोक्रोम कुर पवा, गो मतुइक्‍नीकी” दे ठेयब गेय पाइब कली देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","मिनु मेकोमी “इन थुं नाइक्‍तीने, महिनीने। इन परमप्रभु, इन आफ आ परमप्रभुमी इन क्‍येट इन धोक्रोम कुर पवा माइ। गो इन क्‍येट ताक्‍ता” देंमाक्‍त। मिनु मेकोमी सिमियोन कली चाक्‍गा बाक्‍त। उत्‍पत्ती ४२:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","मिनु मेको मुरुम मेको आन कली योसेफ आ खिं ओंइशा, खोइल चिक्‍चा कली ब्‍वाक्‍कु गेवा बाक्‍त। आन गधा आन कली थुला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","मिनु नाक्‍ती दुम्‍चा चिक्‍तानु, मेको नु काथा जचा माल्‍ब देंशो नेंशा, आन कोसेली गेचा कली ठीक पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","मिनु योसेफ जाक्‍मेनु, मेकोपुकीमी आन कोसेली लाङगा रे ओंइशा, मेको आ ङोंइती वोइश्‍शा, खुम्‍की पा बाप्‍शा ख्रेत्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","मिनु योसेफमी मेको आन कली “दोपा बाक्‍नी? इन आफ, इन देंशो खाल्‍पा, रिम्‍शो बाक्‍मे? मुल सम्‍म ब्रोंइमे?” दे हिल्‍लो पामी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","मिनु मेकोपुकीमी “इन गेय पाइब आंइ आफ मुल सम्‍म ब्रोंइशो नु रिम्‍शो बाक्‍ब” देंशा, आन पिया खुक्‍शा, सेउ पामे बाक्‍त। उत्‍पत्ती ३७:७,९ ");
INSERT INTO suzBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","मिनु योसेफमी आ लोक्‍ब बेन्‍यामीन, आ ममा आ तौ तशा “इन देंशो इन लोक्‍ब कान्‍छा एकोन बाक्‍बा?” देंशा, बेन्‍यामीन कली “परमप्रभुमी इ कली शिशी पवल, आं तौ” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","मिनु योसेफमी आ लोक्‍ब तशा, ग्‍येरसीशा ङाक्‍चा कली ते लङ, दे आ कोठा लशा ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","मिनु आ कुल चिक्‍शा, लेम्‍माक्‍त। मिनु गेय पाइब आन कली “शोब्‍ले ख्रेत्‍तीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","मिनु योसेफ, आ लोक्‍ब नु मेको नु जाइब इजीप्‍त ङा मुर नेल्‍ल आन कली आन पेवा पेवा जचा थोव़क ख्रेत्‍मे बाक्‍त। मारदे हना इजीप्‍त ङा मुर हिब्रू नु जचा मदुम्‍बाक्‍माक्‍त। इजीप्‍त ङा मुरपुकी ग्रांग्रा दीबाक्‍मा बाक्‍त। उत्‍पत्ती ३९:६; उत्‍पत्ती ४६:३४; प्रस्‍थान ८:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","मिनु योसेफमी आ लोक्‍ब आन कली ङोंइती जरमेशो, माइला, साइला पा कान्‍छा सम्‍म गार पा निप्‍पदा बाक्‍त। मिनु मेकोपुकी छक लाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","मिनु योसेफ आ ङोंइती रे जचा ब्‍वचा थोव़क लाइश्‍शा, मेको आन कली ख्रेप्‍पदा बाक्‍त। बेन्‍यामीन आ भाग अरु आन क्‍येङा ५ भाग खोइ शुश बाक्‍माक्‍त। मिनु मेकोपुकी योसेफ नु जशा तूशा, ग्‍येरशा बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","मिनु योसेफमी आ खिं ङा ठेयब गेय पाइब कली “मेको मुर आन धोक्रो प्रिंपतो। गिश कुरने चाप्‍नीमी, मिश प्रिंपतो। मिनु आन क्‍येट अन्‍न आ शोव़म वोतो। ");
INSERT INTO suzBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","मिनु आं चांदी के कचौरा, आ क्‍येट नु मेको नेल्‍ल क्‍येङा ठिटा आ धोक्रो आ शोव़म वोतो” दे मदा बाक्‍त। मिनु मेकोमी योसेफ आ देंशो खोदेंशो पा पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","मिनु सुनी कना रिम्‍शो पा नां मसोव़थु, मेको मुर नु आन गधा आन कली लचा गेमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","मिनु सहर रे लमानु, योसेफम आ ठेयब गेय पाइब कली “बोक्‍को, मेको आन नोले खोतो। मिनु मेको आन कली थिश्‍शा ‘मारदे गे रिम्‍शो पाइब कली मरिम्‍शो पनी? ");
INSERT INTO suzBl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","मारदे आं प्रभु आ मार मार तूतीक नु लिंक्‍यु कोव़तीक चांदी के कचौरा खुइ पनी? गे मरिम्‍शो पाइतीनी’ दे माइक्‍मी” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","मिनु मेको आन कली थिश्‍शा, मोदेंशो लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","मिनु मेकोपुकीमी “आंइ प्रभुम मारदे मोदेंशो लोव़ पाइबा? गो मो मपक। ");
INSERT INTO suzBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","नेनीन, आंइ धोक्रोमी थिश्‍शो क्‍येट कनान रागी रे लेंशा चाक्‍तक। गो दोपा इन प्रभु आ खिं रे सुन चांदी खुइ पाइनीकी? उत्‍पत्ती ४३:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","गो इन गेय पाइब सु नु मेको कचौरा बाक्‍मे, मेको बेक्‍ल। मिनु गोपुकी यो इन वाइल दुम्‍कल” दे मदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","मिनु मेकोमी “इन देंशो खोदेंशो दुम्‍ल। सु आ धोक्रोम थिंसीबा, मेको आं वाइल दुम्‍ब। अरु मो लाइनीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","मिनु नोले मेकोपुकीमी रीब रीब पा आन धोक्रो गधा रे शोल्‍शा, रोक्‍शा कोव़ङमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","मिनु मेकोमी ङोंइती जरमेशो आ धोक्रोमी, नोले नेल्‍ल आन धोक्रोमी का का पा माल्‍शा, कान्‍छा ला लीमाक्‍त। मिनु कचौरा बेन्‍यामीन आ धोक्रोमी थिदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","मिनु मेकोपुकीमी आन वा खाक्‍शा, आन अन्‍न लेंशा गधा तार वोइश्‍शा, सहर लेम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","मिनु यहूदा नु आ लोक्‍बपुकी योसेफ आ खिं जाक्‍मानु, योसेफ मेक उइ बाक्‍माक्‍त। मेको आ ङोंइती खुम्‍की पा बाम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफम मेको आन कली “गे मार पनी? आं खोदेंशो मुरुम नेल्‍ल तुइक्‍ब, दे मतुइक्‍तीनी?” दे मेको आन कली हुइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","मिनु यहूदामी “आंइ प्रभु कली मार देंनीकी? मार लोव़ पाइनीकी? गोपुकी ‘ठीक मुर बाक्‍नीकी’ दे दोपा देंने चाप्‍नीकी? परमप्रभुमी इन गेय पाइब आन मरिम्‍शो कोंइताक्‍व। नेनीन, गोपुकी नु कचौरा धोक्रोम बाक्‍ब, गो नेल्‍ल आंइ प्रभु इन वाइल दुम्‍तक” देंमाक्‍त। उत्‍पत्ती ४२:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","मिनु योसेफमी “ममाइ, मेको मपाइनुङ। तन्‍न सु मुर नु आं कचौरा बाक्‍मे, मेको ला आं वाइल दुम्‍चा माल्‍ब। गेपुकी चहिं थुं नाइश्‍शा, इन आफ आ बाक्‍तीक लने” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","मिनु यहूदा मेको आ नेक्‍था लशा “आं प्रभु, लोव़ का पचा गेयीनी। इन गेय पाइब आ पर्बम मगाइक्‍तीने। गे फाराओ खोदेंशो बाक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","आं प्रभुमी ङोंइती आ गेय पाइब आन कली ‘इन के आफ बाक्‍बा? अर्को लोक्‍ब यो बाक्‍बा?’ दे हिल्‍लो पाइतीनी। उत्‍पत्ती ४२:७,१३; उत्‍पत्ती ४३:७ ");
INSERT INTO suzBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","मिनु गोपुकीमी आंइ प्रभु कली ‘आंइ के आफ खाल्‍पा दुम्‍शो बाक्‍ब। मिनु खाल्‍पाम थिशो तौ का यो बाक्‍ब। मेको आ लोक्‍ब चहिं बेक्‍त। मेको लीशो आ ममा आ का ला तौ बाक्‍ब। मिनु आ आफोमी मेको कली शुश दाक्‍ब’ दे इन कली देंतक। ");
INSERT INTO suzBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","मिनु गेमी ‘आं कली कोंइचा कली मेको एक चाक्‍कीन’ देंतीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","गोपुकीमी आंइ प्रभु कली ‘मेको वोंइश आलमी आ आफ कली प्रोंइने मचाप्‍ब। प्रोंइतु हना, आ आफ बेक्‍ब’ देंतक। ");
INSERT INTO suzBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","मिनु गेमी इन गेय पाइब आन कली ‘इन लोक्‍ब कान्‍छा मचाक्‍तीनी हना, गे आं कली ग्रुम्‍थ मपिने’ देंतीनी। उत्‍पत्ती ४२:१५; उत्‍पत्ती ४३:३-५ ");
INSERT INTO suzBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","गोपुकी आंइ आफ इन गेय पाइब आ बाक्‍तीके जाक्‍दीश्‍शा, इन लोव़ नेल्‍ल माइक्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","आंइ आफोमी ‘लेंशा जचा थोव़क ग्‍याप्‍थ लने’ देंत। ");
INSERT INTO suzBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","मिनु गोपुकीमी ‘आंइ लोक्‍ब कान्‍छा मलाइक्‍तक हना, गो लने मचाप्‍नीकी। मारदे हना आंइ कान्‍छा भाइ गोपुकी नु मलत हना, ग्रुम्‍चा मदुम्‍ब’ देंतक। ");
INSERT INTO suzBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","मिनु इन गेय पाइब आंइ आफोम आंइ कली ‘आं मीशेम तौ निक्‍शी थिप्‍तु, गे तुइक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","का आं बाक्‍तीक रे लत। जन्‍तुमी मेको कली ब्‍वाम्‍तेक्‍मे। गो मेको कली लेंशा मतङ। उत्‍पत्ती ३७:३२-३३ ");
INSERT INTO suzBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","मिनु गे एको कली यो लाइक्‍तीनी हना, लांम बेक्‍बा कों, बेक्‍त हना, गे आं बोइश्‍शो चां श्‍येतम प्रिंशा, तुरसुम वोइक्‍चा माल्‍नीनी’ दे लोव़ पाप्‍तु। उत्‍पत्ती ४२:३८ ");
INSERT INTO suzBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","मिनु गो इन गेय पाइब आंइ आफ आ बाक्‍तीक जाक्‍दी‍कानु, एको वोंइश आल, आ आफ आ थुं नेल्‍लेमी दाक्‍ब। मोपतीके गोपुकी नु मबाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","मेको तशा, आ आफ बेक्‍ब। मिनु गोपुकीमी आंइ आफ, चां बोइश्‍शो इन गेय पाइब कली सुर्ता पपाइश्‍शा, श्‍येत जपाइश्‍शा तुरसुम वोइक्‍चा माल्‍नीकी। ");
INSERT INTO suzBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","गो मेको आ जमानी बाक्‍शो बाक्‍नुङ। गो आफ कली ‘मेको आल मचाक्‍ता हना, आं मरिम्‍शो पशो गेना हना यो आं तारी लील’ देंती। उत्‍पत्ती ४३:९ ");
INSERT INTO suzBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","मोपतीके एको वोंइश आल ममाइ, आं प्रभु, आं कली इन वाइल वोतीन। एको वोंइश आल आ लोक्‍बपुकी नु लचा गेने। ");
INSERT INTO suzBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","गो आं आफ आ ङोंइती एको वोंइश आल मलाइक्‍थु, दोपा लने चाप्‍नुङा? आं आफ आ श्‍येत तशा, गो यो फाल्‍ने मचाप्‍नुङ” दे यहूदामी योसेफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","मिनु नोले योसेफमी आ मुर नेल्‍ल आन ङोंइती फाल्‍ने मचबा बाक्‍त। मिनु “आं गेय पाइब नेल्‍ल एकेर रे लने” दे सोइक्‍पदा बाक्‍त। मिनु योसेफमी आंम कली आ लोक्‍ब आन कली तुइक्‍पदानु, कोठामी सुइ मबाक्‍शो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","मिनु ठेयब सेंदामी ङाक्‍मेनु, फाराओ आ खिंम बाक्‍ब इजीप्‍त ङा मुर नेल्‍लेम नेन्‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","मिनु योसेफमी आ लोक्‍ब आन कली “गो योसेफ नङ। आं आफ मुल सम्‍म ब्रोंइमे?” देंमाक्‍त। आ लोक्‍बपुकीमी लोव़ लेन्‍ने मचाप्‍मे बाक्‍त। मारदे हना शुश हिंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","मिनु योसेफमी आ लोक्‍ब आन कली “आं नेक्‍था पिने” देंमाक्‍त। मिनु मेकोपुकी आ नेक्‍था जाक्‍मा बाक्‍त। मिनु योसेफमी “गो इन इजीप्‍त रागीम लेयशो लोक्‍ब योसेफ नङ। ");
INSERT INTO suzBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","गे आं कली लेयशो आ पर्बम सुर्ता मपने। आंम कली दोस मगेने। मारदे हना परमप्रभुमी आं कली नेल्‍ल ब्रोंइमल, दे इन ङोंइती सोइश्‍शो बाक्‍त। उत्‍पत्ती ५०:२० ");
INSERT INTO suzBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","एको अन्‍काल मुल बर्स निक्‍शी दुम्‍त। मिनु मुल ५ बर्स सम्‍म तेइ वाक्‍शो नु रिक्‍शो मतांइसीब। ");
INSERT INTO suzBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","परमप्रभुमी आं कली गेपुकी ब्रोंइनील। रागीम जात का लीनील। इन पर्बम शुश ब्रोंइमल, दे इन क्‍येङा ङोंइती एक सोइक्‍ताक्‍यी। एको ठेयब श्‍येत रे प्रोंइतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","मोपतीके गेपुकीमी आं कली एक सोइश्‍शो ममाइ, परमप्रभुमी सोइश्‍शो बाक्‍त। मेकोमी आं कली फाराओ आ आफ खोदेंशो सेल्‍शा, आ खिं ङा होव़प नु इजीप्‍त रागी नेल्‍ल ङा हुकुम पाइब सेल्‍ती। ");
INSERT INTO suzBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","गेपुकी मुल रीब पा इं आफ आ बाक्‍तीके लने। मिनु मेको कली ‘परमप्रभुमी इन तौ योसेफ कली इजीप्‍त रागी नेल्‍ल ङा ठेयब मुर सेला बाक्‍त। एक यिचा मरिम्‍दीन। ");
INSERT INTO suzBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","आं नेक्‍था बाक्‍चा कली गे, इन आल, इन चच, इन क्‍यारश भेडा, बी ब्‍यफ नु मारेइ मारेइ नेल्‍ल चाक्‍शा, गोशेन माइक्‍तीकेमी जाक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","आं नेक्‍था बाक्‍कीन। गो इन कली थुल्‍नुङ। मारदे हना अन्‍काल मुल ५ बर्स सम्‍म दुम्‍ब। गे मयीतीनी हना, गे, इन खिं ङा मुर नु गेपुकी नु बाक्‍ब नेल्‍ल शुश प्रुङग दुम्‍नीनी’ देंत, दे इं आफ कली माइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","मिनु गेपुकी नु आं लोक्‍ब बेन्‍यामीनम तशो ‘गो योसेफ नङ। गो इन कली लोव़ पाता’ दे तुइक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","गो इजीप्‍त रागीमी गिश रिम्‍शो बाक्‍ङा, इन तशो नेल्‍ल, गेपुकीमी इं आफ कली देंचा माल्‍नीनी। रीब पा इं आफ कली एक चाक्‍कीन” दे आ लोक्‍ब आन कली माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","मिनु आ लोक्‍ब बेन्‍यामीन कली मुप्‍शा ङाक्‍माक्‍त। मिनु बेन्‍यामीन यो ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","मिनु नोले आ लोक्‍ब नेल्‍ल आन कली मुप्‍शा, पुक्‍पु पाइश्‍शा ङाक्‍माक्‍त। मिनु नोले आ लोक्‍बपुकीमी लोव़ पचा गोव़मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","मिनु “योसेफ आ लोक्‍बपुकी जाक्‍तेक्‍म” देंशो लोव़ फाराओ आ खिंम यो जाक्‍दीम्‍माक्‍त। मिनु फाराओ नु आ गेय पाइब नेल्‍ल ग्‍येरसमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","मिनु फाराओमी योसेफ कली “गेमी इन लोक्‍ब आन कली ‘इन गधापुकीमी अन्‍न कुरपाइश्‍शा, कनान रागी लने। ");
INSERT INTO suzBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","मिनु इन आफ नु इन खिं ङा मुर नेल्‍ल आं नेक्‍था जाक्‍कीन। गो इजीप्‍त रागी ङा नेल्‍ल क्‍येङा रिम्‍शो रू इन कली गेनुङ। मिनु गे रागी ङा नेल्‍ल क्‍येङा ब्रोव़शो जचा ताइनीनी’ दे माइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","इन कली अरेशो एकोन बाक्‍ब। इन आइक्‍च आल नु इन मीश आन कली ङोइक्‍चा कली इजीप्‍त रागी रे बग्‍गीपुकी लतीन। इन आफ चाक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","‘इन मारेइ मारेइ ममिम्‍तीन। मारदे हना इजीप्‍त ङा रिम्‍शो नेल्‍ल इन के बाक्‍ब’ दे माइक्‍मी” दे योसेफ कली मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","मिनु इस्राएल आ तौपुकीमी योसेफ आ देंशो पामे बाक्‍त। मिनु फाराओम मार देंमे मेको पा, योसेफमी मेको आन कली बग्‍गी नु लां कली लाम्‍जी गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","मेको आन कली जोड का का फेक्‍तीक नक वा गेवा बाक्‍त। बेन्‍यामीन कली चहिं सहे सां चांदी के शेकेल नु ५ जोड फेक्‍तीक वा गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","मिनु आ आफ कली १० ओटा गधैनीमी इजीप्‍त रागी ङा नेल्‍ल क्‍येङा ब्रोव़शो जचा थोव़क नु लांम जचा कली १० ओटा गधाम अन्‍न, शोब्‍ले नु श्‍ये कुर पा सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","मिनु लचा ङोंइती मेको आन कली “लांमी मजिने” दे अरेवा बाक्‍त। उत्‍पत्ती ४२:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिनु मेकोपुकी इजीप्‍त रागी रे पा कनान रागी आन आफ याकूब आ बाक्‍तीके जाक्‍दीम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","मिनु आन आफ कली “योसेफ मुल यो ब्रोंइशो बाक्‍त। इजीप्‍त रागीम हुकुम पाइब मेको बाक्‍माक्‍त” दे लोव़ पामे बाक्‍त। याकूबम चहिं आन देंशो थमा मसुदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","मिनु मेकोपुकीमी योसेफ आ लोव़ नेल्‍ल शोव़ङमे बाक्‍त। मिनु याकूबम आ कली ङोइक्‍चा, दे योसेफमी सोइश्‍शो बग्‍गी तशा, आ थुं लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","मिनु इस्राएलमी “आं तौ योसेफ ब्रोंइशो थमा बाक्‍ब। आं बेक्‍चा क्‍येङा ङोंइती मेको आ कुल कोव़नुङ” देंमाक्‍त। उत्‍पत्ती ४६:३० ");
INSERT INTO suzBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","मिनु इस्राएल नु आ खिं ङा मुर नेल्‍ल इजीप्‍त गे लमा बाक्‍त। मिनु बेयर-शेबा जाक्‍दीश्‍शा, आ आफ इसहाक आ परमप्रभु कली चढ़ेवा बाक्‍त। उत्‍पत्ती २६:२३-२५ ");
INSERT INTO suzBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","मिनु मेको नाक्‍दो परमप्रभुमी इस्राएल कली “याकूब, याकूब” देंमाक्‍त। मिनु इस्राएलमी “गो नेंता” दे लोव़ लेत्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","मिनु परमप्रभुमी “गो परमप्रभु, इ आफ आ परमप्रभु नङ। इजीप्‍त लचा महिनो। मारदे हना गे उइ बाक्‍ङेनु, इ रे पा ठेयब जात सेल्‍नुङ। उत्‍पत्ती ४७:२७; प्रस्‍थान १:७ ");
INSERT INTO suzBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","गो गे नु इजीप्‍त रागी लाइनुङ। मिनु इ कली थमा पा लेप्‍पाइक्‍नुङ। बेक्‍शा नोले योसेफमी इ मिक्‍च ख्रेप्‍ब” दे परमप्रभुमी देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","मिनु याकूब बेयर-शेबा रे लमाक्‍त। मिनु इस्राएल आ तौपुकीमी आन आफ, आन आइक्‍च आल नु आन मीश फाराओमी सोइश्‍शो बग्‍गीम ङोइक्‍पदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","मिनु आन बस्‍तु भाव, कनान रागीम आन चाक्‍शो मारेइ मारेइ नु याकूब नु आ मुर नेल्‍ल इजीप्‍त रागी जाक्‍दीम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकूबमी आ तौपुकी नु मेको आन तौपुकी, आ तमीपुकी नु आ तौ आन तमीपुकी नु चच युइ नेल्‍ल इजीप्‍त रागी चाक्‍दीम्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","मिनु इजीप्‍त रागीम जाक्‍दीश्‍शो इस्राएल आ आल आन नें एको बाक्‍नीमी। आ ङोंइती जरमेशो तौ रूबेन बाक्‍माक्‍त। प्रस्‍थान ६:१४-१६ ");
INSERT INTO suzBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेन आ तौपुकी हनोक, फल्‍लु, हेस्रोन नु कारमी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","सिमियोन आ तौपुकी येमुएल, यामीन, ओहद, याकीन नु सोहार, कनान ङा मीश रे जरमेशो शावल, नेल्‍ल सिमियोन आ तौ बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी आ तौपुकी गेरशोन, कोहाथ नु मेरारी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा आ तौपुकी एर, ओनान, शेलाह, पेरेस नु जेराह बाक्‍मा बाक्‍त। एर नु ओनान चहिं कनान रागीम बेक्‍सा बाक्‍त। पेरेस आ तौ हेस्रोन नु हामुल बाक्‍सा बाक्‍त। उत्‍पत्ती ३८:३,४,२९,३० ");
INSERT INTO suzBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्‍साकार आ तौपुकी तोला, पुवा याशुब नु शिम्रोन बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून आ तौपुकी सेरेद, एलोन नु याहलेल बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","मेको नेल्‍ल लेआमी याकूब के पदान-अराममी थिशो तौ बाक्‍मा बाक्‍त। आ तमी दीना यो बाक्‍माक्‍त। याकूब नु आ तमी तौ नेल्‍ल पा ३३ जना बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","मिनु गाद आ तौपुकी सिफ्‍‍योन, हाग्‍गी, शुनी, एस्‍बोन, एरी, अरोदी नु अरेली बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर आ तौपुकी इम्‍नाह, इश्‍वाह, इश्‍वी, बेरीआ नु आ तमी सेराह बाक्‍मा बाक्‍त। मिनु बेरीआ आ तौ निक्‍शी हेबेर नु माल्‍कीएल बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","मिनु लाबान आ तमी लेआ कली गेशो गेय पाइब जिल्‍पाम याकूब के थिशो तौपुकी बाक्‍मा बाक्‍त। मेको १६ जना बाक्‍मा बाक्‍त। उत्‍पत्ती २९:२४ ");
INSERT INTO suzBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","मिनु याकूब आ मीश राहेल आ तौ योसेफ नु बेन्‍यामीन बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","योसेफमी इजीप्‍त रागीमी मनस्‍से नु एफ्राइम थि‍माक्‍त। आ मीश ओन सहर ङा नाक्‍सो पोतीफेरा आ तमी आसेनाथ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बेन्‍यामीन आ तौपुकी बेला, बेकेर, अश्‍बेल, गेरा, नामान, एही, रोश, मुप्‍पीम, हुप्‍पीम नु आरद बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","मेको नेल्‍ल राहेल आ थिशो तौ बाक्‍मा बाक्‍त। मेको नेल्‍ल पा १४ जना बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दान आ तौ हुशीम बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नाप्‍ताली आ तौपुकी याहसेल, गुनी, येसेर नु शिल्‍लेम बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","मेको लाबानमी आ तमी राहेल कली गेशो गेय पाइब बिल्‍हाहम याकूब के थिशो तौ बाक्‍मा बाक्‍त। मेको नेल्‍ल ७ जना बाक्‍मा बाक्‍त। उत्‍पत्ती २९:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","मिनु याकूब आ चाइमीपुकी महिक्‍थु, याकूब नु इजीप्‍त रागी जाक्‍शो मुर नेल्‍ल पा ६६ जना बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","इजीप्‍त रागीमी योसेफमी तौ निक्‍शी थि‍माक्‍त। मोपा इजीप्‍त रागीमी जाक्‍शो याकूब आ खिं ङा मुर ७० जना बाक्‍मा बाक्‍त। याकूब नु योसेफ नु आ तौ निक्‍शी यो हिक्‍शो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","मिनु याकूबमी यहूदा कली गोशेन लां शेंसीचा नु योसेफ ग्रुम्‍चा, दे आन ङोंइती ग्रुम्‍थ सोइक्‍ता बाक्‍त। मिनु मेकोपुकी गोशेन माइक्‍तीके जाक्‍दीम्‍मानु, उत्‍पत्ती ४५:१० ");
INSERT INTO suzBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफ आंम बग्‍गी ठीक पा आ आफ इस्राएल कली गोशेनम ग्रुम्‍थ जाक्‍माक्‍त। मिनु मेको कली ग्रुम्‍शा, मुप्‍शा शुश ङाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","मिनु इस्राएलमी योसेफ कली “मुल गो बेक्‍ने चाप्‍नुङ। मारदे हना गे ब्रोंइशो बाक्‍ते, गो इ कुल कोव़चा ताता” दे आ तौ कली देंमाक्‍त। उत्‍पत्ती ४५:२८ ");
INSERT INTO suzBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","मिनु योसेफम आ लोक्‍ब नु आ आफ आ खिं ङा मुर आन कली “गो फाराओ आ बाक्‍तीके लाइनुङ। मिनु मेको कली ‘कनान रागीम बाक्‍शो आं आफ, आं लोक्‍बपुकी नु आं आफ आ खिं ङा मुर नेल्‍ल जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","मेकोपुकी भेडा गोठला नु बस्‍तु भाव थुल्‍ब बाक्‍नीम। मेको आन क्‍यारश भेडा, बी ब्‍यफ नु आन मारेइ मारेइ चाक्‍शो बाक्‍तेक्‍मे’ देंनुङ। ");
INSERT INTO suzBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","मिनु फाराओम इन कली ब्रेत्‍ताक्‍व हना, मिनु इन कली इन गेय आ पर्बम हिल्‍लो पाप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","गेपुकीमी ‘इन गेय पाइब आन आल रेन मुल सम्‍म बस्‍तु भाव थुल्‍ब बाक्‍नीम। आंइ किकी पिपी यो मोदेंशो गेय पशो बाक्‍मा बाक्‍त’ देंचा माल्‍नीनी। नोले मेकोमी इन कली गोशेनमी बाक्‍तीके गेब। मारदे हना इजीप्‍त ङा मुर गोठला आन कली तशा ग्रांग्रा दीनीम” दे योसेफमी आ लोक्‍ब आन कली देंमाक्‍त। उत्‍पत्ती ४३:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","मिनु नोले योसेफमी फाराओ कली “आं आफ, आं लोक्‍बपुकी, आन क्‍यारश भेडा, बी ब्‍यफ, आन मारेइ मारेइ नेल्‍ल कनान रागी रे चाक्‍शा, गोशेनमी जाक्‍शो बाक्‍नीमी” दे शेंदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","मिनु आ लोक्‍ब आन दाते रे ५ जना योव़शा, फाराओ आ ङोंइती राप्‍पदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","मिनु फाराओमी मेको आन कली “इन गेय मार बाक्‍बा?” दे हिल्‍लो पवा बाक्‍त। मिनु मेकोपुकीमी “गो, इन गेय पाइबपुकी, भेडा गोठला बाक्‍नीकी। गो आंइ किकी पिपी रे गोठला बाक्‍तक” दे फाराओ कली देंमा बाक्‍त। उत्‍पत्ती ४६:३३-३४ ");
INSERT INTO suzBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","मिनु लेंशा “कनान रागीमी ठेयब अन्‍काल दुम्‍तीके, गो अर्को रागी ङा मुर दुम्‍शा, एक बाक्‍थ जाक्‍तक। मारदे हना आंइ क्‍यारश भेडा आन कली जोतीके मबा। मोपतीके आंइ कली गोशेन माइक्‍तीकेमी बाक्‍चा गेने, दे पुंइनीकी” दे पुंइदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","मिनु फाराओम योसेफ कली “इ आफ नु इ लोक्‍बपुकी इ बाक्‍तीक रागी जाक्‍तेक्‍मे। ");
INSERT INTO suzBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","इजीप्‍त रागी इ रागी खोदेंशो मिम्‍तो। नेल्‍ल क्‍येङा रिम्‍शो जोतीके गोशेनमी मेको आन कली बाक्‍पतो। मिनु मेको इ मुर आन दातेमी रिम्‍शो गेय पाइब बाक्‍तेक्‍म हना, आं बस्‍तु भाव आन कली यो कोव़पतो” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","मिनु नोले योसेफमी आ आफ कली फाराओ आ ङोंइती राप्‍पदा बाक्‍त। मिनु याकूबमी फाराओ कली आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","मिनु फाराओमी “गिश बर्स दुम्‍नी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","मिनु याकूबमी “गो मुल सम्‍म रागीम बाक्‍शो, सहे का ३० बर्स दुम्‍ती। आं किकी पिपी खोदेंशो पा शुश बर्स मदुम्‍ङ। गो मरिम्‍शो नाक्‍त यो ताता” देंमाक्‍त। हिब्रू ११:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","मिनु आसीक गेशा, फाराओ रे लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","मिनु योसेफमी फाराओ आ दें‍शो खोदेंशो पा आ आफ नु आ लोक्‍ब आन कली इजीप्‍त रागीमी रू गेवा बाक्‍त। रागी ङा नेल्‍ल क्‍येङा रिम्‍शो बाक्‍तीके रामे‍सेस आ रागी गोशेनमी बाक्‍पाइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","मिनु योसेफम आ आफ, आ लोक्‍ब नु आ आफ आ खिं ङा मुर नेल्‍ल आन कली आन खिं खिं कली गाप्‍चा ङा पा जचा थोव़क गेशा थुल्‍मी बाक्‍त। उत्‍पत्ती ४५:११ ");
INSERT INTO suzBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","रागी नेल्‍लेमी जचा थोव़क मथिदमे बाक्‍त। मारदे हना मेको अन्‍काल बारना बारन ल‍माक्‍त। मिनु इजीप्‍त नु कनान रागी ङा मुर शुश श्‍येत जामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिनु योसेफमी इजीप्‍त नु कनान रागी ङा अन्‍न ग्‍याप्‍थ जाक्‍ब आन गुइ रे क्‍येट ताक्‍शा, फाराओ आ खिंमी वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","मिनु इजीप्‍त नु कनान ङा मुर आन क्‍येट नुप्‍शा, योसेफ आ बाक्‍तीकेमी जाक्‍शा, मेकोपुकीमी “जचा थोव़क गेकी। आंइ के क्‍येट नुप्‍त। गे जचा थोव़क मगेतीनी हना, गो इन ङोंइती बेक्‍चा माल्‍नीकी” दे मदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","मिनु योसेफमी “इन के क्‍येट मबाक्‍त हना, इन बस्‍तु भाव चाक्‍कीन। मेको रे पा जचा थोव़क ताइनीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","मिनु आन बस्‍तु भाव योसेफ आ बाक्‍तीके चाक्‍ग्‍मे बाक्‍त। मिनु योसेफमी शारापुकी, क्‍यारश भेडा, बी ब्‍यफ, गधा ताक्‍शा, जचा थोव़क गेमी बाक्‍त। मेको बर्समी मेको आन कली आन बस्‍तु भाव आन पा ङा अन्‍न गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","मिनु मेको बर्स नुप्‍शा ङा मिन, अर्को बर्स लेंशा जाक्‍शा योसेफ कली मेकोपुकीमी “गो आंइ प्रभु आ ङोंइती आंइ क्‍येट नुप्‍त, आंइ क्‍यारश भेडा, बी ब्‍यफ नेल्‍ल आंइ प्रभु केन दुम्‍तेक्‍म। मुल आंइ के रूपुकी नु आंम रां ला लीब। ");
INSERT INTO suzBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","मारदे गो इन ङोंइती बेक्‍नीकी? आंइ कली नु आंइ रू कली यो अन्‍न गेशा ग्‍यापीन। गोपुकी फाराओ आ वाइलीम वाइल दुम्‍नीकी। गोपुकी ब्रोंइचा नु आंइ रागीम मुरपुकी लीचा कली वांचेर गेने” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","मिनु योसेफमी इजीप्‍त रागी नेल्‍ल फाराओ कली ग्‍यबा बाक्‍त। मारदे हना ठेयब अन्‍काल आ पर्बम इजीप्‍त ङा मुरपुकीमी आन रू नेल्‍ल लेयङमे बाक्‍त। मिनु रू नेल्‍ल फाराओ के दुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","मुर नेल्‍ल आन कली वाइलीम वाइल सेल्‍शा, आन बाक्‍तीक रे याक्‍शा वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","नाक्‍सो आ रू चहिं मग्‍यबा बाक्‍त। मारदे हना आन जचा फाराओ आ गुइ रे तामे बाक्‍त। मोपतीके आन रू यो लेयचा ममाल्‍मा बाक्‍त। गन्‍ती १८:२०; यहोसु १३:१४; इजीकीएल ४४:२८; इजीकीएल ४५:१-५ ");
INSERT INTO suzBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","मिनु योसेफम मुर आन कली “नेनीन, मुलाक्‍ती रे गेपुकी नु इन रू नेल्‍ल फाराओ के दुम्‍त। गो ग्‍याप्‍ता। एको वांचेर लाइश्‍शा, शोक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","मिनु रिक्‍ची ना ५ भाग ङा भाग १ फाराओ कली गेचा माल्‍नीनी। अर्को ४ भाग वांचेर कली नु इन कली, इन खिं ङा मुर नु आइक्‍च आल नेल्‍ल आन कली थुल्‍चा कली लीब” दे माइक्‍मी बाक्‍त। एफाह का २२ लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","मिनु मेकोपुकीमी “गे आंइ कली बेक्‍चा रे प्रोंइतीनी। गे आंइ कली थम रिम्‍शो पाइतीनी। गो फाराओ आ वाइल बाक्‍नीकी” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","मिनु योसेफमी इजीप्‍त रागी ङा ऐन कानुनमी “फाराओ कली ५ भाग ङा भाग का गेचा माल्‍नीम। नाक्‍सोपुकीमी चहिं गेचा ममाल्‍नीम। मारदे हना आन रू फाराओ के मदुम” दे ब्रेक्‍पदा बाक्‍त। मेको मुल सम्‍म मोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","मिनु इस्राएल इजीप्‍त रागी ङा गोशेनमी बाक्‍मेनु, आन मारेइ मारेइ नु मुरपुकी सोशा बोशा, शुश दुम्‍मा बाक्‍त। उत्‍पत्ती ४६:३; प्रस्‍थान १:७,१२ ");
INSERT INTO suzBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब इजीप्‍त रागीमी १७ बर्स ब्रोंइमाक्‍त। मेको आ ब्रोंइतीक नेल्‍ल पा सहे का ४७ बर्स बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","मिनु आ बेक्‍ची जाक्‍माक्‍त। मिनु आ तौ योसेफ कली ब्रेश्‍शा “गे आं कली शिशी पाप्‍तीवी हना, इ गुइ आं फिला तार वोइश्‍शा, जोल मपथु, आं कली रिम्‍शो पावो। आं कली इजीप्‍त रागीम मथिम्‍यी, दे पुंइनुङ। उत्‍पत्ती ५०:५ ");
INSERT INTO suzBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","गो बेक्‍शा, आं कली इजीप्‍त रगी रे कुरशा, आं कली आं किकी पिपी आन तुरसुम थिम्‍यी” दे पुंइदा बाक्‍त। मिनु योसेफमी “इन देंशो पाइनुङ” देंमाक्‍त। उत्‍पत्ती २३:२० ");
INSERT INTO suzBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","मिनु मेकोमी “कसम जावो” दे मदा बाक्‍त। मिनु योसेफमी कसम जवा बाक्‍त। मिनु इस्राएल ब्राख्‍येम बाक्‍शा, खुम्‍की पांइसे बाक्‍त। हिब्रू ११:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","मिनु नोले मुर कामी योसेफ कली “इन आफ रोइ पाप्‍तु” दे शेंदा बाक्‍त। मिनु योसेफमी मनस्‍से नु एफ्राइम आ तौ निक्‍शी लाइश्‍शा, ग्रुम्‍थ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","मिनु मुर कामी याकूब कली “नेनीन, इन तौ योसेफ इन कली ग्रुम्‍थ जाक्‍त” दे नेंपदा बाक्‍त। मिनु इस्राएल बोल पा बोक्‍शा, आ ब्राख्‍येम निस्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","मिनु याकूबमी योसेफ कली “नेल्‍ल सक्ति पाइश्‍शो परमप्रभुमी कनान रागी ङा लूज सहरम ग्रूशा, आं कली आसीक गेती। उत्‍पत्ती २८:१७-१९ ");
INSERT INTO suzBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","मेकोमी आं कली ‘नेनीन, गो इन कली सोशा बोशा, शुश सेल्‍नुङ। गो इ रे शुश थर ङा मुर सेल्‍नुङ। इ कली नु इ चच युइ आन कली मेको रागी गेना हना यो इन केन बाक्‍ब, दे गेनुङ’ देंत। उत्‍पत्ती ३५:११-१२ ");
INSERT INTO suzBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","आं जाक्‍चा ङोंइती, इजीप्‍त रागीम जरमेशो एफ्राइम नु मनस्‍से, इ तौ निक्‍शी आं मुर दुम्‍चा माल्‍नीस। रूबेन नु सिमियोन खोदेंशो पा आं केन दुम्‍चा माल्‍नीस। उत्‍पत्ती ४१:५०-५२ ");
INSERT INTO suzBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","इ नोले थिशो आल चहिं इ के दुम्‍मल। मिनु आन लोक्‍ब आन जात ङा नें वोइश्‍शो, इजीप्‍त रागीम अङस ताइब दुम्‍मल। ");
INSERT INTO suzBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","गो पदान रे गाक्‍ङानु, कनान रागी ङा एफ्राथ आ ङोंइती राहेल बेक्‍त। मिनु गो मेको कली एफ्राथ माइश्‍शो बेथलेहेम सहर लतीक लांमी थिम्‍ता” देंमाक्‍त। उत्‍पत्ती ३५:१९ ");
INSERT INTO suzBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","मिनु इस्राएलमी योसेफ आ तौ निक्‍शी आस कली तशा “मेको निक्‍शी सु नसी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","मिनु योसेफमी आ आफ कली “परमप्रभुमी आं कली गेशो तौ बाक्‍नीसी” देंमाक्‍त। मिनु याकूबमी “मेको आस कली एक चाक्‍सी। मिनु गो मेको आस कली आसीक गेनुङ” दे मदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल खाल्‍पा दुम्‍शा, आ मिक्‍च रिम्‍शो मताइब दुम्‍शो बाक्‍माक्‍त। मोपतीके मेको आस कली मतुइक्‍ता बाक्‍त। मिनु योसेफमी मेको आस नेक्‍था चाक्‍दीस्‍सी बाक्‍त। मिनु इस्राएलमी मेको आस कली पुक्‍पु पाइश्‍शा, मुबा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","मिनु योसेफ कली “गो इ कुल ताइनुङ दे ममिम्‍शो नङ। तन्‍न परमप्रभुमी आं कली इ आल आन कली यो कोंइताक्‍यी” देंमाक्‍त। उत्‍पत्ती ३७:३३-३५; उत्‍पत्ती ४५:२६; भजन संग्रह १२८:६ ");
INSERT INTO suzBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","मिनु योसेफम मेको आस कली आ आफ आ थुकु रे याक्‍शा, खुम्‍की पा सेउ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","मिनु योसेफमी आ तौ निम्‍फा आस कली लाइश्‍शा, एफ्राइम आ ग्‍युरा गुइ नु मनस्‍से आ पेरा गुइ ग्‍याइश्‍शा लाइश्‍शा आ आफ आ ङोंइती वोदा बाक्‍त। मोपा मनस्‍से याकूब आ ग्‍युरा गुइ नु एफ्राइम याकूब आ पेरा गुइ आ नेक्‍था वोदा बाक्‍त। उत्‍पत्ती ४१:५१-५२ ");
INSERT INTO suzBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तन्‍न इस्राएलमी आ गुइ ख्राक्‍शा आ ग्‍युरा गुइ एफ्राइम आ पिया तारी नु आ पेरा गुइ मनस्‍से आ पिया तारी वोदा बाक्‍त। मनस्‍से चहिं योसेफ आ ङोंइती जरमेशो तौ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","मिनु याकूबमी योसेफ कली आसीक गेशा “आं किकी पिपी अब्राहाम नु इसहाक परमप्रभु आ ङोंइती गाक्‍शो बाक्‍ताक्‍से। मेको परमप्रभुमी आं कली आं ब्रोंइतीक नाक्‍त नेल्‍ल मुल सम्‍म कोव़ती। उत्‍पत्ती ३२:१०; भजन संग्रह २३:१ ");
INSERT INTO suzBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","आं कली श्‍येत रे प्रोंइब परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबम एको वोंइश आल आस कली आसीक गेवल। मिनु एको आस पतीके आं नें नु आं किकी पिपी अब्राहाम नु इसहाक आस नें मप्रेंसेक्‍ल। एको निक्‍शी रे पा रागीमी शुश दुम्‍मल” दे आसीक गेम्‍सी बाक्‍त। उत्‍पत्ती ३२:२५-३०; यसैया ४१:१४ ");
INSERT INTO suzBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","मिनु योसेफमी आ आफ आ ग्‍युरा गुइ एफ्राइम आ पिया तारी वोइश्‍शो तशा, आ थुं मनुमाक्‍त। मिनु आ आफ आ गुइ एफ्राइम आ पिया रे शोल्‍शा, मनस्‍से आ पियाम वोइक्‍नुङ, दे मिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","मिनु योसेफम आ आफ कली “ममाइ आं आफ, मेको आं ङोंइती जरमेशो बाक्‍ब। इन ग्‍युरा गुइ एको आ पिया तारी वोतीन” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","तन्‍न आ आफ मबित्‍थु “गो तुइक्‍नुङ, आं तौ, गो तुइक्‍नुङ। एको यो थर का दुम्‍ब, एको यो ठेयब दुम्‍ब। तन्‍न एको क्‍येङा आ लोक्‍ब एफ्राइम ठेयब दुम्‍ब। मिनु आ चच युइ शुश ठेयब जात दुम्‍नीम” दे आसीक गेम्‍सी बाक्‍त। गन्‍ती १:३३,३५; ब्‍यवस्‍था ३३:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","मिनु मेको नाक्‍ती मेको आस कली आसीक गेशा “इस नें थिशा इस्राएलीमी आसीक गेनीम। मेकोपुकीमी ‘परमप्रभुमी इ कली एफ्राइम नु मनस्‍से खोदेंशो सेलल’ दे आसीक गेनीम” देंमाक्‍त। मोपा याकूबमी मनस्‍से क्‍येङा एफ्राइम ङोंइती वोदा बाक्‍त। हिब्रू ११:२१ ");
INSERT INTO suzBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","मिनु इस्राएलमी योसेफ कली “नेनो, गो बेक्‍नुङ। मिनु परमप्रभु गे नु बाक्‍शा, इ कली लेंशा इ किकी पिपी आ रागी लाइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","गो इ कली इ लोक्‍ब आन क्‍येङा निक्‍शी अङस गेतन। आं तरवार नु लिब्रामी एमोरी आन गुइ रे रोइश्‍शो रू इ कली गेतन” दे याकूबमी योसेफ कली मदा बाक्‍त। यूहन्‍ना ४:५ ");
INSERT INTO suzBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","मिनु याकूबमी आ तौ आन कली ब्रेश्‍शा मेको आन कली “नोले इन कली मार मार दुम्‍बा, नेंचा कली एकेर बुक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","याकूब आ तौपुकी बुक्‍शा, इन आफ इस्राएल, आं लोव़ नेनीन। ");
INSERT INTO suzBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","रूबेन, गे आं ङोंइती जरमेशो तौ नवे। ङोंइती ङा आं बोल नु सक्ति बाक्‍नेवे। नेल्‍ल क्‍येङा शिरशो नु सक्ति पाइश्‍शो ङोंइती ङा बाक्‍ते। उत्‍पत्ती २९:३२; ब्‍यवस्‍था २१:१७ ");
INSERT INTO suzBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","समुन्‍द्र ङा छाल खोदेंशो पा गे हिम्‍सीशो थुं पाइश्‍शो मुर दुम्‍नेवे। मारदे हना गे इ आफ आ खाट ङोइश्‍शा, बिथोलो पाप्‍तीवी। आं इप्‍तीकेम बाक्‍ते। गे मान मताइब दुम्‍नेवे। उत्‍पत्ती ३५:२२ ");
INSERT INTO suzBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","सिमियोन नु लेवी वोबु बाक्‍नीसी। गे हुश ख्राक्‍श पोक्‍ब बाक्‍नीसी। उत्‍पत्ती ३४:२५ ");
INSERT INTO suzBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","आं थुं इस ख्रुइश्‍शा अरेशोम गेनायो मबिस्‍सेक्‍ल, आं नें इस ग्रुम्‍तीकेमी गेनायो मदेंमल। थुं का मदुमीसे। मारदे हना इस चुरतीकेमी मुर साइक्‍तीसी। महिंब दुम्‍शा, ब्‍यफ कली गाक्‍ने मचाप्‍ब सेल्‍तीसी। ");
INSERT INTO suzBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","इस गाइश्‍शोम सराप राइब। मारदे हना मेको ठेयब बाक्‍ब। इस चुरचाम सराप राइब। मारदे हना मेको शिशी मपाइश्‍शो मरिम्‍शो बाक्‍ब। थुं का मदुमीस। इस्राएल रागीमी ब्राशा बाक्‍कीस। यहोसु १९:१-९; २१:१-४२ ");
INSERT INTO suzBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","यहूदा, इ लोक्‍बपुकीमी इ कली ठेयब सेल्‍मेक्‍ल। इ गुइमी इ जोरी सत्रु आन क्रोक्‍क्रो निप्‍नेवे। इ आफ आ आल इ ङोंइती खुम्‍की पा बाप्‍नीम। गन्‍ती १०:१४; न्‍यायाधीस १:१-२ ");
INSERT INTO suzBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा गुप्‍स आ चाइक्‍ब खोदेंशो बाक्‍ब। सिखार ब्‍वशा ठेयब दुम्‍ते। ठेयब गुप्‍स खोदेंशो पा खुम बाप्‍ब। गुप्‍सनी खोदेंशो पा इप्‍ब। सुम मेको कली बोक्‍पाइक्‍ने चाप्‍बा? गन्‍ती २३:२४; इजीकीएल १९:२; प्रकाश ५:५ ");
INSERT INTO suzBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ठेयब श्‍येत रे प्रोंइब मजाक्‍म सम्‍म आ राज दन्‍ड आ सासन पतीके आ गुइमी लीब। जात जात ङा मुर मेको आ नोले खोइक्‍नीम। गन्‍ती २४:१७; १इतिहास ५:२; हिब्रू ७:१४; इजीकीएल २१:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","मेकोमी आ गधा अङगुर आ बोटम पाइक्‍ब, आ गधा आ चाइक्‍ब नेल्‍ल क्‍येङा रिम्‍शो अङगुर बोटम पाइक्‍ब। आ फेक्‍तीक वा अङगुर शांबुम मुरब। आ वा अङगुर आ रसम ख्रुम्‍ब। योएल ४:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","आ मिक्‍च अङगुर क्‍येङा रिम्‍शो रङ ङा बाक्‍ब। आ ख्रुइ दूध क्‍येङा बुश बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबूलून समुन्‍द्र नु डोंगा वोइक्‍तीकेमी बाक्‍ल। सीदोन सहर सम्‍म आ बाक्‍तीके दुम्‍ल। यहोसु १९:१०-१६ ");
INSERT INTO suzBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्‍साकार बोल्‍यो गधा दुम्‍शा, भारी आस दातेमी इप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","मेकोमी नाइक्‍तीके रिम्‍शो नु रागी दारशो बाक्‍ब, दे ताप्‍तु। मेकेर कुरब दुम्‍शा, अर्को आन गेय पाइब दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान इस्राएल आ जात ङा ठेयब मुर दुम्‍शा, अरु आन कली निसाफ पाइब दुम्‍ल। न्‍यायाधीस १३:२,२४,२५ ");
INSERT INTO suzBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान लांमी बाक्‍शो बुस्‍स खोदेंशो दुम्‍‍शा, मेको बीस पाइश्‍शो बुस्‍स खोदेंशो दुम्‍शा, आइक्‍च लांम बाक्‍ब। शारा ङोइक्‍ब मुर तोक्‍चा कली शारा आ गेंग्रेम कोक्‍ब। मिनु शारा ङोइक्‍ब मुर नोले गे दोक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","परमप्रभु यावे, गे आं मरिम्‍शो पशो रे प्रोंइनीनी, दे रिम्‍शा बाक्‍ती। भजन संग्रह ११९:१६६; हबकुक २:३ ");
INSERT INTO suzBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","रोइक्‍ब मुरपुकी गाद कली रोइक्‍चा कली जाक्‍नीम। गादमी मेको आन कली खेदा पा मेको आन के रोइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेर आ जचा थोव़क शुश ब्रोव़शो बाक्‍ब। पिपम खोदेंशो पा ब्रोव़शो जचा गेब। यहोसु १९:२४-३१ ");
INSERT INTO suzBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नाप्‍ताली प्रोंइशो रोकोश बाक्‍ब। मेकोमी दारदारशो चाइक्‍ब पाइब। न्‍यायाधीस ४:६-१० ");
INSERT INTO suzBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","योसेफ फल सिप्‍ब रवा का बाक्‍ब। आ राशी गारो तारी बाक्‍शा, ब्‍वाक्‍कु बुक्‍तीकेमी ख्रुम्‍शो रवा का बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ब्रा आप्‍बपुकीमी मेको कली ब्रा आप्‍तेक्‍म। मेको कली आप्‍शा, खेदा पशा, काइ मदाक्‍तेम। ");
INSERT INTO suzBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तन्‍न आ लिब्रा बोल्‍यो बाक्‍ब, आ गुइ बोल्‍यो बाक्‍नीम। सक्ति पाइश्‍शो याकूब आ परमप्रभु, इस्राएल आ गोठला नु सेरथे फुल्‍लुम, मेको कली वारच पाप्‍तु। ब्‍यवस्‍था ३२:१८ ");
INSERT INTO suzBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","इ आफ आ परमप्रभुमी इ कली वारच पाइब। नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभुमी इ कली सरीङ रे नु खप रे आसीक गेब। शुश आल थिचा ङा आसीक यो गेवल। ब्‍यवस्‍था २८:३-६; ब्‍यवस्‍था ३३:१३ ");
INSERT INTO suzBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","गेना हना यो बाक्‍ब डांडा ङा आसीक क्‍येङा इ आफ आ गेशो आसीक ठेयब बाक्‍ब। योसेफ आ लोक्‍ब खोदेंशो मदुम्‍थु, एको आसीक आ पिया तारी दुम्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बेन्‍यामीन ब्रुप्‍शा ग्‍याइक्‍ब फर खोदेंशो बाक्‍ब। मिनु सुनी आ सिखार ब्‍वाइब, नाक्‍दो आ रोइश्‍शो योक्‍ब” दे याकूबम आ तौ नेल्‍ल आन कली आसीक गेमी बाक्‍त। न्‍यायाधीस २०:२५; १सामुएल ९:१-२ ");
INSERT INTO suzBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","एको इस्राएल आ १२ थर बाक्‍नीम। आन आफोम मेको आन कली आसीक गेशा पशो लोव़ एकोन बाक्‍ब। मेकोमी मेको आन कली का का पा आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","मिनु मेको आन कली “गो आं किकी पिपी आन बाक्‍तीके लाइनुङ। हित्ती ङा एफ्रोन आ रूमी बाक्‍शो पुक्‍खी, आं किकी पिपी आन कली थिम्‍तीकेमी आं कली वोतीन। उत्‍पत्ती २३:१३-२० ");
INSERT INTO suzBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","मेको पुक्‍खी कनान रागीमी माम्रे आ पूर्ब ङा माक-पेलामी बाक्‍ब। अब्राहाममी मेको थिम्‍तीक हित्ती ङा एफ्रोन रे ग्‍यबा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","अब्राहाम नु आ मीश सारा मेक थिम्‍शो बाक्‍नीस। इसहाक नु आ मीश रेबेका यो मेक थिम्‍शो बाक्‍नीस। मेकेर लेआ यो थिम्‍ता। उत्‍पत्ती २५:९; उत्‍पत्ती ३५:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","मिनु मेको रू नु पुक्‍खी हित्ती मुर रे ग्‍याप्‍शो बाक्‍त” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","याकूबमी आ तौ आन कली मोदें लोव़ पशा नोले, खाटमी आ खोइल दिंशा, बेक्‍माक्‍त। मिनु आ किकी पिपी आन बाक्‍तीक लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","मिनु योसेफ आ आफ आ कुल तार गुर ब्‍वेशा, पुक्‍पु पाइश्‍शा, ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","मिनु आ गेय पाइब नु डाक्‍टर आन कली “आं आफ आ रां कली ख्रेक्‍तीन” दे माइक्‍मी बाक्‍त। मिनु मेकोपुकीमी बेक्‍शो मुर आ रां ख्रेक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","मिनु ४० नाक्‍त ख्रेक्‍तमे बाक्‍त। मारदे हना ख्रेक्‍चा कली ४० नाक्‍ती माल्‍बाक्‍माक्‍त। इजीप्‍त ङा मुरपुकी यो ७० नाक्‍ती रोंका पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","मिनु रोंका पतीक नाक्‍ती नुम्‍मेनु, योसेफमी फाराओ आ खिं ङा मुर आन कली “गो इन ङोंइती शिशी ताइनुङ हना, गे फाराओ कली आं पर्बम लोव़ पने। ");
INSERT INTO suzBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","आं आफोम आं कली ‘गो बेक्‍ङानु, कनान रागीम आं कली थिम्‍तीके ठीक पाता, मेकेर थिम्‍चा माल्‍नेवे’ दे कसम जपाइक्‍ती। मोपतीके आं आफ थिम्‍चा कली मेकेर लचा गेयीनी। मिनु गो थिम्‍शा लेत्‍नुङ। एको लोव़ फाराओ कली देनीन” दे मेको आन कली मदा बाक्‍त। उत्‍पत्ती ४७:२९-३० ");
INSERT INTO suzBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","मिनु फाराओमी “इ कसम जशो खोदेंशो पा इ आफ कली थिमो” दे योसेफ कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","मिनु योसेफ, फाराओ आ गेय पाइबपुकी, मेको आन ठेयब मुरपुकी, इजीप्‍त रागी ङा ठेयब मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","योसेफ आ खिं ङा मुर नेल्‍ल, आ लोक्‍बपुकी नु आ आफ आ खिं ङा मुर नेल्‍ल आ आफ थिम्‍थ लमा बाक्‍त। आन आइक्‍च आलपुकी नु आन क्‍यारश भेडा, बी ब्‍यफ ला गोशेनमी बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","मिनु योसेफ नु बग्‍गी नु शारा ङोइक्‍बपुकी लमा बाक्‍त। मिनु शुश मुर दुम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","मिनु मेकोपुकी आताद आ चेरब तुप्‍तीके यर्दन खोला आइक्‍ची हांबु जाक्‍दीश्‍शा, ठेयब रोंका पामे बाक्‍त। मिनु योसेफमी आ आफ कली ७ नाक्‍त सम्‍म रोंका पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","मिनु मेकेर बाक्‍ब कनान रागी ङा मुरपुकीम आताद आ चेरब तुप्‍तीक खलाम मेको रोंका पाइब आन कली तशा “एको इजीप्‍त ङा मुर आन ठेयब रोंका का बाक्‍ब” देंमा बाक्‍त। मोपतीके मेको यर्दन आइक्‍ची हांब ङा बाक्‍तीके कली आबेल-मिस्रैम नें वोदमे बाक्‍त। आबेल-मिस्रैम आ अर्थ “ठेयब रोंका पतीके” बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","मोपा याकूब आ तौपुकीमी आन आफ आ अरेशो खोदेंशो पामे बाक्‍त। उत्‍पत्ती ४९:२९ ");
INSERT INTO suzBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","मिनु आ तौपुकीम आन आफ आ रां कनान रागी चाक्‍दीश्‍शा, अब्राहाममी मुर थिम्‍चा कली हित्ती ङा एफ्रोन रे ग्‍याप्‍शो माम्रे आ नेक्‍था माक-पेला ङा रूमी थिम्‍मे बाक्‍त। उत्‍पत्ती २३:१३-२० ");
INSERT INTO suzBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","मिनु आ आफ थिम्‍शा नोले, योसेफ नु आ नु गाक्‍ब नेल्‍ल इजीप्‍त रागी लेम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","मिनु आन आफ बेक्‍म नोले योसेफ आ लोक्‍बपुकीम “मुल योसेफमी इं कली क्‍येक्‍क लेप्‍बा कों। मारदे हना गोपुकीमी मेको कली मरिम्‍शो पाइतय” दे लोव़ पमुमा बाक्‍त। उत्‍पत्ती २७:४१ ");
INSERT INTO suzBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","मिनु आ लोक्‍बपुकीमी लोव़ पचा कली मुर का योसेफ आ बाक्‍तीके सोइक्‍तमे बाक्‍त। मेकोमी “इन आफ आ बेक्‍चा क्‍येङा ङोंइती मार अरेवा बाक्‍त देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","गे योसेफ कली ‘इन लोक्‍ब आन मरिम्‍शो पशो आ पर्बम माफ गेने। मारदे हना इन कली मरिम्‍शो पाम्‍तेक्‍मे। मिनु इन आफ आ परमप्रभु आ गेय पाइब आन कली आन पाप माफ गेने’ दे माइक्‍चा” दे सोइश्‍शो मुरुमी योसेफ कली देंमाक्‍त। मिनु योसेफमी मेको आ लोव़ नेंशा ङाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","मिनु आ लोक्‍बपुकी यो जाक्‍मा बाक्‍त। मिनु आ ङोंइती खुम्‍की पा बाप्‍शा “इन वाइल नकी” दे सेउ पामे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","मिनु योसेफमी “महिनीन, गो परमप्रभु मनङ। ");
INSERT INTO suzBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","गेपुकीमी आं कली मरिम्‍शो पाइतीनी। परमप्रभुमी चहिं रिम्‍शो सेल्‍ती। मो दुम्‍शा परमप्रभुमी शुश मुर आन कली ब्रोंइचा गेप्‍तु। उत्‍पत्ती ४५:५,७ ");
INSERT INTO suzBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","मोपतीके महिनीन, गो इन कली नु इन आल आन कली कोव़नुङ” दे आ लोक्‍ब आन कली लेम्‍शा, रिम्‍शो लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ नु आ खिं ङा मुर नेल्‍ल इजीप्‍त रागीमी बाक्‍मा बाक्‍त। मिनु योसेफ सहे का १० बर्स ब्रोंइमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","मिनु आ तौ एफ्राइम आ चच युइ यो तवा बाक्‍त। आ ङोंइती जरमेशो, मनस्‍से आ तौ माकीर आ तौ आ थुकुम वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","मिनु योसेफमी आ लोक्‍ब आन कली “गो बेक्‍नुङ। परमप्रभुमी इन कली कोव़ब। परमप्रभुमी अब्राहाम, इसहाक नु याकूब कली ‘इन कली कनान रागी लेप्‍पाइक्‍नुङ’ दे कसम जशा, लोव़ पशो बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","मिनु योसेफमी आ लोक्‍ब आन कली “परमप्रभुमी इन कली थमा पा एकेर रे लेप्‍पाइक्‍ब। मेना आं रुश यो लतीने” दे कसम जपाइक्‍मी बाक्‍त। प्रस्‍थान १३:१९; यहोसु २४:३२ ");
INSERT INTO suzBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","मिनु योसेफ सहे का १० बर्स दुम्‍शा बेक्‍माक्‍त। मिनु आ रां कली मराक्‍चा ङा पा ओख्‍ती ख्रेक्‍शा, इजीप्‍त रागीमी बाकसम कुर पा वोदमे बाक्‍त।");
INSERT INTO suzBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","आन खिं खिं ङा मुर लाइश्‍शा, याकूब नु इजीप्‍त लाइब इस्राएल आ तौ सु सु बाक्‍मा बाक्‍त देंशा हना, उत्‍पत्ती ४६:८-२७ ");
INSERT INTO suzBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, सिमियोन, लेवी, यहूदा, ");
INSERT INTO suzBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्‍साकार, जबूलून, बेन्‍यामीन, ");
INSERT INTO suzBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नाप्‍ताली, गाद नु आशेर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","मिनु याकूब आ तौ आन खिं खिं ङा मुर नेल्‍ल पा ७० जना बाक्‍मा बाक्‍त। योसेफ चहिं इजीप्‍त रागीमी बाक्‍शो बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","मिनु नोले योसेफ नु मेको आ लोक्‍ब आन पाला ङा मुर नेल्‍ल बेक्‍मा बाक्‍त। उत्‍पत्ती ५०:२६ ");
INSERT INTO suzBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","मिनु इस्राएल आ चच युइ सोशा बोशा शुश दुम्‍मा बाक्‍त। शुश दुम्‍शा ङा मिन, बोल्‍यो दुम्‍मा बाक्‍त। मिनु इस्राएल आ मुरपुकीमी रागी नेल्‍ल ब्रीमा बाक्‍त। प्रेरित ७:१७-१९ ");
INSERT INTO suzBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","मिनु नोले योसेफ कली मतुइक्‍ब पिप काम इजीप्‍त रागी कली सासन पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","मेकोमी आ मुर आन कली “नेनीन, इं रागीमी बाक्‍शो इस्राएल ङा मुरपुकी इं क्‍येङा शुश नु बोल्‍यो दुम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","मेको आन पर्बमी शुश मिम्‍शा, सल्‍ला पय। मो मपाइतय हना, मेको शुश दुम्‍शा, नोले लडाइ दुम्‍मेनु, इं जोरी सत्रु आन कली वारच पाइश्‍शा, एक रे प्रोक्‍नीमी, कोर में” दे आ मुर आन कली माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","मोपतीके मेकोपुकीमी इस्राएली आन कली श्‍येत गेशा, गेय पपाइक्‍चा कली कोव़ब ठेयब मुरपुकी वोदमे बाक्‍त। मिनु इस्राएलीपुकीमी फाराओ माइश्‍शो पिप आ मार मार वोइक्‍चा कली पिथोम नु रामे‍सेस सहर निक्‍शी सेल्‍मे बाक्‍त। उत्‍पत्ती १५:१३; उत्‍पत्ती ४७:११ ");
INSERT INTO suzBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","तन्‍न इस्राएली गिश श्‍येत जामे, मिश बारना बारन शुश दुम्‍शा, इजीप्‍त रागी ब्रीमा बाक्‍त। मिनु मेको आन कली तशा, इजीप्‍त ङा मुर शुश हिंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","मोपतीके इस्राएली आन कली ङोंइती क्‍येङा यो शुश गेय पपदमे बाक्‍त। उत्‍पत्ती १५:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","शुश श्‍येत गेशा, शुश गेय पपदमे बाक्‍त। मार गेय पपदमे बाक्‍त देंशा हना, हिलो निपदमे बाक्‍त, इंटा सेल्‍पदमे बाक्‍त, रू ङा गेय यो पपदमे बाक्‍त। तेको गेय गेमे, मेको शुश श्‍येत ङा गेय बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","मिनु इजीप्‍त ङा पिपमी हिब्रू मीश मुर आन आल थिची ना वारच पाइब आन ठेयब मीश मुर आस कली लोव़ पवा बाक्‍त। मेको आन दाते ङा का आ नें शिप्रा नु अर्को आ नें पुआ बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","मिनु फाराओमी “गे निक्‍शी हिब्रू मीश मुर आन कली आल थिची ना वारच पाइनीसी। तौ थिम्‍तेक्‍म हना, सतीसे। तमी बाक्‍त हना, मसतीसे” दे माइक्‍सी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","तन्‍न मेको मीश मुर आन कली वारच पाइब नेल्‍लेमी परमप्रभु कली मान पा हिंशा, इजीप्‍त ङा पिपमी देंशो मपथु, वोंइश आल आन कली यो मसदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","मिनु इजीप्‍त ङा पिपम मेको वारच पाइब मीश मुर आस कली ब्रेश्‍शा “गे मारदे वोंइश आल आन कली यो ब्रोंइचा गेसी? मारदे मोदेंशो पसी?” दे लोव़ पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","मिनु मेको मीश मुरुमी “हिब्रू मीश मुरपुकी इजीप्‍त ङा मीश मुर आन क्‍येङा बोल्‍यो बाक्‍नीम। मोपतीके गो जाक्‍दीत्‍चा क्‍येङा ङोंइती आल थिने थुम्‍शो बाक्‍नीमी” देंसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","मोपतीके परमप्रभुमी मेको आल थिचा वारच पाइब मीश मुर आन कली आसीक गेवा बाक्‍त। मिनु इस्राएली शुश दुम्‍शा, बोल्‍यो दुम्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","वारच पाइब मीश मुरपुकी परमप्रभु कली मान पा हिंतीके परमप्रभुमी मेको आन खिं कली यो आसीक गेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","मिनु पिप फाराओमी आ मुर आन कली “हिब्रूपुकीमी दोशो तौ थीमे, मेको नेल्‍ल नील खोलाम लाइश्‍शा ताइक्‍तीन। आन तमी आन कली चहिं ब्रोंइचा गेने” दे हुकुम पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी आ थर ङा मुर का बाक्‍माक्‍त। मिनु मेकोमी लेवी आ थर ङा मीश आल का ग्‍युंबे पवा बाक्‍त। प्रस्‍थान ६:२० ");
INSERT INTO suzBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","मिनु मेको मीश मुरुमी तमी का नु तौ का थिमाक्‍त। नोले लेंशा आल कुरशा, तौ का थिमाक्‍त। आ थिशो तौ कली तशा “शुश दारशो आल बाक्‍ब” दे महिना सां सम्‍म ख्रुइश्‍‍शा वोदा बाक्‍त। प्रेरित ७:२०; हिब्रू ११:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","मिनु नोले आल आ ममामी महिना सां ङा आल कली ख्रुइक्‍ने मचबा बाक्‍त। मिनु आल कली सुम्‍तीके पाइश्‍शो ग्‍युर सेल्‍शा, ब्‍वाक्‍कु मओव़चा ङा पा अल्‍कत्राम सिल्‍दा बाक्‍त। मिनु मेको आ तौ कली ग्‍युरुम कुर पा खोला आ नेक्‍था ङा बुदी मीलु घांस आगा, ब्‍वाक्‍कुम वोदा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","मिनु मेको आल आ दिदी “आं लोक्‍ब कली मार दुम्‍मे” दे ङोन रे कोव़दीम्‍माक्‍त। गन्‍ती २६:५९ ");
INSERT INTO suzBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","मेना पिप आ तमी खोलाम चिक्‍चा कली जाक्‍दीम्‍माक्‍त। आ गेय पाइबपुकी यो खोला आ नेक्‍था लमा बाक्‍त। मिनु पिप आ तमीमी बुदी मीलु घांस आगा, ब्‍वाक्‍कुमी मेको ग्‍युर तशा, आ गेय पाइब का कली “मेको ग्‍युर ब्रथ लावो” दे सोइक्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","मिनु पिप आ तमीमी मेको सुम्‍तीक पाइश्‍शो ग्‍युर रोक्‍शा कोव़ङानु “ए, आल का बाक्‍त” देंमाक्‍त। मिनु आल ङाक्‍माक्‍त। मेको आल तशा, शिशी पवा बाक्‍त। मिनु पिप आ तमीमी “एको हिब्रू ङा मुर आ तौ का बाक्‍ब” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","मिनु आल आ दिदीमी “गो इन कली हिब्रू दूध तुंइब मीश मुर का चाक्‍गु? आल कली दूध तुंइबा कों” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","मिनु फाराओ आ तमीमी “लो, चाक्‍को” दे मीश आल कली देंमाक्‍त। मिनु मेको मीश आलम आ ममा ब्रथ लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","मिनु फाराओ आ तमीमी मेको मीश मुर कली “एको आल आं कली थुलो। एको आल थुल्‍शो ङा, इ कली क्‍येट गेनुङ” दे लोव़ पवा बाक्‍त। मिनु मीश मुरुमी आल लाइश्‍शा, थुला बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","मेको नोले आल कोल्‍माक्‍त। मिनु काबु मेकोमी मेको आल फाराओ आ तमी कली लाइश्‍शा, गेवा बाक्‍त। मिनु आ तौ खोदेंशो दुम्‍माक्‍त। मिनु पिप आ तमीमी मेको आ नें मोसा वोदा बाक्‍त। मारदे हना “गो मेको कली ब्‍वाक्‍कु रे ग्रुंइताक्‍ङ” देंमाक्‍त। मोसा आ अर्थ हिब्रू लोव़मी “ब्‍वाक्‍कु रे ग्रुंइशो” देंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मिनु नोले मोसा ठेयब दुम्‍शा, आ लोक्‍ब आन कली ग्रुम्‍थ लशा, आन श्‍येत जशो ताप्‍तु। मेकोमी इजीप्‍त रागी ङा मुरुमी आ हिब्रू लोक्‍ब का कली तुप्‍शो ताप्‍तु। प्रेरित ७:२३-२९; हिब्रू ११:२४-२७ ");
INSERT INTO suzBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","मिनु मोसामी एर ओंथ कोव़शा, सुइ मबाक्‍शो तशा, इजीप्‍त ङा तुप्‍ब मुर कली साइक्‍तु। मिनु बाल्‍वामी थिम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","आ दीसा मोसा लेंशा हिरथ लमेनु, हिब्रू निक्‍शी जिशा तुम्‍मुशो ताप्‍तु। मिनु मोसामी मरिम्‍शो पाइब कली “मारदे आंम लोक्‍ब कली तुबी?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","मिनु मेकोमी “सुमी इ कली आंस होव़प नु निसाफ पाइब सेला? इजीप्‍त ङा मुर कली साइश्‍शो खोदेंशो पा आं कली यो सदु, देंने?” दें‍त। मिनु मोसामी “मुल एको लोव़, मुर नेल्‍लेमी तुइक्‍नीमी” दे मिम्‍शा हिं‍त। प्रेरित ७:३५ ");
INSERT INTO suzBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","मिनु फाराओमी “मोसाम इजीप्‍त ङा मुर का साइक्‍तु” देंशो नेंशा, मोसा कली साइक्‍चा माल्‍तु। मोसा चहिं फाराओ आ बाक्‍तीक रे प्रोक्‍शा, मिदयान रागी जाक्‍दीश्‍शा, इनार तारी निश्‍शा बाक्‍‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिनु मिदयान रागीमी ७ जना तमी बाक्‍शो नाक्‍सो का बाक्‍माक्‍त। मेको मीश आलपुकीमी आन आफ आ क्‍यारश भेडा आन कली ब्‍वाक्‍कु तुंइचा, दे शुंगु ब्‍वाक्‍कुम प्रिंचा कली, ब्‍वाक्‍कु कीतेक्‍म। प्रस्‍थान ३:१ ");
INSERT INTO suzBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तन्‍न अरु गोठलापुकी जाक्‍शा, मेको आन कली श्‍येत गेम्‍तेक्‍म। मोसामी चहिं मेको मीश आल आन कली वारच पा, आन भेडा आन कली ब्‍वाक्‍कु तुंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","मिनु मेको आन आफ रूएल आ खिं जाक्‍दीम्‍मानु, मेकोमी आ तमी आन कली “मुलाक्‍ती गे दोपा रीब पा जाक्‍नी?” दे हिल्‍लो पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","मिनु मेको आ तमीपुकीमी “इजीप्‍त रागी ङा वोंइश मुर कामी आंइ कली गोठला आन गुइ रे प्रोंइतु। मिनु शुश ब्‍वाक्‍कु कुर पा आंइ क्‍यारश भेडा आन कली तुंइताक्‍व” दे आन आफ कली मदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","मेकोमी आ तमी आन कली “मेको मुर ते बाक्‍मे? एक मारदे मचाक्‍नी? मुल गो नु जथ ब्रेत्‍तीने” दे माइक्‍मी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मिनु मोसा मेकोपुकी नु बाक्‍चा बिस्‍साक्‍व। रूएलमी मोसा कली आ तमी सिप्‍पोरा ग्‍युंबे पा गेप्‍तु। गन्‍ती १२:१ ");
INSERT INTO suzBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","मिनु नोले तौ का थिप्‍तु। मिनु मोसामी मेको आल आ नें गेरशोम वोइक्‍तु। मारदे हना “गो मतुइश्‍शो रागीमी अर्को रागी ङा मुर दुम्‍ती” दें‍त। प्रस्‍थान १८:४ ");
INSERT INTO suzBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","मिनु शुश बर्स नोले इजीप्‍त रागी ङा पिप बेक्‍माक्‍त। इस्राएल जात ङा मुर इजीप्‍त रागीम वाइलीम वाइल खोदेंशो दुम्‍शा, शुश श्‍येत जशा, परमप्रभु कली “वारच पाइय्‍यीकी” दे पुंइशा ङाक्‍मा बाक्‍त। मिनु परमप्रभुमी मेको आन ङाक्‍शो नेना बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","मिनु परमप्रभुमी अब्राहाम, इसहाक नु याकूब नु कबल पशो मिम्‍ता बाक्‍त। उत्‍पत्ती १५:१८; उत्‍पत्ती २६:३; उत्‍पत्ती २८:१३-१४ ");
INSERT INTO suzBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","मिनु परमप्रभुमी आन श्‍येत जशो तशा शिशी पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मेना मोसा आ शिउ आ क्‍यारश भेडा योव़थ ल‍त। आ शिउ रूएल आ नें यित्रो यो बाक्‍माक्‍त। यित्रो चहिं मिदयान रागी ङा नाक्‍सो का बाक्‍माक्‍त। मोसामी क्‍यारश भेडा आन कली गोरशो रागी ङा नां पेरतीके गे योव़तु। मोपा योव़ना योव़न, होरेब माइश्‍शो परमप्रभु आ डांडा आ नेक्‍था जाक्‍दीत्‍‍त। प्रेरित ७:३०-३४ ");
INSERT INTO suzBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","मेकेर परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब मी ब्रशो बुटा रे ग्रूत। ङोंइती दोदेंशो बाक्‍‍त देंशा हना, मोसामी ङोन रे कोव़ङानु, ब्रशो बुटा का कली मीम काइ मनेक्‍शो ताप्‍तु। ब्‍यवस्‍था ३३:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","मिनु मोसामी “गो मेकेर लशा कोव़चा माल्‍नुङ। छक लाक्‍चा ङा बाक्‍त। मारदे मीम मेरे बुटा कली मनेक्‍गा?” दे आंमा लोव़ पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","मिनु परमप्रभु यावेमी मोसा कली ब्रशो बुटा कोव़थ पिशो तशा, परमप्रभुमी बुटा रे “मोसा, मोसा” दे ब्रेत्‍ताक्‍व। मिनु मोसामी “गो एक बाक्‍ती” दे लोव़ लेत्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","मिनु लेंशा “एक मपिवो। इ जुत्ता प्रुतो। मारदे हना इ राप्‍शा बाक्‍तीके आं बाक्‍तीके बाक्‍ब। उत्‍पत्ती २८:१७; यहोसु ५:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","गो इ आफ आ परमप्रभु इ किकी पिपी अब्राहाम, इसहाक नु याकूब आन परमप्रभु नङ” दे मोसा कली लोव़ पाप्‍तु। मिनु मोसामी परमप्रभु कली तशा हिंशा, आ कुल सुम्‍साक्‍व। उत्‍पत्ती १७:१; उत्‍पत्ती २८:१-४; उत्‍पत्ती ३५:९-११; मत्ती २२:३२ ");
INSERT INTO suzBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","मिनु परमप्रभु यावेमी “गो इजीप्‍त रागीमी बाक्‍शो आं मुर आन श्‍येत ताता। मेको आन कली गेय पपाइक्‍ब आन पर्बम ङाक्‍नीमी। गो आन ङाक्‍शो नेंता, ताता। गो आन श्‍येत जशो तुइक्‍ताक्‍ङ। प्रस्‍थान २:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","मिनु मेको आन कली इजीप्‍त रागी ङा मुरपुकीम गेशो श्‍येत रे प्रोंइनुङमी। गो आं मुर आन कली रिम्‍शो नु ठेयब रागी लाइक्‍नुङमी। मेको रागीम दूध नु खुदो शुश बाक्‍ब। मारेइ मारेइ यो शुश ग्रेल्‍ब। मेको रागी कनानी, हित्ती, एमोरी, परिज्‍‍जी, हिव्‍वी नु यबुसी आन बाक्‍तीक रागी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","नेनो, गो इस्राएल जात ङा मुर आन ङाक्‍शो नेंता। इजीप्‍त रागी ङा मुरुमी मेको आन कली दिप्‍शा श्‍येत गेम्‍तेक्‍म। गो मेको यो ताता। ");
INSERT INTO suzBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","गो इ कली फाराओ आ बाक्‍तीके सोइक्‍नुङ। गे इस्राएल जात ङा मुर आन कली इजीप्‍त रागी रे ग्रुंइदो” दे परमप्रभुमी मोसा कली माइक्‍तु। प्रस्‍थान ७:१६; न्‍यायाधीस ६:१४ ");
INSERT INTO suzBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","मिनु मोसामी परमप्रभु यावे कली “गो दोपा मो पने चाप्‍नुङा? फाराओ आ बाक्‍तीकेमी लशा, इस्राएल जात ङा मुर आन कली इजीप्‍त रागी रे दोपा ग्रुंइने चाप्‍नुङा?” दे परमप्रभु कली देंत। प्रस्‍थान ४:१०; उत्‍पत्ती ३२:११; २सामुएल ७:१८; यसैया ६:५,८; येरमीया १:६ ");
INSERT INTO suzBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","मिनु परमप्रभुमी “गो थमा पा, गे नु बाक्‍नुङ। इ कली सोइक्‍ब गो नङ, दे चिन्‍ड का कोंइनन। मेको चिन्‍ड मार बाक्‍त देंशा हना, गे इस्राएल जात ङा मुर आन कली इजीप्‍त रागी रे ग्रुंइशा नोले एको परमप्रभु आ डांडामी आं कली ठेयब सेल्‍नीनी” दे माइक्‍तु। येरमीया १:८ ");
INSERT INTO suzBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मिनु मोसामी परमप्रभु कली “गो इस्राएल जात ङा मुर आन बाक्‍तीके जाक्‍दीश्‍शा, मेको आन कली ‘इन किकी पिपी आन परमप्रभुमी आं कली इन बाक्‍तीके सोइक्‍ताक्‍यी’ देंङानु, मेकोपुकीमी चहिं ‘मेको आ नें मार में?’ दे हिल्‍लो पाइनीम। मेना गो मार देंनुङा?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","मिनु परमप्रभुमी मोसा कली “आं नें ‘गो नङ’ बाक्‍ब। इस्राएल जात ङा मुर आन कली ‘गो नङ’ देंबमी आं कली इन बाक्‍तीकेमी सोइक्‍ताक्‍यी, देंचा माल्‍नेवे” देंत। प्रस्‍थान ६:२; मलाकी ३:६; प्रकाश १:४,८ ");
INSERT INTO suzBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","मिनु लेंशा परमप्रभुमी मोसा कली “इस्राएल ङा मुर आन कली मार देंचा माल्‍नेवे देंशा हना ‘परमप्रभु यावे, इन किकी पिपी अब्राहाम, इसहाक नु याकूब आन परमप्रभुमी इन कली ग्रुम्‍थ सोइक्‍ताक्‍यी। आं नें गेना हना यो लीब। नेल्‍ल पाला ङा मुरुम आं नें आन थुंमी मिम्‍शा वोइक्‍चा माल्‍नीम’ देंचा माल्‍नेवे। प्रस्‍थान ६:२-३; यसैया ४२:८ ");
INSERT INTO suzBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","गे इस्राएल जात ङा मुर आन खाल्‍पा आन कली खुप्‍थ लावो। मिनु मेको आन कली ‘परमप्रभु यावे इन किकी पिपी आन परमप्रभु आं ङोंइती ग्रूत। अब्राहाम, इसहाक नु याकूब आन परमप्रभुमी आं कली ग्रुम्‍शा, लोव़ पाप्‍तु’। मेकोमी आं कली ‘गो थमा पा इन कली ग्रुम्‍थ यिती, इजीप्‍त रागीम इन कली गिश श्‍येत गेमे, मेको ताता। ");
INSERT INTO suzBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","गो इन कली इजीप्‍त रागी ङा मुर आन गेशो श्‍येत रे प्रोंइनुङ। गो इन कली कनानी, हित्ती, एमोरी, परि‍ज्‍जी, हिव्‍वी नु यबुसी आन बाक्‍शो रागी गेनुङ। मेको रागीम दूध नु खुदो शुश बाक्‍ब, अन्‍न यो शुश ग्रेल्‍ब। गो आं देंशो लोव़ खाप्‍नुङ’ देंत, देंचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","इ देंशो लोव़ नेंशा, टिम्‍तेक्‍म हना, गे नु इस्राएल ङा मुर आन खाल्‍पापुकी इजीप्‍त रागी ङा पिप आ बाक्‍तीक लशा, मेको कली लोव़ पचा माल्‍नीनी। गेमी इजीप्‍त रागी ङा पिप कली ‘परमप्रभु यावे हिब्रू आन परमप्रभुमी आंइ कली ग्रुम्‍तीकी। आंइ कली नाक्‍त सां गोरशो रागीम लचा गेकी। मेकेर परमप्रभु यावे आंइ परमप्रभु कली चढ़ेथ लाइनीकी’ दे पिप कली देनीन। प्रस्‍थान ५:१,३ ");
INSERT INTO suzBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","मेको पिपमी चहिं इन कली लचा मगेब, गो तुइक्‍नुङ। गो थम ठेयब सक्तिमी इन कली वारच पाता हना ला, लचा गेब। ");
INSERT INTO suzBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","मिनु गोमी इजीप्‍त रागी ङा मुर आन दातेमी थम छक लाक्‍चा ङा गेय कोंइशा, मेको आन कली श्‍येत गेनुङ। मिनु नोले मेकोमी इन कली लचा गेब। ");
INSERT INTO suzBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","इजीप्‍त रागी ङा मुरपुकीमी इन कली दाक्‍ब सेल्‍नुङमी। इजीप्‍त रे ग्रूनीनु, श्‍येत्‍थ ग्रूचा ममाल्‍नीनी। प्रस्‍थान ११:२-३; प्रस्‍थान १२:३५-३६ ");
INSERT INTO suzBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","मीश मुर नेल्‍लेमी आन नेक्‍था ङा इजीप्‍त रागी ङा वारच रे सुन, चांदी नु वासी पुंइचा माल्‍नीम। आन तमी तौ आन कली पांइपाइक्‍चा माल्‍नीम। मोदेंशो पा इजीप्‍त ङा मुर आन शोंप रोइक्‍चा माल्‍नीनी” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मिनु मोसामी परमप्रभु कली “मेकोपुकीमी आं देंशो थमा मसुइक्‍थु, मटीनीमी कों? ‘परमप्रभु यावेमी इ कली मग्रुम’ देंनीमी कों” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","मिनु परमप्रभु यावेमी “इ गुइमी मार कुरी?” दे हिल्‍लो पाप्‍तु। मिनु मोसामी “कोक्‍के कुरता” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","मिनु “खपीम ब्‍वारदो” दें‍त। मिनु मोसामी आ कोक्‍के ब्‍वारदानु, बुस्‍स दुम्‍‍त। मिनु मोसा मेको तशा प्रोक्‍त। प्रस्‍थान ७:१० ");
INSERT INTO suzBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","मिनु परमप्रभु यावेमी “आ मीलुम ग्‍याइक्‍तो” दें‍त। मिनु मोसामी आ गुइ दिंशा, बुस्‍स कली ग्‍याइक्‍दीमेनु, आ गुइमी लेंशा कोक्‍के दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","मिनु मेको तशा, मेकोपुकीमी “परमप्रभु यावे, आन किकी पिपी अब्राहाम, इसहाक नु याकूब आन परमप्रभुमी इ ङोंइती ग्रूशा, इ कली ग्रुम्‍तु, दे थमा सुइक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","मिनु परमप्रभु यावेमी लेंशा “इ गुइ इ फेक्‍शो वा आगाम वोतो” देंत। मिनु मोसामी मो पाप्‍तु। मिनु नोले आ गुइ ग्रुंइशा कोव़ङानु, कोव़र मुशा बुश दुम्‍‍‍शो ताप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","मिनु मेकोमी “लेंशा, इ गुइ इ फेक्‍शो वा आगाम वोतो” दें‍त। मिनु वोइश्‍शा ग्रुंइदानु, आ गुइ ङोंइती ङा खोदेंशो पा सेस दुम्‍शो ताप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“इ ङोंइती ङा चिन्‍ड तशा, इ लोव़ थमा मसुइक्‍थु, मटिम्‍तेक्‍म हना, नोले ङा चिन्‍ड तशा, थमा सुइक्‍नीमी कों? ");
INSERT INTO suzBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","तन्‍न मेकोपुकीमी चिन्‍ड निक्‍शी तशा यो, थमा मसुइक्‍थु, इ कली मटिम्‍तेक्‍म हना, गे नील खोला ङा ब्‍वाक्‍कु लाइश्‍शा, सोव़शो खप तारी मोतो। खोला रे लाइश्‍शो ब्‍वाक्‍कु सोव़शो खप तारी मोदीनु, मेको हुश दुम्‍ब” दे परमप्रभु यावेमी दें‍त। प्रस्‍थान ७:१७-२१ ");
INSERT INTO suzBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मिनु मोसामी परमप्रभु यावे कली “आं परमप्रभु, गो लोव़ पस मजोक्‍नुङ। गे, मुल इन गेय पाइब नु लोव़ पनीनु यो, आं कली लोव़ पचा मपी। गो थांइशो लें पाइश्‍शो मुर बाक्‍नुङ” देंत। प्रस्‍थान ३:११; प्रस्‍थान ६:१२-३० ");
INSERT INTO suzBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","मिनु परमप्रभु यावेमी “सुमी मुर आ शोव़ सेला? सुम लोव़ पपाइक्‍ब, नोफा नेंब नु मनेंब, मिक्‍च ताइब नु मताइब सेला? गो, परमप्रभु यावे मनङा ङा? भजन संग्रह ९४:९ ");
INSERT INTO suzBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","मुल लावो। गो इ कली लोव़ पपाइक्‍नुङ, मार देंचा माल्‍बा, मेको इ कली शेंनुङ” देंत। ब्‍यवस्‍था १८:१८; मत्ती १०:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","मोसाम चहिं “आं परमप्रभु, आं पा ङा अरु कली सोइक्‍ने चाप्‍नीनी कों? तन्‍न आं कली मसोइक्‍तीनी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","मिनु परमप्रभु यावे मोसा आ पर्बम गाइश्‍शा “लेवी थर ङा इ लोक्‍ब हारून रिम्‍शो लोव़ पस जोक्‍ब बाक्‍ब, गो मतुइक्‍नुङा ङा? मिनु मुल इ कली ग्रुम्‍थ जाक्‍ब। इ कली तशा शुश ग्‍येरब। ");
INSERT INTO suzBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","गो इ पचा माल्‍शो लोव़ नेल्‍ल शेंनुङ। मिनु गे मेको हारून कली देंचा माल्‍नेवे। मिनु मेकोमी इ पा ङा मुर आन कली लोव़ पचा माल्‍ब। मेको इ शोव़ खोदेंशो दुम्‍ब। गो इ कली लोव़ पाइब परमप्रभु खोदेंशो पा, गे हारून कली लोव़ पाइब बाक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","दोपा गो, परमप्रभुम इ कली लोव़ पाइनुङा, मोपा गे हारून कली लोव़ पचा माल्‍नेवे। मिनु मेकोमी मुर आन कली लोव़ पचा माल्‍ब। प्रस्‍थान ७:१-२ ");
INSERT INTO suzBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","मेको कोक्‍के लाइश्‍शा, आं देंशो चिन्‍ड कोंइदो” दे परमप्रभु यावेमी मोसा कली माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मिनु मोसा आ शिउ, यित्रो आ खिं लशा, मेको कली “इजीप्‍त रागीम बाक्‍शो आं लोक्‍ब आन कली ग्रुम्‍थ लचा गेयीनी। बेक्‍मा कों, ब्रोंइमा, गो तुइक्‍चा दाक्‍ती” दे पुंइतु। मिनु यित्रोमी “इ थुं नाइश्‍शा, लावो” देंत। प्रस्‍थान ३:१ ");
INSERT INTO suzBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मिनु मोसा मिदयान रागीम बाक्‍मेनु, परमप्रभु यावेमी “लेंशा इजीप्‍त रागी लावो। मारदे हना इ कली साइक्‍चा माल्‍बपुकी बेक्‍तेक्‍मे” दे लोव़ पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","मिनु मोसा आ मीश नु आ तौ निक्‍शी नु गधा ङोइश्‍शा, इजीप्‍त रागी लेत्‍त। परमप्रभु आ गेशो कोक्‍के यो कुरतु। प्रस्‍थान १८:३-४ ");
INSERT INTO suzBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","मिनु परमप्रभु यावेमी मोसा कली “इ नोफा दाइश्‍शा नेनो। गे इजीप्‍त रागी जाक्‍दीश्‍शा, गो इ कली पपाइश्‍शो छक लाक्‍चा ङा गेय नेल्‍ल फाराओ आ ङोंइती पावो। गो चहिं मुर आन कली लचा मगेचा ङा पा फाराओ कली काइ मटीब सेल्‍नुङ। प्रस्‍थान ७:३,१३; ब्‍यवस्‍था २९:३; यसैया ६:१०; रोमी ९:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","मिनु गे मेको कली ‘परमप्रभु यावेमी इन कली मार लोव़ पाप्‍तु देंशा हना, इस्राएल आं ङोंइती जरमेशो तौ बाक्‍ब। ब्‍यवस्‍था ३२:६ ");
INSERT INTO suzBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","आं तौ कली आं कली चढ़ेतीक चढ़ेथ लचा गेवो। गे मटिप्‍तीवी हना, गो इ ङोंइती जरमेशो तौ कली साइक्‍नुङ’ देंत, देनो” दे परमप्रभु यावेमी मोसा कली माइक्‍तु। प्रस्‍थान ११:५; प्रस्‍थान १२:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मिनु लांम बास बाक्‍मानु, परमप्रभु यावेमी मोसा आ नेक्‍था जाक्‍शा, मेको कली साइक्‍चा माल्‍तु। उत्‍पत्ती १७:१४; उत्‍पत्ती ३२:२५ ");
INSERT INTO suzBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","मिनु सिप्‍पोरामी चहिं हेश्‍शो फुल्‍लु का गुप्‍शा, आ तौ कली ख्रोइक्‍तीक चिन्‍ड ख्रोदा बाक्‍त। मोपा मेकोमी आ तौ आ चारतीक ङा कुशुल ख्रोइश्‍शा, आ तौ आ कुशुलम मोसा आ रां थिशा “गे हुश के ग्‍युम्‍ले नवे” देंमाक्‍त। यहोसु ५:२ ");
INSERT INTO suzBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","मोदेंशो पतीके, परमप्रभुमी मोसा कली मसाइक्‍थु, प्रोना बाक्‍त। सिप्‍पोरामी मारदे “हुश के ग्‍युम्‍ले” दें‍त देंशा हना, ख्रोइक्‍तीक चिन्‍ड रे हुश यिमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ङोंइती परमप्रभु यावेमी हारून कली “मोसा गोरशो रागीम जाक्‍चा चिक्‍शो बाक्‍ब। मेको कली ग्रुम्‍थ लावो” दे माइक्‍तु। मिनु लशा, परमप्रभु आ डांडाम मोसा कली ग्रुम्‍शा, पुक्‍पु पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मोसामी आ कली सोइक्‍ब परमप्रभु यावे आ लोव़ नेल्‍ल नु आ पचा माल्‍शो चिन्‍ड यो हारून कली शेंताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","मिनु मेको निक्‍शीमी इस्राएली आन खाल्‍पा नेल्‍ल आन कली खुप्‍ताक्‍से। ");
INSERT INTO suzBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","हारूनमी परमप्रभु यावेमी मोसा नु पशो लोव़ नेल्‍ल मेको आन कली शेंताक्‍व। मोसा कली कोंइशो चिन्‍ड, हारूनमी मुर आन ङोंइती कोंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","मिनु मुरपुकीमी थमा सुइक्‍तेक्‍म। मिनु परमप्रभु यावेमी इस्राएली आन कली ग्रुम्‍शा, आन श्‍येत तशा, वारच पचा चिक्‍शो तुइश्‍शा, मेकोपुकी बाप्‍शा, परमप्रभु कली ठेयब सेल्‍तेक्‍म। प्रस्‍थान ३:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","मिनु नोले मोसा नु आ लोक्‍ब हारून फाराओ ग्रुम्‍थ लाम्‍ताक्‍स। मिनु मेको कली “परमप्रभु यावे, इस्राएली आन परमप्रभुमी आंस कली लोव़ पाप्‍तु। मेकोमी ‘आं मुर आन कली गोरशो रागीमी आं पर्बम चाड मानेचा कली लचा गेवो’ दे परमप्रभु यावेमी इन कली देंशो बाक्‍ब” देंताक्‍स। प्रस्‍थान ३:१८; प्रस्‍थान ७:१६,२६; प्रस्‍थान ९:१,१३ ");
INSERT INTO suzBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","मिनु फाराओमी “परमप्रभु यावे सु बाक्‍म, गो मतुइक्‍नुङ। मार, आ देंशो लोव़ टिचा माल्‍नुङा? गो इस्राएली आन कली मारदे लचा गेनुङा? गो परमप्रभु यावे कली मतुइक्‍नुङ। मोपतीके इस्राएल ङा मुर, इन कली लचा मगेनन्‍नी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","मिनु मेको निक्‍शीमी “हिब्रू मुर आन परमप्रभुमी आंस कली ग्रुम्‍तु। आंइ कली लचा गेने, दे पुंइनस्‍कु। गोपुकी रोइमी, लडाइमी मबेक्‍कल, दे परमप्रभु यावे, आंइ परमप्रभु कली चढ़ेथ नाक्‍त सां सम्‍म गोरशो रागीम लचा गेने” दे माइक्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिनु इजीप्‍त ङा पिपम मेको आस कली “मोसा नु हारून, गे मारदे मुर आन कली आन गेय क्‍योल्‍चा माल्‍नीसी? इस गेय पथ लस” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","मिनु फाराओमी लेंशा “नेनीस, इस जात ङा मुर शुश दुम्‍तेक्‍म। गे मेको आन कली आन गेय रे नाइक्‍चा गेचा माल्‍सी?” दे मोसा नु हारून आस कली हुइक्‍ताक्‍व। प्रस्‍थान १:७,१२ ");
INSERT INTO suzBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","मोपतीके मेको नाक्‍ती रे फाराओमी गेय पपाइक्‍ब ठेयब मुर नु कोव़ब मुर आन कली ");
INSERT INTO suzBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“मुल रे इस्राएली आन कली इंटा सेल्‍चा कली पराल मगेचा, आंमा गुप्‍थ लचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तन्‍न इंटा चहिं ङोंइती दोशो सेल्‍मे, मुल यो मोशोन सेल्‍चा माल्‍नीमी। मिनु आन गेय ङोंइती पशो खोदेंशो पा पचा माल्‍नीम। मारदे हना आन गेय मबाक्‍मेनु, मेकोपुकीमी ‘गोपुकी गोरशो रागीम आंइ परमप्रभु कली चढ़ेचा दाक्‍नीकी’ दे लोव़ पशा ग्रीनीम। ");
INSERT INTO suzBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","मेको मुर आन कली शुश गेय पपाइश्‍शा श्‍येत गेचा माल्‍नीनी। मेकोपुकीम गेय पा बाक्‍मानु, दूली लोव़ मनेंनीम” दे आ मुर आन कली देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","मिनु इस्राएली आन कली गेय पपाइक्‍बपुकी नु कोव़बपुकीमी मुर आन कली “फाराओमी ‘इन कली पराल मगेनुङ’ देंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","मोपतीके ते खुप्‍ने चाप्‍नीनी, मेक ङा खुप्‍तीन। इंटा चहिं ङोंइती दोशो सेल्‍नी, मुल यो मोशोन सेल्‍चा माल्‍नीनी” दे मदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","मोपा मेकोपुकी इजीप्‍त रागीमी पराल मथित्‍तीके पराल के ठुटा गुप्‍थ ब्रशा गाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","गेय पपाइक्‍बपुकीमी “पराल गेशो नाक्‍त दोशो इंटा सेल्‍नी, मुल यो मोशोन सेल्‍चा माल्‍नीनी” दे शुश गेय पपदमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फाराओ आ गेय पपाइक्‍ब इस्राएली कोव़बपुकी यो वोइश्‍शो बाक्‍मा बाक्‍त। मेको आन कली तुप्‍शा “ङोंइती ङा खोदेंशो पा सिनाक्‍ती मुलाक्‍ती इंटा मारदे मसेल्‍नी?” दे इस्राएली कोव़ब आन कली हुइक्‍तमे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","मिनु इस्राएली कोव़बपुकीमी फाराओ कली “मारदे इन वाइल आन कली ओदेंशो मरिम्‍शो पाइनीनी? ");
INSERT INTO suzBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","इन वाइल आन कली पराल मगेथु ‘इंटा सेलीने’ दे हुइक्‍नीनी। मेको ला ममाइ, इन मुरपुकीमी आंइ कली तुप्‍नीम। गे इन रागी ङा मुर आन कली मरिम्‍शो पपाइक्‍नीनी” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","मिनु फाराओमी “गे अल्‍सेपुकी, थम अल्‍से दुम्‍तीनी। मोपतीके गे ‘आंइ कली परमप्रभु यावे कली चढ़ेथ लचा गेने’ देंतीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","मुल गेय पथ लने। पराल मगेंसीब, इंटा चहिं ङोंइती दोशो सेल्‍नी, मोशोन सेल्‍चा माल्‍नीनी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","मिनु इस्राएली कोव़बपुकीमी “इं कली मरिम्‍शो पशा, शुश श्‍येत गेनीम” दे तुइक्‍तमे बाक्‍त। मारदे हना “ङोंइती नाक्‍त किंत किंत दोशो इंटा सेल्‍नी, मुल यो मोशोन सेल्‍चा माल्‍नीनी” देंशो बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","मिनु फाराओ आ बाक्‍तीके रे लमानु, मेकोपुकीमी लांमी रिम्‍शा बाक्‍शो मोसा नु हारून आस कली ग्रुम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","मिनु मेको कोव़बपुकीमी “परमप्रभु यावेमी इस कली सजाइ गेवल। मारदे हना गे निक्‍शीमी फाराओ नु आ मुर आन ङोंइती आंइ कली मरिम्‍शो सेल्‍तीसी। आंइ कली साइक्‍चा, दे तरवार आन गुइमी गेतीसी” दे गाइश्‍शा हुइक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मिनु मोसा परमप्रभु यावे आ नेक्‍था लशा “परमप्रभु, मारदे गे इन मुर आन कली मरिम्‍शो पाइनीनी? आं कली मारदे एक सोइक्‍तीनी? ");
INSERT INTO suzBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","गो इन नेंमी फाराओ नु लोव़ पङा नोले, मेकोमी इन मुर आन कली ङोंइती क्‍येङा शुश श्‍येत गेप्‍तु। गे चहिं इन मुर आन कली मप्रोंइनी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","मिनु नोले परमप्रभु यावेमी मोसा कली “गो फाराओ कली मार पाइनुङा, गे मुल ताइनेवे। फाराओम मेको आन कली लचा गेचा ला ममाइ, ठेयब सक्तिमी फाराओ कली आं मुर आन कली आ रागी रे खेरपाइक्‍नुङ” दें‍त। प्रस्‍थान ११:१; प्रस्‍थान १२:३३ ");
INSERT INTO suzBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","मिनु लेंशा परमप्रभुमी मोसा कली “गो यावे नङ। प्रस्‍थान ३:१४-१५; उत्‍पत्ती १७:१ ");
INSERT INTO suzBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","गो अब्राहाम, इसहाक नु याकूब आन ङोंइती ग्रूशो ‘नेल्‍ल क्‍येङा सक्ति पाइश्‍शो परमप्रभु नङ’ दे मेको आन कली तुइक्‍पाइक्‍ताक्‍मी। तन्‍न ‘आं नें यावे बाक्‍ब’ दे मतुइक्‍पदुमी। ");
INSERT INTO suzBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","गो मेको आन कली ‘गे मुल अर्को रागी ङा मुर दुम्‍शा, हिरना हिरन बाक्‍शो कनानी आन रागी इन कली गेनुङ’ दे अब्राहाम, इसहाक नु याकूब नु कबल पने थुम्‍शो नङ। उत्‍पत्ती १७:८ ");
INSERT INTO suzBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","मिनु गो इजीप्‍त ङा मुरपुकीमी इन कली गेय पाइब सेल्‍मेनु, श्‍येत जशो इस्राएली आन ङाक्‍शो ताता। मिनु गो आं कबल पशो मिम्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","मोपतीके गो इस्राएली आन कली ‘गो परमप्रभु यावे नङ। गो इजीप्‍त ङा मुर आन गेशो श्‍येत नु इन वाइल दुम्‍शो गेय रे प्रोंइनन्‍नी। गो इजीप्‍त ङा मुर आन कली ठेयब सजाइ गेशा, आं ठेयब सक्तिमी इन कली ग्रुंइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मिनु गो इन कली आं मुर सेल्‍नुङ। गो इन परमप्रभु दुम्‍नुङ। मिनु गो इन कली इजीप्‍त ङा मुर आन गेशो श्‍येत रे ग्रुंइब, परमप्रभु यावे, इन परमप्रभु नङ, दे तुइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मिनु गो अब्राहाम, इसहाक नु याकूब आन कली गेनुङ, दे कसम जशो रागीम इन कली चाक्‍दीत्‍नुङ। मिनु मेको रागी इन के दुम्‍ब। गो परमप्रभु यावे नङ’ दे गे इस्राएली आन कली देंचा माल्‍नेवे” दें‍त। उत्‍पत्ती २२:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मिनु मोसामी मेको लोव़ इस्राएली आन कली नेंपदानु, वाइल दुम्‍तीके नु आन थुं लुक्‍च लतीके मोसा आ लोव़ मने‍नेम। ");
INSERT INTO suzBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“गे इजीप्‍त ङा पिप फाराओ कली ‘इस्राएली आन कली इन रागी रे लचा गेने’ दे मतो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","मिनु मोसामी परमप्रभु यावे कली “इस्राएलीपुकीमी ला यो आं लोव़ मनेनेम हना, गो ब्‍वाक्‍स मजोक्‍ब मुर आं लोव़ फाराओम दोपा नेंबा?” दे लोव़ लेत्‍ताक्‍व। प्रस्‍थान ६:३०; प्रस्‍थान ४:१० ");
INSERT INTO suzBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","मोपा परमप्रभु यावेमी मोसा नु हारून आस कली इस्राएली आन पर्बम लोव़ पाप्‍तु। मिनु “गेमी इजीप्‍त ङा पिप फाराओ कली ‘इस्राएली आन कली इन रागी रे लचा गेचा माल्‍नीनी’ दे रुप्‍पतीस” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएली आन किकी पिपी आन दातेमी ठेयब दुम्‍शो, सु सु बाक्‍मा बाक्‍त देंशा हना, इस्राएल आ ङोंइती जरमेशो तौ रूबेन मेको आ तौपुकी हनोक, पल्‍लु, हेस्रोन नु कारमी बाक्‍मा बाक्‍त। मेको रूबेन आ खिं खिं ङा मुर बाक्‍मा बाक्‍त। उत्‍पत्ती ४६:९-११ ");
INSERT INTO suzBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","सिमियोन आ तौपुकी येमुएल, यामीन, ओहद, याकीन नु सोहार बाक्‍मा बाक्‍त। मिनु का कनानी मीश रे जरमेशो शावल बाक्‍माक्‍त। मेको सिमियोन आ खिं ङा मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","मिनु लेवी आ तौ आन खिं खिं ङा मुर सु सु बाक्‍मा बाक्‍त देंशा हना, गेरशोन, कोहाथ नु मेरारी बाक्‍मा बाक्‍त। मिनु लेवी सहे का ३७ बर्स ब्रोंइमाक्‍त। १इतिहास ५:२७-३०; १इतिहास ६:१-४ ");
INSERT INTO suzBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेरशोन आ तौ लिब्‍नी नु शिमेइ बाक्‍सा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कोहाथ आ तौपुकी अम्राम, इच्‍हार, हेब्रोन नु उज्‍जीएल बाक्‍मा बाक्‍त। मिनु कोहाथ सहे का ३३ बर्स ब्रोंइमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मिनु मेरारी आ तौ माहली नु मुशी बाक्‍सा बाक्‍त। मेको लेवी आ खिं खिं ङा मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","मिनु अम्राममी आ आफ आ समी चाक्‍गा बाक्‍त। मेको आ नें योकेबेद बाक्‍माक्‍त। मेकोमी हारून नु मोसा थिमाक्‍त। अम्राम सहे का ३७ बर्स ब्रोंइमाक्‍त। प्रस्‍थान २:१; लेवी १८:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इच्‍हार आ तौपुकी कोराह, नेफेग नु जिक्री बाक्‍मा बाक्‍त। गन्‍ती १६:१ ");
INSERT INTO suzBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्‍जीएल आ तौपुकी मीशाएल, एल-साफान नु सिथ्री बाक्‍मा बाक्‍त। लेवी १०:४ ");
INSERT INTO suzBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","मिनु हारूनम नहशोन आ समी अम्‍मीनादाब आ तमी एली-शेबा चाक्‍गा बाक्‍त। मेकोमी नादाब, अबीहु, एलाजर नु इथामार थिमाक्‍त। प्रस्‍थान २८:१ ");
INSERT INTO suzBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोराह आ तौपुकी अस्‍सीर, एल्‍काना नु अबी-आसाफ बाक्‍मा बाक्‍त। मेको कोराह आ खिं ङा मुर बाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","मिनु हारून आ तौ एलाजरम पुतीएल आ तमी चाक्‍गा बाक्‍त। मेकोमी फिनेहास थिमाक्‍त। मेकोपुकी लेवी आ खिं ङा ठेयब मुर बाक्‍मा बाक्‍त। गन्‍ती २५:७ ");
INSERT INTO suzBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","मिनु परमप्रभु यावेमी हारून नु मोसा कली “गे इस्राएल ङा मुरपुकी हुल हुल पा इजीप्‍त रागी रे ग्रुंइदीस” देंत। प्रस्‍थान ६:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","मिनु मेको निक्‍शीमी इजीप्‍त ङा पिप फाराओ कली “इस्राएल ङा मुर आन कली लचा गेने” दे लोव़ पाम्‍ताक्‍से। ");
INSERT INTO suzBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मिनु परमप्रभु यावेमी इजीप्‍त रागीमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“गो परमप्रभु यावे नङ। गे इजीप्‍त ङा पिप फाराओ कली आं देंशो लोव़ नेल्‍ल माइक्‍चा माल्‍नेवे” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","मिनु मोसामी परमप्रभु यावे कली “गो ब्‍वाक्‍स मजोक्‍ब मुर नङ। दोपा फाराओमी आं लोव़ नेंबा ङा?” दें‍त। प्रस्‍थान ६:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","परमप्रभु यावेमी मोसा कली “नेनो, गो इ कली फाराओ आ ङोंइती परमप्रभु खोदेंशो पा चिन्‍ड कोंइने चाप्‍ब सेल्‍तन। इ लोक्‍ब हारून चहिं इ लोव़ पाइब दुम्‍ब। प्रस्‍थान ४:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","गो इ कली मार मार माइक्‍ना, गे मेको देंचा माल्‍नेवे। मिनु इ लोक्‍ब हारूनमी ‘इस्राएली आन कली इन रागी रे लचा गेन’ दे फाराओ कली देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","तन्‍न गो फाराओ कली काइ मटीब सेल्‍नुङ। मिनु गो इजीप्‍त रागीमी शुश चिन्‍ड नु छक लाक्‍चा ङा गेय कोंइनुङ। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","मिनु फाराओमी इस कली मटीब। मिनु गो इजीप्‍त ङा मुर आन कली थाम्‍पान सजाइ गेशा, आं शुश मुर आन कली इजीप्‍त रागी रे ग्रुंइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","गो इजीप्‍त ङा मुर आन कली थाम्‍पान सजाइ गेशा, इस्राएली आन कली आन दाते रे ग्रुंइदुनु ‘गो परमप्रभु यावे नङ’ दे इजीप्‍त ङा मुर आन कली तुइक्‍पाइक्‍नुङ” देंत। प्रस्‍थान ७:१७; प्रस्‍थान ८:१८; प्रस्‍थान ९:२९; १सामुएल १७:४६; १राजा २०:२८; २राजा १९:१९; इजीकीएल २९:६ ");
INSERT INTO suzBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मिनु मोसा नु हारूनमी परमप्रभु यावे आ देंशो पाम्‍ताक्‍से। ");
INSERT INTO suzBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","मोपा फाराओ नु लोव़ पची ना, मोसा ८० बर्स दुम्‍शो बाक्‍त। हारून ८३ बर्स दुम्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फाराओमी इस कली ‘छक लाक्‍चा ङा चिन्‍ड कोंइदीसे’ देंमेनु, गेमी हारून कली ‘इ कोक्‍के बुस्‍स दुम्‍पाइक्‍चा कली फाराओ आ ङोंइती ब्‍वारदो’ देंचा माल्‍नेवे। मिनु मेको कोक्‍के बुस्‍स दुम्‍ब” देंत। प्रस्‍थान ४:३ ");
INSERT INTO suzBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मोपा मोसा नु हारूनमी परमप्रभु यावे आ देंशो पशा, फाराओ आ बाक्‍तीकेमी लाम्‍ताक्‍स। मिनु हारूनमी आ कोक्‍के फाराओ नु आ गेय पाइब मुर आन ङोंइती ब्‍वारताक्‍व। मिनु मेको कोक्‍के बुस्‍स दुम्‍‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","मिनु फाराओमी इजीप्‍त रागी ङा जादू नु टुना मुना पाइब आन कली ब्रेत्‍ताक्‍मी। मेकोपुकीमी यो आन टुना मुनामी हारून खोदेंशो पा आन कोक्‍के ब्‍वारशा, बुस्‍सपुकी सेल्‍तेक्‍म। प्रस्‍थान ७:२२; प्रस्‍थान ८:३; उत्‍पत्ती ४१:८; २तिमोथी ३:८ ");
INSERT INTO suzBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","तन्‍न हारून आ कोक्‍के रे दुम्‍शो बुस्‍सुमी मेको आन कोक्‍के रे दुम्‍शो बुस्‍स नेल्‍ल आन कली दाक्‍‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","मिनु परमप्रभु यावेमी देंशो खोदेंशो पा फाराओ काइ मटीब दुम्‍शा, मोसा नु हारून आस देंशो लोव़ मबिस्‍से। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","मिनु परमप्रभु यावेमी मोसा कली “फाराओ काइ मटीब दुम्‍‍त। आं मुर आन कली लचा मगेब। ");
INSERT INTO suzBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","गे दीसा सुनी फाराओ ग्रुम्‍थ लचा माल्‍नीसी। फाराओ ब्‍वाक्‍कु आ नेक्‍था लमेनु, गे मेको आ क्‍येङा ङोंइती खोला आ नेक्‍था जाक्‍दीश्‍शा, रिम्‍शा बाक्‍चा माल्‍नीसी। बुस्‍स दुम्‍ब कोक्‍के यो लाइक्‍चा माल्‍नीसी। ");
INSERT INTO suzBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","मिनु गे मेको कली ‘परमप्रभु यावे, हिब्रू मुर आन परमप्रभुमी इन कली, आं मुर आन कली आं कली चढ़ेतीक चढ़ेथ गोरशो रागी लचा गेवो, देंती। तन्‍न गे मुल सम्‍म आं लोव़ मटिवी’ देंत” देनीस। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","मोपतीके परमप्रभु यावेमी “गो परमप्रभु यावे नङ। गे आं पतीकेमी तुइक्‍नेवे। गो आं कोक्‍केमी नील खोला ङा ब्‍वाक्‍कु तुप्‍नुङ। मिनु मेको हुश दुम्‍ब। प्रस्‍थान ४:९ ");
INSERT INTO suzBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","मिनु खोला ङा ङांइ नेल्‍ल बेक्‍नीम। खोला शुश राक्‍शो रिना पाइब। मिनु इजीप्‍त ङा मुरपुकी मेको ब्‍वाक्‍कु तूचा ग्रांग्रा दीनीम” दे मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","मिनु परमप्रभु यावेमी मोसा कली “गेमी हारून कली ‘इ कोक्‍के इजीप्‍त रागी ङा ब्‍वाक्‍कु हुश दुम्‍पाइक्‍चा कली ब्‍वाक्‍कु तारी दिंदो। नादी, खोला, कुवा नु इनार आन तारी दिंदो। मुर आन चाक्‍शो ठेका नु गरम बाक्‍शो ब्‍वाक्‍कु यो हुश दुम्‍ब’ दे हारून कली देनो” देंत। प्रकाश ११:६ ");
INSERT INTO suzBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","मिनु परमप्रभु यावेमी मोसा नु हारून कली दोदेंशो देंमे, मोदेंशो पाम्‍ताक्‍स। मोसामी फाराओ नु आ गेय पाइब आन ङोंइती आ कोक्‍के खोला ङा ब्‍वाक्‍कु तार दिंशा तुबानु, हुश दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","मोपा नील खोला ङा ङांइ नेल्‍ल बेक्‍तेक्‍म। मिनु ब्‍वाक्‍कु राक्‍शो रिना पाइश्‍शो दुम्‍‍त। इजीप्‍त रागी ङा मुर नेल्‍लेमी नील खोला ङा ब्‍वाक्‍कु तूने मचबेम। इजीप्‍त रागी नेल्‍ल हुशेइ हुश दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","इजीप्‍त रागी ङा ठेयब टुना मुना पाइबपुकीमी यो आन मन्‍तरमी आस पशो खोदेंशो पाम्‍तेक्‍म। फाराओ आ थुं चहिं ङोंइती ङा खोदेंशो पा काइ मटीब दुम्‍माक्‍त। मिनु मोसा नु हारून आस देंशो मटिवो। परमप्रभु यावेमी ङोंइती दोदेंशो देंमे, मोदेंशो दुम्‍‍त। प्रस्‍थान ७:११ ");
INSERT INTO suzBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","मिनु फाराओ आ खिं लेम्‍माक्‍त। मार दुम्‍मे, मारेइ ममिम्‍ता बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","इजीप्‍त रागी ङा मुरपुकीमी नील खोला आ नेक्‍था शुश कुवा दोम्‍तेक्‍म। मारदे हना नील खोला ङा ब्‍वाक्‍कु काइ तूचा मदुम। ");
INSERT INTO suzBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","मोपा परमप्रभु यावेमी नील खोला ङा ब्‍वाक्‍कु तुप्‍शा, हुश दुम्‍शो ७ नाक्‍ती दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","मिनु नोले परमप्रभु यावेमी मोसा कली “गे फाराओ आ बाक्‍तीक लावो। परमप्रभु यावेमी आ मुर आन कली लचा गेमी। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","गे लचा मगेतीनी हना, क्रुक्‍क्रुपुकीमी इ रागी ङा मुर नेल्‍ल आन कली श्‍येत गेपाइक्‍नुङमी। ");
INSERT INTO suzBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील खोलाम शुश क्रुक्‍क्रु ग्रूपाइक्‍नुङ। मेकोपुकी इन खिंम बाक्‍थ जाक्‍नीम। इन इप्‍तीक कोठामी यो ओव़नीम। इन खाट तार ङोइक्‍नीम। मिनु इन दरवार ङा गेय पाइब आन खिंमी यो ओव़नीम। मुर आन तार नु आन चुप्‍लुमी यो बाक्‍नीमी। आन फस नित्‍तीके बोस आगाम ओव़नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","मेको क्रुक्‍क्रुपुकी इन तारी, इन मुर आन तारी नु इन दरवार ङा गेय पाइब आन तारी जाक्‍नीम, दे परमप्रभु यावे आ देंशो लोव़ बाक्‍ब, दे मतो” दे मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","मिनु नोले परमप्रभु यावेमी मोसा कली “गेमी हारून कली ‘इ कोक्‍के खोला नेल्‍ल आन तार दिंदो। मोपा गे इजीप्‍त रागीम क्रुक्‍क्रु ग्रूपाइक्‍नेवे’ दे हारून कली देनो” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","मिनु हारूनमी आ गुइ इजीप्‍त ङा ब्‍वाक्‍कु तारी दिंताक्‍व। मिनु क्रुक्‍क्रुपुकी ग्रूशा, इजीप्‍त रागी नेल्‍ल ब्रीतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","इजीप्‍त रागी ङा जादू टुना मुना पाइबपुकीमी यो आन मन्‍तरमी हारून खोदेंशो पा क्रुक्‍क्रु ग्रूपाइक्‍तेक्‍म। प्रस्‍थान ७:११ ");
INSERT INTO suzBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","मिनु फाराओमी मोसा नु हारून आस कली ब्रेप्‍पाइश्‍शा “आं पर्बम नु आं मुर आन पर्बम परमप्रभु यावे कली पुनीस। क्रुक्‍क्रु लमल, दे पुनीस। गोमी इस्राएल जात ङा मुर आन कली परमप्रभु यावे कली चढ़ेथ लचा गेनुङ” दे मोसा नु हारून आस कली देंत। प्रस्‍थान ८:२४; प्रस्‍थान ९:२८; प्रस्‍थान १०:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मिनु मोसामी फाराओ कली “हजुर, इन कली नु इन गेय पाइब आन कली, इन मुर आन खिं नु इन खिं रे क्रुक्‍क्रु लमल, नील खोलाम ला बाक्‍मल, दे गेना पुंइचा माल्‍नस्‍कु?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","मिनु “दीसा कली पुनीस” दे लोव़ लेत्‍ताक्‍व। मोसामी “परमप्रभु यावे आंइ परमप्रभु खोदेंशो सुइ मबा, दे तुइक्‍पाइक्‍चा कली इन देंशो दीसा दुम्‍ब। प्रस्‍थान ९:१४; प्रस्‍थान १५:११; ब्‍यवस्‍था ३३:२६; २सामुएल ७:२२; येरमीया १०:६ ");
INSERT INTO suzBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","दीसा क्रुक्‍क्रुपुकी इन बाक्‍तीक, इन गेय पाइब नु इन मुर इन खिं नेल्‍ल रे गाक्‍नीमी। नील खोलाम ला बाक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मोपा मोसा नु हारून फाराओ आ खिं रे लाम्‍ताक्‍स। मिनु मोसामी मेको परमप्रभु यावे आ सोइश्‍शो क्रुक्‍क्रु आ पर्बम पुंइतु। ");
INSERT INTO suzBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","मिनु परमप्रभु यावेमी मोसामी पुंइशो नेंशा पाप्‍तु। खिंम, लाङगाम नु रूम बाक्‍शो क्रुक्‍क्रु नेल्‍ल बेक्‍‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","मुरुमी बेक्‍शो क्रुक्‍क्रु नेल्‍ल खुप्‍ताक्‍म। मिनु रागी नेल्‍ल थाम्‍पा रिना पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","इजीप्‍त रागी ङा फाराओ चहिं मेको क्रुक्‍क्रु रे ब्रोंइशो तशा, आ थुं ङोंइती ङा खोदेंशो पा काइ मटीब दुम्‍माक्‍त। मिनु मोसा नु हारूनम देंशो लोव़ मपव। ङोंइती परमप्रभु यावेमी मो देंशो बाक्‍माक्‍त। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","मिनु नोले परमप्रभु यावेमी मोसा कली “गेमी हारून कली ‘इ कोक्‍के दिंशा, फुरक तुपो’ दे मतो। मिनु मो पवानु, इजीप्‍त रागीमी फुरक नेल्‍ल भुस्‍ना दुम्‍शा फोंइनीम” दे मोसा कली माइक्‍तु। प्रस्‍थान ");
INSERT INTO suzBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","मिनु हारूनमी फुरक तुबानु, इजीप्‍त रागी नेल्‍लेमी मुर नु बस्‍तु भाव आन तारी भुस्‍ना शुश फोंइतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","इजीप्‍त रागी ङा जादू टुना मुना पाइबपुकीम यो हारून खोदेंशो पा भुस्‍ना ग्रूपाइक्‍चा माल्‍तेक्‍म। तन्‍न मचबेम। मुर नु बस्‍तु भाव आन तारी भुस्‍ना शुश जुक्‍ताक्‍म। प्रस्‍थान ७:११ ");
INSERT INTO suzBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","मिनु जादू टुना मुना पाइबपुकीमी फाराओ कली “एको परमप्रभुमी पाप्‍तु” देंमा बाक्‍त। फाराओ चहिं काइ मटीब दुम्‍माक्‍त। मिनु मोसा नु हारून आस देंशो लोव़ मटिव। परमप्रभु यावेम ङोंइती देंशो खोदेंशो दुम्‍त। भजन संग्रह ६४:१०; भजन संग्रह ७२:१८; लूका ११:२० ");
INSERT INTO suzBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","मिनु परमप्रभु यावेमी मोसा कली “सुनी कना बोक्‍को। फाराओ खोला लमेनु, मेको कली ग्रुम्‍थ लावो। मिनु फाराओ कली ‘परमप्रभु यावेमी, आं मुर आन कली आं कली चढ़ेथ लचा गेवो। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","नेनो, गे आं मुर आन कली लचा मगेप्‍तीवी हना, गो इ कली, इ गेय पाइब आन कली नु इ मुर नेल्‍ल आन कली श्‍येत जपाइक्‍चा कली इ खिंमी, इ रागी ङा मुर आन खिंमी डांसम ब्रीपाइक्‍नुङ। रू नेल्‍ल डांसम ब्रीपाइक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","मेको मो दुम नाक्‍ती आं मुर आन बाक्‍तीक गोशेनमी चहिं डांस मग्रूपाइक्‍नुङ। अरु इजीप्‍त रागीमी ग्रूपाइक्‍नुङ। आं पर्बम तुइक्‍पाइक्‍चा कली मो पाइनुङ। मिनु गे आं पर्बम परमप्रभु यावे मेको रागीम बाक्‍ब, दे तुइक्‍चा माल्‍नेवे। प्रस्‍थान ७:५ ");
INSERT INTO suzBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मोदेंशो पा गो आं मुर आन बाक्‍तीकेमी डांस मग्रूपाइक्‍नुङ। इ मुर आन बाक्‍तीकेमी ला डांस ग्रूपाइक्‍नुङ। दीसा गे तुइक्‍नेवे, देनो’ देंत” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","मिनु परमप्रभु यावेमी आ देंशो पाप्‍तु। डांस शुश फोंइशा फाराओ आ खिं, आ दरवारम गेय पाइब आन खिं, इजीप्‍त रागी नेल्‍लेमी शुश डांस फोंइशा ब्रीतेक्‍म। मिनु डांसमी मेको रागी नेल्‍ल खतम सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","मिनु नोले फाराओमी मोसा नु हारून आस कली ब्रेप्‍पाइश्‍शा “लने, इन परमप्रभु कली आं रागी उइ चढ़ेने” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मोसामी चहिं “मो पचा मदुम्‍ब। मारदे हना परमप्रभु यावे, आंइ परमप्रभु कली चढ़ेशो तशा, इजीप्‍त ङा मुर ग्रांग्रा दी‍नीम। मोपा इजीप्‍त ङा मुर आन ङोंइती आन मदाक्‍शो गेय पकानु, मेकोपुकीमी आंइ कली फुल्‍लु आप्‍शा, साइक्‍नीम। उत्‍पत्ती ४३:३२; उत्‍पत्ती ४६:३४ ");
INSERT INTO suzBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","गोपुकी नाक्‍त सां ङा लां गाक्‍शा, गोरशो रागीम लशा, परमप्रभु यावेम देंशो खोदेंशो पा चढ़ेचा माल्‍नीकी” दें‍त। प्रस्‍थान ३:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","मिनु फाराओमी “गो इन कली गोरशो रागीम परमप्रभु यावे, इन परमप्रभु कली चढ़ेथ लचा गेनुङ। शुश ङोन चहिं मलने। आं पर्बम यो पुनीस” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मिनु मोसामी “मुल गो एकेर रे लशा, परमप्रभु यावे कली पुंइनुङ। मार पुंइनुङ देंशा हना ‘दीसा फाराओ, आ गेय पाइब नु रागी ङा मुर नेल्‍ल आन बाक्‍तीक रे डांस प्रोक्‍पतीने’ दे पुंइनुङ। तन्‍न लोव़ का पाइनुङ। गे आंइ कली परमप्रभु यावे कली चढ़ेचा दुम्‍ब, दे नोले ‘लचा मगेनुङ’ देंशा, जोल मपने” दे मोसामी फाराओ कली दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मो देंशा मोसा फाराओ आ खिं रे लशा, परमप्रभु यावे कली पुंइतु। प्रस्‍थान ८:८ ");
INSERT INTO suzBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","मिनु परमप्रभु यावेमी मोसा आ पुंइशो लोव़ नेंशा पाप्‍तु। मिनु डांस फाराओ आ खिं, आ गेय पाइब नु मुर नेल्‍ल रे तिल्‍तु। काइ मलीम। ");
INSERT INTO suzBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तन्‍न फाराओ लेंशा काइ मटीब दुम्‍शा, इस्राएली आन कली लचा मगेव। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","मिनु परमप्रभु यावेमी मोसा कली “फाराओ आ बाक्‍तीके लावो। मिनु गे परमप्रभु यावे, हिब्रू मुर आन परमप्रभुमी इन कली ‘आं मुर आं कली चढ़ेथ लचा गेवो। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","नेनो, गे मेको आन कली लचा मगेथु, तेक्‍तीवी हना, यसैया १:२० ");
INSERT INTO suzBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","परमप्रभु यावेमी इन गोठम बाक्‍शो बस्‍तु भाव आन कली ठेयब रोइ पपाइक्‍ब। इन शारा, गधा, दलओंठ, बी ब्‍यफ नु क्‍यारश भेडा नेल्‍ल आन कली बेक्‍तीक रोइ पपाइक्‍ब। प्रस्‍थान ३:२० ");
INSERT INTO suzBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","तन्‍न इस्राएली आन बस्‍तु भाव आन कली रोइ मपपाइक्‍ब। इजीप्‍त ङा मुर आन बस्‍तु भाव आन कली चहिं रोइ पपाइक्‍ब। इस्राएली आन बस्‍तु भाव मबेक्‍नीम’ दे फाराओ कली माइक्‍चा माल्‍नेवे” दे परमप्रभु यावेमी मोसा कली दें‍त। प्रस्‍थान ८:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","मिनु परमप्रभु यावेमी “गो दीसा इजीप्‍त रागीम मो पाइनुङ” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","मिनु आ दीसा परमप्रभु यावेमी आ देंशो पाप्‍तु। इजीप्‍त रागी ङा मुर आन बस्‍तु भाव बेक्‍मा बाक्‍त। तन्‍न इस्राएली आन बस्‍तु भाव चहिं मबेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","मिनु फाराओमी इस्राएल ङा मुर आन बस्‍तु भाव यो बेक्‍मा कों, दे कोव़थ मुर सोइक्‍ताक्‍व। तन्‍न का यो मबेक्‍शो बाक्‍तेक्‍म, दे तुइक्‍पाइक्‍तेक्‍म। मोपा यो फाराओ काइ मटीब दुम्‍शा, इस्राएली आन कली लचा मगेव। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","मिनु नोले परमप्रभु यावेमी मोसा नु हारून आस कली “गे चुप्‍लु ङा पुलु हुइश्‍शा कुरशा लस। मिनु मोसामी फाराओ आ ङोंइती मेको पुलु सरीङ गे फ्रचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","मेको पुलु फुरक दुम्‍शा, मुर नु बस्‍तु भाव आन कली मरिम्‍शो गार मुपाइक्‍ब। इजीप्‍त रागी नेल्‍लेमी मोदेंशो दुम्‍ब” देंत। ब्‍यवस्‍था २८:२७ ");
INSERT INTO suzBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","मिनु मोसा नु हारूनमी चुप्‍लु ङा पुलु हुइश्‍शा कुरशा, फाराओ आ ङोंइती राप्‍ताक्‍स। मिनु मोसामी मेको पुलु सरीङ गे फ्राप्‍तु। मिनु मुर नु बस्‍तु भाव नेल्‍ल शुश गार मुतेक्‍म। प्रकाश १६:२ ");
INSERT INTO suzBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","मिनु इजीप्‍त रागी ङा जादू पाइबपुकी यो शुश गार मुशा, रोइ पशा, मोसा आ नेक्‍था बाक्‍ने मचबेम। ");
INSERT INTO suzBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","परमप्रभु यावेमी फाराओ कली काइ मटीब दुम्‍पदा बाक्‍त। मिनु मोसा नु हारून आस लोव़ मटिव। परमप्रभु यावेमी मोसा कली ङोंइती दोदेंशो देंमे मोदेंशो दुम्‍त। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","मिनु परमप्रभु यावेमी मोसा कली “सुनी कना बोक्‍शा, फाराओ कली ग्रुम्‍थ लशा, परमप्रभु यावे, हिब्रू मुर आन परमप्रभुमी इन कली ‘आं मुर आन कली आं कली चढ़ेथ लचा गेवो। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","मारदे हना मुल रे गेचशो श्‍येतम इ कली, इ गेय पाइब आन कली नु इ मुर नेल्‍ल आन कली सोइक्‍नुङ। रागी रागीमी आं खोदेंशो सुइ मबाक्‍ब, दे इ कली तुइक्‍पाइक्‍नुङ। प्रस्‍थान ८:६ ");
INSERT INTO suzBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","मुल गो इ कली नु इ मुर आन कली बेक्‍तीक रोइ पपदु वा। ");
INSERT INTO suzBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","तन्‍न गो आं सक्ति रागी नेल्‍लेम तुइक्‍पाइक्‍चा कली इ कली मुल सम्‍म ब्रोंइचा गेता। आ नें रागी नेल्‍ल ङा मुर आन कली तुइक्‍पाइक्‍चा, दे इ कली ब्रोंइचा गेता। प्रस्‍थान १४:४; रोमी ९:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","गे आं मुर आन कली लचा मगेतीके, इ ठेयब लेश्‍शो तुइक्‍ताक्‍ङ। ");
INSERT INTO suzBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","नेनो, दीसा गो शुश मरिम्‍शो मुप्‍स यिपाइक्‍नुङ। मुल सम्‍म इजीप्‍त रागीमी मुर बाक्‍चा गोव़मे रे मोदेंशो ठेयब मुप्‍स गेनायो मयिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","मोपतीके इ बस्‍तु भाव आन कली खिं आगा ओंइदो। मारदे हना मुर नु बस्‍तु भाव, सु सु लाङगाम बाक्‍नीमी, मेको मुप्‍सीम तुप्‍शा बेक्‍नीम’ देनो देंत” दे परमप्रभु यावेमी मोसा कली देंपाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फाराओ आ गेय पाइब आन दातेमी सु सु परमप्रभु यावे क्‍येङा हिंमा, मेकोपुकीमी आन गेय पाइब नु आन बी ब्‍यफ, क्‍यारश भेडा आन कली खिं आगा ओंइताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","सु सु परमप्रभु यावे आ देंशो लोव़ क्‍येङा महिंमा, मेकोपुकीमी चहिं आन गेय पाइब नु आन बस्‍तु भाव आन कली खिं आगा मओंइदेम। ");
INSERT INTO suzBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","मिनु नोले परमप्रभु यावेमी मोसा कली “इ गुइ सरीङ गे दिंदो। मो पवीनु, इजीप्‍त रागी नेल्‍लेमी मुप्‍स यीब। मुप्‍स यिशा, मुर बी ब्‍यफ, क्‍यारश भेडा नु रू आन तारी देल्‍ब” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","मिनु मोसामी आ कोक्‍के सरीङ गे दिंदानु, बुंबु चिला पा, मुप्‍स यि‍त। मोपा परमप्रभु यावेमी इजीप्‍त रागीमी मुप्‍स यिपाइक्‍‍तु। मिनु परमप्रभु यावेमी चिला दाप्‍पाइश्‍शा, मुप्‍स यिपाइक्‍तु। प्रकाश १६:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","चिला पना पन मुप्‍स यि‍त। मेको मुप्‍स थम कोल्‍कोल्‍शो बाक्‍तेक्‍म। इजीप्‍त रागीम मुर बाक्‍चा गोव़मे रे मोमो कोल्‍शो मुप्‍स गेनायो मतशो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","मिनु इजीप्‍त रागी ङा रूम वाशो मारेइ मारेइ मुप्‍सीमी श्‍येत्‍थ पोक्‍तु। मुर नु बी ब्‍यफ, क्‍यारश भेडा आन कली साइक्‍तु। रूम मार मार ख्रुम्‍शो बाक्‍मे, मेको नेल्‍ल साइश्‍शा, रवा आन कली यो जिक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","इस्राएली आन बाक्‍तीके गोशेनमी ला मुप्‍स मयी। प्रस्‍थान ९:४; प्रस्‍थान ८:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","मिनु फाराओमी मोसा नु हारून आस कली ब्रेत्‍ताक्‍मसी। मिनु मेको आस कली “मुल गो पाप पाता। परमप्रभु यावे ठीक पाइब बाक्‍ब। गो नु आं मुरपुकीम मरिम्‍शो पाइतक। ");
INSERT INTO suzBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","आंइ पर्बम परमप्रभु यावे कली पुनीस। एको बुंबु नु मुप्‍स मयिपदल। गो इन कली लचा गेनुङ। मुल गे एकेर बाक्‍चा ममाल्‍नीनी” देंत। प्रस्‍थान ८:४ ");
INSERT INTO suzBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मिनु मोसामी “गो सहर रे लशा, इन पर्बम आं गुइ पोक्‍शा, परमप्रभु यावे कली पुंइनुङ। नोले बुंबु पचा नु मुप्‍स यिचा नाइक्‍ब। मिनु गे रागी नेल्‍ल परमप्रभु यावे केन बाक्‍ब, दे तुइक्‍नीनी। प्रस्‍थान ७:५ ");
INSERT INTO suzBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तन्‍न गे नु इन दरवार ङा गेय पाइबपुकी मुल सम्‍म परमप्रभु, परमप्रभु यावे कली महिंशो बाक्‍नीनी, दे तुइक्‍ताक्‍ङ” दे फाराओ कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","मेको मुप्‍सीमी मार पाप्‍तु देंशा हना, सनपाट नु क्‍योव़ज नेल्‍ल खतम सेल्‍तु। मारदे हना क्‍योव़ज बाला दुम्‍ने थुम्‍शो नु सनपाट बोइक्‍ने थुम्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","तन्‍न चेरब नु अर्को अन्‍न चहिं नोले ला मीबाक्‍तेक्‍म। मोपतीके मसद। ");
INSERT INTO suzBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मोदेंशो दुम्‍शा मोसामी फाराओ आ बाक्‍तीके रे लशा, आ गुइ परमप्रभु यावे गे पोक्‍शा, फाराओ आ पर्बम पुंइतु। मिनु बुंबु पा, मुप्‍स नु रेउ यिचा नाइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","मिनु फाराओ नु आ गेय पाइबपुकीमी रेउ, मुप्‍स यिचा नु बुंबु पचा नाइश्‍शो तशा, लेंशा पाप पाम्‍तेक्‍म। मोपा मटीम। ");
INSERT INTO suzBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फाराओ काइ मटीब दुम्‍शा, इस्राएली आन कली लचा मगेव। परमप्रभु यावेमी मोसा कली देंशो खोदेंशो दुम्‍‍त। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","मिनु परमप्रभु यावेमी मोसा कली “गे फाराओ कली आं चिन्‍डपुकी कोंइचा कली ग्रुम्‍थ लसे। मारदे हना गो मेको नु आ गेय पाइब आन कली काइ मटीब दुम्‍पाइक्‍ता। ");
INSERT INTO suzBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","मिनु गे इ चच युइ आन कली ‘गो इजीप्‍त ङा मुर आन कली मार मार पङा’ मेको शेंदो। गो मोदेंशो चिन्‍ड कोंइब बाक्‍नुङ। ‘गो परमप्रभु यावे नङ’ दे नेल्‍लेमी तुइक्‍तमेक्‍ल” दें‍त। प्रस्‍थान ६:२-८ ");
INSERT INTO suzBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मिनु मोसा नु हारून फाराओ आ बाक्‍तीके जाक्‍दीश्‍शा, मेको कली “हिब्रू आंइ परमप्रभु यावे, हिब्रू मुर आन परमप्रभुमी इन कली ‘गेना सम्‍म गे आं ङोंइती ठेयब लेश्‍शा बाक्‍नेवे? आं मुर आन कली आं कली चढ़ेथ लचा गेवो। प्रस्‍थान ५:३ ");
INSERT INTO suzBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","नेनो, गे आं मुर आन कली लचा मगेनेवे हना, दीसा इ रागीम शुश सल्‍हा माले जाक्‍पाइक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","मेकोपुकीमी रागी मतचा ङा पा सुम्‍नीम। मिनु मुप्‍स रे पा गिग खाइ मार मार लीशो बाक्‍मा, मेको नेल्‍ल नेक्‍नीम। रवा आन सफा यो नेल्‍ल नेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","मिनु मेकोपुकी इ खिं, इ दरवार ङा गेय पाइब आन खिं नु नेल्‍ल इजीप्‍त ङा मुर आन खिं खिंम ओव़शा ब्रीनीम। इ किकी पिपीम मोदेंशो गेनायो मतामे’ दे परमप्रभुमी इन कली देंत” दे मोसामी दें‍त। मिनु मोसा फो ग्रूशा गाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","मिनु फाराओ आ दरवार ङा गेय पाइबपुकीमी फाराओ कली “मेको मुरुम आंइ कली गेना सम्‍म श्‍येत गेबा? मेको मुर आन कली परमप्रभु यावे, आन परमप्रभु कली चढ़ेचा गेने। इजीप्‍त रागी मुल थुम्‍साक्‍व, दे मतुइक्‍नीनी?” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मिनु मेकोपुकीमी मोसा नु हारून आस कली फाराओ आ बाक्‍तीके लेश्‍शा चाक्‍तेक्‍म। मिनु फाराओमी मेको आस कली “गे लने। परमप्रभु यावे, इन परमप्रभु कली गेय पने। सु सु लाइक्‍नीनी?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मिनु मोसामी “परमप्रभु यावे आ चाड मानेचा कली गो तमी तौ, खाल्‍पी खाल्‍पा, बी ब्‍यफ नु क्‍यारश भेडा नेल्‍ल लाइश्‍शा, लचा माल्‍नीकी” दें‍त। प्रस्‍थान ५:१ ");
INSERT INTO suzBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","मिनु फाराओमी मेको आस कली “इन परमप्रभु यावे गे नु बाक्‍शो खोदेंशो पा गो इन कली नु इन आल नु लचा मगेनुङ। गे मरिम्‍शो पचा माल्‍नीनी, दे आंमा तुइक्‍नीसी। ");
INSERT INTO suzBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","मोदेंशो मदुम्‍ब। वोंइश मुरपुकी ला परमप्रभु यावे कली चढ़ेथ लने। मारदे हना एकोन इन माल्‍शो बाक्‍ब” दे हुइक्‍ताक्‍व। मिनु फाराओ आ ङोंइती रे खेरतु। ");
INSERT INTO suzBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","मिनु परमप्रभु यावेमी मोसा कली “सल्‍हा माले ग्रूपाइक्‍चा कली इ गुइ इजीप्‍त रागी तार दिंदो। मेकोपुकीम रागीमी मार मार गिग खाइपुकी मुप्‍सीम हेंशो बाक्‍मा, मेको ब्‍वाइनीमी” दें‍त। प्रस्‍थान ९:३२ ");
INSERT INTO suzBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मिनु मोसामी आ कोक्‍के इजीप्‍त रागी तार दिंताक्‍व। मेको नाक्‍त रे आ दीसा सुनी सम्‍म परमप्रभु यावेमी पूर्ब रे फश पपाइक्‍तु। मिनु सुनी नां सोव़मेनु, पूर्ब रे पिशो फशेमी सल्‍हापुकी चाक्‍तु। योएल १:२-१२; योएल २:१-११ ");
INSERT INTO suzBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","मिनु सल्‍हा मालेमी इजीप्‍त रागी नेल्‍ल सुम्‍तेक्‍म। ङोंइती रे मोदेंशो शुश सल्‍हा माले गेनायो मबाक्‍शो बाक्‍मा बाक्‍त। मिनु नोले यो मोदेंशो गेनायो मदुम्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","मेको शुश सल्‍हा माले बेरमानु, नाक्‍ती यो नाक्‍दो खोदेंशो पा छिङछिङ दुम्‍त। मेको सल्‍हा मालेमी मुप्‍स रे लीशो रू ङा वाशो नु रवा ङा फल नेल्‍ल नेक्‍तेक्‍म। मार मार गिग बाक्‍मा, मारेइ महेंदेम। इजीप्‍त रागी ङा रवा नु गिग खाइ नेल्‍ल नेक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","मिनु फाराओमी रीब पा मोसा नु हारून आस कली ब्रेप्‍पाइक्‍तु। मिनु मेकोमी “गो परमप्रभु यावे, इन परमप्रभु आ ङोंइती पाप पाता। मिनु इस कली यो मरिम्‍शो पाता। प्रस्‍थान ९:२७ ");
INSERT INTO suzBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","मुल खेयप का ला आं कली माफ गेयीसी, दे पुंइनुङ। मिनु आं पर्बम परमप्रभु यावे, इन परमप्रभु कली पुनीस। सल्‍हा माले खेरशा, अन्‍काल रे मबेक्‍पाइक्‍चा नम, दे पुनीस” दे मोसा नु हारून आस कली माइक्‍तीम्‍सी। प्रस्‍थान ८:४ ");
INSERT INTO suzBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मो देंम नोले मोसा फाराओ आ ङोंइती रे लशा, परमप्रभु यावे कली पुंइतु। ");
INSERT INTO suzBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","मिनु परमप्रभु यावेमी नां पेरतीक रागी रे ठेयब फश गिवार सोइक्‍ताक्‍व। मेको फश गिवारमी सल्‍हा माले आन कली हुरशा, लल समुन्‍द्रम ताइक्‍ताक्‍व। मिनु मोपा इजीप्‍त रागीम सल्‍हा माले काइ मलीम। ");
INSERT INTO suzBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तन्‍न परमप्रभु यावेमी फाराओ कली मबिप्‍पाइक्‍चा कली काइ मटीब दुम्‍पाइक्‍तु। मोपतीके मेकोमी इस्राएली आन कली लचा मगेव। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","मिनु परमप्रभु यावेमी मोसा कली “इ गुइ सरीङ गे पोक्‍को। मो पवीनु, इजीप्‍त रागीम हिंचा ङा पा छिङछिङ दुम्‍ब” दे माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","मिनु मोसामी आ गुइ सरीङ गे पोक्‍तु। मिनु इजीप्‍त रागीमी नाक्‍त सां सम्‍म शुश छिङछिङ दुम्‍त। मारेइ मतांइस। ");
INSERT INTO suzBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","मिनु मेकोपुकी मतमुथु, आन बाक्‍तीक रे बोक्‍ने मचबेम। तन्‍न इस्राएली आन बाक्‍तीकेमी चहिं छेङछेङ बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","मिनु फाराओमी मोसा कली ब्रेश्‍शा “लने, परमप्रभु यावे कली गेय पने। इन आल नु मीश आन कली यो लाइक्‍ने चाप्‍नीनी। इन बी ब्‍यफ नु क्‍यारश भेडा चहिं मेकेरेन बाक्‍मल” दें‍त। प्रस्‍थान १०:१० ");
INSERT INTO suzBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मोसामी चहिं “आंइ चढ़ेतीक नु चोशा चढ़ेतीक बस्‍तु भाव नेल्‍ल लाइक्‍चा माल्‍नीकी। मेको ला परमप्रभु यावे, आंइ परमप्रभु कली चढ़ेने चाप्‍नीकी। ");
INSERT INTO suzBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","गोपुकी आंइ बी ब्‍यफ, क्‍यारश भेडा नेल्‍ल लाइश्‍शा, लचा माल्‍नीकी। का यो मप्रोंइथु लाइक्‍चा माल्‍नीकी। परमप्रभु यावे, आंइ परमप्रभु कली मार चढ़ेचा माल्‍नीकी मुल मजाक्‍दीश्‍शो सम्‍म मतुइक्‍नीकी” दे फाराओ कली माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","परमप्रभु यावेमी चहिं फाराओ कली काइ मटीब दुम्‍पाइक्‍तु। मोपतीके फाराओमी इस्राएली आन कली लचा मगेव। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","मिनु फाराओमी मोसा कली “मुल एकेर रे लावो। आं कली ग्रुम्‍थ मपिवो। गे लेंशा आं कली ग्रुम्‍थ पिते हना, गो इ कली साइक्‍नन” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मिनु मोसामी “दुम्‍ब, गो इन कली लेंशा ग्रुम्‍थ मपीनुङ” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","मिनु परमप्रभु यावेमी मोसा कली “फाराओ नु इजीप्‍त रागी ङा मुर आन कली नेल्‍ल क्‍येङा नोले ङा बेक्‍चा ङा श्‍येत का गेनुङ। मिनु इन कली लचा गेब। लचा गेवानु, नेल्‍ल इन कली ब्रा ब्रु खेरब। ");
INSERT INTO suzBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","गे मुल इ मुर आन कली ‘वोंइश मुर नु मीश मुरपुकीमी आन नेक्‍था बाक्‍ब इजीप्‍ती आन के सुन नु चांदी के पांइतीक शोंप पुंइचा माल्‍नीम’ दे शेंचा माल्‍नेवे” दें‍त। प्रस्‍थान ३:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","मिनु परमप्रभु यावेमी इजीप्‍त ङा मुर आन कली इस्राएली आन कली दाक्‍ब सेल्‍तु। मिनु मोसा फाराओ आ गेय पाइब नु इजीप्‍त ङा मुर नेल्‍ल आन ङोंइती शुश ठेयब मुर दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मिनु मोसामी फाराओ नु आ मुर आन कली “परमप्रभु यावे आ देंशो लोव़ मार बाक्‍त देंशा हना नाक्‍दो उइक्‍थ दुम्‍मेनु, इजीप्‍ती आन दातेम लाइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","इजीप्‍त रागीमी सु सु ङोंइती जरमेशो बाक्‍मा, मेको बेक्‍चा माल्‍नीम। फाराओ आ नोले सासन पाइब ङोंइती जरमेशो तौ रे नेल्‍ल क्‍येङा आइक्‍च यात हिल्‍ब मीश मुर आन ङोंइती जरमेशो तौ सम्‍म नेल्‍ल बेक्‍चा माल्‍नीम। बस्‍तु भाव आन के यो ङोंइती जरमेशो बेक्‍चा माल्‍नीम। प्रस्‍थान ४:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिनु इजीप्‍त रागी नेल्‍लेमी ठेयब रोंका पा ङाक्‍नीम। ङोंइती मोदेंशो गेनायो मदुम्‍शो बाक्‍त। मिनु नोले यो लेंशा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","इस्राएली आन दातेमी चहिं मुर नु बस्‍तु भाव आन चां का यो महेम्‍ब। परमप्रभु यावेमी इजीप्‍त ङा मुर आन कली नु इस्राएल ङा मुर आन कली खाल का ङा मपाइब, दे तुइक्‍तमेक्‍ल। प्रस्‍थान ९:४ ");
INSERT INTO suzBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","मिनु नोले इन गेय पाइब नेल्‍लेमी आं ङोंइती खुम्‍की पा बाप्‍शा, आं कली ‘गे नु इन नोले खोइक्‍ब मुरपुकी एक रे लने’ देंनीम। मिनु गो लाइनुङ” दे मोसामी फाराओ कली देंत। मिनु मोसा फाराओ आ बाक्‍तीके रे शुश गाइश्‍शा चुरशा गाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","मिनु परमप्रभु यावेमी मोसा कली “इजीप्‍त रागीम आं छक लाक्‍चा ङा शुश चिन्‍ड दुम्‍ल, दे फाराओम इ कली मटिपदु” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोसा नु हारूनमी फाराओ आ ङोंइती मेको छक लाक्‍चा ङा चिन्‍ड मार मार नेल्‍ल पाम्‍ताक्‍स। इस्राएल ङा मुर आन कली लचा मगेवल, दे परमप्रभु यावेमी फाराओ कली काइ मटीब दुम्‍पाइक्‍तु। प्रस्‍थान ४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मिनु मोसा नु हारून इजीप्‍त रागीम बाक्‍सानु, परमप्रभु यावेमी मेको आस कली ");
INSERT INTO suzBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“मुल जाक्‍शो महिना बर्स ङा ङोंइती ङा महिना दुम्‍चा माल्‍ब। प्रस्‍थान १३:४ ");
INSERT INTO suzBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","मिनु गे इस्राएली नेल्‍ल आन कली ‘मेको महिना ङा १० नाक्‍ती खिं का ङा ठेयब मुरुमी पाठा का चाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","खिं का कली पाठा का आ श्‍ये शुश दुम्‍त हना, आ नेक्‍था बाक्‍शो मुर आन कली हिक्‍शा, दोशो ब्‍वाइनीमी योक्‍शा, ब्‍वचा कली ब्रेत्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","मेको पाठा मारेइ मदुम्‍शो थम रिम्‍शो नु बर्स का ङा बोका बाक्‍चा माल्‍ब। भेडा के हना यो, क्‍यारश के हना यो दुम्‍ब। लेवी २२:२० ");
INSERT INTO suzBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","मिनु मेको महिना ङा १४ नाक्‍ती सम्‍म मेको बोका कली ठीक पा वोइक्‍चा माल्‍नीनी। मिनु नां रिक्‍चावानु, इस्राएली नेल्‍लेमी मेको बोका क्‍योरचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तेको खिंमी ब्‍वाइनीनी, मेको खिं ङा मुरुमी बोका आ हुश इच्‍का लाइश्‍शा, आ खिं ङा थाम निक्‍शी नु लाप्‍चो आ पियाम ख्रेक्‍चा माल्‍नीनी। प्रस्‍थान १३:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","मेको नाक्‍दो मेको बोका आ श्‍ये ब्‍वचा माल्‍नीनी। दोपा ब्‍वचा माल्‍नीनी देंशा हना, मीम चोशा, बोरब ओख्‍ती मसुप्‍शो शोब्‍ले, कशो खाइ नु ब्‍वचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","मेको श्‍ये क्‍येख ब्‍वचा मदुम्‍ब, लोप्‍शा ब्‍वचा यो मदुम्‍ब। आ पिया, खोइली क्‍यी नेल्‍ल मी तारी चोचा माल्‍नीनी। ब्‍यवस्‍था १६:७ ");
INSERT INTO suzBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","सुनी सम्‍म मारेइ हेंत हना, मीम चोशा थुम्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","मेको श्‍ये किप्‍शुर किप्‍शा, जुत्ता लिक्‍शा, गुइमी कोक्‍के ग्‍याइश्‍शा, रीब पा ब्‍वचा माल्‍नीनी। मारदे हना मेको परमप्रभु यावे आ पास्‍सा चाड बाक्‍ब। ब्‍यवस्‍था १६:३; यसैया ५२:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","मेको नाक्‍दो गोमी इजीप्‍त रागी हिरशा, इजीप्‍त ङा मुर आन ङोंइती जरमेशो तौ नेल्‍ल साइक्‍नुङमी। बस्‍तु भाव आन के यो ङोंइती जरमेशो नेल्‍ल साइक्‍नुङमी। इजीप्‍त ङा देवी देवता नेल्‍ल आन कली सजाइ गेनुङमी। गो, परमप्रभु यावे मेकोन पाइनुङ। गन्‍ती ३३:४ ");
INSERT INTO suzBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","मेको ख्रेक्‍शो हुश इन खिं ङा चिन्‍ड दुम्‍ब। तेको खिंम हुश ख्रेक्‍शो तङा, मेको खिं कली हेरशा लाक्‍नुङ। गो इजीप्‍त रागी ङा मुर आन कली बेक्‍चा ङा श्‍येत गेनुङमी। इन कली चहिं मेको श्‍येत मगेनुङ। हिब्रू ११:२८; प्रस्‍थान ३०:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","मेको नाक्‍ती इन कली मिम्‍तीक नाक्‍ती दुम्‍चा माल्‍ब। मोपतीके आं नेंम भोज जचा माल्‍नीनी। गे बर्स बर्सम मेको चाड परमप्रभु यावे कली मानेचा माल्‍नीनी। इन पाला नेल्‍ल आन कली गेना हना यो अरेशो लोव़ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","गे ७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। ७ नाक्‍त ङा ङोंइती नाक्‍ती गे इन खिंम बाक्‍शो बोरब ओख्‍ती ताइक्‍चा माल्‍नीनी। सुम मेको ७ नाक्‍तीम बोरब ओख्‍ती सुप्‍शो शोब्‍ले जाइबा, मेको इस्राएली आन दाते रे तिल्‍चा पुंइसीब। प्रस्‍थान १३:७; प्रस्‍थान २३:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","मिनु ७ नाक्‍त ङा ङोंइती नाक्‍ती नु नोले ङा नाक्‍ती परमप्रभु आ नेंमी ग्रुम्‍चा माल्‍नीनी। मिनु जचा थोव़क सेल्‍चा क्‍येङा लाक्‍शा, अरु गेय काइ मपने। ");
INSERT INTO suzBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ङा चाड मानेचा माल्‍नीनी। मारदे हना मेको नाक्‍ती गो इन हुल आन कली इजीप्‍त रागी रे ग्रुंइताक्‍ङ। मोपतीके इन पाला मुर नेल्‍ल आन कली गेना हना यो अरेशो लोव़ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ङोंइती ङा महिना ङा १४ नाक्‍ती ङा नाक्‍दो रे २१ नाक्‍त ङा नाक्‍दो सम्‍म गे बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ला जचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","मेको ७ नाक्‍ती इन खिंमी बोरब ओख्‍ती काइ मवोइक्‍चा। सुमी बोरब ओख्‍ती सुप्‍शो शोब्‍ले जाइबा, मेको अर्को रागी ङा मुर बाक्‍त हना यो, इस्राएली बाक्‍त हना यो इस्राएली आन दाते रे तिल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","इन बाक्‍तीक नेल्‍लेमी बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ला जने, बोरब ओख्‍ती सुप्‍शो शोब्‍ले मजने’ दे माइक्‍मी” दे परमप्रभुमी दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","मिनु नोले मोसामी इस्राएल ङा खाल्‍पा नेल्‍ल आन कली ब्रेश्‍शा “इन खिं ङा ठेयब मुर आन कली पाठा का का चाक्‍कीन। मिनु मेको पाठा पास्‍सा चाड मानेचा कली क्‍योरीन। ");
INSERT INTO suzBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","मिनु गे हिस्सोप के ब्राक्‍स लाइश्‍शा, हुश दाइक्‍तीक बोसुम ख्रुम्‍शा, लाप्‍चो आ पिया नु थाम निक्‍शी कली ख्रेक्‍तीन। मेको नाक्‍दो सुनी सम्‍म सुइ लाङगा मग्रूङीने। प्रस्‍थान १२:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","परमप्रभु यावे इजीप्‍त ङा मुर साइक्‍चा कली हिरब। परमप्रभु यावेमी लाप्‍चो आ पिया नु थाममी हुश ख्रेक्‍शो तशा, इं खिं हेरशा लाक्‍ब। मिनु साइक्‍ब कली इं खिंम ओव़चा मगेब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","मुल रे इन तौ, चच युइ नेल्‍लेमी एको पास्‍सा चाड बर्स बर्सम मानेचा माल्‍नीम। मेको गेना हना यो लीशो अरेशो लोव़ बाल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","मिनु गे परमप्रभु यावेमी देंशो खोदेंशो पा इन कली गेशो रागी जाक्‍दीश्शा, यो एको चाड मानेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","इन आलपुकीम इन कली ‘एको चाड आ अर्थ मार बाक्‍मे?’ दे हिल्‍लो पाम्‍तेक्‍म हना, ");
INSERT INTO suzBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","गे मेको आन कली ‘इस्राएल ङा मुरपुकी इजीप्‍त रागीम बाक्‍मानु, परमप्रभु यावेमी इजीप्‍त ङा मुर आन कली साइक्‍ची ना इस्राएली आन खिं चहिं हेरशा लत। एको हेरतीक आ पर्बम चढ़ेशो बाक्‍ब’ देंचा माल्‍नीनी” दे मोसामी देंत। मिनु मुरपुकीमी खुम्‍की पा बाप्‍शा, परमप्रभु यावे कली ठेयब सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","मिनु इस्राएलीपुकीमी लशा, परमप्रभु यावेमी मोसा नु हारून आस कली दोदेंशो देंमे, मोदेंशो पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मिनु नाक्‍दो उइक्‍थ दुम्‍मेनु, परमप्रभु यावेमी इजीप्‍त रागी ङा मुर आन ङोंइती जरमेशो तौ आन कली साइक्‍तीमी। फाराओ आ नोले सासन पाइब तौ रे जेल्‍खानम बाक्‍ब मुर आन ङोंइती जरमेशो तौ नेल्‍ल आन कली साइक्‍तीमी। बस्‍तु भाव आन ङोंइती जरमेशो यो साइक्‍तु। प्रस्‍थान ४:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","मिनु मेको नाक्‍दो फाराओ, आ गेय पाइबपुकी नु इजीप्‍त रागी ङा मुर नेल्‍ल बोक्‍तेक्‍म। इजीप्‍त रागीमी ठेयब रोंका पा ङाक्‍तेक्‍म। मारदे हना खिं खिं नेल्‍लेमी मुर बेक्‍तेक्‍म। प्रस्‍थान ११:६-७ ");
INSERT INTO suzBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","मिनु मेको नाक्‍दो फाराओमी मोसा नु हारून आस कली ब्रेश्‍शा “छुल छाल बोक्‍कीस। गे नु इस्राएल ङा मुर नेल्‍ल आं रागी ङा मुर आन दाते रे ग्रूङीन। इस देंशो खोदेंशो पा परमप्रभु यावे कली चढ़ेथ लने। ");
INSERT INTO suzBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","इन बी ब्‍यफ नु क्‍यारश भेडा आन कली लाइश्‍शा, फो फु ग्रूङीने। आं कली आसीक गेयीसी” दें‍त। प्रस्‍थान १०:२६; एज्रा ६:१० ");
INSERT INTO suzBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिनु इजीप्‍त ङा मुरपुकीमी मेको आन कली आन रागी रे ब्रा ब्रु खेरशा सोइक्‍ताक्‍म। मारदे हना “गो नेल्‍ल बेक्‍नय” दे हिंतेक्‍म। प्रस्‍थान ६:१ ");
INSERT INTO suzBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","मिनु मुरपुकीमी बोरब ओख्‍ती मसुप्‍शो, निशो फस आन बोस वाम गिल्‍शा, बलाम लाप्‍शा कुरतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","मिनु इस्राएलीपुकीम मोसा आ देंशो खोदेंशो पा इजीप्‍ती आन सुन चांदी नु वासी पुंइतेक्‍म। प्रस्‍थान ११:२ ");
INSERT INTO suzBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","मिनु परमप्रभु यावेमी इजीप्‍त ङा मुर आन कली इस्राएली आन कली दाक्‍पाइक्‍तीके, आन पुंइशो नेल्‍ल गेम्‍तेक्‍म। मोपा इजीप्‍त ङा मुर आन शोंप लाइश्‍शा गाक्‍तेक्‍म। प्रस्‍थान ३:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","मिनु इस्राएल ङा मुरपुकी रामे‍सेस सहर रे गाक्‍शा, सुक्‍कोथ सहर जाक्‍दीत्‍तेक्‍म। मेको आन मीश नु तमी तौ नेल्‍ल महिक्‍थु, वोंइश मुर ला ६ लाख बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","मिनु हिक्‍ने मचाप्‍चा ङा पा इस्राएली खोदेंशो पा परमप्रभु यावे कली टीबपुकी यो, आन बी ब्‍यफ, क्‍यारश भेडा, शुश बस्‍तु भाव खुल्‍शा गाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","मिनु इजीप्‍त रे कुरशो बोरब ओख्‍ती मसुप्‍शो निशो फस रे शोब्‍ले चोम्‍तेक्‍म। मारदे हना इजीप्‍त रागी रे खेरचा पुंइसीतीके मेकेर लाम्‍जी सेल्‍ने मचाप्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएलीपुकी ४ सहे ३० बर्स इजीप्‍त रागीमी बाक्‍शो बाक्‍मा बाक्‍त। उत्‍पत्ती १५:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","मिनु ४ सहे ३० बर्स गाम नाक्‍ती, परमप्रभु यावे आ योव़शो इस्राएली नेल्‍ल इजीप्‍त रागी रे गाक्‍मा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","मेको नाक्‍दो इस्राएलीपुकीमी परमप्रभु यावे आ ङोंइती शुश मिम्‍तीक नाक्‍दो दुम्‍माक्‍त। मारदे हना मेको आन कली इजीप्‍त रागी रे ग्रुंइदा बाक्‍त। मेको परमप्रभु यावे आ नाक्‍दो बाक्‍ब। इस्राएल ङा मुर आन पाला नेल्‍लेमी मेको मिम्‍तीक नाक्‍दो बाक्‍ब। यसैया ३०:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली “पास्‍सा दोपा पचा आं अरेशो लोव़ मार बाक्‍त देंशा हना, अर्को रागी ङा मुरुम मेको जचा ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ख्रोइक्‍तीक चिनु ख्रोइश्‍शो इन वाइलपुकीम चहिं जचा ब्‍वचा दुम्‍नीम। उत्‍पत्ती १७:१२-१३ ");
INSERT INTO suzBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","तन्‍न अर्को रागी ङा मुर इन दातेमी बाक्‍त हना यो, गेय पाइब हना यो जचा ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","मेको पास्‍सा ङा पाठा आन खिंमी ब्‍वचा माल्‍नीम। आ श्‍ये लाङगा ग्रुंइचा मदुम्‍ब। आ रुश का यो जिक्‍चा मदुम्‍ब। यूहन्‍ना १९:३६ ");
INSERT INTO suzBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएली नेल्‍लेमी मोदेंशो पचा माल्‍नीम। प्रस्‍थान ");
INSERT INTO suzBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","इन दातेमी अर्को रागी ङा मुर काम परमप्रभु यावे कली पास्‍सा चाड मानेचा दाक्‍ताक्‍व हना, आ खिं ङा गेय पाइब वोंइश मुर नु आ तौ आन कली ख्रोइक्‍तीक चिनु ख्रोइश्‍शा ला, इस्राएली आन नेक्‍था जाक्‍शा, पास्‍सा चाड मानेने चाप्‍ब। मोपा ला इन खोदेंशो दुम्‍ब। मारदे हना ख्रोइक्‍तीक चिनु मख्रोइश्‍शो मुरुम जने ब्‍वने मचाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","मेको इन कली नु इन दातेम बाक्‍ब अर्को रागी ङा मुर आन कली अरेशो लोव़ का बाक्‍ब” दे परमप्रभुमी देंत। लेवी १९:३४; लेवी २४:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली दोदेंशो देंमे, मोदेंशो इस्राएली नेल्‍लेमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","मिनु मेको नाक्‍ती परमप्रभु यावेमी इस्राएली थर आन कली हुल हुल पा इजीप्‍त रागी रे ग्रुंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्राएलीपुकी, इन ङोंइती जरमेशो तौ नु इन बी ब्‍यफ, क्‍यारश भेडा आन ङोंइती जरमेशो बोहोर बोका योव़शा गेयीनी। मारदे हना मेको आं के बाक्‍नीम, दे मुर आन कली देंचा माल्‍ब” देंत। प्रस्‍थान १३:१२,१३; प्रस्‍थान २२:२८ ");
INSERT INTO suzBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मिनु मोसामी मुर आन कली “गेपुकी इजीप्‍त रागीम वाइलीम वाइल दुम्‍शा, ब्रोंइशा, एक जाक्‍शो नाक्‍त मप्रेंदीन। परमप्रभु यावेमी इन कली आ सक्तिमी ग्रुंइताक्‍व। मोपतीके मेको नाक्‍त गे बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ला जचा माल्‍नीनी। प्रस्‍थान १२:३३-३४ ");
INSERT INTO suzBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","गे मुलाक्‍ती आबीब महिनामी ग्रूतीनी। प्रस्‍थान १२:२ ");
INSERT INTO suzBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","मिनु परमप्रभु यावेमी इन किकी पिपी आन कली ‘कनानी, हित्ती, एमोरी, हिव्‍वी नु यबुसी आन रागी इन कली गेनुङ’ दे कसम जशो बाक्‍माक्‍त। मेको रागीमी जाक्‍दीश्‍शा, आबीब महिनामी पास्‍सा चाड मानेचा माल्‍नीनी। मेको रागीम दूध नु खुदो शुश बाक्‍ब, मारेइ मारेइ यो शुश ग्रेल्‍ब। उत्‍पत्ती १५:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। मेको आ नोले ङा नाक्‍ती परमप्रभु यावे आ नेंमी चाड का मानेचा माल्‍नीनी। प्रस्‍थान १२:१५-१६ ");
INSERT INTO suzBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","मिनु बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ७ नाक्‍त सम्‍म जचा माल्‍नीनी। इन बाक्‍तीके नेल्‍लेमी बोरब ओख्‍ती सुप्‍शो शोब्‍ले काइ वोइक्‍चा मदुम्‍ब। मिनु बोरब ओख्‍ती यो वोइक्‍चा मदुम्‍ब। १कोरिन्‍थी ५:८ ");
INSERT INTO suzBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","मेको नाक्‍ती इन आल आन कली ‘परमप्रभु यावेमी इं कली इजीप्‍त रागी रे ग्रुंइशो कोंइचा, दे ओदेंशो पाइनय’ दे शेंचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","मेको पास्‍सा चाड इन गुइमी नु इन कुप्‍फीम मिम्‍तीके चिन्‍ड खोदेंशो पा बाक्‍चा माल्‍ब। मोपा परमप्रभु यावे आ अरेशो लोव़ गे नु बाक्‍ब। मारदे हना परमप्रभु यावेमी आ ठेयब सक्तिमी इन कली इजीप्‍त रागी रे ग्रुंइताक्‍व। ब्‍यवस्‍था ६:८; ब्‍यवस्‍था ११:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","मोपा गेपुकी बर्स बर्समी मेको चाड ठीक नाक्‍तीम मानेशा आ अरेशो लोव़ पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","मिनु परमप्रभु यावेमी इन कली नु इन किकी पिपी आन कली ‘गो मेको रागी इन कली गेनुङ’ दे कसम जशो, कनानी आन रागीम चोव़दीब। ");
INSERT INTO suzBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","गे इन ङोंइती जरमेशो तौ नु इन बी ब्‍यफ, क्‍यारश भेडा आन ङोंइती जरमेशो परमप्रभु यावे कली गेचा माल्‍नीनी। ङोंइती जरमेशो बोहोर बोका परमप्रभु यावे केन नम। ");
INSERT INTO suzBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","तन्‍न इन गधैनी आ ङोंइती जरमेशो बोहोर प्रोंइचा कली मेको आ पा ङा पाठा का गेचा माल्‍नीनी। पाठा गेचा मदाक्‍ताक्‍नी हना, आ शुर जिक्‍चा माल्‍नीनी। इन ङोंइती जरमेशो तौ आ पा ङा क्‍येट गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","मिनु काबु इन आलपुकीमी ‘गे मारदे ओदेंशो पाइनीनी?’ दे हिल्‍लो पाइनीम। मेना गेपुकीमी ‘परमप्रभु यावेमी इं कली आ ठेयब सक्तिमी इजीप्‍त रागी रे ग्रुंइताक्‍व। वाइलीम वाइल दुम्‍शो रे यो प्रोंइतु’ दे इन आल आन कली शेंचा माल्‍नीनी। प्रस्‍थान १२:२६,२९ ");
INSERT INTO suzBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","‘फाराओम इं कली काइ लचा मगेतीके, परमप्रभु यावेमी इजीप्‍त रागी ङा मुर आन ङोंइती जरमेशो तौ नु बस्‍तु भाव आन दाते ङा ङोंइती जरमेशो नेल्‍ल साइक्‍तु। मोपतीके ङोंइती जरमेशो बोहोर बोका परमप्रभु यावे कली चढ़ेनीकी। तन्‍न ङोंइती जरमेशो तौ आ पा ङा क्‍येट गेशा प्रोंइनीकी। ");
INSERT INTO suzBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","एको पतीके इन गुइमी नु इन कुप्‍फीम मिम्‍तीके चिन्‍ड खोदेंशो पा बाक्‍चा माल्‍ब। मारदे हना परमप्रभु यावेमी इं कली आ ठेयब सक्तिमी इजीप्‍त रागी रे ग्रुंइताक्‍व’ दे इन आल आन कली शेंचा माल्‍नीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","मिनु फाराओमी इस्राएली आन कली लचा गेवानु, परमप्रभुमी इस्राएली आन कली आन नेक्‍था ङा लां पलिस्‍ती आन रागी ङा लां मकोंइद। मारदे हना मुरपुकीमी “लडाइ पचा माल्‍तेक्‍म हना, हिंशा इजीप्‍त रागी लेत्‍नीमी, कों” दे लाइश्‍शो लां कोंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","मोपा परमप्रभुमी इस्राएली आन कली गोरशो रागी रे लल समुन्‍द्र गे ङा लां कोंइताक्‍व। मिनु इस्राएली इजीप्‍त रागी रे गाक्‍मानु, लडाइ पचा कली यो ठीक दुम्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोसामी योसेफ आ रुश यो कुरतु। मारदे हना योसेफमी इस्राएली आन कली “परमप्रभुम इन कली थमा पा एको रागी रे ग्रुंइशा लाइब। मेना आं रुश यो लाइक्‍चा माल्‍नीनी” दे कसम जपाइश्‍शो बाक्‍माक्‍त। उत्‍पत्ती ५०:२५; यहोसु २४:३२ ");
INSERT INTO suzBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","मेकोपुकी सुक्‍कोथ सहर रे लशा, एथाम सहर ङा गोरशो रागी आ नेक्‍थामी बास बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","मिनु परमप्रभु यावेमी मेकोपुकी नाक्‍दो नाक्‍ती गाक्‍ने चाप्‍मेक्‍ल, दे मेको आन कली लां कोंइचा कली नाक्‍ती गोस्‍स के थाम नु नाक्‍दो मी के थाम दुम्‍शा, मेको आन ङोंइङोंइती गाक्‍‍त। प्रस्‍थान ४०:३६-३८; गन्‍ती ९:१५-२३; भजन संग्रह ७८:१४; १कोरिन्‍थी १०:१ ");
INSERT INTO suzBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","नाक्‍ती गोस्‍स के थाम नु नाक्‍दो मी के थाम आन ङोंइङोंइती गाक्‍चा मप्रोन। ");
INSERT INTO suzBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएली आन कली ‘गेपुकी इच्‍का लेत्‍चा माल्‍नीनी। मिग्‍दोल नु लल समुन्‍द्र आस दातेम बाक्‍शो पी-हहीरोथ, बाल-सेफोन आ ङोंइती इन बास बाक्‍तीके सेल्‍चा माल्‍नीनी। मेको लल समुन्‍द्र आ नेक्‍था बाक्‍ब’ देंचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","मिनु फाराओमी ‘गोरशो रागीमी आन लां जाम्‍शा, हेंथे गाक्‍नीम’ देंब। ");
INSERT INTO suzBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","मिनु गो फाराओ आ थुं काइ मटीब दुम्‍पाइक्‍नुङ। मिनु फाराओमी इन कली खेदा पाइब। गो फाराओ नु आ फौज आन कली आं सक्ति कोंइनुङ। मिनु इजीप्‍त रागी ङा मुर नेल्‍लेमी ‘परमप्रभु यावे बाक्‍ब’ दे तुइक्‍नीम” देंत। मिनु मोदेंशो पाम्‍तेक्‍म। प्रस्‍थान ४:२१; इजीकीएल २८:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","मिनु इजीप्‍त रागी ङा मुरपुकीम आन पिप कली “इस्राएली प्रोक्‍ने थुम्‍तेक्‍म। गो मार पया? मारदे गो इस्राएली आन कली गेय प्रोंइपाइश्‍शा, लचा गेया?” दे थुं फाइश्‍शा, लोव़ पमुमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","मिनु पिपमी आ बग्‍गी ठीक पशा, आ लडाइ पाइबपुकी ठीक पवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","मिनु ६ सहे रिम्‍शो पा लडाइ पने चाप्‍ब बग्‍गी नु इजीप्‍त रागी ङा अरु बग्‍गी नु चलेब आन ठेयब मुर आन कली लाइश्‍शा, लमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","मिनु परमप्रभु यावेमी इजीप्‍त रागी ङा फाराओ कली काइ मटीब दुम्‍पाइक्‍तीके इस्राएली आन कली खेदा पामे बाक्‍त। इस्राएली चहिं ठेयब सक्तिमी ग्रूशा गाक्‍तेक्‍म। प्रस्‍थान ३:१९-२० ");
INSERT INTO suzBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","इजीप्‍त ङा फाराओ आ शारापुकी, शारा ङोइक्‍बपुकी, बग्‍गी नु लडाइ पाइब नेल्‍ल लल समुन्‍द्र आ नेक्‍था इस्राएली आन बास बाक्‍तीक पी-हहीरोथ सहर आ नेक्‍था बाल-सेफोन आ ङोंइती जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","मिनु इस्राएलीपुकी फाराओ नु आ लडाइ पाइबम आंम कली खेदा पशो तशा, हिंशा ख्रिंख्रि पाम्‍तेक्‍म। मिनु परमप्रभु यावे कली “वारच पाइय्‍यीकी” दे पुंइतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","मिनु मेकोपुकीम मोसा कली “गे आंइ कली मारदे इजीप्‍त रे ग्रुंइदीकी? इजीप्‍त रागीम मुर थिम्‍तीके मबाक्‍बा ङा? मारदे गोरशो रागीम साइक्‍थ चाक्गी? ");
INSERT INTO suzBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","गोपुकी इजीप्‍त रागीम बाक्‍कानु, इन कली ‘आंइ कली श्‍येत मगेकी। इजीप्‍त ङा मुर आन गेय पचा गेकी, मदेंका ङा? गोरशो रागीम बेक्‍चा क्‍येङा इजीप्‍त रागी ङा मुर आन गेय पक वा’ ” दे मोसा कली ग्रीतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मिनु मोसामी मुर आन कली “महिनीन। मुलाक्‍ती परमप्रभु यावेमी दोपा इन कली इजीप्‍त ङा मुर रे प्रोंइबा, कोव़शा बाक्‍कीन। मुलाक्‍ती तशो इजीप्‍त ङा मुर आन कली गे लेंशा गेनायो मताइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","इन पचा ङा लडाइ परमप्रभु यावेमी पाइब। गे थुं नाइश्‍शा बाक्‍कीन” दे माइक्‍तीमी। ब्‍यवस्‍था १:३०; २इतिहास २०:१५,२९; यसैया ५१:९ ");
INSERT INTO suzBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","परमप्रभु यावेमी मोसा कली “मारदे आं कली ठेयब सेंदा पा पुंइनेवे? इस्राएली आन कली ‘गाक्‍कीन’ दे मतो। ");
INSERT INTO suzBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","इ कोक्‍के लल समुन्‍द्र तार दिंदो। मो पवीनु, समुन्‍द्र ब्राशा, गाक्‍तीक लां दुम्‍ब। इस्राएलीपुकी हिलो मबाक्‍शो लांम गाक्‍ने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मिनु गोमी इजीप्‍त ङा मुर आन कली काइ मटीब दुम्‍पाइक्‍नुङ। मो दुम्‍मेनु, इस्राएली आन नोले खोइश्‍शा, लल समुन्‍द्र ओव़शा, खेदा पाइनीम। मिनु गो फाराओ आ मुरपुकी, आ बग्‍गी नु आ शारा ङोइक्‍ब नु लडाइ पा आं सक्ति कोंइशा ग्रानुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","गो फाराओ, आ बग्‍गी नु आ शारा ङोइक्‍ब आन कली आं सक्ति कोंइनुङ। मिनु इजीप्‍त ङा मुरपुकीमी ‘परमप्रभु यावेमी पाप्‍तु’ दे तुइक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","मिनु इस्राएली आन ङोंइती गाक्‍शो परमप्रभु आ स्‍वर्ग ङा गेय पाइब नोले गे लेश्‍शा लशा, इस्राएली आन नोले खोइक्‍तु। मेको आन ङोंइती गाक्‍शो गोस्‍स के थाम यो लेश्‍शा, आन नोले गाक्‍‍त। उत्‍पत्ती १६:७; प्रस्‍थान १३:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","मेको गोस्‍स इजीप्‍त ङा फौज आन कली छिङछिङ दुम्‍माक्‍त। इस्राएली आन लडाइ पाइब आन कली चहिं छेङछेङ दुम्‍‍त। मोपा मेको नाक्‍दो इजीप्‍त ङा फौज इस्राएली आन नेक्‍था जाक्‍ने मचबेम। भजन संग्रह १०५:३९ ");
INSERT INTO suzBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मिनु मोसामी आ गुइ लल समुन्‍द्र तारी दिंदानु, परमप्रभु यावेमी नाक्‍दो नां दाप्‍तीके रे फश गिवार पपाइश्‍शा, समुन्‍द्र फ्राशा सोव़शो गाक्‍तीक लां सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","मिनु इस्राएलीपुकी समुन्‍द्र ङा सोव़शो लां लाम्‍तेक्‍म। समुन्‍द्र ङा ब्‍वाक्‍कु चहिं आन ग्‍युरा नु पेरा गे गारो खोदेंशो पा बाक्‍त। यहोसु ४:२३; २राजा २:८; यसैया ११:१५-१६; १कोरिन्‍थी १०:१; हिब्रू ११:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","मिनु इजीप्‍त रागी ङा लडाइ पाइब इस्राएली आन कली खेदा पा, मेको आन नोले लल समुन्‍द्र ओव़तेक्‍म। पिप आ शारापुकी, आ बग्‍गीपुकी नु आ शारा ङोइक्‍ब नेल्‍ल ओव़तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","मिनु सुनी कना परमप्रभु यावे गोस्‍स के थाम नु मी के थामम बाक्‍शा, इजीप्‍त ङा लडाइ पाइब आन कली कोव़शा हिंपाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","आन बग्‍गी ङा गुगील पुइश्‍शा गेतीके, गाक्‍ने मचबेम। मिनु इजीप्‍त ङा मुरपुकीमी “इस्राएली रे प्रोक्‍य, परमप्रभु यावेमी मेको आन कली वारच पशा, इजीप्‍त ङा मुरपुकी नु लडाइ पाइब” देंमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","मिनु परमप्रभु यावेमी मोसा कली “इजीप्‍त रागी ङा मुर, आन बग्‍गी नु आन शारा ङोइक्‍ब आन कली ब्‍वाक्‍कुम सुम्‍पाइक्‍चा कली इ गुइ लेंशा समुन्‍द्र तार दिंदो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मिनु मोसामी आ गुइ समुन्‍द्र तार दिंदानु, नां सोव़ची ना समुन्‍द्र ङोंइती ङा खोदेंशो दुम्‍त। मिनु इजीप्‍त ङा लडाइ पाइब लेश्‍शा प्रोक्‍ने मचबेम। मोपा परमप्रभु यावेमी इजीप्‍त ङा लडाइ पाइब आन कली समुन्‍द्रमी ख्रुम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","मिनु ब्‍वाक्‍कु लेंशा ङोंइती ङा खोदेंशो दुम्‍मेनु, इजीप्‍त ङा बग्‍गी, शारा ङोइक्‍बपुकी नु फाराओ आ लडाइ पाइब आन कली सुम्‍शा, समुन्‍द्रमी योल्‍ताक्‍व। सुइ यो मब्रोंइम। ");
INSERT INTO suzBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","तन्‍न इस्राएली चहिं सोव़शो लां लशा, समुन्‍द्र शोक्‍साक्‍म। ब्‍वाक्‍कु गारो खोदेंशो पा, आन ग्‍युरा नु पेरा गे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","मोपा परमप्रभु यावेमी मेको नाक्‍ती इस्राएली आन कली इजीप्‍त रागी ङा लडाइ पाइब रे प्रोंइतीमी। मिनु इस्राएलीपुकीमी इजीप्‍त ङा मुर आन कली दिल दिल थिश्‍शा, समुन्‍द्र आ नेक्‍था बेक्‍शो ताम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","मिनु मुरपुकीमी “परमप्रभु यावेमी इजीप्‍त ङा मुर आन कली साइक्‍तीमी” दे तुइश्‍शा, परमप्रभु यावे क्‍येङा हिंतेक्‍म। मिनु “परमप्रभु यावेमी नेल्‍ल पने चाप्‍ब। मोसा आ गेय पाइब बाक्‍ब” दे थमा सुइक्‍तेक्‍म। प्रस्‍थान १९:९; २इतिहास २०:२० ");
INSERT INTO suzBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","मिनु नोले मोसा नु इस्राएलीपुकीमी परमप्रभु यावे कली कुम्‍सो पाम्‍तेक्‍म। “गो परमप्रभु यावे कली कुम्‍सो पाइनुङ। मारदे हना मेकोमी आ ठेयब सक्ति कोंइशा, ग्रात। शारा नु शारा ङोइक्‍ब आन कली समुन्‍द्रमी ताइक्‍ताक्‍व। प्रकाश १५:३ ");
INSERT INTO suzBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","यावे आं सक्ति बाक्‍ब। आं कली कुम्‍सो पपाइक्‍ब। मारदे हना आं कली आ जोरी सत्रु रे प्रोंइती। मेको आं परमप्रभु बाक्‍ब। मिनु गो मेको कली ठेयब सेल्‍नुङ। परमप्रभु आं आफ आ परमप्रभु बाक्‍ब। मिनु गो मेको कली मान पाइनुङ। भजन संग्रह ११८:१४; यसैया १२:२ ");
INSERT INTO suzBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमप्रभु यावे लडाइ पाइब बाक्‍ब। मेको आ नें परमप्रभु यावे बाक्‍ब। प्रस्‍थान १४:१४; भजन संग्रह ४६:१०; प्रस्‍थान ३:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","मेकोमी इजीप्‍त ङा फाराओ आ बग्‍गीपुकी नु आ लडाइ पाइब आन कली लल समुन्‍द्रमी योल्‍पाइक्‍तु। ठेयब कप्‍तान नेल्‍ल आन कली ब्‍वाक्‍कुम ग्रुम्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","समुन्‍द्र ङा ब्‍वाक्‍कुमी मेको आन कली सुम्‍तु। मेकोपुकी फुल्‍लु खोदेंशो पा आगा ग्रुम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","परमप्रभु यावे, इन सक्ति ठेयब बाक्‍ब। इन सक्तिमी इन जोरी सत्रु आन कली थुम्‍पाइक्‍तीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","इन जोरी सत्रुमी गे नु लडाइ पामेनु, गे इन ठेयब दुम्‍तीकेमी मेको आन कली ग्रातीनी। मिनु गाइश्‍शा मेको आन कली मीम भूस चोशो खोदेंशो पा थुम्‍पाइक्‍तीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","इन नेंमी मुइश्‍शा, समुन्‍द्र ङा ब्‍वाक्‍कु कली ग्‍येत्‍थ गे पोक्‍तीनी। समुन्‍द्र गारो बुदी सोजो पा ग्‍येत्‍थ गे बोक्‍शा, आ पुं चहिं सोव़शो लां दुम्‍त। यसैया ५१:१० ");
INSERT INTO suzBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","आंइ जोरी सत्रुमी ‘मेको आन कली खेदा पा, ब्रो ब्रु थित्‍नय। गो ग्‍येरशा, इं ग्राशो थोव़क योक्‍मुइनय। इं तरवार शोइश्‍शा, नेल्‍ल आन कली साइक्‍नय’ देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","गे चहिं फश पपाइक्‍तीनी। मिनु समुन्‍द्रमी मेको आन कली सुम्‍तीमी। मेकोपुकी फलाम खोदेंशो पा ठेयब समुन्‍द्रम ग्रुम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","परमप्रभु यावे, देवी देवता आन दातेमी इन खोदेंशो ठेयब सुइ मबाक्‍नीम। इन खोदेंशो सक्ति पाइश्‍शो, ठेयब मान ताइब सुइ मबाक्‍नीम। इन ठेयब गेय हिंचा ङा बाक्‍ब। गे छक लाक्‍चा ङा गेय पाइब बाक्‍नीनी। प्रस्‍थान ८:६; प्रस्‍थान १८:११; भजन संग्रह ८६:८ ");
INSERT INTO suzBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","इन ग्‍युरा गुइ दिंनीनु, रागीम मेको आन कली दाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","गे इन ग्रुंइशो मुर आन कली गेना हना यो शिशी पा, लां कोंइताक्‍नी। मेको आन कली इन सक्तिमी इन आंम बाक्‍तीकेम खुल्‍तीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","जात जात ङा मुरपुकी इन लोव़ नेंशा शुश हिंतेक्‍म। पलिस्‍ती रागी ङा मुरपुकी हिंशा, ख्रिंख्रि पाम्‍तेक्‍म। यहोसु २:९-११ ");
INSERT INTO suzBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","मुल एदोम रागी ङा ठेयब मुरपुकी हिंतेक्‍म। मोआब रागी ङा ठेयब मुरपुकी हिंशा ख्रिंख्रि पाम्‍तेक्‍म। कनान रागीम बाक्‍बपुकीम आन सक्ति साम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","परमप्रभु यावे, इजीप्‍त रागी रे इन ग्रुंइशो मुरपुकी मजाक्‍दीम्‍मा सम्‍म मेको आन जोरी सत्रु इन सक्ति ङा गेय तशा, हिंशा फुल्‍लु खोदेंशो पा सिक्‍सी पा बाक्‍तेक्‍म। मोपा हिंशा मेको आन थुं लुक्‍च लत। ");
INSERT INTO suzBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","गे इन मुर आन कली आन रागी ओंइनीनी। मिनु इन आंम बाक्‍तीक डांडाम बाक्‍पाइक्‍नीनी। परमप्रभु यावे, मेको इन बाक्‍तीके आंमा सेल्‍तीनी। इन आंम बाक्‍तीक खिं गे आंमा सेल्‍तीनी। भजन संग्रह ७८:५४ ");
INSERT INTO suzBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमप्रभु यावे गेना हना यो पिप बाक्‍ब” दे कुम्‍सो पाम्‍तेक्‍म। भजन संग्रह ९३:१ ");
INSERT INTO suzBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","फाराओ आ बग्‍गी नु शारा ङोइक्‍बपुकी समुन्‍द्र ङा लां लाम्‍तेक्‍म। परमप्रभु यावेमी समुन्‍द्र ङा ब्‍वाक्‍कु लेंशा लेप्‍पाइश्‍शा, मेको नेल्‍ल आन कली योल्‍पाइक्‍तु। इस्राएली चहिं समुन्‍द्र ङा सोव़शो लां रे पा गाक्‍तेक्‍म। प्रस्‍थान १४:२२-२९ ");
INSERT INTO suzBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","हारून आ समी मिरयाम परमप्रभु आ लोव़ पाइब यो बाक्‍त। मेकोमी खैजडी ताप्‍शा, कुम्‍सो पथ लमेनु, अरु मीश मुरपुकी यो खैजडी ताप्‍शा, सिल पना पन मेको आ नोले खोइक्‍तेक्‍म। भजन संग्रह ६८:२६ ");
INSERT INTO suzBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरयामम मेको आन कली कुम्‍सो पा लोव़ लेश्‍शा “परमप्रभु यावे कली कुम्‍सो पने। मारदे हना मेकोम ठेयब लडाइ पा ग्रात। शारा नु शारा ङोइक्‍ब आन कली समुन्‍द्रम ताइक्‍ताक्‍व” दे कुम्‍सो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मिनु मोसामी इस्राएली आन कली लल समुन्‍द्र रे शुर माइश्‍शो गोरशो रागी कोंइताक्‍व। मिनु मेको गोरशो रागीमी नाक्‍त सां सम्‍म गाक्‍मानु, ब्‍वाक्‍कु मथिदेम। उत्‍पत्ती २०:१ ");
INSERT INTO suzBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","माराह माइश्‍शोमी जाक्‍दीश्‍शा, मेक ङा ब्‍वाक्‍कु तूने मचबेम। मारदे हना मेको ब्‍वाक्‍कु कशो बाक्‍त। मोपतीके मेको कली माराह नें वोइक्‍तेक्‍म। हिब्रू लोव़मी मारा देंशो कशो रुम्‍सीब। ");
INSERT INTO suzBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","मिनु मुरपुकीमी मोसा कली “मुल मार तूचा?” दे गन गन पाम्‍तेक्‍म। प्रस्‍थान १६:२ ");
INSERT INTO suzBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोसामी चहिं परमप्रभु यावे कली पुंइस ङा पुंइस बाक्‍त। मिनु परमप्रभु यावेमी मोसा कली रवा आ शी का कोंइताक्‍व। मिनु मोसामी मेको शी ब्‍वाक्‍कुम ब्‍वारताक्‍व। मिनु मेको ब्‍वाक्‍कु मकशो ब्रोव़शो दुम्‍त। मेकेर इस्राएली आन कली आ फुल्‍लुम मुशा ब्रेक्‍शो नु आन पतीक लोव़ गेशो बाक्‍त। मोपा मेको आन कली नाक्‍ताक्‍व। उत्‍पत्ती २२:१ ");
INSERT INTO suzBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","मिनु मेकोमी “गे परमप्रभु यावे, इन परमप्रभु आं लोव़ नेंशा, आं ङोंइती ठीक पाइतीनी हना, आं शेंशो लोव़ नेंशा, टि‍शा, आं अरेशो लोव़ टीतीनी हना, गो इजीप्‍त रागी ङा मुर आन कली पपाइश्‍शो रोइ इन कली मपपाइक्‍नुङ। मारदे हना गो इन कली सापाइक्‍ब परमप्रभु यावे नङ” देंत। ब्‍यवस्‍था ७:१५; उत्‍पत्ती २०:१७; ब्‍यवस्‍था ३२:३९; भजन संग्रह ३०:३; यसैया ५७:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","मिनु इस्राएली मेकेर रे लशा, एलीममी जाक्‍दीत्‍तेक्‍म। मेकेर १२ ओटा धारा नु ७० ओटा रवा बाक्‍‍तेक्‍म। मेकोपुकी मेको ब्‍वाक्‍कु आ नेक्‍था बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","मिनु इस्राएली नेल्‍ल एलीम रे लशा, सीन माइश्‍शो गोरशो रागी जाक्‍दीत्‍तेक्‍म। सीन माइश्‍शो गोरशो रागी एलीम नु सीनै डांडा आस दातेमी बाक्‍ब। इजीप्‍त रागी रे गाक्‍शा नोले मेकेर आबीब आ नोले ङा महिना ङा १५ नाक्‍तीम जाक्‍दीत्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","मिनु इस्राएली नेल्‍ल मोसा नु हारून आस कली तशा गाइश्‍शा, प्रस्‍थान १७:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“इजीप्‍त रागी उइ परमप्रभु यावेमी आंइ कली सद हना, रिम्‍शो दुम वा। मेकेर श्‍ये नु शोब्‍ले शुश बाक्‍त। गे आंइ कली जचा मगेथु, साइक्‍चा कली एको गोरशो रागीमी चाक्‍तीसी” दे गन गन पाम्‍तेक्‍म। प्रस्‍थान १४:११ ");
INSERT INTO suzBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","मिनु परमप्रभु यावेमी मोसा कली “नेनो, गो इन कली रेउ यिशो खोदेंशो पा सरीङ रे शोब्‍ले यिपाइक्‍नुङ। मिनु मुरपुकीम नाक्‍त किंत किंत गुप्‍चा माल्‍नीम। खेयप का गुप्‍मेनु, नाक्‍त का कली ला गुप्‍चा माल्‍नीमी। आं अरेशो लोव़ पाइबाक्‍मा कों, मपाइबाक्‍मा, गो मेको आन कली नाक्‍नुङ। प्रस्‍थान १६:१५; उत्‍पत्ती २२:१ ");
INSERT INTO suzBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","मुरुमी सुक्रबार आन गुप्‍शो शोब्‍ले नाक्‍त का कली ठीक पाम्‍तेक्‍म हना, नाक्‍त का कली गुप्‍शो यो, नाक्‍त निक्‍शी कली ठीक दुम्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","मिनु मोसा नु हारूनम इस्राएली आन कली “परमप्रभु यावेमी इन कली इजीप्‍त रागी रे प्रोंइता, दे आपो नाक्‍दो लेंशा मिम्‍पाइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","सुनी कना गे परमप्रभु यावे आ छेङछेङ ग्रूशो ताइनीनी। मारदे हना मेकोमी इन परमप्रभु यावे कली गन गन पशो तुइक्‍ताक्‍व। गो निक्‍शी सु नस्‍कु ङा? गे आंस पर्बम गाइक्‍नीनी?” देंताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मिनु मोसामी इस्राएली आन कली “परमप्रभु यावेमी आपो नाक्‍दो इन कली श्‍ये गेब, सुनी कना रूथ्री शोब्‍ले गेब, इन गन गन पशो लोव़ नेंतु, दे तुइक्‍तीन। गो निक्‍शी सु नस्‍कु ङा? इन गन गन पशो आंस कली ममाइ, परमप्रभु यावे नु कका गाइक्‍ताक्‍नी दे तुइक्‍तीन” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मिनु मोसामी हारून कली “गे मुर नेल्‍ल आन कली ‘परमप्रभु यावे आ ङोंइती जाक्‍कीन। मारदे हना मेकोमी इन गन गन पशो नेंतु’ देंचा माल्‍नेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","मिनु हारूनमी इस्राएली नेल्‍ल आन कली लोव़ पवानु, मेकोपुकी गोरशो रागी गे कोव़तेक्‍म। मिनु मेकेर गोस्‍सुमी परमप्रभु यावे आ छेङछेङ ग्रूशो ताम्‍तेक्‍म। गन्‍ती १२:५; गन्‍ती १४:१०; गन्‍ती १६:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“गो इस्राएली आन गन गन पा पशो लोव़ नेंता। गे मेको आन कली ‘आपो नाक्‍दो श्‍ये ब्‍वाइनीनी। मिनु सुनी कना रूथ्री शोब्‍ले जाइनीनी। गो परमप्रभु यावे, इन परमप्रभु नङ, दे गे तुइक्‍नीनी’ दे माइक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","मिनु नाक्‍दो बटटाइ ग्रूमा बाक्‍त। मिनु इस्राएली आन बाक्‍तीक नेल्‍ल सुम्‍मे बाक्‍त। मिनु सुनी कना आन बाक्‍तीकेमी शुश सीत यिशो बाक्‍माक्‍त। गन्‍ती ११:३१ ");
INSERT INTO suzBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","मिनु सुनी कना सीत मजाम्‍म सम्‍म गोरशो रागी ङा खपीम फुरश खोदेंशो पा आइक्‍च गेडा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","इस्राएलीपुकीमी मेको तशा “मार में?” देंमुम्‍तेक्‍म। मारदे हना मार बाक्‍मे, मतुइक्‍तम। मिनु मोसामी मेको आन कली “परमप्रभु यावेमी इन कली गेशो मन्‍ना शोब्‍ले एकोन बाक्‍ब। प्रस्‍थान १६:४; ब्‍यवस्‍था ८:३; यूहन्‍ना ६:३१; १कोरिन्‍थी १०:३ ");
INSERT INTO suzBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमप्रभु यावे आ अरेशो लोव़ मार बाक्‍ब देंशा हना, इन मुर नेल्‍लेमी गिश जने चाप्‍नीमी, मिश गुपीन। इन ताम्‍बुमी गिश जना मुर बाक्‍नीमी, मिश गोमेर गुप्‍चा माल्‍नीनी” दे इस्राएली आन कली देंत। गोमेर का २ लिटर कि ४ माना खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","मोसामी इस्राएली आन कली दोदेंशो देंमे, मोदेंशो पाम्‍तेक्‍म। का निक्‍शीमी शुश, का निक्‍शीमी इच्‍कका ला गुप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","तन्‍न पुक्‍ग‍मेनु, मेको शुश गुप्‍ब नु इच्‍कका ला गुप्‍ब नेल्‍ल आन के उइक्‍थ उइक्‍थ दुम्‍माक्‍त। नेल्‍लेमी गिश जचा दाक्‍तमे, मिश गुप्‍तेक्‍म। २कोरिन्‍थी ८:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मिनु मोसामी मेको आन कली “दीसा सुनी सम्‍म सुइमी मारेइ हेंचा मदुम्‍ब” दे माइक्‍तीमी। प्रस्‍थान १६:४; मत्ती ६:३४; लूका ११:३ ");
INSERT INTO suzBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तन्‍न मेकोपुकीमी मोसा आ देंशो मटीम। मिनु का निक्‍शीमी मेको मन्‍ना सुनी सम्‍म हेंदमे बाक्‍त। मिनु लुस्‍पु जोल्‍शा, शुश रिना पाइक्‍तु। मिनु मोसा शुश गाइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","मिनु गिश माल्‍दमे, सुनी सुनी गुप्‍तेक्‍म। नां चोक्‍तानु, मेको यत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","मिनु सुक्रबार नाक्‍ती मुरपुकीम मुर का कली गोमेर निक्‍‍निक्‍शी मन्‍ना गुप्‍तेक्‍म। इस्राएली आन कली कोव़ब मुरपुकीमी मो पाम्‍तेक्‍म दे मोसा कली देंतेक्‍म। गोमेर का २ लिटर कि ४ माना खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","मिनु मेकोमी “परमप्रभु यावेमी इन कली गे मार पचा माल्‍नीनी, मेको शेंशो बाक्‍ब। मारदे हना दीसा परमप्रभु यावे कली मिम्‍शा नाइक्‍तीक नाक्‍ती बाक्‍ब। मोपतीके मुलाक्‍त माल्‍शो जचा थोव़क क्‍येने चोने। लीशो चहिं दीसा सुनी सम्‍म हेंचा दुम्‍ब” देंत। उत्‍पत्ती २:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","मिनु मोसा आ देंशो खोदेंशो पा आ दीसा सम्‍म हेंताक्‍म। मिनु मेको रिना मपाइक्‍थु, लुस्‍पु यो मजो‍ल। ");
INSERT INTO suzBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मिनु मोसामी “गे मुलाक्‍ती जने। मारदे हना परमप्रभु यावे आ नाइक्‍तीक नाक्‍ती बाक्‍ब। मुलाक्‍ती लाङगाम मारेइ मथिंसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","गे ६ नाक्‍त गुप्‍चा माल्‍नीनी। ६ नाक्‍त आ दीसा ङा नाक्‍त मारेइ मथिंसीब। मारदे हना नाइक्‍तीक नाक्‍त बाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","मिनु सन्‍चरबार नाइक्‍तीक नाक्‍त का निक्‍शी मुर मन्‍ना गुप्‍थ लाङगा ग्रूमानु, मारेइ मथिदेम। ");
INSERT INTO suzBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","मिनु परमप्रभु यावेमी मोसा कली “गेपुकी आं शेंशो नु आं अरेशो गेना सम्‍म मटीनीनी? ");
INSERT INTO suzBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","नोफा दाइश्‍शा नेनीन ‘परमप्रभु यावेमी इन कली सन्‍चरबार नाइक्‍तीक नाक्‍ती गेप्‍तु। मोपतीके सुक्रबार इन कली नाक्‍त निक्‍शी कली जचा थोव़क गेब। मिनु नाइक्‍तीक नाक्‍ती इन बाक्‍तीक बाक्‍तीकेमी बाक्‍कीन। इन खिं रे लाङगा मलने’ दे मुर आन कली देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","मिनु मुरपुकी सन्‍चरबार नाक्‍ती नांइसाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","मिनु इस्राएलीपुकीम मेको गेडा कली मन्‍ना दे नें वोइक्‍तेक्‍म। मेको बुश धन्‍या वांचेर खोदेंशो बाक्‍त। मेको खुदोमी सेल्‍शो शोब्‍ले खोदेंशो पा ब्रोव़माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मिनु मोसामी “परमप्रभु यावे आ अरेशो लोव़ मार बाक्‍त देंशा हना, मेकोमी ‘मेको जचा थोव़क गोमेर का हेंचा माल्‍नीनी। इन कली इजीप्‍त रागी रे प्रोंइशा, चाक्‍गानु, गोरशो रागीमी गेशो जचा थोव़क मेको बाक्‍ब दे शुश पाला ङा मुर आन कली कोंइचा कली हेंदो। गो इन कली इजीप्‍त रे गोरशो रागीमी चाक्‍शा, दोपा थुलु, मेको नेल्‍लेमी तामेक्‍ल’ देंत” देंत। गोमेर का इस्राएली आन अन्‍न पुक्‍तीके का बाक्‍त। मेको २ लिटर रिक्‍ब बाक्‍त। मिनु ओमेर का ४ माना खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","मिनु मोसामी हारून कली “बोस का लतो। मिनु ओमेर का मन्‍ना मेकेर कुर पावो। मेको नेल्‍ल पाला ङा मुरपुकीम तचा ङा पा परमप्रभु यावे आ ङोंइती वोतो” देंत। हिब्रू ९:४ ");
INSERT INTO suzBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","परमप्रभु यावेमी मोसा कली दोपा देंमे, मोपा हारूनमी कबल पशो सन्‍दोस आ ङोंइती वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","मिनु इस्राएलीपुकीमी ४० बर्स सम्‍म मन्‍ना जाम्‍तेक्‍म। मुर बाक्‍तीक कनान रागी ङा सांद मजाक्‍मा सम्‍म मेको जाम्‍तेक्‍म। यहोसु ५:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","गोमेर का एफाह ङा १० भाग बाक्‍ब। एफाह का ठेयब पुक्‍तीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","मिनु इस्राएली नेल्‍ल सीन माइश्‍शो गोरशो रागी रे गाक्‍शा, परमप्रभु यावे आ देंशो बिश्‍शा, रेफीदीम माइश्‍शोमी बाक्‍तेक्‍म। मेकेर चहिं तूचा ब्‍वाक्‍कु मथिदम। गन्‍ती ३३:१२-१४ ");
INSERT INTO suzBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","मोपतीके “मोसामी आंइ कली मरिम्‍शो लां कोंइब” दे गाइश्‍शा, मोसा कली “आंइ कली तूचा ब्‍वाक्‍कु गेकी” दे जिचा पोक्‍तेक्‍म। मिनु मोसामी मेको आन कली “गे आं कली मारदे जिचा तोइनीनी? मारदे परमप्रभु यावे सक्ति पाइश्‍शो बाक्‍ब, दे थमा मसुइक्‍नीनी?” देंत। ब्‍यवस्‍था ६:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","मिनु मुरपुकी ब्‍वाक्‍कु तूतू दाक्‍शा, गाइक्‍ताक्‍म। मेकोपुकीमी मोसा कली “गे मारदे आंइ कली इजीप्‍त रागी प्रोंइपाइय्‍यीकी? आंइ कली, आंइ आल आन कली, आंइ बस्‍तु भाव आन कली तूचा ब्‍वाक्‍कु मबा, आंइ कली बेक्‍पाइक्‍चा कली इजीप्‍त प्रोंइपाइय्‍यीकी?” देंतेक्‍म। प्रस्‍थान १५:२४; प्रस्‍थान १६:२; गन्‍ती १४:-; गन्‍ती १७:६-२८ ");
INSERT INTO suzBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","मो देंमानु, मोसामी परमप्रभु यावे कली “गो एको मुर आन कली मार पाइनुङा? आं कली फुल्‍लु आप्‍शा, साइक्‍चा चिक्‍तायीमी। मुल मार पङ?” देंत। गन्‍ती १४:१० ");
INSERT INTO suzBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","मिनु परमप्रभु यावेमी मोसा कली “इस्राएल ङा खाल्‍पा आन कली लाइश्‍शा, इस्राएली आन ङोंइती गाक्‍को। नील खोला तुप्‍शो कोक्‍के यो लाइश्‍शा लावो। प्रस्‍थान ७:२० ");
INSERT INTO suzBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","गो होरेब माइश्‍शो डांडा आ नेक्‍था सेरथे फुल्‍लु तार इ ङोंइती बाक्‍नुङ। मिनु गे मेको सेरथे फुल्‍लु तुप्‍चा माल्‍नेवे। मिनु, सेरथे फुल्‍लु रे ब्‍वाक्‍कु यीब। मिनु मुरपुकीम तूने चाप्‍नीम” देंत। मिनु इस्राएली आन खाल्‍पा आन ङोंइती मोसाम मो पाप्‍तु। गन्‍ती २०:११; १कोरिन्‍थी १०:४ ");
INSERT INTO suzBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मिनु मोसामी मेको सेरथे फुल्‍लु बाक्‍तीक कली मास्‍साह नु मेरीबा नें वोइक्‍तु। मारदे हना इस्राएलीपुकीमी परमप्रभु यावे कली नाक्‍शा गाइश्‍शा “परमप्रभु यावे आंइ दातेमी बाक्‍ब” दे थमा मसुदम। भजन संग्रह ९५:८-९; मीका ३:११ ");
INSERT INTO suzBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","मिनु अमालेकी रेफीदीमम जाक्‍शा, इस्राएली नु लडाइ पाम्‍तेक्‍म। उत्‍पत्ती ३६:१२-१६ ");
INSERT INTO suzBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मिनु मोसामी यहोसु कली “इं मुरपुकी रे योव़शा, अमालेकी नु लडाइ पथ लावो। गो परमप्रभु आ कोक्‍के शेशा, दीसा मेको डांडा तार राप्‍शा बाक्‍नुङ” देंत। गन्‍ती १३:८,१६ ");
INSERT INTO suzBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मिनु यहोसुमी मोसाम देंशो खोदेंशो पा अमालेकी नु लडाइ पाप्‍तु। मोसा, हारून नु हुर चहिं मेको डांडा ङोंइसाक्‍म। प्रस्‍थान २४:१४ ");
INSERT INTO suzBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","मोसामी आ गुइ पोक्‍गानु, इस्राएलीपुकी ग्रातेक्‍म। आ गुइ तोक्‍गानु, अमालेकीपुकी ग्रातेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","मिनु मोसा आ गुइ योक्‍तीके हारून नु हुरमी फुल्‍लु का थांइशा, मेको तारी निप्‍पाइक्‍ताक्‍स। मिनु मोसा आ गुइ तिक्‍शा, वोइक्‍ताक्‍स। मोदेंशो पा का ग्‍युरा गे, का पेरा गे बाक्‍शा, नां मपेरदा सम्‍म गुइ पोक्‍स ङा पोक्‍स बाक्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","मिनु यहोसु नु आ मुरुमी अमालेक नु आ मुर आन कली ग्राशा, तरवारम साइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","मिनु परमप्रभु यावेमी मोसा कली “एको लडाइ गेना हना यो मिम्‍चा कली किताबम ब्रेक्‍तो। गो अमालेकी आन कली रागी रागी रे क्‍याम्‍नुङमी, दे यहोसु कली मिम्‍पतो” देंत। ब्‍यवस्‍था २५:१७-१९; १सामुएल १५:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मिनु मोसामी चढ़ेतीक का सेल्‍शा “परमप्रभु यावे आं छेदर बाक्‍ब” दे नें वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मिनु मेकोमी “यावे आ नित्‍तीक गे इन गुइ पोक्‍कीन! मारदे हना परमप्रभु यावेमी ‘अमालेकी नेल्‍ल आन पालामी मेकोपुकी नु लडाइ पाइनुङ’ दे ङोंइती देंशो बाक्‍ब” देंत। येरमीया ३:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मिनु मिदयान रागी ङा नाक्‍सो मोसा आ शिउ यित्रोमी परमप्रभुमी मोसा नु इस्राएली आन पर्बम मार मार पवा नु परमप्रभु यावेमी मेको आन कली इजीप्‍त रागी रे दोपा ग्रुंइदा, मेको नेल्‍ल नेना बाक्‍त। प्रस्‍थान ३:१ ");
INSERT INTO suzBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ङोंइती मोसामी आ मीश नु आ तौ निक्‍शी आस कली आ माइत सोइश्‍शो बाक्‍माक्‍त। मुल यित्रोम मेको आन कली मोसा आ बाक्‍तीक चाक्‍ती‍मी। प्रस्‍थान ४:२० ");
INSERT INTO suzBl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","मोसामी आ तौ का आ नें गेरशोम वोइश्‍शो बाक्‍त। मारदे हना मेकोमी “गो मतुइश्‍शो रागी ङा मुर आन दातेमी अर्को रागी ङा मुर दुम्‍ती” देंत। प्रस्‍थान २:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","मिनु अर्को कली एलीएजर नें वोइक्‍तु। मारदे हना मेकोमी “आं आफ आ परमप्रभुमी आं कली फाराओ आ तरवार रे प्रोंइशा, वारच पाइक्‍ती” देंशो बाक्‍त। १इतिहास २३:१५-१७ ");
INSERT INTO suzBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मिनु मोसा आ शिउ यित्रो, मोसा आ मीश नु आ तौ निक्‍शी गोरशो रागीमी मोसा कली ग्रुम्‍थ जाक्‍तेक्‍म। मेना मोसामी आ ताम्‍बु परमप्रभु आ डांडा आ पुंमी कीतु। ");
INSERT INTO suzBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","मिनु यित्रोमी मोसा कली “इ शिउ यित्रो, इ मीश नु इ तौ निक्‍शी इ कली ग्रुम्‍थ जाक्‍तक” दे लोव़ सोइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","मिनु मोसा आ शिउ ग्रुम्‍थ जाक्‍शा, सेउ पशा, पुक्‍पु पशा “दोपा बाक्‍नी” दे ताम्‍बुम ओंइताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मिनु मोसामी परमप्रभु यावेमी इजीप्‍त ङा फाराओ कली नु आ मुर आन कली मार मार पवा, लांमी मार मार श्‍येत जामे, दोपा परमप्रभु यावेमी मेको नेल्‍ल रे प्रोना, मेको नेल्‍ल आ शिउ कली शेंताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","मिनु यित्रोमी परमप्रभु यावेमी इस्राएली आन कली गिश रिम्‍शो पवा नु इजीप्‍त ङा मुर आन गुइ रे दोपा प्रोना मेको नेल्‍ल नेंशा, शुश ग्‍येरसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","मिनु मेकोमी “इन कली इजीप्‍त ङा मुरपुकी नु फाराओ आ गुइ रे प्रोंइब परमप्रभु यावे कली ठेयब सेल्‍य। ");
INSERT INTO suzBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","देवी देवता आन क्‍येङा परमप्रभु यावे ला ठेयब बाक्‍ब, दे गो मुल तुइक्‍ताक्‍ङ। आ मुर आन कली इजीप्‍त ङा मुर आन गुइ रे प्रोंइतु। मारदे हना इजीप्‍तीपुकीमी मेको आन कली ठेयब लेश्‍शा दिप्‍शो बाक्‍तेक्‍म” दें‍त। नेहेम्‍याह ९:१०; येरमीया ५०:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","मिनु मोसा आ शिउमी परमप्रभु कली चोशा चढ़ेतीक नु अरु चढ़ेतीक यो चढ़ेप्‍तु। मिनु हारून नु इस्राएल ङा मुर आन खाल्‍पा नेल्‍ल मोसा आ शिउ नु परमप्रभु कली मान पा ठेयब सेल्‍शा जाम्‍तेक्‍म। उत्‍पत्ती ३१:५४ ");
INSERT INTO suzBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","मिनु मोसा सुनी कना बोक्‍शा, मुर आन कली निसाफ पचा कली निस्‍साक्‍व। मुरपुकी सुनी रे जाक्‍शा, नाक्‍दो सम्‍म मोसा आ ङोंइती बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मिनु मोसा आ शिउ मी मोसा कली मोदेंशो पा मुर आन कली निसाफ पशो तशा “गे मुर आन कली मार पाइनेवे? गे मारदे इ का ला गेय पना पन बाक्‍नेवे? मुरपुकी सुनी रे नाक्‍दो सम्‍म जाक्‍शा, बाक्‍शो बाक्‍नीमी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मिनु मोसामी आ शिउ कली “मुरपुकीमी परमप्रभु आ देंशो तुइक्‍चा दाक्‍नीम, मोपतीके जाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","मेको आन दातेमी मार मार निसाफ पाचा माल्‍शो बाक्‍मे, मेको गो गारपाइक्‍नुङ। मोपा गो निसाफ पचा माल्‍नुङ। मिनु मेको आन कली परमप्रभु आ फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आ अरेशो लोव़ तुइक्‍पाइक्‍नुङ” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मिनु आ शिउमी “इ पशो मरिम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","गे शेम्‍सीनेवे। गे नु बाक्‍ब मुरपुकी यो शेम्‍सीनीम। एको गेय इ मचाप्‍चा ङा बाक्‍ब। गे ला पने मचाप्‍नेवे। गन्‍ती ११:१४; ब्‍यवस्‍था १:९ ");
INSERT INTO suzBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","आं लोव़ नेनो, गो इ कली अर्ती गेनुङ। परमप्रभु गे नु बाक्‍ब। गे मुर आन पर्बम परमप्रभु कली पुंइदो। ");
INSERT INTO suzBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","परमप्रभु आ फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आ अरेशो लोव़ मेको आन कली तुइक्‍पतो। मोपा गे मेको आन गाक्‍तीक लां नु आन पचा माल्‍शो गेय मेको आन कली शेंदो। ");
INSERT INTO suzBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","गे मुर नेल्‍ल आन दाते रे रिम्‍शो गेय पने चाप्‍ब परमप्रभु कली मान पा हिंब, थमा सुइक्‍चा पुंइसीब नु ख्रुइश्‍शा मार मार ताक्‍शा मजाइब मुरपुकी योव़चा माल्‍नेवे। नोले मेको मुर आन कली कोव़ब ठेयब मुर वोतो। मेको आन कली १० जना मुर आन कली कोव़ब, ३० जना मुर आन कली कोव़ब, सहे सहे जना मुर आन कली कोव़ब नु हजार हजार जना मुर आन कली कोव़ब ठेयब मुर आन कली योव़ङो। ");
INSERT INTO suzBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","मेको कोव़ब मुरपुकीमी नाक्‍त किंत किंत ङा निसाफ पामेक्‍ल। ठेयब मुददा चहिं इ ङोंइती चाक्‍गमेक्‍ल। आइक्‍च मुददा आंमा गारपदमेक्‍ल। मो पाप्‍तीवी हना, इ कली रिम्‍शो दुम्‍ब। मिनु मेको कोव़बपुकीमी इ गेय नु श्‍येत योक्‍शा पाइनीम। ");
INSERT INTO suzBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","गे आं देंशो पाप्‍तीवी हना, परमप्रभुमी यो इ कली मोदेंशो पचा गेब। गे मेको गेय फाल्‍ने चाप्‍नेवे। मिनु इ मुर नेल्‍ल दुशा गारशा, आंम आन बाक्‍तीके लाइनीम” दे यित्रोमी मोसा कली अर्ती गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मिनु मोसामी आ शिउ आ अर्ती नेंशा, आ देंशो नेल्‍ल पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मिनु इस्राएली आन दाते रे रिम्‍शो गेय पाइब आन कली योव़शा, मुर आन कली कोव़ब वोइक्‍तु। १०, १०, ३०, ३०, सहे सहे नु हजार हजार जना मुर आन कली कोव़ब वोतो। ");
INSERT INTO suzBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","मेको मुरपुकीमी मुर आन कली निसाफ पची ना, निसाफ पाइनीम। मिनु ठेयब मुददा बाक्‍त हना, मोसा कली ब्रेत्‍ताक्‍म। आइक्‍च मुददा चहिं आंमा निसाफ पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","मिनु मोसामी आ शिउ कली लचा गेप्‍तु। मिनु मेको आ रागी लेत्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","मिनु इस्राएलीपुकी इजीप्‍त रागी रे ग्रूशा महिना सां नोले सीनै माइश्‍शो गोरशो रागीमी जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ङोंइती रेफीदीम माइश्‍शो रे लशा, सीनै माइश्‍शो डांडा आ ङोंइती आन ताम्‍बु कीतेक्‍म। मेको डांडा आ ङोंइती बाक्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","मिनु मोसा परमप्रभु नु लोव़ पचा कली डांडा ङोंइसाक्‍व। मिनु डांडा रे परमप्रभु यावेमी मोसा कली “इ किकी पिपी याकूब आ खिं ङा मुर, इस्राएली आन कली ");
INSERT INTO suzBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘गो इजीप्‍त ङा मुर आन कली मार मार पङा, मेको ताइतीनी। ककाकुली आ फ्रां तार कुरशो खोदेंशो पा इन कली आं नेक्‍था वोइक्‍तन्‍नी। ब्‍यवस्‍था ३२:११ ");
INSERT INTO suzBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","गे आं देंशो लोव़ पाइतीनी नु आं कबल पशो टीतीनी हना, गे नेल्‍ल जात जात ङा मुर आन दातेमी आं योव़शो मुर दुम्‍नीनी। मारदे हना रागी नेल्‍ल आं केन बाक्‍ब। ब्‍यवस्‍था ५:२; ब्‍यवस्‍था ७:६ ");
INSERT INTO suzBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","गे आं कली चढ़ेब आन राज्‍य नु आं योव़शो जात ङा मुर दुम्‍चा माल्‍नीनी’ दे मेको लोव़ इस्राएली आन कली देंचा माल्‍नेवे” दे माइक्‍तु। यसैया ६१:६; १ पत्रुस २:९; प्रकाश १:६; लेवी १९:२ ");
INSERT INTO suzBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मिनु मोसामी इस्राएल आ थर ङा मुर आन खाल्‍पा आन कली ब्रेश्‍शा, परमप्रभु यावेमी देंशो लोव़ मेको आन कली माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","मिनु मुर नेल्‍ल का दुम्‍शा “परमप्रभु यावे आ देंशो नेल्‍ल पाइनीकी” देंतेक्‍म। मिनु मोसामी मेको मुर आन देंशो लोव़ परमप्रभु यावे कली दें‍त। प्रस्‍थान २४:३-८ ");
INSERT INTO suzBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","परमप्रभु यावेमी मोसा कली “लो, गो मारेइ मतांइसीचा ङा गोस्‍सुमी इ कली ग्रुम्‍थ जाक्‍नुङ। मोपा गो मुर आन कली, गे नु लोव़ पशा नेंपाइक्‍नुङमी। मिनु इ कली गेना हना यो थमा सुइक्‍नीम” दें‍त। मोसामी मुर नेल्‍ल आन देंशो यो परमप्रभु यावे कली दें‍त। प्रस्‍थान १६:१०; प्रस्‍थान ३४:५; भजन संग्रह १८:१२; प्रस्‍थान १४:३१ ");
INSERT INTO suzBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","मिनु परमप्रभु यावेमी मोसा कली “मुलाक्‍ती नु दीसा इस्राएली आन कली गो नु ग्रुम्‍पाइक्‍चा ठीक पावो। आन फेक्‍शो वा मुरपतो। लेवी ११:४४; यहोसु ३:५; अय्‍युब १:५ ");
INSERT INTO suzBl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","नित्‍थ नाक्‍त आं कली ग्रुम्‍चा कली ठीक दुम्‍चा माल्‍नीमी। मारदे हना नित्‍थ नाक्‍ती गो सीनै डांडाम मुर नेल्‍ल आन ङोंइती जाक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","मिनु गे डांडा आ एर ओंथ थरपु हिरचा माल्‍नेवे। गेमी मुर आन कली ‘डांडा मङोइक्‍चा, मथिचा ङा पा थरपु हिरचा माल्‍नेवे। होस पा बाक्‍कीन! सुम डांडा आ पुं थीबा, मेको थमा पा साइक्‍चा पुंइसीब। प्रस्‍थान ३४:३ ");
INSERT INTO suzBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","मुर आन गुइमी थरपु थिचा मदुम्‍ब। मेको थरपु थीबा बस्‍तु भाव बाक्‍तेक्‍म हना यो, मुर बाक्‍तेक्‍म हना यो, मेको कली फुल्‍लु आप्‍शा हना यो ब्रा आप्‍शा हना यो साइक्‍चा माल्‍नीनी’ दे इस्राएली आन कली शेंचा माल्‍नेवे। तुराही आ ठेयब सेंदा नेंशा नोले ला, मेकोपुकी डांडा ङोइक्‍चा माल्‍नीमी” दें‍त। हिब्रू १२:१८-२० ");
INSERT INTO suzBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मिनु मोसा डांडा रे मुर आन बाक्‍तीके तोइश्‍शा, मेको आन कली परमप्रभु नु ग्रुम्‍पाइक्‍चा कली ठीक पाप्‍तु। मिनु मेकोपुकीमी आन फेक्‍शो वा मुरतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","मिनु मोसामी वोंइश मुर आन कली “नित्‍थ नाक्‍त ठीक दुम्‍शा बाक्‍कीने। मीश मुर नु मबाक्‍कीन” दें‍त। १सामुएल २१:४-५; १कोरिन्‍थी ७:५ ");
INSERT INTO suzBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","मिनु मेको आ नित्‍थ नाक्‍ती डांडा तार बुंबु पा, चिला पा, ठेयब गोस्‍स का ग्रूत। मिनु तुराही का थम ठेयब सेंदा पा ग्री‍त। मेको नेंशा, इस्राएलीपुकी हिंशा, ङोन लशा, बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","मिनु मोसामी इस्राएली आन कली परमप्रभु कली ग्रुम्‍थ जाक्‍कीन, दे आन बाक्‍तीक रे ग्रुंइताक्‍व। मेकोपुकी डांडा आ पुंमी राप्‍शा बाक्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","मिनु सीनै डांडा कुनै कुन दुम्‍‍त। मारदे हना परमप्रभु यावे मेकेर मीम तोंइसाक्‍व। मेको मार मार चोशो खोदेंशो पा ठेयब कुन ग्रू्‍त। मिनु डांडामी ठेयब ख्रिनु कु‍त। उत्‍पत्ती १५:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","तुराही आ सेंदा शुश ठेयब दुम्‍मेनु, मोसामी परमप्रभु नु लोव़ पाप्‍तु। मिनु परमप्रभुम बुंबु पशो खोदेंशो पा मोसा कली लोव़ लेत्‍ताक्‍व। प्रस्‍थान ३३:११; प्रेरित ७:३८ ");
INSERT INTO suzBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","मिनु परमप्रभु यावे सीनै डांडा तारी जाक्‍‍त। मिनु परमप्रभु यावेमी मोसा कली “डांडा तार ङोंइसो” दे ब्रेत्‍त। मिनु मोसा ङोंइसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","मिनु परमप्रभु यावेमी मोसा कली “तोंइसो। मुर आन कली ‘होस पा मेकेर बाक्‍कीने। परमप्रभु यावे गे मलने’ दे अरेवो। आं कली कोव़थ कुम्‍तेक्‍म हना, शुश मुर बेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","आं कली ग्रुम्‍थ कुइब चढ़ेबपुकी यो आंम कली चिक्‍शा ठीक दुम्‍चा माल्‍नीम। मो मपाम्‍तेक्‍म हना, गो मेको आन कली यो साइक्‍नुङमी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मिनु मोसामी परमप्रभु यावे कली “मुरपुकी सीनै डांडा ङोइक्‍ने मचाप्‍नीम, मारदे हना गे आं कली ‘एर ओंथ थरपु हिरशा, इन के सेल्‍चा’ दे अरेतीनी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","मिनु परमप्रभु यावेमी मोसा कली “लावो, हारून कली ङोइक्‍पतो। तन्‍न चढ़ेबपुकी नु मुर आन कली चहिं मचाक्‍को। परमप्रभु यावे आ बाक्‍तीके कुम्‍तेक्‍म हना, गो मेको आन कली साइक्‍नुङमी” दें‍त। प्रस्‍थान २४:९-११ ");
INSERT INTO suzBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मिनु मोसा मुर आन बाक्‍तीके तोइश्‍शा, मेको लोव़ नेल्‍ल मुर आन कली माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","मिनु परमप्रभुमी मार लोव़ पाप्‍तु देंशा हना मत्ती ५:१७-२८ ");
INSERT INTO suzBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“गो परमप्रभु यावे, इन परमप्रभु नङ। गो इन कली वाइलीम वाइल दुम्‍शो इजीप्‍त रागी रे ग्रुंइताक्‍न्‍नी। न्‍यायाधीस ६:८; येरमीया ३४:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","गे आं कली ला बाप्‍शा सेउ पने, देवी देवता आन कली बाप्‍शा सेउ मपने। ब्‍यवस्‍था ६:४-५; यसैया ४५:५-६; १कोरिन्‍थी ८:५-६ ");
INSERT INTO suzBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","मूर्ति मसेलीन। सरीङम बाक्‍ब, रागीम बाक्‍ब नु ब्‍वाक्‍कु गाम बाक्‍ब तेकोइ जन्‍तु आन मूर्ति मसेलीने। ब्‍यवस्‍था ४:१५-१९; ब्‍यवस्‍था २७:१५; यसैया ४०:१८-२६; रोमी १:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","मेको आन कली बाप्‍शा सेउ मपने। मेको आन कली ठेयब मसेलीने। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ। गो रुश पाइब परमप्रभु नङ। आं कली काइ मदाक्‍ब नु आ अरेशो मटीब मुर आन आल, चच, युइ नु युइ आन युइ आन पाला सम्‍म यो सजाइ गेब परमप्रभु नङ। प्रस्‍थान ३४:१४; ब्‍यवस्‍था ४:२४; ब्‍यवस्‍था ५:९; ब्‍यवस्‍था ६:१५; अय्‍युब २१:१९; येरमीया ३१:२९-३१; इजीकीएल १८:२५ ");
INSERT INTO suzBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","तन्‍न सु सुमी आं कली दाक्‍नीमी, आं शेंशो लोव़ टीनीमी, मेको आन आल, चच युइ नु युइ आन युइ आन पाला सम्‍म कली ला ममाइ, हजार हजार पाला सम्‍म गेना हना यो शिशी पाइक्‍नुङमी। प्रस्‍थान ३४:७; ब्‍यवस्‍था ७:९ ");
INSERT INTO suzBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","गे परमप्रभु यावे, इन परमप्रभु आं नें, मो मथिने। मारदे हना सुम परमप्रभु यावे आं नें मो थीबा, मेको कली सजाइ मगेथु, मप्रोंइब। लेवी १९:१२; लेवी २४:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","सन्‍चरबार नाइक्‍तीक नाक्‍ती आं नाक्‍त बाक्‍ब। मानेचा माल्‍नीनी। प्रस्‍थान १६:२५-२९ ");
INSERT INTO suzBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","गे ६ नाक्‍त इन गेय नेल्‍ल पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","तन्‍न मेको आ नोले ङा नाक्‍त परमप्रभु यावे, इन परमप्रभु आ नाइक्‍तीक नाक्‍त बाक्‍ब। मेको नाक्‍ती गेपुकी काइ गेय मपने। इन तमी तौ, इन वाइलीम वाइल, इन बस्‍तु भाव, इन रागीम बाक्‍शो अर्को रागी ङा मुर आन कली यो काइ गेय मपपतीन। प्रस्‍थान ३१:१३-१७; इजीकीएल २०:१२; मर्कूस २:२७-२८; कलस्‍सी २:१६-१७ ");
INSERT INTO suzBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","मारदे हना परमप्रभु यावेमी ६ नाक्‍तीमी सरीङ नु रागी, ठेयब समुन्‍द्र नु ठेयब समुन्‍द्रमी बाक्‍शो नेल्‍ल आन कली सेल्‍तु। मिनु नोले ङा नाक्‍त नांइसाक्‍व। मोपतीके परमप्रभु यावेमी ‘मेको आं नाक्‍त बाक्‍ब’ दे मेको नाक्‍त कली आसीक गेशो बाक्‍ब। उत्‍पत्ती २:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","इन आम आफ आन कली मान पने। मो पाइतीनी हना, परमप्रभु यावेमी, इन परमप्रभु इन कली गेशो रागीम शुश ब्रोंइचा गेब। प्रस्‍थान २१:१७; ब्‍यवस्‍था २७:१६; मत्ती १५:४-६; एफिसी ६:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","मुर मसतीन। प्रस्‍थान २१:१२; उत्‍पत्ती ९:५-६; याकूब २:१०-११ ");
INSERT INTO suzBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","मुर आन मीश वोंइश नु मइपीन। लेवी २०:१०; मत्ती १५:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","खुइ मपने। प्रस्‍थान २१:१६; लेवी १९:११; एफिसी ४:२८ ");
INSERT INTO suzBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","जोल पा सांकछी मबाक्‍कीन। प्रस्‍थान २३:१; ब्‍यवस्‍था १९:१८-१९; एफिसी ४:२५ ");
INSERT INTO suzBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","इन नेक्‍था बाक्‍ब मुर आ खिं, आ मीश आ वाइलीम वाइल, आ बी ब्‍यफ नु आ गधा, मेको के मार बाक्‍त हना यो, मेको तशा मबाल्‍दीन। एको परमप्रभु यावे आ अरेशो लोव़ बाक्‍ब” दे मोसामी इस्राएली आन कली देंत। रोमी ७:७; रोमी १३:९ ");
INSERT INTO suzBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","मिनु मुरपुकी ङोन बाक्‍मानु, बुंबु पशो नेंशा नु चिला पशो तशा, तुराही ताप्‍शो नेंशा, डांडा रे कुशो कुन तशा, ङोन लशा हिंशा ख्रिंख्रि पा, कोव़शा बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","मिनु मेकोपुकीमी मोसा कली “गे आंइ कली लोव़ पाइतीनी हना, गो नेंनीकी। तन्‍न परमप्रभुमी आंइ कली लोव़ पाप्‍तु हना, बेक्‍नीकी” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मिनु मोसामी “महिनीन। परमप्रभु इन कली नाक्‍थ जाक्‍त। गे परमप्रभु कली मान पा हिंचा ङा बाक्‍ब, दे मिम्‍ताक्‍नी हना, पाप मपाइनीनी” देंत। उत्‍पत्ती २२:१ ");
INSERT INTO suzBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","मुरपुकी ङोन बाक्‍शो बाक्‍तेक्‍म। मोसा चहिं परमप्रभु आ नेक्‍था क्‍येर गोस्‍सुम लत। १राजा ८:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","मिनु परमप्रभु यावेमी मोसा कली “गे इस्राएली आन कली ‘आं कली सरीङ रे लोव़ पशो नेंतीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","गे गो नु देवी देवता मसेलीन। गे आंम कली सुन नु चांदी के देवी देवता मसेलीने। ");
INSERT INTO suzBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","गे आं कली खप के चढ़ेतीके सेल्‍चा माल्‍नीनी। मेको तारी चोशा चढ़ेतीक चढ़ेचा माल्‍नीनी। इन दुशा बाक्‍चा आ पर्बम चढ़ेतीक चढ़ेन। भेडा, ब्‍यफ चढ़ेचा माल्‍नीनी। गो ते ते इन कली आं नें मिम्‍पाइक्‍नुङा, मेक मेक इन कली आसीक गेनुङ। प्रस्‍थान १७:१५; प्रस्‍थान २७:१-८; ब्‍यवस्‍था १२:५ ");
INSERT INTO suzBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","गे आं कली फुल्‍लु के चढ़ेतीके सेल्‍चा दाक्‍ताक्‍नी हना, मप्रोल्‍शो फुल्‍लु के सेल्‍चा माल्‍नीनी। मेको फुल्‍लु फलामम प्रोल्‍तीनी हना, मेको आं कली मदुम्‍ब। ब्‍यवस्‍था २७:५; यहोसु ८:३१ ");
INSERT INTO suzBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","आं कली चढ़ेतीकेम थेंका मङोंइसीने। इन मुने दोक्‍तीक मतांइसेक्‍ल’ दे माइक्‍मी” देंमाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","मिनु परमप्रभुमी लेंशा “मेको निसाफ पतीक लोव़ मुर आन कली शेंचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘गेपुकीमी हिब्रू वाइल ग्‍याप्‍तीनी हना, ६ बर्स इन गेय पपाइश्‍शा, नोले ङा बर्स मो लचा गेचा माल्‍नीनी। लेवी २५:३९-४१; ब्‍यवस्‍था १५:१२-१७; येरमीया ३४:१४ ");
INSERT INTO suzBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","मेको वाइल आ का जाक्‍त हना, आ का लचा माल्‍ब। ग्‍युंबे पा जाक्‍त हना, आ मीश लाइश्‍शा लचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","आ होव़पम आ वाइल कली ग्‍युंबे पपाइक्‍तु हना, मेकोमी तमी तौ थित हना, मेको मीश मुर नु आलपुकी मेको होव़प केन दुम्‍नीम। मेको वाइल आ का ला लचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","तन्‍न मेको वाइलम “आं होव़प, मीश नु आं आल आन कली दाक्‍नुङ, गो प्रोंइशा मलाइनुङ” देंत हना, ");
INSERT INTO suzBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","आ होव़पम आ वाइली कली परमप्रभु आ ङोंइती लाइक्‍चा माल्‍ब। मिनु लाप्‍चो ङा शीम आ नोफा ख्रित्‍चा कली राप्‍पाइक्‍चा माल्‍ब। मिनु आ होव़पम लूजेमी आ वाइली आ नोफा ख्रित्‍चा माल्‍ब। मिनु मेको गेना हना यो वाइल दुम्‍शा बाक्‍ब। ब्‍यवस्‍था १:१७; भजन संग्रह ८२:१ ");
INSERT INTO suzBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","सुइमी आ तमी कली वाइलीमी सेल्‍शा, लेयतु हना, मेको प्रोंइचा मपुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","मेको होव़पमी आंम कली चाक्‍गा नोले मेको कली मदाक्‍ताक्‍व हना, मेको कली क्‍येट ताक्‍शा प्रोंइचा माल्‍ब। आ होव़पमी मेको वाइलीम कली अर्को रागी ङा मुर आन कली लेयने मचाप्‍ब। मारदे हना मेको मीश मुर मरिम्‍शो पचा पुंइसीशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","मिनु मेको होव़पमी मेको ग्‍याप्‍शो मीश आल आ तौ कली गेप्‍तु हना, आ तमी खोदेंशो पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","मेकोमी अर्को मीश यो चाक्‍तु हना, ङोंइती ङा कली जचा, फेक्‍चा नु ग्‍युंबे पशो मीश मुर आन माल्‍शो नेल्‍ल गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","तन्‍न मेको आ माल्‍शो नेल्‍ल मगेप्‍तु हना, मो लचा गेचा माल्‍ब’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","मिनु “सुमी मुर कली मबेक्‍म सम्‍म तुप्‍बा, मेको मुर थमा पा साइक्‍चा पुंइसीब। प्रस्‍थान २०:१३; उत्‍पत्ती ९:६; मत्ती ५:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","मुरुमी अरु कली खेदा मपथु, साइक्‍चा ममाल्‍शो बाक्‍त, तन्‍न परमप्रभुमी मेको मोदेंशो दुम्‍पाइक्‍तु, गो इन कली मोदेंशो मुर कली प्रोक्‍शा बाक्‍तीक का कोंइनुङ। गन्‍ती ३५:६-२९; ब्‍यवस्‍था १९:४-१३ ");
INSERT INTO suzBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","तन्‍न मुर कामी अरु कली ‘गो साइक्‍नुङ’ दे मेको कली साइक्‍तु हना, मेको मुर कली आं चढ़ेतीक रे लाइश्‍शा, साइक्‍चा माल्‍ब। १राजा २:२९-३० ");
INSERT INTO suzBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","सुम आ आम आफ आस कली तुप्‍बा, मेको थमा पा साइक्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","सुमी मुर कली लेयचा कली खुइ पाइबा, मिनु मेको आ खुइ पशो मुर कली आ खिंम थित्‍तेक्‍म हना, मेको मुर थमा पा साइक्‍चा पुंइसीब। ब्‍यवस्‍था २४:७; १तिमोथी १:१० ");
INSERT INTO suzBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","सुमी आ आम आफ आस कली सराप पाइबा, मेको थमा पा साइक्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","मिनु मुरपुकी जिशा कामी अर्को कली फुल्‍लु आप्‍तु हना, आ गुइमी तुप्‍तु हना, तन्‍न मेको मुर मबेक्‍थु, आ बाक्‍तीकेम इप्‍शा, ");
INSERT INTO suzBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","बोक्‍मेनु, कोक्‍के तिक्‍शा, गाक्‍ने चाप्‍ब दुम्‍त हना, मेको तुप्‍बमी मेको तुप्‍चा पुंइसीब नु गारचा माल्‍ब। तुप्‍चा पुंइसीब आ गेय मपशो ङा ला थाप्‍चा ममाइ, मेको कली ठीक पा मसाम सम्‍म थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","मिनु सुइमी आ वाइलीम वाइल कली कोक्‍केमी तुप्‍तु हना, तुबानु बेक्‍त हना, मेको मुर थमा पा सजाइ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","तन्‍न मेको तुप्‍चा पुंइसीशो मुर का निक्‍शी नाक्‍त सम्‍म ब्रोंइत हना, मेको तुप्‍ब मुर सजाइ गेचा मपुंइसीब। मारदे हना आंम आ क्‍येटीम ग्‍याप्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","मिनु वोंइश मुर जिशा, राम्‍शी पा आन नेक्‍था बाक्‍शो कोव़ज कुरशो मीश मुर कली चुशा चिप्‍शा, मेको मीश मुरुम आ कोव़ज ङा आल शाम्‍ताक्‍व हना, तन्‍न आ चहिं मारेइ मरिम्‍शो मदुम्‍त हना, आ वोंइशेमी देंशो खोदेंशो पा मेको डी डा चुशा चिप्‍ब मुरुम सजाइ ताइब। निसाफ पाइबमी गिश थाप्‍चा माल्‍ब देंबा, मिश थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","तन्‍न मेको मीश मुर नोले बेक्‍त हना, चुशा चिप्‍ब मुर साइक्‍चा पुंइसीब। लेवी २४:१९-२०; ब्‍यवस्‍था १९:२१; मत्ती ५:३८ ");
INSERT INTO suzBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","सुइमी अरु आ मिक्‍ची का पुक्‍ताक्‍व हना, मेको यो आ मिक्‍च पुक्‍चा पुंइसीब। सुइमी अरु आ ख्रुइ का जिक्‍ताक्‍व हना, मेको यो आ ख्रुइ जिक्‍चा पुंइसीब। सुइमी अरु आ गुइ जिक्‍ताक्‍व हना, मेको यो आ गुइ जिक्‍चा पुंइसीब। सुइमी अरु आ खोइली का जिक्‍ताक्‍व हना, मेको यो आ खोइली जिक्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","सुइमी अरु कली मीम चोशा, गार सेल्‍तु हना, मेको कली यो मीम चोशा गार सेल्‍चा माल्‍ब। सुइमी अरु कली तुप्‍तु हना, मेको तुप्‍ब यो तुप्‍चा पुंइसीब। सुइमी अरु कली क्‍योरशा गार सेल्‍तु हना, मेको यो क्‍योरशा गार सेल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","मिनु होव़प कामी आ वाइलीम वाइल आन मिक्‍चीम तुप्‍तु हना, मेको मिक्‍च बुक्‍त हना, मेको होव़पमी मेको मिक्‍च आ पर्बम मेको कली मोशा प्रोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","आ वाइलीम वाइल कली तुप्‍शा, आ ख्रुइ जिक्‍ताक्‍व हना, मेको होव़पमी मेको ख्रुइ आ पर्बम मोशा प्रोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","मिनु ब्‍यफ कामी वोंइश मुर, मीश मुर, सुइ कली ख्रुशा साइक्‍तु हना, मेको ब्‍यफ कली थमा पा फुल्‍लु आप्‍शा साइक्‍चा माल्‍नीनी। आ श्‍ये ब्‍वचा मदुम्‍ब। मेको ब्‍यफ आ होव़प चहिं सजाइ मताइब। उत्‍पत्ती ९:५; गन्‍ती ३५:३३ ");
INSERT INTO suzBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","तन्‍न मेको ब्‍यफ ङोंइती रे ख्रुइ‍ब बाक्‍त हना, मिनु आ होव़पमी तुइश्‍शा यो, आ ब्‍यफ कली रिम्‍शो पा मवोइक्‍तु हना, मेको ब्‍यफोमी वोंइश मुर, मीश मुर, सुइ कली साइक्‍तु हना, मेको ब्‍यफ कली फुल्‍लु आप्‍शा, साइक्‍चा माल्‍ब। मिनु आ होव़प कली यो साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","मसाइक्‍चा, दे क्‍येट पुंइतेक्‍म हना, दोशो पुन्‍मे मोशो गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ब्‍यफोमी तमी तौ ख्रुप्‍तु हना, मेको मोदेंशोन पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ब्‍यफोम सुइ आन वाइलीम वाइल आन कली ख्रुप्‍तु हना, मेको ब्‍यफ आ होव़पमी वाइलीम वाइल आन होव़प कली ३० शेकेल चांदी गेचा माल्‍ब। मिनु ब्‍यफ कली चहिं फुल्‍लु आप्‍शा साइक्‍चा माल्‍ब” देनो। शेकेल का ११.५ ग्राम, तोला खोदेंशो बाक्‍ब। ३० शेकेल चांदी ३४५ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","मिनु “सुइमी लाइश्‍शो इनार रोक्‍तु हना, इनार दोप्‍तु हना, मिनु मेको मसुम्‍थु लत हना, नु ब्‍यफ हना यो गधा हना यो बिक्‍त हना, लेवी ७:२४; लेवी १७:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","मेको इनार आ होव़पमी मेको गारपाइक्‍चा माल्‍ब। मेकोमी बस्‍तु भाव आ होव़प कली क्‍येट गेचा माल्‍ब। मेको बेक्‍शो बस्‍तु चहिं इनार आ होव़प के दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","मिनु मुर का आ ब्‍यफोमी अरु मुर आन ब्‍यफ कली ख्रुशा साइक्‍तु हना, मेको सेस ब्‍यफ कली लेयचा माल्‍ब। मेको ताक्‍शो क्‍येट मेको आस दातेमी योक्‍शा, बेक्‍शो ब्‍यफ यो आस दातेमी योक्‍चा माल्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","तन्‍न मेको ब्‍यफ ङोंइती रे ख्रुइ‍ब बाक्‍ब, दे तुइश्‍शा यो, आ होव़पमी मेको ब्‍यफ कली रिम्‍शो पा मवोइक्‍तु हना, मेको बेक्‍शो ब्‍यफ कली थमा पा थाप्‍चा माल्‍ब। मिनु बेक्‍शो ब्‍यफ मेको के दुम्‍ब” देनो। ");
INSERT INTO suzBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","सुइमी ब्‍यफ, भेडा खुइ पशा, क्‍योरशा ब्‍वाप्‍तु हना यो, लेयतु हना यो, मेको मुरुमी ब्‍यफ का के ५ ओटा ब्‍यफ थाप्‍चा माल्‍ब। भेडा का के ४ ओटा भेडा थाप्‍चा माल्‍ब। २सामुएल १२:६; हितोपदेस ६:३१; लूका १९:८ ");
INSERT INTO suzBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","मिनु खुइ कली खुइ पना पन थित्‍तेक्‍म हना, मेको कली तुप्‍शा साइक्‍तेक्‍म हना, साइक्‍ब साइक्‍चा ङा सजाइ गेचा मपुंइसीनीम। ");
INSERT INTO suzBl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","तन्‍न नां दाप्‍शा नोले सम्‍म तुप्‍शा साइक्‍तु हना, मेको साइक्‍ब साइक्‍चा ङा सजाइ ताइब। खुइ पाइब आ खुइ पशो नेल्‍ल लेत्‍चा माल्‍ब। थाप्‍ने मचाप्‍तु हना, वाइल सेल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","मेको खुइ आ खुइ पशो ब्‍यफ, गधा, भेडा आ बाक्‍तीकेम सेल थित्‍तेक्‍म हना, मार बाक्‍त हना यो का के निक्‍शी थाप्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","मिनु “सुइमी आ बी ब्‍यफ, क्‍यारश भेडामी अरु मुर आन शोक्‍शो रू नेक्‍पाइक्‍तु हना, अङगुर रू ङा अङगुर नेक्‍पाइक्‍तु हना, मेकोमी आ आंम रू ङा नेल्‍ल क्‍येङा रिम्‍शो फल थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","सुइमी मी मुइक्‍तानु, मेको मीम चू नु रूमी बाक्‍शो मारेइ नेक्‍तु हना, मेको मी मुइक्‍बमी मीम नेक्‍शो नेल्‍ल थाप्‍चा माल्‍ब” देनो। ");
INSERT INTO suzBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","मिनु “सुइमी आ नेक्‍था ङा मुर कली आ क्‍येट, अरु मारेइ वोइक्‍चा कली गेप्‍तु हना, वोइक्‍ब मुर आ खिं रे खुइ दुम्‍त हना, नु खुइ कली थित्‍तेक्‍म हना, मेको खुइमी का के निक्‍शी थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","खुइ मथित्‍तेक्‍म हना, मेको खिं ङा ठेयब मुरुमी आंम नेक्‍था ङा मुर आ मार मार खुइ पवा कों, दे परमप्रभु आ ङोंइती राप्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","मिनु बी ब्‍यफ, गधा, भेडा नु वासी मार मार वोइक्‍बमी नु वोइक्‍चा गेब, निम्‍फामी ‘आं के बाक्‍ब’ देंताक्‍स हना, मेको निक्‍शी परमप्रभु आ ङोंइती जाक्‍चा माल्‍नीस। परमप्रभुमी सुम खुइ सुइक्‍बा, मेकोमी का ङा निक्‍शी थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","मिनु सुइमी आ नेक्‍था ङा मुर कली गधा, ब्‍यफ, भेडा नु अरु बस्‍तु भाव वोइक्‍चा कली गेप्‍तु हना, मेको बस्‍तु भाव बेक्‍तेक्‍म हना, तुप्‍शा बिग्रेम्‍तेक्‍म हना, सुइम मतचा ङा पा मुरुम खुइ पा लाइश्‍शो बाक्‍तेक्‍म हना, १राजा ८:३१-३२ ");
INSERT INTO suzBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","मेको वोइक्‍बम आ नेक्‍था ङा मुर आ बस्‍तु भाव ‘खुइ मपङ’ दे परमप्रभु यावे आ ङोंइती कसम जचा माल्‍ब। मिनु बस्‍तु भाव आ होव़पम मेको थमा सुदानु, वोइक्‍ब मुरुमी मारेइ थाप्‍चा ममाल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","तन्‍न आ खिं रे खुइ पशो बाक्‍त हना, मेको वोइक्‍बमी मेको थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ब्‍वाकी ङा जन्‍तुम मेको बस्‍तु कली ग्‍याइश्‍शा साइश्‍शो बाक्‍त हना, मेको वोइक्‍बम मेको साइश्‍शो बस्‍तु दसी चाक्‍चा माल्‍ब। मेको ब्‍वाकी ङा जन्‍तुमी साइश्‍शो कली थाप्‍चा ममाल्‍ब। उत्‍पत्ती ३१:३९ ");
INSERT INTO suzBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","मिनु सुइमी आ नेक्‍था ङा मुर रे ब्‍यफ का परमा पचा कली पुंइतु हना, बस्‍तु आ होव़प मबाक्‍थु, मेको ब्‍यफ खजा दुम्‍त हना, बेक्‍त हना, मेको थमा पा थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","तन्‍न आ होव़प यो बाक्‍त हना, मेको मारेइ थाप्‍चा ममाल्‍ब। मारदे हना गेय पचा कली क्‍येट गेशो बाक्‍ब” देनो। ");
INSERT INTO suzBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","मिनु “वोंइश मुर कामी कन्‍ने मीश आल नु मिलो शिलो पा, मेको नु इप्‍त हना, मेको कली थमा पा ग्‍युंबे पा आ आफ कली मार मार थाप्‍चा माल्‍ब। ब्‍यवस्‍था २२:२८-२९ ");
INSERT INTO suzBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","तन्‍न मीश आल आ आफोमी आ तमी मगेप्‍तु हना, मेको वोंइश मुरुम कन्‍ने ग्‍युंबे पशो खोदेंशो पा, क्‍येट थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","टुना मुना पाइब कली ब्रोंइचा मगेचा। लेवी २०:६,२७; लेवी १९:३१; ब्‍यवस्‍था १८:१०; १सामुएल २९:९; मलाकी ३:५ ");
INSERT INTO suzBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","सु बस्‍तु नु इप्‍बा, मेको कली थमा पा साइक्‍चा माल्‍नीनी। लेवी १८:२३; ब्‍यवस्‍था २७:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","सुमी देवी देवता कली पूजा पाइबा, मेको मुर थमा पा साइक्‍चा पुंइसीब। परमप्रभु यावे कली ला चढ़ेचा माल्‍ब। प्रस्‍थान २०:३-५; ब्‍यवस्‍था १३:७-१९; ब्‍यवस्‍था १७:२-७ ");
INSERT INTO suzBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","अर्को रागी ङा मुर आन कली श्‍येत मगेचा, मदिप्‍चा। मारदे हना गे यो इजीप्‍त रागीमी अर्को रागी ङा मुर दुम्‍शा बाक्‍तीनी। लेवी १९:३३-३४; ब्‍यवस्‍था १०:१८,१९ ");
INSERT INTO suzBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","आ वोंइश बेक्‍शो मीश मुर नु रोम रोइक्‍च आन कली श्‍येत मगेचा। ब्‍यवस्‍था २७:१९; यसैया १:१७; जकरिया ७:१० ");
INSERT INTO suzBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","गेपुकीमी श्‍येत गेतीनी हना, मेकोपुकीमी आं कली लोव़ पाम्‍तेक्‍म हना, गो थमा पा आन पुंइशो गेनुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","मिनु गो गाइश्‍शा, इन कली तरवारमी साइक्‍नन्‍नी। मिनु इन मीश वोंइश बेक्‍शो मीश दुम्‍ब। इन आलपुकी आफ बेक्‍शो आल दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","गेपुकीमी आं मुर आन दाते ङा प्रुङग आन कली क्‍येट जेर गेतीनी हना, गे क्‍येट चेम्‍चा कली चाइक्‍ब ताक्‍ब मुर खोदेंशो मदुमीन। लेवी २५:३६; ब्‍यवस्‍था २३:२०; हितोपदेस २८:८ ");
INSERT INTO suzBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","मिनु गेपुकीमी मेको आन सुम्‍तीक वासी क्‍येट आ पा ङा लाइक्‍तीनी हना, नां पेरची ना मेको लेत्‍चा माल्‍नीनी। ब्‍यवस्‍था २४:१०-१३ ");
INSERT INTO suzBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","मारदे हना मेको आन रां ङा सुम्‍तीक का ला बाक्‍ब। इप्‍ची ना दोपा सुम्‍सीनीमी? आं कली ब्रेत्‍तेक्‍म हना, गो आन पुंइशो गेनुङ। मारदे हना गो शिशी पाइब नङ। ");
INSERT INTO suzBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","परमप्रभु आ पर्बम मरिम्‍शो लोव़ मपचा। इन कली सासन पाइब कली सराप मपचा। लेवी २४:१४-१६; प्रेरित २३:५ ");
INSERT INTO suzBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","गे इन रू ङा ङोंइती मीशो मारेइ मारेइ नु अङगुर रस चढ़ेचा मरिम्‍दीन। मिनु इन ङोंइती जरमेशो तौपुकी आं कली गेचा माल्‍नीनी। प्रस्‍थान २३:१९; ब्‍यवस्‍था १८:४; हितोपदेस ३:९-१०; प्रेरित १३:२,१३ ");
INSERT INTO suzBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","इन बी ब्‍यफ नु इन भेडा रे यो मोदेंशो पचा माल्‍नीनी। ७ नाक्‍त आन ममा नु बाक्‍चा माल्‍नीमी। मेको नोले ङा नाक्‍ती आं कली गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","गेपुकी आं मुर ला दुम्‍चा माल्‍नीनी। गे ब्‍वाकी ङा जन्‍तुपुकीम साइश्‍शो मब्‍वने। मेको कुचुम कली ब्‍वचा गेन” देनो। लेवी १९:२; १पत्रुस १:१५; लेवी ७:२४; ब्‍यवस्‍था १४:२१; इजीकीएल ४:१४; इजीकीएल ४४:३१ ");
INSERT INTO suzBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“गेपुकी जोल लोव़ मब्रपतीने। मरिम्‍शो पाइब कली वारच मपने। जोल पा सांकछी मबाक्‍कीन। प्रस्‍थान २०:१६; लेवी १९:१६; भजन संग्रह १५:३; हितोपदेस १९:९ ");
INSERT INTO suzBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","मिनु ठेयब हुल का मरिम्‍शो पाइब बाक्‍तेक्‍म हना, मेको आन नोले मखोतीन। निसाफ पाइब आ ङोंइती ‘ठेयब हुल ङा मुर ठीक बाक्‍नीम’ मदेनीन। मोपा आं ठीक पतीके रे ङोन मलने। ");
INSERT INTO suzBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","दूली पाइब मुर प्रुङग बाक्‍त हना यो मेको कली वारच मपतीन। लेवी १९:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","मिनु गे इन जोरी सत्रु आन ब्‍यफ, गधा लां जाम्‍शा, हिरशो ताइतीनी हना, मेको कली वारच पा, लेश्‍शा आ खिं चोव़दीत्‍चा माल्‍नीनी। अय्‍युब ३१:२९; हितोपदेस २५:२१-२२; लूका ६:२७ ");
INSERT INTO suzBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","गे नु मदुइब मुर आ गधा आ भारीम चिप्‍शो थित्‍तीनी हना, गे मेको पोक्‍ने मचाप्‍शो मुर ताइतीनी हना, मेको कली महेरदीन। मेको कली वारच पा मेको कली पोक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","मिनु प्रुङग मुर का पित हना, मेको कली प्रुङग बाक्‍त हना यो, ठीक निसाफ पने। ब्‍यवस्‍था २५:१९; भजन संग्रह ८२:२-४; उपदेसक ५:७; यसैया १:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","जोल पा सांकछी माल्‍ब आन क्‍येङा ङोन बाक्‍कीन। दोस मताइब नु ठीक पाइब कली मसतीन। मारदे हना गो मरिम्‍शो पाइब आ पर्बम ठीक पाइब बाक्‍ब मदेंनुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","गेपुकी ख्रुइश्‍शा मारेइ मताक्‍कीन। मारदे हना मेकोमी मिक्‍च सिल्‍ब। मिनु ख्रुइश्‍शा ताक्‍शोमी ठीक पाइब आ मुददा लोक्‍ब। ब्‍यवस्‍था २७:२५; १सामुएल ८:३; हितोपदेस १७:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","मिनु अर्को रागी ङा मुर आन कली मदिपीन। मारदे हना गेपुकी यो इजीप्‍त रागीम अर्को रागी ङा मुर दुम्‍शा, अर्को रागी ङा मुर आन थुं तुइक्‍नीनी। प्रस्‍थान २२:२० ");
INSERT INTO suzBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","मिनु ६ बर्स सम्‍म इन रूमी ख्रुम्‍शा, सेक्‍शा खुप्‍तीन। लेवी २५:१-१७, १८-२४ ");
INSERT INTO suzBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","मिनु मेको आ नोले ङा बर्स चहिं मारेइ मशोक्‍थु, मो वोतीन। इन रागी ङा प्रुङगपुकीमी मेको आंमा वाशो जामेक्‍ल। लीत हना, जन्‍तुपुकीम जामेक्‍ल। इन अङगुर रू नु इन तेल रवापुकी यो मेको खोदेंशोन पने। ");
INSERT INTO suzBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","गेपुकी ६ नाक्‍त गेय पचा माल्‍नीनी। मेको आ नोले ङा नाक्‍ती चहिं नांइसीन। मोपा इन ब्‍यफ नु गधा यो नाइक्‍ने चाप्‍नीम। मिनु इन वाइलीम आ तौ नु इन खिंम बाक्‍शो अर्को रागी ङा मुर यो नाइक्‍चा ताइनीम। प्रस्‍थान २०:८-११ ");
INSERT INTO suzBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","आं अरेशो नेल्‍ल पने। देवी देवता आन कली मारेइ मपुंइचा आन नें यो मथिचा। यहोसु २३:७; जकरिया १३:२ ");
INSERT INTO suzBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","बर्सम आं पर्बम खेयप सां चाड मानेचा माल्‍नीनी। प्रस्‍थान ३४:१८-२६; लेवी २३:४-४४; ब्‍यवस्‍था १६:१-१७ ");
INSERT INTO suzBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","गो इन कली देंशो खोदेंशो पा, बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ङा चाड मानेचा माल्‍नीनी। गेपुकी ७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। मेको आबीब महिनामी पचा माल्‍नीनी। मारदे हना गेपुकी आबीब महिनामी इजीप्‍त रागी रे ग्रूतीनी। आं ङोंइती श्‍येत्‍थ गुइ मजाक्‍कीन। प्रस्‍थान १२:१५-२० ");
INSERT INTO suzBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","मिनु इन रूम ख्रुम्‍शो ङोंइती ङा मीशो मारेइ मारेइ ङा चाड मानेचा माल्‍नीनी। बर्स नुप्‍ची ना नेल्‍ल रिक्‍शा, खुप्‍शा, ओंइने थुम्‍शो ङा चाड मानेचा माल्‍नीनी। प्रस्‍थान ३४:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","वोंइश मुर नेल्‍ल परमप्रभु, परमप्रभु यावे आ ङोंइती बर्समी खेयप सां जाक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","गेपुकीमी चढ़ेनीनु, चढ़ेशो आ हुश नु बोरब ओख्‍ती सुप्‍शो मारेइ मारेइ कालेमी मचढ़ेन। मेको चढ़ेशो श्‍ये आ बोंसो सुनी सम्‍म महेंचा। प्रस्‍थान १२:७-१०; प्रस्‍थान ३४:२५ ");
INSERT INTO suzBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","मिनु इन रू ङा ङोंइती मीशो नेल्‍ल क्‍येङा रिम्‍शो फल फुल नु अन्‍न परमप्रभु यावे, इन परमप्रभु आ बाक्‍तीकेम चाक्‍चा माल्‍नीनी। गेपुकीमी पाठा कली आ ममा आ दूधम लोप्‍शा मक्‍येने, देनो” दे परमप्रभु मोसा कली देंत। उत्‍पत्ती ४:४; ब्‍यवस्‍था २६:१-११; नेहेन्‍याह १०:३६; ब्‍यवस्‍था १४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","मिनु परमप्रभुमी “नेनीन, गो इन ङोंइती आं स्‍वर्ग ङा गेय पाइब का सोइक्‍नुङ। मेकोमी लांमी इन कली कोव़शा नु आं देंशो बाक्‍तीकेम चोव़दीब। प्रस्‍थान १४:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","गेपुकी होस पा बाक्‍शा, आं देंशो टिने। गेपुकी मेको कली मगाइक्‍पतीन। मारदे हना आं नें मेको नु बाक्‍ब। मिनु मेकोमी इन हेंथे पतीक मक्‍याम्‍ब। यसैया ६३:१० ");
INSERT INTO suzBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","गेपुकी आ देंशो नेनीन। आं देंशो नेल्‍ल पाइतीनी हना, गो इन जोरी सत्रु आन जोरी सत्रु दुम्‍नुङ। इन कली खेदा पाइब आन कली खेदा पाइब दुम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","आं स्‍वर्ग ङा गेय पाइब थमा पा इन ङोंइती लाइब। मिनु इन कली एमोरी, हित्ती परिज्‍‍जी, नानी, हिव्‍वी नु यबुसी कनानी आन रागी चोव़दीब। मिनु गो मेको नेल्‍ल आन कली क्‍याम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","गेपुकी मेको आन खोदेंशो मपने। मेको आन देवी देवता आन ङोंइती बाप्‍शा सेउ मपने। मेको आन कली गेय मपने। तन्‍न मेको आन मूर्ति जिक्‍शा प्रोल्‍शा ताइक्‍तीन। प्रस्‍थान २०:५; ब्‍यवस्‍था १२:३०; लेवी १८:३ ");
INSERT INTO suzBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","गे परमप्रभु यावे, इन परमप्रभु कली गेय पाइतीनी हना, गो इन जचा तूचा थोव़क कली आसीक गेनुङ। मिनु इन कली रोइ नेल्‍ल रे प्रोंइनुङ। प्रस्‍थान १५:२६ ");
INSERT INTO suzBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","इन रागीमी मीश मुरपुकी आल शाम्‍ब नु आल मथीब मदुम्‍नीम। मिनु गेपुकी खाल्‍पी खाल्‍पा दुम्‍चा सम्‍म ब्रोंइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","गो इन ङोंइङोंइती हिंच कोंइनुङमी। मिनु गे ते ते जाक्‍दीत्‍नीनी, गो मेक ङा जात जात ङा मुर आन थुं लुक्‍च लपाइक्‍नुङ। मिनु इन जोरी सत्रु इन कली तशा प्रोक्‍नीम। उत्‍पत्ती ३५:५; यहोसु २:९-११; १सामुएल १४:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","गो इन ङोंइङोंइती हिकवा सोइश्‍शो खोदेंशो पा हिंतीक सोइक्‍नुङ। मिनु हिव्‍वी, कनानी नु हित्ती इन ङोंइती रे प्रोक्‍पाइक्‍नुङ। ब्‍यवस्‍था ७:२०; यहोसु २४:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","तन्‍न बर्स कामी मेको आन कली मप्रोक्‍पाइक्‍नुङमी। मोपा प्रोक्‍पाइक्‍तामी हना, गोरशो रागी दुम्‍शा, इन क्‍येङा ब्‍वाकी ङा जन्‍तु शुश दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","गे शुश दुम्‍शा, मेको रागी मब्रीनी सम्‍म, गो मेको आन कली इन ङोंइती रे का का पा ग्रुंइनुङमी। ब्‍यवस्‍था ७:२२ ");
INSERT INTO suzBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","गो इन रागी लल समुन्‍द्र रे पलिस्‍ती आन ठेयब समुन्‍द्र सम्‍म नु गोरशो रागी रे युफ्रेटीस खोला सम्‍म दुम्‍पाइक्‍नुङ। मिनु गो मेको रागी ङा मुर इन कली जिम्‍मा गेनुङ। मिनु गे मेको आन कली खेरनीनी। उत्‍पत्ती १५:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","गे मेकोपुकी नु मेको आन देवी देवता नु कबल मपमुने। प्रस्‍थान ३४:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","मेकोपुकीम इन कली पाप पपाइक्‍नीम। मोपतीके मेको आन कली इन रागीमी बाक्‍चा मगेने। गे मेको आन देवी देवता आन कली गेय पाइतीनी हना, आन ग्‍याइलीम रेत्‍चा पुंइसीनीनी” दे परमप्रभु यावेमी इस्राएली आन कली अरेवा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","मिनु परमप्रभु यावेमी मोसा कली “गे, हारून, नादाब, अबीहु नु इस्राएली आन खाल्‍पा रे ७० जना मुर कुने। मिनु ङोन रे आं कली सेउ पचा माल्‍नीनी। प्रस्‍थान २८:१; लेवी १०:१; गन्‍ती ११:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","गे ला आं नेक्‍था जाक्‍ने चाप्‍नेवे। अरु चहिं नेक्‍था मजाक्‍थु, बाक्‍चा माल्‍नीमी। मिनु मुरपुकी गे नु डांडा ङोइक्‍चा मदुम्‍नीम” दे परमप्रभु यावेमी दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मिनु मोसा डांडा रे तोइश्‍शा, मुर आन कली परमप्रभु यावेमी देंशो नु अरेशो लोव़ नेल्‍ल नेंपाइक्‍तीमी। मिनु मुर नेल्‍लेमी मुर का खोदेंशो पा “परमप्रभु यावेमी देंशो लोव़ नेल्‍ल गो पाइनीकी” देंतेक्‍म। प्रस्‍थान १९:८ ");
INSERT INTO suzBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","मिनु मोसामी परमप्रभु यावे आ देंशो लोव़ नेल्‍ल ब्रेक्‍ताक्‍व। मिनु सुनी कना बोक्‍शा, डांडा आ पुंमी चढ़ेतीक का नु इस्राएल आ १२ थर मिम्‍चा कली १२ ओटा फुल्‍लु ख्रुक्‍तु। प्रस्‍थान ३४:२७; यहोसु ४:२० ");
INSERT INTO suzBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","मिनु मोसामी इस्राएली ठिटा आन कली बोहोर क्‍योरशा, चोशा चढ़ेतीक नु परमप्रभु यावे नु दुशा बाक्‍चा आ पर्बम चढ़ेतीक चढ़ेपपाइक्‍तु। न्‍यायाधीस १७:७ ");
INSERT INTO suzBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मिनु चढ़ेशो बस्‍तु आन हुश आधा लाइश्‍शा, बोसपुकीम कुर पाप्‍तु। मिनु लीशो हुश चढ़ेतीकेम ब्रुइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","नोले कबल ङा लोव़ ब्रेक्‍शो किताब मुर आन कली नेंपाइक्‍चा कली पढेप्‍तु। मिनु मेकोपुकीमी “परमप्रभु यावे आ देंशो नेल्‍ल पाइनीकी। आ लोव़ टीनीकी” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","मिनु मोसामी बोस ङा हुश लाइश्‍शा, मुर आन कली ब्रुइश्‍शा “नेनीन, परमप्रभु यावेमी गेपुकी नु कबल पाप्‍तु। मेको हुश परमप्रभु यावे आ कबल ङा देंशो लोव़ आ छाप बाक्‍ब” दें‍त। हिब्रू ९:१९-२७; मर्कूस १४:२४ ");
INSERT INTO suzBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","मिनु मोसा, हारून, नादाब, अबीहु नु इस्राएली आन खाल्‍पा रे ७० जना मुर डांडा ङोंइसाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","मिनु मेकोपुकीमी इस्राएली आन परमप्रभु कली ताम्‍तेक्‍म। आ बाक्‍तीक बास साफीर माइश्‍शो हीरा खोदेंशो दिंम का बाक्‍शो बाक्‍त। मेको हाक्‍शो सरीङ खोदेंशो नीलो बाक्‍‍त। इजीकीएल १:२६ ");
INSERT INTO suzBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","मिनु परमप्रभुमी इस्राएली आन खाल्‍पा आन कली मारेइ मपव। मिनु मेकोपुकीमी परमप्रभु कली तशा, जशा तूशा बाक्‍तेक्‍म। प्रस्‍थान १९:२१-२२; प्रस्‍थान ३३:२०-२३ ");
INSERT INTO suzBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","मिनु परमप्रभु यावेमी मोसा कली “गे डांडा ङोइश्‍शा, आं नेक्‍था जाक्‍शा रिम्‍शा बाक्‍को। गो आं अरेशो लोव़ नु आं शेंशो लोव़ इस्राएली आन कली शेंचा कली फुल्‍लु निक्‍शीम मुशा ब्रेक्‍ताक्‍ङ। गो मेको फुल्‍लु इ कली गेनन्‍न” दें‍त। प्रस्‍थान ३१:१८; २कोरिन्‍थी ३:६ ");
INSERT INTO suzBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","मिनु मोसा आ गेय पाइब यहोसु लाइश्‍शा, परमप्रभु आ डांडा ङोंइसाक्‍व। प्रस्‍थान ३३:११ ");
INSERT INTO suzBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","तन्‍न ङोंइती मोसामी इस्राएली आन खाल्‍पा आन कली “गो मलेस्‍कु सम्‍म, एकेर रिम्‍दीन। नेनीन, हारून नु हुर गेपुकी नु बाक्‍नीस। मार निसाफ प‍चा माल्‍नीनी, मेको निक्‍शीमी गारपाइक्‍नीस” दें‍त। प्रस्‍थान १७:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","मिनु मोसा डांडा ङोंइसाक्व। मिनु गोस्‍सुम मेको डांडा सुम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","मिनु परमप्रभु यावे आ छेङछेङ सीनै डांडाम बाक्‍शो बाक्‍त। मेको गोस्‍सुम डांडा कली ६ नाक्‍त सम्‍म सुम्‍तु। मिनु नाक्‍त का नोले गोस्‍स आ दाते रे परमप्रभु यावेमी मोसा कली ब्रेत्‍ताक्‍व। प्रस्‍थान १६:१० ");
INSERT INTO suzBl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","मिनु परमप्रभु यावे आ छेङछेङ इस्राएली आन कली डांडा तारी थम ठेयब ब्रशो मी खोदेंशो पा तांइसाक्‍व। ब्‍यवस्‍था ४:२४; ब्‍यवस्‍था ९:३; हिब्रू १२:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मिनु मोसा गोस्‍स आगा ओव़शा, डांडा ङोइश्‍शा, ४० नाक्‍दो नु ४० नाक्‍ती बाक्‍त। प्रस्‍थान ३४:२८ ");
INSERT INTO suzBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएली आन कली ‘आं कली मार मार गेचा मिम्‍नीनी, मेको गेने’ दे मतो। आन थुंमी गेचा दाक्‍शो, नेल्‍ल आन चाक्‍शो गे नु इ कली वारच पाइबपुकीमी ताक्‍कीन। प्रस्‍थान ३५:४-७; १इतिहास २९:५; एज्रा २:६८,६९ ");
INSERT INTO suzBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","आं कली मार मार ताक्‍चा माल्‍नीनी देंशा हना, सुन चांदी नु कांसा, ");
INSERT INTO suzBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीलो, प्‍याजी नु लल रङ ङा श्‍येले, रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा, क्‍यारश आ चां, ");
INSERT INTO suzBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लल रङ नुप्‍शो सांड आ कुशुल, नेल्‍ल क्‍येङा रिम्‍शो सेल्‍शो कुशुल, बोल्‍यो शी, ");
INSERT INTO suzBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","बत्ती दातीक तेल, लुक्‍तीक तेल नु धूप कली ब्रोव़शो रिना पपाइक्‍ब थोव़क, ");
INSERT INTO suzBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला नु कुचु तार वोइक्‍तीक सेल्‍चा कली ओनीक्‍स माइश्‍शो हीरा नु अरु हीरा ताक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","मिनु गो मेको आन दातेमी बाक्‍चा कली आं बाक्‍तीक सेल्‍पतो। इजीकीएल ३७:२६-२८ ");
INSERT INTO suzBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","गो इ कली कोंइशो खोदेंशो पा ताम्‍बु सेल्‍पाइक्‍चा माल्‍नेवे। आगाम मार मार वोइक्‍चा माल्‍नेवे, मेको आं कोंइशो खोदेंशो पा सेल्‍पतो। प्रस्‍थान २५:४०; प्रस्‍थान २६:३०; प्रस्‍थान २७:८ ");
INSERT INTO suzBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","मेकोपुकीमी बोल्‍यो शी के सन्‍दोस का सेल्‍चा माल्‍नीम। मेको आ पित्‍थ लाइश्‍शो कुबीत निक्‍शी नु आधा, आ ब्रेम्‍शो कुबीत का नु आधा नु आ ग्‍येत्‍थ लाइश्‍शो कुबीत का नु आधा ङा सेल्‍चा माल्‍नीम। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","मिनु गे मेको सन्‍दोस आ खिंङगा नु आ लाङगा नेल्‍ल क्‍येख सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। मिनु एर ओंथ सुन के सुर सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","मिनु सुन के ४ ओटा मुन्‍द्रा सेल्‍पाइक्‍चा माल्‍नेवे। का पटटी निक्‍शी नु अर्को पटटी निक्‍शी पा सन्‍दोस आ ४ सुरमी क्‍येप्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","मिनु बोल्‍यो शी के कुरतीक कोक्‍के निक्‍शी सेल्‍पाइश्‍शा, सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। १राजा ८:८ ");
INSERT INTO suzBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","मिनु मेको कुरतीक कोक्‍के निक्‍शी मेको मुन्‍द्राम शुइक्‍चा माल्‍नेवे। मो पा मेको सन्‍दोस कली कुरने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","मेको कोक्‍के निक्‍शी सन्‍दोसम बाक्‍शो मुन्‍द्राम शुइक्‍चा माल्‍नीस। मेको आस कली मशोल्‍चा। ");
INSERT INTO suzBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","मिनु गो इ कली गेचा चिक्‍शो कबल पा अरेशो लोव़ मेको सन्‍दोसमी कुर पा वोइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","मिनु सन्‍दोस सुम्‍तीके क्‍येख सुन के चेम्‍शा सेल्‍चा माल्‍नेवे। मेकेर परमप्रभु आ शिशी बाक्‍ब। आ पित्‍थ लाइश्‍शो कुबीत निक्‍शी नु आधा नु आ ब्रेम्‍शो कुबीत का नु आधा बाक्‍चा माल्‍ब। कुबीत का ०.५ मिटर, कुबीत का खोदेंशो बाक्‍ब।लेवी १६:१२-१५; हिब्रू ४:१६; हिब्रू ९:५ ");
INSERT INTO suzBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","मिनु गे आं स्‍वर्ग ङा गेय पाइब खोदेंशो सुन के करूब निक्‍शी चेम्‍शा सेल्‍पाइक्‍चा माल्‍नेवे। मेको सुम्‍तीकेम आ निम्‍फा पटटी का का करूब चेम्‍शा सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","का पटटी करूब का, अर्को पटटी करूब का चेम्‍शा सेल्‍चा माल्‍नेवे। मेको सुम्‍तीके नु करूब निम्‍फा मख्रोंइसीशो सुन का केन चेम्‍शा सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","मेको करूबम आस फ्रां हाम्‍शा, सुम्‍तीके फारचा माल्‍नीस। आस कुल कोव़मुशा, सन्‍दोस सुम्‍तीके गे कोव़चा माल्‍नीसी। ");
INSERT INTO suzBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","मेको सुम्‍तीके मेको कबल पशो सन्‍दोस तार वोइक्‍चा माल्‍नेवे। मिनु गो इ कली गेचा चिक्‍शो कबल पा अरेशो लोव़ मेको कबल पशो सन्‍दोसम कुर पा वोइक्‍चा माल्‍नेवे। प्रस्‍थान ३४:२९; १राजा ८:९ ");
INSERT INTO suzBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","मिनु गो मेको सन्‍दोस सुम्‍तीके शिशी बाक्‍तीकेम गे नु ग्रुम्‍शा, लोव़ पाइनुङ। मेको सुम्‍तीके आ तारी मेको करूब निक्‍शी आस दाते रे गो इस्राएली आन कली मार मार अरेचा माल्‍नुङा, मेको गो इ कली देंनुङ। गन्‍ती ७:८९; २सामुएल ६:२ ");
INSERT INTO suzBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","गे बोल्‍यो शी के टेबल का सेल्‍पाइक्‍चा माल्‍नेवे। मेको आ पित्‍थ लाइश्‍शो कुबीत निक्‍शी नु आ ब्रेम्‍शो कुबीत का नु आ ग्‍येत्‍थ लाइश्‍शो कुबीत का नु आधा दुम्‍चा माल्‍ब। कुबीत का ०.५ मिटर, खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","मिनु मेको कली क्‍येख सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। सिरपेच खोदेंशो पा एर ओंथ नेल्‍ल सुन के सुर सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","मेको एर ओंथ ङा सुर नेल्‍ल ४ आंइची ब्रेम्‍शो दुम्‍चा माल्‍ब। मेको कली सिरपेच खोदेंशो पा बुटा आप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","मिनु ४ ओटा सुन के मुन्‍द्रा चेम्‍शा, मेको आ ४ ओटा खोइलीम टेबल आगाम क्‍येप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","टेबल कुरचा कली मुन्‍द्रापुकी टेबल आ सुर आ नेक्‍था क्‍येप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","मिनु बोल्‍यो शी के कोक्‍के निक्‍शी सेल्‍शा, सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। मेको टेबलम बाक्‍शो मुन्‍द्राम शुइश्‍शा कुरने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","मिनु टेबलम वोइक्‍चा माल्‍शो थाल, लोटा नु बोस नेल्‍ल नु तूचा थोव़क चढ़ेतीक लुक्‍चा कली लोटा नेल्‍ल क्‍येख सुन के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","मिनु मेकेर गेना हना यो आं ङोंइती कोंइतीक शोब्‍ले वोइक्‍चा माल्‍नेवे। लेवी २४:५-६ ");
INSERT INTO suzBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","गे क्‍येख सुन के बत्ती दातीक का चेम्‍शा सेल्‍पाइक्‍चा माल्‍नेवे। आ थाम, आ राशी, आ दियारी, आ डल्‍ला नु फूपुकी ठेयब सुन का केन दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","मिनु मेको बत्ती दातीक आ थाम रे ६ ओटा राशी ग्रूचा माल्‍नीम। का पटटी रे सां नु अर्को पटटी रे सां ग्रूचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","मिनु मेको राशी कामी देसी बदाम आ फू खोदेंशो बुटा पाइश्‍शो फू सां ग्रूचा माल्‍नीम। अर्को राशीपुकी यो नेल्‍ल मोदेंशोन दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","मेको बत्ती दातीक आ थामम चहिं ४ ओटा देसी बदाम आ फू खोदेंशो बुटा पाइश्‍शो ग्रूचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","थाम आ ङोंइती ङा डल्‍ला, आ दाते ङा डल्‍ला नु नोले ङा डल्‍ला रे निम्‍फा पटटी गे राशी निक्‍‍निक्‍शी गूचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","मेको आ राशी नु डल्‍ला नेल्‍ल ठेयब क्‍येख सुन का केन चेम्‍शो दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","गे क्‍येख सुन के ७ ओटा दियारी सेल्‍पाइक्‍चा माल्‍नेवे। मिनु सल्‍दो वोइश्‍शा, नेल्‍ल तांइसीचा ङा पा दाचा माल्‍नेवे। मेको ब्रशा, छेङछेङ दुम्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","मिनु आ कांइची नु आइक्‍च बोस क्‍येख सुन के दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","गे मेको नेल्‍ल टलेन्‍ट का क्‍येख सुन के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","गे मेको नेल्‍ल गो इ कली डांडाम कोंइशो खोदेंशो पा सेल्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २५:९; प्रस्‍थान २६:३०; प्रेरित ७:४४; हिब्रू ८:५ ");
INSERT INTO suzBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","आं बाक्‍तीके सेल्‍चा कली रिम्‍शो पा किरशो सुती श्‍येले के १० ओटा ताम्‍बु साप्‍तीके प्रोव़पाइक्‍चा माल्‍नेवे। मेको सुती श्‍येले नीलो, प्‍याजी नु लल रङम नुप्‍शो बाक्‍चा माल्‍ब। मिनु मेको वामी करूब बुटा आप्‍शा, थाम्‍पा रिम्‍शो प्रोव़स जोक्‍ब मुर आन कली प्रोव़पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","वा का आ लाइश्‍शो २८ कुबीत नु आ ब्रेम्‍शो ४ कुबीत दुम्‍चा माल्‍ब। मेको १० ओटा वा नेल्‍ल मोदेंशोन दुम्‍चा माल्‍नीम। कुबीत का ०.५ मिटर, खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","मिनु ५ ओटा वा बोइश्‍शा, का सेल्‍पाइक्‍चा माल्‍नेवे। मिनु अर्को ५ ओटा वा यो बोइश्‍शा, का सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","मिनु वा आ सुर कली नीलो रङ ङा श्‍येले के बोइक्‍तीके यो सेल्‍पाइक्‍चा माल्‍नेवे। मोपा वा निक्‍शी बोइश्‍शा का सेल्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","मिनु गे का का पा ताम्‍बु साप्‍तीके ५० ओटा सेल्‍पाइक्‍चा माल्‍नेवे। मेकोपुकी गारपाइक्‍चा कली सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","मिनु ५० ओटा सुन के ग्‍याइक्‍पाइक्‍तीके सेल्‍पतो। मोपा मेको वापुकी बोइश्‍शा, आं बाक्‍तीक ताम्‍बु आगा साप्‍तीक कान दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","मिनु आं बाक्‍तीक ताम्‍बु साप्‍चा कली क्‍यारश आ चां के ११ ओटा टुक्रा सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","का आ लाइश्‍शो ३० कुबीत नु आ ब्रेम्‍शो ४ कुबीत दुम्‍चा माल्‍ब। मिनु मेको ११ ओटा टुक्रा नेल्‍ल खाल का ङा दुम्‍चा माल्‍नीम। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","गे ५ ओटा टुक्रा बोइश्‍शा का नु ६ ओटा बोइश्‍शा, अर्को का सेल्‍पाइक्‍चा माल्‍नेवे। ६ ओटा बोइश्‍शो टुक्रा ताम्‍बु आ ङोंइती आ सुर तोक्‍तीके फेके का मुक्‍शा तोक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","मेको टुक्रा का आ सुरमी ५० ओटा बोइक्‍तीक सेल्‍पाइक्‍चा माल्‍नेवे। मिनु अर्को टुक्रा आ सुरमी यो ५० ओटा बोइक्‍तीक सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","मिनु गे कांसा के ५० ओटा ग्‍याइक्‍पाइक्‍तीके सेल्‍पतो। मेको ग्‍याइक्‍पाइक्‍तीक बोइक्‍तीकेमी वोइश्‍शा, टुक्रा निक्‍शी के का दुम्‍चा माल्‍ब। मोपा टुक्रापुकी बोइश्‍शा, ताम्‍बु साप्‍तीक का दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ताम्‍बु आ साप्‍तीके आ दी गे आइदी सम्‍म तोक्‍चा ङा पा साप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","निम्‍फा पटटी साप्‍पाइक्‍चा कली कुबीत का का आइदी सम्‍म तोक्‍चा ङा पा साप्‍पाइक्‍चा माल्‍नेवे। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ताम्‍बु आ साप्‍तीके निक्‍शी आस तारी लल रङम नुप्‍शो बोका आ कुशुल के सेल्‍पाइक्‍चा माल्‍नेवे। मिनु मेको आ तार अर्को साप्‍तीके नेल्‍ल क्‍येङा रिम्‍शो कुशुल के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","गे आं बाक्‍तीक ताम्‍बु आ एर ओंथ थारचा कली फलेक सेल्‍पाइक्‍चा माल्‍नेवे। मेको फलेकपुकी बोल्‍यो शी के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","फलेक नेल्‍ल १० कुबीत ग्‍येत्‍थ लाइश्‍शो नु कुबीत का नु आधा ब्रेम्‍शो दुम्‍चा माल्‍नीम। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","फलेक नेल्‍लेमी ग्रुक्‍तीक निक्‍‍निक्‍शी आ पुं गे एर ओंथ पा सेल्‍पतो। आं बाक्‍तीक ङा फलेक नेल्‍ल मोदेंशो पा सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","आं बाक्‍तीक कली मोदेंशो फलेक सेल्‍पाइक्‍चा माल्‍नेवे। २० ओटा फलेक दक्‍खिन गे थारचा कली सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","मिनु गे २० ओटा फलेक आन कली ४० ओटा चांदी के राप्‍पाइक्‍तीके सेल्‍पाइक्‍चा माल्‍नेवे। फलेक का कली ग्रुक्‍तीक निक्‍शी गारचा ङा पा ग्‍याइक्‍पाइक्‍तीक निक्‍शी माल्‍ब। अर्को फलेक आन कली यो गारचा ङा पा ग्रुक्‍तीक नु राप्‍पाइक्‍तीके निक्‍‍निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","मोदेंशो पा उत्तर गे यो २० ओटा फलेक बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","मिनु ४० ओटा राप्‍पाइक्‍तीक सेल्‍शा, फलेक कामी राप्‍पाइक्‍तीक निक्‍शी ग्रुक्‍पाइक्‍चा माल्‍नेवे। फलेक नेल्‍ल मोदेंशो पा सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","मिनु आं बाक्‍तीक ताम्‍बु आ नोले पटटी, पच्‍छिम गे ६ ओटा फलेक सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","नोले पटटी ङा सुर निक्‍शी कली फलेक निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","मेको सुर ङा फलेक आइक्‍था नु उइ अर्को फलेक नु गारचा ङा दुम्‍चा माल्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","नोले पटटी ङा फलेक नु सुर ङा फलेक नेल्‍ल पा ८ ओटा दुम्‍नीम। मेको फलेक नेल्‍ल आन कली १६ ओटा चांदी के राप्‍पाइक्‍तीके सेल्‍पाइक्‍चा माल्‍नेवे। फलेक का कली निक्‍शी माल्‍ब। फलेक नेल्‍ल मोदेंशो पा सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","मिनु का पटटी ङा फलेक आन कली बोल्‍यो शी के ५ ओटा लाइश्‍शो कोक्‍के, ");
INSERT INTO suzBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","अर्को पटटी कली यो ५ ओटा लाइश्‍शो कोक्‍के सेल्‍पाइक्‍चा माल्‍नेवे। मिनु पच्‍छिम गे नोले पटटी कली ५ ओटा लाइश्‍शो कोक्‍के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","मिनु फलेक ग्‍येत्‍थ आ दातेमी सुर का रे अर्को सुर सम्‍म लाइश्‍शो कोक्‍के बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","मिनु गे मेको फलेकपुकी सुनम गिल्‍पाइक्‍चा माल्‍नेवे। मेको कोक्‍के शुइक्‍तीक मुन्‍द्रा सुन के सेल्‍पाइक्‍चा माल्‍नेवे। मेको लाइश्‍शो कोक्‍केपुकी यो सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","गो इ कली डांडामी कोंइशो खोदेंशो पा आं बाक्‍तीक ताम्‍बु सेल्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २५:९ ");
INSERT INTO suzBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","मिनु गे फारतीक सेल्‍चा कली नीलो प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के वा प्रोव़पाइक्‍चा माल्‍नेवे। मेको वा करूब बुटा आप्‍शा थाम्‍पा रिम्‍शो प्रोव़स जोक्‍ब मुर आन कली प्रोव़पाइक्‍चा माल्‍नेवे। २इतिहास ३:१४ ");
INSERT INTO suzBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","मेको फारतीके बोल्‍यो शी के सेल्‍शो सुनम गिल्‍शो सुन के हेक्‍तीक पाइश्‍शो नु चांदी के राप्‍पाइक्‍तीक पाइश्‍शो ४ ओटा थामम क्‍युक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","मिनु मेको फारतीके हेक्‍तीकेम हेक्‍पाइक्‍चा माल्‍नेवे। मिनु गे मेको आं अरेशो लोव़ आगाम वोइश्‍शो सन्‍दोस मेको फारतीके आगा गे वोइक्‍पाइक्‍चा माल्‍नेवे। मोपा मेको फारतीके चोव़खो नु नेल्‍ल क्‍येङा चोव़खो बाक्‍तीक कली फारब दुम्‍ब। मत्ती २७:५१; हिब्रू ९:३; प्रस्‍थान २६:६,११ ");
INSERT INTO suzBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","मिनु गे मेको सुम्‍तीक अरेशो लोव़ आगाम वोइश्‍शो सन्‍दोस तारी वोइश्‍शा, मेको फारतीक आ आगा गे नेल्‍ल क्‍येङा चोव़खो बाक्‍तीकेमी वोइक्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २५:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","कोंइतीक शोब्‍ले वोइक्‍तीक टेबल चोव़खो बाक्‍तीके उत्तर गे वोइक्‍पाइक्‍चा माल्‍नेवे। बत्ती दातीक चहिं दक्‍खिन गे वोइक्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २५:२३-३०; प्रस्‍थान ४०:४२ ");
INSERT INTO suzBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","मिनु ताम्‍बु ओव़तीक कली नीलो प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा, बुटा आप्‍शा ठेयब फारतीक सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","मेको फारतीके हेक्‍चा कली ५ ओटा बोल्‍यो शी के थाम सेल्‍पाइक्‍चा माल्‍नेवे। मेको थाम सुनम गिल्‍पाइक्‍चा माल्‍नेवे। मेको थामम सुन के हेक्‍तीके यो सेल्‍पाइक्‍चा माल्‍नेवे। मेको थाम राप्‍पाइक्‍तीके ५ ओटा कांसा के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","मिनु बोल्‍यो शी के चढ़ेतीक का सेल्‍चा माल्‍नेवे। मेको ५ कुबीत लाइश्‍शो नु ५ कुबीत ब्रेम्‍शो दुम्‍चा माल्‍ब। ४ पाटे नु कुबीत सां ग्‍येत्‍थ लाइश्‍शो दुम्‍चा माल्‍ब। कुबीत का ०.५ मिटर देंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","आ ४ सुरमी ४ ओटा ग्रोव़ ग्रूपाइक्‍चा माल्‍नेवे। ग्रोव़ नु चढ़ेतीक सेल्‍चा कली फलेक का केन दुम्‍चा माल्‍ब। मेको नेल्‍ल कांसाम गिल्‍पाइक्‍चा माल्‍नेवे। लेवी १६:१८; १राजा १:५; भजन संग्रह ११८:२७ ");
INSERT INTO suzBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","चढ़ेतीके कली माल्‍शो मारेइ मारेइ कांसा के सेल्‍पाइक्‍चा माल्‍नेवे। पुलु वोइक्‍तीक बोसपुकी, पुलु ताप्‍तीकपुकी, ब्रुइक्‍तीक बोसपुकी, श्‍ये ग्रुंइतीक कांटापुकी नु मी कोइला कुर पतीकपुकी सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","मिनु गे मी तिक्‍तीक कांसा के जाली सेल्‍पाइक्‍चा माल्‍नेवे। मिनु जाली आ ४ सुरमी ४ ओटा मुन्‍द्रा सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","मेको जाली चढ़ेतीक उइ गे नु इर गे आ दातेम वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","मिनु चढ़ेतीक कली यो बोल्‍यो शी के कांसाम गिल्‍शो कुरतीक कोक्‍के निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","मेको चढ़ेतीक आ निम्‍फा पटटी ङा मुन्‍द्रामी कोक्‍के शुइश्‍शा, कुरने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","मेको चढ़ेतीक फलेक के सेल्‍पाइक्‍चा माल्‍नेवे। पुं नु सुम्‍तीके मपाइश्‍शो सन्‍दोस खोदेंशो पा सेल्‍पाइक्‍चा माल्‍नेवे। डांडामी इ कली कोंइशो खोदेंशो पा सेल्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २६:३०; ");
INSERT INTO suzBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","मिनु ताम्‍बु आ लाङगा थरपु हिरचा कली रिम्‍शो पा किरशो सुती श्‍येले के फारतीके प्रोव़पाइक्‍चा माल्‍नेवे। मेको फारतीके दक्‍खिन गे सहे का कुबीत लाइश्‍शो दुम्‍चा माल्‍ब। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","मेको फारतीक ग्‍याइक्‍पाइक्‍चा कली खाल का ङा थाम, खाल का ङा कांसा के राप्‍पाइक्‍तीके, मुन्‍द्रापुकी नु कोक्‍केपुकी चहिं चांदी के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","मिनु मोदेंशो पा उत्तर गे यो सहे का कुबीत लाइश्‍शो फारतीक प्रोव़पाइक्‍चा माल्‍नेवे। मेको कली २० ओटा थाम, २० ओटा कांसा के राप्‍पाइक्‍तीके, मेको मुन्‍द्रापुकी नु कोक्‍केपुकी चहिं चांदी के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","लाङगा ङा पच्‍छिम गे ब्रेम्‍शो कली ५० कुबीत लाइश्‍शो फारतीक माल्‍ब। आ थाम नु आ राप्‍पाइक्‍तीक १०, १० ओटा दुम्‍चा माल्‍नीम। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","लाङगा आ पूर्ब, नां दाप्‍तीके गे फारचा कली यो ५० कुबीत ब्रेम्‍शो दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","मिनु ओव़तीक ङा पटटी का कली १५ कुबीत ङा फारतीक दुम्‍चा माल्‍ब। थाम नु आ राप्‍पाइक्‍तीके सां सां दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","मिनु अर्को पटटी यो मोदेंशो पा १५ कुबीत ङा फारतीक, थाम नु राप्‍पाइक्‍तीके सां सां दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","मिनु लाङगा ओव़तीके कली २० कुबीत ङा नीलो, प्‍याजी, श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो फारतीक माल्‍ब। मेको फारतीक कली लूजेम बुटा आप्‍पाइक्‍चा माल्‍नेवे। ओव़तीके कली थाम नु राप्‍पाइक्‍तीके ४, ४ ओटा दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","लाङगा एर ओंथ ङा थाम नेल्‍ल चांदीमी गिल्‍शो कोक्‍केमी ग्‍याइक्‍पाइश्‍शो दुम्‍चा माल्‍नीम। मुन्‍द्रा चांदी के नु आन राप्‍पाइक्‍तीक कांसा के दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","मेको लाङगा आ पित्‍थ लाइश्‍शो सहे का कुबीत, आ ब्रेम्‍शो ५० कुबीत नु आ फारतीके ग्‍येत्‍थ ५ कुबीत दुम्‍चा माल्‍ब। मिनु फारतीक वा नेल्‍ल रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के दुम्‍चा माल्‍ब। थाम आन राप्‍पाइक्‍तीके कांसा के दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","मिनु ताम्‍बु ङा नाक्‍त किंत किंत गेय पचा कली माल्‍शो मारेइ मारेइ कांसा के दुम्‍चा माल्‍नीम। किलापुकी नु लाङगा ङा किला नेल्‍ल यो कांसा के दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","मिनु गे इस्राएली आन कली ‘गे नेल्‍ल क्‍येङा रिम्‍शो तेल रवा आ फल के ख्राक्‍शो तेल चाक्‍कीन। मेको बत्ती गेना हना यो ब्रशा बाक्‍ल’ दे माइक्‍मी। लेवी २४:२-४ ");
INSERT INTO suzBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","मिनु ग्रुम्‍तीक ताम्‍बु आगामी, कबल ङा सन्‍दोस बाक्‍शो नेल्‍ल क्‍येङा चोव़खो कोठा फारतीक आ ङोंइती हारून नु आ तौपुकीमी नाक्‍दो रे सुनी सम्‍म मेको बत्ती दातीक परमप्रभु यावे आ ङोंइती ब्रशा बाक्‍ल, दे ठीक सेल्‍चा माल्‍नीम। मेको इस्राएली आन चच युइ आन कली गेना हना यो पतीके लीचा माल्‍ब। मेको गेना हना यो पचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","मिनु इस्राएली आन दाते रे योव़शा, इ लोक्‍ब हारून नु आ तौपुकी इ ङोंइती राप्‍पाइक्‍चा माल्‍नेवे। मारदे हना हारून नु आ तौ नादाब, अबीहु, एलाजर नु इथामार आं कली चढ़ेब दुम्‍चा माल्‍नीमी। १इतिहास २३:१३; प्रस्‍थान ६:२३ ");
INSERT INTO suzBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","मिनु गे इ लोक्‍ब हारून कली आं गेय पची ना ला फेक्‍चा कली फेक्‍तीक वा फेरपाइक्‍चा माल्‍नेवे। मेको हारून कली ग्‍योम्‍शा दारपाइक्‍चा कली बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","मिनु सु सुमी फेरस जोक्‍नीमी, मेको नु लोव़ पावो। मारदे हना गो मेको आन कली जोक्‍ब नु तुइक्‍ब सोक्‍तीम प्रिंताक्‍ङमी। मेकोपुकीमी हारूनमी आं कली चढ़ेतीक गेय पचा कली वासी फेरचा माल्‍नीम। प्रस्‍थान ३१:५ ");
INSERT INTO suzBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","मेकोपुकीमी मार वासी फेरचा माल्‍नीम देंशा हना, कुचु तार वोइक्‍तीके, निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला, आ तार फेक्‍तीके नु आगा फेक्‍तीक वा फेरचा माल्‍नीम। पियाम गुप्‍‍तीक नु किप्‍शुर यो सेल्‍चा माल्‍नीम। मेको आं कली गेय पची ना फेक्‍तीक बाक्‍ब। इ लोक्‍ब हारून नु आ तौपुकीमी आं कली गेय पामेनु, मेको वा फेक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","फेरबपुकीमी सुन, नीलो, प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍चा माल्‍नीमी। प्रस्‍थान २६:१ ");
INSERT INTO suzBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","कुचु तार वोइक्‍तीके सुन के, नीलो, प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो नु बुटा आप्‍शो वा के सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","मेको आ बला सुम्‍तीके निक्‍शी निम्‍फा पटटी बोइश्‍शो दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","मिनु आ पाइक्‍तीके मेको कुचु तार वोइक्‍तीके का रेन दुम्‍चा माल्‍ब। मिनु खाल का ङा रिम्‍शो गेयम सेल्‍शो दुम्‍चा माल्‍ब। मेको पाइक्‍तीके सुन, नीलो, प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","मिनु गे ओनीक्‍स हीरा निक्‍शी चाक्‍शा, इस्राएल आ १२ जना तौ आन नें मेको आस तारी मुशा ब्रेक्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान २५:७ ");
INSERT INTO suzBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","गे आन जरमेशो खोदेंशो पा हीरा का तारी ६ जना आन नें नु अर्को हीरा तारी ६ जना आन नें मुशा ब्रेक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","छाप सेल्‍बपुकीमी दोदेंशो पा मुशा छाप सेल्‍नीमी, मोदेंशो पा मुशा इस्राएल आ तौ आन नें ब्रेक्‍पाइक्‍चा माल्‍नेवे। मिनु मेको हीरा निक्‍शी सुनमी क्‍येप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","मेको कुचु तार वोइक्‍तीक आ बला ङा टुक्रा तारी क्‍येप्‍शा फेरपाइक्‍चा माल्‍नेवे। मिनु मेको हीरा कोव़शा इस्राएली इन कली मिम्‍नुङ, दे कोंइतीक बाक्‍ब। हारूनम आं ङोंइती मेको आन नें बलाम कुरानु, गो मेको आन कली मिम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","मिनु हीरा वोइक्‍चा कली गे सुन के क्‍येप्‍तीक सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","मिनु गे क्‍येख सुन के डोरी खोदेंशो पा सिक्री निक्‍शी चेम्‍पाइश्‍शा, हीरा क्‍येप्‍पाइश्‍शोमी बोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","गे निसाफ पतीक झोला सेल्‍पाइक्‍चा माल्‍नेवे। मेको कुचु तार वोइक्‍तीके खोदेंशो पा, सेल्‍पाइक्‍चा माल्‍नेवे। सुन, नीलो, प्‍याजी, लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","मेको खेयप का मुक्‍शोनु, स्‍पान का लाइश्‍शो नु स्‍पान का ब्रेम्‍शो ४ पाटे दुम्‍चा माल्‍ब। स्‍पान का २३ सेन्‍ती मिटर खोदेंशो बाक्‍ब। बित्‍ता खोदेंशो बाक्‍ब कों? ");
INSERT INTO suzBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","मिनु ४ लस्‍कर हीरा सुनम का का पा क्‍येप्‍पाइक्‍चा माल्‍नेवे। ङोंइती ङा लस्‍कर लल मानीक माइश्‍शो हीरा, हाव पुश्‍पराज माइश्‍शो हीरा नु गिगी बेरूज माइश्‍शो हीरा वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","मेको आ नोले ङा लस्‍कर लल फिरोजा माइश्‍शो हीरा, बुश नीर माइश्‍शो हीरा नु बुश नु नीलो पन्‍ना माइश्‍शो हीरा वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","मेको आ नोले ङा लस्‍कर गिगी नु नीलो रङ ब्‍वाइश्‍शो रिम्‍शो टल्‍केशो नीलमनी माइश्‍शो हीरा, गिगी हाकीक माइश्‍शो हीरा नु प्‍याजी रङ ङा कटेला माइश्‍शो हीरा वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","मिनु नेल्‍ल क्‍येङा नोले ङा लस्‍कर पीतमनी माइश्‍शो हीरा, लल रङ ङा ओनीक्‍स नु नीलो बिलौरा माइश्‍शो हीरा वोइक्‍पाइक्‍चा माल्‍नेवे। मोपा हीरा नेल्‍ल आन कली सुनम क्‍येप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","मेको हीरा १२ ओटा दुम्‍चा माल्‍नीम। मिनु इस्राएल आ तौ आन नें का का पा मेको आन तार छाप थोक्‍शो खोदेंशो पा मुशा ब्रेक्‍पाइक्‍चा माल्‍नेवे। हीरा का आ तारी थर का आ नें दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","गे मेको निसाफ पतीक झोला कली क्‍येख सुन के डोरी किरशो खोदेंशो पा सिक्री निक्‍शी चेम्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","मिनु गे मेको निसाफ पतीक झोला कली सुन के मुन्‍द्रा निक्‍शी चेम्‍पाइक्‍चा माल्‍नेवे। मिनु मेको मुन्‍द्रा निसाफ पतीक झोला आ सुर निक्‍शीमी वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","मेको सुन के सिक्री निक्‍शी निसाफ पतीक झोला आ सुरम वोइश्‍शो मुन्‍द्रा निक्‍शीमी लिक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","मेको सिक्री चढ़ेब आ कुचु तार वोइश्‍शो वा आ बला ङा हीरा क्‍येप्‍शो सुनम हेक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","मिनु गे लेंशा सुन के मुन्‍द्रा निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। मेको निक्‍शी निसाफ पतीक ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला आ उइ आगा गे पाइक्‍चा माल्‍नेवे। मोपा कुचु तार वोइक्‍तीक वा आ तार बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","मिनु गे लेंशा सुन के मुन्‍द्रा निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। मेको कुचु तार वोइक्‍तीक आ बाला सुम्‍तीके उइ ङा सुरम वोइक्‍चा माल्‍नेवे। मिनु दारपाइश्‍शो पाइक्‍तीके आ तारी क्‍येप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","मिनु मेको निसाफ पतीक ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला आ मुन्‍द्रामी नीलो डोरीम लिक्‍शा, कुचु तार वोइक्‍तीक वामी पाइक्‍पाइक्‍चा माल्‍नेवे। मोपा मेको निसाफ पतीक झोला दारपाइश्‍शो पाइक्‍तीक तार बाक्‍शा कुचु वोइक्‍तीक वा रे एर ओंथ मयाक्‍सीब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","मिनु मोदेंशो पा हारून परमप्रभु यावे आ बाक्‍तीक ओव़मेनु, इस्राएल आ तौ आन नें ब्रेक्‍शो निसाफ पतीक झोला आ कुचु तारी कुरचा माल्‍ब। मेको परमप्रभु यावेमी गेना हना यो मिम्‍चा कली बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","मेको निसाफ पतीके झोलामी मेको ऊरीम नु थुम्‍मीम निक्‍शी कुर पचा माल्‍नेवे। हारून परमप्रभु यावे आ ङोंइती ल‍मेनु, इस्राएली आन निसाफ पतीके गेना हना यो आ कुचु तारी बाक्‍चा माल्‍ब। लेवी ८:८; गन्‍ती २७:२१; ब्‍यवस्‍था ३३:८ ");
INSERT INTO suzBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","मिनु मेको कुचु तार वोइक्‍तीके आगा फेक्‍तीके नेल्‍ल नीलो प्‍याजी रङ ङा वा के फेरपाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","मिनु पिया ख्रीतीक पोव़ला वोइक्‍पाइक्‍चा माल्‍नेवे। मेको एर ओंथ मगाक्‍चा ङा पा आ सुर थम बोल्‍यो पा प्रोव़पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","मेको फेक्‍तीके आ उइ ङा सुर एर ओंथ गे नीलो, लल नु प्‍याजी रङ ङा श्‍येले के सेल्‍शो दारीम सेल्‍पाइक्‍चा माल्‍नेवे। मेको आन दातेम सुन के आइक्‍च आइक्‍च किङगो क्‍युक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","किङगो का, दारीम का, किङगो का दारीम का पा मेको फेक्‍तीक नेल्‍ल आ एर ओंथ क्‍युक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","मिनु हारूनमी मेको वा गेय पची ना फेक्‍चा माल्‍ब। मोपा परमप्रभु यावे आ नेल्‍ल क्‍येङा चोव़खो बाक्‍तीके ओव़मेनु, किङगो आ रेयके नेंपाइक्‍चा माल्‍ब। हारून मबेक्‍ल, दे मोदेंशो दुम्‍चा माल्‍ब। प्रस्‍थान ३०:२१; लेवी १६:२,१३ ");
INSERT INTO suzBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","गे कुप्‍फीम पांइ‍तीके क्‍येख सुन के फू खोदेंशो पा चेम्‍पाइक्‍चा माल्‍नेवे। मेकेर छाप थोक्‍शो खोदेंशो पा ‘परमप्रभु यावे कली ला’ दे मुशा ब्रेक्‍पाइक्‍चा माल्‍नेवे। जकरिया १४:२०; प्रस्‍थान ३९:३० ");
INSERT INTO suzBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","पियाम गुक्‍तीकेम आ ङोंइती गे वोइक्‍चा कली नीलो प्‍याजी डोरीम फ्रेंपाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","मोपा मेको हारून आ कुप्‍फीम बाक्‍चा माल्‍ब। आ कुप्‍फीम पाइश्‍शा, इस्राएली आन मरिम्‍शो पशो कुरब। मिनु परमप्रभु कली चढ़ेशो रिम्‍शो दुम्‍नीम। परमप्रभु यावेमी आन चढ़ेशो ब्रवल, दे गेना हना यो आ कुप्‍फीम बाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","नेल्‍ल क्‍येङा आगा फेक्‍तीके रिम्‍शो पा किरशो सुती श्‍येले के बुटा आप्‍शा प्रोव़शो वा के सेल्‍पाइक्‍चा माल्‍नेवे। पियाम गुक्‍तीके रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍पाइक्‍चा माल्‍नेवे। किप्‍तीके रङ रङ ङा सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","गे हारून आ तौ आन कली फेक्‍तीके किप्‍तीक नु आइक्‍च गुक्‍तीके सेल्‍पाइक्‍चा माल्‍नेवे। मेको हारून आ तौ आन कली ग्‍योम्‍शा दारपाइक्‍चा कली बाक्‍नीम। प्रस्‍थान २८:२ ");
INSERT INTO suzBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","गे मेको इ लोक्‍ब हारून नु आ तौ आन कली फेक्‍तीमी। मिनु तेल लुक्‍शा, आं कली ला गेय पचा कली योव़शा वोइक्‍मी। मोपा आं कली चढ़ेब दुम्‍नीम। प्रस्‍थान २९:९, २९-३६; प्रस्‍थान २९:२४; लेवी ८:१२,२२-३१ ");
INSERT INTO suzBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","गे मेको आन शिश्रा रां सुम्‍पाइक्‍चा कली सुती वा के कटटु फेरपाइक्‍चा माल्‍नेवे। मेको कम्‍बर रे पोक्‍च सम्‍म दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","मिनु हारून नु आ तौपुकी ग्रुम्‍तीक ताम्‍बु ओव़शा, चढ़ेतीक आ नेक्‍था लमानु, मेको वा फेक्‍सीशो बाक्‍चा माल्‍नीम। मफेक्‍साक्‍म हना, दोस तशा बेक्‍नीम। हारून नु आ चच युइ आन पाला नेल्‍लेमी गेना हना यो मोदेंशो पचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","गे हारून नु आ तौपुकी आं कली चढ़ेब सेल्‍‍चा कली मार पचा माल्‍नेवे देंशा हना, बोहोर का, मारेइ मदुम्‍शो थम रिम्‍शो सांड निक्‍शी चाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","मिनु रिम्‍शो चेरब फस के बोरब ओख्‍ती मसुप्‍शो शोब्‍ले, तेल ब्‍वाइश्‍शो जिज शोब्‍ले नु तेल ख्रेक्‍शो बोरब ओख्‍ती मसुप्‍शो शोब्‍ले सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","मेको शोब्‍ले नेल्‍ल तोव़लो कामी कुर पा, बोहोर नु सांड चाक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","मिनु हारून नु आ तौ आन कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी चाक्‍चा नम। मिनु गे मेको आन कली चिक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","वासी चाक्‍शा, हारून कली आगा फेक्‍तीक वा, मेको आ तार ङा फेक्‍तीके वा फेक्‍पाइश्‍शा, कुचु तार वोइक्‍तीक फेक्‍शा निसाफ पतीके ऊरीम नु थुम्‍मीम बाक्‍शो झोला रेल्‍चा माल्‍नेवे। मिनु मेको तारी बुटा आप्‍शो किप्‍तीके किप्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","आ पिया तारी गुक्‍तीके गुप्‍शा, मेको तारी ‘परमप्रभु यावे कली ला’ दे ब्रेक्‍शो कुप्‍फीम पांइतीके पांइपाइक्‍चा माल्‍नेवे। प्रस्‍थान २८:३६; प्रस्‍थान ३९:३० ");
INSERT INTO suzBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","मिनु लुक्‍तीक तेल लाइश्‍शा आ पियामी तेल लुक्‍तो। प्रस्‍थान ३०:२५ ");
INSERT INTO suzBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","मिनु हारून आ तौ आन कली यो चाक्‍शा, वा फेक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","मिनु आ तौ आन कली किप्‍तीके किप्‍चा माल्‍नेवे। मिनु आन पियाम गुक्‍तीके गुप्‍चा माल्‍नेवे। मिनु मेकोपुकी गेना हना यो आं कली चढ़ेब गेय पाइब दुम्‍नीम। मोपा हारून नु आ तौ आन कली आं कली चढ़ेब सेल्‍मी। प्रस्‍थान २८:४१ ");
INSERT INTO suzBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","मिनु मेको बोहोर ग्रुम्‍तीक ताम्‍बु आ ङोंइती चाक्‍शा, हारून नु आ तौ आन कली आन गुइ मेको बोहोर आ पिया तारी वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","मिनु मेको बोहोर कली परमप्रभु यावे आ ङोंइती, ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम राप्‍पाइश्‍शा क्‍योरचा माल्‍नेवे। लेवी १:४ ");
INSERT INTO suzBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","मिनु बोहोर आ हुश इच्‍का खोइ लाइश्‍शा इ ब्रेप्‍चोमी चढ़ेतीक आ ग्रोव़पुकीमी ख्रेक्‍चा माल्‍नेवे। मिनु लीशो हुश नेल्‍ल चढ़ेतीके आ पुंमी मोइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","मिनु गे क्‍यी गिल्‍शो बोंसो नेल्‍ल, आइदी तारी ङा जाला, आ चिच निम्‍फा नु आ तार ङा बोंसो नेल्‍ल चढ़ेतीकेम चोचा माल्‍नेवे। लेवी ३:१६-१७ ");
INSERT INTO suzBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","आ श्‍ये, आ कुशुल नु आ गोबर चहिं ताम्‍बु आ लाङगा रे ग्रुंइशा, चोचा माल्‍नेवे। मेको पाप पशो आ पर्बम चढ़ेशो बाक्‍ब। लेवी ४:११-१२ ");
INSERT INTO suzBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","मिनु मेको सांड का चाक्‍शा, हारून नु आ तौ आन गुइ मेको आ पिया तार वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","मेको कली क्‍योरशा, मेको आ हुश चढ़ेतीक नेल्‍ल ब्रुइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","मिनु मेको सांड आ श्‍ये कली टुक्रा टुक्रा पा चेक्‍शा, पिया नु वोइक्‍चा माल्‍नेवे। मिनु मेको आ क्‍यी नु आ खोइली नेल्‍ल मुरशा, मेको श्‍ये नु पियामी वोइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","मोदेंशो पा सांड नेल्‍ल चढ़ेतीक तारी चोचा माल्‍नेवे। मेको परमप्रभु यावे कली चोशा चढ़ेतीक बाक्‍ब। परमप्रभु यावे कली ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। १सामुएल २:२८ ");
INSERT INTO suzBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","मिनु मेको लीशो सांड चाक्‍चा माल्‍नेवे। मिनु हारून नु आ तौ आन गुइ मेको सांड आ पिया तार वोइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","मिनु मेको सांड क्‍योरशा, आ हुशेम हारून आ ग्‍युरा नोफा ङा लोव़तीम नु आ तौ आन ग्‍युरा नोफा ङा लोव़तीम ख्रेक्‍चा माल्‍नेवे। मिनु मेको आन ग्‍युरा गुइ ङा ठेयब ब्रेप्‍चोम नु आन ग्‍युरा खोइली ङा ठेयब ब्रेप्‍चोम ख्रेक्‍चा माल्‍नेवे। मिनु लीशो हुश चढ़ेतीक तार नु आ एर ओंथ ब्रुइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","मिनु चढ़ेतीकेम बाक्‍शो हुश नु लुक्‍तीक तेल लाइश्‍शा, हारून नु आ वा नु आ तौ आन वा तारी ब्रुइक्‍चा माल्‍नेवे। मोपा हारून नु आ वा, आ तौ नु मेको आन वा नेल्‍ल परमप्रभु यावे कली ला गेय पचा कली दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","मिनु सांड आ बोंसो, आ बोंसो पाइश्‍शो मीलु, आ क्‍यी गिल्‍शो बोंसो, आइदी तार ङा जाला, आ चिच निम्‍फा, मेको तार ङा बोंसो नु आ ग्‍युरा फिला लाइक्‍चा माल्‍नेवे। मारदे हना मेको चढ़ेब सेल्‍तीके सांड बाक्‍ब। लेवी ३:३-४ ");
INSERT INTO suzBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","मिनु परमप्रभु यावे आ ङोंइती वोइश्‍शो बोरब ओख्‍ती मसुप्‍शो शोब्‍ले, तोव़लो ङा शोब्‍ले का, तेलम ब्‍वाइश्‍शो जिज शोब्‍ले का नु तेल ख्रेक्‍शो शोब्‍ले का लाइश्‍शा, ");
INSERT INTO suzBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","मेको नेल्‍ल हारून नु आ तौ आन दाइश्‍शो गुइ गुइमी गेचा माल्‍नेवे। मेको परमप्रभु यावे आ ङोंइती ग्‍येत्‍थ लुक्‍च पा हिम्‍शा चढ़ेतीक चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","मिनु गे मेको आन गुइ रे ताक्‍शा, परमप्रभु यावे आ ङोंइती ब्रोव़शो रिना पाइब चढ़ेतीके तारी चोशा चढ़ेचा माल्‍नेवे। मेको परमप्रभु यावे कली मीम चोशा चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","मिनु हारून कली चढ़ेब सेल्‍तीके सांड आ कुथ्रु चाक्‍शा, परमप्रभु यावे आ ङोंइती ग्‍येत्‍थ लुक्‍च पा हिम्‍शा चढ़ेचा माल्‍नेवे। मेको चहिं इ के दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","मिनु मेको हारून नु आ तौ आन कली चढ़ेब सेल्‍शो सांड आ ग्‍येत्‍थ लुक्‍च पा हिम्‍शा चढ़ेशो कुथ्रु नु क्‍युक्‍शा चढ़ेशो फिला मेको आन कली गेचा माल्‍नीम। गन्‍ती १८:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","मारदे हना इस्राएलीपुकीमी मेको हारून नु आ तौ आन कली गेना हना यो गेचा माल्‍शो भाग बाक्‍ब। मेको गेचा माल्‍शो चढ़ेतीके बाक्‍ब। इस्राएलीपुकीमी आन परमप्रभु यावे नु दुशा बाक्‍चा आ पर्बम चढ़ेतीके रे गेचा माल्‍शो मेकोन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","हारून आ चढ़ेची ना फेक्‍तीक मेको आ नोले चढ़ेब दुम्‍ब आ तौ के दुम्‍ब। मेको वा फेक्‍शा, तेल लुक्‍शा, चढ़ेब दुम्‍ब। प्रस्‍थान २८:४०-४१ ");
INSERT INTO suzBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","हारून आ पा ङा चढ़ेब दुम्‍ब आ तौ ग्रुम्‍तीक ताम्‍बु आगा परमप्रभु यावे आ बाक्‍तीकेम गेय पथ ओव़मेनु, ७ नाक्‍त सम्‍म मेको वा फेक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","मिनु मेको चढ़ेब सेल्‍तीके सांड आ श्‍ये ग्रुम्‍तीक ताम्‍बु आ लाङगाम क्‍येचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","मिनु नोले हारून नु आ तौपुकीमी मेको सांड आ श्‍ये नु तोव़लो ङा शोब्‍ले ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी बाक्‍शा जचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","मेको ङोंइती आन पाप क्‍याम्‍चा कली चढ़ेशो थोव़क आंम कली परमप्रभु यावे कली ला गेय पाइब दुम्‍चा, दे जचा माल्‍नीम। तन्‍न अरुमी मेको जचा मदुम्‍नीम। मारदे हना मेको परमप्रभु यावे के बाक्‍ब। लेवी १०:१७ ");
INSERT INTO suzBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","चढ़ेब सेल्‍ची ना ङा श्‍ये नु शोब्‍ले सुनी सम्‍म हेंत हना, मेको हेंशो नेल्‍ल चोचा माल्‍नेवे। मेको मजचा मब्‍वचा। मारदे हना मेको चढ़ेब सेल्‍ची ना ङा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","गोम इ कली अरेशो खोदेंशो पा हारून नु आ तौ आन कली पाइक्‍मी। मेको आन कली ७ नाक्‍त सम्‍म मोदेंशो चढ़ेब सेल्‍तीक गेय पचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","मिनु गे नाक्‍त किंत किंत बोहोर का पाप पशो आ पर्बम चढ़ेचा माल्‍नेवे। मेको पाप क्‍याम्‍तीक गेय पचा कली चढ़ेशो बाक्‍ब। मिनु चढ़ेतीक परमप्रभु के दुम्‍त, दे हुश ब्रुइश्‍शा, तेल लुक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","गे ७ नाक्‍त सम्‍म चढ़ेतीकेमी मो पशा पाप क्‍याम्‍तीक गेय पचा माल्‍नेवे। मिनु मेको चढ़ेतीके परमप्रभु कली ला दुम्‍ब। मेको चढ़ेतीक कली मार मारम थीनीमी, मेको यो परमप्रभु केन दुम्‍नीम। प्रस्‍थान ३०:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","मिनु गे चढ़ेतीकेमी मार चढ़ेचा माल्‍नेवे देंशा हना, नाक्‍त किंत किंत बर्स का दुम्‍शो सांड निक्‍शी चढ़ेचा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","मेको का सुनी का चहिं नाक्‍दो चढ़ेचा माल्‍नेवे। २राजा १६:१५; भजन संग्रह १४१:२ ");
INSERT INTO suzBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ङोंइती ङा सांड नु रिम्‍शो चेरब फस १० भाग ङा भाग का, ४ भाग ङा हिन भाग का रिम्‍शो तेल मेको नु बुल्‍शा, ४ भाग ङा हिन अङगुर शांबु भाग का तूचा थोव़क चढ़ेचा माल्‍नेवे। चेरब फस एफाह का २२ लिटर खोदेंशो बाक्‍ब। मेको के १० भाग का २ लिटर खोदेंशो बाक्‍ब। हिन का ४ लिटर, ४ भाग ङा भाग का लिटर का बाक्‍ब।प्रस्‍थान २७:२० ");
INSERT INTO suzBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","मिनु अर्को सांड नाक्‍दो चढ़ेचा माल्‍नेवे। मिनु मेको नु अन्‍न चढ़ेतीक नु आ तूचा थोव़क चढ़ेतीक सुनी ङा खोदेंशो पा नाक्‍दो यो चढ़ेचा माल्‍नेवे। परमप्रभु यावे कली ब्रोव़शो रिना पाइब मीम चोशा चढ़ेतीके मेकोन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","गे इ चच युइ आन पाला नेल्‍लेमी गेना हना यो परमप्रभु यावे आ ङोंइती ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ नेक्‍था चोशा चढ़ेतीक चढ़ेचा माल्‍नीम। मेकेर गो गे नु लोव़ पचा कली ग्रुम्‍नन। प्रस्‍थान ३३:७; प्रस्‍थान २५:२ ");
INSERT INTO suzBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","मिनु गो इस्राएली आन कली मेकेर ग्रुम्‍नुङ। मिनु मेको ताम्‍बु आं छेङछेङम ब्रीशा आं के दुम्‍ब। प्रस्‍थान ३३:१०; प्रस्‍थान ४०:३४ ");
INSERT INTO suzBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","गो ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आं के सेल्‍नुङ। हारून नु आ तौ आन कली यो आं कली चढ़ेब दुम्‍शा, आं गेय पपाइक्‍चा कली आं के सेल्‍नुङमी। ");
INSERT INTO suzBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","गो इस्राएली आन दातेमी बाक्‍नुङ। मिनु मेको आन परमप्रभु दुम्‍ती। प्रस्‍थान २५:८; जकरिया २:१४; लेवी २६:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","गो मेको आन दातेमी बाक्‍चा कली मेको आन कली इजीप्‍त रे ग्रुंइब मेको परमप्रभु यावे, आन परमप्रभु नङ। गो मेको आन परमप्रभु यावे नङ, दे मेकोपुकीम तुइक्‍चा माल्‍नीम। प्रस्‍थान २०:२ ");
INSERT INTO suzBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","मिनु गे धूप चोचा कली बोल्‍यो शी के चढ़ेतीक का सेल्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","मेको आ पित्‍थ लाइश्‍शो कुबीत का नु आ ब्रेम्‍शो कुबीत का ङा ४ पाटे दुम्‍चा माल्‍ब। मिनु आ ग्‍येत्‍थ लाइश्‍शो कुबीत निक्‍शी दुम्‍चा माल्‍ब। मेको ग्रोव़ पाइश्‍शो दुम्‍चा माल्‍ब। ग्रोव़ नेल्‍ल मख्रोंइसीशो शी का केन दुम्‍चा माल्‍नीम। कुबीत का ०.५ मिटर बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","मेको नेल्‍ल क्‍येख सुनमी गिल्‍चा माल्‍ब। मिनु मेको कली सिरपेच के खोदेंशो पा सुन के सुर सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","मिनु सुन के मुन्‍द्रा निक्‍‍निक्‍शी सेल्‍पाइक्‍चा माल्‍नेवे। मेको मुन्‍द्रा धूप चोतीके आ सिरपेच खोदेंशो सुर आ दी निम्‍फा पटटी गे क्‍येप्‍पाइक्‍चा माल्‍नेवे। मेको कुरतीक कोक्‍के आन कली शुइक्‍तीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","मिनु मेको कुरचा कली बोल्‍यो शी के कोक्‍के निक्‍शी सेल्‍शा, सुनमी गिल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","मिनु मेको परमप्रभु यावे आ अरेशो लोव़ वोइश्‍शो कबल पशो सन्‍दोस नु सुम्‍तीके फारतीक वा आ ङोंइती वोइक्‍चा माल्‍नेवे। गो मेकेर इ कली ग्रुम्‍नुङ। प्रस्‍थान २५:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","मिनु हारूनमी सुनी कुस कुस बत्ती दाचा कली सादानु, ब्रोव़शो रिना पाइब धूप चोचा माल्‍ब। भजन संग्रह १४१:२ ");
INSERT INTO suzBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","नाक्‍दो हारूनमी बत्ती दाङानु यो धूप चोचा माल्‍ब। मेको परमप्रभु यावे आ ङोंइती धूप चोतीक मेको आन चच युइ आन पालामी गेना हना यो पचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","मेको धूप चोतीकेमी अरु धूप चोचा मदुम्‍ब। चोशा चढ़ेतीके नु जचा थोव़क चढ़ेतीके मेकेर चढ़ेचा मदुम्‍ब। तूचा थोव़क चढ़ेतीके यो मेकेर मोइक्‍चा मदुम्‍ब। लेवी १०:१-२ ");
INSERT INTO suzBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","बर्सम खेयप का हारूनमी चढ़ेतीक आ ग्रोव़म हुश ख्रेक्‍शा पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मेको हुश पाप आ पर्बम चढ़ेशो बस्‍तु आ हुश बाक्‍चा माल्‍ब। मेको गेना हना यो बर्समी खेयप का इन चच युइ आन पाला सम्‍म मेको पाप क्‍याम्‍तीक गेय चढ़ेतीके आ हुशेमी पचा माल्‍ब। मेको परमप्रभु यावे आ ङोंइती नेल्‍ल क्‍येङा चोव़खो सेल्‍तीके बाक्‍ब” दे परमप्रभु यावेमी मोसा कली दें‍त। लेवी १६:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“गे इस्राएली वोंइश मुर आन कली हिक्‍गीनु, मेको आन कली मुर बेक्‍तीक रोइ मपामेक्‍ल, दे ब्रोंइचा कली नेल्‍लेमी परमप्रभु यावे कली क्‍येट गेचा माल्‍नीम। मिनु मेको आन कली हिक्‍शोनु, मारेइ मरिम्‍शो मदुम्‍ब। गन्‍ती १:३; २सामुएल २४:२-३ ");
INSERT INTO suzBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","गिश जना वोंइश मुर हिक्‍सीनीमी, मिश जना ताम्‍बु ङा नाक्‍तीके ङा आधा शेकेल गेचा माल्‍नीमी। शेकेल का २० गेराह चांदी बाक्‍नीम। मोपा परमप्रभु यावे कली गेशो क्‍येट आधा शेकेल गेचा माल्‍शो बाक्‍ब। शेकेल का ११.५ ग्राम खोदेंशो बाक्‍ब। गेरा का ०.६ ग्राम बाक्‍ब।मत्ती १७:२७ ");
INSERT INTO suzBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","वोंइश मुर गिश जना २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो बाक्‍मा, मिश जनाम परमप्रभु यावे कली गेचा माल्‍शो चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","इन पाप क्‍याम्‍तीक गेय पचा कली थीबमी आधा शेकेल, मथीबमी यो आधा शेकेल परमप्रभु यावे कली गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएली वोंइश मुरुमी आन गेशो प्रोंइतीक क्‍येट ताक्‍शा, ग्रुम्‍तीक ताम्‍बु ङा गेय पचा कली गेचा माल्‍नेवे। मिनु मेको क्‍येट परमप्रभु यावे आ ङोंइती इस्राएली आन कली प्रोंइशो मिम्‍तीक चिन्‍ड दुम्‍ब” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“गे चिक्‍चा कली कांसा के ठेयब बोस का सेल्‍पतो। मेको आ निप्‍पाइक्‍तीके यो कांसा केन दुम्‍चा माल्‍ब। मेको ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आस दातेमी वोइश्‍शा, ब्‍वाक्‍कु कुर पपाइक्‍चा माल्‍नेवे। प्रस्‍थान ३८:८ ");
INSERT INTO suzBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","मेको ब्‍वाक्‍कुमी हारून नु आ तौपुकीमी आन गुइ खोइली चिक्‍सीचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","मेकोपुकी मबेक्‍कल, दे ग्रुम्‍तीक ताम्‍बुम ओव़चा क्‍येङा ङोंइती चिक्‍सीचा माल्‍नीम। मिनु चढ़ेतीकेमी गेय पचा, दे परमप्रभु यावे आ ङोंइती मीम चोशा चढ़ेतीक चढ़ेचा कली लमानु, मेको ब्‍वाक्‍कुम चिक्‍सीचा माल्‍नीम। ब्‍वाक्‍कुम चिक्‍सीमानु, मेको मबेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","मेकोपुकी नु आन चच युइ आन पाला नेल्‍लेमी गेना हना यो पतीके लोव़ बाक्‍ब” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“गेमी शुश क्‍येट लाइब ब्रोव़शो रिना पाइब थोव़क चाक्‍चा माल्‍नेवे। मार चाक्‍चा माल्‍नेवे देंशा हना, मूरे आ रस ५ सहे शेकेल, दाल चिनी सहे निक्‍शी ५० शेकेल नु ब्रोव़शो रिना पाइब बोच सहे निक्‍शी ५० शेकेल चाक्‍चा माल्‍नेवे। शेकेल का ११.५ ग्राम चांदी के क्‍येट बाक्‍ब। ताम्‍बु ङा शेकेल चहिं १२ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","नु कस्‍सीया माइश्‍शो ब्रोव़शो रिना पाइब फू ५ सहे शेकेल, ताम्‍बु ङा नाक्‍तीकेमी नाक्‍शा, चाक्‍चा माल्‍नेवे। रिम्‍शो तेल हिन का यो चाक्‍चा माल्‍नेवे। हिन का ४ लिटर खोदेंशो बाक्ब। ");
INSERT INTO suzBl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","मेको नेल्‍ल ब्‍वाइश्‍शा थम रिम्‍शो लुक्‍तीक तेल सेल्‍पाइक्‍चा माल्‍नेवे। मेको परमप्रभु यावे कली ला बाक्‍ब। मेको ब्रोव़शो रिना पाइब सेल्‍स जोक्‍ब मुर कली सेल्‍पाइक्‍चा माल्‍नेवे। मेको थम रिम्‍शो लुक्‍तीक तेल ताम्‍बु कली ला सेल्‍चा माल्‍ब। प्रस्‍थान ३७:२९ ");
INSERT INTO suzBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","मिनु गे ग्रुम्‍तीक ताम्‍बु नु कबल पशो सन्‍दोस, ");
INSERT INTO suzBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","टेबल नु मेकेर ङा मार मार नेल्‍ल, बत्ती दातीके नु मेको आ मार मार नेल्‍ल नु धूप चोशा चढ़ेतीके, ");
INSERT INTO suzBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","चोशा चढ़ेतीके नु मेको आ मार मार नेल्‍ल नु चिक्‍तीके ठेयब बोस नु आ निप्‍पाइक्‍तीके नेल्‍ल ख्रेक्‍पाइक्‍चा माल्‍नेवे। प्रस्‍थान ३०:१० ");
INSERT INTO suzBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","मोपा मेको मारेइ मारेइ नेल्‍ल ख्रेक्‍तीनु, मेको ताम्‍बु ङा गेय कली ला दुम्‍नीम। मेको कली मार मारम थीनीमी, मेको यो परमप्रभु कली दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","आं कली चढ़ेब दुम्‍ब हारून नु आ तौ आन कली यो तेल ख्रेक्‍शा, आं गेय पाइब सेल्‍चा माल्‍नेवे। प्रस्‍थान २९:७ ");
INSERT INTO suzBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएली आन कली ‘मेको गेना हना यो इन चच युइ आन पाला सम्‍म लुक्‍तीक तेल दुम्‍चा माल्‍ब। मेको तेल परमप्रभु यावे के ला बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","मेको अरु मुर आन कली ख्रेक्‍चा मदुम्‍ब। मेको खोदेंशो पा ब्‍वाइश्‍शा तेल सेल्‍चा मदुम्‍ब। मेको परमप्रभु आ तेल ला बाक्‍ब’ दे मिम्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","सुमी मेको खोदेंशो पा ब्‍वाइश्‍शा तेल सेल्‍बा नु अरु मुर आन कली ख्रेक्‍बा, मेको मुर आ थर रे तिल्‍चा पुंइसीब” दे परमप्रभु यावेमी मोसा कली दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","मिनु परमप्रभु यावेमी मोसा कली “ब्रोव़शो रिना पाइब थोव़क मार ब्‍वाइक्‍पाइक्‍चा माल्‍नेवे देंशा हना, चोव़क, कुन्‍दापुरी, ब्रोव़शो रिना पाइब रवा आ दूध नु मारेइ मब्‍वाइश्‍शो मूरे, उइक्‍थ उइक्‍थ पा नाक्‍शा ब्‍वाइक्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","जोक्‍ब मुरुम मेको नेल्‍ल ब्‍वाइश्‍शा, ब्रोव़शो रिना पाइब धूप, हिक्‍सी सुप्‍शा, अरु मब्‍वाइश्‍शो परमप्रभु कली ला चढ़ेतीक धूप सेल्‍पाइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","मेको रे इच्‍का खोइ तुप्‍शा, फस सेलो। मिनु मेको फस ग्रुम्‍तीक ताम्‍बु ङा नेल्‍ल क्‍येङा चोव़खो कोठा कबल पशो सन्‍दोस आ ङोंइती वोइश्‍शा, मेको फस चोचा माल्‍नेवे। मेको इन कली नेल्‍ल क्‍येङा चोव़खो दुम्‍ब। मेकेर गो इ कली ग्रुम्‍नुङ। प्रस्‍थान ३०:६ ");
INSERT INTO suzBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","इन कली धूप सेल्‍नीनु, आं धूप खोदेंशो पा मसेलीन। ‘मेको धूप परमप्रभु यावे आं धूप ला बाक्‍ब’ दे मिम्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","सुइमी मेको नाम्‍चा कली सेल्‍तेक्‍म हना, मेको आन थर रे तिल्‍चा पुंइसीनीम” दे परमप्रभु यावेमी मोसा कली माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","मिनु परमप्रभु यावेमी मोसा कली प्रस्‍थान ३५:३०-३५ ");
INSERT INTO suzBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“नेनो, गो यहूदा आ थर ङा हुर आ चच ऊरी आ तौ बेचालेल आ नें थिशा आं गेय पचा कली योव़ता। ");
INSERT INTO suzBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","गो मेको कली आं सोक्‍तीमी प्रिंशा, मार मार सेल्‍चा कली जोक्‍ब तुइक्‍ब सेल्‍ता। मिनु पने चाप्‍तीक सक्ति यो गेता। ");
INSERT INTO suzBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","मेकोमी नेल्‍ल मिम्‍शा, सुन, चांदी नु कांसा के मारेइ मारेइ चेम्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","हीरा ख्रोइक्‍तीक नु सुनम क्‍येप्‍तीके, शी मुतीके नु मारेइ मारेइ सेल्‍स जोक्‍ब दुम्‍पाइक्‍ता। ");
INSERT INTO suzBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","गो दान आ थर ङा अहीसामाक आ तौ ओहोली-आब कली बेचालेल नु गेय पचा कली योव़ता। गो इस्राएल ङा जोक्‍ब रिम्‍शो गेय पाइब मेको आस कली वारच पाइब यो योव़तामी। गो इ कली मार मार देंङा, मेको नेल्‍ल आन कली सेल्‍ने चाप्‍तीक सक्ति गेतामी। ");
INSERT INTO suzBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ग्रुम्‍तीक ताम्‍बु, कबल पशो सन्‍दोस, मेको आ तार ङा सुम्‍तीके नु ताम्‍बु आ गा ङा माल्‍शो मारेइ मारेइ, प्रस्‍थान ३५:११-१९ ");
INSERT INTO suzBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","टेबल नु मेको आ मारेइ मारेइ, बत्ती दातीके नु आ मारेइ मारेइ, धूप चोशा चढ़ेतीके, ");
INSERT INTO suzBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","चोशा चढ़ेतीके नु आ मारेइ मारेइ, ठेयब चिक्‍तीक बोस नु आ राप्‍पाइक्‍तीके, ");
INSERT INTO suzBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","आं कली चढ़ेब दुम्‍तीके रिम्‍शो प्रोव़शो वा नेल्‍ल, चढ़ेब हारून आ चढ़ेची ना फेक्‍तीक वा नु आ तौ आन फेक्‍तीक वा, ");
INSERT INTO suzBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","लुक्‍तीक तेल नु ब्रोव़शो रिना पाइब धूप गोम इ कली देंशो खोदेंशो पा मेकोपुकीमी आं बाक्‍तीक कली सेल्‍चा माल्‍नीम” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“गे इस्राएली आन कली मार माइक्‍चा माल्‍नेवे देंशा हना ‘गेपुकीमी थमा पा आं नाइक्‍तीक नाक्‍ती मानेचा माल्‍नीनी। मारदे हना मेको गेपुकी नु इन चच युइ सम्‍म कली चिन्‍ड लीब। गो, परमप्रभु यावेमी, इन कली आं मुर सेल्‍ता, दे गे तुइक्‍नीनी। प्रस्‍थान २०:८; इजीकीएल २०:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","मोपतीके गेपुकीमी नाइक्‍तीक नाक्‍त मानेचा माल्‍नीनी। मारदे हना मेको परमप्रभु आ नाक्‍त बाक्‍ब। सु सुमी मेको नाक्‍ती ममानेथु, गेय पाइनीमी, मेको मुर आ जात ङा मुर रे तिल्‍शा, साइक्‍चा पुंइसीनीम। गन्‍ती १५:३२-३५; येरमीया १७:२१-२३ ");
INSERT INTO suzBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","मोपा ६ नाक्‍त सम्‍म गेय पामेक्‍ल, तन्‍न ७ नाक्‍त चहिं नाइक्‍तीक नाक्‍ती बाक्‍ब। मेको परमप्रभु यावे आ नाक्‍त बाक्‍ब। सु सुम मेको नाक्‍ती गेय पाइनीमी मेको थमा पा साइक्‍चा पुंइसीनीम। ");
INSERT INTO suzBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","मोपतीके इस्राएलीपुकीमी नाइक्‍तीक नाक्‍ती मानेचा माल्‍नीम। मेको नाक्‍ती गेना हना यो आन चच युइ सम्‍म कबल पतीके बाक्‍ब। मर्कूस २:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","गो नु इस्राएली इन दातेमी मेको गेना हना यो लीब चिन्‍ड बाक्‍ब। परमप्रभु यावेमी ६ नाक्‍तीमी सरीङ नु रागी सेल्‍ने थुम्‍तु। ७ नाक्‍ती चहिं नांइसीशा, आ दशो सात’ दे इस्राएली आन कली माइक्‍चा माल्‍नेवे” दें‍त। प्रस्‍थान १६:२३,२५; उत्‍पत्ती २:२ ");
INSERT INTO suzBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","मिनु परमप्रभुमी मोसा नु सीनै डांडाम लोव़ पने थुम्‍शा, आ देंशो फुल्‍लु निक्‍शीमी मुशा आंम ब्रेक्‍शो लोव़ मोसा कली गेप्‍तु। प्रस्‍थान २४:१२; प्रस्‍थान ३२:१५-१६; प्रस्‍थान ३४:२८; ब्‍यवस्‍था ४:१३; ब्‍यवस्‍था ५:२२; ब्‍यवस्‍था ९:१०; ब्‍यवस्‍था १०:१-५ ");
INSERT INTO suzBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मिनु इस्राएल ङा मुरपुकीमी मोसा कली डांडा रे मयिशो तशा, हारून आ बाक्‍तीक जाक्‍शा, मेको कली “लो, इं ङोंइङोंइती गाक्‍शा लां कोंइब देवता सेलो। आंइ कली इजीप्‍त रागी रे ग्रुंइशा, एक चाक्‍ब मोसा मार दुम्‍मे? मतुइक्‍तक” दे हारून कली देंमा बाक्‍त। ब्‍यवस्‍था ९:८-२१ ");
INSERT INTO suzBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","मिनु हारूनमी मेको आन कली “इन मीश, इन तमी तौ आन पांइशो सुन प्रुइश्‍शा, आं बाक्‍तीके चाक्‍कीन” दें‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","मिनु मुर नेल्‍लेमी आन नोफामी पांइशो सुन प्रुइश्‍शा, हारून आ बाक्‍तीके चाक्ग‍मे बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","मिनु हारूनमी मेको सुन आन गुइ रे ताक्‍शा, यपाइश्‍शा, बाछा का सेला बाक्‍त। मिनु इस्राएलीपुकीमी “इस्राएल ङा मुरपुकी, एकोन इं देवता बाक्‍ब। एकोमी इं कली इजीप्‍त रागी रे ग्रुंइताक्‍व” दे मुमा बाक्‍त। १राजा १२:२८; भजन संग्रह १०६:१९-२०; प्रेरित ७:४१ ");
INSERT INTO suzBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","मिनु हारूनमी मेको आन कली तशा, बाछा आ ङोंइती चढ़ेतीक का सेला बाक्‍त। मिनु ठेयब सेंदा पा “दीसा परमप्रभु यावे कली चाड का मानेचा माल्‍ब” दें‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","मिनु आ दीसा मेकोपुकी सुनी कना बोक्‍शा चोशा चढ़ेतीक नु दुशा बाक्‍चा आ पर्बम चढ़ेतीक चढ़ेमे बाक्‍त। मिनु मुरपुकी जचा तूचा कली निस्‍समा बाक्‍त। मिनु नोले जशा तूशा बोक्‍शा, आन द‍ला दाक्‍स पामे बाक्‍त। १कोरिन्‍थी १०:७ ");
INSERT INTO suzBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","मिनु परमप्रभु यावेमी मोसा कली “डांडा रे तोंइसो। इजीप्‍त रे ग्रुंइशा चाक्‍शो इ मुरपुकीमी आन द‍ला दाक्‍स पा पाप पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","मेकोपुकीमी आं शेंशो लोव़ थु था प्रोंइतेक्‍म। आंम कली सुन के बाछा का सेल्‍शा, मेको कली पूजा पशा ‘इस्राएल ङा मुरपुकी, एकोन इं कली इजीप्‍त रागी रे ग्रुंइब परमप्रभु बाक्‍ब’ देंतेक्‍म” दे परमप्रभु यावेमी मोसा कली दें‍त। प्रस्‍थान २०:४,२३ ");
INSERT INTO suzBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","मिनु लेंशा परमप्रभु यावेमी मोसा कली “गो मेको मुर आन कली ताता। काइ मटीब बाक्‍नीम, दे तुइक्‍ताक्‍ङ। ब्‍यवस्‍था ९:६; यसैया ४८:४; प्रेरित ७:५१ ");
INSERT INTO suzBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","मोपतीके आं कली मतेक्‍यी। मेको आन कली तशा गाइक्‍ताक्‍यी। गो मेको आन कली साइक्‍नुङमी। मिनु गो इ लां पा ठेयब जात का सेल्‍नुङमी” दें‍त। गन्‍ती १४:११-२० ");
INSERT INTO suzBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","मिनु मोसामी परमप्रभु यावे कली “परमप्रभु यावे, आं परमप्रभु, इन मुर आन पर्बम मारदे गाइक्‍तीनी? गेमी इन ठेयब सक्तिमी मेको आन कली इजीप्‍त रागी रे ग्रुंइताक्‍नी। ");
INSERT INTO suzBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मो पाइतीनी हना इजीप्‍त रागी ङा मुरपुकीमी ‘परमप्रभुमी मेको आन कली पहाडमी साइश्‍शा, रागी रे क्‍याम्‍चा कली एक रे ग्रुंइताक्‍व’ देंनीम। मोपतीके इन ठेयब गाइक्‍तीक प्रोनीन। इन मुर आन कली मसतीन। ब्‍यवस्‍था ९:२८; यहोसु ७:९ ");
INSERT INTO suzBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","इन गेय पाइब अब्राहाम, इसहाक नु याकूब मिम्‍तीने। मेको आन पर्बम इन नेंमी ‘गो इन कली सरीङ ङा सोरुल खोदेंशो पा शुश सेल्‍नुङ। आं देंशो रागी इन चच युइ आन कली गेनुङमी। मिनु एको रागी गेना हना यो मेको आन के दुम्‍ब’ दे कसम जाइतीनी” दें‍त। उत्‍पत्ती १५:५; उत्‍पत्ती २२:१६-१७; उत्‍पत्ती २६:४ ");
INSERT INTO suzBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","मिनु परमप्रभु यावेमी आ थुं लेश्‍शा, आ मुर आन कली मसाइक्‍मी। भजन संग्रह ८५:- ");
INSERT INTO suzBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मिनु मोसा परमप्रभु यावे आ देंशो लोव़ ब्रेक्‍शो फुल्‍लु निक्‍शी कुरशा, डांडा रे ब्रुप्‍त। मेको फुल्‍लु निक्‍शी निम्‍फा पटटीम मुशा ब्रेक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","परमप्रभुमी मेको फुल्‍लु आंमा चेश्‍शा सेल्‍शो बाक्‍माक्‍त। मिनु मुशा ब्रेक्‍शो बाक्‍त। प्रस्‍थान ३१:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","मिनु यहोसुमी मुर आन कली रेयके पशो नेंशा, मोसा कली “इस्राएल ङा मुर आन बाक्‍तीकेमी लडाइ पशो रेयके खोदेंशो नेंसाक्‍व” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","तन्‍न मोसामी “एको रेयके लडाइ ग्राब आन रेयके ममाइ, ब्रुइब आन रेयके यो ममाइ। गो कुम्‍सो पशो नेंता” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","मिनु मोसा इस्राएली आन बाक्‍तीके आ नेक्‍था जाक्‍मेनु, बाछा नु बाछा आ एर ओंथ मुरपुकी सिल पशो तशा, शुश गाइश्‍शा, फुल्‍लु निम्‍फा ताइश्‍शा, डांडा आ पुंम प्रोल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","मिनु मोसामी इस्राएली आन सेल्‍शो बाछा लाइश्‍शा, मीम हुम्‍शा, तुप्‍शा फस सेल्‍शा, ब्‍वाक्‍कुम फुइश्‍शा, इस्राएली आन कली तूपाइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","मिनु नोले मोसामी हारून कली “एको मुरपुकीमी इ कली मार पामे ङा? मारदे मेको आन कली ओदेंशो ठेयब पाप पपाइक्‍मी?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","मिनु हारूनमी “आं पर्बम मगाइक्‍तीन। गे एको मुर आन कली तुइक्‍नीनी। एकोपुकी दूली पाइब ला बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","आं कली ‘आंइ ङोंइङोंइती गाक्‍शा लां कोंइब देवता सेलो। मारदे हना आंइ कली इजीप्‍त रे ग्रुंइशा, एक चाक्‍ब मोसा कली मार दुम्‍मे, मतुइक्‍तक’ देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","मिनु गो मेको आन कली ‘सु सु इन के सुन बाक्‍मे, मेको प्रुइश्‍शा, एक चाक्‍कीन’ दे माइक्‍तामी। मिनु मेकोपुकीमी चाक्‍तेक्‍म। मिनु गो मेको सुन मीम हुम्‍ताक्‍ङ। मिनु एको बाछा दुम्‍त” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोसामी मुर आन कली आन द‍ला दाक्‍स पशो ताप्‍तु। मारदे हना हारूनमी आन दला दाक्‍स पचा गेवा बाक्‍त। मिनु आन जोरी सत्रु नेल्‍ल ग्‍येरसमा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","मिनु मोसामी इस्राएली आन बाक्‍तीक ओव़तीकेम राप्‍शा “सु सु परमप्रभु यावे गे बाक्‍नी, मेकोपुकी आं गे पिने” दें‍त। मिनु लेवी आ थर ङा मुर नेल्‍ल मोसा गे लशा, आ एर ओंथ राप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मिनु मोसामी मेको आन कली “परमप्रभु यावे, इस्राएली आन परमप्रभुमी ‘गे नेल्‍लेमी इन तरवार पिप्‍शा, मुर आन बाक्‍तीके लशा, इन लोक्‍ब, इन खिं ङा मुर, इन वारच नु सु बाक्‍तेक्‍म हना यो, सतीन’ देंत” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मिनु लेवी आ थर ङा मुरपुकीमी मोसा आ देंशो खोदेंशो पा पाम्‍तेक्‍म। मेको नाक्‍ती हजार सां मुर साइक्‍चा पुंइसाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","मिनु मोसामी लेवी आ थर ङा मुर आन कली “गेपुकीमी मुलाक्‍ती परमप्रभु यावे आ गेय पा, आंम आंम इन तौ नु आंम आंम इन लोक्‍ब आन कली मप्रोंइथु साइक्‍तीनी। मिनु मुलाक्‍ती गे आसीक राइनीनी” दें‍त। प्रस्‍थान २६:४१; गन्‍ती ३:६-१०; ब्‍यवस्‍था ३३:८-११ ");
INSERT INTO suzBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","आ दीसा मोसामी मुर आन कली “गेपुकीमी ठेयब पाप पाइतीनी। मिनु गो परमप्रभु यावे आ बाक्‍तीक ङोइश्‍शा, लाइनुङ। गो इन पशो पाप क्‍याम्‍तीक गेय पने चाप्‍नुङा, कों?” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","मिनु मोसा परमप्रभु यावे आ बाक्‍तीक लशा मेको कली “मुरपुकीमी थमा पा ठेयब पाप पाम्‍तेक्‍म। आंम कली सुन के देवता सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","मो हना यो गे मेको आन पाप क्‍याम्‍दीन, दे पुंइनुङ। मक्‍याम्‍ताक्‍नी हना, इन ब्रेक्‍शो किताब रे आं नें क्‍याम्‍दीने” दें‍त। भजन संग्रह ६९:२९; लूका १०:२०; रोमी ९:३ ");
INSERT INTO suzBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","मिनु परमप्रभु यावेमी मोसा कली “सुमी आं देंशो मटिथु पाप पाइबा, मेको आ नें आं ब्रेक्‍शो किताब रे क्‍याम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","तन्‍न मुल लावो। मेको मुर आन कली आं देंशो रागी लाइक्‍मी। नेनो, आं स्‍वर्ग ङा गेय पाइब इ ङोंइङोंइती सोइक्‍नुङ। तन्‍न काबु मेको आन कली पाप पशो आ पर्बम सजाइ गेनुङ” दें‍त। प्रस्‍थान ३३:२,१४; गन्‍ती १४:२७-३० ");
INSERT INTO suzBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","मिनु परमप्रभु यावेमी इस्राएल ङा मुर आन कली बेक्‍तीक रोइ पपाइक्‍तु। मारदे हना मेकोपुकीमी हारून कली मेको सुन के बाछा सेल्‍पाइश्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","मिनु परमप्रभु यावेमी मोसा कली “इजीप्‍त रे ग्रुंइशा, एक चाक्‍शो मुरपुकी नु आं देंशो रागी लावो। मेको रागी आ पर्बम गो ‘इ चच युइ आन कली गेनुङ’ दे अब्राहाम, इसहाक नु याकूब नु कसम जाता। उत्‍पत्ती १२:७ ");
INSERT INTO suzBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","आं स्‍वर्ग ङा गेय पाइब इन ङोंइङोंइती सोइक्‍नुङ। मिनु गो कनानी, एमोरी, हित्ती, परि‍ज्‍जी, हिव्‍वी नु यबुसी आन कली खेरनुङमी। प्रस्‍थान २३:२० ");
INSERT INTO suzBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","मेको रागीम दूध नु खुदो शुश बाक्‍ब। मारेइ मारेइ यो शुश ग्रेल्‍ब। गेपुकी काइ मटीब मुर बाक्‍नीनी। मोपतीके गो गेपुकी नु मगाक्‍नुङ। गो गाक्‍ती हना, इन कली लांमीन साइक्‍नन्‍नी” दें‍त।। प्रस्‍थान ३२:९-१० ");
INSERT INTO suzBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","मिनु मुरपुकीमी मेको मरिम्‍शो लोव़ नेंशा, सुर्ता पाम्‍तेक्‍म। सुइमी आन सुन चांदी मारेइ मपांइसम। ");
INSERT INTO suzBl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","मारदे हना परमप्रभु यावेमी मोसा कली “इस्राएली आन कली ‘गेपुकी काइ मटीब मुर बाक्‍नीनी। गो याम का गे नु गाक्‍ती हना, नेल्‍ल इन कली साइक्‍नन्‍नी। मुल इन सुन चांदी नेल्‍ल प्रुतीन। मिनु इन कली मार पचा माल्‍नुङा, दे मिम्‍नुङ’ ” देंशो बाक्‍त। योएल २:१३ ");
INSERT INTO suzBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","मोपतीके होरेब डांडाम बाक्‍मा रे इस्राएलीपुकीमी सुन चांदी मपांइसम।। योना ३:६ ");
INSERT INTO suzBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मिनु मोसामी अरु आन बाक्‍तीक क्‍येङा ङोन ताम्‍बु का कीशा वोइक्‍तु। मेको ताम्‍बु कली परमप्रभु नु लोव़ पतीक ताम्‍बु दें‍त। सु सु परमप्रभु यावे कली ग्रुम्‍चा दाक्‍तमे, मेको मुर आन बाक्‍तीक रे ग्रूशा, मेको परमप्रभु नु लोव़ पतीक ताम्‍बु लाइबाक्‍तेक्‍म। प्रस्‍थान २९:४२ ");
INSERT INTO suzBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","मिनु मोसा मेको परमप्रभु नु लोव़ पतीक ताम्‍बु लमेनु, मुर नेल्‍ल बोक्‍शा, आन ताम्‍बु आ ओव़तीकेम राप्‍शा, मोसा मेको ताम्‍बु मओव़म सम्‍म, कोव़शा बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मिनु मोसा मेको ताम्‍बु आगा ओव़मेनु, गोस्‍स के थाम यिशा, ताम्‍बु आ ओव़तीकेम राप्‍शो ताम्‍तेक्‍म। मिनु परमप्रभु यावेमी मोसा नु लोव़ पाप्‍तु। गन्‍ती ११:२५; ब्‍यवस्‍था ३१:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","मुर नेल्‍लेमी मेको गोस्‍स के थाम, ताम्‍बु आ ओव़तीकेम राप्‍शो ताम्‍तेक्‍म। मिनु मुर नेल्‍ल बोक्‍शा आंम आंम ताम्‍बु आ ओव़तीकेमी बाप्‍शा, परमप्रभु कली मान पा ठेयब सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","मिनु परमप्रभु यावे नु मोसा कोव़मुशा, लोव़ पाम्‍ताक्‍स। दोदेंशो पा मुर आन वारच नु बाक्‍शा, लोव़ पाइनीमी, मोदेंशो पा लोव़ पाम्‍ताक्‍स। मिनु मोसा लेश्‍शा, आ ताम्‍बुम लत। आ गेय पाइब ठिटा, नून आ तौ यहोसु चहिं ताम्‍बु उइ बाक्‍त। प्रस्‍थान ३३:२०; गन्‍ती १२:८; ब्‍यवस्‍था ३४:१० ");
INSERT INTO suzBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मिनु मोसामी परमप्रभु यावे कली “कोव़ङीन, गे आं कली ‘एको मुर आन कली लतो’ देंतीनी, तन्‍न गो नु सु सु सोइक्‍नीनी, गे आं कली मतुइक्‍पाइय्‍यीनी। मो हना यो, गे आं कली ‘इ नें कली तुइक्‍नुङ। मिनु इ कली दाक्‍नुङ’ देंतीनी। प्रस्‍थान ३३:२,३,१७ ");
INSERT INTO suzBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","मोपतीके गे आं कली दाक्‍ताक्‍नी हना, आं कली इन लां कोंइदीने। गो इन कली तुइक्‍ने चबुल। गो इन ङोंइती शिशी तङल। एको जात ङा मुरपुकी इन मुर नम, दे मिम्‍तीने” दें‍त। भजन संग्रह १०३:७ ");
INSERT INTO suzBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","मिनु परमप्रभुमी “गो गे नु लाइनुङ। मिनु इ थुं नाइक्‍चा गेनुङ” दें‍त। यसैया ६३:९; यहोसु २१:४४; हिब्रू ४:९ ");
INSERT INTO suzBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मिनु मोसामी “गे गो नु मलाइतीनी हना, आंइ कली एक रे मसोइक्‍तीन। ");
INSERT INTO suzBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","गो नु इन मुरपुकीमी इन ङोंइती शिशी तशो बाक्‍नीकी, दे गो दोपा तुइक्‍नीकी? गे गो नु लाइतीनी हना ला, तुइक्‍नीकी। मोपा ला गो नु इन मुरपुकी रागी ङा मुरपुकी नु खाल का ङा मदुम्‍नीकी” दें‍त। ब्‍यवस्‍था ४:६-८ ");
INSERT INTO suzBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","मिनु परमप्रभु यावेमी मोसा कली “गो इ देंशो पाइनुङ। मारदे हना गो इ कली दाक्‍नुङ। मिनु इ नें यो तुइक्‍नुङ” दें‍त। प्रस्‍थान ३३:१२; यसैया ४३:१; २तिमोथी २:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मिनु मोसामी “गे आं कली इन छेङछेङ तपाइय्‍यीनी” दे पुंइतु। यूहन्‍ना १:१४; २कोरिन्‍थी ३:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","मिनु मेकोमी “गो इ ङोंइती रे लाइनुङ, आं गेना हना यो दाक्‍तीक कोंइनन। इ ङोंइती आं नें ‘यावे, देंना देंन गाक्‍नुङ’ सु सु आन कली शिशी पचा दाक्‍ङा, मेको आन कली शिशी पाइनुङ। सु सु आन कली दाक्‍चा दाक्‍ङा, मेको आन कली दाक्‍नुङ” दें‍त। रोमी ९:१५ ");
INSERT INTO suzBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","मिनु मोसा कली “गे आं कुल कोव़ने मचाप्‍नेवे। मारदे हना आं कुल तामेनु, मुर बेक्‍नीमी” दें‍त। प्रस्‍थान २४:११; उत्‍पत्ती ३२:३१; न्‍यायाधीस ६:२२-२३; न्‍यायाधीस १३:२२-२३; यसैया ६:५; यसैया ३३:१४; १तिमोथी ६:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","मिनु लेंशा परमप्रभु यावेमी मोसा कली “कोव़ङो, आं बाक्‍तीकेम सेरथे फुल्‍लु का बाक्‍ब, गे मेको तार रपो। १राजा १९:८-१३ ");
INSERT INTO suzBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","आं छेङछेङ मेकेर रे लमेनु, गो इ कली मेको सेरथे फुल्‍लु आ काक्‍पेमी ख्रुइश्‍शा वोइक्‍नन। गो मलाक्‍गु सम्‍म इ कली आं गुइमी सुम्‍शा वोइक्‍नन। प्रस्‍थान ३४:५-६; प्रस्‍थान २४:११; ");
INSERT INTO suzBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","नोले आं गुइ क्‍युक्‍नुङ। मिनु गे आं ची ताइनेवे। आं कुल चहिं मताइनेवे” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","मिनु परमप्रभु यावेमी मोसा कली “ङोंइती ङा खोदेंशो पा फुल्‍लु निक्‍शी ख्रोतो। गो मेको फुल्‍लुमी इ ङोंइती प्रोल्‍शो फुल्‍लु ङा लोव़ ब्रेक्‍नुङ। प्रस्‍थान ३२:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","सुनी कना बोक्‍शा, सीनै डांडा ङोइश्‍शा, आं ङोंइती जाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","गे नु सुइ डांडा ङोइक्‍चा मदुम्‍नीम। बी ब्‍यफ, क्‍यारश भेडा यो डांडा गे जोचा मदुम्‍नीम” दे माइक्‍तु। प्रस्‍थान १९:१२-१३ ");
INSERT INTO suzBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","मिनु मोसामी परमप्रभु यावेमी देंशो खोदेंशो पा ङोंइती ङा खोदेंशो फुल्‍लु निक्‍शी ख्रोइक्‍तु। मिनु सुनी कना बोक्‍शा, फुल्‍लु कुरशा सीनै डांडा ङोंइसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","मिनु परमप्रभु यावे गोस्‍स आगाम बाक्‍शा, तोंइसाक्‍व। मिनु मोसा नु राप्‍शा आ नें देंना देंन गाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","मिनु परमप्रभु यावे मोसा आ नेक्‍था गाक्‍ना गाक्‍न “यावे, यावे, शिशी पाइब नु दाक्‍ब परमप्रभु बाक्‍ब। रीब पा मगाइक्‍ब। गेना हना यो शिशी पाइब नु आ दाक्‍चा मप्रोंइब बाक्‍ब। प्रस्‍थान ३३:१८-२६; गन्‍ती १४:१८; भजन संग्रह १०३:८; नहुम १:३; १यूहन्‍ना ४:१६ ");
INSERT INTO suzBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","मिनु हजार हजार आन पाला सम्‍म गेना हना यो दाक्‍ब। मुर आन ठीक मपशो, आन हेंथे पशो नु पाप पशो क्‍याम्‍ब। तन्‍न सजाइ मगेथु मप्रोंइब। आम आफ आन मरिम्‍शो पशो आन तमी तौ, चच, युइ नु युइ आन युइ सम्‍म सजाइ ताइनीम” दें‍त। प्रस्‍थान २०:५-६; ब्‍यवस्‍था ३२:९; भजन संग्रह २८:९ ");
INSERT INTO suzBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मिनु मोसामी गु बाप्‍शा सेउ पा ठेयब सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","मिनु “आं परमप्रभु, इन ङोंइती शिशी तशो बाक्‍ती हना, गे परमप्रभु, गो नु गाक्‍कीन, दे पुंइनुङ। एको काइ मटीब मुर बाक्‍तेक्‍म हना यो, आंइ ठीक मपशो नु पाप क्‍याम्‍दीन। आंइ कली आंम इन मुर सेल्‍शा ब्रकी” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","मिनु मेकोमी “नेनो, गो कबल का पाइनुङ। इ मुर नेल्‍ल आन ङोंइती छक लाक्‍चा ङा गेय पाइनुङ। गो मोदेंशो गेय रागी रागी आन दातेमी गेनायो मपङ। मिनु गे नु बाक्‍ब मुर नेल्‍लेमी परमप्रभु यावे आ गेय बाक्‍ब, दे तुइक्‍नीम। आं पचशो गेय हिंचा ङा नु छक लाक्‍चा ङा बाक्‍ब। प्रस्‍थान १९:५ ");
INSERT INTO suzBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","गो मुलाक्‍ती मार देंनुङा, मेको लोव़ टिचा माल्‍नेवे। नेनो, गो इ ङोंइती रे एमोरी, कनानी, हित्ती, परि‍ज्‍जी, हिव्‍वी नु यबुसी आन कली खेरनुङमी। ");
INSERT INTO suzBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","गो इन कली गेनुङ देंशो रागी जाक्‍दीत्‍नीनु, मेको रागी ङा मुरपुकी नु काइ कबल मपावो। होस पा बाक्‍को। कबल पाप्‍तीवी हना, मेकोपुकीमी इन कली दूली पाइब सेल्‍नीम। प्रस्‍थान २३:३२-३३ ");
INSERT INTO suzBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","मेको आन चढ़ेतीकपुकी प्रेश्‍शा, आन पूजा पचा कली ख्रुक्‍शो फुल्‍लु प्रोल्‍शा, मूर्ति पाइश्‍शो थाम कली क्‍योरशा, तिम्‍चा माल्‍नीनी। प्रस्‍थान २३:२४ ");
INSERT INTO suzBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","गे मेको आन देवी देवता आन ङोंइती बाप्‍शा सेउ मपने। मारदे हना आं नें रुश पाइब बाक्‍ब। मिनु गो रुश पाइब परमप्रभु बाक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","मेको रागी ङा मुर नु काइ कबल मपने। मारदे हना मेको रागी ङा मुरुमी आन देवी देवता आन कली पूजा पा क्‍योरशा चढ़ेनीमी। मिनु इन कली ब्रेम्‍मानु, गे मेको आन देवी देवता आन कली चढ़ेशो जाइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","मिनु गे आन तमी इन तौ आन कली चाक्‍नीनी। मिनु मेको आन तमीम आन देवी देवता आन कली पूजा पा चढ़ेनीम। इन तौ आन कली यो आन देवी देवता आन कली पूजा पा चढ़ेपपाइक्‍नीम। ब्‍यवस्‍था ७:३; न्‍यायाधीस ३:६; १राजा ११:२ ");
INSERT INTO suzBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","गेपुकीमी आंम कली मूर्ति मचेम्‍सीन। प्रस्‍थान २०:४ ");
INSERT INTO suzBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","बोरब ओख्‍ती मसुप्‍शो शोब्‍ले ङा चाड मानेचा माल्‍नीनी। आं देंशो खोदेंशो पा आबीब महिनाम ७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। मारदे हना गे आबीब महिनाम इजीप्‍त रे ग्रूशो ननी। प्रस्‍थान २३:१४-१९ ");
INSERT INTO suzBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","इन बस्‍तु भाव आन ङोंइती जरमेशो बाछा, पाठा, नेल्‍ल आं के नम। उत्‍पत्ती ४:४ ");
INSERT INTO suzBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ङोंइती जरमेशो गधा आ बोहोर आ पा ङा पाठा का गेशा प्रोंइचा माल्‍नीनी। मो मपाइनीनी हना, आ शुर जिक्‍शा, साइक्‍चा माल्‍नीनी। इन ङोंइती जरमेशो तौ आ पा ङा क्‍येट गेशा प्रोंइचा माल्‍नीनी। आं ङोंइती सुइ श्‍येत्‍थ गुइ मजाक्‍कीन। प्रस्‍थान १३:१२-१६ ");
INSERT INTO suzBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","मिनु ६ नाक्‍त इन गेय नेल्‍ल पचा माल्‍नीनी। ७ नाक्‍त चहिं नाइक्‍चा माल्‍नीनी। ब्‍यफ वाक्‍ची नु बाली नाली रुप्‍ची ना यो नाइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","गेपुकीमी हप्‍ता ङा चाड मानेचा माल्‍नीनी। मेको ङोंइती मीशो चेरब आ चाड बाक्‍ब। बाली नाली रुप्‍शा ओंइतीक ङा चाड यो मानेचा माल्‍नीनी। मेको बर्स नुप्‍ची ना ङा चाड बाक्‍ब। लेवी २३:१५-१६; ब्‍यवस्‍था १६:९-१० ");
INSERT INTO suzBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","इस्राएल ङा वोंइश मुर नु वोंइश आल नेल्‍ल बर्सम खेयप सां परमप्रभु आ ङोंइती, परमप्रभु यावे, इस्राएली आन परमप्रभु आ ङोंइती जाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","गो रागी रागी ङा मुर आन कली इन ङोंइती रे खेरशा, इन बाक्‍तीक रागी बारपाइक्‍नुङ। बर्सम खेयप सां परमप्रभु यावे इन परमप्रभु आ ङोंइती जाक्‍कीन। मिनु सुइम इन रागी तशा मवाल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","आं कली चढ़ेतीक हुश बोरब ओख्‍ती सुप्‍शो शोब्‍ले नु मचढ़ेन। पास्‍सा चाड ङा चढ़ेशो श्‍ये सुनी सम्‍म मारेइ महेंचा। ");
INSERT INTO suzBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","इन रू ङा ङोंइती मीशो नेल्‍ल क्‍येङा रिम्‍शो थोव़क परमप्रभु यावे, इन परमप्रभु आ खिंम चाक्‍चा माल्‍नीनी। क्‍यारश आ पाठा आ ममा आ दूधमी लोप्‍शा क्‍येचा मदुम्‍ब” दे मोसा कली दें‍त। प्रस्‍थान २३:१९ ");
INSERT INTO suzBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","मिनु परमप्रभु यावेमी मोसा कली “गो, गे नु इस्राएली नेल्‍ल नु एको अरेशो लोव़ पा कबल पाता, मोपतीके ब्रेक्‍तो” दें‍त। प्रस्‍थान २४:४ ");
INSERT INTO suzBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मिनु मोसा परमप्रभु यावे नु ४० नाक्‍दो नाक्‍ती बाक्‍‍त। मारेइ मजवो। ब्‍वाक्‍कु यो मतूङ। मिनु कबल ङा १० ओटा अरेशो लोव़ फुल्‍लुम ब्रेक्‍ताक्‍व। प्रस्‍थान २४:१८; मत्ती ४:२; प्रस्‍थान ३१:१८ ");
INSERT INTO suzBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","मिनु नोले मोसा मेको परमप्रभु यावे आ कबल ङा लोव़ ब्रेक्‍शो फुल्‍लु निक्‍शी कुरशा, सीनै डांडा रे तोंइसाक्‍व। मोसा परमप्रभु यावे नु लोव़ पतीके आ कुल परमप्रभु आ छेङछेङम छेङछेङ दुम्‍शो बाक्‍ब, दे मतुइक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","मिनु हारून नु इस्राएली नेल्‍लेमी मोसा कली तामेनु, आ कुल छेङछेङ दुम्‍शो ताम्‍तेक्‍म। मिनु आ नेक्‍था लचा हिंतेक्‍म। २कोरिन्‍थी ३:७-१८ ");
INSERT INTO suzBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","मिनु मोसामी मेको आन कली ब्रेत्‍तीमीनु, हारून नु ठेयब मुर नेल्‍ल आ नेक्‍था जाक्‍तेक्‍म। मिनु मेकोपुकी नु लोव़ पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","मिनु नोले इस्राएलीपुकी यो मोसा आ नेक्‍था जाक्‍तेक्‍म। सीनै डांडाम परमप्रभु यावेमी आ कली मार मार मदा, मेको नेल्‍ल आन कली अरेम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","मोसामी मेकोपुकी नु लोव़ पने थुम्‍शा, आ कुल वामी सुम्‍साक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मोसा परमप्रभु यावे नु लोव़ पथ आ ङोंइती लमेनु, लाङगा मग्रूम सम्‍म आ कुल हुक्‍साक्‍व। मिनु नोले ग्रूशा, आ कुल सुम्‍सीशा मेको लोव़ इस्राएली आन कली नेंपाइक्‍तीमी। प्रस्‍थान ३३:८-९ ");
INSERT INTO suzBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएलीमी मोसा आ कुल छेङछेङ दुम्‍शो ततीके, मोसामी परमप्रभु यावे नु लोव़ पथ, आगा मओव़म सम्‍म आ कुल सुम्‍साक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोसामी इस्राएली नेल्‍ल आन कली ब्रेश्‍शा “परमप्रभु यावेमी शेंशो इन पचा माल्‍शो गेय, मार मार बाक्‍ब देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","गे ६ नाक्‍त सम्‍म गेय पने। ७ नाक्‍ती चहिं परमप्रभु यावे आ नाक्‍त दुम्‍तीके, मेको नाक्‍ती नाइक्‍तीक नाक्‍त बाक्‍ब। सु सुमी मेको नाक्‍ती गेय पाइनीमी, मेको साइक्‍चा पुंइसीनीम। प्रस्‍थान २०:८-११; प्रस्‍थान ३४:२१ ");
INSERT INTO suzBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","नाइक्‍तीक नाक्‍ती इन खिं नेल्‍लेमी मी मुइक्‍चा यो मदुम्‍ब” दे माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मिनु नोले मोसामी इस्राएली आन कली “परमप्रभु यावे आ शेंशो लोव़ मार बाक्‍ब, देंशा हना ");
INSERT INTO suzBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘परमप्रभु यावे कली ग्रुम्‍तीक ताम्‍बु सेल्‍चा कली चढ़ेतीक मार मार पोक्‍चा माल्‍नीनी। सु सुम ग्‍येरशा गेनीनी, मेकोमी परमप्रभु यावे कली मार चाक्‍चा माल्‍नीनी देंशा हना, सुन, चांदी, कांसा, प्रस्‍थान २५:२ ");
INSERT INTO suzBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा नु क्‍यारश आ चां, ");
INSERT INTO suzBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लल रङ नुप्‍शो बोका आ कुशुल, नेल्‍ल क्‍येङा रिम्‍शो कुशुल नु बोल्‍यो शी, ");
INSERT INTO suzBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","बत्ती दाचा कली तेल, लुक्‍तीक तेल कली ब्‍वाइक्‍तीक नु धूप कली ब्‍वाइक्‍तीक, ");
INSERT INTO suzBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला नु कुचु तार वोइक्‍तीक सेल्‍चा कली ओनीक्‍स माइश्‍शो हीरा नु अरु हीरा चाक्‍चा माल्‍नीनी’ ” दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","मिनु मोसामी “इन दातेम सु सु जोक्‍ब बाक्‍नी, मेको नेल्‍ल जाक्‍शा, परमप्रभु यावे आ देंशो थोव़क नेल्‍ल सेल्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ग्रुम्‍तीक ताम्‍बु नु ताम्‍बु कली सुम्‍तीक, ग्‍याइक्‍पाइक्‍तीकपुकी, फलेक नु लाइश्‍शो कोक्‍केपुकी, थामपुकी नु राप्‍पाइक्‍तीकपुकी, ");
INSERT INTO suzBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","कबल पशो सन्‍दोस नु आ कुरतीक कोक्‍के निक्‍शी, सन्‍दोस आ सुम्‍तीके, फारतीके, ");
INSERT INTO suzBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","टेबल नु आ कुरतीक कोक्‍के, ग्‍योंब नेल्‍ल नु कोंइतीक शोब्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","बत्ती दातीक नु मेको आ दियारीपुकी, बत्ती कली ठीक सेल्‍तीक थोव़क नु बत्ती कली तेल, ");
INSERT INTO suzBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूप चोशा चढ़ेतीके नु मेको आ कुरतीक कोक्‍के, लुक्‍चा कली तेल नु ब्रोव़शो रिना पाइश्‍शो धूप, ताम्‍बु ओव़तीक ङा फारतीक वा, ");
INSERT INTO suzBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","चोशा चढ़ेतीके नु आ एर ओंथ ङा कांसा के थरपु, कुरतीक कोक्‍के नु आ मार मार, चिक्‍तीक ठेयब बोस नु मेको आ निप्‍पाइक्‍तीके, ");
INSERT INTO suzBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ताम्‍बु आ लाङगा ङा फारतीक वा, आ थामपुकी नु मेको आन राप्‍पाइक्‍तीकपुकी, ओव़तीक ङा फारतीक वा, ");
INSERT INTO suzBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ताम्‍बु आ किला नु लाङगा थरपु ङा किलापुकी नु डोरीपुकी, ");
INSERT INTO suzBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","नु हारून नु आ तौ परमप्रभु कली चढ़ेब दुम्‍चा कली फेक्‍तीक वासी सेल्‍चा माल्‍नीनी” दे मुर आन कली माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","मिनु नोले इस्राएली नेल्‍ल मोसा आ ङोंइती रे लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","सु सु आन थुंमी “गो चाक्‍नुङ” देंमा, मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु सेल्‍चा कली नु मेकेर ङा गेय पचा कली मार मार थोव़क नु फेक्‍तीक वा कली मार मार माल्‍दा, मेको परमप्रभु यावे कली गेचा, दे चाक्‍तेक्‍म। १इतिहास २९:५-९; २कोरिन्‍थी ९:७ ");
INSERT INTO suzBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","मीश मुर, वोंइश मुर नेल्‍लेमी मार मार चाक्‍तेक्‍म देंशा हना, मुन्‍द्री, मारवाडी, औंठी, सुन के चुरा नु अरु सुन के थोव़कपुकी परमप्रभु यावे कली चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","सु सु नु नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा, क्‍यारश आ चां, लल रङ नुप्‍शो सांड आन कुशुल, नेल्‍ल क्‍येङा रिम्‍शो सेल्‍शो कुशुल बाक्‍मे, मेको चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","सु सु आन के चांदी नु कांसा बाक्‍मे, मेकोमी परमप्रभु यावे कली चाक्‍तेक्‍म। सु सु नु गेय पचा कली ठीक प‍शो बोल्‍यो शी बाक्‍मे, मेको चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","मिनु मीश मुर आन दातेमी सु सु जोक्‍ब बाक्‍मा, मेकोपुकीमी आन पांइशो नीलो, प्‍याजी, लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","सु सु जोक्‍ब बाक्‍मा, मेकोपुकीमी क्‍यारश आ चां पांइतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","मिनु ठेयब मुरपुकीमी ओनीक्‍स माइश्‍शो नु अरु हीरा कुचु तार वोइक्‍तीक नु निसाफ पतीक ऊरीम नु थुम्‍मीम वोइक्‍चा कली झोलाम क्‍येप्‍पाइक्‍चा कली चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","बत्ती कली तेल, लुक्‍चा कली तेल नु धूप कली ब्रोव़शो रिना पाइब ब्‍वाइक्‍तीक थोव़क चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","मोपा इस्राएली नेल्‍लेमी ग्‍येरशा, परमप्रभु यावे कली गेचा कली मारेइ मारेइ चाक्‍तेक्‍म। मीश मुर नु वोंइश मुरुमी मार मार माल्‍बा मेको नेल्‍ल चाक्‍तेक्‍म। परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा ताम्‍बु सेल्‍तीक गेय पचा कली मार मार चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मिनु मोसामी इस्राएली आन कली “नेनीन, परमप्रभु यावेमी यहूदा आ थर ङा हुर आ चच, ऊरी आ तौ बेचालेल कली आ नें थिशा, आ गेय पचा कली योव़तु। ");
INSERT INTO suzBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","मेकोमी मेको कली परमप्रभुमी आ सोक्‍तीम प्रिंशा, मार मार सेल्‍चा कली जोक्‍ब तुइक्‍ब सेल्‍तु। मिनु पने चाप्‍तीक सक्ति यो गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","मेकोमी नेल्‍ल मिम्‍शा, सुन, चांदी नु कांसा के मारेइ मारेइ चेम्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","हीरा ख्रोइक्‍तीक नु सुनम क्‍येप्‍तीके, शी मुतीके नु मारेइ मारेइ सेल्‍चा जोक्‍ब दुम्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","परमप्रभुमी बेचालेल नु दान आ थर ङा अहीसामाक आ तौ ओहोली-आब आस कली अरु आन कली शेंतीक सक्ति गेशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","मिनु मेको आस कली जोक्‍ब तुइक्‍ब थुं गेशा, गेय पतीक सक्ति नेल्‍ल गेशो बाक्‍ब। मार गेय पचा कली जोक्‍ब तुइक्‍ब सेल्‍शो बाक्‍ब देंशा हना, दारशो मार मार गेय पाइब, मिम्‍शा ब्रेक्‍स ब्रेक्‍शा, नीलो प्‍याजी नु लल श्‍येले बुटा प्रोव़चा नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वामी बुटा आप्‍चा कली जोक्‍ब तुइक्‍ब सेल्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","मिनु परमप्रभु यावेमी बेचालेल, ओहोली-आब नु अरु आन कली आ बाक्‍तीक सेल्‍चा, दे जोक्‍ब तुइक्‍ब नु रुप्‍तीक थुं गेशो मुर नेल्‍लेमी, परमप्रभु यावेमी देंशो खोदेंशो पा गेय पचा माल्‍नीम” दे मोसामी इस्राएली आन कली दें‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","मिनु मोसामी, बेचालेल, ओहोली-आब नु परमप्रभुमी जोक्‍ब तुइक्‍ब सेल्‍शो मुर नेल्‍ल आन कली ब्रेत्‍ताक्‍नमी। सु सु आन थुंमी “गो यो मेको गेय पाइनुङ” दे मिम्‍शो बाक्‍मा, मेको आन कली यो ब्रेत्‍ताक्‍नमी। ");
INSERT INTO suzBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","इस्राएलीपुकीमी परमप्रभु यावे आ बाक्‍तीक सेल्‍चा कली मार मार चाक्‍शो बाक्‍मा, आन थुंमी ग्‍येरशा गेशो नेल्‍ल मोसा आ गुइ रे ताक्‍तेक्म। मेना सम्‍म मुरपुकीमी सुनी कुस कुस मार मार चाक्‍स ङा चाक्‍स बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","मिनु परमप्रभु यावे आ बाक्‍तीक सेल्‍ब जोक्‍ब तुइक्‍बपुकीमी आन गेय प्रोंइशा, मोसा आ बाक्‍तीक जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","मिनु मेकोपुकीमी मोसा कली “परमप्रभु यावेमी अरेशो सेल्‍चा कली माल्‍शो क्‍येङा यो शुश चाक्‍ना चाक्‍न बाक्‍नीम” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","मिनु मोसामी “मुल रे परमप्रभु यावे आ बाक्‍तीक ङा गेय कली सुइम मारेइ मचाक्‍कीन” दे मुर आन बाक्‍तीक बाक्‍तीकेमी नेंपाइक्‍थ मुर सोइक्‍ताक्‍मी। मोपा मारेइ मचाक्‍कीन, दे आन चाक्‍चा नाइक्‍पाइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","मारदे हना आन चाक्‍शो मारेइ मारेइ गाप्‍शा, शुश दुम्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","मिनु जोक्‍ब गेय पाइब नेल्‍लेमी परमप्रभु यावे आ बाक्‍तीक कली १० ओटा सुम्‍तीक वा सेल्‍तेक्‍म। रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के नु नीलो, प्‍याजी नु लल रङ ङा श्‍येलेमी शुश रिम्‍शो करूबपुकी बुटा आप्‍शा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","मेको सुम्‍तीक वा का का पा २८ कुबीत दुइश्‍शो नु ४ कुबीत ब्रेम्‍शो, खाल का ङा पा सेल्‍तेक्‍म। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","मेकोपुकीमी ५ ओटा सुम्‍तीक वा बोइश्‍शा, का सेल्‍तेक्‍म। मिनु अर्को ५ ओटा बोइश्‍शा, अर्को का सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","सुम्‍तीक वा का आ एर सुर गे नीलो रङ ङा ५० ओटा बोइक्‍तीके सेल्‍तेक्‍म। अर्को सुम्‍तीक वा के यो ओंथ सुर गे ५० ओटा नीलो बोइक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","सुम्‍तीक वा कामी ५० ओटा बोइक्‍तीके नु अर्को सुम्‍तीक वा कली यो ५० ओटा बोइक्‍तीके सेल्‍शा, निक्‍शी कली का सेल्‍चा कली ठीक पा वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","मिनु मेकोपुकीमी ५० ओटा सुन के ग्‍याइक्‍पाइक्‍तीके सेल्‍शा, ङोंइती ङा नु नोले ङा सुम्‍तीक वा आस कली बोइश्‍शा, का सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","परमप्रभु यावे आ बाक्‍तीक साप्‍चा कली यो क्‍यारश आ चां के ११ ओटा सुम्‍तीके सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","मेको सुम्‍तीके का का पा ३० कुबीत लाइश्‍शो नु ४ कुबीत ब्रेम्‍शो खाल का ङा पा सेल्‍तेक्‍म। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","मेकोपुकीमी का सेल्‍चा कली ५ ओटा सुम्‍तीके बोइश्‍शा का नु ६ ओटा सुम्‍तीके बोइश्‍शा अर्को का सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ङोंइती ङा सुम्‍तीके आ एर सुर गे ५० ओटा बोइक्‍तीक सेल्‍तेक्‍म। मिनु अर्को सुम्‍तीके आ ओंथ सुर गे यो ५० ओटा बोइक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","मिनु ताम्‍बु सुम्‍तीके का सेल्‍चा कली कांसा के ५० ओटा ग्‍याइक्‍पाइक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","मेकोपुकीमी ताम्‍बु सुम्‍चा कली लल रङ नुप्‍शो सांड आ कुशुल के सुम्‍तीक का सेल्‍तेक्‍म। मेको आ तारी नेल्‍ल क्‍येङा रिम्‍शो सेल्‍शो कुशुल के अर्को सुम्‍तीक का सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","मिनु नोले मेकोपुकीमी परमप्रभु यावे आ बाक्‍तीक सेल्‍चा कली बोल्‍यो शी के फलेक सेल्‍शा, थारतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","फलेक का का पा १० कुबीत लाइश्‍शो नु कुबीत का आधा ब्रेम्‍शो सेल्‍तेक्‍म। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","फलेक का कामी, राप्‍पाइक्‍चा कली किला निक्‍शी गारपाइश्‍शा, सेल्‍तेक्‍म।। परमप्रभु यावे आ बाक्‍तीक सेल्‍चा कली फलेक नेल्‍ल मोदेंशो पा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","मिनु बाक्‍तीके आ दक्‍खिन गे कली २० ओटा फलेक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","मिनु मेको २० ओटा फलेक आन पुं गे, ४० ओटा चांदी के राप्‍पाइक्‍तीके, फलेक का कली राप्‍पाइक्‍तीके निक्‍शी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","उत्तर गे कली २० ओटा फलेक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","मेको आन कली ४० ओटा चांदी के राप्‍पाइक्‍तीके, फलेक का कली राप्‍पाइक्‍तीके निक्‍शी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","बाक्‍तीके आ पच्‍छिम गे कली ६ ओटा फलेक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","पच्‍छिम ङा सुर निक्‍शी कली, फलेक निक्‍शी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","मेकोपुकीम उइ रे ममाइ, इर गे मुन्‍द्रामी ग्‍याइक्‍पाइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","मोपा मेको नेल्‍ल ८ ओटा फलेक दुम्‍तेक्‍म। मिनु १६ ओटा चांदी के राप्‍पाइक्‍तीके, फलेक का कली राप्‍पाइक्‍तीक निक्‍शी दुम्‍त। प्रस्‍थान २६:- ");
INSERT INTO suzBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","बोल्‍यो शी के लाइश्‍शो कोक्‍के सेल्‍तेक्‍म। परमप्रभु यावे आ बाक्‍तीक का पटटी कली फलेक ग्‍याइक्‍पाइक्‍चा कली ५ ओटा लाइश्‍शो कोक्‍के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","अर्को पटटी कली यो फलेक ग्‍याइक्‍पाइक्‍चा कली ५ ओटा लाइश्‍शो कोक्‍के सेल्‍तेक्‍म। आ नोले पच्‍छिम गे कली ५ ओटा लाइश्‍शो कोक्‍के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","मिनु फलेक ग्‍येत्‍थ आ दातेमी सुर का रे अर्को सुर सम्‍म कली लाइश्‍शो कोक्‍के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","मिनु फलेक नु लाइश्‍शो कोक्‍के आन कली सुनम गिल्‍तेक्‍म। मिनु लाइश्‍शो कोक्‍के शुइक्‍चा कली सुन के मुन्‍द्रापुकी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","मिनु नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के नेल्‍ल क्‍येङा चोव़खो कोठा फारतीक का सेल्‍शा, रिम्‍शो पा करूब बुटा आप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","मेकोमी मेको फारतीक कली बोल्‍यो शी के ४ ओटा थाम सेल्‍शा, सुनम गिल्तेक्‍म। मेको आन ग्‍याइक्‍तीके सुन के सेल्‍तेक्‍म। मेको आन कली ४ ओटा चांदी के राप्‍पाइक्‍तीके सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","मिनु नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा दारशो बुटा आप्‍शो ताम्‍बु आ ओव़तीके कली फारतीक का सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","मेको फारतीक ब्‍वेक्‍चा कली ५ ओटा थाम सेल्‍तेक्‍म। मेको आन पिया, ब्‍वेक्‍तीक नु हाम्‍तीक कोक्‍के सुनम गिल्‍तेक्‍म। मेको ५ ओटा थाम आन राप्‍पाइक्‍तीके चहिं कांसा के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","मिनु बेचालेलमी बोल्‍यो शी के सन्‍दोस का सेल्‍तु। मेको आ लाइश्‍शो कुबीत निक्‍शी नु आधा, आ ब्रेम्‍शो कुबीत का नु आधा नु आ ग्‍येत्‍थ लाइश्‍शो कुबीत का नु आधा ङा पा सेल्‍तु। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","मिनु मेको आ खिंङगा नु आ लाङगा नेल्‍ल क्‍येख सुनमी गिल्‍तु। मिनु एर ओंथ नेल्‍ल सुन के सुर सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","मिनु सुन के ४ ओटा मुन्‍द्रा सेल्‍तु। का पटटी निक्‍शी नु अर्को पटटी निक्‍शी पा सन्‍दोस आ ४ सुरमी क्‍येप्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","मिनु बोल्‍यो शी के कुरतीक कोक्‍के निक्‍शी सेल्‍शा, सुनमी गिल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","मिनु मेको कुरतीक कोक्‍के निक्‍शी मुन्‍द्रामी शुइश्‍शा, सन्‍दोस कुरने चाप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","मिनु मेकोमी क्‍येख सुन के चेम्‍शा, सन्‍दोस सुम्‍तीके सेल्‍तु। मेको आ पित्‍थ लाइश्‍शो कुबीत निक्‍शी नु आधा नु आ ब्रेम्‍शो कुबीत का नु आधा सेल्‍तु। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब खोदेंशो सुन के करूब निक्‍शी चेम्‍शा सेल्‍तु। मेको सुम्‍तीके आ निम्‍फा पटटी ङा का का चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","का पटटी करूब का, अर्को पटटी करूब का चेम्‍शा सेला बाक्‍त। मेको सुम्‍तीके नु करूब निम्‍फा मख्रोंइसीशो सुन का रेन चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूब आस फ्रां हाम्‍शा, सुम्‍तीके फारपाइश्‍शा, खाल का ङा पा सन्‍दोस सुम्‍तीके गे कोव़पाइश्‍शा चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बोल्‍यो शी के टेबल का सेल्‍तु। मेको आ पित्‍थ लाइश्‍शो कुबीत निक्‍शी नु आ ब्रेम्‍शो कुबीत का नु आ ग्‍येत्‍थ लाइश्‍शो कुबीत का नु आधा ङा पा सेल्‍तु। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","मिनु मेको कली क्‍येख सुनमी गिल्‍शा, आ एर ओंथ नेल्‍ल सिरपेच खोदेंशो पा सुन के सुर सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","मेको आ एर ओंथ ङा सुर नेल्‍ल ४ गुइ ब्रेम्‍शो सेल्‍शा, सिरपेच खोदेंशो पा बुटा आप्‍शा सेल्‍तु। गुइ का ८ सेन्‍ती मिटर कि ३ आंइची खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","मिनु ४ ओटा सुन के मुन्‍द्रा चेम्‍शा, मेको आ ४ ओटा खोइलीम टेबल आगाम क्‍येप्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","टेबल कुरचा कली मुन्‍द्रापुकी टेबल आ सुर आ नेक्‍था क्‍येप्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","मिनु टेबल कुरचा कली बोल्‍यो शी के कुरतीक कोक्‍के सेल्‍शा, सुनमी गिल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","मिनु टेबलम वोइक्‍चा माल्‍शो थाल, लोटा नु बोस नेल्‍ल नु तूचा थोव़क चढ़ेतीक लुक्‍चा कली लोटा नेल्‍ल क्‍येख सुन के सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","मेकोमी क्‍येख सुन के बत्ती दातीक का चेम्‍शा सेल्‍तु। आ थाम, आ राशी, आ दियारी, आ डल्‍ला नु फूपुकी ठेयब सुन का केन सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","मिनु मेको बत्ती दातीक आ थाम रे ६ ओटा राशी ग्रुंइशा, का पटटी रे सां नु अर्को पटटी रे सां राशी चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","मिनु मेको राशी कामी देसी बदाम आ फू खोदेंशो फू सां नु डल्‍ला सां रे ग्रुंइशो सेल्‍तु। अर्को राशीपुकी यो नेल्‍ल मोदेंशो पा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","मेको बत्ती दातीक आ थामम चहिं ४ ओटा देसी बदाम आ फू खोदेंशो आन डल्‍ला रे ग्रूशो सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","थाम आ ङोंइती ङा डल्‍ला रे, आ दाते ङा डल्‍ला रे नु नोले ङा डल्‍ला रे निम्‍फा पटटी गे राशी निक्‍‍निक्‍शी ग्रूशो सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","मेको आ राशी नु डल्‍ला नेल्‍ल ठेयब क्‍येख सुन का केन चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","बत्ती दातीक ७ ओटा दियारी, आ कांइची नु आइक्‍च बोस नेल्‍ल क्‍येख सुन के चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","मेको नेल्‍ल टलेन्ट का क्‍येख सुन के चेम्‍शा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","धूप चोशा चढ़ेतीके बोल्‍यो शी के कुबीत का लाइश्‍शो नु कुबीत का ब्रेम्‍शो ४ पाटे पा सेल्‍तु। आ ग्‍येत्‍थ लाइश्‍शो कुबीत निक्‍शी ङा सेल्‍तु। मेको नु मेको आ ग्रोव़ नेल्‍ल मख्रोंइसीशो शी का केन सेल्‍तु। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","मिनु मेको नेल्‍ल क्‍येख सुनमी गिल्‍शा, सिरपेच के खोदेंशो पा सुन के सुर सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","मेको आ सुर आगा निम्‍फा पटटी कली सुन के मुन्‍द्रा निक्‍‍निक्‍शी सेल्‍शा, आ सिरपेच खोदेंशो सुर आ दी निम्‍फा पटटी गे क्‍येप्‍ताक्‍व। मिनु मेको कुरतीक कोक्‍के शुइक्‍तीक दुम्‍त ");
INSERT INTO suzBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","मिनु मेको कुरचा कली बोल्‍यो शी के कुरतीक कोक्‍के निक्‍शी सेल्‍शा, सुनम गिल्तु। ");
INSERT INTO suzBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","मिनु मेकोमी ताम्‍बु ङा लुक्‍तीक तेल नु ब्रोव़शो रिना पाइब धूप जोक्‍ब मुरुम सेल्‍शो खोदेंशो पा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","मिनु बेचालेलमी बोल्‍यो शी के चोशा चढ़ेतीके सेल्‍तु। मेको ५ कुबीत लाइश्‍शो नु ५ कुबीत ब्रेम्‍शो, ४ पाटे नु कुबीत सां ग्‍येत्‍थ लाइश्‍शो पा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","आ ४ सुरमी ग्रोव़ सेल्‍तु। मेको ग्रोव़पुकी मेको चढ़ेतीक फलेक का केन सेल्‍शा, कांसामी गिल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","चढ़ेतीके कली माल्‍शो मारेइ मारेइ कांसा के सेल्‍तु। पुलु वोइक्‍तीक बोसपुकी, पुलु ताप्‍तीकपुकी, ब्रुइक्‍तीक बोसपुकी, श्‍ये ग्रुंइतीक कांटापुकी नु मी कोइला कुर पतीकपुकी सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","चोशा चढ़ेतीक कली कुबीत का नु आधा ङा पा ग्‍येत्‍थ पा मी तिक्‍तीक कांसा के जाली सेल्‍तु। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","कुरतीक कोक्‍के शुइक्‍चा कली, ४ ओटा मुन्‍द्रा सेल्‍शा, आ ४ सुरमी क्‍येप्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","बोल्‍यो शी के कुरतीक कोक्‍के निक्‍शी सेल्‍शा, कांसामी गिल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","चढ़ेतीक कुरचा कली मेको कोक्‍के मुन्‍द्राम शुइक्‍ताक्‍व। फलेक के सेल्‍शो चोशा चढ़ेतीके आगाम श्‍येत्‍थ बाक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","बेचालेलमी कांसा के चिक्‍तीक ठेयब बोस नु आ निप्‍पाइक्‍तीके सेल्‍तु। मेको ग्रुम्‍तीक ताम्‍बु ओव़तीकेम गेय पाइब मीश मुर आन कांसा के ऐना के सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","मिनु बेचालेलमी ताम्‍बु आ लाङगा थरपु हिरचा कली रिम्‍शो पा किरशो सुती श्‍येले के वा प्रोव़पाइक्‍तु। मेको फारतीक दक्‍खिन गे सहे का कुबीत लाइश्‍शो पा सेल्‍तु। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","मेको फारतीक ग्‍याइक्‍पाइक्‍चा कली खाल का ङा थाम नु खाल का ङा कांसा के राप्‍पाइक्‍तीके के सेल्‍तु। मुन्‍द्रापुकी नु कोक्‍केपुकी चहिं चांदी के सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","मिनु मोदेंशो पा उत्तर गे यो सहे का कुबीत लाइश्‍शो फारतीक प्रोव़पाइक्‍तु। मेको कली २० ओटा थाम, २० ओटा कांसा के राप्‍पाइक्‍तीके सेल्‍तु। मुन्‍द्रापुकी नु कोक्‍केपुकी चहिं चांदी के सेल्‍तु। सहे का कुबीत ५० मिटर बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पच्‍छिम गे ५० कुबीत ङा फारतीक सेल्‍तु। मेको कली १० ओटा थाम नु १० ओटा राप्‍पाइक्‍तीके सेल्‍तु। आन मुन्‍द्रा नु कोक्‍केपुकी चहिं चांदी के सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","मिनु लाङगा आ ङोंइती पूर्ब गे कली ५० कुबीत ङा फारतीक वा सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ओव़तीके पटटी का कली १५ कुबीत ङा फारतीक वा सेल्‍तु। थाम नु राप्‍पाइक्‍तीके सां सां सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","मिनु ओव़तीके ङा अर्को पटटी कली यो १५ कुबीत ङा फारतीक वा सेल्‍तु। थाम नु राप्‍पाइक्‍तीके सां सां सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","लाङगा ङा एर ओंथ नेल्‍ल ङा फारतीक रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","मेको थाम आन राप्‍पाइक्‍तीक कांसा के बाक्‍तेक्‍म। थाम आन मुन्‍द्रा नु कोक्‍केपुकी चहिं चांदी के बाक्‍तेक्‍म। थाम आन पिया चांदीम गिल्‍शो बाक्‍तेक्‍म। थाम आन फ्रेंतीके नेल्‍ल चांदी के बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","मेको लाङगा ङा ओव़तीके ङा फारतीक नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वाम दारशो बुटा आप्‍शा सेल्‍तु। मेको आ लाइश्‍शो २० कुबीत नु आ ग्‍येत्‍थ ५ कुबीत ङा पा अर्को फारतीक नु उइक्‍थ उइक्‍थ पा सेल्‍तु। कुबीत का ०.५ मिटर, हात का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","मिनु ओव़तीक ङा ४ ओटा थाम नु आन ४ ओटा राप्‍पाइक्‍तीके कांसा के बाक्‍तेक्‍म। मेको फारतीक कली ब्‍वेक्‍तीक, थाम आन पिया नु फ्रेंतीके चांदी के बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","मिनु परमप्रभु यावे आ बाक्‍तीके नु लाङगा ङा किला नेल्‍ल कांसा के बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","परमप्रभु यावे आ बाक्‍तीक सेल्‍चा कली मार मार माल्‍दा, मेको ब्रेक्‍शो बाक्‍त। मेको बाक्‍तीके कबल पशो सन्‍दोस वोइक्‍तीके बाक्‍त। मोसामी “मेको नेल्‍ल ब्रेक्‍चा माल्‍ब” दे अरेशो बाक्‍त। चढ़ेब हारून आ तौ इथामार लेवी आन कली गेय पपाइक्‍ब बाक्‍त। गन्‍ती ४:२८ ");
INSERT INTO suzBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","परमप्रभु यावेमी मोसा कली शेंशो खोदेंशो पा, यहूदा आ थर ङा हुर आ चच, ऊरी आ तौ बेचालेलमी मारेइ मारेइ सेल्‍तु। प्रस्‍थान ३१:१-११ ");
INSERT INTO suzBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","मेको नु दान आ थर ङा अहीसामाक आ तौ ओहोली-आब यो बाक्‍त। मेको मार मार मुशा सेल्‍तीक गेय जोक्‍ब, ब्रेक्‍स ब्रेक्‍शा सेल्‍चा जोक्‍ब नु नीलो, प्‍याजी नु लल रङ ङा रिम्‍शो पा किरशो सुती श्‍येलेम दारशो बुटा आप्‍तीक गेय यो जोक्‍ब बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","परमप्रभु यावे आ बाक्‍तीक नु मेकेर माल्‍शो मारेइ मारेइ सेल्‍चा कली मुर आन गेशो सुन गिश दुम्‍माक्‍त देंशा हना, २९ टलेन्‍ट नु ७ सहे ३० शेकेल दुम्‍त। नेल्‍ल नाक्‍शा, हजार का किलो खोदेंशो दुम्त। टलेन्‍ट का ३४ किलो बाक्‍ब। शेकेल का ११.५ ग्राम, तोला का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ङोंइती हिक्‍शो वोंइश मुर आन रे पोक्‍शो चांदी सहे का टलेन्‍ट नु हजार का ७ सहे ७५ शेकेल दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","मिनु २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो वोंइश मुर ६ लाख हजार सां ५ सहे ५० जना बाक्‍तेक्‍म। मेको आन के का का पा आधा आधा शेकेल पोक्‍तेक्‍म। प्रस्‍थान ३०:१२-१६; गन्‍ती १:४६ ");
INSERT INTO suzBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ताम्‍बु आन फलेक राप्‍पाइक्‍तीक नु नेल्‍ल क्‍येङा चोव़खो कोठा कली फारतीक ङा थाम आन राप्‍पाइक्‍तीक कली सहे का टलेन्‍ट माल्ताक्‍व। सहे का राप्‍पाइक्‍तीके कली सहे का टलेन्‍ट माल्ताक्‍व। का कली टलेन्‍ट का माल्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","मेको हजार का ७ सहे ७५ शेकेल चांदीमी ब्‍वेक्‍तीक सेल्‍शा, थाम आन पिया गिल्तीक नु आन फ्रेंतीकपुकी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","मुर आन चाक्‍शो कांसा ७० टलेन्‍ट नु हजार निक्‍शी ४ सहे शेकेल दुम्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","मेको के ग्रुम्‍तीक ताम्‍बु ङा ओव़तीके ङा थाम आन राप्‍पाइक्‍तीके, कांसा के चोशा चढ़ेतीके, आ मी तिक्‍तीक जाली नु चढ़ेतीक आ मारेइ मारेइ सेल्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","मिनु लाङगा ङा थाम आन राप्‍पाइक्‍तीकपुकी, ठेयब ओव़तीके ङा थाम आन राप्‍पाइक्‍तीकपुकी, ताम्‍बु नु लाङगा ङा किला नेल्‍ल सेल्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा बेचालेल नु आ मुरपुकीमी हारून कली परमप्रभु यावे आ बाक्‍तीकेमी गेय पचा कली नीलो प्‍याजी नु लल रङ ङा श्‍येले के प्रोव़शो फेक्‍तीक वा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","मेकोमी कुचु तार वोइक्‍तीके सुन के, नीलो, प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","मिनु सुन तुप्‍शा, पात्‍लो सेल्‍शा, आइक्‍च पा ख्रोइश्‍शा, श्‍येले खोदेंशो सेल्‍तेक्‍म। मिनु नीलो, प्‍याजी नु लल श्‍येलेमी रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा दारशो बुटा आप्‍शा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","मेको कुचु तार वोइक्‍तीकेमी बलाम सुम्‍तीके निक्‍शी सेल्‍शा, निम्‍फा पटटी बोइक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","मिनु आ पाइक्‍तीके मेको कुचु तार वोइक्‍तीके का रेन सेल्‍तेक्‍म। मेको खाल का ङा पा रिम्‍शो पा सेल्‍तेक्‍म। मेको पाइक्‍तीके सुन, नीलो, प्‍याजी नु लल रङ ङा श्‍येले नु रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍तेक्‍म। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","मिनु मेकोमी ओनीक्‍स हीरा निक्‍शी चाक्‍शा, इस्राएल आ तौ आन नें छाप खोदेंशो पा हीराम मुशा ब्रेक्‍शा सुनम क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","मेको हीरा निक्‍शी कुचु तार वोइक्‍तीक आ बला ङा टुक्रा तारी फेरतेक्‍म। मिनु मेको हीरा इस्राएल आ तौ आन कली मिम्‍चा कली बाक्‍ब। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा सेल्‍तेक्‍म। प्रस्‍थान २८:१२ ");
INSERT INTO suzBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","मेकोमी निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला सेल्‍पाइक्‍तु। कुचु तार वोइक्‍तीके खोदेंशो पा सुन, नीलो, प्‍याजी नु लल श्‍येले नु रिम्‍शो पा किरशो सुती के प्रोव़शो वा के दारशो पा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","मेको खेयप का मुक्‍शोनु, बित्‍ता का लाइश्‍शो नु बित्‍ता का ब्रेम्‍शो ४ पाटे पा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","मिनु ४ लस्‍कर हीरा सुनम का का पा क्‍येप्‍ताक्‍म। ङोंइती ङा लस्‍कर लल मानीक माइश्‍शो हीरा, हाव पुश्‍पराज माइश्‍शो हीरा नु गिगी बेरूज माइश्‍शो हीरा क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","मेको आ नोले ङा लस्‍कर लल फिरोजा माइश्‍शो हीरा, बुश नीर माइश्‍शो हीरा नु बुश नु नीलो पन्‍ना माइश्‍शो हीरा क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","मेको आ नोले ङा लस्‍कर गिगी नु नीलो रङ ब्‍वाइश्‍शो रिम्‍शो टल्‍केशो नीलमनी माइश्‍शो हीरा, गिगी हाकीक माइश्‍शो हीरा नु प्‍याजी रङ ङा कटेला माइश्‍शो हीरा क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","मिनु नेल्‍ल क्‍येङा नोले ङा लस्‍कर पीतमनी माइश्‍शो हीरा, लल रङ ङा ओनीक्‍स नु नीलो बिलौरा माइश्‍शो हीरा क्‍येप्‍ताक्‍म। मोपा हीरा नेल्‍ल कली सुनम क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","मेको हीरा १२ ओटा बाक्‍तेक्‍म। मिनु इस्राएल आ तौ आन नें का का पा मेको आन तार छाप थोक्‍शो खोदेंशो पा मुशा ब्रेक्‍शो बाक्‍तेक्‍म। हीरा का आ तारी थर का आ नें ब्रेक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","मेको निसाफ पतीक झोला कली क्‍येख सुन के डोरी किरशो खोदेंशो पा सिक्री सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","मेकोपुकीमी निसाफ पतीक झोला कली सुन के ग्‍याइक्‍तीक निक्‍शी नु मुन्‍द्रा निक्‍शी चेम्‍तेक्‍म। मिनु मेको मुन्‍द्रा निसाफ पतीक झोला आ सुर निक्‍शीमी वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","मेकोपुकीम सुन के सिक्री निक्‍शी निसाफ पतीक झोला आ सुरम वोइश्‍शो मुन्‍द्रा निक्‍शीमी लिक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","मेको सिक्री निक्‍शी चढ़ेब आ कुचु तार वोइश्‍शो वा आ बला ङा हीरा क्‍येप्‍शो सुनम हेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","मेकोपुकीमी सुन के मुन्‍द्रा निक्‍शी सेल्‍तेक्‍म। मेको निक्‍शी निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला आ उइ आगा गे पाइक्‍ताक्‍म। मोपा मेको झोला कुचु तार वोइक्‍तीके वा आ तार बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","मेकोपुकीमी लेंशा सुन के मुन्‍द्रा निक्‍शी सेल्‍तेक्‍म। कुचु तार वोइक्‍तीके आ बला सुम्‍तीके उइ ङा सुरम वोइक्‍तेक्‍म। दारपाइश्‍शो पाइक्‍तीके आ तारी क्‍येप्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","मिनु मेको निसाफ पतीके ऊरीम नु थुम्‍मीम वोइक्‍तीक झोला आ मुन्‍द्रामी नीलो डोरीम लिक्‍शा, कुचु तार वोइक्‍तीक वामी पाइक्‍ताक्‍म। मोपा मेको निसाफ पतीके झोला दारपाइश्‍शो पाइक्‍तीक तार बाक्‍शो कुचुम वोइक्‍तीक वा रे एर ओंथ मयाक्‍सेक्‍ल, दे पाइक्‍ताक्‍म। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","मिनु मेको कुचु तार वोइक्‍तीके आगा फेक्‍तीक नेल्‍ल नीलो प्‍याजी रङ ङा वा के फेरतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","मिनु पिया ख्रीतीक पोव़ला सेल्‍तेक्‍म। मेको पोव़ला आ एर ओंथ मगाक्‍चा ङा पा आ सुर थम बोल्‍यो पा प्रोव़तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","मेको फेक्‍तीके आ उइ ङा सुर एर ओंथ गे नीलो, लल नु प्‍याजी रङ नु रिम्‍शो किरशो सुती श्‍येले के प्रोव़शो वा के सेल्‍शो दारीम क्‍युक्‍शा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","मिनु मेकोपुकीम क्‍येख सुन के आइक्‍च किङगो सेल्‍तेक्‍म। फेक्‍तीक उइ गे किङगो का दारीम का ख्राक्‍शा क्‍युक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","किङगो का दारीम का नु किङगो का दारीम का पा ख्राक्‍शा, बिर हिरशा क्‍युक्‍तेक्‍म। मेको परमप्रभु यावे आ ङोंइती गेय पची ना फेक्‍तीक वा दुम्‍त। परमप्रभु यावेम मोसा कली दोपा अरेवा मोपा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","हारून नु आ तौ आन कली रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के फेक्‍तीक यो सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के पियाम रुक्‍तीक नु गुक्‍तीक ताकी नु सुरुवाल सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","रिम्‍शो पा किरशो सुती श्‍येले के प्रोव़शो वा के नीलो, प्‍याजी नु लल रङ ङा श्‍येलेमी दारशो बुटा आप्‍शो किप्‍तीकपुकी सेल्‍तेक्‍म। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","मेकोपुकीमी क्‍येख सुन के फू खोदेंशो पा कुप्‍फीम पांइतीके चेम्तेक्‍म। मेकेर छाप मुशो खोदेंशो पा “परमप्रभु यावे कली ला” दे मुशा ब्रेक्‍ताक्‍म। प्रस्‍थान २९:६; प्रस्‍थान २७:३६; लेवी ८:९; जकरिया १४:२०; ");
INSERT INTO suzBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","कुप्‍फीम पांइतीके कली पियाम गुक्‍तीकेमी नीलो श्‍येलेमी फ्रेंताक्‍म। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","मिनु परमप्रभु यावे आ बाक्‍तीक ग्रुम्‍तीक ताम्‍बु ङा गेय नेल्‍ल नुम्‍त। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा इस्राएल ङा मुरपुकीमी नेल्‍ल सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","मिनु मेकोपुकीमी परमप्रभु यावे आ बाक्‍तीक नु आ मारेइ मारेइ मोसा आ बाक्‍तीकेमी चाक्‍तेक्‍म। मार मार चाक्‍ग‍मे बाक्‍त देंशा हना, ताम्‍बु नु आ ग्‍योंब नेल्‍ल, ब्‍वेक्‍तीक, फलेक, लाइश्‍शो कोक्‍के, थाम नु राप्‍पाइक्‍तीकपुकी, ");
INSERT INTO suzBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","लल रङम नुप्‍शो सांड आ कुशुल के सुम्‍तीके, नेल्‍ल क्‍येङा रिम्‍शो कुशुल के सुम्‍तीके, फारतीके, ");
INSERT INTO suzBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","कबल पशो सन्‍दोस, मेको आ कुरतीक कोक्‍के नु सुम्‍तीके, ");
INSERT INTO suzBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","टेबलम वोइक्‍चा माल्‍शो मारेइ मारेइ नु कोंइतीक शोब्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","क्‍येख सुन के बत्ती दातीके नु आ दियारी आन कली ठीक सेल्‍तीके थोव़क नु बत्ती कली तेल, ");
INSERT INTO suzBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सुन के चढ़ेतीक, लुक्‍चा कली तेल, ब्रोव़शो रिना पाइब धूप, ताम्‍बु ओव़तीके ङा फारतीक वा, ");
INSERT INTO suzBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","कांसा के चढ़ेतीक, मेको आ कांसा के मी तिक्‍तीक जाली, कुरतीक कोक्‍के नु चढ़ेतीक आ मारेइ मारेइ, चिक्‍तीक ठेयब बोस नु मेको निप्‍पाइक्‍तीके, ");
INSERT INTO suzBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ताम्‍बु आ लाङगा ङा फारतीक नु थामपुकी, आन राप्‍पाइक्‍तीकपुकी, लाङगा ओव़तीक ङा फारतीक वा, आ फ्रेंतीकपुकी नु किलापुकी, मिनु परमप्रभु यावे आ बाक्‍तीक ग्रुम्‍तीक ताम्‍बु ङा गेय पचा कली मारेइ मारेइ नेल्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","परमप्रभु यावे आ बाक्‍तीक ङा गेय पचा कली हारून कली फेक्‍तीक वा नु आ तौ आन कली परमप्रभु यावे कली चढ़ेब दुम्‍चा कली आन फेक्‍शा गेय पतीके वा नेल्‍ल चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा इस्राएल ङा मुरपुकीमी सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मिनु मोसामी मेको नेल्‍ल कोव़तु। मिनु परमप्रभु यावेमी दोपा अरेवा, मोपा ठीक सेल्‍शो तशा, मोसामी मेको नेल्‍ल आन कली आसीक गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ङोंइती ङा महिना ङा ङोंइती नाक्‍ती, आं बाक्‍तीके ग्रुम्‍तीक ताम्‍बु कीङो। प्रस्‍थान ४०:१७; प्रस्‍थान १२:२; प्रस्‍थान १९:१ ");
INSERT INTO suzBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","गे कबल पशो सन्‍दोस आगाम वोइश्‍शा, फारतीक वाम फारदो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","टेबल ओंइशा, मेको तारी मार मार वोइक्‍चा माल्‍बा, ठीक पा वोतो। मिनु बत्ती दातीके ओंइशा आ दियारी दाङो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","सुन के धूप चोशा चढ़ेतीके कबल पशो सन्‍दोस आ ङोंइती वोतो। आं बाक्‍तीक आ ओव़तीक ङा फारतीक वा क्‍युक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ ङोंइती चोशा चढ़ेतीके वोतो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आस दातेम चिक्‍तीक ठेयब बोस वोइश्‍शा, ब्‍वाक्‍कुम प्रिंदो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","लाङगा ङा थाम वोइश्‍शा, एर ओंथ हिरशा फारतीक वा नु ओव़तीक ङा फारतीक वा क्‍युक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","मिनु गे लुक्‍चा कली तेल चाक्‍शा, आं बाक्‍तीक नु मेकेर ङा मारेइ मारेइ आन कली ‘परमप्रभु यावे केन बाक्‍ब’ दे तेल लुक्‍तो। मोपा मेको नेल्‍ल आं के दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","चोशा चढ़ेतीक नु मेको आ मारेइ मारेइ आन कली यो ‘परमप्रभु यावे केन बाक्‍ब’ दे तेल लुक्‍तो। मोपा मेको नेल्‍ल यो आं के दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","चिक्‍तीक ठेयब बोस नु मेको आ निप्‍पाइक्‍तीके कली यो तेल लुक्‍तो। मिनु मोपा मेको आं के दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","मिनु हारून नु आ तौ आन कली, ग्रुम्‍तीक ताम्‍बु ङा ओव़तीकेम चाक्‍शा चिक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","आं कली चढ़ेब दुम्‍पाइक्‍चा कली हारून कली चढ़ेतीक वा फेक्‍पा, तेल लुक्‍शा आं कली जिम्‍मा गेयी। ");
INSERT INTO suzBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","आ तौ आन कली यो चाक्‍शा, वा फेक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","आन आफ कली खोदेंशो पा मेको आन कली यो तेल लुक्‍तो। मेकोपुकी यो चढ़ेब दुम्‍शा, आं गेय पचा माल्‍नीम। मेको तेल लुक्‍तीके आन चच युइ आन पाला नेल्‍लेमी गेना हना यो आं कली चढ़ेब दुम्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मिनु परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","इजीप्‍त रे गाक्‍मा आ नोले जाक्‍शो बर्स आ ङोंइती ङा महिना, ङोंइती ङा नाक्‍ती परमप्रभु यावे आ बाक्‍तीक ताम्‍बु कीतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोसामी परमप्रभु यावे आ बाक्‍तीक ताम्‍बु कीशा, राप्‍पाइक्‍तीकपुकी वोइक्‍तु। मिनु फलेक थारशा, लाइश्‍शो कोक्‍के शुइश्‍शा, थाम राप्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","परमप्रभु यावे आ बाक्‍तीक तारी सुम्‍तीके यो कोप्‍ताक्‍व। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मिनु मोसामी परमप्रभु यावे आ अरेशो लोव़ मुशा ब्रेक्‍शो फुल्‍लु कबल पशो सन्‍दोसम कुर पाप्‍तु। मिनु कबल पशो सन्‍दोसम कुरतीक कोक्‍के शुइक्‍ताक्‍व। मिनु मेको आ तार सुम्‍तीकेम सुम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","मेको कबल पशो सन्‍दोस परमप्रभु यावे आ बाक्‍तीके ओंइशा, फारतीक वामी फारताक्व। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मोसामी टेबल कली ग्रुम्‍तीक ताम्‍बुम ओंइशा, फारतीक वा आ ङोंइती उत्तर गे वोइक्‍‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","टेबल तारी परमप्रभु यावे आ ङोंइती कोंइतीक शोब्‍ले वोइक्‍तु। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","टेबल नु एर ओंथ पा दक्‍खिन गे बत्ती दातीक कली ग्रुम्‍तीक ताम्‍बुम वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","परमप्रभु यावे आ ङोंइती दियारी दातु। मिनु परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","मिनु मोसामी सुन के सेल्‍शो धूप चोशा चढ़ेतीके कली ग्रुम्‍तीक ताम्‍बु ङा फारतीक वा आ ङोंइती वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","मिनु मेकेर ब्रोव़शो रिना पाइब धूप चोप्‍तु। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","नोले ताम्‍बु ङा ओव़तीकेम फारतीक वा क्‍युक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","मिनु चोशा चढ़ेतीके परमप्रभु यावे आ बाक्‍तीके ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी वोइक्‍तु। मिनु मेकेर चोशा चढ़ेतीक नु अन्‍न चढ़ेतीके चढ़ेप्‍तु। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","मोसामी ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आस दातेमी चिक्‍तीक ठेयब बोस वोइश्‍शा, चिक्‍चा कली ब्‍वाक्‍कुम प्रिंताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मिनु मोसा, हारून नु हारून आ तौपुकीमी आन गुइ खोइली चिक्‍साक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ग्रुम्‍तीक ताम्‍बुमी ओव़शा चढ़ेतीकेम लमानु, आन गुइ खोइली चिक्‍चा माल्‍तेक्‍म। परमप्रभु यावेमी मोसा कली दोपा अरेवा, मोपा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","मोसामी ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आ लाङगा एर ओंथ नेल्‍ल थरपु हिरशा, आ ओव़तीके ङा फारतीक वा क्‍युक्‍तु। मोपा मोसामी ग्रुम्‍तीक ताम्‍बु ङा गेय नेल्‍ल थुम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","मिनु गोस्‍सुमी ग्रुम्‍तीक ताम्‍बु सुम्‍तु। परमप्रभु यावे आ सक्ति नु छेङछेङमी मेको आ बाक्‍तीक ब्रीत। इजीकीएल ४३:१-९ ");
INSERT INTO suzBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मिनु मोसा ग्रुम्‍तीक ताम्‍बुमी ओव़ने मचब। मारदे हना मेको गोस्‍स मेको तारी बाक्‍शा, परमप्रभु यावे आ सक्ति नु छेङछेङमी आ बाक्‍तीक ब्रीत। गन्‍ती ७:८९ ");
INSERT INTO suzBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","मेको गोस्‍स परमप्रभु यावे आ बाक्‍तीक तारी रे ग्‍येत्‍थ बोक्‍मेनु, इस्राएलीपुकी गाक्‍चा गोम्‍तेक्‍म। प्रस्‍थान १३:२१; गन्‍ती ९:१५-२३; गन्‍ती १०:३४-३६; १राजा ८:१०-११; यसैया ४:५ ");
INSERT INTO suzBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","मेको गोस्‍स ग्‍येत्‍थ मबोक्‍म सम्‍म इस्राएली मेक उइ बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","नाक्‍ती परमप्रभु यावे आ गोस्‍स आ बाक्‍तीक तारी बाक्‍त। नाक्‍दो चहिं मेको गोस्‍स आगाम मी दुम्‍त। इस्राएली गोरशो रागीम गाक्‍मा सम्‍म मोदेंशो दुम्‍स ङा दुम्‍स पा नेल्‍लेमी ताम्‍तेक्‍म।");
INSERT INTO suzBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","मिनु परमप्रभु यावेमी ग्रुम्‍तीक ताम्‍बु रे ब्रेश्‍शा मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","गे “इस्राएली आन कली ‘इन दाते ङा सुइम परमप्रभु यावे कली इन बी ब्‍यफ, क्‍यारश भेडा चढ़ेनीनु, आंम इन बगाल रे चढ़ेने। ");
INSERT INTO suzBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","मेको चढ़ेशो बी ब्‍यफ चोशा चढ़ेतीक बाक्‍त हना, मेकोमी मारेइ मदुम्‍शो थमा रिम्‍शो बाछा चढ़ेचा माल्‍ब। मेकोमी मेको ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम चाक्‍चा माल्‍ब। मिनु मेको इन पर्बम परमप्रभु आ ङोंइती ब्रतीके दुम्‍ब। लेवी १७:४ ");
INSERT INTO suzBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","मेकोमी आ गुइ चोशा चढ़ेतीक बस्‍तु आ पिया तारी वोइक्‍चा माल्‍ब। मिनु मेको परमप्रभु यावे आ ङोंइती ब्रशा मेको मुर आ पर्बम पाप क्‍याम्‍तीक गेय बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","मेकोमी मेको बाछा कली परमप्रभु यावे आ ङोंइती क्‍योरशा साइक्‍चा माल्‍ब। मिनु चढ़ेब हारून आ तौपुकीमी मेको हुश चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍नीम। मेको चढ़ेतीक ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","मिनु मेको नोले मेकोमी मेको चोशा चढ़ेतीक आ कुशुल उक्‍शा टुक्रा टुक्रा पा चेक्‍चा माल्‍ब। लेवी ७:८ ");
INSERT INTO suzBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","चढ़ेब हारून आ तौपुकीमी चढ़ेतीक तार मी सुइश्‍शा मेको तार शी गारपाइश्‍शा वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","मिनु चढ़ेब हारून आ तौपुकीमी चढ़ेतीके तारी वोइश्‍शो शी आ तार मेको चेक्‍शो श्‍ये पिया नु बोंसो गार पा वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","मेकोमी मेको आ गा क्‍यी नु खोइली चहिं ब्‍वाक्‍कुम मुरचा माल्‍नीम। मिनु चढ़ेबपुकीमी मेको नेल्‍ल कली चढ़ेतीकेमी चोचा माल्‍नीम। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। उत्‍पत्ती ८:२१; प्रस्‍थान २९:१८ ");
INSERT INTO suzBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","मेको आ चोशा चढ़ेतीक आ बगाल ङा क्‍यारश भेडा बाक्‍तेक्‍म हना, मेकोमी मारेइ मदुम्‍शो थम रिम्‍शो बोका, सांड चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","मेकोमी परमप्रभु यावे आ ङोंइती चढ़ेतीक आ उत्तर गे मेको क्‍योरशा साइक्‍चा माल्‍ब। मिनु चढ़ेब हारून आ तौपुकीमी मेको आ हुश चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","मेको चढ़ेबमी मेको चढ़ेशो कली टुक्रा टुक्रा पचा माल्‍नीम। आ पिया बोंसो सुन्‍दा चेक्‍चा, श्‍ये नु काथा शी तारी गारपाइश्‍शा, चढ़ेतीक ङा मी तारी वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","मेकोमी मेको आ गा क्‍यी नु खोइली चहिं ब्‍वाक्‍कुम मुरचा माल्‍नीम। मिनु चढ़ेबपुकीमी मेको नेल्‍ल कली चढ़ेतीकेमी चोचा माल्‍नीम। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","मिनु परमप्रभु यावे कली चोशा चढ़ेतीके चिक्‍ब बाक्‍तेक्‍म हना, ढुकुर कि परवा चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","चढ़ेबमी मेको चढ़ेतीक आ नेक्‍था मेको आ पिया प्रोइश्‍शा साइक्‍चा माल्‍ब। मिनु मेको कली चढ़ेतीकेमी चोचा माल्‍ब। मिनु आ हुश चहिं चढ़ेतीक आ नेक्‍था चिरचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","मेकोमी मेको आ सोके फेश्‍शा चढ़ेतीक आ पूर्ब गे ङा पुलु ताइक्‍तीकेम ताइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","मेकोमी मेको कली मचेक्‍थु, फ्रां आस दाते रे चेत्‍चा माल्‍ब। मिनु चढ़ेबमी चढ़ेतीक ङा मी तार ङा शीम मेको चोचा माल्‍ब। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","मिनु सुइ मुरुमी परमप्रभु यावे कली अन्‍न चढ़ेचा थुं पाप्‍तु हना, मेको अन्‍न चढ़ेतीक थम रिम्‍शो फस बाक्‍चा माल्‍ब। मिनु मेकोमी मेकेर तेल लुक्‍शा, धूप सुप्‍चा माल्‍नीम। लेवी ७:१०; गन्‍ती १५:४ ");
INSERT INTO suzBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","मिनु मेकोमी मेको चढ़ेब हारून आ तौ आन बाक्‍तीके चाक्‍चा माल्‍ब। मिनु चढ़ेबमी मेको तेल नु धूप ब्‍वाइश्‍शो रिम्‍शो फस मुठी का हुइश्‍शा, मीम चोचा माल्‍ब। मिनु मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","मेको अन्‍न चढ़ेशो रे लीशो चहिं हारून नु आ तौ आन के दुम्‍ब। मेको परमप्रभु यावे कली मीम चोशा चढ़ेतीक ङा नेल्‍ल क्‍येङा चोव़खो चोशा चढ़ेतीक बाक्‍ब। लेवी ६:२२ ");
INSERT INTO suzBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","अन्‍न चढ़ेतीक चाक्‍चा थुं पाम्‍तेक्‍म हना, चो‍शो शोब्‍‍ले चाक्‍चा माल्‍नीम। मेको शोब्‍ले रिम्‍शो फस के, तेलमी निशा बोरब ओख्‍ती मसुप्‍थु चोचा माल्‍नीम। बटुक तेलमी निशा बोरब ओख्‍‍ती मसुप्‍शो दुम्‍चा माल्‍नीम। तेलम मनिशो बाक्‍त हना, शोब्‍ले कली तेल ख्रेक्‍शो बाक्‍‍चा माल्‍ब। लेवी ७:९ ");
INSERT INTO suzBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","मिनु इन चढ़ेतीक अन्‍न बाक्‍त हना, तेल ब्‍वाइश्‍शो बोरब ओख्‍ती मसुप्‍शो रिम्‍शो फस बाक्‍‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","मेको आइक्‍च आइक्‍च सेल्‍शा, तेल लुक्‍चा माल्‍ब। मेको अन्‍न चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","इन चढ़ेतीक दिउरेम क्‍येशो अन्‍न चढ़ेतीक बाक्‍त हना, मेको तेलम क्‍येशो रिम्‍शो फस के दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","मोपा चोशो क्‍येशो अन्‍न चढ़ेतीक परमप्रभु यावे आ बाक्‍तीक लाइक्‍चा माल्‍नीम। मिनु मेको चढ़ेब आन बाक्‍तीक चाक्‍मे नोले चढ़ेबमी मेको चढ़ेतीक आ नेक्‍था चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","मिनु चढ़ेबमी मेको अन्‍न चढ़ेतीक रे मुठी का हुइश्‍शा, मेको चढ़ेतीक ङा मीम चोचा माल्‍ब। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","मेको अन्‍न चढ़ेतीके आ लीशो चहिं हारून नु आ तौ आन के दुम्‍ब। मेको परमप्रभु यावे कली मीम चोशा चढ़ेतीक ङा नेल्‍ल क्‍येङा चोव़खो चोशा चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","गेपुकीमी परमप्रभु यावे कली अन्‍न चढ़ेतीकेमी गेनायो बोरब ओख्‍ती सुप्‍चा मदुम्‍ब। परमप्रभु यावे कली मीम चोशा चढ़ेतीकेमी बोरब ओख्‍ती नु खुदो गेनायो चोचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","खुदो नु बोरब ओख्‍ती सुप्‍शो चढ़ेतीक लाइश्‍शा परमप्रभु यावे कली चढ़ेने चाप्‍नीनी। तन्‍न मेको कली चढ़ेतीक मीम हुम्‍चा मदुम्‍ब। गन्‍ती १८:१२-१३; २इतिहास ३१:५ ");
INSERT INTO suzBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","गेपुकीमी इन अन्‍न चढ़ेतीक नेल्‍ल हिक्‍सी सुप्‍शा, हिक्‍सी ङाम्‍शो सेलीन। इन परमप्रभु आ कबल ङा अन्‍न चढ़ेतीकेमी हिक्‍सी मङाम्‍शो मदुम्‍ब। इन चढ़ेतीक नेल्‍लेमी हिक्‍सी सुप्‍शो चढ़ेचा माल्‍नीनी। गन्‍ती १८:१९; २इतिहास १३:५ ");
INSERT INTO suzBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","परमप्रभु यावे कली ङोंइती मीशो अन्‍न चढ़ेचा थुं पाइतीनी हना, इन ङोंइती मीशो नक बाला आन अन्‍न मीम क्रोइश्‍शा चढ़ेन। ब्‍यवस्‍था २६:२-११ ");
INSERT INTO suzBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","मेको तारी तेल लुक्‍शा, धूप वोइक्‍चा माल्‍ब। मेको अन्‍न चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","मिनु चढ़ेबमी मेको तेल लुक्‍शा, धूप वोइश्‍शो रे मुठी का हुइश्‍शा, मीम चोचा माल्‍ब। मेको परमप्रभु यावे कली मीम चोशा चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","सुइ आन चढ़ेतीके दुशा बाक्‍चा आ पर्बम बाक्‍त हना, मेकोमी बी ब्‍यफ रे का चढ़ेब हना, परमप्रभु यावे आ ङोंइती मारेइ मदुम्‍शो थम रिम्‍शो बी कि ब्‍यफ चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","मेकोमी आ गुइ आ चढ़ेतीक बस्‍तु आ पिया तार वोइक्‍चा माल्‍ब। मिनु ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ ङोंइती मेको कली क्‍योरशा साइक्‍चा माल्‍ब। मिनु चढ़ेब हारून आ तौपुकीमी मेको आ हुश लाइश्‍शा चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","मेकोमी दुशा बाक्‍चा आ पर्बम परमप्रभु यावे कली मीम चोशा चढ़ेतीक चढ़ेचा माल्‍ब। गा क्‍यी आ तार ङा नु मेको कली गिल्‍शो बोंसो नेल्‍ल चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","आ चिच निम्‍फा नु मेको आ तार नु आ क्रातोम बाक्‍शो बोंसो, नु आइदीम क्‍येप्‍शो बोंसो नेल्‍ल ग्रुंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","मिनु हारून आ तौपुकीमी मेको नेल्‍ल कली चढ़ेतीके ङा मी तार ङा शीम वोइश्‍शा, चोचा माल्‍नीम। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","मेकोमी आ दुशा बाक्‍चा आ पर्बम परमप्रभु यावे कली चढ़ेतीके क्‍यारश भेडा रे का चढ़ेब हना, मेकोमी मारेइ मदुम्‍शो थम रिम्‍शो क्‍यारश भेडा बाक्‍त हना यो, बोका सांड बाक्‍त हना यो, चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","मेको आ चढ़ेतीक भेडा का बाक्‍त हना, मेको परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","मेकोमी आ गुइ आ चढ़ेतीक भेडा आ पिया तार वोइक्‍चा माल्‍ब। मिनु ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ ङोंइती मेको कली क्‍योरशा साइक्‍चा माल्‍ब। मिनु चढ़ेब हारून आ तौपुकीमी मेको आ हुश लाइश्‍शा चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","मेकोमी दुशा बाक्‍तीक आ पर्बम चढ़ेतीक भेडा आ बोंसो परमप्रभु यावे कली मीम चोशा चढ़ेचा माल्‍ब। मेको बोंसो पाइश्‍शो मीलु नु क्रातो आ नेक्‍था रे नेल्‍ल ग्रुंइचा माल्‍नीम। गा क्‍यी आ तार ङा नु मेको कली गिल्‍शो बोंसो नेल्‍ल चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","आ चिच निम्‍फा, मेको आ तार ङा क्रातो ङा बोंसो नेल्‍ल नु आ आइदीम क्‍येप्‍शो बोंसो नेल्‍ल ग्रुंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","मिनु चढ़ेबमी मेको परमप्रभु यावे कली मीम चोशा जचा थोव़क चढ़ेतीक चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","मिनु दुशा बाक्‍चा आ पर्बम परमप्रभु यावे कली चढ़ेतीक क्‍यारश का बाक्‍त हना, मेकोमी मेको परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","मेकोमी आ गुइ मेको क्‍यारश आ पिया तारी वोइक्‍चा माल्‍ब। मिनु मेको कली ग्रुम्‍तीक ताम्‍बु आ ङोंइती क्‍योरशा साइक्‍चा माल्‍ब। मिनु हारून आ तौपुकीमी मेको आ हुश चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","मिनु मेकोमी मेको आ चढ़ेतीके परमप्रभु यावे कली मीम चोशा चढ़ेचा माल्‍ब। गा क्‍यी सुम्‍शो नु गिल्‍शो बोंसो नेल्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","आ चिच निम्‍फा, मेको आ तार ङा क्रातो ङा बोंसो नेल्‍ले नु आ आइदीम क्‍येप्‍शो बोंसो नेल्‍ल ग्रुंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","मिनु चढ़ेबमी ब्रोव़शो रिना पाइश्‍शो जचा थोव़क मेको मीम चोशा चढ़ेतीकेमी चढ़ेचा माल्‍ब। बोंसो नेल्‍ले परमप्रभु यावे के बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","मिनु गेपुकीमी बोंसो नु हुश मब्‍वने। इन नोले ङा पाला नेल्‍ल आन कली गेपुकी ते बाक्‍तीनी हना यो, गेना हना यो लीब अरेतीक बाक्‍ब’ दे इस्राएली आन कली देनो” दे परमप्रभु यावेमी मोसा कली देंत। लेवी ७:२३,२७; लेवी १७:१०-१४; उत्‍पत्ती ९:४; ब्‍यवस्‍था १२:१६,२३; प्रेरित १५:२०-२९ ");
INSERT INTO suzBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“गे इस्राएली आन कली ‘परमप्रभु यावेमी मपचा, दे शेंशो सुइ मुरुमी मतुइक्‍थु पाप पाप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","मिनु तेल लुक्‍शो चढ़ेबमी पाप पा, मुर आन कली दोस ताइब सेल्‍तु हना, मेकोमी आ पशो पाप आ पर्बम मारेइ मदुम्‍शो थम रिम्‍शो ब्‍यफ का परमप्रभु यावे आ ङोंइती पाप पशो आ पर्बम चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","मेकोमी मेको ब्‍यफ कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ नेक्‍था परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। मेकोमी आ गुइ मेको ब्‍यफ आ पिया तारी वोइक्‍चा माल्‍ब। मिनु मेको ब्‍यफ कली परमप्रभु यावे आ ङोंइती साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","मिनु मेको तेल लुक्‍शो चढ़ेबमी ब्‍यफ आ हुश इच्‍का हुइश्‍शा ग्रुम्‍तीक ताम्‍बुमी चाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","मिनु चढ़ेबमी आ ब्रेप्‍चो हुशेम ख्रुम्‍शा, मेको हुश परमप्रभु यावे आ ताम्‍बु आ आगा ङा चोव़खो कोठा आ बारेशो वाम आ नेक्‍था परमप्रभु यावे आ ङोंइती ७ खेयप ब्रुइक्‍चा माल्‍ब। लेवी ९:९ ");
INSERT INTO suzBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","मिनु नोले चढ़ेबमी मेको हुश ग्रुम्‍तीक ताम्‍बु आ आगामी बाक्‍शो धूप चढ़ेतीके आ ग्रोव़पुकीमी ख्रेक्‍चा माल्‍ब। मेको ब्रोव़शो रिना पाइश्‍शो धूप परमप्रभु यावे आ ङोंइती चढ़ेतीके बाक्‍ब। मिनु लीशो हुश नेल्‍ले ग्रुम्‍तीक ताम्‍बु आ ओव़तीक ङा चोशा चढ़ेतीक आ पुंम मोइक्‍चा माल्‍ब। प्रस्‍थान ३०:१,६; प्रस्‍थान ४०:६ ");
INSERT INTO suzBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","मेकोमी पाप आ पर्बम चढ़ेशो ब्‍यफ आ बोंसो नेल्‍ल शोल्‍चा माल्‍ब। गा क्‍यी आ तार ङा नु मेको कली गिल्‍शो बोंसो, ");
INSERT INTO suzBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","आ चिच निम्‍फा, मेको आ क्रातो तार ङा बोंसो नेल्‍ले नु आ आइदीम क्‍येप्‍शो बोंसो नेल्‍ल ग्रुंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","दुशा बाक्‍चा आ पर्बम चढ़ेशो ब्‍यफ आ बोंसो ग्रुंइशो खोदेंशो पा शोल्‍चा माल्‍ब। मिनु चढ़ेबमी मेको मीम चोशा चढ़ेतीकेमी चढ़ेचा माल्‍ब। लेवी ८:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","तन्‍न ब्‍यफ आ कुशुल, मेको आ श्‍ये नेल्‍ल, मेको आ पिया, खोइली नु मेको आ गा क्‍यी गोबर सुन्‍दा, ");
INSERT INTO suzBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ब्‍यफ आ लीशो नेल्‍ले मुर बाक्‍तीके रे ङोन चोव़खो पुलु ताइक्‍तीकेमी लाइश्‍शा, शी तार वोइश्‍शा चोचा माल्‍नीम। लेवी ६:४ ");
INSERT INTO suzBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","इस्राएल ङा मुर नेल्‍लेमी मतुइक्‍थु पाप पशो बाक्‍तेक्‍म हना, परमप्रभु यावेमी मपचा दे शेंशो मारेइ पशो बाक्‍तेक्‍म हना, मेको पाप मेको मुर आन दातेमी ख्रुइश्‍शो बाक्‍त हना यो, मेकोपुकी दोस ताइब दुम्‍नीम। गन्‍ती १५:२२-२६ ");
INSERT INTO suzBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","मिनु मेको आन पशो पाप ग्रूमेनु, मेको इस्राएली नेल्‍लेमी पाप आ पर्बम चढ़ेतीके ब्‍यफ चाक्‍शा ग्रुम्‍तीक ताम्‍बु आ ङोंइती जाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","मिनु इस्राएल ङा खाल्‍पा नेल्‍लेमी परमप्रभु यावे आ ङोंइती मेको आन गुइ ब्‍यफ आ पिया तारी वोइक्‍चा माल्‍नीम। मिनु मेको ब्‍यफ परमप्रभु यावे आ ङोंइती साइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","मिनु नोले तेल लुक्‍शो चढ़ेबमी मेको ब्‍यफ आ हुश इच्‍का ग्रुम्‍तीक ताम्‍बु आगा चाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","मिनु चढ़ेबमी मेको आ ब्रेप्‍चो हुशेमी ख्रुम्‍शा, परमप्रभु यावे आ ङोंइती बारेशो वा आ पुंमी ७ खेयप ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","मिनु नोले मेकोमी ग्रुम्‍तीक ताम्‍बु आगाम बाक्‍शो धूप चढ़ेतीक आ ग्रोव़पुकीम परमप्रभु यावे आ ङोंइती ख्रेक्‍चा माल्‍ब। मिनु लीशो हुश नेल्‍ल ग्रुम्‍तीक ताम्‍बु आ ओव़तीके आ ङोंइती बाक्‍शो चोशा चढ़ेतीक आ पुंम मोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","मेकोमी मेको आ बोंसो नेल्‍ल शोल्‍शा, चढ़ेतीकेम चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","मेकोमी पाप आ पर्बम चढ़ेशो ब्‍यफ कली दोदेंशो पामे, मेको ब्‍यफ कली यो मोदेंशोन पचा माल्‍ब। मोपा चढ़ेबमी मेको आन पर्बम पाप क्‍याम्‍तीक गेय पाइब। मिनु मेकोपुकीम माफ ताइनीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","मेकोमी मेको ब्‍यफ कली मुर बाक्‍तीके रे ङोन ग्रुंइशा लाइक्‍चा माल्‍ब। ङोंइती ङा ब्‍यफ चोशो खोदेंशो पा चोचा माल्‍ब। मेको इस्राएली आन पाप आ पर्बम चढ़ेशो बाक्‍ब। लेवी ४:११-१२ ");
INSERT INTO suzBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","मिनु सासन पाइब कामी मतुइक्‍थु, परमप्रभु यावेमी मपचा, दे शेंशो पाप पाप्‍तु हना, मेको दोस ताइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","मिनु मेको आ पशो पाप तुइक्‍तमे नोले, मेकोमी मारेइ मदुम्‍शो थम रिम्‍शो बोका का चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","मिनु मेकोमी आ गुइ मेको बोका आ पिया तार वोइक्‍चा माल्‍ब। मिनु तेकेर परमप्रभु यावे आ ङोंइती चोशा चढ़ेतीक साइक्‍नीमी, मेकेर रेन मेको साइक्‍चा माल्‍ब। मेको पाप आ पर्बम चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","मिनु चढ़ेबमी आ ब्रेप्‍चो हुशेमी ख्रुम्‍शा, चोशा चढ़ेतीक आ ग्रोव़पुकीम ख्रेक्‍चा माल्‍ब। मेको लीशो हुश चोशा चढ़ेतीक आ पुंम मोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","मेको आ बोंसो नेल्‍ले चढ़ेतीक आ तार चोचा माल्‍ब। मेको दुशा बाक्‍तीक आ पर्बम चढ़ेशो बोंसो खोदेंशो पा चढ़ेतीकेमी चोचा माल्‍ब। मोपा चढ़ेबमी मेको आ पाप आ पर्बम पाप क्‍याम्‍तीक गेय पाइब। मिनु मेको माफ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","मिनु मुर आन दाते ङा कामी मतुइक्‍थु पाप पाप्‍तु हना, परमप्रभु यावेमी मपचा, दे शेंशो पाप्‍तु हना, मेको दोस ताइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","मिनु मेको आ पशो पाप तुइक्‍तमे नोले, मेकोमी आ पशो पाप आ पर्बम चढ़ेचा कली मारेइ मदुम्‍शो थम रिम्‍शो क्‍यारश का चढ़ेचा कली चाक्‍चा माल्‍ब। गन्‍ती १५:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","मिनु मेकोमी आ गुइ मेको पाप आ पर्बम चढ़ेतीक तार वोइक्‍चा माल्‍ब। मिनु मेको पाप आ पर्बम चढ़ेतीके कली मेको चोशा चढ़ेतीक आ नेक्‍था साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","मिनु चढ़ेबमी आ ब्रेप्‍चो हुशेमी ख्रुम्‍शा, चोशा चढ़ेतीक आ ग्रोव़पुकीम ख्रेक्‍चा माल्‍ब। मेको लीशो हुश चोशा चढ़ेतीक आ पुंम मोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","मेकोमी आ बोंसो नेल्‍ल दुशा बाक्‍चा आ पर्बम चढ़ेशो आ बोंसो खोदेंशो पा शोल्‍चा माल्‍ब। मिनु चढ़ेबमी मेको चढ़ेतीकेमी चोशा परमप्रभु यावे आ दाक्‍शो ब्रोव़शो रिना पाइक्‍चा कली चोचा माल्‍ब। मोपा चढ़ेबमी मेको आ पाप आ पर्बम पाप क्‍याम्‍तीक गेय पाइब। मिनु मेको माफ ताइब। लेवी ३:१४-१५ ");
INSERT INTO suzBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","मेकोमी आ पाप आ पर्बम चढ़ेचा कली भेडा चाक्‍तु हना, मारेइ मदुम्‍शो थम रिम्‍शो भेडा चाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","मिनु मेकोमी आ गुइ मेको पाप आ पर्बम चढ़ेतीक तार वोइक्‍चा माल्‍ब। मिनु तेकेर चोशा चढ़ेतीक साइक्‍नीमी, मेकेर मेको पाप आ पर्बम चढ़ेतीके साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","मिनु चढ़ेबमी आ ब्रेप्‍चो हुशेमी ख्रुम्‍शा, चोशा चढ़ेतीक आ ग्रोव़पुकीम ख्रेक्‍चा माल्‍ब। मेको लीशो हुश चोशा चढ़ेतीक आ पुंम मोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","मेकोमी आ बोंसो नेल्‍ल दुशा बाक्‍चा आ पर्बम चढ़ेशो आ बोंसो खोदेंशो पा शोल्‍चा माल्‍ब। मिनु चढ़ेबमी मेको चढ़ेतीकेमी अरु चोशा चढ़ेतीक नु परमप्रभु यावे कली चोचा माल्‍ब। मोपा चढ़ेबमी मेको आ पशो पाप आ पर्बम पाप क्‍याम्‍तीक गेय पाइब। मिनु मेको माफ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","मिनु मुर कामी मार मार तशा तुइश्‍शा यो, सांकछी दुम्‍चा कली ब्रेत्‍मेनु, सांकछी दुम्‍चा कली मजाक्‍बा, मेकोमी आ तशो तुइश्‍शो मदेंत हना, मेको आ पर्बम दोस ताइब दुम्‍ब। न्‍यायाधीस १७:२; हितोपदेस २९:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","मिनु सुइमी ग्रांग्रा दिशो थोव़क, बेक्‍शो ब्‍वाकी ङा जन्‍तु, बेक्‍शो बस्‍तु भाव, बेक्‍शो ग्रांग्रा दिशो आइक्‍च ग्रेक्‍शा गाक्‍ब जन्‍तु थिप्‍तु हना, मेकोमी मतुइक्‍ताक्‍व हना यो, मेको ग्रांग्रा दिशो दुम्‍शो बाक्‍ब। मिनु दोस ताइब दुम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","मिनु मेकोमी मुर आन ग्रांग्रा दिशो थोव़क थिप्‍तु हना, तेकोइ मुर आन ग्रांग्रा दिशो सेल्‍शो थोव़क थिप्‍तु हना, मेकोम मेको मतुइक्‍ताक्‍व हना यो, मेको दोस ताइब दुम्‍ब। गन्‍ती १९:१३,२० ");
INSERT INTO suzBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","मिनु सुमी मारेइ रिम्‍शो मरिम्‍शो ममिम्‍थु कसम जाप्‍तु हना, मारेइ मतुइक्‍थु कसम जाप्‍तु हना, मिनु मेको रे मेको लोव़ ख्रुइश्‍शो बाक्‍त हना यो, मेकोमी तुइक्‍ता नोले मेको दोस ताइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","मिनु मेको मुर आ पशो पाप तुइक्‍ता नोले, मेकोमी आ पशो पाप शोव़चा माल्‍ब। लेवी १६:२१; गन्‍ती ५:७; यहोसु ७:२० ");
INSERT INTO suzBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","मेकोमी परमप्रभु यावे आ ङोंइती आ पशो पाप आ पर्बम चढ़ेचा कली आ बगाल रे भेडा बाक्‍त हना यो, क्‍यारश बाक्‍त हना यो, का चाक्‍चा माल्‍ब। मिनु चढ़ेबमी मेको आ पशो पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","तन्‍न मेकोमी भेडा चाक्‍ने मचाप्‍तु हना, मेको आ पशो पाप क्‍याम्‍तीक गेय पचा कली ढुकुर निक्‍शी कि परवा निक्‍शी परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। मेको का पाप आ पर्बम चढ़ेचा कली नु का चोशा चढ़ेचा कली चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","मेकोमी मेको चढ़ेब आन बाक्‍तीक चाक्‍चा माल्‍नीम। मिनु चढ़ेबमी का कली पाप आ पर्बम ङोंइती चढ़ेचा माल्‍ब। मिनु मेको कली आ शुर रोप्‍चा माल्‍ब। तन्‍न मेको कली प्रोइक्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","मिनु मेको चढ़ेबमी चढ़ेशो परवा आ हुश चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍ब। मिनु लीशो हुश चढ़ेतीक आ पुंम चिरचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","मिनु चढ़ेबमी अर्को परवा चहिं परमप्रभु यावेमी ङोंइती देंशो खोदेंशो पा चोशा चढ़ेतीक चढ़ेचा माल्‍ब। मोपा मेको चढ़ेबमी मेको आ पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोम माफ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","तन्‍न ढुकुर निक्‍शी नु परवा निक्‍शी यो चाक्‍ने मचाप्‍तु हना, मेकोमी मार पाप पशो बाक्‍मे, मेको पाप आ पर्बम एफाह का ङा १० भाग थम रिम्‍शो फस चाक्‍चा माल्‍ब। मेकोमी मेको फस तार तेल लुक्‍चा नु धूप वोइक्‍चा मदुम्‍ब। मारदे हना मेको पाप आ पर्बम चढ़ेतीके बाक्‍ब। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको ङा १० भाग २ लिटर नु इच्‍का खोइ खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","मेकोमी मेको चढ़ेब आन बाक्‍तीक चाक्‍चा माल्‍ब। मिनु चढ़ेबमी मेको मिम्‍चा कली मुठी का हुइश्‍शा, परमप्रभु यावे कली मीम चोशा चढ़ेतीकेम अरु नु चोचा माल्‍ब। मेको पाप आ पर्बम चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","मोपा मेको चढ़ेबमी मेको आ पाप आ पर्बम पाप क्‍याम्‍तीक गेय पाइब। मिनु मेकोमी माफ ताइब। मेको रे लीशो चहिं अन्‍न चढ़ेशो खोदेंशो पा चढ़ेब आन के दुम्‍ब’ दे इस्राएली आन कली देनो” दे परमप्रभु यावेमी देंत। लेवी २:३ ");
INSERT INTO suzBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“सुइ मुरुमी प्रेंशा, परमप्रभु यावे आ देंशो मटिथु, पाप पाप्‍तु हना, मेको आ बगाल रे मारेइ मदुम्‍शो थम रिम्‍शो ताम्‍बु ङा चांदी के शेकेलम फाइक्‍चा कली सांड का मेको पाप आ पर्बम चढ़ेचा कली परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। मेको गारचा आ पर्बम चढ़ेतीक बाक्‍ब। शेकेल का ११.५ ग्राम बाक्‍ब। चांदी नु सुन के क्‍येट बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","मेकोमी गारचा कली प्रेंशो बाक्‍त हना, परमप्रभु यावे कली गेतीकेम ५ भाग तेम्‍चा माल्‍ब। मिनु मेको चढ़ेब कली गेचा माल्‍ब। मिनु चढ़ेबम मेको पाप गारचा आ पर्बम चढ़ेशो सांड लाइश्‍शा पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेको माफ ताइब दुम्‍ब। लेवी ५:२३-२४; लेवी २२:१४; लेवी २७:१३; ");
INSERT INTO suzBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","सुइ मुरुमी परमप्रभु यावेमी मपचा, दे शेंशो पाप्‍तु हना, मेकोमी मेको मतुइक्‍ताक्‍व हना यो, मेको दोस ताइब दुम्‍शो बाक्‍ब। मिनु मेको सजाइ ताइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","मेकोमी चढ़ेब आन बाक्‍तीकेम मारेइ मदुम्‍शो थम रिम्‍शो ठीक क्‍येट लाइब सांड का आ बगाल रे गारचा आ पर्बम चढ़ेतीक चढ़ेचा कली चाक्‍चा माल्‍ब। मिनु चढ़ेबमी मेको आ मतुइक्‍थु पशो पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोम माफ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","मेको गारतीक आ पर्बम चढ़ेतीक बाक्‍ब। मेको परमप्रभु यावे आ ङोंइती थमा पा दोस ताइब दुम्‍शो बाक्‍ब” दे मोसामी मुर आन कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“सुइ मुरुमी परमप्रभु यावे कली मटिथु, मेको आ ङोंइती आ नेक्‍था ङा मुर नु जाकटी वोइश्‍शो थोव़क आ पर्बम जोल पाप्‍तु हना, सुइम गेनुङ, दे कबल पा यो मगेप्‍तु हना, कि मेको थोव़क रोइक्‍ताक्व हना, कि जोल पा आ नेक्‍था ङा मुर आ मारेइ थोव़क आंम के सेल्‍तु हना, गन्‍ती ५:६-८ ");
INSERT INTO suzBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","आ नेक्‍था ङा मुर आन मार मार रोइक्‍ताक्‍व हना, जाम्‍शो थोव़क थिश्‍शा यो, मथिदु, दे जोल पाप्‍तु हना, जोल पा कसम जाप्‍तु हना, मेकोमी पाप पशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","मेको मोपा पाप पा दोस ताइब दुम्‍ब। मिनु मेकोमी आ रोइश्‍शो, आ खुइ पशो, आ ताक्‍शो थोव़क मलेत्‍ताक्‍व हना, आ थिश्‍शो आ पर्बम जोल पाप्‍तु हना, इजीकीएल ३३:१५ ");
INSERT INTO suzBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","तेको थोव़क आ पर्बम जोल पा कसम जशो बाक्‍मे, मेकोमी मेको थोव़क नेल्‍लेमी ५ भाग तेम्‍शा, आ होव़प कली लेश्‍शा गेचा माल्‍ब। मेकोमी दोस आ पर्बम चढ़ेतीक नाक्‍ती मेको सु के बाक्‍मे मेको आ नेक्‍था ङा मुर कली लेश्‍शा गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","मिनु मेकोमी परमप्रभु यावे आ ङोंइती ठीक पा हिक्‍शो क्‍येट कि आ बगाल रे मारेइ मदुम्‍शो थम रिम्‍शो सांड का आ मरिम्‍शो पशो आ पर्बम चढ़ेब आ नेक्‍था परमप्रभु यावे आ बाक्‍तीकेमी चढ़ेचा कली चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","मिनु मेको चढ़ेबमी मेको आ पर्बम परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोमी मार आ पर्बम दोस तशो बाक्‍मे, मेकोम माफ ताइब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“गे हारून नु आ तौ आन कली चोशा चढ़ेचा आ पर्बम अरेमी। मेको चोशा चढ़ेतीक नाक्‍दो रे सुनी सम्‍म चढ़ेतीके शी तार बाक्‍चा माल्‍ब। मिनु चढ़ेतीक ङा मी यो ब्रस ङा ब्रस बाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","मिनु चढ़ेबमी आ सुती के आगा फेक्‍तीक वा नु सुती के फेक्‍तीके फेक्‍चा माल्‍ब। मिनु मेकोमी मीम दाक्‍शो चोशा चढ़ेशो आ पुलु हुइश्‍शा चढ़ेतीक आ नेक्‍था वोइक्‍चा माल्‍ब। प्रस्‍थान २८:४२ ");
INSERT INTO suzBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","मिनु नोले मेकोमी आ फेक्‍शो वा प्रुइश्‍शा, अर्को वा फेक्‍शा, मेको पुलु ताम्‍बु रे ग्रुंइशा चोव़खो पुलु ताइक्‍तीकेमी लाइश्‍शा ताइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","चढ़ेतीक ङा मी चहिं ब्रस ङा ब्रस बाक्‍चा माल्‍ब। मेको काप्‍चा मदुम्‍ब। मिनु सुनी कुस कुस चढ़ेबमी मेकेर शी तेम्‍चा माल्‍ब। मिनु चोशा चढ़ेतीके मीम दुशा बाक्‍तीक आ पर्बम चढ़ेशो आ बोंसो चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","चढ़ेतीक ङा मी ब्रस ङा ब्रस बाक्‍चा माल्‍ब। मेको गेनायो काप्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","एको अन्‍न चढ़ेतीक आ पर्बम अरेशो लोव़ बाक्‍ब। हारून आ तौपुकीमी परमप्रभु यावे आ ङोंइती चढ़ेतीक आ नेक्‍था चाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","मिनु मेकोपुकीम अन्‍न चढ़ेतीके, तेल नु धूप आ तार वोइश्‍शो रिम्‍शो फस रे मुठी का लाइश्‍शा, मिम्‍चा कली परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीकेमी चोचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","मिनु लीशो हारून नु आ तौपुकीम जचा माल्‍नीम। तन्‍न मेको चोव़खो बाक्‍तीकेमी बोरब ओख्‍ती मसुप्‍थु, चोशा जचा माल्‍नीम। मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु आ लाङगाम बाक्‍शा, जचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","मेकेर बोरब ओख्‍ती सुप्‍शा शोब्‍ले चोचा मदुम्‍ब। आं कली मीम चोशा चढ़ेशो रे मेको आन कली आं गेशो भाग बाक्‍ब। मेको पाप आ पर्बम चढ़ेतीके नु गारपाइक्‍चा आ पर्बम चढ़ेतीके खोदेंशो मेको थम चोव़खो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून आ खिं ङा वोंइश मुर नेल्‍लेमी गेना हना यो परमप्रभु यावे कली मीम चोशा चढ़ेशो रे जचा माल्‍नीम। परमप्रभु यावे कली मीम चोशा चढ़ेशो रे मेको आ खिं ङा मुर नेल्‍ल आन कली गेशो आन भाग बाक्‍ब। मेको थीब नेल्‍ल चोव़खो दुम्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","मिनु परमप्रभु यावेमी लेंशा मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“हारून नु आ तौपुकीम तेल लुक्‍चा पुंइसे नाक्‍ती परमप्रभु यावे कली मार नु दोपा चढ़ेचा माल्‍नीम देंशा हना, एफाह का ङा १० भाग थम रिम्‍शो फस नाक्‍दो आधा नु सुनी आधा गेना हना यो चढ़ेचा माल्‍नीम। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको ङा १० भाग २ लिटर नु इच्‍का खोइ ४ माना खोदेंशो बाक्‍ब।लेवी ७:३७; प्रस्‍थान २९:- ");
INSERT INTO suzBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","मेको शोब्‍ले तेलम चोचा माल्‍ब। गे मेको कली शुश तेलम चोशा, अन्‍न चढ़ेतीके टुक्रा टुक्रा पा परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","मोपा हारून आ नोले आ तेल लुक्‍शो तौमी मोदेंशो पचा माल्‍ब। मेको गेना हना यो परमप्रभु यावे केन बाक्‍ब। मिनु मेको नेल्‍ल चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","मिनु चढ़ेब आन अन्‍न चढ़ेतीक नेल्‍ल चोचा माल्‍नीम। मेको जचा मदुम्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“गे हारून नु आ तौ आन कली मार देंचा माल्‍नेवे देंशा हना ‘पाप क्‍याम्‍चा कली चढ़ेतीक आ पर्बम अरेशो बाक्‍ब। पाप क्‍याम्‍चा कली चढ़ेतीक परमप्रभु यावे आ ङोंइती चोशा चढ़ेतीक कली साइक्‍तीकेमी साइक्‍चा माल्‍ब। मेको थम चोव़खो बाक्‍ब। लेवी ४:- ");
INSERT INTO suzBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","मेको पाप क्‍याम्‍चा कली चढ़ेशो चढ़ेबमी मेको रे ब्‍वचा माल्‍ब। मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु ङा लाङगाम बाक्‍शा, ब्‍वचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","मेको श्‍ये मारम थीबा, मेको यो चोव़खो दुम्‍ब। मेको आ हुश वाम प्रेक्‍ताक्‍व हना, गेपुकीम मेको वा चोव़खो बाक्‍तीकेमी मुरचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","मेको श्‍ये तेको खप के ग्‍योंबुम लोप्‍नीमी, मेको ग्‍योंब प्रोल्‍शा ताइक्‍चा माल्‍नीम। मेको कांसा के ग्‍योंबुम लोप्‍शो बाक्‍त हना, मेको सिक्‍स ब्‍वाक्‍कुम शेक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","मेको चढ़ेब आन दाते ङा वोंइश मुर नेल्‍लेमी मेको ब्‍वचा माल्‍नीम। मेको थम चोव़खो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","तन्‍न तेको पाप क्‍याम्‍चा कली चढ़ेतीके आ हुश पाप क्‍याम्‍तीक गेय पचा कली ग्रुम्‍तीक ताम्‍बु आ आगाम चाक्‍नीमी, मेको ब्‍वचा मदुम्‍ब। मेको चोचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","गारचा आ पर्बम चढ़ेतीक थम चोव़खो बाक्‍ब। एको दोपा पचा माल्‍ब देंशा हना, लेवी ५:१४-२६ ");
INSERT INTO suzBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","चोशा चढ़ेतीक तेकेर साइक्‍नीमी, मेकेरेन गारचा आ पर्बम चढ़ेतीक साइक्‍चा माल्‍ब। मेको आ हुश, चढ़ेतीक आ एर ओंथ ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","मेको आ बोंसो नेल्‍ले, बोंसो पाइश्‍शो मीलु, गा क्‍यी सुम्‍शो बोंसो, लेवी ३:९-१० ");
INSERT INTO suzBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","चिच निम्‍फा, मेको आ तार ङा नु क्रातो ङा बोंसो, चिच सुन्‍दा आइदीम क्‍येप्‍शो बोंसो नेल्‍ल शोल्‍शा, चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","चढ़ेबमी परमप्रभु यावे कली मीम चोशा चढ़ेचा माल्‍ब। मेको गारचा आ पर्बम चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","मेको चढ़ेब आन खिं ङा वोंइश मुर नेल्‍लेमी मेको ब्‍वचा माल्‍नीम। मेको चोव़खो बाक्‍तीके ब्‍वचा माल्‍नीम। मेको थम चोव़खो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","गारचा आ पर्बम चढ़ेतीके पाप आ पर्बम चढ़ेतीक खोदेंशो बाक्‍ब। पतीक गेय यो कान बाक्‍ब। मिनु तेको चढ़ेबम मेको पाप क्‍याम्‍तीक गेय पवा, मेको मेको केन दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","मिनु तेको चढ़ेबमी मुर आन चाक्‍शो चोशा चढ़ेतीक चढ़ेबा, मेको चोशा चढ़ेशो आ कुशुल यो मेको केन दुम्‍ब। लेवी १:६ ");
INSERT INTO suzBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","मिनु चुप्‍लुम चोशो, दिउरेमी क्‍येशो नु तांवाम चोशो चढ़ेशो नेल्‍ले मेको चढ़ेब केन दुम्‍ब। लेवी २:४,५,७ ");
INSERT INTO suzBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","तन्‍न अरु अन्‍न चढ़ेतीके तेलम ब्‍वाइश्‍शो नु मब्वाइश्‍शो नेल्‍ल हारून नु आ तौ आन कली योक्‍चा कली बाक्‍ब। लेवी २:१-३ ");
INSERT INTO suzBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","मिनु परमप्रभु यावे कली दुशा बाक्‍चा आ पर्बम चढ़ेतीके दोपा चढ़ेचा माल्‍ब, दे अरेशो बाक्‍ब देंशा हना, लेवी ३:- ");
INSERT INTO suzBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","सुइमी परमप्रभु यावे कली “गे रिम्‍शो पाइब बाक्‍नीनी” दे ठेयब सेल्‍शा चढ़ेप्‍तु हना, मेकोमी तेलम निशो बोरब ओख्‍ती मसुप्‍शो बटुक, बोरब ओख्‍ती मसुप्‍शो तेल ख्रेक्‍शो शोब्‍ले नु थम रिम्‍शो फस के सेल्‍शो तेल वोइश्‍शो शोब्‍ले चढ़ेचा माल्‍नीम। लेवी १९:५-८; लेवी २२:२९-३० ");
INSERT INTO suzBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","मेकोमी “गे रिम्‍शो पाइब बाक्‍नीनी” दे ठेयब सेल्‍शा नु दुशा बाक्‍चा आ पर्बम चढ़ेशो नु बोरब ओख्‍ती सुप्‍शो शोब्‍ले यो चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","मेकोमी चढ़ेशो शोब्‍ले नेल्‍ल रे का का पा परमप्रभु यावे कली क्‍युक्‍शा चढ़ेचा माल्‍ब। दुशा बाक्‍चा आ पर्बम चढ़ेतीके आ हुश तेको चढ़ेबम ब्रुइक्‍बा, मेको केन दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“गे रिम्‍शो पाइब बाक्‍नीनी” दे ठेयब सेल्‍शा नु दुशा बाक्‍चा आ पर्बम चढ़ेशो श्‍ये मेको चढ़ेशो नाक्‍तीन नेक्‍चा माल्‍नीम। सुनी सम्‍म मारेइ हें‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","मेको चढ़ेशो कसम जशो आ पर्बम नु ग्‍येरशा चढ़ेशो बाक्‍त हना, मेको चढ़ेशो नाक्‍ती ब्‍वचा माल्‍नीम। आ लीशो आ दीसा ब्‍वचा दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","आ नित्‍थ नाक्‍त सम्‍म लीशो चढ़ेशो श्‍ये चहिं मीम चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","मेको दुशा बाक्‍तीक आ पर्बम चढ़ेशो आ श्‍ये आ नित्‍थ नाक्‍त सम्‍म सुइम ब्‍वाप्‍तु हना, मेको काइ मदुम्‍ब। मेको मुरुमी यो मचढ़ेशो खोदेंशो दुम्‍ब। मेको श्‍ये ब्‍वचा ग्रांग्रा दित्‍चा ङा बाक्‍ब। मेको ब्‍वाइब मुर दोस ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","मारेइ ग्रांग्रा दिशो थोव़कम थिशो श्‍ये ब्‍वचा मदुम्‍ब। मेको चोचा माल्‍ब। तन्‍न सुइ चोव़खो दुम्‍शो बाक्‍तेक्‍म हना, अरु श्‍ये ब्‍वने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","तन्‍न सुइ ग्रांग्रा दिशो दुम्‍शा, परमप्रभु यावे कली दुशा बाक्‍चा आ पर्बम चढ़ेशो श्‍ये ब्‍वाप्‍तु हना, मेको आ खिं ङा मुर रे तिल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","मिनु इन दातेमी सुमी मारेइ मारेइ ग्रांग्रा दिशो थोव़क थिशा, मुर आन ग्रांग्रा दिशो, ग्रांग्रा दिशो जन्‍तु कि मारेइ ग्रांग्रा दिशो थिप्‍तु हना, नोले परमप्रभु यावे कली दुशा बाक्‍चा आ पर्बम चढ़ेशो श्‍ये ब्‍वाप्‍तु हना, मेको आ खिं ङा मुर रे तिल्‍चा पुंइसीब’ दे माइक्‍मी” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“गे इस्राएली आन कली ‘गेपुकीम ब्‍यफ, भेडा नु क्‍यारश आन बोंसो काइ मब्‍वने। लेवी ३:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","आंमा बेक्‍शो, मारेइमी साइश्‍शो बस्‍तु भाव आन बोंसो अर्को मारेइ गेयम चलेने चाप्‍नीनी। तन्‍न गेपुकीमी मेको ब्‍वचा मदुम्‍ब। प्रस्‍थान २२:३० ");
INSERT INTO suzBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","मिनु इन दातेमी सुमी परमप्रभु यावे कली मीम चोशा चढ़ेतीके आ बोंसो ब्‍वाइबा, मेको आ खिं ङा मुर रे तिल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","गेपुकी ते बाक्‍तीनी हना यो, तेकोइ चिक्‍ब नु बी ब्‍यफ, क्‍यारश भेडा आन हुश ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","मिनु सुमी हुश ब्‍वाइबा, मेको आ खिं ङा मुर रे तिल्‍चा पुंइसीब’ माइक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“गे इस्राएली आन कली ‘सुमी परमप्रभु यावे कली गे रिम्‍शो पाइब बाक्‍नीनी, दे ठेयब सेल्‍शा चढ़ेतीक चाड सेल्‍बा, मेकोमी आ चढ़ेशो रे परमप्रभु यावे आ बाक्‍तीकेम आंमान चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","मेकोमी परमप्रभु यावे कली मीम चोशा चढ़ेचा कली बोंसो नु कुथ्रु चाक्‍चा माल्‍ब। मिनु मेको कुथ्रु परमप्रभु यावे कली क्‍युक्‍शा चढ़ेतीक चढ़ेचा माल्‍ब। प्रस्‍थान २९:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","मिनु चढ़ेबमी मेको बोंसो कली मीम चोचा माल्‍ब। तन्‍न मेको कुथ्रु हारून नु आ तौ आन के दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","मिनु इन दुशा बाक्‍चा आ पर्बम चढ़ेतीके रे आ ग्‍युरा फिला चढ़ेब कली क्‍युक्‍शा चढ़ेचा कली गेचा माल्‍नीनी। लेवी ९:२१ ");
INSERT INTO suzBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून आ तौ तेकोम दुशा बाक्‍चा आ पर्बम चढ़ेतीक चढ़ेबा नु हुश ब्रुइक्‍बा, ग्‍युरा फिला मेको के दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","मारदे हना गो इस्राएली आन “गे रिम्‍शो पाइब बाक्‍नीनी” दे ठेयब सेल्‍शा चढ़ेशो कुथ्रु नु ग्‍युरा फिला गेपुकी रे ताक्‍शा चढ़ेब हारून नु मेको आ तौ आन कली गेना हना यो कली गेतामी’ दे माइक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","हारून नु आ तौपुकी तेको नाक्‍त रे परमप्रभु यावे कली चढ़ेब दुम्‍मा, मेको नाक्‍ती रेन परमप्रभु यावे कली मीम चोशा चढ़ेशो चढ़ेतीक रे मेको आन भाग गेतामी। ");
INSERT INTO suzBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","तेको नाक्‍ती रे मेकोमी मेको आन कली तेल लुक्‍ता, मेको नाक्‍त रेन मेको आन कली इस्राएलीपुकी रे ततीक भाग परमप्रभु यावेमी ‘मेको आन के बाक्‍ब’ देंशो बाक्‍ब। मेको आन कली गेना हना यो नेल्‍ल आन पाला सम्‍म आन भाग बाक्‍ब, देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","“मेको चोशा चढ़ेतीके, अन्‍न चढ़ेतीके, पाप आ पर्बम चढ़ेतीके, गारचा आ पर्बम चढ़ेतीके, नक गेय पचा आ पर्बम चढ़ेतीके नु परमप्रभु यावे कली ‘गे रिम्‍शो पाइब बाक्‍नीनी’ दे ठेयब सेल्‍शा चढ़ेतीक आ पर्बम पतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","मिनु परमप्रभु यावेमी मेको लोव़ मोसा कली सीनै डांडाम अरेशो बाक्‍त। मेको नाक्‍ती परमप्रभु यावेमी सीनै ङा गोरशो रागीम इस्राएली आन कली आन चढ़ेतीक आ बाक्‍तीक चाक्‍कीन” दे अरेशो बाक्ब। ");
INSERT INTO suzBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“गे हारून नु आ तौ आन कली, चढ़ेब आन फेक्‍तीक वा, आन कली लुक्‍चा कली तेल, पाप आ पर्बम चढ़ेतीक ब्‍यफ, सांड निक्‍शी नु बोरब ओख्‍ती मसुप्‍शो शोब्‍ले चाक्‍को। प्रस्‍थान २८:३९-४३ ");
INSERT INTO suzBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","मुर नेल्‍ल आन कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम पुक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","मिनु मोसामी परमप्रभु यावेमी दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। मिनु मुरपुकी ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम बुक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मिनु मोसाम बुक्‍शो मुर आन कली “परमप्रभु यावेमी ‘पावो’ दे अरेशो लोव़ एकोन बाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","मिनु मोसामी हारून नु आ तौ आन कली चाक्‍शा चिक्‍ताक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","मिनु मेकोमी हारून कली आगा वा फेक्‍ताक्‍व। मिनु किप्‍शुर किप्‍ताक्‍व। मिनु मेकोमी आ तार ङा फेक्‍तीक फेक्‍ताक्‍व। मेकोमी क्रातो आ ङोंइती क्‍युक्‍तीक वा क्‍युक्‍‍ताक्‍व। मिनु रिम्‍शो पा प्रोव़शो बुटा आप्‍शो किप्‍शुर नु क्रातो ङोंइती क्‍युक्‍तीक झोला मेको आ तार किप्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","मिनु नोले मेकोमी हारून कली कुचुम रेल्‍तीक झोला रेल्‍ताक्‍व, मिनु मेको आगा “ऊरीम नु थुम्‍मीम” कुर पाप्‍तु। ऊरीम नु थुम्‍मीम कली छेङछेङ नु निसाफ पतीके देंसीब। परमप्रभु यावे आ देंशो कोंइब बाक्‍ब।प्रस्‍थान २८:३० ");
INSERT INTO suzBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","मिनु मेको आ पियाम गुप्‍तीके गुप्‍ताक्‍व। मिनु सुन के मुशो कुप्‍फीम पांइतीके “परमप्रभु यावे कली ला” दे मेको आ ङोंइती गे पांइताक्‍व। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। प्रस्‍थान २८:३६-३८; लेवी ३९:३० ");
INSERT INTO suzBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मेको नोले मोसामी लुक्‍तीक तेल चाक्‍शा परमप्रभु यावे आ बाक्‍तीके नु मेकेर बाक्‍शो मारेइ मारेइ आन कली ब्रुइश्‍शा, “परमप्रभु यावे केन बाक्‍ब” दे चोव़खो सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","मिनु मेकोमी तेल इच्‍का चढ़ेतीकेम ७ खेयप ब्रुइक्‍ताक्‍व। मोपा चढ़ेतीके, मेकेर बाक्‍शो चढ़ेचा कली माल्‍तीक नेल्‍ले नु चिक्‍तीक ठेयब ग्‍योंब नु आ नाइक्‍तीके, नेल्‍ल आन कली परमप्रभु यावे के सेल्‍चा कली तेल ब्रुइक्‍ताक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","मिनु मेकोमी हारून आ पियाम लुक्‍तीक तेल लुक्‍शा, मेको कली परमप्रभु यावे कली ला गेय पाइब सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","मिनु मोसामी हारून आ तौ आन कली चाक्‍पाइश्‍शा, आगा वा फेक्‍ताक्‍मी। मिनु किप्‍शुर किप्‍शा पियाम गुप्‍तीके गुप्‍ताक्‍मी। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मिनु नोले मोसामी पाप आ पर्बम चढ़ेतीक ब्‍यफ चाक्‍तु। मिनु हारून नु आ तौपुकीम मेको पाप आ पर्बम चढ़ेतीक ब्‍यफ आ पिया तारी आन गुइ वोइक्‍तेक्‍म। लेवी ४:१-१२ ");
INSERT INTO suzBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मिनु मोसामी मेको ब्‍यफ कली साइक्‍तु। मिनु मेकोमी मेको इच्‍का हुश लाइश्‍शा आ ब्रेप्‍चोमी चढ़ेतीक एर ओंथ ङा ग्रोव़म ख्रेक्‍शा, चढ़ेतीक कली परमप्रभु यावे कली ला, चोव़खो सेल्‍तु। मिनु लीशो हुश चहिं चढ़ेतीक आ पुंम मोइक्‍तु। मोपा मेको चढ़ेतीक कली पाप क्‍याम्‍तीक गेय पचा, दे चोव़खो सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मिनु मोसामी गा क्‍यी गिल्‍शो बोंसो नेल्‍ल, आइदी क्‍येप्‍शो बोंसो नु चिच निम्‍फा नु आ बोंसो चढ़ेतीकेम चोप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","मिनु ब्‍यफ, मेको आ कुशुल, आ श्‍ये नु गोबर मुर आ बाक्‍तीक क्‍येङा ङोन मीम चोप्‍तु। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","मिनु नोले मोसामी चोशा चढ़ेतीक सांड चाक्‍तु। मिनु हारून नु आ तौपुकीमी आन गुइ मेको सांड आ पिया तार वोइक्‍तेक्‍म। लेवी १:१०-१३ ");
INSERT INTO suzBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","मिनु मोसामी मेको सांड कली क्‍योरतु। मिनु मेकोमी आ हुश चढ़ेतीक एर ओंथ ब्रुइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","मिनु मोसामी मेको सांड कली टुक्रा टुक्रा पा चेक्‍तु। मेको आ पिया, चेक्‍शो श्‍ये नु बोंसो नेल्‍ल चोप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","मेकोमी गा क्‍यी नु फिला मुरतु। मोपा मोसामी मेको सांड नेल्‍ल चढ़ेतीकेमी चोप्‍तु। मेको परमप्रभु यावे कली ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेशो बाक्‍त। मिनु परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","मिनु नोले मोसामी अर्को चढ़ेतीक सांड चाक्‍तु। मेको गेय गोचा कली चढ़ेतीक ङा सांड बाक्‍त। मिनु हारून नु आ तौपुकीम आन गुइ मेको सांड आ पिया तार वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मिनु मोसामी मेको सांड कली क्‍योरतु। मिनु मेकोमी मेको आ हुश हारून आ ग्‍युरा नोफा आ फेनेम, आ ग्‍युरा गुइ ङा बोंग्‍ये नु आ ग्‍युरा खोइल ङा बोंग्‍येमी ख्रेक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मिनु मोसामी हारून आ तौ आन कली चाक्‍पाइक्‍तु। मिनु मेकोमी मेको आन ग्‍युरा नोफा आन फेनेम, आन ग्‍युरा गुइ ङा बोंग्‍ये नु आन ग्‍युरा खोइल ङा बोंग्‍येमी ख्रेक्‍ताक्‍व। मिनु मोसामी मेको हुश कली चढ़ेतीके आ एर ओंथ ब्रुइक्‍ताक्‍व। लेवी १७:११ ");
INSERT INTO suzBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","मिनु मेकोमी मेको सांड आ बोंसो, मेको बोंसो पाइश्‍शो मीलु, गा क्‍यीम गिल्‍शो बोंसो, आइदीम क्‍येप्‍शो बोंसो, चिच निम्‍फा नु मेक ङा बोंसो नु ग्‍युरा फिला लाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","मिनु परमप्रभु यावे आ ङोंइती बाक्‍शो बोरब ओख्‍ती मसुप्‍शो मार मार आ डालो रे बोरब ओख्‍ती मसुप्‍शो हिरशो शोब्‍ले का, तेलम ख्रुम्‍शो शोब्‍ले का नु बाबर का ग्रुंइशा, मेको बोंसो नु ग्‍युरा फिला तार वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","मिनु मेको नेल्‍ल लाइश्‍शा हारून नु आ तौ आन गुइमी वोइक्‍तु। मिनु परमप्रभु यावे आ ङोंइती हिम्‍शा चढ़ेतीके चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","मिनु मोसामी मेको आन गुइ रे लाइश्‍शा, चोशा चढ़ेशो आ तारी चोप्‍तु। मेको गेय गोचा कली चढ़ेतीके परमप्रभु यावे कली ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मिनु मोसामी मेको सांड आ कुथ्रु लाइश्‍शा, परमप्रभु यावे आ ङोंइती हिम्‍शा चढ़ेतीके चढ़ेप्‍तु। मेको गेय गोचा कली चढ़ेशो सांड आ श्‍ये मोसा आ भाग दुम्‍त। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मिनु मोसामी लुक्‍तीक तेल नु चढ़ेतीकेम वोइश्‍शो हुश लाइश्‍शा, हारून नु आ तौ आन फेक्‍शो वाम ब्रुइक्‍ताक्‍व। मोपा मोसामी हारून नु मेको आ फेक्‍शो वा, आ तौपुकी नु मेको आन फेक्‍शो वा नेल्‍ल परमप्रभु यावे कली ला गेय पाइब, दे चोव़खो सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मिनु मोसाम हारून नु आ तौ आन कली “गे मेको श्‍ये कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम लोपीन। मिनु गेय गोचा कली चढ़ेशो डालो ङा शोब्‍ले नु मेक उइ जने ब्‍वने। आं देंशो खोदेंशो पा जचा ब्‍वचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","हेंशो श्‍ये नु शोब्‍ले गे मीम चोचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","मिनु नोले गे ७ नाक्‍त सम्‍म, इन कली गेय गोचा कली चढ़ेशो ७ नाक्‍त मगाम सम्‍म ग्रुम्‍तीक ताम्‍बु आ ओव़तीक रे लाङगा मलने। मारदे हना ७ नाक्‍त मजाक्‍दीम सम्‍म इन गेय गोचा कली चढ़ेतीक गेय ला थुम्‍सीब। ");
INSERT INTO suzBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","मुलाक्‍त मार पङा, मेको परमप्रभु यावेमी अरेशो इन कली पाप क्‍याम्‍तीक गेय बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","गेपुकी ७ नाक्‍त सम्‍म नाक्‍दो नाक्‍ती ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी बाक्‍चा माल्‍नीनी। गे परमप्रभु यावेमी अरेशो पने। मो मपाइतीनी हना, गे बेक्‍नीनी। मारदे हना आं कली मोदें अरेशो बाक्‍ब” दे माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","मिनु परमप्रभु यावेमी मोसा रे पा अरेशो नेल्‍ल हारून नु आ तौपुकीम पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","मिनु ८ नाक्‍ती मोसामी हारून, आ तौ नु इस्राएल ङा खाल्‍पा आन कली ब्रेत्‍ताक्‍मी। लेवी ८:३३ ");
INSERT INTO suzBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","मिनु मेकोमी हारून कली “गे पाप आ पर्बम चढ़ेचा कली मारेइ मदुम्‍शो थम रिम्‍शो बाछा का नु चोशा चढ़ेचा कली मारेइ मदुम्‍शो थम रिम्‍शो सांड का चाक्‍शा परमप्रभु यावे आ ङोंइती चढ़ेवो। ");
INSERT INTO suzBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","मिनु इस्राएली आन कली ‘गेपुकीमी पाप आ पर्बम चढ़ेचा कली बोका का नु चोशा चढ़ेचा कली बर्स का दुम्‍शा, मारेइ मदुम्‍शो थम रिम्‍शो बाछा का नु मारेइ मदुम्‍शो थम रिम्‍शो पाठा का चाक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","मिनु परमप्रभु यावे आ ङोंइती दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ का, सांड का नु तेलम निशो अन्‍न चढ़ेतीक यो चाक्‍कीन। मारदे हना मुलाक्‍ती परमप्रभु यावेमी इन कली तपांइसीब’ माइक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","मिनु मोसामी अरेशो खोदेंशो पा मेकोपुकीमी मारेइ मारेइ ग्रुम्‍तीक ताम्‍बु आ ङोंइती चाक्‍तेक्‍म। मिनु मुर नेल्‍ले परमप्रभु यावे आ ङोंइती जाक्‍शा राप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मिनु मोसामी “गेपुकीमी परमप्रभु यावेमी अरेशो पचा माल्‍शो गेय एकोन बाक्‍ब। मिनु परमप्रभु यावे आ छेङछेङम इन कली तपांइसीब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मिनु मोसाम हारून कली “चढ़ेतीक आ नेक्‍था जाक्‍शा, इ पाप आ पर्बम चढ़ेतीक नु इ चोशा चढ़ेतीक चढ़ेवो। मिनु आंम इ पर्बम नु मुर आन पर्बम पाप क्‍याम्‍तीक गेय पावो। परमप्रभु यावेमी अरेशो खोदेंशो पा मुर आन चाक्‍शो चढ़ेतीक चढ़ेशा, मुर आन पर्बम पाप क्‍याम्‍तीक गेय पावो” देंत। लेवी १६:६,११,१५; हिब्रू ५:३; हिब्रू ७२७ ");
INSERT INTO suzBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","मिनु हारून चढ़ेतीक आ नेक्‍था जाक्‍शा, आ पाप आ पर्बम चढ़ेतीक बाछा क्‍योरतु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","मिनु हारून आ तौपुकीमी मेको आ हुश चाक्‍तेक्‍म। मिनु मेकोमी आ ब्रेप्‍चो हुशेम ख्रुम्‍शा चढ़ेतीक आ ग्रोव़पुकीम ख्रेक्‍ताक्‍व। मिनु लीशो हुश कली चढ़ेतीक आ पुंम मोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","मिनु मेकोमी पाप आ पर्बम चढ़ेशो आ बोंसो, चिच नु आइदीम क्‍येप्‍शो बोंसो चढ़ेतीकेम चोप्‍तु। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा हारूनमी पाप्‍तु। लेवी ४:८-१२; लेवी ८:१४-१७ ");
INSERT INTO suzBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","तन्‍न श्‍ये नु कुशुल चहिं मुर आन बाक्‍तीके क्‍येङा ङोन चोप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","मिनु नोले हारूनमी चोशा चढ़ेतीक क्‍योरतु। मिनु मेको आ तौपुकीमी मेको आ हुश चाक्‍शा गेम्‍तेक्‍म। मिनु मेकोमी मेको चढ़ेतीक आ एर ओंथ ब्रुइक्‍ताक्‍व। लेवी १:१०-१३ ");
INSERT INTO suzBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","मिनु मेकोपुकीमी मेको चोशा चढ़ेतीके टुक्रा टुक्रा पा चेक्‍शा, पिया सुन्‍दा चाक्‍शा, मेको कली गेम्‍तेक्‍म। मिनु हारूनमी मेको चढ़ेतीकेमी चोप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","मिनु मेकोमी गा क्‍यी नु खोइल मुरशा, चोशा चढ़ेतीके नु चोप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","मिनु नोले हारूनमी मुर आन पर्बम चढ़ेतीक चाक्‍शा, मेको आन पाप आ पर्बम चढ़ेशो बोका क्‍योरतु। मिनु ङोंइती ङा खोदेंशो पा पाप आ पर्बम चढ़ेतीके चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","मेको नोले चोशा चढ़ेतीक चाक्‍शा, अरेशो खोदेंशो पा चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","मिनु अन्‍न चढ़ेतीक चाक्‍शा, मुठी का हुइश्‍शा, सुनी ङा चोशा चढ़ेतीक नु चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","मिनु हारूनमी मुर आन कली दुशा बाक्‍चा आ पर्बम चढ़ेतीके ब्‍यफ नु सांड क्‍योरतु। मिनु हारून आ तौपुकीम हुश चाक्‍शा, मेको कली गेम्‍तेक्‍म। मिनु मेकोमी चढ़ेतीक आ एर ओंथ ब्रुइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","मिनु ब्‍यफ नु सांड आस बोंसो, बोंसो पाइश्‍शो मीलु, गा क्‍यी गिल्‍शो बोंसो, चिच निम्‍फा नु आइदीम क्‍येप्‍शो बोंसो लाइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","मिनु ङोंइती कुथ्रु तार वोइक्‍तेक्‍म। नोले बोंसो चढ़ेतीकेम चोम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","मिनु मोसाम अरेशो खोदेंशो पा हारूनमी कुथ्रु नु ग्‍युरा फिला चहिं परमप्रभु यावे आ ङोंइती क्‍युक्‍शा हिम्‍शा चढ़ेतीके चढ़ेप्‍तु। लेवी ७:३०-३४; ");
INSERT INTO suzBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","मिनु हारूनमी आ गुइ मुर आन गे पोक्‍शा, आसीक गेम्‍तीमी। मोपा पाप आ पर्बम चढ़ेतीके, चोशा चढ़ेतीके नु दुशा बाक्‍चा आ पर्बम चढ़ेतीके चढ़ेशा, मेको उइ तोंइसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मिनु मोसा नु हारून ग्रुम्‍तीक ताम्‍बु आगा ओव़ताक्‍स। मिनु ग्रूशा मुर आन कली आसीक गेम्‍ताक्‍स। मिनु परमप्रभु यावे आ छेङछेङ मुर नेल्‍लेमी ताम्‍तेक्‍म। प्रस्‍थान १६:१०; प्रस्‍थान ४०:३४ ");
INSERT INTO suzBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","मिनु परमप्रभु यावे आ ङोंइती रे मी ग्रूशा, चढ़ेतीकेम बाक्‍शो चोशा चढ़ेतीक नु मेक बाक्‍शो बोंसो नेक्‍तु। मिनु मुरपुकीमी मेको तशा, ठेयब सेंदा पा ग्‍येरसीशा, खुम्‍की पा बाप्‍तेक्‍म। न्‍यायाधीस ६:२१; १राजा १८:३८; १इतिहास २१:२६; २इतिहास ७:१ ");
INSERT INTO suzBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","मिनु हारून आ तौ नादाब नु अबीहुम आस थनौरो लाइश्‍शा, मी कुर पाम्‍ताक्‍स। मिनु मी आ तारी धूप वोइक्‍ताक्‍स। मोपा मेको निक्‍शी परमप्रभु यावेमी “अरु मी मलाइक्‍चा” दे अरेशो लोव़ मटिम्‍स, मेको परमप्रभु यावे आ ङोंइती चढ़ेम्‍ताक्‍स। प्रस्‍थान ६:२३; प्रस्‍थान २८:१; प्रस्‍थान ३०:९ ");
INSERT INTO suzBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","मिनु परमप्रभु यावे आ ङोंइती रे मी ग्रूशा, मेको आस कली ग्रु दाक्‍तु। मोपा मेको निक्‍शी परमप्रभु यावे आ ङोंइती बेक्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मिनु मोसामी हारून कली “परमप्रभु यावेमी देंशो ‘आं नेक्‍था बाक्‍ब आन कली गो नेल्‍ल क्‍येङा ठेयब बाक्‍नुङ’ दे कोंइनुङ। मिनु नेल्‍ल मुर आन ङोंइती गो ठेयब सेल्‍चा पुंइसीनुङ” देंत। मिनु हारून सिक्‍सी पा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोसामी हारून आ बकान्‍छा उज्‍जीएल आ तौ एल-साफान नु मीशाएल आस कली ब्रेश्‍शा “इस लोक्‍ब आस कली ताम्‍बु रे कुरशा ग्रुंइदीस” देंत। प्रस्‍थान ६:२२ ");
INSERT INTO suzBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मिनु मेको निक्‍शी जाक्‍शा, आस फेक्‍शो वा रे क्‍युक्‍शा मोसा आ देंशो खोदेंशो पा कुरशा ग्रुंइताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","मिनु मोसाम हारून नु आ तौ एलाजर नु इथामार आन कली “रोंका पा इन पिया ङा चां मप्रेक्‍कीन। इन वा मखाक्‍कीन। मो पाइतीनी हना, गेपुकी बेक्‍नीनी। मिनु परमप्रभु यावे आ गाइक्‍तीक नेल्‍ल मुर आन तारी जुक्‍ब। तन्‍न परमप्रभु यावे आ सोइश्‍शो मीम दुप्‍शा बेक्‍ब आस पर्बम इन खिं ङा मुर नु इस्राएली ङा मुर नेल्‍ल रोंका पचा दुम्‍ब। लेवी २१:१० ");
INSERT INTO suzBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","गेपुकी चहिं ग्रुम्‍तीक ताम्‍बु रे लाङगा मलने। मो पाइतीनी हना, बेक्‍नीनी। मारदे हना परमप्रभु यावे आ लुक्‍शो तेल गे इन तार बाक्‍ब” देंत। मिनु मेकोपुकीमी मोसा आ देंशो खोदेंशो पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","मिनु नोले परमप्रभु यावेमी हारून कली ");
INSERT INTO suzBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“गे नु इ तौपुकी ग्रुम्‍तीक ताम्‍बुम ओव़नीनु, अङगुर शांबु नु अरु दुक्‍तीक थोव़क मतूङीन। तूतीनी हना, गेपुकी बेक्‍नीनी। मेको गेना हना यो इन पतीक दुम्‍ब। इजीकीएल ४४:२१; होसे ४:११; आमोस २:८ ");
INSERT INTO suzBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","आं थोव़क नु मुर आ थोव़क तिल्‍चा माल्‍नीनी। ग्रांग्रा दिशो थोव़क नु चोव़खो थोव़क यो तिल्‍चा माल्‍नीनी। इजीकीएल २२:२६; इजीकीएल ४४:२३ ");
INSERT INTO suzBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","मिनु गो मोसा कली अरेशो नेल्‍ल, गे इस्राएली आन कली शेंचा माल्‍नीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मिनु मोसामी हारून नु आ लीशो तौ एलाजर नु इथामार आन कली “परमप्रभु यावे कली मीम चोशा अन्‍न चढ़ेशो रे लीशो बोरब ओख्‍ती मसुप्‍थु चढ़ेतीके आ नेक्‍था बाक्‍शा जने। मारदे हना मेको थम चोव़खो बाक्‍ब। लेवी ९:१७,१८ ");
INSERT INTO suzBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","गेपुकीम मेको कली चोव़खो बाक्‍तीकेमी जने। मारदे हना परमप्रभु यावे कली मीम चोशा चढ़ेशो चढ़ेतीक रे मेको गे नु इ तौ इन भाग बाक्‍ब। आं कली मोदें अरेशो बाक्‍ब। लेवी २:३ ");
INSERT INTO suzBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","तन्‍न क्‍युक्‍शा चढ़ेशो कुथ्रु नु हिम्‍शा चढ़ेशो फिला चहिं गे इन तौ नु इन तमीम चोव़खो बाक्‍तीकेमी बाक्‍शा ब्‍वने। मारदे हना मेको इस्राएली आन दुशा बाक्‍चा आ पर्बम चढ़ेशो रे गे नु इ तमी तौ इन भाग बाक्‍ब। लेवी ७:३४ ");
INSERT INTO suzBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","मिनु हिम्‍शो फिला, क्‍युक्‍शो कुथ्रु नु मीम चोशा चढ़ेशो मार मार आन बोंसो परमप्रभु यावे आ ङोंइती हिम्‍शा चढ़ेचा कली चाक्‍चा माल्‍नीनी। मिनु परमप्रभु यावेमी अरेशो खोदेंशो पा गेना हना यो, गे नु इ तमी तौ इन भाग दुम्‍ब” देंत। लेवी ९:२०-२१ ");
INSERT INTO suzBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मिनु मोसामी पाप आ पर्बम चढ़ेशो बोका माल्‍तु। तन्‍न मेको चोने थुम्‍शो बाक्‍माक्‍त। मिनु मेकोमी हारून आ लीशो तौ एलाजर नु इथामार आस कली गाइश्‍शा, लेवी ९:१५ ");
INSERT INTO suzBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“गेपुकीमी मारदे पाप आ पर्बम चढ़ेशो कली चोव़खो बाक्‍तीकेम मब्‍वनी? मारदे हना मेको थम चोव़खो बाक्‍ब। मिनु परमप्रभु यावेमी मुर आन पर्बम पाप क्‍याम्‍तीक गेय पचा, दे मेको इन कली गेशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","मेको आ हुश ताम्‍बु आ आगामी मलाइश्‍शो बाक्‍त। गेपुकीम थमा पा आं देंशो खोदेंशो पा चोव़खो बाक्‍तीकेम मेको श्‍ये ब्‍वचा माल्‍शो ननी” देंत। लेवी ६:१९,२२ ");
INSERT INTO suzBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","मिनु हारूनमी मोसा कली “नेनीन, मुलाक्‍ती मेकोपुकीमी आन पाप आ पर्बम चढ़ेतीक नु आन चोशा चढ़ेतीक परमप्रभु यावे आ ङोंइती चढ़ेम्‍तेक्‍म। मिनु मुलाक्‍त गो गिश श्‍येत जशो बाक्‍नुङ। गो मुलाक्‍ती मेको पाप आ पर्बम चढ़ेशो ब्‍वशो नङ हना, मार, मेको परमप्रभु यावे आ ङोंइती रिम्‍शो दुम वा ङा?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","मिनु मेको लोव़ नेंशा मोसा सिक्‍सी पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“गे इस्राएली आन कली ‘रागीम बाक्‍शो जन्‍तु, बस्‍तु भाव, चिक्‍ब तेक तेको ब्‍वचा दुम्‍बा, तेक तेको ब्‍वचा मदुम्‍बा, मेको शेंदीस। मिनु जन्‍तु नु बस्‍तु भाव तेको ब्‍वने चाप्‍नीनी देंशा हना, प्रेरित १०:१२-१५; कलस्‍सी २:१६; १तिमोथी ४:३-४ ");
INSERT INTO suzBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","गेपुकीमी आन गेंच जेश्‍शो नु शोंया हेक्‍बपुकी ब्‍वने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","मो हना यो गेंच जेश्‍शो ला कि शोंया हेक्‍ब दुम्‍शो ला ब्‍वचा मदुम्‍ब। दल‍ओंठ मेको शोंया हेक्‍ब, तन्‍न आ गेंच मजेश्‍शो बाक्‍ब। मेको इन कली ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","मिनु शापन मब्‍वने। मारदे हना मेकोमी शोंया हेक्‍ब, तन्‍न आ गेंच मजेश्‍शो बाक्‍ब। मेको इन कली ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","मिनु खरायो मब्‍वने। मारदे हना मेकोमी शोंया हेक्‍ब, तन्‍न आ गेंच मजेश्‍शो बाक्‍ब। मेको इन कली ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","मिनु पोव़ मब्‍वने। मारदे हना मेको आ गेंच जेश्‍शो बाक्‍ब, तन्‍न शोंया महेक्‍ब। मेको इन कली ग्रांग्रा बाक्‍ब। यसैया ६५:४; यसैया ६६:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","गेपुकीमी मेको आन श्‍ये मब्‍वने। आन सिनु यो मथिने। मेको इन कली ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ब्‍वाक्‍कु, खोला नु समुन्‍द्रम बाक्‍बपुकीमी फ्रां नु कत्‍ला पाइश्‍शो ब्‍वने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","तन्‍न समुन्‍द्र नु खोलाम बाक्‍ब फ्रां नु कत्‍ला मपाइश्‍शो ब्‍वचा मदुम्‍ब। मेको आइक्‍च ब्‍वाक्‍कुम बाक्‍ब जन्‍तु नु अरु नेल्‍ल सेल जन्‍तु इन कली ग्रांग्रा बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","मेको इन कली ग्रांग्रा बाक्‍तीके, मेको आन श्‍ये मब्‍वने। मिनु मेको आन सिनु इन कली ग्रांग्रा बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","मिनु ब्‍वाक्‍कुम बाक्‍ब नेल्‍ले फ्रां नु कत्‍ला मपाइश्‍शो जन्‍तु, इन कली ग्रांग्रा बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","मिनु चिक्‍ब आन दातेमी इन कली तेको तेको ग्रांग्रा दिशो नु ब्‍वचा मदुम्‍शो बाक्‍नीम देंशा हना, ककाकुली, गिद, क्‍येर गिद, ");
INSERT INTO suzBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लल ब्‍वारदे नु नेल्‍ल खाल ङा क्‍येर ब्‍वारदे, लेवी ५:२ ");
INSERT INTO suzBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","खद नेल्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ठेयब हुहुचील, ग्रीब बुक्‍स, ब्‍वाक्‍कुम बाक्‍ब चिक्‍ब, मिनु बाज नेल्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","आइक्‍च हुहुचील, ब्‍वाक्‍कु ङा खदी, भुल्‍का, ");
INSERT INTO suzBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","बुश हुहुचील, गोरशो रागी ङा हुहुचीलपुकी, ङांइ ब्‍वाइब ब्‍वारदे, ");
INSERT INTO suzBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, बोकुला नेल्‍ल, फाप्रे चिक्‍ब नु पकातिक्‍ती मब्‍वने। यसैया ६६:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","फ्रां पाइश्‍शो, ४ ओटा खोइलीम ग्रे‍शा गाक्‍ब जन्‍तु नेल्‍ल इन कली ग्रांग्रा बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","मिनु ४ ओटा खोइलीम ग्रेशा गाक्‍ब, फ्रां पाइश्‍शो खपीम प्रेक्‍चा कली खोइल बोइश्‍शो नेल्‍ल मालेपुकी ब्‍वने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","गे सल्‍हा माले, खुइले माले, किथ्रो माले नु फटेङग्रापुकी ब्‍वने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","४ ओटा खोइल पाइश्‍शो नु फ्रां पाइश्‍शो नेल्‍ल इन कली ग्रांग्रा बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","मेकोपुकी रे गेपुकी ग्रांग्रा दिशो दुम्‍नीनी। सुमी मेको आन सिनु थीबा, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","मिनु सुमी मेको सिनु रे इच्‍का कुरबा, मेकोमी आ वा मुरचा माल्‍ब। मिनु नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","मिनु तेको जन्‍तु आन गेंच जेश्‍शो बाक्‍बा, तन्‍न मब्राक्‍शो बाक्‍बा, मेको शोंया महेक्‍बा, मेको इन कली ग्रांग्रा बाक्‍ब। मेको थीब नेल्‍ल ग्रांग्रा दिशो दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","मिनु ब्रेप्‍चोम थेक्‍शा ४ ओटा खोइलीम गाक्‍ब जन्‍तु नेल्‍ल इन कली ग्रांग्रा बाक्‍नीम। मेको आन सिनु थीब नेल्‍ल नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","मेको सुमी आन सिनु कुरब मेकोमी आ वा मुरचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। मेको इन कली ग्रांग्रा दिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","मिनु खपीम ग्रेशा गाक्‍ब आइक्‍च जन्‍तु तेको ग्रांग्रा दिशो बाक्‍नीम देंशा हना, कोचोम्‍बो, यिच, ठेयब नु आइक्‍च खोते नेल्‍ले, ");
INSERT INTO suzBl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","माउसुली, घोरी, भाले मुङग्रो, बाल्‍वाम बाक्‍ब खोते नु रङ फाइक्‍ब खोतेपुकी, ");
INSERT INTO suzBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","मेको ग्रे‍शा गाक्‍ब नेल्‍ल इन कली ग्रांग्रा बाक्‍नीम। सुमी मेको आन सिनु थीबा, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","मोदेंशो जन्‍तु बेक्‍शा, मार तारी दोक्‍बा, मेको थोव़क ग्रांग्रा दिशो दुम्‍ब। शी के सेल्‍शो, वा, कुशुल, भाङग्रा नु मारेइ के बाक्‍ल, मेको थोव़क ब्‍वाक्‍कुम नुप्‍चा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। मिनु नोले ठीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","मिनु मेको मार मार खप के बोसुम दोक्‍त हना, मेको बोस नेल्‍ल ग्रांग्रा दिशो दुम्‍ब। गेपुकीमी मेको बोस प्रोल्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","मेको आगाम ब्‍वाक्‍कु बाक्‍त हना, मिनु मेको ब्‍वाक्‍कुम थिशो मारेइ मारेइ जचा थोव़क ग्रांग्रा दिशो दुम्‍ब। मिनु मेको बोसुम बाक्‍शो तूचा थोव़क नेल्‍ल ग्रांग्रा दिशो दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","मेको आन सिनु मारेइ थोव़कम दोक्‍त हना, चुप्‍लुम बाक्‍त हना यो, मेको प्रेश्‍शा ताइक्‍चा माल्‍ब। मेको ग्रांग्रा दिशो बाक्‍ब। मेको गेना हना यो इन कली ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","मो हना यो ब्‍वाक्‍कु बुक्‍तीके, कुवा नु ब्‍वाक्‍कु वोइक्‍तीके चोव़खो बाक्‍नीम। तन्‍न मेको आन सिनु थीब चहिं ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","मेको आन श्‍ये शोक्‍तीक वांचेरम दोक्‍त हना, मेको चहिं चोव़खो लीब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","तन्‍न मेको आ सिनु शोक्‍चा कली ब्‍वाक्‍कुम वोइश्‍शो वांचेर तारी दोक्‍त हना, मेको इन कली ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","इन बस्‍तु भाव बेक्‍त हना, सुमी मेको कली थीब, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","मेको सुम ब्‍वाइबा, मेकोमी आ वा मुरचा माल्‍ब नु नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। मेको सिनु कुरबमी यो आ वा मुरचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। प्रस्‍थान २२:३० ");
INSERT INTO suzBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","खपीम ग्रे‍शा गाक्‍ब जन्‍तु नेल्‍ल ग्रांग्रा दिशो बाक्‍नीम। मेको ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","कोव़जीम ग्रे‍शा गाक्‍ब, ४ ओटा खोइलीम गाक्‍ब नु शुश खोइल पाइश्‍शो खपीम गाक्‍ब जन्‍तुपुकी ब्‍वचा मदुम्‍ब। मारदे हना मेकोपुकी ग्रांग्रा दिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","मिनु गेपुकी तेकोइ ग्रे‍शा गाक्‍ब जन्‍तु रे ग्रांग्रा दिशो मदुमीन। मेकोपुकी रे इन कली ग्रांग्रा दिशो मसेलीन। ");
INSERT INTO suzBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","मिनु गो परमप्रभु यावे, इन परमप्रभु नङ। मोपतीके गेपुकी ग्रांग्रा दिशो मदुम्‍थु मेको रे ङोन बाक्‍कीन। मारदे हना गो ग्रांग्रा दिशो रे ङोन बाक्‍नुङ। गेपुकी खपीम ग्रे‍शा गाक्‍ब जन्‍तु रे ग्रांग्रा दिशो मदुमीन। लेवी १९:२ ");
INSERT INTO suzBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","गो परमप्रभु यावे, इन कली इजीप्‍त रागी रे ग्रुंइशा एक चाक्‍ब, इन परमप्रभु नङ। मोपतीके गेपुकी ग्रांग्रा दिशो रे ङोन बाक्‍कीन। मारदे हना गो ग्रांग्रा दिशो रे ङोन बाक्‍नुङ’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","एको रागी ङा जन्‍तु, चिक्‍ब नु ब्‍वाक्‍कुम गाक्‍ब नु खपीम ग्रे‍शा गाक्‍ब जन्‍तु आन पर्बम अरेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","मिनु ग्रांग्रा दिशो नु ग्रांग्रा मदिशो, ब्‍वचा दुम्‍ब नु मदुम्‍ब जन्‍तु आन पर्बम तिलीन। ");
INSERT INTO suzBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएली आन कली ‘कोव़ज कुरशा तौ थीब मीश मुर ७ नाक्‍त सम्‍म ग्रांग्रा दिशो बाक्‍ब। मेको आ रां ब्रोल्‍म नाक्‍त ङा खोदेंशो पा ग्रांग्रा बाक्‍ब। लेवी १५:१९ ");
INSERT INTO suzBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","मिनु ८ नाक्‍ती मेको आ तौ कली ख्रोइक्‍तीक चिनु ख्रोइक्‍चा माल्‍ब। उत्‍पत्ती १७:१०-१२; लूका २:२१; यूहन्‍ना ७:२२ ");
INSERT INTO suzBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","मिनु मेको मीश मुर आ हुश चोव़खेचा कली ३३ नाक्‍त सम्‍म दुम्‍चा माल्‍ब। मिनु मेकोमी चोव़खो दुम्‍तीक नाक्‍ती मगाम सम्‍म मारेइ चोव़खो थोव़क थिचा मदुम्‍ब। मिनु ग्रुम्‍तीक ताम्‍बु यो ओव़चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","तन्‍न मेकोमी तमी थिप्‍तु हना, आ रां ब्रोल्‍म नाक्‍त ङा खोदेंशो पा १४ नाक्‍त सम्‍म ग्रांग्रा दिशो बाक्‍ब। मिनु आ हुश चोव़खेचा कली ६६ नाक्‍त दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","मिनु मेको आ चोव़खेतीक गाम नाक्‍ती, तौ आ पर्बम बाक्‍त हना यो, तमी आ पर्बम बाक्‍त हना यो, मेकोमी चोशा चढ़ेचा कली बर्स का गाप्‍शो भेडा का नु पाप आ पर्बम चढ़ेचा कली ढुकुर का कि परवा का ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम बाक्‍शो चढ़ेब कली चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","मिनु चढ़ेबमी परमप्रभु यावे आ ङोंइती मेको चढ़ेशा, मेको आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेको आ हुश यिशो रे चोव़खो दुम्‍ब। मेको मीश मुरुमी तौ कि तमी थिवा नोले, एको पचा माल्‍शो अरेतीक लोव़ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","मिनु मेकोमी भेडा चाक्‍ने मचाप्‍बाक्‍त हना, ढुकुर निक्‍शी कि परवा निक्‍शी चाक्‍चा माल्‍ब। मेको का चोशा चढ़ेतीक नु का पाप आ पर्बम चढ़ेतीक बाक्‍ब। मिनु चढ़ेबमी मेको चढ़ेशा मेको आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेको ग्रांग्रा मदिशो दुम्‍ब’ माइक्‍मी” देंत। लेवी ५:७; लूका २:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमप्रभु यावेमी मोसा नु हारून आस कली गन्‍ती १२:१०-१२; ब्‍यवस्‍था २४:८-९; अय्‍युब १८:१३ ");
INSERT INTO suzBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“सुइ मुर आन रां ङा कुशुल बोरत हना, गार दुम्‍त हना, बुश दुम्‍त हना, मेको कोव़र खोदेंशो दुम्‍त हना, मेको कली चढ़ेब हारून कि आ तौ का आ बाक्‍तीके चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","मिनु मेको चढ़ेबमी आ रांम दुम्‍शो गार कोव़चा माल्‍ब। मिनु मेको आ गारम बाक्‍शो चां बुश बाक्‍त नु मेको आ गार इच्‍का लुक्‍च लशो बाक्‍त हना, मेको याक्‍सीब रोइ बाक्‍ब। मिनु चढ़ेबमी मेको कली कोव़ङा नोले ‘एको ग्रांग्रा बाक्‍ब’ देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","तन्‍न मेको कुशुल ङा बुश गार कुशुल लुक्‍च मलशो बाक्‍त हना, मिनु मेकेर वाशो चां यो बुश मदुम्‍शो बाक्‍त हना, चढ़ेबमी मेको रोइ पाइब मुर कली ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","मिनु चढ़ेबमी ७ नाक्‍त नोले मेको गार लेंशा कोव़चा माल्‍ब। मिनु मेको कुशुल ङा गार एर ओंथ मबारशो बाक्‍त हना, चढ़ेबम मेको कली अर्को ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","मिनु लेंशा ७ नाक्‍त नोले चढ़ेबमी कोव़ङानु, आ गार बारचा नांइसाक्‍व हना, आ कुशुलम मब्रशो बाक्‍त हना, चढ़ेबम मेको कली ग्रांग्रा मदिशो बाक्‍ब, मेको गार ला बाक्‍ब, देंचा माल्‍ब। मेको मुर आ वा मुरचा माल्‍ब। मिनु मेको चोव़खो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","तन्‍न चढ़ेबमी ‘चोव़खो दुम्‍त’ देंम नोले यो गार बारत हना, मेको लेंशा चढ़ेब आ बाक्‍तीक जाक्‍शा, आ गार कोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","मिनु चढ़ेबमी लेंशा कोव़चा माल्‍ब। आ गार कुशुलम बारशा लशो बाक्‍त हना, चढ़ेबमी ‘मेको कली ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको कोव़र खोदेंशो याक्‍सीब रोइ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","मिनु सुइ मुर कली कोव़र खोदेंशो याक्‍सीब रोइ दुम्‍शो बाक्‍त हना, चढ़ेब आन बाक्‍तीकेम चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","मिनु चढ़ेबमी मेको कली कोव़चा माल्‍ब। मिनु आ कुशुल बुश दुम्‍शा बोरशो बाक्‍त हना, नु मेको आ गार ङा चां बुश दुम्‍शा, बोरशो कुशुल ङा गारम श्‍ये तांइसाक्‍व हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","मेको शुश नाक्‍ती सम्‍म बाक्‍ब कुशुल ङा रोइ कोव़र बाक्‍ब। मिनु चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेकोमी मेको कली तिल्‍शा वोइक्‍चा ममाल्‍ब। मारदे हना मेको ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","मिनु मेको आ रोइ कुशुलम बारना बारन लशा, चढ़ेबमी कोव़ङानु, आ गार पिया रे खोइल सम्‍म बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","चढ़ेबमी मेको कली रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको कुशुल ङा रोइम आ रां नेल्‍ल कली सुम्‍शो बाक्‍त हना, चढ़ेबमी मेको कली ‘ग्रांग्रा मदिशो बाक्‍ब’ देंचा माल्‍ब। मारदे हना मेको आ रां नेल्‍ल बुश दुम्‍तीके, मेको मुर ग्रांग्रा मदिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","तन्‍न मेको मुर आ रांम श्‍ये तांइसाक्‍व हना, मेको ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","मिनु चढ़ेबमी मेको तांइसीशो श्‍ये कोव़शा, मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको तांइसीशो श्‍ये ग्रांग्रा बाक्‍ब। मारदे हना मेको कोव़र बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","तन्‍न मेको तांइसीशो श्‍ये लेंशा बुश दुम्‍त हना, मेको मुर लेंशा चढ़ेब आ बाक्‍तीक लचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","मिनु मेको गार बुश दुम्‍शो बाक्‍त हना, मेको चढ़ेबमी ग्रांग्रा मदिशो बाक्‍ब देंचा माल्‍ब। मिनु मेको मुर चोव़खो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","सुइ मुर आ रांमी कान ग्रूशा, सात हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","मिनु मेको कान ग्रूशा साशो गारम बुश दुम्‍शा, बोरत हना, कि लल दुम्‍शा बुश पा बोरत हना, मेको मुरुमी मेको आ गार चढ़ेब कली कोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","मिनु चढ़ेबमी रिम्‍शो पा कोव़ङानु, मेको गार लुक्‍च लशो बाक्‍त नु चां यो बुश दुम्‍शो बाक्‍त हना, मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको कोव़र खोदेंशो रोइ कान रे ग्रूशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","तन्‍न चढ़ेबमी रिम्‍शो पा कोव़ङानु, मेकेर बुश चां मग्रूशो बाक्‍त नु मेको कुशुल क्‍येङा लुक्‍च मलशो बाक्‍त हना, तन्‍न सोव़ना सोव़न, जाम्‍ना जाम्‍न लशो बाक्‍त हना, चढ़ेबमी मेको कली ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","मेको गार कुशुलम बारना बारन लत हना, चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मारदे हना मेको याक्‍सीब रोइ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तन्‍न मेको गार एर ओंथ मबारथु, मेक उइ ला बाक्‍त हना, मेको कान आ खत बाक्‍ब। चढ़ेबमी मेको कली ‘ग्रांग्रा मदिशो बाक्‍ब’ देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","सुइ मुर आन रांमी दुप्‍शा गार दुम्‍त नु मेको दुप्‍शो गारम नक श्‍ये ग्रूशा, लल दुम्‍त हना यो, बुश दुम्‍त हना यो, ");
INSERT INTO suzBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","चढ़ेबमी मेको गार रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको गार ङा चां बुश दुम्‍शा, कुशुल क्‍येङा लुक्‍च लशो बाक्‍त हना, मेको याक्‍सीब रोइ बाक्‍ब। मेको दुप्‍शो गार रे ग्रूशो बाक्‍ब। मिनु चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको कुशुल ङा याक्‍सीब रोइ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","तन्‍न चढ़ेबमी रिम्‍शो पा कोव़ङानु, मेको गार ङा चां बुश मबाक्‍थु नु कुशुल क्‍येङा लुक्‍च मलथु, सोव़ना सोव़न बाक्‍त हना, चढ़ेबमी मेको मुर कली ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","मिनु चढ़ेबमी मेको कली ७ नाक्‍त नोले रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको कुशुलम एर ओंथ बारशो बाक्‍त हना, चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको याक्‍सीब कुशुल ङा रोइ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","तन्‍न मेको गार एर ओंथ मबारथु, सोव़ना सोव़न लशो बाक्‍त हना, मेको दुप्‍शो रे होम्‍शो ला बाक्‍ब। मिनु चढ़ेबमी मेको कली ‘ग्रांग्रा मदिशो बाक्‍ब’ देंचा माल्‍ब। मारदे हना, मेको दुप्‍शो गार आ खत ला बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","सुइ मीश मुर, वोंइश मुर आन पियाम, गाल शोक्रेम मारेइ गार का बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","चढ़ेबमी मेको गार रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको कुशुल क्‍येङा लुक्‍च लशो बाक्‍त हना, नु मेको गार ङा चां हाव जिशो नु आइक्‍च बाक्‍त हना, चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको रक सुइब आ पिया ङा नु गाल शोक्रे ङा याक्‍सीब रोइ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","मिनु चढ़ेबमी मेको रक सुइब रोइ रिम्‍शो पा कोव़ङानु, मेको कुशुल क्‍येङा लुक्‍च मलशो नु मेकेर क्‍येर चां यो मबाक्‍तेक्‍म हना, चढ़ेबम मेको कली ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","मिनु ७ नाक्‍त नोले चढ़ेबमी मेको कली रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको रक सुइब रोइ मबारशो बाक्‍त हना, मेक ङा चां हाव मजिशो बाक्‍त नु गार यो कुशुल क्‍येङा लुक्‍च मलशो बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","मेकोमी गार प्रोंइशा आ चां प्रेक्‍चा माल्‍ब। मिनु चढ़ेबम मेको रोइ पाइब कली अर्को ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","मिनु ७ नाक्‍त नोले चढ़ेबमी मेको रक सुइब गार रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको मबारथु, कुशुल क्‍येङा लुक्‍च मलशो बाक्‍त हना, चढ़ेबमी मेको कली ‘ग्रांग्रा मदिशो बाक्‍ब’ देंचा माल्‍ब। मिनु मेको मुर आ वा मुरशा, चोव़खो दुम्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तन्‍न मेको चोव़खो दुम नोले यो मेको रक सुइब रोइ बारशा लत हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","चढ़ेबमी मेको गार रिम्‍शो पा कोव़चा माल्‍ब। मेको कुशुलम बारशा लशो बाक्‍त हना, चढ़ेबमी मेकेर ङा चां हाव बाक्‍म कों मबाक्‍म, दे कोव़चा ममाल्‍ब। मेको मुर ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","तन्‍न चढ़ेबमी मेको रक सुइब रोइ रिम्‍शो पा कोव़ङानु मेकेर क्‍येर चां वाशो बाक्‍त हना, मेको साशो बाक्‍ब। मेको ग्रांग्रा मदिशो बाक्‍ब। मिनु चढ़ेबम मेको कली ‘ग्रांग्रा मदिशो बाक्‍ब’ देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","सुइ मीश मुर, वोंइश मुर आन रांम बुश गारपुकी बाक्‍तेक्‍म हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","चढ़ेबमी मेको रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको आन रां ङा गारपुकी बुश बाक्‍तेक्‍म हना, मेको कुशुल ङा रोइ ला बाक्‍ब। मेको कुशुल रे ला ग्रूशो बाक्‍ब। मेको मुर ग्रांग्रा मदिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","सुइ मुर आन पिया ङा चां दुल्‍शो बाक्‍त हना, मेको ग्रांग्रा मदिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","मेको आ चां कुप्‍फी रे दुल्‍शो बाक्‍त हना, मेको ग्रांग्रा मदिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तन्‍न मेको आन कुप्‍फीमी लल बुश गार ग्रूत हना, मेको कुप्‍फीम ग्रूशो याक्‍सीब रोइ बाक्‍ब ");
INSERT INTO suzBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","मिनु चढ़ेबमी मेको कली रिम्‍शो पा कोव़ङानु, आ कुप्‍फीम होम्‍शो गार लल बुश नु कोव़र खोदेंशो तांइसाक्‍व हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","मेको मुर कोव़र पशो नु ग्रांग्रा दिशो बाक्‍ब। मिनु चढ़ेबमी मेको कली ‘ग्रांग्रा दिशो बाक्‍ब’ देंचा माल्‍ब। मेको रोइ आ पियाम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","कोव़र प‍शो मुरुम गाक्‍शो वा फेक्‍शा, आ पियाम मारेइ गुप्‍चा मदुम्‍ब। मेकोमी आ गाल शोक्रे कली सुम्‍शा ‘ग्रांग्रा दिशो, ग्रांग्रा दिशो’ दे ग्रीचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","मेको आ रोइ गेना सम्‍म लीबा, मेना सम्‍म मेको ग्रांग्रा दिशो दुम्‍ब। मेको आ कांइचीक बाक्‍चा माल्‍ब। मिनु मेको मुर आन बाक्‍तीक क्‍येङा ङोन बाक्‍चा माल्‍ब। गन्‍ती ५:२-३; २राजा १५:५ ");
INSERT INTO suzBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","मिनु वाम बुंखी ङाइक्‍ताक्‍व हना, ऊन के वासी बाक्‍त हना यो, सुती के वासी बाक्‍त हना यो, ");
INSERT INTO suzBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","फेक्‍तीक नेल्‍ल, कुशुल के सेल्‍शो मारेइ मारेइमी ");
INSERT INTO suzBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","बुंखी ङाइश्‍शा गिगी लल लुम्‍सीशो बाक्‍त हना, वासी नेल्‍ल नु मारेइ मारेइ चढ़ेब कली कोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","मिनु चढ़ेबमी मेको रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको बुंखी ङाइश्‍शो थोव़क आन कली ७ नाक्‍त सम्‍म तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","मिनु चढ़ेबमी ७ नाक्‍त नोले लेंशा रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको वासी, कुशुल के सेल्‍शो मारेइ थोव़कीम बुंखी बारशा लशो बाक्‍त हना, मेको बिग्रेब बुंखी ङाइश्‍शो बाक्‍ब। मेको थोव़क ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","मिनु मेकोमी बुंखी ङाइश्‍शो वासी कि कुशुल के सेल्‍शो मारेइ थोव़क चोचा माल्‍ब। मारदे हना मेको राक्‍ब बुंखी बाक्‍ब। मेको मीम चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","तन्‍न चढ़ेबमी रिम्‍शो पा कोव़ङानु, मेको वासी, कि कुशुल के सेल्‍शो मारेइ थोव़कम मेको बुंखी मबारशो बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","मिनु चढ़ेबमी मेको मुर कली ‘मेको बुंखी ङाइश्‍शो थोव़क मुरचा माल्‍ब’ दे अरेचा माल्‍ब। मिनु मेकोमी चिनु ७ नाक्‍त सम्‍म मेको वासी कली तिल्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","मेको मुरशो नोले चढ़ेबम मेको कली रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको बुंखी आ लुम्‍सीशो रङ मफांइसीशो बाक्‍त हना यो, मेको ग्रांग्रा दिशो बाक्‍ब। मेको बुंखी आ तार गे बाक्‍त हना यो, आगा गे बाक्‍त हना यो, मेको कली मीम चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","तन्‍न चढ़ेबमी मेको मुरशो नोले कोव़ङानु, बुंखी जाम्‍ना जाम्‍न लशो बाक्‍त हना, मेको वासी कि मारेइ मारेइ कुशुल के सेल्‍शो मेको लुम्‍सीशो ला खाक्‍शा ताइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","तन्‍न मेको बुंखी, वासी, कुशुल के सेल्‍शो मारेइ मारेइमी लेंशा तांइसाक्‍व हना, मेको बारना बारन लशो बाक्‍ब। मेको बुंखी ङाइश्‍शो थोव़क मीम चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","मिनु मेको वासी, कुशुल के सेल्‍शो मारेइ मारेइ थोव़क मुरशोनु, मेको रे बुंखी लत हना, मेको लेंशा मुरचा माल्‍ब। मेको ग्रांग्रा मदिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊन के सेल्‍शो वासीम, सुती के वासी नु कुशुल के सेल्‍शो मारेइ थोव़कम बुंखी ङाइश्‍शो आ पर्बम ग्रांग्रा दिशो नु मदिशो आन पर्बम पचा माल्‍शो गेय एकोन बाक्‍नीम, दे शेंचा” दे मोसा नु हारून आस कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“कोव़र खोदेंशो पा रोइ पशो मुर कली आ रोइ साम नोले मार पचा माल्‍ब देंशा हना, मुरुमी मेको कली चढ़ेब आन बाक्‍तीक चाक्‍चा माल्‍नीम। मत्ती ८:४ ");
INSERT INTO suzBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","मिनु चढ़ेबमी मुर आन बाक्‍तीके रे लाङगा ग्रूशा, मेको मुर कली रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको कुशुल ङा याक्‍सीब रोइ साशो बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","मेको चढ़ेबमी मेको चोव़खो सेल्‍चा पुंइसीशो मुर आ पर्बम ‘सेस नु चोव़खो चिक्‍ब निक्‍शी, लेबानोन ङा लाइश्‍शो रवा आ शी, लल रङम नुप्‍शो ऊन नु हिस्‍सोप चाक्‍को’ दे अरेचा माल्‍ब। लेवी ११:३-२०; गन्‍ती १९:६ ");
INSERT INTO suzBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","मिनु चढ़ेबमी ‘मेको चिक्‍ब निक्‍शीमी का खप के सिक्‍स ब्‍वाक्‍कुम ब्रीशो बोस तारी सतो’ दे अरेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","मिनु चढ़ेबमी मेको सेस चिक्‍ब, मेको लेबानोन ङा लाइश्‍शो रवा आ शी, मेको लल रङम नुप्‍शो ऊन नु हिस्‍सोप मेको सिक्‍स ब्‍वाक्‍कु तारी साइश्‍शो चिक्‍ब आ हुशेमी ख्रुम्‍शा ग्रुंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","मिनु मेकोमी रोइ रे साशो चोव़खो सेल्‍चा पुंइसीब मुर कली ७ खेयप ब्रुइश्‍शा ‘चोव़खो बाक्‍ब’ देंचा माल्‍ब। मिनु मेकोमी मेको सेस चिक्‍ब कली प्रोंइशा बेरपाइक्‍चा माल्‍ब। लेवी १६:२२ ");
INSERT INTO suzBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","मिनु मेको चोव़खो सेल्‍चा पुंइसीशो मुरुम आ वा मुरचा माल्‍ब। आ चां नेल्‍ल प्रेक्‍शा, चिक्‍चा माल्‍ब। मिनु मेको ग्रांग्रा मदिशो चोव़खो दुम्‍ब। मिनु नोले मुर आन बाक्‍तीके लचा दुम्‍ब। तन्‍न ७ नाक्‍त सम्‍म आ ताम्‍बु आ लाङगाम बाक्‍चा माल्‍ब। गन्‍ती ८:७ ");
INSERT INTO suzBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","मिनु ७ नाक्‍त नोले मेकोमी आ चां, गाल शोक्रे, मुकुक्‍स नेल्‍ल प्रेक्‍चा माल्‍ब। मिनु नोले आ वा मुरशा, चिक्‍चा माल्‍ब। मिनु मेको मुर चोव़खो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","मिनु ८ नाक्‍त नोले मेकोमी मारेइ मदुम्‍शो थम रिम्‍शो सांड निक्‍शी नु बर्स का दुम्‍शो मारेइ मदुम्‍शो थम रिम्‍शो पाठी का, अन्‍न चढ़ेचा कली तेलम निशो थम रिम्‍शो फस एफाह का के ३० भाग नु लोग का तेल चाक्‍चा माल्‍ब। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको ङा ३० भाग ६.५ लिटर खोदेंशो बाक्‍ब। नेल्‍ल १२ माना खोदेंशो बाक्‍ब। लोग का पुक्‍तीके का बाक्‍ब। मेको ०.३ लिटर रिक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","मिनु चढ़ेबमी मेको चोव़खो सेल्‍चा पुंइसीशो मुर नु मेको आ चाक्‍शो नेल्‍ल परमप्रभु यावे आ ङोंइती ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","मिनु चढ़ेबमी सांड का नु मेको लोग का तेल गारचा आ पर्बम चढ़ेचा माल्‍ब। मिनु क्‍युक्‍शा हिम्‍शा चढ़ेतीक परमप्रभु यावे आ ङोंइती चढ़ेचा माल्‍ब। लोग आइक्‍च पुक्‍तीके बाक्‍ब। मेको ०.३ लिटर रिक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","मिनु मेकोमी पाप आ पर्बम चढ़ेतीक नु चोशा चढ़ेतीक साइक्‍तीके मेको चोव़खो बाक्‍तीकेम साइक्‍चा माल्‍ब। मारदे हना गारचा आ पर्बम चढ़ेशो नु पाप आ पर्बम चढ़ेशो चढ़ेब के दुम्‍ब। मेको थम चोव़खो बाक्‍ब। लेवी ७:७ ");
INSERT INTO suzBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","मिनु चढ़ेबमी मेको गारचा आ पर्बम चढ़ेशो आ हुश लाइश्‍शा, मेको चोव़खो सेल्‍चा पुंइसीशो मुर आ ग्‍युरा नोफा आ फेनेम, आ ग्‍युरा गुइ ङा बोंग्‍ये नु आ ग्‍युरा खोइल ङा बोंग्‍येमी ख्रेक्‍चा माल्‍ब। लेवी ८:२३; प्रस्‍थान २९:२० ");
INSERT INTO suzBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","मिनु चढ़ेबमी मेको तेल रे इच्‍का लाइश्‍शा, आ पेरा गुइ ङा ताप्‍लाम लुक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","मिनु चढ़ेबमी आ ग्‍युरा गुइ ङा ब्रेप्‍चोम आ पेरा गुइम बाक्‍शो तेलम ख्रुम्‍शा, परमप्रभु यावे आ ङोंइती ७ खेयप ब्रुइक्‍चा माल्‍ब। लेवी ४:६,१७ ");
INSERT INTO suzBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","मिनु चढ़ेबमी आ गुइम लीशो तेल चोव़खो सेल्‍चा पुंइसीशो मुर आ ग्‍युरा नोफा ङा फेनेम, मेको आ ग्‍युरा गुइ ङा बोंग्‍येमी नु आ ग्‍युरा खोइल ङा बोंग्‍येम नु गारचा आ पर्बम चढ़ेशो आ हुश तारी ख्रेक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","मिनु चढ़ेबमी आ गुइम लीशो तेल मेको चोव़खो सेल्‍चा पुंइसीशो मुर आ पियाम ख्रेक्‍चा माल्‍ब। मिनु चढ़ेबमी परमप्रभु यावे आ ङोंइती मेको मुर आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","मिनु चढ़ेबमी मेको आ पाप आ पर्बम चढ़ेचा माल्‍ब। मोपा मेको चोव़खो सेल्‍चा पुंइसीशो मुरुम पाप क्‍याम्‍तीक गेय पशो बाक्‍ब। मिनु नोले मेकोमी चोशा चढ़ेतीक क्‍योरचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","मिनु चढ़ेबमी मेको चोशा चढ़ेतीक नु अन्‍न चढ़ेतीक चढ़ेतीकेम चढ़ेचा माल्‍ब। मोपा मेको चढ़ेबमी मेको आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेको मुर ग्रांग्रा मदिशो चोव़खो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","मिनु मेको मुर प्रुङग बाक्‍त हना, मोशो यो चाक्‍ने मचाप्‍बाक्‍त हना, मेकोमी आ पाप क्‍याम्‍तीक गेय आ पर्बम क्‍युक्‍शा हिम्‍शा चढ़ेचा कली सांड का नु अन्‍न चढ़ेचा कली तेलम निशो एफाह का के १० भाग थम रिम्‍शो फस नु लोग का तेल चाक्‍चा माल्‍ब। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको के १० भाग २ लिटर नु इच्‍का खोइ बाक्‍ब। लोग आइक्‍च पुक्‍तीके का बाक्‍ब। मेको ०.३ लिटर रिक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","मिनु आ चाप्‍शो खोदेंशो पा परवा निक्‍शी कि ढुकुर निक्‍शी, का पाप आ पर्बम चढ़ेचा कली नु का चोशा चढ़ेचा कली चाक्‍चा माल्‍ब। लेवी ५:७ ");
INSERT INTO suzBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","मिनु मेकोमी ८ नाक्‍ती आंम कली चोव़खो सेल्‍पाइक्‍चा कली मेको निक्‍शी ग्रुम्‍तीक ताम्‍बु आ ओव़तीक परमप्रभु यावे आ ङोंइती चढ़ेब आ बाक्‍तीकेमी चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","मिनु चढ़ेबमी गारचा आ पर्बम चढ़ेचा कली मेको सांड नु लोग का तेल चाक्‍शा, क्‍युक्‍शा, हिम्‍शा, चढ़ेतीके परमप्रभु यावे आ ङोंइती क्‍युक्‍शा हिम्‍शा चढ़ेचा माल्‍ब। लोग का इस्राएली आन आइक्‍च पुक्‍तीक का बाक्‍ब। मेको ०.३ लिटर रिक्‍ब। मेको माना का नु इच्‍का खोइ खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","मिनु चढ़ेबमी मेको गारचा आ पर्बम चढ़ेतीक सांड क्‍योरशा, मेको आ हुश इच्‍का लाइश्‍शा, चोव़खो सेल्‍चा पुंइसीब मुर आ ग्‍युरा नोफा ङा फेनेम, आ ग्‍युरा गुइ ङा बोंग्‍ये नु आ ग्‍युरा खोइल ङा बोंग्‍येमी ख्रेक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","मिनु चढ़ेबमी मेको तेल इच्‍का आ पेरा गुइ ङा ताप्‍लाम लुक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","मिनु आ ग्‍युरा गुइ ङा ब्रेप्‍चोम पेरा गुइम बाक्‍शो तेल परमप्रभु यावे आ ङोंइती ७ खेयप ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","मिनु चढ़ेबमी आ गुइम बाक्‍शो तेल मेको चोव़खो सेल्‍चा पुंइसीब मुर आ ग्‍युरा नोफा आ फेनेम, आ ग्‍युरा गुइ ङा बोंग्‍ये नु आ ग्‍युरा खोइल ङा बोंग्‍येम गारचा आ पर्बम चढ़ेशो आ हुश ख्रेक्‍शो तार ख्रेक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","मिनु चढ़ेबमी आ गुइम लीशो तेल मेको चोव़खो सेल्‍चा पुंइसीब मुर आ पियाम ख्रेक्‍चा माल्‍ब। मोपा मेकोमी चोव़खो सेल्‍चा पुंइसीब मुर कली परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पाइब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","मिनु मेकोमी ढुकुर कि परवा आ चाप्‍शो खोदेंशो पा चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","मिनु का पाप आ पर्बम, का चोशा चढ़ेचा कली अन्‍न चढ़ेतीक नु चढ़ेचा माल्‍ब। मोपा चढ़ेबमी चोव़खो सेल्‍चा पुंइसीब मुर आ पर्बम परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","कुशुल ङा याक्‍सीब रोइ पशा, चोव़खो दुम्‍तीक आ पर्बम प्रुङग आन पचा माल्‍शो गेय एको बाक्‍ब” देंत। लेवी १३:४७-५९ ");
INSERT INTO suzBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“मुल गो इन कली गेशो कनान रागीम जाक्‍दीश्‍शा बाक्‍नीनु, इन आंम के सेल्‍नी नोले, गो मेको रागी ङा तेकोइ खिंम बुंखी ङाइक्‍पाइक्‍ता हना, ");
INSERT INTO suzBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","मेको खिं ङा मुर जाक्‍शा चढ़ेब कली ‘आं खिंम बुंखी ङाइश्‍शो खोदेंशो तांइसाक्‍व’ देंचा माल्‍ब। लेवी १३:२ ");
INSERT INTO suzBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","मिनु चढ़ेबमी ‘आं जाक्‍शा रिम्‍शो पा कोव़चा क्‍येङा ङोंइती इ खिं कली श्‍येत्‍थ पावो। मो मपाइतीनी हना खिंम बाक्‍शो मारेइ मारेइ ग्रांग्रा दिशो दुम्‍ब’ दे अरेचा माल्‍ब। मिनु नोले मेको चढ़ेब मेको खिं कोव़थ लचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","मिनु मेकोमी मेको बुंखी ङाइश्‍शो रिम्‍शो पा कोव़चा माल्‍ब। मेको खिं ङा गारो गिगी, लल दुम्‍शा, गारो क्‍येङा लुक्‍च लशो बाक्‍त हना, लेवी १३:३ ");
INSERT INTO suzBl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","चढ़ेब खिं रे लाङगा ग्रूशा, ७ नाक्‍त सम्‍म लाप्‍चो चोक्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","मिनु मेको चढ़ेब ७ नाक्‍त नोले जाक्‍शा, मेको बुंखी गारोम बारशो बाक्‍म कों मबाक्‍म रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको गारोम बारशो बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","चढ़ेबमी मेको बुंखी ङाइश्‍शो फुल्‍लु ग्रुंइपाइश्‍शा, सहर क्‍येङा ङोन ग्रांग्रा दिशो ताइक्‍तीकेमी ताइक्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","मेको खिं आगा तेइ तेइ खोतेर पपाइक्‍चा माल्‍ब। मिनु खोतेर पाइश्‍शो खप सहर क्‍येङा ङोन ग्रांग्रा दिशो ताइक्‍तीकेमी ताइक्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","मिनु नोले मेकोपुकीमी ताइश्‍शो फुल्‍लु आ पा ङा अर्को फुल्‍लु चाक्‍शा, मेको फुल्‍लु बाक्‍तीकेम प्रोव़चा माल्‍नीम। मिनु नक खप चाक्‍शा, खिं सिल्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","मिनु फुल्‍लु ग्रुंइशा, अर्को फुल्‍लु प्रोव़शा, खप खोतेर पा ग्रुंइशा, अर्को खप सिल्‍शा यो, मेको बुंखी लेंशा ग्रूत हना, ");
INSERT INTO suzBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","चढ़ेबमी लेंशा जाक्‍शा, रिम्‍शो पा कोव़चा माल्‍ब। मिनु मेको बुंखी खिंम बारना बारन लशो बाक्‍त हना, मेको बारतीक बुंखी ङाइश्‍शो बाक्‍ब। मेको खिं ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","मिनु मेको खिं कली प्रेत्‍चा माल्‍ब। मेको आ फुल्‍लु, शी नु सिल्‍शो खप सहर क्‍येङा ङोन ग्रांग्रा दिशो ताइक्‍तीकेमी ताइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","मिनु सुइ मेको खिं चोक्‍शो नोले ओव़त हना, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। लेवी ११:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","मिनु सुइ मेको खिंमी इप्‍त हना यो, जाप्‍तु हना यो, मेकोमी आ वा मुरचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","तन्‍न चढ़ेबमी मेको खिं रिम्‍शो पा कोव़ङानु, सिल्‍शा फिक्‍शा नोले मेको बुंखी ङाइश्‍शो मबारत हना, चढ़ेबमी मेको खिं कली ‘ग्रांग्रा मदिशो चोव़खो बाक्‍ब’ देंचा माल्‍ब। मारदे हना मेको बुंखी जाम्‍शा लत। ");
INSERT INTO suzBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","मिनु मेको खिं ङा मुरुमी खिं कली चोव़खो सेल्‍चा कली चिक्‍ब निक्‍शी, लेबानोन ङा लाइश्‍शो रवा आ शी, हिस्‍सोप नु लल श्‍येले चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","मिनु चढ़ेबमी ‘मेको चिक्‍ब निक्‍शीमी का खप के सिक्‍स ब्‍वाक्‍कुम ब्रीशो बोस तारी सतो’ दे अरेचा माल्‍ब। लेवी १४:४-७ ");
INSERT INTO suzBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","मिनु चढ़ेबमी मेको लेबानोन ङा लाइश्‍शो रवा आ शी, हिस्‍सोप नु लल रङम नुप्‍शो श्‍येले नु मेको सेस चिक्‍ब लाइश्‍शा, मेको नेल्‍ल कली मेको सिक्‍स ब्‍वाक्‍कु तारी साइश्‍शो चिक्‍ब आ हुशेमी ख्रुम्‍शा ग्रुंइचा माल्‍ब। मिनु मेकोमी मेको खिं कली ७ खेयप ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","मोपा मेकोम चिक्‍ब आ हुश, सिक्‍स ब्‍वाक्‍कु, सेस चिक्‍ब, लेबानोन ङा लाइश्‍शो रवा आ शी, हिस्‍सोप नु लल रङम नुप्‍शो श्‍येलेमी मेको खिं ग्रांग्रा मदिशो चोव़खो सेल्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","मिनु मेकोमी मेको सेस चिक्‍ब कली सहर रे लाङगा प्रोंइशा बेरपाइक्‍चा माल्‍ब। मोपा मेकोमी मेको खिं ङा बुंखी क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेको खिं ग्रांग्रा मदिशो चोव़खो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","मिनु कुशुल ङा याक्‍सीब रोइ नेल्‍ल, रक सुइब रोइ, ");
INSERT INTO suzBl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","वासी नु खिं ङा बुंखी ङाइक्‍तीके, ");
INSERT INTO suzBl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","होम्‍शो नु आइक्‍च गार नु बुश लुम्‍सीशो गारपुकी चोव़खो सेल्‍तीक गेय एकोन बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ग्रांग्रा दिशो नु मदिशो तुइक्‍तीक एको बाक्‍ब। मेको कोव़र नु कोव़र खोदेंशो रोइ नु बुंखी ङाइश्‍शो आन पर्बम पतीक गेय एकोन बाक्‍नीम” दे परमप्रभु यावेमी मोसा नु हारून आस कली माइक्‍तीम्‍सी। ");
INSERT INTO suzBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएली आन कली ‘सुइ वोंइश मुर आन के मार मार यित हना यो, मेको यितीके मेको मुर ग्रांग्रा दिशो बाक्‍ब। गन्‍ती ५:२ ");
INSERT INTO suzBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","मेको आ रां रे यितीके मार बाक्‍ब देंशा हना, रां रे यित हना यो, देक्‍त हना यो, मेको मुर ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","मेको मुर इप्‍शो ब्राख्‍ये नेल्‍ल नु आ निश्‍शो नित्‍तीके नेल्‍ल ग्रांग्रा दिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","सुमी मेको आ ब्राख्‍ये थीबा, मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","मिनु सु मेको आ नित्‍तीकेमी निप्‍बा, मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","सुमी मेको मुर कली थीबा, मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","मेको मुरुमी चोव़खो मुर कली तोक्‍ताक्‍व हना, मेको चोव़खो मुर चिक्‍सीचा माल्‍ब। मेकोमी आ वा मुरचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","मेको मुर तेको शारा तार ब्रतीके थेंकाम निप्‍बा, मेको ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","सुमी मेको आ नित्‍तीके थीबा, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍ब। सुमी मेको थोव़क कुरबा, मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मेको नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","मेको मुरुमी आ गुइ मचिक्‍थु, सुइ कली थिप्‍तु हना, मेको थिचा पुंइसीब मुरुम आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","मेको मुरुम तेकोइ खप के बोस थिप्‍तु हना, मेको प्रोल्‍चा माल्‍ब। तन्‍न शी के बाक्‍त हना, ब्‍वाक्‍कुम शेक्‍चा माल्‍ब। लेवी ११:३३ ");
INSERT INTO suzBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","मेको मुरुमी आ ग्रांग्रा दिशो देक्‍म नोले, चोव़खो दुम्‍चा कली ७ नाक्‍त रिम्‍चा माल्‍ब। मिनु आ वा मुरशा, आ रां नेल्‍ल ब्‍वाक्‍कुम चिक्‍सीचा माल्‍ब। मिनु मेको चोव़खो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","मिनु मेकोमी ८ नाक्‍ती परवा निक्‍शी कि ढुकुर निक्‍शी कुरशा, परमप्रभु यावे आ ङोंइती ग्रुम्‍तीक ताम्‍बु आ ओव़तीक जाक्‍शा, मेको चढ़ेब कली गेचा माल्‍ब। लेवी ५:७ ");
INSERT INTO suzBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","मिनु चढ़ेबमी मेको का पाप आ पर्बम नु का चोशा चढ़ेतीक चढ़ेचा माल्‍ब। मोपा चढ़ेबमी मेको ग्रांग्रा दिशो यिशो मुर आ पर्बम परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","मिनु सुइ वोंइश मुर आ बिउ मोशा यित हना, मेकोमी आ रां नेल्‍ल ब्‍वाक्‍कुम चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍ब। लेवी २२:४ ");
INSERT INTO suzBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","मिनु आ बिउ तेको वा नु कुशुल के सेल्‍शो मारेइमी दोक्‍त हना, मेको मुरचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","सुइ वोंइश मुर मीश मुर नु इम्‍मेनु, बिउ दोक्‍त हना, मेको निम्‍फा चिक्‍सीचा माल्‍नीस। मिनु नां मरिक्‍म सम्‍म ग्रांग्रा दुम्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","सुइ मीश मुर मथिचा दुम्‍त हना, मेको आ रां ङा दुम्‍तीक बाक्‍ब। मेको ७ नाक्‍त सम्‍म ग्रांग्रा दिशो दुम्‍ब। सुम मेको कली थीबा, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो बाक्‍ब। लेवी १८:१९ ");
INSERT INTO suzBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","मेको मीश मुर ग्रांग्रा दिशो दुम्‍मेनु, आ इप्‍तीके नु नित्‍तीके नेल्‍ल ग्रांग्रा दिशो दुम्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","सुम मेको आ ब्राख्‍ये थीबा, मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","सुम मेको आ निश्‍शो थोव़क थीबा, मेकोमी आ वा मुरचा माल्‍ब। मिनु चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","सुइ मुरुमी आ ब्राख्‍ये कि आ निश्‍शो पीरा थिप्‍तु हना, मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","मिनु वोंइश मुर मेको नु इप्‍त नु मेको आ ग्रांग्रा दिशो लुम्‍साक्‍व हना, मेको ७ नाक्‍त सम्‍म ग्रांग्रा दिशो दुम्‍ब। मिनु मेको आ इप्‍शो ब्राख्‍ये यो ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","मिनु सुइ मीश मुर आ रां ब्रोल्‍शो प्रोंइशा मेको क्‍येङा शुश नाक्‍त सम्‍म हुश यिस ङा यिस बाक्‍त हना, आ मथिचा दुम्‍शो नङा खोदेंशो पा ग्रांग्रा दिशो दुम्‍ब। मेको आ मथिचा नाक्‍त खोदेंशो पा मेको ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","मेको आ हुश यिशो नाक्‍त, आ इप्‍शो ब्राख्‍ये आ मथिचा दुम्‍शो नङा खोदेंशो पा ग्रांग्रा दिशो दुम्‍ब। आ निश्‍शो पीरा आ मथिची नङा खोदेंशो पा ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","मेको थोव़क थीब ग्रांग्रा दिशो दुम्‍ब। मेकोमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नां मरिक्‍म सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","मेकोमी आ हुश यिचा देक्‍म नोले ७ नाक्‍ती रिम्‍चा माल्‍ब। मिनु मेको नोले मेको ग्रांग्रा मदिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","मिनु ८ नाक्‍ती मेकोमी ढुकुर निक्‍शी कि परवा निक्‍शी चाक्‍शा, ग्रुम्‍तीक ताम्‍बु आ ओव़तीक चढ़ेब आ ङोंइती जाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","मिनु चढ़ेबमी का पाप आ पर्बम नु का चोशा चढ़ेतीके चढ़ेचा माल्‍ब। मोपा चढ़ेबमी मेको आ हुश यिशो आ पर्बम परमप्रभु यावे आ ङोंइती मेको आ पर्बम चोव़खो दुम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","मोपा गे निक्‍शीमी इस्राएल ङा मुर आन कली ग्रांग्रा दितीक रे ङोन वोतीस। मो मपाइतीसी हना, मेकोपुकीम आं बाक्‍तीक ताम्‍बु ग्रांग्रा दिशो सेल्‍नीम। मिनु मेको आन ग्रांग्रा आ पर्बम बेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","एको ग्रांग्रा दिशो यितीक कि बिउ दोक्‍शो ग्रांग्रा दिशो दुम्‍शो वोंइश मुर आ पर्बम चोव़खो सेल्‍तीके गेय बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","मिनु मथिचा दुम्‍शो, ग्रांग्रा यिशो वोंइश मुर कि मीश मुर नु ग्रांग्रा दिशो दुम्‍शो मीश मुर नु इप्‍ब वोंइश मुर आन कली ग्रांग्रा मदिशो सेल्‍तीक गेय एकोन बाक्‍नीम’ देंचा माल्‍नीसी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारून आ तौ निक्‍शी परमप्रभु यावे आ ङोंइती बेक्‍सा नोले परमप्रभु यावेमी मोसा नु लोव़ पाप्‍तु। लेवी १०:१-२; ");
INSERT INTO suzBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","मिनु परमप्रभु यावेमी मोसा कली “इ लोक्‍ब हारून कली ‘इ दाक्‍शो खोदेंशो पा, गेना हना यो फारशो वा आ आगा बाक्‍शो चोव़खो कोठामी कबल पशो सन्‍दोस तार बाक्‍शो शिशी पतीके आ ङोंइती मजाक्‍को। मटीतीनी हना, गे बेक्‍नेवे। मारदे हना गो शिशी बाक्‍तीकेम गोस्‍स आगाम बाक्‍शा जाक्‍नुङ। प्रस्‍थान २६:३३-३४ ");
INSERT INTO suzBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","हारून दोपा ओव़ने चाप्‍ब देंशा हना, पाप आ पर्बम चढ़ेचा कली ब्‍यफ का नु चोशा चढ़ेचा कली सांड का चाक्‍शा ला ओव़ने चाप्‍ब। लेवी ४:३; लेवी १:१० ");
INSERT INTO suzBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","सुती के आं गेय पचा कली ला आगा फेक्‍तीक वा फेक्‍शा, सुती के आ तार फेक्‍तीक फेक्‍शा, सुती के किप्‍शुर किप्‍शा नु सुती वा के पियाम गुप्‍तीक गुक्‍शा ओव़चा माल्‍ब। मेको वा आ गेय पचा कली ला बाक्‍त। मेकोमी चिक्‍सीशा ला मेको वा फेक्‍सीचा माल्‍ब। प्रस्‍थान २८:३९,४२; प्रस्‍थान २९:४; प्रस्‍थान ३०:१९-२० ");
INSERT INTO suzBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","मेकोमी इस्राएल ङा मुर आन गुइ रे पाप आ पर्बम चढ़ेचा कली बोका निक्‍शी नु चोशा चढ़ेचा कली सांड का ताक्‍चा माल्‍ब। लेवी ३:९,१५,१६ ");
INSERT INTO suzBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","मिनु हारूनमी आंम पाप आ पर्बम चढ़ेतीक ब्‍यफ चढ़ेचा माल्‍ब। मिनु आ नु आ खिं ङा मुर आन पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। लेवी ९:२, ८-११; हिब्रू ७:२७ ");
INSERT INTO suzBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","मिनु मेकोमी मेको बोका निक्‍शी लाइश्‍शा, ग्रुम्‍तीक ताम्‍बु आ ओव़तीक परमप्रभु यावे आ ङोंइती वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","मिनु हारूनमी मेको बोका निक्‍शी आ पर्बम फेन्‍टे आप्‍चा माल्‍ब। मेकोमी परमप्रभु यावे कली का नु मो प्रोंइचा कली का फेन्‍टे आप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","मिनु हारूनमी परमप्रभु यावे कली दुम्‍शो बोका कली आ नेक्‍था चाक्‍शा पाप आ पर्बम चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","फेन्‍टे आप्‍शा मो प्रोंइतीक बोका कली सेसीन परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍ब। मिनु मेको आ तारी पाप क्‍याम्‍तीक गेय पा, मेको बोका कली गोरशो रागीम प्रोंइशा सोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","मिनु हारूनमी आ आंम पाप आ पर्बम चढ़ेतीके ब्‍यफ चाक्‍चा माल्‍ब। मिनु आ आंम कली नु आ खिं ङा मुर आन पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोमी आ पाप आ पर्बम चढ़ेतीक ब्‍यफ क्‍योरचा माल्‍ब। रोमी ३:२५ ");
INSERT INTO suzBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","मिनु मेकोमी परमप्रभु यावे आ ङोंइती चढ़ेतीके रे ब्रशो कोइला धूप चोतीकेम कुर पा मुठी निक्‍शी चुशो ब्रोव़शो रिना पाइश्‍शो धूप कुरशा फारतीक वा चोव़खो कोठा ओव़चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","मिनु मेकोमी परमप्रभु यावे आ ङोंइती बाक्‍शा, धूप चोचा माल्‍ब। मिनु धूप आ कुनम कबल पशो सन्‍दोस आ तार बाक्‍शो शिशी बाक्‍तीक कली सुम्‍चा माल्‍ब। मोदेंशो मपाप्‍तु हना, मेको बेक्‍ब। प्रस्‍थान २५:१७-२२ ");
INSERT INTO suzBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","मेको नोले मेकोम ब्‍यफ आ हुश इच्‍का ब्रेक्‍शा पिश्‍शा, परमप्रभु यावे आ बाक्‍तीक तारी पूर्ब गे ब्रुइक्‍चा माल्‍ब। मेकेर मेकोमी आ ब्रेप्‍चोमी मेको हुश कली ७ खेयप ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","मिनु मेकोमी मुर आन पाप आ पर्बम चढ़ेतीक बोका क्‍योरचा माल्‍ब। मिनु मेको आ हुश फारशो वा आ आगा ङा कोठा चाक्‍शा, ब्‍यफ आ हुश खोदेंशो पा, शिशी बाक्‍तीक तार नु आ ङोंइती ब्रुइक्‍चा माल्‍ब। हिब्रू ४:१६; हिब्रू ९:५ ");
INSERT INTO suzBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","मोपा मेकोमी मेको कोठा चोव़खो दुम्‍ब। मिनु इस्राएल ङा मुर आन ग्रांग्रा दिशो नु मरिम्‍शो पशो नु मेको आन पाप आन पर्बम पाप क्‍याम्‍तीक गेय बाक्‍ब। मिनु मेकोमी ग्रुम्‍तीक ताम्‍बु कली यो पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","मिनु हारूनमी चोव़खो कोठामी पाप क्‍याम्‍तीक गेय पवानु, सुइ मुर ग्रुम्‍तीक ताम्‍बु ओव़चा मदुम्‍ब। मेकोमी आंम आ पर्बम, आ खिं ङा मुर आन पर्बम नु इस्राएल ङा मुर नेल्‍ल आन पर्बम पाप क्‍याम्‍तीक गेय मथुमा सम्‍म, सुइमी ग्रुम्‍तीक ताम्‍बु ओव़चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","मिनु नोले मेको लाङगा ग्रूशा, परमप्रभु यावे आ ङोंइती बाक्‍शो चढ़ेतीकेम लशा, मेको आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोमी ब्‍यफ आ हुश नु बोका आ हुश इच्‍का लाइश्‍शा, चढ़ेतीक आ एर ओंथ ङा ग्रोव़ नेल्‍लेम ख्रेक्‍चा माल्‍ब। प्रस्‍थान ३०:१० ");
INSERT INTO suzBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","मिनु इच्‍का हुश लाइश्‍शा, आ ब्रेप्‍चोम ७ खेयप मेको चढ़ेतीक तार ब्रुइक्‍चा माल्‍ब। मोपा मेको चढ़ेतीके इस्राएली आन ग्रांग्रा दिशो रे चोव़खो सेल्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","मिनु हारूनमी चोव़खो कोठा, ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीके आ पर्बम पाप क्‍याम्‍तीक गेय पवा नोले, मेको सेस बोका चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","मिनु नोले हारूनम आ गुइ निम्‍फा मेको सेस बोका आ पिया तार वोइक्‍चा माल्‍ब। मिनु इस्राएली आन मरिम्‍शो पशो नेल्‍ल नु आन पशो पाप नेल्‍ल शोव़शा, मोपा नेल्‍ल पाप बोका आ पियाम वोइक्‍चा माल्‍ब। मिनु नोले मुर काम मेको बोका कली गोरशो रागीम चोक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","मोपा मेको बोकाम मेको आन मरिम्‍शो पशो कुरशा, सुइ मबाक्‍शो गोरशो रागीम लाइक्‍चा माल्‍ब। मेको मुरुम मेको बोका कली गोरशो रागीम प्रोंइचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","मेको नोले हारून ग्रुम्‍तीक ताम्‍बुम ओव़शा, मेको आ ङोंइती चोव़खो कोठा ओव़शा, फेक्‍शो सुती वा प्रुइश्‍शा, मेक उइ वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","मिनु मेकोमी चोव़खो बाक्‍तीके लशा, चिक्‍सीचा माल्‍ब। मिनु आ वा फेक्‍शा लेत्‍चा माल्‍ब। मिनु आंम आ पर्बम नु मुर आन पर्बम चोशा चढ़ेतीक चढ़ेशा, आंम कली नु मुर आन कली पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","मिनु मेकोमी पाप आ पर्बम चढ़ेशो आ बोंसो चढ़ेतीकेमी चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","मिनु प्रोंइचा पुंइसीब बोका कली चोव़‍थ लाइब मुर आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नोले मुर आन बाक्‍तीक जाक्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","मिनु पाप आ पर्बम चढ़ेशो ब्‍यफ नु बोका आस हुशेमी मेको चोव़खो कोठा कली पाप क्‍याम्‍तीक गेय पशा नोले मेको मुर आन बाक्‍तीक रे ग्रुंइशा, मेको आस कुशुल, श्‍ये नु गोबर नेल्‍ल चोचा माल्‍ब। लेवी ४:१२; लेवी ६:२३; हिब्रू १३:११ ");
INSERT INTO suzBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","मिनु मेको चोइबमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मिनु मेको नोले मुर आन बाक्‍तीके लेन्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","एको नेल्‍ले इन कली गेना हना यो पतीके बाक्‍ब। ७ महिना ङा १० नाक्‍ती परमप्रभु यावे आ नेक्‍था जाक्‍चा माल्‍नीनी। मेको नाक्‍ती गे, इस्राएली नु अर्को रागी ङा मुर नेल्‍लेमी काइ गेय मपने। लेवी २३:२७-३२; गन्‍ती २९:७ ");
INSERT INTO suzBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","मारदे हना मेको नाक्‍ती इन पर्बम पाप क्‍याम्‍तीक गेय पाइनीम। मिनु परमप्रभु यावे आ ङोंइती इन पाप क्‍याम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","एको इन ठेयब नाइक्‍तीक नाक्‍ती बाक्‍ब। मोपतीके काइ गेय मपने। एको गेना हना यो कली पतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","तेल लुक्‍शो नु आ आफ आ पा ङा चढ़ेब दुम्‍चा कली सु योव़सीशो बाक्‍मे, मेकोमी पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोमी मेको गेय कली ला वोइश्‍शो सुती के फेक्‍तीके फेक्‍चा माल्‍ब। प्रस्‍थान २८:४१-४२ ");
INSERT INTO suzBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","मेकोमी चोव़खो कोठा कली, ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक कली पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोमी चढ़ेबपुकी नु मुर नेल्‍ल आन पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","मिनु बर्सम खेयप का इस्राएली नेल्‍ल आन कली पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मेको इन कली गेना हना यो पतीक बाक्‍त। बर्सम खेयप का इस्राएली नेल्‍ल आन पाप आ पर्बम माफ पुंइचा माल्‍ब’ दे हारून कली देनो” देंत। मिनु परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा पाप्‍तु। प्रस्‍थान ३०:१०; हिब्रू १०:३ ");
INSERT INTO suzBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“गे हारून, मेको आ तौपुकी नु इस्राएली नेल्‍ल आन कली ‘परमप्रभु यावेमी अरेशो मार बाक्‍ब देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","सुमी इस्राएली आन बाक्‍तीकेमी ब्‍यफ, भेडा नु क्‍यारश क्‍योरबा, ");
INSERT INTO suzBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","मिनु परमप्रभु यावे आ ङोंइती चढ़ेचा कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम मचाक्‍बा, मेको मुर साइश्‍शो आ पर्बम दोस ताइब। मेकोमी साइक्‍तीके आ मुर रे तिल्‍चा पुंइसीब। उत्‍पत्ती ९:६ ");
INSERT INTO suzBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","मोपतीके इस्राएलीपुकीमी आन क्‍योरशा चढ़ेतीके आन बाक्‍तीके रे ग्रुंइशा, परमप्रभु यावे आ ङोंइती चाक्‍चा माल्‍नीम। मेकोपुकीमी आन क्‍योरतीक बस्‍तु भाव चढ़ेब आ बाक्‍तीकेम, ग्रुम्‍तीक ताम्‍बु आ ओव़तीके आ ङोंइती चाक्‍शा, दुशा बाक्‍तीक आ पर्बम चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","मिनु चढ़ेबमी मेको आ हुश ग्रुम्‍तीक ताम्‍बु आ ओव़तीके आ ङोंइती बाक्‍शो परमप्रभु यावे कली चढ़ेतीकेम ब्रुइक्‍चा माल्‍ब। मिनु बोंसो परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पपाइश्‍शो सेल्‍चा कली चोचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","मेकोपुकीमी मोपा वोल कली चढ़ेशा, आंम कली तेल्‍लेम खोदेंशो सेल्‍ने मचाप्‍नीम। एकोम परमप्रभु यावे आ अरेशो लोव़ नेल्‍ल आन पाला सम्‍म गेना हना यो कली अरेतीके बाक्‍ब’ दे‍‍नो” देंत। ब्‍यवस्‍था १७:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","मिनु परमप्रभुमी “मेको आन कली ‘इस्राएली नु मेको नु बाक्‍ब अर्को रागी ङा मुर चोशा चढ़ेतीके चढ़ेचा दाक्‍ताक्‍म हना, ब्‍यवस्‍था १२:१४ ");
INSERT INTO suzBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","मिनु मेको ग्रुम्‍तीक ताम्‍बु आ ओव़तीके मचाक्‍थु, परमप्रभु यावे कली मचढ़ेप्‍तु हना, मेको मुर कली आ मुर आन दाते रे तिल्‍चा माल्‍नीम’ दे माइक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","इस्राएली नु मेको आन दातेम बाक्‍ब अर्को रागी ङा मुर सुइमी हुश ब्‍वाम्‍तेक्‍म हना, गो मेको हुश ब्‍वाइब कली मरिम्‍शो पाइनुङ। मिनु मेको मुर कली आ मुर आन दाते रे क्‍याम्‍नुङ। लेवी ३:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","मारदे हना मेको बस्‍तु भाव आन हुशेम ब्रोंइतीक सोक्‍त बाक्‍ब। मिनु गो मेको हुश इन कली चढ़ेतीकेमी इन पाप क्‍याम्‍तीक गेय पचा कली गेता। मारदे हना हुशेम पाप क्‍याम्‍तीके बाक्‍ब। हिब्रू ९:२२ ");
INSERT INTO suzBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","मोपतीके गेपुकी नु गेपुकी नु बाक्‍ब अर्को रागी ङा मुर सुइमी हुश ब्‍वचा मदुम्‍ब, दे गो इस्राएली आन कली देंशो बाक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","मिनु सुइ इस्राएलीपुकी नु गेपुकी नु बाक्‍ब अर्को रागी ङा मुर सिखार ग्‍यारशा, ग्‍याइश्‍शा मारेइ साइक्‍तीनी हना, मेको आ हुश नेल्‍ल जारशा, खपीम सुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","मारदे हना मारेइ मारेइ के ब्रोंइतीक सोक्‍त हुशेमी बाक्‍ब। मोपतीके गो इस्राएली नेल्‍ल आन कली ‘गे तेकोइ जन्‍तु, बस्‍तु भाव आन हुश ब्‍वचा मदुम्‍ब। मारदे हना नेल्‍ल जन्‍तु आन ब्रोंइतीके हुशेम बाक्‍ब। मेको सुमी ब्‍वाइबा, मेको क्‍याम्‍चा पुंइसीब। उत्‍पत्ती ९:४ ");
INSERT INTO suzBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","मिनु इस्राएली नु अर्को रागी ङा मुर नेल्‍लेमी, सुम आंमा बेक्‍शो मारेइ मारेइ नु ब्‍वाकी ङा जन्‍तुम साइश्‍शो मार मार ब्‍वाम्‍तेक्‍म हना, मेको आन वा मुरशा, चिक्‍सीचा माल्‍नीम। मिनु नां मरिक्‍म सम्‍म ग्रांग्रा बाक्‍चा माल्‍नीम। मिनु नोले मेको ग्रांग्रा मदिशो दुम्‍नीम। लेवी ११:४०; लेवी २२:८; प्रस्‍थान २१:३३-३६; प्रस्‍थान २२:३०; प्रेरित १५:२० ");
INSERT INTO suzBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","तन्‍न मेकोपुकीमी आन वा ममुरथु, मचिक्‍साक्‍म हना, मेको आन पशो आ पर्बम मेको दोस ताइब दुम्‍नीम’ दे हारून नु आ तौ आन कली देनो” दे परमप्रभु यावेमी देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“गे इस्राएली आन कली ‘गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","गेपुकी इजीप्‍त रागीम पशो खोदेंशो मपने। मिनु गो इन कली कनान रागी लाइक्‍नन्‍नी। गेपुकीमी मेक ङा मुर आन पशो खोदेंशो मपने। प्रस्‍थान २३:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","गेपुकीमी आं पावो, दे अरेशो लोव़ नु आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ पचा माल्‍नीनी। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","सुमी आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आं पावो, दे अरेशो लोव़ पाइबा, मेको ब्रोंइचा ताइब। मारदे हना गो परमप्रभु यावे नङ। नेहेम्‍याह ९:२९; इजीकीएल २०:११; रोमी ७:१०; रोमी १०:५; गलाती ३:१२ ");
INSERT INTO suzBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","गेपुकी सुइ आंम नेक्‍था ङा नाता नु मइपीन। मारदे हना गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","इन ममा नु इप्‍शा इन आफ कली मुने मतोक्‍कीन। इन ममा नु इप्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","गे इ आफ आ अरु मीश नु मइपो। मो पाइ‍तीनी हना, गेपुकीमी इन आफ कली मुने तोक्‍नीनी। उत्‍पत्ती ३५:२२; ब्‍यवस्‍था २७:२०; २सामुएल १६:२२; १कोरिन्‍थी ५:१ ");
INSERT INTO suzBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","गे इ दिदी, बहिनी नु मइपो। इ आफ आ तमी बाक्‍त हना यो, इ ममा आ तमी बाक्‍त हना यो नु आंम खिंम जरमेशो बाक्‍त हना यो अर्को रागीम जरमेशो बाक्‍त हना यो, मेको नु इप्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","मिनु तौ आ तमी बाक्‍त हना यो, इ तमी आ तमी बाक्‍त हना यो, इ चच बाक्‍त हना यो मेको नु मइपो। मो पाप्‍तीवी हना, गे आंमा मुने दोक्नेवे। ");
INSERT INTO suzBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","गे इ आफ आ अरु मीश आ तमी नु मइपो। मेको इन समी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","गे इन फुपु नु मइपो। मेको इन आफ आ समी बाक्‍ब। प्रस्‍थान ६:२० ");
INSERT INTO suzBl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","गे इ ममा आ लोक्‍ब नु मइपो। मेको इन ममा आ नाता बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","इन बोडमा नु आमा कान्‍छी नु मइपो। मेको इन बोडमा नु आमा कान्‍छी बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","गे इ चाइमी नु मइपो। मेको इ तौ आ मीश बाक्‍ब। गे मेको नु इप्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","गे इ भोग्‍यु, बोहारी नु मइपो। मोपा इ लोक्‍ब कली मुने मतोक्‍को। लेवी २०:२१; मर्कूस ६:१८ ");
INSERT INTO suzBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","गे मीश मुर का नु आ तमी निम्‍फा नु मइपो। मिनु मेको आ तौ आ तमी नु आ तमी आ तमी, चच नु मइपो। मेकोपुकी नेक्‍था ङा नाता बाक्‍नीम। मो पचा मरिम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","गे इ मीश बाक्‍ना बाक्‍न, मेको आ लोक्‍ब मचाक्‍को। मेको नु मइपो। ");
INSERT INTO suzBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","गे रां ब्रोल्‍शा ग्रांग्रा दिशो दुम्‍शो मीश मुर नु मइपो। ");
INSERT INTO suzBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","गे अर्को मुर आ मीश नु इप्‍शा आंम कली ग्रांग्रा मसेलो। २सामुएल ११:४ ");
INSERT INTO suzBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","गे मोलेक कली आंम तमी तौपुकी चढ़ेशा, आंम परमप्रभु यावे, इन परमप्रभु आ नें ग्रांग्रा मसेलीन। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","मीश मुर नु इप्‍शो खोदेंशो पा वोंइश मुर नु मइपो। मेको थम ग्रांग्रा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","गे बस्‍तु भाव नु इप्‍शा, आंम कली ग्रांग्रा मसेलो। मीश मुर यो बस्‍तु भाव नु इप्‍चा मदुम्‍ब। मेको थम मरिम्‍शो दूली गेय बाक्‍ब। प्रस्‍थान २२:१८; लेवी २०:१६ ");
INSERT INTO suzBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","गेपुकीमी मोदेंशो पाप पा आंम कली ग्रांग्रा मसेलीन। मारदे हना गो मोदेंशो पाप आ पर्बम जात जात ङा मुर इन ङोंइती रे ग्रुंइनुङमी। मेको नेल्‍लेम मोदेंशो पाप पा ग्रांग्रा दिशो दुम्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","मोपान मेको रागी ग्रांग्रा दिशो दुम्‍त। मिनु गो मेको आन पाप आ पर्बम सजाइ गेता। मिनु रागीम मेक ङा मुर आन कली उक्‍बे पा ताइक्‍ताक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","तन्‍न गे आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आं पावो, दे अरेशो लोव़ टिने। मिनु गे इस्राएली नु इन दातेमी बाक्‍ब अर्को रागी ङा मुर मोदेंशो ग्रांग्रा दिशो गेय मपने। ");
INSERT INTO suzBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","मारदे हना इन ङोंइती मेकेर बाक्‍ब मुरपुकीमी मोदेंशो ग्रांग्रा नेल्‍ल पाम्‍तेक्‍म। मिनु रागी ग्रांग्रा दिशो दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","मिनु आं अरेशो मपथु, मेको रागी ग्रांग्रा दिशो सेल्‍तीनी हना, मेको ङोंइती बाक्‍ब मुर आन कली खोदेंशो पा मेको रागीमी इन कली यो उक्‍बे पा ताइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","सुइमी मेको मरिम्‍शो का ला पाप्‍तु हना, मेको मुर आ मुर रे तिल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","मोपतीके गे ङोंइती ङा मुरपुकीमी पशो खोदेंशो पा मेको दूली ग्रांग्रा दिशो पाप मपने। मिनु आंम कली ग्रांग्रा दिशो मसेलीन। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएली आन ग्रुम्‍तीक ङा मुर नेल्‍ल आन कली ‘गेपुकी आं कली ला ठेयब सेलीन। मारदे हना गो परमप्रभु यावे, इन परमप्रभु का ला नङ। लेवी ११:४४-४५; मत्ती ५:४८; १ पत्रुस १:१५-१६ ");
INSERT INTO suzBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","गे नेल्‍लेमी इन आंम आफ आस कली मान पने। मिनु आं नाइक्‍तीक नाक्‍ती नांइसीन। गो परमप्रभु यावे, इन परमप्रभु नङ। प्रस्‍थान २०:१२; प्रस्‍थान २०:८ ");
INSERT INTO suzBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","गे मूर्ति कली पूजा मपने। मिनु गे आंम कली मूर्ति मसेलीन। गो परमप्रभु यावे, इन परमप्रभु नङ। प्रस्‍थान २०:३; प्रस्‍थान ३४:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","गे दुशा बाक्‍चा आ पर्बम परमप्रभु यावे आ ङोंइती चढ़ेनीनु, परमप्रभु यावेमी ब्रचा ङा पा चढ़ेने। लेवी ७:१२-१८; ");
INSERT INTO suzBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","गे चढ़ेनीनु, मेको चढ़ेशो नाक्‍त नु आ दीसा सम्‍म नेल्‍ल ब्‍वशा नेंचा माल्‍नीनी आ नित्‍थ नाक्‍त सम्‍म मारेइ लीत हना, मेको चोचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","आ नित्‍थ नाक्‍त मेको ब्‍वाइताक्‍नी हना, थम ग्रांग्रा दुम्‍ब। मिनु मेको चढ़ेशो मब्राइब। ");
INSERT INTO suzBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","मेको ब्‍वाइब नेल्‍लेमी सजाइ ताइनीम। मारदे हना मेकोमी परमप्रभु यावे कली चढ़ेशो ग्रांग्रा दिशो सेल्‍शा, मेको कली मटीम। मिनु मोदेंशो मुर आन मुर रे तिल्‍चा पुंइसीनीम। ");
INSERT INTO suzBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","मिनु गे इन बाली नाली रिक्‍नीनु, रू आ सुर सुर सम्‍म मरिक्‍कीन। सिला बाला मगुपीन। लेवी २३:२२; ब्‍यवस्‍था २४:१९; रूथ २:२,१५,१६ ");
INSERT INTO suzBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","गेपुकीमी इन अङगुर रू ङा फल काइ मलीपाइक्‍थु, मसेक्‍कीन। मिनु रूम दोक्‍शो अङगुर यो मगुपीन। मेको प्रुङग नु अर्को रागी ङा मुर आन कली बाक्‍ल। गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","गे खुइ मपने। मठगेने। गे जोल मपमुने। प्रस्‍थान २०:१५-१६; १ थिस्‍सलोनिकी ४:६ ");
INSERT INTO suzBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","गेपुकीमी आं नें थिशा, जोल पा कसम मजने। मो पाइतीनी हना, गे इन परमप्रभु आ नें आइक्‍च सेल्‍नीनी। गो परमप्रभु यावे नङ। प्रस्‍थान २०:७; मत्ती ५:३३ ");
INSERT INTO suzBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","गे आंम नेक्‍था ङा मुर आन कली श्‍येत गेशा, मदिपीन। मिनु मेको आन मार मार मरोइक्‍तीन। गाल्‍च ताक्‍शा गेय पाइब आन क्‍येट काब नाक्‍दो यो इन खिंम वोइक्‍चा मदुम्‍ब। ब्‍यवस्‍था २४:१४-१५; येरमीया २२:१३; याकूब ५:४ ");
INSERT INTO suzBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","नोफा मनेंब मुर कली मरिम्‍शो लोव़ मपने। मिक्‍च मताइब आ ङोंइती दाइल पाइक्‍तीक थोव़क मवोतीन। इन परमप्रभु क्‍येङा हिनीन। गो परमप्रभु यावे नङ। उत्‍पत्ती २७:१९; ब्‍यवस्‍था २७:१८ ");
INSERT INTO suzBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","गे जोल पाइब सांकछी मदुमीन। ठेयब मुर बाक्‍त हना यो, आइक्‍च मुर बाक्‍त हना यो, मुर आन कुल मकोव़थु, ठीक निसाफ पने। प्रस्‍थान २३:३,६; ब्‍यवस्‍था १६:१९,२० ");
INSERT INTO suzBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","गेपुकी मुर आन पर्बम जोल पा लोव़ मपमुने। गे इन नेक्‍था ङा मुर कली साइक्‍चा ममालीन। गो परमप्रभु यावे नङ। प्रस्‍थान २३:७ ");
INSERT INTO suzBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","गे इन लोक्‍ब कली काइ मदाक्‍ब मदुमीन। इन नेक्‍था ङा मुर कली रिम्‍शो पा मोदेंशो दूली गेय मपने’ दे लोव़ पने। मो मपाइतीनी हना, गे पाप राइनीनी। भजन संग्रह १४१:५; मत्ती १८:१५ ");
INSERT INTO suzBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","गे इन मुर आन कली क्‍येक्‍क मलेत्‍तीन। ईख मकुरीन। तन्‍न इन नेक्‍था ङा मुर कली आंम कली खोदेंशो पा दाक्‍तीन। गो परमप्रभु यावे नङ। २राजा ६:२२; २इतिहास २९:९-१५; मत्ती ५:४३-४८; मत्ती २२:३९; लूका १०:२५-३७; यूहन्‍ना १३:३४; रोमी १३:९; गलाती ५:१४; याकूब २:८ ");
INSERT INTO suzBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","गे आं फुल्‍लु मुशा ब्रेक्‍शो लोव़ पने। निक्‍शी खाल ङा जन्‍तु, बस्‍तु भाव आन कली मब्‍वाइक्‍तीन। इन रूमी निक्‍शी खाल ङा वांचेर मशोक्‍कीन। गेपुकीमी निक्‍शी खाल ङा श्‍येले ब्‍वाइश्‍शा प्रोव़शो वा मफेक्‍सीन। ब्‍यवस्‍था २२:९-११ ");
INSERT INTO suzBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","मिनु वोंइश मुर कामी वाइलीम दुम्‍शो मीश आल नु इप्‍त हना, मेको मीश आल चहिं अरु वोंइश मुर कली गेचा चिक्‍शो बाक्‍त हना, तन्‍न मग्‍याप्‍थु, मप्रोंइथु बाक्‍त हना, मेको वोंइश मुर कली खोदील निदील पचा माल्‍नीम। मेको आस कली साइक्‍चा मदुम्‍ब। मारदे हना मेको मीश आल मप्रोंइशो बाक्‍त। प्रस्‍थान २१:७-११ ");
INSERT INTO suzBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","तन्‍न मेको वोंइश मुरुमी परमप्रभु यावे आ ङोंइती ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम आ दोस आ पर्बम सांड का चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","मिनु चढ़ेबमी मेको आ दोस आ पर्बम सांड चढ़ेशा परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मोपा मेको आ पाप क्‍याम्‍सीशा माफ ताइब दुम्‍ब। लेवी ५:१७-१८ ");
INSERT INTO suzBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","मिनु गेपुकी मेको रागी जाक्‍दीश्‍शा, तेकोइ जचा दुम्‍ब फल फुल रवा ख्रुम्‍नीनु, बर्स सां सम्‍म मेको आन फल मजने। ");
INSERT INTO suzBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","मिनु ४ बर्सम चहिं फल फुल नेल्‍ले परमप्रभु यावे कली ग्‍येरशो गेचा माल्‍नीनी। परमप्रभु यावे कली ठेयब मान पचा कली बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तन्‍न ५ बर्सम गेपुकीम मेको फल फुल जने चाप्‍नीनी। मिनु मेको रवा इन कली शुश सिप्‍ब दुम्‍नीम। गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","गेपुकीमी तेकोइ चिक्‍ब, जन्‍तु, बी बयफ, क्‍यारश भडा आन श्‍ये हुश सुन्‍दा मब्‍वने। मिनु गेपुकी लिंक्‍यु मकोव़ङीन। मिनु गे टुना मुना काइ मपने। लेवी ३:१७; ब्‍यवस्‍था १८:१० ");
INSERT INTO suzBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","गेपुकीमी इन चां एर ओंथ मख्रोतीन। मिनु इन गाल शोक्रे आ सुर मख्रोतीन। लेवी २१:५; ब्‍यवस्‍था १४:१ ");
INSERT INTO suzBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","गेपुकी बेक्‍शो मुर आन पर्बम आंम रां क्‍योरशा गार मसेलीन। मिनु इन रांमी चिनु मखोपेन। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","गेपुकीमी इन तमी आन कली तेल्‍लेम सेल्‍शा, ग्रांग्रा दिशो मसेलीन। मो पाइतीनी हना, रागी तेल्‍लेम बाक्‍तीक खोदेंशो दुम्‍शा, ग्रांग्रा दिशोमी ब्रीब। ब्‍यवस्‍था २३:१८; २राजा २३:७ ");
INSERT INTO suzBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","गे आं नाइक्‍तीक नाक्‍तीम नांइसीन। मिनु आं बाक्‍तीक ताम्‍बु कली मान पने। गो परमप्रभु यावे नङ। लेवी २६:२ ");
INSERT INTO suzBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","गेपुकी बेक्‍शो मुर रे लोव़ पाइब नु लिंक्‍यु कोव़ब कली ‘वारच पाइक्‍की’ दे आन बाक्‍तीके मलने। मेकोपुकी नु सल्‍ला पा, गे आंम कली ग्रांग्रा दिशो मसेल्‍सीन। गो परमप्रभु यावे, इन परमप्रभु नङ। लेवी २०:६; ब्‍यवस्‍था १८:१०-११; १सामुएल २८:७ ");
INSERT INTO suzBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","गे खूशो आ ङोंइती बोक्‍कीन। खाल्‍पी खाल्‍पा आन कली मान पने। मिनु इन परमप्रभु कली मान पा हिनीन। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","गेपुकी नु बाक्‍ब अर्को रागी ङा मुर आन कली मदिपीन। प्रस्‍थान २२:२० ");
INSERT INTO suzBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","गे मेको आन कली इन रागीम जरमेशो मुर खोदेंशो मिम्‍तीन। मेको आन कली आंम कली खोदेंशो पा दाक्‍तीन। मारदे हना गेपुकी यो इजीप्‍तमी अर्को रागी ङा मुर दुम्‍शा बाक्‍शो बाक्‍तीनी। गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","गेपुकीमी पुक्‍नीनु, नाक्‍तीनीनु नु थाप्‍तीनीनु जोल मपने। ");
INSERT INTO suzBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","इन नाक्‍तीकेम तुला ठीक दुम्‍चा माल्‍ब। इन ढक ठीक दुम्‍चा माल्‍नीमी। मिनु इन पुक्‍तीके ठीक दुम्‍चा माल्‍नीमी। गो इन कली इजीप्‍त रे ग्रुंइब परमप्रभु यावे, इन परमप्रभु नङ। ब्‍यवस्‍था २५:१३-१६; हितोपदेस ११:१ ");
INSERT INTO suzBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","गे आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आं पावो, दे अरेशो लोव़ नेल्‍ल थुंम वोइश्‍शा, पचा माल्‍नीनी। मारदे हना गो परमप्रभु यावे नङ” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“गे लेंशा इस्राएली आन कली ‘इस्राएलीपुकी, मेको नु बाक्‍ब अर्को रागी ङा मुरपुकी सुम आन आल मोलेक कली चढ़ेनीमी, मेको आन कली साइक्‍चा माल्‍नीम। ग्रुम्‍तीक ङा मुरपुकीम मेको कली फुल्‍लु आप्‍शा साइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मेकोपुकीमी आन आल मोलेक कली चढ़ेमेनु, आं बाक्‍तीक ताम्‍बु नु आं ठेयब नें ग्रांग्रा दिशो सेल्‍तेक्‍म। मोपतीके गो आंमा मेको आन कली ब्रोंइचा मगेथु, आ मुर आन दाते रे क्‍याम्‍नुङमी। ");
INSERT INTO suzBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","मिनु मेको रागी ङा मुरपुकीम आ आल मोलेक कली चढ़ेब मुर कली तुइश्‍शा यो मसाइक्‍तेक्‍म हना, ");
INSERT INTO suzBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","गो आंमा मेको नु आ खिं ङा मुर आन कली ब्रोंइचा मगेथु, मेको आन मुर आन दाते रे क्‍याम्‍नुङमी। मेको नु मेको आन नोले खोइक्‍ब मोलेक कली चढ़ेब नेल्‍ल आन कली क्‍याम्‍नुङमी। ");
INSERT INTO suzBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","सु मुर बेक्‍शो मुर रे लोव़ पाइब नु लिंक्‍यु कोव़ब आन कली “वारच पयी” दे आन बाक्‍तीके लाइबा, गो मेको कली ब्रोंइचा मगेथु, आ मुर आन दाते रे क्‍याम्‍नुङ। लेवी १९:३१ ");
INSERT INTO suzBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","मोपतीके आं कली जिम्‍मा गेंसीशा आं के दुमीन। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ। लेवी १९:२ ");
INSERT INTO suzBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ इन थुंम वोइश्‍शा टिने। गो परमप्रभु यावे नङ। गो इन कली आं खोदेंशो सेल्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","सुमी आ आंम आफ आस कली सराप पाइक्‍बा, मेको मुर कली साइक्‍चा माल्‍ब। आ आंम आफ आस कली सराप पाइक्‍तीके साइक्‍चा पुंइसीब। प्रस्‍थान २१:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","सुइ मुर अरु आन मीश नु इप्‍त हना, मेको पाइब निम्‍फा आस कली साइक्‍चा माल्‍ब। प्रस्‍थान २०:१४; २सामुएल ११:४; यूहन्‍ना ८:५ ");
INSERT INTO suzBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","सु आ आफ आ मीश नु इप्‍बा, मेकोम आ आफ कली मुने तोक्‍ब। मेको निम्‍फा आस कली साइक्‍चा माल्‍ब। मेको साइक्‍चा पुंइसीनीस। लेवी १८:६-२३ ");
INSERT INTO suzBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","सु आ चाइमी नु इप्‍बा, मेको निम्‍फा आस कली साइक्‍चा माल्‍ब। मेको दूली पा मेको थम मरिम्‍शो बाक्‍ब। मेको साइक्‍चा पुंइसीनीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","सुइ मुर मीश मुर नु इप्‍शो खोदेंशो पा वोंइश मुर नु इप्‍त हना, मेको थम ग्रांग्रा दितीक बाक्‍ब। मेको आस कली साइक्‍चा माल्‍ब। मेको थमा पा साइक्‍चा पुंइसीनीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","सु मुर ममा नु आ तमी निम्‍फा नु इप्‍बा, मेको काइ मरिम्‍शो बाक्‍ब। मेको सां आन कली चोचा माल्‍ब। इन दातेमी मोदेंशो मरिम्‍शो मदुम्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","सुइ वोंइश मुर बस्‍तु भाव नु इप्‍त हना, मेको कली साइक्‍चा माल्‍ब। मिनु मेको बस्‍तु कली यो साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","सुइ मीश मुर बस्‍तु भाव नु इप्‍‍त हना, मेको मीश मुर नु बस्‍तु निम्‍फा आस कली साइक्‍चा माल्‍ब। मेको साइक्‍चा पुंइसीनीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","सु मुर आ दिदी बहिनी, आ आंम आ तमी कि आ आफ आ तमी नु इप्‍त हना, मेको थम मुने बाक्‍ब। मेको निम्‍फा आस कली आस मुर आन दाते रे नेल्‍लेम तचा ङा पा साइश्‍शा क्‍याम्‍चा माल्‍ब। मेकोमी आंम आ समी नु इप्‍तीके सजाइ गेचा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","सुइ मुर रां ब्रोल्‍शो मीश मुर नु इप्‍त हना, मेको निम्‍फा आस कली आस मुर आन दाते रे साइश्‍शा क्‍याम्‍चा माल्‍ब। मारदे हना मेको वोंइश मुरुमी मीश मुर आ हुश यितीक ताप्‍तु। मिनु मीश मुरुमी चहिं आ हुश यितीके कोंइताक्‍व। लेवी १५:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","इन ममा आ लोक्‍ब नु इन आफ आ समी नु मइपीन। मारदे हना मो पाइतीनी हना, आंम खिं ङा मुर कली मुने तोक्‍नीनी। मेको सजाइ ताइनीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","सुइ मुरुमी आ बोडो, बकान्‍छा कि मामा आ मीश नु इप्‍त हना, मेकोमी आ बोडो, बकान्‍छा कि मामा कली मुने तोक्‍ब। मेको सजाइ जचा पुंइसीनीस। मिनु आल मथिथु बेक्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","सुमी मुरुमी आ भोग्‍यु कि बोहारी चाक्‍बा, मेको ग्रांग्रा दिशो बाक्‍ब। मेकोमी आंम लोक्‍ब कली मुने तोक्‍ब। मिनु आल मथिथु बेक्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","गेपुकीमी आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु आं पाबो, दे अरेशो लोव़ नेल्‍ल तुइश्‍शा पचा माल्‍नीनी। मो मपाइतीनी हना, गो इन कली चाक्‍शो रागीमी इन कली उक्‍बे पा ताइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","गे इन ङोंइती खेरशो रागी रागी ङा मुर आन पशो मपने। मेकोपुकीमी मोदेंशो नेल्‍ल पाम्‍तेक्‍म। मोपतीके गो मेको आन कली तशा थम ग्रांग्रा दीती। ");
INSERT INTO suzBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","तन्‍न गो इन कली मेको आन रागी इन के दुम्‍ब। गो इन कली गेनुङ, देंती। मिनु मेको रागीम दूध नु खुदो शुश बाक्‍ब। गो परमप्रभु यावे, इन परमप्रभु नङ। मिनु गो इन कली रागी रागी ङा मुर रे तिल्‍शा योव़तन्‍नी। प्रस्‍थान १९:५-६ ");
INSERT INTO suzBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","मोपतीके गेपुकीमी ग्रांग्रा मदिशो नु ग्रांग्रा दिशो जन्‍तु नु ग्रांग्रा मदिशो नु ग्रांग्रा दिशो चिक्‍ब तुइश्‍शा तिल्‍चा माल्‍नीनी। गेपुकीमी ग्रांग्रा दिशो जन्‍तु, चिक्‍ब नु खपीम ग्रेशा गाक्‍ब जन्‍तु रे आंम कली ग्रांग्रा दिशो मसेल्‍सीन। मारदे हना मेको ग्रांग्रा दिशो बाक्‍नीम, दे शेंताक्‍ङ। लेवी ११:- ");
INSERT INTO suzBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","गेपुकी ग्रांग्रा दिशो क्‍येङा ङोन बाक्‍शो दुमीन। मारदे हना गो ग्रांग्रा दिशो क्‍येङा ङोन बाक्‍शो परमप्रभु यावे नङ। मिनु गो इन कली आं मुर दुम्‍चा कली अरु मुर रे तिल्‍शा योव़तन्‍नी। ");
INSERT INTO suzBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","सु इन दातेमी वोंइश मुर कि मीश मुर बेक्‍शो मुर रे लोव़ पाइबा कि लिंक्‍यु कोव़नीम, मेको आन कली साइक्‍चा माल्‍ब। मेको आन कली फुल्‍लु आप्‍शा साइक्‍चा माल्‍ब। मेको साइक्‍चा पुंइसीनीम’ दे इस्राएली आन कली शेंदो” दे परमप्रभु यावेमी मोसा कली देंत। प्रस्‍थान २२:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","मिनु परमप्रभु यावेमी मोसा कली “हारून आ तौ, चढ़ेब आन कली ‘इन मुर बेक्‍तेक्‍म हना, गेपुकी मेको बेक्‍शो मुर कली थिशा आंम कली ग्रांग्रा दिशो मसेलीन। इजीकीएल ४४:२५-२७ ");
INSERT INTO suzBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","तन्‍न इन आम आफ, तमी तौ नु लोक्‍ब, ");
INSERT INTO suzBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","कन्‍ने दिदी बहिनी आन पर्बम ला आंम इन कली ग्रांग्रा दिशो सेल्‍ने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","मिनु गेपुकीमी ग्‍युंबे पा नक नाता ङा मुर आन पर्बम आंम कली ग्रांग्रा दिशो सेल्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","गे चढ़ेबपुकीमी रोंका पा, इन चां प्रेक्‍चा, इन गाल शोक्रे आ सुर ख्रोइक्‍चा नु इन रां क्‍योरशा गार सेल्‍चा मदुम्‍नीनी। लेवी १९:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","इन परमप्रभु कली ला गेय पाइब दुमीन। इन परमप्रभु आ नें ग्रांग्रा दिशो सेल्‍ब मदुम्‍नीम। मारदे हना गेपुकीमी परमप्रभु यावे कली मीम चोशा चढ़ेतीके चढ़ेनीनी। मोपतीके गेपुकी परमप्रभु कली ला गेय पाइब बाक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","गे चढ़ेबपुकीमी तेल्‍लेम मीश मुर, ग्रांग्रा दिशो मीश मुर नु आ वोंइशेमी प्रोंइशो मीश मुर चाक्‍चा मदुम्‍ब। मारदे हना गेपुकी परमप्रभु आ मुर बाक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","मिनु गे इस्राएलीपुकीमी चढ़ेब आन कली परमप्रभु आ गेय पाइब मिम्‍तीन। मारदे हना मेकोपुकी इन परमप्रभु आ जचा चढ़ेनीम। मेकोपुकी इन पर्बम परमप्रभु आ गेय पाइब दुम्‍शो बाक्‍नीम, दे मिम्‍तीन। मारदे हना इन कली ग्रांग्रा रे ङोन बाक्‍ब सेल्‍ब, गो ग्रांग्रा रे ङोन बाक्‍ब परमप्रभु यावेमी इन कली आं खोदेंशो सेल्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","मिनु चढ़ेब आ तमीमी तेल्‍लेम पा आंम कली ग्रांग्रा दिशो सेल्‍तु हना, मेकोमी आ आफ कली ग्रांग्रा दिशो सेल्‍ब। मेको कली मीम चोशा साइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","मिनु सु आंम लोक्‍ब आन दातेम ठेयब चढ़ेब दुम्‍शो बाक्‍मे, मिनु आ पियाम तेल लुक्‍शो बाक्‍मे नु ठेयब चढ़ेब आ वा फेक्‍चा कली तिल्‍शो बाक्‍मे, मेकोमी रोंका पशा, आ पिया ङा चां प्रेक्‍चा मदुम्‍ब नु आ वा खाक्‍चा मदुम्‍ब। लेवी ८:१२; प्रस्‍थान २८:४१; प्रस्‍थान २९:७; लेवी १०:६; लेवी २१:२ ");
INSERT INTO suzBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","मेकोमी बेक्‍शो मुर बाक्‍तीके लशा, आंम कली ग्रांग्रा दिशो सेल्‍चा मदुम्‍ब। मेको आ आम आफ आ बेक्‍शो रां यो कोव़थ लचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","मेको परमप्रभु यावे आ बाक्‍तीके ताम्‍बु रे ग्रूचा मदुम्‍ब। मोदेंशो पाप्‍तु हना, मेकोमी आंम परमप्रभु आ बाक्‍तीके ग्रांग्रा दिशो सेल्‍ब। मारदे हना मेको परमप्रभु आ तेल लुक्‍शो मुर बाक्‍ब। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","मेकोमी कन्‍ने मीश आल कली ला ग्‍युंबे पने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","आ वोंइश बेक्‍शो मीश मुर, आ वोंइश प्रोंइशो मीश मुर, ग्रांग्रा दिशो कि तेल्‍लेम मीश मुर चाक्‍ने मचाप्‍ब। मिनु मेकोमी आ जात ङा कन्‍ने मीश आल ग्‍युंबे पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","मगारचा ङा मीश मुर नु ग्‍युंबे पा, आंम जात नु आंम तमी तौ आन कली ग्रांग्रा दिशो सेल्‍चा मदुम्‍ब। मारदे हना गो परमप्रभु यावे नङ। गो मेको कली आंम मुर सेल्‍ता’ दे शेंदो” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“गे हारून कली ‘इ तमी तौ, चच युइ आन दातेमी गुइ खोइल कुंजे नु दूली मुर आंम परमप्रभु कली चढ़ेब दुम्‍ने मचाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","मारदे हना सुइ दूली मुर, मिक्‍च मताइब, खोइल मदुक्‍ब, आ कुल कि रां बिग्रेशो कि खोइल का लाइश्‍शो मुर परमप्रभु आ ङोंइती जाक्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","गुइ जिक्‍शो, खोइल जिक्‍शो, ");
INSERT INTO suzBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुप्रे, बामन्‍ने, मिक्‍च रोइ पशो, रक सुतीक रोइ पशो, लुतो पशो कि आ गेडा ठीक मदुम्‍शो मुर आं परमप्रभु आ ङोंइती जाक्‍ने मचाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","चढ़ेब हारून आ तमी तौ चच युइ सु दूली दुम्‍शो बाक्‍मे, मेको परमप्रभु यावे कली चोशो चढ़ेतीक चढ़ेने मचाप्‍ब। मारदे हना मेको दूली बाक्‍ब। मेकोम आंम परमप्रभु कली जचा थोव़क चढ़ेचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","मेकोमी आंम परमप्रभु कली चढ़ेशो नु चोव़खो नु थम चोव़खो जचा थोव़क चहिं जने ब्‍वने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","तन्‍न मेको फारशो वा नु चढ़ेतीक आ नेक्‍था जाक्‍चा मदुम्‍ब। मारदे हना मेको दूली मुर जाक्‍शा, आं बाक्‍तीक ताम्‍बु ग्रांग्रा दिशो मसेलल। गो परमप्रभु यावे नङ। गो मेको आन कली मेको आं के सेल्‍नुङ’ दे शेंदो” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","मिनु मोसामी हारून, मेको आ तौपुकी नु इस्राएली नेल्‍ल आन कली एको लोव़ नेंपाइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“गे हारून नु आ तौ आन कली मार शेंचा माल्‍नेवे देंशा हना, ‘इस्राएलीपुकीमी आं कली चढ़ेशो थोव़क आन पर्बम होस पा बाक्‍कीन। मिनु आं नें कली ग्रांग्रा दिशो मसेलीन। गो परमप्रभु यावे नङ’ दे शेंचा माल्‍नेवे” दे परमप्रभु यावेम मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","मिनु मोसा कली “गो परमप्रभु यावे नङ। गे मेको आन कली ‘इन तौ, चच युइ आन पाला ङा तेकोइ मुर ग्रांग्रा दिशो दुम्‍शा, इस्राएलीपुकीमी परमप्रभु यावे कली चढ़ेशो थोव़क आन नेक्‍था जाक्‍तेक्‍म हना, मेको मुर आं ङोंइती रे तिल्‍चा पुंइसीब। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","मिनु हारून आ तौ, चच युइ आन दातेमी सुइ कुशुल ङा रोइ नु ग्रांग्रा यितीक पशो बाक्‍तेक्‍म हना, मेको ग्रांग्रा मदिशो सम्‍म आं कली चढ़ेशो मारेइ थोव़क जचा ब्‍वचा मदुम्‍ब। सुइमी बेक्‍शो मुर के कि बिउ यिशो मुर रे ग्रांग्रा दिशो दुम्‍शो मुर कली थीबा, लेवी १३:-१५:- ");
INSERT INTO suzBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","कि खपीम ग्रेशा गाक्‍ब जन्‍तु कली थिशो ग्रांग्रा दिशो दुम्‍शो मुर थीबा, कि मार मार आ पर्बम ग्रांग्रा दिशो बाक्‍त हना, ");
INSERT INTO suzBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","मेको मुर नां मरिक्‍म सम्‍म ग्रांग्रा दिशो बाक्‍ब। मेकोमी मचिक्‍से सम्‍म ला आं कली चढ़ेशो जचा ब्‍वचा मदुम्‍ब। लेवी ११:- ");
INSERT INTO suzBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","मोदेंशो मुर नां रिक्‍म नोले ला ग्रांग्रा मदिशो दुम्‍ब। मिनु नोले मेकोमी आं कली चढ़ेशो थोव़क जने ब्‍वने चाप्‍ब। मारदे हना मेको आं कली चढ़ेशो आ जचा ब्‍वचा थोव़क बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","मिनु बेक्‍शो, ब्‍वाकी ङा जन्‍तुपुकीम क्राइश्‍शा साइश्‍शो जन्‍तु, बस्‍तु भाव कली ब्‍वचा मदुम्‍ब। मोदेंशो पाप्‍तु हना, मेको मुर ग्रांग्रा दिशो सेल्‍सीब। गो परमप्रभु यावे नङ। लेवी ७:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","चढ़ेबपुकीमी आं देंशो टिचा माल्‍नीम। मो मपाम्‍तेक्‍म हना, मेकोपुकीमी आं देंशो मटितेक्‍म हना, मेकोपुकी दोस तशा आं बाक्‍तीक ताम्‍बुमी बेक्‍नीम। मिनु गो मेको आन कली आंम आं मुर सेल्‍ब परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","मिनु अर्को रागी ङा मुर नु चढ़ेब आ खिंम पौना बाक्‍शो कि गाल्‍च ताइब मुर आं कली चढ़ेशो थोव़क जचा ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","तन्‍न चढ़ेबमी क्‍येट थाप्‍शा ग्‍याप्‍शो मुर नु मेको आ खिंम जरमेशो मुर चढ़ेब आ भाग रे जचा ब्‍वचा दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","मिनु चढ़ेब आ तमी अर्को खिं ङा मुर नु ग्‍युंबे पशो बाक्‍त हना, परमप्रभु कली चढ़ेशो जचा ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","तन्‍न चढ़ेब आ तमी आ वोंइश बेक्‍शो कि प्रोंइचा पुंइसीशो बाक्‍त हना, आ तमी तौ मदुम्‍थु, आ आफ आ खिं लेत्‍त हना, आ आल ना ङा खोदेंशो पा आन आफ आ भाग ङा चढ़ेशो रे जने ब्‍वने चाप्‍ब। तन्‍न अर्को खिं ङा मुर मेको जचा ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","मिनु मरुम मतुइक्‍थु परमप्रभु कली चढ़ेशो रे जाप्‍तु हना, मेकोमी चढ़ेब कली मेको आ जशो क्‍येङा ५ भाग तेम्‍शा, परमप्रभु कली चढ़ेशो खोदेंशो पा चढ़ेब कली लेत्‍चा माल्‍ब। लेवी ५:१६ ");
INSERT INTO suzBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","मोपा सुइमी इस्राएली आन परमप्रभु यावे कली चढ़ेशो थोव़क ग्रांग्रा सेल्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","मोदेंशो परमप्रभु कली चढ़ेशो जशो मुर दोस ताइनीम। मिनु मेकोमी गारशा आ पर्बम चढ़ेतीक चाक्‍चा माल्‍ब। मारदे हना मेकोमी परमप्रभु यावे कली चढ़ेशो जाप्‍तु ब्‍वाप्‍तु। गो परमप्रभु यावे नङ। मिनु गो मेको कली आंम आं मुर सेल्ता’ दे शेंदो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“गे हारून, आ तौपुकी नु इस्राएली नेल्‍ल आन कली ‘इस्राएली आन दातेमी मुर का कि इस्राएलम बाक्‍ब अर्को रागी ङा मुरुमी ग्‍येरशा परमप्रभु यावे कली चढ़ेतीके चोशा चढ़ेशो खोदेंशो परमप्रभु यावे कली चढ़ेचा दाक्‍ताक्‍व हना, ");
INSERT INTO suzBl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","मिनु परमप्रभु आ ङोंइती ब्रचा ङा पा मेकोमी मारेइ मदुम्‍शो थम रिम्‍शो ब्‍यफ, सांड कि बोका चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","गार पाइश्‍शो बस्‍तु चढ़ेचा मदुम्‍ब। मारदे हना मेको मब्रचा ङा बाक्‍नीम। ब्‍यवस्‍था १५:२१; ब्‍यवस्‍था १७:१; मलाकी १:८ ");
INSERT INTO suzBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","मिनु मुर कामी दुशा बाक्‍चा आ पर्बम चढ़ेतीके परमप्रभु यावे कली चढ़ेशा, आ पशो कसम खबानु, ग्‍येरशा परमप्रभु यावे कली चढ़ेतीके, खोदेंशो पा, मेको ब्रचा ङा दुम्‍पाइक्‍चा कली आ हुल रे मारेइ मदुम्‍शो थम रिम्‍शो बस्‍तु चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","मिनु गेपुकीम परमप्रभु यावे कली मिक्‍च मताइब, गार दुम्‍शो, आन रां बिग्रेशो, ग्रांग्रा यितीके पाइब, कुशुल रोइ पाइब कि लुतो पाइब बस्‍तु भाव चढ़ेचा मदुम्‍ब। मोदेंशो मीम चोशा चढ़ेचा कली परमप्रभु यावे कली चढ़ेतीकेमी वोइक्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","मिनु गेपुकीमी लाइश्‍शा खोइल पाइश्‍शो ब्‍यफ कि भेडा चहिं ग्‍येरशा चढ़ेतीके चढ़ेतीनी हना दुम्‍ब। तन्‍न कसम जशोनु, इन चढ़ेतीके मब्राइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","तेको ब्‍यफ, क्‍यारश भेडा खसी पशो गार सेल्‍शो नु चेश्‍शो बाक्‍बा, मेको परमप्रभु यावे कली चढ़ेचा मदुम्‍ब। इन रागीम मो पचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","गेपुकीमी मोदेंशो बस्‍तु भाव अर्को रागी ङा मुर रे ग्‍याप्‍शा ताक्‍शा इन परमप्रभु कली जचा थोव़क चढ़ेचा मदुम्‍ब। मेको आन रां बिग्रेशो नु गारम पतीके इन पर्बम मब्रतीक दुम्‍ब’ दे शेंदो” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“बाछा, भेडा पाठा कि क्‍यारश पाठा जरमेशा, मेको ७ नाक्‍त सम्‍म आ ममा नु बाक्‍चा माल्‍ब। मिनु मेको कली ८ नाक्‍त रे चोशा चढ़ेशोनु, परमप्रभु यावेमी ब्राइब। प्रस्‍थान २७:२९ ");
INSERT INTO suzBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","तन्‍न गेपुकी बी नु आ चाइक्‍ब कि भेडा नु आ पाठा काबुमी क्‍योरचा मदुम्‍ब। ब्‍यवस्‍था २२:६-७ ");
INSERT INTO suzBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","गेपुकीमी परमप्रभु यावे कली ‘गे रिम्‍शो पाइब बाक्‍नीनी’ दे चढ़ेशो चढ़ेनीनु, मेको इन पर्बम ब्रचा ङा पा चढ़ेने। लेवी ७:१५ ");
INSERT INTO suzBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","मेको चढ़ेशो नाक्‍ती मेको कली ब्‍वने। आ दीसा सुनी सम्‍म मारेइ महेंचा। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","मिनु गेपुकीमी आं शेंतीके तुइश्‍शा टिने। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","गे आं ग्रांग्रा रे ङोन बाक्‍शो नें ग्रांग्रा दिशो मसेलीन। मोपतीके गो इस्राएली आन दातेमी का ला ठेयब दुम्‍ती। गो परमप्रभु यावे नङ। मिनु गो इन कली आंम आं मुर सेल्‍ता। लेवी २२:९,१६ ");
INSERT INTO suzBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","मिनु इन परमप्रभु दुम्‍चा कली गो इन कली इजीप्‍त रागी रे ग्रुंइताक्‍ङ। गो परमप्रभु यावे नङ, दे शेंदो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“गे इस्राएली आन कली ‘परमप्रभु यावे आ देंशो पचा माल्‍शो चाड परमप्रभु यावे के बाक्‍नीम। मिनु गे मेको पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","गे ६ नाक्‍ती सम्‍म गेय पचा माल्‍नीनी। तन्‍न ७ नाक्‍त चहिं थमा पा नाइक्‍तीक नाक्‍ती बाक्‍शा, परमप्रभु यावे केन बाक्‍ब। गे मारेइ गेय मपने। इन बाक्‍तीक नेल्‍लेमी परमप्रभु यावे आ नाइक्‍तीक नाक्‍ती बाक्‍ब’ ” देंत। प्रस्‍थान २०:८-११ ");
INSERT INTO suzBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","मिनु परमप्रभु यावेमी लेंशा, मुर आन कली शेंचा, दे मोसा कली “परमप्रभु यावे आ देंशो पचा माल्‍शो चाड आ चाड बाक्‍नीम। आ देंशो नाक्‍ती मानेचा माल्‍नीनी। परमप्रभु यावे आ चाडपुकी मार बाक्‍नीम देंशा हना, प्रस्‍थान २३:१४-१९ ");
INSERT INTO suzBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ङोंइती ङा महिना ङा १४ नाक्‍ती नाक्‍नाक्‍दो पास्‍सा चाड ङा परमप्रभु यावे कली चढ़ेतीक गेय पचा माल्‍नीम। प्रस्‍थान १२:- ");
INSERT INTO suzBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","मेको महिना ङा १५ नाक्‍ती परमप्रभु यावे कली बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जतीक चाड बाक्‍ब। गेपुकीमी ७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ङोंइती ङा नाक्‍ती आं पर्बम ग्रुम्‍तीक नाक्‍ती दुम्‍चा माल्‍ब। मेको नाक्‍ती मारेइ गेय मपने। ");
INSERT INTO suzBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","मिनु ७ नाक्‍त सम्‍म गेपुकीमी परमप्रभु यावे कली मी चोशो चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको आ ७ नाक्‍ती लेंशा परमप्रभु यावे आ पर्बम ग्रुम्‍तीक दुम्‍चा माल्‍ब। मेको नाक्‍ती गेपुकीमी मारेइ गेय मपने” देंत। प्रस्‍थान १३:६ ");
INSERT INTO suzBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“गे इस्राएली आन कली ‘इन कली गेशो रागीम जाक्‍दीश्‍शा, मेकेर ङा बाली नाली खुप्‍तीनीनु, गेपुकीमी ङोंइती ङा रिक्‍शो बाली मुठा का चढ़ेब आन कली चाक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","मेकोमी अन्‍न मुठा परमप्रभु यावे आ ङोंइती क्‍युक्‍शा हिम्‍चा माल्‍ब। मो पाइतीनी हना परमप्रभु यावेमी इन कली ब्राइब। नाइक्‍तीक नाक्‍ती आ दीसा चढ़ेबमी मेको क्‍युक्‍शा हिम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","मेको क्‍युक्‍शा हिम्‍शो नाक्‍ती गेपुकीमी परमप्रभु यावे कली बर्स का दुम्‍शो मारेइ मदुम्‍शो थम रिम्‍शो सांड चोशा चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","मेको नु अन्‍न चढ़ेतीक चढ़ेचा माल्‍नीनी। मेको अन्‍न चढ़ेतीक चहिं तेलम निशो एफाह के २० भाग थम रिम्‍शो फस दुम्‍चा माल्‍ब। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। मेको नु तूचा थोव़क चढ़ेतीके हिन का ङा ४ भाग सेल्‍शो रे भाग का अङगुर शांबु चढ़ेचा माल्‍नीनी। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको के २० भाग ४.४ लिटर बाक्‍ब। लोग आइक्‍च पुक्‍तीके का बाक्‍ब। मेको ०.३ लिटर रिक्‍ब। हिन अर्को पुक्‍तीक का बाक्‍ब। हिन का ४ लिटर खोदेंशो रिक्‍ब। हिन का ४ भाग सेल्‍शो रे भाग का लिटर का खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","मेको नेल्‍ल परमप्रभु कली चढ़ेशो नोले ला शोब्‍ले, कारशो अन्‍न नु गिगी बाला मारेइ जने चाप्‍नीनी। मेको गेपुकी ते बाक्‍तीनी हना यो, एको गेना हना यो नेल्‍ल पाला सम्‍म पतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","मिनु नाइक्‍तीक नाक्‍ती आ दीसा, गे अन्‍न आ मुठा क्‍युक्‍शा हिम्‍शा चढ़ेतीक नाक्‍त रे गेपुकीमी ७ हप्‍ता हिक्‍चा माल्‍नीनी। गन्‍ती २८:२६-३१; ब्‍यवस्‍था १६:९-१२ ");
INSERT INTO suzBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","मिनु गेपुकीमी ७ हप्‍ता आ दीसा, ५० नाक्‍त सम्‍म हिक्‍चा माल्‍नीनी। मेको नाक्‍ती गेपुकीम परमप्रभु यावे कली नक अन्‍न चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","गेपुकीमी आंम इन खिं रे शोब्‍ले निक्‍शी क्‍युक्‍शा हिम्‍शा चढ़ेचा कली माल्‍नीनी। मेको शोब्‍ले का एफाह का के २० भाग थम रिम्‍शो फस रे बोरब ओख्‍ती सुप्‍थु चोशा सेल्‍शो दुम्‍चा माल्‍ब। मेको ङोंइती मीशो अन्‍न के परमप्रभु यावे कली चढ़ेतीक बाक्‍ब। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको के २० भाग ४.४ लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","मेको शोब्‍ले नु बर्स का गाप्‍शो ७ ओटा मारेइ मदुम्‍शो थम रिम्‍शो पाठा नु ब्‍यफ का नु सांड निक्‍शी चढ़ेचा माल्‍नीनी। मेको अन्‍न चढ़ेतीक नु तूचा थोव़क चढ़ेतीके परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशो चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","मिनु गेपुकीमी पाप आ पर्बम चढ़ेचा कली बोका का नु दुशा बाक्‍चा आ पर्बम चढ़ेचा कली बर्स का गाप्‍शो सांड निक्‍शी यो चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","मिनु चढ़ेबमी परमप्रभु यावे कली ङोंइती नक मीशो अन्‍न के शोब्‍ले नु सांड निक्‍शी क्‍युक्‍शा हिम्‍शा चढ़ेचा माल्‍ब। मेको चढ़ेब आ भाग दुम्‍चा कली परमप्रभु यावे कली गेशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","मेको नाक्‍त इन कली ठेयब ग्रुम्‍तीक नाक्‍त बाक्‍ब, दे गेपुकीमी नेल्‍ल आन कली नेंपाइक्‍चा माल्‍नीनी। गेपुकीमी मारेइ गेय मपने। मेको गेपुकी ते बाक्‍तीनी हना यो, एको गेना हना यो नेल्‍ल पाला सम्‍म पतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","मिनु गेपुकीमी इन बाली नाली रिक्‍नीनु, रू आ कुना कुना सम्‍म मरिक्‍कीन। गेपुकीमी इन रू ङा सिला बाला यो मगुपीन। गेपुकीमी इन दाते ङा प्रुङग नु अर्को रागी ङा मुर आन पर्बम प्रोनीन। गो परमप्रभु यावे, इन परमप्रभु नङ’ दे शेंचा माल्‍नेवे” देंत। लेवी १९:९-१० ");
INSERT INTO suzBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएली आन कली ‘७ महिना ङा ङोंइती ङा नाक्‍ती गे नाइक्‍चा माल्‍नीनी। गे परमप्रभु यावे आ पर्बम ग्रुम्‍शा, मेको नाक्‍त मिम्‍चा कली तुराही ताप्‍चा माल्‍नीनी। गन्‍ती २९:१-६; गन्‍ती १०:१० ");
INSERT INTO suzBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","गेपुकीमी मेको नाक्‍त मारेइ गेय मपने। मिनु परमप्रभु यावे कली मीम चोशो चढ़ेतीके चढ़ेन’ दे शेंचा माल्‍नेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“मेको ७ महिना ङा १० नाक्‍त पाप क्‍याम्‍तीक नाक्‍त बाक्‍ब। मेको नाक्‍ती गेपुकीमी परमप्रभु यावे आ पर्बम ग्रुम्‍चा माल्‍नीनी। गेपुकी मेको नाक्‍त माइजा बाक्‍चा माल्‍नीनी। मिनु गेपुकीमी परमप्रभु यावे कली मीम चोशा चढ़ेतीक चढ़ेचा माल्‍नीनी। लेवी १६:- ");
INSERT INTO suzBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","मेको नाक्‍त मारेइ गेय मपने। मारदे हना मेको पाप क्‍याम्‍तीक नाक्‍त बाक्‍ब। मेको नाक्‍ती परमप्रभु यावे, इन परमप्रभु आ ङोंइती इन पर्बम पाप क्‍याम्‍तीक गेय पतीक नाक्‍ती बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","मिनु सु मेको नेल्‍ल नाक्‍ती माइजा मबाक्‍बा, मेको आ मुर आन दाते रे साइक्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","मिनु सुइमी मेको नाक्‍त मारेइ गेय पाम्‍तेक्‍म हना, गो मेको आन कली साइक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","गेपुकीमी मेको नाक्‍त मारेइ गेय मपने। गेपुकी ते बाक्‍तीनी हना यो, मेको गेना हना यो इन पतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","मेको नाक्‍त इन कली थमा पा नाइक्‍तीक नाक्‍त बाक्‍ब। मिनु मेको नाक्‍त गेपुकी माइजा बाक्‍चा माल्‍नीनी। मेको महिना ङा ९ नाक्‍त ङा नां रिक्‍म रे आ दीसा नां रिक्‍म सम्‍म गेपुकी माइजा बाक्‍शा नाइक्‍चा माल्‍नीनी, दे शेंचा माल्‍नेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“गे इस्राएली आन कली ‘७ महिना ङा १५ नाक्‍त रे ७ नाक्‍न सम्‍म परमप्रभु यावे आ ङोंइती गोठ सेल्‍शा बाक्‍तीक चाड मानेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","मेको आ ङोंइती ङा नाक्‍ती परमप्रभु यावे आ पर्बम ग्रुम्‍चा माल्‍नीनी। गेपुकी मेको नाक्‍त इन गेय मपने। ");
INSERT INTO suzBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","मिनु गेपुकीमी ७ नाक्‍त सम्‍म परमप्रभु यावे कली मीम चोशा चढ़ेतीक चढ़ेन। मिनु गेपुकीमी आ दीसा परमप्रभु यावे आ पर्बम ग्रुम्‍तीक नाक्‍ती मानेन। मिनु परमप्रभु यावे कली मीम चोशा चढ़ेन। मेको ठेयब ग्रुम्‍तीक नाक्‍ती बाक्‍ब। मिनु गेपुकीम मेको नाक्‍त इन गेय काइ मपने। यूहन्‍ना ७:३७ ");
INSERT INTO suzBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","मिनु परमप्रभु यावे आ देंशो ठेयब ग्रुम्‍तीक ङा मानेचा माल्‍शो चाड तेको बाक्‍नीम देंशा हना, मेको नाक्‍ती गेपुकीमी परमप्रभु यावे कली मीम चोशा चढ़ेतीके, अन्‍न चढ़ेतीके, क्‍योरशा चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ठीक नाक्‍ती चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","मेको क्‍येङा परमप्रभु यावे आ नाइक्‍तीक नाक्‍ती ङा, इन दाक्‍शा गेतीक थोव़क, इन कबल पशो गेतीक थोव़क नु इन ग्‍येरशा गेशो थोव़क परमप्रभु यावे कली चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","मिनु ७ महिना ङा १५ नाक्‍ती आंम रू ङा अन्‍न खुप्‍शो नोले गेपुकीमी ७ नाक्‍त सम्‍म परमप्रभु यावे आ चाड मानेचा माल्‍नीनी। ङोंइती ङा नाक्‍त नु ८ नाक्‍ती थमा पा नाइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ङोंइती ङा नाक्‍ती गेपुकीमी रवा आन रिम्‍शो फल फुल, खजूर रवा आन राशी, शुश सफा पाइश्‍शो रवा आन राशी नु अरु खोलामी बाक्‍शो रवा आन राशी चाक्‍शा, गे परमप्रभु यावे, इन परमप्रभु आ ङोंइती ७ नाक्‍त सम्‍म ग्‍येरसीन। नेहेम्‍याह ८:१४-१६ ");
INSERT INTO suzBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","गेपुकीमी बर्सम ७ नाक्‍त सम्‍म एको चाड मानेशा, परमप्रभु यावे कली ठेयब सेल्‍चा माल्‍नीनी। गेपुकी ७ महिनामी एको चाड मानेचा माल्‍नीनी। एको इन कली गेना हना यो पतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","गे ७ नाक्‍त सम्‍म गोठीमी बाक्‍कीन। इस्राएल ङा मुर नेल्‍ल गोठीम बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","गो इन कली इजीप्‍त रे ग्रुंइशा चाक्‍नीनु, गोठीम बाक्‍पाइश्‍शो नङ, दे इन चच युइपुकीम तुइक्‍चा माल्‍नीम। गो परमप्रभु यावे, इन परमप्रभु नङ’ दे शेंदो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","मिनु मोसामी परमप्रभु यावे कली मानेचा माल्‍शो चाड मुर नेल्‍ल आन कली नेंपाइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“गे इस्राएली आन कली ‘बत्ती गेना हना यो ब्रपाइश्‍शा वोइक्‍चा कली गेपुकीमी तेल रवा आ फल रे तुप्‍शा सेल्‍‍शो तेल चाक्‍कीन। प्रस्‍थान २७:२ ");
INSERT INTO suzBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","मिनु हारूनमी बत्ती कली ग्रुम्‍तीक ताम्‍बु आगा, फारशो वा आ ङोंइती वोइक्‍चा माल्‍ब। मेको परमप्रभु यावे आ ङोंइती नाक्‍दो रे सुनी सम्‍म गेना हना यो ब्रचा माल्‍ब। मेको इन कली गेना हना यो पतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","मेकोमी परमप्रभु यावे आ ङोंइती क्‍येख सुन के सेल्‍शो बत्ती दातीक तारी गेना हना यो वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","गे रिम्‍शो फस चाक्‍शा, बार ओटा शोब्‍ले चोवो। शोब्‍ले का एफाह का के २० भाग थम रिम्‍शो फस के दुम्‍चा माल्‍ब। एफाह पुक्‍तीके का बाक्‍ब। एफाह का २२ लिटर रिक्‍ब। मेको के २० भाग ४.४ लिटर खोदेंशो बाक्‍ब।प्रस्‍थान २५:३० ");
INSERT INTO suzBl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","मेको शोब्‍ले परमप्रभु यावे आ ङोंइती क्‍येख सुन के टेबल आ तार ६, ६ ओटा ख्रोप्‍शा वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","मेको निक्‍शी ख्रोप्‍तीकेमी का का पा रिम्‍शो धूप वोइक्‍चा माल्‍ब। मिनु मेको शोब्‍ले आ पा ङा मेको धूप मीम चोशा परमप्रभु यावे कली चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","मोपा हारूनमी नेल्‍ल नाइक्‍तीक नाक्‍ती मेको शोब्‍ले कली परमप्रभु यावे आ ङोंइती वोइक्‍चा माल्‍ब। मेको इस्राएली आन कली मेको गेना हना यो पतीक नु लीब कबल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","मेको शोब्‍ले हारून नु आ तौ चच आन कली बाक्‍नीम। मेकोपुकीमी मेको शोब्‍ले चोव़खो बाक्‍तीकेमी बाक्‍शा जचा माल्‍नीम। मारदे हना मेको शोब्‍ले परमप्रभु यावे कली मीम चोशा चढ़ेशो रे नेल्‍ल क्‍येङा चोव़खो हारून नु आ तौ चच आन भाग बाक्‍ब’ दे अरेवो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","मिनु इजीप्‍ती आफ नु इस्राएली ममा पाइश्‍शो मुर का बाक्‍माक्‍त। मेको मुर इस्राएली आन दातेमी जाक्‍शा, इस्राएली का नु तुम्‍मुसा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","मिनु मेको इस्राएली ममा आ तौमी परमप्रभु यावे आ नें थिशा, सराप पवा बाक्‍त। मिनु मुरपुकीमी मेको कली मोसा आ बाक्‍तीकेम चाक्‍गमे बाक्‍त। मेको आ ममा आ नें शेलोमीथ बाक्‍माक्‍त। मिनु मेको दान आ थर ङा दिब्री आ तमी बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","मिनु मेको मुर कली चाक्‍शा, परमप्रभु यावे आ मिम्‍शो मतुइक्‍तमे सम्‍म चोक्‍शा वोदमे बाक्‍त। गन्‍ती १५:३४ ");
INSERT INTO suzBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","मिनु नोले परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“मेको सराप पाइब कली मुर आन बाक्‍तीक रे लाङगा ग्रुंइदीन। मिनु मेको आ नेक्‍था बाक्‍ब मुर नेल्‍लेमी मेको आन गुइ आ पिया तारी वोइक्‍चा माल्‍नीम। मिनु मेको नोले नेल्‍लेमी मेको कली फुल्‍लु आप्‍शा साइक्‍चा माल्‍नीम। गन्‍ती १५:३६; ब्‍यवस्‍था १५:५; प्रेरित ७:५६ ");
INSERT INTO suzBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","मिनु गे इस्राएली आन कली ‘सुम आ परमप्रभु कली सराप पाइबा, मेको आ पाप राइब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","परमप्रभु यावे आ नें आ पर्बम मरिम्‍शो लोव़ पाइब साइक्‍चा पुंइसीब। इस्राएल ङा मुर बाक्‍त हना यो, अर्को रागी ङा मुर बाक्‍त हना यो, सुम परमप्रभु यावे आ नें आ पर्बम मरिम्‍शो लोव़ पाइबा, मेको साइक्‍चा पुंइसीब। प्रस्‍थान २०:७; मत्ती २६:६५-६६ ");
INSERT INTO suzBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","सुमी मुर का कली साइक्‍बा, मेको साइक्‍चा पुंइसीब। प्रस्‍थान २१:१२ ");
INSERT INTO suzBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","सुइमी बस्‍तु भाव कली तुप्‍शा साइक्‍तु हना, मेको आ पा ङा अरु गेचा माल्‍ब। ब्रोंइशो बस्‍तु आ पा ङा ब्रोंइशो बस्‍तु गेचा माल्‍ब। प्रस्‍थान २१:३३-३७ ");
INSERT INTO suzBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","सुइमी आ नेक्‍था ङा मुर कली आ खोइल जिक्‍ताक्‍व हना, मेको यो आ खोइल जिक्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","जिक्‍तीके आ पा ङा जिक्‍तीके, मिक्‍च आ पा ङा मिक्‍च, ख्रुइ आ पा ङा ख्रुइ, सुमी सु कली मार पाइबा, मेको यो मो पाइक्‍चा पुंइसीब। मेको कली यो मो पाइक्‍चा माल्‍ब। प्रस्‍थान २१:२३-२५ ");
INSERT INTO suzBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","सुइमी बी ब्‍यफ, क्‍यारश भेडा आन कली तुप्‍शा साइक्‍तु हना, मेको आ पा ङा अर्को गेचा माल्‍ब। तन्‍न मुर साइक्‍ब कली चहिं, साइक्‍चान माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","आंम रागी ङा मुर नु अर्को रागी ङा मुर आन पर्बम खाल का ङा ऐन कानुन दुम्‍चा माल्‍ब। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ’ दे शेंचा माल्‍नेवे” देंत। लेवी १९:३४; प्रस्‍थान १२:४९ ");
INSERT INTO suzBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मिनु मोसामी इस्राएली आन कली मेको लोव़ शेंदीमी नोले मेकोपुकीमी मेको सराप पाइब कली मुर आन बाक्‍तीक रे ग्रुंइशा, फुल्‍लु आप्‍शा साइक्‍तेक्‍म। मिनु परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा इस्राएली नेल्‍लेमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","मिनु परमप्रभु यावेमी सीनै डांडामी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“गे इस्राएली आन कली ‘गेपुकी गो इन कली गेशो रागीमी जाक्‍दीन्‍नी नोले मेको रागी यो परमप्रभु यावे आ नेंमी नांइसीचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","गे ६ बर्स सम्‍म आंम रूम मार मार शोक्‍चा ख्रुम्‍चा माल्‍नीनी। ६ बर्स सम्‍म इन अङगुर रू ङा बोट आन मसिश्‍शो राशी ख्रोइश्‍शा ताइक्‍चा माल्‍नीनी। मिनु मेको आ अङगुर खुप्‍चा माल्‍नीनी। प्रस्‍थान २३:१०-११ ");
INSERT INTO suzBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","तन्‍न ७ बर्सम रू नेल्‍ले परमप्रभु यावे आ बर्सम नाइक्‍चा माल्‍ब। गेपुकीमी ७ बर्सम इन रूम मारेइ मशोक्‍चा मख्रुम्‍चा। मिनु अङगुर बोट आ फल मसिप्‍ब राशी यो मख्रोतीन। ");
INSERT INTO suzBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","इन रूमी आंमा वाशो मारेइ मारेइ खुप्‍चा मदुम्‍ब। मख्रोइश्‍शो अङगुर बोट आ फल खुप्‍चा मदुम्‍ब। मेको रू कली थम नांइसीतीक बर्स दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","मेको रू नांइसे ना आंमा सिश्‍शो मारेइ मारेइ जने चाप्‍नीनी। मिनु इन वाइलीम वाइल नु गे नु बाक्‍ब इन थाप्‍शो गेय पाइबपुकीमी जने चाप्‍नीमी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","मेको रूमी वाशो, इन बस्‍तु भाव नु ब्‍वाकी ङा जन्‍तु आन कली ब्‍वतीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","मिनु गेपुकीमी ७ नाइक्‍तीक बर्स मानेनी नोले, मिनु ४९ बर्स दुम्‍बा, ");
INSERT INTO suzBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","मिनु ७ महिना ङा १० नाक्‍ती पाप क्‍याम्‍तीक नाक्‍त बाक्‍ब। मेको नाक्‍ती इन रागी नेल्‍लेमी तुराही ताप्‍पाइक्‍चा माल्‍नीनी। लेवी २३:२७ ");
INSERT INTO suzBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","मिनु ५० ङा बर्स परमप्रभु यावे आ बर्स बाक्‍ब। मिनु गे रागी ङा मुर नेल्‍ल आन कली आन ङोंइती ङा अधिकार लेंशा ताइनीम, दे नेंपाइक्‍चा माल्‍नीनी। मेको इन कली प्रोंइतीक बर्स बाक्‍ब। मिनु मुर नेल्‍ल आन आन खिं नु आन आन बाक्‍तीक लेन्‍ने चाप्‍नीम। यसैया ६१:२; लूका ४:१९ ");
INSERT INTO suzBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","मेको ५० बर्स इन कली ङोंइती ङा खोदेंशो पा लेंशा सेल्‍तीक बर्स बाक्‍ब। मेको बर्स गेपुकीमी मारेइ मशोक्‍कीन, मख्रुमीन। आंमा वाशो बाली नाली मरुप्‍चा। अङगुर बोट आन ममुंइशो राशीम सिश्शो अङगुर मखुप्‍चा। ");
INSERT INTO suzBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","मारदे हना मेको प्रोंइतीक बर्स बाक्‍ब। मेको परमप्रभु यावे आ बर्स दुम्‍ब। गेपुकीमी रूम आंमा वाशो, आंमा सिश्‍शो ला जने। ");
INSERT INTO suzBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","मेको प्रोंइतीक बर्समी मुर नेल्‍ल आन आन रू नु खिं लेत्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","मिनु आंम नेक्‍था ङा मुर नु ग्‍याप्‍तीक लेयतीक गेय पनीनु, मठगेपामुने। १ थिस्‍सलोनिकी ४:६ ");
INSERT INTO suzBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","गे इन नेक्‍था ङा मुर रे रू का ग्‍याप्‍तीवी हना, मेको प्रोंइतीक बर्स जाक्‍चा गिश बर्स लीनीम, दे हिक्‍शा ला ग्‍यापीन। ");
INSERT INTO suzBl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","गिश बर्स लीनीमी मेको कोव़शा गेपुकीमी आ क्‍येट बारपाइक्‍चा माल्‍नीनी। मिनु इच्‍का बर्स ला लीतेक्‍म हना, क्‍येट तोक्‍चा माल्‍नीनी। मारदे हना अन्‍न खुप्‍तीक बर्स कोव़शा, मेको रू लेयशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","गेपुकी आंम आंमा मठगेपामुने। तन्‍न परमप्रभु क्‍येङा हिनीन। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","गेपुकीमी आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ तुइश्‍शा पचा माल्‍नीनी। आ पावो, दे अरेशो लोव़ टिने। मोपा ला गे मेको रागीमी रिम्‍शो पा बाक्‍ने चाप्‍नीनी। लेवी २६:५; १राजा ५:५ ");
INSERT INTO suzBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","मिनु रागीमी अन्‍न ग्रेल्‍ब। गेपुकी जचा तूचाम श्‍येत मजाइनीनी। मिनु मेको रागीमी महिंथु थुं नाइश्‍शा बाक्‍चा ताइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","गेपुकीमी अन्‍न मशोक्‍थु मखुप्‍थु ७ बर्सम चहिं गो मार जाइनीकी, दे देंतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","गो ६ बर्सम इन कली आं आसीक गेनन्‍नी। मिनु रागीम बर्स सां सम्‍म शुश अन्‍न ग्रेल्‍पाइक्‍नुङ। ब्‍यवस्‍था २८:८ ");
INSERT INTO suzBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","गेपुकीमी ८ बर्सम ख्रुम्‍नीनु, गे माइत अन्‍न रे जाइनीनी। ९ बर्सम नक बाली नाली ममीम सम्‍म गे माइतन जाइनीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","मिनु इन गे रू गेना हना यो कली लेयने मचाप्‍नीनी। मारदे हना मेको रागी आं के बाक्‍ब। गेपुकी गे आं के वाइल नु बुम्‍था पाइब खोदेंशो बाक्‍नीनी। भजन संग्रह ३९:१३ ");
INSERT INTO suzBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","इन ग्‍याप्‍शो अधिकारम पिशो रू लेंशा लेत्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","सुइ इन मुर प्रुङग दुम्‍तीके आन रू लेयचा माल्‍तेक्‍म हना, मेको आ नेक्‍था ङा मुर जाक्‍शा, मेको लेश्‍शा ग्‍याप्‍पाइक्‍चा माल्‍ब। रूथ ४:३-४ ");
INSERT INTO suzBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","तन्‍न मो पाइब सुइ मबाक्‍तेक्‍म हना, नोले मेको आंमान क्‍येट थीब दुम्‍शा, लेश्‍शा आंमा ग्‍याप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","मेकोमी मेको लेयशो गिश बर्स दुम्‍मे, मेको हिक्‍चा माल्‍ब। मिनु सु कली लेयशो बाक्‍मे, मेको लीशो बर्स ङा खुप्‍‍तीक अन्‍न ङा क्‍येट गेचा माल्‍ब। मिनु मेको मुर आ रू लेंशा मेको केन दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","तन्‍न आंमा लेन्‍ने मचाप्‍तु हना, मेको रू ग्‍याप्‍ब मुर नु बाक्‍ब। मिनु रू ग्‍याप्‍बमी प्रोंइतीक बर्सम लेत्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","मिनु सुइमी गारो हिरशो सहर आगा ङा खिं लेयतु हना, लेयशो बर्स का सम्‍म मेकोमी मेको आ खिं लेन्‍ने चाप्‍ब। मेको कली मेको अधिकार बर्स का सम्‍म बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","तन्‍न बर्स काम यो मेको लेन्‍ने मचाप्‍तु हना, ग्‍याप्‍ब नु आ खिं ङा मुर आन कली मेको खिं आन शोंप दुम्‍ब। प्रोंइतीक बर्सम यो मेको लेश्‍शा गेचा ममाल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","तन्‍न गारो महिरशो बाक्‍तीके ङा खिंपुकी चहिं रूपुकी खोदेंशो पा पचा माल्‍ब। मेको लेन्‍ने चाप्‍नीम। मिनु प्रोंइतीक बर्सम लेश्‍शा गेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","मिनु लेवी आन सहरमी बाक्‍शो खिं चहिं मेकोपुकीमी आंम खिं गेना हना यो लेन्‍ने चाप्‍नीम। गन्‍ती ३५:२-५ ");
INSERT INTO suzBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","लेवी आन सहरम बाक्‍शो लेयशो खिं अरु लेवीम लेन्‍ने मचाप्‍तेक्‍म हना, प्रोंइतीक बर्समी मेको खिं लेश्‍शा, मेको कली गेचा माल्‍ब। मारदे हना लेवी आन सहरम बाक्‍शो खिं इस्राएली आन दातेमी लेवी आन शोंप बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","मेको आन सहर क्‍येङा लाङगाम बाक्‍शो रूपुकी लेयचा मताइनीम। मारदे हना मेको आन गेना हना यो लीब शोंप बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","मिनु इन इस्राएली लोक्‍ब का शुश प्रुङग दुम्‍शा, पने जने मचाप्‍तु हना, गेपुकीमी मेको कली अर्को रागी ङा मुर खोदेंशो पा वारच पचा माल्‍नीनी। मिनु मेको गेपुकी नु बाक्‍ने चबल। ");
INSERT INTO suzBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","मिनु गे मेको कली जेर गेनीनु, आ चाइक्‍ब मताक्‍कीन। गे इन परमप्रभु क्‍येङा हिनीन। मिनु इन लोक्‍ब कली गे नु बाक्‍चा गेन। प्रस्‍थान २२:२४; ब्‍यवस्‍था २३:२० ");
INSERT INTO suzBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","गेपुकीमी मेको कली क्‍येट गेतीकेमी चाइक्‍ब मताक्‍कीन। मिनु मेको कली जचा थोव़क गेशा, मेको आ क्‍येङा शुश मलेप्‍पाइक्‍तीन। ");
INSERT INTO suzBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","गो इन परमप्रभु दुम्‍चा नु इन कली कनान रागी गेचा, दे इन कली इजीप्‍त रागी रे ग्रुंइशा, एक चाक्‍ब, गो परमप्रभु यावे, इन परमप्रभु नङ। ");
INSERT INTO suzBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","मिनु गे इन इस्राएली लोक्‍ब शुश प्रुङग दुम्‍शा, आंमा इन कली लेयसाक्‍म हना, मेको आन कली वाइल खोदेंशो पा गेय मपपतीन। प्रस्‍थान २१:२ ");
INSERT INTO suzBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","मिनु गेपुकीमी मेको कली थाप्‍शो गेय पाइब कि अर्को रागी ङा गेय पाइब खोदेंशो पा बाक्‍चा गेने। मिनु मेको प्रोंइतीक बर्स सम्‍म गेपुकी नु बाक्‍शा इन गेय पाइब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","मिनु नोले मेकोपुकी नु आन तमी तौ गे इन बाक्‍तीक रे लशा, आन खिं ङा मुर नु आन बाक्‍तीक लेम्‍मल। ");
INSERT INTO suzBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","मारदे हना मेकोपुकी गो इजीप्‍त रे ग्रुंइशा चाक्‍शो आं गेय पाइबपुकी बाक्‍नीम। मेको आन कली वाइलीम वाइल खोदेंशो पा लेयचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","मिनु गेपुकीमी मेको आन कली शुश अरेशा श्‍येत मगेन। इन परमप्रभु कली तशा हिनीन। प्रस्‍थान २१:२०-२१ ");
INSERT INTO suzBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","मिनु गेपुकीमी इन वाइलीम वाइल चहिं एर ओंथ ङा अर्को रागी ङा मुर रे ग्‍याप्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","गेपुकी नु बाक्‍ब अर्को रागी ङा मुरपुकी नु इन रागीम जरमेशो मेको आन खिं ङा मुर रे ग्‍याप्‍शा, इन के सेल्‍ने चाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","गे मेको आन कली आंम तौ चच आंम वाइलीम वाइल दुम्‍चा कली ग्‍याप्‍शा वोइक्‍ने चाप्‍नीनी। गे मेको आन कली वाइलीम वाइल खोदेंशो पा दिप्‍शा गेय पपाइक्‍ने चाप्‍नीनी। तन्‍न आंम लोक्‍ब इस्राएली आन कली मोपा श्‍येत गेशा दिप्‍ने मचाप्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","मिनु इन दातेमी बाक्‍ब अर्को रागी ङा मुर क्‍येट थीब दुम्‍त हना नु सुइ इन लोक्‍ब श्‍येत जशा, प्रुङग दुम्‍शा, मेको आंम कली कि आ खिं ङा मुर कली लेयसाक्‍व हना, ");
INSERT INTO suzBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","मेको लेयसे नोले आ लोक्‍बपुकीमी मेको कली लेन्‍ने चाप्‍नीम। मेको आ लोक्‍ब कामी मेको कली लेन्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","मेको आ आफ आ लोक्‍ब, आं लोक्‍ब नु सुइ आ नेक्‍था ङा मुरुमी मेको कली लेन्‍ने चाप्‍ब। मेको नोले शुश क्‍येट थीब दुम्‍त हना, आंमा थाप्‍शा ग्रूने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","मेको मुरुमी आ अर्को रागी ङा ठेयब मुर कली लेयसीशो बर्स रे प्रोंइतीक बर्स सम्‍म हिक्‍शा, आ गेय पतीक लीशो बर्स कली जेला तशो खोदेंशो पा हिक्‍चा माल्‍ब। मिनु लीशो बर्सम ततीके जेला ङा क्‍येट हिक्‍शा थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","मिनु शुश बर्स लीमेनु, आंमा लेयसीशो मुरुमी मेको गेय मपशो नेल्‍ल बर्स हिक्‍शा, मेको कली गारचा ङा पा थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","मिनु मेको प्रोंइतीक बर्स सम्‍म का निक्‍शी बर्स ला लीतेक्‍म हना, मेकोमी जेला तशो खोदेंशो पा का निक्‍शी बर्स ङा गारचा ङा पा प्रोंइतीक बर्स सम्‍म क्‍येट थाप्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","मिनु मेको अर्को रागी ङा ठेयब मुरुमी आंमा लेयसीशो इस्राएली कली बर्स का कली जेला ताक्‍शा गेय पाइब खोदेंशो पा रिम्‍शो पचा माल्‍ब। मेको कली वाइलीम वाइल कली खोदेंशो पचा मदुम्‍ब। लेवी २५:४३ ");
INSERT INTO suzBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","मोपा यो मेको मुर प्रोंइचा मपुंइसाक्‍व हना, रिम्‍शा। मेको नु आ खिं ङा मुर प्रोंइतीक बर्सम ला लचा ताइनीम। ");
INSERT INTO suzBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","मारदे हना इस्राएलीपुकी आं गेय पाइब बाक्‍नीम। गो मेको आन कली इजीप्‍त रागी रे ग्रुंइशा चाक्‍ताक्‍मी। गो परमप्रभु यावे, इन परमप्रभु नङ’ दे शेंदो” दे परमप्रभु यावेमी देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","मिनु लेंशा परमप्रभु यावेमी मोसा कली “गेपुकीमी इन कली मूर्तिपुकी मसेलीन। मिनु आंम कली मुशा मूर्ति नु पूजा पचा कली थाम मवोतीन। मिनु इन रागीमी मुशो फुल्‍लु मवोतीन। मेको कली पूजा पा आन ङोंइती मबपीन। मारदे हना गो परमप्रभु यावे, इन परमप्रभु नङ। प्रस्‍थान २०:४-५ ");
INSERT INTO suzBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","गेपुकीमी आं नाइक्‍तीक नाक्‍ती मानेन। मिनु आं बाक्‍तीक कली मान पने। गो परमप्रभु यावे नङ। लेवी १९:३० ");
INSERT INTO suzBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","गेपुकीमी आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ टिशा पाइतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","गो रेउ यिची ना रेउ यिपाइक्‍नुङ। मिनु इन रूम शुश अन्‍न ग्रेल्‍नीम। मिनु रवाम शुश फल फुल सित्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","मिनु अङगुर सेक्‍ची ना सम्‍म इन अन्‍न तुप्‍नीनी। मिनु अङगुर सेक्‍ने मथुम्‍थु शोक्‍ची ना दुम्‍ब। मोपा गेपुकी नु शुश जचा तूचा बाक्‍ब। मिनु इन रागीम थुं नाइश्‍शा बाक्‍चा ताइनीनी। आमोस ९:१३ ");
INSERT INTO suzBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","मिनु गो रागी ङा मुर आन कली थुं नाइश्‍शा बाक्‍चा गेनुङ। मिनु गेपुकी गोल्‍शा निन्‍द्रा पाइनीनी। सुइमी इन कली हिंच मकोंइब। गो इन रागी रे हिंचा ङा जन्‍तु आन कली खेरनुङमी। इन रागीमी लडाइ मदुम्‍ब। इजीकीएल ३४:२५ ");
INSERT INTO suzBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","मिनु गेपुकीमी इन जोरी सत्रु आन कली खेदा पा तरवारम साइक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","इन मुर ५ जनामी सहे का मुर आन कली नु सहे का मुरुमी १० हजार मुर आन कली खेदा पाइनीम। इन जोरी सत्रु इन तरवारम शोल्‍मो पा बेक्‍नीम। ब्‍यवस्‍था ३२:३०; यहोसु २३:१० ");
INSERT INTO suzBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","मिनु गो इन कली शिशी पा कोव़नन्‍नी। मिनु गो इन कली सोशा बोशा शुश दुम्‍पाइक्‍नुङ। मिनु आं पशो कबल गेपुकी नु गेना हना यो लीपाइक्‍नुङ। इजीकीएल ३६:११ ");
INSERT INTO suzBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","गेपुकीम इन खेक्‍शा वोइश्‍शो माइत अन्‍न जना जन, नक अन्‍न वोइक्‍चा कली माइत अन्‍न तिल्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","गो इन कली ग्रांग्रा मदित्‍थु, इन दातेमीन आ बाक्‍तीकेम बाक्‍नुङ। येरमीया ७:२३; २कोरिन्‍थी ६:१६ ");
INSERT INTO suzBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मिनु गो इन दातेमी बाक्‍शा, गो परमप्रभु दुम्‍नुङ। मिनु गेपुकी आं मुर बाक्‍नीनी। गो परमप्रभु यावे, इन परमप्रभु बाक्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","गो परमप्रभु यावे, इन परमप्रभु नङ। गेपुकी इन कली इजीप्‍ती आन वाइलीम वाइल मदुम्‍पाइक्‍थु, एक चाक्‍तन्‍नी। गो इन शुर ङा जवा जिक्‍शा, इन पिया पोक्‍शा गाक्‍ब सेल्‍तन्‍नी। इजीकीएल ३४:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","तन्‍न गेपुकीमी आं लोव़ मटीतीनी नु आं अरेशो मपाइतीनी, ");
INSERT INTO suzBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","नु आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ मकोव़तीनी, आं अरेशो मपाइतीनी नु आं कबल प्रोंइतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","गो इन कली मार पाइनुङ देंशा हना, गो इन दातेमी शुश हिंतीके सेल्‍नुङ। मिनु इन रां सोव़ना सोव़न बाक्‍नीम। मिनु जरो पा इन मिक्‍च ततीके जाम्‍ना जाम्‍न लाइब। मिनु गे ओंखां पा बेक्‍नीनी। इन शोक्‍शो अन्‍न मोशा दुम्‍नीम। मारदे हना इन जोरी सत्रुम नेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","गो इन कली मरिम्‍शो पाइक्‍नुङ। गे इन जोरी सत्रु रे ब्रुइनीनी। इन जोरी सत्रु इन कली हुकुम पाइब दुम्‍नीम। मिनु सुइमी इन कली खेदा मपाम्‍तेक्‍म हना यो, गेपुकी प्रोक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","मेको नेल्‍ल तुइश्‍शा यो, आं कली मटीतीनी हना, गो इन पाप ७ खेयप तेम्‍शा सजाइ गेनन्‍नी। ");
INSERT INTO suzBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","गो इन ठेयब लेश्‍शो खतम सेल्‍नुङ। मिनु गो इन सरीङ फलाम खोदेंशो नु इन रू तांबा खोदेंशो सेल्‍नुङ। ब्‍यवस्‍था ११:११:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","मिनु इन सक्ति मोशा दुम्‍शा मारेइ पने मचाप्‍नीनी। इन रूम मारेइ मवाब। मिनु इन रागी ङा रवापुकीम फल मसित्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","गेपुकी दूली लांम गाक्‍स ङा गाक्‍स पा, आं कली मटीतीनी हना, गो इन पाप ७ खेयप तेम्‍शा इन कली श्‍येत गेनन्‍नी ");
INSERT INTO suzBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","गो इन दातेमी ब्‍वाकी ङा जन्‍तुपुकी सोइक्‍नुङमी। मेकोमी इन आल आन कली ब्‍वाइनीम। मिनु इन बस्‍तु भाव साइक्‍नीम। मिनु गे का निक्‍शी ला दुम्‍तीके इन लां नेल्‍ल श्‍येत्‍थ दुम्‍नीम। इजीकीएल ५:१७ ");
INSERT INTO suzBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","मोपा सजाइ तशा यो, गेपुकी आं गे मलेत्‍तीनी हना, नु दूली लां गाक्‍स ङा गाक्‍स पाइतीनी हना, २सामुएल २२:२७ ");
INSERT INTO suzBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","गो इन कली यो मरिम्‍शो पस ङा पस पाइनुङ। मिनु गो इन पाप ७ खेयप तेम्‍शा, इन कली श्‍येत गेनुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","गो इन कली लडाइ तोपाइक्‍नुङ। मिनु आं कबल प्रोंइशो आ पर्बम क्‍येक्‍क लेत्‍नुङ। गेपुकी आंम आंमा सहरम बुक्‍तीनी हना, गो मेकेर यो इन दातेम बेक्‍पाइक्‍ब रोइ सोइक्‍नुङ। मिनु इन जोरी सत्रु आन गुइम दुम्‍नीनी। यसैया १:२०,२४ ");
INSERT INTO suzBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","मिनु गो इन अन्‍न थमा पा साम्‍पाइक्‍नुङ। १० ओटा खिं ङा मीश मुरुमी चुप्‍लु कामी क्‍येनीम। क्‍येशा पुक्‍शा तेम्‍मेनु, सुइ मरू‍नीम। यसैया ३:१; इजीकीएल ४:१६ ");
INSERT INTO suzBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","मिनु मेको मो दुम्‍शा यो, गे आं कली मटिथु, दूली लां गाक्‍स ङा गाक्‍स पाइतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","गो इन कली मरिम्‍शो पस ङा पस ग्रुम्‍नुङ। मिनु इन पाप ७ खेयप तेम्‍शा, सजाइ गेनन्‍नी। ब्‍यवस्‍था २८:५३; येरमीया १९:९ ");
INSERT INTO suzBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","गेपुकीमी इन तमी तौ आन श्‍ये ब्‍वचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","गो इन डांडा ङा पूजा पतीक थामपुकी प्रेत्‍नुङ। इन धूप चोतीक नेल्‍ल प्रेत्‍नुङ। मिनु इन बेक्‍शो रां मेको ब्रोल्‍शो मूर्ति आन तार ताइक्‍नुङ। मिनु गो इन कली तशा ग्रांग्रा दिशा तिल्‍नुङ। इजीकीएल ६:४,६ ");
INSERT INTO suzBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","गो इन सहर गोरशो रागी खोदेंशो सेल्‍नुङ। मिनु इन पूजा पतीके थान श्‍येत्‍थ सेल्‍नुङ। गो इन ब्रोव़शो धूप आन रिना मनाम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मिनु गो रागी कली खतम पोक्‍नुङ। मिनु मेकेर जाक्‍शा बाक्‍ब इन जोरी सत्रुमी मेको तशा छक लाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","गो इन कली रागी रागी ङा मुर आन दातेमी ब्रपाइक्‍नुङ। मिनु लडाइ तोपाइश्‍शा, इन कली खेदा पपाइक्‍नुङ। मिनु इन रागी श्‍येत्‍थ नु इन सहरपुकी गोरशो सेल्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","मिनु रागी श्‍येत्‍थ दुम्‍मेनु, मेको आ नाइक्‍तीक बर्स ग्‍येरशा मानेब। मिनु गेपुकी इन जोरी सत्रु आन रागीम बाक्‍नीनु, इन रागी चहिं ग्‍येरशा नांइसीब। लेवी २५:२; २इतिहास २६:२१ ");
INSERT INTO suzBl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","मेको रागी गिश नाक्‍त सम्‍म श्‍येत्‍थ लीबा, मिश नाक्‍त नाइक्‍चा ताइब। गेपुकी मेक बाक्‍नीनु, नाइक्‍तीक बर्स नाइक्‍चा मतशो, नाइक्‍तीक बर्स मानेशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","मिनु गो इन जोरी सत्रु आन रागीम बाक्‍शो लीशो मुर आन थुं लुक्‍च लपाइक्‍नुङ। मिनु सफा दोक्‍शो रेयके नेंशा यो, आन जोरी सत्रुम खेदा पशो खोदेंशो पा प्रोक्‍नीम। मिनु मोशा दाइल पा थित्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","सुइमी खेदा मपथु यो, मेकोपुकी तरवार तशा प्रोक्‍शो खोदेंशो पा, प्रोक्‍नीम। मिनु थोक्‍मुशा गोल्‍नीम। मोपतीके आन जोरी सत्रु आन ङोंइती राप्‍ने मचाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","गेपुकी अर्को रागी ङा मुर आन दातेमी जाम्‍शा लाइनीनी। मिनु इन जोरी सत्रु आन रागीमी इन कली दाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","मिनु लीशोपुकी चहिं जोरी सत्रु आन रागीमी आन पाप नु आन किकी पिपी आन पाप पतीके बेक्‍ना बेक्‍न लाइनीम। इजीकीएल २४:२३; इजीकीएल ३३:१० ");
INSERT INTO suzBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","तन्‍न मेकोपुकीमी आंम पाप नु आन किकी पिपी आन पाप आ पर्बम ‘मरिम्‍शो पाइतक नु दूली लां गाक्‍स ङा गाक्‍स पाइतक’ देंतेक्‍म हना, ब्‍यवस्‍था ४:३० ");
INSERT INTO suzBl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","मिनु गो मेको आन कली मरिम्‍शो पस ङा पस बाक्‍शा, आन जोरी सत्रु आन रागीम सोइक्‍ताक्‍ङमी। मिनु मेको आन खकटा थुं ब्रेम्‍शो दुम्‍शा, आन पाप आ पर्बम पाप क्‍याम्‍तीक गेय पाम्‍तेक्‍म हना, ब्‍यवस्‍था १०:१६; येरमीया ९:२५ ");
INSERT INTO suzBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","गो याकूब, इसहाक नु अब्राहाम नु पशो आं कबल नु मेको रागी कली मिम्‍नुङ। प्रस्‍थान २:२४; २राजा १३:२३ ");
INSERT INTO suzBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","मारदे हना मेको रागी श्‍येत्‍थ दुम्‍शा, आ नाइक्‍तीक बर्सपुकी मुर मबाक्‍तीके मानेना मानेन बाक्‍ब। मिनु मेकोपुकीमी आन मरिम्‍शो पशो आ पर्बम सजाइ ताइनीम। मारदे हना मेकोपुकीमी आं पावो, दे अरेतीक लोव़ नु आं फुल्‍लुम मुशा ब्रेक्‍शो लोव़ काइ मपाम। ");
INSERT INTO suzBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","मिनु मोदेंशो पाम्‍तेक्‍म हना यो, गो मेको आन कली आन जोरी सत्रु आन रागीमी कोव़शा, ग्रांग्रा दिशा खतम मसेल्‍नुङमी। मिनु मेकोपुकी नु पशो आं कबल मप्रोंइनुङ। मारदे हना गो परमप्रभु यावे, मेको आन परमप्रभु नङ। होसे ११:९ ");
INSERT INTO suzBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","तन्‍न गो मेको आन कली मिम्‍शा, आन किकी पिपी नु पशो आं कबल मिम्‍नुङ। गो नेल्‍ल रागी ङा मुरपुकीम तचा ङा पा मेको आन परमप्रभु दुम्‍तीके, मेको आन कली इजीप्‍त रागी रे ग्रुंइशा चाक्‍ताक्‍मी। गो परमप्रभु यावे नङ” दे परमप्रभु यावेमी देंत। उत्‍पत्ती १२:७ ");
INSERT INTO suzBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","एको परमप्रभु यावेमी सीनै डांडाम मोसा कली गेशो आं नु इस्राएली आन दातेमी फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु “पावो” दे अरेशो लोव़ बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“गे इस्राएली आन कली ‘सुइमी परमप्रभु यावे कली मुर आ पा ङा क्‍येट गेनुङ’ दे कसम जाप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","मेकोमी २० बर्स रे ६० बर्स सम्‍म ङा वोंइश मुर आन पर्बम आं ताम्‍बु ङा चांदी के ५० शेकेल परमप्रभु यावे कली गेचा माल्‍नीम। शेकेल इस्राएली आन क्‍येट बाक्‍ब। शेकेल का ११.५ ग्राम चांदी बाक्‍ब। ताम्‍बु ङा शेकेल चहिं १२ ग्राम बाक्‍त।न्‍यायाधीस ११:३१; १सामुएल १:११ ");
INSERT INTO suzBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","मीश मुर आ पर्बम बाक्‍त हना, मेकोम ३० शेकेल गेचा माल्‍ब। ३० शेकेल ३६० ग्राम चांदी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","मिनु ५ बर्स रे २० बर्स सम्‍म ङा वोंइश आल आन पर्बम २० शेकेल गेचा माल्‍ब। मीश आल बाक्‍त हना, १० शेकेल गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","मिनु महिना का रे ५ बर्स सम्‍म ङा वोंइश आल आन पर्बम चांदी के ५ शेकेल नु मीश आल आन पर्बम चांदी के शेकेल सां गेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","मिनु ६० बर्स क्‍येङा ग्‍येत्‍थ ङा वोंइश मुर आ पर्बम १५ शेकेल नु मीश मुर आ पर्बम १० शेकेल गेचा माल्‍ब। ताम्‍बु ङा शेकेल का १२ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","मिनु मेको मुर प्रुङग दुम्‍शा, गेने मचाप्‍ब बाक्‍त हना, मेको कली चढ़ेब आ ङोंइती चाक्‍चा माल्‍नीम। मिनु चढ़ेबमी मेको कसम जाइब आ चाप्‍शो खोदेंशो पा मेको आ क्‍येट देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","मिनु परमप्रभु यावे कली चढ़ेचा ङा बी ब्‍यफ, क्‍यारश भेडा बाक्‍तेक्‍म हना, मेको मारेइ मदुम्‍शो थम रिम्‍शो नु ग्रांग्रा मदिशो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","मेको आ पा ङा अरु फाइक्‍चा मदुम्‍ब। रिम्‍शो बस्‍तु आ पा ङा मरिम्‍शो नु मरिम्‍शो आ पा ङा रिम्‍शो फाइक्‍चा मदुम्‍ब। चढ़ेचा ङा बस्‍तु फाइक्‍तेक्‍म हना, मेको बस्‍तु निम्‍फा मारेइ मदुम्‍शो थम रिम्‍शो ग्रांग्रा मदिशो बाक्‍चा माल्‍नीस। ");
INSERT INTO suzBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","मिनु परमप्रभु यावे आ ङोंइती चढ़ेचा मदुम्‍शो ग्रांग्रा दिशो बस्‍तु भाव बाक्‍तेक्‍म हना, मेको आन कली चढ़ेब कली कोंइचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","मिनु चढ़ेबम मेको बस्‍तु रिम्‍शो बाक्‍त हना यो, मरिम्‍शो बाक्‍त हना यो, मेको गिश क्‍येट लाइक्‍बा, दे चढ़ेबमी देंचा माल्‍ब। मिनु चढ़ेबमी दोशो देंबा मेको ठीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","मेको मुरुम क्‍येट थाप्‍शा, मेको बस्‍तु कली प्रोंइचा दाक्‍ब हना, चढ़ेब आ देंशो क्‍येङा यो ५ भाग ङा भाग का क्‍येट तेम्‍शा गेचा माल्‍ब। लेवी ५:१६ ");
INSERT INTO suzBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","मिनु सुइ मुरुमी परमप्रभु यावे कली खिं का चढ़ेप्‍तु हना, चढ़ेबमी मेको खिं कोव़शा रिम्‍शो बाक्‍म कों मरिम्‍शो बाक्‍मे ‘ओशो क्‍येट लाइक्‍ब’ देंचा माल्‍ब। मिनु चढ़ेबमी दोशो देंबा मेको ठीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","मिनु मेको मुरुमी क्‍येट थाप्‍शा लेत्‍चा थुं पाप्‍तु हना, चढ़ेबमी देंशो क्‍येङा यो ५ भाग ङा भाग का क्‍येट तेम्‍शा गेचा माल्‍ब। मिनु मेको खिं मेको केन दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","मिनु सुइ मुरुमी तेकोइ आंम रू परमप्रभु यावे कली चढ़ेप्‍तु हना, चढ़ेबमी मेको रूम दोशो वांचेर लाइ‍बा कोव़शा, मेको आ क्‍येट देंचा माल्‍ब। होमेर का क्‍योव़ज वांचेर लाइब रू कली ५० चांदी के शेकेल दुम्‍चा माल्‍ब। होमेर का २२० लिटर रिक्‍ब पुक्‍तीक का बाक्‍ब। ताम्‍बु ङा शेकेल का १२ ग्राम चांदी बाक्‍ब।२सामुएल २४:२४ ");
INSERT INTO suzBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","मेको मुरुमी आ रू कली लेंशा प्रोंइतीक बर्स आ नोले ङा बर्स रे चढ़ेप्‍तु हना, मेको आ क्‍येट चढ़ेबमी देंशो खोदेंशो दुम्‍ब। लेवी २५:८-५५ ");
INSERT INTO suzBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तन्‍न मेकोमी आ रू लेंशा प्रोंइतीक बर्स इच्‍का बर्स नोले चढ़ेप्‍तु हना, लेंशा प्रोंइतीक बर्स जाक्‍चा दोशो लीशो बाक्‍मे, चढ़ेबमी मेको हिक्‍चा माल्‍ब। मिनु आ देंशो क्‍येट रे तोक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","मेको मुरुमी मेको रू लेंशा फेत्‍चा दाक्‍ब हना, चढ़ेबमी देंशो क्‍येट क्‍येङा ५ भाग ङा भाग का क्‍येट तेम्‍शा गेचा माल्‍ब। मिनु मेको रू मेको केन दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","तन्‍न मेकोमी मेको रू मलेप्‍ब हना, मेकोमी मेको रू अर्को मुर कली लेयशो बाक्‍त हना, मेकोमी मेको रू गेनायो लेत्‍चा मताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","मेको रू लेंशा प्रोंइतीक बर्सम प्रोंइशो बाक्‍त हना, मेको परमप्रभु यावे कली जिम्‍मा गेशो रू दुम्‍शा, चढ़ेबमी मेको रूम शोक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","मिनु सुइ मुरुमी आंम के ममाइ, तन्‍न आ ग्‍याप्‍शो रू परमप्रभु यावे कली चढ़ेप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","चढ़ेबमी लेंशा प्रोंइतीक बर्स सम्‍म हिक्‍शा, मेको आ क्‍येट दोशो बाक्‍मे, मोशो गेचा माल्‍ब। मेको नाक्‍तीन परमप्रभु यावे कली गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","मिनु लेंशा प्रोंइतीक बर्सम मेको रू सु रे ग्‍याप्‍शो बाक्‍मे, मेको लेंशा ताइब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","मिनु गिश क्‍येट लाइ‍बा, मेको नेल्‍ल परमप्रभु यावे आ ताम्‍बु ङा चांदी के शेकेलम थाप्‍चा माल्‍ब। शेकेल काम २० गेरा बाक्‍नीम। गेरा का ०.६ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","मिनु बी ब्‍यफ, क्‍यारश भेडा आन ङोंइती जरमेशो ब्‍यफ बाक्‍त हना यो, सांड बाक्‍त हना यो, बोका बाक्‍त हना यो, मेको ङोंइती रे परमप्रभु यावे केन बाक्‍ब। सुइमी परमप्रभु यावे कली गेने मचाप्‍नीमी। प्रस्‍थान १३:२,१२,१३; गन्‍ती १८:१५ ");
INSERT INTO suzBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","मेको ग्रांग्रा दिशो बस्‍तु भाव बाक्‍त हना, आ देंशो क्‍येट क्‍येङा ५ भाग ङा भाग का तेम्‍शा, लेत्‍चा माल्‍ब। तन्‍न मलेत्‍ताक्‍म हना, आ देंशो क्‍येटीम लेयचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","मिनु परमप्रभु यावे कली साइक्‍चा कली जिम्‍मा गेशो मारेइ मारेइ मुर बाक्‍त हना यो, बस्‍तु भाव बाक्‍त हना यो, आंम रू बाक्‍त हना यो, मेको लेयने नु लेन्‍ने मचाप्‍नीम। मेको साइक्‍चा कली जिम्‍मा गेशो मारेइ मारेइ थमा पा परमप्रभु यावे केन बाक्‍नीम। गन्‍ती १८:१४; गन्‍ती २१:२; यहोसु ६:१८,२६; इजीकीएल ४४:२९ ");
INSERT INTO suzBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","मिनु सु मुर साइक्‍चा कली जिम्‍मा गेचा पुंइसीशो बाक्‍बा, मेको कली क्‍येट थाप्‍शा मलेत्‍थु, साइक्‍चा माल्‍ब। यहोसु ६:१७-१८; १सामुएल १५:३-९ ");
INSERT INTO suzBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","मिनु रू नेल्‍ल ङा, अन्‍न कि रवा आ फल फुल १० भाग परमप्रभु यावे केन बाक्‍ब। मेको परमप्रभु यावे केन बाक्‍ब। गन्‍ती १८:२१; ब्‍यवस्‍था १४:२२-२९; नेहेम्‍याह १३:१२ ");
INSERT INTO suzBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","मुरुमी आंमा आ गेशो १० भाग लेत्‍चा दाक्‍ताक्‍व हना, ५ भाग तेम्‍शा, लेन्‍ने चाप्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","नेल्‍ल गोठ ङा बी ब्‍यफ, क्‍यारश भेडा, मारेइ मारेइ गोठलाम हिक्‍तु हना यो, १० ओटा ङा का परमप्रभु यावे केन बाक्‍ब। २इतिहास ३१:६ ");
INSERT INTO suzBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","मेकोमी रिम्‍शो नु मरिम्‍शो तिल्‍शा फाइक्‍चा मदुम्‍ब। मुरुमी मेको बस्‍तु फाइक्‍चा थुं पाप्‍तु हना, निम्‍फा परमप्रभु यावे कली गेचा माल्‍ब। मिनु क्‍येट थाप्‍शा, लेत्‍चा मदुम्‍ब, दे अरेवो” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","मिनु सीनै डांडामी परमप्रभु यावेमी इस्राएली आन कली मोसा रे पा शेंशो लोव़ एको बाक्‍नीम। लेवी ७:३८; लेवी २५:१; २६:४६");
INSERT INTO suzBl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएलीपुकी इजीप्‍त रे जाक्‍मा आ बर्स निक्‍शी, महिना निक्‍शी ङा ङोंइती ङा नाक्‍त परमप्रभु यावेमी सीनै ङा रागीमी बाक्‍शो ग्रुम्‍तीक ताम्‍बुमी मोसा कली लोव़ पाप्‍तु। प्रस्‍थान ४०:१७ ");
INSERT INTO suzBl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","मिनु मेकोमी “गे इस्राएली वोंइश मुर आन थर थर नु आन खिं खिं पा नेल्‍ल आन नें ब्रेक्‍चा माल्‍नेवे। उत्‍पत्ती ३५:२३-३६; प्रस्‍थान ३०:१२ ");
INSERT INTO suzBl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","इस्राएलमी २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब मुर नेल्‍ल आन कली गे नु हारूनमी लडाइ पचा कली खुप्‍शा वोइक्‍चा माल्‍नीसी। ");
INSERT INTO suzBl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","मेको नेल्‍ल आन थर रे मुर का कामी इस कली वारच पचा माल्‍नीम। मेको मुर आन खिं ङा ठेयब मुर बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","मिनु सु सुम इन कली वारच पचा माल्‍नीम देंशा हना, रूबेन आ थर रे शेदेउर आ तौ एली-सुर, ");
INSERT INTO suzBl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","सिमियोन आ थर रे सुरी-शदै आ तौ शेलुमीएल, ");
INSERT INTO suzBl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा आ थर रे अम्‍मीनादाब आ तौ नहशोन, प्रस्‍थान ६:२३ ");
INSERT INTO suzBl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्‍साकार आ थर रे सुआर आ तौ नेथनेल, ");
INSERT INTO suzBl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलून आ थर रे हेलोन आ तौ एलीआब, ");
INSERT INTO suzBl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफ आ तौ एफ्राइम आ थर रे अम्‍मीहुद आ तौ एली-शामा, योसेफ आ तौ मनस्‍से आ थर रे पेदा-सुर आ तौ गमलीएल, १इतिहास ७:२६; उत्‍पत्ती ४८:५ ");
INSERT INTO suzBl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बेन्‍यामीन आ थर रे गिदेओनी आ तौ आबी-दान, ");
INSERT INTO suzBl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान आ थर रे अम्‍मी-शदै आ तौ अही-एजेर, ");
INSERT INTO suzBl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर थर रे ओक्रान आ तौ पगीएल, ");
INSERT INTO suzBl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद आ थर रे दूएल आ तौ एली-आसाफ, ");
INSERT INTO suzBl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नाप्‍ताली आ थर रे एनान आ तौ अहीरा बाक्‍नीम” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","एकोपुकी इस्राएली आन दाते रे योव़शो आन थर ङा ठेयब मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","मोसा नु हारूनमी योव़शो मुर आन कली ब्रेत्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","मिनु मेको निक्‍शीमी महिना निक्‍शी ङा ङोंइती ङा नाक्‍ती इस्राएली नेल्‍ल आन कली पुक्‍ताक्‍स। मिनु मुर नेल्‍लेमी आन थर नु आन खिं देंशा, ब्रेक्‍पाइक्‍तेक्‍म। मिनु २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो आन नें नेल्‍ल ब्रेक्‍पाइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","मिनु परमप्रभु यावेमी अरेशो खोदेंशो पा, मोसामी सीनै ङा गोरशो रागीमी मेको आन कली खुप्‍शा वोइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएल आ ङोंइती जरमेशो तौ रूबेन आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","मिनु मेको लडाइ पचा कली खुप्‍शो रूबेन आ थर ङा मुर ४६ हजार ५ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","सिमियोन आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","मिनु मेको लडाइ पचा कली खुप्‍शो सिमियोन आ थर ङा मुर ५९ हजार सहे सां बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","मिनु मेको लडाइ पचा कली खुप्‍शो गाद आ थर ङा मुर ४५ हजार ६ सहे ५० बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदा आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","मिनु मेको लडाइ पचा कली खुप्‍शो यहूदा आ थर ङा मुर ७४ हजार ६ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्‍साकार आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","मिनु मेको लडाइ पचा कली खुप्‍शो इस्‍साकार आ थर ङा मुर ५४ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलून आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","मिनु मेको लडाइ पचा कली खुप्‍शो जबूलून आ थर ङा मुर ५७ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफ आ तौ एफ्राइम आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","मिनु मेको लडाइ पचा कली खुप्‍शो योसेफ आ तौ एफ्राइम आ थर ङा मुर ४० हजार ५ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","योसेफ आ तौ मनस्‍से आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मिनु मेको लडाइ पचा कली खुप्‍शो योसेफ आ तौ मनस्‍से आ थर ङा मुर ३२ हजार सहे निक्‍शी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बेन्‍यामीन आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","मिनु मेको लडाइ पचा कली खुप्‍शो बेन्‍यामीन आ थर ङा मुर ३५ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","मिनु मेको लडाइ पचा कली खुप्‍शो दान आ थर ङा मुर ६२ हजार ७ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेर आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","मिनु मेको लडाइ पचा कली खुप्‍शो आशेर आ थर ङा मुर ४१ हजार ५ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नाप्‍ताली आ थर ङा आन खिं खिं ङा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर नेल्‍ल आन नें ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","मिनु मेको लडाइ पचा कली खुप्‍शो नाप्‍ताली आ थर ङा मुर ५३ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मिनु मेको मुर नेल्‍ले लडाइ पचा कली खुप्‍ताक्‍म। मोसा, हारून नु मेको आस कली वारच पाइब इस्राएल आ १२ थर ङा ठेयब मुरपुकीमी मेको आन कली लडाइ पचा कली खुप्‍ताक्‍म। उत्‍पत्ती १७:२०; उत्‍पत्ती २५:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","मिनु गिश मुर २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब वोंइश मुर बाक्‍शो बाक्‍तेक्‍म देंशा हना, गन्‍ती २:३२; प्रस्‍थान १२:३७ ");
INSERT INTO suzBl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","मेको नेल्‍ल पा ६ लाख ३ हजार ५ सहे ५० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेवी आ खिं ङा मुरपुकी चहिं अरु आन खोदेंशो पा महिक्‍सम। ");
INSERT INTO suzBl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","मिनु ङोंइती परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवी आ थर ङा मुर आन कली चहिं लडाइ पचा कली मखुप्‍तीमी। मिनु इस्राएली आन कली खोदेंशो पा महिक्‍मी। गन्‍ती २:२३; गन्‍ती ३:१५-३९ ");
INSERT INTO suzBl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","तन्‍न गे लेवी आन कली आं कबल पशो सन्‍दोस वोइश्‍शो ताम्‍बु नु आ मारेइ मारेइ थोव़क कोव़चा कली वोइक्‍मी। मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु नु आ मारेइ मारेइ थोव़क कुरचा माल्‍नीम। मेकोपुकीमी मेको कोव़चा माल्‍नीम। मिनु आन ताम्‍बु ग्रुम्‍तीक ताम्‍बु आ एर ओंथ कीचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","मिनु ग्रुम्‍तीक ताम्‍बु याक्‍तमेनु, लेवीपुकीम मेको प्राक्‍चा माल्‍नीम। मिनु ग्रुम्‍तीक ताम्‍बु कीङमेनु, मेकोपुकीमी सेल्‍चा माल्‍नीम। आन नेक्‍था जाक्‍ब अरु मुर साइक्‍चा पुंइसीनीम। गन्‍ती ३:१०,३८; गन्‍ती १७:५ ");
INSERT INTO suzBl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","अरु इस्राएली आन आन हुल आन दातेमी नु आन छेदर आ ख्रुक्‍तीके ङा बाक्‍तीकेम बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","लेवी आ मुर चहिं परमप्रभु यावे आ कबल पशो सन्‍दोस वोइश्‍शो ताम्‍बु आ एर ओंथ आन ताम्‍बु कीचा माल्‍नीम। इस्राएलीपुकी ग्रुम्‍तीके ताम्‍बु आ नेक्‍था लचा मदुम्‍नीम। मिनु मेको आन पर्बम परमप्रभु यावे मगाइक्‍ब। मिनु लेवीपुकीमी परमप्रभु यावे आ कबल पशो सन्‍दोस वोइश्‍शो ताम्‍बु खाल पचा माल्‍नीम” दे परमप्रभु यावेमी देंत। गन्‍ती १७:११; गन्‍ती १८:५; २सामुएल २४:१; २इतिहास १९:२; यसैया ५७:१७; यसैया ६४:४-६ ");
INSERT INTO suzBl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","मिनु इस्राएलीपुकीमी परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा नेल्‍ल पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएलीपुकीम आन थर ङा छेदर बाक्‍तीकेम आन ताम्‍बु कीचा माल्‍नीम। मेकोपुकी ग्रुम्‍तीक ताम्‍बु क्‍येङा ङोन एर ओंथ बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","पूर्ब, नां दाप्‍तीक गे यहूदा आ हुल आन बाक्‍तीके बाक्‍ब। मेको आन छेदर आ नेक्‍था आन ताम्‍बु कीचा माल्‍नीम। यहूदा आ थर ङा मुर आन ठेयब मुर अम्‍मीनादाब आ तौ नहशोन बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","मेको आन कली खुप्‍शा हिक्‍शोनु ७४ हजार ६ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","मेको आन नेक्‍था इस्‍साकार आ हुल आन बाक्‍तीके बाक्‍ब। इस्‍साकार आ थर ङा मुर आन ठेयब मुर सुआर आ तौ नेथनेल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","मेको आन कली खुप्‍शा हिक्‍शोनु ५४ हजार लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","मिनु नोले जबूलून आ थर ङा मुर आन बाक्‍तीके बाक्‍ब। जबूलून आ थर ङा मुर आन ठेयब मुर हेलोन आ तौ एलीआब बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","मेको आन कली खुप्‍शा हिक्‍शोनु ५७ हजार ४ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदा आ नेक्‍था खुप्‍शा हिक्‍शो मुर आन हुल नेल्‍ल पा लाख का ८६ हजार ४ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। मेको नेल्‍ल मुर आन ङोंइती गाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","मिनु दक्‍खिन गे रूबेन आ हुल आन बाक्‍तीके बाक्‍ब। मेको आन छेदर आ नेक्‍था आन ताम्‍बु कीचा माल्‍नीम। रूबेन आ थर ङा मुर आन ठेयब मुर शेदेउर आ तौ एली-सुर बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","मेको आन कली खुप्‍शा हिक्‍शोनु ४६ हजार ५ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","मेको आन नेक्‍था सिमियोन आ हुल आन बाक्‍तीके बाक्‍ब। सिमियोन आ थर ङा मुर आन ठेयब मुर सुरी-शदै आ तौ शेलुमीएल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","मेको आन कली खुप्‍शा हिक्‍शोनु ५९ हजार सहे सां लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","मिनु नोले गाद आ थर ङा मुर आन बाक्‍तीके बाक्‍ब। गाद आ थर ङा मुर आन ठेयब मुर रूएल आ तौ एली-आसाफ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","मेको आन कली खुप्‍शा हिक्‍शोनु ४५ हजार ६ सहे ५० जना लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रूबेन आ नेक्‍था खुप्‍शा हिक्‍शो मुर आन हुल नेल्‍ल पा लाख का ५२ हजार ४ सहे ५० जना लडाइ पाइब वोंइश मुर बाक्‍नीम। मेकोपुकी यहूदा आ हुल आन नोले गाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","मिनु ग्रुम्‍तीक ताम्‍बु नु लेवी आन बाक्‍तीक ताम्‍बु कुरशा गाक्‍चा माल्‍नीम। दोदेंशो पा आन ताम्‍बु कीशो बाक्‍मे, मोदेंशो पा आन छेदर आ नेक्‍था गाक्‍चा माल्‍नीम। गन्‍ती १०:१७,२१ ");
INSERT INTO suzBl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पच्‍छिम गे एफ्राइम आ हुल आन बाक्‍तीके बाक्‍ब। मेको आन छेदर आ नेक्‍था आन ताम्‍बु कीचा माल्‍नीम। एफ्राइम आ थर ङा मुर आन ठेयब मुर अम्‍मीहुद आ तौ एली-शामा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","मेको आन कली खुप्‍शा हिक्‍शोनु ४० हजार ५ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","मेको आन नेक्‍था मनस्‍से आ हुल आन बाक्‍तीके बाक्‍ब। मनस्‍से आ थर ङा मुर आन ठेयब मुर पेदा-सुर आ तौ गमालीएल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","मेको आन कली खुप्‍शा हिक्‍शोनु ३२ हजार सहे निक्‍शी लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","मिनु नोले बेन्‍यामीन आ थर ङा मुर आन बाक्‍तीके बाक्‍ब। बेन्‍यामीन आ थर ङा मुर आन ठेयब मुर गिदेओनी आ तौ आबी-दान बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","मिनु मेको आन कली खुप्‍शा हिक्‍शोनु ३५ हजार ४ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राइम आ नेक्‍था खुप्‍शा हिक्‍शो मुर आन हुल नेल्‍ल पा लाख का ८ हजार सहे का लडाइ पाइब वोंइश मुर बाक्‍नीम। मेकोपुकी लेवी आन नोले गाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तर गे दान आ हुल आन बाक्‍तीके बाक्‍ब। मेको आन छेदर आ नेक्‍था आन ताम्‍बु कीचा माल्‍नीम। दान आ थर ङा मुर आन ठेयब मुर अम्‍मी-शदै आ तौ अही-एजेर बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","मेको आन कली खुप्‍शा हिक्‍शोनु ६३ हजार ७ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","मेको आन नेक्‍था आशेर आ हुल आन बाक्‍तीके बाक्‍ब। आशेर आ थर ङा मुर आन ठेयब मुर ओक्रान आ तौ पगीएल बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","मेको आन कली खुप्‍शा हिक्‍शोनु ४१ हजार ५ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","मिनु नोले नाप्‍ताली आ थर ङा मुर आन बाक्‍तीके बाक्‍ब। नाप्‍ताली आ थर ङा मुर आन ठेयब मुर एनान आ तौ अहीरा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","मेको आन कली खुप्‍शा हिक्‍शोनु ५३ हजार ४ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दान आ नेक्‍था खुप्‍शा हिक्‍शो मुर आन हुल नेल्‍ल पा लाख का ५७ हजार ६ सहे लडाइ पाइब वोंइश मुर बाक्‍नीम। मेकोपुकी मुर नेल्‍ल आन क्‍येङा नोले गाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","एको इस्राएली आन थर थर ङा लडाइ पने चाप्‍ब खुप्‍शा हिक्‍शो मुर बाक्‍नीम। आन हुल हुल ङा मुर नेल्‍ल पा ६ लाख हजार सां ५ सहे ५० जना लडाइ पाइब वोंइश मुर बाक्‍नीम” देंत गन्‍ती १:४६ ");
INSERT INTO suzBl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","मिनु परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा लेवी आ थर ङा मुर अरु इस्राएलीपुकी खोदेंशो पा मखुप्‍शो महिक्‍शो बाक्‍तेक्‍म। गन्‍ती १:४८-४९ ");
INSERT INTO suzBl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","इस्राएलीपुकीमी परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा पाम्‍तेक्‍म। आन थर ङा बाक्‍तीकेमी आन छेदर आ नेक्‍था बाक्‍शा, आन थर थर पा गाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","परमप्रभु यावेमी मोसा नु सीनै डांडाम लोव़ पची ना मोसा नु हारून आस खिं ङा मुर सु सु बाक्‍तेक्‍म देंशा हना, प्रस्‍थान ६:२३ ");
INSERT INTO suzBl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारून आ तौ आन नें, आ ङोंइती जरमेशो तौ नादाब नु अबीहु, एलाजर नु इथामार बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","मेको नेल्‍ल तेल लुक्‍शो चढ़ेब बाक्‍तेक्‍म। हारूनमी मेको आन कली चढ़ेतीक गेय पचा, दे तेल लुक्‍ताक्‍व। प्रस्‍थान ४०:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","नादाब नु अबीहु सीनै ङा गोरशो रागीम बेक्‍ताक्‍स। मारदे हना, मेको निक्‍शीमी परमप्रभु यावेमी मदुम्‍ब देंशो अर्को मी धूप चोतीकेम कुर पा, परमप्रभु यावे आ ङोंइती चढ़ेम्‍ताक्‍स। मिनु परमप्रभु यावे आ ङोंइती बेक्‍ताक्‍स। मिनु मेको आस के आल मबाक्‍म। मोपतीके आ तौ एलाजर नु इथामार निक्‍शीमी ला आस आफ आ ङोंइती चढ़ेतीक गेय पाम्‍ताक्‍स। लेवी १०:१-२ ");
INSERT INTO suzBl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी आ थर ङा मुर आन कली ब्रेश्‍शा, मेको आन कली चढ़ेब हारून आ ङोंइती राप्‍पाइक्‍मी। मिनु मेकोपुकीमी मेको कली वारच पचा माल्‍नीम। प्रस्‍थान ३२:२९ ");
INSERT INTO suzBl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","मिनु मेकोपुकीमी हारून कली वारच पा इस्राएली नेल्‍ल आन पर्बम ग्रुम्‍तीक ताम्‍बु आ ङोंइती गेय पचा माल्‍नीम। गन्‍ती १८:३; गन्‍ती १६:९ ");
INSERT INTO suzBl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु ङा मारेइ मारेइ कोव़चा माल्‍नीम। मिनु मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु ङा इस्राएली आन पचा माल्‍शो गेय पचा माल्‍नीम। गन्‍ती ४:- ");
INSERT INTO suzBl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","गे मेको लेवी आ मुर आन कली हारून नु आ तौ आन कली गेचा माल्‍नेवे। मेको इस्राएली आन दाते रे योव़शा हारून कली गेशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","मिनु गे हारून नु आ तौ आस कली चढ़ेबम पचा माल्‍शो गेय पपाइक्‍मी। मेकोपुकी ङा लाक्‍शा अर्को सुइ मुरुम मो पाम्‍तेक्‍म हना, मेको आन कली साइक्‍चा माल्‍नीम” देंत। गन्‍ती १:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“गो इस्राएली आन ङोंइती जरमेशो तौ आन पा ङा लेवी आ थर ङा मुर आन कली इस्राएली आन दाते रे योव़तामी। मोपतीके लेवी आ मुर आं केन बाक्‍नीम। गन्‍ती ८:१६; प्रस्‍थान १३:२ ");
INSERT INTO suzBl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ङोंइती जरमेशो नेल्‍ल आं के बाक्‍नीम। इजीप्‍तमी ङोंइती जरमेशो नेल्‍ल सदुमी नाक्‍ती, गो इस्राएली आन ङोंइती जरमेशो आं कली वोंइसाक्‍यी। मिनु गो मुर नु बी ब्‍यफ, क्‍यारश भेडा नेल्‍ल आं कली वोंइसाक्‍यी। मेको आं के बाक्‍नीम। गो परमप्रभु यावे नङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","मिनु परमप्रभु यावेमी सीनै ङा गोरशो रागीमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“गे लेवी आ थर ङा मुर आन कली आन खिं खिं पा हिक्‍मी। महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो वोंइश मुर नेल्‍ल आन कली हिक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","मिनु मोसामी परमप्रभु यावेमी अरेशो खोदेंशो पा मेको आन कली हिक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","मिनु लेवी आ तौ सु सु बाक्‍तेक्‍म देंशा हना, गेरशोन, कोहाथ नु मेरारी बाक्‍तेक्‍म। प्रस्‍थान ६:१६-१९; गन्‍ती २६:५७-६४ ");
INSERT INTO suzBl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेरशोन आ तौ लिब्‍नी नु आ खिं ङा मुर नु शिमेइ नु आ खिं ङा मुर बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कोहाथ आ तौ अम्राम नु आ खिं ङा मुर नु इच्‍हार नु आ खिं ङा मुर, हेब्रोन नु आ खिं ङा मुर नु उज्‍जीएल नु आ खिं ङा मुर बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मेरारी आ तौ माहली नु आ खिं ङा मुर नु मुशी नु आ खिं ङा मुर बाक्‍तेक्‍म। एको लेवी आ थर ङा मुर आन खिं खिं ङा मुर बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेरशोन रे पा लिब्‍नी नु शिमेइ आस खिं खिं ङा मुर दुम्‍तेक्‍म। मेकोन गेरशोन आ खिं खिं ङा मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","मेकोपुकी महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो वोंइश मुर हिक्‍शोनु ७ हजार ५ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेरशोन आ खिं ङा मुर आन बाक्‍तीके ग्रुम्‍तीक ताम्‍बु आ नोले, पच्‍छिम गे दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेरशोनी आन खिं ङा ठेयब मुर, लाएल आ तौ एली-आसाफ बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","गेरशोन आ मुरपुकीमी ग्रुम्‍तीक ताम्‍बु कली सुम्‍तीके, ग्रुम्‍तीक ताम्‍बु आ आगा ओव़तीक ङा फारशो वा, ");
INSERT INTO suzBl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","लाङगा ङा फारशो वा, ताम्‍बु नु चढ़ेतीक आ एर ओंथ ङा लाङगा आ आगा ओव़तीक ङा फारशो वा नु ताम्‍बु ङा डोरीपुकी कोव़चा माल्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कोहाथ रे पा अम्राम आ खिं ङा मुर, इच्‍हार आ खिं ङा मुर, हेब्रोन आ खिं ङा मुर नु उज्‍जीएल आ खिं ङा मुरपुकी दुम्‍तेक्‍म। मेको कोहाथ आ खिं खिं ङा मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","मेकोपुकी महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो वोंइश मुर हिक्‍शोनु ८ हजार ६ सहे बाक्‍तेक्‍म। मिनु मेकोपुकी ग्रुम्‍तीक ताम्‍बु ङा गेय पाइब आन कली वारच पाइब बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कोहाथ आ खिं ङा मुर आन बाक्‍तीके ग्रुम्‍तीक ताम्‍बु आ दक्‍खिन गे दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","कोहाथी आन खिं ङा ठेयब मुर उज्‍जीएल आ तौ, एली-जाफान बाक्‍ब। लेवी १०:४ ");
INSERT INTO suzBl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","कोहाथीपुकीमी कबल पशो सन्‍दोस, शोब्‍ले वोइक्‍तीक टेबल, बत्ती दातीके, चढ़ेतीक निक्‍शी नु चढ़ेब आन माल्‍शो मारेइ मारेइ नु नेल्‍ल क्‍येङा चोव़खो कोठा ङा फारशो वा कोव़चा माल्‍बाक्‍तेक्‍म। गन्‍ती ७:९ ");
INSERT INTO suzBl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","मिनु चढ़ेब हारून आ तौ एलाजर चहिं लेवी आन थर ङा ठेयब मुर आन नेल्‍ल क्‍येङा ठेयब मुर बाक्‍त। मिनु मेको ग्रुम्‍तीक ताम्‍बु ङा गेय पाइब नेल्‍ल आन कली कोव़ब मुर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मेरारी रे पा माहली आ खिं ङा मुर नु मुशी आ खिं ङा मुर बाक्‍तेक्‍म। एको मेरारी आ खिं खिं ङा मुर बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","मेकोपुकी महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो वोंइश मुर नेल्‍ल हिक्‍शोनु ६ हजार सहे निक्‍शी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मेरारी आ खिं ङा ठेयब मुर अबीहेल आ तौ सुरीएल बाक्‍ब। मेरारी आ खिं ङा मुर आन बाक्‍तीके ग्रुम्‍तीक ताम्‍बु आ उत्तर गे दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मेरारी आ तौपुकीमी ग्रुम्‍तीक ताम्‍बु ङा फलेकपुकी, थामपुकी नु आन राप्‍पाइक्‍तीकपुकी नु आन मारेइ मारेइ कोव़चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","मेकोपुकीमी लाङगा एर ओंथ ङा थामपुकी नु आन राप्‍पाइक्‍तीकपुकी, किलापुकी नु डोरीपुकी कोव़चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोसा, हारून नु आस तौ आन बाक्‍तीके ग्रुम्‍तीक ताम्‍बु आ ङोंइती पूर्ब गे, नां दाप्‍तीके गे दुम्‍चा माल्‍बाक्‍त। मेकोपुकीमी ग्रुम्‍तीक ताम्‍बुम इस्राएली आन पर्बम मार मार पचा माल्‍शो बाक्‍मे, मेको पचा माल्‍बाक्‍तेक्‍म। मेकोपुकी ङा लाक्‍शा अर्को सुइ मुरुम मो पाम्‍तेक्‍म हना, मेको आन कली साइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","मोसा नु हारूनमी परमप्रभु यावे आ देंशो खोदेंशो पा हिक्‍शो लेवी आ थर ङा खिं खिं ङा मुर महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो नेल्‍ल २२ हजार जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","मिनु परमप्रभु यावेमी मोसा कली “महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो इस्राएली आन ङोंइती जरमेशो तौ नेल्‍ल आन कली हिक्‍शा आन नें ब्रेक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","मिनु गे इस्राएली आन ङोंइती जरमेशो तौ आन पा ङा लेवी आ मुर आन कली आं के सेल्‍मी। मोपा इस्राएली आन ङोंइती जरमेशो बी ब्‍यफ क्‍यारश भेडा आन पा ङा लेवी आन बी ब्‍यफ क्‍यारश भेडा आं के सेल्‍मी। गो परमप्रभु यावे नङ” देंत। गन्‍ती १८:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","मिनु मोसामी परमप्रभु यावेमी अरेशो खोदेंशो पा इस्राएली आन ङोंइती जरमेशो तौ आन कली हिक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","मिनु मेकोपुकी महिना का गाप्‍शो नु मेको क्‍येङा लाक्‍शो ङोंइती जरमेशो आन नें ब्रेक्‍शा, हिक्‍शोनु नेल्‍ल २२ हजार सहे निक्‍शी ७३ जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएली आन ङोंइती जरमेशो तौ आन पा ङा लेवी आ मुर आं के सेल्‍मी। मिनु मेको आन बी ब्‍यफ, क्‍यारश भेडा आन पा ङा लेवी आ मुर आन बी ब्‍यफ, क्‍यारश भेडा आं के सेल्‍मी। लेवी आ मुर आं के बाक्‍नीम। गो परमप्रभु यावे नङ। ");
INSERT INTO suzBl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","मिनु लेवी आन क्‍येङा शुश दुम्‍शो इस्राएली आन ङोंइती जरमेशो तौ सहे निक्‍शी ७३ जना बाक्‍तेक्‍म। मेको आन कली प्रोंइचा माल्‍बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","मेको आन कली प्रोंइचा कली का के ५ शेकेल ताक्‍को। ग्रुम्‍तीक ताम्‍बु ङा शेकेल का २० गेराह ङा बाक्‍ब। गेराह का ०.६ ग्राम बाक्‍ब। ग्रुम्‍तीके ताम्‍बु ङा शेकेल १२ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","मिनु गे इस्राएली आन कली प्रोंइचा कली गेशो शेकेल हारून नु आ तौ आन कली गेचा माल्‍नेवे” देंत। शेकेल इस्राएली आन क्‍येट बाक्‍ब। बजार ङा शेकेल ११.५ ग्राम बाक्‍ब। ताम्‍बु कली गेतीक शेकेल चहिं १२ ग्राम बाक्‍ब। मेको सुन के नु चांदी के शेकेल बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","मिनु मोसामी लेवी आन क्‍येङा शुश दुम्‍शो, प्रोंइचा माल्‍शो मुर रे प्रोंइतीक क्‍येट ताक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","मिनु मेकोमी इस्राएली आन ङोंइती जरमेशो तौ रे प्रोंइतीक क्‍येट ताक्‍शा, मेको हजार का सहे सां ६५ ताम्‍बु ङा शेकेल बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मिनु मोसामी परमप्रभु यावेमी अरेशो खोदेंशो पा, मेको प्रोंइतीक क्‍येट हारून नु आ तौ आन कली गेम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवी आ मुर आन दाते ङा कोहाथी आन कली आन खिं खिं ङा मुर पा हिक्‍कीस। ");
INSERT INTO suzBl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","गे ३० बर्स रे ५० बर्स सम्‍म ङा वोंइश मुर आन कली हिक्‍कीस। मेकोपुकी ला ग्रुम्‍तीक ताम्‍बु ङा गेय पने चाप्‍नीम। गन्‍ती ८:२४-२५; १इतिहास २३:२४ ");
INSERT INTO suzBl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","मेको कोहाथी आन पचा माल्‍शो गेय ग्रुम्‍तीक ताम्‍बु ङा नेल्‍ल क्‍येङा चोव़खो थोव़क नु बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","मिनु ग्रुम्‍तीक ताम्‍बु याक्‍तमेनु, हारून नु आ तौ ग्रुम्‍तीक ताम्‍बु ओव़शा, फारशो वा शोल्‍शा, मेको वामी कबल पशो सन्‍दोस सुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","मिनु नोले मेकोपुकीमी मेको आ तार रिम्‍शो कोक्‍तेमी सुम्‍चा माल्‍नीम। मेको आ तारी नीलो रङ ङा वामी सुम्‍चा माल्‍नीम। मिनु मेको आ कुरतीक कोक्‍के शुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","मिनु मेकोपुकीमी कोंइतीक शोब्‍ले वोइक्‍तीक टेबल तार नीलो वा का ब्रशा, मेको आ तारी थालपुकी, थनौरोपुकी, बोसपुकी नु तूचा थोव़क चढ़ेचा कली कचौरा वोइक्‍चा माल्‍नीम। मिनु नाक्‍त किंत किंत ङा कोंइतीक शोब्‍ले यो मेको तार बाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","मिनु नोले मेको आ तार लल रङ ङा वा ब्रशा, मेको आ तार रिम्‍शो कोक्‍तेम सुम्‍चा माल्‍नीम। मिनु मेको आ कुरतीक कोक्‍के शुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","मेकोपुकीमी बत्ती दातीके नीलो वाम सुम्‍चा माल्‍नीम। मेको आ बत्ती, आ थनारो, आ थाल नु तेल वोइक्‍तीके नेल्‍ल सुम्‍चा माल्‍नीम। प्रस्‍थान २५:३१ ");
INSERT INTO suzBl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","मिनु मेको नेल्‍ल कली रिम्‍शो कोक्‍तेमी वोइश्‍शा, कुरतीक तारी वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","मेकोपुकीमी सुन के चढ़ेतीक तारी नीलो वा ब्रशा, रिम्‍शो कोक्‍तेम सुम्‍चा माल्‍नीम। मिनु मेको आ कुरतीक कोक्‍के शुइक्‍चा माल्‍नीम। प्रस्‍थान ४०:२६-२७ ");
INSERT INTO suzBl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","मिनु ग्रुम्‍तीक ताम्‍बुम माल्‍शो मारेइ मारेइ खुप्‍शा, नीलो वाम कुम्‍लो पचा माल्‍नीम। मिनु मेको कली रिम्‍शो कोक्‍तेम सुम्‍चा माल्‍नीम। मिनु कुरतीक तारी वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","मेकोपुकीमी चढ़ेतीक रे पुलु शोल्‍शा, मेको आ तार प्‍याजी रङ ङा वा ब्रचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","मिनु मेकोपुकीमी चढ़ेतीकेम माल्‍शो मारेइ मारेइ थोव़की मेको आ तारी वोइक्‍चा माल्‍नीम। मी वोइक्‍तीके, श्‍ये ग्रुंइतीके, बेल्‍चापुकी, ब्‍वाक्‍कु वोइक्‍तीक ग्‍योंबपुकी नु चढ़ेतीक ङा मारेइ मारेइ वोइश्‍शा, मेको तार रिम्‍शो कोक्‍तेम सुम्‍चा माल्‍नीम। मेको आ कुरतीक कोक्‍के शुइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","मिनु हारून नु आ तौपुकीमी मेको ग्रुम्‍तीक ताम्‍बु ङा मारेइ मारेइ सुम्‍ने थुम्‍मे नोले कोहाथीपुकी मेको कुरथ जाक्‍चा माल्‍नीम। तन्‍न मेकोपुकीमी परमप्रभु यावे आ मार मार थोव़क थिचा मदुम्‍नीम। मेकोपुकीम थिम्‍तेक्‍म हना, बेक्‍नीम। कोहाथीपुकीमी ग्रुम्‍तीक ताम्‍बु ङा कुरचा माल्‍शो थोव़क मेकोन बाक्‍नीम। गन्‍ती ७:९; २सामुएल ६:६-७ ");
INSERT INTO suzBl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","चढ़ेब हारून आ तौ एलाजर बत्ती दाशो तेल, ब्रोव़शो रिना पाइक्‍ब धूप, नाक्‍त किंत किंत ङा चढ़ेतीक अन्‍न नु लुक्‍तीक तेल कली कोव़ब बाक्‍ब। मेको ग्रुम्‍तीक ताम्‍बु नु मेकेर ङा मारेइ मारेइ कोव़ब बाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","मिनु नोले परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“गे लेवी आन दाते ङा कोहाथी आन खिं खिं ङा मुर आन कली खतम दुम्‍चा मगेस। ");
INSERT INTO suzBl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","गे, कोहाथी मबेक्‍थु, ब्रोंइमल दे नेल्‍ल क्‍येङा चोव़खो थोव़क आ नेक्‍था जाक्‍मानु, मार पचा माल्‍नीनी देंशा हना, हारून नु आ तौपुकी आगा ओव़शा, मेको आन कली आन आन गेय नु मार मार कुरचा माल्‍नीनी, मेको योक्‍शा गेचा माल्‍नीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","तन्‍न कोहाथीपुकीम मेको नेल्‍ल क्‍येङा चोव़खो थोव़क आन कली कोव़चा मदुम्‍ब। कोव़तेक्‍म हना, बेक्‍नीम” देंत। १सामुएल ६:१९ ");
INSERT INTO suzBl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेरशोनी आन कली यो आन खिं खिं पा हिक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","गे ३० बर्स रे ५० बर्स सम्‍म ङा वोंइश मुर आन कली हिक्‍को। मेकोपुकी ला ग्रुम्‍तीक ताम्‍बु ङा गेय पने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","मिनु गेरशोन आ मुर आन पतीके मार बाक्‍त देंशा हना, गेय पचा नु मार मार कुरचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ग्रुम्‍तीक ताम्‍बु ङा फारशो वा, ग्रुम्‍तीक ताम्‍बु आ सुम्‍तीके नु मेको तार बाक्‍शो रिम्‍शो कोक्‍ते नु ग्रुम्‍तीक ताम्‍बु आ ओव़तीक ङा फारशो वा कुरचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","मिनु लाङगा ङा एर ओंथ फारशो वा, ओव़तीक ङा फारशो वा, ग्रुम्‍तीक ताम्‍बु नु चढ़ेतीक आ एर ओंथ ङा वा नु आ डोरी नु मेको आ गेय कली माल्‍शो नेल्‍ल पचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेरशोन आ मुरपुकीमी हारून नु आ तौपुकीमी अरेशो खोदेंशो पा ला आन कुरतीक नु अरु गेय पने चाप्‍नीम। हारून नु आ तौपुकीमी मेको आन कुरचा माल्‍शो नु पतीक गेय नेल्‍ल अरेचा माल्‍नीम। प्रस्‍थान ३८:२१ ");
INSERT INTO suzBl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","मिनु गेरशोनीमी ग्रुम्‍तीक ताम्‍बुम पचा माल्‍शो गेय एकोन बाक्‍ब। मिनु हारून आ तौ इथामार मेको आन कली अरेब बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","गे मेरारी आ मुर आन कली आन खिं खिं ङा मुर पा हिक्‍शा, ब्रेक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","गे ३० बर्स रे ५० बर्स सम्‍म ङा वोंइश मुर आन कली हिक्‍को। मेकोपुकी ला ग्रुम्‍तीक ताम्‍बु ङा गेय पने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","मिनु मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु ङा मार कुरचा माल्‍नीम देंशा हना, ग्रुम्‍तीक ताम्‍बु ङा फलेकपुकी, मेको आन ग्‍याइक्‍तीक कोक्‍केपुकी, थामपुकी नु राप्‍पाइक्‍तीकपुकी कुरचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","मिनु लाङगा ङा थाम नेल्‍ले, आन राप्‍पाइक्‍तीकपुकी, किलापुकी, डोरीपुकी नु मार मार अरु बाक्‍मा मेको कोव़चा नु कुरचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मेको मेरारी आ मुरपुकीम आन ग्रुम्‍तीक ताम्‍बु कली पचा माल्‍शो गेय बाक्‍ब। मिनु चढ़ेब हारून आ तौ इथामार मेको आन कली अरेब बाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोसा, हारून नु थर थर ङा मुर आन ठेयब मुरपुकीमी कोहाथी आन खिं खिं ङा मुर आन कली हिक्‍शा ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","मिनु ३० बर्स रे ५० बर्स सम्‍म ङा मुर ला ग्रुम्‍तीक ताम्‍बुमी गेय पने चाप्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","मिनु मेको आन खिं खिं ङा मुर हिक्‍शोनु, हजार निक्‍शी ७ सहे ५० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","मेको ग्रुम्‍तीक ताम्‍बु ङा गेय पाइब कोहाथीपुकी बाक्‍नीम। मिनु मोसा नु हारूनमी परमप्रभु यावेमी अरेशो खोदेंशो पा मेको आन कली हिक्‍शा ब्रेक्‍शो बाक्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","मिनु गेरशोनी आन खिं खिं ङा मुर आन कली हिक्‍शा ब्रेक्‍ताक्म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","मिनु ३० बर्स रे ५० बर्स सम्‍म ङा मुर ला ग्रुम्‍तीक ताम्‍बुमी गेय पने चाप्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","मिनु मेको आन खिं खिं ङा मुर हिक्‍शोनु, हजार निक्‍शी ६ सहे ३० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","मेको ग्रुम्‍तीक ताम्‍बु ङा गेय पाइब गेरशोनी बाक्‍नीम। मिनु मोसा नु हारूनमी परमप्रभु यावेमी अरेशो खोदेंशो पा मेको आन कली हिक्‍शा ब्रेक्‍‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मिनु मेरारी आ मुर आन खिं खिं ङा मुर आन कली हिक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","मेको ३० बर्स रे ५० बर्स सम्‍म ङा मुर ला ग्रुम्‍तीक ताम्‍बुमी गेय पने चाप्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","मिनु मेको आन खिं खिं ङा मुर हिक्‍शोनु, हजार सां सहे निक्‍शी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","मेको ग्रुम्‍तीक ताम्‍बु ङा गेय पाइब मेरारी आ मुर बाक्‍नीम। मिनु मोसा नु हारूनमी परमप्रभु यावेमी अरेशो खोदेंशो पा मेको आन कली हिक्‍शा ब्रेक्‍‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","मिनु मोसा, हारून नु इस्राएल आ थर ङा मुर आन ठेयब मुरपुकीमी लेवी आ मुर नेल्‍ल आन खिं खिं ङा मुर हिक्‍शा ब्रेक्‍ताक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","मिनु ३० बर्स रे ५० बर्स सम्‍म ङा मुर ला ग्रुम्‍तीक ताम्‍बुमी गेय पने नु मार मार कुरने चाप्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","मिनु मेको आन खिं खिं ङा मुर हिक्‍शोनु ८ हजार ५ सहे ८० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","मिनु परमप्रभु यावेमी अरेशो खोदेंशो पा मोसामी मेको आन कली हिक्‍शा, मार गेय पचा माल्‍नीमी, मार कुरचा माल्‍नीमी, मेको अरेम्‍तीमी। मिनु परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा मेको आन कली हिक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“गे इस्राएली आन कली गेपुकीमी कोव़र खोदेंशो रोइ पाइब, आन रां रे ग्रांग्रा दिशो यिशो नु बेक्‍शो मुर थिशा ग्रांग्रा दुम्‍शो मुर आन कली इन बाक्‍तीक क्‍येङा ङोन वोइक्‍चा माल्‍नीनी। लेवी १३:४६; लेवी १५:२; गन्‍ती ९:६-७ ");
INSERT INTO suzBl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","मोदेंशो वोंइश मुर नु मीश मुर नेल्‍ल आन कली मुर आन बाक्‍तीके क्‍येङा ङोन वोइक्‍चा माल्‍नीनी। मेकोपुकीमी मुर आन बाक्‍तीके ग्रांग्रा दिशो सेल्‍चा मदुम्‍नीम। मारदे हना गो इन दातेमी बाक्‍शो बाक्‍नुङ” देंत। गन्‍ती १२:१४-१५; प्रस्‍थान २५:८ ");
INSERT INTO suzBl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","मिनु इस्राएलीपुकीमी मो पाम्‍तेक्‍म। मोदेंशो मुर आन कली मुर आन बाक्‍तीके क्‍येङा ङोन वोइक्‍तेक्‍म। परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा इस्राएलीपुकीमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“गे इस्राएली आन कली ‘मीश मुर, वोंइश मुर सु बाक्‍त हना यो, परमप्रभु यावे आ ङोंइती पाप पा अरु मुर आन कली मारेइ मरिम्‍शो पाप्‍तु हना, मेको मुर दोस ताइब दुम्‍ब। लेवी ५:२१-२६ ");
INSERT INTO suzBl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","मिनु मेकोमी आ मरिम्‍शो पशो शोव़चा माल्‍ब। मिनु मेको मुरुमी आ खुइ पशो नेल्‍ल लेश्‍शा गेशा, मेको क्‍येङा यो ५ भाग तेम्‍शा गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","तन्‍न मेको खुइ पचा पुंइसीशो मुर बेक्‍शा, मेको के सुइ मबाक्‍तेक्‍म हना, मेको पाप आ पर्बम थाप्‍शो परमप्रभु यावे के दुम्‍शा, चढ़ेब आन के दुम्‍ब। मिनु आ पाप क्‍याम्‍तीक गेय पचा कली सांड का गेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","मिनु इस्राएलीपुकीमी आन परमप्रभु यावे कली गेशो क्‍युक्‍शा चढ़ेतीक नेल्‍ले चढ़ेब कली गेचा माल्‍नीम। मिनु मेको चढ़ेब केन दुम्‍ब। गन्‍ती १८:८ ");
INSERT INTO suzBl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","मिनु मुर नेल्‍ल आन परमप्रभु यावे कली गेशो, मेको केन दुम्‍ब। मार गेम्‍तेक्‍म हना यो, मेको चढ़ेब केन दुम्‍ब’ दे अरेमी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“गे इस्राएली आन कली ‘सुइ आन मीश हेंथे गाक्‍शा, आ वोंइश कली मरिम्‍शो पाप्‍तु हना, ");
INSERT INTO suzBl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","अरु वोंइश मुर नु इप्‍त हना, मेको आ वोंइश रे ख्रुइश्‍शो बाक्‍त हना, मेकोमी सुइम मतुइक्‍थु, ग्रांग्रा दिशो सेल्‍सीशो बाक्‍त हना यो, मेको सुइम थित्‍चा मपुंइसीशो बाक्‍त हना यो, ");
INSERT INTO suzBl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","मेको वोंइश मुरुमी आ ग्रांग्रा दिशो सेल्‍सीशो मीश आ पर्बम रुश पा, आ थुंम मरिम्‍शो मिम्‍शो बाक्‍त हना, मेको आ मीश आंम कली ग्रांग्रा दिशो मसेल्‍सीशो बाक्‍त हना यो, ");
INSERT INTO suzBl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","मेको वोंइश मुरुमी आ मीश कली चढ़ेब आ बाक्‍तीके चाक्‍चा माल्‍ब। मिनु मेको आ मीश आ पर्बम एफाह का ङा १० भाग ङा भाग का क्‍योव़ज फस चाक्‍चा माल्‍ब। मेको आ तारी तेल लुक्‍चा नु धूप वोइक्‍चा मदुम्‍ब। मारदे हना मेको रुश पशो आ पर्बम अन्‍न चढ़ेतीक बाक्‍ब। मेको अन्‍न चढ़ेतीक मरिम्‍शो पशो मिम्‍चा कली बाक्‍ब। एफाह का २२ लिटर ङा पुक्‍तीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","मिनु चढ़ेबमी मेको मीश मुर कली आ नेक्‍था चाक्‍शा, परमप्रभु यावे आ ङोंइती राप्‍पाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","मिनु चढ़ेबमी खप के ग्‍योंबुम नक ब्‍वाक्‍कु चाक्‍चा माल्‍ब। मिनु मेकोमी ग्रुम्‍तीक ताम्‍बु ङा खप ङा फुरक इच्‍का हुइश्‍शा, मेको ब्‍वाक्‍कुम कुर पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","मिनु चढ़ेबमी मेको मीश मुर कली परमप्रभु यावे आ ङोंइती राप्‍पा, मेको आ चां प्रुइक्‍चा माल्‍ब। मिनु मेकोमी मेको मिम्‍चा कली अन्‍न चढ़ेतीक आ गुइमी वोइक्‍चा माल्‍ब। मेको रुश पशो आ पर्बम अन्‍न चढ़ेतीक बाक्‍ब। मिनु मेको चढ़ेबमी मेको सराप चीले रशो कशो ब्‍वाक्‍कु आ गुइमी ग्‍याइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","मिनु चढ़ेबमी मेको मीश मुर कली कसम जपाइश्‍शा “थमा पा गे सुइ वोंइश मुर नु मइप्‍शो बाक्‍ते हना, इ वोंइश नु बाक्‍शा, हेंथे मगाक्‍थु, इ कली ग्रांग्रा दिशो मसेल्‍सीशो बाक्‍ते हना, एको कशो ब्‍वाक्‍कु तूङीनु, गे सराप चीले मराइनेवे। ");
INSERT INTO suzBl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","तन्‍न गे इ वोंइश नु बाक्‍शा यो, हेंथे गाक्‍शा, ग्रांग्रा दिशो सेल्‍सीशो बाक्‍ते हना, गे अरु वोंइश मुर नु इप्‍शो बाक्‍ते” हना, देंशा, ");
INSERT INTO suzBl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","चढ़ेबमी मेको मीश मुर कली सराप चीले रतीक कसम जपाइक्‍चा माल्‍ब। मिनु मेकोमी मीश मुर कली “परमप्रभु यावेमी इ कोव़ज होम्‍पाइक्‍तीक नु देल्‍लो सोव़पाइक्‍तीक रोइ पपाइश्‍शो तशा, गे इ मुर आन दातेमी हिंचा ङा कोंइतीक दुम्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","एको सराप चीले रतीक ब्‍वाक्‍कु इ कोव़जम ओव़शा इ कोव़ज होम्‍तीक नु इ देल्‍लो सोव़तीक रोइ पपाइक्‍ब” देंचा माल्‍ब। मिनु मेको मीश मुरुमी “आमेन, मोदेंशोन दुम्‍ल” देंचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","मिनु नोले चढ़ेबमी मेको सराप चीले कागजम ब्रेक्‍शा मेको कशो ब्‍वाक्‍कुम मेको कागज कली मुरचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","मिनु नोले मेकोमी मेको मीश मुर कली मेको सराप चीले बाक्‍शो कशो ब्‍वाक्‍कु तूपाइक्‍चा माल्‍ब। मिनु मेको सराप चीले बाक्‍शो ब्‍वाक्‍कु मेको मीश मुर आ कोव़जम ओव़शा मेको कली शुश खाइक्‍पाइक्‍ब। भजन संग्रह १०९:१८ ");
INSERT INTO suzBl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","मिनु चढ़ेबमी मेको रुश पतीक आ पर्बम चढ़ेशो अन्‍न मेको मीश मुर आ गुइ रे लाइश्‍शा, परमप्रभु यावे आ ङोंइती क्‍युक्‍शा, चढ़ेतीकेम चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","मिनु चढ़ेबमी मेको अन्‍न चढ़ेतीक रे मिम्‍चा कली योल का हुइश्‍शा चढ़ेतीकेमी चोचा माल्‍ब। मिनु नोले मेको कली मेको ब्‍वाक्‍कु तूपाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","मिनु मेकोमी मेको मीश मुर कली मेको ब्‍वाक्‍कु तूपदानु, मेको ग्रांग्रा दिशो दुम्‍शो बाक्‍त हना, नु आ वोंइश कली मरिम्‍शो पशो बाक्‍त हना, मेको सराप चीले बाक्‍शो कशो ब्‍वाक्‍कु मेको आ आगा ओव़शा, शुश खाइक्‍पाइक्‍ब। मेको आ कोव़ज होम्‍ब। मिनु मेको आ देल्‍लो सोव़ब। मिनु मेको मीश मुर आ मुर आन दातेमी हिंचा ङा कोंइतीक दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","तन्‍न मेको मीश मुरुम आंम कली ग्रांग्रा दिशो मसेल्‍सीशो नु मरिम्‍शो मपशो बाक्‍त हना, मेको ब्‍वाक्‍कु मखाइक्‍‍थु, आल थीब दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","आ वोंइश नु बाक्‍शा यो, हेंथे गाक्‍शा ग्रांग्रा दिशो सेल्‍सीशो मीश मुर आ पर्बम रुश पाइब वोंइश कली अरेशो लोव़ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","मिनु वोंइश मुर रुश पाइब दुम्‍शा, आ मीश आ पर्बम रुश पाप्‍तु हना, मेकोमी आ मीश परमप्रभु यावे आ ङोंइती राप्‍पाइक्‍चा माल्‍ब। मिनु चढ़ेबमी मेको अरेशो लोव़ नेल्‍ले मेको मीश मुर आ पर्बम पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","मिनु मेको वोंइश मुर दोस मताइब दुम्‍ब। मिनु आ मीशेमी चहिं आ मरिम्‍शो पशो राइब’ दे इस्राएली आन कली शेंदो” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“गे इस्राएली आन कली ‘सुइ मीश मुर, वोंइश मुरुमी परमप्रभु यावे कली दिल्‍शा बाक्‍चा, दे नाजिरी कबल पाप्‍तु हना, १सामुएल १:११ ");
INSERT INTO suzBl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","मेकोमी शांबु राकसी तूचा काइ मदुम्‍ब। मेकोम ग्‍युरशो अङगुर शांबु नु अङगुर आ रस तूचा मदुम्‍ब। क्‍येख नु सोव़पाइश्‍शो अङगुर यो ब्‍वचा मदुम्‍ब। आमोस १:११-१२; लूका १:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","गिश नाक्‍त सम्‍म मेको नाजिरी दुम्‍शा दिल्‍शा बाक्‍बा, मिश नाक्‍त सम्‍म मेको अङगुर आ वांचेर रे आ खोश्‍ले सम्‍म यो ब्‍वचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","मेको गिश नाक्‍त सम्‍म नाजिरी दुम्‍शा दिल्‍शा बाक्‍बा, मिश नाक्‍त सम्‍म आ पिया ङा चां प्रेक्‍चा मदुम्‍ब। मेको आ नाजिरी दुम्‍शा दिल्‍शो नाक्‍ती मनुम्‍म सम्‍म मेकोमी परमप्रभु यावे कली ला दिल्‍शो बाक्‍ब। मेकोमी आ चां बारचा गेचा माल्‍ब। न्‍यायाधीस १३:५ ");
INSERT INTO suzBl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","गिश नाक्‍त सम्‍म मेको परमप्रभु यावे आ पर्बम दिल्‍शा बाक्‍बा, मिश नाक्‍त सम्‍म मेको बेक्‍शो मुर आन नेक्‍था लचा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","मेको आ आम आफ, आ लोक्‍बपुकी सु बेक्‍तेक्‍म हना यो, मेको आन पर्बम मेकोमी आंम कली ग्रांग्रा दिशो सेल्‍चा मदुम्‍ब। मारदे हना मेको आ पियाम आ परमप्रभु आ पर्बम दिल्‍शो चिन्‍ड बाक्‍ब। लेवी २१:११ ");
INSERT INTO suzBl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","आ दिल्‍शा बाक्‍शो नाक्‍त नेल्‍ले मेको परमप्रभु यावे कली ला दुम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","मिनु दोक का का पा सुइ मुर मेको आ नेक्‍था बेक्‍शा, आ चां ग्रांग्रा सेल्‍तु हना, ग्रांग्रा मदिशो दुम्चा कली ७ नाक्‍तीम आ चां प्रेक्‍चा माल्‍ब। गन्‍ती १९:११,१४,१६ ");
INSERT INTO suzBl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","मिनु मेकोमी ८ नाक्‍ती परवा हना यो, ढुकुर हना यो निक्‍शी ग्रुम्‍तीक ताम्‍बु ङा ओव़तीक चढ़ेब आ ङोंइती चाक्‍चा माल्‍ब। लेवी ५:७ ");
INSERT INTO suzBl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","मिनु चढ़ेबमी मेको का पाप आ पर्बम चढ़ेतीके नु का चोशा चढ़ेतीके चढ़ेचा माल्‍ब। मिनु मेको मुर आ पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मारदे हना मेको बेक्‍शो मुर आ नेक्‍था बाक्‍शा पाप दुम्‍शा, ग्रांग्रा दिशो दुम्‍शो बाक्‍ब। मिनु मेको नाक्‍त रे मेकोम आ पिया परमप्रभु यावे कली तिल्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","मिनु मेको मुरुमी आ नाजिरी बाक्‍तीक नाक्‍ती नक गोशा परमप्रभु यावे कली दिल्‍चा माल्‍ब। मिनु मेकोमी गारचा आ पर्बम चढ़ेचा कली बर्स का गाप्‍शो सांड का चाक्‍चा माल्‍ब। मेको मुर दिल्‍शा बाक्‍मेनु, ग्रांग्रा दिशो दुम्‍तीके आ ङोंइती ङा नाक्‍त महिक्‍सीब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","मिनु नाजिरी आन कली अरेशो लोव़ मार बाक्‍ब देंशा हना, आंम दिल्‍शा बाक्‍शो नाक्‍त गाक्‍म नोले, मेको मुर आ पतीके मार बाक्‍ब देंशा हना, मेको कली ग्रुम्‍तीक ताम्‍बु आ ओव़तीक आ ङोंइती चाक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","मिनु मेकोमी परमप्रभु यावे कली मारेइ मदुम्‍शो थम रिम्‍शो सांड का चोशा चढ़ेतीक चढ़ेचा माल्‍ब। मिनु मेकोमी बर्स का गाप्‍शो मारेइ मदुम्‍शो थम रिम्‍शो पाठी का पाप आ पर्बम चढ़ेचा माल्‍ब। मिनु मारेइ मदुम्‍शो थम रिम्‍शो बर्स का गाप्‍शो सांड का दुशा बाक्‍चा आ पर्बम चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","मिनु मेकोमी डालो का बोरब ओख्‍ती मसुप्‍शो शोब्‍ले, थम रिम्‍शो तेलम निशो फस के बटुकपुकी नु तेल ख्रेक्‍शो बोरब ओख्‍ती मसुप्‍शो बाबरपुकी चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","मिनु चढ़ेबमी मेको नेल्‍ल परमप्रभु यावे आ ङोंइती वोइक्‍चा माल्‍ब। मिनु मेको पाप आ पर्बम चढ़ेतीके नु चोशा चढ़ेतीके चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","मिनु मेकोमी मेको सांड दुशा बाक्‍चा आ पर्बम परमप्रभु यावे कली चढ़ेचा माल्‍ब। मेको नु डालोम बाक्‍शो बोरब ओख्‍ती मसुप्‍शो शोब्‍ले चढ़ेचा माल्‍ब। मिनु मेको चढ़ेबमी मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीक चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","मिनु नोले मेको नाजिरीमी ग्रुम्‍तीक ताम्‍बु ओव़तीक आ ङोंइती आ तिल्‍शो पिया ङा चां प्रेक्‍चा माल्‍ब। मिनु मेको चां दुशा बाक्‍चा आ पर्बम चढ़ेतीक आ आगाम चोचा माल्‍ब। प्रेरित १८:१८ ");
INSERT INTO suzBl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","मिनु आ पिया प्रेक्‍गा नोले मेको चढ़ेबमी मेको सांड आ लोप्‍शो बला नु डालो ङा बोरब ओख्‍ती मसुप्‍शो बटुक का नु बोरब ओख्‍ती मसुप्‍शो बाबर का मेको नाजिरी आ गुइम वोइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","मिनु चढ़ेबमी मेको कली क्‍युक्‍शा परमप्रभु यावे आ ङोंइती क्‍युक्‍शा चढ़ेतीक चढ़ेचा माल्‍ब। मिनु क्‍युक्‍शा चढ़ेशो, कुथ्रु नु फिला चढ़ेब आ भाग दुम्‍ब। मेको नोले मेको नाजिरीमी अङगुर शांबु तूतु हना दुम्‍ब। प्रस्‍थान २९:२३,२४,२७ ");
INSERT INTO suzBl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","मिनु कसम जशो नाजिरी कली अरेशो लोव़ मार बाक्‍ब देंशा हना, आ परमप्रभु यावे कली चढ़ेशो नाजिरी आ कसम जशो खोदेंशो बाक्‍चा माल्‍ब। आ चाप्‍शो तेम्‍ने चाप्‍ब। आ कसम जशो गारचा माल्‍ब। मिनु आ जिम्‍मा ङा अरेशो लोव़ नेल्‍ल गारचा माल्‍ब’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“गे हारून नु आ तौ आन कली ‘गे इस्राएली आन कली आसीक गेनीनु, मार देंचा माल्‍नीनी देंशा हना, लेवी ९:२२-२३; ब्‍यवस्‍था १०:८ ");
INSERT INTO suzBl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","परमप्रभु यावेमी इन कली आसीक गेवल। इन कली गेना हना यो कोव़ङल। उत्‍पत्ती २४:१,३५; भजन संग्रह १२१:- ");
INSERT INTO suzBl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","परमप्रभु यावे इन कली तशा ग्‍येरसेक्‍ल। मिनु इन कली शिशी पवल। भजन संग्रह ८०:४; प्रस्‍थान ३४:६-७ ");
INSERT INTO suzBl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","परमप्रभु यावेमी इन कली कोव़शा, इन थुं नाइश्‍शा बाक्‍चा गेवल’ देंचा माल्‍नीनी। भजन संग्रह ६९:१७-१८; भजन संग्रह ८५:९; यसैया ५७:१९ ");
INSERT INTO suzBl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","मेकोपुकीमी मोदेंशो लोव़ पा, आं नें इस्राएली आन तार वोइक्‍चा माल्‍नीम। मिनु गो मेको आन कली आसीक गेनुङमी” दे मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","मोसामी ग्रुम्‍तीक ताम्‍बु सेल्‍ने थुम्‍शा, मेको नु आ मारेइ मारेइ आन कली तेल ब्रुइक्‍ताक्मी। मिनु परमप्रभु यावे आ गेय पचा कली वोइक्‍तु। मिनु मेकोमी चढ़ेतीक नु आ मारेइ मारेइ तेल ब्रुइश्‍शा परमप्रभु यावे आ गेय पचा कली वोइक्‍तीमी। प्रस्‍थान ४०:९,१०,१७ ");
INSERT INTO suzBl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","मिनु इस्राएल ङा थर थर नु खिं खिं ङा खुप्‍शा हिक्‍शो मुर आन ठेयब मुरपुकीमी चढ़ेम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","मेकोपुकीमी आन चढ़ेतीके परमप्रभु यावे आ ङोंइती चाक्‍तेक्‍म। मार चाक्‍तेक्‍म देंशा हना, ६ ओटा बग्‍गी, १२ ओटा ब्‍यफ, निक्‍शी थर ङा मुर आन ठेयब मुर आस कली बग्‍गी का बाक्‍त। मिनु ठेयब मुर का का पा ब्‍यफ का का चढ़ेचा कली चाक्‍तेक्‍म। मिनु मेकोपुकीमी ग्रुम्‍तीक ताम्‍बु आ ङोंइती वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","मिनु नोले परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“मेको आन चाक्‍शो ताक्‍को। मिनु मेकोमी ग्रुम्‍तीक ताम्‍बु ङा गेय पने चाप्‍नीम। लेवी आन कली आन आन गेय गारचा ङा पा गेमी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","मिनु मोसामी मेको बग्‍गी नु ब्‍यफपुकी ताक्‍शा, लेवी आन कली गेम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","मिनु मेकोमी बग्‍गी निक्‍शी नु ४ ओटा ब्‍यफ गेरशोन आ तौ आन गेय कोव़शा, मेको आन कली गेम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","मिनु ४ ओटा बग्‍गी नु ८ ओटा ब्‍यफ मेरारी आ मुर आन गेय कोव़शा, मेको आन कली गेम्‍तीमी। चढ़ेब हारून आ तौ इथामार मेको आन कली अरेब बाक्‍त। गन्‍ती ४:२८,३३ ");
INSERT INTO suzBl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","तन्‍न मेकोमी कोहाथी आन कली मारेइ मगेमी। मारदे हना मेकोपुकीमी परमप्रभु यावे आ मार मार थोव़क कोव़चा नु आन बलाम कुरचा माल्‍बाक्‍तेक्‍म। गन्‍ती ४:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","मिनु चढ़ेतीक कली तेल ब्रुइक्‍तीक नु परमप्रभु यावे आ गेय पचा कली वोइक्‍तीक नाक्‍त मेको इस्राएल आ थर ङा मुर आन ठेयब मुरुमी यो चढ़ेचा कली मार मार चाक्‍शा, चढ़ेतीक आ ङोंइती वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","मिनु परमप्रभु यावेमी मोसा कली “मेकोपुकीमी चढ़ेचा कली मार मार चाक्‍चा माल्‍नीम। मेको चढ़ेतीके आं गेय पचा कली वोइक्‍तीक नाक्‍ती इस्राएल आ थर ङा मुर आन ठेयब मुर का कामी नाक्‍त का कली चढ़ेतीक चाक्‍चा माल्‍नीम” देंत। गन्‍ती १:४-१६; गन्‍ती २:३-२९ ");
INSERT INTO suzBl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","मिनु ङोंइती ङा नाक्‍ती यहूदा आ थर ङा मुर आन ठेयब मुर अम्‍मीनादाब आ तौ नहशोनमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ताम्‍बु ङा शेकेल का १२ ग्राम ङा क्‍येट बाक्‍ब। बजार ङा शेकेल चहिं ११.५ ग्राम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको अम्‍मीनादाब आ तौ नहशोन आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","मिनु आ दीसा इस्‍साकार आ थर ङा मुर आन ठेयब मुर सुआर आ तौ नेथनेलम आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको सुआर आ तौ नेथनेल आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","मिनु मेको आ नित्‍थ नाक्‍ती जबूलून आ थर ङा मुर आन ठेयब मुर हेलोन आ तौ एलीआबमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको हेलोन आ तौ एलीआब आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","मिनु मेको आ सांबु नाक्‍ती रूबेन आ थर ङा मुर आन ठेयब मुर शेदेउर आ तौ एली-सुरमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ताम्‍बु ङा शेकेल का १२ ग्राम चांदी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको शेदेउर आ तौ एली-सुर आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","मिनु मेको आ नोले ङा नाक्‍ती सिमियोन आ थर ङा मुर आन ठेयब मुर सुरी-शदै आ तौ शेलुमीएलमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको सुरी-शदै आ तौ शेलुमीएल आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","मिनु मेको आ नोले ङा नाक्‍ती गाद आ थर ङा मुर आन ठेयब मुर दूएल आ तौ एली-आसाफमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको दूएल आ तौ एली-आसाफ आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","मिनु मेको आ नोले ङा नाक्‍ती एफ्राइम आ थर ङा मुर आन ठेयब मुर अम्‍मीहुद आ तौ एली-शामामी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसीम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको अम्‍मीहुद आ तौ एली-शामा आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","मिनु मेको आ नोले ङा नाक्‍ती मनस्‍से आ थर ङा मुर आन ठेयब मुर पेदा-सुर आ तौ गमालीएलमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको पेदा-सुर आ तौ गमालीएल आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","मिनु मेको आ नोले ङा नाक्‍ती बेन्‍यामीन आ थर ङा मुर आन ठेयब मुर गिदेओनी आ तौ आबी-दानमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको गिदेओनी आ तौ आबी-दान आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","मिनु मेको आ नोले ङा नाक्‍ती दान आ थर ङा मुर आन ठेयब मुर अम्‍मी-शदै आ तौ अही-एजेरमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको अम्‍मी-शदै आ तौ अही-एजेर आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","मिनु मेको आ नोले ङा नाक्‍ती आशेर आ थर ङा मुर आन ठेयब मुर ओक्रान आ तौ पगीएलमी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको ओक्रान आ तौ पगीएल आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","मिनु मेको आ नेल्‍ल क्‍येङा नोले ङा नाक्‍ती नाप्‍ताली आ थर ङा मुर आन ठेयब मुर एनान आ तौ अहीरामी आ चढ़ेतीक चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","मिनु मार चाक्‍तु देंशा हना, सहे का ३० शेकेल ङा चांदी के थाल का नु ७० शेकेल ङा चांदी के बोस का चाक्‍तु। मेको शेकेल ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो बाक्‍तेक्‍म। मेको थाल नु बोस निम्‍फामी तेलम निशो रिम्‍शो फसम प्रिंशो बाक्‍ताक्‍स। मेको अन्‍न चढ़ेतीके बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","मिनु १० शेकेल ङा धूपम ब्रीशो सुन के आइक्‍च बोस का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","चोशा चढ़ेचा कली ब्‍यफ का, सांड का नु बर्स का गाप्‍शो पाठा का चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पाप आ पर्बम चढ़ेचा कली बोका का, ");
INSERT INTO suzBl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","दुशा बाक्‍चा आ पर्बम चढ़ेचा कली ब्‍यफ निक्‍शी, ५ ओटा सांड, ५ ओटा बोका नु ५ ओटा बर्स का गाप्‍शो पाठा चाक्‍तु। मेको एनान आ तौ अहीरा आ चढ़ेतीक बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","मिनु परमप्रभु यावे आ गेय पचा कली वोइश्‍शो चढ़ेतीक कली तेल ब्रुइक्‍तीक नाक्‍ती इस्राएल आ थर थर ङा मुर आन ठेयब मुर आन चढ़ेशो मार बाक्‍तेक्‍म देंशा हना, १२ ओटा चांदी के थाल, १२ ओटा चांदी के बोस नु १२ ओटा सुन के आइक्‍च बोस बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","मेको चांदी के थाल का का पा सहे का ३० शेकेल हेल्‍शो बाक्‍तेक्‍म। मेको चांदी के बोस का का पा ७० शेकेल हेल्‍शो बाक्‍तेक्‍म। मेको चांदी के ग्‍योंब नेल्‍ल नाक्‍शोनु, ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो पा हजार निक्‍शी ४ सहे शेकेल हेल्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","मिनु मेको १२ ओटा धूपमी ब्रीशो सुन के आइक्‍च बोस का का पा ग्रुम्‍तीक ताम्‍बु ङा शेकेल खोदेंशो पा १०, १० शेकेल हेल्‍शो बाक्‍तेक्‍म। मेको सुन नेल्‍ल नाक्‍शोनु, सहे का २० शेकेल हेल्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","मिनु बी ब्‍यफ, क्‍यारश भेडा रे चोशा चढ़ेचा कली १२ ओटा ब्‍यफ, १२ ओटा सांड, १२ ओटा बर्स का गाप्‍शो पाठा नु मेकोपुकी नु गारचा ङा पा अन्‍न चढ़ेतीके बाक्‍तेक्‍म। मिनु पाप आ पर्बम चढ़ेचा कली १२ ओटा बोका बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","मिनु बी ब्‍यफ, क्‍यारश भेडा रे दुशा बाक्‍चा आ पर्बम चढ़ेचा कली २४ ओटा ब्‍यफ, ६० ओटा सांड, ६० ओटा बोका नु ६० ओटा बर्स का गाप्‍शो पाठा बाक्‍तेक्‍म। मेको परमप्रभु यावे आ गेय पचा कली ला मेको चढ़ेतीक कली तेल ब्रुइक्‍तीक नाक्‍ती आ नोले चढ़ेशो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","मिनु मोसा परमप्रभु यावे नु लोव़ पचा कली ग्रुम्‍तीक ताम्‍बुम ओव़मेनु, मेकोमी कबल पशो सन्‍दोस सुम्‍शो शिशी बाक्‍तीके, करूब निक्‍शी आस दाते इर रे लोव़ पशो नेंतु। मोपा मेकोमी मोसा नु लोव़ पाप्‍तु। प्रस्‍थान २५:१७-२२; प्रस्‍थान २९:४२; प्रस्‍थान ३३:७; १सामुएल ३:३-१४ ");
INSERT INTO suzBl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“गे हारून कली ‘गे मेको बत्ती वोदीनु, मेको ७ ओटा बत्ती दातीक आ ङोंइती गे ब्रपतो’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","मिनु हारूनमी मो पाप्‍तु। परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा दातीक आ ङोंइती गे ब्रपाइक्‍तु। प्रस्‍थान २५:९, ३१-४० ");
INSERT INTO suzBl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","मिनु बत्ती दातीके दोपा सेल्‍शो बाक्‍त देंशा हना, मेको सुन के तुप्‍शा सेल्‍शो बाक्‍त। मेको उइ रे इर सम्‍म तुप्‍शा सेल्‍शो बाक्‍त। मिनु परमप्रभु यावेमी मोसा कली कोंइशो खोदेंशो पा, हारूनमी मेको बत्ती दातीक सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“इस्राएली आन दाते रे लेवी आन कली चाक्‍शा, मेको आन कली चोव़खो सेल्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","मेको आन कली मार पचा माल्‍नेवे देंशा हना, मेको आन तारी चोव़खो सेल्‍तीक ब्‍वाक्‍कु ब्रुइक्‍तीमी। मिनु मेकोपुकीमी आन रां ङा चां नेल्‍ल प्रेक्‍शा, आन वा मुरशा, चिक्‍सीशा ग्रांग्रा मदिशो सेल्‍सीचा माल्‍नीम। गन्‍ती १९:९,१७; लेवी १४:८ ");
INSERT INTO suzBl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","मिनु नोले मेकोपुकीमी ब्‍यफ का नु तेलम निशो रिम्‍शो फस अन्‍न चढ़ेतीके चाक्‍चा माल्‍नीम। गे चहिं पाप आ पर्बम चढ़ेचा कली ब्‍यफ का चाक्‍को। ");
INSERT INTO suzBl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","मिनु गे लेवी आन कली ग्रुम्‍तीक ताम्‍बु आ ङोंइती चाक्‍शा, इस्राएली नेल्‍ल आन कली ग्रुम्‍पाइक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","मिनु गे लेवी आन कली परमप्रभु यावे आ ङोंइती चाक्‍गीनु, इस्राएली नेल्‍लेमी आन गुइ लेवी आन तार वोइक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","मिनु हारूनमी लेवी आ मुर आन कली परमप्रभु यावे आ गेय पचा कली मेको आ ङोंइती क्‍युक्‍शा चढ़ेशो खोदेंशो पा वोइक्‍चा माल्‍ब। प्रस्‍थान २९:२४ ");
INSERT INTO suzBl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","मिनु लेवी आ मुरपुकीमी आन गुइ मेको ब्‍यफ आस पिया तार वोइक्‍चा माल्‍नीम। मिनु हारूनमी लेवी आ मुर आन पर्बम पाप क्‍याम्‍तीक गेय पचा कली ब्‍यफ का पाप आ पर्बम चढ़ेतीके नु अर्को चोशा चढ़ेतीके परमप्रभु यावे कली चढ़ेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","मिनु मेको नोले गे लेवी आ मुर आन कली हारून नु आ तौ आन ङोंइती राप्‍पा, परमप्रभु यावे कली क्‍युक्‍शा चढ़ेतीक खोदेंशो पा वोइक्‍चा माल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","मोपा गे लेवी आ मुर आन कली अरु इस्राएली रे तिल्‍चा माल्‍नेवे। मिनु लेवी आ मुर आं के दुम्‍नीम। गन्‍ती ३:४५ ");
INSERT INTO suzBl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","मिनु गे लेवी आ मुर आन कली ग्रांग्रा मदिशो सेल्‍शा, मेको आन कली क्‍युक्‍शा चढ़ेतीक खोदेंशो पा वोइक्‍मी नोले मेकोपुकीमी ग्रुम्‍तीक ताम्‍बुमी गेय पने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","मिनु मेकोपुकी इस्राएली आन दाते रे थमा पा आं कली तिल्‍शो बाक्‍नीम। गो मेको आन कली इस्राएली आन नेल्‍ल क्‍येङा ङोंइती जरमेशो तौ आन पा ङा आं कली वोइक्‍तामी। गन्‍ती ३:१२-१३ ");
INSERT INTO suzBl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","मिनु इस्राएली आन दातेम मुर बाक्‍तेक्‍म हना यो, बी ब्‍यफ, क्‍यारश भेडा बाक्‍तेक्‍म हना यो, ङोंइती जरमेशो नेल्‍ल आं के बाक्‍नीम। इजीप्‍ती आन नेल्‍ल क्‍येङा ङोंइती जरमेशो तौ नेल्‍ल आन कली सदुमी नाक्‍त रे गो मेको आन कली आं कली तिल्‍शा वोंइसाक्‍यी। प्रस्‍थान १३:२ ");
INSERT INTO suzBl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","मिनु इस्राएली आन ङोंइती जरमेशो आन पा ङा गो लेवी आ मुर तिल्‍शा वोंइसाक्‍यी। ");
INSERT INTO suzBl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","मिनु गो इस्राएली आन दाते रे लेवी आ मुर आन कली हारून नु आ तौ आन कली गेतामी। मार कली गेतामी देंशा हना, इस्राएली आन पर्बम ग्रुम्‍तीक ताम्‍बुमी गेय पचा कली इस्राएली आन पर्बम पाप क्‍याम्‍तीक गेय पचा कली नु इस्राएलीपुकी ग्रुम्‍तीक ताम्‍बु आ नेक्‍था मजाक्‍मल नु मुर बेक्‍तीक रोइम मबेक्‍म, दे गेतामी” दे परमप्रभु यावेमी मोसा कली देंत। गन्‍ती ३:९; गन्‍ती १:५३ ");
INSERT INTO suzBl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","मिनु मोसा, हारून नु इस्राएल ङा मुर नेल्‍लेमी लेवी आ मुर आन पर्बम परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","मिनु लेवी आ मुरपुकीमी आंम आन पाप रे ग्रांग्रा मदिशो सेल्‍सीशा आन वा मुरतेक्‍म। मिनु नोले हारूनमी मेको आन कली क्‍युक्‍शा चढ़ेतीक खोदेंशो पा परमप्रभु यावे आ ङोंइती वोइक्‍तीमी। मिनु हारूनमी मेको आन कली पाप क्‍याम्‍तीक गेय पा ग्रांग्रा मदिशो सेल्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","मिनु मेको नोले लेवी आ मुरपुकीमी हारून नु आ तौ आन कली वारच पा ग्रुम्‍तीक ताम्‍बु ङा गेय पाम्‍तेक्‍म। मिनु परमप्रभु यावेमी मोसा कली लेवी आ मुर आन पर्बम अरेशो खोदेंशो पा मेकोपुकीमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“एको लोव़ २५ बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लेवी आ मुर आन पर्बम बाक्‍ब। मिनु मेकोपुकी ग्रुम्‍तीक ताम्‍बुमी गेय पचा गोचा माल्‍नीम। गन्‍ती ४:३,२३,३०,४७; १इतिहास २३:३,२४ ");
INSERT INTO suzBl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","मिनु मेकोपुकी ५० बर्स लाक्‍गमेनु, गेय पचा प्रोन्‍मेक्‍ल। ");
INSERT INTO suzBl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","मिनु मेकोपुकी ग्रुम्‍तीक ताम्‍बुमी गेय पाइब आन लोक्‍ब आन कली वारच पदमेक्‍ल। तन्‍न आंमा चहिं गेय मपामेक्‍ल। गे लेवी आ मुर आन कली मोदेंशो पा गेय पपाइक्‍चा माल्‍नेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","मिनु परमप्रभु यावेमी इस्राएलीपुकी इजीप्‍त रे जाक्‍मा आ बर्स निक्‍शी नोले ङोंइती ङा महिनाम सीनै ङा गोरशो रागीमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“गे इस्राएलीपुकीमी आं देंशो नाक्‍ती पास्‍सा चाड मानेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","मेको महिना ङा १४ नाक्‍त ङा नाक्‍नाक्‍दो मेको चाड मानेचा माल्‍नीनी। गेपुकीमी मेको आ पर्बम फुल्‍लुम मुशा ब्रेक्‍शो लोव़ नु शेंशो पतीके नेल्‍लेमी मानेचा माल्‍नीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","मिनु मोसामी इस्राएली आन कली “पास्‍सा चाड मानेचा माल्‍नीनी” दे अरेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","मिनु मेकोपुकीम ङोंइती ङा महिना ङा १४ नाक्‍ती ङा नाक्‍नाक्‍दो सीनै ङा गोरशो रागीमी पास्‍सा चाड मानेम्‍तेक्‍म। परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा इस्राएलीपुकीमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","मिनु मेकेर मुर का निक्‍शी बेक्‍शो मुर थिशा, ग्रांग्रा दिशो दुम्‍शो बाक्‍तेक्‍म। मोपा मेकोपुकीमी मेको नाक्‍ती मेको पास्‍सा चाड मानेचा मतामे। मेकोपुकी मेको नाक्‍ती मोसा नु हारून आस ङोंइती जाक्‍तेक्‍म। गन्‍ती १९:११ ");
INSERT INTO suzBl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","मिनु मेको मुरपुकीमी “गो बेक्‍शो मुर थिशा ग्रांग्रा दिशो दुम्‍शो बाक्‍तक हना यो, मारदे मेको देंशो नाक्‍ती गोपुकीमी इस्राएली आन दातेमी आंइ परमप्रभु यावे कली चढ़ेतीके चढ़ेचा मताइनीकी?” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मिनु मोसाम मेको आन कली “रिम्‍दीन, परमप्रभु यावेमी इन पर्बम मार देंबा, गो मेको नेंचा माल्‍नुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“गे इस्राएली आन कली ‘सुइ इन दातेमी नु इन चच युइ आन दातेमी बेक्‍शो मुर थिशा ग्रांग्रा दिशो दुम्‍शो बाक्‍त हना यो, ङोन लत हना यो, मेकोमी परमप्रभु यावे कली पास्‍सा चाड मानेचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","मेकोपुकीमी महिना निक्‍शी ङा १४ नाक्‍ती नाक्‍नाक्‍दो मेको मानेचा माल्‍नीम। मिनु मेकोपुकीमी मेको पाठा कली बोरब ओख्‍ती मसुप्‍शो शोब्‍ले, कशो खाइ नु ब्‍वचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","मिनु मेको आ दीसा सुनी सम्‍म मारेइ हेंचा मदुम्‍ब। मिनु मेको आ रुश का यो जिक्‍चा मदुम्‍ब। मिनु पास्‍सा चाड आ पर्बम फुल्‍लुम मुशा, मार ब्रेक्‍शो बाक्‍मे, मेको पचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","तन्‍न तेको मुर ग्रांग्रा दिशो मदुम्‍शो बाक्‍बा, ङोन यो मलशो बाक्‍बा, मेकोमी पास्‍सा चाड ममानेप्‍तु हना, मेको मुर आ मुर आन दाते रे तिल्‍चा पुंइसीब। मारदे हना मेकोमी आ देंशो नाक्‍ती परमप्रभु यावे कली चढ़ेतीक मचढ़ेवो। मेको मुर आ पाप राइब। ");
INSERT INTO suzBl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","मिनु इन दातेमी बाक्‍शो अर्को रागी ङा मुरुमी परमप्रभु यावे कली पास्‍सा चाड मानेचा दाक्‍ताक्‍व हना, मेकोमी मेको आ पर्बम ब्रेक्‍शो नेल्‍ल शेंशो पतीक खोदेंशो पा पचा माल्‍ब। मिनु अर्को रागी ङा मुर नु इन मुर नेल्‍ल आन कली पास्‍सा चाड आ पर्बम ब्रेक्‍शो लोव़ का दुम्‍चा माल्‍ब’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","मिनु ग्रुम्‍तीक ताम्‍बु वोइक्‍ने थुम्‍शो नाक्‍ती गोस्‍सुमी मेको कबल पशो सन्‍दोस वोइश्‍शो ताम्‍बु सुम्‍तु। मेको नाक्‍नाक्‍दो रे सुनी सम्‍म ताम्‍बु तारी बाक्‍त। मेको गोस्‍स मी खोदेंशो तांइसीशो बाक्‍त। प्रस्‍थान ४०:३४-३५ ");
INSERT INTO suzBl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","मेको मोदेंशो गेना हना यो दुम्‍शो बाक्‍त। गोस्‍सुमी मेको ताम्‍बु कली नाक्‍ती सुम्‍बाक्‍त। मिनु नाक्‍दो मी खोदेंशो दुम्‍बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","मिनु मेको गोस्‍स ताम्‍बु आ तार रे इर गे लमेनु, इस्राएलीपुकी गाक्‍चा गोम्‍तेक्‍म। मिनु तेकेर मेको गोस्‍स जुक्‍ता, मेकेर इस्राएलीपुकीमी आन बाक्‍तीक सेल्‍तेक्‍म। प्रस्‍थान ४०: ३६-३८ ");
INSERT INTO suzBl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","मिनु इस्राएलीपुकी परमप्रभु यावे आ अरेशोमी गाक्‍बाक्‍तेक्‍म। मिनु परमप्रभु यावे आ अरेशोमी मेकोपुकीमी आन बाक्‍तीक सेल्‍बाक्‍तेक्‍म। मिनु मेकोपुकी मेको गोस्‍स ग्रुम्‍तीक ताम्‍बु तार बाक्‍म सम्‍म मेकेर बाक्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","मेको गोस्‍स शुश नाक्‍त सम्‍म ग्रुम्‍तीक ताम्‍बु तार बाक्‍त हना यो, इस्राएलीपुकी परमप्रभु यावे आ देंशो टिशा मगाक्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कोइ नाक्‍ती मेको गोस्‍स ग्रुम्‍तीक ताम्‍बु आ तार का निक्‍शी नाक्‍त सम्‍म ला बाक्‍बाक्‍त। मिनु मेकोपुकी परमप्रभु यावे आ अरेशो टिशा, बास बाक्‍बाक्‍तेक्‍म। मिनु परमप्रभु यावे आ अरेशो खोदेंशो पा गाक्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कोइ नाक्‍ती मेको गोस्‍स नाक्‍दो रे सुनी सम्‍म ला बाक्‍बाक्‍त। मिनु सुनी गोस्‍स इर लमेनु, मेकोपुकी गाक्‍बाक्‍तेक्‍म। नाक्‍ती बाक्‍त हना यो, नाक्‍दो बाक्‍त हना यो, मेको गोस्‍स इर लत हना, मेकोपुकी गाक्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","मिनु मेको गोस्‍स नाक्‍त निक्‍शी, महिना का नु मेको क्‍येङा शुश नाक्‍त सम्‍म यो ग्रुम्‍तीक ताम्‍बु तार बाक्‍त हना, इस्राएली आन बाक्‍तीकेमी बाक्‍बाक्‍तेक्‍म। तन्‍न गोस्‍स इर गे लत हना, मेकोपुकी गाक्‍बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","मिनु मेकोपुकी परमप्रभु यावेमी अरेशो खोदेंशो पा आन बाक्‍तीक सेल्‍बाक्‍तेक्‍म। मिनु परमप्रभु यावे आ अरेशो खोदेंशो पा गाक्‍बाक्‍तेक्‍म। मेकोपुकीमी परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा पाइबाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“गे चांदी के तुराही निक्‍शी सेलो। मेको तुप्‍शा, सेल्‍चा माल्‍नेवे। मिनु गे मेको ताप्‍शा, इस्राएली आन कली ग्रुम्‍पाइक्‍चा माल्‍नेवे। मिनु गाक्‍ची ना दुम्‍मेनु, गे मेको ताप्‍चा माल्‍नेवे। गन्‍ती ३१:६ ");
INSERT INTO suzBl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","मेको निक्‍शी कालेम ताप्‍शोनु, इस्राएली नेल्‍ल इ ङोंइती ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी जाक्‍शा बुक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","तन्‍न का ला ताप्‍शोनु, इस्राएली आन थर थर ङा मुर आन ठेयब मुरपुकी इ ङोंइती जाक्‍शा बुक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","मिनु ठेयब सेंदामी ताप्‍शोनु, पूर्ब गे बाक्‍शो मुरपुकी गाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","मिनु निक्‍शी खेयप ताप्‍शोनु, दक्‍खिन गे बाक्‍शो मुरपुकी गाक्‍चा माल्‍नीम। गाक्‍ची ना दुम्‍मेनु, गेना हना यो तुराही ताप्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","गे मुर आन कली ग्रुम्‍पाइक्‍ची ना मेको ताप्‍चा माल्‍नेवे। तन्‍न मेको गाक्‍ची ना ङा खोदेंशो पा ताप्‍चा मदुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","मिनु हारून आ तौ चढ़ेब निक्‍शीमी मेको तुराही ताप्‍चा माल्‍नीस। मेको इन कली नु इन चच युइ आन कली गेना हना यो पतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","मिनु गे इन रागीमी इन कली दिप्‍ब जोरी सत्रुपुकी नु लडाइ पथ लनीनु, ठेयब सेंदामी तुराही ताप्‍चा माल्‍नीस। मो पाइतीनी हना, परमप्रभु यावे, इन परमप्रभुमी इन कली मिम्‍शा, इन जोरी सत्रु रे प्रोंइब। न्‍यायाधीस ६:३४ ");
INSERT INTO suzBl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","मिनु गेपुकी ग्‍येरशा बाक्‍नीनु, गे इन पचा माल्‍शो चाड मानेनीनु, औंसी ङा चाड मानेनीनु, इन चोशा चढ़ेतीके नु इन दुशा बाक्‍चा आ पर्बम चढ़ेतीके चढ़ेनीनु, गेपुकीमी तुराही ताप्‍चा माल्‍नीनी। मिनु मेको ताप्‍नीनु, इन परमप्रभुमी इन कली मिम्‍ब। गो परमप्रभु यावे, इन परमप्रभु नङ” देंत। लेवी २३:२४; २राजा ११:१४; २इतिहास ७:६ ");
INSERT INTO suzBl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","मिनु बर्स निक्‍शी, महिना निक्‍शी ङा २० नाक्‍ती मेको गोस्‍स परमप्रभु यावे आ कबल पशो सन्‍दोस बाक्‍शो ताम्‍बु रे इर लत। गन्‍ती १:१ ");
INSERT INTO suzBl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","मिनु नोले इस्राएलीपुकी सीनै ङा गोरशो रागी रे हुल हुल पा गाक्‍तेक्‍म। मिनु मेको गोस्‍स पारान ङा गोरशो रागीम नांइसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","मिनु परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा टिशा, मेकोपुकी गाक्‍तेक्‍म। गन्‍ती २:- ");
INSERT INTO suzBl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","नेल्‍ल क्‍येङा ङोंइती यहूदा आ बाक्‍तीक ङा मुर हुल हुल पा आन छेदर कुरशा गाक्‍तेक्‍म। मेको आन ठेयब मुर अम्‍मीनादाब आ तौ नहशोन बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","मिनु इस्‍साकार आ बाक्‍तीक ङा मुर आन ठेयब मुर सुआर आ तौ नेथनेल बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","मिनु जबूलून आ बाक्‍तीक ङा मुर आन ठेयब मुर हेलोन आ तौ एलीआब बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","मिनु नोले ग्रुम्‍तीक ताम्‍बु पोक्‍शा, गेरशोन आ मुरपुकी नु मेरारी आ मुरपुकीमी मेको कुरशा, गाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","मिनु मेको आन नोले रूबेन आ बाक्‍तीक ङा मुरपुकी हुल हुल पा आन छेदर कुरशा गाक्‍तेक्‍म। मेको आन ठेयब मुर शेदेउर आ तौ एली-सुर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","मिनु सिमियोन आ बाक्‍तीक ङा मुर आन ठेयब मुर सुरी-शदै आ तौ शेलुमीएल बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","मिनु गाद आ बाक्‍तीक ङा मुर आन ठेयब मुर दूएल आ तौ एली-आसाफ बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","मिनु कोहाथीपुकी परमप्रभु यावे आ ताम्‍बु ङा मार मार कुरशा, गाक्‍तेक्‍म। मेको आन जाक्‍चा क्‍येङा ङोंइती मेको ग्रुम्‍तीक ताम्‍बु सेल्‍ने थुम्‍शो बाक्‍चा माल्‍बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","मेको नोले एफ्राइम आ बाक्‍तीक ङा मुरपुकी हुल हुल पा आन छेदर कुरशा गाक्‍तेक्‍म। मेको आन ठेयब मुर अम्‍मीहुद आ तौ एली-शामा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मिनु मनस्‍से आ बाक्‍तीक ङा मुर आन ठेयब मुर पेदा-सुर आ तौ गमालीएल बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","मिनु बेन्‍यामीन आ बाक्‍तीक ङा मुर आन ठेयब मुर गिदेओनी आ तौ आबी-दान बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","मिनु नेल्‍ल आन क्‍येङा नोले दान आ बाक्‍तीक ङा मुर हुल हुल पा आन छेदर कुरशा, गाक्‍तेक्‍म। मेको आन ठेयब मुर अम्‍मी-शदै आ तौ अही-एजेर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","मिनु आशेर आ बाक्‍तीक ङा मुर आन ठेयब मुर ओक्रान आ तौ पगीएल बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","मिनु नाप्‍ताली आ बाक्‍तीक ङा मुर आन ठेयब मुर एनान आ तौ अहीरा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","मोपा इस्राएली आन हुल हुल पा गाक्‍चा माल्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मिनु मोसामी मिदयान ङा रूएल आ तौ होबाब, आ रिउ कली “परमप्रभु यावेमी आंइ कली गेशो रागी लना लन बाक्‍नीकी। गे यो गोपुकी नु पिने। गो इन कली रिम्‍शो पाइक्‍नीकी। मारदे हना परमप्रभु यावेमी ‘इस्राएली आन कली रिम्‍शो पाइनुङ’ देंत” दे मोसामी देंत। प्रस्‍थान २:१८; प्रस्‍थान १८:१; न्‍यायाधीस १:१६; न्‍यायाधीस ४:११ ");
INSERT INTO suzBl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","होबाबमी “गो मलाइक्‍नुङ। गो आं रागी नु आं मुर आन बाक्‍तीके लेत्‍नुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","मिनु मोसामी “आंइ कली मप्रोनीन। मारदे हना मेको गोरशो रागीमी ते ताम्‍बु कीचा मेको तुइक्‍नीनी। मिनु गे आंइ कली लां कोंइब दुम्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","गे गोपुकी नु गाक्‍तीनी हना, परमप्रभु यावेमी आंइ कली मार मार रिम्‍शो पाइबा, गो मेको खोदेंशो पा इन कली पाइनीकी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","मिनु मेकोपुकी परमप्रभु यावे आ डांडा रे नाक्‍त सां सम्‍म गाक्‍तेक्‍म। परमप्रभु यावे आ कबल पशो सन्‍दोस कुरबपुकी मेको आन कली बास बाक्‍तीक माल्‍चा, दे मेको आन ङोंइङोंइती गाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","मिनु परमप्रभु यावे आ गोस्‍स मेको आन गाक्‍ची ना मेको आन तार बाक्‍त। प्रस्‍थान १३:२१; गन्‍ती ९:१५-२३ ");
INSERT INTO suzBl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","मिनु कुरबपुकीमी मेको कबल पशो सन्‍दोस कुरशा गाक्‍मानु, गेना हना यो मोसामी “परमप्रभु यावे, बोक्‍कीन। इन जोरी सत्रु एर ओंथ ब्रामल। मिनु इन जोरी सत्रु इन क्‍येङा प्रोक्‍मल” देंबाक्‍त। २इतिहास ६:४१; भजन संग्रह ३:८; भजन संग्रह ९:२०; भजन संग्रह १०:१२; भजन संग्रह १७:१३; भजन संग्रह ६८:२; भजन संग्रह १३२:८ ");
INSERT INTO suzBl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","मिनु मेको कबल पशो सन्‍दोस नाइक्‍तमेनु, मेकोमी “परमप्रभु यावे, गे हजार, हजार इस्राएली आन दातेमी लेश्‍शा, जाक्‍कीन” देंबाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","मिनु परमप्रभु यावेमी मुर आन श्‍येत जशो आ पर्बम गन गन पशो नेंतु। परमप्रभु यावेमी मेको नेंशा, शुश गाइक्‍ताक्‍व। मिनु परमप्रभु यावे गाइश्‍शा, मुर आन बाक्‍तीके गे मी सोइश्‍शा, एर सुर मीम नेक्‍पाइक्‍तु। लेवी १०:२ ");
INSERT INTO suzBl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","मिनु मुरपुकीमी मोसा कली “वारच पने” दे ग्रीतेक्‍म। मिनु मोसामी परमप्रभु यावे कली पुंइतु। मिनु मेको मी काप्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","मिनु परमप्रभु यावेमी मेको आन दातेमी मी सोइक्‍तीके, मेको बाक्‍तीके आ नें तबेरा वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","मिनु मेको आन दातेमी बाक्‍शो अर्को रागी ङा मुरपुकीमी मार मार जचा थोव़क जचा ब्‍वचा दाक्‍तेक्‍म। मिनु इस्राएली यो लेंशा ङाक्‍शा “गोपुकीमी श्‍ये ब्‍वचा तक हना, दुम वा। प्रस्‍थान १२:३८; प्रस्‍थान १६:३; १कोरिन्‍थी १०:६ ");
INSERT INTO suzBl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","गो इजीप्‍तीमी मो ब्‍वशो ङांइ श्‍ये मिम्‍नीकी। मिनु वोबीस, खाइपुकी, प्‍याज नु लसुन यो मिम्‍नीकी। ");
INSERT INTO suzBl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","तन्‍न गो मुल ओले पेते दुम्‍शा, एको मन्‍ना ङा लाक्‍शा मारेइ मथित्‍नीकी” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्‍ना चहिं धन्‍या वांचेर खोदेंशो बाक्‍त। मेको कोव़शोनु, खोटो खोदेंशो तांइसीबाक्‍त। प्रस्‍थान १६:१४-३१ ");
INSERT INTO suzBl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मिनु मुरपुकी लशा, मेको खुप्‍शा, कोइमी हिल्‍शा, कोइमी चुशा, कोंइमी नेल्‍शा, कोइम बटुक सेल्‍शा जाम्‍तेक्‍म। मिनु मेको तेलम चोशो शोब्‍ले खोदेंशो पा ब्रोव़बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","मिनु नाक्‍दो आन बाक्‍तीकेमी सीत यिमेनु, मन्‍ना यो यीबाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मिनु मोसामी मुर नेल्‍ल आन आन ताम्‍बु ङा ओव़तीकेमी राप्‍शा ङाक्‍शो ताप्‍तु। मिनु मुरपुकीमी परमप्रभु यावे कली शुश गाइक्‍पाइक्‍तीके, मोसामी मेको आन पशो काइ मदाक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मिनु मोसामी परमप्रभु यावे कली “गे मारदे आं कली श्‍येत गेयीनी? मारदे गो इन ङोंइती शिशी मतङा? मारदे आं कली इश ङा मुर आन कली कोव़ब सेल्‍यीनी? ");
INSERT INTO suzBl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","मार, एको इश ङा मुर आं आल नमी ङा? मार, गो मेको आन कली थिङमी ङा? गे आं कली ‘दूध तूब आल कली आ आममी कुरशा लाइश्‍शो खोदेंशो पा, आंइ किकी पिपी आन कली इन गेशो रागीमी कुरशा लावो’ देंनीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","गो इश ङा मुर आन ब्‍वतीक श्‍ये ते थित्‍नुङ ङा? मिनु मेकोपुकीमी आं कली ‘श्‍ये ब्‍वचा गेकी’ दे जाक्‍शा ङाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","गो इश ङा मुर आन कली खुल्‍ने मचाप्‍नुङ। एको आं मचाप्‍चा ङा गेय बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","मिनु गे आं कली ओदेंशो पाइक्‍तीनी। मिनु गो इन शिशी ताता हना, साइय्‍यीनी। मिनु गो आं खतम दुम्‍तीके तचा ममाल्‍नुङ” देंत। प्रस्‍थान ३२:३२ ");
INSERT INTO suzBl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","मिनु परमप्रभु यावेमी मोसा कली “गे इस्राएली आन दाते रे ७० जना खाल्‍पा आन कली खुप्‍तीमी। मेको आन मुर आन दाते ङा ठेयब मुर नु मेको आन कली सासन पाइब मुर दुम्‍चा माल्‍नीम। मिनु गे मेको आन कली तुइक्‍चा माल्‍नेवे। मिनु मेको आन कली ग्रुम्‍तीक ताम्‍बुमी चाक्‍मी। मिनु मेकोपुकी गे नु बाक्‍चा माल्‍नीम। प्रस्‍थान १८:२१-२६; प्रस्‍थान २४:९-११ ");
INSERT INTO suzBl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","मिनु गो यिशा, गे नु लोव़ पाइनुङ। मिनु गो इ आगामी बाक्‍शो सोक्‍त रे लाइश्‍शा, मेको आन तारी वोइक्‍नुङ। मिनु मेकोपुकीमी गे नु गारशा, मेको मुर आन श्‍येत कुरनीम। मिनु गे का ला कुरचा ममाल्‍नेवे। ");
INSERT INTO suzBl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","मिनु गे मुर आन कली ‘गे दीसा कली ग्रांग्रा मदिशो दुम्‍शा, ठीक दुमीन। गेपुकीमी श्‍ये ब्‍वचा ताइनीनी। मारदे हना गेपुकीमी परमप्रभु यावे आ ङोंइती श्‍ये ब्वचा तक हना, रिम्‍शो दुम वा, दे ङाक्‍शो बाक्‍तीनी। आंइ कली एको रागी क्‍येङा इजीप्‍तमी रिम्‍शो बाक्‍त’ देंतीनी। मोपतीके परमप्रभु यावेमी इन कली श्‍ये ब्‍वचा गेब। मिनु गे मेको ब्‍वाइनीनी। प्रस्‍थान १९:१० ");
INSERT INTO suzBl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","मिनु नाक्‍त का, नाक्‍त निक्‍शी ५ नाक्‍ती, १० नाक्‍ती नु २० नाक्‍त ला ममाइ, ");
INSERT INTO suzBl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","गेपुकीमी ब्रीचा ङा पा महिना का सम्‍म श्‍ये ब्‍वचा ताइनीनी। मारदे हना गेपुकीम आंम इन दातेम बाक्‍शो परमप्रभु यावे कली मटिनी। मिनु गे मेको आ ङोंइती ‘गो मारदे इजीप्‍त रे ग्रूशा गाक्‍का?’ दे ङाक्‍तीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","मिनु मोसामी “गो नु लां गाक्‍ब मुर ६ लाख बाक्‍नीम। मो हना यो, गे ‘मेको आन कली महिना का सम्‍म श्‍ये ब्‍वचा गेनुङमी’ देंतीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","मार, बी ब्‍यफ, क्‍यारश भेडा नेल्‍ल क्‍योरशा हना यो, एको इश ङा मुर आन कली गाप्‍बा ङा? समुन्‍द्र ङा ङांइ नेल्‍ल रेश्‍शा हना यो, नेल्‍ल आन कली गाप्‍बा ङा?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","मिनु परमप्रभु यावेमी मोसा कली “मार, आं सक्ति ग्‍युम्‍शो बाक्‍बा ङा? आं देंशो लोव़ गाप्‍बाक्‍म कों मगाप्‍बाक्‍मे, तुइक्‍नेवे” देंत। यसैया ५०:२; यसैया ५९:१ ");
INSERT INTO suzBl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","मोपतीके मोसा लाङगा ग्रूशा, मुर नेल्‍ल आन कली परमप्रभु यावे आ देंशो लोव़ नेंपाइक्‍तीमी। मिनु मेको मुर आन दाते ङा ७० जना खाल्‍पा आन कली ताम्‍बु आ एर ओंथ राप्‍पाइक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","मिनु नोले परमप्रभु यावे गोस्‍सुमी उइ आगा तोइश्‍शा, मोसा नु लोव़ पाप्‍तु। मिनु मेकोमी मोसा आ आगा बाक्‍शो सोक्‍त इच्‍का लाइश्‍शा, मेको ७० जना खाल्‍पा आन तार वोइक्‍तु। मिनु मेको सोक्‍त मेको आन तार नांइसेनु, मेकोपुकीमी परमप्रभु यावे आ लोव़ पाम्‍तेक्‍म। तन्‍न नोनोले मो मपाम। ");
INSERT INTO suzBl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","मिनु ७० जना खाल्‍पा आन दातेमी एल्‍दाद नु मेदाद माइश्‍शो मुर निक्‍शी बाक्‍ताक्‍स। मेको आस नें यो ब्रेक्‍शो बाक्‍त। तन्‍न मेको निक्‍शी ग्रुम्‍तीक ताम्‍बुम मलसा बाक्‍त। मिनु परमप्रभु यावे आ सोक्‍त मेको आस तार यो नांइसे बाक्‍त। मिनु मेको निक्‍शीमी मुर आन बाक्‍तीकेमी परमप्रभु यावे आ लोव़ पाम्‍से बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","मिनु वोंइश मुर का दोरशा जाक्‍शा, मोसा कली “एल्‍दाद नु मेदादमी मुर आन बाक्‍तीकेमी परमप्रभु यावे आ लोव़ पाम्‍ताक्‍स” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","मिनु नून आ तौ यहोसु मोसा कली वारच पाइब बाक्‍त। मेको मोसा आ योव़शो मुरुमी मोसा कली “हजुर, आं होव़प मेको आस कली तेक्‍कीन” देंत। गन्‍ती १३:१६; प्रस्‍थान २४:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","तन्‍न मोसामी मेको कली “मार, आं पर्बम गे ईख पाइब दुमे? परमप्रभु यावेमी आ सोक्‍त आ मुर नेल्‍ल आन तार वोइश्‍शा, मेको नेल्‍ल परमप्रभु यावे आ लोव़ पाइब दुम हना, गिश रिम्‍शो दुम वा” देंत। योएल ३:१; मर्कूस ९:३८-३९ ");
INSERT INTO suzBl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","मिनु मोसा नु इस्राएली खाल्‍पा मुर आन बाक्‍तीके लेत्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","मिनु नोले परमप्रभु यावेमी फश पपाइक्‍तु। मिनु मेको फशेमी समुन्‍द्र रे बटटाइपुकी चाक्‍तु। मिनु मुर आन बाक्‍तीक आ एर ओंथ नेल्‍ल नाइक्‍पाइक्‍तु। काबु ङा नाक्‍त ङा लां सम्‍म कुबीत निक्‍‍निक्‍शी थांइशो पा नांइसाक्‍म। कुबीत का ०.५ मिटर खोदेंशो बाक्‍ब।प्रस्‍थान १६:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","मिनु मुरपुकीमी मेको नाक्‍त रे, नाक्‍दो रे नु आ दीसा नाक्‍त सम्‍म मेको ग्‍याइक्‍ताक्‍म। नेल्‍ल क्‍येङा इच्‍का खोइ ग्‍याइक्‍बमी यो १० होमेर ग्‍याइक्‍ताक्‍मे। मिनु मेकोपुकीम आन बाक्‍तीक एर ओंथ नेल्‍ल सोव़पाइक्‍तेक्‍म। होमेर का २२० लिटर रिक्‍ब पुक्‍तीके का बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","तन्‍न मेकोपुकीमी श्‍ये ब्‍वना ब्‍वन परमप्रभु यावे मेको आन पर्बम शुश गाइक्‍ताक्‍व। मिनु परमप्रभु यावेमी मेको आन कली थम ठेयब बेक्‍तीक रोइ पपाइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","मोपतीके मेको बाक्‍तीके आ नें किब्रोथ-हत्तावा वोइक्‍तेक्‍म। मारदे हना मेकेर शुश वाल्‍ब मुर आन कली थिम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","मिनु मुरपुकी किब्रोथ-हत्तावा रे पा गाक्‍शा, हसेरोथ गे लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मिनु हसेरोथमी बाक्‍मानु, मोसामी कूश रागी ङा मीश चाक्‍तीके मिरयाम नु हारूनमी मोसा कली मरिम्‍शो लोव़ पाम्‍ताक्‍स। मारदे हना मेकोमी कूश रागी ङा मीश ग्‍युंबे पशो बाक्‍त। प्रस्‍थान २:२१ ");
INSERT INTO suzBl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","मिनु मेको निक्‍शीमी “मार, परमप्रभु यावेमी मोसा नु ला लोव़ पशो बाक्‍बा ङा? मार, मेकोमी गोपुकी नु यो लोव़ मपशो बाक्‍बा ङा?” देंताक्‍स। मिनु परमप्रभु यावेमी मेको लोव़ नेंतु। ");
INSERT INTO suzBl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","मोसा चहिं रागी ङा मुर नेल्‍ले आन क्‍येङा ब्रेम्‍शो मुर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","मिनु परमप्रभु यावेमी रीब पा मोसा, हारून नु मिरयाम आन कली “गे सांफा, ग्रुम्‍तीक ताम्‍बुम रे ग्रूङीन” देंत। मिनु मेको सांफा ग्रूतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","मिनु नोले परमप्रभु यावे गोस्‍स के थामम यिशा ग्रुम्‍तीक ताम्‍बु आ ओव़तीक राप्‍शा, हारून नु मिरयाम आस कली ब्रेत्‍ताक्‍मसी। मिनु मेको निम्‍फा जाक्‍ताक्‍स। प्रस्‍थान १६:१० ");
INSERT INTO suzBl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","मिनु मेकोमी “आं लोव़ नेनीन। गेपुकी इन दातेमी परमप्रभु यावे आ लोव़ पाइब बाक्‍त हना, गो मेको कली कोंइतीकेम तपांइसीनुङ। गो मेको नु आ ङोमुमी लोव़ पाइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","तन्‍न आं गेय पाइब मोसा नु मोदेंशो मपाइनुङ। मेको आ गेय नेल्‍लेमी थमा सुइक्‍चा पुंइसीशो बाक्‍ब। हिब्रू ३:२ ");
INSERT INTO suzBl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","गो मेको नु कोव़मुशा लोव़ पाइनुङ। मिनु मेको नु रुप्‍चा ङा लोव़ पा ख्रुइश्‍शो लोव़ मपाइनुङ। मिनु मेको आं नेक्‍था जाक्‍ने चाप्‍ब। मारदे गे आं गेय पाइब मोसा आ पर्बम मरिम्‍शो लोव़ पचा काइ महिंसी?” देंत। प्रस्‍थान ३३:११; ब्‍यवस्‍था ३४:१० ");
INSERT INTO suzBl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","मिनु परमप्रभु यावेमी मेको आस पर्बम शुश गाइक्‍ताक्‍व। मिनु मेको गाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","मिनु मेको गोस्‍स ताम्‍बु आ तार रे लमेनु, मिरयाम कोव़र मुशा फुं खोदेंशो बुश दुम्‍त। मिनु हारूनमी मिरयाम कली कोव़ङानु, मेको कोव़री दुम्‍ने थुम्‍शो बाक्‍त। ब्‍यवस्‍था २४:९ ");
INSERT INTO suzBl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","मिनु हारूनमी मोसा कली “आं प्रभु, गो मूर्ख दुम्‍शा, पाप पशो आ पर्बम आंस कली सजाइ मगेने। ");
INSERT INTO suzBl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","एको कली आ आम आ कोव़ज रे ग्रूमेनु, आ रां फेके का राक्‍शो शाम्‍शो आल खोदेंशो दुम्‍चा मगेने” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","मिनु मोसामी परमप्रभु यावे कली “परमप्रभु, एको कली सापतीन” दे पुंइतु। प्रस्‍थान १५:२६ ");
INSERT INTO suzBl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","मिनु परमप्रभु यावेमी मोसा कली “मार, मेको आ आफोमी आ कुलुम तोक्‍शो हना, मेको ७ नाक्‍त सम्‍म मुने मदोक्‍बा ङा? मेको कली ७ नाक्‍त सम्‍म मुर आन बाक्‍तीक क्‍येङा लाङगाम तिल्‍शा वोतो। मेको नोले ला लेश्‍शा जाक्‍चा गेवो” देंत। गन्‍ती १३:४६ ");
INSERT INTO suzBl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","मिनु मिरयाम ७ नाक्‍त सम्‍म मुर आन बाक्‍तीक क्‍येङा लाङगाम तिल्‍शा वोइक्‍चा पुंइसाक्‍व। मिनु मिरयाम कली लेश्‍शा मचाक्‍गमे सम्‍म मुरपुकी यो मगाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","मिनु मेको आ नोले मेकोपुकी हसेरोथ रे गाक्‍शा, पारान ङा गोरशो रागीम आन बाक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“गे कनान रागी क्‍यारी पाइब मुरपुकी सोइक्‍तो। गो मेको रागी इस्राएली आन कली गेनुङ। मेको आन थर थर रे पा मुर का का सोइक्‍तो। मेको आन मुर आन दाते ङा ठेयब मुर दुम्‍चा माल्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","मिनु परमप्रभु यावे आ देंशो खोदेंशो पा, मोसामी मेको क्‍यारी पाइब आन कली पारान ङा गोरशो रागी रे सोइक्‍ताक्‍मी। मेको नेल्‍ले इस्राएली आन दाते ङा ठेयब मुर बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","मिनु सु सु बाक्‍तेक्‍म देंशा हना, रूबेन आ थर रे जाक्‍कुर आ तौ शम्‍मुआ, ");
INSERT INTO suzBl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","सिमियोन आ थर रे होरी आ तौ शाफात, ");
INSERT INTO suzBl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदा आ थर रे यपुन्‍ने आ तौ कालेब, यहोसु १४:७ ");
INSERT INTO suzBl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्‍साकार आ थर रे योसेफ आ तौ इगाल, ");
INSERT INTO suzBl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राइम आ थर रे नून आ तौ होशेआ, गन्‍ती १३:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बेन्‍यामीन आ थर रे रफु आ तौ पाल्‍ती, ");
INSERT INTO suzBl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलून आ थर रे सोदी आ तौ गददीएल, ");
INSERT INTO suzBl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफ आ तौ मनस्‍से आ थर रे सूसी आ तौ गाददी, ");
INSERT INTO suzBl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान आ थर रे गेमल्‍ली आ तौ अम्‍मीएल, ");
INSERT INTO suzBl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेर आ थर रे मिकाएल आ तौ सेथुर, ");
INSERT INTO suzBl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नाप्‍ताली आ थर रे वोफ्‍सी आ तौ नाहबी, ");
INSERT INTO suzBl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गाद आ थर रे माकी आ तौ गूएल बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मिनु मोसामी मेको रागी कली क्‍यारी पथ सोइश्‍शो मुर आन नें एकोन बाक्‍नीम। मोसामी नून आ तौ होशेआ आ नें यहोसु वोइक्‍तु। गन्‍ती ११:२८; १इतिहास ७:२७ ");
INSERT INTO suzBl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मोसामी मेको आन कली कनान रागी कली क्‍यारी पथ सोइक्‍ताक्‍मी। मिनु मोसामी मेको आन कली “गे एक रे लशा, नेगेब माइश्‍शो दक्‍खिन ङा रागी रे पहाड गे लने। ");
INSERT INTO suzBl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","मेको रागी दोदेंशो बाक्‍मे, मेकेर ङा मुरपुकी बोल्‍यो बाक्‍मा कों, मबाक्‍मा, शुश बाक्‍मा कों, इच्‍का खोइ ला बाक्‍मा? मेको नेल्‍ल कोव़ङीन। ");
INSERT INTO suzBl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","मिनु मेको आन रागी रिम्‍शो बाक्‍म कों, मरिम्‍शो बाक्‍म? मिनु मेको आन सहर गारो हिरशो बाक्‍म कों महिरशो बाक्‍म? ");
INSERT INTO suzBl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","मिनु मेको रागी ङा खप दोदेंशो बाक्‍मे, मलिलो बाक्‍म कों, पाङकोक्‍च बाक्‍म? मेकेर रवापुकी बाक्‍मा कों, मबाक्‍मा? महिंब दुमीन। मिनु मेको रागी ङा फल फुल चाक्‍कीन” दे माइक्‍तीमी। मेना ङोंइती ङा अङगुर मीची जाक्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","मिनु मेकोपुकी ग्‍येत्‍थ लशा, जीन ङा गोरशो रागी रे रेहोब सम्‍म मेको रागी क्‍यारी पाम्‍तेक्‍म। रेहोब लेबो-हमाथ आ नेक्‍था बाक्‍माक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","मिनु मेकोपुकी नेगेब गे ग्‍येत्‍थ लशा, हेब्रोन सहर जाक्‍दीम्‍मा बाक्‍त। मेकेर अनाक आ मुर अहीमान, शेशै नु तल्‍मै बाक्‍बाक्‍तेक्‍म। हेब्रोन चहिं इजीप्‍त ङा सोआन सहर क्‍येङा ७ बर्स ङोंइती सेल्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","मिनु नोले एश्‍कोल ङा दिंममी जाक्‍दीत्‍तेक्‍म। मिनु मेकेर अङगुर सिश्‍शो राशी क्‍योरशा, मेको कोक्‍के कामी शुइश्‍शा मुर निक्‍शीमी कुरशा चाक्‍तेक्‍स। मेकोपुकीमी अनार नु फोव़शी गेडा यो चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","मिनु मेको ठेयब अङगुर ख्रोइक्‍तीके नोले मेको बेंसी आ नें एश्‍कोल ङा बेंसी वोइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","मिनु ४० नाक्‍ती नोले मेकोपुकीमी मेको रागी क्‍यारी पशा, लेत्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","मिनु लेश्‍शा, मोसा, हारून नु इस्राएली नेल्‍ल आन बाक्‍तीके, पारान ङा गोरशो रागी कादेशमी जाक्‍तेक्‍म। मिनु मेको क्‍यारी पाइबपुकीमी मोसा, हारून नु मुर नेल्‍ल आन कली आन तशो शेंताक्‍मे। मिनु मेको रागी ङा फल फुल कोंइताक्‍मे। गन्‍ती २०:१; उत्‍पत्ती १६:१४; उत्‍पत्ती २०:१; ब्‍यवस्‍था १:१९,४६; यहोसु १४:६-७ ");
INSERT INTO suzBl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","मिनु मोसा कली “गोपुकी इन सोइश्‍शो रागीमी जाक्‍दीत्‍तक। मेको रागीम थमा पा दूध नु खुदो शुश बाक्‍ब। मिनु मेको रागी ङा फल फुल एकोन बाक्‍नीम। प्रस्‍थान ३:८,१७ ");
INSERT INTO suzBl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","तन्‍न मेकेर बाक्‍ब मुरपुकी बोल्‍यो बाक्‍नीम। मिनु मेको आन सहरपुकी गारोम हिरशो नु थम ठेयब बाक्नीम। मिनु गोपुकीमी मेकेर अनाक आ मुर आन कली यो ताइतक। ");
INSERT INTO suzBl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","मिनु अमालेक आ मुर नेगेब रागीम बाक्‍बाक्‍तेक्‍म। मिनु हित्ती, यबुसी नु एमोरी पहाडम बाक्‍बाक्‍तेक्‍म। मिनु कनानी ठेयब समुन्‍द्र आ नेक्‍था नु यर्दन खोला आ नेक्‍था बाक्‍बाक्‍तेक्‍म” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","मिनु कालेबमी मोसा आ ङोंइती बाक्‍शो मुर आन थुं नाइक्‍पाइक्‍चा, दे मोसा कली “गोपुकी रीब पा लशा, मेको रागी इं के सेल्‍य। मारदे हना गो मेको थमा पा ग्राने चाप्‍नय” देंत। गन्‍ती १४:६ ");
INSERT INTO suzBl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","मिनु नोले मेको नु लाइब मुरपुकीमी “गोपुकी मेको मुरपुकी नु लडाइ पथ लने मचाप्‍नय। मारदे हना मेकोपुकी गो इं क्‍येङा शुश बोल्‍यो बाक्‍नीम” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","मोपा मेकोपुकीमी क्‍यारी पथ लतीक रागी आ पर्बम मरिम्‍शो लोव़ नेंपाइश्‍शा “गोपुकीमी क्‍यारी पथ लशो रागीमी आ मुर आन कली साइक्‍ब ताइतक। मिनु आंइ तशो मुरपुकी थम ठेयब बाक्‍नी‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","गोपुकीमी मेकेर नेफीलीमपुकी यो ताइतक। अनाक आ मुर नेफीलीम रे दुम्‍शो बाक्‍नीम। मिनु गो मेको आन कली तशा, गो आंमा माले खोदेंशो तांइसाक्‍क। मिनु गो मेको आन ङोंइती यो मोदेंशोन तांइसीनय” देंतेक्‍म। ब्‍यवस्‍था १:२८; ब्‍यवस्‍था ९:२ ");
INSERT INTO suzBl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","मिनु मेको नाक्‍दो मेको मुर नेल्‍ले वाइ ब्रेश्‍शा ङाक्‍तेक्‍म। ब्‍यवस्‍था १:२६-४४ ");
INSERT INTO suzBl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","मिनु इस्राएली नेल्‍ल मोसा नु हारून आस पर्बम गन गन पाम्‍तेक्‍म। मिनु नेल्‍लेमी मेको आस कली “गोपुकी इजीप्‍त उइ बेक्‍शो नकी हना, रिम्‍शो दुम वा। एको गोरशो रागीम बेक्‍शो नकी हना यो, दुम वा। गन्‍ती ११:१; प्रस्‍थान १६:२-३; प्रस्‍थान १७:२-३ ");
INSERT INTO suzBl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","मारदे परमप्रभु यावेमी आंइ कली तरवारम साइक्‍पाइक्‍चा कली एको रागी चाक्‍गा? गो आंइ मीशपुकी नु आंइ आलपुकी रोइश्‍शा लाइक्‍नीम। गोपुकी इजीप्‍त रागी लेत्‍चा रिम्‍शो ममाइ ङा?” देंतेक्‍म। भजन संग्रह १०६:२४-२६ ");
INSERT INTO suzBl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","मिनु मेकोपुकी “मुल गो लां कोंइब मुर का योव़शा, इजीप्‍त रागीम लेय्‍य” देंमुम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","मिनु मोसा नु हारून मेकेर बुक्‍शो इस्राएली नेल्‍ल आन ङोंइती खुम्‍की पा बाप्‍ताक्‍स। गन्‍ती १६:४ ");
INSERT INTO suzBl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","मिनु मेको रागीम क्‍यारी पथ लाइब नून आ तौ यहोसु नु यपुन्‍ने आ तौ कालेबमी सुर्ता पा आस आस वा खाक्‍ताक्‍स। गन्‍ती १३:६,८,१६,३० ");
INSERT INTO suzBl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","मिनु मेको निक्‍शीमी इस्राएली नेल्‍ल आन कली “गोपुकी आंइ क्‍यारी पथ लशो रागी थम रिम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","परमप्रभु यावे गोपुकी इं कली तशा ग्‍येरसाक्‍व हना, मेकोमी इं कली मेको रागीम चाक्‍दीप्‍ब। मिनु मेको रागी दूध नु खुदो शुश बाक्‍शो रागी बाक्‍ब। मेको रागी इं कली गेब। गन्‍ती १३:२७ ");
INSERT INTO suzBl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","गेपुकी परमप्रभु यावे कली गन गन मपने। मिनु मेको रागी ङा मुर आन क्‍येङा महिनीन। मारदे हना गो मेको आन कली शोब्‍ले खोदेंशो पा नेक्‍नय। मेको आन कली प्रोंइब सुइ मबाक्‍नीम। परमप्रभु यावे गोपुकी नु बाक्‍ब। मेको आन क्‍येङा महिंनीन” देंताक्‍स। गन्‍ती १३:३२ ");
INSERT INTO suzBl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तन्‍न मुर नेल्‍लेमी मेको आस कली “फुल्‍लु आप्‍नीकी” दे हिंच कोंइताक्‍म। मेना परमप्रभु यावे आ छेङछेङ इस्राएली नेल्‍ल आन कली ग्रुम्‍तीक ताम्‍बुम तपांइसाक्‍व। प्रस्‍थान १७:४; प्रस्‍थान १६:१० ");
INSERT INTO suzBl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","मिनु परमप्रभु यावेमी मोसा कली “एको मुरपुकीम गेना सम्‍म आं कली मटीनीमी? एको आन दातेम आं कोंइशो चिन्‍ड तशा यो, गेना सम्‍म आं कली थमा मसुइक्‍नीमी? ");
INSERT INTO suzBl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","गो मेको आन कली बेक्‍तीक रोइमी साइक्‍नुङमी। मेको आं मुर खोदेंशो मबाक्‍नीम। मिनु गो इ रे मेको आन क्‍येङा शुश नु बोल्‍यो जात का सेल्‍नुङमी” देंत। प्रस्‍थान ३२:१०-१४ ");
INSERT INTO suzBl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मिनु मोसामी परमप्रभु यावे कली “मोदेंशो पाइतीनी हना, इजीप्‍त ङा मुरपुकीमी एको लोव़ नेंनीम। मारदे हना गे मेको आन कली इन सक्तिमी मेकेर रे ग्रुंइताक्‍नी। ");
INSERT INTO suzBl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","एको रागी ङा मुरपुकीम मेको आन कली नेंपाइक्‍नीम। परमप्रभु यावे, गे इन मुर आन दातेम बाक्‍शो बाक्‍नीनी, दे मेकोपुकीमी देंशो लोव़ नेंने थुम्‍शो बाक्‍नीम। परमप्रभु यावे, गे मेको आन ङोंइतीन तपांइसीशो बाक्‍नीनी। मिनु इन गोस्‍स मेको आन तार बाक्‍शो बाक्‍ब। मिनु गे नाक्‍ती गोस्‍स के थामम नु नाक्‍दो मी के थामम बाक्‍शा, मेको आन ङोंइती गाक्‍नीनी। प्रस्‍थान १३:२१-२२; गन्‍ती ९:१५-२३ ");
INSERT INTO suzBl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","मिनु मुल गे एको मुर आन कली कालेमी साइक्‍तीनी हना, इन पशो नेंब रागी रागी ङा मुरपुकीमी ");
INSERT INTO suzBl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘परमप्रभु यावेमी मेको आन कली गेनुङ, दे कसम जशो रागीम चाक्‍दीन्‍ने मच‍ब। मोपतीके मेको आन कली गोरशो रागीम साइक्‍तु’ देंनीम। ब्‍यवस्‍था ९:२८; यहोसु ७:८-९ ");
INSERT INTO suzBl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","मोपतीके, परमप्रभु, इन ठेयब सक्ति कोंइदीन। गे इन थोक्‍शो पशो लोव़ खाप्‍पीन। ");
INSERT INTO suzBl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘परमप्रभु यावे रीब पा मगाइक्‍ब नु गेना हना यो दाक्‍ब, प्रस्‍थान ३४:६-७ मेकोमी मरिम्‍शो पशो नु दूली पशो क्‍याम्‍ब, तन्‍न दोस ताइब कली दोस मताइब मदेंब। आन आंम आफ आन पशो पाप मेको आन आल, चच, युइ नु युइ आन आल सम्‍म रपाइक्‍ब’ दे थोक्‍शा लोव़ पशो बाक्‍तीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","मिनु गे मेको मुर आन मरिम्‍शो पशो इन ठेयब नु गेना हना यो दाक्‍तीकेमी क्‍याम्‍दीन। गे इन मुर आन कली इजीप्‍त रे एक सम्‍म आन मरिम्‍शो पशो क्‍याम्‍शो खोदेंशो पने” दे पुंइतु। प्रस्‍थान ३४:१० ");
INSERT INTO suzBl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","मिनु परमप्रभु यावेमी “गे इ पुंइशो खोदेंशो पा एको मुर आन मरिम्‍शो पशो क्‍याम्‍नुङ। ");
INSERT INTO suzBl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","मो हना यो गो थमा पा, रागी नेल्‍ले आं सक्तिमी प्रिंनुङ। प्रस्‍थान ९:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","मेकोपुकीमी इजीप्‍तमी नु गोरशो रागीमी आं ठेयब सक्ति नु छक लाक्‍चा ङा गेय तशा यो, आं कली १० खेयप नाक्‍शा, मटीब दुम्‍शा, मेको नेल्‍लेमी ");
INSERT INTO suzBl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","मेको आन किकी पिपी आन कली कसम जशा ‘गेनुङ’ देंशो रागी ओव़चा मताइनीम। मिनु आं कली काइ मदाक्‍बपुकीम मेको रागी मताइनीम। भजन संग्रह ९५:११; हिब्रू ३:११,१७-१९ ");
INSERT INTO suzBl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","तन्‍न आं गेय पाइब कालेब आ थुंमी अर्को सोक्‍ती बाक्‍ब। मिनु मेकोमी आ थुं नेल्‍लेमी आं कली टिशो बाक्‍ब। गो मेको कली आ क्‍यारी पथ लशो रागी चाक्‍दीत्‍नुङ। मिनु मेको आ तौ चच युइ आन रागी दुम्‍ब। यहोसु १४:६-९ ");
INSERT INTO suzBl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","मिनु अमालेक आ मुर नु कनानीपुकी बेंसीम बाक्‍तीके, गेपुकी दीसा लने। मिनु लल समुन्‍द्र गे पा गोरशो रागी लने” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“गेना सम्‍म एको मरिम्‍शो मुरपुकीम आं पर्बम गन गन पाइनीमी? गो इस्राएली आन आं कली गन गन पशो नेंता। मेकोपुकीम आं कली गन गन पाइनीम। प्रस्‍थान ३२:३४-३५ ");
INSERT INTO suzBl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","गे मेको आन कली ‘परमप्रभु यावेमी थमा पा इन देंशो खोदेंशो पा इन कली पाइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","गे नेल्‍ल गोरशो रागीमी बेक्‍चा माल्‍नीनी। नें ब्रेक्‍शो नेल्‍ले, २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो आं कली गन गन पाइब बेक्‍चा माल्‍नीम। १कोरिन्‍थी १०:१० ");
INSERT INTO suzBl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","आं कसम जशा, इन कली गेनुङ देंशो रागीमी सुइ ओव़चा मताइनीम। यपुन्‍ने आ तौ कालेब नु नून आ तौ यहोसु ला ओव़चा ताइनीस। ");
INSERT INTO suzBl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","मिनु रोइक्‍चा पुंइसीनीम, देंशो इन आल आन कली चहिं गो मेक चाक्‍दीत्‍नुङमी। मिनु मेकोपुकीमी इन मदाक्‍शो रागीम बाक्‍शा, तुइक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","गेपुकी चहिं एको गोरशो रागीमी बेक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","मिनु इन आल मेको गोरशो रागीमी ४० बर्स सम्‍म गोठला दुम्‍शा हिरचा माल्‍नीम। मोपा इन मटिशो आ पर्बम श्‍येत जाइनीम। गे नेल्‍ल इन नेल्‍ल क्‍येङा नोले ङा मुर मबेक्‍नी सम्‍म मोदेंशो पा हिरचा माल्‍नीम। प्रस्‍थान १६:३५; ब्‍यवस्‍था २:७; ब्‍यवस्‍था ८:४ ");
INSERT INTO suzBl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","गेपुकीमी मेको रागी क्‍यारी पचा कली ४० नाक्‍त सम्‍म माल्‍शो बाक्‍तीनी। मोपतीके नाक्‍त का ङा बर्स का पा ४० बर्स सम्‍म गेपुकीम इन मरिम्‍शो पशो आ पर्बम श्‍येत जचा माल्‍नीनी। मिनु गो इन पर्बम गाइक्‍ताक्‍ङ, दे तुइक्‍नीनी’ दे येरमीया २:१९; गन्‍ती ३२:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","गो, परमप्रभु यावेमी, लोव़ पाता। मिनु गो एको आं कली गन गन पा बुक्‍शो मरिम्‍शो मुर आन कली थमा पा मो पाइनुङ। मेको नेल्‍ल एको गोरशो रागीमीन बेक्‍शा नुप्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","मिनु मोसाम क्‍यारी पथ सोइश्‍शो मुरपुकी लेश्‍शा जाक्‍शा मेको रागी आ पर्बम मरिम्‍शो लोव़ पा मुर नेल्‍ल आन कली परमप्रभु यावे कली गन गन पपाइक्‍तेक्‍म। १कोरिन्‍थी १०:५,१०; यहूदा:५ ");
INSERT INTO suzBl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","मेको रागी आ पर्बम मरिम्‍शो लोव़ चाक्‍ब मुर नेल्‍ल परमप्रभु यावे आ ङोंइती बेक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","मिनु मेको रागी क्‍यारी पथ लाइब आन दाते ङा नून आ तौ यहोसु नु यपुन्‍ने आ तौ कालेब ला ब्रोंइनीस। ");
INSERT INTO suzBl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","मिनु मोसाम मुर नेल्‍ल आन कली एको लोव़ नेंपदानु, मुर नेल्‍ल शुश रोंका पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","मेकोपुकीमी सुनी कना बोक्‍शा इर पहाड गे ङोइश्‍शा “गोपुकी मुल एक रे परमप्रभु यावे आ कबल पशो रागी लाइनीकी। मारदे हना, गोपुकीम पाप पशो बाक्‍नीकी” देंतेक्‍म। ब्‍यवस्‍था १:४१ ");
INSERT INTO suzBl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तन्‍न मोसामी मेको आन कली “मारदे गेपुकीमी परमप्रभु यावे आ लोव़ लाक्‍नीनी? गे मग्रानीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","गे इर मङोंइसीन। मारदे हना परमप्रभु यावे गेपुकी नु मबाक्‍ब। मो पाइतीनी हना, इन जोरी सत्रुपुकीमी इन कली साइक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","मिनु अमालेक आ मुर नु कनानीपुकीमी इन कली लडाइ तोइनीम। मिनु गेपुकी तरवारम साइक्‍चा पुंइसीनीनी। मारदे हना गेपुकी परमप्रभु यावे कली टिचा प्रोंइतीनी। मोपतीके परमप्रभु यावे इन दातेमी मबाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","मो हना यो मेकोपुकीम लोव़ मनेंथु, इर पहाड गे ङोंइसाक्‍म। तन्‍न परमप्रभु यावे आ कबल पशो सन्‍दोस ग्रुम्‍तीक ताम्‍बुम बाक्‍त। मिनु मोसा मुर आन बाक्‍तीक उइ बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","मिनु मेको पहाडम बाक्‍ब अमालेक आ मुर नु कनानीपुकी उइ तोइश्‍शा, मेको आन कली साइक्‍ना साइक्‍न होरमा सम्‍म खेदा पाम्‍तेक्‍म। गन्‍ती २१:३; ब्यवस्‍था १:४४ ");
INSERT INTO suzBl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“गे इस्राएली आन कली ‘गो इन कली गेशो बाक्‍तीक रागीम जाक्‍दीन्‍नीनु, ");
INSERT INTO suzBl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","गे कसम जशो खाप्‍चा कली मीम चोशा चढ़ेतीक चढ़ेचा दाक्‍ताक्‍नी हना, यो, चोशा चढ़ेतीके चढ़ेचा दाक्‍तीनी हना यो, क्‍योरशा चढ़ेचा दाक्‍ताक्‍नी हना यो, इन कली देंशो चाडमी ग्‍येरशा परमप्रभु यावे कली चढ़ेचा दाक्‍ताक्‍नी हना यो, गे इन गोठ नु बगाल रे परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","मिनु सुमी परमप्रभु यावे कली चढ़ेबा, मेकोमी अन्‍न चढ़ेतीके यो चढ़ेचा माल्‍ब। मेको अन्‍न चढ़ेतीक एफाह का ङा १० भाग ङा भाग का रिम्‍शो फस, हिन का ङा ४ भाग ङा भाग का तेल ब्‍वाइश्‍शा, चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीके बाक्‍ब। हिन का ४ लिटर खोदेंशो बाक्‍ब।लेवी २:-; गन्‍ती २८:५ ");
INSERT INTO suzBl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","गे चोशा चढ़ेतीक पाठा का का नु तूचा थोव़क चढ़ेतीक हिन का ङा भाग सां ङा भाग का अङगुर शांबु यो चढ़ेचा माल्‍नीनी। गन्‍ती २८:७; प्रस्‍थान २९:४०; लेवी २३:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","सांड का चढ़ेचा दाक्‍तीनी हना, मेको नु अन्‍न चढ़ेतीक यो चढ़ेचा माल्‍नीनी। मेको अन्‍न चढ़ेतीक एफाह का ङा १० भाग ङा भाग निक्‍शी रिम्‍शो फस नु हिन का ङा भाग सां ङा भाग का तेल ब्‍वाइश्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","तूचा थोव़क चढ़ेतीक कली हिन का ङा भाग सां ङा भाग का अङगुर शांबु चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","मिनु कसम जशो खाप्‍चा कली कि दुशा बाक्‍चा आ पर्बम परमप्रभु यावे कली चोशा चढ़ेचा कली कि क्‍योरशा चढ़ेचा कली ब्‍यफ का चढ़ेतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","मेको नु अन्‍न चढ़ेतीके यो चढ़ेचा माल्‍नीनी। गे एफाह का ङा १० भाग ङा भाग सां रिम्‍शो फस नु आधा हिन तेल ब्‍वाइश्‍शा, चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीक बाक्‍ब। हिन का ४ लिटर पुक्‍तीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","मिनु तूचा थोव़क चढ़ेतीक कली आधा हिन अङगुर शांबु यो मेको चोशा चढ़ेतीक नु चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","मिनु मेको ब्‍यफ, सांड, बोका, पाठा नु आइक्‍च पाठा चढ़ेशोनु, मो पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","गेपुकीम दोशो चढ़ेनीनी, मेको नेल्‍ल आन कली का का पा मो पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","मिनु इस्राएली सु सुमी परमप्रभु यावे कली ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके चढ़ेनीमी, मेकोपुकीमी मोदेंशो पचा माल्‍नीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","मिनु अर्को रागी ङा मुर, गेपुकी नु इच्‍का नाक्‍त बाक्‍त हना यो, गेना हना यो बाक्‍त हना यो, मेकोमी परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक चढ़ेचा दाक्‍ताक्‍व हना, इन खोदेंशो पा पचा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","मिनु इन ग्रुम्‍तीकेमी गेपुकी नु बाक्‍शो अर्को रागी ङा मुर आन कली नेल्‍ल पाला सम्‍म एको पचा माल्‍शो कान बाक्‍ब। गेपुकी नु अर्को रागी ङा मुर परमप्रभु यावे आ ङोंइती खाल का ङा बाक्‍नीनी। प्रस्‍थान १२:४८-४९ ");
INSERT INTO suzBl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","गेपुकी नु गे नु बाक्‍शो अर्को रागी ङा मुर आन कली अरेशो लोव़ नु ठीक पतीक लोव़ खाल ङा बाक्‍चा माल्‍ब’ देंचा माल्‍नेवे” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“गे इस्राएली आन कली परमप्रभु यावेमी इन कली लाइश्‍शो, रागीम जाक्‍दीन्‍नीनु, ");
INSERT INTO suzBl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","गेपुकीमी मेको रागी ङा अन्‍न जनीनु, परमप्रभु यावे कली कोसेली का गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","मिनु इन ङोंइती निशो फस रे सेल्‍शो शोब्‍ले का परमप्रभु यावे कली गेचा माल्‍नीनी। खला रे क्‍युक्‍शा चढ़ेशो खोदेंशो पा चढ़ेचा माल्‍नीनी। नेहेम्‍याह १०:३८; इजीकीएल ४४:३० ");
INSERT INTO suzBl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","मिनु गेपुकीमी नेल्‍ल इन पाला सम्‍म इन ङोंइती ङा निशो फस रे शोब्‍ले का परमप्रभु यावे कली क्‍युक्‍शा चढ़ेतीके कली चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","मिनु गेपुकीमी मतुइक्‍थु परमप्रभु यावेमी मोसा कली शेंशो लोव़ नेल्‍लेमी का मपाइतीनी हना, लेवी ४:१३-२१ ");
INSERT INTO suzBl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","परमप्रभु यावेमी मोसा रे पा इन कली नु इन नोले ङा मुर आन कली शेंशो लोव़ मपाइतीनी हना, ");
INSERT INTO suzBl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","गे नु ग्रुम्‍तीक ङा मुरुमी मतुइक्‍थु पशो पाप आ पर्बम मेको ग्रुम्‍तीक ङा मुर नेल्‍लेमी ब्‍यफ का चोशा चढ़ेचा माल्‍नीम। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो बाक्‍ब। मेको आ शेंशो खोदेंशो पा अन्‍न चढ़ेतीक नु तूचा थोव़क चढ़ेतीक यो चढ़ेचा माल्‍नीम। मिनु पाप आ पर्बम बोका का यो चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","मिनु चढ़ेबमी इस्राएली नेल्‍ल आन पर्बम पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु मेकोपुकी आन पाप क्‍याम्‍चा ताइनीम। मारदे हना मेकोम मतुइक्‍थु पाप पशो बाक्‍नीम। मिनु मेकोपुकीमी परमप्रभु यावे कली मीम चोशा चढ़ेतीक चढ़ेचा माल्‍नीम। मेको आन मतुइश्‍शो पाप आ पर्बम परमप्रभु यावे कली चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","मिनु ग्रुम्‍तीक ङा इस्राएली नु मेको नु बाक्‍शो अर्को रागी ङा मुर नेल्‍ल माफ ताइनीम। मारदे हना मेको मुर नेल्‍लेम मतुइक्‍थु पाप पशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","मिनु सुइमी मतुइक्‍थु पाप पाप्‍तु हना, मेकोमी आ पाप आ पर्बम बर्स का गाप्‍शो क्‍यारश आ पाठी का चढ़ेचा माल्‍ब। लेवी ४:२७-२८ ");
INSERT INTO suzBl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","मिनु चढ़ेबमी मेको मुर आ पशो पाप मतुइक्‍तीके, परमप्रभु यावे आ ङोंइती पाप क्‍याम्‍तीक गेय पचा माल्‍ब। मिनु नोले मेको मुरुम माफ ताइब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","मतुइक्‍थु पाप पाइब इस्राएलीपुकी नु मेको नु बाक्‍ब अर्को रागी ङा मुर नेल्‍ल आन कली मतुइक्‍थु पाप पशो आ पर्बम पचा माल्‍शो गेय खाल का ङा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","तन्‍न इस्राएली बाक्‍त हना यो, अर्को रागी ङा मुर बाक्‍त हना यो, तुइश्‍शा यो, मटिथु पाप पाप्‍तु हना, मेको परमप्रभु यावे कली पाप पाइब बाक्‍ब। मेको मुर कली ग्रुम्‍तीके रे तिल्‍चा माल्‍ब। प्रेरित १३:३८; हिब्रू १०:२६-२९ ");
INSERT INTO suzBl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","मिनु मेको मुरुमी परमप्रभु यावे आ लोव़ लाक्‍शा, आ अरेशो काइ मटितीके, मेको मुर तिल्‍चा पुंइसीशा, आ पाप राइब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","मिनु इस्राएलीपुकी गोरशो रागीम बाक्‍मानु, मेकोपुकीमी नाइक्‍तीक नाक्‍ती मुर का कली शी खुप्‍शो थित्‍तेक्‍म। प्रस्‍थान २०:८-१० ");
INSERT INTO suzBl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","मिनु मुरपुकीमी मेको शी खुप्‍ब कली मोसा, हारून नु मुर नेल्‍ल आन ङोंइतीमी चाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","मिनु मेको कली मार पाइक्‍चा माल्‍बा मतुइक्‍तीके चोक्‍शा वोइक्‍तेक्‍म। लेवी २४:१२ ");
INSERT INTO suzBl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","मिनु परमप्रभु यावेमी मोसा कली “मेको मुर कली साइक्‍चा माल्‍ब। ग्रुम्‍तीक ङा मुर नेल्‍लेमी मेको कली मुर आन बाक्‍तीके रे ग्रुंइशा, फुल्‍लु आप्‍शा साइक्‍चा माल्‍नीम” देंत। प्रस्‍थान ३१:१४-१५; प्रस्‍थान ३५:२-३ ");
INSERT INTO suzBl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","मिनु ग्रुम्‍तीक ङा मुर नेल्‍लेमी मेको कली मुर आन बाक्‍तीके रे ग्रुंइ‍शा, फुल्‍लु आप्‍शा साइक्‍तेक्‍म। परमप्रभु यावेमी मोसा कली दोदेंशो पा अरेवा, मोदेंशो पा मुरपुकीमी पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","मिनु लेंशा परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“गे इस्राएली आन कली ‘गेपुकीमी इन फेक्‍तीक वा आन सुरमी नीलो श्‍येले के फेने सेलीन। मोदेंशो नेल्‍ल इन पाला सम्‍म पचा माल्‍नीनी। ब्‍यवस्‍था २२:१२; मत्ती २३:५; प्रस्‍थान ३९:१ ");
INSERT INTO suzBl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","मारदे मोदेंशो पचा माल्‍तीनी देंशा हना, गे मेको फेने तशा, परमप्रभु यावे आ शेंतीके नेल्‍ल मिम्‍शा, टिचा कली मोदेंशो पचा माल्‍नीनी। इन थुं ङा द‍ला दाक्‍स मपचा कली नु इन मिक्‍च कली पाप मपपाइक्‍चा कली मोदेंशो पचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","गे परमप्रभु यावे आ शेंतीक नेल्‍ल मिम्‍शा पचा माल्‍नीनी। मिनु गे इन परमप्रभु आ ङोंइती ग्रांग्रा मदिशो दुम्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","गो, परमप्रभु यावे, इन परमप्रभु नङ। गो इन परमप्रभु दुम्‍चा कली इन कली इजीप्‍त रागी रे ग्रुंइताक्‍नी। गो परमप्रभु यावे, इन परमप्रभु नङ’ देंचा माल्‍नेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","मिनु लेवी आ तौ कोहाथ, आ चच इच्‍हार, आ युइ कोराह, नु रूबेन आ थर ङा एलीआब आ तौ निक्‍शी दाथान नु अबीराम नु पेलेथ आ तौ ओन सल्‍ला पाम्‍तेक्‍म। प्रस्‍थान ६:१६,१८,२१; गन्‍ती २६:७-९; यहूदा १:११ ");
INSERT INTO suzBl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","मिनु मेकोपुकीम सहे निक्‍शी ५० जना इस्राएली ब्रेत्‍ताक्‍म। मेकोपुकी ग्रुम्‍तीकेमी योव़चा पुंइसीशो ठेयब मुर बाक्‍तेक्‍म। मेको आन कली मुर नेल्‍लेमी तुइश्‍शो बाक्‍तेक्‍म। मेकोपुकीम मोसा कली दोस गेम्‍तेक्‍म। गन्‍ती १२:१-२ ");
INSERT INTO suzBl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","मिनु मेकोपुकी बुक्‍शा, मोसा नु हारून आस कली “गे निक्‍शीमी थम मरिम्‍शो पाइतीसी। ग्रुम्‍तीक ङा मुर नेल्‍ले का का पा, ग्रांग्रा मदिशो बाक्‍नीम। मिनु परमप्रभु यावे मेको आन दातेमी बाक्‍ब। गे मारदे इस कली परमप्रभु यावे आ मुर आन क्‍येङा ठेयब सेल्‍सीनीसी?” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","मिनु मोसा मेको लोव़ नेंशा, खुम्‍की पा बाप्‍त। गन्‍ती १४:५ ");
INSERT INTO suzBl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","मिनु मेकोमी कोराह नु मेको आ मुर नेल्‍ल आन कली “दीसा सुनी परमप्रभु यावेमी सु मेको आ मुर बाक्‍बा, सु ग्रांग्रा मदिशो बाक्‍बा नु सु आ नेक्‍था जाक्‍दीत्‍चा गेबा, मेको तुइक्‍पाइक्‍ब। २तिमोथी २:१९ ");
INSERT INTO suzBl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","कोराह, गे नु बाक्‍ब मुर नेल्‍लेमी थनौरो चाक्‍शा जाक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","मिनु गे दीसा मेकेर मी कुर पा परमप्रभु यावे आ ङोंइती धूप चोने। मिनु परमप्रभु यावेमी सु कली योव़बा, मेको ग्रांग्रा मदिशो बाक्‍ब। लेवीपुकी, गे थम मरिम्‍शो पाइतीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मिनु मोसामी कोराह कली “गे लेवीपुकी नेनीन। ");
INSERT INTO suzBl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","इस्राएली आन परमप्रभु यावेमी इन कली आ नेक्‍था जाक्‍चा गेशा, आ ताम्‍बु ङा गेय पचा कली मुर आन दाते रे योव़शो बाक्‍ब। गे ग्रुम्‍तीक आ ङोंइती राप्‍शा, मेको मुर आन गेय पचा, आइक्‍च मिम्‍नीनी? गन्‍ती ३:६-१३; गन्‍ती ४:४-२० ");
INSERT INTO suzBl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","मेकोमी गे नु इ लोक्‍ब, लेवी नेल्‍ल आन कली आ नेक्‍था जाक्‍चा गेप्‍तु। मार, गेपुकीम चढ़ेब आन गेय यो माल्‍नीनी? ");
INSERT INTO suzBl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","गे नु इ मुर नेल्‍ले परमप्रभु यावे कली दोस गेशा बुक्‍तीनी। हारून सु बाक्‍बा ङा? गे मेको कली गन गन पनी?” दे माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","मिनु मोसामी एलीआब आ तौ दाथान नु अबीराम आस कली ब्रेत्‍थ सोइक्‍ताक्‍व। तन्‍न मेको निक्‍शीमी “गो मजाक्‍नस्‍कु। ");
INSERT INTO suzBl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","गे आंइ कली दूध नु खुदो शुश बाक्‍शो रागी रे एको गोरशो रागीम साइक्‍थ चाक्‍शा यो, मार, इन कली मजाक्‍दीम्‍मे? मिनु गे आंइ कली हुकुम यो पचा माल्‍नीसी? ");
INSERT INTO suzBl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","गे आंइ कली दूध नु खुदो शुश बाक्‍शो रागीम चाक्‍दीन्‍नी? रू नु अङगुर रू गे‍नी? मार, गे एको मुर आन मिक्‍च फेत्‍चा दाक्‍नीनी? गोपुकी थमा पा मजाक्‍नीकी” देंताक्‍स। प्रस्‍थान ३:८ ");
INSERT INTO suzBl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","मिनु मोसा शुश गाइश्‍शा, परमप्रभु यावे कली “मेको आन चढ़ेशो मताक्‍कीन। गो मेको आन गधा का यो मताक्‍गु। गो मेको आन कली मरिम्‍शो यो मपङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","मिनु मोसामी कोराह कली “गे नु इ मुरपुकी नु हारून यो दीसा परमप्रभु यावे आ ङोंइती जाक्‍कीन। ");
INSERT INTO suzBl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","गे नेल्‍लेमी आंम आंम थनौरो चाक्‍शा, मेकेर धूप कुर पने। मिनु गे का का पा आंम थनौरो परमप्रभु यावे आ ङोंइती चाक्‍कीन। गे नु हारूनम यो इस थनौरो चाक्‍कीस। मेको सहे निक्‍शी ५० ओटा थनौरो बाक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","मिनु मेको का का पा आन थनौरोम मी कुर पा धूप वोइक्‍तेक्‍म। मिनु मेकोपुकी मोसा नु हारून ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी राप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","मिनु कोराहमी ग्रुम्‍तीक ङा मुर नेल्‍ल आन कली मोसा नु हारून आस पर्बम गन गन पचा, दे ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी पुक्‍तीमी। मेना परमप्रभु यावे आ छेङछेङ मेको नेल्‍ल आन ङोंइती ग्रूत। गन्‍ती १६:१० ");
INSERT INTO suzBl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","मिनु परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“गे निक्‍शी मेको मुर आन रे दिलीस। मिनु गो याम कामी एको नेल्‍ल आन कली रोवल चिवल पोक्‍नुङमी” देंत। उत्‍पत्ती १९:१४ ");
INSERT INTO suzBl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","मिनु मोसा नु हारूनमी खुम्‍की पा “परमप्रभु मुर नेल्‍ल आन कली ब्रोंइचा गेब परमप्रभु, मुर कामी पाप पतीके गे मुर नेल्‍ल नु गाइक्‍नीनी?” देंताक्‍स। अय्‍युब १०:१२; अय्‍युब १२:१०; २सामुएल २४:१७; गन्‍ती २७:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“एको मुर आन कली ‘कोराह, दाथान नु अबीराम आन बाक्‍तीक रे दिलीन’ दे माइक्‍मी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मिनु मोसा बोक्‍शा दाथान नु अबीराम आस बाक्‍तीक लत। मिनु इस्राएली आन खाल्‍पापुकी यो लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","मिनु मेकोम नेल्‍ल मुर आन कली “मेको मरिम्‍शो मुर आन ताम्‍बु रे दिल्‍शा बाक्‍कीन। मेको आन के मारेइ मथिने। मो मपाइतीनी हना, मेको आन पापमी पतीके गेपुकी यो साइक्‍चा पुंइसीनीनी” दे माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","मोपतीके मेकोपुकी कोराह, दाथान नु अबीराम आन ताम्‍बु रे दिल्‍तेक्‍म। मिनु दाथान नु अबीराम आस ताम्‍बु रे ग्रूशा, मेको आस ताम्‍बु आ ओव़तीकेम आस मीश नु आस आलपुकी नु राप्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","मिनु मोसामी मेको नेल्‍ल आन कली “परमप्रभु यावेमी आं कली एको गेय पचा कली सोइश्‍शो बाक्‍ब, दे गे तुइक्‍नीनी। एको गेय नेल्‍ल गो आंमा पशो मनङ। ");
INSERT INTO suzBl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","मेको मुरपुकी अरु मुरपुकी खोदेंशो पा बेक्‍तेक्‍म हना, गो परमप्रभु यावे आ सोइश्‍शो मनङ। ");
INSERT INTO suzBl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","तन्‍न परमप्रभु यावेमी नक गेय का पा, रागीम आ शोव़ पाक्‍शा, दाक्‍तु हना, एको आन मारेइ मारेइ सुन्‍दा सेसीन बेक्‍शो मुर आन बाक्‍तीके दोक्‍तेक्‍म हना, एकोपुकीमी परमप्रभु यावे आ लोव़ लाक्‍शो बाक्‍मा बाक्‍त, दे गेपुकीमी तुइक्‍नीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","मिनु मेको लोव़ पने थुमा नोले मेको आन बाक्‍शो रागी ब्रोल्‍त। ब्‍यवस्‍था ११:६ ");
INSERT INTO suzBl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","मिनु रागीम आ शोव़ पाक्‍शा, मेको नु मेको आस खिं ङा मुर नेल्‍ल, कोराह आ खिं ङा मुर नेल्‍ले नु मेको आन मारेइ मारेइ नेल्‍ल दाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","मिनु मेकोपुकी नु आन मारेइ मारेइ सेसीन बेक्‍शो मुर आन बाक्‍तीके लाम्‍तेक्‍म। मिनु रागीम मेको आन तार आ शोव़ ख्रेप्‍ताक्‍व। मिनु मेकोपुकी ग्रुम्‍तीक ङा मुर आन दाते रे जाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","मिनु आन नेक्‍था बाक्‍ब इस्राएली नेल्‍लेमी मेको आन वाइ ब्रेश्‍शो नेंशा “गोपुकी इं कली यो मुल रागीम दाक्‍ब” देंना देंन प्रोक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","मिनु परमप्रभु यावे रे मी ग्रूशा, मेको सहे निक्‍शी ५० जना धूप चोइब आन कली दाक्‍तु। लेवी १०:१-२; भजन संग्रह १०६:१७-१८ ");
INSERT INTO suzBl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“चढ़ेब हारून आ तौ एलाजर कली थनौरोपुकी ब्रशो मी रे ग्रुंइचा कली नु मी आ फिलीङगो शुश ङोन लाइश्‍शा फ्रचा कली अरेवो। गन्‍ती ३:४; प्रस्‍थान ६:२५ ");
INSERT INTO suzBl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","मारदे हना मेको पाप पाइबपुकी बेक्‍तीके आन थनौरोपुकी ग्रांग्रा मदिशो बाक्‍नीम। मेको थनौरो तुप्‍शा, चढ़ेतीके गिल्‍तीक पाता सेल्‍चा माल्‍ब। मारदे हना मेको मुर आन थनौरो परमप्रभु यावे आ ङोंइती चढ़ेतीके ग्रांग्रा मदिशो दुम्‍तेक्‍म। मिनु मेको इस्राएली आन कली मिम्‍तीक चिन्‍ड दुम्‍चा माल्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","मिनु चढ़ेब एलाजरमी मेको बेक्‍शो मुरपुकीम धूप चोशो तांबा के थनौरो गुप्‍तु। मिनु मेको कली तुप्‍शा चढ़ेतीक गिल्‍चा कली पाता सेल्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","मेको इस्राएली आन कली मिम्‍तीके बाक्‍ब। मार मिम्‍तीके बाक्‍ब देंशा हना, हारून आ मुर ङा लाक्‍शा, अरु मुरपुकी परमप्रभु यावे आ ङोंइती धूप चोचा कली आ नेक्‍था लने मचाप्‍नीम। मिनु कोराह नु आ मुरपुकी खोदेंशो पा साइक्‍चा मपुंइसीनीम, दे मिम्‍पाइक्‍तीक बाक्‍ब। मिनु परमप्रभु यावे मोसा रे पा एलाजर कली दोदेंशो पा लोव़ पवा, मोदेंशो पा पाप्‍तु। गन्‍ती ३:१० ");
INSERT INTO suzBl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","मिनु आ दीसा सुनी इस्राएली नेल्‍लेमी मोसा नु हारून आस पर्बम गन गन पा “गे निक्‍शीमी परमप्रभु यावे आ मुर आन कली साइक्‍तीसी” देंतेक्‍म। प्रस्‍थान १७:३ ");
INSERT INTO suzBl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","मिनु मुरपुकीम मोसा नु हारून आस कली गन गन पा बुक्‍शा, ग्रुम्‍तीक ताम्‍बु गे कोव़ङमेनु, गोस्‍सुमी मेको ताम्‍बु कली सुम्‍शो ताम्‍तेक्‍म। मिनु परमप्रभु यावे आ छेङछेङ ग्रूत। ");
INSERT INTO suzBl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","मेना मोसा नु हारून ग्रुम्‍तीक ताम्‍बु आ ङोंइती लाम्‍ताक्‍स। ");
INSERT INTO suzBl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“गे मेको मुर आन दाते रे दिलीस। गो मेको आन कली याम कामी रोवल चिवल पोक्‍नुङमी” देंत। मिनु मेको खुम्‍की बाप्‍ताक्‍से। ");
INSERT INTO suzBl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","मिनु मोसामी हारून कली “मेको थनौरो लाइश्‍शा, मेको चढ़ेतीक ङा मी कुर पा धूप चोवो। मिनु रीब पा मेको मुर आन दातेमी लाइश्‍शा, मेको आन पाप क्‍याम्‍तीक गेय पावो। मारदे हना परमप्रभु यावे गाइक्‍ताक्‍व। मिनु मुर बेक्‍तीक रोइ बोक्‍चा गोप्‍तु” देंत। लेवी १६:१२,१३,१७; गन्‍ती १:५३ ");
INSERT INTO suzBl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","मिनु मोसामी देंशो खोदेंशो पा हारून थनौरो लाइश्‍शा मुर आन दातेमी दोरशा लत। मेना मुर आन दातेमी मुर साइक्‍ब रोइ जाक्‍ने थुम्‍शो बाक्‍त। मिनु मेकोमी धूप चोशा मुर आन पर्बम पाप क्‍याम्‍तीक गेय पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","मिनु हारून बेक्‍शो नु सेस मुर आन दातेमी राप्‍त। मिनु मेको मुर बेक्‍‍तीक रोइ देक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","कोराह बेक्‍तीकेम बेक्‍शो प्रोंइशा, मेको मुर बेक्‍तीक रोइम बेक्‍शो मुर १४ हजार ७ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","मिनु मेको मुर बेक्‍तीक रोइ देक्‍म नोले हारून मोसा आ बाक्‍तीक, ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम लेत्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“गे इस्राएली नेल्‍ल आन कली ‘गे इन किकी पिपी आन थर थर रे पा का का पा १२ ओटा कोक्‍के चाक्‍कीन’ दे माइक्‍मी। मेको मुर आन नें मेको आन आन कोक्‍केमी ब्रेक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","मिनु हारून आ नें लेवी आ थर ङा मुर आन कोक्‍केम ब्रेक्‍तो। मारदे हना नेल्‍ल थर ङा ठेयब मुर आन नेंम कोक्‍के का का दुम्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","मिनु गे मेको कोक्‍के आन कली ग्रुम्‍तीक ताम्‍बुमी सल्‍ला पशो सन्‍दोस आ ङोंइती वोतो। गो मेकेर रे इन कली लोव़ पाइनुङ। प्रस्‍थान २५:२२ ");
INSERT INTO suzBl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","मिनु आं योव़शो मुर आ कोक्‍केम कोच्‍वा दाप्‍ब। मोपा गो इस्राएलीपुकीम इस पशो गन गन नाइक्‍पाइक्‍नुङमी” देंत। गन्‍ती १६:५-७ ");
INSERT INTO suzBl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","मिनु मोसाम इस्राएली आन कली मेको लोव़ नेंपाइक्‍तीमी। मिनु मेको आन ठेयब मुर नेल्‍लेमी मेको कली कोक्‍के का का चाक्‍शा, गेम्‍तेक्‍म। मिनु मेको आन किकी पिपी आन थर थर पा १२ ओटा कोक्‍के गेम्‍तेक्‍म। मिनु हारून आ कोक्‍के यो मेको आन कोक्‍के आन दातेम बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मिनु मोसामी मेको कोक्‍के नेल्‍ल परमप्रभु यावे आ सल्‍ला पशो सन्‍दोस बाक्‍शो ताम्‍बुमी परमप्रभु यावे आ ङोंइती वोइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","मिनु मोसा आ दीसा सल्‍ला पशो सन्‍दोस बाक्‍शो ताम्‍बुम लत। मिनु लेवी आ थर ङा मुर, हारून आ कोक्‍केम कोच्‍वा दाप्‍शा, फू बोइश्‍शा देसी बदाम सिश्‍शो मीशो ताप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मिनु नोले मोसामी कोक्‍के नेल्‍ल खुप्‍शा, परमप्रभु यावे आ ङोंइती रे लाइश्‍शा, इस्राएली आन कली गेम्‍तीमी। मिनु मेकोपुकीमी कोव़शा, आन आन कोक्‍के लांइसाक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","मिनु परमप्रभु यावेमी मोसा कली “मरिम्‍शो पाइब मुर आन कली मिम्‍तीके दुम्‍पाइक्‍चा कली हारून आ कोक्‍के लेंशा सल्‍ला पशो सन्‍दोस आ ङोंइती लाइश्‍शा वोतो। मिनु मेकोपुकीमी आं पर्बम गन गन पचा मप्रोंइतेक्‍म हना, बेक्‍नीम” देंत। हिब्रू ९:४ ");
INSERT INTO suzBl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मिनु मोसामी परमप्रभु यावे आ देंशो खोदेंशो पा पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","मिनु इस्राएलीपुकीमी मोसा कली “कोव़ङीन, गोपुकी खतम दुम्‍शा जाम्‍शा लाइनीकी। ");
INSERT INTO suzBl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","सु परमप्रभु यावे आ ताम्‍बु आ नेक्‍था लाइबा, मेको बेक्‍ब। मार, गो नेल्‍ल यो बेक्‍नीकी?” देंतेक्‍म। भजन संग्रह १३०:३-४ ");
INSERT INTO suzBl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","मिनु परमप्रभु यावेमी हारून कली “गे इ तौपुकी नु इ आफ आ खिं ङा मुरुम परमप्रभु यावे आ बाक्‍तीक कली मरिम्‍शो पशो कुरचा माल्‍नीनी। मिनु गे नु इ तौपुकीमी चढ़ेतीक गेय पाइब आन मरिम्‍शो पशो कुरचा माल्‍नीनी। प्रस्‍थान २८:३८; लेवी १६:३२-३३ ");
INSERT INTO suzBl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","मोपतीके गे इ लोक्‍ब लेवी आ थर ङा मुर आन कली यो इ कली वारच पचा कली चाक्‍मी। गे नु इ तौपुकीम ताम्‍बु आ ङोंइती गेय पना पन बाक्‍नीनु, मेकोपुकीम इन कली वारच पामेक्‍ल। गन्‍ती ३:६-१० ");
INSERT INTO suzBl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","मेकोपुकी इ कली वारच पशा, ताम्‍बु ङा गेय पचा माल्‍नीम। तन्‍न मेकोपुकीम ताम्‍बु ङा मार मार थिचा मदुम्‍नीम। मिनु चढ़ेतीक आ नेक्‍था जाक्‍चा मदुम्‍नीम। मो पाम्‍तेक्‍म हना, मेकोपुकी नु गे यो बेक्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","मेकोपुकीम इन अरेशो टिशा, ग्रुम्‍तीक ताम्‍बु ङा मारेइ मारेइ गेय पचा माल्‍नीम। गे इन ङा लाक्‍शा अरु सुइम मेको गेय पचा मताइनीम। ");
INSERT INTO suzBl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","मिनु गे इस्राएली आन दातेमी लेंशा गाइक्‍तीक गेनायो मजाक्‍ल, दे परमप्रभु यावे आ बाक्‍तीक नु चढ़ेतीक ङा गेय आंमा पचा माल्‍नेवे। गन्‍ती १७:११ ");
INSERT INTO suzBl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","मिनु गो मुल इस्राएली आन दाते रे इ लोक्‍ब लेवी आन कली योव़नुङ। गो मेको इ कली गेनुङ। मेकोपुकी ग्रुम्‍तीक ताम्‍बु ङा गेय पचा कली आं कली जिम्‍मा गेशो बाक्‍नीम। गन्‍ती ३:१२,४५ ");
INSERT INTO suzBl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","तन्‍न गे नु इ तौपुकीम चढ़ेतीक नु फारशो वा आगा ङा कोठा ङा गेय थम रिम्‍शो पा पने। चढ़ेतीक गेय इन कली गेतन्‍नी। अरु सुइ मेकेर जाक्‍तेक्‍म हना, मेको साइक्‍चा पुंइसीनीम” देंत। गन्‍ती १:५१ ");
INSERT INTO suzBl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","मिनु परमप्रभु यावेमी हारून कली “गो आं कली चढ़ेशो इ कली गेतन। इस्राएलीपुकीमी आं कली चढ़ेशो नेल्‍ल गेतन। मेको इ कली नु इ तौ आन कली चढ़ेतीक गेय पशो ङा गेना हना यो इन भाग बाक्‍ब। लेवी ३:२,१०; लेवी ६:९-११,१९-२२; लेवी ७:६-१० ");
INSERT INTO suzBl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","मिनु मी रे पा प्रोंइशा आं कली चढ़ेशो इन कली मार बाक्‍ब देंशा हना, मेको आं कली नेल्‍ल क्‍येङा चोव़खो चढ़ेशो अन्‍न चढ़ेशो बाक्‍त हना यो, पाप आ पर्बम चढ़ेशो बाक्‍त हना यो नु गारचा आ पर्बम चढ़ेशो नेल्‍ल इ कली नु इ तौ आन कली बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","मिनु मेको इन कली नेल्‍ल क्‍येङा चोव़खो जचा थोव़क बाक्‍ब। मेको इन दाते ङा वोंइश मुर नेल्‍लेमी जने चाप्‍नीम। मेको इन कली चोव़खो बाक्‍ब। लेवी ६:९; लेवी १०:१२,१४ ");
INSERT INTO suzBl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","मिनु इस्राएलीपुकीमी क्‍युक्‍शा चढ़ेतीक चढ़ेम्‍तेक्‍म हना, मेको तिल्‍शो नेल्‍ल इ कली नु इ तमी तौ आन कली गेना हना यो इन भाग बाक्‍ब, दे गेतन्‍नी। इ खिंम ग्रांग्रा मदिशो बाक्‍शो सुइ सुइमी मेको जने चाप्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","मिनु मेकोपुकीमी परमप्रभु यावे कली गेशो नेल्‍ल क्‍येङा रिम्‍शो तेल, नेल्‍ल क्‍येङा रिम्‍शो अङगुर शांबु, अन्‍न नु रिम्‍शो मारेइ मारेइ गो इ कली गेतन। ");
INSERT INTO suzBl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","मेकोपुकीमी परमप्रभु यावे कली चढ़ेथ चाक्‍शो आन ङोंइती मीशो फल फुल नेल्‍ल इं केन दुम्‍ब। इ खिंमी ग्रांग्रा मदिशो बाक्‍शो मुर नेल्‍लेमी मेको जने चाप्‍नीम। प्रस्‍थान २३:१९; ब्‍यवस्‍था १८:३-४ ");
INSERT INTO suzBl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इस्राएलम आं कली चढ़ेशो मारेइ मारेइ इ केन बाक्‍ब। लेवी २७:२८ ");
INSERT INTO suzBl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","मिनु परमप्रभु यावे कली चढ़ेशो, मुर आन ङोंइती जरमेशो, बी ब्‍यफ क्‍यारश भेडा आन ङोंइती जरमेशो नेल्‍ल इ केन बाक्‍नीम। मो दुम्‍त हना यो, गे मुर आ ङोंइती जरमेशो कली प्रोंइचा माल्‍नेवे। ग्रांग्रा दिशो बस्‍तु भाव आन ङोंइती जरमेशो यो प्रोंइचा माल्‍नेवे। प्रस्‍थान १३:२; प्रस्‍थान ३४:१९-२० ");
INSERT INTO suzBl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","मेको आन कली प्रोंइतीक क्‍येट महिना का गाप्‍शो कली चांदी के ५ शेकेल ताक्‍चा माल्‍नेवे। मेको ताम्‍बु ङा शेकेल बाक्‍चा माल्‍नीम। मेको ताम्‍बु ङा शेकेल का २० गेराह ङा बाक्‍ब। गेराह का ०.६ ग्राम बाक्‍ब। ताम्‍बु ङा शेकेल का १२ ग्राम ङा क्‍येट बाक्‍ब।लेवी २७:६,२७ ");
INSERT INTO suzBl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","मिनु बी, भेडा क्‍यारश आन ङोंइती जरमेशो आन कली प्रोंइने मचाप्‍नीम। मेको आं केन बाक्‍नीम। गे मेको आन हुश चढ़ेतीकेमी ब्रुइक्‍चा माल्‍नेवे। मिनु मेको आन बोंसो चोचा माल्‍नेवे। मेको परमप्रभु यावे कली आ दाक्‍चा ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","तन्‍न आन श्‍ये इ केन बाक्‍ब। मेको क्‍युक्‍शा चढ़ेशो कुथ्रु नु ग्‍युरा फिला खोदेंशो पा इ केन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","मिनु इस्राएलीपुकीमी आं कली चढ़ेशो नेल्‍ल इ कली नु इ तमी तौ आन कली गेना हना यो कली गेतन्‍नी। मेको इ कली नु इ चच युइ आन कली परमप्रभु यावे आ ङोंइती गेना हना यो लीशो हिक्‍सी आ कबल पशो बाक्‍ब” देंत। लेवी २:१३; २इतिहास १३:५ ");
INSERT INTO suzBl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","मिनु नोले परमप्रभु यावेमी हारून कली “गे मेको रागीम मुर आन दातेमी रू मताइनीनी। गो इस्राएली आन दातेमी इन भाग नु इन शोंप नङ। गन्‍ती ३५:-; ब्‍यवस्‍था १०:९; ब्‍यवस्‍था १२:१२; यहोसु १३:१४,३३; भजन संग्रह १६:५; भजन संग्रह ७३:२६; इजीकीएल ४४:२८ ");
INSERT INTO suzBl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","गो लेवी आ मुर आन कली ग्रुम्‍तीक ताम्‍बुमी गेय पचा कली इस्राएली नेल्‍ल आन १० भाग ङा भाग का गेतामी। लेवी २७:३० ");
INSERT INTO suzBl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","मुल रे इस्राएलीपुकी ग्रुम्‍तीक ताम्‍बु आ नेक्‍था जाक्‍ने मचाप्‍नीम। जाक्‍तेक्‍म हना, पापम पतीकेमी बेक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","तन्‍न लेवीपुकीमी ग्रुम्‍तीक ताम्‍बु ङा गेय पचा माल्‍नीम। मेकोपुकीमी पाप पाम्‍तेक्‍म हना, मेको आंमा कुरचा माल्‍नीम। मेको इन कली गेना हना यो लीब शेंतीके बाक्‍ब। तन्‍न मेकोपुकीमी इस्राएली आन दातेमी रू मताइनीम। ");
INSERT INTO suzBl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","मारदे हना गो लेवी आन कली इस्राएली आन परमप्रभु यावे कली चढ़ेशो १० भाग ङा भाग का गेतामी। मोपतीके गो मेको आन कली ‘गे इस्राएली आन दातेमी रू मताइनीनी’ देंती” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“गे लेवी आन कली ‘परमप्रभु यावेमी इन कली मुर आन गुइ रे इन भाग दुम्‍चा कली गेशो, इस्राएली आ १० भाग ङा भाग का ताक्‍नीनु, गेपुकीम मेको रे यो परमप्रभु यावे कली १० भाग ङा भाग का तिल्‍शा, गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","मिनु मेको अन्‍न नु अङगुर शांबु मुर आन रे चाक्‍शो भाग खोदेंशो मिम्‍सीब। ");
INSERT INTO suzBl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","मोपा गे इस्राएली आन रे ताक्‍शो १० भाग ङा भाग का नेल्‍ल रे तिल्‍शा परमप्रभु यावे कली १० भाग ङा भाग का गेचा माल्‍नीनी। मेको चढ़ेब हारून कली गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","मिनु गे मार मार ताक्‍नी, मेको नेल्‍ल रे परमप्रभु यावे आ भाग तिल्‍चा माल्‍नीनी’ दे माइक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","मिनु गे मेको आन कली ‘गेपुकीमी नेल्‍ल क्‍येङा रिम्‍शो भाग तिल्‍नी नोले, मेको लीशो इन रू रे रुप्‍शो अन्‍न नु इन अङगुर रू ङा शांबु खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","मिनु गे नु इन खिं ङा मुर नेल्‍ले ते ते जचा दाक्‍नीनी, मेक मेक जने चाप्‍नीनी। मारदे हना मेको इन ग्रुम्‍तीक ताम्‍बुमी गेय पशो ङा गाल्‍च बाक्‍ब। मत्ती १०:१० ");
INSERT INTO suzBl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","मिनु गे मेको आन नेल्‍ल क्‍येङा रिम्‍शो भाग गेतीके इन कली मारेइ दोस मदुम्‍ब। तन्‍न इस्राएलीपुकीम आन परमप्रभु यावे कली गेशो थोव़क दूली पा मचलेने। मो पाइतीनी हना गे बेक्‍नीनी’ दे माइक्‍चा माल्‍नेवे” दे परमप्रभु यावेमी मोसा कली देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","परमप्रभु यावेमी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“गे इस्राएली आन कली ‘परमप्रभु यावेमी ब्रेक्‍शा अरेशो पचा माल्‍शो लोव़ का एको बाक्‍ब। गेपुकी थम रिम्‍शो मारेइ मदुम्‍शो गेनायो जवा मलाप्‍शो लल बी का आंस बाक्‍तीक चाक्‍कीन’ देनीस। हिब्रू ९:१३; लेवी २२:२०; ब्‍यवस्‍था २१:३ ");
INSERT INTO suzBl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","मिनु गे मेको बी कली चढ़ेब एलाजर कली गेसे। मिनु मेकोमी मेको बी कली मुर आन बाक्‍तीक रे ङोन लाइश्‍शा, आ ङोंइती मेको कली क्‍योरपाइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","मिनु चढ़ेब एलाजरमी आ ब्रेप्‍चोमी आ हुश ख्रुम्‍शा, ग्रुम्‍तीक ताम्‍बु आ ङोंइती ७ खेयप ब्रुइक्‍चा माल्‍ब। लेवी ४:६,१७ ");
INSERT INTO suzBl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","मिनु नोले मेको बी चढ़ेब आ ङोंइती चोचा माल्‍ब। आ कुशुल, आ श्‍ये, आ हुश नु गोबर सुन्‍दा चोचा माल्‍ब। लेवी ७:८; लेवी ४:११-१२ ");
INSERT INTO suzBl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","मिनु चढ़ेबमी लेबानोन ङा लाइश्‍शो रवा आ शी, हिस्‍सोप के ब्राक्‍स, लल रङ ङा ऊन चाक्‍शा, मेको बी कली जेन्‍ना जेन्‍न पशो मीम हुम्‍चा माल्‍ब। लेवी १४:६ ");
INSERT INTO suzBl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","मेको नोले चढ़ेबमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। नोले मेको मुर आन बाक्‍तीके लेन्‍ने चाप्‍ब। तन्‍न मेको चढ़ेब नां मलाक्‍गा सम्‍म ग्रांग्रा दिशो बाक्‍ब। लेवी १६:२८ ");
INSERT INTO suzBl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","मिनु नोले मेको बी चोइ‍बमी आ वा मुरशा, चिक्‍सीचा माल्‍ब। मेको नां मलाक्‍गा सम्‍म ग्रांग्रा दिशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","मिनु ग्रांग्रा मदिशो मुर कामी मेको बी कली चोशो पुलु खुप्‍शा, मुर आन बाक्‍तीके रे ङोन ग्रांग्रा मदिशो बाक्‍तीकेम वोइक्‍चा माल्‍ब। मेको इस्राएली आन कली चोव़खेतीक ब्‍वाक्‍कु सेल्‍चा कली बाक्‍ब। मेको चोव़खेसीचा कली चढ़ेतीक बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","मिनु मेको बी चोशो पुलु हुइक्‍बमी यो आ वा मुरचा माल्‍ब। मिनु नां मलाक्‍गा सम्‍म मेको ग्रांग्रा दिशा बाक्‍ब। मेको इस्राएलीपुकी नु मेकोपुकी नु बाक्‍ब अर्को रागी ङा मुर नेल्‍ल आन कली पचा माल्‍शो गेय बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","मिनु सुमी बेक्‍शो मुर कली थीबा, मेको ७ नाक्‍त सम्‍म ग्रांग्रा दिशोन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","मिनु मेकोम मेको सां नाक्‍तीम ब्‍वाक्‍कु चोव़खेसीचा माल्‍ब। मिनु ७ नाक्‍तीम लेंशा चोव़खेसीचा माल्‍ब। मिनु मेको ग्रांग्रा मदिशो दुम्‍ब। तन्‍न मेकोमी सां नाक्‍त नु ७ नाक्‍त मचोव़खेसाक्‍व हना, मेको ग्रांग्रा दिशा बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","मिनु सुमी बेक्‍शो मुर थिशा, मचोव़खेसीबा, मेकोमी परमप्रभु यावे आ ताम्‍बु ग्रांग्रा दिशो सेल्‍ब। मेको मुर इस्राएली आन दाते रे तिल्‍चा पुंइसीब। मारदे हना चोव़खेतीक ब्‍वाक्‍कु मेको आ तार मब्रुइश्‍शो बाक्‍ब। मोपतीके मेको ग्रांग्रा दिशो बाक्‍ब। मिनु मेको आ ग्रांग्रा दितीके मेको नु लीब। लेवी १५:३१ ");
INSERT INTO suzBl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","मिनु मुर आ ताम्‍बुम बेक्‍त हना, मेको आ पर्बम पचा माल्‍शो गेय मार बाक्‍ब देंशा हना, सु मेको ताम्‍बुम बाक्‍बा, सु मेको ताम्‍बुम जाक्‍बा, मेको ७ नाक्‍त सम्‍म ग्रांग्रा दिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","मिनु मसुम्‍शो ग्‍योंब नेल्‍ल ग्रांग्रा दिशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","मिनु सुमी लांम तरवारम साइक्‍चा पुंइसीशो मुर बाक्‍त हना यो, आंमा बेक्‍शो मुर बाक्‍त हना यो, मुर आ रुश बाक्‍त हना यो, मेको थीब मुर ७ नाक्‍त सम्‍म ग्रांग्रा दिशो दुम्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","मिनु मुरुमी मेको ग्रांग्रा दिशो मुर कली चोव़खेचा कली चढ़ेतीक पुलु ग्‍योंबुम कुर पा नक ब्‍वाक्‍कु लुक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","मिनु नोले ग्रांग्रा मदिशो मुर कामी हिस्‍सोप के ब्राक्‍स मेको चोव़खेतीक ब्‍वाक्‍कुम नुप्‍शा, मेको बेक्‍शो मुर आ ताम्‍बु, मेकेर बाक्‍शो मारेइ मारेइ, मेक बाक्‍ब मुर आन कली, रुश थीब मुर आन कली, साइक्‍चा पुंइसीशो मुर थीब, बेक्‍शो मुर नु तुरस थीब मुर आन कली मेको ब्‍वाक्‍कु ब्रुइक्‍चा माल्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","मिनु ग्रांग्रा मदिशो मुरुमी सां नाक्‍तीम नु ७ नाक्‍तीम ग्रांग्रा दिशो मुर आन कली मेको चोव़खेतीक ब्‍वाक्‍कु ब्रुइक्‍चा माल्‍ब। मिनु ७ नाक्‍तीम मेको आन कली चोव़खेतीके नुप्‍ब। मिनु नोले मेकोपुकीम आन वा मुरशा, आन रां चिक्‍सीचा माल्‍नीम। मिनु मेकोपुकी नां लाक्‍गा नोले ग्रांग्रा मदिशो दुम्‍नीम। गन्‍ती १९:१२-१३ ");
INSERT INTO suzBl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","मिनु सु ग्रांग्रा दिशो दुम्‍शा यो, मचोव़खेसीबा, मेकोमी परमप्रभु यावे आ ताम्‍बु ग्रांग्रा दिशो सेल्‍ब। मेको मुर इस्राएली आन दाते रे तिल्‍चा पुंइसीब। मारदे हना चोव़खेतीक ब्‍वाक्‍कुम मेको कली मब्रुइश्‍शो बाक्‍ब। मोपतीके मेको ग्रांग्रा दिशोन बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","मिनु मेको, मेको कली गेना हना यो आ पतीक दुम्‍ब। मिनु मेको ब्‍वाक्‍कु ब्रुइक्‍ब मुरुम आ वा मुरचा माल्‍ब। मिनु सुमी चोव़खेतीक ब्‍वाक्‍कु थीबा, मेको नां मलाक्‍गा सम्‍म ग्रांग्रा दिशो दुम्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ग्रांग्रा दिशो दुम्‍शो मुरुमी मार थिवा, मेको नेल्‍ल ग्रांग्रा दिशो दुम्‍नीम। मिनु सुमी मेको ग्रांग्रा दिशो थोव़क थीबा, मेको यो नां मलाक्‍गा सम्‍म ग्रांग्रा दिशो दुम्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","मिनु ङोंइती ङा महिनाम इस्राएली नेल्‍ले जीन ङा गोरशो रागीम जाक्‍तेक्‍म। मिनु कादेशमी बाक्‍तीक सेल्‍शा बाक्‍तेक्‍म। मिनु मिरयाम मेक उइ बेक्‍त। मिनु मेक उइ थिम्‍तेक्‍म। गन्‍ती १३:२१; गन्‍ती १२:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","मिनु मेकेर मुर आन कली ब्‍वाक्‍कु मबा। मिनु मुरपुकी मोसा नु हारून आस पर्बम मरिम्‍शो पा बुक्‍तेक्‍म। प्रस्‍थान १७:१-७ ");
INSERT INTO suzBl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","मिनु मेकोपुकीमी मोसा कली जिचा तोशा मेको कली “गो आंइ लोक्‍बपुकी परमप्रभु यावे आ ङोंइती बेक्‍मानु, गोपुकी यो बेक्‍शो नकी हना, रिम्‍शो दुम वा। ");
INSERT INTO suzBl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","गे मारदे परमप्रभु यावे आ मुर, आंइ कली एको गोरशो रागीम चाक्‍नी? मुल गोपुकी नु आंइ बी ब्‍यफ, क्‍यारश भेडा नेल्‍ल एक बेक्‍ब दुम्‍तक। ");
INSERT INTO suzBl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","गे मारदे आंइ कली इजीप्‍त रे एको मरिम्‍शो रागीम चाक्‍नी। एको रागीम अन्‍न, फोव़शी, अङगुर नु अनार मारेइ मथिंसीब। एकोक्‍के तूचा कली ब्‍वाक्‍कु यो मबा” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मिनु नोले मोसा नु हारून मुर आन बाक्‍तीक रे लशा, ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेमी खुम्‍की पा बाप्‍ताक्‍स। मिनु परमप्रभु यावे आ छेङछेङ मेको आस ङोंइती ग्रूत। ");
INSERT INTO suzBl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“एको कोक्‍के लतो। मिनु गे नु इ लोक्‍ब हारून लशा, मुर आन कली पुक्‍कीस। मिनु मेको आन ङोंइतीन एको फुल्‍लु कली हुकुम पावो। मिनु फुल्‍लु रे ब्‍वाक्‍कु यीब। मिनु गे मुर आन ङोंइती एको सेरथे फुल्‍लु कली ‘ब्‍वाक्‍कु बुक्‍को’ दे मतो। मोपा गे मुर आन कली मेको सेरथे फुल्‍लु रे ब्‍वाक्‍कु यिपाइक्‍नेवे। गे मोपा मुर नु मेको आन बी ब्‍यफ क्‍यारश भेडा आन कली तूचा गेनेवे” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","मिनु मोसामी मेको कोक्‍के परमप्रभु यावेम देंशो खोदेंशो पा ताक्‍तु। गन्‍ती १७:२५ ");
INSERT INTO suzBl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मिनु मोसा नु हारूनमी मुर नेल्‍ल आन कली सेरथे फुल्‍लु आ ङोंइती पुक्‍ताक्‍स। मिनु मोसाम मेको आन कली “गे गन गन पाइबपुकी नेनीन। मार, गो एको सेरथे फुल्‍लु रे इन कली ब्‍वाक्‍कु बुक्‍पाइश्‍शा गेन्‍नी?” दे माइक्‍तीमी। भजन संग्रह १०६:३२-३३ ");
INSERT INTO suzBl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","मिनु मोसामी आ गुइ क्‍युक्‍शा आ कोक्‍केमी निक्‍शी खेयप मेको सेरथे फुल्‍लु कली तुप्‍तु। मिनु मेकेर शुश ब्‍वाक्‍कु बुक्‍शा ग्रूत। मिनु मुरपुकी नु आन बी ब्‍यफ, क्‍यारश भेडामी तूतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","तन्‍न परमप्रभु यावेमी मोसा नु हारून आस कली “गे आं कली थमा मसुइक्‍तीके नु आं ठेयब सक्ति इस्राएली आन ङोंइती मकोंइतीके, गे एको मुर आन कली गो इन कली गेशो रागीम चाक्‍दीत्‍चा मताइनीसी” देंत। गन्‍ती २७:१४; ब्‍यवस्‍था १:३७; ब्‍यवस्‍था ४:२१; ब्‍यवस्‍था ५०:५१ ");
INSERT INTO suzBl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","मोपतीके मेको ब्‍वाक्‍कु कली मेरीबा ङा ब्‍वाक्‍कु देंसीब। मेकेर इस्राएलीपुकीमी परमप्रभु यावे कली जिचा तोम्‍तेक्‍म। मिनु मेकोमी आ सक्ति कोंइताक्‍व। भजन संग्रह ८१:८ ");
INSERT INTO suzBl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मिनु मोसामी कादेश रे एदोम ङा पिप कली “इन लोक्‍ब इस्राएलमी इन कली ‘गो आंइ कली दुम्‍शो श्‍येत गे तुइक्‍नीनी। उत्‍पत्ती ३६:१,३१; ब्‍यवस्‍था २:१-८; ब्‍यवस्‍था २३:८ ");
INSERT INTO suzBl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","आंइ किकी पिपी इजीप्‍त लशा, मेकेर शुश बाक्‍शो बाक्‍तेक्‍म। मिनु इजीप्‍तीपुकीमी आंइ किकी पिपी नु आंइ कली दिप्‍शा, मरिम्‍शो पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","मिनु गोपुकीमी परमप्रभु यावे कली पुंइतक। मिनु मेकोमी आंइ पुंइशो नेंशा, आ स्‍वर्ग ङा गेय पाइब का सोइश्‍शा, गो आंइ कली इजीप्‍त रे ग्रुंइशा एक चाक्‍तु। मुल गो इन रागी ङा सांद कादेश देंशो सहरम बाक्‍शो बाक्‍नीकी। प्रस्‍थान २३:२० ");
INSERT INTO suzBl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","मिनु गो आंइ रागी रे पा लचा गेने। गोपुकी रू नु अङगुर रू रे पा मलाइनीकी। गोपुकीम इन तेकोइ इनार ङा ब्‍वाक्‍कु मतूनीकी। गो पिप आ ठेयब लां रे पा लाइनीकी। इन रागी मलाक्‍का सम्‍म गो ग्‍युरा पेरा मपाइनीकी’ देंशो बाक्‍ब, देनीन” दे मुर सोइक्‍ताक्‍मी। गन्‍ती २१:२२; ब्‍यवस्‍था २:१-८; न्‍यायाधीस ११:१७ ");
INSERT INTO suzBl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","तन्‍न एदोममी मेको कली “गेपुकी एको रागी रे पा लचा मताइनीनी। मो पाइतीनी हना, गोपुकीमी गेपुकी इन कली लडाइ तोइनीकी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","मिनु इस्राएलीपुकीमी मेको कली “गोपुकी ठेयब लां रे पा लाइनीकी। मिनु गो नु आंइ बी ब्‍यफ क्‍यारश भेडामी इन ब्‍वाक्‍कु तूतक हना, मेको ङा क्‍येट थाप्‍नीकी। आंइ कली इन रागी रे पा ला लचा गेने” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","तन्‍न मेकोपुकीमी “गेपुकी लचा मताइनीनी” देंतेक्‍म। मिनु एदोममी मेको आन कली लडाइ तोचा कली शुश या कुरशा, ठेयब हुल लडाइ पाइब चाक्‍शा जाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","मोपा एदोममी इस्राएली आन कली आ रागी रे पा लचा मगेमी। मोपतीके इस्राएलीपुकी मेकेर रे लेत्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","मिनु इस्राएली कादेश रे गाक्‍शा, होर डांडामी जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","मिनु नोले परमप्रभु यावेमी एदोम रागी ङा सांद ङा होर डांडामी मोसा नु हारून आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून आ किकी पिपी नु बाक्‍थ लाइब। गे निम्‍फा मेरीबा ङा ब्‍वाक्‍कुम आं देंशो मटितीके, गोम इस्राएली आन कली गेशो रागीम हारून ओव़चा मताइब। ");
INSERT INTO suzBl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून नु मेको आ तौ एलाजर आस कली होर डांडा लाइश्‍शा लावो। ");
INSERT INTO suzBl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","मिनु हारून आ वा प्रुइश्‍शा, मेको आ तौ एलाजर कली फेक्‍तो। मेको नोले हारून आ किकी पिपी नु बाक्‍थ लचा कली बेक्‍ब” देंत। प्रस्‍थान २९:४-७ ");
INSERT INTO suzBl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मिनु मोसामी परमप्रभु यावे आ देंशो खोदेंशो पा पाप्‍तु। मिनु मुर नेल्‍ल आन ङोंइती रे मेकोपुकी होर डांडा लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मिनु मोसामी हारून आ वा प्रुइश्‍शा, आ तौ एलाजर कली फेक्‍ताक्‍व। मिनु हारून मेको डांडा तार बेक्‍त। मिनु मोसा नु एलाजर मेको डांडा रे ब्रुप्‍ताक्‍स। गन्‍ती ३३:३८-३९; ब्‍यवस्‍था १०:६ ");
INSERT INTO suzBl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","मिनु इस्राएली नेल्‍लेमी हारून बेक्‍शो तुइश्‍शा, ३० नाक्‍त सम्‍म रोंका पाम्‍तेक्‍म। ब्‍यवस्‍था ३४:८ ");
INSERT INTO suzBl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","मिनु नेगेबम बाक्‍ब कनानी आराद ङा पिपम इस्राएली अथारीम ङा लां रे पा पिना पिन बाक्‍नीम, देंशो लोव़ नेंतु। मिनु मेकोमी इस्राएली नु लडाइ पा, इस्राएली का निक्‍शी आन कली ग्‍याइक्‍ताक्‍व। गन्‍ती १४:४४,४५; न्‍यायाधीस १:११-१५ ");
INSERT INTO suzBl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","मिनु इस्राएलीपुकीमी परमप्रभु यावे कली “गे एको मुर आन कली थमा पा आंइ गुइमी गेतीनी हना, गोपुकीमी मेको आन सहर नेल्‍ल रोवल चिवल पोक्‍नीकी” दे कसम जाम्‍तेक्‍म। ब्‍यवस्था १३:१६; ब्‍यवस्‍था २०:१४,१६,१७; यहोसु ६:१७; न्‍यायाधीस १:१७; १सामुएल १५:३ ");
INSERT INTO suzBl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","मिनु परमप्रभु यावेमी इस्राएली आन पुंइशो लोव़ नेंशा, मेको कनानी आन कली मेको आन गुइमी गेप्‍तु। मिनु इस्राएलीपुकीम मेकोपुकी नु मेको आन सहर नेल्‍ल खतम पोक्‍तेक्‍म। मोपतीके मेको रागी आ नें होरमा वोइक्‍तेक्‍म। होरमा हिब्रू लोव़मी खतम दुम्‍तीके देंसीब।गन्‍ती १४:१४,४५; ब्‍यवस्‍था १:४४ ");
INSERT INTO suzBl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","मिनु मेकोपुकी एदोम रागी कली हेरशा लचा, दे होर डांडा रे लल समुन्‍द्र गे लाम्‍तेक्‍म। तन्‍न मुरपुकी शुश गाक्‍चा माल्‍तीके दाम्‍तेक्‍म। गन्‍ती ११:४-६ ");
INSERT INTO suzBl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","मिनु मेकोपुकीम परमप्रभु नु मोसा आस पर्बम गन गन पा “मारदे गे आंइ कली एको गोरशो रागीम बेक्‍पाइक्‍चा कली इजीप्‍त रागी रे ग्रुंइशा एक चाक्‍सी? एकेर जचा थोव़क मबा। ब्‍वाक्‍कु यो मबा। गो एको मब्रोव़शो जचा थोव़क क्‍येङा ब्रीताक्‍क” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","मिनु नोले परमप्रभु यावेमी बीस पाइश्‍शो बुस्‍स मेको मुर आन दातेमी सोइक्‍ताक्‍व। मिनु बुस्‍सपुकीमी मुर आन कली कोक्‍तेक्‍म। मिनु शुश इस्राएली बेक्‍तेक्‍म। १कोरिन्‍थी १०:९ ");
INSERT INTO suzBl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","मिनु मुरपुकी मोसा आ बाक्‍तीक जाक्‍शा “गोपुकीम परमप्रभु यावे नु इन पर्बम मरिम्‍शो लोव़ पा पाप पाइतक। मेको बुस्‍सपुकी खेरचा, दे परमप्रभु यावे कली आंइ पर्बम पुनीन” देंतेक्‍म। मिनु मोसामी मेको मुर आन पर्बम पुंइतु। प्रस्‍थान ३२:३०-३४ ");
INSERT INTO suzBl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","मिनु परमप्रभु यावेमी मोसा कली “गे मेको बीस पाइश्‍शो बुस्‍स खोदेंशो पा बुस्‍स का सेल्‍शा, ख्रांबा काम क्‍युक्‍को। मिनु सु बुस्‍सुम कोक्‍शो बाक्‍मे, मेकोमी मेको बुस्‍स कोव़शा, ब्रोंइब” देंत। २राजा १८:४; यूहन्‍ना ३:१४ ");
INSERT INTO suzBl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","मिनु मोसाम कांसा के बुस्‍स का सेल्‍तु। मिनु मेको कली ख्रांबा काम क्‍युक्‍तु। मिनु सु सु बुस्‍सुमी कोक्‍शो बाक्‍मा, मेकोपुकीम कांसा के बुस्‍स कोव़ङमेनु, ब्रोंइतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","मिनु इस्राएलीपुकी गाक्‍शा, ओबोथम बाक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","मिनु ओबोथ रे गाक्‍शा, मोआब आ पूर्ब गे ङा सांद इये-अबारीम ङा गोरशो रागीम बाक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","मिनु मेकोपुकी मेकेर रे गाक्‍शा, जेरेद ङा बेंसीम बाक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","मिनु मेकोपुकी मेकेर रे गाक्‍शा, एमोरी आन सांदम ग्रूतीक गोरशो रागीम बाक्‍शो अरनोन खोला आ आइक्‍ची हांबुम आन बाक्‍तीक सेल्‍तेक्‍म। मेको अरनोन खोला मोआब आ सांद बाक्‍ब। मेको एमोरी नु मोआबी आन दातेम बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","मोपतीके परमप्रभु यावे आ लडाइ ङा किताबमी दोपा ब्रेक्‍शो बाक्‍ब देंशा हना “वाहेब सहर सुफाह नु अरनोन खोला आ दिंम, यहोसु १०:१३; २सामुएल १:१८ ");
INSERT INTO suzBl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","नु आर माइश्‍शो बाक्‍तीके सम्‍म लाइब लुक्‍च लतीक लां। मेको मोआब आ सांद सम्‍म लशो बाक्‍ब” देंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","मिनु मेकेर रे मेकोपुकी बेयर लाम्‍तेक्‍म। मिनु परमप्रभु यावेमी मोसा कली “मुर आन कली पुक्‍मी। मिनु गो ब्‍वाक्‍कु गेनुङमी” देंशो कुवा मेकेर बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","मिनु नोले इस्राएलीपुकीम एको कुम्‍सो पाम्‍तेक्‍म। “कुवा, ब्‍वाक्‍कु बुक्‍शा ग्रूङो। मिनु मेको आ पर्बम कुम्‍सो पावो। ");
INSERT INTO suzBl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","मेको कुवा मेको ठेयब मुरपुकीम दोशो बाक्‍तेक्‍म। मिनु मुरपुकीमी मेको कुवा पिप आ सुन के कोक्‍केम दोशो बाक्‍तेक्‍म” दे कुम्‍सो पाम्‍तेक्‍म। मिनु मेकोपुकी गोरशो रागी रे ग्रूशा मत्ताना लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मिनु नोले मत्ताना रे नाहालीएल, नाहालीएल रे बामोथ सम्‍म ");
INSERT INTO suzBl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","बामोथ रे मोआब ङा दिंम बाक्‍शो बेंसी सम्‍म, गोरशो रागी रे तांइसीतीक इर पिस्‍गा डांडा सम्‍म लाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","मिनु नोले इस्राएलीपुकीमी एमोरी आन पिप सीहोन आ बाक्‍तीकेम मुर आन कली सोइश्‍शा ब्‍यवस्‍था २:२६-३७ ");
INSERT INTO suzBl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“गो आंइ कली इन रागी रे पा लचा गेने। गो रू नु अङगुर रू रे पा मलाइनीकी। गोपुकीम इन तेकोइ कुवा ङा ब्‍वाक्‍कु मतूनीकी। इन रागी मलाक्‍का सम्‍म गो पिप आ ठेयब लां रे पा लाइनीकी” देंपाइक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","तन्‍न सीहोनमी इस्राएली आन कली आ रागी लाक्‍शा लचा मगेवो। मेकोम आ लडाइ पाइबपुकी खुप्‍शा, गोरशो रागीम इस्राएली आन कली लडाइ तोप्‍तु। मेकोमी याहास सम्‍म जाक्‍शा, इस्राएली नु लडाइ पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","मिनु इस्राएलीपुकीम मेको कली तरवारम क्‍योरशा साइक्‍तेक्‍म। मिनु अरनोन खोला रे यब्‍बोक खोला सम्‍म मेको आ रागी आन के सेल्‍तेक्‍म। मिनु अम्‍मोनी आन सांद सम्‍म मेकोपुकीम आन रागी सेल्‍तेक्‍म। मारदे हना, अम्‍मोनी आन सांद बोल्‍यो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएलीपुकीम मेको सहर नेल्‍ल आन के सेल्‍तेक्‍म। मिनु मेकोपुकीम एमोरी आन सहर नेल्‍ल नु हेश्‍बोन नु मेको आ एर ओंथ ङा गाउं नेल्‍लेम बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेश्‍बोन सहर एमोरी आन पिप सीहोन आ सहर बाक्‍त। पिप सीहोनमी मोआबी आन ङोंइती ङा पिप नु लडाइ पा मेको आ रागी अरनोन खोला सम्‍म आ के सेल्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","मोपतीके कुम्‍सो पाइबपुकीम “गेपुकी हेश्‍बोन सहरम जाक्‍कीन। मिनु मेको लेंशा सेल्‍सीन। सीहोन आ सहर लेंशा सेलीन। ");
INSERT INTO suzBl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हेश्‍बोन रे मी ग्रूत। सीहोन आ सहर रे ब्रशो मी ग्रूत। मिनु मेको मीम मोआब ङा आर सहर नु अरनोन ङा डांडा दाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","आबी आबी, मोआब, केमोश आ मुरपुकी बेक्‍तेक्‍म। एमोरी आन पिप सीहोनमी मेको आ तौ आन कली प्रोक्‍ब सेल्‍तीमी। आ तमी आन कली ग्‍याइक्‍चा पुंइसीब सेल्‍तीमी। न्‍यायाधीस ११:३४; १राजा ११:१७ ");
INSERT INTO suzBl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","मोपा मेको आन थेरशो रू हेश्‍बोन रे दीबोन सम्‍म खतम दुम्‍त। मिनु मेदेबा मीम नेक्‍चा क्‍येङा ङोंइती गो मेको खतम पोक्‍तका” दे कुम्‍सो पाम्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","मोपा इस्राएलीपुकी एमोरी आन रागीम आन खिं सेल्‍‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मिनु मोसामी याजेर रागी कली क्‍यारी पथ मुर सोइक्‍ताक्‍व। मिनु मेकोपुकीमी मेको आन एर ओंथ ङा गाउं आन के सेल्‍तेक्‍म। मेकेर ङा एमोरी आन कली खेरतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","मेको नोले मेकोपुकी हिरशा बाशान ङा लां रे पा ङोइश्‍शा लाम्‍तेक्‍म। मिनु बाशान ङा पिप ओग नु आ मुरपुकी इस्राएली नु लडाइ पचा कली ग्रूशा एद्रेइमी जाक्‍तेक्‍म। ब्‍यवस्‍था ३:१-११ ");
INSERT INTO suzBl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","मिनु परमप्रभु यावेमी मोसा कली “मेको नु महिंनो। मारदे हना गो मेको कली आ मुर नेल्‍ल नु मेको आ रागी यो यो इ कली गेतन। गे हेश्‍बोन ङा एमोरी आन पिप सीहोन कली पाइश्‍शो खोदेंशो पा मेको कली यो पतो” दे माइक्‍तु। भजन संग्रह १३६:१७-२२ ");
INSERT INTO suzBl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","मोपतीके मेको कली, मेको आ तौपुकी नु मेको आ मुर नेल्‍ल आन कली का यो मप्रोंइथु साइश्‍शा, मेको आन रागी आन के सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","मिनु इस्राएलीपुकी गाक्‍शा, यरीको यर्दन खोला आ आइक्‍ची हांबुम बाक्‍शो मोआब ङा दिंममी बाक्‍तीक सेल्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","मिनु सिप्‍पोर आ तौ बालाकमी इस्राएलीपुकीम एमोरी आन कली मार पाइश्‍शो बाक्‍मा, मेको नेल्‍ल तुइश्‍शो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","मिनु मोआब ङा मुर इस्राएली आन कली तशा साप्‍पा हिंतेक्‍म। मारदे हना मेको शुश बाक्‍तेक्‍म। मोपतीके मेको आन थुं ग्‍येत्‍थ लुक्‍च दुम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मिनु मोआबीपुकीमी मिदयान ङा खाल्‍पा आन कली “दोपा ब्‍यफोम घांस बाक्‍तीक दिंम चाइश्‍शा घांस नेल्‍ल ब्‍वाइबा, मोपा एको हुलपुकीमी इं कली एर ओंथ नेल्‍ल रे ब्‍वाइनीम” देंतेक्‍म। मेना सिप्‍पोर आ तौ बालाक मोआब ङा पिप बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","मेकोमी आमाव रागी युफ्रेटीस माइश्‍शो ठेयब खोला आ नेक्‍था, पेथोर सहरम बाक्‍शो बेओर आ तौ बालाम कली मुरपुकी ब्रथ सोइक्‍ताक्‍व। मेकोपुकीमी “इजीप्‍त रे जाक्‍शो मुरुम रागी नेल्‍ल ब्रीतेक्‍म। मेकोपुकी आं नेक्‍था जाक्‍शा बाक्‍शो बाक्‍नीम। गन्‍ती ३१:८; यहोसु २४:९; मीका ६:५ ");
INSERT INTO suzBl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","मुल गे जाक्‍को। आं कली वारच पा, मेको मुर आन कली सराप चीले पाइक्‍मी। मारदे हना मेकोपुकी आं क्‍येङा शुश नु बोल्‍यो बाक्‍नीम। मो पाइतीनी हना, गो मेको आन कली ग्राशा, आं रागी रे ग्रुंइने चबु वा। मारदे हना गे सु कली आसीक गेनीनी, मेको आसीक राइनीम। मिनु सु कली सराप चीले पाइनीनी, मेको सराप चीले राइनीम, दे गो तुइक्‍नुङ” दे सोइक्‍ताक्‍व। २पत्रुस २:१५ ");
INSERT INTO suzBl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मिनु मोआब नु मिदयान ङा खाल्‍पापुकीम मेको गेय पचा कली क्‍येट कुरशा, बालाम आ बाक्‍तीक जाक्‍शा, बालाक आ लोव़ शोव़तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","मिनु बालाममी मेको आन कली “मुलाक्‍दो एकेन बाक्‍कीन। मिनु परमप्रभु यावेमी आं कली मार देंबा, गो मेकोन इन कली देंनुङ” देंत। मोपतीके मेको मोआब ङा ठेयब गेय पाइब मुरपुकी मेको नाक्‍दो बालाम आ खिं उइ बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","मिनु परमप्रभु बालाम आ बाक्‍तीक जाक्‍शा, मेको कली “गे नु बाक्‍ब मुरपुकी सु नमी?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","मिनु बालाममी परमप्रभु कली “मोआब ङा पिप, सिप्‍पोर आ तौ बालाकमी आं कली ");
INSERT INTO suzBl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘इजीप्‍त रे ग्रूशा जाक्‍शो मुरपुकीम रागी नेल्‍ल ब्रीशो बाक्‍नीम। मुल जाक्‍शा आं कली वारच पा मेको आन कली सराप चीले पाइक्‍मी। मो दुम्‍त हना, गो मेको आन कली लडाइ पा ग्राशा, खेरने चाप्‍नुङ ङा कों?’ दे लोव़ कुर पा सोइश्‍शो मुर बाक्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","मिनु परमप्रभुमी बालाम कली “गे एकोपुकी नु मलावो। गे मेको मुर आन कली सराप चीले मपाइक्‍मी। मारदे हना मेकोपुकी आसीक रशो बाक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","मिनु बालाम सुनी कना बोक्‍शा, मेको बालाक आ सोइश्‍शो मुर आन कली “गेपुकी इन रागी लने। मारदे हना, परमप्रभु यावेमी आं कली गेपुकी नु लचा मगेयी” दे माइक्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","मिनु मोआब ङा ठेयब मुरपुकी बालाक आ बाक्‍तीक जाक्‍शा “बालाम गोपुकी नु जाक्‍ने मबिस्‍से” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","मिनु बालाकमी लेंशा, मेको आन क्‍येङा ठेयब नु शुश मुरपुकी सोइक्‍ताक्‍मी। ");
INSERT INTO suzBl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","मिनु मेकोपुकी बालाम आ बाक्‍तीक जाक्‍दीश्‍शा “सिप्‍पोर आ तौ बालाकमी इन कली ‘आं बाक्‍तीक जाक्‍चा मारेइम मतेक्‍गल। ");
INSERT INTO suzBl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","गो थमा पा इ कली मान पशा, ठेयब सेल्‍नुङ। गे मार देंनीनी, गो मेकोन पाइनुङ। मिनु जाक्‍शा, मेको मुर आन कली सराप चीले पाइक्‍मी’ देंत” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","तन्‍न बालाममी बालाक आ गेय पाइब मुर आन कली “बालाकमी सुन नु चांदीम ब्रीशो आ दरवार गेती हना यो, गो परमप्रभु यावे, आं परमप्रभु आ लोव़ आइक्‍च बाक्‍त हना यो, ठेयब बाक्‍त हना यो, मेको लोव़ लाक्‍ने मचाप्‍नुङ। १राजा १३:८ ");
INSERT INTO suzBl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","मिनु अरु आन खोदेंशो पा गेपुकी यो, मुलाक्‍दो एक उइ बाक्‍कीन। मिनु परमप्रभु यावेमी आं कली लेंशा मार मार देंबा गो तुइक्‍नुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","मिनु मेको नाक्‍दो परमप्रभु बालाम आ बाक्‍तीक जाक्‍शा, मेको कली “एको मुरपुकी इ कली ब्रेत्‍थ जाक्‍शो बाक्‍तेक्‍म हना, बोक्‍को, मिनु मेकोपुकी नु लावो। तन्‍न गो इ कली मार देंङा, मेको ला पावो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","मिनु बालाम सुनी कना बोक्‍शा, आ गधा छांदेशा मोआब ङा ठेयब मुरपुकी नु लत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","मिनु मेको मोपा लतीके परमप्रभु गाइक्‍ताक्‍व। मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब कामी मेको कली तेक्‍चा, दे लांम राप्‍शा बाक्‍त। मिनु बालाम आ गधाम ङोइश्‍शा लना लन बाक्‍त। मेको आ गेय पाइब निक्‍शी यो मेको नु गाक्‍शो बाक्‍ताक्‍स। उत्‍पत्ती १६:७ ");
INSERT INTO suzBl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","मिनु मेको गधामी परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब शोइश्‍शो तरवार शेशा, लांम बाक्‍शो ताप्‍तु। मिनु मेको गधा हिंशा, लां रे रूम लत। मिनु बालामम गधा कली लां गे सोइक्‍चा कली तुप्‍तु। यहोसु ५:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब आइक्‍च लांम राप्‍शा बाक्‍त। मेको लां निम्‍फा पटटी गारो प्रोव़शो अङगुर रू आस दातेमी बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","मिनु मेको गधामी परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब कली तशा, गारो गे ढेंसेसीशा गाक्‍त। मिनु बालाम आ खोइली मेको गारोम खोरताक्‍व। मिनु मेकोमी मेको कली लेंशा तुप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","मिनु लेंशा परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब इच्‍का ग्‍येत्‍थ लशा, ग्‍युरा पेरा तेइ रे मलाक्‍चा ङा पा आइक्‍च लांमी राप्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","मिनु बालाम आ गधाम परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब कली तशा, गु ब्रे‍शा बाक्‍त। मिनु बालाम थाम्‍पा गाइश्‍शा, आ गधा कली कोक्‍केमी तुबा बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","मिनु नोले परमप्रभु यावेमी मेको गधा कली ब्‍वाक्‍ब सेल्‍तु। मिनु मेकोमी बालाम कली “गो इन कली मार पङा? मारदे गे आं कली सां खेयप तुप्‍यीनी?” देंत। २ पत्रुस २:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","मिनु बालाममी मेको गधा कली “गे आं कली शाक्‍ती। गो आं गुइम तरवार बाक्‍शो हना, गो इ कली मुलन साइक्‍न वा” दे माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","तन्‍न गधाम बालाम कली “गो ङोंइती रे मुल सम्‍म इन ङोइश्‍शो गधा मनङा ङा? गो ङोंइती इन कली गेनायो ओदेंशो मपङ” देंत। मिनु मेकोमी “मपवी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","मिनु परमप्रभु यावेमी बालाम कली मिक्‍च ताइब सेल्‍तु। मिनु मेकोमी तरवार शोइश्‍शो परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब का लांम राप्‍शो ताप्‍तु। मिनु बालाम खुम्‍की पा बाप्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","मिनु मेको परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी मेको कली “मारदे इ गधा कली खेयप सां तुबी? कोव़ङो, गो इ लां तेक्‍चा कली जाक्‍शो बाक्‍नुङ। मारदे हना गे आं ङोंइती इ द‍ला दाक्‍स पाप्‍तीवी। ");
INSERT INTO suzBl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","इ गधामी आं कली तशा, खेयप सां सम्‍म आं बाक्‍तीक रे प्रोक्‍त। मेकोम आं कली तशा, मप्रोक्‍शो हना, गो इ कली मुल साइक्‍ने थुमु वा। तन्‍न मेको कली चहिं सेसीन सोइक्‍तु वा” दे माइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","मिनु बालाममी परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइब कली “गो पाप पाता। आं लां तेक्‍शा इन राप्‍शो गो मतुइक्‍तु। मिनु इन ङोंइती एको मरिम्‍शो बाक्‍त हना, गो लेश्‍शा लाइनुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","मिनु परमप्रभु यावे आ स्‍वर्ग ङा गेय पाइबमी बालाम कली “एको मुरपुकी नु लावो। तन्‍न गो इ कली मार लोव़ पाइनुङा, गे मेको ला देनो” दे माइक्‍तु। मोपतीके बालाम बालाक आ सोइश्‍शो ठेयब मुरपुकी नु लत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","मिनु बालाकमी बालाम जाक्‍शो नें‍शा, मेकोमी आ रागी आ सुर अरनोन खोला ङा सांद ङा सहर इर-मोआब सम्‍म मेको कली ग्रुम्‍थ लत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","मिनु बालाकमी बालाम कली “गो इन कली ब्रेत्‍थ मुर सोइक्‍ताक्‍ङमी। तन्‍न गे मारदे आं बाक्‍तीक मजाक्‍नी? गो इ कली मान पने मचाप्‍नुङा ङा?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","मिनु बालाममी बालाक कली “मुल गो इन बाक्‍तीके जाक्‍ती। मार देंचा माल्‍नुङा, दे मतुइक्‍नुङ। परमप्रभुम मार देंबा, गो मेको ला देंने चाप्‍‍नुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","मिनु बालाम बालाक नु लत। मिनु मेको नेल्‍ल किरयथ-हुसोथमी जाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","मिनु बालाकमी ब्‍यफ नु क्‍यारश भेडा क्‍योरशा चढ़ेशा, बालाम नु मेको नु बाक्‍ब ठेयब मुर आन कली यो थुल्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","आ दीसा सुनी बालाकमी बालाम कली लाइश्‍शा, बामोथ-बालमी ङोइश्‍शा लत। मिनु मेकेर रे बालाममी इच्‍का मुर आन कली ताप्‍तु। यहोसु १३:१७ ");
INSERT INTO suzBl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","मिनु बालाममी बालाक कली “आं कली ७ ओटा चढ़ेतीक सेलीन। मिनु ७ ओटा ब्‍यफ नु ७ ओटा सांड ठीक सेलीन” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","मिनु बालाकमी बालाममी देंशो खोदेंशो पाप्‍तु। मिनु बालाक नु बालाममी ब्‍यफ का नु सांड का चढ़ेतीक का काम चढ़ेम्‍ताक्‍से। ");
INSERT INTO suzBl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","मिनु नोले बालाममी बालाक कली “गे इन चोशा चढ़ेतीके आ नेक्‍था राप्‍शा बाक्‍कीन। गो चहिं एर गे लाइनुङ। परमप्रभु यावे आं कली ग्रुम्‍थ जाक्‍बा, कों। मिनु मेकोमी आं कली मार कोंइबा, मेको इन कली देंनुङ” देंत। मिनु मेको गोरशो डांडा ङोंइसाक्‍व। ");
INSERT INTO suzBl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","मिनु परमप्रभुमी बालाम कली ग्रुमानु, बालाममी मेको कली “गो ७ ओटा चढ़ेतीके सेल्‍पाइश्‍शा, मेकेर ब्‍यफ का का नु सांड का का चढ़ेता” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","मिनु परमप्रभु यावेमी बालाम कली लोव़ पशा “गे बालाक आ बाक्‍तीके लेतो। इ कली देंशो लोव़ मेको कली मतो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","मिनु मेको बालाक आ बाक्‍तीके लेश्‍शा जाक्‍त। मेना बालाक नु मोआब ङा ठेयब मुरपुकी चोशा चढ़ेतीके आ नेक्‍था राप्‍शा बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","मिनु बालाममी परमप्रभु आ देंशो लोव़ पा बालाकमी आं कली अराम रागी रे चाक्‍तु। नां दाप्‍तीके ङा पहाडम बाक्‍ब मोआबी आन पिपमी आं कली “जाक्‍कीन, मिनु आं पा ङा याकूब कली सराप चीले पने। इस्राएली आन कली हिंच कोंइदीमी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","मिनु “परमप्रभुमी सराप चीले मपाइश्‍शो आन कली, गो दोपा सराप चीले पाइक्‍नुङमी? परमप्रभु यावेमी हिंच मकोंइशो आन कली, गो दोपा हिंच कोंइनुङमी? ");
INSERT INTO suzBl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","गो सेरथे फुल्‍लु तार बाक्‍शा, मेको आन कली ताइनुङ। गो डांडाम बाक्‍शा, मेको आन कली कोव़नुङ। मेको आन का ला बाक्‍ब जात ङा मुर बाक्‍नीम। मिनु रागी रागी ङा मुर नु मखाल्‍सीनीम। ");
INSERT INTO suzBl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूब आ मुर फुरक खोदेंशो पा शुश दुम्‍शो बाक्‍नीम। इस्राएल ङा मुर आन ४ भाग ङा भाग का यो, सुम हिक्‍ने चाप्‍नीमी ङा? उत्‍पत्ती १३:१६ गे आं कली ठीक पाइब मुर आन कली खोदेंशो पा बेक्‍चा गेयीनी। मिनु आं बेक्‍तीके मेको आन केन खोदेंशो दुम्‍ल” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","मिनु बालाकमी बालाम कली “गे आं कली मार पनी? गो इन कली आं जोरी सत्रु आन कली सराप चीले पाइक्‍चा कली ब्रेश्‍शा चाक्‍तन्‍नी। तन्‍न गे दूली पा मेको आन कली आसीक कका गेतीनी” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","मिनु मेकोमी “गो परमप्रभु यावेम आं थुंम वोइश्‍शो देंशो लोव़ ब्‍वाक्‍चा माल्‍नुङ” देंत। गन्‍ती २२:३८ ");
INSERT INTO suzBl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","मिनु बालाकमी मेको कली “गो नु अर्को बाक्‍तीके पिने। गे एकेर रे मेको आन कली ताइनीनी। मेकेर रे मेको आन कली इच्‍का ला ताइतीनी। नेल्‍ल आन कली तने मचाप्‍नीनी। मेको आन कली मेकेर रे सराप चीले पतीन” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","मिनु मेकोमी मेको कली चोफीम ङा रू पिस्‍गा डांडाम लाइक्‍तु। मिनु ७ ओटा चढ़ेतीक सेल्‍शा, मेको तारी ब्‍यफ का का नु सांड का का चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","मिनु बालाममी बालाक कली “गो परमप्रभु यावे कली ग्रुम्‍थ एर लाइनुङ। गे चहिं एको इन चोशा चढ़ेशो आ नेक्‍था राप्‍शा बाक्‍कीन” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","मिनु परमप्रभु यावेमी बालाम कली ग्रुम्‍शा, आ थुंमी लोव़ वोइश्‍शा, मेको कली “गे बालाक आ बाक्‍तीके लेतो। इ कली देंशो लोव़ मेको कली मतो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","मिनु मेको बालाक आ बाक्‍तीके लेश्‍शा जाक्‍त। मेना बालाक नु मोआब ङा ठेयब मुरपुकी चोशा चढ़ेतीके आ नेक्‍था राप्‍शा बाक्‍तेक्‍म। मिनु बालाकमी मेको कली “परमप्रभु यावेम मार देंम?” दे हिल्‍लो पाप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","मिनु बालाममी परमप्रभु आ देंशो लोव़ पा “बालाक बोक्‍शा, आं लोव़ नेनो। सिप्‍पोर आ तौ इ नोफा दाइक्‍तो। ");
INSERT INTO suzBl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमप्रभु मुर ममाइ। मेकोमी जोल मपाइब। मेको बेक्‍शा लाइब मुर खोदेंशो पा आ थुं मफाइक्‍ब। मेकोमी लोव़ थोक्‍शा देंम ङा मेरे पाइब। मेकोम पाइक्‍नुङ देंम ङा मेरे मेको मपाइक्‍बा ङा? १सामुएल १५:२९ ");
INSERT INTO suzBl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","नेनीन, गो मेको आन कली आसीक गेतीक लोव़ त‍शो बाक्‍नुङ। मेकोमी मेको आन कली आसीक गेशो बाक्‍ब। मिनु गो मेको फाइक्‍ने चाप्‍नुङा ङा? ");
INSERT INTO suzBl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","याकूब कली मरिम्‍शो मदुम्‍ब, देंशो बाक्‍ब। मिनु इस्राएली आन कली श्‍येत मदुम्‍ब। मेको परमप्रभु यावे, आन परमप्रभु मेकोपुकी नु बाक्‍ब। मिनु मेको आन दातेमी पिप बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमप्रभुमी मेको आन कली इजीप्‍त रे ग्रुंइशा, आ सक्तिम मेको आन कली ब्‍वाकी ङा ब्‍यफ खोदेंशो सेल्‍शो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","थमा पा, याकूब कली राइब मारेइ मन्‍तर तन्‍तर मबाक्‍ब। इस्राएली आन कली राइब मारेइ लिंक्‍यु कोव़तीके मबाक्‍नीम। मुल याकूब नु इस्राएल आ पर्बम परमप्रभु आ पशो कोव़ङीन। ");
INSERT INTO suzBl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","कोव़ङीन, मेको जात ङा मुर गुप्‍सनी खोदेंशो पा बोक्‍नीम। प्रेक्‍शा ग्राम्‍चा चिक्‍शो गुप्‍स खोदेंशो पा मेको छुल बोक्‍ब। मेकोमी सिखार मब्‍वा सम्‍म नु सिखार आ हुश मतूङा सम्‍म मनाइक्‍ब” देंत। गन्‍ती २४:९; इजीकीएल १९:२ ");
INSERT INTO suzBl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","मिनु बालाकमी बालाम कली “मेको आन कली सराप चीले मगेने, आसीक यो मगेने” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","तन्‍न बालाममी बालाक कली “परमप्रभु यावेमी मार देंबा, गो मेको पचा माल्‍नुङ, दे गो इन कली ना कना मदेंङा ङा?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","मिनु बालाकमी बालाम कली “मुल पिने, गो इन कली अर्को बाक्‍तीकेमी लाइक्‍नन्‍नी। मेकेर रे गे आं पा ङा मेको आन कली सराप चीले पचा कली परमप्रभुमी दाक्‍बा कों?” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","मिनु बालाकमी बालाम कली पेओर डांडाम लाइक्‍तु। मेकेर रे गोरशो रागी नेल्‍ल तांइसाक्‍व। गन्‍ती २२:४१; गन्‍ती २५:३ ");
INSERT INTO suzBl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","मिनु बालाममी बालाक कली “एकेर आं कली ७ ओटा चढ़ेतीक सेलीन। मिनु ७ ओटा ब्‍यफ ७ ओटा सांड ठीक पने” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","मिनु बालाकमी बालाममी देंशो खोदेंशो पा पाप्‍तु। मिनु चढ़ेतीक नेल्‍लेमी ब्‍यफ का का नु सांड का का चढ़ेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","मिनु बालाममी परमप्रभु यावेमी इस्राएली आन कली आसीक गेचा थुं पशो बाक्‍त, दे तुइक्‍ताक्‍व। मिनु मेको ङोंइती ङा खोदेंशो पा परमप्रभु कली हिल्‍लो पथ मला। तन्‍न मेकोमी आ कुल गोरशो रागी गे हिरशा कोव़तु। ");
INSERT INTO suzBl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","मिनु बालाममी कोव़ना कोव़न, इस्राएली आन कली थर थर पा बाक्‍शो ताम्‍तीमी। मिनु परमप्रभु आ सोक्‍तीम मेको कली सुम्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","मिनु मेकोमी परमप्रभु आ पपाइश्‍शो लोव़ पा “गो बेओर आ तौ बालाम, मिक्‍च ताइब नङ, आ देंशो लोव़ मार बाक्‍त देंशा हना, १सामुएल ९:९ ");
INSERT INTO suzBl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","गो, परमप्रभु आ लोव़ नेंबमी, एको लोव़ पाइनुङ। गो नेल्‍ल क्‍येङा सक्ति पाइश्‍शो आ कोंइशो ताइनुङ। मिनु गो आ ङोंइती बाप्‍शा, मेको कली ताइनुङ। ");
INSERT INTO suzBl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","याकूब आ मुर इन ताम्‍बु गिश रिम्‍शो बाक्‍नीमी। गे इस्राएली इन बाक्‍तीके दारशो बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","मेको खजूर रवा ख्रुम्‍शो ठेयब दिंम खोदेंशो बाक्‍ब। मेको खोला आ नेक्‍था ख्रुम्‍शो फू रू खोदेंशो बाक्‍ब। मेको परमप्रभु यावेमी ख्रुम्‍शो ठेयब घ्‍यू कुमारी खोदेंशो बाक्‍ब। ब्‍वाक्‍कु आ नेक्‍था वाशो लेबानोन ङा लाइश्‍शो रवा खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","मेको आन गरपुकीम ब्‍वाक्‍कु ब्रीशा क्‍युप्‍ब। मिनु मेको आन रू शुश ब्‍वाक्‍कु ताइनीम। मेको आन पिप अगाग क्‍येङा यो ठेयब बाक्‍‍ब। मिनु मेको आ राज्‍य ठेयब सेल्‍चा पुंइसीब। ");
INSERT INTO suzBl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","परमप्रभुमी मेको आन कली इजीप्‍त रे ग्रुंइशा चाक्‍शो बाक्‍ब। आ सक्ति इस्राएली आन कली ब्‍वाकी ङा ब्‍यफ आ ग्रोव़ खोदेंशो बाक्‍ब। रागी रागी ङा जोरी सत्रु आन कली क्‍याम्‍ब। मेको आन रुश जिक्‍ब। मेको आन लिब्रामी मेको आन कली ख्रिश्‍शा साइक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","मेको गुप्‍स खोदेंशो पा बाप्‍शा बाक्‍ब। गुप्‍सनी खोदेंशो पा बाप्‍शा बाक्‍ब। सुम मेको कली पोक्‍बा ङा? इस्राएली, सुमी इन कली आसीक गेनीमी, मेको आसीक राइनीम। सुमी इन कली सराप चीले पाइक्‍नीमी, मेको सराप चीले राइनीम” देंत। गन्‍ती २३:२४; उत्‍पत्ती ४९:९; उत्‍पत्ती १२:३; उत्‍पत्ती २७:२९ ");
INSERT INTO suzBl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","मिनु बालाक बालाम कली तशा, शुश गाइक्‍ताक्‍व। मिनु मेकोमी आ गुइ क्‍युक्‍शा, बालाम कली “गो इ कली आं जोरी सत्रु आन कली सराप चीले पाइक्‍चा कली कका ब्रेत्‍ताक्‍न। तन्‍न गे मेको आन कली सां खेयप आसीक कका गेप्‍तीवी। ");
INSERT INTO suzBl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","मोपतीके मुल गे दोरोर पा इ खिं लेतो। गो इ कली ठेयब सेल्‍नुङ, दे मिम्‍शो नङ। तन्‍न परमप्रभु यावेमी इ कली मान ततीक रे तेक्‍तु” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","मिनु बालामम बालाक कली “गे आं कली ब्रेत्‍थ सोइश्‍शो मुर आन कली गो ");
INSERT INTO suzBl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘बालाकमी आं कली सुन नु चांदीम ब्रीशो आ दरवार गेती हना यो, परमप्रभु यावे आ लोव़ लाक्‍शा आं मिम्‍शोमी मारेइ रिम्‍शो नु मरिम्‍शो पने मचाप्‍नुङ। परमप्रभु यावेमी आं कली मार देंबा, गो मेकोन देंनुङ’ मदेंशो नङा ङा? गन्‍ती २२:१८ ");
INSERT INTO suzBl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","मुल गो आं मुर आन बाक्‍तीके लाइनुङ। तन्‍न इस्राएलीपुकीम इन मुर आन कली नोले मार पाइक्‍नीमी, मेको इन कली शेंनुङ” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","मिनु बालाममी परमप्रभु आ पपाइश्‍शो लोव़ पा “गो बेओर आ तौ बालाम, मिक्‍च ताइब नङ, आ देंशो लोव़ मार बाक्‍त देंशा हना, ");
INSERT INTO suzBl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","गो, परमप्रभु आ लोव़ नेंबमी, एको लोव़ पाइनुङ। गो नेल्‍ल क्‍येङा ठेयब तुइश्‍शा, नेल्‍ल क्‍येङा सक्ति पाइश्‍शो आ कोंइशो ताइनुङ। मिनु गो आं मिक्‍च मसुम्‍शो आ ङोंइती बाप्‍शा, ");
INSERT INTO suzBl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","गो मेको कली ताइनुङ, तन्‍न मुल ममाइ। गो मेको कली कोव़नुङ। तन्‍न आ नेक्‍था रे ममाइ। याकूब रे पा सोरुल का दाप्‍ब। मिनु इस्राएली रे पा पिप का ग्रूब। मिनु मेकोमी मोआब रागी आ सांद रे पा खतम सेल्‍ब। मिनु शेथ आ थर ङा मुर आन कली खतम पोक्‍ब। मत्ती २:२; लूका १:७८; उत्‍पत्ती ४९:१०; २सामुएल ८:२ ");
INSERT INTO suzBl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम रागी आ केन सेल्‍ब। मिनु सेइर रागी ग्राब। मिनु इस्राएल बोल्‍यो दुम्‍ब। २सामुएल ८:१४; येरमीया ४९:७-२२ ");
INSERT INTO suzBl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकूब रे पा हुकुम पाइब का ग्रूब। मिनु इर सहर ङा लीशो आन कली साइक्‍ब” देंत। मीका ५:१,७,८ ");
INSERT INTO suzBl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","मिनु बालाममी अमालेक आ मुर आन कली कोव़शा “अमालेक आ मुरपुकी रागी रागी नेल्‍ल क्‍येङा ङोंइती ङा बाक्‍तेक्‍म। तन्‍न मेकोपुकी गेना हना यो जाम्‍शा लाइनीमी” देंत। प्रस्‍थान १७:१४; १सामुएल १५:२-३,७ ");
INSERT INTO suzBl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","मिनु नोले मेकोमी केनी ङा मुर आन कली कोव़शा “इन बाक्‍तीक रागी बोल्‍यो बाक्‍ब। इन बाक्‍तीक सेरथे फुल्‍लुमी सेल्‍शो ग्‍योव़ खोदेंशो बाक्‍ब। १सामुएल १५:६ ");
INSERT INTO suzBl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तन्‍न गे काइन सहर ङा मुरपुकी मीम चोचा पुंइसीनीनी। गिश सम्‍म अश्‍शुरीमी इन कली फ्रेंशा लाइक्‍नीम” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","मिनु लेंशा मेकोमी लोव़ पा “आबी, परमप्रभुम मोदेंशो पवानु, सु ब्रोंइने चाप्‍बा ङा? ");
INSERT INTO suzBl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीम रे जहाजपुकी जाक्‍नीम। मिनु मेकोपुकीम अश्‍शुर नु एबेर कली श्‍येत गे‍नीम। मिनु मेकोपुकी यो खतम दुम्‍नीम” देंत। उत्‍पत्ती १०:-४; उत्‍पत्ती १०:२१-२२ ");
INSERT INTO suzBl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","मिनु बालाम बोक्‍शा, आ खिं लेत्‍त। मिनु बालाक यो आ लां लत। गन्‍ती ३१:८,१६ ");
INSERT INTO suzBl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएलीपुकी शित्तीममी बाक्‍मानु, मुरपुकी मोआबी आन तमीपुकी नु इप्‍शा, मरिम्‍शो पचा गोम्‍तेक्‍म। गन्‍ती ३३:४९; १कोरिन्‍थी १०:८ ");
INSERT INTO suzBl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","मिनु मेकोपुकीम इस्राएली आन कली आन देवी देवता आन कली चढ़ेतीकेम ब्रेत्‍ताक्‍म। मिनु मेकोपुकीम मेको आन भोज जशा, मेको आन देवी देवता आन ङोंइती बाप्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","मोपा इस्राएलीपुकीम पेओर डांडा ङा बाल देवता कली पूजा पचा गोम्‍तेक्‍म। मिनु परमप्रभु यावे इस्राएली आन पर्बम गाइक्‍ताक्‍व। ब्‍यवस्‍था ४:३; भजन संग्रह १०६:२८ ");
INSERT INTO suzBl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","मिनु परमप्रभु यावेमी मोसा कली “एको मुर आन ठेयब मुर नेल्‍ल आन कली चाक्‍शा क्‍युक्‍शा साइश्‍शा, परमप्रभु यावे आ ङोंइती नाप्‍शो नांम वोइक्‍मी। मिनु परमप्रभु यावे इस्राएली आन पर्बम आ थाम्‍पा गाइश्‍शो नांइसीब” देंत। ब्‍यवस्‍था २१:२२-२३; २सामुएल २१:६-९ ");
INSERT INTO suzBl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","मिनु मोसाम इस्राएली आन निसाफ पाइब आन कली “गे नेल्‍लेमी पेओर डांडा ङा बाल देवता कली पूजा पाइब इन मुर नेल्‍ल आन कली साइक्‍चा माल्‍नीनी” दे माइक्‍तीमी। प्रस्‍थान ३२:२७ ");
INSERT INTO suzBl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","मिनु इस्राएलीपुकी ग्रुम्‍तीक ताम्‍बु आ ओव़तीकेम ङाक्‍शा बाक्‍मानु, मेना इस्राएली काम मोसा नु इस्राएली नेल्‍ल आन ङोंइती आ खिंम मिदयानी मीश का चाक्‍तु। गन्‍ती ३१:१६ ");
INSERT INTO suzBl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","मिनु चढ़ेब हारून आ चच, एलाजर आ तौ फिनेहासमी मेको तशा, मेको बोक्‍शा, आ गुइमी तूतीक का शेशा, प्रस्‍थान ६:२५ ");
INSERT INTO suzBl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","मेको इस्राएली आ नोनोले लशा, आ बाक्‍तीक ओव़शा, मेको इस्राएली नु मेको मीश मुर निम्‍फा आस कली एर ओंथ ख्रिप्‍पाइश्‍शा थोक्‍तीम्‍सी। मिनु इस्राएली आन दाते रे मेको मुर बेक्‍तीक रोइ जाम्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","तन्‍न मेको मुर बेक्‍तीक रोइम बेक्‍बपुकी २४ हजार बाक्‍तेक्‍म। भजन संग्रह १०६:२९-३१ ");
INSERT INTO suzBl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“चढ़ेब हारून आ चच, एलाजर आ तौ, फिनेहासमी इस्राएली आन पर्बमी आं गाइश्‍शो नाइक्‍पाइक्‍तु। फिनेहासमी आं रुश पशो तुइश्‍शा, आ जोंब बोक्‍शा, आं गाइश्‍शो नाइक्‍पाइक्‍तु। मिनु मेको आन कली मसदुमी। ");
INSERT INTO suzBl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","मोपतीके गे मेको कली ‘परमप्रभुमी इ कली आं थुं नाइक्‍तीक कबल पाइब। १इतिहास ९:२०; यसैया ५४:१०; मलाकी २:५ ");
INSERT INTO suzBl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","मिनु मेको कबल इ कली नु इ चच युइ आन कली बाक्‍ब। मेको गेना हना यो चढ़ेब दुम्‍तीक कबल बाक्‍ब। मारदे हना गे इ परमप्रभु आ पर्बम जोंब बोक्‍शा, गेय पाप्‍तीवी। मिनु गेमी इस्राएली आन पर्बम पाप क्‍याम्‍तीक गेय पाप्‍तीवी’ देनो” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","मेको मिदयानी मीश मुर नु साइक्‍चा पुंइसीब इस्राएली आ नें जिम्री बाक्‍त। मेको सालु आ तौ सिमियोन आ थर ङा खिं का ङा ठेयब मुर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","मेको साइक्‍चा पुंइसीब मिदयानी मीश मुर आ नें कोज्‍बी बाक्‍त। मेको सुर आ तमी बाक्‍त। मेको मिदयान ङा ठेयब मुर बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिदयानी आन कली श्‍येत गेशा, साइक्‍मी। गन्‍ती ३१:२-१० ");
INSERT INTO suzBl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","मारदे हना, मेकोपुकीमी इन कली यो श्‍येत गेचा गोम्‍तेक्‍म। मिनु इन कली बाल-पेओर कली पूजा पपाइक्‍तेक्‍म। मेना मिदयान ङा ठेयब मुर आ तमी कोज्‍बीमी इन कली श्‍येत गेपाइक्‍तु। मेको चहिं मुर साइक्‍चा रोइ बोक्‍म नाक्‍त साइक्‍चा पुंइसाक्‍व। पेओर कली पूजा पतीके मो दुम्‍शो बाक्‍त” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","मेको मुर बेक्‍तीक रोइ दुम नोले परमप्रभु यावेमी मोसा नु चढ़ेब हारून आ तौ एलाजर आस कली ");
INSERT INTO suzBl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएली नेल्‍ल आन दातेमी २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो लडाइम लने चाप्‍ब आन कली थर थर पा हिक्‍कीस” देंत। गन्‍ती १:२-४७; ");
INSERT INTO suzBl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","मिनु मोसा नु चढ़ेब एलाजरमी यरीको आ आइक्‍ची हांबु यर्दन खोला आ शुंइच मोआब ङा दिंमम इस्राएली आन कली ग्रुम्‍पाइश्‍शा ");
INSERT INTO suzBl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“परमप्रभु यावेमी मोसा कली अरेशो खोदेंशो पा २० बर्स गाप्‍शो नु मेको क्‍येङा लाक्‍शो मुर आन कली हिक्‍कीन” दे माइक्‍तीमी। मिनु इजीप्‍त रे ग्रूशा जाक्‍शो इस्राएलीपुकी एकोन बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","इस्राएल आ ङोंइती जरमेशो तौ रूबेन आ थर, हनोक आ खिं खिं ङा मुरपुकी, पल्‍लु आ खिं खिं ङा मुरपुकी, उत्‍पत्ती ३५:२३-२६; उत्‍पत्ती ४६:८-२७; १इतिहास ४:-८:- ");
INSERT INTO suzBl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोन आ खिं खिं ङा मुरपुकी नु कारमी आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","एको रूबेन आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ४३ हजार ७ सहे ५० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्‍लु आ तौ आन दातेमी का एलीआब बाक्‍‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलीआब आ तौपुकी, नेमुएल, दाथान नु अबीराम बाक्‍तेक्‍म। एकोपुकी मेको दाथान नु अबीराम आन दाते ङा ठेयब मुरपुकी बाक्‍तेक्‍म। मेकोपुकी कोराह आ हुलम ब्‍वांइसीशा मोसा नु हारून नु जिचा पोक्‍शा, परमप्रभु यावे आ पर्बम दूली पा बोक्‍शो बाक्‍तेक्‍म। गन्‍ती १६:१,१२ ");
INSERT INTO suzBl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","मिनु रागीम आ शोव़ पाक्‍शा मेको आन कली कोराह नुन दाक्‍शो बाक्‍त। मेना सहे निक्‍शी ५० जना आन कली मीम खतम पोक्‍शो बाक्‍त। मेकोपुकी मरिम्‍शो पाइब दुम्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तन्‍न कोराह आ तौपुकी चहिं मबेक्‍शो बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","सिमियोन आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, नेमुएल आ खिं खिं ङा मुरपुकी, यामीन आ खिं खिं ङा मुरपुकी, याकीन आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेराह आ खिं खिं ङा मुरपुकी नु शावल आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। उत्‍पत्ती ३६:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","एको सिमियोन आ थर ङा खिं खिं ङा मुरपुकी बाक्‍नीम। मेको नेल्‍ल आन कली हिक्‍शोनु, २२ हजार सहे निक्‍शी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, सेफोन आ खिं खिं ङा मुरपुकी, हाग्‍गी आ खिं खिं ङा मुरपुकी, शुनी आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओज्‍नी आ खिं खिं ङा मुरपुकी, एरी आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोद आ खिं खिं ङा मुरपुकी नु अरेली आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","एको गाद आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु ४० हजार ५ सहे जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","मिनु यहूदा आ तौ एर नु ओनान बाक्‍ताक्‍स। तन्‍न मेको कनान रागीम बेक्‍ताक्‍स। उत्‍पत्ती ३८:७-१० ");
INSERT INTO suzBl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदा आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, शेलाह आ खिं खिं ङा मुरपुकी, पेरेस आ खिं खिं ङा मुरपुकी, जेराह आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","मिनु पेरेस आ चच युइ ङा मुर चहिं, हेस्रोन आ खिं खिं ङा मुरपुकी नु हामुल आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। रूथ ४:१८ ");
INSERT INTO suzBl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","एको यहूदा आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ७६ हजार ५ सहे जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्‍साकार आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, तोला आ खिं खिं ङा मुरपुकी, पुवा आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशुब आ खिं खिं ङा मुरपुकी नु शिम्रोन आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","एको इस्‍साकार आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ६४ हजार सहे सां बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलून आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, सेरेद आ खिं खिं ङा मुरपुकी, एलोन आ खिं खिं ङा मुरपुकी नु याहलेल आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","एको जबूलून आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ६० हजार ५ सहे जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","मिनु योसेफ आ तौ मनस्‍से नु एफ्राइम आस थर ङा मुर आन खिं खिं ङा मुर आन कली का का पा हिक्‍शोनु, ");
INSERT INTO suzBl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनस्‍से आ चच युइ ङा माकीर आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। माकीर गिलाद आ आफ बाक्‍त। यहोसु १७:१-६ ");
INSERT INTO suzBl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलाद आ चच युइपुकी इएजेर आ खिं खिं ङा मुर रे इएजेर, हेलेक आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएल आ खिं खिं ङा मुरपुकी, शेकेम आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शेमीदा आ खिं खिं ङा मुरपुकी नु हेफेर आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। हेफेर आ तौ सेलोफेहाद के चहिं तौ मबाक्‍थु, तमीपुकी ला बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","हेफेर आ तौ सेलोफेहाद आ तमी आन नें महलाह, नोआह, होग्‍ला, मिल्‍का नु तिरचा बाक्‍तेक्‍म। गन्‍ती २७:१ ");
INSERT INTO suzBl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","एको मनस्‍से आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ५२ हजार ७ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राइम आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, शुथेलाह आ खिं खिं ङा मुरपुकी, बेकेर आ खिं खिं ङा मुरपुकी नु तहन आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","मिनु शुथेलाह आ खिं खिं ङा मुरपुकी चहिं एरान आ खिं खिं ङा मुर बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एको एफ्राइम आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ३२ हजार ५ सहे बाक्‍तेक्‍म। मेको योसेफ आ चच युइ आन खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बेन्‍यामीन आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, बेला आ खिं खिं ङा मुरपुकी, अश्‍बेल आ खिं ङा मुरपुकी, अहीराम आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शुफाम आ खिं खिं ङा मुरपुकी नु हुफाम आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","मिनु बेला आ तौ आरद नु नामान बाक्‍ताक्‍स। आरद आ खिं खिं ङा मुरपुकी नु नामान आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","एको बेन्‍यामीन आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ४५ हजार ६ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दान आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, शुहाम आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको दान आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","एको शुहाम आ खिं खिं ङा मुर नेल्‍ल आन कली हिक्‍शोनु, ६४ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेर आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, इम्नाह आ खिं खिं ङा मुरपुकी, इश्‍वी आ खिं खिं ङा मुरपुकी, बेरीआ आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","हेबेर आ खिं खिं ङा मुरपुकी नु माल्‍कीएल आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेर आ तमी आ नें सेराह बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","एको आशेर आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु ५३ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नाप्‍ताली आ थर ङा मुर आन खिं खिं ङा मुरपुकी का का पा हिक्‍शोनु, याहसेल आ खिं खिं ङा मुरपुकी, गुनी आ खिं खिं ङा मुरपुकी, ");
INSERT INTO suzBl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेर आ खिं खिं ङा मुरपुकी नु शिल्‍लेम आ खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","एको नाप्‍ताली आ थर ङा खिं खिं ङा मुरपुकी बाक्‍तेक्‍म। मेको नेल्‍ल आन कली हिक्‍शोनु, ४५ हजार ४ सहे बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस्राएली वोंइश मुर नेल्‍ल आन कली हिक्‍शोनु, ६ लाख हजार का ७ सहे ३० जना बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“मेको आन खिं खिं ङा मुर गिश बाक्‍नीमी, दे मिम्‍शा, रागी आंम के सेल्‍चा कली योक्‍शा गेमी। ");
INSERT INTO suzBl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","गे मेको आन कली ठेयब थर आन कली ठेयब रागी नु आइक्‍च थर आन कली आइक्‍च रागी पा योक्‍शा गेमी। थर का का आन कली मेको आ मुर आन कली कोव़शा हुकुम पचा गेमी। ");
INSERT INTO suzBl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","मो हना यो मेको रागी चिठठा आप्‍शा योक्‍चा माल्‍ब। मेकोपुकीमी आन किकी पिपी आन नें नें खोदेंशो पा अधिकार पामेक्‍ल। गन्‍ती ३३:५४; यहोसु १४:२ ");
INSERT INTO suzBl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ठेयब नु आइक्‍च आन दातेमी आन अधिकार पतीके चिठठा आप्‍शा योक्‍चा माल्‍ब” देंत। ");
INSERT INTO suzBl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","मिनु लेवी आ थर ङा मुर का का पा हिक्‍शोनु, सु सु बाक्‍तेक्‍म देंशा हना, गेरशोन आ खिं खिं ङा मुर, कोहाथ आ खिं खिं ङा मुर, मेरारी आ खिं खिं ङा मुर बाक्‍तेक्‍म। गन्‍ती ३:१७-२०; प्रस्‍थान ६:१६-२५ ");
INSERT INTO suzBl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","मिनु लेवी आ थर ङा खिं खिं ङा मुर अरु सु सु अरु बाक्‍तेक्‍म देंशा हना, लिब्‍नी आ खिं खिं ङा मुर, हेब्रोन आ खिं खिं ङा मुर, माहली आ खिं खिं ङा मुर, मुशी आ खिं ङा मुर, कोराह आ खिं ङा मुर बाक्‍तेक्‍म। कोहाथ चहिं अम्राम आ किकी बाक्‍त। गन्‍ती ३३:२०; गन्‍ती १३:२२ ");
INSERT INTO suzBl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्राम आ मीश आ नें योकेबेद बाक्‍त। मेको चहिं लेवी आ थर ङा इजीप्‍त रागीमी थिशो तमी बाक्‍त। मेकोमी अम्राम रे हारून नु मोसा नु आस समी मिरयाम आन कली थिम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","मिनु हारूनमी नादाब, अबीहु, एलाजर नु इथामार थिम्‍तीमी। ");
INSERT INTO suzBl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","तन्‍न नादाब नु अबीहु चहिं परमप्रभु यावे आ ङोंइती अरु मी रे पा चोशा चढ़ेतीके, बेक्‍ताक्‍स। लेवी १०:१-२ ");
INSERT INTO suzBl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","मेको वोंइश आल नेल्‍ले महिना का नु मेको क्‍येङा लाक्‍शो हिक्‍शोनु २३ हजार बाक्‍तेक्‍म। मेकोपुकी अरु इस्राएली आन खोदेंशो पा लडाइ पचा कली महिक्‍शो बाक्‍तेक्‍म। मारदे हना मेकोपुकी इस्राएली आन दातेमी आंम आन रागी कली मगेशो बाक्‍त। ");
INSERT INTO suzBl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मिनु मोसा नु एलाजर चढ़ेबमी मेको नेल्‍ल आन कली हिक्‍ताक्‍स। मेना मेकोपुकी मोआब ङा दिंम यर्दन आ शुंइच, यरीको आ नेक्‍था बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","तन्‍न मोसा नु हारूनमी सीनै ङा गोरशो रागीम हिक्‍शो इस्राएली का यो मबाक्‍म। गन्‍ती १:- ");
INSERT INTO suzBl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","मारदे हना, परमप्रभु यावेमी मेको आन पर्बम “मेकोपुकी थमा पा गोरशो रागीमीन बेक्‍चा माल्‍नीम” देंशो बाक्‍त। यपुन्‍ने आ तौ कालेब नु नून आ तौ यहोसु ङा लाक्‍शा, मेको आन दाते ङा का यो सेस मलीम। गन्‍ती १४:२२-३८ ");
INSERT INTO suzBl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","योसेफ आ तौ मनस्‍से, मनस्‍से आ तौ माकीर, माकीर आ तौ गिलाद, गिलाद आ तौ हेफेर, हेफेर आ तौ सेलोफेहाद आ तमीपुकी महलाह, नोआह, होग्‍ला, मिल्‍का नु तिरचा बाक्‍तेक्‍म। गन्‍ती २६:३३; यहोसु १७:३-६ ");
INSERT INTO suzBl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","मेकोपुकी मोसा, चढ़ेब एलाजर, ठेयब मुरपुकी नु मेकेर बाक्‍ब मुर नेल्‍ले आन ङोंइती ग्रुम्‍तीक ताम्‍बु आ लाप्‍चो आ ङोंइती बाक्‍तेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","मिनु सेलोफेहाद आ तमीपुकीमी “आंइ आफ गोरशो रागीम बेक्‍त। तन्‍न मेको परमप्रभु यावे आ पर्बम मरिम्‍शो पा बोक्‍ब कोराह आ हुलम मबाक्‍शो बाक्‍त। तन्‍न मेको आ आंम पाप पतीके बेक्‍त। मिनु मेको के तौ मबाक्‍म। गन्‍ती १६:७; उत्‍पत्ती ३:१९ ");
INSERT INTO suzBl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","मिनु तौ मबाक्‍तीके आंइ आफ आ नें आ थर आ मुर आन दाते रे मारदे क्‍याम्‍सीबा? आंइ आफ आ लोक्‍बपुकी नु आंइ कली यो अङस गेने” देंतेक्‍म। ");
INSERT INTO suzBl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","मिनु मोसामी मेको आन पोक्‍शो लोव़ परमप्रभु यावे आ ङोंइती चाक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","मिनु परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सेलोफेहाद आ तमीपुकीम पोक्‍शो लोव़ ठीक बाक्‍ब। गे थमा पा मेको आन कली आन आफ आ लोक्‍ब आन दातेमी अङस गेचा माल्‍नेवे। मिनु गे मेको आन आफ आ अङस मेको आन कली गेमी। ");
INSERT INTO suzBl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","मिनु गे इस्राएली आन कली ‘सुइ मुर तौ मथिथु, बेक्‍त हना, मेको आ तमी आन कली आ अङस गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","मेको के तमी यो मबाक्‍त हना, मेको आ अङस आ लोक्‍ब आन कली गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","मेको के आ लोक्‍ब यो मबाक्‍त हना, मेको आ अङस आ आफ आ लोक्‍ब कली गेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","मिनु मेको आ आफ आ लोक्‍ब यो मबाक्‍त हना, मेको आ अङस आ थर ङा नेल्‍ल क्‍येङा आ नेक्‍था ङा मुर कली गेचा माल्‍नीनी। मिनु मेको अङस मेको केन दुम्‍ब’ दे माइक्मी” देंत। मेको लोव़ परमप्रभु यावेमी मोसा कली देंशो, इस्राएली आन कली फुल्‍लुम मुशा ब्रेक्‍शो नु अरेशो लोव़ बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","मिनु परमप्रभु यावेमी मोसा कली “गे एको अबारीम पहाड ङा डांडा ङोंइसो। मिनु इस्राएली आन कली गेशो रागी कोव़ङो। गन्‍ती २१:११; ब्‍यवस्‍था ३२:४८-५२ ");
INSERT INTO suzBl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","मिनु गे मेको रागी तवी नोले, गे इ लोक्‍ब हारून खोदेंशो पा इ किकी पिपी नु बाक्‍थ लाइनेवे। गन्‍ती २०:२४-२८ ");
INSERT INTO suzBl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","मारदे हना जीन ङा गोरशो रागीमी मुरपुकी गो नु जिचा पोक्‍ग्‍मेनु, गे यो मटिसी। मेरीबाथ-कादेश ङा ब्‍वाक्‍कुम मुर आन ङोंइती गे आं कली ठेयब मसेल्‍यीसी” देंत। गन्‍ती २०:१२-१३ ");
INSERT INTO suzBl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मिनु मोसामी परमप्रभु यावे कली ");
INSERT INTO suzBl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“परमप्रभु यावे, मुर नेल्‍ल आन ब्रोंइचा गेब परमप्रभु, एको मुर आन कली लां कोंइब मुर का वोतीन। गन्‍ती १६:२२ ");
INSERT INTO suzBl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","मिनु मेको मुर आन ङोंइती गाक्‍ल। मिनु मेको आन कली लतीक नु जाक्‍तीक लां कोंइदल। मोपा परमप्रभु यावे आ मुर गोठला मबाक्‍शो भेडा खोदेंशो मदुम्‍मल” देंत। मीका ५:३; मत्ती ९:३६ ");
INSERT INTO suzBl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","मिनु परमप्रभु यावेमी मोसा कली “गे आं सोक्‍त पाइश्‍शो नून आ तौ यहोसु कली चाक्‍शा, इ गुइ मेको आ तार वोतो। प्रस्‍थान ३३:११; ब्‍यवस्‍था ३४:९ ");
INSERT INTO suzBl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","मिनु मेको कली चढ़ेब एलाजर नु मुर नेल्‍ल आन ङोंइती राप्‍पतो। मिनु मेको मुर नेल्‍लेम तचा ङा पा मेको कली एको गेय जिम्‍मा गेवो। ");
INSERT INTO suzBl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","मोपा गे मेको कली इ अधिकार गेवो। मिनु इस्राएली नेल्‍लेमी मेको आ देंशो टीमेक्‍ल। प्रस्‍थान ३४:२९-३०; २राजा २:९,१५ ");
INSERT INTO suzBl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","मिनु यहोसु चढ़ेब एलाजर आ ङोंइती राप्‍चा माल्‍ब। मिनु एलाजरमी ऊरीम यहोसु आ पर्बम मार देंबा, दे परमप्रभु यावे आ ङोंइती हिल्‍लो पचा माल्‍ब। यहोसु आ देंशोमी इस्राएली नेल्‍ले मेको नु लडाइ पथ लचा नु लेत्‍चा माल्‍नीम” देंत। प्रस्‍थान २८:३०; ब्‍यवस्‍था ३३:८ ");
INSERT INTO suzBl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मिनु मोसामी परमप्रभु यावेमी अरेशो खोदेंशो पा पाप्‍तु। मेकोमी यहोसु कली चाक्‍शा चढ़ेब एलाजर नु इस्राएली नेल्‍ल आन ङोंइती राप्‍पाइक्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","मिनु मोसामी परमप्रभु यावेमी देंशो खोदेंशो पा आ गुइ यहोसु आ तार वोइश्‍शा, आ गेय पचा कली जिम्‍मा गेप्‍तु। ");
INSERT INTO suzBl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","परमप्रभु यावेमी मोसा कली ");
INSERT INTO suzBl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“गे इस्राएली आन कली मीम चोशा चढ़ेतीके आं जचा थोव़क, आं दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके गे आं देंशो नाक्‍त चढ़ेचा माल्‍नीम, दे शेंचा माल्‍नेवे। लेवी २१:६ ");
INSERT INTO suzBl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","मिनु गे मेको आन कली ‘गे परमप्रभु यावे कली मीम चोशा चढ़ेतीके मार चढ़ेचा माल्‍नीनी देंशा हना, मारेइ मदुम्‍शो थम रिम्‍शो बर्स का गाप्‍शो पाठा निक्‍शी नाक्‍त किंत किंत चढ़ेचा माल्‍नीनी। प्रस्‍थान २९:३८-४२ ");
INSERT INTO suzBl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","मिनु का सुनी नु का नाक्‍दो चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","मेको नु अन्‍न चढ़ेतीके कली एफाह का ङा १० भाग ङा भाग का रिम्‍शो फस नु हिन का ङा ४ भाग ङा भाग का ख्राक्‍शो तेल ब्‍वाइश्‍शा चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीक बाक्‍ब। हिन का ४ लिटर बाक्‍ब। ४ भाग ङा भाग का लिटर का बाक्ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","एको परमप्रभु यावे कली गेना हना यो मीम चोशा चढ़ेतीके बाक्‍ब। मेको आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो सीनै डांडाम देंशो खोदेंशो पा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","मेको नु तूचा थोव़क चढ़ेतीके पाठा का कली हिन का ङा ४ भाग ङा भाग का अङगुर शांबु चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे आ बाक्‍तीकेम परमप्रभु यावे आ ङोंइती मोइक्‍चा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","मेको अर्को पाठा नां रिक्‍चावानु, चढ़ेचा माल्‍नीनी। मेको नु सुनी ङा खोदेंशो पा अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। एको परमप्रभु यावे कली मीम चोशा चढ़ेशो आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","मिनु नाइक्‍तीक नाक्‍तीम मारेइ मदुम्‍शो थम रिम्‍शो बर्स का गाप्‍शो पाठा निक्‍शी चढ़ेचा माल्‍नीनी। मेको नु अन्‍न चढ़ेतीके तेल ब्‍वाइश्‍शो रिम्‍शो फस एफाह का ङा १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। मिनु मेको नु तूचा थोव़क चढ़ेतीके यो चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीक बाक्‍ब।मत्ती १२:५ ");
INSERT INTO suzBl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","मेको नाइक्‍तीक नाक्‍ती ङा चोशा चढ़ेतीके बाक्‍ब। मेको नाक्‍त किंत किंत ङा चोशा चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेशा यो मेको चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","मिनु गे नेल्‍ल महिना ङा ङोंइती ङा नाक्‍त परमप्रभु यावे कली चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको ब्‍यफ निक्‍शी, सांड का नु ७ ओटा मारेइ मदुम्‍शो थम रिम्‍शो बर्स का का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। गन्‍ती १०:१०; इजीकीएल ४६:१,३,६; यसैया १:१३ ");
INSERT INTO suzBl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","मिनु मेको ब्‍यफ का का पा नु अन्‍न चढ़ेतीके तेलम निशो रिम्‍शो फस एफाह ङा १० भाग ङा भाग सां चढ़ेचा माल्‍नीनी। मेको सांड का नु अन्‍न चढ़ेतीके तेलम निशो रिम्‍शो फस एफाह का ङा १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीके बाक्‍ब।गन्‍ती १५:२-१२ ");
INSERT INTO suzBl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","मिनु मेको ७ ओटा पाठा नु का का पा एफाह ङा १० भाग ङा भाग का तेलम निशो रिम्‍शो फस चढ़ेचा माल्‍नीनी। एको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","मेको नु तूचा थोव़क चढ़ेतीके ब्‍यफ का का नु आधा हिन अङगुर शांबु बाक्‍चा माल्‍ब। सांड नु हिन का ङा भाग सां ङा भाग का अङगुर शांबु बाक्‍चा माल्‍ब। मिनु पाठा नेल्‍ल नु हिन का ङा ४ भाग ङा भाग का अङगुर शांबु चढ़ेचा माल्‍नीनी। मेको बर्स ङा महिना नेल्‍ल ङा औंसीम चोशा चढ़ेतीके बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","मिनु पाप पशो आ पर्बम बोका का परमप्रभु यावे कली चढ़ेचा माल्‍नीम। मेको नाक्‍त किंत किंत ङा चोशा चढ़ेतीक नु तूचा थोव़क चढ़ेतीके चढ़ेशा यो मेको चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","मिनु ङोंइती ङा महिना ङा १४ नाक्‍ती परमप्रभु यावे कली पास्‍सा चाड ङा चढ़ेतीके चढ़ेचा माल्‍नीनी। लेवी २३:५-१४ ");
INSERT INTO suzBl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","मिनु मेको महिना ङा १५ नाक्‍ती ठेयब चाड का मानेचा माल्‍नीम। मेको चाडम ७ नाक्‍त सम्‍म बोरब ओख्‍ती मसुप्‍शो शोब्‍ले जचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ङोंइती ङा नाक्‍तीम परमप्रभु यावे नु ग्रुम्‍तीके का दुम्‍चा माल्‍ब। मेको नाक्‍ती गे काइ गेय मपने। ");
INSERT INTO suzBl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","गे परमप्रभु यावे कली मीम चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मार चढ़ेचा माल्‍नीनी देंशा हना, ब्‍यफ निक्‍शी, सांड का नु बर्स का का गाप्‍शो ७ ओटा पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल मारेइ मदुम्‍शो थम रिम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","मेको नु अन्‍न चढ़ेतीके तेल ब्‍वाइश्‍शो रिम्‍शो फस दुम्‍चा माल्‍ब। मेको ब्‍यफ का नु एफाह का ङा १० भाग ङा भाग सां चढ़ेचा माल्‍नीनी। मेको सांड का नु एफाह का ङा १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","मिनु मेको ७ ओटा पाठा नु एफाह ङा १० भाग ङा भाग का का पा रिम्‍शो फस चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","मिनु इन पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा कली बोका का चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","मिनु सुनी ङा चोशा चढ़ेतीके, मेको गेना हना यो पचा माल्‍शो चोशा चढ़ेतीक बाक्‍ब, मेको चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","गे मोदेंशो चढ़ेतीके ७ नाक्‍त सम्‍म नाक्‍त किंत किंत जचा थोव़क कली चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक बाक्‍ब। मेको नाक्‍त किंत किंत ङा चोशा चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेशा यो मेको चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","मिनु ७ नाक्‍तीम परमप्रभु यावे नु ग्रुम्‍तीके का दुम्‍चा माल्‍ब। मेको नाक्‍ती गे काइ गेय मपने। ");
INSERT INTO suzBl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ङोंइती मीशो अन्‍न नु फल फुल ङा चाड नाक्‍त गे परमप्रभु यावे कली नक अन्‍न रे अन्‍न चढ़ेतीक चढ़ेनीनी। मेको हप्‍ता ङा चाड बाक्‍ब। मेना परमप्रभु यावे नु ग्रुम्‍तीके का दुम्‍चा माल्‍ब। मेको नाक्‍ती गे काइ गेय मपने। लेवी २३:१५-२१; ब्‍यवस्‍था १६:१० ");
INSERT INTO suzBl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","गे परमप्रभु यावे कली चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके बाक्‍ब। गेपुकीमी ब्‍यफ निक्‍शी, सांड का नु बर्स का का गाप्‍शो ७ ओटा पाठा चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","मेको नु अन्‍न चढ़ेतीके तेल ब्‍वाइश्‍शो रिम्‍शो फस दुम्‍चा माल्‍ब। मेको ब्‍यफ का नु एफाह का ङा १० भाग ङा भाग सां चढ़ेचा माल्‍नीनी। मेको सांड का नु एफाह का ङा १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","मिनु मेको ७ ओटा पाठा नु भाग का रिम्‍शो फस चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","मिनु इन पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा कली बोका का चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","मिनु नाक्‍त किंत किंत ङा चोशा चढ़ेतीक नु मेको अन्‍न चढ़ेतीक गेपुकीम मेको नु आ तूचा थोव़क चढ़ेतीक चढ़ेचा माल्‍नीनी। मेको ब्‍यफ, सांड, पाठा नेल्‍ल मारेइ मदुम्‍शो थम रिम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","गेपुकी ७ महिना ङा ङोंइती ङा नाक्‍ती ग्रुम्‍तीके का सेल्‍चा माल्‍नीनी। मेको नाक्‍ती गे काइ गेय मपने। मेको नाक्‍ती गे तुराही ताप्‍चा माल्‍नीनी। गन्‍ती १०:१०; लेवी २३:२४-२५ ");
INSERT INTO suzBl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","गे परमप्रभु यावे कली चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको परमप्रभु यावे कली आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके बाक्‍ब। गेपुकीमी ब्‍यफ का, सांड का नु बर्स का का गाप्‍शो ७ ओटा पाठा चढ़ेचा माल्‍नीनी। मेको मारेइ मदुम्‍शो थम रिम्‍शो दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","मिनु मेको ब्‍यफ नु अन्‍न चढ़ेतीके, तेल ब्‍वाइश्‍शो रिम्‍शो फस एफाह का १० भाग ङा भाग सां नु सांड नु १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर पुक्‍तीके का बाक्‍ब। भाग सां ६ नु आधा लिटर खोदेंशो बाक्‍ब। भाग निक्‍शी ४ नु आधा लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","मिनु मेको ७ ओटा पाठा नु का का पा भाग का चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","मिनु इन पाप आ पर्बम पाप क्‍याम्‍तीक गेय पचा कली बोका का चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","मेको नेल्‍ले औंसी नाक्‍त ङा चोशा चढ़ेतीक नु मेको नु अन्‍न चढ़ेतीके, नाक्‍त किंत किंत ङा चोशा चढ़ेतीक नु मेको नु अन्‍न चढ़ेतीके, मेको नेल्‍ल नु तूचा थोव़क चढ़ेतीके यो चढ़ेचा माल्‍नीनी। मेको नेल्‍ले परमप्रभु यावेमी देंशो खोदेंशो पा आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीक बाक्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","मेको ७ महिना ङा १० नाक्‍त परमप्रभु यावे नु ग्रुम्‍तीके का दुम्‍चा माल्‍ब। मेको नाक्‍ती गे माइजा बाक्‍शा, काइ गेय मपने। लेवी २३:२७-३२ ");
INSERT INTO suzBl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","गे परमप्रभु यावे कली चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो चढ़ेतीके बाक्‍ब। मिनु गे ब्‍यफ का, सांड का नु बर्स का का गाप्‍शो ७ ओटा पाठा चढ़ेचा माल्‍नीनी। मेको थम रिम्‍शो मारेइ मदुम्‍शो दुम्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","मिनु मेको ब्‍यफ नु अन्‍न चढ़ेतीके, तेल ब्‍वाइश्‍शो रिम्‍शो फस एफाह का ङा १० भाग ङा भाग सां नु सांड नु १० भाग ङा भाग निक्‍शी चढ़ेचा माल्‍नीनी। एफाह का २२ लिटर खोदेंशो बाक्‍ब ");
INSERT INTO suzBl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","मिनु मेको ७ ओटा पाठा नु का का पा भाग का का पा चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। लेवी १६:११-२८ ");
INSERT INTO suzBl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","गे ७ महिना ङा १५ नाक्‍ती परमप्रभु यावे नु ग्रुम्‍तीके का सेल्‍चा माल्‍नीनी। मेको नाक्‍ती गे काइ गेय मपने। गे परमप्रभु यावे कली ७ नाक्‍त सम्‍म चाड मानेचा माल्‍नीनी। लेवी २३: ३४-४३ ");
INSERT INTO suzBl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","गेपुकीमी परमप्रभु यावे कली चोशा चढ़ेतीके चढ़ेचा माल्‍नीनी। मेको आ दाक्‍शो ब्रोव़शो रिना पाइश्‍शो मीम चोशा चढ़ेतीके बाक्‍ब। मेको चोशा चढ़ेतीके मार बाक्‍चा माल्‍नीम देंशा हना, १३ ओटा ब्‍यफ, सांड निक्‍शी नु बर्स का गाप्‍शो १४ ओटा पाठा बाक्‍चा माल्‍नीम। मेको नेल्‍ल थम रिम्‍शो मारेइ मदुम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","मिनु मेको नु अन्‍न चढ़ेतीके तेल ब्‍वाइश्‍शो रिम्‍शो फस बाक्‍चा माल्‍ब। मेको १३ ओटा ब्‍यफ आन कली का का पा एफाह का ङा १० भाग ङा भाग सां चढ़ेचा माल्‍नीम। मेको सांड निक्‍शी नु एफाह का ङा १० भाग ङा भाग निक्‍शी रिम्‍शो तेल ब्‍वाइश्‍शो फस चढ़ेचा माल्‍नीम। एफाह का २२ लिटर खोदेंशो बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","मिनु मेको १४ ओटा पाठा नु का का पा भाग का का रिम्‍शो फस चढ़ेचा माल्‍नीनी। भाग ला ब्रेक्‍शो बाक्‍त हना, एफाह ङा १० भाग ङा भाग का मिम्‍सीब। मेको २ लिटर २०० सी सी बाक्‍ब। ");
INSERT INTO suzBl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","मिनु मेको आ दीसा गे १२ ओटा ब्‍यफ, सांड निक्‍शी १४ ओटा बर्स का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल थम रिम्‍शो मारेइ मदुम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ङोंइती ङा खोदेंशो पा ब्‍यफ, सांड नु पाठा आन कली हिक्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","मिनु मेको आ दीसा गे ११ ओटा ब्‍यफ, सांड निक्‍शी १४ ओटा बर्स का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल मारेइ मदुम्‍शो थम रिम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ङोंइती ङा खोदेंशो पा ब्‍यफ, सांड नु पाठा आन कली हिक्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","मिनु मेको आ दीसा गे १० ओटा ब्‍यफ, सांड निक्‍शी १४ ओटा बर्स का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल मारेइ मदुम्‍शो थम रिम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ङोंइती ङा खोदेंशो पा ब्‍यफ, सांड नु पाठा आन कली हिक्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","मिनु मेको आ दीसा गे ९ ओटा ब्‍यफ, सांड निक्‍शी, १४ ओटा बर्स का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल थम रिम्‍शो मारेइ मदुम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ङोंइती ङा खोदेंशो पा ब्‍यफ, सांड नु पाठा आन कली हिक्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा चढ़ेतीके, मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","मिनु मेको आ दीसा गे ८ ओटा ब्‍यफ, सांड निक्‍शी १४ ओटा बर्स का गाप्‍शो पाठा चढ़ेचा माल्‍नीनी। मेको नेल्‍ल मारेइ मदुम्‍शो थम रिम्‍शो बाक्‍चा माल्‍नीम। ");
INSERT INTO suzBl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","मेको नु अन्‍न चढ़ेतीके नु तूचा थोव़क चढ़ेतीके ङोंइती ङा खोदेंशो पा ब्‍यफ, सांड नु पाठा आन कली हिक्‍शा, चढ़ेचा माल्‍नीनी। ");
INSERT INTO suzBl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","मिनु मेको नु पाप पशो आ पर्बम बोका का चढ़ेचा माल्‍नीनी। मेको पाप पशो क्‍याम्‍तीक गेय पचा कली चढ़ेशा यो नाक्‍त किंत किंत ङा चोशा