﻿USE sofia;
DROP TABLE IF EXISTS sofia.susa_vpl;
CREATE TABLE susa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES susa_vpl WRITE;
INSERT INTO susa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","عَ قْلّ رَ، عَلَ نَشَ كٌورٍ نُن بْشِ دَا. ");
INSERT INTO susa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","دُنِحَ مُ نُ يَءِلَنشِ، سٍسٍ مُ نُ نَ عَ مَ. دِ مِ نَن نُ نَ بَا بِرِن مَ، كْنْ عَلَ حّنفِ نَشَن لُشِ عَلْ قٌيٍ نُ عَ مَلِنتَنمَ يٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","عَلَ نَشَ عَ مَسٍن، «نَءِيَلَنيِ شَ مِنِ.» نَءِيَلَنيِ نَشَ مِنِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","عَلَ نَشَ عَ مَتٌ قَ، نَ نَءِيَلَنيِ قَنشِ. عَلَ نَشَ نَءِيَلَنيِ نُن دِ مِ عِتَشُن. ");
INSERT INTO susa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","عَلَ نَشَ نَءِيَلَنيِ شِلِ سَ «يَنيِ.» عَ نَشَ دِ مِ شِلِ سَ «كْي.» كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي سِنفٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","عَلَ نَشَ عَ مَسٍن، «كٌورٍ وَلَشّ شَ لُ بْشِ يٍ نُن كٌورٍ يٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","نَ بَرَ قِندِ نَانِنيِ رَ بْشِ يٍ نُن كٌورٍ يٍ تَفِ. عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","عَلَ نَشَ يِ نَانِنيِ شِلِ سَ «كٌورٍ.» كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي قِرِن ندٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","عَلَ نَشَ عَ مَسٍن، «بْشِ يٍ شَ مَلَن يِرٍ كٍرٍن. شَرٍ شَ مَبَ.» عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","عَلَ نَشَ نَ شَرٍ شِلِ سَ «بْشِ.» عَ نَشَ نَ بْشِ يٍ شِلِ سَ «بَا.» عَلَ نَشَ عَ مَتٌ قَ، نَ بِرِن قَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","عَلَ نَشَ عَ مَسٍن، «سَنسِيٍ شَ مِنِ بْشِ مَ. سَنسِ مْولِ بِرِن شَ بُلَ. سَنسِ شْرِ نَشَن نَ عَ بٌفِ كُي، عَ بُلَمَ نّ بِرِن نُن عَ مْولِ رَ.» عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","بْشِ نَشَ رَقٍ سَنسِ مْولِ بِرِن نَ، عَ بٌفِ نُن عَ سَنسِ شْرِ نَ عَ بِلِ مَ، نَ قَن بِرِن نُن عَ مْولِ. عَلَ نَشَ عَ مَتٌ قَ، نَ بِرِن قَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي سَشَن ندٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","عَلَ نَشَ عَ مَسٍن، «يَنبَسٍيٍ شَ لُ كٌورٍ مَ، يَنيِ نُن كْي عِتَشُنقٍ رَ. وَشَتِ بِرِن كٌلٌنمَ يَنبَسٍيٍ سَابُي نَن نَ. شِ يٌ شِ، حّ يٌ حّ عَ كٌلٌنمَ يَنبَسٍيٍ نَن سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","يَنبَسٍ نَ كٌورٍ مَ بْشِ عِيَلَنسٍ نَن نَ.» عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","عَلَ نَشَ نَءِيَلَنسٍ شُنفبٍ قِرِن نَقَلَ. نَشَن شُنفبٌ، نَ شَ يَنيِ يَامَرِ رَبَ. نَشَن شُرُن، نَ شَ كْي يَامَرِ رَبَ. عَ نَشَ تُنبُييٍ قَن نَقَلَ. ");
INSERT INTO susa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","عَلَ نَشَ يَنبَسٍيٍ سَ كٌورٍ مَ عَلَكٌ عٍ شَ بْشِ عِيَلَن، ");
INSERT INTO susa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","عٍ شَ يَنيِ نُن كْي يَامَرِ رَبَ، عٍ شَ دِ مِ نُن نَءِيَلَنيِ رَقَتَن. عَلَ نَشَ عَ مَتٌ قَ، عَ بِرِن قَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي نَانِ ندٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","عَلَ نَشَ عَ مَسٍن، يّشّيٍ شَ يٍ رَ مَشَ. شْنِيٍ شَ حّرّ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","عَلَ نَشَ يّشّ شُنفبٍ مْولِ بِرِن دَا عَ نُن نِمَسٍ نَشَن بِرِن نَ يٍ شْورَ. عَ نَشَ شْنِ مْولِ بِرِن قَن دَا. عَلَ نَشَ عَ مَتٌ قَ، عَ بِرِن قَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","عَلَ نَشَ بَرَكّ سَ عٍ شَ قٍ. عَ نَشّ، «وٌ شَ وُيَ، وٌ شَ يِرِوَ عَلَكٌ يّشّيٍ شَ وُيَ بَا مَ. شْنِيٍ قَن شَ فبٌ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي سُولِ ندٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","عَلَ نَشَ عَ مَسٍن، «نِمَسٍيٍ مْولِ بِرِن شَ لُ بْشِ مَ؛ شُرُ سٍيٍ، بُبُسٍيٍ، عَ نُن بُورُنيِ سُبٍيٍ.» عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","عَلَ نَشَ بُورُنيِ سُبٍيٍ مْولِ بِرِن دَا، عَ نَشَ شُرُ سٍيٍ مْولِ بِرِن دَا، عَ نَشَ بُبُسٍيٍ مْولِ بِرِن دَا. عَلَ نَشَ عَ مَتٌ قَ، عَ بِرِن قَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","عَلَ نَشَ عَ مَسٍن، «وٌن شَ عَدَ مَ دَا، وٌن شَ وٌن قْشِ لُ عَ مَ. عَ شَ يَامَرِ رَبَ يّشّيٍ شُن مَ، شْنِيٍ شُن مَ، شُرُ سٍيٍ شُن مَ، بْشِ شُن مَ، عَ نُن بُبُسٍيٍ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","عَلَ نَشَ عَدَ مَ دَا فِنّ نُن شّمّ، عَ عَ قْشِ لُ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","عَلَ نَشَ بَرَكّ سَ عٍ شَ قٍ. عَ نَشّ، «وٌ شَ وُيَ، وٌ شَ يِرِوَ عَلَكٌ بْشِ شَ رَقٍ. وٌ شَ يَامَرِ رَبَ بْشِ شُن مَ، يّشّيٍ شُن مَ، شْنِيٍ شُن مَ، بُبُسٍيٍ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","عَ نَشّ، «ﭑ بَرَ سَنسِ بِرِن نُن سَنسِ بٌفِ بِرِن قِ وٌ مَ بَلٌي رَ. ");
INSERT INTO susa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ﭑ بَرَ سَنسِ بِرِن قِ سُبٍ بِرِن مَ نَشَن نَ بْشِ مَ، عَ نُن شْنِ بِرِن مَ، عَ نُن بُبُسٍ بِرِن مَ، نِمَسٍ بِرِن مَ نَشٍيٍ حّنفِمَ. سَنسِ بِرِن بَرَ قِندِ عٍ بَلٌي رَ.» عَ رَبَشِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","عَلَ نَشَ عَ شَ دَالِسٍ بِرِن مَتٌ قَ، عَ قَنشِ هَن. كْي نَشَ سٌ، كُيٍ نَشَ عِبَ، لْشْي سٍننِ ندٍ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","كٌورٍ، بْشِ، نُن سٍ بِرِن دَا كِ نَن نُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","لْشْي سٌلٌقٍرٍ ندٍ عَلَ شَ وَلِ نَشَ كَمَلِ. عَ نَشَ عَ مَلَبُ. ");
INSERT INTO susa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","عَلَ نَشَ تِدٍ سَ نَ لْشْي سٌلٌقٍرٍ ندٍ مَ، عَ شَ قِندِ لْشْي سّنِيّنشِ رَ بَرِ مَ عَ عَ مَلَبُ نَ لْشْي نّ عَ شَ وَلِ كَمَلِشِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","تَرُشُي نَن يَ، دُنِحَ دَاشِ كِ نَشّ. مَرِفِ عَلَتَلَ بْشِ نُن كٌورٍ دَا تّمُي نَشّ، ");
INSERT INTO susa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","قْتْنيِ يٌ مُ نُ نَ. سَنسِ يٌ مُ نُ نَ نَشَن بُلَشِ بْشِ مَ بَرِ مَ مَرِفِ عَلَتَلَ مُ نُ تُنّ يٍ رَفٌرٌشِ سِندٍن. عَدَ مَ قَن مُ نُ نَ نَشَن بْشِ رَوَلِمَ، ");
INSERT INTO susa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","كْنْ يٍ نُ لُمَ مِنِ رَ بْشِ بُن، عَ قَ يٍنسٍن يّ يِرٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","مَرِفِ عَلَتَلَ نَشَ عَدَ مَ يَءِلَن بّندّ رَ. نَ دَنفِ شَنبِ عَ نَشَ نِي رَ سٌ عَ قَتٍ عَ حْي كُي. عَ قِندِ عَدَ مَ رَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","نَ شَنبِ مَرِفِ عَلَتَلَ نَشَ يِرٍ قَنيِ يَءِلَن سٌفٍتٍدٍ مَبِرِ. نَ يِرٍ شِلِ «عٍدٍن.» عَ نَشَ عَدَ مَ لُ مّننِ. ");
INSERT INTO susa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","مَرِفِ عَلَتَلَ نَشَ وُرِ مْولِ بِرِن نَبُلَ مّننِ، وُرِ تٌقَنيِيٍ، وُرِ نَشٍيٍ بٌفِ قَن عَ دٌن دَاشِ رَ. نَ يِرٍ تَفِ وُرِ قِرِن نُ نَ. كٍرٍن شِلِ «سِمَيَ وُرِ.» بٌورٍ شِلِ «قٍ قَنيِ نُن قٍ حَاشِ كٌلٌن وُرِ.» ");
INSERT INTO susa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","شُرٍ نَشَن يٍ رَ سٌشِ عٍدٍن كُي سَنسِيٍ بّ، عَ تٌ دَنفِشِ، عَ عِتَشُنشِ دْشْ نَانِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","نَ سِنفٍ شِلِ ثِسٌن. نَ نَن دَنفِمَ هَوِلَ بْشِ بِرِن مَ، شّيمَ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","نَ شّيمَ قَن. وُرِ يٍ شِرِ حْشُنمّ قَن نَ نَ، عَ نُن فّمّ تٌقَنيِ نَشَن شِلِ عٌنِشِ. ");
INSERT INTO susa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","نَ شُرٍ قِرِن ندٍ شِلِ فِشٌن. نَ نَن دَنفِمَ كُسِ بْشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","نَ شُرٍ سَشَن ندٍ شِلِ تِفِرِ. نَ نَن دَنفِمَ عَسُرِ بْشِ مَ عَ سٌفٍتٍدٍ بِرِ رَ. نَ شُرٍ نَانِ ندٍ شِلِ عٍقِرَتِ. ");
INSERT INTO susa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","مَرِفِ عَلَتَلَ نَشَ عَدَ مَ رَ سَبَتِ عٍدٍن، عَلَكٌ عَ شَ نْ نَ يِرٍ رَوَلِدٍ، عَ مَن شَ مّينِ نَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","مَرِفِ عَلَتَلَ نَشَ يَامَرِ سٌ عَدَ مَ يِ رَ، عَ نَشّ، «عِ نْمَ يِ وُرِ بٌفِ بِرِن دٌندٍ نَشَن نَ عٍدٍن كُي، ");
INSERT INTO susa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","كْنْ عِ نَشَ ‹قٍ قَنيِ نُن قٍ حَاشِ كٌلٌن وُرِ› بٌفِ دٌن دٍ، بَرِ مَ عِ نُ نَ دٌن، عِ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","مَرِفِ عَلَتَلَ نَشَ عَ قَلَ، «عَ مُ قَن شّمّ شَ لُ بٍ عَ كٍرٍن. ﭑ قَمَ مَلِمَ قَنيِ دَالِدٍ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","بُورُنيِ سُبٍ بِرِن نُن شْنِ بِرِن مَرِفِ عَلَتَلَ نَشَن دَالِشِ بّندّ رَ، عَ نَشَ عٍ شَنِن عَدَ مَ شْن مَ عَ شَ عٍ شِلِ سَ. عَدَ مَ شِلِ نَشٍيٍ سَ عٍ شُن مَ، نٍيٍ نَشَ قِندِ عٍ شِلِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","عَ نَشَ شُرُ سٍ بِرِن، شْنِ بِرِن، عَ نُن بُورُنيِ سُبٍ بِرِن شِلِ سَ. كْنْ نَ وَشَتِ عَدَ مَ مُ عَ مَلِمَ قَنيِ سْتْشِ سِندٍن. ");
INSERT INTO susa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","مَرِفِ عَلَتَلَ نَشَ شِ شْلِ رَدَنفِ عَ مَ. عَ نَشَ عَ رَشِ عَ قَنيِ رَ. عَ تٌ شِ، مَرِفِ عَلَتَلَ نَشَ عَ فَنيَنيِ شْرِ كٍرٍن بَ، عَ قَ مّننِ رَفَلِ. ");
INSERT INTO susa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","نَ شَنبِ، مَرِفِ عَلَتَلَ نَشَ عَدَ مَ فَنيَنيِ شْرِ قِندِ فِنّ رَ، عَ قَ نَ فِنّ قِ عَدَ مَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","عَدَ مَ نَشَ عَ قَلَ، «يِ فِنّ قَتَنشِ ﭑ شْرِ نُن ﭑ سُبٍ نَن نَ. عَ شِلِ نّ ‹فِنّ›، بَرِ مَ عَ مِنِشِ شّمّ نّ عِ.» ");
INSERT INTO susa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","نَ قٍ نَ عَ تٌشِ، شّمّ قَمَ نّ كٍلِدٍ عَ بَبَ نُن عَ نفَ شُن مَ، عَ مَسٌ عَ شَ فِنّ رَ، عٍ قِندِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","شّمّ نُن عَ شَ فِنّ مَفٍلِ نَن نُ عَ رَ، كْنْ نَ قٍ يَافِ مُ نُ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","بْشِمَسٍ نَن نُ كْوتَ مَرِفِ عَلَتَلَ شَ دَالِسٍ بِرِن بّ. عَ نَشَ فِنّ مَشْرِن، «عَلَ عَ قَلَ نّ وٌ بّ عَ وُرِ بٌفِ نَشَن بِرِن نَ عٍدٍن كُي، عَ وٌ نَشَ عَ سٍسٍ دٌن؟ نْندِ نَ عَ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","فِنّ نَشَ عَ يَابِ، «وُرِ نَشٍيٍ نَ عٍدٍن كُي، مُشُ نْمَ عٍ بِرِن بٌفِ دٌندٍ، ");
INSERT INTO susa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","كْنْ وُرِ نَشَن نَ عٍدٍن تَفِ، مُشُ مُ نْمَ نَ تَن بٌفِ دٌندٍ، مُشُ مُ نْمَ مَكْرّدٍ عَ رَ يّتّ يَتِ، شَ نَ مُ عَ رَ مُشُ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","بْشِمَسٍ نَشَ عَ قَلَ فِنّ بّ، «عَدٍ، وٌ مُ قَشَمَ. ");
INSERT INTO susa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","عَلَ عَ كٌلٌن، وٌ نَ عَ دٌن، وٌ يَ رَبِمَ نّ. وٌ قَمَ قٍ قَنيِ نُن قٍ حَاشِ كٌلٌندٍ عَلْ عَلَ يّتّ.» ");
INSERT INTO susa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","فِنّ تٌ وُرِ بٌفِ تٌ، عَ تٌقَن، عَ قَن دٌنسٍ رَ، عَ قَن شَشِلِ سْتْسٍ رَ، عَ نَشَ كٍرٍن بَ، عَ دٌن، عَ ندٍ سٌ عَ شَ مْرِ يِ، عٍ نُن نَشَن نُ عَ رَ. نَ قَن نَشَ عَ دٌن. ");
INSERT INTO susa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","نَ وَشَتِ عٍ يَيٍ نَشَ رَبِ. عٍ نَشَ عَ كٌلٌن، عٍ مَفٍلِ نَن نُ عَ رَ. عٍ نَشَ شْرّ بُرّشّيٍ دّنبّ عٍ بٌورٍ رَ، عٍ عٍ يّتّ سُتُرَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","نَ شَنبِ، شّمّ نُن عَ شَ فِنّ نَشَ مَرِفِ عَلَتَلَ حّرّ شُي مّ نُنمَرٍ رَ. عٍ نَشَ عٍ نْشُن وُرِيٍ شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","مَرِفِ عَلَتَلَ نَشَ شِلِ تِ، «عَدَ مَ، عِ نَ مِندٍن؟» ");
INSERT INTO susa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","عَدَ مَ نَشَ عَ يَابِ، «ﭑ بَرَ عِ شُي مّ عٍدٍن كُي، كْنْ ﭑ بَرَ فَاشُ، بَرِ مَ ﭑ مَفٍلِ نَ عَ رَ. نَ نَن عَ رَ، ﭑ نَن ﭑ نْشُنشِ.» ");
INSERT INTO susa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","مَرِفِ عَلَتَلَ نَشَ عَ مَشْرِن، «ندٍ عَ مَسٍنشِ عِ بّ عِ مَفٍلِ نَ عَ رَ؟ كَ عِ بَرَ نَ وُرِ بٌفِ دٌن بَ، ﭑ نَشَن مَ قٍ قَلَ عِ بّ عِ نَشَ عَ دٌن؟» ");
INSERT INTO susa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","عَدَ مَ نَشّ، «عِ فِنّ نَشَن قِشِ ﭑ مَ، نَ نَن يِ وُرِ بٌفِ سٌ ﭑ يِ رَ، ﭑ نَشَ عَ دٌن.» ");
INSERT INTO susa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","نَ شَنبِ، مَرِفِ عَلَتَلَ نَشَ فِنّ مَشْرِن، «عِ يِ رَبَشِ مُنقٍ رَ؟» فِنّ نَشَ عَ يَابِ، «بْشِمَسٍ بَرَ ﭑ مَدَشُ هَن ﭑ بَرَ نَ وُرِ بٌفِ دٌن.» ");
INSERT INTO susa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","عَوَ، مَرِفِ عَلَتَلَ نَشَ عَ قَلَ بْشِمَسٍ بّ، «عِ تٌ بَرَ يِ رَبَ، عَوَ، ﭑ قَن ﭑ بَرَ عِ دَنكَ شُرُ سٍ نُن بُورُنيِ سُبٍ بِرِن يَ مَ. عِ قِندِ مَ بُبُسٍ نَن نَ عِ قُرِ قَرِ. عِ شُبٍ نَن دٌنمَ عِ شَ دُنِحّءِفِرِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ﭑ بَرَ دّحَاشُي رَ سٌ عِ تَن نُن فِنّ تَفِ. ﭑ بَرَ عَ رَ سٌ عِ شَ دِيٍ نُن عَ شَ دِيٍ تَفِ. فِنّ شَ دِ عِ شُنيِ بُتُشُنمَ نّ. عِ قَن عَ تِنفِلِنيِ شِنمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","مَرِفِ عَلَتَلَ نَشَ عَ قَلَ فِنّ بّ، «عِ قَن، ﭑ عِ تْورْ مَ نّ عِ شَ دِ بَرِ كُي. نَ تْورّ فبٌمَ نّ. عِ بِرَ مَ نّ عِ شَ مْرِ قْشْ رَ، عَ عِ يَمَرِ.» ");
INSERT INTO susa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","مَرِفِ عَلَتَلَ نَشَ عَ قَلَ عَدَ مَ بّ، «عِ بَرَ بِرَ عِ شَ فِنّ قْشْ رَ. عِ بَرَ نَ وُرِ بٌفِ دٌن، ﭑ نَشَن مَ قٍ قَلَ عِ بّ، عِ نَشَ عَ دٌن. يَكْسِ ﭑ بَرَ بْشِ دَنكَ عِ شَ قٍ رَ. عِ تْورْ مَ نّ بَلٌي سْتْدٍ عِ شَ دُنِحّءِفِرِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ﭑ تُنبٍ نُن بَافِ رَ مِنِمَ نّ بْشِ مَ، عِ بَلٌي سْتْمَ شّ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","عِ بَلٌي سْتْمَ عِ يِلٍنقُرٍ نَن نَ هَن عِ فبِلٍنمَ بّندّ تّمُي نَشّ عِ رَقَلَشِ نَشَن نَ. بّندّ نَن عِ رَ، عِ مَن فبِلٍنمَ نَ بّندّ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","عَدَ مَ نَشَ عَ شَ فِنّ شِلِ سَ «مَهَوَ،» بَرِ مَ عَ قِندِ مَ نّ مِشِ بِرِن نفَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","مَرِفِ عَلَتَلَ نَشَ دُفِ كِرِ دَاشِيٍ دّفّ عَدَ مَ نُن عَ شَ فِنّ بّ، عَ نَشَ عٍ رَفٌرٌ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","مَرِفِ عَلَتَلَ نَشَ عَ مَسٍن، «عَدَ مَ بَرَ قٍ قَنيِ نُن قٍ حَاشِ تَفِ رَبَ كٌلٌن عَلْ وٌن تَن. عَ مُ دَشَ عَ شَ سِمَيَ وُرِ بٌفِ دٌن، شَ نَ مُ عَ رَ عَ مُ قَشَمَ.» ");
INSERT INTO susa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","مَرِفِ عَلَتَلَ نَشَ عَ رَ مِنِ عٍدٍن، عَ شَ بْشِ رَوَلِ عَلَ عَ دَاشِ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","عَ عَدَ مَ كٍرِ شَنبِ، مَرِفِ عَلَتَلَ نَشَ مَلٍكّيٍ يَامَرِ، عٍ شَ تِ عٍدٍن سٌفٍتٍدٍ بِرِ رَ. عٍ شَ نُ سَنتِدّفّمَ تّ دَاشِ مَلِنتَن، نَ سِمَيَ وُرِ كَنتَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","عَدَ مَ نُن مَهَوَ تٌ كَقُ، مَهَوَ نَشَ تّيفّ. عٍ نَشَ دِ سْتْ نَشَن شِلِ كَبِلَ. مَهَوَ نَشّ، «عَلَتَلَ بَرَ ﭑ مَلِ دِ شّمّ سْتْقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","نَ شَنبِ مَهَوَ نَشَ كَبِلَ شَنبِرَتٌي شّمّمَ سْتْ نَشَن شِلِ هَبِلَ. شُرُ سٍ دّ مَدٌنيِ نَن نُ هَبِلَ رَ. بْشِ رَوَلِ نَن نُ كَبِلَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","نَ تّمُي تٌ دَنفِ، كَبِلَ نَشَ قَ سَنسِ بٌفِ قَنفَدَ مَ رَ سّرّشّ بَدٍ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","كْنْ هَبِلَ نَشَ قَ شُرُ سٍ دِ سِنفٍيٍ رَ نُن عٍ تُرٍ. هَبِلَ نُن عَ شَ سّرّشّ نَشَ رَقَن عَلَتَلَ مَ، ");
INSERT INTO susa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","كْنْ كَبِلَ نُن عَ شَ سّرّشّ مُ نُ رَقَن عَلَتَلَ مَ. عَلَتَلَ مُ عَ يَ تِ كَبِلَ شَ سّرّشّ رَ. نَ نَ عَ رَ، كَبِلَ نَشَ شْنْ، عَ يَتَفِ نَشَ مَسَرَ. ");
INSERT INTO susa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","نَ شَنبِ عَلَتَلَ نَشَ كَبِلَ مَشْرِن، «عِ شْنْشِ مُنقٍ رَ؟ عِ يَتَفِ مَسَرَشِ مُنقٍ رَ؟ ");
INSERT INTO susa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","شَ عِ قٍ قَنيِ رَبَ، ﭑ نَ تٌنفٌمَ نّ، كْنْ شَ عِ قٍ حَاشِ رَبَ، سٍنتَنّ عِ رَتَنتَنمَ نّ. عِ كَتَ، عِ شَ عِ يّتّ بَ عَ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","كَبِلَ نَشَ عَ قَلَ عَ شُنيَ بّ، «وٌن شّي شّ مَ.» عٍ تٌ سٌ شّ مَ، كَبِلَ نَشَ عَ شُنيَ هَبِلَ سُشُ، عَ نَشَ عَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","نَ شَنبِ عَلَتَلَ نَشَ كَبِلَ مَشْرِن، «عِ شُنيَ هَبِلَ نَ مِندٍن؟» عَ نَشَ عَ يَابِ، «ﭑ مُ عَ كٌلٌن. قٌ ﭑ شَ مّينِ ﭑ شُنيَ مَ؟» ");
INSERT INTO susa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","عَلَتَلَ نَشَ عَ قَلَ، «عِ مُنسٍ رَبَشِ؟ ﭑ نَ عِ شُنيَ وُلِ فبٍلٍفبٍلٍ شُي مّقٍ كٍلِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ﭑ بَرَ عِ دَنكَ بَرِ مَ عِ بَرَ عِ شُنيَ قَشَ. ﭑ عِ كٍرِ مَ نّ يِ بْشِ مَ عِ شُنيَ وُلِ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","عِ نَ بْشِ رَوَلِ، عِ مُ بَلٌي سْتْمَ. عِ قِندِ مَ حّرّتِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","كَبِلَ نَشَ عَلَتَلَ يَابِ، «نَ حَشَنكَتّ فبٌ ﭑ تَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","شَ عِ بَرَ ﭑ كٍرِ يِ بْشِ مَ تٌ، وٌن تَفِ عِكُيَمَ نّ. ﭑ قِندِ مَ حّرّتِ نَن نَ. مِشِ نَشَن نَ سَ ﭑ تٌ، عَ ﭑ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","عَلَتَلَ نَشَ عَ يَابِ، «عَدٍ، شَ مِشِ يٌ عِ قَشَ، ﭑ عِ فبٍحْشْمَ نّ دْشْ سٌلٌقٍرٍ.» عَلَتَلَ نَشَ تْنشُمَ سَ كَبِلَ مَ عَلَكٌ شَ نَشَن سَ عَ تٌ عَ نَشَ نْ عَ فٍرٍدٍ. ");
INSERT INTO susa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","نَ تّمُي كَبِلَ نَشَ عَ مَكُيَ عَلَتَلَ رَ. عَ نَشَ سَبَتِ نٌدِ بْشِ مَ عٍدٍن قُفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","كَبِلَ نُن عَ شَ فِنّ نَشَ كَقُ. عَ شَ فِنّ نَشَ تّيفّ، عَ نَشَ دِ سْتْ نَشَن شِلِ عٍنٌكِ. كَبِلَ نُ نَ تَا تِقٍ. عَ نَشَ عَ شَ دِ شِلِ سَ نَ تَا شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","عٍنٌكِ نَشَ عِرَدِ سْتْ. عِرَدِ، مٍشُيَيٍلِ بَبَ نَ عَ رَ. مٍشُيَيٍلِ، مٍتُسَيٍلِ بَبَ نَ عَ رَ. مٍتُسَيٍلِ، لَمٍكِ بَبَ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لَمٍكِ نَشَ فِنّ قِرِن سْتْ، كٍرٍن شِلِ عَدَ، بٌورٍ شِلِ سِلَهِ. ");
INSERT INTO susa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","عَدَ نَشَ يَبَلَ سْتْ. يَبَلَ، شُرُ سٍ دّ مَدٌنيِيٍ نُن كِرِ بَنشِ كَنيِيٍ بَبَ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","يَبَلَ شُنيَ شِلِ يُبَلِ. يُبَلِ، كْرَ بْنبْييٍ نُن شُلٍ قٍيٍ بَبَ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","سِلَهِ قَن نَشَ دِ سْتْ. عَ شِلِ تُبَلِ كَبِلَ. شَبُي نَن نُ عَ تَن نَ. وَلِسٍ وُرٍ فبٍيلِ نُن وُرٍ دَاشِ مْولِ بِرِن شَبُي نَن نُ عَ رَ. تُبَلِ كَيِنِ شُنيَ فِنّمَ شِلِ نَمَ. ");
INSERT INTO susa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","لَمٍكِ نَشَ عَ قَلَ عَ شَ فِنّيٍ بّ، «عَدَ نُن سِلَهِ وٌ شَ وٌ هَاكّ تٌ ﭑ بّ. لَمٍكِ شَ فِنّيٍ، وٌ شَ وٌ تُلِ مَتِ ﭑ مَ وْيّنيِ رَ. ﭑ بَرَ شّمّ ندٍ قَشَ فبٍحْشْي رَ. ﭑ بَرَ نَ سّفّتَلَ قَشَ بَرِ مَ عَ بَرَ ﭑ مَشْنْ. ");
INSERT INTO susa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","شَ مِشِ سٌلٌقٍرٍ نَن قَشَمَ كَبِلَ فبٍحْشْقٍ رَ، مِشِ تٌنفٌ سٌلٌقٍرٍ نُن سٌلٌقٍرٍ نَن قَشَمَ ﭑ تَن لَمٍكِ فبٍحْشْقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","عَدَ مَ نُن عَ شَ فِنّ نَشَ كَقُ. مَهَوَ نَشَ دِ سْتْ نَشَن شِلِ سٍتِ. عَ بَرَ نَ شِلِ سَ عَ شَ دِ شُن مَ بَرِ مَ عَلَ بَرَ عَ شَ دِ هَبِلَ حْشْي سٌ عَ يِ رَ كَبِلَ نَشَن قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","سٍتِ قَن نَشَ دِ سْتْ نَشَن شِلِ عٍنٌسِ. نَ وَشَتِ مِشِيٍ نَشَ عَلَتَلَ مَشَندِ قْلْ. ");
INSERT INTO susa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","عَدَ مَ نُن عَ بْنسْي شَ تَرُشُي نَن يَ. عَلَ تٌ عِبُنَدَ مَ دِيٍ دَا، عَ نَشَ عَ قْشِ لُ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","عَ نَشَ عٍ دَا شّمّ نُن فِنّ. عَ بَرَكّ سَ عٍ مَ. عَ عٍ شِلِ سَ «عَدَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","عَدَ مَ تٌ بُ حّ كّمّ حّ تٌنفٌ سَشَن، عَ نَشَ دِ سْتْ عَ يّتّ مِسَالِ رَ. عَ نَشَ عَ شِلِ سَ سٍتِ. ");
INSERT INTO susa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","سٍتِ شَ بَرِ دَنفِ شَنبِ، عَدَ مَ نَشَ بُ حّ كّمّ سٌلٌمَسَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","عَدَ مَ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ تٌنفٌ سَشَن. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","سٍتِ تٌ بُ حّ كّمّ حّ سُولِ، عَ نَشَ قِندِ عٍنٌسِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","عٍنٌسِ شَ بَرِ دَنفِ شَنبِ، سٍتِ نَشَ بُ حّ كّمّ سٌلٌمَسَشَن حّ سٌلٌقٍرٍ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","سٍتِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ قُ نُن قِرِن. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","عٍنٌسِ تٌ بُ حّ تٌنفٌ سٌلٌمَنَانِ، عَ نَشَ قِندِ كٍنَن بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","كٍنَن شَ بَرِ دَنفِ شَنبِ، عٍنٌسِ نَشَ بُ حّ كّمّ سٌلٌمَسَشَن حّ قُ نُن سُولِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","عٍنٌسِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ سُولِ. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","كٍنَن تٌ بُ حّ تٌنفٌ سٌلٌقٍرٍ، عَ نَشَ قِندِ مَهَلَلٍلِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","مَهَلَلٍلِ شَ بَرِ دَنفِ شَنبِ، كٍنَن نَشَ بُ حّ كّمّ سٌلٌمَسَشَن حّ تٌنفٌ نَانِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","كٍنَن شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ قُ. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","مَهَلَلٍلِ تٌ بُ حّ تٌنفٌ سٍننِ عَ نُن سُولِ، عَ نَشَ قِندِ يٍرٍدِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","يٍرٍدِ شَ بَرِ دَنفِ شَنبِ، مَهَلَلٍلِ نَشَ بُ حّ كّمّ سٌلٌمَسَشَن حّ تٌنفٌ سَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","مَهَلَلٍلِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَسَشَن نُن حّ تٌنفٌ سٌلٌمَنَانِ نُن سُولِ. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","يٍرٍدِ تٌ بُ حّ كّمّ حّ تٌنفٌ سٍننِ عَ نُن قِرِن، عَ نَشَ قِندِ عٍنٌكِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","عٍنٌكِ شَ بَرِ دَنفِ شَنبِ، يٍرٍدِ نَشَ بُ حّ كّمّ سٌلٌمَسَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","يٍرٍدِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ تٌنفٌ سٍننِ عَ نُن قِرِن. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","عٍنٌكِ تٌ بُ حّ تٌنفٌ سٍننِ عَ نُن سُولِ، عَ نَشَ قِندِ مٍتُسٍلَ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","مٍتُسٍلَ شَ بَرِ دَنفِ شَنبِ، عٍنٌكِ نَشَ بِرَ عَلَ قْشْ رَ حّ كّمّ سَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","عٍنٌكِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سَشَن نُن حّ تٌنفٌ سٍننِ عَ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","عٍنٌكِ نَشَ بِرَ عَلَ قْشْ رَ. نَ شَنبِ عَ مُ لُ نَ سْنْن، بَرِ مَ عَلَ بَرَ عَ شَنِن. ");
INSERT INTO susa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","مٍتُسٍلَ تٌ بُ حّ كّمّ حّ تٌنفٌ سٌلٌمَسَشَن عَ نُن سٌلٌقٍرٍ، عَ نَشَ قِندِ لَمٍكِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","لَمٍكِ شَ بَرِ دَنفِ شَنبِ، مٍتُسٍلَ نَشَ بُ حّ كّمّ سٌلٌقٍرٍ حّ تٌنفٌ سٌلٌمَسَشَن عَ نُن قِرِن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","مٍتُسٍلَ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌمَنَانِ نُن حّ تٌنفٌ سٍننِ عَ نُن سٌلٌمَنَانِ. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","لَمٍكِ تٌ بُ حّ كّمّ حّ تٌنفٌ سٌلٌمَسَشَن عَ نُن قِرِن، عَ نَشَ دِ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","عَ نَشَ عَ شِلِ سَ نُهَ. عَ نَشَ عَ قَلَ، «عَ قَمَ وٌن مَلِدٍ وٌن مَ تْورّ نُن وٌن مَ وَلِ كُي، وٌن نَشَن نَبَمَ بْشِ مَ عَلَتَلَ بَرَ دّننَشّ دَنكَ.» ");
INSERT INTO susa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","نُهَ شَ بَرِ دَنفِ شَنبِ، لَمٍكِ نَشَ بُ حّ كّمّ سُولِ حّ تٌنفٌ سٌلٌمَنَانِ عَ نُن سُولِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","لَمٍكِ شَ سِمَيَ نَشَ سِفَ حّ كّمّ سٌلٌقٍرٍ نُن حّ تٌنفٌ سٌلٌقٍرٍ عَ نُن سٌلٌقٍرٍ. نَ شَنبِ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","نُهَ تٌ بُ حّ كّمّ سُولِ، عَ نَشَ قِندِ سٍمِ، هَمِ، نُن يٍقٍتِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","نَ تّمُي شّمّيٍ نُن عٍ شَ دِ فِنّيٍ نَشَ وُيَ قْلْ. ");
INSERT INTO susa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","عَلَ شَ مَلٍكّيٍ نَشَ يَبُ يِ دِ فِنّيٍ رَ عٍ شَ تٌقَنيِ مَ. مَلٍكّيٍ نَشَ ندٍيٍ سُفَندِ، عٍ نَشَ عٍ قِندِ عٍ شَ فِنّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","نَ شَنبِ، عَلَتَلَ نَشَ عَ قَلَ، «ﭑ مُ تِنمَ نِي شَ بُ عَدَ مَ قَتٍ عَبَدَن، بَرِ مَ دَالِسٍ نَ عَ رَ. عَ مُ دَنفِمَ حّ كّمّ حّ مْشْحّن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","نَ وَشَتِ، عَ نُن وَشَتِ نَشَن قَ نَ شَنبِ رَ، نَبِيٌرٌ بْنسْي نُ نَ دُنِحَ مَ. نَ مَلٍكّيٍ نُن نَ دِ فِنّيٍ نَن نٍيٍ بَرِشِ. فٍرٍ سٌي بٍلٍبٍلٍيٍ نُن شِلِ شُنفبٍ كَنيِيٍ نَن نُ نَبِيٌرٌ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","عَلَتَلَ نَشَ عَ تٌ عَدَ مَ بَرَ كٌبِ. تّمُي بِرِن عَ شَ مَحْشُنيِيٍ قِندِشِ عَ كٌبِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","نَ نَشَ عَلَتَلَ تْورْ هَن عَ بَرَ عَ يّتّ مَشْرِن مُنقٍ رَ عَ عَدَ مَ دَاشِ. نَ قٍ نَشَ عَ بْحّ تْورْ كِ قَنيِ. ");
INSERT INTO susa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","عَلَتَلَ نَشَ عَ قَلَ، «عَدَ مَ بِرِن ﭑ نَشَن دَاشِ، ﭑ نَ بِرِن تٌنفٌمَ نّ دُنِحَ مَ. مِشِ يٌ، سُبٍ يٌ، بُبُسٍ يٌ، شْنِ نَشَن حّرّ مَ كٌورٍ مَ يٌ، ﭑ نَ بِرِن تٌنفٌمَ نّ دُنِحَ مَ، بَرِ مَ ﭑ بَرَ نِمِسَ عَدَ مَ دَاقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","كْنْ نُهَ تَن نُ رَقَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","نُهَ شَ تَرُشُي نَن يَ. نُهَ نُ قِندِشِ تِنشِنتْي نُن سّنِيّنتْي نَن نَ نَ وَشَتِ مِشِيٍ تَفِ. عَ نُ بِرَ مَ عَلَ نَن قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","دِ سَشَن نَن نُ نُهَ يِ رَ؛ سٍمِ، هَمِ، نُن يٍقٍتِ. ");
INSERT INTO susa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","دُنِحَ نُ بَرَ كَنَ عَلَ يَ عِ، عَ شَ قٍ حَاشِ نُ بَرَ فبٌ يّ. ");
INSERT INTO susa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","عَلَ نَشَ دُنِحَ تٌ، عَ كَنَشِ، مِشِ بِرِن قٍ حَاشِ رَبَقٍ. ");
INSERT INTO susa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","نَ كُي عَلَ نَشَ عَ مَسٍن نُهَ بّ، «ﭑ وَ مَ عَدَ مَ بِرِن تٌنفٌقٍ دُنِحَ مَ، بَرِ مَ دُنِحَ بَرَ كٌبِ عَ حَاشِ رَ. ﭑ وَ مَ عَدَ مَ بِرِن نُن دُنِحَ بِرِن كَنَقٍ. ");
INSERT INTO susa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","عَ لَنمَ عِ شَ كُنكُي بَنبَن وُرِ رَ، نَشَن شِلِ فٌقٍرِ. كٌنكٌي شَ لُ عَ كُي. دٌلٍ شَ سَ عَ كُي نُن عَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","عِ شَ عَ يَءِلَن يِ كِ؛ عِ شَ كُنكُي رَكُيَ كَنكٍ يَ تٌنفٌ سٍننِ نُن سٌلٌقٍرٍ عَ نُن عَ تَفِ. عِ شَ عَ عِفبٌ كَنكٍ يَ قُ نُن كٍرٍن. عِ شَ عَ عِتٍ كَنكٍ يَ سٍننِ نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","عِ شَ كُنكُي شُنيِ يَءِلَن، نْنفْن يَ كٍرٍن شَ لُ كُنكُي شُنيِ نُن كُنكُي دّ كِرِ تَفِ. عِ شَ نَادّ تِ عَ سّيتِ كٍرٍن مَ. عِ شَ عَ كُي رَبَفَن دْشْ سَشَن.» ");
INSERT INTO susa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«نَ شَنبِ ﭑ تَن قَمَ يٍ رَدِندٍ دُنِحَ مَ. عَ مِشِ بِرِن سْنتْ. نِمَسٍ بِرِن قَشَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","كْنْ ﭑ بَرَ سَاتّ تٌنفٌ عِ بّ. عِ سٌمَ نّ يِ كُنكُي كُي، عِ تَن نُن عِ شَ دِيٍ، عَ نُن عِ شَ فِنّ، عَ نُن عِ شَ دِيٍ شَ فِنّيٍ. ");
INSERT INTO susa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","عِ شَ قَ نِمَسٍ مْولِ بِرِن قِرِن قِرِن نَ، شّمّ نُن فِنّ. نَ نَن عَ تٌمَ عٍ كِسِمَ. ");
INSERT INTO susa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","شْنِ بْنسْي بِرِن قِرِن قِرِن، سُبٍ بْنسْي بِرِن قِرِن قِرِن، بُبُسٍ بْنسْي بِرِن قِرِن قِرِن، عٍ قَمَ عِ شْن، عِ شَ عٍ رَكِسِ. ");
INSERT INTO susa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","عِ شَ دٌنسٍ مْولِ بِرِن بَكِ كُنكُي كُي. عِ شَ سَ عَ رَفَتَ عِ تَن بّ عَ نُن عٍ قَن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","نُهَ نَشَ عَ بِرِن نَبَ عَلَ نَشَن مَسٍنشِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","عَلَتَلَ نَشَ عَ مَسٍن نُهَ بّ، «سٌ كُنكُي كُي، عِ تَن نُن عِ شَ دٍنبَيَ بِرِن، بَرِ مَ عِ تَن تِنشِنتْي نَن عِ رَ يِ وَشَتِ مِشِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","سُبٍ رَدَشَشِ بِرِن، عِ شَ شّمّ سٌلٌقٍرٍ نُن فِنّ سٌلٌقٍرٍ بَكِ. سُبٍ رَهَرَ مُشِ بِرِن، عِ شَ شّمّ كٍرٍن نُن فِنّ كٍرٍن بَكِ. ");
INSERT INTO susa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","شْنِ قَن عَ مْولِ بِرِن، عِ شَ شّمّ سٌلٌقٍرٍ نُن فِنّ سٌلٌقٍرٍ بَكِ. نَ كُي سُبٍ مْولِ بِرِن شَ نْ لُدٍ دُنِحَ مَ بَنبَرَنيِ دَنفِ شَنبِ.» ");
INSERT INTO susa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","«شِ سٌلٌقٍرٍ نَ دَنفِ، ﭑ تُنّ رَفٌرٌ مَ بْشِ مَ. شِ تٌنفٌ نَانِ تُنّ قَمَ كْي نُن يَنيِ. نِمَسٍ بِرِن ﭑ نَشَن دَاشِ، نَ بِرِن سْنتْمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","نُهَ نَشَ نَ بِرِن نَبَ عَلَتَلَ نَشَن مَسٍن عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","نَ تُنّ قَمَ تّمُي نَشّ، نُهَ شَ سِمَيَ نُ نَ حّ كّمّ سٍننِ. ");
INSERT INTO susa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","نُهَ يٌ، عَ شَ فِنّ، عَ شَ دِيٍ نُن نٍيٍ قَن شَ فِنّيٍ، عٍ بِرِن نَشَ عٍ فِ يٍ مَ، عٍ سَ سٌ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","سُبٍ رَدَشَشِيٍ، سُبٍ رَهَرَ مُشِيٍ، شْنِيٍ، نُن بُبُسٍيٍ، عٍ بِرِن ");
INSERT INTO susa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","نَشَ سِفَ نُهَ شْن مَ كُنكُي كُي، شّمّيٍ نُن فِنّيٍ، عٍ سَ سٌ كُنكُي كُي عَلْ عَلَ نُهَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","شِ سٌلٌقٍرٍ دَنفِ شَنبِ، نَ بَنبَرَنيِ نَشَ دِن دُنِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","نُهَ شَ سِمَيَ نُ نَ حّ كّمّ سٍننِ، كِكٍ قِرِن، شِ قُ عَ نُن سٌلٌقٍرٍ. نَ لْشْي يٍ نَشَن نَ بْشِ بُن مَ، نَ نَشَ تٍ قْلْ، يٍ نَشَن نَ كٌورٍ مَ، نَ قَن نَشَ فٌرٌ قْلْ. ");
INSERT INTO susa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","تُنّ نَشَ بِرَ بْشِ مَ شِ تٌنفٌ نَانِ. كْي عَ نُن يَنيِ، تُنّ قَمَ. ");
INSERT INTO susa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","نَ لْشْي، نُهَ نُن عَ شَ دِيٍ، سٍمِ، هَمِ، يٍقٍتِ، عَ شَ فِنّ، نُن عَ شَ دِ سَشَنيِيٍ شَ فِنّيٍ، عٍ بِرِن نَشَ سٌ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","بُورُنيِ سُبٍ بْنسْي بِرِن، شُرُ سٍ بْنسْي بِرِن، بُبُسٍ بْنسْي بِرِن، عَ نُن شْنِ بْنسْي بِرِن، عٍ نَشَ سٌ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","دَالِسٍ نَشَن بِرِن حّنفِمَ، عَ قِرِن قِرِن، عٍ نَشَ قَ نُهَ شْن مَ، عٍ سَ سٌ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","نِمَسٍ بِرِن، شّمّ نُن فِنّ، عٍ سٌشِ نّ كُنكُي كُي عَلْ عَلَ نُهَ يَمَرِشِ كِ نَشّ. نَ شَنبِ عَلَتَلَ نَشَ نَادّ بَلَن. ");
INSERT INTO susa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","شِ تٌنفٌ نَانِ بَنبَرَنيِ تٍمَ. عَ نَشَ كُنكُي عِتٍ. ");
INSERT INTO susa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","يٍ تٌ فبٌ بْشِ مَ، كُنكُي نَشَ دْشْ يٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","يٍ نَشَ تٍ هَن عَ نَشَ فٍيَ بِرِن مَكٌتٌ دُنِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","يٍ نَشَ دُ سُ فٍيَ شُن هَن كَنكٍ يَ سٌلٌقٍرٍ نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","نِمَسٍ نَشَن بِرِن نُ حّرّ مَ دُنِحَ مَ، عٍ بِرِن نَشَ قَشَ؛ شْنِيٍ، شُرُ سٍيٍ، بُورُنيِ سُبٍيٍ، بُبُسٍيٍ، عَ نُن عَدَ مَدِيٍ. ");
INSERT INTO susa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","نِمَسٍ نَشَن بِرِن حّنفِمَ شَرٍ مَ، عٍ بِرِن نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","عَلَ نَشَ نِمَسٍ بِرِن بَ دُنِحَ مَ. نِمَسٍ بِرِن نَشَ قَشَ؛ عَدَ مَدِيٍ، شُرُ سٍيٍ، بُبُسٍيٍ، عَ نُن شْنِ نَشٍيٍ حّرّ مَ كٌورٍ مَ، قٌ نُهَ كٍرٍن، عَ نُن نَشٍيٍ نُ نَ عَ شُن مَ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","بَنبَرَنيِ نَشَ دِن دُنِحَ مَ شِ كّمّ شِ تٌنفٌ سُولِ. ");
INSERT INTO susa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","كْنْ عَلَ نَشَ رَتُ نُهَ مَ، عَ نُن بُورُنيِ سُبٍ نُن شُرُ سٍ نَشٍيٍ نُ نَ عَ شُن مَ كُنكُي كُي. عَلَ نَشَ قٌيٍ رَدِن دُنِحَ مَ، يٍ قَ شْرِ قْلْ. ");
INSERT INTO susa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","يٍ نَشَن نُ كٍلِمَ بْشِ بُن مَ، نَ نَشَ دَن. يٍ نَشَن نُ كٍلِمَ كٌورٍ مَ، نَ قَن نَشَ دَن. ");
INSERT INTO susa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","لْشْ يٌ لْشْ قٌ ندٍ بَ يٍ رَ. شِ كّمّ شِ تٌنفٌ سُولِ كَمَلِ شَنبِ، ندٍ نَشَ بَ يٍ رَ كِ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","كِكٍ سٌلٌقٍرٍ، شِ قُ نُن سٌلٌقٍرٍ ندٍ، كُنكُي نَشَ دْشْ فٍيَيٍ قَرِ، فٍيَ نَشٍيٍ نَ عَرَرَتِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","كِكٍ قُ شِ كٍرٍن كَمَلِ شَنبِ، فٍيَيٍ قَرِ نَشَ مَبَ. ");
INSERT INTO susa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","شِ تٌنفٌ نَانِ دَنفِ شَنبِ، نُهَ نَشَ وُندّرِ رَبِ نَشَن نَ كُنكُي مَ. ");
INSERT INTO susa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","عَ نَشَ شَشَ بّحِن، عَ نُ سِفَ، عَ نُ قَ، هَن يٍ نَشَ شُرُن. ");
INSERT INTO susa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","نَ شَنبِ عَ نَشَ فَنبّ بّحِن، عَ شَ كٌلٌن شَ يٍ بَرَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","كْنْ نَ فَنبّ نَشَ يِرٍ مَتٌ، سَنتِدٍ مُ نَ، بَرِ مَ يٍ دِنشِ دُنِحَ بِرِن مَ. عَ نَشَ فبِلٍن نُهَ يِرٍ. نُهَ نَشَ فَنبّ تٌنفٌ، عَ عَ رَ سٌ كُنكُي كُي. ");
INSERT INTO susa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","عَ نَشَ مَمّ تِ هَن شِ سٌلٌقٍرٍ، عَ مَن نَشَ فَنبّ بّحِن عَ قِرِن ندٍ. ");
INSERT INTO susa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","نُنمَرٍ، فَنبّ نَشَ فبِلٍن نُهَ يِرٍ، عٌلِوِ وُرِ حِنفِ سُشُشِ عَ دّكٌلٍ رَ. نَ كُي نُهَ نَشَ عَ كٌلٌن يٍ بَرَ بَ دُنِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","عَ نَشَ مَمّ تِ شِ سٌلٌقٍرٍ. عَ نَشَ فَنبّ بّحِن عَ سَشَن ندٍ، كْنْ فَنبّ مُ فبِلٍن. ");
INSERT INTO susa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","نُهَ شَ سِمَيَ تٌ سِفَ حّ كّمّ سٍننِ نُن حّ كٍرٍن، كِكٍ كٍرٍن، شِ كٍرٍن، بَنبَرَنيِ قَ حْن دُنِحَ مَ. نُهَ تٌ كُنكُي شُنيِ بَ نَا، عَ نَشَ عَ تٌ شَرٍ بَرَ مَبَ. ");
INSERT INTO susa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","كِكٍ قِرِن شِ مْشْحّن عَ نُن سٌلٌقٍرٍ تٌ دَنفِ، بْشِ نُ بَرَ شَرَ عَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","عَلَ نَشَ عَ مَسٍن نُهَ بّ، ");
INSERT INTO susa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«وٌ مِنِ كُنكُي كُي، عِ تَن نُن عِ شَ فِنّ، عِ شَ دِيٍ نُن عٍ شَ فِنّيٍ. ");
INSERT INTO susa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","عِ شَ نِمَسٍ بِرِن نَمِنِ كُنكُي كُي؛ شْنِيٍ، سُبٍيٍ، بُبُسٍيٍ، عَلَكٌ عٍ شَ يِرِوَ، عٍ شَ وُيَ دُنِحَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","نَ تّمُي نُهَ نَشَ مِنِ قَ، عَ نُن عَ شَ دِيٍ، عَ شَ فِنّ، نُن عَ شَ دِيٍ شَ فِنّيٍ. ");
INSERT INTO susa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","سُبٍيٍ قَن نَشَ مِنِ، عَ نُن بُبُسٍيٍ، نُن شْنِيٍ. نِمَسٍ بْنسْي بِرِن نَشَ مِنِ عٍ شَتِ شَتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","نَ شَنبِ، نُهَ نَشَ سّرّشّبَدٍ يَءِلَن عَلَتَلَ بّ. عَ نَشَ سُبٍ نُن شْنِ رَدَشَشِ ندٍيٍ تٌنفٌ، عَ نٍيٍ بَ سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","نَ تُورِ تٌ تٍ، عَلَتَلَ نَشَ نَ فَن شِرِ مّ. عَ نَشَ رَقَن عَ مَ. عَ نَشَ عَ قَلَ عَ بْحّ مَ، «ﭑ مُ بْشِ دَنكَمَ سْنْن عَدَ مَ شَ قٍ رَ، بَرِ مَ ﭑ نَ كٌلٌن عَدَ مَ بْحّ مُ قَن كَقِ عَ دِ مّدِ تّمُي. ﭑ مُ نِمَسٍ بِرِن سْنتْمَ سْنْن عَلْ ﭑ نَ سِنفٍ رَبَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","سَنسِ سِ تّمُي نُن سَنسِ شَبَ تّمُي، شِنبٍلِ نُن كُيٍقُرٍ، سٌفٌقُرٍ نُن حّمّ، يَنيِ نُن كْي، ﭑ مُ نَ بَمَ سْنْن هَن دُنِحَ حْن.» ");
INSERT INTO susa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","نَ دَنفِ شَنبِ عَلَ نَشَ بَرَكّ سَ نُهَ نُن عَ شَ دِيٍ شَ قٍ. عَ نَشَ عَ مَسٍن عٍ بّ، «وٌ شَ وُيَ، وٌ شَ يِرِوَ، وٌ شَ فبٌ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","سُبٍ نَشٍيٍ نَ دُنِحَ مَ نُن شْنِ نَشٍيٍ نَ كٌورٍ مَ، عٍ فَاشُمَ نّ وٌ يَ رَ. بُبُسٍ نَشٍيٍ نَ بْشِ مَ نُن يّشّ نَشٍيٍ نَ بَا مَ، عٍ عٍ فِمَ نّ وٌ يَ رَ. ﭑ بَرَ عٍ بِرِن سَ وٌ سَفٌ، ");
INSERT INTO susa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ﭑ بَرَ عٍ بِرِن قِندِ بَلٌي رَ وٌ بّ عَلْ سَنسِيٍ ﭑ نَشَن سِنفٍ قِ وٌ مَ دٌنسٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","«كْنْ وٌ نَشَ سُبٍ دٌن، نَشَن وُلِ مُ بَشِ، بَرِ مَ عَ وُلِ قِندِشِ سُبٍ نِي نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","سُبٍ يٌ نَشَن وٌ نِي بَمَ، شَ نَ مُ عَ رَ مِشِ يٌ نَشَن عَ بٌورٍ عَدَ مَدِ نِي بَمَ، نَ كَنيِ نَن فبٍ نَ نَ نِي كٌتٍ سَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","مِشِ نَشَن عَدَ مَدِ نِي بَمَ، مِشِ نَن نَ كَنيِ قَن نِي بَمَ، بَرِ مَ عَلَ قْشِ بَرَ لُ عَدَ مَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","وٌ شَ وُيَ، وٌ شَ يِرِوَ، وٌ شَ فبٌ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","نَ شَنبِ عَلَ نَشَ عَ مَسٍن نُهَ نُن عَ شَ دِيٍ بّ، ");
INSERT INTO susa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«ﭑ بَرَ سَاتّ تٌنفٌ وٌ نُن وٌ شَ دِيٍ بّ، ");
INSERT INTO susa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","عَ نُن نِمَسٍ نَشَن بِرِن نُ نَ كُنكُي كُي؛ شْنِيٍ، شُرُ سٍيٍ، بُورُنيِ سُبٍيٍ، نِمَسٍ نَشَن بِرِن نَ دُنِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ﭑ بَرَ سَاتّ تٌنفٌ وٌ بّ، بَنبَرَنيِ تَن مُ نِي بِرِن بَمَ سْنْن، عَ مُ دُنِحَ بِرِن كَنَمَ قَ.» ");
INSERT INTO susa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","عَلَ نَشَ عَ مَسٍن، «ﭑ بَرَ سَاتّ تٌنفٌ وٌ نُن نِمَسٍ بِرِن بّ، سَاتّ نَشَن مُ كَنَمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","سَاتّ تْنشُمَ نَن يَ، ﭑ سٍنكُي مَسٍنمَ نّ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","شَ ﭑ بَرَ كُندَ سَ كٌورٍ مَ، نَ سٍنكُي مِنِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","نَ تّمُي ﭑ نَتُمَ نّ سَاتّ شَ قٍ مَ، ﭑ سَاتّ نَشَن تٌنفٌشِ وٌ نُن نِمَسٍ بِرِن بّ. ﭑ مُ نِي بِرِن بَمَ دُنِحَ مَ بَنبَرَنيِ رَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","سٍنكُي نَ مِنِ كٌورٍ مَ، ﭑ نَ تٌمَ، ﭑ نَتُمَ سَاتّ شَ قٍ مَ، سَاتّ نَشَن مُ كَنَمَ عَبَدَن، ﭑ سَاتّ نَشَن تٌنفٌشِ وٌ نُن نِمَسٍ بِرِن بّ نَشٍيٍ نَ دُنِحَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","عَلَ نَشَ عَ مَسٍن نُهَ بّ، «سَاتّ تْنشُمَ نَن يَ، ﭑ نَ سَاتّ نَشَن تٌنفٌشِ نِمَسٍ بِرِن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","نُهَ شَ دِ نَشٍيٍ كٍلِشِ كُنكُي كُي، عٍ شِلِ سٍمِ، هَمِ، يٍقٍتِ. هَمِ قِندِشِ كَنَانكَيٍ بَبَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","دُنِحَ مِشِ بِرِن قَتَنشِ نُهَ شَ دِ سَشَنيِيٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نُهَ تٌ شّ رَوَلِ قْلْ، عَ نَشَ وّنِ سَنسِ سِ. ");
INSERT INTO susa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","نَ سَنسِ تٌ بٌفِ، نُهَ نَشَ وّنِ يَءِلَن. عَ تٌ سِيسِ نَ رَ، عَ نَشَ عَ سَ كِرِ بَنشِ كُي عَ مَفٍلِ. ");
INSERT INTO susa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","كَنَانكَيٍ بٍنبَ هَمِ تٌ عَ بَبَ مَفٍلِ تٌ، عَ نَشَ نَ قَلَ عَ تَارَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","نَ كُي سٍمِ نُن يٍقٍتِ نَشَ دُفِ تٌنفٌ قَ، عٍ سٌ عٍ بَبَ شُن عٍ شَنبِ شَنبِ مَ. عٍ نَشَ دُفِ قٍلٍن عٍ بَبَ مَ، عٍ مُ عٍ يَ تِ عٍ بَبَ مَفٍلِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","نُهَ شُن تٌ مَبْو عَ رَ، عَ نَشَ كٍلِ، عَ نَشَ عَ كٌلٌن قَ عَ شَ دِ دْنشْي نَشَن نَبَشِ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","نُهَ نَشَ عَ قَلَ، «ﭑ بَرَ كَنَان دَنكَ. عَ شَ قِندِ كٌنيِ بِرِن دْنشْي رَ عَ تَارَيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","عَ مَن نَشَ عَ قَلَ، «ﭑ بَرَ سٍمِ مَرِفِ عَلَتَلَ مَتْشْ. كَنَان شَ قِندِ سٍمِ شَ كٌنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","عَلَ شَ يٍقٍتِ شَ بْشِ فبٌ، عَ شَ لُ سٍمِ شَ نِينِ بُن مَ، كَنَان شَ قِندِ عَ شَ كٌنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","بَنبَرَنيِ دَنفِ شَنبِ، نُهَ نَشَ بُ دُنِحَ مَ حّ كّمّ سَشَن حّ تٌنفٌ سُولِ. ");
INSERT INTO susa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","نُهَ شَ سِمَيَ تٌ حّ كّمّ سٌلٌمَنَانِ حّ تٌنفٌ سُولِ لِ، عَ نَشَ لَاشِرَ. ");
INSERT INTO susa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","نُهَ شَ دِيٍ، سٍمِ، هَمِ، نُن يٍقٍتِ شَ تَرُشُي نَن يَ، عَ نُن عٍ قَن شَ دِيٍ عٍ نَشٍيٍ سْتْ بَنبَرَنيِ دَنفِ شَنبِ. ");
INSERT INTO susa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","يٍقٍتِ شَ دِيٍ شِلِيٍ نَن يَ؛ فٌمٍرِ، مَفٌفٌ، مَدَيِ، يَوَنِ، تُبَلِ، مٍسٍكِ، تِرَ سِ. ");
INSERT INTO susa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","فٌمٍرِ شَ دِيٍ شِلِيٍ نَن يَ؛ عَسِكٍنَسِ، رِقَتِ، تٌفَرَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","يَوَنِ شَ دِيٍ شِلِيٍ نَن يَ؛ عٍلِسَهَ، تَرَ سِسِ، كِتِمِ، رٌدَنِمِ. ");
INSERT INTO susa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","يٍقٍتِ شَ مِشِيٍ نَشَ سَبَتِ بَا دّ رَ عٍ شَبِلّ كِ مَ، كَنكَن نُن عَ فبٍ شُي. عٍ نَشَ قِندِ سِ دْشْ وُيَشِ رَ عٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","هَمِ شَ دِيٍ شِلِيٍ نَن يَ؛ كُسِ، مِسِرَ، ثُتِ، كَنَان. ");
INSERT INTO susa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","كُسِ شَ دِيٍ شِلِيٍ نَن يَ؛ سٍبَ، هَوِلَ، سَبَتَ، رَامَ، سَبِتٍكَ. رَامَ شَ دِيٍ شِلِيٍ نَن يَ؛ سٍيبَ، دٍدَن. ");
INSERT INTO susa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","نِمِرٌدِ فٍرٍ سٌي بٍلٍبٍلٍ نَن نُ عَ رَ. عَ بَبَ شِلِ كُسِ. ");
INSERT INTO susa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","نِمِرٌدِ مَن قِندِ كٌيِنمَ بٍلٍبٍلٍ رَ عَلَتَلَ يَ عِ. مِشِيٍ نُ عَ قَلَمَ، «كٌيِنمَ بٍلٍبٍلٍ نَن نِمِرٌدِ رَ عَلَتَلَ يَ عِ.» ");
INSERT INTO susa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","عَ شَ مَنفّيَ تَا سِنفٍيٍ قِندِ بَبِلْن، عٍرٍكِ، عَكَدِ، نُن كَلٍنٍ نَن نَ، نَشٍيٍ نُ نَ سِنَرِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","عَ نَشَ كٍلِ سِنَرِ، عَ سِفَ عَسِرِيَ بْشِ مَ. مّننِ عَ نَشَ تَايٍ تِ نَشٍيٍ شِلِ نِنٍوٍ، رٍهٌبٌتِ، عِرِ، كَلَ، ");
INSERT INTO susa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","نُن رٍ سٍن، تَا بٍلٍبٍلٍ نَشَن نَ نِنٍوٍ نُن كَلَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","مِسِرَ نَشَ قِندِ لُدُكَيٍ، عَنَمِكَيٍ، لٍهَبَكَيٍ، نَقَتُ، ");
INSERT INTO susa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ثَتِرُ سُكَيٍ، كَسَلُشُكَيٍ، (قِلِسِتَكَيٍ كٍلِ دّننَشّ)، عَ نُن كَقَتٌرٌكَيٍ بٍنبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","كَنَان نَشَ قِندِ يِ مِشِيٍ بَبَ رَ؛ سِدْنكَيٍ، عَ شَ دِ سِنفٍ، شِتِكَيٍ، ");
INSERT INTO susa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","يٍبُسُكَيٍ، عَمٌرِكَيٍ، فِرِفَسَكَيٍ، ");
INSERT INTO susa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","هِوِكَيٍ، عَرَكِكَيٍ، سِنِكَيٍ، ");
INSERT INTO susa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","عَرَوَدَكَيٍ، سٍمَرَكَيٍ، نُن شَمَتَكَيٍ. بْنسْي نَشَن بِرِن كٍلِ كَنَان، عٍ نَشَ يٍنسٍن يّ. ");
INSERT INTO susa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","كَنَان شَ نَانِنيِ نَشَ كٍلِ سِدْن سِفَقٍ فٍرَرَ، عَ نَشَ سِفَ هَن فَسَ، عَ دَنفِ سٌدٌ مَ، فٌمٌرَ، عَدَ مَهَ، نُن سٍبٌيِمِ رَ، عَ سِفَ هَن لَسَ. ");
INSERT INTO susa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","هَمِ شَ مِشِيٍ نَن يَ عٍ شَبِلّ كِ مَ، كَنكَن نُن عَ فبٍ شُي. عٍ نَشَ قِندِ سِ دْشْ وُيَشِ رَ عٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","يٍقٍتِ شُنيَ سٍمِ قَن نَشَ دِيٍ سْتْ. عٍبٍرِ شَ دِيٍ بٍنبَ نَن نَ سٍمِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","سٍمِ شَ دِيٍ شِلِيٍ نَن يَ؛ عٍلَمَ، عَسُرِ، عَرَقَشَدِ، لُدُ، نُن عَرَ مِ. ");
INSERT INTO susa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","عَرَ مِ شَ دِيٍ شِلِيٍ نَن يَ؛ عُسِ، شُلُ، فٍتٍرِ، نُن مٍسٍكِ. ");
INSERT INTO susa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","عَرَقَشَدِ نَشَ قِندِ سٍلَهَ بَبَ رَ. سٍلَهَ نَشَ قِندِ عٍبٍرِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","عٍبٍرِ نَشَ دِ قِرِن سْتْ. كٍرٍن شِلِ ثٍلٍفِ. نَ نَن قَلَشِ «مَءِتَشُنيِ،» بَرِ مَ عَلَ دُنِحَ مِشِيٍ عِتَشُن نَ وَشَتِ نّ. عَ شُنيَ شِلِ يٌكَتَن. ");
INSERT INTO susa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","يٌكَتَن شَ دِيٍ شِلِيٍ نَن يَ؛ عَلٌمٌدَدِ، سٍلٍقَ، هَسَرَ مَوٍتٍ، يٍرَ، ");
INSERT INTO susa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","هَدٌرَ مِ، عُسَلِ، دِكِلَ، ");
INSERT INTO susa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عٌبَلَ، عَبِمَيٍلٍ، سٍيبَ، ");
INSERT INTO susa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","عٌقِرِ، هَوِلَ، نُن يٌبَبٌ. يٌكَتَن نَشَ نَ دِيٍ بِرِن سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","عٍ شَ بْشِ كٍلِمَ مٍسَ، عَ سِفَ هَن سٍقَرٍ، نَشَن نَ فٍيَ سٌفٍتٍدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","سٍمِ شَ دِيٍ نَن يَ عَ شَبِلّ كِ مَ، كَنكَن نُن عَ فبٍ شُي. عٍ نَشَ قِندِ سِ دْشْ وُيَشِ رَ عٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","نُهَ شَ دِيٍ بْنسْييٍ شَ تَرُشُي نَن نَ كِ. بَنبَرَنيِ دَنفِ شَنبِ، يِ بْنسْي نَن قِندِ دُنِحَ سِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","نَ تّمُي دُنِحَ مِشِ بِرِن نُ شُي كٍرٍن نَن قَلَمَ. ");
INSERT INTO susa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","مِشِ ندٍيٍ نَشَ كٍلِ، عٍ سِفَ سٌفٍتٍدٍ مَبِرِ، عٍ فٍيَ تٌ سِنَرِ بْشِ مَ. عٍ نَشَ سَبَتِ كّنّ مَ نَشَن نَ فُلُنبَ كُي. ");
INSERT INTO susa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","عٍ نَشَ عَ قَلَ عٍ بٌورٍ بّ، «وٌ قَ، وٌن شَ بِرِكِ بْنبْ، وٌن شَ عٍ فَن.» عٍ نَشَ بِرِكِ قِندِ فّمّ حْشْي رَ. عٍ نَشَ مْتَ قِندِ دٌلٍ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","نَ شَنبِ عٍ نَشَ عَ قَلَ، «وٌن وَلِ سُشُ، وٌن شَ تَا تِ وٌن يّتّ بّ، عَ نُن بَنشِ بٍلٍبٍلٍ نَشَن تٍمَ هَن كٌورٍ مَ، عَلَكٌ وٌن شِلِ شَ فبٌ. نَ نَ عَ رَ، وٌن مُ لْيمَ وٌن بٌورٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","كْنْ عَلَتَلَ نَشَ فٌرٌ نَ تَا مَتٌدٍ، عَ نُن نَ بَنشِ بٍلٍبٍلٍ. ");
INSERT INTO susa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","عَلَتَلَ نَشَ عَ مَسٍن، «شَ يِ مِشِيٍ بَرَ كَقُ عٍ بٌورٍ مَ يِ وَلِ رَبَدٍ، عٍ نَ شُي كٍرٍن قَلَ، وَلِ بِرِن عٍ وَ مَ نَشَن نَبَقٍ، عَ سْونّيَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","وٌن شّي، وٌن شَ فٌرٌ عٍ شَ شُي مَسُنبُدٍ عَلَكٌ عٍ نَشَ عٍ بٌورٍ وْيّن شُي قَهَامُ.» ");
INSERT INTO susa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","نَ كُي عَلَتَلَ نَشَ نَ فَلِ رَيٍنسٍن يّ. نَ بَنشِ تِقٍ نَشَ دَن. ");
INSERT INTO susa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","نَ يِرٍ شِلِ نَشَ سَ بَبٍلِ، بَرِ مَ عَلَتَلَ دُنِحَ مِشِيٍ شُييٍ رَوُيَ مّننِ نّ، عَ قَ عٍ رَيٍنسٍن يّ دُنِحَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","سٍمِ شَ تَرُشُي نَن يَ. بَنبَرَنيِ دَنفِ شَنبِ حّ قِرِن، سٍمِ شَ سِمَيَ نَشَ حّ كّمّ لِ. عَ نَشَ قِندِ عَرَقَشَدِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","عَ تٌ عَرَقَشَدِ سْتْ، سٍمِ نَشَ حّ كّمّ سُولِ سَ عَ قَرِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","عَرَقَشَدِ تٌ حّ تٌنفٌ سَشَن عَ نُن سُولِ سْتْ، عَ نَشَ قِندِ سٍلَهَ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","عَ تٌ سٍلَهَ سْتْ، عَرَقَشَدِ نَشَ بُ حّ كّمّ نَانِ نُن حّ سَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","سٍلَهَ تٌ حّ تٌنفٌ سَشَن سْتْ، عَ نَشَ قِندِ عٍبٍرِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","عَ تٌ عٍبٍرِ سْتْ، سٍلَهَ نَشَ بُ حّ كّمّ نَانِ نُن حّ سَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","عٍبٍرِ تٌ حّ تٌنفٌ سَشَن نُن نَانِ سْتْ، عَ نَشَ قِندِ ثٍلٍفِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","عَ تٌ ثٍلٍفِ سْتْ، عٍبٍرِ نَشَ بُ حّ كّمّ نَانِ نُن حّ تٌنفٌ سَشَن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ثٍلٍفِ تٌ حّ تٌنفٌ سَشَن سْتْ، عَ نَشَ قِندِ رُيٍ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","عَ تٌ رُيٍ سْتْ، ثٍلٍفِ نَشَ بُ حّ كّمّ قِرِن نُن حّ سٌلٌمَنَانِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","رُيٍ تٌ حّ تٌنفٌ سَشَن عَ نُن قِرِن سْتْ، عَ نَشَ قِندِ سٍرُفُ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","عَ تٌ سٍرُفُ سْتْ، رُيٍ نَشَ بُ حّ كّمّ قِرِن نُن حّ سٌلٌقٍرٍ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","سٍرُفُ تٌ حّ تٌنفٌ سَشَن سْتْ، عَ نَشَ قِندِ نَشٌرِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","عَ تٌ نَشٌرِ سْتْ، سٍرُفُ نَشَ بُ حّ كّمّ قِرِن. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","نَشٌرِ تٌ حّ مْشْحّن نُن سٌلٌمَنَانِ سْتْ، عَ نَشَ قِندِ تٍرَ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","عَ تٌ تٍرَ سْتْ، نَشٌرِ نَشَ بُ حّ كّمّ نُن حّ قُ نُن سٌلٌمَنَانِ. عَ نَشَ دِ شّمّ نُن دِ فِنّ فبّتّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","تٍرَ تٌ حّ تٌنفٌ سٌلٌقٍرٍ سْتْ، عَ نَشَ قِندِ عِبُرَ مَ، نَشٌرِ، نُن شَرَنِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","تٍرَ شَ تَرُشُي نَن يَ. تٍرَ نَشَ قِندِ عِبُرَ مَ، نَشٌرِ، نُن شَرَنِ بَبَ رَ. شَرَنِ نَشَ قِندِ لٌتِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","شَرَنِ سِنفٍ نَشَ قَشَ عَ بَبَ تٍرَ بّ عُرُ، كَلِدِ بْشِ مَ، عَ بَرِشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","عِبُرَ مَ نُن نَشٌرِ نَشَ فِنّيٍ قٍن، عٍ نَشَ قُتِ شِرِ. عِبُرَ مَ شَ فِنّ شِلِ سَرَيِ. نَشٌرِ شَ فِنّ شِلِ مِلِكَ. مِلِكَ شَرَنِ شَ دِ نَ عَ رَ. دِ قِرِن نُ نَ شَرَنِ يِ رَ، مِلِكَ نُن عِسِكَ. ");
INSERT INTO susa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","سَرَيِ دِبَرِتَرٍ نَن نُ عَ رَ. دِ يٌ مُ نُ نَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","تٍرَ نَشَ عَ شَ دِ عِبُرَ مَ، عَ شَ مَمَدِ لٌتِ، نَشَن قِندِشِ شَرَنِ شَ دِ رَ، نُن عِبُرَ مَ شَ فِنّ سَرَيِ تٌنفٌ، عٍ نَشَ كٍلِ عُرُ كَلِدِ بْشِ مَ سِفَقٍ رَ كَنَان بْشِ مَ. كْنْ عٍ تٌ شَرَنِ لِ، عٍ نَشَ سَبَتِ مّننِ. ");
INSERT INTO susa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","تٍرَ شَ سِمَيَ تٌ حّ كّمّ قِرِن حّ سُولِ لِ، عَ نَشَ لَاشِرَ شَرَنِ. ");
INSERT INTO susa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","عَلَتَلَ نَشَ عَ مَسٍن عِبُرَ مَ بّ، «عِ شَ بْشِ بّحِن، عِ شَ مِشِيٍ بّحِن، عِ شَبِلّ بّحِن. عِ شَ سِفَ بْشِ مَ ﭑ دّننَشّ مَسٍنمَ عِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ﭑ عِ قِندِ مَ نّ سِ بٍلٍبٍلٍ رَ. ﭑ بَرَكّ سَمَ نّ عِ شَ قٍ. ﭑ عِ شِلِ فبٌمَ نّ. مِشِيٍ قَن بَرَكّ سْتْمَ عِ تَن نَن سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","مِشِ نَشَن دُبَمَ عِ بّ، ﭑ قَن بَرَكّ سَمَ نّ نَ كَنيِ مَ. مِشِ نَشَن عِ دَنكَمَ، ﭑ قَن نَ كَنيِ دَنكَمَ نّ. دُنِحَ بِرِن بَرَكّ سْتْمَ عِ تَن نَن سَابُي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","نَ تّمُي عِبُرَ مَ نَشَ كٍلِ شَرَنِ عَلْ عَلَتَلَ عَ مَسٍنشِ عَ بّ كِ نَشّ. لٌتِ قَن نَشَ بِرَ عَ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","عِبُرَ مَ تٌ كٍلِ شَرَنِ، عَ شَ سِمَيَ نُ بَرَ حّ تٌنفٌ سٌلٌقٍرٍ نُن سُولِ لِ. عَ نَشَ عَ شَ فِنّ سَرَيِ، عَ شُنيَ شَ دِ لٌتِ، عَ هَرِفٍ بِرِن، نُن مِشِيٍ عَ نَشٍيٍ سْتْ شَرَنِ، عَ نَشَ عٍ بِرِن شَنِن كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","عِبُرَ مَ نَشَ حّرّ هَن عَ نَشَ وُرِ بِلِ بٍلٍبٍلٍ ندٍ لِ دّننَشّ شِلِ مٌرٍ، سِكٍمِ مَبِرِ. كَنَانكَيٍ نُ سَبَتِشِ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","عَلَتَلَ نَشَ عَ يّتّ مَسٍن عِبُرَ مَ بّ. عَ نَشَ عَ قَلَ، «ﭑ يِ بْشِ نَن قِمَ عِ بْنسْي مَ.» نَ كُي عِبُرَ مَ نَشَ سّرّشّبَدٍ يَءِلَن عَلَتَلَ بّ نَشَن مِنِشِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","عَ نَشَ سِفَ فٍيَ مَ بٍتٍلِ قُفٍ رَ. عَ نَشَ كِرِ بَنشِ تِ مّننِ، بٍتٍلِ نَ عَ سٌفٍفٌرٌدٍ، عَيِ نَ عَ سٌفٍتٍدٍ. عَ نَشَ سّرّشّبَدٍ يَءِلَن عَلَتَلَ بّ، عَ قَ عَ مَشَندِ عَ شِلِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","نَ شَنبِ عَ نَشَ سِفَ نٍفٍوِ فبٍنفبٍرٍن يِرٍ بِرِ. ");
INSERT INTO susa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","نَ تّمُي، كَامّ نُ بَرَ دِن كَنَان بْشِ رَ. عِبُرَ مَ نَشَ سِفَ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","بٍينُ عٍ شَ سٌ مِسِرَ بْشِ مَ، عِبُرَ مَ نَشَ عَ قَلَ عَ شَ فِنّ سَرَيِ بّ، «ﭑ عَ كٌلٌن، فِنّ تٌقَنيِ نَن عِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","مِسِرَكَيٍ نَ عِ تٌ يَ، عٍ عَ قَلَمَ نّ ﭑ مَ فِنّ نَن عِ رَ. نَ شَنبِ، عٍ ﭑ قَشَمَ نّ، عَلَكٌ عٍ شَ عِ تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","عِ شَ عَ قَلَ عٍ بّ ﭑ شُنيَ نَن لَنشِ عِ مَ، عَلَكٌ عٍ شَ مّينِ ﭑ مَ عِ شَ قٍ رَ. نَ كُي، ﭑ مُ قَشَمَ عِ تَن سَابُي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","عِبُرَ مَ تٌ مِسِرَ لِ، مِسِرَكَيٍ نَشَ عَ تٌ، سَرَيِ فِنّ تٌقَنيِ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","مِسِرَ مَنفّ شَ سَنسَلَيٍ تٌ سَرَيِ مَتْشْ عَ بّ، عَ نَشَ عَ شَنِن عَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","مَنفّ نَشَ مّينِ عِبُرَ مَ مَ سَرَيِ سَابُي رَ. عَ نَشَ شُرُ سٍ لَنمَيٍ، شُرُ سٍ شُنفبٍيٍ، سٌقَلٍيٍ، كٌنيِيٍ، نُن حْشْمّيٍ قِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","كْنْ عَلَتَلَ نَشَ قُرٍ حَاشِ سَ مِسِرَ مَنفّ نُن عَ شَ دٍنبَيَ مَ، عِبُرَ مَ شَ فِنّ سَرَيِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","مِسِرَ مَنفّ نَشَ عِبُرَ مَ شِلِ. عَ نَشَ عَ قَلَ عَ بّ، «عِ مُنسٍ رَبَشِ ﭑ نَ؟ مُنقٍ رَ عِ مُ عَ قَلَ ﭑ بّ عِ شَ فِنّ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","مُنقٍ رَ عِ عَ قَلَشِ عِ شُنيَ نَ عَ رَ، هَن ﭑ تَن بَرَ عَ قِندِ ﭑ مَ فِنّ رَ؟ عَوَ، ﭑ كٌ، عِ شَ فِنّ نَن يَ. وٌ سِفَ!» ");
INSERT INTO susa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","نَ شَنبِ، مِسِرَ مَنفّ نَشَ عِبُرَ مَ شَ قٍ قَلَ عَ شَ كٌرٌفبَيٍ بّ. عٍ نَشَ عَ رَفبّنفبّن، عَ تَن، عَ شَ فِنّ، نُن عَ هَرِفٍ بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","نَ تّمُي عِبُرَ مَ نَشَ كٍلِ مِسِرَ، عَ سِفَ نٍفٍوِ فبٍنفبٍرٍن يِرٍ مَبِرِ. عَ نَشَ عَ شَ فِنّ نُن عَ هَرِفٍ بِرِن شَنِن عَ شُن مَ. عَ شُنيَ شَ دِ لٌتِ قَن نَشَ عَ مَتِ نَا. ");
INSERT INTO susa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","عِبُرَ مَ نُ بَرَ قِندِ بَننَ رَ. شُرُ سٍيٍ، فبٍتِ، نُن شّيمَ نُ نَ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","عَ نَشَ كٍلِ نٍفٍوِ، عَ نُ عَ شَ حّرّ تَفِ عِسُشُ، سِفَقٍ رَ ");
INSERT INTO susa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","يِرٍ ندٍ بٍتٍلِ نُن عَيِ تَفِ، عَ نُ بَرَ سّرّشّبَدٍ تِ دّننَشّ. مّننِ عِبُرَ مَ نَشَ عَلَتَلَ مَشَندِ عَ شِلِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","لٌتِ، نَشَن نُ نَ عِبُرَ مَ قْشْ رَ، عَ قَن قِندِشِ شُرُ سٍيٍ نُن كِرِ بَنشِيٍ كَنيِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","عِبُرَ مَ شَ شُرُ سٍ فْورّ نُن لٌتِ شَ شُرُ سٍ فْورّ نُ فبٌ نَ بْشِ بّ. عٍ مُ نُ نْمَ لُدٍ يِرٍ كٍرٍن سْنْن. ");
INSERT INTO susa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","سْنشْي نَشَ مِنِ عِبُرَ مَ شَ شُرُ سٍ دّ مَدٌنيِيٍ عَ نُن لٌتِ شَ شُرُ سٍ دّ مَدٌنيِيٍ تَفِ. كَنَانكَيٍ نُن ثٍرِ سِكَيٍ قَن نُ نَ مّننِ نَ وَشَتِ. ");
INSERT INTO susa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","عِبُرَ مَ نَشَ عَ قَلَ لٌتِ بّ، «وٌن نَشَ كْنحّ، وٌن مَ شُرُ سٍ دّ مَدٌنيِيٍ قَن مُ لَن عٍ شَ كْنحّ، بَرِ مَ وٌن تَن نفَشَكٍرٍنمَ نَن وٌن نَ. ");
INSERT INTO susa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","يِ بْشِ بِرِن نَن عِ يَ عِ يِ كِ. وٌن نَشَن نَبَمَ، وٌن شَ قَتَن. شَ عِ سِفَ كْولَ مَ، ﭑ تَن سِفَمَ يِرٍقَنيِ نَن مَ. شَ عِ سِفَ يِرٍقَنيِ مَ، ﭑ تَن سِفَ كْولَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","لٌتِ نَشَ عَ يَ رَ سِفَ، عَ نَشَ سَ يُرُدّن مّرّ تٌ. يٍ نُ نَ نَ عَ قَنيِ رَ. بٍينُ عَلَتَلَ شَ سٌدٌ مَ نُن فٌمٌرَ كَنَ، نَ بْشِيٍ نُ قَن هَن سٌوَرِ بِرِ. نَ نُ لُشِ عَلْ مِسِرَ بْشِ، عَلْ عَلَتَلَ شَ يِرٍ يَءِلَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","نَ كُي لٌتِ نَشَ يُرُدّن مّرّ سُفَندِ عَ يّتّ بّ. عَ نَشَ سِفَ سٌفٍتٍدٍ مَبِرِ. عِبُرَ مَ نُن لٌتِ قَتَن نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","عِبُرَ مَ نَشَ لُ كَنَان بْشِ مَ، لٌتِ نَشَ لُ يُرُدّن مّرّ تَايٍ تَفِ. لٌتِ نَشَ عَ شَ كِرِ بَنشِيٍ تِ سٌدٌ مَ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","سٌدٌ مَكَيٍ نُ بَرَ كٌبِ عَ فبٍ رَ، عٍ نُ بَرَ قِندِ يُنُبِتْي بٍلٍبٍلٍ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","عِبُرَ مَ نُن لٌتِ تٌ قَتَن، عَلَتَلَ نَشَ عَ مَسٍن عِبُرَ مَ بّ، «عِ يَ تِ سٌفٍتٍدٍ رَ، سٌفٍفٌرٌدٍ، يِرٍقَنيِ، نُن كْولَ. ");
INSERT INTO susa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","عِ بْشِ نَشَن بِرِن تٌشِ، ﭑ عَ قِمَ عِ تَن نُن عِ بْنسْي مَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ﭑ عِ بْنسْي رَوُيَمَ نّ عَلْ شُبٍ نَشَن نَ بْشِ مَ. شَ مِشِ ندٍ نْمَ شُبٍ كْنتِدٍ، عَ نْمَ نّ عِ بْنسْي كْنتِ قَن كٌلٌندٍ. ");
INSERT INTO susa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","كٍلِ، عِ بْشِ عِحّرّ، عَ كُيّيَ نُن عَ فبٌيَ، عِ شَ عَ بِرِن مَتٌ بَرِ مَ ﭑ عَ قِمَ عِ تَن نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","نَ تّمُي عِبُرَ مَ نَشَ كِرِ بَنشِ يِرٍ مَسَرَ. عَ نَشَ سَبَتِ وُرِ بٍلٍبٍلٍ ندٍيٍ مَبِرِ نَشَن نَ مَمِرٍ نُن هٍبِرٌن قّ مَ. عَ نَشَ سّرّشّبَدٍ يَءِلَن نَا عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","نَ وَشَتِ بَبِلْن بْشِ مَنفّ عَمَرَقٍلِ، عٍلَسَرِ بْشِ مَنفّ عَرِيٌكِ، عٍلَمَ بْشِ مَنفّ كٍدٌرٌلَمٍرِ، نُن فٌيِن بْشِ مَنفّ تِدَلِ، يِ مَنفّ نَانِ نَشَ سَاتّ تٌنفٌ عٍ بٌورٍ بّ مَنفّ سُولِ ندٍيٍ فٍرٍقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","نَ مَنفّ سُولِ نَن يَ؛ سٌدٌ مَ مَنفّ بٍرَ، فٌمٌرَ مَنفّ بِرِ سَ، عَدَ مَهَ مَنفّ سِنَبُ، سٍبٌيِمِ مَنفّ سٍمٍبٍرِ، نُن بٍلَ مَنفّ سٌوَرِ. ");
INSERT INTO susa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","يِ مَنفّ سُولِ نَشَ عٍ مَلَن فُلُنبَ ندٍ كُي نَشَن شِلِ سِدِ مِ، قْشْي بَا نَ دّننَشّ تٌ. ");
INSERT INTO susa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","كَبِ حّ قُ نُن قِرِن يِ مَنفّ سُولِ نُ نَ مَنفّ كٍدٌرٌلَمٍرِ شَ نْي بُن مَ، كْنْ حّ قُ نُن سَشَن ندٍ عٍ نَشَ مُرُتَ عَ شَ مَنفّيَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","عَ حّ قُ نُن نَانِ ندٍ، مَنفّ كٍدٌرٌلَمٍرِ نُن مَنفّ نَشٍيٍ نُ نَ عَ سّيتِ مَ، عٍ نَشَ سِفَ فٍرٍ سٌدٍ. عٍ نَشَ نْ عَ بِرِن نَ؛ رٍقَكَ نَشٍيٍ نُ نَ عَسِتٍرٌتِ كَرَنَيِمِ، سُسِكَ نَشٍيٍ نُ نَ هَمِ، عٍمِكَ نَشٍيٍ نُ نَ سَوٍ كِرِيَتَيِمِ، ");
INSERT INTO susa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","عَ نُن شٌرِكَ نَشٍيٍ نُ نَ فٍيَ مَ سٍيِرِ بِرِ هَن ثَرَن فبٍنفبٍرٍن يِرٍ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","نَ شَنبِ عٍ نَشَ فبِلٍن، عٍ نَشَ سِفَ عٍن مِسَثَتِ، نَشَن شِلِ كَدٍ سِ. عٍ نَشَ نْ عَمَلّكِكَيٍ رَ، عَ نُن عَمٌرِكَ نَشٍيٍ نُ سَبَتِشِ شَسَسٌن تَمَرِ. ");
INSERT INTO susa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","نَ تّمُي، سٌدٌ مَ مَنفّ، فٌمٌرَ مَنفّ، عَدَ مَهَ مَنفّ، سٍبٌيِمِ مَنفّ، عَ نُن بٍلَ مَنفّ (بٍلَ شِلِ سٌوَرِ)، عٍ نَشَ عٍ مَلَن فُلُنبَ كُي نَشَن شِلِ سِدِ مِ يِ مَنفّ سُولِ فٍرٍقٍ مَ؛ ");
INSERT INTO susa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","عٍلَمَ مَنفّ كٍدٌرٌلَمٍرِ، فٌيِن مَنفّ تِدَلِ، بَبِلْن مَنفّ عَمَرَقٍلِ، نُن لَسَ مَنفّ عَرِيٌكِ. نَ مَنفّ نَانِ نَشَ يِ مَنفّ سُولِ فٍرٍ. ");
INSERT INTO susa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","يِلِيٍ نُ نَ سِدِ مِ فُلُنبَ كُي، دٌلٍ نُ نَ عٍ كُي. سٌدٌ مَ مَنفّ نُن فٌمٌرَ مَنفّ تٌ عٍ فِ، عٍ نَشَ قَ بِرَ نَ يِلِيٍ كُي. مِشِ دْنشْييٍ نَشَ عٍ فِ سِفَقٍ رَ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","نَ مَنفّ نَانِ نَشٍيٍ فٍينِ، عٍ نَشَ سٌدٌ مَ نُن فٌمٌرَ هَرِفٍ نُن عٍ شَ بَلٌي بِرِن تٌنفٌ، عٍ سِفَ. ");
INSERT INTO susa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","عٍ نَشَ عِبُرَ مَ شُنيَ شَ دِ لٌتِ قَن سُشُ عَ نُن عَ هَرِفٍ بِرِن، بَرِ مَ عَ نُ سَبَتِشِ سٌدٌ مَ نَن كُي. ");
INSERT INTO susa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","مِشِ ندٍ نَشَ نْ عَ فِدٍ، عَ سَ نَ قٍ بِرِن تَفِ رَبَ عِبُرَ مَ عٍبُرُكَ بّ. نَ وَشَتِ، عِبُرَ مَ نُ سَبَتِشِ مَمِرٍ عَمٌرِكَ شَ وُرِ بِلِ بٍلٍبٍلٍيٍ نَن بُن مَ. مَمِرٍ نُن عَ نفَشَكٍرٍنيِيٍ عٍسٍكٌلِ نُن عَنٍرِ، عٍ نُن عِبُرَ مَ نُ بَرَ سَاتّ تٌنفٌ عٍ بٌورٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","عِبُرَ مَ تٌ عَ مّ عٍ بَرَ عَ شُنيَ شَ دِ شّمّمَ لٌتِ سُشُ، عَ نَشَ سْورِ كّمّ سَشَن سْورِ قُ نُن سٌلٌمَسَشَن تٌنفٌ، نَشٍيٍ نُ بَرِشِ عَ شَ مِشِيٍ يَ مَ. عٍ نَشَ سِفَ نَ مَنفّيٍ قْشْ رَ هَن تَا نَشَن شِلِ دَنَ. ");
INSERT INTO susa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","كْي رَ عِبُرَ مَ نَشَ عَ شَ سْورِيٍ عِتَشُن، عٍ نَشَ نَ مَنفّيٍ تّرّننَ فٍرٍ رَ. عٍ نَشَ نْ نَ مَنفّيٍ مَتُتُندٍ هَن هٌبَ، دَ مَسِ كْولَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","عِبُرَ مَ نَشَ نْ نَ هَرِفٍ بِرِن مَسْتْدٍ. عَ نَشَ فبِلٍن عَ شُنيَ شَ دِ لٌتِ رَ، عَ هَرِفٍ، عَ شَ فِنّ، نُن عَ شَ مِشِ بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","عِبُرَ مَ تٌ فبِلٍن شُن نَكٍلِ كُي كٍلِقٍ مَنفّ كٍدٌرٌلَمٍرِ فٍرٍدٍ نُن مَنفّ نَشٍيٍ نُ نَ عَ سّيتِ مَ، سٌدٌ مَ مَنفّ نَشَ سِفَ عَ رَلَندٍ فُلُنبَ كُي نَشَن شِلِ سَوٍ. مّننِ شِلِ نّ «مَنفّ شَ فُلُنبَ.» ");
INSERT INTO susa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","نَ شَنبِ، سَلَمُ مَنفّ مٍلٍكِسٍدٍكِ نَشَ قَ تَامِ نُن وّنِ رَ عِبُرَ مَ بّ. عَلَ شِلِ شُنفبٍ كَنيِ شَ سّرّشّدُبّ نَن نُ نَ مٍلٍكِسٍدٍكِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","عَ نَشَ دُبَ عِبُرَ مَ بّ عَ قَلَقٍ رَ، «عَلَ شِلِ شُنفبٍ كَنيِ، نَشَن كٌورٍ نُن بْشِ دَاشِ، عَ شَ بَرَكّ سَ عِبُرَ مَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","تَنتُي نَ عَلَ شِلِ شُنفبٍ كَنيِ بّ، نَشَن عِ يَشُييٍ رَيَرَبِشِ عِ بّ.» نَ تّمُي، عِبُرَ مَ نَشَ قَرِلّ قِ مٍلٍكِسٍدٍكِ مَ عَ نَشَن سْتْ نَ فٍرٍ كُي. ");
INSERT INTO susa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","سٌدٌ مَ مَنفّ نَشَ عَ قَلَ عِبُرَ مَ بّ، «ﭑ مَ مِشِيٍ رَفبِلٍن ﭑ مَ، كْنْ نَاقُلِ تَن شَ لُ عِ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","عِبُرَ مَ نَشَ عَ يَابِ، «ﭑ بَرَ ﭑ كَلِ عَلَتَلَ رَ، عَلَ شِلِ شُنفبٍ كَنيِ نَشَن كٌورٍ نُن بْشِ دَاشِ، ");
INSERT INTO susa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ﭑ مُ سٍسٍ تٌنفٌمَ نَشَن قِندِ عِ فبٍ رَ، هَلِ لُوتِ دِ، شَ نَ مُ عَ رَ سَنكِرِ لُوتِ، عَلَكٌ عِ نَشَ قَ عَ قَلَ، ‹ﭑ بَرَ عِبُرَ مَ قِندِ بَننَ رَ.› ");
INSERT INTO susa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ﭑ مُ سٍسٍ تٌنفٌمَ، قٌ ﭑ مَ سْورِيٍ نَشَن دٌنشِ. عِ مَن شَ عَنٍرِ، عٍسٍكٌلِ، نُن مَمِرٍ فبٍ سٌ عٍ يِ رَ، بَرِ مَ عٍ قَن نُ نَ ﭑ سّيتِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","نَ شَنبِ عَلَتَلَ نَشَ مِنِ عِبُرَ مَ مَ، عَ نَشَ عَ مَسٍن عَ بّ، «عِبُرَ مَ عِ نَشَ فَاشُ، ﭑ تَن نَن نَ عِ كَنتَمَ رَ. عِ سَرٍ شُنفبٍ سْتْمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","عِبُرَ مَ نَشَ عَ يَابِ، «مَرِفِ عَلَتَلَ، عِ مُنسٍ حَنِفٍشِ ﭑ بّ عَ قِقٍ رَ ﭑ مَ؟ ﭑ تٌ يِ كِ، دِ يٌ مُ نَ ﭑ بّ. مِشِ مُ نَ ﭑ بّ نَشَن ﭑ كّ تٌنفٌمَ قٌ ﭑ مَ وَلِكّ عٍلِيٍسٍرِ دَ مَسِ. ");
INSERT INTO susa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","عِ مُ دِ يٌ قِشِ ﭑ تَن مَ. نَشَن بَرِشِ ﭑ مَ بَنشِ كُي، نَ نَن قِندِ مَ ﭑ كّ تٌنفٌمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","عَلَتَلَ نَشَ عَ يَابِ، «عَدٍ، نَ مُ قِندِ مَ عِ كّ تٌنفٌمَ رَ دٍ. عِ بَرِ دِ يَتِ نَن قَمَ قِندِدٍ عِ كّ تٌنفٌمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","عَلَتَلَ نَشَ عِبُرَ مَ رَ مِنِ عَ شَ كِرِ بَنشِ بُن مَ، عَ نَشَ عَ مَسٍن عَ بّ، «عِ يَ رَتٍ كٌورٍ مَ. عِ شَ تُنبُييٍ كْنتِ شَ عِ نْمَ عٍ كْنتِ كٌلٌندٍ.» عَ مَن نَشَ عَ مَسٍن عَ بّ، «تُنبُييٍ فبٌشِ كِ نَشّ كٌورٍ مَ، عِ بْنسْي قَن وُيَمَ نَ كِ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","عِبُرَ مَ نَشَ لَ عَلَتَلَ رَ. عَلَتَلَ قَن نَشَ نَ قِندِ تِنشِنيِ رَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","عَلَ نَشَ عَ مَسٍن عَ بّ، «ﭑ تَن نَن نَ عَلَتَلَ رَ، نَشَن عِ رَ مِنِشِ عُرُ تَا كُي بَبِلْن بْشِ مَ. ﭑ بَرَ عِ شَنِن بْشِ مَ، ﭑ دّننَشّ قِشِ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","عِبُرَ مَ نَشَ عَ مَرِفِ عَلَتَلَ مَشْرِن، «ﭑ نَ كٌلٌنمَ دِ، ﭑ قَمَ نَ سْتْدٍ؟» ");
INSERT INTO susa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «قَ نِنفٍ فِنّ، سِ فِنّ، نُن يّشّي كٌنتٌنيِ رَ، نَشٍيٍ بَرَ حّ سَشَن سَشَن سْتْ. عِ مَن شَ قَ فَنبّ نُن كٌلٌكٌندٍ لَنمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","عِبُرَ مَ نَشَ قَ نَ سُبٍيٍ رَ. عَ نَشَ نِنفٍ، سِ فِنّ، نُن يّشّي كٌنتٌنيِ عِشَبَ عَ تَفِ. عَ نَشَ نَ سُبٍ بٌلٌنيِيٍ سَ عٍ بٌورٍ يَ عِ، كْنْ عَ مُ نَ شْنِيٍ تَن عِشَبَ. ");
INSERT INTO susa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","يُبّيٍ نَشَ قَ، عٍ فٌرٌ نَ سُبٍ قَشَشِ يِرٍ، كْنْ عِبُرَ مَ نَشَ عٍ بِرِن كٍرِ نَا. ");
INSERT INTO susa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","سٌفٍ تٌ نُ دُلَقٍ، شِ شْلِ نَشَ دَنفِ عِبُرَ مَ مَ دُنفبّن. دِ مِ نَشَ سِن عَ مَ، فَاشُي شُنفبٍ نَشَ عَ سُشُ. ");
INSERT INTO susa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «عَ كٌلٌن، عِ بْنسْي قَمَ سِفَدٍ بْشِ فبّتّ مَ عٍ شْنيِ مُ دّننَشّ رَ. عٍ قِندِ مَ نّ كٌنيِيٍ رَ نَ بْشِ مَ. عٍ قٍ شْنّ مْولِ بِرِن سْتْمَ نّ مّننِ حّ كّمّ نَانِ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","كْنْ ﭑ قَمَ نّ نَ بْشِكَيٍ مَكِيتِدٍ، عِ بْنسْي قِندِ مَ كٌنيِيٍ رَ دّننَشّ. نَ دَنفِ شَنبِ، عِ بْنسْي كٍلِمَ نّ نَا، عٍ قَ نَاقُلِ شُنفبٍ شَنِن عٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","عِ تَن قَمَ نّ بْحّسَ سْتْدٍ، عِ مَن سِمَيَ شْنكُيٍ سْتْمَ نّ، هَن عِ سَ رَفَتَمَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","عَمٌرِكَيٍ شَ يُنُبِ نَ فبٌ يّ تّمُي نَشّ، عِ بْنسْي تٌلٌنتٌلٌنيِيٍ قَمَ فبِلٍندٍ كٍلِقٍ عٍ شَ كٌنيِيَ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","سٌفٍ تٌ بَرَ دُلَ، كُيٍ بَرَ عِقْورْ، تُورِ نُن تّ نَشَ دَنفِ سُبٍ بٌلٌنيِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","نَ لْشْي، عَلَتَلَ نَشَ يِ سَاتّ تٌنفٌ عِبُرَ مَ بّ، «ﭑ بَرَ يِ بْشِ قِ عِ بْنسْي مَ، كٍلِ مِسِرَ شُرٍ مَ، سَ دْشْ عٍقِرَتِ شُرٍ بٍلٍبٍلٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","سِ دْشْ وُيَشِ نَن نُ نَ نَ بْشِ مَ. نَ سِيٍ نَن يَ؛ كٍنِ، كٍنِسِ، كَدَ مٌن، ");
INSERT INTO susa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","شِتِ، ثٍرِ سِ، رٍقَ، ");
INSERT INTO susa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","عَمٌرِ، كَنَان، فِرِفَسَ، نُن يٍبُسُ. ");
INSERT INTO susa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","سَرَيِ مُ نُ دِ يٌ بَرِ عَ شَ مْرِ عِبُرَ مَ بّ. كٌنيِ فِنّ مِسِرَكَ نُ نَ سَرَيِ يِ رَ، نَشَن شِلِ هَفَرَ. ");
INSERT INTO susa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","سَرَيِ نَشَ عَ قَلَ عِبُرَ مَ بّ، «عِ بَرَ عَ تٌ، عَلَتَلَ مُ دِ بَرِ قٍ رَفِرِشِ ﭑ تَن مَ. كْنْ تّمُندٍ ﭑ نْمَ دِ سْتْدٍ ﭑ مَ كٌنيِ فِنّ سَابُي رَ عِ بّ. وٌ شَ لُ يِرٍ كٍرٍن تٌ كْي رَ.» عِبُرَ مَ نَشَ تِن سَرَيِ شَ وْيّنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","سَرَيِ نَشَ عَ شَ كٌنيِ فِنّ هَفَرَ مِسِرَكَ تٌنفٌ، عَ نَشَ عَ سٌ عَ شَ مْرِ عِبُرَ مَ يِ رَ، عَ شَ قِندِ عَ شَ فِنّ رَ. عِبُرَ مَ نُ بَرَ حّ قُ رَبَ كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","عِبُرَ مَ نُن هَفَرَ نَشَ شِ يِرٍ كٍرٍن، نَ نَن قِندِ هَفَرَ بّ تّيفّ رَ. هَفَرَ تٌ بَرَ عَ كٌلٌن عَ عَ بَرَ تّيفّ، عَ نَشَ يٌ عَ كَنيِ مَ، عَ نَشَ عَ مَتٌ مَتٌ كِ كٌبِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","سَرَيِ نَشَ عَ قَلَ عِبُرَ مَ بّ، «عِ تَن نَن عَ نِيَشِ يِ بْتّ رَبَ شَ عِلَن ﭑ نَ! ﭑ تَن نَن ﭑ مَ كٌنيِ فِنّ قِشِ عِ مَ عَ شَ قِندِ عِ شَ فِنّ رَ. كَبِ عَ نَشَ عَ كٌلٌن عَ قُرُشِ، عَ قَ قٍ كٌبِ نَن تُن عِلَنمَ ﭑ نَ. عَلَتَلَ شَ وٌن تَن قِرِنيِ مَكِيتِ.» ");
INSERT INTO susa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","عِبُرَ مَ نَشَ عَ شَ فِنّ يَابِ، «عِ شَ كٌنيِ فِنّ نَ عَ رَ. عِ وَ مَ قٍ نَشَن بِرِن شْن مَ، عِ شَ نَ رَبَ عَ رَ.» سَرَيِ نَشَ عَ وَشْنقٍ كٌبِ بِرِن نَبَ هَفَرَ رَ، هَن عَ نَشَ عَ فِ. ");
INSERT INTO susa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","عَلَتَلَ شَ مَلٍكّ نَشَ هَفَرَ لِ دُلٌنيِ ندٍ قّ مَ سُرُ كِرَ شْن مَ فبٍنفبٍرٍن يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","مَلٍكّ نَشَ هَفَرَ مَشْرِن، «سَرَيِ شَ كٌنيِ فِنّ هَفَرَ، عِ كٍلِشِ مِندٍن؟ عِ سِفَقٍ مِندٍن؟» هَفَرَ نَشَ مَلٍكّ يَابِ، «ﭑ نَن ﭑ فِشِ ﭑ كَنيِ نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","عَلَتَلَ شَ مَلٍكّ نَشَ عَ مَسٍن هَفَرَ بّ، «عِ مَن شَ فبِلٍن عِ كٍلِدٍ، عِ سَ عِ مَفٌرٌ عِ كَنيِ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","عَلَتَلَ شَ مَلٍكّ نَشَ عَ قَلَ عَ بّ، «ﭑ قَمَ بْنسْي وُيَشِ قِدٍ عِ مَ، عِ مُ نْمَ نَشَن كْنتِ كٌلٌندٍ.» ");
INSERT INTO susa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","عَلَتَلَ شَ مَلٍكّ مَن نَشَ عَ قَلَ عَ بّ، «عِ تّيفّشِ نّ يِ كِ. عِ قَمَ دِ سْتْدٍ. عِ نَ دِ شِلِ سَمَ نّ سُمَيِلَ، بَرِ مَ عَلَتَلَ بَرَ عِ شُي مّ عِ شَ مَرَيَافِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","عِ شَ دِ قِندِ مَ فٍرٍ سٌي رَ عَلْ وُلَءِ سٌي عَ رَبَمَ كِ نَشّ. عَ مِشِ بِرِن فٍرٍ مَ نّ، بِرِن عَ تَن قَن فٍرٍ مَ نّ. عَ شُنيَيٍ قَن عَ فٍرٍ مَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","هَفَرَ نَشَ شِلِ سَ عَلَتَلَ شُن، نَشَن وْيّن عَ بّ، «عَلَتَلَ نَشَن ﭑ تٌشِ.» عَ نَشَ عَ قَلَ، «ﭑ بَرَ ﭑ تٌمَ تٌ.» ");
INSERT INTO susa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","نَ نَن عَ تٌشِ عٍ نَ كْلْنيِ شِلِ قَلَمَ، «عَلَ حِحّ نَشَن ﭑ تٌشِ.» نَ كْلْنيِ نَ كَدٍ سِ نُن بٍرٍدَ نَن تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","هَفَرَ نَشَ دِ سْتْ عِبُرَ مَ بّ. عِبُرَ مَ نَشَ عَ شِلِ سَ سُمَيِلَ. ");
INSERT INTO susa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","عِبُرَ مَ نُ بَرَ حّ تٌنفٌ سٌلٌمَسَشَن نُن سٍننِ سْتْ سِمَيَ رَ، هَفَرَ قَ نَ دِ سْتْ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","عِبُرَ مَ تٌ بَرَ حّ تٌنفٌ سٌلٌمَنَانِ نُن سٌلٌمَنَانِ سْتْ سِمَيَ رَ، عَلَتَلَ نَشَ مِنِ عَ مَ، عَ قَ يِ مَسٍن عَ بّ، «ﭑ تَن نَن نَ عَلَ سّنبّ كَنيِ رَ. عِ مَحّرّ ﭑ يَ تٌدٍ رَ تِنشِنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ﭑ قَمَ نّ سَاتّ تٌنفٌدٍ وٌن قِرِن تَفِ. ﭑ قَمَ بْنسْي فبٍفبٍ قِدٍ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","عِبُرَ مَ نَشَ عَ شِنبِ سِن، عَ يَتَفِ رَقٍلٍن بْشِ. عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، ");
INSERT INTO susa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«ﭑ بَرَ يِ سَاتّ تٌنفٌ عِ بّ. عِ قَمَ نّ قِندِدٍ سِ وُيَشِ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","عِ شِلِ مُ قَلَمَ سْنْن عِبُرَ مَ، عِ شِلِ قَمَ نّ قَلَدٍ عِبُرَهِمَ، بَرِ مَ ﭑ عِ قِندِ مَ سِ وُيَشِ بَبَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ﭑ قَمَ نّ عِ قِندِدٍ حَمَ فبٍفبٍ بَبَ رَ. عِ قَمَ نّ دِيٍ سْتْدٍ نَشٍيٍ قِندِ مَ سِ وُيَشِ رَ، مَنفّيٍ قَن قَمَ نّ مِنِدٍ عِ شَ دِيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ﭑ نَن ﭑ مَ سَاتّ مَبَنبَنمَ نّ وٌن قِرِن تَفِ، هَلِ عِ دَنفِ شَنبِ، عَ نُن عِ بْنسْي، فبِلٍن نٍيٍ قَن بْنسْي بْنسْي. عَ قِندِ مَ سَاتّ رَ دَن مُ نَ نَشَن مَ. نَ كُي، ﭑ تَن نَن نَ عِ مَرِفِ عَلَ رَ. ﭑ تَن نَن نَ عِ بْنسْي مَرِفِ عَلَ رَ، هَلِ عِ دَنفِ شَنبِ. ");
INSERT INTO susa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ﭑ قَمَ نّ يِ بْشِ قِدٍ عِ تَن نُن عِ بْنسْي مَ، وٌ قَشِ سَبَتِدٍ دّننَشّ. كَنَان بْشِ بِرِن قِندِ مَ نّ وٌ فبٍ رَ عَبَدَن. ﭑ تَن نَن نَ عِ بْنسْي مَرِفِ عَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","عَلَ مَن نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «عِ تَن نُن عِ بْنسْي، فبِلٍن نَ قَن بْنسْي بْنسْي، وٌ لَن نّ وٌ شَ ﭑ مَ سَاتّ رَتِنمّ. ");
INSERT INTO susa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","وٌن مَ سَاتّ نَن يَ، ﭑ نَشَن سَشِ وٌ مَ، وٌ لَن وٌ شَ نَشَن نَتِنمّ، عِ تَن نُن عِ بْنسْييٍ؛ نَشَن بِرِن قِندِشِ شّمّ رَ وٌ يَ مَ، عٍ بِرِن لَن نّ عٍ شَ سُننَ. ");
INSERT INTO susa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","وٌ شَ سُننَ قِندِ مَ سَاتّ تْنشُمَ نَن نَ وٌ تَن نُن ﭑ تَن تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","كٍلِ وٌ تَن مَ، عَ سَ دْشْ وٌ بْنسْي بْنسْي رَ، دِ شّمّ نَشَن بِرِن بَرِ مَ، عَ لَنمَ عٍ شَ سُننَ شِ سٌلٌمَسَشَن ندٍ. نَ سّرِيّ لَن نّ عَ شَ سَ وٌ شَ كٌنيِيٍ مَ نَشٍيٍ نَ وٌ يِ رَ، نَشٍيٍ بَرِشِ وٌ شْنيِ، عَ نُن كٌنيِ نَشٍيٍ سَرَشِ بْشِ فبّتّ مَ، هَلِ عَ مُ قَ نَ عِ بْنسْي شَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","نَ كُي، كٌنيِ نَشَن بَرِشِ عِ شْنيِ عَ نُن عِ نَ نَشَن قَن سَرَ، عٍ بِرِن لَن نّ عٍ شَ سُننَ عَلَكٌ ﭑ مَ سَاتّ تْنشُمَ شَ لُ وٌ قَتٍ مَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","شّمّ نَشَن نَ لُ عَ قَتٍ مُ سُننَ، عَ قَمَ نّ رَ مِنِدٍ عَ بْنسْي يَ مَ، بَرِ مَ عَ مُ ﭑ مَ سَاتّ رَكَمَلِشِ.» ");
INSERT INTO susa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","نَ شَنبِ، عَلَ نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «عِ نَشَ سَرَيِ شِلِ قَلَ عِ شَ فِنّ شُن مَ سْنْن دٍ، عَ قَ شِلِ نّ كْرّ سَرَ. ");
INSERT INTO susa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ﭑ بَرَكّ سَمَ عَ شَ قٍ، عَ قَ دِ شّمّ بَرِ عِ بّ. ﭑ بَرَكّ سَمَ نّ سَرَ شَ قٍ، عَ قَمَ قِندِدٍ سِ فبٍفبٍ نفَ رَ. سِ دْشْ وُيَشِ مَنفّيٍ قَمَ نّ مِنِدٍ عَ شَ دِيٍ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","عِبُرَهِمَ نَشَ عَ يَتَفِ رَقٍلٍن بْشِ مَ، كْنْ عَ نَشَ يٍلٍ، عَ قَ عَ قَلَ عَ بْحّ مَ، «ﭑ تَن نَشَن بَرَ حّ كّمّ سْتْ سِمَيَ رَ، ﭑ نْمَ دِ ندٍ سْتْدٍ سْنْن؟ سَرَ نَشَن بَرَ حّ تٌنفٌ سٌلٌمَنَانِ سْتْ سِمَيَ رَ، عَ قَن نْمَ دِ ندٍ بَرِدٍ قَ؟» ");
INSERT INTO susa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","عَ نَشَ عَ قَلَ عَلَ بّ، «عِ حّنفِ سَ سُمَيِلَ شْن مَ. نَ بَرَ ﭑ وَ سَ.» ");
INSERT INTO susa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","عَلَ نَشَ عَ يَابِ، «عَدٍ! عِ شَ فِنّ سَرَ قَمَ دِ شّمّ بَرِدٍ عِ بّ عِ نَشَن شِلِ سَمَ عِسِيَفَ. ﭑ نَن ﭑ مَ سَاتّ مَبَنبَنمَ نّ ﭑ تَن نُن عَ تَن تَفِ، عَ نُن عَ بْنسْي رَ هَلِ عَ قَشَ شَنبِ. سَاتّ نَن نَ كِ نَشَن مُ كَنَمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ﭑ بَرَ عِ شَ مَشَندِ سُشُ سُمَيِلَ شَ قٍ رَ. ﭑ بَرَكّ سَمَ نّ عَ شَ قٍ، ﭑ مَن قَ دِ فبٍفبٍ بَرِقٍ رَفِرِ عَ مَ، ﭑ بْنسْي وُيَشِ قِمَ نّ عَ مَ. عَ قِندِ مَ نّ مَنفّ دِ قُ نُن قِرِن بَبَ رَ، عَ نُن سِ شُنفبٍ كَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","كْنْ، نَشَن قِندِ ﭑ مَ سَاتّ رَ، ﭑ قَمَ عَ مَبَنبَندٍ ﭑ تَن نُن عِسِيَفَ نَن تَفِ، سَرَ قَمَ دِ شّمّ نَشَن بَرِدٍ عِ بّ تَمُنَ يِ وَشَتِ.» ");
INSERT INTO susa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","عَلَ تٌ فّ نَ مَسٍنيِ رَ، عَ نَشَ كٍلِ عِبُرَهِمَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","عِبُرَهِمَ نَشَ عَ شَ دِ سُمَيِلَ تٌنفٌ، عَ نُن عَ شَ كٌنيِ نَشٍيٍ بَرِشِ عَ شْنيِ، عَ نُن عَ نَشٍيٍ سَرَشِ. شّمّ نَشَن بِرِن نَ عَ شَ بَنشِ كُي، عَ نَشَ عٍ بِرِن سُننَ نَ لْشْي عَلْ عَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","عِبُرَهِمَ قَن نَشَ سُننَ. عِبُرَهِمَ سُننَ تّمُي نَشّ، عَ حّ تٌنفٌ سٌلٌمَنَانِ عَ نُن سٌلٌمَنَانِ نَن نُ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","سُمَيِلَ سُننَمَ تّمُي نَشّ، عَ حّ قُ نُن سَشَن. ");
INSERT INTO susa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","عٍ نَشَ عٍ بِرِن سُننَ لْشْي كٍرٍن، ");
INSERT INTO susa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","عَ نُن شّمّ نَشَن بِرِن نُ نَ عِبُرَهِمَ شَ بَنشِ كُي، كٌنيِ نَشٍيٍ بَرِشِ عَ شْنيِ، عَ نُن عَ نَشٍيٍ قَن سَرَشِ كٍلِقٍ سِ فبّتّيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","عَلَتَلَ مِنِ نّ عِبُرَهِمَ مَ مَمِرٍ، وُرِ بِلِ بٍلٍبٍلٍ نَ دّننَشّ. نَ تّمُي، عِبُرَهِمَ نُ دْشْشِ عَ شَ كِرِ بَنشِ سٌدٍ دّ رَ كُيٍقُرٍ تّمُي يَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","عَ تٌ شّمّ سَشَن تٌ قَ رَ، عَ نَشَ كٍلِ مَقُرٍن، عَ سَ عٍ رَلَن. عَ نَشَ عَ عِفٌرٌ عٍ بّ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","عَ نَشَ عَ مَسٍن عٍ بّ، «ﭑ مَرِفِ، ﭑ بَرَ وٌ مَشَندِ، وٌ شَ وٌ مَلَبُ ﭑ تَن وٌ شَ كٌنيِ شْنيِ، ");
INSERT INTO susa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ﭑ شَ قَ يٍ رَ وٌ بّ عَلَكٌ وٌ شَ وٌ سَنيِيٍ مَشَ. وٌ مَن شَ قٌيٍ تٌنفٌ يِ وُرِ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ﭑ شَ قَ تَامِ رَ وٌ شْن مَ عَلَكٌ وٌ نْمَ سّنبّ سْتْدٍ كِ نَشّ. نَ شَنبِ، وٌ قَ سِفَ وٌ شَ حّرّ رَ. نَ كُي وٌ عَ كٌلٌنمَ وٌ شَ كٌنيِ نَن ﭑ نَ.» نَ شْحّيٍ نَشَ عَ رَتِن، «وٌن بَرَ لَن نَ مَ. عِ نَشَن قَلَشِ، عَ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","نَ نَن لَن، عِبُرَهِمَ نَشَ فبِلٍن مَقُرٍن عَ شَ كِرِ بَنشِ كُي. عَ نَشَ عَ مَسٍن عَ شَ فِنّ سَرَ بّ، «عِ شُلُن. عِ قَرِن قَنيِ سِفَاتِ يَ تٌنفٌ سٌلٌقٍرٍ يَءِلَن تَامِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","نَ شَنبِ، عَ نَشَ عَ فِ، عَ سِفَ نِنفٍ فْورّ، عَ سَ نِنفٍ سُبٍ بْرْشْشِ قَتٍ قَنيِ كٍرٍن تٌنفٌ. عَ نَشَ نَ نِنفٍ سٌ عَ شَ وَلِكّ يِ رَ، عَ شَ عَ قَشَ، عَ شَ عَ يَءِلَن دٌنسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","نَ سُبٍ تٌ بَرَ فّ حِندٍ، عِبُرَهِمَ نَشَ عَ تٌنفٌ، عَ عَ سٌ شْحّيٍ يِ رَ، عَ نُن شِحّ شِنبٍلِ نُن شِحّ بْنبْشِ. عٍ نَ نَ دٌنسٍ دٌنقٍ، عِبُرَهِمَ نَشَ تِ عٍ سّيتِ مَ وُرِ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","نَ شْحّيٍ نَشَ عِبُرَهِمَ مَشْرِن، «عِ شَ فِنّ سَرَ نَ مِندٍن؟» عَ نَشَ عٍ يَابِ، «عَ نَ كِرِ بَنشِ بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","نَ شْحّ مِشِ كٍرٍن نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «ﭑ مَن فبِلٍنمَ تَمُنَ يِ حْندْن تّمُي. نَ تّمُي عِ شَ فِنّ قَمَ دِ شّمّ بَرِدٍ عِ بّ.» سَرَ نُ تِشِ عِبُرَهِمَ شَنبِ رَ كِرِ بَنشِ سٌدٍ دّ رَ، عَ تُلِ مَتِشِ عٍ شَ وْيّنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","عِبُرَهِمَ نُن سَرَ نُ بَرَ فّ قٌرِدٍ. سَرَ مُ نُ نْمَ دِ بَرِدٍ سْنْن. ");
INSERT INTO susa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","سَرَ تٌ نَ مّ، عَ نَشَ يٍلٍ عَ يّتّ مَ، «ﭑ تَن نَ كِ نَشّ يِ كِ ﭑ بَرَ فّ تَفَندٍ. ﭑ مَ شّمّ قَن بَرَ قِندِ شّمّ قٌرِ رَ. مُشُ تَن دِ بَرِ تّمُي بَرَ دَنفِ.» ");
INSERT INTO susa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","عَلَتَلَ نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «سَرَ يٍلٍشِ مُنقٍ رَ؟ عَ عَ قَلَشِ مُنقٍ رَ، عَ تَن مُ نْمَ دِ بَرِدٍ سْنْن، بَرِ مَ عَ بَرَ فّ تَفَندٍ؟ ");
INSERT INTO susa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","نَ قٍ نَ نَ عَلَتَلَ مُ نْمَ نَشَن نَبَدٍ؟ ﭑ نَ قَ تَمُنَ عِ شْنيِ بٍ يِ تّمُي، سَرَ قَمَ نّ دِ بَرِدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","سَرَ نَشَ فَاشُ، عَ نَشَ وُلٍ قَلَ، «ﭑ مُ يٍلٍشِ دٍ.» عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «عِيٌ، عِ يٍلٍشِ نّ!» ");
INSERT INTO susa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","نَ شْحّيٍ نَشَ تِ كِرَ شْن مَ، عٍ نَشَ عٍ شُنسَ سٌدٌ مَ تَا مَ. عِبُرَهِمَ نَشَ سِفَ عٍ مَتِدٍ. ");
INSERT INTO susa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","عَلَتَلَ نَشَ عَ مَسٍن، «ﭑ نْمَ عَ نْشُندٍ عِبُرَهِمَ مَ، ﭑ وَ مَ نَشَن نَبَقٍ؟ ");
INSERT INTO susa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","عَ قَمَ نّ قِندِدٍ سِ بٍلٍبٍلٍ سّنبّمَ رَ. ﭑ قَمَ نّ بَرَكّ سَدٍ سِ بِرِن مَ عَ تَن سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ﭑ نَ عَ سُفَندِشِ نّ، عَلَكٌ عَ شَ نْ يَامَرِ سَدٍ عَ شَ دِيٍ نُن عَ بْنسْييٍ مَ، عٍ شَ نْ عٍ حّنفِ سَدٍ ﭑ مَ سّرِيّ شْن مَ تِنشِنيِ كُي. نَ تّمُي، ﭑ تَن عَلَتَلَ، ﭑ قَمَ نّ ﭑ مَ لَايِدِ رَكَمَلِدٍ ﭑ نَشَن تٌنفٌشِ عِبُرَهِمَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","عَلَتَلَ نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «قٍ نَشَن قَلَشِ سٌدٌ مَكَيٍ نُن فٌمٌرَكَيٍ شُن، قٍ مَفَاشُشِ نَ عَ رَ. عٍ شَ يُنُبِ بَرَ فبٌ هَن، ");
INSERT INTO susa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ﭑ قَمَ فٌرٌدٍ ﭑ شَ سَ عَ مَتٌ قٍ نَشَن بِرِن قَلَشِ عٍ شُن مَ، شَ عَ نَ نَ كِ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","شْحّ قِرِن نَشَ كٍلِ عٍ نُ نَ دّننَشّ، عٍ نَشَ سِفَ سٌدٌ مَ. كْنْ عَلَتَلَ نُن عِبُرَهِمَ نَشَ لُ يِرٍ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","عِبُرَهِمَ نَشَ عَ مَسٌ عَلَتَلَ رَ، عَ نَشَ عَ مَسٍن عَ بّ، «عَلَتَلَ، عِ قَمَ نّ مِشِ كٌبِ نُن مِشِ تِنشِنشِ بِرِن سْنتْدٍ؟ ");
INSERT INTO susa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","تّمُندٍ مِشِ تٌنفٌ سُولِ نَ سٌدٌ مَكَيٍ يَ مَ نَشٍيٍ قِندِشِ مِشِ مَتِنشِنشِيٍ رَ. عِ قَمَ نّ نَ تَا كَنَدٍ؟ عِ مُ نْمَ دِحّدٍ سٌدٌ مَ حَمَ مَ نَ مِشِ مَتِنشِنشِ تٌنفٌ سُولِ شَ قٍ رَ؟ ");
INSERT INTO susa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","عَدٍ، عَ مُ لَن عِ شَ مِشِ كٌبِ نُن مِشِ تِنشِنشِ قَشَ كِ كٍرٍن. عَ مُ لَن كِيتِ كٍرٍن شَ سَ مِشِ كٌبِ نُن مِشِ تِنشِنشِ مَ. عَ مُ لَن عِ شَ نَ رَبَ. نَشَن دُنِحَ بِرِن مَكِيتِمَ، عَ رَبَمَ نّ تِنشِنيِ كِرَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","عَلَتَلَ نَشَ يَابِ تِ، «شَ ﭑ مِشِ مَتِنشِنشِ تٌنفٌ سُولِ لِ سٌدٌ مَ تَا كُي، ﭑ قَمَ نّ دِحّدٍ سٌدٌ مَ مِشِ بِرِن مَ نَ مِشِ تٌنفٌ سُولِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","عِبُرَهِمَ مَن نَشَ وْيّنيِ تٌنفٌ، «ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ عِ شَ نْ دِحّدٍ ﭑ بّ، ﭑ شَ نْ يِ مَسٍنيِ تِدٍ عِ بّ، بَ ﭑ تَن كٍلِشِ شُبٍ نُن بّندّ نّ. ");
INSERT INTO susa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","عِ سَ عَ لِمَ مِشِ تٌنفٌ سُولِ شَ مُ مِشِ مَتِنشِنشِ رَ، تّمُندٍ قٌ مِشِ تٌنفٌ نَانِ عَ نُن سُولِ. نَ مِشِ سُولِ نَشَن لُمَ نَ كِ، عِ قَمَ نّ نَ تَا كَنَدٍ نٍيٍ شَ قٍ رَ؟» عَلَتَلَ نَشَ عَ مَسٍن، «ﭑ مُ نَ كَنَمَ شَ ﭑ مِشِ مَتِنشِنشِ تٌنفٌ نَانِ عَ نُن سُولِ لِ نَا.» ");
INSERT INTO susa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","عِبُرَهِمَ مَن نَشَ عَ مَشْرْشْ، «تّمُندٍ عِ مِشِ تٌنفٌ نَانِ نَن لِمَ نَا.» عَلَتَلَ نَشَ عَ مَسٍن، «ﭑ مُ قَمَ نَ كَنَدٍ نَ مِشِ تٌنفٌ نَانِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","عِبُرَهِمَ نَشَ عَ قَلَ، «ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ، عِ نَشَ شْنْ شَ ﭑ مَن قَ وْيّنيِ ندٍ مَسٍن عِ بّ. تّمُندٍ عِ قَمَ مِشِ تٌنفٌ سَشَن نَن لِدٍ نَا.» عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «ﭑ مُ قَمَ نَ كَنَدٍ شَ ﭑ مِشِ مَتِنشِنشِ تٌنفٌ سَشَن لِ نَا.» ");
INSERT INTO susa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","عِبُرَهِمَ نَشَ عَ مَسٍن، «مَرِفِ عِ شَ عِ هَاكّ تٌ ﭑ بّ ﭑ مَ بْحّ شْرْشْي مَ. تّمُندٍ وٌ مِشِ مْشْحّن نَن لِمَ نَا.» عَلَتَلَ نَشَ عَ مَسٍن، «ﭑ مُ قَمَ نَ تَا كَنَدٍ نَ مِشِ مْشْحّن شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","عِبُرَهِمَ مَن نَشَ عَ قَلَ، «ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ، عِ نَشَ شْنْ. ﭑ مَ مَشْرِنيِ دْنشْي نَن يِ كِ عِ بّ. تّمُندٍ، عِ مِشِ قُ نَن لِمَ نَا.» عَلَتَلَ نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «ﭑ مُ قَمَ نَ تَا كَنَدٍ نَ مِشِ قُ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","عٍ تٌ فّ نَ مَسٍنيِ رَ، عَلَتَلَ نَشَ سِفَ، عِبُرَهِمَ قَن نَشَ فبِلٍن عَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","نُنمَرٍ تّمُي، نَ مَلٍكّ قِرِنيِيٍ نَشَ سٌ سٌدٌ مَ. لٌتِ نُ دْشْشِ نَ تَا سٌدٍ دّ رَ. عَ تٌ مَلٍكّيٍ تٌ قَ رَ، عَ نَشَ كٍلِ عَ سَ عٍ رَلَن كِرَ رَ. عَ نَشَ عَ عِفٌرٌ بْشِ مَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","لٌتِ نَشَ عَ مَسٍن عٍ بّ، «ﭑ بَرَ وٌ مَشَندِ وٌ شَ تِن ﭑ شَ وٌ يِفِيَ ﭑ شْنيِ. وٌ نْمَ وٌ سَنيِيٍ مَشَدٍ، وٌ وٌ مَلَبُ. تِنَ فّيسّفّ وٌ كُرُن وٌ شَ بِيَاسِ رَ.» مَلٍكّيٍ نَشَ عَ يَابِ، «عَدٍ! قٌ مُشُ شَ شِ تَا تَفِ نّ تٌ كْي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","كْنْ لٌتِ نَشَ عَ مَشْرْشْ هَن عٍ نَشَ سِفَ عَ شْنيِ. عَ نَشَ دٌنسٍ قَنيِ رَقَلَ عٍ بّ، عَ نَشَ تَامِ لّبِنِتَرٍ فَن. عٍ نَشَ عٍ دّفٍ. ");
INSERT INTO susa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","سَ تّمُي مُ نُ عَ لِشِ، سٌدٌ مَكَيٍ نَشَ لٌتِ شَ بَنشِ رَبِلِن. كٍلِ سّفّتَلَيٍ مَ، عَ سَ دْشْ شّمْشِيٍ رَ، عٍ بِرِن نُ نَ نَا. ");
INSERT INTO susa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","عٍ نَشَ لٌتِ شِلِ، عٍ عَ مَشْرِن، «نَ مِشِيٍ نَ مِندٍن، نَشٍيٍ سٌشِ عِ شْنيِ تٌ نُنمَرٍ رَ؟ عٍ رَ مِنِ مُشُ مَ، مُشُ شَ كَقُ يِرٍ كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لٌتِ نَشَ مِنِ عَ شَ بَنشِ كُي، عَ تِ نَادّ رَ، عَ نَادّ رَفَلِ عَ شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","عَ نَشَ عَ مَسٍن عٍ بّ، «عَدٍ! ﭑ نفَشَكٍرٍنيِيٍ، وٌ نَشَ قٍ حَاشِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ﭑ مَ دِ فِنّ قِرِنيِيٍ نَ بٍ نَشٍيٍ مُ نُ شّمّ قٍ كٌلٌن. ﭑ بَرَ تِن عَ رَ ﭑ شَ نٍيٍ سَ وٌ سَفٌي، وٌ شَ وٌ وَشْنقٍ بِرِن نَبَ عٍ رَ، عَلَكٌ وٌ نَشَ سٍسٍ رَبَ ﭑ مَ شْحّيٍ رَ. ﭑ تَن بَرَ قِندِ عٍ يَتِفِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","نَ مِشِيٍ نَشَ عَ قَلَ لٌتِ بّ، «مِنِ مُشُ تَفِ. شْحّ نَن عِ رَ بٍ. عِ مُ نْمَ كِيتِ سَدٍ مُشُ مَ. شَ عِ مُ عِ كَتَ، مُشُ قَمَ قٍ شْنّ دْشْدٍ عِ مَ دَنفِقٍ عٍ تَن نَ.» عٍ نَشَ سٌنسٌن لٌتِ مَ، عَلَكٌ عٍ شَ نَادّ كَنَ. ");
INSERT INTO susa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","نَ مَلٍكّ قِرِنيِيٍ نَشَ لٌتِ سُشُ، عٍ نَشَ عَ رَ سٌ بَنشِ كُي، عٍ نَادّ بَلَن عٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","مَلٍكّيٍ نَشَ فَلِ رَدْنشُ، نَشٍيٍ نُ تِشِ نَادّ رَ. كٍلِ سّفّتَلَيٍ مَ، سَ دْشْ شّمْشِيٍ رَ، عٍ مُ نُ سٍسٍ تٌمَ قَ. كِرَ نَشَ عِقُ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","نَ مَلٍكّ قِرِنيِيٍ نَشَ لٌتِ مَشْرِن، «عِ شَ مِشِ ندٍ نَ بٍ؟ عِ شَ عِ شَ دِ بِرِن نَمِنِ يِ تَا كُي. عِ شَبِلّ شَ كٍلِ بٍ، ");
INSERT INTO susa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","بَرِ مَ مُشُ قَقٍ يِ تَا كَنَدٍ. يِ تَاكَيٍ شَ وَلِ كٌبِ بَرَ قِندِ سٍيدٍحْشْيَ رَ عَلَتَلَ بّ. عَلَتَلَ مَن مُشُ رَ سَنبَشِ نّ، مُشُ شَ قَ يِ تَا كَنَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","لٌتِ نَشَ سِفَ عَ قَلَ عَ شَ دِيٍ شَ مْرِيٍ بّ، «وٌ كٍلِ بٍ مَقُرٍن! عَلَتَلَ نَ قَقٍ بٍ كَنَدٍ يَكْسِ.» عٍ نَشَ عَ مَحْشُن عَ نَ فبّنتّنقٍ نّ. ");
INSERT INTO susa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","نَ سُبَشّ مَ، مَلٍكّيٍ نَشَ فبَتَ لٌتِ رَ، عٍ نَشَ عَ مَسٍن عَ بّ، «كٍلِ، عِ شَ فِنّ تٌنفٌ، عَ نُن عِ شَ دِ فِنّ قِرِنيِ نَشٍيٍ نَ بٍ. وٌ شَ كٍلِ بٍ عَلَكٌ وٌ نَشَ سْنتْ عَ نُن يِ تَا مِشِ كٌبِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","عَ تٌ نُ وَ مَ بُقٍ، مَلٍكّيٍ نَشَ لٌتِ سُشُ عَ بّلّشّ مَ، عَ نُن عَ شَ فِنّ، سَ عَ شَ دِ فِنّ قِرِنيِيٍ شُن مَ. عٍ نَشَ عٍ رَ مِنِ تَا كُي، بَرِ مَ عَلَتَلَ نُ بَرَ كِنِكِنِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","مَلٍكّيٍ تٌ عٍ رَ مِنِ، كٍرٍن نَشَ عَ مَسٍن لٌتِ بّ، «عِ فِ، عَلَكٌ عِ شَ عِ نِي رَتَنفَ. عِ نَشَ عِ كٌبٍ رَتٌ دٍ! عِ نَشَ عِ مَتِ يِ تَا يِرٍ يٌي. شَ عِ مُ وَ مَ عِ شَ سْنتْ، سِفَ نَ فٍيَ يِرٍ.» ");
INSERT INTO susa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لٌتِ نَشَ عَ قَلَ، «عَدٍ، ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ، ﭑ مُ نْمَ نَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ﭑ عَ كٌلٌن، عِ بَرَ هِننّ عِ شَ كٌنيِ دِ رَ. عِ بَرَ كِنِكِنِ ﭑ مَ عَ فبٍفبٍ رَ. عِ بَرَ ﭑ نِي رَتَنفَ. كْنْ، ﭑ تَن مُ نْمَ ﭑ فِدٍ هَن فٍيَ مَ، شَ نَ مُ عَ رَ ﭑ قَشَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","عِ بَرَ نَ تَا لَنمَدِ تٌ نَشَن مَكْرّشِ وٌن نَ؟ ﭑ نْمَ نَ تَن لِدٍ. عَ لُ ﭑ شَ سِفَ نَا، ﭑ نِي شَ رَتَنفَ. عَ مَتٌ، تَا شُرُدِ شَ مُ عَ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","مَلٍكّ نَشَ عَ يَابِ، «ﭑ بَرَ تِن نَ بِرِن نَ. ﭑ مُ نَ تَا كَنَمَ. ");
INSERT INTO susa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","سِفَ مَقُرٍن. هَن عِ سَ سٌمَ تّمُي نَشّ، ﭑ مُ قٍقٍ رَبَمَ.» نَ تَا شِلِ سَشِ نّ سٌوَرِ، بَرِ مَ عَ شُرُن. ");
INSERT INTO susa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","سٌفٍ نُ تٍقٍ تّمُي نَشّ، لٌتِ نَشَ سٌ سٌوَرِ تَا كُي. ");
INSERT INTO susa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","نَ تّمُي، عَلَتَلَ نَشَ سٌودَ نُن تّ رَفٌرٌ فٌمٌرَ تَا نُن سٌدٌ مَ تَا مَ. ");
INSERT INTO susa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","عَ نَشَ نَ تَايٍ تُشُنسَن، كٍلِ سَنسِيٍ مَ، عَ سَ دْشْ مِشِيٍ رَ نَشٍيٍ بِرِن سَبَتِشِ نَ تَايٍ كُي. ");
INSERT INTO susa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","لٌتِ شَ فِنّ نَشَ عَ كٌبٍ رَتٌ، نَ نَن لَن عَ نَشَ قِندِ قْشّ شُتِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","نَ سُبَشّ مَ، عِبُرَهِمَ نَشَ كٍلِ، عَ عَ شُنسَ يِرٍ مَ عَ نُن عَلَتَلَ دّ مَسَرَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","عَ تٌ عَ يَ رَ سِفَ فٌمٌرَ نُن سٌدٌ مَ مَ، عَ نُن نَ رَبِلِنيِ بِرِن، عَ نَشَ تُورِ فبٍفبٍ تٌ تٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","عَلَ تٌ نَ تَايٍ كَنَ لٌتِ نُ سَبَتِشِ دّننَشّ، عَ عَ رَتَنفَ نَ فبَلٌي مَ عِبُرَهِمَ شَ قٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","لٌتِ نُ بَرَ فَاشُ لُقٍ رَ سٌوَرِ تَا كُي. عَ نَشَ كٍلِ نَا، عَ سِفَ فٍيَ قَرِ. عَ نَشَ سَبَتِ عَ نُن عَ شَ دِ فِنّ قِرِنيِيٍ رَ قْنمّ ندٍ كُي فّمّ لٌنفٌرِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","لْشْي ندٍ، عَ شَ دِ فِنّ سِنفٍ نَشَ عَ قَلَ عَ شُنيَ بّ، «وٌن بَبَ بَرَ قٌرِ. وٌن نَ دّننَشّ يِ كِ، شّمّ يٌ مُ نَ وٌن دْشْمَ نَشَن شْن عَلْ عَدَ مَ دَرِشِ عَ رَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","قَ بٍ، وٌن شَ وٌن بَبَ رَ سِيسِ عَلَكٌ وٌن شَ شِ عَ شْن مَ، عَلَكٌ وٌن شَ دِ قِ عَ مَ نَشَن قِندِ مَ عَ بْنسْي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","نَ كْي رَ، عٍ نَشَ عٍ بَبَ رَ سِيسِ. عَ شَ دِ فِنّ سِنفٍ نَشَ شِ عَ بَبَ شْن مَ. عَ مُ عَ شُن مَ قٍ يٌ كٌلٌن، عَ شَ دِ سَ تّمُي، نُن عَ كٍلِ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","كُيٍ تٌ عِبَ، عَ شَ دِ فِنّ سِنفٍ نَشَ عَ قَلَ عَ شُنيَ بّ، «عَ بَرَ حْن، ﭑ تَن نُن ﭑ بَبَ بَرَ شِ يِرٍ كٍرٍن تٌ. تٌ كْي رَ، عِ نُن وٌن بَبَ قَمَ شِدٍ يِرٍ كٍرٍن. نَ تّمُي وٌن نْمَ بْنسْي قِدٍ عَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","نَ كْي مَن نَ، عٍ نَشَ عٍ بَبَ رَ سِيسِ. عَ شُنيَ قَن نَشَ شِ عَ بَبَ شْن مَ. عَ مُ عَ شُن مَ قٍ يٌ كٌلٌن، عَ شَ دِ سَ تّمُي، نُن عَ كٍلِ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","لٌتِ شَ دِ فِنّ قِرِنيِيٍ نَشَ قُرِ تٌنفٌ عٍ بَبَ شَ دِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","نَ دِ فِنّ سِنفٍ تٌ دِ بَرِ، عَ شِلِ نَشَ سَ مٌوَبَ. نَ نَن قِندِ مٌوَبَكَيٍ بِرِن بٍنبَ رَ. هَن يَكْسِ عٍ نَ نَ. ");
INSERT INTO susa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","عَ شَ دِ فِنّ قِرِن ندٍ قَن نَشَ دِ بَرِ، عَ شِلِ نَشَ سَ بٍن عَمِ. نَ نَن قِندِ عَمٌنِكَيٍ بِرِن بٍنبَ رَ. هَن يَكْسِ عٍ نَ نَ. ");
INSERT INTO susa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","عِبُرَهِمَ نَشَ سِفَ نٍفٍوِ بْشِ مَ، عَ سَبَتِ كَدٍ سِ نُن سُرُ تَفِ. نَ دَنفِ شَنبِ عَ نَشَ سِفَ فٍرَرَ، عَ سَشَنيِ رَبَ مّننِ. ");
INSERT INTO susa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","عِبُرَهِمَ نَشَ عَ قَلَ مّننِكَيٍ بّ عَ شَ فِنّ سَرَ شَ قٍ رَ، «ﭑ شُنيَ فِنّمَ نَن عَ رَ.» نَ كُي فٍرَرَ مَنفّ عَبِمٍلٍكِ نَشَ سَرَ تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","كْي تٌ سٌ، عَلَ نَشَ عَ مَسٍن عَبِمٍلٍكِ بّ شِيٍ كُي، «عِ قَمَ نّ قَشَدٍ يِ فِنّ شَ قٍ رَ، عِ نَشَن تٌنفٌشِ، بَرِ مَ شّمّ تَا عِدْشْي نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","نَ تّمُي عَبِمٍلٍكِ مُ نُ عَ مَكْرّشِ عَ رَ. عَ نَشَ عَ يَابِ، «ﭑ مَرِفِ، عِ قَمَ نّ سِ تِنشِنشِ شَ قٍ كَنَدٍ؟ ");
INSERT INTO susa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","عِبُرَهِمَ عَ مَسٍن نّ ﭑ بّ، عَ يِ فِنّ عَ شُنيَ فِنّمَ نَن لَنشِ عَ مَ. فِنّ قَن نَشَ عَ قَلَ ﭑ بّ، عَ تَارَ نَن لَنشِ عِبُرَهِمَ مَ. ﭑ نَشَن نَبَشِ، ﭑ نَ رَبَشِ ﭑ بْحّ قِيشّ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","عَلَ مَن نَشَ عَ مَسٍن عَ بّ نَ شِيٍ كُي، «ﭑ تَن يَتِ، ﭑ نَ كٌلٌن عِ قٍ نَشَن نَبَشِ، قٍ كٌبِ شَ مُ عَ رَ. ﭑ تَن نَن مَن عَ نِيَشِ، عِ مُ نْشِ يُنُبِ قٍ رَبَدٍ ﭑ نَ. نَ نَن عَ تٌشِ ﭑ مُ عَ لُشِ عِ شَ عَ قِندِ عِ شَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","يَكْسِ، يِ فِنّ رَفبِلٍن عَ شَ مْرِ مَ. نَمِحْنمّ نَن عَ رَ. عَ قَمَ نّ عَلَ مَشَندِدٍ عِ بّ، عَلَكٌ عِ نِي رَتَنفَمَ كِ نَشّ. كْنْ شَ عِ مُ عَ رَفبِلٍن عَ شَ مْرِ مَ، عَ كٌلٌن عِ قَمَ نّ قَشَدٍ وٌ نُن عِ شَ دٍنبَيَ بِرِن.» ");
INSERT INTO susa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","عَبِمٍلٍكِ نَشَ كٍلِ سِننَنيِ مَ، عَ نَشَ عَ شَ كٌنيِيٍ بِرِن مَلَن. قٍ نَشَن بِرِن دَنفِشِ، عَ نَ تَفِ رَبَ عٍ بّ. فَاشُي فبٍفبٍ نَشَ عٍ سُشُ. ");
INSERT INTO susa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","عَبِمٍلٍكِ نَشَ عِبُرَهِمَ شِلِ عَ شْنيِ. عَ نَشَ عَ مَشْرِن، «ﭑ يُنُبِ مُندُن نَبَشِ عِ رَ، عِ شَ نْ ﭑ تَن نُن ﭑ مَ حَمَ قِندِدٍ يُنُبِتْي بٍلٍبٍلٍيٍ رَ؟ عِ بَرَ قٍ رَبَ ﭑ نَ، قٍ نَشَن مُ لَن عَ شَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","مُنقٍ عَ نِيَشِ عِ نَ رَبَشِ؟» ");
INSERT INTO susa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","عِبُرَهِمَ نَشَ عَ يَابِ، «ﭑ عَ قَلَ نّ مِشِ نَشٍيٍ بِرِن نَ بٍ، عٍ مُ فَاشُمَ عَلَ يَ رَ، عٍ قَمَ نّ ﭑ قَشَدٍ ﭑ مَ فِنّ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","نْندِ نَن عَ رَ، ﭑ شُنيَ نَن مَن لَنشِ عَ مَ. مُشُ بِرِن بَبَ كٍرٍن، كْنْ مُشُ نفَ كٍرٍن مُ عَ رَ. نَ نَن عَ تٌشِ عَ قِندِشِ ﭑ مَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","عَلَ تٌ بَرَ ﭑ تٌنفٌ ﭑ بَبَ شْنيِ، ﭑ نَشَ عَ مَسٍن ﭑ مَ فِنّ بّ، ‹وٌن نَ سِفَ دّدّ، يَندِ ﭑ بَرَ عِ مَشَندِ عِ شَ عَ قَلَ، ﭑ شُنيَ نَن لَنشِ عِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","عَبِمٍلٍكِ نَشَ يّشّييٍ، سِيٍ، نِنفٍيٍ، نُن كٌنيِيٍ تٌنفٌ، عَ نَشَ عٍ بِرِن سٌ عِبُرَهِمَ يِ رَ. عَ مَن نَشَ عَ شَ فِنّ سَرَ رَفبِلٍن عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","عَ نَشَ عَ قَلَ عِبُرَهِمَ بّ، «ﭑ مَ بْشِ بَرَ رَبِ عِ بّ. عِ نَ وَ لُقٍ دّدّ يِ بْشِ مَ، عِ شَ لُ نَا.» ");
INSERT INTO susa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","عَ نَشَ عَ قَلَ سَرَ بّ، «عِ بَرَ عَ تٌ، ﭑ بَرَ كْبِرِ كٌلٍ وُلُ قِرِن سٌ عِ تَارَ يِ رَ، عَلَكٌ يَافِ شَ بَ عِ يَ رَ، عِ تَن نُن عِ مَلَن بٌورٍ بِرِن تَفِ. نَ كُي عِ شُن نَكٍلِ سْتْمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","عِبُرَهِمَ تٌ عَلَ مَشَندِ، عَلَ نَشَ عَبِمٍلٍكِ، عَ شَ فِنّ، نُن عَ شَ كٌنيِيٍ يَلَن، عَلَكٌ عٍ مَن شَ نْ دِ بَرِدٍ. ");
INSERT INTO susa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","عَلَتَلَ نُ بَرَ دِبَرِتَرٍحَ رَفِرِ عَبِمٍلٍكِ شَ مِشِيٍ مَ عِبُرَهِمَ شَ فِنّ سَرَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","عَلَتَلَ نَشَ هِننّ سَرَ رَ، عَ عَ شَ لَايِدِ رَكَمَلِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","سَرَ نَشَ تّيفّ. عَ شَ مْرِ شَ شّمّقٌرِحَ كُي، عَ نَشَ دِ بَرِ عِبُرَهِمَ بّ عَلَ وَشَتِ نَشَن قَلَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","عِبُرَهِمَ نَشَ عَ شَ دِ شِلِ سَ عِسِيَفَ، سَرَ نَشَن سْتْشِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","عَ نَشَ عَ شَ دِ سُننَ عَ شِ سٌلٌمَسَشَن لْشْي عَلْ عَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","عِبُرَهِمَ نُ بَرَ حّ كّمّ سْتْ سِمَيَ رَ، عِسِيَفَ بَرِشِ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","سَرَ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ نَسّيوَ. مِشِ يٌ نَ ﭑ مَ دِ عِسِيَفَ بَرِقٍ مّ، مُشُ بِرِن سّيوَ مَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","عَ مَن نَشَ عَ قَلَ، «ندٍ نُ نْمَ عَ قَلَدٍ عِبُرَهِمَ بّ نَ تّمُي، لْشْي ندٍ قَمَ عَ لِدٍ، سَرَ قِندِ مَ نّ دِنفّ رَ؟ كْنْ ﭑ تَن بَرَ دِ قِ عَ مَ عَ شَ شّمّقٌرِحَ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","عِسِيَفَ تٌ مْ، عٍ نَشَ عَ دّ بَ شِحّ رَ. عِبُرَهِمَ نَشَ حّلّشِن شُلُنيِ بٍلٍبٍلٍ سَ، عَ شَ دِيْرّ دّ بَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","نَ تّمُي سَرَ نَشَ سُمَيِلَ تٌ يٍلٍ رَ، مِسِرَكَ هَفَرَ دِ نَشَن بَرِشِ عِبُرَهِمَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","سَرَ نَشَ عَ قَلَ عِبُرَهِمَ بّ، «يِ كٌنيِ فِنّ كٍرِ، عَ نُن عَ شَ دِ. يِ نَشَن يِ كِ، عَ مُ لَن عَ نُن ﭑ مَ دِ عِسِيَفَ شَ لُ كّ كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","نَ وْيّنيِ مُ رَقَن عِبُرَهِمَ مَ عَ شَ دِ شَ قٍ رَ، ");
INSERT INTO susa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","كْنْ عَلَ نَشَ عَ مَسٍن عِبُرَهِمَ بّ، «عِ بْحّ نَشَ رَحَاشُ عِ مَ عِ شَ كٌنيِ فِنّ نُن عَ شَ دِ شَ قٍ رَ. سَرَ نَ قٍ نَشَن بِرِن قَلَ عِ بّ، عَ بِرِن نَبَ عَ بّ، بَرِ مَ عِسِيَفَ نَن قَمَ قِندِدٍ عِ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ﭑ سِ قَن نَمِنِمَ نّ عِ شَ كٌنيِ فِنّ شَ دِ، بَرِ مَ عِ شَ دِ نَن لَنشِ عَ قَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","عِبُرَهِمَ نَشَ كٍلِ سُبَشّ مَ. عَ نَشَ تَامِ تٌنفٌ عَ نُن كِرِ فبْنقْي، يٍ نَ كُي. عَ نَشَ نَ بِرِن دْشْ هَفَرَ شُن مَ، عَ نَشَ دِ سٌ عَ يِ رَ، عَ قَ عٍ بِرِن نَسِفَ. هَفَرَ نَشَ عَ شُن تِ فبٍنفبٍرٍن يِرٍ رَ دّننَشّ شِلِ بٍرِ سٍيبَ. ");
INSERT INTO susa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","يٍ تٌ بَرَ حْن عَ شَ كِرِ فبْنقْي كُي، عَ نَشَ عَ شَ دِ لُ وُرِ ندٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","عَ نَشَ سِفَ، عَ سَ دْشْ عَ شَتِ مَ يَامِلّ كٍرٍن حْندْنيِ. عَ نَشَ عَ قَلَ، «ﭑ مُ نْمَ ﭑ يَ تِدٍ ﭑ مَ دِ رَ، عَ شَ قَشَ ﭑ يَ شْرِ.» عَ نَشَ سِفَ عَ سَ دْشْ عَ شَتِ مَ عَ نُ وَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","عَلَ نَشَ نَ دِ وَ شُي مّ كٌورٍ مَ. عَلَ شَ مَلٍكّ نَشَ هَفَرَ شِلِ، عَ نَشَ عَ مَشْرِن، «هَفَرَ مُنسٍ عِ سْتْشِ؟ عِ نَشَ فَاشُ بَرِ مَ عَلَ بَرَ عِ شَ دِ وَ شُي مّ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","كٍلِ، عِ شَ مّينِ عِ شَ دِ مَ، بَرِ مَ ﭑ قَمَ عَ قِندِدٍ سِ بٍلٍبٍلٍ كَنيِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","عَلَ نَشَ هَفَرَ يَ رَبِ، عَ نَشَ كْلْنيِ ندٍ تٌ. عَ نَشَ كِرِ فبْنقْي تٌنفٌ، عَ يٍ سَ عَ كُي، عَ ندٍ قِ عَ شَ دِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","عَلَ نَشَ عَ حّنفِ سَ سُمَيِلَ شْن مَ. عَ نَشَ مْ، عَ سَ سَبَتِ فبٍنفبٍرٍن يِرٍ، دّننَشّ شِلِ ثَرَن. عَ نَشَ قِندِ شَلِ وٌلِ يِ مَتِنشِنشِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","عَ نفَ نَشَ مِسِرَ فِنّ كٍرٍن قٍن عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","نَ تّمُي عَبِمٍلٍكِ نُن عَ شَ سْورِ مَنفّ ثِكٌلِ نَشَ عَ قَلَ عِبُرَهِمَ بّ، «عِ قٍقٍ يٌ رَبَمَ وٌ نُن عَلَ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","عِ رَكَلِ ﭑ بّ عَلَ شِلِ رَ، قَ سَ شِلِ مَ عِ مُ قَمَ ﭑ يَنقَدٍ، عِ مُ ﭑ مَ دِيٍ يَنقَمَ، عِ مُ ﭑ مَ مَمَدِيٍ قَن يَنقَمَ. عِ شَ قٍ قَنيِ رَبَ ﭑ بّ عَ نُن يِ بْشِ مِشِيٍ بّ عِ نَ دّننَشّ، عَلْ ﭑ نَ رَبَ عِ بّ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","عِبُرَهِمَ نَشَ عَ يَابِ، «ﭑ بَرَ ﭑ كَلِ عَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","عِبُرَهِمَ نَشَ كْرْ سِ رَبَ عَبِمٍلٍكِ رَ قٍ مَ عَ شَ مِشِيٍ نَشَن نِيَشِ عَ رَ، عَ شَ كْلْنيِ بَقٍ عَ فبٍحَ. ");
INSERT INTO susa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","عَبِمٍلٍكِ نَشَ عَ يَابِ، «ﭑ مُ عَ كٌلٌن نَشَن نَ قٍ رَبَشِ عِ رَ. عِ مُ يِ وْيّنيِ قَلَشِ ﭑ بّ، قٌ تٌ ﭑ تَن قَ نَ كٌلٌن.» ");
INSERT INTO susa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","نَ نَن لَن، عِبُرَهِمَ نَشَ يّشّييٍ نُن نِنفٍيٍ قِ عَبِمٍلٍكِ مَ، عٍ شَ سَاتّ تٌنفٌ عٍ بٌورٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","عِبُرَهِمَ نَشَ يّشّي سٌلٌقٍرٍ تٌنفٌ، عَ نَشَ عٍ سَ عَ شَتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","عَبِمٍلٍكِ نَشَ عَ مَشْرِن، «عِ نَ يّشّي سٌلٌقٍرٍ سَشِ عَ شَتِ مَ مُنقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","عِبُرَهِمَ نَشَ عَ يَابِ، «ﭑ نٍيٍ سٌقٍ نّ عِ يِ رَ، عَلَكٌ عِ شَ عَ كٌلٌن، قَ سَ شِلِ مَ، يِ كْلْنيِ نَشَن يِ كِ، ﭑ تَن نَن عَ فٍشِ.» ");
INSERT INTO susa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","نَ نَن عَ تٌشِ، نَ تَا شِلِ قَلَمَ بٍرِ سٍيبَ، بَرِ مَ نَ مِشِ قِرِنيِيٍ عٍ رَكَلِ عٍ بٌورٍ بّ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","عٍ تٌ نَ سَاتّ تٌنفٌ عٍ بٌورٍ بّ بٍرِ سٍيبَ، عَبِمٍلٍكِ نُن عَ شَ سْورِ مَنفّ ثِكٌلِ نَشَ تِ كِرَ شْن مَ فبِلٍنقٍ قِلِسِتَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","عِبُرَهِمَ نَشَ تَمَرٍ وُرِ بِلِ كٍرٍن سِ بٍرِ سٍيبَ. عَ نَشَ عَلَتَلَ مَشَندِ عَ شِلِ رَ، عَلَ نَشَن نَ نَ. ");
INSERT INTO susa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","عِبُرَهِمَ حّ فبٍفبٍ رَبَ نّ قِلِسِتَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","نَ قٍ دَنفِ شَنبِ، عَلَ نَشَ عِبُرَهِمَ مَتٌ. عَ نَشَ عَ شِلِ، «عِبُرَهِمَ.» عِبُرَهِمَ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ.» ");
INSERT INTO susa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","عَلَ مَن نَشَ عَ مَسٍن عَ بّ، «عِ شَ دِ عِسِيَفَ تٌنفٌ، عِ شَ دِ كٍرٍنيِ، نَشَن نَقَنشِ عِ مَ، عِ شَ عَ شَنِن بْشِ مَ دّننَشّ شِلِ مٌرِيَ، فٍيَ قَرِ ﭑ نَ دّننَشّ مَسٍن عِ بّ. عِ شَ عَ قِ ﭑ مَ سّرّشّ فَن دَاشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","سُبَشّ مَ عِبُرَهِمَ نَشَ كٍلِ، عَ نَشَ دْشْسٍ يَءِلَن عَ شَ سٌقَلٍ قَرِ. عَ نَشَ عَ شَ وَلِكّ قِرِن تٌنفٌ عَ نُن عَ شَ دِ عِسِيَفَ. عِبُرَهِمَ نَشَ يٍفٍ عِبْو نَشَن قِندِ مَ تّ شُرُ سٍ رَ سّرّشّ بَدٍ. عَ نَشَ بِيَاسِ قْلْ سِفَقٍ رَ يِرٍ عَلَ دّننَشّ مَسٍنشِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","نَ شِ سَشَن لْشْي، عِبُرَهِمَ يَ نَشَ تِ نَ يِرٍ مَكُيٍ رَ، عَ سِفَقٍ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","عَ نَشَ عَ قَلَ عَ شَ وَلِكّ قِرِنيِيٍ بّ، «وٌ تَن نُن سٌقَلٍ شَ لُ بٍ. ﭑ تَن نُن ﭑ مَ دِ، مُشُ نَ سِفَقٍ فٍيَ قَرِ سَلِدٍ. نَ تّمُي مُشُ مَن فبِلٍنمَ هَن بٍ.» ");
INSERT INTO susa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","عِبُرَهِمَ نَشَ نَ يٍفٍ دْشْ عَ شَ دِ عِسِيَفَ شُن مَ. عَ مَن نَشَ تّ وٌلٍ نُن قِنّ شَنِن. عٍ حّرّقٍ عٍ قِرِن. ");
INSERT INTO susa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","عِسِيَفَ نَشَ عَ بَبَ عِبُرَهِمَ شِلِ، «ﭑ بَبَ.» عَ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ، ﭑ مَ دِ.» عِسِيَفَ نَشَ عَ بَبَ مَشْرِن، «ﭑ بَرَ عَ تٌ يٍفٍ نُن تّ شُرُ سٍ نَ وٌن يِ رَ، كْنْ يّشّي نَ مِندٍن وٌن نَشَن بَقٍ سّرّشّ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","عِبُرَهِمَ نَشَ عَ يَابِ، «ﭑ مَ دِ، عَلَ يَتِ نَن يّشّي سٌمَ وٌن يِ رَ، وٌن نَشَن بَمَ سّرّشّ فَن دَاشِ رَ.» عٍ حّرّقٍ عٍ قِرِن. ");
INSERT INTO susa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","عٍ تٌ يِرٍ لِ عَلَ دّننَشّ مَسٍنشِ عِبُرَهِمَ بّ، عِبُرَهِمَ نَشَ سّرّشّبَدٍ يَءِلَن، عَ يٍفٍ سَ عَ قَرِ. عَ نَشَ عَ شَ دِ عِسِيَفَ شِرِ، عَ عَ سَ سّرّشّبَدٍ كْن نَ، نَ يٍفٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","نَ شَنبِ، عِبُرَهِمَ نَشَ قِنّ تٌنفٌ، عَ نَشَ عَ بّلّشّ عِتَلَ عَ شَ عَ شَ دِ كْن نَشَبَ، ");
INSERT INTO susa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","كْنْ عَلَتَلَ شَ مَلٍكّ نَشَ عَ شِلِ كٌورٍ مَ، «عِبُرَهِمَ، عِبُرَهِمَ!» عِبُرَهِمَ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ.» ");
INSERT INTO susa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","مَلٍكّ نَشَ عَ قَلَ، «يِ سّفّتَلَ لُ نَا. عِ نَشَ قٍقٍ حَاشِ يٌ رَبَ عَ رَ. ﭑ بَرَ عَ كٌلٌن عِ فَاشُمَ عَلَ يَ رَ. ﭑ مَن بَرَ لَ عَ رَ، عِ مُ تٌندِشِ عِ شَ دِ كٍرٍنيِ قِدٍ ﭑ مَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","عِبُرَهِمَ نَشَ عَ يَ رَفبِلٍن عَ شَنبِ رَ، عَ نَشَ يّشّي كٌنتٌنيِ تٌ سَنسِ لٌنفٌرِ رَ، عَ قٍرِ قِرِنيِ كَنكَنشِ سَنسِ قِرِ رَ. عَ نَشَ سِفَ، عَ سَ نَ يّشّي كٌنتٌنيِ تٌنفٌ، عَ قَ عَ رَ. عَ نَشَ نَ بَ سّرّشّ رَ عَ شَ دِ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","عِبُرَهِمَ نَشَ نَ يِرٍ شِلِ سَ «عَلَتَلَ مِشِ كِمَ.» نَ نَن عَ تٌشِ هَن يَكْسِ عَ قَلَمَ «عَلَتَلَ مِشِ كِمَ عَ شَ فٍيَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","عَلَتَلَ شَ مَلٍكّ مَن نَشَ فبِلٍن عِبُرَهِمَ شِلِ رَ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","عَ نَشَ عَ مَسٍن عَ بّ، «ﭑ بَرَ ﭑ كَلِ ﭑ يّتّ رَ، عَلَتَلَ شَ مَسٍنيِ نَن يَ. عِ تٌ بَرَ يِ رَبَ، عِ مُ تٌندِ عِ شَ دِ كٍرٍنيِ مَ ﭑ بّ، ");
INSERT INTO susa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ﭑ بَرَكّ سَمَ نّ عِ مَ. عِ بْنسْي وُيَمَ نّ عَلْ تُنبُي نَشٍيٍ نَ كٌورٍ مَ، شَ نَ مُ عَ رَ عٍ فبٌمَ نّ عَلْ مّيّنيِ نَشَن مَلَنشِ بَا دّ رَ. عِ بْنسْي قَمَ نّ نْدٍ عٍ يَشُييٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ﭑ قَمَ نّ بَرَكّ سَدٍ دُنِحَ سِ بِرِن مَ عِ بْنسْي سَابُي رَ، بَرِ مَ عِ بَرَ ﭑ شُي رَتِنمّ.» ");
INSERT INTO susa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","عِبُرَهِمَ نَشَ فبِلٍن عَ شَ كٌنيِيٍ يِرٍ. عٍ بِرِن نَشَ سِفَ بٍرِ سٍيبَ، بَرِ مَ عِبُرَهِمَ نُ سَبَتِشِ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","نَ قٍ بِرِن تٌ دَنفِ، عِبُرَهِمَ نَشَ عَ مّ مِلِكَ دِيٍ بَرِ نّ عِبُرَهِمَ شُنيَ نَشٌرِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عٍ شِلِ نَن يَ؛ عَ شَ دِ سِنفٍ عُسِ، نَ شَنبِرَتٌي بُسِ، عَرَ مِ بَبَ كٍمُوٍلِ، ");
INSERT INTO susa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","كٍسٍدٍ، هَسٌ، ثِلِدَ سِ، يِدِلَقِ نُن بٍتُوٍلِ. ");
INSERT INTO susa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","بٍتُوٍلِ قِندِ رٍبٍكَ بَبَ نَن نَ. نَ دِ سٌلٌمَسَشَنيِ، مِلِكَ نَن نٍيٍ بَرِ عِبُرَهِمَ شُنيَ نَشٌرِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","نَشٌرِ شَ كٌنيِ فِنّ نُ شِلِ نّ رٍيُمَ. عَ يِ دِيٍ نَن بَرِ؛ تٍبَ، فَشَمِ، تَشَسَ، نُن مَاكَ. ");
INSERT INTO susa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","سَرَ تٌ حّ كّمّ حّ مْشْحّن عَ نُن سٌلٌقٍرٍ نَن سْتْ سِمَيَ رَ، ");
INSERT INTO susa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","عَ نَشَ لَاشِرَ كِرِيَتِ عَرَبَ، هٍبِرٌن مَبِرِ، كَنَان بْشِ مَ. عِبُرَهِمَ نَشَ عَ شَ فِنّ حْن قٍ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","عِبُرَهِمَ تٌ فّ وَدٍ عَ شَ فِنّ بّ، عَ نَشَ سِفَ شِتِكَيٍ شْن مَ، عَ عَ قَلَ عٍ بّ، ");
INSERT INTO susa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«شْحّ نَن لَنشِ ﭑ مَ وٌ يَ مَ بٍ. ﭑ بَرَ وٌ مَشَندِ، وٌ فَبُرِ يِرٍ قِ ﭑ مَ، ﭑ نْمَ ﭑ مَ فِنّ رَفَتَدٍ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","شِتِكَيٍ نَشَ عَ يَابِ، ");
INSERT INTO susa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«عِ تُلِ مَتِ مُشُ رَ عَ قَنيِ رَ. عَلَ شَ مِشِ نَن عِ رَ مُشُ يَ مَ. عِ نَ وَ عِ شَ فِنّ رَفَتَقٍ مُشُ شَ فَبُرِ يِرٍ يٌي، عِ سَفٌ نَ عَ رَ. مُشُ تَن يَ مَ بٍ، مِشِ يٌ مُ نَ نَشَن نْمَ تٌندِدٍ عِ بّ عِ شَ فِنّ رَفَتَدٍ عَ شَ فَبُرِ يِرٍ.» ");
INSERT INTO susa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","عِبُرَهِمَ نَشَ كٍلِ، عَ عِفٌرٌ بْشِ مَ شِتِ بْنسْي يَ عِ، نَشٍيٍ نُ سَبَتِشِ نَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","عَ نَشَ عَ قَلَ عٍ بّ، «شَ وٌ بَرَ تِن، ﭑ شَ ﭑ مَ فِنّ رَفَتَ وٌ شَ بْشِ مَ، وٌ شَ ﭑ مَ مَشَندِ رَدَنفِ سٌشَرَ شَ دِ عٍقٍرٌن مَ، ");
INSERT INTO susa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","عَلَكٌ عَ شَ مَكِثٍلَ قْنمّ سٌ ﭑ يِ رَ فَبُرِ رَ نَشَن نَ عَ شَ شّ قّ مَ. ﭑ عَ كٌلٌن عَ تَن نَن فبٍ لَنشِ مّننِ مَ. عَ شَ نَ سَرَ ﭑ مَ وٌ يَ شْرِ، عَلَكٌ بِرِن شَ عَ كٌلٌن نَ بْشِ بَرَ قِندِ ﭑ مَ مِشِ رَفَتَدٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عٍقٍرٌن شِتِكَ نُ تِشِ نَا حَمَ تَفِ. عَ نَشَ عِبُرَهِمَ يَابِ عَ شُي عِتٍشِ رَ، عَلَكٌ شِتِكَ نَشٍيٍ بِرِن نُ مَلَنشِ تَا سٌدٍ دّ رَ، عٍ شَ نْ عَ شَ وْيّنيِ رَ مّدٍ. ");
INSERT INTO susa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","عَ نَشّ، «ﭑ بَبَ، ﭑ بَرَ عِ مَشَندِ، عِ تُلِ مَتِ ﭑ نَ. ﭑ بَرَ نَ شّ نُن نَ قْنمّ قِ عِ مَ ﭑ بْنسْي يَ شْرِ. عِ شَ عِ شَ فِنّ رَفَتَ مّننِ.» ");
INSERT INTO susa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","عِبُرَهِمَ مَن نَشَ عَ عِفٌرٌ بْشِ مَ حَمَ بِرِن يَ شْرِ، ");
INSERT INTO susa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","عَ عَ قَلَ عٍقٍرٌن بّ، «عِ شَ عِ هَاكّ تٌ ﭑ بّ. عِ شَ شّ مَسُندِ نَن يَ. يَندِ، عَ رَ سُشُ، عَلَكٌ ﭑ شَ نْ ﭑ مَ فِنّ رَفَتَدٍ مّننِ.» ");
INSERT INTO susa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","عٍقٍرٌن نَشَ عَ يَابِ، ");
INSERT INTO susa_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«ﭑ بَبَ، عِ تُلِ مَتِ ﭑ نَ عَ قَنيِ رَ. بْشِ نَشَن سَرٍ لَنمَ فبٍتِ كِلٌ نَانِ نُن عَ تَفِ، سٍسٍ مُ نَ كِ عِ تَن نُن ﭑ تَن تَفِ. عِ شَ فِنّ رَفَتَ نَا تُن!» ");
INSERT INTO susa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","عِبُرَهِمَ نَشَ تِن نَ سَرٍ رَ شِتِكَيٍ يَ شْرِ. عَ نَشَ فبٍتِ كِلٌ نَانِ نُن عَ تَفِ مَنِيَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","نَ شّ نَشَن نَ مَكِثٍلَ قّ مَ، مَمِرٍ سٌفٍتٍدٍ بِرِ، قْنمّ نَشَن نَ عَ نُن وُرِ بِلِ نَشَن بِرِن سِشِ نَ نَانِنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","نَ بِرِن نَشَ قِندِ عِبُرَهِمَ فبٍ رَ. نَ شِتِكَ نَشٍيٍ بِرِن نُ مَلَنشِ تَا سٌدٍ دّ رَ، عٍ بِرِن قِندِشِ نَ قٍ سٍيدٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","نَ بِرِن دَنفِ شَنبِ، عِبُرَهِمَ نَشَ عَ شَ فِنّ سَرَ رَفَتَ نَ قْنمّ كُي مَكِثٍلَ شّ قّ مَ، نَشَن نَ مَمِرٍ يَتَفِ هٍبِرٌن مَبِرِ كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","نَ شّ نُن نَ قْنمّ نَشَ بَ شِتِكَيٍ فبٍحَ، عَ قِندِ عِبُرَهِمَ فبٍ رَ، عَلَكٌ عَ شَ نْ عَ شَ مِشِيٍ رَفَتَدٍ مّننِ. ");
INSERT INTO susa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","نَ وَشَتِ عِبُرَهِمَ نُ بَرَ فّ قٌرِدٍ. عَلَتَلَ نُ بَرَ بَرَكّ سَ عِبُرَهِمَ شَ قٍ بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","عِبُرَهِمَ نَشَ عَ مَسٍن عَ شَ وَلِكّيٍ شُنيِ بّ، نَشَن عَ حّنفِ سَشِ عَ هَرِفٍ بِرِن شْن مَ، «عِ بّلّشّ سَ ﭑ تَبٍ بُن مَ كَلِ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ﭑ قَقٍ عِ رَكَلِدٍ كٌورٍ نُن بْشِ مَرِفِ عَلَتَلَ رَ، عَلَكٌ عِ نَشَ كَنَان فِنّ قٍن ﭑ مَ دِ بّ ﭑ سَبَتِشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","عَ شْلِ ﭑ مَ عِ شَ سِفَ ﭑ بَرِ بْشِ نَن مَ، عِ قَ مّننِ فِنّ ندٍ قٍن ﭑ بْنسْي يَ مَ ﭑ مَ دِ عِسِيَفَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","عَ شَ وَلِكّ نَشَ عَ يَابِ، «شَ عَ سَ لِ نَ فِنّ مُ تِن بِرَدٍ ﭑ قْشْ رَ قَقٍ يِ بْشِ مَ، ﭑ شَ عِ شَ دِ شَنِن عِ شَ بْشِ مَ، عِ كٍلِشِ دّننَشّ؟» ");
INSERT INTO susa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","عِبُرَهِمَ نَشَ عَ يَابِ، «عِ نَشَ ﭑ مَ دِ رَفبِلٍن مّننِ دٍ! ");
INSERT INTO susa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","عَلَتَلَ نَشَن نَ كٌورٍ مَ، نَشَن ﭑ تٌنفٌشِ ﭑ بَرِ مِشِيٍ يَ مَ، نَشَن ﭑ نَكٍلِشِ ﭑ مَ بْشِ مَ، عَ قَ عَ كَلِ عَ يِ بْشِ قِمَ نّ ﭑ بْنسْي مَ، عَ تَن يَتِ قَمَ نّ عَ شَ مَلٍكّ شّيدٍ عِ مَلِقٍ رَ، عَلَكٌ عِ شَ نْ فِنّ تٌنفٌدٍ مّننِ ﭑ مَ دِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","شَ نَ فِنّ مُ قَ سَ تِن بِرَدٍ عِ قْشْ رَ، عِ قَمَ نّ رَتَنفَدٍ ﭑ مَ مَرَكَلِ مَ، عِ نَشَن تٌنفٌشِ ﭑ بّ. كْنْ عِ نَشَ ﭑ مَ دِ شَنِن مّننِ دٍ!» ");
INSERT INTO susa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","نَ وَلِكّ نَشَ عَ بّلّشّ سَ عَ مَرِفِ عِبُرَهِمَ تَبٍ بُن مَ، عَ نَشَ عَ رَكَلِ. ");
INSERT INTO susa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","عَ نَشَ حْشْمّ قُ تٌنفٌ عِبُرَهِمَ شَ حْشْمّ فْورّ يَ مَ، عَ كٌتٍ فبٍفبٍ سَ عٍ قَرِ. عَ نَشَ كٍلِ، عَ سِفَ نَشٌرِ شَ تَا ثَدَن عَرَ مِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","عِبُرَهِمَ شَ وَلِكّ تٌ مّننِ لِ، عَ نَشَ حْشْمّيٍ رَفٌرٌ تَا قَرِ مَ كْلْنيِ ندٍ سّيتِ مَ. نُنمَرٍ تّمُي نَن نُ عَ رَ، فِنّيٍ مِنِمَ يٍ بَدٍ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","عَ نَشَ عَلَ مَشَندِ، «ﭑ مَرِفِ عِبُرَهِمَ مَرِفِ عَلَتَلَ، ﭑ بَرَ عِ مَشَندِ عَلَكٌ ﭑ مَ حّرّ شَ قِندِ ﭑ بّ شُن نَكٍلِ رَ تٌ لْشْي. عِ مَن شَ هِننّ ﭑ مَرِفِ عِبُرَهِمَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","عِ بَرَ ﭑ تٌ ﭑ نَ كْلْنيِ سّيتِ مَ، تَا فِنّ دِ مّيٍ نَ قَقٍ يٍ بَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ﭑ قَمَ نّ فِنّ دِ مّ ندٍ مَشْرِندٍ عَ شَ عَ شَ يٍ بَسٍ سٌ ﭑ يِ رَ، ﭑ شَ يٍ مِن. شَ عَ سَ ﭑ يَابِ، ‹يٍ مِن، ﭑ شَ يٍ سٌ عِ شَ حْشْمّيٍ قَن يِ رَ،› ﭑ قَمَ نّ عَ كٌلٌندٍ نَ تّمُي، عِ نَ فِنّ يَتِ نَن سُفَندِشِ عِ شَ كٌنيِ عِسِيَفَ بّ. نَ تّمُي ﭑ قَمَ عَ كٌلٌندٍ عِ بَرَ هِننّ ﭑ مَرِفِ عِبُرَهِمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","بٍينُن عَ شَ فّ نَ وْيّنيِ رَ، نَ نَن لَن بٍتُوٍلِ شَ دِ فِنّ رٍبٍكَ نَشَ قَ. عِبُرَهِمَ شُنيَ نَشٌرِ شَ مَمَدِ نَن لَنشِ عَ مَ. عَ شَ قّحّ دْشْشِ عَ تُنكِ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","فِنّ دِ مّدِ تٌقَنيِ نَن نُ عَ رَ، نَشَن مُ شّمّ قٍ كٌلٌن. عَ نَشَ فٌرٌ كْلْنيِ يِرٍ، عَ نَشَ عَ يٍ بَسٍ رَقٍ يٍ رَ، عَ مَن نَشَ تٍ. ");
INSERT INTO susa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","عِبُرَهِمَ شَ وَلِكّ نَشَ عَ فِ عَ سَ عَ رَلَن. عَ نَشَ عَ قَلَ عَ بّ، «ﭑ بَرَ عِ مَشَندِ، عَ لُ ﭑ شَ يٍ ندٍ مِن، نَشَن نَ عِ شَ قّحّ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","عَ نَشَ عَ يَابِ، «ﭑ بَ، يٍ مِن.» عَ نَشَ عَ شَ قّحّ رَفٌرٌ عَ تُنكِ قَرِ، عَ يٍ سٌ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","عَ تٌ فّ نَ رَ، عَ نَشَ عَ قَلَ عَ بّ، «ﭑ يٍ بَمَ نّ عِ شَ حْشْمّيٍ قَن بّ، عَلَكٌ عٍ بِرِن شَ يٍ مِن عَ قَنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","مَقُرٍن، عَ نَشَ عَ شَ قّحّ عِبَفَن كُورّ كُي، عَ مَن عَ فِ سِفَقٍ كْلْن دّ رَ عَ شَ يٍ فبّتّ بَ. عَ نَشَ يٍ بَ هَن حْشْمّ بِرِن نَشَ وَ سَ. ");
INSERT INTO susa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","عِبُرَهِمَ شَ وَلِكّ نُ قَ عَ مَحْشُن، «تّمُندٍ عَلَتَلَ بَرَ ﭑ مَ بِيَاسِ سْونّيَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","حْشْمّيٍ تٌ بَرَ فّ يٍ مِندٍ، عِبُرَهِمَ شَ مِشِ نَشَ حْيرَ سٌي شّيمَ دَاشِ سٌ رٍبٍكَ حْي رَ، نَشَن شَ بِنيّ فِرَ مُ سٍننِ لِمَ. عَ مَن نَشَ بّلّشّرَ سٌي قِرِن شّيمَ دَاشِيٍ سٌ عَ بّلّشّ رَ، نَشَن كٍرٍن شَ بِنيّ دَنفِ فِرَ مُ كّمّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","عَ نَشَ فِنّدِ مّدِ مَشْرِن، «ندٍ شَ دِ لَنشِ عِ مَ؟ يَندِ، عَ قَلَ ﭑ بّ، عِ بَبَ نْمَ مُشُ يِفِيَدٍ تٌ كْي رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","رٍبٍكَ نَشَ عَ يَابِ، «بٍتُوٍلِ شَ دِ نَن لَنشِ ﭑ مَ، مِلِكَ نُن نَشٌرِ شَ مَمَدِ.» ");
INSERT INTO susa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","عَ مَن نَشَ عَ قَلَ، «مُشُ شْنيِ سّشّ نُن حٌوفٍ فبٍفبٍ نَ نَ، يِفِيَ قَن نَ نَ وٌ لُمَ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","عِبُرَهِمَ شَ وَلِكّ نَشَ عَ عِفٌرٌ بْشِ مَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","عَ نَشَ عَ قَلَ، «ﭑ مَرِفِ عِبُرَهِمَ مَرِفِ عَلَتَلَ، ﭑ بَرَ عِ تَنتُ. عِ مُ تَفَن هِننّدٍ ﭑ مَرِفِ عِبُرَهِمَ رَ، عِ شَ لَنلَنتٍيَ مُ كَنَ. عَلَتَلَ ﭑ شُن تِشِ ﭑ مَرِفِ عِبُرَهِمَ شَبِلّ نَن شْنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","رٍبٍكَ نَشَ سِفَ عَ فِ رَ عَ نفَ يِرٍ، عَلَكٌ قٍ نَشَن دَنفِشِ، عَ شَ عَ تَفِ رَبَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","رٍبٍكَ تَارَ لَبَن نَشَ عَ شُلُن سِفَقٍ رَ كْلْن يِرٍ، عِبُرَهِمَ شَ وَلِكّ نُ تِشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","لَبَن نُ بَرَ عَ مَافِنّ تٌ، حْيرَ سٌي عَ حْي رَ، بّلّشّرَ سٌي عَ بّلّشّ رَ. عَ مَن نُ بَرَ عَ شَ دّنتّفّ مّ، شّمّ نَشَن قَلَشِ عَ بّ. نَ كُي، عَ نَشَ سِفَ نَ شّمّ رَلَندٍ كْلْنيِ قّ مَ، حْشْمّيٍ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","لَبَن نَشَ عَ قَلَ عَ بّ، «عَلَتَلَ بَرَ بَرَكَ سَ عِ تَن نَشَن مَ قٍ، عِ تِشِ بٍ مُنقٍ رَ، دّننَشّ مَكُيَ تَا رَ؟ عِ شَ سٌ ﭑ شْنيِ. ﭑ بَرَ بَنشِ يَءِلَن عِ يِفِيَ رَ، ﭑ بَرَ يِرٍ رَقَلَ عِ شَ حْشْمّيٍ لُمَ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","عِبُرَهِمَ شَ وَلِكّ نَشَ سٌ لَبَن شْنيِ. لَبَن نَشَ حْشْمّيٍ شَ كٌتٍ رَفٌرٌ، عَ قَ دٌنسٍ سٌ عٍ يِ رَ، عَ يِرٍ يَءِلَن عٍ بّ. عَ نَشَ يٍ قَن سٌ عِبُرَهِمَ شَ مِشِيٍ يِ رَ، عَلَكٌ عٍ شَ عٍ سَنيِيٍ مَشَ. ");
INSERT INTO susa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","لَبَن تٌ قَ دٌنسٍ رَ عٍ بّ، عِبُرَهِمَ شَ وَلِكّ نَشَ عَ قَلَ، «ﭑ مُ ﭑ دّفٍمَ سِندٍن، قٌ ﭑ شَ ﭑ دّنتّفّ وٌ بّ.» لَبَن نَشَ عَ قَلَ عَ بّ، «عَوَ يِرٍ، دّنتّفّ سَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","عِبُرَهِمَ شَ وَلِكّ نَشَ عَ مَسٍن، «ﭑ تَن نَن نَ عِبُرَهِمَ شَ وَلِكّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","عَلَتَلَ بَرَ بَرَكّ سَ ﭑ مَرِفِ عِبُرَهِمَ شَ قٍ كِ قَنيِ. عَ بَرَ قِندِ بَننَ رَ، بَرِ مَ عَلَتَلَ بَرَ شُرُ سٍ مْولِ بِرِن قِ عَ مَ، عَ نُن فبٍتِ، شّيمَ، كٌنيِيٍ، حْشْمّيٍ، نُن سٌقَلٍيٍ. عَلَتَلَ بَرَ نَ بِرِن قِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ﭑ مَرِفِ عِبُرَهِمَ شَ فِنّ سَرَ بَرَ دِ قَن بَرِ عَ بّ عَ شَ قٌرِحَ كُي. عِبُرَهِمَ عَ هَرِفٍ بِرِن قِشِ نَ دِ نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","«عِبُرَهِمَ ﭑ نَكَلِشِ نّ، ‹عِ نَشَ فِنّ تٌنفٌ ﭑ مَ دِ بّ نَشَن قِندِ كَنَانكَ رَ ﭑ سَبَتِشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","عِ شَ سِفَ ﭑ بَبَ بَرِبٌورٍ يِرٍ ﭑ شَبِلّ تَفِ، عَلَكٌ عِ شَ فِنّ تٌنفٌ ﭑ مَ دِ بّ مّننِ.› ");
INSERT INTO susa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ﭑ مَرِفِ تٌ نَ قَلَ ﭑ بّ، ﭑ نَشَ عَ مَشْرِن، ‹شَ نَ فِنّ قَ تٌندِ بِرَدٍ ﭑ قْشْ رَ فٌ؟› ");
INSERT INTO susa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","عَ نَشَ ﭑ يَابِ، ‹ﭑ حّرّ مَ عَلَتَلَ نَشَن يَ عِ، عَ قَمَ عَ شَ مَلٍكّ بِرَدٍ عِ قْشْ رَ عِ شَ حّرّ كُي عَلَكٌ عَ شَ سْونّيَ. عِ قَمَ نّ فِنّ تٌنفٌدٍ ﭑ مَ دِ بّ ﭑ شَبِلّ تَفِ ﭑ بَبَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","عِ نَ سِفَ ﭑ شَبِلّ رَ، شَ عٍ مُ قَ سَ فِنّ دِ مّدِ سٌ عِ يِ رَ قٍوٌ، عِ بَرَ رَتَنفَ ﭑ مَ مَرَكَلِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«ﭑ تٌ كْلْن يِرٍ لِ، ﭑ نَشَ عَلَ مَشَندِ، ‹عَلَتَلَ، ﭑ مَرِفِ عِبُرَهِمَ نَشَن بَتُمَ، ﭑ بَرَ عِ مَيَندِ عِ شَ ﭑ مَ بِيَاسِ سْونّيَ. ");
INSERT INTO susa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","عِ يَ تِ ﭑ نَ يِ كْلْنيِ سّيتِ مَ. ﭑ قَمَ نّ فِنّ دِ مّدِ ندٍ مَشْرِندٍ نَشَن قَقٍ يٍ بَدٍ، عَ شَ يٍ سٌ ﭑ يِ رَ نَشَن نَ عَ شَ قّحّ كُي عَلَكٌ ﭑ شَ عَ مِن. ");
INSERT INTO susa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","شَ عَ ﭑ يَابِ، «يٍ مِن، ﭑ يٍ بَمَ نّ عِ شَ حْشْمّيٍ قَن بّ، عٍ مِن،» ﭑ عَ كٌلٌنمَ نَ تّمُي، عَلَتَلَ نَ فِنّ دِ مّدِ يَتِ نَن سُفَندِشِ ﭑ مَرِفِ عِبُرَهِمَ شَ دِ بّ.›» ");
INSERT INTO susa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«بٍينُن ﭑ شَ فّ نَ وْيّنيِ رَحْندٍ ﭑ يّتّ مَ، نَ نَن لَن رٍبٍكَ نَشَ قَ، قّحّ دْشْشِ عَ تُنكِ قَرِ. عَ نَشَ فٌرٌ كْلْنيِ رَ، عَ يٍ بَ. ﭑ نَشَ عَ قَلَ عَ بّ، ‹ﭑ بَرَ عِ مَشَندِ، ﭑ كِ يٍ، ﭑ شَ عَ مِن.› ");
INSERT INTO susa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","عَ نَشَ عَ شَ قّحّ رَفٌرٌ مَقُرٍن عَ تُنكِ قَرِ، عَ نَشَ عَ قَلَ ﭑ بّ، ‹يٍ مِن. عِ نَ فّ يٍ مِندٍ ﭑ يٍ سٌمَ نّ عِ شَ حْشْمّيٍ قَن يِ رَ.› ");
INSERT INTO susa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ﭑ نَشَ عَ مَشْرِن، ‹ندٍ شَ دِ نَ عِ رَ؟› عَ نَشَ ﭑ يَابِ، ‹بٍتُوٍلِ شَ دِ فِنّ نَن ﭑ نَ، نَشٌرِ نُن مِلِكَ شَ مَمَدِ.› نَ كُي ﭑ نَشَ شّيمَ سٌ عَ حْي رَ، ﭑ نَشَ شّيمَ بّلّشّرَ سٌي سٌ عَ بّلّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ﭑ نَشَ ﭑ عِفٌرٌ بْشِ مَ عَلَتَلَ بّ. ﭑ نَشَ ﭑ مَرِفِ عِبُرَهِمَ مَرِفِ عَلَتَلَ تَنتُ، بَرِ مَ عَ بَرَ ﭑ شُن تِ ﭑ مَرِفِ شُنيَ شَ دِ فِنّمَ رَ، ﭑ شَ عَ قُتِ عَ شَ دِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","يَكْسِ، لَبَن، عَ قَلَ ﭑ بّ شَ عِ بَرَ تِن قٍ قَنيِ نُن قٍ تِنشِنشِ رَبَقٍ ﭑ مَرِفِ بّ. شَ نَ مُ عَ رَ ﭑ سِفَمَ نّ يِرٍ فبّتّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لَبَن نُن بٍتُوٍلِ نَشَ عَ يَابِ، «عَلَتَلَ نَن يِ قٍ رَفِرِشِ. مُشُ مُ قَمَ نَ مَشْرْشْدٍ. ");
INSERT INTO susa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","رٍبٍكَ نَن تِشِ عِ يَ عِ يِ كِ. عَ شَنِن عِ شُن مَ، عَلَكٌ عَ شَ قِندِ عِ مَرِفِ شَ دِ شَ فِنّ رَ، عَلْ عَلَتَلَ عَ مَسٍنشِ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","عِبُرَهِمَ شَ وَلِكّ تٌ نَ وْيّنيِ مّ، عَ نَشَ عَ عِفٌرٌ بْشِ مَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","نَ شَنبِ، عَ نَشَ بُنسٍ فبٍتِ دَاشِ، بُنسٍ شّيمَ دَاشِ، عَ نُن دُفِيٍ قِ رٍبٍكَ مَ. عَ نَشَ سَنبّ قَنيِيٍ قِ رٍبٍكَ نفَ نُن عَ تَارَ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","نَ دَنفِ شَنبِ، عِبُرَهِمَ شَ وَلِكّ نُن عَ شَ مِشِيٍ نَشَ عٍ دّفٍ، عٍ مِن، عٍ قَ سٌ عٍ سَدٍ. عٍ تٌ كٍلِ فّيسّفّ، عِبُرَهِمَ شَ وَلِكّ نَشَ عَ مَسٍن رٍبٍكَ نفَ نُن عَ تَارَ بّ، «وٌ عَ لُ قَ ﭑ شَ فبِلٍن ﭑ مَرِفِ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","عٍ نَشَ عَ قَلَ، «رٍبٍكَ شَ شِ قُ حْندْن نَبَ بٍ سِندٍن، نَ تّمُي وٌ قَ سِفَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","عِبُرَهِمَ شَ وَلِكّ نَشَ عٍ يَابِ، «وٌ نَشَ ﭑ مَكَنكَن بٍ. عَلَتَلَ بَرَ ﭑ مَ بِيَاسِ سْونّيَ. وٌ عَ لُ قَ ﭑ شَ فبِلٍن ﭑ مَرِفِ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","عٍ نَشَ عَ قَلَ، «وٌن شَ رٍبٍكَ شِلِ، وٌن شَ عَ كٌلٌن حَنِفٍ نَشَن نَ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","عٍ نَشَ رٍبٍكَ شِلِ، عٍ نَشَ عَ مَشْرِن، «عِ وَ مَ سِفَقٍ وٌ نُن يِ شّمّ رَ؟» رٍبٍكَ نَشَ عٍ يَابِ، «عِيٌ، ﭑ وَ مَ سِفَقٍ.» ");
INSERT INTO susa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","نَ كُي عٍ نَشَ عٍ شُنيَ رٍبٍكَ نُن عَ مّينِمَ سٌ عِبُرَهِمَ شَ وَلِكّ نُن عَ شَ مِشِيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","عٍ نَشَ دُبَ رٍبٍكَ بّ عَ قَلَقٍ رَ، «مُشُ شُنيَ نَن لَنشِ عِ مَ. عَلَ شَ عِ قِندِ حَمَ فبٍفبٍ بَرِ مَ رَ. عِ بْنسْي شَ نْ عِ يَشُييٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","رٍبٍكَ نُن عَ شَ فِنّيٍ نَشَ دْشْ حْشْمّيٍ قَرِ، عٍ نَشَ بِرَ عِبُرَهِمَ شَ وَلِكّ قْشْ رَ. عٍ بِرِن نَشَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","عِسِيَفَ نُ بَرَ كٍلِ كْلْن يِرٍ نَشَن شِلِ «عَلَ حِحّ نَشَن ﭑ تٌشِ.» عَ نُ بَرَ سَبَتِ نٍفٍوِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","لْشْي ندٍ، عِسِيَفَ تٌ مِنِ عَ مَحّرّدٍ دَاشَ نُنمَرٍ تّمُي، عَ نَشَ عِبُرَهِمَ شَ وَلِكّ شَ حْشْمّيٍ تٌ قَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","رٍبٍكَ تٌ بَرَ عِسِيَفَ تٌ، عَ نَشَ فٌرٌ حْشْمّيٍ قَرِ، ");
INSERT INTO susa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","عَ قَ وَلِكّ مَشْرِن، «ندٍ نَ نَ شّمّ رَ نَشَن سَ قَقٍ نَ كِ، كٍلِ دَاشَ لٌنفٌرِ رَ وٌن نَلَندٍ؟» ");
INSERT INTO susa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","عِبُرَهِمَ شَ وَلِكّ نَشَ عَ يَابِ، «ﭑ مَرِفِ نَن عَ رَ.» نَ نَن لَن، رٍبٍكَ نَشَ عَ يَ مَكٌتٌ عَ شَ مَقٍلٍنيِ رَ. عِبُرَهِمَ شَ وَلِكّ نَشَ دّنتّفّ سَ عِسِيَفَ بّ، عَ قٍ نَشَن بِرِن نَدَنفِشِ. ");
INSERT INTO susa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","نَ شَنبِ، عِسِيَفَ نَشَ رٍبٍكَ شَنِن عَ نفَ شَ كِرِ بَنشِ كُي، عَ عَ قِندِ عَ شَ فِنّ رَ. عِسِيَفَ نَشَ عَ شَنُ عَ بْحّ بِرِن نَ، هَن عَ نفَ شَ قَشّ سُننُنيِ نَشَ بَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","عِبُرَهِمَ مَن نَشَ فِنّ فبّتّ دْشْ نَشَن شِلِ كٍتُرَ. ");
INSERT INTO susa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","نَ فِنّ نَشَ دِيٍ بَرِ عَ بّ. نَ دِيٍ نُ شِلِ؛ سِمِرَن، يٌكٌسَن، مٍدَن، مَدِيَن، يِسٍبَكِ، نُن سُوَ. ");
INSERT INTO susa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","يٌكٌسَن نَشَ سٍيبَ نُن دٍدَن بَرِ. دٍدَن بْنسْي قِندِ عَسُرِكَيٍ، لٍتُسِكَيٍ، نُن لٍيُمِكَيٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","مَدِيَن شَ دِيٍ لَنشِ عٍقَ، عٍقٍرٍ، هَنٌكِ، عَبِدَ، نُن عٍلِدَا نَن مَ. كٍتُرَ شَ دِيٍ نَن لَنشِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","عِبُرَهِمَ نَشَ عَ هَرِفٍ بِرِن قِ عِسِيَفَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","عَ نَشَ سٍ فبٍفبٍ قَن قِ عَ شَ فِنّ بٌورٍيٍ شَ دِيٍ مَ، عَ قَ عٍ مَكُيَ عَ شَ دِ عِسِيَفَ رَ، عَ عٍ رَ سِفَ بْشِ ندٍ مَ نَشَن نَ سٌفٍتٍدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","عِبُرَهِمَ شَ سِمَيَ نَشَ سِفَ هَن حّ كّمّ حّ تٌنفٌ سٌلٌقٍرٍ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","نَ شَنبِ، عَ نَشَ قَشَ هّيرِ كُي، عَ عَ بٍنبَيٍ لِ عَلِفِيَمَ. ");
INSERT INTO susa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","عَ شَ دِيٍ عِسِيَفَ نُن سُمَيِلَ نَشَ عَ رَفَتَ مَكِثٍلَ قْنمّ كُي، سٌشَرَ شِتِكَ شَ دِ عٍقٍرٌن شَ بْشِ مَ مَمِرٍ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","عِبُرَهِمَ نَ بْشِ سَرَ شِتِكَيٍ بْنسْي نَن مَ. عٍ نُن عَ شَ فِنّ سَرَ، عٍ بِرِن نَفَتَشِ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","عِبُرَهِمَ قَشَ شَنبِ، عَلَ نَشَ بَرَكّ سَ عَ شَ دِ عِسِيَفَ مَ. عَ نُ سَبَتِشِ كْلْنيِ قّ مَ، نَشَن شِلِ «عَلَ حِحّ نَشَن ﭑ تٌشِ.» ");
INSERT INTO susa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","شِلِيٍ نَن يَ نَشٍيٍ قِندِ سُمَيِلَ بْنسْي رَ. سَرَ نُ بَرَ عَ شَ كٌنيِ فِنّ مِسِرَكَ هَفَرَ قِ عِبُرَهِمَ مَ. هَفَرَ نَشَ سُمَيِلَ سْتْ دِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","سُمَيِلَ شَ دِيٍ نَن يَ، عٍ بَرِشِ كِ نَشّ عٍ بٌورٍ قْشْ رَ؛ نٍبَيٌتِ، سُمَيِلَ شَ دِ سِنفٍ، كٍدَرِ، عَدَبٍيلِ، مِبِسَمِ، ");
INSERT INTO susa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مِسِمَ، دُ مَ، مَسَ، ");
INSERT INTO susa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","هَدَدَ، تٍمَ، يٍتُرِ، نَقِسِ، نُن كٍدٍ مَ. نَ دِ قُ نُن قِرِنيِ قِندِ سُمَيِلَ شَ دِيٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","نَ مِشِ كٍرٍن كٍرٍن مَ قِندِ بْشِ مَنفّيٍ نَن نَ. عٍ نَشَ عٍ شِلِيٍ سَ عٍ شَ تَايٍ شُن مَ عَ نُن عٍ شَ مِشِيٍ. ");
INSERT INTO susa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","سُمَيِلَ شَ سِمَيَ دَن حّ كّمّ حّ تٌنفٌ سَشَن نُن سٌلٌقٍرٍ نّ. عَ نَشَ لَاشِرَ، عَ سَ عَ بٍنبَيٍ لِ عَلِفِيَمَ. ");
INSERT INTO susa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","سُمَيِلَ بْنسْي نُ سَبَتِشِ بْشِ نَن مَ، دّننَشّ نُ نَ هَوِلَ نُن سُرُ تَفِ. سُرُ يَ رَقِندِشِ مِسِرَ نَن مَ عَسُرِ كِرَ رَ. عٍ نُ سَبَتِشِ عٍ نفَشَكٍرٍنيِيٍ نَن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","عِسِيَفَ شَ تَرُشُي نَن يَ؛ عِسِيَفَ قِندِ عِبُرَهِمَ شَ دِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","عَ تٌ بَرَ حّ تٌنفٌ نَانِ سْتْ سِمَيَ رَ، عَ نَشَ رٍبٍكَ دْشْ، لَبَن شُنيَ فِنّمَ، بٍتُوٍلِ شَ دِ فِنّ. عَرَ مِكَيٍ نَن نَ عٍ رَ، كٍلِقٍ ثَدَن عَرَ مِ. ");
INSERT INTO susa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","كْنْ رٍبٍكَ مُ نُ نْمَ دِ بَرِدٍ عِسِيَفَ بّ. عِسِيَفَ نَشَ عَلَتَلَ مَشَندِ عَ شَ فِنّ شَ قٍ رَ عَ شَ نْ دِ بَرِدٍ. عَلَتَلَ نَشَ عَ شَ دُبَ سُشُ، رٍبٍكَ نَشَ تّيفّ. ");
INSERT INTO susa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","نَ دِيٍ نُ قَ فٍرٍ عٍ نفَ تّيفّ. عَ نَشَ عَ يّتّ مَشْرِن، «مُنقٍ رَبَقٍ ﭑ بّ يِ كِ؟» نَ كُي عَ نَشَ سِفَ عَلَتَلَ مَشْرِندٍ. ");
INSERT INTO susa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «سِ دْشْ قِرِن نَن نَ عِ تّيفّ. كٍرٍن سّنبّ فبٌمَ نّ بٌورٍ بّ. تَارَ نَن قَمَ لُدٍ عَ شُنيَ شَ نْي بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","عَ دِ بَرِ تّمُي تٌ عَ لِ، رٍبٍكَ نَشَ فُلِيٍ بَرِ. ");
INSERT INTO susa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","عَ شَ دِ سِنفٍ قِندِشِ مِشِ فبٍيلِ نَن نَ. قَتٍ مَشَبٍ فبٍفبٍ كَنيِ نَن نُ عَ رَ. عٍ نَشَ عَ شِلِ سَ عٍسَيُ. ");
INSERT INTO susa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","نَ شَنبِ عَ شُنيَ قَن نَشَ بَرِ. عَ بّلّشّ رَشُتُشِ عَ تَارَ تِنفِلِنيِ مَ. عٍ نَشَ عَ قَن شِلِ سَ يَشُبَ. عِسِيَفَ نَ دِيٍ بَرِ مَ تّمُي نَشّ، عَ نُ نَ حّ تٌنفٌ سٍننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","نَ دِ شّمّ قِرِنيِ نَشَ مْ. عٍسَيُ نَشَ قِندِ كٌيِنمَ قَنيِ رَ نَشَن نُ وُلَ عِ سَمَ. نَشَن قِندِ يَشُبَ تَن نَ، مِشِ مَشِنبٍلِشِ نَن نُ عَ رَ، عَ تَن نُ دْشْمَ كِرِ بَنشِ نَن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","عٍسَيُ نَن نُ رَقَن عِسِيَفَ مَ، بَرِ مَ عَ نُ قَمَ سُبٍ رَ عَ بّ. يَشُبَ تَن نُ رَقَن رٍبٍكَ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","لْشْي ندٍ يَشُبَ نُ بَرَ سُثِ يَءِلَن. عٍسَيُ نَشَ سٌ، عَ تَفَنشِ كٍلِقٍ كٌيِندٍ. ");
INSERT INTO susa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","عَ نَشَ عَ قَلَ عَ بّ، «ﭑ مُ نْمَ قٍقٍ رَ يِ كِ. عَ لُ ﭑ شَ يِ سُثِ فبٍيلِ ندٍ مِن.» نَ نَن تٌشِ عَ عٍدٌن شِلِ نَشَ سَ عَ شُن مَ، نَ نَن نَ كِ «عَ فبٍيلِ.» ");
INSERT INTO susa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","يَشُبَ نَشَ عَ يَابِ، «عِ شَ قٌرِحَ تِدٍ قِ ﭑ مَ سِندٍن.» ");
INSERT INTO susa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عٍسَيُ نَشَ عَ مَسٍن، «ﭑ نَ قَشَقٍ، كَامّ نَن نَ ﭑ مَ يِ كِ. نَ قٌرِحَ تِدٍ مُنسٍ قَنمَ ﭑ مَ؟» ");
INSERT INTO susa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","يَشُبَ مَن نَشَ عَ قَلَ، «قٌ عِ شَ عِ كَلِ.» عٍسَيُ نَشَ عَ كَلِ عَ عَ بَرَ عَ شَ قٌرِحَ تِدٍ قِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","يَشُبَ نَشَ تَامِ نُن نَ تٌفٍ سُثِ ندٍ سٌ عَ يِ رَ. عٍسَيُ تٌ فّ عَ دّفٍدٍ، عَ عَ مِن، عَ نَشَ سِفَ. عٍسَيُ مُ تِدٍ يٌ تٌشِ عَ شَ قٌرِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","كَامّ نَشَ سٌ بْشِ كُي، بَقٍ كَامّ سِنفٍ رَ نَشَن نَبَ عِبُرَهِمَ شَ وَشَتِ. عِسِيَفَ نَشَ سِفَ قِلِسِتَ مَنفّ عَبِمٍلٍكِ شْنيِ، نَشَن نُ نَ فٍرَرَ. ");
INSERT INTO susa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","عَلَتَلَ نَشَ مِنِ عِسِيَفَ مَ، عَ عَ مَسٍن عَ بّ، «عِ نَشَ سِفَ مِسِرَ بْشِ مَ دٍ. عِ شَ لُ بْشِ مَ ﭑ نَ دّننَشّ مَسٍن عِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","لُ بٍ. وٌن بِرِن نَ عَ رَ. ﭑ بَرَكّ سَمَ نّ عِ شَ قٍ، بَرِ مَ ﭑ قَمَ يِ بْشِ قِدٍ عِ تَن نُن عِ بْنسْييٍ نَن مَ. ﭑ لَايِدِ نَشَن تٌنفٌ عِ بَبَ عِبُرَهِمَ بّ، ﭑ نَ رَكَمَلِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ﭑ عِ بْنسْي رَوُيَمَ نّ عَلْ تُنبُي نَشٍيٍ نَ كٌورٍ مَ. ﭑ يِ بْشِ قِمَ نّ عِ بْنسْي مَ. ﭑ بَرَكّ سَمَ نّ دُنِحَ سِ بِرِن مَ عِ بْنسْي سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","عِبُرَهِمَ ﭑ شُي رَ مّ نّ. عَ نَشَ عَ حّنفِ سَ ﭑ مَ سّرِيّ، ﭑ مَ مَنفّيَ، ﭑ مَ يَامَرِيٍ، نُن ﭑ مَ تْنيِيٍ شْن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","نَ كُي عِسِيَفَ نَشَ سَبَتِ فٍرَرَ. ");
INSERT INTO susa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","مِشِ نَشٍيٍ دْشْشِ مّننِ، نٍيٍ نَشَ عَ مَشْرِن عَ شَ فِنّ شَ قٍ مَ. عَ نَشَ عٍ يَابِ، عَ عَ شُنيَ فِنّمَ نَن لَنشِ عَ مَ. عَ مُ سُو سَ عَ قَلَدٍ عٍ بّ، عَ شَ فِنّ نَن لَنشِ رٍبٍكَ مَ عَلَكٌ مّننِ مِشِيٍ نَشَ قَ عَ قَشَ. عَ بَرَ فَاشُ عَ قَلَدٍ عَ شَ فِنّ نَ عَ رَ بَرِ مَ رٍبٍكَ فِنّ تٌقَنيِ نَن نُ لَنشِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","عِسِيَفَ تٌ بَرَ بُ نَا، لْشْي ندٍ قِلِسِتَكَيٍ شَ مَنفّ عَبِمٍلٍكِ نَشَ عَ يَ رَ مِنِ وُندّرِ رَ، عَ نَشَ عَ تٌ عِسِيَفَ نَ رٍبٍكَ مَقُرُكُقٍ. ");
INSERT INTO susa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","عَبِمٍلٍكِ نَشَ عَ شِلِ عَ شْنيِ. عَ نَشَ عَ قَلَ عَ بّ، «عِ شَ فِنّ يَتِ نَن لَنشِ يِ مَ! مُنقٍ رَ عِ قَ عَ قَلَ مُشُ بّ عِ شُنيَ فِنّمَ نَن عَ رَ؟» عِسِيَفَ نَشَ عَ يَابِ، «ﭑ نُ فَاشُشِ نّ وٌ نَشَ قَ ﭑ قَشَ. نَ نَن عَ تٌ ﭑ نَشَ نَ قَلَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","عَبِمٍلٍكِ مَن نَشَ عَ مَشْرِن، «عِ مُنسٍ رَبَشِ مُشُ رَ يِ كِ؟ شَ مِشِ ندٍ قَ مِنِ ﭑ مَ حَمَ يَ مَ فٌ، عَ نَشَ عِ شَ فِنّ قِندِ عَ يّتّ رَ؟ نَ تّمُي عِ بَرَ مُشُ رَتَنتَن.» ");
INSERT INTO susa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","عَبِمٍلٍكِ نَشَ يَامَرِ قِ عَ شَ حَمَ بِرِن مَ، «مِشِ يٌ نَ دِن يِ شّمّ نُن عَ شَ فِنّ رَ، ﭑ نَ كَنيِ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","نَ حّ رَ، عِسِيَفَ نَشَ شّ سَ نَ بْشِ مَ. عَ تٌ نَ شّ شَبَ، عَ نَشَ عَ شَ سَنسِ وٌلِشِ حْندْن كّمّ سْتْ، بَرِ مَ عَلَتَلَ بَرَ بَرَكّ سَ عَ شَ قٍ. ");
INSERT INTO susa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","عَ هَرِفٍ شُن نَشَ مَسَ، عَ قِندِ بَننَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","يّشّي، سِ، نِنفٍ، نُن كٌنيِ فبٍفبٍ نُ نَ عَ يِ رَ. نَ كُي قِلِسِتَكَيٍ نَشَ عِسِيَفَ تْونّ. ");
INSERT INTO susa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","قِلِسِتَكَيٍ نَشَ كْلْنيِ بِرِن نَقٍ بّندّ رَ، عِسِيَفَ بَبَ عِبُرَهِمَ شَ كٌنيِ نَشٍيٍ فٍ عِبُرَهِمَ شَ وَشَتِ. ");
INSERT INTO susa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","عَبِمٍلٍكِ نَشَ عَ قَلَ عِسِيَفَ بّ، «قٌ عِ شَ كٍلِ بٍ. عِ بَرَ سّنبّ سْتْ دَنفِ مُشُ تَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","عِسِيَفَ نَشَ كٍلِ نَا، عَ سَ سَبَتِ فٍرَرَ فُلُنبَ كُي. ");
INSERT INTO susa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","عِسِيَفَ نَشَ كْلْنيِيٍ عِبَ، نَشٍيٍ نُ فٍشِ عَ بَبَ وَشَتِ، قِلِسِتَكَيٍ نَشٍيٍ دّ سّ عِبُرَهِمَ قَشَ شَنبِ. عَ بَبَ نُ نَ كْلْنيِيٍ شِلِ قَلَمَ كِ نَشّ، عِسِيَفَ مَن نَشَ نَ شِلِيٍ قَلَ عٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","عِسِيَفَ شَ كٌنيِيٍ مَن نَشَ كْلْنيِ فبّتّ فٍ نَ فُلُنبَ يِرٍ، دُلٌنيِ قَ مِنِ عَ كُي. ");
INSERT INTO susa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","فٍرَرَ شَ شُرُ سٍ دّ مَدٌنيِيٍ نُن عِسِيَفَ شَ شُرُ سٍ دّ مَدٌنيِيٍ نَشَ كْنحّ نَ كْلْنيِ شَ قٍ رَ. عٍ بِرِن نُ قَ عَ قَلَ عٍ بٌورٍ بّ، «مُشُ تَن نَن فبٍ نَ نَ كْلْنيِ رَ.» عِسِيَفَ نَشَ نَ كْلْنيِ شِلِ قَلَ «سْنشْي،» بَرِ مَ سْنشْي بَرَ بِرَ عَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","عَ شَ كٌنيِيٍ مَن نَشَ كْلْنيِ فبّتّ فٍ، سْنشْي مَن نَشَ بِرَ نَ قَن شَ قٍ رَ. عَ نَشَ عَ شِلِ قَلَ سِتِنَ، نَ نَن نَ كِ «فَلَنبُي كْلْنيِ.» ");
INSERT INTO susa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","عِسِيَفَ نَشَ كٍلِ نَا، عَ سَ كْلْنيِ فٍ يِرٍ فبّتّ. نَ كْلْنيِ تٌ فٍ، سْنشْي مُ بِرَ نَ تَن شَ قٍ رَ. عَ نَشَ عَ شِلِ قَلَ رٍهٌبٌتِ كْلْنيِ، نَ نَن نَ كِ «مَكُيٍ كْلْنيِ،» بَرِ مَ عَ نَشّ، «عَلَتَلَ بَرَ وٌن مَكُيَ بٍكَيٍ رَ عَلَكٌ وٌن مَ قٍ شَ سْونّيَ يِ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","عِسِيَفَ تٌ كٍلِ مّننِ سِفَقٍ رَ بٍرِ سٍيبَ، ");
INSERT INTO susa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","عَلَتَلَ نَشَ مِنِ عَ مَ كْي رَ. عَ نَشَ عَ مَسٍن عَ بّ، «عِ بَبَ عِبُرَهِمَ مَرِفِ عَلَ لَنشِ ﭑ تَن نَن مَ. عِ نَشَ فَاشُ قٍقٍ رَ، وٌن تَن نَن عَ رَ يِرٍ بِرِن. ﭑ مَن بَرَكّ سَمَ نّ عِ شَ قٍ. ﭑ عِ بْنسْي رَوُيَمَ نّ ﭑ مَ كٌنيِ عِبُرَهِمَ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","عِسِيَفَ نَشَ سّرّشّبَدٍ يَءِلَن نَ يِرٍ، عَ نُ قَ عَلَتَلَ مَشَندِ عَ شِلِ رَ. عَ نَشَ سَبَتِ نَا، عَ شَ كٌنيِيٍ مَن نَشَ كْلْنيِ فبّتّ فٍ. ");
INSERT INTO susa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","عَبِمٍلٍكِ بٌورٍ عَهُسَتِ، نُن عَ شَ سْورِ مَنفّ ثِكٌلِ نَشَ كٍلِ فٍرَرَ، عٍ سِفَ عِسِيَفَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","عِسِيَفَ نَشَ عٍ مَشْرِن، «وٌ قَشِ ﭑ يِرٍ مُنقٍ رَ يِ كِ؟ وٌ بَرَ ﭑ نَحَاشُ هَن وٌ بَرَ ﭑ كٍرِ وٌ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","عٍ نَشَ عَ يَابِ، «مُشُ بَرَ عَ كٌلٌن عَلَتَلَ شَ مِشِ نَن لَنشِ عِ مَ. مُشُ مَن بَرَ عَ مَحْشُن، قٌ وٌن شَ سَاتّ تٌنفٌ وٌن بٌورٍ بّ مَرَكَلِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","عِ رَكَلِ مُشُ بّ، عِ مُ قَمَ قٍ شْنّ رَبَدٍ مُشُ رَ، بَرِ مَ مُشُ قَن مُ قٍ كٌبِ يٌ رَبَشِ عِ رَ، قٌ قٍ قَنيِ. مُشُ مَن نَشَ عِ لُ، عِ شَ سِفَ بْحّسَ كُي. يَكْسِ عَلَتَلَ بَرَ بَرَكّ سَ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","عِسِيَفَ نَشَ دٌنسٍ فبٍفبٍ يَءِلَن عٍ بّ. عٍ بِرِن نَشَ عٍ دّفٍ، عٍ نَشَ عٍ مِن. ");
INSERT INTO susa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","كُيٍ تٌ عِبَ، عٍ نَشَ عٍ رَكَلِ عٍ بٌورٍ بّ. عِسِيَفَ نَشَ عَ حُنفُ عٍ مَ، عٍ نَشَ قَتَن لَنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","نَ لْشْي كٍرٍنيِ، عِسِيَفَ شَ كٌنيِيٍ نَشَ كْلْنيِ ندٍ شَ قٍ دّنتّفّ سَ عَ بّ عٍ نَشَن فٍشِ. عٍ نَشّ، «مُشُ بَرَ يٍ لِ نَ كْلْنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","عِسِيَفَ نَشَ نَ كْلْنيِ شِلِ قَلَ سِبَ كْلْنيِ، نَ نَن قَلَشِ «مَرَكَلِ.» نَ نَن عَ تٌشِ مُشُ يِ تَا شِلِ قَلَمَ هَن يَكْسِ بٍرِ سٍيبَ، نَ نَن قَلَشِ «مَرَكَلِ كْلْنيِ.» ");
INSERT INTO susa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","عٍسَيُ تٌ حّ تٌنفٌ نَانِ رَكَمَلِ، عَ نَشَ بٍيرِ شَ دِ يُدِتَ نُن عٍلٌن شَ دِ بَسَمَتِ دْشْ. نَ قِرِنيِ شِتِكَيٍ نَن نَ عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","عٍ نَشَ عِسِيَفَ نُن رٍبٍكَ بْحّ رَحَاشُ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","عِسِيَفَ نُ بَرَ فّ قٌرِدٍ، عَ يَيٍ نُ بَرَ رَقْورْ. عَ مُ نْمَ سٍسٍ تٌدٍ قَ. عَ نَشَ عَ شَ دِ سِنفٍ عٍسَيُ شِلِ، «ﭑ مَ دِ!» عٍسَيُ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ!» ");
INSERT INTO susa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","عِسِيَفَ نَشَ عَ قَلَ عَ بّ، «عِ بَرَ عَ تٌ، ﭑ بَرَ فّ قٌرِدٍ. ﭑ مُ عَ كٌلٌن ﭑ قَشَمَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","تَنبّ سَسٍ نُن شَلِ تٌنفٌ، عِ شَ سِفَ وُلَءِ سُبٍ قٍندٍ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","عِ شَ نَ سُبٍ حِن عَلْ عَ رَقَنشِ ﭑ مَ كِ نَشّ. عِ شَ قَ عَ رَ ﭑ شْن مَ، عَلَكٌ ﭑ شَ نْ دُبَدٍ عِ بّ بٍينُ ﭑ شَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","نَ تّمُي رٍبٍكَ تِشِ عَ تُلِ مَتِشِ عِسِيَفَ رَ، عَ نَشَن قَلَشِ عٍسَيُ بّ. عٍسَيُ نَشَ سِفَ وُلَءِ سُبٍ بُندٍ عَ بَبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","رٍبٍكَ نَشَ عَ قَلَ عَ شَ دِ يَشُبَ بّ، «ﭑ بَرَ عِ بَبَ شُي مّ عَ يِ وْيّنيِ قَلَمَ عٍسَيُ بّ، ");
INSERT INTO susa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹سَ سُبٍ بُن ﭑ بّ، عِ شَ عَ حِن عَ قَنيِ رَ، ﭑ شَ عَ دٌن. ﭑ نَ فّ نَ سُبٍ دٌندٍ، ﭑ دُبَمَ عِ بّ عَلَتَلَ يَ عِ بٍينُن ﭑ شَ قَشَ.› ");
INSERT INTO susa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","يَكْسِ، ﭑ مَ دِ، عِ تُلِ مَتِ ﭑ نَ عَ قَنيِ رَ. ﭑ نَشَن قَلَمَ عِ بّ، عِ شَ عَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","سِفَ فْورّ، عِ شَ قَ سِ قَنيِ قِرِن نَ. ﭑ شَ عٍ حِن عَ قَنيِ رَ عَلْ عِ بَبَ وَ مَ عَ شْن مَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ﭑ نَ فّ نَ رَ، عِ شَ عَ شَنِن عِ بَبَ شْن مَ، عَلَكٌ عَ شَ دُبَ عِ بّ بٍينُن عَ شَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","يَشُبَ نَشَ عَ نفَ رٍبٍكَ يَابِ، «عٍسَيُ قَتٍ مَشَبٍ كَنيِ نَن عَ رَ. ﭑ تَن قَتٍ مَشَبٍ مُ نَ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ﭑ بَبَ نَ ﭑ مَسُشُ، عَ كٌلٌنمَ نّ عٍسَيُ شَ مُ عَ رَ، ﭑ قِندِ مَ وُلٍ قَلّ نَن نَ عَ تَن بّ. بٍينُن ﭑ شَ دُبَ سْتْ، ﭑ قَمَ دَنكّ نَن سْتْدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","عَ نفَ نَشَ عَ قَلَ، «عَدٍ، نَ دَنكّ شَ فبِلٍن ﭑ تَن نَن مَ، ﭑ مَ دِ. عِ نَشَن نَبَمَ، عِ تُلِ مَتِ ﭑ نَ. سِفَ، عِ سَ قَ نَ سِ قَنيِ قِرِنيِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","يَشُبَ نَشَ سِفَ، عَ نَشَ قَ سِ قَنيِ قِرِنيِيٍ رَ عَ نفَ شْن مَ. عَ نفَ نَشَ نَ دٌنسٍ يَءِلَن عَلْ عَ رَقَنشِ عِسِيَفَ مَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","نَ شَنبِ، رٍبٍكَ نَشَ عَ شَ دِ سِنفٍ عٍسَيُ شَ دٌنمَ تٌنفٌ، دٌنمَ نَشَن قَن عَ شَ دُفِيٍ يَ مَ بَنشِ كُي. عَ نَشَ نَ رَفٌرٌ يَشُبَ مَ، عَ شَ دِ قِرِن ندٍ. ");
INSERT INTO susa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","عَ نَشَ عَ شَ دِ بّلّشّيٍ نُن عَ كْنيِ مَسَلَشُنشِ مَشِرِ سِ كِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","عَ نَشَ سُبٍ نُن تَامِ سٌ عَ شَ دِ يَشُبَ يِ رَ، عَ نَشَن يَءِلَنشِ. ");
INSERT INTO susa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","نَ تّمُي يَشُبَ نَشَ سِفَ عَ بَبَ يِرٍ، عَ عَ قَلَ عَ بّ، «ﭑ بَبَ، ﭑ تَن نَن يَ.» عَ بَبَ نَشَ عَ مَشْرِن، «ﭑ مَ دِ مُندُن لَنشِ عِ تَن مَ؟» ");
INSERT INTO susa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","يَشُبَ نَشَ عَ بَبَ يَابِ، «عٍسَيُ نَن لَنشِ ﭑ مَ، عِ شَ دِ سِنفٍ. عِ نَشَن مَشْرِنشِ ﭑ مَ، ﭑ بَرَ قَ عَ رَ. يَندِ، كٍلِ، عِ دْشْ، عِ شَ ﭑ مَ سُبٍ يَءِلَنشِ دٌن. نَ تّمُي عِ شَ دُبَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","عِسِيَفَ نَشَ عَ قَلَ عَ شَ دِ بّ، «ﭑ مَ دِ، عِ يِ سُبٍ تٌشِ يِ عِكْرّشِ رَ دِ؟» يَشُبَ نَشَ عَ يَابِ، «عِ مَرِفِ عَلَتَلَ نَن يِ قِشِ ﭑ مَ سْونّيَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","عِسِيَفَ نَشَ عَ قَلَ يَشُبَ بّ، «ﭑ مَ دِ، عِ مَسٌ ﭑ نَ، ﭑ شَ عِ مَسُشُ، عَلَكٌ ﭑ شَ لَ عَ رَ عَ ﭑ مَ دِ عٍسَيُ يَتِ نَن عِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","يَشُبَ نَشَ عَ مَسٌ عَ بَبَ رَ. عِسِيَفَ نَشَ عَ قَتٍ مَسُشُ. عَ نَشَ عَ قَلَ، «عِ شُي مَنِيَ يَشُبَ شُي رَ، كْنْ عِ بّلّشّ تَن عٍسَيُ بّلّشّ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","عِسِيَفَ مُ نْ يَشُبَ كٌلٌندٍ، بَرِ مَ عَ بّلّشّيٍ نُ مَشِرِشِ شَبٍ رَ، عَلْ عَ تَارَ عٍسَيُ نَ كِ نَشّ. نَ كُي عِسِيَفَ نَشَ دُبَ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","عِسِيَفَ مَن نَشَ عَ مَشْرِن، «ﭑ مَ دِ عٍسَيُ يَتِ نَن عِ رَ؟» يَشُبَ نَشَ عَ يَابِ، «عِيٌ.» ");
INSERT INTO susa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","عِسِيَفَ نَشَ عَ قَلَ، «قَ دٌنسٍ رَ، عِ نَشَن يَءِلَنشِ، ﭑ شَ عَ دٌن، ﭑ قَ دُبَ عِ بّ.» يَشُبَ نَشَ دٌنسٍ سٌ عَ بَبَ يِ رَ، عِسِيَفَ نَشَ عَ دٌن. يَشُبَ نَشَ وّنِ قَن سٌ عَ يِ رَ، عَ نَشَ نَ قَن مِن. ");
INSERT INTO susa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","نَ تّمُي، عَ بَبَ عِسِيَفَ نَشَ عَ قَلَ عَ بّ، «ﭑ مَ دِ، عِ مَكْرّ ﭑ نَ، عِ شَ قِندِفِلِن ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","يَشُبَ نَشَ عَ مَسٌ عَ رَ، عَ نَشَ قِندِفِلِن عَ مَ. عِسِيَفَ نَشَ عَ شَ سٌسٍ شِرِ مّ. نَ دَنفِ شَنبِ، عَ نَشَ دُبَ عَ بّ. عَ نَشَ عَ مَسٍن، «عِيٌ، ﭑ مَ دِ شِرِ لُشِ نّ عَلْ عَلَتَلَ بَرَكّ سَشِ شّ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","عَلَ شَ شِنِ قِ عِ مَ نَشَن كٍلِمَ كٌورٍ مَ. عَلَ شَ بْشِ دَشَمُي قِ عِ مَ. عَلَ شَ بَرَكّ سَ عِ شَ شّ مَ. عَلَ شَ وّنِ فبٍفبٍ قِ عِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","عَلَ شَ حَمَ بِرِن لُ عِ سَفٌي. عَلَ شَ سِ بِرِن مَفٌرٌ عِ بّ. عِ شَ قِندِ عِ نفَشَكٍرٍنيِيٍ شَ يَرٍرَتِ رَ. عٍ بِرِن شَ عٍ مَفٌرٌ عِ بّ. مِشِ يٌ نَ عِ دَنكَ، نَ دَنكّ شَ فبِلٍن عَ كَنيِ مَ. مِشِ يٌ نَ دُبَ عِ بّ، عَلَ شَ بَرَكّ سَ نَ كَنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","عِسِيَفَ تٌ بَرَ فّ دُبَدٍ عَ بّ، يَشُبَ نَشَ مِنِ. عَ مُ بُ، يَشُبَ تَارَ عٍسَيُ قَن نَشَ سٌ كٍلِقٍ سُبٍ قٍندٍ. ");
INSERT INTO susa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","عَ قَن نَشَ نَ سُبٍ يَءِلَن عَ قَنيِ رَ عَلْ عَ بَبَ وَ مَ عَ شْن مَ كِ نَشّ. عَ تٌ قَ عَ رَ عَ بَبَ شْن، عَ نَشَ عَ قَلَ عَ بَبَ بّ، «ﭑ بَبَ، كٍلِ، عِ شَ دْشْ، عِ سُبٍ دٌن ﭑ نَشَن يَءِلَنشِ عِ بّ عَلَكٌ عِ شَ دُبَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","عَ بَبَ عِسِيَفَ نَشَ عَ مَشْرِن، «ندٍ نَ عِ تَن نَ؟» عٍسَيُ نَشَ عَ يَابِ، «عٍسَيُ نَن نَ ﭑ نَ، عِ شَ دِ سِنفٍ.» ");
INSERT INTO susa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","نَ قٍ نَشَ عِسِيَفَ عِقُ عَ قَنيِ رَ. عَ قَتٍ بِرِن نَشَ سّرّن عَ مَ. عَ نَشَ عَ قَلَ عَ بّ، «كْنْ ندٍ تَن قَشِ سُبٍ يَءِلَنشِ رَ ﭑ بّ، ﭑ نَشَن دٌنشِ يَكْسِ بٍينُن عِ تَن شَ سٌ بٍ يِ كِ؟ ﭑ بَرَ دُبَ نَ كَنيِ بّ. عَ تَن نَن قَمَ بَرَكّ سْتْدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","عٍسَيُ تٌ عَ بَبَ شَ مَسٍنيِ مّ، عَ بْحّ نَشَ مِنِ، عَ نَشَ سْنشْي فبٍفبٍ رَتٍ. عَ نَشَ عَ بَبَ مَيَندِ، «ﭑ بَبَ، دُبَ ﭑ قَن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","عِسِيَفَ نَشَ عَ يَابِ، «عِ شُنيَ بَرَ ﭑ مَدَشُ. ﭑ بَرَ فّ دُبَدٍ عَ تَن نَن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","عٍسَيُ نَشَ عَ قَلَ، «عَ شِلِ يَتِ نَ عَ شُن مَ، يَشُبَ، ‹مِشِ مَيَنقّ›. عَ سَنمَيَ قِرِن نَن يَ عَ ﭑ مَيَنقَمَ. عَ بَرَ ﭑ مَ قٌرِحَ تِدٍ تٌنفٌ. يَكْسِ عَ بَرَ ﭑ مَ دُبّ قَن سْتْ.» عٍسَيُ مَن نَشَ عَ مَشْرِن، «دُبّ يٌ مُ نَ عِ يِ رَ سْنْن، عِ لَن عِ شَ نَشَن نَبَ ﭑ تَن بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","عِسِيَفَ نَشَ عَ مَسٍن عٍسَيُ بّ، «ﭑ بَرَ عَ تَن قِندِ عِ شُنيِ رَ، ﭑ مَن بَرَ عَ نفَشَكٍرٍنيِ بِرِن سٌ عَ يِ رَ عٍ شَ لُ عَ بُن مَ. ﭑ بَرَ بَرَكّ فبٍفبٍ قِ عَ مَ، عَ نُن وّنِ قَنيِ. ﭑ مَ دِ، ﭑ نْمَ مُنسٍ رَبَدٍ عِ تَن بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","عٍسَيُ نَشَ عَ قَلَ عَ بَبَ بّ، «دُبّ كٍرٍن ثٍتِ نَن نَ عِ يِ رَ؟ ﭑ بَبَ، دُبَ ﭑ تَن قَن بّ.» عَ نَشَ وَ عَ شُي عِتٍشِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","عَ بَبَ عِسِيَفَ نَشَ عَ يَابِ، «عَ كٌلٌن، عِ مُ قَمَ بْشِ دَشَمُي سْتْدٍ، عَ نُن شِنِ نَشَن كٍلِمَ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","عِ بَلٌمَ عِ شَ سَنتِدّفّمَ نَن شُن نَ. عِ قَمَ وَلِدٍ عِ شُنيَ شَ نْي نَن بُن مَ، كْنْ يَرٍ عِ قَمَ عِ يّتّ سْتْدٍ. عَ نَ نْي نَشَن سَ عِ مَ، عِ تٌندِ مَ نّ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","عٍسَيُ نُ عَ شُنيَ يَشُبَ رَقٍنقٍ فٍرٍ رَ، عَ شَ دُبّ سْتْقٍ شَ قٍ رَ عٍ بَبَ رَ. عٍسَيُ نَشَ عَ قَلَ عَ بْحّ مَ، «ﭑ بَبَ شَ حْنقٍ نَ بَ عَ رَ تّمُي نَشّ، ﭑ يَشُبَ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","رٍبٍكَ تٌ بَرَ عَ شَ دِ سِنفٍ عٍسَيُ شَ نَتّ تٌنفٌشِ كٌلٌن، عَ نَشَ عَ شَ دِ قِرِن ندٍ يَشُبَ شِلِ. عَ نَشَ عَ قَلَ عَ بّ، «عِ بَرَ عَ تٌ، عِ تَارَ عٍسَيُ وَ مَ عَ فبٍحْشْقٍ عِ مَ، عَ شَ عِ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","يَكْسِ ﭑ مَ دِ، عِ تُلِ مَتِ ﭑ نَ عَ قَنيِ رَ. كٍلِ بٍ، عِ شَ سِفَ شَرَنِ، ﭑ تَارَ لَبَن شْنيِ. عِ شَ سَ لُ نَا. ");
INSERT INTO susa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","عِ شَ لُ عَ شْنيِ يِ سَشَنيِ هَن بٍيمَنُ عِ تَارَ بْحّ قَمَ فٌرٌدٍ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","عِ تَارَ بْحّ نَ فٌرٌ عِ مَ تّمُي نَشَن مَ، عَ نَ نّيمُ عِ رَبَ قْشِ رَ، نَ تّمُي ﭑ نَن حُنفُمَ عِ شَ قَ. ﭑ مُ وَ مَ فَنقٍ وٌ قِرِنيِ بِرِن نَ لْشْي كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","رٍبٍكَ نَشَ عَ قَلَ عِسِيَفَ بّ، «ﭑ بْحّ بَرَ رَحَاشُ ﭑ مَ شِتِ شَ دِ فِنّيٍ شَ قٍ رَ. شَ عَ سَ لِ يَشُبَ قَن فِنّ تٌنفٌ عٍ يَ مَ يِ بْشِ مَ، نَ تّمُي تِدٍ يٌ مُ نَ ﭑ تَن مَ قٍ مَ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","عِسِيَفَ نَشَ يَشُبَ شِلِ، عَ دُبَ عَ بّ. عَ نَشَ عَ يَمَرِ، «عِ نَشَ فِنّ دْشْ دٍ نَشَن قِندِ كَنَانكَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","كٍلِ، عِ شَ سِفَ ثَدَن عَرَ مِ، عِ نفَ بَبَ بٍتُوٍلِ شْنيِ. مّننِ عِ شَ عِ نفَ تَارَ لَبَن شَ دِ فِنّ ندٍ دْشْ. ");
INSERT INTO susa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","عَلَ سّنبّ كَنيِ شَ بَرَكّ سَ عِ شَ قٍ، عَ شَ دِ فبٍفبٍ قِ عِ مَ، عَ شَ عِ قِندِ سِ فبٍفبٍ بٍنبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","عَلَ شَ بَرَكّ سَ عِ شَ قٍ، عَ نُن عِ بْنسْي، عَلْ عَ لَايِدِشِ عِبُرَهِمَ بّ كِ نَشّ، عَلَكٌ يِ بْشِ شَ قِندِ عِ فبٍ رَ، عِ سَشَنيِ رَبَقٍ دّننَشّ، عَلَ بْشِ نَشَن قِ عِبُرَهِمَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","نَ كُي عِسِيَفَ نَشَ يَشُبَ شّي ثَدَن عَرَ مِ بْشِ مَ بٍتُوٍلِ عَرَ مِكَ شَ دِ لَبَن شْنيِ. لَبَن قِندِشِ رٍبٍكَ تَارَ نَن نَ، يَشُبَ نُن عٍسَيُ نفَ. ");
INSERT INTO susa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","عٍسَيُ نَشَ عَ كٌلٌن عَ بَبَ بَرَ دُبَ يَشُبَ بّ، عَ شّيقٍ ثَدَن عَرَ مِ عَ شَ مّننِ فِنّ دْشْ. عَ مَن نَشَ كٌلٌن سْتْ عَ مَ، عَ بَبَ بَرَ يَشُبَ يَمَرِ عَ نَشَ كَنَان فِنّ دْشْ، ");
INSERT INTO susa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","يَشُبَ قَن بَرَ عَ بَبَ نُن عَ نفَ شُي رَتِنمّ سِفَقٍ رَ ثَدَن عَرَ مِ. ");
INSERT INTO susa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","نَ كُي عٍسَيُ نَشَ عَ قَهَامُ كَنَان فِنّ مُ رَقَن عَ بَبَ عِسِيَفَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","نَ نَ عَ رَ عَ نَشَ سِفَ عِبُرَهِمَ شَ دِ سُمَيِلَ يِرٍ، عَ سَ نَ شَ دِ فِنّ مَهَلَتَ دْشْ، نَشَن قِندِشِ نٍبَيٌتِ شُنيَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","يَشُبَ نَشَ كٍلِ بٍرِ سٍيبَ سِفَقٍ رَ شَرَنِ. ");
INSERT INTO susa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","كْي تٌ سٌ عَ رَ كِرَ عِ، عَ نَشَ عَ سَ يِرٍ ندٍ، عَ فّمّ قِندِ عَ شَ شُنسَسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","كْي رَ عَ نَشَ شِيٍ سَ، سَمّ تِشِ بْشِ قَرِ عَ شُنيِ سَ دْشْشِ كٌورٍ رَ. عَلَ شَ مَلٍكّيٍ نُ تٍقٍ سَمّ كْن نَ، عٍ مَن نُ فٌرٌ. ");
INSERT INTO susa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","عَلَتَلَ نُ تِشِ سَمّ قُفٍ رَ. عَ نَشَ عَ مَسٍن يَشُبَ بّ، «ﭑ تَن نَن نَ عِ تَنُن عِبُرَهِمَ نُن عِ بَبَ عِسِيَفَ مَرِفِ عَلَتَلَ رَ. عِ سَشِ بْشِ نَشَن قَرِ يِ كِ، ﭑ عَ قِمَ نّ عِ تَن نُن عِ بْنسْي مَ. ");
INSERT INTO susa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","عِ بْنسْي قَمَ نّ وُيَدٍ عَلْ شُبٍ. وٌ شَ بْشِ قَمَ نّ فبٌدٍ كٍلِقٍ سٌفٍتٍدٍ مَ عَ سَ دْشْ سٌفٍفٌرٌدٍ رَ، كٍلِ كْولَ مَ سَ دْشْ يِرٍقَنيِ رَ. ﭑ قَمَ هّيرِ قِدٍ سِ بِرِن مَ عِ تَن نُن عِ بْنسْي سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","عِ سِفَ دّدّ، وٌن بِرِن نَ عَ رَ. ﭑ عِ كَنتَمَ يِرٍ بِرِن. ﭑ مَن عِ رَفبِلٍنمَ نّ يِ بْشِ مَ. ﭑ مُ عِ رَبٌلٌمَ قٍقٍ مَ. ﭑ نَن ﭑ مَ لَايِدِ بِرِن نَكَمَلِمَ نّ عِ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","يَشُبَ تٌ شُنُ، عَ نَشَ عَ قَلَ، «يَكْسِ ﭑ بَرَ عَ كٌلٌن عَلَتَلَ نَ بٍ، كْنْ سِنفٍ ﭑ مُ نُ عَ كٌلٌنشِ.» ");
INSERT INTO susa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","عَ نَشَ فَاشُ، عَ قَ عَ قَلَ، «يِرٍ مَفَاشُشِ نَن نَ بٍ رَ. بٍ قِندِشِ عَلَ شَ بَنشِ نَادّ نَن نَ، سِفَقٍ رَ كٌورٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","يَشُبَ تٌ كٍلِ سُبَشّ مَ، عَ نَشَ نَ فّمّ تٌنفٌ عَ شُنيِ نُ سَشِ نَشَن مَ. عَ نَشَ عَ رَكٍلِ، عَ عَ تِ تْنشُمَ رَ، عَ نَشَ تُرٍ مَسٌ فّمّ شُنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","عَ نَشَ نَ يِرٍ شِلِ سَ بٍتٍلِ، «عَلَ شَ بَنشِ.» بٍينُن نَ شَ رَبَ، نَ يِرٍ شِلِ نُ قَلَمَ نّ لُسِ. ");
INSERT INTO susa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","يَشُبَ نَشَ لَايِدِ تٌنفٌ عَلَ بّ عَ قَلَقٍ رَ، «شَ عَلَ ﭑ كَنتَمَ كِرَ شْن مَ، عَ قَ دٌنسٍ نُن سٌسٍ قِ ﭑ مَ، ");
INSERT INTO susa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ﭑ فبِلٍن بْحّسَ كُي ﭑ بَبَ شْنيِ، نَ تّمُي ﭑ عَلَتَلَ نَن قِندِ مَ ﭑ مَرِفِ عَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ﭑ بَرَ يِ فّمّ تِ بٍ تْنشُمَ رَ، يِ يِرٍ شَ قِندِ عَلَ بَتُدٍ رَ. عَلَتَلَ، عِ هَرِفٍ نَشَن بِرِن قِمَ ﭑ مَ، ﭑ قَرِلّ بَمَ نّ عَ رَ، ﭑ نَ قِ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","نَ دَنفِ شَنبِ يَشُبَ نَشَ عَ شَ بِيَاسِ دّ عِدْشْ. عَ تٌ بْشِ لِ نَشَن نَ سٌفٍتٍدٍ، ");
INSERT INTO susa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","عَ نَشَ كْلْنيِ ندٍ تٌ وُلَ عِ. يّشّي نُن سِ فْورّ سَشَن نُ مَلَنشِ نَ كْلْنيِ قّ مَ، كْنْ فّمّ شُنفبٍ نَن نُ كْلْنيِ دّ مَكٌتٌشِ. ");
INSERT INTO susa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","عٍ نُ دَرِشِ نَشَن نَ، شُرُ سٍ بِرِن نَ مَلَن نَ يِرٍ، شُرُ سٍ دّ مَدٌنيِيٍ نَ كْلْنيِ دّرَكٌتٍ فّمّ مَحِندِفِلِنمَ، عَ بَ نَا. شُرُ سٍ نَ فّ يٍ مِندٍ، شُرُ سٍ دّمَدٌنيِيٍ مَن نُ فّمّ رَفبِلٍنمَ كْلْنيِ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","يَشُبَ نَشَ شُرُ سٍ دّ مَدٌنيِيٍ مَشْرِن، «ﭑ نفَشَكٍرٍنيِيٍ، وٌ كٍلِشِ مِندٍن يِ كِ؟» عٍ نَشَ عَ يَابِ، «مُشُ كٍلِشِ شَرَنِ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","عَ نَشَ عٍ مَشْرِن، «وٌ لَبَن كٌلٌن، نَشٌرِ شَ دِ شّمّ؟» عٍ نَشَ عَ يَابِ، «عِيٌ، مُشُ عَ كٌلٌن.» ");
INSERT INTO susa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","عَ نَشَ عٍ مَشْرِن، «تَنَ مُ نَ عَ مَ؟» عٍ نَشَ عَ يَابِ، «سٍسٍ مُ عَ تٌشِ. عَ شَ دِ فِنّ رَشٍلٍ نَن قَقٍ نَ كِ عٍ نُن شُرُ سٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","عَ نَشَ عَ قَلَ عٍ بّ، «وٌن نَ يَنيِ نّ يِ كِ. شُرُ سٍيٍ مَلَن تّمُي مُ يِ كِ. وٌ يٍ قِ شُرُ سٍيٍ مَ مَقُرٍن، وٌ مَن شَ فبِلٍن عٍ رَ عٍ دّ مَدٌندٍ.» ");
INSERT INTO susa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","عٍ نَشَ عَ يَابِ، «مُشُ مُ نْمَ قٍقٍ يٌ رَبَدٍ يِ كِ، قٌ شُرُ سٍ بِرِن نَ مَلَن. نَ تّمُي، مُشُ قَ يِ فّمّ بَ كْلْنيِ دّ رَ نَشَن عَ مَكٌتٌشِ، مُشُ يٍ قِ شُرُ سٍ بِرِن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","يَشُبَ تٌ نُ نَ وْيّنقٍ عٍ بّ، رَشٍلٍ قَن نَشَ قَ عَ بَبَ شَ شُرُ سٍيٍ رَ، بَرِ مَ شُرُ سٍ دّ مَدٌنيِ نَن نُ لَنشِ عَ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","يَشُبَ تٌ رَشٍلٍ تٌ قَ رَ، يَشُبَ نفَ تَارَ لَبَن شَ دِ فِنّ، عَ نُن عَ شَ شُرُ سٍيٍ، عَ نَشَ عَ مَسٌ كْلْنيِ رَ. عَ نَشَ فّمّ بَ كْلْنيِ دّ رَ، عَ نَشَ يٍ قِ لَبَن شَ شُرُ سٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","يَشُبَ نَشَ رَشٍلٍ شّيبُ سُنبُي رَ، عَ نُ وَ عَ شُي عِتٍشِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","عَ نَشَ عَ قَلَ رَشٍلٍ بّ، «عِ بَبَ شُنيَ شَ دِ نَن لَنشِ ﭑ مَ، رٍبٍكَ شَ دِ شّمّ.» رَشٍلٍ تٌ نَ مّ، عَ نَشَ عَ فِ رَكْي، عَ سَ نَ تَفِ رَبَ عَ بَبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","لَبَن تٌ بَرَ عَ شُنيَ فِنّمَ شَ دِ يَشُبَ شَ قٍ مّ، عَ نَشَ سِفَ عَ سَ عَ رَلَن. عَ نَشَ قِندِفِلِن عَ مَ، عَ عَ شَنِن بَنشِ. يَشُبَ نَشَ دّنتّفّ سَ لَبَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لَبَن نَشَ عَ قَلَ عَ بّ، «وٌن بِرِن وُلِ كٍرٍن قَسّ كٍرٍن.» يَشُبَ نَشَ كِكٍ كٍرٍن نَبَ لَبَن شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","نَ لْشْي لَبَن نَشَ عَ قَلَ يَشُبَ بّ، «ﭑ مَ مَمَدِ نَن لَنشِ عِ مَ، كْنْ سّرِيّ يٌ مُ عَ قَلَشِ عِ شَ وَلِ ﭑ بّ عَ قَ لُ ﭑ مُ عِ سَرٍ قِ. عَ قَلَ ﭑ بّ، عَ لَنمَ ﭑ شَ عِ سَرٍ قِ نَشَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","نَ تّمُي دِ فِنّ قِرِن نَن نُ نَ لَبَن يِ رَ. عَ شَ دِ فِنّ سِنفٍ شِلِ نّ لٍيَ، عَ قِرِن ندٍ رَشٍلٍ. ");
INSERT INTO susa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","لٍيَ يَ نُ شُرُن، كْنْ رَشٍلٍ تَن فِنّ تٌقَنيِ نَن نُ لَنشِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","رَشٍلٍ نَن نُ رَقَن يَشُبَ مَ كِ قَنيِ رَ. عَ نَشَ عَ قَلَ لَبَن بّ، «ﭑ حّ سٌلٌقٍرٍ نَن وَلِمَ عِ بّ، عَلَكٌ عِ شَ عِ شَ دِ فِنّ قِرِن ندٍ رَشٍلٍ قِ ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لَبَن نَشَ عَ يَابِ، «بٍينُن ﭑ شَ ﭑ مَ دِ قِ مِشِ فبّتّ مَ، ﭑ لَن ﭑ شَ عَ قِ عِ تَن نَن مَ. لُ ﭑ شْنيِ بٍ.» ");
INSERT INTO susa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","يَشُبَ نَشَ حّ سٌلٌقٍرٍ وَلِ رَبَ لَبَن يِ رَ رَشٍلٍ شَ قٍ رَ. كْنْ نَ حّ سٌلٌقٍرٍ لُ نّ عَ بّ عَلْ شِ سٌلٌقٍرٍ فبَنسَن، بَرِ مَ رَشٍلٍ نُ رَقَنشِ عَ مَ كِ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","نَ حّ سٌلٌقٍرٍ دَنفِ شَنبِ، يَشُبَ نَشَ عَ قَلَ لَبَن بّ، «ﭑ مَ كّرّ تٌنفٌشِ بَرَ كَمَلِ. ﭑ مَ فِنّ سٌ ﭑ يِ رَ قَ، ﭑ شَ عَ قِندِ ﭑ يّتّ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","لَبَن نَشَ مّننِكَ بِرِن شِلِ، عٍ شَ قَ عٍ دّفٍ، عٍ شَ حّلّشِنيِ شُلُنيِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","نُنمَرٍ رَ، عَ نَشَ عَ شَ دِ فِنّ سِنفٍ لٍيَ تٌنفٌ، عَ نَشَ عَ شَنِن يَشُبَ شْن مَ. يَشُبَ نَشَ عَ قِندِ عَ يّتّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","لَبَن نَشَ سِلِثَ سٌ عَ شَ دِ لٍيَ يِ رَ، عَ شَ قِندِ عَ شَ كٌنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","كُيٍ تٌ عِبَ، يَشُبَ نَشَ عَ تٌ لٍيَ نَ عَ رَ. عَ نَشَ عَ قَلَ لَبَن بّ، «عِ مُنسٍ رَبَشِ ﭑ نَ يِ كِ؟ ﭑ مُ وَلِشِ عِ بّ رَشٍلٍ شَ قٍ شَ رَ؟ عِ ﭑ يَنقَشِ مُنقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لَبَن نَشَ عَ يَابِ، «مُشُ تَن مَ نَامُنيِ مُ تِنمَ عَ رَ دِ فِنّ قِرِن ندٍ شَ دْشْ شّمّ تَا، عَ سِنفٍ مُ شّمّ سْتْشِ. ");
INSERT INTO susa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","يِ لْشْشُنيِ رَبَ سِندٍن وٌ نُن لٍيَ. شَ عِ مَن حّ سٌلٌقٍرٍ وَلِ رَبَ ﭑ بّ، ﭑ نَن ﭑ مَ دِ فِنّ قِرِن ندٍ قَن قِمَ نّ عِ مَ، عَ قِندِ عِ شَ فِنّ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","يَشُبَ نَشَ نَ رَبَ. عٍ نُن لٍيَ تٌ لْشْشُنيِ رَبَ يِرٍ كٍرٍن، لَبَن نَشَ رَشٍلٍ قَن قِ عَ مَ، ");
INSERT INTO susa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","عَ بِلَ سٌ رَشٍلٍ يِ رَ عَ شَ قِندِ عَ شَ كٌنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","يَشُبَ نَشَ رَشٍلٍ قِندِ عَ يّتّ رَ، عَ عَ شَنُ دَنفِقٍ لٍيَ رَ. نَ دَنفِ شَنبِ عَ مَن نَشَ حّ سٌلٌقٍرٍ وَلِ رَبَ لَبَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","عَلَتَلَ تٌ بَرَ عَ تٌ لٍيَ مُ فّشِ رَقَندٍ يَشُبَ مَ عَلْ رَشٍلٍ، عَ نَشَ لٍيَ قِندِ دِبَرِ رَ، عَ رَشٍلٍ قِندِ دِبَرِتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","لٍيَ نَشَ تّيفّ، عَ دِ شّمّ بَرِ. عَ نَشَ نَ دِ شِلِ سَ رُبٍن، عَ قَلَقٍ رَ، «عَلَتَلَ بَرَ ﭑ مَ يَافِ تٌ. يَكْسِ ﭑ قَ رَقَنمَ نّ ﭑ مَ شّمّ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","عَ مَن نَشَ تّيفّ دِ قِرِن ندٍ مَ. عَ تٌ نَ دِ بَرِ، عَ نَشَ عَ قَلَ، «عَلَتَلَ قَن يَتِ عَ كٌلٌن، ﭑ مُ رَقَن ﭑ مَ شّمّ مَ. نَ نَن عَ تٌشِ عَ يِ دِ قِرِن ندٍ قَن قِشِ ﭑ مَ.» عَ نَشَ نَ دِ شِلِ سَ سِمٍيْن. ");
INSERT INTO susa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","عَ مَن نَشَ تّيفّ دِ سَشَن ندٍ مَ. عَ تٌ عَ بَرِ، عَ مَن نَشَ عَ قَلَ، «يِ بِيَاسِ، قٌ ﭑ شَ رَقَن نّ ﭑ مَ شّمّ مَ سْنْن، بَرِ مَ ﭑ بَرَ دِ سَشَن سْتْ عَ بّ.» نَ نَن عَ تٌ، عَ نَشَ نَ دِ شِلِ سَ لٍوِ. ");
INSERT INTO susa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","عَ نَشَ تّيفّ دِ نَانِ ندٍ مَ. عَ تٌ نَ قَن بَرِ، عَ نَشَ عَ قَلَ، «يِ بِيَاسِ ﭑ عَلَتَلَ تَنتُمَ نّ.» عَ نَشَ نَ دِ شِلِ سَ يُدَ. عَ شَ دِ بَرِقٍ دَن نَ دِ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","رَشٍلٍ تٌ بَرَ عَ تٌ، عَ مُ قَ دِ بَرِقٍ، عَ نَشَ عَ تَارَ تْونّ. عَ نَشَ عَ قَلَ يَشُبَ بّ، «دِ قِ ﭑ قَن مَ، شَ نَ مُ عَ رَ ﭑ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","يَشُبَ نَشَ شْنْ عَ شَ وْيّنيِ مَ. عَ نَشَ عَ قَلَ عَ بّ، «عِ تَن عَ مَحْشُنشِ نّ عَ عَلَ نَ ﭑ تَن نَن نَ؟ عَلَ نَ عَ نِيَشِ عِ مُ دِ بَرِقٍ!» ");
INSERT INTO susa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","رَشٍلٍ نَشَ عَ يَابِ، «ﭑ مَ كٌنيِ فِنّ بِلَ تٌنفٌ، عَلَكٌ عَ شَ دِ بَرِ ﭑ بّ. عَ شَ قِندِ ﭑ مَ سَابُي رَ دِ بَرِقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","رَشٍلٍ نَشَ عَ شَ كٌنيِ فِنّ تٌنفٌ، عَ عَ سٌ عَ شَ شّمّ يَشُبَ يِ رَ. عٍ تٌ كَقُ، ");
INSERT INTO susa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","بِلَ نَشَ تّيفّ، عَ نَشَ دِ شّمّ بَرِ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","رَشٍلٍ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ مَ كِيتِ سَ. عَ بَرَ ﭑ مَ وْيّنيِ مّ. نَ نَن عَ تٌشِ عَ دِ قِشِ ﭑ مَ.» عَ نَشَ نَ دِ شِلِ سَ دَنَ. ");
INSERT INTO susa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","رَشٍلٍ شَ كٌنيِ فِنّ بِلَ مَن نَشَ تّيفّ. عَ نَشَ دِ شّمّ قِرِن ندٍ بَرِ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","رَشٍلٍ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ مَلِ كَتّ بِرِن نَ عَلَكٌ ﭑ شَ شُن نَكٍلِ سْتْ ﭑ تَارَ فِنّمَ شُن مَ.» عَ نَشَ عَ شَ دِ شِلِ سَ نَقَتَلِ. ");
INSERT INTO susa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","لٍيَ تٌ بَرَ عَ كٌلٌن عَ مُ دِ بَرِ مَ قَ، عَ نَشَ عَ شَ كٌنيِ فِنّ سِلِثَ تٌنفٌ، عَ نَشَ عَ سٌ يَشُبَ يِ رَ عَ شَ قِندِ عَ شَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","سِلِثَ نَشَ دِ شّمّ بَرِ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","لٍيَ نَشَ عَ قَلَ، «هّيرِ بَرَ قَ ﭑ مَ.» عَ نَشَ نَ دِ شِلِ سَ فَدِ. ");
INSERT INTO susa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","سِلِثَ نَشَ دِ قِرِن ندٍ سْتْ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","لٍيَ نَشَ عَ قَلَ، «ﭑ بَرَ حّلّشِن. يَكْسِ، فِنّ بِرِن بَرَ عَ كٌلٌن ﭑ بَرَ هّيرِ فبٍفبٍ سْتْ.» عَ نَشَ عَ شِلِ سَ عَسٍرِ. ");
INSERT INTO susa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","مّنفِ شَبَ تّمُي تٌ بَرَ عَ لِ، رُبٍن نَشَ سِفَ شّ مَ. عَ نَشَ بٌفِسٍ ندٍ لِ نَا، نَشَن شِلِ مَرَقَنيِ بٌفِسٍ. عَ نَشَ قَ عَ رَ عَ نفَ شْن. نَ نَن لَن رَشٍلٍ نَشَ عَ قَلَ لٍيَ بّ، «ﭑ بَرَ عِ مَشَندِ، عِ شَ عِ شَ دِ شَ مَرَقَنيِ بٌفِسٍ ندٍيٍ قِ ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","لٍيَ نَشَ عَ يَابِ، «عِ بَرَ ﭑ مَ شّمّ بَ ﭑ يِ رَ. نَ مُ عِ وَ سَشِ؟ عِ مَن وَشِ ﭑ مَ دِ شَ مَرَقَنيِ بٌفِسٍ نَن قَن تٌنفٌقٍ؟» رَشٍلٍ نَشَ عَ قَلَ، «تٌ كْي رَ، وٌ نُن يَشُبَ نَن قَمَ شِدٍ عِ شَ دِ شَ مَرَقَنيِ بٌفِسٍ حْشْي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","يَشُبَ تٌ سٌ نُنمَرٍ رَ كٍلِقٍ شّ مَ، لٍيَ نَشَ عَ رَلَن. عَ نَشَ عَ قَلَ عَ بّ، «عِ شِمَ ﭑ تَن نَن شْن مَ تٌ كْي رَ. ﭑ بَرَ تٌ كْي سَرٍ قِ ﭑ مَ دِ شَ مَرَقَنيِ بٌفِسٍ رَ.» ءَ تَن نُن يَشُبَ نَشَ كَقُ نَ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","عَلَ نَشَ لٍيَ شَ مَشَندِ تٌنفٌ، عَ نَشَ تّيفّ. نَ نَشَ قِندِ عَ شَ دِ سُولِ ندٍ رَ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","عَ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ سَرٍ قِ ﭑ مَ كٌنيِ فِنّ سٌقٍ رَ ﭑ مَ شّمّ يِ.» عَ نَشَ عَ شَ دِ شِلِ سَ عِسَكَرِ. ");
INSERT INTO susa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","لٍيَ مَن نَشَ تّيفّ دِ سٍننِ ندٍ مَ. عَ نَشَ نَ دِ بَرِ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","لٍيَ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ كِ. يِ بِيَاسِ ﭑ مَ شّمّ ﭑ بِنيَمَ نّ، بَرِ مَ ﭑ بَرَ دِ سٍننِ بَرِ عَ بّ.» عَ نَشَ نَ دِ شِلِ سَ سَبُلٌن. ");
INSERT INTO susa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","نَ شَنبِ عَ مَن نَشَ دِ فِنّ بَرِ. عَ نَشَ عَ شِلِ سَ دِنَ. ");
INSERT INTO susa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","نَ تّمُي عَلَ نَشَ عَ حّنفِ رَ سِفَ رَشٍلٍ شَ قٍ شْن. عَ نَشَ عَ شَ كْنتْقِلِ مّ، عَ عَ قِندِ دِ بَرِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","رَشٍلٍ نَشَ تّيفّ، عَ نَشَ دِ بَرِ. عَ نَشَ عَ قَلَ، «عَلَ بَرَ ﭑ نَمِنِ ﭑ مَ يَافِ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","عَ نَشَ نَ دِ شِلِ سَ يُسُقُ. نَ شِلِ يَتِ نَن قِندِشِ عَ شَ مَشَندِ رَ، قَ عَ قَلَقٍ، «عَلَتَلَ مَن شَ دِ شّمّ فبّتّ قَن قِ ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","رَشٍلٍ تٌ يُسُقُ بَرِ، يَشُبَ نَشَ عَ قَلَ لَبَن بّ، «عَ لُ ﭑ شَ فبِلٍن ﭑ مَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","عَ لُ ﭑ شَ ﭑ مَ فِنّيٍ شَنِن عَ نُن ﭑ مَ دِيٍ، ﭑ وَلِشِ عِ بّ نَشٍيٍ شَ قٍ رَ. عِ عَ كٌلٌن ﭑ وَلِ نَشَن شَسَبِ رَبَشِ عِ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لَبَن نَشَ عَ قَلَ عَ بّ، «يَندِ، شَ ﭑ نَقَن عِ مَ، عِ شَ دِحّ، عِ شَ لُ بٍ. ﭑ بَرَ عَ كٌلٌن سٍمَتٌي سَابُي رَ، عَلَتَلَ بَرَكّ سَشِ ﭑ مَ عِ تَن نَن شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","عَ قَلَ ﭑ بّ عِ وَ مَ وَلِ سَرٍ نَشَن شْن. ﭑ نَ قِمَ نّ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","يَشُبَ نَشَ عَ قَلَ عَ بّ، «عِ تَن يّتّ يَتِ عَ كٌلٌن ﭑ وَلِشِ عِ بّ كِ نَشّ هَن عِ شَ فْورّ بَرَ قِندِ عَ رَ. نَ سَابُي كٍلِشِ ﭑ تَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","دٌندٌرٌنتِ نَن نُ نَ عِ يِ رَ بٍينُ ﭑ شَ قَ، عَ فبٍفبٍ بَرَ سَ عَ شُن مَ. عَلَتَلَ بَرَ بَرَكّ سَ عِ شَ قٍ كَبِ ﭑ نَشَ سٌ عِ شْنيِ. يَكْسِ، عِ مُ عَ لُمَ ﭑ شَ وَلِ ندٍ رَبَ ﭑ مَ دٍنبَيَ قَن بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","لَبَن نَشَ عَ مَشْرِن، «عَ لَن ﭑ شَ يٍرِ قِ عِ مَ؟» يَشُبَ نَشَ عَ يَابِ، «عِ نَشَ سٍسٍ قِ ﭑ مَ. شَ عِ بَرَ تِن قٍ رَ ﭑ نَشَن قَلَشِ عِ بّ عِ شَ عَ رَبَ، ﭑ قَن بَرَ تِن ﭑ حّنفِ سَقٍ رَ عِ شَ فْورّ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ﭑ سِفَمَ تٌ، ﭑ شَ عِ شَ شُرُ سٍ بِرِن مَتٌ. يّشّي نُن سِ مَكَتُنشِ بِرِن تِ سّيتِ كٍرٍن، عَ نُن نَشٍيٍ بِرِن نَقْورْشِ. ﭑ مَسُندِ قِندِ مَ نٍيٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ﭑ مَ تِنشِنيِ قَمَ مَكّنّندٍ عِ قَمَ شُرُ سٍ مَتٌدٍ تّمُي نَشّ. سِ نَشٍيٍ بِرِن مُ مَكَتُنشِ نُن يّشّي يْرّ بِرِن نَشٍيٍ مُ قْورْ، نٍيٍ بَرَ قِندِ مُحّ رَ ﭑ مَبِرِ.» ");
INSERT INTO susa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لَبَن نَشَ عَ قَلَ، «ﭑ بَرَ تِن نَ رَ. عِ نَشَن قَلَشِ نَ كِ، وٌن بَرَ لَن نَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","نَ لْشْي لَبَن نَشَ سِ شّمّيٍ نُن فِنّيٍ مَيٍفٍتِ، سَرِنيِ سَشِ نَشٍيٍ مَ عَ نُن نَشٍيٍ مَكَتُنشِ. عَ مَن نَشَ يّشّي رَقْورْشِ مَيٍفٍتِ. عَ نَشَ نَ شُرُ سٍ بِرِن سٌ عَ شَ دِيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","نَ شَنبِ عَ نَشَ نٍيٍ شَنِن يِرٍ شِ سَشَن حّرّ رَبَمَ دّننَشّ كِرَ شْن عٍ نُن يَشُبَ تَفِ. يَشُبَ نُ قَ لَبَن شَ شُرُ سٍ دْنشْييٍ دّ مَدٌن. ");
INSERT INTO susa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","نَ تّمُي يَشُبَ نَشَ وُرِ بِلِ مْولِ سَشَن سَلٌنيِ شِندٍ فِرَ. عَ نَشَ عٍ كٌبٌلٍيٍ بَ عٍ مَ يِرٍ ندٍ عَلَكٌ سَرِنيِ قِيشّ شَ مَكّنّن. ");
INSERT INTO susa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","عَ نَشَ عٍ سَ شُرُ سٍيٍ يٍ مِندٍ عَلَكٌ شُرُ سٍ شَ عٍ يَيٍ تِ عٍ رَ عٍ يٍ مِنمَ تّمُي نَشّ. شُرُ سٍيٍ نَ سِفَ يٍ مِندٍ، شُرُ سٍ شّمّيٍ شَ تٍ شُرُ سٍ فِنّيٍ مَ سَلٌنيِيٍ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","نَ نَن عَ تٌشِ، نَ شُرُ سٍيٍ نَشَ دِيٍ بَرِ، سَرِنيِيٍ نُن كَتُنيِيٍ نَ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","يَشُبَ نَشَ نَ شُرُ سٍ يْرّيٍ سَ عٍ شَتِ مَ، كْنْ بٌورٍيٍ تِ لَبَن شَ شُرُ سٍيٍ يَ رَ سَرِنيِ نَ نَشٍيٍ مَ، عَ نُن نَشٍيٍ مَقْورْشِ. نَ كِ عَ فْورّ قِرِن نَن يَءِلَنشِ. عَ مُ تِن عَ فبٍ شَ لُ لَبَن شَ شُرُ سٍيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","شُرُ سٍ سّنبّمَيٍ نُ تٍمَ فِنّمَيٍ مَ تّمُي نَشّ، يَشُبَ نَشَ نَ سَلٌنيِ مْولِ سَ شُرُ سٍ يٍ مِندٍ عَلَكٌ عٍ شَ تٍ فِنّيٍ مَ سَلٌنيِيٍ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","يَشُبَ مُ نُ نَ وَلِ رَبَمَ شُرُ سٍ شُرِيٍ رَ. نَ نَن عَ نِيَشِ شُرُ سٍ شُرِيٍ نَشَ قِندِ لَبَن فبٍ رَ، عَ سّنبّمَيٍ نَشَ قِندِ يَشُبَ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","نَ كُي يَشُبَ بَرَ قِندِ بَننَمِشِ بٍلٍبٍلٍ رَ. شُرُ سٍيٍ، كٌنيِيٍ، حْشْمّيٍ، نُن سٌقَلٍ فبٍفبٍ بَرَ لُ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","نَ تّمُي يَشُبَ نُ بَرَ لَبَن شَ دِ شّمّيٍ شُي مّ عٍ نَشَن قَلَمَ، «سٍ نَشَن بِرِن قِندِشِ وٌن بَبَ فبٍ رَ، يَشُبَ بَرَ عَ بِرِن تٌنفٌ. نَ نَن عَ تٌشِ عَ بَرَ قِندِ بَننَ مِشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","يَشُبَ يَتِ نَشَ عَ كٌلٌن، عَ مُ رَقَن لَبَن مَ سْنْن عَلْ سِنفٍ. ");
INSERT INTO susa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","عَلَتَلَ نَشَ عَ مَسٍن يَشُبَ بّ، «فبِلٍن عِ بَبَيٍ نُن عِ بَرِبٌورٍيٍ شَ بْشِ مَ عِ كٍلِشِ دّننَشّ. وٌن بِرِن نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","يَشُبَ نَشَ رَشٍلٍ نُن لٍيَ شِلِ. عٍ نُ نَ عَ شَ شُرُ سٍيٍ دّ مَدٌنقٍ. ");
INSERT INTO susa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","عَ نَشَ عَ قَلَ عٍ بّ، «ﭑ بَرَ عَ كٌلٌن ﭑ مُ رَقَن وٌ بَبَ مَ عَلْ سِنفٍ، كْنْ ﭑ بَبَ مَرِفِ عَلَتَلَ بَرَ هِننّ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","وٌ عَ كٌلٌن يَتِ ﭑ بَرَ وَلِ وٌ بَبَ بّ ﭑ سّنبّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","عَ بَرَ ﭑ مَدَشُ ﭑ وَلِ سَرٍ مَسَرَقٍ دْشْ قُ رَ، كْنْ عَلَ مُ تِن عَ شَ قٍ حَاشِ رَبَ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","شَ وٌ بَبَ قَ عَ قَلَ، ‹كَتُنيِ نَ شُرُ سٍ نَشٍيٍ مَ، نٍيٍ نَن قِندِ مَ يَشُبَ فبٍ رَ،› شُرُ سٍ بِرِن دِ بَرِ مَ نَشٍيٍ مَكَتُنشِ. شَ وٌ بَبَ قَ عَ قَلَ، ‹سَرِنيِ نَ شُرُ سٍ نَشٍيٍ مَ، نٍيٍ نَن قِندِ مَ يَشُبَ فبٍ رَ،› شُرُ سٍ بِرِن دِ بَرِ مَ سَرِنيِ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","عَلَ بَرَ وٌ بَبَ شَ شُرُ سٍيٍ بَ عَ يِ رَ، عَ نَشَ عٍ قِ ﭑ تَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«يِ شُرُ سٍيٍ نُ تٍمَ عٍ بٌورٍ مَ تّمُي نَشّ، ﭑ بَرَ عَ تٌ شِيٍ كُي، شُرُ سٍ شّمّ نَشٍيٍ تٍشِ شُرُ سٍ فِنّيٍ مَ، سَرِنيِ نُن كَتُنيِ نَ عٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ﭑ مَ شِيٍ كُي، عَلَ شَ مَلٍكّ نَشَ ﭑ شِلِ، ‹يَشُبَ›. ﭑ نَشَ عَ رَتِن، ‹ﭑ تَن نَن يَ.› ");
INSERT INTO susa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","عَ نَشَ عَ مَسٍن، ‹عِ يَ رَكٍلِ، عِ شَ عَ مَتٌ. شُرُ سٍ شّمّ نَشٍيٍ بِرِن تٍشِ شُرُ سٍ فِنّيٍ مَ، سَرِنيِ نُن كَتُنيِ نَ عٍ مَ، بَرِ مَ لَبَن نَشَن بِرِن نَبَشِ عِ رَ، ﭑ نَ تٌشِ. ");
INSERT INTO susa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ﭑ تَن نَن نَ عَلَ رَ نَشَن مِنِ عِ مَ بٍتٍلِ، عِ فّمّ تِشِ تْنشُمَ رَ دّننَشّ. مّننِ عِ بَرَ لَايِدِ تٌنفٌ ﭑ بّ. يَكْسِ، كٍلِ يِ بْشِ مَ. عِ شَ سِفَ بْشِ مَ عِ بَرِشِ دّننَشّ.›» ");
INSERT INTO susa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","رَشٍلٍ نُن لٍيَ نَشَ يَشُبَ يَابِ، «مُشُ بَبَ مُ كّ يٌ لُشِ مُشُ تَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","شْحّ شَ مُ نَ مُشُ رَ مُشُ بَبَ شْنيِ؟ عَ بَرَ مُشُ مَتِ، عَ مَن بَرَ مُشُ شَ كْبِرِ قَن دٌن. ");
INSERT INTO susa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","عَلَ هَرِفٍ نَشَن بِرِن بَشِ مُشُ بَبَ يِ رَ، عَ فبِلٍنمَ نّ مُشُ مَ عَ نُن مُشُ شَ دِيٍ. يَكْسِ عَلَ قٍ نَشَن بِرِن مَسٍنشِ عِ بّ، نَ بِرِن نَبَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","يَشُبَ نَشَ عَ شَ فِنّيٍ نُن عَ شَ دِيٍ بَكِ حْشْمّيٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","عَ نَشَ عَ شَ شُرُ سٍ نُن عَ هَرِفٍ بِرِن شَنِن، عَ نَشَن سْتْ ثَدَن عَرَ مِ سِفَقٍ رَ عَ بَبَ عِسِيَفَ شْنيِ كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","لَبَن تٌ سِفَ عَ شَ شُرُ سٍيٍ شَبٍ مَشَبَدٍ عٍ مَ، رَشٍلٍ نُ بَرَ عَ شَ كُيٍيٍ مُحَ. ");
INSERT INTO susa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","يَشُبَ قَن لَبَن عَرَ مِكَ مَيَنقَ نّ، بَرِ مَ عَ سِفَ نّ عَ مُ حُنفُي رَبِرَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","يَشُبَ نَشَ عَ فِ، عَ نُن سٍ نَشَن بِرِن قِندِ عَ فبٍ رَ. عَ تٌ دَنفِ عٍقِرَتِ شُرٍ رَ، عَ نَشَ سِفَ فَلَدِ فٍيَ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","عَ شِ سَشَن لْشْي، مِشِ ندٍ نَشَ عَ قَلَ لَبَن بّ عَ يَشُبَ بَرَ عَ فِ. ");
INSERT INTO susa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","لَبَن نَشَ عَ نفَشَكٍرٍنيِيٍ تٌنفٌ، عٍ نَشَ مِنِ يَشُبَ قٍندٍ شِ سٌلٌقٍرٍ بُن مَ. عٍ نَشَ عَ لِ فَلَدِ فٍيَ بِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","كْنْ كْي رَ، عَلَ نَشَ مِنِ لَبَن عَرَ مِكَ مَ شِيٍ كُي. عَ نَشَ عَ مَسٍن عَ بّ، «عِ يّتّ رَتَنفَ قٍ مْولِ بِرِن قَلَقٍ رَ يَشُبَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","لَبَن نَشَ يَشُبَ لِ، عَ شَ كِرِ بَنشِ عِتَلَشِ فٍيَ يِرٍ فَلَدِ بْشِ مَ. لَبَن نُن عَ نفَشَكٍرٍنيِيٍ قَن نَشَ عٍ فبٍ عِتَلَ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","لَبَن نَشَ عَ قَلَ يَشُبَ بّ، «عِ مُنسٍ رَبَشِ يِ كِ؟ مُنقٍ رَ عِ ﭑ مَيَنقَشِ، عِ قَ ﭑ مَ دِيٍ شَنِن عَلْ فٍيلِمَنِيٍ؟ ");
INSERT INTO susa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","عِ فِشِ نْشُنيِ كُي مُنقٍ رَ؟ عِ بَرَ يَنقَنتٍيَ نِيَ ﭑ نَ. عِ مُ عِ حُنفُي رَبِرَ ﭑ مَ. شَ عِ ﭑ نَكٌلٌن نُ، ﭑ شُلُنيِ نَن تِمَ عِ بّ، ﭑ عِ تِ كِرَ رَ حّلّشِنيِ كُي بٌوتٍ نُن كْرَ شُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","كْنْ عِ تَن مُ تِنشِ يَتِ ﭑ شَ ﭑ مَ دِيٍ نُن ﭑ مَ مَمَدِيٍ سُنبُ. شَشِلِ قَنيِ مُ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ﭑ نْمَ قٍ كٌبِ رَبَدٍ وٌ رَ، كْنْ عِ بَبَ مَرِفِ عَلَتَلَ بَرَ عَ مَسٍن ﭑ بّ تٌ كْي رَ، ‹عِ يّتّ رَتَنفَ قٍ مْولِ بِرِن قَلَقٍ رَ يَشُبَ رَ.› ");
INSERT INTO susa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","كْنْ عِ تٌ فبَتَشِ سِفَقٍ رَ عِ بَبَ شْنيِ، عِ ﭑ مَ عَلَيٍ تَن شَنِنشِ عِ شُن مَ مُنقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","يَشُبَ نَشَ لَبَن يَابِ، «ﭑ مُ ﭑ حُنفُ عِ مَ، بَرِ مَ ﭑ فَاشُ نّ عِ قَ عِ شَ دِ فِنّيٍ بَقٍ ﭑ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","كْنْ عِ نَ عِ شَ عَلَيٍ تٌ ﭑ مَ مِشِ يٌ يِ رَ، ﭑ نَ كَنيِ قَشَمَ نّ. عِ شَ ﭑ مَ كٌتٍ بِرِن مَتٌ وٌن نفَشَكٍرٍنيِيٍ يَ شْرِ. نَشَن بِرِن قِندِشِ عِ فبٍ رَ، عِ شَ عَ شَنِن.» يَشُبَ مُ نُ عَ مَحْشُنمَ عَ رَشٍلٍ نَن عَ بَبَ شَ كُيٍيٍ تٌنفٌشِ. ");
INSERT INTO susa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","لَبَن نَشَ يَشُبَ شَ كِرِ بَنشِ كُي مَتٌ. عَ مَن نَشَ لٍيَ شْنيِ، لٍيَ شَ كٌنيِ شْنيِ، نُن رَشٍلٍ شَ كٌنيِ شْنيِ مَتٌ، كْنْ عَ مُ عَ فبٍ سٍ يٌ تٌ نَا. عَ تٌ مِنِ عٍ شْنيِ، عَ نَشَ سٌ رَشٍلٍ شَ كِرِ بَنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","رَشٍلٍ يَتِ نَن يِ كُيٍيٍ تٌنفٌ. عَ نُ بَرَ عٍ نْشُن دْشْسٍ بُن مَ نَشَن سَمَ حْشْمّ قَرِ، عَ قَ دْشْ عَ قَرِ. لَبَن نَشَ كِرِ بَنشِ كُي مَتٌ، كْنْ عَ مُ عَ فبٍ سٍ يٌ تٌشِ نَا. ");
INSERT INTO susa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","رَشٍلٍ نَشَ عَ قَلَ عَ بَبَ بّ، «ﭑ بَبَ عِ نَشَ شْنْ ﭑ مَ دٍ، عِ نَ تٌ ﭑ مُ كٍلِشِ ﭑ تِ. ﭑ نَ كِكٍ وَلِ نّ.» لَبَن قٍنيِ مْولِ بِرِن تِ نّ، كْنْ عَ مُ كُيٍيٍ تٌ. ");
INSERT INTO susa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","يَشُبَ نَشَ شْنْ، عَ نَشَ وْيّن شْنّ قَلَ لَبَن بّ. عَ نَشّ، «ﭑ فبَلٌي مُندُن نَبَشِ، ﭑ سّرِيّ مُندُن كَنَشِ نَشَن عَ نِيَمَ عِ شَ مِنِ ﭑ قٍندٍ يِ مْولِ رَ؟ ");
INSERT INTO susa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","عِ بَرَ ﭑ مَ كٌتٍ بِرِن كُي مَتٌ. عِ فبٍ سٍيٍ مُندُن تٌشِ عٍ كُي؟ عَ مَسٍن ﭑ بّ ﭑ نفَشَكٍرٍنيِيٍ يَ شْرِ عَ نُن عِ قَن نفَشَكٍرٍنيِيٍ يَ شْرِ عَلَكٌ عٍ شَ وٌن مَكِيتِ. ");
INSERT INTO susa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ﭑ حّ مْشْحّن نَن نَبَشِ عِ شْنيِ، كْنْ عِ شَ يّشّي نُن سِ كٍرٍن مُ دِ بَرِشِ ﭑ يِ رَ عَ قَ قَشَ. ﭑ مَن مُ عِ شَ شُرُ سٍ كٌنتٌنيِ يٌ دٌنشِ. ");
INSERT INTO susa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ﭑ مُ قَشِ شُرُ سٍ رَ عِ شْن مَ وُلَءِ سُبٍيٍ نَشَن قَشَشِ. شُرُ سٍ نَشٍيٍ مُحَشِ كْي نُن يَنيِ رَ، ﭑ تَن نَن نَ كٌتٍ بِرِن تٌنفٌشِ ﭑ يّتّ رَ. عِ نُ نَ بِرِن مَشْرِنمَ ﭑ تَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","يَنيِ رَ كُيٍقُرٍ نَشَ ﭑ تْورْ، كْي رَ شِنبٍلِ نَشَ ﭑ تْورْ، هَن ﭑ مُ نُ نْمَ شِدٍ عَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ﭑ بَرَ حّ مْشْحّن نَبَ عِ يِ رَ. ﭑ حّ قُ نُن نَانِ وَلِشِ نّ عَلَكٌ ﭑ شَ عِ شَ دِ فِنّ قِرِنيِيٍ دْشْ. ﭑ مَن نَشَ حّ سٍننِ قَن سَ عَ قَرِ عِ شَ فْورّ كَنتَقٍ رَ. كْنْ عِ بَرَ ﭑ سَرٍ مَسَرَ دْشْ قُ. ");
INSERT INTO susa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","شَ ﭑ تَنُن عِبُرَهِمَ مَرِفِ عَلَ مُ ﭑ مَلِ نُ، عَلَ نَشَن نُ ﭑ بَبَ عِسِيَفَ رَ سّرّنمَ، ﭑ سِفَمَ ﭑ بّلّشّ عِفٍلِ نَن نَ نُ. كْنْ عَلَ بَرَ ﭑ مَ مَرَيَافِ تٌ، عَ بَرَ ﭑ مَ تْورّ كٌلٌن. يِ كْي دَنفِشِ عَ بَرَ ﭑ مَ كِيتِ سَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لَبَن نَشَ يَشُبَ يَابِ، «عِ شَ فِنّيٍ نَن لَنشِ ﭑ مَ دِيٍ مَ، عٍ شَ دِيٍ، وٌن مَ دِيٍ نَن عٍ رَ. يِ شُرُ سٍيٍ ﭑ فبٍ نَ عٍ رَ، عِ سٍ نَشَن بِرِن تٌشِ يِ كِ، ﭑ تَن نَن فبٍ عٍ رَ. كْنْ تٌ شَنبِ، ﭑ نْمَ مُنسٍ رَبَدٍ ﭑ مَ دِيٍ نُن ﭑ مَ مَمَدِيٍ بّ؟ ");
INSERT INTO susa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","يَكْسِ، وٌن شَ سَاتَ. سٍيدٍ شَ لُ وٌن تَفِ.» ");
INSERT INTO susa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","يَشُبَ نَشَ فّمّ تٌنفٌ، عَ نَشَ عَ تِ سَاتّ تْنشُمَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","عَ نَشَ عَ قَلَ عَ نفَشَكٍرٍنيِيٍ بّ عٍ قَن شَ فّمّيٍ مَتٌنفٌ. عٍ نَشَ عٍ مَتٌنفٌ، عٍ عٍ مَلَن يِرٍ كٍرٍن. عٍ نَشَ عٍ دّفٍ نَ فّمّ كٌتٌشِ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","لَبَن نَشَ نَ يِرٍ شِلِ قَلَ يٍفَرَ سَهَدُتَ. يِ شِلِ نَن قَلَشِ «كٌتٌ سٍيدٍ» عَرَ مِ شُي رَ. يَشُبَ نَشَ نَ شِلِ قَلَ فَلٍدٍ. يِ شِلِ نَن قَلَشِ «كٌتٌ سٍيدٍ» عِسِرَيِلَ شُي رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","لَبَن نَشَ عَ قَلَ، «يِ فّمّ كٌتٌشِ نَشَن يِ كِ، عَ قِندِشِ سٍيدٍ نَن نَ عِ تَن نُن ﭑ تَن تَفِ.» نَ نَن عَ تٌشِ بٍ شِلِ قَلَشِ فَلٍدٍ، «سٍيدٍ فّمّ كٌتٌشِ.» ");
INSERT INTO susa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","مِسِثَ شِلِ قَن سَشِ نَ يِرٍ نَن شُن. نَ شِلِ نَن قَلَشِ «حّنفِ سَ يِرٍ،» بَرِ مَ لَبَن عَ قَلَ مّننِ نّ، «عَلَتَلَ شَ عَ حّنفِ سَ وٌن تَن قِرِنيِ شَ قٍ شْن مَ، هَلِ وٌن قَتَن شَنبِ. ");
INSERT INTO susa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","شَ عِ ﭑ مَ دِيٍ تْورْ، شَ نَ مُ عَ رَ عِ فِنّ فبّتّيٍ دْشْ، عِ شَ رَتُ عَ مَ عَ عَلَ نَن قِندِشِ سٍيدٍ رَ وٌن تَفِ، عَدَ مَدِ شَ مُ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","نَ شَنبِ لَبَن نَشَ عَ قَلَ يَشُبَ بّ، «عِ يَ تِ يِ فّمّ كٌتٌشِ رَ. يِ تْنشُمَ فّمّ مَتٌ ﭑ نَشَن تِشِ وٌن تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","يِ فّمّ كٌتٌشِ نُن يِ تْنشُمَ فّمّ قِندِشِ سٍيدٍ نَن نَ. ﭑ مُ لَن ﭑ شَ دَنفِ بٍ رَ عِ شَ قٍ حَاشِ رَ ﭑ قُرِ كُي. عِ قَن مُ لَن عِ شَ دَنفِ يِ فّمّ كٌتٌشِ نُن يِ تْنشُمَ فّمّ رَ ﭑ مَ قٍ حَاشِ رَ عِ قُرِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","عِبُرَهِمَ مَرِفِ عَلَ نُن نَشٌرِ مَرِفِ عَلَ شَ قِندِ وٌن تَن قِرِنيِ مَكِيتِمَ رَ.» نَ تّمُي يَشُبَ نَشَ عَ يّتّ رَكَلِ عَلَ رَ، عَ بَبَ عِسِيَفَ فَاشُشِ نَشَن يَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","يَشُبَ نَشَ سّرّشّ بَ فٍيَ يِرٍ. عَ نَشَ عَ نفَشَكٍرٍنيِ بِرِن شِلِ عٍ شَ عٍ دّفٍ. عٍ تٌ فّ عٍ دّفٍدٍ، عٍ نَشَ شِ مّننِ نَ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","لَبَن تٌ كٍلِ سُبَشّ مَ، عَ نَشَ قِندِفِلِن عَ شَ دِيٍ نُن عَ شَ مَمَدِيٍ مَ. عَ نَشَ دُبَ عٍ بّ. نَ شَنبِ، لَبَن نَشَ فبِلٍن عَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","يَشُبَ تٌ نُ سِفَقٍ كِرَ شْن، عَلَ شَ مَلٍكّيٍ نَشَ مِنِ عَ مَ. عَ تٌ بَرَ عٍ تٌ، عَ نَشَ عَ قَلَ، «عَلَ شَ يٌنكِندٍ نَن يِ كِ.» ");
INSERT INTO susa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","عَ نَشَ يِ يِرٍ شِلِ سَ مَشَنَيِمِ. ");
INSERT INTO susa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","يَشُبَ نَشَ شّيرَيٍ شّي عَ تَارَ عٍسَيُ شْن مَ عٍدٌن دَاشَ، سٍيِرِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","عَ نَشَ عَ قَلَ عٍ بّ، «وٌ يِ نَن قَلَمَ ﭑ مَرِفِ عٍسَيُ بّ، ‹عِ شَ كٌنيِ دِ يَشُبَ نَشّ، ﭑ بَرَ بُ لَبَن شْنيِ هَن يَ. ");
INSERT INTO susa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","نِنفٍيٍ، سٌقَلٍيٍ، يّشّييٍ، نُن سِيٍ نَن ﭑ يِ رَ. كٌنيِ شّمّيٍ نُن كٌنيِ فِنّيٍ قَن نَن ﭑ يِ رَ. ﭑ مَرِفِ، ﭑ شّيرَيٍ شّيشِ نّ عِ شْن مَ عَلَكٌ عِ شَ دِحّ ﭑ بّ.›» ");
INSERT INTO susa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","نَ شّيرَيٍ تٌ فبِلٍن، عٍ نَشَ عَ قَلَ يَشُبَ بّ، «مُشُ بَرَ عِ تَارَ عٍسَيُ تٌ. عَ نَ قَقٍ عِ يِرٍ، عَ نُن فبَنفبَلَنيِ مِشِ كّمّ نَانِ.» ");
INSERT INTO susa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","نَ مَسٍنيِ نَشَ يَشُبَ بْحّ رَ مِنِ. حَمَ نَشَن نُ عَ قْشْ رَ، عَ نَشَ عٍ عِتَشُن دْشْ قِرِن. عَ نَشَ يّشّييٍ نُن سِيٍ عِتَشُن دْشْ قِرِن، عَ نُن نِنفٍيٍ نُن حْشْمّيٍ. ");
INSERT INTO susa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","عَ نَشَ عَ قَلَ، «شَ عٍسَيُ حَمَ كٍرٍن فٍرٍ، حَمَ بٌورٍ شَ نْ عَ فِدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","نَ شَنبِ يَشُبَ نَشَ عَلَ مَشَندِ، «ﭑ تَنُن عِبُرَهِمَ مَرِفِ عَلَ، ﭑ بَبَ عِسِيَفَ مَرِفِ عَلَتَلَ، عِ عَ قَلَ نّ ﭑ بّ، ‹فبِلٍن عِ شَ بْشِ مَ، عِ نفَشَكٍرٍنيِيٍ يِرٍ. عِ نَ سِفَ، ﭑ قٍ قَنيِ رَبَمَ نّ عِ بّ.› ");
INSERT INTO susa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","كْنْ يَكْسِ ﭑ مَرِفِ، ﭑ تَن شُرُن يِ قٍ سْتْقٍ مَ عِ نَشَن نَفِرِشِ ﭑ مَ. عِ بَرَ عِ شُي رَ سَبَتِ ﭑ تَن بّ عِ شَ كٌنيِ. ﭑ مَ يِسُشُوُرِ فبَنسَن نَن نُ سُشُشِ ﭑ يِ رَ ﭑ يُرُدّن عِفِرِ مَ تّمُي نَشّ، كْنْ يَكْسِ مُشُ نُن حَمَ قِرِن نَن فبِلٍنقٍ. ");
INSERT INTO susa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ﭑ نَتَنفَ ﭑ تَارَ عٍسَيُ مَ، بَرِ مَ ﭑ بَرَ فَاشُ عَ يَ رَ. ﭑ فَاشُشِ نّ عَ نَشَ قَ ﭑ قَشَ، ﭑ تَن نُن دِنفّيٍ نُن عٍ شَ دِيٍ. ");
INSERT INTO susa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","عِ بَرَ عَ مَسٍن ﭑ بّ، ‹ﭑ قٍ قَنيِ رَبَمَ نّ عِ بّ. ﭑ عِ بْنسْي رَوُيَمَ نّ عَلْ مّيّنيِ نَشَن كْنتِ مُ نْمَ كٌلٌندٍ بَا دّ رَ.›» ");
INSERT INTO susa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","يَشُبَ نَشَ كْي رَدَنفِ نَ يِرٍ. عَ نَشَ سَنبَسٍ قَنيِ مَيٍفٍتِ عَ هَرِفٍ بِرِن يَ مَ عَ نَشَن قِمَ عَ تَارَ عٍسَيُ مَ؛ ");
INSERT INTO susa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","سِ كّمّ قِرِن، سِ كٌنتٌنيِ مْشْحّن، يّشّي كّمّ قِرِن، يّشّي كٌنتٌنيِ مْشْحّن، ");
INSERT INTO susa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","حْشْمّ فِنّ تٌنفٌ سَشَن، عٍ شَ دِيٍ، نِنفٍ تٌنفٌ نَانِ، تُورَ قُ، سٌقَلٍ فِنّ مْشْحّن، عَ نُن سٌقَلٍ شّمّ قُ. ");
INSERT INTO susa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","عَ نَشَ يِ شُرُ سٍيٍ عِتَشُن، عَ ندٍ سٌ عَ شَ كٌنيِيٍ يِ رَ. عَ نَشَ عَ قَلَ عٍ بّ، «وٌ دَنفِ يَرٍ. وٌ شَ نَانِنيِ لُ فْورّيٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","عَ نَشَ عَ قَلَ عَ شَ كٌنيِ سِنفٍ بّ، «وٌ نُن ﭑ تَارَ عٍسَيُ نَ نَرَلَن، عَ قَمَ عِ مَشْرِندٍ، ‹وٌ نُن ندٍ عَ رَ؟ عِ نَ سِفَقٍ مِندٍن؟ ندٍ فبٍ نَ يِ شُرُ سٍيٍ رَ نَشٍيٍ تِشِ عِ يَ رَ يِ كِ؟› ");
INSERT INTO susa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","عِ قَمَ نّ عَ يَابِدٍ، ‹ﭑ مَرِفِ عٍسَيُ، عِ شَ كٌنيِ يَشُبَ نَن فبٍ نَ عٍ رَ. عَ عِ سَنبَشِ يٍيٍ نَن نَ. عَ قَن نَ ﭑ شَنبِ رَ.›» ");
INSERT INTO susa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","عَ نَشَ نَ مَسٍنيِ تِ عَ قِرِن ندٍ قَن بّ، عَ نُن عَ سَشَن ندٍ، عَ نُن مِشِ نَشٍيٍ بِرِن بِرَشِ شُرُ سٍيٍ قْشْ رَ. «وٌ نُن عٍسَيُ نَ نَرَلَن تّمُي نَشّ، وٌ شَ نَ مَسٍنيِ تِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","وٌ شَ عَ قَلَ، ‹عِ شَ كٌنيِ يَشُبَ نَ قَقٍ مُشُ شَنبِ رَ.›» نَ كُي يَشُبَ نُ نَ عَ مَحْشُنقٍ، «يَكْسِ، ﭑ عَ بْحّ مَفٌرٌ مَ يِ سَنبَسٍيٍ نَن نَ. نَ تّمُي، عَ نَ ﭑ تٌ، تّمُندٍ عَ نْمَ نّ ﭑ نَسّنّدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","يَشُبَ شَ سَنبَسٍيٍ نَشَ تِ عَ يَ رَ، عَ تَن نَشَ كْي رَدَنفِ يٌنكِندٍ كُي. ");
INSERT INTO susa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","كْي كُي، يَشُبَ نَشَ كٍلِ. عَ نَشَ عَ شَ فِنّ قِرِنيِيٍ تٌنفٌ، عٍ شَ كٌنيِ قِرِنيِيٍ، عَ نُن عَ شَ دِ قُ نُن كٍرٍنيِ. عٍ نَشَ يَبٌكٌ عِفِرِ. ");
INSERT INTO susa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","عَ نَشَ عٍ رَفِرِ يَبٌكٌ شُرٍ عَ نُن سٍ نَشَن بِرِن نَ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","عَ نَشَ لُ مّننِ عَ كٍرٍن. نَ تّمُي، شّمّ ندٍ نَشَ مِنِ عَ مَ، عٍ نَشَ فٍرٍ هَن كُيٍ عِبَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","نَ شّمّ تٌ بَرَ عَ تٌ عَ مُ نْمَ نْلَ سْتْدٍ يَشُبَ مَ عٍ شَ فٍرٍ كُي، عَ نَشَ عَ فَرِن عَ تْنشْنيِ مَ. عَ تْنشْنيِ نَشَ تٍ عَ كُي. ");
INSERT INTO susa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","شّمّ نَشَ عَ قَلَ، «عَ لُ ﭑ شَ سِفَ، بَ كُيٍ بَرَ عِبَ.» يَشُبَ نَشَ عَ قَلَ، «ﭑ مُ عِ بّحِنمَ، قٌ عِ دُبَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","شّمّ نَشَ عَ مَشْرِن، «عِ شِلِ دِ؟» عَ نَشَ عَ يَابِ، «يَشُبَ.» ");
INSERT INTO susa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","شّمّ نَشَ عَ قَلَ، «عِ شِلِ مُ قَلَمَ سْنْن يَشُبَ. عَ قَ قَلَمَ نّ كْرّ عِسِرَيِلَ، بَ وٌ نُن عَلَ نَن فٍرٍشِ، وٌ نُن مِشِيٍ قَن بَرَ فٍرٍ. عِ تَن بَرَ نْ عٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","يَشُبَ نَشَ مَشْرِنيِ تِ، «عِ شِلِ دِ؟» شّمّ نَشَ عَ قَلَ، «مُنقٍ رَ عِ ﭑ مَشْرِنمَ ﭑ شِلِ مَ؟» نَ شَنبِ، عَ نَشَ دُبَ يَشُبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","يَشُبَ نَشَ نَ يِرٍ شِلِ ثٍنِيٍلِ، بَرِ مَ عَ نَشّ، «ﭑ عَلَ تٌشِ نّ ﭑ يَ عِ، كْنْ ﭑ تَن نَن مَن حّنفِقٍ يِ كِ.» ");
INSERT INTO susa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","سٌفٍ تٍمَ تّمُي نَشّ، يَشُبَ نُ بَرَ دَنفِ ثٍنِيٍلِ رَ، عَ فٌرٌ مَ عَ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","نَ نَن عَ تٌشِ هَن يَكْسِ عِسِرَيِلَكَيٍ مُ لَارٍ دٌنمَ نَشَن نَ تْنشْنيِ مَ، بَرِ مَ عَلَ يَشُبَ مَسْتْشِ عَ تْنشْن لَارٍ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","يَشُبَ تٌ عٍسَيُ تٌ قَ رَ عٍ نُن شّمّ مِشِ كّمّ نَانِ، عَ نَشَ عَ شَ دِيٍ عِتَشُن لٍيَ نُن رَشٍلٍ مَ، عَ نُن عٍ شَ كٌنيِ فِنّ قِرِنيِيٍ. ");
INSERT INTO susa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","عَ نَشَ كٌنيِ فِنّ قِرِنيِيٍ تِ يَرٍ، عٍ نُن عٍ شَ دِيٍ. نٍيٍ شَنبِ رَ، لٍيَ قَن نَشَ تِ نُن عَ شَ دِيٍ. رَشٍلٍ نُن يُسُقُ نَشَ لُ دْنشْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","يَشُبَ تَن نَشَ سِفَ يَرٍ. عَ تٌ مَكْرّ عَ تَارَ رَ، عَ نَشَ عَ عِفٌرٌ بْشِ مَ سَنيَ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","نَ نَن لَن عٍسَيُ نَشَ عَ فِ عَ سَ يَشُبَ رَلَن. عَ نَشَ قِندِفِلِن عَ مَ، عَ قَ عَ مَسُنبُ. عٍ بِرِن نُ قَ وَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","عٍسَيُ تٌ بَرَ فِنّيٍ نُن دِ مّيٍ تٌ، عَ نَشَ مَشْرِنيِ تِ، «ندٍ يٍيٍ رَ نَشٍيٍ بِرَشِ عِ قْشْ رَ يِ كِ؟» يَشُبَ نَشَ عَ يَابِ، «عَلَ دِ نَشٍيٍ قِشِ عِ شَ كٌنيِ دِ مَ عَ شَ مَرَقَنيِ سَابُي رَ.» ");
INSERT INTO susa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","نَ كُي لٍيَ نُن رَشٍلٍ شَ كٌنيِ فِنّيٍ نَشَ عٍ مَسٌ عٍسَيُ رَ، عٍ نُن عٍ شَ دِيٍ، عٍ قَ عٍ عِفٌرٌ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","لٍيَ نُن عَ شَ دِيٍ قَن نَشَ عٍ مَسٌ، عٍ نَشَ عٍ عِفٌرٌ بْشِ مَ. نَ شَنبِ يُسُقُ نُن رَشٍلٍ نَشَ عٍ مَسٌ عٍسَيُ رَ، عٍ عِفٌرٌ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","عٍسَيُ نَشَ يَشُبَ مَشْرِن، «عِ مُنسٍ رَبَمَ يِ شُرُ سٍ بِرِن نَ، ﭑ نَرَلَنشِ نَشٍيٍ رَ يِ كِ؟» يَشُبَ نَشَ عَ يَابِ، «ﭑ وَ مَ نّ عِ تَن نَشَن نَ ﭑ مَرِفِ رَ، عِ شَ ﭑ نَقَن.» ");
INSERT INTO susa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","عٍسَيُ نَشَ عَ قَلَ، «ﭑ شُنيَ، هَرِفٍ فبٍفبٍ نَ ﭑ قَن يِ رَ. عِ فبٍ رَفَتَ.» ");
INSERT INTO susa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","يَشُبَ نَشَ عَ يَابِ، «عَدٍ، ﭑ بَرَ عِ مَشَندِ. شَ عِ بَرَ ﭑ نَقَن، ﭑ عِ سَنبَشِ سٍ نَشٍيٍ بِرِن نَ، عِ شَ عٍ رَ سُشُ. وٌن تَن قِرِنيِ شَ مَرَلَنيِ لُشِ نّ ﭑ بّ عَلْ مُشُ نُن عَلَ نَن لُشِ يِرٍ كٍرٍن. عِ بَرَ ﭑ نَسّنّ عَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ﭑ بَرَ عِ مَشَندِ، عِ شَ يِ سَنبَسٍيٍ رَ سُشُ، بَرِ مَ عَلَ بَرَ ﭑ وَشْنقٍ بِرِن نَبَ ﭑ بّ. ﭑ هَيِ مُ نَ سٍسٍ مَ سْنْن.» يَشُبَ نَشَ عَ مَشْرْشْ هَن عٍسَيُ نَشَ تِن نٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","عٍسَيُ نَشَ عَ قَلَ، «وٌن شّي كِرَ شْن مَ، ﭑ شَ سَ عِ مَتِ.» ");
INSERT INTO susa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","يَشُبَ نَشَ عَ يَابِ، «ﭑ مَرِفِ، عَ كٌلٌن دِ مّيٍ شَ قٍ شْرْشْ. يّشّي فِنّيٍ نُن نِنفٍ فِنّيٍ نَ شِحّ قِقٍ عٍ شَ دِيٍ مَ. شَ وٌن فبَتَ عٍ رَ لْشْي كٍرٍن، نٍيٍ بِرِن قَمَ نّ قَشَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ﭑ مَرِفِ، عِ تَن شَ تِ يَرٍ. ﭑ تَن شَ بِرَ ﭑ مَ شُرُ سٍيٍ قْشْ رَ دْيِن. ﭑ شَ سِفَ ﭑ مَ شُرُ سٍيٍ نُن ﭑ مَ دِيٍ يَيَ رَ، هَن مُشُ سٌمَ عِ شْنيِ تّمُي نَشّ سٍيِرِ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عٍسَيُ نَشَ عَ قَلَ، «ﭑ شَ ﭑ مَ مِشِ ندٍيٍ لُ عِ يِ رَ بٍ.» يَشُبَ نَشَ عَ يَابِ، «مُنقٍ رَ؟ ﭑ مَرِفِ، ﭑ تَن وَ مَ نَشَن شْن، ﭑ شَ رَقَن عِ مَ فبَنسَن.» ");
INSERT INTO susa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","نَ كُي عٍسَيُ نَشَ فبِلٍن نَ لْشْي سٍيِرِ. ");
INSERT INTO susa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","يَشُبَ تَن نَشَ سِفَ سُكْتِ. مّننِ عَ نَشَ بَنشِ كٍرٍن تِ عَ يّتّ بّ، عَ نُن فْورّ عَ شَ شُرُ سٍيٍ لُمَ دّننَشّ. نَ نَن عَ تٌشِ نَ يِرٍ شِلِ قَلَمَ سُكْتِ، نَ نَن قَلَشِ نَ كِ «بَنشِ شُنشُرِ.» ");
INSERT INTO susa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","يَشُبَ تٌ سٌ هّيرِ سِكٍمِ تَا كُي كَنَان بْشِ مَ كٍلِقٍ ثَدَن عَرَ مِ، عَ نَشَ عَ شَ كِرِ بَنشِ عِتَلَ تَا قَرِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","عَ شَ كِرِ بَنشِ نُ تِشِ دّننَشّ، عَ نَشَ نَ بْشِ سَرَ هَمٌرِ شَ دِيٍ مَ كْبِرِ كٌلٍ كّمّ رَ. هَمٌرِ نَن قِندِ سِكٍمِ بَبَ رَ، نَشَن سِنفٍ سَبَتِ نَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","عَ نَشَ سّرّشّبَدٍ يَءِلَن مّننِ، عَ نَ يِرٍ شِلِ «عِسِرَيِلَ مَرِفِ عَلَ سّنبّ فبٌ.» ");
INSERT INTO susa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","يَشُبَ شَ دِ فِنّ دِنَ، لٍيَ نَشَن بَرِشِ عَ بّ، نَ نَشَ سِفَ سِكٍمِ تَا كُي فِنّيٍ شّيبُدٍ. ");
INSERT INTO susa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","مَنفّ هَمٌرِ هِوِكَ شَ دِ سِكٍمِ تٌ دِنَ تٌ، عَ نَشَ عَ مَدُتُن، عَ نَشَ عَ قُتِ كَنَ. ");
INSERT INTO susa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","نَ كُي يَشُبَ شَ دِ فِنّ دِنَ شَ شَنُنتٍيَ نَشَ لُ سِكٍمِ قَتٍ. سِكٍمِ نَشَ وْيّن دِنَ بّ مَرَقَنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","نَ تّمُي سِكٍمِ نَشَ عَ قَلَ عَ بَبَ هَمٌرِ بّ، «يِ تّمّدِ مَشَندِ ﭑ بّ عَلَكٌ ﭑ شَ عَ دْشْ.» ");
INSERT INTO susa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","يَشُبَ عَ مّ تّمُي نَشّ سِكٍمِ بَرَ عَ شَ دِ فِنّ دِنَ قُتِ كَنَ، عَ شَ دِ شّمّيٍ نُ نَ شّ مَ شُرُ سٍيٍ قْشْ رَ. عَ مُ سٍسٍ قَلَ هَن نٍيٍ سٌ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","سِكٍمِ بَبَ هَمٌرِ نَشَ سِفَ يَشُبَ شْنيِ عَ شَ سَ وْيّن عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","يَشُبَ شَ دِيٍ تٌ عَ مّ نَشَن دَنفِشِ، عٍ نَشَ كٍلِ شّ مَ كٍرٍن نَ، عٍ فبِلٍن بَنشِ. عٍ بْحّ نَشَ تٍ كِ قَنيِ رَ بَرِ مَ سِكٍمِ قٍ مَيَافِشِ نَن نَبَشِ عِسِرَيِلَ بْشِ مَ، عَ قٍ نِيَ يَشُبَ شَ دِ فِنّ رَ نَشَن مُ لَنمَ عَ شَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","هَمٌرِ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ دِ فِنّ بَرَ رَقَن ﭑ مَ دِ سِكٍمِ مَ. ﭑ بَرَ وٌ مَشَندِ، وٌ شَ عَ قِ عَ مَ، عَ شَ قِندِ عَ شَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","وٌن شَ لُ قٍ كٍرٍن، وٌ وٌ شَ دِ فِنّيٍ قِ مُشُ مَ عَلَكٌ مُشُ شَ عٍ دْشْ. نَ تّمُي وٌ قَن نْمَ مُشُ فبٍيٍ دْشْدٍ. ");
INSERT INTO susa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","وٌ شَ سَبَتِ يِ بْشِ مَ مُشُ سّيتِ مَ. بٍ شَ قِندِ وٌ شْنيِ رَ، وٌ شَ يُلّيَ رَبَ، وٌ شَ هَرِفٍ سْتْ.» ");
INSERT INTO susa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","سِكٍمِ نَشَ عَ قَلَ دِنَ بَبَ نُن عَ تَارَيٍ بّ، «وٌ شَ هِننّ ﭑ نَ. وٌ وَ مَ سٍ نَشَن يٌ شْن، ﭑ عَ قِمَ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","وٌ نْمَ قٍ بٍلٍبٍلٍ مَشْرِندٍ ﭑ مَ نَشَن قِندِ مَ كٌتٍ دْشْسٍ رَ، سَ سٍ فبٍفبٍ قَن قَرِ. وٌ نَ سٍ نَشَن بِرِن مَشْرِن ﭑ مَ، ﭑ نْمَ عَ بِرِن قِدٍ وٌ مَ عَلَكٌ ﭑ شَ يِ سُنفبُتُنيِ دْشْ.» ");
INSERT INTO susa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","يَشُبَ شَ دِيٍ نَشَ وْيّن قُرُشِ قَلَ سِكٍمِ نُن عَ بَبَ هَمٌرِ بّ، بَرِ مَ سِكٍمِ نُ بَرَ عٍ شُنيَ دِنَ رَيَافِ. ");
INSERT INTO susa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","عٍ نَشَ عَ قَلَ عٍ بّ، «مُشُ مُ نْمَ مُشُ شُنيَ فِنّمَ قِدٍ مِشِ مَ نَشَن مُ سُننَشِ. عَ قِندِ مَ يَافِ نَن نَ مُشُ بّ. ");
INSERT INTO susa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","مُشُ مُ نْمَ وٌ وَشْنقٍ رَبَدٍ، قٌ وٌ شَ لُ عَلْ مُشُ تَن. مِشِ نَشَن بِرِن نَ وٌ شْنيِ، عٍ لَن نّ عٍ شَ سُننَ عَلْ مُشُ تَن. ");
INSERT INTO susa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","نَ تّمُي مُشُ نْمَ مُشُ شَ دِ فِنّيٍ قِدٍ وٌ مَ، وٌ شَ عٍ دْشْ. مُشُ قَن وٌ فبٍيٍ دْشْ. مُشُ لُمَ وٌ سّيتِ مَ نَ تّمُي. وٌن بِرِن قِندِ حَمَ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","كْنْ شَ وٌ مُ قَ سَ تِن وٌ سُننَدٍ، مُشُ مُشُ شُنيَ فِنّمَ رَ سُشُمَ نّ، مُشُ كٍلِ بٍ.» ");
INSERT INTO susa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","هَمٌرِ نُن عَ شَ دِ سِكٍمِ نَشَ تِن عٍ شَ مَسٍنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","نَ سّفّتَلَ مُ بُ نَ قٍ رَبَقٍ رَ، بَرِ مَ يَشُبَ شَ دِ فِنّ بَرَ رَقَن عَ مَ. عَ تَن نَن نُ وُرُفٍنتٍ رَ عَ نفَشَكٍرٍنيِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","هَمٌرِ نُن سِكٍمِ نَشَ سِفَ عٍ شَ مَلَن يِرٍ تَا سٌدٍ دّ رَ. عٍ نَشَ عَ مَسٍن عٍ شَ حَمَ بّ، ");
INSERT INTO susa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«يِ مِشِيٍ وٌن مَ قٍ قَنيِ نَ عٍ بّ. عٍ شَ لُ يِ بْشِ مَ، عٍ شَ يُلّيَ رَبَ، بَرِ مَ وٌن مَ بْشِ فبٌ. وٌن نْمَ عٍ شَ دِ فِنّيٍ دْشْدٍ، وٌن قَن وٌن مَ دِ فِنّيٍ قِمَ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","شَ يِ مِشِيٍ سَبَتِمَ بٍ، وٌن شَ قِندِ حَمَ كٍرٍن نَ، قٌ وٌن شَ يِ نَن نَبَ. شّمّ نَشَن بِرِن نَ وٌن شْنيِ بٍ، عٍ بِرِن لَن نّ عٍ شَ سُننَ عَلْ عٍ تَن. ");
INSERT INTO susa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","شَ وٌن بَرَ تِن عٍ شَ مَسٍنيِ رَ، نَ تّمُي عٍ سَبَتِمَ وٌن شْنيِ. عٍ شَ شُرُ سٍيٍ نُن عٍ سْتْسٍ بِرِن قِندِ وٌن بِرِن فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","مِشِ نَشَن بِرِن نُ نَ تَا سٌدٍ دّ رَ نَ لْشْي، عٍ بِرِن نَشَ تِن هَمٌرِ نُن عَ شَ دِ سِكٍمِ شَ مَسٍنيِ رَ. شّمّ نَشَن بِرِن نُ نَ تَا كُي، عٍ بِرِن نَشَ عٍ سُننَ. ");
INSERT INTO susa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","عٍ شَ سُننّ شِ سَشَن لْشْي، يِ شّمّيٍ سُننَدٍ تٌ نُ نَ عٍ شْنْقٍ، يَشُبَ شَ دِ شّمّ قِرِنيِيٍ سِمٍيْن نُن لٍوِ، دِنَ تَارَ شّمّمَيٍ نَشَ عٍ شَ سَنتِدّفّمَيٍ تٌنفٌ، عٍ سٌ تَا كُي، عٍ شّمّ بِرِن قَشَ سَنتِدّفّمَ رَ تّرّننَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","عٍ نَشَ هَمٌرِ نُن عَ شَ دِ سِكٍمِ قَن قَشَ. عٍ نَشَ دِنَ تٌنفٌ سِكٍمِ شْنيِ، عٍ نَشَ قَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","يَشُبَ شَ دِ بٌورٍيٍ نَشَ سٍ بِرِن تٌنفٌ نَشٍيٍ قِندِ نَ مِشِ قَشَشِيٍ فبٍ رَ، بَرِ مَ عٍ نُ بَرَ عٍ شُنيَ فِنّمَ قُتِ كَنَ. ");
INSERT INTO susa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","عٍ نَشَ عٍ شَ يّشّييٍ تٌنفٌ عَ نُن عٍ شَ سِيٍ، عٍ شَ نِنفٍيٍ نُن عٍ شَ سٌقَلٍيٍ، نَشٍيٍ نُ نَ تَا كُي عَ نُن دَاشَ. ");
INSERT INTO susa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","سٍ نَشَن بِرِن نُ نَ، عٍ نَشَ عَ بِرِن شَنِن. عٍ نَشَ دِ مّيٍ نُن فِنّيٍ شَنِن. بَنشِ نَشَن بِرِن نُ نَ، عٍ نَشَ عَ بِرِن كَنَ. ");
INSERT INTO susa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","يَشُبَ نَشَ عَ قَلَ سِمٍيْن نُن لٍوِ بّ، «وٌ بَرَ كْنتْقِلِ تِ ﭑ مَ ﭑ لُقٍ رَ شْننَنتٍيَ دْشْي كُي كَنَانكَيٍ نُن ثٍرٍ سِكَيٍ تَفِ. شّمّ فبٍفبٍ مُ نَ ﭑ يِ رَ. عٍ قَمَ نّ لَندٍ ﭑ شُن مَ، عٍ ﭑ بْنبْ، عٍ ﭑ شَبِلّ بِرِن هَلَكِ.» ");
INSERT INTO susa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","عٍ نَشَ عَ يَابِ، «عَ نُ لَنمَ يِ مِشِ شَ مُشُ شُنيَ قِندِ لَنفٌي رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","عَلَ نَشَ عَ مَسٍن يَشُبَ بّ، «كٍلِ، عِ سِفَ بٍتٍلِ. عِ شَ سّرّشّبَدٍ يَءِلَن ﭑ بّ مّننِ، ﭑ نَن ﭑ يّتّ مَسٍن عِ بّ دّننَشّ، عِ نُ عِ فِمَ وَشَتِ نَشّ عِ تَارَ عٍسَيُ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","يَشُبَ نَشَ عَ قَلَ عَ شَ دٍنبَيَ بّ عَ نُن عَ قْشِرَبِرّيٍ، «وٌ فبِلٍن كُيٍ قٍ قْشْ رَ، وٌ شَ وٌ يّتّ سّنِيّن، وٌ شَ وٌ شَ سٌسٍيٍ قَن مَسَرَ. ");
INSERT INTO susa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","وٌ وٌ يَءِلَن، وٌن شَ سِفَ بٍتٍلِ. ﭑ شَ سّرّشّبَدٍ يَءِلَن عَلَ بّ، نَشَن عَ يّتّ مَسٍن ﭑ بّ ﭑ نُ نَ كْنتْقِلِ كُي تّمُي نَشّ. عَ نَشَ عَ حّنفِ سَ ﭑ مَ قٍ شْن ﭑ سِفَ دّننَشّ بِرِن.» ");
INSERT INTO susa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","نَ تّمُي عٍ نَشَ عٍ شَ كُيٍ بِرِن سٌ يَشُبَ يِ رَ عَ نُن عٍ شَ تُلِرَ سٌي. يَشُبَ نَشَ عٍ بِرِن بِرِ وُرِ بٍلٍبٍلٍ بُن مَ نَشَن نَ سِكٍمِ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","يَشُبَ نُن عَ شَ دِيٍ تٌ بَرَ عٍ شَ يٌنكِندٍ بَ، عَلَ نَشَ فَاشُي لُ تَا مِشِ بِرِن بْحّ مَ، مِشِ يٌ مُ سُو سَ بِرَدٍ عٍ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","يَشُبَ نُن عَ قْشِرَبِرّيٍ نَشَ سِفَ لُسِ، بٍتٍلِ نَن نَ كِ، كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","عَ نَشَ سّرّشّبَدٍ يَءِلَن مّننِ. عَ نَشَ نَ يِرٍ شِلِ قَلَ «بٍتٍلِ مَرِفِ عَلَ،» بَرِ مَ عَلَ عَ يّتّ مَسٍن عَ بّ مّننِ نّ عَ نُ عَ فِقٍ عَ تَارَ مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","رٍبٍكَ شَ دِ مَسُشُي دٍبٌرَ نَشَ قَشَ. عٍ نَشَ عَ رَفَتَ بٍتٍلِ مَبِرِ وُرِ بٍلٍبٍلٍ نَ دّننَشّ. نَ وُرِ بٍلٍبٍلٍ شِلِ نّ «وَ تِدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","عَلَ مَن نَشَ مِنِ يَشُبَ مَ، عَ تٌ فبِلٍن كٍلِقٍ ثَدَن عَرَ مِ. عَ نَشَ بَرَكّ سَ عَ شَ قٍ. ");
INSERT INTO susa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","عَلَ نَشَ عَ قَلَ عَ بّ، «عِ شِلِ قَلَقٍ نّ يَشُبَ، كْنْ عَ مُ قَلَمَ نَ كِ سْنْن. تٌ شَنبِ عِ شِلِ قَ قَلَمَ نّ عِسِرَيِلَ.» عَلَ نَشَ عَ شِلِ سَ عِسِرَيِلَ. ");
INSERT INTO susa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","عَ مَن نَشَ عَ مَسٍن عَ بّ، «ﭑ تَن نَن نَ عَلَ رَ سّنبّ كَنيِ. ﭑ دِ فبٍفبٍ قِمَ نّ عِ مَ، عَلَكٌ عِ شَ قِندِ سِ ندٍ بٍنبَ رَ. عِ مَن قِندِ مَ نّ سِ فبٍفبٍ بٍنبَ رَ. مَنفّيٍ قَمَ نّ مِنِدٍ عِ بْنسْي يَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ﭑ بْشِ نَشَن قِ عِبُرَهِمَ نُن عِسِيَفَ مَ، ﭑ بَرَ عَ قِ عِ قَن مَ، عَ نُن عِ بْنسْي مَ نَشَن قَمَ عِ شَنبِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","نَ نَن لَن، عَلَ نَشَ كٍلِ يِرٍ، عَ وْيّن يَشُبَ بّ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","يَشُبَ نَشَ فّمّ تْنشُمَ تِ نَا، عَ نَشَ تُرٍ نُن وّنِ عِقِلِ عَ مَ سّرّشّ رَ، عَلَكٌ عَ شَ قِندِ فّمّ مَفَاشُشِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","عَ نَشَ يِ يِرٍ شِلِ قَلَ بٍتٍلِ، عَلَ وْيّن عَ بّ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","يَشُبَ نُن عَ شَ دٍنبَيَ تٌ كٍلِ بٍتٍلِ، بٍينُ عٍ شَ مَكْرّ عٍقَرَتَ رَ، رَشٍلٍ نَشَ دِ سْتْ. نَ دِ بَرِقٍ نَشَ قِندِ عَ بّ قٍ شْرْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","رَشٍلٍ نُ نَ دِ بَرِ مَ تّمُي نَشّ شْنّ كُي، دِ رَ سُشُي نَشَ عَ قَلَ عَ بّ، «هَلِ عِ مُ فَاشُ، يِ بِيَاسِ عِ مَن شّمّ نَن بَرِشِ.» ");
INSERT INTO susa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","رَشٍلٍ نُ بَرَ لُ عَلْ مِشِ قَشَشِ. عَ نُ عَ نِي مَفَفَمَ تّمُي نَشّ، عَ نَشَ عَ شَ دِ شِلِ سَ بٍن عٌنِ، «نِمِسَ دِ.» كْنْ عَ بَبَ تَن نَشَ عَ شِلِ سَ بُنيَمِن، «دِ بَرَكَشِ.» ");
INSERT INTO susa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","رَشٍلٍ تٌ قَشَ، عٍ نَشَ عَ رَفَتَ عٍقَرَتَ كِرَ دّ. نَ يِرٍ شِلِ قَلَمَ نّ يَكْسِ بّتّلّيمُ. ");
INSERT INTO susa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","يَشُبَ نَشَ فّمّ سَ فَبُرِ قَرِ تْنشُمَ رَ، نَ نَ مّننِ هَن تٌ. ");
INSERT INTO susa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","عِسِرَيِلَ نَشَ سِفَ عَ سَ يٌنكِن مِفِدَلِ عٍدٍرِ شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","عِسِرَيِلَ نُ نَ مّننِ تّمُي نَشّ، رُبٍن نَشَ عَ بَبَ شَ فِنّ بِلَ كٌلٌن فِنّ رَ. عِسِرَيِلَ نَشَ كٌلٌن سْتْ نَ مَ. عِسِرَيِلَ دِ شّمّ قُ نُن قِرِن نَن سْتْ. ");
INSERT INTO susa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","لٍيَ نَشَ رُبٍن بَرِ دِ سِنفٍ، نَ شَنبِ رَ سِمٍيْن، لٍوِ، يُدَ، عِسَكَرِ، نُن سَبُلٌن. ");
INSERT INTO susa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","رَشٍلٍ نَشَ يُسُقُ نُن بُنيَمِن بَرِ. ");
INSERT INTO susa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","رَشٍلٍ شَ كٌنيِ بِلَ نَشَ نَقَتَلِ نُن دَنَ بَرِ. ");
INSERT INTO susa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","لٍيَ شَ كٌنيِ سِلِثَ نَشَ فَدِ نُن عَسٍرِ بَرِ. نٍيٍ بِرِن قِندِشِ يَشُبَ شَ دِيٍ نَن نَ، عَ نَشٍيٍ سْتْ ثَدَن عَرَ مِ. ");
INSERT INTO susa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","يَشُبَ نَشَ سِفَ عَ بَبَ عِسِيَفَ شْنيِ مَمِرٍ، كِرِيَتِ عَرَبَ مَبِرِ. مّننِ قَ شِلِ نّ كْرّ هٍبِرٌن. عِبُرَهِمَ نُن عِسِيَفَ سَبَتِ نّ نَا. ");
INSERT INTO susa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","عِسِيَفَ شَ سِمَيَ نُ بَرَ سِفَ حّ كّمّ حّ تٌنفٌ سٌلٌمَسَشَن. ");
INSERT INTO susa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","عَ تٌ فّ سِمَيَ شْنكُيٍ سْتْدٍ، عَ نَشَ قَشَ، عَ عَ بٍنبَيٍ مَسَفَتَ عَلِفِيَمَ. عَ شَ دِ عٍسَيُ نُن يَشُبَ نَشَ عَ رَفَتَ. ");
INSERT INTO susa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","عٍسَيُ، نَشَن مَن شِلِ قَلَمَ عٍدٌن، عَ شَ تَرُشُي نَن يَ. ");
INSERT INTO susa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عٍسَيُ كَنَان فِنّيٍ دْشْ نّ؛ عَدَ، نَشَن قِندِشِ عٍلٌن شِتِكَ شَ دِ رَ، نُن عٌهٌلِبَمَ، نَشَن قِندِشِ عَنَ شَ دِ رَ، سِبٍيٌن هِوِكَ شَ مَمَدِ. ");
INSERT INTO susa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","عَ نَشَ سُمَيِلَ شَ دِ فِنّ بَسَمَتِ قَن دْشْ، نٍبَيٌتِ شُنيَ فِنّمَ. ");
INSERT INTO susa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عٍلِقَسِ قِندِ عَدَ شَ دِ نَن نَ. رٍيُوٍلِ قِندِ بَسَمَتِ شَ دِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","عٌهٌلِبَمَ نَشَ دِ شّمّ سَشَن بَرِ عَ بّ؛ يٍيُسِ، يَلَمِ، نُن كٌرَ. نٍيٍ بِرِن قِندِ عٍسَيُ شَ دِيٍ نَن نَ نَشٍيٍ بَرِشِ كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","عٍسَيُ نَشَ عَ شَ فِنّيٍ شَنِن عَ شُن مَ، عَ شَ دِ فِنّيٍ، عَ شَ دِ شّمّيٍ، عَ شَ كٌنيِيٍ، عَ شَ شُرُ سٍيٍ، نُن عَ هَرِفٍ نَشَن بِرِن سْتْ كَنَان بْشِ مَ. عَ نَشَ عَ بِرِن شَنِن بْشِ فبّتّ مَ، دّننَشّ مَكُيَ عَ شُنيَ يَشُبَ يِرٍ رَ، ");
INSERT INTO susa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","بَرِ مَ عٍ هَرِفٍ نُ بَرَ فبٌ، عٍ مُ نُ نْمَ لُدٍ عٍ بٌورٍ سّيتِ مَ. عٍ نُ نَ دّننَشّ، عٍ شَ شُرُ سٍ بِرِن مُ نُ نْمَ حٌوفٍ سْتْدٍ. ");
INSERT INTO susa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","نَ نَن عَ تٌ عٍسَيُ، نَشَن قِندِ عٍدٌن نَ، عَ نَشَ سِفَ عَ سَ سَبَتِ سٍيِرِ فٍيَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","عٍسَيُ نَشَن قِندِ عٍدٌن بْنسْي بَبَ رَ، نَ نُ سَبَتِشِ فٍيَيٍ نَن مَ سٍيِرِ بْشِ مَ، عَ شَ تَرُشُي نَن يَ. ");
INSERT INTO susa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","عٍسَيُ شَ دِيٍ نَن يَ؛ عٍلِقَسِ، عَدَ نَشَن بَرِشِ عٍسَيُ بّ، رٍيُوٍلِ، بَسَمَتِ نَشَن بَرِشِ عٍسَيُ بّ. ");
INSERT INTO susa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","عٍلِقَسِ شَ دِيٍ نَن يَ؛ تٍمَن، عٌمَرُ، سٍقٌ، فَتَمِ، نُن كٍنَسِ. ");
INSERT INTO susa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","تِمِنَ، عٍلِقَسِ شَ كٌنيِ فِنّ، عَ عَمَلّكِ بَرِ نّ عٍلِقَسِ بّ. عٍسَيُ نُن عَ شَ فِنّ عَدَ شَ مَمَدِيٍ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","رٍيُوٍلِ شَ دِيٍ نَن يَ؛ نَشَتِ، سٍرَ، سَمَ، نُن مِسَ. عٍسَيُ نُن عَ شَ فِنّ بَسَمَتِ شَ مَمَدِيٍ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","عٍسَيُ شَ دِيٍ نَن يَ عٌهٌلِبَمَ نَشَن بَرِشِ عَ بّ؛ يٍيُسِ، يَلَمِ، نُن كٌرَ. عٌهٌلِبَمَ قِندِشِ عَنَ شَ دِ فِنّ نَن نَ. عَنَ قِندِشِ سِبٍيٌن شَ دِ فِنّ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","مَنفّ نَشٍيٍ كٍلِ عٍسَيُ بْنسْي نٍيٍ نَن يَ؛ عٍسَيُ شَ دِ سِنفٍ عٍلِقَسِ شَ دِيٍ نَن يَ؛ مَنفّيٍ تٍمَن، عٌمَرُ، سٍقٌ، كٍنَسِ، ");
INSERT INTO susa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","كٌرَ، فَتَمِ، نُن عَمَلّكِ. مَنفّيٍ نَن نَ كِ نَشٍيٍ قَتَنشِ عٍلِقَسِ عٍدٌنكَ رَ. عَدَ شَ مَمَدِيٍ نَن عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","عٍسَيُ شَ دِ رٍيُوٍلِ شَ دِيٍ نَن يَ؛ مَنفّيٍ نَشَتِ، سٍرَ، سَمَ، نُن مِسَ. مَنفّيٍ نَن نَ كِ نَشٍيٍ قَتَنشِ رٍيُوٍلِ عٍدٌنكَ رَ. بَسَمَتِ شَ مَمَدِيٍ نَن عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","عٍسَيُ شَ فِنّ عٌهٌلِبَمَ شَ دِيٍ نَن يَ؛ مَنفّيٍ يٍيُسِ، يَلَمِ، نُن كٌرَ. مَنفّيٍ نَن نَ كِ نَشٍيٍ قَتَنشِ عٍسَيُ شَ فِنّ عٌهٌلِبَمَ رَ. عٌهٌلِبَمَ نَن قِندِشِ عَنَ شَ دِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","عٍسَيُ، نَشَن مَن شِلِ قَلَمَ عٍدٌن، عَ شَ دِيٍ نَن نَ كِ، عَ نُن مَنفّ نَشٍيٍ قَتَنشِ عٍسَيُ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","سٍيِرِ شٌرِكَ شَ دِيٍ نَن يَ، نَشٍيٍ نُ نَ يِ بْشِ مَ؛ لٌتَن، سٌبَلِ، سِبٍيٌن، عَنَ، ");
INSERT INTO susa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","دِ سٌن، عٍسٍرِ، نُن دِ سَن. شٌرِ مَنفّيٍ نَن نَ كِ نَشٍيٍ قَتَنشِ سٍيِرِ بْنسْي رَ عٍدٌن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","لٌتَن شَ دِ شّمّيٍ نَن يَ؛ شٌرِ نُن هٍمَمِ تِمِنَ قِندِشِ لٌتَن شُنيَ فِنّمَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","سٌبَلِ شَ دِ شّمّيٍ نَن يَ؛ عَلِبَن، مَنَشَتِ، عٍبَلِ، سٍقٌ، نُن عٌنَن. ");
INSERT INTO susa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","سِبٍيٌن شَ دِ شّمّيٍ نَن يَ؛ عَيَ نُن عَنَ، نَشَن دُلٌنيِ قُرَشِيٍ تٌشِ فبٍنفبٍرٍن يِرٍ، عَ تٌ نُ سِبٍيٌن شَ سٌقَلٍيٍ دّ مَدٌنقٍ. ");
INSERT INTO susa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","عَنَ شَ دِيٍ نَن يَ؛ دِ سٌن نُن عٌهٌلِبَمَ، عَنَ شَ دِ فِنّ. ");
INSERT INTO susa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","دِ سٌن شَ دِ شّمّيٍ نَن يَ؛ هٍندَن، عٍسٍبَن، يِتِرَن، نُن كٍرَن. ");
INSERT INTO susa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","عٍسٍرِ شَ دِ شّمّيٍ نَن يَ؛ بِلِهَن، سَبَن، نُن عَكَن. ");
INSERT INTO susa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","دِ سَن شَ دِ شّمّيٍ نَن يَ؛ عُسِ نُن عَرَن. ");
INSERT INTO susa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","شٌرِ مَنفّيٍ نَن يَ؛ لٌتَن، سٌبَلِ، سِبٍيٌن، عَنَ، ");
INSERT INTO susa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","دِ سٌن، عٍسٍرِ، دِ سَن. شٌرِ مَنفّيٍ نَن نَ كِ سٍيِرِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","عٍدٌن مَنفّيٍ نَن يَ، نَشٍيٍ نُ نَ بٍينُ مَنفّ ندٍيٍ شَ لُ عِسِرَيِلَ؛ ");
INSERT INTO susa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بٍيٌرِ شَ دِ بٍلَ نَشَ قِندِ عٍدٌن مَنفّ رَ. عَ شَ تَا شِلِ نُ قَلَ نّ دِنهَبَ. ");
INSERT INTO susa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","بٍلَ تٌ قَشَ، سٍرَ شَ دِ يٌبَبٌ نَشَن كٍلِ بٌسَرَ، نَ نَشَ قِندِ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","يٌبَبٌ تٌ قَشَ، شُسَمَ نَشَن كٍلِ تٍمَن بْشِ مَ، نَ نَشَ قِندِ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","شُسَمَ تٌ قَشَ، بٍدَدَ شَ دِ هَدَدَ، نَشَن بَرَ نْ مَدِيَن نَ مٌوَبَ بْشِ مَ، نَ نَشَ قِندِ مَنفّ رَ. عَ شَ تَا شِلِ نُ قَلَ نّ عَبِتِ. ");
INSERT INTO susa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","هَدَدَ تٌ قَشَ، سَمَلَ مَسَرٍكَ نَشَ قِندِ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","سَمَلَ تٌ قَشَ، سَوُلُ رٍهٌبٌتِكَ، نَشَن نُ نَ شُرٍ دّ رَ، نَ نَشَ قِندِ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","سَوُلُ تٌ قَشَ، عَكِبٌرِ شَ دِ بَلِ هَنَن، نَ نَشَ قِندِ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","عَكِبٌرِ شَ دِ بَلِ هَنَن تٌ قَشَ، هَدَرَ نَشَ قِندِ مَنفّ رَ. عَ شَ تَا شِلِ نُ قَلَ نّ ثَوُ. عَ شَ فِنّ شِلِ نُ قَلَ نّ مٍهٍتَبٍلِ، مَتِرّدِ شَ دِ فِنّ، مٍسَهَبِ شَ مَمَدِ. ");
INSERT INTO susa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","مَنفّيٍ نَن يَ نَشٍيٍ كٍلِشِ عٍسَيُ بْنسْي مَ؛ تِمِنَ، عَلِبَ، يٍتٍتِ، ");
INSERT INTO susa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","عٌهٌلِبَمَ، عٍلَ، ثِنٌن، ");
INSERT INTO susa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","كٍنَسِ، تٍمَن، مِبِسَرِ، ");
INSERT INTO susa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","مَفَدِيّلِ، نُن عِرَ مِ. عٍدٌن مَنفّيٍ نُ مَنفّيَ رَحّرّ مَ عٍ شَ بْشِيٍ نَن مَ. عٍسَيُ شَ تَرُشُي نَن نَ كِ نَشَن قِندِشِ عٍدٌنكَيٍ بٍنبَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","يَشُبَ سَبَتِ نّ كَنَان بْشِ مَ، عَ بَبَ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","يَشُبَ بْنسْي شَ تَرُشُي نَن يَ. يُسُقُ، نَشَن شَ سِمَيَ نُ بَرَ حّ قُ نُن سٌلٌقٍرٍ لِ، عَ نُ شُرُ سٍيٍ نَن كَنتَمَ عَ نُن عَ تَارَيٍ، نُن عَ بَبَ شَ فِنّيٍ بِلَ نُن سِلِثَ شَ دِيٍ. يُسُقُ نُ عَ تَارَيٍ شَ قٍ حَاشِيٍ دّنتّفّ سَمَ عَ بَبَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","يُسُقُ نَن نُ رَقَن عِسِرَيِلَ مَ دَنفِ عَ شَ دِ بِرِن نَ، بَرِ مَ عَ تَن بَرِ عَ شَ شّمّقٌرِحَ نَن كُي. نَ كُي عَ نَشَ دٌنمَ كُيٍ تٌقَنيِ قِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","يُسُقُ تَارَيٍ نَشَ عَ كٌلٌن عٍ شُنيَ نَن نَقَن عٍ بَبَ مَ دَنفِ عٍ بِرِن نَ. عٍ نَشَ عَ رَحَاشُ قْلْ، عٍ مُ نُ وْيّن قَنيِ قَلَمَ عَ بّ كْرّ. ");
INSERT INTO susa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","نَ تّمُي يُسُقُ نَشَ شِيٍ ندٍ سَ. عَ تٌ نَ عِبَ عَ تَارَيٍ بّ، عٍ نَشَ عَ رَحَاشُ دَنفِقٍ عَ سِنفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","عَ نَشَ عَ قَلَ عٍ بّ، «وٌ تُلِ مَتِ ﭑ مَ شِيٍ رَ، ﭑ نَشَن سَشِ. ");
INSERT INTO susa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","وٌن بِرِن نُ نَ شّ نَن مَ مّنفِ رَشِرِدٍ. نَ نَن لَن، ﭑ مَ مّنفِ شِرِ نَشَ كٍلِ، عَ تِ. مّنفِ شِرِ نَشٍيٍ نُ سُشُشِ وٌ تَن يِ رَ، عٍ نَشَ ﭑ فبٍ شِرِ رَبِلِن، عٍ بِرِن قَ عٍ كُنتِن ﭑ مَ شِرِ بُن.» ");
INSERT INTO susa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","عَ تَارَيٍ نَشَ عَ مَشْرِن، «ثٍ، عِ وَ مَ قِندِقٍ مُشُ شَ مَنفّ نَن نَ، عَلَكٌ عِ شَ نُ مُشُ يَمَرِ؟» عٍ نَشَ عَ رَحَاشُ دَنفِقٍ عَ سِنفٍ رَ عَ شَ شِيٍ نُن عَ شَ مَسٍنيِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","يُسُقُ تٌ شِيٍ فبّتّ سَ، عَ نَشَ نَ قَن عِبَ عَ تَارَيٍ بّ. عَ نَشَ عَ قَلَ عٍ بّ، «ﭑ مَن بَرَ شِيٍ سَ. سٌفٍ، كِكٍ، نُن تُنبُي قُ نُن كٍرٍن نُ نَ ﭑ بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","عَ نَشَ نَ شِيٍ تَفِ رَبَ عَ بَبَ نُن عَ تَارَيٍ بّ. عَ بَبَ نَشَ شَاحّ عَ مَ، عَ قَ عَ قَلَ عَ بّ، «عِ شِيٍ نَشَن سَشِ يِ كِ، عَ قِندِشِ شِيٍ مْولِ مُندُن نَ؟ عِ وَشِ نّ عِ نفَ، عِ تَارَيٍ، نُن ﭑ تَن، مُشُ شَ قَ مُشُ عِفٌرٌدٍ بْشِ مَ عِ بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","عَ تَارَيٍ نَشَ بِرَ عَ تْونّ قٍ قْشْ رَ، كْنْ عَ بَبَ نَشَ عَ حّنفِ سَ عَ شِيٍ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","يُسُقُ تَارَيٍ نَشَ سِفَ سِكٍمِ عٍ بَبَ شَ شُرُ سٍيٍ دّ مَدٌندٍ. ");
INSERT INTO susa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","عِسِرَيِلَ نَشَ عَ قَلَ يُسُقُ بّ، «عِ تَارَيٍ بَرَ سِفَ شُرُ سٍيٍ دّ مَدٌندٍ سِكٍمِ. ﭑ نَشَن نَبَمَ، ﭑ شَ عِ شّي عٍ شْن مَ.» يُسُقُ نَشَ عَ يَابِ، «عَوَ.» ");
INSERT INTO susa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","عِسِرَيِلَ نَشَ عَ مَسٍن عَ بّ، «سِفَ مَقُرٍن عِ شَ سَ عَ مَتٌ شَ عِ تَارَيٍ مُ قُرَشِ، شَ سٍ مُ شُرُ سٍيٍ قَن تٌشِ عَلَكٌ عِ شَ قَ نَ دّنتّفّ سَ ﭑ بّ.» عَ نَشَ عَ شّي كٍلِ هٍبِرٌن لَنبَنيِ سِفَقٍ رَ سِكٍمِ. ");
INSERT INTO susa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","شّمّ ندٍ نَشَ يُسُقُ تٌ سِكٍمِ بْشِ مَ، عَ نَ حّرّقٍ وُلَ عِ. نَ شّمّ نَشَ عَ مَشْرِن، «عِ مُنسٍ قٍنقٍ؟» ");
INSERT INTO susa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","عَ نَشَ عَ يَابِ، «ﭑ نَ ﭑ تَارَيٍ نَن قٍنقٍ. يَندِ، عَ قَلَ ﭑ بّ عٍ نَ شُرُ سٍيٍ دّ مَدٌنقٍ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","نَ شّمّ نَشَ عَ قَلَ عَ بّ، «عٍ مُ نَ بٍ. ﭑ بَرَ عٍ شُي مّ عَ قَلَ رَ عٍ شَ سِفَ دٌتَن.» نَ كُي يُسُقُ نَشَ بِرَ عَ تَارَيٍ قْشْ رَ هَن عَ سَ عٍ لِ دٌتَن. ");
INSERT INTO susa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","عٍ تٌ سَ عَ تٌ يِرٍ مَكُيٍ، عٍ نَشَ لَن عَ مَ عٍ شَ عَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","عٍ نُ قَ عَ قَلَ رَ عٍ بٌورٍ بّ، «يِ شِيٍ سَ مَنفّ نَن نَ قَقٍ يِ كِ. ");
INSERT INTO susa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","وٌ قَ بٍ، وٌن شَ عَ قَشَ، وٌن شَ عَ رَفٌرٌ كْلْنيِ ندٍ كُي. وٌن نْمَ عَ قَلَدٍ سُبٍ شَاحّ ندٍ بَرَ عَ عِبْو. نَ تّمُي وٌن قَمَ عَ كٌلٌندٍ عَ شَ شِيٍ قِندِ مَ عَ بّ قٍ نَشَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","رُبٍن تٌ نَ مّ، عَ نَشَ عَ بَ عٍ يِ رَ يِ مَسٍنيِ رَ، «وٌن نَشَ عَ قَشَ دٍ. ");
INSERT INTO susa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","عَ مُ لَنمَ وٌ شَ عَ وُلِ رَ مِنِ. وٌ شَ عَ رَفٌرٌ يِ كْلْنيِ كُي نَشَن نَ يِ فبٍنفبٍرٍن يِرٍ. مِشِ يٌ نَشَ عَ بّلّشّ دِن عَ رَ.» عَ نُ وَ مَ عَ بَقٍ نّ عٍ يِ رَ عَلَكٌ عَ شَ نْ عَ رَفبِلٍندٍ عَ بَبَ شْن. ");
INSERT INTO susa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","يُسُقُ تٌ عَ تَارَيٍ يِرٍ لِ، عٍ نَشَ عَ شَ دٌنمَ كُيٍ تٌقَنيِ رَتٍ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","عٍ نَشَ يُسُقُ رَفٌرٌ كْلْنيِ ندٍ كُي، يٍ مُ نُ نَ نَشَن كُي. ");
INSERT INTO susa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","نَ دَنفِ شَنبِ، عٍ نُ نَ عٍ دّفٍقٍ تّمُي نَشّ، عٍ نَشَ سُمَيِلَ دِ ندٍيٍ تٌ قَ رَ كٍلِقٍ فَلٍدٍ. عٍ نُ نَ سُرَيِ، سٍرِ، نُن لَبُندّ شَنِنقٍ مِسِرَ بْشِ مَ حْشْمّيٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","يُدَ نَشَ عَ مَسٍن عَ شُنيَيٍ بّ، «وٌن نَ وٌن شُنيَ قَشَ فُندٌ كُي، نَ مُنسٍ قَنمَ وٌن تَن مَ؟ ");
INSERT INTO susa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","وٌ قَ، وٌن شَ عَ مَتِ سُمَيِلَ بْنسْي مِشِيٍ مَ. وٌن نَشَ عَ قَشَ، بَرِ مَ وٌن شُنيَ نَ عَ رَ. وٌن وُلِ كٍرٍن قَسّ كٍرٍن.» عَ شُنيَيٍ بِرِن نَشَ تِن عَ شَ مَسٍنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","نَ مَدِيَن يُلّيٍ تٌ عٍ يِرٍ لِ، يُسُقُ تَارَيٍ نَشَ عَ رَتٍ كْلْنيِ كُي، عٍ قَ عَ مَتِ نٍيٍ مَ كْبِرِ كٌلٍ مْشْحّن نَ. نَ يُلّ نَشٍيٍ قَتَنشِ سُمَيِلَ بْنسْي رَ، نٍيٍ نَشَ يُسُقُ شَنِن مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","نَ دَنفِ شَنبِ رُبٍن نَشَ فبِلٍن كْلْنيِ يِرٍ يُسُقُ قْشْ رَ، كْنْ عَ مُ عَ لِ نَا. عَ نَشَ عَ شَ دٌنمَ بِرِن عِبْو عَ مَ سُننُنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","عَ نَشَ فبِلٍن عَ شُنيَيٍ يِرٍ، عَ عَ قَلَ عٍ بّ، «يُسُقُ مُ نَ يِرٍ وٌن نَ لُ دّننَشّ، ﭑ قَ مُنسٍ رَبَمَ كْرّ؟» ");
INSERT INTO susa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","عٍ نَشَ سِ كٍرٍن قَشَ، عٍ قَ يُسُقُ شَ دٌنمَ كُيٍ تٌقَنيِ مَتُرُشُن نَ سُبٍ وُلِ. ");
INSERT INTO susa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","نَ شَنبِ، عٍ نَشَ نَ دٌنمَ كُيٍ تٌقَنيِ شَنِن عٍ بَبَ شْن مَ. عٍ نَشَ عَ قَلَ عَ بّ، «مُشُ بَرَ يِ تٌ. يِ دٌنمَ مَتٌ بَ شَ عِ شَ دِ نَن فبٍ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","يَشُبَ نَشَ نَ دٌنمَ كٌلٌن، عَ قَ عَ قَلَ، «ﭑ مَ دِ شَ دٌنمَ نَ عَ رَ! وُلَ سُبٍ شَاحّ ندٍ بَرَ ﭑ مَ دِ يُسُقُ قَشَ! عَ بَرَ عَ عِبْو!» ");
INSERT INTO susa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","يَشُبَ نَشَ عَ شَ دٌنمَ عِبْو عَ مَ سُننُنيِ كُي. عَ نَشَ سُننُن دُفِ رَفٌرٌ عَ مَ، عَ عَ شَ دِ حْن قٍ رَبَ شِ وُيَشِ. ");
INSERT INTO susa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","عَ شَ دِ شّمّيٍ نُن عَ شَ دِ فِنّيٍ نَشَ قٍ بِرِن نَبَ عَ بّ عَلَكٌ سُننُنيِ شَ بَ عَ مَ، كْنْ يَشُبَ مُ دُندُ. عَ نَشَ عَ قَلَ، «ﭑ نَن ﭑ مَ دِ شَ سُننُنيِ شَنِنمَ هَن ﭑ سَ عَ لِمَ تّمُي نَشّ عَلِفِيَمَ.» يَشُبَ نَشَ وَ عَ شَ دِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","مَدِيَنكَيٍ تٌ مِسِرَ لِ، عٍ نَشَ يُسُقُ مَتِ ثٌتِقَرِ مَ، نَشَن قِندِشِ مِسِرَ مَنفّ كَنتَمِشِيٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","نَ تّمُي، يُدَ نَشَ كٍلِ عَ نفَشَكٍرٍنيِيٍ شُن مَ، عَ سِفَ عَدُلَمَكَ ندٍ شْنيِ نَشَن شِلِ هِرَ. ");
INSERT INTO susa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","مّننِ يُدَ نَشَ سُوَ كَنَانكَ شَ دِ فِنّ تٌ. عَ نَشَ عَ قِندِ عَ شَ فِنّ رَ. عٍ نَشَ لُ عٍ بٌورٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","نَ فِنّ نَشَ تّيفّ، عَ نَشَ دِ شّمّ بَرِ. يُدَ نَشَ نَ دِ شِلِ سَ عٍرِ. ");
INSERT INTO susa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","تَمَرِ مَن نَشَ تّيفّ دِ قِرِن ندٍ مَ، عَ نَشَ دِ شّمّ بَرِ. عَ نَشَ نَ دِ شِلِ سَ عٌنَن. ");
INSERT INTO susa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","نَ شَنبِ، عَ مَن نَشَ دِ شّمّ فبّتّ بَرِ. عَ نَشَ نَ دِ شِلِ سَ سٍلَهَ. يُدَ شَ فِنّ نَ دِ بَرِ كٍسِبٍ نّ. ");
INSERT INTO susa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","يُدَ نَشَ فِنّ ندٍ قٍن، عَ عَ سٌ عَ شَ دِ سِنفٍ عٍرِ يِ رَ. نَ فِنّ شِلِ تَمَرِ. ");
INSERT INTO susa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","مِشِ كٌبِ نَن نُ لَنشِ يُدَ شَ دِ سِنفٍ عٍرِ مَ عَلَتَلَ يَ عِ. عَلَتَلَ نَشَ عَ رَفِرِ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","نَ شَنبِ يُدَ نَشَ عَ قَلَ عٌنَن بّ، «عِ تَارَ شَ فِنّ تٌنفٌ، عَ شَ قِندِ عِ شَ فِنّ رَ. عِ شَ نِمْشْ وَلِ رَبَ، عَلَكٌ عِ شَ دِ قِ عِ تَارَ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","كْنْ عٌنَن عَ كٌلٌن نَ دِ مُ قَمَ قِندِدٍ عَ فبٍ رَ. نَ نَن عَ تٌ، عٍ نُن عَ نِمْشْ نَ كَقُ، عَ عَ شَ مَنِيٍ سَمَ بْشِ نَن مَ عَلَكٌ عَ نَشَ قَ دِ قِ عَ تَارَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","عَ نُ نَشَن نَبَمَ، نَ مُ نُ رَقَن عَلَتَلَ مَ. نَ نَن عَ رَ، عَلَ نَشَ عَ رَفِرِ عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","نَ تّمُي يُدَ نَشَ عَ قَلَ عَ شَ مَمَدِ تَمَرِ بّ، «كَاحّ شَنِن عِ بَبَ شْنيِ، بٍينُن ﭑ مَ دِ سٍلَهَ مْمَ تّمُي نَشّ.» عَ عَ مَحْشُن نّ، تّمُندٍ سٍلَهَ قَن قَشَمَ عَلْ عَ تَارَيٍ قَشَشِ كِ نَشّ. نَ كُي تَمَرِ نَشَ سِفَ، عَ سَ لُ عَ بَبَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","عَ مُ بُ يُدَ شَ فِنّ نَشَ قَ، نَشَن نُ لَنشِ سُوَ شَ دِ فِنّ مَ. حْن قٍ تٌ بَ عَ رَ، يُدَ نَشَ سِفَ تِمِنَ عٍ نُن عَ بٌورٍ هِرَ عَدُلَمَكَ. عٍ نَشَ سِفَ يُدَ شَ شُرُ سٍ يِرٍ، يُدَ شَ وَلِكّيٍ نُ شُرُ سٍيٍ شَبٍ مَشَبَقٍ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","مِشِ ندٍ نَشَ عَ قَلَ تَمَرِ بّ، «عِ تَنُن نَ سِفَقٍ تِمِنَ عَ شَ شُرُ سٍيٍ شَبٍ مَشَبَدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","تَمَرِ نَشَ عَ شَ كَاحّ دٌنمَ رَتٍ عَ مَ، عَ نَشَ عَ يَتَفِ مَكٌتٌ مَقٍلٍنيِ رَ، عَ سَ دْشْ عٍنَيِمَ سٌدٍ دّ رَ تِمِنَ كِرَ شْن. عَ نُ بَرَ عَ تٌ، سٍلَهَ بَرَ عَ فِنّ دْشْدٍ لِ، كْنْ يُدَ مُ تَمَرِ قِ عَ مَ، عَ شَ قِندِ عَ شَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","يُدَ تٌ بَرَ تَمَرِ تٌ كِرَ دّ رَ، عَ يَتَفِ مَكٌتٌشِ مَقٍلٍنيِ رَ، عَ نَشَ عَ مَحْشُن لَنفٌي رَ. ");
INSERT INTO susa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","عَ نَشَ عَ قَلَ عَ بّ كِرَ رَ، «وٌن شّي، وٌن شَ سَ كَقُ.» عَ مُ نُ عَ كٌلٌنشِ عَ شَ مَمَدِ نَن عَ رَ. كْنْ تَمَرِ نَشَ يُدَ مَشْرِن، «عِ مُنسٍ قِمَ ﭑ مَ وٌن نَ كَقُ؟» ");
INSERT INTO susa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","عَ نَشَ عَ يَابِ، «ﭑ سِ كٍرٍن تٌنفٌمَ ﭑ مَ شُرُ سٍيٍ يَ مَ، ﭑ قَ عَ رَ عِ شْن مَ.» تَمَرِ نَشَ عَ يَابِ، «عَوَ، سّيكّ سٍ ندٍ لُ ﭑ يِ رَ بٍ سِندٍن، بٍينُن عِ قَمَ سِ رَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","عَ نَشَ عَ مَشْرِن، «عِ وَ مَ ﭑ شَ مُنسٍ دْشْ عِ شْن مَ سّيكّ رَ؟» تَمَرِ نَشَ عَ يَابِ، «عِ شَ عِ شَ تْنشُمَ، عَ لُوتِ، نُن عِ شَ يِسُشُوُرِ سٌ ﭑ يِ رَ.» عَ نَشَ نَ سٍيٍ سٌ عَ يِ رَ، عٍ قَ كَقُ عٍ بٌورٍ رَ. تَمَرِ نَشَ تّيفّ عَ شَ دِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","تَمَرِ نَشَ فبِلٍن عَ شْنيِ. عَ نَشَ عَ شَ مَقٍلٍنيِ بَ عَ شُن مَ، عَ مَن نَشَ عَ كَاحّ فِنّ دٌنمَ رَفٌرٌ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","يُدَ نَشَ عَ بٌورٍ عَدُلَمَكَ شّي سِ تِدٍ نَ فِنّ مَ، عَلَكٌ عَ شَ قَ سٍيٍ رَ عَ نَشَن سٌ فِنّ يِ رَ سٍيدٍحْشْيَ رَ. كْنْ عَ بٌورٍ مُ نَ فِنّ تٌ. ");
INSERT INTO susa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","عَ نَشَ عٍنَيِمَ مِشِيٍ مَشْرِن، «يِ لَنفٌي فِنّ نَشَن نُ نَ عٍنَيِمَ كِرَ رَ، عَ نَ مِندٍن؟» عٍ نَشَ عَ يَابِ، «لَنفٌي يٌ مُ نَ بٍ.» ");
INSERT INTO susa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","عَ نَشَ فبِلٍن يُدَ يِرٍ، عَ قَ عَ قَلَ، «ﭑ مُ عَ لِشِ نَا. نَ لٌنفٌرِ مِشِيٍ بَرَ عَ قَلَ ﭑ بّ عَ لَنفٌي يٌ مُ نَ نَ كِرَ شْن.» ");
INSERT INTO susa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","يُدَ نَشَ عَ قَلَ، «نَ فِنّ شَ نَ سٍيٍ رَفَتَ. وٌن قَن نَشَ وٌن يّتّ رَيَافِ. ﭑ بَرَ سِ رَ سَنبَ عَ مَ، كْنْ عِ مُ عَ لِشِ نَا.» ");
INSERT INTO susa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","كِكٍ سَشَن دَنفِ شَنبِ، مِشِ ندٍ نَشَ عَ قَلَ يُدَ بّ، «عِ شَ مَمَدِ تَمَرِ بَرَ قِندِ لَنفٌي رَ، عَ بَرَ قُرِ تٌنفٌ عَ شَ لَنفٌيحَ سَابُي رَ.» يُدَ نَشَ عَ قَلَ، «وٌ عَ رَ مِنِ، عَ شَ فَن.» ");
INSERT INTO susa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","عٍ نُ قَقٍ عَ رَ تّمُي نَشّ، تَمَرِ نَشَ شّيرَ رَ سَنبَ عَ تَنُن مَ، «يِ سٍيٍ مَتٌ نَشَن نَ ﭑ يِ رَ. يِ تْنشُمَ، عَ لُوتِ، نُن يِ يِسُشُوُرِ قِندِ مِشِ نَن فبٍ رَ نَشَن ﭑ نَقُرُشِ. عِ لَن نّ عِ شَ يِ كَنيِ كٌلٌن.» ");
INSERT INTO susa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","يُدَ نَشَ كٌلٌن سْتْ نَ سٍيٍ شَ قٍ مَ. عَ نَشَ عَ قَلَ، «عَ بَرَ سّرِيّ رَكَمَلِ دَنفِقٍ ﭑ تَن نَ بَرِ مَ ﭑ مُ عَ قِشِ ﭑ مَ دِ سٍلَهَ مَ.» نَ شَنبِ، عَ مُ عَ كٌلٌن فِنّ رَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","تَمَرِ نُ دِ بَرِ مَ تّمُي نَشّ، عٍ نَشَ عَ كٌلٌن عَ فُلِيٍ نَن نَ عَ قُرِ. ");
INSERT INTO susa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","دِ بَرِ تّمُي، كٍرٍن نَشَ عَ بّلّشّ رَ مِنِ. دِ رَ سُشُي نَشَ عَ بّلّشّ سُشُ، عَ فّسّ فبٍيلِ شِرِ عَ بّلّشّ رَ. عَ قَ عَ قَلَ، «يِ نَن سِنفٍ بَرِشِ.» ");
INSERT INTO susa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","كْنْ نَ دِيْرّ نَشَ عَ بّلّشّ رَ سٌ، عَ شُنيَ نَشَ بَرِ. دِ رَ سُشُي نَشَ عَ قَلَ، «عِ قَشِ سّنبّ مُندُن نَ يِ كِ؟» يُدَ نَشَ عَ شِلِ سَ ثٍرٍ سِ. ");
INSERT INTO susa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","نَ شَنبِ، بٌورٍ قَن نَشَ بَرِ فّسّ فبٍيلِ شِرِشِ عَ بّلّشّ رَ. يُدَ نَشَ عَ شِلِ سَ سٍرَ. ");
INSERT INTO susa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","سُمَيِلَ بْنسْييٍ تٌ يُسُقُ شَنِن مِسِرَ، مِسِرَ مَنفّ كَنتَمَيٍ شُنيِ ثٌتِقَرِ نَشَ عَ سَرَ كٌنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","عَلَتَلَ نُن يُسُقُ نَن نُ عَ رَ. يُسُقُ نُ قٍ نَشَن بِرِن نَبَمَ عَ شَ مَنفّ مِسِرَكَ شْنيِ، عَ بِرِن نُ قَنمَ نّ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","عَ شَ مَنفّ نَشَ عَ كٌلٌن عَ يُسُقُ نُن عَلَتَلَ نَ عَ رَ، بَرِ مَ عَلَتَلَ نُ قٍ بِرِن سْونّيَمَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ثٌتِقَرِ نَشَ حّلّشِن عَ رَ، عَ نَشَ عَ قِندِ عَ شَ بَنشِ مِشِيٍ شُنيِ رَ. عَ نَشَ عَ هَرِفٍ بِرِن تَشُ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ثٌتِقَرِ تٌ يُسُقُ قِندِ عَ شَ بَنشِ نُن عَ هَرِفٍ شُنيِ رَ، عَلَتَلَ نَشَ بَرَكّ سَ نَ مِسِرَكَ شَ بَنشِ مَ يُسُقُ سَابُي رَ. عَلَتَلَ نَشَ بَرَكّ سَ ثٌتِقَرِ شَ بَنشِ نُن عَ شَ شّيٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","نَ نَن عَ تٌ، ثٌتِقَرِ نَشَ عَ شَ سٍ بِرِن تَشُ يُسُقُ رَ. عَ تَن مُ نُ قَ عَ حّنفِ سَشِ قٍقٍ شْن مَ، قٌ عَ نُ دٌنسٍ نَشَن دٌنمَ. مِشِ تٌقَنيِ نَن نُ لَنشِ يُسُقُ مَ. ");
INSERT INTO susa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","تّمُي ندٍ تٌ دَنفِ، يُسُقُ شَ مَنفّ شَ فِنّ يَ نَشَ سِن عَ عِ. عَ نَشَ عَ قَلَ عَ بّ، «قَ بٍ، وٌن شَ قَ كَقُ.» ");
INSERT INTO susa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","يُسُقُ نَشَ تٌندِ، عَ قَ عَ قَلَ عَ شَ مَنفّ شَ فِنّ بّ، «كَقِ ﭑ نَشَ قَ ﭑ مَ مَنفّ شْنيِ عَ مُ عَ حّنفِ سَشِ قٍقٍ شْن مَ كْرّ عَ شَ بَنشِ كُي. عَ بَرَ عَ هَرِفٍ بِرِن تَشُ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","عَ شَ بَنشِ كُي بٍ، ﭑ تَن نَن دَنفِ مِشِ بِرِن نَ. عَ مُ سٍسٍ رَقِسَشِ ﭑ بّ، قٌ عِ كٍرٍن، بَ عِ تَن بَرَ قِندِ عَ شَ فِنّ رَ. يَكْسِ، ﭑ قٍ حَاشِ رَبَمَ مُنقٍ رَ نَشَن قِندِ يُنُبِ قٍ رَ عَلَ بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","كْنْ نَ فِنّ نَشَ بِرَ يُسُقُ شَ قٍ دَلِلِ قْشْ رَ. عَ نُ عَ مَكَتَمَ لْشْي بِرِن، كْنْ يُسُقُ نَشَ تٌندِ عٍ شَ كَقُ. ");
INSERT INTO susa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","لْشْي ندٍ يُسُقُ نَشَ سٌ بَنشِ كُي عَ شَ وَلِ رَبَدٍ. كٌنيِ فبّتّ يٌ مُ نُ نَ بَنشِ كُي نَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ثٌتِقَرِ شَ فِنّ نَشَ عَ سُشُ عَ شَ دٌنمَ مَ. عَ نُ قَ عَ قَلَ عَ بّ، «وٌن كَقُ!» فِنّ تٌ يُسُقُ شَ دٌنمَ سُشُ، يُسُقُ نَشَ مِنِ عَ شَ دٌنمَ كُي عَ عَ لُ فِنّ بّلّشّ، عَ مِنِ عَ فِ رَ تَندٍ. ");
INSERT INTO susa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","فِنّ تٌ بَرَ عَ كٌلٌن عَ بَرَ عَ فِ، عَ شَ دٌنمَ لُ عَ يِ رَ، عَ نَشَ مِنِ تَندٍ، ");
INSERT INTO susa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","عَ نَشَ عَ شَ بَنشِ كٌنيِيٍ شِلِ، عَ قَ نَ دٌنمَ مَسٍن عٍ بّ، «وٌ يِ تٌ، ﭑ مَ شّمّ قَشِ عٍبُرُ نَشَن نَ، نَ نَن وَ مَ وٌن مَيَنقَقٍ كْوتَ رَ. عَ قَشِ نّ ﭑ يِرٍ عَ مُشُ شَ مُشُ سَ، كْنْ ﭑ نَشَ سْنشْي رَتٍ. ");
INSERT INTO susa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","كَبِ ﭑ بَرَ سْنشْي رَتٍ، عَ نَشَ عَ فِ، عَ شَ دٌنمَ لُ ﭑ يِ رَ. عَ نَشَ مِنِ عَ فِ رَ تَندٍ.» ");
INSERT INTO susa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ثٌتِقَرِ شَ فِنّ نَشَ يُسُقُ شَ دٌنمَ رَفَتَ هَن بٍينُن عَ شَ مَنفّ سٌ تّمُي. ");
INSERT INTO susa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","عَ نَشَ نَ قٍ تَفِ رَبَ عَ بّ، عَ نَشّ، «عِ قَشِ عٍبُرُ كٌنيِ شّمّ نَشَن نَ يِ كِ، عَ قَشِ نّ عَ شَ ﭑ مَيَنقَ كْوتَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","كْنْ ﭑ تٌ سْنشْي رَتٍ، عَ نَشَ عَ شَ دٌنمَ لُ ﭑ يِ رَ، عَ نَشَ مِنِ عَ فِ رَ تَندٍ. ");
INSERT INTO susa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","عِ شَ كٌنيِ نَ نَن نَبَشِ ﭑ نَ.» يُسُقُ شَ مَنفّ تٌ عَ شَ فِنّ شَ وْيّنيِ مّ، ");
INSERT INTO susa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","عَ بْحّ نَشَ تٍ عَ حَاشِ رَ. عَ نَشَ يُسُقُ بَلَن مَنفّ شَ فٍيلِمَنِيٍ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","كْنْ مّننِ قَن، عَلَتَلَ مّينِ نّ عَ مَ. عَ نَشَ عَ رَفِرِ يُسُقُ نُن فٍيلِ مَنفّ دّ شَ قَن. ");
INSERT INTO susa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","فٍيلِ مَنفّ نَشَ فٍيلِمَنِيٍ تَشُ يُسُقُ رَ. قٍ نَشَن بِرِن نُ رَبَمَ، عَ نُ دَنفِمَ عَ تَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","فٍيلِ مَنفّ مُ نُ يُسُقُ شَ وَلِ شُن مَتٌمَ عَ رَ، بَرِ مَ عَلَتَلَ نُن يُسُقُ بِرِن نَ عَ رَ. عَلَتَلَ نُ قٍ بِرِن سْونّيَمَ يُسُقُ بّ. ");
INSERT INTO susa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","نَ دَنفِ شَنبِ مِسِرَ مَنفّ شَ وَلِكّ نَشَن عَ حّنفِ سَشِ عَ شَ مِنسٍ شْن مَ، عَ نُن عَ شَ تَامِفَنيِ نَشَ قٍ ندٍ رَبَ نَشَن مُ رَقَنشِ عٍ شَ مَنفّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","مِسِرَ مَنفّ نَشَ شْنْ نَ وَلِكّ قِرِنيِيٍ مَ، نَشَن حّنفِ سَمَ عَ شَ مِنسٍ شْن مَ عَ نُن نَشَن عَ شَ تَامِ فَنمَ. ");
INSERT INTO susa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","عَ نَشَ عٍ سُشُ، عٍ بَلَن سْورِ مَنفّ شَ فٍيلِ كُي، يُسُقُ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","سْورِيٍ شَ مَنفّ نَشَ عٍ تَشُ يُسُقُ رَ، عَ شَ مّينِ عٍ مَ. عٍ تٌ سَشَنيِ رَبَ فٍيلِ كُي، ");
INSERT INTO susa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","نَشَن حّنفِ سَمَ مَنفّ شَ مِنسٍ شْن مَ، عَ نُن نَشَن تَامِ فَنمَ مَنفّ بّ، نٍيٍ نَشَ شِيٍ سَ فٍيلِ كُي كْي كٍرٍن نَ. كَنكَن شَ شِيٍ نُ وَ مَ قٍ ندٍ نَن مَسٍنقٍ عَ كَنيِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","نَ كُيٍ عِبَ يُسُقُ نَشَ قَ عٍ يِرٍ، عَ نَشَ عٍ لِ سُننُنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","نَ تّمُي عَ نَشَ نَ مِسِرَ مَنفّ شَ وَلِكّ قِرِنيِيٍ مَشْرِن، نَشٍيٍ تَشُشِ عَ رَ، «مُنقٍ رَ وٌ سُننُنشِ تٌ؟» ");
INSERT INTO susa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","عٍ نَشَ عَ يَابِ، «مُشُ بَرَ شِيٍ ندٍيٍ نَن سَ، كْنْ مِشِ يٌ مُ نَ بٍ نَشَن نْمَ نَ قَسَرِدٍ.» يُسُقُ نَشَ عَ قَلَ عٍ بّ، «وٌ مُ عَ كٌلٌن عَلَ نْمَ عَ قَسَرِدٍ وٌ بّ؟ وٌ شِيٍ قَلَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","نَشَن حّنفِ نُ سَمَ مَنفّ شَ مِنسٍ شْن مَ، عَ نَشَ عَ شِيٍ قَلَ يُسُقُ بّ. عَ نَشّ، «ﭑ تَن مَ شِيٍ كُي، ﭑ وّنِ بِلِ نَن تٌ عَ تِشِ ﭑ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","سَلٌن سَشَن نَ عَ بِلِ مَ. عَ تٌ قُفَ، عَ قُفٍ نَشَ وّنِ بٌفِ مْشِيٍ رَ مِنِ. ");
INSERT INTO susa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","مِسِرَ مَنفّ شَ وّنِ سَسٍ سُشُشِ ﭑ يِ رَ. ﭑ نَشَ نَ وّنِ بٌفِ مْشِيٍ بَ، ﭑ نَشَ عٍ بُندُ مِسِرَ مَنفّ شَ وّنِ سَسٍ كُي، ﭑ قَ عَ سٌ عَ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","يُسُقُ نَشَ عَ قَلَ عَ بّ، «يِ شِيٍ يِ نَن قَسَرِشِ؛ نَ سَلٌنيِ سَشَن نَشَن نَ كِ، عَ شِ سَشَن نَن مَسٍنشِ. ");
INSERT INTO susa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","شِ سَشَن دَنفِ شَنبِ، مِسِرَ مَنفّ عِ شُن نَكٍلِمَ نّ، عَ مَن قَ عِ رَفبِلٍن عِ وَلِدٍ قٌرِ. عِ مَن قَمَ نّ وّنِ تْنبِلِ سٌدٍ مِسِرَ مَنفّ يِ رَ عَلْ عِ دَرِشِ عَ رَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","كْنْ عِ نَشَ نّيمُ ﭑ مَ عِ نَ هّيرِ سْتْ تّمُي نَشّ. عِ شَ قِندِ سَابُي رَ ﭑ بّ، عِ شَ ﭑ مَ قٍ قَلَ مِسِرَ مَنفّ بّ عَلَكٌ ﭑ شَ مِنِ فٍيلِ كُي، ");
INSERT INTO susa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","بَرِ مَ عٍ ﭑ تٌنفٌشِ نْي نَن نَ عٍبُرُ بْشِ مَ. بٍ قَن، ﭑ مُ قٍقٍ رَبَشِ نَشَن عَ نِيَمَ ﭑ شَ فٍيلِ سْتْ.» ");
INSERT INTO susa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","نَشَن تَامِ فَنمَ مَنفّ بّ، عَ تٌ بَرَ عَ تٌ يُسُقُ وْيّنيِ نَشَن تَفِ رَبَشِ عَ بٌورٍ بّ، عَ قَنشِ عَ بّ، عَ نَشَ عَ قَلَ يُسُقُ بّ، «ﭑ تَن قَن شِيٍ ندٍ سَشِ. دٍبٍ سَشَن دْشْشِ ﭑ شُن مَ، تَامِ قِيشّ نَ عٍ كُي. ");
INSERT INTO susa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","دٍبٍ نَشَن دْشْشِ عَ قَرِ، تَامِفَنيِ دٌنسٍ نَشَن بِرِن نَقَلَمَ مِسِرَ مَنفّ بّ، عَ بِرِن نُ نَ عَ كُي. كْنْ شْنِيٍ نُ قَ نَ دٌنسٍ مَسَكُن نَشَن دْشْشِ ﭑ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","يُسُقُ نَشَ عَ مَسٍن عَ بّ، «عِ شَ شِيٍ يِ نَن قَسَرِشِ؛ نَ دٍبٍ سَشَنيِ نَشَن نَ كِ، عَ شِ سَشَن نَن مَسٍنشِ. ");
INSERT INTO susa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","شِ سَشَن دَنفِ شَنبِ، مِسِرَ مَنفّ عِ شُنيِ بٌلٌنمَ نّ عَ دّ عِ. عَ عِ فبَكُمَ نّ وُرِ مَ، شْنِيٍ عِ سُبٍ مَسَكُن.» ");
INSERT INTO susa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","شِ سَشَن لْشْي، مِسِرَ مَنفّ بَرِ لْشْي، مَنفّ نَشَ شُلُنيِ بٍلٍبٍلٍ تِ عَ شَ وَلِكّيٍ بّ. نَشَن حّنفِ سَمَ مَنفّ شَ مِنسٍ شْن مَ، عَ نُن عَ شَ تَامِفَنيِ، مِسِرَ مَنفّ نَشَ عٍ شُن نَكٍلِ وَلِكّيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","نَشَن حّنفِ سَمَ مِنسٍ شْن مَ، عَ نَشَ عَ رَفبِلٍن عَ وَلِدٍ قٌرِ، عَلَكٌ عَ مَن شَ مِنسٍ سٌ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","كْنْ عَ نَشَ عَ شَ تَامِفَنيِ فبَكُ وُرِ مَ عَلْ يُسُقُ نُ بَرَ عَ تَفِ رَبَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","نَشَن حّنفِ سَمَ مَنفّ شَ مِنسٍ شَ قٍ شْن مَ، عَ مُ رَتُ يُسُقُ شَ قٍ مَ، عَ نّيمُ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","حّ قِرِن دَنفِ شَنبِ، مِسِرَ مَنفّ نَشَ شِيٍ ندٍ سَ. نَ شِيٍ كُي عَ تِشِ شُرٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","عَ نَشَ نِنفٍ قَتٍ قَنيِ سٌلٌقٍرٍ تٌ مِنِ رَ شُرٍ كُي، عٍ نَ حٌوفٍ دٌنقٍ كَلٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","نَ دَنفِ شَنبِ، نِنفٍ سٌلٌقٍرٍ فبّتّ، نَشٍيٍ شْسِشِ، نٍيٍ نَشَ مِنِ شُرٍ دّ رَ بٌورٍ نِنفٍيٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","يِ نِنفٍ شْسِشِ سٌلٌقٍرٍ نَشَ يِ نِنفٍ قَتٍ قَنيِ سٌلٌقٍرٍ دٌن. نَ نَن لَن مِسِرَ مَنفّ نَشَ شُنُ. ");
INSERT INTO susa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","عَ تٌ فبِلٍن عَ سَ رَ، عَ مَن نَشَ شِيٍ فبّتّ سَ. ");
INSERT INTO susa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","نَ شِيٍ كُي تْنسْي سٌلٌقٍرٍ قَنيِ تِشِ بِلِ كٍرٍن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","نَ دَنفِ شَنبِ، تْنسْي سٌلٌقٍرٍ فبّتّ، نَشٍيٍ شُن شُرُن، قٌيٍ بَرَ عٍ رَفَن، عٍ تِشِ بٌورٍ تْنسْييٍ سّيتِ مَ. يِ تْنسْي شُنشُرِيٍ نَشَ يِ تْنسْي رَقٍشِ قَنيِيٍ دٌن. نَ نَن لَن، مِسِرَ مَنفّ نَشَ شُنُ. نَ شِيٍ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","نَ كُيٍ عِبَ، مِسِرَ مَنفّ بْحّ نُ مِنِشِ. عَ نَشَ مَندُرُلَيٍ نُن كَرَ مْشْي بِرِن شِلِ. عَ نَشَ نَ شِيٍيٍ مَسٍن عٍ بّ، كْنْ مِشِ يٌ مُ سْتْ عٍ يَ مَ، نَشَن نْ عَ تَفِ رَبَدٍ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","نَ تّمُي نَشَن عَ حّنفِ سَمَ مَنفّ شَ مِنسٍ شْن مَ، نَ نَشَ وْيّنيِ تٌنفٌ عَ قَ عَ قَلَ مِسِرَ مَنفّ بّ، «ﭑ نَن مَ كَنَرِ يَ شَرَنمَ نّ تٌ لْشْي. ");
INSERT INTO susa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","تّمُي دَنفِشِ، مِسِرَ مَنفّ شْنْ نّ عَ شَ كٌنيِيٍ مَ. عَ نَشَ ﭑ سُشُ، عَ ﭑ بَلَن سْورِ مَنفّ شَ فٍيلِ كُي، عَ نُن نَشَن تَامِ فَنمَ مَنفّ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","عَ تَن نُن ﭑ تَن، مُشُ بِرِن شِيٍ سَ نّ كْي كٍرٍن كُي نَشَن تَفِ لَن عَ شَ رَبَ. كَنكَن شَ شِيٍ نُ وَ مَ قٍ ندٍ مَسٍنقٍ عَ كَنيِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","سْورِ مَنفّ شَ عٍبُرُ كٌنيِ ندٍ نَن نُ نَ فٍيلِ كُي مُشُ يَ مَ. مُشُ تٌ نَ شِيٍيٍ قَلَ عَ بّ، عَ نَشَ عٍ بِرِن قَسَرِ مُشُ بّ. مُشُ شِيٍ نَشٍيٍ سَشِ، عَ نَشَ كَنكَن فبٍ قَسَرِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","عَ بِرِن دَنفِ نّ عَلْ عَ شِيٍ تَفِ رَبَ مُشُ بّ كِ نَشّ. مِسِرَ مَنفّ بَرَ ﭑ تَن نَفبِلٍن ﭑ وَلِدٍ قٌرِ، كْنْ عَ بَرَ بٌورٍ فبَكُ وُرِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","مِسِرَ مَنفّ نَشَ شّيرَيٍ شّي يُسُقُ يِرٍ. عٍ نَشَ عَ رَ مِنِ فٍيلِ كُي عَ عِكْرّشِ رَ. عٍ نَشَ عَ شُنيِ بِ، عٍ سٌسٍ فبّتّيٍ رَفٌرٌ عَ مَ، عٍ سِفَ عَ رَ مِسِرَ مَنفّ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","مِسِرَ مَنفّ نَشَ عَ مَسٍن يُسُقُ بّ، «ﭑ بَرَ شِيٍ ندٍ سَ. مِشِ يٌ مُ نْشِ عَ تَفِ رَبَدٍ، كْنْ ﭑ بَرَ عَ مّ عِ تَن شِيٍ تَفِ رَبَمَ عٍ نَ نَشَن قَلَ عِ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","يُسُقُ نَشَ مِسِرَ مَنفّ يَابِ، «ﭑ تَن مُ عَ رَ. عَلَ نَن مِسِرَ مَنفّ شَ شِيٍ تَفِ رَبَمَ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","مِسِرَ مَنفّ نَشَ عَ مَسٍن يُسُقُ بّ، «ﭑ مَ شِيٍ كُي ﭑ تِشِ شُرٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ﭑ نَشَ نِنفٍ قَتٍ قَنيِ سٌلٌقٍرٍ تٌ مِنِ رَ شُرٍ كُي، عٍ نَ حٌوفٍ دٌنقٍ كَلٍيٍ لٌنفٌرِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","نَ نَن لَن، نِنفٍ سٌلٌقٍرٍ فبّتّ نَشَ تٍ عٍ شَنبِ رَ، عٍ شْسِشِ هَن. عٍ فَنيَنشْرِ بِرِن سَشِ كّنّ مَ. هَن تٌ ﭑ مُ نَ نِنفٍ شْسِشِ مْولِ تٌ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","نَ نِنفٍ شْسِشِ شُن نَكَنَشِيٍ نَشَ نَ نِنفٍ سٌلٌقٍرٍ قَتٍ قَنيِ دٌن. ");
INSERT INTO susa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","كْنْ نَ دَنفِ شَنبِ، مِشِ يٌ مُ نْ عَ كٌلٌندٍ شَ عٍ بَرَ عٍ دٌن. عٍ شَ شْسِ مُ مَسَرَ. نَ نَن لَن، ﭑ نَشَ شُنُ.» ");
INSERT INTO susa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«نَ تّمُي ﭑ مَن نَشَ شِيٍ فبّتّ سَ. تْنسْي رَقٍشِ قَنيِ سٌلٌقٍرٍ تِشِ بِلِ كٍرٍن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","نَ دَنفِ شَنبِ تْنسْي شُنشُرِ سٌلٌقٍرٍ فبّتّ، قٌيٍ نَشٍيٍ رَفَنشِ، نٍيٍ نَشَ مِنِ بٌورٍيٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","تْنسْي ثٌنثٌييٍ نَشَ نَ تْنسْي سٌلٌقٍرٍ قَنيِ دٌن. ﭑ بَرَ نَ قَلَ مَندُرُلَيٍ بّ، كْنْ مِشِ يٌ مُ نْ عَ قَسَرِدٍ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","يُسُقُ نَشَ عَ قَلَ مِسِرَ مَنفّ بّ، «عِ شَ شِيٍ قِرِنيِ بِرِن قٍ كٍرٍن نَن مَسٍنشِ. عَلَ بَرَ عِ رَكٌلٌن قٍ مَ عَ قَمَ نَشَن نَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","نَ نِنفٍ سٌلٌقٍرٍ قَنيِيٍ نُن نَ تْنسْي سٌلٌقٍرٍ قَنيِيٍ، حّ سٌلٌقٍرٍ نَن مَسٍنشِ نَ كِ. نَ تَن شِيٍ كٍرٍن نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","نَ نِنفٍ شْسِشِ شُن نَكَنَشِ سٌلٌقٍرٍ نُن نَ تْنسْي ثٌنثٌي سٌلٌقٍرٍ قٌيٍ نَشٍيٍ رَفَنشِ، نٍيٍ قَن حّ سٌلٌقٍرٍ كَامّ نَن مَسٍنشِ.» ");
INSERT INTO susa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«ﭑ شَ نْندِ قَلَ عِ بّ، عَلَ بَرَ قٍ مَسٍن مِسِرَ مَنفّ بّ عَ قَمَ نَشَن نَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","يِ حّ سٌلٌقٍرٍ نَشَن قَقٍ يِ كِ، عٍ قِندِ مَ حّ قَنيِ نَن نَ مِسِرَ بْشِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","نَ نَ دَنفِ، كَامّ حّ سٌلٌقٍرٍ فبّتّ قَمَ قَدٍ، وٌن نّيمُمَ نّ نَ قٍ قَنيِ بِرِن نَ. كَامّ بْشِ هَلَكِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","نَ قِندِ مَ قٍ مَفَاشُشِ نَن نَ، عَ لُ عَلْ سٍسٍ قَنيِ مُ نُ رَبَ يِ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","«عِ يِ شِيٍ سَشِ نّ دْشْ قِرِن، بَرِ مَ عَلَ شَ نَتّ نَ عَ رَ نَشَن مُ كَنَمَ، عَ مَن مُ بُمَ عَ شَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","مَنفّ، يَكْسِ عَ لَنمَ عِ شَ شَشِلِمَ قٍن نَشَن لْننِشِ. عِ شَ مِسِرَ نْي سٌ نَ كَنيِ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","مَنفّ، عِ شَ مِشِيٍ سُفَندِ نَشٍيٍ حّنفِ قَمَ سَدٍ بْشِ رَوَلِ شْن مَ يِ حّ قَنيِ سٌلٌقٍرٍ بُن مَ. بْشِ دَشَمُي بُسَلِ سُولِ يٌ سُولِ، عٍ شَ قَ كٍرٍن نَ مَنفّ شْن مَ، عَ شَ عَ رَفَتَ. ");
INSERT INTO susa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","عٍ شَ دٌنسٍ بِرِن مَلَن، عٍ شَ عَ رَفَتَ تَايٍ كُي مِسِرَ مَنفّ شَ نْي بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","يِ دٌنسٍ رَفَتَشِ قَمَ مِسِرَ بْشِ رَتَنفَدٍ كَامّ مَ، نَشَن قَمَ قَدٍ حّ سٌلٌقٍرٍ بُن.» ");
INSERT INTO susa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","نَ وْيّنيِ نَشَ رَقَن مِسِرَ مَنفّ نُن عَ شَ مِشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","مِسِرَ مَنفّ نَشَ عَ قَلَ عٍ بّ، «وٌن نْمَ مِشِ ندٍ سْتْدٍ نَشَن لُمَ عَلْ يِ شّمّ؟ عَلَ شَشِلِ نَ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","مِسِرَ مَنفّ نَشَ عَ قَلَ يُسُقُ بّ، «عَلَ بَرَ نَ قٍ بِرِن مَسٍن عِ بّ. مِشِ يٌ مُ نَ نَشَن شَشِلِ قَن عَلْ عِ تَن، عَ شَ لْننِ مَن شَ دَنفِ عِ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","عِ تَن نَن قَمَ قِندِدٍ ﭑ مَ بَنشِ شُنيِ رَ. ﭑ مَ حَمَ قَمَ بِرَدٍ عِ شَ يَامَرِ نَن قْشْ رَ. ﭑ مَ مَنفّ كِبَنيِ نَن تُن ﭑ نَدَنفِشِ عِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","مِسِرَ مَنفّ مَن نَشَ عَ قَلَ يُسُقُ بّ، «عَ مَتٌ، ﭑ بَرَ نْي سٌ عِ يِ رَ مِسِرَ بْشِ بِرِن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","عَ نَشَ عَ شَ فبٍتِ شُرُندّ بَ عَ بّلّشّ رَ، عَ نَشَ عَ سٌ يُسُقُ بّلّشّ رَ. عَ نَشَ سٌسٍ قَنيِ رَفٌرٌ عَ مَ. عَ نَشَ كْنمَفٌرٍ شّيمَ دَاشِ رَفٌرٌ عَ كْن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","عَ نَشَ عَ رَتٍ فِسٍ كُي، نَشَن بِرَ مَ مِسِرَ مَنفّ رَفِسٍ قْشْ رَ. سْورِيٍ نُ قَ عَ قَلَ عٍ شُي عِتٍشِ رَ حَمَ بّ، «وٌ شِنبِ سِن!» مِسِرَ مَنفّ عَ شَ مَنفّيَ تَشُ يُسُقُ رَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","مِسِرَ مَنفّ مَن نَشَ عَ قَلَ يُسُقُ بّ، «ﭑ تَن نَن مَنفّ رَ، كْنْ شَ عِ مُ يَامَرِ قِ نَشَن مَ، قٍقٍ مُ رَبَمَ مِسِرَ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","مِسِرَ مَنفّ نَشَ يُسُقُ شِلِ سَ سَقَنَتِ ثَنٍيَ. عَ نَشَ ثٌتِقٍرَ، عٌن سّرّشّدُبّ، شَ دِ فِنّ عَسَنَ، قِ عَ مَ. يُسُقُ نَشَ مِسِرَ بْشِ شُن مَتٌ قْلْ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","يُسُقُ سِمَيَ نُ بَرَ حّ تٌنفٌ سَشَن لِ، عَ قَ مِسِرَ مَنفّ يِرٍ تّمُي نَشّ. نَ تّمُي يُسُقُ نَشَ كٍلِ مِسِرَ مَنفّ يِرٍ، عَ سَ مِسِرَ بْشِ بِرِن عِحّرّ. ");
INSERT INTO susa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","نَ حّ سٌلٌقٍرٍ قَنيِ كُي، بْشِ بِرِن نَشَ رَوَلِ. ");
INSERT INTO susa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","يُسُقُ نَشَ دٌنسٍ بِرِن مَلَن نَشَن سْتْشِ نَ حّ سٌلٌقٍرٍ بُن مَ مِسِرَ بْشِ مَ. عَ نَشَ دٌنسٍ رَفَتَ تَايٍ كُي نَشَن سْتْشِ دَاشَ. ");
INSERT INTO susa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","يُسُقُ نَشَ دٌنسٍ شْرِ فبٍفبٍ مَلَن، عَلْ مّيّنيِ نَشَن نَ بَا دّ رَ. عَ نَشَ فبٌ يّ هَن عَ مُ نَ شَسَبِ سّبّ سْنْن، بَرِ مَ مِشِ يٌ مُ نْمَ عَ كْنتِ كٌلٌندٍ. ");
INSERT INTO susa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","بٍينُن كَامّ حّ سِن تّمُي، يُسُقُ شَ فِنّ عَسَنَ، عٌن سّرّشّدُبّ ثٌتِقَرِ شَ دِ فِنّ، نَشَ دِ قِرِن بَرِ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","يُسُقُ نَشَ عَ شَ دِ سِنفٍ شِلِ سَ مَنَسِ. نَ نَن نَ كِ، عَلَ بَرَ عَ نِيَ ﭑ بَرَ نّيمُ ﭑ مَ تْورّ بِرِن مَ، عَ نُن ﭑ بَبَ شَ دٍنبَيَ. ");
INSERT INTO susa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","عَ نَشَ عَ شَ دِ قِرِن ندٍ شِلِ سَ عٍقِرَ مِ. نَ نَن نَ كِ، عَلَ بَرَ ﭑ قِندِ دِ بَرِ رَ بْشِ مَ ﭑ شُن نُ فٌرٌشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","حّ قَنيِ سٌلٌقٍرٍ نَشَ دَنفِ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","كَامّ حّ سٌلٌقٍرٍ نَشَ عَ لِ قْلْ، عَلْ يُسُقُ عَ تَفِ رَبَ كِ نَشّ. كَامّ نَشَ دِن دُنِحَ بِرِن نَ، كْنْ بَلٌي نُ نَ مِسِرَ بْشِ تَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","كَامّ تٌ بَرَ مِسِرَ بْشِ بِرِن سُشُ، حَمَ نَشَ سْنشْي رَتٍ مِسِرَ مَنفّ مَ بَلٌي قٍ رَ. مِسِرَ مَنفّ نَشَ عَ قَلَ مِسِرَكَيٍ بِرِن بّ، «وٌ سِفَ عَ قَلَ يُسُقُ بّ، عَ نَ قٍ نَشَن قَلَ وٌ بّ، وٌ شَ نَ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","كَامّ نَشَ دِن بْشِ بِرِن نَ. يُسُقُ نَشَ دٌنسٍ مَلَندٍيٍ رَبِ، عَ نَشَ مّنفِ سَرَ مِسِرَكَيٍ مَ، بَرِ مَ كَامّ نُ بَرَ سّنبّ سْتْ مِسِرَ بْشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","مِشِيٍ نُ قَ كٍلِ يِرٍ بِرِن، قَقٍ مّنفِ سَرَدٍ يُسُقُ مَ، بَرِ مَ كَامّ نُ بَرَ سّنبّ سْتْ دُنِحَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","يَشُبَ تٌ بَرَ عَ مّ عَ مّنفِ نَ مِسِرَ، عَ نَشَ عَ قَلَ عَ شَ دِيٍ بّ، «وٌ دْشْشِ مُنقٍ رَ؟ ");
INSERT INTO susa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ﭑ بَرَ عَ مّ عَ مّنفِ نَ مِسِرَ. وٌ فٌرٌ، وٌ سَ مّنفِ سَرَ وٌن بّ عَلَكٌ وٌن شَ بَلٌ، وٌن نَشَ قَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","يُسُقُ تَارَ مِشِ قُ نَشَ فٌرٌ دٌنسٍ شْرِ سَرَدٍ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","يَشُبَ مُ تِن بُنيَمِن، يُسُقُ شُنيَ، شَ بِرَ عٍ قْشْ رَ. عَ نُ قَ عَ قَلَ، «ﭑ بَرَ فَاشُ قٍ حَاشِ نَشَ قَ عَ سْتْ.» ");
INSERT INTO susa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","عِسِرَيِلَ شَ دِيٍ نَشَ سِفَ مّنفِ سَرَدٍ، عٍ نُن مِشِ فبّتّيٍ رَ نَشٍيٍ قَن نُ وَشِ مّنفِ شْن، بَرِ مَ كَامّ نُ بَرَ دِن كَنَان بْشِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","يُسُقُ نَن نُ قِندِشِ مَنفّ شُنفبٍ رَ مِسِرَ. عَ تَن نَن نُ مّنفِ سَرَ مَ مِشِ بِرِن مَ. يُسُقُ تَارَيٍ نَشَ قَ، عٍ عٍ يَتَفِ رَقٍلٍن بْشِ مَ عَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","يُسُقُ تٌ عَ تَارَيٍ تٌ، عَ نَشَ عٍ كٌلٌن، كْنْ عَ نَشَ عَ يّتّ رَ سَن عٍ مَ. عَ نَشَ وْيّن عٍ بّ عَ شْرْشْي رَ، «وٌ كٍلِشِ مِندٍن؟» عٍ نَشَ عَ يَابِ، «مُشُ كٍلِشِ كَنَان بْشِ نَن مَ، قَقٍ دٌنسٍ سَرَدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","يُسُقُ نَشَ عَ تَارَيٍ كٌلٌن، كْنْ عٍ تَن مُ كٌلٌن سْتْ عَ شَ قٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","يُسُقُ نَشَ رَتُ عَ شَ شِيٍ مَ، عَ نَشَن سَ عَ تَارَيٍ شَ قٍ رَ. عَ نَشَ عَ قَلَ عٍ بّ، «بْشِ رَبّنيِيٍ نَن نَ وٌ رَ. وٌ قَشِ يِ بْشِ كٌبِدٍيٍ نَن كٌلٌندٍ.» ");
INSERT INTO susa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","عٍ نَشَ عَ يَابِ، «عَدٍ. مَنفّ، مُشُ قَشِ دٌنسٍ نَ تُن سَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","مُشُ بِرِن، شّمّ كٍرٍن شَ دِيٍ نَن لَنشِ مُشُ مَ. مِشِ مَتِنشِنشِيٍ نَن نَ مُشُ رَ. مُشُ نَ عِ شَ يَامَرِ بُن مَ، مُشُ مُ قِندِشِ بْشِ رَبّنيِيٍ شَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","يُسُقُ نَشَ عَ قَلَ عٍ بّ، «وُلٍ نَ عَ رَ. وٌ قَشِ بْشِ كٌبِدٍيٍ نَن قٍندٍ.» ");
INSERT INTO susa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","عٍ نَشَ عَ يَابِ، «مُشُ تَن لُشِ عَلْ عِ شَ كٌنيِيٍ. مُشُ دِ قُ نُن قِرِن نَن عَ رَ. مِشِ كٍرٍن مَ دِيٍ نَن نَ مُشُ بِرِن نَ كَنَان بْشِ مَ. مُشُ بِرِن شُنيَ نَ مُشُ بَبَ يِرٍ، دِ كٍرٍن تَن بَرَ لَاشِرَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","يُسُقُ نَشَ عَ قَلَ عٍ بّ، «ﭑ عَ كٌلٌن عَ بْشِ رَبّنيِيٍ نَن نَ وٌ رَ. ");
INSERT INTO susa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ﭑ وٌ مَتٌمَ يِ نَن مَ. مِسِرَ مَنفّ شِلِ رَ، وٌ مُ كٍلِمَ بٍ دَنمِ وٌ شُنيَ مُ قَ. ");
INSERT INTO susa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","وٌ مِشِ ندٍ شّي وٌ يَ مَ عَ شَ سَ قَ وٌ شُنيَ رَ. وٌ تَن دْنشْييٍ سٌمَ فٍيلِ نّ. ﭑ قَمَ وٌ شَ وْيّنيِ مَتٌدٍ، ﭑ شَ عَ كٌلٌن شَ وٌ نْندِ قَلَمَ، شَ نَ مُ مِسِرَ مَنفّ شِلِ رَ، بْشِ رَبّنيِيٍ نَن نَ وٌ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","عَ نَشَ عٍ بِرِن مَكَنكَن هَن شِ سَشَن. ");
INSERT INTO susa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","شِ سَشَن لْشْي، يُسُقُ نَشَ عَ قَلَ عٍ بّ، «شَ وٌ بَرَ ﭑ شُي سُشُ، وٌ مُ قَشَمَ، بَرِ مَ ﭑ فَاشُمَ عَلَ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","شَ مِشِ مَتِنشِنشِيٍ نَن وٌ رَ، وٌ مِشِ كٍرٍن لُ فٍيلِ كُي، بٌورٍيٍ شَ دٌنسٍ شَنِن وٌ شَ دٍنبَيَيٍ شْن مَ، بَرِ مَ عٍ نَ تْورّ كُي. ");
INSERT INTO susa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","وٌ شَ قَ وٌ شُنيَ رَ ﭑ شْن مَ عَلَكٌ ﭑ شَ عَ كٌلٌن شَ نْندِ قَلّيٍ نَن وٌ رَ، نَ نَن عَ تٌمَ وٌ مُ قَشَمَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","نَ تّمُي، عٍ نُ قَ عَ قَلَ عٍ بٌورٍ بّ، «عِيٌ وٌن تَن نَن يَتِ قْشِ نَ وٌن يّتّ مَ، بَرِ مَ وٌن نَ وٌن شُنيَ شَ يَمَحْشُنيِ تٌ نّ. عَ نَشَ وٌن مَيَندِ، كْنْ وٌن حَن مُ عَ دَنشُن. نَ قٍ نَن عَ تٌشِ وٌن نَ يِ تْورّ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","رُبٍن تٌ وْيّنيِ تٌنفٌ، عَ نَشَ عَ قَلَ عٍ بّ، «ﭑ نَ عَ قَلَ نّ وٌ بّ، وٌ نَشَ فبَلٌي قٍ رَبَ نَ دِ مّدِ رَ. كْنْ وٌ مُ تِن وٌ تُلِ مَتِدٍ ﭑ نَ. يَكْسِ عَ هَاكّ نَن وٌن بْنبْقٍ يِ كِ.» ");
INSERT INTO susa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","عٍ مُ نُ عَ كٌلٌنشِ عَ يُسُقُ عٍ شَ شُي مّمَ، بَرِ مَ شُي مَدَنفِ نُ نَ عٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","يُسُقُ نَشَ عَ مَكُيَ عٍ رَ، عَ نُ قَ وَ. نَ دَنفِ شَنبِ، عَ نَشَ قَ وْيّندٍ عٍ بّ. عَ نَشَ سِمٍيْن تٌنفٌ عٍ يَ مَ، عَ عَ سَ فٍيلِ عٍ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","يُسُقُ نَشَ يَامَرِ قِ عَ شَ وَلِكّيٍ مَ، عٍ شَ عٍ شَ بّكِيٍ رَقٍ دٌنسٍ شْرِ رَ، عٍ شَ عٍ شَ كْبِرِ قَن سَ كَنكَن شَ بّكِيٍ كُي عَ نُن عٍ قَندّ. نَ نَشَ رَبَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","نَ تّمُي يُسُقُ شَ تَارَيٍ نَشَ عٍ شَ مّنفِ كٌتٍ سَ سٌقَلٍيٍ قَرِ، عٍ نَشَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","عٍ تٌ شِدٍ لِ، كٍرٍن نَشَ عَ شَ بّكِ رَبِ عَلَكٌ عَ شَ دٌنسٍ شْرِ سٌ عَ شَ سٌقَلٍ يِ رَ. عَ نَشَ عَ شَ كْبِرِ تٌ عَ شَ بّكِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","عَ نَشَ عَ قَلَ عَ تَارَيٍ بّ، «عٍ بَرَ ﭑ مَ كْبِرِ رَفبِلٍن ﭑ مَ. عَ تَن نَن نَ ﭑ مَ بّكِ كُي يِ كِ.» عٍ بْحّيٍ نَشَ مِنِ. عٍ نُ قَ عٍ بٌورٍ مَشْرِن كْنتْقِلِ كُي، «عَلَ مُنسٍ رَبَشِ وٌن نَ يِ كِ؟» ");
INSERT INTO susa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","عٍ تٌ سٌ عٍ بَبَ يَشُبَ يِرٍ كَنَان بْشِ مَ، عٍ نَشَ نَ بِرِن دّنتّفّ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","عٍ نَشَ عَ قَلَ، «شّمّ نَشَن نَ نَ بْشِ مَنفّ رَ، عَ وْيّنشِ نّ مُشُ بّ عَ شْرْشْي رَ. عَ مَن قَ مُشُ قِندِ مِشِيٍ رَ نَشٍيٍ قَشِ عَ شَ بْشِ رَبّندٍ. ");
INSERT INTO susa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","مُشُ نَشَ عَ قَلَ عَ بّ، ‹مِشِ مَتِنشِنشِيٍ نَن نَ مُشُ رَ، بْشِ رَبّنيِيٍ شَ مُ لَنشِ مُشُ مَ. ");
INSERT INTO susa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","مُشُ دِ قُ نُن قِرِن نَ عَ رَ، مُشُ بِرِن بَبَ كٍرٍن. كٍرٍن بَرَ لَاشِرَ، مُشُ شُنيَ نَ مُشُ بَبَ قّ مَ كَنَان بْشِ مَ.› ");
INSERT INTO susa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","نَ شّمّ نَشَن نَ نَ بْشِ مَنفّ رَ، عَ قَلَشِ نّ مُشُ بّ، ‹ﭑ وَ مَ عَ كٌلٌنقٍ نّ شَ مِشِ مَتِنشِنشِيٍ نَن نَ وٌ رَ. وٌ مِشِ كٍرٍن لُ ﭑ يِرٍ بٍ. وٌ مّنفِ شَنِن وٌ شَ مِشِيٍ شْن، بَرِ مَ كَامّ نَ عٍ مَ. وٌ سِفَ، ");
INSERT INTO susa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","كْنْ وٌ مَن شَ قَ وٌ شُنيَ رَ ﭑ شْن مَ. ﭑ قَمَ عَ كٌلٌندٍ نَ نَن مَ مِشِ مَتِنشِنشِيٍ نَن وٌ رَ، بْشِ رَبّنيِيٍ مُ وٌ رَ. نَ تّمُي، ﭑ وٌ شُنيَ سٌمَ وٌ يِ رَ، وٌ مَن قَ يُلّيَ رَبَ ﭑ مَ بْشِ كُي.›» ");
INSERT INTO susa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","عٍ تٌ عٍ شَ بّكِيٍ عِبَفَن، كَنكَن نَشَ عَ شَ كْبِرِ تٌ عَ شَ بّكِ كُي. عٍ تَن نُن عٍ بَبَ تٌ نَ كْبِرِ تٌ، عٍ بِرِن نَشَ فَاشُ. ");
INSERT INTO susa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","عٍ بَبَ يَشُبَ نَشَ عَ قَلَ عٍ بّ، «وٌ بَرَ ﭑ نَفَن ﭑ مَ دِيٍ رَ. يُسُقُ مُ نَ قَ، سِمٍيْن قَن مُ نَ. وٌ مَن وَشِ بُنيَمِن نَن قَن تٌنفٌقٍ يِ كِ. يِ كٌتٍ بِرِن قِندِشِ ﭑ تَن نَن فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","رُبٍن نَشَ عَ قَلَ عَ بَبَ بّ، «شَ ﭑ مُ بُنيَمِن نَفبِلٍن عِ مَ، عِ شَ ﭑ مَ دِ قِرِنيِيٍ قَشَ. بُنيَمِن سٌ ﭑ يِ رَ، ﭑ مَن قَمَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","يَشُبَ نَشَ عَ يَابِ، «وٌ نُن ﭑ مَ دِ بِرِن مُ سِفَمَ، بَرِ مَ عَ تَارَ بَرَ قَشَ، عَ كٍرٍن نَن قَ لُشِ. شَ قٍ ندٍ سَ عَ سْتْ وٌ شَ بِيَاسِ كُي، ﭑ مَ سِمَيَ رَحْنيِ قِندِ مَ ﭑ بّ سُننُنيِ نَن نَ وٌ قْشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","كَامّ سّنبّ نُ فبٌمَ نَن تُن كَنَان بْشِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","يَشُبَ نُن عَ شَ دٍنبَيَ تٌ بَرَ فّ مّنفِ بِرِن دٌندٍ عٍ قَ نَشَن نَ كٍلِقٍ رَ مِسِرَ، يَشُبَ نَشَ عَ قَلَ عَ شَ دِيٍ بّ، «وٌ مَن شَ سِفَ، وٌ شَ سَ دٌنسٍ ندٍ سَرَ وٌن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","يُدَ نَشَ عَ يَابِ، «مِسِرَ مَنفّ عَ قَلَ نّ مُشُ بّ عَ قَنيِ رَ، ‹وٌ مُ ﭑ يَتَفِ تٌمَ شَ وٌ نُن وٌ شُنيَ بِرِن مُ قَ.› ");
INSERT INTO susa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","شَ عِ بَرَ تِن مُشُ نُن بُنيَمِن بِرِن شَ سِفَ، مُشُ سِفَمَ نّ، مُشُ سَ دٌنسٍ سَرَ عِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","كْنْ شَ عِ مُ تِن نَ رَ، مُشُ مُ سِفَمَ، بَرِ مَ نَ شّمّ عَ قَلَ نّ مُشُ بّ، ‹وٌ مُ ﭑ يَتَفِ تٌمَ شَ وٌ نُن وٌ شُنيَ بِرِن شَ مُ قَ.›» ");
INSERT INTO susa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","نَ تّمُي عِسِرَيِلَ نَشَ عَ قَلَ، «مُنقٍ رَ وٌ قٍ كٌبِ عِلَنشِ ﭑ نَ عَ قَلَقٍ نَ شّمّ بّ عَ شُنيَ فبّتّ نَ وٌ بّ؟» ");
INSERT INTO susa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","عٍ نَشَ عَ يَابِ، «نَ شّمّ مُشُ مَشْرِنشِ نّ عَ شْرْشْي رَ مُشُ بَرِ كِ مَ. عَ نُ قَ عَ قَلَ، ‹وٌ بَبَ مَن نَ سِمَيَ كُي؟ وٌ شُنيَ ندٍ نَ؟› مُشُ قَن نَشَ عَ شَ مَشْرِنيِ بِرِن يَابِ. مُشُ حْشْ مُ نُ عَ مَ، عَ قَلَمَ، ‹وٌ قَ وٌ شُنيَ رَ.›» ");
INSERT INTO susa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","يُدَ نَشَ عَ قَلَ عَ بَبَ عِسِرَيِلَ بّ، «عَ لُ مُشُ نُن دِ مّدِ شَ سِفَ. مُشُ شَ سِفَ، نَ تّمُي وٌن بَلٌي سْتْمَ نّ وٌن مُ قَشَ، عِ تَن، مُشُ تَن، عَ نُن مُشُ شَ دِيٍ. ");
INSERT INTO susa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","عِ يَ تِ ﭑ تَن نَ. عِ قَمَ عَ مَشْرِندٍ ﭑ تَن نَن مَ. شَ ﭑ مُ قَ عَ رَ، ﭑ قَ عَ تِ عِ يَ عِ، نَ كٌتٍ بَرَ قِندِ ﭑ فبٍ رَ عِ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","يَكْسِ، شَ يِ قٍ شَ مُ مُشُ رَبُشِ نُ، مُشُ بَرَ سِفّ نُن قَ قِرِن نَبَ نُ.» ");
INSERT INTO susa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","عٍ بَبَ عِسِرَيِلَ نَشَ عَ قَلَ عٍ بّ، «يِ نَن تٌ قَ عَ رَ، وٌ قَن يِ نَن نَبَمَ. وٌ بْشِ دَشَمُي ندٍيٍ سَ كٌتٍ عَلَكٌ وٌ شَ نَ شّمّ سَنبَ وُرِ دٌلٍ، كُمِ، سُرَيِ، لَبُندّ، كُسُ، نُن قٌوتٍ كَنسِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","وٌ شَ مّنفِ سَرٍ سِنفٍ، وٌ نَشَن تٌشِ بّكِيٍ كُي، عَ نُن مّنفِ فبّتّ سَرٍ، وٌ شَ نَ كْبِرِ بِرِن شَنِن وٌ شُن. تّمُندٍ نَ قِندِشِ نّيمُي نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","وٌ وٌ شُنيَ تٌنفٌ، وٌ شَ سِفَ نَ شّمّ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","عَلَ سّنبّ كَنيِ شَ عَ نِيَ نَ شّمّ شَ كِنِكِنِ وٌ مَ، عَ شَ وٌ شُنيَ سٌ وٌ يِ رَ عَ نُن بُنيَمِن. شَ ﭑ تَن قَ فَنمَ نّ ﭑ مَ دِيٍ بِرِن نَ، ﭑ بَرَ يّرّلّ.» ");
INSERT INTO susa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","يَشُبَ شَ دِيٍ نَشَ نَ سَنبَسٍيٍ يَءِلَن. عٍ نَشَ مّنفِ سَرٍ سِنفٍ كْبِرِ تٌنفٌ، عَ نُن عٍ لَنمَ عٍ شَ مّنفِ فبّتّ سَرَ كْبِرِ نَشَن نَ. عٍ نَشَ سِفَ مِسِرَ عَ نُن بُنيَمِن، عٍ سَ عٍ يّتّ دّنتّفّ يُسُقُ بّ. ");
INSERT INTO susa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","يُسُقُ تٌ بُنيَمِن تٌ عٍ يَ مَ، عَ نَشَ عَ قَلَ عَ شَ كٌنيِ بّ، «يِ شّمّيٍ شَنِن ﭑ شْنيِ. عِ شَ شُرُ سٍ ندٍيٍ قَشَ، عِ دٌنسٍ يَءِلَن، عَلَكٌ مُشُ شَ مُشُ دّفٍ يِرٍ كٍرٍن تٌ يَنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","يُسُقُ شَ كٌنيِ نَشَ عَ شَ يَامَرِ رَبَ كٍرٍن نَ. عَ نَشَ يَشُبَ شَ دِيٍ شَنِن يُسُقُ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","فَاشُي نَشَ لُ عٍ مَ عَ نُ عٍ شَنِنمَ تّمُي نَشّ يُسُقُ شْنيِ. عٍ نُ قَ عَ قَلَ عٍ بٌورٍ بّ، «عٍ نَ وٌن شَنِنقٍ نَ كْبِرِ نَن مَ قٍ رَ، وٌن نَشَن تٌ وٌن مَ بّكِيٍ كُي. عٍ قَمَ نّ دُتُندٍ وٌن مَ، عٍ وٌن مَ سٌقَلٍيٍ تٌنفٌ، عٍ وٌن قِندِ كٌنيِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","نَ كُي عٍ نَشَ عٍ مَسٌ يُسُقُ شَ بَنشِ كٌنيِ رَ، عٍ نَشَ وْيّن عَ رَ بَنشِ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","عٍ نَشَ عَ قَلَ، «يَندِ مَنفّ، مُشُ سِنفٍ بَرَ قَ بٍ نُ دٌنسٍ سَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","كْنْ مُشُ تٌ مُشُ شِدٍ لِ فبِلٍنقٍ رَ مُشُ شْنيِ، مُشُ نَشَ مُشُ شَ بّكِيٍ رَقُلُن، كَنكَن نَشَ عَ شَ كْبِرِ تٌ عَ شَ بّكِ كُي نَ دٌنسٍ سَرَشِ نَشَن نَ. يَكْسِ مُشُ مَن بَرَ قَ نَ كْبِرِ رَفبِلٍندٍ عِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","مُشُ بَرَ قَ كْبِرِ فبّتّ قَن نَ، عَلَكٌ مُشُ مَن شَ دٌنسٍ فبّتّ سَرَ. مُشُ مُ عَ كٌلٌن مِشِ يٌ نَشَن نَ كْبِرِ سَشِ مُشُ شَ بّكِيٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","مَنفّ شَ كٌنيِ نَشَ عٍ يَابِ، «وٌ بْحّ شَ سَ، وٌ نَشَ فَاشُ. عَلَ نَ عَ رَ، وٌ بَبَ مَرِفِ عَلَ نَن نَ هَرِفٍ قِشِ وٌ مَ وٌ شَ بّكِيٍ كُي. ﭑ تَن يَتِ نَن وٌ شَ كْبِرِ رَ سُشُ.» نَ تّمُي عَ نَشَ سِمٍيْن رَ مِنِ عٍ مَ، ");
INSERT INTO susa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","عَ قَ عٍ رَ سٌ يُسُقُ شْنيِ. عَ نَشَ يٍ سٌ عٍ يِ رَ، عَلَكٌ عٍ شَ عٍ سَنيِيٍ مَشَ. عَ نَشَ حٌوفٍ سٌ عٍ شَ سٌقَلٍيٍ يِ رَ دٌنسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","يُسُقُ تَارَيٍ نَشَ سَنبَسٍيٍ يَءِلَن، بٍينُ يُسُقُ سٌمَ تّمُي نَشّ يَنيِ رَ، بَرِ مَ عٍ نُ بَرَ عَ مّ عٍ عٍ دّفٍمَ نَا نّ. ");
INSERT INTO susa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","يُسُقُ تٌ سٌ بَنشِ، عٍ نَشَ عَ شَ سَنبَسٍيٍ سٌ عَ يِ رَ، عٍ عٍ رَقٍلٍن بْشِ مَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","يُسُقُ نَشَ عٍ مَشْرِن شَ عٍ يَلَنشِ. عَ مَن نَشَ عٍ مَشْرِن، «وٌ بَبَ قٌرِشِ وٌ نَشَن شَ قٍ قَلَ ﭑ بّ، سٍ مُ عَ تٌشِ؟ عَ مَن نَ سِمَيَ كُي؟» ");
INSERT INTO susa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","عٍ نَشَ عَ يَابِ، «عِ شَ كٌنيِ مُشُ بَبَ، سٍسٍ مُ عَ سْتْشِ. عَ مَن نَ سِمَيَ كُي.» عٍ مَن نَشَ عٍ رَقٍلٍن بْشِ مَ عَ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","يُسُقُ تٌ عَ يَ رَكٍلِ، عَ نَشَ عَ شُنيَ بُنيَمِن تٌ، عَ نفَ شَ دِ. عَ نَشَ عَ قَلَ، «يِ نَن نَ وٌ شُنيَ رَ وٌ نَشَن شَ قٍ قَلَ ﭑ بّ؟» يُسُقُ نَشَ عَ قَلَ بُنيَمِن بّ، «ﭑ مَ دِ، عَلَ شَ هّيرِ قِ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","عَ شُنيَ شَ قٍ كِنِكِنِ نَشَ فٌرٌ عَ سٌندٌنيِ كُي، وَ شْلِ نَشَ عَ سُشُ. عَ نَشَ كٍلِ مَقُرٍن، عَ سٌ عَ شِدٍ عَ نُ قَ وَ. ");
INSERT INTO susa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","يُسُقُ تٌ فّ عَ يَ رَقُرُكُدٍ، عَ نَشَ مِنِ، عَ نَ مَحْشُنيِ بَ عَ يَ رَ. عَ نَشَ يَامَرِ قِ، «وٌ دٌنسٍ عِتَشُن.» ");
INSERT INTO susa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","عَ شَ وَلِكّيٍ نَشَ عَ فبٍ سَ عَ شَتِ مَ، عٍ عَ تَارَيٍ فبٍ دْشْ عٍ شَتِ مَ، عٍ مِسِرَكَيٍ فبٍ قَن دْشْ عٍ شَتِ مَ، بَرِ مَ مِسِرَكَيٍ نُن عٍبُرُ مِشِيٍ مُ عٍ دّفٍمَ يِرٍ كٍرٍن. مِسِرَكَيٍ شَ نَامُنيِ مُ تِنمَ نَ رَ قٍوٌ. ");
INSERT INTO susa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","يُسُقُ شَ وَلِكّيٍ نَشَ عَ تَارَيٍ مَفٌرٌ عَ يَ شْرِ. عٍ بِرِن نُ مَفٌرٌشِ عَ قٌرِ كِ مَ، كٍلِ دِ سِنفٍ مَ هَن دِ مّدِ. يِ قٍ نَشَ عٍ بِرِن كَابَ. ");
INSERT INTO susa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","يُسُقُ تٌ يَامَرِ قِ دٌنسٍ شَ سٌ عٍ يِ رَ، بُنيَمِن شَ دٌنسٍ نُ دَنفِ عَ تَارَيٍ فبٍ رَ دْشْ سُولِ. عٍ بِرِن نَشَ عٍ دّفٍ، عٍ مِن، هَن عٍ وَ سَ. ");
INSERT INTO susa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","يُسُقُ نَشَ يِ يَامَرِ سٌ عَ شَ بَنشِ وَلِكّيٍ شُنيِ يِ رَ، عَ نَشّ، «يِ مِشِيٍ شَ بّكِيٍ رَقٍ دٌنسٍ رَ عٍ نْمَ نَشَن شَنِندٍ. عِ مَن شَ عٍ شَ كْبِرِ سَ عٍ شَ بّكِيٍ كُي. ");
INSERT INTO susa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","عِ شَ ﭑ مَ يٍ مِنسٍ فبٍتِ دَاشِ قَن سَ عٍ بِرِن شُنيَ دْنشْي شَ بّكِ كُي، عَ نُن عَ شَ مّنفِ سَرَ كْبِرِ.» يُسُقُ قٍ نَشَن بِرِن قَلَ عَ شَ وَلِكّ بّ، عَ نَشَ عَ بِرِن نَبَ. ");
INSERT INTO susa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","كُيٍ تٌ عِبَ فّيسّفّ، يَشُبَ شَ دِيٍ نَشَ سِفَ، عٍ نُن عٍ شَ سٌقَلٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","عٍ نَشَ كٍلِ تَا كُي، كْنْ بٍينُن عٍ شَ مَكُيَ، يُسُقُ نَشَ عَ قَلَ عَ شَ وَلِكّ بّ، «كٍلِ، عِ سِفَ نَ مِشِيٍ قْشْ رَ، عِ شَ عٍ سُشُ. عِ نَ عٍ لِ، عَ قَلَ عٍ بّ، ‹وٌ قٍ قَنيِ مَسَرَشِ قٍ كٌبِ رَ مُنقٍ رَ؟ ");
INSERT INTO susa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","مُنقٍ رَ وٌ ﭑ مَ مَنفّ شَ يٍ مِنسٍ فبٍتِ دَاشِ سٍ مَتٌسٍ مُحَشِ؟ نَ قٍ مْولِ مُ قَن.›» ");
INSERT INTO susa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","مَنفّ شَ وَلِكّ تٌ عٍ يِرٍ لِ، عَ نَشَ نَ بِرِن قَلَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","عٍ نَشَ عَ يَابِ، «مَنفّ، عِ وْيّنمَ يِ مْولِ رَ مُنقٍ رَ؟ مُشُ تَن، عِ شَ كٌنيِيٍ مُ نْمَ نَ مْولِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","مُشُ كْبِرِ نَشَن تٌ بّكِيٍ كُي كَنَان، مُشُ بَرَ قَ عَ رَ. مُنقٍ رَ مُشُ فبٍتِ، شَ نَ مُ عَ رَ شّيمَ، مُحَمَ عِ شَ مَنفّ شَ بَنشِ كُي؟ ");
INSERT INTO susa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","عِ نَ سٍسٍ تٌ مُشُ يِ رَ نَشَن قِندِشِ مِسِرَ مَنفّ فبٍ رَ، عِ شَ نَ كَنيِ قَشَ، عِ شَ مُشُ تَن دْنشْييٍ قَن قِندِ عِ شَ كٌنيِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","مَنفّ شَ كٌنيِ نَشَ عَ قَلَ، «نَ بَرَ قَن. وٌ نَشَن قَلَشِ يِ كِ، ﭑ قَن بَرَ تِن نَ رَ. ﭑ نَ سٍ كٍرٍن تٌ مِشِ نَشَن يِ رَ، نَ تَن بَرَ قِندِ ﭑ مَ كٌنيِ رَ، وٌ تَن دْنشْييٍ بَرَ كِسِ.» ");
INSERT INTO susa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","عٍ بِرِن نَشَ عٍ شَ بّكِيٍ رَفٌرٌ مَقُرٍن، عٍ نَشَ عٍ رَقُلُن. ");
INSERT INTO susa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","مَنفّ شَ كٌنيِ نَشَ عٍ قّتّنكّن قْلْ قٌرِ مَ عَ سَ دْشْ دِ مّدِ رَ. نَ يٍ مِنسٍ فبٍتِ دَاشِ نَشَ تٌ بُنيَمِن شَ بّكِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","نَ كُي يَشُبَ شَ دِيٍ نَشَ عٍ شَ دٌنمَيٍ عِبْو. عٍ بِرِن نَشَ عٍ شَ كٌتٍ بَكِ سٌقَلٍيٍ قَرِ، عٍ مَن نَشَ فبِلٍن تَا كُي. ");
INSERT INTO susa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","يُدَ نُن عَ شُنيَيٍ تٌ يُسُقُ شْنيِ لِ، عٍ نَشَ عٍ قٍلٍن عَ بُن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","يُسُقُ نَشَ عَ قَلَ عٍ بّ، «وٌ يِ رَبَشِ مُنقٍ رَ؟ وٌ مُ عَ كٌلٌن، مِشِ عَلْ ﭑ تَن عَ نْمَ سٍ مَتٌدٍ قٍ بِرِن مَ؟» ");
INSERT INTO susa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","يُدَ نَشَ عَ يَابِ، «ﭑ مُنسٍ قَلَمَ ﭑ مَ مَنفّ بّ؟ ﭑ لَن ﭑ شَ مُنسٍ قَلَ؟ مُشُ نْمَ قِيشّدٍ دِ؟ عَلَ بَرَ عِ شَ كٌنيِيٍ تٌ قٍ كٌبِ شُن مَ. مُشُ بَرَ قِندِ ﭑ مَ مَنفّ شَ كٌنيِيٍ رَ، مُشُ تَن نُن يِ يٍ مِنسٍ فبٍتِ دَاشِ تٌشِ مِشِ نَشَن يِ.» ");
INSERT INTO susa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","يُسُقُ نَشَ عَ قَلَ، «ﭑ مُ نْمَ نَ مْولِ رَبَدٍ. يِ يٍ مِنسٍ فبٍتِ دَاشِ تٌشِ مِشِ نَشَن يِ رَ، نَ نَن نَ ﭑ مَ كٌنيِ رَ، كْنْ وٌ تَن، وٌ سِفَ شَشِلِسَ كُي وٌ بَبَ يِرٍ.» ");
INSERT INTO susa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","نَ شَنبِ يُدَ نَشَ مَكْرّ مَنفّ رَ، عَ نَشَ عَ قَلَ عَ بّ، «ﭑ بَرَ عِ مَيَندِ ﭑ مَ مَنفّ، عَ لُ ﭑ شَ مَسٍنيِ ندٍ تِ عِ بّ. عِ بْحّ نَشَ تٍ ﭑ تَن عِ شَ كٌنيِ شِلِ مَ، بَرِ مَ عِ لُشِ نّ عَلْ مِسِرَ مَنفّ. ");
INSERT INTO susa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","عَ سِنفٍ رَ عِ مُشُ مَشْرِن نّ، قَ عَ قَلَ، ‹وٌ بَبَ نَ نَ؟ وٌ شُنيَ ندٍ نَ نَ؟› ");
INSERT INTO susa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","مُشُ نَشَ عِ يَابِ، ‹مُشُ بَبَ قٌرِشِ نَ نَ، عَ نُن مُشُ شُنيَ، عَ نَشَن سْتْشِ عَ شَ شّمّقٌرِحَ كُي. بُنيَمِن تَارَ بَرَ قَشَ، عَ كٍرٍن نَن قَ لُشِ عَ نفَ شَ دِيٍ يَ مَ، عَ تَن نَن نَقَن مُشُ بَبَ مَ.›» ");
INSERT INTO susa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«عِ بَرَ عَ قَلَ مُشُ تَن عِ شَ كٌنيِيٍ بّ، ‹وٌ قَ عَ رَ ﭑ شْن مَ عَلَكٌ ﭑ شَ عَ تٌ ﭑ يَ رَ.› ");
INSERT INTO susa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","مُشُ نَشَ ﭑ مَ مَنفّ يَابِ، ‹يِ دِ مّدِ مُ كٍلِمَ عَ بَبَ سّيتِ مَ، شَ نَ مُ عَ رَ عَ بَبَ قَشَمَ نّ.› ");
INSERT INTO susa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","كْنْ عِ بَرَ عَ قَلَ عِ شَ كٌنيِيٍ بّ، ‹شَ وٌ نُن وٌ شُنيَ بِرِن مُ قَ، ﭑ مُ ﭑ يَ تِمَ وٌ بّ.› ");
INSERT INTO susa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","مُشُ تٌ سِفَ ﭑ بَبَ يِرٍ، عِ شَ كٌنيِ، مُشُ نَشَ مَنفّ شَ دّنتّفّ سَ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«نَ دَنفِ شَنبِ، مُشُ بَبَ مَن نَشَ عَ قَلَ مُشُ بّ، ‹وٌ سِفَ، وٌ شَ سَ دٌنسٍ ندٍ سَرَ وٌن بّ.› ");
INSERT INTO susa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","مُشُ نَشَ عَ يَابِ، ‹مُشُ مُ نْمَ سِفَدٍ شَ مُشُ نُن مُشُ شُنيَ بِرِن مُ عَ رَ. شَ بِيَاسِ لَنمَ، قٌ مُشُ نُن مُشُ شُنيَ شَ سِفَ. شَ نَ مُ عَ رَ، يِ شّمّ مُ مُشُ رَ سّنّمَ.› ");
INSERT INTO susa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","عِ شَ كٌنيِ، ﭑ بَبَ، عَ عَ قَلَ نّ مُشُ بّ، ‹وٌ عَ كٌلٌن ﭑ مَ فِنّ دِ شّمّ قِرِن نَن بَرِشِ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","كٍرٍن كٍلِشِ نّ ﭑ شُن مَ، ﭑ حْشْ لُشِ عَ مَ تّمُندٍ سُبٍ ندٍ بَرَ عَ عِبْو، بَرِ مَ هَن يَكْسِ ﭑ مُ نُ عَ تٌ. ");
INSERT INTO susa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","شَ وٌ يِ دِ قَن تٌنفٌ ﭑ شُن مَ، قٍ حَاشِ ندٍ نَشَ عَ سْتْ، ﭑ قَشَمَ نّ نَ سُننُنيِ رَ ﭑ قَتٍ.›» ");
INSERT INTO susa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«يَكْسِ شَ ﭑ سَ فبِلٍن ﭑ بَبَ يِرٍ، شَ مُشُ نُن يِ دِ مّدِ بِرِن شَ مُ عَ رَ، ");
INSERT INTO susa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ﭑ بَبَ قَشَمَ نّ، بَرِ مَ عَ نِي لُوتِ نَن بُنيَمِن نَ. عَ نَ عَ تٌ يِ دِ مّدِ مُ نَ مُشُ قْشْ رَ، مُشُ تَن عِ شَ كٌنيِيٍ بَرَ عٍ بَبَ قٌرِشِ قَشَ سُننُنيِ رَ عَ قَتٍ. ");
INSERT INTO susa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ﭑ تَن عِ شَ كٌنيِ، ﭑ دْشْشِ نّ سّيكّ رَ يِ دِ مّدِ شَ قٍ رَ. ﭑ نُ بَرَ عَ قَلَ ﭑ بَبَ بّ، ‹شَ ﭑ مُ فبِلٍن عَ رَ عِ يِرٍ، نَ بَرَ قِندِ ﭑ مَ كٌتٍ رَ ﭑ مَ دُنِحّءِفِرِ بِرِن كُي.›» ");
INSERT INTO susa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«يَكْسِ ﭑ بَرَ عِ مَيَندِ، عِ شَ تِن ﭑ تَن شَ لُ يِ دِ مّدِ حْشْي رَ، ﭑ شَ قِندِ عِ شَ كٌنيِ رَ، عَلَكٌ يِ دِ مّدِ نُن عَ تَارَيٍ بِرِن شَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ﭑ نْمَ سِفَدٍ ﭑ بَبَ يِرٍ دِ، شَ مُشُ نُن يِ دِ مّدِ بِرِن شَ مُ عَ رَ؟ ﭑ مُ نْمَ عَ لُدٍ سُننُنيِ شَ ﭑ بَبَ قَشَ ﭑ يَ شْرِ.» ");
INSERT INTO susa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","يُسُقُ تٌ مُ نُ وَ مَ وَقٍ عَ شَ كٌنيِيٍ يَ شْرِ، عَ نَشَ عٍ يَمَرِ عٍ بِرِن شَ مِنِ. نَ كُي، عَ نُ عَ يّتّ مَسٍنمَ عَ تَارَيٍ بّ تّمُي نَشّ، مِشِ فبّتّ يٌ مُ نُ نَ نَا. ");
INSERT INTO susa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","يُسُقُ نَشَ وَ عَ شُي عِتٍشِ رَ، هَن مِسِرَكَيٍ نُن مِسِرَ مَنفّ شَ مِشِ بِرِن نَشَ نَ قٍ كٌلٌن. ");
INSERT INTO susa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","يُسُقُ نَشَ عَ مَسٍن عَ تَارَيٍ بّ، «يُسُقُ نَن ﭑ نَ! ﭑ بَبَ مَن نَ دُنِحّ؟» كْنْ عَ تَارَيٍ مُ نْ عَ يَابِدٍ قٍقٍ مَ. عٍ دّ بَرَ عِشَرَ، عٍ فَاشُ عَ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","يُسُقُ نَشَ عَ قَلَ عَ تَارَيٍ بّ، «ﭑ بَرَ وٌ مَشَندِ، وٌ شَ وٌ مَسٌ ﭑ نَ.» عٍ نَشَ عٍ مَسٌ عَ رَ. عَ نَشَ عَ قَلَ، «ﭑ تَن نَن نَ يُسُقُ رَ، وٌ شُنيَ، وٌ نَشَن مَتِ عَ شَ قِندِ كٌنيِ رَ مِسِرَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","يَكْسِ وٌ بْحّ نَشَ مِنِ، وٌ نَشَ فَاشُ، وٌ تٌ بَرَ ﭑ مَتِ كٌنيِ رَ، ﭑ سَرَ مَيٍ نَشَ قَ ﭑ نَ يِ بْشِ مَ. عَلَ نَن نَ رَفِرِشِ. عَ تَن نَن ﭑ شّيشِ وٌ يَ رَ عَلَكٌ ﭑ شَ وٌ رَكِسِ. ");
INSERT INTO susa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","وٌ بَرَ عَ تٌ، حّ قِرِن نَن يِ كِ كَامّ نَ بْشِ مَ، كْنْ حّ سُولِ مَن لُشِ. بْشِ مُ رَوَلِمَ، سَنسِ مُ شَبَمَ. ");
INSERT INTO susa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","عَلَ ﭑ نَسَنبَشِ نّ وٌ يَ رَ، عَلَكٌ ﭑ شَ بْشِ دٌنسٍ ندٍ رَفَتَ وٌ بّ، وٌ شَ نْ بَلٌدٍ مَرَتَنفّ كُي. ");
INSERT INTO susa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","وٌ تَن شَ مُ قَشِ ﭑ نَ بٍ. عَلَ نَ عَ رَ. عَ تَن نَن ﭑ قِندِ مِسِرَ مَنفّ بَبَ رَ، عَ شَ بَنشِ نُن عَ شَ بْشِ بِرِن شَ لُ ﭑ مَ يَامَرِ بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«وٌ شُلُن، وٌ شَ سِفَ ﭑ بَبَ يِرٍ. وٌ شَ عَ قَلَ عَ بّ، ‹عِ شَ دِ يُسُقُ يِ نَن قَلَشِ، «عَلَ بَرَ ﭑ قِندِ مِسِرَ مَنفّ رَ. عِ شَ سِفَ ﭑ يِرٍ، عِ نَشَ دُفُندِ. ");
INSERT INTO susa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","عِ قَمَ لُدٍ فٌسٍن بْشِ نَن مَ ﭑ قّ مَ، عِ تَن، عِ شَ دِيٍ، عِ شَ مَمَدِيٍ، عِ شَ شُرُ سٍيٍ، نُن عِ هَرِفٍ بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","حّ سُولِ كَامّ مَن لُشِ. ﭑ عِ هَيِ بِرِن قَنمَ نّ فٌسٍن، عَلَكٌ عِ نُن عِ شَ دٍنبَيَ نَشَ قِندِ سٍتَرٍيٍ رَ.»›» ");
INSERT INTO susa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«وٌ بَرَ عَ تٌ وٌ يّتّ يَ رَ، ﭑ شُنيَ بُنيَمِن قَن بَرَ عَ تٌ، عَ ﭑ تَن يَتِ نَن وْيّنقٍ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","وٌ شَ ﭑ مَ مَنفّيَ سّنبّ تَفِ رَبَ ﭑ بَبَ بّ، ﭑ نَ نَشَن كُي مِسِرَ بْشِ مَ، عَ نُن وٌ قٍ نَشَن بِرِن تٌشِ. وٌ وٌ شُلُن، وٌ شَ قَ ﭑ بَبَ رَ هَن بٍ.» ");
INSERT INTO susa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","يُسُقُ نَشَ قِندِفِلِن عَ شُنيَ بُنيَمِن مَ، عٍ قِرِن نَشَ وَ عَ شْرْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","يُسُقُ نَشَ عَ تَارَيٍ قَن مَسُنبُ، عٍ بِرِن نَشَ وَ. نَ شَنبِ، عَ تَارَيٍ نَشَ سُو سَ وْيّندٍ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","مِسِرَ مَنفّ نَشَ كٌلٌن سْتْ عَ مَ، عَ يُسُقُ تَارَيٍ بَرَ قَ. نَ نَشَ رَقَن مِسِرَ مَنفّ نُن عَ شَ مِشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","عَ نَشَ عَ مَسٍن يُسُقُ بّ، «عَ قَلَ عِ تَارَيٍ بّ، ‹وٌ كٌتٍ بَكِ وٌ شَ سٌقَلٍيٍ قَرِ، وٌ شَ سِفَ كَنَان بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","نَ تّمُي وٌ شَ فبِلٍن وٌ نُن وٌ بَبَ نُن وٌ شَبِلّ رَ ﭑ يِرٍ. سٍ قَنيِ نَشَن بِرِن نَ مِسِرَ بْشِ مَ، ﭑ نَ عَ سٌمَ نّ وٌ يِ رَ، وٌ مَن قَ بْشِ دَشَمُي قَنيِ دٌن.› ");
INSERT INTO susa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","عِ شَ عَ قَلَ عِ تَارَيٍ بّ، ‹وٌ شَ مِسِرَ فِسٍيٍ شَنِن، وٌ شَ وٌ بَبَ، وٌ شَ دِيٍ، نُن وٌ شَ فِنّيٍ بَكِ عٍ كُي، وٌ شَ قَ عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","وٌ نَشَ مْنّ سٍسٍ شَ قٍ رَ، بَرِ مَ سٍ قَنيِ نَشَن بِرِن نَ مِسِرَ بْشِ مَ، عَ قِندِ مَ وٌ فبٍ نَن نَ.›» ");
INSERT INTO susa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","عِسِرَيِلَ شَ دِيٍ نَشَ نَ رَبَ. يُسُقُ نَشَ فِسٍيٍ سٌ عَ تَارَيٍ يِ رَ عَلْ مِسِرَ مَنفّ عَ قَلَ عَ بّ كِ نَشّ. عَ نَشَ قَندّ قَن سٌ عٍ يِ رَ عٍ نَشَن دٌنمَ كِرَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","عَ نَشَ دٌنمَ قَنيِيٍ قِ عَ تَارَيٍ بِرِن مَ. كْنْ عَ كْبِرِ كٌلٍ كّمّ سَشَن نَن قِ بُنيَمِن تَن مَ، عَ نُن دٌنمَ سُولِ. ");
INSERT INTO susa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","عَ نَشَ مِسِرَ دَشَمُي قَنيِ بَكِ سٌقَلٍ قُ قَرِ عَ بَبَ شَ سَنبّ. عَ مَن نَشَ دٌنسٍ شْرِ، تَامِ، نُن قَندّ فبّتّيٍ بَكِ سٌقَلٍ فِنّ قُ قَرِ عَ بَبَ شَ بِيَاسِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","نَ دَنفِ شَنبِ، عَ نَشَ عَ تَارَيٍ لُ عٍ شَ سِفَ. عَ نَشَ عَ قَلَ عٍ بّ، «وٌ نَشَ فَلَنبُ كِرَ شْن مَ دٍ!» ");
INSERT INTO susa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","عٍ نَشَ كٍلِ مِسِرَ، عٍ تٍ كَنَان بْشِ مَ عٍ بَبَ يَشُبَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","عٍ نَشَ عَ قَلَ عَ بّ، «يُسُقُ مُ قَشَشِ! عَ تَن نَن مِسِرَ بْشِ بِرِن يَمَرِ مَ!» يَشُبَ تٌ نَ مّ، عَ مُ نْ لَدٍ نَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","كْنْ عٍ تٌ يُسُقُ شَ مَسٍنيِ بِرِن دّنتّفّ عَ بّ، عَ يَ قَن نَشَ فِسٍيٍ تٌ يُسُقُ نَشٍيٍ رَ سَنبَشِ عَ شَنِنقٍ رَ، يَشُبَ نَشَ سّيوَ. ");
INSERT INTO susa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","عِسِرَيِلَ نَشَ عَ قَلَ، «ﭑ بَرَ حّلّشِن، ﭑ مَ دِ يُسُقُ مَن نَ حّنفِقٍ. بٍينُن ﭑ شَ قَشَ، ﭑ قَمَ نّ عَ تٌدٍ.» ");
INSERT INTO susa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","يَشُبَ نَشَ عَ هَرِفٍ بِرِن شَنِن عَ شُن مَ. عَ تٌ بٍرِ سٍيبَ لِ، عَ نَشَ سّرّشّ بَ عَ بَبَ عِسِيَفَ مَرِفِ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","عَلَ نَشَ عِسِرَيِلَ شِلِ شِيٍ كُي، «يَشُبَ، يَشُبَ.» عِسِرَيِلَ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ.» ");
INSERT INTO susa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","عَلَ نَشَ عَ مَسٍن عَ بّ، «ﭑ تَن نَن نَ عَلَ رَ، عِ بَبَ مَرِفِ عَلَ. هَلِ عِ مُ فَاشُ سِفَقٍ رَ مِسِرَ، بَرِ مَ ﭑ عِ قِندِ مَ سِ بٍلٍبٍلٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","وٌن بِرِن نَن سِفَمَ مِسِرَ، ﭑ تَن نَن مَن قَمَ عِ رَفبِلٍندٍ بٍ. يُسُقُ يَتِ نَن قَمَ عِ يَيٍ رَفَلِدٍ عِ حْن تّمُي.» ");
INSERT INTO susa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","نَ كُي، يَشُبَ نَشَ كٍلِ بٍرِ سٍيبَ. عِسِرَيِلَ شَ دِيٍ نَشَ عٍ بَبَ يَشُبَ، عٍ شَ دِيٍ، عَ نُن عٍ شَ فِنّيٍ بَكِ فِسٍيٍ كُي، مِسِرَ مَنفّ نَشٍيٍ رَ سَنبَ. ");
INSERT INTO susa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","عٍ نَشَ عٍ شَ شُرُ سٍيٍ تٌنفٌ، عَ نُن عٍ سٍ نَشَن بِرِن سْتْ كَنَان بْشِ مَ. يَشُبَ نَشَ سِفَ مِسِرَ عَ نُن عَ بْنسْي بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","عَ نَشَ عَ شَ دِيٍ نُن عَ شَ مَمَدِيٍ بِرِن شَنِن عَ شُن مَ. عَ نَشَ سِفَ عَ تَن نُن عَ بْنسْي بِرِن. ");
INSERT INTO susa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","عِسِرَيِلَ شَ دِيٍ شِلِ نَن يَ نَشٍيٍ سِفَ مِسِرَ. يَشُبَ نُن عَ شَ دِ شّمّيٍ شَ تَرُشُي نَن يَ؛ يَشُبَ شَ دِ سِنفٍ لَنشِ رُبٍن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","رُبٍن شَ دِيٍ نَن يَ؛ هَنٌكِ، ثَلُ، هٍسٍرٌن، نُن كَرِ مِ. ");
INSERT INTO susa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","سِمٍيْن شَ دِيٍ نَن يَ؛ يٍمُوٍلِ، يَمِن، عٌهَدِ، يَكِن، سٌشَرَ، نُن سٌلِ. سٌلِ قِندِ كَنَان فِنّ شَ دِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","لٍوِ شَ دِيٍ نَن يَ؛ فٍرِ سٌن، كٌهَتَ، نُن مٍرَرِ. ");
INSERT INTO susa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","يُدَ شَ دِيٍ نَن يَ؛ عٍرِ، عٌنَن، سٍلَهَ، ثٍرٍ سِ، نُن سٍرَ. كْنْ عٍرِ نُن عٌنَن قَشَ كَنَان بْشِ نَن مَ. ثٍرٍ سِ شَ دِيٍ قِندِ هٍسٍرٌن نُن هَمُلِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","عِسَكَرِ شَ دِيٍ نَن يَ؛ تٌلَ، ثُوَ، يَسُبُ، نُن سِمِرٌن. ");
INSERT INTO susa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","سَبُلٌن شَ دِيٍ نَن يَ؛ سٍرٍدِ، عٍلٌن، نُن يَشَلٍيلِ. ");
INSERT INTO susa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","دِيٍ نَن نَ كِ، لٍيَ نَشٍيٍ بَرِ يَشُبَ بّ ثَدَن عَرَ مِ. عَ مَن نَشَ عَ شَ دِ فِنّ دِنَ بَرِ نَا. عَ شَ دِ شّمّيٍ نُن دِ فِنّيٍ كْنتِ بِرِن نَلَنشِ مِشِ تٌنفٌ سَشَن عَ نُن سَشَن. ");
INSERT INTO susa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","فَدِ شَ دِيٍ نَن يَ؛ سٍقٌن، هَفِ، سُنِ، عٍسِبٌن، عٍرِ، عَرٌدِ، نُن عَرٍلِ. ");
INSERT INTO susa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","عَسٍرِ شَ دِيٍ نَن يَ؛ يِمِنَ، يِسِوَ، يِسِوِ، بٍرِيَ، عَ نُن عٍ شُنيَ فِنّمَ سٍرَ. بٍرِيَ شَ دِيٍ قِندِ هٍبٍرِ نُن مَلَكِيٍلِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","دِيٍ نَن نَ كِ، سِلِثَ نَشٍيٍ بَرِ يَشُبَ بّ. عٍ بِرِن نَلَنشِ مِشِ قُ نُن سٍننِ. لَبَن نُ بَرَ سِلِثَ سٌ عَ شَ دِ فِنّ لٍيَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","يَشُبَ شَ فِنّ رَشٍلٍ شَ دِيٍ نَن يَ؛ يُسُقُ نُن بُنيَمِن. ");
INSERT INTO susa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","عَسٍنَ نَشَ دِ قِرِن سْتْ يُسُقُ بّ مِسِرَ بْشِ مَ؛ مَنَسِ نُن عٍقِرَ مِ. عَسَنَ نَن لَنشِ عٌن سّرّشّدُبّ ثٌتِقَرِ شَ دِ فِنّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","بُنيَمِن شَ دِيٍ نَن يَ؛ بٍلَ، بٍكٍرِ، عَسِبٍلِ، فٍرَ، نَامَن، عٍكِ، رٌ سِ، شُثِمِ، مُثِمِ، نُن عَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","دِيٍ نَن نَ كِ، رَشٍلٍ نَشٍيٍ بَرِ يَشُبَ بّ. عٍ بِرِن نَلَنشِ مِشِ قُ نُن نَانِ. ");
INSERT INTO susa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","دَنَ شَ دِ نَن يَ؛ شُسِمِ. ");
INSERT INTO susa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","نَقَتَلِ شَ دِيٍ نَن يَ؛ يَشَسٍيلِ، فُنِ، يٍسٍرِ، نُن سِلٍمِ. ");
INSERT INTO susa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","دِيٍ نَن نَ كِ، بِلَ نَشٍيٍ بَرِ يَشُبَ بّ. عٍ بِرِن نَلَنشِ مِشِ سٌلٌقٍرٍ. لَبَن نُ بَرَ بِلَ سٌ عَ شَ دِ فِنّ رَشٍلٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","يَشُبَ نُن مِشِ نَشٍيٍ بِرِن سِفَ مِسِرَ، عَ بْنسْي بِرِن نَلَنشِ مِشِ تٌنفٌ سٍننِ نُن سٍننِ، بَقٍ عَ شَ دِيٍ شَ فِنّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","يُسُقُ دِ شّمّ قِرِن نَن بَرِ مِسِرَ. يَشُبَ شَبِلّ نَشَن سِفَ مِسِرَ بْشِ مَ، عٍ كْنتِ بِرِن نَلَنشِ مِشِ تٌنفٌ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","يَشُبَ نَشَ يُدَ شّي عَ يَ رَ يُسُقُ شْن مَ، عَلَكٌ عَ شَ كِرَ يَءِلَن عٍ بّ سِفَقٍ رَ فٌسٍن. عٍ تٌ سٌ فٌسٍن بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","يُسُقُ نَشَ عَ فِسٍ تٌنفٌ، عَ نَشَ سِفَ عَ بَبَ عِسِرَيِلَ رَلَندٍ نَا. عَ تٌ عَ لِ، عَ نَشَ قِندِفِلِن عَ مَ، عَ نُ قَ وَ رَ عَ شْنكُيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","عِسِرَيِلَ نَشَ عَ قَلَ يُسُقُ بّ، «هَلِ ﭑ قَشَ قَ، ﭑ بْحّ بَرَ سَ بَرِ مَ ﭑ بَرَ عِ يَتَفِ تٌ، عِ مَن نَ حّنفِقٍ.» ");
INSERT INTO susa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","يُسُقُ نَشَ عَ قَلَ عَ تَارَيٍ بّ، عَ نُن عَ بَبَ شَ دٍنبَيَ، «ﭑ شَ سِفَ، ﭑ شَ سَ عَ قَلَ مِسِرَ مَنفّ بّ، ‹ﭑ تَارَيٍ نُن ﭑ بَبَ شَ دٍنبَيَ نَشٍيٍ نُ سَبَتِشِ كَنَان بْشِ مَ، عٍ بِرِن بَرَ قَ ﭑ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","يِ مِشِيٍ فْورّ كَنيِيٍ نَن عٍ رَ. عٍ شُرُ سٍيٍ نَن دّ مَدٌنمَ. عٍ بَرَ قَ عٍ شَ فْورّيٍ رَ، سِيٍ، يّشّييٍ، نِنفٍيٍ، نُن عٍ هَرِفٍ بِرِن.› ");
INSERT INTO susa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","مِسِرَ مَنفّ نَ وٌ شِلِ تّمُي نَشّ، عَ وٌ مَشْرِنمَ نّ وٌ شَ وَلِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","وٌ شَ عَ يَابِ، ‹مُشُ تَن عِ شَ كٌنيِيٍ قِندِشِ شُرُ سٍ مَشُرِيٍ نَن نَ، كَبِ مُشُ دِ مّدِ تّمُي هَن يَكْسِ، عَلْ مُشُ بٍنبَيٍ نُ عَ رَبَمَ كِ نَشّ.› نَ كُي وٌ قَمَ لُدٍ فٌسٍن بْشِ نَن مَ، بَرِ مَ شُرُ سٍ دّ مَدٌنيِيٍ رَحَاشُ مِسِرَكَيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","يُسُقُ نَشَ سِفَ عَ سَ عَ قَلَ مِسِرَ مَنفّ بّ، «ﭑ بَبَ نُن ﭑ نفَشَكٍرٍنيِيٍ بَرَ قَ فٌسٍن كٍلِقٍ كَنَان بْشِ مَ. عٍ بَرَ قَ عٍ شَ شُرُ سٍيٍ نُن عٍ هَرِفٍ بِرِن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","عَ نَشَ عَ تَارَ سُولِ ندٍيٍ مَسٍن مِسِرَ مَنفّ بّ. ");
INSERT INTO susa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","مِسِرَ مَنفّ نَشَ يُسُقُ تَارَيٍ مَشْرِن، «وٌ وَلِ مُندُن نَبَمَ؟» عٍ نَشَ مِسِرَ مَنفّ يَابِ، «مُشُ تَن عِ شَ كٌنيِيٍ قِندِشِ شُرُ سٍ دّ مَدٌنيِيٍ نَن نَ، عَلْ مُشُ بٍنبَيٍ نُ عَ رَبَمَ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","عٍ مَن نَشَ عَ قَلَ مِسِرَ مَنفّ بّ، «مُشُ قَشِ نّ، مُشُ شَ لُ يِ بْشِ مَ سِندٍن، بَرِ مَ سّشّ مُ نَ مُشُ شْنيِ كْرّ شُرُ سٍيٍ نَشَن دٌنمَ. كَامّ بَرَ دِن كَنَان بْشِ رَ. مُشُ بَرَ عِ مَيَندِ عِ شَ مُشُ تَن عِ شَ كٌنيِيٍ سَفٌ سَ، مُشُ شَ لُ فٌسٍن بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","مِسِرَ مَنفّ نَشَ عَ قَلَ يُسُقُ بّ، «عِ بَبَ نُن عِ تَارَيٍ بَرَ قَ عِ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","مِسِرَ بْشِ نَ عِ سَفٌي. يِرٍ قَنيِ قٍن فٌسٍن مَبِرِ، عِ بَبَ نُن عِ نفَشَكٍرٍنيِيٍ لُمَ دّننَشّ. شَ عِ مِشِ مَتِنشِنشِيٍ كٌلٌن عٍ يَ مَ، عٍ سُفَندِ عٍ شَ قِندِ ﭑ مَ شُرُ سٍ دّ مَدٌنيِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","نَ دَنفِ شَنبِ، يُسُقُ نَشَ عَ بَبَ شَنِن مِسِرَ مَنفّ يِرٍ، عَ عَ مَسٍن عَ بّ. يَشُبَ نَشَ دُبَ مِسِرَ مَنفّ بّ. ");
INSERT INTO susa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","مِسِرَ مَنفّ نَشَ يَشُبَ مَشْرِن، «عِ شَ سِمَيَ حّ يٍرِ عَ رَ يِ كِ؟» ");
INSERT INTO susa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","يَشُبَ نَشَ مِسِرَ مَنفّ يَابِ، «ﭑ مَ سِمَيَ حّ كّمّ حّ تٌنفٌ سَشَن نَ عَ رَ يِ كِ. ﭑ سِمَيَ دُنكٍ نَشَسِشِ نَن سْتْشِ. عَ حَن مُ مَكْرّشِ ﭑ بٍنبَيٍ شَ سِمَيَ شَسَبِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","يَشُبَ تٌ دُبَ مِسِرَ مَنفّ بّ، عَ نَشَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","يُسُقُ نَشَ بْشِ قَنيِ قِ عَ بَبَ نُن عَ تَارَيٍ مَ، عَلْ مِسِرَ مَنفّ عَ يَمَرِ كِ نَشّ. عٍ بْشِ نَشَن سْتْ عَ تَن نَن قَن مِسِرَ بْشِ بِرِن بّ. عَ شِلِ رَ مٍسٍسِ. ");
INSERT INTO susa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","يُسُقُ نَشَ مّينِ عَ بَبَ، عَ تَارَيٍ، نُن عَ بَبَ شَ دٍنبَيَيٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","نَ تّمُي كَامّ نُ بَرَ سّنبّ سْتْ. دٌنسٍ مُ نُ تٌمَ كٍلِ مِسِرَ بْشِ مَ هَن كَنَان. كَامّ نَشَ حَمَ هَلَكِ. ");
INSERT INTO susa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","كْبِرِ نَشَن بِرِن نُ نَ مِسِرَ نُن كَنَان بْشِ مَ، يُسُقُ نَشَ عَ مَسَرَ مّنفِ رَ. عَ نَشَ نَ كْبِرِ رَفَتَ مِسِرَ مَنفّ شَ بَنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","مِسِرَكَيٍ نُن كَنَانكَيٍ شَ كْبِرِ بِرِن تٌ حْن، مِسِرَكَيٍ نَشَ قَ يُسُقُ يِرٍ عٍ عَ قَلَ، «دٌنسٍ سٌ مُشُ يِ رَ! عَ لَنمَ مُشُ شَ قَشَ عِ يَ شْرِ؟ مُشُ شَ كْبِرِ بِرِن بَرَ حْن.» ");
INSERT INTO susa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","يُسُقُ نَشَ عٍ يَابِ، «وٌ قَ وٌ شَ شُرُ سٍيٍ رَ، وٌن شَ عَ مَسَرَ دٌنسٍ رَ، بَرِ مَ كْبِرِ مُ نَ وٌ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","عٍ نَشَ قَ عٍ شَ شُرُ سٍيٍ رَ يُسُقُ شْن مَ. عٍ شَ سٌي، سِيٍ، يّشّييٍ، نِنفٍيٍ، نُن سٌقَلٍيٍ، عٍ نٍيٍ بِرِن مَسَرَ يُسُقُ مَ دٌنسٍ رَ. عَ نَشَ دٌنسٍ تَشُن عٍ رَ عٍ شَ شُرُ سٍيٍ مَسَرّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","نَ حّ تٌ دَنفِ، عٍ نَشَ قَ عَ يِرٍ، عٍ عَ قَلَ عَ بّ، «مُشُ مُ نْمَ مُشُ نْشُندٍ مُشُ شَ مَنفّ مَ. كْبِرِ يٌ مُ نَ مُشُ يِ رَ. مُشُ شَ شُرُ سٍ قَن بِرِن نَ مُشُ شَ مَنفّ يِ رَ. مُشُ فُندِيٍ نُن مُشُ شَ بْشِيٍ فبَنسَن نَن لُشِ مُشُ يِ رَ دٌنسٍ سَرٍ رَ مُشُ شَ مَنفّ بّ. ");
INSERT INTO susa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","عَ لَنمَ مُشُ شَ قَشَ عِ يَ شْرِ، مُشُ شَ بْشِيٍ شُن شَ رَكَنَ؟ مُشُ نُن مُشُ شَ بْشِيٍ مَسَرَ دٌنسٍ رَ، مُشُ شَ قِندِ مِسِرَ مَنفّ شَ كٌنيِيٍ رَ، مُشُ شَ بْشِيٍ قَن شَ قِندِ عَ فبٍ رَ. سَنسِ شْرِ سٌ مُشُ يِ رَ مُشُ نَشَن نَوَلِمَ، مُشُ شَ بَلٌ عَلَكٌ مُشُ نَشَ قَشَ، بْشِ قَن نَشَ رَبّحِن.» ");
INSERT INTO susa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","نَ كُي يُسُقُ نَشَ مِسِرَكَيٍ شَ بْشِ بِرِن سَرَ مِسِرَ مَنفّ بّ. كَامّ شَ شْرْشْي نُ بَرَ عَ نِيَ عٍ شَ عٍ شَ بْشِ بِرِن مَتِ مِسِرَ مَنفّ مَ. ");
INSERT INTO susa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","يُسُقُ مِسِرَ حَمَ بِرِن قِندِ كٌنيِيٍ رَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","كْنْ سّرّشّدُبّيٍ تَن مُ عٍ فبٍ بْشِيٍ سَرَ، بَرِ مَ مِسِرَ مَنفّ نُ هِننّمَ عٍ رَ دٌنسٍ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","يُسُقُ نَشَ عَ قَلَ حَمَ بّ، «ﭑ بَرَ وٌ سَرَ تٌ عَ نُن وٌ شَ بْشِيٍ مِسِرَ مَنفّ بّ. سَنسِ نَن يِ كِ، وٌ شَ بْشِيٍ رَوَلِ. ");
INSERT INTO susa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","عَ شَبَ تّمُي، وٌ عَ دْشْ سُولِ ندٍ سٌمَ مِسِرَ مَنفّ نَن يِ رَ. دْشْ نَانِ نَشٍيٍ لُمَ، نَ قِندِ مَ سَنسِ نُن بَلٌي نَن نَ، وٌ تَن، وٌ شَ دِيٍ، عَ نُن وٌ شَ مِشِ بِرِن بّ.» ");
INSERT INTO susa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","عٍ نَشَ عَ قَلَ، «عِ بَرَ مُشُ رَكِسِ! مُشُ بَرَ مُشُ شَ مَنفّ شَ قٍ قَنيِ تٌ عَ نَشَن نَبَشِ مُشُ بّ. مُشُ قِندِ مَ مِسِرَ مَنفّ شَ كٌنيِيٍ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","يُسُقُ نَشَ نَ قِندِ سّرِيّ رَ. هَن تٌ مِسِرَ بْشِ دَشَمُي دْشْ سُولِ ندٍ بِرِن قِندِ مِسِرَ مَنفّ نَن فبٍ رَ. سّرّشّدُبّيٍ شَ بْشِيٍ نَن فبَنسَن مُ قِندِشِ مِسِرَ مَنفّ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","عِسِرَيِلَكَيٍ نَشَ سَبَتِ فٌسٍن مِسِرَ بْشِ مَ. نَ بْشِ نَشَ قِندِ عٍ فبٍ رَ. عٍ بْنسْي نَشَ فبٌ يّ. ");
INSERT INTO susa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","يَشُبَ حّ قُ نُن سٌلٌقٍرٍ نَن نَبَ مِسِرَ بْشِ مَ. عَ شَ سِمَيَ نَشَ حّ كّمّ حّ تٌنفٌ نَانِ نُن سٌلٌقٍرٍ لِ. ");
INSERT INTO susa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","عِسِرَيِلَ شَ سِمَيَ تٌ نُ قَ حْنقٍ، عَ نَشَ عَ شَ دِ يُسُقُ شِلِ، عَ عَ قَلَ عَ بّ، «نَ كُي، عِ شَ عِ بّلّشّ دْشْ ﭑ تَبٍ بُنيِ رَ، عِ قَ عِ كَلِ ﭑ بّ قَ عَ قَلَقٍ رَ، عِ مُ ﭑ نَفَتَمَ يِ مِسِرَ بْشِ مَ، عِ شَ مّينِ ﭑ مَ تِنشِنيِ كُي، عِ هِننّ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ﭑ نَ لَاشِرَ تّمُي نَشّ، عِ شَ ﭑ نَمِنِ مِسِرَ، عِ سَ ﭑ نَفَتَ ﭑ بٍنبَيٍ شَ فَبُرِ يِرٍ.» يُسُقُ نَشَ عَ يَابِ، «عِ نَشَن قَلَشِ ﭑ بّ، ﭑ نَ رَبَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","يَشُبَ نَشَ عَ قَلَ، «عِ رَكَلِ ﭑ بّ.» يُسُقُ نَشَ عَ كَلِ عَ بّ. نَ تّمُي يَشُبَ نَشَ عَ قٍلٍن عَ شَ سَدٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","نَ قٍ بِرِن تٌ بَرَ دَنفِ، عٍ نَشَ عَ قَلَ يُسُقُ بّ، «عِ بَبَ مُ يَلَنشِ.» يُسُقُ نَشَ سِفَ عَ بَبَ يِرٍ، عَ نُن عَ شَ دِ شّمّ قِرِنيِيٍ، مَنَسِ نُن عٍقِرَ مِ. ");
INSERT INTO susa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","مِشِ ندٍ نَشَ عَ قَلَ يَشُبَ بّ، «عِ شَ دِ يُسُقُ بَرَ قَ.» عِسِرَيِلَ نَشَ سّنبّ رَبَ، عَ كٍلِ، عَ دْشْ سَدٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","يَشُبَ نَشَ عَ قَلَ يُسُقُ بّ، «عَلَ سّنبّ كَنيِ مِنِ نّ ﭑ مَ لُسِ كَنَان بْشِ مَ. عَ نَشَ بَرَكّ سَ ﭑ مَ قٍ. ");
INSERT INTO susa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","عَلَ نَشَ عَ قَلَ ﭑ بّ، ‹ﭑ عِ قِندِ مَ دِبَرِ بٍلٍبٍلٍ نَن نَ. ﭑ عِ شَ دِيٍ رَوُيَمَ نّ، هَن عٍ قِندِ حَمَ فبٍفبٍ رَ. ﭑ يِ بْشِ قِمَ نّ عِ بْنسْي مَ، هَلِ عِ دَنفِ شَنبِ، عَ قِندِ عٍ فبٍ رَ هَن دُنِحَ حْن.›» ");
INSERT INTO susa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«يَكْسِ يِ دِ قِرِنيِيٍ، عِ نَشٍيٍ بَرِشِ مِسِرَ بٍينُن ﭑ تَن شَ قَ، ﭑ بَرَ عٍ قِندِ ﭑ مَ دِيٍ رَ. عٍقِرَ مِ نُن مَنَسِ قِندِ مَ ﭑ تَن نَن فبٍ رَ، عَلْ رُبٍن نُن سِمٍيْن. ");
INSERT INTO susa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","كْنْ عِ دِ نَشٍيٍ بَرِ مَ يٍيٍ شَنبِ رَ، عِ فبٍ لَنشِ نٍيٍ نَن مَ. عٍ قَمَ لُدٍ عٍ تَارَيٍ نَن بُن مَ عٍ كّ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ﭑ تٌ كٍلِ ثَدَن، رَشٍلٍ نَشَ قَشَ ﭑ يِ رَ كِرَ شْن كَنَان بْشِ مَ. عَ حْندٍ مُ نُ مَكُيَ عٍقَرَتَ رَ. ﭑ نَشَ عَ رَفَتَ مّننِ، عٍقَرَتَ كِرَ رَ، دّننَشّ شِلِ بّتّلّيمُ.» ");
INSERT INTO susa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","عِسِرَيِلَ نَشَ يُسُقُ شَ دِيٍ مَتٌ، عَ قَ عَ قَلَ، «ندٍيٍ يٍيٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","يُسُقُ نَشَ عَ بَبَ يَابِ، «ﭑ مَ دِ شّمّيٍ نَ عٍ رَ عَلَ نَشٍيٍ قِشِ ﭑ مَ بٍ.» عِسِرَيِلَ نَشَ عَ قَلَ، «عِ شَ عٍ مَسٌ ﭑ نَ، عَلَكٌ ﭑ شَ دُبَ عٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","يَشُبَ نُ بَرَ فّ قٌرِدٍ، عَ يَيٍ مُ نُ سٍيٍ عِفبّمَ سْنْن. يُسُقُ تٌ عَ شَ دِيٍ مَسٌ عَ رَ، عِسِرَيِلَ نَشَ عٍ مَسُنبُ، عَ قِندِفِلِن عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","عِسِرَيِلَ نَشَ عَ قَلَ يُسُقُ بّ، «ﭑ مُ نُ لَشِ عَ رَ، شَ ﭑ عِ يَتَفِ تٌمَ سْنْن، كْنْ عَلَ بَرَ عَ رَفِرِ ﭑ بَرَ عِ شَ دِيٍ قَن تٌ.» ");
INSERT INTO susa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","يُسُقُ نَشَ عَ شَ دِيٍ تٌنفٌ عَ بَبَ سَن مَ، عَ قَ عَ رَقٍلٍن بْشِ قَرِ. ");
INSERT INTO susa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","نَ دَنفِ شَنبِ، يُسُقُ نَشَ عَ شَ دِ قِرِنيِيٍ تٌنفٌ عٍ بّلّشّ مَ. عَ نَشَ عٍقِرَ مِ سُشُ عَ يِرٍقَنيِ بّلّشّ رَ، عِسِرَيِلَ كْولَ مَبِرِ. عَ نَشَ مَنَسِ سُشُ عَ كْولَ بّلّشّ رَ، عِسِرَيِلَ يِرٍقَنيِ مَبِرِ. عَ نَشَ عٍ مَسٌ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","كْنْ يَشُبَ نَشَ عَ يِرٍقَنيِ بّلّشّ سَ عٍقِرَ مِ شُنيِ قَرِ نَشَن نَ دِ مّدِ رَ. عَ نَشَ عَ كْولَ بّلّشّ سَ مَنَسِ شُنيِ قَرِ نَشَن نَ دِ سِنفٍ رَ. عَ نُ عَ كٌلٌن عَ نُ قٍ نَشَن نَبَمَ عَ بّلّشّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","عَ نَشَ دُبَ يُسُقُ بّ، عَ قَ عَ قَلَ، «عَلَ، ﭑ بٍنبَيٍ عِبُرَهِمَ نُن عِسِيَفَ حّرّ نَشَن يَ شْرِ، عَلَ نَشَن نَ ﭑ كَنتَمَ رَ، كَقِ ﭑ بَرِ لْشْي هَن تٌ، ");
INSERT INTO susa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","عَلَ نَشَن مَلٍكّ شّيشِ ﭑ نَتَنفَدٍ قٍ شْرْشْي مَ، عَ شَ بَرَكّ سَ يِ دِ مّيٍ شَ قٍ. مِشِيٍ شَ عٍ شِلِ ﭑ شِلِ رَ، عٍ شَ عٍ شِلِ ﭑ بٍنبَيٍ عِبُرَهِمَ نُن عِسِيَفَ شِلِ رَ. عٍ بْنسْي شَ وُيَ عَ فبٍفبٍ رَ دُنِحَ.» ");
INSERT INTO susa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","يُسُقُ نَشَ عَ تٌ عَ بَبَ بَرَ عَ يِرٍقَنيِ بّلّشّ سَ عٍقِرَ مِ شُنيِ مَ. نَ قٍ مُ رَقَنشِ عَ مَ. عَ نَشَ عَ بَبَ بّلّشّ سُشُ، عَ بَ عٍقِرَ مِ شُنيِ مَ، عَ قَ عَ سَ مَنَسِ شُنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","يُسُقُ نَشَ عَ قَلَ عَ بَبَ بّ، «ﭑ بَبَ، نَ كِ شَ مُ عَ رَ، بَرِ مَ يِ نَن نَ قٌرِ رَ. عِ يِرٍقَنيِ بّلّشّ سَمَ يِ نَن شُنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","عَ بَبَ نَشَ تٌندِ، عَ قَ عَ قَلَ، «ﭑ مَ دِ، ﭑ عَ كٌلٌن، ﭑ عَ كٌلٌن. عَ قَن قَمَ قِندِدٍ بْنسْي وُيَشِ كَنيِ نَن نَ. عَ قَن فبٌمَ نّ، كْنْ عَ شُنيَ نَن قَمَ فبٌدٍ دَنفِقٍ عَ رَ. عَ شُنيَ بْنسْي قِندِ مَ نّ سِ وُيَشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","عَ نَشَ دُبَ عٍ بّ نَ لْشْي، عَ قَ عَ قَلَ، «عِسِرَيِلَكَيٍ دُبَ رَبَمَ وٌ شِلِيٍ نَن نَ. عٍ قَمَ عَ قَلَدٍ، ‹عَلَ شَ عِ لُ عَلْ عٍقِرَ مِ نُن مَنَسِ.›» نَ كُي عَ نَشَ عٍقِرَ مِ تِ يَرٍ مَنَسِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","عِسِرَيِلَ نَشَ عَ قَلَ يُسُقُ بّ، «عِ بَرَ عَ تٌ، عَ فبٍ مُ لُشِ ﭑ شَ لَاشِرَ، كْنْ عَلَ تِمَ نّ عِ قَنفَ رَ، عَ قَ عِ رَفبِلٍن عِ بٍنبَيٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ﭑ قَمَ كّ قِدٍ عِ مَ دَنفِ عِ تَارَيٍ رَ. ﭑ بْشِ نَشَن نَسُشُ عَمٌرِكَيٍ يِ رَ ﭑ مَ سَنتِدّفّمَ نُن ﭑ مَ شَلِ سَابُي رَ، ﭑ بَرَ نَ قَن سَ عِ كّ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","يَشُبَ نَشَ عَ شَ دِيٍ شِلِ، عَ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ وٌ مَلَن، ﭑ شَ قٍ قَلَ نَشَن قَمَ رَبَدٍ وٌ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«يَشُبَ شَ دِيٍ، وٌ قَ بٍ، وٌ شَ وٌ تُلِ مَتِ وٌ بَبَ عِسِرَيِلَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","رُبٍن، عِ تَن، ﭑ مَ دِ سِنفٍ، عِ تَن نَن نَ ﭑ مَ قٌنِكٍ دِ رَ. عِ بَرَ قِندِ قِسَمَنتٍ رَ لَسِرِيَ كُي. عِ سّنبّ دَنفِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","كْنْ عِ تٌ قِندِ شُرُتَرٍ نَن نَ، عَلْ يٍ نَشَن سُسُمَ، عِ مُ قِسَمَنتٍيَ سْتْمَ سْنْن، بَرِ مَ عِ بَرَ عِ سَ عِ بَبَ شَ سَدٍ مَ عَ نُن عِ نَندٍن. نَ بَرَ قِندِ سّنِيّنتَرٍحَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","سِمٍيْن نُن لٍوِ قِندِشِ نفَشَكٍرٍنمَيٍ نَن نَ. سَنتِدّفّمَ نَن نَ عٍ شَ فٍرٍ سٌسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ﭑ مُ سٌمَ عٍ شَ قٍقٍ يَ مَ، ﭑ مُ تِنمَ دْشْدٍ عٍ شَ مَلَنيِ، بَرِ مَ عٍ شَ بْحّتٍ كُي عٍ بَرَ شّمّيٍ قَشَ، عٍ شَ كَلَبَنتٍحَ كُي عٍ بَرَ تُورَيٍ مَشْنْ قُقَقُ. ");
INSERT INTO susa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ﭑ بَرَ عٍ شَ بْحّتٍ دَنكَ، بَرِ مَ فٍرٍفِرِيٍ نَن عٍ رَ. عٍ نَشَن نَبَمَ، ﭑ بَرَ نَ دَنكَ، بَرِ مَ عٍ يَ عِشَرَ. عٍ بْنسْي مُ لُمَ يِرٍ كٍرٍن يَشُبَ شْنيِ، ﭑ عٍ رَيٍنسٍنمَ نّ عِسِرَيِلَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","يُدَ، عِ شُنيَيٍ عِ تَن نَن تَنتُمَ. عِ قَمَ نّ شُتُ سْتْدٍ عِ يَشُييٍ مَ. عِ بَبَ شَ دِ شّمّيٍ مَفٌرٌ مَ نّ عِ بّ. ");
INSERT INTO susa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","يُدَ، يّتّ يْرّ نَن لَنشِ عِ مَ. ﭑ مَ دِ، عِ بَلٌمَ سُبٍ نَن شُن نَ. عِ شِنبِيٍ كُنتَنمَ نّ عَلْ يّتّ. ندٍ نْمَ سُو سَدٍ عَ شَ عِ رَكٍلِ. ");
INSERT INTO susa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","مَنفّ سَوُرِ قَمَ لُدٍ يُدَ بْنسْي نَن يِ. مِشِ يٌ مُ مَنفّ سَوُرِ بَمَ عَ يِ، بٍيمَنُ تْنشُمَ كَنيِ قَمَ تّمُي نَشّ، سِيٍ سُيِدِ مَ نَشَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","عَ شَ سٌقَلٍ شِرِ مَ وّنِ بِلِ نَن نَ، عَ شَ سٌقَلٍ يْرّ شِرِ مَ وّنِ بِلِ قَنيِ نَن نَ. عَ شَ دٌنمَ نُن عَ شَ شِنبٍلِ دٌنمَ شَمَ وّنِ يٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","عَ يَ مَحِنفِشِ عَلْ وّنِ، عَ حِنيِ قِيشّ عَلْ شِحّ. ");
INSERT INTO susa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","سَبُلٌن قَمَ سَبَتِدٍ بَا دّ نّ. عَ قِندِ مَ وَقُ دّ نَن نَ كُنكُييٍ بّ. عَ شَ نَانِنيِ لُمَ نّ سِدْن نَن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","عِسَكَرِ سّنبّ فبٌ عَلْ سٌقَلٍ، نَشَن عَ سَمَ فْورّ قِرِنيِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","عَ سَشِ بْشِ نَشَن مَ، يِرٍ قَنيِ نَن عَ رَ. عَ تُنكِ قٍلٍنمَ نّ كٌتٍ بُن مَ، عَ لُمَ يَامَرِ نَن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","دَنَ عَ شَ حَمَ يَمَرِ مَ نّ، عَلْ عِسِرَيِلَ بْنسْي ندٍ. ");
INSERT INTO susa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","عَ لُمَ نّ عَلْ بْشِمَسٍ كِرَ شْن مَ، عَلْ تَنبَلُنبٍ سَنكِرَ رَ. عَ نَ سٌي تِنفِلِنيِ شِن، سٌي رَفِ بِرَ مَ نّ عَ قَرِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","عَلَتَلَ، ﭑ شَشِلِ تِشِ عِ شَ كِسِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","فَدِ، فٍرٍ سٌي عَ فٍرٍ مَ نّ، كْنْ عَ تَن نَن عٍ رَبٌرٌنمَ عَ تِنفِلِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","عَسٍرِ شَ بْشِ قِندِ مَ دَشَمُي قَنيِ يِرٍ نَن نَ، نَشَن قِندِ مَ مَنفّ دَشَمُدٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نَقَتَلِ لُمَ نّ عَلْ شٍلِ فِنّ نَشَن نَ عَ فِقٍ، عَ وْيّن قَنيِيٍ قَلَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","يُسُقُ لُمَ نّ عَلْ سَنسِ بُرّشّ نّينّ، نَشَن بٌفِمَ عَ قَنيِ رَ شُرٍ سّيتِ مَ. عَ سَلٌنيِيٍ تِمَ تّتّ نَن شُن. ");
INSERT INTO susa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","مِشِيٍ نَشَ فٍرٍ فِرِ عَ مَ، عٍ نَشَ شَلِ وٌلِ عَ مَ فٍرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","كْنْ عَ شَ شَلِ سّنبّ فبٌ، عَ بّلّشّ قَن شْرْشْ يَشُبَ مَرِفِ عَلَ سّنبّ كَنيِ سَابُي رَ، نَشَن قِندِشِ عِسِرَيِلَ كَنتَمَ رَ، نَشَن لُشِ عَلْ قَنيٍ. ");
INSERT INTO susa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","عِ بَبَ مَرِفِ عَلَ قَمَ عِ مَلِدٍ. عَلَ سّنبّ كَنيِ بَرَكّ سَمَ نّ عِ شَ قٍ. عَ كٌورٍ بَرَكّ قِمَ نّ عِ مَ، عَ بْشِ بَرَكّ قِ عِ مَ، عَ دِبَرِ بَرَكّ رَفِرِ عِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","عِ بَبَ شَ دُبّ دَنفِ بَلٌي نُن سٍ قَنيِ بِرِن نَ، نَشَن كٍلِمَ فٍيَ قَرِ، فٍيَ نَشَن تِشِ كَقِ دُنِحَ قْلّ. نَ بَرَكّ بِرِن شَ لُ يُسُقُ مَ، نَشَن قِندِ عَ نفَشَكٍرٍنيِيٍ شَ مَنفّ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بُنيَمِن لُمَ نّ عَلْ وُلَءِ بَرٍ شَاحّ. عَ سُبٍ قَشَمَ فّيسّفّ، عَ عَ دْنشْي دٌن نُنمَرٍ.» ");
INSERT INTO susa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","عِسِرَيِلَ بْنسْي قُ نُن قِرِنيِيٍ نَن نَ كِ، عَ نُن دُبّ عٍ بَبَ نَشَن نَبَشِ كَنكَن بّ. ");
INSERT INTO susa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","نَ دُبّ دَنفِ شَنبِ، يَشُبَ نَشَ عَ حُنفُ عَ شَ دِيٍ مَ، عَ قَلَقٍ رَ، «ﭑ قَ سِفَقٍ ﭑ بٍنبَ قَشَشِيٍ نَن يِرٍ. ﭑ نَ قَشَ، وٌ ﭑ نَفَتَ ﭑ بٍنبَيٍ رَفَتَدٍ، فَبُرِ نَشَن نَ عٍقٍرٌن شِتِكَ شَ شّ يِرٍ، ");
INSERT INTO susa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","مَكِثٍلَ شّ قْنمّ رَ، مَمِرٍ قّ مَ، كَنَان بْشِ مَ. عِبُرَهِمَ نَ شّ سَرَشِ عٍقٍرٌن شِتِكَ نَن مَ، عَلَكٌ نَ شَ قِندِ عَ شَ مِشِ رَفَتَدٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","عِبُرَهِمَ رَفَتَشِ مّننِ نّ، عَ نُن عَ شَ فِنّ سَرَ. عِسِيَفَ قَن نَفَتَشِ مّننِ نّ عَ نُن عَ شَ فِنّ رٍبٍكَ. ﭑ تَن قَن لٍيَ رَفَتَشِ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","نَ شّ نُن نَ قْنمّ نَشَن نَ نَا، عٍ سَرَشِ شِتِكَيٍ نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","يَشُبَ تٌ بَرَ فّ عَ شَ وْيّنيِ مَسٍندٍ عَ شَ دِيٍ بّ، عَ نَشَ عَ سَ سَدٍ مَ، عَ قَ لَاشِرَ، عَ عَ بٍنبَيٍ لِ عَلِفِيَمَ. ");
INSERT INTO susa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","يُسُقُ نَشَ قِندِفِلِن عَ بَبَ مَ، عَ مَسُنبُ، عَ وَ مَ. ");
INSERT INTO susa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","نَ دَنفِ شَنبِ، يُسُقُ نَشَ يَامَرِ قِ سٍرِبَيٍ مَ عٍ شَ عَ بَبَ قَتٍ سْشْ سٍرِ رَ، عَلَكٌ عَ قُرٍ نَشَ بْرْ. عٍ نَشَ نَ وَلِ رَبَ عَ بَبَ عِسِرَيِلَ رَ ");
INSERT INTO susa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","شِ تٌنفٌ نَانِ بُن مَ عٍ شَ نَامُنيِ كِ مَ. مِسِرَكَيٍ نَشَ عَ حْنقٍ رَبَ شِ تٌنفٌ سٌلٌقٍرٍ بُن. ");
INSERT INTO susa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","حْن قٍ تٌ بَرَ بَ عَ رَ، يُسُقُ نَشَ عَ قَلَ مِسِرَ مَنفّ شَ مِشِيٍ بّ، «ﭑ بَرَ وٌ مَيَندِ، شَ ﭑ مَ قٍ رَقَن وٌ مَ، وٌ شَ ﭑ وَشْنقٍ مَسٍن مِسِرَ مَنفّ بّ. ");
INSERT INTO susa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ﭑ بَبَ ﭑ نَكَلِ نّ، عَ نَشّ، ‹ﭑ قَ نَ قَشَقٍ نّ. عِ ﭑ نَفَتَمَ فَبُرِ نَن كُي ﭑ نَشَن فٍشِ كَنَان بْشِ مَ.› نَ كُي ﭑ وَ مَ سِفَقٍ نّ ﭑ شَ سَ ﭑ بَبَ رَفَتَ. ﭑ نَ فّ، ﭑ قَمَ.» ");
INSERT INTO susa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","مِسِرَ مَنفّ نَشَ عَ يَابِ، «سِفَ، عِ شَ سَ عِ بَبَ رَفَتَ عَلْ عَ عِ رَكَلِشِ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","يُسُقُ نَشَ سِفَ عَ بَبَ رَفَتَدٍ. عَ نَشَ سِفَ عَ نُن مِسِرَ مَنفّ شَ كٌنيِيٍ، مِسِرَ مَنفّ شَ مِشِ شُنفبٍيٍ، مِسِرَ كُنتِفِيٍ، ");
INSERT INTO susa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","عَ يّتّ شَ دٍنبَيَ، عَ تَارَيٍ، نُن عَ بَبَ شَ دٍنبَيَ. عٍ شَ دِ مّدِيٍ نُن عٍ شَ شُرُ سٍيٍ فبَنسَن نَشَ لُ فٌسٍن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","سْورِيٍ نُن سٌي رَفِيٍ نَشَ يُسُقُ مَتِ عٍ شَ فِسٍيٍ كُي. حَمَ بٍلٍبٍلٍ نَن نُ عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","عٍ تٌ عَتَدِ لٌنيِ لِ يُرُدّن نَاكِرِ مَ، عٍ نَشَ حْن قٍ بٍلٍبٍلٍ رَبَ. يُسُقُ نَشَ بِنيّ قِ عَ بَبَ مَ، عَ حْن قٍ شَنِن هَن شِ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","كَنَانكَيٍ نَشَ عٍ حْشْ دْشْ نَ مَرَفَتّ شْن مَ، نَشَن نَبَشِ عَتَدِ شَ لٌنيِ مَ. عٍ نَشَ عَ قَلَ، «يِ حْن قٍ قِندِ قٍ بٍلٍبٍلٍ نَن نَ مِسِرَكَيٍ بّ.» نَ نَن عَ تٌشِ عٍ نَشَ «مِسِرَ حْن قٍ» شِلِ قَلَ نَ يِرٍ شُن يُرُدّن نَاكِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","نَ كُي، يَشُبَ شَ دِيٍ نَشَ عٍ بَبَ وَشْنقٍ رَبَ عَلْ عَ عَ قَلَ عٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","عٍ نَشَ عَ شَنِن كَنَان بْشِ مَ، عٍ نَشَ عَ رَفَتَ مَكِثٍلَ شَ شّ يِرٍ قْنمّ كُي، عِبُرَهِمَ شّ نَشَن سَرَ عٍقٍرٌن شِتِكَ مَ عَلَكٌ نَ شَ قِندِ مِشِ رَفَتَدٍ رَ مَمِرٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","يُسُقُ تٌ فّ عَ بَبَ رَفَتَدٍ، عَ نَشَ فبِلٍن مِسِرَ بْشِ مَ، عَ نُن عَ تَارَيٍ نُن مِشِ نَشَن بِرِن عَ مَتِ. ");
INSERT INTO susa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","يُسُقُ تَارَيٍ تٌ بَرَ عَ تٌ عٍ بَبَ بَرَ قَشَ، عٍ نَشَ عَ قَلَ، «شَ يُسُقُ قَ وٌن قِندِ عَ فٍرٍقَ رَ، وٌن قٍ حَاشِ نَشَن بِرِن نَبَشِ عَ رَ، عَ فبٍحْشْمَ نّ وٌن مَ.» ");
INSERT INTO susa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","نَ كُي عٍ نَشَ سِفَ يُسُقُ يِرٍ، عٍ عَ قَلَ عَ بّ، «عِ بَبَ يِ نَن قَلَشِ مُشُ بّ بٍينُن عَ شَ قَشَ، عَ نَشّ، ");
INSERT INTO susa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹وٌ يِ قَلَ يُسُقُ بّ، «ﭑ بَرَ عِ مَشَندِ، دِحّ عِ تَارَيٍ شَ فبَلٌي قٍ مَ عَ نُن عٍ شَ يُنُبِ، بَرِ مَ عٍ بَرَ قٍ حَاشِ رَبَ عِ رَ. ﭑ بَرَ عِ مَشَندِ، يَكْسِ دِحّ عِ بَبَ مَرِفِ عَلَ شَ كٌنيِيٍ مَ.»›» عٍ تٌ نَ مَسٍنيِ قَلَ يُسُقُ بّ، عَ نَشَ وَ. ");
INSERT INTO susa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","عَ تَارَيٍ نَشَ عٍ قٍلٍن عَ بُن مَ، عٍ قَ عَ قَلَ، «مُشُ تَن نَن يَ، عِ شَ كٌنيِيٍ.» ");
INSERT INTO susa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","يُسُقُ نَشَ عَ قَلَ عٍ بّ، «هَلِ وٌ مُ فَاشُ. عَلَ مُ نَ ﭑ تَن شَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","وٌ لَن نّ ﭑ شُن وٌ نَشَ قٍ حَاشِ رَبَ ﭑ نَ، كْنْ عَلَ نَشَ عَ مَسَرَ قٍ قَنيِ رَ عَلَكٌ ﭑ شَ قٍ رَكَمَلِ حَمَ نِي رَتَنفَقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","يَكْسِ هَلِ وٌ مُ فَاشُ. ﭑ وٌ هَيِ بِرِن قَنمَ نّ نُن وٌ شَ دِيٍ.» عَ شَ وْيّنيِ نَشَ عٍ بْحّ سَ. ");
INSERT INTO susa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","يُسُقُ نَشَ لُ مِسِرَ، عَ تَن نُن عَ شَ دٍنبَيَ بِرِن. عَ نَشَ حّ كّمّ حّ قُ سْتْ سِمَيَ رَ. ");
INSERT INTO susa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","يُسُقُ نَشَ عَ شَ مَمَدِيٍ نُن عَ تٌلٌبِتّيٍ تٌ، عَ شَ دِ عٍقِرَ مِ نَشٍيٍ سْتْ. عَ نَشَ مَنَسِ شَ دِ مَكِرِ شَ دِيٍ تٌ، عَ نٍيٍ تٌنفٌ عَ فبٍ دِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","يُسُقُ نَشَ عَ قَلَ عَ تَارَيٍ بّ، «ﭑ قَن نَ قَشَقٍ نّ، كْنْ عَلَ وٌ مَلِمَ نّ عَ قَنيِ رَ. عَ قَمَ نّ وٌ تٌنفٌدٍ مِسِرَ، عَ وٌ شَنِن بْشِ مَ عَ دّننَشّ لَايِدِ تٌنفٌ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ بّ.» ");
INSERT INTO susa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","يُسُقُ نَشَ عِسِرَيِلَ شَ دِيٍ رَكَلِ، عَ قَ عَ قَلَ، «عَلَ نَ وٌ مَلِ فبِلٍنقٍ رَ كَنَان بْشِ مَ، وٌ شَ ﭑ قُرٍ شَنِن نَا.» ");
INSERT INTO susa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","يُسُقُ لَاشِرَ عَ حّ كّمّ حّ قُ نَن مَ. عٍ نَشَ عَ قُرٍ سْشْ سٍرِ رَ عَلَكٌ عَ قَتٍ نَشَ بْرْ، عٍ عَ رَفَتَ قُرٍ كَنكِرَ كُي مِسِرَ بْشِ مَ.");
INSERT INTO susa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","عِسِرَيِلَ شَ دِيٍ شِلِيٍ نَن يَ، نَشٍيٍ عٍ بَبَ يَشُبَ مَتِ مِسِرَ بْشِ مَ، عَ نُن عٍ شَ دٍنبَيَيٍ؛ ");
INSERT INTO susa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رُبٍن، سِمٍيْن، لٍوِ، يُدَ، ");
INSERT INTO susa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","عِسَكَرِ، سَبُلٌن، بُنيَمِن، ");
INSERT INTO susa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دَنَ، نَقَتَلِ، فَدِ، نُن عَسٍرِ. ");
INSERT INTO susa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","يَشُبَ شَ دِيٍ نُن عَ شَ مَمَدِيٍ نُ لَنشِ مِشِ تٌنفٌ سٌلٌقٍرٍ نَن مَ. عَ شَ دِ يُسُقُ حَن نُ بَرَ سِفَ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","يُسُقُ نُن عَ نفَشَكٍرٍنيِيٍ دَنفِ شَنبِ، ");
INSERT INTO susa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","عِسِرَيِلَكَيٍ نَشَ يِرِوَ مِسِرَ بْشِ مَ، عٍ سّنبّ نُ لُمَ شُن مَسَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","نَ وَشَتِ مَنفّ فبّتّ نَن نُ نَ مِسِرَ شُن مَ، نَشَن مُ يُسُقُ كٌلٌن. ");
INSERT INTO susa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","عَ نَشَ عَ قَلَ عَ شَ حَمَ بّ، «وٌ عَ تٌ، عِسِرَيِلَكَيٍ يِرِوَشِ كِ نَشّ، عَ بَرَ قِندِ كْنتْقِلِ رَ وٌن بّ. عٍ بَرَ دَنفِ وٌن نَ. ");
INSERT INTO susa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","وٌن شَ كْوتَ ندٍ رَبَ عَلَكٌ عٍ نَشَ وُيَ سْنْن. شَ نَ مُ، فٍرٍ تّمُي، عٍ قَمَ نّ كَقُدٍ وٌن يَشُييٍ مَ، عٍ كٍلِ وٌن شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","نَ كُي، مَنفّ نَشَ عٍ قِندِ كٌنيِيٍ رَ، عَ وَلِ شْرْشْي دْشْ عٍ مَ ثِتٌمِ نُن رَ مٍسٍسِ تَايٍ تِقٍ رَ. مِسِرَ مَنفّ قِرَوُنَ نُ دٌنسٍ مَلَنمَ نَ تَايٍ نَن كُي. ");
INSERT INTO susa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","كْنْ وَلِ شْرْشْي نُ دْشْمَ عٍ مَ كِ نَشّ، عٍ مَن نُ سِفَمَ فبٌ رَ نَ كِ نّ، هَن مِسِرَكَيٍ بْحّ نَشَ رَحَاشُ عٍ مَ عِسِرَيِلَكَيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","مِسِرَكَيٍ نَشَ عٍ رَوَلِ عَ حَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","عٍ نَشَ عٍ تْورْ وَلِ شْرْشْي رَ عَلْ بِرِكِ بْنبْقٍ نُن شّيٍ رَوَلِقٍ. عٍ نَشَ كٌنيِيَ حَاشِ دْشْ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","مِسِرَ مَنفّ نَشَ عِسِرَيِلَكَيٍ شَ دِرَ سُشُييٍ سِقِرَ نُن ثُوَ يَمَرِ، ");
INSERT INTO susa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«وٌ نَ عِسِرَيِلَ فِنّ شَ دِ رَ سُشُ، شَ شّمّ نَن عَ رَ، وٌ عَ قَشَ كٍرٍن نَ. شَ فِنّ نَن عَ رَ، وٌ شَ عَ لُ عَ شَ بَلٌ.» ");
INSERT INTO susa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","كْنْ دِرَ سُشُييٍ تٌ نُ فَاشُمَ عَلَ يَ رَ، عٍ مُ نُ مِسِرَ مَنفّ شَ يَامَرِ رَبَتُمَ. عٍ نَشَ دِ شّمّمَيٍ لُ عٍ شَ بَلٌ. ");
INSERT INTO susa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","مَنفّ نَشَ دِرَ سُشُييٍ شِلِ، عَ نَشَ عٍ مَشْرِن، «مُنقٍ رَ وٌ دِ شّمّيٍ لُمَ، عٍ شَ بَلٌ؟» ");
INSERT INTO susa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","دِرَ سُشُييٍ نَشَ قِرَوُنَ يَابِ، «عِسِرَيِلَ فِنّيٍ سّنبّ فبٌ مِسِرَ فِنّيٍ بّ. بٍينُ دِرَ سُشُي شَ عٍ يِرٍ لِ، عٍ حَن بَرَ دِ بَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","عَلَ نَشَ هِننّ نَ دِرَ سُشُييٍ رَ. عِسِرَيِلَ حَمَ نَشَ وُيَ دَنفِقٍ عَ سِنفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","دِرَ سُشُييٍ تٌ فَاشُ عَلَ يَ رَ، عَلَ نَشَ دِيٍ قِ عٍ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","نَ تّمُي، قِرَوُنَ نَشَ عَ شَ حَمَ بِرِن يَمَرِ، «وٌ عِسِرَيِلَكَيٍ شَ دِيْرّ شّمّيٍ وٌلِ نِلِ شُرٍ مَ، كْنْ وٌ عٍ شَ دِ فِنّيٍ تَن لُ، عٍ شَ بَلٌ.» ");
INSERT INTO susa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","شّمّ نُن فِنّ ندٍ نَشَ عٍ بٌورٍ قُتِ، عٍ بِرِن قَتَن لٍوِ بْنسْي نَن نَ عِسِرَيِلَكَيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","نَ فِنّ نَشَ تّيفّ، عَ دِ شّمّ بَرِ. عَ تٌ عَ تٌ دِ قَنيِ نَن نُ عَ رَ، عَ نَشَ عَ نْشُن كِكٍ سَشَن. ");
INSERT INTO susa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","عَ تٌ مُ نُ نْمَ عَ نْشُندٍ سْنْن، عَ نَشَ كْلِمّ دٍبٍ مَسٌ دٌلٍ رَ، عَ دِيْرّ سَ عَ كُي، عَ قَ دٍبٍ دْشْ نِلِ شُرٍ مَ يٌقٌرٌي تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","نَ دِيْرّ تَارَ فِنّمَ نُ تِشِ يِرٍ ندٍ، عَ يَ تِشِ عَ شُنيَ رَ، عَلَكٌ عَ شَ عَ كٌلٌن قٍ نَشَن قَمَ نَ لِدٍ. ");
INSERT INTO susa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","قِرَوُنَ شَ دِ فِنّ نَشَ فٌرٌ نِلِ شُرٍ مَ عَ مَشَدٍ. عَ تٌ دٍبٍ تٌ يٌقٌرٌي تَفِ، عَ نَشَ عَ شَ كٌنيِ فِنّ ندٍ شّي عَ تٌنفٌدٍ. ");
INSERT INTO susa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","عَ تٌ عَ رَبِ، عَ نَشَ دِ شّمّ تٌ عَ كُي، عَ وَقٍ. عَ نَشَ كِنِكِنِ عَ مَ، عَ قَ عَ قَلَ، «عِسِرَيِلَكَ ندٍ شَ دِ نَ عَ رَ!» ");
INSERT INTO susa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","نَ تّمُي، دِيْرّ تَارَ نَشَ قِرَوُنَ شَ دِ فِنّ مَشْرِن، «ﭑ شَ سِفَ عِسِرَيِلَ دِنفّ ندٍ شِلِ عِ بّ، عَ شَ قَ شِحّ قِ عَ مَ؟» ");
INSERT INTO susa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","قِرَوُنَ شَ دِ فِنّ نَشَ عَ يَابِ، «عِيٌ.» دِيْرّ تَارَ نَشَ سِفَ، عَ سَ دِيْرّ نفَ شِلِ. ");
INSERT INTO susa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","قِرَوُنَ شَ دِ فِنّ نَشَ عَ قَلَ دِيْرّ نفَ بّ، «يِ دِيْرّ شَنِن، عِ شَ شِحّ قِ عَ مَ ﭑ بّ. ﭑ عِ سَرٍ قِمَ نّ.» دِيْرّ نفَ نَشَ دِيْرّ تٌنفٌ، عَ شِحّ قِ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","دِيْرّ تٌ مْ، عَ نفَ نَشَ عَ شَنِن قِرَوُنَ شَ دِ فِنّ شْن مَ، عَ قِندِ نَ شَ دِ رَ. عَ تٌ عَ رَ مِنِشِ يٍ نَن شْورَ، عَ نَشَ عَ شِلِ سَ مُنسَ، نَشَن قَلَشِ «مِنِقٍ» عٍبُرُ شُي رَ. ");
INSERT INTO susa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","مُنسَ تٌ قٌنِكٍيَ رَكَمَلِ، عَ نَشَ سِفَ عَ نفَشَكٍرٍنيِيٍ يِرٍ، عَ شَ عٍ شُن مَتٌ عَ رَ عٍ شَ وَلِ شْرْشْي كُي. عَ تٌ عَ نفَشَكٍرٍنيِيٍ يِرٍ لِ، عَ نَشَ مِسِرَكَ ندٍ تٌ عِسِرَيِلَكَ ندٍ بْنبْ رَ. ");
INSERT INTO susa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","عَ تٌ مُ مِشِ يٌ تٌ نَ لٌنفٌرِ، عَ نَشَ نَ مِسِرَكَ قَشَ، عَ قَ عَ قُرٍ نْشُن مّيّنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","نَ كُيٍ عِبَ، مُنسَ مَن نَشَ مِنِ، عَ عِسِرَيِلَكَ قِرِن تٌ سْنشْ رَ. عَ نَشَ مِشِ مَشْرِن نْندِ مُ نَ نَشَن بّ، «عِ بَرِبٌورٍ بْنبْقٍ مُنقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","عَ نَشَ عَ يَابِ، «ندٍ عِ قِندِشِ مَنفّ نُن كِيتِسَ رَ مُشُ شُن مَ؟ عِ وَ مَ ﭑ قَن قَشَقٍ نّ، عَلْ عِ نَ مِسِرَكَ قَشَ كِ نَشّ؟» مُنسَ نَشَ فَاشُ. عَ نَشَ عَ قَلَ عَ بْحّ مَ، «ﭑ نَشَن نَبَشِ عَ بَرَ كٌلٌن.» ");
INSERT INTO susa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","قِرَوُنَ تٌ عَ كٌلٌن مُنسَ نَشَن نَبَشِ، عَ نَشَ كَتَ مُنسَ قَشَدٍ. كْنْ مُنسَ نَشَ عَ فِ قِرَوُنَ مَ، عَ سَ سَبَتِ مَدِيَن بْشِ مَ. مُنسَ تٌ سِفَ نَا، عَ نَشَ كْلْنيِ ندٍ لِ، عَ قَ دْشْ عَ شَ عَ مَلَبُ. ");
INSERT INTO susa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","مَدِيَن سّرّشّدُبّ شَ دِ فِنّ سٌلٌقٍرٍ نَشَ قَ يٍ بَدٍ نَ كْلْنيِ يِرٍ عٍ بَبَ شَ شُرُ سٍيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","كْنْ شُرُ سٍ دّمَدٌنيِ ندٍيٍ قَن نَشَ قَ، عٍ نَشَ وَ نَ فِنّيٍ كٍرِقٍ. مُنسَ تٌ نَ تٌ، عَ نَشَ كٍلِ، عَ نَ فِنّيٍ شُن مَفٍرٍ سٌ، عَ قَ يٍ قِ عٍ شَ شُرُ سٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","نَ فِنّيٍ تٌ فبِلٍن عٍ بَبَ رٍيُوٍلِ يِرٍ، عَ نَشَ عٍ مَشْرِن، «مُنسٍ عَ نِيَشِ وٌ فبِلٍنشِ سِننَنيِ مَ تٌ؟» ");
INSERT INTO susa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","عٍ نَشَ عَ يَابِ، «مِسِرَكَ ندٍ بَرَ مُشُ رَتَنفَ شُرُ سٍ دّمَدٌنيِ كٌبِيٍ مَ، عَ مَن قَ يٍ بَ وٌن مَ شُرُ سٍيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","رٍيُوٍلِ نَشَ عَ شَ دِ فِنّيٍ مَشْرِن، «عَ نَ مِندٍن؟ وٌ عَ لُشِ نَا مُنقٍ رَ؟ وٌ سَ عَ شِلِ، وٌ دٌنسٍ سٌ عَ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","مُنسَ نَشَ تِن سَبَتِدٍ رٍيُوٍلِ شْنيِ. رٍيُوٍلِ نَشَ عَ شَ دِ فِنّ سِثٌرَ قِ مُنسَ مَ، عَ شَ عَ دْشْ. ");
INSERT INTO susa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","سِثٌرَ نَشَ دِ شّمّ بَرِ عَ بّ. شْحّ نَن تٌ لَنشِ مُنسَ مَ نَ بْشِ مَ، عَ نَشَ عَ شَ دِ شِلِ سَ فٍرِ سٌمِ، نَشَن وَ مَ عَ قَلَقٍ، «شْحّ نَن ﭑ نَ يِ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","حّ وُيَشِ دَنفِ شَنبِ، مِسِرَ مَنفّ نَشَ قَشَ. عِسِرَيِلَكَيٍ نُ عٍ مَوَقٍ عَلَ بّ عٍ شَ كٌنيِيَ شْرْشْي شَ قٍ رَ. نَ مَشَندِ نَشَ عَلَ لِ. ");
INSERT INTO susa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","عَلَ نَشَ عٍ وَ شُي مّ. عَ نَشَ رَتُ عَ شَ سَاتّ مَ نَشَن شِرِشِ عَ تَن نُن عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","نَ كُي عَلَ نَشَ عَ يَ رَقِندِ عِسِرَيِلَكَيٍ مَ، عَ شَ عَ حّنفِ سَ عٍ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","مُنسَ بِتَنيِ يٍتِرٌ نَن نُ نَ مَدِيَن سّرّشّدُبّ رَ. مُنسَ نَشَ يٍتِرٌ شَ شُرُ سٍيٍ شَنِن وُلَ عِ يِرٍ مَكُيٍ، هَن عَ سَ عَلَ شَ فٍيَ شٌرٍبٍ لِ. ");
INSERT INTO susa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","مّننِ عَلَتَلَ شَ مَلٍكّ نَشَ مِنِ عَ مَ وُرِ بِلِ لَنمَدِ مَ، نَشَن رَدّشّشِ. مُنسَ نَشَ عَ مَتٌ، تّ نُ نَ نَ وُرِ بِلِ مَ، كْنْ وُرِ بِلِ مُ فَنشِ. ");
INSERT INTO susa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","مُنسَ نَشَ عَ قَلَ عَ يّتّ مَ، «ﭑ شَ ﭑ مَكْرّ يِ كَابَنَكٌ رَ، ﭑ شَ عَ كٌلٌن مُنقٍ رَ وُرِ بِلِ لَنمَ مُ فَنشِ.» ");
INSERT INTO susa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","عَلَتَلَ تٌ مُنسَ تٌ عَ مَكْرْشِ وُرِ بِلِ رَ عَلَكٌ عَ شَ عَ عِفبّ، عَ نَشَ عَ شِلِ كٍلِقٍ نَ وُرِ بِلِ مَ، «مُنسَ، مُنسَ!» مُنسَ نَشَ عَ رَتِن، «ﭑ تَن نَن يَ.» ");
INSERT INTO susa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","عَلَ نَشَ عَ مَسٍن عَ بّ، «عِ نَشَ عِ مَكْرّ بٍ رَ. سَنكِرِيٍ بَ، بَرِ مَ عِ تِشِ يِرٍ سّنِيّنشِ نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","عَ مَن نَشَ عَ مَسٍن، «عِ بَبَ مَرِفِ عَلَ نَ ﭑ تَن نَ، عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ مَرِفِ عَلَ.» مُنسَ تٌ نَ مّ، عَ نَشَ عَ يَتَفِ مَكٌتٌ، بَرِ مَ عَ نُ فَاشُشِ عَلَ مَتٌقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","عَلَتَلَ مَن نَشَ يِ مَسٍنيِ تِ مُنسَ بّ، «ﭑ بَرَ ﭑ مَ حَمَ شَ تْورّ تٌ مِسِرَ بْشِ مَ. ﭑ بَرَ عٍ وَ شُي مّ عٍ شَ كٌنيِيَ كُي. ﭑ حّنفِ سَشِ عٍ شَ تْورّ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ﭑ فٌرٌشِ نَ نَن مَ، ﭑ شَ قَ عٍ بَدٍ مِسِرَكَيٍ يِ رَ، ﭑ شَ عٍ رَ سٌ بْشِ قَنيِ مَ، لُدٍ فبٍفبٍ نَ دّننَشّ. شِحّ نُن كُمِ فبٌ نَا، كَنَانكَيٍ، شِتِكَيٍ، عَمٌرِكَيٍ، ثٍرِ سِكَيٍ، هِوِكَيٍ نُن يٍبُسُكَيٍ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","يَكْسِ عِسِرَيِلَكَيٍ وَ شُي بَرَ ﭑ لِ. ﭑ مَن بَرَ حَشَنكَتّ تٌ مِسِرَكَيٍ نَشَن دْشْقٍ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","سِفَ، ﭑ بَرَ عِ شّي قِرَوُنَ شْن، عِ شَ ﭑ مَ حَمَ عِسِرَيِلَ رَ مِنِ مِسِرَ.» ");
INSERT INTO susa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","مُنسَ نَشَ عَ قَلَ عَلَ بّ، «مِشِ مْولِ مُندُن نَ ﭑ تَن نَ، ﭑ شَ سِفَ قِرَوُنَ مَ عِسِرَيِلَكَيٍ رَ مِنِقٍ رَ مِسِرَ؟» ");
INSERT INTO susa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","عَلَ نَشَ عَ يَابِ، «وٌن بِرِن نَ عَ رَ. عِ نَ فّ حَمَ رَ مِنِدٍ مِسِرَ بْشِ مَ، وٌ قَمَ ﭑ بَتُدٍ يِ فٍيَ نَن قَرِ. نَ قِندِ مَ تْنشُمَ رَ، قَ عَ قَلَ، ﭑ تَن يَتِ نَن عِ شّيشِ.» ");
INSERT INTO susa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","مُنسَ نَشَ عَ قَلَ عَلَ بّ، «ﭑ نَ سَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ بٍنبَيٍ مَرِفِ عَلَ نَن ﭑ شّيشِ وٌ مَ،› عٍ قَ سَ ﭑ مَشْرِن عِ شِلِ مَ، ﭑ يَابِ مُندُن قِمَ عٍ مَ؟» ");
INSERT INTO susa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","عَلَ نَشَ عَ مَسٍن مُنسَ بّ، «ﭑ نَ ‹نَشَن نَ› نَ. عِ شَ عِسِرَيِلَكَيٍ يَابِ، ‹عَلَ نَشَن نَ، عَ بَرَ ﭑ شّي وٌ مَ.›» ");
INSERT INTO susa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","عَلَ مَن نَشَ عَ مَسٍن مُنسَ بّ، «عِ قَمَ وْيّندٍ يِ كِ نّ عِسِرَيِلَكَيٍ بّ، ‹وٌ بٍنبَ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ مَرِفِ عَلَتَلَ، عَلَ نَشَن نَ، نَ نَن ﭑ شّيشِ وٌ مَ.› ﭑ شِلِ نَن نَ كِ عَبَدَن، ﭑ وَ مَ مِشِ بِرِن شَ ﭑ شِلِ نَ كِ نّ تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","سَ عِسِرَيِلَ كُنتِفِيٍ مَلَن، عِ عَ قَلَ عٍ بّ، ‹وٌ بٍنبَ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ مَرِفِ عَلَتَلَ بَرَ مِنِ ﭑ مَ. عَ بَرَ عَ مَسٍن ﭑ بّ، «ﭑ بَرَ قٍ تٌ عٍ نَشَن دْشْقٍ وٌ مَ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ﭑ بَرَ نَتّ تٌنفٌ وٌ رَ مِنِقٍ رَ مِسِرَ وٌ شَ تْورّ كُي. ﭑ شَ وٌ شَنِن كَنَانكَيٍ، شِتِكَيٍ، عَمٌرِكَيٍ، ثٍرِ سِكَيٍ، هِوِكَيٍ، نُن يٍبُسُكَيٍ شْنيِ، شِحّ نُن كُمِ شّلّمَ دّننَشّ.»›» ");
INSERT INTO susa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«عِسِرَيِلَ كُنتِفِيٍ نَ فّ عِ شُي رَ مّدٍ، وٌ سِفَمَ نّ مِسِرَ مَنفّ يِرٍ عَ قَلَقٍ رَ، ‹عِسِرَيِلَكَيٍ مَرِفِ عَلَتَلَ بَرَ قَ مُشُ قْشْ رَ. عِ شَ مُشُ سَفٌ سَ مُشُ شَ قّيحّن سَشَن حّرّ رَبَ فبٍنفبٍرٍنيِ مَ، عَلَكٌ مُشُ شَ سّرّشّيٍ بَ مُشُ مَرِفِ عَلَتَلَ بّ.› ");
INSERT INTO susa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ﭑ عَ كٌلٌن مِسِرَ مَنفّ مُ تِنمَ وٌ لُدٍ وٌ شَ سِفَ، شَ ﭑ مُ ﭑ سّنبّ مَسٍن عَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","نَ كُي ﭑ قٍ مَفَاشُشِيٍ رَبَمَ نّ مِسِرَكَيٍ رَ، ﭑ عٍ تْورْ كَابَنَكٌي رَ. نَ دَنفِ شَنبِ، عٍ شَ مَنفّ تِنمَ نّ وٌ شَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ﭑ مَن عَ رَفِرِ مَ نّ مِسِرَكَيٍ شَ وٌ كِ، عَلَكٌ وٌ نَشَ سِفَ وٌ بّلّشّ عِفٍلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","عِسِرَيِلَ فِنّ بِرِن شَ عٍ دْشْبٌورٍ مِسِرَكَيٍ مَكُلَ يِرَبَسٍ فبٍتِ نُن شّيمَ دَاشِيٍ رَ، عَ نُن سٌسٍيٍ، وٌ نَشٍيٍ سٌمَ وٌ شَ دِيٍ مَ. نَ كُي وٌ هَرِفٍ بَمَ نّ مِسِرَكَيٍ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","مُنسَ نَشَ عَلَتَلَ مَشْرِن، «شَ عِسِرَيِلَكَيٍ مُ سَ لَ ﭑ مَ مَسٍنيِ رَ، عٍ قَ عَ قَلَ، ‹عَلَتَلَ مُ مِنِشِ عِ مَ قٍوٌ،› ﭑ مُنسٍ رَبَمَ قَ؟» ");
INSERT INTO susa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","عَلَتَلَ نَشَ عَ مَشْرِن، «مُنسٍ نَ عِ بّلّشّ نَ كِ؟» عَ نَشَ عَ يَابِ، «ﭑ مَ يِسُشُوُرِ.» ");
INSERT INTO susa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","عَلَتَلَ نَشَ عَ يَمَرِ، «عَ وٌلِ بْشِ.» عَ تٌ عَ وٌلِ بْشِ، نَ نَشَ مَقِندِ بْشِمَسٍ رَ، مُنسَ قَ عَ فِ عَ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «عِ بّلّشّ عِتَلَ عِ شَ عَ سُشُ عَ شُلِ مَ.» مُنسَ نَشَ عَ بّلّشّ عِتَلَ. عَ تٌ عَ سُشُ عَ بّلّشّ رَ، نَ نَشَ قِندِ يِسُشُوُرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «نَ قِندِ مَ تْنشُمَ رَ عٍ بّ، قَ عَ قَلَ، عٍ بٍنبَ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ مَرِفِ عَلَتَلَ بَرَ مِنِ عِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","نَ دَنفِ شَنبِ، عَلَتَلَ مَن نَشَ عَ مَسٍن عَ بّ، «عِ بّلّشّ سَ عِ كَنكٍ مَ عِ شَ دٌنمَ بُن مَ.» عَ تٌ نَ رَبَ، عَ قَ عَ رَ مِنِ، كُنّ عَ بّلّشّ رَقِيشّشِ. ");
INSERT INTO susa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","عَ مَن نَشَ عَ يَمَرِ، «عِ مَن شَ عِ بّلّشّ سَ عِ كَنكٍ مَ عِ شَ دٌنمَ بُن مَ.» عَ تٌ نَ رَبَ، عَ بّلّشّ نَشَ يَلَن كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «شَ عِسِرَيِلَكَيٍ مُ لَ عِ شُي رَ، شَ نَ مُ عَ رَ نَ تْنشُمَ سِنفٍ رَ، تّمُندٍ عٍ قَمَ نّ لَدٍ عِ رَ نَ تْنشُمَ قِرِن ندٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","شَ عٍ مُ لَ عِ شُي رَ نَ تْنشُمَ قِرِنيِيٍ شَ قٍ رَ، عِ شَ يٍ تٌنفٌ نِلِ شُرٍ، عِ عَ رَقِلِ بْشِ مَ. عَ قِندِ مَ نّ وُلِ رَ كٍرٍن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","مُنسَ نَشَ عَلَتَلَ يَابِ، «ﭑ مَرِفِ، عِ عَ كٌلٌن عِ شَ كٌنيِ مُ قَتَ وْيّندٍ. ﭑ نّنيِ بِنيَ ﭑ دّ عِ كَبِ ﭑ دِ مّدِ تّمُي. تٌ مَسٍنيِ مُ نَ قٍ مَسَرَشِ.» ");
INSERT INTO susa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «ندٍ مِشِ نّنيِ رَكٍلِمَ؟ ندٍ مِشِ قِندِ مَ بٌبٌي رَ، شَ نَ مُ تُلِشْرِ؟ ندٍ مِشِ قِندِ مَ يَ كَنيِ رَ، شَ نَ مُ دْنشُي؟ ﭑ تَن عَلَتَلَ شَ مُ عَ رَ؟ ");
INSERT INTO susa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","سِفَ. ﭑ عِ مَلِمَ مَسٍنيِ تِدٍ. ﭑ مَسٍنيِ يَتِ رَ سٌمَ نّ عِ دّ عِ، عِ نَشَن تِمَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","مُنسَ نَشَ عَ يَابِ، «ﭑ مَرِفِ، يَندِ، مِشِ فبّتّ شّي.» ");
INSERT INTO susa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","نَ كُي عَلَتَلَ نَشَ شْنْ مُنسَ مَ. عَ نَشَ عَ مَسٍن عَ بّ، «عِ تَارَ هَرُنَ فٌ؟ لٍوِ بْنسْي مُ عَ رَ؟ ﭑ عَ كٌلٌن، نَ تَن قَتَ وْيّندٍ. عَ حَن نَ قَقٍ عِ رَلَندٍ. عَ سّيوَ مَ نّ عِ تٌقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","عِ مَسٍنيِيٍ تِمَ نّ عَ بّ، عَ نَشَن قَلَمَ حَمَ بّ. ﭑ وٌ قِرِن مَلِمَ نَ كُي. ﭑ عَ مَسٍنمَ وٌ بّ وٌ لَن وٌ شَ نَشَن قَلَ. ");
INSERT INTO susa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","هَرُنَ عِ شُي مَدَنفِمَ حَمَ بّ، عَلْ نَمِحْنمّ عَلَ شُي مَدَنفِمَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","عِ شَ عِ شَ يِسُشُوُرِ تٌنفٌ. عِ كَابَنَكٌ بِرِن نَبَمَ عَ تَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","نَ تّمُي مُنسَ نَشَ فبِلٍن عَ بِتَنيِ شْنيِ، عَ عَ قَلَ عَ بّ، «ﭑ وَ مَ سِفَقٍ نفَشَكٍرٍنيِيٍ يِرٍ مِسِرَ بْشِ مَ، ﭑ شَ عَ كٌلٌن عٍ شَ قٍ نَ كِ نَشّ.» يٍتِرٌ نَشَ عَ يَابِ، «سِفَ بْحّسَ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ مَدِيَن بْشِ مَ، «عِ شَ فبِلٍن مِسِرَ. نَشٍيٍ نُ وَ مَ عِ قَشَقٍ، نٍيٍ بِرِن بَرَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","نَ كُي مُنسَ نَشَ عَ شَ فِنّ نُن عَ شَ دِيٍ بَكِ سٌقَلٍيٍ قَرِ، عٍ فبِلٍن مِسِرَ. مُنسَ نَشَ عَ شَ يِسُشُوُرِ قَن شَنِن، عَلَ نَشَن مَ قٍ قَلَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ، «عِ نَ فبِلٍن مِسِرَ، عِ شَ كَابَنَكٌ بِرِن نَبَ قِرَوُنَ يَ عِ، ﭑ نَشٍيٍ سَشِ عِ سَفٌي. نَ تّمُي ﭑ تَن نَن عَ شَشِلِ رَشْرْشْمَ، عَلَكٌ عَ نَشَ تِن ﭑ مَ حَمَ بّحِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","عِ شَ عَ قَلَ قِرَوُنَ بّ، ‹عَلَتَلَ شُي نَن يَ، عِسِرَيِلَ، ﭑ مَ دِ سِنفٍ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ﭑ بَرَ عِ يَمَرِ عِ شَ عَ بّحِن عَلَكٌ عَ شَ سِفَ ﭑ بَتُدٍ. عِ تٌ بَرَ تٌندِ نَ رَ، ﭑ عِ شَ دِ سِنفٍ قَشَمَ نّ.›» ");
INSERT INTO susa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","مُنسَ تٌ نُ نَ بِيَاسِ كُي سِفَقٍ رَ مِسِرَ، عَلَتَلَ نَشَ مِنِ عَ مَ كْي رَ، عَ شَ عَ قَشَ، ");
INSERT INTO susa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","كْنْ مُنسَ شَ فِنّ سِثٌرَ نَشَ عَ شَ دِ شّمّ سُننَ فّمّ شّحّنشِ رَ، عَ نَ سٌلِ سَ عَ سَنيِ مَ. عَ نَشَ عَ قَلَ، «ﭑ مَ مْرِ نَن عِ رَ، مُشُ نُن نَشَن وُلِ كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","نَ كُي عَلَتَلَ نَشَ مُنسَ لُ نَ. سِثٌرَ شَ مَسٍنيِ، «ﭑ مَ مْرِ نَن عِ رَ، مُشُ نُن نَشَن وُلِ كٍرٍن،» عَ نُ وَ مَ سُننّ وُلِ نَن شَ قٍ قَلَقٍ. ");
INSERT INTO susa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","عَلَتَلَ نَشَ عَ مَسٍن هَرُنَ بّ، «عِ شَ سِفَ مُنسَ رَلَندٍ فبٍنفبٍرٍنيِ مَ.» عَ تٌ نَرَلَن مُنسَ رَ عَلَ شَ فٍيَ مَ، عَ نَشَ عَ سُنبُ. ");
INSERT INTO susa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","مُنسَ نَشَ عَلَتَلَ شَ شّيرَيَ بِرِن يَ بَ عَ بّ. عَ نَشَ نَ كَابَنَكٌ قٍيٍ قَن قَلَ عَ بّ، عَلَ نَشَن قِشِ عَ مَ عَ رَبَقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","مُنسَ نُن هَرُنَ تٌ عِسِرَيِلَكَيٍ لِ، عٍ نَشَ عِسِرَيِلَ قٌرِ بِرِن مَلَن. ");
INSERT INTO susa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","هَرُنَ نَشَ دّنتّفّ سَ عٍ بّ عَلَتَلَ نَشَن مَسٍنشِ مُنسَ بّ. عَ نَشَ كَابَنَكٌي قَن نَبَ حَمَ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","حَمَ نَشَ لَ نَ بِرِن نَ. عٍ تٌ عَ كٌلٌن عَ عَلَتَلَ حّنفِ سَشِ عِسِرَيِلَكَيٍ شْن مَ عٍ شَ تْورّ كُي، عٍ نَشَ عٍ عِفٌرٌ بْشِ، عٍ سُيِدِ عَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","نَ دَنفِ شَنبِ، مُنسَ نُن هَرُنَ نَشَ سِفَ قِرَوُنَ يِرٍ. عٍ نَشَ عَ قَلَ عَ بّ، «عِسِرَيِلَ مَرِفِ عَلَتَلَ شَ مَسٍنيِ نَن يَ، ‹ﭑ مَ حَمَ بّحِن، عَلَكٌ عٍ شَ سِفَ ﭑ مَ سَلِ رَبَدٍ فبٍنفبٍرٍنيِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","قِرَوُنَ نَشَ يِ مَشْرِنيِ تِ، «ندٍ تَن نَ نَ عَلَتَلَ رَ، ﭑ لَن ﭑ شَ نَشَن شَ يَامَرِ رَبَتُ عِسِرَيِلَ بّحِنقٍ رَ؟ ﭑ مُ عَلَتَلَ كٌلٌن! نَ كُي، ﭑ مُ نْمَ عَ لُدٍ عِسِرَيِلَ شَ سِفَ قٍقٍ مَ!» ");
INSERT INTO susa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","عٍ نَشَ عَ قَلَ عَ بّ، «عِسِرَيِلَ مَرِفِ عَلَ بَرَ قَ مُشُ قْشْ رَ. عَ لُ مُشُ شَ بِيَاسِ شِ سَشَن فبٍنفبٍرٍنيِ يِرٍ، عَلَكٌ مُشُ شَ سّرّشّيٍ بَ مُشُ مَرِفِ عَلَتَلَ بّ، شَ مُشُ مُ نَ رَبَ مُشُ سْنتْمَ نّ وُفَنيِ رَ، شَ نَ مُ سَنتِدّفّمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","مِسِرَ مَنفّ نَشَ عٍ يَابِ، «مُنسَ نُن هَرُنَ، مُنقٍ رَ وٌ وَ مَ حَمَ بَقٍ وَلِ دّ عِ؟ وٌ سِفَ وٌ شَ وَلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","يِ حَمَ تٌ بَرَ فبٌ يّ يِ بْشِ مَ، وٌ وَ مَ عٍ شَ وَلِ نَن شُن نَكَنَقٍ قَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","نَ لْشْي قِرَوُنَ نَشَ كٌنيِيٍ شَ مَنفّيٍ نُن وَلِ شُنيِيٍ يَمَرِ، ");
INSERT INTO susa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«وٌ نَشَ سّشّ سٌ عِسِرَيِلَ حَمَ يِ رَ سْنْن، عٍ نَشَن مَلَنمَ بٌورَ رَ عٍ بِرِكِ بْنبْمَ تّمُي نَشّ. يَكْسِ عٍ شَ نَ سّشّ قٍن عٍ يّتّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","عٍ دَرِ بِرِكِ شَسَبِ نَشَن بْنبْ رَ، وٌ نَشَ سٍسٍ بَ نَ رَ. قُيَنتٍ نَن عٍ رَ. نَ نَن عَ رَ، عٍ عَ قَلَمَ، ‹مُشُ شَ سِفَ سّرّشّ بَدٍ مُشُ مَرِفِ عَلَ بّ.› ");
INSERT INTO susa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","وٌ شَ ندٍ سَ عٍ شَ وَلِ شُن مَ، عَلَكٌ عٍ نَشَ يَنقَ وَلِ مَ مَدَشُي وْيّنيِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","كٌنيِ شَ مَنفّيٍ نُن وَلِ شُنيِيٍ نَشَ عَ قَلَ عِسِرَيِلَ حَمَ بّ، «قِرَوُنَ نَشّ عَ عَ مُ سّشّ سٌمَ وٌ يِ رَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","وٌ شَ سِفَ نَ قٍندٍ وٌ يّتّ رَ. وٌ شَ عَ كٌلٌن سٍسٍ مُ بَمَ وٌ شَ وَلِ كٌتٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","نَ كُي حَمَ نَشَ يٍنسٍن مِسِرَ بْشِ سّشّ شَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","مَنفّيٍ نُ عٍ رَفبَتَمَ نّ، عٍ نُ قَ عَ قَلَ، «وٌ شَ وٌ شَ وَلِ رَحْن لْشْ يٌ لْشْ عَلْ عَ سِنفٍ، سّشّ نُ سٌمَ وٌ يِ رَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","قِرَوُنَ شَ مِشِيٍ نُ قَ عِسِرَيِلَكَيٍ بْنبْ نَشٍيٍ نُ تِشِ وَلِ شُنيِيٍ رَ. عٍ نُ قَ عٍ مَشْرِن، «مُنقٍ رَ شٌرٌ نُن تٌ، وٌ مُ بِرِكِ شَسَبِ بْنبْشِ عَلْ وٌ دَرِشِ عَ رَ كِ نَشّ؟» ");
INSERT INTO susa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","عِسِرَيِلَ وَلِ شُنيِيٍ نَشَ سِفَ عٍ مَوَدٍ قِرَوُنَ شْن عَ قَلَقٍ رَ، «عِ نَ يِ مْولِ رَبَقٍ مُشُ تَن عِ شَ كٌنيِيٍ رَ مُنقٍ رَ؟ ");
INSERT INTO susa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","عٍ مُ سّشّ يٌ سٌمَ مُشُ يِ رَ، كْنْ عٍ عَ قَلَمَ عَ مُشُ شَ بِرِكِ بْنبْ! عِ شَ مِشِيٍ نَ مُشُ تَن عِ شَ كٌنيِ بْنبْقٍ، كْنْ عٍ تَن نَن وَلِ كَنَشِ.» ");
INSERT INTO susa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","قِرَوُنَ نَشَ عٍ يَابِ، «قُيَنتٍيٍ نَن وٌ رَ. نَ نَن عَ تٌشِ وٌ عَ قَلَمَ، عَ وٌ شَ سِفَ سّرّشّ بَدٍ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","وٌ سِفَ وَلِدٍ! سّشّ يٌ مُ سٌمَ وٌ يِ رَ، سٍسٍ مَن مُ بَمَ وٌ شَ بِرِكِ كْنتِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","عِسِرَيِلَ وَلِ شُنيِيٍ نَشَ كْنتْقِلِ نَ وْيّنيِ رَ، عَ قَلَقٍ رَ، «سٍسٍ مُ بَمَ بِرِكِيٍ كْنتِ رَ وٌ نَشَن بْنبْمَ لْشْ يٌ لْشْ.» ");
INSERT INTO susa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","عٍ تٌ مِنِ قِرَوُنَ شْنيِ، عٍ نَشَ مُنسَ نُن هَرُنَ لِ نَا. عٍ نُ نَ عٍ مّمّقٍ. ");
INSERT INTO susa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","نَ وَلِ شُنيِيٍ نَشَ عَ قَلَ عٍ بّ، «عَلَتَلَ شَ وٌ حَشَنكَتَ، بَرِ مَ وٌ بَرَ مُشُ مَحَاشُ قِرَوُنَ نُن عَ شَ مِشِيٍ شْن مَ. وٌ بَرَ سَنتِدّفّمَ سَ عٍ بّلّشّ، عٍ شَ مُشُ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","مُنسَ نَشَ فبِلٍن عَلَتَلَ مَ عَ قَلَقٍ رَ، «مَرِفِ، عِ بَرَ يِ تْورّ دْشْ يِ حَمَ مَ مُنقٍ رَ؟ عِ ﭑ شّيشِ بٍ مُنقٍ مَ؟ ");
INSERT INTO susa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","كَبِ ﭑ نَشَ سِفَ قِرَوُنَ يِرٍ وْيّنقٍ رَ عِ شِلِ رَ، عَ قَ قٍ حَاشِ نَن تُن نَبَقٍ يِ حَمَ رَ. عِ مُ عِ شَ حَمَ شْرّيَشِ قٍوٌ.» ");
INSERT INTO susa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ قَمَ عَ تٌدٍ يَكْسِ، ﭑ نَشَن نَبَمَ قِرَوُنَ رَ. ﭑ سّنبّ نَن قَمَ عَ نِيَدٍ عَ شَ عِسِرَيِلَ حَمَ بّحِن، عَ يّتّ شَ عٍ كٍرِ عَ شَ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","عَلَ مَن نَشَ عَ مَسٍن مُنسَ بّ، «ﭑ تَن نَن عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ﭑ نَشَ ﭑ يّتّ مَسٍن عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ بّ. كْنْ عٍ مُ ﭑ ﭑ شِلِ كٌلٌنشِ عَلَتَلَ رَ. عٍ ﭑ كٌلٌنشِ عَلَ سّنبّمَ شِلِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","مُشُ مَن نَشَ سَاتَ، ﭑ شَ كَنَان بْشِ قِ عٍ مَ، عٍ شْحّيَ رَبَشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ﭑ بَرَ عِسِرَيِلَكَيٍ وَ شُي مّ عٍ شَ كٌنيِيَ كُي مِسِرَكَيٍ يِ رَ. ﭑ مَن بَرَ رَتُ ﭑ مَ سَاتّ مَ. ");
INSERT INTO susa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","نَ كُي، عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹ﭑ تَن نَن عَلَتَلَ رَ. ﭑ قَمَ نّ وٌ رَ مِنِدٍ مِسِرَكَيٍ شَ نْي بُن مَ. ﭑ شْرّيَ قِمَ نّ وٌ مَ. ﭑ قَمَ نّ وٌ شُن سَرَدٍ ﭑ سّنبّ رَ. ﭑ حَشَنكَتّ رَفٌرٌ مَ نّ مِسِرَكَيٍ مَ عٍ شَ وَلِ كٌبِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ﭑ وٌ قِندِ مَ نّ ﭑ مَ حَمَ رَ. ﭑ قَن قِندِ مَ نّ وٌ مَرِفِ رَ. نَ تّمُي وٌ عَ كٌلٌنمَ نّ، ﭑ تَن نَن نَ وٌ مَرِفِ عَلَتَلَ رَ، نَشَن وٌ بَشِ كٌنيِيَ كُي مِسِرَكَيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ﭑ قَمَ نّ وٌ رَ سٌدٍ بْشِ مَ، ﭑ نَكَلِشِ نَشَن مَ قٍ رَ، ﭑ شَ عَ قِ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ مَ. ﭑ قَمَ نّ عَ قِدٍ وٌ مَ، عَ لُ وٌ سَفٌي.›» ");
INSERT INTO susa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","مُنسَ نَشَ نَ دّنتّفّ عِسِرَيِلَكَيٍ بّ، كْنْ عٍ مُ لَ عَ شُي رَ عٍ شَ كٌنيِيَ شْرْشْي شَ قٍ رَ. لِمَنِيَ بِرِن نُ بَرَ بَ عٍ يِ. ");
INSERT INTO susa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«سِفَ مِسِرَ مَنفّ يِرٍ. عَ قَلَ قِرَوُنَ بّ عَ شَ عِسِرَيِلَ حَمَ بّحِن، عٍ شَ مِنِ عَ شَ بْشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","كْنْ مُنسَ نَشَ عَلَتَلَ يَابِ، «شَ عِسِرَيِلَكَيٍ يَتِ مُ لَشِ ﭑ شُي رَ، قِرَوُنَ قَن مُ ﭑ شُي سُشُمَ قٍوٌ، ﭑ تَن نَشَن حَن مُ قَتَ وْيّندٍ.» ");
INSERT INTO susa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","عَلَتَلَ مَسٍنيِ تِ مُنسَ نُن هَرُنَ بّ نَ كِ نّ، عِسِرَيِلَكَيٍ نُن مِسِرَ مَنفّ قِرَوُنَ شَ قٍ رَ. عَ عٍ يَمَرِ نّ عٍ شَ عِسِرَيِلَكَيٍ رَ مِنِ مِسِرَ بْشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","عِسِرَيِلَ بْنسْي يَرٍرَتِيٍ نَن يِ كِ؛ رُبٍن نَشَن سِنفٍ بَرِ عِسِرَيِلَ، عَ شَ دِيٍ نَن يَ؛ شَنْكِ، ثَلُ، شٍسِرٌن، نُن كَرِ مِ. رُبٍن بْنسْي نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","سِمٍيْن شَ دِيٍ نَن يَ؛ يٍمُوٍلِ، يَمِن، عٌهَدِ، يَكِن، سٌشَرَ، نُن فِنّ كَنَانكَ شَ دِ سَوُلُ. سِمٍيْن بْنسْي نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","لٍوِ شَ دِيٍ شِلِيٍ نَن يِ كِ عٍ شَ تَرُشُي كِ مَ؛ فٍرِ سٌن، كٍهَتِ، نُن مٍرَرِ. لٍوِ شَ سِمَيَ نَشَ حّ كّمّ حّ تٌنفٌ سَشَن عَ نُن سٌلٌقٍرٍ لِ. ");
INSERT INTO susa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","فٍرِ سٌن شَ دِيٍ قِندِشِ لِبِنِ نُن سِمٍيِ نَن نَ عٍ شَبِلّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","كٍهَتِ شَ دِيٍ قِندِشِ عَمَرَ مَ، يِسٍهَرِ، شٍبِرٌن، نُن يُسِيّلِ نَن نَ عٍ شَبِلّ كِ مَ. كٍهَتِ شَ سِمَيَ نَشَ حّ كّمّ حّ تٌنفٌ سَشَن عَ نُن سَشَن لِ. ");
INSERT INTO susa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","مٍرَرِ شَ دِيٍ قِندِشِ مَشَلِ نُن مُسِ نَن نَ. لٍوِ شَ دِيٍ نَن نَ كِ عٍ تَرُشُي كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","عَمَرَ مَ نَشَ عَ بَبَ بَرٍنيِ يٍبٍدِ دْشْ، نَشَن هَرُنَ نُن مُنسَ بَرِ عَ بّ. عَمَرَ مَ شَ سِمَيَ نَشَ حّ كّمّ حّ تٌنفٌ سَشَن عَ نُن سٌلٌقٍرٍ لِ. ");
INSERT INTO susa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","يِسٍهَرِ شَ دِيٍ نَن يَ؛ كٌرَ، نٍقٍفِ، نُن سِكِرِ. ");
INSERT INTO susa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","يُسِيّلِ شَ دِيٍ نَن يَ؛ مِسَيٍلِ، عٍلٍسَقَنَ، نُن سِتِرِ. ");
INSERT INTO susa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","هَرُنَ نَشَ عَمِنَدَبٌ شَ دِ عٍلِسٍيبَ دْشْ، نَشَن قِندِشِ نَشَسٌن مَافِنّ رَ. عَ نَشَ نَدَبٌ، عَبِهُ، عٍلٍيَسَرِ، نُن عِتَمَرِ بَرِ هَرُنَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","كٌرَ شَ دِيٍ نَن يَ؛ عَسِرِ، عٍلٍكَنَ، نُن عَبِيَسَقِ عَ شَبِلّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","هَرُنَ شَ دِ عٍلٍيَسَرِ نَشَ ثُتِيٍلِ شَ دِ فِنّ دْشْ. عَ نَشَ قِنٍشَسِ بَرِ عَ بّ. لٍوِ بْنسْي يَرٍرَتِيٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","عَلَتَلَ هَرُنَ نُن مُنسَ يَمَرِ نّ، «وٌ عِسِرَيِلَكَيٍ رَ مِنِ مِسِرَ بْشِ رَ عٍ لَنشُندّ كِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","مُنسَ نُن هَرُنَ نَن وْيّن مِسِرَ مَنفّ قِرَوُنَ بّ عِسِرَيِلَكَيٍ رَ مِنِقٍ رَ مِسِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ مِسِرَ بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«ﭑ تَن نَن نَ عَلَتَلَ رَ. سِفَ، ﭑ شُي بِرِن نَدَنفِ مِسِرَ مَنفّ قِرَوُنَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","مُنسَ نَشَ عَلَتَلَ يَابِ، «ﭑ تَن نَن يِ كِ، ﭑ مُ قَتَ وْيّندٍ عَ قَنيِ رَ. قِرَوُنَ نْمَ تِندٍ ﭑ مَ مَسٍنيِ رَ دِ؟» ");
INSERT INTO susa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «هَرُنَ شَ عِ شُي مَدَنفِ قِرَوُنَ بّ عَلْ نَمِحْنمّ عَلَ شُي مَدَنفِمَ مِشِيٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ﭑ عِ يَمَرِ مَ نَشَن بِرِن نَ، عِ شَ نَ قَلَ عِ تَارَ هَرُنَ بّ نَشَن نَ مَدَنفِمَ قِرَوُنَ مَ، عَلَكٌ عَ شَ عَ لُ عِسِرَيِلَكَيٍ شَ مِنِ مِسِرَ بْشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ﭑ قِرَوُنَ شَشِلِ رَشْرْشْمَ نّ. ﭑ تْنشُمَ نُن كَابَنَكٌ فبٍفبٍ رَبَمَ نّ مِسِرَ بْشِ كُي، ");
INSERT INTO susa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","كْنْ قِرَوُنَ مُ قَمَ عَ تُلِ مَتِدٍ وٌ رَ. ﭑ قَمَ نّ حَشَنكَتّ شْرْشْييٍ دْشْدٍ مِسِرَ مَ، ﭑ قَ ﭑ مَ حَمَ عِسِرَيِلَ رَ مِنِ عَ لَنشُندّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ﭑ نَ مِسِرَ هَلَكِ عِسِرَيِلَ رَ مِنِقٍ رَ عٍ تَفِ، عٍ ﭑ كٌلٌنمَ نّ عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","مُنسَ نُن هَرُنَ نَشَ عَلَتَلَ شَ يَامَرِ سُشُ عَلْ عَ مَسٍنشِ عٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","عٍ نُ مَسٍنيِ تِمَ قِرَوُنَ بّ تّمُي نَشّ، مُنسَ شَ سِمَيَ نُ بَرَ حّ تٌنفٌ سٌلٌمَسَشَن لِ. هَرُنَ شَ سِمَيَ نُ بَرَ حّ تٌنفٌ سٌلٌمَسَشَن عَ نُن سَشَن لِ. ");
INSERT INTO susa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«قِرَوُنَ نَ عَ قَلَ وٌ بّ، ‹وٌ شَ كَابَنَكٌ ندٍ رَبَ،› عِ تَن مُنسَ، عِ شَ عَ قَلَ هَرُنَ بّ، عَ شَ عِ شَ يِسُشُوُرِ تٌنفٌ، عَ عَ وٌلِ قِرَوُنَ سّيتِ مَ. نَ مَقِندِ مَ نّ بْشِمَسٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","نَ كُي مُنسَ نُن هَرُنَ نَشَ سِفَ قِرَوُنَ يِرٍ، عٍ قَ عَ رَبَ، عَلْ عَلَتَلَ عٍ يَمَرِشِ كِ نَشّ. هَرُنَ نَشَ مُنسَ شَ يِسُشُوُرِ وٌلِ بْشِ مَ قِرَوُنَ نُن عَ شَ كُنتِفِيٍ يَ عِ، نَ نَشَ قِندِ بْشِمَسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","نَ تّمُي قِرَوُنَ نَشَ عَ شَ كَرَ مْشْييٍ نُن عَ شَ مَندُرُلَيٍ شِلِ، عٍ شَ نَ كَابَنَكٌ مْولِ رَبَ عٍ شَ دُورٍيَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","عٍ نُن هَرُنَ بِرِن نَشَ عٍ شَ يِسُشُوُرِيٍ وٌلِ بْشِ مَ. نٍيٍ بِرِن نَشَ مَقِندِ بْشِمَسٍيٍ رَ، كْنْ هَرُنَ فبٍ نَشَ بٌورٍ فبٍ فٍرُن. ");
INSERT INTO susa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","نَ كُي قِرَوُنَ شَشِلِ نَشَ شْرْشْ، عَ مُ عَ تُلِ مَتِ مُنسَ نُن هَرُنَ رَ، عَلْ عَلَتَلَ نُ بَرَ عَ مَسٍن كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «قِرَوُنَ شَشِلِ بَرَ شْرْشْ. عَ بَرَ تٌندِ ﭑ مَ حَمَ بّحِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","تِنَ فّيسّفّ عِ شَ نَرَلَن قِرَوُنَ رَ نِلِ شُرٍ دّ. عِ شَ عِ شَ يِسُشُوُرِ شَنِن، نَشَن نُ بَرَ مَقِندِ بْشِمَسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","مّننِ عِ شَ عَ قَلَ قِرَوُنَ بّ، ‹عِسِرَيِلَكَيٍ مَرِفِ عَلَتَلَ بَرَ ﭑ شّي عِ يِرٍ، ﭑ شَ عَ قَلَ عِ بّ، «ﭑ مَ حَمَ بّحِن، عَلَكٌ عٍ شَ سِفَ ﭑ بَتُدٍ فبٍنفبٍرٍنيِ مَ.» هَن يَكْسِ عِ تَن مُ تِنشِ نَ شُي سُشُدٍ. ");
INSERT INTO susa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","نَ كُي عَلَتَلَ شَ مَسٍنيِ نَن يَ، «نَ نَن عَ رَ، عِ قَمَ عَ كٌلٌندٍ، ﭑ تَن نَن عَلَتَلَ رَ. ﭑ مَ يِسُشُوُرِ نَ دِن نِلِ شُرٍ رَ، يٍ مَقِندِ مَ نّ وُلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","يّشّ نَشٍيٍ نَ نِلِ شُرٍ مَ، عٍ قَمَ سْنتْدٍ، عٍ شِرِ حَاشِ قَ مِنِ، مِسِرَكَيٍ مُ نْمَ نَ يٍ مِندٍ.»›» ");
INSERT INTO susa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «هَرُنَ يَمَرِ، ‹عِ شَ عِ شَ يِسُشُوُرِ عِتَلَ مِسِرَ بَايٍ، شُرٍيٍ، نُن دَبٌنيِ بِرِن مَ.› نَ عَ نِيَمَ نّ يٍ بِرِن شَ مَقِندِ وُلِ رَ مِسِرَ بْشِ مَ، هَلِ نَشٍيٍ نَ قّحّيٍ كُي، وُرِ نُن فّمّ دَاشِ.» ");
INSERT INTO susa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","مُنسَ نُن هَرُنَ نَشَ عَ رَبَ عَلْ عَلَتَلَ عٍ يَمَرِشِ كِ نَشّ. هَرُنَ نَشَ عَ شَ يِسُشُوُرِ عِتَلَ، عَ عَ دِن نِلِ شُرٍ رَ. شُرٍ نَشَ قِندِ وُلِ رَ قِرَوُنَ نُن عَ شَ كُنتِفِيٍ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","يّشّ بِرِن نَشَ قَشَ، عٍ شِرِ حَاشِ نَشَ مِنِ نِلِ شُرٍ مَ. مِسِرَكَيٍ مُ نُ نْمَ نَ يٍ مِندٍ، بَرِ مَ مِسِرَ يٍ بِرِن قِندِشِ وُلِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","مَندُرُلَيٍ قَن نَشَ نَ كَابَنَكٌ مْولِ رَبَ. قِرَوُنَ شَشِلِ نَشَ شْرْشْ، عَ مُ تِن مُنسَ نُن هَرُنَ شُي رَ، عَلْ عَلَتَلَ نُ بَرَ عَ مَسٍن كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","قِرَوُنَ نَشَ فبِلٍن عَ شْنيِ، عَ نَشَ نَ قٍ بْتّ بَ. ");
INSERT INTO susa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","مِسِرَكَ بِرِن نَشَ تِفِيٍ فٍ نِلِ شُرٍ سّيتِيٍ مَ، عَلَكٌ عٍ شَ يٍ مِن دَاشِ سْتْ، بَرِ مَ عٍ مُ نُ نْمَ نِلِ شُرٍ يٍ مِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","عَلَتَلَ تٌ فّ نِلِ شُرٍ فَرِندٍ، شِ سٌلٌقٍرٍ دَنفِ شَنبِ، ");
INSERT INTO susa_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","عَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ سِفَ قِرَوُنَ يِرٍ، عَ قَلَ عَ بّ، ‹عَلَتَلَ بَرَ عَ يَمَرِ، عِ شَ عَ شَ حَمَ بّحِن، عٍ شَ سِفَ عَ بَتُدٍ. ");
INSERT INTO susa_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","شَ عِ مُ تِن نَ رَ، عَلَتَلَ قَمَ عِ شَ بْشِ بِرِن شُن نَكَنَدٍ لَنشَنسَرِ مَيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","عٍ قَمَ يِرِوَدٍ نِلِ شُرٍ مَ، عٍ قَ تٍ، عٍ سٌ عِ شَ بَنشِ كُي هَن عٍ عِ شَ سَدٍ لِ. عٍ سٌمَ عِ شَ كُنتِفِيٍ نُن مِسِرَ حَمَ شَ بَنشِيٍ كُي، عٍ مَن سٌمَ تَامِ رَقَلَمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","لَنشَنسَرِ مَيٍ قَمَ نّ تٍدٍ عِ تَن، عِ شَ حَمَ، نُن عِ شَ كُنتِفِيٍ بِرِن مَ.›» ");
INSERT INTO susa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عَ قَلَ هَرُنَ بّ، عَ شَ عَ شَ يِسُشُوُرِ عِتَلَ بَايٍ، شُرٍيٍ، نُن دَبٌنيِ بِرِن شُن مَ عَلَكٌ لَنشَنسَرِ مَيٍ شَ تٍ نِلِ شُرٍ مَ، عٍ سٌ مِسِرَ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","هَرُنَ تٌ عَ شَ يِسُشُوُرِ عِتَلَ مِسِرَ يٍيٍ شُن مَ، لَنشَنسَرِ مَيٍ نَشَ تٍ مِسِرَ بْشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","مَندُرُلَيٍ قَن نَشَ نَ كَابَنَكٌ مْولِ رَبَ، عٍ قَن نَشَ لَنشَنسَرِ مَيٍ رَ سٌ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","نَ دَنفِ شَنبِ قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ، عَ عَ قَلَ عٍ بّ، «وٌ سَ عَلَتَلَ مَشَندِ، عَلَكٌ لَنشَنسَرِ مَيٍ شَ كٍلِ ﭑ تَن نُن ﭑ مَ حَمَ شُن مَ. ﭑ قَمَ عِ شَ حَمَ رَبّحِندٍ، عٍ شَ سِفَ سّرّشّيٍ بَدٍ عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","مُنسَ نَشَ عَ قَلَ قِرَوُنَ بّ، «مَنفّ، عِ فبٍ بِنيّ. عِ شَ نَتّ تٌنفٌ لْشْي سَقٍ رَ لَنشَنسَرِ مَيٍ شَ كٍلِ عِ تَن، عِ شَ كُنتِفِيٍ، نُن عِ شَ حَمَ شُن مَ، عٍ شَ لُ نِلِ شُرٍ فبَنسَن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","عَ نَشَ عَ يَابِ، «تِنَ.» مُنسَ نَشَ عَ قَلَ، «عَ قَمَ رَبَدٍ نَ كِ نّ، عَلَكٌ عِ شَ عَ كٌلٌن، مُشُ مَرِفِ عَلَتَلَ مَنِيّ مُ نَ. ");
INSERT INTO susa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","لَنشَنسَرِ مَيٍ قَمَ كٍلِدٍ عِ تَن، عِ شَ كُنتِفِيٍ، نُن عِ شَ حَمَ شُن مَ، عٍ قَ لُ نِلِ شُرٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","مُنسَ نُن هَرُنَ تٌ مِنِ قِرَوُنَ شْنيِ، مُنسَ نَشَ عَلَتَلَ مَشَندِ لَنشَنسَرِ مَيٍ شَ قٍ رَ نَشٍيٍ نُ قِرَوُنَ تْورْ مَ. ");
INSERT INTO susa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","عَلَتَلَ نَشَ مُنسَ شَ مَشَندِ سُشُ. لَنشَنسَرِ مَيٍ نَشَ قَشَ بَنشِيٍ، شَندّيٍ، نُن دَاشَيٍ كُي. ");
INSERT INTO susa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","مِشِيٍ نَشَ عٍ كٌتٌ، عٍ شِرِ حَاشِ قَ دِن بْشِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","كْنْ قِرَوُنَ تٌ عَ تٌ نَ قٍ نُ بَرَ دَنفِ، عَ مَن نَشَ عَ شَشِلِ رَشْرْشْ، عَ مُ تِن مُنسَ نُن هَرُنَ شُي رَ، عَلْ عَلَتَلَ عَ مَسٍن كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عَ قَلَ هَرُنَ بّ عَ شَ عَ شَ يِسُشُوُرِ عِتَلَ، عَ شَ دِن بْشِ شُبٍ رَ عَلَكٌ عَ شَ مَقِندِ سَاسِيٍ رَ مِسِرَ بْشِ بِرِن كُي.» ");
INSERT INTO susa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","عٍ نَشَ عَ رَبَ نَ كِ. هَرُنَ تٌ عَ شَ يِسُشُوُرِ عِتَلَ، عَ قَ بْشِ شُبٍ فَرِن، نَ بِرِن نَشَ قِندِ سَاسِيٍ رَ، مِشِيٍ نُن شُرُ سٍيٍ قْشْ رَ. شُبٍ بِرِن نَشَ قِندِ سَاسِيٍ رَ مِسِرَ بْشِ بِرِن كُي. ");
INSERT INTO susa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","مَندُرُلَيٍ تٌ كَتَ نَ كَابَنَكٌ مْولِ رَبَدٍ، عٍ مُ نْ. سَاسِيٍ نُ دِنشِ مِشِ نُن شُرُ سٍ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","مَندُرُلَيٍ نَشَ عَ قَلَ قِرَوُنَ بّ، «عَلَ قْشِ يَتِ نَن نَ كِ،» كْنْ قِرَوُنَ شَشِلِ مَن نَشَ شْرْشْ، عَ مُ تِن مُنسَ نُن هَرُنَ شُي رَ، عَلْ عَلَتَلَ عَ مَسٍنشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «تِنَ فّيسّفّ عِ شَ كُرُن، عِ شَ نَرَلَن قِرَوُنَ رَ يٍ يِرٍ. عِ شَ عَ قَلَ عَ بّ عَلَتَلَ شَ مَسٍنيِ نَن يَ، ‹ﭑ مَ حَمَ بّحِن، عَلَكٌ عٍ شَ سِفَ ﭑ بَتُدٍ. ");
INSERT INTO susa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","شَ عِ مُ سَ تِن ﭑ مَ حَمَ بّحِندٍ، ﭑ قَمَ شّيرِيٍ نَن نَدِندٍ عِ تَن، عِ شَ كُنتِفِيٍ، نُن عِ شَ حَمَ مَ وٌ شْنيِ. شّيرِيٍ قَمَ لُدٍ مِسِرَكَيٍ شَ بَنشِيٍ نُن عٍ شَ بْشِيٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","كْنْ نَ لْشْي، فٌسٍن بْشِ رَتَنفَمَ نّ، ﭑ مَ حَمَ نَ دّننَشّ. شّيرِيٍ مُ لُمَ نَا، عَلَكٌ عِ شَ عَ كٌلٌن عَ ﭑ تَن عَلَتَلَ نَ يِ بْشِ يِرٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ﭑ تَفِ رَ سَ لُمَ نّ ﭑ مَ حَمَ نُن عِ فبٍ مَ. وٌ نَ كَابَنَكٌ تٌمَ نّ تِنَ.›» ");
INSERT INTO susa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","عَلَتَلَ عَ رَبَ نَ كِ نّ. شّيرِيٍ نَشَ دِن قِرَوُنَ، نُن عَ شَ كُنتِفِيٍ رَ. مِسِرَ بْشِ بِرِن شُن نَشَ رَكَنَ شّيرِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ، عَ عَ قَلَ عٍ بّ، «وٌ شَ سِفَ سّرّشّ بَدٍ وٌ مَرِفِ عَلَ بّ مِسِرَ.» ");
INSERT INTO susa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","مُنسَ نَشَ عَ يَابِ، «نَ مُ لَنمَ، بَرِ مَ مُشُ شَ سّرّشّيٍ مُ رَقَن مِسِرَكَيٍ مَ. شَ مُشُ نَ سّرّشّ مْولِ بَ مِسِرَكَيٍ يَ شْرِ عٍ نَشٍيٍ شْنشِ، عٍ مُ مُشُ مَفْنْمَ شّ؟ ");
INSERT INTO susa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","عَ لَنمَ مُشُ شَ شِ سَشَن بِيَاسِ رَبَ فبٍنفبٍرٍنيِ مَ، مُشُ قَ سّرّشّيٍ بَ مُشُ مَرِفِ عَلَتَلَ بّ، عَلْ عَ مُشُ يَمَرِشِ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","قِرَوُنَ نَشَ عَ قَلَ مُنسَ بّ، «ﭑ قَمَ وٌ بّحِندٍ، عَلَكٌ وٌ شَ سِفَ فبٍنفبٍرٍنيِ مَ سّرّشّيٍ بَدٍ وٌ مَرِفِ عَلَتَلَ بّ. كْنْ وٌ نَشَ وٌ مَكُيَ عَ فبٍ رَ. يَكْسِ، وٌ عَلَ مَشَندِ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","مُنسَ نَشَ عَ يَابِ، «ﭑ بَرَ تِن. ﭑ نَ مِنِ عِ شْنيِ، ﭑ عَلَتَلَ مَشَندِ مَ نّ. تِنَ، شّيرِيٍ مَكُيَمَ نّ قِرَوُنَ، عَ شَ كُنتِفِيٍ، نُن عَ شَ حَمَ رَ. كْنْ عِ تَن قِرَوُنَ، عِ نَشَ مُشُ مَدَشُ. عِ نَشَ تٌندِ عِسِرَيِلَ حَمَ بّحِندٍ عَلَكٌ عٍ شَ سّرّشّيٍ بَ عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","مُنسَ تٌ مِنِ قِرَوُنَ شْنيِ، عَ نَشَ عَلَتَلَ مَشَندِ. ");
INSERT INTO susa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","عَلَتَلَ نَشَ مُنسَ شَ دُبَ سُشُ. شّيرِيٍ نَشَ مَكُيَ قِرَوُنَ، عَ شَ كُنتِفِيٍ، نُن عَ شَ حَمَ رَ. هَلِ كٍرٍن مُ لُ نَا. ");
INSERT INTO susa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","كْنْ قِرَوُنَ مَن نَشَ عَ شَشِلِ شْرْشْ، عَ مُ تِن عِسِرَيِلَ حَمَ بّحِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ سِفَ قِرَوُنَ يِرٍ، عِ شَ عَ قَلَ عَ بّ، ‹عِسِرَيِلَكَ مَرِفِ عَلَتَلَ شَ مَسٍنيِ نَن يَ، «عِ شَ ﭑ مَ حَمَ بّحِن، عَلَكٌ عٍ شَ سِفَ ﭑ بَتُدٍ.» ");
INSERT INTO susa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","شَ عِ تٌندِ عٍ بّحِندٍ، عِ كَنكَن عٍ مَ، ");
INSERT INTO susa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","عَلَتَلَ قَمَ وُفَنيِ حَاشِ رَدِندٍ عِ شَ شُرُ سٍيٍ مَ، عَلْ سٌي، سٌقَلٍيٍ، حْشْمّيٍ، نِنفٍيٍ، يّشّييٍ، نُن سِ. ");
INSERT INTO susa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","عَلَتَلَ قَمَ عِسِرَيِلَكَيٍ شَ فْورّ نُن مِسِرَكَيٍ شَ فْورّ تَفِ رَ سَدٍ. عِسِرَيِلَكَيٍ شَ شُرُ سٍيٍ مُ وُفَنيِ سْتْمَ. ");
INSERT INTO susa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","عَلَتَلَ بَرَ نَتّ تٌنفٌ نَ رَبَمَ تّمُي نَشّ، عَ قَلَقٍ رَ، «تِنَ، ﭑ قَمَ نَ نَن نَبَدٍ.»›» ");
INSERT INTO susa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","نَ كُيٍ عِبَ، عَلَتَلَ عَ رَبَ نَ كِ نّ. مِسِرَ فْورّ بِرِن نَشَ قَشَ، كْنْ هَلِ شُرُ سٍ كٍرٍن مُ قَشَ عِسِرَيِلَكَيٍ شَ فْورّ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","قِرَوُنَ نَشَ مِشِيٍ شّي نَ قٍ كٌلٌندٍ. عٍ نَشَ عَ قَلَ قِرَوُنَ بّ شُرُ سٍ كٍرٍن مُ قَشَشِ عِسِرَيِلَكَيٍ شَ فْورّ كُي، كْنْ عَ شَشِلِ نَشَ شْرْشْ، عَ مَن مُ تِن عِسِرَيِلَ حَمَ بّحِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، «وٌ شَ تّ شُبٍ رَتٍ قِرَوُنَ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","عَ قِندِ مَ شُبٍ رَ نَشَن دِنمَ مِسِرَ بْشِ بِرِن نَ، عَ سُورِ رَ مِنِ مِسِرَكَيٍ نُن عٍ شَ شُرُ سٍيٍ بِرِن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","عٍ نَشَ تّ شُبٍ شَنِن قِرَوُنَ يِرٍ. مُنسَ نَشَ عَ وٌلِ كٌورٍ مَ، عَ قَ سُورِ حَاشِيٍ رَ مِنِ مِشِيٍ نُن شُرُ سٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","مَندُرُلَيٍ يَتِ مُ نْ تِدٍ مُنسَ يَ عِ سُورِيٍ شَ قٍ رَ، نَشٍيٍ نُ نَ مِسِرَكَيٍ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","كْنْ عَلَتَلَ نَشَ قِرَوُنَ شَشِلِ رَشْرْشْ، عَلَكٌ عَ نَشَ تِن مُنسَ نُن هَرُنَ شُي سُشُدٍ، عَلْ عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «تِنَ عِ شَ كُرُن سِفَقٍ رَ قِرَوُنَ يِرٍ، عَ قَلَ عَ بّ، ‹عِسِرَيِلَ مَرِفِ عَلَتَلَ شَ مَسٍنيِ نَن يَ، «ﭑ مَ حَمَ بّحِن، عٍ شَ سِفَ ﭑ بَتُدٍ، ");
INSERT INTO susa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","شَ نَ مُ عَ رَ ﭑ فبَلٌي مْولِ بِرِن نَمِنِمَ عِ تَن، عِ شَ كُنتِفِيٍ، نُن عِ شَ حَمَ مَ ﭑ سّنبّ رَ. نَ كُي عِ قَمَ عَ كٌلٌندٍ ﭑ مَنِيّ مُ نَ دُنِحَ بّندّ قُحِ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ﭑ نُ نْمَ فبَلٌي حَاشِ رَ مِنِدٍ وٌ مَ ﭑ سّنبّ رَ، نَشَن نُ نْمَ وٌ سْنتْدٍ، وٌ لْي دُنِحَ مَ، ");
INSERT INTO susa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","كْنْ ﭑ بَرَ وٌ لُ دُنِحَ عَلَكٌ ﭑ شَ ﭑ سّنبّ مَسٍن وٌ بّ، دُنِحَ شَ ﭑ شِلِ كٌلٌن. ");
INSERT INTO susa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","هَن يَ عِ كِرَ بٌلٌنمَ ﭑ مَ حَمَ يَ رَ، عِ تٌندِ عٍ شَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","نَ نَن عَ رَ، تِنَ ﭑ قَمَ نّ بَلَبَلَنيِ مَفَاشُشِ رَفٌرٌدٍ مِسِرَ مَ، وٌ مُ نَشَن مْولِ تٌ كَبِ دُنِحَ قْلّ. ");
INSERT INTO susa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","عِ شَ عِ شَ فْورّ نُن عِ شَ سٍ بِرِن نَسٌ يِرٍ مَكَنتَشِ كُي، بَرِ مَ يِ بَلَبَلَنيِ نَ بِرَ، عَ مِشِ نُن شُرُ سٍ بِرِن سْنتْمَ نّ.»›» ");
INSERT INTO susa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","قِرَوُنَ شَ كُنتِفِ ندٍيٍ نَشَ فَاشُ عَلَتَلَ شَ مَسٍنيِ يَ رَ، عٍ شُلُن عٍ شَ كٌنيِيٍ نُن عٍ شَ شُرُ سٍيٍ رَ سٌدٍ يِرٍ مَكَنتَشِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","كْنْ نَشٍيٍ مُ نُ عٍ حْشْ سَشِ عَلَتَلَ شَ مَسٍنيِ شْن مَ، عٍ نَشَ عٍ شَ كٌنيِيٍ نُن عٍ شَ شُرُ سٍيٍ لُ تَندٍ. ");
INSERT INTO susa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ بّلّشّ عِتَلَ كٌورٍ مَبِرِ، بَلَبَلَنيِ شَ بِرَ مِشِ، شُرُ سٍيٍ، نُن شّيٍ قَرِ مِسِرَ بْشِ بِرِن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","مُنسَ تٌ عَ شَ يِسُشُوُرِ عِتَلَ كٌورٍ مَ، عَلَتَلَ نَشَ سٍيَمَكْنيِ، فَلَنيِ، نُن بَلَبَلَنيِ رَفٌرٌ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","بَلَبَلَنيِ مَسُنبُشِ تّ رَ عَ نَشَ فٌرٌ عٍ مَ. مِسِرَ بْشِ مُ نُ نَ فبَلٌي مْولِ تٌ كَبِ عَ قْلّ. ");
INSERT INTO susa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","نَ بَلَبَلَنيِ نَشَ مِشِيٍ نُن شُرُ سٍيٍ مَفْنْ مِسِرَ بْشِ بِرِن مَ. عَ نَشَ شّيٍ نُن وُرِ بِلِيٍ قَن كَنَ. ");
INSERT INTO susa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","فٌسٍن بْشِ فبَنسَن نَشَ رَتَنفَ نَ فبَلٌي مَ، عِسِرَيِلَكَيٍ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ، عَ عَ قَلَ عٍ بّ، «يِ بِيَاسِ، ﭑ بَرَ يُنُبِ رَبَ. نْندِ نَ عَلَتَلَ نَن بّ. ﭑ تَن نُن ﭑ مَ حَمَ بَرَ تَنتَن. ");
INSERT INTO susa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","وٌ شَ عَلَتَلَ مَدِحّ، عَلَكٌ سٍيَمَكْنيِ نُن بَلَبَلَنيِ شَ حْن. ﭑ بَرَ تِن وٌ بّحِندٍ، ﭑ مُ كَنكَنمَ وٌ مَ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","مُنسَ نَشَ عَ قَلَ عَ بّ، «ﭑ نَ مِنِ تَا كُي، ﭑ عَلَتَلَ مَشَندِ مَ وٌ بّ. فَلَنيِ نُن بَلَبَلَنيِ دَنمَ نّ، عَلَكٌ عِ شَ عَ كٌلٌن عَ عَلَتَلَ نَن فبٍ دُنِحَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","كْنْ ﭑ بَرَ عَ كٌلٌن، عِ تَن نُن عِ شَ كُنتِفِيٍ، وٌ مُ فَاشُشِ مَرِفِ عَلَتَلَ يَ رَ سِندٍن.» ");
INSERT INTO susa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","نَ بَلَبَلَنيِ نُ بَرَ سَنسِ قُندٍن مَنِيّ نُن فّسّ قُتِ كَنَ، نَشٍيٍ مُ نُ مْ سِندٍن. ");
INSERT INTO susa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","مّنفِ نُن عَ مَنِيّ تَن مُ كَنَ، بَرِ مَ عٍ تَن تّمُي مُ نُ عَ لِشِ. ");
INSERT INTO susa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","مُنسَ نَشَ مِنِ قِرَوُنَ شْنيِ، عَ سِفَ تَا قَرِ مَ. عَ تٌ عَ بّلّشّ عِتَلَ عَلَتَلَ مَشَندِدٍ، فَلَنيِ، بَلَبَلَنيِ، نُن تُنّ نَشَ دَن. ");
INSERT INTO susa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","قِرَوُنَ تٌ نَ تٌ، عَ مَن نَشَ يُنُبِ سْتْ، بَرِ مَ عَ تَن نُن عَ شَ كُنتِفِيٍ نَشَ عٍ شَشِلِ رَشْرْشْ. ");
INSERT INTO susa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","نَ كُي قِرَوُنَ مُ تِن عِسِرَيِلَكَيٍ بّحِندٍ، عَلْ عَلَتَلَ عَ مَسٍنشِ كِ نَشّ مُنسَ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «سِفَ قِرَوُنَ يِرٍ، بَرِ مَ ﭑ تَن نَن عَ شَشِلِ نُن عَ شَ كُنتِفِيٍ شَشِلِ رَشْرْشْ، عَلَكٌ ﭑ شَ ﭑ مَ تْنشُمَ مَكَابَشِيٍ مَسٍن عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ﭑ فبَلٌي نَشَن دْشْمَ مِسِرَكَيٍ مَ، وٌ شَ نَ قَلَ وٌ شَ دِيٍ نُن وٌ شَ مَمَدِيٍ بّ، عَلَكٌ وٌ شَ عَ كٌلٌن، ﭑ تَن نَن عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","مُنسَ نُن هَرُنَ نَشَ سِفَ قِرَوُنَ شْنيِ، عٍ عَ قَلَ عَ بّ، «عِسِرَيِلَ مَرِفِ عَلَتَلَ شَ مَسٍنيِ نَن يَ، ‹عِ تٌندِ مَ عِ يّتّ مَفٌرٌدٍ ﭑ بّ هَن مُن تّمُي؟ عِ شَ ﭑ مَ حَمَ بّحِن، عٍ شَ سِفَ ﭑ بَتُدٍ. ");
INSERT INTO susa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","شَ عِ مُ عٍ بّحِن، تِنَ ﭑ كَتٌي رَدِنمَ نّ عِ شَ بْشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","عٍ بْشِ فبَاتَ مَكٌتٌمَ نّ، عٍ سَنسِ نُن وُرِ بِلِ بِرِن دٌنمَ نّ بَلَبَلَنيِ مُ نَشٍيٍ لِشِ. ");
INSERT INTO susa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","عٍ قَمَ سٌدٍ عِ تَن، عِ شَ كُنتِفِيٍ، نُن مِسِرَكَيٍ بِرِن شَ بَنشِيٍ كُي، عَلْ وٌ بٍنبَيٍ مُ نُ عَ تٌشِ كِ نَشّ كَبِ مِسِرَ قْلّ.›» مُنسَ تٌ فّ نَ قَلَدٍ، عَ نَشَ عَ كٌبٍ سٌ، عَ مِنِ قِرَوُنَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","قِرَوُنَ شَ كُنتِفِيٍ نَشَ عَ قَلَ عَ بّ، «يِ شّمّ وٌن تْورْ مَ هَن مُن تّمُي؟ عِ شَ عَ شَ حَمَ بّحِن عَلَكٌ عٍ شَ سِفَ عٍ مَرِفِ عَلَتَلَ بَتُدٍ. هَن يَ عِ مُ عَ كٌلٌن مِسِرَ نَ سْنتْقٍ نّ؟» ");
INSERT INTO susa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ، عَ عَ قَلَ عٍ بّ، «وٌ سِفَ، وٌ سَ وٌ مَرِفِ عَلَتَلَ بَتُ.» عَ مَن نَشَ عٍ مَشْرِن، «ندٍيٍ نَ سِفَقٍ وٌ يَ مَ؟» ");
INSERT INTO susa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","مُنسَ نَشَ عَ يَابِ، «مُشُ بِرِن سِفَمَ نّ؛ قٌنِكٍيٍ، قٌرِيٍ، شّمّيٍ، فِنّيٍ، مُشُ شَ شُرُ سٍيٍ. عَلَتَلَ شَ سَلِ شُنفبٍ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","قِرَوُنَ نَشَ عٍ يَابِ، «وٌ وَ مَ نّ ﭑ شَ عَ قَلَ وٌ بّ، ‹عَلَتَلَ شَ وٌ كَنتَ.› شَ ﭑ سَ عَ لُ وٌ شَ سِفَ، وٌ نُن وٌ شَ دِيٍ، ﭑ عَ كٌلٌن وٌ قٍ كٌبِ رَبَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ﭑ مُ تِنمَ نَ رَ. شّمّيٍ فبَنسَن نْمَ سِفَدٍ عَلَتَلَ بَتُدٍ، بَرِ مَ وٌ نَ نَن مَشْرِنشِ.» عَ تٌ فّ نَ قَلَدٍ، قِرَوُنَ نَشَ عٍ كٍرِ. ");
INSERT INTO susa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ بّلّشّ عِتَلَ مِسِرَ بْشِ شُن مَ، كَتٌييٍ شَ قَ. عٍ شَ بُرّشّ شِندٍ بِرِن دٌن بَلَبَلَنيِ مُ نَشٍيٍ لِشِ.» ");
INSERT INTO susa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","مُنسَ نَشَ عَ شَ يِسُشُوُرِ عِتَلَ مِسِرَ بْشِ شُن مَ، عَلَتَلَ قَ قٌيٍ رَ مِنِ يَنيِ نُن كْي كٍرٍن كُي كٍلِقٍ سٌفٍتٍدٍ. نَ كُيٍ عِبَ، نَ قٌيٍ نُ بَرَ قَ كَتٌييٍ رَ، ");
INSERT INTO susa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","نَشٍيٍ دِن مِسِرَ بْشِ بِرِن نَ. كَتٌييٍ فبٍفبٍ نَشَ لُ مِسِرَ يِرٍ بِرِن. هَن يَ نَ قٍ مَنِيّ مُ تٌشِ، عَ مَن مُ تٌمَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","عٍ نَشَ بْشِ بِرِن مَكٌتٌ هَن عَ عِقْورْ. عٍ نَشَ بُرّشّ شِندٍ نُن وُرِ بٌفِ بِرِن دٌن بَلَبَلَنيِ مُ نَشَن لِشِ. بُرّشّ شِندٍ يٌ مُ لُ وُرِيٍ نُن سَنسِيٍ كْن نَ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ مَقُرٍن. عَ نَشَ عَ قَلَ عٍ بّ، «ﭑ بَرَ يُنُبِ سْتْ وٌ مَرِفِ عَلَتَلَ رَ، ﭑ بَرَ هَاكّ سْتْ وٌ قَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","وٌ شَ دِحّ ﭑ مَ، وٌ شَ وٌ مَرِفِ عَلَتَلَ مَشَندِ عَلَكٌ عَ شَ يِ تْورّ بَ ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","مُنسَ نَشَ كٍلِ قِرَوُنَ يِرٍ، عَ نَشَ عَلَتَلَ مَشَندِ. ");
INSERT INTO susa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","عَلَتَلَ نَشَ تُرُننَادّ قٌيٍ رَ مِنِ، عَ كَتٌي بِرِن تُتُن سٌفٍفٌرٌدٍ، عَ سَ عٍ رَ سِن شُلُنيُمِ بَا مَ. هَلِ كَتٌي كٍرٍن مُ لُ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","نَ دَنفِ شَنبِ عَلَتَلَ نَشَ قِرَوُنَ شَشِلِ رَشْرْشْ، عَلَكٌ عَ نَشَ عِسِرَيِلَكَيٍ بّحِن. ");
INSERT INTO susa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","نَ تّمُي عَلَتَلَ نَشَ عَ قَلَ مُنسَ بّ، «عِ بّلّشّ عِتَلَ كٌورٍ مَ، دِ مِ بِنيٍ شَ سِن مِسِرَ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","مُنسَ تٌ نَ رَبَ، دِ مِ بِنيٍ نَشَ سِن مِسِرَ بْشِ بِرِن مَ. شِ سَشَن بُن مَ ");
INSERT INTO susa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","مِشِ مُ نْ عَ بٌورٍ تٌدٍ، مِشِ مُ نْ كٍلِدٍ عَ شْنيِ. كْنْ عِسِرَيِلَكَيٍ نُ سَبَتِشِ دّننَشّ، مّننِ تَن عِيَلَنشِ. ");
INSERT INTO susa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","قِرَوُنَ نَشَ مُنسَ شِلِ، عَ عَ قَلَ عَ بّ، «وٌ شَ سِفَ عَلَتَلَ بَتُدٍ. وٌ نْمَ وٌ شَ دِيٍ نُن وٌ شَ فِنّيٍ شَنِندٍ، كْنْ وٌ شَ وٌ شَ شُرُ سٍيٍ تَن لُ بٍ.» ");
INSERT INTO susa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","مُنسَ نَشَ عَ يَابِ، «عِ شَ تِن مُشُ شَ شُرُ سٍيٍ شَنِن مُشُ نَشٍيٍ بَمَ سّرّشّ رَ مُشُ مَرِفِ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","مُشُ شَ فْورّ بِرِن شَ سِفَ. هَلِ كٍرٍن مُ لُمَ بٍ. ندٍيٍ بَمَ سّرّشّ نَن نَ مُشُ مَرِفِ عَلَتَلَ بّ، كْنْ مُشُ مُ عَ كٌلٌن سِندٍن شُرُ سٍيٍ مُندُن رَوَلِمَ نَ كُي، قٌ مُشُ شَ سٌ نَا.» ");
INSERT INTO susa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","نَ دَنفِ شَنبِ عَلَتَلَ نَشَ قِرَوُنَ شَشِلِ رَشْرْشْ، عَ مُ تِن عٍ بّحِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","قِرَوُنَ نَشَ عَ قَلَ مُنسَ بّ، «كٍلِ ﭑ شُن مَ! عِ يّتّ رَتَنفَ تِقٍ رَ ﭑ يَ عِ سْنْن. شَ ﭑ عِ تٌ بٍ، ﭑ عِ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","مُنسَ نَشَ عَ يَابِ، «عَ شَ رَبَ عَلْ عِ عَ قَلَ كِ نَشّ. عِ مُ ﭑ تٌمَ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «ﭑ قَمَ كَابَنَكٌ دْنشْي رَفٌرٌدٍ قِرَوُنَ نُن مِسِرَكَيٍ مَ. نَ دَنفِ شَنبِ، قِرَوُنَ وٌ بّحِنمَ نّ، وٌ سِفَ كٍرٍنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","عَ قَلَ حَمَ بّ عٍ شَ عٍ دْشْبٌورٍ مَكُلَ فبٍتِ نُن شّيمَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","عَلَتَلَ نَشَ عَ رَفِرِ مِسِرَكَيٍ شَ تِن عِسِرَيِلَكَيٍ كِدٍ. مِسِرَ حَمَ نُن قِرَوُنَ شَ كُنتِفِيٍ نَشَ فَاشُ مُنسَ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","مُنسَ نَشَ عَ قَلَ، «عَلَتَلَ شَ مَسٍنيِ نَن يَ، ‹كْي تَفِ ﭑ مِسِرَ بْشِ عِفِرِ مَ نّ، ");
INSERT INTO susa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","دِ سِنفٍ بِرِن قَ قَشَ كٍلِقٍ قِرَوُنَ شَ دِ سِنفٍ مَ، عَ سَ دْشْ كٌنيِ فِنّيٍ شَ دِ سِنفٍ رَ. قِرَوُنَ تَن مَنفّيَ قِمَ عَ شَ دِ مَ، كٌنيِ فِنّ تَن تَامِ رَقَلَمَ، كْنْ عٍ شَ دِ سِنفٍ بِرِن قَمَ نّ قَشَدٍ. هَلِ مِسِرَكَيٍ شَ شُرُ سٍيٍ شَ دِ سِنفٍيٍ قَشَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","نَ تّمُي مِسِرَ وَ شُي ندٍ مّمَ نّ، عٍ مُ نَشَن مْولِ مّشِ تّمُي دَنفِشِيٍ، عٍ مُ نَشَن مْولِ مّمَ تّمُي نَشٍيٍ سَ قَمَ. ");
INSERT INTO susa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","كْنْ عِسِرَيِلَكَيٍ شْنيِ، هَلِ بَرٍ كٍرٍن مُ وٌنوٌنمَ. نَ كُي وٌ شَ عَ كٌلٌن ﭑ تَفِ رَ سَ لُشِ مِسِرَكَيٍ نُن عِسِرَيِلَكَيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","نَ تّمُي عِ شَ كُنتِفِيٍ بِرِن قَمَ نّ عٍ شِنبِ سِندٍ ﭑ بُن مَ، عٍ عَ قَلَ ﭑ بّ، عَ ﭑ تَن نُن ﭑ مَ حَمَ بِرِن شَ مِنِ عٍ شَ بْشِ كُي. ﭑ نَ فّ نَ رَبَدٍ، ﭑ سِفَمَ نّ.›» مُنسَ تٌ فّ نَ قَلَدٍ، عَ نَشَ كٍلِ قِرَوُنَ شُن مَ، عَ شْنْشِ كِ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ، «قِرَوُنَ مُ عَ تُلِ مَتِمَ وٌ رَ. نَ كُي ﭑ نَن ﭑ مَ كَابَنَكٌي شُن مَسَمَ نّ مِسِرَ بْشِ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","مُنسَ نُن هَرُنَ نُ بَرَ نَ كَابَنَكٌي بِرِن نَبَ قِرَوُنَ يَ شْرِ، كْنْ عَلَتَلَ بَرَ قِرَوُنَ شَشِلِ رَشْرْشْ، عَ مُ تِن عِسِرَيِلَكَيٍ شَ مِنِ عَ شَ بْشِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ مِسِرَ بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«يِ كِكٍ نَشَن يَ، يِ نَن قِندِ مَ وٌ بّ حّ كِكٍ سِنفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","وٌ شَ عَ قَلَ عِسِرَيِلَ حَمَ بِرِن بّ، يِ كِكٍ شِ قُ، دٍنبَيَ يٌ دٍنبَيَ شَ يّشّي كٍرٍن سْتْ. ");
INSERT INTO susa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","شَ دٍنبَيَ ندٍ شُرُن، عٍ مُ نْمَ نَ رَ، عٍ شَ كَقُ عٍ دْشْ بٌورٍ ندٍيٍ مَ عَلَكٌ يّشّي كٍرٍن شَ عٍ بِرِن نَلِ. ");
INSERT INTO susa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","نَ يّشّي شَ قِندِ شّمّ رَ، نَشَن بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَشَن مَ. شَ نَ مُ عَ رَ، وٌ نْمَ سِ قَن نَوَلِدٍ. ");
INSERT INTO susa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","وٌ شَ عَ رَفَتَ هَن نَ كِكٍ شِ قُ نُن نَانِ. نَ لْشْي عِسِرَيِلَ دٍنبَيَ بِرِن شَ عٍ فبٍ كْن نَشَبَ سٌفٍ دُلَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","وٌ شَ عَ وُلِ مَسٌ نَادّ فبَنيِ نُن عَ سّيتِيٍ مَ، عَ دٌنمَ بَنشِ نَشَن كُي. ");
INSERT INTO susa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","نَ سُبٍ شَ فَن تّ رَ، وٌ شَ عَ دٌن نَ كْي رَ تَامِ لّبِنِتَرٍ نُن بُرّشّ شْنّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","وٌ نَشَ عَ دٌن عَ فَنتَرٍ رَ، وٌ نَشَ عَ حِن يٍ رَ. وٌ شَ عَ بِرِن فَن عَ قَنيِ رَ بٍينُ وٌ شَ عَ عِشَبَ. عَ شُنيِ، عَ سَنيِيٍ، نُن عَ قُرِنفّيٍ شَ فَن تّمُي كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","نَ سٍسٍ نَشَ شِ هَن فّيسّفّ. شَ ندٍ لُشِ، وٌ شَ نَ وٌلِ تّ شْورَ. ");
INSERT INTO susa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","وٌ شَ عَ دٌن وٌ تَفِ عِشِرِشِ، وٌ شَ سَنكِرِيٍ سٌشِ وٌ سَنيِيٍ، عَ نُن وٌ شَ يِسُشُوُرِ سُشُشِ وٌ بّلّشّ رَ. وٌ شَ عَ دٌن مَقُرٍن مَقُرٍن. عَلَتَلَ شَ سَيَمَلٍكّ دَنفِ سَلِ سّرّشّ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«نَ كْي رَ، ﭑ مِسِرَ بْشِ عِسَمَ نّ، ﭑ دِ سِنفٍ بِرِن قَشَ مِشِيٍ نُن شُرُ سٍيٍ يَ مَ. ﭑ مِسِرَ شَ عَلَيٍ حَشَنكَتَمَ نّ. ﭑ تَن نَن عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ﭑ نَ نَ وُلِ تْنشُمَ تٌ وٌ شَ نَادّيٍ مَ، ﭑ دَنفِمَ نّ مّننِ شُن مَ. كَسَرّ يٌ مُ وٌ لِمَ، ﭑ مِسِرَ بْشِ رَتْنمَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«نَ لْشْي شَ قِندِ سَلِ شُنفبٍ نَن نَ وٌ بّ عَلَتَلَ شَ بِنيّ بُن مَ. وٌ شَ نَ سَلِ رَبَ حّ يٌ حّ عَلَتَلَ شَ يَامَرِ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","نَ سَلِ وَشَتِ وٌ شَ تَامِ لّبِنِتَرٍ دٌن شِ سٌلٌقٍرٍ بُن مَ. سَلِ قْلّ لْشْي، وٌ شَ لّبِنِ بِرِن نَمِنِ وٌ شَ بَنشِيٍ كُي. مِشِ يٌ نَشَن تَامِ لّبِنِ دَاشِ دٌنمَ نَ شِ سٌلٌقٍرٍ بُن مَ، نَ كَنيِ شَ رَ مِنِ عِسِرَيِلَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","نَ سَلِ لْشْي سِنفٍ نُن نَ سَلِ لْشْي سٌلٌقٍرٍ ندٍ، وٌ شَ وٌ مَلَن عَلَتَلَ شَ بِنيّ بُن مَ. نَ لْشْي قِرِنيِيٍ، وٌ نَشَ وَلِ يٌ رَبَ بَقٍ دٌنسٍ رَقَلَقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«وٌ شَ يِ تَامِ لّبِنِتَرٍ سَلِ رَبَ، بَرِ مَ ﭑ وٌ شَ حَمَ رَ مِنِ مِسِرَ بْشِ رَ نَ لْشْي نّ. ﭑ بَرَ وٌ يَمَرِ وٌ شَ يِ سَلِ رَبَ حّ يٌ حّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","كِكٍ سِنفٍ، شِ قُ نُن نَانِ، نُنمَرٍ قْلْ تّمُي، وٌ نَشَ تَامِ يٌ دٌن بَقٍ تَامِ لّبِنِتَرٍ رَ هَن عَ شِ مْشْحّن نُن كٍرٍن، عَ نُنمَرٍ تّمُي. ");
INSERT INTO susa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","نَ شِ سٌلٌقٍرٍ بُن مَ، لّبِنِ يٌ نَشَ تٌ وٌ شْنيِ، بَرِ مَ شْحّ نُن عِسِرَيِلَكَ بِرِن نَشَن لّبِنِ دٌنمَ نَ وَشَتِ بُن مَ، عَ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","وٌ نَشَ تَامِ لّبِنِ دَاشِ دٌن دّدّ.» ");
INSERT INTO susa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","مُنسَ نَشَ عِسِرَيِلَ قٌرِ بِرِن شِلِ، عَ عَ قَلَ عٍ بّ، «وٌ شَ سِفَ شُرُ سٍ ندٍ سْتْدٍ وٌ شَ دٍنبَيَيٍ بّ. وٌ شَ عٍ كْن نَشَبَ سَيَمَلٍكّ دَنفِ سَلِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","وٌ نَ فّ شُرُ سٍ كْن نَشَبَدٍ، وٌ شَ عَ وُلِ مَسٌ نَادّ فبَنيِ نُن نَادّ سّيتِيٍ مَ هِسٌثِ بُرّشّ رَ. مِشِ يٌ نَشَ مِنِ عَ شَ بَنشِ كُي هَن فّيسّفّ. ");
INSERT INTO susa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","عَلَتَلَ نَ مِسِرَ بْشِ عِسَ دِ سِنفٍ قَشَقٍ رَ، عَ دَنفِمَ نّ بَنشِيٍ شُن مَ، وُلِ نَ نَشٍيٍ نَادّ فبَنيِ نُن عَ سّيتِيٍ مَ. عَ مُ تِنمَ كَنَرِ يٌ شَ سٌ وٌ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","وٌ نُن وٌ شَ دِيٍ شَ يِ يَامَرِ رَتِنمّ حّ يٌ حّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","وٌ نَ سٌ بْشِ كُي عَلَتَلَ نَشَن لَايِدِشِ وٌ بّ، وٌ شَ يِ سَلِ رَبَ عَ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","وٌ شَ دِيٍ نَ وٌ مَشْرِن، ‹يِ سَلِ مُنسٍ مَسٍنمَ وٌن بّ،› ");
INSERT INTO susa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","وٌ شَ عٍ يَابِ، ‹سَيَمَلٍكّ دَنفِ سَلِ سّرّشّ نَن عَ رَ. وٌن نَ رَبَمَ عَلَتَلَ بّ نَشَن دَنفِ عِسِرَيِلَكَيٍ شَ بَنشِيٍ شُن مَ مِسِرَ، عَلَكٌ عٍ شَ رَتَنفَ، مِسِرَكَيٍ تَن شَ قَشَ.›» عِسِرَيِلَ حَمَ نَشَ عَ سُيِدِ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","عِسِرَيِلَكَيٍ نَشَ نَ يَامَرِ رَتِنمّ عَلْ عَلَتَلَ عَ مَسٍنشِ مُنسَ نُن هَرُنَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","كْي تَفِ عَلَتَلَ نَشَ دِ سِنفٍ بِرِن قَشَ مِسِرَ بْشِ كُي، كٍلِقٍ قِرَوُنَ كِبَنيِ كَنيِ شَ دِ سِنفٍ مَ، عَ سَ دْشْ فٍيلِمَنِ شَ دِ سِنفٍ رَ. عَ نَشَ شُرُ سٍ شَ دِ سِنفٍ قَن بِرِن قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","نَ كُي قِرَوُنَ نَشَ كٍلِ كْي رَ، عَ تَن، عَ شَ كُنتِفِيٍ، نُن مِسِرَكَيٍ بِرِن، عٍ قَ عٍ وَ شُي رَتٍ، بَرِ مَ بَنشِ كٍرٍن مُ لُ قَشّ مُ تِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","نَ كْي رَ قِرَوُنَ نَشَ مُنسَ نُن هَرُنَ شِلِ، عَ عَ قَلَ عٍ بّ، «وٌ نُن عِسِرَيِلَكَيٍ، وٌ مِنِ ﭑ مَ حَمَ يَ مَ. وٌ سِفَ، وٌ سَ عَلَتَلَ بَتُ، عَلْ وٌ نُ وَ مَ عَ شْن مَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","وٌ شَ وٌ شَ شُرُ سٍيٍ شَنِن، عَلْ وٌ عَ قَلَشِ كِ نَشّ. وٌ سِفَ! وٌ شَ دُبَ ﭑ قَن بّ.» ");
INSERT INTO susa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","مِسِرَكَيٍ نُ فبَتَشِ عِسِرَيِلَكَيٍ شَ سِفَ. عٍ نُ عَ قَلَ، «شَ عٍ مُ سِفَمَ، وٌن بِرِن قَمَ نّ سْنتْدٍ!» ");
INSERT INTO susa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","نَ نَن عَ رَ عِسِرَيِلَكَيٍ نَشَ تَامِ رَ مُلَنشِ مَقِلِن عٍ شَ دُفِيٍ كُي، بٍينُ تَامِ شَ تٍ. عٍ نَشَ تَامِ نُن تَامِ رَ مُلَنسٍ دْشْ عٍ شُن مَ، عٍ قَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","عِسِرَيِلَكَيٍ نَشَ فبٍتِ، شّيمَ، نُن دُفِيٍ مَكُلَ مِسِرَكَيٍ مَ عَلْ مُنسَ عَ قَلَ عٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","عَلَتَلَ نَشَ عَ رَفِرِ مِسِرَكَيٍ شَ تِن عِسِرَيِلَكَيٍ وَشْنقٍ رَ. نَ كُي عِسِرَيِلَكَيٍ نَشَ سٍ فبٍفبٍ سْتْ مِسِرَكَيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","عِسِرَيِلَكَيٍ نَشَ كٍلِ رَ مٍسٍسِ، سِفَقٍ سُكْتِ. شّمّ وُلُ كّمّ سٍننِ نُ نَ، بَقٍ فِنّيٍ نُن دِ مّدِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","مِشِ فبّتّيٍ قَن نَشَ بِرَ عٍ قْشْ رَ، عَ نُن فْورّ فبٍفبٍ مْولِ بِرِن. ");
INSERT INTO susa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","عٍ نَشَ تَامِ فَن، نَ تَامِ لّبِنِتَرٍ رَ مُلَنشِ رَ، عٍ قَشِ نَشَن نَ عٍ شُن مَ كٍلِقٍ مِسِرَ. نَ تَامِ مُ نُ تٍشِ، بَرِ مَ مِسِرَكَيٍ تٌ عٍ كٍرِ، عٍ مُ نْ قَندّ رَقَلَدٍ. ");
INSERT INTO susa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","عِسِرَيِلَكَيٍ نُ بَرَ حّ كّمّ نَانِ حّ تٌنفٌ سَشَن نَبَ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","نَ حّ كّمّ نَانِ حّ تٌنفٌ سَشَن حْن لْشْي يَتِ، عَلَتَلَ شَ حَمَ بِرِن مِنِ مِسِرَ بْشِ رَ نَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","عَلَتَلَ تٌ نَ كْي رَدَنفِ عِسِرَيِلَ حَمَ رَ مِنِقٍ رَ مِسِرَ، عَ لَنمَ عِسِرَيِلَكَيٍ بِرِن شَ نَ كْي شُنفبِلٍنيِ رَدَنفِ عَلَتَلَ مَتْشْقٍ رَ حّ يٌ حّ. ");
INSERT INTO susa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","عَلَتَلَ نَشَ يِ سّرِيّ سٌ مُنسَ نُن هَرُنَ يِ رَ سَيَمَلٍكّ دَنفِ سَلِ شَ قٍ رَ، «مِشِ يٌ نَشَ نَ سّرّشّ دٌن نَشَن مُ قِندِشِ عِسِرَيِلَكَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","وٌ شَ كٌنيِ سُننَشِيٍ نْمَ عَ دٌندٍ، ");
INSERT INTO susa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","كْنْ وٌ شَ وَلِكّ نَشٍيٍ كٍلِشِ يِرٍ فبّتّ، عٍ نَشَ عَ دٌن. ");
INSERT INTO susa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","نَ سّرّشّ شَ دٌن بَنشِ نَن كُي، وٌ نَشَ عَ سُبٍ شَنِن تَندٍ، وٌ نَشَ عَ شْرِ يٌ فِرَ. ");
INSERT INTO susa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","عِسِرَيِلَ حَمَ بِرِن شَ سَيَمَلٍكّ دَنفِ سَلِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","شَ وٌ شَ شْحّ ندٍ وَ مَ سَيَمَلٍكّ دَنفِ سَلِ رَبَقٍ عَلَتَلَ شَ بِنيّ بُن مَ، قٌ عَ شَ شّمّ بِرِن سُننَ عَ شَ دٍنبَيَ كُي. شَ عَ بَرَ نَ رَبَ، عَ نْمَ نَ سَلِ رَبَدٍ عَلْ عِسِرَيِلَكَيٍ. كْنْ سُننَتَرٍيٍ مُ نْمَ عَ دٌندٍ. ");
INSERT INTO susa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","لَسِرِ نُن شْحّ بِرِن نَ نَ سّرِيّ بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","عِسِرَيِلَكَ بِرِن نَشَ عَ رَبَ، عَلْ عَلَتَلَ مُنسَ نُن هَرُنَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","نَ لْشْي يَتِ، عَلَتَلَ نَشَ عِسِرَيِلَكَيٍ رَ مِنِ مِسِرَ بْشِ رَ، عٍ لَنشُندّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«وٌ شَ دِ سِنفٍ بِرِن قِ ﭑ مَ، عَ قِندِ مِشِ رَ، عَ قِندِ شُرُ سٍ رَ. ﭑ تَن نَن فبٍ نَ عِسِرَيِلَكَيٍ بِرِن شَ دِ سِنفٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","مُنسَ نَشَ عَ قَلَ حَمَ بّ، «وٌ شَ رَتُ تٌ لْشْي مَ سَلِ رَ، بَرِ مَ عَلَتَلَ سّنبّ نَن وٌ رَ مِنِشِ مِسِرَ بْشِ مَ كٌنيِيَ كُي. وٌ نَشَ لّبِنِ يٌ دٌن نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","وٌ مِنِشِ تٌ عَبِبِ كِكٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","عَلَتَلَ نَ وٌ رَ سٌ بْشِ كُي، عَ نَشَن لَايِدِشِ وٌ بٍنبَيٍ بّ، كَنَانكَيٍ، شِتِكَيٍ، عَمٌرِكَيٍ، هِوِكَيٍ نُن يٍبُسُكَيٍ سَبَتِشِ دّننَشّ، شِحّ نُن كُمِ شّلّمَ بْشِ نَشَن مَ، وٌ شَ تَامِ لّبِنِتَرٍ سَلِ رَبَ نَ كِكٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","نَ سَلِ وَشَتِ وٌ شَ تَامِ لّبِنِتَرٍ فبَنسَن دٌن شِ سٌلٌقٍرٍ بُن مَ. نَ شِ سٌلٌقٍرٍ ندٍ، وٌ شَ سَلِ رَبَ عَلَتَلَ شَ بِنيّ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","نَ شِ سٌلٌقٍرٍ بُن مَ تَامِ لّبِنِتَرٍ نَن دٌنمَ. لّبِنِ يٌ نَشَ لُ عِسِرَيِلَكَ ندٍ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","نَ لْشْي وٌ شَ يِ سَلِ شَ قٍ قَتَنقَسِ وٌ شَ دِيٍ بّ، وٌ قَ عَ قَلَ، ‹ﭑ يِ سَلِ رَبَمَ نّ، بَرِ مَ عَلَتَلَ بَرَ ﭑ نَمِنِ مِسِرَ بْشِ رَ.› ");
INSERT INTO susa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","يِ سَلِ لُمَ نّ وٌ بّ عَلْ تْنشُمَ نَشَن سَشِ وٌ بّلّشّ مَ، شَ نَ مُ تْنشُمَ نَشَن سَشِ وٌ تِفِ مَ، عَلَكٌ وٌ نَشَ نّيمُ عَلَتَلَ شَ سّرِيّ مَ. ");
INSERT INTO susa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","وٌ شَ يِ سَلِ رَبَ عَ وَشَتِ حّ بِرِن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«عَلَتَلَ نَ وٌ رَ سٌ كَنَانكَيٍ شَ بْشِ مَ، عَ عَ قِ وٌ مَ عَلْ عَ لَايِدِشِ وٌ تَن نُن وٌ بٍنبَيٍ بّ كِ نَشّ، ");
INSERT INTO susa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","وٌ شَ وٌ شَ دِ شّمّ سِنفٍ بِرِن قِ عَلَتَلَ مَ، عَ نُن وٌ شَ شُرُ سٍيٍ شَ دِ شّمّ سِنفٍ. وٌ شَ دِ شّمّمَ سِنفٍ بِرِن قِندِشِ عَلَتَلَ نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","وٌ نْمَ يّشّي شَ نَ مُ عَ رَ سِ قِدٍ وٌ شَ سٌقَلٍ شَ دِ سِنفٍ حْشْي رَ، شَ نَ مُ عَ رَ وٌ شَ عَ كٌبٍ فِرَ، عَ شَ قَشَ. وٌ شَ وٌ شَ دِ سِنفٍ قَن شُن سَرَ يّشّي رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","شَ عَ سَ لِ وٌ شَ دِ ندٍ وٌ مَشْرِنمَ عَ وٌ يِ قٍ رَبَمَ قٍ نَشَن مَ، وٌ شَ عَ يَابِ، ‹عَلَتَلَ سّنبّ نَن وٌن نَمِنِشِ كٌنيِيَ كُي مِسِرَكَيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","قِرَوُنَ تٌ تٌندِ مُشُ بّحِندٍ مُشُ شَ سِفَ، عَلَتَلَ نَشَ مِسِرَ دِ سِنفٍ بِرِن قَشَ مِشِيٍ نُن شُرُ سٍيٍ يَ مَ. نَ نَن عَ رَ وٌن شُرُ سٍيٍ شَ دِ سِنفٍ بِرِن قِمَ عَلَتَلَ مَ سّرّشّ رَ، عَ نُن وٌن مَ دِ شّمّ سِنفٍ بِرِن شُن سَرَ مَ نّ يّشّي رَ.› ");
INSERT INTO susa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","نَ لُمَ نّ وٌ بّ عَلْ تْنشُمَ نَشَن سَشِ وٌ بّلّشّ مَ، شَ نَ مُ تْنشُمَ نَشَن سَشِ وٌ تِفِ مَ، بَرِ مَ عَلَتَلَ سّنبّ نَن وٌ رَ مِنِشِ مِسِرَ بْشِ مَ كٌنيِيَ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","قِرَوُنَ تٌ عِسِرَيِلَ حَمَ بّحِن، عَلَتَلَ مُ عٍ شُن تِ قِلِسِتَ بْشِ كِرَ رَ، هَلِ نَ كِرَ نَن تٌ سْونّيَ، بَرِ مَ عَ عَ قَلَ نّ، «شَ حَمَ فٍرٍ لِمَ كِرَ شْن مَ، عٍ نَتّ مَسَرَ مَ نّ، عٍ قَ فبِلٍن مِسِرَ.» ");
INSERT INTO susa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","نَ كُي عَلَتَلَ نَشَ حَمَ يَ رَقِندِ فبٍنفبٍرٍنيِ كِرَ مَ شُلُنيُمِ بَا مَبِرِ. عِسِرَيِلَكَيٍ نَشَ مِنِ مِسِرَ عٍ شَ فٍرٍ سٌسٍيٍ رَ عٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","مُنسَ نَشَ يُسُقُ شْرِيٍ قَن شَنِن، بَرِ مَ يُسُقُ نُ بَرَ عِسِرَيِلَ شَ دِيٍ رَكَلِ نَ قٍ مَ، عَ قَلَقٍ رَ، «ﭑ عَ كٌلٌن، عَلَتَلَ قَمَ نّ وٌ مَلِدٍ. نَ تّمُي وٌ شَ ﭑ شْرِيٍ شَنِن وٌ شُن مَ يِرٍ فبّتّ.» ");
INSERT INTO susa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","عِسِرَيِلَكَيٍ نَشَ كٍلِ سُكْتِ، عٍ سَ يٌنكِن عٍتَمَ فبٍنفبٍرٍنيِ قْلْشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","عَلَتَلَ نَن نُ تِشِ عٍ يَ رَ. يَنيِ رَ عَ نَشَ عٍ رَحّرّ نُشُي رَ، كْي رَ عَ نَشَ عٍ رَحّرّ تّ دّشّ رَ كٌورٍ مَ، نَشَن نُ كُيٍ عِيَلَنمَ عٍ بّ. نَ كِ عٍ نُ نْمَ حّرّدٍ كْي نُن يَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","لْشْ يٌ لْشْ نَ نُشُي نُ تِشِ عٍ يَ رَ يَنيِ رَ، نَ تّ قَن نُ تِشِ عٍ يَ رَ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ عٍ شَ فبِلٍن، عٍ شَ قَ يٌنكِن ثِ هَشِرْتِ مَبِرِ رَ، مِفِدٌلِ نُن بَا تَفِ. عٍ شَ لُ بَا دّ رَ بَالِ سٍقٌن يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","قِرَوُنَ عَ مَحْشُنمَ نّ، عَ عِسِرَيِلَكَيٍ بَرَ لْي فبٍنفبٍرٍنيِ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ﭑ قِرَوُنَ شَشِلِ رَشْرْشْمَ نّ، عَلَكٌ عَ شَ بِرَ وٌ قْشْ رَ. نَ كُي ﭑ قَمَ مَتْشْي سْتْدٍ قِرَوُنَ نُن عَ شَ سْورِيٍ سَابُي رَ. مِسِرَكَيٍ قَمَ نّ عَ كٌلٌندٍ عَ ﭑ تَن نَن نَ عَلَتَلَ رَ.» عِسِرَيِلَكَيٍ عَ رَبَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","مِسِرَ مَنفّ نُن عَ شَ كُنتِفِيٍ تٌ عَ كٌلٌن، عَ عِسِرَيِلَكَيٍ بَرَ سِفَ، عٍ نَشَ نَتّ مَسَرَ، عَ قَلَقٍ رَ، «وٌن مُنسٍ رَبَشِ يِ كِ؟ وٌن تٌ عِسِرَيِلَكَيٍ بّحِنشِ، عٍ مُ وَلِمَ وٌن بّ سْنْن!» ");
INSERT INTO susa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","قِرَوُنَ نَشَ يَامَرِ قِ سٌي شَ شِرِ سْورِ رَفِسٍيٍ رَ، سْورِيٍ شَ مَلَن يِرٍ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","عَ نَشَ سْورِ رَفِسٍ قَنيِ كّمّ سٍننِ سُفَندِ، سْورِ رَفِسٍ نَشَن بِرِن نَ مِسِرَ عٍ قَ بِرَ عٍ قْشْ رَ. سْورِ كُنتِفِ نُ بَكِشِ عٍ بِرِن كُي. ");
INSERT INTO susa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","عَلَتَلَ نَشَ مِسِرَ مَنفّ قِرَوُنَ شَشِلِ رَشْرْشْ، عَ قَ بِرَ عِسِرَيِلَكَيٍ قْشْ رَ، نَشٍيٍ نُ سِفَقٍ شُن نَكٍلِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","قِرَوُنَ نُن عَ شَ سْورِ بِرِن نَشَ بِرَ عِسِرَيِلَكَيٍ قْشْ رَ عٍ شَ سٌي نُن عٍ شَ سْورِ رَفِسٍيٍ رَ. مِسِرَكَيٍ نَشَ عٍ لِ بَا دّ رَ، عٍ نُ يٌنكِنشِ دّننَشّ، ثِ هَشِرْتِ مَبِرِ رَ، بَالِ سٍقٌن يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","قِرَوُنَ تٌ مَكْرّ عٍ رَ، عِسِرَيِلَكَيٍ نَشَ عٍ يَ رَكٍلِ، عٍ نَشَ مِسِرَكَيٍ تٌ قَ رَ. عٍ نَشَ فَاشُ كِ قَنيِ رَ، عٍ قَ عٍ مَوَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","عٍ نَشَ عَ قَلَ مُنسَ بّ، «عِ وٌن نَمِنِشِ مِسِرَ بْشِ رَ مُنقٍ رَ؟ يَكْسِ وٌن قَشَمَ نّ فبٍنفبٍرٍن يِرٍ. عَ مُ نُ قِسَ وٌن شَ قَشَ مِسِرَ؟ ");
INSERT INTO susa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","وٌن نُ نَ مِسِرَ بْشِ مَ تّمُي نَشّ، مُشُ عَ قَلَ نّ عِ بّ، ‹مُشُ وَلِقٍ مِسِرَكَيٍ بّ، نَ قِسَ مُشُ بّ دِنّ قَشَقٍ رَ فبٍنفبٍرٍنيِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","مُنسَ نَشَ حَمَ يَابِ، «وٌ نَشَ فَاشُ، وٌ شَ لِمَنِيَ. تٌ وٌ قَمَ عَلَتَلَ شَ كِسِ تٌدٍ. مِسِرَكَيٍ نَشٍيٍ يِ كِ، وٌ مُ عٍ تٌمَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","عَلَتَلَ نَن فٍرٍ سٌمَ وٌ بّ. وٌ سَبَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ مَوَقٍ ﭑ بّ مُنقٍ رَ؟ عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ شَ تِ كِرَ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","عِ شَ يِسُشُوُرِ رَتٍ، عَ عِتَلَ بَا شُن مَ، عَلَكٌ بَا شَ رَبِ، عِسِرَيِلَكَيٍ شَ عِفِرِ بْشِ شَرَشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ﭑ مِسِرَكَيٍ شَشِلِ رَشْرْشْمَ نّ، عَلَكٌ عٍ شَ بِرَ وٌ قْشْ رَ. نَ كُي ﭑ مَتْشْي سْتْمَ قِرَوُنَ، عَ شَ سْورِيٍ، عَ شَ سْورِ رَفِسٍيٍ، نُن عَ شَ سٌي رَفِمَيٍ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ﭑ نَ فّ مَتْشْي سْتْدٍ قِرَوُنَ، عَ شَ سْورِ رَفِسٍيٍ، نُن عَ شَ سٌي رَفِمَيٍ سَابُي رَ، مِسِرَكَيٍ عَ كٌلٌنمَ نّ عَ ﭑ تَن نَن نَ عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","عَلَ شَ مَلٍكّ نَشَن نُ نَ سِفَقٍ عِسِرَيِلَ حَمَ يَ رَ، عَ نَشَ فبِلٍن عٍ شَنبِ رَ. نُشُي قَن نَشَ كٍلِ عٍ يَ رَ، عَ قَ تِ عٍ شَنبِ رَ ");
INSERT INTO susa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","مِسِرَكَيٍ نُن عِسِرَيِلَكَيٍ تَفِ. نَ نُشُي نَشَ عَ نِيَ مِسِرَكَيٍ شَ لُ دِ مِ كُي، عِسِرَيِلَكَيٍ تَن شَ لُ نَءِيَلَنيِ كُي. عٍ مُ نْ عٍ مَكْرّدٍ عٍ بٌورٍ رَ نَ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","مُنسَ تٌ عَ بّلّشّ عِتَلَ بَا شُن مَ، عَلَتَلَ نَشَ بَا تُتُن كْي بِرِن نَ قٌيٍ شُنفبٍ رَ كٍلِقٍ سٌفٍتٍدٍ. عَ نَشَ كِرَ شَرَشِ رَ مِنِ بَا تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","عِسِرَيِلَكَيٍ دَنفِمَ دّننَشّ، بَا يٍيٍ نَشَ مَلَن عٍ يِرٍقَنيِ مَ نُن عٍ كْولَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","مِسِرَكَيٍ نَشَ عٍ سَفَتَ. قِرَوُنَ شَ سٌي، عَ شَ سْورِ رَفِسٍيٍ، نُن عَ شَ سٌي رَفِمَيٍ بِرِن نَشَ بِرَ عٍ قْشْ رَ بَا تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","سُبَشّ مَ، عَلَتَلَ نَشَ عَ يَ رَ سِفَ مِسِرَ شَ سْورِيٍ مَ كٍلِقٍ كٌورٍ مَ، تّ نُن نُشُي نَ دّننَشّ، عَ قَ عٍ عِقُ. ");
INSERT INTO susa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","عَ نَشَ عَ رَفِرِ سْورِيٍ رَفِسٍيٍ سَنيِيٍ شَ بَ نَ، عٍ شَ حّرّ شَ شْرْشْ. نَ كُي، مِسِرَكَيٍ نَشَ عَ قَلَ، «وٌن شَ وٌن فِ عِسِرَيِلَكَيٍ مَ، بَرِ مَ عَلَتَلَ نَن نَ عٍ شَ فٍرٍ سٌقٍ.» ");
INSERT INTO susa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ بّلّشّ عِتَلَ بَا شُن مَ، يٍ شَ رَدِن مِسِرَكَيٍ، عٍ شَ سْورِ رَفِسٍيٍ، نُن عٍ شَ سٌي رَفِمَيٍ شُن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","مُنسَ تٌ نَ رَبَ سُبَشّ مَ، بَا نَشَ فبِلٍن عَ يِرٍ. مِسِرَكَيٍ نُ نَ عٍ فِقٍ تّمُي نَشّ، عَلَتَلَ نَشَ يٍ دُ سُ عٍ بِرِن شُن نَ. ");
INSERT INTO susa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","يٍ نَشَ قِرَوُنَ شَ سْورِيٍ، عَ شَ رَفِسٍيٍ، سٌي رَفِمَيٍ، نُن عَ شَ سْورِ بِرِن مَكٌتٌ. نَشٍيٍ نُ بِرَشِ عِسِرَيِلَكَيٍ قْشْ رَ بَا كُي، نٍيٍ بِرِن نَشَ لْي. ");
INSERT INTO susa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","كْنْ عِسِرَيِلَكَيٍ نَشَ بَا عِفِرِ كِرَ شَرَشِ شْن مَ. يٍ نُ مَلَنشِ عٍ يِرٍقَنيِ مَ نُن عٍ كْولَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","نَ لْشْي عَلَتَلَ نَشَ عِسِرَيِلَكَيٍ رَتَنفَ مِسِرَكَيٍ مَ. عِسِرَيِلَكَيٍ نَشَ مِسِرَكَيٍ قُرٍيٍ تٌ بَا دّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","عِسِرَيِلَكَيٍ تٌ عَلَتَلَ سّنبّ تٌ عَ نَشَن نَوَلِشِ مِسِرَكَيٍ شِلِ مَ، عٍ نَشَ فَاشُ عَلَتَلَ يَ رَ، عٍ قَ عٍ تَشُ عَلَتَلَ نُن عَ شَ شّيرَ مُنسَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","نَ دَنفِ شَنبِ مُنسَ نُن عِسِرَيِلَكَيٍ نَشَ يِ بّيتِ بَ عَلَتَلَ بّ. «ﭑ شَ يِ بّيتِ بَ عَلَتَلَ بّ، نَشَن شِلِ فبٌ. عَ بَرَ سٌي نُن عَ رَفِمَ مَدُلَ بَا مَ. ");
INSERT INTO susa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ﭑ سّنبّ نَ عَلَتَلَ نَن نَ. ﭑ عَ مَتْشْمَ بّيتِ رَ. عَ بَرَ قِندِ ﭑ نَكِسِمَ نُن ﭑ مَرِفِ رَ. ﭑ تَنتُي رَ سِفَمَ ﭑ بٍنبَيٍ مَرِفِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","سّنبّمَ نَن عَلَ رَ. عَ شِلِ نّ عَلَتَلَ. ");
INSERT INTO susa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","عَ نَشَ قِرَوُنَ شَ سْورِيٍ نُن عٍ رَفِسٍيٍ رَ سِن بَا مَ. قِرَوُنَ شَ كُنتِفِيٍ نَشَ مَدُلَ شُلُنيُمِ بَا مَ. ");
INSERT INTO susa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","مْرْنيِيٍ نَشَ عٍ مَكٌتٌ، عٍ نَشَ فٌرٌ عَ بْتِنِ مَ عَلْ فّمّ. ");
INSERT INTO susa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","عَلَتَلَ، عِ سّنبّ مَفَاشُ. عِ بَرَ نْ عِ يَشُييٍ رَ، عِ بَرَ نْ عِ مَتَندِ مَيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","عِ شَ مَنفّيَ سّنبّ مَفَاشُ. عِ بْحّ نَ تٍ، عٍ فَنمَ نّ عَلْ سّشّ تّ سٌشِ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","عِ شَ قٌيٍ نَشَ شُلُنيُمِ بَا رَبِ، كِرَ شَرَشِ نَشَ لُ عَ تَفِ. مْرْنيِيٍ نَشَ تٍ عَلْ بَنشِ شَلّ. يٍ نَشَ تِ، عَ شْرْشْ. ");
INSERT INTO susa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","عِسِرَيِلَ يَشُي عَ قَلَ نّ، ‹ﭑ بِرَ مَ نّ عٍ قْشْ رَ، هَن ﭑ عٍ لِ، ﭑ عٍ هَرِفٍ تٌنفٌمَ نّ، هَن ﭑ وَ سَ. ﭑ عٍ سْنتْمَ نّ ﭑ مَ سَنتِدّفّمَ رَ.› ");
INSERT INTO susa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","كْنْ عِ تَن نَشَ قٌيٍ رَ مِنِ، بَا نَشَ عٍ رَدُلَ. عٍ نَشَ فٌرٌ يٍ شْورَ عَلْ يْشُي. ");
INSERT INTO susa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","عَلَتَلَ، عِ مَنِيّ مُ نَ عَدَ مَ شَ عَلَيٍ يَ مَ. عِ شَ سّنِيّنيِ قِيشّ، عِ شَ نْرّ فبٌ، عِ شَ كَابَنَكٌي وُيَ. عِ مَنِيّ نَ مِندٍن؟ ");
INSERT INTO susa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","عِ تٌ عِ سّنبّ رَ مِنِ، بْشِ نَشَ عٍ فٍرُن. ");
INSERT INTO susa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","عِ شَ حَمَ نَشَن شُن سَرَشِ، عِ قَمَ عٍ شُن تِدٍ عِ شَ شَنُنتٍيَ رَ، نَشَن مُ حْنمَ عَبَدَن. عِ قَمَ عٍ شُن تِدٍ عِ شَ لِنفِرَ سّنِيّنشِ يِرٍ عِ سّنبّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","حَمَنّ فبّتّيٍ نَ نَ مّ، عٍ فَاشُمَ نّ. قِلِسِتَكَيٍ بْحّ مِنِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","عٍدٌن يَرٍرَتِيٍ عِقُمَ نّ، مٌوَبَ مَنفّيٍ سّرّنمَ نّ. لِمَنِيَ بِرِن بَمَ نّ كَنَان حَمَنّ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","عَلَتَلَ، فَاشُي نُن كْنتْقِلِ عٍ سُشُمَ نّ، عٍ دّ بَلَنمَ نّ عِ سّنبّ رَ، هَن عِ شَ حَمَ دَنفِ، عِ نَشَن شُن سَرَشِ. ");
INSERT INTO susa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","عِ قَمَ نّ عِ شَ حَمَ رَ سَبَتِدٍ عِ شَ فٍيَ قَرِ، عِ دّننَشّ سُفَندِشِ عِ شَ لِنفِرَ سّنِيّنشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","عَلَتَلَ شَ مَنفّيَ بُمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","قِرَوُنَ شَ سٌي، عَ شَ سْورِ رَفِسٍيٍ، نُن عَ شَ سٌي رَفِمَيٍ تٌ فٌرٌ بَا مَ، عَلَتَلَ نَشَ بَا رَدِن عٍ شُن مَ، كْنْ عِسِرَيِلَكَيٍ نَشَ دَنفِ كِرَ شَرَشِ رَ بَا تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","هَرُنَ مَافِنّ مَرِيَمَ، نَشَن قِندِشِ نَمِحْنمّ فِنّ رَ، عَ نَشَ بٌوتٍ مَشَ. فِنّ فبّتّيٍ نَشَ قَرٍ بٌرٌن. ");
INSERT INTO susa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","مَرِيَمَ نَشَ يِ بّيتِ بَ، «وٌ بّيتِ بَ عَلَتَلَ بّ، بَرِ مَ عَ شِلِ فبٌ. عَ بَرَ سٌي نُن عٍ رَفِمَيٍ رَدُلَ بَا مَ.» ");
INSERT INTO susa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","مُنسَ نَشَ عِسِرَيِلَكَيٍ شُن تِ سُرُ فبٍنفبٍرٍنيِ رَكٍلِقٍ شُلُنيُمِ بَا دّ رَ. عٍ نَشَ عٍ حّرّ شِ سَشَن فبٍنفبٍرٍنيِ مَ، عٍ مُ يٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","عٍ نَشَ مَرَ لِ، كْنْ عٍ مُ نْ مَرَ يٍ مِندٍ بَرِ مَ نَ يٍ نُ شْنْ. «مَرَ» وَ مَ «شْنّ» نَن قَلَقٍ. ");
INSERT INTO susa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","حَمَ نَشَ سْنشْ مُنسَ مَ، «وٌن يٍ سْتْمَ مِندٍن؟» ");
INSERT INTO susa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","مُنسَ نَشَ عَ دّ رَوَ عَلَتَلَ شْن مَ. عَلَتَلَ نَشَ وُرِ مْولِ ندٍ مَسٍن مُنسَ بّ، عَ قَ نَ وٌلِ يٍ شْورَ، يٍ شْنّ نَشَ بَ. عَلَتَلَ تٌ فّ عٍ شَشِلِ مَتٌدٍ مّننِ، عَ نَشَ يِ سَاتّ تٌنفٌ عٍ بّ، ");
INSERT INTO susa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«شَ وٌ وٌ تُلِ مَتِ ﭑ شُي رَ عَ قَنيِ رَ، شَ وٌ بِرَ ﭑ مَ تِنشِنيِ قْشْ رَ، شَ وٌ ﭑ مَ يَامَرِ بِرِن سُشُ، وٌ ﭑ مَ سّرِيّ بِرِن بِنيَ، ﭑ تَن، وٌ مَرِفِ عَلَتَلَ، ﭑ مُ قُرٍ حَاشِ يٌ رَفٌرٌ مَ وٌ مَ، عَلْ ﭑ نَشَن نَفٌرٌ مِسِرَكَيٍ مَ. ﭑ تَن نَن عَلَتَلَ رَ، نَشَن وٌ رَيَلَنمَ.» ");
INSERT INTO susa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","عٍ تٌ دُلٌنيِ قُ نُن قِرِن نُن تُفِ بِلِ تٌنفٌ سٌلٌقٍرٍ لِ عٍلِمِ، عٍ نَشَ يٌنكِن مّننِ. ");
INSERT INTO susa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","عِسِرَيِلَ حَمَ بِرِن نَشَ كٍلِ عٍلِمِ، سِفَقٍ رَ سِنِ فبٍنفبٍرٍنيِ مَ، نَشَن نَ عٍلِمِ نُن تُرُ سِنِنَ تَفِ. عٍ بِيَاسِ نَشَن نَبَ كٍلِ مِسِرَ هَن سِنِ فبٍنفبٍرٍنيِ مَ، نَ نَشَ بُ كِكٍ قِرِن عَ نُن شِ قُ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","مّننِ عِسِرَيِلَ حَمَ نَشَ سْنشْ مُنسَ نُن هَرُنَ مَ، ");
INSERT INTO susa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","عَ قَلَقٍ رَ، «مُنقٍ رَ عَلَتَلَ مُ عَ رَفِرِشِ وٌن شَ قَشَ مِسِرَ بْشِ مَ؟ مّننِ سُبٍ نُن تَامِ نُ نَ وٌن يِ رَ نَشَن وٌن لُفَمَ، كْنْ بٍ يِ فبٍنفبٍرٍن يِرٍ، وٌن قَمَ قَشَدٍ كَامّ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «ﭑ قَمَ تَامِ رَفٌرٌدٍ وٌ بّ كٍلِقٍ كٌورٍ مَ. حَمَ شَ مِنِ، عٍ شَ عَ مَتٌنفٌ فّيسّفّ عٍ نَشَن دٌنمَ لْشْي كٍرٍن كُي. ﭑ قَمَ عٍ شَشِلِ مَتٌدٍ، شَ عٍ حّرّ مَ ﭑ مَ يَامَرِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","عَ شِ سٍننِ ندٍ، عٍ شَ شِ قِرِن دَاشِ مَتٌنفٌ.» ");
INSERT INTO susa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","مُنسَ نُن هَرُنَ نَشَ عَ قَلَ عِسِرَيِلَ حَمَ بّ، «تٌ نُنمَرٍ وٌ عَ كٌلٌنمَ نّ، عَ عَلَتَلَ نَن وٌ رَ مِنِشِ مِسِرَ بْشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","تِنَ فّيسّفّ، وٌ قَمَ عَلَتَلَ شَ كَابَنَكٌ تٌدٍ. عَ بَرَ وٌ شَ سْنشْي مّ. مُنقٍ رَ وٌ وَ مَ سْنشْقٍ مُشُ تَن مَ؟ ");
INSERT INTO susa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","تٌ نُنمَرٍ عَلَتَلَ وٌ كِمَ سُبٍ رَ، فّيسّفّ عَ وٌ كِمَ تَامِ رَ، هَن وٌ لُفَ. وٌ مُ سْنشْشِ مُشُ تَن شَ مَ دٍ. وٌ سْنشْشِ عَلَتَلَ نَن مَ، نَشَن بَرَ وٌ شُي بِرِن مّ.» ");
INSERT INTO susa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","مُنسَ نَشَ عَ قَلَ هَرُنَ بّ، «عَ قَلَ عِسِرَيِلَ حَمَ بّ، عٍ شَ عٍ يّتّ مَسٍن عَلَتَلَ بّ، بَرِ مَ عَ بَرَ عٍ شَ سْنشْي مّ.» ");
INSERT INTO susa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","هَرُنَ نُ وْيّنقٍ عِسِرَيِلَ حَمَ بّ تّمُي نَشّ، عٍ نَشَ عٍ يَ رَقِندِ فبٍنفبٍرٍنيِ مَ، عٍ قَ عَلَتَلَ شَ نْرّ تٌ مِنِ رَ نُشُي كُي. ");
INSERT INTO susa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«ﭑ بَرَ عِسِرَيِلَكَيٍ شَ سْنشْي مّ. عَ قَلَ عٍ بّ، ‹نُنمَرٍ وٌ سُبٍ دٌنمَ، فّيسّفّ وٌ لُفَمَ تَامِ رَ. نَ كُي وٌ عَ كٌلٌنمَ نّ، عَ ﭑ تَن نَن نَ وٌ مَرِفِ عَلَتَلَ رَ.›» ");
INSERT INTO susa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","نُنمَرٍ يَتِ شْنِيٍ نَشٍيٍ شِلِ كْنكْلّيٍ نَشَ رَدِن عٍ يٌنكِندٍ بِرِن مَ. نَ كُيٍ عِبَ شِنِ نَشَ لُ عٍ يٌنكِندٍ رَبِلِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","نَ شِنِ تٌ بَ نَ، سٍ ندٍ نَشَ لُ بْشِ قَرِ عَلْ بَلَبَلَنيِ. ");
INSERT INTO susa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","عِسِرَيِلَكَيٍ تٌ نَ تٌ، عٍ نَشَ عٍ بٌورٍ مَشْرِن، «مُنسٍ يَ؟» عٍ مُ عَ كٌلٌن سٍ يٌ نَ كِ. مُنسَ نَشَ عَ قَلَ عٍ بّ، «تَامِ نَن عَ رَ، عَلَتَلَ نَشَن قِشِ وٌ مَ بَلٌي رَ.» ");
INSERT INTO susa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","عَلَتَلَ شَ يَامَرِ نَن يَ، «وٌ شَ سِفَاتِ يَ سٌلٌقٍرٍ تٌنفٌ مِشِ بِرِن بّ نَشَن نَ وٌ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","عِسِرَيِلَكَيٍ عَ رَبَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","عٍ تٌ عَ مَنِيَ، نَشٍيٍ فبٍ نُ فبٌشِ، عَ مُ دَنفِ يّ، نَشٍيٍ قَن فبٍ نُ شُرُنشِ، عَ عٍ رَلِشِ نّ. كَنكَن نَشَ بَلٌي شَسَبِ سْتْ نَشَن عَ رَلِمَ. ");
INSERT INTO susa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","مُنسَ نَشَ عَ قَلَ عٍ بّ، «يِ بَلٌي نَشَ رَشِ هَن فّيسّفّ.» ");
INSERT INTO susa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","كْنْ ندٍيٍ مُ مُنسَ شُي سُشُ، عٍ نَشَ عَ رَفَتَ هَن فّيسّفّ. كُلِيٍ نَشَ بِرَ عَ عِ، عَ شِرِ حَاشِ نَشَ مِنِ. مُنسَ نَشَ شْنْ نَ كَنيِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","فّيسّفّ يٌ فّيسّفّ، كَنكَن نُ قَ عَ فبٍ دٌنسٍ مَتٌنفٌ، كْنْ سٌفٍ نَ تٍ، عَ دْنشْي نَشَن لُشِ، نَ شُنُ عَ عِ. ");
INSERT INTO susa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","عَ شِ سٍننِ ندٍ، عٍ نَشَ شِ قِرِن دَاشِ مَتٌنفٌ، سِفَاتِ يَ قُ نُن نَانِ مِشِ كٍرٍن بّ. يَرٍرَتِيٍ نَشَ نَ دّنتّفّ سَ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","مُنسَ نَشَ عَ قَلَ عٍ بّ، «عَلَتَلَ نَشّ عَ تِنَ مَلَبُي لْشْي نَن عَ رَ، لْشْي سّنِيّنشِ عَلَتَلَ بّ. وٌ شَ ندٍ فَن، وٌ شَ ندٍ سَتُن. عَ دْنشْي نَشَن نَ لُ، وٌ شَ نَ رَفَتَ هَن تِنَ فّيسّفّ.» ");
INSERT INTO susa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","عٍ تٌ ندٍ رَفَتَ هَن فّيسّفّ، عَلْ مُنسَ عَ يَمَرِ عٍ بّ كِ نَشّ، عٍ نَشَ عَ تٌ كُلِ مُ بِرَشِ عَ عِ، عَ مَن مُ بْرْ. ");
INSERT INTO susa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","مُنسَ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ عَ دٌن تٌ، بَرِ مَ تٌ نَن مَلَبُي لْشْي رَ عَلَتَلَ شَ بِنيّ بُن مَ. نَ دٌنسٍ مُ فٌرٌ مَ بْشِ مَ تٌ. ");
INSERT INTO susa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","وٌ شَ عَ مَتٌنفٌ شِ سٍننِ بُن مَ، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ، وٌ مُ سٍسٍ تٌمَ، بَرِ مَ مَلَبُي لْشْي نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","عَ شِ سٌلٌقٍرٍ ندٍ، مِشِ ندٍيٍ مِنِ نّ نَ دٌنسٍ مَتٌنفٌدٍ، كْنْ عٍ مُ سٍسٍ تٌ. ");
INSERT INTO susa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","نَ كُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «وٌ ﭑ مَ يَامَرِ نُن ﭑ مَ سّرِيّ مَتَندِ مَ هَن مُن تّمُي؟ ");
INSERT INTO susa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","وٌ شَ عَ كٌلٌن، ﭑ تَن عَلَتَلَ نَن مَلَبُي لْشْي سّرِيّ مَسٍنشِ وٌ بّ. نَ نَن عَ رَ، شِ سٍننِ ندٍ وٌ دٌنسٍ شِ قِرِن دَاشِ سْتْمَ. عَ سٌلٌقٍرٍ ندٍ وٌ نَشَ سِفَ دّدّ، وٌ بِرِن شَ لُ وٌ شْنيِيٍ، مَلَبُي لْشْي نَن عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","نَ كُي حَمَ نَشَ عٍ مَلَبُ نَ لْشْي سٌلٌقٍرٍ ندٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","عِسِرَيِلَكَيٍ نَشَ نَ دٌنسٍ شِلِ قَلَ «مَنَ،» نَشَن نُ وَ مَ عَ قَلَقٍ، «مُنسٍ عَ رَ؟» عَ مَنِيَ قُندٍن شْرِ رَ، عَ قِيشّ، عَ حْشُن عَلْ دِفِيَنيِ. ");
INSERT INTO susa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","مُنسَ نَشَ عَ قَلَ، «عَلَتَلَ شَ يَامَرِ نَن يِ كِ، ‹وٌ شَ يِ مَنَ سِفَاتِ يَ سٌلٌقٍرٍ رَفَتَ، عَلَكٌ وٌ بْنسْي نَشٍيٍ قَمَ بَرِدٍ عٍ شَ دٌنسٍ تٌ ﭑ نَشَن نَفٌرٌشِ وٌ مَ فبٍنفبٍرٍنيِ مَ، ﭑ تٌ وٌ رَ مِنِ مِسِرَ بْشِ رَ.›» ");
INSERT INTO susa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","نَ كُي مُنسَ نَشَ عَ قَلَ هَرُنَ بّ، «عِ شَ مَنَ سِفَاتِ يَ سٌلٌقٍرٍ سَ سٍسَسٍ كُي، عِ شَ عَ دْشْ هْرْ مْلِنفِرَ يِرٍ، عَلَكٌ عَ شَ قِندِ تْنشُمَ رَ وٌ بْنسْييٍ بّ نَشٍيٍ قَمَ بَرِدٍ.» ");
INSERT INTO susa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","هَرُنَ نَشَ نَ سٍسَسٍ دْشْ عَلَتَلَ شَ هْرْ مْلِنفِرَ يِرٍ سَاتّ كَنكِرَ يَ رَ، عَلَكٌ عَ شَ رَفَتَ عَلْ عَلَتَلَ عَ مَسٍنشِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","عِسِرَيِلَكَيٍ مَنَ دٌن نّ حّ تٌنفٌ نَانِ بُن مَ، هَن عٍ سَ سٌ كَنَان بْشِ مَ، سِ فبّتّيٍ سَبَتِشِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","نَ سِفَاتِ يَ سٌلٌقٍرٍ نَشَن نُ رَوَلِمَ نَ مَنَ مَنِيَقٍ رَ، عَ دْشْ قُ قِندِشِ بُسَلِ كٍرٍن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","عِسِرَيِلَ حَمَ بِرِن نَشَ كٍلِ سِنِ فبٍنفبٍرٍنيِ مَ، عٍ قَ بِيَاسِ رَبَ عَلْ عَلَتَلَ نُ لُمَ عٍ يَمَرِ رَ كِ نَشّ. عٍ تٌ رٍقِدِ مِ لِ، عٍ نَشَ يٌنكِن نَا، كْنْ عٍ مُ يٍ مِن دَاشِ سْتْ. ");
INSERT INTO susa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","حَمَ نَشَ تِ مُنسَ كَنكٍ، عٍ عَ قَلَ عَ بّ، «يٍ سٌ مُشُ يِ رَ.» مُنسَ نَشَ وْيّن عٍ بّ، «وٌ تِمَ ﭑ كَنكٍ مُنقٍ رَ؟ وٌ نَ عَلَتَلَ مَتٌقٍ مُنقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","يٍ شْلِ نُ بَرَ فبَا حَمَ رَ، عٍ نُ قَ عَ قَلَ مُنسَ بّ، «مُنقٍ رَ عِ مُشُ رَ مِنِشِ مِسِرَ بْشِ رَ؟ عِ وَ مَ نّ مُشُ شَ دٍنبَيَ نُن مُشُ شَ شُرُ سٍيٍ شَ قَشَ يٍ شْلِ رَ فبٍنفبٍرٍنيِ مَ؟» ");
INSERT INTO susa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","مُنسَ نَشَ عَ دّ رَوَ عَلَتَلَ شْن مَ، عَ قَلَقٍ رَ، «ﭑ نْمَ مُنسٍ رَبَدٍ يِ حَمَ رَ؟ عَ فبٍ مُ لُشِ عٍ شَ ﭑ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","عَلَتَلَ نَشَ مُنسَ يَابِ، «عِ شَ دَنفِ حَمَ يَ رَ، عَ نُن عِسِرَيِلَ قٌرِ ندٍيٍ. عِ شَ عِ شَ يِسُشُوُرِ تٌنفٌ، عِ نِلِ شُرٍ فَرِن نَشَن نَ، عِ تِ عٍ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ﭑ تِمَ عِ يَ رَ، قَنيٍ سّيتِ مَ، نَشَن نَ شٌرٍبٍ فٍيَ يِرٍ. عِ شَ نَ قَنيٍ فَرِن. نَ كُي يٍ مِنِمَ نّ حَمَ نَشَن مِنمَ.» مُنسَ نَشَ عَ رَبَ نَ كِ عِسِرَيِلَ قٌرِيٍ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","عَ نَشَ نَ يِرٍ شِلِ سَ مَسَ نُن مٍرِبَ، نَ نَن نَ كِ «مَتٌي نُن سْنشْي،» بَرِ مَ عِسِرَيِلَكَيٍ سْنشْ نّ مُنسَ مَ مّننِ، عٍ مَن نَشَ عَلَتَلَ مَتٌ نَ عَ قَلَقٍ رَ، «عَلَتَلَ نَ وٌن تَفِ بَ، كَ عَ مُ وٌن تَفِ؟» ");
INSERT INTO susa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","عَمَلّكِكَيٍ نَشَ قَ عِسِرَيِلَ فٍرٍدٍ رٍقِدِ مِ. ");
INSERT INTO susa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","مُنسَ نَشَ عَ قَلَ يٌسُوٍ بّ، «شّمّ ندٍيٍ مَيٍفٍتِ، وٌ قَ مِنِ عَمَلّكِكَيٍ فٍرٍدٍ. تِنَ، ﭑ تِمَ نّ فٍيَ قَرِ عَلَ شَ يِسُشُوُرِ رَ ﭑ يِ.» ");
INSERT INTO susa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","يٌسُوٍ نَشَ عَمَلّكِكَيٍ فٍرٍ عَلْ مُنسَ عَ يَمَرِشِ كِ نَشّ. مُنسَ، هَرُنَ، نُن شُرُ نَشَ تٍ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","مُنسَ تٌ عَ بّلّشّ عِتٍمَ، عِسِرَيِلَ سّنبّ نُ فبٌمَ، كْنْ عَ تٌ عَ بّلّشّ عِفٌرٌ مَ، عَمَلّكِكَيٍ سّنبّ تَن نُ فبٌمَ. ");
INSERT INTO susa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","مُنسَ بّلّشّيٍ تٌ بِنيَ عَ رَ، عٍ نَشَ فّمّ ندٍ تٌنفٌ عَ دْشْمَ نَشَن قَرِ. هَرُنَ نُن شُرُ نَشَ لُ مُنسَ سّيتِ مَ، عَ كْولَ نُن عَ يِرٍقَنيِ مَ، عَ بّلّشّ رَتٍقٍ رَ هَن سٌفٍ دُلَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","نَ كُي يٌسُوٍ نَشَ نْ عَمَلّكِ نُن عَ شَ سْورِيٍ رَ سَنتِدّفّمَ شّحّنشِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «يِ تَرُشُي سّبّ عَلَكٌ حَمَ شَ رَتُ عَ مَ. عِ مَن شَ عَ قَلَ يٌسُوٍ بّ، ‹ﭑ قَمَ نّ عَمَلّكِكَيٍ شَ قٍ حْندٍ يِ دُنِحَ مَ.›» ");
INSERT INTO susa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","مُنسَ نَشَ يِرٍ ندٍ رَقَلَ سّرّشّبَدٍ رَ، عَ نَشَ نَ يِرٍ شِلِ سَ، «عَلَتَلَ نَن شُن نَكٍلِ قِمَ ﭑ مَ،» ");
INSERT INTO susa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","بَرِ مَ عَ نُ بَرَ عَ شَشِلِ تِ عَلَتَلَ شَ مَنفّيَ رَ. مُنسَ نَشَ عَ عَ قَلَ، «عَلَتَلَ عَمَلّكِكَيٍ فٍرٍ مَ نّ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","مُنسَ بِتَنيِ يٍتِرٌ، نَشَن قِندِشِ مَدِيَن سّرّشّدُبّ رَ، عَ نَشَ عَ مّ عَلَتَلَ نَشَن نَبَشِ مُنسَ نُن عَ شَ حَمَ عِسِرَيِلَ بّ، عٍ رَ مِنِقٍ رَ مِسِرَ بْشِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","مُنسَ نُ بَرَ عَ شَ فِنّ سِثٌرَ نُن عَ شَ دِ قِرِنيِ شّي يٍتِرٌ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","مُنسَ شَ دِ سِنفٍ نُ شِلِ فٍرِ سٌمِ، بَرِ مَ نَ شِلِ نُ وَ مَ عَ قَلَقٍ عٍ فبٍ شُي، «شْحّ نَن ﭑ نَ يِ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","بٌورٍ نُ شِلِ عٍلِيٍسٍرِ، بَرِ مَ نَ شِلِ نُ وَ مَ عَ قَلَقٍ عٍ فبٍ شُي، «ﭑ بَبَ مَرِفِ بَرَ ﭑ مَلِ، عَ بَرَ ﭑ نَتَنفَ قِرَوُنَ شَ سَنتِدّفّمَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","مُنسَ بِتَنيِ يٍتِرٌ نَشَ مُنسَ شَ فِنّ نُن نَ شَ دِيٍ شَنِن مُنسَ يِرٍ فبٍنفبٍرٍنيِ مَ، عَ نُ يٌنكِنشِ دّننَشّ، عَلَ شَ فٍيَ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","يٍتِرٌ نُ بَرَ شّيرَ شّي مُنسَ شْن عَ قَلَقٍ رَ، «ﭑ تَن، عِ بِتَنيِ يٍتِرٌ، ﭑ نَ قَقٍ عِ شَ فِنّ نُن عَ شَ دِ قِرِنيِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","مُنسَ نَشَ مِنِ عَ بِتَنيِ رَلَندٍ. عَ نَشَ عَ شِنبِ سِن عَ يَ رَ، عَ مَن قَ عَ سُنبُ. عٍ تٌ عٍ بٌورٍ شّيبُ، عٍ نَشَ سٌ مُنسَ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","مُنسَ نَشَ قٍيٍ يَ بَ عَ بِتَنيِ بّ، عَلَتَلَ نَشَن بِرِن نَبَ قِرَوُنَ نُن مِسِرَكَيٍ رَ عِسِرَيِلَ شَ قٍ رَ. عَ نَشَ عِسِرَيِلَ شَ حَشَنكَتّ بِرِن قَلَ عَ بّ، عَ نُن عَلَتَلَ عٍ رَكِسِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","يٍتِرٌ نَشَ سّيوَ عَلَتَلَ شَ هِننّ رَ عَ نَشَن مَسٍنشِ عِسِرَيِلَ بّ، عَ عٍ بَقٍ رَ مِسِرَكَيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","يٍتِرٌ نَشَ عَ قَلَ، «تَنتُي نَ عَلَتَلَ بّ، نَشَن وٌ بَ مِسِرَكَيٍ نُن قِرَوُنَ يِ رَ، نَشَن عِسِرَيِلَ حَمَ رَ مِنِشِ عٍ شَ نْي بُن مَ! ");
INSERT INTO susa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ﭑ بَرَ عَ كٌلٌن عَلَتَلَ سّنبّ فبٌ دَنفِ عَدَ مَدِيٍ شَ عَلَيٍ مْولِ بِرِن نَ، بَرِ مَ عَ بَرَ حَمَ عِفٌرٌ نَشَن نُ بَرَ عَ يّتّ رَقِسَ عِسِرَيِلَكَيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","نَ تّمُي مُنسَ بِتَنيِ يٍتِرٌ نَشَ سّرّشّ فَن دَاشِ نُن سّرّشّ فبّتّيٍ بَ عَلَتَلَ بّ. هَرُنَ نُن عِسِرَيِلَ قٌرِ بِرِن نَشَ نَ سّرّشّ دٌن مُنسَ بِتَنيِ يِرٍ عَلَتَلَ شَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","نَ كُيٍ عِبَ، مُنسَ نَشَ عَ مَفٌرٌ، عَ شَ كِيتِ سَ عِسِرَيِلَكَيٍ تَفِ. حَمَ نَشَ لُ عَ يِرٍ كٍلِقٍ فّيسّفّ هَن نُنمَرٍ. ");
INSERT INTO susa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","عَ بِتَنيِ تٌ عَ تٌ مُنسَ نَشَن بِرِن نَبَمَ حَمَ بّ، عَ نَشَ عَ قَلَ عَ بّ، «عِ نَ مُنسٍ رَبَقٍ يِ حَمَ بّ؟ مُنقٍ رَ كِيتِ وَلِ بِرِن دْشْشِ عِ كٍرٍن نَن شُن مَ كٍلِقٍ فّيسّفّ هَن نُنمَرٍ؟» ");
INSERT INTO susa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","مُنسَ نَشَ عَ بِتَنيِ يَابِ، «حَمَ قَشِ ﭑ يِرٍ عَلَتَلَ شَ كِيتِ نَن قٍندٍ. ");
INSERT INTO susa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","فَلَنبُي نَ لُ مِشِيٍ تَفِ عٍ قَمَ ﭑ يِرٍ ﭑ شَ كِيتِ سَ عَلَتَلَ شَ يَامَرِيٍ نُن عَ شَ سّرِيّ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","مُنسَ بِتَنيِ نَشَ عَ قَلَ عَ بّ، «عَ مُ لَنمَ عِ شَ عَ رَبَ نَ كِ.» ");
INSERT INTO susa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","عِ نُن عِ شَ مِشِيٍ، وٌ تَفَنمَ نّ. عِ كٍرٍن مُ نْمَ يِ كٌتٍ شَنِندٍ. ");
INSERT INTO susa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","عِ شَ عِ تُلِ مَتِ ﭑ مَ مَرَ سِ رَ. عَلَ شَ عِ مَلِ. عِ تَن شَ قِندِ حَمَ شُي مَدَنفِمَ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","عِ لَن نّ عِ شَ عٍ شَرَن عَلَتَلَ شَ سّرِيّ نُن عَ شَ يَامَرِيٍ رَ. عِ شَ عَلَ شَ كِرَ مَسٍن عٍ بّ، عٍ بِرَ مَ نَشَن قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","مِشِ كّندّيٍ سُفَندِ حَمَ يَ مَ، نْندِ قَلّ نَشٍيٍ فَاشُمَ عَلَتَلَ يَ رَ، نَشٍيٍ رِبَ شْنشِ. عِ شَ نٍيٍ قِندِ يَرٍرَتِيٍ رَ حَمَ شُن مَ شُنلَندٍ كِ مَ. ندٍ شَ لُ مِشِ وُلُ كٍرٍن شُن مَ، بٌورٍ مِشِ كّمّ شُن مَ، بٌورٍ مِشِ تٌنفٌ سُولِ شُن مَ، بٌورٍ مِشِ قُ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","نٍيٍ شَ كِيتِ بِرِن سَ مِشِيٍ تَفِ، قٌ كِيتِ ندٍ نَشٍيٍ شْرْشْ. عٍ شَ نَ كِيتِ شْرْشْي مَسٍن عِ تَن بّ. نَ كِ، كٌتٍ مُ دْشْمَ عِ كٍرٍن شُن. ");
INSERT INTO susa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","شَ عِ عَلَ شُي سُشُمَ، نَ رَبَقٍ نْمَ قِندِدٍ سْونّيَ رَ وٌ بِرِن بّ، بْحّسَ قَ لُ حَمَ بّ عٍ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","مُنسَ نَشَ عَ بِتَنيِ شُي سُشُ، عَ بِرِن نَشَ رَبَ عَلْ عَ قَلَشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","مُنسَ نَشَ مِشِ كّندّيٍ سُفَندِ عِسِرَيِلَكَيٍ يَ مَ، عَ قَ عٍ دْشْ حَمَ شُن نَ شُنلَندٍ كِ مَ، مِشِ وُلُ كٍرٍن شُن مَ، مِشِ كّمّ شُن مَ، مِشِ تٌنفٌ سُولِ شُن مَ، نُن مِشِ قُ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","عٍ نُ كِيتِسَ وَلِ رَبَ تّمُي بِرِن، قٌ كِيتِ شْرْشْي عٍ نٍيٍ نَن مَسٍنمَ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","نَ تّمُي مُنسَ نَشَ عَ بِتَنيِ بّحِن. يٍتِرٌ نَشَ فبِلٍن عَ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","كِكٍ سَشَن يَتِ تٌ دَنفِ، كٍلِقٍ عٍ مِنِ مِسِرَ بْشِ رَ تّمُي نَشّ، عِسِرَيِلَكَيٍ نَشَ سٌ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","عٍ تٌ كٍلِ رٍقِدِ مِ، عٍ نَشَ سٌ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ، عٍ يٌنكِن فٍيَ يَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","مُنسَ نَشَ تٍ فٍيَ قَرِ سِفَقٍ عَلَتَلَ يِرٍ. عَلَتَلَ نَشَ عَ شِلِ فٍيَ قَرِ، عَ عَ مَسٍن عَ بّ، «عِ شَ عَ قَلَ عِسِرَيِلَكَيٍ يَشُبَ بْنسْي بّ، ");
INSERT INTO susa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹وٌ بَرَ عَ تٌ، ﭑ قٍ نَشَن نَبَشِ مِسِرَكَيٍ رَ. وٌ بَرَ عَ كٌلٌن ﭑ قَشِ وٌ رَ ﭑ يِرٍ كِ نَشّ. عَ لُشِ عَلْ وٌ بَكِشِ شْنِ نَن قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","شَ وٌ ﭑ شُي سُشُ ﭑ مَ سَاتّ رَكَمَلِقٍ رَ، وٌ قَمَ نّ قِندِدٍ ﭑ مَ حَمَ سُفَندِشِ رَ سِ بِرِن يَ مَ. ﭑ فبٍ نَن دُنِحَ بِرِن نَ، ");
INSERT INTO susa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","كْنْ وٌ تَن قِندِ مَ ﭑ مَ سِ سّنِيّنشِ نَن نَ، نَشَن سّرّشّدُبّ وَلِ رَبَمَ.› عِ شَ نَ مَسٍنيِ تِ عِسِرَيِلَكَيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","مُنسَ نَشَ فٌرٌ، عَ قٌرِ بِرِن شِلِ، عَ قَ عَلَتَلَ شَ مَسٍنيِ بِرِن دّنتّفّ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","حَمَ بِرِن نَشَ عَ قَلَ، «مُشُ عَلَتَلَ شُي بِرِن سُشُمَ نّ.» مُنسَ نَشَ حَمَ شَ يَابِ دّنتّفّ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «ﭑ قَمَ وْيّندٍ عِ بّ نُشُي كُي حَمَ يَ شْرِ، عَلَكٌ عٍ شَ لَنلَنتٍيَ سَ عِ مَ تّمُي بِرِن.» مُنسَ نَشَ حَمَ شَ مَسٍنيِ دّنتّفّ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عَ قَلَ حَمَ بّ، عٍ شَ عٍ يّتّ رَ سّنِيّن تٌ نُن تِنَ. عٍ شَ عٍ شَ دُفِيٍ قَن شَ. ");
INSERT INTO susa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","عٍ شَ رّدِ تِنَ بٌرَ يَ رَ، بَرِ مَ ﭑ قَمَ نّ فٌرٌدٍ حَمَ بِرِن يَ تٌدٍ رَ نَ لْشْي تُرُ سِنِنَ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","عِ شَ نَانِنيِ سَ فٍيَ رَبِلِنيِ بِرِن مَ، عِ قَ عَ قَلَ حَمَ بّ، ‹مِشِ يٌ نَشَ تٍ فٍيَ قَرِ، مِشِ يٌ نَشَ عَ مَكْرّ عَ رَ، بَرِ مَ نَشَن يٌ دِن عَ رَ، نَ كَنيِ قَشَمَ نّ.› ");
INSERT INTO susa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","وٌ نَشَ وٌ بّلّشّ دِن نَ كَنيِ رَ، وٌ عَ مَفْنْ فّمّ رَ هَن عَ قَشَ. شَ نَ مُ، وٌ شَ عَ مَسْشْ شَلِيٍ رَ. عَ قِندِ دَالِسٍ رَ، عَ قِندِ مِشِ رَ، عَ لَنمَ عَ شَ قَشَ. مِشِ مُ لَنمَ عَ شَ تٍ فٍيَ قَرِ، قٌ سَرَ شُي نَ مِنِ مِشِ سُفَندِشِ ندٍيٍ قَ تٍ.» ");
INSERT INTO susa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","مُنسَ تٌ فٌرٌ فٍيَ مَ حَمَ يِرٍ، عَ نَشَ مَرَ سّنِيّنيِ قٍ قَلَ عٍ بّ، عٍ شَ عٍ يّتّ نُن عٍ شَ دُفِيٍ رَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","عَ نَشَ عَ قَلَ حَمَ بّ، «وٌ شَ وٌ يّتّ يَءِلَن تِنَ بٌرَ يَ رَ. سَدٍ قٍ نَشَ لُ وٌ تَن نُن وٌ شَ فِنّيٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","عَ شِ سَشَن لْشْي، فَلَنيِ نُن سٍيَمَكْنيِ نَشَ بِرَ بْشِ مَ فّيسّفّ، نُشُي عِقْورْشِ نَشَ تٌ فٍيَ مَ. سَرَ شُي نَشَ مِنِ سّنبّ رَ. حَمَ بِرِن نَشَ فَاشُ. ");
INSERT INTO susa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","مُنسَ نَشَ حَمَ مَتِ فٍيَ لَنبَنيِ عَلَ شُي رَ مّدٍ. ");
INSERT INTO susa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","تُورِ نُ نَ تُرُ سِنِنَ فٍيَ مَ، بَرِ مَ عَلَتَلَ نُ بَرَ فٌرٌ تّ تَفِ. نَ تُورِ نُ تٍمَ نّ، عَلْ قِيلِ نَ فَن. فٍيَ نُ سّرّنمَ سّنبّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","سَرَ شُي نُ سِفَمَ فبٌ رَ. نَ تّمُي مُنسَ نَشَ وْيّن، عَلَ نَشَ عَ يَابِ. ");
INSERT INTO susa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","عَلَتَلَ نَشَ فٌرٌ تُرُ سِنِنَ فٍيَ قَرِ، عَ قَ مُنسَ شِلِ. مُنسَ تٌ تٍ نَا، ");
INSERT INTO susa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «عِ شَ فٌرٌ، عِ شَ عَ قَلَ حَمَ بّ، عٍ نَشَ وُرُنتُن ﭑ تٌقٍ رَ دٍ، شَ نَ مُ عَ رَ، عَ فبٍفبٍ قَشَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","هَلِ سّرّشّدُبّ نَشٍيٍ عٍ مَكْرّ مَ ﭑ نَ، عٍ شَ عٍ يّتّ رَ سّنِيّن، عَلَكٌ ﭑ نَشَ قَ عٍ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","مُنسَ نَشَ عَ قَلَ عَلَتَلَ بّ، «حَمَ مُ نْمَ تِدٍ تُرُ سِنِنَ فٍيَ قَرِ، بَرِ مَ عِ حَن بَرَ مُشُ يَمَرِ نَانِنيِيٍ شَ سَ فٍيَ رَبِلِنيِ مَ، حَمَ شَ لُ عٍ شَتِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «عِ شَ فٌرٌ سِندٍن هَرُنَ قْشْ رَ. نَ تّمُي وٌ قِرِن شَ تٍ. سّرّشّدُبّيٍ نُن حَمَ نَشَ تٍ دٍ، شَ نَ مُ عَ رَ، عٍ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","مُنسَ نَشَ فٌرٌ حَمَ يِرٍ، عَ قَ نَ مَسٍنيِ تِ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","نَ تّمُي عَلَتَلَ نَشَ يِ مَسٍنيِ تِ؛ ");
INSERT INTO susa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«ﭑ تَن عَلَتَلَ نَن وٌ مَرِفِ عَلَ رَ، نَشَن وٌ رَ مِنِ مِسِرَ كٌنيِيَ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«وٌ نَشَ عَلَ فبّتّيٍ بَتُ بَقٍ ﭑ تَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«وٌ نَشَ كُيٍ يٌ يَءِلَن نَشَن مِسَالِشِ سٍ ندٍ رَ، نَشَن تٌمَ كٌورٍ نُن بْشِ مَ، شَ نَ مُ نَشَن لُمَ يٍ نُن بْشِ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","وٌ نَشَ وٌ مَقٍلٍن نَ سٍ مْولِيٍ بّ، وٌ نَشَ عٍ بَتُ، بَرِ مَ ﭑ تَن وٌ مَرِفِ عَلَتَلَ، ﭑ مُ وَ مَ ﭑ قِرِن ندٍ شْن. نَشٍيٍ ﭑ شْنمَ، ﭑ نٍيٍ بْنسْي رَتْنمَ نّ هَن عٍ تٌلٌنتٌلٌنيِيٍ، شَ نَ مُ عَ رَ عٍ تٌلٌبِتّيٍ شَ دِيٍ. ");
INSERT INTO susa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","كْنْ مِشِ نَشٍيٍ ﭑ شَنُمَ، عٍ بِرَ ﭑ مَ سّرِيّ قْشْ رَ، ﭑ هِننّمَ عٍ رَ شَنُنتٍيَ كُي عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«وٌ نَشَ ﭑ شِلِ يٍلٍقُ، بَرِ مَ ﭑ تَن عَلَتَلَ مُ دِحّمَ مِشِيٍ مَ، نَشٍيٍ نَ قٍ مْولِ رَبَمَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«وٌ شَ رَتُ مَلَبُي لْشْي مَ، وٌ شَ عَ بِنيَ. ");
INSERT INTO susa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","وٌ نْمَ وَلِ بِرِن نَبَدٍ شِ سٍننِ بُن مَ، ");
INSERT INTO susa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","كْنْ نَ شِ سٌلٌقٍرٍ ندٍ قِندِ مَ مَلَبُي لْشْي رَ وٌ مَرِفِ عَلَتَلَ شَ بِنيّ بُن مَ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي، وٌ تَن، وٌ شَ دِيٍ، وٌ شَ كٌنيِيٍ، وٌ شَ شُرُ سٍيٍ، نُن وٌ شَ شْحّيٍ. ");
INSERT INTO susa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","عَلَتَلَ دُنِحَ نُن سٍ بِرِن دَا شِ سٍننِ نَن بُن مَ. عَ تٌ فّ نَ رَ عَ نَشَ عَ مَلَبُ عَ شِ سٌلٌقٍرٍ ندٍ. نَ نَن عَ شّيشِ، عَلَتَلَ نَشَ بَرَكّ سَ نَ مَلَبُي لْشْي مَ، عَ قِندِ لْشْي سّنِيّنشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«وٌ شَ وٌ بَبَ نُن وٌ نفَ بِنيَ. نَ كُي وٌ شَ سِمَيَ شْن كُيَمَ نّ بْشِ مَ، وٌ مَرِفِ عَلَتَلَ نَشَن قِمَ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«وٌ نَشَ مِشِ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«وٌ نَشَ يّنّ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«وٌ نَشَ مُحّ تِ.» ");
INSERT INTO susa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«وٌ نَشَ وٌ بٌورٍ تْوحّفّ.» ");
INSERT INTO susa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«وٌ نَشَ مِلَ وٌ بٌورٍ شَ هَرِفٍ مَ، عَلْ عَ شَ بَنشِ، عَ شَ فِنّ، عَ شَ كٌنيِيٍ، عَ شَ نِنفٍ، شَ نَ مُ عَ شَ سٌقَلٍ.» ");
INSERT INTO susa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","حَمَ تٌ نَ فَلَنيِ، سٍيَمَكْنيِ، نُن تُورِ تٌ فٍيَ قَرِ، عٍ قَ سَرَ شُي مّ، عٍ نَشَ سّرّن فَاشُي رَ. عٍ نَشَ مَكُيَ مّننِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","عٍ قَ عَ قَلَ مُنسَ بّ، «عِ تَن شَ وْيّن مُشُ رَ، عَلَتَلَ شُي وٌن قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","مُنسَ نَشَ عَ قَلَ حَمَ بّ، «هَلِ وٌ مُ فَاشُ. عَلَ نَ وٌ مَتٌقٍ، عَلَكٌ وٌ شَ فَاشُ عَ يَ رَ، وٌ شَ يُنُبِ لُ نَ.» ");
INSERT INTO susa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","حَمَ نَشَ لُ يِرٍ مَكُيٍ، كْنْ مُنسَ تَن نَشَ سِفَ نَ نُشُي قْورْشِ يِرٍ عَلَتَلَ نُ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ يِ مَسٍنيِ تِ عِسِرَيِلَكَيٍ بّ، ‹وٌ بَرَ عَ تٌ، ﭑ بَرَ وْيّن وٌ رَ كٍلِقٍ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","وٌ نَشَ كُيٍ يٌ يَءِلَن فبٍتِ نُن شّيمَ رَ نَشَن لُمَ ﭑ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","وٌ شَ سّرّشّبَدٍ يَءِلَن ﭑ بّ بّندّ رَ. وٌ شَ شُرُ سٍيٍ بَ سّرّشّ فَن دَاشِ نُن شَنُنتٍيَ سّرّشّ رَ. وٌ نَ ﭑ شِلِ بِنيَ، ﭑ بَرَكّ سَمَ نّ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","شَ وٌ سَ سّرّشّبَدٍ تِمَ ﭑ بّ فّمّ رَ، وٌ نَشَ عَ تِ فّمّ مَسٌلِشِيٍ رَ، بَرِ مَ نَ عَ نِيَمَ نّ عَ شَ قِندِ سٍ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","وٌ نَشَ ﭑ مَ سّرّشّبَدٍ عِتٍ، شَ نَ مُ عَ رَ سّرّشّدُبّ شَ دٌنمَ كُيٍ بُنيِ مَبَمَ نّ.›» ");
INSERT INTO susa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","عِ شَ يِ يَامَرِيٍ مَسٍن عِسِرَيِلَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","شَ وٌ كٌنيِ سَرَ نَشَن قِندِ عِسِرَيِلَكَ رَ، عَ شَ وَلِ وٌ بّ حّ سٍننِ، كْنْ عَ سٌلٌقٍرٍ ندٍ وٌ شَ عَ بّحِن بَرِ مَ عَ شُنسَرٍ بَرَ حْن. ");
INSERT INTO susa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","شَ عَ سَ لِ وٌ نُ بَرَ نَ كٌنيِ نُن عَ شَ فِنّ سَرَ، وٌ شَ عٍ قِرِن بِرِن بّحِن حّ سٌلٌقٍرٍ ندٍ. ");
INSERT INTO susa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","شَ كٌنيِ كَنيِ نَن فِنّ سٌ عَ شَ كٌنيِ يِ رَ، عَ قَ دِ بَرِ، نَ فِنّ نُن عَ شَ دِيٍ لُمَ كٌنيِ كَنيِ يِ رَ. شّمّ فبَنسَن نَن بّحِنمَ. ");
INSERT INTO susa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","شَ نَ كٌنيِ قَ عَ قَلَ، «ﭑ مَرِفِ، ﭑ مَ فِنّ، نُن ﭑ مَ دِيٍ رَقَن ﭑ مَ، ﭑ مُ وَ مَ شْرّيَقٍ،» ");
INSERT INTO susa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","عَ مَرِفِ شَ عَ دّنتّفّ عَلَ بّ. نَ تّمُي عَ شَ عَ تُلِ تُنبَ سْشْمّ رَ نَادّ وُرِ مَ. نَ نَن عَ مَسٍنمَ نَ كٌنيِ بَرَ لُ عَ مَرِفِ شَ يَامَرِ بُن مَ عَ شَ دُنِحّءِفِرِ بِرِن كُي. ");
INSERT INTO susa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","شّمّ نَ عَ شَ دِ فِنّ مَتِ كٌنيِ رَ، فِنّ شْرّيَ كِ مُ لُمَ عَلْ شّمّ شْرّيَ كِ. ");
INSERT INTO susa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","شَ نَ فِنّ مُ رَقَن عَ مَرِفِ مَ، نَشَن نُ وَ مَ عَ قِندِقٍ عَ شَ فِنّ رَ، عَ لَنمَ عَ شَ لُ عَ شُن شَ سَرَ. عَ مُ دَشَ عَ شَ عَ مَتِ مِشِ فبّتّ مَ، بَرِ مَ عَ بَرَ مّي عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","شَ عَ وَ مَ عَ قِقٍ عَ شَ دِ مَ فِنّ رَ، عَ لَنمَ عَ شَ عَ سُشُ عَلْ عَ شَ دِ فِنّ يَتِ. ");
INSERT INTO susa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","شَ عَ سَ فِنّ فبّتّ تٌنفٌ، عَ نَشَ سٍسٍ بَ عَ شَ فِنّ سِنفٍ شَ دٌنسٍ، عَ شَ سٌسٍيٍ، نُن عَ شَ سْلّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","شَ عَ مُ نَ قٍ سَشَنيِيٍ رَكَمَلِ عَ بّ، فِنّ نْمَ كٍلِدٍ عَ شْن مَ، عَ مُ سٍسٍ قِ. ");
INSERT INTO susa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","نَشَن نَ مِشِ بْنبْ هَن عَ نَشَ قَشَ، نَ كَنيِ لَن عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","كْنْ شَ عَ مُ عَ قَشَقٍ حَنِفٍشِ، عَلَ نَن تُن عَ رَفِرِشِ، عَ شَ عَ شُن تَشُ يِرٍ ندٍ ﭑ دّننَشّ مَسٍنمَ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","كْنْ شَ عَ نُ عَ قَشَقٍ حَنِفٍشِ نّ كْوتَ ندٍ رَ، نَ كَنيِ مُ نْمَ عَ شُن تَشُدٍ ﭑ مَ سّرّشّبَدٍ رَ. وٌ شَ عَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","نَشَن نَ عَ نفَ، شَ نَ مُ عَ بَبَ بْنبْ، نَ لَن نّ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","نَشَن نَ عَدَ مَدِ سُشُ، عَ شَ عَ مَتِ، نَ كَنيِ شَ قَشَ هَلِ عَ مُ فّشِ نَ عَدَ مَدِ مَتِدٍ. ");
INSERT INTO susa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","نَشَن نَ عَ نفَ، شَ نَ مُ عَ بَبَ دَنكَ، نَ كَنيِ لَن نّ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","نَشَن نَ مِشِ مَشْنْ فٍرٍ كُي، نَ كَنيِ مُ سُشُمَ شَ مِشِ مَشْنْشِ مُ قَشَشِ، ");
INSERT INTO susa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","شَ عَ نْمَ كٍلِدٍ عَ شَ سَدٍ مَ، عَ حّرّ عَ شَ يِسُشُوُرِ رَ. كْنْ مَشْنّ تِ تَن لَنمَ عَ شَ كْبِرِ بَ نَ مِشِ مَشْنْشِ بّ هَن عَ فّمَ يَلَندٍ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","نَشَن نَ عَ شَ كٌنيِ قَشَ بْنبْ وُرِ رَ، عَ لَنمَ نّ نَ كَنيِ شَ حَشَنكَتَ. ");
INSERT INTO susa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","كْنْ شَ نَ كٌنيِ سَ يَلَن بٍينُ شِ قِرِن، عَ مُ لَنمَ كٌنيِ كَنيِ شَ حَشَنكَتَ، بَرِ مَ نَ كٌنيِ قِندِشِ عَ فبٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","مِشِ نَشٍيٍ بْنبْمَ قُرِ فِنّ ندٍ رَ، عٍ شَ فٍرٍ كُي، نَ قَ عَ نِيَ فِنّ شَ دِ بَرِ عَ وَشَتِ مُ عَ لِشِ، كْنْ عَ مُ قٍ كَنَ عَ مَ، نَ فٍرٍ سٌييٍ شَ كْبِرِ ندٍ بَ فِنّ بّ. فِنّ شَ مْرِ نُن كِيتِسَ شَ نَتّ تٌنفٌ كْبِرِ شَسَبِ نَشَن بَمَ. ");
INSERT INTO susa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","كْنْ شَ عَ سَ قِندِ فبَلٌي رَ، نِي حْشْي نَ نِي نَن نَ، ");
INSERT INTO susa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","يَ حْشْي نَ يَ نَن نَ، حِنيِ حْشْي نَ حِنيِ نَن نَ، بّلّشّ حْشْي نَ بّلّشّ نَن نَ، سَنيِ حْشْي نَ سَنيِ نَن نَ، ");
INSERT INTO susa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","فَنيِ حْشْي نَ فَنيِ نَن نَ، شَبّ حْشْي نَ شَبّ نَن نَ، مَشْنّ حْشْي نَ مَشْنّ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","نَشَن نَ عَ شَ كٌنيِ بْنبْ هَن عَ يَ نَشَ كَنَ، عَ لَنمَ عَ شَ عَ شَ كٌنيِ شْرّيَ عَ شَ يَ كَنّ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","نَشَن نَ عَ شَ كٌنيِ حِنيِ فِرَ، نَ كَنيِ لَنمَ عَ شَ عَ شَ كٌنيِ شْرّيَ عَ شَ حِنيِ فِرّ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","تُورَ نَشَن نَ مِشِ قَشَ، عَ لَنمَ نَ تُورَ شَ مَفْنْ هَن عَ قَشَ. عَ سُبٍ نَشَ دٌن. تُورَ كَنيِ مُ حَشَنكَتّ يٌ سْتْمَ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","كْنْ شَ نَ تُورَ دَرِشِ نَ مْولِ رَبَ رَ، عَ كَنيِ عَ كٌلٌن كْنْ عَ مُ عَ شِرِ مَ عَ قَنيِ رَ، نَ كَنيِ يٌ، عَ شَ تُورَ يٌ، عٍ بِرِن شَ مَفْنْ هَن عٍ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","كِيتِسَ نْمَ نَتّ تٌنفٌدٍ نَ تُورَ كَنيِ شُن سَرَ مَ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","نَ سّرِيّ كٍرٍن نَن نَوَلِمَ هَلِ تُورَ سَ دِ مّدِ نَن قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","شَ عَ سَ لِ تُورَ قَ مِشِ فبّتّ شَ كٌنيِ ندٍ قَشَ، فبٍتِ كٌلٍ تٌنفٌ سَشَن نَن قِمَ نَ كٌنيِ مَرِفِ مَ. نَ تُورَ شَ مَفْنْ هَن عَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","نَشَن نَ يِلِ فٍ، عَ لُ عِ مُ عَ دّ رَكٌتٌمَ، شَ عَ سَ لِ نِنفٍ شَ نَ مُ عَ رَ سٌقَلٍ ندٍ سَ سِن نَ يِلِ كُي، ");
INSERT INTO susa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","عَ لَنمَ نَ كَنيِ شَ نَ شُرُ سٍ سَرٍ قِ، شُرُ سٍ قَشَشِ شَ لُ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","نَشَن مَ تُورَ نَ سَ عَ بٌورٍ فبٍ قَشَ، نَ تُورَ بَلٌشِ شَ مَتِ، نَ سَرٍ نُن نَ تُورَ قَشَشِ شَ عِتَشُن عٍ بٌورٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","كْنْ شَ عَ سَ عَ لِ، نَ تُورَ دَرِشِ نَ مْولِ رَبَ رَ، عَ كَنيِ عَ كٌلٌن كْنْ عَ مُ عَ شِرِ مَ عَ قَنيِ رَ، عَ لَنمَ تُورَ بَلٌشِ كَنيِ شَ عَ فبٍ قِ تُورَ قَشَشِ كَنيِ مَ، تُورَ قَشَشِ شَ لُ عَ تَن بّ. ");
INSERT INTO susa_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","نَشَن نَ تُورَ شَ نَ مُ عَ رَ يّشّي مُحَ، عَ سَ عَ مَتِ، شَ نَ مُ عَ رَ، عَ قَشَ، عَ لَنمَ نَ كَنيِ شَ تُورَ سُولِ رَفبِلٍن نَ تُورَ كٍرٍن حْشْي رَ، شَ نَ مُ، يّشّي نَانِ نَ يّشّي كٍرٍن حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","شَ وٌ مِشِ سُشُ عَ مُحّ تِقٍ كْي رَ، عَ قَ قَشَ وٌ يِ بْنبْي رَ، قَشّ كٌتٍ مُ دْشْمَ وٌ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","كْنْ شَ وٌ نَ مْولِ رَبَ يَنيِ رَ، قَشّ كٌتٍ دْشْمَ نّ وٌ شُن مَ. مُحّتِ لَنمَ عَ شَ سٍ مُحَشِيٍ سَرٍ رَفبِلٍن، كْنْ شَ عَ مُ نْمَ نَ رَ، عَ فُندِ شَ مَتِ كٌنيِ رَ عَلَكٌ مُحّ سٍ سَرٍ شَ قِ. ");
INSERT INTO susa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","شَ عَ سَ لِ، نَ سٍ مُحَشِ نَ عَ يِ عَلْ نِنفٍ، سٌقَلٍ، يّشّي، شَ نَ مُ عَ رَ، عَ حِحّ رَ، عَ عٍ حْندْن قِرِن نَن قِمَ عَ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","نَشَن نَ عَ شَ شُرُ سٍيٍ بّحِن، عَ سَ عَ بٌورٍ شَ شّ كَنَ، نَ كَنيِ لَنمَ عَ شَ عَ سَرٍ قِ عَ شَ شّ بٌفِ قَنيِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","نَشَن نَ تّ سَ حٌوفٍ فَنقٍ رَ، كْنْ تّ قَ مِشِ ندٍ شَ سَنسِ مَلَنشِ فَن، شَ نَ مُ عَ شَ شّ، نَ كَنيِ لَنمَ عَ شَ نَ سٍ بِرِن سَرٍ قِ. ");
INSERT INTO susa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","شَ مِشِ هَرِفٍ ندٍ تَشُ عَ دْشْبٌورٍ رَ، كْنْ مِشِ قَ نَ مُحَ، نَ مُحّتِ شَ نَ سٍ سَرٍ قِرِن نَفبِلٍن عَ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","كْنْ شَ نَ مُحّتِ مُ تٌ، سٍ تَشُشِ نَشَن نَ، نَ شَ عَ كَلِ عَلَ شِلِ رَ كِيتِسَمَيٍ يِرٍ، عَلَكٌ عٍ شَ عَ كٌلٌن عَ تَن شَ مُ نَ هَرِفٍ تٌنفٌشِ. ");
INSERT INTO susa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","شَ سٍ ندٍ سَ لُ مِشِ يِ رَ عَلْ نِنفٍ، سٌقَلٍ، يّشّي، دُفِ، شَ نَ مُ عَ رَ سٍ فبّتّ، كْنْ مِشِ فبّتّ قَ عَ قَلَ عَ تَن نَن فبٍ نَ عَ رَ، عٍ لَنمَ عٍ شَ سِفَ كِيتِسَيٍ يِرٍ. كِيتِ كَنَمَ نَشَن نَ، عَ شَ نَ سٍ سَرٍ دْشْ قِرِن نَفبِلٍن عَ بٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","شَ مِشِ ندٍ شُرُ سٍ تَشُ عَ بٌورٍ رَ، عَلْ سٌقَلٍ، نِنفٍ، شَ نَ مُ يّشّي، نَ شُرُ سٍ قَ قَشَ، شَ نَ مُ عَ سَلٌنسٍ ندٍ قَ فِرَ، شَ نَ مُ مِشِ قَ عَ مُحَ، ");
INSERT INTO susa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","عَ بٌورٍ شَ عَ كَلِ عَلَتَلَ رَ عَ مُ عَ يِ. سٍ كَنيِ شَ لَ نَ رَ، عَ شَ دِحّ نَ سٍ لْيشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","كْنْ شَ نَ شُرُ سٍ مُحَشِ نَ عَ شْنيِ نّ، عَ حْشْي قِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","شَ وُلَءِ سُبٍ ندٍ نَن قَ عَ قَشَ، عَ تَشُ نَشَن نَ، نَ شَ عَ بِنبِ مَسٍن شُرُ سٍ كَنيِ بّ سٍيدٍحْشْيَ رَ. نَ تّمُي، عَ مُ نَ حْشْي قِمَ. ");
INSERT INTO susa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","شَ مِشِ شُرُ سٍ يٍقُ عَ بٌورٍ مَ، شُرُ سٍ قَ عَ يّتّ مَشْنْ، شَ نَ مُ عَ رَ عَ قَشَ شُرُ سٍ كَنيِ شَنبِ، عَ يٍقُمَ شَ عَ حْشْي قِ. ");
INSERT INTO susa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","كْنْ شَ قٍ ندٍ نَ شُرُ سٍ سْتْ عَ كَنيِ يَ شْرِ، عَ يٍقُمَ مُ عَ حْشْي قِمَ. شَ عَ سَ لِ، عَ هّرِشِ نَن عَ رَ، هّرِ مَسُندِ نَن قِندِ مَ عَ حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","نَشَن نَ فِنّ دِ مّدِ قُتِ كَنَ نَشَن شَ كٌتٍ مُ دْشْشِ سِندٍن، عَ لَنمَ عَ شَ عَ شَ كٌتٍ دْشْ عَلَكٌ عَ شَ قِندِ عَ شَ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","شَ نَ فِنّ بَبَ مُ تِن عَ قِدٍ عَ مَ، نَ قُتِكَنّ كْبِرِ نَن قِمَ نَشَن لَنمَ فِنّ دِ مّدِ شَ كٌتٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","مَندُرُلَ فِنّ لَنمَ نّ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","نَشَن يٌ يّنّ رَبَ شُرُ سٍ رَ، عَ لَنمَ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","نَشَن يٌ نَ سّرّشّ بَ عَلَ فبّتّ بّ، بَقٍ عَلَتَلَ رَ، نَ كَنيِ لَن نّ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","وٌ نَشَ شْحّ تْورْ نَشَن قَتَن سِ فبّتّ رَ عَ سَبَتِ وٌ شْنيِ، بَرِ مَ وٌ قَن نُ نَ شْحّيَ نّ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","وٌ نَشَ قُ كَاحّ فِنّ نُن كِرِدِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","وٌ نَ قُ نٍيٍ مَ، ﭑ عٍ وَ شُي مّمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ﭑ مَ شْنّ تٍمَ نّ وٌ شِلِ مَ، ﭑ وٌ قَشَ سَنتِدّفّمَ رَ. وٌ شَ فِنّيٍ قِندِ مَ نّ كَاحّ فِنّيٍ رَ، وٌ شَ دِيٍ قَن قِندِ مَ نّ كِرِدِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","شَ وٌ سَ كْبِرِ دٌنِ تْورْ مِشِ ندٍ بّ ﭑ مَ حَمَ يَ مَ، وٌ نَشَ فٍينِ يٌ قٍن عَ شُن نَ عَلْ دٌنِتِ حَاشِ ندٍيٍ. ");
INSERT INTO susa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","وٌ نَ وٌ بٌورٍ شَ دُفِ دْشْ سّيكّ رَ، وٌ شَ عَ رَفبِلٍن عَ مَ بٍينُن سٌفٍ شَ دُلَ، ");
INSERT INTO susa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","بَرِ مَ نَ كٍرٍن ثٍتِ نَن عَ يِ رَ، عَ نَ نَن قٍلٍنمَ عَ مَ. عَ نَ ﭑ شِلِ، ﭑ عَ شُي سُشُمَ نّ، بَرِ مَ كِنِكِنِنتٍ نَن ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","وٌ نَشَ ﭑ تَن عَلَ بّشُ. وٌ نَشَ وٌ شَ حَمَ مَنفّ دَنكَ. ");
INSERT INTO susa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","وٌ نَشَ دُفُندِ ﭑ كِدٍ وٌ شَ شّ بٌفِيٍ رَ. وٌ شَ وٌ شَ دِ سِنفٍ بِرِن قِ ﭑ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","وٌ شَ وٌ شَ شُرُ سٍيٍ شَ دِ سِنفٍيٍ قِ ﭑ مَ. وٌ شَ عٍ لُ عٍ نفَ قْشْ رَ شِ سٌلٌقٍرٍ. عَ شِ سٌلٌمَسَشَن ندٍ، وٌ قَ عٍ قِ ﭑ مَ. ");
INSERT INTO susa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","وٌ شَ قِندِ ﭑ مَ حَمَ سّنِيّنشِ رَ. وٌ نَشَ وُلَءِ سُبٍ دٌن، سُبٍ فبّتّ نَشَن قَشَشِ. وٌ شَ نَ مْولِ قِ بَرٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","وٌ نَشَ مِشِ تْوحّفّ، وٌ نَشَ وُلٍ سٍيدٍ بَ مِشِ حَاشِ بّ. ");
INSERT INTO susa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","وٌ نَشَ بِرَ حَمَ وَشْنقٍ حَاشِ قْشْ رَ، وٌ نَشَ وُلٍ سٍيدٍ بَ حَمَ شَ قٍ رَ. نَ مْولِ تِنشِنيِ كَنَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","وٌ نَشَ مِشِ رَقِسَ عَ بٌورٍ بّ كِيتِ كُي، هَلِ عَ قِندِ مِسِكِينّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","وٌ نَ وٌ يَشُي شَ نِنفٍ لْيشِ تٌ، شَ نَ مُ عَ شَ سٌقَلٍ، وٌ شَ عَ شَنِن عَ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","وٌ نَ وٌ يَشُي شَ سٌقَلٍ تٌ، عَ بِرَشِ كٌتٍ شُنفبٍ بُن مَ، وٌ نَشَ عَ لُ نَا. وٌ شَ عَ مَلِ. ");
INSERT INTO susa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","وٌ نَشَ سّرِيّ مَتَندِ تْورْ مِشِ مَكِيتِمَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","وٌ نَشَ مِشِ تْوحّفّ. وٌ نَشَ عَ نِيَ مِشِ تْوحّفّشِ شَ قَشَ، بَرِ مَ ﭑ مُ دِحّمَ نَ مِشِ مْولِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","وٌ نَشَ تِنشِنيِ كَنَ كْبِرِ رَ، بَرِ مَ نَ عَ نِيَمَ نّ سٍيدٍ شَ دُندُ، تِنشِنتْي شَ وْيّنيِ شَ مَقِندِ. ");
INSERT INTO susa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","وٌ نَشَ شْحّ تْورْ نَشَن قَتَن سِ فبّتّ رَ. وٌ تَن يَتِ بَرَ نَ تْورّ مْولِ كٌلٌن وٌ نُ نَ مِسِرَ بْشِ مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","وٌ شَ سَنسِ سِ، وٌ شَ عَ شَبَ حّ سٍننِ بُن مَ، ");
INSERT INTO susa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","كْنْ عَ حّ سٌلٌقٍرٍ ندٍ، وٌ شَ بْشِ لُ نَ، عَ شَ عَ مَلَبُ. نَ تّمُي سَنسِ نَشَن قَمَ بُلَدٍ عَ يّتّ مَ، نَ نْمَ قِندِدٍ عِسِرَيِلَ تْورْ مِشِيٍ شَ بَلٌي رَ. بُرُنيِ سُبٍيٍ قَن شَ بَلٌ نَ دْنشْي رَ. وٌ شَ نَ رَبَ وٌ شَ وّنِ نُن وٌ شَ عٌلِوِ بِلِيٍ قَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","وٌ شَ وَلِ بِرِن نَبَ شِ سٍننِ بُن مَ، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ وٌ نَشَ وَلِ يٌ رَبَ عَلَكٌ وٌ شَ نِنفٍ، وٌ شَ سٌقَلٍ، وٌ شَ كٌنيِ، نُن سِ فبّتّ مِشِ نَشٍيٍ نَ وٌ شْنيِ، عٍ بِرِن شَ عٍ مَلَبُ. ");
INSERT INTO susa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","وٌ شَ وٌ حْشْ سَ ﭑ مَ يَامَرِ بِرِن شْن مَ. وٌ نَشَ عَلَ فبّتّيٍ بَتُ، عٍ شِلِ حَن نَشَ مِنِ وٌ دّ عِ. ");
INSERT INTO susa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","حّ يٌ حّ وٌ شَ سَلِ سَشَن نَبَ ﭑ مَ بِنيّ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","وٌ شَ تَامِ لّبِنِتَرٍ سَلِ رَبَ يِ كِ. شِ سٌلٌقٍرٍ نَشٍيٍ سُفَندِشِ عَبِبِ كِكٍ كُي، وٌ شَ تَامِ لّبِنِتَرٍ فبَنسَن دٌن، عَلْ ﭑ وٌ يَمَرِشِ كِ نَشّ. وٌ شَ عَ رَبَ نَ تّمُي نّ بَرِ مَ وٌ مِنِ مِسِرَ بْشِ كُي نَ كِكٍ نَن نَ. وٌ نَشَ ﭑ كُمَ نَ سَلِيٍ كُي. ");
INSERT INTO susa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","شّ شَبّ سَلِ، وٌ شَ عَ رَبَ وٌ شَ سَنسِ بٌفِ سِنفٍيٍ رَ. سَنسِ بٌفِ بَ سَلِ، وٌ شَ عَ رَبَ حّ رَحْنيِ، وٌ نَ سَنسِ بٌفِ سٍ رَ سٌ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","شّمّ بِرِن شَ نَ سَلِ سَشَن نَبَ عٍ مَرِفِ عَلَتَلَ شَ بِنيّ بُن مَ حّ بِرِن كُي. ");
INSERT INTO susa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","وٌ نَ شُرُ سٍ بَ سّرّشّ رَ ﭑ بّ تّمُي نَشّ، وٌ نَشَ تَامِ لّبِنِ دَاشِ بَ سّرّشّ رَ عَ سّيتِ مَ دٍ. وٌ نَشَ ﭑ مَ سَلِ سّرّشّ سُبٍ تُرٍ رَفَتَ هَن فّيسّفّ. ");
INSERT INTO susa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","وٌ شَ سَنسِ بٌفِ قِسَمَنتٍ بَ وٌ شَ سَنسِ بٌفِ سِنفٍيٍ يَ مَ ﭑ تَن وٌ مَرِفِ عَلَتَلَ بّ، وٌ عٍ شَنِن ﭑ مَ هْرْ مْلِنفِرَ كُي. وٌ نَشَ سِ حِن عَ نفَ شِحّ يٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ﭑ مَلٍكّ تِمَ نّ وٌ يَ رَ، نَشَن وٌ مَكَنتَمَ كِرَ رَ سِفَقٍ رَ بْشِ مَ ﭑ دّننَشّ يَءِلَنشِ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","وٌ شَ وٌ تُلِ مَتِ عَ رَ، وٌ شَ عَ شُي سُشُ. وٌ نَشَ عَ مَتَندِ. عَ مُ دِحّمَ وٌ شَ مَتَندِ مَ، بَرِ مَ ﭑ شِلِ نَ عَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","كْنْ شَ وٌ وٌ تُلِ مَتِ عَ رَ، شَ وٌ عَ شُي بِرِن سُشُ، ﭑ قِندِ مَ نّ وٌ يَشُييٍ يَشُي رَ، وٌ فٍرٍقَيٍ فٍرٍ مَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ﭑ مَ مَلٍكّ وٌ مَتِمَ عَمٌرِكَيٍ، شِتِكَيٍ، ثٍرِ سِكَيٍ، كَنَانكَيٍ، هِوِكَيٍ، نُن يٍبُسُكَيٍ شْنيِ. ﭑ قَمَ نّ عٍ بِرِن سْنتْدٍ. ");
INSERT INTO susa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","وٌ نَشَ سُيِدِ عٍ شَ عَلَيٍ بّ، وٌ نَشَ عٍ بَتُ، وٌ نَشَ بِرَ عٍ قْشْ رَ. وٌ شَ عٍ شَ كُيٍيٍ كَنَ، وٌ شَ عٍ شَ فّمّ مَسٌلِشِيٍ مَفِرَ. ");
INSERT INTO susa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","وٌ شَ وٌ مَرِفِ عَلَتَلَ بَتُ. عَ بَرَكّ سَمَ نّ وٌ شَ تَامِ نُن وٌ شَ يٍ مَ. عَ وٌ شَ قُرٍ يَلَنمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","فِنّ قُرِ مُ كَنَمَ وٌ شَ بْشِ مَ، فِنّ دِ بَرِتَرٍ قَن مُ تٌمَ وٌ يَ مَ. ﭑ سِمَيَ كَمَلِشِ قِمَ نّ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ﭑ سِيٍ رَفَاشُمَ نّ وٌ يَ رَ ﭑ سّنبّ رَ. ﭑ عٍ عِقُمَ نّ عَلَكٌ عٍ شَ عٍ فِ وٌ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ﭑ حُرِيٍ رَ سَنبَمَ نّ وٌ يَ رَ نَشَن هِوِكَيٍ، كَنَانكَيٍ، نُن شِتِكَيٍ كٍرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","كْنْ ﭑ مُ نَ رَبَمَ حّ كٍرٍن كُي، عَلَكٌ بْشِ نَشَ قَ كَنَ، وُلَءِ سُبٍيٍ نَشَ قَ وُيَ وٌ شِلِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ﭑ نٍيٍ كٍرِ مَ عَ شُرِ شُرِ نَن نَ وٌ يَ رَ، هَن وٌ وُيَ، وٌ قَ نْي سْتْ بْشِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ﭑ وٌ شَ نَانِنيِ عِفبٌمَ نّ كٍلِ شُلُنيُمِ بَا مَ هَن بَا شُنفبٍ، كٍلِقٍ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ هَن عَ سَ دْشْ عٍقِرَتِ شُرٍ شُنفبٍ رَ. ﭑ مّننِكَيٍ سَمَ نّ وٌ سَفٌ، عَلَكٌ وٌ شَ عٍ كٍرِ. ");
INSERT INTO susa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","وٌ نَشَ سَاتّ يٌ تٌنفٌ مّننِكَيٍ نُن عٍ شَ عَلَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","وٌ نَشَ لُ عٍ شَ سَبَتِ وٌ شَ بْشِ مَ، شَ نَ مُ عَ رَ عٍ عَ نِيَمَ نّ وٌ شَ فبِلٍن ﭑ قْشْ رَ. عٍ شَ عَلَيٍ قِندِ مَ فَنتَنيِ نَن نَ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «تٍ ﭑ يِرٍ بٍ فٍيَ قَرِ، عِ تَن، هَرُنَ، نَدَبٌ، عَبِهُ، نُن عِسِرَيِلَ قٌرِيٍ مِشِ تٌنفٌ سٌلٌقٍرٍ. وٌ شَ سُيِدِ يِرٍ نَشَن مَكُيَ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","مُنسَ، عِ فبَنسَن شَ مَكْرّ ﭑ نَ، بٌورٍيٍ شَ لُ يِرٍ مَكُيٍ. حَمَ قَن نَشَ تٍ عِ تَن مُنسَ قْشْ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","مُنسَ نَشَ عَلَتَلَ شَ مَسٍنيِ نُن عَ شَ يَامَرِ بِرِن نَدَنفِ حَمَ مَ. حَمَ بِرِن نَشَ عَ يَابِ شُي كٍرٍن نَ، «مُشُ عَلَتَلَ شُي بِرِن سُشُمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","مُنسَ نَشَ عَلَتَلَ شَ مَسٍنيِ بِرِن سّبّ. نَ كُيٍ عِبَ، مُنسَ نَشَ سّرّشّبَدٍ تِ فٍيَ بُنيِ، عَ نَشَ فّمّ تُندٍنيِ قُ نُن قِرِن تِ مّننِ، نَشٍيٍ عِسِرَيِلَ بْنسْي قُ نُن قِرِنيِ مِسَالِشِ. ");
INSERT INTO susa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","عَ نَشَ عِسِرَيِلَ قٌنِكٍ ندٍيٍ شّي عٍ شَ سّرّشّ فَن دَاشِيٍ بَ. عٍ مَن شَ تُورَيٍ بَ عَلَ بّ شَنُنتٍيَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","مُنسَ نَشَ نَ وُلِ تَفِ سَ قّحّ دِيٍ كُي، عَ نَشَ نَ دْنشْي كَسَن سّرّشّبَدٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","عَ نَشَ سَاتّ كِتَابُي تٌنفٌ، عَ عَ شَرَن حَمَ بِرِن بّ. عٍ نَشَ عَ يَابِ، «مُشُ عَلَتَلَ شُي بِرِن سُشُمَ نّ. مُشُ عَ رَتِنمّمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","مُنسَ نَشَ نَ وُلِ تٌنفٌ، عَ عَ كَسَن حَمَ مَ. عَ نَشَ عَ مَسٍن، «سَاتّ وُلِ نَن يَ. عَلَتَلَ يِ سَاتّ نَن تٌنفٌشِ وٌ بّ عَ شَ مَسٍنيِ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","مُنسَ نَشَ تٍ، عَ تَن نُن هَرُنَ، نَدَبٌ، عَبِهُ، نُن عِسِرَيِلَ قٌرِيٍ، مِشِ تٌنفٌ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","عٍ نَشَ عِسِرَيِلَ مَرِفِ عَلَ تٌ. عَ نُ تِشِ فّمّ نْرْشِ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","نَ عِسِرَيِلَ كُنتِفِيٍ نَشَ عَلَ تٌ، كْنْ عَ مُ عٍ حَشَنكَتَ نَ مَ. عٍ بِرِن نَشَ عٍ دّفٍ، عٍ نَشَ عٍ مِن. ");
INSERT INTO susa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «تٍ فٍيَ قَرِ ﭑ يِرٍ، عِ شَ قَ لُ بٍ سِندٍن. ﭑ شَ فّمّ وَلَشّيٍ سٌ عِ يِ رَ، ﭑ نَن ﭑ مَ سّرِيّ نُن ﭑ مَ يَامَرِيٍ سّبّشِ نَشٍيٍ مَ. عِ شَ عِسِرَيِلَكَيٍ شَرَن نٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","مُنسَ نُن عَ مَلِمَ يٌسُوٍ نَشَ تٍ عَلَ شَ فٍيَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","مُنسَ نَشَ عَ قَلَ قٌرِيٍ بّ، «وٌ شَ مُشُ مّمّ بٍ. مُشُ قَقٍ. هَرُنَ نُن شُرُ شَ لُ وٌ قّ مَ بٍ. شَ قٍ ندٍ بِرَ عَ عِ وٌ تَفِ، وٌ شَ عَ مَسٍن عٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","مُنسَ تٌ تٍ فٍيَ قَرِ، نُشُي نَشَ دُ سُ عَ شُن نَ. ");
INSERT INTO susa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","عَلَتَلَ شَ نْرّ نَشَ لُ تُرُ سِنِنَ فٍيَ شُن نَ. نُشُي نَشَ فٍيَ مَكٌتٌ شِ سٍننِ. عَ شِ سٌلٌقٍرٍ ندٍ، عَلَتَلَ نَشَ مُنسَ شِلِ نَ نُشُي كُي. ");
INSERT INTO susa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","عَلَتَلَ شَ نْرّ نُ لُشِ نّ عِسِرَيِلَكَيٍ بّ، عَلْ تّ شُنفبٍ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","مُنسَ تٌ نُ تٍمَ، عَ نَشَ سٌ نَ نُشُي كُي، عَ نَشَ لُ فٍيَ قَرِ شِ تٌنفٌ نَانِ كْي نُن يَنيِ. ");
INSERT INTO susa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، قٌنِسٍرٍلَيٍ شَ يِ سٍيٍ مْولِ بَ هَدِيَ رَ؛ ");
INSERT INTO susa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","شّيمَ، فبٍتِ، وُرٍ فبٍيلِ، ");
INSERT INTO susa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، فّسّ فبٍيلِ، سُوَ دُفِ، دُفِ نَشَن سْشْشِ سِ شَبٍ رَ، ");
INSERT INTO susa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","يّشّي كٌنتٌنيِ كِرِ نَشٍيٍ سٌشِ عَ فبٍيلِ رَ، ثٍرٍ مُي كِرِيٍ، كَسِيَ وُرِ، ");
INSERT INTO susa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","تُرٍ نَشَن سَمَ لَنثُي كُي، لَبُندّ نَشَن سَمَ تُرٍ سّنِيّنشِ نُن سُرَيِ شُن مَ، ");
INSERT INTO susa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","عَ نُن فّمّ تٌقَنيِ نَشٍيٍ قِندِ سّرّشّدُبّ شَ دٌنمَ كُيٍ نُن دٌنمَ كَنكٍ رَشُنمَ سٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","عِسِرَيِلَكَيٍ شَ هْرْ مْلِنفِرَ تِ ﭑ بّ، عَلَكٌ ﭑ شَ سَبَتِ عٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","وٌ شَ نَ لِنفِرَ نُن عَ شَ يِرَبَسٍ بِرِن يَءِلَن عَلْ ﭑ نَ مَسٍنمَ عِ بّ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«عٍ شَ سَاتّ كَنكِرَ يَءِلَن كَسِيَ وُرِ رَ. نَ كَنكِرَ شَ كُيَ نْنفْن قِرِن نُن عَ تَفِ، عَ شَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ، عَ شَ عِتٍ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","عِ شَ عَ كُي نُن عَ قَرِ مَسٌ شّيمَ رَ. عَ دّ كِرِ قَن شَ يَءِلَن شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","عِ شَ عَ سُشُدٍ دِفِلِنشِ نَانِ رَقَلَ شّيمَ رَ عَ تُنشُن نَانِيٍ مَ، قِرِن نَ سّيتِ، قِرِن نَ بٌورٍ سّيتِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","«عِ شَ كَسِيَ وُرِ كُيٍ قِرِن مَسٌلِ، عٍ مَسٌ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","عِ شَ عٍ رَ سٌ كَنكِرَ سُشُدٍ دِفِلِنشِيٍ كُي، نَ كَنكِرَ شَنِنمَ عٍ تَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","عٍ نَشَ رَ مِنِ نَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","«ﭑ نَ سَاتّ تْنشُمَ سٌ عِ يِ رَ، عِ شَ عَ سَ نَ كَنكِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","عِ شَ عَ دّرَكٌتٍ يَءِلَن شّيمَ قَنيِ رَ، نَشَن قِندِ مَ شُنسَرٍ يِرٍ رَ. عَ شَ كُيَ نْنفْن قِرِن نُن عَ تَفِ، عَ شَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","مَلٍكّ سَوُرّ قِرِن شَ يَءِلَن شّيمَ شَبُشِ رَ كَنكِرَ دّرَكٌتٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","مَلٍكّيٍ سَوُرّ نُن كَنكِرَ دّرَكٌتٍ شَ قِندِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","نَ مَلٍكّ سَوُرّ قِرِنيِيٍ شَ تِ عٍ بٌورٍ يَ عِ، عٍ فَبُتٍنيِيٍ عِتَلَشِ، عٍ شُن سِنشِ شُنسَرٍ يِرٍ.» ");
INSERT INTO susa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","«عِ شَ نَ كَنكِرَ دّرَكٌتٍ سَ عَ مَ، نَشَن قِندِشِ شُنسَرٍ يِرٍ رَ. ﭑ نَ سَاتّ تْنشُمَ سٌ عِ يِ رَ، عِ شَ عَ سَ نَ كَنكِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ﭑ نَن ﭑ يّتّ مَسٍنمَ عِ بّ مّننِ نّ، نَ سَاتّ كَنكِرَ دّرَكٌتٍ قَرِ، مَلٍكّ سَوُرّ قِرِنيِيٍ تَفِ. ﭑ يَامَرِ بِرِن سٌمَ عِ يِ رَ مّننِ نّ كَتَرَبِ عِسِرَيِلَكَيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«عِ شَ تٍيبِلِ ندٍ يَءِلَن كَسِيَ وُرِ رَ، نَشَن كُيَ نْنفْن قِرِن، عَ عِفبٌ نْنفْن كٍرٍن، عَ عِتٍ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","عِ شَ شّيمَ قَنيِ مَسٌ عَ مَ، عَ نُن عَ دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","شٍبٍنيِ ندٍ شَ سَ نَ دّ كِرِ بُن مَ نَشَن عِفبٌ سُشُي كٍرٍن عَ نُن عَ تَفِ. شّيمَ شَ سَ نَ قَن دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","عِ شَ عَ سُشُدٍ دِفِلِنشِ نَانِ رَقَلَ شّيمَ رَ عَ تُنشُن نَانِيٍ مَ، نَشٍيٍ عِلَنمَ عَ سَنيِيٍ رَ ");
INSERT INTO susa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","نَ شٍبٍنيِ بُن مَ. وُرِ كُيّيٍ شَ سٌ نٍيٍ كُي تٍيبِلِ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","نَ وُرِ كُيٍيٍ شَ مَسٌلِ كَسِيَ وُرِ رَ، شّيمَ شَ مَسٌ عٍ مَ. نٍيٍ نَن قِندِ مَ تٍيبِلِ تٌنفٌسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ثِلٍتِيٍ، تْنبِلِيٍ، ثْوتِيٍ، نُن ثَانِ نَشٍيٍ سَمَ نَ تٍيبِلِ مَ، نَشٍيٍ رَوَلِمَ سّرّشّ يٍيرَ مَ دَاشِ شَ قٍ رَ، نٍيٍ بِرِن شَ يَءِلَن شّيمَ قَنيِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","تَامِ قَن شَ سَ نَ تٍيبِلِ مَ تّمُي بِرِن، نَشَن قِندِشِ سّرّشّ رَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«عِ شَ لَنثُي دْشْسٍ ندٍ يَءِلَن شّيمَ قَنيِ شَبُشِ رَ. عَ سَنيِ، عَ بِلِ، عَ سَلٌنيِيٍ، نُن لَنثُي دْشْدٍ نَشٍيٍ مَنِيَ سَنسِ قُفٍيٍ رَ، نَ بِرِن شَ قِندِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","سَلٌن سٍننِ شَ مِنِ لَنثُي دْشْسٍ بِلِ مَ، سَشَن سّيتِ كٍرٍن، سَشَن بٌورٍ سّيتِ. ");
INSERT INTO susa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","تْنبِلِ سَشَن شَ لُ نَ سَلٌن سٍننِ بِرِن شُن مَ. عٍ شَ مَنِيَ سَنسِ بٌفِ رَ نَشَن دْشْشِ عَ بُرّشّيٍ نُن عَ قُفٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","تْنبِلِ نَانِ فبّتّ شَ لُ لَنثُي بِلِ مَ. عٍ قَن شَ مَنِيَ سَنسِ بٌفِ رَ نَشَن دْشْشِ عَ بُرّشّيٍ نُن عَ قُفٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","نَ سَلٌن قِرِن قِرِن دْشْ سَشَنيِيٍ بُن مَ نَشٍيٍ كٍلِشِ عَ بِلِ مَ، عَ سَمَ نّ مّننِ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","نَ تْنبِلِيٍ نُن لَنثُي سَلٌنيِيٍ شَ قِندِ كٍرٍن نَ، عٍ شَ يَءِلَن شّيمَ قَنيِ شَبُشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«عِ شَ لَنثُي سٌلٌقٍرٍ يَءِلَن، عِ شَ عٍ دْشْ عٍ دْشْدٍيٍ مَ عَلَكٌ عٍ دّشّ شَ يَرٍ عِيَلَن. ");
INSERT INTO susa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","عِ شَ وُكِ شَبَسٍ نُن شُبٍ سَسٍ يَءِلَن شّيمَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","شّيمَ نَشَن نَوَلِمَ لَنثُي دْشْسٍ نُن لَنثُي يِرَبَسٍ يَءِلَنقٍ رَ، نَ شَ قِندِ شّيمَ كِلٌ تٌنفٌ سَشَن نُن نَانِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","عِ شَ نَ بِرِن نَبَ عَلْ ﭑ عَ مَسٍنشِ عِ بّ كِ نَشّ فٍيَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«عِ شَ عَلَ شَ هْرْ مْلِنفِرَ يَءِلَن سُوَ دُفِ قُ رَ، نَشٍيٍ رَشُنمَشِ فّسّ مْولِ سَشَن نَ، فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، نُن فّسّ فبٍيلِ. نَ فّسّ شَ مَلٍكّيٍ سَوُرّ رَ مِنِ دُفِيٍ مَ. عَ شَ تٌقَن كِ قَنيِ. ");
INSERT INTO susa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","دُفِ بِرِن شَ كُيَ نْنفْن مْشْحّن نُن سٌلٌمَسَشَن، عَ شَ عِفبٌ نْنفْن نَانِ. عٍ كُيّ نُن عٍ عِفبٌيَ شَ لَن. ");
INSERT INTO susa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","دُفِ سُولِ شَ دّفّ عٍ بٌورٍ رَ، دُفِ سُولِ فبّتّ قَن شَ دّفّ عٍ بٌورٍ رَ. نَ كُي نَ دُفِ قُ بَرَ قِندِ دُفِ قِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","عِ شَ فّسّ فّرّ دَاشِ دّفّ نَ دُفِ سِنفٍ دّ كِرِ مَ، عَ نُن نَ دُفِ قِرِن ندٍ دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","عِ شَ فّسّ تٌنفٌ سُولِ دّفّ نَ قِرِنيِ دّ كِرِ مَ عَلَكٌ عٍ بِرِن شَ لَن عٍ بٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","نَ دَنفِ شَنبِ عِ شَ سُشُسٍ تٌنفٌ سُولِ يَءِلَن شّيمَ رَ، عِ قَ نَ دُفِ قِرِنيِيٍ رَلَن عٍ بٌورٍ رَ نَ سُشُسٍيٍ رَ. نَ نَن عَ نِيَمَ هْرْ مْلِنفِرَ شَ قِندِ دُفِ كٍرٍن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«عِ شَ دُفِ قُ نُن كٍرٍن سْشْ سِ شَبٍ رَ، نَشٍيٍ عَلَ شَ هْرْ مْلِنفِرَ مَكٌتٌمَ. ");
INSERT INTO susa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","دُفِ كٍرٍن شَ كُيَ نْنفْن تٌنفٌ سَشَن، عَ شَ عِفبٌ نْنفْن نَانِ. نَ دُفِ قُ نُن كٍرٍنيِ بِرِن شَ لَن. ");
INSERT INTO susa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","عِ شَ دُفِ سُولِ دّفّ عٍ بٌورٍ رَ، عٍ شَ قِندِ دُفِ كٍرٍن نَ. نَ دُفِ سٍننِ نَشٍيٍ لُشِ، عِ شَ عٍ قَن دّفّ عٍ بٌورٍ رَ. نَ دُفِ سٍننِ ندٍ سِنفَنمَ بَنشِ يَتَفِ نَن شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","عِ شَ فّسّ تٌنفٌ سُولِ دّفّ نَ دُفِ سِنفٍ رَ، عَ نُن نَ دُفِ قِرِن ندٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","نَ دَنفِ شَنبِ عِ شَ سُشُسٍ تٌنفٌ سُولِ يَءِلَن وُرٍ فبٍيلِ رَ، عِ قَ نَ دُفِ قِرِنيِيٍ رَلَن عٍ بٌورٍ رَ نَ سُشُسٍيٍ رَ. نَ نَن عَ نِيَمَ نَ بِرِن شَ قِندِ دُفِ كٍرٍن نَ نَشَن عَلَ شَ هْرْ مْلِنفِرَ مَكٌتٌمَ. ");
INSERT INTO susa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","نَ دُفِ شَ مَيِفبٌي كّحَ مَ دْنشْي تَفِ سِنفَنمَ هْرْ مْلِنفِرَ نَن شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","نَ دُفِ شَ كُيّ كّحَ نَ كِ نَشّ، نْنفْن كٍرٍن نَن لُمَ نَ سّيتِ قِرِنيِيٍ مَ، عَلَكٌ هْرْ مْلِنفِرَ شَ مَكٌتٌ.» ");
INSERT INTO susa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«نَ دَنفِ شَنبِ عِ شَ مَكٌتٌسٍ فبّتّ يَءِلَن يّشّي كٌنتٌنيِ كِرِ رَ، نَشَن سٌشِ عَ فبٍيلِ رَ. عِ مَن شَ مَكٌتٌسٍ فبّتّ يَءِلَن ثٍرٍ مُي كِرِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«عِ شَ كَسِيَ وُرِ شَبَ شٍبٍنيِيٍ رَ هْرْ مْلِنفِرَ تِمَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","كَنكَن شَ كُيَ نْنفْن قُ، عَ شَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","سُشُسٍ قِرِن شَ لُ هْرْ مْلِنفِرَ شٍبٍنيِ بِرِن مَ عٍ كَقُمَ عٍ بٌورٍ مَ نَشٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","شٍبٍنيِ مْشْحّن نَن تِمَ هْرْ مْلِنفِرَ يِرٍقَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","سَنبُنيِ فبٍتِ دَاشِ تٌنفٌ نَانِ نَن سَمَ نَ شٍبٍنيِ مْشْحّن بُن مَ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن. عٍ شَ لُ شٍبٍنيِ سُشُسٍيٍ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","شٍبٍنيِ مْشْحّن نَن تِمَ هْرْ مْلِنفِرَ كْولَ قَن مَ، ");
INSERT INTO susa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","عَ نُن عٍ سَنبُنيِ فبٍتِ دَاشِ تٌنفٌ نَانِ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن. ");
INSERT INTO susa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","شٍبٍنيِ سٍننِ نَن تِمَ هْرْ مْلِنفِرَ شَنبِ رَ سٌفٍفٌرٌدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","عِ شَ شٍبٍنيِ قِرِن يَءِلَن تُشُييٍ بّ هْرْ مْلِنفِرَ شَنبِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","نَشٍيٍ قُفٍ نُن لَنبَنيِ لَنمَ عٍ بٌورٍ مَ، عٍ شِرِ قُفٍ رَ سٍ دِفِلِنشِ رَ. نَ تُشُي قِرِنيِ شَ يَءِلَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","نَ بِرِن لَنمَ شٍبٍنيِ سٌلٌمَسَشَن نَن مَ، عَ نُن عٍ سَنبُنيِ فبٍتِ دَاشِ قُ نُن سٍننِ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن.» ");
INSERT INTO susa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«عِ شَ وُرِ سُولِ يَءِلَن كَسِيَ وُرِ رَ، هْرْ مْلِنفِرَ شٍبٍنيِيٍ تِمَ نَشٍيٍ مَ. سُولِ رَوَلِ سّيتِ كٍرٍن مَ، ");
INSERT INTO susa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","سُولِ رَوَلِ بٌورٍ سّيتِ مَ، سُولِ رَوَلِمَ هْرْ مْلِنفِرَ شَنبِ رَ سٌفٍفٌرٌدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","وُرِ نَشَن لُمَ عَ تَفِ، نَ دَنفِمَ شٍبٍنيِيٍ نَن شُن مَ، عَ كٍلِ سّيتِ سِنفٍ عَ سَ دْشْ بٌورٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","نَ شٍبٍنيِيٍ، نُن نَ وُرِيٍ، نُن سٍ دِفِلِنشِيٍ وُرِ سٌمَ نَشٍيٍ كُي، عِ شَ شّيمَ مَسٌ نَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","عِ شَ نَ هْرْ مْلِنفِرَ تِ عَلْ ﭑ عِ يَمَرِشِ كِ نَشّ فٍيَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«عِ شَ سُوَ دُفِ يَءِلَن فّسّ فبٍيلِ نُن فّسّ بُلُ دَاشِ رَ. مَلٍكّ سَوُرّيٍ شَ دّفّ نَ مَ، عَ شَ تٌقَن كِ قَنيِ. ");
INSERT INTO susa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","عِ شَ عَ فبَكُ كَسِيَ وُرِ نَانِ رَ شّيمَ مَسٌشِ نَشٍيٍ مَ، عٍ تِشِ فبٍتِ سَنبُنيِيٍ مَ. سُشُسٍ نَشٍيٍ دُفِ شِرِ مَ وُرِيٍ مَ، شّيمَ شَ مَسٌ نٍيٍ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","عِ نَ فّ دُفِ فبَكُدٍ نَ سُشُسٍيٍ رَ، عِ شَ سَاتّ كَنكِرَ دْشْ عَ شَنبِ رَ. نَ كِ، نَ دُفِ لُمَ نَ يِرٍ قِرِن تَفِ رَ، نَشَن شِلِ يِرٍ سّنِيّنشِ عَ نُن نَشَن شِلِ يِرٍ سّنِيّنشِ قِسَمَنتٍ. ");
INSERT INTO susa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","عِ شَ سَاتّ كَنكِرَ دّ رَكٌتٌ عَ دّرَكٌتٍ رَ يِرٍ سّنِيّنشِ قِسَمَنتٍ كُي. نَ دّرَكٌتٍ سٍ قِندِشِ شُنسَرٍ يِرٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","عِ شَ تٍيبِلِ تَن دْشْ هْرْ مْلِنفِرَ كْولَ مَ، لَنثُي دْشْسٍ شَ لُ عَ يَ رَ يِرٍقَنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«عِ شَ سُوَ دُفِ فبّتّ يَءِلَن فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، نُن فّسّ فبٍيلِ رَ هْرْ مْلِنفِرَ سٌدٍ. عِ شَ عَ مَسْشْ عَ قَنيِ رَ، عَ شَ تٌقَن. ");
INSERT INTO susa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","عِ شَ عَ فبَكُ وُرِ سُولِ مَ نَشٍيٍ يَءِلَنشِ كَسِيَ وُرِ رَ، شّيمَ مَسٌشِ نَشٍيٍ مَ، عٍ تِشِ فبٍتِ سَنبُنيِيٍ مَ. سُشُسٍ نَشٍيٍ دُفِ شِرِ مَ وُرِيٍ مَ، نٍيٍ يَءِلَنشِ وُرٍ فبٍيلِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«عِ شَ سّرّشّبَدٍ يَءِلَن كَسِيَ وُرِ رَ، نَشَن كُيَ نْنفْن سُولِ، عَ عِفبٌ نْنفْن سُولِ، عَ عِتٍ نْنفْن سَشَن. ");
INSERT INTO susa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","عِ شَ قٍرِ نَانِ يَءِلَن عَ تُشُي بِرِن مَ، نَشٍيٍ قِندِشِ سٍ كٍرٍن نَ سّرّشّبَدٍ رَ. عِ شَ وُرٍ فبٍيلِ مَسٌ نَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","عِ شَ عَ يِرَبَسٍ بِرِن يَءِلَن وُرٍ فبٍيلِ رَ، عَلْ شُبٍ سَسٍيٍ، ثٍلِيٍ، ثْوتِيٍ، سُبٍ سْشْسٍيٍ، نُن تُندٍيٍ تّ سَمَ نَشٍيٍ كُي. ");
INSERT INTO susa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","عِ شَ سٍ ندٍ يَءِلَن وُرٍ فبٍيلِ رَ نَشَن سَمَ تّ شُن مَ، سُبٍ سَمَ نَشَن قَرِ. عِ شَ سُشُسٍ دِفِلِنشِيٍ وُرٍ فبٍيلِ دَاشِ سَ عَ تُشُي مَ، ");
INSERT INTO susa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","عَلَكٌ عَ شَ فبَكُ سّرّشّبَدٍ كُي عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","عِ شَ وُرِ كُيٍيٍ يَءِلَن كَسِيَ وُرِ رَ وُرٍ فبٍيلِ مَسٌشِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","عٍ رَ سٌمَ سُشُسٍ دِفِلِنشِ نَانِيٍ نَن كُي سّرّشّبَدٍ سّيتِ قِرِنيِيٍ مَ عَ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","عِ شَ نَ سّرّشّبَدٍ يَءِلَن شٍبٍنيِيٍ نَن نَ. سٍسٍ نَشَ لُ عَ كُي. عِ شَ عَ يَءِلَن عَلْ ﭑ عِ يَمَرِشِ كِ نَشّ فٍيَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«عِ شَ هْرْ مْلِنفِرَ تّتّ يَءِلَن يِ كِ نّ؛ تّتّ شَ كُيَ نْنفْن كّمّ يِرٍقَنيِ مَبِرِ رَ. عِ شَ فّرّ سُوَ دُفِ فبَكُ نَ ");
INSERT INTO susa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","وُرِ مْشْحّن مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. نَ دُفِ سُشُسٍيٍ شَ يَءِلَن فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","تّتّ شَ كُيَ نْنفْن كّمّ كْولَ قَن مَبِرِ رَ. عِ شَ فّرّ دُفِ فبَكُ نَ وُرِ مْشْحّن مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. نَ دُفِ سُشُسٍيٍ شَ يَءِلَن فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","تّتّ شَ عِفبٌ نْنفْن تٌنفٌ سُولِ سٌفٍفٌرٌدٍ مَبِرِ رَ. عِ شَ فّرّ دُفِ فبَكُ نَ وُرِ قُ مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","تّتّ شَ عِفبٌ نْنفْن تٌنفٌ سُولِ سٌفٍتٍدٍ قَن مَبِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","فّرّ دُفِ شَ فبَكُ سّيتِ مَ وُرِ سَشَن مَ، نَشٍيٍ تِشِ سَنبُنيِ مَ. نَ شَ كُيَ نْنفْن قُ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","فّرّ دُفِ فبّتّ شَ فبَكُ بٌورٍ سّيتِ مَ وُرِ سَشَن مَ، نَشٍيٍ تِشِ سَنبُنيِ مَ. نَ قَن شَ كُيَ نْنفْن قُ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","تّتّ سٌدٍ دّ شَ يَءِلَن سُوَ دُفِ رَ نَشَن مَسْشْشِ فّسّ فّرّ دَاشِ نُن فّسّ بُلُ دَاشِ نُن فّسّ فبٍيلِ رَ. نَ دُفِ شَ نْنفْن شَ مْشْحّن سْتْ. نَ شَ فبَكُ وُرِ نَانِ مَ، نَشٍيٍ تِشِ سَنبُنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","وُرِ نَشٍيٍ تِشِ تّتّ مَ، عٍ تِشِ عٍ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. دُفِ سُشُسٍيٍ قَن نَ عٍ مَ نَشٍيٍ يَءِلَنشِ فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","نَ هْرْ مْلِنفِرَ تّتّ كُيّيَ لَنمَ نْنفْن كّمّ نَن مَ، عَ عِفبٌيَ نْنفْن تٌنفٌ سُولِ. سُوَ دُفِ نَشٍيٍ فبَكُشِ نَ، عٍ عِتٍ نْنفْن سُولِ. تّتّ وُرِ سَنبُنيِيٍ، ");
INSERT INTO susa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","هْرْ مْلِنفِرَ يِرَبَسٍ بِرِن، نُن تّتّ لُوتِ شِرِ مَ سٍ نَشٍيٍ مَ، نَ بِرِن يَءِلَنمَ وُرٍ فبٍيلِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«عِ شَ عِسِرَيِلَكَيٍ يَامَرِ، عٍ شَ قَ عٌلِوِ تُرٍ قَنيِ رَ عِ شْن مَ، عَلَكٌ هْرْ مْلِنفِرَ لَنثُييٍ شَ دّشّ تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","هَرُنَ نُن عَ شَ دِيٍ شَ نَ لَنثُييٍ رَدّشّ، نَشٍيٍ نَ هْرْ مْلِنفِرَ كُي، ﭑ عِ لِمَ دّننَشّ، يِرٍ سّنِيّنشِ قِسَمَنتٍ يَ رَ، دُفِ فبَكُشِ دّننَشّ سَاتّ كَنكِرَ يَ رَ. نَ لَنثُييٍ شَ يَنبَ عَلَتَلَ يَ شْرِ كٍلِقٍ كْي هَن فّيسّفّ. سّرِيّ نَن نَ كِ عِسِرَيِلَ بْنسْي بِرِن بّ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«عِ شَ عِ تَارَ هَرُنَ تٌنفٌ عِسِرَيِلَكَيٍ يَ مَ، عَ نُن عَ شَ دِيٍ نَدَبٌ، عَبِهُ، عٍلٍيَسَرِ، نُن عِتَمَرِ، عٍ شَ سّرّشّدُبّ وَلِ رَبَ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","عِ شَ سٌسٍ سّنِيّنشِيٍ دّفّ عِ تَارَ هَرُنَ بّ، نَشٍيٍ عَ شَ كُنتِفِيَ نُن عَ بِنيّ مَسٍنمَ. ");
INSERT INTO susa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","عِ شَ نَ وَلِ سٌ مِشِيٍ يِ رَ ﭑ نَشٍيٍ كِشِ شَشِلِ قَنيِ رَ، نَشَن عَ نِيَمَ عٍ شَ قَتَ. عٍ شَ هَرُنَ شَ سّرّشّدُبّ سٌسٍيٍ دّفّ، عَلَكٌ عَ شَ تِ ﭑ مَ سّرّشّدُبّ وَلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","سٌسٍيٍ نَن يِ كِ عٍ نَشٍيٍ دّفّمَ؛ دٌنمَ كَنكٍ رَشُنمَسٍ، دٌنمَ كُيٍ، تُنكِ رَشُنمَسٍ، دٌنمَ كُيٍ بُن مَفٌرٌي مَسْشْشِ، شُنمَسٍ نَشَن دْشْمَ عٍ شُنيِ مَ، نُن بّلّتِ. عٍ شَ نَ سٌسٍ سّنِيّنشِيٍ يَءِلَن عِ تَارَ هَرُنَ نُن عَ شَ دِيٍ بّ، عَلَكٌ عٍ شَ سّرّشّدُبّ وَلِ رَبَ ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","«دٌنمَ دّفّمَيٍ شَ فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، فّسّ فبٍيلِ، فّسّ شّيمَ دَاشِ، نُن سُوَ دُفِ مَلَن. ");
INSERT INTO susa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","عٍ شَ دٌنمَ كُيٍ دّفّ فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، فّسّ فبٍيلِ، فّسّ شّيمَ دَاشِ، نُن سُوَ دُفِ رَ. عَ شَ قِندِ وَلِ تٌقَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","عٍ شَ تُنكِ رَشُنمَسٍ قِرِن يَءِلَن، عٍ شَ عٍ دّفّ دٌنمَ كُيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","بّلّتِ قَن شَ يَءِلَن فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، فّسّ فبٍيلِ، فّسّ شّيمَ دَاشِ، نُن سُوَ دُفِ رَ عَلْ دٌنمَ كُيٍ. ");
INSERT INTO susa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","عِ شَ عٌنِشِ فّمّ قِرِن تٌنفٌ، عِ قَ يَشُبَ شَ دِيٍ شِلِيٍ مَسٌلِ عٍ مَ ");
INSERT INTO susa_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","عٍ بَرِ كِ مَ. شِلِ سٍننِ مَسٌلِ فّمّ كٍرٍن مَ، شِلِ سٍننِ مَسٌلِ فّمّ بٌورٍ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","نَ فّمّ مَسٌلِشِ قِرِنيِيٍ قِندِ مَ وَلِ تٌقَنيِ رَ، عَلْ سّبّلِ مَسٌلِمَ شُرُندّ مَ كِ نَشّ. عِ شَ شّيمَ سَ عٍ رَبِلِنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","عِ قَ نٍيٍ دّفّ تُنكِ رَشُنمَسٍيٍ مَ، عٍ شَ قِندِ حْشْ رَ سِفَ سٍيٍ رَ عِسِرَيِلَ دِيٍ شَ قٍ مَ. نَ كِ هَرُنَ قَمَ عٍ شِلِيٍ رَ ﭑ يَ عِ، عَ شَ قِندِ دُبّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","عِ نَ شّيمَ سَ عٍ رَبِلِنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","عِ شَ لُوتِ دِيٍ يَءِلَن شّيمَ رَ نَشٍيٍ فبَكُمَ عٍ رَبِلِنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«عِ شَ سّرّشّدُبّ دٌنمَ كَنكٍ رَشُنمَسٍ يَءِلَن عَ تٌقَنيِ كِ مَ. عَ قِندِ مَ كِيتِ سٍ نَن نَ. عِ شَ عَ يَءِلَن فّسّ فّرّ دَاشِ، فّسّ بُلُ دَاشِ، فّسّ فبٍيلِ، نُن سُوَ دُفِ رَ عَلْ دٌنمَ كُيٍ يَءِلَنشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","عَ شَ كُيّ نُن عَ شَ عِفبٌيَ شَ قِندِ سُشُي كٍرٍن نَ. عَ شَ قِندِ دُفِ قِرِن نَ، عَلَكٌ عَ شَ قِندِ يُبَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","عَ شَ رَشُنمَ فّمّ تٌقَنيِيٍ سَقّ نَانِ رَ. سَقّ سِنفٍ قِندِ مَ فّمّيٍ نَن نَ، نَشٍيٍ شِلِ سَرِدُوَنِ، تٌثَسِ، نُن عٍمٍرٌدٍ. ");
INSERT INTO susa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","سَقّ قِرِن ندٍ، عٍسِكَرِبُكُلُ، سَقِرِ، نُن دِيَمَن. ");
INSERT INTO susa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","سَقّ سَشَن ندٍ، عٌثَلٍ، عَفَتِ، نُن عَمٍتِسِتٍ. ");
INSERT INTO susa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","سَقّ نَانِ ندٍ، كِرٌ سٌلِتٍ، عٌنِشِ، نُن يَسِثٍ. عِ شَ شّيمَ سَ نٍيٍ بِرِن رَبِلِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","عِسِرَيِلَ شَ دِيٍ شِلِيٍ شَ مَسٌلِ نَ فّمّ قُ نُن قِرِن مَ، عَلْ سّبّلِ مَسٌلِمَ شُرُندّ مَ كِ نَشّ. كَنكَن شِلِ شَ مَسٌلِ فّمّ ندٍ مَ. عٍ قِندِ مَ عِسِرَيِلَ بْنسْي قُ نُن قِرِنيِ مَتْنشُمَ سٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","عِ شَ لُوتِ دِيٍ دّفّ نَ دٌنمَ كَنكٍ رَشُنمَسٍ مَ، نَشٍيٍ يَءِلَنشِ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","عِ شَ شُرُندّ قِرِن يَءِلَن شّيمَ رَ، عِ شَ عٍ دّفّ دٌنمَ كَنكٍ رَشُنمَسٍ مَ عَ دّ كِرِ قِرِنيِيٍ مَ عَ قُفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","نَ لُوتِ شّيمَ دَاشِيٍ شَ شِرِ نَ شُرُندّ قِرِنيِيٍ مَ، نَشٍيٍ دّفّشِ دٌنمَ كَنكٍ رَشُنمَسٍ دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","عِ مَن شَ نَ لُوتِ قِرِنيِيٍ شِرِ دٌنمَ كُيٍ تُنكِ رَشُنمَسٍيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","«عِ شَ شُرُندّ قِرِن فبّتّ يَءِلَن شّيمَ رَ، عِ نَشٍيٍ دّفّمَ دٌنمَ كَنكٍ رَشُنمَسٍ دّ كِرِيٍ مَ عَ لَبٍ رَ. عِ شَ نٍيٍ دّفّ دٌنمَ كُيٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","عِ شَ شُرُندّ قِرِن فبّتّ يَءِلَن شّيمَ رَ، عِ نَشٍيٍ دّفّمَ تُنكِ رَشُنمَسٍيٍ لَنبَنيِ مَ، دّننَشّ عِلَنمَ بّلّتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","دٌنمَ كَنكٍ رَشُنمَسٍ شَ شِرِ دٌنمَ كُيٍ مَ لُوتِ فّرّ دَاشِ رَ نَشَن نَسٌمَ شُرُندّيٍ كُي نَشٍيٍ دّفّشِ دٌنمَ كَنكٍ رَشُنمَسٍ نُن دٌنمَ كُيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«هَرُنَ نَ سٌ هْرْ مْلِنفِرَ كُي، عِسِرَيِلَ بْنسْي شِلِ بِرِن سّبّشِ عَ شَ دٌنمَ كَنكٍ رَشُنمَسٍ مَ، نَشَن سَشِ عَ كَنكٍ قَرِ سٌندٌنيِ يَءِلَنيِ، عَ قِندِ مَ دُبّ رَ عَلَتَلَ بّ عِسِرَيِلَ شَ قٍ رَ تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","عِ شَ فّمّ قِرِن سَ نَ دٌنمَ كَنكٍ رَشُنمَسٍيٍ كُي، نَشَن سَشِ هَرُنَ كَنكٍ قَرِ سٌندٌنيِ مَبِرِ. نٍيٍ قِندِشِ عَلَ وَشْنقٍ مَسٍن سٍ نَن نَ. هَرُنَ نَ سٌ عَلَتَلَ يِرٍ، عَ نْمَ عَلَتَلَ وَشْنقٍ كٌلٌندٍ عِسِرَيِلَكَيٍ شَ قٍ رَ نٍيٍ سَابُي رَ.» ");
INSERT INTO susa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«عِ شَ سّرّشّدُبّ شَ دٌنمَ كُيٍ بُن مَفٌرٌي سْشْ فّسّ فّرّ دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","عِ شَ عَ شُنيِ رَ سٌدٍ شَبَ عَ تَفِ، عِ شَ نَ سٌدٍ دّ مَسْشْ، عَلَكٌ بْودٍ يٌ نَشَ لُ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","عِ شَ عَ رَشُنمَ ثِرِنتِ فّرّ دَاشِ، بُلُ دَاشِ، نُن فبٍيلِ رَ نَشٍيٍ مِسَالِشِ وُرِ بٌفِ رَ عَ رَبِلِنيِ بِرِن مَ. عِ شَ تْلْنيِ شّيمَ دَاشِيٍ دّفّ نَ ثِرِنتِيٍ تَفِ، ");
INSERT INTO susa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","عَلَكٌ تْلْنيِ ندٍ شَ لُ وُرِ بٌفِ بِرِن تَفِ نَ دٌنمَ كُيٍ بُن مَفٌرٌي سَنبُنيِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","هَرُنَ نَ عَ رَفٌرٌ عَ مَ عَ سٌ تّمُي نُن عَ مِنِ تّمُي عَلَتَلَ شَ هْرْ مْلِنفِرَ كُي، نَ نَن عَ رَتَنفَمَ قَشّ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«عِ شَ شّيمَ يَءِلَن، عَ سّبّ عَ مَ، ‹عَلَتَلَ فبٍ›، ");
INSERT INTO susa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","عِ قَ عَ شِرِ شُنمَسٍ قَرِ لُوتِ فّرّ دَاشِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","عَلَكٌ عَ شَ فبَكُ عَ تِفِ رَ. شَ عَ سَ لِ سّرّشّ مُ نُ بَشِ سّرِيّ كِ مَ، نَ كٌتٍ لُمَ هَرُنَ نَن مَ، كْنْ نَ سّبّلِ نَشَن فبَكُشِ عَ تِفِ رَ عَ نِيَمَ نّ عَلَتَلَ شَ نَ سّرّشّ سُشُ.» ");
INSERT INTO susa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«عِ شَ دٌنمَ كُيٍ بُن مَفٌرٌي فبّتّ دّفّ هَرُنَ بّ سُوَ دُفِ رَ، عَ نُن شُنمَسٍ نَشَن سَمَ عَ شُن مَ. عِ شَ عَ شَ بّلّتِ مَسْشْ عَ تٌقَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","عِ شَ دٌنمَ كُيٍ بُن مَفٌرٌي، بّلّتِيٍ، نُن شُنمَسٍيٍ دّفّ هَرُنَ شَ دِيٍ قَن بّ، نَشٍيٍ عٍ شَ بِنيّ نُن عٍ شَ كُنتِفِيَ مَسٍنمَ. ");
INSERT INTO susa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","عِ شَ عِ تَارَ هَرُنَ نُن عَ شَ دِيٍ مَشِرِ نَ كِ، بٍينُن عِ شَ عٍ تِ ﭑ مَ سّرّشّدُبّ وَلِ رَبَدٍ. عِ شَ تُرٍ مَسٌ عٍ شُنيِ مَ، عِ قَ عٍ مَسٍن حَمَ بّ عٍ بَرَ قِندِ سّرّشّدُبّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","عِ شَ وَنتَنيِ دّفّ سُوَ دُفِ رَ نَشَن كٍلِمَ عٍ تَفِ هَن عٍ تَبٍ عَلَكٌ عٍ شَ سُتُرَ. ");
INSERT INTO susa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","هَرُنَ نُن عَ شَ دِيٍ شَ نَ مْولِ سٌ عٍ مَ عٍ مَكْرّ مَ سّرّشّبَدٍ رَ تّمُي نَشّ، شَ نَ مُ عَ رَ عٍ نَ هْرْ مْبَنشِ كُي لِ تّمُي نَشّ، ﭑ عِ لِمَ دّننَشّ. نَ نَن عَ نِيَمَ عٍ مُ يُنُبِ سْتْمَ، عٍ تَنفَمَ نّ قَشّ مَ. سّرِيّ نَ عَ رَ نَشَن مُ كَنَمَ عَبَدَن هَرُنَ نُن عَ بْنسْي بِرِن بّ.» ");
INSERT INTO susa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«عِ نَ وَ مِشِ تِقٍ ﭑ مَ سّرّشّدُبّ وَلِ رَبَقٍ رَ، عِ شَ تُورَ نُن يّشّي كٌنتٌنيِ قِرِن تٌنفٌ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ، ");
INSERT INTO susa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","عَ نُن تَامِ لّبِنِتَرٍ، تَامِ لّبِنِتَرٍ تُرٍ مَسُنبُشِ نَشَن نَ، نُن تَامِ لّبِنِتَرٍ شُنشُرِ تُرٍ مَسٌشِ نَشَن مَ. عِ شَ نَ بِرِن نَبَ سَنسِ شْرِ لُشُتَشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","عِ شَ نَ تَامِ بِرِن سَ دٍبٍ كُي، عِ عَ شَنِن هْرْ مْلِنفِرَ يِرٍ، عَ نُن تُورَ، نُن يّشّي كٌنتٌنيِ قِرِن. ");
INSERT INTO susa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","عِ شَ هَرُنَ نُن عَ شَ دِيٍ تِ سّرّشّدُبّ وَلِ رَ هْرْ مْلِنفِرَ سٌدٍ، ﭑ عٍ لِمَ دّننَشّ. عِ نَ فّ عٍ مَشَدٍ يٍ رَ عٍ رَ سّنِيّنقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","عِ شَ هَرُنَ شَ سّرّشّدُبّ سٌسٍيٍ رَفٌرٌ عَ مَ، عَ شَ دٌنمَ بُن مَفٌرٌي، عَ شَ دٌنمَ كُيٍ بُن مَفٌرٌي، عَ شَ دٌنمَ كُيٍ، عَ شَ دٌنمَ كَنكٍ رَشُنمَسٍ رَ، نُن عَ شَ بّلّتِ دٌنمَ كَنكٍ رَشُنمَسٍ شِرِ مَ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","عِ شَ شُنمَسٍ دْشْ عَ شُنيِ مَ، عِ قَ نَ تْنشُمَ شّيمَ دَاشِ شِرِ نَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","عِ شَ تُرٍ سّنِيّنشِ سُرُ سُرُ عَ شُنيِ مَ عَ تِقٍ سّرّشّدُبّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","عِ نَ فّ نَ رَ، عِ شَ سّرّشّدُبّ دٌنمَ كُيٍ بُن مَفٌرٌي رَفٌرٌ هَرُنَ شَ دِيٍ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","عِ شَ هَرُنَ نُن عَ شَ دِيٍ تَفِ عِشِرِ بّلّتِ رَ، عِ شَ شُنمَسٍ دْشْ عٍ شُنيِ مَ. عِ هَرُنَ نُن عَ شَ دِيٍ تِمَ سّرّشّدُبّيٍ رَ نَ كِ نّ. نَ شَ قِندِ سّرِيّ رَ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«عِ شَ تُورَ ندٍ شَنِن هْرْ مْلِنفِرَ سٌدٍ دّ رَ، ﭑ عِ لِمَ دّننَشّ. هَرُنَ نُن عَ شَ دِيٍ نَ عٍ بّلّشّ سَ عَ شُنيِ، ");
INSERT INTO susa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","عِ شَ نَ تُورَ كْن نَشَبَ عَلَتَلَ يَ شْرِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، ﭑ عِ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","عِ شَ نَ تُورَ وُلِ تٌنفٌ، عِ ندٍ سَ سّرّشّبَدٍ قٍرِ نَانِ مَ عِ بّلّشّسٌلٍ رَ. وُلِ نَشَن لُشِ، عِ شَ نَ عِقِلِ سّرّشّبَدٍ سَنبُنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","عِ نَ فّ نَ رَ، عِ شَ نَ تُورَ تُرٍ تٌنفٌ نَشَن نَ عَ قُرِنفّ مَ، عَ لَارٍ نَشَن عَ بْحّ مَكٌتٌشِ، عَ فُنفُييٍ نُن تُرٍ نَشَن نَ عٍ مَ، عِ شَ نَ بِرِن فَن سّرّشّ رَ سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","كْنْ عَ سُبٍ، عَ كِرِ، نُن عَ شَ حَحّ، عِ شَ نٍيٍ فَن تَا قَرِ مَ، بَرِ مَ يُنُبِ شَقَرِ سّرّشّ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«عِ نَ فّ نَ رَ، عِ شَ يّشّي كٌنتٌنيِ كٍرٍن تٌنفٌ. هَرُنَ نُن عَ شَ دِيٍ عٍ شَ عٍ بّلّشّ سَ عَ شُنيِ، ");
INSERT INTO susa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","عِ قَ عَ كْن نَشَبَ. عِ شَ عَ وُلِ تٌنفٌ، عِ عَ عِقِلِ سّرّشّبَدٍ رَبِلِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","عِ شَ نَ يّشّي كٌنتٌنيِ بٌلٌن عَ شُنتُنيِ رَ. عِ شَ عَ قُرِنفّ نُن عَ سَنيِيٍ مَشَ، عِ قَ عٍ مَلَن عَ سُبٍ نُن عَ شُنيِ قَرِ، ");
INSERT INTO susa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","عِ نَ بِرِن فَن سّرّشّبَدٍ قَرِ. سّرّشّ فَن دَاشِ نَن نَ كِ عَلَتَلَ بّ، نَشَن نَقَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«عِ نَ فّ نَ سِنفٍ رَ، عِ شَ نَ يّشّي كٌنتٌنيِ قِرِن ندٍ تٌنفٌ. هَرُنَ نُن عَ شَ دِيٍ نَ عٍ بّلّشّ سَ عَ شُنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","عِ شَ عَ كْن نَشَبَ. عِ شَ نَ وُلِ تٌنفٌ، عِ ندٍ سَ هَرُنَ نُن عَ شَ دِيٍ يِرٍقَنيِ تُلِ كِرِيٍ مَ، عٍ يِرٍقَنيِ بّلّشّ، نُن سَنكُرَيٍ مَ. وُلِ نَشَن لُشِ، عِ شَ نَ عِقِلِ سّرّشّبَدٍ رَبِلِنيِ. ");
INSERT INTO susa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","عِ شَ وُلِ ندٍ تٌنفٌ سّرّشّبَدٍ قَرِ، عَ نُن تُرٍ ندٍ نَشَن نَوَلِشِ مِشِ تِقٍ سّرّشّدُبّ رَ، عِ شَ نٍيٍ كَسَن هَرُنَ، عَ شَ دِيٍ، نُن عٍ شَ دُفِيٍ مَ. نَ كُي هَرُنَ نُن عَ شَ دِيٍ بَرَ تِ سّرّشّدُبّيٍ رَ، عٍ شَ دُفِيٍ قَن بَرَ قِندِ سّرّشّدُبّ دُفِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«عِ شَ يّشّي كٌنتٌنيِ تُرٍ تٌنفٌ، عَ نُن عَ شُلِ، عَ تُرٍ نَشَن نَ عَ قُرِنفّ مَ، عَ لَارٍ نَشَن عَ بْحّ مَكٌتٌشِ، عَ فُنفُييٍ نُن تُرٍ نَشَن عٍ مَكٌتٌشِ، عَ نُن عَ يِرٍقَنيِ تَبٍ، بَرِ مَ سّرّشّ نَ عَ رَ نَشَن عَ نِيَمَ مِشِ شَ تِ سّرّشّدُبّ وَلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","عِ شَ نَ دٍبٍ تٌنفٌ تَامِ لّبِنِتَرٍ نَ نَشَن كُي نَشَن قِشِ عَلَتَلَ مَ. نَ كُي عِ شَ تَامِ دِفِلِنشِ كٍرٍن تٌنفٌ، عَ نُن تَامِ لّبِنِتَرٍ تُرٍ مَسُنبُشِ نَشَن نَ، نُن تَامِ لّبِنِتَرٍ شُنشُرِ ندٍ، ");
INSERT INTO susa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","عِ شَ نٍيٍ سَ هَرُنَ نُن عَ شَ دِيٍ بّلّشّ، عِ نٍيٍ لِنتَن عَلَتَلَ يَ عِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","نَ دَنفِ شَنبِ، عِ شَ عٍ بَ عٍ بّلّشّ، عِ عٍ سَ سّرّشّ فَن دَاشِ قَرِ سّرّشّبَدٍ. سّرّشّ فَنشِ نَ عَ رَ نَشَن نَقَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«عِ شَ يّشّي كٌنتٌنيِ كَنكٍ تٌنفٌ، نَشَن بَشِ هَرُنَ بّ، عِ عَ لِنتَن عَلَتَلَ يَ عِ سّرّشّ رَ، عَ شَ قِندِ عِ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","نَ كَنكٍ نُن نَ تَبٍ عِ نَشَن لِنتَنشِ عَلَتَلَ يَ عِ سّرّشّ رَ سّرّشّدُبّيٍ تِقٍ شَ قٍ رَ، ");
INSERT INTO susa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","نٍيٍ بَرَ قِندِ هَرُنَ نُن عَ شَ دِيٍ فبٍ رَ. سّرِيّ نَن نَ كِ عِسِرَيِلَكَيٍ بّ نَشَن مُ كَنَمَ عَبَدَن. عٍ لَن نّ عٍ شَ نَ مْولِ بَ عٍ شَ شَنُنتٍيَ سّرّشّ بِرِن مَ، عٍ عَ قِ عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«هَرُنَ نَ قَشَ، عَ شَ سّرّشّدُبّ سٌسٍ رَدَنفِمَ عَ شَ دِيٍ نَن مَ. عٍ تِ تّمُي نَ وَلِ رَ، عٍ شَ عٍ رَفٌرٌ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","هَرُنَ شَ دِ نَشَن قِندِ مَ عَ حْشْي رَ نَ نَن قَمَ نَ دُفِيٍ رَفٌرٌدٍ عَ مَ شِ سٌلٌقٍرٍ بُن مَ، بٍينُن عَ شَ سٌ يِرٍ سّنِيّنشِ هْرْ مْلِنفِرَ كُي، ﭑ عِ لِمَ دّننَشّ، سّرّشّدُبّ وَلِ رَبَقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«يّشّي كٌنتٌنيِ نَشَن بَشِ سّرّشّ رَ، هَرُنَ قِندِشِ سّرّشّدُبّ رَ تّمُي نَشّ، عِ شَ نَ سُبٍ حِن يِرٍ ندٍ نَشَن سّنِيّنشِ. ");
INSERT INTO susa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","نَ سُبٍ نُن نَ تَامِ نَشَن نَ دٍبٍ كُي، هَرُنَ نُن عَ شَ دِيٍ شَ نَ دٌن هْرْ مْلِنفِرَ سٌدٍ دّ رَ، ﭑ عِ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","عٍ كٍرٍن شَ نَ يُنُبِ شَقَرِ سّرّشّ دٌن، سّرّشّ نَشَن بَ عٍ بّ عٍ تِ لْشْي سّرّشّدُبّيٍ رَ. عَ مُ لَنمَ مِشِ فبّتّ شَ نَ دٌن، بَرِ مَ سٍ سّنِيّنشِ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","شَ نَ سّرّشّ سُبٍ نُن تَامِ ندٍ سَ لُ هَن فّيسّفّ، عِ شَ عَ فَن تّ شْورَ. عَ مُ دٌنمَ، بَرِ مَ سٍ سّنِيّنشِ نَن عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«عِ شَ ﭑ مَ يَامَرِيٍ رَبَتُ هَرُنَ نُن عَ شَ دِيٍ شَ قٍ رَ نَ شِ سٌلٌقٍرٍ بُن مَ عٍ تِمَ سّرّشّدُبّيٍ رَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","عِ شَ تُورَ كٍرٍن بَ لْشْ يٌ لْشْ يُنُبِ شَقَرِ سّرّشّ رَ. نَ نَن عَ تٌمَ سّرّشّبَدٍ قَن سّنِيّنمَ. نَ شَنبِ عِ شَ تُرٍ عِقِلِ سّرّشّبَدٍ قَرِ، عَلَكٌ عَ شَ قِندِ يِرٍ سُفَندِشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","عِ شَ نَ وَلِ رَبَ شِ سٌلٌقٍرٍ بُن مَ، عَلَكٌ سّرّشّبَدٍ شَ سّنِيّن، عَ مَن شَ مِشِ رَ سّنِيّن نَشَن دِنمَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«لْشْ يٌ لْشْ عَ لَنمَ عِ شَ يّشّي قِرِن بَ سّرّشّ رَ سّرّشّبَدٍ قَرِ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ. نَ شَ رَبَ كُدّءِ. ");
INSERT INTO susa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","عَ سِنفٍ شَ بَ فّيسّفّ، بٌورٍ شَ بَ كْي سٌ تّمُي. ");
INSERT INTO susa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","عِ نَ نَ يّشّي سِنفٍ بَ، عِ شَ قَرِن كٌنكٌرٌنيِ سُولِ، عٌلِوِ تُرٍ لِتِرِ كٍرٍن، نُن وّنِ لِتِرِ كٍرٍن سَ نَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","عِ نَ نَ يّشّي قِرِن ندٍ بَ كْي سٌ تّمُي، عِ شَ سَنسِ بٌفِ ندٍ نُن وّنِ سَ عَ قَرِ عَلْ فّيسّفّ دَاشِ. عِ شَ نٍيٍ بَ سّرّشّ فَن دَاشِ رَ، نَشَن نَقَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","سّرّشّ فَن دَاشِ مْولِ نَن عَ رَ، عِ بْنسْي لَنمَ عَ شَ نَشَن بَ ﭑ تَن عَلَتَلَ بّ عَبَدَن. عَ بَمَ هْرْ مْلِنفِرَ سٌدٍ دّ نَن نَ ﭑ تَن عَلَتَلَ يَ شْرِ، ﭑ وٌ لِمَ دّننَشّ، ﭑ وْيّنمَ وٌ بّ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","«ﭑ نَن ﭑ يّتّ مَسٍنمَ عِسِرَيِلَكَيٍ بّ مّننِ ﭑ مَ نْرّ كُي، نَشَن مّننِ رَ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ﭑ نَن ﭑ مَ هْرْ مْلِنفِرَ نُن ﭑ مَ سّرّشّبَدٍ رَ سّنِيّنمَ نّ، ﭑ عِ لِمَ دّننَشّ. ﭑ هَرُنَ نُن عَ شَ دِيٍ رَ سّنِيّنمَ نّ، عَلَكٌ عٍ شَ ﭑ مَ سّرّشّدُبّ وَلِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ﭑ سَبَتِمَ نّ عِسِرَيِلَكَيٍ تَفِ، ﭑ مَن قِندِ مَ نّ عٍ مَرِفِ عَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","نَ كُي عٍ عَ كٌلٌنمَ نّ ﭑ تَن نَن عَلَتَلَ رَ، عٍ مَرِفِ عَلَ، نَشَن عٍ رَ مِنِ مِسِرَ بْشِ رَ، عَلَكٌ ﭑ شَ سَبَتِ عٍ تَفِ. عَلَتَلَ نَن ﭑ تَن نَ، عٍ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«عِ شَ سُرَيِ سّرّشّبَدٍ يَءِلَن كَسِيَ وُرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","عَ شَ كُيَ نْنفْن كٍرٍن، عَ عِفبٌ نْنفْن كٍرٍن، عَ عِتٍ نْنفْن قِرِن. قٍرِ نَانِ شَ لُ عَ تُشُييٍ رَ، عٍ نُن سّرّشّبَدٍ قِندِشِ سٍ كٍرٍن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","عِ شَ نَ سّرّشّبَدٍ بِرِن مَسٌ شّيمَ شِندٍ رَ، عَ قَرِ، عَ سّيتِيٍ، عَ قٍرِيٍ، نُن عَ دّ كِرِ. ");
INSERT INTO susa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","عِ شَ سُشُسٍ دِفِلِنشِ قِرِن يَءِلَن شّيمَ رَ سّرّشّبَدٍ سّيتِ قِرِنيِيٍ مَ عَ دّ كِرِ لَبٍ رَ، وُرِ كُيٍيٍ سٌمَ نَشٍيٍ كُي عَ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","عِ شَ نَ وُرِيٍ يَءِلَن كَسِيَ وُرِ رَ، عِ قَ شّيمَ مَسٌ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","نَ سُرَيِ سّرّشّبَدٍ شَ دْشْ دُفِ يَ رَ نَشَن نَ سَاتّ كَنكِرَ يَ رَ، يُنُبِ شُنسَرٍ يِرٍ دْشْشِ نَشَن قَرِ، ﭑ مِشِ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","هَرُنَ شَ سُرَيِ شِرِ حْشُنمّ فَن مّننِ فّيسّفّ بِرِن، عَ قّنتّنمَ لَنثُييٍ مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","عَ مَن شَ نَ مْولِ رَبَ كْي سٌ تّمُي. سُرَيِ نَن عَ رَ، نَشَن لَنمَ عَ شَ فَن وَشَتِ بِرِن عَلَتَلَ يَ شْرِ. سّرِيّ نَ عَ رَ وٌ بْنسْي بّ نَشَن مُ كَنَمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","وٌ نَشَ سٍسٍ بَ نَ سّرّشّبَدٍ قَرِ بَقٍ سُرَيِ سّنِيّنشِ رَ. وٌ نَشَ سُرَيِ سّنِيّنتَرٍ بَ، وٌ نَشَ سّرّشّ فَن دَاشِ بَ، وٌ نَشَ سَنسِ سّرّشّ بَ، وٌ نَشَ وّنِ شَ نَ مُ عَ رَ تُرٍ بَ مّننِ. ");
INSERT INTO susa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","حّ يٌ حّ هَرُنَ شَ يُنُبِ شَقَرِ سّرّشّ وُلِ ندٍ تٌنفٌ، عَ عَ مَسٌ سُرَيِ سّرّشّبَدٍ قٍرِيٍ مَ، عَلَكٌ عٍ قَن شَ سّنِيّن. سّرِيّ نَن عَ رَ عِ بْنسْي لَنمَ عَ شَ نَشَن نَبَ عَبَدَن. نَ سّرّشّبَدٍ قِندِشِ سٍ سّنِيّنشِ نَن نَ عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ؛ ");
INSERT INTO susa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«عِ نَ عِسِرَيِلَكَيٍ كْنتِ لْشْي نَشّ، بِرِن شَ عَ شُنسَرٍ قِ عَلَتَلَ مَ. نَ نَن عَ رَ، مَنكَنّ يٌ مُ عٍ لِمَ نَ كْنتِ تِقٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","مِشِ نَشَن بِرِن كْنتِمَ، عٍ شَ فبٍتِ فِرَ مُ سٍننِ قِ عَلَتَلَ مَ. نَ شَ مَنِيَ هْرْ مْلِنفِرَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","مِشِ نَشَن بِرِن سِمَيَ بَرَ حّ مْشْحّن لِ، عَ شَ عَ شُنسَرٍ قِ عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","بَننَ مُ سٍ سَمَ نَ فِرَ مُ سٍننِ شُن مَ، مِسِكِينّ قَن مُ ندٍ بَمَ نَ فِرَ مُ سٍننِ رَ. بِرِن شَ نَ قِ عَلَتَلَ مَ عٍ شُنسَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","عِسِرَيِلَكَيٍ نَ نَ فبٍتِ سٌ عِ يِ رَ، عِ شَ عَ رَوَلِ هْرْ مْلِنفِرَ يَءِلَنقٍ رَ، ﭑ عِ لِمَ دّننَشّ، عَلَكٌ ﭑ شَ رَتُ عَ مَ عِسِرَيِلَكَيٍ نَشَن قِشِ عٍ شُنسَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","نَ دَنفِ شَنبِ عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«عِ شَ هْرْ مْلِنفِرَ يٍ سَسٍ شُنفبٍ يَءِلَن وُرٍ فبٍيلِ رَ، عَ نُن عَ دْشْسٍ. عِ شَ نَ دْشْ هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ تَفِ، عِ قَ مَرَ سّنِيّن يٍ سَ عَ كُي، ");
INSERT INTO susa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","هَرُنَ نُن عَ شَ دِيٍ نَشَن نَوَلِمَ عٍ بّلّشّيٍ نُن عٍ سَنيِيٍ مَشَقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","بٍينُن عٍ شَ سٌ هْرْ مْلِنفِرَ كُي، ﭑ وٌ لِمَ دّننَشّ، عَ لَنمَ عٍ شَ عٍ بّلّشّيٍ نُن عٍ سَنيِيٍ مَشَ نَ يٍ رَ، عَلَكٌ عٍ نَشَ قَشَ. بٍينُن عٍ شَ عٍ مَكْرّ سّرّشّبَدٍ رَ سّرّشّ فَن دَاشِ بَقٍ عَلَتَلَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","عَ لَنمَ عٍ شَ عٍ بّلّشّيٍ نُن عٍ سَنيِيٍ مَشَ نَ يٍ رَ، عَلَكٌ عٍ نَشَ قَشَ. سّرِيّ نَن نَ رَ عٍ بْنسْي بِرِن بّ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«عِ شَ سٍ شِرِ حْشُنمّ قَنيِيٍ تٌنفٌ، عَلْ وُرِ وَ يٍ نَشَن شِلِ مِرِ كِلٌ سُولِ، وُرِ قُحِ نَشَن شِلِ سِنَمٌن كِلٌ قِرِن نُن عَ تَفِ، كَلٍ ندٍ كِلٌ قِرِن نُن عَ تَفِ نَشَن شِرِ حْشُن، ");
INSERT INTO susa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","كَسِيَ وُرِ قُحِ كِلٌ سُولِ، نُن عٌلِوِ تُرٍ لِتِرِ سٍننِ. ");
INSERT INTO susa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","عِ شَ نَ بِرِن يَءِلَن تُرٍ سّنِيّنشِ رَ نَشَن نَوَلِمَ سّرّشّدُبّ تِقٍ رَ. نَ وَلِ شَ رَبَ عَ قَنيِ رَ عَ رَبَ كِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","«عِ مَن شَ نَ تُرٍ رَوَلِ هْرْ مْلِنفِرَ نُن سَاتّ كَنكِرَ رَ سّنِيّنقٍ رَ، ﭑ وٌ لِمَ دّننَشّ، ");
INSERT INTO susa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","عَ نُن هْرْ مْلِنفِرَ تٍيبِلِ، عَ يِرَبَسٍيٍ، لَنثُي دْشْسٍ، عَ يِرَبَسٍيٍ، سُرَيِ سّرّشّبَدٍ، ");
INSERT INTO susa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","سّرّشّبَدٍ شُنفبٍ، عَ يِرَبَسٍيٍ، هْرْ مْلِنفِرَ يٍ سَسٍ شُنفبٍ، نُن عَ دْشْسٍ. ");
INSERT INTO susa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","عِ شَ نَ تُرٍ سّنِيّنشِ رَوَلِ نَ بِرِن نَسّنِيّنقٍ رَ. مِشِ نَشٍيٍ دِنمَ نٍيٍ رَ، عٍ سّنِيّنمَ نّ. ");
INSERT INTO susa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","عِ شَ نَ تُرٍ سّنِيّنشِ رَوَلِ هَرُنَ نُن عَ شَ دِيٍ تِقٍ ﭑ مَ سّرّشّدُبّيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«عِ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ عَ نَ تُرٍ قِندِشِ تُرٍ سّنِيّنشِ نَن نَ وٌ بْنسْي بّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","وٌ نَشَ عَ سَ مِشِ قَتٍ مَ، وٌ نَشَ نَ تُرٍ مْولِ يَءِلَن وَلِ فبّتّ شَ قٍ رَ. تُرٍ سّنِيّنشِ نَن عَ رَ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","مِشِ يٌ نَشَن نَ نَ تُرٍ مْولِ رَقَلَ، عَ عَ سَ مِشِ سّنِيّنتَرٍ مَ، نَ كَنيِ بَمَ نّ حَمَ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ سٍ شِرِ حْشُنمّيٍ تٌنفٌ، عَلْ سِتَكِتٍ، عٌنِشِ، نُن فَلِبَنٌن. عِ شَ عٍ مَسُنبُ سُرَيِ قَنيِ رَ، عٍ شَسَبِ بِرِن شَ لَن. ");
INSERT INTO susa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","نَ قِندِ مَ سُرَيِ رَ نَشَن شِرِ حْشُن كِ قَنيِ رَ. قْشّ دِ شَ سَ عَ مَ. سُرَيِ سّنِيّنشِ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","عِ شَ نَ سُرَيِ قِندِ قُحِ رَ عِ نَشَن سَمَ سَاتّ كَنكِرَ يَ رَ هْرْ مْلِنفِرَ كُي ﭑ عِ لِمَ دّننَشّ. سٍ سّنِيّنشِ نَ عَ رَ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","وٌ نَشَ يِ سُرَيِ مْولِ رَقَلَ وٌ يّتّ بّ. سٍ سّنِيّنشِ نَ عَ رَ، وٌ نَشَن نَوَلِمَ عَلَتَلَ فبَنسَن بّ. ");
INSERT INTO susa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","مِشِ يٌ نَشَن نَ نَ مْولِ رَقَلَمَ عَ يّتّ بّ عَ شَ نَ شِرِ رَ مّ، نَ كَنيِ كٍرِ مَ نّ عَ شَ حَمَ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«عِ شَ عَ كٌلٌن ﭑ بَرَ عُرِ شَ دِ بٍسَلٍلِ سُفَندِ، شُرُ شَ مَمَدِ، نَشَن قَتَنشِ يُدَ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ﭑ بَرَ شَشِلِ قَنيِ قِ عَ مَ نَشَن قَتَنشِ ﭑ تَن نَ، عَلَكٌ عَ شَ وَلِ بِرِن نَبَ كِ كٌلٌن لْننِ قَنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","عَ شَ نْ وَلِ تٌدٍ عَ شَشِلِ كُي بٍينُن عَ شَ رَبَ، عَ شَ نْ شّيمَ، فبٍتِ، نُن وُرٍ فبٍيلِ رَوَلِدٍ، ");
INSERT INTO susa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","عَ شَ نْ فّمّ قَنيِ مَسٌلِدٍ عَ قَ عَ رَبِلِنيِ يَءِلَن، عَ شَ نْ كَمُدّرِحَ نُن وَلِ فبّتّيٍ رَبَدٍ.» ");
INSERT INTO susa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«ﭑ بَرَ عٌهٌلِيَبُ عَشِسَمَكِ شَ دِ سٌ عَ يِ رَ، نَشَن قَتَنشِ دَنَ بْنسْي رَ، عَ شَ عَ مَلِ. ﭑ بَرَ شَشِلِ قَنيِ قِ مِشِيٍ مَ، نَشٍيٍ قَتَ وَلِدٍ، عَلَكٌ عٍ شَ نْ ﭑ مَ يَامَرِ بِرِن نَبَدٍ، ");
INSERT INTO susa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","عَلْ هْرْ مْلِنفِرَ ﭑ عَدَ مَدِ لِمَ دّننَشّ، سَاتّ كَنكِرَ، عَ دّرَكٌتٍ نَشَن قِندِشِ شُنسَرٍ يِرٍ رَ، نُن هْرْ مْلِنفِرَ يِرَبَسٍ بِرِن، ");
INSERT INTO susa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","تٍيبِلِ، تٍيبِلِ يِرَبَسٍيٍ، لَنثُي دْشْسٍ شّيمَ دَاشِ، لَنثُي يِرَبَسٍيٍ، سُرَيِ سّرّشّبَدٍ، ");
INSERT INTO susa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","سّرّشّبَدٍ شُنفبٍ نُن عَ شَ يِرَبَسٍيٍ، يٍ سَسٍ شُنفبٍ نُن عَ دْشْسٍ، ");
INSERT INTO susa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","سّرّشّدُبّ سٌسٍ سّنِيّنشِيٍ هَرُنَ نُن عَ شَ دِيٍ بّ، ");
INSERT INTO susa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","تُرٍ سّنِيّنشِ، نُن سُرَيِ نَشَن فَنمَ هْرْ مْلِنفِرَ كُي. عٍ شَ عَ بِرِن يَءِلَن ﭑ مَ يَامَرِ كِ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«عَ قَلَ عِسِرَيِلَكَيٍ بّ عَ عٍ شَ عٍ حّنفِ سَ ﭑ مَ مَلَبُي لْشْييٍ شْن مَ، بَرِ مَ نٍيٍ قِندِ مَ تْنشُمَ رَ وٌن تَفِ عَبَدَن، عَلَكٌ وٌ شَ عَ كٌلٌن عَ ﭑ تَن نَن نَ عَلَتَلَ رَ نَشَن وٌ رَ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","وٌ شَ وٌ حّنفِ سَ مَلَبُي لْشْي شْن مَ، بَرِ مَ عَ سّنِيّن وٌ تَن بّ. شَ نَشَن مُ عَ بِنيَ، عَ لَن نّ نَ كَنيِ شَ قَشَ. مِشِ نَشَن وَلِمَ مَلَبُي لْشْي، نَ كَنيِ شَ كٍرِ ﭑ مَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","شِ سٍننِ نَ وٌ يِ رَ وَلِقٍ رَ، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ قِندِ مَ مَلَبُي لْشْي نَن نَ، نَشَن قِمَ عَلَتَلَ مَ. مِشِ نَشَن وَلِمَ نَ لْشْي، نَ كَنيِ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","عِسِرَيِلَكَيٍ شَ عٍ حّنفِ سَ مَلَبُي لْشْي شْن مَ، عٍ عَ رَبَتُ وَشَتِ بِرِن. سَاتّ نَ عَ رَ نَشَن مُ كَنَمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","عَ قِندِ مَ تْنشُمَ نَن نَ، ﭑ تَن نُن عِسِرَيِلَكَيٍ تَفِ تّمُي بِرِن، بَرِ مَ ﭑ تَن عَلَتَلَ، ﭑ كٌورٍ نُن بْشِ دَاشِ شِ سٍننِ نَن بُن مَ، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ، ﭑ نَشَ وَلِ دَن، ﭑ نَن ﭑ مَلَبُ.» ");
INSERT INTO susa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","عَلَتَلَ تٌ فّ مَسٍنيِ تِدٍ مُنسَ بّ تُرُ سِنِنَ فٍيَ قَرِ، عَ نَشَ فّمّ وَلَشّ قِرِن سٌ عَ يِ رَ سٍيدٍ رَ، عَ شَ يَامَرِيٍ نُ سّبّشِ نَشٍيٍ مَ عَ بّلّشّ سٌلٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","عِسِرَيِلَكَيٍ تٌ عَ تٌ، مُنسَ بَرَ بُ فٍيَ قَرِ، حَمَ نَشَ عٍ مَلَن هَرُنَ يِرٍ، عٍ قَ عَ قَلَ عَ بّ، «عِ شَ كُيٍ يَءِلَن نَشَن تِمَ مُشُ يَ رَ. مُنسَ نَشَن مُشُ رَ مِنِشِ مِسِرَ بْشِ رَ، مُشُ مُ عَ كٌلٌن قٍ نَشَن عَ سْتْشِ فٍيَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","هَرُنَ نَشَ عٍ يَابِ، «لَنفَ شّيمَ دَاشِ نَشَن بِرِن نَ وٌ شَ فِنّيٍ نُن وٌ شَ دِيٍ تُلِيٍ رَ، وٌ قَ عٍ بِرِن نَ ﭑ شْن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","عِسِرَيِلَ حَمَ بِرِن نَشَ عٍ شَ لَنفَ شّيمَ دَاشِيٍ بَ عٍ تُلِيٍ رَ، عٍ قَ عٍ سٌ هَرُنَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","هَرُنَ نَشَ نَ شّيمَ رَشُنُ، عَ نِنفٍ كُيٍ دَاشِ يَءِلَن عَ رَ. عَ تٌ فّ نَ رَ، عٍ نَشَ عَ قَلَ عٍ شُي عِتٍشِ رَ، «عِسِرَيِلَكَيٍ، وٌن مَ عَلَ نَن يَ نَشَن وٌن نَمِنِشِ مِسِرَ بْشِ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","هَرُنَ تٌ نَ تٌ، عَ نَشَ سّرّشّبَدٍ يَءِلَن نَ نِنفٍ كُيٍ دَاشِ يَ رَ، عَ قَ عَ قَلَ عَ شُي عِتٍشِ رَ، «تِنَ، شُلُنيِ تِمَ نّ عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","نَ كُيٍ عِبَ، عٍ نَشَ كٍلِ سُبَشّ مَ، عٍ سّرّشّ فَن دَاشِ نُن شَنُنتٍيَ سّرّشّ بَ. مِشِيٍ نَشَ عٍ دّفٍ، عٍ مِنسٍيٍ مِن، عٍ قَ عٍ وَشْنقٍ رَبَ. ");
INSERT INTO susa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","نَ تّمُي عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ فٌرٌ حَمَ يِرٍ، بَرِ مَ عِ نَشٍيٍ نَمِنِ مِسِرَ بْشِ كُي، عٍ بَرَ قٍ كَنَ عَ حَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","عٍ بَرَ ﭑ مَ كِرَ بّحِن يِ عِكْرّشِ رَ، عٍ بَرَ نِنفٍ كُيٍ دَاشِ يَءِلَن وُرٍ رَشُنُشِ رَ، عٍ نَ بَتُ، عٍ سّرّشّيٍ بَ عَ بّ، عٍ عَ قَلَ، ‹عِسِرَيِلَكَيٍ، وٌن مَ عَلَ نَن يَ نَشَن وٌن نَمِنِشِ مِسِرَ بْشِ كُي.› ");
INSERT INTO susa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ﭑ تَن عَلَتَلَ ﭑ شَ عَ مَسٍن عِ بّ، يِ حَمَ، حَمَ شُرُتَرٍ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","وٌن نَشَن نَبَمَ، عَ لُ ﭑ شَ عٍ سْنتْ ﭑ مَ شْنّ كُي، كْنْ عِ تَن، عِ شَ مَكُيَ عٍ رَ، ﭑ شَ عِ قِندِ سِ شُنفبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","نَ كُي مُنسَ نَشَ عَلَتَلَ مَشَندِ، «عَلَتَلَ، مُنقٍ رَ عِ وَ مَ شْنْقٍ عِ شَ حَمَ مَ، عِ سّنبّ نَشَن نَمِنِشِ مِسِرَ بْشِ رَ؟ ");
INSERT INTO susa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","شَ عِ نَ رَبَ، مِسِرَكَيٍ قَمَ عَ قَلَدٍ عَ عِ يِ حَمَ رَ مِنِشِ مِسِرَ بْشِ كُي نّ عَلَكٌ عِ شَ عٍ قَشَ فٍيَيٍ قَرِ، عٍ شَ قٍ شَ حْن دُنِحَ. ﭑ بَرَ عِ مَشَندِ، عِ بْحّ مَفٌرٌ، ﭑ مَرِفِ. عِ نَشَ يِ حَمَ سْنتْ. ");
INSERT INTO susa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","عِ رَتُ عِ شَ كٌنيِيٍ عِبُرَهِمَ، عِسِيَفَ، نُن عِسِرَيِلَ مَ، عِ كَلِشِ نَشٍيٍ رَ، عَ قَلَقٍ رَ، ‹ﭑ وٌ بْنسْي رَوُيَمَ نّ عَلْ تُنبُي نَشٍيٍ نَ كٌورٍ مَ. ﭑ بْشِ قِمَ وٌ بْنسْي مَ كّ رَ نَشَن مُ بَمَ وٌ يِ رَ عَبَدَن.›» ");
INSERT INTO susa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","نَ تّمُي عَلَتَلَ بْحّ نَشَ فٌرٌ، عَ مُ عَ شَ حَمَ سْنتْ سْنْن. ");
INSERT INTO susa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","مُنسَ نَشَ فٌرٌ فٍيَ قَرِ نَ سٍيدٍ وَلَشّ قِرِنيِيٍ سُشُشِ عَ يِ رَ، سّبّلِ تِشِ نٍيٍ سّيتِ قِرِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","عَلَ نَن نَ وَلَشّيٍ يَءِلَن، عَ سّبّلِ مَسٌلِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","يٌسُوٍ تٌ حَمَ شُي عِتٍشِ مّ، عَ نَشَ عَ قَلَ مُنسَ بّ، «ﭑ شُي ندٍ مّمَ حَمَ يِرٍ نَشَن لُشِ عَلْ فٍرٍ سٌ شُي.» ");
INSERT INTO susa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","مُنسَ نَشَ عَ يَابِ، «فٍرٍ فٍينِقٍ شُي مُ يَ، فٍرٍ لْو سِقٍ شُي قَن مُ عَ رَ. ﭑ شُلُنيِ شُي نَن مّمَ.» ");
INSERT INTO susa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","عٍ تٌ مَكْرّ حَمَ رَ، مُنسَ نَشَ مِشِيٍ تٌ قَرٍ بٌرٌن نَ كُيٍ يِرٍ. عَ بْحّ نَشَ تٍ هَن عَ قَ وَلَشّيٍ وٌلِ بْشِ مَ فٍيَ سَنبُنيِ، عٍ نَشَ كَنَ. ");
INSERT INTO susa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","عَ نَشَ عٍ شَ نِنفٍ كُيٍ دَاشِ وٌلِ تّ شْورَ، عَ فَن هَن عَ قِندِ شُبٍ رَ. عَ نَشَ نَ تّ شُبٍ سَ يٍ شْورَ، عَ نَ قِ عِسِرَيِلَكَيٍ مَ، عٍ شَ عَ مِن. ");
INSERT INTO susa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","عَ نَشَ قَ هَرُنَ مَشْرِن، «يِ حَمَ مُنسٍ رَبَشِ عِ رَ، نَشَن عَ نِيَشِ عِ شَ عٍ تِ يِ يُنُبِ شُنفبٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","هَرُنَ نَشَ عَ يَابِ، «ﭑ مَرِفِ، عِ نَشَ شْنْ ﭑ مَ! عِ عَ كٌلٌن يِ حَمَ بِرَ مَ قٍ كٌبِ قْشْ رَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","عٍ تَن نَن عَ قَلَشِ ﭑ بّ، ‹عِ شَ كُيٍ يَءِلَن نَشَن تِمَ مُشُ يَ رَ. مُنسَ نَشَن مُشُ رَ مِنِشِ مِسِرَ بْشِ رَ، مُشُ مُ عَ كٌلٌن قٍ نَشَن عَ سْتْشِ فٍيَ قَرِ.› ");
INSERT INTO susa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ﭑ نَشَ عَ قَلَ عٍ بّ، ‹وٌ شَ قَ وٌ شَ شّيمَ رَ.› عٍ تٌ قَ نَ شّيمَ رَ، ﭑ نَشَ عَ وٌلِ تّ شْورَ، يِ نِنفٍ كُيٍ دَاشِ قَ مِنِ.» ");
INSERT INTO susa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","مُنسَ نَشَ عَ كٌلٌن هَرُنَ حَمَ لُشِ نّ عٍ شَ عٍ وَشْنقٍ رَبَ. نَ نُ وَ مَ قِندِقٍ يَافِ رَ عِسِرَيِلَكَيٍ بّ عٍ يَشُييٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","مُنسَ نَشَ سَ تِ عٍ شَ يٌنكِندٍ سٌدٍ دّ رَ، عَ قَ عَ قَلَ عَ شُي عِتٍشِ رَ، «نَشٍيٍ نَ عَلَتَلَ بّ، وٌ شَ قَ ﭑ يِرٍ.» لٍوِ بْنسْي بِرِن نَشَ عٍ مَلَن مُنسَ شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","عَ نَشَ عَ قَلَ عٍ بّ، «عِسِرَيِلَ مَرِفِ عَلَتَلَ بَرَ وٌ يَمَرِ وٌ بِرِن شَ وٌ شَ سَنتِدّفّمَ تٌنفٌ، وٌ قَ وٌ نفَشَكٍرٍنيِ بِرِن قَشَ، عَ نُن وٌ بٌورٍيٍ نُن وٌ دْشْبٌورٍيٍ نَشٍيٍ بَرَ لُ يِ قٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","نَ لْشْي لٍوِ بْنسْي نَشَ مُنسَ شَ يَامَرِ سُشُ، عٍ قَ عِسِرَيِلَكَ مِشِ وُلُ سَشَن قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","مُنسَ نَشَ عَ قَلَ عٍ بّ، «تٌ وٌ بَرَ عَلَتَلَ وَشْنقٍ رَبَ وٌ نفَشَكٍرٍنيِيٍ قَشَقٍ. عَلَ شَ بَرَكَ سَ وٌ شَ قٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","نَ كُيٍ عِبَ، مُنسَ نَشَ عَ قَلَ حَمَ بّ، «وٌ بَرَ يُنُبِ شُنفبٍ رَبَ. ﭑ شَ فبِلٍن عَلَتَلَ يِرٍ فٍيَ قَرِ، عَلَكٌ ﭑ شَ عَ مَيَندِ وٌ شَ يُنُبِ شَقَرِقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","مُنسَ نَشَ سِفَ عَلَتَلَ يِرٍ، عَ عَ قَلَ عَ بّ، «عَلَتَلَ، ﭑ بَرَ عِ مَشَندِ يِ حَمَ بّ. عٍ بَرَ يُنُبِ شُنفبٍ رَبَ كُيٍ يَءِلَنقٍ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ﭑ بَرَ عِ مَشَندِ، عِ شَ دِحّ عٍ مَ. يَندِ، شَ نَ مُ عَ رَ، عِ شَ ﭑ شِلِ بَ عٍ حْشْي رَ كِسِ كِتَابُي كُي، عِ نَشَن سّبّشِ.» ");
INSERT INTO susa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","عَلَتَلَ نَشَ عَ يَابِ، «عَدٍ، ﭑ مِشِيٍ نَن شِلِ بَمَ ﭑ مَ كِسِ كِتَابُي كُي نَشٍيٍ يُنُبِ رَبَشِ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","يَكْسِ، سِفَ، عِ شَ حَمَ شَنِن ﭑ دّننَشّ مَسٍنشِ عِ بّ. ﭑ مَ مَلٍكّ تِمَ عِ يَ رَ سِندٍن، كْنْ كِيتِ لْشْي نَ قَ، عٍ عٍ شَ يُنُبِيٍ سَرٍ قِمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","عَلَتَلَ عِسِرَيِلَكَيٍ رَتْن نّ، بَرِ مَ عٍ عَ قَلَ نّ هَرُنَ بّ، عَ شَ نِنفٍ كُيٍ دَاشِ يَءِلَن عٍ بّ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «وٌ نُن حَمَ عِ نَشَن نَمِنِشِ مِسِرَ بْشِ كُي، وٌ شَ سِفَ ﭑ دّننَشّ لَايِدِشِ عِبُرَهِمَ، عِسِيَفَ، نُن يَشُبَ بّ كَلِ رَ، عَ قَلَقٍ رَ ﭑ نَ قِمَ عٍ بْنسْييٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ﭑ مَلٍكّ تِمَ نّ وٌ يَ رَ. ﭑ كَنَانكَيٍ، عَمٌرِكَيٍ، شِتِكَيٍ، ثٍرِ سِكَيٍ، هِوِكَيٍ، نُن يٍبُسُكَيٍ كٍرِ مَ نّ ");
INSERT INTO susa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","نَ بْشِ مَ، شِحّ نُن كُمِ شّلّمَ دّننَشّ. كْنْ ﭑ تَن مُ سِفَمَ نَا وٌ قْشْ رَ، شَ نَ مُ عَ رَ ﭑ وٌ سْنتْمَ نّ كِرَ شْن مَ، بَرِ مَ حَمَ شُرُتَرٍ نَن وٌ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","حَمَ تٌ نَ مَسٍنيِ شْرْشْي مّ، عٍ نَشَ سُننُن. مِشِ يٌ مُ عَ رَشُنمَسٍيٍ سٌ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹شُرُتَرٍيٍ نَن وٌ رَ. شَ ﭑ بِرَ وٌ قْشْ رَ، ﭑ وٌ سْنتْمَ نّ. وٌ شَ وٌ قَتٍ رَشُنمَسٍ بِرِن بَ وٌ مَ، ﭑ شَ عَ مَتٌ ﭑ وٌ شَ قٍ سُشُمَ كِ نَشّ.›» ");
INSERT INTO susa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","نَ كُي عٍ تٌ كٍلِ شٌرٍبٍ فٍيَ يِرٍ، عٍ نَشَ عٍ شَ شُنمَسٍيٍ بَ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","مُنسَ نُ كِرِ بَنشِ تٌنفٌمَ، عَ نُ عَ تِ عِسِرَيِلَكَيٍ شَ يٌنكِندٍ قَرِ مَ. عَ نَشَ نَ شِلِ سَ عَلَ مَشَندِ يِرٍ. مّننِ مِشِ نُ نْمَ مَشْرِنيِ تِدٍ عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","مُنسَ تٌ نُ مِنِمَ سِفَقٍ رَ نَ بَنشِ كُي، حَمَ بِرِن نُ كٍلِمَ نّ، عٍ تِ عٍ شَ نَادّ رَ، عٍ يَ تِ مُنسَ رَ هَن عَ سٌ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","مُنسَ نَ فّ سٌدٍ نَ بَنشِ كُي، نُشُي نُ فٌرٌ مَ نَ نَادّ رَ، عَلَتَلَ قَ سُمُن عَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","عِسِرَيِلَكَيٍ تٌ نُ نَ نُشُي تٌمَ نَ بَنشِ سٌدٍ دّ مَ، عٍ نُ لُمَ عٍ مَقٍلٍن نَ بْشِ مَ عٍ شْنيِ نَادّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","عَلَتَلَ نُ وْيّنمَ مُنسَ بّ عٍ بٌورٍ يَ عِ، عَلْ مِشِ وْيّنمَ عَ بٌورٍ بّ كِ نَشّ. سُمُنيِ دَنفِ شَنبِ، مُنسَ نُ فبِلٍنمَ حَمَ يِرٍ، كْنْ عَ مَلِمَ يٌسُوٍ، نُن شَ دِ، نَ تَن مُ نُ كٍلِمَ نَ بَنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","مُنسَ نَشَ عَ مَسٍن عَلَتَلَ بّ، «ﭑ مَرِفِ عِ بَرَ ﭑ يَمَرِ ﭑ شَ تِ يِ حَمَ يَ رَ، كْنْ عِ مُ عَ مَسٍنشِ ﭑ بّ عِ نَشَن شّيمَ مُشُ مَتِقٍ رَ. عِ بَرَ عَ قَلَ ﭑ بّ، ‹ﭑ تَن نَن عِ سُفَندِشِ، عِ بَرَ ﭑ كّنّن.› ");
INSERT INTO susa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ﭑ بَرَ عِ مَشَندِ، شَ ﭑ عِ كّنّنشِ، عِ شَ عِ وَشْنقٍ مَسٍن ﭑ بّ، عَلَكٌ ﭑ شَ عِ كٌلٌن يَتِ، ﭑ مَن شَ عِ شَ هِننّ سْتْ. عِ شَ عَ كٌلٌن، يِ سِ قِندِشِ عِ شَ حَمَ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","عَلَتَلَ نَشَ عَ يَابِ، «ﭑ تَن يَتِ وٌ مَتِمَ نّ، ﭑ شَ بْحّسَ قِ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","مُنسَ نَشَ عَ مَسٍن عَ بّ، «شَ عِ تَن يَتِ مُ مُشُ مَتِمَ نَا، عِ نَشَ عَ لُ مُشُ شَ كٍلِ بٍ. ");
INSERT INTO susa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","مُنسٍ نْمَ عَ مَسٍندٍ دُنِحَ بّ عَ مُشُ بَرَ عِ كّنّن، شَ عِ مُ نَ مُشُ قْشْ رَ؟ نَ كُي شَ عِ نَ مُشُ قْشْ رَ، عٍ نْمَ عَ كٌلٌندٍ عِ بَرَ ﭑ تَن نُن عِ شَ حَمَ سُفَندِ دُنِحَ سِ بِرِن يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","عَلَتَلَ نَشَ مُنسَ يَابِ، «عِ نَشَن قَلَشِ، ﭑ عَ رَبَمَ نّ، بَرِ مَ عِ بَرَ ﭑ كّنّن. ﭑ تَن نَن عِ سُفَندِشِ يَتِ.» ");
INSERT INTO susa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","نَ دَنفِ شَنبِ مُنسَ نَشَ عَلَ مَشَندِ، «عِ شَ عِ شَ نْرّ مَسٍن ﭑ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","عَلَتَلَ نَشَ عَ يَابِ، «ﭑ قَمَ ﭑ مَ قَنيِ بِرِن مَسٍندٍ عِ بّ. ﭑ تَن عَلَتَلَ، ﭑ مَن قَمَ ﭑ شِلِ يَتِ قَلَدٍ عِ بّ. ﭑ هِننّمَ مِشِ رَ، ﭑ وَ مَ هِننّقٍ نَشَن نَ. ﭑ كِنِكِنِمَ مِشِ مَ، ﭑ وَ مَ كِنِكِنِقٍ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","كْنْ عِ مُ نْمَ ﭑ يَتَفِ تَن تٌدٍ، بَرِ مَ عَدَ مَدِ يٌ مُ نْمَ ﭑ يَتَفِ تٌدٍ، عَ مُ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، «قَنيٍ ندٍ نَن بٍ ﭑ قّ مَ. عِ شَ تِ نَا. ");
INSERT INTO susa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ﭑ نّ دَنفِمَ ﭑ مَ نْرّ كُي، ﭑ عِ نْشُنمَ قْنمّ كُي، ﭑ قَ عِ يَ مَكٌتٌ ﭑ بّلّشّ رَ هَن ﭑ فّمَ دَنفِدٍ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","نَ تّمُي ﭑ قَمَ ﭑ بّلّشّ بَدٍ عِ يَ مَ، عَلَكٌ عِ شَ نْ ﭑ كٌبٍ تٌدٍ قَ، كْنْ عِ مُ نْمَ ﭑ يَتَفِ تَن تٌدٍ.» ");
INSERT INTO susa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «وَلَشّ قِرِن مَسٌلِ فّمّ رَ، نَشٍيٍ مَنِيَ نَ سِنفٍيٍ رَ عِ نَشٍيٍ كَنَ. ﭑ شَ سّبّلِ تِ عٍ مَ، عَلْ سّبّلِ نَشَن نُ تِشِ نَ بٌورٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","عِ شَ كُرُن تِنَ فّيسّفّ تٍقٍ رَ تُرُ سِنِنَ فٍيَ قَرِ عِ ﭑ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","عِ نَشَ قَ مِشِ يٌ رَ، مِشِ يٌ نَشَ تٍ فٍيَ مَ. هَلِ شُرُ سٍيٍ نَشَ عٍ دّ مَدٌن مّننِ.» ");
INSERT INTO susa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","مُنسَ نَشَ فّمّ وَلَشّ قِرِن مَسٌلِ عَلْ عَ سِنفٍيٍ. سُبَشّ عَ نَشَ تٍ تُرُ سِنِنَ فٍيَ مَ نَ وَلَشّيٍ رَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","عَلَتَلَ تٌ فٌرٌ نُشُي كُي مُنسَ يِرٍ عَ شِلِ مَسٍندٍ عَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","عَ نَشَ دَنفِ مُنسَ يَ رَ، عَ قَ عَ يِتَ عَ بّ، «ﭑ تَن نَن نَ عَلَتَلَ رَ. عَلَتَلَ نَشَن كِنِكِنِمَ، نَشَن شَ هِننّ فبٌ، نَشَن دِحّمَ عِبُنَدَ مَ مَ. دُفُتّفّحَ كَنيِ نَن ﭑ نَ، ﭑ مُ يَنقَنتٍيَ كٌلٌن. ");
INSERT INTO susa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ﭑ مَ دُفُتّفّحَ بُمَ عَبَدَن. ﭑ دِحّمَ مِشِ شَ تَنتَنيِ مَ، ﭑ مُ رَتُمَ عٍ شَ مَتَندِ مَ، ﭑ عٍ شَ يُنُبِ شَقَرِ مَ. كْنْ ﭑ مُ نّيمُمَ تِنشِنتَرٍيَ مَ. ﭑ تِنشِنتَرٍيٍ سَرٍ رَفبِلٍنمَ نّ عٍ بْنسْي مَ هَن عٍ تٌلٌنتٌلٌنيِيٍ شَ وَشَتِ.» ");
INSERT INTO susa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","مُنسَ نَشَ عَ قٍلٍن بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","عَ قَ عَ قَلَ، «ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ، شَ ﭑ عِ كّنّن، عِ شَ حّرّ مُشُ يَ مَ، بَرِ مَ شُرُتَرٍ نَن مُشُ رَ. عِ شَ دِحّ مُشُ شَ مَتَندِ مَ، عِ شَ مُشُ شَ يُنُبِيٍ شَقَرِ، عَلَكٌ مُشُ شَ قِندِ عِ شَ حَمَ يَتِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","عَلَتَلَ نَشَ عَ يَابِ، «ﭑ شَ سَاتّ تٌنفٌ وٌ بّ. ﭑ قَمَ نّ كَابَنَكٌي رَبَدٍ وٌ يَ مَ، نَشٍيٍ سِنفٍ مُ نُ رَبَ دُنِحَ كُي. سِ بِرِن كَابَمَ نّ عَلَتَلَ شَ وَلِ مَفَاشُشِيٍ مَ، ﭑ نَشٍيٍ رَبَمَ عِ تَن سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","وٌ حّنفِ سَ ﭑ مَ يَامَرِ شْن مَ ﭑ نَشَن قَلَمَ وٌ بّ تٌ. ﭑ قَمَ نّ عَمٌرِكَيٍ، كَنَانكَيٍ، شِتِكَيٍ، ثٍرِ سِكَيٍ، هِوِكَيٍ، نُن يٍبُسُكَيٍ كٍرِدٍ وٌ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","وٌ نَ سٌ نَ، وٌ نُن عٍ تَن نَشَ سَاتّ يٌ شِرِ، شَ نَ مُ عَ رَ عٍ قِندِ مَ فَنتَنيِ نَن نَ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","عَ لَنمَ وٌ شَ عٍ شَ سّرّشّبَدٍيٍ رَبِرَ، وٌ شَ عٍ شَ فّمّ تْنشُمَيٍ كَنَ، وٌ شَ عٍ شَ كُيٍيٍ مَسٌلِشِيٍ مَسّفّ. ");
INSERT INTO susa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","وٌ نَشَ وٌ مَفٌرٌ عَلَ فبّتّ بُن مَ، بَرِ مَ ﭑ تَن نَشَن شِلِ عَلَتَلَ، ﭑ مُ وَ مَ ﭑ قِرِن ندٍ شْن. ");
INSERT INTO susa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","وٌ نَشَ سَاتّ شِرِ وٌ نُن نَ بْشِكَيٍ رَ، عَلَكٌ وٌ نَشَ ﭑ يَنقَ، وٌ قَ عٍ شَ عَلَيٍ شَ سّرّشّيٍ دٌن عٍ وٌ شِلِمَ لَندٍ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","وٌ نَشَ مّننِ فِنّيٍ قٍن وٌ شَ دِيٍ بّ، عَلَكٌ عٍ نَشَ عَ نِيَ وٌ شَ دِيٍ شَ عٍ شَ عَلَيٍ بَتُ. ");
INSERT INTO susa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","وٌ نَشَ عَلَ فبّتّ يَءِلَن وُرٍ رَشُنُشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«وٌ شَ تَامِ لّبِنِتَرٍ سَلِ رَبَ. شِ سٌلٌقٍرٍ بُن مَ عَبِبَ كِكٍ رَ، وٌ شَ تَامِ لّبِنِتَرٍ فبَنسَن دٌن، عَلْ ﭑ وٌ يَمَرِشِ كِ نَشّ. وٌ شَ رَتُ عَ مَ عَ ﭑ وٌ رَ مِنِشِ مِسِرَ بْشِ كُي نَ كِكٍ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«ﭑ فبٍ نَن دِ شّمّ سِنفٍ بِرِن نَ، عَ قِندِ مِشِ رَ، عَ قِندِ شُرُ سٍ رَ وٌ شَ فْورّ كُي عَلْ نِنفٍ، يّشّي، شَ نَ مُ عَ رَ سِ. ");
INSERT INTO susa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","وٌ شَ سٌقَلٍ شَ دِ سِنفٍ شُن سَرَ يّشّي شَ نَ مُ عَ رَ سِ رَ. شَ وٌ مُ تِن نَ رَ، وٌ شَ نَ سٌقَلٍ كْنيِ فِرَ. وٌ شَ دِ شّمّ سِنفٍ بِرِن شُن سَرَ. وٌ نَشَ وٌ مَكْرّ ﭑ نَ وٌ بّلّشّ عِفٍلِ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«وٌ شَ وَلِ شِ سٍننِ لْشُنيِ كُي، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ، وٌ شَ وٌ مَلَبُ. هَلِ عَ قِندِ شّ بُشَ نُن شّ شَبَ تّمُي نَن نَ، وٌ شَ نَ سّرِيّ سُشُ.» ");
INSERT INTO susa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«وٌ شَ لْشُنيِيٍ سَلِ رَبَ عَلَ تَنتُقٍ رَ وٌ مّنفِ سِنفٍ شَبَمَ تّمُي نَشّ، عَ نُن وٌ شّ شَبَمَ تّمُي نَشّ حّ حْنيِ. ");
INSERT INTO susa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","حّ كٍرٍن كُي، شّمّ بِرِن شَ قَ سَلِ رَبَ رَ عِسِرَيِلَ مَرِفِ عَلَتَلَ يَ شْرِ سَنيَ سَشَن. ");
INSERT INTO susa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","نَ وَشَتِ سَشَنيِ كُي، ﭑ مُ تِنمَ سِ يٌ شَ قَ وٌ شَ بْشِ بَ وٌ يِ رَ. ﭑ عَ نِيَمَ نّ وٌ شَ نْ عٍ رَ، وٌ قَ ندٍ سَ وٌ شَ بْشِ شَ فبٌي شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«وٌ نَشَ قَ شُرُ سٍ سّرّشّ رَ ﭑ شْن مَ، تَامِ لّبِنِ دَاشِ بِرَشِ عَ قْشْ رَ. وٌ نَ فّ سَيَمَلٍكّ دَنفِ سَلِ سّرّشّ دٌندٍ، وٌ نَشَ نَ سُبٍ دْنشْي رَشِ يّ عِ. ");
INSERT INTO susa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","وٌ شَ وٌ شَ سَنسِ بٌفِ قِسَمَنتٍ سِنفٍيٍ بَ سّرّشّ رَ وٌ مَرِفِ عَلَتَلَ شَ هْرْ مْلِنفِرَ كُي. وٌ نَشَ سِ يْرّ حِن عَ نفَ شِحّ يٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ يِ يَامَرِيٍ سّبّ، بَرِ مَ نٍيٍ قِندِشِ سَاتّ نَن نَ ﭑ نُن عِسِرَيِلَ حَمَ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","مُنسَ نَشَ لُ عَلَتَلَ يِرٍ شِ تٌنفٌ نَانِ. كْي نُن يَنيِ عَ مُ سٍسٍ دٌن، عَ مُ سٍسٍ مِن. نَ وَشَتِ عَلَتَلَ نَشَ نَ سّرِيّ قُ سّبّ فّمّ وَلَشّيٍ مَ، نَشٍيٍ قِندِشِ سَاتّ مَسٍنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","مُنسَ نَشَ فٌرٌ تُرُ سِنِنَ فٍيَ قَرِ، وَلَشّ قِرِن سُشُشِ عَ يِ رَ، نَشٍيٍ قِندِشِ سَاتّ مَسٍنيِ رَ. مُنسَ مُ نُ عَ كٌلٌن عَ يَتَفِ نُ بَرَ نْرْ عَ تَن نُن عَلَ شَ سُمُنيِ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","هَرُنَ نُن عِسِرَيِلَكَيٍ تٌ نْرّ تٌ مُنسَ يَتَفِ مَ، عٍ مُ سُو سَ عٍ مَكْرّدٍ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","مُنسَ نَشَ هَرُنَ نُن حَمَ كُنتِفِيٍ شِلِ، عٍ قَ لُ يِرٍ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","عٍ تٌ فّ وْيّندٍ، عِسِرَيِلَ حَمَ بِرِن نَشَ قَ عٍ تُلِ مَتِدٍ عَلَتَلَ شَ يَامَرِ رَ، عَ نَشَن مَسٍنشِ مُنسَ بّ تُرُ سِنِنَ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","مُنسَ تٌ فّ نَ قَلَدٍ، عَ نَشَ مَقٍلٍنيِ دُ سُ عَ يَتَفِ شُن نَ. ");
INSERT INTO susa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","عَ نُ سٌ كِرِ بَنشِ كُي مَشْرِنيِ تِدٍ عَلَتَلَ مَ، عَ نُ مَقٍلٍنيِ بَمَ عَ يَتَفِ مَ. عَ نَ مِنِ تّمُي نَشّ، عَ عَلَ شَ يَامَرِ رَدَنفِ عِسِرَيِلَ حَمَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","عِسِرَيِلَكَيٍ نُ عَ تٌمَ مُنسَ يَتَفِ نُ نْرْشِ كِ نَشّ. عَ نَ فّ نَ مَسٍنيِ رَ، عَ مَن عَ شَ مَقٍلٍنيِ دُ سُ عَ شُن نَ، هَن عَ فبِلٍن تّمُي عَلَتَلَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","مُنسَ نَشَ عِسِرَيِلَ حَمَ بِرِن مَلَن، عَ عَ قَلَ عٍ بّ، «عَلَتَلَ شَ يَامَرِيٍ نَن يَ؛ ");
INSERT INTO susa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","وٌ شَ وَلِ شِ سٍننِ لْشُنيِ كُي، كْنْ عَ شِ سٌلٌقٍرٍ ندٍ وٌ شَ وٌ مَلَبُ. لْشْي سُفَندِشِ نَ عَ رَ عَلَتَلَ بّ. مِشِ يٌ نَشَن وَلِ سُشُمَ نَ لْشْي، عَ لَنمَ نَ كَنيِ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","وٌ نَشَ تّ يٌ رَدّشّ وٌ شَ بَنشِ كُي مَلَبُي لْشْي.» ");
INSERT INTO susa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","مُنسَ مَن نَشَ عَ مَسٍن عِسِرَيِلَ حَمَ بِرِن بّ، «عَلَتَلَ شَ يَامَرِيٍ نَن يَ؛ ");
INSERT INTO susa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","وٌ شَ هَدِيَ بَ عَلَتَلَ بّ. مِشِ نَشَن نَ عَ حَنِفٍ عَ شَ هَدِيَ بَ، عَلْ شّيمَ، فبٍتِ، نُن وُرٍ فبٍيلِ، ");
INSERT INTO susa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ، سُوَ دُفِ، نُن فّسّ نَشَن يَءِلَنشِ سِ شَبٍ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","يّشّي كٌنتٌنيِ كِرِ نَشٍيٍ سٌشِ عَ فبٍيلِ رَ، ثٍرٍ مُي كِرِيٍ، نُن كَسِيَ وُرِ، ");
INSERT INTO susa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","لَنثُي تُرٍ، لَبُندّ نَشَن مَسُنبُمَ تُرٍ رَ، سُرَيِ شِرِ حْشُنمّ نَشَن فَنمَ، ");
INSERT INTO susa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","عٌنِشِ فّمّ، نُن فّمّ تٌقَنيِ نَشٍيٍ سَمَ سّرّشّدُبّ شَ دٌنمَ كُيٍ نُن عَ شَ دٌنمَ كَنكٍ رَشُنمَسٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«وَلِ كٌلٌنيِيٍ نَشٍيٍ نَ وٌ يَ مَ، عٍ شَ قَ يِ سٍيٍ يَءِلَندٍ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ؛ ");
INSERT INTO susa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","هْرْ مْلِنفِرَ دُفِيٍ، عَ شُن مَكٌتٌ سٍيٍ، عَ سُشُسٍيٍ، عَ شٍبٍنيِيٍ، عَ وُرِيٍ نُن عٍ سَنبُنيِيٍ، ");
INSERT INTO susa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","عَ نُن سَاتّ كَنكِرَ، عَ وُرِ كُيٍيٍ، عَ دّرَكٌتٍ، عَ نُن دُفِ نَشَن فبَكُمَ عَ يَ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","هْرْ مْلِنفِرَ تٍيبِلِ، عَ وُرِ كُيٍيٍ، عَ يِرَبَسٍ، نُن تَامِ نَشٍيٍ بَمَ عَلَتَلَ بّ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","هْرْ مْلِنفِرَ لَنثُي دْشْسٍ، عَ يِرَبَسٍيٍ، عَ لَنثُييٍ، نُن تُرٍ نَشَن سَمَ عَ كُي، ");
INSERT INTO susa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","سُرَيِ سّرّشّبَدٍ، عَ وُرِ كُيٍيٍ، نُن تُرٍ سّنِيّنشِ، لَبُندّ فَن دَاشِ، عَ نُن دُفِ نَشَن فبَكُمَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","سّرّشّبَدٍ شُنفبٍ، عَ سُبٍ فَنسٍ وُرٍ فبٍيلِ دَاشِ، عَ وُرِ كُيٍيٍ، عَ يِرَبَسٍ، نُن هْرْ مْلِنفِرَ يٍ سَسٍ شُنفبٍ نُن عَ دْشْسٍ، ");
INSERT INTO susa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","هْرْ مْلِنفِرَ تّتّ شَ دُفِيٍ، عَ وُرِيٍ، نُن عٍ سَنبُنيِيٍ، عَ نُن دُفِ نَشَن فبَكُمَ تّتّ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","هْرْ مْلِنفِرَ مَشِرِ سٍيٍ، تّتّ مَشِرِ سٍيٍ، نُن عٍ شَ لُوتِيٍ، ");
INSERT INTO susa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","عَ نُن سّرّشّدُبّ سٌسٍيٍ هَرُنَ نُن عَ شَ دِيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","عِسِرَيِلَ حَمَ نَشَ كٍلِ مُنسَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","مِشِ نَشٍيٍ عَ حَنِفٍ، نٍيٍ نَشَ قَ عٍ شَ هَدِيَ رَ عَلَتَلَ بّ عَ شَ هْرْ مْلِنفِرَ تِقٍ رَ، عَلَ عٍ لِمَ دّننَشّ، عَ نُن سّرّشّدُبّ سٌسٍيٍ سّنِيّنشِيٍ يَءِلَنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","شّمّيٍ نُن فِنّ نَشٍيٍ عَ حَنِفٍشِ، عٍ نَشَ قَ شُنمَسٍ شّيمَ دَاشِيٍ رَ، عَلْ تُلِرَ سٌي، شُرُندّيٍ، كْنيِ مَفٌرٌ سٍيٍ، بّلّشّرَ سٌييٍ، عَ نُن شُنمَسٍ فبّتّ نَشٍيٍ يَءِلَنشِ شّيمَ رَ. عٍ نَشَ نَ بِرِن قِ عَلَتَلَ مَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ، سُوَ دُفِيٍ، فّسّ نَشَن يَءِلَنشِ سِ شَبٍ رَ، يّشّي كٌنتٌنيِ كِرِ نَشٍيٍ سٌشِ عَ فبٍيلِ رَ، نُن ثٍرٍ مُي كِرِيٍ نُ نَ نَشٍيٍ يِ رَ، نٍيٍ نَشَ قَ عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","مِشِ نَشٍيٍ نُ عَ حَنِفٍشِ، نٍيٍ نَشَ قَ فبٍتِ نُن وُرٍ فبٍيلِ هَدِيَ رَ عَلَتَلَ بّ. كَسِيَ وُرِ كَنيِيٍ نَشَ قَ نَ وُرِ رَ هْرْ مْلِنفِرَ وَلِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","فِنّ نَشَن بِرِن قَتَ دُفِ سْشْدٍ، عٍ نَشَ دُفِيٍ سْشْ عٍ بّلّشّ رَ، عٍ قَ نٍيٍ رَ؛ دُفِ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ. عٍ نَشَ قَ سُوَ دُفِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","فِنّ نَشَن بِرِن قَتَ، عٍ عَ حَنِفٍ، عٍ نَشَ فّسّ يَءِلَن سِ شَبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","حَمَ كُنتِفِيٍ نَشَ قَ عٌنِشِ فّمّيٍ نُن فّمّ تٌقَنيِ فبّتّيٍ رَ، نَشٍيٍ سَمَ سّرّشّدُبّ شَ دٌنمَ كُيٍ نُن عَ شَ دٌنمَ كَنكٍ رَشُنمَسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","عٍ نَشَ قَ لَبُندّ نُن تُرٍ رَ هْرْ مْلِنفِرَ لَنثُي بّ، عَ نُن تُرٍ سّنِيّنشِ نُن لَبُندّ فَن دَاشِ فبّتّ. ");
INSERT INTO susa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","عِسِرَيِلَكَ بِرِن نَشٍيٍ عَ حَنِفٍشِ عٍ بْحّ كُي، شّمّيٍ نُن فِنّيٍ، نٍيٍ نَشَ قَ هَدِيَ رَ عَلَتَلَ شْن مَ، عَلَكٌ مُنسَ شَ وَلِ رَبَ عَلَتَلَ عَ يَمَرِشِ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","مُنسَ نَشَ عَ مَسٍن عِسِرَيِلَكَيٍ بّ، «وٌ عَ كٌلٌن، عَلَتَلَ بَرَ بٍسَلٍلِ عُرِ شَ دِ سُفَندِ، شُرُ شَ مَمَدِ نَشَن قَتَنشِ يُدَ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","عَلَتَلَ بَرَ شَشِلِ قَنيِ قِ عَ مَ، عَلَكٌ عَ شَ وَلِ بِرِن نَبَ كِ كٌلٌن لْننِ قَنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","عَ شَ نْ وَلِ تٌدٍ عَ شَشِلِ كُي بٍينُن عَ شَ رَبَ، عَ شَ نْ شّيمَ، فبٍتِ، نُن وُرٍ فبٍيلِ رَوَلِدٍ، ");
INSERT INTO susa_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","عَ شَ نْ فّمّ قَنيِ مَسٌلِدٍ عَ قَ عَ رَبِلِنيِ يَءِلَن، عَ شَ نْ كَمُدّرِحَ نُن وَلِ فبّتّيٍ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","عَلَ بَرَ عَ نِيَ بٍسَلٍلِ شَ نْ مِشِ فبّتّ مَتِنكَندٍ عَ شَ وَلِ رَ. عَلَ بَرَ نَ نِيَ عٌهٌلِيَبُ عَشِسَمَكِ شَ دِ قَن بّ، نَشَن قَتَنشِ دَنَ بْنسْي رَ. ");
INSERT INTO susa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","عَلَ بَرَ عٍ مَلِ عَلَكٌ عٍ شَ قَتَ وَلِ بِرِن نَ، عَلْ فّمّ نُن وُرِ مَسٌلِقٍ، ثِرِنتِ رَبَقٍ، سُوَ دُفِ سْشْقٍ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ، عَ نُن وَلِ بِرِن عٍ نَشَن تٌمَ عٍ شَشِلِ كُي.» ");
INSERT INTO susa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","بٍسَلٍلِ، عٌهٌلِيَبُ، نُن وَلِ قَنيِ رَبَيٍ، عَلَتَلَ بَرَ شَشِلِ قَنيِ قِ نَشٍيٍ مَ، عَلَكٌ عٍ شَ هْرْ مْلِنفِرَ وَلِ بِرِن نَبَ كِ كٌلٌن لْننِ قَنيِ رَ، نٍيٍ وَلِ سُشُ نّ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","مُنسَ نَشَ بٍسَلٍلِ، عٌهٌلِيَبُ، نُن وَلِ قَنيِ رَبَيٍ شِلِ، عَلَتَلَ بَرَ شَشِلِ قَنيِ قِ نَشٍيٍ مَ، نَشٍيٍ نُ بَرَ عَ حَنِفٍ عٍ شَ نَ وَلِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","مُنسَ نَشَ هَدِيَ بِرِن سٌ عٍ يِ رَ، عِسِرَيِلَكَيٍ نَشٍيٍ بَشِ سّرّشّ حَنِفٍشِ رَ عٍ شَ هْرْ مْلِنفِرَ تِقٍ شَ قٍ رَ. فّيسّفّ يٌ فّيسّفّ، عٍ نُ هَدِيَ فبّتّ سْتْمَ. ");
INSERT INTO susa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","نَ وَلِ قَنيِ رَبَيٍ نَشَ كٍلِ عٍ شَ وَلِيٍ دّ عِ، عَلَكٌ عٍ شَ هْرْ مْلِنفِرَ وَلِ فبَنسَن نَبَ. ");
INSERT INTO susa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","عٍ نَشَ عَ قَلَ مُنسَ بّ، «حَمَ قَمَ هَدِيَ نَشٍيٍ رَ، عَ فبٌ وَلِ بّ، عَلَتَلَ نَشَن يَمَرِشِ.» ");
INSERT INTO susa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","نَ كُي مُنسَ نَشَ يَامَرِ قِ، يِ شِبَارُ شَ رَيٍنسٍن يٌنكِندٍ كُي، «مِشِ نَشَ وَلِ سْنْن هَدِيَ شَ قٍ رَ، نَشَن بَمَ هْرْ مْلِنفِرَ تِقٍ رَ.» حَمَ نَشَ نَ شُي رَبَتُ، عٍ مُ قَ نَ هَدِيَ مْولِ رَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","سٍ نَشٍيٍ نُ بَرَ بَ، نٍيٍ نُ نْمَ وَلِ رَحْندٍ عَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","وَلِ قَنيِ رَبَيٍ نَشَ هْرْ مْلِنفِرَ تِ سُوَ دُفِ قُ رَ، عَ فّرّ دَاشِ، عَ بُلُ دَاشِ، نُن عَ فبٍيلِ. عٍ مَلٍكّيٍ سَوُرّ مَسْشْ عَ مَ عَ تٌقَن كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","دُفِ بِرِن كُيَ نْنفْن مْشْحّن نُن سٌلٌمَسَشَن، عٍ عِفبٌ نْنفْن نَانِ. عٍ كُيّ نُن عٍ عِفبٌيَ لَن. ");
INSERT INTO susa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","عٍ دُفِ سُولِ دّفّ عٍ بٌورٍ رَ، عٍ دُفِ سُولِ فبّتّ قَن دّفّ عٍ بٌورٍ رَ. نَ كُي نَ دُفِ قُ بَرَ قِندِ دُفِ قِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","عٍ فّسّ فّرّ دَاشِ دّفّ نَ دُفِ سِنفٍ دّ كِرِ مَ، عَ نُن نَ دُفِ قِرِن ندٍ دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","عٍ فّسّ تٌنفٌ سُولِ دّفّ نَ قِرِنيِ دّ كِرِ مَ عَلَكٌ عٍ بِرِن شَ لَن عٍ بٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","عٍ سُشُسٍ تٌنفٌ سُولِ يَءِلَن شّيمَ رَ، نَ دُفِ قِرِنيِيٍ رَلَن عٍ بٌورٍ رَ نَ سُشُسٍيٍ رَ. نَ نَن عَ نِيَ هْرْ مْلِنفِرَ قِندِ دُفِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","عٍ دُفِ قُ نُن كٍرٍن سْشْ سِ شَبٍ رَ، نَشٍيٍ عَلَ شَ هْرْ مْلِنفِرَ مَكٌتٌمَ. ");
INSERT INTO susa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","دُفِ كٍرٍن كُيَ نْنفْن تٌنفٌ سَشَن، عَ عِفبٌ نْنفْن نَانِ. نَ دُفِ قُ نُن كٍرٍنيِ بِرِن لَن نّ. ");
INSERT INTO susa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","عٍ دُفِ سُولِ دّفّ عٍ بٌورٍ رَ، عٍ قِندِ دُفِ كٍرٍن نَ. نَ دُفِ سٍننِ نَشٍيٍ لُشِ، عٍ قَن دّفّ عٍ بٌورٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","عٍ فّسّ تٌنفٌ سُولِ دّفّ نَ دُفِ سِنفٍ رَ، عَ نُن نَ دُفِ قِرِن ندٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","عٍ سُشُسٍ تٌنفٌ سُولِ يَءِلَن وُرٍ فبٍيلِ رَ، نَ دُفِ قِرِنيِيٍ رَلَن عٍ بٌورٍ رَ نَ سُشُسٍيٍ رَ. نَ نَن عَ نِيَ نَ بِرِن قِندِ دُفِ كٍرٍن نَ نَشَن عَلَ شَ هْرْ مْلِنفِرَ مَكٌتٌمَ. ");
INSERT INTO susa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","عٍ مَكٌتٌسٍ فبّتّ يَءِلَن يّشّي كٌنتٌنيِ كِرِ رَ، نَشَن سٌشِ عَ فبٍيلِ رَ. عٍ مَكٌتٌسٍ فبّتّ يَءِلَن ثٍرٍ مُي كِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","عٍ كَسِيَ وُرِ شَبَ شٍبٍنيِيٍ رَ هْرْ مْلِنفِرَ تِمَ نَشٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","كَنكَن كُيَ نْنفْن قُ، عَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","سُشُسٍ قِرِن لُ هْرْ مْلِنفِرَ شٍبٍنيِ بِرِن مَ عٍ كَقُمَ عٍ بٌورٍ مَ نَشٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","شٍبٍنيِ مْشْحّن نَن تِ هْرْ مْلِنفِرَ يِرٍقَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","سَنبُنيِ فبٍتِ دَاشِ تٌنفٌ نَانِ نَن سَ نَ شٍبٍنيِ مْشْحّن بُن مَ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن. عٍ لُ شٍبٍنيِ سُشُسٍيٍ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","شٍبٍنيِ مْشْحّن نَن تِ هْرْ مْلِنفِرَ كْولَ قَن مَ، ");
INSERT INTO susa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","عَ نُن عٍ سَنبُنيِ فبٍتِ دَاشِ تٌنفٌ نَانِ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن. ");
INSERT INTO susa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","شٍبٍنيِ سٍننِ نَن تِ هْرْ مْلِنفِرَ شَنبِ رَ سٌفٍفٌرٌدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","عٍ شٍبٍنيِ قِرِن يَءِلَن تُشُييٍ بّ هْرْ مْلِنفِرَ شَنبِ رَ، ");
INSERT INTO susa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","نَشٍيٍ قُفٍ نُن لَبٍ لَنمَ عٍ بٌورٍ مَ، عٍ شِرِ قُفٍ رَ سٍ دِفِلِنشِ رَ. نَ تُشُي قِرِنيِ يَءِلَن نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","نَ بِرِن لَنشِ شٍبٍنيِ سٌلٌمَسَشَن نَن مَ، عَ نُن عٍ سَنبُنيِ فبٍتِ دَاشِ قُ نُن سٍننِ، شٍبٍنيِ كٍرٍن، سَنبُنيِ قِرِن. ");
INSERT INTO susa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","عٍ وُرِ سُولِ يَءِلَن كَسِيَ وُرِ رَ، هْرْ مْلِنفِرَ شٍبٍنيِيٍ تِمَ نَشٍيٍ مَ. سُولِ رَوَلِ سّيتِ مَ، ");
INSERT INTO susa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","سُولِ رَوَلِ بٌورٍ سّيتِ مَ، سُولِ رَوَلِ هْرْ مْلِنفِرَ شَنبِ رَ سٌفٍفٌرٌدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","وُرِ نَشَن لُ عَ تَفِ، نَ دَنفِ شٍبٍنيِيٍ نَن شُن مَ، عَ كٍلِ سّيتِ سِنفٍ عَ سَ دْشْ بٌورٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","نَ شٍبٍنيِيٍ، نُن نَ وُرِيٍ، نُن سٍ دِفِلِنشِيٍ وُرِ سٌ نَشٍيٍ كُي، نَ بِرِن مَسٌ شّيمَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","عٍ سُوَ دُفِ يَءِلَن فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ. مَلٍكّ سَوُرّيٍ دّفّ نَ مَ، عَ تٌقَن كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","عَ فبَكُ كَسِيَ وُرِ نَانِ مَ نَشٍيٍ مَسٌشِ شّيمَ رَ، عٍ تِشِ فبٍتِ سَنبُنيِيٍ مَ. سُشُسٍ نَشٍيٍ دُفِ شِرِ مَ وُرِيٍ مَ، نٍيٍ قَن مَسٌ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","عٍ سُوَ دُفِ فبّتّ يَءِلَن فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عٍ عَ مَسْشْ عَ قَنيِ رَ، عَ شَ تٌقَن. ");
INSERT INTO susa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","عٍ عَ فبَكُ وُرِ سُولِ مَ نَشٍيٍ يَءِلَنشِ كَسِيَ وُرِ رَ، عٍ مَسٌشِ شّيمَ رَ، عٍ تِشِ فبٍتِ سَنبُنيِيٍ مَ. سُشُسٍ نَشٍيٍ دُفِ شِرِ مَ وُرِيٍ مَ، نٍيٍ يَءِلَنشِ وُرٍ فبٍيلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","بٍسَلٍلِ نَشَ كَنكِرَ يَءِلَن كَسِيَ وُرِ رَ. عَ كُيَ نْنفْن قِرِن نُن عَ تَفِ، عَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ، عَ عِتٍ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","عَ نَشَ عَ كُي نُن عَ قَرِ مَسٌ شّيمَ رَ، عَ نَشَ عَ دّ كِرِ قَن يَءِلَن شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","عَ نَشَ عَ سُشُدٍ دِفِلِنشِ نَانِ رَقَلَ شّيمَ رَ عَ تُنشُن نَانِيٍ مَ، قِرِن نَ سّيتِ، قِرِن نَ بٌورٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","عَ نَشَ كَسِيَ وُرِ قِرِن مَسٌلِ عَ بّ، عَ قَ عٍ مَسٌ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","عَ نَشَ عٍ رَ سٌ نَ كَنكِرَ سُشُدٍ دِفِلِنشِيٍ كُي، نٍيٍ قِندِ كَنكِرَ تٌنفٌسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","عَ نَشَ نَ كَنكِرَ دّرَكٌتٍ يَءِلَن شّيمَ قَنيِ رَ، عَ قِندِ شُنسَرٍ يِرٍ رَ. عَ كُيَ نْنفْن قِرِن نُن عَ تَفِ، عَ عِفبٌ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","عَ نَشَ مَلٍكّ سَوُرّ قِرِن يَءِلَن شّيمَ شَبُشِ رَ كَنكِرَ دّرَكٌتٍ قَرِ نَ سّيتِ قِرِنيِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","نَ مَلٍكّ سَوُرّيٍ نُن نَ كَنكِرَ دّرَكٌتٍ قِندِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","نَ مَلٍكّ سَوُرّ قِرِنيِيٍ نَشَ تِ عٍ بٌورٍ يَ عِ، عٍ فَبُتٍنيِيٍ عِتَلَشِ، عٍ شُن سِنشِ شُنسَرٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","عَ نَشَ تٍيبِلِ يَءِلَن كَسِيَ وُرِ رَ، نَشَن كُيَ نْنفْن قِرِن، عَ عِفبٌ نْنفْن كٍرٍن، عَ عِتٍ نْنفْن كٍرٍن نُن عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","عَ نَشَ شّيمَ قَنيِ مَسٌ عَ مَ، عَ نُن عَ دّ كِرِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","عَ نَشَ شٍبٍنيِ ندٍ سَ نَ دّ كِرِيٍ بُن مَ، نَشَن عِفبٌ سُشُي كٍرٍن عَ نُن عَ تَفِ. عَ نَشَ شّيمَ سَ نَ قَن دّ كِرِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","عَ نَشَ عَ سُشُدٍ دِفِلِنشِ نَانِ رَقَلَ شّيمَ رَ عَ تُنشُن نَانِيٍ مَ، نَشٍيٍ عِلَنمَ عَ سَنيِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","عٍ نُ نَ نَ شٍبٍنيِ بُن مَ. وُرِ كُيٍيٍ نُ سٌمَ نٍيٍ كُي تٍيبِلِ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","عَ نَشَ وُرِ كُيٍيٍ مَسٌلِ كَسِيَ وُرِ رَ، عَ عٍ مَسٌ شّيمَ رَ. نٍيٍ قِندِ تٍيبِلِ تٌنفٌسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ثِلٍتِيٍ، تْنبِلِيٍ، ثْوتِيٍ، نُن ثَانِ نَشٍيٍ سَمَ نَ تٍيبِلِ مَ، نَشٍيٍ رَوَلِمَ سّرّشّ يٍيرَ مَ دَاشِ شَ قٍ رَ، عَ نَشَ عٍ بِرِن يَءِلَن شّيمَ قَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","عَ نَشَ لَنثُي دْشْسٍ ندٍ يَءِلَن شّيمَ قَنيِ شَبُشِ رَ. عَ سَنيِ، عَ بِلِ، عَ سَلٌنيِيٍ، نُن لَنثُي دْشْدٍ نَشٍيٍ مَنِيَ سَنسِ قُفٍيٍ رَ، نَ بِرِن قِندِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","سَلٌن سٍننِ نَن مِنِ لَنثُي دْشْسٍ بِلِ مَ، سَشَن سّيتِ كٍرٍن، سَشَن بٌورٍ سّيتِ. ");
INSERT INTO susa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","تْنبِلِ سَشَن نَن لُ نَ سَلٌن سٍننِ بِرِن شُن مَ. عٍ مَنِيَ سَنسِ بٌفِ رَ نَشَن دْشْشِ عَ بُرّشّيٍٍ نُن عَ قُفٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","تْنبِلِ نَانِ فبّتّ نَن لُ لَنثُي دْشْسٍ بِلِ مَ. عٍ قَن مَنِيَ سَنسِ بٌفِ رَ نَشَن دْشْشِ عَ بُرّشّيٍ نُن عَ قُفٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","نَ سَلٌن قِرِن قِرِن دْشْ سَشَنيِيٍ بُن مَ نَشٍيٍ كٍلِشِ عَ بِلِ مَ، عَ سَ نّ مّننِ قَن مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","نَ تْنبِلِيٍ نُن لَنثُي سَلٌنيِيٍ قِندِ كٍرٍن نَ، عٍ يَءِلَن شّيمَ قَنيِ شَبُشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","عَ نَشَ لَنثُي سٌلٌقٍرٍ يَءِلَن، عَ عٍ دْشْ عٍ دْشْدٍيٍ مَ عَلَكٌ عٍ دّشّ شَ يَرٍ عِيَلَن. ");
INSERT INTO susa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","شّيمَ نَشَن نَوَلِشِ لَنثُي دْشْسٍ نُن لَنثُي يِرَبَسٍ يَءِلَنقٍ رَ، نَ قِندِ شّيمَ كِلٌ تٌنفٌ سَشَن نُن نَانِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","عَ نَشَ سُرَيِ سّرّشّبَدٍ يَءِلَن كَسِيَ وُرِ رَ. عَ كُيَ نْنفْن كٍرٍن، عَ عِفبٌ نْنفْن كٍرٍن، عَ سّيتِ نَانِ بِرِن لَن، عَ عِتٍ نْنفْن قِرِن. قٍرِيٍ نَشَ لُ عَ تُشُييٍ رَ، عٍ نُن سّرّشّبَدٍ قِندِ سٍ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","عَ نَشَ نَ سّرّشّبَدٍ بِرِن مَسٌ شّيمَ شِندٍ رَ، عَ قَرِ، عَ سّيتِيٍ، عَ قٍرِيٍ، نُن عَ دّ كِرِ. ");
INSERT INTO susa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","عَ نَشَ سُشُسٍ دِفِلِنشِ قِرِن يَءِلَن شّيمَ رَ سّرّشّبَدٍ سّيتِ قِرِنيِيٍ مَ، عَ دّ كِرِ لَبٍ رَ، وُرِ كُيٍيٍ سٌمَ نَشٍيٍ كُي عَ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","عَ نَشَ نَ وُرِيٍ يَءِلَن كَسِيَ وُرِ رَ، عَ نَشَ شّيمَ مَسٌ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","عَ نَشَ تُرٍ سّنِيّنشِ نُن سُرَيِ شِرِ قَنيِ يَءِلَن نَشَن نَوَلِمَ سّرّشّدُبّ تِقٍ رَ. نَ وَلِ شَ رَبَ عَ قَنيِ رَ عَلْ لَبُندّ رَقَلّ عَ رَقَلَمَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","عَ نَشَ سّرّشّ فَن دَاشِ سّرّشّبَدٍ يَءِلَن كَسِيَ وُرِ رَ، نَشَن كُيَ نْنفْن سُولِ، عَ عِفبٌ نْنفْن سُولِ، عَ سّيتِ بِرِن لَن، عَ عِتٍ نْنفْن سَشَن. ");
INSERT INTO susa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","عَ نَشَ قٍرِ نَانِ يَءِلَن عَ تُشُي بِرِن مَ، نَشٍيٍ قِندِشِ سٍ كٍرٍن نَ سّرّشّبَدٍ رَ. عَ نَشَ وُرٍ فبٍيلِ مَسٌ نَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","عَ نَشَ سّرّشّبَدٍ يِرَبَسٍ بِرِن يَءِلَن وُرٍ فبٍيلِ رَ، عَلْ شُبٍ سَسٍيٍ، ثٍلِيٍ، ثْوتِيٍ، سُبٍ سْشْسٍيٍ، نُن تُندٍيٍ تّ سَمَ نَشٍيٍ كُي. ");
INSERT INTO susa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","عَ نَشَ سٍ ندٍ يَءِلَن وُرٍ فبٍيلِ رَ نَشَن سَمَ تّ شُن مَ، سُبٍ سَمَ نَشَن قَرِ. عَ نَشَ سُشُسٍ دِفِلِنشِيٍ وُرٍ فبٍيلِ دَاشِ سَ عَ تُشُي مَ، ");
INSERT INTO susa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","عَلَكٌ عَ شَ فبَكُ سّرّشّبَدٍ كُي عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","عَ نَشَ وُرِ كُيٍيٍ يَءِلَن كَسِيَ وُرِ رَ وُرٍ فبٍيلِ مَسٌشِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","عَ نَشَ عٍ رَ سٌ سُشُسٍ دِفِلِنشِ نَانِيٍ كُي سّرّشّبَدٍ سّيتِ قِرِنيِيٍ مَ عَ شَنِنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","عَ نَشَ هْرْ مْلِنفِرَ يٍ سَسٍ شُنفبٍ نُن عَ دْشْسٍ يَءِلَن وُرٍ فبٍيلِ رَ، عَ نَشَن سْتْ فِنّيٍ رَ نَشٍيٍ نُ مَلَنمَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","عَ نَشَ تّتّ يَءِلَن سُوَ دُفِ رَ. تّتّ كُيَ نْنفْن كّمّ يِرٍقَنيِ مَبِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","عَ نَشَ فّرّ دُفِ فبَكُ نَ وُرِ مْشْحّن مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. نَ دُفِ سُشُسٍيٍ نَشَ يَءِلَن فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","تّتّ كُيَ نْنفْن كّمّ كْولَ قَن مَبِرِ رَ. عَ نَشَ فّرّ دُفِ فبَكُ نَ وُرِ مْشْحّن مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. نَ دُفِ سُشُسٍيٍ شَ يَءِلَن فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","تّتّ عِفبٌ نْنفْن تٌنفٌ سُولِ سٌفٍفٌرٌدٍ مَبِرِ رَ. عَ نَشَ فّرّ دُفِ فبَكُ نَ وُرِ قُ مَ، نَشٍيٍ تِشِ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","تّتّ عِفبٌ نْنفْن تٌنفٌ سُولِ سٌفٍتٍدٍ قَن مَبِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","عَ نَشَ فّرّ دُفِ فبَكُ سّيتِ مَ وُرِ سَشَن مَ، نَشٍيٍ تِشِ سَنبُنيِ مَ. نَ كُيّ نْنفْن قُ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","عَ نَشَ فّرّ دُفِ فبّتّ فبَكُ بٌورٍ سّيتِ مَ وُرِ سَشَن مَ، نَشٍيٍ تِشِ سَنبُنيِ مَ. نَ قَن كُيّ نْنفْن قُ نُن سُولِ. ");
INSERT INTO susa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","تّتّ نَشَ يَءِلَن سُوَ دُفِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","وُرِ نَشٍيٍ تِشِ تّتّ مَ، عٍ تِشِ عٍ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. دُفِ سُشُسٍيٍ قَن نَ عٍ مَ نَشٍيٍ يَءِلَنشِ فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","تّتّ سٌدٍ دّ نَشَ يَءِلَن سُوَ دُفِ رَ نَشَن مَسْشْشِ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ. نَ دُفِ كُيَ نْنفْن مْشْحّن، عَ عِتٍ نْنفْن سُولِ، عَلْ تّتّ دُفِ بِرِن شَ مَءِتٍ. ");
INSERT INTO susa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","عَ نَشَ نَ فبَكُ وُرِ نَانِ مَ، نَشٍيٍ تِشِ عٍ سَنبُنيِ وُرٍ فبٍيلِ دَاشِيٍ مَ. نَ دُفِ سُشُسٍيٍ نُن نَ وُرِ شُنيِيٍ يَءِلَنشِ فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","هْرْ مْلِنفِرَ نُن تّتّ لُوتِ شِرِ مَ سٍ نَشٍيٍ مَ، نٍيٍ بِرِن يَءِلَن وُرٍ فبٍيلِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","هْرْ مْلِنفِرَ، سٍيدٍ وَلَشّ نَ نَشَن كُي، عَ وَلِ دّنتّفّ نَن يِ كِ. لٍوِ بْنسْي نَ وَلِ رَبَ مُنسَ شَ يَامَرِ نَن بُن مَ. هَرُنَ شَ دِ، عِتَمَرِ نَن قِندِ نَ وَلِ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","بٍسَلٍلِ، عُرِ شَ دِ، شُرُ شَ مَمَدِ، يُدَ بْنسْي، نَشَ عَلَتَلَ شَ يَامَرِ بِرِن نَبَ، عَ نَشَن مَسٍن مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","عٌهٌلِيَبُ، عَشِسَمَكِ شَ دِ، دَنَ بْنسْي، قِندِ بٍسَلٍلِ مَلِمَ نَن نَ. عَ نُ قَتَ سٍ مَسٌلِدٍ نُن سُوَ دُفِ مَسْشْدٍ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","شّيمَ شَسَبِ نَشَن نَوَلِشِ هْرْ مْلِنفِرَ تِقٍ رَ، نَشَن سْتْ هَدِيَ رَ، عَ لَن كِلٌ كّمّ سٌلٌمَنَانِ كِلٌ تٌنفٌ سٌلٌمَنَانِ نَن مَ هْرْ مْلِنفِرَ مَنِيَسٍ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","فبٍتِ شَسَبِ نَشَن سْتْ مِشِ كْنتِشِيٍ رَ، نَ لَن نّ كِلٌ وُلُ سَشَن كِلٌ كّمّ سٌلٌمَسَشَن نُن تٌنفٌ سٌلٌقٍرٍ نُن سُولِ نَن مَ هْرْ مْلِنفِرَ مَنِيَسٍ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","مِشِ وُلُ كّمّ سٍننِ مِشِ وُلُ سَشَن كّمّ سُولِ تٌنفٌ سُولِ، نَشٍيٍ نُ بَرَ حّ مْشْحّن سْتْ نُن نَ شَنبِ، نَشٍيٍ كْنتِشِ عِسِرَيِلَكَيٍ تَفِ، كَنكَن نَشَ فبٍتِ فِرَ مُ سٍننِ قِ هْرْ مْلِنفِرَ مَنِيَسٍ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","عٍ نَشَ فبٍتِ كِلٌ وُلُ سَشَن كِلٌ كّمّ نَانِ رَشُنُ وُرِ سَنبُنيِ كّمّ يَءِلَنقٍ رَ هْرْ مْلِنفِرَ نُن تّتّ بّ. وُرِ سَنبُن كٍرٍن قِندِ فبٍتِ كِلٌ تٌنفٌ سَشَن نُن نَانِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","نَ كِلٌ مْشْحّن نَشَن لُ، نَ نَشَ يَءِلَن دُفِ نُن وُرِ سُشُسٍيٍ نُن وُرِ شُنيِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","وُرٍ فبٍيلِ شَسَبِ نَشَن سْتْ عِسِرَيِلَ شَ هَدِيَ رَ، عَ لَن كِلٌ وُلُ قِرِن كِلٌ كّمّ نَانِ نُن سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","عٍ نَشَ عَ قِندِ هْرْ مْلِنفِرَ سٌدٍ دّ وُرِ سَنبُنيِيٍ رَ، نُن سّرّشّبَدٍ وُرٍ فبٍيلِ دَاشِ، نُن نَ شَ يِرَبَسٍ بِرِن، ");
INSERT INTO susa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","نُن تّتّ وُرِ سَنبُنيِيٍ، نُن عَ سٌدٍ دّ شَ وُرِ سَنبُنيِيٍ، نُن تّتّ مَشِرِ سٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","عٍ نَشَ سٌسٍ سّنِيّنشِيٍ دّفّ هَرُنَ نُن سّرّشّدُبّيٍ بّ نَشٍيٍ وَلِمَ هْرْ مْلِنفِرَ كُي. نَ سٌسٍ يَءِلَنشِ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، عَ فبٍيلِ، نُن سُوَ دُفِ رَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","عٍ دٌنمَ كُيٍ يَءِلَن نّ شّيمَ فّسّ رَ، فّسّ فّرّ دَاشِ، بُلُ دَاشِ، عَ فبٍيلِ، نُن سُوَ دُفِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","عٍ نَشَ شّيمَ كٍبٍلَ عِتَلَ، عٍ عَ عِشَبَ عٍ عَ يَءِلَن وَيَ رَ. عٍ نَشَ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، عَ فبٍيلِ، نُن سُوَ دُفِ مَسْشْ نَ وَيَ رَ. عَ قِندِ وَلِ تٌقَنيِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","عٍ نَشَ تُنكِ رَشُنمَسٍ قِرِن يَءِلَن نَشٍيٍ شِرِ مَ دٌنمَ كُيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","بّلّتِ قَن يَءِلَن نَ كِ نّ فّسّ فّرّ دَاشِ، بُلُ دَاشِ، عَ فبٍيلِ، نُن سُوَ دُفِ رَ. نَ بّلّتِ نُن دٌنمَ قِندِ كٍرٍن نَ. نَ بِرِن يَءِلَنشِ عَلْ عَلَتَلَ مُنسَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","عٍ نَشَ عٌنِشِ فّمّيٍ رَوَلِ، عٍ نَشَ عٍ رَبِلِنيِ قِندِ شّيمَ رَ. عٍ نَشَ عِسِرَيِلَ شَ دِيٍ شِلِ مَسٌلِ عٍ مَ، عَلْ عٍ سّبّلِ مَسٌلِمَ شُرُندّ مَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","عٍ نَشَ عٍ سَ تُنكِ رَشُنمَسٍيٍ مَ، عٍ شَ قِندِ تْنشُمَ سٍيٍ رَ عِسِرَيِلَ شَ دِيٍ شَ قٍ مَ، عَلْ عَلَتَلَ مُنسَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","عٍ دٌنمَ كَنكٍ رَشُنمَسٍ يَءِلَن نّ عَ قَنيِ رَ عَلْ دٌنمَ كُيٍ. عٍ نَ سُوَ دُفِ سْشْ شّيمَ فّسّ، فّسّ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","عَ شَ كُيّ نُن عَ شَ عِفبٌيَ لَن نّ سُشُي كٍرٍن مَ، عَ قِندِ دُفِ قِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","فّمّ تٌقَنيِيٍ سَقّ نَانِ نُ نَ عَ مَ. سَقّ سِنفٍ قِندِ فّمّيٍ نَن نَ، نَشٍيٍ شِلِ سَرِدُوَنِ، تٌثَسِ، نُن عٍمٍرٌدٍ. ");
INSERT INTO susa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","سَقّ قِرِن ندٍ، عٍسِكَرِبُكُلُ، سَقِرِ، نُن دِيَمَن. ");
INSERT INTO susa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","سَقّ سَشَن ندٍ، عٌثَلٍ، عَفَتِ، نُن عَمٍتِسِتٍ. ");
INSERT INTO susa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","سَقّ نَانِ ندٍ، كِرٌ سٌلِتٍ، عٌنِشِ، نُن يَسِثٍ. شّيمَ نُ نَ نَ فّمّ بِرِن رَبِلِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","عِسِرَيِلَ شَ دِيٍ شِلِيٍ مَسٌلِ نَ فّمّ قُ نُن قِرِن مَ، عَلْ سّبّلِ مَسٌلِمَ شُرُندّ مَ كِ نَشّ. كَنكَن شِلِ مَسٌلِ فّمّ ندٍ مَ. عٍ قِندِ عِسِرَيِلَ بْنسْي قُ نُن قِرِنيِ مَتْنشُمَ سٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","عٍ لُوتِ دِيٍ دّفّ نّ نَ دٌنمَ كَنكٍ رَشُنمَسٍ مَ، نَشٍيٍ يَءِلَنشِ شّيمَ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","عٍ شُرُندّ قِرِن يَءِلَن شّيمَ رَ، عٍ عٍ دّفّ دٌنمَ كَنكٍ رَشُنمَسٍ مَ عَ دّ كِرِ قِرِنيِيٍ مَ عَ قُفٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","عٍ نَ لُوتِ شّيمَ دَاشِيٍ شِرِ نَ شُرُندّ قِرِنيِيٍ مَ، نَشٍيٍ دّفّشِ دٌنمَ كَنكٍ رَشُنمَسٍ دّ كِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","عٍ مَن نَ لُوتِ قِرِنيِيٍ شِرِ دٌنمَ كُيٍ تُنكِ رَشُنمَسٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","عٍ شُرُندّ قِرِن فبّتّ يَءِلَن شّيمَ رَ، نَشٍيٍ دّفّمَ دٌنمَ كَنكٍ رَشُنمَسٍ دّ كِرِيٍ مَ عَ لَبٍ رَ. عٍ نٍيٍ دّفّ دٌنمَ كُيٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","عٍ مَن نَشَ شُرُندّ قِرِن فبّتّ يَءِلَن شّيمَ رَ، نَشٍيٍ دّفّمَ تُنكِ رَشُنمَسٍيٍ لَبٍ رَ، دّننَشّ عِلَنمَ بّلّتِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","دٌنمَ كَنكٍ رَشُنمَسٍ نَشَ شِرِ دٌنمَ كُيٍ مَ لُوتِ فّرّ دَاشِ رَ نَشَن نَسٌمَ شُرُندّيٍ كُي نَشٍيٍ دّفّشِ دٌنمَ كَنكٍ رَشُنمَسٍ نُن دٌنمَ كُيٍ مَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","عٍ نَشَ سّرّشّدُبّ شَ دٌنمَ كُيٍ بُن مَفٌرٌي سْشْ فّسّ فّرّ دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","عٍ نَشَ عَ شُنيِ رَ سٌدٍ شَبَ عَ تَفِ، عٍ نَ سٌدٍ دّ مَسْشْ، عَلَكٌ بْودٍ يٌ نَشَ لُ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","عٍ نَشَ عَ رَشُنمَ ثِرِنتِ فّرّ دَاشِ، بُلُ دَاشِ، نُن عَ فبٍيلِ رَ نَشٍيٍ مِسَالِشِ وُرِ بٌفِ رَ عَ رَبِلِنيِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","عٍ نَشَ تْلْنيِ شّيمَ دَاشِيٍ دّفّ نَ ثِرِنتِيٍ تَفِ، عَلَكٌ تْلْنيِ ندٍ شَ لُ وُرِ بٌفِ بِرِن تَفِ نَ دٌنمَ كُيٍ بُن مَفٌرٌي سَنبُنيِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","تْلْنيِ ندٍ لُ وُرِ بٌفِ بِرِن تَفِ نَ دٌنمَ كُيٍ بُن مَفٌرٌي سَنبُنيِ بِرِن مَ، عَلَكٌ سّرّشّدُبّ شَ وَلِ رَبَ عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","عٍ نَشَ دٌنمَ كُيٍ بُن مَفٌرٌي فبّتّ دّفّ سُوَ دُفِ رَ، نَشَن سْشْشِ عَ قَنيِ رَ، هَرُنَ نُن عَ شَ دِ شّمّيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","شُنمَسٍيٍ نَشَ يَءِلَن سُوَ دُفِ رَ. عٍ نَشَ وَنتَن بُن سٌي قَن دّفّ سُوَ دُفِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","عٍ نَشَ بّلّتِ يَءِلَن سُوَ دُفِ رَ، نَشَن مَسْشْشِ عَ فّرّ دَاشِ، عَ بُلُ دَاشِ، نُن عَ فبٍيلِ رَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","عٍ نَشَ وَلَشّ لَنمَدِ يَءِلَن شّيمَ رَ، عَ قِندِ تْنشُمَ سّنِيّنشِ رَ. عٍ نَشَ سّبّلِ مَسٌلِ عَ مَ، عَلْ عٍ سّبّلِ مَسٌلِمَ شُرُندّ مَ كِ نَشّ، عَ مَسٍنقٍ رَ، «مِشِ سّنِيّنشِ عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","عٍ نَشَ عَ شِرِ فّسّ فّرّ دَاشِ نُن فّسّ بُلُ دَاشِ رَ شُنمَسٍ مَ عَ تِفِ رَ، عَلْ عَلَتَلَ مُنسَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","هْرْ مْلِنفِرَ شَ وَلِ رَحْن نَ كِ نّ، عَلَ مِشِ لِمَ دّننَشّ. عِسِرَيِلَكَيٍ عَ بِرِن نَبَ نّ عَلْ عَلَتَلَ مُنسَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","عٍ نَشَ هْرْ مْلِنفِرَ شَنِن مُنسَ شْن مَ نُن عَ سٍ بِرِن؛ تّتّ نُن عَ سٍيٍ، سُشُسٍيٍ، شٍبٍنيِيٍ، وُرِ كُيٍيٍ مْولِ قِرِن، وُرِ سَنبُنيِيٍ، ");
INSERT INTO susa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","هْرْ مْلِنفِرَ مَكٌتٌسٍيٍ، نَشَن يَءِلَنشِ يّشّي كٌنتٌنيِ كِرِ فبٍيلِ رَ، عَ نُن نَشَن يَءِلَنشِ ثٍرٍ مُي كِرِ رَ، دُفِ نَشَن فبَكُشِ يِرٍ سّنِيّنشِ قِسَمَنتٍ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","سَاتّ كَنكِرَ نُن عَ شَ وُرِ كُيٍيٍ، سٍيدٍ كَنكِرَ دّرَكٌتٍ، ");
INSERT INTO susa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","تٍيبِلِ، تٍيبِلِ شَ يِرَبَسٍ بِرِن، تَامِ نَشَن سَمَ تٍيبِلِ قَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","لَنثُي دْشْسٍ شّيمَ دَاشِ، لَنثُييٍ نُن عٍ يِرَبَسٍ بِرِن، لَنثُي تُرٍ، ");
INSERT INTO susa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","سُرَيِ سّرّشّبَدٍ شّيمَ دَاشِ، تُرٍ سّنِيّنشِ، سُرَيِ، دُفِ نَشَن فبَكُشِ تّتّ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","سّرّشّبَدٍ وُرٍ فبٍيلِ دَاشِ، عَ شَ وُرِ كُيٍيٍ، وُرٍيٍ سُبٍ سَمَ نَشٍيٍ قَرِ، عَ شَ يِرَبَسٍ بِرِن، يٍ سَسٍ شُنفبٍ نُن عَ دْشْسٍ، ");
INSERT INTO susa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","تّتّ دُفِيٍ، وُرِيٍ دُفِيٍ فبَكُمَ نَشٍيٍ مَ نٍيٍ سَنبُنيِيٍ، دُفِ نَشَن فبَكُشِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، لُوتِيٍ، وُرِيٍ لُوتِيٍ شِرِ مَ نَشٍيٍ رَ، عَ نُن هْرْ مْلِنفِرَ شَ يِرَبَسٍ بِرِن، عَلَ مَشَندِ يِرٍ، ");
INSERT INTO susa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","سّرّشّدُبّيٍ شَ سٌسٍ نَشٍيٍ رَوَلِمَ يِرٍ سّنِيّنشِ كُي، هَرُنَ نُن عَ شَ دِيٍ شَ سٌسٍ سّنِيّنشِيٍ نَشٍيٍ رَوَلِمَ عٍ شَ سّرّشّدُبّ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","عِسِرَيِلَكَيٍ نَشَ نَ وَلِ بِرِن نَبَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","مُنسَ تٌ نَ وَلِ بِرِن تٌ عَ رَبَشِ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ، عَ نَشَ دُبَ عِسِرَيِلَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«كِكٍ سِنفٍ شِ سِنفٍ، عِ شَ هْرْ مْلِنفِرَ تِ، عَلَ وٌ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","عِ شَ سَاتّ كَنكِرَ دْشْ نَ كُي دُفِ شَنبِ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","عِ شَ تٍيبِلِ يَءِلَن مّننِ، عِ قَ سٍيٍ دْشْ عَ مَ عَ رَبَ كِ مَ. عِ شَ لَنثُي دْشْسٍ تِ نَا، عِ قَ لَنثُييٍ دْشْ عَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","عِ شَ سُرَيِ سّرّشّبَدٍ شّيمَ دَاشِ دْشْ سَاتّ كَنكِرَ يَ رَ، عِ قَ دُفِ فبَكُ هْرْ مْلِنفِرَ سٌدٍ دّ رَ عَلَ مَشَندِ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","عِ شَ سّرّشّبَدٍ دْشْ هْرْ مْلِنفِرَ سٌدٍ يَ رَ، عَلَ وٌ لِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","عِ شَ يٍ سَسٍ شُنفبٍ دْشْ هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ تَفِ، عِ قَ يٍ سَ عَ كُي. ");
INSERT INTO susa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","عِ شَ هْرْ مْلِنفِرَ تّتّ تِ، عِ قَ دُفِ فبَكُ تّتّ سٌدٍ دّ رَ.» ");
INSERT INTO susa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«عِ نَ فّ نَ رَ، عِ شَ تُرٍ سّنِيّنشِ تٌنفٌ، عِ قَ عَ سَ هْرْ مْلِنفِرَ نُن عَ كُي سٍ بِرِن مَ، عٍ شَ سّنِيّن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","عِ مَن شَ نَ رَبَ سّرّشّبَدٍ نُن عَ يِرَبَسٍ بِرِن مَ. عٍ شَ سّنِيّن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","عِ مَن شَ نَ رَبَ يٍ سَسٍ شُنفبٍ نُن عَ دْشْسٍ مَ، عٍ شَ سّنِيّن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«عِ شَ هَرُنَ نُن عَ شَ دِيٍ مَلَن هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عِ قَ عٍ مَشَ يٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","عِ شَ سّرّشّدُبّ سٌسٍ سّنِيّنشِيٍ رَفٌرٌ هَرُنَ مَ، عِ قَ تُرٍ سّنِيّنشِ سَ عَ مَ عَلَكٌ عَ شَ قِندِ ﭑ مَ سّرّشّدُبّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","عِ شَ سّرّشّدُبّ سٌسٍ سّنِيّنشِيٍ رَفٌرٌ عَ شَ دِيٍ قَن مَ، ");
INSERT INTO susa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","عِ قَ تُرٍ سّنِيّنشِ سَ عٍ مَ عَلْ عِ نَشَن نَبَشِ عٍ بَبَ رَ، عَلَكٌ عٍ قَن شَ قِندِ ﭑ مَ سّرّشّدُبّيٍ رَ. نَ وَلِ لُمَ عٍ يِ رَ، عَ نُن نَشٍيٍ قَمَ عٍ شَنبِ رَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","نَ تّمُي مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ بِرِن نَبَ عَلْ عَ قَلَ عَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","كٍلِقٍ عٍ مِنِ مِسِرَ بْشِ كُي تّمُي نَشّ، حّ قِرِن ندٍ، كِكٍ سِنفٍ، تّنفّ سِنفٍ لْشْي، عَ نَشَ هْرْ مْلِنفِرَ تِ. ");
INSERT INTO susa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","مُنسَ نَشَ هْرْ مْلِنفِرَ سَنبُنيِيٍ سَ، عَ عَ وُرِ بِرِن تِ، ");
INSERT INTO susa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","عَ قَ دُفِيٍ عِتَلَ هْرْ مْلِنفِرَ شُن مَ، عَ نُن عَ مَكٌتٌسٍيٍ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","مُنسَ نَشَ سَاتّ وَلَشّ قِرِنيِيٍ سَ سَاتّ كَنكِرَ كُي، عَ قَ كَنكِرَ وُرِيٍ رَ سٌ كَنكِرَ سُشُسٍ دِفِلِنشِيٍ كُي، عَ كَنكِرَ دّرَكٌتٍ سَ عَ دّ رَ نَشَن قِندِشِ شُنسَرٍ يِرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","عَ تٌ فّ نَ رَبَدٍ، عَ نَشَ سَاتّ كَنكِرَ شَنِن هْرْ مْلِنفِرَ كُي، عَ عَ دْشْ يِرٍ سّنِيّنشِ قِسَمَنتٍ كُي. عَ نَشَ دُفِ فبَكُ نَ يَ رَ، عَلَكٌ مِشِ يٌ نَشَ عَ تٌ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","عَ نَشَ هْرْ مْلِنفِرَ تٍيبِلِ دْشْ دُفِ يَ رَ عَ كْولَ مَبِرِ، ");
INSERT INTO susa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","عَ قَ تَامِيٍ سَ عَ قَرِ عَ سَقّ كِ مَ عَلَتَلَ يَ شْرِ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","عَ نَشَ لَنثُي دْشْسٍ تِ هْرْ مْلِنفِرَ كُي تٍيبِلِ يَ رَ عَ يِرٍقَنيِ مَبِرِ، ");
INSERT INTO susa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","عَ قَ لَنثُييٍ تِ نَ قَرِ عَلَتَلَ يَ شْرِ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","عَ نَشَ سُرَيِ سّرّشّبَدٍ دْشْ هْرْ مْلِنفِرَ كُي دُفِ فبَكُشِ عَ يَ رَ، ");
INSERT INTO susa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","عَ قَ سُرَيِ فَن مّننِ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","عَ نَشَ دُفِ فبَكُ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","عَ نَشَ سّرّشّبَدٍ دْشْ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عَ نَشَ سّرّشّ فَن دَاشِ بَ مّننِ نُن هَدِيَ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","عَ نَشَ يٍ سَسٍ شُنفبٍ دْشْ هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ تَفِ، عَ يٍ سَ عَ كُي مَرَ سّنِيّنيِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","مُنسَ، هَرُنَ، نُن هَرُنَ شَ دِيٍ نُ لُمَ عٍ بّلّشّيٍ نُن عٍ سَنيِيٍ مَشَ رَ نَا، ");
INSERT INTO susa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","عٍ سٌمَ هْرْ مْلِنفِرَ كُي تّمُي نَشّ، عَ نُن عٍ سّرّشّ بَمَ تّمُي نَشّ عَلْ عَلَتَلَ مُنسَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","مُنسَ نَشَ تّتّ رَبِلِن هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ رَ، عَ قَ دُفِ فبَكُ تّتّ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","مُنسَ تٌ فّ نَ بِرِن نَ، نُشُي نَشَ دِن هْرْ مْلِنفِرَ شُن مَ، عَلَ عٍ لِمَ دّننَشّ. عَلَتَلَ شَ نْرّ نَشَ هْرْ مْلِنفِرَ رَقٍ، ");
INSERT INTO susa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","هَن نَ نَشَ عَ نِيَ مُنسَ مُ نُ نْمَ سٌدٍ نَ كُي. عَلَتَلَ شَ نْرّ نُ بَرَ نَ رَقٍ، نُشُي قَن نُ رَدِنشِ نَ بِرِن شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","كٍلِقٍ نَ تّمُي عٍ شَ بِيَاسِيٍ كُي، عِسِرَيِلَكَيٍ مُ حّرّ قْلْمَ قٌ نُشُي نَ كٍلِ هْرْ مْلِنفِرَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","شَ نُشُي مُ تٍ هْرْ مْلِنفِرَ شُن مَ، عِسِرَيِلَكَيٍ مُ حّرّ رَ مِنِمَ سِفَقٍ يِرٍ فبّتّ. ");
INSERT INTO susa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","عَلَتَلَ شَ نُشُي نُ لُمَ هْرْ مْلِنفِرَ شُن مَ يَنيِ نُن كْي رَ. عِسِرَيِلَكَيٍ نُ تّ دّشّشِ تٌمَ نُشُي كُي كْي رَ. عَ لُ نَ كِ نّ عٍ شَ بِيَاسِ بِرِن كُي.");
INSERT INTO susa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","عَلَتَلَ نَشَ عَننَبِ مُنسَ شِلِ عَ شَ هْرْ مْلِنفِرَ كُي، عَ عَ مَسٍن عَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، نَشَن نَ وَ سّرّشّ بَقٍ ﭑ تَن عَلَتَلَ بّ، عَ شَ شُرُ سٍ لَنمَ شَ نَ مُ عَ رَ شُرُ سٍ شُنفبٍ بَ. ");
INSERT INTO susa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","شَ عَ وَ مَ شُرُ سٍ شُنفبٍ نَن بَقٍ سّرّشّ فَن دَاشِ رَ، قٌ عَ شَ قِندِ تُورَ رَ لَنيُرُ مُ نَ نَشَن مَ. عَ شَ قَ نَ رَ ﭑ تَن عَلَتَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عَلَكٌ ﭑ شَ عَ تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","سّرّشّبَ شَ عَ بّلّشّ سَ شُرُ سٍ شُن تَفِ، عَلَكٌ ﭑ تَن عَلَتَلَ شَ نَ سّرّشّ تٌنفٌ، عَ شَ قِندِ عَ شُنسَرٍ رَ عَ شَ يُنُبِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","نَ تُورَ شَ قَشَ ﭑ تَن عَلَتَلَ يَ عِ. هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ قَ نَ تُورَ وُلِ رَ، عٍ شَ عَ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ، سّرّشّبَدٍ نَشَن نَ ﭑ مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","عٍ شَ تُورَ بُرَ، عٍ قَ عَ عِسّفّ. ");
INSERT INTO susa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ يٍفٍ رَدْشْ، عٍ تّ رَدّشّ. ");
INSERT INTO susa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","عٍ مَن شَ سّرّشّ سُبٍ، عَ شُنيِ، نُن عَ تُرٍ سَ تّ عِ سّرّشّبَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","عَ قُرِنفّ نُن عَ سَنيِيٍ شَ رَشَ. سّرّشّدُبّ شَ نَ بِرِن فَن سّرّشّبَدٍ. سّرّشّ فَن دَاشِ نَ عَ رَ نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«شَ مِشِ وَ مَ سّرّشّ فَن دَاشِ بَقٍ شُرُ سٍ لَنمَ رَ، عَ شَ قِندِ يّشّي كٌنتٌنيِ رَ، شَ نَ مُ عَ رَ سِكْتّ، لَنيُرُ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","سّرّشّبَ شَ نَ كْن نَشَبَ سّرّشّبَدٍ كْولَ مَبِرِ ﭑ تَن عَلَتَلَ يَ عِ. هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ عَ وُلِ تٌنفٌ، عٍ شَ عَ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","عٍ نَ فّ سُبٍ عِشَبَدٍ، سّرّشّدُبّ شَ عَ سُبٍ، عَ شُنيِ، نُن عَ تُرٍ سَ تّ سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","سّرّشّبَ شَ سّرّشّ قُرِنفّ نُن عَ سَنيِيٍ رَشَ. سّرّشّدُبّ شَ نَ بِرِن فَن سّرّشّبَدٍ. سّرّشّ فَن دَاشِ نَ عَ رَ نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«شَ عَ وَ مَ شْنِ بَقٍ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ، قٌ عَ شَ قِندِ كٌلٌكٌندٍ نَن نَ، شَ نَ مُ عَ رَ فَنبّ يْرّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","سّرّشّدُبّ شَ قَ عَ رَ سّرّشّبَدٍ، عَ عَ شُنيِ بٌلٌن عَ دّ عِ، عَ عَ سَ تّ، عَ عَ فَن. عَ وُلِ شَ عِقِلِ سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","عَ شَ عَ فّمّ بْوتْ بَ، عَ عَ وْلّ تّ عِ شُبٍ شُن، سّرّشّبَدٍ سٌفٍتٍدٍ مَبِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","سّرّشّدُبّ شَ عَ سُشُ عَ فَبُتٍنيِيٍ مَ، عَ عَ عِبْو. عَ شَ عَ فَن، عَ قِندِ سّرّشّ فَن دَاشِ رَ، نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«شَ مِشِ وَ مَ سّرّشّ بَقٍ ﭑ تَن عَلَتَلَ بّ نَشَن قِندِشِ سَنسِ شْرِ رَ، عَ شَ عَ لُشُتَ عَ قَنيِ رَ. عَ شَ تُرٍ سَ عَ قَرِ، عَ سُرَيِ قَن سَ تُرٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","عَ شَ نَ سٌ هَرُنَ شَ دِ سّرّشّدُبّيٍ يِ رَ. سّرّشّدُبّ ندٍ شَ سَنسِ شْرِ لُشُتَشِ بّلّشّ يَ كٍرٍن كْ، تُرٍ سَشِ نَشَن قَرِ، عَ نُن سُرَيِ، عَ شَ عَ سَ تّ عِ. نَ شَ فَن ﭑ تَن عَلَتَلَ بّ، عَ شَ قِندِ تْنشُمَ رَ نَ سّرّشّ بِرِن شَ قٍ رَ. سّرّشّ فَن دَاشِ نَ عَ رَ نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","سَنسِ شْرِ لُشُتَشِ نَشَن لُشِ نَا قِندِ مَ هَرُنَ نُن عَ شَ دِيٍ نَن فبٍ رَ. عَ سّنِيّن بَرِ مَ عَ بَشِ سّرّشّ فَنشِ نَن نَ نَشَن بَشِ ﭑ تَن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«شَ مِشِ وَ مَ سّرّشّ بَقٍ ﭑ تَن عَلَتَلَ بّ نَشَن قِندِشِ تَامِ فَنشِ رَ، عَ شَ نَ يَءِلَن سَنسِ شْرِ لُشُتَشِ رَ لّبِنِ مُ نَ نَشَن شُن. تُرٍ شَ مَسُنبُ نَ قَن نَ. تَامِ لّبِنِتَرٍ شُنشُرِيٍ قَن نْمَ يَءِلَندٍ، تُرٍ مَسٌشِ نَشٍيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«شَ مِشِ وَ مَ سّرّشّ بَقٍ نَشَن قِندِشِ تَامِ فِلِنشِ رَ، عَ شَ نَ يَءِلَن سَنسِ شْرِ لُشُتَشِ رَ لّبِنِ مُ نَ نَشَن شُن. تُرٍ شَ مَسُنبُ نَ قَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","عَ نَ فّ فِلِندٍ، عَ شَ عِفِرَ، تُرٍ سَ عَ مَ، عَ شَ قِندِ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«شَ مِشِ وَ مَ سّرّشّ بَقٍ نَشَن قِندِشِ تَامِ رَ نَشَن فَنشِ تُندٍ كُي، عَ شَ نَ يَءِلَن سَنسِ شْرِ لُشُتَشِ نُن تُرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","عَ لَنمَ مِشِ شَ قَ نَ سّرّشّ مْولِ رَ ﭑ تَن عَلَتَلَ بّ. شَ نَ بَرَ سٌ سّرّشّدُبّ يِ رَ، عَ نَ شَنِنمَ سّرّشّبَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","عَ شَ ندٍ تٌنفٌ نَشَن قِندِ مَ تْنشُمَ رَ، عَ شَ نَ فَن سّرّشّبَدٍ قَرِ، عَ شَ قِندِ سّرّشّ رَ، نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","سَنسِ شْرِ دِنشِ نَشَن لُشِ عَ قِندِ مَ هَرُنَ نُن عَ شَ دِيٍ نَن فبٍ رَ. عَ سّنِيّن بَرِ مَ عَ بَشِ سّرّشّ فَنشِ نَن نَ نَشَن بَشِ ﭑ تَن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«سّرّشّ نَشَن بِرِن بَمَ ﭑ تَن عَلَتَلَ بّ، لّبِنِ يٌ نَشَ لُ عَ شُن. عَ مُ لَن وٌ شَ سّرّشّ فَن دَاشِ يٌ بَ ﭑ تَن عَلَتَلَ بّ لّبِنِ نَ نَشَن شُن، شَ نَ مُ عَ رَ كُمِ. ");
INSERT INTO susa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","وٌ نْمَ لّبِنِ نُن كُمِ سَدٍ سَنسِ بٌفِ سِنفٍيٍ شُن مَ نَشٍيٍ بَمَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، كْنْ عٍ نَشَ فَن سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","قْشْي شَ سَ نَ سّرّشّ مْولِ بِرِن مَ، بَرِ مَ نَ بَرَ قِندِ سَاتّ تْنشُمَ رَ وٌ تَن نُن وٌ مَرِفِ عَلَ تَفِ. قْشْي شَ سَ وٌ شَ سّرّشّ بِرِن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«شَ وٌ وَ مَ سّرّشّ بَقٍ ﭑ تَن عَلَتَلَ بّ وٌ شَ سَنسِ بٌفِ سِنفٍ رَ، وٌ شَ تْنسْي نّينّ فَن، ");
INSERT INTO susa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","وٌ تُرٍ نُن سُرَيِ سَ عَ شُن، عَ شَ قِندِ سَنسِ بٌفِ سِنفٍ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","سّرّشّدُبّ شَ ندٍ تٌنفٌ نَ سَنسِ شْرِ، تُرٍ، نُن سُرَيِ رَ، نَ شَ قِندِ تْنشُمَ رَ. عَ شَ نَ فَن سّرّشّبَدٍ قَرِ. عَ شَ قِندِ سّرّشّ رَ، نَشَن شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«شَ مِشِ وَ مَ شُرُ سٍ شُنفبٍ بَقٍ شَنُنتٍيَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، شُرُ سٍ شّمّمَ، شَ نَ مُ عَ رَ فِنّمَ، عَ شَ قِندِ شُرُ سٍ رَ لَنيُرُ يٌ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","عَ شَ عَ بّلّشّ سَ نَ شُرُ سٍ شُن تَفِ ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عَ عَ كْن نَشَبَ. هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ نَ شُرُ سٍ وُلِ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","شَنُنتٍيَ سّرّشّ كُي، عَ لَنمَ تُرٍ نَشَن نَ قُرِنفّ سّيتِ مَ، عَ شَ فَن تّ عِ ﭑ تَن عَلَتَلَ يَ عِ، ");
INSERT INTO susa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","عَ نُن عَ فُنفُي قِرِنيِ، عٍ تُرٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","هَرُنَ شَ دِيٍ شَ نَ بِرِن فَن سّرّشّ فَن دَاشِ شُن مَ، نَشَن نَ فَنقٍ سّرّشّبَدٍ قَرِ. عَ شَ قِندِ سٍ شِرِ حْشُنمّ رَ ﭑ تَن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«شَ مِشِ وَ مَ شُرُ سٍ لَنمَ بَقٍ شَنُنتٍيَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، شُرُ سٍ شّمّمَ، شَ نَ مُ عَ رَ فِنّمَ، عَ شَ قِندِ شُرُ سٍ رَ لَنيُرُ يٌ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","شَ مِشِ وَ مَ يّشّي بَقٍ سّرّشّ رَ، عَ شَ نَ مَسٍن ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","عَ شَ عَ بّلّشّ سَ عَ شُن تَفِ، عَ قَ عَ كْن نَشَبَ ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ نَ شُرُ سٍ وُلِ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","يِ شَنُنتٍيَ سّرّشّ كُي، عَ لَنمَ عَ تُرٍ، عَ شُلِ، تُرٍ نَشَن نَ قُرِنفّ سّيتِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","عَ فُنفُي قِرِنيِ، عٍ تُرٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ، نَ بِرِن شَ فَن تّ عِ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","سّرّشّدُبّ شَ نَ فَن سّرّشّبَدٍ قَرِ. تّ شَ نَ بِرِن فَن. نَ بَرَ قِندِ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«شَ مِشِ وَ مَ سِ بَقٍ سّرّشّ رَ، عَ شَ نَ مَسٍن ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","عَ شَ عَ بّلّشّ سَ عَ شُن تَفِ، عَ قَ عَ كْن نَشَبَ ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، هَرُنَ شَ دِ سّرّشّدُبّيٍ شَ نَ شُرُ سٍ وُلِ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","يِ شَنُنتٍيَ سّرّشّ كُي، عَ لَنمَ عَ تُرٍ نَشَن نَ قُرِنفّ سّيتِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","عَ فُنفُي قِرِنيِ، عٍ تُرٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ، نَ بِرِن شَ فَن تّ عِ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","سّرّشّدُبّ شَ نَ فَن سّرّشّبَدٍ قَرِ. تّ شَ نَ بِرِن فَن. نَ بَرَ قِندِ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ نَشَن شِرِ رَقَن ﭑ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«مِشِ يٌ نَشَ سُبٍ تُرٍ دٌن، مِشِ يٌ نَشَ سُبٍ وُلِ مِن. وٌ سَبَتِ دّدّ، نَ بَرَ قِندِ يَامَرِ رَ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، شَ مِشِ ندٍ سَ يُنُبِ رَبَ، كْنْ عَ مُ كٍلِ عَ حَنِفٍ مَ، عَ شَ بِرَ يِ سّرِيّ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","شَ سّرّشّدُبّ كُنتِفِ سَ عَلَ شَ يَامَرِ ندٍ مَتَندِ، نَ قَ قِندِ يُنُبِ رَ حَمَ بّ، عَ لَنمَ عَ شَ تُورَ بَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، لَنيُرُ مُ نَ نَشَن مَ، عَلَكٌ نَ شَ قِندِ يُنُبِ شَقَرِ سّرّشّ رَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","عَ شَ تُورَ شَنِن ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ ﭑ يَ عِ، عَ عَ بّلّشّ سَ عَ شُن تَفِ، عَ قَ عَ كْن نَشَبَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","سّرّشّدُبّ كُنتِفِ شَ نَ تُورَ وُلِ شَنِن ﭑ مَ هْرْ مْلِنفِرَ كُي، ");
INSERT INTO susa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","عَ عَ بّلّشّسٌلٍ رَفٌرٌ نَ وُلِ شْورَ، عَ عَ كَسَن سَنيَ سٌلٌقٍرٍ دُفِ يَ رَ نَشَن فبَكُشِ يِرٍ سّنِيّنشِ مَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","سّرّشّدُبّ شَ وُلِ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نَ سُرَيِ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ، نَشَن نَ ﭑ تَن عَلَتَلَ يَ عِ ﭑ مَ هْرْ مْلِنفِرَ كُي. وُلِ نَشَن لُشِ، عَ شَ نَ عِقِلِ سّرّشّ فَن دَاشِ سّرّشّبَدٍ لَنبَنيِ مَ، نَشَن نَ ﭑ تَن عَلَتَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","عَ شَ تُرٍ بِرِن بَ تُورَ مَ نَشَن قِندِشِ يُنُبِ شَقَرِ سّرّشّ رَ، تُرٍ نَشَن نَ عَ قُرِنفّ سّيتِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","عَ فُنفُي قِرِنيِ، عٍ تُرٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","عَ شَ نَ رَبَ عَلْ شَنُنتٍيَ سّرّشّ رَبَمَ كِ نَشّ. سّرّشّدُبّ شَ نَ فَن سّرّشّ فَن دَاشِ سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","كْنْ تُورَ كِرِ، عَ سُبٍ، عَ شُنيِ، عَ سَنيِيٍ، عَ قُرِنفّ، نُن عَ حَحّ، ");
INSERT INTO susa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","نَ تُورَ دْنشْي بِرِن شَ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، يِرٍ سّنِيّنشِ، تّ شُبٍ وْلّمَ دّننَشّ. مّننِ عَ شَ فَن تّ رَ نَ تّ شُبٍ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«شَ عِسِرَيِلَ حَمَ بِرِن نَن سَ ﭑ تَن عَلَ شَ يَامَرِ ندٍ مَتَندِشِ، كْنْ نَ مُ كٍلِ عٍ حَنِفٍ مَ، نَ قِندِ مَ يُنُبِ رَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","عٍ نَ قَهَامُي سْتْ نَ مَ تّمُي نَشّ، حَمَ شَ تُورَ يْرّ بَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ هْرْ مْلِنفِرَ سٌدٍ دّ رَ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","حَمَ قٌرِيٍ شَ عٍ بّلّشّ سَ تُورَ شُن تَفِ ﭑ تَن عَلَتَلَ يَ عِ، عٍ عَ كْن نَشَبَ. ");
INSERT INTO susa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","سّرّشّدُبّ كُنتِفِ شَ نَ تُورَ وُلِ شَنِن ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ كُي، ");
INSERT INTO susa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","عَ عَ بّلّشّسٌلٍ رَفٌرٌ نَ وُلِ شْورَ، عَ عَ كَسَن سَنيَ سٌلٌقٍرٍ دُفِ يَ رَ نَشَن فبَكُشِ يِرٍ سّنِيّنشِ مَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","سّرّشّدُبّ شَ وُلِ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نُ نَ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ، نَشَن نَ ﭑ تَن عَلَتَلَ يَ عِ ﭑ مَ هْرْ مْلِنفِرَ كُي. وُلِ نَشَن لُشِ، عَ شَ نَ عِقِلِ سّرّشّ فَن دَاشِ سّرّشّبَدٍ لَنبَنيِ مَ، نَشَن نَ ﭑ مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","عَ شَ تُرٍ بِرِن بَ تُورَ مَ، عَ نَ فَن سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","عَ شَ يِ تُورَ بَ سّرّشّ رَ عَلْ نَشَن بَمَ يُنُبِ شَقَرِ سّرّشّ رَ. عٍ بَ كِ بِرِن كٍرٍن. نَ كُي، سّرّشّدُبّ سّرّشّ بَمَ نَشَن قِندِ مَ عٍ شُنسَرٍ رَ، عَلَكٌ عٍ شَ يُنُبِيٍ شَ شَقَرِ. ");
INSERT INTO susa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","عَ شَ نَ تُورَ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، عَ شَ عَ فَن عَلْ بٌورٍ تُورَ فَنمَ كِ نَشّ. نَ قِندِ مَ يُنُبِ شَقَرِ سّرّشّ نَن نَ حَمَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«شَ مَنفّ ندٍ عَ مَرِفِ عَلَتَلَ شَ يَامَرِ ندٍ مَتَندِ، كْنْ نَ مُ كٍلِ عَ حَنِفٍ مَ، نَ قِندِ مَ يُنُبِ رَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","عَ نَ قَهَامُي سْتْ نَ مَ تّمُي نَشّ، عَ شَ سِكْتّ بَ سّرّشّ رَ، لَنيُرُ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","عَ شَ عَ بّلّشّ سَ سِكْتّ شُن تَفِ مَ ﭑ تَن عَلَتَلَ يَ عِ، عَ عَ كْن نَشَبَ سّرّشّ فَن دَاشِيٍ كْن نَشَبَمَ دّننَشّ. يُنُبِ شَقَرِ سّرّشّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","سّرّشّدُبّ شَ عَ بّلّشّسٌلٍ رَفٌرٌ نَ وُلِ شْورَ نَشَن بَشِ يُنُبِ شَ قٍ رَ، عَ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نَ سّرّشّ فَن دَاشِ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ. وُلِ نَشَن لُشِ، عَ شَ نَ عِقِلِ سّرّشّ فَن دَاشِ سّرّشّبَدٍ لَنبَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","عَ شَ نَ تُرٍ بِرِن فَن سّرّشّبَدٍ قَرِ، عَلْ شَنُنتٍيَ سّرّشّ رَبَمَ كِ نَشّ. نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ مَنفّ بّ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«شَ مِشِ ندٍ سَ عَ مَرِفِ عَلَتَلَ شَ يَامَرِ ندٍ مَتَندِ، كْنْ نَ مُ كٍلِ عَ حَنِفٍ مَ، نَ قِندِ مَ يُنُبِ رَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","عَ نَ قَهَامُي سْتْ نَ مَ تّمُي نَشّ، عَ شَ سِ فِنّ بَ سّرّشّ رَ، لَنيُرُ مُ نَ نَشَن مَ، عَ شَ يُنُبِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","عَ شَ عَ بّلّشّ سَ نَ يُنُبِ شَقَرِ سّرّشّ شُن تَفِ، عَ عَ كْن نَشَبَ سّرّشّ فَن دَاشِيٍ كْن نَشَبَمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","سّرّشّدُبّ شَ عَ بّلّشّسٌلٍ رَفٌرٌ نَ وُلِ شْورَ نَشَن بَشِ يُنُبِ شَ قٍ رَ، عَ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نَ سّرّشّ فَن دَاشِ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ. وُلِ نَشَن لُشِ، عَ شَ نَ عِقِلِ سّرّشّ فَن دَاشِ سّرّشّبَدٍ لَنبَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","عَ شَ نَ تُرٍ بِرِن بَ سِ مَ، عَلْ شَنُنتٍيَ سّرّشّ رَبَمَ كِ نَشّ، عَ نَ فَن سّرّشّبَدٍ قَرِ، عَ شَ قِندِ سٍ شِرِ حْشُنمّ رَ ﭑ تَن عَلَتَلَ بّ. نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ نَ مِشِ بّ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«شَ عَ يّشّي بَمَ يُنُبِ شَقَرِ سّرّشّ رَ، قٌ عَ شَ قِندِ يّشّي فِنّمَ لَنيُرُ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","عَ شَ عَ بّلّشّ سَ نَ يُنُبِ شَقَرِ سّرّشّ شُن تَفِ، عَ عَ كْن نَشَبَ سّرّشّ فَن دَاشِيٍ كْن نَشَبَمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","سّرّشّدُبّ شَ عَ بّلّشّسٌلٍ رَفٌرٌ نَ وُلِ شْورَ نَشَن بَشِ يُنُبِ شَقَرِ سّرّشّ رَ، عَ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نَ سّرّشّ فَن دَاشِ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ. وُلِ نَشَن لُشِ، عَ شَ نَ عِقِلِ سّرّشّ فَن دَاشِ سّرّشّبَدٍ لَنبَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","عَ شَ نَ تُرٍ بِرِن بَ يّشّي مَ، عَلْ شَنُنتٍيَ سّرّشّ رَبَمَ كِ نَشّ، عَ شَ نَ فَن سّرّشّيٍ قَرِ نَشٍيٍ فَنمَ سّرّشّبَدٍ قَرِ. نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ نَ مِشِ بّ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«شَ مِشِ ندٍ سَ عَ مّ عٍ سٍيدٍيٍ شِلِمَ كِيتِ ندٍ مَ، كْنْ عَ فُندِ سٍيدٍيَشِ قٍ نَشَن مَ عَ مُ نَ قَلَ حَمَ بّ، نَ يُنُبِ لُمَ عَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","شَ مِشِ دِن سٍ سّنِيّنتَرٍ رَ عَ مُ عَ كٌلٌن، عَلْ سُبٍ رَهَرَ مُشِ بِنبِ، شَ نَ مُ عَ رَ شُرُ سٍ سّنِيّنتَرٍ بِنبِ، شَ نَ مُ عَ رَ بُبُسٍ سّنِيّنتَرٍ بِنبِ، نَ مِشِ قَن قِندِ مَ نّ مِشِ سّنِيّنتَرٍ رَ، عَ يُنُبِ سْتْ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","شَ مِشِ ندٍ سَ دِن سٍ سّنِيّنتَرٍ رَ نَشَن كٍلِشِ عَدَ مَدِ قَتٍ مَ، عَ قَ لِ عَ مُ عَ كٌلٌن نَ تّمُي، شَ عَ سَ عَ كٌلٌن تّمُي نَشّ، عَ قِندِ مَ سّنِيّنتَرٍ رَ، عَ يُنُبِ سْتْمَ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","شَ مِشِ ندٍ سَ عَ كَلِ قُقَقُ، قٍ قَنيِ شَ نَ مُ عَ رَ قٍ حَاشِ رَ، عَ قَ نّيمُ نَ مَ، عَ نَ رَتُ نَ قٍ مَ تّمُي نَشّ، عَ قِندِ مَ سّنِيّنتَرٍ رَ، عَ يُنُبِ سْتْ نَ كُي.» ");
INSERT INTO susa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«نَشَن نَ يُنُبِ مْولِ رَبَمَ، عَ لَنمَ عَ شَ عَ تِ نَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","عَ شَ يّشّي فِنّ، شَ نَ مُ عَ رَ سِ فِنّ بَ يّتّ رَفبِلٍن سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ. نَ كُي سّرّشّدُبّ يُنُبِ شَقَرِ سّرّشّ بَمَ عَ بّ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«شَ قّيرّ مُ نَ عَ يِ رَ نَ سّرّشّ شَ قٍ رَ، عَ شَ كٌلٌكٌندٍ قِرِن شَ نَ مُ عَ رَ فَنبّ قِرِن بَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ. كٍرٍن شَ قِندِ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ شَ قِندِ سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","عَ شَ عٍ شَنِن سّرّشّدُبّ شْن، سّرّشّدُبّ شَ يُنُبِ شَقَرِ سّرّشّ نَن سِنفٍ بَ. عَ شَ عَ كْنيِ فِرَ، كْنْ عَ نَشَ عَ شُنيِ بَ عَ دّ عِ. ");
INSERT INTO susa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","عَ عَ وُلِ ندٍ كَسَنمَ سّرّشّبَدٍ سّيتِ مَ، وُلِ نَشَن لُشِ، عَ نَ عِقِلِمَ سّرّشّبَدٍ لَنبَنيِ. يُنُبِ شَقَرِ سّرّشّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","سّرّشّدُبّ شَ نَ شْنِ قِرِن ندٍ بَ سّرّشّ فَن دَاشِ رَ عَ رَبَ كِ مَ. نَ كُي، سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ عَ بّ عَ شَ يُنُبِ رَبَشِ شَ قٍ رَ، عَلَكٌ عَ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«شَ قّيرّ مُ نَ عَ يِ رَ كٌلٌكٌندٍ قِرِن، شَ نَ مُ عَ رَ فَنبّ قِرِن سْتْقٍ رَ، عَ شَ سَنسِ شْرِ دِنشِ كٌنبٌ يَ كٍرٍن نُن عَ تَفِ بَ يُنُبِ شَقَرِ سّرّشّ رَ. عَ نَشَ تُرٍ، شَ نَ مُ عَ رَ سُرَيِ سَ نَ قَرِ دٍ، بَرِ مَ يُنُبِ شَقَرِ سّرّشّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","عَ شَ نَ شَنِن سّرّشّدُبّ شْن مَ، سّرّشّدُبّ سُشُ كٍرٍن فَنمَ سّرّشّبَدٍ قَرِ تْنشُمَ رَ. عَ نَ رَبَمَ سّرّشّيٍ قَرِ نَشٍيٍ فَنمَ سّرّشّبَدٍ قَرِ، بَرِ مَ يُنُبِ شَقَرِ سّرّشّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ عَ بّ، عَلَكٌ عَ شَ يُنُبِ رَبَشِ شَ شَقَرِ. سَنسِ شْرِ دِنشِ نَشَن لُشِ عَ قِندِ مَ سّرّشّدُبّ نَن فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«شَ مِشِ ندٍ سَ سٍ ندٍ تٌنفٌ نَشَن قِندِشِ ﭑ تَن عَلَتَلَ فبٍ رَ، كْنْ عَ مُ عَ كٌلٌن عَ نَ يُنُبِ مْولِ رَبَشِ، عَ شَ يّشّي كٌنتٌنيِ بَ يّتّ رَفبِلٍن سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ عَ شَ يُنُبِ شَ قٍ رَ. عَ مُ لَنمَ لَنيُرُ يٌ شَ لُ نَ يّشّي مَ، عَ سَرٍ قَن شَ لَن سَرٍ مَ نَشَن نَوَلِمَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","عَ شَ نَ سٍ تٌنفٌشِ رَفبِلٍن سّرّشّدُبّ مَ، عَ مَن شَ كْبِرِ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ سٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ سٌ سّرّشّدُبّ يِ رَ. نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ عَ بّ سِكْتّ رَ نَشَن قِندِ يّتّ رَفبِلٍن سّرّشّ رَ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ. ");
INSERT INTO susa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","مِشِ نَشَن يُنُبِ رَبَمَ، عَ ﭑ تَن عَلَتَلَ شَ يَامَرِ ندٍ مَتَندِ، هَلِ عَ مُ عَ كٌلٌن، نَ بَرَ يُنُبِ سْتْ، قٌ عَ شَ نَ سَرٍ قِ. ");
INSERT INTO susa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","عَ لَنمَ عَ شَ سِكْتّ بَ يّتّ رَفبِلٍن سّرّشّ رَ، لَنيُرُ مُ نَ نَشَن مَ، نَشَن سَرٍ لَنمَ سّرِيّ مَ. نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ عَ بّ عَ شَ يُنُبِ شَ قٍ رَ، عَ نَشَن نَبَشِ عَ مُ عَ كٌلٌن، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ. ");
INSERT INTO susa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","نَ بَرَ قِندِ يّتّ رَفبِلٍن سّرّشّ رَ، بَرِ مَ عَ يُنُبِ سْتْ نّ ﭑ تَن عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«شَ مِشِ ندٍ سَ يُنُبِ سْتْ، عَ قٍ حَاشِ رَبَ ﭑ تَن عَلَتَلَ رَ، عَلْ عَ نفَشَكٍرٍنيِ مَدَشُقٍ سٍ ندٍ شَ قٍ رَ، نَشَن نُ بَرَ تَشُ عَ رَ، شَ نَ مُ عَ رَ عَ نَشَن مُحَ، شَ نَ مُ عَ رَ عَ نَشَن بَشِ عَ بٌورٍ يِ رَ قُنمَلَيَ رَ، ");
INSERT INTO susa_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","شَ نَ مُ عَ رَ سٍ لْيشِ عَ نَشَن تٌشِ، عَ قَ وُلٍ قَلَ نَ شَ قٍ رَ كَلِ رَ، ");
INSERT INTO susa_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","نَ يُنُبِ رَبَ مْولِ لَنمَ عَ شَ نَ سٍ مُحَشِ رَفبِلٍن. شَ عَ مُحَشِ نّ بَ، شَ عَ تَشُشِ نّ عَ رَ بَ، شَ سٍ لْيشِ نَ عَ رَ عَ نَشَن تٌشِ بَ، ");
INSERT INTO susa_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","شَ سٍ نَ عَ رَ وُلٍ قَلَ نَشَن مَ قٍ رَ كَلِ رَ، عَ شَ نَ رَفبِلٍن عَ كَنيِ مَ كٍرٍن نَ، عَ مَن شَ كْبِرِ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ سٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ سٌ نَ كَنيِ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","عَ مَن شَ يّشّي كٌنتٌنيِ شَنِن سّرّشّدُبّ يِرٍ يّتّ رَفبِلٍن سّرّشّ رَ عَلَتَلَ بّ. قِ يٌ نَشَ لُ نَ يّشّي مَ، عَ سَرٍ قَن شَ لَن سّرِيّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","نَ كُي سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ عَ بّ ﭑ تَن عَلَتَلَ يَ عِ، عَلَكٌ عَ شَ يُنُبِ، عَ نَشَن نَبَشِ، نَ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«يِ يَامَرِ سٌ هَرُنَ نُن عَ شَ دِيٍ يِ رَ؛ سّرِيّ نَن يَ سّرّشّ فَن دَاشِ شَ قٍ رَ. سّرّشّ فَن دَاشِ شَ لُ سّرّشّبَدٍ قَرِ كْي رَ، عَ شَ فَن هَن فّيسّفّ. ");
INSERT INTO susa_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","سّرّشّدُبّ شَ دٌنمَ رَفٌرٌ عَ مَ، عَ شَ وَنتَنيِ قِيشّ قَنيِ سٌ عَ رَ، عَ شَ تّ شُبٍ بَ سّرّشّ فَن دَاشِ بُن مَ، عَ عَ سَ سّرّشّبَدٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","عَ نَ فّ نَ وَلِ رَ، عَ شَ عَ شَ دُفِ قَنيِ بَ عَ مَ، عَ شَ دُفِ فبّتّ رَفٌرٌ عَ مَ، عَلَكٌ عَ شَ نَ تّ شُبٍ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، يِرٍ سّنِيّنشِ. ");
INSERT INTO susa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","تّ نَشَن دّشّشِ سّرّشّبَدٍ بُن مَ، نَ نَشَ شُبٍن. فّيسّفّ بِرِن سّرّشّدُبّ شَ يٍفٍ رَدْشْ، عَ شَ تّ شُرُ، عَ سّرّشّ فَن دَاشِ سَ نَ قَرِ. عَ شَنُنتٍيَ سّرّشّيٍ تُرٍ قَن فَنمَ نَا نّ. ");
INSERT INTO susa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","نَ تّ دّشّمَ تّمُي بِرِن سّرّشّبَدٍ بُن مَ، عَ مُ شُبٍنمَ.» ");
INSERT INTO susa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«سّرِيّ نَن يَ سَنسِ شْرِ دِنشِ سّرّشّ شَ قٍ رَ. هَرُنَ شَ دِيٍ شَ قَ نَ سّرّشّ رَ سّرّشّبَدٍ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","سّرّشّدُبّ شَ سُشُ كٍرٍن كْ سَنسِ شْرِ دِنشِ رَ، عَ نُن تُرٍ، عَ نُن سُرَيِ نَشَن بِرِن سَمَ عَ قَرِ، عَ شَ نَ بِرِن فَن سّرّشّ تْنشُمَ رَ سّرّشّبَدٍ قَرِ. نَ شِرِ رَقَن ﭑ تَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","نَشَن لُشِ، هَرُنَ نُن عَ شَ دِيٍ شَ نَ دٌن عَ لّبِنِتَرٍ رَ، هْرْ مْلِنفِرَ تّتّ سّنِيّنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","عَ مُ لَنمَ عَ شَ حِن لّبِنِ رَ، بَرِ مَ عَ قَتَنشِ ﭑ مَ سّرّشّ فَن دَاشِيٍ نَن نَ نَشٍيٍ سّنِيّنشِ هَن عَلْ يُنُبِ شَقَرِ سّرّشّ نُن يّتّ رَفبِلٍن سّرّشّ. ");
INSERT INTO susa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","هَرُنَ شَ دِ شّمّيٍ نْمَ نَ دٌندٍ. يَامَرِ نَ عَ رَ وٌ بْنسْي بّ نَشَن مُ كَنَمَ عَبَدَن. مِشِ نَشَن بِرِن عَ مَكْرّ مَ نَ سّرّشّ فَن دَاشِيٍ رَ نَشٍيٍ بَمَ ﭑ تَن عَلَتَلَ بّ، نَ كَنيِيٍ سّنِيّنمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«هَرُنَ تِمَ سّرّشّدُبّ كُنتِفِ رَ لْشْي نَشّ، عَ لَنمَ عَ تَن هَرُنَ نُن عَ شَ دِيٍ شَ سَنسِ شْرِ قَنيِ دِنشِ كٌنبٌ يَ كٍرٍن بَ سّرّشّ رَ. نَ سّرّشّ تَفِ بَمَ فّيسّفّ، بٌورٍ تَفِ بَمَ نُنمَرٍ. نَ مْولِ شَ رَبَ مِشِ تِمَ سّرّشّدُبّ كُنتِفِ رَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","يِ سَنسِ شْرِ دِنشِ شَ فِلِن تُندٍ كُي، تُرٍ شَ سَ عَ مَ. عَ نَ حْن، عَ شُنتُنيِيٍ شَ فَن تّ شْورَ، عَ شَ قِندِ شِرِ حْشُنمّ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","سّرّشّدُبّ نَشَن قِندِ مَ هَرُنَ حْشْي رَ شَ نَ سّرّشّ مْولِ بَ. عَ شَ رَبَ نَ كِ نّ تّمُي بِرِن ﭑ تَن عَلَتَلَ يَ عِ. نَ سّرّشّ بِرِن شَ فَن. ");
INSERT INTO susa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","سّرّشّدُبّ شَ سّرّشّ بِرِن شَ فَن، عٍ نَشَ نَ سٍسٍ دٌن.» ");
INSERT INTO susa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«يِ يَامَرِ سٌ هَرُنَ نُن عَ شَ دِيٍ يِ رَ؛ ‹سّرِيّ نَن يَ يُنُبِ شَقَرِ سّرّشّ شَ قٍ رَ. يُنُبِ شَقَرِ سّرّشّ كْن نَشَبَمَ سّرّشّ فَن دَاشِ كْن نَشَبَدٍ نّ، بَرِ مَ سٍ سّنِيّنشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","سّرّشّدُبّ نَشَن يُنُبِ شَقَرِ سّرّشّ بَمَ، عَ نَ دٌنمَ ﭑ تَن عَلَ شَ هْرْ مْلِنفِرَ تّتّ سّنِيّنشِ نَن كُي. ");
INSERT INTO susa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","نَشَن يٌ دِنمَ نَ سّرّشّ رَ، نَ كَنيِ سّنِيّنمَ نّ. شَ نَ وُلِ سَ كَسَن دُفِ ندٍ مَ، نَ دُفِ شَ شَ يِرٍ سّنِيّنشِ. ");
INSERT INTO susa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","شَ نَ سُبٍ حِنمَ تُندٍ مْولِ ندٍ كُي نَشَن مَنِيَ قّحّ رَ، عَ نَ فّ عَ حِندٍ، نَ تُندٍ شَ كَنَ. شَ عَ حِنمَ تُندٍ كُي نَشَن يَءِلَنشِ يْشُي رَ، نَ تُندٍ شَ مَشَ عَ قَنيِ رَ يٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","شّمّ سّرّشّدُبّ بِرِن شَ نَ دٌن، بَرِ مَ سّرّشّ سّنِيّنشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","كْنْ مِشِ يٌ نَشَ يُنُبِ شَقَرِ سّرّشّ دٌن، نَشَن وُلِ شَنِنمَ هْرْ مْلِنفِرَ كُي شُنسَرٍ رَ. نَ سّرّشّ مْولِ شَ فَن تّ رَ.›» ");
INSERT INTO susa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«يّتّ رَفبِلٍن سّرّشّ سّرِيّ نَن يَ؛ سّرّشّ سّنِيّنشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","يّتّ رَفبِلٍن سّرّشّ كْن نَشَبَمَ سّرّشّ فَن دَاشِ كْن نَشَبَدٍ نّ. عَ وُلِ شَ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","عَ تُرٍ بِرِن، عَ شُلِ، عَ تُرٍ نَشَن نَ عَ قُرِنفّ سّيتِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","عَ فُنفُي قِرِنيِ، عٍ تُرٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ، نَ بِرِن شَ بَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","سّرّشّدُبّ شَ نَ بِرِن فَن سّرّشّبَدٍ قَرِ سّرّشّ فَن دَاشِ رَ عَلَتَلَ بّ. يّتّ رَفبِلٍن سّرّشّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","شّمّ سّرّشّدُبّيٍ نَن نَ دٌنمَ يِرٍ سّنِيّنشِ كُي، بَرِ مَ سّرّشّ سّنِيّنشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","يُنُبِ شَقَرِ سّرّشّ نُن يّتّ رَفبِلٍن سّرّشّ، عٍ سّرِيّ بِرِن كٍرٍن. سّرّشّدُبّ نَشَن نَ شُنسَرٍ سّرّشّ بَشِ، عَ تَن نَن نَ سُبٍ دٌنمَ. ");
INSERT INTO susa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","سّرّشّ فَن دَاشِ كِرِ قَن لُمَ سّرّشّدُبّ يِ رَ نَشَن نَ بَشِ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","«سَنسِ شْرِ دِنشِ سّرّشّ نَشَن فَنشِ نُن نَشَن فِلِنشِ، عٍ قَن قِندِ مَ سّرّشّدُبّ نَن فبٍ رَ، نَشَن عٍ بَشِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","سَنسِ شْرِ دِنشِ سّرّشّ نَشَن مُ فَنشِ، تُرٍ فبَنسَن نَن سَشِ عَ مَ، شَ نَ مُ عَ رَ تُرٍ مُ سَشِ عَ مَ، نٍيٍ قِندِ مَ هَرُنَ شَ دِ بِرِن نَن فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«شَنُنتٍيَ سّرّشّيٍ سّرِيّ نَن يَ، نَشَن بَمَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","شَ مِشِ ندٍ وَ مَ تَنتُي سّرّشّ بَقٍ، عَ مَن شَ تَامِ لّبِنِتَرٍيٍ يَءِلَن تُرٍ رَ، عَ نُن تَامِ شُنشُرِيٍ تُرٍ سَشِ نَشٍيٍ مَ، نُن تَامِ شُنشُرِ نَشٍيٍ رَ مُلَنشِ تُرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","عَ نَ شَنُنتٍيَ سّرّشّ بَمَ تّمُي نَشّ، نَشَن قِندِشِ تَنتُي سّرّشّ رَ، عَ شَ تَامِ قَن حِن لّبِنِ نَ نَشَن شُن. ");
INSERT INTO susa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ندٍ شَ بَ نَ تَامِ مْولِ بِرِن نَ، عَ قِندِ سّرّشّدُبّ فبٍ رَ، نَشَن شَنُنتٍيَ سّرّشّ وُلِ كَسَنمَ سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","نَ شَنُنتٍيَ سّرّشّ سُبٍ دٌنمَ عَ بَ لْشْي نّ، سٍسٍ نَشَ لُ هَن فّيسّفّ.» ");
INSERT INTO susa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«شَ لَايِدِ سّرّشّ بَمَ، شَ نَ مُ عَ رَ سّرّشّ حَنِفٍشِ، نَ سُبٍ شَ دٌن عَ بَ لْشْي نّ، كْنْ شَ ندٍ سَ لُ عَ نْمَ دٌندٍ فّيسّفّ قَن. ");
INSERT INTO susa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","شَ عَ دْنشْي سَ لُ هَن نَ قَن كُيٍ عِبَ، نَ سُبٍ شَ فَن فبِكِ نَ شِ سَشَن ندٍ لْشْي مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","شَ مِشِ ندٍ سَ عَ يّتّ شَ شَنُنتٍيَ سّرّشّ سُبٍ دٌن نَ شِ سَشَن ندٍ لْشْي مَ، عَلَ مُ عَ شَ سّرّشّ تٌنفٌمَ. عَ لُمَ عَلْ عَ مُ سّرّشّ يٌ بَشِ، بَرِ مَ نَ سُبٍ قِندِشِ سٍ سّنِيّنتَرٍ نَن نَ. مِشِ نَشَن نَ رَبَمَ، عَ يُنُبِ سْتْمَ نَ كُي.» ");
INSERT INTO susa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«سّرّشّ سُبٍ نَشَن دِنمَ سٍ سّنِيّنتَرٍ رَ، عَ مُ لَنمَ نَ سُبٍ شَ دٌن. قٌ عَ شَ فَن نّ فبِكِ. مِشِ سّنِيّنشِ نَن نْمَ نَ شَنُنتٍيَ سّرّشّ سُبٍ دٌندٍ، ");
INSERT INTO susa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","كْنْ سّنِيّنتَرٍ مُ نْمَ ﭑ تَن عَلَتَلَ شَ شَنُنتٍيَ سّرّشّ دٌندٍ، عَ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","مِشِ نَشَن عَ بّلّشّ دِنمَ سٍ سّنِيّنتَرٍ رَ نَشَن كٍلِشِ عَدَ مَدِ مَ، شَ نَ مُ عَ رَ عَ بّلّشّ دِن سُبٍ سّنِيّنتَرٍ رَ، شَ نَ مُ عَ رَ سٍ فبّتّ نَشَن مُ سّنِيّنشِ، شَ نَ كَنيِ قَ ﭑ تَن عَلَتَلَ شَ شَنُنتٍيَ سّرّشّ دٌن، عَ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ نَشَ نِنفٍ، يّشّي، نُن سِ تُرٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","وٌ نْمَ شُرُ سٍ تُرٍ رَوَلِدٍ عَلْ وٌ وَ مَ عَ شْن مَ كِ نَشّ شَ عَ قَشَ عَ يّتّ مَ، شَ نَ مُ عَ رَ سُبٍ شَاحّ ندٍ نَشَ عَ قَشَ، كْنْ وٌ مُ نْمَ عَ دٌندٍ. ");
INSERT INTO susa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","نَشَن يٌ تُرٍ دٌنمَ، نَشَن نْمَ رَوَلِدٍ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ، نَ كَنيِ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","وٌ مَن مُ لَنمَ وٌ شَ شْنِ وُلِ، شَ نَ مُ عَ رَ شُرُ سٍ وُلِ يٌ مِن يِرٍ بِرِن وٌ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","نَشَن يٌ وُلِ مِنمَ، نَ كَنيِ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ.›» ");
INSERT INTO susa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹نَشَن شَنُنتٍيَ سّرّشّ بَمَ ﭑ تَن عَلَتَلَ بّ، عَ شَ ﭑ تَن عَلَتَلَ فبٍ قِ ﭑ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","عَ شَ نَ شُرُ سٍ تُرٍ نُن عَ سِسِ شَنِن ﭑ تَن عَلَتَلَ يِرٍ عَلَكٌ عَ شَ فَن تّ رَ ﭑ تَن عَلَتَلَ بّ. عَ لَنمَ عَ شَ نَ شُرُ سٍ سِسِ لِنتَن ﭑ تَن عَلَتَلَ يَ عِ عَ مَسٍنقٍ رَ ﭑ بّ، نَ قِندِشِ ﭑ تَن نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","سّرّشّدُبّ شَ نَ تُرٍ فَن سّرّشّبَدٍ قَرِ. نَ شُرُ سٍ كَنكٍ لُمَ هَرُنَ نُن عَ شَ دِيٍ نَن بّ. ");
INSERT INTO susa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","وٌ شَ شَنُنتٍيَ سّرّشّيٍ كُي، وٌ مَن شَ شُرُ سٍ يِرٍقَنيِ تَبٍ قِ سّرّشّدُبّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","شُرُ سٍ يِرٍقَنيِ تَبٍ شَ قِندِ سّرّشّدُبّ نَن فبٍ رَ نَشَن بَرَ وُلِ نُن تُرٍ بَ شَنُنتٍيَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ﭑ بَرَ نَتّ تٌنفٌ نَشَن مُ كَنَمَ عَبَدَن، عِسِرَيِلَكَيٍ شَ شَنُنتٍيَ سّرّشّيٍ كُي، عٍ شُرُ سٍ كَنكٍ نَشَن لِنتَنشِ ﭑ تَن عَلَ يَ عِ، عَ نُن شُرُ سٍ يِرٍقَنيِ تَبٍ عٍ نَشَن بَشِ، نَ بِرِن شَ قِندِ سّرّشّدُبّ هَرُنَ نُن عَ شَ دِيٍ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","كَبِ هَرُنَ نُن عَ شَ دِيٍ قِندِ ﭑ تَن عَلَ شَ سّرّشّدُبّيٍ رَ، عٍ نَ نَن سْتْمَ ﭑ تَن عَلَتَلَ شَ سّرّشّ فَن دَاشِيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","عٍ تٌ قِندِ سّرّشّدُبّيٍ رَ، ﭑ تَن عَلَتَلَ نَشَ نَ يَامَرِ قِ عِسِرَيِلَكَيٍ مَ. يَامَرِ نَ عَ رَ نَشَن مُ كَنَمَ عَبَدَن.›» ");
INSERT INTO susa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","سّرِيّ نَن نَ كِ سّرّشّيٍ شَ قٍ رَ، سّرّشّ فَن دَاشِ، سَنسِ شْرِ دِنشِ سّرّشّ، يُنُبِ شَقَرِ سّرّشّ، يّتّ رَفبِلٍن سّرّشّ، سّرّشّدُبّ تِ سّرّشّ، نُن شَنُنتٍيَ سّرّشّ. ");
INSERT INTO susa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","عَلَتَلَ نُ بَرَ نَ بِرِن مَسٍن عَننَبِ مُنسَ بّ تُرُ سِنِنَ فٍيَ قَرِ عَ تٌ عِسِرَيِلَكَيٍ يَمَرِ عٍ شَ قَ سّرّشّيٍ رَ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«هَرُنَ نُن عَ شَ دِيٍ شِلِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عِ شَ قَ عٍ شَ دُفِ سّنِيّنشِيٍ رَ، عَ نُن تُرٍ سّنِيّنشِ، تُورَ نَشَن بَمَ يُنُبِ شَقَرِ سّرّشّ رَ، يّشّي كٌنتٌنيِ قِرِن، نُن دٍبٍ، تَامِ لّبِنِتَرٍيٍ نَ نَشَن كُي. ");
INSERT INTO susa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","عِ شَ عِسِرَيِلَ حَمَ بِرِن مَلَن هْرْ مْلِنفِرَ سٌدٍ دّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","عَننَبِ مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ رَكَمَلِ، حَمَ قَن نَشَ عٍ مَلَن هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","عَننَبِ مُنسَ نَشَ عَ قَلَ حَمَ بّ، «عَلَتَلَ بَرَ ﭑ يَمَرِ ﭑ شَ يِ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","عَننَبِ مُنسَ نَشَ هَرُنَ نُن عَ شَ دِيٍ مَسٌ، عَ نَشَ عٍ مَشَ يٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","عَ نَشَ دُفِ سّنِيّنشِيٍ رَفٌرٌ هَرُنَ مَ، عَ نَشَ عَ تَفِ شِرِ بّلّتِ رَ، عَ فُبَ رَفٌرٌ عَ مَ، عَ سّرّشّدُبّ دٌنمَ رَفٌرٌ نَ قَرِ، عَ عَ تَفِ شِرِ بّلّتِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","عَ نَشَ كَنكٍ مَكٌتٌسٍ رَفٌرٌ عَ كْن مَ، عَ فّمّ قِرِن سَ نَ كُي نَشٍيٍ قِندِشِ عَلَ وَشْنقٍ مَسٍنسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","عَ نَشَ شُنمَسٍ دْشْ هَرُنَ شُنيِ مَ، عَ تْنشُمَ سّنِيّنشِ شّيمَ دَاشِ سَ نَ مَ، عَلْ عَلَتَلَ مُنسَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","عَننَبِ مُنسَ نَشَ تُرٍ سّنِيّنشِ تٌنفٌ، عَ ندٍ مَسٌ عَلَ شَ هْرْ مْلِنفِرَ مَ، نُن سٍ نَشَن بِرِن نَ عَ كُي. عَ نٍيٍ رَ سّنِيّن نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","عَ نَشَ تُرٍ كَسَن سّرّشّبَدٍ مَ سَنيَ سٌلٌقٍرٍ، عَ نُن سّرّشّبَدٍ يِرَبَسٍيٍ، يٍ رَفَتَدٍ شُنفبٍ، نُن نَ سَشِ سٍ نَشَن قَرِ، عَلَكٌ عٍ شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","عَ مَن نَشَ تُرٍ ندٍ سَ هَرُنَ شُنيِ مَ، عَلَكٌ هَرُنَ قَن شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","عَننَبِ مُنسَ نَشَ هَرُنَ شَ دِيٍ مَسٌ، عَ دُفِ سّنِيّنشِيٍ رَفٌرٌ عٍ قَن مَ. عَ نَشَ عٍ تَفِ نُن عٍ شُنيِ شِرِ دُفِ رَ، عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","عَننَبِ مُنسَ تٌ قَ تُورَ يُنُبِ شَقَرِ سّرّشّ رَ، هَرُنَ نُن عَ شَ دِيٍ نَشَ عٍ بّلّشّيٍ سَ نَ تُورَ شُن تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","عَننَبِ مُنسَ نَشَ عَ كْن نَشَبَ، عَ نَشَ عَ وُلِ ندٍ تٌنفٌ، عَ عَ مَسٌ سّرّشّبَدٍ قٍرِيٍ مَ نَشٍيٍ نُ نَ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ. عَ نَشَ نَ رَبَ عَ بّلّشّسٌلٍ رَ، عَلَكٌ عَ شَ سّرّشّبَدٍ رَ سّنِيّن. عَ نَشَ وُلِ دْنشْي عِقِلِ سّرّشّبَدٍ سّيتِيٍ مَ. عَ سّرّشّبَدٍ رَ سّنِيّن نَ كِ نّ بَرِ مَ عَ قِندِ شُنسَرَدٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","عَننَبِ مُنسَ مَن نَشَ تُرٍ تٌنفٌ نَشَن نُ نَ نِنفٍ قُرِنفّ رَبِلِنيِ، عَ نُن لَارٍ نَشَن نُ نَ عَ بْحّ قَرِ، نُن عَ فُنفُي شْرِ قِرِنيِيٍ نُن عٍ تُرٍ. عَ نَشَ نٍيٍ بِرِن سَ تّ عِ سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","كْنْ عَ نَشَ تُورَ فُندِ، عَ كِرِ، عَ سُبٍ، نُن عَ حَحّ فَن تّ رَ حَمَ يٌنكِندٍ قَرِ مَ، عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","عَننَبِ مُنسَ نَشَ قَ يّشّي كٌنتٌنيِ رَ نَشَن قِندِ سّرّشّ فَن دَاشِ رَ. هَرُنَ نُن عَ شَ دِيٍ نَشَ عٍ بّلّشّيٍ سَ نَ يّشّي شُن تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","عَننَبِ مُنسَ نَشَ عَ كْن نَشَبَ، عَ عَ وُلِ ندٍ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","عَ نَشَ يّشّي عِشَبَ عَ شُنتُنيِيٍ رَ. عَ نَشَ عَ شُنيِ، عَ شُنتُنيِيٍ، نُن عَ تُرٍ فَن تّ عِ. ");
INSERT INTO susa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","عَ نَشَ يّشّي قُرِنفّ نُن عَ سَنيِيٍ رَشَ، عَ يّشّي كٌنتٌنيِ فُندِ بِرِن فَن تّ رَ سّرّشّبَدٍ قَرِ سّرّشّ فَن دَاشِ رَ، نَشَن شِرِ رَقَن عَلَتَلَ مَ. عَ نَ بِرِن نَبَ نّ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","عَننَبِ مُنسَ نَشَ يّشّي كٌنتٌنيِ قِرِن ندٍ تٌنفٌ نَشَن قِندِ سّرّشّدُبّ دْشْ سّرّشّ رَ. هَرُنَ نُن عَ شَ دِيٍ نَشَ عٍ بّلّشّيٍ سَ نَ يّشّي شُن تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","عَننَبِ مُنسَ نَشَ عَ كْن نَشَبَ، عَ عَ وُلِ ندٍ تٌنفٌ، عَ عَ سَ هَرُنَ يِرٍقَنيِ تُلِ مَ، عَ يِرٍقَنيِ بّلّشّكُرَ مَ، نُن عَ سَنكُرَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","عَ نَشَ هَرُنَ شَ دِيٍ قَن مَسٌ، عَ نَشَ وُلِ ندٍ سَ عٍ يِرٍقَنيِ تُلِيٍ مَ، عٍ يِرٍقَنيِ بّلّشّكُرَ مَ، نُن عٍ يِرٍقَنيِ سَنكُرَ مَ. عَ نَشَ عَ وُلِ ندٍ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","عَ نَشَ نَ يّشّي تُرٍ تٌنفٌ، عَ نُن عَ شُلِ، عَ قُرِنفّ تُرٍ، لَارٍ نَشَن نَ عَ بْحّ قَرِ، عَ فُنفُي شْرِ قِرِنيِيٍ نُن عٍ تُرٍ، نُن عَ يِرٍقَنيِ تَبٍ. ");
INSERT INTO susa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","عَننَبِ مُنسَ نَشَ دٍبٍ تٌنفٌ تَامِ لّبِنِتَرٍيٍ نَ نَشَن كُي، نَشَن نُ دْشْشِ عَلَتَلَ يَ عِ. عَ نَشَ تَامِ لّبِنِتَرٍ كٍرٍن بَ نَ، عَ نُن تَامِ كٍرٍن نَشَن يَءِلَنشِ تُرٍ رَ، عَ نُن تَامِ لَنمَدِ كٍرٍن. عَ نَشَ عٍ سَ نَ يّشّي تُرٍ نُن عَ يِرٍقَنيِ تَبٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","عَ نَشَ نَ بِرِن سٌ هَرُنَ نُن عَ شَ دِيٍ يِ رَ، عٍ قَ نَ لِنتَن عَلَتَلَ يَ عِ عَلَكٌ عَ شَ عَ كٌلٌن عَ فبٍ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","نَ دَنفِ شَنبِ، عَننَبِ مُنسَ نَشَ عٍ رَ سُشُ عٍ يِ رَ، عَ نَشَ عٍ سَ تّ سّرّشّبَدٍ قَرِ، سّرّشّ فَن دَاشِ نُ نَ دّننَشّ. سّرّشّدُبّ دْشْ سّرّشّ نَ عَ رَ، نَشَن فَن شِرِ رَقَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","عَننَبِ مُنسَ نَشَ يّشّي كٌنتٌنيِ كَنكٍ تٌنفٌ نَ سّرّشّدُبّ دْشْ سّرّشّ رَ، عَ قَ نَ لِنتَن عَلَتَلَ يَ عِ عَ مَسٍنقٍ رَ عَ بّ. نَ نَشَ قِندِ عَننَبِ مُنسَ فبٍ رَ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","عَننَبِ مُنسَ نَشَ تُرٍ سّنِيّنشِ ندٍ تٌنفٌ، عَ نُن وُلِ ندٍ نَشَن نُ نَ سّرّشّبَدٍ قَرِ، عَ نَشَ عَ كَسَن هَرُنَ نُن عَ شَ دُفِيٍ مَ، عَ عَ كَسَن هَرُنَ شَ دِيٍ نُن عٍ شَ دُفِيٍ قَن مَ، عَلَكٌ عٍ تَن نُن عٍ شَ دُفِيٍ بِرِن شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","مُنسَ نَشَ عَ قَلَ هَرُنَ نُن عَ شَ دِيٍ بّ، «وٌ سُبٍ حِن هْرْ مْلِنفِرَ سٌدٍ دّ رَ، وٌ شَ عَ دٌن مّننِ، عَ نُن تَامِ نَشَن نَ دٍبٍ كُي نَشَن قِندِ سّرّشّدُبّ دْشْ سّرّشّ رَ. ﭑ بَرَ يَامَرِ قِ، هَرُنَ نُن عَ شَ دِيٍ شَ نَ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","تَامِ نُن سُبٍ نَشَن لُشِ، وٌ شَ نَ دْنشْي فَن. ");
INSERT INTO susa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","وٌ نَشَ كٍلِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ شِ سٌلٌقٍرٍ بُن مَ، هَن وٌ شَ دْشْي وَشَتِ كَمَلِمَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","نَشَن نَبَشِ تٌ، عَلَتَلَ عَ يَمَرِشِ وٌ يُنُبِ شُنسَرٍ شَ قٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","نَ نَ عَ تٌشِ، وٌ لُمَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ شِ سٌلٌقٍرٍ بُن مَ، كْي نُن يَنيِ، عَلْ عَلَتَلَ ﭑ يَمَرِشِ عَ رَ كِ نَشّ، عَلَكٌ وٌ نَشَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","هَرُنَ نُن عَ شَ دِيٍ نَشَ عَلَتَلَ شَ يَامَرِ بِرِن نَبَ نَ كِ عَ نَشَن مَسٍنشِ عٍ بّ عَننَبِ مُنسَ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","شِ سٌلٌمَسَشَن لْشْي، عَننَبِ مُنسَ نَشَ هَرُنَ نُن عَ شَ دِيٍ، نُن عِسِرَيِلَ قٌرِيٍ شِلِ. ");
INSERT INTO susa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","عَ نَشَ عَ مَسٍن هَرُنَ بّ، «عِ شَ سّرّشّ قِرِن مَسٍن عَلَتَلَ بّ، تُورَ دِ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ نُن يّشّي كٌنتٌنيِ نَشَن قِندِ مَ سّرّشّ فَن دَاشِ رَ، لَنيُرُ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","عِ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ شَ سِكْتّ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ تُورَ دِ نُن يّشّي دِ نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشٍيٍ مَ، وٌ شَ عٍ بَ سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","وٌ شَ تُورَ نُن يّشّي كٌنتٌنيِ بَ شَنُنتٍيَ سّرّشّ رَ عَلَتَلَ بّ. وٌ شَ تَامِ قَن بَ سّرّشّ رَ، تُرٍ سُنبُشِ نَشَن نَ. وٌ شَ نَ بِرِن بَ بَرِ مَ عَلَتَلَ مِنِمَ نّ وٌ مَ تٌ.›» ");
INSERT INTO susa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","حَمَ نَشَ سّرّشّيٍ شَنِن هْرْ مْلِنفِرَ سٌدٍ دّ رَ عَلْ عَننَبِ مُنسَ عٍ يَمَرِشِ كِ نَشّ. عٍ بِرِن نَشَ عٍ مَكْرّ هْرْ مْلِنفِرَ رَ، عٍ تِ عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","عَننَبِ مُنسَ نَشَ عَ مَسٍن عٍ بّ، «وٌ شَ عَلَتَلَ شَ يَامَرِ رَبَتُ عَلَكٌ عَ شَ عَ نْرّ مَسٍن وٌ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","عَننَبِ مُنسَ نَشَ عَ مَسٍن هَرُنَ بّ، «عِ مَسٌ سّرّشّبَدٍ رَ. عِ شَ يُنُبِ شَقَرِ سّرّشّ نُن سّرّشّ فَن دَاشِ بَ شُنسَرٍ رَ عِ يّتّ بّ، عَ نُن حَمَ بّ. عِ شَ حَمَ شَ سّرّشّ قَن بَ عٍ بّ شُنسَرٍ رَ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","هَرُنَ تٌ عَ مَسٌ سّرّشّبَدٍ رَ، عَ نَشَ تُورَ دِ كْن نَشَبَ عَ يّتّ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","عَ شَ دِيٍ نَشَ تُورَ وُلِ سٌ عَ يِ رَ. عَ نَشَ عَ بّلّشّسٌلٍ رَ سِن وُلِ شْورَ، عَ ندٍ سَ قٍرِيٍ مَ نَشٍيٍ نُ نَ سّرّشّبَدٍ تُنشُنيِ نَانِ رَ. عَ نَشَ وُلِ دْنشْي عِقِلِ سّرّشّبَدٍ لَنبَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","شُرُ سٍ تُرٍ، عَ فُنفُييٍ، نُن لَارٍ نَشَن نَ عَ بْحّ مَ، عَ نَشَ نَ بِرِن فَن سّرّشّبَدٍ قَرِ يُنُبِ شَقَرِ سّرّشّ رَ عَلْ عَلَتَلَ عَننَبِ مُنسَ يَمَرِشِ عَ رَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","كْنْ عَ نَشَ عَ سُبٍ نُن عَ كِرِ فَن حَمَ يٌنكِندٍ قَرِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","نَ دَنفِ شَنبِ، هَرُنَ نَشَ سّرّشّ فَن دَاشِ كْن نَشَبَ. عَ شَ دِيٍ نَشَ نَ وُلِ سٌ عَ يِ رَ، عَ قَ عَ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","عٍ نَشَ سّرّشّ شُنتُنيِيٍ نُن عَ شُنيِ سٌ عَ يِ رَ، عَ نَ بِرِن فَن سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","عَ تٌ فّ عَ قُرِنفّ نُن عَ سَنيِيٍ رَشَدٍ، عَ نَشَ عٍ فَن عٍ نُن سّرّشّ فَن دَاشِ رَ سّرّشّبَدٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","هَرُنَ فّ شَنبِ نَ رَ، عَ نَشَ حَمَ شَ سِكْتّ كْن نَشَبَ، عَ شَ قِندِ يُنُبِ شَقَرِ سّرّشّ رَ حَمَ بّ. عَ نَ رَبَ نّ عَلْ عَ عَ سِنفٍ رَبَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","عَ نَشَ سّرّشّ فَن دَاشِ بَ عَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","عَ نَشَ سَنسِ شْرِ دِنشِ سُشُ كٍرٍن فَن سّرّشّبَدٍ قَرِ سّرّشّ فَن دَاشِ بَ تّمُي فّيسّفّ. ");
INSERT INTO susa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","عَ نَشَ تُورَ نُن يّشّي كٌنتٌنيِ كْن نَشَبَ شَنُنتٍيَ سّرّشّ رَ حَمَ بّ. عَ شَ دِيٍ نَشَ نَ وُلِ سٌ عَ يِ، عَ عَ كَسَن سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","عٍ نَشَ تُورَ نُن يّشّي كٌنتٌنيِ تُرٍ تٌنفٌ، نَشَن نَ عٍ شُلِ نُن عٍ قُرِنفّ مَبِرِ، عَ نُن عٍ فُنفُييٍ، عَ نُن لَارٍ نَشَن نَ عٍ بْحّ مَ، ");
INSERT INTO susa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","عٍ نَشَ نَ بِرِن سَ سُبٍ كَنكٍ مَ سّرّشّبَدٍ قَرِ، عٍ عَ بِرِن فَن. ");
INSERT INTO susa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","هَرُنَ نَشَ سّرّشّ سُبٍيٍ كَنكٍ نُن عٍ يِرٍقَنيِ تَبٍ عِتٍ، عَ عٍ لِنتَن عَلَتَلَ يَ عِ عَ مَسٍنقٍ رَ عَ بّ، عَلْ عَننَبِ مُنسَ عَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","هَرُنَ نَشَ عَ بّلّشّيٍ عِتَلَ، عَ دُبَ حَمَ بّ. عَ تٌ يُنُبِ شَقَرِ سّرّشّ، سّرّشّ فَن دَاشِ، نُن شَنُنتٍيَ سّرّشّ بَ، عَ نَشَ فٌرٌ كٍلِقٍ سّرّشّبَدٍ سّيتِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","عَننَبِ مُنسَ نُن هَرُنَ نَشَ سٌ هْرْ مْلِنفِرَ كُي. عٍ تٌ مِنِ، عٍ نَشَ دُبَ حَمَ بّ. نَ تّمُي عَلَتَلَ شَ نْرّ نَشَ مِنِ حَمَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","عَلَتَلَ نَشَ تّ رَفٌرٌ سّرّشّبَدٍ قَرِ، عَ سّرّشّ فَن دَاشِ نُن تُرٍ فَن. حَمَ تٌ نَ تٌ، عٍ نَشَ عٍ شُي عِتٍ سّيوّ رَ، عٍ عٍ قٍلٍن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","هَرُنَ شَ دِ قِرِنيِيٍ، نَدَبٌ نُن عَبِهُ نَشَ سُرَيِ فَنسٍيٍ تٌنفٌ، عٍ تّ سَ عٍ كُي، عٍ سُرَيِ فَن عَلَتَلَ يَ عِ. كْنْ عٍ مُ نَ تّ تٌنفٌ عَلَ شَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","نَ نَ عَ تٌ، عَلَتَلَ نَشَ تّ رَفٌرٌ عٍ مَ، عٍ قَشَ عَ شَ هْرْ مْلِنفِرَ يِرٍ سّنِيّنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","عَننَبِ مُنسَ نَشَ عَ قَلَ هَرُنَ بّ، «عَلَتَلَ وٌ رَكٌلٌنشِ نّ يِ رَ، عَ تٌ عَ قَلَ، ‹نَشٍيٍ مَكْرّ ﭑ نَ، عٍ شَ عَ كٌلٌن ﭑ سّنِيّن، حَمَ شَ ﭑ بِنيَ.›» هَرُنَ نَشَ دُندُ يٍن. ");
INSERT INTO susa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","عَننَبِ مُنسَ نَشَ مِكَيٍلِ نُن عٍلِسَقَن شِلِ، هَرُنَ بَبَ شُنيَ يُسِيّلِ شَ دِيٍ. عَ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ وٌ نفَشَكٍرٍنيِيٍ قُرٍيٍ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، دّننَشّ مَكُيَ يِرٍ سّنِيّنشِ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","عٍ نَشَ عٍ قُرٍيٍ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، عَلْ عَننَبِ مُنسَ عٍ يَمَرِشِ كِ نَشّ. عٍ نُ بَرَ سّرّشّدُبّ دُفِيٍ لُ عٍ قُرٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","عَننَبِ مُنسَ نَشَ عَ قَلَ هَرُنَ نُن عَ شَ دِيٍ بّ، عٍلٍيَسَرِ نُن عِتَمَرِ، «وٌ نَشَ وٌ شُنسّشّ رَبّحِن، وٌ نَشَ وٌ شَ دُفِيٍ قَن عِبْو. وٌ نَشَ سٍسٍ رَبَ نَشَن نْمَ سُننُنيِ مَسٍندٍ يِ مِشِيٍ شَ قَشّ شَ قٍ رَ، عَلَكٌ عَلَتَلَ نَشَ شْنْ حَمَ مَ، عَ وٌ قَن قَشَ. وٌ نفَشَكٍرٍنيِ عِسِرَيِلَكَيٍ تَن نْمَ سُننُندٍ يِ مِشِيٍ شَ قٍ رَ عَلَتَلَ نَشٍيٍ قَشَشِ تّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","وٌ نَشَ كٍلِ عَلَ شَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ يِ سَشَنيِ، عَلَكٌ وٌ نَشَ قَشَ. عَلَتَلَ شَ مِشِ سُفَندِشِيٍ نَن وٌ تَن نَ.» عٍ نَشَ عَننَبِ مُنسَ شَ يَامَرِ رَبَتُ. ");
INSERT INTO susa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","عَلَتَلَ نَشَ عَ مَسٍن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«وٌ نَ سٌ هْرْ مْلِنفِرَ كُي، وٌ نَشَ وّنِ مِن. وٌ نَشَ مِنسٍ يٌ مِن نَشَن مِشِ سِيسِمَ، شَ نَ مُ عَ رَ وٌ قَشَمَ نّ. نَ سّرِيّ مُ كَنَمَ وٌ بْنسْي بّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","نَ نَن عَ نِيَمَ وٌ نْمَ عَلَ فبٍ نُن عَدَ مَدِ فبٍ تَفِ رَبَدٍ، سّنِيّنيِ نُن سّنِيّنتَرٍحَ. ");
INSERT INTO susa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","نَ قَن عَ نِيَمَ نّ وٌ شَ نْ عِسِرَيِلَكَيٍ شَرَندٍ عَلَتَلَ شَ يَامَرِيٍ رَ، عَ نَشٍيٍ قِشِ عٍ مَ عَننَبِ مُنسَ سَابُي رَ.» ");
INSERT INTO susa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","عَننَبِ مُنسَ نَشَ عَ قَلَ هَرُنَ نُن عَ شَ دِ دْنشْييٍ بّ، عٍلٍيَسَرِ نُن عِتَمَرِ، «سَنسِ شْرِ دِنشِ نَشَن بَشِ سّرّشّ رَ عَلَتَلَ بّ، كْنْ نَشَن بِرِن مُ فَنشِ تّ رَ، وٌ شَ نَ دٌن سّرّشّبَدٍ قّ مَ. وٌ نَشَ لّبِنِ سَ عَ شُن مَ دٍ، بَرِ مَ عَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","وٌ شَ عَ دٌن يِرٍ سّنِيّنشِ، بَرِ مَ عَ فَنشِ عَلَتَلَ بّ سّرّشّ فَن دَاشِيٍ نَن قّ مَ. نَ قِندِشِ عِ فبٍ نُن عِ شَ دِيٍ فبٍ نَن نَ. عَلَتَلَ سّرّشّدُبّيٍ يَمَرِشِ نَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","وٌ مَن شَ سّرّشّ سُبٍ كَنكٍ نُن تَبٍ دٌن يِرٍ سّنِيّنشِ نّ، نَشٍيٍ بَرَ لِنتَن عَلَ يَ عِ، عَ مَسٍنقٍ رَ عَ بّ. نٍيٍ قِندِشِ وٌ فبٍ نَن نَ، عِ تَن، عِ شَ دِ شّمّيٍ، نُن عِ شَ دِ فِنّيٍ. عَلَ بَرَ نَ يَامَرِ قِ عِسِرَيِلَكَيٍ مَ عٍ شَ شَنُنتٍيَ سّرّشّيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","تُرٍ نَشَن فَنمَ يٌ، تَبٍ نَشَن بَمَ يٌ، نُن كَنكٍ نَشَن لِنتَنمَ يٌ، عٍ شَ نَ بِرِن مَسٍن عَلَتَلَ بّ، نَ قَ قِندِ عِ فبٍ نُن عِ شَ دِيٍ فبٍ رَ، عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. سّرِيّ نَ عَ رَ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","عَننَبِ مُنسَ تٌ سِكْتّ شَ قٍ مَشْرِن، نَشَن بَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ نَشَ عَ مّ عَ عٍ نُ بَرَ عَ بِرِن فَن تّ رَ، عَ نَشَ شْنْ عٍلٍيَسَرِ نُن عِتَمَرِ مَ، هَرُنَ شَ دِيٍ نَشٍيٍ مُ قَشَ. عَ نَشَ عَ قَلَ عٍ بّ، ");
INSERT INTO susa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«مُنقٍ رَ وٌ مُ يِ يُنُبِ شَقَرِ سّرّشّ سُبٍ دٌنشِ يِرٍ سّنِيّنشِ؟ سّرّشّ سّنِيّنشِ نَ عَ رَ عَلَتَلَ نَشَن قِشِ وٌ مَ، عَلَكٌ عِسِرَيِلَ حَمَ شَ يُنُبِ شَ شَقَرِ، عَ قِندِ شُنسَرٍ رَ عٍ بّ عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","يِ سّرّشّ وُلِ تٌ مُ سٌشِ يِرٍ سّنِيّنشِ مَ هْرْ مْلِنفِرَ كُي، عَ نُ لَن نّ وٌ شَ عَ سُبٍ دٌن يِرٍ سّنِيّنشِ نّ، عَلْ عَلَ ﭑ يَمَرِشِ عَ رَ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","هَرُنَ نَشَ عَننَبِ مُنسَ يَابِ، «تٌ عٍ بَرَ عٍ شَ يُنُبِ شَقَرِ سّرّشّ نُن عٍ شَ سّرّشّ فَن دَاشِ بَ عَلَتَلَ يَ عِ، كْنْ ﭑ تٌ بَرَ يِ قٍ شْرْشْي مْولِ سْتْ، عَلَتَلَ نْمَ تِندٍ ﭑ شَ يُنُبِ شَقَرِ سّرّشّ سُبٍ دٌن تٌ؟» ");
INSERT INTO susa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","عَننَبِ مُنسَ تٌ نَ يَابِ مّ، عَ نَشَ تِن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«وٌ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، سُبٍ نَشٍيٍ رَدَشَشِ وٌ بّ، نٍيٍ نَن يَ؛ ");
INSERT INTO susa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","سُبٍ تٌرٍ كَنيِيٍ نَشٍيٍ تٌرٍ عِتَشُنشِ قِرِنيِ رَ، عٍ مَن عٍ شَ دٌنسٍ رَتٍمَ عٍ دّ عِ عٍ نُ عَ عِدٌن. وٌ نْمَ نَ سُبٍ مْولِ دٌندٍ.» ");
INSERT INTO susa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","«كْنْ ندٍيٍ نَ نَشٍيٍ دٌنسٍ رَتٍمَ عٍ دّ عِ عٍ نُ عَ عِدٌن، عٍ تٌرٍ تَن مُ عِتَشُنشِ قِرِنيِ رَ. نٍيٍ رَهَرَ مُشِ وٌ مَ. حْشْمّ رَهَرَ مُشِ وٌ مَ، بَرِ مَ عَ دٌنسٍ رَتٍمَ عَ دّ عِ عَ نُ عَ عِدٌن، كْنْ عَ تٌرٍ مُ عِتَشُنشِ قِرِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","يٍرٍ مَنِيّ ندٍ قَن دٌنسٍ رَتٍمَ عَ دّ عِ عَ نُ عَ عِدٌن، كْنْ عَ تٌرٍ مُ عِتَشُنشِ قِرِنيِ رَ. عَ رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","يٍرٍ قَن دٌنسٍ رَتٍمَ عَ دّ عِ عَ نُ عَ عِدٌن، كْنْ عَ تٌرٍ مُ عِتَشُنشِ قِرِنيِ رَ. عَ رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","شْسّ تَن، عَ تٌرٍ عِتَشُنشِ قِرِنيِ رَ، كْنْ عَ مُ دٌنسٍ رَتٍمَ عَ دّ عِ عَ نُ عَ عِدٌن. عَ رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","وٌ نَشَ نَ سُبٍيٍ دٌن، وٌ نَشَ دِن عٍ بِنبِيٍ رَ. عٍ رَهَرَ مُشِ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«يّشّ نَشٍيٍ نَ يٍ شْورَ، وٌ نْمَ نَشٍيٍ دٌندٍ، نٍيٍ نَن يَ؛ شَلٍ كَنيِ نُن بّلّ كَنيِ نَشٍيٍ نَ بَا مَ، شَ نَ مُ عَ رَ شُرٍ كُي. ");
INSERT INTO susa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","كْنْ يّشّ نَشٍيٍ نَ بَا مَ، شَ نَ مُ عَ رَ شُرٍ كُي، بّلّ مُ نَ نَشٍيٍ مَ، شَ نَ مُ عَ رَ شَلٍ مُ نَ نَشٍيٍ مَ، عٍ رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","عٍ رَهَرَ مُشِ وٌ مَ، وٌ نَشَ عٍ سُبٍ دٌن. عٍ بِنبِيٍ قَن رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","يّشّ بِرِن بّلّ نُن شَلٍ مُ نَ نَشٍيٍ مَ، عٍ رَهَرَ مُشِ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«شْنِ رَهَرَ مُشِيٍ نَن يَ وٌ مُ لَن وٌ شَ نَشٍيٍ دٌن؛ يُبّ، سّفّ، شَرُ مَ فبْنتْي، ");
INSERT INTO susa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","عَ نُن نٍيٍ مَنِيّ بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","شَاشَ قَن، وٌ نَشَ نَ دٌن عَ نُن عَ مَنِيّ بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","شُندِ، كٌوقٌلٍ، عَ نُن تَفَرَنتٌنفٌي، ");
INSERT INTO susa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","وٌ نَشَ عٍ دٌن عَ نُن نٍيٍ مَنِيّ بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","فبْنفبٌي، يٍدْنمّ، ");
INSERT INTO susa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لَابَ، تُكّ، عَ نُن نٍيٍ مَنِيّ بِرِن، وٌ نَشَ عٍ دٌن.» ");
INSERT INTO susa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«نِمَسٍ فَبُتٍنيِ نُن سَنيِ نَ نَشٍيٍ مَ، عٍ رَهَرَ مُشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","كْنْ نَ نِمَسٍ مْولِيٍ يَ مَ، نَشٍيٍ تُفَنمَ، وٌ نْمَ نٍيٍ تَن دٌندٍ، ");
INSERT INTO susa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","عَلْ كَتٌي، تُفُمِيٍ، نُن نٍيٍ مَنِيّ بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","كْنْ، نِمَسٍ فَبُتٍنيِ نُن سَنيِ نَ نَشٍيٍ مَ، عٍ رَهَرَ مُشِ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«شَ وٌ دِنمَ سُبٍ سّنِيّنتَرٍ رَ، وٌ قِندِ مَ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","نَشَن عٍ بِنبِيٍ مَشَنِنمَ، نَ كَنيِ لَن نّ عَ شَ عَ شَ دُفِيٍ شَ، عَ مَن قَ قِندِ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. قٌ عَ شَ عَ شَ دُفِيٍ شَ. ");
INSERT INTO susa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","سُبٍ نَشٍيٍ بِرِن تٌرٍ مُ عِتَشُنشِ قِرِنيِ رَ، عَ نُن نَشٍيٍ دٌنسٍ دٌنمَ، كْنْ عَ مُ فبِلٍنمَ عَ رَتٍ رَ عٍ دّ عِ عٍ نُ عَ عِدٌن، نٍيٍ رَهَرَ مُشِ وٌ مَ. نَشَن دِنمَ نَ مْولِ رَ عَ قِندِ مَ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","سُبٍ بِرِن تٌرٍ مُ نَ نَشٍيٍ بّ، عٍ عٍ حّرّ عٍ سَنيِ نَانِيٍ شُن نَ، عٍ رَهَرَ مُشِ وٌ مَ. نَشَن دِنمَ عٍ بِنبِيٍ رَ نَ قِندِ مَ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","عٍ رَهَرَ مُشِ وٌ مَ. نَشَن عٍ بِنبِيٍ مَشَنِنمَ، نَ كَنيِ لَن نّ عَ شَ عَ شَ دُفِيٍ شَ، عَ مَن قَ قِندِ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«نِمَسٍ نَشَن بِرِن لُمَ يِلِيٍ كُي، عٍ هَرَ مُشِ وٌ بّ. عٍ شِلِيٍ نَن يَ؛ بَلٍ، حّنّ، كَسَ، ");
INSERT INTO susa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","بٌنبٌلِكَ، كٌولٌ، نُن نٍيٍ مَنِيّيٍ. ");
INSERT INTO susa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","نَ نِمَسٍ شُنشُرِ مْولِيٍ رَهَرَ مُشِ وٌ مَ. نَشَن دِنمَ عٍ بِنبِيٍ رَ عَ قِندِ مَ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","شَ عٍ بِنبِيٍ سَ بِرَ سٍ ندٍ قَرِ، نَ قَن قِندِ مَ سٍ سّنِيّنتَرٍ رَ، عَلْ سٍ سَ سٍ وُرِ دَاشِ، دُفِ، شُرُ سٍ كِرِ شَرَشِ، بّكِ، شَ نَ مُ عَ رَ يِرَبَسٍ ندٍ. عَ لَنمَ نَ سٍ مْولِ شَ سَ يٍ شْورَ هَن نُنمَرٍ رَ عَلَكٌ عَ شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","شَ نَ نِمَسٍ مْولِ بِرَ قّحّ ندٍ كُي، قّحّ نُن عَ كُي سٍ بِرِن قِندِ مَ سٍ سّنِيّنتَرٍ رَ. نَ قّحّ شَ كَنَ. ");
INSERT INTO susa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","يٍ نَشَن نُ نَ نَ قّحّ كُي، عَ نَ سَ دٌنسٍ ندٍ مَ، نَ دٌنسٍ قَن قِندِ مَ سٍ سّنِيّنتَرٍ رَ. مِنسٍ يٌ نَشَن نُ نَ نَ قّحّ كُي، عَ قَن قِندِ مَ سٍ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","شَ نَ نِمَسٍ مْولِ بِنبِ بِرَ سٍ يٌ مَ، نَ قِندِ مَ سٍ سّنِيّنتَرٍ رَ، عَلْ تَامِ فَنسٍ، شَ نَ مُ عَ رَ تُندٍ. عٍ تٌ قِندِ سٍ سّنِيّنتَرٍيٍ رَ، عَ لَنمَ وٌ شَ عٍ كَنَ. ");
INSERT INTO susa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","كْنْ شَ عٍ بِنبِ سَ بِرَ دُلٌنيِ نَن كُي، شَ نَ مُ عَ رَ يٍ رَفَتَدٍ ندٍ، نٍيٍ تَن مُ قِندِ مَ سٍ سّنِيّنتَرٍيٍ رَ. كْنْ مِشِ نَشَن عَ بّلّشّ دِنمَ عٍ بِنبِيٍ رَ، نَ قِندِ مَ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","شَ عَ بِنبِ بِرَ سَنسِ شْرِ مَ نَشَن سِمَ، نَ مُ قِندِ مَ سٍ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","كْنْ شَ عَ بِنبِ بِرَ سَنسِ شْرِ تَن مَ نَشَن نَ يٍ شْورَ، نَ سَنسِ شْرِ قِندِ مَ سٍ سّنِيّنتَرٍ رَ وٌ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«شَ شُرُ سٍ رَدَشَشِ ندٍ قَشَ، مِشِ قَ دِن عَ بِنبِ رَ، نَ كَنيِ قِندِ مَ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","نَشَن نَ عَ سُبٍ دٌن، نَ كَنيِ لَن نّ عَ شَ عَ شَ دُفِيٍ شَ، عَ مَن قَ قِندِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. نَشَن نَ سُبٍ بِنبِ مَشَنِن، نَ كَنيِ لَن نّ عَ شَ عَ شَ دُفِيٍ شَ، عَ مَن قَ قِندِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«نِمَسٍ نَشَن بِرِن عَ بُبُمَ بْشِ مَ، نٍيٍ بِرِن رَهَرَ مُشِ وٌ مَ. عَ مُ لَنمَ وٌ شَ نٍيٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","بُبُسٍيٍ نُن نِمَسٍ شُنشُرِ نَشٍيٍ حّرّ مَ عٍ سَنيِ نَانِ شُن نَ، شَ نَ مُ عَ رَ عٍ سَنيِ وُيَشِ شُن نَ، عٍ سٍسٍ مُ رَدَشَشِ. وٌ نَشَ عٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","وٌ نَشَ وٌ يّتّ قِندِ سّنِيّنتَرٍ رَ نَ نِمَسٍ مْولِ سَابُي رَ. وٌ نَشَ عٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ. وٌ شَ وٌ يّتّ قِ ﭑ تَن نَن مَ. وٌ شَ سّنِيّن، بَرِ مَ ﭑ تَن سّنِيّن. وٌ نَشَ وٌ يّتّ قِندِ سّنِيّنتَرٍ رَ نَ نِمَسٍ شُنشُرِ سَابُي رَ نَشٍيٍ لُمَ حّرّ رَ بْشِ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","«ﭑ تَن نَن عَلَتَلَ رَ نَشَن وٌ رَ مِنِشِ مِسِرَ بْشِ مَ، عَلَكٌ ﭑ شَ قِندِ وٌ مَرِفِ عَلَ رَ. وٌ شَ سّنِيّن، بَرِ مَ ﭑ تَن سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","سّرِيّ نَن نَ كِ سُبٍيٍ، شْنِيٍ، يّشّييٍ، نُن بُبُسٍيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","نَ كُي وٌ نْمَ سُبٍ سّنِيّنشِ نُن سُبٍ سّنِيّنتَرٍ تَفِ رَبَ كٌلٌندٍ، سُبٍ رَدَشَشِ نُن سُبٍ رَهَرَ مُشِ.» ");
INSERT INTO susa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، شَ فِنّ ندٍ سَ تّيفّ، عَ دِ شّمّ بَرِ، عَ قِندِ مَ سّنِيّنتَرٍ رَ شِ سٌلٌقٍرٍ بُن مَ، عَلْ عَ كِكٍ وَلِمَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","شِ سٌلٌمَسَشَن لْشْي، دِ شَ سُننَ. ");
INSERT INTO susa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","نَ شِ سٌلٌقٍرٍ شَنبِ، دِنفّ لُمَ سّنِيّنتَرٍحَ كُي شِ تٌنفٌ سَشَن نُن سَشَن بُن مَ عَ وُلِ شَ قٍ رَ نَشَن مِنِشِ عَ مَ عَ دِ بَرِ تّمُي. عَ مُ لَنمَ عَ شَ دِن سٍ سّنِيّنشِ رَ، عَ مُ لَنمَ عَ شَ سٌ يِرٍ سّنِيّنشِ كُي هَن مَرَ سّنِيّنيِ وَشَتِ شَ كَمَلِ.» ");
INSERT INTO susa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«شَ دِنفّ دِ فِنّ بَرِ، عَ لُمَ سّنِيّنتَرٍحَ كُي لْشْشُن قِرِن، عَلْ عَ كِكٍ وَلِمَ تّمُي نَشّ. نَ شَنبِ عَ شَ مَرَ سّنِيّنيِ وَشَتِ بُمَ شِ تٌنفٌ سٍننِ نُن سٍننِ، عَ وُلِ شَ قٍ رَ نَشَن مِنِشِ عَ دِ بَرِ تّمُي. ");
INSERT INTO susa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","عَ شَ مَرَ سّنِيّنيِ وَشَتِ نَ كَمَلِ، دِ شّمّ، شَ نَ مُ عَ رَ دِ فِنّ شَ قٍ رَ، عَ شَ يّشّي حّ كٍرٍن دَاشِ شَنِن سّرّشّدُبّ شْن مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عَ شَ نَ بَ سّرّشّ فَن دَاشِ رَ. عَ مَن شَ كٌلٌكٌندٍ يْرّ، شَ نَ مُ عَ رَ فَنبّ بَ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","سّرّشّدُبّ شَ نَ سّرّشّيٍ بَ عَلَتَلَ بّ، عَ قِندِ نَ فِنّ شَ شُنسَرٍ رَ. نَ تّمُي عَ سّنِيّنمَ نّ نَ وُلِ شَ قٍ رَ. سّرِيّ نَن نَ كِ فِنّ بّ نَشَن دِ شّمّ بَرِ مَ، شَ نَ مُ عَ رَ دِ فِنّ. ");
INSERT INTO susa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","شَ قّيرّ مُ نَ عَ يِ عَ شَ يّشّي سْتْ، عَ نْمَ فَنبّ قِرِن شَنِندٍ، شَ نَ مُ عَ رَ كٌلٌكٌندٍ قِرِن. كٍرٍن شَ بَ سّرّشّ فَن دَاشِ رَ، بٌورٍ شَ بَ يُنُبِ شَقَرِ سّرّشّ رَ. سّرّشّدُبّ شَ نَ بَ، عَ قِندِ شُنسَرٍ رَ فِنّ بّ، عَ قَ سّنِيّن.» ");
INSERT INTO susa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«شَ مِشِ قَتٍ كِرِ يِرٍ ندٍ قُنتُ، شَ نَ مُ عَ رَ عَ قِيشّ، شَ نَ مُ عَ رَ عَ قِندِ قِ رَ، وٌ شَ نَ كَنيِ شَنِن سّرّشّدُبّ هَرُنَ يِرٍ، شَ نَ مُ عَ رَ عَ شَ دِ ندٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","قُرٍ نَشَن نَ عَ قَتٍ، سّرّشّدُبّ شَ نَ مَتٌ. شَ قَتٍ شَبٍ بَرَ قِيشّ نَ قِ يِرٍ، قِ قَن بَرَ تِلِن، عَ سُبٍ لِ، قُرٍ حَاشِ نَ عَ رَ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","شَ قُرٍ يَ مُ عِتِلِن عَ نَ كِرِ نَن فبَنسَن قَرِ، قَتٍ شَبٍ مُ قِيشّشِ نَ لٌنفٌرِ، سّرّشّدُبّ شَ قُرٍ مَ يَمَرِ عَ شَ لُ عَ كٍرٍنيِ مَ لْشْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","عَ شِ سٌلٌقٍرٍ ندٍ لْشْي، سّرّشّدُبّ مَن شَ عَ مَتٌ. شَ عَ سَ لِ قُرٍ مُ نَ لَنتَنقٍ، عَ مَن شَ قُرٍ مَ يَمَرِ عَ شَ لُ عَ كٍرٍنيِ مَ لْشْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","عَ شِ سٌلٌقٍرٍ ندٍ لْشْي، سّرّشّدُبّ مَن شَ عَ مَتٌ عَ سَنمَيَ قِرِن ندٍ. شَ قُرٍ حِنفِ بَرَ مَسَرَ، عَ مَن مُ لَنتَنقٍ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ سّنِيّن. قُرٍ نَ عَ رَ نَشَن مُ حَاشُ. عَ شَ عَ شَ دُفِيٍ شَ، عَ قِندِ مِشِ سّنِيّنشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","كْنْ شَ سّرّشّدُبّ بَرَ عَ مَتٌ، قُرٍ بَرَ لَنتَن يّ نَ مَسٍنيِ دَنفِ شَنبِ، قُرٍ مَ مَن شَ فبِلٍن سّرّشّدُبّ يِرٍ تّمُي فبّتّ. ");
INSERT INTO susa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","سّرّشّدُبّ مَن شَ عَ مَتٌ. شَ قُرٍ بَرَ لَنتَن يّ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ سّنِيّنتَرٍ رَ، قُرٍ حَاشِ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«شَ قُرٍ حَاشِ بَرَ لُ مِشِ ندٍ كِرِ مَ، عٍ شَ عَ شَنِن سّرّشّدُبّ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","عَ شَ عَ مَتٌ. شَ نَ مِشِ كِرِ بَرَ قِيشّ يِرٍ ندٍ، عَ قَ قُنتُ، قَتٍ شَبٍ قَن قَ قِيشّ نَ لٌنفٌرِ، عَ بُلَ، سُبٍ مِنِ كّنّ مَ، ");
INSERT INTO susa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","قُرٍ حَاشِ نَ عَ رَ نَشَن مُ دَندَنمَ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. هَلِ عَ مُ لُ عَ كٍرٍنيِ مَ وَشَتِ دِ بُن مَ سْنْن، سّرّشّدُبّ مَن شَ عَ مَتٌ. نَ تَن بَرَ فّ قِندِدٍ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","شَ سّرّشّدُبّ بَرَ عَ تٌ عَ نَ قِ حَاشِ بِرِن بَرَ بَرِ قْلْ، نَشَن نُ نَ قُرٍ مَ قَتٍ مَ، كٍلِقٍ عَ سَنيِيٍ مَ هَن عَ شُنيِ، ");
INSERT INTO susa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","عَ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ سّنِيّن، بَرِ مَ قِ بِرِن بَرَ بَرِ قْلْ. عَ بَرَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","كْنْ شَ، قُرٍ سَ بُلَ، سُبٍ مِنِ كّنّ مَ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","سّرّشّدُبّ نَ قُرٍ بُلَشِ تٌ، عَ شَ مَسٍنيِ تِ، قِ بُلَشِ مُ سّنِيّن، قُرٍ حَاشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","شَ سُبٍ بُلَشِ قَ بَرِ، قُرٍ مَ شَ سِفَ سّرّشّدُبّ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","عَ شَ عَ مَتٌ. شَ قُرٍ بَرَ بَرِ، سّرّشّدُبّ شَ مَسٍنيِ تِ، قُرٍ مَ بَرَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","شَ سُورِ مِنِ مِشِ مَ، عَ قَ يَلَن، ");
INSERT INTO susa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","كْنْ نَ كِرِ قَ قِيشّ، شَ نَ مُ عَ رَ عَ فبٍيلِ، نَ كَنيِ شَ سِفَ سّرّشّدُبّ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","عَ شَ عَ مَتٌ. شَ قُرٍ يَ بَرَ عِتِلِن، عَ سُبٍ لِ، قَتٍ شَبٍ بَرَ قِيشّ نَ لٌنفٌرِ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. قُرٍ حَاشِ نَ عَ رَ، نَشَن مِنِشِ سُورِ قْشِ. ");
INSERT INTO susa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","شَ سّرّشّدُبّ مُ قَتٍ شَبٍ قِيشّ تٌ، قِ قَن مُ تِلِن، عَ مُ سُبٍ لِشِ، عَ مُ قِيشّ عَ فبٍ رَ، قُرٍ مَ شَ لُ عَ كٍرٍنيِ مَ لْشْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","شَ قُرٍ بَرَ لَنتَن يّ عَ قَتٍ مَ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ، قُرٍ حَاشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","كْنْ شَ قُرٍ مُ مَسَرَشِ عَ مُ لَنتَنشِ عَ عِ، سُورِ بَرِشِ نَ عَ رَ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ مِشِ سّنِيّنشِ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«شَ مِشِ قَتٍ بَرَ فَن تّ رَ تّمُي دَنفِشِ، عَ كِرِ قَ بَرِ، كْنْ قُرٍ فبٍيلِ، شَ نَ مُ عَ رَ قُرٍ قِيشّ قَ مِنِ نَ قْشِ، ");
INSERT INTO susa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","سّرّشّدُبّ شَ نَ مَتٌ. شَ قُرٍ مَ قَتٍ شَبٍ بَرَ قِيشّ نَ قْشِ، قُرٍ بَرَ تِلِن، عَ سُبٍ لِ، قُرٍ حَاشِ نَ عَ رَ، نَشَن بَرَ مِنِ قَتٍ مَ كِرِ دّننَشّ نُ فَنشِ. نَ سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ، بَرِ مَ قُرٍ حَاشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","كْنْ شَ سّرّشّدُبّ مُ قَتٍ شَبٍ قِيشّ تٌ قُرٍ مَ، قِ قَن يَ مُ عِتِلِن، عَ مُ سُبٍ لِشِ، عَ مُ قِيشّ عَ فبٍ رَ، سّرّشّدُبّ شَ نَ كَنيِ يَمَرِ عَ شَ لُ عَ كٍرٍنيِ مَ لْشْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","سّرّشّدُبّ شَ عَ مَتٌ شِ سٌلٌقٍرٍ ندٍ لْشْي. شَ قُرٍ بَرَ لَنتَن يّ عَ قَتٍ مَ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ، قُرٍ حَاشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","كْنْ شَ قُرٍ مُ مَسَرَشِ، عَ مُ لَنتَنشِ عَ عِ، عَ مُ قِيشّ عَلْ عَ سِنفٍ، عَ قَتَنشِ نَ كِرِ فَنشِ نَن نَ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ مِشِ سّنِيّنشِ نَ عَ رَ. نَرِ نَ عَ رَ كِرِ دّننَشّ فَن.» ");
INSERT INTO susa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«شَ قُرٍ لُ شّمّ، شَ نَ مُ عَ رَ فِنّ شُنيِ مَ، شَ نَ مُ عَ رَ عَ كٍنكٍنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","سّرّشّدُبّ شَ نَ قُرٍ مَتٌ. شَ قِ يَ بَرَ عِتِلِن، عَ سُبٍ لِ، قَتٍ شَبٍ قِيشّ، عَ شُرُن، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. قُرٍ حَاشِ نَ عَ رَ نَشَن بَرَ لُ عَ شُنيِ مَ، شَ نَ مُ عَ رَ عَ كٍنكٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","شَ سّرّشّدُبّ سَ عَ تٌ قُرٍ يَ مُ عِتِلِنقٍ، عَ مُ سُبٍ لِقٍ، قَتٍ شَبٍ قْورّ مُ نَ، عَ شَ قُرٍ مَ يَمَرِ عَ شَ لُ عَ كٍرٍنيِ مَ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","سّرّشّدُبّ شَ نَ قُرٍ مَتٌ شِ سٌلٌقٍرٍ ندٍ لْشْي. شَ قُرٍ مُ لَنتَنقٍ عَ عِ، قَتٍ شَبٍ مُ قِيشّ نَ لٌنفٌرِ، قِ يَ مُ عِتِلِنشِ، عَ مُ سُبٍ لِشِ، ");
INSERT INTO susa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","نَ كَنيِ شَ عَ شُنسّشّ نُن عَ دّشَبٍ بِ عَ شَ عَ بَ قِ رَ. سّرّشّدُبّ مَن شَ قُرٍ مَ يَمَرِ عَ شَ لُ عَ كٍرٍنيِ مَ لْشْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","سّرّشّدُبّ شَ نَ قُرٍ مَن مَتٌ شِ سٌلٌقٍرٍ ندٍ لْشْي. شَ عَ مُ لَنتَنشِ عَ عِ، عَ يَ مُ عِتِلِنشِ، عَ مُ سُبٍ لِشِ، سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ مِشِ سّنِيّنشِ نَ عَ رَ. عَ شَ عَ شَ دُفِيٍ شَ، عَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","كْنْ سّرّشّدُبّ شَ مَسٍنيِ دَنفِ شَنبِ، شَ قُرٍ بَرَ لَنتَن يّ قُرٍ مَ قَتٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","سّرّشّدُبّ مَن شَ عَ مَتٌ. شَ قُرٍ بَرَ لَنتَن يّ، هَلِ سّرّشّدُبّ مُ قَتٍ شَبٍ قِيشّ قٍن. نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","كْنْ شَ نَ قُرٍ مُ لَنتَنشِ عَ عِ، قَتٍ شَبٍ قْورّ ندٍ تَن بَرَ مِنِ، قُرٍ بَرَ يَلَن. نَ كَنيِ مِشِ سّنِيّنشِ نَ عَ رَ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ مِشِ سّنِيّنشِ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«شَ شّمّ، شَ نَ مُ عَ رَ فِنّ قَتٍ كِرِ بَرَ قِيشّ يِرٍ ندٍيٍ، ");
INSERT INTO susa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","سّرّشّدُبّ شَ نَ مَتٌ. شَ نَ مُ قِيشّ عَ فبٍ رَ، كَسِ مْولِ ندٍ فبَنسَن نَ عَ رَ. عَ سّنِيّن.» ");
INSERT INTO susa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«شَ مِشِ ندٍ شُنسّشّ بَرَ مَكْن، تّرّرّ كَنيِ نَ عَ رَ، عَ مُ حَاشُ. نَ كَنيِ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","شَ مِشِ ندٍ شُنسّشّ مَكْنشِ عَ تِفِ دّ بِرِ فبَنسَن نّ، تّرّرّ نَ عَ رَ عَ مُ حَاشُ. نَ كَنيِ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","كْنْ شَ قُرٍ قِيشّ، شَ نَ مُ عَ رَ قُرٍ فبٍيلِ مِنِ عَ شُنيِ مَ، شَ نَ مُ عَ رَ عَ تِفِ مَ، قُرٍ حَاشِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","سّرّشّدُبّ شَ نَ مَتٌ. شَ نَ قُرٍ قُنتُ نَشَن مِنِشِ عَ شُنيِ مَ، عَ قِيشّ، شَ نَ مُ عَ رَ عَ فبٍيلِ عَلْ قُرٍ حَاشِ نَ كِ نَشّ، ");
INSERT INTO susa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","قُرٍ مَ نَ عَ رَ، عَ مُ سّنِيّنشِ. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. قُرٍ نَ عَ شُنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«نَ قُرٍ حَاشِ كَنيِ شَ دُفِ عِبْوشِ رَفٌرٌ عَ مَ، عَ شَ عَ شُنيِ بِ، عَ شَ عَ دّ شَبٍ مَكٌتٌ عَ بّلّشّ رَ، عَ نُ عَ قَلَ عَ شُي عِتٍشِ رَ ‹سّنِيّنتَرٍ، سّنِيّنتَرٍ.› ");
INSERT INTO susa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","دَنمِ نَ قُرٍ حَاشِ نَ عَ مَ، عَ مُ سّنِيّن. قٌ عَ شَ لُ عَ كٍرٍنيِ مَ حَمَ يٌنكِندٍ قَرِ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«نَ قُرٍ حَاشِ نْمَ لُدٍ دُفِ مَ نَشَن يَءِلَنشِ شُرُ سٍ شَبٍ رَ، شَ نَ مُ عَ رَ فّسّ قُتٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","عَ مَن نْمَ لُدٍ سٍ ندٍ دّنبّشِ مَ نَشَن يَءِلَنشِ شُرُ سٍ شَبٍ رَ، شَ نَ مُ عَ رَ فّسّ قُتٍ رَ. عَ مَن نْمَ لُدٍ سٍ ندٍ مَ نَشَن يَءِلَنشِ شُرُ سٍ كِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","شَ نَ قُرٍ بَرَ عِقْورْ، شَ نَ مُ عَ رَ عَ بَرَ فبٍيلِ دُفِ مَ، كِرِ مَ، شَ نَ مُ عَ رَ سٍ دّنبّشِ مَ، قُرٍ حَاشِ نَ عَ رَ. عَ شَ مَسٍن سّرّشّدُبّ بّ، عَ شَ نَ مَتٌ. ");
INSERT INTO susa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","نَ قُرٍ نَ سٍ نَشَن مَ، نَ سٍ شَ رَفَتَ يِرٍ ندٍ عَ كٍرٍنيِ مَ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","شِ سٌلٌقٍرٍ ندٍ لْشْي سّرّشّدُبّ مَن شَ عَ مَتٌ. شَ نَ قُرٍ بَرَ لَنتَن يّ عِ نَ دُفِ مَ، شَ نَ مُ عَ رَ نَ سٍ دّنبّشِ مَ، شَ نَ مُ عَ رَ نَ كِرِ مَ، قُرٍ حَاشِ نَ عَ رَ. نَ بَرَ قِندِ سٍ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","سّرّشّدُبّ شَ سٍ بِرِن فَن نَ قُرٍ نَ سٍ نَشَن مَ، دُفِ نَشَن يَءِلَنشِ شُرُ سٍ شَبٍ رَ، دُفِ نَشَن يَءِلَنشِ فّسّ قُتٍ رَ، دُفِ دّنبّشِ، شَ نَ مُ عَ رَ كِرِ. ");
INSERT INTO susa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","كْنْ شَ سّرّشّدُبّ بَرَ عَ مَتٌ، نَ قُرٍ مُ لَنتَنشِ نَ سٍيٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","عَ شَ يَامَرِ قِ نَ سٍيٍ شَ مَشَ يٍ رَ، عٍ شَ سَ عٍ كٍرٍنيِ مَ شِ سٌلٌقٍرٍ بُن مَ سَنمَيَ قِرِن ندٍ. ");
INSERT INTO susa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","عَ نَ فّ مَشَدٍ، سّرّشّدُبّ مَن شَ نَ مَتٌ. شَ قُرٍ مُ مَسَرَشِ، هَلِ عَ مَن مُ لَنتَنشِ عَ عِ، نَ قِندِشِ سٍ سّنِيّنتَرٍ نَن نَ. عَ بِرِن شَ فَن تّ رَ، هَلِ قُرٍ نَ عَ لَهَلّ كٍرٍنيِ فبَنسَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","شَ سّرّشّدُبّ بَرَ عَ تٌ قُرٍ مُ قِيشّ عَلْ سِنفٍ، عَ شَ نَ يِرٍ فبَنسَن بَ نَ. ");
INSERT INTO susa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","كْنْ شَ قُرٍ نَ لَنتَنقٍ عَ عِ دُفِ مَ، شَ نَ مُ عَ رَ دُفِ دّنبّشِ مَ، شَ نَ مُ عَ رَ كِرِ مَ، قُرٍ حَاشِ نَ عَ رَ، قٌ نَ شَ فَن تّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","شَ قُرٍ بَرَ بَ دُفِ مَ، شَ نَ مُ عَ رَ دُفِ دّنبّشِ مَ، شَ نَ مُ عَ رَ كِرِ مَ يٍ رَ عَ قِرِن ندٍ، عَ بَرَ سّنِيّن.» ");
INSERT INTO susa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","سّرِيّ نَن نَ كِ قُرٍ حَاشِ شَ قٍ رَ نَشَن نْمَ لُدٍ دُفِ ندٍ مَ نَشَن يَءِلَنشِ شُرُ سٍ شَبٍ رَ، شَ نَ مُ عَ رَ فّسّ قُتٍ رَ، عَ نُن دُفِ ندٍ مَ نَشَن دّنبّشِ، عَ نُن كِرِ ندٍ مَ. نَ سّرِيّ نْمَ عَ مَسٍندٍ شَ سٍ ندٍ سّنِيّن، شَ نَ مُ عَ مُ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«مَرَ سّنِيّنيِ لْشْي، قُرٍ حَاشِ كَنيِ شَ سِفَ سّرّشّدُبّ شْن. ");
INSERT INTO susa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","سّرّشّدُبّ شَ سِفَ حَمَ يٌنكِندٍ قَرِ مَ نَ قُرٍ مَ مَتٌدٍ. شَ عَ بَرَ يَلَن، ");
INSERT INTO susa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","سّرّشّدُبّ شَ يَامَرِ قِ، عَ شَ قَ شْنِ حِحّ رَدَشَشِ قِرِن نَ، عٍ نُن سّدِرِ وُرِ، فّرّ مْولِ ندٍ، نُن هِسٌثِ وُرِ قُرٍ مَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","سّرّشّدُبّ شَ يَامَرِ قِ، عٍ شَ شْنِ كٍرٍن كْن نَشَبَ قّحّ ندٍ شُن مَ، دُلٌن يٍ نَ نَشَن كُي. ");
INSERT INTO susa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","عَ شَ شْنِ حِحّ تٌنفٌ، عَ نُن سّدِرِ وُرِ، فّرّ مْولِ ندٍ، نُن هِسٌثِ وُرِ، عَ شَ عٍ بِرِن دُكُلُ شْنِ وُلِ شْورَ عٍ نَشَن كْن نَشَبَشِ دُلٌن يٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","عَ شَ نَ كَسَن سَنمَيَ سٌلٌقٍرٍ نَ قُرٍ مَ مَ، نَشَن لَنمَ عَ شَ سّنِيّن. سّرّشّدُبّ شَ مَسٍنيِ تِ، نَ مِشِ بَرَ قِندِ مِشِ سّنِيّنشِ رَ. نَ تّمُي عَ شَ شْنِ حِحّ بّحِن وُلَ عِ.» ");
INSERT INTO susa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«نَشَن وَ مَ سّنِيّنقٍ، عَ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ قَتٍ مَشَبٍ بِ، عَ شَ عَ مَشَ يٍ رَ. نَ كُي، عَ سّنِيّنمَ نّ. نَ دَنفِ شَنبِ عَ نْمَ سٌدٍ حَمَ يٌنكِندٍ كُي، كْنْ عَ مُ نْمَ سٌدٍ عَ شَ كِرِ بَنشِ تَن كُي شِ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","شِ سٌلٌقٍرٍ ندٍ لْشْي، عَ مَن شَ عَ شُنسّشّ بِ، عَ دّ شَبٍ، عَ يَ شِنبِ شَبٍ، عَ نُن عَ قَتٍ مَشَبٍ بِرِن. عَ مَن شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ قَتٍ مَشَ. نَ كُي، عَ سّنِيّنمَ نّ. ");
INSERT INTO susa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","شِ سٌلٌمَسَشَن ندٍ لْشْي، عَ شَ يّشّييْرّ شّمّمَ قِرِن تٌنفٌ، عَ نُن يّشّي فِنّمَ، حّ كٍرٍن دَاشِ، لَنيُرُ مُ نَ نَشٍيٍ مَ. عَ مَن شَ سَنسِ شْرِ دِنشِ كٌنبٌ يَ كٍرٍن نُن عَ تَفِ سْتْ، تُرٍ مَسُنبُشِ نَشَن نَ، عَ نُن تُرٍ سِفَاتِ يَ كٍرٍن نَشَن قِندِ مَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","سّرّشّدُبّ شَ قُرٍ مَ نُن عَ شَ سّرّشّ تِ ﭑ تَن عَلَتَلَ يَ عِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","عَ شَ يّشّييْرّ كٍرٍن تٌنفٌ، عَ شَ عَ بَ يّتّ رَفبِلٍن سّرّشّ رَ، عَ نُن تُرٍ سِفَاتِ يَ كٍرٍن. عَ شَ نٍيٍ لِنتَن ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","عَ شَ نَ يّشّي كْن نَشَبَ يِرٍ سّنِيّنشِ يُنُبِ شَقَرِ سّرّشّ نُن سّرّشّ فَن دَاشِ بَمَ دّننَشّ. سّرّشّدُبّ نَن فبٍ يّتّ رَفبِلٍن سّرّشّ نُن يُنُبِ شَقَرِ سّرّشّ رَ. سّرّشّ سّنِيّنشِ نَن عٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","سّرّشّدُبّ شَ يّتّ رَفبِلٍن سّرّشّ وُلِ ندٍ تٌنفٌ، عَ شَ عَ سَ قُرٍ مَ يِرٍقَنيِ تُلِ مَ، عَ بّلّشّكُرَ يِرٍقَنيِ مَ، نُن عَ سَنكُرَ يِرٍقَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","عَ مَن شَ نَ تُرٍ سِفَاتِ يَ كٍرٍن عِقِلِ عَ يّتّ كْولَ بّلّشّ كُي. ");
INSERT INTO susa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","عَ شَ عَ بّلّشّسٌلٍ يِرٍقَنيِ سِن تُرٍ كُي، عَ نُ بَرَ نَشَن سَ عَ كْولَ بّلّشّ كُي، عَ شَ نَ تُرٍ كَسَن دْشْ سٌلٌقٍرٍ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","تُرٍ نَشَن لُشِ سّرّشّدُبّ بّلّشّ كُي، عَ شَ ندٍ سَ قُرٍ مَ يِرٍقَنيِ تُلِ مَ، عَ نُن عَ بّلّشّكُرَ يِرٍقَنيِ مَ، عَ نُن عَ سَنكُرَ يِرٍقَنيِ مَ يّتّ رَفبِلٍن سّرّشّ وُلِ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","تُرٍ دْنشْي نَشَن لُشِ سّرّشّدُبّ يِ رَ، عَ شَ نَ سَ قُرٍ مَ شُنيِ مَ. سّرّشّدُبّ شَ عَ شُن سَرَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","سّرّشّدُبّ شَ يُنُبِ شَقَرِ سّرّشّ بَ، عَ شَ عَ شُن سَرَ عَ شَ سّنِيّنتَرٍحَ مَ. نَ دَنفِ شَنبِ عَ شَ نَ سّرّشّ فَن دَاشِ كْن نَشَبَ. ");
INSERT INTO susa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","عَ شَ سّرّشّ فَن دَاشِ نُن سَنسِ شْرِ دِنشِ سّرّشّ بَ سّرّشّبَدٍ قَرِ. عَ شَ قُرٍ مَ شُن سَرَ عَلَكٌ عَ شَ سّنِيّن.» ");
INSERT INTO susa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«شَ سٍتَرٍ نَن نَ قُرٍ مَ رَ، قّيرّ مُ نَ عَ يِ نَ سّرّشّ شَ قٍ رَ، عَ شَ يّشّييْرّ كٍرٍن فبَنسَن بَ يّتّ رَفبِلٍن سّرّشّ رَ، نَشَن لِنتَنمَ ﭑ تَن عَلَتَلَ يَ عِ عَ شَ قِندِ قُرٍ مَ شَ شُنسَرٍ رَ. عَ شَ سَنسِ شْرِ دِنشِ كٌنبٌ يَ تَفِ سْتْ، تُرٍ مَسُنبُشِ نَشَن نَ، عَ نُن تُرٍ سِفَاتِ يَ كٍرٍن، ");
INSERT INTO susa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","نُن فَنبّ قِرِن، شَ نَ مُ عَ رَ كٌلٌكٌندٍ يْرّ قِرِن. كٍرٍن شَ قِندِ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ سّرّشّ فَن دَاشِ. ");
INSERT INTO susa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","شِ سٌلٌمَسَشَن ندٍ لْشْي، عَ شَ قَ نَ سّرّشّيٍ رَ سّرّشّدُبّ شْن هْرْ مْلِنفِرَ سٌدٍ دّ رَ ﭑ تَن عَلَتَلَ يَ عِ، عَلَكٌ عَ شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","سّرّشّدُبّ شَ يّتّ رَفبِلٍن سّرّشّ يّشّي نُن تُرٍ سِفَاتِ يَ كٍرٍن لِنتَن ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","عَ شَ نَ يّشّييْرّ كْن نَشَبَ يّتّ رَفبِلٍن سّرّشّ رَ. عَ شَ عَ وُلِ ندٍ تٌنفٌ، عَ شَ نَ سَ قُرٍ مَ يِرٍقَنيِ تُلِ مَ، عَ يِرٍقَنيِ بّلّشّكُرَ مَ، عَ نُن عَ يِرٍقَنيِ سَنكُرَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","عَ شَ تُرٍ ندٍ عِقِلِ عَ يّتّ كْولَ بّلّشّ كُي. ");
INSERT INTO susa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","عَ شَ نَ تُرٍ كَسَن سَنمَيَ سٌلٌقٍرٍ عَ بّلّشّسٌلٍ يِرٍقَنيِ رَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","تُرٍ نَشَن نَ عَ بّلّشّ كُي، عَ شَ دٌندٌرٌنتِ تٌنفٌ، عَ نَ سَ قُرٍ مَ يِرٍقَنيِ تُلِ مَ، عَ يِرٍقَنيِ بّلّشّكُرَ مَ، عَ نُن عَ يِرٍقَنيِ سَنكُرَ مَ وُلِ قَرِ نَشَن كٍلِ يّتّ رَفبِلٍن سّرّشّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","تُرٍ نَشَن لُشِ عَ بّلّشّ كُي، عَ شَ نَ سَ نَ قُرٍ مَ شُنيِ مَ، عَلَكٌ عَ شُن شَ سَرَ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","سّرّشّدُبّ شَ فَنبّ كٍرٍن بَ، شَ نَ مُ عَ رَ كٌلٌكٌندٍ يْرّ، سّرّشّيٍ يَ مَ قُرٍ مَ نَشٍيٍ سْتْشِ. ");
INSERT INTO susa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","عَ شَ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ شَ قِندِ سّرّشّ فَن دَاشِ رَ، عَ نُن سَنسِ شْرِ دِنشِ. سّرّشّدُبّ قُرٍ مَ شُن سَرَ مَ ﭑ تَن عَلَتَلَ يَ عِ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","سّرِيّ نَن نَ كِ مَرَ سّنِيّنيِ شَ قٍ رَ قُرٍ مَيٍ بّ نَشٍيٍ قِندِشِ سٍتَرٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«وٌ نَ سٌ كَنَان بْشِ مَ، ﭑ نَشَن قِمَ وٌ مَ كّ رَ، شَ قُرٍ حَاشِ سَ مِنِ وٌ شَ بَنشِ كَنكٍيٍ مَ مّننِ، ");
INSERT INTO susa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","بَنشِ كَنيِ شَ سَ عَ قَلَ سّرّشّدُبّ بّ، ‹ﭑ بَرَ قُرٍ حَاشِ تٌ ﭑ مَ بَنشِ مَ.› ");
INSERT INTO susa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","سّرّشّدُبّ شَ يَامَرِ قِ، عٍ شَ سٍ بِرِن نَمِنِ بَنشِ كُي بٍينُ عَ شَ سِفَ قُرٍ حَاشِ مَتٌدٍ، عَلَكٌ سٍ نَشَن نَ بَنشِ كُي، نَ نَشَ قِندِ سٍ سّنِيّنتَرٍ رَ. عٍ نَ فّ نَ رَبَدٍ، سّرّشّدُبّ شَ سِفَ نَ بَنشِ مَتٌدٍ.» ");
INSERT INTO susa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","«سّرّشّدُبّ شَ نَ قُرٍ مَتٌ. شَ قُرٍ قْورْ، شَ نَ مُ عَ رَ عَ فبٍيلِ، عَ مَن يَ نَشَ عِتِلِن، عَ بَنشِ كَنكٍ سُشُ، ");
INSERT INTO susa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","سّرّشّدُبّ شَ مِنِ بَنشِ كُي، عَ شَ بَنشِ نَادّ بَلَن لْشُن كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","شِ سٌلٌقٍرٍ ندٍ لْشْي، سّرّشّدُبّ مَن شَ فبِلٍن نَا. شَ قُرٍ بَرَ لَنتَن يّ عِ بَنشِ كَنكٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","سّرّشّدُبّ شَ يَامَرِ قِ، بَنشِ فّمّيٍ شَ بَ نَ قُرٍ نَ دّننَشّ، عٍ شَ عٍ وْلّ تَا قَرِ مَ يِرٍ سّنِيّنتَرٍ. ");
INSERT INTO susa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","بَنشِ كَنكٍ شَ مَشْولِن بَنشِ كُي. نَشَن بَمَ، نَ شَ وٌلِ تَا قَرِ مَ يِرٍ سّنِيّنتَرٍ. ");
INSERT INTO susa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","فّمّ فبّتّيٍ شَ سَ بٌورٍيٍ حْشْي رَ، بَنشِ كَنكٍ شَ مَسٌ عَ نّينّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«نَ وَلِ بِرِن دَنفِ شَنبِ، شَ قُرٍ حَاشِ مَن مِنِ بَنشِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","سّرّشّدُبّ شَ فبِلٍن نَ مَتٌ رَ. شَ قُرٍ بَرَ لَنتَن يّ بَنشِ كُي، قُرٍ حَاشِ نَ عَ رَ، عَ قِندِشِ سٍ سّنِيّنتَرٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","نَ بَنشِ شَ رَبِرَ، عَ فّمّيٍ، عَ وُرِيٍ، نُن عَ مَسٌ بّندّ بِرِن شَ وْلّ تَا قَرِ مَ يِرٍ سّنِيّنتَرٍ. ");
INSERT INTO susa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","نَشَن يٌ سٌمَ نَ بَنشِ كُي عَ بَلَن شَنبِ، نَ كَنيِ قَن قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","نَشَن نَ عَ سَ نَ بَنشِ كُي، شَ نَ مُ عَ رَ عَ عَ دّفٍ نَا، نَ لَنمَ عَ شَ عَ شَ دُفِيٍ شَ.» ");
INSERT INTO susa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«نَ بَنشِ يَءِلَن شَنبِ، شَ سّرّشّدُبّ سَ فبِلٍن نَ بَنشِ كُي، عَ قَ عَ تٌ قُرٍ مُ لَنتَنشِ عَ عِ، عَ شَ مَسٍنيِ تِ، نَ بَنشِ بَرَ سّنِيّن، قُرٍ بَرَ حْن نَا. ");
INSERT INTO susa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","نَ بَنشِ كَنيِ شَ نَ مَرَ سّنِيّنيِ رَكَمَلِ سّرّشّ بَقٍ رَ. عَ شَ شْنِ قِرِن، سّدِرِ وُرِ، فّرّ مْولِ ندٍ، نُن هِسٌثِ وُرِ سْتْ. ");
INSERT INTO susa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","عَ شَ شْنِ كٍرٍن كْن نَشَبَ قّحّ ندٍ شُن مَ دُلٌن يٍ نَ نَشَن كُي. ");
INSERT INTO susa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","عَ شَ سّدِرِ وُرِ، هِسٌثِ وُرِ، فّرّ مْولِ ندٍ، نُن شْنِ حِحّ سِن شْنِ كْن نَشَبَ وُلِ شْورَ، نَشَن نَ دُلٌن يٍ كُي. عَ شَ عَ كَسَن بَنشِ مَ سَنمَيَ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","عَ شَ بَنشِ رَ سّنِيّن شْنِ وُلِ، دُلٌن يٍ، شْنِ حِحّ، سّدِرِ وُرِ، هِسٌثِ وُرِ، نُن فّرّ مْولِ ندٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","عَ شَ شْنِ حِحّ بّحِن تَا قَرِ مَ وُلَ عِ. نَ كُي، نَ بَنشِ شَ قٍ حَاشِ حْنمَ نّ، عَ سّنِيّن.» ");
INSERT INTO susa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","«سّرِيّ نَن نَ كِ قُرٍ حَاشِيٍ شَ قٍ رَ نَشٍيٍ مِنِمَ مِشِ قَتٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","دُفِيٍ مَ، بَنشِيٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","نَشٍيٍ قُنتُمَ، نَشٍيٍ بُلَمَ، نَشٍيٍ قِيشّمَ، ");
INSERT INTO susa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","عَلَكٌ عَ شَ كٌلٌن شَ سٍ سّنِيّنشِ نَن عَ رَ، شَ نَ مُ عَ رَ عَ مُ سّنِيّنشِ. سّرِيّ نَن نَ كِ نَ قُرٍ حَاشِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«وٌ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، كْرْ سِلَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","كْرْ سِلَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ هَلِ كْرْ سِلَ مُ نَ مِنِقٍ سِندٍن، كْنْ عَ نَ عَ قَتٍ كُي. ");
INSERT INTO susa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","كْرْ سِلَ كَنيِ سَمَ سَدٍ نَشَن مَ، سٍ سّنِيّنتَرٍ نَ عَ رَ. عَ دْشْ فٌنيِ نَشَن يٌ مَ، نَ قَن سٍ سّنِيّنتَرٍ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","نَشَن نَ دِن عَ شَ سَدٍ رَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","نَشَن دْشْمَ عَ شَ فٌنيِ مَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","نَشَن يٌ دِن نَ قُرٍ مَ قَتٍ رَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","شَ قُرٍ مَ دّ يٍ بْشُن مِشِ سّنِيّنشِ ندٍ مَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","دْشْسٍ نَشَن سَمَ سٌي مَ، شَ نَ مُ عَ رَ حْشْمّ مَ، شَ قُرٍ مَ دْشْ نَ قَرِ، نَ دْشْسٍ قِندِ مَ سٍ سّنِيّنتَرٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","نَشَن نَ دِن سٍسٍ رَ قُرٍ مَ بَرَ دْشْ نَشَن قَرِ، نَ كَنيِ بَرَ قِندِ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ. ");
INSERT INTO susa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","قُرٍ مَ بّلّشّ سّنِيّنتَرٍ كَنيِ دِنمَ مِشِ نَشَن نَ، نَ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","قُرٍ مَ دِنمَ قّحّ نَشَن نَ، نَ شَ كَنَ. شَ يِرَبَسٍ وُرِ دَاشِ نَ عَ رَ، عَ لَن عَ شَ مَشَ يٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«كْرْ سِلَ كَنيِ نَ يَلَن، عَ مَمّ تِمَ نّ لْشُن كٍرٍن بٍينُ عَ شَ قِندِ مِشِ سّنِيّنشِ رَ. عَ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ مَشَ دُلٌنيِ يٍ رَ. عَ سّنِيّنمَ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","شِ سٌلٌمَسَشَن ندٍ لْشْي، عَ شَ فَنبّ قِرِن تٌنفٌ، شَ نَ مُ عَ رَ كٌلٌكٌندٍ يْرّ قِرِن، عَ سَ عٍ سٌ سّرّشّدُبّ يِ رَ ﭑ تَن عَلَتَلَ يَ عِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","سّرّشّدُبّ شَ شْنِ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ سّرّشّ فَن دَاشِ. نَ كُي، كْرْ سِلَ كَنيِ بَرَ عَ شُن سَرَ ﭑ تَن عَلَتَلَ يَ عِ.» ");
INSERT INTO susa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«شَ شّمّ ندٍ عَ شَ وَنتَنيِ نْشْ، عَ شَ عَ قَتٍ بِرِن مَشَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","دُفِ نُن كِرِ نَشَن بِرِن نْشْ، عٍ شَ مَشَ يٍ رَ، عٍ قَن قِندِ مَ نّ سٍ سّنِيّنتَرٍ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","شَ شّمّ نُن فِنّ كَقُ عٍ بٌورٍ رَ، عٍ شَ عٍ قَتٍ مَشَ. عٍ قِندِ مَ مِشِ سّنِيّنتَرٍيٍ نَن نَ هَن نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«فِنّ نَشَن نَ عَ شَ كِكٍ وَلِ كُي، عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ لْشُن كٍرٍن بُن مَ. نَشَن نَ دِن عَ رَ، عَ قَن قِندِ مَ مِشِ سّنِيّنتَرٍ رَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","فِنّ نَشَن نَ عَ شَ كِكٍ وَلِ كُي، عَ سَمَ سَدٍ نَشَن مَ، سٍ سّنِيّنتَرٍ نَ عَ رَ. عَ دْشْ سٍسٍ نَشَن مَ، نَ قَن سٍ سّنِيّنتَرٍ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","نَشَن يٌ نَ دِن عَ شَ سَدٍ رَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","نَشَن يٌ نَ دْشْ عَ شَ فٌنيِ مَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ يّتّ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","شَ سٍ ندٍ سَشِ نَ سَدٍ مَ، شَ نَ مُ عَ رَ نَ فٌنيِ مَ عَ نُ دْشْشِ نَشَن مَ، نَشَن دِنمَ نَ سٍ رَ عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","شَ شّمّ ندٍ نُن نَ فِنّ كَقُ، عَ شَ كِكٍ وَلِ وُلِ قَ سَ عَ قَتٍ مَ، عَ قَن قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ لْشْشُن كٍرٍن بُن مَ. عَ نَ سَ سَدٍ يٌ مَ، نَ قَن قِندِ مَ سٍ سّنِيّنتَرٍ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«شَ وُلِ لُ مِنِ رَ فِنّ مَ، نَشَن مُ قِندِشِ عَ شَ كِكٍ وَلِ وُلِ رَ، شَ نَ مُ عَ رَ عَ شَ كِكٍ وَلِ تّمُي شْن نَشَ كُيَ، عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ عَلْ فِنّ نَشَن نَ عَ شَ كِكٍ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","عَ نَ عَ سَ سَدٍ نَشَن مَ، شَ نَ مُ عَ رَ عَ دْشْ فٌنيِ نَشَن مَ، نَ بِرِن قِندِ مَ نّ سٍ سّنِيّنتَرٍ رَ عَلْ عَ شَ كِكٍ وَلِ تّمُي. ");
INSERT INTO susa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","نَشَن دِنمَ نَ سٍيٍ رَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ قَتٍ مَشَ يٍ رَ. عَ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«وُلِ نَ بَ مِنِقٍ، نَ فِنّ شَ مَمّ تِ لْشْشُن كٍرٍن، عَ قَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","شِ سٌلٌقٍرٍ ندٍ لْشْي، عَ شَ فَنبّ قِرِن، شَ نَ مُ عَ رَ كٌلٌكٌندٍ يْرّ قِرِن تٌنفٌ، عَ شَ عٍ شَنِن سّرّشّدُبّ شْن هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","سّرّشّدُبّ شَ شْنِ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ سّرّشّ فَن دَاشِ. سّرّشّدُبّ شُنسَرٍ سّرّشّ بَمَ نَ فِنّ بّ ﭑ تَن عَلَتَلَ يَ عِ نَ كِ نّ.» ");
INSERT INTO susa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«وٌ شَ عِسِرَيِلَكَيٍ مَكُيَ سّنِيّنتَرٍحَ رَ، شَ نَ مُ عَ رَ، عٍ نَ عٍ مَكْرّ ﭑ مَ هْرْ مْلِنفِرَ رَ نَشَن نَ وٌ تَفِ، عٍ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","«سّرِيّ نَن نَ كِ كْرْ سِلَ شَ قٍ رَ، عَ نُن شّمّ نَشَن عَ شَ وَنتَنيِ نْشْمَ، ");
INSERT INTO susa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","فِنّ نَشَن نَ كِكٍ وَلِ كُي، كْرْ سِلَ نَشَن مِنِمَ شّمّ نُن فِنّ قَتٍ عِ، نُن شّمّ نَشَن نُن فِنّ سّنِيّنتَرٍ كَقُمَ.» ");
INSERT INTO susa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","هَرُنَ شَ دِ قِرِنيِ تٌ قَشَ عٍ يّتّ مَسٍنقٍ رَ عَلَتَلَ بّ، عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«عَ قَلَ عِ تَارَ هَرُنَ بّ، عَ نَ سٌ هْرْ مْلِنفِرَ كُي، عَ نَشَ لُ دَنفِ رَ دُفِ فبَكُشِ رَ شَ عَ دَنفِ تّمُي مُ عَ لِشِ، عَلَكٌ عَ نَشَ قَشَ. يِرٍ سّنِيّنشِ نَ عَ رَ سَاتّ كَنكِرَ نَ دّننَشّ. شُنسَرَدٍ نَ نَ سَاتّ كَنكِرَ نَن قَرِ، ﭑ مِنِمَ نُشُي كُي دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«هَرُنَ شَ سٌ هْرْ مْلِنفِرَ كُي تُورَ رَ، نَشَن بَمَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ نُن يّشّي كٌنتٌنيِ سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","عَ شَ فُبَ سّنِيّنشِ فّسّ قُتٍ دَاشِ رَفٌرٌ عَ مَ، عَ شَ وَنتَنيِ فّسّ قُتٍ دَاشِ سٌ. عَ شَ عَ تَفِ عِشِرِ بّلّتِ فّسّ قُتٍ دَاشِ رَ، عَ شَ شُنمَسٍ دْشْ عَ شُنيِ مَ. عَ نَ فّ عَ مَشَدٍ، عَ شَ نَ دُفِ سّنِيّنشِ بِرِن نَفٌرٌ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","عِسِرَيِلَ حَمَ شَ سِكْتّ قِرِن سٌ عَ يِ رَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ نُن يّشّي كٌنتٌنيِ كٍرٍن سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","هَرُنَ شَ تُورَ بَ عَ يّتّ شَ يُنُبِ شَقَرِ سّرّشّ رَ عَلَكٌ عَ تَن نُن عَ شَ دٍنبَيَ شُن شَ سَرَ. ");
INSERT INTO susa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","عَ شَ نَ سِكْتّ قِرِنيِ تِ ﭑ تَن عَلَتَلَ يَ عِ، هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","عَ شَ ﭑ تَن عَلَ مَشَندِ عَ شَ تْنشُمَ مَسٍن ﭑ بّ نَ سِكْتّ قِرِنيِ شَ قٍ رَ. كٍرٍن شَ قِندِ ﭑ تَن عَلَتَلَ فبٍ رَ، بٌورٍ شَ لُ سٍنتَنّ بّ وُلَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","سِكْتّ نَشَن سُفَندِشِ ﭑ تَن عَلَتَلَ فبٍ رَ، هَرُنَ شَ عَ بَ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","سِكْتّ نَشَن سُفَندِشِ عَ شَ قِندِ سٍنتَنّ فبٍ رَ، نَ مُ قَشَمَ. هَرُنَ شَ عَ تِ ﭑ تَن عَلَتَلَ يَ عِ، عَ شَ قِندِ شُنسَرٍ رَ، عَ شَ عَ بّحِن سِفَقٍ رَ وُلَ عِ سٍنتَنّ بّ. ");
INSERT INTO susa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","هَرُنَ شَ تُورَ بَ عَ يّتّ شَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ شَ قِندِ عَ تَن نُن عَ شَ دٍنبَيَ شُنسَرٍ رَ. عَ شَ نَ تُورَ كْن نَشَبَ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","عَ شَ سُرَيِ فَنسٍ رَقٍ تّ وٌلٍ رَ نَشَن تٌنفٌشِ سّرّشّبَدٍ قَرِ ﭑ تَن عَلَتَلَ يَ عِ. عَ شَ سُرَيِ قُحِ بّلّشّ يَ قِرِن قَن تٌنفٌ. عَ شَ نَ بِرِن شَنِن دُفِ فبَكُشِ شَنبِ رَ يِرٍ سّنِيّنشِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","عَ شَ نَ سُرَيِ فَن ﭑ تَن عَلَتَلَ يَ عِ، عَلَكٌ تُورِ نَشَن تٍمَ نَ شَ سَاتّ كَنكِرَ نْشُن عَ مَ عَلَكٌ عَ نَشَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","عَ شَ تُورَ وُلِ ندٍ تٌنفٌ عَ بّلّشّسٌلٍ رَ، عَ شَ عَ كَسَن سَاتّ كَنكِرَ مَكٌتٌ سٍ مَ شُنسَرَدٍ سٌفٍتٍدٍ بِرِ سَنمَيَ سٌلٌقٍرٍ، عَ مَن شَ عَ كَسَن نَ مَكٌتٌ سٍ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","عَ شَ سِكْتّ كْن نَشَبَ حَمَ شَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ قَ عَ وُلِ شَنِن دُفِ فبَكُشِ شَنبِ رَ. عَ شَ نَ وُلِ كَسَن سَاتّ كَنكِرَ مَكٌتٌ سٍ مَ نُن سَاتّ كَنكِرَ مَكٌتٌ سٍ يَ رَ، عَلْ عَ رَبَشِ تُورَ وُلِ رَ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","«نَ كِ عَ شُنسَرٍ سْتْمَ يِرٍ سّنِيّنشِ بّ عِسِرَيِلَكَيٍ شَ سّنِيّنتَرٍحَ، عٍ شَ قٍ كٌبِيٍ، نُن عٍ شَ يُنُبِيٍ شَ قٍ رَ. عَ شَ عَ رَبَ نَ كِ هْرْ مْلِنفِرَ قَن بّ، نَشَن تِشِ عِسِرَيِلَكَ سّنِيّنتَرٍيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","مِشِ يٌ نَشَ لُ هْرْ مْلِنفِرَ كُي هَن هَرُنَ مِنِمَ يِرٍ سّنِيّنشِ قِسَمَنتٍ كُي تّمُي نَشّ. عَ شَ عَ تَن نُن عَ شَ دٍنبَيَ شُن سَرَ، عَ نُن عِسِرَيِلَ حَمَ بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","عَ شَ سِفَ سّرّشّبَدٍ يِرٍ نَشَن نَ ﭑ تَن عَلَتَلَ يَ عِ، عَ قَ شُنسَرٍ بَ نَ سّرّشّبَدٍ بّ. عَ شَ تُورَ نُن سِكْتّ وُلِ سَ قٍرِيٍ مَ نَشٍيٍ نُ نَ سّرّشّبَدٍ تُنشُنيِ نَانِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","عَ شَ وُلِ كَسَن عَ بّلّشّسٌلٍ رَ سَنيَ سٌلٌقٍرٍ سّرّشّبَدٍ مَ، عَلَكٌ عَ شَ سّنِيّن عِسِرَيِلَكَيٍ شَ سّنِيّنتَرٍحَ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«هَرُنَ نَ فّ شُنسَرٍ بَدٍ يِرٍ سّنِيّنشِ، هْرْ مْلِنفِرَ، نُن سّرّشّبَدٍ بّ، عَ شَ سِكْتّ بٌورٍ مَسٌ نَشَن مُ نُ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","عَ شَ عَ بّلّشّ قِرِنيِيٍ سَ نَ سِكْتّ شُن تَفِ، عَ قَ عِسِرَيِلَكَيٍ شَ سّنِيّنتَرٍحَ، عٍ شَ قٍ كٌبِيٍ، نُن عٍ شَ يُنُبِ بِرِن مَسٍن ﭑ تَن عَلَ بّ. عَ نَ فّ نَ كٌتٍ بِرِن سَدٍ سِكْتّ شُن، عَ شَ نَ سِكْتّ بّحِن وُلَ عِ مِشِ ندٍ سَابُي رَ نَشَن بَرَ تِن نَ وَلِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","نَ سِكْتّ يُنُبِ بِرِن شَنِنمَ عَ شُن مَ وُلَ عِ، عَ بّحِن دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«نَ دَنفِ شَنبِ، هَرُنَ شَ سٌ هْرْ مْلِنفِرَ كُي، عَ شَ عَ شَ دُفِ فّسّ قُتٍ دَاشِيٍ بَ، عَ نَشٍيٍ رَفٌرٌشِ عَ مَ بٍينُ عَ شَ سٌ يِرٍ سّنِيّنشِ كُي. عَ شَ نٍيٍ لُ نَ. ");
INSERT INTO susa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","عَ شَ عَ مَشَ يٍ رَ يِرٍ سّنِيّنشِ كُي، عَ دُفِ فبّتّيٍ رَفٌرٌ عَ مَ. عَ نَ فّ، عَ شَ مِنِ، عَ سّرّشّ فَن دَاشِ قِرِن بَ، كٍرٍن عَ يّتّ بّ، بٌورٍ حَمَ بّ. عَ شُنسَرٍ سْتْمَ عَ يّتّ بّ نُن حَمَ بّ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","عَ مَن شَ يُنُبِ شَقَرِ سّرّشّ تُرٍ فَن سّرّشّبَدٍ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«نَشَن سِكْتّ بّحِن وُلَ عِ سٍنتَنّ بّ، نَ لَن عَ شَ عَ شَ دُفِيٍ شَ، عَ عَ قَتٍ مَشَ، عَ قَ فبِلٍن حَمَ يٌنكِندٍ. ");
INSERT INTO susa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","تُورَ نُن سِكْتّ نَشٍيٍ بَشِ يُنُبِ شَقَرِ سّرّشّ رَ، نَشٍيٍ وُلِ قِندِ شُنسَرٍ رَ يِرٍ سّنِيّنشِ، نٍيٍ لَن عٍ شَ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، عٍ كِرِ، عٍ سُبٍ، نُن عٍ حَحّ بِرِن شَ فَن تّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","نَشَن نَ وَلِ رَبَمَ، عَ شَ عَ شَ دُفِيٍ شَ، عَ شَ عَ قَتٍ مَشَ يٍ رَ، عَ قَ فبِلٍن حَمَ يٌنكِندٍ.» ");
INSERT INTO susa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«سّرِيّ نَن نَ كِ وٌ بّ نَشَن مُ كَنَمَ عَبَدَن. كِكٍ سٌلٌقٍرٍ ندٍ، شِ قُ لْشْي، وٌ شَ سُنيِ سُشُ، وٌ نَشَ وَلِ يٌ رَبَ، وٌ تَن، نُن مِشِ نَشٍيٍ سَبَتِشِ نَا كْنْ عٍ مُ قِندِ عِسِرَيِلَكَيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","نَ قِندِ مَ شُنسَرٍ لْشْي رَ وٌ بّ، عَلَكٌ وٌ شَ سّنِيّن، وٌ شَ يُنُبِ بِرِن شَ شَقَرِ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","نَ قِندِ مَ مَلَبُي نُن سَلِ لْشْي رَ وٌ بّ. وٌ شَ سُنيِ سُشُ نَ لْشْي. يِ سّرِيّ مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«عَلَ نَشَن سُفَندِشِ، عَ نَشَن تِشِ سّرّشّدُبّ كُنتِفِ رَ، نَ نَن وٌ شُن سَرَ مَ. عَ لُمَ عَ بَبَ شَ وَلِ رَبَ رَ. عَ لُمَ سّرّشّدُبّ دُفِ سّنِيّنشِيٍ رَفٌرٌ رَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","عَ لُمَ يِرٍ سّنِيّنشِ، هْرْ مْلِنفِرَ، سّرّشّبَدٍ، سّرّشّدُبّيٍ نُن عِسِرَيِلَ حَمَ بِرِن شُن سَرَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","يِ سّرِيّ مُ كَنَمَ عَبَدَن، عَلَكٌ حّ بِرِن شُنسَرٍ شَ بَ عِسِرَيِلَكَيٍ بّ عٍ شَ يُنُبِ بِرِن مَ قٍ رَ.» عٍ عَلَتَلَ شَ يَامَرِ بِرِن سُشُ عَلْ عَ مَسٍنشِ عَننَبِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«عَ قَلَ هَرُنَ بّ نُن عَ شَ دِيٍ بّ، عَ نُن عِسِرَيِلَكَ بِرِن بّ، عَلَتَلَ يِ نَن يَمَرِشِ. ");
INSERT INTO susa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","عِسِرَيِلَكَ نَشَن نِنفٍ، شَ نَ مُ عَ رَ يّشّي، شَ نَ مُ عَ رَ سِ بَمَ سّرّشّ رَ حَمَ يٌنكِندٍ كُي، شَ نَ مُ عَ رَ حَمَ يٌنكِندٍ قَرِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","عَ مُ عَ شَنِنمَ هْرْ مْلِنفِرَ سٌدٍ دّ شَ رَ عَلَكٌ عَ شَ عَ قِ ﭑ تَن عَلَتَلَ مَ هْرْ مْلِنفِرَ يِرٍ، نَ كَنيِ لُمَ نّ عَلْ قَشّتِ. عَ بَرَ قَشّ تِ، عَ لَنمَ نَ كَنيِ شَ كٍرِ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","يِ يَامَرِ وَ مَ عَ مَسٍنقٍ نّ عَ عِسِرَيِلَكَيٍ مُ لَنمَ عٍ شَ سّرّشّ بَ بُرُنيِ. عٍ شَ قَ شَنُنتٍيَ سّرّشّ رَ سّرّشّدُبّ نَن شْن ﭑ تَن عَلَتَلَ يَ عِ ﭑ مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","سّرّشّدُبّ شَ نَ وُلِ كَسَن ﭑ تَن عَلَتَلَ شَ سّرّشّبَدٍ سّيتِيٍ مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عَ مَن شَ نَ تُرٍ فَن تّ عِ، عَ شَ قِندِ شِرِ قَنيِ رَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","عِسِرَيِلَكَيٍ نَشَ سِكْتّ سّرّشّ بَ كُيٍ بّ سْنْن دٍ. نَ قِندِ مَ يَنقَنتٍيَ نَن نَ ﭑ تَن عَلَتَلَ مَبِرِ. يِ يَامَرِ مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«عَ قَلَ عٍ بّ، عِسِرَيِلَكَ، شَ نَ مُ عَ رَ شْحّ نَشَن سَبَتِشِ عٍ تَفِ، شَ عَ سّرّشّ فَن دَاشِ، شَ نَ مُ عَ رَ سّرّشّ فبّتّ بَ، ");
INSERT INTO susa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","عَ مُ عَ شَنِن هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عَلَكٌ عَ شَ قِ ﭑ تَن عَلَتَلَ مَ، نَ كَنيِ كٍرِ مَ نّ عَ شَ حَمَ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«شَ عِسِرَيِلَكَ ندٍ، شَ نَ مُ عَ رَ شْحّ ندٍ نَشَن سَبَتِشِ عِسِرَيِلَ بْشِ مَ عَ نَشَ وُلِ مِن، ﭑ فبِلٍنمَ نّ نَ كَنيِ قْشْ رَ، ﭑ قَ عَ كٍرِ عَ شَ حَمَ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","بَرِ مَ سُبٍ نِي بَرَ لُ عَ وُلِ يَ مَ. ﭑ بَرَ وُلِ قِندِ وٌ شُنسَرٍ رَ، نَشَن بَمَ سّرّشّ رَ سّرّشّبَدٍ قَرِ. وُلِ نَن نَ شُنسَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","نَ نَ عَ رَ، ﭑ بَرَ عِسِرَيِلَكَيٍ يَمَرِ عٍ نَشَ وُلِ مِن. وٌ شَ شْحّ نَشٍيٍ سَبَتِشِ عِسِرَيِلَ بْشِ مَ، عٍ قَن نَشَ وُلِ مِن دٍ. ");
INSERT INTO susa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","شَ عِسِرَيِلَكَ، شَ نَ مُ عَ رَ شْحّ ندٍ نَشَن نَ وٌ تَفِ، سَ سُبٍ ندٍ، شَ نَ مُ عَ رَ شْنِ ندٍ قَشَ نَشَن دَشَ عَ شَ دٌن، عَ شَ نَ وُلِ عِقِلِ بْشِ مَ، عَ بّندّ سَ عَ قَرِ، ");
INSERT INTO susa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","بَرِ مَ سُبٍ نِي نَ عَ وُلِ نَن يَ مَ. نَ نَ عَ رَ، ﭑ بَرَ عِسِرَيِلَكَيٍ يَمَرِ وٌ نَشَ سُبٍ وُلِ يٌ مِن، بَرِ مَ سُبٍ نِي نَ عَ وُلِ نَن يَ مَ. نَشَن يٌ نَ رَبَ، عَ قَمَ كٍرِدٍ عِسِرَيِلَ حَمَ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«شَ عِسِرَيِلَكَ، شَ نَ مُ عَ رَ شْحّ ندٍ نَشَن نَ وٌ تَفِ، نَ سُبٍ دٌن نَشَن قَشَشِ عَ يّتّ مَ، شَ نَ مُ عَ رَ سُبٍ فبّتّ نَشَن قَشَشِ كِ فبّتّ رَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ يٍ رَ، عَ مَن شَ عَ يّتّ مَشَ. عَ مُ سّنِيّنمَ هَن نُنمَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","شَ عَ مُ عَ شَ دُفِيٍ شَ، شَ عَ مُ عَ يّتّ مَشَ، نَ سّنِيّنتَرٍحَ لُمَ نّ عَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ. ");
INSERT INTO susa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","وٌ نَشَ مِسِرَكَيٍ شَ نَامُنيِيٍ رَبَ، وٌ نُ نَ دّننَشّ. وٌ مَن نَشَ كَنَانكَيٍ قَن مَ نَامُنيِيٍ رَبَ، ﭑ وٌ شَنِنمَ دّننَشّ. وٌ نَشَ بِرَ عٍ شَ سّرِيّ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","وٌ شَ ﭑ تَن نَن مَ سّرِيّ نُن ﭑ مَ يَامَرِيٍ رَبَتُ، بَرِ مَ عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ. ");
INSERT INTO susa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","وٌ شَ بِرَ ﭑ مَ سّرِيّ نُن ﭑ مَ يَامَرِيٍ نَن قْشْ رَ. مِشِ نَشَن نٍيٍ رَبَتُمَ، عَ سِمَيَ سْتْمَ نٍيٍ نَن سَابُي رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«وٌ نَشَ كَقُ وٌ نُن وٌ بَرِ مَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«وٌ نَشَ كَقُ وٌ نُن وٌ نفَ، نَشَن قِندِشِ وٌ بَبَ شَ فِنّ رَ. وٌ نفَ نَن وٌ نفَ رَ، وٌ نَشَ كَقُ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«وٌ نَشَ كَقُ وٌ نُن وٌ نَندٍن، نَشَن قِندِشِ وٌ بَبَ شَ فِنّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«وٌ نَشَ كَقُ وٌ نُن وٌ مَافِنّ، نَشَن قِندِشِ وٌ بَبَ شَ نَ مُ عَ رَ وٌ نفَ شَ دِ رَ، نَشَن بَرِشِ وٌ شْنيِ شَ نَ مُ عَ رَ يِرٍ فبّتّ.» ");
INSERT INTO susa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«وٌ نَشَ كَقُ وٌ نُن وٌ شَ دِ شّمّ شَ دِ فِنّ، وٌ نَشَ كَقُ وٌ نُن وٌ شَ دِ فِنّ شَ دِ فِنّ. عٍ قَتَنشِ وٌ يّتّ قَتٍ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«وٌ نَشَ كَقُ وٌ نُن وٌ بَبَ شَ فِنّ فبّتّ شَ دِ فِنّ، وٌ بَبَ نَشَن بَرِشِ. وٌ مَافِنّ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«وٌ نَشَ كَقُ وٌ نُن وٌ بَبَ مَافِنّ رَ. وٌ بَبَ بَرِبٌورٍ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«وٌ نَشَ كَقُ وٌ نُن وٌ نفَ شُنيَ، شَ نَ مُ عَ رَ عَ تَارَ. وٌ نفَ بَرِبٌورٍ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«وٌ نَشَ كَقُ وٌ نُن وٌ بَبَ شُنيَ شَ فِنّ، شَ نَ مُ عَ رَ عَ تَارَ شَ فِنّ. وٌ بَبَ شُنيَ شَ نَ مُ عَ رَ عَ تَارَ نَن فبٍ قِندِشِ نَ فِنّيٍ رَ. وٌ نفَ نُن وٌ مَمَ نَن لَنشِ عٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«وٌ نَشَ كَقُ وٌ نُن وٌ شَ دِ شَ فِنّ، وٌ شَ دِ نَن شَ فِنّ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«وٌ نَشَ كَقُ وٌ نُن وٌ شُنيَ، شَ نَ مُ عَ رَ وٌ تَارَ شَ فِنّ.» ");
INSERT INTO susa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«شَ وٌ نُن فِنّ ندٍ بَرَ كَقُ، وٌ نُن عَ شَ دِ فِنّ تَن نَشَ كَقُ دٍ. وٌ نُن عَ شَ دِ شّمّ شَ دِ فِنّ نَشَ كَقُ دٍ، وٌ نُن عَ شَ دِ فِنّ شَ دِ فِنّ نَشَ كَقُ دٍ. بَرِبٌورٍ مَيٍ نَ عٍ رَ، نَ قٍ مْولِ مُ قَن.» ");
INSERT INTO susa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«وٌ نُن وٌ شَ فِنّ شُنيَ نَشَ كَقُ دٍ، شَ نَ مُ عَ رَ عَ تَارَ، وٌ شَ فِنّ شَ سِمَيَ كُي. نَ قٍ قَمَ نّ تْونّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«وٌ نُن فِنّ نَشَ كَقُ عَ شَ كِكٍ وَلِ كُي دٍ، بَرِ مَ عَ مُ سّنِيّنشِ نَ تّمُي.» ");
INSERT INTO susa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«سَدٍ قٍ نَشَ لُ وٌ نُن وٌ مَلَنبٌورٍ شَ فِنّ تَفِ دٍ، نَ قِندِ مَ سّنِيّنتَرٍحَ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«وٌ نَشَ وٌ شَ دِ يٌ بَ سّرّشّ رَ مْلْكْ كُيٍ بّ. وٌ نَشَ وٌ مَرِفِ عَلَ شِلِ بّشُ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«شّمّ نَشَ كَقُ نُن شّمّ رَ. قٍ حَاشِ نَ عَ رَ. شّمّ لَنمَ عٍ نُن فِنّ نَن شَ كَقُ.» ");
INSERT INTO susa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«شّمّ نَشَ كَقُ نُن سُبٍ رَ. فِنّ قَن نَشَ كَقُ نُن سُبٍ رَ. نَ قٍ مْولِ مُ قَن قٍوٌ.» ");
INSERT INTO susa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«وٌ نَشَ وٌ مَنْشْ يِ قٍ مْولِيٍ رَ، عَلْ نَ سِيٍ عَ رَبَشِ كِ نَشّ ﭑ نَشٍيٍ كٍرِ وٌ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","عٍ شَ قٍ حَاشِيٍ بَرَ بْشِ يَتِ مَنْشْ. ﭑ عٍ رَتْنشِ نَ نَن مَ، عٍ مُ لُمَ يِ بْشِ مَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","وٌ تَن عِسِرَيِلَكَيٍ نُن شْحّ نَشٍيٍ نَ وٌ تَفِ، وٌ شَ ﭑ مَ سّرِيّ نُن ﭑ مَ يَامَرِيٍ رَبَتُ. وٌ نَشَ يِ قٍ شْنشِيٍ رَبَ دٍ. ");
INSERT INTO susa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","بٍكَيٍ نُ بَرَ نَ مْولِ رَبَ بٍينُ وٌ شَ قَ. يِ بْشِ قِندِ يِرٍ سّنِيّنتَرٍ رَ نَ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","شَ وٌ قَن بِرَ نَ مْولِ قْشْ رَ، وٌ قَن كٍرِ مَ نّ يِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","مِشِ يٌ نَشَن نَ مْولِ رَبَمَ، عَ كٍلِمَ نّ عَ شَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","وٌ شَ ﭑ مَ يَامَرِيٍ رَبَتُ، وٌ نَشَ نَ قٍ شْنشِيٍ رَبَ عَلْ مِشِ نَشٍيٍ نُ نَ بٍ بٍينُ وٌ شَ قَ. وٌ نَشَ قِندِ مِشِ سّنِيّنتَرٍيٍ رَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، وٌ شَ سّنِيّن، بَرِ مَ ﭑ تَن سّنِيّن، وٌ مَرِفِ عَلَتَلَ. ");
INSERT INTO susa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","بِرِن شَ عٍ نفَ نُن عٍ بَبَ بِنيَ. بِرِن شَ مَلَبُي لْشْي سّرِيّ رَبَتُ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«وٌ نَشَ كُيٍيٍ بَتُ، وٌ نَشَ وُرٍ رَشُنُ كُيٍ يَءِلَنقٍ رَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«وٌ شَ شَنُنتٍيَ سّرّشّ بَ ﭑ تَن عَلَتَلَ بّ عَ رَبَ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","سّرّشّ سُبٍ شَ دٌن عَ قَشَ لْشْي، شَ نَ مُ عَ رَ نَ كُيٍ عِبَ. سُبٍ نَ شِ سَشَن تِ، نَ شَ سَ تّ عِ. ");
INSERT INTO susa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","نَشَن لُمَ هَن شِ سَشَن، عَ رَهَرَ مُشِ، عَ مُ لَن نَ مْولِ شَ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","نَشَن نَ رَبَمَ، عَ نَ سَرٍ سْتْمَ نّ، بَرِ مَ عَ بَرَ ﭑ تَن عَلَتَلَ شَ سٍ سّنِيّنشِ يٍلٍبُ. نَ كَنيِ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«وٌ نَ شّ شَبَ وٌ شْنيِ، وٌ نَشَ عَ تُشُييٍ شَبَ. بَلٌي نَشَن بِرَ مَ بْشِ مَ، وٌ شَ نَ لُ نَا. ");
INSERT INTO susa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","وٌ نَ وّنِ بٌفِ بَ وٌ شَ سَنسِيٍ كْن نَ، وٌ نَشَ فبِلٍن عَ مَ عَ قِرِن ندٍ. بٌفِ نَشٍيٍ قَن يٌلٌنمَ عٍ يّتّ مَ، وٌ شَ نٍيٍ قَن لُ نَ سٍتَرٍيٍ بّ، عَ نُن مِشِيٍ بّ نَشٍيٍ كٍلِشِ حَمَنّ فبّتّيٍ مَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«وٌ نَشَ مُحّ تِ. وٌ نَشَ وُلٍ قَلَ. وٌ نَشَ وٌ بٌورٍ يَنقَ. ");
INSERT INTO susa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","وٌ نَشَ وٌ كَلِ ﭑ شِلِ رَ وُلٍ قَرِ، بَرِ مَ نَ كُي وٌ وٌ مَرِفِ عَلَ شِلِ نَن كَنَمَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«وٌ نَشَ وٌ نفَشَكٍرٍنيِ تْورْ، وٌ نَشَ عَ مُحَ. وٌ نَشَ وٌ شَ وَلِكّ شَ وَلِ سَرٍ لُ هَن تِنَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«وٌ نَشَ تُلِشْرِ كٌنبِ، وٌ نَشَ دْنشُي رَبِرَ. وٌ شَ فَاشُ ﭑ تَن عَلَ يَ رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«وٌ نَشَ كِيتِ سَ تِنشِنتَرٍيَ رَ. وٌ نَشَ سٍتَرٍ رَقِسَ عَ بٌورٍ بّ، وٌ نَشَ بَننَ رَقِسَ عَ بٌورٍ بّ. وٌ شَ كِيتِ بِرِن سَ تِنشِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","وٌ نَشَ وٌ بٌورٍ مَقَلَ. وٌ نَشَ وٌ بٌورٍ تْوحّفّ عَلَكٌ عَ شَ قَشَ. عَلَتَلَ نَن ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","وٌ نَشَ وٌ نفَشَكٍرٍنيِ شْن. وٌ شَ وٌ بٌورٍ رَ سِ، عَلَكٌ وٌ نَشَ يُنُبِ سْتْ عَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","وٌ نَشَ وٌ فبٍحْشْ. وٌ نَشَ فبّسّنشْننّيَ رَفَتَ وٌ سٌندٌنيِ كُي وٌ نفَشَكٍرٍنيِ بّ. وٌ شَ وٌ بٌورٍ شَنُ عَلْ وٌ وٌ يّتّ شَنُمَ كِ نَشّ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«وٌ شَ ﭑ مَ يَامَرِيٍ رَبَتُ. وٌ نَشَ شُرُ سٍ مْولِ قِرِن رَتٍ عٍ بٌورٍ مَ. وٌ نَشَ سَنسِ مْولِ قِرِن سِ شّ كٍرٍن مَ. وٌ نَشَ دُفِ رَفٌرٌ وٌ مَ نَشَن دّفّشِ فّسّ مْولِ قِرِن نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«شَ شّمّ ندٍ نُن كٌنيِ فِنّ ندٍ كَقُ شّمّ فبّتّ نَشَن شَ كٌتٍ دْشْشِ، نَشَن شُن مُ سَرَشِ سِندٍن، نَشَن مُ شْرّيَشِ، عٍ شَ حَشَنكَتَ. كْنْ وٌ نَشَ عٍ قَشَ، بَرِ مَ كٌنيِ فِنّ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","نَ شّمّ شَ يّشّي كٌنتٌنيِ بَ يّتّ رَفبِلٍن سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","سّرّشّدُبّ شَ نَ يّشّي كٌنتٌنيِ قِندِ شُنسَرٍ رَ عَ بّ ﭑ تَن عَلَتَلَ يَ عِ، عَ شَ قِندِ يّتّ رَفبِلٍن سّرّشّ رَ عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«وٌ نَ سٌ بْشِ كُي ﭑ نَشَن قِمَ وٌ مَ، وٌ نَشَ وٌ شَ سَنسِ سِشِيٍ بٌفِيٍ دٌن سِندٍن هَن حّ سَشَن. عٍ مُ سّنِيّن، عٍ لُشِ عَلْ سُننّتَرٍ. وٌ نَشَ عٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","نَشٍيٍ قَن بٌفِمَ حّ نَانِ ندٍ مَ، نَ بِرِن قِمَ ﭑ تَن عَلَتَلَ نَن مَ، عَ شَ قِندِ ﭑ مَ مَتْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","نَشٍيٍ بٌفِمَ حّ سُولِ ندٍ مَ، نَ تَن بِرِن قِندِ مَ وٌ بَلٌي نَن نَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«وٌ نَشَ سُبٍ يٌ دٌن وٌ مُ نَشَن كْن نَشَبَشِ، عَ وُلِ شَ مِنِ. وٌ نَشَ سٍمَتٌي وَلِ رَبَ، وٌ نَشَ دُورٍيَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","وٌ نَشَ وٌ شُنسّشّ مَشَبَ وٌ شُنيِ سّيتِيٍ مَ عَ رَدِفِلِنشِ رَ، وٌ نَشَ وٌ دّ شَبٍ سّيتِيٍ مَشَبَ، ");
INSERT INTO susa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","وٌ نَشَ وٌ قَتٍ مَشَبَ حْنيِ تٌ سٌشِ وٌ مَ. وٌ نَشَ ثِرِنتِ تِ وٌ قَتٍ مَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«وٌ نَشَ وٌ شَ دِ فِنّ مَتِ لَنفٌي رَ، عَلَكٌ وٌ شَ بْشِ نَشَ بِرَ لَنفٌيحَ قْشْ رَ، عَ شَ رَقٍ قٍ حَاشِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","وٌ شَ ﭑ مَ مَلَبُي لْشْييٍ بِنيَ، عَ نُن ﭑ مَ يِرٍ سّنِيّنشِ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«وٌ نَشَ مِشِ قٍن نَشَن مِشِ قَشَشِيٍ رَوْيّنمَ. وٌ نَشَ بِرَ سٍمَتٌييٍ قْشْ رَ، شَ نَ مُ عَ رَ وٌ قِندِ مَ سّنِيّنتَرٍيٍ نَن نَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«وٌ شَ مِشِ مْشِيٍ بِنيَ، نَشٍيٍ شُنسّشّ بَرَ قِيشّ. وٌ شَ فَاشُ وٌ مَرِفِ عَلَ يَ رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«وٌ نَشَ مِشِ رَوَلِ عَ حَاشِ رَ، نَشٍيٍ كٍلِشِ حَمَنّ فبّتّ عٍ شَ سَبَتِ وٌ شَ بْشِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","وٌ شَ نَ شْحّ مْولِ رَ سّنّ عَلْ وٌ نفَشَكٍرٍنيِ. وٌ شَ عَ شَنُ عَلْ وٌ وٌ يّتّ شَنُمَ كِ نَشّ. وٌ قَن نُ نَ شْحّيَ نَن كُي مِسِرَ بْشِ مَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«وٌ نَشَ تِنشِنتَرٍيَ يٌ رَبَ، كِيتِ سَدٍ، سٍ كُيّيَ مَنِيَدٍ، سٍ بِنيّ مَنِيَدٍ، سٍ رَقٍ دَاشِ مَنِيَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","وٌ شَ سِكٍيلِ شَ كَمَلِ. وٌ سٍ مَنِيَسٍ كَمَلِشِيٍ رَوَلِ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ، نَشَن وٌ رَ مِنِشِ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","وٌ شَ ﭑ مَ سّرِيّ نُن ﭑ مَ يَامَرِ بِرِن نَبَتُ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، شَ عِسِرَيِلَكَ ندٍ، شَ نَ مُ عَ رَ شْحّ ندٍ نَشَن سَبَتِشِ عِسِرَيِلَ بْشِ مَ، عَ شَ دِ ندٍ بَ سّرّشّ رَ مْلْكْ كُيٍ بّ، حَمَ شَ نَ كَنيِ مَفْنْ فّمّيٍ رَ هَن عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ﭑ تَن قَن فبِلٍنمَ نّ نَ مِشِ قْشْ رَ، ﭑ عَ رَ مِنِ حَمَ يَ مَ، بَرِ مَ عَ بَرَ ﭑ مَ يِرٍ سّنِيّنشِ يٍلٍبُ، عَ بَرَ ﭑ شِلِ سّنِيّنشِ كَنَ نَ سّرّشّ مْولِ رَ مْلْكْ كُيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","شَ حَمَ عَ يَ رَشِ نَ قٍ مَ، عٍ تٌندِ مِشِ قَشَدٍ، نَشَن عَ شَ دِ بَشِ سّرّشّ رَ مْلْكْ بّ، ");
INSERT INTO susa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ﭑ تَن فبِلٍنمَ نّ نَ مِشِ نُن عَ شَبِلّ قْشْ رَ، ﭑ نٍيٍ كٍرِ عٍ شَ حَمَ يَ مَ، عَ نُن مِشِ بِرِن نَشٍيٍ ﭑ يَنقَمَ مْلْكْ كُيٍ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«شَ مِشِ ندٍ ﭑ يَنقَ، عَ بِرَ سٍمَتٌي قْشْ رَ، عَ نُن مِشِ نَشَن مِشِ قَشَشِيٍ رَوْيّنمَ، ﭑ فبِلٍنمَ نَ كَنيِ قْشْ رَ، ﭑ عَ كٍرِ عَ شَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","وٌ شَ وٌ حّرّ سّنِيّنيِ كُي، عَلَكٌ وٌ شَ سّنِيّن، بَرِ مَ عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ. ");
INSERT INTO susa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","وٌ شَ ﭑ مَ يَامَرِيٍ رَبَتُ، وٌ شَ عٍ رَتِنمّ. عَلَتَلَ نَن ﭑ نَ، نَشَن وٌ رَ سّنِيّنمَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«نَشَن يٌ عَ بَبَ دَنكَ، شَ نَ مُ عَ رَ عَ نفَ، وٌ شَ نَ كَنيِ قَشَ. عَ تَن نَن عَ قَشَ قٍ رَفِرِشِ، بَرِ مَ عَ بَرَ عَ بَبَ دَنكَ، شَ نَ مُ عَ رَ عَ نفَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«شَ شّمّ ندٍ يّنّ رَبَ عَ مَلَن بٌورٍ شَ فِنّ رَ، نَ شّمّ نُن نَ فِنّ شَ قَشَ عٍ شَ لَنفٌيحَ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«شَ شّمّ ندٍ كَقُ نُن عَ بَبَ شَ فِنّ رَ، عَ بَرَ قٍ حَاشِ رَبَ عَ بَبَ رَ. وٌ شَ نَ شّمّ نُن نَ فِنّ قَشَ عٍ شَ يُنُبِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«شَ شّمّ ندٍ كَقُ نُن عَ شَ دِ شَ فِنّ رَ، وٌ شَ عٍ قِرِنيِ بِرِن قَشَ نَ يُنُبِ شَ قٍ رَ، بَرِ مَ نَ قٍ مْولِ مُ قَن قٍوٌ.» ");
INSERT INTO susa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«شَ شّمّ ندٍ كَقُ نُن شّمّ فبّتّ رَ عَلْ شّمّ دَرِشِ عَ رَبَ رَ فِنّ رَ كِ نَشّ، وٌ شَ عٍ قِرِنيِ بِرِن قَشَ نَ قٍ شْنشِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«شَ شّمّ ندٍ كَقُ نُن فِنّ رَ نُن نَ شَ دِ فِنّ رَ، عٍ بَرَ قٍ حَاشِ رَبَ. وٌ شَ عٍ فَن تّ رَ، شّمّ نُن فِنّ، عَلَكٌ نَ قٍ شْنشِ مْولِ نَشَ لُ وٌ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«شَ شّمّ ندٍ كَقُ نُن سُبٍ رَ، وٌ شَ نَ شّمّ نُن نَ سُبٍ بِرِن قَشَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«شَ فِنّ ندٍ عَ مَسٌ سُبٍ رَ كَقُ بٌورٍحَ رَ، وٌ شَ نَ فِنّ نُن نَ سُبٍ قَشَ نَ قٍ حَاشِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«شَ شّمّ ندٍ كَقُ نُن عَ مَافِنّ رَ، عَ بَبَ شَ دِ فِنّ، شَ نَ مُ عَ رَ عَ نفَ شَ دِ فِنّ، قٍ مَيَافِشِ نَن عَ رَ. وٌ شَ عٍ كٍرِ عٍ شَ حَمَ يَ مَ، بَرِ مَ شّمّ بَرَ كَقُ نُن عَ مَافِنّ رَ. نَ كٌتٍ شَ لُ عَ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«شَ شّمّ ندٍ كَقُ نُن فِنّ رَ نَشَن نَ عَ شَ كِكٍ وَلِ كُي، عَ وُلِ نَشَ مِنِ كّنّ مَ. عٍ قِرِنيِ بِرِن شَ كٍرِ حَمَ يَ مَ نَ قٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«وٌ نَشَ كَقُ نُن وٌ نفَ شُنيَ، شَ نَ مُ عَ رَ وٌ نفَ تَارَ رَ، شَ نَ مُ عَ رَ وٌ بَبَ مَافِنّ رَ، بَرِ مَ وٌ بَرِبٌورٍ نَن عٍ رَ. نَشَن نَ مْولِ رَبَمَ نَ كٌتٍ شَ لُ عَ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«شَ شّمّ ندٍ كَقُ نُن عَ بَبَ شُنيَ شَ فِنّ رَ، شَ نَ مُ عَ رَ عَ بَبَ تَارَ شَ فِنّ رَ، عٍ نَ كٌتٍ شَنِنمَ نّ. عٍ بِرِن قَمَ قَشَدٍ دِبَرِتَرٍحَ نَن كُي.» ");
INSERT INTO susa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«شَ شّمّ ندٍ كَقُ نُن عَ شُنيَ شَ فِنّ رَ، شَ نَ مُ عَ رَ عَ كَقُ نُن عَ تَارَ شَ فِنّ رَ، عَ بَرَ قٍ سّنِيّنتَرٍ رَبَ. عٍ بِرِن قَمَ قَشَدٍ دِبَرِتَرٍحَ نَن كُي.» ");
INSERT INTO susa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«وٌ شَ ﭑ مَ سّرِيّ نُن ﭑ مَ يَامَرِ بِرِن نَبَتُ، وٌ شَ نَ بِرِن نَبَ، عَلَكٌ وٌ مُ قَمَ كٍرِدٍ كِ نَشّ بْشِ مَ ﭑ وٌ رَ سَبَتِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","وٌ نَشَ بِرَ نَ بْشِ سِيٍ شَ سّرِيّ قْشْ رَ، ﭑ قَمَ نَشٍيٍ كٍرِدٍ وٌ يَ رَ. عٍ نَشَن نَبَمَ نَ مُ رَقَنشِ ﭑ مَ قٍوٌ. ");
INSERT INTO susa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ﭑ بَرَ عَ قَلَ وٌ بّ نَ بْشِ قِندِ مَ وٌ فبٍ رَ. ﭑ بَرَ نَ بْشِ قِ وٌ مَ، شِحّ نُن كُمِ فبٍفبٍ نَ دّننَشّ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ، نَشَن وٌ سُفَندِشِ سِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","وٌ شَ سُبٍ رَهَرَ مُشِيٍ نُن سُبٍ رَدَشَشِيٍ تَفِ رَ سَ، عٍ نُن شْنِ رَهَرَ مُشِيٍ نُن شْنِ رَدَشَشِيٍ، عَلَكٌ وٌ نَشَ قِندِ سّنِيّنتَرٍيٍ رَ عٍ سَابُي رَ. ﭑ بَرَ تْنيِ دْشْ نَ سُبٍيٍ، نَ شْنِيٍ، نُن نَ بْشِمَسٍيٍ رَ. عٍ مُ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","وٌ شَ قِندِ ﭑ مَ حَمَ سّنِيّنشِ رَ، بَرِ مَ ﭑ تَن عَلَتَلَ نَن سّنِيّن. ﭑ بَرَ وٌ سُفَندِ سِيٍ تَفِ، عَلَكٌ وٌ شَ قِندِ ﭑ فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«مِشِ يٌ نَشَن مِشِ قَشَشِيٍ رَوْيّنمَ، شَ نَ مُ عَ رَ عَ قِندِ سٍمَتٌي رَ، وٌ شَ عَ مَفْنْ فّمّيٍ رَ هَن عَ شَ قَشَ. عَ تَن نَن عَ قَشَ قٍ رَفِرِشِ.» ");
INSERT INTO susa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، «عَ قَلَ هَرُنَ شَ دِ سّرّشّدُبّيٍ بّ، سّرّشّدُبّ نَشَ عَ يّتّ قِندِ سّنِيّنتَرٍ رَ عَ شَ مِشِ ندٍ قُرٍ سَابُي رَ، ");
INSERT INTO susa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","قٌ عَ شَ مِشِ كّندّ ندٍ عَلْ عَ نفَ، عَ بَبَ، عَ شَ دِ شّمّ، عَ شَ دِ فِنّ، عَ شُنيَ شّمّمَ، عَ تَارَ شّمّمَ، ");
INSERT INTO susa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","نُن عَ مَافِنّ، فِنّدِ مّدِ نَ نَشَن نَ، عَ مُ دْشْشِ شّمّ تَا سِندٍن، عَ نَ عَ شْنيِ. سّرّشّدُبّ نَ دِن عٍ قُرٍ رَ، عَ قِندِ مَ نّ مِشِ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","عَ مُ لَنمَ سّرّشّدُبّ شَ قِندِ سّنِيّنتَرٍ رَ عَ شَ فِنّ قُرٍ شَ قٍ رَ، شَ نَ مُ عَ رَ عَ شَ فِنّ شَ مِشِيٍ قُرٍ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«شَ حْنقٍ بَرَ عَ لِ، عَ مُ لَنمَ سّرّشّدُبّ شَ عَ شُنيِ بِ، شَ نَ مُ عَ رَ عَ دّ شَبٍيٍ سّيتِ مَشَبَ، شَ نَ مُ عَ رَ عَ قَتٍ مَشَبَ. ");
INSERT INTO susa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","عٍ شَ سّنِيّن عٍ مَرِفِ عَلَ بّ. عٍ نَشَ عٍ مَرِفِ عَلَ شِلِ كَنَ، بَرِ مَ عٍ تَن نَن سّرّشّ فَن دَاشِيٍ بَمَ ﭑ تَن عَلَتَلَ بّ، نَشٍيٍ لُشِ عَلْ ﭑ مَ دٌنسٍ. عٍ لَن عٍ شَ سّنِيّن نَ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","عَ مُ لَنمَ سّرّشّدُبّ شَ لَنفٌي فِنّ دْشْ، شَ نَ مُ عَ رَ فِنّ قُتِ كَنّ، شَ نَ مُ عَ رَ فِنّ شّمّ مّيشِ نَشَن نَ. سّرّشّدُبّ تَن سّنِيّن عَ مَرِفِ عَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","وٌ شَ عَ كٌلٌن مِشِ سّنِيّنشِ رَ، بَرِ مَ عَ تَن نَن سّرّشّيٍ قِمَ عَلَ مَ نَشٍيٍ لُشِ عَلْ دٌنسٍ. وٌ شَ عَ كٌلٌن عَ سّنِيّن، بَرِ مَ ﭑ تَن عَلَتَلَ سّنِيّن، ﭑ تَن نَشَن وٌ رَ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","شَ سّرّشّدُبّ شَ دِ فِنّ ندٍ عَ يّتّ رَيَافِمَ قِندِقٍ رَ لَنفٌي رَ، عَ بَرَ عَ بَبَ رَيَافِ. عَ لَنمَ نَ فِنّ شَ فَن تّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«سّرّشّدُبّ كُنتِفِ نَشَن سُفَندِشِ عَ نفَشَكٍرٍنيِيٍ تَفِ، عٍ تُرٍ سّنِيّنشِ سَ عَ مَ، عٍ دُفِ سّنِيّنشِ رَفٌرٌ عَ مَ، نَ نَشَ عَ شُنسّشّ كَنَ، عَ نَشَ عَ شَ دُفِ عِبْو. ");
INSERT INTO susa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","عَ نَشَ سٌ قُرٍ شُن مَ، عَ نَشَ قِندِ سّنِيّنتَرٍ رَ قُرٍ شَ قٍ رَ، هَلِ عَ بَبَ شَ نَ مُ عَ رَ عَ نفَ. ");
INSERT INTO susa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","عَ نَشَ مِنِ يِرٍ سّنِيّنشِ كُي، عَ نَشَ عَ مَرِفِ عَلَ شَ هْرْ مْلِنفِرَ مَنْشْ، بَرِ مَ ﭑ تَن عَلَ نَن عَ سُفَندِشِ، تُرٍ سّنِيّنشِ سَشِ عَ شُنيِ مَ. عَلَتَلَ نَن ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","عَ شَ فِنّدِ مّدِ دْشْ فِنّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","عَ نَشَ كَاحّ فِنّ دْشْ، عَ نَشَ فِنّ رَبّحِنشِ دْشْ، عَ نَشَ لَنفٌي دْشْ، عَ نَشَ فِنّ دْشْ فِنّدِ مّدِ مُ نَشَن نَ. عَ شَ فِنّدِ مّدِ تٌنفٌ فِنّ رَ عَ شَ مِشِيٍ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","عَلَكٌ عَ نَشَ عَ بْنسْي رَيَافِ. عَلَتَلَ نَن ﭑ نَ نَشَن عَ رَ سّنِيّنمَ.» ");
INSERT INTO susa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«عَ قَلَ هَرُنَ بّ، مِشِ مَبّنشِ يٌ نَشَ سّرّشّدُبّ وَلِ رَبَ، عَ سّرّشّ سَ سّرّشّبَدٍ مَ ﭑ تَن عَلَ بّ. نَ مُ لَنمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","مَبّنيِيٍ نَن يَ نَشٍيٍ مُ دَشَ عٍ شَ عٍ مَسٌ سّرّشّبَدٍ رَ؛ نَشَن يَ مُ قَن، نَشَن مُ نْمَ حّرّدٍ عَ قَنيِ رَ، نَشَن سَلٌنسٍ ندٍ كَنَشِ، ");
INSERT INTO susa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","نَشَن بّلّشّ، شَ نَ مُ عَ رَ سَنيِ فِرَشِ، ");
INSERT INTO susa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","نَشَن كُنتِنشِ، نَشَن شَ كُيّ مُ كَمَلِشِ، نَشَن يَ مُ قَنشِ، قَتٍ كِرِ قُرٍ نَ نَشَن مَ، نُن شّمّ بَنَشِ. ");
INSERT INTO susa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","مَبّنيِ يٌ قَتَن سّرّشّدُبّ هَرُنَ شَبِلّ رَ، عَ نَشَ عَ مَسٌ ﭑ تَن عَلَتَلَ شَ سّرّشّبَدٍ رَ سّرّشّ فَن دَاشِ بَقٍ رَ عَ مَرِفِ عَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","عَ نْمَ ﭑ تَن عَلَ شَ دٌنسٍ سّنِيّنشِ مْولِ بِرِن دٌندٍ، ");
INSERT INTO susa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","كْنْ عَ مُ لَن عَ شَ عَ مَسٌ يِرٍ سّنِيّنشِ قِسَمَنتٍ شَ دُفِ رَ، شَ نَ مُ عَ رَ سّرّشّبَدٍ رَ. عَ نَشَ ﭑ مَ يِرٍ سّنِيّنشِ شِلِ كَنَ، بَرِ مَ عَلَتَلَ نَن ﭑ نَ، نَشَن عَ رَ سّنِيّنمَ.» ");
INSERT INTO susa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","عَننَبِ مُنسَ نَشَ نَ مَسٍنيِ تِ هَرُنَ، عَ شَ دِيٍ، نُن عِسِرَيِلَكَ بِرِن بّ. ");
INSERT INTO susa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«عَ قَلَ هَرُنَ نُن عَ شَ دِيٍ بّ، عٍ شَ عِسِرَيِلَكَيٍ شَ سّرّشّ سّنِيّنشِيٍ بَ عَ بَ كِ مَ، بَرِ مَ عٍ نٍيٍ قِمَ ﭑ تَن نَن مَ. سّرّشّدُبّيٍ نَشَ ﭑ شِلِ سّنِيّنشِ كَنَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«عَ قَلَ عٍ بّ، شَ عٍ بْنسْي مِشِ ندٍ سَ قِندِ سّنِيّنتَرٍ رَ، عَ نَشَ عَ مَسٌ عِسِرَيِلَكَيٍ شَ سّرّشّ رَ عٍ نَشٍيٍ قِمَ ﭑ تَن عَلَتَلَ مَ، نَ كَنيِ كٍرِ مَ نّ ﭑ يَ عِ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«كُنّ قُرٍ نَ مِشِ يٌ مَ هَرُنَ بْنسْي يَ مَ، شَ نَ مُ عَ رَ كْرْ سِلَ قُرٍ، نَ مُ لَن عَ شَ سّرّشّ سّنِيّنشِ دٌن قٌ عَ شَ فّ سّنِيّندٍ. عَ مَن مُ لَن مِشِ شَ نَ رَبَ شَ عَ بَرَ دِن مِشِ ندٍ رَ نَشَن بَرَ دِن مِشِ قُرٍ رَ. شَ يٍ سّنِيّنتَرٍ نَ مِنِقٍ مِشِ شّمّيَ كُي، عَ مُ لَن عَ شَ سّرّشّ سّنِيّنشِ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","شَ مِشِ ندٍ بَرَ دِن بُبُسٍ رَ، شَ نَ مُ عَ رَ مِشِ سّنِيّنتَرٍ رَ، نَ مُ لَن عَ شَ سّرّشّ سّنِيّنشِ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","نَشَن نَ رَبَمَ، نَ كَنيِ قِندِ مَ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ. بٍينُ عَ شَ نَ سّرّشّ سّنِيّنشِ دٌن، عَ شَ عَ قَتٍ مَشَ. ");
INSERT INTO susa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","سٌفٍ نَ فٌرٌ، عَ بَرَ سّنِيّن، عَ نْمَ سّرّشّ سّنِيّنشِ دٌندٍ سْنْن، بَرِ مَ عَ بَلٌي نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","«سّرّشّدُبّ نَشَ سُبٍ دٌن نَشَن قَشَشِ عَ يّتّ مَ. عَ مَن نَشَ سُبٍ دٌن سُبٍ فبّتّ نَشَن قَشَشِ، عَلَكٌ عَ نَشَ قِندِ سّنِيّنتَرٍ رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«سّرّشّدُبّيٍ شَ ﭑ مَ يَامَرِيٍ رَبَتُ عٍ بَلٌي شَ قٍ رَ، عَلَكٌ عٍ نَشَ يُنُبِ سْتْ، عٍ قَ قَشَ. عَلَتَلَ نَن ﭑ نَ، نَشَن عٍ رَ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","مِشِ يٌ نَشَ سّرّشّ سّنِيّنشِ دٌن شَ سّرّشّدُبّ مُ عَ رَ. هَلِ سّرّشّدُبّ شَ شْحّ، شَ نَ مُ عَ رَ عَ شَ وَلِكّ مُ لَنمَ عَ شَ عَ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","كْنْ سّرّشّدُبّ شَ كٌنيِ، عَ نَشَن سَرَ كْبِرِ رَ، عَ نُن نَ كٌنيِ شَ دٍنبَيَ تَن نْمَ سّرّشّدُبّ بَلٌي دٌندٍ. ");
INSERT INTO susa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","سّرّشّدُبّ شَ دِ فِنّ نَشَن دْشْشِ شّمّ عَلَ كٌلٌنتَرٍ شْن مَ، نَشَ سّرّشّ سّنِيّنشِ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","سّرّشّدُبّ شَ دِ فِنّ نَشَن قِندِشِ كَاحّ فِنّ رَ، شَ نَ مُ عَ رَ شّمّ مّيشِ نَشَن نَ عٍ مُ دِ بَرِ، عَ فبِلٍن عَ بَبَ شْنيِ عَلْ عَ نُ نَ نَا كِ نَشّ عَ دِ مّدِ رَ، نَ فِنّ نْمَ عَ بَبَ بَلٌي دٌندٍ. مِشِ يٌ نَشَن مُ قِندِ عِسِرَيِلَكَ رَ، نَ مُ لَنمَ عَ شَ نَ مْولِ دٌن. ");
INSERT INTO susa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","شَ مِشِ ندٍ سَ سّرّشّ سّنِيّنشِ دٌن كٌلٌنتَرٍيَ مَ، عَ لَن عَ شَ عَ حْشْي قِ كْبِرِ رَ، عَ مَن شَ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ دٌنسٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ سٌ سّرّشّدُبّ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","سّرّشّدُبّيٍ نَشَ قٍ رَبَ ﭑ تَن عَلَتَلَ شَ سّرّشّ سّنِيّنشِيٍ رَ، عَ مُ لَن نَشَن شَ رَبَ ");
INSERT INTO susa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","عَلَكٌ عٍ نَشَ يُنُبِ سْتْ نَ سّرّشّيٍ شَ قٍ رَ عٍ نَشٍيٍ دٌنشِ. عَلَتَلَ نَن ﭑ نَ، نَشَن عٍ رَ سّنِيّنمَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«عَ قَلَ هَرُنَ، عَ شَ دِيٍ، نُن عِسِرَيِلَكَيٍ بِرِن بّ، عِسِرَيِلَكَيٍ بِرِن، عَ نُن شْحّ نَشٍيٍ سَبَتِشِ عِسِرَيِلَ بْشِ مَ، مِشِ نَشَن سّرّشّ فَن دَاشِ بَمَ ﭑ تَن عَلَتَلَ بّ لَايِدِ ندٍ رَكَمَلِقٍ رَ، شَ نَ مُ عَ رَ عَ يّتّ حَنِفٍ رَبَقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","عَ لَن عَ شَ تُورَ نَن بَ، شَ نَ مُ عَ رَ يّشّي كٌنتٌنيِ، شَ نَ مُ عَ رَ سِكْتّ، لَنيُرُ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","وٌ نَشَ شُرُ سٍ يٌ بَ لَنيُرُ نَ نَشَن مَ، بَرِ مَ ﭑ تَن عَلَ مُ نَ مْولِ رَ سُشُمَ. ");
INSERT INTO susa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","شَ مِشِ ندٍ وَ مَ شُرُ سٍ شُنفبٍ، شَ نَ مُ عَ رَ شُرُ سٍ لَنمَ بَقٍ شَنُنتٍيَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، لَايِدِ ندٍ رَكَمَلِقٍ رَ، شَ نَ مُ عَ رَ حَنِفٍ رَبَقٍ رَ، نَ شُرُ سٍ قَتٍ شَ قَن، لَنيُرُ يٌ نَشَ لُ عَ مَ، شَ نَ مُ عَ رَ ﭑ تَن عَلَ مُ عَ رَ سُشُمَ. ");
INSERT INTO susa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","وٌ نَشَ شُرُ سٍ يٌ بَ نَشَن يَ مُ قَن، نَشَن مَشْنْشِ، نَشَن مَبّنشِ، قُرٍ نَ نَشَن كِرِ مَ. وٌ نَشَ نَ مْولِ سَ ﭑ تَن عَلَتَلَ شَ سّرّشّبَدٍ قَرِ، عَ شَ قِندِ سّرّشّ فَن دَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","عِ نْمَ نِنفٍ، شَ نَ مُ عَ رَ يّشّي كّحَ حَاشِ بَدٍ حَنِفٍ سّرّشّ رَ، كْنْ عِ مُ نْمَ نَ بَدٍ لَايِدِ رَكَمَلِ سّرّشّ رَ دٍ. ");
INSERT INTO susa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","وٌ نَشَ شُرُ سٍ بَنَشِ، شّمّيَ كَنَشِ، شَ نَ مُ عَ رَ شّمّيَ مُ نَشَن بّ، بَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ. وٌ نَشَ نَ مْولِ بَ سّرّشّ رَ وٌ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","وٌ نَشَ نَ شُرُ سٍ مْولِ رَ سُشُ شْحّيٍ يِ رَ، وٌ شَ عٍ بَ سّرّشّ رَ وٌ مَرِفِ عَلَ بّ، بَرِ مَ عٍ قَتٍ مُ قَنشِ، عٍ مُ كَمَلِشِ. ﭑ تَن عَلَ مُ نٍيٍ رَ سُشُمَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«نِنفٍ يْرّ، يّشّي يْرّ، نُن سِ يْرّ نَ بَرِ، عٍ شَ لُ عٍ نفَ بُن مَ شِ سٌلٌقٍرٍ، بٍينُ عٍ شَ قِندِ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","وٌ نَشَ نِنفٍ، شَ نَ مُ عَ رَ يّشّي، نُن عَ شَ دِ كْن نَشَبَ لْشْي كٍرٍن كُي.» ");
INSERT INTO susa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«وٌ شَ تَنتُي سّرّشّ بَ ﭑ تَن عَلَتَلَ بّ عَ بَ كِ مَ عَلَكٌ ﭑ شَ عَ سُشُ. ");
INSERT INTO susa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","وٌ شَ نَ سّرّشّ دٌن نَ لْشْي يَتِ، عَ نَشَ لُ هَن فّيسّفّ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«وٌ شَ ﭑ مَ يَامَرِيٍ رَبَتُ، وٌ شَ عٍ سُشُ. عَلَتَلَ نَن ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","وٌ نَشَ ﭑ شِلِ سّنِيّنشِ كَنَ. عِسِرَيِلَكَيٍ بِرِن شَ عَ كٌلٌن ﭑ سّنِيّن. عَلَتَلَ نَن ﭑ نَ، نَشَن وٌ رَ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ﭑ تَن نَن وٌ رَ مِنِ مِسِرَ بْشِ رَ، ﭑ شَ قِندِ وٌ مَرِفِ عَلَ رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ﭑ تَن عَلَتَلَ شَ سَلِ لْشْييٍ نَن يَ، نَشٍيٍ سّنِيّنشِ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","وٌ شَ وَلِ شِ سٍننِ، كْنْ شِ سٌلٌقٍرٍ ندٍ قِندِشِ مَلَبُي لْشْي نَن نَ، مَلَنيِ سّنِيّنشِ رَبَمَ لْشْي نَشّ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. نَ قِندِشِ ﭑ تَن عَلَتَلَ نَن فبٍ رَ. وٌ شَ نَ سّرِيّ سُشُ وٌ سَبَتِدٍ بِرِن.» ");
INSERT INTO susa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«ﭑ تَن عَلَتَلَ شَ سَلِ لْشْي فبّتّيٍ نَن يَ، وٌ حَمَ مَشِلِمَ لْشْي نَشٍيٍ مَ؛ ");
INSERT INTO susa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","كِكٍ سِنفٍ، شِ قُ نُن نَانِ ندٍ، سٌفٍ دُلَ تّمُي، سَيَمَلٍكّ دَنفِ سَلِ سّرّشّ شَ بَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ﭑ تَن عَلَتَلَ شَ تَامِ لّبِنِتَرٍ سَلِ قْلْمَ نَ كِكٍ شِ قُ نُن سُولِ ندٍ لْشْي نّ. وٌ شَ تَامِ لّبِنِتَرٍيٍ دٌن نَ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","نَ سَلِ شِ سِنفٍ كُي، وٌ شَ مَلَنيِ سّنِيّنشِ رَبَ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","وٌ شَ سّرّشّيٍ فَن دَاشِيٍ بَ ﭑ تَن عَلَتَلَ بّ نَ شِ سٌلٌقٍرٍ بُن مَ. شِ سٌلٌقٍرٍ ندٍ لْشْي، وٌ مَن شَ مَلَنيِ سّنِيّنشِ رَبَ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي.» ");
INSERT INTO susa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، وٌ نَ سٌ بْشِ مَ ﭑ نَشَن قِمَ وٌ مَ، وٌ نَ شّ شَبَ، وٌ شَ عَ شِرِ سِنفٍ شَنِن سّرّشّدُبّ شْن. ");
INSERT INTO susa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","سّرّشّدُبّ شَ نَ مَسٍن ﭑ تَن عَلَتَلَ بّ مَلَبُي لْشْي دَنفِ شَنبِ، عَلَكٌ ﭑ شَ عَ سُشُ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","وٌ نَ شِرِ سِنفٍ مَسٍنمَ ﭑ تَن عَلَتَلَ بّ لْشْي نَشّ، وٌ مَن شَ يّشّي قَنيِ حّ كٍرٍن دَاشِ بَ سّرّشّ فَن دَاشِ رَ ﭑ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","عَ نُن سَنسِ شْرِ دِنشِ كٌنبٌ يَ كٍرٍن نَشَن مَسُنبُشِ تُرٍ رَ. نَ قِندِ مَ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ نَشَن شِرِ رَقَن ﭑ مَ. وٌ مَن شَ وّنِ لِتِرِ كٍرٍن بَ وّنِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","وٌ نَشَن سْتْ شّ شَبَ تّمُي، وٌ نَشَ سٍسٍ دٌن، تَامِ، تْنسْي فَنشِ، نُن سَنسِ شْرِ رَ، بٍينُ وٌ شَ نَ سّرّشّ بَ وٌ مَرِفِ عَلَ بّ. سّرِيّ نَن نَ كِ وٌ بْنسْي بّ وٌ سَبَتِدٍ بِرِن. نَ مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«قْلْ مَلَبُي لْشْي كُيٍ عِبَ مَ، وٌ نَ شِرِ سِنفٍ لِنتَنمَ عَلَتَلَ يَ عِ سّرّشّ رَ لْشْي نَشّ، لْشُن سٌلٌقٍرٍ شَ دَنفِ. ");
INSERT INTO susa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","عَ شِ تٌنفٌ سُولِ ندٍ، مَلَبُي لْشْي شِ سٌلٌقٍرٍ ندٍ كُيٍ عِبَ، وٌ مَن شَ سّرّشّ بَ ﭑ تَن عَلَتَلَ بّ دَشَمُي نّينّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","وٌ شَ قَ تَامِ قِرِن نَ وٌ نَشَن لِنتَنمَ ﭑ تَن عَلَتَلَ يَ عِ سّرّشّ رَ، كٍلِقٍ رَ وٌ شْنيِيٍ. وٌ شَ عٍ يَءِلَن سَنسِ شْرِ لُشُتَشِ كٌنبٌ يَ كٍرٍن نَ، وٌ لّبِنِ سُنبُ عَ رَ. بٌفِسٍ سِنفٍ سّرّشّ نَن نَ كِ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","وٌ مَن شَ يّشّي قَنيِ حّ كٍرٍن دَاشِ سٌلٌقٍرٍ سَ نَ تَامِ قَرِ، تُورَ لَنمَ كٍرٍن، نُن يّشّي كٌنتٌنيِ قِرِن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِيٍ رَ. وٌ مَن شَ سَنسِ شْرِ لُشُتَشِ نُن وّنِ سّرّشّ سَ نٍيٍ قَرِ. نٍيٍ فَن شِرِ نَقَن ﭑ تَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","وٌ مَن شَ سِكْتّ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ، عَ نُن يّشّي قِرِن حّ كٍرٍن دَاشِ، نَشٍيٍ قِندِ مَ شَنُنتٍيَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","سّرّشّدُبّ نَ بِرِن لِنتَنمَ ﭑ تَن عَلَتَلَ يَ عِ سّرّشّ رَ، نَ تَامِ سِنفٍيٍ، نُن نَ يّشّي قِرِنيِيٍ. عٍ بِرِن قِمَ ﭑ تَن عَلَتَلَ نَن مَ، عٍ قَ لُ سّرّشّدُبّ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","نَ لْشْي وٌ شَ مَلَنيِ سّنِيّنشِ رَبَ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. سّرِيّ نَ عَ رَ وٌ بْنسْي بّ يِرٍ بِرِن عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","وٌ نَ شّ شَبَ وٌ شْنيِ، وٌ نَشَ عَ تُشُييٍ شَبَ. بَلٌي نَشَن بِرَ مَ بْشِ مَ، وٌ شَ نَ لُ نَا سٍتَرٍيٍ بّ، عَ نُن مِشِيٍ بّ نَشٍيٍ كٍلِشِ حَمَنّ فبّتّيٍ مَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، كِكٍ سٌلٌقٍرٍ ندٍ، شِ سِنفٍ، وٌ شَ وٌ مَلَبُ نَ لْشْي، وٌ شَ حَمَ مَشِلِ سَرَ شُي رَ، وٌ مَلَنيِ سّنِيّنشِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي، وٌ شَ سّرّشّ فَن دَاشِيٍ بَ ﭑ تَن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«كِكٍ سٌلٌقٍرٍ ندٍ، شِ قُ ندٍ شَ قِندِ شُنسَرٍ لْشْي رَ. وٌ شَ مَلَنيِ سّنِيّنشِ رَبَ، وٌ شَ سُنيِ سُشُ، وٌ شَ سّرّشّ فَن دَاشِيٍ بَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي، بَرِ مَ شُنسَرٍ لْشْي نَ عَ رَ، وٌ شُن سَرَ مَ وٌ مَرِفِ عَلَتَلَ يَ عِ لْشْي نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","مِشِ نَشَن تٌندِ مَ سُنيِ سُشُدٍ نَ لْشْي، نَ كَنيِ رَ مِنِمَ نّ عَ شَ حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","مِشِ نَشَن وَلِ يٌ رَبَمَ نَ لْشْي، ﭑ عَ سْنتْمَ نّ عَ شَ حَمَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","وٌ نَشَ وَلِ يٌ رَبَ. سّرِيّ نَ عَ رَ وٌ بْنسْي بِرِن بّ يِرٍ بِرِن، نَشَن مُ كَنَمَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","نَ قِندِ مَ مَلَبُي لْشْي نَن نَ وٌ بّ. وٌ شَ سُنيِ سُشُ قْلْقٍ نَ كِكٍ شِ سٌلٌمَنَانِ لْشْي نُنمَرٍ رَ، هَن عَ شِ قُ لْشْي نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، كِكٍ سٌلٌقٍرٍ ندٍ شِ قُ نُن سُولِ ندٍ، بَفٍ تِ سَلِ قْلْمَ، عَ بُ شِ سٌلٌقٍرٍ ﭑ تَن عَلَتَلَ شَ بِنيّ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","سَلِ شِ سِنفٍ مَلَنيِ سّنِيّنشِ رَبَمَ نّ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","وٌ شَ سّرّشّ فَن دَاشِيٍ بَ ﭑ تَن عَلَتَلَ بّ شِ سٌلٌقٍرٍ بُن مَ. شِ سٌلٌمَسَشَن ندٍ وٌ شَ مَلَنيِ سّنِيّنشِ رَبَ. وٌ شَ سّرّشّ فَن دَاشِيٍ بَ ﭑ تَن عَلَتَلَ بّ. سَلِ شُنفبٍ نَ عَ رَ، وٌ نَشَ وَلِ يٌ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«ﭑ تَن عَلَتَلَ شَ سَلِ لْشْي شُنفبٍيٍ نَن نَ كِ وٌ بّ. وٌ شَ سّرّشّ فَن دَاشِيٍ، سَنسِ شْرِ سّرّشّيٍ، نُن وّنِ سّرّشّيٍ بَ عَ بَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","وٌ شَ ﭑ تَن عَلَتَلَ شَ مَلَبُي لْشْييٍ رَبَتُ، وٌ شَ شَنُنتٍيَ سّرّشّيٍ، وٌ شَ لَايِدِ سّرّشّيٍ، عَ نُن وٌ شَ حَنِفٍ سّرّشّيٍ وٌ نَشٍيٍ قِمَ ﭑ مَ، وٌ شَ عٍ رَكَمَلِ.» ");
INSERT INTO susa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«كِكٍ سٌلٌقٍرٍ ندٍ شِ قُ نُن سُولِ ندٍ، وٌ فّ شَنبِ وٌ شَ شّيٍ بٌفِسٍيٍ مَلَندٍ، وٌ شَ سَلِ رَبَ ﭑ تَن عَلَتَلَ بّ شِ سٌلٌقٍرٍ بُن مَ. سَلِ شِ سِنفٍ نُن عَ شِ سٌلٌمَسَشَن ندٍ قِندِشِ مَلَبُي لْشْييٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","سَلِ شِ سِنفٍ، وٌ شَ بٌفِسٍ قَنيِيٍ بَ سَنسِ بِلِيٍ كْن نَ، تُفِ قّنسّيٍ، نُن وُرِ تٌقَنيِ حِنفِيٍ. وٌ شَ سّيوَ وٌ مَرِفِ عَلَتَلَ يَ عِ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","وٌ شَ يِ سَلِ رَبَ عَلَتَلَ بّ حّ يٌ حّ شِ سٌلٌقٍرٍ بُن مَ. سّرِيّ نَ عَ رَ وٌ بْنسْي بِرِن بّ نَشَن مُ كَنَمَ عَبَدَن. وٌ شَ نَ سَلِ رَبَ كِكٍ سٌلٌقٍرٍ ندٍ كُي. ");
INSERT INTO susa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","وٌ شَ شِ بَفٍيٍ كُي نَ شِ سٌلٌقٍرٍ بُن مَ. عِسِرَيِلَكَيٍ بِرِن شَ شِ بَفٍيٍ كُي، ");
INSERT INTO susa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","عَلَكٌ وٌ بْنسْييٍ شَ عَ كٌلٌن عَ ﭑ عَ نِيَشِ نّ وٌ بٍنبَيٍ شَ شِ بَفٍيٍ كُي ﭑ عٍ رَ مِنِ مِسِرَ بْشِ رَ تّمُي نَشّ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","عَننَبِ مُنسَ شَ مَسٍنيِ نَن نَ كِ، عَ نَشَن مَسٍن عِسِرَيِلَكَيٍ بّ عَلَتَلَ شَ سَلِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«عِسِرَيِلَكَيٍ يَمَرِ، عٍ شَ قَ عٌلِوِ تُرٍ قَنيِ رَ عِ شْن، عَلَكٌ لَنثُييٍ شَ دّشّ تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","هَرُنَ شَ عَ حّنفِ سَ لَنثُييٍ شْن، نَشٍيٍ نَ هْرْ مْلِنفِرَ كُي، يِرٍ سّنِيّنشِ سّيتِ مَ. سَاتّ كَنكِرَ نَ نَ يِرٍ سّنِيّنشِ قِسَمَنتٍ نَن كُي، دُفِ فبَكُشِ عَ سٌدٍ دّ رَ. عَ شَ عَ نِيَ لَنثُييٍ شَ نُ دّشّ ﭑ تَن عَلَتَلَ يَ عِ تّمُي بِرِن، كٍلِقٍ نُنمَرٍ رَ هَن فّيسّفّ. سّرِيّ نَ عَ رَ وٌ بْنسْي بّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","هَرُنَ شَ عَ حّنفِ سَ لَنثُييٍ شْن نَشٍيٍ دْشْشِ لَنثُي دْشْ سٍ شّيمَ دَاشِيٍ قَرِ ﭑ تَن عَلَتَلَ يَ عِ.» ");
INSERT INTO susa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«وٌ شَ تَامِ قُ نُن قِرِن يَءِلَن سَنسِ شْرِ لُشُتَشِ قَنيِ رَ، تَامِ كٍرٍن، سَنسِ شْرِ دِنشِ كٌنبٌ يَ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","وٌ شَ عٍ سَ سَقّ قِرِن، سٍننِ نَ سّيتِ كٍرٍن، سٍننِ نَ سّيتِ بٌورٍ، تٍيبِلِ قَرِ ﭑ تَن عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","وٌ شَ سُرَيِ قَنيِ سَ تَامِ سَقّيٍ سّيتِ مَ، نَشَن قَمَ فَندٍ تَامِ حْشْي رَ ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","تَامِ شَ سَ تٍيبِلِ قَرِ مَلَبُي لْشْي بِرِن. سّرِيّ نَ عَ رَ عِسِرَيِلَكَيٍ بّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","هَرُنَ نُن عَ شَ دِيٍ شَ نَ تَامِيٍ دٌن يِرٍ سّنِيّنشِ، بَرِ مَ سّرّشّ سّنِيّنشِ نَ عَ رَ، نَشٍيٍ قِشِ عَلَتَلَ مَ عَ فَن دَاشِ رَ. سّرِيّ نَ عَ رَ نَشَن مُ كَنَمَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","لْشْي ندٍ مِشِ ندٍ نَشَ سٌ عِسِرَيِلَكَيٍ يَ مَ. عَ نفَ قِندِ عِسِرَيِلَكَ نَن نَ، كْنْ عَ بَبَ نَشَ قِندِ مِسِرَكَ رَ. فٍرٍ نَشَ بِرَ عَ عِ نَ مِشِ نُن عِسِرَيِلَكَ ندٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","نَ كُي، نَ عِسِرَيِلَ فِنّ شَ دِ نَشَ عَلَتَلَ شِلِ بّشُ، عَ عَ كٌنبِ. عٍ نَشَ عَ شَنِن عَننَبِ مُنسَ شْن نَ قٍ مَ. نَ مِشِ نفَ شِلِ نّ سٍلٌمِتِ، دِبِرِ شَ دِ فِنّ، دَنَ بْنسْي. ");
INSERT INTO susa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","عٍ نَشَ عَ سُشُ عَ قَنيِ رَ هَن عَلَتَلَ يَتِ نَشَ عَ شَ قٍ يَ عِبَ عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«حَمَ شَ يِ كٌنبِتِ شَنِن حَمَ يٌنكِندٍ قَرِ مَ. نَشٍيٍ نَ كٌنبِ مّشِ، نٍيٍ شَ عٍ بّلّشّيٍ سَ عَ شُنيِ، حَمَ بِرِن قَ عَ مَفْنْ فّمّ رَ هَن عَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","عِ شَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، مِشِ يٌ نَشَن ﭑ تَن عَلَ كٌنبِمَ، نَ يُنُبِ كٌتٍ لُمَ عَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","نَشَن نَ ﭑ تَن عَلَتَلَ شِلِ بّشُ، حَمَ بِرِن شَ عَ مَفْنْ فّمّ رَ هَن عَ شَ قَشَ. شَ عَ قِندِ شْحّ رَ، شَ عَ قِندِ بٍكَ رَ، عَ شَ قَشَ بَرِ مَ عَ بَرَ ﭑ تَن عَلَتَلَ بّشُ.» ");
INSERT INTO susa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«مِشِ نَشَن نَ عَدَ مَدِ قَشَ، عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","مِشِ نَشَن نَ مِشِ ندٍ شَ شُرُ سٍ قَشَ، عَ شَ عَ حْشْي سٌ عَ يِ. نِي حْشْي شَ قِ نِي رَ. ");
INSERT INTO susa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","مِشِ نَشَن نَ عَ بٌورٍ مَشْنْ، عَ قَن شَ مَشْنْ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","مَشْنّ حْشْي مَشْنّ نَن نَ. يَ حْشْي يَ نَن نَ، حِنيِ حْشْي نَ حِنيِ نَن نَ. عَ شَ مَشْنْ عَلْ عَ عَ رَبَشِ عَ بٌورٍ رَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","مِشِ نَشَن نَ مِشِ شَ شُرُ سٍ قَشَ، عَ شَ عَ حْشْي قِ، كْنْ مِشِ نَشَن نَ عَدَ مَدِ قَشَ، نَ كَنيِ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","سّرِيّ كٍرٍن نَ عَ رَ وٌ بِرِن بّ، شْحّيٍ نُن عِسِرَيِلَكَيٍ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","عَننَبِ مُنسَ تٌ فّ نَ مَسٍنيِ تِدٍ عِسِرَيِلَكَيٍ بّ، حَمَ نَشَ نَ كٌنبِتِ شَنِن حَمَ يٌنكِندٍ قَرِ مَ، عٍ عَ مَفْنْ فّمّ رَ هَن عَ قَشَ. نَ كُي عٍ نَشَ عَلَتَلَ شَ يَامَرِ سُشُ عَلْ عَننَبِ مُنسَ عَ مَسٍنشِ عٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ تُرُ سِنِنَ فٍيَ قَرِ، ");
INSERT INTO susa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، وٌ نَ سٌ بْشِ كُي ﭑ نَشَن قِمَ وٌ مَ، وٌ شَ عَ لُ بْشِ شَ مَلَبُ ﭑ تَن عَلَتَلَ شَ بِنيّ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","وٌ شَ شّ وَلِ سُشُ، وٌ شَ مّينِ وّنِ بِلِيٍ مَ، وٌ شَ عٍ بٌفِيٍ بَ. وٌ شَ نَ بِرِن نَبَ حّ سٍننِ بُن مَ، ");
INSERT INTO susa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","كْنْ حّ سٌلٌقٍرٍ ندٍ وٌ شَ عَ لُ بْشِ شَ عَ مَلَبُ ﭑ تَن عَلَتَلَ شَ بِنيّ بُن مَ. وٌ نَشَ شّ وَلِ رَبَ، وٌ نَشَ قٍقٍ رَبَ وّنِ بِلِيٍ رَ نَ حّ كُي. ");
INSERT INTO susa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","سَنسِ بٌفِ نَشٍيٍ بُلَمَ عٍ يّتّ مَ، وٌ نَشَ عٍ شَبَ. وّنِ بٌفِيٍ نَشٍيٍ بٌفِمَ عٍ يّتّ مَ، وٌ شَ عٍ لُ نَا بَرِ مَ مَلَبُي حّ نَ عَ رَ بْشِ بّ. ");
INSERT INTO susa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","بْشِ نَشَن نَمِنِمَ نَ مَلَبُي حّ كُي، وٌ بِرِن نْمَ نَ دٌندٍ، وٌ تَن، وٌ شَ كٌنيِيٍ، وٌ شَ وَلِكّيٍ، وٌ شَ شْحّيٍ، ");
INSERT INTO susa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","وٌ شَ شُرُ سٍيٍ، عَ نُن بُرُنيِ سُبٍ نَشٍيٍ نَ بْشِ كُي. بْشِ نَشَن نَمِنِ عَ يّتّ رَ نَ حّ رَ، نَ نَن قِندِ مَ وٌ بَلٌي رَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«وٌ شَ مَلَبُي حّ سٌلٌقٍرٍ كْنتِ، حّ تٌنفٌ نَانِ نُن سٌلٌمَنَانِ، حّ سٌلٌقٍرٍ دْشْ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","عَ كِكٍ سٌلٌقٍرٍ شِ قُ ندٍ، وٌ شَ سَرَيٍ قٍ حَمَ بّ بْشِ بِرِن كُي، عَ قِندِ مَ شُنسَرٍ لْشْي نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","نَ حّ تٌنفٌ سُولِ ندٍ شَ قِندِ شْرّيَ حّ رَ بْشِ مِشِ بِرِن بّ. كٌنيِ بِرِن شَ شْرّيَ سْتْ، كَنكَن شَ فبِلٍن عَ شْنيِ عَ شَبِلّ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","نَ حّ تٌنفٌ سُولِ ندٍ قِندِ مَ شْرّيَ حّ نَن نَ وٌ بّ. وٌ نَشَ سَنسِ شْرِيٍ سِ، وٌ نَشَ سَنسِ بٌفِيٍ نُن وّنِ بٌفِيٍ بَ نَشٍيٍ بُلَمَ عٍ يّتّ مَ، ");
INSERT INTO susa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","شْرّيَ حّ نَن نَ رَ، وَشَتِ سّنِيّنشِ نَ عَ رَ وٌ بّ. بْشِ دَشَمُي شَ قِندِ وٌ شَ بَلٌي رَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«نَ شْرّيَ حّ كُي، بِرِن شَ فبِلٍن عٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","شَ وٌ بْشِ مَتِمَ وٌ نفَشَكٍرٍنيِ مَ، شَ نَ مُ عَ رَ وٌ بَرَ ندٍ سَرَ وٌ نفَشَكٍرٍنيِ مَ، وٌ نَشَ وٌ بٌورٍ تْورْ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","وٌ شَ نَ سَرَ سَرٍ تِنشِنشِ رَ، نَشَن حّيٍ كْنتِمَ كٍلِقٍ شْرّيَ حّ وَشَتِ. وٌ نفَشَكٍرٍنيِ شَ نَ مَتِ وٌ مَ سّرِيّ كِ مَ. عَ شَ شّ شَبَ حّ كْنتِ نَشٍيٍ لُشِ بٍينُ شْرّيَ حّ شَ عَ لِ. ");
INSERT INTO susa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","شَ حّ وُيَشِ لُشِ، عَ سَرٍ شَ مَتٍ نَ كِ. شَ حّ وُيَشِ مُ لُشِ، عَ سَرٍ شَ مَفٌرٌ. وٌ شَ عَ مَتٌ شّ شَبَمَ سَنمَيَ يٍرِ بٍينُ شْرّيَ حّ شَ عَ لِ. ");
INSERT INTO susa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","وٌ نَشَ وٌ بٌورٍ تْورْ نَ كُي. وٌ شَ فَاشُ وٌ مَرِفِ عَلَ يَ رَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«وٌ شَ ﭑ مَ سّرِيّ سُشُ، وٌ شَ ﭑ مَ يَامَرِيٍ رَبَتُ، عَلَكٌ وٌ شَ لُ يِ بْشِ مَ بْحّسَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","بْشِ دَشَمُي قَمَ وٌ وَ سَدٍ، وٌ مَن سَبَتِمَ بْحّسَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","شَ وٌ سَ مَشْرِنيِ تِ يِ كِ، ‹شَ وٌن مُ سٍسٍ سِمَ حّ سٌلٌقٍرٍ ندٍ كُي، شَ وٌن مُ سَنسِ شَبَمَ نَ تّمُي، وٌن بَلٌمَ مُنسٍ رَ قَ؟› ");
INSERT INTO susa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ﭑ تَن نَن بَرَكَ رَفٌرٌ مَ وٌ مَ حّ سٍننِ ندٍ كُي، نَشَن قِندِ مَ بَلٌي رَ وٌ بّ حّ سَشَن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","وٌ شَ سَنسِ شْرِ سِ حّ سٌلٌمَسَشَن ندٍ كُي، كْنْ وٌ دٌنسٍ رَفَتَشِ نَن دٌنمَ هَن حّ سٌلٌمَنَانِ ندٍ. دٌنسٍ نَشَن نَفَتَشِ، نَ وٌ رَلِمَ نّ هَن بَلٌي نّينّ سَ مِنِمَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«وٌ نَشَ بْشِ مَتِ عَ شَ لُ وٌ بٌورٍ يِ رَ عَبَدَن، بَرِ مَ ﭑ تَن نَن فبٍ بْشِ رَ. وٌ لُشِ نّ عَلْ شْحّيٍ نَشٍيٍ يِفِيَشِ ﭑ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","سّرِيّ كِ مَ، وٌ شَ تِن يِ بْشِ بِرِن شُن شَ سَرَ. ");
INSERT INTO susa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","شَ وٌ نفَشَكٍرٍنيِ ندٍ عَ شَ بْشِ مَتِ عَ شَ سٍتَرٍحَ مَ، عَ بَرِبٌورٍ ندٍ شَ نَ بْشِ مَتِشِ شُن سَرَ. ");
INSERT INTO susa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","شَ عَ بَرِبٌورٍ مُ نَ نَشَن نْمَ نَ بْشِ شُن سَرَدٍ، كْنْ عَ تَن نَشَ سَ نَ شُنسَرٍ قّيرّ سْتْ عَ يّتّ رَ، ");
INSERT INTO susa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","عَ شَ بْشِ سَرٍ كْنتِ سّرِيّ كِ مَ، كٍلِقٍ عَ سَرَ تّمُي، عَ قَ نَ حْشْي رَفبِلٍن عَ سَرَ مِشِ مَ، عَلَكٌ عَ شَ فبِلٍن عَ شَ بْشِ مَسْتْ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","كْنْ شَ عَ مُ نَ شُنسَرٍ قّيرّ سْتْ، نَ بْشِ شَ لُ عَ سَرَ مِشِ يِ رَ هَن شْرّيَ حّ رَ. نَ تّمُي بْشِ كَنيِ مَن شَ فبِلٍن عَ شَ بْشِ مَسْتْ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«شَ مِشِ ندٍ سَ عَ شَ بَنشِ مَتِ نَشَن نَ تَا كُي تّتّ رَبِلِنشِ نَشَن نَ، عَ نْمَ نَ بَنشِ شُن سَرَدٍ حّ كٍرٍن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","شَ نَ بَنشِ شُن مُ سَرَ نَ حّ كُي، عَ لُمَ نّ عَ سَرَ مِشِ نُن عَ بْنسْي يِ رَ عَبَدَن. هَلِ شْرّيَ حّ كُي عَ سَرَ مِشِ مُ كٍلِمَ نَا. ");
INSERT INTO susa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","كْنْ بَنشِ نَشٍيٍ تِشِ تَا شُنشُرِيٍ كُي، نَشٍيٍ مُ رَبِلِنشِ تّتّ رَ، نٍيٍ لُمَ عَلْ بْشِ. عٍ نْمَ شُن سَرَدٍ. نَشَن نَ مْولِ سَرَ مَ، عَ لَنمَ عَ شَ مِنِ نَ بَنشِ شْرّيَ حّ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«لٍوِكَيٍ تَن نْمَ عٍ شَ بَنشِيٍ شُن سَرَدٍ عٍ شَ تَايٍ كُي تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","نَشَن بَرَ لٍوِكَ ندٍ شَ بَنشِ سَرَ، عَ مِنِمَ نّ نَ كُي شْرّيَ حّ تّمُي، بَرِ مَ بَنشِ نَشٍيٍ نَ لٍوِكَيٍ شَ تَايٍ كُي، نٍيٍ قِندِشِ لٍوِكَيٍ نَن فبٍ رَ عِسِرَيِلَ حَمَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","شّ نَشٍيٍ نَ لٍوِكَيٍ شَ تَايٍ رَبِلِنيِ، نٍيٍ مُ نْمَ مَتِدٍ، بَرِ مَ لٍوِكَيٍ نَن فبٍ عٍ رَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«شَ وٌ نفَشَكٍرٍنيِ ندٍ قِندِ سٍتَرٍ رَ، قّيرّ مُ نَ عَ يِ رَ عَ بَلٌمَ نَشَن نَ، عَ لَنمَ وٌ شَ عَ مَلِ عَلْ شْحّ، عَ شَ لُ وٌ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","وٌ نَشَ رِبَ سَ عَ شَ دٌنِ شُن مَ. وٌ شَ فَاشُ وٌ مَرِفِ عَلَ يَ رَ. وٌ شَ وٌ نفَشَكٍرٍنيِ يِفِيَ. ");
INSERT INTO susa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","وٌ نَشَ رِبَ سَ عَ شَ دٌنِ شُن مَ، وٌ نَشَ رِبَ سَ عَ شَ دٌنسٍ سَرٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ، نَشَن وٌ رَ مِنِشِ مِسِرَ بْشِ كُي، ﭑ شَ كَنَان بْشِ قِ وٌ مَ، ﭑ شَ قِندِ وٌ مَرِفِ عَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«شَ وٌ نفَشَكٍرٍنيِ ندٍ عَ يّتّ مَتِ وٌ مَ عَ شَ سٍتَرٍحَ مَ، وٌ نَشَ كٌنيِ وَلِ دْشْ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","عَ شَ لُ عَلْ وٌ شَ وَلِكّ، شَ نَ مُ عَ رَ وٌ شَ شْحّ هَن شْرّيَ حّ وَشَتِ. ");
INSERT INTO susa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","نَ تّمُي، عَ تَن نُن عَ شَ دِيٍ شَ شْرّيَ، عٍ شَ فبِلٍن عٍ شَبِلّ مَ، عٍ بٍنبَيٍ شَ بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","بَرِ مَ ﭑ مَ وَلِكّيٍ نَن عِسِرَيِلَكَيٍ رَ، ﭑ نَشٍيٍ رَ مِنِشِ مِسِرَ بْشِ رَ. عَ مُ لَنمَ عٍ شَ مَتِ كٌنيِيَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","وٌ نَشَ عٍ يَمَرِ عَ حَاشِ رَ، وٌ شَ فَاشُ وٌ مَرِفِ عَلَ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","شَ وٌ وَ مَ كٌنيِيٍ شْن، وٌ شَ عٍ سَرَ سِ فبّتّيٍ تَفِ، نَشٍيٍ نَ وٌ رَبِلِنيِ. عٍ تَن نَن شَ قِندِ وٌ شَ كٌنيِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","وٌ مَن نْمَ كٌنيِيٍ سَرَدٍ سِ فبّتّيٍ شَ مِشِيٍ يَ مَ نَشٍيٍ دْشْشِ وٌ تَفِ، عَ نُن عٍ شَبِلّيٍ مِشِ نَشٍيٍ بَرِشِ وٌ شَ بْشِ كُي. نٍيٍ نْمَ قِندِدٍ وٌ شَ كٌنيِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","وٌ نْمَ عٍ لُدٍ وٌ شَ دِيٍ يِ رَ كّ رَ. عٍ نْمَ لُدٍ كٌنيِيَ كُي عَبَدَن، كْنْ وٌ نفَشَكٍرٍنيِ عِسِرَيِلَكَيٍ مُ نْمَ لُدٍ عٍ نفَشَكٍرٍنيِ شَ يَامَرِ شْرْشْي بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«شَ وٌ نفَشَكٍرٍنيِ سٍتَرٍ ندٍ عَ يّتّ مَتِ شْحّ بَننَشِ مَ وٌ شَ بْشِ كُي، شَ نَ مُ عَ رَ نَ شْحّ شَبِلّ مِشِ ندٍ مَ، ");
INSERT INTO susa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","وٌ نفَشَكٍرٍنيِ بَرِبٌورٍ ندٍ نْمَ عَ شُن سَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","عَ سْشْ، شَ نَ مُ عَ رَ عَ سْشْ شَ دِ، شَ نَ مُ عَ رَ عَ بَرِبٌورٍ ندٍ فبّتّ، نْمَ عَ شُن سَرَدٍ. شَ عَ قَن قّيرّ سْتْ، عَ نْمَ عَ يّتّ شُن سَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","عَ شَ نَ شُنسَرٍ كْنتِ سّرِيّ كِ مَ، كٍلِقٍ عَ سَرَ حّ مَ، هَن شْرّيَ حّ رَ. عَ شَ نَ حْشْي رَفبِلٍن عَ كَنيِ مَ، عَ شَ لُ عَلْ وَلِ سَرٍ. ");
INSERT INTO susa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","شَ حّ وُيَشِ لُشِ، عَ شُنسَرٍ شَ فبٌ نَ كِ عَ كَنيِ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","شَ حّ وُيَشِ مُ لُشِ بٍينُ شْرّيَ حّ شَ عَ لِ، عَ شُنسَرٍ شَ لَن نَ حّ شَسَبِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","عَ نْمَ لُدٍ عَلْ وَلِكّ عَ كَنيِ شْنيِ، كْنْ عَ مُ لَنمَ عَ كَنيِ شَ عَ يَمَرِ عَ حَاشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","شَ عَ مُ نْمَ عَ يّتّ شُن سَرَدٍ يِ قّيرّ مْولِ يٌ رَ، عَ تَن نُن عَ شَ دِيٍ شَ لُ عٍ كَنيِ يِ رَ هَن شْرّيَ حّ رَ، ");
INSERT INTO susa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","بَرِ مَ ﭑ تَن نَن مَ وَلِكّيٍ نَ عِسِرَيِلَكَيٍ رَ، ﭑ نَشٍيٍ رَ مِنِشِ مِسِرَ بْشِ رَ. عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«وٌ نَشَ كُيٍ يٌ يَءِلَن، وٌ نَشَ عَلَ ندٍ رَقَلَ، وٌ نَشَ فّمّ بَتُ دَاشِ دْشْ، وٌ نَشَ فّمّ مَسٌلِشِ بَتُ، بَرِ مَ عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ. ");
INSERT INTO susa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","وٌ شَ ﭑ مَ مَلَبُي لْشْييٍ رَبَتُ، وٌ شَ ﭑ مَ يِرٍ سّنِيّنشِ بِنيَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«شَ وٌ ﭑ مَ سّرِيّ سُشُ، شَ وٌ ﭑ مَ يَامَرِيٍ رَبَتُ، ");
INSERT INTO susa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ﭑ تُنّ رَفٌرٌ مَ نّ وٌ بّ عَ وَشَتِ، بْشِ دَشَمُي رَ مِنِمَ نّ، سَنسِيٍ بٌفِمَ نّ شّ مَ. ");
INSERT INTO susa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","سَنسِ بْنبْ تّمُي بُمَ نّ هَن وّنِ بٌفِ بَ تّمُي. وّنِ بٌفِ بَ تّمُي قَن بُمَ نّ هَن سَنسِ سِ تّمُي. وٌ وَ سَمَ نّ بَلٌي رَ، وٌ سَبَتِ وٌ شَ بْشِ مَ بْحّسَ كُي. ");
INSERT INTO susa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ﭑ هِننّمَ وٌ رَ عَلَكٌ وٌ شَ شِ بْحّسَ كُي، عَلَكٌ بُرُنيِ سُبٍيٍ نُن فٍرٍ سٌي نَشَ وٌ تْورْ وٌ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","وٌ نْمَ نّ وٌ يَشُييٍ رَ سَنتِدّفّمَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","وٌ شَ سْورِ سُولِ قَمَ نّ وٌ يَشُي مِشِ كّمّ كٍرِدٍ. وٌ شَ سْورِ كّمّ قَمَ وٌ يَشُي مِشِ وُلُ قُ كٍرِدٍ. وٌ قَمَ نْدٍ وٌ يَشُييٍ رَ فٍرٍ كُي. ");
INSERT INTO susa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","وٌن بِرِن نَ عَ رَ. ﭑ دِ وُيَشِ قِمَ نّ وٌ مَ، ﭑ وٌ رَوُيَ. ﭑ نَن ﭑ مَ سَاتّ رَكَمَلِمَ نّ وٌ بّ. ");
INSERT INTO susa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","وٌ يَلَ مَالٍ دٌنمَ نّ هَن مَالٍ شَبَ تّمُي. وٌ عَ قٌرِ بَمَ نّ عَ سَسٍيٍ كُي عَ شَ فبٌي مَ، عَلَكٌ وٌ شَ نْ مَالٍ نّينّ رَفَتَدٍ. ");
INSERT INTO susa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ﭑ لُمَ نّ وٌ سّيتِ مَ، ﭑ مُ مّيمَ وٌ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ﭑ حّرّ مَ نّ وٌ يَ مَ. وٌ مَرِفِ عَلَ نَن ﭑ نَ، وٌ قَن بَرَ قِندِ ﭑ مَ حَمَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","عَلَتَلَ نَن ﭑ نَ، وٌ مَرِفِ عَلَ، نَشَن وٌ رَ مِنِ مِسِرَ بْشِ رَ عَلَكٌ وٌ نَشَ لُ عٍ يِ رَ. ﭑ بَرَ كٌنيِيَ كٌتٍ بَ وٌ شُن مَ، عَلَكٌ وٌ شَ حّرّ شُننَكٍلِ كُي.» ");
INSERT INTO susa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«كْنْ، شَ وٌ مُ ﭑ شُي رَ مّ، شَ وٌ مُ ﭑ مَ يَامَرِيٍ بِرِن نَبَتُ، ");
INSERT INTO susa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","شَ وٌ مُ ﭑ مَ سّرِيّ سُشُ، شَ وٌ مُ بِرَ ﭑ وَشْنقٍ قْشْ رَ، شَ وٌ ﭑ مَ سَاتّ كَنَ، ");
INSERT INTO susa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ﭑ يِ نَن نَبَمَ وٌ رَ؛ ﭑ يِهَدِ رَفٌرٌ مَ نّ وٌ مَ، ﭑ وٌ رَقُرَ مَ نّ قُرٍ حَاشِ رَ نَشَن وٌ يَيٍ كَنَمَ، نَشَن وٌ بْحّ تْورْ مَ. وٌ سَنسِ شْرِيٍ سِمَ نّ قُقَقُ، بَرِ مَ وٌ يَشُييٍ نَ بِرِن دٌنمَ نّ. ");
INSERT INTO susa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ﭑ فبِلٍنمَ نّ وٌ قْشْ رَ. وٌ يَشُييٍ نْمَ نّ وٌ رَ، وٌ شْننَنتٍيٍ وٌ يَمَرِ مَ نّ. وٌ لُمَ فَاشُي نَن كُي، وٌ نُ وٌ فِ هَلِ مِشِ مُ نَ وٌ قْشْ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«كْنْ نَ بِرِن كُي، وٌ مُ قَمَ ﭑ شُي رَ مّدٍ. ﭑ وٌ حَشَنكَتَمَ هَن سَنمَيَ سٌلٌقٍرٍ وٌ شَ يُنُبِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ﭑ وٌ شَ يّتّ عِفبٌحَ كَنَمَ نّ. ﭑ كٌورٍ بَلَنمَ نّ وٌ يَ رَ هَن وٌ شَ بْشِ شْرْشْ عَلْ وُرٍ فبٍيلِ. ");
INSERT INTO susa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","وٌ سّنبّ حْنمَ نّ قُقَقُ. وٌ شَ بْشِ تٌندِ مَ نّ دَشَمُي رَ مِنِدٍ، وٌ شَ سَنسِيٍ مُ بٌفِمَ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«شَ وٌ لُ ﭑ مَتَندِ رَ، شَ وٌ مُ ﭑ شُي رَ مّ، ﭑ وٌ حَشَنكَتَمَ هَن سَنمَيَ سٌلٌقٍرٍ وٌ شَ يُنُبِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ﭑ بُرُنيِ سُبٍيٍ رَقَمَ نّ وٌ شِلِ مَ. عٍ وٌ شَ دِيٍ قَشَمَ نّ، عٍ وٌ شَ شُرُ سٍيٍ عِبْو، عٍ وٌ سْنتْ هَن مِشِ حْن كِرَيٍ شْن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«نَ بِرِن نَبَ شَنبِ وٌ رَ، شَ وٌ مُ تِن ﭑ مَ سّرِيّ رَ، شَ وٌ لُ ﭑ مَتَندِ رَ، ");
INSERT INTO susa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ﭑ قٍ شْرْشْي رَقَمَ نّ وٌ مَ، ﭑ وٌ حَشَنكَتَ هَن سَنمَيَ سٌلٌقٍرٍ وٌ شَ يُنُبِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ﭑ فٍرٍ رَكٍلِمَ نّ وٌ مَ ﭑ مَ سَاتّ كَنَشِ شَ قٍ رَ. وٌ نَ وٌ نْشُن وٌ شَ تَا مَكَنتَشِيٍ كُي، ﭑ وٌ رَقُرَ مَ نّ قُرٍ حَاشِ رَ، وٌ قَ لُ وٌ يَشُييٍ سَفٌي. ");
INSERT INTO susa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ﭑ كَامّ رَدِنمَ وٌ مَ تّمُي نَشّ، فِنّ قُ تَامِ فَنمَ نّ تَامِ فَنسٍ كٍرٍن كُي. عٍ نَ عِتَشُن عَ شُنشُرِ رَ، عٍ عَ شَنِن وٌ شْن مَ وٌ عَ دٌن، كْنْ عَ مُ وٌ وَ سَمَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«نَ بِرِن نَبَ شَنبِ وٌ رَ، شَ وٌ مُ وٌ تُلِ مَتِ ﭑ نَ، شَ وٌ تٌندِ ﭑ وَشْنقٍ سُشُدٍ، ");
INSERT INTO susa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ﭑ قٍ شْرْشْي رَقَمَ نّ وٌ مَ، ﭑ وٌ حَشَنكَتَ هَن سَنمَيَ سٌلٌقٍرٍ وٌ شَ يُنُبِيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","وٌ قَمَ وٌ شَ دِيٍ سُبٍ يَتِ دٌندٍ. ");
INSERT INTO susa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ﭑ وٌ شَ كُيٍ بَتُدٍيٍ كَنَمَ نّ نَشٍيٍ نَ فٍيَيٍ قَرِ. ﭑ وٌ شَ فّمّيٍ رَبِرَ مَ نّ، وٌ نَشٍيٍ بَتُمَ. ﭑ قُرٍيٍ مَلَنمَ نّ وٌ شَ كُيٍيٍ قَرِ. ﭑ وٌ رَبّحِنمَ نّ، ");
INSERT INTO susa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ﭑ وٌ شَ تَايٍ قِندِ فبٍنفبٍرٍنيِ رَ، ﭑ وٌ شَ بَتُدٍيٍ كَنَ، ﭑ تٌندِ وٌ شَ سّرّشّيٍ سُشُدٍ سْنْن. ");
INSERT INTO susa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ﭑ نَ فّ وٌ شَ بْشِ كَنَدٍ، وٌ يَشُييٍ يَتِ قَمَ كَابَدٍ نَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ﭑ وٌ رَيٍنسٍنمَ نّ حَمَنّ فبّتّيٍ مَ، ﭑ وٌ حَشَنكَتَمَ نّ سَنتِدّفّمَ رَ. وٌ شَ بْشِ كَنَمَ نّ، مِشِ يٌ مُ لُمَ وٌ شَ تَايٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«نَ وَشَتِ بُن مَ وٌ شَ بْشِ مَلَبُمَ نّ. وٌ نَ وٌ يَشُييٍ يِرٍ تّمُي نَشّ، وٌ شَ بْشِ قَنمَ نّ مَلَبُي سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","وٌ شَ بْشِ مَلَبُي سْتْمَ نَ وَشَتِ نَن كُي عَ مُ نَشَن سْتْ وٌ نُ نَ مّننِ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","نَشٍيٍ مُ قَشَمَ نَ فٍرٍيٍ كُي، نٍيٍ لُمَ نّ فَاشُي كُي عٍ يَشُييٍ يِرٍ، هَلِ وُرِ بُرّشّ نَن دِن عٍ رَ، قٌ عٍ عٍ فِ. عٍ عٍ فِمَ نّ، عٍ بِرَ هَلِ سَنتِدّفّمَ كَنيِ يٌ مُ نَ عٍ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","عٍ بِرَ مَ نّ عٍ بٌورٍ قَرِ، عَلْ سَنتِدّفّمَ كَنيِ نَن عٍ قْشْ رَ، عَ قَ لِ مِشِ يٌ مُ نَ عٍ قْشْ رَ. وٌ مُ نْمَ تِدٍ وٌ يَشُييٍ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","وٌ سْنتْمَ نّ سِ فبّتّيٍ تَفِ، وٌ يَشُييٍ نْمَ نّ وٌ رَ. ");
INSERT INTO susa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","نَشٍيٍ مُ قَشَمَ فٍرٍ كُي وٌ يَ مَ، نٍيٍ قَمَ نّ قَشَدٍ عٍ يَشُييٍ شَ بْشِ مَ عٍ شَ يُنُبِيٍ نُن عٍ بٍنبَيٍ شَ يُنُبِيٍ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«عٍ قَمَ عٍ شَ يُنُبِيٍ نُن عٍ بٍنبَيٍ شَ يُنُبِيٍ مَسٍندٍ ﭑ بّ، عَ نُن عٍ نَشَن نَبَشِ ﭑ نَ مَتَندِ كُي. ");
INSERT INTO susa_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ﭑ قَن عٍ تْورْ مَ نّ عٍ يَشُييٍ شَ بْشِ كُي، عَلَكٌ مِشِ نَشٍيٍ عٍ يّتّ قِشِ ﭑ مَ، عٍ شَ مَفٌرٌ. عٍ شَ عٍ شَ يُنُبِيٍ سَرٍ قِ. ");
INSERT INTO susa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","نَ تّمُي ﭑ نَن ﭑ حْشْ سَمَ نّ ﭑ مَ سَاتّ شْن مَ نَشَن نَ ﭑ تَن، نُن يَشُبَ، عِسِيَفَ، نُن عِبُرَهِمَ تَفِ. ﭑ مُ نّيمُمَ نَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","بْشِ قَمَ نّ مَلَبُدٍ نَ تّمُي، بَرِ مَ عِسِرَيِلَكَيٍ بَرَ سِفَ ثٌن عٍ شَ يُنُبِ سَرٍ قِدٍ. عٍ بَرَ ﭑ مَ سّرِيّ بّحِن، عٍ بَرَ يٌ ﭑ مَ يَامَرِيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","«كْنْ، ﭑ نَ عٍ كٍرِ سِفَقٍ رَ عٍ يَشُييٍ يِرٍ تّمُي نَشّ، ﭑ مُ عٍ رَبّحِنمَ هَن عٍ شَ سْنتْ. ﭑ مُ ﭑ مَ سَاتّ كَنَمَ عٍ تَن مَ قٍ رَ، بَرِ مَ عَلَتَلَ نَن ﭑ نَ، عٍ مَرِفِ عَلَ. ");
INSERT INTO susa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ﭑ نَن ﭑ حْشْ سَمَ نّ ﭑ مَ سَاتّ سِنفٍ شْن مَ، ﭑ عٍ رَ مِنِ مِسِرَ بْشِ رَ سِيٍ يَ شْرِ تّمُي نَشّ، عَلَكٌ ﭑ شَ قِندِ عٍ مَرِفِ عَلَ رَ. عَلَتَلَ نَن ﭑ نَ.» ");
INSERT INTO susa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","عَلَتَلَ شَ سّرِيّ، عَ شَ يَامَرِيٍ، نُن عَ شَ مَسٍنيِيٍ نَن نَ كِ عَلَتَلَ نَشٍيٍ مَسٍنشِ عِسِرَيِلَكَيٍ بّ عَننَبِ مُنسَ سَابُي رَ تُرُ سِنِنَ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","عَلَتَلَ نَشَ عَ مَسٍن عَننَبِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، شَ مِشِ ندٍ لَايِدِ تٌنفٌ، عَ شَ مِشِ ندٍ قِ ﭑ تَن عَلَتَلَ مَ، عَ نْمَ عَ شُن سَرَدٍ يِ كْبِرِ شَسَبِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","شَ شّمّ نَ عَ رَ نَشَن شَ سِمَيَ كٍلِمَ حّ مْشْحّن هَن حّ تٌنفٌ سٍننِ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ تٌنفٌ سُولِ نَن نَ نَشَن مَنِيَمَ يِرٍ سّنِيّنشِ مَنِيَسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","شَ فِنّ نَ عَ رَ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ تٌنفٌ سَشَن نُن عَ تَفِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","شَ دِ شّمّ نَ عَ رَ نَشَن شَ سِمَيَ كٍلِمَ حّ سُولِ هَن حّ مْشْحّن، عَ شُن سَرَ مَ فبٍتِ كِلٌ مْشْحّن نَن نَ. شَ فِنّ دِ مّدِ نَ عَ رَ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ قُ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","شَ دِ شّمّ نَ عَ رَ نَشَن مُ حّ سُولِ سْتْشِ سِندٍن، عَ شُن سَرَ مَ فبٍتِ كٌلٍ سُولِ نَن نَ. شَ دِ فِنّ نَ عَ رَ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ سَشَن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","شَ شّمْشِ نَ عَ رَ نَشَن شَ سِمَيَ دَنفِمَ حّ تٌنفٌ سٍننِ رَ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ قُ نُن سُولِ نَن نَ. شَ حّلّشّقٌرِ نَ عَ رَ، عَ شُن سَرَ مَ فبٍتِ كٌلٍ قُ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","شَ سٍتَرٍ بَرَ نَ لَايِدِ تٌنفٌ، نَشَن مُ نْمَ نَ شُنسَرٍ شَسَبِ قِدٍ، عَ لَن عَ شَ عَ يّتّ مَسٍن سّرّشّدُبّ بّ نَشَن قَمَ شُنسَرٍ شَسَبِ قَلَدٍ عَ بّ عَ نْمَ نَشَن نَ.» ");
INSERT INTO susa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«شَ مِشِ ندٍ لَايِدِ تٌنفٌ شُرُ سٍ ندٍ قِقٍ رَ، نَشَن نْمَ بَدٍ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، نَ شُرُ سٍ شَ قِ ﭑ تَن عَلَتَلَ مَ. عَ بَرَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","شُرُ سٍ فبّتّ مُ قِمَ عَ مَسَرٍ رَ، عَ قَن بَ، عَ مُ قَن بَ. شَ وٌ نَ رَبَمَ، عٍ قِرِنيِ بَرَ قِندِ سٍ سّنِيّنشِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","شَ سُبٍ رَهَرَ مُشِ نَ عَ رَ، نَشَن مُ بَمَ سّرّشّ رَ ﭑ تَن عَلَتَلَ بّ، عَ شَ شَنِن سّرّشّدُبّ شْن. ");
INSERT INTO susa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","سّرّشّدُبّ شَ شُنسَرٍ ندٍ قَلَ سُبٍ كّحَ مَ. نَ شَ قِندِ عَ سَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","شَ عَ كَنيِ وَ مَ نَ سُبٍ شُن سَرَقٍ، عَ شَ نَ سَرٍ قِ، عَ مَن شَ كْبِرِ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ سٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ قِ شُنسَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«شَ مِشِ ندٍ عَ شَ بَنشِ قِ ﭑ تَن عَلَتَلَ مَ، سّرّشّدُبّ شَ نَ سَرٍ قَلَ بَنشِ كّحَ مَ. نَ شَ قِندِ عَ سَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","شَ عَ كَنيِ وَ مَ عَ شُن سَرَقٍ، عَ شَ نَ سَرٍ قِ، عَ مَن شَ كْبِرِ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ بَنشِ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ قِ شُنسَرٍ رَ. نَ تّمُي بَنشِ شَ فبِلٍن عَ كَنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«شَ مِشِ ندٍ عَ شَ شّ قِ ﭑ تَن عَلَتَلَ مَ، عَ سَرٍ قَتَنمَ سَنسِ شْرِ شَسَبِ نَن نَ نَشَن نْمَ فَرَنسَندٍ نَا. فبٍتِ كٌلٍ تٌنفٌ سُولِ شَ قِ قُندٍنيِ مَنِيّ بُسَلِ نَانِ شَسَبِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","شَ عَ عَ شَ شّ قِ شْرّيَ حّ نَن كُي، عَ سَرٍ مُ مَسَرَ مَ. ");
INSERT INTO susa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","شَ عَ عَ شَ شّ قِ شْرّيَ حّ دَنفِ شَنبِ نّ، سّرّشّدُبّ شَ حّيٍ كْنتِ نَشٍيٍ لُشِ بٍينُ شْرّيَ حّ فبّتّ شَ قَ. عَ شَ ندٍ بَ شّ سَرٍ رَ نَ سّرِيّ كُي. ");
INSERT INTO susa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","شَ شّ كَنيِ وَ مَ عَ شَ شّ شُن سَرَقٍ، عَ شَ نَ سَرٍ قِ، عَ مَن شَ كْبِرِ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ شّ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ قِ شُنسَرٍ رَ. نَ تّمُي شّ شَ لُ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","شَ عَ مُ شّ شُن سَرَ، عَ قَ عَ مَتِ مِشِ فبّتّ مَ، عَ مُ نْمَ عَ شُن سَرَدٍ سْنْن. ");
INSERT INTO susa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","شْرّيَ حّ نَ عَ لِ، نَ شّ كَنيِ نّينّ شَ كٍلِ نَ بْشِ مَ. بْشِ بَرَ سّنِيّن، عَ بَرَ لُ عَلْ بْشِ نَشَن نَتْنشِ. عَ بَرَ قِندِ عَلَتَلَ فبٍ رَ، سّرّشّدُبّيٍ شَ نَ رَوَلِ. ");
INSERT INTO susa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","شَ مِشِ بَرَ شّ سَرَشِ قِ عَلَتَلَ مَ، نَشَن مُ نَ عَ شَبِلّ كّ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","سّرّشّدُبّ شَ عَ سَرٍ قَلَ عَ سّرِيّ كِ مَ. عَ نَ كٌلٌنمَ حّ شَسَبِ نَن مَ نَشٍيٍ لُشِ بٍينُ شْرّيَ حّ شَ عَ لِ. نَ كَنيِ شَ عَ سَرٍ قِ نَ لْشْي يَتِ، بَرِ مَ عَ سّنِيّن ﭑ تَن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","شْرّيَ حّ نَ عَ لِ، نَ شّ فبِلٍنمَ نَ شّ كَنيِ سِنفٍ نَن مَ، بٌورٍ عَ سَرَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","نَ سَرٍيٍ بِرِن مَنِيَمَ يِرٍ سّنِيّنشِ شَ سٍ مَنِيَ كِ نَن مَ. عَ كٌلٍ كٍرٍن لَنشِ فَرَ مُ قُ نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«مِشِ يٌ مُ نْمَ عَ شَ شُرُ سٍ دِ سِنفٍ قِدٍ ﭑ تَن عَلَتَلَ مَ، بَرِ مَ عَ حَن قِندِشِ ﭑ تَن عَلَتَلَ فبٍ نَن نَ. شُرُ سٍ شُنفبٍ نُن عَ لَنمَ دِ سِنفٍ بِرِن قِندِشِ ﭑ تَن نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","مِشِ نْمَ سُبٍ رَهَرَ مُشِ شَ دِ سِنفٍ شُن سَرَدٍ. نَ مِشِ شَ عَ سَرٍ قِ، عَ مَن شَ كْبِرِ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ سُبٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ قِ عَ شُنسَرٍ رَ. شَ عَ كَنيِ مُ عَ شُن سَرَ مَ، عَ شَ عَ مَتِ عَ سَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«كْنْ سٍ ندٍيٍ نَ مِشِ نَشٍيٍ قِمَ ﭑ تَن عَلَتَلَ مَ عَ بْحّ بِرِن نَ عٍ قِندِ ﭑ فبٍ رَ، عَدَ مَ مُ نْمَ نٍيٍ شُن سَرَدٍ سْنْن. نٍيٍ بَرَ سّنِيّن، نٍيٍ بَرَ قِندِ ﭑ تَن عَلَتَلَ فبَنسَن فبٍ رَ. نٍيٍ نْمَ قِندِدٍ مِشِ، شُرُ سٍ، شّ، شَ نَ مُ عَ رَ سٍ فبّتّ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","مِشِ سٍ نَشٍيٍ قِمَ ﭑ تَن عَلَتَلَ مَ نَ مْولِ رَ، عٍ شُن مُ نْمَ سَرَدٍ، قٌ عٍ شَ قَشَ نّ.» ");
INSERT INTO susa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«بْشِ قَرِلّ بِرِن قِندِ مَ ﭑ تَن عَلَتَلَ نَن فبٍ رَ، سَنسِ شْرِ نَشَن نَمِنِمَ نُن وُرِ بِلِ نَشَن بٌفِمَ. نَ قَرِلّ بِرِن قِمَ ﭑ تَن عَلَتَلَ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","شَ مِشِ ندٍ وَ مَ عَ شَ قَرِلّ شُن سَرَقٍ، عَ شَ عَ سَرٍ قِ، عَ مَن شَ كْبِرِ ندٍ سَ نَ قَرِ. نَ قِندِ مَ كْبِرِ نَشَن نَ، عَ نَ سٍ سَرٍ نَن عِتَشُنمَ دْشْ سُولِ رَ، عَ قَ دْشْ كٍرٍن بَ عَ رَ، عَ نَ قِ عَ شُنسَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","شُرُ سٍ قَرِلّ بِرِن قِندِ مَ ﭑ تَن عَلَتَلَ نَن فبٍ رَ، شُرُ سٍ شُنفبٍ نُن عَ لَنمَ، شُرُ سٍ دّمَدٌنيِ نَشَن بِرِن كْنتِمَ. نَ قَرِلّ بِرِن قِمَ ﭑ تَن عَلَتَلَ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","شُرُ سٍيٍ مُ مَتٌمَ شَ عَ قَن، شَ عَ مُ قَن. شُرُ سٍ مُ نْمَ مَسَرَدٍ شُرُ سٍ فبّتّ رَ، شَ نَ مُ عَ رَ نَ قِرِنيِ بِرِن سّنِيّنمَ نّ، عٍ قِندِ ﭑ تَن عَلَتَلَ فبٍ رَ، عٍ سٍسٍ مُ نْمَ شُن سَرَدٍ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","عَلَتَلَ شَ يَامَرِيٍ نَن نَ كِ، عَ نَشٍيٍ سٌ عَننَبِ مُنسَ يِ رَ تُرُ سِنِنَ فٍيَ قَرِ عِسِرَيِلَكَيٍ بّ.");
INSERT INTO susa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","عِسِرَيِلَكَيٍ شَ مِنِ مِسِرَ حّ قِرِن ندٍ، كِكٍ قِرِن ندٍ، شِ سِنفٍ، عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ هْرْ مْلِنفِرَ كُي، ");
INSERT INTO susa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«وٌ شَ عِسِرَيِلَ شّمّ بِرِن كْنتِ عَ شَبِلّ نُن عَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","نَشٍيٍ شَ سِمَيَ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نْمَ قِندِدٍ عِسِرَيِلَ سْورِيٍ رَ. عِ نُن هَرُنَ، وٌ شَ عٍ عِتَشُن سْورِ فَالِ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","بْنسْي شُنيِيٍ شَ وٌ مَلِ نَ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","عٍ شِلِيٍ نَن يَ؛ رُبٍن بْنسْي يَ مَ، سٍدٍيُرِ شَ دِ شّمّ عٍلِسُرُ. ");
INSERT INTO susa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","سِمٍيْن بْنسْي يَ مَ، سُرِ سَدَيِ شَ دِ شّمّ سٍلُمِيٍلِ. ");
INSERT INTO susa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","يُدَ بْنسْي يَ مَ، عَمِنَدَبٌ شَ دِ شّمّ نَشَسٌن. ");
INSERT INTO susa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","عِسَكَرِ بْنسْي يَ مَ، سُوَرَ شَ دِ شّمّ نٍتَنٍيلِ. ");
INSERT INTO susa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","سَبُلٌن بْنسْي يَ مَ، شٍلٌن شَ دِ شّمّ عٍلِيَبِ. ");
INSERT INTO susa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","يُسُقُ شَ دِ شّمّ عٍقِرَ مِ بْنسْي يَ مَ، عَمِشُدِ شَ دِ شّمّ عٍلِسَمَ. يُسُقُ شَ دِ شّمّ مَنَسِ بْنسْي يَ مَ، ثٍدَ سُرُ شَ دِ شّمّ فَمَلِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","بُنيَمِن بْنسْي يَ مَ، فِدٍيٌنِ شَ دِ شّمّ عَبِدَن. ");
INSERT INTO susa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","دَنَ بْنسْي يَ مَ، عَمِسَدَيِ شَ دِ شّمّ عَشِيٍسٍرِ. ");
INSERT INTO susa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","عَسٍرِ بْنسْي يَ مَ، عٌكِرَن شَ دِ شّمّ ثَفِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","فَدِ بْنسْي يَ مَ، دُوٍلِ شَ دِ شّمّ عٍلِيَسَقَ. ");
INSERT INTO susa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","نَقَتَلِ بْنسْي يَ مَ، عٍنَن شَ دِ شّمّ عَشِرَ.» ");
INSERT INTO susa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","نَ بْنسْي شُنيِيٍ نَن شِلِشِ، عٍ شَ قِندِ عِسِرَيِلَ سْورِ مَنفّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","عٍ نَشَ كَقُ مُنسَ نُن هَرُنَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","عٍ شَ عِسِرَيِلَ حَمَ مَلَن، نَ كِكٍ قِرِن ندٍ، شِ سِنفٍ. شّمّ بِرِن نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، عٍ نَشَ عٍ تّنفّ عٍ شَبِلّ نُن عٍ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. مُنسَ نَشَ عٍ تّنفّ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","عٍ نَشَ عِسِرَيِلَ شَ دِ سِنفٍ رُبٍن بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ نَانِ نُن سٍننِ، شّمّ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","عٍ نَشَ سِمٍيْن بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سُولِ نُن سٌلٌمَنَانِ، شّمّ كّمّ سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","عٍ نَشَ فَدِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ نَانِ نُن سُولِ، شّمّ كّمّ سٍننِ تٌنفٌ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","عٍ نَشَ يُدَ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سٌلٌقٍرٍ نُن نَانِ، شّمّ كّمّ سٍننِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","عٍ نَشَ عِسَكَرِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سُولِ نُن نَانِ، شّمّ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","عٍ نَشَ سِمٍيْن بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سُولِ نُن سٌلٌقٍرٍ، شّمّ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","عٍ نَشَ يُسُقُ شَ دِ شّمّ عٍقِرَ مِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ نَانِ، شّمّ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","عٍ نَشَ يُسُقُ شَ دِ شّمّ مَنَسِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سَشَن نُن قِرِن، شّمّ كّمّ قِرِن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","عٍ نَشَ بُنيَمِن بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سَشَن نُن سُولِ، شّمّ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","عٍ نَشَ دَنَ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سٍننِ نُن قِرِن، شّمّ كّمّ سٌلٌقٍرٍ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","عٍ نَشَ عَسٍرِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","نَ شَسَبِ لَن نّ شّمّ وُلُ نَانِ نُن كٍرٍن، شّمّ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","عٍ نَشَ نَقَتَلِ بْنسْي بِرِن تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ. عٍ نَشَ شّمّيٍ شِلِ سّبّ، نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","نَ شَسَبِ لَن نّ شّمّ وُلُ تٌنفٌ سُولِ نُن سَشَن، شّمّ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","عِسِرَيِلَ بْنسْي شُنيِ قُ نُن قِرِنيِ نَن كَقُ مُنسَ نُن هَرُنَ مَ نَ تّنفّ تِقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","عِسِرَيِلَ شّمّ نَشٍيٍ نُ بَرَ حّ مْشْحّن لِ، نَشٍيٍ نُ نْمَ سْورِحَ رَبَدٍ، ");
INSERT INTO susa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","نٍيٍ نُ لَنشِ شّمّ وُلُ كّمّ سٍننِ نُن سَشَن، شّمّ كّمّ سُولِ نُن تٌنفٌ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","كْنْ لٍوِ بْنسْي مُ نُ نَ نَ كْنتِ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","بَرِ مَ عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«عِ نَشَ لٍوِكَيٍ تّنفّ عِسِرَيِلَكَيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","عِ شَ هْرْ مْلِنفِرَ نُن عَ شَ سٍ بِرِن تَشُ عٍ رَ. ﭑ مَ سَاتّ تْنشُمَ نَ عَ رَ. عٍ شَ عَ مَشَنِن، عٍ شَ مّينِ عَ مَ، عٍ شَ يٌنكِن عَ رَبِلِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","وٌ نَ كٍلِ سِفَدٍ، عٍ شَ عَ رَفٌرٌ. وٌ نَ يِرٍ نّينّ لِ، عٍ شَ عَ تِ. شَ مِشِ فبّتّ عَ مَسٌ عَ رَ نَشَن مُ قِندِ لٍوِ بْنسْي رَ، نَ كَنيِ لَن نّ عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","عِسِرَيِلَكَ بِرِن شَ يٌنكِن يِرٍ عٍ نَ دّننَشّ مَسٍن عٍ بّ، عٍ بْنسْي شَ تْنشُمَ بُن مَ، عَ نُن عٍ شَ سْورِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","لٍوِ بْنسْييٍ شَ يٌنكِن هْرْ مْلِنفِرَ رَبِلِنيِ، شَ نَ مُ عَ رَ ﭑ شْنْمَ نّ عِسِرَيِلَ حَمَ مَ. لٍوِكَيٍ شَ عٍ حّنفِ سَ هْرْ مْلِنفِرَ شْن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","عِسِرَيِلَكَيٍ نَشَ عَلَتَلَ شَ يَامَرِ بِرِن سُشُ، عَ نَشَن سٌشِ مُنسَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«عِسِرَيِلَكَ بِرِن يٌنكِنمَ عٍ شَبِلّ شَ تْنشُمَ نَن بُن مَ. عٍ بِرِن يَ رَقِندِ مَ عٍ بٌورٍيٍ نَن مَ، هْرْ مْلِنفِرَ قَ لُ عٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","يُدَ بْنسْي نَن يٌنكِنمَ سٌفٍتٍدٍ مَبِرِ عٍ شَ تْنشُمَ بُن مَ. عَمِنَدَبٌ شَ دِ نَشَسٌن نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سٌلٌقٍرٍ نُن نَانِ، مِشِ كّمّ سٍننِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","عِسَكَرِ بْنسْي نَن يٌنكِنمَ يُدَ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. سُوَرَ شَ دِ نٍتَنٍيلِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن نَانِ، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","سَبُلٌن بْنسْي نَن يٌنكِنمَ يُدَ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. شٍلٌن شَ دِ عٍلِيَبِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن سٌلٌقٍرٍ، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","فَلِ نَشَن يٌنكِن يُدَ بْنسْي مَبِرِ، عٍ شَسَبِ لَن مِشِ وُلُ كّمّ مِشِ وُلُ تٌنفٌ سٌلٌمَسَشَن نُن سٍننِ، مِشِ كّمّ نَانِ نَن مَ. عٍ تَن نَن تِمَ يَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","رُبٍن بْنسْي نَن يٌنكِنمَ سٌفٍتٍدٍ مَبِرِ عٍ شَ تْنشُمَ بُن مَ. سٍدٍيُرِ شَ دِ عٍلِسُرُ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن سٍننِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","سِمٍيْن بْنسْي نَن يٌنكِنمَ رُبٍن بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. سُرِ سَدَيِ شَ دِ سٍلُمِيٍلِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن سٌلٌمَنَانِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","فَدِ بْنسْي نَن يٌنكِنمَ رُبٍن بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. دُوٍلِ شَ دِ عٍلِيَسَقَ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن سُولِ، مِشِ كّمّ سٍننِ نُن تٌنفٌ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","فَلِ نَشَن يٌنكِن رُبٍن بْنسْي مَبِرِ، عٍ شَسَبِ لَن مِشِ وُلُ كّمّ مِشِ وُلُ تٌنفٌ سُولِ نُن كٍرٍن، مِشِ كّمّ نَانِ نُن تٌنفٌ سُولِ نَن مَ. عٍ تَن نَن سِفَمَ عَ قِرِن ندٍ. ");
INSERT INTO susa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","لٍوِ بْنسْي نَشَن يٌنكِنمَ عٍ تَفِ، عَ بِرَ مَ عٍ قْشْ رَ هْرْ مْلِنفِرَ شَنِنقٍ رَ. بْنسْي بِرِن حّرّ مَ عٍ سَقّ كِ نَن مَ عٍ شَ تْنشُمَ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","عٍقِرَ مِ بْنسْي نَن يٌنكِنمَ سٌفٍفٌرٌدٍ مَبِرِ عٍ شَ تْنشُمَ بُن مَ. عَمِشُدِ شَ دِ عٍلِسَمَ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","مَنَسِ بْنسْي نَن يٌنكِنمَ عٍقِرَ مِ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. ثٍدَ سُرُ شَ دِ فَمَلِيّلِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سَشَن نُن قِرِن، مِشِ كّمّ قِرِن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","بُنيَمِن بْنسْي نَن يٌنكِنمَ عٍقِرَ مِ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. فِدٍيٌنِ شَ دِ عَبِدَن نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سَشَن نُن سُولِ، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","فَلِ نَشَن يٌنكِن عٍقِرَ مِ بْنسْي مَبِرِ، عٍ شَسَبِ لَن مِشِ وُلُ كّمّ مِشِ وُلُ سٌلٌمَسَشَن، مِشِ كّمّ نَن مَ. عٍ تَن نَن سِفَمَ عَ سَشَن ندٍ. ");
INSERT INTO susa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","دَنَ بْنسْي نَن يٌنكِنمَ يِرٍقَنيِ مَبِرِ عٍ شَ تْنشُمَ بُن مَ. عَمِسَدَيِ شَ دِ عَشِيٍسٍرِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سٍننِ نُن قِرِن، مِشِ كّمّ سٌلٌقٍرٍ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","عَسٍرِ بْنسْي نَن يٌنكِنمَ دَنَ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. عٌكِرَن شَ دِ ثَفِيّلِ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن كٍرٍن، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","نَقَتَلِ بْنسْي نَن يٌنكِنمَ دَنَ بْنسْي سّيتِ مَ عٍ شَ تْنشُمَ بُن مَ. عٍنَن شَ دِ عَشِرَ نَن عٍ شَ يَرٍرَتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","عَ شَ سْورِيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن سَشَن، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","فَلِ نَشَن يٌنكِن دَنَ بْنسْي مَبِرِ، عٍ شَسَبِ لَن مِشِ وُلُ كّمّ مِشِ وُلُ تٌنفٌ سُولِ نُن سٌلٌقٍرٍ، مِشِ كّمّ سٍننِ نَن مَ. عٍ تَن نَن سِفَمَ عَ دْنشْي رَ عٍ شَ تْنشُمَيٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","عِسِرَيِلَكَ نَشٍيٍ تّنفّ عٍ شَبِلّ كِ مَ نُن عٍ شَ سْورِ فَلِ كِ مَ، عٍ شَسَبِ لَن مِشِ وُلُ كّمّ سٍننِ نُن سَشَن، مِشِ كّمّ سُولِ نُن تٌنفٌ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","لٍوِ بْنسْي تَن مُ تّنفّ عِسِرَيِلَكَيٍ شُن مَ، عَلْ عَلَتَلَ عَ مَسٍن كِ نَشّ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","عِسِرَيِلَكَيٍ نَشَ بِرَ عَلَتَلَ شَ يَامَرِ بِرِن قْشْ رَ، عَلْ عَ مُنسَ يَمَرِ عَ رَ كِ نَشّ. عٍ نُ يٌنكِنمَ عٍ شَ تْنشُمَ نَن بُن مَ، عٍ مَن نُ حّرّ مَ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","هَرُنَ نُن مُنسَ شَ تَرُشُي نَن يَ، عَلَتَلَ تٌ وْيّن مُنسَ بّ تُرُ سِنِنَ فٍيَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","هَرُنَ شَ دِ شّمّيٍ شِلِيٍ نَن يِ كِ؛ عَ شَ دِ شّمّ سِنفٍ نُ شِلِ نّ نَدَبٌ، عَ شُنيَيٍ، عَبِهُ، عٍلٍيَسَرِ، نُن عِتَمَرِ. ");
INSERT INTO susa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","نٍيٍ نَن سُفَندِشِ عٍ شَ قِندِ سّرّشّدُبّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","كْنْ نَدَبٌ نُن عَبِهُ نَشَ قَشَ عَلَتَلَ يَ عِ عٍ تٌ سّرّشّ فَن تّ رَ نَشَن مُ لَنشِ. عٍ مُ دِ يٌ سْتْ، كْنْ عٍلٍيَسَرِ نُن عِتَمَرِ نَشَ لُ سّرّشّدُبّحَ كُي عٍ بَبَ هَرُنَ شَ يَامَرِ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«عِ شَ لٍوِ بْنسْي مَسٍن هَرُنَ بّ، عٍ شَ عَ مَلِ عَ شَ سّرّشّدُبّ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","عٍ شَ هَرُنَ نُن عِسِرَيِلَ حَمَ مَلِ هْرْ مْلِنفِرَ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","عٍ شَ عٍ حْشْ سَ هْرْ مْلِنفِرَ رَشُنمَسٍيٍ شْن نَ، عٍ مَن شَ هْرْ مْلِنفِرَ وَلِ رَبَ عِسِرَيِلَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","نَ كُي عِ لٍوِ بْنسْي سَمَ هَرُنَ نُن عَ شَ دِ شّمّيٍ نَن سَفٌ. عٍ سُفَندِشِ عِسِرَيِلَكَيٍ يَ مَ هَرُنَ مَلِقٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","عِ شَ هَرُنَ نُن عَ شَ دِيٍ نَن تُن تِ سّرّشّدُبّ وَلِ رَبَقٍ رَ. شَ مِشِ فبّتّ سَ عَ مَسٌ هْرْ مْلِنفِرَ رَ، نَ كَنيِ شَ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«ﭑ بَرَ لٍوِ بْنسْي سُفَندِ عِسِرَيِلَكَيٍ تَفِ عِسِرَيِلَ فِنّيٍ شَ دِ سِنفٍ بِرِن حْشْي رَ. نَ بْنسْي قِندِشِ ﭑ فبٍ نَن نَ، ");
INSERT INTO susa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","بَرِ مَ ﭑ فبٍ نَن نَ دِ شّمّ سِنفٍ بِرِن نَ. ﭑ تٌ دِ شّمّ سِنفٍ بِرِن قَشَ مِسِرَ بْشِ مَ، ﭑ نَشَ عِسِرَيِلَ دِ شّمّ سِنفٍ بِرِن سُفَندِ ﭑ يّتّ بّ، عَ قِندِ مِشِ رَ، عَ قِندِ شُرُ سٍ رَ. ﭑ تَن نَن نَ عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«لٍوِ بْنسْي تّنفّ عَ دٍنبَيَ نُن عَ شَبِلّ كِ مَ. شّمّ بِرِن تّنفّمَ نّ نَشَن مَ سِمَيَ بَرَ كِكٍ كٍرٍن لِ.» ");
INSERT INTO susa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","مُنسَ نَشَ عٍ تّنفّ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","لٍوِ شَ دِ شّمّيٍ شِلِيٍ نَن يِ كِ؛ فٍرِ سٌن، كٍهَتِ، نُن مٍرَرِ. ");
INSERT INTO susa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","فٍرِ سٌن شَ دِ شّمّيٍ شِلِيٍ نَن يِ كِ عَ شَبِلّ كِ مَ؛ لِبِنِ نُن سِمٍيِ. ");
INSERT INTO susa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","كٍهَتِ شَ دِ شّمّيٍ عَ شَبِلّ كِ مَ؛ عَمَرَ مَ، يِسٍهَرِ، شٍبِرٌن نُن يُسِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","مٍرَرِ شَ دِ شّمّيٍ عَ شَبِلّ كِ مَ؛ مَشَلِ نُن مُسِ. لٍوِ شَبِلّ نَن نَ كِ عٍ شَ دٍنبَيَ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","فٍرِ سٌن بْنسْي نُ نَ لِبِنِ سِمٍيِ شَبِلّ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","نَشٍيٍ شَ سِمَيَ نُ بَرَ كِكٍ كٍرٍن لِ، عٍ شَسَبِ لَن مِشِ وُلُ سٌلٌقٍرٍ مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","فٍرِ سٌن شَبِلّ نُ يٌنكِنمَ هْرْ مْلِنفِرَ نَن شَنبِ رَ سٌفٍفٌرٌدٍ مَبِرِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","عٍ شُنيِ نُ نَ لَيّلِ شَ دِ شّمّ عٍلِيَسَقَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","فٍرِ سٌن شَ مِشِيٍ نُ عٍ حْشْي سَشِ هْرْ مْلِنفِرَ نَن شْن مَ، نُن مَقٍلٍنيِ نَشَن قٍلٍنمَ عَ شُن مَ، عَ نُن عَ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","عَ نُن كْلِمّ نَشٍيٍ نُ سَمَ هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ رَبِلِنيِ مَ، عَ نُن نَ تّتّ سٌدٍ دّ رَ، عَ نُن لُوتِيٍ عٍ نَ مَشِرِ مَ نَشٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","كٍهَتِ شَ مِشِيٍ نَن يِ كِ؛ عَمَرَ مَ شَبِلّ، يِسٍهَرِ شَبِلّ، شٍبِرٌن شَبِلّ، نُن يُسِيّلِ شَبِلّ. نَ شَبِلّيٍ نَن مِنِشِ عٍ بٍنبَ كٍهَتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","عٍ شَ دِ شّمّ نَشٍيٍ شَ سِمَيَ نُ بَرَ كِكٍ كٍرٍن لِ، عٍ شَسَبِ لَن مِشِ وُلُ سٌلٌمَسَشَن كّمّ سٍننِ نَن مَ. كٍهَتِ شَ مِشِيٍ نَن نُ مّينِمَ هْرْ مْلِنفِرَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","عٍ تَن نُ يٌنكِنمَ هْرْ مْلِنفِرَ يِرٍقَنيِ مَبِرِ نّ. ");
INSERT INTO susa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","يُسِيّلِ شَ دِ شّمّ عٍلِسَقَن نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","هْرْ مْلِنفِرَ سَاتّ كَنكِرَ، تٍيبِلِ، لَنثُييٍ، سّرّشّبَدٍيٍ، يِرَبَسٍ نَشٍيٍ رَوَلِمَ يِرٍ سّنِيّنشِ كُي، نُن دُفِ يَرَ سَ نَشَن نَ هْرْ مْلِنفِرَ كُي، عٍ نُ تَشُشِ عٍ تَن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","لٍوِ بْنسْي بِرِن شُنيِ نُ نَ هَرُنَ شَ دِ شّمّ عٍلٍيَسَرِ نَن نَ. عَ تَن نَن نُ لٍوِ بْنسْي مِشِيٍ شُن مَ، نَشٍيٍ مّينِمَ هْرْ مْلِنفِرَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","مٍرَرِ شَ مِشِيٍ نَن يِ كِ؛ مَشَلِ شَبِلّ نُن مُسِ شَبِلّ. ");
INSERT INTO susa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","عٍ شَ دِ شّمّ نَشٍيٍ شَ سِمَيَ نُ بَرَ كِكٍ كٍرٍن لِ، عٍ شَسَبِ لَن مِشِ وُلُ سٍننِ كّمّ قِرِن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","عَبِشَيِلِ شَ دِ شّمّ سُرِيٍلِ نَن نُ نَ مٍرَرِ شَبِلّيٍ شُنيِ رَ. عٍ نُ يٌنكِنمَ هْرْ مْلِنفِرَ كْولَ مَبِرِ نّ. ");
INSERT INTO susa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","هْرْ مْلِنفِرَ شٍبٍنيِيٍ، عَ وُرِ كُيٍيٍ، عَ كْنتِفِبَيٍ، عَ سَنبُنيِيٍ، عَ شَ يِرَبَسٍ، نُن عَ رَوَلِسٍيٍ نُ تَشُشِ عٍ تَن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","عٍ مَن نُ عٍ حْشْ سَمَ كْنتِفِبَيٍ شْن مَ نَشٍيٍ نُ هْرْ مْلِنفِرَ تّتّ رَبِلِنشِ، عَ نُن عٍ سَنبُنيِيٍ، عٍ شَ كْرِدِيٍ، نُن عٍ شَ لُوتِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","مُنسَ، هَرُنَ، نُن عَ شَ دِ شّمّيٍ نُ يٌنكِنمَ هْرْ مْلِنفِرَ سٌدٍ دّ نَن نَ سٌفٍتٍدٍ مَبِرِ. عٍ تَن نَن نُ عٍ حْشْ سَمَ هْرْ مْلِنفِرَ شْن مَ عِسِرَيِلَكَ بِرِن شِلِ رَ. شَ مِشِ فبّتّ سَ عَ مَسٌ هْرْ مْلِنفِرَ رَ، نَ كَنيِ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","لٍوِ بْنسْي دِ شّمّ نَشٍيٍ شَ سِمَيَ نُ بَرَ كِكٍ كٍرٍن لِ، عٍ شَسَبِ لَن مِشِ وُلُ مْشْحّن نُن قِرِن نَن مَ. مُنسَ نُن هَرُنَ نُ بَرَ عٍ تّنفّ عٍ شَبِلّ كِ مَ عَلْ عَلَتَلَ عٍ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «دِ شّمّ سِنفٍ بِرِن تّنفّ عِسِرَيِلَكَيٍ يَ مَ، نَشٍيٍ سِمَيَ بَرَ كِكٍ كٍرٍن لِ، عِ شَ عٍ شِلِيٍ سّبّ. ");
INSERT INTO susa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","لٍوِ بْنسْي شَ قِندِ عِسِرَيِلَ دِ شّمّ سِنفٍ بِرِن حْشْي رَ. لٍوِ بْنسْي شَ فْورّ شَ قِندِ عِسِرَيِلَكَيٍ شَ شُرُ سٍيٍ دِ سِنفٍيٍ حْشْي رَ. ﭑ تَن نَن نَ عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","مُنسَ نَشَ عِسِرَيِلَ دِ شّمّ سِنفٍ بِرِن تّنفّ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","عِسِرَيِلَ دِ شّمّ سِنفٍ بِرِن نَشٍيٍ شَ سِمَيَ بَرَ كِكٍ كٍرٍن لِ، عٍ شَسَبِ لَن مِشِ وُلُ مْشْحّن نُن قِرِن مِشِ كّمّ قِرِن تٌنفٌ سٌلٌقٍرٍ نُن سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«لٍوِ بْنسْي شَ قِندِ عِسِرَيِلَ دِ شّمّ سِنفٍ بِرِن حْشْي رَ. لٍوِ بْنسْي شَ فْورّ شَ قِندِ عِسِرَيِلَكَيٍ شَ شُرُ سٍيٍ دِ سِنفٍيٍ حْشْي رَ. ﭑ تَن نَن نَ عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","نَ عِسِرَيِلَ دِ شّمّ سِنفٍ مِشِ كّمّ قِرِن تٌنفٌ سٌلٌقٍرٍ نُن سَشَن نَشٍيٍ شَسَبِ دَنفِ لٍوِ بْنسْي كْنتِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","عِ شَ كَنكَن شُن سَرَ فبٍتِ فِرَ مُ تٌنفٌ سُولِ نُن سٌلٌقٍرٍ رَ نَشَن مْولِ رَوَلِمَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","عِ شَ نَ فبٍتِ سٌ هَرُنَ نُن عَ شَ دِ شّمّ يِ رَ، دِ سِنفٍيٍ شُنسَرٍ رَ نَشٍيٍ شَسَبِ نُ دَنفِ لٍوِ بْنسْي شَسَبِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","مُنسَ نَشَ نَ فبٍتِ سُشُ نَشَن قِشِ دِ سِنفٍيٍ شُنسَرٍ شَ قٍ رَ، نَشٍيٍ شَسَبِ نُ دَنفِ لٍوِ بْنسْي شَسَبِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","عَ نَشَ نَ فبٍتِ كِلٌ قُ نُن سُولِ نُن عَ تَفِ رَ سُشُ عِسِرَيِلَ دِ سِنفٍيٍ يِ رَ. فبٍتِ نَن عَ رَ نَشَن نُ رَوَلِمَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","مُنسَ نَشَ نَ شُنسَرٍ فبٍتِ سٌ هَرُنَ نُن عَ شَ دِ شّمّيٍ يِ رَ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«كٍهَتِ شَ دِيٍ تّنفّ لٍوِ بْنسْييٍ يَ مَ عَ شَبِلّ نُن عَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","كٍهَتِ شَ دِيٍ لَنمَ عٍ شَ مّينِ سٍ سّنِيّنشِيٍ مَ نَشٍيٍ نَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","عِسِرَيِلَكَيٍ نَ كٍلِ سِفَدٍ، هَرُنَ نُن عَ شَ دِ شّمّيٍ شَ دُفِ يَرَ سَ رَفٌرٌ، عٍ سَاتّ كَنكِرَ مَكٌتٌ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","نَ دَنفِ شَنبِ عٍ شَ قٌيٍ يّشّ كِرِ سَ نَ قَرِ، عَ نُن فّرّ دُفِ. عَ دْنشْي رَ عٍ شَ وُرِ كُيٍيٍ رَ سٌ كَنكِرَ تٌنفٌسٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«عٍ نَ فّرّ دُفِ فبّتّ عِتَلَ تٍيبِلِ مَ، عٍ شَ ثِلٍتِيٍ، تْنبِلِيٍ، نُن كُندِيٍ سَ نَ قَرِ، نَشٍيٍ رَوَلِمَ وّنِ سّرّشّيٍ رَ. تَامِ نَشَن بَمَ سّرّشّ رَ، نَ قَن سَمَ نّ نَ تٍيبِلِ نَن قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","عٍ دُفِ فبٍيلِ نَن سَمَ نَ بِرِن شُن مَ، عٍ قَ قٌيٍ يّشّ كِرِ عِتَلَ نَ قَرِ. نَ دَنفِ شَنبِ عٍ شَ وُرِ كُيٍيٍ رَ سٌ تٍيبِلِ تٌنفٌسٍيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«عٍ شَ فّرّ دُفِ دُ سُ لَنثُي دْشْسٍ، لَنثُييٍ، عَ يِرَبَسٍيٍ، شُبٍ سَسٍيٍ، نُن تُرٍ كُندِيٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","عٍ شَ نَ بِرِن مَقِلِن قٌيٍ يّشّ كِرِ نَن كُي، عٍ قَ عَ سَ شَنِنسٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","عٍ شَ فّرّ دُفِ عِتَلَ سّرّشّبَدٍ شّيمَ دَاشِ قَرِ، عٍ قَ عَ مَكٌتٌ قٌيٍ يّشّ كِرِ رَ، عٍ وُرِ كُيٍيٍ رَ سٌ عَ تٌنفٌسٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","نَ هْرْ مْلِنفِرَ رَشُنمَسٍ بِرِن مَكٌتٌمَ فَرّ دُفِ نَن نَ، عٍ عٍ مَقِلِن قٌيٍ يّشّ كِرِ كُي، عٍ قَ نَ سَ شَنِنسٍ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","عٍ شَ شُبٍ بَ سّرّشّبَدٍ وُرٍ فبٍيلِ دَاشِ كُي، عٍ قَ دُفِ فبٍيلِ دُ سُ عَ شُن نَ. ");
INSERT INTO susa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","عٍ نَ عَ يِرَبَسٍيٍ سَ عَ قَرِ، عَلْ سُرَيِ فَنسٍيٍ، سُشُمّيٍ، ثٍلِيٍ، نُن ثْوتِ شُنفبٍيٍ، عٍ شَ نَ بِرِن مَقِلِن قٌيٍ يّشّ كِرِ رَ، عٍ قَ وُرِ كُيٍيٍ رَ سٌ عَ تٌنفٌسٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","هَرُنَ نُن عَ شَ دِ شّمّيٍ نَ فّ نَ شُنمَسٍ سّنِيّنشِيٍ نُن عَ يِرَبَسٍيٍ مَكٌتٌدٍ، كٍهَتِ شَ دِيٍ لَنمَ عٍ شَ نَ بِرِن شَنِن بِيَاسِ كُي. كْنْ عٍ مُ لَنمَ عٍ شَ دِن نَ سٍ سّنِيّنشِيٍ رَ شَ نَ مُ عٍ قَشَمَ نّ. كٍهَتِ بْنسْييٍ شَ وَلِ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","هَرُنَ سّرّشّدُبّ شَ دِ شّمّ عٍلٍيَسَرِ نَن عَ حْشْ سَمَ لَنثُي تُرٍ، سُرَيِ، سَنسِ سّرّشّ، نُن تُرٍ سّنِيّنشِ شْن مَ. هْرْ مْلِنفِرَ رَشُنمَسٍ سّنِيّنشِيٍ نُن عَ يِرَبَسٍ بِرِن تَشُشِ عَ تَن نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«وٌ نَشَ لُ كٍهَتِ بْنسْي شَبِلّيٍ شَ بَ لٍوِ بْنسْي يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","هَرُنَ نُن عَ شَ دِ شّمّيٍ شَ عٍ مَتِ هْرْ مْلِنفِرَ كُي، عٍ قَ عٍ شَ وَلِ مَسٍن كَنكَن بّ عَلَكٌ عٍ نَشَ عٍ مَكْرّ سٍ سّنِيّنشِيٍ رَ، عٍ قَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","عٍ مُ لَن عٍ شَ عٍ يَ مَسَ سٍ سّنِيّنشِيٍ مَ، هَلِ دٌندٌرٌنتِ، شَ نَ مُ عٍ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«فٍرِ سٌن بْنسْي تّنفّ عَ شَبِلّ نُن عَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","فٍرِ سٌن شَبِلّ شَ وَلِ نَن يِ كِ. ");
INSERT INTO susa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","عٍ هْرْ مْلِنفِرَ مَقٍلٍنيِيٍ نَن شَنِنمَ، عَ نُن مَقٍلٍنيِ نَشَن يَءِلَنشِ قٌيٍ يّشّ كِرِ رَ، عَ نُن مَقٍلٍنيِ نَشَن فبَكُشِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","عٍ شَ تّتّ مَقٍلٍنيِيٍ قَن شَنِن نَشٍيٍ هْرْ مْلِنفِرَ نُن سّرّشّبَدٍ رَبِلِنمَ، عَ نُن نَشَن فبَكُشِ تّتّ سٌدٍ دّ رَ، عَ نُن تّتّ لُوتِيٍ. عٍ شَ عٍ حْشْ سَ نَ سٍ مْولِ بِرِن شْن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","فٍرِ سٌن شَبِلّ وَلِمَ هَرُنَ نُن عَ شَ دِ شّمّيٍ شَ يَامَرِ نَن بُن مَ، عَ قِندِ كٌتٍيٍ شَنِنقٍ رَ، عَ قِندِ وَلِ فبّتّ رَبَقٍ رَ. نٍيٍ نَن عَ قَلَمَ عٍ بّ عٍ لَن عٍ شَ نَشَن نَبَ، عَ نُن عٍ لَن عٍ شَ نَشَن شَنِن. ");
INSERT INTO susa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","فٍرِ سٌن بْنسْي شَ وَلِ نَن نَ كِ هْرْ مْلِنفِرَ شَ قٍ رَ. عٍ نَ وَلِ رَبَمَ هَرُنَ سّرّشّدُبّ شَ دِ شّمّ عِتَمَرِ شَ يَامَرِ نَن بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«عِ شَ مٍرَرِ بْنسْي قَن تّنفّ عَ شَبِلّ نُن عَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","سٍيٍ نَن يِ كِ عٍ تَن لَن عٍ شَ نَشٍيٍ مَشَنِن هْرْ مْلِنفِرَ سٍيٍ رَ؛ عَ شٍبٍنيِيٍ، عَ وُرِ كُيٍيٍ، عَ كْنتِفِبَيٍ، نُن عٍ سَنبُنيِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","عٍ شَ تّتّ قَن شَنِن، عَ نُن عَ كْنتِفِبَيٍ، عٍ سَنبُنيِيٍ، عٍ سْرْنسٍيٍ، عٍ شَ لُوتِيٍ، عٍ شَ يِرَبَسٍيٍ، نُن عٍ شَ وَلِسٍ بِرِن. وٌ سٍيٍ مَسٍن كَنكَن بّ، عَ لَنمَ عَ شَ نَشٍيٍ شَنِن. ");
INSERT INTO susa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","مٍرَرِ بْنسْييٍ شَ وَلِ بِرِن نَن نَ كِ هْرْ مْلِنفِرَ شَ قٍ رَ. عٍ وَلِمَ هَرُنَ سّرّشّدُبّ شَ دِ شّمّ عِتَمَرِ شَ يَامَرِ نَن بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","مُنسَ، هَرُنَ، نُن حَمَ كُنتِفِيٍ نَشَ كٍهَتِ شَ مِشِيٍ تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","شّمّ نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","عٍ شَسَبِ لَن مِشِ وُلُ قِرِن، مِشِ كّمّ سٌلٌقٍرٍ، تٌنفٌ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","شّمّيٍ نَن نَ كِ كٍهَتِ شَبِلّيٍ يَ مَ نَشٍيٍ هْرْ مْلِنفِرَ وَلِ رَبَمَ. مُنسَ نُن هَرُنَ بَرَ عٍ تّنفّ عَلْ عَلَتَلَ مُنسَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","عٍ نَشَ فٍرِ سٌن شَ مِشِيٍ تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","شّمّ نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","عٍ شَسَبِ لَن مِشِ وُلُ قِرِن، كّمّ سٍننِ، تٌنفٌ سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","شّمّيٍ نَن نَ كِ فٍرِ سٌن شَبِلّيٍ يَ مَ نَشٍيٍ هْرْ مْلِنفِرَ وَلِ رَبَمَ. مُنسَ نُن هَرُنَ بَرَ عٍ تّنفّ عَلْ عَلَتَلَ مُنسَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","عٍ نَشَ مٍرَرِ شَ مِشِيٍ تّنفّ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","شّمّ نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","عٍ شَسَبِ لَن مِشِ وُلُ سَشَن مِشِ كّمّ قِرِن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","شّمّيٍ نَن نَ كِ مٍرَرِ شَبِلّيٍ يَ مَ نَشٍيٍ هْرْ مْلِنفِرَ وَلِ رَبَمَ. مُنسَ نُن هَرُنَ بَرَ عٍ تّنفّ عَلْ عَلَتَلَ مُنسَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","مُنسَ، هَرُنَ، نُن عِسِرَيِلَ كُنتِفِيٍ، عٍ لٍوِ بْنسْي مِشِ نَشٍيٍ تّنفّشِ عٍ شَبِلّ نُن عٍ شَ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","شّمّ نَشٍيٍ شَ سِمَيَ بَرَ حّ تٌنفٌ سَشَن لِ هَن حّ تٌنفٌ سُولِ، نَشٍيٍ قَمَ هْرْ مْلِنفِرَ وَلِ رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","عٍ شَسَبِ لَن مِشِ وُلُ سٌلٌمَسَشَن، كّمّ سُولِ، تٌنفٌ سٌلٌمَسَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","شّمّيٍ نُن عٍ شَ وَلِيٍ نَن نَ كِ لٍوِ نَشٍيٍ تّنفّشِ مُنسَ نُن هَرُنَ سَابُي رَ عَلْ عَلَتَلَ مُنسَ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«عِسِرَيِلَكَيٍ يَمَرِ عٍ شَ كُنّ كَنيِ نُن كْرْ سِلَ كَنيِ بِرِن نَمِنِ عٍ يٌنكِندٍ، عَ نُن مِشِ نَشٍيٍ دِنشِ قُرٍ ندٍ رَ، عٍ قَ قِندِ سّنِيّنتَرٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","عَ قِندِ شّمّ رَ، عَ قِندِ فِنّ رَ، وٌ عٍ رَ مِنِ وٌ يَ مَ، عٍ شَ سَ لُ عٍ شَتِ مَ عَلَكٌ عٍ نَشَ سّنِيّنتَرٍحَ رَ سٌ وٌ يَ مَ، ﭑ سَبَتِشِ دّننَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","عِسِرَيِلَكَيٍ نَشَ عَ رَبَ عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ، عٍ نَشَ نَ مِشِيٍ رَ مِنِ عٍ يَ مَ. عَلَتَلَ عَ يَمَرِ كِ نَشّ مُنسَ بّ، عٍ نَشَ عَ رَبَ نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عَ قِندِ شّمّ رَ، عَ قِندِ فِنّ رَ، نَشَن يٌ نَ هَاكّ ندٍ رَبَ عَ بٌورٍ رَ، هَاكّ نَشَن قِندِ مَ عَلَتَلَ شُي مَتَندِقٍ رَ، نَ قٍ دْشْشِ عَ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","عَ لَن نّ عَ شَ عَ تِ نَ هَاكّ رَ، عَ شَ نَ قٍ يَءِلَن عَ نُن نَ كَنيِ تَفِ، عَ مَن قَ نَ قٍ كَنَشِ دْشْ سُولِ ندٍ سَ نَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","شَ عَ سَ لِ عَ هَاكّ رَبَشِ نَشَن نَ، عَ بَرَ قَشَ، عَ شَ مِشِ يٌ مُ نَ نَشَن نْمَ نَ قٍ يَءِلَنشِ رَ سُشُدٍ، نَ قِندِ مَ عَلَتَلَ نَن فبٍ رَ، عَ سٌ سّرّشّدُبّ يِ رَ. قٍ كَنّ مَن قَ يّشّي كٌنتٌنيِ كٍرٍن بَ عَ شَ يُنُبِ شَقَرِ رَ، عَ عَ سٌ سّرّشّدُبّ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","عِسِرَيِلَكَيٍ نَ سّرّشّ بَ، عٍ عَ قِ سّرّشّدُبّ مَ، نَ سّرّشّ قِندِ مَ نَ سّرّشّدُبّ نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","نَشَن بِرِن سّرّشّ بَمَ، عَ نَشَن بَمَ، عَ فبٍ نَن نَ كِ، كْنْ عَ نَشَن قِمَ سّرّشّدُبّ مَ، سّرّشّدُبّ فبٍ نَن نَ كِ.» ");
INSERT INTO susa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ يِ نَن نَبَمَ شَ فِنّ ندٍ سَ يّنّ رَبَ. ");
INSERT INTO susa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","شَ عٍ نُن شّمّ فبّتّ بَرَ عٍ سَ فُندٌ رَ، فِنّ شَ مْرِ مُ نَ كٌلٌن، سٍيدٍ مُ نَ، مِشِ مُ عَ سُشُ عَ كُي، ");
INSERT INTO susa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","كْنْ عَ شَ مْرِ بَرَ عَ شَ فِنّ تْونّ قْلْ، شَ عَ شَ فِنّ سّنِيّنشِ، شَ نَ مُ عَ مُ سّنِيّنشِ، ");
INSERT INTO susa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","عَ شَ عَ شَ فِنّ شَنِن سّرّشّدُبّ يِرٍ، عَ مّنفِ كِلٌ سَشَن بَ عَ بّ سّرّشّ رَ تُرٍ نُن سُرَيِ مُ نَ نَشَن شُن، بَرِ مَ تْونّ سّرّشّ نَن عَ رَ نَشَن بَمَ عَ كٌلٌنقٍ رَ شَ يُنُبِ رَبَشِ.» ");
INSERT INTO susa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«سّرّشّدُبّ شَ نَ فِنّ تِ عَلَتَلَ يَ عِ، ");
INSERT INTO susa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","عَ قَ شُبٍ مَكْ بْشِ مَ هْرْ مْلِنفِرَ كُي، عَ عَ مَسُنبُ يٍ سّنِيّنشِ رَ قّحّ كُي. ");
INSERT INTO susa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","فِنّ نَ تِ عَلَتَلَ يَ عِ، سّرّشّدُبّ شَ عَ شُنسّشّ قُلُن، عَ قَ تْونّ سّرّشّ سَ فِنّ بّلّشّ مَرَتُسٍ رَ. سّرّشّدُبّ تَن شَ نَ يٍ تٌنفٌ نَشَن قِندِ مَ دَنكَ رَ، عَ عَ لِنتَن فِنّ يَ عِ.» ");
INSERT INTO susa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","«سّرّشّدُبّ فِنّ رَكَلِمَ نّ، عَ عَ قَلَ، ‹شَ عَ سَ لِ عِ تَن نُن شّمّ فبّتّ مُ كَقُشِ، عِ مُ عِ شَ مْرِ يَنقَ، عِ مُ سّنِيّنتَرٍحَ سْتْ قُتِ كُي، عِ شَ رَتَنفَ دَنكّ مَ يِ يٍ قَمَ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","كْنْ شَ عَ سَ لِ، عِ بَرَ عِ شَ مْرِ يَنقَ وٌ شَ قُتِ كُي، عِ نُن شّمّ فبّتّ بَرَ كَقُ سّنِيّنتَرٍحَ كُي، ");
INSERT INTO susa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","عَلَتَلَ شَ عَ رَفِرِ عِ قُرِ شَ كَنَ. نَ كُي عِ نفَشَكٍرٍنيِيٍ عِ دَنكَمَ نّ، عٍ عِ كٌنبِ. ");
INSERT INTO susa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","يِ يٍ نَشَن قَمَ دَنكّ رَ، عَ شَ عِ قُرِ مَقُنتُ، عَ عِ شْرّ مَبَ.› فِنّ شَ عَ رَتِن عَ قَلَقٍ رَ، ‹عَمِنَ، عَمِنَ.›» ");
INSERT INTO susa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«سّرّشّدُبّ نَ فّ نَ دَنكّ سّبّدٍ كِرِ مَ، عَ شَ نَ كِرِ شَ نَ يٍ سّنِيّنشِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","عَ قَ عَ قِ فِنّ مَ، عَ شَ عَ مِن. نَ يٍ نَشَن نْمَ قِندِدٍ دَنكّ رَ، عَ سٌمَ عَ قَتٍ عِ. ");
INSERT INTO susa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","سّرّشّدُبّ تْونّ سّرّشّ رَ سُشُمَ نّ فِنّ يِ رَ، عَ عَ دّنتّفّ عَلَتَلَ بّ سّرّشّبَدٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","سّرّشّدُبّ شَ مّنفِ سُشُي كٍرٍن فَن سّرّشّبَدٍ قَرِ، عَ قِندِ سّرّشّ تْنشُمَ رَ. عَ نَ فّ نَ رَ، عَ شَ نَ يٍ قِ فِنّ مَ، عَ شَ عَ مِن. ");
INSERT INTO susa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","عَ نَ نَ يٍ مِن، شَ عَ سَ لِ نَ فِنّ بَرَ قِندِ سّنِيّنتَرٍ رَ، عَ بَرَ عَ شَ مْرِ يَنقَ، نَ يٍ نَشَن قِندِ مَ دَنكّ رَ، عَ سٌمَ نّ عَ قَتٍ عِ، عَ عَ تْورْ كِ قَنيِ رَ. عَ قُرِ قُنتُمَ نّ، عَ شْرّ مَبَمَ نّ، عَ نفَشَكٍرٍنيِيٍ قَمَ نّ عَ دَنكَدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","«كْنْ شَ عَ سَ لِ عَ مُ سّنِيّنتَرٍحَ يٌ رَبَشِ، تْوحّفّ بَمَ نّ عَ شُن مَ، عَ مَن نْمَ دِ بَرِدٍ. ");
INSERT INTO susa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","تْونّ سّرِيّ نَن نَ كِ نَشَن نَوَلِمَ شَ فِنّ قِندِ مَ سّنِيّنتَرٍ رَ، عَ عَ شَ مْرِ يَنقَ قُتِ كُي، ");
INSERT INTO susa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","شَ نَ مُ عَ رَ، تْونّ شَشِلِ نَ سٌ شّمّ قُرِ، عَ قَ سِيكّ عَ شَ فِنّ مَ. عَ عَ شَ فِنّ شَنِنمَ عَلَتَلَ يَ عِ، سّرّشّدُبّ قَ نَ سّرِيّ رَبَتُ عَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","نَ كُي يُنُبِ مُ نَ نَ شّمّ مَ، كْنْ فِنّ تَن عَ شَ يُنُبِ سَرٍ سْتْمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، شَ شّمّ ندٍ، شَ نَ مُ فِنّ ندٍ سَ لَايِدِ تٌنفٌ عَلَتَلَ بّ، عَ شَ لُ عَ سَفٌ، نَ نَن نَ كِ عَ شَ قِندِ نَسَرِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","نَ كَنيِ مُ لَن عَ شَ وّنِ نُن بٍيرٍ مِن. عَ نَشَ سٍسٍ مِن نَشَن كٍلِشِ وّنِ بٌفِ مَ، شَ نَ مُ بٍيرٍ مَ. عَ نَشَ وّنِ بٌفِ بُندَ دٌن، عَ نَشَ عَ شَرٍ دٌن. ");
INSERT INTO susa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","عَ تّمُي نَشَن بِرِن نَبَمَ عَ شَ نَسَرِيَ كُي، عَ نَشَ سٍسٍ دٌن نَشَن كٍلِ وّنِ بِلِ مَ، كٍلِ عَ بٌفِ مَ عَ سَ دْشْ عَ شْرِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«عَ شَ نَسَرِيَ كُي، عَ مُ لَنمَ عَ شُنيِ شَ بِ. عَ شَ لُ سّنِيّنيِ كُي، عَ شُنسّشّ شَ نُ كُيَ رَ تُن. ");
INSERT INTO susa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","نَ وَشَتِ بُن مَ، عَ مُ لَن عَ شَ عَ مَسٌ قُرٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","هَلِ عَ قِندِ عَ بَبَ رَ، عَ نفَ، عَ تَارَ، شَ نَ مُ عَ رَ عَ شُنيَ قُرٍ رَ. عَ نَ عَلَتَلَ نَن سَفٌ تُن، عَلْ عَ شُنسّشّ كّحَ عَ مَسٍنشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","عَ تّمُي نَشَن بِرِن نَبَمَ عَ شَ نَسَرِيَ كُي، عَ لُمَ سّنِيّنيِ نَن كُي عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«شَ مِشِ ندٍ سَ قَشَ عَ قّ مَ عَ تّرّننَ كِ مَ، عَ شُنسّشّ بَرَ قِندِ سٍ سّنِيّنتَرٍ رَ. نَ تّمُي عَ شَ سّنِيّن لْشُن كٍرٍن بُن مَ، عَ مَن قَ عَ شُنيِ بِ نَ شِ سٌلٌقٍرٍ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","عَ شِ سٌلٌمَسَشَن لْشْي، عَ قٌفٌتَرَ قِرِن نَن شَنِنمَ سّرّشّدُبّ شْن مَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، شَ نَ مُ فَنبّ قِرِن. ");
INSERT INTO susa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","سّرّشّدُبّ شْنِ كٍرٍن نَن بَمَ يُنُبِ شَقَرِ سّرّشّ رَ، بٌورٍ قِندِ مَ عَ فَن دَاشِ نَن نَ، عَلَكٌ عَ شَ يُنُبِ شَ شَقَرِ، بَرِ مَ عَ دِنقٍ قُرٍ رَ، نَ قِندِ مَ يُنُبِ نَن نَ. نَ لْشْي عَ مَن شَ عَ شُنيِ رَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","عَ نَ فّ نَ رَ، عَ مَن شَ فبِلٍن عَ شَ لَايِدِ مَ. قٌ عَ شَ يّشّي كٍرٍن بَ يّتّ رَفبِلٍن سّرّشّ رَ، نَشَن حّ كٍرٍن عَ رَ عَ شَ يُنُبِ شَقَرِقٍ رَ. لْشْي نَشٍيٍ بَرَ دَنفِ، نٍيٍ مُ كْنتِمَ سْنْن، بَرِ مَ عَ نُ بَرَ سّنِيّنتَرٍحَ سْتْ.» ");
INSERT INTO susa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«مِشِ نَ فّ نَسَرِيَ رَبَدٍ، عَ شَ بِرَ يِ سّرِيّ نَن قْشْ رَ. عَ شَ سِفَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","عَ شَ سّرّشّ فَن دَاشِ بَ عَلَتَلَ بّ، يّشّي نَشَن بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشَن مَ. عَ شَ يُنُبِ شَقَرِ سّرّشّ قَن بَ، يّشّي فِنّ نَشَن بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشَن مَ. عَ شَ شَنُنتٍيَ سّرّشّ بَ، يّشّي كٌنتٌنيِ، لَنيُرُ يٌ مُ نَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","عَ شَ سّرّشّ ندٍيٍ سَ نَ قَرِ، عَلْ سَنسِ شْرِ دِنشِ سّرّشّ، وّنِ سّرّشّ، تَامِ لّبِنِتَرٍ، لّكِ يَءِلَنشِ تُرٍ رَ، نُن لّكِ تُرٍ مَسٌشِ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","سّرّشّدُبّ نَ سّرّشّ سٍيٍ نَن دّنتّفّمَ عَلَتَلَ بّ، عَ قَ يُنُبِ شَقَرِ سّرّشّ بَ، عَ نُن سّرّشّ فَن دَاشِ. ");
INSERT INTO susa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","عَ شَ نَ تَامِ لّبِنِتَرٍ مَسٍن عَلَتَلَ بّ، عَ شَ نَ يّشّي كٌنتٌنيِ بَ شَنُنتٍيَ سّرّشّ رَ، عَ شَ سَنسِ شْرِ دِنشِ سّرّشّ نُن وّنِ سّرّشّ سَ نَ قَرِ.» ");
INSERT INTO susa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«نَ تّمُي نَسَرِ شَ عَ شُنسّشّ بِ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عَ نَشَن قِشِ عَلَتَلَ مَ. عَ شَ نَ رَ سٌ تّ شْورَ شَنُنتٍيَ سّرّشّ نَ بَقٍ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","نَسَرِ نَ فّ عَ شُنسّشّ بِدٍ، سّرّشّدُبّ يّشّي كٌنتٌنيِ بّلّشّ فَنشِ كٍرٍن نَن تٌنفٌمَ عَ بّلّشّ رَ، عَ نُن لّكِ لّبِنِتَرٍ قِرِن نَشٍيٍ نَ دٍبٍ كُي. ");
INSERT INTO susa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","عَ شَ عٍ دّنتّفّ عَلَتَلَ بّ عٍ لِنتَنقٍ رَ. نَ قِندِ دٌنسٍ سّنِيّنشِ نَن نَ سّرّشّدُبّ بّ، عَ نُن نَ يّشّي فَنيَنيِ نُن عَ تَبٍ. نَ دَنفِ شَنبِ، نَسَرِ نْمَ وّنِ مِندٍ سْنْن. ");
INSERT INTO susa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","نَسَرِ سّرِيّ نَن نَ كِ. عَ لَنمَ عَ شَ نَ سّرّشّيٍ بَ عَلَتَلَ بّ عَلْ عَ حَنِفٍشِ كِ نَشّ، عَ نُن سٍ فبّتّيٍ عَ نْمَ نَشَن نَ. قٌ عَ شَ عَ شَ نَسَرِ لَايِدِ رَكَمَلِ عَ سّرِيّ كِ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«عَ قَلَ هَرُنَ نُن عَ شَ دِيٍ بّ، عٍ شَ دُبَ عِسِرَيِلَكَيٍ بّ يِ كِ نّ؛ ");
INSERT INTO susa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹عَلَتَلَ شَ بَرَكَ سَ عِ شَ قٍ، عَ شَ عِ كَنتَ. ");
INSERT INTO susa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","عَلَتَلَ يَتَفِ شَ نْرْ عِ مَ، عَ شَ هِننّ عِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","عَلَتَلَ شَ عَ يَ رَقِندِ عِ مَ، عَ شَ بْحّسَ قِ عِ مَ.› ");
INSERT INTO susa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","عٍ دُبَمَ عِسِرَيِلَكَيٍ بّ نَ كِ نّ، ﭑ قَن بَرِكَ سَمَ نّ عٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","مُنسَ تٌ فّ هْرْ مْلِنفِرَ تِدٍ، عَ نَشَ تُرٍ سّنِيّنشِ سَ عَ مَ، عَ نُن عَ شُنمَسٍيٍ، عَ شَ سّرّشّبَدٍيٍ، نُن عَ يِرَبَسٍيٍ، عَلَكٌ نٍيٍ شَ سّنِيّن عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","عِسِرَيِلَ كُنتِفِيٍ، شَبِلّ شُنيِ نَشٍيٍ بْنسْييٍ تّنفّ، عٍ نَشَ هَدِيَيٍ بَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","عٍ نَشَ قَ سَرّتِ مَكٌتٌشِ سٍننِ نُن نِنفٍ قُ نُن قِرِن نَ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، عٍ شَ قِندِ عٍ شَ سّرّشّ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«يِ هَدِيَيٍ رَ سُشُ عٍ يِ رَ هْرْ مْلِنفِرَ وَلِ شَ قٍ رَ. عٍ تَشُ لٍوِ بْنسْي شَ مِشِيٍ رَ كَنكَن شَ وَلِ بّرّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","مُنسَ نَشَ نَ سَرّتِيٍ نُن نِنفٍيٍ سٌ لٍوِ شَ مِشِيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","عَ نَشَ سَرّتِ قِرِن نُن نِنفٍ نَانِ سٌ فٍرِ سٌن شَبِلّ يِ رَ عٍ شَ وَلِ بّرّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","عَ نَشَ سَرّتِ نَانِ نُن نِنفٍ سٌلٌمَسَشَن سٌ مٍرَرِ شَبِلّ يِ رَ عٍ شَ وَلِ بّرّ رَ. عٍ نُ نَ هَرُنَ سّرّشّدُبّ شَ دِ عِتَمَرِ شَ يَامَرِ نَن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","كْنْ عَ مُ سٍسٍ سٌ كٍهَتِ شَبِلّ تَن يِ، بَرِ مَ عَ نُ لَنمَ عٍ شَ سٍ سّنِيّنشِيٍ مَشَنِن عٍ تُنكِ قَرِ عَلْ عَلَتَلَ عٍ يَمَرِشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","سّرّشّبَدٍ نّينّ شَ وَلِ سِنفٍ، تُرٍ سّنِيّنشِ تٌ مَسٌ عَ مَ تّمُي نَشّ، كُنتِفِيٍ نَشَ قَ عٍ شَ سّرّشّيٍ رَ سّرّشّبَدٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ، «لْشْي يٌ لْشْي مِشِ كٍرٍن شَ قَ عَ شَ هَدِيَ رَ سّرّشّبَدٍ نّينّ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","نَ لْشْي سِنفٍ، عَمِنَدَبٌ شَ دِ نَشَسٌن كٍلِقٍ يُدَ بْنسْي، ");
INSERT INTO susa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. عَمِنَدَبٌ شَ دِ نَشَسٌن شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","نَ لْشْي قِرِن ندٍ، سُوَرَ شَ دِ نٍتَنٍيلِ كٍلِقٍ عِسَكَرِ بْنسْي، ");
INSERT INTO susa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. سُوَرَ شَ دِ نٍتَنٍيلِ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","نَ لْشْي سَشَن ندٍ، شٍلٌن شَ دِ عٍلِيَبِ كٍلِقٍ سَبُلٌن بْنسْي، ");
INSERT INTO susa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. شٍلٌن شَ دِ عٍلِيَبِ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","نَ لْشْي نَانِ ندٍ، سٍدٍيُرِ شَ دِ عٍلِسُرُ كٍلِقٍ رُبٍن بْنسْي، ");
INSERT INTO susa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. سٍدٍيُرِ شَ دِ عٍلِسُرُ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","نَ لْشْي سُولِ ندٍ، سُرِ سَدَيِ شَ دِ سٍلُمِيٍلِ كٍلِقٍ سِمٍيْن بْنسْي، ");
INSERT INTO susa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. سُرِ سَدَيِ شَ دِ سٍلُمِيٍلِ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","نَ لْشْي سٍننِ ندٍ، دُوٍلِ شَ دِ عٍلِيَسَقَ قَتَنقٍ فَدِ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. دُوٍلِ شَ دِ عٍلِيَسَقَ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","نَ لْشْي سٌلٌقٍرٍ ندٍ، عَمِشُدِ شَ دِ عٍلِسَمَ قَتَنقٍ عٍقِرَ مِ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. عَمِشُدِ شَ دِ عٍلِسَمَ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","نَ لْشْي سٌلٌمَسَشَن ندٍ، ثٍدَ سُرُ شَ دِ فَمَلِيّلِ قَتَنقٍ مَنَسِ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. ثٍدَ سُرُ شَ دِ فَمَلِيّلِ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","نَ لْشْي سٌلٌمَنَانِ ندٍ، فِدٍيٌنِ شَ دِ عَبِدَن قَتَنقٍ بُنيَمِن بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. فِدٍيٌنِ شَ دِ عَبِدَن شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","نَ لْشْي قُ ندٍ، عَمِسَدَيِ شَ دِ عَشِيٍسٍرِ قَتَنقٍ دَنَ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. عَمِسَدَيِ شَ دِ عَشِيٍسٍرِ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","نَ لْشْي قُ نُن كٍرٍن ندٍ، عٌكِرَن شَ دِ ثَفِيّلِ قَتَنقٍ عَسٍرِ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. عَمِنَدَبٌ شَ دِ نَشَسٌن شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","نَ لْشْي قُ نُن قِرِن ندٍ، عٍنَن شَ دِ عَشِرَ قَتَنقٍ نَقَتَلِ بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","عَ نَشَ قَ يِ هَدِيَيٍ رَ؛ ثِلٍتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ قُ نُن سُولِ رَ، عَ نُن ثْوتِ كٍرٍن نَشَن يَءِلَنشِ فبٍتِ كِلٌ كٍرٍن نَ عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. عٍ قِرِن نَقٍشِ سَنسِ شْرِ دِنشِ رَ، تُرٍ مَسُنبُشِ نَشَن نَ، عَلَكٌ عَ شَ قِندِ سَنسِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","عَ مَن نَشَ قَ ثْوتِ كٍرٍن نَ نَشَن يَءِلَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ رَ، نَشَن نَقٍشِ سُرَيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","عَ نُن نَشٍيٍ بَمَ سّرّشّ فَن دَاشِ رَ عَلْ تُورَ كٍرٍن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي كٍرٍن نَشَن شَ سِمَيَ بَرَ حّ كٍرٍن لِ، ");
INSERT INTO susa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ، ");
INSERT INTO susa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","عَ نُن نَشٍيٍ بَمَ شَنُنتٍيَ سّرّشّ رَ عَلْ نِنفٍ قِرِن، يّشّي كٌنتٌنيِ سُولِ، نُن يّشّي سُولِ نَشٍيٍ شَ سِمَيَ بَرَ حّ كٍرٍن لِ. عٍنَن شَ دِ عَشِرَ شَ هَدِيَ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","عِسِرَيِلَ كُنتِفِيٍ شَ هَدِيَ مَلَنشِيٍ قِندِشِ يِ نَن نَ سّرّشّبَدٍ نّينّ شَ قٍ رَ؛ ثِلٍتِ فبٍتِ دَاشِ قُ نُن قِرِن، ثْوتِ فبٍتِ دَاشِ قُ نُن قِرِن، نُن ثْوتِ شّيمَ دَاشِ قُ نُن قِرِن. ");
INSERT INTO susa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ثِلٍتِ كٍرٍن كٍرٍن لَنشِ فبٍتِ كِلٌ كٍرٍن نُن عَ تَفِ نَن مَ. ثْوتِ كٍرٍن كٍرٍن لَنشِ فبٍتِ كِلٌ كٍرٍن نَن مَ. سٍ نَشٍيٍ يَءِلَنشِ فبٍتِ رَ، نٍيٍ لَنشِ كِلٌ مْشْحّن نُن نَانِ نَن مَ، عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ثْوتِ شّيمَ دَاشِ قُ نُن قِرِن لَنشِ شّيمَ فِرَ مُ كّمّ فِرَ مُ قُ نُن نَانِ نَن مَ، عَلْ سٍ مَنِيَمَ كِ نَشّ هْرْ مْلِنفِرَ كُي. نَ ثْوتِ قُ نُن قِرِن لَنشِ شّيمَ كِلٌ كٍرٍن نُن عَ تَفِ نَن مَ. عٍ بِرِن نَقٍشِ سُرَيِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","سّرّشّ فَن دَاشِ شُرُ سٍ شَسَبِ نَشَ لَن تُورَ قُ نُن قِرِن مَ، عَ نُن يّشّي كٌنتٌنيِ قُ نُن قِرِن، نُن يّشّي قُ نُن قِرِن نَشٍيٍ شَ سِمَيَ نُ بَرَ حّ كٍرٍن لِ، عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ سّرّشّ. يُنُبِ شَقَرِ سّرّشّ شُرُ سٍ شَسَبِ نَشَ لَن سِكْتّ قُ نُن قِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","شَنُنتٍيَ سّرّشّ شَ شُرُ سٍ شَسَبِ نَشَ لَن تُورَ مْشْحّن نُن نَانِ مَ، يّشّي كٌنتٌنيِ تٌنفٌ سٍننِ، سِكْتّ تٌنفٌ سٍننِ، نُن يّشّي تٌنفٌ سٍننِ نَشٍيٍ بَرَ حّ كٍرٍن سْتْ. نٍيٍ نَن قِندِ هَدِيَيٍ رَ سّرّشّبَدٍ شَ وَلِ قْلْ تّمُي، تُرٍ سّنِيّنشِ تٌ سَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","مُنسَ تٌ سٌ هْرْ مْلِنفِرَ كُي، عَ نُن عَلَتَلَ شَ سُمُن، عَ نَشَ عَلَتَلَ شُي مّ سَاتّ كَنكِرَ دّرَكٌتٍ قَرِ، عَ مَسٍنيِ تِمَ عَ بّ مَلٍكّ قِرِنيِيٍ سَوُرّ تَفِ نَشٍيٍ نَ نَ كَنكِرَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«عَ قَلَ هَرُنَ بّ، عَ شَ لَنثُي سٌلٌقٍرٍ دْشْ عَلَكٌ عٍ شَ يَنبَ عٍ دْشْسٍ يَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","هَرُنَ عَ رَبَ نَ كِ نّ. عَ نَشَ لَنثُي دْشْ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","لَنثُييٍ دْشْسٍ نُ رَقَلَشِ شّيمَ دِنشِ نَن نَ، كٍلِقٍ عَ سَنبُنيِ مَ هَن عَ شُنيِ، عَلْ عَلَتَلَ عَ مَسٍنشِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«لٍوِ بْنسْي بَ عِسِرَيِلَكَيٍ يَ مَ، عِ شَ عٍ رَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","عِ عٍ رَ سّنِيّنمَ يِ كِ نّ. مَرَ سّنِيّن يٍ مَكَسَن عٍ مَ. عٍ شَ عٍ قَتٍ مَشَبٍ بِرِن بِ، عٍ شَ عٍ شَ دُفِيٍ شَ، عَلَكٌ عٍ شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","نَ شَنبِ، عٍ شَ تُورَ كٍرٍن بَ سّرّشّ رَ، عَ نُن مّنفِ نَشَن مَسُنبُشِ تُرٍ رَ. عِ شَ تُورَ فبّتّ بَ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","عِ شَ لٍوِ بْنسْي نُن عِسِرَيِلَكَ بِرِن مَلَن هْرْ مْلِنفِرَ سٌدٍ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","مّننِ، عَلَتَلَ يَ شْرِ، عِسِرَيِلَكَيٍ شَ عٍ بّلّشّ سَ لٍوِ بْنسْي مِشِيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","هَرُنَ نَن قَمَ عٍ دّنتّفّدٍ عَلَتَلَ بّ عٍ شَ لُ عَلْ سّرّشّ عِسِرَيِلَكَيٍ حْشْي رَ. نَ كُي عٍ نْمَ عَلَتَلَ شَ وَلِ رَبَدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«لٍوِ بْنسْي مِشِيٍ شَ عٍ بّلّشّ سَ نَ تُورَ قِرِنيِيٍ مَ. كٍرٍن بَمَ يُنُبِ شَقَرِ سّرّشّ نَن نَ، بٌورٍ بَ سّرّشّ فَن دَاشِ رَ، عَلَكٌ عٍ شَ يُنُبِيٍ شَ شَقَرِ. ");
INSERT INTO susa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","لٍوِ بْنسْي نَ تِ هَرُنَ نُن عَ شَ دِيٍ يَ عِ، عِ شَ عٍ دّنتّفّ عَ سّرّشّ كِ مَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","عَ لِمَ نّ، نَ تّمُي، عِ بَرَ لٍوِ بْنسْي تَن بَ عِسِرَيِلَكَيٍ يَ مَ، عٍ شَ قِندِ ﭑ فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«عِ نَ فّ عٍ رَ سّنِيّندٍ عَ سّرّشّ كِ مَ، لٍوِ بْنسْي قَمَ نّ سٌدٍ عٍ شَ هْرْ مْلِنفِرَ وَلِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","عِسِرَيِلَكَيٍ نَن عٍ رَ نَشٍيٍ قِندِشِ ﭑ فبٍ رَ عِسِرَيِلَ دِ سِنفٍ بِرِن حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","عِسِرَيِلَ دِ سِنفٍ بِرِن نُن عٍ شَ شُرُ سٍ دِ سِنفٍ بِرِن قِندِشِ ﭑ فبٍ نَن نَ، كَقِ ﭑ سَ مِسِرَكَيٍ شَ دِ سِنفٍ بِرِن قَشَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ﭑ نَشَ لٍوِ بْنسْي تٌنفٌ عِسِرَيِلَ دِ سِنفٍ بِرِن حْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ﭑ بَرَ عٍ سٌ هَرُنَ نُن عَ شَ دِيٍ يِ رَ عِسِرَيِلَكَيٍ تَفِ، عَلَكٌ عٍ شَ هْرْ مْلِنفِرَ وَلِ رَبَ عِسِرَيِلَكَيٍ شِلِ رَ. عٍ مَن شَ يُنُبِ شَقَرِ سّرّشّ بَ عِسِرَيِلَكَيٍ بّ، عَلَكٌ فبَلٌي يٌ نَشَ فٌرٌ عِسِرَيِلَكَيٍ مَ عٍ نَ مَكْرّ يِرٍ سّنِيّنشِ رَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","مُنسَ، هَرُنَ، نُن حَمَ بِرِن نَشَ نَ رَبَ لٍوِ بْنسْي رَ عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","لٍوِ بْنسْي نَشَ عٍ يّتّ رَ سّنِيّن، عٍ نَشَ عٍ شَ دُفِيٍ شَ. هَرُنَ نَشَ عٍ دّنتّفّ عَلَتَلَ بّ. عَ نَشَ عٍ شَ يُنُبِ شَقَرِ سّرّشّ بَ عٍ بّ عٍ شَ سّنِيّن. ");
INSERT INTO susa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","نَ تٌ بَ عَ رَ، لٍوِ بْنسْي نَشَ قَ عٍ شَ وَلِ سُشُ هْرْ مْلِنفِرَ شَ قٍ رَ هَرُنَ نُن عَ شَ دِيٍ شَ يَامَرِ بُن مَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«لٍوِ بْنسْي مِشِيٍ شَ سِمَيَ نَ حّ مْشْحّن نُن سُولِ لِ، عٍ نْمَ هْرْ مْلِنفِرَ وَلِ سُشُدٍ. ");
INSERT INTO susa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","عٍ نَ حّ تٌنفٌ سُولِ سْتْ، عٍ شَ نَ وَلِ لُ نَا. ");
INSERT INTO susa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","عٍ نْمَ عٍ نفَشَكٍرٍنيِيٍ مَلِدٍ نَ وَلِ كُي، كْنْ عٍ تَن مُ نْمَ نَ رَبَدٍ سْنْن. عِ شَ نَ سّرِيّيٍ سُشُ لٍوِ بْنسْي شَ قٍ رَ هْرْ مْلِنفِرَ وَلِ رَبَقٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","عِسِرَيِلَكَيٍ تٌ مِنِ مِسِرَ بْشِ مَ، عٍ قَ لُ فبٍنفبٍرٍن يِرٍ حّ قِرِن، نَ كِكٍ سِنفٍ عَلَتَلَ نُ بَرَ عَ مَسٍن مُنسَ بّ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«عِسِرَيِلَكَيٍ شَ سَيَمَلٍكّ دَنفِ سَلِ رَبَ ");
INSERT INTO susa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","يِ كِكٍ شِ قُ نُن نَانِ، سٌفٍ دُلَ تّمُي عَلْ عَ يَمَرِشِ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","مُنسَ نَشَ عَ قَلَ عِسِرَيِلَكَيٍ بّ، عَ عٍ شَ سَيَمَلٍكّ دَنفِ سَلِ رَبَ. ");
INSERT INTO susa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","عٍ نَشَ نَ سَلِ رَبَ كِكٍ سِنفٍ شِ قُ نُن نَانِ سٌفٍ دُلَ تّمُي تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ. عٍ نَشَ عَ رَبَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","كْنْ نَ لْشْي، مِشِ ندٍيٍ مُ نْ سَيَمَلٍكّ دَنفِ سَلِ رَبَ بَرِ مَ عٍ نُ بَرَ دِن مِشِ قُرٍ رَ، عٍ قَ قِندِ سّنِيّنتَرٍ رَ نَ لْشْي. نَ لْشْي كٍرٍنيِ عٍ نَشَ سِفَ مُنسَ نُن هَرُنَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","عٍ عَ قَلَ عٍ بّ، «مُشُ مُ سّنِيّن قُرٍ شَ قٍ رَ، كْنْ مُنقٍ رَ مُشُ مُ لَن مُشُ شَ قَ مُشُ شَ هَدِيَ رَ عَلَتَلَ بّ عَلْ عِسِرَيِلَكَ بِرِن؟» ");
INSERT INTO susa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","مُنسَ نَشَ عٍ يَابِ، «وٌ مَمّ تِ سِندٍن، ﭑ شَ عَ مَتٌ عَلَتَلَ نَشَن يَمَرِ مَ وٌ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«شَ وٌ مُ سّنِيّن قُرٍ ندٍ شَ قٍ رَ، شَ نَ مُ عَ رَ وٌ نَ بِيَاسِ كُي، وٌ مَن نْمَ سَيَمَلٍكّ دَنفِ سَلِ رَبَدٍ عَلَتَلَ شَ بِنيّ بُن مَ، كٍلِ وٌ تَن مَ هَن عَ سَ وٌ بْنسْي لِ. ");
INSERT INTO susa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","كْنْ عٍ تَن شَ عَ رَبَ كِكٍ قِرِن ندٍ شِ قُ نُن نَانِ سٌفٍ دُلَ تّمُي. عٍ يّشّي دٌن عَ نُن تَامِ لّبِنِتَرٍ نُن بُرّشّ شْنّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","عَ دْنشْي يٌ نَشَ لُ هَن فّيسّفّ. عَ شْرِ قَن مُ عِبْو مَ. عٍ شَ نَ سَلِ رَبَ عَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","كْنْ شَ مِشِ سّنِيّنشِ نَشَن مُ نَ بِيَاسِ كُي، عَ تٌندِ سَيَمَلٍكّ دَنفِ سَلِ رَبَدٍ، نَ كَنيِ لَنمَ عَ شَ بَ عَلَتَلَ شَ حَمَ يَ مَ، بَرِ مَ عَ مُ قَ هَدِيَ رَ عَلَتَلَ بّ عَ وَشَتِ. نَ كَنيِ قَمَ نّ عَ شَ يُنُبِ سَرٍ سْتْدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«شَ عِ شَ شْحّ ندٍ وَ مَ سَيَمَلٍكّ دَنفِ سَلِ رَبَقٍ، عَ شَ عَ رَبَ عَ سّرِيّ كِ مَ. سّرِيّ نَشَن سَشِ تَا كَنيِيٍ مَ، نَ سّرِيّ كٍرٍنيِ نَن لُمَ نَ شْحّ قَن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","هْرْ مْلِنفِرَ تِ لْشْي، سَاتّ وَلَشّيٍ نَ دّننَشّ، نُشُي ندٍ نَشَ دُ سُ نَ شُن نَ. كٍلِ نُنمَرٍ هَن كُيٍ عِبَ، عَ نُ نَ هْرْ مْلِنفِرَ قَرِ، عَ مَنِيَشِ تّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","تّمُي بِرِن عَ نُ نَ نَ كِ نّ، نُشُي نُ نَ هْرْ مْلِنفِرَ قَرِ يَنيِ رَ، عَ قَ يَنبَ عَلْ تّ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","نُشُي نّقّ كٍلِ هْرْ مْلِنفِرَ شُن مَ، عِسِرَيِلَكَيٍ قَن بَرَ كٍلِ، عٍ حّرّ قْلْ هَن عَ فٌرٌ، عٍ قَ يٌنكِن مّننِ. ");
INSERT INTO susa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","نَ كُي عِسِرَيِلَكَيٍ نُ حّرّ مَ عَلَتَلَ شَ يَامَرِ نَن بُن مَ، عٍ مَن نُ يٌنكِنمَ عَلَتَلَ شَ يَامَرِ نَن مَ. قَننِ نُشُي نَ هْرْ مْلِنفِرَ شُن مَ، عٍ قَن يٌنكِنمَ مّننِ نّ. ");
INSERT INTO susa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","شَ نُشُي سَ بُ هْرْ مْلِنفِرَ قَرِ عَ فبٍ رَ، عِسِرَيِلَكَيٍ نُ بِرَ مَ عَلَتَلَ شَ يَامَرِ نَن قْشْ رَ، عٍ لُ مّننِ. ");
INSERT INTO susa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","تّمُي ندٍيٍ نَ نُشُي مُ بُمَ، عَ كٍلِ. عِسِرَيِلَكَيٍ نُ لُمَ عَلَتَلَ شَ يَامَرِ نَن بُن مَ، عٍ قَن كٍلِ، عٍ يٌنكِن نُشُي يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","تّمُي ندٍيٍ نُشُي بَرَ لُ يِرٍ شِ كٍرٍن، كٍلِ كْي رَ هَن كُيٍ عِبَ، عَ قَ سِفَ. عَ نّقّ كٍلِ، عِسِرَيِلَكَيٍ قَن بَرَ كٍلِ، عٍ بِرَ عَ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","شَ نُشُي لُ هْرْ مْلِنفِرَ شُن مَ شِ قِرِن، شَ نَ مُ كِكٍ كٍرٍن، شَ نَ مُ حّ كٍرٍن، عِسِرَيِلَكَيٍ مُ نُ كٍلِمَ عٍ يٌنكِندٍ، قٌ نَ نُشُي نَ كٍلِ هْرْ مْلِنفِرَ شُن مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","عٍ نُ يٌنكِنمَ عَلَتَلَ شَ يَامَرِ نَن بُن مَ، عٍ نُ كٍلِمَ عَلَتَلَ شَ يَامَرِ نَن بُن مَ. عٍ نُ بِرَ مَ عَلَتَلَ شَ يَامَرِ نَن قْشْ رَ، عَ نَشَن قِشِ مُنسَ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«عِ شَ سَرَ قِرِن يَءِلَن فبٍتِ بْنبْشِ رَ. عٍ رَوَلِمَ حَمَ شِلِقٍ نَن نَ مَلَنيِ. عٍ مَن نَوَلِمَ حَمَ كٍلِقٍ نَن نَ بِيَاسِ تّمُي. ");
INSERT INTO susa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","عٍ قِرِن نَ قٍ تّمُي كٍرٍن، حَمَ بِرِن شَ مَلَن عِ يِرٍ هْرْ مْلِنفِرَ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","شَ سَرَ كٍرٍن نَن قٍ، عِسِرَيِلَ يَرٍرَتِيٍ نُن كُنتِفِيٍ فبَنسَن شَ مَلَن عِ يِرٍ.» ");
INSERT INTO susa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","«وٌ كٍلِمَ بِيَاسِدٍ تّمُي نَشّ، سَرَيٍ شَ قٍ كٍرٍن. نَ كُي نَشٍيٍ دْشْشِ سٌفٍتٍدٍ، عٍ شَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","سَرَيٍ نَ قٍ قِرِن، نَشٍيٍ دْشْشِ يِرٍقَنيِ مَ، نٍيٍ قَن شَ سِفَ. سَرَ شُي نَن عَ مَسٍنمَ حَمَ سِفَ تّمُي بَرَ عَ لِ. ");
INSERT INTO susa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","سَرَ شُي كّحَ فبّتّ نَن عَ مَسٍنمَ حَمَ مَلَن تّمُي بَرَ عَ لِ.» ");
INSERT INTO susa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«هَرُنَ بْنسْي سّرّشّدُبّيٍ نَن نَ سَرَيٍ قٍمَ. سّرِيّ نَن نَ رَ وٌ تَن نُن وٌ بْنسْييٍ بّ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","وٌ نَ وٌ يَشُييٍ فٍرٍ وٌ شَ بْشِ مَ تّمُي نَشّ، وٌ شَ نَ سَرَيٍ قٍ. عَلَتَلَ حْشْ سَمَ نّ وٌ شْن، عَ وٌ رَتَنفَ وٌ يَشُييٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","وٌ شَ سَلِ لْشْي شُنفبٍيٍ نُن وٌ شَ كِكٍ نّينّ سَلِ لْشْييٍ، وٌ مَن شَ نَ سَرَيٍ قٍ وٌ سّرّشّ فَن دَاشِيٍ نُن شَنُنتٍيَ سّرّشّيٍ بَمَ تّمُي نَشّ. نَ نَن عَ نِيَمَ، ﭑ نَن ﭑ حْشْ سَمَ وٌ شْن مَ. ﭑ تَن نَن نَ وٌ مَرِفِ عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","حّ قِرِن ندٍ كِكٍ قِرِن ندٍ شِ مْشْحّن لْشْي، نُشُي نَشَن نُ دْشْشِ هْرْ مْلِنفِرَ شُن مَ، عَلَ شَ سٍيدٍ نُ نَ دّننَشّ، عَ نَشَ حّرّ قْلْ. ");
INSERT INTO susa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","نَ كُي عِسِرَيِلَكَيٍ نَشَ كٍلِ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ، عٍ بِرَ نَ نُشُي قْشْ رَ هَن عَ سَ تِ ثَرَن فبٍنفبٍرٍنيِ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","عَلَتَلَ نَشَ عٍ يَمَرِ عَننَبِ مُنسَ سَابُي رَ، عٍ شَ نَ بِيَاسِ سِنفٍ قْلْ. ");
INSERT INTO susa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","يُدَ بْنسْي نَشَ تِ يَرٍ، عٍ شَ تْنشُمَ تِشِ عٍ يَ رَ. عٍ شُنيِ نُ نَ عَمِنَدَبٌ شَ دِ شّمّ نَشَسٌن نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","سُوَرَ شَ دِ شّمّ نٍتَنٍيلِ نَن نُ نَ عِسَكَرِ بْنسْي شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","شٍلٌن شَ دِ شّمّ عٍلِيَبِ نَن نُ نَ سَبُلٌن بْنسْي شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","هْرْ مْلِنفِرَ تٌ مَقَفَتِ، فٍرِ سٌن شَ دِ شّمّيٍ نُن مٍرَرِ شَ دِ شّمّيٍ نَشَ عَ شَنِن. ");
INSERT INTO susa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","رُبٍن بْنسْي نَشَ بِرَ عٍ قْشْ رَ، عٍ شَ تْنشُمَ تِشِ عٍ يَ رَ. سٍدٍيُرِ شَ دِ شّمّ عٍلِسُرُ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","سِمٍيْن بْنسْي نَشَ بِرَ عٍ قْشْ رَ. سُرِ سَدَيِ شَ دِ شّمّ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","فَدِ بْنسْي نَشَ بِرَ عٍ قْشْ رَ. دُوٍلِ شَ دِ شّمّ عٍلِيَسَقَ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","كٍهَتِ شَبِلّ نَشَ بِرَ عٍ قْشْ رَ هْرْ مْلِنفِرَ سٍ سّنِيّنشِيٍ رَ. بٌورٍيٍ تَن لَن نّ عٍ شَ هْرْ مْلِنفِرَ تِ بٍينُ كٍهَتِ شَبِلّ شَ سٌ. ");
INSERT INTO susa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","عٍقِرَ مِ بْنسْي نَشَ بِرَ عٍ قْشْ رَ، عٍ شَ تْنشُمَ تِشِ عٍ يَ رَ. عَمِشُدِ شَ دِ شّمّ عٍلِسَمَ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","مَنَسِ بْنسْي نَشَ بِرَ عٍ قْشْ رَ. ثٍدَ سُرُ شَ دِ شّمّ فَمَلِيّلِ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","فِدٍيٌنِ شَ دِ شّمّ عَبِدَن نَن نُ نَ بُنيَمِن بْنسْي شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","دَنَ بْنسْييٍ نَشَ حّرّ عٍ بِرِن شَنبِ رَ، عٍ شَ تْنشُمَ تِشِ عٍ يَ رَ. عَمِسَدَيِ شَ دِ شّمّ عَشِيٍسٍرِ نَن نُ نَ عٍ شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","عٌكِرَن شَ دِ شّمّ ثَفِيّلِ نَن نُ نَ عَسٍرِ بْنسْي شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","عٍنَن شَ دِ شّمّ عَشِرَ نَن نُ نَ نَقَتَلِ بْنسْي شُنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","عِسِرَيِلَكَيٍ نُ حّرّ مَ نَ كِ نّ عٍ فَلِ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","مُنسَ نَشَ عَ قَلَ عَ بِتَنيِ رٍيُوٍلِ مَدِيَنكَ شَ دِ شّمّ شٌبَبٌ بّ، «مُشُ نَ سِفَقٍ عَلَتَلَ دّننَشَن لَايِدِشِ مُشُ بّ. عِ قَن شَ قَ. نَ قِندِ مَ سْونّيَ نَن نَ عِ بّ، بَرِ مَ عَلَتَلَ بَرَ لَايِدِ تٌنفٌ عَ قٍ قَنيِيٍ رَبَمَ نّ عِسِرَيِلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","شٌبَبٌ نَشَ عَ يَابِ، «عَدٍ، ﭑ شَ فبِلٍن ﭑ شْنيِ ﭑ مَ مِشِيٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","مُنسَ نَشَ عَ مَشَندِ، «يَندِ، عِ نَشَ كٍلِ مُشُ شُن مَ. عِ تَن نَن يِ فبٍنفبٍرٍنيِ بِرِن كٌلٌن مُشُ نْمَ يٌنكِندٍ دّننَشّ. عِ قِندِ مَ مُشُ رَحّرّ مَ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","شَ عِ مُشُ مَتِمَ، مُشُ عِ كِمَ نّ هّيرِ رَ عَلَتَلَ قَمَ نَشَن قِدٍ مُشُ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","عٍ نَشَ كٍلِ عَلَتَلَ شَ فٍيَ بُن مَ، عٍ شِ سَشَن حّرّ رَبَ. عَلَتَلَ شَ سَاتّ كَنكِرَ نُ تِشِ عٍ يَ رَ نَ شِ سَشَن بُن مَ يٌنكِندٍ قٍنقٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","عٍ تٌ نُ كٍلِمَ عٍ يٌنكِندٍ، عَلَتَلَ شَ نُشُي نُ تِشِ عٍ شُن مَ قّيحّنيِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","عٍ تٌ نُ سَاتّ كَنكِرَ رَكٍلِمَ تّمُي نَشّ، مُنسَ نُ عَ قَلَمَ، «عَلَتَلَ، عِ شَ كٍلِ، عِ شَ عِ يَشُييٍ رَيٍنسٍن. نَشٍيٍ عِ شْنشِ، نٍيٍ قَن شَ عٍ فِ عِ يَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","عٍ تٌ نُ سَاتّ كَنكِرَ رَفٌرٌ مَ تّمُي نَشّ، مُنسَ نُ عَ قَلَمَ، «عَلَتَلَ، عِ شَ عِ مَفٌرٌ عِسِرَيِلَ حَمَ وُيَشِ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","لْشْي ندٍ، حَمَ نَشَ عٍ مَوَ عٍ شَ تْورّ شَ قٍ رَ عَلَتَلَ يَ عِ. عَلَتَلَ نَشَ شْنْ نَ قٍ مَ، عَ قَ تّ رَ سِن حَمَ تَفِ، عَ يِرٍ ندٍ فَن يٌنكِندٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","حَمَ تٌ فبٍلٍفبٍلٍ مُنسَ رَ، عَ نَشَ عَلَتَلَ مَشَندِ. نَ كُي تّ نَشَ شُبٍن. ");
INSERT INTO susa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","عٍ نَشَ نَ يِرٍ شِلِ سَ تَبٍرَ، نَ نَن نَ كِ «تّ مَنكَنّ،» بَرِ مَ عَلَتَلَ نُ بَرَ تّ رَ سِن عٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","مِشِ كٌبِ ندٍيٍ تٌ وَ دٌنسٍ مْولِ فبّتّ شْن مَ، عِسِرَيِلَكَيٍ مَن نَشَ عٍ مَوَ، عَ قَلَقٍ رَ، «مُشُ وَ مَ سُبٍ نَن شْن! ");
INSERT INTO susa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","مُشُ مُشُ رَتُمَ نَ دٌنسٍ قَنيِ مَ مُشُ نَشَن سْتْ مِسِرَ بْشِ مَ كْبِرِ شَنبِ، عَلْ يّشّ، كَاكُنبٌو سِ، بَسِكّتِ، يّبّ، نُن يّبّ مَنِيّ. ");
INSERT INTO susa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","كْنْ يَكْسِ دٌنسٍ شْلِ مُ نَ مُشُ مَ، بَرِ مَ ‹مَنَ› دٌنسٍ نَن تُن نَ بٍ.» ");
INSERT INTO susa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","نَ «مَنَ» نُ لُشِ نّ عَلْ قُندٍن شْرِ قِيشّ. ");
INSERT INTO susa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","حَمَ نُ مِنِمَ عَ مَتٌنفٌدٍ، عٍ قَ عَ دِن فّمّ رَ، شَ نَ مُ، مُلُنيِ كُي. عٍ نُ لّكِ يَءِلَنمَ عَ رَ. عَ نُ لُشِ عَلْ تُرٍ نُ نَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","مَنَ نُ فٌرٌ مَ شِنِ فٌرٌ تّمُي. ");
INSERT INTO susa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","مُنسَ نَشَ حَمَ وَ شُي رَ مّ. مِشِ بِرِن نُ عٍ مَوَ مَ عٍ شْنيِ. عَلَتَلَ نَشَ شْنْ كِ قَنيِ رَ. مُنسَ نَشَ كْنتْقِلِ. ");
INSERT INTO susa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","عَ نَشَ عَلَتَلَ مَشْرِن، «ﭑ مَرِفِ، مُنقٍ رَ عِ بَرَ يِ كْنتْقِلِ لُ عِ شَ كٌنيِ مَ؟ ﭑ مُنسٍ رَبَشِ نَشَن عَ نِيَمَ عِ شَ يِ حَمَ شَ كٌتٍ دْشْ ﭑ شُن مَ؟ ﭑ تَن نَن نُ وَ مَ عَ شْن؟ ");
INSERT INTO susa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ﭑ تَن نَن عٍ بَرِشِ؟ مُنقٍ رَ عِ بَرَ عٍ سَ ﭑ بّلّشّ، ﭑ شَ عٍ شَنِن بْشِ مَ عِ نَشَن لَايِدِشِ عٍ بٍنبَيٍ بّ، عَلْ دِنفّ عَ شَ دِ شَنِنمَ كِ نَشّ؟ ");
INSERT INTO susa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ﭑ سُبٍ سْتْمَ مِندٍن يِ حَمَ بِرِن بّ؟ عٍ عٍ مَوَ مَ عٍ وَ مَ سُبٍ شْن. ");
INSERT INTO susa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ﭑ كٍرٍن مُ نْمَ يِ حَمَ بِرِن شَ كٌتٍ رَ، عَ بِنيَ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","قَشّ نَن قِسَ نَ كٌتٍ بّ. شَ ﭑ مَ قٍ رَقَن عِ مَ، عِ نَشَ ﭑ شُن نَكَنَ.» ");
INSERT INTO susa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِسِرَيِلَ قٌرِ تٌنفٌ سٌلٌقٍرٍ مَلَن ﭑ بّ، عِ نَشٍيٍ كٌلٌن تَا يَرٍرَتِيٍ نُن كُنتِفِيٍ رَ. عٍ شَ عٍ مَلَن هْرْ مْلِنفِرَ دّ رَ عِ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ﭑ قَمَ فٌرٌدٍ عِ يِرٍ، وٌن شَ وْيّن. ﭑ شَشِلِ سّنِيّنشِ نَشَن قِشِ عِ مَ، ﭑ نَ ندٍ بَمَ عِ مَ، ﭑ شَ نَ سَ عٍ قَن مَ، عَلَكٌ عِ كٍرٍن نَشَ يِ حَمَ شَ كٌتٍ شَنِن سْنْن. وٌ نُن نَ كُنتِفِيٍ نَن عَ شَنِنمَ قَ.» ");
INSERT INTO susa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«عَ قَلَ حَمَ بّ، ‹وٌ شَ وٌ يّتّ رَ سّنِيّن، بَرِ مَ تِنَ وٌ سُبٍ دٌنمَ نّ. عَلَتَلَ بَرَ وٌ وَ شُي مّ، عَ قَلَقٍ رَ، «مُشُ وَ مَ سُبٍ نَن شْن مَ. لُقٍ مِسِرَ نَن قِسَ.» عَلَتَلَ قَمَ سُبٍ قِدٍ وٌ مَ وٌ نَشَن دٌنمَ. ");
INSERT INTO susa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","كْنْ وٌ مُ عَ دٌنمَ شّ شِ كٍرٍن، شَ نَ مُ شِ قِرِن، شَ نَ مُ شِ سُولِ، شَ نَ مُ شِ قُ، شَ نَ مُ شِ مْشْحّن. ");
INSERT INTO susa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","وٌ عَ دٌنمَ نّ هَن كِكٍ كٍرٍن، هَن عَ مِنِ وٌ حْي كُي، هَن عَ رَحَاشُ وٌ مَ، بَرِ مَ وٌ بَرَ عَلَتَلَ رَبّحِن، نَشَن نَ وٌ يَ مَ. وٌ بَرَ وٌ مَوَ عَ قَلَقٍ رَ، «مُنقٍ رَ مُشُ مِنِشِ مِسِرَ؟»›» ");
INSERT INTO susa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","مُنسَ نَشَ عَ مَسٍن عَلَتَلَ بّ، «عِ عَ قَلَمَ عِ سُبٍ قِمَ يِ حَمَ مَ كِكٍ كٍرٍن بُن مَ؟ ﭑ نَ شّمّ وُلُ كّمّ سٍننِ نَن يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","شُرُ سٍ فْورّ مُ نْمَ عٍ رَلِدٍ سُبٍ رَ. هَلِ يّشّ نَشٍيٍ نَ بَا مَ، عٍ مُ نْمَ عٍ رَلِدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","عَلَتَلَ نَشَ عَ يَابِ، «ﭑ سّنبّ شُرُن نَ رَبَدٍ؟ عِ قَمَ عَ كٌلٌندٍ شَ ﭑ مَ وْيّنيِ قِندِشِ نْندِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","مُنسَ نَشَ سِفَ عَلَتَلَ شَ مَسٍنيِ دّنتّفّدٍ حَمَ بّ. عَ نَشَ حَمَ قٌرِيٍ مِشِ تٌنفٌ سٌلٌقٍرٍ مَلَن عَلَ شَ هْرْ مْلِنفِرَ رَبِلِنيِ. ");
INSERT INTO susa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","عَلَتَلَ نَشَ فٌرٌ نُشُي كُي، عَ مَسٍنيِ تِ مُنسَ بّ. عَ نَشَ عَ يّتّ شَشِلِ سّنِيّنشِ ندٍ تٌنفٌ نَشَن نُ نَ مُنسَ مَ، عَ عَ سَ نَ قٌرِ مِشِ تٌنفٌ سٌلٌقٍرٍ مَ. نَ شَشِلِ سّنِيّنشِ تٌ فٌرٌ عٍ مَ، عٍ نَشَ سٌ مَسٍنيِ تِقٍ عَلَ شِلِ رَ، كْنْ عٍ مُ عَ عِكُيَ. ");
INSERT INTO susa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","كْنْ شّمّ قِرِن نُ نَ نَ قٌرِ تٌنفٌ سٌلٌقٍرٍ يَ مَ نَشٍيٍ مُ سِفَ مَلَنيِ. عٍ مُ سِفَ هْرْ مْلِنفِرَ يِرٍ، عٍ نَشَ لُ يٌنكِندٍ كُي. كْنْ عَلَ شَشِلِ سّنِيّنشِ نَشَ فٌرٌ عٍ قَن مَ، عٍ قَ مَسٍنيِ تِ عَلَ شِلِ رَ حَمَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","قٌنِكٍ ندٍ نَشَ عَ فِ، عَ سَ عَ قَلَ مُنسَ بّ، «عٍلٍدَدٍ نُن مٍدَدِ نَ مَسٍنيِ تِقٍ عَلَ شِلِ رَ حَمَ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","نُنُ شَ دِ شّمّ يٌسُوٍ، نَشَن نُ مُنسَ مَلِمَ كَقِ عَ قٌنِكٍ تّمُي، عَ نَشَ عَ قَلَ مُنسَ بّ، «ﭑ مَرِفِ، عِ شَ نَ قٍ دَن.» ");
INSERT INTO susa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","مُنسَ نَشَ عَ يَابِ، «عِ تْونّ تِقٍ ﭑ تَن نَن مَ قٍ رَ؟ عَ شْلِ ﭑ مَ عَلَتَلَ شَ حَمَ بِرِن قِندِ نَمِحْنمّيٍ رَ نَشٍيٍ بَرَ عَلَ شَشِلِ سّنِيّنشِ سْتْ!» ");
INSERT INTO susa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","نَ تّمُي، مُنسَ نُن عِسِرَيِلَ كُنتِفِيٍ نَشَ فبِلٍن حَمَ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","عَلَتَلَ نَشَ قٌيٍ شُنفبٍ رَ مِنِ كٍلِقٍ بَا مَ، نَشَن شْنِ فبٍفبٍ رَدِن حَمَ يٌنكِندٍ رَبِلِنيِ، هَن كٍلِقٍ يٌنكِندٍ تَفِ، عَ سَ دْشْ قّيحّن كٍرٍن حّرّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","حَمَ نَشَ قّيحّن نَ شْنِيٍ مَتٌنفٌ رَ، هَن نَ كُيٍ عِبَ. عٍ مَن نَشَ قّيحّن شْنِيٍ مَتٌنفٌ رَ، هَن كَنكَن نَشَ ثَانِ يَ قُ سْتْ، لِتِرِ كّمّ سَشَن تٌنفٌ سُولِ سَمَ ثَانِ نَشَن كُي. عٍ نَشَ عٍ رَقٍن عٍ شَ يٌنكِندٍ رَبِلِنيِ. ");
INSERT INTO susa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","كْنْ بٍينُ عِسِرَيِلَكَيٍ شَ فّ نَ سُبٍ دٌندٍ، عَلَتَلَ نَشَ شْنْ عٍ مَ، عَ عٍ حَشَنكَتَ عَ شْرْشْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","عٍ نَشَ نَ يِرٍ شِلِ سَ كِبِرٌتِ هَتَاوَ، نَ نَن نَ كِ «مِلَنتٍ فَبُرِ،» بَرِ مَ مِلَنتٍ فَلِ نَن نَفَتَ مّننِ. ");
INSERT INTO susa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","حَمَ نَشَ كٍلِ كِبِرٌتِ هَتَاوَ، عٍ سَ يٌنكِن شَسٍرٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","مُنسَ تٌ نُ بَرَ كُسِ فِنّ دْشْ، مَرِيَمَ نُن هَرُنَ نَشَ مُنسَ مَقَلَ، ");
INSERT INTO susa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","عَ قَلَقٍ رَ، «عَلَتَلَ وْيّنمَ مُنسَ نَن فبَنسَن سَابُي رَ؟ عَ مُ وْيّنمَ مُشُ قَن سَابُي رَ؟» عَلَتَلَ نَشَ نَ مَسٍنيِ مّ. ");
INSERT INTO susa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","مُنسَ نُ قِندِشِ يّتّ مَفٌرٌي نَن نَ دَنفِقٍ مِشِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","عَلَتَلَ نَشَ مُنسَ، هَرُنَ، نُن مَرِيَمَ شِلِ كٍرٍن نَ، عَ عٍ بِرِن شَ سِفَ هْرْ مْلِنفِرَ. عٍ تٌ سِفَ نَا، ");
INSERT INTO susa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","عَلَتَلَ نَشَ فٌرٌ نُشُي كُي هْرْ مْلِنفِرَ دّ رَ. عَ نَشَ هَرُنَ نُن مَرِيَمَ شِلِ. عٍ قِرِن نَشَ عٍ مَسٌ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","عَلَتَلَ نَشَ عَ مَسٍن عٍ بّ، «وٌ تُلِ مَتِ ﭑ مَ مَسٍنيِ رَ. ﭑ نَمِحْنمّ شّيمَ وٌ يَ مَ تّمُي نَشّ، ﭑ نَن ﭑ يّتّ مَسٍنمَ نَ كَنيِ بّ لَامَتُنيِ نَن كُي. ﭑ وْيّن عَ رَ شِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","كْنْ ﭑ مَ كٌنيِ مُنسَ تَن فبٍ مُ نَ نَ كِ شّ. عَ تَن قِندِشِ ﭑ دُفُتّفّ نَن نَ ﭑ مَ وَلِ بِرِن كُي. ");
INSERT INTO susa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ﭑ نَ ﭑ مَ مَسٍنيِ مَكّنّنمَ عَ بّ، ﭑ مُ تَالِ وْيّنيِ رَوَلِمَ مُشُ تَفِ. ﭑ نَن ﭑ يّتّ مَسٍنمَ عَ بّ، عَ قَ ﭑ نِينِ عِفبّقٍ. مُنقٍ رَ وٌ مُ فَاشُ ﭑ مَ كٌنيِ مُنسَ مَقَلَقٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","عَلَتَلَ نَشَ شْنْ عٍ مَ، عَ قَ كٍلِ عٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","نُشُي تٌ كٍلِ هْرْ مْلِنفِرَ شُن مَ، مَرِيَمَ قَتٍ نَشَ رَقِيشّ كُنّ رَ كٍرٍن نَ. هَرُنَ تٌ عَ تٌ، كُنّ نَ مَرِيَمَ قَتٍ بِرِن مَ، ");
INSERT INTO susa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","عَ نَشَ مُنسَ مَيَندِ، «يَندِ، ﭑ مَرِفِ، عِ نَشَ مُشُ رَتْن مُشُ شَ يُنُبِ شَ قٍ رَ، مُشُ نَشَن نَبَشِ مُشُ شَ شَشِلِتَرٍحَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","مَرِيَمَ نَشَ لُ عَلْ دِ نَشَن قَشَشِ عَ نفَ قُرِ، نَشَن قَتٍ سّيتِ بْرْشِ بٍينُ عَ بَرِ تّمُي.» ");
INSERT INTO susa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","مُنسَ نَشَ عَ شُي رَتٍ عَلَتَلَ مَ، «ﭑ مَرِفِ، ﭑ بَرَ عِ مَشَندِ، عَ رَيَلَن!» ");
INSERT INTO susa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","عَلَتَلَ نَشَ عَ يَابِ، «شَ عَ بَبَ دّيٍ بْشُن عَ يَتَفِ، عَ مُ يَافِمَ شّ هَن لْشُن كٍرٍن؟ عِ شَ عَ رَ مِنِ حَمَ يَ مَ. عَ نَ فٍ لْشُن كٍرٍن نَبَدٍ حَمَ يٌنكِندٍ قَرِ مَ، وٌ نْمَ عَ رَ سٌدٍ وٌ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","نَ كُي، عٍ نَشَ عَ رَ مِنِ حَمَ يَ مَ، عَ شِ سٌلٌقٍرٍ رَبَ يٌنكِندٍ قَرِ مَ. حَمَ مُ كٍلِ عٍ يٌنكِندٍ هَن مَرِيَمَ نَشَ رَفبِلٍن عٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","نَ تٌ بَ عَ رَ، حَمَ نَشَ كٍلِ شَسٍرٌتِ، عٍ نَشَ سَ يٌنكِن ثَرَن فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«عِ شَ يَرٍرَتِ كٍرٍن كٍرٍن سُفَندِ بْنسْي بِرِن يَ مَ، عِ شَ عٍ شّي كَنَان بْشِ مَ، عٍ شَ سَ نَ بْشِ رَبّن، ﭑ نَشَن قِمَ عِسِرَيِلَكَيٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","مُنسَ نَشَ نَ مِشِيٍ شّي كٍلِقٍ ثَرَن فبٍنفبٍرٍنيِ مَ، عَلْ عَلَتَلَ عَ يَمَرِشِ كِ نَشّ. نَ مِشِ بِرِن قِندِ عِسِرَيِلَ كُنتِفِيٍ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","عٍ شِلِيٍ نَن يِ كِ؛ كٍلِقٍ رُبٍن بْنسْي مَ، سَكُرُ شَ دِ شّمّ سَمُوَ. ");
INSERT INTO susa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","كٍلِقٍ سِمٍيْن بْنسْي مَ، شٌرِ شَ دِ شّمّ سَقَتِ. ");
INSERT INTO susa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","كٍلِقٍ يُدَ بْنسْي مَ، يٍقُنٍ شَ دِ شّمّ كَلٍبِ. ");
INSERT INTO susa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","كٍلِقٍ عِسَكَرِ بْنسْي مَ، يُسُقُ شَ دِ شّمّ يِفَلِ. ");
INSERT INTO susa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","كٍلِقٍ عٍقِرَ مِ بْنسْي مَ، نُنُ شَ دِ شّمّ هٌسٍيَ. ");
INSERT INTO susa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","كٍلِقٍ بُنيَمِن بْنسْي مَ، رَقُ شَ دِ شّمّ ثَلِتِ. ");
INSERT INTO susa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","كٍلِقٍ سَبُلٌن بْنسْي مَ، سٌدِ شَ دِ شّمّ فَدِيٍلِ. ");
INSERT INTO susa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","كٍلِقٍ يُسُقُ شَ دِ، مَنَسِ بْنسْي مَ، سُسِ شَ دِ شّمّ فَدِ. ");
INSERT INTO susa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","كٍلِقٍ دَنَ بْنسْي مَ، فٍمَلِ شَ دِ شّمّ عَمِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","كٍلِقٍ عَسٍرِ بْنسْي مَ، مِكَيٍلِ شَ دِ شّمّ سٍتُرُ. ");
INSERT INTO susa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","كٍلِقٍ نَقَتَلِ بْنسْي مَ، قٌقِسِ شَ دِ شّمّ نَشَبِ. ");
INSERT INTO susa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","كٍلِقٍ فَدِ بْنسْي مَ، مَكِ شَ دِ شّمّ فٍيُوٍلِ. ");
INSERT INTO susa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","شّمّيٍ شِلِيٍ نَن نَ كِ مُنسَ نَشٍيٍ شّي كَنَان بْشِ رَبّندٍ. مُنسَ نَشَ نُنُ شَ دِ شّمّ هٌسٍيَ شِلِ سَ يٌسُوٍ. ");
INSERT INTO susa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","مُنسَ تٌ عٍ شّي كَنَان بْشِ رَبّندٍ، عَ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ مِنِ نٍفٍوِ فبٍنفبٍرٍنيِ بِرِ، هَن وٌ فٍيَيٍ يِرٍ لِ. ");
INSERT INTO susa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","وٌ شَ نَ بْشِ رَبّن، وٌ شَ عَ كٌلٌن شَ مّننِكَيٍ سّنبّ فبٌ، شَ عٍ سّنبّ مُ فبٌ، شَ عٍ وُيَ، شَ عٍ مُ وُيَ. ");
INSERT INTO susa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","وٌ شَ عَ مَتٌ شَ نَ بْشِ قَن. وٌ شَ عَ كٌلٌن شَ تّتّ نَ نَ تَايٍ رَبِلِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","وٌ شَ عَ مَتٌ شَ نَ بْشِ قَن سَنسِ بّ، شَ وُرِيٍ فبٌ نَا. وٌ كَتَ وٌ شَ قَ نَ سَنسِ بٌفِ ندٍيٍ رَ.» وّنِ بِلِيٍ بٌفِ سِنفٍ تّمُي نَن نُ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","عٍ نَشَ سَ نَ بْشِ رَبّن، كٍلِقٍ سِنِ فبٍنفبٍرٍنيِ مَ، هَن رٍشٌبٌ، شَمَتَ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","عٍ نَشَ دَنفِ نٍفٍوِ فبٍنفبٍرٍنيِ رَ، عٍ سَ شٍبِرٌن لِ، عَنَكِ شَ دِيٍ عَشِمَن، سّسَيِ، نُن تَلَمَيِ نُ سَبَتِشِ دّننَشّ. شٍبِرٌن تَا نُ تِشِ حّ سٌلٌقٍرٍ بٍينُ سٌوَن تَا شَ تِ مِسِرَ. ");
INSERT INTO susa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","عٍ تٌ عٍسٍكٌلِ فُلُنبَ لِ، عٍ نَشَ وّنِ بِلِ سَلٌنيِ ندٍ رَ سّفّ، عَ تْنسْي نُ نَ نَشَن مَ. مِشِ قِرِن نَشَ نَ شَنِن وُرِ كُيٍ رَ. عٍ نَشَ شْرّ بٌفِ ندٍ قَن تٌنفٌ، عَ نُن بٌفِسٍ ندٍ نَشَن شِلِ فِرٍنَدِ، نَشَن مَنِيّ كْوبّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","عٍ نَشَ نَ يِرٍ شِلِ سَ عٍسٍكٌلِ، نَ نَن نَ كِ «تْنسْي يِرٍ،» نَ وّنِ بٌفِ تْنسْي شَ قٍ رَ، عٍ نَشَن بَشِ. ");
INSERT INTO susa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","عٍ تٌ شِ تٌنفٌ نَانِ رَبَ نَا نَ بْشِ رَبّندٍ، عٍ نَشَ فبِلٍن ");
INSERT INTO susa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","مُنسَ، هَرُنَ، نُن عِسِرَيِلَ حَمَ يِرٍ. عٍ نُ نَ كَدٍ سِ، ثَرَن فبٍنفبٍرٍنيِ مَ. مّننِ عٍ نَشَ دّنتّفّ سَ، عٍ نَ بْشِ سَنسِ بٌفِيٍ مَسٍن عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","عٍ نَشَ عَ قَلَ مُنسَ بّ، «مُشُ سٌ نّ بْشِ مَ، عِ مُشُ شّي دّننَشّ. بْشِ نَن عَ رَ، كُمِ نُن شِحّ شّلّمَ دّننَشّ. نَ بٌفِسٍ ندٍيٍ نَن يَ. ");
INSERT INTO susa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","كْنْ حَمَ نَشَن سَبَتِشِ نَ بْشِ مَ، عٍ سّنبّ فبٌ. تّتّ دْشْشِ تَا بِرِن نَ. تَا شُنفبٍ نَن عٍ رَ. مُشُ عَنَكِ بْنسْي يَتِ تٌشِ نّ نَا. ");
INSERT INTO susa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","عَمَلّكِكَيٍ سَبَتِشِ نٍفٍوِ فبٍنفبٍرٍنيِ نَن مَ. شِتِكَيٍ، يٍبُسُكَيٍ، نُن عَمٌرِكَيٍ، نٍيٍ نَن سَبَتِشِ فٍيَ يِرٍ. كَنَانكَيٍ تَن سَبَتِشِ بَا دّ نَن نَ، عَ نُن يُرُدّن شُرٍ دّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","كَلٍبِ نَشَ حَمَ مَسَبَرِ مُنسَ يَ شْرِ، عَ قَلَقٍ رَ، «وٌن شّي! وٌن شَ يِ بْشِ قِندِ وٌن فبٍ رَ. وٌن نْمَ نَ رَبَدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","كْنْ بٌورٍ نَشٍيٍ سِفَ بْشِ رَبّندٍ، نٍيٍ نَشَ عَ قَلَ، «وٌن مُ نْمَ سِفَدٍ نَ حَمَ فٍرٍدٍ. عٍ سّنبّ فبٌ وٌن بّ!» ");
INSERT INTO susa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","نَ كُي عٍ نَشَ قٍ حَاشِ قَلَ نَ بْشِ شَ قٍ رَ عِسِرَيِلَ حَمَ بّ. عٍ نَشَ عَ قَلَ، «مُشُ بْشِ نَشَن نَبّنشِ، بْشِ نَن عَ رَ نَشَن مِشِ قَشَمَ. مِشِ فبَنفبَلَنيِيٍ سَبَتِشِ نَا. ");
INSERT INTO susa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","مُشُ عَنَبِيٌرٌي تٌ نّ نَشَن قَتَنشِ عَنَكِ بْنسْي رَ. مُشُ نُ لُشِ نّ عَلْ كَتٌي عٍ مَبِرِ. عٍ تَن يٌ، مُشُ تَن يٌ، عٍ بِرِن عَ تٌشِ نَ كِ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","حَمَ نَشَ وَ شُي رَ مِنِ كْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","عِسِرَيِلَكَ بِرِن نُ قَ وْيّن نَ مُنسَ نُن هَرُنَ مَ، عٍ نُ عَ قَلَ، «عَ نُ قِسَ مُشُ شَ قَشَ مِسِرَ، شَ نَ مُ عَ رَ يِ فبٍنفبٍرٍن يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","مُنقٍ رَ عَلَتَلَ مُشُ رَ سٌقٍ يِ بْشِ مَ، مُشُ شَ قَشَ سَنتِدّفّمَ رَ، مُشُ شَ دِيٍ نُن مُشُ شَ فِنّيٍ شَ سُشُ فٍرٍ كُي. عَ مُ قِسَ مُشُ شَ فبِلٍن مِسِرَ؟» ");
INSERT INTO susa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","عٍ نَشَ عَ قَلَ عٍ بٌورٍيٍ بّ، «وٌن مَنفّ كٍرٍن تِ وٌن شُن نَ، وٌن شَ فبِلٍن مِسِرَ.» ");
INSERT INTO susa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","مُنسَ نُن هَرُنَ نَشَ عٍ يَتَفِ رَقٍلٍن بْشِ مَ عِسِرَيِلَكَ بِرِن يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","نُنُ شَ دِ شّمّ يٌسُوٍ نُن يٍقُنٍ شَ دِ شّمّ كَلٍبِ نَشَ عٍ شَ دٌنمَ عِبْو سُننُنيِ كُي. نَ مِشِ قِرِن نُ نَ نَ شّيرَيٍ يَ مَ، نَشٍيٍ سِفَ كَنَان بْشِ رَبّندٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","عٍ نَشَ قَ يِ مَسٍنيِ تِ حَمَ بّ، «مُشُ بْشِ نَشَن مَتٌشِ، بْشِ قَنيِ قَنيِ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","شِحّ نُن كُمِ يِرٍ نَن عَ رَ. شَ عَلَتَلَ نَ وٌن بّ، عَ وٌن نَسٌمَ نّ نَا، عَ نَ بْشِ قِ وٌن مَ. ");
INSERT INTO susa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","يَندِ، وٌ نَشَ عَلَتَلَ مَتَندِ. وٌ نَشَ فَاشُ نَ بْشِ مِشِيٍ يَ رَ. وٌن نْمَ نّ عٍ رَ. عٍ سَنكٍ يٌ مُ نَ سْنْن، بَرِ مَ عَلَتَلَ نَ وٌن تَن نَن بّ. وٌ نَشَ فَاشُ عٍ يَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","حَمَ نُ وَ مَ عٍ مَفْنْقٍ، كْنْ عَلَتَلَ شَ نْرّ نَشَ مِنِ هْرْ مْلِنفِرَ عِسِرَيِلَكَ بِرِن يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «يِ حَمَ بَمَ ﭑ مَبٍرٍقٍ مُن تّمُي؟ مُنقٍ رَ عٍ سِيكّمَ هَلِ ﭑ كَابَنَكٌي رَبَمَ عٍ تَفِ؟ ");
INSERT INTO susa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ﭑ شَ وُفَنيِ رَدِن عٍ مَ، ﭑ نٍيٍ قَشَ. نَ تّمُي ﭑ بْنسْي شُنفبٍ سّنبّمَ ندٍ رَكٍلِمَ نّ عِ سَابُي رَ، نَشَن دَنفِ عٍ تَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","مُنسَ نَشَ عَلَتَلَ يَابِ، «مِسِرَكَيٍ بَرَ عَ كٌلٌن، عَ عِ يِ حَمَ رَ مِنِ عٍ شَ بْشِ رَ عِ سّنبّ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","عٍ بَرَ بٍكَيٍ رَكٌلٌن. نٍيٍ بَرَ عَ مّ، عَ عِ تَن عَلَتَلَ نَ عِ شَ حَمَ قْشْ رَ، عَ عِ عِ يّتّ مَسٍنمَ عٍ مَ، عَ عِ نُشُي سَمَ عٍ شُن مَ، عَ عِ حّرّ مَ عٍ يَ رَ نُشُي كُي يَنيِ رَ، نُن تّ كُي كْي رَ. ");
INSERT INTO susa_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","شَ عِ قَ يِ حَمَ بِرِن قَشَ كٍرٍنيِ رَ، بْنسْي نَشٍيٍ عِ شَ قٍ مّشِ، عٍ عَ قَلَمَ نّ، ");
INSERT INTO susa_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹عَلَتَلَ سّنبّ يٌ مُ نُ نْمَ يِ حَمَ رَ سٌدٍ بْشِ مَ، عَ نَشَن لَايِدِشِ عٍ بّ. نَ نَن عَ رَ، عَ عٍ بِرِن سْنتْ فبٍنفبٍرٍنيِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«عِ شَ عِ سّنبّ مَسٍن عٍ بّ، عَلْ عِ تَن يَتِ عَ يِتَشِ كِ نَشّ، عَ قَلَقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹ﭑ مُ شْنْمَ مَقُرٍن مَقُرٍن. ﭑ مَ دِحّ نُن قَنيِ فبٌ. ﭑ مِشِيٍ شَ يُنُبِيٍ نُن قٍ حَاشِيٍ شَقَرِ مَ. كْنْ ﭑ مِشِ كٌبِ نُن مِشِ قَنيِ تَفِ رَ سَمَ. ﭑ بٍنبَيٍ شَ يُنُبِ سَرٍ دْشْمَ عٍ شَ دِيٍ شُن مَ هَن بْنسْي سَشَن، شَ نَ مُ نَانِ.› ");
INSERT INTO susa_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","يَندِ، ﭑ بَرَ عِ مَشَندِ، دِحّ عِ شَ حَمَ شَ يُنُبِ مَ عِ شَ هِننّ شَ قٍ رَ، عَلْ عِ عَ رَبَشِ كَبِ عٍ مِنِ مِسِرَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","عَلَتَلَ نَشَ عَ يَابِ، «ﭑ بَرَ دِحّ عِ شَ مَشَندِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","كْنْ، ﭑ بَرَ ﭑ كَلِ، نْندِ نَن عَ رَ عَلْ ﭑ تٌ نَ نَ، عَلْ ﭑ مَ نْرّ نَشَن بْشِ رَقٍمَ، ");
INSERT INTO susa_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","شّمّ نَشَن بِرِن ﭑ مَ نْرّ نُن ﭑ مَ كَابَنَكٌي تٌشِ، ﭑ نَشٍيٍ رَبَ مِسِرَ نُن فبٍنفبٍرٍنيِ مَ، كْنْ عٍ قَ مُرُتَ ﭑ مَ هَن سَنيَ قُ تُلِ شْرْشْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","نٍيٍ سٍسٍ مُ بْشِ تٌمَ، ﭑ نَشَن لَايِدِشِ عٍ بٍنبَيٍ بّ. نَشَن بِرِن مُرُتَشِ ﭑ مَ، عٍ سٍسٍ مُ نَ تٌمَ. ");
INSERT INTO susa_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","كْنْ ﭑ مَ كٌنيِ دِ كَلٍبِ تٌ بِرَ شَشِلِ فبّتّ قْشْ رَ، عَ قَ ﭑ نَبَتُ، ﭑ عَ تَن نَسٌمَ نّ نَ بْشِ مَ، عَ نَشَن نَبّنشِ. عَ بْنسْي كّ سْتْمَ نّ نَا. ");
INSERT INTO susa_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","عَمَلّكِكَيٍ نُن كَنَانكَيٍ تٌ سَبَتِ فُلُنبَ كُي، تِنَ وٌ شَ وٌ مَقِندِ، وٌ شَ فبِلٍن فبٍنفبٍرٍنيِ مَ شُلُنيُمِ بَا مَبِرِ.» ");
INSERT INTO susa_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«يِ حَمَ كٌبِ ﭑ مَتَندِ مَ هَن مُن تّمُي؟ ﭑ بَرَ عِسِرَيِلَكَيٍ شُي مّ، عٍ نَشَن قَلَمَ ﭑ بّ، عٍ تِ ﭑ كَنكٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","عَ قَلَ عٍ بّ، ‹ﭑ بَرَ ﭑ كَلِ، نْندِ نَن عَ رَ، عَلْ ﭑ تٌ نَ نَ، ﭑ عَ رَبَمَ نّ وٌ بّ عَلْ ﭑ عَ مّشِ وٌ دّ عِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","وٌ تَن مَتَندِلَيٍ، نَشَن بِرِن كْنتِشِ عِسِرَيِلَ حَمَ يَ مَ، نَشٍيٍ شَ سِمَيَ بَرَ دَنفِ حّ مْشْحّن نَ، وٌ قَشَمَ نّ يِ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","وٌ مُ سٌمَ بْشِ مَ ﭑ نَشَن لَايِدِ وٌ بّ، قٌ يٍقُنٍ شَ دِ شّمّ كَلٍبِ نُن نُنُ شَ دِ شّمّ يٌسُوٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","وٌ شَ دِيٍ، وٌ نَشٍيٍ مَ عَ عٍ بِرِن قَشَمَ فٍرٍ نَن كُي، ﭑ نٍيٍ تَن نَسٌمَ نّ نَ بْشِ كُي، وٌ مّيشِ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","وٌ قَشَمَ فبٍنفبٍرٍنيِ نَن مَ، وٌ قُرٍيٍ لُمَ نَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","وٌ شَ دِيٍ قِندِ مَ حّرّتِيٍ نَن نَ حّ تٌنفٌ نَانِ بُن مَ يِ فبٍنفبٍرٍنيِ مَ. عٍ وٌ شَ يُنُبِ سَرٍ شَنِنمَ هَن وٌ بِرِن قَشَ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","وٌ شِ شَسَبِ نَشَن نَبَ نَ بْشِ رَبّندٍ، وٌ نَ حّ شَسَبِ رَبَمَ فبٍنفبٍرٍنيِ مَ وٌ شَ يُنُبِ شَ قٍ رَ. وٌ تٌ شِ تٌنفٌ نَانِ رَبَ نَ بْشِ رَبّندٍ، وٌ قَمَ نّ حّ تٌنفٌ نَانِ رَبَدٍ فبٍنفبٍرٍنيِ مَ، عَلَكٌ وٌ شَ عَ كٌلٌن ﭑ نَ يُنُبِ شْنشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ﭑ تَن عَلَتَلَ، ﭑ بَرَ فّ وْيّندٍ. ﭑ بَرَ نَ نَتّ تٌنفٌ يِ حَمَ كٌبِ شَ قٍ رَ، نَشَن تِ ﭑ كَنكٍ. عٍ بِرِن قَشَمَ نّ فبٍنفبٍرٍنيِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","مُنسَ شَ شّيرَيٍ تٌ فبِلٍن كٍلِقٍ نَ بْشِ رَبّندٍ، عٍ نَشَ قٍ شْرْشْي قَلَ نَ بْشِ شَ قٍ رَ هَن عِسِرَيِلَ حَمَ نَشَ تِ مُنسَ كَنكٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","نَ كُي، عَلَتَلَ نَشَ عٍ قَشَ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","نَ شّيرَيٍ يَ مَ، يٍقُنٍ شَ دِ شّمّ كَلٍبِ نُن نُنُ شَ دِ شّمّ يٌسُوٍ نَن فبَنسَن مُ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","مُنسَ تٌ نَ مَسٍنيِ تِ عِسِرَيِلَ حَمَ بّ، عٍ نَشَ سُننُن كِ قَنيِ. ");
INSERT INTO susa_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","عٍ نَشَ كٍلِ سُبَشّ مَ، عٍ شَ تٍ فٍيَ لٌنفٌرِ. عٍ نَشّ، «مُشُ شَ تٍ يِرٍ، عَلَتَلَ دّننَشّ مَسٍنشِ مُشُ بّ. مُشُ بَرَ يُنُبِ رَبَ.» ");
INSERT INTO susa_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","مُنسَ نَشَ عٍ مَشْرِن، «وٌ عَلَتَلَ شَ يَامَرِ نَن مَتَندِقٍ؟ وٌ مُ فٍينِمَ نَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","وٌ نَشَ تٍ دٍ، بَرِ مَ عَلَتَلَ مُ نَ وٌ يَ مَ سْنْن. وٌ نَشَ عَ نِيَ وٌ يَشُييٍ شَ نْ وٌ رَ. ");
INSERT INTO susa_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","عَمَلّكِكَيٍ نُن كَنَانكَيٍ نَ وٌ يَ رَ، عٍ وٌ سْنتْمَ نّ عٍ شَ سَنتِدّفّمَيٍ رَ. وٌ تٌ بَرَ وٌ كٌبٍ سٌ عَلَتَلَ رَ، عَ مُ نَ وٌ قْشْ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","كْنْ عِسِرَيِلَ حَمَ مُ عٍ تُلِ مَتِ مُنسَ رَ. عٍ نَشَ تٍ فٍيَ يِرٍ، كْنْ عَلَتَلَ شَ سَاتّ كَنكِرَ نُن مُنسَ مُ كٍلِ حَمَ شَ يٌنكِندٍ. ");
INSERT INTO susa_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","عَمَلّكِكَيٍ نُن كَنَانكَيٍ نَشٍيٍ نُ سَبَتِشِ نَ فٍيَ يِرٍ، عٍ نَشَ فٌرٌ عِسِرَيِلَكَيٍ شِلِ مَ، عٍ قَ عٍ بْنبْ، عٍ عٍ مَسّفّ هَن هٌرٌ مَ. ");
INSERT INTO susa_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ نَ سٌ بْشِ مَ، ﭑ دّننَشَن قِشِ وٌ مَ سَبَتِدٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","شَ وٌ وَ مَ شُرُ سٍ بَقٍ سّرّشّ رَ نَشَن نَقَن عَلَتَلَ مَ، عَلْ سّرّشّ فَن دَاشِ، لَايِدِ سّرّشّ، سّرّشّ حَنِفٍشِ، شَ نَ مُ عَ رَ سَلِ سّرّشّ، ");
INSERT INTO susa_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّ سَ نَ قَرِ، نَشَن قِندِ مَ سَنسِ شْرِ دِنشِ لُشُتَشِ كِلٌ سَشَن مَسُنبُشِ تُرٍ لِتِرِ كٍرٍن نُن عَ تَفِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","عَ نُن وّنِ لِتِرِ كٍرٍن نُن عَ تَفِ. نَ سَمَ سّرّشّ فَن دَاشِ نُن سّرّشّ حَنِفٍشِ نَن شُن مَ نَشَن قِندِ مَ يّشّي رَ. ");
INSERT INTO susa_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","شَ عَ سَ قِندِ يّشّي كٌنتٌنيِ نَن نَ، وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّ سَ نَ قَرِ، نَشَن قِندِ مَ سَنسِ شْرِ دِنشِ لُشُتَشِ كِلٌ سٍننِ مَسُنبُشِ تُرٍ لِتِرِ قِرِن نَ، ");
INSERT INTO susa_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","عَ نُن وّنِ لِتِرِ قِرِن. نَ فَنشِ رَقَن عَلَتَلَ مَ.›» ");
INSERT INTO susa_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«شَ وٌ وَ مَ نِنفٍ بَقٍ سّرّشّ رَ نَشَن نَقَن عَلَتَلَ مَ، عَلْ سّرّشّ فَن دَاشِ، لَايِدِ سّرّشّ، شَنُنتٍيَ سّرّشّ، ");
INSERT INTO susa_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّ سَ نَ قَرِ، نَشَن قِندِ مَ سَنسِ شْرِ دِنشِ لُشُتَشِ كِلٌ سٌلٌمَنَانِ نَشَن مَسُنبُشِ تُرٍ لِتِرِ سَشَن نَ، ");
INSERT INTO susa_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","عَ نُن وّنِ لِتِرِ سَشَن. نَ فَنشِ رَقَن عَلَتَلَ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«نَ نَن نَبَمَ نِنفٍيٍ، يّشّي كٌنتٌنيِيٍ، يّشّييٍ، نُن سِيٍ بِرِن بّ وٌ نَشَن بَمَ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","وٌ شَ نَ رَبَ شُرُ سٍ بِرِن بّ. ");
INSERT INTO susa_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","عِسِرَيِلَكَ بِرِن شَ عَ رَبَ نَ كِ نّ عٍ شَ سّرّشّ بِرِن بّ، عٍ نَشَن بَمَ تّ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","شْحّ نَشٍيٍ نَ وٌ يَ مَ، عٍ قَن شَ عَ رَبَ نَ كِ عٍ سّرّشّ فَن دَاشِ بَمَ تّمُي نَشّ. نَ رَقَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","سّرِيّ كٍرٍن نَن لُمَ حَمَ بِرِن بّ، عِسِرَيِلَكَيٍ بَ، شْحّيٍ بَ. كٍلِ وٌ تَن مَ، هَن وٌ شَ دِيٍ، نُن نٍيٍ قَن شَ دِيٍ نَشٍيٍ قَمَ، وٌ تَن يٌ، شْحّ يٌ، وٌ بِرِن شَ عَلَتَلَ شَ سّرِيّ سُشُ نَ كِ نّ. ");
INSERT INTO susa_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","عِسِرَيِلَكَيٍ بَ، شْحّيٍ بَ، وٌ بِرِن نَ سّرِيّ كٍرٍن نُن يَامَرِ كٍرٍن نَن بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ نَ سٌ بْشِ مَ، ﭑ وٌ رَ سٌقٍ دّننَشّ، ");
INSERT INTO susa_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","وٌ قَ نَ بْشِ دَشَمُي سْتْ، وٌ شَ ندٍ بَ سّرّشّ رَ ﭑ بّ. ");
INSERT INTO susa_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","وٌ نَ تَامِ سِنفٍ يَءِلَن سَنسِ شْرِ نّينّ رَ، وٌ شَ ندٍ بَ سّرّشّ رَ ﭑ بّ، عَلْ وٌ سَنسِ شْرِ نّينّ ندٍ بَمَ كِ نَشّ شّ شَبَ تّمُي لٌنيِ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","وٌ شَ نَ تَامِ سِنفٍ بَ عَلَتَلَ بّ حّ يٌ حّ.›» ");
INSERT INTO susa_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«شَ عَ سَ لِ وٌ تَنتَنشِ نّ عَلَتَلَ شَ يَامَرِيٍ سُشُقٍ كُي، عَ نَشٍيٍ مَسٍنشِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","كٍلِقٍ نَ مَسٍن تّمُي، هَن وٌ شَ دِيٍ شَ مَمَدِيٍ شَ تّمُي، ");
INSERT INTO susa_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","شَ وٌ مُ نَ رَبَ وٌ حَنِفٍ رَ، وٌ عَ رَبَ كٌلٌنتَرٍيَ كُي، حَمَ شَ تُورَ بَ سّرّشّ فَن دَاشِ رَ، نَشَن نَقَن عَلَتَلَ مَ. وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّ نُن وّنِ سّرّشّ سَ نَ قَرِ عَ رَبَ كِ مَ، عَ نُن سِكْتّ نَشَن قِندِ مَ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","سّرّشّدُبّ يُنُبِ شَقَرِ مَشَندِ مَ نّ عِسِرَيِلَكَ بِرِن بّ. عَلَتَلَ دِحّمَ نّ عٍ مَ. يُنُبِ نَن عَ رَ، عٍ مُ نَشَن حَنِفٍشِ. عٍ مَن بَرَ سّرّشّ فَن دَاشِ بَ عَلَتَلَ بّ، عَ نُن عٍ شَ يُنُبِ شَقَرِ سّرّشّ. ");
INSERT INTO susa_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","نَ يُنُبِ شَقَرِ مَ نّ عِسِرَيِلَكَ بِرِن نُن عٍ شَ شْحّيٍ بّ، بَرِ مَ تَنتَنيِ نَ نُ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«شَ مِشِ كٍرٍن نَن يُنُبِ رَبَ حَنِفٍتَرٍحَ كُي، عَ شَ سِ فِنّ كٍرٍن بَ يُنُبِ شَقَرِ سّرّشّ رَ، نَشَن بَرَ حّ كٍرٍن سْتْ. ");
INSERT INTO susa_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","سّرّشّدُبّ يُنُبِ شَقَرِ مَشَندِ مَ نّ نَ مِشِ بّ نَشَن يُنُبِ رَبَ حَنِفٍتَرٍحَ كُي عَلَتَلَ يَ شْرِ. نَ نَ حْن، عَ شَ يُنُبِ بَرَ شَقَرِ. ");
INSERT INTO susa_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","نَ سّرِيّ كٍرٍنيِ نَ عِسِرَيِلَكَيٍ نُن عٍ شَ شْحّيٍ بّ، يُنُبِ رَبَقٍ حَنِفٍتَرٍحَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","كْنْ شَ مِشِ ندٍ سَ عَلَتَلَ مَتَندِ عَ حَنِفٍ رَ، عَ قِندِ عِسِرَيِلَكَ رَ، عَ قِندِ شْحّ رَ، نَ كَنيِ كٍرِ مَ نّ حَمَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","عَ بَرَ عَلَتَلَ شَ مَسٍنيِ مَبٍرٍ، عَ بَرَ عَلَتَلَ شَ سّرِيّ مَتَندِ. نَ كَنيِ كٍرِ مَ نّ حَمَ تَفِ، بَرِ مَ نَ يُنُبِ كٌتٍ دْشْشِ عَ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","عِسِرَيِلَكَيٍ تٌ نُ نَ فبٍنفبٍرٍنيِ مَ، عٍ نَشَ مِشِ ندٍ لِ مَلَبُي لْشْي عَ يٍفٍ قٍنقٍ. ");
INSERT INTO susa_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","عٍ نَشَ عَ شَنِن مُنسَ نُن هَرُنَ شْن حَمَ يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","عٍ نَشَ عَ سُشُ، كْنْ عٍ مُ عَ حَشَنكَتَ، بَرِ مَ نَتّ مُ نُ تٌنفٌشِ عَ شَ قٍ رَ سِندٍن. ");
INSERT INTO susa_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «يِ شّمّ لَن نّ عَ شَ قَشَ. حَمَ بِرِن شَ عَ مَفْنْ هَن عَ قَشَ يٌنكِندٍ قَرِ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","حَمَ بِرِن نَشَ عَ رَ مِنِ عٍ يٌنكِندٍ قَرِ مَ، عٍ عَ مَفْنْ هَن عَ قَشَ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ تَن نُن عٍ شَ دِيٍ شَ مَمَدِيٍ عٍ شَ عٍ شَ سٌسٍيٍ سَنبُنيِ رَقُتُقُتُ، عٍ فّسّ فّرّ دَاشِ شِرِ عَ دّ عِ. ");
INSERT INTO susa_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","نَ سَنبُنيِ رَقُتُقُتُشِ قِندِ مَ تْنشُمَ نَن نَ وٌ بّ، عَلَكٌ وٌ شَ رَتُ عَلَتَلَ شَ يَامَرِيٍ مَ، وٌ مَن شَ عٍ رَبَتُ. وٌ نَشَ بِرَ وٌ يّتّ وَشْنقٍيٍ قْشْ رَ، نَشٍيٍ وٌ رَتَنتَنمَ. ");
INSERT INTO susa_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","نَ نَن عَ نِيَمَ، وٌ رَتُمَ ﭑ مَ يَامَرِيٍ مَ، وٌ مَن عٍ رَبَتُ. نَ كُي، وٌ بَرَ قِندِ ﭑ مَ مِشِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ﭑ تَن نَن عَلَتَلَ رَ، وٌ مَرِفِ عَلَ، نَشَن وٌ رَ مِنِ مِسِرَ بْشِ رَ، عَلَكٌ ﭑ شَ قِندِ وٌ مَرِفِ عَلَ رَ. ﭑ تَن نَن عَلَتَلَ رَ، وٌ مَرِفِ عَلَ.» ");
INSERT INTO susa_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","لٍوِ بْنسْي مِشِ ندٍ، نَشَن شِلِ كٌرَ، يِسٍهَرِ شَ دِ شّمّ، كٍهَتِ شَ مَمَدِ، عَ نُن دَتَن نُن عَبِرَ مِ، عٍلِيَبِ شَ دِ شّمّيٍ، عَ نُن ثٍلٍتَ شَ دِ شّمّ عٌنِ، نَشَن قَتَنشِ رُبٍن بْنسْي رَ، ");
INSERT INTO susa_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","نٍيٍ نَشَ تِ مُنسَ كَنكٍ. عِسِرَيِلَكَ مِشِ كّمّ قِرِن مِشِ تٌنفٌ سُولِ نُ نَ عٍ شَنبِ رَ. كُنتِفِ بٍلٍبٍلٍيٍ نُ نَ عٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","عٍ نَشَ عٍ مَلَن مُنسَ نُن هَرُنَ شِلِ مَ، عٍ قَ عَ قَلَ عٍ بّ، «وٌ شَ مَنفّيَ بَرَ حْن! عِسِرَيِلَ حَمَ بِرِن سّنِيّن، عَلَتَلَ مَن نَ مُشُ تَفِ. مُنقٍ رَ وٌ تَن فبَنسَن وٌ يّتّ عِتٍمَ عَلَتَلَ شَ حَمَ شُن مَ؟» ");
INSERT INTO susa_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","مُنسَ تٌ نَ مّ، عَ نَشَ عَ يَتَفِ رَقٍلٍن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","عَ نَشَ عَ قَلَ كٌرَ نُن عَ شَ مِشِيٍ بّ، «تِنَ فّيسّفّ، عَلَتَلَ قَمَ عَ مَسٍندٍ وٌن بّ، عَ شَ مِشِ سّنِيّنشِ نَ نَشَن نَ. عَ تِنمَ نَ كَنيِ شَ مَكْرّ عَ رَ، عَ نَشَن سُفَندِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","كٌرَ، عِ نُن عِ شَ مِشِيٍ، وٌ شَ سُرَيِ فَنسٍيٍ تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","تِنَ وٌ تّ سَ عٍ كُي، وٌ سُرَيِ فَن عَلَتَلَ بّ. عَلَتَلَ نَ نَشَن سُفَندِ، نَ نَن سّنِيّن. لٍوِ بْنسْي، يَكْسِ وٌ بَرَ عَ رَدَنفِ عَ عِ.» ");
INSERT INTO susa_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","مُنسَ مَن نَشَ عَ قَلَ كٌرَ بّ، «لٍوِ بْنسْي شَ دِيٍ، وٌ وٌ تُلِ مَتِ. ");
INSERT INTO susa_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","عِسِرَيِلَ مَرِفِ عَلَ وٌ سُفَندِشِ نّ عِسِرَيِلَ حَمَ يَ مَ عَ شَ هْرْ مْلِنفِرَ وَلِ شَ قٍ رَ. وٌ تَن نَن تِمَ حَمَ يَ رَ عٍ سَلِ تّمُي. نَ مُ وٌ وَ سَ؟ ");
INSERT INTO susa_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","عَ تِنمَ وٌ تَن لٍوِ بْنسْي شَ مَكْرّ عَ رَ، كْنْ وٌ وَ مَ سّرّشّدُبّ وَلِ قَن نَن نَبَقٍ. ");
INSERT INTO susa_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","نَ كُي عِ تَن نُن عِ شَ مِشِيٍ، وٌ بَرَ لَن وٌ بٌورٍ مَ وٌ شَ عَلَتَلَ مَتَندِ. مُنقٍ رَ وٌ نَ تِقٍ هَرُنَ كَنكٍ؟» ");
INSERT INTO susa_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","مُنسَ نَشَ مِشِ شّي عٍلِيَبِ شَ دِ شّمّيٍ دَتَن نُن عَبِرَ مِ شِلِدٍ، كْنْ عٍ نَشَ تٌندِ، عٍ قَ عَ قَلَ، «مُشُ تَن مُ سِفَمَ. ");
INSERT INTO susa_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","مُنقٍ رَ عِ بَرَ مُشُ رَ مِنِ بْشِ مَ، كُمِ نُن شِحّ شّلّمَ دّننَشّ، عَلَكٌ مُشُ شَ قَشَ يِ فبٍنفبٍرٍنيِ مَ؟ عِ مَن وَ مَ عِ يّتّ قِندِقٍ مُشُ شَ مَنفّ رَ؟ ");
INSERT INTO susa_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","عِ مُ مُشُ رَ سٌشِ بْشِ كُي كُمِ نُن شِحّ شّلّمَ دّننَشّ. عِ مُ شّيٍ نُن وّنِ بِلِيٍ شَ قِشِ مُشُ مَ كّ رَ. عِ حْشْ عَ مَ، عَ عِ نُن دْنشُييٍ نَن عَ رَ؟ مُشُ مُ سِفَمَ!» ");
INSERT INTO susa_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","مُنسَ نَشَ شْنْ كِ قَنيِ رَ، عَ عَ قَلَ عَلَتَلَ بّ، «عِ نَشَ عٍ شَ سّرّشّ سُشُ. ﭑ مُ سٍسٍ تٌنفٌشِ عٍ يِ رَ، هَلِ سٌقَلٍ كٍرٍن. ﭑ مُ قٍ حَاشِ يٌ رَبَشِ عٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","مُنسَ نَشَ عَ قَلَ كٌرَ بّ، «عِ تَن نُن عِ شَ مِشِيٍ، تِنَ وٌ نُن هَرُنَ شَ تِ بٍ عَلَتَلَ يَ عِ. ");
INSERT INTO susa_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","وٌ بِرِن شَ وٌ شَ سُرَيِ فَنسٍيٍ تٌنفٌ، وٌ شَ سُرَيِ سَ عَ مَ، وٌ وٌ يّتّ مَسٍن عَلَتَلَ بّ. نَ لَنمَ سُرَيِ فَنسٍ كّمّ قِرِن تٌنفٌ سُولِ نَن مَ. عِ تَن نُن هَرُنَ، وٌ قَن شَ وٌ شَ سُرَيِ فَنسٍ سُشُ وٌ يِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","عٍ بِرِن نَشَ تّ سَ عٍ شَ سُرَيِ فَنسٍيٍ كُي، عٍ نَشَ سُرَيِ سَ عَ مَ، عٍ قَ تِ هْرْ مْلِنفِرَ دّ رَ. مُنسَ نُن هَرُنَ قَن نُ نَ نَا. ");
INSERT INTO susa_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","كٌرَ تٌ حَمَ بِرِن مَلَن مُنسَ نُن هَرُنَ شِلِ مَ هْرْ مْلِنفِرَ دّ رَ، عَلَتَلَ شَ نْرّ نَشَ مِنِ حَمَ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«وٌ مِنِ يِ مِشِيٍ يَ مَ. ﭑ شَ عٍ سْنتْ كٍرٍن نَ!» ");
INSERT INTO susa_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","مُنسَ نُن هَرُنَ نَشَ عٍ يَتَفِ رَقٍلٍن بْشِ مَ، عٍ قَ عَ قَلَ، «عَلَتَلَ، دَالِ بِرِن مَنفّ، عَ لَنمَ عِ شَ شْنْ حَمَ بِرِن مَ، مِشِ كٍرٍن شَ يُنُبِ شَ قٍ رَ؟» ");
INSERT INTO susa_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","عَلَتَلَ نَشَ مُنسَ يَابِ، ");
INSERT INTO susa_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«عَ قَلَ حَمَ بِرِن بّ، عٍ شَ عٍ مَكُيَ كٌرَ، دَتَن، نُن عَبِرَ مِ شْنيِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","مُنسَ نُن عِسِرَيِلَ كُنتِفِيٍ نَشَ سِفَ عَبِرَ مِ نُن دَتَن يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","عَ نَشَ عَ قَلَ حَمَ بّ، «وٌ وٌ مَكُيَ يِ يُنُبِتْييٍ شَ لِنفِرَيٍ رَ. وٌ نَشَ دِن عٍ شَ سٍيٍ رَ، عَلَكٌ وٌ نَشَ قَ قَشَ عٍ شَ يُنُبِيٍ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","حَمَ نَشَ عَ مَسِفَ كٌرَ، دَتَن، نُن عَبِرَ مِ شَ لِنفِرَيٍ رَ. دَتَن نُن عَبِرَ مِ نَشَ مِنِ عٍ شْنيِ، عٍ تِ نَادّ رَ، عٍ نُن عٍ شَ فِنّيٍ، نُن عٍ شَ دِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","مُنسَ نَشَ عَ قَلَ، «وٌ عَ كٌلٌنمَ عَ عَلَتَلَ نَن ﭑ تِشِ يِ وَلِ بِرِن نَ، ﭑ تَن مُ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","شَ يِ مِشِيٍ مُ قَشَ كَابَنَكٌي رَ، عَلَتَلَ مُ ﭑ شّيشِ. ");
INSERT INTO susa_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","كْنْ شَ عَلَتَلَ سَ كَابَنَكٌ رَبَ، عَ بْشِ رَبِ، عٍ فٌرٌ عٍ حِحّ رَ عَ كُي، عٍ تَن نُن عٍ كّ بِرِن، نَ نَن عَ مَسٍنمَ وٌ بّ، عَ عٍ بَرَ عَلَتَلَ مَبٍرٍ.» ");
INSERT INTO susa_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","مُنسَ تٌ فّ نَ قَلَدٍ، بْشِ نَشَ رَبِ عٍ سَنيِ بُن مَ، ");
INSERT INTO susa_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","عَ عٍ فٍرُن، كٌرَ نُن عَ شَ مِشِيٍ، عٍ شَ لِنفِرَيٍ، عَ نُن عٍ شَ هَرِفٍ بِرِن. ");
INSERT INTO susa_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","عٍ نَشَ فٌرٌ عَلِفِيَمَ عٍ حِحّ رَ، عٍ تَن نُن عٍ سْتْسٍ بِرِن. بْشِ نَشَ عٍ مَكٌتٌ، عٍ نَشَ لْي حَمَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","عِسِرَيِلَكَ نَشَن بِرِن نُ نَ عٍ سّيتِ مَ، عٍ نَشَ عٍ فِ عٍ فبٍلٍفبٍلٍ شُي مَ، عٍ نُ قَ عَ قَلَ، «بْشِ نَشَ مُشُ قَن فٍرُن دٍ!» ");
INSERT INTO susa_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","عَلَتَلَ نَشَ تّ رَدِن نَ مِشِ كّمّ قِرِن مِشِ تٌنفٌ سُولِ مَ، نَشٍيٍ سُرَيِ فَن هْرْ مْلِنفِرَ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«عَ قَلَ هَرُنَ سّرّشّدُبّ شَ دِ شّمّ عٍلٍيَسَرِ بّ، عَ شَ سُرَيِ فَنسٍيٍ مَتٌنفٌ تّ شْورَ، عَ شَ عٍ تّ وٌلٍيٍ رَوٌلِ يِرٍ مَكُيٍ. نَ سُرَيِ فَنسٍيٍ بَرَ قِندِ سٍ سّنِيّنشِيٍ رَ عَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","وٌ شَ نَ سُرَيِ فَنسٍيٍ مَتٌنفٌ، يُنُبِتْييٍ نَشٍيٍ رَوَلِشِ عٍ قَ قَشَ، وٌ عٍ بْنبْ هَن عٍ شَ قِندِ عَ كٍبٍلَ رَ، وٌ عٍ سَ سّرّشّبَدٍ مَ. سٍ سّنِيّنشِ نَ عَ رَ بَرِ مَ عَ نُ بَرَ مَسٍن عَلَتَلَ بّ. نَ كُي عَ قِندِ تْنشُمَ نَن نَ عِسِرَيِلَكَيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","عٍلٍيَسَرِ سّرّشّدُبّ نَشَ نَ مِشِيٍ شَ سُرَيِ فَنسٍ وُرٍ فبٍيلِ دَاشِيٍ مَتٌنفٌ، نَ مِشِ قَشَشِيٍ نَشٍيٍ رَوَلِشِ، عَ عٍ بْنبْ هَن عٍ قِندِ كٍبٍلَ رَ، عَ عٍ سَ سّرّشّبَدٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","نَ بَرَ قِندِ تْنشُمَ رَ عِسِرَيِلَكَيٍ بّ، عَلَكٌ عٍ شَ رَتُ عَ مَ عَ مُ لَن مِشِ يٌ شَ سُرَيِ فَن سّرّشّ رَ بَقٍ هَرُنَ شَ دِيٍ، شَ نَ مُ عَ رَ عَ قَن لُمَ نّ عَلْ كٌرَ نُن عَ شَ مِشِيٍ، عَلْ عَلَتَلَ عَ مَسٍنشِ مُنسَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","نَ كُيٍ عِبَ، عِسِرَيِلَ حَمَ نَشَ وْيّن قْلْ مُنسَ نُن هَرُنَ مَ، عَ عٍ تَن نَن عَلَتَلَ شَ حَمَ قَشَشِ. ");
INSERT INTO susa_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","عٍ نُ عٍ مَلَنقٍ تّمُي نَشّ مُنسَ نُن هَرُنَ شِلِ مَ، عٍ نَشَ عَ تٌ نُشُي نَشَ دُ سُ هْرْ مْلِنفِرَ شُن مَ، عَلَتَلَ شَ نْرّ قَ مِنِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","مُنسَ نُن هَرُنَ نَشَ سِفَ هْرْ مْلِنفِرَ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«وٌ مِنِ يِ مِشِيٍ يَ مَ، ﭑ شَ عٍ سْنتْ كٍرٍنيِ رَ.» مُنسَ نُن هَرُنَ نَشَ عٍ يَتَفِ رَقٍلٍن بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","مُنسَ قَ عَ قَلَ هَرُنَ بّ، «عِ شَ تّ وٌلٍ تٌنفٌ سّرّشّبَدٍ يِرٍ، عِ عَ سَ عِ شَ سُرَيِ فَنسٍ كُي عَ نُن سُرَيِ ندٍ. نَ شَنِن مَقُرٍن مَقُرٍن حَمَ مَبِرِ، عِ سَ يُنُبِ شَقَرِ مَشَندِ عٍ بّ. عَلَتَلَ بَرَ عَ شَ شْنّ قُلُن يِ حَمَ شِلِ مَ، سْنتْي حَن بَرَ قْلْ.» ");
INSERT INTO susa_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","هَرُنَ نَشَ سُرَيِ فَنسٍ تٌنفٌ عَلْ مُنسَ عَ قَلَ عَ بّ كِ نَشّ، عَ عَ فِ عَ سِفَ حَمَ يِرٍ، سْنتْي نُ بَرَ قْلْ دّننَشّ. عَ نَشَ سُرَيِ بَ سّرّشّ رَ، عَ قَ يُنُبِ شَقَرِ مَشَندِ حَمَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","عَ نَشَ تِ مِشِ قَشَشِيٍ نُن مِشِ حِحّيٍ تَفِ. مِشِ قَشَقٍ نَشَ دَن. ");
INSERT INTO susa_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","مِشِ وُلُ قُ نُن نَانِ مِشِ كّمّ سٌلٌقٍرٍ نَن قَشَ، بَقٍ كٌرَ شَ مِشِيٍ رَ، نَشٍيٍ سِنفٍ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","مِشِ قَشَقٍ تٌ دَن، هَرُنَ نَشَ فبِلٍن مُنسَ يِرٍ هْرْ مْلِنفِرَ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، بْنسْي شُنيِ بِرِن شَ يِسُشُوُرِ كٍرٍن سٌ عِ يِ رَ، نَ لَنمَ يِسُشُوُرِ قُ نُن قِرِن نَن مَ. عِ شَ بْنسْي بِرِن شِلِ سّبّ عَ شَ يِسُشُوُرِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","عِ شَ هَرُنَ شِلِ سّبّ لٍوِ بْنسْي شَ يِسُشُوُرِ مَ. بْنسْي شُنيِ بِرِن شَ يِسُشُوُرِ شَ لُ نَا. ");
INSERT INTO susa_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","عِ نَ يِسُشُوُرِيٍ سَمَ هْرْ مْلِنفِرَ نَن كُي، سَاتّ كَنكِرَ يَ تٌدٍ رَ، ﭑ لُمَ ﭑ يّتّ مَسٍن نَ وٌ بّ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","ﭑ مِشِ نَشَن سُفَندِشِ، نَ كَنيِ شَ يِسُشُوُرِ مَبُتُنمَ نّ. نَ كُي، ﭑ بَرَ عَ نِيَ عِسِرَيِلَكَيٍ نَشَ وْيّن وٌ مَ سْنْن.» ");
INSERT INTO susa_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","مُنسَ نَشَ دّنتّفّ سَ عِسِرَيِلَكَيٍ بّ. عِسِرَيِلَ بْنسْي شُنيِ بِرِن نَشَ قَ عٍ شَ يِسُشُوُرِ رَ. نَ نَشَ لَن يِسُشُوُرِ قُ نُن قِرِن مَ. هَرُنَ فبٍ نُ نَ عٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","مُنسَ نَشَ نَ يِسُشُوُرِيٍ سَ عَلَتَلَ يَ عِ، هْرْ مْلِنفِرَ كُي، سَاتّ كَنكِرَ نَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","نَ كُيٍ عِبَ، عَ تٌ سٌ هْرْ مْلِنفِرَ كُي، عَ نَشَ عَ تٌ هَرُنَ شَ يِسُشُوُرِ، نَشَن سَ لٍوِ بْنسْي شِلِ رَ، عَ بَرَ بُتُن، عَ بَرَ قُفَ، عَ تَمَرٍ بٌفِ فبٍيلِ رَ مِنِ. ");
INSERT INTO susa_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","مُنسَ نَشَ يِسُشُوُرِ بِرِن نَمِنِ، عَ عٍ مَسٍن عِسِرَيِلَ حَمَ بّ. بْنسْي شُنيِ بِرِن تٌ عٍ تٌ، عٍ نَشَ عٍ فبٍ تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ مَن شَ هَرُنَ شَ يِسُشُوُرِ رَفبِلٍن سَاتّ كَنكِرَ يِرٍ، عَ شَ رَفَتَ تْنشُمَ رَ مَتَندِلَيٍ بّ. نَ كُي عٍ مُ وْيّنمَ ﭑ مَ، عٍ مُ قَشَ.» ");
INSERT INTO susa_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ رَبَتُ، عَلْ عَ مَسٍن عَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","عِسِرَيِلَكَيٍ نَشَ عَ قَلَ مُنسَ بّ، «عَ مَتٌ، مُشُ بِرِن حْنمَ نّ هَلَكِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","نَشَن يٌ عَ مَسٌ عَلَتَلَ شَ هْرْ مْلِنفِرَ رَ، نَ كَنيِ قَشَمَ نّ. مُشُ بِرِن شَ سْنتْ؟» ");
INSERT INTO susa_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","عَلَتَلَ نَشَ عَ مَسٍن هَرُنَ بّ، «عِ تَن، عِ شَ دِيٍ، نُن لٍوِ بْنسْي بِرِن، وٌ تَن نَن يُنُبِ سْتْمَ شَ قٍ حَاشِ سَ رَبَ هْرْ مْلِنفِرَ شَ قٍ رَ. هَرُنَ عِ تَن نُن عِ شَ دِيٍ، وٌ تَن نَن يُنُبِ سْتْمَ شَ قٍ حَاشِ سَ رَبَ سّرّشّدُبّحَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","عِ شَ لٍوِ بْنسْي مِشِ بِرِن مَسٌ عِ رَ، عَلَكٌ عٍ شَ عِ تَن نُن عِ شَ دِيٍ مَلِ وٌ شَ وَلِ رَ هْرْ مْلِنفِرَ كُي. ");
INSERT INTO susa_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","عٍ عِ مَلِمَ هْرْ مْلِنفِرَ وَلِ كُي، كْنْ عٍ نَشَ مَكْرّ يِرَبَسٍ سّنِيّنشِيٍ نُن سّرّشّبَدٍ رَ، عَلَكٌ وٌ نَشَ قَشَ، عٍ تَن نُن عِ تَن. ");
INSERT INTO susa_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","عٍ بِرَ مَ نّ عِ قْشْ رَ عِ شَ هْرْ مْلِنفِرَ وَلِ بِرِن كُي. مِشِ فبّتّ يٌ نَشَ سُنبُ وٌ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","وٌ تَن فبَنسَن شَ سّنِيّن لِنفِرَ نُن سّرّشّبَدٍ وَلِ رَبَ، عَلَكٌ عَلَتَلَ نَشَ قَ عَ شَ شْنّ رَ مِنِ عِسِرَيِلَكَيٍ مَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ﭑ تَن نَن وٌ نفَشَكٍرٍنيِ لٍوِ بْنسْي تٌنفٌشِ عِسِرَيِلَكَيٍ يَ مَ ﭑ يّتّ بّ. ﭑ بَرَ عٍ سَ وٌ سَفٌي، عٍ شَ وٌ مَلِ هْرْ مْلِنفِرَ وَلِ رَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","عِ تَن نُن عِ شَ دِيٍ، وٌ حْشْ سَمَ نّ وٌ شَ سّرّشّدُبّ وَلِ شْن مَ سّرّشّبَدٍ نُن يِرٍ سّنِيّنشِ قِسَمَنتٍ، نَشَن نَ دُفِ فبَكُشِ شَنبِ رَ. ﭑ تَن نَن نَ وَلِ قِشِ وٌ مَ. مِشِ فبّتّ نَ عَ مَسٌ نَ رَ، عَ قَشَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","عَلَتَلَ نَشَ عَ قَلَ هَرُنَ بّ، «ﭑ بَرَ عِسِرَيِلَكَيٍ شَ هَدِيَ سّنِيّنشِ بِرِن قِ عِ تَن نُن عِ شَ دِيٍ مَ، بَرِ مَ وٌ تَن نَن سُفَندِشِ سّرّشّدُبّيٍ رَ عَبَدَن. ");
INSERT INTO susa_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","سٍيٍ نَن يِ كِ نَشٍيٍ قِندِ مَ عِ فبٍ رَ سٍ سّنِيّنشِيٍ تَفِ، تّ مُ نَشٍيٍ فَنشِ؛ عِسِرَيِلَكَيٍ شَ سّرّشّ، عٍ شَ سَنسِ شْرِ دِنشِ سّرّشّيٍ، عٍ شَ يُنُبِ شَقَرِ سّرّشّيٍ، نُن عٍ شَ يّتّ رَفبِلٍن سّرّشّيٍ. نَ سّرّشّ سّنِيّنشِيٍ قِندِ مَ عِ تَن نُن عِ شَ دِيٍ نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","وٌ نٍيٍ دٌنمَ نّ عَلْ سٍ سّنِيّنشِيٍ. شّمّ بِرِن نْمَ عٍ دٌندٍ وٌ شَ دٍنبَيَ كُي. سٍ سّنِيّنشِيٍ نَن عٍ رَ وٌ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«سٍ نَشٍيٍ بَشِ عِسِرَيِلَكَيٍ شَ هَدِيَ سّنِيّنشِيٍ رَ، ﭑ نٍيٍ قَن قِمَ نّ عِ مَ، نَشٍيٍ لِنتَنمَ ﭑ يَ عِ عَ مَسٍنقٍ رَ ﭑ فبٍ نَ عَ رَ. ﭑ نَ قِمَ عِ تَن، عِ شَ دِ شّمّيٍ، نُن عِ شَ دِ فِنّيٍ مَ. عِ شَ مِشِ بِرِن نَشٍيٍ سّنِيّنشِ عٍ نْمَ نَ دٌندٍ. ");
INSERT INTO susa_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ﭑ مَن بَرَ دَشَمُي سِنفٍيٍ قِ عِ مَ، عِسِرَيِلَكَيٍ نَشٍيٍ بَمَ ﭑ نَ هَدِيَ رَ عَلْ تُرٍ، وّنِ، نُن سَنسِ شْرِيٍ دِنشِ. ");
INSERT INTO susa_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","دَشَمُي سِنفٍيٍ عٍ قَمَ نَشَن بِرِن نَ ﭑ بّ، نَ بِرِن قِندِ مَ عِ فبٍ نَن نَ. عِ شَ مِشِ بِرِن نَشٍيٍ سّنِيّنشِ عٍ نْمَ نَ دٌندٍ.» ");
INSERT INTO susa_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«سٍ نَشَن بِرِن هَرَ مُشِ مِشِيٍ بّ عِسِرَيِلَ بْشِ مَ، عَ قَ قِندِ ﭑ فبٍ رَ، ﭑ بَرَ نَ قِ عِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","دِ سِنفٍ بِرِن نَشٍيٍ قِمَ عَلَتَلَ مَ، عَ قِندِ مِشِ رَ، عَ قِندِ شُرُ سٍ رَ، نَ بِرِن عِ تَن نَن فبٍ عَ رَ. كْنْ عِبُنَدَ مَ شَ دِ شّمّ سِنفٍ نُن سُبٍ هَرَ مُشِ شَ دِ شّمّ سِنفٍ، عٍ تَن شُن سَرَ مَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","عٍ نَ كِكٍ كٍرٍن سْتْ، عٍ شُن شَ سَرَ فبٍتِ كٌلٍ سُولِ، نَشَن كٌلٍ كٍرٍن لَنمَ فِرَ مُ قُ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«كْنْ عِ نَشَ نِنفٍيٍ، يّشّييٍ، نُن سِيٍ شَ دِ سِنفٍيٍ شُن سَرَ، بَرِ مَ عٍ تَن سّنِيّنشِ. عٍ وُلِ شَ كَسَن سّرّشّبَدٍ مَ، عٍ تُرٍ شَ بَ سّرّشّ رَ. عٍ شَ فَن تّ رَ عَلَتَلَ بّ. نَ رَقَن عَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","عٍ فَنيَنيِ نُن عٍ يِرٍقَنيِ تَبٍ قِندِ مَ عِ فبٍ نَن نَ، بَرِ مَ عٍ نُ لِنتَنشِ ﭑ تَن عَلَتَلَ يَ عِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ﭑ بَرَ نٍيٍ قِ عِ تَن نُن عِ شَ دِيٍ مَ عَبَدَن، عِسِرَيِلَكَ نَشَن بِرِن بَمَ عٍ شَ سّرّشّ سّنِيّنشِيٍ رَ عَلَتَلَ بّ. سَاتّ نَن عَ رَ نَشَن مُ كَنَمَ عَبَدَن، عِ تَن نُن عِ بْنسْي بِرِن بّ عَلَتَلَ يَ عِ.» ");
INSERT INTO susa_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","عَلَتَلَ نَشَ عَ مَسٍن هَرُنَ بّ، «عِ مُ كّ سْتْمَ عِسِرَيِلَ بْشِ مَ عَلْ بٌورٍ. ﭑ تَن نَن قِندِ مَ عِ كّ رَ عِسِرَيِلَكَيٍ تَفِ. عِ هَيِ مُ نَ سٍسٍ فبّتّ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«ﭑ عِسِرَيِلَ شَ قَرِلّ قِمَ لٍوِ بْنسْي نَن مَ سَرٍ رَ عٍ شَ هْرْ مْلِنفِرَ وَلِ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","عِسِرَيِلَكَيٍ نَشَ عٍ مَسٌ هْرْ مْلِنفِرَ رَ سْنْن، عَلَكٌ عٍ نَشَ قَ يُنُبِ سْتْ نَ كُي عٍ قَشَمَ نَشَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","لٍوِ بْنسْي نَن هْرْ مْلِنفِرَ شَ وَلِ رَبَمَ. شَ يُنُبِ يٌ سَ مِنِ نَ وَلِ كُي، عٍ تَن نَن عَ كٌتٍ تٌنفٌمَ. نَ قِندِ مَ سّرِيّ نَن نَ وٌ بّ عَبَدَن. لٍوِ بْنسْي مُ قَمَ كّ سْتْدٍ عِسِرَيِلَكَيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ﭑ بَرَ عِسِرَيِلَكَيٍ شَ قَرِلّ قِ لٍوِ بْنسْي مَ كّ رَ. نَ نَن عَ تٌشِ، ﭑ نَ عَ قَلَشِ عٍ شَ قٍ رَ، كّ مُ نَ عٍ تَن بّ عِسِرَيِلَكَيٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«عَ قَلَ لٍوِ بْنسْي بّ، ‹عِسِرَيِلَكَيٍ نَ قَ عٍ شَ قَرِلّ رَ، ﭑ نَشَن قِمَ وٌ مَ، وٌ شَ نَ قَرِلّ شَ قَرِلّ بَ ﭑ تَن بّ. ");
INSERT INTO susa_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","نَ كُي وٌ قَن عَ رَبَمَ نّ عَلْ وٌ نفَشَكٍرٍنيِ نَشٍيٍ قَرِلّ بَمَ عٍ شَ سَنسِ شْرِ رَ لٌنيِ يِرٍ، شَ نَ مُ عَ رَ عٍ شَ وّنِ رَ عٍ عَ بُندُ مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","وٌ شَ وٌ شَ هَدِيَ بَ ﭑ بّ عِسِرَيِلَكَيٍ شَ قَرِلّ رَ، وٌ قَ عَ سٌ هَرُنَ سّرّشّدُبّ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","وٌ شَ قَرِلّ بَ ﭑ بّ هَدِيَ رَ وٌ نَشَن بِرِن سْتْمَ. وٌ شَ دَشَمُي سِنفٍيٍ وٌ نَشٍيٍ سْتْمَ، وٌ شَ ﭑ فبٍ بَ نَ رَ.› ");
INSERT INTO susa_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","عِ مَن شَ عَ قَلَ عٍ بّ، ‹وٌ نَ فّ دَشَمُي قِسَمَنتٍ بَدٍ ﭑ بّ، وٌ شَ نَ قَرِلّ بَ سَنسِ شْرِ نُن وّنِ رَ لٍوِ بْنسْي بّ. ");
INSERT INTO susa_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","وٌ تَن نُن وٌ شَ دٍنبَيَيٍ نْمَ نَ دٌندٍ وٌ وَ مَ عَ شْن دّننَشّ. وٌ شَ هْرْ مْلِنفِرَ وَلِ سَرٍ نَن نَ كِ. ");
INSERT INTO susa_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","دَشَمُي سِنفٍيٍ بَقٍ مُ قِندِ مَ يُنُبِ رَ وٌ بّ. وٌ مُ عِسِرَيِلَكَيٍ شَ هَدِيَ سّنِيّنشِيٍ مَبٍرٍ مَ نَ كُي، وٌ مَن مُ قَشَمَ نَ شَ قٍ رَ.›» ");
INSERT INTO susa_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«عَلَ شَ سّرِيّ نَن يَ. عِسِرَيِلَكَيٍ شَ قَ نِنفٍ فِنّ فبٍيلِ رَ، نَشَن مُ مَبّنشِ، لَنيُرُ مُ نَ نَشَن مَ، عَ نُن نَشَن مُ سَرِ بّندُنشِ سِندٍن. ");
INSERT INTO susa_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","عِ شَ نَ سٌ عٍلٍيَسَرِ سّرّشّدُبّ يِ رَ، عَ كْن قَ رَشَبَ عَ يَ شْرِ يٌنكِندٍ قَرِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","عٍلٍيَسَرِ شَ عَ وُلِ ندٍ كَسَن عَ بّلّشّسٌلٍ رَ هْرْ مْلِنفِرَ سٌدٍ مَبِرِ سَنمَيَ سٌلٌقٍرٍ. ");
INSERT INTO susa_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","عٍ شَ نَ نِنفٍ فُندِ بِرِن فَن عَ يَ شْرِ، عَ كِرِ، عَ سُبٍ، عَ وُلِ، نُن عَ حَحّ. ");
INSERT INTO susa_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","نَ نِنفٍ نَ فَنقٍ تّمُي نَشّ، سّرّشّدُبّ شَ سّدِرِ وُرِ ندٍ، هِسٌثِ، نُن فّسّ فبٍيلِ وٌلِ تّ شْورَ.» ");
INSERT INTO susa_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","«نَ دَنفِ شَنبِ، سّرّشّدُبّ شَ عَ قَتٍ نُن عَ شَ سٌسٍيٍ مَشَ، عَ قَ سٌ يٌنكِن يِرٍ، كْنْ عَ مُ سّنِيّنشِ هَن نُنمَرٍ. ");
INSERT INTO susa_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","نَشَن بَرَ نِنفٍ فَن، نَ قَن شَ عَ قَتٍ نُن عَ شَ سٌسٍيٍ مَشَ، كْنْ عَ مُ سّنِيّنشِ هَن نُنمَرٍ. ");
INSERT INTO susa_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","مِشِ سّنِيّنشِ ندٍ شَ نَ نِنفٍ فَنشِ شُبٍ مَكْ، عَ سَ عٍ سَ يِرٍ سّنِيّنشِ يٌنكِندٍ قَرِ مَ. عَ رَفَتَمَ مّننِ نّ عِسِرَيِلَ حَمَ بّ عَلَكٌ عٍ شَ مَرَ سّنِيّن يّ يَءِلَن عَ رَ. يُنُبِ شَقَرِ سّرّشّ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","نَشَن بَرَ نَ نِنفٍ فَنشِ شُبٍ مَكْ، نَ قَن شَ عَ قَتٍ نُن عَ شَ دُفِيٍ شَ، كْنْ عَ مُ سّنِيّنشِ هَن نُنمَرٍ. نَ سّرِيّ مُ كَنَمَ عَبَدَن عِسِرَيِلَكَيٍ نُن عٍ شْحّيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«نَشَن نَ دِن مِشِ قَشَشِ رَ، نَ كَنيِ قِندِ مَ سّنِيّنتَرٍ نَن نَ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","عَ شَ عَ يّتّ رَ سّنِيّن يِ مَرَ سّنِيّن يٍ رَ عَ شِ سَشَن ندٍ نُن عَ شِ سٌلٌقٍرٍ ندٍ مَ. شَ عَ مُ عَ رَبَ نَ شِ سَشَن ندٍ نُن نَ شِ سٌلٌقٍرٍ ندٍ مَ، عَ مُ سّنِيّنمَ. ");
INSERT INTO susa_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","شَ نَشَن يٌ دِن مِشِ قَشَشِ قُرٍ رَ، عَ قَ لُ عَ مُ عَ يّتّ رَ سّنِيّن، نَ كَنيِ شَ سّنِيّنتَرٍحَ دَنفِمَ نّ عَلَتَلَ شَ هْرْ مْلِنفِرَ مَ. نَ كَنيِ شَ كٍرِ عِسِرَيِلَكَيٍ يَ مَ. مَرَ سّنِيّن يٍ تٌ مُ كَسَنشِ عَ مَ، عَ مُ سّنِيّنشِ.» ");
INSERT INTO susa_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«سّرِيّ نَن يَ؛ شَ مِشِ قَشَ كِرِ بَنشِ ندٍ كُي، مِشِ يٌ نَشَن نَ نَا، شَ نَ مُ عَ رَ عَ سٌمَ نَا، نَ كَنيِ قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","سٍسَسٍ رَبِشِ بِرِن قِندِ مَ سٍ سّنِيّنتَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","مِشِ نَشَن دِن مِشِ قَشَشِ رَ وُلَ عِ، نَشَن بَرَ قَشَ عَ حَاشِ رَ، شَ نَ مُ عَ قَشَ عَ يّتّ مَ، نَ كَنيِ قِندِ مَ سّنِيّنتَرٍ نَن نَ شِ سٌلٌقٍرٍ بُن مَ. نَشَن دِن مِشِ قَشَشِ شْرِيٍ رَ، شَ نَ مُ عَ فَبُرِ رَ، نَ قَن مُ سّنِيّنشِ شِ سٌلٌقٍرٍ بُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«عَ لَنمَ نَ مِشِ مْولِ شَ سّنِيّن يٍ رَ، نَشَن مَسُنبُشِ نَ نِنفٍ فَنشِ شُبٍ رَ. نَ يٍ شَ تٌنفٌ دُلٌنيِ يِرٍ، شَ نَ مُ عَ رَ شُرٍ. ");
INSERT INTO susa_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","شّمّ سّنِيّنشِ ندٍ شَ هِسٌثِ وُرِ سَلٌنيِ تٌنفٌ، عَ عَ رَ سِن نَ يٍ شْورَ، عَ عَ كَسَن نَ كِرِ بَنشِ مَ، عَ كُي سٍ بِرِن مَ، نُن مِشِيٍ مَ نَشٍيٍ نُ نَ عَ كُي. عٍ مَن شَ نَ رَبَ مِشِ رَ نَشَن دِنشِ مِشِ قُرٍ رَ، نَشَن قَشَ عَ حَاشِ رَ، شَ نَ مُ عَ رَ نَشَن قَشَ عَ يّتّ مَ، عَ نُن مِشِ نَشَن دِنشِ مِشِ شْرِيٍ رَ، شَ نَ مُ فَبُرِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","مِشِ سّنِيّنشِ شَ نَ يٍ كَسَن مِشِ سّنِيّنتَرٍ مَ عَ شِ سَشَن ندٍ نُن عَ شِ سٌلٌقٍرٍ ندٍ. عَ نَ فّ نَ رَ، عَ شَ عَ يّتّ نُن عَ شَ سٌسٍيٍ مَشَ يٍ رَ، عَ قَ قِندِ مِشِ سّنِيّنشِ رَ نَ شِ سٌلٌقٍرٍ نُنمَرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«مِشِ نَشَن تٌندِ عَ يّتّ رَ سّنِيّندٍ، نَ كَنيِ شَ كٍرِ حَمَ يَ مَ، بَرِ مَ عَ شَ سّنِيّنتَرٍحَ دَنفِمَ نّ عَلَتَلَ شَ هْرْ مْلِنفِرَ مَ. عَ تٌ مُ كَسَنشِ مَرَ سّنِيّن يٍ رَ، عَ مُ سّنِيّنشِ. ");
INSERT INTO susa_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","يَامَرِ نَن نَ كِ عِسِرَيِلَكَيٍ بّ نَشَن مُ كَنَمَ عَبَدَن.» «مَرَ سّنِيّن يٍ كَسَنمَ نَشَن مَ، نَ كَنيِ شَ عَ شَ دُفِيٍ شَ. عَ مُ سّنِيّنمَ قٌ نُنمَرٍ. ");
INSERT INTO susa_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","مِشِ سّنِيّنتَرٍ دِنمَ سٍ نَشَن نَ، نَ سٍ بَرَ قِندِ سٍ سّنِيّنتَرٍ رَ. مِشِ نَشَن دِنمَ نَ سٍ رَ، نَ قَن قِندِ مَ مِشِ سّنِيّنتَرٍ نَن نَ هَن نُنمَرٍ.» ");
INSERT INTO susa_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","كِكٍ سِنفٍ، عِسِرَيِلَ حَمَ بِرِن نَشَ سٌ سِنِ فبٍنفبٍرٍنيِ مَ، عٍ يٌنكِن كَدٍ سِ. مَرِيَمَ نَشَ قَشَ مّننِ، عٍ قَ عَ رَفَتَ فَبُرِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","يٍ تٌ مُ نُ نَ حَمَ يِ رَ، عٍ نَشَ عٍ مَلَن مُنسَ نُن هَرُنَ شِلِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","عٍ نَشَ سْنشْ مُنسَ رَ، عٍ نُ عَ قَلَ، «عَ نُ قِسَ مُشُ قَن شَ قَشَ عَلَتَلَ مُشُ نفَشَكٍرٍنيِيٍ قَشَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","مُنقٍ رَ وٌ عَلَتَلَ شَ حَمَ رَقَشِ يِ فبٍنفبٍرٍنيِ مَ، مُشُ نُن مُشُ شَ شُرُ سٍيٍ شَ قَشَ؟ ");
INSERT INTO susa_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","مُنقٍ رَ وٌ مُشُ رَ مِنِشِ مِسِرَ بْشِ رَ قَقٍ رَ يِ يِرٍ حَاشِ، شْرّ بِلِ، وّنِ بِلِ، فِرٍنَدِ وُرِ بِلِ مُ نَ دّننَشّ. هَلِ يٍ مِن دَاشِ مُ سْتْمَ بٍ.» ");
INSERT INTO susa_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","مُنسَ نُن هَرُنَ نَشَ كٍلِ حَمَ يَ مَ، عٍ عٍ قٍلٍن هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عَلَتَلَ شَ نْرّ نَشَ مِنِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«عِ شَ يِسُشُوُرِ تٌنفٌ. عِ تَن نُن عِ تَارَ هَرُنَ، وٌ شَ عِسِرَيِلَكَ بِرِن مَلَن، وٌ وْيّن قَنيٍ رَ عٍ يَ شْرِ، عَلَكٌ عَ شَ يٍ رَ مِنِ. وٌ يٍ رَ مِنِمَ نّ عِسِرَيِلَ حَمَ بّ عَلَكٌ عٍ تَن نُن عٍ شَ شُرُ سٍيٍ شَ يٍ مِن.» ");
INSERT INTO susa_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","مُنسَ نَشَ عَ شَ يِسُشُوُرِ تٌنفٌ نَشَن نُ نَ هْرْ مْلِنفِرَ كُي، عَلْ عَلَتَلَ عَ يَمَرِ عَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","مُنسَ نُن هَرُنَ نَشَ حَمَ مَلَن نَ قَنيٍ يَ رَ، عٍ قَ عَ قَلَ عٍ بّ، «وٌ تُلِ مَتِ، وٌ تَن مَتَندِلَيٍ. مُشُ شَ يٍ رَ مِنِ وٌ بّ يِ قَنيٍ كُي؟» ");
INSERT INTO susa_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","مُنسَ نَشَ عَ بّلّشّ عِتٍ، عَ قَنيٍ بْنبْ سَنيَ قِرِن عَ شَ يِسُشُوُرِ رَ. يٍ نَشَ فبُسَن قَنيٍ رَ، حَمَ نُن شُرُ سٍ بِرِن نَشَ عٍ مِن. ");
INSERT INTO susa_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","كْنْ عَلَتَلَ نَشَ عَ مَسٍن مُنسَ نُن هَرُنَ بّ، «وٌ تٌ مُ لَشِ ﭑ نَ، عِسِرَيِلَ حَمَ يَ شْرِ، وٌ شَ بِنيّ تِ ﭑ تَن سّنِيّنتْي مَ، وٌ تَن مُ قَمَ يِ حَمَ رَ سٌدٍ نَ بْشِ مَ ﭑ دّننَشّ قِشِ عٍ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","عٍ مّننِ نَن شِلِ مٍرِبَ يٍ، بَرِ مَ عِسِرَيِلَكَيٍ سْنشْ عَلَتَلَ مَ مّننِ نّ، عَ قَ عَ شَ سّنِيّنيِ مَسٍن عٍ بّ. ");
INSERT INTO susa_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","مُنسَ نَشَ شّيرَيٍ شّي عٍدٌن مَنفّ مَ كٍلِ كَدٍ سِ، عَ قَلَقٍ رَ عَ بّ، «عِ نفَشَكٍرٍنيِ عِسِرَيِلَكَيٍ شُي نَن يَ! عِ عَ كٌلٌن مُشُ تْورْشِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","مُشُ بٍنبَيٍ فٌرٌ نّ مِسِرَ، مُشُ نَشَ حّ وُيَشِ رَبَ مّننِ. كْنْ مِسِرَكَيٍ نَشَ مُشُ نُن مُشُ بٍنبَيٍ حَشَنكَتَ. ");
INSERT INTO susa_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","مُشُ نَشَ عَلَتَلَ مَشَندِ، عَ قَ مُشُ شُي رَ مّ. عَ نَشَ عَ شَ مَلٍكّ شّي مُشُ رَ مِنِدٍ مِسِرَ. يَكْسِ مُشُ نَ بٍ كَدٍ سِ نَشَن نَ وٌ شَ نَانِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","عَ لُ مُشُ شَ دَنفِ وٌ شَ بْشِ تَفِ. مُشُ مُ وٌ شَ شّيٍ نُن وٌ شَ وّنِ بِلِيٍ كَنَمَ. مُشُ مُ يٍ بَمَ وٌ شَ كْلْنيِيٍ كُي. مُشُ مُ سِفَمَ كْولَ مَ، مُشُ مُ قَمَ يِرٍقَنيِ مَ. مُشُ تِمَ وٌ شَ كِرَ شُنفبٍ كٍرٍنيِ نَن شْن، هَن مُشُ دَنفِمَ وٌ شَ بْشِ رَ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","عٍدٌن مَنفّ نَشَ عَ يَابِ، «وٌ مُ دَنفِمَ مُشُ شَ بْشِ رَ قٍقٍ مَ، شَ نَ مُ مُشُ وٌ فٍرٍ مَ سَنتِدّفّمَ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","عِسِرَيِلَكَيٍ مَن نَشَ عَ قَلَ عَ بّ، «مُشُ تَن دَنفِمَ نّ كِرَ شْن. شَ مُشُ نُن مُشُ شَ شُرُ سٍيٍ وٌ شَ يٍ ندٍ مِن، مُشُ شَ عَ سَرٍ قِ. مُشُ مُ عِ مَشْرِنشِ سٍسٍ مَ، مُشُ وَ مَ دَنفِقٍ نّ تُن.» ");
INSERT INTO susa_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","عٍدٌن مَنفّ مَن نَشَ عَ يَابِ، «وٌ مُ دَنفِمَ قٍوٌ!» نَ كُي، عَ نَشَ عَ شَ سْورِيٍ رَ مِنِ عَ سّنبّ كِ مَ عِسِرَيِلَكَيٍ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","عٍدٌن مَنفّ تٌ تٌندِ عِسِرَيِلَكَيٍ شَ دَنفِ عَ شَ بْشِ رَ، عِسِرَيِلَ نَشَ فبِلٍن. ");
INSERT INTO susa_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","عِسِرَيِلَ حَمَ نَشَ كٍلِ كَدٍ سِ، عٍ نَشَ سِفَ هٌرٌ فٍيَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","عَلَتَلَ نَشَ عَ قَلَ مُنسَ نُن هَرُنَ بّ هٌرٌ فٍيَ يِرٍ، عٍدٌن شَ بْشِ نَانِنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«هَرُنَ قَمَ نّ عَ بٍنبَيٍ لِدٍ عَلِفِيَمَ. عَ مُ سٌمَ نَ بْشِ مَ ﭑ دّننَشّ قِشِ عِسِرَيِلَكَيٍ مَ، بَرِ مَ وٌ بَرَ ﭑ مَ يَامَرِ مَتَندِ مٍرِبَ يٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","عِ شَ هَرُنَ نُن عَ شَ دِ شّمّ عٍلٍيَسَرِ شَنِن هٌرٌ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","مّننِ عِ شَ سّرّشّدُبّ دُفِيٍ بَ هَرُنَ مَ، عِ عٍ رَفٌرٌ عَ شَ دِ شّمّ عٍلٍيَسَرِ مَ. هَرُنَ لَاشِرَ مَ نّ مّننِ، عَ قَ عَ بٍنبَيٍ يِرٍ لِ.» ");
INSERT INTO susa_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","مُنسَ نَشَ عَ رَبَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. عٍ نَشَ تٍ هٌرٌ فٍيَ قَرِ عِسِرَيِلَكَ بِرِن يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","مُنسَ نَشَ هَرُنَ شَ دٌنمَيٍ بَ عَ مَ، عَ عٍ رَفٌرٌ عَ شَ دِ شّمّ عٍلٍيَسَرِ مَ. هَرُنَ نَشَ لَاشِرَ فٍيَ قَرِ. مُنسَ نُن عٍلٍيَسَرِ نَشَ فٌرٌ فٍيَ رَ، ");
INSERT INTO susa_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","عٍ قَ عِسِرَيِلَ حَمَ رَكٌلٌن هَرُنَ قَشَ قٍ رَ. عِسِرَيِلَ نَشَ عَ حْن قٍ رَبَ شِ تٌنفٌ سَشَن بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","عَرَدِ مَنفّ كَنَانكَ، نَشَن نُ سَبَتِشِ نٍفٍوِ بْشِ مَ، عَ تٌ عَ مّ، عَ عِسِرَيِلَ نُ مِنِقٍ عَتَرِ مَ كِرَ نَن نَ، عَ نَشَ عٍ فٍرٍ، عَ ندٍيٍ قِندِ فٍيلِمَنِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","نَ كُي عِسِرَيِلَ نَشَ يِ لَايِدِ تٌنفٌ عَلَتَلَ بّ، «شَ عِ يِ مِشِيٍ سَ مُشُ سَفٌي، مُشُ عٍ شَ تَا بِرِن كَنَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","عَلَتَلَ نَشَ تِن عِسِرَيِلَكَيٍ شَ لَايِدِ رَ، عَ نَشَ كَنَانكَيٍ سَ عٍ سَفٌي. عِسِرَيِلَكَيٍ نَشَ عٍ سْنتْ، عٍ عٍ شَ تَايٍ كَنَ. نَ نَن عَ تٌشِ عٍ نَشَ مّننِ شِلِ سَ هٌرٌ مَ، نَشَن وَ مَ عَ قَلَقٍ «فبَلٌي.» ");
INSERT INTO susa_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","عِسِرَيِلَكَيٍ نَشَ كٍلِ هٌرٌ فٍيَ مَ شُلُنيُمِ بَا كِرَ شْن مَ، عَلَكٌ عٍ شَ عٍدٌن بْشِ مَبِلِن. كْنْ لِمَنِيَ نَشَ بَ عٍ يِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","عٍ قَ عَ قَلَ عَلَتَلَ نُن مُنسَ بّ، «مُنقٍ رَ وٌ مُشُ رَ مِنِشِ مِسِرَ بْشِ رَ، عَلَكٌ مُشُ شَ قَ قَشَ فبٍنفبٍرٍنيِ مَ؟ تَامِ مُ نَ بٍ، يٍ مُ نَ بٍ، قٌ يِ دٌنسٍ حَاشِ نَشَن فٌرٌ مَ كٌورٍ مَ!» ");
INSERT INTO susa_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","نَ كُي عَلَتَلَ نَشَ عَ نِيَ بْشِمَسٍيٍ شَ مِنِ عٍ تَفِ، عٍ شَ مِشِيٍ شِن، عٍ مِشِ فبٍفبٍ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","حَمَ نَشَ عَ قَلَ مُنسَ بّ، «مُشُ بَرَ يُنُبِ رَبَ وْيّنقٍ رَ عِ تَن نُن عَلَتَلَ مَ. عِ شَ عَلَتَلَ مَشَندِ مُشُ بّ، عَ شَ يِ بْشِمَسٍيٍ مَكُيَ مُشُ رَ.» مُنسَ نَشَ تِن نَ رَ، عَ عَلَتَلَ مَشَندِ حَمَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","عَلَتَلَ نَشَ عَ يَابِ، «بْشِمَسٍ مِسَالِ رَقَلَ وُرٍ فبٍيلِ رَ، عَ فبَكُ وُرِ كُيٍ رَ. مِشِ شِنشِ نَشَن عَ يَ تِمَ نَ رَ، عَ مُ قَشَمَ.» ");
INSERT INTO susa_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","مُنسَ نَشَ بْشِمَسٍ يَءِلَن وُرٍ فبٍيلِ رَ، عَ عَ فبَكُ وُرِ كُيٍ رَ. نَ تّمُي بْشِمَسٍيٍ مِشِ نَشٍيٍ شِنشِ، عٍ نُ نْمَ عٍ يَ تِدٍ نَ رَ، عٍ كِسِ. ");
INSERT INTO susa_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","عِسِرَيِلَكَيٍ نَشَ سِفَ، عٍ سَ يٌنكِن عٌبٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","عٍ نَشَ كٍلِ مّننِ، عٍ سِفَ عِيٍ عَبَرِ مِ فبٍنفبٍرٍنيِ مَ نَشَن يَ رَقِندِشِ مٌوَبَ بْشِ مَ، سٌفٍتٍدٍ مَبِرِ. ");
INSERT INTO susa_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ سٍرٍدٍ فُلُنبَ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عَرِنٌن دّ رَ، شُرٍ نَشَن نَ عَمٌرِ بْشِ مَ. عَرِنٌن نَن نَ نَانِنيِ رَ مٌوَبَكَيٍ نُن عَمٌرِكَيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","نَ نَن عَ رَ، عَ سّبّشِ سّبّلِ ندٍ كُي، عَلَتَلَ شَ فٍرٍيٍ شَ قٍ نَ نَشَن كُي، «وَهٍبِ نُن عَ شَ فُلُنبَيٍ نَ سُقَ بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","عَرِنٌن فُلُنبَيٍ فٍشِ هَن عَرِ، عَ قِندِ مٌوَبَ نَانِنيِ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","عٍ تٌ كٍلِ، عٍ نَشَ سِفَ بٍيرِ، عَلَتَلَ عَ مَسٍن مُنسَ بّ دّننَشّ، «حَمَ مَلَن، ﭑ شَ عٍ كِ يٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","عِسِرَيِلَكَيٍ يِ سُوكِ بَ نَ وَشَتِ نّ؛ «يٍ شَ تٍ كْلْنيِ رَ! وٌ شَ بّيتِ بَ عَ شَ قٍ رَ! ");
INSERT INTO susa_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","مَنفّيٍ نُن كُنتِفِيٍ بَرَ عَ فٍ، مَنفّ تْنشُمَ كَنيِيٍ.» ");
INSERT INTO susa_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","عٍ تٌ كٍلِ فبٍنفبٍرٍنيِ مَ، عٍ نَشَ سِفَ مَتَنَ. عٍ تٌ كٍلِ مَتَنَ، عٍ نَشَ سِفَ نَشَلِيّلِ. عٍ تٌ كٍلِ نَشَلِيّلِ، عٍ نَشَ سِفَ بَمٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","عٍ تٌ كٍلِ بَمٌتِ، عٍ نَشَ سِفَ مٌوَبَ فُلُنبَ يِرٍ، ثِسِفَ فٍيَ نَ دّننَشّ. فبٍنفبٍرٍن يِرٍ بِرِن تٌمَ نّ نَ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","عِسِرَيِلَكَيٍ نَشَ شّيرَيٍ شّي عَمٌرِكَيٍ شَ مَنفّ سِشْن يِرٍ عَ قَلَقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«مُشُ وَ مَ فِرِقٍ عِ شَ بْشِ نَن مَ. مُشُ مُ شّ يِرٍ نُن وّنِ بٌفِ يِرٍ لِمَ. مُشُ مُ وٌ شَ كْلْن يٍ مِنمَ. مُشُ لُمَ مَنفّ شَ كِرَ فبَنسَن نَن شْن مَ، هَن مُشُ عِ شَ بْشِ عِفِرِ.» ");
INSERT INTO susa_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","سِشْن مُ تِن عٍ شَ دَنفِ عَ شَ بْشِ مَ. عَ نَشَ عَ شَ سْورِيٍ مَلَن، عٍ نَشَ مِنِ عِسِرَيِلَكَيٍ شِلِ مَ فبٍنفبٍرٍنيِ مَ، عٍ قَ عٍ فٍرٍ يَهَسِ. ");
INSERT INTO susa_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","عِسِرَيِلَكَيٍ نَشَ فٍينِ. عٍ نَشَ عٍ شَ بْشِ بِرِن تٌنفٌ كٍلِ عَرِنٌن شُرٍ مَ هَن يَبٌكٌ شُرٍ، هَن عَمٌنِكَيٍ شَ بْشِ نَانِنيِ رَ. عٍ مُ نْ دَنفِدٍ نَ رَ بَرِ مَ عَمٌنِكَيٍ سّنبّ نُ فبٌ. ");
INSERT INTO susa_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","كْنْ عِسِرَيِلَكَيٍ نَشَ عَمٌرِكَيٍ شَ تَايٍ بِرِن سُشُ، عٍ قَ سَبَتِ نٍيٍ كُي. عٍ نَشَ شّسِبْن قَن سُشُ، عَ نُن عَ شَ رَبِلِنيِ. ");
INSERT INTO susa_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","شّسِبْن نَن نُ نَ عَمٌرِكَيٍ شَ مَنفّ سِشْن شَ مَنفَتَا رَ. عَ نُ بَرَ نَ تَا بَ مٌوَبَ مَنفّ ندٍ يِ، عَ نُن عَ شَ بْشِ بِرِن هَن عَرِنٌن شُرٍ. ");
INSERT INTO susa_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","نَ نَن عَ رَ، بّيتِبَيٍ عَ قَلَمَ، «وٌ قَ شّسِبْن! سِشْن شَ تَا شَ تِ، عَ مَن شَ سّنبّ سْتْ! ");
INSERT INTO susa_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","تّ بَرَ شّسِبْن فَن، سِشْن شَ تَا بَرَ كَنَ تّ رَ. مٌوَبَ بْشِ شَ تَا عَرِ قَن بَرَ فَن، نَشَن شَ مِشِيٍ نُ نْمَ عَرِنٌن تٌدٍ. ");
INSERT INTO susa_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","حَشَنكَتّ نَ وٌ بّ مٌوَبَكَيٍ، وٌ تَن كٍمٌسِ شَ بَتُلَيٍ. عَ شَ دِ شّمّيٍ بَرَ عٍ فِ. عَ شَ دِ فِنّيٍ بَرَ قِندِ فٍيلِمَنِيٍ رَ عَمٌرِ مَنفّ سِشْن شْنيِ. ");
INSERT INTO susa_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","كْنْ مُشُ بَرَ نْ عٍ رَ، شّسِبْن بَرَ كَنَ هَن دِبٌن. مُشُ بَرَ عٍ هَلَكِ هَن نٌقَ، هَن عَ سَ مٍدٍبَ لِ.» ");
INSERT INTO susa_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","عِسِرَيِلَ نَشَ سَبَتِ عَمٌرِكَيٍ شَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","مُنسَ تٌ فّ يَاسّرِ تَا رَبّندٍ، عِسِرَيِلَ نَشَ عَمٌرِكَيٍ كٍرِ نَ لٌنفٌرِ بِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","نَ دَنفِ شَنبِ، عٍ نَشَ كِرَ تٌنفٌ سِفَقٍ رَ بَسَن. بَسَن مَنفّ عٌفٌ نُن عَ شَ سْورِيٍ نَشَ عٍ لِ عٍدٍرٍيِ. ");
INSERT INTO susa_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ نَشَ فَاشُ عَ يَ رَ! ﭑ نَ سَمَ نّ عِ بّلّشّ، عَ نُن عَ شَ سْورِيٍ نُن عَ شَ بْشِ بِرِن. عِ شَ عَ بْنبْ عَلْ عِ عَمٌرِ مَنفّ سِشْن بْنبْشِ كِ نَشّ شّسِبْن.» ");
INSERT INTO susa_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","عِسِرَيِلَكَيٍ نَشَ عٌفٌ، عَ شَ دِيٍ، نُن عَ شَ سْورِ بِرِن بْنبْ. مِشِ كٍرٍن مُ نْ عَ بَدٍ عٍ يِ. عٍ نَشَ عَ شَ بْشِ قِندِ عٍ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","عِسِرَيِلَكَيٍ نَشَ سِفَ عٍ سَ يٌنكِن مٌوَبَ قِيلِ مَ، يُرُدّن شُرٍ دّ، يٍرِكٌ يَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","سِثٌرٌ شَ دِ شّمّ بَلَكِ نُ بَرَ عَ مّ عِسِرَيِلَكَيٍ نَشَن نَبَشِ عَمٌرِكَيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","مٌوَبَكَيٍ نُ بَرَ فَاشُ عِسِرَيِلَ حَمَ بٍلٍبٍلٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","نَ كُي، عٍ نَشَ عَ قَلَ مَدِيَن كُنتِفِيٍ بّ، «يِ حَمَ بٍلٍبٍلٍ قَمَ وٌن مَ بْشِ بِرِن شُن نَكَنَدٍ، عَلْ نِنفٍيٍ مّرّ شُن نَكَنَمَ كِ نَشّ.» بَلَكِ نَن نُ نَ مٌوَبَ مَنفّ رَ نَ تّمُي. ");
INSERT INTO susa_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","عَ نَشَ شّيرَيٍ شّي بٍيٌرِ شَ دِ شّمّ بَلَمِ يِرٍ، نَشَن نُ سَبَتِشِ ثٍتٌرِ، عَ بَرِ تَا شُرٍ دّ رَ، عَ قَلَقٍ رَ، «حَمَ بٍلٍبٍلٍ ندٍ بَرَ كٍلِ مِسِرَ بْشِ مَ، عٍ قَ يٌنكِن ﭑ مَ بْشِ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","يَندِ، عِ شَ قَ يِ حَمَ دَنكَدٍ، بَرِ مَ عٍ سّنبّ فبٌ ﭑ بّ. تّمُندٍ، نَ كِ ﭑ نْمَ نّ عٍ بْنبْدٍ، ﭑ عٍ كٍرِ يِ بْشِ مَ. ﭑ عَ كٌلٌن، عِ نَ دُبَ نَشَن بّ، نَ بَرَ بَرِكَ. عِ مَن نَ نَشَن دَنكَ، نَ قَن بَرَ دَنكَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","مٌوَبَ كُنتِفِيٍ نُن مَدِيَن كُنتِفِيٍ نَشَ سِفَ سٍ مَتٌي سَرٍ رَ بَلَمِ شْن، عٍ قَ بَلَكِ شَ شّيرَيَ عِبَ عَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","بَلَمِ نَشَ عَ قَلَ عٍ بّ، «وٌ شَ كْي رَدَنفِ بٍ. عَلَتَلَ نَ يَابِ سٌ ﭑ يِ، ﭑ نَ قَلَمَ نّ وٌ بّ.» نَ كُي، مٌوَبَ كُنتِفِيٍ نَشَ شِ بَلَمِ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","عَلَتَلَ نَشَ مِنِ بَلَمِ مَ، عَ عَ مَشْرِن، «ندٍ نَ يِ مِشِيٍ رَ عِ نَشٍيٍ رَ سّنّشِ عِ شْنيِ يِ كِ؟» ");
INSERT INTO susa_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بَلَمِ نَشَ عَ يَابِ، «مٌوَبَ مَنفّ سِثٌرٌ شَ دِ شّمّ بَلَكِ نَن يِ مِشِيٍ شّي، عَ عٍ شَ قَ عَ قَلَ ﭑ بّ، ");
INSERT INTO susa_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹حَمَ بٍلٍبٍلٍ ندٍ بَرَ كٍلِ مِسِرَ بْشِ مَ، عٍ قَ سَبَتِ ﭑ مَ بْشِ سّيتِ مَ. عِ شَ قَ يِ حَمَ دَنكَ، عَلَكٌ ﭑ شَ نْ عٍ كٍرِدٍ.›» ");
INSERT INTO susa_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","عَلَتَلَ نَشَ عَ مَسٍن بَلَمِ بّ، «عِ نَشَ بِرَ يِ مِشِيٍ قْشْ رَ، عِ نَشَ نَ حَمَ دَنكَ. بَرَكَتْي حَمَ نَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","نَ كُيٍ عِبَ بَلَمِ نَشَ كٍلِ، عَ عَ قَلَ بَلَكِ شَ كُنتِفِيٍ بّ، «وٌ فبِلٍن وٌ شَ بْشِ مَ، بَرِ مَ عَلَتَلَ مُ تِنشِ ﭑ شَ بِرَ وٌ قْشْ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","نَ كُي، مٌوَبَ كُنتِفِيٍ نَشَ فبِلٍن بَلَكِ يِرٍ، عٍ عَ قَلَ عَ بّ، «بَلَمِ بَرَ تٌندِ بِرَدٍ مُشُ قْشْ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","بَلَكِ مَن نَشَ كُنتِفِ فبٍفبٍ فبّتّ شّي، نَشٍيٍ تِدٍ دَنفِ عَ سِنفٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","عٍ نَشَ سِفَ بَلَمِ يِرٍ، عٍ عَ قَلَ عَ بّ، «بَلَكِ شَ مَسٍنيِ نَن يَ؛ ‹ﭑ تَن سِثٌرٌ شَ دِ شّمّ بَلَكِ، ﭑ بَرَ عِ مَيَندِ، عِ نَشَ تٌندِ تَلُقٍ رَ ﭑ يِرٍ! ");
INSERT INTO susa_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ﭑ عِ سَرٍ قِمَ نّ عَ قَنيِ رَ. عِ وَ مَ نَشَن يٌ شْن، ﭑ نَ قِمَ نّ عِ مَ. يَندِ عِ شَ يِ حَمَ دَنكَ ﭑ بّ.›» ");
INSERT INTO susa_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","كْنْ بَلَمِ نَشَ بَلَكِ شَ شّيرَيٍ يَابِ، «هَلِ بَلَكِ عَ شَ بَنشِ رَقٍ فبٍتِ نُن شّيمَ رَ، عَ عَ سٌ ﭑ يِ رَ، ﭑ مُ نْمَ قٍقٍ رَبَدٍ ﭑ مَرِفِ عَلَتَلَ مُ ﭑ يَمَرِ نَشَن نَ. ");
INSERT INTO susa_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","وٌ نَشَن نَبَمَ، وٌ قَن شَ لُ بٍ هَن تِنَ فّيسّفّ. ﭑ مَن شَ عَلَتَلَ شَ مَسٍنيِ رَ مّ.» ");
INSERT INTO susa_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","عَلَتَلَ نَشَ مِنِ بَلَمِ مَ كْي رَ، عَ عَ مَسٍن عَ بّ، «يِ مِشِيٍ تٌ بَرَ قَ عِ شِلِدٍ، عِ شَ بِرَ عٍ قْشْ رَ، كْنْ ﭑ نَ نَشَن قَلَ عِ بّ، عِ نَ نَن نَبَمَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","نَ كُيٍ عِبَ بَلَمِ نَشَ بَكِ عَ شَ سٌقَلٍ قَرِ، عَ بِرَ مٌوَبَ كُنتِفِيٍ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","بَلَمِ سِفَقٍ نَشَ عَلَتَلَ رَشْنْ. عَلَتَلَ شَ مَلٍكّ نَشَ سِفَ كِرَ عِبٌلٌندٍ بَلَمِ يَ رَ. عَ نُ دْشْشِ عَ شَ سٌقَلٍ قَرِ، عَ شَ وَلِكّ قِرِنيِيٍ نُ نَ عَ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","بَلَمِ شَ سٌقَلٍ تٌ عَلَتَلَ شَ مَلٍكّ تٌ كِرَ تَفِ، سَنتِدّفّمَ سُشُشِ عَ يِ، عَ رَ مِنِشِ عَ تّ عِ، عَ نَشَ كٍلِ كِرَ شْن مَ، عَ سٌ شّ رَ. بَلَمِ نَشَ سٌقَلٍ بْنبْ، عَلَكٌ عَ شَ عَ شُن تِ كِرَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","عَلَتَلَ شَ مَلٍكّ مَن نَشَ سَ تِ عٍ شَ كِرَ دِ شْن مَ وّنِ بِلِيٍ تّتّ قِرِنيِيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","سٌقَلٍ تٌ عَلَتَلَ شَ مَلٍكّ تٌ، عَ نَشَ عَ رَشّتّن تّتّ رَ، عَ بَلَمِ سَنيِ شّتّن تّتّ رَ عَ حَاشِ رَ. بَلَمِ نَشَ فبِلٍن عَ بْنبْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","عَلَتَلَ شَ مَلٍكّ مَن نَشَ سَ تِ يِرٍ رَشّتّنشِ عَ قَنيِ رَ. دَنفِدٍ يٌ مُ نُ نَ. ");
INSERT INTO susa_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","سٌقَلٍ تٌ عَلَتَلَ شَ مَلٍكّ تٌ، عَ نَشَ عَ سَ بَلَمِ بُن مَ. بَلَمِ نَشَ شْنْ عَ مَ، عَ عَ بْنبْ عَ شَ يِسُشُوُرِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","نَ كُي، عَلَتَلَ نَشَ سٌقَلٍ دّ رَ مِنِ، عَ عَ نِيَ عَ شَ عَ قَلَ بَلَمِ بّ، «عَ سَشَن ندٍ نَن يِ كِ عِ ﭑ بْنبْمَ. ﭑ مُنسٍ رَبَشِ عِ رَ؟» ");
INSERT INTO susa_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بَلَمِ نَشَ عَ يَابِ، «عِ ﭑ مَتَندِشِ نّ. شَ سَنتِدّفّمَ نَ ﭑ يِ رَ نُ، ﭑ عِ قَشَمَ نّ كٍرٍن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","سٌقَلٍ نَشَ عَ قَلَ بَلَمِ بّ، «ﭑ تَن شَ مُ عِ شَ سٌقَلٍ رَ، عِ تٍمَ نَشَن قَرِ تّمُي بِرِن؟ ﭑ دَرِشِ يِ مْولِ رَبَ رَ؟» بَلَمِ نَشَ عَ يَابِ، «عَدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","نَ تّمُي عَلَتَلَ نَشَ بَلَمِ يَ رَبِ مَلٍكّ تٌقٍ رَ، عَ تِشِ كِرَ تَفِ، عَ شَ سَنتِدّفّمَ بَشِ عَ تّ عِ، عَ سُشُشِ عَ بّلّشّ. بَلَمِ نَشَ عَ قٍلٍن، عَ سُيِدِ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","مَلٍكّ نَشَ عَ مَشْرِن، «مُنقٍ رَ عِ بَرَ عِ شَ سٌقَلٍ بْنبْ سَنيَ سَشَن؟ ﭑ قَشِ نّ ﭑ شَ كِرَ عِبٌلٌن عِ يَ رَ، بَرِ مَ عِ نَ كِرَ نَشَن شْن يِ كِ، مُرُتّلَ شَ كِرَ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","عِ شَ سٌقَلٍ بَرَ عِ رَتَنفَ ﭑ مَ سَنيَ سَشَن. شَ عَ تَن مُ عَ رَ نُ، ﭑ بَرَ عِ قَشَ نُ، كْنْ ﭑ مُ عَ تَن قَشَمَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بَلَمِ نَشَ عَ قَلَ عَ بّ، «ﭑ بَرَ يُنُبِ رَبَ! ﭑ مُ نُ عَ كٌلٌنشِ، عِ تِشِ ﭑ يَ رَ. كْنْ يَكْسِ، شَ يِ بِيَاسِ مُ عِ كّنّنشِ، ﭑ شَ فبِلٍن ﭑ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","عَلَتَلَ شَ مَلٍكّ نَشَ عَ مَسٍن، «عَدٍ، عِ شَ بِرَ يِ مِشِيٍ قْشْ رَ، كْنْ ﭑ نَ مَسٍنيِ نَشَن مَسٍن عِ بّ، عِ نَ نَن قَلَمَ.» نَ كُي، بَلَمِ نُن بَلَكِ شَ شّيرَيٍ نَشَ سِفَ. ");
INSERT INTO susa_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","بَلَكِ تٌ عَ مّ عَ بَلَمِ نَ قَقٍ، عَ نَشَ سِفَ عَ رَلَندٍ تَا ندٍ مَ عَرِنٌن شُرٍ دّ رَ، مٌوَبَ شَ نَانِنيِ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","عَ نَشَ بَلَمِ مَشْرِن، «مُنقٍ رَ عِ مُ قَ ﭑ مَ شّيرَيَ سِنفٍ شِلِ مَ؟ عِ حْشْ عَ مَ ﭑ مُ نْمَ عِ سَرٍ قِدٍ؟» ");
INSERT INTO susa_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بَلَمِ نَشَ بَلَكِ يَابِ، «ﭑ بَرَ قَ عِ شْن، كْنْ ﭑ مُ نْمَ وْيّندٍ نَ كِ تُن. عَلَتَلَ مَسٍنيِ نَشَن سَمَ ﭑ دّ عِ، ﭑ نَ نَن تُن قَلَمَ.» ");
INSERT INTO susa_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","بَلَمِ نُن بَلَكِ نَشَ سِفَ، عٍ سٌ كِرِيَتِ شُسٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","بَلَكِ نَشَ نِنفٍيٍ نُن يّشّييٍ بَ سّرّشّ رَ، عَ ندٍ سٌ بَلَمِ يِ رَ عَ نُن كُنتِفِ نَشٍيٍ نُ نَ عَ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","نَ كُيٍ عِبَ، بَلَكِ نَشَ بَلَمِ شَنِن بَمٌتِ بَالِ فٍيَ قَرِ. مّننِ عَ نَشَ عِسِرَيِلَ حَمَ سّيتِ ندٍ تٌ. ");
INSERT INTO susa_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بَلَمِ نَشَ عَ قَلَ بَلَكِ بّ، «عِ شَ سّرّشّبَدٍ سٌلٌقٍرٍ يَءِلَن بٍ. عِ مَن شَ قَ تُورَ سٌلٌقٍرٍ نُن يّشّي كٌنتٌنيِ سٌلٌقٍرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بَلَمِ نَشَن مَشْرِن، بَلَكِ نَشَ عَ بِرِن نَبَ. عٍ نَشَ تُورَ كٍرٍن نُن يّشّي كٌنتٌنيِ كٍرٍن بَ سّرّشّ رَ نَ سّرّشّبَدٍ كٍرٍن كٍرٍن مَ. ");
INSERT INTO susa_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","بَلَمِ نَشَ عَ قَلَ بَلَكِ بّ، «عِ شَ لُ بٍ سّرّشّ قّ مَ، ﭑ تَن شَ ﭑ مَكُيَ دٌندٌرٌنتِ. تّمُندٍ عَلَتَلَ قَمَ مِنِدٍ ﭑ مَ. عَ نَشَن يٌ مَسٍن ﭑ بّ، ﭑ عَ قَلَمَ عِ بّ.» بَلَمِ تٌ تٍ فٍيَ ندٍ قَرِ، ");
INSERT INTO susa_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","عَلَتَلَ نَشَ مِنِ عَ مَ. بَلَمِ نَشَ عَ قَلَ عَ بّ، «ﭑ بَرَ سّرّشّبَدٍ سٌلٌقٍرٍ يَءِلَن، ﭑ يّشّي كٌنتٌنيِ كٍرٍن نُن تُورَ كٍرٍن نَن بَشِ عَ بِرِن كٍرٍن كٍرٍن قَرِ.» ");
INSERT INTO susa_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","عَلَتَلَ نَشَ مَسٍنيِ قِ بَلَمِ مَ عَ نَشَن مَسٍنمَ. عَ نَشَ عَ يِتَ عَ بّ، «سِفَ بَلَكِ يِرٍ، عِ شَ يِ مَسٍنيِ تِ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","بَلَمِ نَشَ فبِلٍن بَلَكِ يِرٍ، عَ عَ لِ عَ تِشِ عَ شَ سّرّشّ قّ مَ، عَ تَن نُن مٌوَبَ كُنتِفِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","بَلَمِ نَشَ عَ شَ مَسٍنيِ تِ يِ كِ، «بَلَكِ نَن قَشِ ﭑ نَ كٍلِقٍ سِرِيَ. مٌوَبَ مَنفّ نَن ﭑ شِلِشِ، كٍلِقٍ سٌفٍتٍدٍ فٍيَيٍ كْن نَ. ‹قَ، يَشُبَ بْنسْي دَنكَ ﭑ بّ! عِ شَ شْنّ رَدِن عِسِرَيِلَ مَ!› ");
INSERT INTO susa_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ﭑ نْمَ مِشِ دَنكَدٍ دِ، عَلَتَلَ مُ نَشَن دَنكَشِ؟ ﭑ نْمَ شْنْدٍ مِشِ مَ دِ، عَلَ مُ شْنْشِ نَشَن مَ؟ ");
INSERT INTO susa_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ﭑ عٍ تٌمَ كٍلِقٍ فٍيَ كْن نَ، كٍلِ يِرٍ عِتٍشِ. حَمَ نَن عَ رَ، نَشَن لُمَ عَ شَتِ مَ، نَشَن تَفِ رَ سَمَ عٍ نُن سِ فبّتّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ندٍ نْمَ يَشُبَ بْنسْي كْنتِدٍ، كْنتِ نَشَن دَنفِمَ مّيّنيِ كْنتِ رَ؟ عٍ نُ عِسِرَيِلَ حَمَ عِتَشُن دْشْدٍ نَانِ رَ، ندٍ نْمَ عَ سّيتِ كٍرٍن يَتِ كْنتِدٍ؟ عَلَ شَ ﭑ مَلِ ﭑ شَ عَلِفِيَمَ لِ تِنشِنيِ كُي. عَلَ شَ ﭑ مَلِ ﭑ شَ مَنِيَ عٍ رَ ﭑ مَ سَيَ كُي.» ");
INSERT INTO susa_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بَلَكِ نَشَ عَ قَلَ بَلَمِ بّ، «عِ مُنسٍ رَبَشِ ﭑ نَ يِ كِ؟ ﭑ عِ رَقَشِ نّ ﭑ يَشُييٍ دَنكَدٍ، كْنْ عِ تَن نَ دُبَقٍ عٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","بَلَمِ نَشَ عَ يَابِ، «عَلَتَلَ نَ مَسٍنيِ نَشَن سَ ﭑ دّ عِ، ﭑ مُ لَن ﭑ شَ نَ قَلَ؟» ");
INSERT INTO susa_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","بَلَكِ مَن نَشَ عَ قَلَ عَ بّ، «وٌن شَ سِفَ يِرٍ فبّتّ، عِ نْمَ عٍ تٌدٍ دّننَشّ. عِ سّيتِ كٍرٍن نَن فبَنسَن تٌمَ بٍ، عِ مُ عٍ بِرِن تٌمَ. مّننِ عِ نْمَ عٍ بِرِن تٌدٍ، عِ قَ عٍ دَنكَ.» ");
INSERT INTO susa_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","عَ نَشَ بَلَمِ شَنِن سٌقِمِ، ثِسِفَ فٍيَ قَرِ. عَ نَشَ سّرّشّبَدٍ سٌلٌقٍرٍ يَءِلَن مّننِ، عَ تُورَ كٍرٍن نُن يّشّي كٌنتٌنيِ كٍرٍن بَ سّرّشّ رَ نَ سّرّشّبَدٍ كٍرٍن كٍرٍن مَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","بَلَمِ نَشَ عَ قَلَ بَلَكِ بّ، «عِ شَ لُ بٍ عِ شَ سّرّشّ قّ مَ، ﭑ تَن شَ ﭑ مَكُيَ دٌندٌرٌنتِ، ﭑ نُن عَلَتَلَ شَ لُ يِرٍ كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","عَلَتَلَ نَشَ مِنِ بَلَمِ مَ، عَ مَسٍنيِ ندٍ قِ عَ مَ، عَ قَ عَ قَلَ عَ بّ، «سِفَ بَلَكِ يِرٍ، عِ شَ يِ مَسٍنيِ تِ عَ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","بَلَمِ نَشَ فبِلٍن بَلَكِ يِرٍ، عَ عَ لِ عَ تِشِ عَ شَ سّرّشّ قّ مَ، عَ تَن نُن مٌوَبَ كُنتِفِيٍ. بَلَكِ نَشَ عَ مَشْرِن، «عَلَتَلَ مُنسٍ مَسٍنشِ؟» ");
INSERT INTO susa_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","بَلَمِ نَشَ يِ مَسٍنيِ تِ عَ بّ، «بَلَكِ، كٍلِ. سِثٌرٌ شَ دِ شّمّ، عِ تُلِ مَتِ. ");
INSERT INTO susa_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","عَلَ مِشِ مُ عَ رَ، عَ مُ وُلٍ قَلَمَ. عَدَ مَدِ مُ عَ رَ، عَ شَ عَ شَشِلِ مَسَرَ. عَ مُ عَ شُي مَسَرَ مَ. عَ مُ نّيمُمَ عَ شَ سَاتّ مَ. عَ مُ لَايِدِ كَنَمَ. ");
INSERT INTO susa_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","عَلَ بَرَ ﭑ يَمَرِ ﭑ شَ دُبَ يِ حَمَ بّ. عَلَتَلَ بَرَ بَرَكَ سَ عٍ مَ. ﭑ مُ نْمَ نَ مَسَرَدٍ. ");
INSERT INTO susa_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","تْورّ مُ لُمَ يَشُبَ بْنسْي يَ مَ. سٍتَرٍحَ مُ تٌمَ عِسِرَيِلَ. عٍ مَرِفِ عَلَتَلَ نَ عٍ قْشْ رَ. مَنفّ شُي مّمَ نّ عٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","عَلَتَلَ عٍ رَ مِنِشِ مِسِرَ بْشِ رَ، سّنبّ نَ عٍ يِ رَ عَلْ سّشّ نِنفٍ. ");
INSERT INTO susa_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","كَرَ مْشْ وَلِ مُ نْمَ يَشُبَ بْنسْي تْورْدٍ. سٍمَتٌي مُ نْمَ سٍسٍ رَبَدٍ عِسِرَيِلَ شِلِ مَ. عَ قَمَ قَلَدٍ يَشُبَ نُن عِسِرَيِلَ شَ قٍ رَ، عَلَ شَ وَلِ مَتٌ! ");
INSERT INTO susa_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","يِ حَمَ كٍلِمَ عَلْ يّتّ فِنّ، عٍ تِمَ عَلْ يّتّ شّمّ، نَشَن مُ عَ سَمَ قٌ عَ شَ سُبٍ دٌن، عَ نَشَن قَشَ، قٌ عَ شَ عَ وُلِ مِن.» ");
INSERT INTO susa_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","بَلَكِ نَشَ عَ قَلَ بَلَمِ بّ، «شَ عِ مُ وَ مَ عٍ دَنكَقٍ، هَلِ عِ مُ دُبَ عٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بَلَمِ نَشَ عَ يَابِ، «ﭑ مُ عَ قَلَ عِ بّ، عَلَتَلَ نَ نَشَن يٌ مَسٍن ﭑ بّ، ﭑ نَ نَن قَلَمَ؟» ");
INSERT INTO susa_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","بَلَكِ نَشَ عَ قَلَ بَلَمِ بّ، «عَوَ، وٌن شَ سِفَ يِرٍ فبّتّ. تّمُندٍ عَلَتَلَ تِنمَ عِ شَ يِ حَمَ دَنكَ ﭑ بّ مّننِ.» ");
INSERT INTO susa_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","بَلَكِ نَشَ بَلَمِ شَنِن ثٍيٌرِ فٍيَ قَرِ، فبٍنفبٍرٍنيِ تٌمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بَلَمِ نَشَ عَ قَلَ بَلَكِ بّ، «سّرّشّبَدٍ سٌلٌقٍرٍ تِ بٍ، عِ مَن شَ قَ تُورَ سٌلٌقٍرٍ نُن يّشّي كٌنتٌنيِ سٌلٌقٍرٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بَلَمِ نَشَن مَشْرِن، بَلَكِ نَشَ عَ بِرِن نَبَ. عَ نَشَ تُورَ كٍرٍن نُن يّشّي كٌنتٌنيِ كٍرٍن بَ سّرّشّ رَ نَ سّرّشّبَدٍ كٍرٍن كٍرٍن مَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","بَلَمِ تٌ عَ تٌ عَ عَلَتَلَ نُ وَ مَ بَرَكَ سَقٍ عِسِرَيِلَ شَ قٍ مَ، عَ مُ كَرَ مْشْ وَلِ رَبَ عَلْ عَ دَرِشِ عَ رَبَ رَ كِ نَشّ. عَ نَشَ عَ يَ رَقِندِ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","عَ تٌ عِسِرَيِلَ حَمَ تٌ، عٍ يٌنكِنشِ عٍ بْنسْي كِ مَ، عَلَ شَشِلِ نَشَ فٌرٌ عَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","عَ قَ يِ مَسٍنيِ تِ؛ «ﭑ يِ نَن مَسٍنمَ، ﭑ تَن بٍيٌرِ شَ دِ شّمّ بَلَمِ، نَشَن شَ سٍ عِفبّمَ عَ قَنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","نَشَن عَلَ شُي رَ مّمَ، نَشَن عَلَ شِلِ شُنفبٍ كَنيِ شَ لَامَتُنيِ تٌمَ، نَشَن قَهَامُي سْتْمَ سُيِدِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","يَشُبَ، عِ شَ كِرِ بَنشِيٍ رَيَبُ، عِسِرَيِلَ، عِ شَ لِنفِرَيٍ تٌقَن. ");
INSERT INTO susa_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","عٍ فُلُنبَ رَقٍمَ، عٍ لُمَ عَلْ لَاكْي نَشَن نَ شُرٍ دّ رَ، عَلْ وُرِ بِلِيٍ عَلَتَلَ نَشٍيٍ سِشِ يٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","يٍ مُ حْنمَ عِسِرَيِلَ حَمَ يِ رَ، تُنّ فٌرٌ مَ عٍ شَ سَنسِيٍ مَ عَ قَنيِ رَ. عٍ شَ مَنفّ سّنبّ فبٌ عَفَفَ بّ، عِسِرَيِلَ شَ مَنفّيَ شِلِ قَنيِ سْتْمَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","عَلَ نَشَ عٍ رَ مِنِ مِسِرَ بْشِ مَ، عٍ سّنبّ فبٌ عَلْ سّشّ نِنفٍ. عٍ عٍ يَشُييٍ شُن نَكَنَمَ نّ، نَشٍيٍ عٍ شْرِ فِرَ مَ، عٍ عٍ قَشَمَ شَلِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","عٍ عٍ مَلَبُمَ نّ عَلْ يّتّ، ندٍ سُو سَمَ عٍ رَكٍلِدٍ؟ بَرِكَ شَ لُ مِشِ بّ نَشَن نَ دُبَ وٌ بّ، دَنكَ شَ لُ مِشِ بّ نَشَن نَ وٌ دَنكَ!» ");
INSERT INTO susa_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","نَ كُي بَلَكِ نَشَ شْنْ بَلَمِ مَ عَ حَاشِ رَ. عَ نَشَ عَ قَلَ، «ﭑ عِ شِلِ نّ عِ شَ ﭑ يَشُييٍ دَنكَ، كْنْ عَ سَنيَ سَشَن ندٍ نَن يِ كِ، عِ نَ دُبَقٍ عٍ بّ! ");
INSERT INTO susa_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","كٍلِ بٍ كٍرٍن نَ! سِفَ عِ شْنيِ! ﭑ نُ بَرَ لَايِدِ تٌنفٌ عِ بّ وَلِ سَرٍ شَ قٍ رَ، كْنْ عَلَتَلَ مُ تِنشِ عِ شَ عَ سْتْ!» ");
INSERT INTO susa_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بَلَمِ نَشَ عَ يَابِ، «ﭑ مُ عَ قَلَ عِ شَ شّيرَيٍ بّ، ");
INSERT INTO susa_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹هَلِ بَلَكِ عَ شَ بَنشِ نَن نَقٍ فبٍتِ نُن شّيمَ رَ ﭑ بّ، ﭑ مُ نْمَ سٍسٍ رَبَدٍ عَلَتَلَ مُ ﭑ يَمَرِ نَشَن نَ. عَلَتَلَ نَشَن مَسٍنمَ ﭑ بّ، ﭑ نْمَ فبِلٍندٍ نَ قْشْ رَ؟› ");
INSERT INTO susa_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","عَوَ، يَكْسِ، ﭑ نَ فبِلٍنقٍ ﭑ شْنيِ، كْنْ عِ شَ عَ كٌلٌن يِ حَمَ نَشَن نَبَمَ وٌ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","نَ تّمُي بَلَمِ نَشَ يِ مَسٍنيِ تِ عَ بّ؛ «بٍيٌرِ شَ دِ شّمّ بَلَمِ شَ مَسٍنيِ نَن يَ، نَشَن سٍيٍ عِفبّمَ عَ قَنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","نَشَن عَلَ شُي رَ مّمَ، نَشَن عَلَ شِلِ شُنفبٍ كَنيِ شَ لَامَتُنيِ تٌمَ، نَشَن قَهَامُي سْتْمَ عَلَ شِلِ شُنفبٍ سَابُي رَ. ");
INSERT INTO susa_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ﭑ قٍ تٌشِ نَشَن قَمَ رَبَدٍ يَرٍ. ﭑ قٍ تٌشِ نَشَن مَكُيَ يَكْسِ رَ. تُنبُي ندٍ قَمَ تٍدٍ كٍلِقٍ يَشُبَ شَ مِشِيٍ مَ. مَنفّ تْنشُمَ ندٍ قَمَ كٍلِدٍ عِسِرَيِلَ يَ مَ. عَ مٌوَبَ شُن نَكَنَمَ نّ، عَ سٍتِ شَ دِيٍ شَ قٍ حْنمَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","عٍدٌن شَ قٍ فٌرٌ مَ نّ، سٍيِرِ شَ قٍ فٌرٌ مَ نّ، كْنْ عِسِرَيِلَ سّنبّ سْتْمَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","مَنفّ ندٍ كٍلِمَ يَشُبَ شَ مِشِيٍ يَ مَ، نَشَن بٍكَيٍ سْنتْمَ.» ");
INSERT INTO susa_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","بَلَمِ تٌ عَمَلّكِكَيٍ تٌ، عَ نَشَ يِ مَسٍنيِ تِ؛ «عَمَلّكِ سِ قِسَمَنتٍ نَ نُ عَ رَ، كْنْ عَ رَحْنيِ، عَ بْنْمَ نّ!» ");
INSERT INTO susa_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","بَلَمِ تٌ كٍنِكَيٍ تٌ، عَ نَشَ يِ مَسٍنيِ تِ؛ «وٌ سَبَتِدٍ مَبَنبَنشِ، وٌ تّي سَشِ قَنيٍ نَن قَرِ، ");
INSERT INTO susa_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","كْنْ عَسُرِ قَمَ نّ وٌ شُن نَكَنَدٍ، عَ وٌ قِندِ فٍيلِمَنِيٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","نَ تّمُي عَ نَشَ عَ شَ مَسٍنيِ شُن دُ سُ؛ «ندٍ نْمَ كِسِدٍ عَلَ شَ حَشَنكَتّ مَ؟ ");
INSERT INTO susa_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","كُنكُييٍ قَمَ نّ كٍلِقٍ كِتِمِ، عٍ نْمَ نّ عَسُرِ نُن شٍبٍرِ رَ، كْنْ عَ رَحْنيِ، عٍ قَن شُن نَكَنَمَ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","نَ دَنفِ شَنبِ، بَلَمِ نَشَ كٍلِ، عَ فبِلٍن عَ شْنيِ. بَلَكِ قَن نَشَ كٍلِ نَا. ");
INSERT INTO susa_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","عِسِرَيِلَكَيٍ تٌ نُ يٌنكِنشِ سِتِمِ، عٍ نَشَ سٌ يّنّ رَبَقٍ مٌوَبَ فِنّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","نَ فِنّيٍ نَشَ عِسِرَيِلَ شّمّيٍ شِلِ عٍ شَ لَن عٍ شَ سّرّشّيٍ مَ، نَشٍيٍ نُ بَمَ عٍ شَ كُيٍيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","عِسِرَيِلَكَيٍ تٌ ثٍيٌرِ شَ بَلِ كُيٍ بَتُ قْلْ، عَلَتَلَ نَشَ شْنْ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","عَلَتَلَ نَشَ عَ قَلَ مُنسَ بّ، عَ عَ شَ حَمَ يَرٍرَتِ بِرِن فبَكُ وُرِ كْن نَ عَ يَ عِ، عَ عٍ يَ رَقِندِ سٌفٍ مَ، عَلَكٌ عَ شَ شْنّ شَ فبِلٍن عِسِرَيِلَ قْشْ رَ. ");
INSERT INTO susa_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","مُنسَ نَشَ عِسِرَيِلَ كِيتِسَيٍ يَمَرِ، «وٌ شَ مِشِ بِرِن قَشَ، نَشَن بَرَ ثٍيٌرِ شَ بَلِ كُيٍ بَتُ!» ");
INSERT INTO susa_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","عَ قّقّ نَ قَلَ، عِسِرَيِلَكَ ندٍ نَشَ قَ مَدِيَنكَ فِنّ ندٍ رَ عَ نفَشَكٍرٍنيِيٍ يَ عِ. مُنسَ نُن عِسِرَيِلَ حَمَ نَشٍيٍ نُ نَ وَقٍ هْرْ مْلِنفِرَ سٌدٍ دّ رَ، نَشَ نَ فِنّ نُن نَ شّمّ تٌ. ");
INSERT INTO susa_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","هَرُنَ شَ مَمَدِ، عٍلٍيَسَرِ شَ دِ شّمّ قِنٍشَسِ سّرّشّدُبّ تٌ نَ فِنّ نُن نَ شّمّ تٌ، عَ نَشَ كٍلِ، عَ تَنبّ تٌنفٌ، ");
INSERT INTO susa_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","عَ بِرَ نَ شّمّ قْشْ رَ كِرِ بَنشِ كُي، عَ سَ عَ تَن نُن نَ فِنّ سْشْ عَ شَ تَنبّ رَ عٍ قُرِ مَ كٍرٍن نَ. نَ تّمُي عَلَتَلَ شَ شْنّ نَشَ دَن. ");
INSERT INTO susa_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","مِشِ وُلُ مْشْحّن نُن نَانِ نَن قَشَ نَ فبَلٌي كُي. ");
INSERT INTO susa_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«هَرُنَ سّرّشّدُبّ شَ مَمَدِ، عٍلٍيَسَرِ شَ دِ شّمّ قِنٍشَسِ، بَرَ ﭑ مَ شْنّ بَ عِسِرَيِلَكَيٍ مَ. ﭑ مَ شَنُنتٍيَ ﭑ مَ حَمَ بّ نُ نَ عَ بْحّ كُي، عَ قَ عَ نِيَ عَ شَ نَ رَبَ. ﭑ تَن مُ عِسِرَيِلَ بِرِن سْنتْ ﭑ مَ شَنُنتٍيَ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","عَ قَلَ قِنٍشَسِ بّ، ﭑ بَرَ بْحّسَ سَاتّ شِرِ عَ تَن نُن ﭑ تَن تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","نَ سَاتّ لُمَ ﭑ تَن نُن عَ بْنسْي تَفِ، عٍ قَ قِندِ سّرّشّدُبّيٍ رَ عَبَدَن، بَرِ مَ ﭑ مَ شَنُنتٍيَ نُ نَ عَ بْحّ كُي، عَ مَن قَ عَ نِيَ عِسِرَيِلَكَيٍ شَ يُنُبِ شَ شَقَرِ.» ");
INSERT INTO susa_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","عِسِرَيِلَكَ نَشَن قَشَ عٍ نُن نَ مَدِيَن فِنّ رَ، عَ نُ شِلِ سِمِرِ، سَلُ شَ دِ شّمّ. سِمٍيْن بْنسْي شُنيِ ندٍ نَن نُ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","نَ فِنّ مَدِيَنكَ تَن نُ شِلِ كْسِبِ، سُورُ شَ دِ فِنّ. مَدِيَن شَبِلّ ندٍيٍ شُنيِ نَن نُ عَ بَبَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«وٌ شَ مَدِيَنكَيٍ فٍرٍ عَلْ يَشُييٍ! ");
INSERT INTO susa_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","عٍ قِندِشِ وٌ بّ يَشُييٍ نَن نَ ثٍيٌرِ كُيٍ شَ قٍ رَ، نُن عٍ مَافِنّ كْسِبِ شَ قٍ رَ. كْسِبِ قِندِشِ عٍ شَ يَرٍرَتِ ندٍ شَ دِ فِنّ نَن نَ، ");
INSERT INTO susa_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","نَشَن قَشَ ثٍيٌرِ كُيٍ شَ قٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","نَ فبَلٌي تٌ دَنفِ، عَلَتَلَ نَشَ عَ قَلَ مُنسَ نُن هَرُنَ سّرّشّدُبّ شَ دِ شّمّ عٍلٍيَسَرِ بّ، ");
INSERT INTO susa_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«وٌ شَ عِسِرَيِلَ حَمَ بِرِن شِلِ سّبّ، كٍلِ عَ حّ مْشْحّن مَ هَن نَ شَنبِ، عَ دٍنبَيَ كِ مَ، نَشَن بِرِن نْمَ سْورِحَ رَبَدٍ.» ");
INSERT INTO susa_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","مُنسَ نُن عٍلٍيَسَرِ سّرّشّدُبّ نَشَ عَ قَلَ عِسِرَيِلَكَيٍ بّ مٌوَبَ بْشِ مَ يُرُدّن شُرٍ سّيتِ مَ يٍرِكٌ يَ عِ، ");
INSERT INTO susa_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«عِسِرَيِلَكَ بِرِن شَ كْنتِ، كٍلِ مِشِ مَ نَشَن بَرَ حّ مْشْحّن سْتْ هَن نَ شَنبِ، عَلْ عَلَتَلَ عَ يَمَرِ مُنسَ نُن عِسِرَيِلَكَيٍ بّ كِ نَشّ.» عِسِرَيِلَ بْنسْي نَشٍيٍ مِنِ مِسِرَ بْشِ رَ، نٍيٍ نَن يِ كِ. ");
INSERT INTO susa_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","عَ قْلْ عِسِرَيِلَ شَ دِ سِنفٍ رُبٍن نَن مَ، عَ شَ دِيٍ نَن يِ كِ؛ شَنْكِ، ثَلُ، ");
INSERT INTO susa_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","شٍسِرٌن، كَرِ مِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","رُبٍن بْنسْي شَبِلّيٍ نَن نَ كِ. نٍيٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن سَشَن كّمّ سٌلٌقٍرٍ تٌنفٌ سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ثَلُ شَ دِ شّمّ عٍلِيَبِ ");
INSERT INTO susa_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","نَن نُ نَ نٍمُوٍلِ، دَتَن، نُن عَبِرَ مِ بَبَ رَ، نَشٍيٍ كٍلِ مُنسَ نُن هَرُنَ شِلِ مَ عِسِرَيِلَ كُنتِفِيٍ يَ مَ. عٍ نُن كٌرَ نُن عَ قْشِرَبِرّيٍ تٌ كٍلِ عَلَتَلَ شِلِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","بْشِ رَبِ نّ، عَ قَ عٍ بِرِن فٍرُن. نَ لْشْي عَلَتَلَ مِشِ كّمّ قِرِن مِشِ تٌنفٌ سُولِ فَن نّ تّ رَ، عٍ شَ قِندِ مِسَالِ رَ حَمَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","كْنْ كٌرَ شَ دِيٍ تَن مُ قَشَ نَ قٍ كُي. ");
INSERT INTO susa_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","سِمٍيْن شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ نٍمُوٍلِ، يَمِن، يَكِمِ، ");
INSERT INTO susa_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","سٍرَ، سَوُلُ، عَ نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","سِمٍيْن بْنسْي شَبِلّيٍ نَن نَ كِ. نٍيٍ شَسَبِ لَن مِشِ وُلُ مْشْحّن نُن قِرِن، مِشِ كّمّ قِرِن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","فَدِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ سٍقٌن، شَفِ، سُنِ، ");
INSERT INTO susa_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","عٌسٍنِ، عٍرِ، ");
INSERT INTO susa_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","عَرٌدِ، عَرٍلِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","فَدِ بْنسْي شَبِلّيٍ نَن نَ كِ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","يُدَ شَ دِيٍ نَن يِ كِ؛ عٍرُ نُن عٌنَن. كْنْ عٍ تَن قَشَ كَنَان بْشِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","يُدَ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ سٍلَهَ، ثٍرٍ سِ، سٍرَ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ثٍرٍ سِ شَ دِيٍ نَن يِ كِ؛ شٍسِرٌن، شَمُلِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","يُدَ بْنسْي شَبِلّيٍ نَن نَ كِ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سٌلٌقٍرٍ نُن سٍننِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","عِسَكَرِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ تٌلَ، ثُوَ، ");
INSERT INTO susa_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","يَسُبُ، سِمِرٌن، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","عِسَكَرِ بْنسْييٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سٍننِ نُن نَانِ، مِشِ كّمّ سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","سَبُلٌن شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ سٍرٍدِ، عٍلٌن، يَشَلٍيلِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","سَبُلٌن بْنسْي شَبِلّيٍ نَن نَ كِ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سٍننِ، مِشِ كّمّ سُولِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","يُسُقُ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ مَنَسِ نُن عٍقِرَ مِ. ");
INSERT INTO susa_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","مَنَسِ شَ دِيٍ نَن يِ كِ؛ مَكِرِ نُن عَ شَبِلّيٍ. مَكِرِ نَن فَلَدِ نُن عَ شَبِلّيٍ سْتْ. ");
INSERT INTO susa_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","فَلَدِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ يٍسٍرِ، شٍلٍكِ، ");
INSERT INTO susa_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","عَسِرّلِ، سِكٍمِ، ");
INSERT INTO susa_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","سّمِدَ، شٍقٍرِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","شٍقٍرِ شَ دِ شّمّ سٍلٌقٍشَدِ تَن دِ فِنّيٍ نَن تُن سْتْ. نٍيٍ شِلِيٍ نَن يِ كِ؛ مَشَلَ، نٌوَ، شٌفَلَ، مِلِكَ نُن تِرِ سَ. ");
INSERT INTO susa_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","مَنَسِ بْنسْي شَبِلّيٍ نَن نَ كِ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن قِرِن، مِشِ كّمّ سٌلٌقٍرٍ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","عٍقِرَ مِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ سُتٍلَ، بٍكٍرِ، تَشَنِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","سُتٍلَ شَ دِ نَن يِ كِ؛ عٍرَن نُن عَ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","عٍقِرَ مِ شَ دِيٍ نَن نَ كِ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سَشَن نُن قِرِن، مِشِ كّمّ سُولِ نَن مَ. يُسُقُ شَ مَمَدِيٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","بُنيَمِن شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ بٍلَ، عَسِبٍلِ، عَشِرَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","سُقَمِ، شُقَمِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","بٍلَ شَ دِيٍ نَشَ قِندِ عَرَدٍ، نَامَن، نُن عٍ شَبِلّيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","بُنيَمِن شَ دِيٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. عٍ شَسَبِ نَشَ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن مِشِ سُولِ كّمّ سٍننِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","دَنَ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ. سُشَمِ نُن عَ شَبِلّيٍ. دَنَ بْنسْي نَن نَ كِ عٍ شَبِلّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","عٍ شَسَبِ نَشَ لَن مِشِ وُلُ تٌنفٌ سٍننِ نُن نَانِ، مِشِ كّمّ نَانِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","عَسٍرِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ يِمٍنَ، يِسِوِ، بٍرِيَ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","بٍرِيَ شَ دِيٍ نَن يِ كِ؛ شٍبٍرِ، مَلَكِيٍلِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","عَسٍرِ شَ دِ فِنّ نُ شِلِ نّ سٍرَ. ");
INSERT INTO susa_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","عَسٍرِكَيٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ سُولِ نُن سَشَن، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","نَقَتَلِ شَ دِيٍ نَن يِ كِ عٍ شَبِلّ كِ مَ؛ يَشَسٍيلِ، فُنِ، ");
INSERT INTO susa_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","يٍسٍرِ، سِلٍمِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","نَقَتَلِ بْنسْييٍ نَن نَ كِ عٍ شَبِلّ كِ مَ. عٍ شَسَبِ لَن مِشِ وُلُ تٌنفٌ نَانِ نُن سُولِ، مِشِ كّمّ نَانِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","عِسِرَيِلَكَ كْنتِ لَنشِ مِشِ وُلُ كّمّ سٍننِ نُن كٍرٍن، مِشِ كّمّ سٌلٌقٍرٍ تٌنفٌ سَشَن نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«كَنَان بْشِ عِتَشُنمَ نَ مِشِيٍ نَن مَ عٍ بْنسْي شَسَبِ مَ، عَ قِندِ عٍ كّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","بْنسْي بِرِن كّ سْتْمَ عَ شَ مِشِيٍ شَسَبِ بّرّ نَن نَ. بْنسْي نَشٍيٍ شَ مِشِيٍ فبٌ، عِ نٍيٍ فبٍ رَفبٌ دَنفِ بٌورٍيٍ رَ، نَشٍيٍ شَ مِشِ شُرُن. ");
INSERT INTO susa_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ﭑ تَن نَن عَ رَفِرِ مَ بْنسْي بِرِن لَن عَ شَ كّ نَشَن سْتْ عٍ بْنسْي شَسَبِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","بْشِ عِتَشُنيِ قِندِ مَ عَلَ شَ مَرَفِرِ نَن نَ، بْنسْي شُنفبٍيٍ نُن بْنسْي شُرِيٍ تَفِ.» ");
INSERT INTO susa_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","لٍوِ بْنسْي نَن يِ كِ نَشٍيٍ كْنتِ عٍ شَبِلّ كِ مَ؛ فٍرِ سٌن، كٍهَتِ، مٍرَرِ، نُن عٍ شَبِلّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","لٍوِ بْنسْي شَبِلّيٍ نَن يِ كِ؛ لِبِنِ، شٍبِرٌن، مَشَلِ، مُسِ، نُن كٌرَ. كٍهَتِ نُ بَرَ عَمَرَ مَ سْتْ. ");
INSERT INTO susa_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","عَمَرَ مَ شَ فِنّ نُ شِلِ نّ يٍبٍدِ، لٍوِ شَ دِ فِنّ، نَشَن بَرِ مِسِرَ. عَ نَشَ هَرُنَ، مُنسَ، نُن عٍ مَافِنّ مَرِيَمَ بَرِ عَمَرَ مَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","هَرُنَ نُ بَرَ نَدَبٌ، عَبِهُ، عٍلٍيَسَرِ، نُن عِتَمَرِ سْتْ دِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","نَدَبٌ نُن عَبِهُ قَشَ نّ، عٍ تٌ سّرّشّ فَن تّ رَ نَشَن مُ دَشَ. ");
INSERT INTO susa_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","دِ شّمّ نَشَن كْنتِ لٍوِ بْنسْي يَ مَ، كٍلِ عَ كِكٍ كٍرٍن مَ هَن نَ شَنبِ، عَ شَسَبِ لَن مِشِ وُلُ مْشْحّن نُن سَشَن نَن مَ. عٍ شَ كْنتِ نُ نَ عَ شَتِ مَ، بَرِ مَ عٍ مُ بْشِ سْتْ كّ رَ عِسِرَيِلَكَيٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","مُنسَ نُن عٍلٍيَسَرِ سّرّشّدُبّ نَ مِشِيٍ نَن كْنتِ مٌوَبَ بْشِ مَ يُرُدّن شُرٍ سّيتِ مَ يٍرِكٌ تَا يَ عِ، ");
INSERT INTO susa_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","كْنْ مُنسَ نُن هَرُنَ سّرّشّدُبّ مِشِ نَشٍيٍ كْنتِ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ، نَ كٍرٍن مُ نُ نَ عِسِرَيِلَكَيٍ يَ مَ سْنْن. ");
INSERT INTO susa_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","عَلَتَلَ عَ قَلَ نّ، عَ نٍيٍ بِرِن قَشَمَ نّ فبٍنفبٍرٍنيِ مَ. نَ كُي، عٍ سٍسٍ مُ لُ دُنِحَ، قٌ يٍقُنٍ شَ دِ شّمّ كَلٍبِ، نُن نُنُ شَ دِ شّمّ يٌسُوٍ. ");
INSERT INTO susa_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","يُسُقُ شَ دِ شّمّ مَنَسِ، نَ قَن شَ دِ شّمّ مَكِرِ، نَ قَن شَ دِ شّمّ فَلَدِ، نَ قَن شَ دِ شّمّ شٍقٍرِ، نَ قَن شَ دِ شّمّ سٍلٌقٍشَدِ، دِ فِنّ سُولِ نَن سْتْ، نَشٍيٍ نُ شِلِ؛ مَشَلَ، نٌوَ، شٌفَلَ، مِلِكَ نُن تِرِ سَ. ");
INSERT INTO susa_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","نَ دِ فِنّيٍ نَن قَ عٍ يّتّ كَن دّنتّفّ مُنسَ، عٍلٍيَسَرِ سّرّشّدُبّ، نُن عِسِرَيِلَ يَرٍرَتِيٍ بّ، عِسِرَيِلَ حَمَ بِرِن يَ شْرِ، هْرْ مْلِنفِرَ سٌدٍ دّ رَ. عٍ نَشَ عَ مَسٍن، ");
INSERT INTO susa_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«مُشُ بَبَ مُ دِ شّمّ سْتْ. عَ بَرَ قَشَ فبٍنفبٍرٍنيِ مَ، كْنْ عَ مُ نُ نَ كٌرَ شَ مِشِيٍ يَ مَ نَشٍيٍ كٍلِ عَلَتَلَ شِلِ مَ. عَ تَن قَشَ عَ يّتّ كَن شَ يُنُبِ رَبَشِ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","مُنقٍ رَ مُشُ بَبَ شِلِ بَمَ عَ شَبِلّ شَ مِشِيٍ يَ مَ، دِ شّمّ تٌ مُ نَ عَ بّ؟ كّ ندٍ سٌ مُشُ قَن يِ رَ، مُشُ بَبَ نفَشَكٍرٍنيِيٍ تَفِ!» ");
INSERT INTO susa_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","مُنسَ نَشَ عٍ شَ قٍ دّنتّفّ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","عَلَتَلَ نَشَ عَ مَسٍن عَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«سٍلٌقٍشَدِ شَ دِ فِنّيٍ بَرَ نْندِ قَلَ. عٍ بَبَ كّ سٌ عٍ يِ رَ عَلْ عٍ بَبَ نفَشَكٍرٍنيِيٍ عَ سْتْ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹شَ شّمّ ندٍ سَ قَشَ دِ شّمّ شَنبِ، وٌ عَ كّ سٌ عَ شَ دِ فِنّيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","شَ دِ فِنّ قَن مُ نَ عَ بّ، وٌ عَ كّ سٌ عَ قَقَشَكٍرٍنيِيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","شَ قَقَشَكٍرٍن يٌ مُ نَ عَ بّ، وٌ عَ سٌ عَ بَبَ قَقَشَكٍرٍنيِيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","شَ عَ سَ لِ، عَ بَبَ قَقَشَكٍرٍن يٌ مُ نَ، وٌ عَ كّ سٌ مِشِ يِ رَ، عٍ نُن نَشَن مَكْرّ عٍ بٌورٍ رَ عَ شَبِلّيٍ يَ مَ.› نَ شَ قِندِ يَامَرِ نُن سّرِيّ رَ عِسِرَيِلَكَيٍ بّ، عَلْ ﭑ تَن عَلَتَلَ عَ يَمَرِشِ عِ بّ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «تٍ يِ عَبَرِ مِ فٍيَ قَرِ، عَلَكٌ عِ شَ بْشِ مَتٌ ﭑ نَشَن قِمَ عِسِرَيِلَكَيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","عِ نَ فّ عَ مَتٌدٍ، عِ تَا مَسَرَ مَ نّ، عِ فبِلٍن عِ بٍنبَيٍ مَ عَلْ عِ تَارَ هَرُنَ، ");
INSERT INTO susa_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","بَرِ مَ وٌ بَرَ ﭑ مَ يَامَرِ مَتَندِ. عِسِرَيِلَكَيٍ تٌ كٍلِ ﭑ شِلِ مَ يٍ شْلِ شَ قٍ رَ كَدٍ سِ، سِنِ فبٍنفبٍرٍنيِ مَ، وٌ مُ سٍيدٍحْشْيَ رَبَ ﭑ مَ سّنِيّنيِ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","مُنسَ نَشَ عَ قَلَ عَلَتَلَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«عَلَتَلَ، دَالِ بِرِن مَرِفِ عَلَ، مِشِ كٍرٍن دْشْ حَمَ شُن مَ، ");
INSERT INTO susa_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","نَشَن تِمَ عٍ يَ رَ، عٍ مِنِ تّمُي نُن عٍ سٌ تّمُي، نَشَن عٍ رَ مِنِمَ، عَ عٍ رَ سٌ، عَلَكٌ عِ شَ حَمَ نَشَ لُ عَلْ شُرُ سٍ نَشٍيٍ رَبّحِنشِ عٍ يّتّ مَ، كَنتَمَ يٌ مُ عٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، «عِ شَ نُنُ شَ دِ يٌسُوٍ سُفَندِ، شَشِلِ سّنِيّنشِ نَ نَشَن مَ. عِ شَ عِ بّلّشّ سَ عَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","عِ شَ عَ تِ عٍلٍيَسَرِ سّرّشّدُبّ نُن حَمَ بِرِن يَ شْرِ، عِ قَ يَامَرِيٍ سٌ عَ يِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","عِ شَ مَنفّيَ ندٍ شَ دَنفِ عَ مَ، عَلَكٌ عِسِرَيِلَ حَمَ بِرِن شَ عَ شُي سُشُ. ");
INSERT INTO susa_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","عَ تِمَ نّ عٍلٍيَسَرِ سّرّشّدُبّ يَ عِ ﭑ وَشْنقٍ مَشْرِندٍ فّمّ سُفَندِشِيٍ رَ. ﭑ يَابِ نَشَن قِمَ، عَ تَن نُن حَمَ بِرِن حّرّ مَ نَ نَن مَ. عٍ مِنِمَ عٍلٍيَسَرِ سّرّشّدُبّ شُي نَن مَ، عٍ سٌمَ يٌسُوٍ شُي نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ رَبَ. عَ نَشَ يٌسُوٍ تٌنفٌ، عَ سَ عَ تِ عٍلٍيَسَرِ سّرّشّدُبّ نُن عِسِرَيِلَ حَمَ يَ عِ، ");
INSERT INTO susa_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","عَ عَ بّلّشّ سَ عَ مَ، عَ يَامَرِيٍ سٌ عَ يِ رَ، عَلْ عَلَتَلَ نُ بَرَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ شَ ﭑ مَ سّرّشّ بَ عَ بَ تّمُي. دٌنسٍيٍ نَن عٍ رَ، نَشٍيٍ فَنمَ، عٍ شِرِ حْشُنمّ تٍ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«عَ قَلَ عٍ بّ، ‹لْشْ يٌ لْشْ وٌ شَ سّرّشّ فَن دَاشِ بَ عَلَتَلَ بّ، يّشّي قِرِن، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","كٍرٍن شَ بَ فّيسّفّ، بٌورٍ شَ بَ نُنمَرٍ. ");
INSERT INTO susa_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","وٌ مَن شَ سَنسِ شْرِ دِنشِ كِلٌ سَشَن بَ سّرّشّ رَ نَشَن نَمُلَنشِ عٌلِوِ تُرٍ قَنيِ لِتِرِ كٍرٍن نُن عَ تَفِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","نَ سّرّشّ فَن دَاشِ مْولِ نُ بَمَ ﭑ بّ تُرُ سِنِنَ فٍيَ مَ، عَ شِرِ حْشُنمّ نُ تٍمَ ﭑ نَ. ");
INSERT INTO susa_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","وّنِ سّرّشّ لِتِرِ كٍرٍن نُن عَ تَفِ بَمَ يّشّي سّيتِ مَ عَلَتَلَ بّ. نَ سّرّشّ رَقَلَمَ يِرٍ سّنِيّنشِ نَن كُي. ");
INSERT INTO susa_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّ نُن وّنِ سّرّشّ بَ نُنمَرٍ تّمُي يّشّي سّيتِ مَ. نَ بِرِن قِندِ مَ سّرّشّ فَن دَاشِ نَن نَ نَشَن شِرِ حْشُنمّ تٍمَ ﭑ تَن عَلَتَلَ رَ.›» ");
INSERT INTO susa_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","مَلَبُي لْشْي وٌ شَ يّشّي قِرِن بَ مَلَبُ لْشْي سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. سَنسِ شْرِ دِنشِ سّرّشّ نَشَن نَمُلَنشِ تُرٍ كِلٌ سٍننِ رَ، نُن وّنِ سّرّشّ شَ بَ نَ يّشّييٍ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","مَلَبُي لْشْي سّرّشّ فَن دَاشِيٍ نَن بَمَ فّيسّفّ نُن نُنمَرٍ سّرّشّيٍ رَ، عَ نُن عٍ شَ وّنِ سّرّشّيٍ. ");
INSERT INTO susa_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","كِكٍ شِ سِنفٍ بِرِن، وٌ شَ تُورَ قِرِن بَ سّرّشّ فَن دَاشِ رَ، عَ نُن يّشّي كٌنتٌنيِ كٍرٍن، عَ نُن يّشّي سٌلٌقٍرٍ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ تُورَ كٍرٍن يٌ تُورَ كٍرٍن سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٌنتٌنيِ كٍرٍن يٌ يّشّي كٌنتٌنيِ كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٍرٍن يٌ يّشّي كٍرٍن سّيتِ مَ. سّرّشّ فَن دَاشِ نَن عَ رَ نَشَن فَنمَ، عَ شِرِ حْشُنمّ تٍ ﭑ تَن عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","وّنِ لِتِرِ سَشَن سّرّشّ شَ بَ تُورَ بِرِن بّ. وّنِ لِتِرِ قِرِن سّرّشّ شَ بَ يّشّي كٌنتٌنيِ بِرِن بّ. وّنِ لِتِرِ كٍرٍن سّرّشّ شَ بَ يّشّي بِرِن بّ. نَ سّرّشّ مْولِ بَمَ كِكٍ شِ سِنفٍ بِرِن حّ كُي. ");
INSERT INTO susa_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","وٌ شَ سِكْتّ كٍرٍن قَن بَ عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ، وٌ فّيسّفّ نُن نُنمَرٍ سّرّشّ بَمَ تّمُي نَشّ، عَ نُن عَ شَ وّنِ سّرّشّ. ");
INSERT INTO susa_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","كِكٍ سِنفٍ شِ قُ نُن نَانِ ندٍ، وٌ شَ سَيَمَلٍكّ دَنفِ سَلِ رَبَ عَلَتَلَ شَ بِنيّ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","نَ كِكٍ شِ قُ نُن سُولِ ندٍ قِندِ مَ سَلِ لْشْي نَن نَ. وٌ شَ تَامِ لّبِنِتَرٍ دٌن شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","نَ شِ سِنفٍ وٌ شَ وٌ مَلَن عَلَ بَتُدٍ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","وٌ شَ يِ سّرّشّ فَن دَاشِيٍ بَ عَلَتَلَ بّ نَ لْشْي؛ تُورَ قِرِن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي سٌلٌقٍرٍ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ تُورَ كٍرٍن يٌ تُورَ كٍرٍن سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٌنتٌنيِ كٍرٍن يٌ يّشّي كٌنتٌنيِ كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي يٌ يّشّي سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","وٌ شَ سِكْتّ كٍرٍن قَن بَ عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","وٌ شَ نَ سّرّشّيٍ سَ فّيسّفّ دَاشِيٍ شُن مَ، نَشٍيٍ بَمَ لْشْي بِرِن. ");
INSERT INTO susa_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","وٌ شَ نٍيٍ بَ شِ سٌلٌقٍرٍ بُن مَ. سّرّشّ فَن دَاشِ نَن عَ رَ نَشَن فَنمَ، عَ شِرِ حْشُنمّ تٍ ﭑ تَن عَلَتَلَ رَ. نٍيٍ بَمَ نّ لْشْ يٌ لْشْ، عٍ نُن بٌورٍ سّرّشّ فَن دَاشِيٍ، نُن وّنِ سّرّشّ. ");
INSERT INTO susa_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","عَ شِ سٌلٌقٍرٍ ندٍ، وٌ شَ وٌ مَلَن عَلَ بَتُدٍ. وٌ نَشَ وَلِ فبّتّيٍ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","شّ شَبَ سَلِ، وٌ نَ قَ سَنسِ بٌفِ سِنفٍيٍ سّرّشّ رَ عَلَتَلَ شْن مَ، وٌ شَ وٌ مَلَن ﭑ بَتُدٍ. وٌ نَشَ وَلِ يٌ سُشُ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","وٌ شَ يِ سّرّشّيٍ بَ؛ تُورَ قِرِن، يّشّي كٌنتٌنيِ كٍرٍن، نُن يّشّي سٌلٌقٍرٍ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ. نٍيٍ نَن بَمَ سّرّشّ فَن دَاشِ رَ، عٍ شِرِ حْشُنمّ تٍ ﭑ تَن عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ تُورَ كٍرٍن يٌ تُورَ كٍرٍن سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٌنتٌنيِ كٍرٍن يٌ يّشّي كٌنتٌنيِ كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٍرٍن يٌ يّشّي كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","وٌ شَ سِكْتّ كٍرٍن قَن بَ عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ. لَنيُرُ يٌ نَشَ لُ نَ سّرّشّيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«كِكٍ سٌلٌقٍرٍ ندٍ شِ سِنفٍ، وٌ شَ وٌ مَلَن ﭑ بَتُدٍ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. وٌ سَرَيٍ قٍمَ نّ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","وٌ شَ تُورَ قِرِن بَ سّرّشّ فَن دَاشِ رَ، عَ نُن يّشّي كٌنتٌنيِ كٍرٍن، عَ نُن يّشّي سٌلٌقٍرٍ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ تُورَ كٍرٍن يٌ تُورَ كٍرٍن سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٌنتٌنيِ كٍرٍن يٌ يّشّييٍ كٌنتٌنيِ كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٍرٍن يٌ يّشّي كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","وٌ شَ سِكْتّ كٍرٍن قَن بَ عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","نَ سّرّشّ بِرِن سَمَ سّرّشّ فَن دَاشِيٍ نَن شُن، وٌ نَشٍيٍ بَمَ لْشْ يٌ لْشْ، عَ نُن وٌ نَشٍيٍ بَمَ كِكٍ يٌ كِكٍ عَ شِ سِنفٍ، عَ نُن سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن سَمَ عٍ سّيتِ مَ. سّرّشّيٍ نَن عٍ رَ نَشٍيٍ فَنمَ، عٍ شِرِ حْشُنمّ تٍ ﭑ تَن عَلَتَلَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«نَ كِكٍ سٌلٌقٍرٍ ندٍ، شِ قُ لْشْي، وٌ شَ وٌ مَلَن ﭑ بَتُدٍ، وٌ قَن شَ سُنيِ سُشُ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","نَ لْشْي وٌ شَ تُورَ ندٍ بَ سّرّشّ فَن دَاشِ رَ، عَ نُن يّشّي كٌنتٌنيِ كٍرٍن، عَ نُن يّشّي سٌلٌقٍرٍ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ تُورَ سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٌنتٌنيِ كٍرٍن يٌ يّشّي كٌنتٌنيِ كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ يّشّي كٍرٍن يٌ يّشّي كٍرٍن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ، دَنفِقٍ نَ يُنُبِ شَقَرِ سّرّشّ، نُن نَ سّرّشّ فَن دَاشِيٍ وٌ نَشٍيٍ بَمَ لْشْ يٌ لْشْ، عَ نُن سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ.» ");
INSERT INTO susa_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«كِكٍ سٌلٌقٍرٍ ندٍ، شِ قُ نُن سُولِ، وٌ شَ وٌ مَلَن ﭑ بَتُدٍ. وٌ نَشَ وَلِ يٌ رَبَ نَ لْشْي. وٌ شَ سَلِ ندٍ رَبَ ﭑ تَن عَلَتَلَ بّ شِ سٌلٌقٍرٍ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","عَ شِ سِنفٍ، وٌ شَ تُورَ قُ نُن سَشَن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ فَن دَاشِ رَ ﭑ تَن عَلَتَلَ بّ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ يٌ مُ نَ نَشٍيٍ مَ. وٌ نَ عٍ فَن، عَ شِرِ حْشُنمّ تٍ ﭑ تَن عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٌلٌمَنَانِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ نَ تُورَ قُ نُن سَشَن سّيتِ مَ. سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سٍننِ نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ نَ يّشّي كٌنتٌنيِ قِرِن سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","سَنسِ شْرِ دِنشِ سّرّشّ كِلٌ سَشَن نَشَن نَمُلَنشِ تُرٍ رَ، عَ شَ سَ نَ يّشّي قُ نُن نَانِ سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ، دَنفِقٍ نَ يُنُبِ شَقَرِ سّرّشّ، نُن نَ سّرّشّ فَن دَاشِيٍ وٌ نَشٍيٍ بَمَ لْشْ يٌ لْشْ، عَ نُن سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ.» ");
INSERT INTO susa_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«سَلِ شِ قِرِن ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«سَلِ شِ سَشَن ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«سَلِ شِ نَانِ ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«سَلِ شِ سُولِ ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«سَلِ شِ سٍننِ ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«سَلِ شِ سٌلٌقٍرٍ ندٍ، وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","عَ نُن عٍ شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ نَشَن لَنمَ سّرِيّ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","وٌ شَ سِكْتّ كٍرٍن قَن بَ عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«سَلِ شِ سٌلٌمَسَشَن ندٍ، وٌ شَ وٌ مَلَن ﭑ تَن عَلَ بَتُدٍ. وٌ نَشَ وَلِ فبّتّيٍ رَبَ نَ لْشْي. ");
INSERT INTO susa_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","وٌ شَ تُورَ قُ نُن قِرِن، يّشّي كٌنتٌنيِ قِرِن، نُن يّشّي قُ نُن نَانِ بَ سّرّشّ فَن دَاشِ رَ، نَشٍيٍ بَرَ حّ كٍرٍن سْتْ، لَنيُرُ مُ نَ نَشَن مَ. عٍ شِرِ حْشُنمّ تٍمَ ﭑ تَن عَلَتَلَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","وٌ مَن شَ سَنسِ شْرِ دِنشِ نُن وّنِ سّرّشّ بَ نَشَن لَنمَ سّرِيّ كِ مَ نَ تُورَ، نَ يّشّي كٌنتٌنيِ، نُن نَ يّشّي شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","وٌ شَ سِكْتّ كٍرٍن قَن بَ ﭑ تَن عَلَتَلَ بّ يُنُبِ شَقَرِ سّرّشّ رَ. وٌ شَ نَ سّرّشّيٍ سَ بٌورٍ سّرّشّيٍ شُن، وٌ نَشٍيٍ بَمَ لْشْي بِرِن، عٍ نُن سَنسِ شْرِ نُن وّنِ نَشَن قَن بَمَ سّرّشّ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«سّرّشّيٍ نَن نَ كِ وٌ لَن وٌ شَ نَشٍيٍ بَ ﭑ تَن عَلَتَلَ بّ وٌ شَ سَلِ لْشْييٍ، بَقٍ وٌ شَ لَايِدِ سّرّشّيٍ، وٌ شَ سّرّشّ حَنِفٍشِيٍ، وٌ شَ سّرّشّ فَن دَاشِيٍ، وٌ شَ سَنسِ شْرِ دِنشِ سّرّشّيٍ، وٌ شَ وّنِ سّرّشّيٍ، نُن وٌ شَ شَنُنتٍيَ سّرّشّيٍ.» ");
INSERT INTO susa_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ بِرِن قَلَ عِسِرَيِلَكَيٍ بّ، عَ نَشٍيٍ سٌ عَ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","مُنسَ نَشَ يِ مَسٍنيِ تِ عِسِرَيِلَ بْنسْي كُنتِفِيٍ بّ، «عَلَتَلَ شَ يَامَرِيٍ نَن يَ؛ ");
INSERT INTO susa_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","شَ مِشِ ندٍ سَ لَايِدِ تٌنفٌ عَلَتَلَ بّ قٍ ندٍ مَ، شَ نَ مُ عَ عَ كَلِ عَلَتَلَ رَ قٍ ندٍ مَ، نَ كَنيِ لَن نّ عَ شَ عَ شُي رَكَمَلِ. عَ نَشَن بِرِن قَلَشِ عَ دّ رَ، عَ شَ عَ بِرِن نَبَ.» ");
INSERT INTO susa_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","«فِنّ دِ مّدِ نَ سَ لَايِدِ تٌنفٌ قٍ ندٍ مَ عَلَتَلَ بّ، عَ نَ عَ بَبَ شْنيِ تّمُي نَشّ، عَ قَ عَ كَلِ، ");
INSERT INTO susa_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","عَ بَبَ نَشَ عَ كٌلٌن عَ عَ شَ دِ فِنّ بَرَ لَايِدِ ندٍ تٌنفٌ، عَ بَبَ مُ سٍسٍ قَلَ نَ قٍ كُي، عَ شَ نَ لَايِدِ رَكَمَلِ. ");
INSERT INTO susa_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","كْنْ شَ عَ بَبَ مُ تِن نَ لَايِدِ تٌنفٌشِ رَ عَ مّ تّمُي، عَ مُ لَن نَ فِنّ دِ مّدِ شَ عَ رَكَمَلِ. عَلَتَلَ مُ عَ سُشُمَ عَ رَ عَ بَبَ وَشْنقٍ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","«فِنّ نَ سَ لَايِدِ تٌنفٌ، شَ نَ مُ عَ عَ كَلِ وْيّنيِ مَقُرَشِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","شَ عَ شَ مْرِ سَ نَ مّ، عَ قَ لُ عَ مُ سٍسٍ قَلَ نَ قٍ رَ، عَ شَ نَ لَايِدِ رَكَمَلِ. ");
INSERT INTO susa_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","كْنْ شَ عَ شَ مْرِ مُ تِن نَ قٍ رَ عَ مّ تّمُي، عَ مُ لَن نَ فِنّ شَ عَ رَكَمَلِ. عَلَتَلَ مُ عَ سُشُمَ عَ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«كَاحّ فِنّ نَ لَايِدِ تٌنفٌ، شَ نَ مُ، فِنّ نَشَن نُن عَ شَ شّمّ بَرَ قَتَن، عَ شَ عَ شَ لَايِدِ رَكَمَلِ.» ");
INSERT INTO susa_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","«فِنّ شّمّ تَا عِدْشْي نَ لَايِدِ تٌنفٌ، شَ نَ مُ عَ عَ كَلِ قٍ ندٍ مَ، ");
INSERT INTO susa_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","شَ عَ شَ مْرِ قَ نَ قٍ كٌلٌن، كْنْ عَ مُ قٍقٍ قَلَ نَ قٍ كُي، عَ لَنمَ نَ فِنّ شَ عَ شَ لَايِدِ رَكَمَلِ. ");
INSERT INTO susa_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","عَ شَ مْرِ نَ عَ شَ لَايِدِ مّ تّمُي نَشّ، عَ نْمَ تِندٍ عَ رَ، شَ نَ مُ عَ رَ، عَ نْمَ تْنيِ دْشْدٍ عَ مَ. عَلَتَلَ مُ عَ سُشُمَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","عَ شَ مْرِ نْمَ تِندٍ، شَ نَ مُ عَ رَ تٌندِدٍ عَ شَ لَايِدِ نُن عَ شَ كَلِ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","شَ عَ مُ قٍقٍ قَلَمَ نَ قٍ كُي، عَ شَ فِنّ لَنمَ عَ شَ عَ شَ لَايِدِ رَكَمَلِ. عَ شَ دُندُي عَ نِيَمَ نّ فِنّ شَ عَ شَ لَايِدِ رَكَمَلِ. ");
INSERT INTO susa_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","شَ عَ شَ مْرِ تْنيِ دْشْمَ عَ شَ فِنّ شَ لَايِدِ مَ تّمُي فبّتّ، عَ تَن نَن يَتِ عَ شَ فِنّ شَ كٌتٍ شَنِنمَ.» ");
INSERT INTO susa_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","«عَلَتَلَ شَ سّرِيّ نَن نَ كِ عَ نَشَن قِشِ مُنسَ مَ، فِنّ شَ قٍ رَ نَشَن نَ شّمّ تَا، شَ نَ مُ عَ رَ فِنّ نَشَن نَ عَ بَبَ شْنيِ.» ");
INSERT INTO susa_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","عَلَتَلَ نَشَ يِ مَسٍنيِ تِ مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«عِ شَ عِسِرَيِلَكَيٍ فبٍ حْشْ مَدِيَنكَيٍ مَ. عِ نَ فّ نَ رَ، عِ قَ تَا مَسَرَ.» ");
INSERT INTO susa_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","مُنسَ نَشَ عَ قَلَ حَمَ بّ، «شّمّ ندٍيٍ شَ فٍرٍ سٌسٍيٍ تٌنفٌ مَدِيَن شِلِ مَ وٌ فبٍ حْشْدٍ عَلَتَلَ شِلِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","عِسِرَيِلَ بْنسْي بِرِن شَ مِشِ وُلُ كٍرٍن كٍرٍن بَ فٍرٍ سٌي رَ.» ");
INSERT INTO susa_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","عِسِرَيِلَ بْنسْي قُ نُن قِرِن نَشَ مِشِ وُلُ كٍرٍن كٍرٍن بَ فٍرٍ سٌي رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","مُنسَ نَشَ نَ سْورِ وُلُ قُ نُن قِرِن شّي فٍرٍ تِدٍ. عٍلٍيَسَرِ سّرّشّدُبّ شَ دِ شّمّ قِنٍشَسِ نَشَ عٍ مَتِ، سٍ سّنِيّنشِيٍ نُ نَ عَ يِ رَ، عَ نُن سَرَ نَشٍيٍ تْنشُمَ قِمَ عٍ بٌورٍ مَ فٍرٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","عٍ نَشَ سِفَ فٍرٍ تِدٍ مَدِيَن شِلِ مَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ مُنسَ بّ. عٍ نَشَ نَ شّمّيٍ بِرِن قَشَ، ");
INSERT INTO susa_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","عَ نُن مَدِيَن مَنفّ سُولِ؛ عٍقِ، رٍكٍمِ، سُورُ، شُرُ، نُن رٍبَ. عٍ نَشَ بٍيٌرِ شَ دِ شّمّ بَلَمِ قَن قَشَ سَنتِدّفّمَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","عٍ نَشَ مَدِيَن فِنّيٍ نُن عٍ شَ دِ بِرِن قِندِ كٌنيِيٍ رَ. عٍ نَشَ عٍ شَ شُرُ سٍيٍ، عٍ شَ فْورّيٍ، نُن عٍ هَرِفٍ بِرِن تٌنفٌ. ");
INSERT INTO susa_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","عٍ نَشَ عٍ شَ تَايٍ نُن عٍ شَ دَاشَيٍ فَن. ");
INSERT INTO susa_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","عٍ نَشَ عٍ شَ هَرِفٍ، عٍ شَ شُرُ سٍيٍ، نُن عٍ شَ فِنّيٍ سُشُ، ");
INSERT INTO susa_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","عٍ عٍ شَنِن مُنسَ، عٍلٍيَسَرِ، نُن عِسِرَيِلَ حَمَ شْن مَ عٍ يٌنكِندٍ مٌوَبَ قِيلِ مَ، يُرُدّن شُرٍ دّ عِ، يٍرِكٌ يَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","مُنسَ، عٍلٍيَسَرِ سّرّشّدُبّ، نُن عِسِرَيِلَ حَمَ يَرٍرَتِيٍ نَشَ عٍ رَلَن يٌنكِندٍ قَرِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","مُنسَ نَشَ شْنْ سْورِ وُلُ شُنيِيٍ نُن سْورِ كّمّ شُنيِيٍ مَ، عَ عَ قَلَ عٍ بّ، ");
INSERT INTO susa_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","«مُنقٍ رَ وٌ مُ يِ فِنّيٍ قَشَ؟ ");
INSERT INTO susa_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","عٍ تَن نَن بِرَ بَلَمِ شَ مَرَ سِ قْشْ رَ، عٍ عِسِرَيِلَكَيٍ رَ مِنِ عَلَتَلَ شَ كِرَ شْن ثٍيٌرِ، عَلَتَلَ قَ فبَلٌي رَفٌرٌ عَ شَ حَمَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","عَوَ، يَكْسِ، وٌ شّمّ دِ مّ بِرِن قَشَ، عَ نُن فِنّ نَشٍيٍ بَرَ شّمّ قٍ كٌلٌن. ");
INSERT INTO susa_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","فِنّ دِ مّدِيٍ تَن، وٌ شَ نٍيٍ رَفَتَ وٌ يّتّ بّ. ");
INSERT INTO susa_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","وٌ تَن نَشٍيٍ بَرَ مِشِ قَشَ، شَ نَ مُ وٌ بَرَ دِن قُرٍ رَ، وٌ شَ لُ يٌنكِندٍ قَرِ مَ شِ سٌلٌقٍرٍ، عَ نُن مِشِيٍ وٌ نَشٍيٍ سُشُ فٍرٍ كُي. وٌ شَ وٌ يّتّ نُن وٌ شَ مِشِ سُشُشِيٍ رَ سّنِيّن عَ شِ سَشَن ندٍ نُن عَ شِ سٌلٌقٍرٍ ندٍ. ");
INSERT INTO susa_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","وٌ شَ وٌ شَ دُفِيٍ قَن نَسّنِيّن عَ نُن سٍيٍ نَشَن تَن بِرِن نَقَلَشِ كِرِ، سِ شَبٍ، نُن وُرِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","عٍلٍيَسَرِ سّرّشّدُبّ نَشَ عَ قَلَ سْورِيٍ بّ نَشٍيٍ فٍرٍ تِشِ، «عَلَتَلَ شَ سّرِيّ نَن يَ عَ نَشَن مَسٍنشِ مُنسَ بّ؛ ");
INSERT INTO susa_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","شّيمَ، فبٍتِ، وُرٍ فبٍيلِ، وُرٍ، يْشُي، نُن سُنبُي، ");
INSERT INTO susa_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","سٍ نَشَن بِرِن مُ فَنمَ تّ رَ، وٌ شَ عَ رَ سٌ تّ، عَ شَ سّنِيّن. نَ دَنفِ شَنبِ وٌ مَن شَ عَ رَ سّنِيّن يٍ رَ. سٍ نَشَن مُ نْمَ رَ سٌدٍ تّ، وٌ شَ نَ رَ سّنِيّن يٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","وٌ شَ وٌ شَ دُفِيٍ شَ عَ شِ سٌلٌقٍرٍ ندٍ. نَ تّمُي وٌ بَرَ سّنِيّن، وٌ قَ نْمَ سٌدٍ يٌنكِندٍ.» ");
INSERT INTO susa_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«عِ تَن، عٍلٍيَسَرِ سّرّشّدُبّ، نُن عِسِرَيِلَ كُنتِفِيٍ، وٌ شَ يِ مِشِ سُشُشِيٍ، نُن عٍ شَ شُرُ سٍيٍ كْنتِ، وٌ نَشٍيٍ سْتْشِ فٍرٍ كُي. ");
INSERT INTO susa_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","عِ شَ عٍ عِتَشُن سْورِيٍ نُن حَمَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","سْورِيٍ فبٍ يَ مَ، عِ شَ مِشِ كٍرٍن تٌنفٌ مِشِ كّمّ سُولِ يٌ مِشِ كّمّ سُولِ تَفِ، عَ شَ قِندِ ﭑ فبٍ رَ. شُرُ سٍيٍ قَن نَ كِ، كّمّ سُولِ يٌ كّمّ سُولِ، عِ كٍرٍن نَن تٌنفٌمَ عٍ يَ مَ ﭑ بّ. عَ قِندِ نِنفٍيٍ رَ، عَ قِندِ سٌقَلٍيٍ رَ، عَ قِندِ شُرُ سٍ لَنمَيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","عِ شَ نٍيٍ بَ سْورِيٍ فبٍ يَ مَ، عِ عٍ قِ عٍلٍيَسَرِ سّرّشّدُبّ مَ عَلَتَلَ شِلِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","عِسِرَيِلَ حَمَ فبٍ يَ مَ، عِ شَ مِشِ كٍرٍن تٌنفٌ مِشِ تٌنفٌ سُولِ يٌ مِشِ تٌنفٌ سُولِ يَ مَ، كّمّ سُولِ يٌ كّمّ سُولِ، عِ كٍرٍن نَن تٌنفٌمَ عٍ يَ مَ ﭑ بّ. عَ قِندِ نِنفٍيٍ رَ، عَ قِندِ سٌقَلٍيٍ رَ، عَ قِندِ شُرُ سٍ لَنمَيٍ رَ. عِ شَ نٍيٍ سٌ لٍوِ بْنسْي يِ رَ، نَشٍيٍ عٍ حْشْ سَشِ ﭑ مَ هْرْ مْلِنفِرَ شْن.» ");
INSERT INTO susa_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","مُنسَ نُن عٍلٍيَسَرِ سّرّشّدُبّ نَشَ عَ رَبَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ مُنسَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","نَشَن سْتْ فٍرٍ كُي، عَ شَسَبِ لَن شُرُ سٍ لَنمَ وُلُ كّمّ سٍننِ وُلُ تٌنفٌ سٌلٌقٍرٍ نُن سُولِ نَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","نِنفٍ وُلُ تٌنفٌ سٌلٌقٍرٍ نُن قِرِن، ");
INSERT INTO susa_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","سٌقَلٍ وُلُ تٌنفٌ سٍننِ نُن كٍرٍن، ");
INSERT INTO susa_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","فِنّ نَشٍيٍ مُ شّمّ قٍ كٌلٌن، مِشِ وُلُ تٌنفٌ سَشَن نُن قِرِن. ");
INSERT INTO susa_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","سّيتِ نَشَن قِشِ سْورِيٍ مَ نَشٍيٍ فٍرٍ تِ، عَ شَسَبِ نَشَ لَن شُرُ سٍ لَنمَ وُلُ كّمّ سَشَن وُلُ تٌنفٌ سَشَن نُن سٌلٌقٍرٍ كّمّ سُولِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","عَلَتَلَ فبٍ نَشَن بَ نَ رَ، نَ نَشَ لَن شُرُ سٍ لَنمَ كّمّ سٍننِ تٌنفٌ سٌلٌقٍرٍ نُن سُولِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","نِنفٍ نَشٍيٍ قِشِ سْورِيٍ مَ، عٍ شَسَبِ نَشَ لَن وُلُ تٌنفٌ سَشَن نُن سٍننِ مَ. عَلَتَلَ فبٍ نَشَن بَ نَ رَ، نَ نَشَ لَن نِنفٍ تٌنفٌ سٌلٌقٍرٍ نُن قِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","سٌقَلٍ نَشٍيٍ قِشِ سْورِيٍ مَ، عٍ شَسَبِ نَشَ لَن وُلُ تٌنفٌ سَشَن كّمّ سُولِ مَ. عَلَتَلَ فبٍ نَشَن بَ نَ رَ، نَ نَشَ لَن سٌقَلٍ تٌنفٌ سٍننِ نُن كٍرٍن مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","مِشِ نَشٍيٍ قِشِ سْورِيٍ مَ، عٍ شَسَبِ نَشَ لَن وُلُ قُ نُن سٍننِ مَ. عَلَتَلَ فبٍ نَشَن بَ نَ رَ، نَ نَشَ لَن مِشِ تٌنفٌ سَشَن نُن قِرِن مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","مُنسَ نَشَ عَلَتَلَ فبٍ قِ عٍلٍيَسَرِ سّرّشّدُبّ مَ، عَلْ عَلَتَلَ عَ يَمَرِ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","عِسِرَيِلَ حَمَ فبٍ، مُنسَ نَشَن سٌ عٍ يِ رَ، نَشَن مُ نُ نَ سْورِيٍ فبٍ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","نَ قِندِشِ شُرُ سٍ لَنمَيٍ وُلُ كّمّ سَشَن تٌنفٌ سَشَن نُن سٌلٌقٍرٍ كّمّ سُولِ نَن مَ، ");
INSERT INTO susa_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","عَ نُن نِنفٍ وُلُ تٌنفٌ سَشَن نُن سٍننِ، ");
INSERT INTO susa_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","عَ نُن سٌقَلٍ وُلُ تٌنفٌ سَشَن كّمّ سُولِ، ");
INSERT INTO susa_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","عَ نُن مِشِ وُلُ قُ نُن سٍننِ. ");
INSERT INTO susa_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","نَ كُي، شُرُ سٍيٍ بَ، مِشِيٍ بَ، تٌنفٌ سُولِ يٌ تٌنفٌ سُولِ، مُنسَ نَشَ كٍرٍن كٍرٍن بَ عَ بِرِن نَ، عَ عٍ سٌ لٍوِ بْنسْي يِ رَ، نَشٍيٍ عٍ حْشْ سَشِ عَلَتَلَ شَ هْرْ مْلِنفِرَ شْن، عَلْ عَلَتَلَ عَ يَمَرِ عَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","سْورِ كّمّ شُنيِيٍ نُن سْورِ وُلُ شُنيِيٍ نَشَ قَ مُنسَ يِرٍ، ");
INSERT INTO susa_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","عٍ عَ قَلَ عَ بّ، «مُشُ تَن عِ شَ كٌنيِيٍ، مُشُ بَرَ سْورِيٍ كْنتِ نَشٍيٍ نُ نَ مُشُ شَ يَامَرِ بُن مَ. عٍ بِرِن نَ نَ. ");
INSERT INTO susa_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","نَ نَن عَ تٌشِ مُشُ بَرَ قَ هَدِيَيٍ رَ عَلَتَلَ بّ شُنسَرٍ شَ قٍ رَ. كَنكَن بَرَ قَ عَ سْتْسٍيٍ رَ عَلْ بّلّشّرَ سٌي، شُرُندّيٍ، تُلِرَ سٌي، نُن كْنمَفٌرٍ شّيمَ دَاشِ.» ");
INSERT INTO susa_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","مُنسَ نُن عٍلٍيَسَرِ سّرّشّدُبّ نَشَ نَ سٍيٍ شّيمَ دَاشِ رَ سُشُ عٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","نَ شّيمَ بِرِن، سْورِ شُنيِيٍ قَ نَشَن نَ عَلَتَلَ بّ، عَ شَسَبِ لَن قَيِدَ شّيمَ كِلٌ كّمّ تٌنفٌ سٌلٌقٍرٍ نَن مَ. ");
INSERT INTO susa_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","سْورِيٍ تَن نُ عٍ فبٍيٍ رَفَتَشِ عٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","مُنسَ نُن عٍلٍيَسَرِ سّرّشّدُبّ نَشَ نَ سٍيٍ بِرِن نَسُشُ سْورِ وُلُ شُنيِيٍ نُن سْورِ كّمّ شُنيِيٍ يِ رَ، عٍ عَ شَنِن هْرْ مْلِنفِرَ يِرٍ، عَلَكٌ نَ شَ قِندِ تْنشُمَ رَ عِسِرَيِلَ شَ قٍ رَ عَلَتَلَ بّ. ");
INSERT INTO susa_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","فْورّ فبٍفبٍ نَن نُ نَ رُبٍن بْنسْي نُن فَدِ بْنسْي يِ رَ. عٍ تٌ عَ تٌ يَاسّرِ نُن فَلَدِ بْشِ قَن شُرُ سٍيٍ بّ، ");
INSERT INTO susa_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","عٍ نَشَ قَ مُنسَ، عٍلٍيَسَرِ، نُن عِسِرَيِلَ كُنتِفِيٍ يِرٍ، ");
INSERT INTO susa_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","عٍ عَ قَلَ عٍ بّ، «تَا نَشٍيٍ شِلِ عَتَرٌتِ، دِبٌن، يَاسّرِ، نِمِرَ، شّسِبْن، عٍلٍيَلٍ، سٍبَمِ، نٍبٌ، نُن بٍيٌن، نٍيٍ نَ بْشِ يَ مَ، ");
INSERT INTO susa_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","عَلَتَلَ نَشَن سَشِ عِسِرَيِلَ حَمَ سَفٌي. نَ لٌنفٌرِ قَن شُرُ سٍ كَنيِيٍ بّ عَلْ مُشُ تَن. ");
INSERT INTO susa_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","شَ وٌ بَرَ تِن عَ رَ، بٍ شَ قِندِ مُشُ تَن فبٍ رَ، هَلِ مُشُ مُ دَنفِ يُرُدّن نَاكِرِ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","مُنسَ نَشَ فَدِ بْنسْي نُن رُبٍن بْنسْي يَابِ، «وٌ نفَشَكٍرٍنيِيٍ سِفَمَ نّ فٍرٍ سٌدٍ، وٌ تَن شَ لُ بٍ؟ ");
INSERT INTO susa_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","مُنقٍ رَ وٌ وَ مَ لِمَنِيَ بَقٍ وٌ نفَشَكٍرٍنيِيٍ يِ رَ، عَلَكٌ عٍ نَشَ دَنفِ يُرُدّن نَاكِرِ مَ بْشِ مَ عَلَتَلَ نَشَن قِشِ عٍ مَ؟ ");
INSERT INTO susa_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","وٌ بَبَيٍ قَن بَرَ نَ وَلِ مْولِ رَبَ ﭑ تٌ عٍ شّي كَنَان بْشِ رَبّندٍ كٍلِقٍ كَدٍ سِ بَرِنٍيَ. ");
INSERT INTO susa_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","عٍ تٌ فّ عٍسٍكٌلِ فُلُنبَ رَبّندٍ، عٍ نَشَ فبِلٍن، عٍ قَ لِمَنِيَ بَ عِسِرَيِلَكَيٍ يِ رَ سٌقٍ رَ بْشِ مَ، عَلَتَلَ نَشَن قِشِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","عَلَتَلَ نَشَ شْنْ عِسِرَيِلَكَيٍ مَ نَ لْشْي، عَ قَ عَ كَلِ، ");
INSERT INTO susa_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹يِ مِشِ نَشَن بِرِن كٍلِشِ مِسِرَ، نَشَن شَ سِمَيَ بَرَ دَنفِ حّ مْشْحّن نَ، عٍ مُ سٌمَ بْشِ مَ ﭑ نَن ﭑ كَلِ عِبُرَهِمَ، عِسِيَفَ نُن يَشُبَ بّ دّننَشَن قِقٍ رَ عٍ مَ، بَرِ مَ عٍ مُ بِرَ ﭑ قْشْ رَ عٍ حَنِفٍ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","قٌ يٍقُنٍ شَ دِ شّمّ كَلٍبِ كٍنِسِكَ، نُن نُنُ شَ دِ شّمّ يٌسُوٍ، نٍيٍ نَن ثٍتِ بِرَ ﭑ شُي قْشْ رَ عٍ حَنِفٍ بِرِن نَ.› ");
INSERT INTO susa_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","عَلَتَلَ نَشَ شْنْ عِسِرَيِلَكَيٍ مَ كِ قَنيِ، عَ قَ عٍ رَبّحِن فبٍنفبٍرٍنيِ مَ حّ تٌنفٌ نَانِ بُن مَ، هَن نَ مِشِ بِرِن قَشَ، نَشٍيٍ وَلِ كِ مُ نُ رَقَن عَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","وٌ تَن يُنُبِتْي بْنسْييٍ، وٌ نَ بِرَقٍ وٌ بٍنبَيٍ قْشْ رَ عَلَتَلَ رَشْنْقٍ رَ عِسِرَيِلَ شِلِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","شَ وٌ كٍلِ عَلَ شَ كِرَ شْن، عَ مَن عِسِرَيِلَ رَبّحِنمَ نّ فبٍنفبٍرٍنيِ مَ، عٍ هَلَكِ وٌ شَ قٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","عٍ نَشَ سِفَ مُنسَ يِرٍ، عٍ عَ قَلَ عَ بّ، «مُشُ وَ مَ فْورّ تِقٍ بٍ مُشُ شَ شُرُ سٍيٍ بّ، عَ نُن مُشُ وَ مَ يِرٍيٍ يَءِلَنقٍ بٍ مُشُ شَ فِنّيٍ نُن مُشُ شَ دِيٍ لُمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","كْنْ مُشُ بَرَ تِن سْورِحَ رَبَدٍ مُشُ نفَشَكٍرٍنيِ عِسِرَيِلَكَيٍ بّ هَن عٍ شَ سٌ عٍ سٌدٍ. مُشُ شَ دِيٍ تَن لُمَ بٍ مُشُ شَنبِ رَ نّ تَا كَنتَشِيٍ كُي، عَلَكٌ بٍكَيٍ نَشَ عٍ تْورْ. ");
INSERT INTO susa_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","مُشُ مُ فبِلٍنمَ مُشُ شْنيِ بٍ، قٌ عِسِرَيِلَكَ بِرِن عَ فبٍ بْشِ مَسْتْ. ");
INSERT INTO susa_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","كّ فبّتّ مُ لُمَ مُشُ تَن بّ سْنْن يُرُدّن نَاكِرِ مَ. مُشُ فبٍ نَ بٍبِرِ يُرُدّن سٌفٍتٍدٍ نّ.» ");
INSERT INTO susa_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","مُنسَ نَشَ عَ قَلَ عٍ بّ، «شَ وٌ سَ عَ رَبَ عَلْ وٌ عَ قَلَشِ كِ نَشّ، شَ وٌ وٌ مَشِرِ سِفَقٍ رَ فٍرٍ تِدٍ عَلَتَلَ شِلِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","شَ وٌ مُ فبِلٍن بٍ يُرُدّن نَاكِرِ مَ، هَن عَلَتَلَ فّ عَ يَشُييٍ بِرِن كٍرِدٍ عَ يَ رَ، ");
INSERT INTO susa_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","نَ تّمُي بٍ بَرَ قِندِ وٌ شَ بْشِ رَ عَلَتَلَ شِلِ رَ. مّننِ نَ لُ عَلَتَلَ شَ يَامَرِ بُن مَ، وٌ نْمَ فبِلٍندٍ بٍ. نَ كُي وٌ بَرَ وٌ شَ لَايِدِ رَكَمَلِ عِسِرَيِلَ نُن عَلَتَلَ بّ.» ");
INSERT INTO susa_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","«كْنْ شَ وٌ مُ سَ نَ سّرِيّ رَبَتُ، نَ بَرَ قِندِ يُنُبِ رَ وٌ بّ، وٌ نَ سَرٍ قِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","يَكْسِ، وٌ شَ تَايٍ تِ وٌ شَ فِنّيٍ نُن وٌ شَ دِيٍ بّ. وٌ شَ فْورّيٍ يَءِلَن وٌ شَ شُرُ سٍيٍ قَن بّ. كْنْ وٌ نَشَ نّيمُ وٌ شَ لَايِدِ تٌنفٌشِ مَ دٍ، وٌ شَ نَ رَكَمَلِ.» ");
INSERT INTO susa_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","فَدِ بْنسْي نُن رُبٍن بْنسْي نَشَ مُنسَ يَابِ، «مُشُ قَمَ نّ عِ شَ يَامَرِ بِرِن سُشُدٍ. ");
INSERT INTO susa_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","مُشُ شَ دِيٍ، مُشُ شَ فِنّيٍ، نُن مُشُ شَ شُرُ سٍيٍ بِرِن لُمَ بٍ فَلَدِ بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","كْنْ مُشُ فٍرٍ سٌسٍيٍ تٌنفٌمَ نّ، مُشُ قَ فٍرٍ سٌ عَلَتَلَ بّ عَلْ عِ عَ يِتَشِ كِ نَشّ، مُشُ مَرِفِ.» ");
INSERT INTO susa_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","مُنسَ نَشَ عٍلٍيَسَرِ سّرّشّدُبّ، نُنُ شَ دِ شّمّ يٌسُوٍ، عَ نُن عِسِرَيِلَ كُنتِفِيٍ يَمَرِ، ");
INSERT INTO susa_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«شَ فَدِ بْنسْي نُن رُبٍن بْنسْي سَ دَنفِ يُرُدّن نَاكِرِ مَ، عٍ سِفَ فٍرٍ سٌدٍ عَلَتَلَ بّ، هَن وٌ نَشَ نَ بْشِ بِرِن مَسْتْ تّمُي نَشّ، وٌ شَ فَلَدِ بْشِ سٌ عٍ يِ رَ كّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","كْنْ شَ عٍ مُ نَ رَبَ، عٍ قَن شَ سَبَتِ وٌ تَفِ كَنَان بْشِ مَ!» ");
INSERT INTO susa_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","فَدِ بْنسْي نُن رُبٍن بْنسْي نَشَ عٍ يَابِ، «عَلَتَلَ نَشَن بِرِن مَسٍنشِ عَ شَ كٌنيِ دِيٍ شَ قٍ رَ، مُشُ عَ بِرِن نَبَمَ نّ. ");
INSERT INTO susa_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","مُشُ دَنفِمَ نّ يُرُدّن نَاكِرِ مَ مُشُ شَ فٍرٍ سٌسٍيٍ رَ سِفَقٍ رَ كَنَان بْشِ مَ عَلَتَلَ يَ تٌدٍ رَ، كْنْ مُشُ كّ تَن قِندِ مَ بْشِ نَن نَ يُرُدّن بٍبِرِ سّيتِ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","مُنسَ نَشَ عَمٌرِكَيٍ شَ مَنفّ سِشْن نُن بَسَن مَنفّ عٌفٌ شَ بْشِ نُن نَ رَبِلِنيِ قِ فَدِ بْنسْي، رُبٍن بْنسْي، نُن يُسُقُ شَ دِ شّمّ مَنَسِ بْنسْي سّيتِ كٍرٍن مَ. ");
INSERT INTO susa_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","فَدِ شَ دِيٍ نَشَ فبِلٍن دِبٌن تِ رَ، عَ نُن عَتَرٌتِ، عَرٌوٍرِ، ");
INSERT INTO susa_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","عَتِرٌتِ سٌقَنَ، يَاسّرِ، يٌفبٍهَ، ");
INSERT INTO susa_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","بٍتِ نِمِرَ، نُن بٍتِ شَرَنِ. عٍ بَرَ قِندِ تَا مَكَنتَشِيٍ رَ، فْورّيٍ فبٍفبٍ قَن نُ نَ. ");
INSERT INTO susa_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","رُبٍن بْنسْي نَشَ فبِلٍن شّسِبْن تِ رَ، عَ نُن عٍلٍيَلٍ، كِرِيَتَيِمِ، ");
INSERT INTO susa_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","نٍبٌ، بَالِ مٍيٌنِ، نُن سِبِمَ. عٍ نَشَ نَ تَا ندٍيٍ شِلِيٍ مَسَرَ. ");
INSERT INTO susa_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","مَنَسِ شَ دِ مَكِرِ شَ دِيٍ تٌ فَلَدِ تَا سُشُ، عٍ عَمٌرِكَيٍ كٍرِ نَشٍيٍ نُ سَبَتِشِ نَا، ");
INSERT INTO susa_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","مُنسَ نَشَ نَ تَا سٌ عٍ يِ رَ سَبَتِدٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","مَنَسِ شَ يَيِرِ قَن نَشَ تَا ندٍيٍ سُشُ، عَ عٍ شِلِ يَيِرِ شَ تَايٍ. ");
INSERT INTO susa_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","نٌبَ قَن نَشَ كٍنَتَ تَا نُن عَ رَبِلِنيِ سُشُ، عَ يّتّ شِلِ سَ عٍ شُن مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","حّرّ نَن يَ عِسِرَيِلَكَيٍ نَشَن نَبَ عٍ شُندّ كِ مَ مُنسَ نُن هَرُنَ شَ يَامَرِ بُن مَ عٍ تٌ كٍلِ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","مُنسَ نَ بِرِن سّبّشِ نّ عَلْ عَلَتَلَ عَ يَمَرِ عَ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","عٍ نَشَ كٍلِ رَ مٍسٍسِ تَا مِسِرَ بْشِ كِكٍ سِنفٍ شِ قُ نُن سُولِ. سَيَمَلٍكّ دَنفِ سَلِ لْشْي، نَ كُيٍ عِبَ عِسِرَيِلَكَيٍ نَشَ مِنِ مِسِرَ شْرّيَ كُي مِسِرَكَ بِرِن يَ شْرِ. ");
INSERT INTO susa_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","عَ عَ لِشِ نَ تّمُي، مِسِرَكَيٍ نُ نَ عٍ شَ دِ سِنفٍيٍ رَفَتَقٍ، عَلَتَلَ نَشٍيٍ قَشَ عٍ يَ مَ عَ شَ شْنّ كُي عٍ شَ كُيٍيٍ شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","عِسِرَيِلَكَيٍ نَشَ كٍلِ رَ مٍسٍسِ، عٍ سَ يٌنكِن سُكْتِ. ");
INSERT INTO susa_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عٍتَمَ فبٍنفبٍرٍنيِ دّ رَ. ");
INSERT INTO susa_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","عٍ تٌ كٍلِ عٍتَمَ، عٍ نَشَ فبِلٍن ثِ هَشِرْتِ مَبِرِ، بَالِ سٍقٌن يَ تَفِ، عٍ سَ يٌنكِن مِفِدٌلِ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ بَا عِفِرِ، عٍ سِفَ فبٍنفبٍرٍنيِ مَ. عٍ نَشَ شِ سَشَن حّرّ رَبَ عٍتَمَ فبٍنفبٍرٍنيِ مَ، عٍ سَ يٌنكِن مَرَ. ");
INSERT INTO susa_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عٍلِمِ، عٍ دُلٌنيِ قُ نُن قِرِن نُن تُفِ تٌنفٌ سٌلٌقٍرٍ لِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ شُلُنيُمِ بَا سّيتِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ سِنِ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سَ يٌنكِن دٌقِكَ. ");
INSERT INTO susa_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عَلُسُ. ");
INSERT INTO susa_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ رٍقِدِ مِ، كْنْ عٍ مُ يٍ تٌ نَا. ");
INSERT INTO susa_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ تُرُ سِنِنَ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ كِبِرٌتِ هَتَاوَ. ");
INSERT INTO susa_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ شَسٍرٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ رِتِمَ. ");
INSERT INTO susa_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ رِ مْن ثٍرٍ سِ. ");
INSERT INTO susa_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ لِبِنَ. ");
INSERT INTO susa_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ رِ سَ. ");
INSERT INTO susa_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ كٍهٍلَتَ. ");
INSERT INTO susa_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ سٍيقٍرِ فٍيَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ شَرَدَ. ");
INSERT INTO susa_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ مَكٍلٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ تَشَتِ. ");
INSERT INTO susa_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ تٍرَ. ");
INSERT INTO susa_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ مِتِكَ. ");
INSERT INTO susa_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ شَسَمٌنَ. ");
INSERT INTO susa_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ مٌسٍرَ. ");
INSERT INTO susa_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ بٍنٍيَاكَن. ");
INSERT INTO susa_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ هٌرٌ فِدِفَدَ. ");
INSERT INTO susa_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ يٌتٌبَتَ. ");
INSERT INTO susa_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عَبَرٌنَ. ");
INSERT INTO susa_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عٍسِيٌن فٍبٍرِ. ");
INSERT INTO susa_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ كَدٍ سِ سِنِ فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","عٍ كٍلِ مّننِ نّ، عٍ نَشَ سِفَ هٌرٌ فٍيَ مَ، عٍدٌن بْشِ نَانِنيِ قّ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","عِسِرَيِلَكَيٍ شَ مِنِ مِسِرَ حّ تٌنفٌ نَانِ كِكٍ سُولِ ندٍ شِ سِنفٍ، عَلَتَلَ نَشَ هَرُنَ يَمَرِ عَ شَ تٍ هٌرٌ فٍيَ قَرِ، عَ شَ لَاشِرَ مّننِ. ");
INSERT INTO susa_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","هَرُنَ نُ بَرَ حّ كّمّ مْشْحّن نُن سَشَن سْتْ، عَ قَشَ تّمُي هٌرٌ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","عَرَدِ مَنفّ، نَشَن سَبَتِشِ نٍفٍوِ فبٍنفبٍرٍنيِ كَنَان بْشِ مَ، عَ نَشَ عَ كٌلٌن عِسِرَيِلَكَيٍ بَرَ قَ. ");
INSERT INTO susa_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","عِسِرَيِلَكَيٍ تٌ كٍلِ هٌرٌ فٍيَ يِرٍ، عٍ نَشَ سَ يٌنكِن سَلَمٌنَ. ");
INSERT INTO susa_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ ثُنٌن. ");
INSERT INTO susa_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عٌبٌتِ. ");
INSERT INTO susa_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عِيٍ عَبَرِ مِ، مٌوَبَ بْشِ نَانِنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ دِبٌن فَدِ. ");
INSERT INTO susa_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عَلَمْن دِبِلَتَيِمَ. ");
INSERT INTO susa_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ عَبَرِ مِ فٍيَيٍ يِرٍ، نٍبٌ فٍيَ يَتَفِ. ");
INSERT INTO susa_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","عٍ تٌ كٍلِ مّننِ، عٍ نَشَ سِفَ مٌوَبَ قِيلِ مَ، يُرُدّن شُرٍ دّ رَ، يٍرِكٌ تَا يَتَفِ. ");
INSERT INTO susa_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","عٍ نَشَ يٌنكِن يُرُدّن شُرٍ دّ رَ، بٍتِ يٍسِمٌتِ نُن عَبٍلِ سِتِمِ لٌنفٌرِ مٌوَبَ قِيلِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ مٌوَبَ قِيلِ مَ، يُرُدّن شُرٍ دّ رَ، يٍرِكٌ تَا يَتَفِ، ");
INSERT INTO susa_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، ‹وٌ نَ يُرُدّن شُرٍ فِرِ تّمُي نَشّ سٌقٍ رَ كَنَان بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","وٌ مّننِكَيٍ بِرِن قَشَ. وٌ شَ عٍ شَ كُيٍ بِرِن كَنَ، نَشٍيٍ مَسٌلِشِ فّمّ رَ، نَشٍيٍ يَءِلَنشِ وُرٍ رَشُنُشِ رَ. وٌ شَ عٍ شَ بَتُدٍيٍ قَن كَنَ. ");
INSERT INTO susa_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","وٌ شَ نَ بْشِ سُشُ، وٌ قَ سَبَتِ نَا. ﭑ بَرَ نَ بْشِ قِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","نَ بْشِ عِتَشُنمَ وٌ مَ عَلَتَلَ شَ مَرَفِرِ كّحَ نَن مَ عَ شَبِلّ كِ مَ. نَشٍيٍ بْنسْي شَ مِشِيٍ نَ وُيَ، عٍ شَ بْشِ بٍلٍبٍلٍ سْتْ. نَشٍيٍ بْنسْي شَ مِشِيٍ مُ وُيَ، عٍ شَ بْشِ شَ شُرُن. عَلَتَلَ عَ رَفِرِ مَ كَنكَن نَشَن سْتْمَ عَ بْنسْي كِ مَ. ");
INSERT INTO susa_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","كْنْ شَ وٌ مُ مّننِكَيٍ قَشَ، عٍ قَمَ مَنِيَدٍ حٌوفٍ نَن نَ نَشَن مِشِ يَ تْورْ مَ، شَ نَ مُ عَ رَ تُنبٍيٍ نَشٍيٍ مِشِ قَرِ مَسْشْمَ. عٍ قِندِ مَ نّ وٌ يَشُييٍ رَ وٌ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","نَ تّمُي، ﭑ عٍ شَ يُنُبِ سَرٍ دْشْمَ وٌ تَن نَن مَ.›» ");
INSERT INTO susa_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«عَ مَسٍن عِسِرَيِلَكَيٍ بّ، ‹وٌ نَ سِفَ كَنَان بْشِ مَ، ﭑ نَشَن قِشِ وٌ مَ كّ رَ، عَ نَانِنيِيٍ نَن يِ كِ؛ ");
INSERT INTO susa_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","يِرٍقَنيِ مَبِرِ، وٌ شَ بْشِ نَانِنيِ سَ قْلْمَ سِنِ فبٍنفبٍرٍنيِ نَن مَ، عٍدٌن بْشِ مَبِرِ. نَ نَانِنيِ سَ قْلْمَ قْشْي بَا نَن مَ سٌفٍتٍدٍ مَبِرِ، ");
INSERT INTO susa_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","عَ سَ عَ كْنكْرْن تَلِ تٍدٍ يِرٍقَنيِ مَبِرِ، عَ عَ شُن سَ سِنِ، عَ دَنفِ كَدٍ سِ بَرِنٍيَ يِرٍقَنيِ مَبِرِ، عَ سِفَ شَسَرِ عَدَرِ مَبِرِ، عَ سَ عَسِمٌن لِ. ");
INSERT INTO susa_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","عَ سَ كٍلِ عَسِمٌن، عَ عَ كْنكْرْن هَن مِسِرَ دَبٌنيِ كُي، عَ قَ سَ مِنِ بَا شُنفبٍ مَ.›» ");
INSERT INTO susa_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","«عَ سٌفٍفٌرٌدٍ نَانِنيِ قِندِ مَ بَا شُنفبٍ نَن نَ.» ");
INSERT INTO susa_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","«عَ كْولَ نَانِنيِ سَ قْلْمَ بَا شُنفبٍ نَن مَ، هَن عَ قَ دْشْ هٌرٌ فٍيَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","كٍلِقٍ رَ هٌرٌ فٍيَ مَ، وٌ شَ نَانِنيِ سِفَمَ نَ كِ نّ هَن شَمَتَ سٌدٍ دّ رَ، عَ سَ دْشْ سٍدَدٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","عَ نَ كٍلِ مّننِ، عَ سِفَمَ سِقِرٌن مَبِرِ نّ هَن عَ سَ مِنِ شَسَرِ عٍنَن مَ. وٌ شَ بْشِ نَانِنيِ نَن نَ كِ كْولَ مَبِرِ.» ");
INSERT INTO susa_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","«عَ سٌفٍتٍدٍ، وٌ شَ نَانِنيِ سَ كٍلِمَ شَسَرِ عٍنَن نَن مَ، عَ سِفَ هَن سٍيقَمِ. ");
INSERT INTO susa_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","عَ كٍلِ مّننِ، عَ سِفَ رِبِلَ، عَيِن سٌفٍتٍدٍ بِرِ، عَ مَن سِفَ، عَ سَ دِن تٍنتٍنيِيٍ رَ كِنٍرٍتِ بَا سٌفٍتٍدٍ بِرِ رَ، ");
INSERT INTO susa_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","عَ سَ مِنِ يُرُدّن شُرٍ مَ، عَ قَ سَ عَ رَحْن قْشْي بَا مَ. وٌ شَ بْشِ نَانِنيِيٍ نَن نَ كِ.» ");
INSERT INTO susa_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","مُنسَ نَشَ نَ يَامَرِ رَدَنفِ عِسِرَيِلَكَيٍ مَ، عَ قَلَقٍ رَ، «بْشِ نَن يِ كِ، نَشَن عِتَشُنمَ عِسِرَيِلَ بْنسْي سٌلٌمَنَانِ نُن عَ تَفِ مَ، عَلْ عَلَتَلَ عَ رَفِرِشِ كَنكَن مَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","رُبٍن بْنسْي، فَدِ بْنسْي، نُن مَنَسِ بْنسْي سّيتِ بَرَ عٍ فبٍ كّ سْتْ عٍ دٍنبَيَ كِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","يُرُدّن نَاكِرِ مَ، يٍرِكٌ يَ تَفِ سٌفٍتٍدٍ بِرِ رَ.» ");
INSERT INTO susa_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«عٍلٍيَسَرِ سّرّشّدُبّ نُن نُنُ شَ دِ شّمّ يٌسُوٍ نَن يِ بْشِ عِتَشُنمَ. ");
INSERT INTO susa_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","وٌ شَ يَرٍرَتِ كٍرٍن كٍرٍن سُفَندِ بْنسْي بِرِن كُي، نَشٍيٍ لَنمَ يِ بْشِ عِتَشُنيِ. ");
INSERT INTO susa_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","عٍ شِلِيٍ نَن يِ كِ؛ يُدَ بْنسْي، يٍقُنٍ شَ دِ شّمّ كَلٍبِ. ");
INSERT INTO susa_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","سِمٍيْن بْنسْي، عَمِشُدِ شَ دِ شّمّ سٍمُوٍلِ. ");
INSERT INTO susa_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","بُنيَمِن بْنسْي، كِسِلٌن شَ دِ شّمّ عٍلِدَدَ ");
INSERT INTO susa_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","دَنَ بْنسْي، يٌفٌلِ شَ دِ شّمّ بُوكِ. ");
INSERT INTO susa_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","يُسُقُ شَ دِ مَنَسِ بْنسْي، عٍقٌدٌ شَ دِ شّمّ شَنِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","عٍقِرَ مِ بْنسْي، سِقِتَن شَ دِ شّمّ كٍمُوٍلِ. ");
INSERT INTO susa_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","سَبُلٌن بْنسْي، ثَرَنَكِ شَ دِ شّمّ عٍلِسَقَن. ");
INSERT INTO susa_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","عِسَكَرِ بْنسْي، عَسَنَ شَ دِ شّمّ ثَلَتِيّلِ. ");
INSERT INTO susa_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","عَسٍرِ بْنسْي، سٍلٌمِ شَ دِ شّمّ عَشِهُدِ. ");
INSERT INTO susa_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","نَقَتَلِ بْنسْي، عَمِشُدِ شَ دِ شّمّ ثٍدَهٍلِ.» ");
INSERT INTO susa_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","عَلَتَلَ نٍيٍ نَن سُفَندِ كَنَان بْشِ عِتَشُنقٍ رَ عِسِرَيِلَكَيٍ مَ. ");
INSERT INTO susa_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، مٌوَبَ قِيلِ مَ، يُرُدّن شُرٍ قّ مَ، يٍرِكٌ يَ تَفِ، ");
INSERT INTO susa_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ شَ تَا ندٍيٍ نُن عٍ رَبِلِنيِيٍ سُفَندِ عٍ شَ بْشِ كُي، عٍ نَشٍيٍ قِمَ لٍوِ بْنسْي مَ، عٍ سَبَتِمَ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","لٍوِ بْنسْي سَبَتِمَ نَ تَايٍ نَن كُي، عٍ شَ شُرُ سٍيٍ لُمَ نَ رَبِلِنيِيٍ. ");
INSERT INTO susa_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","نَ تَا رَبِلِنيِيٍ شَ فبٌيَ سِفَمَ نّ هَن نْنفْن وُلُ كٍرٍن نَ تَا سّيتِ نَانِ بِرِن مَ، ");
INSERT INTO susa_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","كٍلِقٍ تَا تّتّ مَ سِفَقٍ نْنفْن وُلُ قِرِن عَ سٌفٍتٍدٍ بِرِ، عَ سٌفٍفٌرٌدٍ بِرِ، عَ كْولَ مَ، نُن عَ يِرٍقَنيِ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«نَ تَا تٌنفٌ نَانِ نُن سٌلٌمَسَشَن يَ مَ، وٌ شَ تَا سٍننِ سُفَندِ نَشٍيٍ قِندِ مَ مَكَنتَدٍيٍ رَ مِشِيٍ بّ نَشٍيٍ بَرَ قَشّ تِ عٍ مُ عَ حَنِفٍشِ. ");
INSERT INTO susa_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","وٌ شَ نَ تَا تٌنفٌ نَانِ نُن سٌلٌمَسَشَن نُن عٍ رَبِلِنيِيٍ قِ لٍوِ بْنسْي مَ. ");
INSERT INTO susa_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","بْنسْي نَشٍيٍ شَ تَايٍ وُيَ، عٍ شَ تَا فبٍفبٍ قِ. بْنسْي نَشٍيٍ شَ تَايٍ مُ وُيَ، عٍ شَ تَا دٌندٌرٌنتِ قِ لٍوِ بْنسْي مَ.» ");
INSERT INTO susa_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","عَلَتَلَ نَشَ عَ مَسٍن مُنسَ بّ، ");
INSERT INTO susa_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«عَ قَلَ عِسِرَيِلَكَيٍ بّ، عٍ نَ يُرُدّن شُرٍ عِفِرِ سٌقٍ رَ كَنَان بْشِ مَ، ");
INSERT INTO susa_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","عٍ شَ تَايٍ سُفَندِ، نَشٍيٍ قِندِ مَ مَكَنتَدٍيٍ رَ مِشِيٍ بّ نَشٍيٍ بَرَ قَشّ تِ عٍ مُ عَ حَنِفٍشِ. ");
INSERT INTO susa_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","نَ تَايٍ نَن قِندِ مَ مَكَنتَدٍيٍ رَ نَ مِشِيٍ بّ، هَن كِيتِسَيٍ عٍ مَكِيتِمَ تّمُي نَشّ. نَ كُي عٍ شَ رَتَنفَ مِشِيٍ مَ نَشٍيٍ وَ مَ عٍ فبٍحْشْقٍ، نَشٍيٍ وَ مَ عٍ قَشَقٍ كٍرٍن نَ. ");
INSERT INTO susa_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","وٌ شَ تَا سٍننِ سُفَندِ نَ وَلِ شَ قٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","سَشَن يُرُدّن نَاكِرِ مَ، سَشَن كَنَان بْشِ مَ. نَ تَايٍ نَن قِندِ مَ وٌ مَكَنتَدٍيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","مِشِ يٌ مِشِ، عَ قِندِ عِسِرَيِلَكَ رَ، عَ قِندِ شْحّ رَ، عَ قِندِ دَنفِ مِشِ رَ، شَ نَشَن يٌ سَ مِشِ ندٍ قَشَ عَ مُ عَ حَنِفٍشِ، نَ كَنيِ نْمَ عَ نِي رَتَنفَدٍ نَ تَا سٍننِيٍ ندٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«كْنْ شَ مِشِ سَ مِشِ بْنبْ وُرٍ رَ هَن عَ قَشَ، نِي بَ نَن عَ رَ. عَ لَن نّ، عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","شَ مِشِ سَ مِشِ بْنبْ فّمّ نَن نَ هَن عَ قَشَ، نِي بَ نَن عَ رَ. عَ لَن نّ، عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","شَ مِشِ سَ مِشِ بْنبْ وُرِ نَن نَ هَن عَ قَشَ، نِي بَ نَن عَ رَ. عَ لَن نّ، عَ قَن شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","فبٍحْشْي شَ نَ قَشّتِ قَشَ عَ عَ سُشُشِ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","شَ مِشِ ندٍ سَ عَ بٌورٍ رَدِن يّ مَرَحَاشُي مَ، شَ نَ مُ، عَ حَنِفٍ عَ شَ عَ فْنْ سٍ ندٍ رَ، عَ قَشَ، قَشّتِ نَن عَ رَ. ");
INSERT INTO susa_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","شَ مِشِ ندٍ سَ عَ بٌورٍ دِن عَ بّلّشّ رَ يَشُيَ رَ، عَ قَشَ، قَشّتِ نَن عَ رَ. عَ لَن نّ، عَ قَن شَ قَشَ. فبٍحْشْي شَ نَ قَشّتِ قَشَ عَ عَ سُشُشِ تّمُي نَشّ.» ");
INSERT INTO susa_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«كْنْ شَ مِشِ ندٍ سَ عَ بٌورٍ رَدِن يّ حَنِفٍتَرٍحَ كُي، شْنّ مُ نَ، شَ نَ مُ عَ سٍ ندٍ وٌلِ عَ مَ حَنِفٍتَرٍحَ كُي، ");
INSERT INTO susa_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","شَ نَ مُ عَ عَ فْنْ فّمّ رَ حَنِفٍتَرٍحَ كُي، عَ قَ قَشَ، كْنْ شْنّ نُن يَشُيَ مُ نَ عَ كُي، ");
INSERT INTO susa_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","حَمَ شَ عَ مَكِيتِ يِ سّرِيّ رَ فبٍحْشْي شَ قٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","حَمَ شَ عَ بَ فبٍحْشْي يِ رَ، عَ عَ رَ سٌ مَكَنتَدٍ كُي. عَ شَ لُ مّننِ هَن سّرّشّدُبّ كُنتِفِ لَاشِرَ مَ تّمُي نَشّ، عَلَتَلَ نَشَن سُفَندِشِ. ");
INSERT INTO susa_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","كْنْ شَ نَ كَنيِ سَ مِنِ مَكَنتَدٍ قَرِ مَ، عَ نُ بَرَ سٌ دّننَشّ، ");
INSERT INTO susa_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","فبٍحْشْي قَ عَ تٌ، عَ قَشَ، فبٍحْشْي مُ قِندِ مَ قَشّتِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","مِشِ نَشَن نِي بَمَ حَنِفٍتَرٍحَ كُي، عَ شَ لُ مَكَنتَدٍ هَن سّرّشّدُبّ كُنتِفِ لَاشِرَ مَ تّمُي نَشّ. سّرّشّدُبّ كُنتِفِ نَ لَاشِرَ تّمُي نَشّ، مِشِ نَشَن نِي بَشِ حَنِفٍتَرٍحَ كُي، عَ نْمَ فبِلٍندٍ عَ شْنيِ مَرَتَنفٍ كُي.» ");
INSERT INTO susa_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«سّرِيّ نَن يَ وٌ بْنسْي بّ يِرٍ بِرِن، تّمُي بِرِن. ");
INSERT INTO susa_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","قَشّتِ مُ لَن عَ شَ قَشَ سٍيدٍ كٍرٍن شُي مَ، قٌ سٍيدٍ وُيَشِ. ");
INSERT INTO susa_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","قَشّتِ مُ لَن عَ شُن شَ سَرَ، عَ شَ قَشَ. ");
INSERT INTO susa_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","مِشِ نَشَن قَشّ تِ حَنِفٍتَرٍحَ كُي، عَ مُ لَن عَ شُن شَ سَرَ عَلَكٌ عَ شَ فبِلٍن عَ شْنيِ بٍينُن سّرّشّدُبّ كُنتِفِ لَاشِرَ مَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","وٌ مُ لَن وٌ شَ بْشِ قِندِ بْشِ سّنِيّنتَرٍ رَ. وُلِ رَ مِنِقٍ نَ نَن نَبَمَ. قَشّتِ وُلِ فبَنسَن نَن قِندِ مَ بْشِ شُنسَرٍ رَ. ");
INSERT INTO susa_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","وٌ نَشَ وٌ شْنيِ قِندِ يِرٍ سّنِيّنتَرٍ رَ. ﭑ تَن عَلَتَلَ سَبَتِشِ وٌ تَن عِسِرَيِلَكَيٍ يَ مَ.» ");
INSERT INTO susa_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","دٍنبَيَ شُنيِ نَشٍيٍ نُ نَ فَلَدِ شَبِلّ يَ مَ، مَكِرِ شَ دِيٍ، مَنَسِ شَ مَمَدِيٍ، يُسُقُ شَبِلّيٍ، نٍيٍ نَشَ سِفَ مُنسَ نُن عِسِرَيِلَ دٍنبَيَ شُنيِيٍ يِرٍ. ");
INSERT INTO susa_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","عٍ نَشَ عَ قَلَ مُنسَ بّ، «عَلَتَلَ بَرَ عَ يَمَرِ عِ تَن ﭑ مَرِفِ، عِ شَ يِ بْشِ عِتَشُن عِسِرَيِلَ دِيٍ مَ عَلَتَلَ شَ مَرَفِرِ كّحَ مَ، عَ شَ قِندِ عٍ كّ رَ. عَلَتَلَ مَن بَرَ عِ يَمَرِ عِ شَ مُشُ تَارَ سٍلٌقٍشَدِ شَ هَرِفٍ سٌ عَ شَ دِ فِنّيٍ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","كْنْ شَ نَ دِ فِنّيٍ سَ دْشْ بْنسْي فبّتّ شّمّيٍ شْن، عٍ كّ بَمَ نّ مُشُ بْنسْي كّ رَ، عَ سَ عٍ شَ شّمّيٍ بْنسْييٍ كّ شُن مَ. نَ كُي ندٍ بَمَ نّ مُشُ كّ رَ، نَشَن قِشِ مُشُ بْنسْي مَ مَرَفِرِ كُي. ");
INSERT INTO susa_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","شْرّيَ حّ نَ عَ لِ، عٍ كّ بَمَ نّ مُشُ بٍنبَيٍ كّ رَ، عَ سَ عٍ شَ شّمّيٍ بٍنبَيٍ كّ شُن مَ.» ");
INSERT INTO susa_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ رَدَنفِ عِسِرَيِلَكَيٍ مَ، عَ قَلَقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","«يُسُقُ بْنسْي، وٌ نْندِ. عَلَتَلَ شَ يَامَرِ نَن يَ سٍلٌقٍشَدِ شَ دِ فِنّيٍ بّ. عٍ شَ دْشْ شّمّ شْن نَشَن نَ شَبِلّ ندٍ كُي عٍ بَبَ بْنسْي يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","سٍسٍ مُ بَمَ عِسِرَيِلَ بْنسْي ندٍ كّ رَ، عَ قِندِ بْنسْي فبّتّ كّ رَ. بِرِن عَ بٍنبَ كّ نَن شُن مَكَنتَمَ. ");
INSERT INTO susa_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","دِ فِنّ كّ كَنيِ شَ دْشْ شّمّ شْن نَشَن نَ شَبِلّ ندٍ كُي عَ بَبَ بْنسْي يَ مَ. ");
INSERT INTO susa_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","سٍسٍ مُ بَمَ عِسِرَيِلَ بْنسْي ندٍ كّ رَ، عَ قِندِ بْنسْي فبّتّ كّ رَ. بِرِن عَ بٍنبَ كّ نَن شُن مَكَنتَمَ.» ");
INSERT INTO susa_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","سٍلٌقٍشَدِ شَ دِ فِنّيٍ نَشَ عَلَتَلَ شَ يَامَرِ سُشُ عَلْ مُنسَ عَ قَلَ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","عٍ شِلِيٍ نَن يَ؛ مَشَلَ، تِرِ سَ، شٌفَلَ، مِلِكَ، نُن نٌوَ. عٍ بِرِن نَشَ دْشْ عٍ دّيشْيٍ شْن مَ. ");
INSERT INTO susa_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","عٍ دْشْ مَنَسِ شَ دِ شَبِلّيٍ نَن شْن مَ. نَ كُي عٍ كّ نَشَ لُ عٍ بٍنبَ يُسُقُ بْنسْي. ");
INSERT INTO susa_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","عَلَتَلَ شَ سّرِيّ نُن يَامَرِيٍ نَن نَ كِ عَ نَشٍيٍ قِشِ مُنسَ مَ، كَتَرَبِ عِسِرَيِلَ مَ، عٍ نُ نَ مٌوَبَ قِيلِ مَ تّمُي نَشّ، يُرُدّن شُرٍ قّ مَ، يٍرِكٌ يَ تَفِ.");
INSERT INTO susa_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","وْيّنيِيٍ نَن يِ كِ، عَننَبِ مُنسَ نَشَن مَسٍن عِسِرَيِلَكَيٍ بِرِن بّ. نَ تّمُي عَ نُ نَ يُرُدّن سٌفٍتٍدٍ بِرِ رَ، فبٍنفبٍرٍنيِ مَ نَشَن نَ عَرَبَ، سُقِ يَ تَفِ، ثَرَن، تٌقٍلِ، لَبَن، شَسٍرٌتِ، نُن دِ سَهَبِ لٌنفٌرِ. ");
INSERT INTO susa_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","كٍلِ شٌرٍبٍ فٍيَ هَن كَدٍ سِ بَرِنٍيَ كِرَ رَ مِنِقٍ رَ سٍيِرِ فٍيَيٍ بِرِ، شِ قُ نُن كٍرٍن حّرّ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","عٍ شَ كٍلِ حّ تٌنفٌ نَانِ ندٍ مَ مِسِرَ، عَ كِكٍ قُ نُن كٍرٍن ندٍ، شِ سِنفٍ، عَننَبِ مُنسَ نَشَ عَلَتَلَ شَ يَامَرِ مَسٍن عِسِرَيِلَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","نَ تّمُي عَننَبِ مُنسَ نُ بَرَ شُتُ سْتْ سِشْن مَ، عَمٌرِ مَنفّ، نَشَن نُ سَبَتِشِ شّسِبْن، عَ نُن عٌفٌ، بَسَن مَنفّ، نَشَن نُ سَبَتِشِ عَسَتَرٌتِ نُن عٍدٍرٍيِ. ");
INSERT INTO susa_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","يُرُدّن سٌفٍتٍدٍ بِرِ مٌوَبَ بْشِ مَ، عَننَبِ مُنسَ نَشَ عَلَ شَ سّرِيّ تَفِ رَبَ عٍ بّ. نَ وْيّنيِ نَن يِ كِ. ");
INSERT INTO susa_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«وٌن نُ نَ شٌرٍبٍ فٍيَ يِرٍ تّمُي نَشّ، وٌن مَرِفِ عَلَتَلَ يِ نَن مَسٍن وٌن بّ، ‹وٌ بَرَ بُ يِ فٍيَ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","وٌ تِ كِرَ شْن مَ قَ. وٌ شَ سِفَ فٍيَ مَ عَمٌرِكَيٍ نَ دّننَشّ، نُن نَ لٌنفٌرِ بِرِن، عَرَبَ بْشِ مَ، فٍيَ بِرِ، سٍقٍلَ نُن نٍفٍوِ بِرِ، بَا دّ رَ، هَن كَنَان بْشِ مَ، هَن لِبَن سَ دْشْ عٍقِرَتِ شُرٍ بٍلٍبٍلٍ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","وٌ شَ نَ بْشِ مَتٌ، ﭑ نَشَن قِشِ وٌ مَ. وٌ سِفَ، وٌ شَ نَ تٌنفٌ، بَرِ مَ ﭑ تَن عَلَتَلَ يَتِ نَن نَ بْشِ لَايِدِ تٌنفٌشِ وٌ بٍنبَيٍ بّ، عِبُرَهِمَ، عِسِيَفَ، عَ نُن يَشُبَ، عَ نُن عٍ بْنسْي بِرِن هَلِ عٍ دَنفِ شَنبِ.›» ");
INSERT INTO susa_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«نَ تّمُي ﭑ يِ نَن قَلَ وٌ بّ، ‹ﭑ تَن كٍرٍن مُ نْمَ وٌ شَ قٍ نْدٍ. ");
INSERT INTO susa_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","وٌ مَرِفِ عَلَتَلَ بَرَ وٌ رَفبٌ يّ. يَكْسِ وٌ بَرَ فبٌ يّ عَلْ تُنبُييٍ نَشٍيٍ نَ كٌورٍ مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","وٌ بٍنبَيٍ مَرِفِ عَلَتَلَ شَ وٌ رَوُيَ هَن. عَ شَ بَرَكَ سَ وٌ شَ قٍ عَلْ عَ مَسٍن كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ﭑ تَن كٍرٍن نْمَ وٌ شَ كَلَمُييٍ مَكِيتِدٍ دِ؟ ");
INSERT INTO susa_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","وٌ كُنتِفِ لْننِلَيٍ سُفَندِ، نَشٍيٍ كٌلٌنشِ وٌ بْنسْييٍ يَ مَ. ﭑ نٍيٍ نَن قِندِ مَ حَمَ يَرٍرَتِيٍ رَ.› ");
INSERT INTO susa_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","وٌ نَشَ ﭑ يَابِ، عَ ﭑ مَ مَحْشُنيِ، عَ مَحْشُن قَنيِ نَ عَ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ﭑ نَشَ وٌ شَ يَرٍرَتِيٍ تٌنفٌ، وٌ شَ كُنتِفِ لْننِلَ نَشٍيٍ كٌلٌنشِ وٌ بْنسْي يَ مَ. ﭑ نَشَ عٍ قِندِ مِشِ وُلُ، مِشِ كّمّ، مِشِ تٌنفٌ سُولِ، مِشِ قُ شُنيِيٍ رَ. ﭑ نَشَ عٍ قِندِ يَرٍرَتِيٍ رَ وٌ بْنسْييٍ يَ مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","نَ تّمُي ﭑ نَشَ يَامَرِ سٌ وٌ مَكِيتِمَيٍ يِ رَ. ﭑ نَشّ، ‹وٌ شَ وٌ تُلِ مَتِ وٌ بَرِبٌورٍيٍ رَ. وٌ شَ بِرِن مَكِيتِ سّرِيّ كّحَ مَ، وٌ نفَشَكٍرٍنيِيٍ تَفِ نُن عٍ تَن نُن شْحّيٍ تَفِ. ");
INSERT INTO susa_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","وٌ نَشَ تِ مِشِ يٌ شْن مَ كِيتِ سَدٍ. وٌ نَشَ شُرُنيِ نُن فبٌي مَتٌ. وٌ نَشَ فَاشُ مِشِ يٌ يَ رَ، بَرِ مَ كِيتِسَ نَ عَلَ نَن نَ. شَ كِيتِ سَ شْرْشْ وٌ بّ هَن، وٌ قَ عَ رَ ﭑ شْن، ﭑ تَن كِيتِ سَمَ.› ");
INSERT INTO susa_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","نَ كِ ﭑ بَرَ قٍ بِرِن مَسٍن وٌ بّ، عَ لَن وٌ شَ نَشَن نَبَ.» ");
INSERT INTO susa_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«نَ تٌ دَنفِ، وٌن نَشَ كٍلِ شٌرٍبٍ فٍيَ، وٌن مِنِ فبٍنفبٍرٍنيِ مَفَاشُشِ رَ وٌ بَرَ دّننَشّ تٌ. وٌن نَشَ بِرَ كِرَ قْشْ رَ نَشَن سِفَمَ عَمٌرِ فٍيَيٍ بِرِ رَ، عَلْ وٌن مَرِفِ عَلَتَلَ عَ مَسٍن وٌن بّ كِ نَشّ. وٌن نَشَ سٌ كَدٍ سِ بَرِنٍيَ. ");
INSERT INTO susa_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ﭑ نَشَ عَ قَلَ وٌ بّ، ‹وٌ بَرَ عَمٌرِ فٍيَيٍ لِ، وٌن مَرِفِ عَلَتَلَ دّننَشّ قِشِ وٌن مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","وٌ عَ مَتٌ، وٌ مَرِفِ عَلَتَلَ بَرَ يِ بْشِ تِ وٌن يَ عِ. وٌ سِفَ، وٌ شَ نَ تٌنفٌ عَلْ وٌ بٍنبَيٍ مَرِفِ عَلَتَلَ عَ قَلَشِ وٌ بّ كِ نَشّ. وٌ نَشَ فَاشُ، وٌ شَ لِمَنِيَ.›» ");
INSERT INTO susa_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","«نَ تّمُي، وٌ بِرِن نَشَ قَ ﭑ يِرٍ، وٌ قَ عَ قَلَ ﭑ بّ، ‹وٌن شَ مِشِيٍ شّي، عٍ شَ سِفَ يِ بْشِ مَ، عٍ شَ نَا رَبّن. نَ شَ قِندِ نٍيٍ قَن مَ وَلِ رَ، عَلَكٌ وٌن شَ عَ كٌلٌن وٌن لَن وٌن شَ وٌن حّرّ كِرَ نَشَن شْن عَ نُن وٌن سِفَمَ تَا نَشٍيٍ.› ");
INSERT INTO susa_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","وٌ شَ مَحْشُنيِ نَشَ قِندِ ﭑ بّ قٍ قَنيِ رَ. نَ نَن عَ تٌ ﭑ نَشَ شّمّ مِشِ قُ نُن قِرِن مَيٍفٍتِ وٌ يَ مَ، وٌ بْنسْي كٍرٍن كٍرٍن مَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","عٍ نَشَ سِفَ فٍيَيٍ بِرِ رَ هَن عٍ نَشَ فُلُنبَ لِ نَشَن شِلِ عٍسٍكٌلِ. عٍ نَشَ نَا رَبّن. ");
INSERT INTO susa_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","عٍ نَشَ يِ بْشِ بٌفِسٍيٍ بَ، عٍ قَ عٍ مَسٍن وٌن بّ. عٍ نَشَ دّنتّفّ سَ وٌن بّ يِ كِ، ‹وٌن مَرِفِ عَلَتَلَ بْشِ قَنيِ نَن قِشِ وٌن مَ.› ");
INSERT INTO susa_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","كْنْ وٌ مُ تِن تٍدٍ، وٌ نَشَ تٌندِ وٌ مَرِفِ عَلَتَلَ شَ يَامَرِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","وٌ عَ مَشْرْشْ نّ وٌ شَ كِرِ بَنشِيٍ كُي. وٌ نَشَ عَ قَلَ، ‹شْننَنتٍيَ نَ شّيشِ، عَلَتَلَ وٌن تٌنفٌشِ مِسِرَ بْشِ مَ. عَ وَ مَ وٌن سٌقٍ عَمٌرِكَيٍ نَن يِ رَ عَلَكٌ عٍ شَ وٌن هَلَكِ. ");
INSERT INTO susa_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","وٌن سِفَمَ مِندٍن؟ لِمَنِيَ مُ نَ وٌن بّ، بَرِ مَ وٌن نفَشَكٍرٍنيِيٍ بَرَ عَ قَلَ وٌن بّ عَ مّننِكَيٍ سّنبّ فبٌ. عٍ مَن فبَنفبَلَن وٌن بّ، نُن نَ تَايٍ شَ قٍ مَشْرْشْ. تّتّ نَشَن نَا رَبِلِنشِ، عَ عِتٍ هَن. مُشُ عَنَكِ بْنسْييٍ يَتِ تٌ نّ.›» ");
INSERT INTO susa_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","«ﭑ نَشَ عَ قَلَ وٌ بّ، ‹وٌ نَشَ سِيكّ. وٌ نَشَ فَاشُ عٍ يَ رَ! ");
INSERT INTO susa_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","وٌ مَرِفِ عَلَتَلَ نَشَن حّرّ مَ وٌ يَ رَ، عَ فٍرٍ سٌمَ نّ وٌ بّ عَلْ عَ عَ رَبَشِ وٌ يَ شْرِ كِ نَشّ مِسِرَ بْشِ مَ هَن فبٍنفبٍرٍنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","وٌ مَن بَرَ عَ تٌ، وٌ مَرِفِ عَلَتَلَ قَشِ نّ وٌ رَ عَلْ شّمّ عَ شَ دِ شَنِنمَ كِ نَشّ، وٌ حّرّشِ كِرَ نَشَن بِرِن نَ هَن وٌ نَشَ قَ بٍ لِ. ");
INSERT INTO susa_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","كْنْ نَ بِرِن كُي، وٌ مُ نُ لَشِ وٌ مَرِفِ عَلَتَلَ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","عَ تَن نَن تِ وٌ يَ رَ، عَ يِرٍ قٍن وٌ بّ وٌ لُمَ دّننَشّ. كْي رَ عَ تَن نَن نُ كِرَ عِيَلَنمَ وٌ بّ تّ رَ. يَنيِ قَن نَ، عَ قِندِ نُشُي رَ، عَ تِ وٌ يَ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","عَلَتَلَ نَشَ وٌ شُرُتُشُرُتُ شُي مّ. عَ شَ شْنّ كُي، عَ نَشَ عَ رَكَلِ، ");
INSERT INTO susa_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«يِ مِشِ كٌبِ يٌ مُ سٌمَ يِ بْشِ قَنيِ مَ، ﭑ نَشَن لَايِدِشِ وٌ بَبَيٍ بّ ");
INSERT INTO susa_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","قٌ كَلٍبِ، يٍقُنٍ شَ دِ. عَ تَن عَ تٌمَ نّ. عَ بْشِ دّننَشّ حّرّشِ، نَ قِندِ مَ نّ عَ فبٍ نُن عَ بْنسْي فبٍ رَ، بَرِ مَ عَ بَرَ بِرَ ﭑ تَن عَلَتَلَ شَ كِرَ قْشْ رَ.»›» ");
INSERT INTO susa_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","«وٌ تَن شَ قٍ رَ عَلَتَلَ بَرَ شْنْ ﭑ قَن مَ. عَ نَشَ عَ مَسٍن، ‹عِ تَن يّتّ يَتِ مُ سٌمَ يِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","يٌسُوٍ، نُنُ شَ دِ، عِ مَلِمَ، نَن قَمَ سٌدٍ. لِمَنِيَ قِ عَ مَ، بَرِ مَ عَ تَن نَن تِمَ عِسِرَيِلَكَيٍ يَ رَ يِ بْشِ مَسْتْقٍ رَ، عَ شَ قِندِ عٍ كّ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","وٌ شَ دِيٍ، وٌ عَ قَلَشِ نَشٍيٍ بّ، عٍ قِندِ مَ فٍيلِمَنِيٍ رَ. عٍ تَن نَشَن مُ قٍ كٌبِ نُن قٍ قَنيِ تَفِ رَبَ كٌلٌنشِ، عٍ تَن نَن قَمَ سٌدٍ نَ بْشِ مَ. ﭑ قَمَ نَ بْشِ قِدٍ عٍ تَن نَن مَ. عَ قِندِ مَ عٍ تَن نَن فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","كْنْ وٌ تَن مَن شَ وٌ مَقِندِ فبِلٍنقٍ رَ فبٍنفبٍرٍنيِ بِرِ رَ، سِفَقٍ كَلٍ بَا مَبِرِ.›» ");
INSERT INTO susa_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","«وٌ نَشَ عَ يَابِ، ‹مُشُ بَرَ قِندِ يُنُبِتْي رَ عَلَتَلَ يَ عِ، كْنْ يَكْسِ مُشُ قَ وَ مَ سِفَقٍ فٍرٍ سٌدٍ نّ، عَلْ مُشُ مَرِفِ عَلَتَلَ مُشُ يَمَرِشِ عَ رَ كِ نَشّ.› كَنكَن نَشَ فٍرٍ سٌسٍ تٌنفٌ، بَرِ مَ وٌ عَ مَحْشُن نّ عَ يِ فٍيَ تَا مَسْتْقٍ عَ قِندِ مَ سْونّيَ رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","نَ نَن عَ تٌ عَلَتَلَ نَشَ عَ مَسٍن ﭑ بّ، ‹عَ قَلَ عٍ بّ، وٌ نَشَ سِفَ فٍرٍ سٌدٍ دٍ، بَرِ مَ ﭑ مُ نَ وٌ يَ مَ. وٌ نَشَ سِفَ دٍ، وٌ يَشُييٍ نَشَ قَ وٌ بْنبْ.› ");
INSERT INTO susa_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ﭑ يِ مَرَ سِ قِشِ نّ وٌ مَ، كْنْ وٌ مُ تِن وٌ تُلِ مَتِدٍ ﭑ نَ. وٌ نَشَ عَلَتَلَ شُي مَتَندِ، وٌ نَشَ تٍ يّتّ عِفبٌحَ كُي فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","نَ تّمُي عَمٌرِكَ نَشٍيٍ نُ سَبَتِشِ فٍيَ قَرِ عٍ نَشَ مِنِ وٌ فٍرٍدٍ عَلْ كُمِ دِنمَ مِشِ رَ كِ نَشّ. عٍ نَشَ وٌ بْنبْ كٍلِ سٍيِرِ هَن هٌرٌ مَ. ");
INSERT INTO susa_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","وٌ تٌ فبِلٍن، وٌ نَشَ وَ عَلَتَلَ يَ عِ، كْنْ عَلَتَلَ مُ عَ تُلِ مَتِ وٌ وَ شُي رَ. ");
INSERT INTO susa_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","وٌ مَن نَشَ لُ كَدٍ سِ، وٌ بُ نَا عَلْ وٌ سِنفٍ بُي نَشَن نَبَ.» ");
INSERT INTO susa_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","«نَ شَنبِ وٌن نَشَ فبِلٍن فبٍنفبٍرٍنيِ كِرَ سُشُ رَ سِفَقٍ كَلٍ بَا مَبِرِ، عَلْ عَلَتَلَ عَ مَسٍن ﭑ بّ كِ نَشّ. وٌن نَشَ شِ وُيَشِ رَبَ سٍيِرِ فٍيَيٍ رَبِلِنيِ.» ");
INSERT INTO susa_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","«عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ");
INSERT INTO susa_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‹وٌ بَرَ يِ فٍيَ مَبِلِن عَ فبٍ رَ. وٌ وٌ مَقِندِ سِفَقٍ رَ كْولَ مَ.› ");
INSERT INTO susa_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","عَ نَشَ عَ قَلَ ﭑ بّ ﭑ شَ يِ يَامَرِ قِ وٌ مَ. وٌ قَمَ دَنفِدٍ سٍيِرِ بْشِ سّيتِ مَ، وٌ نفَشَكٍرٍنيِيٍ نَ دّننَشّ، عٍسَيُ بْنسْي. عٍ قَمَ نّ فَاشُدٍ وٌ يَ رَ، كْنْ وٌ وٌ يّتّ مَسُشُ عٍ فٍرٍقٍ رَ، ");
INSERT INTO susa_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","بَرِ مَ ﭑ مُ سٍسٍ سٌمَ وٌ يِ رَ عٍ شَ بْشِ مَ، هَلِ سَنيِ تِدٍ. ﭑ بَرَ سٍيِرِ فٍيَيٍ قِ عٍسَيُ مَ. ");
INSERT INTO susa_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","وٌ نَ وَ دٌنسٍ نُن يٍ نَشَن شْن قٌ وٌ عَ سَرَ عٍ مَ فبٍتِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","وٌ مَرِفِ عَلَتَلَ بَرَ بَرَكَ سَ وٌ وَلِ قْشِ. عَ بَرَ عَ حْشْ سَ وٌ شَ قٍ شْن مَ وٌ نُ يِ فبٍنفبٍرٍنيِ عِفِرِ مَ تّمُي نَشّ. يِ حّ تٌنفٌ نَانِ بُن مَ، وٌ بِرِن نَن نُ عَ رَ. سٍسٍ شَ قٍ مُ شْرْشْ وٌ مَ.» ");
INSERT INTO susa_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","«وٌن نَشَ دَنفِ وٌن نفَشَكٍرٍنيِيٍ رَ يِرٍ مَكُيٍ، عٍسَيُ بْنسْي نَشَن سَبَتِشِ سٍيِرِ بْشِ مَ. وٌن مَن نَشَ دَنفِ عَرَبَ، عٍلَتَ، عٍسِيٌن فٍبٍرِ كِرَ رَ يِرٍ مَكُيٍ. نَ شَنبِ وٌن نَشَ وٌن مَقِندِ، وٌن مٌوَبَ فبٍنفبٍرٍنيِ كِرَ سُشُ.» ");
INSERT INTO susa_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","«عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹وٌ نَشَ فٍرٍ فِرِ مٌوَبَكَيٍ مَ دٍ. وٌ نَشَ فٍرٍ تِ عٍ بّ دٍ، بَرِ مَ ﭑ مُ قَمَ سٍسٍ سٌدٍ وٌ يِ رَ عٍ شْنيِ. ﭑ بَرَ عَرِ بْشِ قِ لٌتِ مَ.›» ");
INSERT INTO susa_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","سِنفٍ رَ، عٍمِكَيٍ نَن نُ نَ عَرِ بْشِ مَ. حَمَ فبَنفبَلَنيِ نَن نُ عٍ رَ. عٍ وُيَ، عٍ قَن كُيَ عَلْ عَنَكِ بْنسْييٍ. ");
INSERT INTO susa_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","مِشِ ندٍيٍ نَشَ عٍ مَحْشُن رٍقَكَيٍ رَ، نَشٍيٍ مَنِيَ عَنَكِ بْنسْييٍ رَ، كْنْ مٌوَبَكَيٍ نُ عٍ شِلِمَ نّ عٍمِكَيٍ. ");
INSERT INTO susa_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","نَشَن قِندِ سٍيِرِ بْشِ رَ، شٌرِكَيٍ نَن سِنفٍ نُ نَ نَا. عٍسَيُ بْنسْي نَشَ عٍ مَسُشُ، عٍ عٍ قَشَ. عٍ تَن نَشَ سَبَتِ نَا. عِسِرَيِلَكَيٍ قَن قَمَ نَ مْولِ نَن نَبَدٍ بْشِ مَ عَلَتَلَ نَ دّننَشّ قِ عٍ مَ. ");
INSERT INTO susa_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","«عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹يَكْسِ، وٌ كٍلِ، وٌ شَ سٍرٍدٍ شُرٍ عِفِرِ.›» وٌن نَشَ نَ رَبَ. ");
INSERT INTO susa_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","حّ تٌنفٌ سَشَن نُن سٌلٌمَسَشَن دَنفِ نّ كَبِ وٌن كٍلِ لْشْي كَدٍ سِ بَرِنٍيَ هَن وٌن فِرِ لْشْي سٍرٍدٍ شُرٍ رَ. نَ وَشَتِ كُي فٍرٍ سٌي نَشٍيٍ نُ نَ، نٍيٍ بِرِن نُ بَرَ قَشَ عَلْ عَلَتَلَ عَ رَكَلِ عٍ بّ كِ نَشّ. ");
INSERT INTO susa_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","عَلَتَلَ نَشَ عٍ تُشُنسَن هَن عٍ بِرِن نَشَ هَلَكِ. ");
INSERT INTO susa_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","نَ فٍرٍ سٌي تٌ بَرَ هَلَكِ حَمَ تَفِ، ");
INSERT INTO susa_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","عَلَتَلَ نَشَ عَ مَسٍن ﭑ بّ، ");
INSERT INTO susa_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«وٌ قَ سِفَقٍ دَنفِدٍ مٌوَبَ نَانِنيِ نَن نَ سِفَقٍ عَرِ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","وٌ مَكْرّ مَ نّ عَمٌنِكَيٍ رَ. وٌ نَشَ فٍرٍ فِرِ عٍ مَ دٍ. وٌ نَشَ عٍ قٍن فٍرٍ رَ، بَرِ مَ ﭑ مُ قَمَ سٍسٍ سٌدٍ وٌ يِ رَ عٍ شَ بْشِ مَ. ﭑ نَا قِشِ لٌتِ بْنسْي نَن مَ.» ");
INSERT INTO susa_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","عٍ نُ يِ بْشِ مَحْشُنشِ رٍقَكَيٍ نَن فبٍ رَ. كَبِ تّمُي شْننَكُيٍ رٍقَكَيٍ نَن نُ سَبَتِشِ نَا. عَمٌنِكَيٍ نُ عٍ شِلِمَ نّ سَمِسُمِكَيٍ. ");
INSERT INTO susa_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","حَمَ سّنبّمَ نَن نُ لَنشِ عٍ مَ، عٍ وُيَ، عٍ مَن فبَنفبَلَن عَلْ عَنَكِ بْنسْي. كْنْ عَلَتَلَ نَشَ عٍ هَلَكِ عَمٌنِكَيٍ سَابُي رَ. نَا نَشَ قِندِ عَمٌنِكَيٍ فبٍ رَ، عٍ نَشَ سَبَتِ نَا. ");
INSERT INTO susa_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","عَلَتَلَ نَشَ نَ مْولِ رَبَ عٍسَيُ شَ دِيٍ بّ نَشٍيٍ سَبَتِشِ سٍيِرِ بْشِ مَ. عَ تٌ نُ شٌرِكَيٍ هَلَكِمَ عٍ سَابُي رَ، نَا نَشَ قِندِ عٍ فبٍ رَ. عٍ سَبَتِشِ مّننِ نّ هَن يَكْسِ. ");
INSERT INTO susa_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","نَشَن قِندِ عَوِكَيٍ تَن نَ، نَشٍيٍ نُ سَبَتِشِ تَايٍ كُي هَن فَسَ، عٍ نَشَ هَلَكِ كَقَتٌرٌكَيٍ سَابُي رَ. نَا نَشَ قِندِ كَقَتٌرٌكَيٍ فبٍ رَ، عٍ نَشَ سَبَتِ نَا. كَقَتٌرٌكَيٍ نَشَ كٍلِ كَقَتٌرٌ. ");
INSERT INTO susa_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","عَلَتَلَ نَشَ عَ مَسٍن وٌن بّ، «وٌ تِ كِرَ شْن مَ، وٌ شَ عَرِنٌن شُرٍ عِفِرِ. وٌ عَ مَتٌ، ﭑ بَرَ سِشْن عَمٌرِكَ شّسِبْن مَنفّ سٌ وٌ يِ رَ نُن عَ شَ بْشِ. يَكْسِ، وٌ نَ تٌنفٌ، وٌ عٍ فٍرٍ. ");
INSERT INTO susa_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","تٌ ﭑ قَمَ نّ وٌ شَ قٍ مَفَاشُي لُدٍ دُنِحَ مِشِ بِرِن مَ. عٍ نَ وٌ شِلِ مّ، عٍ قَمَ نّ سّرّندٍ فبِرِفبِرِ.» ");
INSERT INTO susa_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","«ﭑ شّيرَ شّي نّ سِشْن، شّسِبْن مَنفّ مَ، كٍلِقٍ رَ كٍدٍ مٌتِ فبٍنفبٍرٍنيِ مَ. ﭑ نَشَ يِ بْحّسَ مَسٍنيِ تِ عَ بّ، ");
INSERT INTO susa_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‹مُشُ وَ مَ عِ شَ بْشِ عِفِرِقٍ. مُشُ مُشُ حّرّ مَ كِرَ نَن تُن شْن مَ. مُشُ مُ سِفَمَ كْولَ مَ، مُشُ مُ سِفَمَ يِرٍقَنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","مُشُ دٌنسٍ نُن يٍ نَشَن مِنمَ، مُشُ قَمَ نّ عَ بِرِن سَرٍ قِدٍ عِ مَ فبٍتِ رَ. عَ لُ كَنسَن مُشُ شَ دَنفِ عِ شَ بْشِ مَ مُشُ سَنيِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","عٍسَيُ بْنسْييٍ نَشٍيٍ سَبَتِشِ سٍيِرِ بْشِ مَ، نُن مٌوَبَكَيٍ نَشٍيٍ سَبَتِشِ عَرِ بْشِ مَ، نٍيٍ نَشَ مُشُ سَفٌي سَ دَنفِقٍ رَ عٍ شَ بْشِ مَ. عِ قَن شَ مُشُ سَفٌي سَ مُشُ شَ يُرُدّن شُرٍ عِفِرِ، مُشُ شَ سٌ بْشِ مَ مُشُ مَرِفِ عَلَتَلَ دّننَشّ قِشِ مُشُ مَ.› ");
INSERT INTO susa_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","كْنْ شّسِبْن مَنفّ سِشْن نَشَ تٌندِ مُشُ سَفٌي قِدٍ دَنفِقٍ رَ عَ شَ بْشِ مَ، بَرِ مَ وٌ مَرِفِ عَلَتَلَ نُ بَرَ عَ شَشِلِ رَشْرْشْ. عَ نَشَ عَ بْحّ بَلَن عَلَكٌ عَ شَ عَ سٌ وٌ يِ رَ عَلْ وٌ عَ تٌشِ كِ نَشّ تٌ.» ");
INSERT INTO susa_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","«عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹عِ بَرَ عَ تٌ، ﭑ بَرَ فّ سِشْن نُن عَ شَ بْشِ سٌدٍ عِ يِ رَ. نَا تٌنفٌ عِ فبٍ.› ");
INSERT INTO susa_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","سِشْن نُن عَ شَ حَمَ بِرِن نَشَ كٍلِ قَقٍ رَ وٌن فٍرٍدٍ يَهَسِ. ");
INSERT INTO susa_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","وٌن مَرِفِ عَلَتَلَ نَشَ عٍ سٌ وٌن يِ رَ شُننَكٍلِ كُي. وٌن نَشَ نْلَ سْتْ عٍ مَ، عَ تَن، عَ شَ دِيٍ عَ نُن عَ شَ حَمَ بِرِن. ");
INSERT INTO susa_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","وٌن نَشَ نَ تَايٍ بِرِن سُشُ، وٌن نَشَ عٍ بِرِن كَنَ. وٌن مَن نَشَ شّمّيٍ، نُن فِنّيٍ، عَ نُن دِ مّيٍ بِرِن قَشَ. وٌن مُ مِشِ يٌ لُ عَ حِحّ رَ، ");
INSERT INTO susa_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","كْنْ وٌن مُ سٍسٍ تٌنفٌ قٌ شُرُ سٍيٍ عَ نُن سٍ شْرِ نَشٍيٍ نُ نَ نَ تَايٍ كُي. ");
INSERT INTO susa_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","كٍلِ عَرٌوٍرِ عَرِنٌن شُرٍ دّ رَ، عَ نُن تَا نَشَن نَ فٍيَ لَنبَنيِ، سِفَقٍ رَ هَن فَلَدِ، تَا يٌ سّنبّ مُ دَنفِ وٌن نَ. وٌن مَرِفِ عَلَتَلَ نَشَ عَ بِرِن سٌ وٌن يِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","كْنْ وٌ مُ وٌ مَكْرّ عَمٌنِكَيٍ شَ بْشِ رَ، يَبٌكٌ شُرٍ دّ بِرِن، تَا نَشٍيٍ نَ فٍيَ قَرِ، عَ نُن عَلَتَلَ تْنيِ دْشْ وٌن مَ بْشِ نَشٍيٍ فٍرٍقٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","«وٌن نَشَ وٌن مَقِندِ تٍقٍ رَ بَسَن كِرَ شْن مَ. عٌفٌ، بَسَن مَنفّ، نَشَ مِنِ وٌن فٍرٍدٍ عٍدٍرِ، عَ تَن نُن عَ شَ حَمَ بِرِن. ");
INSERT INTO susa_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹عِ نَشَ فَاشُ عَ يَ رَ، بَرِ مَ ﭑ عَ نِيَمَ نّ عِ شُتُ سْتْ عَ تَن نُن عَ شَ حَمَ بِرِن مَ نُن عَ شَ بْشِ. عِ شَ نْ عَ رَ عَلْ عِ عَ رَبَشِ عَمٌرِكَيٍ شَ مَنفّ سِشْن نَ كِ نَشّ.› ");
INSERT INTO susa_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","وٌن مَرِفِ عَلَتَلَ نَشَ عَ نِيَ وٌن شَ شُتُ سْتْ بَسَن مَنفّ عٌفٌ نُن عَ شَ حَمَ بِرِن مَ. وٌن نَشَ عٍ بِرِن قَشَ، مِشِ يٌ مُ لُ. ");
INSERT INTO susa_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","نَ تّمُي وٌن نُ بَرَ عٍ شَ تَايٍ بِرِن سُشُ. نَ تَا يٌ مُ لُ وٌن مُ دّننَشّ سُشُ، تَا تٌنفٌ سٍننِ نَ عَ رَ نَشَن نَ عَرَفٌبٌ رَبِلِنيِ. نَ تَا بِرِن نُ نَ عٌفٌ شَ مَنفّيَ نَن بُن مَ بَسَن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","نَ تَايٍ بِرِن نُ رَبِلِنشِ تّتّ عِتٍشِيٍ نَن نَ، نُن نَادّ مَبَلَنشِيٍ رَ. تَا فبٍفبٍ قَن نُ نَ تّتّ مُ نُ نَشٍيٍ رَبِلِنشِ. ");
INSERT INTO susa_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","وٌن نَشَ نَ لٌنفٌرِ تَا بِرِن كَنَ عَلْ وٌن عَ رَبَ شّسِبْن، سِشْن مَنفّ شَ بْشِ رَ كِ نَشّ. وٌن نَشَ شّمّيٍ، نُن فِنّيٍ، عَ نُن دِ مّيٍ بِرِن قَشَ، ");
INSERT INTO susa_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","كْنْ وٌن نَشَ عٍ شَ شُرُ سٍيٍ نُن عٍ هَرِفٍ تَن شَنِن.» ");
INSERT INTO susa_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","«وٌن عَ رَبَ نَ كِ نّ. نَ وَشَتِ وٌن نَشَ بْشِيٍ رَ سُشُ، نَشٍيٍ نُ نَ يُرُدّن سٌفٍتٍدٍ بِرِ، عَمٌرِكَيٍ شَ مَنفّ قِرِنيِيٍ يِ رَ. نَ لٌنفٌرِ كٍلِ عَرِنٌن شُرٍ هَن شٍرِ مٌن فٍيَ. ");
INSERT INTO susa_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","سِدْنكَيٍ نَ فٍيَ شِلِ قَلَمَ نّ سِرِيٌن. عَمٌرِكَيٍ تَن نَ شِلِ قَلَمَ سٍنِرِ. ");
INSERT INTO susa_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","تَا نَشٍيٍ بِرِن نَ لَنبَنيِ مَ، وٌن نَشَ عٍ بِرِن مَسْتْ، عَ نُن فَلَدِ بْشِ رَبِلِنيِ بِرِن، سِفَقٍ رَ بَسَن مَ سَ دْشْ سَلِكَ نُن عٍدٍرِ رَ. نَ تَا بِرِن نُ نَ عٌفٌ شَ مَنفّيَ نَن بُن مَ بَسَن بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","بَسَن مَنفّ عٌفٌ نَن كٍرٍن مُ قَشَ رٍقَكَيٍ يَ مَ. عَ شَ وُرٍ سَدٍ نُ نَ رَابَ نّ، عَمٌنِكَيٍ شَ مَنفَتَا. عَ كُيّ نُ سِفَشِ نْنفْن سٌلٌمَنَانِ، عَ عِفبٌي نْنفْن نَانِ.» ");
INSERT INTO susa_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","«نَ تّمُي وٌن نَشَ شُتُ سْتْ نَ بْشِ مَ. كٍلِقٍ عَرٌوٍرِ سِفَقٍ رَ عَرِنٌن شُرٍ مَ، عَ نُن فَلَدٍ فٍيَ سّيتِ، نُن عَ تَايٍ، ﭑ نَشَ نَ بِرِن سٌ رُبٍن نُن فَدِ بْنسْي يِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ﭑ نَشَ فَلَدٍ سّيتِ دْنشْي نُن عٌفٌ شَ مَنفّيَ نَشَن نَ بَسَن بْشِ مَ سٌ مَنَسِ بْنسْي سّيتِ يِ رَ. عَرَفٌبٌ رَبِلِنيِ نُن بَسَن نُ كٌلٌنشِ رٍقَكَيٍ شَ بْشِ نَن نَ. ");
INSERT INTO susa_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","مَنَسِ شَ دِ يَيِرِ نَشَ عَرَفٌبٌ بْشِ قِندِ عَ فبٍ رَ، هَن فٍسُرِكَيٍ نُن مَاكَكَيٍ نَانِنيِ رَ. عَ نَشَ عَ شِلِ سَ بَسَن شُن مَ، نَشَن شِلِ قَلَمَ هَن يَكْسِ يَيِرِ تَا. ");
INSERT INTO susa_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ﭑ نَشَ فَلَدٍ سٌ مَكِرِ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ﭑ نَشَ فَلَدٍ سّيتِ سٌ رُبٍن بْنسْي عَ نُن فَدِ بْنسْي يِ رَ، هَن عَ سَ دْشْ عَرِنٌن شُرٍ رَ. شُرٍ نَن نَ نَانِنيِ رَ، هَن عَ سَ دْشْ يَبٌكٌ شُرٍ رَ عَمٌنِكَيٍ نَانِنيِ رَ، ");
INSERT INTO susa_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","عَ نُن عَرَبَ بْشِ نَشَن نُن يُرُدّن نَانِنيِ بَشِ، كٍلِ كِنٍرٍتِ بَا مَ، عَ سَ دْشْ عَرَبَ قْشّ بَا رَ، نَشَن نَ ثِسِفَ لَنبَنيِ مَ سٌفٍتٍدٍ.» ");
INSERT INTO susa_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","«نَ تّمُي ﭑ نَشَ يِ يَامَرِ قِ وٌ مَ، ‹وٌ مَرِفِ عَلَتَلَ بَرَ يِ بْشِ قِ وٌ مَ عَلَكٌ عَ شَ قِندِ وٌ فبٍ رَ. وٌ تَن شّمّ كّندّيٍ، وٌ قِندِ مَ نّ وٌ نفَشَكٍرٍنيِ عِسِرَيِلَكَيٍ شَ سْورِيٍ رَ. ");
INSERT INTO susa_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","وٌ شَ فِنّيٍ نُن وٌ شَ دِيْرّيٍ، نُن وٌ شَ شُرُ سٍيٍ نَن فبَنسَن قَمَ لُدٍ تَايٍ كُي ﭑ نَشٍيٍ سٌشِ وٌ يِ رَ. ﭑ نَ عَ كٌلٌن شُرُ سٍيٍ فبٍفبٍ نَ وٌ يِ رَ. ");
INSERT INTO susa_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","وٌ سْورِحَ رَبَمَ نّ هَن وٌ مَرِفِ عَلَتَلَ مَلَبُي قِمَ وٌ نفَشَكٍرٍنيِيٍ مَ تّمُي نَشّ. وٌ مَرِفِ عَلَتَلَ بْشِ قِمَ عٍ مَ يُرُدّن نَاكِرِ نَن مَ. نَ تّمُي كَنكَن قَمَ فبِلٍندٍ عَ شَ بْشِ مَ ﭑ نَشَن سٌشِ عَ يِ رَ.›» ");
INSERT INTO susa_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","«نَ تّمُي ﭑ نَشَ يَامَرِ سٌ يٌسُوٍ يِ رَ. ﭑ قَ عَ قَلَ عَ بّ، ‹عِ يَ بَرَ قٍيٍ بِرِن تٌ عِ مَرِفِ عَلَتَلَ نَشٍيٍ رَبَشِ يِ مَنفّ قِرِنيِيٍ رَ. عَلَتَلَ قَمَ نّ نَ رَبَدٍ مَنفَتَا بِرِن عِ نَ دَنفِ دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","عِ نَشَ فَاشُ عٍ يَ رَ، بَرِ مَ عِ مَرِفِ عَلَتَلَ نَن قَمَ عٍ فٍرٍدٍ وٌ بّ.›» ");
INSERT INTO susa_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","«نَ تّمُي ﭑ نَشَ عَلَتَلَ مَشَندِ، ");
INSERT INTO susa_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‹ﭑ مَرِفِ عَلَتَلَ، عِ بَرَ عِ شَ قِسَمَنتٍيَ نُن عِ سّنبّ مَسٍن عِ شَ كٌنيِ بّ. عَلَ فبّتّ يٌ مُ نَ كٌورٍ مَ عَ نُن بْشِ نَشَن نْمَ عِ قْشِ عَ نُن عِ شَ كَابَنَكٌي رَبَدٍ. ");
INSERT INTO susa_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ﭑ بَرَ عِ مَيَندِ، عَ لُ ﭑ شَ نْ يُرُدّن شُرٍ عِفِرِدٍ، عَلَكٌ ﭑ شَ نَ بْشِ قَنيِ نُن عَ شَ فٍيَ قَنيِيٍ تٌ نَشَن نَ نَاكِرِ مَ، عَ نُن لِبَن.› ");
INSERT INTO susa_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","كْنْ وٌ تَن شَ قٍ رَ، عَلَتَلَ نَشَ شْنْ ﭑ مَ. عَ مُ ﭑ دَنشُن. عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹عَ مُ لَن عِ شَ يِ وْيّنيِ قَلَ ﭑ بّ سْنْن. ");
INSERT INTO susa_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","تٍ ثِسِفَ فٍيَ شُنتَفِ، عِ شَ سٌفٍفٌرٌدٍ بِرِ، كْولَ بِرِ، يِرٍقَنيِ بِرِ، عَ نُن سٌفٍتٍدٍ بِرِ مَتٌ، كْنْ عِ شَ عَ كٌلٌن عَ قَنيِ رَ عِ مُ يُرُدّن عِفِرِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","عِ شَ يَامَرِ سٌ يٌسُوٍ يِ رَ، عِ شَ لِمَنِيَ نُن سّنبّ قِ عَ مَ، بَرِ مَ عَ تَن نَن قَمَ تِدٍ حَمَ يَ رَ يُرُدّن عِفِرِقٍ رَ. عِ بْشِ نَشَن تٌمَ، يٌسُوٍ قَمَ نّ نَ بْشِ سٌدٍ عِسِرَيِلَ يِ رَ، عَ قِندِ عٍ كّ بْشِ رَ.› ");
INSERT INTO susa_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","نَ نَن عَ تٌشِ، وٌن نَشَ لُ فُلُنبَ بٍتِ ثٍيٌرِ يَتَفِ. ");
INSERT INTO susa_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","«يَكْسِ، عِسِرَيِلَ، وٌ وٌ تُلِ مَتِ. وٌ شَ بِرَ سّرِيّ نُن يَامَرِ قْشْ رَ ﭑ وٌ شَرَنقٍ نَشٍيٍ رَ يِ كِ، عَلَكٌ وٌ شَ سِمَيَ سْتْ، وٌ مَن شَ بْشِ سْتْ وٌ بَبَيٍ مَرِفِ عَلَتَلَ نَشَن قِشِ وٌ مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","وٌ نَشَ سٍسٍ سَ يَامَرِ شُن، ﭑ نَشَن قَلَشِ وٌ بّ. وٌ مَن نَشَ سٍسٍ بَ عَ رَ. وٌ شَ وٌ مَرِفِ عَلَتَلَ شَ يَامَرِ رَوَلِ عَلْ ﭑ نَ قَلَشِ وٌ بّ كِ نَشّ.» ");
INSERT INTO susa_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","«وٌ يَيٍ بَرَ قٍيٍ تٌ عَلَتَلَ نَشٍيٍ رَبَشِ ثٍيٌرِ. وٌ مَرِفِ عَلَتَلَ بَرَ مِشِ بِرِن قَشَ نَشٍيٍ بَلِ بَتُشِ ثٍيٌرِ. ");
INSERT INTO susa_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","كْنْ وٌ تَن نَشٍيٍ بِرَشِ وٌ مَرِفِ عَلَتَلَ شَ قٍ قْشْ رَ، وٌ بِرِن مَن نَ سِمَيَ كُي هَن تٌ.» ");
INSERT INTO susa_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","«وٌ عَ كٌلٌن، ﭑ بَرَ وٌ شَرَن سّرِيّ نُن يَامَرِ رَ عَلْ ﭑ مَرِفِ عَلَتَلَ عَ يَمَرِشِ ﭑ نَ كِ نَشّ، عَلَكٌ وٌ شَ عَ رَبَ بْشِ مَ دّننَشّ قِندِ مَ وٌ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","وٌ شَ عَ تِ شْرِ مَ، وٌ شَ عَ رَبَ، عَ شَ قِندِ لْننِ رَ وٌ بّ، عَ شَ شَشِلِ قِ وٌ مَ. سِ فبّتّيٍ نَ يِ سّرِيّيٍ كٌلٌن، عٍ قَمَ نّ عَ قَلَدٍ، ‹يِ سِ قِندِشِ لْننِلَ قَنيِيٍ نَن نَ.› ");
INSERT INTO susa_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","سِ مُندُن شَ عَلَ مَكْرّشِ عَ رَ عَلْ وٌن مَرِفِ عَلَتَلَ عَ مَكْرّ مَ وٌن نَ كِ نَشّ وٌن نَ عَ مَشَندِ تّمُي نَشّ؟ ");
INSERT INTO susa_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","سّرِيّ نُن يَامَرِ تِنشِنشِ نَ سِ مُندُن بّ عَلْ وٌن مَ سّرِيّ ﭑ نَشَن سٌشِ وٌ يِ رَ يِ كِ؟ ");
INSERT INTO susa_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","وٌ شَ قٍيٍ رَفَتَ وٌ شَشِلِ مَ لْشْي بِرِن وٌ شَ سِمَيَ كُي، وٌ نَشٍيٍ تٌشِ. وٌ نَشَ نّيمُ نٍيٍ مَ، عٍ نَشَ بَ وٌ بْحّ مَ. وٌ شَ عٍ مَسٍن وٌ شَ دِيٍ نُن وٌ شَ مَمَدِيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","«وٌ وٌ مَحْشُن لْشْي مَ وٌ تِ وٌ مَرِفِ عَلَتَلَ يَ عِ لْشْي نَشّ، شٌرٍبٍ فٍيَ قَرِ. نَ لْشْي عَلَتَلَ نَشَ عَ قَلَ ﭑ بّ، ‹حَمَ بِرِن شَ مَلَن ﭑ يِرٍ. ﭑ شَ ﭑ مَ سّرِيّ قَلَ عٍ بّ عَلَكٌ عٍ شَ فَاشُ ﭑ يَ رَ عٍ شَ دُنِحّءِفِرِ كُي. عٍ مَن شَ عَ شَرَن عٍ شَ دِيٍ قَن نَ.› ");
INSERT INTO susa_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","وٌ نَشَ وٌ مَسٌ فٍيَ بُنيِ رَ. تّ نُ بَرَ دِن فٍيَ رَ هَن كٌورٍ مَ. دِ مِ، نُشُي، نُن كُندَ نَشَ فٌرٌ. ");
INSERT INTO susa_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","عَلَتَلَ نَشَ وْيّن وٌ بّ تّ تَفِ. وٌ نَشَ عَ وْيّن شُي مّ، كْنْ وٌ مُ سٍسٍ تٌ. وٌ نُ عَ شُي نَن تُن مّمَ. ");
INSERT INTO susa_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","عَ نَشَ عَ شَ سَاتّ مَسٍن وٌ بّ، وٌ نَشَن نَوَلِمَ. عَ نَشَ نَ يَامَرِ قُ سّبّ فّمّ وَلَشّ قِرِنيِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","نَ وَشَتِ، عَلَتَلَ نَشَ ﭑ يَامَرِ ﭑ شَ وٌ شَرَن سّرِيّ نُن يَامَرِ رَ، عَلَكٌ وٌ شَ عَ رَبَ بْشِ مَ نَشَن قِندِ مَ وٌ فبٍ رَ.» ");
INSERT INTO susa_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","«وٌ نَشَ وٌ يّتّ رَنّيمُ لْشْي مَ دٍ عَلَتَلَ وْيّن وٌ بّ لْشْي نَشّ، شٌرٍبٍ فٍيَ قَرِ تّ تَفِ، وٌ مُ عَ فُندِ يَتِ تٌ. ");
INSERT INTO susa_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","وٌ نَشَ قِندِ يُنُبِتْي رَ دٍ كُيٍيٍ يَءِلَنقٍ رَ، نَشٍيٍ مِسَالِشِ شّمّ، فِنّ، ");
INSERT INTO susa_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","سُبٍ، شْنِ، ");
INSERT INTO susa_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","بُبُسٍيٍ نُن يّشّيٍ رَ نَشٍيٍ نَ يٍ مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","وٌ نَشَ وٌ يَيٍ رَتٍ كٌورٍ مَ دٍ، سٌفٍ بَتُقٍ رَ، شَ نَ مُ عَ رَ كِكٍ، شَ نَ مُ عَ رَ تُنبُييٍ. سٍ نَشٍيٍ بِرِن نَ كٌورٍ مَ، وٌ نَشَ وٌ عِفٌرٌ عٍ بّ، وٌ نَشَ عٍ بَتُ. وٌ مَرِفِ عَلَتَلَ نٍيٍ دَاشِ سِ بِرِن نَن بّ، نَشٍيٍ نَ دُنِحَ مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","كْنْ وٌ تَن، عَلَتَلَ وٌ رَ مِنِ نّ قٍ شْرْشْي كُي مِسِرَ بْشِ مَ عَلَكٌ وٌ شَ قِندِ عَ شَ حَمَ رَ، عَلْ وٌ نَ كِ نَشّ تٌ لْشْي.» ");
INSERT INTO susa_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","«عَلَتَلَ نَشَ شْنْ ﭑ مَ وٌ شَ قٍ رَ. عَ نَشَ عَ كَلِ عَ ﭑ مُ يُرُدّن عِفِرِ مَ، ﭑ مُ قَمَ سٌدٍ يِ بْشِ قَنيِ مَ وٌ مَرِفِ عَلَتَلَ نَشَن قِشِ وٌ مَ كّ رَ. ");
INSERT INTO susa_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ﭑ تَن، ﭑ قَمَ قَشَدٍ يِ بْشِ نَن مَ. ﭑ مُ قَمَ يُرُدّن عِفِرِدٍ قٍوٌ. كْنْ وٌ تَن قَمَ نّ عَ عِفِرِدٍ، نَ بْشِ قَنيِ قِندِ وٌ فبٍ رَ. ");
INSERT INTO susa_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","وٌ شَ وٌ حّنفِ سَ وٌ يّتّ شْن مَ عَلَكٌ وٌ نَشَ نّيمُ وٌ مَرِفِ عَلَتَلَ شَ سَاتّ مَ عَ نَشَن تٌنفٌشِ وٌ بّ. وٌ نَشَ كُيٍ يٌ يَءِلَن وٌ مَرِفِ عَلَتَلَ نَشٍيٍ رَتْنشِ وٌ مَ، ");
INSERT INTO susa_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","بَرِ مَ وٌ مَرِفِ عَلَتَلَ لُمَ عَلْ تّ نَشَن سٍ كَنَمَ، عَ مُ وَ مَ عَ قِرِن بٌورٍ شْن مَ.» ");
INSERT INTO susa_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","«وٌ نَ دِيٍ نُن مَمَدِيٍ سْتْ تّمُي نَشّ، وٌ نَ بُ كِ نَشّ بْشِ مَ، شَ وٌ كُيٍ يَءِلَن سٍ ندٍ مِسَالِ رَ، شَ وٌ قٍ حَاشِ رَبَ وٌ مَرِفِ عَلَتَلَ يَ عِ نَشَن مُ رَقَن عَ مَ، ");
INSERT INTO susa_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","كٌورٍ نُن بْشِ نَن نَ وٌن سٍيدٍ رَ تٌ لْشْي، وٌ قَمَ نّ قَشَدٍ مَقُرٍن بْشِ مَ نَشَن قَمَ قِندِدٍ وٌ فبٍ رَ يُرُدّن نَاكِرِ مَ. وٌ مُ قَمَ سِمَيَ سْتْدٍ، وٌ هَلَكِمَ نّ. ");
INSERT INTO susa_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","عَلَتَلَ وٌ رَيٍنسٍنمَ نّ حَمَنّيٍ مَ. وٌ سِ قَمَ نّ شُرُندٍ حَمَيٍ تَفِ عَلَتَلَ نَ وٌ شَنِن دّننَشّ. ");
INSERT INTO susa_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","مّننِ وٌ قَمَ كُيٍيٍ نَن بَتُدٍ، مِشِيٍ نَشٍيٍ يَءِلَنشِ وُرِ رَ، شَ نَ مُ عَ رَ فّمّ، كُيٍ نَشٍيٍ مُ نْمَ سٍ تٌدٍ، عٍ مُ قٍ مّمَ، عٍ مُ عٍ دّفٍمَ، عٍ مُ سٍ شِرِ مّمَ. ");
INSERT INTO susa_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","مّننِ وٌ قَمَ نّ وٌ مَرِفِ عَلَتَلَ قٍندٍ. وٌ عَ تٌمَ نّ شَ وٌ عَ قٍن وٌ بْحّ قَنيِ رَ، وٌ حَنِفٍ بِرِن نَ. ");
INSERT INTO susa_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","وٌ شَ تْورّ كُي نَ قٍ بِرِن وٌ لِمَ نّ. نَ تّمُي وٌ قَمَ فبِلٍندٍ وٌ مَرِفِ عَلَتَلَ مَ، وٌ عَ شُي مّمَ نّ، ");
INSERT INTO susa_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","بَرِ مَ وٌ مَرِفِ عَلَتَلَ، عَلَ نَ عَ رَ نَشَن كِنِكِنِمَ مِشِ مَ، نَشَن مُ وٌ رَبّحِنمَ، نَشَن مُ وٌ هَلَكِمَ. عَ مُ قَمَ نّيمُدٍ سَاتّ مَ عَ رَكَلِ نَشَن نَ وٌ بَبَيٍ بّ.» ");
INSERT INTO susa_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«وٌ وٌ مَحْشُن قٍ قٌرِيٍ مَ نَشٍيٍ بَرَ دَنفِ دُنِحَ مَ كَبِ عَلَ عَدَ مَ دَاشِ تّمُي نَشّ. قٍ كَابَنَكٌي فبّتّ قَن بَرَ رَبَ نَ شَنبِ رَ؟ ندٍ بَرَ نَ قٍ مْولِ مَنِيّ مّ سِندٍن؟ ");
INSERT INTO susa_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","حَمَ فبّتّ ندٍ نَ نَ بَ، نَشٍيٍ بَرَ عَلَ شُي مّ تّ تَفِ، عَ مَن قَ سِمَيَ سْتْ عَلْ نَشَن بَرَ رَبَ وٌ تَن بّ؟ ");
INSERT INTO susa_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","عَلَ مُندُن بَرَ حَمَ بَ حَمَ فبّتّ يِ رَ حَشَنكَتّ رَ، تْنشُمَ رَ، كَابَنَكٌي رَ، فٍرٍ بٍلٍبٍلٍ رَ، قٍ مَفَاشُشِيٍ رَ، عَلْ وٌ مَرِفِ عَلَتَلَ نَشَن نَبَ وٌ بّ مِسِرَ بْشِ مَ وٌ يَ شْرِ؟» ");
INSERT INTO susa_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","«نَ بَرَ قِيشّ وٌ بّ عَلَكٌ وٌ شَ لَ عَ رَ عَ عَلَتَلَ كٍرٍن ثٍتِ نَن عَلَ رَ، عَلَ فبّتّ يٌ مُ نَ قٌ عَ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","عَ نَشَ عَ شُي رَ مِنِ كٌورٍ مَ عَلَكٌ وٌ شَ فَاشُ عَ يَ رَ. عَ نَشَ تّ بٍلٍبٍلٍ مَسٍن وٌ بّ بْشِ قَرِ، عَ وْيّن وٌ بّ عَ تَفِ. ");
INSERT INTO susa_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","عَ نَشَ وٌ بَبَيٍ شَنُ، عَ نَشَ عٍ بْنسْي قَن سُفَندِ هَلِ عٍ دَنفِ شَنبِ. نَ نَن عَ تٌشِ عَ وٌ رَ مِنِشِ سّنبّ رَ مِسِرَ بْشِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","عَ سِيٍ كٍرِ وٌ بّ نَشٍيٍ سّنبّ فبٌ وٌ تَن بّ، عَ عٍ شَ بْشِ سٌ وٌ يِ رَ كّ رَ عَلْ وٌ عَ تٌشِ كِ نَشّ تٌ. ");
INSERT INTO susa_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","وٌ لَن نّ وٌ شَ عَ كٌلٌن تٌ لْشْي وٌ بْحّ كُي، عَ عَلَتَلَ كٍرٍن ثٍتِ نَن نَ عَلَ رَ كٌورٍ نُن بْشِ مَ. عَلَ فبّتّ مُ نَ نَ قٌ عَ كٍرٍن. ");
INSERT INTO susa_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","وٌ عَ شَ سّرِيّ نُن عَ شَ يَامَرِ رَبَتُ، ﭑ نَشَن سٌقٍ وٌ يِ رَ تٌ لْشْي، عَلَكٌ وٌ شَ هّيرِ سْتْ وٌ تَن نُن وٌ بْنسْي، هَلِ وٌ دَنفِ شَنبِ، عَلَكٌ وٌ مَن شَ سِمَيَ شْنكُيٍ سْتْ بْشِ مَ وٌ مَرِفِ عَلَتَلَ دّننَشّ قِشِ وٌ مَ عَبَدَن.» ");
INSERT INTO susa_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","عَننَبِ مُنسَ نَشَ تَا سَشَن سُفَندِ يُرُدّن سٌفٍتٍدٍ بِرِ. ");
INSERT INTO susa_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","نٍيٍ نَشَ قِندِ مِشِ رَتَنفَ تَايٍ رَ قَشَتِيٍ بّ نَشٍيٍ قَشّ تِمَ، كْنْ عٍ مُ عَ حَنِفٍشِ. نَ قَشّتِ نْمَ لُدٍ يِ تَا كٍرٍن كٍرٍن نَ مَ كُي عَلَكٌ عَ نِي شَ رَتَنفَ فبٍحْشْي مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","نَ تَايٍ قِندِ بٍتٍسٍرِ نَن نَ فبٍنفبٍرٍنيِ مَ فٍيَ قَرِ، رُبٍنكَيٍ شْنيِ، رَ مٌتِ تَا نَشَن نَ فَلٍدٍ، فَدِكَيٍ شْنيِ، عَ نُن فٌلَن، تَا نَشَن نَ بَسَن بْشِ مَ مَنَسِكَيٍ شْنيِ. ");
INSERT INTO susa_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","عَلَ شَ سّرِيّ نَن يَ، عَننَبِ مُنسَ نَشَن مَسٍنشِ عِسِرَيِلَكَيٍ بّ. ");
INSERT INTO susa_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","مَسٍنيِ، سّرِيّ، نُن يَامَرِ نَن يَ، عَننَبِ مُنسَ نَشَن قَلَ عِسِرَيِلَكَيٍ بّ عٍ نُ مِنِمَ مِسِرَ بْشِ رَ تّمُي نَشّ. ");
INSERT INTO susa_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","نَ تّمُي، عٍ نُ نَ يُرُدّن نَاكِرِ نَن مَ، فُلُنبَ بٍتِ ثٍيٌرِ يَ تَفِ، عَمٌرِكَيٍ شَ مَنفّ سِشْن شَ بْشِ مَ. سِشْن نُ سَبَتِشِ شّسِبْن نّ. عَننَبِ مُنسَ نُن عِسِرَيِلَكَيٍ تٌ مِنِ مِسِرَ بْشِ مَ، عٍ نَشَ نْلَ سْتْ سِشْن مَ. ");
INSERT INTO susa_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","عٍ نَشَ عَ شَ بْشِ رَ سُشُ عَ يِ رَ، عَ نُن بَسَن مَنفّ عٌفٌ شَ بْشِ. يِ عَمٌرِكَيٍ شَ مَنفّ قِرِنيِيٍ نُ نَ يُرُدّن نَاكِرِ مَ سٌفٍتٍدٍ بِرِ. ");
INSERT INTO susa_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","يِ تَايٍ نُ سِفَشِ عَرٌوٍرِ هَن عَرِنٌن شُرٍ، سِفَقٍ رَ شٍرِ مٌن فٍيَ مَ، نَشَن شِلِ سِيٌن. ");
INSERT INTO susa_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","يِ تَايٍ نَن نُ عَرَبَ بْشِ مَ يُرُدّن نَاكِرِ مَ، سٌفٍتٍدٍ بِرِ، عَ سَ دْشْ عَرَبَ بَا رَ ثِسِفَ فٍيَ بُن مَ. ");
INSERT INTO susa_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","عَننَبِ مُنسَ نَشَ عِسِرَيِلَ حَمَ مَشِلِ، عَ نَشَ عَ قَلَ عٍ بّ، «عِسِرَيِلَكَيٍ، وٌ وٌ تُلِ مَتِ يِ سّرِيّ نُن يَامَرِ رَ، ﭑ نَشَن قَلَقٍ وٌ بّ تٌ لْشْي. وٌ لَن وٌ شَ عَ شَرَن، وٌ شَ قّنتّن عَ رَبَ كِ مَ. ");
INSERT INTO susa_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","وٌن مَرِفِ عَلَتَلَ بَرَ سَاتّ تٌنفٌ وٌن بّ شٌرٍبٍ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","عَلَتَلَ نُن وٌن بَبَيٍ شَ مُ يِ سَاتّ شِرِشِ. عَ شِرِشِ وٌن تَن نَن بِرِن تَفِ، وٌن تَن نَشٍيٍ نَ سِمَيَ كُي يِ وَشَتِ. ");
INSERT INTO susa_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","عَلَتَلَ وْيّن نّ وٌن بّ يَ نُن يَ تّ تَفِ فٍيَ قَرِ. ");
INSERT INTO susa_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","نَ تّمُي ﭑ تَن نَن نُ نَ وٌ نُن عَلَتَلَ تَفِ عَلَكٌ ﭑ شَ عَلَتَلَ شَ مَسٍنيِ يَ شَرَن وٌ بّ، بَرِ مَ وٌ نُ فَاشُشِ تّ يَ رَ. وٌ مُ تٍ فٍيَ قَرِ. عَ نَشَ عَ مَسٍن وٌ بّ، ");
INSERT INTO susa_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‹ﭑ تَن نَن نَ وٌ مَرِفِ عَلَتَلَ رَ. ﭑ تَن نَن وٌ رَ مِنِشِ مِسِرَ، وٌ نُ نَ كٌنيِيَ كُي دّننَشّ.›» ");
INSERT INTO susa_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«وٌ نَشَ عَلَ فبّتّ بَتُ قٌ ﭑ كٍرٍن.» ");
INSERT INTO susa_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«وٌ نَشَ كُيٍ يَءِلَن مِسَالِ يٌ رَ، سٍ يٌ رَ نَشٍيٍ نَ كٌورٍ نُن بْشِ مَ، نَشٍيٍ نَ يٍ بُن مَ. ");
INSERT INTO susa_vpl VA