﻿USE sofia;
DROP TABLE IF EXISTS sofia.sus_vpl;
CREATE TABLE sus_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sus_vpl WRITE;
INSERT INTO sus_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A fɔlɛ ra, Ala naxa koore nun bɔxi daa. ");
INSERT INTO sus_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Duniɲa mu nu yailanxi, sese mu nu na a ma. Dimi nan nu na baa birin ma, kɔnɔ Ala ɲɛngi naxan luxi alɔ foye nu a malintanma ye xun ma. ");
INSERT INTO sus_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ala naxa a masen, «Naiyalanyi xa mini.» Naiyalanyi naxa mini keren na. ");
INSERT INTO sus_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ala naxa a mato fa, na naiyalanyi fanxi. Ala naxa naiyalanyi nun dimi itaxun. ");
INSERT INTO sus_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ala naxa naiyalanyi xili sa «yanyi.» A naxa dimi xili sa «kɔɛ.» Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ singe nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ala naxa a masen, «Koore walaxɛ xa lu bɔxi ye nun koore ye tagi.» ");
INSERT INTO sus_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Na bara findi naaninyi ra bɔxi ye nun koore ye tagi. A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ala naxa yi naaninyi xili sa «koore.» Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ firin nde nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ala naxa a masen, «Bɔxi ye xa malan yire keren. Xare xa maba.» A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ala naxa na xare xili sa «bɔxi.» A naxa na bɔxi ye xili sa «baa.» Ala naxa a mato fa, na birin fanxi. ");
INSERT INTO sus_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ala naxa a masen, «Sansie xa mini bɔxi ma. Sansi mɔɔli birin xa bula. Sansi xɔri naxan na a bogi kui, a bulama nɛ birin nun a mɔɔli ra.» A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Bɔxi naxa rafe sansi mɔɔli birin na, a bogi nun a sansi xɔri na a bili ma, na fan birin nun a mɔɔli. Ala naxa a mato fa, na birin fanxi. ");
INSERT INTO sus_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ saxan nde nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ala naxa a masen, «Yanbasee xa lu koore ma, yanyi nun kɔɛ itaxunfe ra. Waxati birin kolonma yanbasee saabui nan na. Xi yo xi, ɲɛ yo ɲɛ a kolonma yanbasee nan saabui ra. ");
INSERT INTO sus_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Yanbase na koore ma bɔxi iyalanse nan na.» A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ala naxa naiyalanse xungbe firin nafala. Naxan xungbo, na xa yanyi yaamari raba. Naxan xurun, na xa kɔɛ yaamari raba. A naxa tunbuie fan nafala. ");
INSERT INTO sus_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ala naxa yanbasee sa koore ma alako e xa bɔxi iyalan, ");
INSERT INTO sus_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","e xa yanyi nun kɔɛ yaamari raba, e xa dimi nun naiyalanyi rafatan. Ala naxa a mato fa, a birin fanxi. ");
INSERT INTO sus_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ naani nde nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ala naxa a masen, yɛxɛe xa ye ramaxa. Xɔnie xa ɲɛrɛ koore ma. ");
INSERT INTO sus_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ala naxa yɛxɛ xungbe mɔɔli birin daa a nun nimase naxan birin na ye xɔɔra. A naxa xɔni mɔɔli birin fan daa. Ala naxa a mato fa, a birin fanxi. ");
INSERT INTO sus_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ala naxa barakɛ sa e xa fe. A naxɛ, «Wo xa wuya, wo xa yiriwa alako yɛxɛe xa wuya baa ma. Xɔnie fan xa gbo bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ suuli nde nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ala naxa a masen, «Nimasee mɔɔli birin xa lu bɔxi ma: xurusee, bubusee, a nun buurunyi subee.» A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ala naxa buurunyi subee mɔɔli birin daa, a naxa xurusee mɔɔli birin daa, a naxa bubusee mɔɔli birin daa. Ala naxa a mato fa, a birin fanxi. ");
INSERT INTO sus_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ala naxa a masen, «Won xa adama daa, won xa won fɔxi lu a ma. A xa yaamari raba yɛxɛe xun ma, xɔnie xun ma, xurusee xun ma, bɔxi xun ma, a nun bubusee xun ma.» ");
INSERT INTO sus_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ala naxa adama daa ginɛ nun xɛmɛ, a a fɔxi lu e ma. ");
INSERT INTO sus_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ala naxa barakɛ sa e xa fe. A naxɛ, «Wo xa wuya, wo xa yiriwa alako bɔxi xa rafe. Wo xa yaamari raba bɔxi xun ma, yɛxɛe xun ma, xɔnie xun ma, bubusee xun ma.» ");
INSERT INTO sus_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A naxɛ, «N bara sansi birin nun sansi bogi birin fi wo ma baloe ra. ");
INSERT INTO sus_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","N bara sansi birin fi sube birin ma naxan na bɔxi ma, a nun xɔni birin ma, a nun bubuse birin ma, nimase birin ma naxee ɲɛngima. Sansi birin bara findi e baloe ra.» A rabaxi na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ala naxa a xa daalise birin mato fa, a fanxi han. Kɔɛ naxa so, kuye naxa iba, lɔxɔɛ senni nde nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Koore, bɔxi, nun se birin daa ki nan nu na ki. ");
INSERT INTO sus_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Lɔxɔɛ solofere nde Ala xa wali naxa kamali. A naxa a malabu. ");
INSERT INTO sus_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ala naxa tide sa na lɔxɔɛ solofere nde ma, a xa findi lɔxɔɛ sɛniyɛnxi ra barima a a malabu na lɔxɔɛ nɛ a xa wali kamalixi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Taruxui nan ya, duniɲa daaxi ki naxɛ. Marigi Alatala bɔxi nun koore daa tɛmui naxɛ, ");
INSERT INTO sus_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","fɔtɔnyi yo mu nu na. Sansi yo mu nu na naxan bulaxi bɔxi ma barima Marigi Alatala mu nu tunɛ ye ragoroxi sinden. Adama fan mu nu na naxan bɔxi rawalima, ");
INSERT INTO sus_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","kɔnɔ ye nu luma mini ra bɔxi bun, a fa yensen yɛ yire birin ma. ");
INSERT INTO sus_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Marigi Alatala naxa adama yailan bɛndɛ ra. Na dangi xanbi a naxa nii raso a fate a ɲɔɛ kui. A findi adama ra na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na xanbi Marigi Alatala naxa yire fanyi yailan sogetede mabiri. Na yire xili «Eden.» A naxa adama lu mɛnni. ");
INSERT INTO sus_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Marigi Alatala naxa wuri mɔɔli birin nabula mɛnni, wuri tofanyie, wuri naxee bogi fan a don daaxi ra. Na yire tagi wuri firin nu na. Keren xili «Simaya wuri.» Boore xili «Fe fanyi nun fe ɲaaxi kolon wuri.» ");
INSERT INTO sus_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Xure naxan ye rasoxi Eden kui sansie bɛ, a to dangixi, a itaxunxi dɔxɔ naani ra. ");
INSERT INTO sus_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Na singe xili Pison. Na nan dangima Hawila bɔxi birin ma, xɛɛma na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na xɛɛma fan. Wuri ye xiri ɲɔxunmɛ fan na na, a nun gɛmɛ tofanyi naxan xili onixi. ");
INSERT INTO sus_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na xure firin nde xili Gixon. Na nan dangima Kusi bɔxi birin ma. ");
INSERT INTO sus_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na xure saxan nde xili Tigiri. Na nan dangima Asuri bɔxi ma a sogetede biri ra. Na xure naani nde xili Efirati. ");
INSERT INTO sus_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Marigi Alatala naxa adama rasabati Eden, alako a xa nɔ na yire rawalide, a man xa mɛɛni na ma. ");
INSERT INTO sus_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Marigi Alatala naxa yaamari so adama yi ra, a naxɛ, «I nɔma yi wuri bogi birin donde naxan na Eden kui, ");
INSERT INTO sus_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kɔnɔ i naxa ‹Fe fanyi nun fe ɲaaxi kolon wuri› bogi don de, barima i nu na don, i faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Marigi Alatala naxa a fala, «A mu fan xɛmɛ xa lu be a keren. N fama malima fanyi daalide a bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Buurunyi sube birin nun xɔni birin Marigi Alatala naxan daalixi bɛndɛ ra, a naxa e xanin adama xɔn ma a xa e xili sa. Adama xili naxee sa e xun ma, nee naxa findi e xilie ra. ");
INSERT INTO sus_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A naxa xuruse birin, xɔni birin, a nun buurunyi sube birin xili sa. Kɔnɔ na waxati Adama mu a malima fanyi sɔtɔxi sinden. ");
INSERT INTO sus_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Marigi Alatala naxa xi xɔli radangi a ma. A naxa a raxi a fanyi ra. A to xi, Marigi Alatala naxa a ganyanyi xɔri keren ba, a fa mɛnni ragali. ");
INSERT INTO sus_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na xanbi, Marigi Alatala naxa Adama ganyanyi xɔri findi ginɛ ra, a fa na ginɛ fi Adama ma. ");
INSERT INTO sus_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adama naxa a fala, «Yi ginɛ fatanxi n xɔri nun n sube nan na. A xili nɛ ‹ginɛ›, barima a minixi xɛmɛ nɛ i.» ");
INSERT INTO sus_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Na fe na a toxi, xɛmɛ fama nɛ kelide a baba nun a nga xun ma, a maso a xa ginɛ ra, e findi keren na. ");
INSERT INTO sus_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Xɛmɛ nun a xa ginɛ mageli nan nu a ra, kɔnɔ na fe yaagi mu nu e ma. ");
INSERT INTO sus_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bɔximase nan nu kɔɔta Marigi Alatala xa daalise birin bɛ. A naxa ginɛ maxɔrin, «Ala a fala nɛ wo bɛ a wuri bogi naxan birin na Eden kui, a wo naxa a sese don? Nɔndi na a ra?» ");
INSERT INTO sus_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ginɛ naxa a yaabi, «Wuri naxee na Eden kui, muxu nɔma e birin bogi donde, ");
INSERT INTO sus_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kɔnɔ wuri naxan na Eden tagi, muxu mu nɔma na tan bogi donde, muxu mu nɔma makɔrɛde a ra yɛtɛ yati, xa na mu a ra muxu faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bɔximase naxa a fala ginɛ bɛ, «Ade, wo mu faxama. ");
INSERT INTO sus_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ala a kolon, wo na a don, wo ya rabima nɛ. Wo fama fe fanyi nun fe ɲaaxi kolonde alɔ Ala yɛtɛ.» ");
INSERT INTO sus_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ginɛ to wuri bogi to, a tofan, a fan donse ra, a fan xaxili sɔtɔse ra, a naxa keren ba, a don, a nde so a xa mɔri yi, e nun naxan nu a ra. Na fan naxa a don. ");
INSERT INTO sus_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Na waxati e yae naxa rabi. E naxa a kolon, e mageli nan nu a ra. E naxa xɔrɛ burɛxɛe dɛnbɛ e boore ra, e e yɛtɛ sutura a ra. ");
INSERT INTO sus_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na xanbi, xɛmɛ nun a xa ginɛ naxa Marigi Alatala ɲɛrɛ xui mɛ nunmare ra. E naxa e nɔxun wurie xanbi ra. ");
INSERT INTO sus_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Marigi Alatala naxa xili ti, «Adama, i na minden?» ");
INSERT INTO sus_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adama naxa a yaabi, «N bara i xui mɛ Eden kui, kɔnɔ n bara gaaxu, barima n mageli na a ra. Na nan a ra, n nan n nɔxunxi.» ");
INSERT INTO sus_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Marigi Alatala naxa a maxɔrin, «Nde a masenxi i bɛ i mageli na a ra? Ka i bara na wuri bogi don ba, n naxan ma fe fala i bɛ i naxa a don?» ");
INSERT INTO sus_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adama naxɛ, «I ginɛ naxan fixi n ma, na nan yi wuri bogi so n yi ra, n naxa a don.» ");
INSERT INTO sus_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Na xanbi, Marigi Alatala naxa ginɛ maxɔrin, «I yi rabaxi munfe ra?» Ginɛ naxa a yaabi, «Bɔximase bara n madaxu han n bara na wuri bogi don.» ");
INSERT INTO sus_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Awa, Marigi Alatala naxa a fala bɔximase bɛ, «I to bara yi raba, awa, n fan n bara i danka xuruse nun buurunyi sube birin ya ma. I findima bubuse nan na i furi fari. I xube nan donma i xa duniɲɛigiri kui. ");
INSERT INTO sus_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","N bara dɛɲaaxui raso i tan nun ginɛ tagi. N bara a raso i xa die nun a xa die tagi. Ginɛ xa di i xunyi butuxunma nɛ. I fan a tingilinyi xinma nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Marigi Alatala naxa a fala ginɛ bɛ, «I fan, n i tɔɔrɔma nɛ i xa di bari kui. Na tɔɔrɛ gboma nɛ. I birama nɛ i xa mɔri fɔxɔ ra, a i yamari.» ");
INSERT INTO sus_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Marigi Alatala naxa a fala Adama bɛ, «I bara bira i xa ginɛ fɔxɔ ra. I bara na wuri bogi don, n naxan ma fe fala i bɛ, i naxa a don. Yakɔsi n bara bɔxi danka i xa fe ra. I tɔɔrɔma nɛ baloe sɔtɔde i xa duniɲɛigiri kui. ");
INSERT INTO sus_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","N tunbe nun baagi raminima nɛ bɔxi ma, i baloe sɔtɔma xɛ nan ma. ");
INSERT INTO sus_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I baloe sɔtɔma i yilenfure nan na han i gbilenma bɛndɛ tɛmui naxɛ i rafalaxi naxan na. Bɛndɛ nan i ra, i man gbilenma na bɛndɛ nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adama naxa a xa ginɛ xili sa «Mahawa,» barima a findima nɛ mixi birin nga ra. ");
INSERT INTO sus_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Marigi Alatala naxa dugi kiri daaxie dɛgɛ Adama nun a xa ginɛ bɛ, a naxa e ragoro e ma. ");
INSERT INTO sus_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Marigi Alatala naxa a masen, «Adama bara fe fanyi nun fe ɲaaxi tagi raba kolon alɔ won tan. A mu daxa a xa simaya wuri bogi don, xa na mu a ra a mu faxama.» ");
INSERT INTO sus_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Marigi Alatala naxa a ramini Eden, a xa bɔxi rawali Ala a daaxi naxan na. ");
INSERT INTO sus_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A Adama keri xanbi, Marigi Alatala naxa malekɛe yaamari, e xa ti Eden sogetede biri ra. E xa nu santidɛgɛma tɛ daaxi malintan, na simaya wuri kantade. ");
INSERT INTO sus_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama nun Mahawa to kafu, Mahawa naxa tɛɛgɛ. E naxa di sɔtɔ naxan xili Kabila. Mahawa naxɛ, «Alatala bara n mali di xɛmɛ sɔtɔfe ra.» ");
INSERT INTO sus_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Na xanbi Mahawa naxa Kabila xanbiratoe xɛmɛma sɔtɔ naxan xili Habila. Xuruse dɛmadonyi nan nu Habila ra. Bɔxi rawali nan nu Kabila ra. ");
INSERT INTO sus_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na tɛmui to dangi, Kabila naxa fa sansi bogi fangadama ra sɛrɛxɛ bade Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kɔnɔ Habila naxa fa xuruse di singee ra nun e ture. Habila nun a xa sɛrɛxɛ naxa rafan Alatala ma, ");
INSERT INTO sus_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kɔnɔ Kabila nun a xa sɛrɛxɛ mu nu rafan Alatala ma. Alatala mu a ya ti Kabila xa sɛrɛxɛ ra. Na na a ra, Kabila naxa xɔnɔ, a yatagi naxa masara. ");
INSERT INTO sus_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na xanbi Alatala naxa Kabila maxɔrin, «I xɔnɔxi munfe ra? I yatagi masaraxi munfe ra? ");
INSERT INTO sus_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Xa i fe fanyi raba, n na tongoma nɛ, kɔnɔ xa i fe ɲaaxi raba, Sentanɛ i ratantanma nɛ. I kata, i xa i yɛtɛ ba a yi ra.» ");
INSERT INTO sus_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kabila naxa a fala a xunya bɛ, «Won xɛɛ xɛ ma.» E to so xɛ ma, Kabila naxa a xunya Habila suxu, a naxa a faxa. ");
INSERT INTO sus_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Na xanbi Alatala naxa Kabila maxɔrin, «I xunya Habila na minden?» A naxa a yaabi, «N mu a kolon. Fo n xa mɛɛni n xunya ma?» ");
INSERT INTO sus_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Alatala naxa a fala, «I munse rabaxi? N na i xunya wuli gbelegbele xui mɛfe keli bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","N bara i danka barima i bara i xunya faxa. N i kerima nɛ yi bɔxi ma i xunya wuli na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","I na bɔxi rawali, i mu baloe sɔtɔma. I findima ɲɛrɛti nan na.» ");
INSERT INTO sus_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kabila naxa Alatala yaabi, «Na ɲaxankatɛ gbo n tan bɛ. ");
INSERT INTO sus_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Xa i bara n keri yi bɔxi ma to, won tagi ikuyama nɛ. N findima ɲɛrɛti nan na. Mixi naxan na sa n to, a n faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Alatala naxa a yaabi, «Ade, xa mixi yo i faxa, n i gbeɲɔxɔma nɛ dɔxɔ solofere.» Alatala naxa tɔnxuma sa Kabila ma alako xa naxan sa a to a naxa nɔ a gerede. ");
INSERT INTO sus_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Na tɛmui Kabila naxa a makuya Alatala ra. A naxa sabati Nodi bɔxi ma Eden fuge ra. ");
INSERT INTO sus_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kabila nun a xa ginɛ naxa kafu. A xa ginɛ naxa tɛɛgɛ, a naxa di sɔtɔ naxan xili Enoki. Kabila nu na taa tife. A naxa a xa di xili sa na taa xun ma. ");
INSERT INTO sus_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki naxa Iradi sɔtɔ. Iradi, Mexuyayeli baba na a ra. Mexuyayeli, Metusayeli baba na a ra. Metusayeli, Lameki baba na a ra. ");
INSERT INTO sus_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki naxa ginɛ firin sɔtɔ, keren xili Ada, boore xili Silahi. ");
INSERT INTO sus_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada naxa Yabala sɔtɔ. Yabala, xuruse dɛmadonyie nun kiri banxi kanyie baba na a ra. ");
INSERT INTO sus_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabala xunya xili Yubali. Yubali, kɔra bɔnbɔɛe nun xule fee baba na a ra. ");
INSERT INTO sus_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silahi fan naxa di sɔtɔ. A xili Tubali Kabila. Xabui nan nu a tan na. Walise wure gbeeli nun wure daaxi mɔɔli birin xabui nan nu a ra. Tubali Kayini xunya ginɛma xili Nama. ");
INSERT INTO sus_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki naxa a fala a xa ginɛe bɛ, «Ada nun Silahi wo xa wo haakɛ to n bɛ. Lameki xa ginɛe, wo xa wo tuli mati n ma wɔyɛnyi ra. N bara xɛmɛ nde faxa gbeɲɔxɔɛ ra. N bara na sɛgɛtala faxa barima a bara n maxɔnɔ. ");
INSERT INTO sus_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Xa mixi solofere nan faxama Kabila gbeɲɔxɔfe ra, mixi tongo solofere nun solofere nan faxama n tan Lameki gbeɲɔxɔfe ra.» ");
INSERT INTO sus_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama nun a xa ginɛ naxa kafu. Mahawa naxa di sɔtɔ naxan xili Seti. A bara na xili sa a xa di xun ma barima Ala bara a xa di Habila ɲɔxɔɛ so a yi ra Kabila naxan faxa. ");
INSERT INTO sus_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti fan naxa di sɔtɔ naxan xili Enosi. Na waxati mixie naxa Alatala maxandi fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama nun a bɔnsɔɛ xa taruxui nan ya. Ala to ibunadama die daa, a naxa a fɔxi lu e ma. ");
INSERT INTO sus_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A naxa e daa xɛmɛ nun ginɛ. A barakɛ sa e ma. A e xili sa «adama.» ");
INSERT INTO sus_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama to bu ɲɛ kɛmɛ ɲɛ tongo saxan, a naxa di sɔtɔ a yɛtɛ misaali ra. A naxa a xili sa Seti. ");
INSERT INTO sus_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti xa bari dangi xanbi, Adama naxa bu ɲɛ kɛmɛ solomasaxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adama xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ tongo saxan. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti to bu ɲɛ kɛmɛ ɲɛ suuli, a naxa findi Enosi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosi xa bari dangi xanbi, Seti naxa bu ɲɛ kɛmɛ solomasaxan ɲɛ solofere. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ fu nun firin. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi to bu ɲɛ tongo solomanaani, a naxa findi Kenan baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan xa bari dangi xanbi, Enosi naxa bu ɲɛ kɛmɛ solomasaxan ɲɛ fu nun suuli. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ suuli. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan to bu ɲɛ tongo solofere, a naxa findi Mahalaleli baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalaleli xa bari dangi xanbi, Kenan naxa bu ɲɛ kɛmɛ solomasaxan ɲɛ tongo naani. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ fu. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli to bu ɲɛ tongo senni a nun suuli, a naxa findi Yeredi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yeredi xa bari dangi xanbi, Mahalaleli naxa bu ɲɛ kɛmɛ solomasaxan ɲɛ tongo saxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli xa simaya naxa siga ɲɛ kɛmɛ solomasaxan nun ɲɛ tongo solomanaani nun suuli. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yeredi to bu ɲɛ kɛmɛ ɲɛ tongo senni a nun firin, a naxa findi Enoki baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoki xa bari dangi xanbi, Yeredi naxa bu ɲɛ kɛmɛ solomasaxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yeredi xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ tongo senni a nun firin. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoki to bu ɲɛ tongo senni a nun suuli, a naxa findi Metusela baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela xa bari dangi xanbi, Enoki naxa bira Ala fɔxɔ ra ɲɛ kɛmɛ saxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoki xa simaya naxa siga ɲɛ kɛmɛ saxan nun ɲɛ tongo senni a nun suuli. ");
INSERT INTO sus_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki naxa bira Ala fɔxɔ ra. Na xanbi a mu lu na sɔnɔn, barima Ala bara a xanin. ");
INSERT INTO sus_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela to bu ɲɛ kɛmɛ ɲɛ tongo solomasaxan a nun solofere, a naxa findi Lameki baba ra. ");
INSERT INTO sus_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lameki xa bari dangi xanbi, Metusela naxa bu ɲɛ kɛmɛ solofere ɲɛ tongo solomasaxan a nun firin. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela xa simaya naxa siga ɲɛ kɛmɛ solomanaani nun ɲɛ tongo senni a nun solomanaani. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki to bu ɲɛ kɛmɛ ɲɛ tongo solomasaxan a nun firin, a naxa di sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A naxa a xili sa Nuha. A naxa a fala, «A fama won malide won ma tɔɔrɛ nun won ma wali kui, won naxan nabama bɔxi ma Alatala bara dɛnnaxɛ danka.» ");
INSERT INTO sus_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuha xa bari dangi xanbi, Lameki naxa bu ɲɛ kɛmɛ suuli ɲɛ tongo solomanaani a nun suuli. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki xa simaya naxa siga ɲɛ kɛmɛ solofere nun ɲɛ tongo solofere a nun solofere. Na xanbi a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuha to bu ɲɛ kɛmɛ suuli, a naxa findi Semi, Hami, nun Yefeti baba ra. ");
INSERT INTO sus_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Na tɛmui xɛmɛe nun e xa di ginɛe naxa wuya fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ala xa malekɛe naxa yabu yi di ginɛe ra e xa tofanyi ma. Malekɛe naxa ndee sugandi, e naxa e findi e xa ginɛe ra. ");
INSERT INTO sus_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na xanbi, Alatala naxa a fala, «N mu tinma nii xa bu adama fate abadan, barima daalise na a ra. A mu dangima ɲɛ kɛmɛ ɲɛ mɔxɔɲɛn na.» ");
INSERT INTO sus_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na waxati, a nun waxati naxan fa na xanbi ra, nabiyoro bɔnsɔɛ nu na duniɲa ma. Na malekɛe nun na di ginɛe nan nee barixi. Geresoe belebelee nun xili xungbe kanyie nan nu nabiyoro bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Alatala naxa a to adama bara kobi. Tɛmui birin a xa maɲɔxunyie findixi a kobi nan na. ");
INSERT INTO sus_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Na naxa Alatala tɔɔrɔ han a bara a yɛtɛ maxɔrin munfe ra a adama daaxi. Na fe naxa a bɔɲɛ tɔɔrɔ ki fanyi. ");
INSERT INTO sus_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Alatala naxa a fala, «Adama birin n naxan daaxi, n na birin tongoma nɛ duniɲa ma. Mixi yo, sube yo, bubuse yo, xɔni naxan ɲɛrɛma koore ma yo, n na birin tongoma nɛ duniɲa ma, barima n bara nimisa adama daafe ra.» ");
INSERT INTO sus_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kɔnɔ Nuha tan nu rafan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuha xa taruxui nan ya. Nuha nu findixi tinxintɔɛ nun sɛniyɛntɔɛ nan na na waxati mixie tagi. A nu birama Ala nan fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Di saxan nan nu Nuha yi ra: Semi, Hami, nun Yefeti. ");
INSERT INTO sus_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Duniɲa nu bara kana Ala ya i, a xa fe ɲaaxi nu bara gbo yɛ. ");
INSERT INTO sus_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ala naxa duniɲa to, a kanaxi, mixi birin fe ɲaaxi rabafe. ");
INSERT INTO sus_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Na kui Ala naxa a masen Nuha bɛ, «N wama adama birin tongofe duniɲa ma, barima duniɲa bara kobi a ɲaaxi ra. N wama adama birin nun duniɲa birin kanafe. ");
INSERT INTO sus_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","A lanma i xa kunkui banban wuri ra, naxan xili goferi. Konkoe xa lu a kui. Dole xa sa a kui nun a fari. ");
INSERT INTO sus_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","I xa a yailan yi ki: I xa kunkui rakuya kanke ya tongo senni nun solofere a nun a tagi. I xa a igbo kanke ya fu nun keren. I xa a ite kanke ya senni nun a tagi. ");
INSERT INTO sus_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I xa kunkui xunyi yailan, nɔngɔn ya keren xa lu kunkui xunyi nun kunkui dɛ kiri tagi. I xa naadɛ ti a sɛɛti keren ma. I xa a kui rabagan dɔxɔ saxan.» ");
INSERT INTO sus_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«Na xanbi n tan fama ye radinde duniɲa ma. A mixi birin sɔntɔ. Nimase birin faxama nɛ. ");
INSERT INTO sus_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kɔnɔ n bara saatɛ tongo i bɛ. I soma nɛ yi kunkui kui, i tan nun i xa die, a nun i xa ginɛ, a nun i xa die xa ginɛe. ");
INSERT INTO sus_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I xa fa nimase mɔɔli birin firin firin na, xɛmɛ nun ginɛ. Na nan a toma e kisima. ");
INSERT INTO sus_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Xɔni bɔnsɔɛ birin firin firin, sube bɔnsɔɛ birin firin firin, bubuse bɔnsɔɛ birin firin firin, e fama i xɔn, i xa e rakisi. ");
INSERT INTO sus_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I xa donse mɔɔli birin baki kunkui kui. I xa sa a ragata i tan bɛ a nun e fan bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuha naxa a birin naba Ala naxan masenxi a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Alatala naxa a masen Nuha bɛ, «So kunkui kui, i tan nun i xa denbaya birin, barima i tan tinxintɔɛ nan i ra yi waxati mixie tagi. ");
INSERT INTO sus_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sube radaxaxi birin, i xa xɛmɛ solofere nun ginɛ solofere baki. Sube raharamuxi birin, i xa xɛmɛ keren nun ginɛ keren baki. ");
INSERT INTO sus_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Xɔni fan a mɔɔli birin, i xa xɛmɛ solofere nun ginɛ solofere baki. Na kui sube mɔɔli birin xa nɔ lude duniɲa ma banbaranyi dangi xanbi.» ");
INSERT INTO sus_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","«Xi solofere na dangi, n tunɛ ragoroma bɔxi ma. Xi tongo naani tunɛ fama kɔɛ nun yanyi. Nimase birin n naxan daaxi, na birin sɔntɔma nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuha naxa na birin naba Alatala naxan masen a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Na tunɛ fama tɛmui naxɛ, Nuha xa simaya nu na ɲɛ kɛmɛ senni. ");
INSERT INTO sus_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuha yo, a xa ginɛ, a xa die nun nee fan xa ginɛe, e birin naxa e gi ye ma, e sa so kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Sube radaxaxie, sube raharamuxie, xɔnie, nun bubusee, e birin ");
INSERT INTO sus_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","naxa siga Nuha xɔn ma kunkui kui, xɛmɛe nun ginɛe, e sa so kunkui kui alɔ Ala Nuha yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Xi solofere dangi xanbi, na banbaranyi naxa din duniɲa ma. ");
INSERT INTO sus_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuha xa simaya nu na ɲɛ kɛmɛ senni, kike firin, xi fu a nun solofere. Na lɔxɔɛ ye naxan na bɔxi bun ma, na naxa te fɔlɔ, ye naxan na koore ma, na fan naxa goro fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tunɛ naxa bira bɔxi ma xi tongo naani. Kɔɛ a nun yanyi, tunɛ fama. ");
INSERT INTO sus_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na lɔxɔɛ, Nuha nun a xa die, Semi, Hami, Yefeti, a xa ginɛ, nun a xa di saxanyie xa ginɛe, e birin naxa so kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Buurunyi sube bɔnsɔɛ birin, xuruse bɔnsɔɛ birin, bubuse bɔnsɔɛ birin, a nun xɔni bɔnsɔɛ birin, e naxa so kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Daalise naxan birin ɲɛngima, a firin firin, e naxa fa Nuha xɔn ma, e sa so kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nimase birin, xɛmɛ nun ginɛ, e soxi nɛ kunkui kui alɔ Ala Nuha yamarixi ki naxɛ. Na xanbi Alatala naxa naadɛ balan. ");
INSERT INTO sus_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Xi tongo naani banbaranyi tema. A naxa kunkui ite. ");
INSERT INTO sus_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ye to gbo bɔxi ma, kunkui naxa dɔxɔ ye fari. ");
INSERT INTO sus_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ye naxa te han a naxa geya birin makoto duniɲa ma. ");
INSERT INTO sus_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ye naxa dusu geya xun han kanke ya solofere nun a tagi. ");
INSERT INTO sus_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nimase naxan birin nu ɲɛrɛma duniɲa ma, e birin naxa faxa: xɔnie, xurusee, buurunyi subee, bubusee, a nun adamadie. ");
INSERT INTO sus_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nimase naxan birin ɲɛngima xare ma, e birin naxa faxa. ");
INSERT INTO sus_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ala naxa nimase birin ba duniɲa ma. Nimase birin naxa faxa: adamadie, xurusee, bubusee, a nun xɔni naxee ɲɛrɛma koore ma, fo Nuha keren, a nun naxee nu na a xun ma kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Banbaranyi naxa din duniɲa ma xi kɛmɛ xi tongo suuli. ");
INSERT INTO sus_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kɔnɔ Ala naxa ratu Nuha ma, a nun buurunyi sube nun xuruse naxee nu na a xun ma kunkui kui. Ala naxa foye radin duniɲa ma, ye fa xɔri fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ye naxan nu kelima bɔxi bun ma, na naxa dan. Ye naxan nu kelima koore ma, na fan naxa dan. ");
INSERT INTO sus_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lɔxɔ yo lɔxɔ fo nde ba ye ra. Xi kɛmɛ xi tongo suuli kamali xanbi, nde naxa ba ye ra ki fanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kike solofere, xi fu nun solofere nde, kunkui naxa dɔxɔ geyae fari, geya naxee na Ararati bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kike fu xi keren kamali xanbi, geyae fari naxa maba. ");
INSERT INTO sus_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Xi tongo naani dangi xanbi, Nuha naxa wundɛri rabi naxan na kunkui ma. ");
INSERT INTO sus_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A naxa xaxa bɛɲin, a nu siga, a nu fa, han ye naxa xurun. ");
INSERT INTO sus_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Na xanbi a naxa ganbɛ bɛɲin, a xa kolon xa ye bara xɔri. ");
INSERT INTO sus_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kɔnɔ na ganbɛ naxa yire mato, santide mu na, barima ye dinxi duniɲa birin ma. A naxa gbilen Nuha yire. Nuha naxa ganbɛ tongo, a a raso kunkui kui. ");
INSERT INTO sus_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A naxa mamɛ ti han xi solofere, a man naxa ganbɛ bɛɲin a firin nde. ");
INSERT INTO sus_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nunmare, ganbɛ naxa gbilen Nuha yire, oliwi wuri ɲingi suxuxi a dɛkole ra. Na kui Nuha naxa a kolon ye bara ba duniɲa ma. ");
INSERT INTO sus_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A naxa mamɛ ti xi solofere. A naxa ganbɛ bɛɲin a saxan nde, kɔnɔ ganbɛ mu gbilen. ");
INSERT INTO sus_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuha xa simaya to siga ɲɛ kɛmɛ senni nun ɲɛ keren, kike keren, xi keren, banbaranyi fa ɲɔn duniɲa ma. Nuha to kunkui xunyi ba naa, a naxa a to xare bara maba. ");
INSERT INTO sus_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kike firin xi mɔxɔɲɛn a nun solofere to dangi, bɔxi nu bara xara a fanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ala naxa a masen Nuha bɛ, ");
INSERT INTO sus_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Wo mini kunkui kui, i tan nun i xa ginɛ, i xa die nun e xa ginɛe. ");
INSERT INTO sus_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","I xa nimase birin namini kunkui kui: xɔnie, subee, bubusee, alako e xa yiriwa, e xa wuya duniɲa ma.» ");
INSERT INTO sus_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Na tɛmui Nuha naxa mini fa, a nun a xa die, a xa ginɛ, nun a xa die xa ginɛe. ");
INSERT INTO sus_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Subee fan naxa mini, a nun bubusee, nun xɔnie. Nimase bɔnsɔɛ birin naxa mini e xati xati ma. ");
INSERT INTO sus_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na xanbi, Nuha naxa sɛrɛxɛbade yailan Alatala bɛ. A naxa sube nun xɔni radaxaxi ndee tongo, a nee ba sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Na tuuri to te, Alatala naxa na gan xiri mɛ. A naxa rafan a ma. A naxa a fala a bɔɲɛ ma, «N mu bɔxi dankama sɔnɔn adama xa fe ra, barima n na kolon adama bɔɲɛ mu fan kafi a dimɛdi tɛmui. N mu nimase birin sɔntɔma sɔnɔn alɔ n na singe raba ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sansi si tɛmui nun sansi xaba tɛmui, xinbeli nun kuyefure, sogofure nun ɲɛmɛ, yanyi nun kɔɛ, n mu na bama sɔnɔn han duniɲa ɲɔn.» ");
INSERT INTO sus_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na dangi xanbi Ala naxa barakɛ sa Nuha nun a xa die xa fe. A naxa a masen e bɛ, «Wo xa wuya, wo xa yiriwa, wo xa gbo bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sube naxee na duniɲa ma nun xɔni naxee na koore ma, e gaaxuma nɛ wo ya ra. Bubuse naxee na bɔxi ma nun yɛxɛ naxee na baa ma, e e gima nɛ wo ya ra. N bara e birin sa wo sago, ");
INSERT INTO sus_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","n bara e birin findi baloe ra wo bɛ alɔ sansie n naxan singe fi wo ma donse ra.» ");
INSERT INTO sus_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","«Kɔnɔ wo naxa sube don, naxan wuli mu baxi, barima a wuli findixi sube nii nan na. ");
INSERT INTO sus_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sube yo naxan wo nii bama, xa na mu a ra mixi yo naxan a boore adamadi nii bama, na kanyi nan gbe na na nii kote sare ra. ");
INSERT INTO sus_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mixi naxan adamadi nii bama, mixi nan na kanyi fan nii bama, barima Ala fɔxi bara lu adama ma. ");
INSERT INTO sus_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Wo xa wuya, wo xa yiriwa, wo xa gbo bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Na xanbi Ala naxa a masen Nuha nun a xa die bɛ, ");
INSERT INTO sus_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«N bara saatɛ tongo wo nun wo xa die bɛ, ");
INSERT INTO sus_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","a nun nimase naxan birin nu na kunkui kui: xɔnie, xurusee, buurunyi subee, nimase naxan birin na duniɲa ma. ");
INSERT INTO sus_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","N bara saatɛ tongo wo bɛ, banbaranyi tan mu nii birin bama sɔnɔn, a mu duniɲa birin kanama fa.» ");
INSERT INTO sus_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ala naxa a masen, «N bara saatɛ tongo wo nun nimase birin bɛ, saatɛ naxan mu kanama abadan. ");
INSERT INTO sus_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Saatɛ tɔnxuma nan ya, n senkui masenma nɛ koore ma. ");
INSERT INTO sus_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Xa n bara kunda sa koore ma, na senkui minima nɛ. ");
INSERT INTO sus_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Na tɛmui n natuma nɛ saatɛ xa fe ma, n saatɛ naxan tongoxi wo nun nimase birin bɛ. N mu nii birin bama duniɲa ma banbaranyi ra sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Senkui na mini koore ma, n na toma, n natuma saatɛ xa fe ma, saatɛ naxan mu kanama abadan, n saatɛ naxan tongoxi wo nun nimase birin bɛ naxee na duniɲa ma.» ");
INSERT INTO sus_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ala naxa a masen Nuha bɛ, «Saatɛ tɔnxuma nan ya, n na saatɛ naxan tongoxi nimase birin bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuha xa di naxee kelixi kunkui kui, e xili Semi, Hami, Yefeti. Hami findixi Kanaankae baba nan na. ");
INSERT INTO sus_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Duniɲa mixi birin fatanxi Nuha xa di saxanyie nan na. ");
INSERT INTO sus_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuha to xɛ rawali fɔlɔ, a naxa wɛni sansi si. ");
INSERT INTO sus_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Na sansi to bogi, Nuha naxa wɛni yailan. A to siisi na ra, a naxa a sa kiri banxi kui a mageli. ");
INSERT INTO sus_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaankae benba Hami to a baba mageli to, a naxa na fala a taarae bɛ. ");
INSERT INTO sus_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Na kui Semi nun Yefeti naxa dugi tongo fa, e so e baba xun e xanbi xanbi ma. E naxa dugi felen e baba ma, e mu e ya ti e baba mageli ra. ");
INSERT INTO sus_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuha xun to mabɔɔ a ra, a naxa keli, a naxa a kolon fa a xa di dɔnxɔɛ naxan nabaxi a ra. ");
INSERT INTO sus_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nuha naxa a fala, «N bara Kanaan danka. A xa findi konyi birin dɔnxɔɛ ra a taarae bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A man naxa a fala, «N bara Semi Marigi Alatala matɔxɔ. Kanaan xa findi Semi xa konyi ra. ");
INSERT INTO sus_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ala xa Yefeti xa bɔxi gbo, a xa lu Semi xa niini bun ma, Kanaan xa findi a xa konyi ra.» ");
INSERT INTO sus_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Banbaranyi dangi xanbi, Nuha naxa bu duniɲa ma ɲɛ kɛmɛ saxan ɲɛ tongo suuli. ");
INSERT INTO sus_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuha xa simaya to ɲɛ kɛmɛ solomanaani ɲɛ tongo suuli li, a naxa laaxira. ");
INSERT INTO sus_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuha xa die, Semi, Hami, nun Yefeti xa taruxui nan ya, a nun e fan xa die e naxee sɔtɔ banbaranyi dangi xanbi. ");
INSERT INTO sus_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yefeti xa die xilie nan ya: Gomeri, Magogo, Madayi, Yawani, Tubali, Meseki, Tirasi. ");
INSERT INTO sus_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeri xa die xilie nan ya: Asikenasi, Rifati, Togarama. ");
INSERT INTO sus_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawani xa die xilie nan ya: Elisaha, Tarasisi, Kitimi, Rodanimi. ");
INSERT INTO sus_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yefeti xa mixie naxa sabati baa dɛ ra e xabilɛ ki ma, kankan nun a gbe xui. E naxa findi si dɔxɔ wuyaxi ra e xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hami xa die xilie nan ya: Kusi, Misira, Puti, Kanaan. ");
INSERT INTO sus_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi xa die xilie nan ya: Seba, Hawila, Sabata, Raama, Sabiteka. Raama xa die xilie nan ya: Seeba, Dedan. ");
INSERT INTO sus_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nimirodi geresoe belebele nan nu a ra. A baba xili Kusi. ");
INSERT INTO sus_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimirodi man findi koyinma belebele ra Alatala ya i. Mixie nu a falama, «Koyinma belebele nan Nimirodi ra Alatala ya i.» ");
INSERT INTO sus_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A xa mangɛya taa singee findi Babilɔn, Ereki, Akadi, nun Kalene nan na, naxee nu na Sinari bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A naxa keli Sinari, a siga Asiriya bɔxi ma. Mɛnni a naxa taae ti naxee xili Ninewe, Rehoboti, Iri, Kala, ");
INSERT INTO sus_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nun Resen, taa belebele naxan na Ninewe nun Kala tagi. ");
INSERT INTO sus_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misira naxa findi Ludukae, Anamikae, Lehabakae, Nafatu, ");
INSERT INTO sus_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patirusukae, Kasaluxukae, (Filisitakae keli dɛnnaxɛ), a nun Kafatorokae benba ra. ");
INSERT INTO sus_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan naxa findi yi mixie baba ra: Sidɔnkae, a xa di singe, Xitikae, ");
INSERT INTO sus_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusukae, Amorikae, Girigasakae, ");
INSERT INTO sus_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwikae, Arakikae, Sinikae, ");
INSERT INTO sus_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arawadakae, Semarakae, nun Xamatakae. Bɔnsɔɛ naxan birin keli Kanaan, e naxa yensen yɛ. ");
INSERT INTO sus_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaan xa naaninyi naxa keli Sidɔn sigafe Gerara, a naxa siga han Gasa, a dangi Sodoma, Gomora, Adamaha, nun Seboyimi ra, a siga han Lasa. ");
INSERT INTO sus_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hami xa mixie nan ya e xabilɛ ki ma, kankan nun a gbe xui. E naxa findi si dɔxɔ wuyaxi ra e xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yefeti xunya Semi fan naxa die sɔtɔ. Eberi xa die benba nan na Semi ra. ");
INSERT INTO sus_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semi xa die xilie nan ya: Elama, Asuri, Arafaxadi, Ludu, nun Arami. ");
INSERT INTO sus_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arami xa die xilie nan ya: Usi, Xulu, Geteri, nun Meseki. ");
INSERT INTO sus_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arafaxadi naxa findi Selaha baba ra. Selaha naxa findi Eberi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi naxa di firin sɔtɔ. Keren xili Pelegi. Na nan falaxi «maitaxunyi,» barima Ala duniɲa mixie itaxun na waxati nɛ. A xunya xili Yokatan. ");
INSERT INTO sus_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokatan xa die xilie nan ya: Alomodadi, Selefa, Hasaramawete, Yera, ");
INSERT INTO sus_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorami, Usali, Dikila, ");
INSERT INTO sus_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimayele, Seeba, ");
INSERT INTO sus_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Hawila, nun Yobabo. Yokatan naxa na die birin sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","E xa bɔxi kelima Mesa, a siga han Sefare, naxan na geya sogetede mabiri. ");
INSERT INTO sus_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semi xa die nan ya a xabilɛ ki ma, kankan nun a gbe xui. E naxa findi si dɔxɔ wuyaxi ra e xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuha xa die bɔnsɔɛe xa taruxui nan na ki. Banbaranyi dangi xanbi, yi bɔnsɔɛ nan findi duniɲa si birin na. ");
INSERT INTO sus_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Na tɛmui duniɲa mixi birin nu xui keren nan falama. ");
INSERT INTO sus_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mixi ndee naxa keli, e siga sogetede mabiri, e geya to Sinari bɔxi ma. E naxa sabati kɛnɛ ma naxan na gulunba kui. ");
INSERT INTO sus_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E naxa a fala e boore bɛ, «Wo fa, won xa biriki bɔnbɔ, won xa e gan.» E naxa biriki findi gɛmɛ ɲɔxɔɛ ra. E naxa mɔta findi dole ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na xanbi e naxa a fala, «Won wali suxu, won xa taa ti won yɛtɛ bɛ, a nun banxi belebele naxan tema han koore ma, alako won xili xa gbo. Na na a ra, won mu lɔɛma won boore ma.» ");
INSERT INTO sus_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kɔnɔ Alatala naxa goro na taa matode, a nun na banxi belebele. ");
INSERT INTO sus_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Alatala naxa a masen, «Xa yi mixie bara kafu e boore ma yi wali rabade, e na xui keren fala, wali birin e wama naxan nabafe, a sɔɔnɛyama nɛ. ");
INSERT INTO sus_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Won xɛɛ, won xa goro e xa xui masunbude alako e naxa e boore wɔyɛn xui fahaamu.» ");
INSERT INTO sus_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Na kui Alatala naxa na gali rayensen yɛ. Na banxi tife naxa dan. ");
INSERT INTO sus_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Na yire xili naxa sa Babeli, barima Alatala duniɲa mixie xuie rawuya mɛnni nɛ, a fa e rayensen yɛ duniɲa birin ma. ");
INSERT INTO sus_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semi xa taruxui nan ya. Banbaranyi dangi xanbi ɲɛ firin, Semi xa simaya naxa ɲɛ kɛmɛ li. A naxa findi Arafaxadi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A to Arafaxadi sɔtɔ, Semi naxa ɲɛ kɛmɛ suuli sa a fari. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arafaxadi to ɲɛ tongo saxan a nun suuli sɔtɔ, a naxa findi Selaha baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A to Selaha sɔtɔ, Arafaxadi naxa bu ɲɛ kɛmɛ naani nun ɲɛ saxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selaha to ɲɛ tongo saxan sɔtɔ, a naxa findi Eberi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A to Eberi sɔtɔ, Selaha naxa bu ɲɛ kɛmɛ naani nun ɲɛ saxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi to ɲɛ tongo saxan nun naani sɔtɔ, a naxa findi Pelegi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A to Pelegi sɔtɔ, Eberi naxa bu ɲɛ kɛmɛ naani nun ɲɛ tongo saxan. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi to ɲɛ tongo saxan sɔtɔ, a naxa findi Ruye baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A to Ruye sɔtɔ, Pelegi naxa bu ɲɛ kɛmɛ firin nun ɲɛ solomanaani. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ruye to ɲɛ tongo saxan a nun firin sɔtɔ, a naxa findi Serugu baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A to Serugu sɔtɔ, Ruye naxa bu ɲɛ kɛmɛ firin nun ɲɛ solofere. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugu to ɲɛ tongo saxan sɔtɔ, a naxa findi Naxori baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A to Naxori sɔtɔ, Serugu naxa bu ɲɛ kɛmɛ firin. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxori to ɲɛ mɔxɔɲɛn nun solomanaani sɔtɔ, a naxa findi Tera baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A to Tera sɔtɔ, Naxori naxa bu ɲɛ kɛmɛ nun ɲɛ fu nun solomanaani. A naxa di xɛmɛ nun di ginɛ gbɛtɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera to ɲɛ tongo solofere sɔtɔ, a naxa findi Iburama, Naxori, nun Xarani baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera xa taruxui nan ya. Tera naxa findi Iburama, Naxori, nun Xarani baba ra. Xarani naxa findi Loti baba ra. ");
INSERT INTO sus_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Xarani singe naxa faxa a baba Tera bɛ Uru, Kalidi bɔxi ma, a barixi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iburama nun Naxori naxa ginɛe fen, e naxa futi xiri. Iburama xa ginɛ xili Sarayi. Naxori xa ginɛ xili Milika. Milika Xarani xa di na a ra. Di firin nu na Xarani yi ra, Milika nun Isika. ");
INSERT INTO sus_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi dibaritare nan nu a ra. Di yo mu nu na a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera naxa a xa di Iburama, a xa mamadi Loti, naxan findixi Xarani xa di ra, nun Iburama xa ginɛ Sarayi tongo, e naxa keli Uru Kalidi bɔxi ma sigafe ra Kanaan bɔxi ma. Kɔnɔ e to Xarani li, e naxa sabati mɛnni. ");
INSERT INTO sus_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera xa simaya to ɲɛ kɛmɛ firin ɲɛ suuli li, a naxa laaxira Xarani. ");
INSERT INTO sus_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Alatala naxa a masen Iburama bɛ, «I xa bɔxi bɛɲin, i xa mixie bɛɲin, i xabilɛ bɛɲin. I xa siga bɔxi ma n dɛnnaxɛ masenma i bɛ. ");
INSERT INTO sus_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","N i findima nɛ si belebele ra. N barakɛ sama nɛ i xa fe. N i xili gboma nɛ. Mixie fan barakɛ sɔtɔma i tan nan saabui ra. ");
INSERT INTO sus_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mixi naxan dubama i bɛ, n fan barakɛ sama nɛ na kanyi ma. Mixi naxan i dankama, n fan na kanyi dankama nɛ. Duniɲa birin barakɛ sɔtɔma i tan nan saabui ra.» ");
INSERT INTO sus_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Na tɛmui Iburama naxa keli Xarani alɔ Alatala a masenxi a bɛ ki naxɛ. Loti fan naxa bira a fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Iburama to keli Xarani, a xa simaya nu bara ɲɛ tongo solofere nun suuli li. A naxa a xa ginɛ Sarayi, a xunya xa di Loti, a harige birin, nun mixie a naxee sɔtɔ Xarani, a naxa e birin xanin Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iburama naxa ɲɛrɛ han a naxa wuri bili belebele nde li dɛnnaxɛ xili More, Sikemi mabiri. Kanaankae nu sabatixi mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Alatala naxa a yɛtɛ masen Iburama bɛ. A naxa a fala, «N yi bɔxi nan fima i bɔnsɔɛ ma.» Na kui Iburama naxa sɛrɛxɛbade yailan Alatala bɛ naxan minixi a ma. ");
INSERT INTO sus_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A naxa siga geya ma Beteli fuge ra. A naxa kiri banxi ti mɛnni, Beteli na a sogegorode, Ayi na a sogetede. A naxa sɛrɛxɛbade yailan Alatala bɛ, a fa a maxandi a xili ra. ");
INSERT INTO sus_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na xanbi a naxa siga Negewi gbengberen yire biri. ");
INSERT INTO sus_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na tɛmui, kaamɛ nu bara din Kanaan bɔxi ra. Iburama naxa siga Misira. ");
INSERT INTO sus_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Beenu e xa so Misira bɔxi ma, Iburama naxa a fala a xa ginɛ Sarayi bɛ, «N a kolon, ginɛ tofanyi nan i ra. ");
INSERT INTO sus_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misirakae na i to ya, e a falama nɛ n ma ginɛ nan i ra. Na xanbi, e n faxama nɛ, alako e xa i tongo. ");
INSERT INTO sus_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","I xa a fala e bɛ n xunya nan lanxi i ma, alako e xa mɛɛni n ma i xa fe ra. Na kui, n mu faxama i tan saabui ra.» ");
INSERT INTO sus_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iburama to Misira li, Misirakae naxa a to, Sarayi ginɛ tofanyi nan a ra. ");
INSERT INTO sus_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Misira mangɛ xa sansalae to Sarayi matɔxɔ a bɛ, a naxa a xanin a xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mangɛ naxa mɛɛni Iburama ma Sarayi saabui ra. A naxa xuruse lanmae, xuruse xungbee, sofalee, konyie, nun ɲɔxɔmɛe fi a ma. ");
INSERT INTO sus_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kɔnɔ Alatala naxa fure ɲaaxi sa Misira mangɛ nun a xa denbaya ma, Iburama xa ginɛ Sarayi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Misira mangɛ naxa Iburama xili. A naxa a fala a bɛ, «I munse rabaxi n na? Munfe ra i mu a fala n bɛ i xa ginɛ nan a ra. ");
INSERT INTO sus_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Munfe ra i a falaxi i xunya na a ra, han n tan bara a findi n ma ginɛ ra? Awa, n ko, i xa ginɛ nan ya. Wo siga!» ");
INSERT INTO sus_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na xanbi, Misira mangɛ naxa Iburama xa fe fala a xa korogbae bɛ. E naxa a ragbɛngbɛn, a tan, a xa ginɛ, nun a harige birin. ");
INSERT INTO sus_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Na tɛmui Iburama naxa keli Misira, a siga Negewi gbengberen yire mabiri. A naxa a xa ginɛ nun a harige birin xanin a xun ma. A xunya xa di Loti fan naxa a mati naa. ");
INSERT INTO sus_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Iburama nu bara findi banna ra. Xurusee, gbeti, nun xɛɛma nu na a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A naxa keli Negewi, a nu a xa ɲɛrɛ tagi isuxu, sigafe ra ");
INSERT INTO sus_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","yire nde Beteli nun Ayi tagi, a nu bara sɛrɛxɛbade ti dɛnnaxɛ. Mɛnni Iburama naxa Alatala maxandi a xili ra. ");
INSERT INTO sus_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti, naxan nu na Iburama fɔxɔ ra, a fan findixi xurusee nun kiri banxie kanyi nan na. ");
INSERT INTO sus_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Iburama xa xuruse gɔɔrɛ nun Loti xa xuruse gɔɔrɛ nu gbo na bɔxi bɛ. E mu nu nɔma lude yire keren sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Sɔnxɔɛ naxa mini Iburama xa xuruse dɛmadonyie a nun Loti xa xuruse dɛmadonyie tagi. Kanaankae nun Perisikae fan nu na mɛnni na waxati. ");
INSERT INTO sus_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Iburama naxa a fala Loti bɛ, «Won naxa kɔnɲɛ, won ma xuruse dɛmadonyie fan mu lan e xa kɔnɲɛ, barima won tan ngaxakerenma nan won na. ");
INSERT INTO sus_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Yi bɔxi birin nan i ya i yi ki. Won naxan nabama, won xa fatan. Xa i siga kɔɔla ma, n tan sigama yirefanyi nan ma. Xa i siga yirefanyi ma, n tan siga kɔɔla ma.» ");
INSERT INTO sus_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti naxa a ya rasiga, a naxa sa Yurudɛn mɛrɛ to. Ye nu na na a fanyi ra. Beenu Alatala xa Sodoma nun Gomora kana, na bɔxie nu fan han Sowari biri. Na nu luxi alɔ Misira bɔxi, alɔ Alatala xa yire yailanxi. ");
INSERT INTO sus_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Na kui Loti naxa Yurudɛn mɛrɛ sugandi a yɛtɛ bɛ. A naxa siga sogetede mabiri. Iburama nun Loti fatan na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iburama naxa lu Kanaan bɔxi ma, Loti naxa lu Yurudɛn mɛrɛ taae tagi. Loti naxa a xa kiri banxie ti Sodoma fɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomakae nu bara kobi a gbe ra, e nu bara findi yunubitɔɛ belebele ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Iburama nun Loti to fatan, Alatala naxa a masen Iburama bɛ, «I ya ti sogetede ra, sogegorode, yirefanyi, nun kɔɔla. ");
INSERT INTO sus_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I bɔxi naxan birin toxi, n a fima i tan nun i bɔnsɔɛ ma abadan. ");
INSERT INTO sus_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","N i bɔnsɔɛ rawuyama nɛ alɔ xube naxan na bɔxi ma. Xa mixi nde nɔma xube kɔntide, a nɔma nɛ i bɔnsɔɛ kɔnti fan kolonde. ");
INSERT INTO sus_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Keli, i bɔxi iɲɛrɛ, a kuyɛya nun a gboya, i xa a birin mato barima n a fima i tan nan ma.» ");
INSERT INTO sus_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Na tɛmui Iburama naxa kiri banxi yire masara. A naxa sabati wuri belebele ndee mabiri naxan na Mamire nun Hebiron fɛ ma. A naxa sɛrɛxɛbade yailan naa Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na waxati Babilɔn bɔxi mangɛ Amarafeli, Elasari bɔxi mangɛ Ariyoki, Elama bɔxi mangɛ Kedorolameri, nun Goyin bɔxi mangɛ Tidali, yi mangɛ naani naxa saatɛ tongo e boore bɛ mangɛ suuli ndee gerefe ra. ");
INSERT INTO sus_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Na mangɛ suuli nan ya: Sodoma mangɛ Bera, Gomora mangɛ Birisa, Adamaha mangɛ Sinabu, Seboyimi mangɛ Semeberi, nun Bela mangɛ Sowari. ");
INSERT INTO sus_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Yi mangɛ suuli naxa e malan gulunba nde kui naxan xili Sidimi, Fɔxɔɛ Baa na dɛnnaxɛ to. ");
INSERT INTO sus_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kabi ɲɛ fu nun firin yi mangɛ suuli nu na mangɛ Kedorolameri xa nɔɛ bun ma, kɔnɔ ɲɛ fu nun saxan nde e naxa muruta a xa mangɛya ma. ");
INSERT INTO sus_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A ɲɛ fu nun naani nde, mangɛ Kedorolameri nun mangɛ naxee nu na a sɛɛti ma, e naxa siga gere sode. E naxa nɔ a birin na: Refaka naxee nu na Asiteroti Karanayimi, Susika naxee nu na Hami, Emika naxee nu na Sawe Kiriyatayimi, ");
INSERT INTO sus_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","a nun Xorika naxee nu na geya ma Seyiri biri han Paran gbengberen yire fɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Na xanbi e naxa gbilen, e naxa siga En Misapati, naxan xili Kadesi. E naxa nɔ Amalɛkikae ra, a nun Amorika naxee nu sabatixi Xasason Tamari. ");
INSERT INTO sus_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na tɛmui, Sodoma mangɛ, Gomora mangɛ, Adamaha mangɛ, Seboyimi mangɛ, a nun Bela mangɛ (Bela xili Sowari), e naxa e malan gulunba kui naxan xili Sidimi yi mangɛ suuli gerefe ma: ");
INSERT INTO sus_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elama mangɛ Kedorolameri, Goyin mangɛ Tidali, Babilɔn mangɛ Amarafeli, nun Lasa mangɛ Ariyoki. Na mangɛ naani naxa yi mangɛ suuli gere. ");
INSERT INTO sus_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Yilie nu na Sidimi gulunba kui, dole nu na e kui. Sodoma mangɛ nun Gomora mangɛ to e gi, e naxa fa bira na yilie kui. Mixi dɔnxɔɛe naxa e gi sigafe ra geya fari. ");
INSERT INTO sus_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Na mangɛ naani naxee geeni, e naxa Sodoma nun Gomora harige nun e xa baloe birin tongo, e siga. ");
INSERT INTO sus_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","E naxa Iburama xunya xa di Loti fan suxu a nun a harige birin, barima a nu sabatixi Sodoma nan kui. ");
INSERT INTO sus_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mixi nde naxa nɔ a gide, a sa na fe birin tagi raba Iburama Eburuka bɛ. Na waxati, Iburama nu sabatixi Mamire Amorika xa wuri bili belebelee nan bun ma. Mamire nun a ngaxakerenyie Esekoli nun Aneri, e nun Iburama nu bara saatɛ tongo e boore bɛ. ");
INSERT INTO sus_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Iburama to a mɛ e bara a xunya xa di xɛmɛma Loti suxu, a naxa sɔɔri kɛmɛ saxan sɔɔri fu nun solomasaxan tongo, naxee nu barixi a xa mixie ya ma. E naxa siga na mangɛe fɔxɔ ra han taa naxan xili Dana. ");
INSERT INTO sus_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kɔɛ ra Iburama naxa a xa sɔɔrie itaxun, e naxa na mangɛe tɛrɛnna gere ra. E naxa nɔ na mangɛe matutunde han Hoba, Damasi kɔɔla ma. ");
INSERT INTO sus_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Iburama naxa nɔ na harige birin masɔtɔde. A naxa gbilen a xunya xa di Loti ra, a harige, a xa ginɛ, nun a xa mixi birin. ");
INSERT INTO sus_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Iburama to gbilen xun nakeli kui kelife mangɛ Kedorolameri gerede nun mangɛ naxee nu na a sɛɛti ma, Sodoma mangɛ naxa siga a ralande gulunba kui naxan xili Sawe. Mɛnni xili nɛ «Mangɛ xa gulunba.» ");
INSERT INTO sus_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na xanbi, Salamu mangɛ Melekisedeki naxa fa taami nun wɛni ra Iburama bɛ. Ala Xili Xungbe Kanyi xa sɛrɛxɛdubɛ nan nu na Melekisedeki ra. ");
INSERT INTO sus_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A naxa duba Iburama bɛ a falafe ra, «Ala Xili Xungbe Kanyi, naxan koore nun bɔxi daaxi, a xa barakɛ sa Iburama ma. ");
INSERT INTO sus_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tantui na Ala Xili Xungbe Kanyi bɛ, naxan i yaxuie rayarabixi i bɛ.» Na tɛmui, Iburama naxa farilɛ fi Melekisedeki ma a naxan sɔtɔ na gere kui. ");
INSERT INTO sus_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodoma mangɛ naxa a fala Iburama bɛ, «N ma mixie ragbilen n ma, kɔnɔ naafuli tan xa lu i bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iburama naxa a yaabi, «N bara n kali Alatala ra, Ala Xili Xungbe Kanyi naxan koore nun bɔxi daaxi, ");
INSERT INTO sus_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","n mu sese tongoma naxan findi i gbe ra, hali luuti di, xa na mu a ra sankiri luuti, alako i naxa fa a fala, ‹N bara Iburama findi banna ra.› ");
INSERT INTO sus_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","N mu sese tongoma, fo n ma sɔɔrie naxan donxi. I man xa Aneri, Esekoli, nun Mamire gbe so e yi ra, barima e fan nu na n sɛɛti ma.» ");
INSERT INTO sus_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na xanbi Alatala naxa mini Iburama ma, a naxa a masen a bɛ, «Iburama i naxa gaaxu, n tan nan na i kantama ra. I sare xungbe sɔtɔma nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Iburama naxa a yaabi, «Marigi Alatala, i munse ɲanigexi n bɛ a fife ra n ma? N to yi ki, di yo mu na n bɛ. Mixi mu na n bɛ naxan n kɛ tongoma fo n ma walikɛ Eliyeseri Damasi. ");
INSERT INTO sus_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","I mu di yo fixi n tan ma. Naxan barixi n ma banxi kui, na nan findima n kɛ tongoma ra.» ");
INSERT INTO sus_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Alatala naxa a yaabi, «Ade, na mu findima i kɛ tongoma ra de. I bari di yati nan fama findide i kɛ tongoma ra.» ");
INSERT INTO sus_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Alatala naxa Iburama ramini a xa kiri banxi bun ma, a naxa a masen a bɛ, «I ya rate koore ma. I xa tunbuie kɔnti xa i nɔma e kɔnti kolonde.» A man naxa a masen a bɛ, «Tunbuie gboxi ki naxɛ koore ma, i bɔnsɔɛ fan wuyama na ki nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iburama naxa la Alatala ra. Alatala fan naxa na findi tinxinyi ra a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ala naxa a masen a bɛ, «N tan nan na Alatala ra, naxan i raminixi Uru taa kui Babilɔn bɔxi ma. N bara i xanin bɔxi ma, n dɛnnaxɛ fixi i ma.» ");
INSERT INTO sus_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Iburama naxa a Marigi Alatala maxɔrin, «N na kolonma di, n fama na sɔtɔde?» ");
INSERT INTO sus_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Alatala naxa a masen a bɛ, «Fa ninge ginɛ, si ginɛ, nun yɛxɛɛ kontonyi ra, naxee bara ɲɛ saxan saxan sɔtɔ. I man xa fa ganbɛ nun kolokonde lanma ra.» ");
INSERT INTO sus_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iburama naxa fa na subee ra. A naxa ninge, si ginɛ, nun yɛxɛɛ kontonyi ixaba a tagi. A naxa na sube bolonyie sa e boore ya i, kɔnɔ a mu na xɔnie tan ixaba. ");
INSERT INTO sus_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yubɛe naxa fa, e goro na sube faxaxi yire, kɔnɔ Iburama naxa e birin keri naa. ");
INSERT INTO sus_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Soge to nu dulafe, xi xɔli naxa dangi Iburama ma dungbɛn. Dimi naxa sin a ma, gaaxui xungbe naxa a suxu. ");
INSERT INTO sus_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Alatala naxa a masen a bɛ, «A kolon, i bɔnsɔɛ fama sigade bɔxi gbɛtɛ ma e xɔnyi mu dɛnnaxɛ ra. E findima nɛ konyie ra na bɔxi ma. E fe xɔnɛ mɔɔli birin sɔtɔma nɛ mɛnni ɲɛ kɛmɛ naani bun ma. ");
INSERT INTO sus_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kɔnɔ n fama nɛ na bɔxikae makiitide, i bɔnsɔɛ findima konyie ra dɛnnaxɛ. Na dangi xanbi, i bɔnsɔɛ kelima nɛ naa, e fa naafuli xungbe xanin e xun ma. ");
INSERT INTO sus_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","I tan fama nɛ bɔɲɛsa sɔtɔde, i man simaya xɔnkuye sɔtɔma nɛ, han i sa ragatama tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Amorikae xa yunubi na gbo yɛ tɛmui naxɛ, i bɔnsɔɛ tolontolonyie fama gbilende kelife e xa konyiya kui.» ");
INSERT INTO sus_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Soge to bara dula, kuye bara ifɔɔrɔ, tuuri nun tɛ naxa dangi sube bolonyie tagi. ");
INSERT INTO sus_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na lɔxɔɛ, Alatala naxa yi saatɛ tongo Iburama bɛ, «N bara yi bɔxi fi i bɔnsɔɛ ma, keli Misira xure ma, sa dɔxɔ Efirati xure belebele ra.» ");
INSERT INTO sus_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Si dɔxɔ wuyaxi nan nu na na bɔxi ma. Na sie nan ya: Keni, Kenisi, Kadamon, ");
INSERT INTO sus_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Xiti, Perisi, Refa, ");
INSERT INTO sus_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaan, Girigasa, nun Yebusu. ");
INSERT INTO sus_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi mu nu di yo bari a xa mɔri Iburama bɛ. Konyi ginɛ Misiraka nu na Sarayi yi ra, naxan xili Hagara. ");
INSERT INTO sus_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi naxa a fala Iburama bɛ, «I bara a to, Alatala mu di bari fe ragirixi n tan ma. Kɔnɔ tɛmunde n nɔma di sɔtɔde n ma konyi ginɛ saabui ra i bɛ. Wo xa lu yire keren to kɔɛ ra.» Iburama naxa tin Sarayi xa wɔyɛnyi ra. ");
INSERT INTO sus_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarayi naxa a xa konyi ginɛ Hagara Misiraka tongo, a naxa a so a xa mɔri Iburama yi ra, a xa findi a xa ginɛ ra. Iburama nu bara ɲɛ fu raba Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iburama nun Hagara naxa xi yire keren, na nan findi Hagara bɛ tɛɛgɛ ra. Hagara to bara a kolon a a bara tɛɛgɛ, a naxa yo a kanyi ma, a naxa a mato mato ki kobi ra. ");
INSERT INTO sus_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi naxa a fala Iburama bɛ, «I tan nan a niyaxi yi bɔtɛ raba xa ilan n na! N tan nan n ma konyi ginɛ fixi i ma a xa findi i xa ginɛ ra. Kabi a naxa a kolon a furuxi, a fa fe kobi nan tun ilanma n na. Alatala xa won tan firinyi makiiti.» ");
INSERT INTO sus_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iburama naxa a xa ginɛ yaabi, «I xa konyi ginɛ na a ra. I wama fe naxan birin xɔn ma, i xa na raba a ra.» Sarayi naxa a waxɔnfe kobi birin naba Hagara ra, han a naxa a gi. ");
INSERT INTO sus_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Alatala xa malekɛ naxa Hagara li dulonyi nde fɛ ma Suru kira xɔn ma gbengberen yire. ");
INSERT INTO sus_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malekɛ naxa Hagara maxɔrin, «Sarayi xa konyi ginɛ Hagara, i kelixi minden? I sigafe minden?» Hagara naxa malekɛ yaabi, «N nan n gixi n kanyi nan ma.» ");
INSERT INTO sus_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Alatala xa malekɛ naxa a masen Hagara bɛ, «I man xa gbilen i kelide, i sa i magoro i kanyi bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Alatala xa malekɛ naxa a fala a bɛ, «N fama bɔnsɔɛ wuyaxi fide i ma, i mu nɔma naxan kɔnti kolonde.» ");
INSERT INTO sus_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Alatala xa malekɛ man naxa a fala a bɛ, «I tɛɛgɛxi nɛ yi ki. I fama di sɔtɔde. I na di xili sama nɛ Sumayila, barima Alatala bara i xui mɛ i xa marayaagi kui. ");
INSERT INTO sus_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","I xa di findima geresoe ra alɔ wulai soe a rabama ki naxɛ. A mixi birin gerema nɛ, birin a tan fan gerema nɛ. A xunyae fan a gerema nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagara naxa xili sa Alatala xun, naxan wɔyɛn a bɛ, «Alatala naxan n toxi.» A naxa a fala, «N bara n toma to.» ");
INSERT INTO sus_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Na nan a toxi e na kɔlɔnyi xili falama, «Ala ɲiɲɛ naxan n toxi.» Na kɔlɔnyi na Kadesi nun Bereda nan tagi. ");
INSERT INTO sus_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagara naxa di sɔtɔ Iburama bɛ. Iburama naxa a xili sa Sumayila. ");
INSERT INTO sus_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Iburama nu bara ɲɛ tongo solomasaxan nun senni sɔtɔ simaya ra, Hagara fa na di sɔtɔ a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Iburama to bara ɲɛ tongo solomanaani nun solomanaani sɔtɔ simaya ra, Alatala naxa mini a ma, a fa yi masen a bɛ, «N tan nan na Ala Sɛnbɛ Kanyi ra. I maɲɛrɛ n ya tode ra tinxinyi kui. ");
INSERT INTO sus_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","N fama nɛ saatɛ tongode won firin tagi. N fama bɔnsɔɛ gbegbe fide i ma.» ");
INSERT INTO sus_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iburama naxa a xinbi sin, a yatagi rafelen bɔxi. Alatala naxa a masen a bɛ, ");
INSERT INTO sus_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«N bara yi saatɛ tongo i bɛ. I fama nɛ findide si wuyaxi baba ra. ");
INSERT INTO sus_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","I xili mu falama sɔnɔn Iburama, i xili fama nɛ falade Iburahima, barima n i findima si wuyaxi baba nan na. ");
INSERT INTO sus_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","N fama nɛ i findide ɲama gbegbe baba ra. I fama nɛ die sɔtɔde naxee findima si wuyaxi ra, mangɛe fan fama nɛ minide i xa die ya ma. ");
INSERT INTO sus_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","N nan n ma saatɛ mabanbanma nɛ won firin tagi, hali i dangi xanbi, a nun i bɔnsɔɛ, gbilen nee fan bɔnsɔɛ bɔnsɔɛ. A findima saatɛ ra dan mu na naxan ma. Na kui, n tan nan na i Marigi Ala ra. N tan nan na i bɔnsɔɛ Marigi Ala ra, hali i dangi xanbi. ");
INSERT INTO sus_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","N fama nɛ yi bɔxi fide i tan nun i bɔnsɔɛ ma, wo faxi sabatide dɛnnaxɛ. Kanaan bɔxi birin findima nɛ wo gbe ra abadan. N tan nan na i bɔnsɔɛ Marigi Ala ra.» ");
INSERT INTO sus_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ala man naxa a masen Iburahima bɛ, «I tan nun i bɔnsɔɛ, gbilen na fan bɔnsɔɛ bɔnsɔɛ, wo lan nɛ wo xa n ma saatɛ ratinmɛ. ");
INSERT INTO sus_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Won ma saatɛ nan ya, n naxan saxi wo ma, wo lan wo xa naxan natinmɛ, i tan nun i bɔnsɔɛe: Naxan birin findixi xɛmɛ ra wo ya ma, e birin lan nɛ e xa sunna. ");
INSERT INTO sus_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Wo xa sunna findima saatɛ tɔnxuma nan na wo tan nun n tan tagi. ");
INSERT INTO sus_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Keli wo tan ma, a sa dɔxɔ wo bɔnsɔɛ bɔnsɔɛ ra, di xɛmɛ naxan birin barima, a lanma e xa sunna xi solomasaxan nde. Na sɛriyɛ lan nɛ a xa sa wo xa konyie ma naxee na wo yi ra, naxee barixi wo xɔnyi, a nun konyi naxee saraxi bɔxi gbɛtɛ ma, hali a mu fa na i bɔnsɔɛ xa ya ma. ");
INSERT INTO sus_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Na kui, konyi naxan barixi i xɔnyi a nun i na naxan fan sara, e birin lan nɛ e xa sunna alako n ma saatɛ tɔnxuma xa lu wo fate ma abadan. ");
INSERT INTO sus_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Xɛmɛ naxan na lu a fate mu sunna, a fama nɛ raminide a bɔnsɔɛ ya ma, barima a mu n ma saatɛ rakamalixi.» ");
INSERT INTO sus_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Na xanbi, Ala naxa a masen Iburahima bɛ, «I naxa Sarayi xili fala i xa ginɛ xun ma sɔnɔn de, a fa xili nɛ kɔrɛ Sara. ");
INSERT INTO sus_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","N barakɛ sama a xa fe, a fa di xɛmɛ bari i bɛ. N barakɛ sama nɛ Sara xa fe, a fama findide si gbegbe nga ra. Si dɔxɔ wuyaxi mangɛe fama nɛ minide a xa die ya ma.» ");
INSERT INTO sus_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iburahima naxa a yatagi rafelen bɔxi ma, kɔnɔ a naxa yele, a fa a fala a bɔɲɛ ma, «N tan naxan bara ɲɛ kɛmɛ sɔtɔ simaya ra, n nɔma di nde sɔtɔde sɔnɔn? Sara naxan bara ɲɛ tongo solomanaani sɔtɔ simaya ra, a fan nɔma di nde baride fa?» ");
INSERT INTO sus_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A naxa a fala Ala bɛ, «I ɲɛngi sa Sumayila xɔn ma. Na bara n wasa.» ");
INSERT INTO sus_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ala naxa a yaabi, «Ade! I xa ginɛ Sara fama di xɛmɛ baride i bɛ i naxan xili sama Isiyaga. N nan n ma saatɛ mabanbanma nɛ n tan nun a tan tagi, a nun a bɔnsɔɛ ra hali a faxa xanbi. Saatɛ nan na ki naxan mu kanama abadan. ");
INSERT INTO sus_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","N bara i xa maxandi suxu Sumayila xa fe ra. N barakɛ sama nɛ a xa fe, n man fa di gbegbe barife ragiri a ma, n bɔnsɔɛ wuyaxi fima nɛ a ma. A findima nɛ mangɛ di fu nun firin baba ra, a nun si xungbe kanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kɔnɔ, naxan findi n ma saatɛ ra, n fama a mabanbande n tan nun Isiyaga nan tagi, Sara fama di xɛmɛ naxan baride i bɛ tamuna yi waxati.» ");
INSERT INTO sus_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ala to gɛ na masenyi ra, a naxa keli Iburahima xun ma. ");
INSERT INTO sus_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Iburahima naxa a xa di Sumayila tongo, a nun a xa konyi naxee barixi a xɔnyi, a nun a naxee saraxi. Xɛmɛ naxan birin na a xa banxi kui, a naxa e birin sunna na lɔxɔɛ alɔ Ala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iburahima fan naxa sunna. Iburahima sunna tɛmui naxɛ, a ɲɛ tongo solomanaani a nun solomanaani nan nu na a ra. ");
INSERT INTO sus_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Sumayila sunnama tɛmui naxɛ, a ɲɛ fu nun saxan. ");
INSERT INTO sus_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","E naxa e birin sunna lɔxɔɛ keren, ");
INSERT INTO sus_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","a nun xɛmɛ naxan birin nu na Iburahima xa banxi kui, konyi naxee barixi a xɔnyi, a nun a naxee fan saraxi kelife si gbɛtɛe ma. ");
INSERT INTO sus_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Alatala mini nɛ Iburahima ma Mamire, wuri bili belebele na dɛnnaxɛ. Na tɛmui, Iburahima nu dɔxɔxi a xa kiri banxi sode dɛ ra kuyefure tɛmui yanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A to xɛmɛ saxan to fa ra, a naxa keli mafuren, a sa e ralan. A naxa a igoro e bɛ bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A naxa a masen e bɛ, «N Marigi, n bara wo maxandi, wo xa wo malabu n tan wo xa konyi xɔnyi, ");
INSERT INTO sus_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","n xa fa ye ra wo bɛ alako wo xa wo sanyie maxa. Wo man xa foye tongo yi wuri bun ma. ");
INSERT INTO sus_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","N xa fa taami ra wo xɔn ma alako wo nɔma sɛnbɛ sɔtɔde ki naxɛ. Na xanbi, wo fa siga wo xa ɲɛrɛ ra. Na kui wo a kolonma wo xa konyi nan n na.» Na xɔɲɛe naxa a ratin, «Won bara lan na ma. I naxan falaxi, a raba.» ");
INSERT INTO sus_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Na nan lan, Iburahima naxa gbilen mafuren a xa kiri banxi kui. A naxa a masen a xa ginɛ Sara bɛ, «I xulun. I farin fanyi sigaati ya tongo solofere yailan taami ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Na xanbi, a naxa a gi, a siga ninge gɔɔrɛ, a sa ninge sube bɔrɔxɔxi fate fanyi keren tongo. A naxa na ninge so a xa walikɛ yi ra, a xa a faxa, a xa a yailan donse ra. ");
INSERT INTO sus_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Na sube to bara gɛ ɲinde, Iburahima naxa a tongo, a a so xɔɲɛe yi ra, a nun xiɲɛ xinbeli nun xiɲɛ bɔnbɔxi. E na na donse donfe, Iburahima naxa ti e sɛɛti ma wuri bun ma. ");
INSERT INTO sus_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na xɔɲɛe naxa Iburahima maxɔrin, «I xa ginɛ Sara na minden?» A naxa e yaabi, «A na kiri banxi bun ma.» ");
INSERT INTO sus_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Na xɔɲɛ mixi keren naxa a masen Iburahima bɛ, «N man gbilenma tamuna yi ɲɔndɔn tɛmui. Na tɛmui i xa ginɛ fama di xɛmɛ baride i bɛ.» Sara nu tixi Iburahima xanbi ra kiri banxi sode dɛ ra, a tuli matixi e xa wɔyɛnyi ra. ");
INSERT INTO sus_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Iburahima nun Sara nu bara gɛ foride. Sara mu nu nɔma di baride sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara to na mɛ, a naxa yele a yɛtɛ ma, «N tan na ki naxɛ yi ki n bara gɛ tagande. N ma xɛmɛ fan bara findi xɛmɛ fori ra. Muxu tan di bari tɛmui bara dangi.» ");
INSERT INTO sus_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Alatala naxa a masen Iburahima bɛ, «Sara yelexi munfe ra? A a falaxi munfe ra, a tan mu nɔma di baride sɔnɔn, barima a bara gɛ tagande? ");
INSERT INTO sus_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Na fe na na Alatala mu nɔma naxan nabade? N na fa tamuna i xɔnyi be yi tɛmui, Sara fama nɛ di baride.» ");
INSERT INTO sus_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara naxa gaaxu, a naxa wule fala, «N mu yelexi de.» Alatala naxa a masen a bɛ, «Iyo, i yelexi nɛ!» ");
INSERT INTO sus_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na xɔɲɛe naxa ti kira xɔn ma, e naxa e xunsa Sodoma taa ma. Iburahima naxa siga e matide. ");
INSERT INTO sus_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Alatala naxa a masen, «N nɔma a nɔxunde Iburahima ma, n wama naxan nabafe? ");
INSERT INTO sus_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","A fama nɛ findide si belebele sɛnbɛma ra. N fama nɛ barakɛ sade si birin ma a tan saabui ra. ");
INSERT INTO sus_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","N na a sugandixi nɛ, alako a xa nɔ yaamari sade a xa die nun a bɔnsɔɛe ma, e xa nɔ e ɲɛngi sade n ma sɛriyɛ xɔn ma tinxinyi kui. Na tɛmui, n tan Alatala, n fama nɛ n ma laayidi rakamalide n naxan tongoxi Iburahima bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Alatala naxa a masen Iburahima bɛ, «Fe naxan falaxi Sodomakae nun Gomorakae xun, fe magaaxuxi na a ra. E xa yunubi bara gbo han, ");
INSERT INTO sus_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","n fama gorode n xa sa a mato fe naxan birin falaxi e xun ma, xa a na na ki nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Xɔɲɛ firin naxa keli e nu na dɛnnaxɛ, e naxa siga Sodoma. Kɔnɔ Alatala nun Iburahima naxa lu yire keren. ");
INSERT INTO sus_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Iburahima naxa a maso Alatala ra, a naxa a masen a bɛ, «Alatala, i fama nɛ mixi kobi nun mixi tinxinxi birin sɔntɔde? ");
INSERT INTO sus_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tɛmunde mixi tongo suuli na Sodomakae ya ma naxee findixi mixi matinxinxie ra. I fama nɛ na taa kanade? I mu nɔma diɲɛde Sodoma ɲama ma na mixi matinxinxi tongo suuli xa fe ra? ");
INSERT INTO sus_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ade, a mu lan i xa mixi kobi nun mixi tinxinxi faxa ki keren. A mu lan kiiti keren xa sa mixi kobi nun mixi tinxinxi ma. A mu lan i xa na raba. Naxan duniɲa birin makiitima, a rabama nɛ tinxinyi kira ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Alatala naxa yaabi ti, «Xa n mixi matinxinxi tongo suuli li Sodoma taa kui, n fama nɛ diɲɛde Sodoma mixi birin ma na mixi tongo suuli xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iburahima man naxa wɔyɛnyi tongo, «N Marigi, n bara i maxandi i xa nɔ diɲɛde n bɛ, n xa nɔ yi masenyi tide i bɛ, ba n tan kelixi xube nun bɛndɛ nɛ. ");
INSERT INTO sus_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","I sa a lima mixi tongo suuli xa mu mixi matinxinxi ra, tɛmunde fo mixi tongo naani a nun suuli. Na mixi suuli naxan luma na ki, i fama nɛ na taa kanade nee xa fe ra?» Alatala naxa a masen, «N mu na kanama xa n mixi matinxinxi tongo naani a nun suuli li naa.» ");
INSERT INTO sus_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iburahima man naxa a maxɔrɔxɔ, «Tɛmunde i mixi tongo naani nan lima naa.» Alatala naxa a masen, «N mu fama na kanade na mixi tongo naani xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iburahima naxa a fala, «N Marigi, n bara i maxandi, i naxa xɔnɔ xa n man fa wɔyɛnyi nde masen i bɛ. Tɛmunde i fama mixi tongo saxan nan lide naa.» Alatala naxa a masen a bɛ, «N mu fama na kanade xa n mixi matinxinxi tongo saxan li naa.» ");
INSERT INTO sus_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iburahima naxa a masen, «Marigi i xa i haakɛ to n bɛ n ma bɔɲɛ xɔrɔxɔɛ ma. Tɛmunde wo mixi mɔxɔɲɛn nan lima naa.» Alatala naxa a masen, «N mu fama na taa kanade na mixi mɔxɔɲɛn xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iburahima man naxa a fala, «N Marigi, n bara i maxandi, i naxa xɔnɔ. N ma maxɔrinyi dɔnxɔɛ nan yi ki i bɛ. Tɛmunde, i mixi fu nan lima naa.» Alatala naxa a masen Iburahima bɛ, «N mu fama na taa kanade na mixi fu xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E to gɛ na masenyi ra, Alatala naxa siga, Iburahima fan naxa gbilen a xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nunmare tɛmui, na malekɛ firinyie naxa so Sodoma. Loti nu dɔxɔxi na taa sode dɛ ra. A to malekɛe to fa ra, a naxa keli a sa e ralan kira ra. A naxa a igoro bɔxi ma e bɛ. ");
INSERT INTO sus_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Loti naxa a masen e bɛ, «N bara wo maxandi wo xa tin n xa wo yigiya n xɔnyi. Wo nɔma wo sanyie maxade, wo wo malabu. Tina gɛɛsɛgɛ wo kurun wo xa biyaasi ra.» Malekɛe naxa a yaabi, «Ade! Fo muxu xa xi taa tagi nɛ to kɔɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kɔnɔ Loti naxa a maxɔrɔxɔ han e naxa siga a xɔnyi. A naxa donse fanyi rafala e bɛ, a naxa taami lɛbinitare gan. E naxa e dɛge. ");
INSERT INTO sus_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sa tɛmui mu nu a lixi, Sodomakae naxa Loti xa banxi rabilin. Keli sɛgɛtalae ma, a sa dɔxɔ xɛmɔxie ra, e birin nu na naa. ");
INSERT INTO sus_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","E naxa Loti xili, e a maxɔrin, «Na mixie na minden, naxee soxi i xɔnyi to nunmare ra? E ramini muxu ma, muxu xa kafu yire keren.» ");
INSERT INTO sus_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti naxa mini a xa banxi kui, a ti naadɛ ra, a naadɛ ragali a xanbi ra. ");
INSERT INTO sus_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","A naxa a masen e bɛ, «Ade! N ngaxakerenyie, wo naxa fe ɲaaxi raba. ");
INSERT INTO sus_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","N ma di ginɛ firinyie na be naxee mu nu xɛmɛ fe kolon. N bara tin a ra n xa nee sa wo sagoe, wo xa wo waxɔnfe birin naba e ra, alako wo naxa sese raba n ma xɔɲɛe ra. N tan bara findi e yatigi ra.» ");
INSERT INTO sus_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na mixie naxa a fala Loti bɛ, «Mini muxu tagi. Xɔɲɛ nan i ra be. I mu nɔma kiiti sade muxu ma. Xa i mu i kata, muxu fama fe xɔnɛ dɔxɔde i ma dangife e tan na.» E naxa sonson Loti ma, alako e xa naadɛ kana. ");
INSERT INTO sus_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na malekɛ firinyie naxa Loti suxu, e naxa a raso banxi kui, e naadɛ balan e xun ma. ");
INSERT INTO sus_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Malekɛe naxa gali radɔnxu, naxee nu tixi naadɛ ra. Keli sɛgɛtalae ma, sa dɔxɔ xɛmɔxie ra, e mu nu sese toma fa. Kira naxa ifu e ma. ");
INSERT INTO sus_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Na malekɛ firinyie naxa Loti maxɔrin, «I xa mixi nde na be? I xa i xa di birin namini yi taa kui. I xabilɛ xa keli be, ");
INSERT INTO sus_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","barima muxu fafe yi taa kanade. Yi taakae xa wali kobi bara findi seedeɲɔxɔya ra Alatala bɛ. Alatala man muxu rasanbaxi nɛ, muxu xa fa yi taa kana.» ");
INSERT INTO sus_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Loti naxa siga a fala a xa die xa mɔrie bɛ, «Wo keli be mafuren! Alatala na fafe be kanade yakɔsi.» E naxa a maɲɔxun a na gbɛntɛnfe nɛ. ");
INSERT INTO sus_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Na subaxɛ ma, malekɛe naxa gbata Loti ra, e naxa a masen a bɛ, «Keli, i xa ginɛ tongo, a nun i xa di ginɛ firinyi naxee na be. Wo xa keli be alako wo naxa sɔntɔ a nun yi taa mixi kobie ra.» ");
INSERT INTO sus_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","A to nu wama bufe, malekɛe naxa Loti suxu a bɛlɛxɛ ma, a nun a xa ginɛ, sa a xa di ginɛ firinyie xun ma. E naxa e ramini taa kui, barima Alatala nu bara kinikini e ma. ");
INSERT INTO sus_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Malekɛe to e ramini, keren naxa a masen Loti bɛ, «I gi, alako i xa i nii ratanga. I naxa i kobe rato de! I naxa i mati yi taa yire yoe. Xa i mu wama i xa sɔntɔ, siga na geya yire.» ");
INSERT INTO sus_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti naxa a fala, «Ade, n Marigi, n bara i maxandi, n mu nɔma na rabade. ");
INSERT INTO sus_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","N a kolon, i bara hinnɛ i xa konyi di ra. I bara kinikini n ma a gbegbe ra. I bara n nii ratanga. Kɔnɔ, n tan mu nɔma n gide han geya ma, xa na mu a ra n faxama nɛ. ");
INSERT INTO sus_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","I bara na taa lanmadi to naxan makɔrɛxi won na? N nɔma na tan lide. A lu n xa siga naa, n nii xa ratanga. A mato, taa xurudi xa mu a ra?» ");
INSERT INTO sus_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malekɛ naxa a yaabi, «N bara tin na birin na. N mu na taa kanama. ");
INSERT INTO sus_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Siga mafuren. Han i sa soma tɛmui naxɛ, n mu fefe rabama.» Na taa xili saxi nɛ Sowari, barima a xurun. ");
INSERT INTO sus_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Soge nu tefe tɛmui naxɛ, Loti naxa so Sowari taa kui. ");
INSERT INTO sus_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Na tɛmui, Alatala naxa sooda nun tɛ ragoro Gomora taa nun Sodoma taa ma. ");
INSERT INTO sus_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A naxa na taae tuxunsan, keli sansie ma, a sa dɔxɔ mixie ra naxee birin sabatixi na taae kui. ");
INSERT INTO sus_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Loti xa ginɛ naxa a kobe rato, na nan lan a naxa findi fɔxɛ xuti ra. ");
INSERT INTO sus_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na subaxɛ ma, Iburahima naxa keli, a a xunsa yire ma a nun Alatala dɛ masara dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A to a ya rasiga Gomora nun Sodoma ma, a nun na rabilinyi birin, a naxa tuuri gbegbe to te ra. ");
INSERT INTO sus_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ala to na taae kana Loti nu sabatixi dɛnnaxɛ, a a ratanga na gbaloe ma Iburahima xa fe nan na. ");
INSERT INTO sus_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti nu bara gaaxu lufe ra Sowari taa kui. A naxa keli naa, a siga geya fari. A naxa sabati a nun a xa di ginɛ firinyie ra fɔnmɛ nde kui gɛmɛ longori ra. ");
INSERT INTO sus_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lɔxɔɛ nde, a xa di ginɛ singe naxa a fala a xunya bɛ, «Won baba bara fori. Won na dɛnnaxɛ yi ki, xɛmɛ yo mu na won dɔxɔma naxan xɔn alɔ adama darixi a ra ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Fa be, won xa won baba rasiisi alako won xa xi a xɔn ma, alako won xa di fi a ma naxan findima a bɔnsɔɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na kɔɛ ra, e naxa e baba rasiisi. A xa di ginɛ singe naxa xi a baba xɔn ma. A mu a xun ma fe yo kolon, a xa di sa tɛmui, nun a keli tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kuye to iba, a xa di ginɛ singe naxa a fala a xunya bɛ, «A bara ɲɔn, n tan nun n baba bara xi yire keren to. To kɔɛ ra, i nun won baba fama xide yire keren. Na tɛmui won nɔma bɔnsɔɛ fide a ma.» ");
INSERT INTO sus_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na kɔɛ man na, e naxa e baba rasiisi. A xunya fan naxa xi a baba xɔn ma. A mu a xun ma fe yo kolon, a xa di sa tɛmui, nun a keli tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Loti xa di ginɛ firinyie naxa furi tongo e baba xa di ma. ");
INSERT INTO sus_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Na di ginɛ singe to di bari, a xili naxa sa Mowaba. Na nan findi Mowabakae birin benba ra. Han yakɔsi e na na. ");
INSERT INTO sus_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A xa di ginɛ firin nde fan naxa di bari, a xili naxa sa Ben Ami. Na nan findi Amonikae birin benba ra. Han yakɔsi e na na. ");
INSERT INTO sus_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Iburahima naxa siga Negewi bɔxi ma, a sabati Kadesi nun Suru tagi. Na dangi xanbi a naxa siga Gerara, a saxanyi raba mɛnni. ");
INSERT INTO sus_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iburahima naxa a fala mɛnnikae bɛ a xa ginɛ Sara xa fe ra, «N xunya ginɛma nan a ra.» Na kui Gerara mangɛ Abimeleki naxa Sara tongo. ");
INSERT INTO sus_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kɔɛ to so, Ala naxa a masen Abimeleki bɛ xiye kui, «I fama nɛ faxade yi ginɛ xa fe ra, i naxan tongoxi, barima xɛmɛ taa idɔxɔɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Na tɛmui Abimeleki mu nu a makɔrɛxi a ra. A naxa a yaabi, «N Marigi, i fama nɛ si tinxinxi xa fe kanade? ");
INSERT INTO sus_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Iburahima a masen nɛ n bɛ, a yi ginɛ a xunya ginɛma nan lanxi a ma. Ginɛ fan naxa a fala n bɛ, a taara nan lanxi Iburahima ma. N naxan nabaxi, n na rabaxi n bɔɲɛ fiixɛ nan na.» ");
INSERT INTO sus_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ala man naxa a masen a bɛ na xiye kui, «N tan yati, n na kolon i fe naxan nabaxi, fe kobi xa mu a ra. N tan nan man a niyaxi, i mu nɔxi yunubi fe rabade n na. Na nan a toxi n mu a luxi i xa a findi i xa ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Yakɔsi, yi ginɛ ragbilen a xa mɔri ma. Namiɲɔnmɛ nan a ra. A fama nɛ Ala maxandide i bɛ, alako i nii ratangama ki naxɛ. Kɔnɔ xa i mu a ragbilen a xa mɔri ma, a kolon i fama nɛ faxade wo nun i xa denbaya birin.» ");
INSERT INTO sus_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki naxa keli sinnanyi ma, a naxa a xa konyie birin malan. Fe naxan birin dangixi, a na tagi raba e bɛ. Gaaxui gbegbe naxa e suxu. ");
INSERT INTO sus_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleki naxa Iburahima xili a xɔnyi. A naxa a maxɔrin, «N yunubi mundun nabaxi i ra, i xa nɔ n tan nun n ma ɲama findide yunubitɔɛ belebelee ra? I bara fe raba n na, fe naxan mu lan a xa raba. ");
INSERT INTO sus_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Munfe a niyaxi i na rabaxi?» ");
INSERT INTO sus_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iburahima naxa a yaabi, «N a fala nɛ mixi naxee birin na be, e mu gaaxuma Ala ya ra, e fama nɛ n faxade n ma ginɛ xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nɔndi nan a ra, n xunya nan man lanxi a ma. Muxu birin baba keren, kɔnɔ muxu nga keren mu a ra. Na nan a toxi a findixi n ma ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ala to bara n tongo n baba xɔnyi, n naxa a masen n ma ginɛ bɛ, ‹Won na siga dɛdɛ, yandi n bara i maxandi i xa a fala, n xunya nan lanxi i ma.›» ");
INSERT INTO sus_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleki naxa yɛxɛɛe, sie, ningee, nun konyie tongo, a naxa e birin so Iburahima yi ra. A man naxa a xa ginɛ Sara ragbilen a ma. ");
INSERT INTO sus_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A naxa a fala Iburahima bɛ, «N ma bɔxi bara rabi i bɛ. I na wa lufe dɛdɛ yi bɔxi ma, i xa lu naa.» ");
INSERT INTO sus_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A naxa a fala Sara bɛ, «I bara a to, n bara kɔbiri kole wulu firin so i taara yi ra, alako yaagi xa ba i ya ra, i tan nun i malan boore birin tagi. Na kui i xun nakeli sɔtɔma nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Iburahima to Ala maxandi, Ala naxa Abimeleki, a xa ginɛ, nun a xa konyie yalan, alako e man xa nɔ di baride. ");
INSERT INTO sus_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Alatala nu bara dibaritareɲa ragiri Abimeleki xa mixie ma Iburahima xa ginɛ Sara xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Alatala naxa hinnɛ Sara ra, a a xa laayidi rakamali a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara naxa tɛɛgɛ. A xa mɔri xa xɛmɛforiɲa kui, a naxa di bari Iburahima bɛ Ala waxati naxan fala a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iburahima naxa a xa di xili sa Isiyaga, Sara naxan sɔtɔxi a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","A naxa a xa di sunna a xi solomasaxan lɔxɔɛ alɔ Ala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iburahima nu bara ɲɛ kɛmɛ sɔtɔ simaya ra, Isiyaga barixi tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara naxa a fala, «Ala bara n nasɛɛwa. Mixi yo na n ma di Isiyaga barife mɛ, muxu birin sɛɛwama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A man naxa a fala, «Nde nu nɔma a falade Iburahima bɛ na tɛmui, lɔxɔɛ nde fama a lide, Sara findima nɛ dingɛ ra? Kɔnɔ n tan bara di fi a ma a xa xɛmɛforiɲa kui.» ");
INSERT INTO sus_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isiyaga to mɔ, e naxa a dɛ ba xiɲɛ ra. Iburahima naxa ɲɛlɛxin xulunyi belebele sa, a xa diyɔrɛ dɛ ba lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Na tɛmui Sara naxa Sumayila to yele ra, Misiraka Hagara di naxan barixi Iburahima bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara naxa a fala Iburahima bɛ, «Yi konyi ginɛ keri, a nun a xa di. Yi naxan yi ki, a mu lan a nun n ma di Isiyaga xa lu kɛ keren.» ");
INSERT INTO sus_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na wɔyɛnyi mu rafan Iburahima ma a xa di xa fe ra, ");
INSERT INTO sus_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","kɔnɔ Ala naxa a masen Iburahima bɛ, «I bɔɲɛ naxa raɲaaxu i ma i xa konyi ginɛ nun a xa di xa fe ra. Sara na fe naxan birin fala i bɛ, a birin naba a bɛ, barima Isiyaga nan fama findide i bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","N si fan naminima nɛ i xa konyi ginɛ xa di, barima i xa di nan lanxi a fan ma.» ");
INSERT INTO sus_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iburahima naxa keli subaxɛ ma. A naxa taami tongo a nun kiri gbɔnfɔɛ, ye na kui. A naxa na birin dɔxɔ Hagara xun ma, a naxa di so a yi ra, a fa e birin nasiga. Hagara naxa a xun ti gbengberen yire ra dɛnnaxɛ xili Beriseeba. ");
INSERT INTO sus_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ye to bara ɲɔn a xa kiri gbɔnfɔɛ kui, a naxa a xa di lu wuri nde bun ma. ");
INSERT INTO sus_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","A naxa siga, a sa dɔxɔ a xati ma yaamilɛ keren ɲɔndɔnyi. A naxa a fala, «N mu nɔma n ya tide n ma di ra, a xa faxa n ya xɔri.» A naxa siga a sa dɔxɔ a xati ma a nu wa ra. ");
INSERT INTO sus_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ala naxa na di wa xui mɛ koore ma. Ala xa malekɛ naxa Hagara xili, a naxa a maxɔrin, «Hagara munse i sɔtɔxi? I naxa gaaxu barima Ala bara i xa di wa xui mɛ koore ma. ");
INSERT INTO sus_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Keli, i xa mɛɛni i xa di ma, barima n fama a findide si belebele kanyi nan na.» ");
INSERT INTO sus_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ala naxa Hagara ya rabi, a naxa kɔlɔnyi nde to. A naxa kiri gbɔnfɔɛ tongo, a ye sa a kui, a nde fi a xa di ma. ");
INSERT INTO sus_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ala naxa a ɲɛngi sa Sumayila xɔn ma. A naxa mɔ, a sa sabati gbengberen yire, dɛnnaxɛ xili Paran. A naxa findi xali woli yi matinxinxi ra. ");
INSERT INTO sus_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A nga naxa Misira ginɛ keren fen a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na tɛmui Abimeleki nun a xa sɔɔri mangɛ Pikoli naxa a fala Iburahima bɛ, «I fefe yo rabama wo nun Ala na a ra. ");
INSERT INTO sus_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","I rakali n bɛ Ala xili ra, fa sa xili ma i mu fama n yanfade, i mu n ma die yanfama, i mu n ma mamadie fan yanfama. I xa fe fanyi raba n bɛ a nun yi bɔxi mixie bɛ i na dɛnnaxɛ, alɔ n na raba i bɛ ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iburahima naxa a yaabi, «N bara n kali Ala ra.» ");
INSERT INTO sus_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Iburahima naxa kɔrɔsi raba Abimeleki ra fe ma a xa mixie naxan niyaxi a ra, a xa kɔlɔnyi bafe a gbeɲa. ");
INSERT INTO sus_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki naxa a yaabi, «N mu a kolon naxan na fe rabaxi i ra. I mu yi wɔyɛnyi falaxi n bɛ, fo to n tan fa na kolon.» ");
INSERT INTO sus_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Na nan lan, Iburahima naxa yɛxɛɛe nun ningee fi Abimeleki ma, e xa saatɛ tongo e boore bɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iburahima naxa yɛxɛɛ solofere tongo, a naxa e sa a xati ma. ");
INSERT INTO sus_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki naxa a maxɔrin, «I na yɛxɛɛ solofere saxi a xati ma munfe ra?» ");
INSERT INTO sus_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iburahima naxa a yaabi, «N nee sofe nɛ i yi ra, alako i xa a kolon, fa sa xili ma, yi kɔlɔnyi naxan yi ki, n tan nan a gexi.» ");
INSERT INTO sus_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Na nan a toxi, na taa xili falama Beriseeba, barima na mixi firinyie e rakali e boore bɛ mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","E to na saatɛ tongo e boore bɛ Beriseeba, Abimeleki nun a xa sɔɔri mangɛ Pikoli naxa ti kira xɔn ma gbilenfe Filisita bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iburahima naxa tamare wuri bili keren si Beriseeba. A naxa Alatala maxandi a xili ra, Ala naxan na na. ");
INSERT INTO sus_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Iburahima ɲɛ gbegbe raba nɛ Filisita bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na fe dangi xanbi, Ala naxa Iburahima mato. A naxa a xili, «Iburahima.» Iburahima naxa a ratin, «N tan nan ya.» ");
INSERT INTO sus_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ala man naxa a masen a bɛ, «I xa di Isiyaga tongo, i xa di kerenyi, naxan nafanxi i ma, i xa a xanin bɔxi ma dɛnnaxɛ xili Moriya, geya fari n na dɛnnaxɛ masen i bɛ. I xa a fi n ma sɛrɛxɛ gan daaxi ra.» ");
INSERT INTO sus_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Subaxɛ ma Iburahima naxa keli, a naxa dɔxɔse yailan a xa sofale fari. A naxa a xa walikɛ firin tongo a nun a xa di Isiyaga. Iburahima naxa yege ibɔɔ naxan findima tɛ xuruse ra sɛrɛxɛ bade. A naxa biyaasi fɔlɔ sigafe ra yire Ala dɛnnaxɛ masenxi a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na xi saxan lɔxɔɛ, Iburahima ya naxa ti na yire makuye ra, a sigafe dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A naxa a fala a xa walikɛ firinyie bɛ, «Wo tan nun sofale xa lu be. N tan nun n ma di, muxu na sigafe geya fari salide. Na tɛmui muxu man gbilenma han be.» ");
INSERT INTO sus_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iburahima naxa na yege dɔxɔ a xa di Isiyaga xun ma. A man naxa tɛ wole nun finɛ xanin. E ɲɛrɛfe e firin. ");
INSERT INTO sus_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isiyaga naxa a baba Iburahima xili, «N baba.» A naxa a ratin, «N tan nan ya, n ma di.» Isiyaga naxa a baba maxɔrin, «N bara a to yege nun tɛ xuruse na won yi ra, kɔnɔ yɛxɛɛ na minden won naxan bafe sɛrɛxɛ ra?» ");
INSERT INTO sus_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iburahima naxa a yaabi, «N ma di, Ala yati nan yɛxɛɛ soma won yi ra, won naxan bama sɛrɛxɛ gan daaxi ra.» E ɲɛrɛfe e firin. ");
INSERT INTO sus_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","E to yire li Ala dɛnnaxɛ masenxi Iburahima bɛ, Iburahima naxa sɛrɛxɛbade yailan, a yege sa a fari. A naxa a xa di Isiyaga xiri, a a sa sɛrɛxɛbade kɔn na, na yege fari. ");
INSERT INTO sus_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Na xanbi, Iburahima naxa finɛ tongo, a naxa a bɛlɛxɛ itala a xa a xa di kɔn naxaba, ");
INSERT INTO sus_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","kɔnɔ Alatala xa malekɛ naxa a xili koore ma, «Iburahima, Iburahima!» Iburahima naxa a ratin, «N tan nan ya.» ");
INSERT INTO sus_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malekɛ naxa a fala, «Yi sɛgɛtala lu naa. I naxa fefe ɲaaxi yo raba a ra. N bara a kolon i gaaxuma Ala ya ra. N man bara la a ra, i mu tondixi i xa di kerenyi fide n ma sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iburahima naxa a ya ragbilen a xanbi ra, a naxa yɛxɛɛ kontonyi to sansi longori ra, a feri firinyi kankanxi sansi firi ra. A naxa siga, a sa na yɛxɛɛ kontonyi tongo, a fa a ra. A naxa na ba sɛrɛxɛ ra a xa di ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iburahima naxa na yire xili sa «Alatala mixi kima.» Na nan a toxi han yakɔsi a falama «Alatala mixi kima a xa geya fari.» ");
INSERT INTO sus_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Alatala xa malekɛ man naxa gbilen Iburahima xili ra koore ma. ");
INSERT INTO sus_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","A naxa a masen a bɛ, «N bara n kali n yɛtɛ ra, Alatala xa masenyi nan ya. I to bara yi raba, i mu tondi i xa di kerenyi ma n bɛ, ");
INSERT INTO sus_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","n barakɛ sama nɛ i ma. I bɔnsɔɛ wuyama nɛ alɔ tunbui naxee na koore ma, xa na mu a ra e gboma nɛ alɔ mɛyɛnyi naxan malanxi baa dɛ ra. I bɔnsɔɛ fama nɛ nɔde e yaxuie ra. ");
INSERT INTO sus_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","N fama nɛ barakɛ sade duniɲa si birin ma i bɔnsɔɛ saabui ra, barima i bara n xui ratinmɛ.» ");
INSERT INTO sus_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Iburahima naxa gbilen a xa konyie yire. E birin naxa siga Beriseeba, barima Iburahima nu sabatixi mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Na fe birin to dangi, Iburahima naxa a mɛ Milika die bari nɛ Iburahima xunya Naxori bɛ. ");
INSERT INTO sus_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","E xili nan ya: A xa di singe Usi, na xanbiratoe Busi, Arami baba Kemuweli, ");
INSERT INTO sus_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesede, Haso, Pilidasi, Yidilafi nun Betuweli. ");
INSERT INTO sus_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuweli findi Rebeka baba nan na. Na di solomasaxanyi, Milika nan nee bari Iburahima xunya Naxori bɛ. ");
INSERT INTO sus_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naxori xa konyi ginɛ nu xili nɛ Reyuma. A yi die nan bari: Teba, Gaxami, Taxasa, nun Maaka. ");
INSERT INTO sus_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara to ɲɛ kɛmɛ ɲɛ mɔxɔɲɛn a nun solofere nan sɔtɔ simaya ra, ");
INSERT INTO sus_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","a naxa laaxira Kiriyati Araba, Hebiron mabiri, Kanaan bɔxi ma. Iburahima naxa a xa ginɛ ɲɔn fe raba. ");
INSERT INTO sus_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Iburahima to gɛ wade a xa ginɛ bɛ, a naxa siga Xitikae xɔn ma, a a fala e bɛ, ");
INSERT INTO sus_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Xɔɲɛ nan lanxi n ma wo ya ma be. N bara wo maxandi, wo gaburi yire fi n ma, n nɔma n ma ginɛ ragatade dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xitikae naxa a yaabi, ");
INSERT INTO sus_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«I tuli mati muxu ra a fanyi ra. Ala xa mixi nan i ra muxu ya ma. I na wa i xa ginɛ ragatafe muxu xa gaburi yire yoe, i sago na a ra. Muxu tan ya ma be, mixi yo mu na naxan nɔma tondide i bɛ i xa ginɛ ragatade a xa gaburi yire.» ");
INSERT INTO sus_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iburahima naxa keli, a igoro bɔxi ma Xiti bɔnsɔɛ ya i, naxee nu sabatixi na bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A naxa a fala e bɛ, «Xa wo bara tin, n xa n ma ginɛ ragata wo xa bɔxi ma, wo xa n ma maxandi radangi Soxara xa di Eferon ma, ");
INSERT INTO sus_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","alako a xa Makipela fɔnmɛ so n yi ra gaburi ra naxan na a xa xɛ fɛ ma. N a kolon a tan nan gbe lanxi mɛnni ma. A xa na sara n ma wo ya xɔri, alako birin xa a kolon na bɔxi bara findi n ma mixi ragatade ra.» ");
INSERT INTO sus_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eferon Xitika nu tixi naa ɲama tagi. A naxa Iburahima yaabi a xui itexi ra, alako Xitika naxee birin nu malanxi taa sode dɛ ra, e xa nɔ a xa wɔyɛnyi ramɛde. ");
INSERT INTO sus_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","A naxɛ, «N baba, n bara i maxandi, i tuli mati n na. N bara na xɛ nun na fɔnmɛ fi i ma n bɔnsɔɛ ya xɔri. I xa i xa ginɛ ragata mɛnni.» ");
INSERT INTO sus_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iburahima man naxa a igoro bɔxi ma ɲama birin ya xɔri, ");
INSERT INTO sus_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","a a fala Eferon bɛ, «I xa i haakɛ to n bɛ. I xa xɛ masundi nan ya. Yandi, a rasuxu, alako n xa nɔ n ma ginɛ ragatade mɛnni.» ");
INSERT INTO sus_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eferon naxa a yaabi, ");
INSERT INTO sus_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«N baba, i tuli mati n na a fanyi ra. Bɔxi naxan sare lanma gbeti kilo naani nun a tagi, sese mu na ki i tan nun n tan tagi. I xa ginɛ ragata naa tun!» ");
INSERT INTO sus_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iburahima naxa tin na sare ra Xitikae ya xɔri. A naxa gbeti kilo naani nun a tagi maniya a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Na xɛ naxan na Makipela fɛ ma, Mamire sogetede biri, fɔnmɛ naxan na a nun wuri bili naxan birin sixi na naaninyi ra, ");
INSERT INTO sus_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","na birin naxa findi Iburahima gbe ra. Na Xitika naxee birin nu malanxi taa sode dɛ ra, e birin findixi na fe seede ra. ");
INSERT INTO sus_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Na birin dangi xanbi, Iburahima naxa a xa ginɛ Sara ragata na fɔnmɛ kui Makipela xɛ fɛ ma, naxan na Mamire yatagi Hebiron mabiri Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Na xɛ nun na fɔnmɛ naxa ba Xitikae gbeɲa, a findi Iburahima gbe ra, alako a xa nɔ a xa mixie ragatade mɛnni. ");
INSERT INTO sus_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na waxati Iburahima nu bara gɛ foride. Alatala nu bara barakɛ sa Iburahima xa fe birin. ");
INSERT INTO sus_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Iburahima naxa a masen a xa walikɛe xunyi bɛ, naxan a ɲɛngi saxi a harige birin xɔn ma, «I bɛlɛxɛ sa n tabe bun ma kali ki ma. ");
INSERT INTO sus_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","N fafe i rakalide koore nun bɔxi Marigi Alatala ra, alako i naxa Kanaan ginɛ fen n ma di bɛ n sabatixi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","A xɔli n ma i xa siga n bari bɔxi nan ma, i fa mɛnni ginɛ nde fen n bɔnsɔɛ ya ma n ma di Isiyaga bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A xa walikɛ naxa a yaabi, «Xa a sa li na ginɛ mu tin birade n fɔxɔ ra fafe yi bɔxi ma, n xa i xa di xanin i xa bɔxi ma, i kelixi dɛnnaxɛ?» ");
INSERT INTO sus_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iburahima naxa a yaabi, «I naxa n ma di ragbilen mɛnni de! ");
INSERT INTO sus_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Alatala naxan na koore ma, naxan n tongoxi n bari mixie ya ma, naxan n nakelixi n ma bɔxi ma, a fa a kali a yi bɔxi fima nɛ n bɔnsɔɛ ma, a tan yati fama nɛ a xa malekɛ xɛɛde i malife ra, alako i xa nɔ ginɛ tongode mɛnni n ma di bɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Xa na ginɛ mu fa sa tin birade i fɔxɔ ra, i fama nɛ ratangade n ma marakali ma, i naxan tongoxi n bɛ. Kɔnɔ i naxa n ma di xanin mɛnni de!» ");
INSERT INTO sus_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Na walikɛ naxa a bɛlɛxɛ sa a marigi Iburahima tabe bun ma, a naxa a rakali. ");
INSERT INTO sus_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A naxa ɲɔxɔmɛ fu tongo Iburahima xa ɲɔxɔmɛ gɔɔrɛ ya ma, a kote gbegbe sa e fari. A naxa keli, a siga Naxori xa taa Padan Arami bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Iburahima xa walikɛ to mɛnni li, a naxa ɲɔxɔmɛe ragoro taa fari ma kɔlɔnyi nde sɛɛti ma. Nunmare tɛmui nan nu a ra, ginɛe minima ye bade tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A naxa Ala maxandi, «N marigi Iburahima Marigi Alatala, n bara i maxandi alako n ma ɲɛrɛ xa findi n bɛ xun nakeli ra to lɔxɔɛ. I man xa hinnɛ n marigi Iburahima ra. ");
INSERT INTO sus_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","I bara n to n na kɔlɔnyi sɛɛti ma, taa ginɛ dimɛe na fafe ye bade. ");
INSERT INTO sus_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","N fama nɛ ginɛ dimɛ nde maxɔrinde a xa a xa ye base so n yi ra, n xa ye min. Xa a sa n yaabi, ‹Ye min, n xa ye so i xa ɲɔxɔmɛe fan yi ra,› n fama nɛ a kolonde na tɛmui, i na ginɛ yati nan sugandixi i xa konyi Isiyaga bɛ. Na tɛmui n fama a kolonde i bara hinnɛ n marigi Iburahima ra.» ");
INSERT INTO sus_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Beenun a xa gɛ na wɔyɛnyi ra, na nan lan Betuweli xa di ginɛ Rebeka naxa fa. Iburahima xunya Naxori xa mamadi nan lanxi a ma. A xa fɛɲɛ dɔxɔxi a tunki fari. ");
INSERT INTO sus_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ginɛ dimɛdi tofanyi nan nu a ra, naxan mu xɛmɛ fe kolon. A naxa goro kɔlɔnyi yire, a naxa a ye base rafe ye ra, a man naxa te. ");
INSERT INTO sus_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iburahima xa walikɛ naxa a gi a sa a ralan. A naxa a fala a bɛ, «N bara i maxandi, a lu n xa ye nde min, naxan na i xa fɛɲɛ kui.» ");
INSERT INTO sus_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A naxa a yaabi, «N ba, ye min.» A naxa a xa fɛɲɛ ragoro a tunki fari, a ye so a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A to gɛ na ra, a naxa a fala a bɛ, «N ye bama nɛ i xa ɲɔxɔmɛe fan bɛ, alako e birin xa ye min a fanyi ra.» ");
INSERT INTO sus_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mafuren, a naxa a xa fɛɲɛ ibagan kuurɛ kui, a man a gi sigafe kɔlɔn dɛ ra a xa ye gbɛtɛ ba. A naxa ye ba han ɲɔxɔmɛ birin naxa wasa. ");
INSERT INTO sus_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Iburahima xa walikɛ nu fa a maɲɔxun, «Tɛmunde Alatala bara n ma biyaasi sɔɔnɛya n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ɲɔxɔmɛe to bara gɛ ye minde, Iburahima xa mixi naxa ɲɔɛrasoe xɛɛma daaxi so Rebeka ɲɔɛ ra, naxan xa binyɛ giramu senni lima. A man naxa bɛlɛxɛrasoe firin xɛɛma daaxie so a bɛlɛxɛ ra, naxan keren xa binyɛ dangi giramu kɛmɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A naxa ginɛdimɛdi maxɔrin, «Nde xa di lanxi i ma? Yandi, a fala n bɛ, i baba nɔma muxu yigiyade to kɔɛ ra?» ");
INSERT INTO sus_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka naxa a yaabi, «Betuweli xa di nan lanxi n ma, Milika nun Naxori xa mamadi.» ");
INSERT INTO sus_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","A man naxa a fala, «Muxu xɔnyi sɛxɛ nun ɲooge gbegbe na na, yigiya fan na na wo luma dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Iburahima xa walikɛ naxa a igoro bɔxi ma Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A naxa a fala, «N marigi Iburahima Marigi Alatala, n bara i tantu. I mu tagan hinnɛde n marigi Iburahima ra, i xa lanlanteya mu kana. Alatala n xun tixi n marigi Iburahima xabilɛ nan xɔnyi ra.» ");
INSERT INTO sus_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka naxa siga a gi ra a nga yire, alako fe naxan dangixi, a xa a tagi raba a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka taara Laban naxa a xulun sigafe ra kɔlɔn yire, Iburahima xa walikɛ nu tixi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban nu bara a maaginɛ to, ɲɔɛrasoe a ɲɔɛ ra, bɛlɛxɛrasoe a bɛlɛxɛ ra. A man nu bara a xa dɛntɛgɛ mɛ, xɛmɛ naxan falaxi a bɛ. Na kui, a naxa siga na xɛmɛ ralande kɔlɔnyi fɛ ma, ɲɔxɔmɛe nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban naxa a fala a bɛ, «Alatala bara baraka sa i tan naxan ma fe, i tixi be munfe ra, dɛnnaxɛ makuya taa ra? I xa so n xɔnyi. N bara banxi yailan i yigiya ra, n bara yire rafala i xa ɲɔxɔmɛe luma dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Iburahima xa walikɛ naxa so Laban xɔnyi. Laban naxa ɲɔxɔmɛe xa kote ragoro, a fa donse so e yi ra, a yire yailan e bɛ. A naxa ye fan so Iburahima xa mixie yi ra, alako e xa e sanyie maxa. ");
INSERT INTO sus_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Laban to fa donse ra e bɛ, Iburahima xa walikɛ naxa a fala, «N mu n dɛgema sinden, fo n xa n dɛntɛgɛ wo bɛ.» Laban naxa a fala a bɛ, «Awa yire, dɛntɛgɛ sa.» ");
INSERT INTO sus_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Iburahima xa walikɛ naxa a masen, «N tan nan na Iburahima xa walikɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Alatala bara barakɛ sa n marigi Iburahima xa fe ki fanyi. A bara findi banna ra, barima Alatala bara xuruse mɔɔli birin fi a ma, a nun gbeti, xɛɛma, konyie, ɲɔxɔmɛe, nun sofalee. Alatala bara na birin fi a ma. ");
INSERT INTO sus_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","N marigi Iburahima xa ginɛ Sara bara di fan bari a bɛ a xa foriɲa kui. Iburahima a harige birin fixi na di nan ma.» ");
INSERT INTO sus_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","«Iburahima n nakalixi nɛ, ‹I naxa ginɛ tongo n ma di bɛ naxan findi Kanaanka ra n sabatixi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","I xa siga n baba bariboore yire n xabilɛ tagi, alako i xa ginɛ tongo n ma di bɛ mɛnni.› ");
INSERT INTO sus_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","N marigi to na fala n bɛ, n naxa a maxɔrin, ‹Xa na ginɛ fa tondi birade n fɔxɔ ra go?› ");
INSERT INTO sus_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A naxa n yaabi, ‹N ɲɛrɛma Alatala naxan ya i, a fama a xa malekɛ birade i fɔxɔ ra i xa ɲɛrɛ kui alako a xa sɔɔnɛya. I fama nɛ ginɛ tongode n ma di bɛ n xabilɛ tagi n baba xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","I na siga n xabilɛ ra, xa e mu fa sa ginɛ dimɛdi so i yi ra feo, i bara ratanga n ma marakali ma.›» ");
INSERT INTO sus_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«N to kɔlɔn yire li, n naxa Ala maxandi, ‹Alatala, n marigi Iburahima naxan batuma, n bara i mayandi i xa n ma biyaasi sɔɔnɛya. ");
INSERT INTO sus_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","I ya ti n na yi kɔlɔnyi sɛɛti ma. N fama nɛ ginɛ dimɛdi nde maxɔrinde naxan fafe ye bade, a xa ye so n yi ra naxan na a xa fɛɲɛ kui alako n xa a min. ");
INSERT INTO sus_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Xa a n yaabi, «Ye min, n ye bama nɛ i xa ɲɔxɔmɛe fan bɛ, e min,» n a kolonma na tɛmui, Alatala na ginɛ dimɛdi yati nan sugandixi n marigi Iburahima xa di bɛ.›» ");
INSERT INTO sus_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Beenun n xa gɛ na wɔyɛnyi raɲɔnde n yɛtɛ ma, na nan lan Rebeka naxa fa, fɛɲɛ dɔxɔxi a tunki fari. A naxa goro kɔlɔnyi ra, a ye ba. N naxa a fala a bɛ, ‹N bara i maxandi, n ki ye, n xa a min.› ");
INSERT INTO sus_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A naxa a xa fɛɲɛ ragoro mafuren a tunki fari, a naxa a fala n bɛ, ‹Ye min. I na gɛ ye minde n ye soma nɛ i xa ɲɔxɔmɛe fan yi ra.› ");
INSERT INTO sus_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","N naxa a maxɔrin, ‹Nde xa di na i ra?› A naxa n yaabi, ‹Betuweli xa di ginɛ nan n na, Naxori nun Milika xa mamadi.› Na kui n naxa xɛɛma so a ɲɔɛ ra, n naxa xɛɛma bɛlɛxɛrasoe so a bɛlɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","N naxa n igoro bɔxi ma Alatala bɛ. N naxa n marigi Iburahima Marigi Alatala tantu, barima a bara n xun ti n marigi xunya xa di ginɛma ra, n xa a futi a xa di bɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Yakɔsi, Laban, a fala n bɛ xa i bara tin fe fanyi nun fe tinxinxi rabafe n marigi bɛ. Xa na mu a ra n sigama nɛ yire gbɛtɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban nun Betuweli naxa a yaabi, «Alatala nan yi fe ragirixi. Muxu mu fama na maxɔrɔxɔde. ");
INSERT INTO sus_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka nan tixi i ya i yi ki. A xanin i xun ma, alako a xa findi i marigi xa di xa ginɛ ra, alɔ Alatala a masenxi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Iburahima xa walikɛ to na wɔyɛnyi mɛ, a naxa a igoro bɔxi ma Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Na xanbi, a naxa bunse gbeti daaxi, bunse xɛɛma daaxi, a nun dugie fi Rebeka ma. A naxa sanbɛ fanyie fi Rebeka nga nun a taara fan ma. ");
INSERT INTO sus_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Na dangi xanbi, Iburahima xa walikɛ nun a xa mixie naxa e dɛge, e min, e fa so e sade. E to keli gɛɛsɛgɛ, Iburahima xa walikɛ naxa a masen Rebeka nga nun a taara bɛ, «Wo a lu fa n xa gbilen n marigi xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","E naxa a fala, «Rebeka xa xi fu ɲɔndɔn naba be sinden, na tɛmui wo fa siga.» ");
INSERT INTO sus_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Iburahima xa walikɛ naxa e yaabi, «Wo naxa n makankan be. Alatala bara n ma biyaasi sɔɔnɛya. Wo a lu fa n xa gbilen n marigi xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","E naxa a fala, «Won xa Rebeka xili, won xa a kolon ɲanige naxan na a bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","E naxa Rebeka xili, e naxa a maxɔrin, «I wama sigafe wo nun yi xɛmɛ ra?» Rebeka naxa e yaabi, «Iyo, n wama sigafe.» ");
INSERT INTO sus_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Na kui e naxa e xunya Rebeka nun a mɛɛnima so Iburahima xa walikɛ nun a xa mixie yi ra. ");
INSERT INTO sus_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","E naxa duba Rebeka bɛ a falafe ra, «Muxu xunya nan lanxi i ma. Ala xa i findi ɲama gbegbe barima ra. I bɔnsɔɛ xa nɔ i yaxuie ra.» ");
INSERT INTO sus_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka nun a xa ginɛe naxa dɔxɔ ɲɔxɔmɛe fari, e naxa bira Iburahima xa walikɛ fɔxɔ ra. E birin naxa siga. ");
INSERT INTO sus_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isiyaga nu bara keli kɔlɔn yire naxan xili «Ala ɲiɲɛ naxan n toxi.» A nu bara sabati Negewi bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lɔxɔɛ nde, Isiyaga to mini a maɲɛrɛde daaxa nunmare tɛmui, a naxa Iburahima xa walikɛ xa ɲɔxɔmɛe to fa ra. ");
INSERT INTO sus_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka to bara Isiyaga to, a naxa goro ɲɔxɔmɛe fari, ");
INSERT INTO sus_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","a fa walikɛ maxɔrin, «Nde na na xɛmɛ ra naxan sa fafe na ki, keli daaxa longori ra won nalande?» ");
INSERT INTO sus_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Iburahima xa walikɛ naxa a yaabi, «N marigi nan a ra.» Na nan lan, Rebeka naxa a ya makoto a xa mafelenyi ra. Iburahima xa walikɛ naxa dɛntɛgɛ sa Isiyaga bɛ, a fe naxan birin nadangixi. ");
INSERT INTO sus_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na xanbi, Isiyaga naxa Rebeka xanin a nga xa kiri banxi kui, a a findi a xa ginɛ ra. Isiyaga naxa a xanu a bɔɲɛ birin na, han a nga xa faxɛ sunnunyi naxa ba a ma. ");
INSERT INTO sus_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iburahima man naxa ginɛ gbɛtɛ dɔxɔ naxan xili Ketura. ");
INSERT INTO sus_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Na ginɛ naxa die bari a bɛ. Na die nu xili: Simiran, Yokosan, Medan, Madiyan, Yisebaki, nun Suwa. ");
INSERT INTO sus_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokosan naxa Seeba nun Dedan bari. Dedan bɔnsɔɛ findi Asurikae, Letusikae, nun Leyumikae nan na. ");
INSERT INTO sus_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan xa die lanxi Efa, Efere, Hanoki, Abida, nun Elidaa nan ma. Ketura xa die nan lanxi e ma. ");
INSERT INTO sus_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Iburahima naxa a harige birin fi Isiyaga ma. ");
INSERT INTO sus_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A naxa se gbegbe fan fi a xa ginɛ booree xa die ma, a fa e makuya a xa di Isiyaga ra, a e rasiga bɔxi nde ma naxan na sogetede mabiri. ");
INSERT INTO sus_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iburahima xa simaya naxa siga han ɲɛ kɛmɛ ɲɛ tongo solofere nun suuli. ");
INSERT INTO sus_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Na xanbi, a naxa faxa hɛɛri kui, a a benbae li aligiyama. ");
INSERT INTO sus_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A xa die Isiyaga nun Sumayila naxa a ragata Makipela fɔnmɛ kui, Soxara Xitika xa di Eferon xa bɔxi ma Mamire fɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iburahima na bɔxi sara Xitikae bɔnsɔɛ nan ma. E nun a xa ginɛ Sara, e birin nagataxi mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Iburahima faxa xanbi, Ala naxa barakɛ sa a xa di Isiyaga ma. A nu sabatixi kɔlɔnyi fɛ ma, naxan xili «Ala ɲiɲɛ naxan n toxi.» ");
INSERT INTO sus_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Xilie nan ya naxee findi Sumayila bɔnsɔɛ ra. Sara nu bara a xa konyi ginɛ Misiraka Hagara fi Iburahima ma. Hagara naxa Sumayila sɔtɔ di ra. ");
INSERT INTO sus_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Sumayila xa die nan ya, e barixi ki naxɛ e boore fɔxɔ ra: Nebayoti, Sumayila xa di singe, Kedari, Adabeeli, Mibisami, ");
INSERT INTO sus_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO sus_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadada, Tema, Yeturi, Nafisi, nun Kedema. Na di fu nun firinyi findi Sumayila xa die nan na. ");
INSERT INTO sus_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na mixi keren keren ma findi bɔxi mangɛe nan na. E naxa e xilie sa e xa taae xun ma a nun e xa mixie. ");
INSERT INTO sus_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumayila xa simaya dan ɲɛ kɛmɛ ɲɛ tongo saxan nun solofere nɛ. A naxa laaxira, a sa a benbae li aligiyama. ");
INSERT INTO sus_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sumayila bɔnsɔɛ nu sabatixi bɔxi nan ma, dɛnnaxɛ nu na Hawila nun Suru tagi. Suru ya rafindixi Misira nan ma Asuri kira ra. E nu sabatixi e ngaxakerenyie nan sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isiyaga xa taruxui nan ya: Isiyaga findi Iburahima xa di nan na. ");
INSERT INTO sus_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","A to bara ɲɛ tongo naani sɔtɔ simaya ra, a naxa Rebeka dɔxɔ, Laban xunya ginɛma, Betuweli xa di ginɛ. Aramikae nan na e ra, kelife Padan Arami. ");
INSERT INTO sus_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kɔnɔ Rebeka mu nu nɔma di baride Isiyaga bɛ. Isiyaga naxa Alatala maxandi a xa ginɛ xa fe ra a xa nɔ di baride. Alatala naxa a xa duba suxu, Rebeka naxa tɛɛgɛ. ");
INSERT INTO sus_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Na die nu fa gere e nga tɛɛgɛ. A naxa a yɛtɛ maxɔrin, «Munfe rabafe n bɛ yi ki?» Na kui a naxa siga Alatala maxɔrinde. ");
INSERT INTO sus_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Alatala naxa a masen a bɛ, «Si dɔxɔ firin nan na i tɛɛgɛ. Keren sɛnbɛ gboma nɛ boore bɛ. Taara nan fama lude a xunya xa nɔɛ bun ma.» ");
INSERT INTO sus_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A di bari tɛmui to a li, Rebeka naxa gulie bari. ");
INSERT INTO sus_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A xa di singe findixi mixi gbeeli nan na. Fate maxabe gbegbe kanyi nan nu a ra. E naxa a xili sa Esayu. ");
INSERT INTO sus_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na xanbi a xunya fan naxa bari. A bɛlɛxɛ raxutuxi a taara tingilinyi ma. E naxa a fan xili sa Yaxuba. Isiyaga na die barima tɛmui naxɛ, a nu na ɲɛ tongo senni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Na di xɛmɛ firinyi naxa mɔ. Esayu naxa findi koyinma fanyi ra naxan nu wula i sama. Naxan findi Yaxuba tan na, mixi maxinbelixi nan nu a ra, a tan nu dɔxɔma kiri banxi nan bun ma. ");
INSERT INTO sus_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esayu nan nu rafan Isiyaga ma, barima a nu fama sube ra a bɛ. Yaxuba tan nu rafan Rebeka nan ma. ");
INSERT INTO sus_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lɔxɔɛ nde Yaxuba nu bara supi yailan. Esayu naxa so, a taganxi kelife koyinde. ");
INSERT INTO sus_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A naxa a fala a bɛ, «N mu nɔma fefe ra yi ki. A lu n xa yi supi gbeeli nde min.» Na nan toxi a Edon xili naxa sa a xun ma, na nan na ki «a gbeeli.» ");
INSERT INTO sus_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaxuba naxa a yaabi, «I xa foriɲa tide fi n ma sinden.» ");
INSERT INTO sus_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esayu naxa a masen, «N na faxafe, kaamɛ nan na n ma yi ki. Na foriɲa tide munse fanma n ma?» ");
INSERT INTO sus_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaxuba man naxa a fala, «Fo i xa i kali.» Esayu naxa a kali a a bara a xa foriɲa tide fi a ma. ");
INSERT INTO sus_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaxuba naxa taami nun na toge supi nde so a yi ra. Esayu to gɛ a dɛgede, a a min, a naxa siga. Esayu mu tide yo toxi a xa foriɲa ma. ");
INSERT INTO sus_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kaamɛ naxa so bɔxi kui, bafe kaamɛ singe ra naxan naba Iburahima xa waxati. Isiyaga naxa siga Filisita mangɛ Abimeleki xɔnyi, naxan nu na Gerara. ");
INSERT INTO sus_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Alatala naxa mini Isiyaga ma, a a masen a bɛ, «I naxa siga Misira bɔxi ma de. I xa lu bɔxi ma n na dɛnnaxɛ masen i bɛ. ");
INSERT INTO sus_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Lu be. Won birin na a ra. N barakɛ sama nɛ i xa fe, barima n fama yi bɔxi fide i tan nun i bɔnsɔɛe nan ma. N laayidi naxan tongo i baba Iburahima bɛ, n na rakamalima nɛ. ");
INSERT INTO sus_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","N i bɔnsɔɛ rawuyama nɛ alɔ tunbui naxee na koore ma. N yi bɔxi fima nɛ i bɔnsɔɛ ma. N barakɛ sama nɛ duniɲa si birin ma i bɔnsɔɛ saabui ra. ");
INSERT INTO sus_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Iburahima n xui ramɛ nɛ. A naxa a ɲɛngi sa n ma sɛriyɛ, n ma mangɛya, n ma yaamarie, nun n ma tɔnyie xɔn ma.» ");
INSERT INTO sus_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Na kui Isiyaga naxa sabati Gerara. ");
INSERT INTO sus_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mixi naxee dɔxɔxi mɛnni, nee naxa a maxɔrin a xa ginɛ xa fe ma. A naxa e yaabi, a a xunya ginɛma nan lanxi a ma. A mu suusa a falade e bɛ, a xa ginɛ nan lanxi Rebeka ma alako mɛnni mixie naxa fa a faxa. A bara gaaxu a falade a xa ginɛ na a ra barima Rebeka ginɛ tofanyi nan nu lanxi a ma. ");
INSERT INTO sus_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isiyaga to bara bu naa, lɔxɔɛ nde Filisitakae xa mangɛ Abimeleki naxa a ya ramini wundɛri ra, a naxa a to Isiyaga na Rebeka mafurukufe. ");
INSERT INTO sus_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki naxa a xili a xɔnyi. A naxa a fala a bɛ, «I xa ginɛ yati nan lanxi yi ma! Munfe ra i fa a fala muxu bɛ i xunya ginɛma nan a ra?» Isiyaga naxa a yaabi, «N nu gaaxuxi nɛ wo naxa fa n faxa. Na nan a to n naxa na fala.» ");
INSERT INTO sus_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki man naxa a maxɔrin, «I munse rabaxi muxu ra yi ki? Xa mixi nde fa mini n ma ɲama ya ma go, a naxa i xa ginɛ findi a yɛtɛ ra? Na tɛmui i bara muxu ratantan.» ");
INSERT INTO sus_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleki naxa yaamari fi a xa ɲama birin ma, «Mixi yo na din yi xɛmɛ nun a xa ginɛ ra, n na kanyi faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Na ɲɛ ra, Isiyaga naxa xɛ sa na bɔxi ma. A to na xɛ xaba, a naxa a xa sansi wolixi ɲɔndɔn kɛmɛ sɔtɔ, barima Alatala bara barakɛ sa a xa fe. ");
INSERT INTO sus_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A harige xun naxa masa, a findi banna ra. ");
INSERT INTO sus_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yɛxɛɛ, si, ninge, nun konyi gbegbe nu na a yi ra. Na kui Filisitakae naxa Isiyaga tɔɔnɛ. ");
INSERT INTO sus_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Filisitakae naxa kɔlɔnyi birin nafe bɛndɛ ra, Isiyaga baba Iburahima xa konyi naxee ge Iburahima xa waxati. ");
INSERT INTO sus_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki naxa a fala Isiyaga bɛ, «Fo i xa keli be. I bara sɛnbɛ sɔtɔ dangi muxu tan na.» ");
INSERT INTO sus_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isiyaga naxa keli naa, a sa sabati Gerara gulunba kui. ");
INSERT INTO sus_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isiyaga naxa kɔlɔnyie iba, naxee nu gexi a baba waxati, Filisitakae naxee dɛsɛ Iburahima faxa xanbi. A baba nu na kɔlɔnyie xili falama ki naxɛ, Isiyaga man naxa na xilie fala e xun ma. ");
INSERT INTO sus_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isiyaga xa konyie man naxa kɔlɔnyi gbɛtɛ ge na gulunba yire, dulonyi fa mini a kui. ");
INSERT INTO sus_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerara xa xuruse dɛmadonyie nun Isiyaga xa xuruse dɛmadonyie naxa kɔnɲɛ na kɔlɔnyi xa fe ra. E birin nu fa a fala e boore bɛ, «Muxu tan nan gbe na na kɔlɔnyi ra.» Isiyaga naxa na kɔlɔnyi xili fala «sɔnxɔɛ,» barima sɔnxɔɛ bara bira a xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A xa konyie man naxa kɔlɔnyi gbɛtɛ ge, sɔnxɔɛ man naxa bira na fan xa fe ra. A naxa a xili fala Sitina, na nan na ki «galanbui kɔlɔnyi.» ");
INSERT INTO sus_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isiyaga naxa keli naa, a sa kɔlɔnyi ge yire gbɛtɛ. Na kɔlɔnyi to ge, sɔnxɔɛ mu bira na tan xa fe ra. A naxa a xili fala Rehoboti kɔlɔnyi, na nan na ki «makuye kɔlɔnyi,» barima a naxɛ, «Alatala bara won makuya bekae ra alako won ma fe xa sɔɔnɛya yi bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isiyaga to keli mɛnni sigafe ra Beriseeba, ");
INSERT INTO sus_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Alatala naxa mini a ma kɔɛ ra. A naxa a masen a bɛ, «I baba Iburahima Marigi Ala lanxi n tan nan ma. I naxa gaaxu fefe ra, won tan nan a ra yire birin. N man barakɛ sama nɛ i xa fe. N i bɔnsɔɛ rawuyama nɛ n ma konyi Iburahima xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isiyaga naxa sɛrɛxɛbade yailan na yire, a nu fa Alatala maxandi a xili ra. A naxa sabati naa, a xa konyie man naxa kɔlɔnyi gbɛtɛ ge. ");
INSERT INTO sus_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki boore Ahusati, nun a xa sɔɔri mangɛ Pikoli naxa keli Gerara, e siga Isiyaga yire. ");
INSERT INTO sus_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaga naxa e maxɔrin, «Wo faxi n yire munfe ra yi ki? Wo bara n naɲaaxu han wo bara n keri wo xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","E naxa a yaabi, «Muxu bara a kolon Alatala xa mixi nan lanxi i ma. Muxu man bara a maɲɔxun, fo won xa saatɛ tongo won boore bɛ marakali ra. ");
INSERT INTO sus_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","I rakali muxu bɛ, i mu fama fe xɔnɛ rabade muxu ra, barima muxu fan mu fe kobi yo rabaxi i ra, fo fe fanyi. Muxu man naxa i lu, i xa siga bɔɲɛsa kui. Yakɔsi Alatala bara barakɛ sa i ma.» ");
INSERT INTO sus_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isiyaga naxa donse gbegbe yailan e bɛ. E birin naxa e dɛge, e naxa e min. ");
INSERT INTO sus_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kuye to iba, e naxa e rakali e boore bɛ. Isiyaga naxa a ɲungu e ma, e naxa fatan lanyi kui. ");
INSERT INTO sus_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na lɔxɔɛ kerenyi, Isiyaga xa konyie naxa kɔlɔnyi nde xa fe dɛntɛgɛ sa a bɛ e naxan gexi. E naxɛ, «Muxu bara ye li na kɔlɔnyi ra.» ");
INSERT INTO sus_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isiyaga naxa na kɔlɔnyi xili fala Siba kɔlɔnyi, na nan falaxi «marakali.» Na nan a toxi muxu yi taa xili falama han yakɔsi Beriseeba, na nan falaxi «marakali kɔlɔnyi.» ");
INSERT INTO sus_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esayu to ɲɛ tongo naani rakamali, a naxa Beeri xa di Yudita nun Elon xa di Basamati dɔxɔ. Na firinyi Xitikae nan na e ra. ");
INSERT INTO sus_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","E naxa Isiyaga nun Rebeka bɔɲɛ raɲaaxu e ma. ");
INSERT INTO sus_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isiyaga nu bara gɛ foride, a yae nu bara rafɔɔrɔ. A mu nɔma sese tode fa. A naxa a xa di singe Esayu xili, «N ma di!» Esayu naxa a ratin, «N tan nan ya!» ");
INSERT INTO sus_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isiyaga naxa a fala a bɛ, «I bara a to, n bara gɛ foride. N mu a kolon n faxama tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tanbɛ sase nun xali tongo, i xa siga wulai sube fende n bɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","I xa na sube ɲin alɔ a rafanxi n ma ki naxɛ. I xa fa a ra n xɔn ma, alako n xa nɔ dubade i bɛ beenu n xa faxa.» ");
INSERT INTO sus_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Na tɛmui Rebeka tixi a tuli matixi Isiyaga ra, a naxan falaxi Esayu bɛ. Esayu naxa siga wulai sube bunde a baba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka naxa a fala a xa di Yaxuba bɛ, «N bara i baba xui mɛ a yi wɔyɛnyi falama Esayu bɛ, ");
INSERT INTO sus_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Sa sube bun n bɛ, i xa a ɲin a fanyi ra, n xa a don. N na gɛ na sube donde, n dubama i bɛ Alatala ya i beenun n xa faxa.› ");
INSERT INTO sus_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Yakɔsi, n ma di, i tuli mati n na a fanyi ra. N naxan falama i bɛ, i xa a raba. ");
INSERT INTO sus_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Siga gɔɔrɛ, i xa fa si fanyi firin na. N xa e ɲin a fanyi ra alɔ i baba wama a xɔn ma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","N na gɛ na ra, i xa a xanin i baba xɔn ma, alako a xa duba i bɛ beenun a xa faxa.» ");
INSERT INTO sus_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaxuba naxa a nga Rebeka yaabi, «Esayu fate maxabe kanyi nan a ra. N tan fate maxabe mu na n bɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","N baba na n masuxu, a kolonma nɛ Esayu xa mu a ra, n findima wule falɛ nan na a tan bɛ. Beenun n xa duba sɔtɔ, n fama dankɛ nan sɔtɔde.» ");
INSERT INTO sus_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A nga naxa a fala, «Ade, na dankɛ xa gbilen n tan nan ma, n ma di. I naxan nabama, i tuli mati n na. Siga, i sa fa na si fanyi firinyie ra.» ");
INSERT INTO sus_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yaxuba naxa siga, a naxa fa si fanyi firinyie ra a nga xɔn ma. A nga naxa na donse yailan alɔ a rafanxi Isiyaga ma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Na xanbi, Rebeka naxa a xa di singe Esayu xa donma tongo, donma naxan fan a xa dugie ya ma banxi kui. A naxa na ragoro Yaxuba ma, a xa di firin nde. ");
INSERT INTO sus_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A naxa a xa di bɛlɛxɛe nun a kɔnyi masalaxunxi maxiri si kiri ra. ");
INSERT INTO sus_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A naxa sube nun taami so a xa di Yaxuba yi ra, a naxan yailanxi. ");
INSERT INTO sus_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Na tɛmui Yaxuba naxa siga a baba yire, a a fala a bɛ, «N baba, n tan nan ya.» A baba naxa a maxɔrin, «N ma di mundun lanxi i tan ma?» ");
INSERT INTO sus_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaxuba naxa a baba yaabi, «Esayu nan lanxi n ma, i xa di singe. I naxan maxɔrinxi n ma, n bara fa a ra. Yandi, keli, i dɔxɔ, i xa n ma sube yailanxi don. Na tɛmui i xa duba n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isiyaga naxa a fala a xa di bɛ, «N ma di, i yi sube toxi yi ikɔrɛxi ra di?» Yaxuba naxa a yaabi, «I Marigi Alatala nan yi fixi n ma sɔɔnɛya ra.» ");
INSERT INTO sus_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isiyaga naxa a fala Yaxuba bɛ, «N ma di, i maso n na, n xa i masuxu, alako n xa la a ra a n ma di Esayu yati nan i ra.» ");
INSERT INTO sus_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaxuba naxa a maso a baba ra. Isiyaga naxa a fate masuxu. A naxa a fala, «I xui maniya Yaxuba xui ra, kɔnɔ i bɛlɛxɛ tan Esayu bɛlɛxɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isiyaga mu nɔ Yaxuba kolonde, barima a bɛlɛxɛe nu maxirixi xabe ra, alɔ a taara Esayu na ki naxɛ. Na kui Isiyaga naxa duba Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isiyaga man naxa a maxɔrin, «N ma di Esayu yati nan i ra?» Yaxuba naxa a yaabi, «Iyo.» ");
INSERT INTO sus_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isiyaga naxa a fala, «Fa donse ra, i naxan yailanxi, n xa a don, n fa duba i bɛ.» Yaxuba naxa donse so a baba yi ra, Isiyaga naxa a don. Yaxuba naxa wɛni fan so a yi ra, a naxa na fan min. ");
INSERT INTO sus_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Na tɛmui, a baba Isiyaga naxa a fala a bɛ, «N ma di, i makɔrɛ n na, i xa findigilin n ma.» ");
INSERT INTO sus_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaxuba naxa a maso a ra, a naxa findigilin a ma. Isiyaga naxa a xa sose xiri mɛ. Na dangi xanbi, a naxa duba a bɛ. A naxa a masen, «Iyo, n ma di xiri luxi nɛ alɔ Alatala barakɛ saxi xɛ naxan ma. ");
INSERT INTO sus_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ala xa xini fi i ma naxan kelima koore ma. Ala xa bɔxi daxamui fi i ma. Ala xa barakɛ sa i xa xɛ ma. Ala xa wɛni gbegbe fi i ma. ");
INSERT INTO sus_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ala xa ɲama birin lu i sagoe. Ala xa si birin magoro i bɛ. I xa findi i ngaxakerenyie xa yarerati ra. E birin xa e magoro i bɛ. Mixi yo na i danka, na dankɛ xa gbilen a kanyi ma. Mixi yo na duba i bɛ, Ala xa barakɛ sa na kanyi ma.» ");
INSERT INTO sus_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isiyaga to bara gɛ dubade a bɛ, Yaxuba naxa mini. A mu bu, Yaxuba taara Esayu fan naxa so kelife sube fende. ");
INSERT INTO sus_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A fan naxa na sube yailan a fanyi ra alɔ a baba wama a xɔn ma ki naxɛ. A to fa a ra a baba xɔn, a naxa a fala a baba bɛ, «N baba, keli, i xa dɔxɔ, i sube don n naxan yailanxi i bɛ alako i xa duba n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A baba Isiyaga naxa a maxɔrin, «Nde na i tan na?» Esayu naxa a yaabi, «Esayu nan na n na, i xa di singe.» ");
INSERT INTO sus_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Na fe naxa Isiyaga ifu a fanyi ra. A fate birin naxa sɛrɛn a ma. A naxa a fala a bɛ, «Kɔnɔ nde tan faxi sube yailanxi ra n bɛ, n naxan donxi yakɔsi beenun i tan xa so be yi ki? N bara duba na kanyi bɛ. A tan nan fama barakɛ sɔtɔde.» ");
INSERT INTO sus_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esayu to a baba xa masenyi mɛ, a bɔɲɛ naxa mini, a naxa sɔnxɔɛ gbegbe rate. A naxa a baba mayandi, «N baba, duba n fan bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isiyaga naxa a yaabi, «I xunya bara n madaxu. N bara gɛ dubade a tan nan bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esayu naxa a fala, «A xili yati na a xun ma, Yaxuba, ‹mixi mayanfɛ›. A sanmaya firin nan ya a n mayanfama. A bara n ma foriɲa tide tongo. Yakɔsi a bara n ma dubɛ fan sɔtɔ.» Esayu man naxa a maxɔrin, «Dubɛ yo mu na i yi ra sɔnɔn, i lan i xa naxan naba n tan bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isiyaga naxa a masen Esayu bɛ, «N bara a tan findi i xunyi ra, n man bara a ngaxakerenyi birin so a yi ra e xa lu a bun ma. N bara barakɛ gbegbe fi a ma, a nun wɛni fanyi. N ma di, n nɔma munse rabade i tan bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esayu naxa a fala a baba bɛ, «Dubɛ keren peti nan na i yi ra? N baba, duba n tan fan bɛ.» A naxa wa a xui itexi ra. ");
INSERT INTO sus_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A baba Isiyaga naxa a yaabi, «A kolon, i mu fama bɔxi daxamui sɔtɔde, a nun xini naxan kelima koore ma. ");
INSERT INTO sus_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","I baloma i xa santidɛgɛma nan xun na. I fama walide i xunya xa nɔɛ nan bun ma, kɔnɔ yare i fama i yɛtɛ sɔtɔde. A na nɔɛ naxan sa i ma, i tondima nɛ a ra.» ");
INSERT INTO sus_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esayu nu a xunya Yaxuba rafenfe gere ra, a xa dubɛ sɔtɔfe xa fe ra e baba ra. Esayu naxa a fala a bɔɲɛ ma, «N baba xa ɲɔnfe na ba a ra tɛmui naxɛ, n Yaxuba faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka to bara a xa di singe Esayu xa natɛ tongoxi kolon, a naxa a xa di firin nde Yaxuba xili. A naxa a fala a bɛ, «I bara a to, i taara Esayu wama a gbeɲɔxɔfe i ma, a xa i faxa. ");
INSERT INTO sus_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yakɔsi n ma di, i tuli mati n na a fanyi ra. Keli be, i xa siga Xarani, n taara Laban xɔnyi. I xa sa lu naa. ");
INSERT INTO sus_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","I xa lu a xɔnyi yi saxanyi han beemanu i taara bɔɲɛ fama gorode tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","I taara bɔɲɛ na goro i ma tɛmui naxan ma, a na nɛɛmu i raba fɔxi ra, na tɛmui n nan ɲunguma i xa fa. N mu wama ganfe wo firinyi birin na lɔxɔɛ keren.» ");
INSERT INTO sus_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka naxa a fala Isiyaga bɛ, «N bɔɲɛ bara raɲaaxu n ma Xiti xa di ginɛe xa fe ra. Xa a sa li Yaxuba fan ginɛ tongo e ya ma yi bɔxi ma, na tɛmui tide yo mu na n tan ma fe ma sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isiyaga naxa Yaxuba xili, a duba a bɛ. A naxa a yamari, «I naxa ginɛ dɔxɔ de naxan findi Kanaanka ra. ");
INSERT INTO sus_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Keli, i xa siga Padan Arami, i nga baba Betuweli xɔnyi. Mɛnni i xa i nga taara Laban xa di ginɛ nde dɔxɔ. ");
INSERT INTO sus_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ala Sɛnbɛ Kanyi xa barakɛ sa i xa fe, a xa di gbegbe fi i ma, a xa i findi si gbegbe benba ra. ");
INSERT INTO sus_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ala xa barakɛ sa i xa fe, a nun i bɔnsɔɛ, alɔ a laayidixi Iburahima bɛ ki naxɛ, alako yi bɔxi xa findi i gbe ra, i saxanyi rabafe dɛnnaxɛ, Ala bɔxi naxan fi Iburahima ma.» ");
INSERT INTO sus_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Na kui Isiyaga naxa Yaxuba xɛɛ Padan Arami bɔxi ma Betuweli Aramika xa di Laban xɔnyi. Laban findixi Rebeka taara nan na, Yaxuba nun Esayu nga. ");
INSERT INTO sus_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esayu naxa a kolon a baba bara duba Yaxuba bɛ, a xɛɛfe Padan Arami a xa mɛnni ginɛ dɔxɔ. A man naxa kolon sɔtɔ a ma, a baba bara Yaxuba yamari a naxa Kanaan ginɛ dɔxɔ, ");
INSERT INTO sus_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaxuba fan bara a baba nun a nga xui ratinmɛ sigafe ra Padan Arami. ");
INSERT INTO sus_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Na kui Esayu naxa a fahaamu Kanaan ginɛ mu rafan a baba Isiyaga ma. ");
INSERT INTO sus_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Na na a ra a naxa siga Iburahima xa di Sumayila yire, a sa na xa di ginɛ Mahalata dɔxɔ, naxan findixi Nebayoti xunya ra. ");
INSERT INTO sus_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaxuba naxa keli Beriseeba sigafe ra Xarani. ");
INSERT INTO sus_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kɔɛ to so a ra kira i, a naxa a sa yire nde, a gɛmɛ findi a xa xunsase ra. ");
INSERT INTO sus_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kɔɛ ra a naxa xiye sa, samɛ tixi bɔxi fari a xunyi sa dɔxɔxi koore ra. Ala xa malekɛe nu tefe samɛ kɔn na, e man nu goro. ");
INSERT INTO sus_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Alatala nu tixi samɛ fuge ra. A naxa a masen Yaxuba bɛ, «N tan nan na i tanun Iburahima nun i baba Isiyaga Marigi Alatala ra. I saxi bɔxi naxan fari yi ki, n a fima nɛ i tan nun i bɔnsɔɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I bɔnsɔɛ fama nɛ wuyade alɔ xube. Wo xa bɔxi fama nɛ gbode kelife sogetede ma a sa dɔxɔ sogegorode ra, keli kɔɔla ma sa dɔxɔ yirefanyi ra. N fama hɛɛri fide si birin ma i tan nun i bɔnsɔɛ saabui ra. ");
INSERT INTO sus_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I siga dɛdɛ, won birin na a ra. N i kantama yire birin. N man i ragbilenma nɛ yi bɔxi ma. N mu i raboloma fefe ma. N nan n ma laayidi birin nakamalima nɛ i bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaxuba to xunu, a naxa a fala, «Yakɔsi n bara a kolon Alatala na be, kɔnɔ singe n mu nu a kolonxi.» ");
INSERT INTO sus_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A naxa gaaxu, a fa a fala, «Yire magaaxuxi nan na be ra. Be findixi Ala xa banxi naadɛ nan na, sigafe ra koore ma.» ");
INSERT INTO sus_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaxuba to keli subaxɛ ma, a naxa na gɛmɛ tongo a xunyi nu saxi naxan ma. A naxa a rakeli, a a ti tɔnxuma ra, a naxa ture maso gɛmɛ xunyi ma. ");
INSERT INTO sus_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A naxa na yire xili sa Beteli, «Ala xa banxi.» Beenun na xa raba, na yire xili nu falama nɛ Lusi. ");
INSERT INTO sus_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yaxuba naxa laayidi tongo Ala bɛ a falafe ra, «Xa Ala n kantama kira xɔn ma, a fa donse nun sose fi n ma, ");
INSERT INTO sus_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","n gbilen bɔɲɛsa kui n baba xɔnyi, na tɛmui n Alatala nan findima n Marigi Ala ra. ");
INSERT INTO sus_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","N bara yi gɛmɛ ti be tɔnxuma ra, yi yire xa findi Ala batude ra. Alatala, i harige naxan birin fima n ma, n farilɛ bama nɛ a ra, n na fi i ma.» ");
INSERT INTO sus_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Na dangi xanbi Yaxuba naxa a xa biyaasi dɛ idɔxɔ. A to bɔxi li naxan na sogetede, ");
INSERT INTO sus_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","a naxa kɔlɔnyi nde to wula i. Yɛxɛɛ nun si gɔɔrɛ saxan nu malanxi na kɔlɔnyi fɛ ma, kɔnɔ gɛmɛ xungbe nan nu kɔlɔnyi dɛ makotoxi. ");
INSERT INTO sus_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","E nu darixi naxan na, xuruse birin na malan na yire, xuruse dɛmadonyie na kɔlɔnyi dɛrakote gɛmɛ maɲindigilinma, a ba naa. Xuruse na gɛ ye minde, xuruse dɛmadonyie man nu gɛmɛ ragbilenma kɔlɔnyi dɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaxuba naxa xuruse dɛmadonyie maxɔrin, «N ngaxakerenyie, wo kelixi minden yi ki?» E naxa a yaabi, «Muxu kelixi Xarani nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A naxa e maxɔrin, «Wo Laban kolon, Naxori xa di xɛmɛ?» E naxa a yaabi, «Iyo, muxu a kolon.» ");
INSERT INTO sus_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A naxa e maxɔrin, «Tana mu na a ma?» E naxa a yaabi, «Sese mu a toxi. A xa di ginɛ Raxele nan fafe na ki e nun xurusee ra.» ");
INSERT INTO sus_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A naxa a fala e bɛ, «Won na yanyi nɛ yi ki. Xurusee malan tɛmui mu yi ki. Wo ye fi xurusee ma mafuren, wo man xa gbilen e ra e dɛmadonde.» ");
INSERT INTO sus_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","E naxa a yaabi, «Muxu mu nɔma fefe yo rabade yi ki, fo xuruse birin na malan. Na tɛmui, muxu fa yi gɛmɛ ba kɔlɔnyi dɛ ra naxan a makotoxi, muxu ye fi xuruse birin ma.» ");
INSERT INTO sus_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yaxuba to nu na wɔyɛnfe e bɛ, Raxele fan naxa fa a baba xa xurusee ra, barima xuruse dɛmadonyi nan nu lanxi a fan ma. ");
INSERT INTO sus_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaxuba to Raxele to fa ra, Yaxuba nga taara Laban xa di ginɛ, a nun a xa xurusee, a naxa a maso kɔlɔnyi ra. A naxa gɛmɛ ba kɔlɔnyi dɛ ra, a naxa ye fi Laban xa xuruse birin ma. ");
INSERT INTO sus_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaxuba naxa Raxele xɛɛbu sunbui ra, a nu wa a xui itexi ra. ");
INSERT INTO sus_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A naxa a fala Raxele bɛ, «I baba xunya xa di nan lanxi n ma, Rebeka xa di xɛmɛ.» Raxele to na mɛ, a naxa a gi rakɔɛ, a sa na tagi raba a baba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban to bara a xunya ginɛma xa di Yaxuba xa fe mɛ, a naxa siga a sa a ralan. A naxa findigilin a ma, a a xanin banxi. Yaxuba naxa dɛntɛgɛ sa Laban bɛ. ");
INSERT INTO sus_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban naxa a fala a bɛ, «Won birin wuli keren fasɛ keren.» Yaxuba naxa kike keren naba Laban xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Na lɔxɔɛ Laban naxa a fala Yaxuba bɛ, «N ma mamadi nan lanxi i ma, kɔnɔ sɛriyɛ yo mu a falaxi i xa wali n bɛ a fa lu n mu i sare fi. A fala n bɛ, a lanma n xa i sare fi naxan na.» ");
INSERT INTO sus_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na tɛmui di ginɛ firin nan nu na Laban yi ra. A xa di ginɛ singe xili nɛ Leya, a firin nde Raxele. ");
INSERT INTO sus_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ya nu xurun, kɔnɔ Raxele tan ginɛ tofanyi nan nu lanxi a ma. ");
INSERT INTO sus_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Raxele nan nu rafan Yaxuba ma ki fanyi ra. A naxa a fala Laban bɛ, «N ɲɛ solofere nan walima i bɛ, alako i xa i xa di ginɛ firin nde Raxele fi n ma.» ");
INSERT INTO sus_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban naxa a yaabi, «Beenun n xa n ma di fi mixi gbɛtɛ ma, n lan n xa a fi i tan nan ma. Lu n xɔnyi be.» ");
INSERT INTO sus_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaxuba naxa ɲɛ solofere wali raba Laban yi ra Raxele xa fe ra. Kɔnɔ na ɲɛ solofere lu nɛ a bɛ alɔ xi solofere gbansan, barima Raxele nu rafanxi a ma ki fanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Na ɲɛ solofere dangi xanbi, Yaxuba naxa a fala Laban bɛ, «N ma kɛrɛ tongoxi bara kamali. N ma ginɛ so n yi ra fa, n xa a findi n yɛtɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban naxa mɛnnika birin xili, e xa fa e dɛge, e xa ɲɛlɛxinyi xulunyi raba. ");
INSERT INTO sus_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nunmare ra, a naxa a xa di ginɛ singe Leya tongo, a naxa a xanin Yaxuba xɔn ma. Yaxuba naxa a findi a yɛtɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban naxa Silipa so a xa di Leya yi ra, a xa findi a xa konyi ra. ");
INSERT INTO sus_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kuye to iba, Yaxuba naxa a to Leya na a ra. A naxa a fala Laban bɛ, «I munse rabaxi n na yi ki? N mu walixi i bɛ Raxele xa fe xa ra? I n yanfaxi munfe ra?» ");
INSERT INTO sus_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban naxa a yaabi, «Muxu tan ma naamunyi mu tinma a ra di ginɛ firin nde xa dɔxɔ xɛmɛ taa, a singe mu xɛmɛ sɔtɔxi. ");
INSERT INTO sus_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Yi lɔxɔxunyi raba sinden wo nun Leya. Xa i man ɲɛ solofere wali raba n bɛ, n nan n ma di ginɛ firin nde fan fima nɛ i ma, a findi i xa ginɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaxuba naxa na raba. E nun Leya to lɔxɔxunyi raba yire keren, Laban naxa Raxele fan fi a ma, ");
INSERT INTO sus_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","a Bila so Raxele yi ra a xa findi a xa konyi ra. ");
INSERT INTO sus_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaxuba naxa Raxele findi a yɛtɛ ra, a a xanu dangife Leya ra. Na dangi xanbi a man naxa ɲɛ solofere wali raba Laban bɛ. ");
INSERT INTO sus_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Alatala to bara a to Leya mu gɛxi rafande Yaxuba ma alɔ Raxele, a naxa Leya findi dibari ra, a Raxele findi dibaritare ra. ");
INSERT INTO sus_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya naxa tɛɛgɛ, a di xɛmɛ bari. A naxa na di xili sa Ruben, a falafe ra, «Alatala bara n ma yaagi to. Yakɔsi n fa rafanma nɛ n ma xɛmɛ ma.» ");
INSERT INTO sus_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A man naxa tɛɛgɛ di firin nde ma. A to na di bari, a naxa a fala, «Alatala fan yati a kolon, n mu rafan n ma xɛmɛ ma. Na nan a toxi a yi di firin nde fan fixi n ma.» A naxa na di xili sa Simeyɔn. ");
INSERT INTO sus_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A man naxa tɛɛgɛ di saxan nde ma. A to a bari, a man naxa a fala, «Yi biyaasi, fo n xa rafan nɛ n ma xɛmɛ ma sɔnɔn, barima n bara di saxan sɔtɔ a bɛ.» Na nan a to, a naxa na di xili sa Lewi. ");
INSERT INTO sus_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A naxa tɛɛgɛ di naani nde ma. A to na fan bari, a naxa a fala, «Yi biyaasi n Alatala tantuma nɛ.» A naxa na di xili sa Yuda. A xa di barife dan na di naani nan ma. ");
INSERT INTO sus_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raxele to bara a to, a mu fa di barife, a naxa a taara tɔɔnɛ. A naxa a fala Yaxuba bɛ, «Di fi n fan ma, xa na mu a ra n faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaxuba naxa xɔnɔ a xa wɔyɛnyi ma. A naxa a fala a bɛ, «I tan a maɲɔxunxi nɛ a Ala na n tan nan na? Ala na a niyaxi i mu di barife!» ");
INSERT INTO sus_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Raxele naxa a yaabi, «N ma konyi ginɛ Bila tongo, alako a xa di bari n bɛ. A xa findi n ma saabui ra di barife ra.» ");
INSERT INTO sus_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Raxele naxa a xa konyi ginɛ tongo, a a so a xa xɛmɛ Yaxuba yi ra. E to kafu, ");
INSERT INTO sus_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila naxa tɛɛgɛ, a naxa di xɛmɛ bari Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raxele naxa a fala, «Ala bara n ma kiiti sa. A bara n ma wɔyɛnyi mɛ. Na nan a toxi a di fixi n ma.» A naxa na di xili sa Dana. ");
INSERT INTO sus_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raxele xa konyi ginɛ Bila man naxa tɛɛgɛ. A naxa di xɛmɛ firin nde bari Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raxele naxa a fala, «Ala bara n mali katɛ birin na alako n xa xun nakeli sɔtɔ n taara ginɛma xun ma.» A naxa a xa di xili sa Nafatali. ");
INSERT INTO sus_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya to bara a kolon a mu di barima fa, a naxa a xa konyi ginɛ Silipa tongo, a naxa a so Yaxuba yi ra a xa findi a xa ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silipa naxa di xɛmɛ bari Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya naxa a fala, «Hɛɛri bara fa n ma.» A naxa na di xili sa Gadi. ");
INSERT INTO sus_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa naxa di firin nde sɔtɔ Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya naxa a fala, «N bara ɲɛlɛxin. Yakɔsi, ginɛ birin bara a kolon n bara hɛɛri gbegbe sɔtɔ.» A naxa a xili sa Aseri. ");
INSERT INTO sus_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mɛngi xaba tɛmui to bara a li, Ruben naxa siga xɛ ma. A naxa bogise nde li naa, naxan xili marafanyi bogise. A naxa fa a ra a nga xɔn. Na nan lan Raxele naxa a fala Leya bɛ, «N bara i maxandi, i xa i xa di xa marafanyi bogise ndee fi n ma.» ");
INSERT INTO sus_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya naxa a yaabi, «I bara n ma xɛmɛ ba n yi ra. Na mu i wasaxi? I man waxi n ma di xa marafanyi bogise nan fan tongofe?» Raxele naxa a fala, «To kɔɛ ra, wo nun Yaxuba nan fama xide i xa di xa marafanyi bogise ɲɔxɔɛ ra.» ");
INSERT INTO sus_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaxuba to so nunmare ra kelife xɛ ma, Leya naxa a ralan. A naxa a fala a bɛ, «I xima n tan nan xɔn ma to kɔɛ ra. N bara to kɔɛ sare fi n ma di xa marafanyi bogise ra.» A tan nun Yaxuba naxa kafu na kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ala naxa Leya xa maxandi tongo, a naxa tɛɛgɛ. Na naxa findi a xa di suuli nde ra Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","A naxa a fala, «Ala bara n sare fi n ma konyi ginɛ sofe ra n ma xɛmɛ yi.» A naxa a xa di xili sa Isakari. ");
INSERT INTO sus_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya man naxa tɛɛgɛ di senni nde ma. A naxa na di bari Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya naxa a fala, «Ala bara n ki. Yi biyaasi n ma xɛmɛ n binyama nɛ, barima n bara di senni bari a bɛ.» A naxa na di xili sa Sabulon. ");
INSERT INTO sus_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Na xanbi a man naxa di ginɛ bari. A naxa a xili sa Dina. ");
INSERT INTO sus_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Na tɛmui Ala naxa a ɲɛngi rasiga Raxele xa fe xɔn. A naxa a xa kɔntɔfili mɛ, a a findi di bari ra. ");
INSERT INTO sus_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Raxele naxa tɛɛgɛ, a naxa di bari. A naxa a fala, «Ala bara n namini n ma yaagi kui.» ");
INSERT INTO sus_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A naxa na di xili sa Yusufu. Na xili yati nan findixi a xa maxandi ra, fa a falafe, «Alatala man xa di xɛmɛ gbɛtɛ fan fi n ma.» ");
INSERT INTO sus_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raxele to Yusufu bari, Yaxuba naxa a fala Laban bɛ, «A lu n xa gbilen n ma bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","A lu n xa n ma ginɛe xanin a nun n ma die, n walixi i bɛ naxee xa fe ra. I a kolon n wali naxan xasabi rabaxi i bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban naxa a fala a bɛ, «Yandi, xa n nafan i ma, i xa diɲɛ, i xa lu be. N bara a kolon sematoe saabui ra, Alatala barakɛ saxi n ma i tan nan xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","A fala n bɛ i wama wali sare naxan xɔn. N na fima nɛ i ma.» ");
INSERT INTO sus_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaxuba naxa a fala a bɛ, «I tan yɛtɛ yati a kolon n walixi i bɛ ki naxɛ han i xa gɔɔrɛ bara findi a ra. Na saabui kelixi n tan nan ma. ");
INSERT INTO sus_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Dondoronti nan nu na i yi ra beenu n xa fa, a gbegbe bara sa a xun ma. Alatala bara barakɛ sa i xa fe kabi n naxa so i xɔnyi. Yakɔsi, i mu a luma n xa wali nde raba n ma denbaya fan bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban naxa a maxɔrin, «A lan n xa yeri fi i ma?» Yaxuba naxa a yaabi, «I naxa sese fi n ma. Xa i bara tin fe ra n naxan falaxi i bɛ i xa a raba, n fan bara tin n ɲɛngi safe ra i xa gɔɔrɛ xɔn ma. ");
INSERT INTO sus_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","N sigama to, n xa i xa xuruse birin mato. Yɛxɛɛ nun si makatunxi birin ti sɛɛti keren, a nun naxee birin nafɔɔrɔxi. N masundi findima nee nan na. ");
INSERT INTO sus_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","N ma tinxinyi fama makɛnɛnde i fama xuruse matode tɛmui naxɛ. Si naxee birin mu makatunxi nun yɛxɛɛ yɔrɛ birin naxee mu fɔɔrɔ, nee bara findi muɲɛ ra n mabiri.» ");
INSERT INTO sus_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban naxa a fala, «N bara tin na ra. I naxan falaxi na ki, won bara lan na ma.» ");
INSERT INTO sus_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na lɔxɔɛ Laban naxa si xɛmɛe nun ginɛe mayegeti, sarinyi saxi naxee ma a nun naxee makatunxi. A man naxa yɛxɛɛ rafɔɔrɔxi mayegeti. A naxa na xuruse birin so a xa die yi ra. ");
INSERT INTO sus_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na xanbi a naxa nee xanin yire xi saxan ɲɛrɛ rabama dɛnnaxɛ kira xɔn e nun Yaxuba tagi. Yaxuba nu fa Laban xa xuruse dɔnxɔɛe dɛmadon. ");
INSERT INTO sus_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na tɛmui Yaxuba naxa wuri bili mɔɔli saxan salonyi xinde gira. A naxa e kobolee ba e ma yire nde alako sarinyi fiixɛ xa makɛnɛn. ");
INSERT INTO sus_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A naxa e sa xurusee ye minde alako xuruse xa e yae ti e ra e ye minma tɛmui naxɛ. Xurusee na siga ye minde, xuruse xɛmɛe xa te xuruse ginɛe ma salonyie ya i. ");
INSERT INTO sus_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Na nan a toxi, na xurusee naxa die bari, sarinyie nun katunyie na e ma. ");
INSERT INTO sus_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaxuba naxa na xuruse yɔrɛe sa e xati ma, kɔnɔ booree ti Laban xa xurusee ya ra sarinyi na naxee ma, a nun naxee mafɔɔrɔxi. Na ki a gɔɔrɛ firin nan yailanxi. A mu tin a gbe xa lu Laban xa xurusee ya ma. ");
INSERT INTO sus_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Xuruse sɛnbɛmae nu tema ginɛmae ma tɛmui naxɛ, Yaxuba naxa na salonyi mɔɔli sa xuruse ye minde alako e xa te ginɛe ma salonyie ya i. ");
INSERT INTO sus_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yaxuba mu nu na wali rabama xuruse xurie ra. Na nan a niyaxi xuruse xurie naxa findi Laban gbe ra, a sɛnbɛmae naxa findi Yaxuba gbe ra. ");
INSERT INTO sus_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Na kui Yaxuba bara findi bannamixi belebele ra. Xurusee, konyie, ɲɔxɔmɛe, nun sofale gbegbe bara lu a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Na tɛmui Yaxuba nu bara Laban xa di xɛmɛe xui mɛ e naxan falama, «Se naxan birin findixi won baba gbe ra, Yaxuba bara a birin tongo. Na nan a toxi a bara findi banna mixi ra.» ");
INSERT INTO sus_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaxuba yati naxa a kolon, a mu rafan Laban ma sɔnɔn alɔ singe. ");
INSERT INTO sus_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Alatala naxa a masen Yaxuba bɛ, «Gbilen i babae nun i baribooree xa bɔxi ma i kelixi dɛnnaxɛ. Won birin na a ra.» ");
INSERT INTO sus_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaxuba naxa Raxele nun Leya xili. E nu na a xa xurusee dɛmadonfe. ");
INSERT INTO sus_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A naxa a fala e bɛ, «N bara a kolon n mu rafan wo baba ma alɔ singe, kɔnɔ n baba Marigi Alatala bara hinnɛ n na. ");
INSERT INTO sus_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wo a kolon yati n bara wali wo baba bɛ n sɛnbɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","A bara n madaxu n wali sare masarafe dɔxɔ fu ra, kɔnɔ Ala mu tin a xa fe ɲaaxi raba n na. ");
INSERT INTO sus_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Xa wo baba fa a fala, ‹Katunyi na xuruse naxee ma, nee nan findima Yaxuba gbe ra,› xuruse birin di barima naxee makatunxi. Xa wo baba fa a fala, ‹Sarinyi na xuruse naxee ma, nee nan findima Yaxuba gbe ra,› xuruse birin di barima sarinyi na naxee ma. ");
INSERT INTO sus_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ala bara wo baba xa xurusee ba a yi ra, a naxa e fi n tan ma.» ");
INSERT INTO sus_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Yi xurusee nu tema e boore ma tɛmui naxɛ, n bara a to xiye kui, xuruse xɛmɛ naxee texi xuruse ginɛe ma, sarinyi nun katunyi na e birin ma. ");
INSERT INTO sus_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","N ma xiye kui, Ala xa malekɛ naxa n xili, ‹Yaxuba›. N naxa a ratin, ‹N tan nan ya.› ");
INSERT INTO sus_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A naxa a masen, ‹I ya rakeli, i xa a mato. Xuruse xɛmɛ naxee birin texi xuruse ginɛe ma, sarinyi nun katunyi na e ma, barima Laban naxan birin nabaxi i ra, n na toxi. ");
INSERT INTO sus_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","N tan nan na Ala ra naxan mini i ma Beteli, i gɛmɛ tixi tɔnxuma ra dɛnnaxɛ. Mɛnni i bara laayidi tongo n bɛ. Yakɔsi, keli yi bɔxi ma. I xa siga bɔxi ma i barixi dɛnnaxɛ.›» ");
INSERT INTO sus_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raxele nun Leya naxa Yaxuba yaabi, «Muxu baba mu kɛ yo luxi muxu tan bɛ. ");
INSERT INTO sus_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Xɔɲɛ xa mu na muxu ra muxu baba xɔnyi? A bara muxu mati, a man bara muxu xa kɔbiri fan don. ");
INSERT INTO sus_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ala harige naxan birin baxi muxu baba yi ra, a gbilenma nɛ muxu ma a nun muxu xa die. Yakɔsi Ala fe naxan birin masenxi i bɛ, na birin naba.» ");
INSERT INTO sus_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yaxuba naxa a xa ginɛe nun a xa die baki ɲɔxɔmɛe fari. ");
INSERT INTO sus_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A naxa a xa xuruse nun a harige birin xanin, a naxan sɔtɔ Padan Arami sigafe ra a baba Isiyaga xɔnyi Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban to siga a xa xurusee xabe maxabade e ma, Raxele nu bara a xa kuyee muɲa. ");
INSERT INTO sus_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaxuba fan Laban Aramika mayanfa nɛ, barima a siga nɛ a mu ɲungui rabira a ma. ");
INSERT INTO sus_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yaxuba naxa a gi, a nun se naxan birin findi a gbe ra. A to dangi Efirati xure ra, a naxa siga Galadi geya mabiri. ");
INSERT INTO sus_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A xi saxan lɔxɔɛ, mixi nde naxa a fala Laban bɛ a Yaxuba bara a gi. ");
INSERT INTO sus_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban naxa a ngaxakerenyie tongo, e naxa mini Yaxuba fende xi solofere bun ma. E naxa a li Galadi geya biri ra. ");
INSERT INTO sus_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kɔnɔ kɔɛ ra, Ala naxa mini Laban Aramika ma xiye kui. A naxa a masen a bɛ, «I yɛtɛ ratanga fe mɔɔli birin falafe ra Yaxuba bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban naxa Yaxuba li, a xa kiri banxi italaxi geya yire Galadi bɔxi ma. Laban nun a ngaxakerenyie fan naxa e gbe itala mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban naxa a fala Yaxuba bɛ, «I munse rabaxi yi ki? Munfe ra i n mayanfaxi, i fa n ma die xanin alɔ geelimanie? ");
INSERT INTO sus_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","I gixi nɔxunyi kui munfe ra? I bara yanfanteya niya n na. I mu i ɲungui rabira n ma. Xa i n nakolon nu, n xulunyi nan tima i bɛ, n i ti kira ra ɲɛlɛxinyi kui boote nun kɔra xui ra. ");
INSERT INTO sus_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kɔnɔ i tan mu tinxi yati n xa n ma die nun n ma mamadie sunbu. Xaxili fanyi mu na ki. ");
INSERT INTO sus_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","N nɔma fe kobi rabade wo ra, kɔnɔ i baba Marigi Alatala bara a masen n bɛ to kɔɛ ra, ‹I yɛtɛ ratanga fe mɔɔli birin falafe ra Yaxuba bɛ.› ");
INSERT INTO sus_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kɔnɔ i to gbataxi sigafe ra i baba xɔnyi, i n ma alae tan xaninxi i xun ma munfe ra?» ");
INSERT INTO sus_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaxuba naxa Laban yaabi, «N mu n ɲungu i ma, barima n gaaxu nɛ i fa i xa di ginɛe bafe n yi ra. ");
INSERT INTO sus_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kɔnɔ i na i xa alae to n ma mixi yo yi ra, n na kanyi faxama nɛ. I xa n ma kote birin mato won ngaxakerenyie ya xɔri. Naxan birin findixi i gbe ra, i xa a xanin.» Yaxuba mu nu a maɲɔxunma a Raxele nan a baba xa kuyee tongoxi. ");
INSERT INTO sus_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban naxa Yaxuba xa kiri banxi kui mato. A man naxa Leya xɔnyi, Leya xa konyi xɔnyi, nun Raxele xa konyi xɔnyi mato, kɔnɔ a mu a gbe se yo to naa. A to mini e xɔnyi, a naxa so Raxele xa kiri banxi kui. ");
INSERT INTO sus_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raxele yati nan yi kuyee tongo. A nu bara e nɔxun dɔxɔse bun ma naxan sama ɲɔxɔmɛ fari, a fa dɔxɔ a fari. Laban naxa kiri banxi kui mato, kɔnɔ a mu a gbe se yo toxi naa. ");
INSERT INTO sus_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raxele naxa a fala a baba bɛ, «N baba i naxa xɔnɔ n ma de, i na to n mu kelixi n ti. N na kike wali nɛ.» Laban fenyi mɔɔli birin ti nɛ, kɔnɔ a mu kuyee to. ");
INSERT INTO sus_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaxuba naxa xɔnɔ, a naxa wɔyɛn xɔnɛ fala Laban bɛ. A naxɛ, «N gbaloe mundun nabaxi, n sɛriyɛ mundun kanaxi naxan a niyama i xa mini n fende yi mɔɔli ra? ");
INSERT INTO sus_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","I bara n ma kote birin kui mato. I gbe see mundun toxi e kui? A masen n bɛ n ngaxakerenyie ya xɔri a nun i fan ngaxakerenyie ya xɔri alako e xa won makiiti. ");
INSERT INTO sus_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","N ɲɛ mɔxɔɲɛn nan nabaxi i xɔnyi, kɔnɔ i xa yɛxɛɛ nun si keren mu di barixi n yi ra a fa faxa. N man mu i xa xuruse kontonyi yo donxi. ");
INSERT INTO sus_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","N mu faxi xuruse ra i xɔn ma wulai subee naxan faxaxi. Xuruse naxee muɲaxi kɔɛ nun yanyi ra, n tan nan na kote birin tongoxi n yɛtɛ ra. I nu na birin maxɔrinma n tan nan ma. ");
INSERT INTO sus_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yanyi ra kuyefure naxa n tɔɔrɔ, kɔɛ ra xinbeli naxa n tɔɔrɔ, han n mu nu nɔma xide a fanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","N bara ɲɛ mɔxɔɲɛn naba i yi ra. N ɲɛ fu nun naani walixi nɛ alako n xa i xa di ginɛ firinyie dɔxɔ. N man naxa ɲɛ senni fan sa a fari i xa gɔɔrɛ kantafe ra. Kɔnɔ i bara n sare masara dɔxɔ fu. ");
INSERT INTO sus_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Xa n tanun Iburahima Marigi Ala mu n mali nu, Ala naxan nu n baba Isiyaga rasɛrɛnma, n sigama n bɛlɛxɛ igeli nan na nu. Kɔnɔ Ala bara n ma marayaagi to, a bara n ma tɔɔrɛ kolon. Yi kɔɛ dangixi a bara n ma kiiti sa.» ");
INSERT INTO sus_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban naxa Yaxuba yaabi, «I xa ginɛe nan lanxi n ma die ma, e xa die, won ma die nan e ra. Yi xurusee n gbe na e ra, i se naxan birin toxi yi ki, n tan nan gbe e ra. Kɔnɔ to xanbi, n nɔma munse rabade n ma die nun n ma mamadie bɛ? ");
INSERT INTO sus_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yakɔsi, won xa saata. Seede xa lu won tagi.» ");
INSERT INTO sus_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaxuba naxa gɛmɛ tongo, a naxa a ti saatɛ tɔnxuma ra. ");
INSERT INTO sus_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A naxa a fala a ngaxakerenyie bɛ e fan xa gɛmɛe matongo. E naxa e matongo, e e malan yire keren. E naxa e dɛge na gɛmɛ kotoxi sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban naxa na yire xili fala Yegara Sahaduta. Yi xili nan falaxi «koto seede» Arami xui ra. Yaxuba naxa na xili fala Galede. Yi xili nan falaxi «koto seede» Isirayila xui ra. ");
INSERT INTO sus_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban naxa a fala, «Yi gɛmɛ kotoxi naxan yi ki, a findixi seede nan na i tan nun n tan tagi.» Na nan a toxi be xili falaxi Galede, «seede gɛmɛ kotoxi.» ");
INSERT INTO sus_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Misipa xili fan saxi na yire nan xun. Na xili nan falaxi «ɲɛngi sa yire,» barima Laban a fala mɛnni nɛ, «Alatala xa a ɲɛngi sa won tan firinyi xa fe xɔn ma, hali won fatan xanbi. ");
INSERT INTO sus_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Xa i n ma die tɔɔrɔ, xa na mu a ra i ginɛ gbɛtɛe dɔxɔ, i xa ratu a ma a Ala nan findixi seede ra won tagi, adamadi xa mu a ra.» ");
INSERT INTO sus_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Na xanbi Laban naxa a fala Yaxuba bɛ, «I ya ti yi gɛmɛ kotoxi ra. Yi tɔnxuma gɛmɛ mato n naxan tixi won tagi. ");
INSERT INTO sus_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Yi gɛmɛ kotoxi nun yi tɔnxuma gɛmɛ findixi seede nan na. N mu lan n xa dangi be ra i xa fe ɲaaxi ra n furi kui. I fan mu lan i xa dangi yi gɛmɛ kotoxi nun yi tɔnxuma gɛmɛ ra n ma fe ɲaaxi ra i furi kui. ");
INSERT INTO sus_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Iburahima Marigi Ala nun Naxori Marigi Ala xa findi won tan firinyi makiitima ra.» Na tɛmui Yaxuba naxa a yɛtɛ rakali Ala ra, a baba Isiyaga gaaxuxi naxan ya ra. ");
INSERT INTO sus_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaxuba naxa sɛrɛxɛ ba geya yire. A naxa a ngaxakerenyi birin xili e xa e dɛge. E to gɛ e dɛgede, e naxa xi mɛnni na kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban to keli subaxɛ ma, a naxa findigilin a xa die nun a xa mamadie ma. A naxa duba e bɛ. Na xanbi, Laban naxa gbilen a xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaxuba to nu sigafe kira xɔn, Ala xa malekɛe naxa mini a ma. A to bara e to, a naxa a fala, «Ala xa yonkinde nan yi ki.» ");
INSERT INTO sus_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","A naxa yi yire xili sa Maxanayimi. ");
INSERT INTO sus_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yaxuba naxa xɛɛrae xɛɛ a taara Esayu xɔn ma Edon daaxa, Seyiri bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A naxa a fala e bɛ, «Wo yi nan falama n marigi Esayu bɛ, ‹I xa konyi di Yaxuba naxɛ, N bara bu Laban xɔnyi han ya. ");
INSERT INTO sus_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ningee, sofalee, yɛxɛɛe, nun sie nan n yi ra. Konyi xɛmɛe nun konyi ginɛe fan nan n yi ra. N marigi, n xɛɛrae xɛɛxi nɛ i xɔn ma alako i xa diɲɛ n bɛ.›» ");
INSERT INTO sus_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Na xɛɛrae to gbilen, e naxa a fala Yaxuba bɛ, «Muxu bara i taara Esayu to. A na fafe i yire, a nun gbangbalanyi mixi kɛmɛ naani.» ");
INSERT INTO sus_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Na masenyi naxa Yaxuba bɔɲɛ ramini. Ɲama naxan nu a fɔxɔ ra, a naxa e itaxun dɔxɔ firin. A naxa yɛxɛɛe nun sie itaxun dɔxɔ firin, a nun ningee nun ɲɔxɔmɛe. ");
INSERT INTO sus_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A naxa a fala, «Xa Esayu ɲama keren gere, ɲama boore xa nɔ a gide.» ");
INSERT INTO sus_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na xanbi Yaxuba naxa Ala maxandi, «N tanun Iburahima Marigi Ala, n baba Isiyaga Marigi Alatala, i a fala nɛ n bɛ, ‹Gbilen i xa bɔxi ma, i ngaxakerenyie yire. I na siga, n fe fanyi rabama nɛ i bɛ.› ");
INSERT INTO sus_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kɔnɔ yakɔsi n Marigi, n tan xurun yi fe sɔtɔfe ma i naxan nagirixi n ma. I bara i xui rasabati n tan bɛ i xa konyi. N ma yisuxuwuri gbansan nan nu suxuxi n yi ra n Yurudɛn igirima tɛmui naxɛ, kɔnɔ yakɔsi muxu nun ɲama firin nan gbilenfe. ");
INSERT INTO sus_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","N natanga n taara Esayu ma, barima n bara gaaxu a ya ra. N gaaxuxi nɛ a naxa fa n faxa, n tan nun dingɛe nun e xa die. ");
INSERT INTO sus_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I bara a masen n bɛ, ‹N fe fanyi rabama nɛ i bɛ. N i bɔnsɔɛ rawuyama nɛ alɔ mɛyɛnyi naxan kɔnti mu nɔma kolonde baa dɛ ra.›» ");
INSERT INTO sus_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yaxuba naxa kɔɛ radangi na yire. A naxa sanbase fanyi mayegeti a harige birin ya ma a naxan fima a taara Esayu ma: ");
INSERT INTO sus_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Si kɛmɛ firin, si kontonyi mɔxɔɲɛn, yɛxɛɛ kɛmɛ firin, yɛxɛɛ kontonyi mɔxɔɲɛn, ");
INSERT INTO sus_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ɲɔxɔmɛ ginɛ tongo saxan, e xa die, ninge tongo naani, tuura fu, sofale ginɛ mɔxɔɲɛn, a nun sofale xɛmɛ fu. ");
INSERT INTO sus_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A naxa yi xurusee itaxun, a nde so a xa konyie yi ra. A naxa a fala e bɛ, «Wo dangi yare. Wo xa naaninyi lu gɔɔrɛe tagi.» ");
INSERT INTO sus_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A naxa a fala a xa konyi singe bɛ, «Wo nun n taara Esayu na naralan, a fama i maxɔrinde, ‹Wo nun nde a ra? I na sigafe minden? Nde gbe na yi xurusee ra naxee tixi i ya ra yi ki?› ");
INSERT INTO sus_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","I fama nɛ a yaabide, ‹N marigi Esayu, i xa konyi Yaxuba nan gbe na e ra. A i sanbaxi yee nan na. A fan na n xanbi ra.›» ");
INSERT INTO sus_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A naxa na masenyi ti a firin nde fan bɛ, a nun a saxan nde, a nun mixi naxee birin biraxi xurusee fɔxɔ ra. «Wo nun Esayu na naralan tɛmui naxɛ, wo xa na masenyi ti a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Wo xa a fala, ‹I xa konyi Yaxuba na fafe muxu xanbi ra.›» Na kui Yaxuba nu na a maɲɔxunfe, «Yakɔsi, n a bɔɲɛ magoroma yi sanbasee nan na. Na tɛmui, a na n to, tɛmunde a nɔma nɛ n nasɛnɛde.» ");
INSERT INTO sus_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yaxuba xa sanbasee naxa ti a ya ra, a tan naxa kɔɛ radangi yonkinde kui. ");
INSERT INTO sus_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kɔɛ kui, Yaxuba naxa keli. A naxa a xa ginɛ firinyie tongo, e xa konyi firinyie, a nun a xa di fu nun kerenyi. E naxa Yaboko igiri. ");
INSERT INTO sus_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A naxa e ragiri Yaboko xure a nun se naxan birin na a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A naxa lu mɛnni a keren. Na tɛmui, xɛmɛ nde naxa mini a ma, e naxa gere han kuye iba tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na xɛmɛ to bara a to a mu nɔma nɔla sɔtɔde Yaxuba ma e xa gere kui, a naxa a garin a tɔnxɔnyi ma. A tɔnxɔnyi naxa te a kui. ");
INSERT INTO sus_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Xɛmɛ naxa a fala, «A lu n xa siga, ba kuye bara iba.» Yaxuba naxa a fala, «N mu i bɛɲinma, fo i duba n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Xɛmɛ naxa a maxɔrin, «I xili di?» A naxa a yaabi, «Yaxuba.» ");
INSERT INTO sus_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Xɛmɛ naxa a fala, «I xili mu falama sɔnɔn Yaxuba. A fa falama nɛ kɔrɛ Isirayila, ba wo nun Ala nan gerexi, wo nun mixie fan bara gere. I tan bara nɔ e ra.» ");
INSERT INTO sus_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaxuba naxa maxɔrinyi ti, «I xili di?» Xɛmɛ naxa a fala, «Munfe ra i n maxɔrinma n xili ma?» Na xanbi, a naxa duba Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaxuba naxa na yire xili Peniyeli, barima a naxɛ, «N Ala toxi nɛ n ya i, kɔnɔ n tan nan man ɲɛngife yi ki.» ");
INSERT INTO sus_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Soge tema tɛmui naxɛ, Yaxuba nu bara dangi Peniyeli ra, a goroma a sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Na nan a toxi han yakɔsi Isirayilakae mu laare donma naxan na tɔnxɔnyi ma, barima Ala Yaxuba masɔtɔxi a tɔnxɔn laare nan ma. ");
INSERT INTO sus_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaxuba to Esayu to fa ra e nun xɛmɛ mixi kɛmɛ naani, a naxa a xa die itaxun Leya nun Raxele ma, a nun e xa konyi ginɛ firinyie. ");
INSERT INTO sus_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A naxa konyi ginɛ firinyie ti yare, e nun e xa die. Nee xanbi ra, Leya fan naxa ti nun a xa die. Raxele nun Yusufu naxa lu dɔnxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yaxuba tan naxa siga yare. A to makɔrɛ a taara ra, a naxa a igoro bɔxi ma sanya solofere. ");
INSERT INTO sus_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Na nan lan Esayu naxa a gi a sa Yaxuba ralan. A naxa findigilin a ma, a fa a masunbu. E birin nu fa wa ra. ");
INSERT INTO sus_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esayu to bara ginɛe nun dimɛe to, a naxa maxɔrinyi ti, «Nde yee ra naxee biraxi i fɔxɔ ra yi ki?» Yaxuba naxa a yaabi, «Ala di naxee fixi i xa konyi di ma a xa marafanyi saabui ra.» ");
INSERT INTO sus_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Na kui Leya nun Raxele xa konyi ginɛe naxa e maso Esayu ra, e nun e xa die, e fa e igoro bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya nun a xa die fan naxa e maso, e naxa e igoro bɔxi ma. Na xanbi Yusufu nun Raxele naxa e maso Esayu ra, e igoro bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esayu naxa Yaxuba maxɔrin, «I munse rabama yi xuruse birin na, n naralanxi naxee ra yi ki?» Yaxuba naxa a yaabi, «N wama nɛ i tan naxan na n marigi ra, i xa n nafan.» ");
INSERT INTO sus_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esayu naxa a fala, «N xunya, harige gbegbe na n fan yi ra. I gbe ragata.» ");
INSERT INTO sus_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaxuba naxa a yaabi, «Ade, n bara i maxandi. Xa i bara n nafan, n i sanbaxi se naxee birin na, i xa e rasuxu. Won tan firinyi xa maralanyi luxi nɛ n bɛ alɔ muxu nun Ala nan luxi yire keren. I bara n nasɛnɛ a fanyi ra. ");
INSERT INTO sus_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","N bara i maxandi, i xa yi sanbasee rasuxu, barima Ala bara n waxɔnfe birin naba n bɛ. N hayi mu na sese ma sɔnɔn.» Yaxuba naxa a maxɔrɔxɔ han Esayu naxa tin nee ra. ");
INSERT INTO sus_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esayu naxa a fala, «Won xɛɛ kira xɔn ma, n xa sa i mati.» ");
INSERT INTO sus_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaxuba naxa a yaabi, «N marigi, a kolon dimɛe xa fe xɔrɔxɔ. Yɛxɛɛ ginɛe nun ninge ginɛe na xiɲɛ fife e xa die ma. Xa won gbata e ra lɔxɔɛ keren, nee birin fama nɛ faxade. ");
INSERT INTO sus_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","N marigi, i tan xa ti yare. N tan xa bira n ma xurusee fɔxɔ ra dɔyin. N xa siga n ma xurusee nun n ma die yaya ra, han muxu soma i xɔnyi tɛmui naxɛ Seyiri bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esayu naxa a fala, «N xa n ma mixi ndee lu i yi ra be.» Yaxuba naxa a yaabi, «Munfe ra? N marigi, n tan wama naxan xɔn, n xa rafan i ma gbansan.» ");
INSERT INTO sus_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na kui Esayu naxa gbilen na lɔxɔɛ Seyiri. ");
INSERT INTO sus_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaxuba tan naxa siga Sukɔti. Mɛnni a naxa banxi keren ti a yɛtɛ bɛ, a nun gɔɔrɛ a xa xurusee luma dɛnnaxɛ. Na nan a toxi na yire xili falama Sukɔti, na nan falaxi na ki «banxi xunxuri.» ");
INSERT INTO sus_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaxuba to so hɛɛri Sikemi taa kui Kanaan bɔxi ma kelife Padan Arami, a naxa a xa kiri banxi itala taa fari ma. ");
INSERT INTO sus_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A xa kiri banxi nu tixi dɛnnaxɛ, a naxa na bɔxi sara Hamori xa die ma kɔbiri kole kɛmɛ ra. Hamori nan findi Sikemi Baba ra, naxan singe sabati na bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A naxa sɛrɛxɛbade yailan mɛnni, a na yire xili «Isirayila Marigi Ala sɛnbɛ gbo.» ");
INSERT INTO sus_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yaxuba xa di ginɛ Dina, Leya naxan barixi a bɛ, na naxa siga Sikemi taa kui ginɛe xɛɛbude. ");
INSERT INTO sus_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mangɛ Hamori Hiwika xa di Sikemi to Dina to, a naxa a madutun, a naxa a futi kana. ");
INSERT INTO sus_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na kui Yaxuba xa di ginɛ Dina xa xanunteya naxa lu Sikemi fate. Sikemi naxa wɔyɛn Dina bɛ marafanyi kui. ");
INSERT INTO sus_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Na tɛmui Sikemi naxa a fala a baba Hamori bɛ, «Yi tɛmɛdi maxandi n bɛ alako n xa a dɔxɔ.» ");
INSERT INTO sus_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaxuba a mɛ tɛmui naxɛ Sikemi bara a xa di ginɛ Dina futi kana, a xa di xɛmɛe nu na xɛ ma xurusee fɔxɔ ra. A mu sese fala han nee so tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sikemi baba Hamori naxa siga Yaxuba xɔnyi a xa sa wɔyɛn a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaxuba xa die to a mɛ naxan dangixi, e naxa keli xɛ ma keren na, e gbilen banxi. E bɔɲɛ naxa te ki fanyi ra barima Sikemi fe mayaagixi nan nabaxi Isirayila bɔxi ma, a fe niya Yaxuba xa di ginɛ ra naxan mu lanma a xa raba. ");
INSERT INTO sus_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori naxa a fala e bɛ, «Wo xa di ginɛ bara rafan n ma di Sikemi ma. N bara wo maxandi, wo xa a fi a ma, a xa findi a xa ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Won xa lu fe keren, wo wo xa di ginɛe fi muxu ma alako muxu xa e dɔxɔ. Na tɛmui wo fan nɔma muxu gbee dɔxɔde. ");
INSERT INTO sus_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wo xa sabati yi bɔxi ma muxu sɛɛti ma. Be xa findi wo xɔnyi ra, wo xa yulɛya raba, wo xa harige sɔtɔ.» ");
INSERT INTO sus_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikemi naxa a fala Dina baba nun a taarae bɛ, «Wo xa hinnɛ n na. Wo wama se naxan yo xɔn, n a fima wo ma. ");
INSERT INTO sus_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Wo nɔma fe belebele maxɔrinde n ma naxan findima kote dɔxɔse ra, sa se gbegbe fan fari. Wo na se naxan birin maxɔrin n ma, n nɔma a birin fide wo ma alako n xa yi sungbutunyi dɔxɔ.» ");
INSERT INTO sus_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaxuba xa die naxa wɔyɛn furuxi fala Sikemi nun a baba Hamori bɛ, barima Sikemi nu bara e xunya Dina rayaagi. ");
INSERT INTO sus_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","E naxa a fala e bɛ, «Muxu mu nɔma muxu xunya ginɛma fide mixi ma naxan mu sunnaxi. A findima yaagi nan na muxu bɛ. ");
INSERT INTO sus_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Muxu mu nɔma wo waxɔnfe rabade, fo wo xa lu alɔ muxu tan. Mixi naxan birin na wo xɔnyi, e lan nɛ e xa sunna alɔ muxu tan. ");
INSERT INTO sus_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Na tɛmui muxu nɔma muxu xa di ginɛe fide wo ma, wo xa e dɔxɔ. Muxu fan wo gbee dɔxɔ. Muxu luma wo sɛɛti ma na tɛmui. Won birin findi ɲama keren na. ");
INSERT INTO sus_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kɔnɔ xa wo mu fa sa tin wo sunnade, muxu muxu xunya ginɛma rasuxuma nɛ, muxu keli be.» ");
INSERT INTO sus_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamori nun a xa di Sikemi naxa tin e xa masenyi ra. ");
INSERT INTO sus_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Na sɛgɛtala mu bu na fe rabafe ra, barima Yaxuba xa di ginɛ bara rafan a ma. A tan nan nu wurugente ra a ngaxakerenyie tagi. ");
INSERT INTO sus_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori nun Sikemi naxa siga e xa malan yire taa sode dɛ ra. E naxa a masen e xa ɲama bɛ, ");
INSERT INTO sus_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Yi mixie won ma fe fanyi na e bɛ. E xa lu yi bɔxi ma, e xa yulɛya raba, barima won ma bɔxi gbo. Won nɔma e xa di ginɛe dɔxɔde, won fan won ma di ginɛe fima e ma. ");
INSERT INTO sus_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Xa yi mixie sabatima be, won xa findi ɲama keren na, fo won xa yi nan naba. Xɛmɛ naxan birin na won xɔnyi be, e birin lan nɛ e xa sunna alɔ e tan. ");
INSERT INTO sus_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Xa won bara tin e xa masenyi ra, na tɛmui e sabatima won xɔnyi. E xa xurusee nun e sɔtɔse birin findi won birin gbe ra.» ");
INSERT INTO sus_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mixi naxan birin nu na taa sode dɛ ra na lɔxɔɛ, e birin naxa tin Hamori nun a xa di Sikemi xa masenyi ra. Xɛmɛ naxan birin nu na taa kui, e birin naxa e sunna. ");
INSERT INTO sus_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","E xa sunnɛ xi saxan lɔxɔɛ, yi xɛmɛe sunnade to nu na e xɔnɔfe, Yaxuba xa di xɛmɛ firinyie Simeyɔn nun Lewi, Dina taara xɛmɛmae naxa e xa santidɛgɛmae tongo, e so taa kui, e xɛmɛ birin faxa santidɛgɛma ra tɛrɛnna ra. ");
INSERT INTO sus_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","E naxa Hamori nun a xa di Sikemi fan faxa. E naxa Dina tongo Sikemi xɔnyi, e naxa fa a ra. ");
INSERT INTO sus_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaxuba xa di booree naxa se birin tongo naxee findi na mixi faxaxie gbe ra, barima e nu bara e xunya ginɛma futi kana. ");
INSERT INTO sus_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","E naxa e xa yɛxɛɛe tongo a nun e xa sie, e xa ningee nun e xa sofalee, naxee nu na taa kui a nun daaxa. ");
INSERT INTO sus_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Se naxan birin nu na, e naxa a birin xanin. E naxa dimɛe nun ginɛe xanin. Banxi naxan birin nu na, e naxa a birin kana. ");
INSERT INTO sus_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaxuba naxa a fala Simeyɔn nun Lewi bɛ, «Wo bara kɔntɔfili ti n ma n lufe ra xɔnnanteya dɔxɔɛ kui Kanaankae nun Peresikae tagi. Xɛmɛ gbegbe mu na n yi ra. E fama nɛ lande n xun ma, e n bɔnbɔ, e n xabilɛ birin halaki.» ");
INSERT INTO sus_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","E naxa a yaabi, «A nu lanma yi mixi xa muxu xunya findi langoe ra?» ");
INSERT INTO sus_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ala naxa a masen Yaxuba bɛ, «Keli, i siga Beteli. I xa sɛrɛxɛbade yailan n bɛ mɛnni, n nan n yɛtɛ masen i bɛ dɛnnaxɛ, i nu i gima waxati naxɛ i taara Esayu ma.» ");
INSERT INTO sus_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaxuba naxa a fala a xa denbaya bɛ a nun a fɔxirabirɛe, «Wo gbilen kuye fe fɔxɔ ra, wo xa wo yɛtɛ sɛniyɛn, wo xa wo xa sosee fan masara. ");
INSERT INTO sus_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Wo wo yailan, won xa siga Beteli. N xa sɛrɛxɛbade yailan Ala bɛ, naxan a yɛtɛ masen n bɛ n nu na kɔntɔfili kui tɛmui naxɛ. A naxa a ɲɛngi sa n ma fe xɔn n siga dɛnnaxɛ birin.» ");
INSERT INTO sus_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Na tɛmui e naxa e xa kuye birin so Yaxuba yi ra a nun e xa tulirasoe. Yaxuba naxa e birin biri wuri belebele bun ma naxan na Sikemi sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yaxuba nun a xa die to bara e xa yonkinde ba, Ala naxa gaaxui lu taa mixi birin bɔɲɛ ma, mixi yo mu suusa birade e fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaxuba nun a fɔxirabirɛe naxa siga Lusi, Beteli nan na ki, Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A naxa sɛrɛxɛbade yailan mɛnni. A naxa na yire xili fala «Beteli Marigi Ala,» barima Ala a yɛtɛ masen a bɛ mɛnni nɛ a nu a gife a taara ma tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebeka xa di masuxui Debora naxa faxa. E naxa a ragata Beteli mabiri wuri belebele na dɛnnaxɛ. Na wuri belebele xili nɛ «wa tide.» ");
INSERT INTO sus_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ala man naxa mini Yaxuba ma, a to gbilen kelife Padan Arami. A naxa barakɛ sa a xa fe. ");
INSERT INTO sus_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ala naxa a fala a bɛ, «I xili falafe nɛ Yaxuba, kɔnɔ a mu falama na ki sɔnɔn. To xanbi i xili fa falama nɛ Isirayila.» Ala naxa a xili sa Isirayila. ");
INSERT INTO sus_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A man naxa a masen a bɛ, «N tan nan na Ala ra Sɛnbɛ Kanyi. N di gbegbe fima nɛ i ma, alako i xa findi si nde benba ra. I man findima nɛ si gbegbe benba ra. Mangɛe fama nɛ minide i bɔnsɔɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","N bɔxi naxan fi Iburahima nun Isiyaga ma, n bara a fi i fan ma, a nun i bɔnsɔɛ ma naxan fama i xanbi ra.» ");
INSERT INTO sus_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Na nan lan, Ala naxa keli yire, a wɔyɛn Yaxuba bɛ dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaxuba naxa gɛmɛ tɔnxuma ti naa, a naxa ture nun wɛni ifili a ma sɛrɛxɛ ra, alako a xa findi gɛmɛ magaaxuxi ra. ");
INSERT INTO sus_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A naxa yi yire xili fala Beteli, Ala wɔyɛn a bɛ dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yaxuba nun a xa denbaya to keli Beteli, beenu e xa makɔrɛ Efarata ra, Raxele naxa di sɔtɔ. Na di barife naxa findi a bɛ fe xɔrɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Raxele nu na di barima tɛmui naxɛ xɔnɛ kui, di rasuxui naxa a fala a bɛ, «Hali i mu gaaxu, yi biyaasi i man xɛmɛ nan barixi.» ");
INSERT INTO sus_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raxele nu bara lu alɔ mixi faxaxi. A nu a nii magagama tɛmui naxɛ, a naxa a xa di xili sa Ben Oni, «nimisa di.» Kɔnɔ a baba tan naxa a xili sa Bunyamin, «di barakaxi.» ");
INSERT INTO sus_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raxele to faxa, e naxa a ragata Efarata kira dɛ. Na yire xili falama nɛ yakɔsi Bɛtɛlɛɛmu. ");
INSERT INTO sus_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaxuba naxa gɛmɛ sa gaburi fari tɔnxuma ra, na na mɛnni han to. ");
INSERT INTO sus_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isirayila naxa siga a sa yonkin Migidali Ederi xanbi ra. ");
INSERT INTO sus_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isirayila nu na mɛnni tɛmui naxɛ, Ruben naxa a baba xa ginɛ Bila kolon ginɛ ra. Isirayila naxa kolon sɔtɔ na ma. Isirayila di xɛmɛ fu nun firin nan sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya naxa Ruben bari di singe, na xanbi ra Simeyɔn, Lewi, Yuda, Isakari, nun Sabulon. ");
INSERT INTO sus_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raxele naxa Yusufu nun Bunyamin bari. ");
INSERT INTO sus_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raxele xa konyi Bila naxa Nafatali nun Dana bari. ");
INSERT INTO sus_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leya xa konyi Silipa naxa Gadi nun Aseri bari. Nee birin findixi Yaxuba xa die nan na, a naxee sɔtɔ Padan Arami. ");
INSERT INTO sus_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaxuba naxa siga a baba Isiyaga xɔnyi Mamire, Kiriyati Araba mabiri. Mɛnni fa xili nɛ kɔrɛ Hebiron. Iburahima nun Isiyaga sabati nɛ naa. ");
INSERT INTO sus_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isiyaga xa simaya nu bara siga ɲɛ kɛmɛ ɲɛ tongo solomasaxan. ");
INSERT INTO sus_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","A to gɛ simaya xɔnkuye sɔtɔde, a naxa faxa, a a benbae masagata aligiyama. A xa di Esayu nun Yaxuba naxa a ragata. ");
INSERT INTO sus_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esayu, naxan man xili falama Edon, a xa taruxui nan ya. ");
INSERT INTO sus_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esayu Kanaan ginɛe dɔxɔ nɛ: Ada, naxan findixi Elon Xitika xa di ra, nun Oholibama, naxan findixi Ana xa di ra, Sibeyon Hiwika xa mamadi. ");
INSERT INTO sus_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A naxa Sumayila xa di ginɛ Basamati fan dɔxɔ, Nebayoti xunya ginɛma. ");
INSERT INTO sus_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Elifasi findi Ada xa di nan na. Reyuweli findi Basamati xa di nan na. ");
INSERT INTO sus_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama naxa di xɛmɛ saxan bari a bɛ: Yeyusi, Yalami, nun Kora. Nee birin findi Esayu xa die nan na naxee barixi Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esayu naxa a xa ginɛe xanin a xun ma, a xa di ginɛe, a xa di xɛmɛe, a xa konyie, a xa xurusee, nun a harige naxan birin sɔtɔ Kanaan bɔxi ma. A naxa a birin xanin bɔxi gbɛtɛ ma, dɛnnaxɛ makuya a xunya Yaxuba yire ra, ");
INSERT INTO sus_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","barima e harige nu bara gbo, e mu nu nɔma lude e boore sɛɛti ma. E nu na dɛnnaxɛ, e xa xuruse birin mu nu nɔma ɲooge sɔtɔde. ");
INSERT INTO sus_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Na nan a to Esayu, naxan findi Edon na, a naxa siga a sa sabati Seyiri geya bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esayu naxan findi Edon bɔnsɔɛ baba ra, na nu sabatixi geyae nan ma Seyiri bɔxi ma, a xa taruxui nan ya. ");
INSERT INTO sus_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esayu xa die nan ya: Elifasi, Ada naxan barixi Esayu bɛ, Reyuweli, Basamati naxan barixi Esayu bɛ. ");
INSERT INTO sus_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasi xa die nan ya: Teman, Omaru, Sefo, Gatami, nun Kenasi. ");
INSERT INTO sus_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timina, Elifasi xa konyi ginɛ, a Amalɛki bari nɛ Elifasi bɛ. Esayu nun a xa ginɛ Ada xa mamadie nan na ki. ");
INSERT INTO sus_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reyuweli xa die nan ya: Naxati, Sera, Sama, nun Misa. Esayu nun a xa ginɛ Basamati xa mamadie nan na ki. ");
INSERT INTO sus_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esayu xa die nan ya Oholibama naxan barixi a bɛ: Yeyusi, Yalami, nun Kora. Oholibama findixi Ana xa di ginɛ nan na. Ana findixi Sibeyon xa di ginɛ nan na. ");
INSERT INTO sus_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mangɛ naxee keli Esayu bɔnsɔɛ nee nan ya: Esayu xa di singe Elifasi xa die nan ya: Mangɛe Teman, Omaru, Sefo, Kenasi, ");
INSERT INTO sus_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatami, nun Amalɛki. Mangɛe nan na ki naxee fatanxi Elifasi Edonka ra. Ada xa mamadie nan e ra. ");
INSERT INTO sus_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esayu xa di Reyuweli xa die nan ya: Mangɛe Naxati, Sera, Sama, nun Misa. Mangɛe nan na ki naxee fatanxi Reyuweli Edonka ra. Basamati xa mamadie nan e ra. ");
INSERT INTO sus_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esayu xa ginɛ Oholibama xa die nan ya: Mangɛe Yeyusi, Yalami, nun Kora. Mangɛe nan na ki naxee fatanxi Esayu xa ginɛ Oholibama ra. Oholibama nan findixi Ana xa di ra. ");
INSERT INTO sus_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esayu, naxan man xili falama Edon, a xa die nan na ki, a nun mangɛ naxee fatanxi Esayu bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seyiri Xorika xa die nan ya, naxee nu na yi bɔxi ma: Lotan, Sobali, Sibeyon, Ana, ");
INSERT INTO sus_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eseri, nun Disan. Xori mangɛe nan na ki naxee fatanxi Seyiri bɔnsɔɛ ra Edon bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan xa di xɛmɛe nan ya: Xori nun Hemami Timina findixi Lotan xunya ginɛma nan na. ");
INSERT INTO sus_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali xa di xɛmɛe nan ya: Aliban, Manaxati, Ebali, Sefo, nun Onan. ");
INSERT INTO sus_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyon xa di xɛmɛe nan ya: Aya nun Ana, naxan dulonyi furaxie toxi gbengberen yire, a to nu Sibeyon xa sofalee dɛmadonfe. ");
INSERT INTO sus_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana xa die nan ya: Dison nun Oholibama, Ana xa di ginɛ. ");
INSERT INTO sus_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison xa di xɛmɛe nan ya: Hendan, Eseban, Yitiran, nun Keran. ");
INSERT INTO sus_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseri xa di xɛmɛe nan ya: Bilihan, Saban, nun Akan. ");
INSERT INTO sus_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan xa di xɛmɛe nan ya: Usi nun Aran. ");
INSERT INTO sus_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Xori mangɛe nan ya: Lotan, Sobali, Sibeyon, Ana, ");
INSERT INTO sus_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eseri, Disan. Xori mangɛe nan na ki Seyiri bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Edon mangɛe nan ya, naxee nu na beenu mangɛ ndee xa lu Isirayila: ");
INSERT INTO sus_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beyori xa di Bela naxa findi Edon mangɛ ra. A xa taa xili nu fala nɛ Dinhaba. ");
INSERT INTO sus_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela to faxa, Sera xa di Yobabo naxan keli Bosara, na naxa findi mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabo to faxa, Xusama naxan keli Teman bɔxi ma, na naxa findi mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xusama to faxa, Bedada xa di Hadada, naxan bara nɔ Madiyan na Mowaba bɔxi ma, na naxa findi mangɛ ra. A xa taa xili nu fala nɛ Abiti. ");
INSERT INTO sus_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadada to faxa, Samala Masareka naxa findi mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala to faxa, Sawulu Rehobotika, naxan nu na xure dɛ ra, na naxa findi mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawulu to faxa, Akibori xa di Bali Hanan, na naxa findi mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akibori xa di Bali Hanan to faxa, Hadara naxa findi mangɛ ra. A xa taa xili nu fala nɛ Pawu. A xa ginɛ xili nu fala nɛ Mehetabeli, Matirɛdi xa di ginɛ, Mesahabi xa mamadi. ");
INSERT INTO sus_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mangɛe nan ya naxee kelixi Esayu bɔnsɔɛ ma: Timina, Aliba, Yeteti, ");
INSERT INTO sus_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO sus_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenasi, Teman, Mibisari, ");
INSERT INTO sus_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiyɛli, nun Irami. Edon mangɛe nu mangɛya raɲɛrɛma e xa bɔxie nan ma. Esayu xa taruxui nan na ki naxan findixi Edonkae benba ra. ");
INSERT INTO sus_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaxuba sabati nɛ Kanaan bɔxi ma, a baba nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaxuba bɔnsɔɛ xa taruxui nan ya. Yusufu, naxan xa simaya nu bara ɲɛ fu nun solofere li, a nu xurusee nan kantama a nun a taarae, nun a baba xa ginɛe Bila nun Silipa xa die. Yusufu nu a taarae xa fe ɲaaxie dɛntɛgɛ sama a baba bɛ. ");
INSERT INTO sus_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusufu nan nu rafan Isirayila ma dangi a xa di birin na, barima a tan bari a xa xɛmɛforiɲa nan kui. Na kui a naxa donma kuye tofanyi fi a ma. ");
INSERT INTO sus_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusufu taarae naxa a kolon e xunya nan nafan e baba ma dangi e birin na. E naxa a raɲaaxu fɔlɔ, e mu nu wɔyɛn fanyi falama a bɛ kɔrɛ. ");
INSERT INTO sus_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Na tɛmui Yusufu naxa xiye nde sa. A to na iba a taarae bɛ, e naxa a raɲaaxu dangife a singe ra. ");
INSERT INTO sus_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A naxa a fala e bɛ, «Wo tuli mati n ma xiye ra, n naxan saxi. ");
INSERT INTO sus_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Won birin nu na xɛ nan ma mɛngi raxiride. Na nan lan, n ma mɛngi xiri naxa keli, a ti. Mɛngi xiri naxee nu suxuxi wo tan yi ra, e naxa n gbe xiri rabilin, e birin fa e kuntin n ma xiri bun.» ");
INSERT INTO sus_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","A taarae naxa a maxɔrin, «Pe, i wama findife muxu xa mangɛ nan na, alako i xa nu muxu yamari?» E naxa a raɲaaxu dangife a singe ra a xa xiye nun a xa masenyi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufu to xiye gbɛtɛ sa, a naxa na fan iba a taarae bɛ. A naxa a fala e bɛ, «N man bara xiye sa. Soge, kike, nun tunbui fu nun keren nu na n bun ma.» ");
INSERT INTO sus_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A naxa na xiye tagi raba a baba nun a taarae bɛ. A baba naxa xaaɲɛ a ma, a fa a fala a bɛ, «I xiye naxan saxi yi ki, a findixi xiye mɔɔli mundun na? I waxi nɛ i nga, i taarae, nun n tan, muxu xa fa muxu igorode bɔxi ma i bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A taarae naxa bira a tɔɔnɛ fe fɔxɔ ra, kɔnɔ a baba naxa a ɲɛngi sa a xiye xɔn ma. ");
INSERT INTO sus_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yusufu taarae naxa siga Sikemi e baba xa xurusee dɛmadonde. ");
INSERT INTO sus_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isirayila naxa a fala Yusufu bɛ, «I taarae bara siga xurusee dɛmadonde Sikemi. N naxan nabama, n xa i xɛɛ e xɔn ma.» Yusufu naxa a yaabi, «Awa.» ");
INSERT INTO sus_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Isirayila naxa a masen a bɛ, «Siga mafuren i xa sa a mato xa i taarae mu furaxi, xa se mu xurusee fan toxi alako i xa fa na dɛntɛgɛ sa n bɛ.» A naxa a xɛɛ keli Hebiron lanbanyi sigafe ra Sikemi. ");
INSERT INTO sus_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Xɛmɛ nde naxa Yusufu to Sikemi bɔxi ma, a na ɲɛrɛfe wula i. Na xɛmɛ naxa a maxɔrin, «I munse fenfe?» ");
INSERT INTO sus_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A naxa a yaabi, «N na n taarae nan fenfe. Yandi, a fala n bɛ e na xurusee dɛmadonfe dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Na xɛmɛ naxa a fala a bɛ, «E mu na be. N bara e xui mɛ a fala ra e xa siga Dotan.» Na kui Yusufu naxa bira a taarae fɔxɔ ra han a sa e li Dotan. ");
INSERT INTO sus_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","E to sa a to yire makuye, e naxa lan a ma e xa a faxa. ");
INSERT INTO sus_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E nu fa a fala ra e boore bɛ, «Yi xiye sa mangɛ nan na fafe yi ki. ");
INSERT INTO sus_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wo fa be, won xa a faxa, won xa a ragoro kɔlɔnyi nde kui. Won nɔma a falade sube xaaɲɛ nde bara a ibɔɔ. Na tɛmui won fama a kolonde a xa xiye findima a bɛ fe naxan na.» ");
INSERT INTO sus_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben to na mɛ, a naxa a ba e yi ra yi masenyi ra, «Won naxa a faxa de. ");
INSERT INTO sus_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","A mu lanma wo xa a wuli ramini. Wo xa a ragoro yi kɔlɔnyi kui naxan na yi gbengberen yire. Mixi yo naxa a bɛlɛxɛ din a ra.» A nu wama a bafe nɛ e yi ra alako a xa nɔ a ragbilende a baba xɔn. ");
INSERT INTO sus_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusufu to a taarae yire li, e naxa a xa donma kuye tofanyi rate a ma. ");
INSERT INTO sus_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","E naxa Yusufu ragoro kɔlɔnyi nde kui, ye mu nu na naxan kui. ");
INSERT INTO sus_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na dangi xanbi, e nu na e dɛgefe tɛmui naxɛ, e naxa Sumayila di ndee to fa ra kelife Galede. E nu na surayi, seri, nun labundɛ xaninfe Misira bɔxi ma ɲɔxɔmɛe fari. ");
INSERT INTO sus_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda naxa a masen a xunyae bɛ, «Won na won xunya faxa gundo kui, na munse fanma won tan ma? ");
INSERT INTO sus_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Wo fa, won xa a mati Sumayila bɔnsɔɛ mixie ma. Won naxa a faxa, barima won xunya na a ra. Won wuli keren fasɛ keren.» A xunyae birin naxa tin a xa masenyi ra. ");
INSERT INTO sus_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Na Madiyan yulɛe to e yire li, Yusufu taarae naxa a rate kɔlɔnyi kui, e fa a mati nee ma kɔbiri kole mɔxɔɲɛn na. Na yulɛ naxee fatanxi Sumayila bɔnsɔɛ ra, nee naxa Yusufu xanin Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Na dangi xanbi Ruben naxa gbilen kɔlɔnyi yire Yusufu fɔxɔ ra, kɔnɔ a mu a li naa. A naxa a xa donma birin ibɔɔ a ma sunnunyi kui. ");
INSERT INTO sus_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A naxa gbilen a xunyae yire, a a fala e bɛ, «Yusufu mu na yire won na lu dɛnnaxɛ, n fa munse rabama kɔrɛ?» ");
INSERT INTO sus_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","E naxa si keren faxa, e fa Yusufu xa donma kuye tofanyi maturuxun na sube wuli. ");
INSERT INTO sus_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Na xanbi, e naxa na donma kuye tofanyi xanin e baba xɔn ma. E naxa a fala a bɛ, «Muxu bara yi to. Yi donma mato ba xa i xa di nan gbe a ra.» ");
INSERT INTO sus_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yaxuba naxa na donma kolon, a fa a fala, «N ma di xa donma na a ra! Wula sube xaaɲɛ nde bara n ma di Yusufu faxa! A bara a ibɔɔ!» ");
INSERT INTO sus_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaxuba naxa a xa donma ibɔɔ a ma sunnunyi kui. A naxa sunnun dugi ragoro a ma, a a xa di ɲɔn fe raba xi wuyaxi. ");
INSERT INTO sus_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A xa di xɛmɛe nun a xa di ginɛe naxa fe birin naba a bɛ alako sunnunyi xa ba a ma, kɔnɔ Yaxuba mu dundu. A naxa a fala, «N nan n ma di xa sunnunyi xaninma han n sa a lima tɛmui naxɛ aligiyama.» Yaxuba naxa wa a xa di bɛ. ");
INSERT INTO sus_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Madiyankae to Misira li, e naxa Yusufu mati Potifari ma, naxan findixi Misira mangɛ kantamixie xunyi ra. ");
INSERT INTO sus_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na tɛmui, Yuda naxa keli a ngaxakerenyie xun ma, a siga Adulamaka nde xɔnyi naxan xili Hira. ");
INSERT INTO sus_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mɛnni Yuda naxa Suwa Kanaanka xa di ginɛ to. A naxa a findi a xa ginɛ ra. E naxa lu e boore ra. ");
INSERT INTO sus_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Na ginɛ naxa tɛɛgɛ, a naxa di xɛmɛ bari. Yuda naxa na di xili sa Eri. ");
INSERT INTO sus_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Na ginɛ man naxa tɛɛgɛ di firin nde ma, a naxa di xɛmɛ bari. A naxa na di xili sa Onan. ");
INSERT INTO sus_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na xanbi, a man naxa di xɛmɛ gbɛtɛ bari. A naxa na di xili sa Selaha. Yuda xa ginɛ na di bari Kesibe nɛ. ");
INSERT INTO sus_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda naxa ginɛ nde fen, a a so a xa di singe Eri yi ra. Na ginɛ xili Tamari. ");
INSERT INTO sus_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mixi kobi nan nu lanxi Yuda xa di singe Eri ma Alatala ya i. Alatala naxa a ragiri a xa faxa. ");
INSERT INTO sus_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na xanbi Yuda naxa a fala Onan bɛ, «I taara xa ginɛ tongo, a xa findi i xa ginɛ ra. I xa nimɔxɔ wali raba, alako i xa di fi i taara ma.» ");
INSERT INTO sus_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kɔnɔ Onan a kolon na di mu fama findide a gbe ra. Na nan a to, e nun a nimɔxɔ na kafu, a a xa maniye sama bɔxi nan ma alako a naxa fa di fi a taara ma. ");
INSERT INTO sus_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A nu naxan nabama, na mu nu rafan Alatala ma. Na nan a ra, Ala naxa a ragiri a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na tɛmui Yuda naxa a fala a xa mamadi Tamari bɛ, «Kaaɲɛ xanin i baba xɔnyi, beenun n ma di Selaha mɔma tɛmui naxɛ.» A a maɲɔxun nɛ, tɛmunde Selaha fan faxama alɔ a taarae faxaxi ki naxɛ. Na kui Tamari naxa siga, a sa lu a baba xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A mu bu Yuda xa ginɛ naxa fa, naxan nu lanxi Suwa xa di ginɛ ma. Ɲɔn fe to ba a ra, Yuda naxa siga Timina e nun a boore Hira Adulamaka. E naxa siga Yuda xa xuruse yire, Yuda xa walikɛe nu xurusee xabe maxabafe dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mixi nde naxa a fala Tamari bɛ, «I tanun na sigafe Timina a xa xurusee xabe maxabade.» ");
INSERT INTO sus_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamari naxa a xa kaaɲɛ donma rate a ma, a naxa a yatagi makoto mafelenyi ra, a sa dɔxɔ Enayima sode dɛ ra Timina kira xɔn. A nu bara a to, Selaha bara a ginɛ dɔxɔde li, kɔnɔ Yuda mu Tamari fi a ma, a xa findi a xa ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda to bara Tamari to kira dɛ ra, a yatagi makotoxi mafelenyi ra, a naxa a maɲɔxun langoe ra. ");
INSERT INTO sus_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A naxa a fala a bɛ kira ra, «Won xɛɛ, won xa sa kafu.» A mu nu a kolonxi a xa mamadi nan a ra. Kɔnɔ Tamari naxa Yuda maxɔrin, «I munse fima n ma won na kafu?» ");
INSERT INTO sus_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A naxa a yaabi, «N si keren tongoma n ma xurusee ya ma, n fa a ra i xɔn ma.» Tamari naxa a yaabi, «Awa, sɛɛkɛ se nde lu n yi ra be sinden, beenun i fama si ra tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A naxa a maxɔrin, «I wama n xa munse dɔxɔ i xɔn ma sɛɛkɛ ra?» Tamari naxa a yaabi, «I xa i xa tɔnxuma, a luuti, nun i xa yisuxuwuri so n yi ra.» A naxa na see so a yi ra, e fa kafu e boore ra. Tamari naxa tɛɛgɛ a xa di ma. ");
INSERT INTO sus_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamari naxa gbilen a xɔnyi. A naxa a xa mafelenyi ba a xun ma, a man naxa a kaaɲɛ ginɛ donma ragoro a ma. ");
INSERT INTO sus_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda naxa a boore Adulamaka xɛɛ si tide na ginɛ ma, alako a xa fa see ra a naxan so ginɛ yi ra seedeɲɔxɔya ra. Kɔnɔ a boore mu na ginɛ to. ");
INSERT INTO sus_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A naxa Enayima mixie maxɔrin, «Yi langoe ginɛ naxan nu na Enayima kira ra, a na minden?» E naxa a yaabi, «Langoe yo mu na be.» ");
INSERT INTO sus_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A naxa gbilen Yuda yire, a fa a fala, «N mu a lixi naa. Na longori mixie bara a fala n bɛ a langoe yo mu na na kira xɔn.» ");
INSERT INTO sus_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda naxa a fala, «Na ginɛ xa na see ragata. Won fan naxa won yɛtɛ rayaagi. N bara si rasanba a ma, kɔnɔ i mu a lixi naa.» ");
INSERT INTO sus_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kike saxan dangi xanbi, mixi nde naxa a fala Yuda bɛ, «I xa mamadi Tamari bara findi langoe ra, a bara furi tongo a xa langoeɲa saabui ra.» Yuda naxa a fala, «Wo a ramini, a xa gan.» ");
INSERT INTO sus_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E nu fafe a ra tɛmui naxɛ, Tamari naxa xɛɛra rasanba a tanun ma, «Yi see mato naxan na n yi ra. Yi tɔnxuma, a luuti, nun yi yisuxuwuri findi mixi nan gbe ra naxan n nafuruxi. I lan nɛ i xa yi kanyi kolon.» ");
INSERT INTO sus_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda naxa kolon sɔtɔ na see xa fe ma. A naxa a fala, «A bara sɛriyɛ rakamali dangife n tan na barima n mu a fixi n ma di Selaha ma.» Na xanbi, a mu a kolon ginɛ ra sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamari nu di barima tɛmui naxɛ, e naxa a kolon a gulie nan na a furi. ");
INSERT INTO sus_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Di bari tɛmui, keren naxa a bɛlɛxɛ ramini. Di rasuxui naxa a bɛlɛxɛ suxu, a gɛsɛ gbeeli xiri a bɛlɛxɛ ra. A fa a fala, «Yi nan singe barixi.» ");
INSERT INTO sus_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kɔnɔ na diyɔrɛ naxa a bɛlɛxɛ raso, a xunya naxa bari. Di rasuxui naxa a fala, «I faxi sɛnbɛ mundun na yi ki?» Yuda naxa a xili sa Peresi. ");
INSERT INTO sus_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Na xanbi, boore fan naxa bari gɛsɛ gbeeli xirixi a bɛlɛxɛ ra. Yuda naxa a xili sa Sera. ");
INSERT INTO sus_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sumayila bɔnsɔɛe to Yusufu xanin Misira, Misira mangɛ kantamae xunyi Potifari naxa a sara konyi ra. ");
INSERT INTO sus_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Alatala nun Yusufu nan nu a ra. Yusufu nu fe naxan birin nabama a xa mangɛ Misiraka xɔnyi, a birin nu fanma nɛ a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A xa mangɛ naxa a kolon a Yusufu nun Alatala na a ra, barima Alatala nu fe birin sɔɔnɛyama a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifari naxa ɲɛlɛxin a ra, a naxa a findi a xa banxi mixie xunyi ra. A naxa a harige birin taxu a ra. ");
INSERT INTO sus_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Potifari to Yusufu findi a xa banxi nun a harige xunyi ra, Alatala naxa barakɛ sa na Misiraka xa banxi ma Yusufu saabui ra. Alatala naxa barakɛ sa Potifari xa banxi nun a xa xɛe birin ma. ");
INSERT INTO sus_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Na nan a to, Potifari naxa a xa se birin taxu Yusufu ra. A tan mu nu fa a ɲɛngi saxi fefe xɔn ma, fo a nu donse naxan donma. Mixi tofanyi nan nu lanxi Yusufu ma. ");
INSERT INTO sus_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tɛmui nde to dangi, Yusufu xa mangɛ xa ginɛ ya naxa sin a i. A naxa a fala a bɛ, «Fa be, won xa fa kafu.» ");
INSERT INTO sus_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yusufu naxa tondi, a fa a fala a xa mangɛ xa ginɛ bɛ, «Kafi n naxa fa n ma mangɛ xɔnyi a mu a ɲɛngi saxi fefe xɔn ma kɔrɛ a xa banxi kui. A bara a harige birin taxu n na. ");
INSERT INTO sus_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A xa banxi kui be, n tan nan dangi mixi birin na. A mu sese rafisaxi n bɛ, fo i keren, ba i tan bara findi a xa ginɛ ra. Yakɔsi, n fe ɲaaxi rabama munfe ra naxan findi yunubi fe ra Ala bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kɔnɔ na ginɛ naxa bira Yusufu xa fe dalili fɔxɔ ra. A nu a makatama lɔxɔɛ birin, kɔnɔ Yusufu naxa tondi e xa kafu. ");
INSERT INTO sus_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lɔxɔɛ nde Yusufu naxa so banxi kui a xa wali rabade. Konyi gbɛtɛ yo mu nu na banxi kui na tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifari xa ginɛ naxa a suxu a xa donma ma. A nu fa a fala a bɛ, «Won kafu!» Ginɛ to Yusufu xa donma suxu, Yusufu naxa mini a xa donma kui a a lu ginɛ bɛlɛxɛ, a mini a gi ra tande. ");
INSERT INTO sus_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ginɛ to bara a kolon a bara a gi, a xa donma lu a yi ra, a naxa mini tande, ");
INSERT INTO sus_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a naxa a xa banxi konyie xili, a fa na donma masen e bɛ, «Wo yi to, n ma xɛmɛ faxi Eburu naxan na, na nan wama won mayanfafe kɔɔta ra. A faxi nɛ n yire a muxu xa muxu sa, kɔnɔ n naxa sɔnxɔɛ rate. ");
INSERT INTO sus_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kabi n bara sɔnxɔɛ rate, a naxa a gi, a xa donma lu n yi ra. A naxa mini a gi ra tande.» ");
INSERT INTO sus_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifari xa ginɛ naxa Yusufu xa donma ragata han beenun a xa mangɛ so tɛmui. ");
INSERT INTO sus_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A naxa na fe tagi raba a bɛ, a naxɛ, «I faxi Eburu konyi xɛmɛ naxan na yi ki, a faxi nɛ a xa n mayanfa kɔɔta ra. ");
INSERT INTO sus_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kɔnɔ n to sɔnxɔɛ rate, a naxa a xa donma lu n yi ra, a naxa mini a gi ra tande. ");
INSERT INTO sus_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","I xa konyi na nan nabaxi n na.» Yusufu xa mangɛ to a xa ginɛ xa wɔyɛnyi mɛ, ");
INSERT INTO sus_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","a bɔɲɛ naxa te a ɲaaxi ra. A naxa Yusufu balan mangɛ xa geelimanie nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kɔnɔ mɛnni fan, Alatala mɛɛni nɛ a ma. A naxa a ragiri Yusufu nun geeli mangɛ dɛ xa fan. ");
INSERT INTO sus_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Geeli mangɛ naxa geelimanie taxu Yusufu ra. Fe naxan birin nu rabama, a nu dangima a tan nan ma. ");
INSERT INTO sus_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Geeli mangɛ mu nu Yusufu xa wali xun matoma a ra, barima Alatala nun Yusufu birin na a ra. Alatala nu fe birin sɔɔnɛyama Yusufu bɛ. ");
INSERT INTO sus_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Na dangi xanbi Misira mangɛ xa walikɛ naxan a ɲɛngi saxi a xa minse xɔn ma, a nun a xa taamiganyi naxa fe nde raba naxan mu rafanxi e xa mangɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Misira mangɛ naxa xɔnɔ na walikɛ firinyie ma, naxan ɲɛngi sama a xa minse xɔn ma a nun naxan a xa taami ganma. ");
INSERT INTO sus_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A naxa e suxu, e balan sɔɔri mangɛ xa geeli kui, Yusufu nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sɔɔrie xa mangɛ naxa e taxu Yusufu ra, a xa mɛɛni e ma. E to saxanyi raba geeli kui, ");
INSERT INTO sus_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","naxan ɲɛngi sama mangɛ xa minse xɔn ma, a nun naxan taami ganma mangɛ bɛ, nee naxa xiye sa geeli kui kɔɛ keren na. Kankan xa xiye nu wama fe nde nan masenfe a kanyi bɛ. ");
INSERT INTO sus_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na kuye iba Yusufu naxa fa e yire, a naxa e li sunnunyi kui. ");
INSERT INTO sus_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Na tɛmui a naxa na Misira mangɛ xa walikɛ firinyie maxɔrin, naxee taxuxi a ra, «Munfe ra wo sunnunxi to?» ");
INSERT INTO sus_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","E naxa a yaabi, «Muxu bara xiye ndee nan sa, kɔnɔ mixi yo mu na be naxan nɔma na fasaride.» Yusufu naxa a fala e bɛ, «Wo mu a kolon Ala nɔma a fasaride wo bɛ? Wo xiye fala n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Naxan ɲɛngi nu sama mangɛ xa minse xɔn ma, a naxa a xiye fala Yusufu bɛ. A naxɛ, «N tan ma xiye kui, n wɛni bili nan to a tixi n ya i. ");
INSERT INTO sus_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Salon saxan na a bili ma. A to fuga, a fuge naxa wɛni bogi mɔxie ramini. ");
INSERT INTO sus_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Misira mangɛ xa wɛni sase suxuxi n yi ra. N naxa na wɛni bogi mɔxie ba, n naxa e bundu Misira mangɛ xa wɛni sase kui, n fa a so a yi ra.» ");
INSERT INTO sus_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu naxa a fala a bɛ, «Yi xiye yi nan fasarixi: Na salonyi saxan naxan na ki, a xi saxan nan masenxi. ");
INSERT INTO sus_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Xi saxan dangi xanbi, Misira mangɛ i xun nakelima nɛ, a man fa i ragbilen i walide fori. I man fama nɛ wɛni tɔnbili sode Misira mangɛ yi ra alɔ i darixi a ra ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kɔnɔ i naxa nɛɛmu n ma i na hɛɛri sɔtɔ tɛmui naxɛ. I xa findi saabui ra n bɛ, i xa n ma fe fala Misira mangɛ bɛ alako n xa mini geeli kui, ");
INSERT INTO sus_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","barima e n tongoxi nɔɛ nan na Eburu bɔxi ma. Be fan, n mu fefe rabaxi naxan a niyama n xa geeli sɔtɔ.» ");
INSERT INTO sus_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Naxan taami ganma mangɛ bɛ, a to bara a to Yusufu wɔyɛnyi naxan tagi rabaxi a boore bɛ, a fanxi a bɛ, a naxa a fala Yusufu bɛ, «N tan fan xiye nde saxi. Debe saxan dɔxɔxi n xun ma, taami fiixɛ na e kui. ");
INSERT INTO sus_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Debe naxan dɔxɔxi a fari, taamiganyi donse naxan birin nafalama Misira mangɛ bɛ, a birin nu na a kui. Kɔnɔ xɔnie nu fa na donse masakun naxan dɔxɔxi n xun ma.» ");
INSERT INTO sus_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu naxa a masen a bɛ, «I xa xiye yi nan fasarixi: Na debe saxanyi naxan na ki, a xi saxan nan masenxi. ");
INSERT INTO sus_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Xi saxan dangi xanbi, Misira mangɛ i xunyi bolonma nɛ a dɛ i. A i gbakuma nɛ wuri ma, xɔnie i sube masakun.» ");
INSERT INTO sus_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Xi saxan lɔxɔɛ, Misira mangɛ bari lɔxɔɛ, mangɛ naxa xulunyi belebele ti a xa walikɛe bɛ. Naxan ɲɛngi sama mangɛ xa minse xɔn ma, a nun a xa taamiganyi, Misira mangɛ naxa e xun nakeli walikɛe tagi. ");
INSERT INTO sus_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Naxan ɲɛngi sama minse xɔn ma, a naxa a ragbilen a walide fori, alako a man xa minse so a yi ra. ");
INSERT INTO sus_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kɔnɔ a naxa a xa taamiganyi gbaku wuri ma alɔ Yusufu nu bara a tagi raba ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Naxan ɲɛngi sama mangɛ xa minse xa fe xɔn ma, a mu ratu Yusufu xa fe ma, a nɛɛmu a ma. ");
INSERT INTO sus_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ɲɛ firin dangi xanbi, Misira mangɛ naxa xiye nde sa. Na xiye kui a tixi xure dɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A naxa ninge fate fanyi solofere to mini ra xure kui, e na ɲooge donfe kalee tagi. ");
INSERT INTO sus_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na dangi xanbi, ninge solofere gbɛtɛ, naxee xɔsixi, nee naxa mini xure dɛ ra boore ningee sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Yi ninge xɔsixi solofere naxa yi ninge fate fanyi solofere don. Na nan lan Misira mangɛ naxa xunu. ");
INSERT INTO sus_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A to gbilen a sa ra, a man naxa xiye gbɛtɛ sa. ");
INSERT INTO sus_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Na xiye kui tɔnsɔɛ solofere fanyi tixi bili keren ma. ");
INSERT INTO sus_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Na dangi xanbi, tɔnsɔɛ solofere gbɛtɛ, naxee xun xurun, foye bara e ragan, e tixi boore tɔnsɔɛe sɛɛti ma. Yi tɔnsɔɛ xunxurie naxa yi tɔnsɔɛ rafexi fanyie don. Na nan lan, Misira mangɛ naxa xunu. Na xiye nan na ki. ");
INSERT INTO sus_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na kuye iba, Misira mangɛ bɔɲɛ nu minixi. A naxa mandurulae nun karamɔxɔɛ birin xili. A naxa na xiyee masen e bɛ, kɔnɔ mixi yo mu sɔtɔ e ya ma, naxan nɔ a tagi rabade a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na tɛmui naxan a ɲɛngi sama mangɛ xa minse xɔn ma, na naxa wɔyɛnyi tongo a fa a fala Misira mangɛ bɛ, «N nan ma kanari ya xaranma nɛ to lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tɛmui dangixi, Misira mangɛ xɔnɔ nɛ a xa konyie ma. A naxa n suxu, a n balan sɔɔri mangɛ xa geeli kui, a nun naxan taami ganma mangɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A tan nun n tan, muxu birin xiye sa nɛ kɔɛ keren kui naxan tagi lan a xa raba. Kankan xa xiye nu wama fe nde masenfe a kanyi bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sɔɔri mangɛ xa Eburu konyi nde nan nu na geeli kui muxu ya ma. Muxu to na xiyee fala a bɛ, a naxa e birin fasari muxu bɛ. Muxu xiye naxee saxi, a naxa kankan gbe fasari a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A birin dangi nɛ alɔ a xiye tagi raba muxu bɛ ki naxɛ. Misira mangɛ bara n tan nagbilen n walide fori, kɔnɔ a bara boore gbaku wuri ma.» ");
INSERT INTO sus_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Misira mangɛ naxa xɛɛrae xɛɛ Yusufu yire. E naxa a ramini geeli kui a ikɔrɛxi ra. E naxa a xunyi bi, e sose gbɛtɛe ragoro a ma, e siga a ra Misira mangɛ yire. ");
INSERT INTO sus_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Misira mangɛ naxa a masen Yusufu bɛ, «N bara xiye nde sa. Mixi yo mu nɔxi a tagi rabade, kɔnɔ n bara a mɛ i tan xiye tagi rabama e na naxan fala i bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu naxa Misira mangɛ yaabi, «N tan mu a ra. Ala nan Misira mangɛ xa xiye tagi rabama a bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Misira mangɛ naxa a masen Yusufu bɛ, «N ma xiye kui n tixi xure dɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","N naxa ninge fate fanyi solofere to mini ra xure kui, e na ɲooge donfe kalee longori ra. ");
INSERT INTO sus_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na nan lan, ninge solofere gbɛtɛ naxa te e xanbi ra, e xɔsixi han. E ganyanxɔri birin saxi kɛnɛ ma. Han to n mu na ninge xɔsixi mɔɔli to Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Na ninge xɔsixi xun nakanaxie naxa na ninge solofere fate fanyi don. ");
INSERT INTO sus_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kɔnɔ na dangi xanbi, mixi yo mu nɔ a kolonde xa e bara e don. E xa xɔsi mu masara. Na nan lan, n naxa xunu.» ");
INSERT INTO sus_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Na tɛmui n man naxa xiye gbɛtɛ sa. Tɔnsɔɛ rafexi fanyi solofere tixi bili keren ma. ");
INSERT INTO sus_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na dangi xanbi tɔnsɔɛ xunxuri solofere gbɛtɛ, foye naxee raganxi, nee naxa mini booree sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tɔnsɔɛ ponpoee naxa na tɔnsɔɛ solofere fanyi don. N bara na fala mandurulae bɛ, kɔnɔ mixi yo mu nɔ a fasaride n bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu naxa a fala Misira mangɛ bɛ, «I xa xiye firinyi birin fe keren nan masenxi. Ala bara i rakolon fe ma a fama naxan nabade. ");
INSERT INTO sus_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Na ninge solofere fanyie nun na tɔnsɔɛ solofere fanyie, ɲɛ solofere nan masenxi na ki. Na tan xiye keren nan a ra. ");
INSERT INTO sus_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na ninge xɔsixi xun nakanaxi solofere nun na tɔnsɔɛ ponpoe solofere foye naxee raganxi, nee fan ɲɛ solofere kaamɛ nan masenxi.» ");
INSERT INTO sus_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«N xa nɔndi fala i bɛ, Ala bara fe masen Misira mangɛ bɛ a fama naxan nabade. ");
INSERT INTO sus_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yi ɲɛ solofere naxan fafe yi ki, e findima ɲɛ fanyi nan na Misira bɔxi bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na na dangi, kaamɛ ɲɛ solofere gbɛtɛ fama fade, won nɛɛmuma nɛ na fe fanyi birin na. Kaamɛ bɔxi halakima nɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Na findima fe magaaxuxi nan na, a lu alɔ sese fanyi mu nu raba yi bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","«I yi xiye saxi nɛ dɔxɔ firin, barima Ala xa natɛ na a ra naxan mu kanama, a man mu buma a xa raba. ");
INSERT INTO sus_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Mangɛ, yakɔsi a lanma i xa xaxilima fen naxan lɔnnixi. I xa Misira nɔɛ so na kanyi yi ra. ");
INSERT INTO sus_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mangɛ, i xa mixie sugandi naxee ɲɛngi fama sade bɔxi rawali xɔn ma yi ɲɛ fanyi solofere bun ma. Bɔxi daxamui busali suuli yo suuli, e xa fa keren na mangɛ xɔn ma, a xa a ragata. ");
INSERT INTO sus_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E xa donse birin malan, e xa a ragata taae kui Misira mangɛ xa nɔɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yi donse ragataxi fama Misira bɔxi ratangade kaamɛ ma, naxan fama fade ɲɛ solofere bun.» ");
INSERT INTO sus_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na wɔyɛnyi naxa rafan Misira mangɛ nun a xa mixi birin ma. ");
INSERT INTO sus_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Misira mangɛ naxa a fala e bɛ, «Won nɔma mixi nde sɔtɔde naxan luma alɔ yi xɛmɛ? Ala Xaxili na a bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Misira mangɛ naxa a fala Yusufu bɛ, «Ala bara na fe birin masen i bɛ. Mixi yo mu na naxan xaxili fan alɔ i tan, a xa lɔnni man xa dangi i gbe ra. ");
INSERT INTO sus_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","I tan nan fama findide n ma banxi xunyi ra. N ma ɲama fama birade i xa yaamari nan fɔxɔ ra. N ma mangɛ kibanyi nan tun n nadangixi i ra.» ");
INSERT INTO sus_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Misira mangɛ man naxa a fala Yusufu bɛ, «A mato, n bara nɔɛ so i yi ra Misira bɔxi birin ma.» ");
INSERT INTO sus_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","A naxa a xa gbeti xurundɛ ba a bɛlɛxɛ ra, a naxa a so Yusufu bɛlɛxɛ ra. A naxa sose fanyi ragoro a ma. A naxa kɔnmagore xɛɛma daaxi ragoro a kɔn ma. ");
INSERT INTO sus_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A naxa a rate gise kui, naxan birama Misira mangɛ ragise fɔxɔ ra. Sɔɔrie nu fa a fala e xui itexi ra ɲama bɛ, «Wo xinbi sin!» Misira mangɛ a xa mangɛya taxu Yusufu ra na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Misira mangɛ man naxa a fala Yusufu bɛ, «N tan nan mangɛ ra, kɔnɔ xa i mu yaamari fi naxan ma, fefe mu rabama Misira bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Misira mangɛ naxa Yusufu xili sa Safanati Paneya. A naxa Potifera, On sɛrɛxɛdubɛ, xa di ginɛ Asana, fi a ma. Yusufu naxa Misira bɔxi xun mato fɔlɔ a ra. ");
INSERT INTO sus_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu simaya nu bara ɲɛ tongo saxan li, a fa Misira mangɛ yire tɛmui naxɛ. Na tɛmui Yusufu naxa keli Misira mangɛ yire, a sa Misira bɔxi birin iɲɛrɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na ɲɛ solofere fanyi kui, bɔxi birin naxa rawali. ");
INSERT INTO sus_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu naxa donse birin malan naxan sɔtɔxi na ɲɛ solofere bun ma Misira bɔxi ma. A naxa donse ragata taae kui naxan sɔtɔxi daaxa. ");
INSERT INTO sus_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu naxa donse xɔri gbegbe malan, alɔ mɛyɛnyi naxan na baa dɛ ra. A naxa gbo yɛ han a mu na xasabi sɛbɛ sɔnɔn, barima mixi yo mu nɔma a kɔnti kolonde. ");
INSERT INTO sus_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Beenun kaamɛ ɲɛ sin tɛmui, Yusufu xa ginɛ Asana, On sɛrɛxɛdubɛ Potifari xa di ginɛ, naxa di firin bari a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu naxa a xa di singe xili sa Manasi. Na nan na ki, Ala bara a niya n bara nɛɛmu n ma tɔɔrɛ birin ma, a nun n baba xa denbaya. ");
INSERT INTO sus_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A naxa a xa di firin nde xili sa Efirami. Na nan na ki, Ala bara n findi di bari ra bɔxi ma n xun nu goroxi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ɲɛ fanyi solofere naxa dangi Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kaamɛ ɲɛ solofere naxa a li fɔlɔ, alɔ Yusufu a tagi raba ki naxɛ. Kaamɛ naxa din duniɲa birin na, kɔnɔ baloe nu na Misira bɔxi tan ma. ");
INSERT INTO sus_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kaamɛ to bara Misira bɔxi birin suxu, ɲama naxa sɔnxɔɛ rate Misira mangɛ ma baloe fe ra. Misira mangɛ naxa a fala Misirakae birin bɛ, «Wo siga a fala Yusufu bɛ, a na fe naxan fala wo bɛ, wo xa na raba.» ");
INSERT INTO sus_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kaamɛ naxa din bɔxi birin na. Yusufu naxa donse malandee rabi, a naxa mɛngi sara Misirakae ma, barima kaamɛ nu bara sɛnbɛ sɔtɔ Misira bɔxi birin ma. ");
INSERT INTO sus_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mixie nu fa keli yire birin, fafe mɛngi sarade Yusufu ma, barima kaamɛ nu bara sɛnbɛ sɔtɔ duniɲa birin ma. ");
INSERT INTO sus_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaxuba to bara a mɛ a mɛngi na Misira, a naxa a fala a xa die bɛ, «Wo dɔxɔxi munfe ra? ");
INSERT INTO sus_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","N bara a mɛ a mɛngi na Misira. Wo goro, wo sa mɛngi sara won bɛ alako won xa balo, won naxa fa faxa.» ");
INSERT INTO sus_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yusufu taara mixi fu naxa goro donse xɔri sarade Misira. ");
INSERT INTO sus_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaxuba mu tin Bunyamin, Yusufu xunya, xa bira e fɔxɔ ra. A nu fa a fala, «N bara gaaxu fe ɲaaxi naxa fa a sɔtɔ.» ");
INSERT INTO sus_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Isirayila xa die naxa siga mɛngi sarade, e nun mixi gbɛtɛe ra naxee fan nu waxi mɛngi xɔn, barima kaamɛ nu bara din Kanaan bɔxi birin na. ");
INSERT INTO sus_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu nan nu findixi mangɛ xungbe ra Misira. A tan nan nu mɛngi sarama mixi birin ma. Yusufu taarae naxa fa, e e yatagi rafelen bɔxi ma a ya i. ");
INSERT INTO sus_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu to a taarae to, a naxa e kolon, kɔnɔ a naxa a yɛtɛ rasan e ma. A naxa wɔyɛn e bɛ a xɔrɔxɔɛ ra, «Wo kelixi minden?» E naxa a yaabi, «Muxu kelixi Kanaan bɔxi nan ma, fafe donse sarade.» ");
INSERT INTO sus_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu naxa a taarae kolon, kɔnɔ e tan mu kolon sɔtɔ a xa fe ma. ");
INSERT INTO sus_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu naxa ratu a xa xiye ma, a naxan sa a taarae xa fe ra. A naxa a fala e bɛ, «Bɔxi rabɛnyie nan na wo ra. Wo faxi yi bɔxi kobidee nan kolonde.» ");
INSERT INTO sus_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","E naxa a yaabi, «Ade. Mangɛ, muxu faxi donse na tun sarade. ");
INSERT INTO sus_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Muxu birin, xɛmɛ keren xa die nan lanxi muxu ma. Mixi matinxinxie nan na muxu ra. Muxu na i xa yaamari bun ma, muxu mu findixi bɔxi rabɛnyie xa ra.» ");
INSERT INTO sus_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufu naxa a fala e bɛ, «Wule na a ra. Wo faxi bɔxi kobidee nan fende.» ");
INSERT INTO sus_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","E naxa a yaabi, «Muxu tan luxi alɔ i xa konyie. Muxu di fu nun firin nan a ra. Mixi keren ma die nan na muxu birin na Kanaan bɔxi ma. Muxu birin xunya na muxu baba yire, di keren tan bara laaxira.» ");
INSERT INTO sus_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu naxa a fala e bɛ, «N a kolon a bɔxi rabɛnyie nan na wo ra. ");
INSERT INTO sus_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","N wo matoma yi nan ma. Misira mangɛ xili ra, wo mu kelima be danmi wo xunya mu fa. ");
INSERT INTO sus_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wo mixi nde xɛɛ wo ya ma a xa sa fa wo xunya ra. Wo tan dɔnxɔɛe soma geeli nɛ. N fama wo xa wɔyɛnyi matode, n xa a kolon xa wo nɔndi falama, xa na mu Misira mangɛ xili ra, bɔxi rabɛnyie nan na wo ra.» ");
INSERT INTO sus_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A naxa e birin makankan han xi saxan. ");
INSERT INTO sus_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xi saxan lɔxɔɛ, Yusufu naxa a fala e bɛ, «Xa wo bara n xui suxu, wo mu faxama, barima n gaaxuma Ala ya ra. ");
INSERT INTO sus_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Xa mixi matinxinxie nan wo ra, wo mixi keren lu geeli kui, booree xa donse xanin wo xa denbayae xɔn ma, barima e na tɔɔrɛ kui. ");
INSERT INTO sus_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Wo xa fa wo xunya ra n xɔn ma alako n xa a kolon xa nɔndi falɛe nan wo ra, na nan a toma wo mu faxama.» ");
INSERT INTO sus_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Na tɛmui, e nu fa a fala e boore bɛ, «Iyo won tan nan yati fɔxi na won yɛtɛ ma, barima won na won xunya xa yamaɲɔxunyi to nɛ. A naxa won mayandi, kɔnɔ won ɲan mu a danxun. Na fe nan a toxi won na yi tɔɔrɛ kui.» ");
INSERT INTO sus_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben to wɔyɛnyi tongo, a naxa a fala e bɛ, «N na a fala nɛ wo bɛ, wo naxa gbaloe fe raba na dimɛdi ra. Kɔnɔ wo mu tin wo tuli matide n na. Yakɔsi a haakɛ nan won bɔnbɔfe yi ki.» ");
INSERT INTO sus_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","E mu nu a kolonxi a Yusufu e xa xui mɛma, barima xui madangi nu na e tagi. ");
INSERT INTO sus_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu naxa a makuya e ra, a nu fa wa. Na dangi xanbi, a naxa fa wɔyɛnde e bɛ. A naxa Simeyɔn tongo e ya ma, a a sa geeli e ya xɔri. ");
INSERT INTO sus_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu naxa yaamari fi a xa walikɛe ma, e xa e xa bɛkie rafe donse xɔri ra, e xa e xa kɔbiri fan sa kankan xa bɛkie kui a nun e fandɛ. Na naxa raba e bɛ. ");
INSERT INTO sus_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na tɛmui Yusufu xa taarae naxa e xa mɛngi kote sa sofalee fari, e naxa siga. ");
INSERT INTO sus_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","E to xide li, keren naxa a xa bɛki rabi alako a xa donse xɔri so a xa sofale yi ra. A naxa a xa kɔbiri to a xa bɛki kui. ");
INSERT INTO sus_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A naxa a fala a taarae bɛ, «E bara n ma kɔbiri ragbilen n ma. A tan nan na n ma bɛki kui yi ki.» E bɔɲɛe naxa mini. E nu fa e boore maxɔrin kɔntɔfili kui, «Ala munse rabaxi won na yi ki?» ");
INSERT INTO sus_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","E to so e baba Yaxuba yire Kanaan bɔxi ma, e naxa na birin dɛntɛgɛ a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","E naxa a fala, «Xɛmɛ naxan na na bɔxi mangɛ ra, a wɔyɛnxi nɛ muxu bɛ a xɔrɔxɔɛ ra. A man fa muxu findi mixie ra naxee faxi a xa bɔxi rabɛnde. ");
INSERT INTO sus_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Muxu naxa a fala a bɛ, ‹Mixi matinxinxie nan na muxu ra, bɔxi rabɛnyie xa mu lanxi muxu ma. ");
INSERT INTO sus_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Muxu di fu nun firin na a ra, muxu birin baba keren. Keren bara laaxira, muxu xunya na muxu baba fɛ ma Kanaan bɔxi ma.› ");
INSERT INTO sus_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Na xɛmɛ naxan na na bɔxi mangɛ ra, a falaxi nɛ muxu bɛ, ‹N wama a kolonfe nɛ xa mixi matinxinxie nan na wo ra. Wo mixi keren lu n yire be. Wo mɛngi xanin wo xa mixie xɔn, barima kaamɛ na e ma. Wo siga, ");
INSERT INTO sus_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","kɔnɔ wo man xa fa wo xunya ra n xɔn ma. N fama a kolonde na nan ma mixi matinxinxie nan wo ra, bɔxi rabɛnyie mu wo ra. Na tɛmui, n wo xunya soma wo yi ra, wo man fa yulɛya raba n ma bɔxi kui.›» ");
INSERT INTO sus_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","E to e xa bɛkie ibagan, kankan naxa a xa kɔbiri to a xa bɛki kui. E tan nun e baba to na kɔbiri to, e birin naxa gaaxu. ");
INSERT INTO sus_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E baba Yaxuba naxa a fala e bɛ, «Wo bara n nagan n ma die ra. Yusufu mu na fa, Simeyɔn fan mu na. Wo man waxi Bunyamin nan fan tongofe yi ki. Yi kote birin findixi n tan nan gbe ra.» ");
INSERT INTO sus_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben naxa a fala a baba bɛ, «Xa n mu Bunyamin nagbilen i ma, i xa n ma di firinyie faxa. Bunyamin so n yi ra, n man fama a ra.» ");
INSERT INTO sus_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaxuba naxa a yaabi, «Wo nun n ma di birin mu sigama, barima a taara bara faxa, a keren nan fa luxi. Xa fe nde sa a sɔtɔ wo xa biyaasi kui, n ma simaya raɲɔnyi findima n bɛ sunnunyi nan na wo fɔxi ra.» ");
INSERT INTO sus_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kaamɛ sɛnbɛ nu gboma nan tun Kanaan bɔxi kui. ");
INSERT INTO sus_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yaxuba nun a xa denbaya to bara gɛ mɛngi birin donde e fa naxan na kelife ra Misira, Yaxuba naxa a fala a xa die bɛ, «Wo man xa siga, wo xa sa donse nde sara won bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda naxa a yaabi, «Misira mangɛ a fala nɛ muxu bɛ a fanyi ra, ‹Wo mu n yatagi toma xa wo nun wo xunya birin mu fa.› ");
INSERT INTO sus_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Xa i bara tin muxu nun Bunyamin birin xa siga, muxu sigama nɛ, muxu sa donse sara i bɛ. ");
INSERT INTO sus_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kɔnɔ xa i mu tin na ra, muxu mu sigama, barima na xɛmɛ a fala nɛ muxu bɛ, ‹Wo mu n yatagi toma xa wo nun wo xunya birin xa mu fa.›» ");
INSERT INTO sus_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Na tɛmui Isirayila naxa a fala, «Munfe ra wo fe kobi ilanxi n na a falafe na xɛmɛ bɛ a xunya gbɛtɛ na wo bɛ?» ");
INSERT INTO sus_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","E naxa a yaabi, «Na xɛmɛ muxu maxɔrinxi nɛ a xɔrɔxɔɛ ra muxu bari ki ma. A nu fa a fala, ‹Wo baba man na simaya kui? Wo xunya nde na?› Muxu fan naxa a xa maxɔrinyi birin yaabi. Muxu ɲɔxɔ mu nu a ma, a falama, ‹Wo fa wo xunya ra.›» ");
INSERT INTO sus_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda naxa a fala a baba Isirayila bɛ, «A lu muxu nun dimɛdi xa siga. Muxu xa siga, na tɛmui won baloe sɔtɔma nɛ won mu faxa, i tan, muxu tan, a nun muxu xa die. ");
INSERT INTO sus_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I ya ti n tan na. I fama a maxɔrinde n tan nan ma. Xa n mu fa a ra, n fa a ti i ya i, na kote bara findi n gbe ra i mabiri. ");
INSERT INTO sus_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Yakɔsi, xa yi fe xa mu muxu rabuxi nu, muxu bara sigɛ nun fa firin naba nu.» ");
INSERT INTO sus_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","E baba Isirayila naxa a fala e bɛ, «Yi nan to fa a ra, wo fan yi nan nabama. Wo bɔxi daxamui ndee sa kote alako wo xa na xɛmɛ sanba wuri dole, kumi, surayi, labundɛ, kusu, nun foote kansi ra. ");
INSERT INTO sus_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Wo xa mɛngi sare singe, wo naxan toxi bɛkie kui, a nun mɛngi gbɛtɛ sare, wo xa na kɔbiri birin xanin wo xun. Tɛmunde na findixi nɛɛmui nan na. ");
INSERT INTO sus_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wo wo xunya tongo, wo xa siga na xɛmɛ yire. ");
INSERT INTO sus_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ala Sɛnbɛ Kanyi xa a niya na xɛmɛ xa kinikini wo ma, a xa wo xunya so wo yi ra a nun Bunyamin. Xa n tan fa ganma nɛ n ma die birin na, n bara yɛrɛlɛ.» ");
INSERT INTO sus_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yaxuba xa die naxa na sanbasee yailan. E naxa mɛngi sare singe kɔbiri tongo, a nun e lanma e xa mɛngi gbɛtɛ sara kɔbiri naxan na. E naxa siga Misira a nun Bunyamin, e sa e yɛtɛ dɛntɛgɛ Yusufu bɛ. ");
INSERT INTO sus_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu to Bunyamin to e ya ma, a naxa a fala a xa konyi bɛ, «Yi xɛmɛe xanin n xɔnyi. I xa xuruse ndee faxa, i donse yailan, alako muxu xa muxu dɛge yire keren to yanyi ra.» ");
INSERT INTO sus_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yusufu xa konyi naxa a xa yaamari raba keren na. A naxa Yaxuba xa die xanin Yusufu xɔnyi. ");
INSERT INTO sus_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Gaaxui naxa lu e ma a nu e xaninma tɛmui naxɛ Yusufu xɔnyi. E nu fa a fala e boore bɛ, «E na won xaninfe na kɔbiri nan ma fe ra, won naxan to won ma bɛkie kui. E fama nɛ dutunde won ma, e won ma sofalee tongo, e won findi konyie ra.» ");
INSERT INTO sus_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Na kui e naxa e maso Yusufu xa banxi konyi ra, e naxa wɔyɛn a ra banxi sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","E naxa a fala, «Yandi mangɛ, muxu singe bara fa be nu donse sarade. ");
INSERT INTO sus_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kɔnɔ muxu to muxu xide li gbilenfe ra muxu xɔnyi, muxu naxa muxu xa bɛkie rafulun, kankan naxa a xa kɔbiri to a xa bɛki kui na donse saraxi naxan na. Yakɔsi muxu man bara fa na kɔbiri ragbilende i ma. ");
INSERT INTO sus_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Muxu bara fa kɔbiri gbɛtɛ fan na, alako muxu man xa donse gbɛtɛ sara. Muxu mu a kolon mixi yo naxan na kɔbiri saxi muxu xa bɛkie kui.» ");
INSERT INTO sus_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mangɛ xa konyi naxa e yaabi, «Wo bɔɲɛ xa sa, wo naxa gaaxu. Ala na a ra, wo baba Marigi Ala nan na harige fixi wo ma wo xa bɛkie kui. N tan yati nan wo xa kɔbiri rasuxu.» Na tɛmui a naxa Simeyɔn ramini e ma, ");
INSERT INTO sus_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","a fa e raso Yusufu xɔnyi. A naxa ye so e yi ra, alako e xa e sanyie maxa. A naxa ɲooge so e xa sofalee yi ra donse ra. ");
INSERT INTO sus_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yusufu taarae naxa sanbasee yailan, beenu Yusufu soma tɛmui naxɛ yanyi ra, barima e nu bara a mɛ e e dɛgema naa nɛ. ");
INSERT INTO sus_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu to so banxi, e naxa a xa sanbasee so a yi ra, e e rafelen bɔxi ma a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu naxa e maxɔrin xa e yalanxi. A man naxa e maxɔrin, «Wo baba forixi wo naxan xa fe fala n bɛ, se mu a toxi? A man na simaya kui?» ");
INSERT INTO sus_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","E naxa a yaabi, «I xa konyi muxu baba, sese mu a sɔtɔxi. A man na simaya kui.» E man naxa e rafelen bɔxi ma a bun ma. ");
INSERT INTO sus_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu to a ya rakeli, a naxa a xunya Bunyamin to, a nga xa di. A naxa a fala, «Yi nan na wo xunya ra wo naxan xa fe fala n bɛ?» Yusufu naxa a fala Bunyamin bɛ, «N ma di, Ala xa hɛɛri fi i ma.» ");
INSERT INTO sus_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","A xunya xa fe kinikini naxa goro a sondonyi kui, wa xɔli naxa a suxu. A naxa keli mafuren, a so a xide a nu fa wa. ");
INSERT INTO sus_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yusufu to gɛ a ya rafurukude, a naxa mini, a na maɲɔxunyi ba a ya ra. A naxa yaamari fi, «Wo donse itaxun.» ");
INSERT INTO sus_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","A xa walikɛe naxa a gbe sa a xati ma, e a taarae gbe dɔxɔ e xati ma, e Misirakae gbe fan dɔxɔ e xati ma, barima Misirakae nun Eburu mixie mu e dɛgema yire keren. Misirakae xa naamunyi mu tinma na ra feo. ");
INSERT INTO sus_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufu xa walikɛe naxa a taarae magoro a ya xɔri. E birin nu magoroxi a fori ki ma, keli di singe ma han dimɛdi. Yi fe naxa e birin kaaba. ");
INSERT INTO sus_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufu to yaamari fi donse xa so e yi ra, Bunyamin xa donse nu dangi a taarae gbe ra dɔxɔ suuli. E birin naxa e dɛge, e min, han e wasa. ");
INSERT INTO sus_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu naxa yi yaamari so a xa banxi walikɛe xunyi yi ra, a naxɛ, «Yi mixie xa bɛkie rafe donse ra e nɔma naxan xaninde. I man xa e xa kɔbiri sa e xa bɛkie kui. ");
INSERT INTO sus_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","I xa n ma ye minse gbeti daaxi fan sa e birin xunya dɔnxɔɛ xa bɛki kui, a nun a xa mɛngi sara kɔbiri.» Yusufu fe naxan birin fala a xa walikɛ bɛ, a naxa a birin naba. ");
INSERT INTO sus_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kuye to iba gɛɛsɛgɛ, Yaxuba xa die naxa siga, e nun e xa sofalee ra. ");
INSERT INTO sus_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","E naxa keli taa kui, kɔnɔ beenun e xa makuya, Yusufu naxa a fala a xa walikɛ bɛ, «Keli, i siga na mixie fɔxɔ ra, i xa e suxu. I na e li, a fala e bɛ, ‹Wo fe fanyi masaraxi fe kobi ra munfe ra? ");
INSERT INTO sus_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Munfe ra wo n ma mangɛ xa ye minse gbeti daaxi se matose muɲaxi? Na fe mɔɔli mu fan.›» ");
INSERT INTO sus_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mangɛ xa walikɛ to e yire li, a naxa na birin fala e bɛ. ");
INSERT INTO sus_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","E naxa a yaabi, «Mangɛ, i wɔyɛnma yi mɔɔli ra munfe ra? Muxu tan, i xa konyie mu nɔma na mɔɔli rabade. ");
INSERT INTO sus_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Muxu kɔbiri naxan to bɛkie kui Kanaan, muxu bara fa a ra. Munfe ra muxu gbeti, xa na mu a ra xɛɛma, muɲama i xa mangɛ xa banxi kui? ");
INSERT INTO sus_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","I na sese to muxu yi ra naxan findixi Misira mangɛ gbe ra, i xa na kanyi faxa, i xa muxu tan dɔnxɔɛe fan findi i xa konyie ra.» ");
INSERT INTO sus_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mangɛ xa konyi naxa a fala, «Na bara fan. Wo naxan falaxi yi ki, n fan bara tin na ra. N na se keren to mixi naxan yi ra, na tan bara findi n ma konyi ra, wo tan dɔnxɔɛe bara kisi.» ");
INSERT INTO sus_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","E birin naxa e xa bɛkie ragoro mafuren, e naxa e rafulun. ");
INSERT INTO sus_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mangɛ xa konyi naxa e fɛtɛnkɛn fɔlɔ fori ma a sa dɔxɔ dimɛdi ra. Na ye minse gbeti daaxi naxa to Bunyamin xa bɛki kui. ");
INSERT INTO sus_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Na kui Yaxuba xa die naxa e xa donmae ibɔɔ. E birin naxa e xa kote baki sofalee fari, e man naxa gbilen taa kui. ");
INSERT INTO sus_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda nun a xunyae to Yusufu xɔnyi li, e naxa e felen a bun bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu naxa a fala e bɛ, «Wo yi rabaxi munfe ra? Wo mu a kolon, mixi alɔ n tan a nɔma se matode fe birin ma?» ");
INSERT INTO sus_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda naxa a yaabi, «N munse falama n ma mangɛ bɛ? N lan n xa munse fala? Muxu nɔma fiixɛde di? Ala bara i xa konyie to fe kobi xun ma. Muxu bara findi n ma mangɛ xa konyie ra, muxu tan nun yi ye minse gbeti daaxi toxi mixi naxan yi.» ");
INSERT INTO sus_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu naxa a fala, «N mu nɔma na mɔɔli rabade. Yi ye minse gbeti daaxi toxi mixi naxan yi ra, na nan na n ma konyi ra, kɔnɔ wo tan, wo siga xaxilisa kui wo baba yire.» ");
INSERT INTO sus_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Na xanbi Yuda naxa makɔrɛ mangɛ ra, a naxa a fala a bɛ, «N bara i mayandi n ma mangɛ, a lu n xa masenyi nde ti i bɛ. I bɔɲɛ naxa te n tan i xa konyi xili ma, barima i luxi nɛ alɔ Misira mangɛ. ");
INSERT INTO sus_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","A singe ra i muxu maxɔrin nɛ, fa a fala, ‹Wo baba na na? Wo xunya nde na na?› ");
INSERT INTO sus_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Muxu naxa i yaabi, ‹Muxu baba forixi na na, a nun muxu xunya, a naxan sɔtɔxi a xa xɛmɛforiɲa kui. Bunyamin taara bara faxa, a keren nan fa luxi a nga xa die ya ma, a tan nan nafan muxu baba ma.›» ");
INSERT INTO sus_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«I bara a fala muxu tan i xa konyie bɛ, ‹Wo fa a ra n xɔn ma alako n xa a to n ya ra.› ");
INSERT INTO sus_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Muxu naxa n ma mangɛ yaabi, ‹Yi dimɛdi mu kelima a baba sɛɛti ma, xa na mu a ra a baba faxama nɛ.› ");
INSERT INTO sus_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kɔnɔ i bara a fala i xa konyie bɛ, ‹Xa wo nun wo xunya birin mu fa, n mu n ya tima wo bɛ.› ");
INSERT INTO sus_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Muxu to siga n baba yire, i xa konyi, muxu naxa mangɛ xa dɛntɛgɛ sa a bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Na dangi xanbi, muxu baba man naxa a fala muxu bɛ, ‹Wo siga, wo xa sa donse nde sara won bɛ.› ");
INSERT INTO sus_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Muxu naxa a yaabi, ‹Muxu mu nɔma sigade xa muxu nun muxu xunya birin mu a ra. Xa biyaasi lanma, fo muxu nun muxu xunya xa siga. Xa na mu a ra, yi xɛmɛ mu muxu rasɛnɛma.› ");
INSERT INTO sus_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I xa konyi, n baba, a a fala nɛ muxu bɛ, ‹Wo a kolon n ma ginɛ di xɛmɛ firin nan barixi n bɛ. ");
INSERT INTO sus_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Keren kelixi nɛ n xun ma, n ɲɔxɔ luxi a ma tɛmunde sube nde bara a ibɔɔ, barima han yakɔsi n mu nu a to. ");
INSERT INTO sus_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Xa wo yi di fan tongo n xun ma, fe ɲaaxi nde naxa a sɔtɔ, n faxama nɛ na sunnunyi ra n fate.›» ");
INSERT INTO sus_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Yakɔsi xa n sa gbilen n baba yire, xa muxu nun yi dimɛdi birin xa mu a ra, ");
INSERT INTO sus_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","n baba faxama nɛ, barima a nii luuti nan Bunyamin na. A na a to yi dimɛdi mu na muxu fɔxɔ ra, muxu tan i xa konyie bara e baba forixi faxa sunnunyi ra a fate. ");
INSERT INTO sus_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","N tan i xa konyi, n dɔxɔxi nɛ sɛɛkɛ ra yi dimɛdi xa fe ra. N nu bara a fala n baba bɛ, ‹Xa n mu gbilen a ra i yire, na bara findi n ma kote ra n ma duniɲɛigiri birin kui.›» ");
INSERT INTO sus_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Yakɔsi n bara i mayandi, i xa tin n tan xa lu yi dimɛdi ɲɔxɔɛ ra, n xa findi i xa konyi ra, alako yi dimɛdi nun a taarae birin xa siga. ");
INSERT INTO sus_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","N nɔma sigade n baba yire di, xa muxu nun yi dimɛdi birin xa mu a ra? N mu nɔma a lude sunnunyi xa n baba faxa n ya xɔri.» ");
INSERT INTO sus_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufu to mu nu wama wafe a xa konyie ya xɔri, a naxa e yamari e birin xa mini. Na kui, a nu a yɛtɛ masenma a taarae bɛ tɛmui naxɛ, mixi gbɛtɛ yo mu nu na naa. ");
INSERT INTO sus_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yusufu naxa wa a xui itexi ra, han Misirakae nun Misira mangɛ xa mixi birin naxa na fe kolon. ");
INSERT INTO sus_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu naxa a masen a taarae bɛ, «Yusufu nan n na! N baba man na duniɲɛ?» Kɔnɔ a taarae mu nɔ a yaabide fefe ma. E dɛ bara ixara, e gaaxu a ya ra. ");
INSERT INTO sus_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu naxa a fala a taarae bɛ, «N bara wo maxandi, wo xa wo maso n na.» E naxa e maso a ra. A naxa a fala, «N tan nan na Yusufu ra, wo xunya, wo naxan mati a xa findi konyi ra Misirakae bɛ. ");
INSERT INTO sus_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yakɔsi wo bɔɲɛ naxa mini, wo naxa gaaxu, wo to bara n mati konyi ra, n saramae naxa fa n na yi bɔxi ma. Ala nan na ragirixi. A tan nan n xɛɛxi wo ya ra alako n xa wo rakisi. ");
INSERT INTO sus_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Wo bara a to, ɲɛ firin nan yi ki kaamɛ na bɔxi ma, kɔnɔ ɲɛ suuli man luxi. Bɔxi mu rawalima, sansi mu xabama. ");
INSERT INTO sus_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ala n nasanbaxi nɛ wo ya ra, alako n xa bɔxi donse nde ragata wo bɛ, wo xa nɔ balode maratangɛ kui. ");
INSERT INTO sus_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Wo tan xa mu faxi n na be. Ala na a ra. A tan nan n findi Misira mangɛ baba ra, a xa banxi nun a xa bɔxi birin xa lu n ma yaamari bun ma.» ");
INSERT INTO sus_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Wo xulun, wo xa siga n baba yire. Wo xa a fala a bɛ, ‹I xa di Yusufu yi nan falaxi, «Ala bara n findi Misira mangɛ ra. I xa siga n yire, i naxa dugundi. ");
INSERT INTO sus_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","I fama lude Gosen bɔxi nan ma n fɛ ma, i tan, i xa die, i xa mamadie, i xa xurusee, nun i harige birin. ");
INSERT INTO sus_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ɲɛ suuli kaamɛ man luxi. N i hayi birin fanma nɛ Gosen, alako i nun i xa denbaya naxa findi setaree ra.»›» ");
INSERT INTO sus_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«Wo bara a to wo yɛtɛ ya ra, n xunya Bunyamin fan bara a to, a n tan yati nan wɔyɛnfe wo bɛ. ");
INSERT INTO sus_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Wo xa n ma mangɛya sɛnbɛ tagi raba n baba bɛ, n na naxan kui Misira bɔxi ma, a nun wo fe naxan birin toxi. Wo wo xulun, wo xa fa n baba ra han be.» ");
INSERT INTO sus_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusufu naxa findigilin a xunya Bunyamin ma, e firin naxa wa a xɔrɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusufu naxa a taarae fan masunbu, e birin naxa wa. Na xanbi, a taarae naxa suusa wɔyɛnde a bɛ. ");
INSERT INTO sus_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Misira mangɛ naxa kolon sɔtɔ a ma, a Yusufu taarae bara fa. Na naxa rafan Misira mangɛ nun a xa mixi birin ma. ");
INSERT INTO sus_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","A naxa a masen Yusufu bɛ, «A fala i taarae bɛ, ‹Wo kote baki wo xa sofalee fari, wo xa siga Kanaan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Na tɛmui wo xa gbilen wo nun wo baba nun wo xabilɛ ra n yire. Se fanyi naxan birin na Misira bɔxi ma, n na a soma nɛ wo yi ra, wo man fa bɔxi daxamui fanyi don.› ");
INSERT INTO sus_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","I xa a fala i taarae bɛ, ‹Wo xa Misira gisee xanin, wo xa wo baba, wo xa die, nun wo xa ginɛe baki e kui, wo xa fa e ra. ");
INSERT INTO sus_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wo naxa mɔnɛ sese xa fe ra, barima se fanyi naxan birin na Misira bɔxi ma, a findima wo gbe nan na.›» ");
INSERT INTO sus_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Isirayila xa die naxa na raba. Yusufu naxa gisee so a taarae yi ra alɔ Misira mangɛ a fala a bɛ ki naxɛ. A naxa fandɛ fan so e yi ra e naxan donma kira ra. ");
INSERT INTO sus_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A naxa donma fanyie fi a taarae birin ma. Kɔnɔ a kɔbiri kole kɛmɛ saxan nan fi Bunyamin tan ma, a nun donma suuli. ");
INSERT INTO sus_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A naxa Misira daxamui fanyi baki sofale fu fari a baba xa sanbɛ. A man naxa donse xɔri, taami, nun fandɛ gbɛtɛe baki sofale ginɛ fu fari a baba xa biyaasi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na dangi xanbi, a naxa a taarae lu e xa siga. A naxa a fala e bɛ, «Wo naxa galanbu kira xɔn ma de!» ");
INSERT INTO sus_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","E naxa keli Misira, e te Kanaan bɔxi ma e baba Yaxuba yire. ");
INSERT INTO sus_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E naxa a fala a bɛ, «Yusufu mu faxaxi! A tan nan Misira bɔxi birin yamarima!» Yaxuba to na mɛ, a mu nɔ lade na ra. ");
INSERT INTO sus_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kɔnɔ e to Yusufu xa masenyi birin dɛntɛgɛ a bɛ, a ya fan naxa gisee to Yusufu naxee rasanbaxi a xaninfe ra, Yaxuba naxa sɛɛwa. ");
INSERT INTO sus_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isirayila naxa a fala, «N bara ɲɛlɛxin, n ma di Yusufu man na ɲɛngife. Beenun n xa faxa, n fama nɛ a tode.» ");
INSERT INTO sus_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yaxuba naxa a harige birin xanin a xun ma. A to Beriseeba li, a naxa sɛrɛxɛ ba a baba Isiyaga Marigi Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ala naxa Isirayila xili xiye kui, «Yaxuba, Yaxuba.» Isirayila naxa a ratin, «N tan nan ya.» ");
INSERT INTO sus_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ala naxa a masen a bɛ, «N tan nan na Ala ra, i baba Marigi Ala. Hali i mu gaaxu sigafe ra Misira, barima n i findima si belebele nan na. ");
INSERT INTO sus_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Won birin nan sigama Misira, n tan nan man fama i ragbilende be. Yusufu yati nan fama i yae ragalide i ɲɔn tɛmui.» ");
INSERT INTO sus_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na kui, Yaxuba naxa keli Beriseeba. Isirayila xa die naxa e baba Yaxuba, e xa die, a nun e xa ginɛe baki gisee kui, Misira mangɛ naxee rasanba. ");
INSERT INTO sus_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","E naxa e xa xurusee tongo, a nun e se naxan birin sɔtɔ Kanaan bɔxi ma. Yaxuba naxa siga Misira a nun a bɔnsɔɛ birin. ");
INSERT INTO sus_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A naxa a xa die nun a xa mamadie birin xanin a xun ma. A naxa siga a tan nun a bɔnsɔɛ birin. ");
INSERT INTO sus_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isirayila xa die xili nan ya naxee siga Misira. Yaxuba nun a xa di xɛmɛe xa taruxui nan ya: Yaxuba xa di singe lanxi Ruben nan ma. ");
INSERT INTO sus_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben xa die nan ya: Hanoki, Palu, Heseron, nun Karimi. ");
INSERT INTO sus_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔn xa die nan ya: Yemuweli, Yamin, Ohadi, Yakin, Soxara, nun Soli. Soli findi Kanaan ginɛ xa di nan na. ");
INSERT INTO sus_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi xa die nan ya: Gerison, Kohata, nun Merari. ");
INSERT INTO sus_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda xa die nan ya: Eri, Onan, Selaha, Peresi, nun Sera. Kɔnɔ Eri nun Onan faxa Kanaan bɔxi nan ma. Peresi xa die findi Heseron nun Hamuli nan na. ");
INSERT INTO sus_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari xa die nan ya: Tola, Puwa, Yasubu, nun Simiron. ");
INSERT INTO sus_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sabulon xa die nan ya: Seredi, Elon, nun Yaxaleeli. ");
INSERT INTO sus_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Die nan na ki, Leya naxee bari Yaxuba bɛ Padan Arami. A man naxa a xa di ginɛ Dina bari naa. A xa di xɛmɛe nun di ginɛe kɔnti birin nalanxi mixi tongo saxan a nun saxan. ");
INSERT INTO sus_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi xa die nan ya: Sefon, Hagi, Suni, Esibon, Eri, Arodi, nun Areli. ");
INSERT INTO sus_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseri xa die nan ya: Yimina, Yisiwa, Yisiwi, Beriya, a nun e xunya ginɛma Sera. Beriya xa die findi Heberi nun Malakiyeli nan na. ");
INSERT INTO sus_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Die nan na ki, Silipa naxee bari Yaxuba bɛ. E birin nalanxi mixi fu nun senni. Laban nu bara Silipa so a xa di ginɛ Leya yi ra. ");
INSERT INTO sus_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaxuba xa ginɛ Raxele xa die nan ya: Yusufu nun Bunyamin. ");
INSERT INTO sus_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asena naxa di firin sɔtɔ Yusufu bɛ Misira bɔxi ma: Manasi nun Efirami. Asana nan lanxi On sɛrɛxɛdubɛ Potifari xa di ginɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bunyamin xa die nan ya: Bela, Bekeri, Asibeli, Gera, Naaman, Eki, Rosi, Xupimi, Mupimi, nun Arade. ");
INSERT INTO sus_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Die nan na ki, Raxele naxee bari Yaxuba bɛ. E birin nalanxi mixi fu nun naani. ");
INSERT INTO sus_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dana xa di nan ya: Xusimi. ");
INSERT INTO sus_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatali xa die nan ya: Yaxaseeli, Guni, Yeseri, nun Silemi. ");
INSERT INTO sus_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Die nan na ki, Bila naxee bari Yaxuba bɛ. E birin nalanxi mixi solofere. Laban nu bara Bila so a xa di ginɛ Raxele yi ra. ");
INSERT INTO sus_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaxuba nun mixi naxee birin siga Misira, a bɔnsɔɛ birin nalanxi mixi tongo senni nun senni, bafe a xa die xa ginɛe ra. ");
INSERT INTO sus_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusufu di xɛmɛ firin nan bari Misira. Yaxuba xabilɛ naxan siga Misira bɔxi ma, e kɔnti birin nalanxi mixi tongo solofere. ");
INSERT INTO sus_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaxuba naxa Yuda xɛɛ a ya ra Yusufu xɔn ma, alako a xa kira yailan e bɛ sigafe ra Gosen. E to so Gosen bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu naxa a gise tongo, a naxa siga a baba Isirayila ralande naa. A to a li, a naxa findigilin a ma, a nu fa wa ra a xɔnkuye ra. ");
INSERT INTO sus_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isirayila naxa a fala Yusufu bɛ, «Hali n faxa fa, n bɔɲɛ bara sa barima n bara i yatagi to, i man na ɲɛngife.» ");
INSERT INTO sus_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu naxa a fala a taarae bɛ, a nun a baba xa denbaya, «N xa siga, n xa sa a fala Misira mangɛ bɛ, ‹N taarae nun n baba xa denbaya naxee nu sabatixi Kanaan bɔxi ma, e birin bara fa n yire. ");
INSERT INTO sus_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yi mixie gɔɔrɛ kanyie nan e ra. E xurusee nan dɛmadonma. E bara fa e xa gɔɔrɛe ra, sie, yɛxɛɛe, ningee, nun e harige birin.› ");
INSERT INTO sus_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Misira mangɛ na wo xili tɛmui naxɛ, a wo maxɔrinma nɛ wo xa wali ma. ");
INSERT INTO sus_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Wo xa a yaabi, ‹Muxu tan i xa konyie findixi xuruse maxurie nan na, kabi muxu dimɛdi tɛmui han yakɔsi, alɔ muxu benbae nu a rabama ki naxɛ.› Na kui wo fama lude Gosen bɔxi nan ma, barima xuruse dɛmadonyie raɲaaxu Misirakae ma.» ");
INSERT INTO sus_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu naxa siga a sa a fala Misira mangɛ bɛ, «N baba nun n ngaxakerenyie bara fa Gosen kelife Kanaan bɔxi ma. E bara fa e xa xurusee nun e harige birin na.» ");
INSERT INTO sus_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A naxa a taara suuli ndee masen Misira mangɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Misira mangɛ naxa Yusufu taarae maxɔrin, «Wo wali mundun nabama?» E naxa Misira mangɛ yaabi, «Muxu tan i xa konyie findixi xuruse dɛmadonyie nan na, alɔ muxu benbae nu a rabama ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","E man naxa a fala Misira mangɛ bɛ, «Muxu faxi nɛ, muxu xa lu yi bɔxi ma sinden, barima sɛxɛ mu na muxu xɔnyi kɔrɛ xurusee naxan donma. Kaamɛ bara din Kanaan bɔxi ra. Muxu bara i mayandi i xa muxu tan i xa konyie sago sa, muxu xa lu Gosen bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Misira mangɛ naxa a fala Yusufu bɛ, «I baba nun i taarae bara fa i fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misira bɔxi na i sagoe. Yire fanyi fen Gosen mabiri, i baba nun i ngaxakerenyie luma dɛnnaxɛ. Xa i mixi matinxinxie kolon e ya ma, e sugandi e xa findi n ma xuruse dɛmadonyie ra.» ");
INSERT INTO sus_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Na dangi xanbi, Yusufu naxa a baba xanin Misira mangɛ yire, a a masen a bɛ. Yaxuba naxa duba Misira mangɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Misira mangɛ naxa Yaxuba maxɔrin, «I xa simaya ɲɛ yeri a ra yi ki?» ");
INSERT INTO sus_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaxuba naxa Misira mangɛ yaabi, «N ma simaya ɲɛ kɛmɛ ɲɛ tongo saxan na a ra yi ki. N simaya dunke naxasixi nan sɔtɔxi. A ɲan mu makɔrɛxi n benbae xa simaya xasabi ra.» ");
INSERT INTO sus_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yaxuba to duba Misira mangɛ bɛ, a naxa siga. ");
INSERT INTO sus_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu naxa bɔxi fanyi fi a baba nun a taarae ma, alɔ Misira mangɛ a yamari ki naxɛ. E bɔxi naxan sɔtɔ a tan nan fan Misira bɔxi birin bɛ. A xili Ramesesi. ");
INSERT INTO sus_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu naxa mɛɛni a baba, a taarae, nun a baba xa denbayae birin ma. ");
INSERT INTO sus_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na tɛmui kaamɛ nu bara sɛnbɛ sɔtɔ. Donse mu nu toma keli Misira bɔxi ma han Kanaan. Kaamɛ naxa ɲama halaki. ");
INSERT INTO sus_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kɔbiri naxan birin nu na Misira nun Kanaan bɔxi ma, Yusufu naxa a masara mɛngi ra. A naxa na kɔbiri ragata Misira mangɛ xa banxi kui. ");
INSERT INTO sus_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misirakae nun Kanaankae xa kɔbiri birin to ɲɔn, Misirakae naxa fa Yusufu yire e a fala, «Donse so muxu yi ra! A lanma muxu xa faxa i ya xɔri? Muxu xa kɔbiri birin bara ɲɔn.» ");
INSERT INTO sus_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu naxa e yaabi, «Wo fa wo xa xurusee ra, won xa a masara donse ra, barima kɔbiri mu na wo yi ra.» ");
INSERT INTO sus_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","E naxa fa e xa xurusee ra Yusufu xɔn ma. E xa soe, sie, yɛxɛɛe, ningee, nun sofalee, e nee birin masara Yusufu ma donse ra. A naxa donse taxun e ra e xa xurusee masarɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Na ɲɛ to dangi, e naxa fa a yire, e a fala a bɛ, «Muxu mu nɔma muxu nɔxunde muxu xa mangɛ ma. Kɔbiri yo mu na muxu yi ra. Muxu xa xuruse fan birin na muxu xa mangɛ yi ra. Muxu gundie nun muxu xa bɔxie gbansan nan luxi muxu yi ra donse sare ra muxu xa mangɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","A lanma muxu xa faxa i ya xɔri, muxu xa bɔxie xun xa rakana? Muxu nun muxu xa bɔxie masara donse ra, muxu xa findi Misira mangɛ xa konyie ra, muxu xa bɔxie fan xa findi a gbe ra. Sansi xɔri so muxu yi ra muxu naxan nawalima, muxu xa balo alako muxu naxa faxa, bɔxi fan naxa rabɛɲin.» ");
INSERT INTO sus_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Na kui Yusufu naxa Misirakae xa bɔxi birin sara Misira mangɛ bɛ. Kaamɛ xa xɔrɔxɔɛ nu bara a niya e xa e xa bɔxi birin mati Misira mangɛ ma. ");
INSERT INTO sus_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusufu Misira ɲama birin findi konyie ra na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kɔnɔ sɛrɛxɛdubɛe tan mu e gbe bɔxie sara, barima Misira mangɛ nu hinnɛma e ra donse fe ra. ");
INSERT INTO sus_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu naxa a fala ɲama bɛ, «N bara wo sara to a nun wo xa bɔxie Misira mangɛ bɛ. Sansi nan yi ki, wo xa bɔxie rawali. ");
INSERT INTO sus_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A xaba tɛmui, wo a dɔxɔ suuli nde soma Misira mangɛ nan yi ra. Dɔxɔ naani naxee luma, na findima sansi nun baloe nan na, wo tan, wo xa die, a nun wo xa mixi birin bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","E naxa a fala, «I bara muxu rakisi! Muxu bara muxu xa mangɛ xa fe fanyi to a naxan nabaxi muxu bɛ. Muxu findima Misira mangɛ xa konyie nan na.» ");
INSERT INTO sus_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufu naxa na findi sɛriyɛ ra. Han to Misira bɔxi daxamui dɔxɔ suuli nde birin findi Misira mangɛ nan gbe ra. Sɛrɛxɛdubɛe xa bɔxie nan gbansan mu findixi Misira mangɛ gbe ra. ");
INSERT INTO sus_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isirayilakae naxa sabati Gosen Misira bɔxi ma. Na bɔxi naxa findi e gbe ra. E bɔnsɔɛ naxa gbo yɛ. ");
INSERT INTO sus_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaxuba ɲɛ fu nun solofere nan naba Misira bɔxi ma. A xa simaya naxa ɲɛ kɛmɛ ɲɛ tongo naani nun solofere li. ");
INSERT INTO sus_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Isirayila xa simaya to nu fa ɲɔnfe, a naxa a xa di Yusufu xili, a a fala a bɛ, «Na kui, i xa i bɛlɛxɛ dɔxɔ n tabe bunyi ra, i fa i kali n bɛ fa a falafe ra, i mu n nagatama yi Misira bɔxi ma, i xa mɛɛni n ma tinxinyi kui, i hinnɛ n na. ");
INSERT INTO sus_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","N na laaxira tɛmui naxɛ, i xa n namini Misira, i sa n nagata n benbae xa gaburi yire.» Yusufu naxa a yaabi, «I naxan falaxi n bɛ, n na rabama nɛ.» ");
INSERT INTO sus_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaxuba naxa a fala, «I rakali n bɛ.» Yusufu naxa a kali a bɛ. Na tɛmui Yaxuba naxa a felen a xa sade xunyi ra. ");
INSERT INTO sus_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Na fe birin to bara dangi, e naxa a fala Yusufu bɛ, «I baba mu yalanxi.» Yusufu naxa siga a baba yire, a nun a xa di xɛmɛ firinyie, Manasi nun Efirami. ");
INSERT INTO sus_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mixi nde naxa a fala Yaxuba bɛ, «I xa di Yusufu bara fa.» Isirayila naxa sɛnbɛ raba, a keli, a dɔxɔ sade ma. ");
INSERT INTO sus_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaxuba naxa a fala Yusufu bɛ, «Ala Sɛnbɛ Kanyi mini nɛ n ma Lusi Kanaan bɔxi ma. A naxa barakɛ sa n ma fe. ");
INSERT INTO sus_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ala naxa a fala n bɛ, ‹N i findima dibari belebele nan na. N i xa die rawuyama nɛ, han e findi ɲama gbegbe ra. N yi bɔxi fima nɛ i bɔnsɔɛ ma, hali i dangi xanbi, a findi e gbe ra han duniɲa ɲɔn.›» ");
INSERT INTO sus_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Yakɔsi yi di firinyie, i naxee barixi Misira beenun n tan xa fa, n bara e findi n ma die ra. Efirami nun Manasi findima n tan nan gbe ra, alɔ Ruben nun Simeyɔn. ");
INSERT INTO sus_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kɔnɔ i di naxee barima yee xanbi ra, i gbe lanxi nee nan ma. E fama lude e taarae nan bun ma e kɛ xa fe ra. ");
INSERT INTO sus_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","N to keli Padan, Raxele naxa faxa n yi ra kira xɔn Kanaan bɔxi ma. A ɲɔnde mu nu makuya Efarata ra. N naxa a ragata mɛnni, Efarata kira ra, dɛnnaxɛ xili Bɛtɛlɛɛmu.» ");
INSERT INTO sus_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isirayila naxa Yusufu xa die mato, a fa a fala, «Ndee yee ra?» ");
INSERT INTO sus_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu naxa a baba yaabi, «N ma di xɛmɛe na e ra Ala naxee fixi n ma be.» Isirayila naxa a fala, «I xa e maso n na, alako n xa duba e bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yaxuba nu bara gɛ foride, a yae mu nu see igbɛma sɔnɔn. Yusufu to a xa die maso a ra, Isirayila naxa e masunbu, a findigilin e ma. ");
INSERT INTO sus_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isirayila naxa a fala Yusufu bɛ, «N mu nu laxi a ra, xa n i yatagi toma sɔnɔn, kɔnɔ Ala bara a ragiri n bara i xa die fan to.» ");
INSERT INTO sus_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu naxa a xa die tongo a baba san ma, a fa a rafelen bɔxi fari. ");
INSERT INTO sus_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Na dangi xanbi, Yusufu naxa a xa di firinyie tongo e bɛlɛxɛ ma. A naxa Efirami suxu a yirefanyi bɛlɛxɛ ra, Isirayila kɔɔla mabiri. A naxa Manasi suxu a kɔɔla bɛlɛxɛ ra, Isirayila yirefanyi mabiri. A naxa e maso a ra. ");
INSERT INTO sus_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kɔnɔ Yaxuba naxa a yirefanyi bɛlɛxɛ sa Efirami xunyi fari naxan na dimɛdi ra. A naxa a kɔɔla bɛlɛxɛ sa Manasi xunyi fari naxan na di singe ra. A nu a kolon a nu fe naxan nabama a bɛlɛxɛe ra. ");
INSERT INTO sus_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A naxa duba Yusufu bɛ, a fa a fala, «Ala, n benbae Iburahima nun Isiyaga ɲɛrɛ naxan ya xɔri, Ala naxan na n kantama ra, kafi n bari lɔxɔɛ han to, ");
INSERT INTO sus_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ala naxan malekɛ xɛɛxi n natangade fe xɔrɔxɔɛ ma, a xa barakɛ sa yi dimɛe xa fe. Mixie xa e xili n xili ra, e xa e xili n benbae Iburahima nun Isiyaga xili ra. E bɔnsɔɛ xa wuya a gbegbe ra duniɲa.» ");
INSERT INTO sus_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu naxa a to a baba bara a yirefanyi bɛlɛxɛ sa Efirami xunyi ma. Na fe mu rafanxi a ma. A naxa a baba bɛlɛxɛ suxu, a ba Efirami xunyi ma, a fa a sa Manasi xunyi ma. ");
INSERT INTO sus_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu naxa a fala a baba bɛ, «N baba, na ki xa mu a ra, barima yi nan na fori ra. I yirefanyi bɛlɛxɛ sama yi nan xunyi ma.» ");
INSERT INTO sus_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","A baba naxa tondi, a fa a fala, «N ma di, n a kolon, n a kolon. A fan fama findide bɔnsɔɛ wuyaxi kanyi nan na. A fan gboma nɛ, kɔnɔ a xunya nan fama gbode dangife a ra. A xunya bɔnsɔɛ findima nɛ si wuyaxi ra.» ");
INSERT INTO sus_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A naxa duba e bɛ na lɔxɔɛ, a fa a fala, «Isirayilakae duba rabama wo xilie nan na. E fama a falade, ‹Ala xa i lu alɔ Efirami nun Manasi.›» Na kui a naxa Efirami ti yare Manasi bɛ. ");
INSERT INTO sus_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Isirayila naxa a fala Yusufu bɛ, «I bara a to, a gbe mu luxi n xa laaxira, kɔnɔ Ala tima nɛ i fanga ra, a fa i ragbilen i benbae xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","N fama kɛ fide i ma dangi i taarae ra. N bɔxi naxan nasuxu Amorikae yi ra n ma santidɛgɛma nun n ma xali saabui ra, n bara na fan sa i kɛ fari.» ");
INSERT INTO sus_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaxuba naxa a xa die xili, a naxa a fala e bɛ, «Wo xa wo malan, n xa fe fala naxan fama rabade wo bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Yaxuba xa die, wo fa be, wo xa wo tuli mati wo baba Isirayila ra. ");
INSERT INTO sus_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, i tan, n ma di singe, i tan nan na n ma fonike di ra. I bara findi fisamante ra lasiriya kui. I sɛnbɛ dangi birin na. ");
INSERT INTO sus_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kɔnɔ i to findi xurutare nan na, alɔ ye naxan susuma, i mu fisamanteya sɔtɔma sɔnɔn, barima i bara i sa i baba xa sade ma a nun i nanden. Na bara findi sɛniyɛntareɲa ra. ");
INSERT INTO sus_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyɔn nun Lewi findixi ngaxakerenmae nan na. Santidɛgɛma nan na e xa geresose ra. ");
INSERT INTO sus_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","N mu soma e xa fefe ya ma, n mu tinma dɔxɔde e xa malanyi, barima e xa bɔɲɛte kui e bara xɛmɛe faxa, e xa kalabanteɲa kui e bara tuurae maxɔnɔ fufafu. ");
INSERT INTO sus_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","N bara e xa bɔɲɛte danka, barima geregirie nan e ra. E naxan nabama, n bara na danka, barima e ya ixara. E bɔnsɔɛ mu luma yire keren Yaxuba xɔnyi, n e rayensenma nɛ Isirayila bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, i xunyae i tan nan tantuma. I fama nɛ xutu sɔtɔde i yaxuie ma. I baba xa di xɛmɛe magoroma nɛ i bɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, yɛtɛ yɔrɛ nan lanxi i ma. N ma di, i baloma sube nan xun na. I xinbie kuntanma nɛ alɔ yɛtɛ. Nde nɔma suusade a xa i rakeli? ");
INSERT INTO sus_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mangɛ sawuri fama lude Yuda bɔnsɔɛ nan yi. Mixi yo mu mangɛ sawuri bama a yi, beemanu tɔnxuma kanyi fama tɛmui naxɛ, sie suyidima naxan bɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A xa sofale xirima wɛni bili nan na, a xa sofale yɔrɛ xirima wɛni bili fanyi nan na. A xa donma nun a xa xinbeli donma xama wɛni ye nan na. ");
INSERT INTO sus_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A ya maɲingixi alɔ wɛni, A ɲinyi fiixɛ alɔ xiɲɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabulon fama sabatide baa dɛ nɛ. A findima wafu dɛ nan na kunkuie bɛ. A xa naaninyi luma nɛ Sidɔn nan sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari sɛnbɛ gbo alɔ sofale, naxan a sama gɔɔrɛ firinyie tagi. ");
INSERT INTO sus_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A saxi bɔxi naxan ma, yire fanyi nan a ra. A tunki felenma nɛ kote bun ma, a luma yaamari nan bun ma. ");
INSERT INTO sus_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dana a xa ɲama yamarima nɛ, alɔ Isirayila bɔnsɔɛ nde. ");
INSERT INTO sus_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","A luma nɛ alɔ bɔximase kira xɔn ma, alɔ tanbalunbe sankira ra. A na soe tingilinyi xin, soe ragi birama nɛ a fari ma. ");
INSERT INTO sus_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Alatala, n xaxili tixi i xa kisi ra. ");
INSERT INTO sus_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi, geresoe a gerema nɛ, kɔnɔ a tan nan e raboronma a tingilinyi ra. ");
INSERT INTO sus_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aseri xa bɔxi findima daxamui fanyi yire nan na, naxan findima mangɛ daxamude ra. ");
INSERT INTO sus_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatali luma nɛ alɔ xeli ginɛ naxan na a gife, a wɔyɛn fanyie falama nɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu luma nɛ alɔ sansi burɛxɛ nɛɛnɛ, naxan bogima a fanyi ra xure sɛɛti ma. A salonyie tima tɛtɛ nan xun. ");
INSERT INTO sus_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mixie naxa gere giri a ma, e naxa xali woli a ma gere ra. ");
INSERT INTO sus_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kɔnɔ a xa xali sɛnbɛ gbo, a bɛlɛxɛ fan xɔrɔxɔ Yaxuba Marigi Ala Sɛnbɛ Kanyi saabui ra, naxan findixi Isirayila kantama ra, naxan luxi alɔ fanye. ");
INSERT INTO sus_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","I baba Marigi Ala fama i malide. Ala Sɛnbɛ Kanyi barakɛ sama nɛ i xa fe. A koore barakɛ fima nɛ i ma, a bɔxi barakɛ fi i ma, a dibari barakɛ ragiri i ma. ");
INSERT INTO sus_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","I baba xa dubɛ dangi baloe nun se fanyi birin na, naxan kelima geya fari, geya naxan tixi kafi duniɲa fɔlɛ. Na barakɛ birin xa lu Yusufu ma, naxan findi a ngaxakerenyie xa mangɛ ra. ");
INSERT INTO sus_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bunyamin luma nɛ alɔ wulai bare xaaɲɛ. A sube faxama gɛɛsɛgɛ, a a dɔnxɔɛ don nunmare.» ");
INSERT INTO sus_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isirayila bɔnsɔɛ fu nun firinyie nan na ki, a nun dubɛ e baba naxan nabaxi kankan bɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na dubɛ dangi xanbi, Yaxuba naxa a ɲungu a xa die ma, a falafe ra, «N fa sigafe n benba faxaxie nan yire. N na faxa, wo n nagata n benbae ragatade, gaburi naxan na Eferon Xitika xa xɛ yire, ");
INSERT INTO sus_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makipela xɛ fɔnmɛ ra, Mamire fɛ ma, Kanaan bɔxi ma. Iburahima na xɛ saraxi Eferon Xitika nan ma, alako na xa findi a xa mixi ragatade ra. ");
INSERT INTO sus_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iburahima ragataxi mɛnni nɛ, a nun a xa ginɛ Sara. Isiyaga fan nagataxi mɛnni nɛ a nun a xa ginɛ Rebeka. N tan fan Leya ragataxi mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Na xɛ nun na fɔnmɛ naxan na naa, e saraxi Xitikae nan ma.» ");
INSERT INTO sus_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaxuba to bara gɛ a xa wɔyɛnyi masende a xa die bɛ, a naxa a sa sade ma, a fa laaxira, a a benbae li aligiyama. ");
INSERT INTO sus_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu naxa findigilin a baba ma, a masunbu, a wama. ");
INSERT INTO sus_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na dangi xanbi, Yusufu naxa yaamari fi seribae ma e xa a baba fate sɔxɔ seri ra, alako a fure naxa bɔrɔ. E naxa na wali raba a baba Isirayila ra ");
INSERT INTO sus_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","xi tongo naani bun ma e xa naamunyi ki ma. Misirakae naxa a ɲɔnfe raba xi tongo solofere bun. ");
INSERT INTO sus_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ɲɔn fe to bara ba a ra, Yusufu naxa a fala Misira mangɛ xa mixie bɛ, «N bara wo mayandi, xa n ma fe rafan wo ma, wo xa n waxɔnfe masen Misira mangɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","N baba n nakali nɛ, a naxɛ, ‹N fa na faxafe nɛ. I n nagatama gaburi nan kui n naxan gexi Kanaan bɔxi ma.› Na kui n wama sigafe nɛ n xa sa n baba ragata. N na gɛ, n fama.» ");
INSERT INTO sus_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Misira mangɛ naxa a yaabi, «Siga, i xa sa i baba ragata alɔ a i rakalixi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusufu naxa siga a baba ragatade. A naxa siga a nun Misira mangɛ xa konyie, Misira mangɛ xa mixi xungbee, Misira kuntigie, ");
INSERT INTO sus_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","a yɛtɛ xa denbaya, a taarae, nun a baba xa denbaya. E xa dimɛdie nun e xa xurusee gbansan naxa lu Gosen bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sɔɔrie nun soe ragie naxa Yusufu mati e xa gisee kui. Ɲama belebele nan nu e ra. ");
INSERT INTO sus_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","E to Atadi lonyi li Yurudɛn naakiri ma, e naxa ɲɔn fe belebele raba. Yusufu naxa binyɛ fi a baba ma, a ɲɔn fe xanin han xi solofere. ");
INSERT INTO sus_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanaankae naxa e ɲɔxɔ dɔxɔ na maragatɛ xɔn ma, naxan nabaxi Atadi xa lonyi ma. E naxa a fala, «Yi ɲɔn fe findi fe belebele nan na Misirakae bɛ.» Na nan a toxi e naxa «Misira Ɲɔn fe» xili fala na yire xun Yurudɛn naakiri ma. ");
INSERT INTO sus_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Na kui, Yaxuba xa die naxa e baba waxɔnfe raba alɔ a a fala e bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","E naxa a xanin Kanaan bɔxi ma, e naxa a ragata Makipela xa xɛ yire fɔnmɛ kui, Iburahima xɛ naxan sara Eferon Xitika ma alako na xa findi mixi ragatade ra Mamire sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu to gɛ a baba ragatade, a naxa gbilen Misira bɔxi ma, a nun a taarae nun mixi naxan birin a mati. ");
INSERT INTO sus_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yusufu taarae to bara a to e baba bara faxa, e naxa a fala, «Xa Yusufu fa won findi a gerefa ra, won fe ɲaaxi naxan birin nabaxi a ra, a gbeɲɔxɔma nɛ won ma.» ");
INSERT INTO sus_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na kui e naxa siga Yusufu yire, e a fala a bɛ, «I baba yi nan falaxi muxu bɛ beenun a xa faxa, a naxɛ, ");
INSERT INTO sus_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Wo yi fala Yusufu bɛ, «N bara i maxandi, diɲɛ i taarae xa gbaloe fe ma a nun e xa yunubi, barima e bara fe ɲaaxi raba i ra. N bara i maxandi, yakɔsi diɲɛ i baba Marigi Ala xa konyie ma.»›» E to na masenyi fala Yusufu bɛ, a naxa wa. ");
INSERT INTO sus_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A taarae naxa e felen a bun ma, e fa a fala, «Muxu tan nan ya, i xa konyie.» ");
INSERT INTO sus_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusufu naxa a fala e bɛ, «Hali wo mu gaaxu. Ala mu na n tan xa ra. ");
INSERT INTO sus_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wo lan nɛ n xun wo naxa fe ɲaaxi raba n na, kɔnɔ Ala naxa a masara fe fanyi ra alako n xa fe rakamali ɲama nii ratangafe ra. ");
INSERT INTO sus_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yakɔsi hali wo mu gaaxu. N wo hayi birin fanma nɛ nun wo xa die.» A xa wɔyɛnyi naxa e bɔɲɛ sa. ");
INSERT INTO sus_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu naxa lu Misira, a tan nun a xa denbaya birin. A naxa ɲɛ kɛmɛ ɲɛ fu sɔtɔ simaya ra. ");
INSERT INTO sus_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu naxa a xa mamadie nun a tolobitɛe to, a xa di Efirami naxee sɔtɔ. A naxa Manasi xa di Makiri xa die to, a nee tongo a gbe die ra. ");
INSERT INTO sus_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu naxa a fala a taarae bɛ, «N fan na faxafe nɛ, kɔnɔ Ala wo malima nɛ a fanyi ra. A fama nɛ wo tongode Misira, a wo xanin bɔxi ma a dɛnnaxɛ laayidi tongo Iburahima, Isiyaga, nun Yaxuba bɛ.» ");
INSERT INTO sus_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufu naxa Isirayila xa die rakali, a fa a fala, «Ala na wo mali gbilenfe ra Kanaan bɔxi ma, wo xa n fure xanin naa.» ");
INSERT INTO sus_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu laaxira a ɲɛ kɛmɛ ɲɛ fu nan ma. E naxa a fure sɔxɔ seri ra alako a fate naxa bɔrɔ, e a ragata fure kankira kui Misira bɔxi ma.");
INSERT INTO sus_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Isirayila xa die xilie nan ya, naxee e baba Yaxuba mati Misira bɔxi ma, a nun e xa denbayae: ");
INSERT INTO sus_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeyɔn, Lewi, Yuda, ");
INSERT INTO sus_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Sabulon, Bunyamin, ");
INSERT INTO sus_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dana, Nafatali, Gadi, nun Aseri. ");
INSERT INTO sus_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaxuba xa die nun a xa mamadie nu lanxi mixi tongo solofere nan ma. A xa di Yusufu ɲan nu bara siga Misira. ");
INSERT INTO sus_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yusufu nun a ngaxakerenyie dangi xanbi, ");
INSERT INTO sus_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isirayilakae naxa yiriwa Misira bɔxi ma, e sɛnbɛ nu luma xun masa ra. ");
INSERT INTO sus_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na waxati mangɛ gbɛtɛ nan nu na Misira xun ma, naxan mu Yusufu kolon. ");
INSERT INTO sus_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","A naxa a fala a xa ɲama bɛ, «Wo a to, Isirayilakae yiriwaxi ki naxɛ, a bara findi kɔntɔfili ra won bɛ. E bara dangi won na. ");
INSERT INTO sus_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Won xa kɔɔta nde raba alako e naxa wuya sɔnɔn. Xa na mu, gere tɛmui, e fama nɛ kafude won yaxuie ma, e keli won xun ma.» ");
INSERT INTO sus_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Na kui, mangɛ naxa e findi konyie ra, a wali xɔrɔxɔɛ dɔxɔ e ma Pitomi nun Ramesesi taae tife ra. Misira mangɛ Firawuna nu donse malanma na taae nan kui. ");
INSERT INTO sus_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kɔnɔ wali xɔrɔxɔɛ nu dɔxɔma e ma ki naxɛ, e man nu sigama gbo ra na ki nɛ, han Misirakae bɔɲɛ naxa raɲaaxu e ma Isirayilakae xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Misirakae naxa e rawali a ɲaaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","E naxa e tɔɔrɔ wali xɔrɔxɔɛ ra alɔ biriki bɔnbɔfe nun xɛe rawalife. E naxa konyiya ɲaaxi dɔxɔ e ma. ");
INSERT INTO sus_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misira mangɛ naxa Isirayilakae xa dirasuxuie Sifira nun Puwa yamari, ");
INSERT INTO sus_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Wo na Isirayila ginɛ xa di rasuxu, xa xɛmɛ nan a ra, wo a faxa keren na. Xa ginɛ nan a ra, wo xa a lu a xa balo.» ");
INSERT INTO sus_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kɔnɔ dirasuxuie to nu gaaxuma Ala ya ra, e mu nu Misira mangɛ xa yaamari rabatuma. E naxa di xɛmɛmae lu e xa balo. ");
INSERT INTO sus_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mangɛ naxa dirasuxuie xili, a naxa e maxɔrin, «Munfe ra wo di xɛmɛe luma, e xa balo?» ");
INSERT INTO sus_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Dirasuxuie naxa Firawuna yaabi, «Isirayila ginɛe sɛnbɛ gbo Misira ginɛe bɛ. Beenu dirasuxui xa e yire li, e ɲan bara di bari.» ");
INSERT INTO sus_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ala naxa hinnɛ na dirasuxuie ra. Isirayila ɲama naxa wuya dangife a singe ra. ");
INSERT INTO sus_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Dirasuxuie to gaaxu Ala ya ra, Ala naxa die fi e fan ma. ");
INSERT INTO sus_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Na tɛmui, Firawuna naxa a xa ɲama birin yamari, «Wo Isirayilakae xa diyɔrɛ xɛmɛe woli Nili xure ma, kɔnɔ wo e xa di ginɛe tan lu, e xa balo.» ");
INSERT INTO sus_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Xɛmɛ nun ginɛ nde naxa e boore futi, e birin fatan Lewi bɔnsɔɛ nan na Isirayilakae ya ma. ");
INSERT INTO sus_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na ginɛ naxa tɛɛgɛ, a di xɛmɛ bari. A to a to di fanyi nan nu a ra, a naxa a nɔxun kike saxan. ");
INSERT INTO sus_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A to mu nu nɔma a nɔxunde sɔnɔn, a naxa kɔlimɛ debe maso dole ra, a diyɔrɛ sa a kui, a fa debe dɔxɔ Nili xure ma yoforoe tagi. ");
INSERT INTO sus_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Na diyɔrɛ taara ginɛma nu tixi yire nde, a ya tixi a xunya ra, alako a xa a kolon fe naxan fama na lide. ");
INSERT INTO sus_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Firawuna xa di ginɛ naxa goro Nili xure ma a maxade. A to debe to yoforoe tagi, a naxa a xa konyi ginɛ nde xɛɛ a tongode. ");
INSERT INTO sus_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A to a rabi, a naxa di xɛmɛ to a kui, a wafe. A naxa kinikini a ma, a fa a fala, «Isirayilaka nde xa di na a ra!» ");
INSERT INTO sus_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na tɛmui, diyɔrɛ taara naxa Firawuna xa di ginɛ maxɔrin, «N xa siga Isirayila dingɛ nde xili i bɛ, a xa fa xiɲɛ fi a ma?» ");
INSERT INTO sus_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Firawuna xa di ginɛ naxa a yaabi, «Iyo.» Diyɔrɛ taara naxa siga, a sa diyɔrɛ nga xili. ");
INSERT INTO sus_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Firawuna xa di ginɛ naxa a fala diyɔrɛ nga bɛ, «Yi diyɔrɛ xanin, i xa xiɲɛ fi a ma n bɛ. N i sare fima nɛ.» Diyɔrɛ nga naxa diyɔrɛ tongo, a xiɲɛ fi a ma. ");
INSERT INTO sus_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Diyɔrɛ to mɔ, a nga naxa a xanin Firawuna xa di ginɛ xɔn ma, a findi na xa di ra. A to a raminixi ye nan xɔɔra, a naxa a xili sa Munsa, naxan falaxi «minife» Eburu xui ra. ");
INSERT INTO sus_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Munsa to fonikeya rakamali, a naxa siga a ngaxakerenyie yire, a xa e xun mato a ra e xa wali xɔrɔxɔɛ kui. A to a ngaxakerenyie yire li, a naxa Misiraka nde to Isirayilaka nde bɔnbɔ ra. ");
INSERT INTO sus_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","A to mu mixi yo to na longori, a naxa na Misiraka faxa, a fa a fure nɔxun mɛyɛnyi kui. ");
INSERT INTO sus_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Na kuye iba, Munsa man naxa mini, a Isirayilaka firin to sɔnxɔ ra. A naxa mixi maxɔrin nɔndi mu na naxan bɛ, «I bariboore bɔnbɔfe munfe ra?» ");
INSERT INTO sus_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A naxa a yaabi, «Nde i findixi mangɛ nun kiitisa ra muxu xun ma? I wama n fan faxafe nɛ, alɔ i na Misiraka faxa ki naxɛ?» Munsa naxa gaaxu. A naxa a fala a bɔɲɛ ma, «N naxan nabaxi a bara kolon.» ");
INSERT INTO sus_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Firawuna to a kolon Munsa naxan nabaxi, a naxa kata Munsa faxade. Kɔnɔ Munsa naxa a gi Firawuna ma, a sa sabati Madiyan bɔxi ma. Munsa to siga naa, a naxa kɔlɔnyi nde li, a fa dɔxɔ a xa a malabu. ");
INSERT INTO sus_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madiyan sɛrɛxɛdubɛ xa di ginɛ solofere naxa fa ye bade na kɔlɔnyi yire e baba xa xurusee bɛ. ");
INSERT INTO sus_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kɔnɔ xuruse dɛmadonyi ndee fan naxa fa, e naxa wa na ginɛe kerife. Munsa to na to, a naxa keli, a na ginɛe xun magere so, a fa ye fi e xa xurusee ma. ");
INSERT INTO sus_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Na ginɛe to gbilen e baba Reyuweli yire, a naxa e maxɔrin, «Munse a niyaxi wo gbilenxi sinnanyi ma to?» ");
INSERT INTO sus_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","E naxa a yaabi, «Misiraka nde bara muxu ratanga xuruse dɛmadonyi kobie ma, a man fa ye ba won ma xurusee bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reyuweli naxa a xa di ginɛe maxɔrin, «A na minden? Wo a luxi naa munfe ra? Wo sa a xili, wo donse so a yi ra.» ");
INSERT INTO sus_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Munsa naxa tin sabatide Reyuweli xɔnyi. Reyuweli naxa a xa di ginɛ Sipora fi Munsa ma, a xa a dɔxɔ. ");
INSERT INTO sus_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipora naxa di xɛmɛ bari a bɛ. Xɔɲɛ nan to lanxi Munsa ma na bɔxi ma, a naxa a xa di xili sa Gerisomi, naxan wama a falafe, «Xɔɲɛ nan n na yi bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ɲɛ wuyaxi dangi xanbi, Misira mangɛ naxa faxa. Isirayilakae nu e mawafe Ala bɛ e xa konyiya xɔrɔxɔɛ xa fe ra. Na maxandi naxa Ala li. ");
INSERT INTO sus_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ala naxa e wa xui mɛ. A naxa ratu a xa saatɛ ma naxan xirixi a tan nun Iburahima, Isiyaga, nun Yaxuba tagi. ");
INSERT INTO sus_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Na kui Ala naxa a ya rafindi Isirayilakae ma, a xa a ɲɛngi sa e xɔn ma. ");
INSERT INTO sus_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Munsa bitanyi Yetiro nan nu na Madiyan sɛrɛxɛdubɛ ra. Munsa naxa Yetiro xa xurusee xanin wula i yire makuye, han a sa Ala xa geya Xorebe li. ");
INSERT INTO sus_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mɛnni Alatala xa malekɛ naxa mini a ma wuri bili lanmadi ma, naxan radɛxɛxi. Munsa naxa a mato, tɛ nu na na wuri bili ma, kɔnɔ wuri bili mu ganxi. ");
INSERT INTO sus_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Munsa naxa a fala a yɛtɛ ma, «N xa n makɔrɛ yi kaabanako ra, n xa a kolon munfe ra wuri bili lanma mu ganxi.» ");
INSERT INTO sus_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Alatala to Munsa to a makɔrɔxi wuri bili ra alako a xa a igbɛ, a naxa a xili kelife na wuri bili ma, «Munsa, Munsa!» Munsa naxa a ratin, «N tan nan ya.» ");
INSERT INTO sus_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ala naxa a masen a bɛ, «I naxa i makɔrɛ be ra. Sankirie ba, barima i tixi yire sɛniyɛnxi nan ma.» ");
INSERT INTO sus_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A man naxa a masen, «I baba Marigi Ala na n tan na, Iburahima, Isiyaga, nun Yaxuba Marigi Ala.» Munsa to na mɛ, a naxa a yatagi makoto, barima a nu gaaxuxi Ala matofe ra. ");
INSERT INTO sus_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Alatala man naxa yi masenyi ti Munsa bɛ, «N bara n ma ɲama xa tɔɔrɛ to Misira bɔxi ma. N bara e wa xui mɛ e xa konyiya kui. N ɲɛngi saxi e xa tɔɔrɛ xɔn ma. ");
INSERT INTO sus_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","N goroxi na nan ma, n xa fa e bade Misirakae yi ra, n xa e raso bɔxi fanyi ma, lude gbegbe na dɛnnaxɛ. Xiɲɛ nun kumi gbo naa, Kanaankae, Xitikae, Amorikae, Perisikae, Hiwikae nun Yebusukae xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yakɔsi Isirayilakae wa xui bara n li. N man bara ɲaxankatɛ to Misirakae naxan dɔxɔfe e ma. ");
INSERT INTO sus_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Siga, n bara i xɛɛ Firawuna xɔn, i xa n ma ɲama Isirayila ramini Misira.» ");
INSERT INTO sus_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Munsa naxa a fala Ala bɛ, «Mixi mɔɔli mundun na n tan na, n xa siga Firawuna ma Isirayilakae raminife ra Misira?» ");
INSERT INTO sus_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ala naxa a yaabi, «Won birin na a ra. I na gɛ ɲama raminide Misira bɔxi ma, wo fama n batude yi geya nan fari. Na findima tɔnxuma ra, fa a fala, n tan yati nan i xɛɛxi.» ");
INSERT INTO sus_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Munsa naxa a fala Ala bɛ, «N na sa a fala Isirayilakae bɛ, ‹Wo benbae Marigi Ala nan n xɛɛxi wo ma,› e fa sa n maxɔrin i xili ma, n yaabi mundun fima e ma?» ");
INSERT INTO sus_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ala naxa a masen Munsa bɛ, «N na ‹naxan na› na. I xa Isirayilakae yaabi, ‹Ala naxan na, a bara n xɛɛ wo ma.›» ");
INSERT INTO sus_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ala man naxa a masen Munsa bɛ, «I fama wɔyɛnde yi ki nɛ Isirayilakae bɛ, ‹Wo benba Iburahima, Isiyaga, nun Yaxuba Marigi Alatala, Ala naxan na, na nan n xɛɛxi wo ma.› N xili nan na ki abadan, n wama mixi birin xa n xili na ki nɛ tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Sa Isirayila kuntigie malan, i a fala e bɛ, ‹Wo benba Iburahima, Isiyaga, nun Yaxuba Marigi Alatala bara mini n ma. A bara a masen n bɛ, «N bara fe to e naxan dɔxɔfe wo ma Misira. ");
INSERT INTO sus_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","N bara natɛ tongo wo raminife ra Misira wo xa tɔɔrɛ kui. N xa wo xanin Kanaankae, Xitikae, Amorikae, Perisikae, Hiwikae, nun Yebusukae xɔnyi, xiɲɛ nun kumi xɛlɛma dɛnnaxɛ.»›» ");
INSERT INTO sus_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Isirayila kuntigie na gɛ i xui ramɛde, wo sigama nɛ Misira mangɛ yire a falafe ra, ‹Isirayilakae Marigi Alatala bara fa muxu fɔxɔ ra. I xa muxu sago sa muxu xa fɛɛɲɛn saxan ɲɛrɛ raba gbengberenyi ma, alako muxu xa sɛrɛxɛe ba muxu Marigi Alatala bɛ.› ");
INSERT INTO sus_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","N a kolon Misira mangɛ mu tinma wo lude wo xa siga, xa n mu n sɛnbɛ masen a bɛ. ");
INSERT INTO sus_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Na kui n fe magaaxuxie rabama nɛ Misirakae ra, n e tɔɔrɔ kaabanakoe ra. Na dangi xanbi, e xa mangɛ tinma nɛ wo xa siga. ");
INSERT INTO sus_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","N man a ragirima nɛ Misirakae xa wo ki, alako wo naxa siga wo bɛlɛxɛ igeli ra. ");
INSERT INTO sus_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isirayila ginɛ birin xa e dɔxɔboore Misirakae makula yirabase gbeti nun xɛɛma daaxie ra, a nun sosee, wo naxee soma wo xa die ma. Na kui wo harige bama nɛ Misirakae yi ra.» ");
INSERT INTO sus_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Munsa naxa Alatala maxɔrin, «Xa Isirayilakae mu sa la n ma masenyi ra, e fa a fala, ‹Alatala mu minixi i ma feo,› n munse rabama fa?» ");
INSERT INTO sus_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Alatala naxa a maxɔrin, «Munse na i bɛlɛxɛ na ki?» A naxa a yaabi, «N ma yisuxuwuri.» ");
INSERT INTO sus_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Alatala naxa a yamari, «A woli bɔxi.» A to a woli bɔxi, na naxa mafindi bɔximase ra, Munsa fa a gi a ya ra. ");
INSERT INTO sus_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Alatala naxa a masen a bɛ, «I bɛlɛxɛ itala i xa a suxu a xuli ma.» Munsa naxa a bɛlɛxɛ itala. A to a suxu a bɛlɛxɛ ra, na naxa findi yisuxuwuri ra. ");
INSERT INTO sus_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Alatala naxa a masen a bɛ, «Na findima tɔnxuma ra e bɛ, fa a fala, e benba Iburahima, Isiyaga, nun Yaxuba Marigi Alatala bara mini i ma.» ");
INSERT INTO sus_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Na dangi xanbi, Alatala man naxa a masen a bɛ, «I bɛlɛxɛ sa i kanke ma i xa donma bun ma.» A to na raba, a fa a ramini, kunɛ a bɛlɛxɛ rafiixɛxi. ");
INSERT INTO sus_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","A man naxa a yamari, «I man xa i bɛlɛxɛ sa i kanke ma i xa donma bun ma.» A to na raba, a bɛlɛxɛ naxa yalan keren na. ");
INSERT INTO sus_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Alatala naxa a masen a bɛ, «Xa Isirayilakae mu la i xui ra, xa na mu a ra na tɔnxuma singe ra, tɛmunde e fama nɛ lade i ra na tɔnxuma firin nde xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Xa e mu la i xui ra na tɔnxuma firinyie xa fe ra, i xa ye tongo Nili xure, i a rafili bɔxi ma. A findima nɛ wuli ra keren na.» ");
INSERT INTO sus_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Munsa naxa Alatala yaabi, «N Marigi, i a kolon i xa konyi mu fata wɔyɛnde. N nɛnyi binya n dɛ i kabi n dimɛdi tɛmui. To masenyi mu na fe masaraxi.» ");
INSERT INTO sus_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Alatala naxa a masen a bɛ, «Nde mixi nɛnyi rakelima? Nde mixi findima boboe ra, xa na mu tulixɔri? Nde mixi findima ya kanyi ra, xa na mu dɔnxui? N tan Alatala xa mu a ra? ");
INSERT INTO sus_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Siga. N i malima masenyi tide. N masenyi yati rasoma nɛ i dɛ i, i naxan tima.» ");
INSERT INTO sus_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Munsa naxa a yaabi, «N Marigi, yandi, mixi gbɛtɛ xɛɛ.» ");
INSERT INTO sus_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Na kui Alatala naxa xɔnɔ Munsa ma. A naxa a masen a bɛ, «I taara Haruna go? Lewi bɔnsɔɛ mu a ra? N a kolon, na tan fata wɔyɛnde. A ɲan na fafe i ralande. A sɛɛwama nɛ i tofe ra. ");
INSERT INTO sus_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I masenyie tima nɛ a bɛ, a naxan falama ɲama bɛ. N wo firin malima na kui. N a masenma wo bɛ wo lan wo xa naxan fala. ");
INSERT INTO sus_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haruna i xui madangima ɲama bɛ, alɔ namiɲɔnmɛ Ala xui madangima ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","I xa i xa yisuxuwuri tongo. I kaabanako birin nabama a tan na.» ");
INSERT INTO sus_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Na tɛmui Munsa naxa gbilen a bitanyi xɔnyi, a a fala a bɛ, «N wama sigafe ngaxakerenyie yire Misira bɔxi ma, n xa a kolon e xa fe na ki naxɛ.» Yetiro naxa a yaabi, «Siga bɔɲɛsa kui.» ");
INSERT INTO sus_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Alatala nu bara a masen Munsa bɛ Madiyan bɔxi ma, «I xa gbilen Misira. Naxee nu wama i faxafe, nee birin bara faxa.» ");
INSERT INTO sus_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Na kui Munsa naxa a xa ginɛ nun a xa die baki sofalee fari, e gbilen Misira. Munsa naxa a xa yisuxuwuri fan xanin, Ala naxan ma fe fala a bɛ. ");
INSERT INTO sus_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Alatala naxa yi masenyi ti Munsa bɛ, «I na gbilen Misira, i xa kaabanako birin naba Firawuna ya i, n naxee saxi i sagoe. Na tɛmui n tan nan a xaxili raxɔrɔxɔma, alako a naxa tin n ma ɲama bɛɲinde. ");
INSERT INTO sus_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I xa a fala Firawuna bɛ, ‹Alatala xui nan ya, Isirayila, n ma di singe nan a ra. ");
INSERT INTO sus_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","N bara i yamari i xa a bɛɲin alako a xa siga n batude. I to bara tondi na ra, n i xa di singe faxama nɛ.›» ");
INSERT INTO sus_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Munsa to nu na biyaasi kui sigafe ra Misira, Alatala naxa mini a ma kɔɛ ra, a xa a faxa, ");
INSERT INTO sus_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","kɔnɔ Munsa xa ginɛ Sipora naxa a xa di xɛmɛ sunna gɛmɛ xɛɲɛnxi ra, a na soli sa a sanyi ma. A naxa a fala, «N ma mɔri nan i ra, muxu nun naxan wuli keren.» ");
INSERT INTO sus_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Na kui Alatala naxa Munsa lu na. Sipora xa masenyi, «N ma mɔri nan i ra, muxu nun naxan wuli keren,» a nu wama sunnɛ wuli nan xa fe falafe. ");
INSERT INTO sus_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Alatala naxa a masen Haruna bɛ, «I xa siga Munsa ralande gbengberenyi ma.» A to naralan Munsa ra Ala xa geya ma, a naxa a sunbu. ");
INSERT INTO sus_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Munsa naxa Alatala xa xɛɛraya birin ya ba a bɛ. A naxa na kaabanako fee fan fala a bɛ, Ala naxan fixi a ma a rabafe ra. ");
INSERT INTO sus_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Munsa nun Haruna to Isirayilakae li, e naxa Isirayila fori birin malan. ");
INSERT INTO sus_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haruna naxa dɛntɛgɛ sa e bɛ Alatala naxan masenxi Munsa bɛ. A naxa kaabanakoe fan naba ɲama ya xɔri. ");
INSERT INTO sus_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ɲama naxa la na birin na. E to a kolon a Alatala ɲɛngi saxi Isirayilakae xɔn ma e xa tɔɔrɛ kui, e naxa e igoro bɔxi, e suyidi Ala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na dangi xanbi, Munsa nun Haruna naxa siga Firawuna yire. E naxa a fala a bɛ, «Isirayila Marigi Alatala xa masenyi nan ya, ‹N ma ɲama bɛɲin, alako e xa siga n ma sali rabade gbengberenyi ma.›» ");
INSERT INTO sus_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawuna naxa yi maxɔrinyi ti, «Nde tan na na Alatala ra, n lan n xa naxan xa yaamari rabatu Isirayila bɛɲinfe ra? N mu Alatala kolon! Na kui, n mu nɔma a lude Isirayila xa siga fefe ma!» ");
INSERT INTO sus_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","E naxa a fala a bɛ, «Isirayila Marigi Ala bara fa muxu fɔxɔ ra. A lu muxu xa biyaasi xi saxan gbengberenyi yire, alako muxu xa sɛrɛxɛe ba muxu Marigi Alatala bɛ, xa muxu mu na raba muxu sɔntɔma nɛ wuganyi ra, xa na mu santidɛgɛma ra.» ");
INSERT INTO sus_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misira mangɛ naxa e yaabi, «Munsa nun Haruna, munfe ra wo wama ɲama bafe wali dɛ i? Wo siga wo xa wali ra. ");
INSERT INTO sus_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Yi ɲama to bara gbo yɛ yi bɔxi ma, wo wama e xa wali nan xun nakanafe fa.» ");
INSERT INTO sus_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Na lɔxɔɛ Firawuna naxa konyie xa mangɛe nun wali xunyie yamari, ");
INSERT INTO sus_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Wo naxa sɛxɛ so Isirayila ɲama yi ra sɔnɔn, e naxan malanma boora ra e biriki bɔnbɔma tɛmui naxɛ. Yakɔsi e xa na sɛxɛ fen e yɛtɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","E dari biriki xasabi naxan bɔnbɔ ra, wo naxa sese ba na ra. Fuyante nan e ra. Na nan a ra, e a falama, ‹Muxu xa siga sɛrɛxɛ bade muxu Marigi Ala bɛ.› ");
INSERT INTO sus_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wo xa nde sa e xa wali xun ma, alako e naxa yanfa wali ma madaxui wɔyɛnyi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Konyi xa mangɛe nun wali xunyie naxa a fala Isirayila ɲama bɛ, «Firawuna naxɛ a a mu sɛxɛ soma wo yi ra sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Wo xa siga na fende wo yɛtɛ ra. Wo xa a kolon sese mu bama wo xa wali kote ra.» ");
INSERT INTO sus_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Na kui ɲama naxa yensen Misira bɔxi sɛxɛ xabade. ");
INSERT INTO sus_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mangɛe nu e ragbatama nɛ, e nu fa a fala, «Wo xa wo xa wali raɲɔn lɔxɔ yo lɔxɔ alɔ a singe, sɛxɛ nu soma wo yi ra tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Firawuna xa mixie nu fa Isirayilakae bɔnbɔ naxee nu tixi wali xunyie ra. E nu fa e maxɔrin, «Munfe ra xoro nun to, wo mu biriki xasabi bɔnbɔxi alɔ wo darixi a ra ki naxɛ?» ");
INSERT INTO sus_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Isirayila wali xunyie naxa siga e mawade Firawuna xɔn a falafe ra, «I na yi mɔɔli rabafe muxu tan i xa konyie ra munfe ra? ");
INSERT INTO sus_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","E mu sɛxɛ yo soma muxu yi ra, kɔnɔ e a falama a muxu xa biriki bɔnbɔ! I xa mixie na muxu tan i xa konyi bɔnbɔfe, kɔnɔ e tan nan wali kanaxi.» ");
INSERT INTO sus_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Firawuna naxa e yaabi, «Fuyantee nan wo ra. Na nan a toxi wo a falama, a wo xa siga sɛrɛxɛ bade Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Wo siga walide! Sɛxɛ yo mu soma wo yi ra, sese man mu bama wo xa biriki kɔnti ra.» ");
INSERT INTO sus_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isirayila wali xunyie naxa kɔntɔfili na wɔyɛnyi ra, a falafe ra, «Sese mu bama birikie kɔnti ra wo naxan bɔnbɔma lɔxɔ yo lɔxɔ.» ");
INSERT INTO sus_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","E to mini Firawuna xɔnyi, e naxa Munsa nun Haruna li naa. E nu na e mɛmɛfe. ");
INSERT INTO sus_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Na wali xunyie naxa a fala e bɛ, «Alatala xa wo ɲaxankata, barima wo bara muxu maɲaaxu Firawuna nun a xa mixie xɔn ma. Wo bara santidɛgɛma sa e bɛlɛxɛ, e xa muxu faxa.» ");
INSERT INTO sus_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Munsa naxa gbilen Alatala ma a falafe ra, «Marigi, i bara yi tɔɔrɛ dɔxɔ yi ɲama ma munfe ra? I n xɛɛxi be munfe ma? ");
INSERT INTO sus_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kabi n naxa siga Firawuna yire wɔyɛnfe ra i xili ra, a fa fe ɲaaxi nan tun nabafe yi ɲama ra. I mu i xa ɲama xɔrɛyaxi feo.» ");
INSERT INTO sus_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Alatala naxa a masen Munsa bɛ, «I fama a tode yakɔsi, n naxan nabama Firawuna ra. N sɛnbɛ nan fama a niyade a xa Isirayila ɲama bɛɲin, a yɛtɛ xa e keri a xa bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ala man naxa a masen Munsa bɛ, «N tan nan Alatala ra. ");
INSERT INTO sus_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","N naxa n yɛtɛ masen Iburahima, Isiyaga, nun Yaxuba bɛ. Kɔnɔ e mu n n xili kolonxi Alatala ra. E n kolonxi Ala Sɛnbɛma xili nan na. ");
INSERT INTO sus_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Muxu man naxa saata, n xa Kanaan bɔxi fi e ma, e xɔɲɛya rabaxi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","N bara Isirayilakae wa xui mɛ e xa konyiya kui Misirakae yi ra. N man bara ratu n ma saatɛ ma. ");
INSERT INTO sus_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Na kui, a fala Isirayilakae bɛ, ‹N tan nan Alatala ra. N fama nɛ wo raminide Misirakae xa nɔɛ bun ma. N xɔrɛya fima nɛ wo ma. N fama nɛ wo xun sarade n sɛnbɛ ra. N ɲaxankatɛ ragoroma nɛ Misirakae ma e xa wali kobie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","N wo findima nɛ n ma ɲama ra. N fan findima nɛ wo Marigi ra. Na tɛmui wo a kolonma nɛ, n tan nan na wo Marigi Alatala ra, naxan wo baxi konyiya kui Misirakae yi ra. ");
INSERT INTO sus_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","N fama nɛ wo rasode bɔxi ma, n nakalixi naxan ma fe ra, n xa a fi Iburahima, Isiyaga, nun Yaxuba ma. N fama nɛ a fide wo ma, a lu wo sagoe.›» ");
INSERT INTO sus_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Munsa naxa na dɛntɛgɛ Isirayilakae bɛ, kɔnɔ e mu la a xui ra e xa konyiya xɔrɔxɔɛ xa fe ra. Limaniya birin nu bara ba e yi. ");
INSERT INTO sus_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Siga Misira mangɛ yire. A fala Firawuna bɛ a xa Isirayila ɲama bɛɲin, e xa mini a xa bɔxi ra.» ");
INSERT INTO sus_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kɔnɔ Munsa naxa Alatala yaabi, «Xa Isirayilakae yati mu laxi n xui ra, Firawuna fan mu n xui suxuma feo, n tan naxan ɲan mu fata wɔyɛnde.» ");
INSERT INTO sus_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Alatala masenyi ti Munsa nun Haruna bɛ na ki nɛ, Isirayilakae nun Misira mangɛ Firawuna xa fe ra. A e yamari nɛ e xa Isirayilakae ramini Misira bɔxi ra. ");
INSERT INTO sus_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isirayila bɔnsɔɛ yareratie nan yi ki: Ruben naxan singe bari Isirayila, a xa die nan ya: Xanɔki, Palu, Xesiron, nun Karimi. Ruben bɔnsɔɛ nan na ki. ");
INSERT INTO sus_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeyɔn xa die nan ya: Yemuweli, Yamin, Ohadi, Yakin, Soxara, nun ginɛ Kanaanka xa di Sawulu. Simeyɔn bɔnsɔɛ nan na ki. ");
INSERT INTO sus_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewi xa die xilie nan yi ki e xa taruxui ki ma: Gerison, Kehati, nun Merari. Lewi xa simaya naxa ɲɛ kɛmɛ ɲɛ tongo saxan a nun solofere li. ");
INSERT INTO sus_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerison xa die findixi Libini nun Simeyi nan na e xabilɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehati xa die findixi Amarama, Yisehari, Xebiron, nun Yusiyɛli nan na e xabilɛ ki ma. Kehati xa simaya naxa ɲɛ kɛmɛ ɲɛ tongo saxan a nun saxan li. ");
INSERT INTO sus_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari xa die findixi Maxali nun Musi nan na. Lewi xa die nan na ki e taruxui ki ma. ");
INSERT INTO sus_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amarama naxa a baba barenyi Yebedi dɔxɔ, naxan Haruna nun Munsa bari a bɛ. Amarama xa simaya naxa ɲɛ kɛmɛ ɲɛ tongo saxan a nun solofere li. ");
INSERT INTO sus_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yisehari xa die nan ya: Kora, Nefegi, nun Sikiri. ");
INSERT INTO sus_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Yusiyɛli xa die nan ya: Misayeli, Elesafana, nun Sitiri. ");
INSERT INTO sus_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna naxa Aminadabo xa di Eliseeba dɔxɔ, naxan findixi Naxason maaginɛ ra. A naxa Nadabo, Abihu, Eleyasari, nun Itamari bari Haruna bɛ. ");
INSERT INTO sus_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora xa die nan ya: Asiri, Elekana, nun Abiyasafi a xabilɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Haruna xa di Eleyasari naxa Putiyeli xa di ginɛ dɔxɔ. A naxa Finexasi bari a bɛ. Lewi bɔnsɔɛ yareratie nan na ki e xabilɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Alatala Haruna nun Munsa yamari nɛ, «Wo Isirayilakae ramini Misira bɔxi ra e lanxundɛ ki ma.» ");
INSERT INTO sus_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Munsa nun Haruna nan wɔyɛn Misira mangɛ Firawuna bɛ Isirayilakae raminife ra Misira kui. ");
INSERT INTO sus_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Alatala naxa yi masenyi ti Munsa bɛ Misira bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«N tan nan na Alatala ra. Siga, n xui birin nadangi Misira mangɛ Firawuna ma.» ");
INSERT INTO sus_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Munsa naxa Alatala yaabi, «N tan nan yi ki, n mu fata wɔyɛnde a fanyi ra. Firawuna nɔma tinde n ma masenyi ra di?» ");
INSERT INTO sus_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Alatala naxa a masen Munsa bɛ, «Haruna xa i xui madangi Firawuna bɛ alɔ namiɲɔnmɛ Ala xui madangima mixie bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","N i yamarima naxan birin na, i xa na fala i taara Haruna bɛ naxan na madangima Firawuna ma, alako a xa a lu Isirayilakae xa mini Misira bɔxi ra. ");
INSERT INTO sus_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","N Firawuna xaxili raxɔrɔxɔma nɛ. N tɔnxuma nun kaabanako gbegbe rabama nɛ Misira bɔxi kui, ");
INSERT INTO sus_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","kɔnɔ Firawuna mu fama a tuli matide wo ra. N fama nɛ ɲaxankatɛ xɔrɔxɔɛe dɔxɔde Misira ma, n fa n ma ɲama Isirayila ramini a lanxundɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","N na Misira halaki Isirayila raminife ra e tagi, e n kolonma nɛ Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Munsa nun Haruna naxa Alatala xa yaamari suxu alɔ a masenxi e bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","E nu masenyi tima Firawuna bɛ tɛmui naxɛ, Munsa xa simaya nu bara ɲɛ tongo solomasaxan li. Haruna xa simaya nu bara ɲɛ tongo solomasaxan a nun saxan li. ");
INSERT INTO sus_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Firawuna na a fala wo bɛ, ‹Wo xa kaabanako nde raba,› i tan Munsa, i xa a fala Haruna bɛ, a xa i xa yisuxuwuri tongo, a a woli Firawuna sɛɛti ma. Na mafindima nɛ bɔximase ra.» ");
INSERT INTO sus_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Na kui Munsa nun Haruna naxa siga Firawuna yire, e fa a raba, alɔ Alatala e yamarixi ki naxɛ. Haruna naxa Munsa xa yisuxuwuri woli bɔxi ma Firawuna nun a xa kuntigie ya i, na naxa findi bɔximase ra. ");
INSERT INTO sus_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Na tɛmui Firawuna naxa a xa karamɔxɔɛe nun a xa mandurulae xili, e xa na kaabanako mɔɔli raba e xa duureya ra. ");
INSERT INTO sus_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","E nun Haruna birin naxa e xa yisuxuwurie woli bɔxi ma. Nee birin naxa mafindi bɔximasee ra, kɔnɔ Haruna gbe naxa boore gbe gerun. ");
INSERT INTO sus_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Na kui Firawuna xaxili naxa xɔrɔxɔ, a mu a tuli mati Munsa nun Haruna ra, alɔ Alatala nu bara a masen ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Alatala naxa a masen Munsa bɛ, «Firawuna xaxili bara xɔrɔxɔ. A bara tondi n ma ɲama bɛɲinde. ");
INSERT INTO sus_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tina gɛɛsɛgɛ i xa naralan Firawuna ra Nili xure dɛ. I xa i xa yisuxuwuri xanin, naxan nu bara mafindi bɔximase ra. ");
INSERT INTO sus_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mɛnni i xa a fala Firawuna bɛ, ‹Isirayilakae Marigi Alatala bara n xɛɛ i yire, n xa a fala i bɛ, «N ma ɲama bɛɲin, alako e xa siga n batude gbengberenyi ma.» Han yakɔsi i tan mu tinxi na xui suxude. ");
INSERT INTO sus_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Na kui Alatala xa masenyi nan ya, «Na nan a ra, i fama a kolonde, n tan nan Alatala ra. N ma yisuxuwuri na din Nili xure ra, ye mafindima nɛ wuli ra. ");
INSERT INTO sus_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Yɛxɛ naxee na Nili xure ma, e fama sɔntɔde, e xiri ɲaaxi fa mini, Misirakae mu nɔma na ye minde.»›» ");
INSERT INTO sus_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Alatala naxa a masen Munsa bɛ, «Haruna yamari, ‹I xa i xa yisuxuwuri itala Misira baae, xuree, nun dabonyi birin ma.› Na a niyama nɛ ye birin xa mafindi wuli ra Misira bɔxi ma, hali naxee na fɛɲɛe kui, wuri nun gɛmɛ daaxi.» ");
INSERT INTO sus_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Munsa nun Haruna naxa a raba alɔ Alatala e yamarixi ki naxɛ. Haruna naxa a xa yisuxuwuri itala, a a din Nili xure ra. Xure naxa findi wuli ra Firawuna nun a xa kuntigie ya xɔri. ");
INSERT INTO sus_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Yɛxɛ birin naxa faxa, e xiri ɲaaxi naxa mini Nili xure ma. Misirakae mu nu nɔma na ye minde, barima Misira ye birin findixi wuli nan na. ");
INSERT INTO sus_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mandurulae fan naxa na kaabanako mɔɔli raba. Firawuna xaxili naxa xɔrɔxɔ, a mu tin Munsa nun Haruna xui ra, alɔ Alatala nu bara a masen ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firawuna naxa gbilen a xɔnyi, a naxa na fe bɔtɛ ba. ");
INSERT INTO sus_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misiraka birin naxa tigie ge Nili xure sɛɛtie ma, alako e xa ye min daaxi sɔtɔ, barima e mu nu nɔma Nili xure ye minde. ");
INSERT INTO sus_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Alatala to gɛ Nili xure garinde, xi solofere dangi xanbi, ");
INSERT INTO sus_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","a naxa a masen Munsa bɛ, «I xa siga Firawuna yire, a fala a bɛ, ‹Alatala bara a yamari, i xa a xa ɲama bɛɲin, e xa siga a batude. ");
INSERT INTO sus_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Xa i mu tin na ra, Alatala fama i xa bɔxi birin xun nakanade lanxansarimae ra. ");
INSERT INTO sus_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","E fama yiriwade Nili xure ma, e fa te, e so i xa banxi kui han e i xa sade li. E soma i xa kuntigie nun Misira ɲama xa banxie kui, e man soma taami rafalama dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Lanxansarimae fama nɛ tede i tan, i xa ɲama, nun i xa kuntigie birin ma.›» ");
INSERT INTO sus_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na tɛmui Alatala naxa a masen Munsa bɛ, «A fala Haruna bɛ, a xa a xa yisuxuwuri itala baae, xuree, nun dabonyi birin xun ma alako lanxansarimae xa te Nili xure ma, e so Misira bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Haruna to a xa yisuxuwuri itala Misira yee xun ma, lanxansarimae naxa te Misira bɔxi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mandurulae fan naxa na kaabanako mɔɔli raba, e fan naxa lanxansarimae raso Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Na dangi xanbi Firawuna naxa Munsa nun Haruna xili, a a fala e bɛ, «Wo sa Alatala maxandi, alako lanxansarimae xa keli n tan nun n ma ɲama xun ma. N fama i xa ɲama rabɛɲinde, e xa siga sɛrɛxɛe bade Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Munsa naxa a fala Firawuna bɛ, «Mangɛ, i gbe binyɛ. I xa natɛ tongo lɔxɔɛ safe ra lanxansarimae xa keli i tan, i xa kuntigie, nun i xa ɲama xun ma, e xa lu Nili xure gbansan ma.» ");
INSERT INTO sus_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A naxa a yaabi, «Tina.» Munsa naxa a fala, «A fama rabade na ki nɛ, alako i xa a kolon, muxu Marigi Alatala maniyɛ mu na. ");
INSERT INTO sus_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lanxansarimae fama kelide i tan, i xa kuntigie, nun i xa ɲama xun ma, e fa lu Nili xure ma.» ");
INSERT INTO sus_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Munsa nun Haruna to mini Firawuna xɔnyi, Munsa naxa Alatala maxandi lanxansarimae xa fe ra naxee nu Firawuna tɔɔrɔma. ");
INSERT INTO sus_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Alatala naxa Munsa xa maxandi suxu. Lanxansarimae naxa faxa banxie, xandɛe, nun daaxae kui. ");
INSERT INTO sus_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mixie naxa e koto, e xiri ɲaaxi fa din bɔxi birin na. ");
INSERT INTO sus_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kɔnɔ Firawuna to a to na fe nu bara dangi, a man naxa a xaxili raxɔrɔxɔ, a mu tin Munsa nun Haruna xui ra, alɔ Alatala a masen ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Na tɛmui Alatala naxa a masen Munsa bɛ, «A fala Haruna bɛ a xa a xa yisuxuwuri itala, a xa din bɔxi xube ra alako a xa mafindi saasie ra Misira bɔxi birin kui.» ");
INSERT INTO sus_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E naxa a raba na ki. Haruna to a xa yisuxuwuri itala, a fa bɔxi xube garin, na birin naxa findi saasie ra, mixie nun xurusee fɔxɔ ra. Xube birin naxa findi saasie ra Misira bɔxi birin kui. ");
INSERT INTO sus_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mandurulae to kata na kaabanako mɔɔli rabade, e mu nɔ. Saasie nu dinxi mixi nun xuruse birin na. ");
INSERT INTO sus_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mandurulae naxa a fala Firawuna bɛ, «Ala fɔxi yati nan na ki,» kɔnɔ Firawuna xaxili man naxa xɔrɔxɔ, a mu tin Munsa nun Haruna xui ra, alɔ Alatala a masenxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na tɛmui Alatala naxa a masen Munsa bɛ, «Tina gɛɛsɛgɛ i xa kurun, i xa naralan Firawuna ra ye yire. I xa a fala a bɛ Alatala xa masenyi nan ya, ‹N ma ɲama bɛɲin, alako e xa siga n batude. ");
INSERT INTO sus_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Xa i mu sa tin n ma ɲama bɛɲinde, n fama xɛɛrie nan nadinde i tan, i xa kuntigie, nun i xa ɲama ma wo xɔnyi. Xɛɛrie fama lude Misirakae xa banxie nun e xa bɔxie birin ma. ");
INSERT INTO sus_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kɔnɔ na lɔxɔɛ, Gosen bɔxi ratangama nɛ, n ma ɲama na dɛnnaxɛ. Xɛɛrie mu luma naa, alako i xa a kolon a n tan Alatala na yi bɔxi yire birin ma. ");
INSERT INTO sus_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","N tagi rasa luma nɛ n ma ɲama nun i gbe ma. Wo na kaabanako toma nɛ tina.›» ");
INSERT INTO sus_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Alatala a raba na ki nɛ. Xɛɛrie naxa din Firawuna, nun a xa kuntigie ra. Misira bɔxi birin xun naxa rakana xɛɛrie ra. ");
INSERT INTO sus_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Firawuna naxa Munsa nun Haruna xili, a a fala e bɛ, «Wo xa siga sɛrɛxɛ bade wo Marigi Ala bɛ Misira.» ");
INSERT INTO sus_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Munsa naxa a yaabi, «Na mu lanma, barima muxu xa sɛrɛxɛe mu rafan Misirakae ma. Xa muxu na sɛrɛxɛ mɔɔli ba Misirakae ya xɔri e naxee xɔnxi, e mu muxu magɔnɔma xɛ? ");
INSERT INTO sus_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","A lanma muxu xa xi saxan biyaasi raba gbengberenyi ma, muxu fa sɛrɛxɛe ba muxu Marigi Alatala bɛ, alɔ a muxu yamarixi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Firawuna naxa a fala Munsa bɛ, «N fama wo bɛɲinde, alako wo xa siga gbengberenyi ma sɛrɛxɛe bade wo Marigi Alatala bɛ. Kɔnɔ wo naxa wo makuya a gbe ra. Yakɔsi, wo Ala maxandi n bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Munsa naxa a yaabi, «N bara tin. N na mini i xɔnyi, n Alatala maxandima nɛ. Tina, xɛɛrie makuyama nɛ Firawuna, a xa kuntigie, nun a xa ɲama ra. Kɔnɔ i tan Firawuna, i naxa muxu madaxu. I naxa tondi Isirayila ɲama bɛɲinde alako e xa sɛrɛxɛe ba Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Munsa to mini Firawuna xɔnyi, a naxa Alatala maxandi. ");
INSERT INTO sus_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Alatala naxa Munsa xa duba suxu. Xɛɛrie naxa makuya Firawuna, a xa kuntigie, nun a xa ɲama ra. Hali keren mu lu naa. ");
INSERT INTO sus_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kɔnɔ Firawuna man naxa a xaxili xɔrɔxɔ, a mu tin Isirayila ɲama bɛɲinde. ");
INSERT INTO sus_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Na tɛmui Alatala naxa a masen Munsa bɛ, «I xa siga Firawuna yire, i xa a fala a bɛ, ‹Isirayilaka Marigi Alatala xa masenyi nan ya, «I xa n ma ɲama bɛɲin, alako e xa siga n batude.» ");
INSERT INTO sus_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Xa i tondi e bɛɲinde, i kankan e ma, ");
INSERT INTO sus_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Alatala fama wuganyi ɲaaxi radinde i xa xurusee ma, alɔ soe, sofalee, ɲɔxɔmɛe, ningee, yɛxɛɛe, nun si. ");
INSERT INTO sus_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Alatala fama Isirayilakae xa gɔɔrɛ nun Misirakae xa gɔɔrɛ tagi rasade. Isirayilakae xa xurusee mu wuganyi sɔtɔma. ");
INSERT INTO sus_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Alatala bara natɛ tongo na rabama tɛmui naxɛ, a falafe ra, «Tina, n fama na nan nabade.»›» ");
INSERT INTO sus_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na kuye iba, Alatala a raba na ki nɛ. Misira gɔɔrɛ birin naxa faxa, kɔnɔ hali xuruse keren mu faxa Isirayilakae xa gɔɔrɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firawuna naxa mixie xɛɛ na fe kolonde. E naxa a fala Firawuna bɛ xuruse keren mu faxaxi Isirayilakae xa gɔɔrɛ kui, kɔnɔ a xaxili naxa xɔrɔxɔ, a man mu tin Isirayila ɲama bɛɲinde. ");
INSERT INTO sus_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Na tɛmui Alatala naxa a masen Munsa nun Haruna bɛ, «Wo xa tɛ xube rate Firawuna ya xɔri. ");
INSERT INTO sus_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A findima xube ra naxan dinma Misira bɔxi birin na, a suuri ramini Misirakae nun e xa xurusee birin ma.» ");
INSERT INTO sus_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","E naxa tɛ xube xanin Firawuna yire. Munsa naxa a woli koore ma, a fa suuri ɲaaxie ramini mixie nun xurusee ma. ");
INSERT INTO sus_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mandurulae yati mu nɔ tide Munsa ya i suurie xa fe ra, naxee nu na Misirakae birin ma. ");
INSERT INTO sus_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kɔnɔ Alatala naxa Firawuna xaxili raxɔrɔxɔ, alako a naxa tin Munsa nun Haruna xui suxude, alɔ Alatala nu bara a masen Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Na tɛmui Alatala naxa a masen Munsa bɛ, «Tina i xa kurun sigafe ra Firawuna yire, a fala a bɛ, ‹Isirayila Marigi Alatala xa masenyi nan ya, «N ma ɲama bɛɲin, e xa siga n batude, ");
INSERT INTO sus_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","xa na mu a ra n gbaloe mɔɔli birin naminima i tan, i xa kuntigie, nun i xa ɲama ma n sɛnbɛ ra. Na kui i fama a kolonde n maniyɛ mu na duniɲa bɛndɛ fuɲi fari. ");
INSERT INTO sus_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","N nu nɔma gbaloe ɲaaxi raminide wo ma n sɛnbɛ ra, naxan nu nɔma wo sɔntɔde, wo lɔɛ duniɲa ma, ");
INSERT INTO sus_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","kɔnɔ n bara wo lu duniɲa alako n xa n sɛnbɛ masen wo bɛ, duniɲa xa n xili kolon. ");
INSERT INTO sus_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Han ya i kira bolonma n ma ɲama ya ra, i tondi e xa siga. ");
INSERT INTO sus_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Na nan a ra, tina n fama nɛ balabalanyi magaaxuxi ragorode Misira ma, wo mu naxan mɔɔli to kabi duniɲa fɔlɛ. ");
INSERT INTO sus_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","I xa i xa gɔɔrɛ nun i xa se birin naso yire makantaxi kui, barima yi balabalanyi na bira, a mixi nun xuruse birin sɔntɔma nɛ.»›» ");
INSERT INTO sus_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firawuna xa kuntigi ndee naxa gaaxu Alatala xa masenyi ya ra, e xulun e xa konyie nun e xa xurusee rasode yire makantaxi kui. ");
INSERT INTO sus_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kɔnɔ naxee mu nu e ɲɔxɔ saxi Alatala xa masenyi xɔn ma, e naxa e xa konyie nun e xa xurusee lu tande. ");
INSERT INTO sus_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Alatala naxa a masen Munsa bɛ, «I bɛlɛxɛ itala koore mabiri, balabalanyi xa bira mixi, xurusee, nun xɛe fari Misira bɔxi birin ma.» ");
INSERT INTO sus_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Munsa to a xa yisuxuwuri itala koore ma, Alatala naxa seyamakɔnyi, galanyi, nun balabalanyi ragoro Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Balabalanyi masunbuxi tɛ ra a naxa goro e ma. Misira bɔxi mu nu na gbaloe mɔɔli to kabi a fɔlɛ. ");
INSERT INTO sus_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Na balabalanyi naxa mixie nun xurusee magɔnɔ Misira bɔxi birin ma. A naxa xɛe nun wuri bilie fan kana. ");
INSERT INTO sus_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosen bɔxi gbansan naxa ratanga na gbaloe ma, Isirayilakae nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firawuna naxa Munsa nun Haruna xili, a a fala e bɛ, «Yi biyaasi, n bara yunubi raba. Nɔndi na Alatala nan bɛ. N tan nun n ma ɲama bara tantan. ");
INSERT INTO sus_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wo xa Alatala madiɲɛ, alako seyamakɔnyi nun balabalanyi xa ɲɔn. N bara tin wo bɛɲinde, n mu kankanma wo ma sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Munsa naxa a fala a bɛ, «N na mini taa kui, n Alatala maxandima wo bɛ. Galanyi nun balabalanyi danma nɛ, alako i xa a kolon a Alatala nan gbe duniɲa ra. ");
INSERT INTO sus_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kɔnɔ n bara a kolon, i tan nun i xa kuntigie, wo mu gaaxuxi Marigi Alatala ya ra sinden.» ");
INSERT INTO sus_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Na balabalanyi nu bara sansi funden maniyɛ nun gɛsɛ futi kana, naxee mu nu mɔ sinden. ");
INSERT INTO sus_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mɛngi nun a maniyɛ tan mu kana, barima e tan tɛmui mu nu a lixi. ");
INSERT INTO sus_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Munsa naxa mini Firawuna xɔnyi, a siga taa fari ma. A to a bɛlɛxɛ itala Alatala maxandide, galanyi, balabalanyi, nun tunɛ naxa dan. ");
INSERT INTO sus_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Firawuna to na to, a man naxa yunubi sɔtɔ, barima a tan nun a xa kuntigie naxa e xaxili raxɔrɔxɔ. ");
INSERT INTO sus_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Na kui Firawuna mu tin Isirayilakae bɛɲinde, alɔ Alatala a masenxi ki naxɛ Munsa saabui ra. ");
INSERT INTO sus_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Alatala naxa a masen Munsa bɛ, «Siga Firawuna yire, barima n tan nan a xaxili nun a xa kuntigie xaxili raxɔrɔxɔ, alako n xa n ma tɔnxuma makaabaxie masen e bɛ. ");
INSERT INTO sus_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","N gbaloe naxan dɔxɔma Misirakae ma, wo xa na fala wo xa die nun wo xa mamadie bɛ, alako wo xa a kolon, n tan nan Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Munsa nun Haruna naxa siga Firawuna xɔnyi, e a fala a bɛ, «Isirayila Marigi Alatala xa masenyi nan ya, ‹I tondima i yɛtɛ magorode n bɛ han mun tɛmui? I xa n ma ɲama bɛɲin, e xa siga n batude. ");
INSERT INTO sus_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Xa i mu e bɛɲin, tina n katoe radinma nɛ i xa bɔxi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","E bɔxi gbaata makotoma nɛ, e sansi nun wuri bili birin donma nɛ balabalanyi mu naxee lixi. ");
INSERT INTO sus_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","E fama sode i tan, i xa kuntigie, nun Misirakae birin xa banxie kui, alɔ wo benbae mu nu a toxi ki naxɛ kabi Misira fɔlɛ.›» Munsa to gɛ na falade, a naxa a kobe so, a mini Firawuna xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Firawuna xa kuntigie naxa a fala a bɛ, «Yi xɛmɛ won tɔɔrɔma han mun tɛmui? I xa a xa ɲama bɛɲin alako e xa siga e Marigi Alatala batude. Han ya i mu a kolon Misira na sɔntɔfe nɛ?» ");
INSERT INTO sus_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Firawuna naxa Munsa nun Haruna xili, a a fala e bɛ, «Wo siga, wo sa wo Marigi Alatala batu.» A man naxa e maxɔrin, «Ndee na sigafe wo ya ma?» ");
INSERT INTO sus_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Munsa naxa a yaabi, «Muxu birin sigama nɛ: fonikee, forie, xɛmɛe, ginɛe, muxu xa xurusee. Alatala xa sali xungbe na a ra.» ");
INSERT INTO sus_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firawuna naxa e yaabi, «Wo wama nɛ n xa a fala wo bɛ, ‹Alatala xa wo kanta.› Xa n sa a lu wo xa siga, wo nun wo xa die, n a kolon wo fe kobi rabama nɛ. ");
INSERT INTO sus_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","N mu tinma na ra. Xɛmɛe gbansan nɔma sigade Alatala batude, barima wo na nan maxɔrinxi.» A to gɛ na falade, Firawuna naxa e keri. ");
INSERT INTO sus_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Alatala naxa a masen Munsa bɛ, «I bɛlɛxɛ itala Misira bɔxi xun ma, katoee xa fa. E xa burɛxɛ xinde birin don balabalanyi mu naxee lixi.» ");
INSERT INTO sus_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Munsa naxa a xa yisuxuwuri itala Misira bɔxi xun ma, Alatala fa foye ramini yanyi nun kɔɛ keren kui kelife sogetede. Na kuye iba, na foye nu bara fa katoee ra, ");
INSERT INTO sus_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","naxee din Misira bɔxi birin na. Katoee gbegbe naxa lu Misira yire birin. Han ya na fe maniyɛ mu toxi, a man mu toma sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","E naxa bɔxi birin makoto han a ifɔɔrɔ. E naxa burɛxɛ xinde nun wuri bogi birin don balabalanyi mu naxan lixi. Burɛxɛ xinde yo mu lu wurie nun sansie kɔn na Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firawuna naxa Munsa nun Haruna xili mafuren. A naxa a fala e bɛ, «N bara yunubi sɔtɔ wo Marigi Alatala ra, n bara haakɛ sɔtɔ wo fan na. ");
INSERT INTO sus_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Wo xa diɲɛ n ma, wo xa wo Marigi Alatala maxandi alako a xa yi tɔɔrɛ ba n ma.» ");
INSERT INTO sus_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Munsa naxa keli Firawuna yire, a naxa Alatala maxandi. ");
INSERT INTO sus_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Alatala naxa turunnaadɛ foye ramini, a katoe birin tutun sogegorode, a sa e rasin Xulunyumi Baa ma. Hali katoe keren mu lu Misira. ");
INSERT INTO sus_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Na dangi xanbi Alatala naxa Firawuna xaxili raxɔrɔxɔ, alako a naxa Isirayilakae bɛɲin. ");
INSERT INTO sus_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Na tɛmui Alatala naxa a fala Munsa bɛ, «I bɛlɛxɛ itala koore ma, dimi binye xa sin Misira bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Munsa to na raba, dimi binye naxa sin Misira bɔxi birin ma. Xi saxan bun ma ");
INSERT INTO sus_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","mixi mu nɔ a boore tode, mixi mu nɔ kelide a xɔnyi. Kɔnɔ Isirayilakae nu sabatixi dɛnnaxɛ, mɛnni tan iyalanxi. ");
INSERT INTO sus_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firawuna naxa Munsa xili, a a fala a bɛ, «Wo xa siga Alatala batude. Wo nɔma wo xa die nun wo xa ginɛe xaninde, kɔnɔ wo xa wo xa xurusee tan lu be.» ");
INSERT INTO sus_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Munsa naxa a yaabi, «I xa tin muxu xa xurusee xanin muxu naxee bama sɛrɛxɛ ra muxu Marigi Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Muxu xa gɔɔrɛ birin xa siga. Hali keren mu luma be. Ndee bama sɛrɛxɛ nan na muxu Marigi Alatala bɛ, kɔnɔ muxu mu a kolon sinden xurusee mundun rawalima na kui, fo muxu xa so naa.» ");
INSERT INTO sus_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Na dangi xanbi Alatala naxa Firawuna xaxili raxɔrɔxɔ, a mu tin e bɛɲinde. ");
INSERT INTO sus_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawuna naxa a fala Munsa bɛ, «Keli n xun ma! I yɛtɛ ratanga tife ra n ya i sɔnɔn. Xa n i to be, n i faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Munsa naxa a yaabi, «A xa raba alɔ i a fala ki naxɛ. I mu n toma sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Alatala naxa a masen Munsa bɛ, «N fama kaabanako dɔnxɔɛ ragorode Firawuna nun Misirakae ma. Na dangi xanbi, Firawuna wo bɛɲinma nɛ, wo siga kerenyi ra. ");
INSERT INTO sus_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A fala ɲama bɛ e xa e dɔxɔboore makula gbeti nun xɛɛma ra.» ");
INSERT INTO sus_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Alatala naxa a ragiri Misirakae xa tin Isirayilakae kide. Misira ɲama nun Firawuna xa kuntigie naxa gaaxu Munsa ya ra. ");
INSERT INTO sus_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Munsa naxa a fala, «Alatala xa masenyi nan ya, ‹Kɔɛ tagi n Misira bɔxi igirima nɛ, ");
INSERT INTO sus_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","di singe birin fa faxa kelife Firawuna xa di singe ma, a sa dɔxɔ konyi ginɛe xa di singe ra. Firawuna tan mangɛya fima a xa di ma, konyi ginɛ tan taami rafalama, kɔnɔ e xa di singe birin fama nɛ faxade. Hali Misirakae xa xurusee xa di singee faxama nɛ. ");
INSERT INTO sus_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Na tɛmui Misira wa xui nde mɛma nɛ, e mu naxan mɔɔli mɛxi tɛmui dangixie, e mu naxan mɔɔli mɛma tɛmui naxee sa fama. ");
INSERT INTO sus_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kɔnɔ Isirayilakae xɔnyi, hali bare keren mu wonwonma. Na kui wo xa a kolon n tagi rasa luxi Misirakae nun Isirayilakae tagi. ");
INSERT INTO sus_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na tɛmui i xa kuntigie birin fama nɛ e xinbi sinde n bun ma, e a fala n bɛ, a n tan nun n ma ɲama birin xa mini e xa bɔxi kui. N na gɛ na rabade, n sigama nɛ.›» Munsa to gɛ na falade, a naxa keli Firawuna xun ma, a xɔnɔxi ki fanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Alatala nu bara a masen Munsa bɛ, «Firawuna mu a tuli matima wo ra. Na kui n nan n ma kaabanakoe xun masama nɛ Misira bɔxi kui.» ");
INSERT INTO sus_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Munsa nun Haruna nu bara na kaabanakoe birin naba Firawuna ya xɔri, kɔnɔ Alatala bara Firawuna xaxili raxɔrɔxɔ, a mu tin Isirayilakae xa mini a xa bɔxi kui. ");
INSERT INTO sus_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Alatala naxa a masen Munsa nun Haruna bɛ Misira bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Yi kike naxan ya, yi nan findima wo bɛ ɲɛ kike singe ra. ");
INSERT INTO sus_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Wo xa a fala Isirayila ɲama birin bɛ, yi kike xi fu, denbaya yo denbaya xa yɛxɛɛ keren sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Xa denbaya nde xurun, e mu nɔma na ra, e xa kafu e dɔxɔ boore ndee ma alako yɛxɛɛ keren xa e birin nali. ");
INSERT INTO sus_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Na yɛxɛɛ xa findi xɛmɛ ra, naxan bara ɲɛ keren sɔtɔ, lanyuru yo mu naxan ma. Xa na mu a ra, wo nɔma si fan nawalide. ");
INSERT INTO sus_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Wo xa a ragata han na kike xi fu nun naani. Na lɔxɔɛ Isirayila denbaya birin xa e gbe kɔn naxaba soge dula tɛmui. ");
INSERT INTO sus_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wo xa a wuli maso naadɛ gbanyi nun a sɛɛtie ma, a donma banxi naxan kui. ");
INSERT INTO sus_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Na sube xa gan tɛ ra, wo xa a don na kɔɛ ra taami lɛbinitare nun burɛxɛ xɔnɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Wo naxa a don a gantare ra, wo naxa a ɲin ye ra. Wo xa a birin gan a fanyi ra beenu wo xa a ixaba. A xunyi, a sanyie, nun a furingɛe xa gan tɛmui keren. ");
INSERT INTO sus_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Na sese naxa xi han gɛɛsɛgɛ. Xa nde luxi, wo xa na woli tɛ xɔɔra. ");
INSERT INTO sus_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Wo xa a don wo tagi ixirixi, wo xa sankirie soxi wo sanyie, a nun wo xa yisuxuwuri suxuxi wo bɛlɛxɛ ra. Wo xa a don mafuren mafuren. Alatala xa Sayamalekɛ Dangi Sali sɛrɛxɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Na kɔɛ ra, n Misira bɔxi isama nɛ, n di singe birin faxa mixie nun xurusee ya ma. N Misira xa alae ɲaxankatama nɛ. N tan nan Alatala ra. ");
INSERT INTO sus_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","N na na wuli tɔnxuma to wo xa naadɛe ma, n dangima nɛ mɛnni xun ma. Kasarɛ yo mu wo lima, n Misira bɔxi ratɔnma tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Na lɔxɔɛ xa findi sali xungbe nan na wo bɛ Alatala xa binyɛ bun ma. Wo xa na sali raba ɲɛ yo ɲɛ Alatala xa yaamari ki ma. ");
INSERT INTO sus_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Na sali waxati wo xa taami lɛbinitare don xi solofere bun ma. Sali fɔlɛ lɔxɔɛ, wo xa lɛbini birin namini wo xa banxie kui. Mixi yo naxan taami lɛbini daaxi donma na xi solofere bun ma, na kanyi xa ramini Isirayila ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Na sali lɔxɔɛ singe nun na sali lɔxɔɛ solofere nde, wo xa wo malan Alatala xa binyɛ bun ma. Na lɔxɔɛ firinyie, wo naxa wali yo raba bafe donse rafalafe ra.» ");
INSERT INTO sus_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Wo xa yi Taami Lɛbinitare Sali raba, barima n wo xa ɲama ramini Misira bɔxi ra na lɔxɔɛ nɛ. N bara wo yamari wo xa yi sali raba ɲɛ yo ɲɛ abadan. ");
INSERT INTO sus_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kike singe, xi fu nun naani, nunmare fɔlɔ tɛmui, wo naxa taami yo don bafe taami lɛbinitare ra han a xi mɔxɔɲɛn nun keren, a nunmare tɛmui. ");
INSERT INTO sus_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Na xi solofere bun ma, lɛbini yo naxa to wo xɔnyi, barima xɔɲɛ nun Isirayilaka birin naxan lɛbini donma na waxati bun ma, a raminima nɛ Isirayila ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Wo naxa taami lɛbini daaxi don dɛdɛ.» ");
INSERT INTO sus_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Munsa naxa Isirayila fori birin xili, a a fala e bɛ, «Wo xa siga xuruse nde sɔtɔde wo xa denbayae bɛ. Wo xa e kɔn naxaba Sayamalekɛ Dangi Sali sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Wo na gɛ xuruse kɔn naxabade, wo xa a wuli maso naadɛ gbanyi nun naadɛ sɛɛtie ma hisopi burɛxɛ ra. Mixi yo naxa mini a xa banxi kui han gɛɛsɛgɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Alatala na Misira bɔxi isa di singe faxafe ra, a dangima nɛ banxie xun ma, wuli na naxee naadɛ gbanyi nun a sɛɛtie ma. A mu tinma kanari yo xa so wo xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Wo nun wo xa die xa yi yaamari ratinmɛ ɲɛ yo ɲɛ abadan. ");
INSERT INTO sus_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Wo na so bɔxi kui Alatala naxan laayidixi wo bɛ, wo xa yi sali raba a ki ma. ");
INSERT INTO sus_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Wo xa die na wo maxɔrin, ‹Yi sali munse masenma won bɛ,› ");
INSERT INTO sus_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","wo xa e yaabi, ‹Sayamalekɛ Dangi Sali sɛrɛxɛ nan a ra. Won na rabama Alatala bɛ naxan dangi Isirayilakae xa banxie xun ma Misira, alako e xa ratanga, Misirakae tan xa faxa.›» Isirayila ɲama naxa a suyidi Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Isirayilakae naxa na yaamari ratinmɛ alɔ Alatala a masenxi Munsa nun Haruna bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kɔɛ tagi Alatala naxa di singe birin faxa Misira bɔxi kui, kelife Firawuna kibanyi kanyi xa di singe ma, a sa dɔxɔ geelimani xa di singe ra. A naxa xuruse xa di singe fan birin faxa. ");
INSERT INTO sus_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Na kui Firawuna naxa keli kɔɛ ra, a tan, a xa kuntigie, nun Misirakae birin, e fa e wa xui rate, barima banxi keren mu lu faxɛ mu ti dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Na kɔɛ ra Firawuna naxa Munsa nun Haruna xili, a a fala e bɛ, «Wo nun Isirayilakae, wo mini n ma ɲama ya ma. Wo siga, wo sa Alatala batu, alɔ wo nu wama a xɔn ma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Wo xa wo xa xurusee xanin, alɔ wo a falaxi ki naxɛ. Wo siga! Wo xa duba n fan bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirakae nu gbataxi Isirayilakae xa siga. E nu a fala, «Xa e mu sigama, won birin fama nɛ sɔntɔde!» ");
INSERT INTO sus_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Na nan a ra Isirayilakae naxa taami ramulanxi mafilin e xa dugie kui, beenu taami xa te. E naxa taami nun taami ramulanse dɔxɔ e xun ma, e fa siga. ");
INSERT INTO sus_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isirayilakae naxa gbeti, xɛɛma, nun dugie makula Misirakae ma alɔ Munsa a fala e bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Alatala naxa a ragiri Misirakae xa tin Isirayilakae waxɔnfe ra. Na kui Isirayilakae naxa se gbegbe sɔtɔ Misirakae yi ra. ");
INSERT INTO sus_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isirayilakae naxa keli Ramesesi, sigafe Sukɔti. Xɛmɛ wulu kɛmɛ senni nu na, bafe ginɛe nun dimɛdie ra. ");
INSERT INTO sus_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Mixi gbɛtɛe fan naxa bira e fɔxɔ ra, a nun gɔɔrɛ gbegbe mɔɔli birin. ");
INSERT INTO sus_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","E naxa taami gan, na taami lɛbinitare ramulanxi ra, e faxi naxan na e xun ma kelife Misira. Na taami mu nu texi, barima Misirakae to e keri, e mu nɔ fandɛ rafalade. ");
INSERT INTO sus_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isirayilakae nu bara ɲɛ kɛmɛ naani ɲɛ tongo saxan naba Misira. ");
INSERT INTO sus_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na ɲɛ kɛmɛ naani ɲɛ tongo saxan ɲɔn lɔxɔɛ yati, Alatala xa ɲama birin mini Misira bɔxi ra na nɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Alatala to na kɔɛ radangi Isirayila ɲama raminife ra Misira, a lanma Isirayilakae birin xa na kɔɛ xungbilenyi radangi Alatala matɔxɔfe ra ɲɛ yo ɲɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Alatala naxa yi sɛriyɛ so Munsa nun Haruna yi ra Sayamalekɛ Dangi Sali xa fe ra, «Mixi yo naxa na sɛrɛxɛ don naxan mu findixi Isirayilaka ra. ");
INSERT INTO sus_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Wo xa konyi sunnaxie nɔma a donde, ");
INSERT INTO sus_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","kɔnɔ wo xa walikɛ naxee kelixi yire gbɛtɛ, e naxa a don. ");
INSERT INTO sus_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Na sɛrɛxɛ xa don banxi nan kui, wo naxa a sube xanin tande, wo naxa a xɔri yo gira. ");
INSERT INTO sus_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isirayila ɲama birin xa Sayamalekɛ Dangi Sali raba. ");
INSERT INTO sus_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Xa wo xa xɔɲɛ nde wama Sayamalekɛ Dangi Sali rabafe Alatala xa binyɛ bun ma, fo a xa xɛmɛ birin sunna a xa denbaya kui. Xa a bara na raba, a nɔma na sali rabade alɔ Isirayilakae. Kɔnɔ sunnataree mu nɔma a donde. ");
INSERT INTO sus_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Lasiri nun xɔɲɛ birin na na sɛriyɛ bun ma.» ");
INSERT INTO sus_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Isirayilaka birin naxa a raba, alɔ Alatala Munsa nun Haruna yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Na lɔxɔɛ yati, Alatala naxa Isirayilakae ramini Misira bɔxi ra, e lanxundɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Wo xa di singe birin fi n ma, a findi mixi ra, a findi xuruse ra. N tan nan gbe na Isirayilakae birin xa di singee ra.» ");
INSERT INTO sus_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Munsa naxa a fala ɲama bɛ, «Wo xa ratu to lɔxɔɛ ma sali ra, barima Alatala sɛnbɛ nan wo raminixi Misira bɔxi ma konyiya kui. Wo naxa lɛbini yo don na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Wo minixi to Abibi kike nan na. ");
INSERT INTO sus_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Alatala na wo raso bɔxi kui, a naxan laayidixi wo benbae bɛ, Kanaankae, Xitikae, Amorikae, Hiwikae nun Yebusukae sabatixi dɛnnaxɛ, xiɲɛ nun kumi xɛlɛma bɔxi naxan ma, wo xa Taami Lɛbinitare Sali raba na kike ra. ");
INSERT INTO sus_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Na sali waxati wo xa taami lɛbinitare gbansan don xi solofere bun ma. Na xi solofere nde, wo xa sali raba Alatala xa binyɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Na xi solofere bun ma taami lɛbinitare nan donma. Lɛbini yo naxa lu Isirayilaka nde xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Na lɔxɔɛ wo xa yi sali xa fe fatanfasi wo xa die bɛ, wo fa a fala, ‹N yi sali rabama nɛ, barima Alatala bara n namini Misira bɔxi ra.› ");
INSERT INTO sus_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Yi sali luma nɛ wo bɛ alɔ tɔnxuma naxan saxi wo bɛlɛxɛ ma, xa na mu tɔnxuma naxan saxi wo tigi ma, alako wo naxa nɛɛmu Alatala xa sɛriyɛ ma. ");
INSERT INTO sus_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Wo xa yi sali raba a waxati ɲɛ birin na.» ");
INSERT INTO sus_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Alatala na wo raso Kanaankae xa bɔxi ma, a a fi wo ma alɔ a laayidixi wo tan nun wo benbae bɛ ki naxɛ, ");
INSERT INTO sus_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","wo xa wo xa di xɛmɛ singe birin fi Alatala ma, a nun wo xa xurusee xa di xɛmɛ singe. Wo xa di xɛmɛma singe birin findixi Alatala nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Wo nɔma yɛxɛɛ xa na mu a ra si fide wo xa sofale xa di singe ɲɔxɔɛ ra, xa na mu a ra wo xa a kobe gira, a xa faxa. Wo xa wo xa di singe fan xun sara yɛxɛɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Xa a sa li wo xa di nde wo maxɔrinma a wo yi fe rabama fe naxan ma, wo xa a yaabi, ‹Alatala sɛnbɛ nan won naminixi konyiya kui Misirakae yi ra. ");
INSERT INTO sus_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Firawuna to tondi muxu bɛɲinde muxu xa siga, Alatala naxa Misira di singe birin faxa mixie nun xurusee ya ma. Na nan a ra won xurusee xa di singe birin fima Alatala ma sɛrɛxɛ ra, a nun won ma di xɛmɛ singe birin xun sarama nɛ yɛxɛɛ ra.› ");
INSERT INTO sus_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Na luma nɛ wo bɛ alɔ tɔnxuma naxan saxi wo bɛlɛxɛ ma, xa na mu tɔnxuma naxan saxi wo tigi ma, barima Alatala sɛnbɛ nan wo raminixi Misira bɔxi ma konyiya kui.» ");
INSERT INTO sus_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Firawuna to Isirayila ɲama bɛɲin, Alatala mu e xun ti Filisita bɔxi kira ra, hali na kira nan to sɔɔnɛya, barima a a fala nɛ, «Xa ɲama gere lima kira xɔn ma, e natɛ masarama nɛ, e fa gbilen Misira.» ");
INSERT INTO sus_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Na kui Alatala naxa ɲama ya rafindi gbengberenyi kira ma Xulunyumi Baa mabiri. Isirayilakae naxa mini Misira e xa geresosee ra e yi ra. ");
INSERT INTO sus_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Munsa naxa Yusufu xɔrie fan xanin, barima Yusufu nu bara Isirayila xa die rakali na fe ma, a falafe ra, «N a kolon, Alatala fama nɛ wo malide. Na tɛmui wo xa n xɔrie xanin wo xun ma yire gbɛtɛ.» ");
INSERT INTO sus_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isirayilakae naxa keli Sukɔti, e sa yonkin Etama gbengberenyi fɔlɔxi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Alatala nan nu tixi e ya ra. Yanyi ra a naxa e raɲɛrɛ nuxui ra, kɔɛ ra a naxa e raɲɛrɛ tɛ dɛxɛ ra koore ma, naxan nu kuye iyalanma e bɛ. Na ki e nu nɔma ɲɛrɛde kɔɛ nun yanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Lɔxɔ yo lɔxɔ na nuxui nu tixi e ya ra yanyi ra, na tɛ fan nu tixi e ya ra kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«A fala Isirayilakae bɛ e xa gbilen, e xa fa yonkin Pi Haxirɔti mabiri ra, Migidoli nun baa tagi. E xa lu baa dɛ ra Baali Sefon ya ra. ");
INSERT INTO sus_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firawuna a maɲɔxunma nɛ, a Isirayilakae bara lɔɛ gbengberenyi mabiri. ");
INSERT INTO sus_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","N Firawuna xaxili raxɔrɔxɔma nɛ, alako a xa bira wo fɔxɔ ra. Na kui n fama matɔxɔɛ sɔtɔde Firawuna nun a xa sɔɔrie saabui ra. Misirakae fama nɛ a kolonde a n tan nan na Alatala ra.» Isirayilakae a raba na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Misira mangɛ nun a xa kuntigie to a kolon, a Isirayilakae bara siga, e naxa natɛ masara, a falafe ra, «Won munse rabaxi yi ki? Won to Isirayilakae bɛɲinxi, e mu walima won bɛ sɔnɔn!» ");
INSERT INTO sus_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Firawuna naxa yaamari fi soe xa xiri sɔɔri ragisee ra, sɔɔrie xa malan yire keren. ");
INSERT INTO sus_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A naxa sɔɔri ragise fanyi kɛmɛ senni sugandi, sɔɔri ragise naxan birin na Misira e fa bira e fɔxɔ ra. Sɔɔri kuntigi nu bakixi e birin kui. ");
INSERT INTO sus_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Alatala naxa Misira mangɛ Firawuna xaxili raxɔrɔxɔ, a fa bira Isirayilakae fɔxɔ ra, naxee nu sigafe xun nakeli kui. ");
INSERT INTO sus_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Firawuna nun a xa sɔɔri birin naxa bira Isirayilakae fɔxɔ ra e xa soe nun e xa sɔɔri ragisee ra. Misirakae naxa e li baa dɛ ra, e nu yonkinxi dɛnnaxɛ, Pi Haxirɔti mabiri ra, Baali Sefon ya ra. ");
INSERT INTO sus_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firawuna to makɔrɛ e ra, Isirayilakae naxa e ya rakeli, e naxa Misirakae to fa ra. E naxa gaaxu ki fanyi ra, e fa e mawa Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","E naxa a fala Munsa bɛ, «I won naminixi Misira bɔxi ra munfe ra? Yakɔsi won faxama nɛ gbengberen yire. A mu nu fisa won xa faxa Misira? ");
INSERT INTO sus_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Won nu na Misira bɔxi ma tɛmui naxɛ, muxu a fala nɛ i bɛ, ‹Muxu walife Misirakae bɛ, na fisa muxu bɛ dinɛ faxafe ra gbengberenyi ma.›» ");
INSERT INTO sus_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Munsa naxa ɲama yaabi, «Wo naxa gaaxu, wo xa limaniya. To wo fama Alatala xa kisi tode. Misirakae naxee yi ki, wo mu e toma sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Alatala nan gere soma wo bɛ. Wo sabari.» ");
INSERT INTO sus_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Alatala naxa a masen Munsa bɛ, «I mawafe n bɛ munfe ra? A fala Isirayilakae bɛ, e xa ti kira xɔn ma. ");
INSERT INTO sus_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","I xa yisuxuwuri rate, a itala baa xun ma, alako baa xa rabi, Isirayilakae xa igiri bɔxi xaraxi ra. ");
INSERT INTO sus_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","N Misirakae xaxili raxɔrɔxɔma nɛ, alako e xa bira wo fɔxɔ ra. Na kui n matɔxɔɛ sɔtɔma Firawuna, a xa sɔɔrie, a xa sɔɔri ragisee, nun a xa soe ragimae saabui ra. ");
INSERT INTO sus_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","N na gɛ matɔxɔɛ sɔtɔde Firawuna, a xa sɔɔri ragisee, nun a xa soe ragimae saabui ra, Misirakae a kolonma nɛ a n tan nan na Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ala xa malekɛ naxan nu na sigafe Isirayila ɲama ya ra, a naxa gbilen e xanbi ra. Nuxui fan naxa keli e ya ra, a fa ti e xanbi ra ");
INSERT INTO sus_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Misirakae nun Isirayilakae tagi. Na nuxui naxa a niya Misirakae xa lu dimi kui, Isirayilakae tan xa lu naiyalanyi kui. E mu nɔ e makɔrɛde e boore ra na kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Munsa to a bɛlɛxɛ itala baa xun ma, Alatala naxa baa tutun kɔɛ birin na foye xungbe ra kelife sogetede. A naxa kira xaraxi ramini baa tagi. ");
INSERT INTO sus_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isirayilakae dangima dɛnnaxɛ, baa yee naxa malan e yirefanyi ma nun e kɔɔla ma. ");
INSERT INTO sus_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirakae naxa e sagata. Firawuna xa soe, a xa sɔɔri ragisee, nun a xa soe ragimae birin naxa bira e fɔxɔ ra baa tagi. ");
INSERT INTO sus_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Subaxɛ ma, Alatala naxa a ya rasiga Misira xa sɔɔrie ma kelife koore ma, tɛ nun nuxui na dɛnnaxɛ, a fa e ifu. ");
INSERT INTO sus_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A naxa a ragiri sɔɔrie ragisee sanyie xa ba na, e xa ɲɛrɛ xa xɔrɔxɔ. Na kui, Misirakae naxa a fala, «Won xa won gi Isirayilakae ma, barima Alatala nan na e xa gere sofe.» ");
INSERT INTO sus_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Alatala naxa a masen Munsa bɛ, «I bɛlɛxɛ itala baa xun ma, ye xa radin Misirakae, e xa sɔɔri ragisee, nun e xa soe ragimae xun na.» ");
INSERT INTO sus_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Munsa to na raba subaxɛ ma, baa naxa gbilen a yire. Misirakae nu na e gife tɛmui naxɛ, Alatala naxa ye dusu e birin xun na. ");
INSERT INTO sus_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ye naxa Firawuna xa sɔɔrie, a xa ragisee, soe ragimae, nun a xa sɔɔri birin makoto. Naxee nu biraxi Isirayilakae fɔxɔ ra baa kui, nee birin naxa lɔɛ. ");
INSERT INTO sus_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kɔnɔ Isirayilakae naxa baa igiri kira xaraxi xɔn ma. Ye nu malanxi e yirefanyi ma nun e kɔɔla ma. ");
INSERT INTO sus_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Na lɔxɔɛ Alatala naxa Isirayilakae ratanga Misirakae ma. Isirayilakae naxa Misirakae furee to baa dɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isirayilakae to Alatala sɛnbɛ to a naxan nawalixi Misirakae xili ma, e naxa gaaxu Alatala ya ra, e fa e taxu Alatala nun a xa xɛɛra Munsa ra. ");
INSERT INTO sus_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na dangi xanbi Munsa nun Isirayilakae naxa yi bɛɛti ba Alatala bɛ. «N xa yi bɛɛti ba Alatala bɛ, naxan xili gbo. A bara soe nun a ragima madula baa ma. ");
INSERT INTO sus_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","N sɛnbɛ na Alatala nan na. N a matɔxɔma bɛɛti ra. A bara findi n Nakisima nun n Marigi ra. N tantui rasigama n benbae Marigi ma. ");
INSERT INTO sus_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Sɛnbɛma nan Ala ra. A xili nɛ Alatala. ");
INSERT INTO sus_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A naxa Firawuna xa sɔɔrie nun e ragisee rasin baa ma. Firawuna xa kuntigie naxa madula Xulunyumi Baa ma. ");
INSERT INTO sus_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mɔrɔnyie naxa e makoto, e naxa goro a bɔtini ma alɔ gɛmɛ. ");
INSERT INTO sus_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Alatala, i sɛnbɛ magaaxu. I bara nɔ i yaxuie ra, i bara nɔ i matandimae ra. ");
INSERT INTO sus_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I xa mangɛya sɛnbɛ magaaxu. I bɔɲɛ na te, e ganma nɛ alɔ sɛxɛ tɛ soxi naxan na. ");
INSERT INTO sus_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I xa foye naxa Xulunyumi baa rabi, kira xaraxi naxa lu a tagi. Mɔrɔnyie naxa te alɔ banxi xalɛ. Ye naxa ti, a xɔrɔxɔ. ");
INSERT INTO sus_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Isirayila yaxui a fala nɛ, ‹N birama nɛ e fɔxɔ ra, han n e li, n e harige tongoma nɛ, han n wasa. N e sɔntɔma nɛ n ma santidɛgɛma ra.› ");
INSERT INTO sus_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kɔnɔ i tan naxa foye ramini, baa naxa e radula. E naxa goro ye xɔɔra alɔ yɔxui. ");
INSERT INTO sus_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Alatala, i maniyɛ mu na adama xa alae ya ma. I xa sɛniyɛnyi fiixɛ, i xa nɔrɛ gbo, i xa kaabanakoe wuya. I maniyɛ na minden? ");
INSERT INTO sus_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","I to i sɛnbɛ ramini, bɔxi naxa e gerun. ");
INSERT INTO sus_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","I xa ɲama naxan xun saraxi, i fama e xun tide i xa xanunteya ra, naxan mu ɲɔnma abadan. I fama e xun tide i xa lingira sɛniyɛnxi yire i sɛnbɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ɲamanɛ gbɛtɛe na na mɛ, e gaaxuma nɛ. Filisitakae bɔɲɛ minima nɛ. ");
INSERT INTO sus_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edon yareratie ifuma nɛ, Mowaba mangɛe sɛrɛnma nɛ. Limaniya birin bama nɛ Kanaan ɲamanɛ yi ra. ");
INSERT INTO sus_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Alatala, gaaxui nun kɔntɔfili e suxuma nɛ, e dɛ balanma nɛ i sɛnbɛ ra, han i xa ɲama dangi, i naxan xun saraxi. ");
INSERT INTO sus_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","I fama nɛ i xa ɲama rasabatide i xa geya fari, i dɛnnaxɛ sugandixi i xa lingira sɛniyɛnxi ra. ");
INSERT INTO sus_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Alatala xa mangɛya buma abadan.» ");
INSERT INTO sus_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Firawuna xa soe, a xa sɔɔri ragisee, nun a xa soe ragimae to goro baa ma, Alatala naxa baa radin e xun ma, kɔnɔ Isirayilakae naxa dangi kira xaraxi ra baa tagi. ");
INSERT INTO sus_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Haruna maaginɛ Mariyama, naxan findixi namiɲɔnmɛ ginɛ ra, a naxa boote maxa. Ginɛ gbɛtɛe naxa fare boron. ");
INSERT INTO sus_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mariyama naxa yi bɛɛti ba, «Wo bɛɛti ba Alatala bɛ, barima a xili gbo. A bara soe nun e ragimae radula baa ma.» ");
INSERT INTO sus_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Munsa naxa Isirayilakae xun ti Suru gbengberenyi rakelife Xulunyumi Baa dɛ ra. E naxa e ɲɛrɛ xi saxan gbengberenyi ma, e mu ye sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","E naxa Mara li, kɔnɔ e mu nɔ Mara ye minde barima na ye nu xɔnɔ. «Mara» wama «xɔnɛ» nan falafe. ");
INSERT INTO sus_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ɲama naxa sɔnxɔ Munsa ma, «Won ye sɔtɔma minden?» ");
INSERT INTO sus_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Munsa naxa a dɛ rawa Alatala xɔn ma. Alatala naxa wuri mɔɔli nde masen Munsa bɛ, a fa na woli ye xɔɔra, ye xɔnɛ naxa ba. Alatala to gɛ e xaxili matode mɛnni, a naxa yi saatɛ tongo e bɛ, ");
INSERT INTO sus_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Xa wo wo tuli mati n xui ra a fanyi ra, xa wo bira n ma tinxinyi fɔxɔ ra, xa wo n ma yaamari birin suxu, wo n ma sɛriyɛ birin binya, n tan, wo Marigi Alatala, n mu fure ɲaaxi yo ragoroma wo ma, alɔ n naxan nagoro Misirakae ma. N tan nan Alatala ra, naxan wo rayalanma.» ");
INSERT INTO sus_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","E to dulonyi fu nun firin nun tugi bili tongo solofere li Elimi, e naxa yonkin mɛnni. ");
INSERT INTO sus_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isirayila ɲama birin naxa keli Elimi, sigafe ra Sini gbengberenyi ma, naxan na Elimi nun Turusinina tagi. E biyaasi naxan naba keli Misira han Sini gbengberenyi ma, na naxa bu kike firin a nun xi fu nun suuli. ");
INSERT INTO sus_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mɛnni Isirayila ɲama naxa sɔnxɔ Munsa nun Haruna ma, ");
INSERT INTO sus_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","a falafe ra, «Munfe ra Alatala mu a ragirixi won xa faxa Misira bɔxi ma? Mɛnni sube nun taami nu na won yi ra naxan won lugama, kɔnɔ be yi gbengberen yire, won fama faxade kaamɛ nan na.» ");
INSERT INTO sus_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Alatala naxa a masen Munsa bɛ, «N fama taami ragorode wo bɛ kelife koore ma. Ɲama xa mini, e xa a matongo gɛɛsɛgɛ e naxan donma lɔxɔɛ keren kui. N fama e xaxili matode, xa e ɲɛrɛma n ma yaamari nan ma. ");
INSERT INTO sus_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A xi senni nde, e xa xi firin daaxi matongo.» ");
INSERT INTO sus_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Munsa nun Haruna naxa a fala Isirayila ɲama bɛ, «To nunmare wo a kolonma nɛ, a Alatala nan wo raminixi Misira bɔxi ra. ");
INSERT INTO sus_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Tina gɛɛsɛgɛ, wo fama Alatala xa kaabanako tode. A bara wo xa sɔnxɔɛ mɛ. Munfe ra wo wama sɔnxɔfe muxu tan ma? ");
INSERT INTO sus_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","To nunmare Alatala wo kima sube ra, gɛɛsɛgɛ a wo kima taami ra, han wo luga. Wo mu sɔnxɔxi muxu tan xa ma de. Wo sɔnxɔxi Alatala nan ma, naxan bara wo xui birin mɛ.» ");
INSERT INTO sus_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Munsa naxa a fala Haruna bɛ, «A fala Isirayila ɲama bɛ, e xa e yɛtɛ masen Alatala bɛ, barima a bara e xa sɔnxɔɛ mɛ.» ");
INSERT INTO sus_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haruna nu wɔyɛnfe Isirayila ɲama bɛ tɛmui naxɛ, e naxa e ya rafindi gbengberenyi ma, e fa Alatala xa nɔrɛ to mini ra nuxui kui. ");
INSERT INTO sus_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«N bara Isirayilakae xa sɔnxɔɛ mɛ. A fala e bɛ, ‹Nunmare wo sube donma, gɛɛsɛgɛ wo lugama taami ra. Na kui wo a kolonma nɛ, a n tan nan na wo Marigi Alatala ra.›» ");
INSERT INTO sus_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nunmare yati xɔnie naxee xili kɔnkɔlɛe naxa radin e yonkinde birin ma. Na kuye iba xini naxa lu e yonkinde rabilinyi ma. ");
INSERT INTO sus_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Na xini to ba na, se nde naxa lu bɔxi fari alɔ balabalanyi. ");
INSERT INTO sus_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isirayilakae to na to, e naxa e boore maxɔrin, «Munse ya?» E mu a kolon se yo na ki. Munsa naxa a fala e bɛ, «Taami nan a ra, Alatala naxan fixi wo ma baloe ra.» ");
INSERT INTO sus_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Alatala xa yaamari nan ya, «Wo xa sigaati ya solofere tongo mixi birin bɛ naxan na wo xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isirayilakae a raba na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E to a maniya, naxee gbe nu gboxi, a mu dangi yɛ, naxee fan gbe nu xurunxi, a e ralixi nɛ. Kankan naxa baloe xasabi sɔtɔ naxan a ralima. ");
INSERT INTO sus_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Munsa naxa a fala e bɛ, «Yi baloe naxa raxi han gɛɛsɛgɛ.» ");
INSERT INTO sus_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kɔnɔ ndee mu Munsa xui suxu, e naxa a ragata han gɛɛsɛgɛ. Kulie naxa bira a i, a xiri ɲaaxi naxa mini. Munsa naxa xɔnɔ na kanyie ma. ");
INSERT INTO sus_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Gɛɛsɛgɛ yo gɛɛsɛgɛ, kankan nu fa a gbe donse matongo, kɔnɔ soge na te, a dɔnxɔɛ naxan luxi, na xunu a i. ");
INSERT INTO sus_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A xi senni nde, e naxa xi firin daaxi matongo, sigaati ya fu nun naani mixi keren bɛ. Yareratie naxa na dɛntɛgɛ sa Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Munsa naxa a fala e bɛ, «Alatala naxɛ a tina malabui lɔxɔɛ nan a ra, lɔxɔɛ sɛniyɛnxi Alatala bɛ. Wo xa nde gan, wo xa nde satun. A dɔnxɔɛ naxan na lu, wo xa na ragata han tina gɛɛsɛgɛ.» ");
INSERT INTO sus_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","E to nde ragata han gɛɛsɛgɛ, alɔ Munsa a yamari e bɛ ki naxɛ, e naxa a to kuli mu biraxi a i, a man mu bɔrɔ. ");
INSERT INTO sus_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Munsa naxa a fala e bɛ, «Wo xa a don to, barima to nan malabui lɔxɔɛ ra Alatala xa binyɛ bun ma. Na donse mu goroma bɔxi ma to. ");
INSERT INTO sus_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Wo xa a matongo xi senni bun ma, kɔnɔ a xi solofere nde, wo mu sese toma, barima malabui lɔxɔɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","A xi solofere nde, mixi ndee mini nɛ na donse matongode, kɔnɔ e mu sese to. ");
INSERT INTO sus_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Na kui Alatala naxa a masen Munsa bɛ, «Wo n ma yaamari nun n ma sɛriyɛ matandima han mun tɛmui? ");
INSERT INTO sus_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wo xa a kolon, n tan Alatala nan malabui lɔxɔɛ sɛriyɛ masenxi wo bɛ. Na nan a ra, xi senni nde wo donse xi firin daaxi sɔtɔma. A solofere nde wo naxa siga dɛdɛ, wo birin xa lu wo xɔnyie, malabui lɔxɔɛ nan a ra.» ");
INSERT INTO sus_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Na kui ɲama naxa e malabu na lɔxɔɛ solofere nde ma. ");
INSERT INTO sus_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isirayilakae naxa na donse xili fala «mana,» naxan nu wama a falafe, «Munse a ra?» A maniya funden xɔri ra, a fiixɛ, a ɲɔxun alɔ digiyanyi. ");
INSERT INTO sus_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Munsa naxa a fala, «Alatala xa yaamari nan yi ki, ‹Wo xa yi mana sigaati ya solofere ragata, alako wo bɔnsɔɛ naxee fama baride e xa donse to n naxan nagoroxi wo ma gbengberenyi ma, n to wo ramini Misira bɔxi ra.›» ");
INSERT INTO sus_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Na kui Munsa naxa a fala Haruna bɛ, «I xa mana sigaati ya solofere sa sesase kui, i xa a dɔxɔ hɔrɔmɔlingira yire, alako a xa findi tɔnxuma ra wo bɔnsɔɛe bɛ naxee fama baride.» ");
INSERT INTO sus_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Haruna naxa na sesase dɔxɔ Alatala xa hɔrɔmɔlingira yire saatɛ kankira ya ra, alako a xa ragata alɔ Alatala a masenxi Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isirayilakae mana don nɛ ɲɛ tongo naani bun ma, han e sa so Kanaan bɔxi ma, si gbɛtɛe sabatixi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Na sigaati ya solofere naxan nu rawalima na mana maniyafe ra, a dɔxɔ fu findixi busali keren nan na. ");
INSERT INTO sus_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isirayila ɲama birin naxa keli Sini gbengberenyi ma, e fa biyaasi raba alɔ Alatala nu luma e yamari ra ki naxɛ. E to Refidimi li, e naxa yonkin naa, kɔnɔ e mu ye min daaxi sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ɲama naxa ti Munsa kanke, e a fala a bɛ, «Ye so muxu yi ra.» Munsa naxa wɔyɛn e bɛ, «Wo tima n kanke munfe ra? Wo na Alatala matofe munfe ra?» ");
INSERT INTO sus_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ye xɔli nu bara gbaa ɲama ra, e nu fa a fala Munsa bɛ, «Munfe ra i muxu raminixi Misira bɔxi ra? I wama nɛ muxu xa denbaya nun muxu xa xurusee xa faxa ye xɔli ra gbengberenyi ma?» ");
INSERT INTO sus_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Munsa naxa a dɛ rawa Alatala xɔn ma, a falafe ra, «N nɔma munse rabade yi ɲama ra? A gbe mu luxi e xa n faxa.» ");
INSERT INTO sus_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Alatala naxa Munsa yaabi, «I xa dangi ɲama ya ra, a nun Isirayila fori ndee. I xa i xa yisuxuwuri tongo, i Nili xure garin naxan na, i ti e ya ra. ");
INSERT INTO sus_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","N tima i ya ra, fanye sɛɛti ma, naxan na Xorebe geya yire. I xa na fanye garin. Na kui ye minima nɛ ɲama naxan minma.» Munsa naxa a raba na ki Isirayila forie ya xɔri. ");
INSERT INTO sus_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A naxa na yire xili sa Masa nun Meriba, na nan na ki «matoe nun sɔnxɔɛ,» barima Isirayilakae sɔnxɔ nɛ Munsa ma mɛnni, e man naxa Alatala mato na a falafe ra, «Alatala na won tagi ba, ka a mu won tagi?» ");
INSERT INTO sus_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalɛkikae naxa fa Isirayila gerede Refidimi. ");
INSERT INTO sus_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Munsa naxa a fala Yosuwe bɛ, «Xɛmɛ ndee mayegeti, wo fa mini Amalɛkikae gerede. Tina, n tima nɛ geya fari Ala xa yisuxuwuri ra n yi.» ");
INSERT INTO sus_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwe naxa Amalɛkikae gere alɔ Munsa a yamarixi ki naxɛ. Munsa, Haruna, nun Xuru naxa te geya fari. ");
INSERT INTO sus_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Munsa to a bɛlɛxɛ itema, Isirayila sɛnbɛ nu gboma, kɔnɔ a to a bɛlɛxɛ igoroma, Amalɛkikae sɛnbɛ tan nu gboma. ");
INSERT INTO sus_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Munsa bɛlɛxɛe to binya a ra, e naxa gɛmɛ nde tongo a dɔxɔma naxan fari. Haruna nun Xuru naxa lu Munsa sɛɛti ma, a kɔɔla nun a yirefanyi ma, a bɛlɛxɛ ratefe ra han soge dula tɛmui. ");
INSERT INTO sus_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Na kui Yosuwe naxa nɔ Amalɛki nun a xa sɔɔrie ra santidɛgɛma xɛɲɛnxie ra. ");
INSERT INTO sus_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Alatala naxa a masen Munsa bɛ, «Yi taruxui sɛbɛ alako ɲama xa ratu a ma. I man xa a fala Yosuwe bɛ, ‹N fama nɛ Amalɛkikae xa fe ɲɔnde yi duniɲa ma.›» ");
INSERT INTO sus_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Munsa naxa yire nde rafala sɛrɛxɛbade ra, a naxa na yire xili sa, «Alatala nan xun nakeli fima n ma,» ");
INSERT INTO sus_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","barima a nu bara a xaxili ti Alatala xa mangɛya ra. Munsa naxa a a fala, «Alatala Amalɛkikae gerema nɛ abadan.» ");
INSERT INTO sus_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Munsa bitanyi Yetiro, naxan findixi Madiyan sɛrɛxɛdubɛ ra, a naxa a mɛ Alatala naxan nabaxi Munsa nun a xa ɲama Isirayila bɛ, e raminife ra Misira bɔxi kui. ");
INSERT INTO sus_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Munsa nu bara a xa ginɛ Sipora nun a xa di firinyi xɛɛ Yetiro xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Munsa xa di singe nu xili Gerisomi, barima na xili nu wama a falafe e gbe xui, «Xɔɲɛ nan n na yi bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Boore nu xili Eliyeseri, barima na xili nu wama a falafe e gbe xui, «N baba Marigi bara n mali, a bara n natanga Firawuna xa santidɛgɛma ma.» ");
INSERT INTO sus_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Munsa bitanyi Yetiro naxa Munsa xa ginɛ nun na xa die xanin Munsa yire gbengberenyi ma, a nu yonkinxi dɛnnaxɛ, Ala xa geya mabiri. ");
INSERT INTO sus_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetiro nu bara xɛɛra xɛɛ Munsa xɔn a falafe ra, «N tan, i bitanyi Yetiro, n na fafe i xa ginɛ nun a xa di firinyie ra.» ");
INSERT INTO sus_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Munsa naxa mini a bitanyi ralande. A naxa a xinbi sin a ya ra, a man fa a sunbu. E to e boore xɛɛbu, e naxa so Munsa xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Munsa naxa fee ya ba a bitanyi bɛ, Alatala naxan birin naba Firawuna nun Misirakae ra Isirayila xa fe ra. A naxa Isirayila xa ɲaxankatɛ birin fala a bɛ, a nun Alatala e rakisixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetiro naxa sɛɛwa Alatala xa hinnɛ ra a naxan masenxi Isirayila bɛ, a e bafe ra Misirakae yi ra. ");
INSERT INTO sus_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetiro naxa a fala, «Tantui na Alatala bɛ, naxan wo ba Misirakae nun Firawuna yi ra, naxan Isirayila ɲama raminixi e xa nɔɛ bun ma! ");
INSERT INTO sus_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","N bara a kolon Alatala sɛnbɛ gbo dangi adamadie xa alae mɔɔli birin na, barima a bara ɲama igoro naxan nu bara a yɛtɛ rafisa Isirayilakae bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Na tɛmui Munsa bitanyi Yetiro naxa sɛrɛxɛ gan daaxi nun sɛrɛxɛ gbɛtɛe ba Alatala bɛ. Haruna nun Isirayila fori birin naxa na sɛrɛxɛ don Munsa bitanyi yire Alatala xa hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Na kuye iba, Munsa naxa a magoro, a xa kiiti sa Isirayilakae tagi. Ɲama naxa lu a yire kelife gɛɛsɛgɛ han nunmare. ");
INSERT INTO sus_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","A bitanyi to a to Munsa naxan birin nabama ɲama bɛ, a naxa a fala a bɛ, «I na munse rabafe yi ɲama bɛ? Munfe ra kiiti wali birin dɔxɔxi i keren nan xun ma kelife gɛɛsɛgɛ han nunmare?» ");
INSERT INTO sus_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Munsa naxa a bitanyi yaabi, «Ɲama faxi n yire Alatala xa kiiti nan fende. ");
INSERT INTO sus_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Galanbui na lu mixie tagi e fama n yire n xa kiiti sa Alatala xa yaamarie nun a xa sɛriyɛ ra.» ");
INSERT INTO sus_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Munsa bitanyi naxa a fala a bɛ, «A mu lanma i xa a raba na ki.» ");
INSERT INTO sus_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","I nun i xa mixie, wo taganma nɛ. I keren mu nɔma yi kote xaninde. ");
INSERT INTO sus_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","I xa i tuli mati n ma marasi ra. Ala xa i mali. I tan xa findi ɲama xui madangima ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","I lan nɛ i xa e xaran Alatala xa sɛriyɛ nun a xa yaamarie ra. I xa Ala xa kira masen e bɛ, e birama naxan fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mixi kɛndɛe sugandi ɲama ya ma, nɔndi falɛ naxee gaaxuma Alatala ya ra, naxee riba xɔnxi. I xa nee findi yareratie ra ɲama xun ma xunlande ki ma. Nde xa lu mixi wulu keren xun ma, boore mixi kɛmɛ xun ma, boore mixi tongo suuli xun ma, boore mixi fu xun ma. ");
INSERT INTO sus_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Nee xa kiiti birin sa mixie tagi, fo kiiti nde naxee xɔrɔxɔ. E xa na kiiti xɔrɔxɔɛ masen i tan bɛ. Na ki, kote mu dɔxɔma i keren xun. ");
INSERT INTO sus_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Xa i Ala xui suxuma, na rabafe nɔma findide sɔɔnɛya ra wo birin bɛ, bɔɲɛsa fa lu ɲama bɛ e xɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Munsa naxa a bitanyi xui suxu, a birin naxa raba alɔ a falaxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Munsa naxa mixi kɛndɛe sugandi Isirayilakae ya ma, a fa e dɔxɔ ɲama xun na xunlande ki ma, mixi wulu keren xun ma, mixi kɛmɛ xun ma, mixi tongo suuli xun ma, nun mixi fu xun ma. ");
INSERT INTO sus_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E nu kiitisa wali raba tɛmui birin, fo kiiti xɔrɔxɔɛ e nee nan masenma Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na tɛmui Munsa naxa a bitanyi bɛɲin. Yetiro naxa gbilen a xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Kike saxan yati to dangi, kelife e mini Misira bɔxi ra tɛmui naxɛ, Isirayilakae naxa so Turusinina gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","E to keli Refidimi, e naxa so Turusinina gbengberenyi ma, e yonkin geya ya tagi. ");
INSERT INTO sus_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Munsa naxa te geya fari sigafe Alatala yire. Alatala naxa a xili geya fari, a a masen a bɛ, «I xa a fala Isirayilakae Yaxuba bɔnsɔɛ bɛ, ");
INSERT INTO sus_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Wo bara a to, n fe naxan nabaxi Misirakae ra. Wo bara a kolon n faxi wo ra n yire ki naxɛ. A luxi alɔ wo bakixi xɔni nan fari. ");
INSERT INTO sus_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Xa wo n xui suxu n ma saatɛ rakamalife ra, wo fama nɛ findide n ma ɲama sugandixi ra si birin ya ma. N gbe nan duniɲa birin na, ");
INSERT INTO sus_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","kɔnɔ wo tan findima n ma si sɛniyɛnxi nan na, naxan sɛrɛxɛdubɛ wali rabama.› I xa na masenyi ti Isirayilakae bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Munsa naxa goro, a fori birin xili, a fa Alatala xa masenyi birin dɛntɛgɛ e bɛ. ");
INSERT INTO sus_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ɲama birin naxa a fala, «Muxu Alatala xui birin suxuma nɛ.» Munsa naxa ɲama xa yaabi dɛntɛgɛ Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Alatala naxa a masen Munsa bɛ, «N fama wɔyɛnde i bɛ nuxui kui ɲama ya xɔri, alako e xa lanlanteya sa i ma tɛmui birin.» Munsa naxa ɲama xa masenyi dɛntɛgɛ Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Alatala naxa a masen Munsa bɛ, «A fala ɲama bɛ, e xa e yɛtɛ rasɛniyɛn to nun tina. E xa e xa dugie fan xa. ");
INSERT INTO sus_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","E xa rɛdi tina bora ya ra, barima n fama nɛ gorode ɲama birin ya tode ra na lɔxɔɛ Turusinina geya fari. ");
INSERT INTO sus_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I xa naaninyi sa geya rabilinyi birin ma, i fa a fala ɲama bɛ, ‹Mixi yo naxa te geya fari, mixi yo naxa a makɔrɛ a ra, barima naxan yo din a ra, na kanyi faxama nɛ.› ");
INSERT INTO sus_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Wo naxa wo bɛlɛxɛ din na kanyi ra, wo a magɔnɔ gɛmɛ ra han a faxa. Xa na mu, wo xa a masɔxɔ xalie ra. A findi daalise ra, a findi mixi ra, a lanma a xa faxa. Mixi mu lanma a xa te geya fari, fo sara xui na mini mixi sugandixi ndee fa te.» ");
INSERT INTO sus_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Munsa to goro geya ma ɲama yire, a naxa marasɛniyɛnyi fe fala e bɛ, e xa e yɛtɛ nun e xa dugie rasɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","A naxa a fala ɲama bɛ, «Wo xa wo yɛtɛ yailan tina bora ya ra. Sade fe naxa lu wo tan nun wo xa ginɛe tagi.» ");
INSERT INTO sus_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A xi saxan lɔxɔɛ, galanyi nun seyamakɔnyi naxa bira bɔxi ma gɛɛsɛgɛ, nuxui ifɔɔrɔxi naxa to geya ma. Sara xui naxa mini sɛnbɛ ra. Ɲama birin naxa gaaxu. ");
INSERT INTO sus_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Munsa naxa ɲama mati geya lanbanyi Ala xui ramɛde. ");
INSERT INTO sus_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tuuri nu na Turusinina geya ma, barima Alatala nu bara goro tɛ tagi. Na tuuri nu tema nɛ, alɔ fiili na gan. Geya nu sɛrɛnma sɛnbɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Sara xui nu sigama gbo ra. Na tɛmui Munsa naxa wɔyɛn, Ala naxa a yaabi. ");
INSERT INTO sus_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Alatala naxa goro Turusinina geya fari, a fa Munsa xili. Munsa to te naa, ");
INSERT INTO sus_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Alatala naxa a masen a bɛ, «I xa goro, i xa a fala ɲama bɛ, e naxa wuruntun n tofe ra de, xa na mu a ra, a gbegbe faxama nɛ. ");
INSERT INTO sus_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hali sɛrɛxɛdubɛ naxee e makɔrɛma n na, e xa e yɛtɛ rasɛniyɛn, alako n naxa fa e faxa.» ");
INSERT INTO sus_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Munsa naxa a fala Alatala bɛ, «Ɲama mu nɔma tide Turusinina geya fari, barima i ɲan bara muxu yamari naaninyie xa sa geya rabilinyi ma, ɲama xa lu e xati ma.» ");
INSERT INTO sus_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Alatala naxa a masen a bɛ, «I xa goro sinden Haruna fɔxɔ ra. Na tɛmui wo firin xa te. Sɛrɛxɛdubɛe nun ɲama naxa te de, xa na mu a ra, e faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Munsa naxa goro ɲama yire, a fa na masenyi ti e bɛ. ");
INSERT INTO sus_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Na tɛmui Alatala naxa yi masenyi ti: ");
INSERT INTO sus_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«N tan Alatala nan wo Marigi Ala ra, naxan wo ramini Misira konyiya kui.» ");
INSERT INTO sus_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Wo naxa ala gbɛtɛe batu bafe n tan na.» ");
INSERT INTO sus_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Wo naxa kuye yo yailan naxan misaalixi se nde ra, naxan toma koore nun bɔxi ma, xa na mu naxan luma ye nun bɔxi bun ma. ");
INSERT INTO sus_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Wo naxa wo mafelen na se mɔɔlie bɛ, wo naxa e batu, barima n tan wo Marigi Alatala, n mu wama n firin nde xɔn. Naxee n xɔnma, n nee bɔnsɔɛ ratɔnma nɛ han e tolontolonyie, xa na mu a ra e tolobitɛe xa die. ");
INSERT INTO sus_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kɔnɔ mixi naxee n xanuma, e bira n ma sɛriyɛ fɔxɔ ra, n hinnɛma e ra xanunteya kui abadan.» ");
INSERT INTO sus_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Wo naxa n xili yelefu, barima n tan Alatala mu diɲɛma mixie ma, naxee na fe mɔɔli rabama.» ");
INSERT INTO sus_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Wo xa ratu malabui lɔxɔɛ ma, wo xa a binya. ");
INSERT INTO sus_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Wo nɔma wali birin nabade xi senni bun ma, ");
INSERT INTO sus_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","kɔnɔ na xi solofere nde findima malabui lɔxɔɛ ra wo Marigi Alatala xa binyɛ bun ma. Wo naxa wali yo raba na lɔxɔɛ, wo tan, wo xa die, wo xa konyie, wo xa xurusee, nun wo xa xɔɲɛe. ");
INSERT INTO sus_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Alatala duniɲa nun se birin daa xi senni nan bun ma. A to gɛ na ra a naxa a malabu a xi solofere nde. Na nan a xɛɛxi, Alatala naxa barakɛ sa na malabui lɔxɔɛ ma, a findi lɔxɔɛ sɛniyɛnxi ra.» ");
INSERT INTO sus_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Wo xa wo baba nun wo nga binya. Na kui wo xa simaya xɔn kuyama nɛ bɔxi ma, wo Marigi Alatala naxan fima wo ma.» ");
INSERT INTO sus_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Wo naxa mixi faxa.» ");
INSERT INTO sus_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Wo naxa yɛnɛ raba.» ");
INSERT INTO sus_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Wo naxa muɲɛ ti.» ");
INSERT INTO sus_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Wo naxa wo boore tɔɔɲɛgɛ.» ");
INSERT INTO sus_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Wo naxa mila wo boore xa harige ma, alɔ a xa banxi, a xa ginɛ, a xa konyie, a xa ninge, xa na mu a xa sofale.» ");
INSERT INTO sus_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ɲama to na galanyi, seyamakɔnyi, nun tuuri to geya fari, e fa sara xui mɛ, e naxa sɛrɛn gaaxui ra. E naxa makuya mɛnni ra, ");
INSERT INTO sus_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","e fa a fala Munsa bɛ, «I tan xa wɔyɛn muxu ra, Alatala xui won faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Munsa naxa a fala ɲama bɛ, «Hali wo mu gaaxu. Ala na wo matofe, alako wo xa gaaxu a ya ra, wo xa yunubi lu na.» ");
INSERT INTO sus_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ɲama naxa lu yire makuye, kɔnɔ Munsa tan naxa siga na nuxui fɔɔrɔxi yire Alatala nu na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Alatala naxa a masen Munsa bɛ, «I xa yi masenyi ti Isirayilakae bɛ, ‹Wo bara a to, n bara wɔyɛn wo ra kelife koore ma. ");
INSERT INTO sus_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Wo naxa kuye yo yailan gbeti nun xɛɛma ra naxan luma n sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Wo xa sɛrɛxɛbade yailan n bɛ bɛndɛ ra. Wo xa xurusee ba sɛrɛxɛ gan daaxi nun xanunteya sɛrɛxɛ ra. Wo na n xili binya, n barakɛ sama nɛ wo ma. ");
INSERT INTO sus_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Xa wo sa sɛrɛxɛbade tima n bɛ gɛmɛ ra, wo naxa a ti gɛmɛ masolixie ra, barima na a niyama nɛ a xa findi se sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Wo naxa n ma sɛrɛxɛbade ite, xa na mu a ra sɛrɛxɛdubɛ xa donma kuye bunyi mabama nɛ.›» ");
INSERT INTO sus_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","I xa yi yaamarie masen Isirayilakae bɛ. ");
INSERT INTO sus_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Xa wo konyi sara naxan findi Isirayilaka ra, a xa wali wo bɛ ɲɛ senni, kɔnɔ a solofere nde wo xa a bɛɲin barima a xunsare bara ɲɔn. ");
INSERT INTO sus_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Xa a sa li wo nu bara na konyi nun a xa ginɛ sara, wo xa e firin birin bɛɲin ɲɛ solofere nde. ");
INSERT INTO sus_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Xa konyi kanyi nan ginɛ so a xa konyi yi ra, a fa di bari, na ginɛ nun a xa die luma konyi kanyi yi ra. Xɛmɛ gbansan nan bɛɲinma. ");
INSERT INTO sus_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Xa na konyi fa a fala, «N marigi, n ma ginɛ, nun n ma die rafan n ma, n mu wama xɔrɛyafe,» ");
INSERT INTO sus_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","a marigi xa a dɛntɛgɛ Ala bɛ. Na tɛmui a xa a tuli tunba sɔxɔmɛ ra naadɛ wuri ma. Na nan a masenma na konyi bara lu a marigi xa yaamari bun ma a xa duniɲɛigiri birin kui. ");
INSERT INTO sus_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Xɛmɛ na a xa di ginɛ mati konyi ra, ginɛ xɔrɛya ki mu luma alɔ xɛmɛ xɔrɛya ki. ");
INSERT INTO sus_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Xa na ginɛ mu rafan a marigi ma, naxan nu wama a findife a xa ginɛ ra, a lanma a xa lu a xun xa sara. A mu daxa a xa a mati mixi gbɛtɛ ma, barima a bara mɛɛ a ra. ");
INSERT INTO sus_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Xa a wama a fife a xa di ma ginɛ ra, a lanma a xa a suxu alɔ a xa di ginɛ yati. ");
INSERT INTO sus_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Xa a sa ginɛ gbɛtɛ tongo, a naxa sese ba a xa ginɛ singe xa donse, a xa sosee, nun a xa sɔlɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Xa a mu na fe saxanyie rakamali a bɛ, ginɛ nɔma kelide a xɔn ma, a mu sese fi. ");
INSERT INTO sus_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Naxan na mixi bɔnbɔ han a naxa faxa, na kanyi lan a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kɔnɔ xa a mu a faxafe ɲanigexi, Ala nan tun a ragirixi, a xa a xun taxu yire nde n dɛnnaxɛ masenma wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kɔnɔ xa a nu a faxafe ɲanigexi nɛ kɔɔta nde ra, na kanyi mu nɔma a xun taxude n ma sɛrɛxɛbade ra. Wo xa a faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Naxan na a nga, xa na mu a baba bɔnbɔ, na lan nɛ a xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Naxan na adamadi suxu, a xa a mati, na kanyi xa faxa hali a mu gɛxi na adamadi matide. ");
INSERT INTO sus_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Naxan na a nga, xa na mu a baba danka, na kanyi lan nɛ a xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Naxan na mixi maxɔnɔ gere kui, na kanyi mu suxuma xa mixi maxɔnɔxi mu faxaxi, ");
INSERT INTO sus_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","xa a nɔma kelide a xa sade ma, a ɲɛrɛ a xa yisuxuwuri ra. Kɔnɔ maxɔnɛ ti tan lanma a xa kɔbiri ba na mixi maxɔnɔxi bɛ han a gɛma yalande tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Naxan na a xa konyi faxa bɔnbɔ wuri ra, a lanma nɛ na kanyi xa ɲaxankata. ");
INSERT INTO sus_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kɔnɔ xa na konyi sa yalan beenu xi firin, a mu lanma konyi kanyi xa ɲaxankata, barima na konyi findixi a gbe nan na. ");
INSERT INTO sus_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Mixi naxee bɔnbɔma furi ginɛ nde ra, e xa gere kui, na fa a niya ginɛ xa di bari a waxati mu a lixi, kɔnɔ a mu fe kana a ma, na geresoee xa kɔbiri nde ba ginɛ bɛ. Ginɛ xa mɔri nun kiitisa xa natɛ tongo kɔbiri xasabi naxan bama. ");
INSERT INTO sus_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kɔnɔ xa a sa findi gbaloe ra, nii ɲɔxɔɛ na nii nan na, ");
INSERT INTO sus_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ya ɲɔxɔɛ na ya nan na, ɲinyi ɲɔxɔɛ na ɲinyi nan na, bɛlɛxɛ ɲɔxɔɛ na bɛlɛxɛ nan na, sanyi ɲɔxɔɛ na sanyi nan na, ");
INSERT INTO sus_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ganyi ɲɔxɔɛ na ganyi nan na, xabɛ ɲɔxɔɛ na xabɛ nan na, maxɔnɛ ɲɔxɔɛ na maxɔnɛ nan na. ");
INSERT INTO sus_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Naxan na a xa konyi bɔnbɔ han a ya naxa kana, a lanma a xa a xa konyi xɔrɛya a xa ya kanɛ ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Naxan na a xa konyi ɲinyi gira, na kanyi lanma a xa a xa konyi xɔrɛya a xa ɲinyi girɛ ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Tuura naxan na mixi faxa, a lanma na tuura xa magɔnɔ han a faxa. A sube naxa don. Tuura kanyi mu ɲaxankatɛ yo sɔtɔma na kui. ");
INSERT INTO sus_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kɔnɔ xa na tuura darixi na mɔɔli raba ra, a kanyi a kolon kɔnɔ a mu a xirima a fanyi ra, na kanyi yo, a xa tuura yo, e birin xa magɔnɔ han e xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kiitisa nɔma natɛ tongode na tuura kanyi xun sarama naxan na. ");
INSERT INTO sus_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Na sɛriyɛ keren nan nawalima hali tuura sa dimɛdi nan faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Xa a sa li tuura fa mixi gbɛtɛ xa konyi nde faxa, gbeti kole tongo saxan nan fima na konyi marigi ma. Na tuura xa magɔnɔ han a faxa. ");
INSERT INTO sus_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Naxan na yili ge, a lu i mu a dɛ rakotoma, xa a sa li ninge xa na mu a ra sofale nde sa sin na yili kui, ");
INSERT INTO sus_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","a lanma na kanyi xa na xuruse sare fi, xuruse faxaxi xa lu a bɛ. ");
INSERT INTO sus_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Naxan ma tuura na sa a boore gbe faxa, na tuura baloxi xa mati, na sare nun na tuura faxaxi xa itaxun e boore tagi. ");
INSERT INTO sus_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kɔnɔ xa a sa a li, na tuura darixi na mɔɔli raba ra, a kanyi a kolon kɔnɔ a mu a xirima a fanyi ra, a lanma tuura baloxi kanyi xa a gbe fi tuura faxaxi kanyi ma, tuura faxaxi xa lu a tan bɛ. ");
INSERT INTO sus_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Naxan na tuura xa na mu a ra yɛxɛɛ muɲa, a sa a mati, xa na mu a ra, a faxa, a lanma na kanyi xa tuura suuli ragbilen na tuura keren ɲɔxɔɛ ra, xa na mu, yɛxɛɛ naani na yɛxɛɛ keren ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Xa wo mixi suxu a muɲɛ tife kɔɛ ra, a fa faxa wo yi bɔnbɔɛ ra, faxɛ kote mu dɔxɔma wo xun ma. ");
INSERT INTO sus_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kɔnɔ xa wo na mɔɔli raba yanyi ra, faxɛ kote dɔxɔma nɛ wo xun ma. Muɲɛti lanma a xa se muɲaxie sare ragbilen, kɔnɔ xa a mu nɔma na ra, a gundi xa mati konyi ra alako muɲɛ se sare xa fi. ");
INSERT INTO sus_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Xa a sa li, na se muɲaxi na a yi alɔ ninge, sofale, yɛxɛɛ, xa na mu a ra, a ɲiɲɛ ra, a e ɲɔndɔn firin nan fima a ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Naxan na a xa xurusee bɛɲin, a sa a boore xa xɛ kana, na kanyi lanma a xa a sare fi a xa xɛ bogi fanyi nan na. ");
INSERT INTO sus_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Naxan na tɛ sa ɲooge ganfe ra, kɔnɔ tɛ fa mixi nde xa sansi malanxi gan, xa na mu a xa xɛ, na kanyi lanma a xa na se birin sare fi. ");
INSERT INTO sus_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Xa mixi harige nde taxu a dɔxɔboore ra, kɔnɔ mixi fa na muɲa, na muɲɛti xa na se sare firin nagbilen a ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kɔnɔ xa na muɲɛti mu to, se taxuxi naxan na, na xa a kali Ala xili ra kiitisamae yire, alako e xa a kolon a tan xa mu na harige tongoxi. ");
INSERT INTO sus_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Xa se nde sa lu mixi yi ra alɔ ninge, sofale, yɛxɛɛ, dugi, xa na mu a ra se gbɛtɛ, kɔnɔ mixi gbɛtɛ fa a fala a tan nan gbe na a ra, e lanma e xa siga kiitisae yire. Kiiti kanama naxan na, a xa na se sare dɔxɔ firin nagbilen a boore ma. ");
INSERT INTO sus_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Xa mixi nde xuruse taxu a boore ra, alɔ sofale, ninge, xa na mu yɛxɛɛ, na xuruse fa faxa, xa na mu a salonse nde fa gira, xa na mu mixi fa a muɲa, ");
INSERT INTO sus_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","a boore xa a kali Alatala ra a mu a yi. Se kanyi xa la na ra, a xa diɲɛ na se lɔɛxi ma. ");
INSERT INTO sus_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kɔnɔ xa na xuruse muɲaxi na a xɔnyi nɛ, a ɲɔxɔɛ fima nɛ. ");
INSERT INTO sus_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Xa wulai sube nde nan fa a faxa, a taxu naxan na, na xa a binbi masen xuruse kanyi bɛ seedeɲɔxɔya ra. Na tɛmui, a mu na ɲɔxɔɛ fima. ");
INSERT INTO sus_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Xa mixi xuruse yefu a boore ma, xuruse fa a yɛtɛ maxɔnɔ, xa na mu a ra a faxa xuruse kanyi xanbi, a yefuma xa a ɲɔxɔɛ fi. ");
INSERT INTO sus_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kɔnɔ xa fe nde na xuruse sɔtɔ a kanyi ya xɔri, a yefuma mu a ɲɔxɔɛ fima. Xa a sa li, a hɛrixi nan a ra, hɛri masundi nan findima a ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Naxan na ginɛ dimɛdi futi kana naxan xa kote mu dɔxɔxi sinden, a lanma a xa a xa kote dɔxɔ alako a xa findi a xa ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Xa na ginɛ baba mu tin a fide a ma, na futikanɛ kɔbiri nan fima naxan lanma ginɛ dimɛdi xa kote ma. ");
INSERT INTO sus_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mandurula ginɛ lanma nɛ a xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Naxan yo yɛnɛ raba xuruse ra, a lanma a xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Naxan yo na sɛrɛxɛ ba ala gbɛtɛ bɛ, bafe Alatala ra, na kanyi lan nɛ a xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wo naxa xɔɲɛ tɔɔrɔ naxan fatan si gbɛtɛ ra a sabati wo xɔnyi, barima wo fan nu na xɔɲɛya nɛ Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Wo naxa fu kaaɲɛ ginɛ nun kiridi ma. ");
INSERT INTO sus_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Wo na fu nee ma, n e wa xui mɛma nɛ. ");
INSERT INTO sus_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","N ma xɔnɛ tema nɛ wo xili ma, n wo faxa santidɛgɛma ra. Wo xa ginɛe findima nɛ kaaɲɛ ginɛe ra, wo xa die fan findima nɛ kiridie ra. ");
INSERT INTO sus_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Xa wo sa kɔbiri doni tɔɔrɔmixi nde bɛ n ma ɲama ya ma, wo naxa geeni yo fen a xun na alɔ doniti ɲaaxi ndee. ");
INSERT INTO sus_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Wo na wo boore xa dugi dɔxɔ sɛɛkɛ ra, wo xa a ragbilen a ma beenun soge xa dula, ");
INSERT INTO sus_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","barima na keren peti nan a yi ra, a na nan felenma a ma. A na n xili, n a xui suxuma nɛ, barima kinikininte nan n na. ");
INSERT INTO sus_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Wo naxa n tan Ala bɛxu. Wo naxa wo xa ɲama mangɛ danka. ");
INSERT INTO sus_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Wo naxa dugundi n kide wo xa xɛ bogie ra. Wo xa wo xa di singe birin fi n ma. ");
INSERT INTO sus_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Wo xa wo xa xurusee xa di singee fi n ma. Wo xa e lu e nga fɔxɔ ra xi solofere. A xi solomasaxan nde, wo fa e fi n ma. ");
INSERT INTO sus_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Wo xa findi n ma ɲama sɛniyɛnxi ra. Wo naxa wulai sube don, sube gbɛtɛ naxan faxaxi. Wo xa na mɔɔli fi baree ma. ");
INSERT INTO sus_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Wo naxa mixi tɔɔɲɛgɛ, wo naxa wule seede ba mixi ɲaaxi bɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Wo naxa bira ɲama waxɔnfe ɲaaxi fɔxɔ ra, wo naxa wule seede ba ɲama xa fe ra. Na mɔɔli tinxinyi kanama nɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Wo naxa mixi rafisa a boore bɛ kiiti kui, hali a findi misikiinɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wo na wo yaxui xa ninge lɔɛxi to, xa na mu a xa sofale, wo xa a xanin a xɔn ma. ");
INSERT INTO sus_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wo na wo yaxui xa sofale to, a biraxi kote xungbe bun ma, wo naxa a lu naa. Wo xa a mali. ");
INSERT INTO sus_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Wo naxa sɛriyɛ matandi tɔɔrɔmixi makiitima tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Wo naxa mixi tɔɔɲɛgɛ. Wo naxa a niya mixi tɔɔɲɛgɛxi xa faxa, barima n mu diɲɛma na mixi mɔɔli ma. ");
INSERT INTO sus_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Wo naxa tinxinyi kana kɔbiri ra, barima na a niyama nɛ seede xa dundu, tinxintɔɛ xa wɔyɛnyi xa mafindi. ");
INSERT INTO sus_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Wo naxa xɔɲɛ tɔɔrɔ naxan fatan si gbɛtɛ ra. Wo tan yati bara na tɔɔrɛ mɔɔli kolon wo nu na Misira bɔxi ma tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Wo xa sansi si, wo xa a xaba ɲɛ senni bun ma, ");
INSERT INTO sus_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","kɔnɔ a ɲɛ solofere nde, wo xa bɔxi lu na, a xa a malabu. Na tɛmui sansi naxan fama bulade a yɛtɛ ma, na nɔma findide Isirayila tɔɔrɔmixie xa baloe ra. Burunyi subee fan xa balo na dɔnxɔɛ ra. Wo xa na raba wo xa wɛni nun wo xa oliwi bilie fan na. ");
INSERT INTO sus_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Wo xa wali birin naba xi senni bun ma, kɔnɔ a xi solofere nde wo naxa wali yo raba alako wo xa ninge, wo xa sofale, wo xa konyi, nun si gbɛtɛ mixi naxee na wo xɔnyi, e birin xa e malabu. ");
INSERT INTO sus_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Wo xa wo ɲɔxɔ sa n ma yaamari birin xɔn ma. Wo naxa ala gbɛtɛe batu, e xili ɲan naxa mini wo dɛ i. ");
INSERT INTO sus_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ɲɛ yo ɲɛ wo xa sali saxan naba n ma binyɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Wo xa Taami Lɛbinitare Sali raba yi ki. Xi solofere naxee sugandixi Abibi kike kui, wo xa taami lɛbinitare gbansan don, alɔ n wo yamarixi ki naxɛ. Wo xa a raba na tɛmui nɛ barima wo mini Misira bɔxi kui na kike nan na. Wo naxa n kuma na salie kui. ");
INSERT INTO sus_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Xɛ Xabɛ Sali, wo xa a raba wo xa sansi bogi singee ra. Sansi Bogi Ba Sali, wo xa a raba ɲɛ raɲɔnyi, wo na sansi bogi se raso tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Xɛmɛ birin xa na sali saxan naba e Marigi Alatala xa binyɛ bun ma ɲɛ birin kui. ");
INSERT INTO sus_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Wo na xuruse ba sɛrɛxɛ ra n bɛ tɛmui naxɛ, wo naxa taami lɛbini daaxi ba sɛrɛxɛ ra a sɛɛti ma de. Wo naxa n ma sali sɛrɛxɛ sube ture ragata han gɛɛsɛgɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Wo xa sansi bogi fisamante ba wo xa sansi bogi singee ya ma n tan wo Marigi Alatala bɛ, wo e xanin n ma hɔrɔmɔlingira kui. Wo naxa si ɲin a nga xiɲɛ ye ra. ");
INSERT INTO sus_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","N malekɛ tima nɛ wo ya ra, naxan wo makantama kira ra sigafe ra bɔxi ma n dɛnnaxɛ yailanxi wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Wo xa wo tuli mati a ra, wo xa a xui suxu. Wo naxa a matandi. A mu diɲɛma wo xa matandi ma, barima n xili na a xun ma. ");
INSERT INTO sus_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kɔnɔ xa wo wo tuli mati a ra, xa wo a xui birin suxu, n findima nɛ wo yaxuie yaxui ra, wo gerefae gerema ra. ");
INSERT INTO sus_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","N ma malekɛ wo matima Amorikae, Xitikae, Perisikae, Kanaankae, Hiwikae, nun Yebusukae xɔnyi. N fama nɛ e birin sɔntɔde. ");
INSERT INTO sus_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Wo naxa suyidi e xa alae bɛ, wo naxa e batu, wo naxa bira e fɔxɔ ra. Wo xa e xa kuyee kana, wo xa e xa gɛmɛ masolixie magira. ");
INSERT INTO sus_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Wo xa wo Marigi Alatala batu. A barakɛ sama nɛ wo xa taami nun wo xa ye ma. A wo xa fure yalanma nɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ginɛ furi mu kanama wo xa bɔxi ma, ginɛ di baritare fan mu toma wo ya ma. N simaya kamalixi fima nɛ wo ma. ");
INSERT INTO sus_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","N sie ragaaxuma nɛ wo ya ra n sɛnbɛ ra. N e ifuma nɛ alako e xa e gi wo ya ra. ");
INSERT INTO sus_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","N ɲurie rasanbama nɛ wo ya ra naxan Hiwikae, Kanaankae, nun Xitikae kerima. ");
INSERT INTO sus_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kɔnɔ n mu na rabama ɲɛ keren kui, alako bɔxi naxa fa kana, wulai subee naxa fa wuya wo xili ma. ");
INSERT INTO sus_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","N nee kerima a xuri xuri nan na wo ya ra, han wo wuya, wo fa nɔɛ sɔtɔ bɔxi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","N wo xa naaninyi igboma nɛ keli Xulunyumi Baa ma han Baa Xungbe, kelife Turusinina gbengberenyi ma han a sa dɔxɔ Efirati xure xungbe ra. N mɛnnikae sama nɛ wo sago, alako wo xa e keri. ");
INSERT INTO sus_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Wo naxa saatɛ yo tongo mɛnnikae nun e xa alae bɛ. ");
INSERT INTO sus_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Wo naxa lu e xa sabati wo xa bɔxi ma, xa na mu a ra e a niyama nɛ wo xa gbilen n fɔxɔ ra. E xa alae findima gantanyi nan na wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Alatala naxa a masen Munsa bɛ, «Te n yire be geya fari, i tan, Haruna, Nadabo, Abihu, nun Isirayila forie mixi tongo solofere. Wo xa suyidi yire naxan makuya n na. ");
INSERT INTO sus_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Munsa, i gbansan xa makɔrɛ n na, booree xa lu yire makuye. Ɲama fan naxa te i tan Munsa fɔxɔ ra.» ");
INSERT INTO sus_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Munsa naxa Alatala xa masenyi nun a xa yaamari birin nadangi ɲama ma. Ɲama birin naxa a yaabi xui keren na, «Muxu Alatala xui birin suxuma nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Munsa naxa Alatala xa masenyi birin sɛbɛ. Na kuye iba, Munsa naxa sɛrɛxɛbade ti geya bunyi, a naxa gɛmɛ tundenyi fu nun firin ti mɛnni, naxee Isirayila bɔnsɔɛ fu nun firinyi misaalixi. ");
INSERT INTO sus_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A naxa Isirayila fonike ndee xɛɛ e xa sɛrɛxɛ gan daaxie ba. E man xa tuurae ba Ala bɛ xanunteya sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Munsa naxa na wuli tagi sa fɛɲɛ die kui, a naxa na dɔnxɔɛ kasan sɛrɛxɛbade ma. ");
INSERT INTO sus_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","A naxa saatɛ kitaabui tongo, a a xaran ɲama birin bɛ. E naxa a yaabi, «Muxu Alatala xui birin suxuma nɛ. Muxu a ratinmɛma nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Munsa naxa na wuli tongo, a a kasan ɲama ma. A naxa a masen, «Saatɛ wuli nan ya. Alatala yi saatɛ nan tongoxi wo bɛ a xa masenyi fari.» ");
INSERT INTO sus_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Munsa naxa te, a tan nun Haruna, Nadabo, Abihu, nun Isirayila forie, mixi tongo solofere. ");
INSERT INTO sus_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","E naxa Isirayila Marigi Ala to. A nu tixi gɛmɛ nɔrɔxi fari. ");
INSERT INTO sus_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Na Isirayila kuntigie naxa Ala to, kɔnɔ a mu e ɲaxankata na ma. E birin naxa e dɛge, e naxa e min. ");
INSERT INTO sus_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Alatala naxa a masen Munsa bɛ, «Te geya fari n yire, i xa fa lu be sinden. N xa gɛmɛ walaxɛe so i yi ra, n nan n ma sɛriyɛ nun n ma yaamarie sɛbɛxi naxee ma. I xa Isirayilakae xaran nee ra.» ");
INSERT INTO sus_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Munsa nun a malima Yosuwe naxa te Ala xa geya ma. ");
INSERT INTO sus_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Munsa naxa a fala forie bɛ, «Wo xa muxu mɛmɛ be. Muxu fafe. Haruna nun Xuru xa lu wo fɛ ma be. Xa fe nde bira a i wo tagi, wo xa a masen e bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Munsa to te geya fari, nuxui naxa dusu a xun na. ");
INSERT INTO sus_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Alatala xa nɔrɛ naxa lu Turusinina geya xun na. Nuxui naxa geya makoto xi senni. A xi solofere nde, Alatala naxa Munsa xili na nuxui kui. ");
INSERT INTO sus_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Alatala xa nɔrɛ nu luxi nɛ Isirayilakae bɛ, alɔ tɛ xungbe geya fari. ");
INSERT INTO sus_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Munsa to nu tema, a naxa so na nuxui kui, a naxa lu geya fari xi tongo naani kɔɛ nun yanyi. ");
INSERT INTO sus_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«A fala Isirayilakae bɛ, foniserelae xa yi see mɔɔli ba hadiya ra: ");
INSERT INTO sus_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","xɛɛma, gbeti, wure gbeeli, ");
INSERT INTO sus_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, gɛsɛ gbeeli, suwa dugi, dugi naxan sɔxɔxi si xabe ra, ");
INSERT INTO sus_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","yɛxɛɛ kontonyi kiri naxee soxi a gbeeli ra, peremui kirie, kasiya wuri, ");
INSERT INTO sus_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ture naxan sama lanpui kui, labundɛ naxan sama ture sɛniyɛnxi nun surayi xun ma, ");
INSERT INTO sus_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","a nun gɛmɛ tofanyi naxee findi sɛrɛxɛdubɛ xa donma kuye nun donma kanke raxunma se ra. ");
INSERT INTO sus_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Isirayilakae xa hɔrɔmɔlingira ti n bɛ, alako n xa sabati e ya ma. ");
INSERT INTO sus_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Wo xa na lingira nun a xa yirabase birin yailan alɔ n na masenma i bɛ ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«E xa saatɛ kankira yailan kasiya wuri ra. Na kankira xa kuya nɔngɔn firin nun a tagi, a xa igbo nɔngɔn keren nun a tagi, a xa ite nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","I xa a kui nun a fari maso xɛɛma ra. A dɛ kiri fan xa yailan xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","I xa a suxude digilinxi naani rafala xɛɛma ra a tunxun naanie ma, firin na sɛɛti, firin na boore sɛɛti ma.» ");
INSERT INTO sus_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","«I xa kasiya wuri kuye firin masoli, e maso xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I xa e raso kankira suxude digilinxie kui, na kankira xaninma e tan nan ma. ");
INSERT INTO sus_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","E naxa ramini na abadan.» ");
INSERT INTO sus_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","«N na saatɛ tɔnxuma so i yi ra, i xa a sa na kankira kui. ");
INSERT INTO sus_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","I xa a dɛrakote yailan xɛɛma fanyi ra, naxan findima xunsare yire ra. A xa kuya nɔngɔn firin nun a tagi, a xa igbo nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Malekɛ sawurɛ firin xa yailan xɛɛma xabuxi ra kankira dɛrakote fari. ");
INSERT INTO sus_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Malekɛe sawurɛ nun kankira dɛrakote xa findi keren na. ");
INSERT INTO sus_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Na malekɛ sawurɛ firinyie xa ti e boore ya i, e gabutenyie italaxi, e xun sinxi xunsare yire.» ");
INSERT INTO sus_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","«I xa na kankira dɛrakote sa a ma, naxan findixi xunsare yire ra. N na saatɛ tɔnxuma so i yi ra, i xa a sa na kankira kui. ");
INSERT INTO sus_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","N nan n yɛtɛ masenma i bɛ mɛnni nɛ, na saatɛ kankira dɛrakote fari, malekɛ sawurɛ firinyie tagi. N yaamari birin soma i yi ra mɛnni nɛ katarabi Isirayilakae ma.» ");
INSERT INTO sus_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«I xa teebili nde yailan kasiya wuri ra, naxan kuya nɔngɔn firin, a igbo nɔngɔn keren, a ite nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","I xa xɛɛma fanyi maso a ma, a nun a dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Xebenyi nde xa sa na dɛ kiri bun ma naxan igbo suxui keren a nun a tagi. Xɛɛma xa sa na fan dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","I xa a suxude digilinxi naani rafala xɛɛma ra a tunxun naanie ma, naxee ilanma a sanyie ra ");
INSERT INTO sus_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","na xebenyi bun ma. Wuri kuyɛe xa so nee kui teebili xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Na wuri kuyee xa masoli kasiya wuri ra, xɛɛma xa maso e ma. Nee nan findima teebili tongose ra. ");
INSERT INTO sus_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Piletie, tɔnbilie, pɔɔtie, nun paani naxee sama na teebili ma, naxee rawalima sɛrɛxɛ yeerama daaxi xa fe ra, nee birin xa yailan xɛɛma fanyi nan na. ");
INSERT INTO sus_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Taami fan xa sa na teebili ma tɛmui birin, naxan findixi sɛrɛxɛ ra n bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«I xa lanpui dɔxɔse nde yailan xɛɛma fanyi xabuxi ra. A sanyi, a bili, a salonyie, nun lanpui dɔxɔde naxee maniya sansi fugee ra, na birin xa findi keren na. ");
INSERT INTO sus_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Salon senni xa mini lanpui dɔxɔse bili ma, saxan sɛɛti keren, saxan boore sɛɛti. ");
INSERT INTO sus_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tɔnbili saxan xa lu na salon senni birin xun ma. E xa maniya sansi bogi ra naxan dɔxɔxi a burɛxɛe nun a fugee tagi. ");
INSERT INTO sus_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tɔnbili naani gbɛtɛ xa lu lanpui bili ma. E fan xa maniya sansi bogi ra naxan dɔxɔxi a burɛxɛe nun a fugee tagi. ");
INSERT INTO sus_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Na salon firin firin dɔxɔ saxanyie bun ma naxee kelixi a bili ma, a sama nɛ mɛnni fan ma. ");
INSERT INTO sus_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Na tɔnbilie nun lanpui salonyie xa findi keren na, e xa yailan xɛɛma fanyi xabuxi ra.» ");
INSERT INTO sus_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«I xa lanpui solofere yailan, i xa e dɔxɔ e dɔxɔdee ma alako e dɛxɛ xa yare iyalan. ");
INSERT INTO sus_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","I xa wuki xabase nun xube sase yailan xɛɛma fanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Xɛɛma naxan nawalima lanpui dɔxɔse nun lanpui yirabase yailanfe ra, na xa findi xɛɛma kilo tongo saxan nun naani nan na. ");
INSERT INTO sus_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","I xa na birin naba alɔ n a masenxi i bɛ ki naxɛ geya fari.» ");
INSERT INTO sus_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«I xa Ala xa hɔrɔmɔlingira yailan suwa dugi fu ra, naxee raxunmaxi gɛsɛ mɔɔli saxan na, gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, nun gɛsɛ gbeeli. Na gɛsɛ xa malekɛe sawurɛ ramini dugie ma. A xa tofan ki fanyi. ");
INSERT INTO sus_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dugi birin xa kuya nɔngɔn mɔxɔɲɛn nun solomasaxan, a xa igbo nɔngɔn naani. E kuyɛ nun e igboya xa lan. ");
INSERT INTO sus_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Dugi suuli xa dɛgɛ e boore ra, dugi suuli gbɛtɛ fan xa dɛgɛ e boore ra. Na kui na dugi fu bara findi dugi firin na. ");
INSERT INTO sus_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I xa gɛsɛ gɛrɛ daaxi dɛgɛ na dugi singe dɛ kiri ma, a nun na dugi firin nde dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","I xa gɛsɛ tongo suuli dɛgɛ na firinyi dɛ kiri ma alako e birin xa lan e boore ma. ");
INSERT INTO sus_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Na dangi xanbi i xa suxuse tongo suuli yailan xɛɛma ra, i fa na dugi firinyie ralan e boore ra na suxusee ra. Na nan a niyama hɔrɔmɔlingira xa findi dugi keren na.» ");
INSERT INTO sus_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«I xa dugi fu nun keren sɔxɔ si xabe ra, naxee Ala xa hɔrɔmɔlingira makotoma. ");
INSERT INTO sus_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dugi keren xa kuya nɔngɔn tongo saxan, a xa igbo nɔngɔn naani. Na dugi fu nun kerenyi birin xa lan. ");
INSERT INTO sus_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","I xa dugi suuli dɛgɛ e boore ra, e xa findi dugi keren na. Na dugi senni naxee luxi, i xa e fan dɛgɛ e boore ra. Na dugi senni nde singanma banxi yatagi nan xun ma. ");
INSERT INTO sus_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","I xa gɛsɛ tongo suuli dɛgɛ na dugi singe ra, a nun na dugi firin nde ra. ");
INSERT INTO sus_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Na dangi xanbi i xa suxuse tongo suuli yailan wure gbeeli ra, i fa na dugi firinyie ralan e boore ra na suxusee ra. Na nan a niyama na birin xa findi dugi keren na naxan Ala xa hɔrɔmɔlingira makotoma. ");
INSERT INTO sus_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Na dugi xa mayigboe kɛɲa ma dɔnxɔɛ tagi singanma hɔrɔmɔlingira nan xanbi ra. ");
INSERT INTO sus_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Na dugi xa kuyɛ kɛɲa na ki naxɛ, nɔngɔn keren nan luma na sɛɛti firinyie ma, alako hɔrɔmɔlingira xa makoto.» ");
INSERT INTO sus_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Na dangi xanbi i xa makotose gbɛtɛ yailan yɛxɛɛ kontonyi kiri ra, naxan soxi a gbeeli ra. I man xa makotose gbɛtɛ yailan peremui kiri ra.» ");
INSERT INTO sus_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«I xa kasiya wuri xaba xebenyie ra hɔrɔmɔlingira tima naxee ma. ");
INSERT INTO sus_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kankan xa kuya nɔngɔn fu, a xa igbo nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Suxuse firin xa lu hɔrɔmɔlingira xebenyi birin ma e kafuma e boore ma naxee ra. ");
INSERT INTO sus_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xebenyi mɔxɔɲɛn nan tima hɔrɔmɔlingira yirefanyi ma. ");
INSERT INTO sus_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Sanbunyi gbeti daaxi tongo naani nan sama na xebenyi mɔxɔɲɛn bun ma, xebenyi keren, sanbunyi firin. E xa lu xebenyi suxusee fɛ ma. ");
INSERT INTO sus_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Xebenyi mɔxɔɲɛn nan tima hɔrɔmɔlingira kɔɔla fan ma, ");
INSERT INTO sus_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","a nun e sanbunyi gbeti daaxi tongo naani, xebenyi keren, sanbunyi firin. ");
INSERT INTO sus_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Xebenyi senni nan tima hɔrɔmɔlingira xanbi ra sogegorode mabiri. ");
INSERT INTO sus_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","I xa xebenyi firin yailan tuxuie bɛ hɔrɔmɔlingira xanbi ra, ");
INSERT INTO sus_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","naxee fuge nun lanbanyi lanma e boore ma, e xiri fuge ra se digilinxi ra. Na tuxui firinyi xa yailan na ki. ");
INSERT INTO sus_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Na birin lanma xebenyi solomasaxan nan ma, a nun e sanbunyi gbeti daaxi fu nun senni, xebenyi keren, sanbunyi firin.» ");
INSERT INTO sus_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«I xa wuri suuli yailan kasiya wuri ra, hɔrɔmɔlingira xebenyie tima naxee ma. Suuli rawali sɛɛti keren ma, ");
INSERT INTO sus_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","suuli rawali boore sɛɛti ma, suuli rawalima hɔrɔmɔlingira xanbi ra sogegorode mabiri. ");
INSERT INTO sus_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Wuri naxan luma a tagi, na dangima xebenyie nan xun ma, a keli sɛɛti singe a sa dɔxɔ boore ra. ");
INSERT INTO sus_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Na xebenyie, nun na wurie, nun se digilinxie wuri soma naxee kui, i xa xɛɛma maso na birin ma. ");
INSERT INTO sus_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","I xa na hɔrɔmɔlingira ti alɔ n i yamarixi ki naxɛ geya fari.» ");
INSERT INTO sus_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«I xa suwa dugi yailan gɛsɛ gbeeli nun gɛsɛ bulu daaxi ra. Malekɛ sawurɛe xa dɛgɛ na ma, a xa tofan ki fanyi. ");
INSERT INTO sus_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I xa a gbaku kasiya wuri naani ra xɛɛma masoxi naxee ma, e tixi gbeti sanbunyie ma. Suxuse naxee dugi xirima wurie ma, xɛɛma xa maso nee fan ma. ");
INSERT INTO sus_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","I na gɛ dugi gbakude na suxusee ra, i xa saatɛ kankira dɔxɔ a xanbi ra. Na ki, na dugi luma na yire firin tagi ra, naxan xili yire sɛniyɛnxi a nun naxan xili yire sɛniyɛnxi fisamante. ");
INSERT INTO sus_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","I xa saatɛ kankira dɛ rakoto a dɛrakote ra yire sɛniyɛnxi fisamante kui. Na dɛrakote se findixi xunsare yire nan na. ");
INSERT INTO sus_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I xa teebili tan dɔxɔ hɔrɔmɔlingira kɔɔla ma, lanpui dɔxɔse xa lu a ya ra yirefanyi ma.» ");
INSERT INTO sus_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«I xa suwa dugi gbɛtɛ yailan gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, nun gɛsɛ gbeeli ra hɔrɔmɔlingira sode. I xa a masɔxɔ a fanyi ra, a xa tofan. ");
INSERT INTO sus_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","I xa a gbaku wuri suuli ma naxee yailanxi kasiya wuri ra, xɛɛma masoxi naxee ma, e tixi gbeti sanbunyie ma. Suxuse naxee dugi xirima wurie ma, nee yailanxi wure gbeeli ra.» ");
INSERT INTO sus_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«I xa sɛrɛxɛbade yailan kasiya wuri ra, naxan kuya nɔngɔn suuli, a igbo nɔngɔn suuli, a ite nɔngɔn saxan. ");
INSERT INTO sus_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","I xa feri naani yailan a tuxui birin ma, naxee findixi se keren na sɛrɛxɛbade ra. I xa wure gbeeli maso na birin ma. ");
INSERT INTO sus_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","I xa a yirabase birin yailan wure gbeeli ra, alɔ xube sasee, pelie, pɔɔtie, sube sɔxɔsee, nun tundee tɛ sama naxee kui. ");
INSERT INTO sus_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","I xa se nde yailan wure gbeeli ra naxan sama tɛ xun ma, sube sama naxan fari. I xa suxuse digilinxie wure gbeeli daaxi sa a tuxui ma, ");
INSERT INTO sus_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","alako a xa gbaku sɛrɛxɛbade kui a tagi. ");
INSERT INTO sus_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","I xa wuri kuyee yailan kasiya wuri ra wure gbeeli masoxi e ma. ");
INSERT INTO sus_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","E rasoma suxuse digilinxi naanie nan kui sɛrɛxɛbade sɛɛti firinyie ma a xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","I xa na sɛrɛxɛbade yailan xebenyie nan na. Sese naxa lu a kui. I xa a yailan alɔ n i yamarixi ki naxɛ geya fari.» ");
INSERT INTO sus_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«I xa hɔrɔmɔlingira tɛtɛ yailan yi ki nɛ: Tɛtɛ xa kuya nɔngɔn kɛmɛ yirefanyi mabiri ra. I xa gɛrɛ suwa dugi gbaku na ");
INSERT INTO sus_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","wuri mɔxɔɲɛn ma, naxee tixi sanbunyi wure gbeeli daaxie ma. Na dugi suxusee xa yailan gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tɛtɛ xa kuya nɔngɔn kɛmɛ kɔɔla fan mabiri ra. I xa gɛrɛ dugi gbaku na wuri mɔxɔɲɛn ma, naxee tixi sanbunyi wure gbeeli daaxie ma. Na dugi suxusee xa yailan gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Tɛtɛ xa igbo nɔngɔn tongo suuli sogegorode mabiri ra. I xa gɛrɛ dugi gbaku na wuri fu ma, naxee tixi sanbunyi wure gbeeli daaxie ma. ");
INSERT INTO sus_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Tɛtɛ xa igbo nɔngɔn tongo suuli sogetede fan mabiri ra. ");
INSERT INTO sus_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Gɛrɛ dugi xa gbaku sɛɛti ma wuri saxan ma, naxee tixi sanbunyi ma. Na xa kuya nɔngɔn fu nun suuli. ");
INSERT INTO sus_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Gɛrɛ dugi gbɛtɛ xa gbaku boore sɛɛti ma wuri saxan ma, naxee tixi sanbunyi ma. Na fan xa kuya nɔngɔn fu nun suuli. ");
INSERT INTO sus_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Tɛtɛ sode dɛ xa yailan suwa dugi ra naxan masɔxɔxi gɛsɛ gɛrɛ daaxi nun gɛsɛ bulu daaxi nun gɛsɛ gbeeli ra. Na dugi xa nɔngɔn xa mɔxɔɲɛn sɔtɔ. Na xa gbaku wuri naani ma, naxee tixi sanbunyi ma. ");
INSERT INTO sus_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Wuri naxee tixi tɛtɛ ma, e tixi e sanbunyi wure gbeeli daaxie ma. Dugi suxusee fan na e ma naxee yailanxi gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Na hɔrɔmɔlingira tɛtɛ kuyɛya lanma nɔngɔn kɛmɛ nan ma, a igboya nɔngɔn tongo suuli. Suwa dugi naxee gbakuxi na, e ite nɔngɔn suuli. Tɛtɛ wuri sanbunyie, ");
INSERT INTO sus_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","hɔrɔmɔlingira yirabase birin, nun tɛtɛ luuti xirima se naxee ma, na birin yailanma wure gbeeli nan na.» ");
INSERT INTO sus_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«I xa Isirayilakae yaamari, e xa fa oliwi ture fanyi ra i xɔn ma, alako hɔrɔmɔlingira lanpuie xa dɛxɛ tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haruna nun a xa die xa na lanpuie radɛxɛ, naxee na hɔrɔmɔlingira kui, n i lima dɛnnaxɛ, yire sɛniyɛnxi fisamante ya ra, dugi gbakuxi dɛnnaxɛ saatɛ kankira ya ra. Na lanpuie xa yanba Alatala ya xɔri kelife kɔɛ han gɛɛsɛgɛ. Sɛriyɛ nan na ki Isirayila bɔnsɔɛ birin bɛ naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«I xa i taara Haruna tongo Isirayilakae ya ma, a nun a xa die Nadabo, Abihu, Eleyasari, nun Itamari, e xa sɛrɛxɛdubɛ wali raba n bɛ. ");
INSERT INTO sus_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","I xa sose sɛniyɛnxie dɛgɛ i taara Haruna bɛ, naxee a xa kuntigiya nun a binyɛ masenma. ");
INSERT INTO sus_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","I xa na wali so mixie yi ra n naxee kixi xaxili fanyi ra, naxan a niyama e xa fata. E xa Haruna xa sɛrɛxɛdubɛ sosee dɛgɛ, alako a xa ti n ma sɛrɛxɛdubɛ wali ra. ");
INSERT INTO sus_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Sosee nan yi ki e naxee dɛgɛma: donma kanke raxunmase, donma kuye, tunki raxunmase, donma kuye bun magoroe masɔxɔxi, xunmase naxan dɔxɔma e xunyi ma, nun bɛlɛti. E xa na sose sɛniyɛnxie yailan i taara Haruna nun a xa die bɛ, alako e xa sɛrɛxɛdubɛ wali raba n bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","«Donma dɛgɛmae xa gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, gɛsɛ gbeeli, gɛsɛ xɛɛma daaxi, nun suwa dugi malan. ");
INSERT INTO sus_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","E xa donma kuye dɛgɛ gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, gɛsɛ gbeeli, gɛsɛ xɛɛma daaxi, nun suwa dugi ra. A xa findi wali tofanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","E xa tunki raxunmase firin yailan, e xa e dɛgɛ donma kuye ma. ");
INSERT INTO sus_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Bɛlɛti fan xa yailan gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, gɛsɛ gbeeli, gɛsɛ xɛɛma daaxi, nun suwa dugi ra alɔ donma kuye. ");
INSERT INTO sus_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","I xa onixi gɛmɛ firin tongo, i fa Yaxuba xa die xilie masoli e ma ");
INSERT INTO sus_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","e bari ki ma. Xili senni masoli gɛmɛ keren ma, xili senni masoli gɛmɛ boore fan ma. ");
INSERT INTO sus_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Na gɛmɛ masolixi firinyie findima wali tofanyi ra, alɔ sɛbɛli masolima xurundɛ ma ki naxɛ. I xa xɛɛma sa e rabilinyi ma, ");
INSERT INTO sus_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","i fa nee dɛgɛ tunki raxunmasee ma, e xa findi ɲɔxɔ rasiga see ra Isirayila die xa fe ma. Na ki Haruna fama e xilie ra n ya i, a xa findi dubɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","I na xɛɛma sa e rabilinyi ma, ");
INSERT INTO sus_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","i xa luuti die yailan xɛɛma ra naxee gbakuma e rabilinyi ma.» ");
INSERT INTO sus_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«I xa sɛrɛxɛdubɛ donma kanke raxunmase yailan a tofanyi ki ma. A findima kiiti se nan na. I xa a yailan gɛsɛ gɛrɛ daaxi, gɛsɛ bulu daaxi, gɛsɛ gbeeli, nun suwa dugi ra alɔ donma kuye yailanxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","A xa kuyɛ nun a xa igboya xa findi suxui keren na. A xa findi dugi firin na, alako a xa findi yuba ra. ");
INSERT INTO sus_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","A xa raxunma gɛmɛ tofanyie safɛ naani ra. Safɛ singe findima gɛmɛe nan na, naxee xili sariduwani, topasi, nun emerode. ");
INSERT INTO sus_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Safɛ firin nde, esikaribukulu, safiri, nun diyaman. ");
INSERT INTO sus_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Safɛ saxan nde, opale, agati, nun ametisite. ");
INSERT INTO sus_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Safɛ naani nde, kirosolite, onixi, nun yasipe. I xa xɛɛma sa nee birin rabilinyi ma. ");
INSERT INTO sus_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Isirayila xa die xilie xa masoli na gɛmɛ fu nun firin ma, alɔ sɛbɛli masolima xurundɛ ma ki naxɛ. Kankan xili xa masoli gɛmɛ nde ma. E findima Isirayila bɔnsɔɛ fu nun firinyi matɔnxuma se nan na. ");
INSERT INTO sus_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","I xa luuti die dɛgɛ na donma kanke raxunmase ma, naxee yailanxi xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","I xa xurundɛ firin yailan xɛɛma ra, i xa e dɛgɛ donma kanke raxunmase ma a dɛ kiri firinyie ma a fuge ra. ");
INSERT INTO sus_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Na luuti xɛɛma daaxie xa xiri na xurundɛ firinyie ma, naxee dɛgɛxi donma kanke raxunmase dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","I man xa na luuti firinyie xiri donma kuye tunki raxunmasee ma.» ");
INSERT INTO sus_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","«I xa xurundɛ firin gbɛtɛ yailan xɛɛma ra, i naxee dɛgɛma donma kanke raxunmase dɛ kirie ma a labe ra. I xa nee dɛgɛ donma kuye sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","I xa xurundɛ firin gbɛtɛ yailan xɛɛma ra, i naxee dɛgɛma tunki raxunmasee lanbanyi ma, dɛnnaxɛ ilanma bɛlɛti ra. ");
INSERT INTO sus_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Donma kanke raxunmase xa xiri donma kuye ma luuti gɛrɛ daaxi ra naxan nasoma xurundɛe kui naxee dɛgɛxi donma kanke raxunmase nun donma kuye ma.» ");
INSERT INTO sus_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Haruna na so hɔrɔmɔlingira kui, Isirayila bɔnsɔɛ xili birin sɛbɛxi a xa donma kanke raxunmase ma, naxan saxi a kanke fari sondonyi yailanyi, a findima dubɛ ra Alatala bɛ Isirayila xa fe ra tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I xa gɛmɛ firin sa na donma kanke raxunmasee kui, naxan saxi Haruna kanke fari sondonyi mabiri. Nee findixi Ala waxɔnfe masen se nan na. Haruna na so Alatala yire, a nɔma Alatala waxɔnfe kolonde Isirayilakae xa fe ra nee saabui ra.» ");
INSERT INTO sus_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«I xa sɛrɛxɛdubɛ xa donma kuye bun magoroe sɔxɔ gɛsɛ gɛrɛ daaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","I xa a xunyi rasode xaba a tagi, i xa na sode dɛ masɔxɔ, alako bɔɔde yo naxa lu a ma. ");
INSERT INTO sus_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","I xa a raxunma pirinti gɛrɛ daaxi, bulu daaxi, nun gbeeli ra naxee misaalixi wuri bogi ra a rabilinyi birin ma. I xa tɔlɔnyi xɛɛma daaxie dɛgɛ na pirintie tagi, ");
INSERT INTO sus_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","alako tɔlɔnyi nde xa lu wuri bogi birin tagi na donma kuye bun magoroe sanbunyi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruna na a ragoro a ma a so tɛmui nun a mini tɛmui Alatala xa hɔrɔmɔlingira kui, na nan a ratangama faxɛ ma.» ");
INSERT INTO sus_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«I xa xɛɛma yailan, a sɛbɛ a ma, ‹Alatala gbe›, ");
INSERT INTO sus_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","i fa a xiri xunmase fari luuti gɛrɛ daaxi ra, ");
INSERT INTO sus_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","alako a xa gbaku a tigi ra. Xa a sa li sɛrɛxɛ mu nu baxi sɛriyɛ ki ma, na kote luma Haruna nan ma, kɔnɔ na sɛbɛli naxan gbakuxi a tigi ra a niyama nɛ Alatala xa na sɛrɛxɛ suxu.» ");
INSERT INTO sus_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«I xa donma kuye bun magoroe gbɛtɛ dɛgɛ Haruna bɛ suwa dugi ra, a nun xunmase naxan sama a xun ma. I xa a xa bɛlɛti masɔxɔ a tofanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","I xa donma kuye bun magoroe, bɛlɛtie, nun xunmasee dɛgɛ Haruna xa die fan bɛ, naxee e xa binyɛ nun e xa kuntigiya masenma. ");
INSERT INTO sus_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I xa i taara Haruna nun a xa die maxiri na ki, beenun i xa e ti n ma sɛrɛxɛdubɛ wali rabade. I xa ture maso e xunyi ma, i fa e masen ɲama bɛ e bara findi sɛrɛxɛdubɛe ra. ");
INSERT INTO sus_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","I xa wantanyi dɛgɛ suwa dugi ra naxan kelima e tagi han e tabe alako e xa sutura. ");
INSERT INTO sus_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruna nun a xa die xa na mɔɔli so e ma e makɔrɛma sɛrɛxɛbade ra tɛmui naxɛ, xa na mu a ra e na hɔrɔmɔbanxi kui li tɛmui naxɛ, n i lima dɛnnaxɛ. Na nan a niyama e mu yunubi sɔtɔma, e tangama nɛ faxɛ ma. Sɛriyɛ na a ra naxan mu kanama abadan Haruna nun a bɔnsɔɛ birin bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«I na wa mixi tife n ma sɛrɛxɛdubɛ wali rabafe ra, i xa tuura nun yɛxɛɛ kontonyi firin tongo, lanyuru yo mu na naxee ma, ");
INSERT INTO sus_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","a nun taami lɛbinitare, taami lɛbinitare ture masunbuxi naxan na, nun taami lɛbinitare xunxuri ture masoxi naxan ma. I xa na birin naba sansi xɔri luxutaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I xa na taami birin sa debe kui, i a xanin hɔrɔmɔlingira yire, a nun tuura, nun yɛxɛɛ kontonyi firin. ");
INSERT INTO sus_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","I xa Haruna nun a xa die ti sɛrɛxɛdubɛ wali ra hɔrɔmɔlingira sode, n e lima dɛnnaxɛ. I na gɛ e maxade ye ra e rasɛniyɛnfe ra, ");
INSERT INTO sus_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","i xa Haruna xa sɛrɛxɛdubɛ sosee ragoro a ma, a xa donma bun magoroe, a xa donma kuye bun magoroe, a xa donma kuye, a xa donma kanke raxunmase ra, nun a xa bɛlɛti donma kanke raxunmase xirima naxan na. ");
INSERT INTO sus_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I xa xunmase dɔxɔ a xunyi ma, i fa na tɔnxuma xɛɛma daaxi xiri na ra. ");
INSERT INTO sus_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","I xa ture sɛniyɛnxi surusuru a xunyi ma a tife sɛrɛxɛdubɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","I na gɛ na ra, i xa sɛrɛxɛdubɛ donma kuye bun magoroe ragoro Haruna xa die fan ma. ");
INSERT INTO sus_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","I xa Haruna nun a xa die tagi ixiri bɛlɛti ra, i xa xunmase dɔxɔ e xunyi ma. I Haruna nun a xa die tima sɛrɛxɛdubɛe ra na ki nɛ. Na xa findi sɛriyɛ ra naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«I xa tuura nde xanin hɔrɔmɔlingira sode dɛ ra, n i lima dɛnnaxɛ. Haruna nun a xa die na e bɛlɛxɛ sa a xunyi, ");
INSERT INTO sus_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","i xa na tuura kɔn naxaba Alatala ya xɔri hɔrɔmɔlingira sode dɛ ra, n i lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I xa na tuura wuli tongo, i nde sa sɛrɛxɛbade feri naani ma i bɛlɛxɛsole ra. Wuli naxan luxi, i xa na ifili sɛrɛxɛbade sanbunyi ma. ");
INSERT INTO sus_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","I na gɛ na ra, i xa na tuura ture tongo naxan na a furingɛ ma, a laare naxan a bɔɲɛ makotoxi, a gunguie nun ture naxan na e ma, i xa na birin gan sɛrɛxɛ ra sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kɔnɔ a sube, a kiri, nun a xa ɲaɲɛ, i xa nee gan taa fari ma, barima yunubi xafari sɛrɛxɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«I na gɛ na ra, i xa yɛxɛɛ kontonyi keren tongo. Haruna nun a xa die e xa e bɛlɛxɛ sa a xunyi, ");
INSERT INTO sus_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","i fa a kɔn naxaba. I xa a wuli tongo, i a ifili sɛrɛxɛbade rabilinyi ma. ");
INSERT INTO sus_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","I xa na yɛxɛɛ kontonyi bolon a xuntunyi ra. I xa a furingɛ nun a sanyie maxa, i fa e malan a sube nun a xunyi fari, ");
INSERT INTO sus_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","i na birin gan sɛrɛxɛbade fari. Sɛrɛxɛ gan daaxi nan na ki Alatala bɛ, naxan nafan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«I na gɛ na singe ra, i xa na yɛxɛɛ kontonyi firin nde tongo. Haruna nun a xa die na e bɛlɛxɛ sa a xunyi ma, ");
INSERT INTO sus_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","i xa a kɔn naxaba. I xa na wuli tongo, i nde sa Haruna nun a xa die yirefanyi tuli kirie ma, e yirefanyi bɛlɛxɛ, nun sankurae ma. Wuli naxan luxi, i xa na ifili sɛrɛxɛbade rabilinyi. ");
INSERT INTO sus_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","I xa wuli nde tongo sɛrɛxɛbade fari, a nun ture nde naxan nawalixi mixi tife sɛrɛxɛdubɛ ra, i xa nee kasan Haruna, a xa die, nun e xa dugie ma. Na kui Haruna nun a xa die bara ti sɛrɛxɛdubɛe ra, e xa dugie fan bara findi sɛrɛxɛdubɛ dugie ra.» ");
INSERT INTO sus_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«I xa yɛxɛɛ kontonyi ture tongo, a nun a xuli, a ture naxan na a furingɛ ma, a laare naxan a bɔɲɛ makotoxi, a gunguie nun ture naxan e makotoxi, a nun a yirefanyi tabe, barima sɛrɛxɛ na a ra naxan a niyama mixi xa ti sɛrɛxɛdubɛ wali ra. ");
INSERT INTO sus_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","I xa na debe tongo taami lɛbinitare na naxan kui naxan fixi Alatala ma. Na kui i xa taami digilinxi keren tongo, a nun taami lɛbinitare ture masunbuxi naxan na, nun taami lɛbinitare xunxuri nde, ");
INSERT INTO sus_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","i xa nee sa Haruna nun a xa die bɛlɛxɛ, i nee lintan Alatala ya i sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Na dangi xanbi, i xa e ba e bɛlɛxɛ, i e sa sɛrɛxɛ gan daaxi fari sɛrɛxɛbade. Sɛrɛxɛ ganxi na a ra naxan nafan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«I xa yɛxɛɛ kontonyi kanke tongo, naxan baxi Haruna bɛ, i a lintan Alatala ya i sɛrɛxɛ ra, a xa findi i gbe ra. ");
INSERT INTO sus_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Na kanke nun na tabe i naxan lintanxi Alatala ya i sɛrɛxɛ ra sɛrɛxɛdubɛe tife xa fe ra, ");
INSERT INTO sus_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","nee bara findi Haruna nun a xa die gbe ra. Sɛriyɛ nan na ki Isirayilakae bɛ naxan mu kanama abadan. E lan nɛ e xa na mɔɔli ba e xa xanunteya sɛrɛxɛ birin ma, e a fi Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Haruna na faxa, a xa sɛrɛxɛdubɛ sose radangima a xa die nan ma. E ti tɛmui na wali ra, e xa e ragoro e ma. ");
INSERT INTO sus_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Haruna xa di naxan findima a ɲɔxɔɛ ra na nan fama na dugie ragorode a ma xi solofere bun ma, beenun a xa so yire sɛniyɛnxi hɔrɔmɔlingira kui, n i lima dɛnnaxɛ, sɛrɛxɛdubɛ wali rabafe ra.» ");
INSERT INTO sus_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Yɛxɛɛ kontonyi naxan baxi sɛrɛxɛ ra, Haruna findixi sɛrɛxɛdubɛ ra tɛmui naxɛ, i xa na sube ɲin yire nde naxan sɛniyɛnxi. ");
INSERT INTO sus_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Na sube nun na taami naxan na debe kui, Haruna nun a xa die xa na don hɔrɔmɔlingira sode dɛ ra, n i lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","E keren xa na yunubi xafari sɛrɛxɛ don, sɛrɛxɛ naxan ba e bɛ e ti lɔxɔɛ sɛrɛxɛdubɛe ra. A mu lanma mixi gbɛtɛ xa na don, barima se sɛniyɛnxi nan a ra. ");
INSERT INTO sus_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Xa na sɛrɛxɛ sube nun taami nde sa lu han gɛɛsɛgɛ, i xa a gan tɛ xɔɔra. A mu donma, barima se sɛniyɛnxi nan a ra.» ");
INSERT INTO sus_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«I xa n ma yaamarie rabatu Haruna nun a xa die xa fe ra na xi solofere bun ma e tima sɛrɛxɛdubɛe ra tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","I xa tuura keren ba lɔxɔ yo lɔxɔ yunubi xafari sɛrɛxɛ ra. Na nan a toma sɛrɛxɛbade fan sɛniyɛnma. Na xanbi i xa ture ifili sɛrɛxɛbade fari, alako a xa findi yire sugandixi ra. ");
INSERT INTO sus_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","I xa na wali raba xi solofere bun ma, alako sɛrɛxɛbade xa sɛniyɛn, a man xa mixi rasɛniyɛn naxan dinma a ra.» ");
INSERT INTO sus_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Lɔxɔ yo lɔxɔ a lanma i xa yɛxɛɛ firin ba sɛrɛxɛ ra sɛrɛxɛbade fari, naxee bara ɲɛ keren sɔtɔ. Na xa raba kudɛi. ");
INSERT INTO sus_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","A singe xa ba gɛɛsɛgɛ, boore xa ba kɔɛ so tɛmui. ");
INSERT INTO sus_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","I na na yɛxɛɛ singe ba, i xa farin konkoronyi suuli, oliwi ture litiri keren, nun wɛni litiri keren sa na fari. ");
INSERT INTO sus_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","I na na yɛxɛɛ firin nde ba kɔɛ so tɛmui, i xa sansi bogi nde nun wɛni sa a fari alɔ gɛɛsɛgɛ daaxi. I xa nee ba sɛrɛxɛ gan daaxi ra, naxan nafan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Sɛrɛxɛ gan daaxi mɔɔli nan a ra, i bɔnsɔɛ lanma a xa naxan ba n tan Alatala bɛ abadan. A bama hɔrɔmɔlingira sode dɛ nan na n tan Alatala ya xɔri, n wo lima dɛnnaxɛ, n wɔyɛnma wo bɛ dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","«N nan n yɛtɛ masenma Isirayilakae bɛ mɛnni n ma nɔrɛ kui, naxan mɛnni rasɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","N nan n ma hɔrɔmɔlingira nun n ma sɛrɛxɛbade rasɛniyɛnma nɛ, n i lima dɛnnaxɛ. N Haruna nun a xa die rasɛniyɛnma nɛ, alako e xa n ma sɛrɛxɛdubɛ wali raba. ");
INSERT INTO sus_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","N sabatima nɛ Isirayilakae tagi, n man findima nɛ e Marigi Ala ra. ");
INSERT INTO sus_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na kui e a kolonma nɛ n tan nan Alatala ra, e Marigi Ala, naxan e ramini Misira bɔxi ra, alako n xa sabati e tagi. Alatala nan n tan na, e Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«I xa surayi sɛrɛxɛbade yailan kasiya wuri ra. ");
INSERT INTO sus_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A xa kuya nɔngɔn keren, a igbo nɔngɔn keren, a ite nɔngɔn firin. Feri naani xa lu a tuxuie ra, e nun sɛrɛxɛbade findixi se keren nan na. ");
INSERT INTO sus_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","I xa na sɛrɛxɛbade birin maso xɛɛma xinde ra, a fari, a sɛɛtie, a ferie, nun a dɛ kiri. ");
INSERT INTO sus_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","I xa suxuse digilinxi firin yailan xɛɛma ra sɛrɛxɛbade sɛɛti firinyie ma a dɛ kiri labe ra, wuri kuyee soma naxee kui a xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","I xa na wurie yailan kasiya wuri ra, i fa xɛɛma maso e ma. ");
INSERT INTO sus_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Na surayi sɛrɛxɛbade xa dɔxɔ dugi ya ra naxan na saatɛ kankira ya ra, yunubi xunsare yire dɔxɔxi naxan fari, n mixi lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Haruna xa surayi xiri ɲɔxunmɛ gan mɛnni gɛɛsɛgɛ birin, a fɛntɛnma lanpuie ma tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","A man xa na mɔɔli raba kɔɛ so tɛmui. Surayi nan a ra, naxan lanma a xa gan waxati birin Alatala ya xɔri. Sɛriyɛ na a ra wo bɔnsɔɛ bɛ naxan mu kanama abadan. ");
INSERT INTO sus_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Wo naxa sese ba na sɛrɛxɛbade fari bafe surayi sɛniyɛnxi ra. Wo naxa surayi sɛniyɛntare ba, wo naxa sɛrɛxɛ gan daaxi ba, wo naxa sansi sɛrɛxɛ ba, wo naxa wɛni xa na mu a ra ture ba mɛnni. ");
INSERT INTO sus_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ɲɛ yo ɲɛ Haruna xa yunubi xafari sɛrɛxɛ wuli nde tongo, a a maso surayi sɛrɛxɛbade ferie ma, alako e fan xa sɛniyɛn. Sɛriyɛ nan a ra i bɔnsɔɛ lanma a xa naxan naba abadan. Na sɛrɛxɛbade findixi se sɛniyɛnxi nan na Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Alatala naxa yi masenyi ti Munsa bɛ: ");
INSERT INTO sus_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«I na Isirayilakae kɔnti lɔxɔɛ naxɛ, birin xa a xunsare fi Alatala ma. Na nan a ra, mankanɛ yo mu e lima na kɔnti tife xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mixi naxan birin kɔntima, e xa gbeti giramu senni fi Alatala ma. Na xa maniya hɔrɔmɔlingira sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Mixi naxan birin simaya bara ɲɛ mɔxɔɲɛn li, a xa a xunsare fi Alatala ma. ");
INSERT INTO sus_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Banna mu se sama na giramu senni xun ma, misikiinɛ fan mu nde bama na giramu senni ra. Birin xa na fi Alatala ma e xunsare ra. ");
INSERT INTO sus_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Isirayilakae na na gbeti so i yi ra, i xa a rawali hɔrɔmɔlingira yailanfe ra, n i lima dɛnnaxɛ, alako n xa ratu a ma Isirayilakae naxan fixi e xunsare ra.» ");
INSERT INTO sus_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Na dangi xanbi Alatala naxa yi masenyi ti Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«I xa hɔrɔmɔlingira ye sase xungbe yailan wure gbeeli ra, a nun a dɔxɔse. I xa na dɔxɔ hɔrɔmɔlingira nun sɛrɛxɛbade tagi, i fa marasɛniyɛn ye sa a kui, ");
INSERT INTO sus_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna nun a xa die naxan nawalima e bɛlɛxɛe nun e sanyie maxafe ra. ");
INSERT INTO sus_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Beenun e xa so hɔrɔmɔlingira kui, n wo lima dɛnnaxɛ, a lanma e xa e bɛlɛxɛe nun e sanyie maxa na ye ra, alako e naxa faxa. Beenun e xa e makɔrɛ sɛrɛxɛbade ra sɛrɛxɛ gan daaxi bafe Alatala bɛ, ");
INSERT INTO sus_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","a lanma e xa e bɛlɛxɛe nun e sanyie maxa na ye ra, alako e naxa faxa. Sɛriyɛ nan na ra e bɔnsɔɛ birin bɛ naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«I xa se xiri ɲɔxunmɛ fanyie tongo, alɔ wuri wa ye naxan xili miri kilo suuli, wuri fuɲi naxan xili sinamon kilo firin nun a tagi, kale nde kilo firin nun a tagi naxan xiri ɲɔxun, ");
INSERT INTO sus_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kasiya wuri fuɲi kilo suuli, nun oliwi ture litiri senni. ");
INSERT INTO sus_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","I xa na birin yailan ture sɛniyɛnxi ra naxan nawalima sɛrɛxɛdubɛ tife ra. Na wali xa raba a fanyi ra a raba ki ma.» ");
INSERT INTO sus_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","«I man xa na ture rawali hɔrɔmɔlingira nun saatɛ kankira rasɛniyɛnfe ra, n wo lima dɛnnaxɛ, ");
INSERT INTO sus_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","a nun hɔrɔmɔlingira teebili, a yirabasee, lanpui dɔxɔse, a yirabasee, surayi sɛrɛxɛbade, ");
INSERT INTO sus_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","sɛrɛxɛbade xungbe, a yirabasee, hɔrɔmɔlingira ye sase xungbe, nun a dɔxɔse. ");
INSERT INTO sus_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I xa na ture sɛniyɛnxi rawali na birin nasɛniyɛnfe ra. Mixi naxee dinma nee ra, e sɛniyɛnma nɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","I xa na ture sɛniyɛnxi rawali Haruna nun a xa die tife n ma sɛrɛxɛdubɛe ra.» ");
INSERT INTO sus_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«I xa a fala Isirayilakae bɛ a na ture findixi ture sɛniyɛnxi nan na wo bɔnsɔɛ bɛ abadan. ");
INSERT INTO sus_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Wo naxa a sa mixi fate ma, wo naxa na ture mɔɔli yailan wali gbɛtɛ xa fe ra. Ture sɛniyɛnxi nan a ra wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mixi yo naxan na na ture mɔɔli rafala, a a sa mixi sɛniyɛntare ma, na kanyi bama nɛ ɲama ya ma.» ");
INSERT INTO sus_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Alatala naxa a masen Munsa bɛ, «I xa se xiri ɲɔxunmɛe tongo, alɔ sitakite, onixi, nun galibanon. I xa e masunbu surayi fanyi ra, e xasabi birin xa lan. ");
INSERT INTO sus_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Na findima surayi ra naxan xiri ɲɔxun ki fanyi ra. Fɔxɛ di xa sa a ma. Surayi sɛniyɛnxi nan a ra. ");
INSERT INTO sus_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I xa na surayi findi fuɲi ra i naxan sama saatɛ kankira ya ra hɔrɔmɔlingira kui n i lima dɛnnaxɛ. Se sɛniyɛnxi na a ra wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Wo naxa yi surayi mɔɔli rafala wo yɛtɛ bɛ. Se sɛniyɛnxi na a ra, wo naxan nawalima Alatala gbansan bɛ. ");
INSERT INTO sus_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mixi yo naxan na na mɔɔli rafalama a yɛtɛ bɛ a xa na xiri ramɛ, na kanyi kerima nɛ a xa ɲama ya ma.» ");
INSERT INTO sus_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«I xa a kolon n bara Uri xa di Besaleli sugandi, Xuru xa mamadi, naxan fatanxi Yuda bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","N bara xaxili fanyi fi a ma naxan fatanxi n tan na, alako a xa wali birin naba ki kolon lɔnni fanyi ra, ");
INSERT INTO sus_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","a xa nɔ wali tode a xaxili kui beenun a xa raba, a xa nɔ xɛɛma, gbeti, nun wure gbeeli rawalide, ");
INSERT INTO sus_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","a xa nɔ gɛmɛ fanyi masolide a fa a rabilinyi yailan, a xa nɔ kamudɛriɲa nun wali gbɛtɛe rabade.» ");
INSERT INTO sus_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«N bara Oholiyabu Axisamaki xa di so a yi ra, naxan fatanxi Dana bɔnsɔɛ ra, a xa a mali. N bara xaxili fanyi fi mixie ma, naxee fata walide, alako e xa nɔ n ma yaamari birin nabade, ");
INSERT INTO sus_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","alɔ hɔrɔmɔlingira n adamadi lima dɛnnaxɛ, saatɛ kankira, a dɛrakote naxan findixi xunsare yire ra, nun hɔrɔmɔlingira yirabase birin, ");
INSERT INTO sus_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","teebili, teebili yirabasee, lanpui dɔxɔse xɛɛma daaxi, lanpui yirabasee, surayi sɛrɛxɛbade, ");
INSERT INTO sus_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sɛrɛxɛbade xungbe nun a xa yirabasee, ye sase xungbe nun a dɔxɔse, ");
INSERT INTO sus_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","sɛrɛxɛdubɛ sose sɛniyɛnxie Haruna nun a xa die bɛ, ");
INSERT INTO sus_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ture sɛniyɛnxi, nun surayi naxan ganma hɔrɔmɔlingira kui. E xa a birin yailan n ma yaamari ki ma.» ");
INSERT INTO sus_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«A fala Isirayilakae bɛ a e xa e ɲɛngi sa n ma malabui lɔxɔɛe xɔn ma, barima nee findima tɔnxuma ra won tagi abadan, alako wo xa a kolon a n tan nan na Alatala ra naxan wo rasɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Wo xa wo ɲɛngi sa malabui lɔxɔɛ xɔn ma, barima a sɛniyɛn wo tan bɛ. Xa naxan mu a binya, a lan nɛ na kanyi xa faxa. Mixi naxan walima malabui lɔxɔɛ, na kanyi xa keri n ma ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Xi senni na wo yi ra walife ra, kɔnɔ a xi solofere nde findima malabui lɔxɔɛ nan na, naxan fima Alatala ma. Mixi naxan walima na lɔxɔɛ, na kanyi xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isirayilakae xa e ɲɛngi sa malabui lɔxɔɛ xɔn ma, e a rabatu waxati birin. Saatɛ na a ra naxan mu kanama abadan. ");
INSERT INTO sus_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","A findima tɔnxuma nan na, n tan nun Isirayilakae tagi tɛmui birin, barima n tan Alatala, n koore nun bɔxi daaxi xi senni nan bun ma, kɔnɔ a xi solofere nde, n naxa wali dan, n nan n malabu.» ");
INSERT INTO sus_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Alatala to gɛ masenyi tide Munsa bɛ Turusinina geya fari, a naxa gɛmɛ walaxɛ firin so a yi ra seede ra, a xa yaamarie nu sɛbɛxi naxee ma a bɛlɛxɛ sole ra. ");
INSERT INTO sus_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Isirayilakae to a to, Munsa bara bu geya fari, ɲama naxa e malan Haruna yire, e fa a fala a bɛ, «I xa kuye yailan naxan tima muxu ya ra. Munsa naxan muxu raminixi Misira bɔxi ra, muxu mu a kolon fe naxan a sɔtɔxi geya fari.» ");
INSERT INTO sus_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna naxa e yaabi, «Langa xɛɛma daaxi naxan birin na wo xa ginɛe nun wo xa die tulie ra, wo fa e birin na n xɔn ma.» ");
INSERT INTO sus_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Isirayila ɲama birin naxa e xa langa xɛɛma daaxie ba e tulie ra, e fa e so Haruna yi ra. ");
INSERT INTO sus_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Haruna naxa na xɛɛma raxunu, a ninge kuye daaxi yailan a ra. A to gɛ na ra, e naxa a fala e xui itexi ra, «Isirayilakae, won ma ala nan ya naxan won naminixi Misira bɔxi kui.» ");
INSERT INTO sus_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruna to na to, a naxa sɛrɛxɛbade yailan na ninge kuye daaxi ya ra, a fa a fala a xui itexi ra, «Tina, xulunyi tima nɛ Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Na kuye iba, e naxa keli subaxɛ ma, e sɛrɛxɛ gan daaxi nun xanunteya sɛrɛxɛ ba. Mixie naxa e dɛge, e minsee min, e fa e waxɔnfe raba. ");
INSERT INTO sus_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na tɛmui Alatala naxa a masen Munsa bɛ, «I xa goro ɲama yire, barima i naxee namini Misira bɔxi kui, e bara fe kana a ɲaaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","E bara n ma kira bɛɲin yi ikɔrɛxi ra, e bara ninge kuye daaxi yailan wure raxunuxi ra, e na batu, e sɛrɛxɛe ba a bɛ, e a fala, ‹Isirayilakae, won ma ala nan ya naxan won naminixi Misira bɔxi kui.› ");
INSERT INTO sus_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","N tan Alatala n xa a masen i bɛ, yi ɲama, ɲama xurutare na a ra. ");
INSERT INTO sus_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Won naxan nabama, a lu n xa e sɔntɔ n ma xɔnɛ kui, kɔnɔ i tan, i xa makuya e ra, n xa i findi si xungbe ra.» ");
INSERT INTO sus_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Na kui Munsa naxa Alatala maxandi, «Alatala, munfe ra i wama xɔnɔfe i xa ɲama ma, i sɛnbɛ naxan naminixi Misira bɔxi ra? ");
INSERT INTO sus_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Xa i na raba, Misirakae fama a falade a i yi ɲama raminixi Misira bɔxi kui nɛ alako i xa e faxa geyae fari, e xa fe xa ɲɔn duniɲa. N bara i maxandi, i bɔɲɛ magoro, n Marigi. I naxa yi ɲama sɔntɔ. ");
INSERT INTO sus_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","I ratu i xa konyie Iburahima, Isiyaga, nun Isirayila ma, i kalixi naxee ra, a falafe ra, ‹N wo bɔnsɔɛ rawuyama nɛ alɔ tunbui naxee na koore ma. N bɔxi fima wo bɔnsɔɛ ma kɛ ra naxan mu bama wo yi ra abadan.›» ");
INSERT INTO sus_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na tɛmui Alatala bɔɲɛ naxa goro, a mu a xa ɲama sɔntɔ sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Munsa naxa goro geya fari na seede walaxɛ firinyie suxuxi a yi ra, sɛbɛli tixi nee sɛɛti firinyi ma. ");
INSERT INTO sus_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ala nan na walaxɛe yailan, a sɛbɛli masoli e ma. ");
INSERT INTO sus_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosuwe to ɲama xui itexi mɛ, a naxa a fala Munsa bɛ, «N xui nde mɛma ɲama yire naxan luxi alɔ gere so xui.» ");
INSERT INTO sus_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Munsa naxa a yaabi, «Gere geenife xui mu ya, gere lɔɔsife xui fan mu a ra. N xulunyi xui nan mɛma.» ");
INSERT INTO sus_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E to makɔrɛ ɲama ra, Munsa naxa mixie to fare boron na kuye yire. A bɔɲɛ naxa te han a fa walaxɛe woli bɔxi ma geya sanbunyi, e naxa kana. ");
INSERT INTO sus_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","A naxa e xa ninge kuye daaxi woli tɛ xɔɔra, a gan han a findi xube ra. A naxa na tɛ xube sa ye xɔɔra, a na fi Isirayilakae ma, e xa a min. ");
INSERT INTO sus_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","A naxa fa Haruna maxɔrin, «Yi ɲama munse rabaxi i ra, naxan a niyaxi i xa e ti yi yunubi xungbe ra?» ");
INSERT INTO sus_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna naxa a yaabi, «N marigi, i naxa xɔnɔ n ma! I a kolon yi ɲama birama fe kobi fɔxɔ ra ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","E tan nan a falaxi n bɛ, ‹I xa kuye yailan naxan tima muxu ya ra. Munsa naxan muxu raminixi Misira bɔxi ra, muxu mu a kolon fe naxan a sɔtɔxi geya fari.› ");
INSERT INTO sus_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","N naxa a fala e bɛ, ‹Wo xa fa wo xa xɛɛma ra.› E to fa na xɛɛma ra, n naxa a woli tɛ xɔɔra, yi ninge kuye daaxi fa mini.» ");
INSERT INTO sus_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Munsa naxa a kolon Haruna ɲama luxi nɛ e xa e waxɔnfe raba. Na nu wama findife yaagi ra Isirayilakae bɛ e yaxuie mabiri. ");
INSERT INTO sus_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Munsa naxa sa ti e xa yonkinde sode dɛ ra, a fa a fala a xui itexi ra, «Naxee na Alatala bɛ, wo xa fa n yire.» Lewi bɔnsɔɛ birin naxa e malan Munsa xanbi ra. ");
INSERT INTO sus_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A naxa a fala e bɛ, «Isirayila Marigi Alatala bara wo yamari wo birin xa wo xa santidɛgɛma tongo, wo fa wo ngaxakerenyi birin faxa, a nun wo booree nun wo dɔxɔbooree naxee bara lu yi fe kui.» ");
INSERT INTO sus_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Na lɔxɔɛ Lewi bɔnsɔɛ naxa Munsa xa yaamari suxu, e fa Isirayilaka mixi wulu saxan faxa. ");
INSERT INTO sus_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Munsa naxa a fala e bɛ, «To wo bara Alatala waxɔnfe raba wo ngaxakerenyie faxafe. Ala xa baraka sa wo xa fe ma.» ");
INSERT INTO sus_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Na kuye iba, Munsa naxa a fala ɲama bɛ, «Wo bara yunubi xungbe raba. N xa gbilen Alatala yire geya fari, alako n xa a mayandi wo xa yunubi xafarife ra.» ");
INSERT INTO sus_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Munsa naxa siga Alatala yire, a a fala a bɛ, «Alatala, n bara i maxandi yi ɲama bɛ. E bara yunubi xungbe raba kuye yailanfe xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","N bara i maxandi, i xa diɲɛ e ma. Yandi, xa na mu a ra, i xa n xili ba e ɲɔxɔɛ ra kisi kitaabui kui, i naxan sɛbɛxi.» ");
INSERT INTO sus_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Alatala naxa a yaabi, «Ade, n mixie nan xili bama n ma kisi kitaabui kui naxee yunubi rabaxi n na. ");
INSERT INTO sus_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yakɔsi, siga, i xa ɲama xanin n dɛnnaxɛ masenxi i bɛ. N ma malekɛ tima i ya ra sinden, kɔnɔ kiiti lɔxɔɛ na fa, e e xa yunubie sare fima nɛ.» ");
INSERT INTO sus_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Alatala Isirayilakae ratɔn nɛ, barima e a fala nɛ Haruna bɛ, a xa ninge kuye daaxi yailan e bɛ xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Alatala naxa a masen Munsa bɛ, «Wo nun ɲama i naxan naminixi Misira bɔxi kui, wo xa siga n dɛnnaxɛ laayidixi Iburahima, Isiyaga, nun Yaxuba bɛ kali ra, a falafe ra n na fima e bɔnsɔɛe ma. ");
INSERT INTO sus_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","N malekɛ tima nɛ wo ya ra. N Kanaankae, Amorikae, Xitikae, Perisikae, Hiwikae, nun Yebusukae kerima nɛ ");
INSERT INTO sus_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","na bɔxi ma, xiɲɛ nun kumi xɛlɛma dɛnnaxɛ. Kɔnɔ n tan mu sigama naa wo fɔxɔ ra, xa na mu a ra n wo sɔntɔma nɛ kira xɔn ma, barima ɲama xurutare nan wo ra.» ");
INSERT INTO sus_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ɲama to na masenyi xɔrɔxɔɛ mɛ, e naxa sunnun. Mixi yo mu a raxunmasee so a ma. ");
INSERT INTO sus_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Alatala naxa a masen Munsa bɛ, «I xa a fala Isirayilakae bɛ, ‹Xurutaree nan wo ra. Xa n bira wo fɔxɔ ra, n wo sɔntɔma nɛ. Wo xa wo fate raxunmase birin ba wo ma, n xa a mato n wo xa fe suxuma ki naxɛ.›» ");
INSERT INTO sus_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Na kui e to keli Xorebe geya yire, e naxa e xa xunmasee ba e ma. ");
INSERT INTO sus_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Munsa nu kiri banxi tongoma, a nu a ti Isirayilakae xa yonkinde fari ma. A naxa na xili sa Ala Maxandi yire. Mɛnni mixi nu nɔma maxɔrinyi tide Alatala ma. ");
INSERT INTO sus_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Munsa to nu minima sigafe ra na banxi kui, ɲama birin nu kelima nɛ, e ti e xa naadɛ ra, e ya ti Munsa ra han a so na kui. ");
INSERT INTO sus_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Munsa na gɛ sode na banxi kui, nuxui nu goroma na naadɛ ra, Alatala fa sumun a bɛ. ");
INSERT INTO sus_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Isirayilakae to nu na nuxui toma na banxi sode dɛ ma, e nu luma e mafelen na bɔxi ma e xɔnyi naadɛe ra. ");
INSERT INTO sus_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Alatala nu wɔyɛnma Munsa bɛ e boore ya i, alɔ mixi wɔyɛnma a boore bɛ ki naxɛ. Sumunyi dangi xanbi, Munsa nu gbilenma ɲama yire, kɔnɔ a malima Yosuwe, Nun xa di, na tan mu nu kelima na banxi kui. ");
INSERT INTO sus_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Munsa naxa a masen Alatala bɛ, «N Marigi i bara n yamari n xa ti yi ɲama ya ra, kɔnɔ i mu a masenxi n bɛ i naxan xɛɛma muxu matife ra. I bara a fala n bɛ, ‹N tan nan i sugandixi, i bara n kɛnɛn.› ");
INSERT INTO sus_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","N bara i maxandi, xa n i kɛnɛnxi, i xa i waxɔnfe masen n bɛ, alako n xa i kolon yati, n man xa i xa hinnɛ sɔtɔ. I xa a kolon, yi si findixi i xa ɲama nan na.» ");
INSERT INTO sus_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Alatala naxa a yaabi, «N tan yati wo matima nɛ, n xa bɔɲɛsa fi wo ma.» ");
INSERT INTO sus_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Munsa naxa a masen a bɛ, «Xa i tan yati mu muxu matima naa, i naxa a lu muxu xa keli be. ");
INSERT INTO sus_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Munse nɔma a masende duniɲa bɛ a muxu bara i kɛnɛn, xa i mu na muxu fɔxɔ ra? Na kui xa i na muxu fɔxɔ ra, e nɔma a kolonde i bara n tan nun i xa ɲama sugandi duniɲa si birin ya ma.» ");
INSERT INTO sus_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Alatala naxa Munsa yaabi, «I naxan falaxi, n a rabama nɛ, barima i bara n kɛnɛn. N tan nan i sugandixi yati.» ");
INSERT INTO sus_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na dangi xanbi Munsa naxa Ala maxandi, «I xa i xa nɔrɛ masen n bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Alatala naxa a yaabi, «N fama n ma fanyi birin masende i bɛ. N tan Alatala, n man fama n xili yati falade i bɛ. N hinnɛma mixi ra, n wama hinnɛfe naxan na. N kinikinima mixi ma, n wama kinikinife naxan ma. ");
INSERT INTO sus_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kɔnɔ i mu nɔma n yatagi tan tode, barima adamadi yo mu nɔma n yatagi tode, a mu faxa.» ");
INSERT INTO sus_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Alatala naxa a masen a bɛ, «Fanye nde nan be n fɛ ma. I xa ti naa. ");
INSERT INTO sus_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","N nɛ dangima n ma nɔrɛ kui, n i nɔxunma fɔnmɛ kui, n fa i ya makoto n bɛlɛxɛ ra han n gɛma dangide tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Na tɛmui n fama n bɛlɛxɛ bade i ya ma, alako i xa nɔ n kobe tode fa, kɔnɔ i mu nɔma n yatagi tan tode.» ");
INSERT INTO sus_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Alatala naxa a masen Munsa bɛ, «Walaxɛ firin masoli gɛmɛ ra, naxee maniya na singee ra i naxee kana. N xa sɛbɛli ti e ma, alɔ sɛbɛli naxan nu tixi na booree ma. ");
INSERT INTO sus_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I xa kurun tina gɛɛsɛgɛ tefe ra Turusinina geya fari i n lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","I naxa fa mixi yo ra, mixi yo naxa te geya ma. Hali xurusee naxa e dɛmadon mɛnni.» ");
INSERT INTO sus_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Munsa naxa gɛmɛ walaxɛ firin masoli alɔ a singee. Subaxɛ a naxa te Turusinina geya ma na walaxɛe ra, alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Alatala to goro nuxui kui Munsa yire a xili masende a bɛ, ");
INSERT INTO sus_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","a naxa dangi Munsa ya ra, a fa a yita a bɛ, «N tan nan na Alatala ra. Alatala naxan kinikinima, naxan xa hinnɛ gbo, naxan diɲɛma ibunadama ma. Dugutɛgɛɲa kanyi nan n na, n mu yanfanteya kolon. ");
INSERT INTO sus_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","N ma dugutɛgɛɲa buma abadan. N diɲɛma mixi xa tantanyi ma, n mu ratuma e xa matandi ma, n e xa yunubi xafarima. Kɔnɔ n mu nɛɛmuma tinxintareya ma. N tinxintaree sare ragbilenma nɛ e bɔnsɔɛ ma han e tolontolonyie xa waxati.» ");
INSERT INTO sus_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Munsa naxa a felen bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","a fa a fala, «N Marigi, n bara i maxandi, xa n i kɛnɛn, i xa ɲɛrɛ muxu ya ma, barima xurutare nan muxu ra. I xa diɲɛ muxu xa matandi ma, i xa muxu xa yunubie xafari, alako muxu xa findi i xa ɲama yati nan na.» ");
INSERT INTO sus_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Alatala naxa a yaabi, «N xa saatɛ tongo wo bɛ. N fama nɛ kaabanakoe rabade wo ya ma, naxee singe mu nu raba duniɲa kui. Si birin kaabama nɛ Alatala xa wali magaaxuxie ma, n naxee rabama i tan saabui ra. ");
INSERT INTO sus_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Wo ɲɛngi sa n ma yaamari xɔn ma n naxan falama wo bɛ to. N fama nɛ Amorikae, Kanaankae, Xitikae, Perisikae, Hiwikae, nun Yebusukae keride wo ya ra. ");
INSERT INTO sus_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wo na so na, wo nun e tan naxa saatɛ yo xiri, xa na mu a ra e findima gantanyi nan na wo bɛ. ");
INSERT INTO sus_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A lanma wo xa e xa sɛrɛxɛbadee rabira, wo xa e xa gɛmɛ tɔnxumae kana, wo xa e xa kuyee masolixie masɛgɛ. ");
INSERT INTO sus_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Wo naxa wo magoro ala gbɛtɛ bun ma, barima n tan naxan xili Alatala, n mu wama n firin nde xɔn. ");
INSERT INTO sus_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Wo naxa saatɛ xiri wo nun na bɔxikae ra, alako wo naxa n yanfa, wo fa e xa alae xa sɛrɛxɛe don e wo xilima lande naxee ma. ");
INSERT INTO sus_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Wo naxa mɛnni ginɛe fen wo xa die bɛ, alako e naxa a niya wo xa die xa e xa alae batu. ");
INSERT INTO sus_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Wo naxa ala gbɛtɛ yailan wure raxunuxi ra.» ");
INSERT INTO sus_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Wo xa Taami Lɛbinitare Sali raba. Xi solofere bun ma Abiba kike ra, wo xa taami lɛbinitare gbansan don, alɔ n wo yamarixi ki naxɛ. Wo xa ratu a ma a n wo raminixi Misira bɔxi kui na kike nan na.» ");
INSERT INTO sus_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«N gbe nan di xɛmɛ singe birin na, a findi mixi ra, a findi xuruse ra wo xa gɔɔrɛ kui alɔ ninge, yɛxɛɛ, xa na mu a ra si. ");
INSERT INTO sus_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Wo xa sofale xa di singe xun sara yɛxɛɛ xa na mu a ra si ra. Xa wo mu tin na ra, wo xa na sofale kɔnyi gira. Wo xa di xɛmɛ singe birin xun sara. Wo naxa wo makɔrɛ n na wo bɛlɛxɛ igeli ra.» ");
INSERT INTO sus_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Wo xa wali xi senni lɔxunyi kui, kɔnɔ a xi solofere nde, wo xa wo malabu. Hali a findi xɛ buxa nun xɛ xaba tɛmui nan na, wo xa na sɛriyɛ suxu.» ");
INSERT INTO sus_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Wo xa Lɔxunyie Sali raba Ala tantufe ra wo mɛngi singe xabama tɛmui naxɛ, a nun wo xɛ xabama tɛmui naxɛ ɲɛ ɲɔnyi. ");
INSERT INTO sus_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ɲɛ keren kui, xɛmɛ birin xa fa sali raba ra Isirayila Marigi Alatala ya xɔri sanya saxan. ");
INSERT INTO sus_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Na waxati saxanyi kui, n mu tinma si yo xa fa wo xa bɔxi ba wo yi ra. N a niyama nɛ wo xa nɔ e ra, wo fa nde sa wo xa bɔxi xa gboe xun ma.» ");
INSERT INTO sus_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Wo naxa fa xuruse sɛrɛxɛ ra n xɔn ma, taami lɛbini daaxi biraxi a fɔxɔ ra. Wo na gɛ Sayamalekɛ Dangi Sali sɛrɛxɛ donde, wo naxa na sube dɔnxɔɛ raxi yɛ i. ");
INSERT INTO sus_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Wo xa wo xa sansi bogi fisamante singee ba sɛrɛxɛ ra wo Marigi Alatala xa hɔrɔmɔlingira kui. Wo naxa si yɔrɛ ɲin a nga xiɲɛ ye ra.» ");
INSERT INTO sus_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Alatala naxa a masen Munsa bɛ, «I xa yi yaamarie sɛbɛ, barima nee findixi saatɛ nan na n nun Isirayila ɲama tagi.» ");
INSERT INTO sus_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Munsa naxa lu Alatala yire xi tongo naani. Kɔɛ nun yanyi a mu sese don, a mu sese min. Na waxati Alatala naxa na sɛriyɛ fu sɛbɛ gɛmɛ walaxɛe ma, naxee findixi saatɛ masenyi ra. ");
INSERT INTO sus_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Munsa naxa goro Turusinina geya fari, walaxɛ firin suxuxi a yi ra, naxee findixi saatɛ masenyi ra. Munsa mu nu a kolon a yatagi nu bara nɔrɔ a tan nun Ala xa sumunyi saabui ra. ");
INSERT INTO sus_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna nun Isirayilakae to nɔrɛ to Munsa yatagi ma, e mu suusa e makɔrɛde a ra. ");
INSERT INTO sus_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Munsa naxa Haruna nun ɲama kuntigie xili, e fa lu yire keren. ");
INSERT INTO sus_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","E to gɛ wɔyɛnde, Isirayila ɲama birin naxa fa e tuli matide Alatala xa yaamari ra, a naxan masenxi Munsa bɛ Turusinina geya fari. ");
INSERT INTO sus_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Munsa to gɛ na falade, a naxa mafelenyi dusu a yatagi xun na. ");
INSERT INTO sus_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","A nu so kiri banxi kui maxɔrinyi tide Alatala ma, a nu mafelenyi bama a yatagi ma. A na mini tɛmui naxɛ, a Ala xa yaamari radangi Isirayila ɲama ma. ");
INSERT INTO sus_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Isirayilakae nu a toma Munsa yatagi nu nɔrɔxi ki naxɛ. A na gɛ na masenyi ra, a man a xa mafelenyi dusu a xun na, han a gbilen tɛmui Alatala yire. ");
INSERT INTO sus_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Munsa naxa Isirayila ɲama birin malan, a a fala e bɛ, «Alatala xa yaamarie nan ya: ");
INSERT INTO sus_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Wo xa wali xi senni lɔxunyi kui, kɔnɔ a xi solofere nde wo xa wo malabu. Lɔxɔɛ sugandixi na a ra Alatala bɛ. Mixi yo naxan wali suxuma na lɔxɔɛ, a lanma na kanyi xa faxa. ");
INSERT INTO sus_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Wo naxa tɛ yo radɛxɛ wo xa banxi kui malabui lɔxɔɛ.» ");
INSERT INTO sus_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Munsa man naxa a masen Isirayila ɲama birin bɛ, «Alatala xa yaamarie nan ya: ");
INSERT INTO sus_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Wo xa hadiya ba Alatala bɛ. Mixi naxan na a ɲanige a xa hadiya ba, alɔ xɛɛma, gbeti, nun wure gbeeli, ");
INSERT INTO sus_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli, suwa dugi, nun gɛsɛ naxan yailanxi si xabe ra, ");
INSERT INTO sus_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","yɛxɛɛ kontonyi kiri naxee soxi a gbeeli ra, peremui kirie, nun kasiya wuri, ");
INSERT INTO sus_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lanpui ture, labundɛ naxan masunbuma ture ra, surayi xiri ɲɔxunmɛ naxan ganma, ");
INSERT INTO sus_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onixi gɛmɛ, nun gɛmɛ tofanyi naxee sama sɛrɛxɛdubɛ xa donma kuye nun a xa donma kanke raxunmase ma.» ");
INSERT INTO sus_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Wali kolonyie naxee na wo ya ma, e xa fa yi see yailande alɔ Alatala a yamarixi ki naxɛ: ");
INSERT INTO sus_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hɔrɔmɔlingira dugie, a xun makoto see, a suxusee, a xebenyie, a wurie nun e sanbunyie, ");
INSERT INTO sus_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","a nun saatɛ kankira, a wuri kuyee, a dɛrakote, a nun dugi naxan gbakuma a ya ra, ");
INSERT INTO sus_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","hɔrɔmɔlingira teebili, a wuri kuyee, a yirabase, nun taami naxee bama Alatala bɛ sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","hɔrɔmɔlingira lanpui dɔxɔse, a yirabasee, a lanpuie, nun ture naxan sama a kui, ");
INSERT INTO sus_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","surayi sɛrɛxɛbade, a wuri kuyee, nun ture sɛniyɛnxi, labundɛ gan daaxi, a nun dugi naxan gbakuma hɔrɔmɔlingira sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","sɛrɛxɛbade xungbe, a sube ganse wure gbeeli daaxi, a wuri kuyee, a yirabase, nun hɔrɔmɔlingira ye sase xungbe nun a dɔxɔse, ");
INSERT INTO sus_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","hɔrɔmɔlingira tɛtɛ xa dugie, a wurie, nun e sanbunyie, a nun dugi naxan gbakuma tɛtɛ sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","hɔrɔmɔlingira maxirisee, tɛtɛ maxirisee, nun e xa luutie, ");
INSERT INTO sus_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","a nun sɛrɛxɛdubɛ sosee Haruna nun a xa die bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Isirayila ɲama naxa keli Munsa xun ma. ");
INSERT INTO sus_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Mixi naxee a ɲanige, nee naxa fa e xa hadiya ra Alatala bɛ a xa hɔrɔmɔlingira tife ra, Ala e lima dɛnnaxɛ, a nun sɛrɛxɛdubɛ sosee sɛniyɛnxie yailanfe ra. ");
INSERT INTO sus_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Xɛmɛe nun ginɛ naxee a ɲanigexi, e naxa fa xunmase xɛɛma daaxie ra, alɔ tulirasoe, xurundɛe, kɔnyi magorosee, bɛlɛxɛrasoee, a nun xunmase gbɛtɛ naxee yailanxi xɛɛma ra. E naxa na birin fi Alatala ma sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli, suwa dugie, gɛsɛ naxan yailanxi si xabe ra, yɛxɛɛ kontonyi kiri naxee soxi a gbeeli ra, nun peremui kirie nu na naxee yi ra, nee naxa fa e ra. ");
INSERT INTO sus_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mixi naxee nu a ɲanigexi, nee naxa fa gbeti nun wure gbeeli hadiya ra Alatala bɛ. Kasiya wuri kanyie naxa fa na wuri ra hɔrɔmɔlingira wali xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ginɛ naxan birin fata dugi sɔxɔde, e naxa dugie sɔxɔ e bɛlɛxɛ ra, e fa nee ra: dugi gɛrɛ daaxi, bulu daaxi, nun a gbeeli. E naxa fa suwa dugi ra. ");
INSERT INTO sus_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ginɛ naxan birin fata, e a ɲanige, e naxa gɛsɛ yailan si xabe ra. ");
INSERT INTO sus_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ɲama kuntigie naxa fa onixi gɛmɛe nun gɛmɛ tofanyi gbɛtɛe ra, naxee sama sɛrɛxɛdubɛ xa donma kuye nun a xa donma kanke raxunmase ra. ");
INSERT INTO sus_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","E naxa fa labundɛ nun ture ra hɔrɔmɔlingira lanpui bɛ, a nun ture sɛniyɛnxi nun labundɛ gan daaxi gbɛtɛ. ");
INSERT INTO sus_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isirayilaka birin naxee a ɲanigexi e bɔɲɛ kui, xɛmɛe nun ginɛe, nee naxa fa hadiya ra Alatala xɔn ma, alako Munsa xa wali raba Alatala a yamarixi naxan na. ");
INSERT INTO sus_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Munsa naxa a masen Isirayilakae bɛ, «Wo a kolon, Alatala bara Besaleli Uri xa di sugandi, Xuru xa mamadi naxan fatanxi Yuda bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Alatala bara xaxili fanyi fi a ma, alako a xa wali birin naba ki kolon lɔnni fanyi ra, ");
INSERT INTO sus_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","a xa nɔ wali tode a xaxili kui beenun a xa raba, a xa nɔ xɛɛma, gbeti, nun wure gbeeli rawalide, ");
INSERT INTO sus_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","a xa nɔ gɛmɛ fanyi masolide a fa a rabilinyi yailan, a xa nɔ kamudɛriɲa nun wali gbɛtɛe rabade. ");
INSERT INTO sus_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ala bara a niya Besaleli xa nɔ mixi gbɛtɛ matinkande a xa wali ra. Ala bara na niya Oholiyabu Axisamaki xa di fan bɛ, naxan fatanxi Dana bɔnsɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ala bara e mali alako e xa fata wali birin na, alɔ gɛmɛ nun wuri masolife, pirinti rabafe, suwa dugi sɔxɔfe gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra, a nun wali birin e naxan toma e xaxili kui.» ");
INSERT INTO sus_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besaleli, Oholiyabu, nun wali fanyi rabae, Alatala bara xaxili fanyi fi naxee ma, alako e xa hɔrɔmɔlingira wali birin naba ki kolon lɔnni fanyi ra, nee wali suxu nɛ alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Munsa naxa Besaleli, Oholiyabu, nun wali fanyi rabae xili, Alatala bara xaxili fanyi fi naxee ma, naxee nu bara a ɲanige e xa na wali raba. ");
INSERT INTO sus_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Munsa naxa hadiya birin so e yi ra, Isirayilakae naxee baxi sɛrɛxɛ ɲanigexi ra e xa hɔrɔmɔlingira tife xa fe ra. Gɛɛsɛgɛ yo gɛɛsɛgɛ, e nu hadiya gbɛtɛ sɔtɔma. ");
INSERT INTO sus_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Na wali fanyi rabae naxa keli e xa walie dɛ i, alako e xa hɔrɔmɔlingira wali gbansan naba. ");
INSERT INTO sus_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","E naxa a fala Munsa bɛ, «Ɲama fama hadiya naxee ra, a gbo wali bɛ, Alatala naxan yamarixi.» ");
INSERT INTO sus_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Na kui Munsa naxa yaamari fi, yi xibaaru xa rayensen yonkinde kui, «Mixi naxa wali sɔnɔn hadiya xa fe ra, naxan bama hɔrɔmɔlingira tife ra.» Ɲama naxa na xui rabatu, e mu fa na hadiya mɔɔli ra sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Se naxee nu bara ba, nee nu nɔma wali raɲɔnde a fanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Wali fanyi rabae naxa hɔrɔmɔlingira ti suwa dugi fu ra, a gɛrɛ daaxi, a bulu daaxi, nun a gbeeli. E malekɛe sawurɛ masɔxɔ a ma a tofan ki ma. ");
INSERT INTO sus_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dugi birin kuya nɔngɔn mɔxɔɲɛn nun solomasaxan, e igbo nɔngɔn naani. E kuyɛ nun e igboya lan. ");
INSERT INTO sus_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","E dugi suuli dɛgɛ e boore ra, e dugi suuli gbɛtɛ fan dɛgɛ e boore ra. Na kui na dugi fu bara findi dugi firin na. ");
INSERT INTO sus_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","E gɛsɛ gɛrɛ daaxi dɛgɛ na dugi singe dɛ kiri ma, a nun na dugi firin nde dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","E gɛsɛ tongo suuli dɛgɛ na firinyi dɛ kiri ma alako e birin xa lan e boore ma. ");
INSERT INTO sus_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","E suxuse tongo suuli yailan xɛɛma ra, na dugi firinyie ralan e boore ra na suxusee ra. Na nan a niya hɔrɔmɔlingira findi dugi keren na. ");
INSERT INTO sus_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","E dugi fu nun keren sɔxɔ si xabe ra, naxee Ala xa hɔrɔmɔlingira makotoma. ");
INSERT INTO sus_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dugi keren kuya nɔngɔn tongo saxan, a igbo nɔngɔn naani. Na dugi fu nun kerenyi birin lan nɛ. ");
INSERT INTO sus_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","E dugi suuli dɛgɛ e boore ra, e findi dugi keren na. Na dugi senni naxee luxi, e fan dɛgɛ e boore ra. ");
INSERT INTO sus_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","E gɛsɛ tongo suuli dɛgɛ na dugi singe ra, a nun na dugi firin nde ra. ");
INSERT INTO sus_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","E suxuse tongo suuli yailan wure gbeeli ra, na dugi firinyie ralan e boore ra na suxusee ra. Na nan a niya na birin findi dugi keren na naxan Ala xa hɔrɔmɔlingira makotoma. ");
INSERT INTO sus_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E makotose gbɛtɛ yailan yɛxɛɛ kontonyi kiri ra, naxan soxi a gbeeli ra. E makotose gbɛtɛ yailan peremui kiri ra. ");
INSERT INTO sus_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","E kasiya wuri xaba xebenyie ra hɔrɔmɔlingira tima naxee ra. ");
INSERT INTO sus_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kankan kuya nɔngɔn fu, a igbo nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Suxuse firin lu hɔrɔmɔlingira xebenyi birin ma e kafuma e boore ma naxee ra. ");
INSERT INTO sus_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Xebenyi mɔxɔɲɛn nan ti hɔrɔmɔlingira yirefanyi ma. ");
INSERT INTO sus_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Sanbunyi gbeti daaxi tongo naani nan sa na xebenyi mɔxɔɲɛn bun ma, xebenyi keren, sanbunyi firin. E lu xebenyi suxusee fɛ ma. ");
INSERT INTO sus_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Xebenyi mɔxɔɲɛn nan ti hɔrɔmɔlingira kɔɔla fan ma, ");
INSERT INTO sus_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","a nun e sanbunyi gbeti daaxi tongo naani, xebenyi keren, sanbunyi firin. ");
INSERT INTO sus_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Xebenyi senni nan ti hɔrɔmɔlingira xanbi ra sogegorode mabiri. ");
INSERT INTO sus_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","E xebenyi firin yailan tuxuie bɛ hɔrɔmɔlingira xanbi ra, ");
INSERT INTO sus_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","naxee fuge nun labe lanma e boore ma, e xiri fuge ra se digilinxi ra. Na tuxui firinyi yailan na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Na birin lanxi xebenyi solomasaxan nan ma, a nun e sanbunyi gbeti daaxi fu nun senni, xebenyi keren, sanbunyi firin. ");
INSERT INTO sus_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","E wuri suuli yailan kasiya wuri ra, hɔrɔmɔlingira xebenyie tima naxee ma. Suuli rawali sɛɛti ma, ");
INSERT INTO sus_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","suuli rawali boore sɛɛti ma, suuli rawali hɔrɔmɔlingira xanbi ra sogegorode mabiri. ");
INSERT INTO sus_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wuri naxan lu a tagi, na dangi xebenyie nan xun ma, a keli sɛɛti singe a sa dɔxɔ boore ra. ");
INSERT INTO sus_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Na xebenyie, nun na wurie, nun se digilinxie wuri so naxee kui, na birin maso xɛɛma nan na. ");
INSERT INTO sus_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","E suwa dugi yailan gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra. Malekɛ sawurɛe dɛgɛ na ma, a tofan ki ma. ");
INSERT INTO sus_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A gbaku kasiya wuri naani ma naxee masoxi xɛɛma ra, e tixi gbeti sanbunyie ma. Suxuse naxee dugi xirima wurie ma, nee fan maso xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","E suwa dugi gbɛtɛ yailan gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra hɔrɔmɔlingira sode dɛ ra. E a masɔxɔ a fanyi ra, a xa tofan. ");
INSERT INTO sus_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","E a gbaku wuri suuli ma naxee yailanxi kasiya wuri ra, e masoxi xɛɛma ra, e tixi gbeti sanbunyie ma. Suxuse naxee dugi xirima wurie ma, nee yailanxi wure gbeeli ra. ");
INSERT INTO sus_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleli naxa kankira yailan kasiya wuri ra. A kuya nɔngɔn firin nun a tagi, a igbo nɔngɔn keren nun a tagi, a ite nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A naxa a kui nun a fari maso xɛɛma ra, a naxa a dɛ kiri fan yailan xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A naxa a suxude digilinxi naani rafala xɛɛma ra a tunxun naanie ma, firin na sɛɛti, firin na boore sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A naxa kasiya wuri firin masoli a bɛ, a fa e maso xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A naxa e raso na kankira suxude digilinxie kui, nee findi kankira tongose ra. ");
INSERT INTO sus_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A naxa na kankira dɛrakote yailan xɛɛma fanyi ra, a findi xunsare yire ra. A kuya nɔngɔn firin nun a tagi, a igbo nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A naxa malekɛ sawurɛ firin yailan xɛɛma xabuxi ra kankira dɛrakote fari na sɛɛti firinyie ma. ");
INSERT INTO sus_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Na malekɛ sawurɛe nun na kankira dɛrakote findi keren na. ");
INSERT INTO sus_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Na malekɛ sawurɛ firinyie naxa ti e boore ya i, e gabutenyie italaxi, e xun sinxi xunsare yire. ");
INSERT INTO sus_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","A naxa teebili yailan kasiya wuri ra, naxan kuya nɔngɔn firin, a igbo nɔngɔn keren, a ite nɔngɔn keren nun a tagi. ");
INSERT INTO sus_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A naxa xɛɛma fanyi maso a ma, a nun a dɛ kirie ma. ");
INSERT INTO sus_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A naxa xebenyi nde sa na dɛ kirie bun ma, naxan igbo suxui keren a nun a tagi. A naxa xɛɛma sa na fan dɛ kirie ma. ");
INSERT INTO sus_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A naxa a suxude digilinxi naani rafala xɛɛma ra a tunxun naanie ma, naxee ilanma a sanyie ra. ");
INSERT INTO sus_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","E nu na na xebenyi bun ma. Wuri kuyee nu soma nee kui teebili xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A naxa wuri kuyee masoli kasiya wuri ra, a e maso xɛɛma ra. Nee findi teebili tongose ra. ");
INSERT INTO sus_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Piletie, tɔnbilie, pɔɔtie, nun paani naxee sama na teebili ma, naxee rawalima sɛrɛxɛ yeerama daaxi xa fe ra, a naxa e birin yailan xɛɛma fanyi ra. ");
INSERT INTO sus_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","A naxa lanpui dɔxɔse nde yailan xɛɛma fanyi xabuxi ra. A sanyi, a bili, a salonyie, nun lanpui dɔxɔde naxee maniya sansi fugee ra, na birin findi keren na. ");
INSERT INTO sus_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Salon senni nan mini lanpui dɔxɔse bili ma, saxan sɛɛti keren, saxan boore sɛɛti. ");
INSERT INTO sus_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Tɔnbili saxan nan lu na salon senni birin xun ma. E maniya sansi bogi ra naxan dɔxɔxi a burɛxɛee nun a fugee tagi. ");
INSERT INTO sus_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Tɔnbili naani gbɛtɛ nan lu lanpui dɔxɔse bili ma. E fan maniya sansi bogi ra naxan dɔxɔxi a burɛxɛe nun a fugee tagi. ");
INSERT INTO sus_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Na salon firin firin dɔxɔ saxanyie bun ma naxee kelixi a bili ma, a sa nɛ mɛnni fan ma. ");
INSERT INTO sus_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Na tɔnbilie nun lanpui salonyie findi keren na, e yailan xɛɛma fanyi xabuxi ra. ");
INSERT INTO sus_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A naxa lanpui solofere yailan, a e dɔxɔ e dɔxɔdee ma alako e dɛxɛ xa yare iyalan. ");
INSERT INTO sus_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Xɛɛma naxan nawalixi lanpui dɔxɔse nun lanpui yirabase yailanfe ra, na findi xɛɛma kilo tongo saxan nun naani nan na. ");
INSERT INTO sus_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","A naxa surayi sɛrɛxɛbade yailan kasiya wuri ra. A kuya nɔngɔn keren, a igbo nɔngɔn keren, a sɛɛti naani birin lan, a ite nɔngɔn firin. Ferie naxa lu a tuxuie ra, e nun sɛrɛxɛbade findi se keren na. ");
INSERT INTO sus_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A naxa na sɛrɛxɛbade birin maso xɛɛma xinde ra, a fari, a sɛɛtie, a ferie, nun a dɛ kiri. ");
INSERT INTO sus_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A naxa suxuse digilinxi firin yailan xɛɛma ra sɛrɛxɛbade sɛɛti firinyie ma, a dɛ kiri labe ra, wuri kuyee soma naxee kui a xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A naxa na wurie yailan kasiya wuri ra, a naxa xɛɛma maso e ma. ");
INSERT INTO sus_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A naxa ture sɛniyɛnxi nun surayi xiri fanyi yailan naxan nawalima sɛrɛxɛdubɛ tife ra. Na wali xa raba a fanyi ra alɔ labundɛ rafalɛ a rafalama ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","A naxa sɛrɛxɛ gan daaxi sɛrɛxɛbade yailan kasiya wuri ra, naxan kuya nɔngɔn suuli, a igbo nɔngɔn suuli, a sɛɛti birin lan, a ite nɔngɔn saxan. ");
INSERT INTO sus_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A naxa feri naani yailan a tuxui birin ma, naxee findixi se keren na sɛrɛxɛbade ra. A naxa wure gbeeli maso na birin ma. ");
INSERT INTO sus_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A naxa sɛrɛxɛbade yirabase birin yailan wure gbeeli ra, alɔ xube sasee, pelie, pɔɔtie, sube sɔxɔsee, nun tundee tɛ sama naxee kui. ");
INSERT INTO sus_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A naxa se nde yailan wure gbeeli ra naxan sama tɛ xun ma, sube sama naxan fari. A naxa suxuse digilinxie wure gbeeli daaxi sa a tuxui ma, ");
INSERT INTO sus_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","alako a xa gbaku sɛrɛxɛbade kui a tagi. ");
INSERT INTO sus_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A naxa wuri kuyee yailan kasiya wuri ra wure gbeeli masoxi e ma. ");
INSERT INTO sus_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A naxa e raso suxuse digilinxi naanie kui sɛrɛxɛbade sɛɛti firinyie ma a xaninfe ra. ");
INSERT INTO sus_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A naxa hɔrɔmɔlingira ye sase xungbe nun a dɔxɔse yailan wure gbeeli ra, a naxan sɔtɔ ginɛe ra naxee nu malanma hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","A naxa tɛtɛ yailan suwa dugi ra. Tɛtɛ kuya nɔngɔn kɛmɛ yirefanyi mabiri ra. ");
INSERT INTO sus_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","A naxa gɛrɛ dugi gbaku na wuri mɔxɔɲɛn ma, naxee tixi sanbunyi wure gbeeli daaxie ma. Na dugi suxusee naxa yailan gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tɛtɛ kuya nɔngɔn kɛmɛ kɔɔla fan mabiri ra. A naxa gɛrɛ dugi gbaku na wuri mɔxɔɲɛn ma, naxee tixi sanbunyi wure gbeeli daaxie ma. Na dugi suxusee xa yailan gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Tɛtɛ igbo nɔngɔn tongo suuli sogegorode mabiri ra. A naxa gɛrɛ dugi gbaku na wuri fu ma, naxee tixi sanbunyi wure gbeeli daaxie ma. ");
INSERT INTO sus_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Tɛtɛ igbo nɔngɔn tongo suuli sogetede fan mabiri ra. ");
INSERT INTO sus_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A naxa gɛrɛ dugi gbaku sɛɛti ma wuri saxan ma, naxee tixi sanbunyi ma. Na kuyɛ nɔngɔn fu nun suuli. ");
INSERT INTO sus_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A naxa gɛrɛ dugi gbɛtɛ gbaku boore sɛɛti ma wuri saxan ma, naxee tixi sanbunyi ma. Na fan kuyɛ nɔngɔn fu nun suuli. ");
INSERT INTO sus_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tɛtɛ naxa yailan suwa dugi ra. ");
INSERT INTO sus_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Wuri naxee tixi tɛtɛ ma, e tixi e sanbunyi wure gbeeli daaxie ma. Dugi suxusee fan na e ma naxee yailanxi gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Tɛtɛ sode dɛ naxa yailan suwa dugi ra naxan masɔxɔxi gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra. Na dugi kuya nɔngɔn mɔxɔɲɛn, a ite nɔngɔn suuli, alɔ tɛtɛ dugi birin xa maite. ");
INSERT INTO sus_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A naxa na gbaku wuri naani ma, naxee tixi e sanbunyi wure gbeeli daaxie ma. Na dugi suxusee nun na wuri xunyie yailanxi gbeti ra. ");
INSERT INTO sus_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Hɔrɔmɔlingira nun tɛtɛ luuti xirima se naxee ma, nee birin yailan wure gbeeli nan na. ");
INSERT INTO sus_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hɔrɔmɔlingira, seede walaxɛ na naxan kui, a wali dɛntɛgɛ nan yi ki. Lewi bɔnsɔɛ na wali raba Munsa xa yaamari nan bun ma. Haruna xa di, Itamari nan findi na wali yarerati ra. ");
INSERT INTO sus_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleli, Uri xa di, Xuru xa mamadi, Yuda bɔnsɔɛ, naxa Alatala xa yaamari birin naba, a naxan masen Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiyabu, Axisamaki xa di, Dana bɔnsɔɛ, findi Besaleli malima nan na. A nu fata se masolide nun suwa dugi masɔxɔde gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli daaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Xɛɛma xasabi naxan nawalixi hɔrɔmɔlingira tife ra, naxan sɔtɔ hadiya ra, a lan kilo kɛmɛ solomanaani kilo tongo solomanaani nan ma hɔrɔmɔlingira maniyase sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Gbeti xasabi naxan sɔtɔ mixi kɔntixie ra, na lan nɛ kilo wulu saxan kilo kɛmɛ solomasaxan nun tongo solofere nun suuli nan ma hɔrɔmɔlingira maniyase sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Mixi wulu kɛmɛ senni mixi wulu saxan kɛmɛ suuli tongo suuli, naxee nu bara ɲɛ mɔxɔɲɛn sɔtɔ nun na xanbi, naxee kɔntixi Isirayilakae tagi, kankan naxa gbeti giramu senni fi hɔrɔmɔlingira maniyase sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","E naxa gbeti kilo wulu saxan kilo kɛmɛ naani raxunu wuri sanbunyi kɛmɛ yailanfe ra hɔrɔmɔlingira nun tɛtɛ bɛ. Wuri sanbun keren findi gbeti kilo tongo saxan nun naani nan na. ");
INSERT INTO sus_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na kilo mɔxɔɲɛn naxan lu, na naxa yailan dugi nun wuri suxusee nun wuri xunyie ra. ");
INSERT INTO sus_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Wure gbeeli xasabi naxan sɔtɔ Isirayila xa hadiya ra, a lan kilo wulu firin kilo kɛmɛ naani nun solofere. ");
INSERT INTO sus_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E naxa a findi hɔrɔmɔlingira sode dɛ wuri sanbunyie ra, nun sɛrɛxɛbade wure gbeeli daaxi, nun na xa yirabase birin, ");
INSERT INTO sus_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","nun tɛtɛ wuri sanbunyie, nun a sode dɛ xa wuri sanbunyie, nun tɛtɛ maxirisee ra. ");
INSERT INTO sus_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","E naxa sose sɛniyɛnxie dɛgɛ Haruna nun sɛrɛxɛdubɛe bɛ naxee walima hɔrɔmɔlingira kui. Na sose yailanxi gɛsɛ gɛrɛ daaxi, bulu daaxi, a gbeeli, nun suwa dugi ra, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","E donma kuye yailan nɛ xɛɛma gɛsɛ ra, gɛsɛ gɛrɛ daaxi, bulu daaxi, a gbeeli, nun suwa dugi ra. ");
INSERT INTO sus_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","E naxa xɛɛma kebela itala, e a ixaba e a yailan waya ra. E naxa gɛsɛ gɛrɛ daaxi, bulu daaxi, a gbeeli, nun suwa dugi masɔxɔ na waya ra. A findi wali tofanyi nan na. ");
INSERT INTO sus_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","E naxa tunki raxunmase firin yailan naxee xirima donma kuye ra. ");
INSERT INTO sus_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Bɛlɛti fan yailan na ki nɛ gɛsɛ gɛrɛ daaxi, bulu daaxi, a gbeeli, nun suwa dugi ra. Na bɛlɛti nun donma findi keren na. Na birin yailanxi alɔ Alatala Munsa yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","E naxa onixi gɛmɛe rawali, e naxa e rabilinyi findi xɛɛma ra. E naxa Isirayila xa die xili masoli e ma, alɔ e sɛbɛli masolima xurundɛ ma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E naxa e sa tunki raxunmasee ma, e xa findi tɔnxuma see ra Isirayila xa die xa fe ma, alɔ Alatala Munsa yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","E donma kanke raxunmase yailan nɛ a fanyi ra alɔ donma kuye. E na suwa dugi sɔxɔ xɛɛma gɛsɛ, gɛsɛ gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra. ");
INSERT INTO sus_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","A xa kuyɛ nun a xa igboya lan nɛ suxui keren ma, a findi dugi firin na. ");
INSERT INTO sus_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gɛmɛ tofanyie safɛ naani nu na a ma. Safɛ singe findi gɛmɛe nan na, naxee xili sariduwani, topasi, nun emerode. ");
INSERT INTO sus_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Safɛ firin nde, esikaribukulu, safiri, nun diyaman. ");
INSERT INTO sus_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Safɛ saxan nde, opale, agati, nun ametisite. ");
INSERT INTO sus_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Safɛ naani nde, kirosolite, onixi, nun yasipe. Xɛɛma nu na na gɛmɛ birin rabilinyi ma. ");
INSERT INTO sus_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Isirayila xa die xilie masoli na gɛmɛ fu nun firin ma, alɔ sɛbɛli masolima xurundɛ ma ki naxɛ. Kankan xili masoli gɛmɛ nde ma. E findi Isirayila bɔnsɔɛ fu nun firinyi matɔnxuma se nan na. ");
INSERT INTO sus_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","E luuti die dɛgɛ nɛ na donma kanke raxunmase ma, naxee yailanxi xɛɛma ra. ");
INSERT INTO sus_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","E xurundɛ firin yailan xɛɛma ra, e e dɛgɛ donma kanke raxunmase ma a dɛ kiri firinyie ma a fuge ra. ");
INSERT INTO sus_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","E na luuti xɛɛma daaxie xiri na xurundɛ firinyie ma, naxee dɛgɛxi donma kanke raxunmase dɛ kiri ma. ");
INSERT INTO sus_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","E man na luuti firinyie xiri donma kuye tunki raxunmasee ma. ");
INSERT INTO sus_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","E xurundɛ firin gbɛtɛ yailan xɛɛma ra, naxee dɛgɛma donma kanke raxunmase dɛ kirie ma a labe ra. E nee dɛgɛ donma kuye sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","E man naxa xurundɛ firin gbɛtɛ yailan xɛɛma ra, naxee dɛgɛma tunki raxunmasee labe ra, dɛnnaxɛ ilanma bɛlɛti ra. ");
INSERT INTO sus_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Donma kanke raxunmase naxa xiri donma kuye ma luuti gɛrɛ daaxi ra naxan nasoma xurundɛe kui naxee dɛgɛxi donma kanke raxunmase nun donma kuye ma, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","E naxa sɛrɛxɛdubɛ xa donma kuye bun magoroe sɔxɔ gɛsɛ gɛrɛ daaxi ra. ");
INSERT INTO sus_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","E naxa a xunyi rasode xaba a tagi, e na sode dɛ masɔxɔ, alako bɔɔde yo naxa lu a ma. ");
INSERT INTO sus_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E naxa a raxunma pirinti gɛrɛ daaxi, bulu daaxi, nun a gbeeli ra naxee misaalixi wuri bogi ra a rabilinyi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","E naxa tɔlɔnyi xɛɛma daaxie dɛgɛ na pirintie tagi, alako tɔlɔnyi nde xa lu wuri bogi birin tagi na donma kuye bun magoroe sanbunyi birin ma. ");
INSERT INTO sus_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Tɔlɔnyi nde lu wuri bogi birin tagi na donma kuye bun magoroe sanbunyi birin ma, alako sɛrɛxɛdubɛ xa wali raba alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","E naxa donma kuye bun magoroe gbɛtɛ dɛgɛ suwa dugi ra, naxan sɔxɔxi a fanyi ra, Haruna nun a xa di xɛmɛe bɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Xunmasee naxa yailan suwa dugi ra. E naxa wantan bun soe fan dɛgɛ suwa dugi ra. ");
INSERT INTO sus_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","E naxa bɛlɛti yailan suwa dugi ra, naxan masɔxɔxi a gɛrɛ daaxi, a bulu daaxi, nun a gbeeli ra, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","E naxa walaxɛ lanmadi yailan xɛɛma ra, a findi tɔnxuma sɛniyɛnxi ra. E naxa sɛbɛli masoli a ma, alɔ e sɛbɛli masolima xurundɛ ma ki naxɛ, a masenfe ra, «Mixi sɛniyɛnxi Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E naxa a xiri gɛsɛ gɛrɛ daaxi nun gɛsɛ bulu daaxi ra xunmase ma a tigi ra, alɔ Alatala Munsa yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Hɔrɔmɔlingira xa wali raɲɔn na ki nɛ, Ala mixi lima dɛnnaxɛ. Isirayilakae a birin naba nɛ alɔ Alatala Munsa yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","E naxa hɔrɔmɔlingira xanin Munsa xɔn ma nun a se birin: tɛtɛ nun a see, suxusee, xebenyie, wuri kuyee mɔɔli firin, wuri sanbunyie, ");
INSERT INTO sus_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","hɔrɔmɔlingira makotosee, naxan yailanxi yɛxɛɛ kontonyi kiri gbeeli ra, a nun naxan yailanxi peremui kiri ra, dugi naxan gbakuxi yire sɛniyɛnxi fisamante sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","saatɛ kankira nun a xa wuri kuyee, seede kankira dɛrakote, ");
INSERT INTO sus_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","teebili, teebili xa yirabase birin, taami naxan sama teebili fari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","lanpui dɔxɔse xɛɛma daaxi, lanpuie nun e yirabase birin, lanpui ture, ");
INSERT INTO sus_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Surayi sɛrɛxɛbade xɛɛma daaxi, ture sɛniyɛnxi, surayi, dugi naxan gbakuxi tɛtɛ sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","sɛrɛxɛbade wure gbeeli daaxi, a xa wuri kuyee, wuree sube sama naxee fari, a xa yirabase birin, ye sase xungbe nun a dɔxɔse, ");
INSERT INTO sus_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","tɛtɛ dugie, wurie dugie gbakuma naxee ma nee sanbunyie, dugi naxan gbakuxi hɔrɔmɔlingira sode dɛ ra, luutie, wurie luutie xirima naxee ra, a nun hɔrɔmɔlingira xa yirabase birin, Ala maxandi yire, ");
INSERT INTO sus_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","sɛrɛxɛdubɛe xa sose naxee rawalima yire sɛniyɛnxi kui, Haruna nun a xa die xa sose sɛniyɛnxie naxee rawalima e xa sɛrɛxɛdubɛ wali kui. ");
INSERT INTO sus_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isirayilakae naxa na wali birin naba, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Munsa to na wali birin to a rabaxi alɔ Alatala a yamari ki naxɛ, a naxa duba Isirayilakae bɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Kike singe xi singe, i xa hɔrɔmɔlingira ti, Ala wo lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I xa saatɛ kankira dɔxɔ na kui dugi xanbi ra. ");
INSERT INTO sus_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","I xa teebili yailan mɛnni, i fa see dɔxɔ a ma a raba ki ma. I xa lanpui dɔxɔse ti naa, i fa lanpuie dɔxɔ a fari. ");
INSERT INTO sus_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","I xa surayi sɛrɛxɛbade xɛɛma daaxi dɔxɔ saatɛ kankira ya ra, i fa dugi gbaku hɔrɔmɔlingira sode dɛ ra Ala maxandi yire. ");
INSERT INTO sus_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","I xa sɛrɛxɛbade dɔxɔ hɔrɔmɔlingira sode ya ra, Ala wo lima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","I xa ye sase xungbe dɔxɔ hɔrɔmɔlingira nun sɛrɛxɛbade tagi, i fa ye sa a kui. ");
INSERT INTO sus_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","I xa hɔrɔmɔlingira tɛtɛ ti, i fa dugi gbaku tɛtɛ sode dɛ ra.» ");
INSERT INTO sus_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«I na gɛ na ra, i xa ture sɛniyɛnxi tongo, i fa a sa hɔrɔmɔlingira nun a kui se birin ma, e xa sɛniyɛn Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","I man xa na raba sɛrɛxɛbade nun a yirabase birin ma. E xa sɛniyɛn Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","I man xa na raba ye sase xungbe nun a dɔxɔse ma, e xa sɛniyɛn Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«I xa Haruna nun a xa die malan hɔrɔmɔlingira sode dɛ ra, i fa e maxa ye ra. ");
INSERT INTO sus_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","I xa sɛrɛxɛdubɛ sose sɛniyɛnxie ragoro Haruna ma, i fa ture sɛniyɛnxi sa a ma alako a xa findi n ma sɛrɛxɛdubɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","I xa sɛrɛxɛdubɛ sose sɛniyɛnxie ragoro a xa die fan ma, ");
INSERT INTO sus_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","i fa ture sɛniyɛnxi sa e ma alɔ i naxan nabaxi e baba ra, alako e fan xa findi n ma sɛrɛxɛdubɛe ra. Na wali luma e yi ra, a nun naxee fama e xanbi ra abadan.» ");
INSERT INTO sus_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Na tɛmui Munsa naxa Alatala xa yaamari birin naba alɔ a fala a bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kelife e mini Misira bɔxi kui tɛmui naxɛ, ɲɛ firin nde, kike singe, tɛngɛ singe lɔxɔɛ, a naxa hɔrɔmɔlingira ti. ");
INSERT INTO sus_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Munsa naxa hɔrɔmɔlingira sanbunyie sa, a a wuri birin ti, ");
INSERT INTO sus_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","a fa dugie itala hɔrɔmɔlingira xun ma, a nun a makotosee alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Munsa naxa saatɛ walaxɛ firinyie sa saatɛ kankira kui, a fa kankira wurie raso kankira suxuse digilinxie kui, a kankira dɛrakote sa a dɛ ra naxan findixi xunsare yire ra. ");
INSERT INTO sus_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A to gɛ na rabade, a naxa saatɛ kankira xanin hɔrɔmɔlingira kui, a a dɔxɔ yire sɛniyɛnxi fisamante kui. A naxa dugi gbaku na ya ra, alako mixi yo naxa a to alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","A naxa hɔrɔmɔlingira teebili dɔxɔ dugi ya ra a kɔɔla mabiri, ");
INSERT INTO sus_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","a fa taamie sa a fari a safɛ ki ma Alatala ya xɔri alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A naxa lanpui dɔxɔse ti hɔrɔmɔlingira kui teebili ya ra a yirefanyi mabiri, ");
INSERT INTO sus_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","a fa lanpuie ti na fari Alatala ya xɔri alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","A naxa surayi sɛrɛxɛbade dɔxɔ hɔrɔmɔlingira kui dugi gbakuxi a ya ra, ");
INSERT INTO sus_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","a fa surayi gan mɛnni alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","A naxa dugi gbaku hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A naxa sɛrɛxɛbade dɔxɔ hɔrɔmɔlingira sode dɛ ra. A naxa sɛrɛxɛ gan daaxi ba mɛnni nun hadiya alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A naxa ye sase xungbe dɔxɔ hɔrɔmɔlingira nun sɛrɛxɛbade tagi, a ye sa a kui marasɛniyɛnyi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Munsa, Haruna, nun Haruna xa die nu luma e bɛlɛxɛe nun e sanyie maxa ra naa, ");
INSERT INTO sus_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","e soma hɔrɔmɔlingira kui tɛmui naxɛ, a nun e sɛrɛxɛ bama tɛmui naxɛ alɔ Alatala Munsa yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Munsa naxa tɛtɛ rabilin hɔrɔmɔlingira nun sɛrɛxɛbade ra, a fa dugi gbaku tɛtɛ sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Munsa to gɛ na birin na, nuxui naxa din hɔrɔmɔlingira xun ma, Ala e lima dɛnnaxɛ. Alatala xa nɔrɛ naxa hɔrɔmɔlingira rafe, ");
INSERT INTO sus_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","han na naxa a niya Munsa mu nu nɔma sode na kui. Alatala xa nɔrɛ nu bara na rafe, nuxui fan nu radinxi na birin xun ma. ");
INSERT INTO sus_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kelife na tɛmui e xa biyaasie kui, Isirayilakae mu ɲɛrɛ fɔlɔma fo nuxui na keli hɔrɔmɔlingira xun ma. ");
INSERT INTO sus_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Xa nuxui mu te hɔrɔmɔlingira xun ma, Isirayilakae mu ɲɛrɛ raminima sigafe yire gbɛtɛ. ");
INSERT INTO sus_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Alatala xa nuxui nu luma hɔrɔmɔlingira xun ma yanyi nun kɔɛ ra. Isirayilakae nu tɛ dɛxɛxi toma nuxui kui kɔɛ ra. A lu na ki nɛ e xa biyaasi birin kui.");
INSERT INTO sus_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Alatala naxa Annabi Munsa xili a xa hɔrɔmɔlingira kui, a a masen a bɛ, ");
INSERT INTO sus_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«A fala Isirayilakae bɛ, naxan na wa sɛrɛxɛ bafe n tan Alatala bɛ, a xa xuruse lanma xa na mu a ra xuruse xungbe ba. ");
INSERT INTO sus_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Xa a wama xuruse xungbe nan bafe sɛrɛxɛ gan daaxi ra, fo a xa findi tuura ra lanyuru mu na naxan ma. A xa fa na ra n tan Alatala xa hɔrɔmɔlingira sode dɛ ra, alako n xa a tongo. ");
INSERT INTO sus_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Sɛrɛxɛba xa a bɛlɛxɛ sa xuruse xun tagi, alako n tan Alatala xa na sɛrɛxɛ tongo, a xa findi a xunsare ra a xa yunubi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Na tuura xa faxa n tan Alatala ya i. Haruna xa di sɛrɛxɛdubɛe xa fa na tuura wuli ra, e xa a kasan sɛrɛxɛbade sɛɛtie ma, sɛrɛxɛbade naxan na n ma hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","E xa tuura bura, e fa a isɛgɛ. ");
INSERT INTO sus_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Haruna xa di sɛrɛxɛdubɛe xa yege radɔxɔ, e tɛ radɛxɛ. ");
INSERT INTO sus_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","E man xa sɛrɛxɛ sube, a xunyi, nun a ture sa tɛ i sɛrɛxɛbade. ");
INSERT INTO sus_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A furingɛ nun a sanyie xa raxa. Sɛrɛxɛdubɛ xa na birin gan sɛrɛxɛbade. Sɛrɛxɛ gan daaxi na a ra naxan xiri rafan n tan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Xa mixi wama sɛrɛxɛ gan daaxi bafe xuruse lanma ra, a xa findi yɛxɛɛ kontonyi ra, xa na mu a ra sikɔtɛ, lanyuru mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Sɛrɛxɛba xa na kɔn naxaba sɛrɛxɛbade kɔɔla mabiri n tan Alatala ya i. Haruna xa di sɛrɛxɛdubɛe xa a wuli tongo, e xa a kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","E na gɛ sube ixabade, sɛrɛxɛdubɛ xa a sube, a xunyi, nun a ture sa tɛ sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Sɛrɛxɛba xa sɛrɛxɛ furingɛ nun a sanyie raxa. Sɛrɛxɛdubɛ xa na birin gan sɛrɛxɛbade. Sɛrɛxɛ gan daaxi na a ra naxan xiri rafan n tan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Xa a wama xɔni bafe sɛrɛxɛ gan daaxi ra n tan Alatala bɛ, fo a xa findi kolokonde nan na, xa na mu a ra ganbɛ yɔrɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Sɛrɛxɛdubɛ xa fa a ra sɛrɛxɛbade, a a xunyi bolon a dɛ i, a a sa tɛ, a a gan. A wuli xa ifili sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A xa a gɛmɛ bɔɔtɔ ba, a a wɔlɛ tɛ i xube xun, sɛrɛxɛbade sogetede mabiri ra. ");
INSERT INTO sus_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Sɛrɛxɛdubɛ xa a suxu a gabutenyie ma, a a ibɔɔ. A xa a gan, a findi sɛrɛxɛ gan daaxi ra, naxan xiri rafan n tan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Xa mixi wama sɛrɛxɛ bafe n tan Alatala bɛ naxan findixi sansi xɔri ra, a xa a luxuta a fanyi ra. A xa ture sa a fari, a surayi fan sa ture fari. ");
INSERT INTO sus_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","A xa na so Haruna xa di sɛrɛxɛdubɛe yi ra. Sɛrɛxɛdubɛ nde xa sansi xɔri luxutaxi bɛlɛxɛ ya keren kɔ, ture saxi naxan fari, a nun surayi, a xa a sa tɛ i. Na xa gan n tan Alatala bɛ, a xa findi tɔnxuma ra na sɛrɛxɛ birin xa fe ra. Sɛrɛxɛ gan daaxi na a ra naxan xiri rafan n tan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Sansi xɔri luxutaxi naxan luxi naa findima Haruna nun a xa die nan gbe ra. A sɛniyɛn barima a baxi sɛrɛxɛ ganxi nan na naxan baxi n tan Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Xa mixi wama sɛrɛxɛ bafe n tan Alatala bɛ naxan findixi taami ganxi ra, a xa na yailan sansi xɔri luxutaxi ra lɛbini mu na naxan xun. Ture xa masunbu na fan na. Taami lɛbinitare xunxurie fan nɔma yailande, ture masoxi naxee ma.» ");
INSERT INTO sus_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Xa mixi wama sɛrɛxɛ bafe naxan findixi taami gilinxi ra, a xa na yailan sansi xɔri luxutaxi ra lɛbini mu na naxan xun. Ture xa masunbu na fan na. ");
INSERT INTO sus_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","A na gɛ gilinde, a xa igira, ture sa a ma, a xa findi sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Xa mixi wama sɛrɛxɛ bafe naxan findixi taami ra naxan ganxi tunde kui, a xa na yailan sansi xɔri luxutaxi nun ture ra. ");
INSERT INTO sus_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","A lanma mixi xa fa na sɛrɛxɛ mɔɔli ra n tan Alatala bɛ. Xa na bara so sɛrɛxɛdubɛ yi ra, a na xaninma sɛrɛxɛbade. ");
INSERT INTO sus_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","A xa nde tongo naxan findima tɔnxuma ra, a xa na gan sɛrɛxɛbade fari, a xa findi sɛrɛxɛ ra, naxan xiri rafan n tan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Sansi xɔri dinxi naxan luxi a findima Haruna nun a xa die nan gbe ra. A sɛniyɛn barima a baxi sɛrɛxɛ ganxi nan na naxan baxi n tan Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Sɛrɛxɛ naxan birin bama n tan Alatala bɛ, lɛbini yo naxa lu a xun. A mu lan wo xa sɛrɛxɛ gan daaxi yo ba n tan Alatala bɛ lɛbini na naxan xun, xa na mu a ra kumi. ");
INSERT INTO sus_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Wo nɔma lɛbini nun kumi sade sansi bogi singee xun ma naxee bama sɛrɛxɛ ra n tan Alatala bɛ, kɔnɔ e naxa gan sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Fɔxɔɛ xa sa na sɛrɛxɛ mɔɔli birin ma, barima na bara findi saatɛ tɔnxuma ra wo tan nun wo Marigi Ala tagi. Fɔxɔɛ xa sa wo xa sɛrɛxɛ birin ma.» ");
INSERT INTO sus_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Xa wo wama sɛrɛxɛ bafe n tan Alatala bɛ wo xa sansi bogi singe ra, wo xa tɔnsɔɛ nɛɛnɛ gan, ");
INSERT INTO sus_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","wo ture nun surayi sa a xun, a xa findi sansi bogi singe sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sɛrɛxɛdubɛ xa nde tongo na sansi xɔri, ture, nun surayi ra, na xa findi tɔnxuma ra. A xa na gan sɛrɛxɛbade fari. A xa findi sɛrɛxɛ ra, naxan xiri rafan n tan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Xa mixi wama xuruse xungbe bafe xanunteya sɛrɛxɛ ra n tan Alatala bɛ, xuruse xɛmɛma, xa na mu a ra ginɛma, a xa findi xuruse ra lanyuru yo mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","A xa a bɛlɛxɛ sa na xuruse xun tagi n tan Ala xa hɔrɔmɔlingira sode dɛ ra, a a kɔn naxaba. Haruna xa di sɛrɛxɛdubɛe xa na xuruse wuli kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Xanunteya sɛrɛxɛ kui, a lanma ture naxan na furingɛ sɛɛti ma, a xa gan tɛ i n tan Alatala ya i, ");
INSERT INTO sus_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","a nun a gungui firinyi, e ture, nun laare naxan na a bɔɲɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Haruna xa die xa na birin gan sɛrɛxɛ gan daaxi xun ma, naxan na ganfe sɛrɛxɛbade fari. A xa findi se xiri ɲɔxunmɛ ra n tan Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Xa mixi wama xuruse lanma bafe xanunteya sɛrɛxɛ ra n tan Alatala bɛ, xuruse xɛmɛma, xa na mu a ra ginɛma, a xa findi xuruse ra lanyuru yo mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Xa mixi wama yɛxɛɛ bafe sɛrɛxɛ ra, a xa na masen n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A xa a bɛlɛxɛ sa a xun tagi, a fa a kɔn naxaba n tan Ala xa hɔrɔmɔlingira sode dɛ ra. Haruna xa di sɛrɛxɛdubɛe xa na xuruse wuli kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Yi xanunteya sɛrɛxɛ kui, a lanma a ture, a xuli, ture naxan na furingɛ sɛɛti ma, ");
INSERT INTO sus_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","a gungui firinyi, e ture, nun laare naxan na a bɔɲɛ ma, na birin xa gan tɛ i n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sɛrɛxɛdubɛ xa na gan sɛrɛxɛbade fari. Tɛ xa na birin gan. Na bara findi sɛrɛxɛ gan daaxi ra n tan Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Xa mixi wama si bafe sɛrɛxɛ ra, a xa na masen n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A xa a bɛlɛxɛ sa a xun tagi, a fa a kɔn naxaba n tan Ala xa hɔrɔmɔlingira sode dɛ ra, Haruna xa di sɛrɛxɛdubɛe xa na xuruse wuli kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Yi xanunteya sɛrɛxɛ kui, a lanma a ture naxan na furingɛ sɛɛti ma, ");
INSERT INTO sus_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","a gungui firinyi, e ture, nun laare naxan na a bɔɲɛ ma, na birin xa gan tɛ i n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sɛrɛxɛdubɛ xa na gan sɛrɛxɛbade fari. Tɛ xa na birin gan. Na bara findi sɛrɛxɛ gan daaxi ra n tan Alatala bɛ naxan xiri rafan n ma.» ");
INSERT INTO sus_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Mixi yo naxa sube ture don, mixi yo naxa sube wuli min. Wo sabati dɛdɛ, na bara findi yaamari ra naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«A fala Isirayilakae bɛ, xa mixi nde sa yunubi raba, kɔnɔ a mu keli a ɲanige ma, a xa bira yi sɛriyɛ fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Xa sɛrɛxɛdubɛ kuntigi sa Ala xa yaamari nde matandi, na fa findi yunubi ra ɲama bɛ, a lanma a xa tuura ba sɛrɛxɛ ra n tan Alatala bɛ, lanyuru mu na naxan ma, alako na xa findi yunubi xafari sɛrɛxɛ ra a bɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A xa tuura xanin n tan Ala xa hɔrɔmɔlingira sode dɛ ra n ya i, a a bɛlɛxɛ sa a xun tagi, a fa a kɔn naxaba n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sɛrɛxɛdubɛ kuntigi xa na tuura wuli xanin n ma hɔrɔmɔlingira kui, ");
INSERT INTO sus_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","a a bɛlɛxɛsole ragoro na wuli xɔɔra, a a kasan sanya solofere dugi ya ra naxan gbakuxi yire sɛniyɛnxi ma n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sɛrɛxɛdubɛ xa wuli nde sa ferie ma naxee na surayi sɛrɛxɛbade tunxunyi naani ra, naxan na n tan Alatala ya i n ma hɔrɔmɔlingira kui. Wuli naxan luxi, a xa na ifili sɛrɛxɛ gan daaxi sɛrɛxɛbade lanbanyi ma, naxan na n tan Alatala xa hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","A xa ture birin ba tuura ma naxan findixi yunubi xafari sɛrɛxɛ ra, ture naxan na a furingɛ sɛɛti ma, ");
INSERT INTO sus_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","a gungui firinyi, e ture, nun laare naxan na a bɔɲɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","A xa na raba alɔ xanunteya sɛrɛxɛ rabama ki naxɛ. Sɛrɛxɛdubɛ xa na gan sɛrɛxɛ gan daaxi sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kɔnɔ tuura kiri, a sube, a xunyi, a sanyie, a furingɛ, nun a ɲaɲɛ, ");
INSERT INTO sus_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","na tuura dɔnxɔɛ birin xa xanin ɲama yonkinde fari ma, yire sɛniyɛnxi, tɛ xube wɔlɛma dɛnnaxɛ. Mɛnni a xa gan tɛ ra na tɛ xube fari.» ");
INSERT INTO sus_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Xa Isirayila ɲama birin nan sa n tan Ala xa yaamari nde matandixi, kɔnɔ na mu keli e ɲanige ma, na findima yunubi ra e bɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","E na fahaamui sɔtɔ na ma tɛmui naxɛ, ɲama xa tuura yɔrɛ ba sɛrɛxɛ ra n tan Alatala bɛ hɔrɔmɔlingira sode dɛ ra naxan findima yunubi xafari sɛrɛxɛ ra e bɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ɲama forie xa e bɛlɛxɛ sa tuura xun tagi n tan Alatala ya i, e a kɔn naxaba. ");
INSERT INTO sus_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Sɛrɛxɛdubɛ kuntigi xa na tuura wuli xanin n tan Ala xa hɔrɔmɔlingira kui, ");
INSERT INTO sus_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","a a bɛlɛxɛsole ragoro na wuli xɔɔra, a a kasan sanya solofere dugi ya ra naxan gbakuxi yire sɛniyɛnxi ma n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sɛrɛxɛdubɛ xa wuli nde sa ferie ma naxee nu na sɛrɛxɛbade tunxunyi naani ra, naxan na n tan Alatala ya i n ma hɔrɔmɔlingira kui. Wuli naxan luxi, a xa na ifili sɛrɛxɛ gan daaxi sɛrɛxɛbade lanbanyi ma, naxan na n ma hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A xa ture birin ba tuura ma, a na gan sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A xa yi tuura ba sɛrɛxɛ ra alɔ naxan bama yunubi xafari sɛrɛxɛ ra. E ba ki birin keren. Na kui, sɛrɛxɛdubɛ sɛrɛxɛ bama naxan findima e xunsare ra, alako e xa yunubie xa xafari. ");
INSERT INTO sus_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A xa na tuura xanin ɲama yonkinde fari ma, a xa a gan alɔ boore tuura ganma ki naxɛ. Na findima yunubi xafari sɛrɛxɛ nan na ɲama bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Xa mangɛ nde a Marigi Alatala xa yaamari nde matandi, kɔnɔ na mu keli a ɲanige ma, na findima yunubi ra a bɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","A na fahaamui sɔtɔ na ma tɛmui naxɛ, a xa sikɔtɛ ba sɛrɛxɛ ra, lanyuru mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","A xa a bɛlɛxɛ sa sikɔtɛ xun tagi ma n tan Alatala ya i, a a kɔn naxaba sɛrɛxɛ gan daaxie kɔn naxabama dɛnnaxɛ. Yunubi xafari sɛrɛxɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sɛrɛxɛdubɛ xa a bɛlɛxɛsole ragoro na wuli xɔɔra naxan baxi yunubi xa fe ra, a nde sa ferie ma naxee na sɛrɛxɛ gan daaxi sɛrɛxɛbade tunxunyi naani ra. Wuli naxan luxi, a xa na ifili sɛrɛxɛ gan daaxi sɛrɛxɛbade lanbanyi ma. ");
INSERT INTO sus_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A xa na ture birin gan sɛrɛxɛbade fari, alɔ xanunteya sɛrɛxɛ rabama ki naxɛ. Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama mangɛ bɛ, alako a xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Xa mixi nde sa a Marigi Alatala xa yaamari nde matandi, kɔnɔ na mu keli a ɲanige ma, na findima yunubi ra a bɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","A na fahaamui sɔtɔ na ma tɛmui naxɛ, a xa si ginɛ ba sɛrɛxɛ ra, lanyuru mu na naxan ma, a xa yunubi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","A xa a bɛlɛxɛ sa na yunubi xafari sɛrɛxɛ xun tagi, a a kɔn naxaba sɛrɛxɛ gan daaxie kɔn naxabama dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sɛrɛxɛdubɛ xa a bɛlɛxɛsole ragoro na wuli xɔɔra naxan baxi yunubi xa fe ra, a nde sa ferie ma naxee na sɛrɛxɛ gan daaxi sɛrɛxɛbade tunxunyi naani ra. Wuli naxan luxi, a xa na ifili sɛrɛxɛ gan daaxi sɛrɛxɛbade lanbanyi ma. ");
INSERT INTO sus_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A xa na ture birin ba si ma, alɔ xanunteya sɛrɛxɛ rabama ki naxɛ, a na gan sɛrɛxɛbade fari, a xa findi se xiri ɲɔxunmɛ ra n tan Alatala bɛ. Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama na mixi bɛ, alako a xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Xa a yɛxɛɛ bama yunubi xafari sɛrɛxɛ ra, fo a xa findi yɛxɛɛ ginɛma lanyuru mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A xa a bɛlɛxɛ sa na yunubi xafari sɛrɛxɛ xun tagi, a a kɔn naxaba sɛrɛxɛ gan daaxie kɔn naxabama dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sɛrɛxɛdubɛ xa a bɛlɛxɛsole ragoro na wuli xɔɔra naxan baxi yunubi xafari sɛrɛxɛ ra, a nde sa ferie ma naxee na sɛrɛxɛ gan daaxi sɛrɛxɛbade tunxunyi naani ra. Wuli naxan luxi, a xa na ifili sɛrɛxɛ gan daaxi sɛrɛxɛbade lanbanyi ma. ");
INSERT INTO sus_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A xa na ture birin ba yɛxɛɛ ma, alɔ xanunteya sɛrɛxɛ rabama ki naxɛ, a xa na gan sɛrɛxɛe fari naxee ganma sɛrɛxɛbade fari. Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama na mixi bɛ, alako a xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Xa mixi nde sa a mɛ e seedee xilima kiiti nde ma, kɔnɔ a gundi seedeyaxi fe naxan ma a mu na fala ɲama bɛ, na yunubi luma a xun ma. ");
INSERT INTO sus_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Xa mixi din se sɛniyɛntare ra a mu a kolon, alɔ sube raharamuxi binbi, xa na mu a ra xuruse sɛniyɛntare binbi, xa na mu a ra bubuse sɛniyɛntare binbi, na mixi fan findima nɛ mixi sɛniyɛntare ra, a yunubi sɔtɔ na kui. ");
INSERT INTO sus_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Xa mixi nde sa din se sɛniyɛntare ra naxan kelixi adamadi fate ma, a fa li a mu a kolon na tɛmui, xa a sa a kolon tɛmui naxɛ, a findima sɛniyɛntare ra, a yunubi sɔtɔma na kui. ");
INSERT INTO sus_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Xa mixi nde sa a kali fufafu, fe fanyi xa na mu a ra fe ɲaaxi ra, a fa nɛɛmu na ma, a na ratu na fe ma tɛmui naxɛ, a findima sɛniyɛntare ra, a yunubi sɔtɔ na kui.» ");
INSERT INTO sus_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Naxan na yunubi mɔɔli rabama, a lanma a xa a ti na ra. ");
INSERT INTO sus_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A xa yɛxɛɛ ginɛ, xa na mu a ra si ginɛ ba yɛtɛ ragbilen sɛrɛxɛ ra n tan Alatala bɛ. Na kui sɛrɛxɛdubɛ yunubi xafari sɛrɛxɛ bama a bɛ, alako a xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Xa fɛɛrɛ mu na a yi ra na sɛrɛxɛ xa fe ra, a xa kolokonde firin xa na mu a ra ganbɛ firin ba sɛrɛxɛ ra n tan Alatala bɛ. Keren xa findi yunubi xafari sɛrɛxɛ ra, boore xa findi sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A xa e xanin sɛrɛxɛdubɛ xɔn, sɛrɛxɛdubɛ xa yunubi xafari sɛrɛxɛ nan singe ba. A xa a kɔnyi gira, kɔnɔ a naxa a xunyi ba a dɛ i. ");
INSERT INTO sus_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","A a wuli nde kasanma sɛrɛxɛbade sɛɛti ma, wuli naxan luxi, a na ifilima sɛrɛxɛbade lanbanyi. Yunubi xafari sɛrɛxɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Sɛrɛxɛdubɛ xa na xɔni firin nde ba sɛrɛxɛ gan daaxi ra a raba ki ma. Na kui, sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama a bɛ a xa yunubi rabaxi xa fe ra, alako a xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Xa fɛɛrɛ mu na a yi ra kolokonde firin, xa na mu a ra ganbɛ firin sɔtɔfe ra, a xa sansi xɔri dinxi konbo ya keren nun a tagi ba yunubi xafari sɛrɛxɛ ra. A naxa ture, xa na mu a ra surayi sa na fari de, barima yunubi xafari sɛrɛxɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","A xa na xanin sɛrɛxɛdubɛ xɔn ma, sɛrɛxɛdubɛ suxu keren ganma sɛrɛxɛbade fari tɔnxuma ra. A na rabama sɛrɛxɛe fari naxee ganma sɛrɛxɛbade fari, barima yunubi xafari sɛrɛxɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama a bɛ, alako a xa yunubi rabaxi xa xafari. Sansi xɔri dinxi naxan luxi a findima sɛrɛxɛdubɛ nan gbe ra.» ");
INSERT INTO sus_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Xa mixi nde sa se nde tongo naxan findixi n tan Alatala gbe ra, kɔnɔ a mu a kolon a na yunubi mɔɔli rabaxi, a xa yɛxɛɛ kontonyi ba yɛtɛ ragbilen sɛrɛxɛ ra n tan Alatala bɛ a xa yunubi xa fe ra. A mu lanma lanyuru yo xa lu na yɛxɛɛ ma, a sare fan xa lan sare ma naxan nawalima hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A xa na se tongoxi ragbilen sɛrɛxɛdubɛ ma, a man xa kɔbiri sa na fari. Na findima kɔbiri naxan na, a na se sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na so sɛrɛxɛdubɛ yi ra. Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama a bɛ sikɔtɛ ra naxan findi yɛtɛ ragbilen sɛrɛxɛ ra, alako a xa yunubi xa xafari. ");
INSERT INTO sus_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Mixi naxan yunubi rabama, a n tan Alatala xa yaamari nde matandi, hali a mu a kolon, na bara yunubi sɔtɔ, fo a xa na sare fi. ");
INSERT INTO sus_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A lanma a xa sikɔtɛ ba yɛtɛ ragbilen sɛrɛxɛ ra, lanyuru mu na naxan ma, naxan sare lanma sɛriyɛ ma. Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama a bɛ a xa yunubi xa fe ra, a naxan nabaxi a mu a kolon, alako a xa yunubi xa xafari. ");
INSERT INTO sus_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Na bara findi yɛtɛ ragbilen sɛrɛxɛ ra, barima a yunubi sɔtɔ nɛ n tan Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Xa mixi nde sa yunubi sɔtɔ, a fe ɲaaxi raba n tan Alatala ra, alɔ a ngaxakerenyi madaxufe se nde xa fe ra, naxan nu bara taxu a ra, xa na mu a ra a naxan muɲa, xa na mu a ra a naxan baxi a boore yi ra funmalaya ra, ");
INSERT INTO sus_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","xa na mu a ra se lɔɛxi a naxan toxi, a fa wule fala na xa fe ra kali ra, ");
INSERT INTO sus_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","na yunubi raba mɔɔli lanma a xa na se muɲaxi ragbilen. Xa a muɲaxi nɛ ba, xa a taxuxi nɛ a ra ba, xa se lɔɛxi na a ra a naxan toxi ba, ");
INSERT INTO sus_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","xa se na a ra wule fala naxan ma fe ra kali ra, a xa na ragbilen a kanyi ma keren na, a man xa kɔbiri sa na fari. Na findima kɔbiri naxan na, a na se sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na so na kanyi yi ra. ");
INSERT INTO sus_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","A man xa yɛxɛɛ kontonyi xanin sɛrɛxɛdubɛ yire yɛtɛ ragbilen sɛrɛxɛ ra Alatala bɛ. Fi yo naxa lu na yɛxɛɛ ma, a sare fan xa lan sɛriyɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Na kui sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama a bɛ n tan Alatala ya i, alako a xa yunubi, a naxan nabaxi, na xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Yi yaamari so Haruna nun a xa die yi ra: Sɛriyɛ nan ya sɛrɛxɛ gan daaxi xa fe ra. Sɛrɛxɛ gan daaxi xa lu sɛrɛxɛbade fari kɔɛ ra, a xa gan han gɛɛsɛgɛ. ");
INSERT INTO sus_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Sɛrɛxɛdubɛ xa donma ragoro a ma, a xa wantanyi fiixɛ fanyi so a ra, a xa tɛ xube ba sɛrɛxɛ gan daaxi bun ma, a a sa sɛrɛxɛbade sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","A na gɛ na wali ra, a xa a xa dugi fanyi ba a ma, a xa dugi gbɛtɛ ragoro a ma, alako a xa na tɛ xube xanin ɲama yonkinde fari ma, yire sɛniyɛnxi. ");
INSERT INTO sus_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Tɛ naxan dɛxɛxi sɛrɛxɛbade bun ma, na naxa xuben. Gɛɛsɛgɛ birin sɛrɛxɛdubɛ xa yege radɔxɔ, a xa tɛ xuru, a sɛrɛxɛ gan daaxi sa na fari. A xanunteya sɛrɛxɛe ture fan ganma naa nɛ. ");
INSERT INTO sus_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Na tɛ dɛxɛma tɛmui birin sɛrɛxɛbade bun ma, a mu xubenma.» ");
INSERT INTO sus_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Sɛriyɛ nan ya sansi xɔri dinxi sɛrɛxɛ xa fe ra. Haruna xa die xa fa na sɛrɛxɛ ra sɛrɛxɛbade n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Sɛrɛxɛdubɛ xa suxu keren kɔ sansi xɔri dinxi ra, a nun ture, a nun surayi naxan birin sama a fari, a xa na birin gan sɛrɛxɛ tɔnxuma ra sɛrɛxɛbade fari. Na xiri rafan n tan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Naxan luxi, Haruna nun a xa die xa na don a lɛbinitare ra, hɔrɔmɔlingira tɛtɛ sɛniyɛnxi kui. ");
INSERT INTO sus_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","A mu lanma a xa ɲin lɛbini ra, barima a fatanxi n ma sɛrɛxɛ gan daaxie nan na naxee sɛniyɛnxi han alɔ yunubi xafari sɛrɛxɛ nun yɛtɛ ragbilen sɛrɛxɛ. ");
INSERT INTO sus_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Haruna xa di xɛmɛe nɔma na donde. Yaamari na a ra wo bɔnsɔɛ bɛ naxan mu kanama abadan. Mixi naxan birin a makɔrɛma na sɛrɛxɛ gan daaxie ra naxee bama n tan Alatala bɛ, na kanyie sɛniyɛnma nɛ.» ");
INSERT INTO sus_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Haruna tima sɛrɛxɛdubɛ kuntigi ra lɔxɔɛ naxɛ, a lanma a tan Haruna nun a xa die xa sansi xɔri fanyi dinxi konbo ya keren ba sɛrɛxɛ ra. Na sɛrɛxɛ tagi bama gɛɛsɛgɛ, boore tagi bama nunmare. Na mɔɔli xa raba mixi tima sɛrɛxɛdubɛ kuntigi ra tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Yi sansi xɔri dinxi xa gilin tunde kui, ture xa sa a ma. A na ɲɔn, a xuntunyie xa gan tɛ xɔɔra, a xa findi xiri ɲɔxunmɛ ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Sɛrɛxɛdubɛ naxan findima Haruna ɲɔxɔɛ ra xa na sɛrɛxɛ mɔɔli ba. A xa raba na ki nɛ tɛmui birin n tan Alatala ya i. Na sɛrɛxɛ birin xa gan. ");
INSERT INTO sus_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sɛrɛxɛdubɛ xa sɛrɛxɛ birin xa gan, e naxa na sese don.» ");
INSERT INTO sus_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«Yi yaamari so Haruna nun a xa die yi ra: ‹Sɛriyɛ nan ya yunubi xafari sɛrɛxɛ xa fe ra. Yunubi xafari sɛrɛxɛ kɔn naxabama sɛrɛxɛ gan daaxi kɔn naxabade nɛ, barima se sɛniyɛnxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Sɛrɛxɛdubɛ naxan yunubi xafari sɛrɛxɛ bama, a na donma n tan Ala xa hɔrɔmɔlingira tɛtɛ sɛniyɛnxi nan kui. ");
INSERT INTO sus_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Naxan yo dinma na sɛrɛxɛ ra, na kanyi sɛniyɛnma nɛ. Xa na wuli sa kasan dugi nde ma, na dugi xa xa yire sɛniyɛnxi. ");
INSERT INTO sus_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Xa na sube ɲinma tunde mɔɔli nde kui naxan maniya fɛɲɛ ra, a na gɛ a ɲinde, na tunde xa kana. Xa a ɲinma tunde kui naxan yailanxi yɔxui ra, na tunde xa maxa a fanyi ra ye ra. ");
INSERT INTO sus_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Xɛmɛ sɛrɛxɛdubɛ birin xa na don, barima sɛrɛxɛ sɛniyɛnxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kɔnɔ mixi yo naxa yunubi xafari sɛrɛxɛ don, naxan wuli xaninma hɔrɔmɔlingira kui xunsare ra. Na sɛrɛxɛ mɔɔli xa gan tɛ ra.›» ");
INSERT INTO sus_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Yɛtɛ ragbilen sɛrɛxɛ sɛriyɛ nan ya: Sɛrɛxɛ sɛniyɛnxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Yɛtɛ ragbilen sɛrɛxɛ kɔn naxabama sɛrɛxɛ gan daaxi kɔn naxabade nɛ. A wuli xa kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A ture birin, a xuli, a ture naxan na a furingɛ sɛɛti ma, ");
INSERT INTO sus_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","a gungui firinyi, e ture, nun laare naxan na a bɔɲɛ ma, na birin xa ba sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Sɛrɛxɛdubɛ xa na birin gan sɛrɛxɛbade fari sɛrɛxɛ gan daaxi ra Alatala bɛ. Yɛtɛ ragbilen sɛrɛxɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Xɛmɛ sɛrɛxɛdubɛe nan na donma yire sɛniyɛnxi kui, barima sɛrɛxɛ sɛniyɛnxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Yunubi xafari sɛrɛxɛ nun yɛtɛ ragbilen sɛrɛxɛ, e sɛriyɛ birin keren. Sɛrɛxɛdubɛ naxan na xunsare sɛrɛxɛ baxi, a tan nan na sube donma. ");
INSERT INTO sus_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sɛrɛxɛ gan daaxi kiri fan luma sɛrɛxɛdubɛ yi ra naxan na baxi sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","«Sansi xɔri dinxi sɛrɛxɛ naxan ganxi nun naxan gilinxi, e fan findima sɛrɛxɛdubɛ nan gbe ra, naxan e baxi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Sansi xɔri dinxi sɛrɛxɛ naxan mu ganxi, ture gbansan nan saxi a ma, xa na mu a ra ture mu saxi a ma, nee findima Haruna xa di birin nan gbe ra.» ");
INSERT INTO sus_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Xanunteya sɛrɛxɛe sɛriyɛ nan ya, naxan bama n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Xa mixi nde wama tantui sɛrɛxɛ bafe, a man xa taami lɛbinitaree yailan ture ra, a nun taami xunxurie ture saxi naxee ma, nun taami xunxuri naxee ramulanxi ture ra. ");
INSERT INTO sus_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","A na xanunteya sɛrɛxɛ bama tɛmui naxɛ, naxan findixi tantui sɛrɛxɛ ra, a xa taami fan ɲin lɛbini na naxan xun. ");
INSERT INTO sus_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Nde xa ba na taami mɔɔli birin na, a findi sɛrɛxɛdubɛ gbe ra, naxan xanunteya sɛrɛxɛ wuli kasanma sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Na xanunteya sɛrɛxɛ sube donma a ba lɔxɔɛ nɛ, sese naxa lu han gɛɛsɛgɛ.» ");
INSERT INTO sus_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Xa laayidi sɛrɛxɛ bama, xa na mu a ra sɛrɛxɛ ɲanigexi, na sube xa don a ba lɔxɔɛ nɛ, kɔnɔ xa nde sa lu a nɔma donde gɛɛsɛgɛ fan. ");
INSERT INTO sus_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Xa a dɔnxɔɛ sa lu han na fan kuye iba, na sube xa gan gbiki na xi saxan nde lɔxɔɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Xa mixi nde sa a yɛtɛ xa xanunteya sɛrɛxɛ sube don na xi saxan nde lɔxɔɛ ma, Ala mu a xa sɛrɛxɛ tongoma. A luma alɔ a mu sɛrɛxɛ yo baxi, barima na sube findixi se sɛniyɛntare nan na. Mixi naxan na rabama, a yunubi sɔtɔma na kui.» ");
INSERT INTO sus_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«Sɛrɛxɛ sube naxan dinma se sɛniyɛntare ra, a mu lanma na sube xa don. Fo a xa gan nɛ gbiki. Mixi sɛniyɛnxi nan nɔma na xanunteya sɛrɛxɛ sube donde, ");
INSERT INTO sus_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","kɔnɔ sɛniyɛntare mu nɔma n tan Alatala xa xanunteya sɛrɛxɛ donde, a raminima nɛ Isirayila ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mixi naxan a bɛlɛxɛ dinma se sɛniyɛntare ra naxan kelixi adamadi ma, xa na mu a ra a bɛlɛxɛ din sube sɛniyɛntare ra, xa na mu a ra se gbɛtɛ naxan mu sɛniyɛnxi, xa na kanyi fa n tan Alatala xa xanunteya sɛrɛxɛ don, a raminima nɛ Isirayila ɲama ya ma.» ");
INSERT INTO sus_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«A fala Isirayilakae bɛ, ‹Wo naxa ninge, yɛxɛɛ, nun si ture don. ");
INSERT INTO sus_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Wo nɔma xuruse ture rawalide alɔ wo wama a xɔn ma ki naxɛ xa a faxa a yɛtɛ ma, xa na mu a ra sube xaaɲɛ nde naxa a faxa, kɔnɔ wo mu nɔma a donde. ");
INSERT INTO sus_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Naxan yo ture donma, naxan nɔma rawalide sɛrɛxɛ gan daaxi ra n tan Alatala bɛ, na kanyi raminima nɛ Isirayila ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Wo man mu lanma wo xa xɔni wuli, xa na mu a ra xuruse wuli yo min yire birin wo na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Naxan yo wuli minma, na kanyi raminima nɛ Isirayila ɲama ya ma.›» ");
INSERT INTO sus_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«A fala Isirayilakae bɛ, ‹Naxan xanunteya sɛrɛxɛ bama n tan Alatala bɛ, a xa n tan Alatala gbe fi n ma. ");
INSERT INTO sus_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","A xa na xuruse ture nun a sisi xanin n tan Alatala yire alako a xa gan tɛ ra n tan Alatala bɛ. A lanma a xa na xuruse sisi lintan n tan Alatala ya i a masenfe ra n bɛ, na findixi n tan nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sɛrɛxɛdubɛ xa na ture gan sɛrɛxɛbade fari. Na xuruse kanke luma Haruna nun a xa die nan bɛ. ");
INSERT INTO sus_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Wo xa xanunteya sɛrɛxɛe kui, wo man xa xuruse yirefanyi tabe fi sɛrɛxɛdubɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Xuruse yirefanyi tabe xa findi sɛrɛxɛdubɛ nan gbe ra naxan bara wuli nun ture ba xanunteya sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","N bara natɛ tongo naxan mu kanama abadan, Isirayilakae xa xanunteya sɛrɛxɛe kui, e xuruse kanke naxan lintanxi n tan Ala ya i, a nun xuruse yirefanyi tabe e naxan baxi, na birin xa findi sɛrɛxɛdubɛ Haruna nun a xa die gbe ra. ");
INSERT INTO sus_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Kabi Haruna nun a xa die findi n tan Ala xa sɛrɛxɛdubɛe ra, e na nan sɔtɔma n tan Alatala xa sɛrɛxɛ gan daaxie ya ma. ");
INSERT INTO sus_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","E to findi sɛrɛxɛdubɛe ra, n tan Alatala naxa na yaamari fi Isirayilakae ma. Yaamari na a ra naxan mu kanama abadan.›» ");
INSERT INTO sus_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Sɛriyɛ nan na ki sɛrɛxɛe xa fe ra, sɛrɛxɛ gan daaxi, sansi xɔri dinxi sɛrɛxɛ, yunubi xafari sɛrɛxɛ, yɛtɛ ragbilen sɛrɛxɛ, sɛrɛxɛdubɛ ti sɛrɛxɛ, nun xanunteya sɛrɛxɛ. ");
INSERT INTO sus_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Alatala nu bara na birin masen Annabi Munsa bɛ Turusinina geya fari a to Isirayilakae yamari e xa fa sɛrɛxɛe ra Turusinina gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Haruna nun a xa die xili hɔrɔmɔlingira sode dɛ ra. I xa fa e xa dugi sɛniyɛnxie ra, a nun ture sɛniyɛnxi, tuura naxan bama yunubi xafari sɛrɛxɛ ra, yɛxɛɛ kontonyi firin, nun debe, taami lɛbinitaree na naxan kui. ");
INSERT INTO sus_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","I xa Isirayila ɲama birin malan hɔrɔmɔlingira sode dɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Annabi Munsa naxa Alatala xa yaamari rakamali, ɲama fan naxa e malan hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Annabi Munsa naxa a fala ɲama bɛ, «Alatala bara n yamari n xa yi raba.» ");
INSERT INTO sus_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Annabi Munsa naxa Haruna nun a xa die maso, a naxa e maxa ye ra. ");
INSERT INTO sus_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A naxa dugi sɛniyɛnxie ragoro Haruna ma, a naxa a tagi xiri bɛlɛti ra, a guba ragoro a ma, a sɛrɛxɛdubɛ donma ragoro na fari, a a tagi xiri bɛlɛti ra. ");
INSERT INTO sus_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A naxa kanke makotose ragoro a kɔn ma, a gɛmɛ firin sa na kui naxee findixi Ala waxɔnfe masense ra. ");
INSERT INTO sus_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A naxa xunmase dɔxɔ Haruna xunyi ma, a tɔnxuma sɛniyɛnxi xɛɛma daaxi sa na ma, alɔ Alatala Munsa yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Annabi Munsa naxa ture sɛniyɛnxi tongo, a nde maso Ala xa hɔrɔmɔlingira ma, nun se naxan birin na a kui. A nee rasɛniyɛn na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A naxa ture kasan sɛrɛxɛbade ma sanya solofere, a nun sɛrɛxɛbade yirabasee, ye ragatade xungbe, nun na saxi se naxan fari, alako e xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","A man naxa ture nde sa Haruna xunyi ma, alako Haruna fan xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Annabi Munsa naxa Haruna xa die maso, a dugi sɛniyɛnxie ragoro e fan ma. A naxa e tagi nun e xunyi xiri dugi ra, alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Annabi Munsa to fa tuura yunubi xafari sɛrɛxɛ ra, Haruna nun a xa die naxa e bɛlɛxɛe sa na tuura xun tagi. ");
INSERT INTO sus_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Annabi Munsa naxa a kɔn naxaba, a naxa a wuli nde tongo, a a maso sɛrɛxɛbade ferie ma naxee nu na sɛrɛxɛbade tunxunyi naani ra. A naxa na raba a bɛlɛxɛsole ra, alako a xa sɛrɛxɛbade rasɛniyɛn. A naxa wuli dɔnxɔɛ ifili sɛrɛxɛbade sɛɛtie ma. A sɛrɛxɛbade rasɛniyɛn na ki nɛ barima a findi xunsarade nan na. ");
INSERT INTO sus_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Annabi Munsa man naxa ture tongo naxan nu na ninge furingɛ rabilinyi, a nun laare naxan nu na a bɔɲɛ fari, nun a gungui xɔri firinyie nun e ture. A naxa nee birin sa tɛ i sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kɔnɔ a naxa tuura gundi, a kiri, a sube, nun a ɲaɲɛ gan tɛ ra ɲama yonkinde fari ma, alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Annabi Munsa naxa fa yɛxɛɛ kontonyi ra naxan findi sɛrɛxɛ gan daaxi ra. Haruna nun a xa die naxa e bɛlɛxɛe sa na yɛxɛɛ xun tagi. ");
INSERT INTO sus_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Annabi Munsa naxa a kɔn naxaba, a a wuli nde kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","A naxa yɛxɛɛ ixaba a xuntunyie ra. A naxa a xunyi, a xuntunyie, nun a ture gan tɛ i. ");
INSERT INTO sus_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A naxa yɛxɛɛ furingɛ nun a sanyie raxa, a yɛxɛɛ kontonyi gundi birin gan tɛ ra sɛrɛxɛbade fari sɛrɛxɛ gan daaxi ra, naxan xiri rafan Alatala ma. A na birin naba nɛ alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Annabi Munsa naxa yɛxɛɛ kontonyi firin nde tongo naxan findi sɛrɛxɛdubɛ dɔxɔ sɛrɛxɛ ra. Haruna nun a xa die naxa e bɛlɛxɛe sa na yɛxɛɛ xun tagi. ");
INSERT INTO sus_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Annabi Munsa naxa a kɔn naxaba, a a wuli nde tongo, a a sa Haruna yirefanyi tuli ma, a yirefanyi bɛlɛxɛkura ma, nun a sankura ma. ");
INSERT INTO sus_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","A naxa Haruna xa die fan maso, a naxa wuli nde sa e yirefanyi tulie ma, e yirefanyi bɛlɛxɛkura ma, nun e yirefanyi sankura ma. A naxa a wuli nde kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A naxa na yɛxɛɛ ture tongo, a nun a xuli, a furingɛ ture, laare naxan na a bɔɲɛ fari, a gungui xɔri firinyie nun e ture, nun a yirefanyi tabe. ");
INSERT INTO sus_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Annabi Munsa naxa debe tongo taami lɛbinitaree na naxan kui, naxan nu dɔxɔxi Alatala ya i. A naxa taami lɛbinitare keren ba na, a nun taami keren naxan yailanxi ture ra, a nun taami lanmadi keren. A naxa e sa na yɛxɛɛ ture nun a yirefanyi tabe fari. ");
INSERT INTO sus_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A naxa na birin so Haruna nun a xa die yi ra, e fa na lintan Alatala ya i alako a xa a kolon a gbe na a ra. ");
INSERT INTO sus_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Na dangi xanbi, Annabi Munsa naxa e rasuxu e yi ra, a naxa e sa tɛ sɛrɛxɛbade fari, sɛrɛxɛ gan daaxi nu na dɛnnaxɛ. Sɛrɛxɛdubɛ dɔxɔ sɛrɛxɛ na a ra, naxan gan xiri rafan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Annabi Munsa naxa yɛxɛɛ kontonyi kanke tongo na sɛrɛxɛdubɛ dɔxɔ sɛrɛxɛ ra, a fa na lintan Alatala ya i a masenfe ra a bɛ. Na naxa findi Annabi Munsa gbe ra alɔ Alatala a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Annabi Munsa naxa ture sɛniyɛnxi nde tongo, a nun wuli nde naxan nu na sɛrɛxɛbade fari, a naxa a kasan Haruna nun a xa dugie ma, a a kasan Haruna xa die nun e xa dugie fan ma, alako e tan nun e xa dugie birin xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Munsa naxa a fala Haruna nun a xa die bɛ, «Wo sube ɲin hɔrɔmɔlingira sode dɛ ra, wo xa a don mɛnni, a nun taami naxan na debe kui naxan findi sɛrɛxɛdubɛ dɔxɔ sɛrɛxɛ ra. N bara yaamari fi, Haruna nun a xa die xa na don. ");
INSERT INTO sus_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Taami nun sube naxan luxi, wo xa na dɔnxɔɛ gan. ");
INSERT INTO sus_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Wo naxa keli hɔrɔmɔlingira sode dɛ ra xi solofere bun ma, han wo xa dɔxɔɛ waxati kamalima tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Naxan nabaxi to, Alatala a yamarixi wo yunubi xunsare xa fe nan na. ");
INSERT INTO sus_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Na na a toxi, wo luma hɔrɔmɔlingira sode dɛ ra xi solofere bun ma, kɔɛ nun yanyi, alɔ Alatala n yamarixi a ra ki naxɛ, alako wo naxa faxa.» ");
INSERT INTO sus_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Haruna nun a xa die naxa Alatala xa yaamari birin naba na ki a naxan masenxi e bɛ Annabi Munsa saabui ra. ");
INSERT INTO sus_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Xi solomasaxan lɔxɔɛ, Annabi Munsa naxa Haruna nun a xa die, nun Isirayila forie xili. ");
INSERT INTO sus_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","A naxa a masen Haruna bɛ, «I xa sɛrɛxɛ firin masen Alatala bɛ, tuura di naxan findima yunubi xafari sɛrɛxɛ ra, a nun yɛxɛɛ kontonyi naxan findima sɛrɛxɛ gan daaxi ra, lanyuru mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","I xa a fala Isirayilakae bɛ, ‹Wo xa sikɔtɛ keren ba yunubi xafari sɛrɛxɛ ra. Wo xa tuura di nun yɛxɛɛ di naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxee ma, wo xa e ba sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Wo xa tuura nun yɛxɛɛ kontonyi ba xanunteya sɛrɛxɛ ra Alatala bɛ. Wo xa taami fan ba sɛrɛxɛ ra, ture sunbuxi naxan na. Wo xa na birin ba barima Alatala minima nɛ wo ma to.›» ");
INSERT INTO sus_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ɲama naxa sɛrɛxɛe xanin hɔrɔmɔlingira sode dɛ ra alɔ Annabi Munsa e yamarixi ki naxɛ. E birin naxa e makɔrɛ hɔrɔmɔlingira ra, e ti Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Annabi Munsa naxa a masen e bɛ, «Wo xa Alatala xa yaamari rabatu alako a xa a nɔrɛ masen wo bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Annabi Munsa naxa a masen Haruna bɛ, «I maso sɛrɛxɛbade ra. I xa yunubi xafari sɛrɛxɛ nun sɛrɛxɛ gan daaxi ba xunsare ra i yɛtɛ bɛ, a nun ɲama bɛ. I xa ɲama xa sɛrɛxɛ fan ba e bɛ xunsare ra alɔ Alatala a yamarixi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Haruna to a maso sɛrɛxɛbade ra, a naxa tuura di kɔn naxaba a yɛtɛ yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","A xa die naxa tuura wuli so a yi ra. A naxa a bɛlɛxɛsole rasin wuli xɔɔra, a nde sa ferie ma naxee nu na sɛrɛxɛbade tunxunyi naani ra. A naxa wuli dɔnxɔɛ ifili sɛrɛxɛbade lanbanyi ma. ");
INSERT INTO sus_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Xuruse ture, a gunguie, nun laare naxan na a bɔɲɛ ma, a naxa na birin gan sɛrɛxɛbade fari yunubi xafari sɛrɛxɛ ra alɔ Alatala Annabi Munsa yamarixi a ra ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Kɔnɔ a naxa a sube nun a kiri gan ɲama yonkinde fari ma. ");
INSERT INTO sus_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Na dangi xanbi, Haruna naxa sɛrɛxɛ gan daaxi kɔn naxaba. A xa die naxa na wuli so a yi ra, a fa a kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","E naxa sɛrɛxɛ xuntunyie nun a xunyi so a yi ra, a na birin gan sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A to gɛ a furingɛ nun a sanyie raxade, a naxa e gan e nun sɛrɛxɛ gan daaxi ra sɛrɛxɛbade fari. ");
INSERT INTO sus_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Haruna gɛ xanbi na ra, a naxa ɲama xa sikɔtɛ kɔn naxaba, a xa findi yunubi xafari sɛrɛxɛ ra ɲama bɛ. A na raba nɛ alɔ a a singe raba ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A naxa sɛrɛxɛ gan daaxi ba a sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A naxa sansi xɔri dinxi suxu keren gan sɛrɛxɛbade fari sɛrɛxɛ gan daaxi ba tɛmui gɛɛsɛgɛ. ");
INSERT INTO sus_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","A naxa tuura nun yɛxɛɛ kontonyi kɔn naxaba xanunteya sɛrɛxɛ ra ɲama bɛ. A xa die naxa na wuli so a yi, a a kasan sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","E naxa tuura nun yɛxɛɛ kontonyi ture tongo, naxan na e xuli nun e furingɛ mabiri, a nun e gunguie, a nun laare naxan na e bɔɲɛ ma, ");
INSERT INTO sus_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","e naxa na birin sa sube kanke ma sɛrɛxɛbade fari, e a birin gan. ");
INSERT INTO sus_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haruna naxa sɛrɛxɛ subee kanke nun e yirefanyi tabe ite, a e lintan Alatala ya i a masenfe ra a bɛ, alɔ Annabi Munsa a yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Haruna naxa a bɛlɛxɛe itala, a duba ɲama bɛ. A to yunubi xafari sɛrɛxɛ, sɛrɛxɛ gan daaxi, nun xanunteya sɛrɛxɛ ba, a naxa goro kelife sɛrɛxɛbade sɛɛtie ma. ");
INSERT INTO sus_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Annabi Munsa nun Haruna naxa so hɔrɔmɔlingira kui. E to mini, e naxa duba ɲama bɛ. Na tɛmui Alatala xa nɔrɛ naxa mini ɲama ma. ");
INSERT INTO sus_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Alatala naxa tɛ ragoro sɛrɛxɛbade fari, a sɛrɛxɛ gan daaxi nun ture gan. Ɲama to na to, e naxa e xui ite sɛɛwɛ ra, e e felen bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Haruna xa di firinyie, Nadabo nun Abihu naxa surayi gansee tongo, e tɛ sa e kui, e surayi gan Alatala ya i. Kɔnɔ e mu na tɛ tongo Ala xa sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Na na a to, Alatala naxa tɛ ragoro e ma, e faxa a xa hɔrɔmɔlingira yire sɛniyɛnxi kui. ");
INSERT INTO sus_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Annabi Munsa naxa a fala Haruna bɛ, «Alatala wo rakolonxi nɛ yi ra, a to a fala, ‹Naxee makɔrɛ n na, e xa a kolon n sɛniyɛn, ɲama xa n binya.›» Haruna naxa dundu yen. ");
INSERT INTO sus_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Annabi Munsa naxa Mikayeli nun Elisafan xili, Haruna baba xunya Yusiyɛli xa die. A naxa a fala e bɛ, «Wo xa wo ngaxakerenyie furee xanin ɲama yonkinde fari ma, dɛnnaxɛ makuya yire sɛniyɛnxi ra.» ");
INSERT INTO sus_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","E naxa e furee xanin ɲama yonkinde fari ma, alɔ Annabi Munsa e yamarixi ki naxɛ. E nu bara sɛrɛxɛdubɛ dugie lu e furee ma. ");
INSERT INTO sus_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Annabi Munsa naxa a fala Haruna nun a xa die bɛ, Eleyasari nun Itamari, «Wo naxa wo xunsɛxɛ rabɛɲin, wo naxa wo xa dugie fan ibɔɔ. Wo naxa sese raba naxan nɔma sunnunyi masende yi mixie xa faxɛ xa fe ra, alako Alatala naxa xɔnɔ ɲama ma, a wo fan faxa. Wo ngaxakerenyi Isirayilakae tan nɔma sunnunde yi mixie xa fe ra Alatala naxee faxaxi tɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Wo naxa keli Ala xa hɔrɔmɔlingira sode dɛ ra yi saxanyi, alako wo naxa faxa. Alatala xa mixi sugandixie nan wo tan na.» E naxa Annabi Munsa xa yaamari rabatu. ");
INSERT INTO sus_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Alatala naxa a masen Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Wo na so hɔrɔmɔlingira kui, wo naxa wɛni min. Wo naxa minse yo min naxan mixi siisima, xa na mu a ra wo faxama nɛ. Na sɛriyɛ mu kanama wo bɔnsɔɛ bɛ abadan. ");
INSERT INTO sus_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Na nan a niyama wo nɔma Ala gbe nun adamadi gbe tagi rabade, sɛniyɛnyi nun sɛniyɛntareɲa. ");
INSERT INTO sus_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Na fan a niyama nɛ wo xa nɔ Isirayilakae xarande Alatala xa yaamarie ra, a naxee fixi e ma Annabi Munsa saabui ra.» ");
INSERT INTO sus_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Annabi Munsa naxa a fala Haruna nun a xa di dɔnxɔɛe bɛ, Eleyasari nun Itamari, «Sansi xɔri dinxi naxan baxi sɛrɛxɛ ra Alatala bɛ, kɔnɔ naxan birin mu ganxi tɛ ra, wo xa na don sɛrɛxɛbade fɛ ma. Wo naxa lɛbini sa a xun ma de, barima a sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Wo xa a don yire sɛniyɛnxi, barima a ganxi Alatala bɛ sɛrɛxɛ gan daaxie nan fɛ ma. Na findixi i gbe nun i xa die gbe nan na. Alatala sɛrɛxɛdubɛe yamarixi na nan na. ");
INSERT INTO sus_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Wo man xa sɛrɛxɛ sube kanke nun tabe don yire sɛniyɛnxi nɛ, naxee bara lintan Ala ya i, a masenfe ra a bɛ. Nee findixi wo gbe nan na, i tan, i xa di xɛmɛe, nun i xa di ginɛe. Ala bara na yaamari fi Isirayilakae ma e xa xanunteya sɛrɛxɛe xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ture naxan ganma yo, tabe naxan bama yo, nun kanke naxan lintanma yo, e xa na birin masen Alatala bɛ, na fa findi i gbe nun i xa die gbe ra, alɔ Alatala a yamarixi ki naxɛ. Sɛriyɛ na a ra naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Annabi Munsa to sikɔtɛ xa fe maxɔrin, naxan ba yunubi xafari sɛrɛxɛ ra, a naxa a mɛ a e nu bara a birin gan tɛ ra, a naxa xɔnɔ Eleyasari nun Itamari ma, Haruna xa die naxee mu faxa. A naxa a fala e bɛ, ");
INSERT INTO sus_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Munfe ra wo mu yi yunubi xafari sɛrɛxɛ sube donxi yire sɛniyɛnxi? Sɛrɛxɛ sɛniyɛnxi na a ra Alatala naxan fixi wo ma, alako Isirayila ɲama xa yunubi xa xafari, a findi xunsare ra e bɛ Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Yi sɛrɛxɛ wuli to mu soxi yire sɛniyɛnxi ma hɔrɔmɔlingira kui, a nu lan nɛ wo xa a sube don yire sɛniyɛnxi nɛ, alɔ Ala n yamarixi a ra ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruna naxa Annabi Munsa yaabi, «To e bara e xa yunubi xafari sɛrɛxɛ nun e xa sɛrɛxɛ gan daaxi ba Alatala ya i, kɔnɔ n to bara yi fe xɔrɔxɔɛ mɔɔli sɔtɔ, Alatala nɔma tinde n xa yunubi xafari sɛrɛxɛ sube don to?» ");
INSERT INTO sus_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Annabi Munsa to na yaabi mɛ, a naxa tin a ra. ");
INSERT INTO sus_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Alatala naxa a masen Annabi Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Wo xa a fala Isirayilakae bɛ, sube naxee radaxaxi wo bɛ, nee nan ya: ");
INSERT INTO sus_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Sube tore kanyie naxee tore itaxunxi firinyi ra, e man e xa donse ratema e dɛ i e nu a idon. Wo nɔma na sube mɔɔli donde.» ");
INSERT INTO sus_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","«Kɔnɔ ndee na naxee donse ratema e dɛ i e nu a idon, e tore tan mu itaxunxi firinyi ra. Nee raharamuxi wo ma. Ɲɔxɔmɛ raharamuxi wo ma, barima a donse ratema a dɛ i a nu a idon, kɔnɔ a tore mu itaxunxi firinyi ra. ");
INSERT INTO sus_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Yere maniyɛ nde fan donse ratema a dɛ i a nu a idon, kɔnɔ a tore mu itaxunxi firinyi ra. A raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Yere fan donse ratema a dɛ i a nu a idon, kɔnɔ a tore mu itaxunxi firinyi ra. A raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Xɔsɛ tan, a tore itaxunxi firinyi ra, kɔnɔ a mu donse ratema a dɛ i a nu a idon. A raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Wo naxa na subee don, wo naxa din e binbie ra. E raharamuxi wo ma.» ");
INSERT INTO sus_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Yɛxɛ naxee na ye xɔɔra, wo nɔma naxee donde, nee nan ya: xale kanyi nun bɛlɛ kanyi naxee na baa ma, xa na mu a ra xure kui. ");
INSERT INTO sus_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Kɔnɔ yɛxɛ naxee na baa ma, xa na mu a ra xure kui, bɛlɛ mu na naxee ma, xa na mu a ra xale mu na naxee ma, e raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","E raharamuxi wo ma, wo naxa e sube don. E binbie fan raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yɛxɛ birin bɛlɛ nun xale mu na naxee ma, e raharamuxi wo ma.» ");
INSERT INTO sus_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Xɔni raharamuxie nan ya wo mu lan wo xa naxee don: yubɛ, sɛgɛ, xaruma gbɔntɔɛ, ");
INSERT INTO sus_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","a nun nee maniyɛ birin. ");
INSERT INTO sus_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Xaaxa fan, wo naxa na don a nun a maniyɛ birin. ");
INSERT INTO sus_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Xundi, koofole, a nun tagarantongoe, ");
INSERT INTO sus_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","wo naxa e don a nun nee maniyɛ birin. ");
INSERT INTO sus_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Gbongboe, yedɔnmɛ, ");
INSERT INTO sus_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","laaba, tukɛ, a nun nee maniyɛ birin, wo naxa e don.» ");
INSERT INTO sus_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Nimase gabutenyi nun sanyi na naxee ma, e raharamuxi wo ma. ");
INSERT INTO sus_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kɔnɔ na nimase mɔɔlie ya ma, naxee tuganma, wo nɔma nee tan donde, ");
INSERT INTO sus_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","alɔ katoe, tugumie, nun nee maniyɛ birin. ");
INSERT INTO sus_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Kɔnɔ, nimase gabutenyi nun sanyi na naxee ma, e raharamuxi wo ma.» ");
INSERT INTO sus_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Xa wo dinma sube sɛniyɛntare ra, wo findima mixi sɛniyɛntare ra han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Naxan e binbie maxaninma, na kanyi lan nɛ a xa a xa dugie xa, a man fa findi mixi sɛniyɛntare ra han nunmare ra. Fo a xa a xa dugie xa. ");
INSERT INTO sus_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Sube naxee birin tore mu itaxunxi firinyi ra, a nun naxee donse donma, kɔnɔ a mu gbilenma a rate ra e dɛ i e nu a idon, nee raharamuxi wo ma. Naxan dinma na mɔɔli ra a findima mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sube birin tore mu na naxee bɛ, e e ɲɛrɛ e sanyi naanie xun na, e raharamuxi wo ma. Naxan dinma e binbie ra na findima mixi sɛniyɛntare ra han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","E raharamuxi wo ma. Naxan e binbie maxaninma, na kanyi lan nɛ a xa a xa dugie xa, a man fa findi mixi sɛniyɛntare ra han nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Nimase naxan birin luma yilie kui, e haramuxi wo bɛ. E xilie nan ya: bale, ɲɛnɛ, kasa, ");
INSERT INTO sus_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","bonbolika, koolo, nun nee maniyɛe. ");
INSERT INTO sus_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Na nimase xunxuri mɔɔlie raharamuxi wo ma. Naxan dinma e binbie ra a findima mixi sɛniyɛntare ra han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Xa e binbie sa bira se nde fari, na fan findima se sɛniyɛntare ra, alɔ se sa se wuri daaxi, dugi, xuruse kiri xaraxi, bɛki, xa na mu a ra yirabase nde. A lanma na se mɔɔli xa sa ye xɔɔra han nunmare ra alako a xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Xa na nimase mɔɔli bira fɛɲɛ nde kui, fɛɲɛ nun a kui se birin findima se sɛniyɛntare ra. Na fɛɲɛ xa kana. ");
INSERT INTO sus_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ye naxan nu na na fɛɲɛ kui, a na sa donse nde ma, na donse fan findima se sɛniyɛntare ra. Minse yo naxan nu na na fɛɲɛ kui, a fan findima se sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Xa na nimase mɔɔli binbi bira se yo ma, na findima se sɛniyɛntare ra, alɔ taami ganse, xa na mu a ra tunde. E to findi se sɛniyɛntaree ra, a lanma wo xa e kana. ");
INSERT INTO sus_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kɔnɔ xa e binbi sa bira dulonyi nan kui, xa na mu a ra ye ragatade nde, nee tan mu findima se sɛniyɛntaree ra. Kɔnɔ mixi naxan a bɛlɛxɛ dinma e binbie ra, na findima mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Xa a binbi bira sansi xɔri ma naxan sima, na mu findima se sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Kɔnɔ xa a binbi bira sansi xɔri tan ma naxan na ye xɔɔra, na sansi xɔri findima se sɛniyɛntare ra wo bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Xa xuruse radaxaxi nde faxa, mixi fa din a binbi ra, na kanyi findima sɛniyɛntare ra han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Naxan na a sube don, na kanyi lan nɛ a xa a xa dugie xa, a man fa findi sɛniyɛntare ra han nunmare ra. Naxan na sube binbi maxanin, na kanyi lan nɛ a xa a xa dugie xa, a man fa findi sɛniyɛntare ra han nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Nimase naxan birin a bubuma bɔxi ma, nee birin raharamuxi wo ma. A mu lanma wo xa nee don. ");
INSERT INTO sus_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Bubusee nun nimase xunxuri naxee ɲɛrɛma e sanyi naani xun na, xa na mu a ra e sanyi wuyaxi xun na, e sese mu radaxaxi. Wo naxa e don. ");
INSERT INTO sus_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Wo naxa wo yɛtɛ findi sɛniyɛntare ra na nimase mɔɔli saabui ra. Wo naxa e don. ");
INSERT INTO sus_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Alatala nan n na, wo Marigi Ala. Wo xa wo yɛtɛ fi n tan nan ma. Wo xa sɛniyɛn, barima n tan sɛniyɛn. Wo naxa wo yɛtɛ findi sɛniyɛntare ra na nimase xunxuri saabui ra naxee luma ɲɛrɛ ra bɔxi ma.» ");
INSERT INTO sus_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","«N tan nan Alatala ra naxan wo raminixi Misira bɔxi ma, alako n xa findi wo Marigi Ala ra. Wo xa sɛniyɛn, barima n tan sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Sɛriyɛ nan na ki subee, xɔnie, yɛxɛɛe, nun bubusee xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Na kui wo nɔma sube sɛniyɛnxi nun sube sɛniyɛntare tagi raba kolonde, sube radaxaxi nun sube raharamuxi.» ");
INSERT INTO sus_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«A fala Isirayilakae bɛ, xa ginɛ nde sa tɛɛgɛ, a di xɛmɛ bari, a findima sɛniyɛntare ra xi solofere bun ma, alɔ a kike walima tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Xi solomasaxan lɔxɔɛ, di xa sunna. ");
INSERT INTO sus_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Na xi solofere xanbi, dingɛ luma sɛniyɛntareɲa kui xi tongo saxan nun saxan bun ma a wuli xa fe ra naxan minixi a ma a di bari tɛmui. A mu lanma a xa din se sɛniyɛnxi ra, a mu lanma a xa so yire sɛniyɛnxi kui han marasɛniyɛnyi waxati xa kamali.» ");
INSERT INTO sus_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Xa dingɛ di ginɛ bari, a luma sɛniyɛntareɲa kui lɔxɔxun firin, alɔ a kike walima tɛmui naxɛ. Na xanbi a xa marasɛniyɛnyi waxati buma xi tongo senni nun senni, a wuli xa fe ra naxan minixi a di bari tɛmui. ");
INSERT INTO sus_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A xa marasɛniyɛnyi waxati na kamali, di xɛmɛ, xa na mu a ra di ginɛ xa fe ra, a xa yɛxɛɛ ɲɛ keren daaxi xanin sɛrɛxɛdubɛ xɔn ma hɔrɔmɔlingira sode dɛ ra. A xa na ba sɛrɛxɛ gan daaxi ra. A man xa kolokonde yɔrɛ, xa na mu a ra ganbɛ ba yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Sɛrɛxɛdubɛ xa na sɛrɛxɛe ba Alatala bɛ, a findi na ginɛ xa xunsare ra. Na tɛmui a sɛniyɛnma nɛ na wuli xa fe ra. Sɛriyɛ nan na ki ginɛ bɛ naxan di xɛmɛ barima, xa na mu a ra di ginɛ. ");
INSERT INTO sus_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Xa fɛɛrɛ mu na a yi a xa yɛxɛɛ sɔtɔ, a nɔma ganbɛ firin xaninde, xa na mu a ra kolokonde firin. Keren xa ba sɛrɛxɛ gan daaxi ra, boore xa ba yunubi xafari sɛrɛxɛ ra. Sɛrɛxɛdubɛ xa na ba, a findi xunsare ra ginɛ bɛ, a fa sɛniyɛn.» ");
INSERT INTO sus_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Alatala naxa a masen Annabi Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Xa mixi fate kiri yire nde funtu, xa na mu a ra a fiixɛ, xa na mu a ra a findi fi ra, wo xa na kanyi xanin sɛrɛxɛdubɛ Haruna yire, xa na mu a ra a xa di nde yire. ");
INSERT INTO sus_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Fure naxan na a fate, sɛrɛxɛdubɛ xa na mato. Xa fate xabe bara fiixɛ na fi yire, fi fan bara tilin, a sube li, fure ɲaaxi na a ra. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Xa fure ya mu itilin a na kiri nan gbansan fari, fate xabe mu fiixɛxi na longori, sɛrɛxɛdubɛ xa furema yamari a xa lu a kerenyi ma lɔxɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A xi solofere nde lɔxɔɛ, sɛrɛxɛdubɛ man xa a mato. Xa a sa li fure mu na lantanfe, a man xa furema yamari a xa lu a kerenyi ma lɔxɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","A xi solofere nde lɔxɔɛ, sɛrɛxɛdubɛ man xa a mato a sanmaya firin nde. Xa fure ɲingi bara masara, a man mu lantanfe, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara sɛniyɛn. Fure na a ra naxan mu ɲaaxu. A xa a xa dugie xa, a findi mixi sɛniyɛnxi ra. ");
INSERT INTO sus_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kɔnɔ xa sɛrɛxɛdubɛ bara a mato, fure bara lantan yɛ na masenyi dangi xanbi, furema man xa gbilen sɛrɛxɛdubɛ yire tɛmui gbɛtɛ. ");
INSERT INTO sus_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Sɛrɛxɛdubɛ man xa a mato. Xa fure bara lantan yɛ, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi sɛniyɛntare ra, fure ɲaaxi na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Xa fure ɲaaxi bara lu mixi nde kiri ma, e xa a xanin sɛrɛxɛdubɛ yire. ");
INSERT INTO sus_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","A xa a mato. Xa na mixi kiri bara fiixɛ yire nde, a fa funtu, fate xabe fan fa fiixɛ na longori, a bula, sube mini kɛnɛ ma, ");
INSERT INTO sus_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","fure ɲaaxi na a ra naxan mu dandanma. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra. Hali a mu lu a kerenyi ma waxati di bun ma sɔnɔn, sɛrɛxɛdubɛ man xa a mato. Na tan bara gɛ findide mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Xa sɛrɛxɛdubɛ bara a to a na fi ɲaaxi birin bara bari fɔlɔ, naxan nu na furema fate ma, kelife a sanyie ma han a xunyi, ");
INSERT INTO sus_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","a xa masenyi ti, na kanyi bara sɛniyɛn, barima fi birin bara bari fɔlɔ. A bara sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kɔnɔ xa, fure sa bula, sube mini kɛnɛ ma, na kanyi bara findi mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Sɛrɛxɛdubɛ na fure bulaxi to, a xa masenyi ti, fi bulaxi mu sɛniyɛn, fure ɲaaxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Xa sube bulaxi fa bari, furema xa siga sɛrɛxɛdubɛ yire. ");
INSERT INTO sus_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","A xa a mato. Xa fure bara bari, sɛrɛxɛdubɛ xa masenyi ti, furema bara sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Xa suuri mini mixi ma, a fa yalan, ");
INSERT INTO sus_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kɔnɔ na kiri fa fiixɛ, xa na mu a ra a gbeeli, na kanyi xa siga sɛrɛxɛdubɛ yire. ");
INSERT INTO sus_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","A xa a mato. Xa fure ya bara itilin, a sube li, fate xabe bara fiixɛ na longori, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra. Fure ɲaaxi na a ra, naxan minixi suuri fɔxi. ");
INSERT INTO sus_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Xa sɛrɛxɛdubɛ mu fate xabe fiixɛ to, fi fan mu tilin, a mu sube lixi, a mu fiixɛ a gbe ra, furema xa lu a kerenyi ma lɔxɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Xa fure bara lantan yɛ a fate ma, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra, fure ɲaaxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kɔnɔ xa fure mu masaraxi a mu lantanxi a i, suuri barixi na a ra. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi mixi sɛniyɛnxi na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Xa mixi fate bara gan tɛ ra tɛmui dangixi, a kiri fa bari, kɔnɔ fure gbeeli, xa na mu a ra fure fiixɛ fa mini na fɔxi, ");
INSERT INTO sus_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","sɛrɛxɛdubɛ xa na mato. Xa furema fate xabe bara fiixɛ na fɔxi, fure bara tilin, a sube li, fure ɲaaxi na a ra, naxan bara mini fate ma kiri dɛnnaxɛ nu ganxi. Na sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra, barima fure ɲaaxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kɔnɔ xa sɛrɛxɛdubɛ mu fate xabe fiixɛ to fure ma, fi fan ya mu itilin, a mu sube lixi, a mu fiixɛ a gbe ra, sɛrɛxɛdubɛ xa na kanyi yamari a xa lu a kerenyi ma lɔxɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sɛrɛxɛdubɛ xa a mato xi solofere nde lɔxɔɛ. Xa fure bara lantan yɛ a fate ma, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra, fure ɲaaxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kɔnɔ xa fure mu masaraxi, a mu lantanxi a i, a mu fiixɛ alɔ a singe, a fatanxi na kiri ganxi nan na. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi mixi sɛniyɛnxi na a ra. Nari na a ra kiri dɛnnaxɛ gan.» ");
INSERT INTO sus_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Xa fure lu xɛmɛ, xa na mu a ra ginɛ xunyi ma, xa na mu a ra a kenkenyi ma, ");
INSERT INTO sus_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","sɛrɛxɛdubɛ xa na fure mato. Xa fi ya bara itilin, a sube li, fate xabe fiixɛ, a xurun, sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra. Fure ɲaaxi na a ra naxan bara lu a xunyi ma, xa na mu a ra a kenkenyi ma. ");
INSERT INTO sus_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Xa sɛrɛxɛdubɛ sa a to fure ya mu itilinfe, a mu sube life, fate xabe fɔɔrɛ mu na, a xa furema yamari a xa lu a kerenyi ma xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sɛrɛxɛdubɛ xa na fure mato xi solofere nde lɔxɔɛ. Xa fure mu lantanfe a i, fate xabe mu fiixɛ na longori, fi ya mu itilinxi, a mu sube lixi, ");
INSERT INTO sus_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","na kanyi xa a xunsɛxɛ nun a dɛxabe bi a xa a ba fi ra. Sɛrɛxɛdubɛ man xa furema yamari a xa lu a kerenyi ma lɔxɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sɛrɛxɛdubɛ xa na fure man mato xi solofere nde lɔxɔɛ. Xa a mu lantanxi a i, a ya mu itilinxi, a mu sube lixi, sɛrɛxɛdubɛ xa masenyi ti, na kanyi mixi sɛniyɛnxi na a ra. A xa a xa dugie xa, a sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kɔnɔ sɛrɛxɛdubɛ xa masenyi dangi xanbi, xa fure bara lantan yɛ furema fate ma, ");
INSERT INTO sus_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","sɛrɛxɛdubɛ man xa a mato. Xa fure bara lantan yɛ, hali sɛrɛxɛdubɛ mu fate xabe fiixɛ fen. Na kanyi bara findi mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kɔnɔ xa na fure mu lantanxi a i, fate xabe fɔɔrɛ nde tan bara mini, fure bara yalan. Na kanyi mixi sɛniyɛnxi na a ra. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi mixi sɛniyɛnxi na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Xa xɛmɛ, xa na mu a ra ginɛ fate kiri bara fiixɛ yire ndee, ");
INSERT INTO sus_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","sɛrɛxɛdubɛ xa na mato. Xa na mu fiixɛ a gbe ra, kasi mɔɔli nde gbansan na a ra. A sɛniyɛn.» ");
INSERT INTO sus_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Xa mixi nde xunsɛxɛ bara makɔn, tɛrɛrɛ kanyi na a ra, a mu ɲaaxu. Na kanyi sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Xa mixi nde xunsɛxɛ makɔnxi a tigi dɛ biri gbansan nɛ, tɛrɛrɛ na a ra a mu ɲaaxu. Na kanyi sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kɔnɔ xa fure fiixɛ, xa na mu a ra fure gbeeli mini a xunyi ma, xa na mu a ra a tigi ma, fure ɲaaxi na a ra. ");
INSERT INTO sus_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sɛrɛxɛdubɛ xa na mato. Xa na fure funtu naxan minixi a xunyi ma, a fiixɛ, xa na mu a ra a gbeeli alɔ fure ɲaaxi na ki naxɛ, ");
INSERT INTO sus_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","furema na a ra, a mu sɛniyɛnxi. Sɛrɛxɛdubɛ xa masenyi ti, na kanyi bara findi mixi sɛniyɛntare ra. Fure na a xunyi ma.» ");
INSERT INTO sus_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Na fure ɲaaxi kanyi xa dugi ibɔɔxi ragoro a ma, a xa a xunyi bi, a xa a dɛ xabe makoto a bɛlɛxɛ ra, a nu a fala a xui itexi ra ‹Sɛniyɛntare, Sɛniyɛntare.› ");
INSERT INTO sus_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Danmi na fure ɲaaxi na a ma, a mu sɛniyɛn. Fo a xa lu a kerenyi ma ɲama yonkinde fari ma.» ");
INSERT INTO sus_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Na fure ɲaaxi nɔma lude dugi ma naxan yailanxi xuruse xabe ra, xa na mu a ra gɛsɛ fute ra. ");
INSERT INTO sus_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","A man nɔma lude se nde dɛnbɛxi ma naxan yailanxi xuruse xabe ra, xa na mu a ra gɛsɛ fute ra. A man nɔma lude se nde ma naxan yailanxi xuruse kiri ra. ");
INSERT INTO sus_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Xa na fure bara ifɔɔrɔ, xa na mu a ra a bara gbeeli dugi ma, kiri ma, xa na mu a ra se dɛnbɛxi ma, fure ɲaaxi na a ra. A xa masen sɛrɛxɛdubɛ bɛ, a xa na mato. ");
INSERT INTO sus_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Na fure na se naxan ma, na se xa ragata yire nde a kerenyi ma xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Xi solofere nde lɔxɔɛ sɛrɛxɛdubɛ man xa a mato. Xa na fure bara lantan yɛ i na dugi ma, xa na mu a ra na se dɛnbɛxi ma, xa na mu a ra na kiri ma, fure ɲaaxi na a ra. Na bara findi se sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sɛrɛxɛdubɛ xa se birin gan na fure na se naxan ma, dugi naxan yailanxi xuruse xabe ra, dugi naxan yailanxi gɛsɛ fute ra, dugi dɛnbɛxi, xa na mu a ra kiri. ");
INSERT INTO sus_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kɔnɔ xa sɛrɛxɛdubɛ bara a mato, na fure mu lantanxi na see ma, ");
INSERT INTO sus_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","a xa yaamari fi na see xa maxa ye ra, e xa sa e kerenyi ma xi solofere bun ma sanmaya firin nde. ");
INSERT INTO sus_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","A na gɛ maxade, sɛrɛxɛdubɛ man xa na mato. Xa fure mu masaraxi, hali a man mu lantanxi a i, na findixi se sɛniyɛntare nan na. A birin xa gan tɛ ra, hali fure na a lahalɛ kerenyi gbansan nan ma. ");
INSERT INTO sus_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Xa sɛrɛxɛdubɛ bara a to fure mu fiixɛ alɔ singe, a xa na yire gbansan ba na. ");
INSERT INTO sus_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kɔnɔ xa fure na lantanfe a i dugi ma, xa na mu a ra dugi dɛnbɛxi ma, xa na mu a ra kiri ma, fure ɲaaxi na a ra, fo na xa gan tɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Xa fure bara ba dugi ma, xa na mu a ra dugi dɛnbɛxi ma, xa na mu a ra kiri ma ye ra a firin nde, a bara sɛniyɛn.» ");
INSERT INTO sus_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Sɛriyɛ nan na ki fure ɲaaxi xa fe ra naxan nɔma lude dugi nde ma naxan yailanxi xuruse xabe ra, xa na mu a ra gɛsɛ fute ra, a nun dugi nde ma naxan dɛnbɛxi, a nun kiri nde ma. Na sɛriyɛ nɔma a masende xa se nde sɛniyɛn, xa na mu a mu sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Marasɛniyɛnyi lɔxɔɛ, fure ɲaaxi kanyi xa siga sɛrɛxɛdubɛ xɔn. ");
INSERT INTO sus_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Sɛrɛxɛdubɛ xa siga ɲama yonkinde fari ma na furema matode. Xa a bara yalan, ");
INSERT INTO sus_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","sɛrɛxɛdubɛ xa yaamari fi, a xa fa xɔni ɲiɲɛ radaxaxi firin na, e nun sɛdiri wuri, gɛrɛ mɔɔli nde, nun hisopi wuri furema bɛ. ");
INSERT INTO sus_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sɛrɛxɛdubɛ xa yaamari fi, e xa xɔni keren kɔn naxaba fɛɲɛ nde xun ma, dulon ye na naxan kui. ");
INSERT INTO sus_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","A xa xɔni ɲiɲɛ tongo, a nun sɛdiri wuri, gɛrɛ mɔɔli nde, nun hisopi wuri, a xa e birin dukulu xɔni wuli xɔɔra e naxan kɔn naxabaxi dulon ye xun ma. ");
INSERT INTO sus_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","A xa na kasan sanmaya solofere na furema ma, naxan lanma a xa sɛniyɛn. Sɛrɛxɛdubɛ xa masenyi ti, na mixi bara findi mixi sɛniyɛnxi ra. Na tɛmui a xa xɔni ɲiɲɛ bɛɲin wula i.» ");
INSERT INTO sus_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Naxan wama sɛniyɛnfe, a xa a xa dugie xa, a xa a fate maxabe bi, a xa a maxa ye ra. Na kui, a sɛniyɛnma nɛ. Na dangi xanbi a nɔma sode ɲama yonkinde kui, kɔnɔ a mu nɔma sode a xa kiri banxi tan kui xi solofere. ");
INSERT INTO sus_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Xi solofere nde lɔxɔɛ, a man xa a xunsɛxɛ bi, a dɛ xabe, a ya xinbi xabe, a nun a fate maxabe birin. A man xa a xa dugie xa, a xa a fate maxa. Na kui, a sɛniyɛnma nɛ. ");
INSERT INTO sus_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Xi solomasaxan nde lɔxɔɛ, a xa yɛxɛɛyɔrɛ xɛmɛma firin tongo, a nun yɛxɛɛ ginɛma, ɲɛ keren daaxi, lanyuru mu na naxee ma. A man xa sansi xɔri dinxi konbo ya keren nun a tagi sɔtɔ, ture masunbuxi naxan na, a nun ture sigaati ya keren naxan findima sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sɛrɛxɛdubɛ xa furema nun a xa sɛrɛxɛ ti n tan Alatala ya i hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","A xa yɛxɛɛyɔrɛ keren tongo, a xa a ba yɛtɛ ragbilen sɛrɛxɛ ra, a nun ture sigaati ya keren. A xa nee lintan n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A xa na yɛxɛɛ kɔn naxaba yire sɛniyɛnxi yunubi xafari sɛrɛxɛ nun sɛrɛxɛ gan daaxi bama dɛnnaxɛ. Sɛrɛxɛdubɛ nan gbe yɛtɛ ragbilen sɛrɛxɛ nun yunubi xafari sɛrɛxɛ ra. Sɛrɛxɛ sɛniyɛnxi nan e ra. ");
INSERT INTO sus_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Sɛrɛxɛdubɛ xa yɛtɛ ragbilen sɛrɛxɛ wuli nde tongo, a xa a sa furema yirefanyi tuli ma, a bɛlɛxɛkura yirefanyi ma, nun a sankura yirefanyi ma. ");
INSERT INTO sus_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","A man xa na ture sigaati ya keren ifili a yɛtɛ kɔɔla bɛlɛxɛ kui. ");
INSERT INTO sus_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","A xa a bɛlɛxɛsole yirefanyi sin ture kui, a nu bara naxan sa a kɔɔla bɛlɛxɛ kui, a xa na ture kasan dɔxɔ solofere n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ture naxan luxi sɛrɛxɛdubɛ bɛlɛxɛ kui, a xa nde sa furema yirefanyi tuli ma, a nun a bɛlɛxɛkura yirefanyi ma, a nun a sankura yirefanyi ma yɛtɛ ragbilen sɛrɛxɛ wuli fari. ");
INSERT INTO sus_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ture dɔnxɔɛ naxan luxi sɛrɛxɛdubɛ yi ra, a xa na sa furema xunyi ma. Sɛrɛxɛdubɛ xa a xun sara n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Sɛrɛxɛdubɛ xa yunubi xafari sɛrɛxɛ ba, a xa a xun sara a xa sɛniyɛntareɲa ma. Na dangi xanbi a xa na sɛrɛxɛ gan daaxi kɔn naxaba. ");
INSERT INTO sus_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","A xa sɛrɛxɛ gan daaxi nun sansi xɔri dinxi sɛrɛxɛ ba sɛrɛxɛbade fari. A xa furema xun sara alako a xa sɛniyɛn.» ");
INSERT INTO sus_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Xa setare nan na furema ra, fɛɛrɛ mu na a yi na sɛrɛxɛ xa fe ra, a xa yɛxɛɛyɔrɛ keren gbansan ba yɛtɛ ragbilen sɛrɛxɛ ra, naxan lintanma n tan Alatala ya i a xa findi furema xa xunsare ra. A xa sansi xɔri dinxi konbo ya tagi sɔtɔ, ture masunbuxi naxan na, a nun ture sigaati ya keren, ");
INSERT INTO sus_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","nun ganbɛ firin, xa na mu a ra kolokonde yɔrɛ firin. Keren xa findi yunubi xafari sɛrɛxɛ ra, boore sɛrɛxɛ gan daaxi. ");
INSERT INTO sus_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Xi solomasaxan nde lɔxɔɛ, a xa fa na sɛrɛxɛe ra sɛrɛxɛdubɛ xɔn hɔrɔmɔlingira sode dɛ ra n tan Alatala ya i, alako a xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Sɛrɛxɛdubɛ xa yɛtɛ ragbilen sɛrɛxɛ yɛxɛɛ nun ture sigaati ya keren lintan n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","A xa na yɛxɛɛyɔrɛ kɔn naxaba yɛtɛ ragbilen sɛrɛxɛ ra. A xa a wuli nde tongo, a xa na sa furema yirefanyi tuli ma, a yirefanyi bɛlɛxɛkura ma, a nun a yirefanyi sankura ma. ");
INSERT INTO sus_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","A xa ture nde ifili a yɛtɛ kɔɔla bɛlɛxɛ kui. ");
INSERT INTO sus_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","A xa na ture kasan sanmaya solofere a bɛlɛxɛsole yirefanyi ra n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ture naxan na a bɛlɛxɛ kui, a xa dondoronti tongo, a na sa furema yirefanyi tuli ma, a yirefanyi bɛlɛxɛkura ma, a nun a yirefanyi sankura ma wuli fari naxan keli yɛtɛ ragbilen sɛrɛxɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ture naxan luxi a bɛlɛxɛ kui, a xa na sa na furema xunyi ma, alako a xun xa sara n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sɛrɛxɛdubɛ xa ganbɛ keren ba, xa na mu a ra kolokonde yɔrɛ, sɛrɛxɛe ya ma furema naxee sɔtɔxi. ");
INSERT INTO sus_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","A xa keren ba yunubi xafari sɛrɛxɛ ra, boore xa findi sɛrɛxɛ gan daaxi ra, a nun sansi xɔri dinxi. Sɛrɛxɛdubɛ furema xun sarama n tan Alatala ya i na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Sɛriyɛ nan na ki marasɛniyɛnyi xa fe ra furemae bɛ naxee findixi setaree ra.» ");
INSERT INTO sus_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Alatala naxa a masen Annabi Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Wo na so Kanaan bɔxi ma, n naxan fima wo ma kɛ ra, xa fure ɲaaxi sa mini wo xa banxi kankee ma mɛnni, ");
INSERT INTO sus_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","banxi kanyi xa sa a fala sɛrɛxɛdubɛ bɛ, ‹N bara fure ɲaaxi to n ma banxi ma.› ");
INSERT INTO sus_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sɛrɛxɛdubɛ xa yaamari fi, e xa se birin namini banxi kui beenu a xa siga fure ɲaaxi matode, alako se naxan na banxi kui, na naxa findi se sɛniyɛntare ra. E na gɛ na rabade, sɛrɛxɛdubɛ xa siga na banxi matode.» ");
INSERT INTO sus_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","«Sɛrɛxɛdubɛ xa na fure mato. Xa fure fɔɔrɔ, xa na mu a ra a gbeeli, a man ya naxa itilin, a banxi kanke suxu, ");
INSERT INTO sus_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","sɛrɛxɛdubɛ xa mini banxi kui, a xa banxi naadɛ balan lɔxun keren. ");
INSERT INTO sus_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Xi solofere nde lɔxɔɛ, sɛrɛxɛdubɛ man xa gbilen naa. Xa fure bara lantan yɛ i banxi kanke ma, ");
INSERT INTO sus_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","sɛrɛxɛdubɛ xa yaamari fi, banxi gɛmɛe xa ba na fure na dɛnnaxɛ, e xa e wɔlɛ taa fari ma yire sɛniyɛntare. ");
INSERT INTO sus_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Banxi kanke xa maxɔɔlin banxi kui. Naxan bama, na xa woli taa fari ma yire sɛniyɛntare. ");
INSERT INTO sus_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Gɛmɛ gbɛtɛe xa sa booree ɲɔxɔɛ ra, banxi kanke xa maso a nɛɛnɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Na wali birin dangi xanbi, xa fure ɲaaxi man mini banxi ma, ");
INSERT INTO sus_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","sɛrɛxɛdubɛ xa gbilen na mato ra. Xa fure bara lantan yɛ banxi kui, fure ɲaaxi na a ra, a findixi se sɛniyɛntare nan na. ");
INSERT INTO sus_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Na banxi xa rabira, a gɛmɛe, a wurie, nun a maso bɛndɛ birin xa wɔlɛ taa fari ma yire sɛniyɛntare. ");
INSERT INTO sus_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Naxan yo soma na banxi kui a balan xanbi, na kanyi fan findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Naxan na a sa na banxi kui, xa na mu a ra a a dɛge naa, na lanma a xa a xa dugie xa.» ");
INSERT INTO sus_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Na banxi yailan xanbi, xa sɛrɛxɛdubɛ sa gbilen na banxi kui, a fa a to fure mu lantanxi a i, a xa masenyi ti, na banxi bara sɛniyɛn, fure bara ɲɔn naa. ");
INSERT INTO sus_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Na banxi kanyi xa na marasɛniyɛnyi rakamali sɛrɛxɛ bafe ra. A xa xɔni firin, sɛdiri wuri, gɛrɛ mɔɔli nde, nun hisopi wuri sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","A xa xɔni keren kɔn naxaba fɛɲɛ nde xun ma dulon ye na naxan kui. ");
INSERT INTO sus_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A xa sɛdiri wuri, hisopi wuri, gɛrɛ mɔɔli nde, nun xɔni ɲiɲɛ sin xɔni kɔn naxaba wuli xɔɔra, naxan na dulon ye kui. A xa a kasan banxi ma sanmaya solofere. ");
INSERT INTO sus_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A xa banxi rasɛniyɛn xɔni wuli, dulon ye, xɔni ɲiɲɛ, sɛdiri wuri, hisopi wuri, nun gɛrɛ mɔɔli nde ra. ");
INSERT INTO sus_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","A xa xɔni ɲiɲɛ bɛɲin taa fari ma wula i. Na kui, na banxi xa fe ɲaaxi ɲɔnma nɛ, a sɛniyɛn.» ");
INSERT INTO sus_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","«Sɛriyɛ nan na ki fure ɲaaxie xa fe ra naxee minima mixi fate ma, ");
INSERT INTO sus_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","dugie ma, banxie ma, ");
INSERT INTO sus_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","naxee funtuma, naxee bulama, naxee fiixɛma, ");
INSERT INTO sus_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","alako a xa kolon xa se sɛniyɛnxi nan a ra, xa na mu a ra a mu sɛniyɛnxi. Sɛriyɛ nan na ki na fure ɲaaxi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Alatala naxa a masen Annabi Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Wo xa a fala Isirayilakae bɛ, kɔrɔsila kanyi bara findi mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kɔrɔsila kanyi bara findi mixi sɛniyɛntare ra hali kɔrɔsila mu na minife sinden, kɔnɔ a na a fate kui. ");
INSERT INTO sus_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kɔrɔsila kanyi sama sade naxan ma, se sɛniyɛntare na a ra. A dɔxɔ gonyi naxan yo ma, na fan se sɛniyɛntare na a ra. ");
INSERT INTO sus_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Naxan na din a xa sade ra, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Naxan dɔxɔma a xa gonyi ma, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Naxan yo din na furema fate ra, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Xa furema dɛ ye bɔxun mixi sɛniyɛnxi nde ma, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Dɔxɔse naxan sama soe ma, xa na mu a ra ɲɔxɔmɛ ma, xa furema dɔxɔ na fari, na dɔxɔse findima se sɛniyɛntare nan na. ");
INSERT INTO sus_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Naxan na din sese ra furema bara dɔxɔ naxan fari, na kanyi bara findi mixi sɛniyɛntare ra han nunmare ra. Na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa. ");
INSERT INTO sus_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Furema bɛlɛxɛ sɛniyɛntare kanyi dinma mixi naxan na, na xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Furema dinma fɛɲɛ naxan na, na xa kana. Xa yirabase wuri daaxi na a ra, a lan a xa maxa ye ra.» ");
INSERT INTO sus_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Kɔrɔsila kanyi na yalan, a mamɛ tima nɛ lɔxun keren beenu a xa findi mixi sɛniyɛnxi ra. A xa a xa dugie xa, a xa a maxa dulonyi ye ra. A sɛniyɛnma na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Xi solomasaxan nde lɔxɔɛ, a xa ganbɛ firin tongo, xa na mu a ra kolokonde yɔrɛ firin, a sa e so sɛrɛxɛdubɛ yi ra n tan Alatala ya i hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Sɛrɛxɛdubɛ xa xɔni keren ba yunubi xafari sɛrɛxɛ ra, boore sɛrɛxɛ gan daaxi. Na kui, kɔrɔsila kanyi bara a xun sara n tan Alatala ya i.» ");
INSERT INTO sus_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Xa xɛmɛ nde a xa wantanyi nɔxɔ, a xa a fate birin maxa. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Dugi nun kiri naxan birin nɔxɔ, e xa maxa ye ra, e fan findima nɛ se sɛniyɛntare han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Xa xɛmɛ nun ginɛ kafu e boore ra, e xa e fate maxa. E findima mixi sɛniyɛntaree nan na han nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Ginɛ naxan na a xa kike wali kui, a findima mixi sɛniyɛntare nan na lɔxun keren bun ma. Naxan na din a ra, a fan findima mixi sɛniyɛntare ra han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ginɛ naxan na a xa kike wali kui, a sama sade naxan ma, se sɛniyɛntare na a ra. A dɔxɔ sese naxan ma, na fan se sɛniyɛntare na a ra. ");
INSERT INTO sus_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Naxan yo na din a xa sade ra, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Naxan yo na dɔxɔ a xa gonyi ma, na kanyi xa a xa dugie xa, a xa a yɛtɛ maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Xa se nde saxi na sade ma, xa na mu a ra na gonyi ma a nu dɔxɔxi naxan ma, naxan dinma na se ra a findima mixi sɛniyɛntare nan na han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Xa xɛmɛ nde nun na ginɛ kafu, a xa kike wali wuli fa sa a fate ma, a fan findima mixi sɛniyɛntare nan na lɔxɔxun keren bun ma. A na sa sade yo ma, na fan findima se sɛniyɛntare nan na.» ");
INSERT INTO sus_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Xa wuli lu mini ra ginɛ ma, naxan mu findixi a xa kike wali wuli ra, xa na mu a ra a xa kike wali tɛmui xɔn naxa kuya, a findima mixi sɛniyɛntare nan na alɔ ginɛ naxan na a xa kike wali kui. ");
INSERT INTO sus_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","A na a sa sade naxan ma, xa na mu a ra a dɔxɔ gonyi naxan ma, na birin findima nɛ se sɛniyɛntare ra alɔ a xa kike wali tɛmui. ");
INSERT INTO sus_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Naxan dinma na see ra, na kanyi xa a xa dugie xa, a xa a fate maxa ye ra. A findima mixi sɛniyɛntare nan na han nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Wuli na ba minife, na ginɛ xa mamɛ ti lɔxɔxun keren, a fa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Xi solofere nde lɔxɔɛ, a xa ganbɛ firin, xa na mu a ra kolokonde yɔrɛ firin tongo, a xa e xanin sɛrɛxɛdubɛ xɔn hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Sɛrɛxɛdubɛ xa xɔni keren ba yunubi xafari sɛrɛxɛ ra, boore sɛrɛxɛ gan daaxi. Sɛrɛxɛdubɛ xunsare sɛrɛxɛ bama na ginɛ bɛ n tan Alatala ya i na ki nɛ.» ");
INSERT INTO sus_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Wo xa Isirayilakae makuya sɛniyɛntareɲa ra, xa na mu a ra, e na e makɔrɛ n ma hɔrɔmɔlingira ra naxan na wo tagi, e faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","«Sɛriyɛ nan na ki kɔrɔsila xa fe ra, a nun xɛmɛ naxan a xa wantanyi nɔxɔma, ");
INSERT INTO sus_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ginɛ naxan na kike wali kui, kɔrɔsila naxan minima xɛmɛ nun ginɛ fate i, nun xɛmɛ naxan nun ginɛ sɛniyɛntare kafuma.» ");
INSERT INTO sus_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Haruna xa di firinyi to faxa e yɛtɛ masenfe ra Alatala bɛ, Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«A fala i taara Haruna bɛ, a na so hɔrɔmɔlingira kui, a naxa lu dangi ra dugi gbakuxi ra xa a dangi tɛmui mu a lixi, alako a naxa faxa. Yire sɛniyɛnxi na a ra saatɛ kankira na dɛnnaxɛ. Xunsarade na na saatɛ kankira nan fari, n minima nuxui kui dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Haruna xa so hɔrɔmɔlingira kui tuura ra, naxan bama yunubi xafari sɛrɛxɛ ra, a nun yɛxɛɛ kontonyi sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A xa guba sɛniyɛnxi gɛsɛ fute daaxi ragoro a ma, a xa wantanyi gɛsɛ fute daaxi so. A xa a tagi ixiri bɛlɛti gɛsɛ fute daaxi ra, a xa xunmase dɔxɔ a xunyi ma. A na gɛ a maxade, a xa na dugi sɛniyɛnxi birin nagoro a ma. ");
INSERT INTO sus_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isirayila ɲama xa sikɔtɛ firin so a yi ra yunubi xafari sɛrɛxɛ ra, a nun yɛxɛɛ kontonyi keren sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haruna xa tuura ba a yɛtɛ xa yunubi xafari sɛrɛxɛ ra alako a tan nun a xa denbaya xun xa sara. ");
INSERT INTO sus_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","A xa na sikɔtɛ firinyi ti n tan Alatala ya i, hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","A xa n tan Ala maxandi a xa tɔnxuma masen n bɛ na sikɔtɛ firinyi xa fe ra. Keren xa findi n tan Alatala gbe ra, boore xa lu Sentanɛ bɛ wula i. ");
INSERT INTO sus_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Sikɔtɛ naxan sugandixi n tan Alatala gbe ra, Haruna xa a ba yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Sikɔtɛ naxan sugandixi a xa findi Sentanɛ gbe ra, na mu faxama. Haruna xa a ti n tan Alatala ya i, a xa findi xunsare ra, a xa a bɛɲin sigafe ra wula i Sentanɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Haruna xa tuura ba a yɛtɛ xa yunubi xafari sɛrɛxɛ ra, a xa findi a tan nun a xa denbaya xunsare ra. A xa na tuura kɔn naxaba yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","A xa surayi ganse rafe tɛ wole ra naxan tongoxi sɛrɛxɛbade fari n tan Alatala ya i. A xa surayi fuɲi bɛlɛxɛ ya firin fan tongo. A xa na birin xanin dugi gbakuxi xanbi ra yire sɛniyɛnxi kui. ");
INSERT INTO sus_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A xa na surayi gan n tan Alatala ya i, alako tuuri naxan tema na xa saatɛ kankira nɔxun a ma alako a naxa faxa. ");
INSERT INTO sus_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","A xa tuura wuli nde tongo a bɛlɛxɛsole ra, a xa a kasan saatɛ kankira makoto se ma xunsarade sogetede biri sanmaya solofere, a man xa a kasan na makoto se ya ra. ");
INSERT INTO sus_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","A xa sikɔtɛ kɔn naxaba ɲama xa yunubi xafari sɛrɛxɛ ra, a fa a wuli xanin dugi gbakuxi xanbi ra. A xa na wuli kasan saatɛ kankira makoto se ma nun saatɛ kankira makoto se ya ra, alɔ a rabaxi tuura wuli ra ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","«Na ki a xunsare sɔtɔma yire sɛniyɛnxi bɛ Isirayilakae xa sɛniyɛntareɲa, e xa fe kobie, nun e xa yunubie xa fe ra. A xa a raba na ki hɔrɔmɔlingira fan bɛ, naxan tixi Isirayilaka sɛniyɛntaree tagi. ");
INSERT INTO sus_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mixi yo naxa lu hɔrɔmɔlingira kui han Haruna minima yire sɛniyɛnxi fisamante kui tɛmui naxɛ. A xa a tan nun a xa denbaya xun sara, a nun Isirayila ɲama birin. ");
INSERT INTO sus_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","A xa siga sɛrɛxɛbade yire naxan na n tan Alatala ya i, a fa xunsare ba na sɛrɛxɛbade bɛ. A xa tuura nun sikɔtɛ wuli sa ferie ma naxee nu na sɛrɛxɛbade tunxunyi naanie ra. ");
INSERT INTO sus_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A xa wuli kasan a bɛlɛxɛsole ra sanya solofere sɛrɛxɛbade ma, alako a xa sɛniyɛn Isirayilakae xa sɛniyɛntareɲa xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Haruna na gɛ xunsare bade yire sɛniyɛnxi, hɔrɔmɔlingira, nun sɛrɛxɛbade bɛ, a xa sikɔtɛ boore maso naxan mu nu faxa. ");
INSERT INTO sus_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","A xa a bɛlɛxɛ firinyie sa na sikɔtɛ xun tagi, a fa Isirayilakae xa sɛniyɛntareɲa, e xa fe kobie, nun e xa yunubi birin masen n tan Ala bɛ. A na gɛ na kote birin sade sikɔtɛ xun, a xa na sikɔtɛ bɛɲin wula i mixi nde saabui ra naxan bara tin na wali ra. ");
INSERT INTO sus_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Na sikɔtɛ yunubi birin xaninma a xun ma wula i, a bɛɲin dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Na dangi xanbi, Haruna xa so hɔrɔmɔlingira kui, a xa a xa dugi gɛsɛ fute daaxie ba, a naxee ragoroxi a ma beenu a xa so yire sɛniyɛnxi kui. A xa nee lu na. ");
INSERT INTO sus_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A xa a maxa ye ra yire sɛniyɛnxi kui, a dugi gbɛtɛe ragoro a ma. A na gɛ, a xa mini, a sɛrɛxɛ gan daaxi firin ba, keren a yɛtɛ bɛ, boore ɲama bɛ. A xunsare sɔtɔma a yɛtɛ bɛ nun ɲama bɛ na kui. ");
INSERT INTO sus_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A man xa yunubi xafari sɛrɛxɛ ture gan sɛrɛxɛbade fari.» ");
INSERT INTO sus_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Naxan sikɔtɛ bɛɲin wula i Sentanɛ bɛ, na lan a xa a xa dugie xa, a a fate maxa, a fa gbilen ɲama yonkinde. ");
INSERT INTO sus_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Tuura nun sikɔtɛ naxee baxi yunubi xafari sɛrɛxɛ ra, naxee wuli findi xunsare ra yire sɛniyɛnxi, nee lan e xa xanin ɲama yonkinde fari ma, e kiri, e sube, nun e ɲaɲɛ birin xa gan tɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Naxan na wali rabama, a xa a xa dugie xa, a xa a fate maxa ye ra, a fa gbilen ɲama yonkinde.» ");
INSERT INTO sus_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Sɛriyɛ nan na ki wo bɛ naxan mu kanama abadan. Kike solofere nde, xi fu lɔxɔɛ, wo xa sunyi suxu, wo naxa wali yo raba, wo tan, nun mixi naxee sabatixi naa kɔnɔ e mu findi Isirayilakae ra. ");
INSERT INTO sus_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Na findima xunsare lɔxɔɛ ra wo bɛ, alako wo xa sɛniyɛn, wo xa yunubi birin xa xafari n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Na findima malabui nun sali lɔxɔɛ ra wo bɛ. Wo xa sunyi suxu na lɔxɔɛ. Yi sɛriyɛ mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Ala naxan sugandixi, a naxan tixi sɛrɛxɛdubɛ kuntigi ra, na nan wo xun sarama. A luma a baba xa wali raba ra. A luma sɛrɛxɛdubɛ dugi sɛniyɛnxie ragoro ra a ma. ");
INSERT INTO sus_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A luma yire sɛniyɛnxi, hɔrɔmɔlingira, sɛrɛxɛbade, sɛrɛxɛdubɛe nun Isirayila ɲama birin xun sara ra. ");
INSERT INTO sus_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Yi sɛriyɛ mu kanama abadan, alako ɲɛ birin xunsare xa ba Isirayilakae bɛ e xa yunubi birin ma fe ra.» E Alatala xa yaamari birin suxu alɔ a masenxi Annabi Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«A fala Haruna bɛ nun a xa die bɛ, a nun Isirayilaka birin bɛ, Alatala yi nan yamarixi. ");
INSERT INTO sus_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isirayilaka naxan ninge, xa na mu a ra yɛxɛɛ, xa na mu a ra si bama sɛrɛxɛ ra ɲama yonkinde kui, xa na mu a ra ɲama yonkinde fari ma, ");
INSERT INTO sus_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a mu a xaninma hɔrɔmɔlingira sode dɛ xa ra alako a xa a fi n tan Alatala ma hɔrɔmɔlingira yire, na kanyi luma nɛ alɔ faxɛti. A bara faxɛ ti, a lanma na kanyi xa keri ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Yi yaamari wama a masenfe nɛ a Isirayilakae mu lanma e xa sɛrɛxɛ ba burunyi. E xa fa xanunteya sɛrɛxɛ ra sɛrɛxɛdubɛ nan xɔn n tan Alatala ya i n ma hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sɛrɛxɛdubɛ xa na wuli kasan n tan Alatala xa sɛrɛxɛbade sɛɛtie ma hɔrɔmɔlingira sode dɛ ra, a man xa na ture gan tɛ i, a xa findi xiri fanyi ra n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isirayilakae naxa sikɔtɛ sɛrɛxɛ ba kuye bɛ sɔnɔn de. Na findima yanfanteya nan na n tan Alatala mabiri. Yi yaamari mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«A fala e bɛ, Isirayilaka, xa na mu a ra xɔɲɛ naxan sabatixi e tagi, xa a sɛrɛxɛ gan daaxi, xa na mu a ra sɛrɛxɛ gbɛtɛ ba, ");
INSERT INTO sus_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","a mu a xanin hɔrɔmɔlingira sode dɛ ra, alako a xa fi n tan Alatala ma, na kanyi kerima nɛ a xa ɲama tagi.» ");
INSERT INTO sus_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Xa Isirayilaka nde, xa na mu a ra xɔɲɛ nde naxan sabatixi Isirayila bɔxi ma a naxa wuli min, n gbilenma nɛ na kanyi fɔxɔ ra, n fa a keri a xa ɲama ya ma, ");
INSERT INTO sus_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","barima sube nii bara lu a wuli ya ma. N bara wuli findi wo xunsare ra, naxan bama sɛrɛxɛ ra sɛrɛxɛbade fari. Wuli nan na xunsare ra. ");
INSERT INTO sus_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Na na a ra, n bara Isirayilakae yamari e naxa wuli min. Wo xa xɔɲɛ naxee sabatixi Isirayila bɔxi ma, e fan naxa wuli min de. ");
INSERT INTO sus_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Xa Isirayilaka, xa na mu a ra xɔɲɛ nde naxan na wo tagi, sa sube nde, xa na mu a ra xɔni nde faxa naxan daxa a xa don, a xa na wuli ifili bɔxi ma, a bɛndɛ sa a fari, ");
INSERT INTO sus_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","barima sube nii na a wuli nan ya ma. Na na a ra, n bara Isirayilakae yamari wo naxa sube wuli yo min, barima sube nii na a wuli nan ya ma. Naxan yo na raba, a fama keride Isirayila ɲama ya ma.» ");
INSERT INTO sus_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Xa Isirayilaka, xa na mu a ra xɔɲɛ nde naxan na wo tagi, na sube don naxan faxaxi a yɛtɛ ma, xa na mu a ra sube gbɛtɛ naxan faxaxi ki gbɛtɛ ra, na kanyi xa a xa dugie xa ye ra, a man xa a yɛtɛ maxa. A mu sɛniyɛnma han nunmare ra. ");
INSERT INTO sus_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Xa a mu a xa dugie xa, xa a mu a yɛtɛ maxa, na sɛniyɛntareɲa luma nɛ a ma.» ");
INSERT INTO sus_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«A fala Isirayilakae bɛ Alatala nan n na, wo Marigi Ala. ");
INSERT INTO sus_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Wo naxa Misirakae xa naamunyie raba, wo nu na dɛnnaxɛ. Wo man naxa Kanaankae fan ma naamunyie raba, n wo xaninma dɛnnaxɛ. Wo naxa bira e xa sɛriyɛ fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Wo xa n tan nan ma sɛriyɛ nun n ma yaamarie rabatu, barima Alatala nan n na, wo Marigi Ala. ");
INSERT INTO sus_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Wo xa bira n ma sɛriyɛ nun n ma yaamarie nan fɔxɔ ra. Mixi naxan nee rabatuma, a simaya sɔtɔma nee nan saabui ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Wo naxa kafu wo nun wo barima. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Wo naxa kafu wo nun wo nga, naxan findixi wo baba xa ginɛ ra. Wo nga nan wo nga ra, wo naxa kafu a ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Wo naxa kafu wo nun wo nanden, naxan findixi wo baba xa ginɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Wo naxa kafu wo nun wo maaginɛ, naxan findixi wo baba xa na mu a ra wo nga xa di ra, naxan barixi wo xɔnyi xa na mu a ra yire gbɛtɛ.» ");
INSERT INTO sus_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Wo naxa kafu wo nun wo xa di xɛmɛ xa di ginɛ, wo naxa kafu wo nun wo xa di ginɛ xa di ginɛ. E fatanxi wo yɛtɛ fate nan na.» ");
INSERT INTO sus_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Wo naxa kafu wo nun wo baba xa ginɛ gbɛtɛ xa di ginɛ, wo baba naxan barixi. Wo maaginɛ na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Wo naxa kafu wo nun wo baba maaginɛ ra. Wo baba bariboore na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Wo naxa kafu wo nun wo nga xunya, xa na mu a ra a taara. Wo nga bariboore na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Wo naxa kafu wo nun wo baba xunya xa ginɛ, xa na mu a ra a taara xa ginɛ. Wo baba xunya xa na mu a ra a taara nan gbe findixi na ginɛe ra. Wo nga nun wo mama nan lanxi e ma.» ");
INSERT INTO sus_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Wo naxa kafu wo nun wo xa di xa ginɛ, wo xa di nan xa ginɛ a ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Wo naxa kafu wo nun wo xunya, xa na mu a ra wo taara xa ginɛ.» ");
INSERT INTO sus_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Xa wo nun ginɛ nde bara kafu, wo nun a xa di ginɛ tan naxa kafu de. Wo nun a xa di xɛmɛ xa di ginɛ naxa kafu de, wo nun a xa di ginɛ xa di ginɛ naxa kafu de. Baribooremae na e ra, na fe mɔɔli mu fan.» ");
INSERT INTO sus_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Wo nun wo xa ginɛ xunya naxa kafu de, xa na mu a ra a taara, wo xa ginɛ xa simaya kui. Na fe fama nɛ tɔɔnɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Wo nun ginɛ naxa kafu a xa kike wali kui de, barima a mu sɛniyɛnxi na tɛmui.» ");
INSERT INTO sus_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Sade fe naxa lu wo nun wo malanboore xa ginɛ tagi de, na findima sɛniyɛntareɲa nan na.» ");
INSERT INTO sus_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Wo naxa wo xa di yo ba sɛrɛxɛ ra Mɔlɔkɔ kuye bɛ. Wo naxa wo Marigi Ala xili bɛxu. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Xɛmɛ naxa kafu nun xɛmɛ ra. Fe ɲaaxi na a ra. Xɛmɛ lanma e nun ginɛ nan xa kafu.» ");
INSERT INTO sus_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Xɛmɛ naxa kafu nun sube ra. Ginɛ fan naxa kafu nun sube ra. Na fe mɔɔli mu fan feo.» ");
INSERT INTO sus_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Wo naxa wo manɔxɔ yi fe mɔɔlie ra, alɔ na sie a rabaxi ki naxɛ n naxee keri wo ya ra. ");
INSERT INTO sus_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","E xa fe ɲaaxie bara bɔxi yati manɔxɔ. N e ratɔnxi na nan ma, e mu luma yi bɔxi ma sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Wo tan Isirayilakae nun xɔɲɛ naxee na wo tagi, wo xa n ma sɛriyɛ nun n ma yaamarie rabatu. Wo naxa yi fe xɔnxie raba de. ");
INSERT INTO sus_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Bekae nu bara na mɔɔli raba beenu wo xa fa. Yi bɔxi findi yire sɛniyɛntare ra na nan ma. ");
INSERT INTO sus_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Xa wo fan bira na mɔɔli fɔxɔ ra, wo fan kerima nɛ yi bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Mixi yo naxan na mɔɔli rabama, a kelima nɛ a xa ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Wo xa n ma yaamarie rabatu, wo naxa na fe xɔnxie raba alɔ mixi naxee nu na be beenu wo xa fa. Wo naxa findi mixi sɛniyɛntaree ra. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«A fala Isirayilakae bɛ, wo xa sɛniyɛn, barima n tan sɛniyɛn, wo Marigi Alatala. ");
INSERT INTO sus_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Birin xa e nga nun e baba binya. Birin xa malabui lɔxɔɛ sɛriyɛ rabatu. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Wo naxa kuyee batu, wo naxa wure raxunu kuye yailanfe ra. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Wo xa xanunteya sɛrɛxɛ ba n tan Alatala bɛ a raba ki ma. ");
INSERT INTO sus_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Sɛrɛxɛ sube xa don a faxa lɔxɔɛ, xa na mu a ra na kuye iba. Sube na xi saxan ti, na xa sa tɛ i. ");
INSERT INTO sus_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Naxan luma han xi saxan, a raharamuxi, a mu lan na mɔɔli xa don. ");
INSERT INTO sus_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Naxan na rabama, a na sare sɔtɔma nɛ, barima a bara n tan Alatala xa se sɛniyɛnxi yelebu. Na kanyi raminima nɛ Isirayila ɲama ya ma.» ");
INSERT INTO sus_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Wo na xɛ xaba wo xɔnyi, wo naxa a tuxuie xaba. Baloe naxan birama bɔxi ma, wo xa na lu naa. ");
INSERT INTO sus_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Wo na wɛni bogi ba wo xa sansie kɔn na, wo naxa gbilen a ma a firin nde. Bogi naxee fan yolonma e yɛtɛ ma, wo xa nee fan lu na setaree bɛ, a nun mixie bɛ naxee kelixi ɲamanɛ gbɛtɛe ma. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Wo naxa muɲɛ ti. Wo naxa wule fala. Wo naxa wo boore yanfa. ");
INSERT INTO sus_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Wo naxa wo kali n xili ra wule fari, barima na kui wo wo Marigi Ala xili nan kanama. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Wo naxa wo ngaxakerenyi tɔɔrɔ, wo naxa a muɲa. Wo naxa wo xa walikɛ xa wali sare lu han tina.» ");
INSERT INTO sus_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«Wo naxa tulixɔri konbi, wo naxa dɔnxui rabira. Wo xa gaaxu n tan Ala ya ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Wo naxa kiiti sa tinxintareya ra. Wo naxa setare rafisa a boore bɛ, wo naxa banna rafisa a boore bɛ. Wo xa kiiti birin sa tinxinyi ra. ");
INSERT INTO sus_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Wo naxa wo boore mafala. Wo naxa wo boore tɔɔɲɛgɛ alako a xa faxa. Alatala nan n na. ");
INSERT INTO sus_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Wo naxa wo ngaxakerenyi xɔn. Wo xa wo boore rasi, alako wo naxa yunubi sɔtɔ a xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Wo naxa wo gbeɲɔxɔ. Wo naxa gbɛsɛnxɔnnɛya ragata wo sondonyi kui wo ngaxakerenyi bɛ. Wo xa wo boore xanu alɔ wo wo yɛtɛ xanuma ki naxɛ. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Wo xa n ma yaamarie rabatu. Wo naxa xuruse mɔɔli firin rate e boore ma. Wo naxa sansi mɔɔli firin si xɛ keren ma. Wo naxa dugi ragoro wo ma naxan dɛgɛxi gɛsɛ mɔɔli firin na.» ");
INSERT INTO sus_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Xa xɛmɛ nde nun konyi ginɛ nde kafu xɛmɛ gbɛtɛ naxan xa kote dɔxɔxi, naxan xun mu saraxi sinden, naxan mu xɔrɛyaxi, e xa ɲaxankata. Kɔnɔ wo naxa e faxa, barima konyi ginɛ nan a ra. ");
INSERT INTO sus_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Na xɛmɛ xa yɛxɛɛ kontonyi ba yɛtɛ ragbilen sɛrɛxɛ ra n tan Alatala bɛ hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Sɛrɛxɛdubɛ xa na yɛxɛɛ kontonyi findi xunsare ra a bɛ n tan Alatala ya i, a xa findi yɛtɛ ragbilen sɛrɛxɛ ra alako a xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Wo na so bɔxi kui n naxan fima wo ma, wo naxa wo xa sansi sixie bogie don sinden han ɲɛ saxan. E mu sɛniyɛn, e luxi alɔ sunnɛtare. Wo naxa e don. ");
INSERT INTO sus_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Naxee fan bogima ɲɛ naani nde ma, na birin fima n tan Alatala nan ma, a xa findi n ma matɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Naxee bogima ɲɛ suuli nde ma, na tan birin findima wo baloe nan na. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Wo naxa sube yo don wo mu naxan kɔn naxabaxi, a wuli xa mini. Wo naxa sematoe wali raba, wo naxa duureya raba. ");
INSERT INTO sus_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Wo naxa wo xunsɛxɛ maxaba wo xunyi sɛɛtie ma a radigilinxi ra, wo naxa wo dɛ xabe sɛɛtie maxaba, ");
INSERT INTO sus_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","wo naxa wo fate maxaba ɲɔnyi to soxi wo ma. Wo naxa pirinti ti wo fate ma. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Wo naxa wo xa di ginɛ mati langoe ra, alako wo xa bɔxi naxa bira langoeɲa fɔxɔ ra, a xa rafe fe ɲaaxie ra. ");
INSERT INTO sus_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Wo xa n ma malabui lɔxɔɛe binya, a nun n ma yire sɛniyɛnxi. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Wo naxa mixi fen naxan mixi faxaxie rawɔyɛnma. Wo naxa bira sematoee fɔxɔ ra, xa na mu a ra wo findima sɛniyɛntaree nan na. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Wo xa mixi mɔxie binya, naxee xunsɛxɛ bara fiixɛ. Wo xa gaaxu wo Marigi Ala ya ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Wo naxa mixi rawali a ɲaaxi ra, naxee kelixi ɲamanɛ gbɛtɛ e xa sabati wo xa bɔxi kui. ");
INSERT INTO sus_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Wo xa na xɔɲɛ mɔɔli rasɛnɛ alɔ wo ngaxakerenyi. Wo xa a xanu alɔ wo wo yɛtɛ xanuma ki naxɛ. Wo fan nu na xɔɲɛya nan kui Misira bɔxi ma. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Wo naxa tinxintareya yo raba, kiiti sade, se kuyɛya maniyade, se binyɛ maniyade, se rafe daaxi maniyade. ");
INSERT INTO sus_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Wo xa sikeeli xa kamali. Wo se maniyase kamalixie rawali. Alatala nan n na, wo Marigi Ala, naxan wo raminixi Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Wo xa n ma sɛriyɛ nun n ma yaamari birin nabatu. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«A fala Isirayilakae bɛ, xa Isirayilaka nde, xa na mu a ra xɔɲɛ nde naxan sabatixi Isirayila bɔxi ma, a xa di nde ba sɛrɛxɛ ra Mɔlɔkɔ kuye bɛ, ɲama xa na kanyi magɔnɔ gɛmɛe ra han a xa faxa. ");
INSERT INTO sus_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","N tan fan gbilenma nɛ na mixi fɔxɔ ra, n a ramini ɲama ya ma, barima a bara n ma yire sɛniyɛnxi yelebu, a bara n xili sɛniyɛnxi kana na sɛrɛxɛ mɔɔli ra Mɔlɔkɔ kuye bɛ. ");
INSERT INTO sus_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Xa ɲama a ya raxi na fe ma, e tondi mixi faxade, naxan a xa di baxi sɛrɛxɛ ra Mɔlɔkɔ bɛ, ");
INSERT INTO sus_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","n tan gbilenma nɛ na mixi nun a xabilɛ fɔxɔ ra, n nee keri e xa ɲama ya ma, a nun mixi birin naxee n yanfama Mɔlɔkɔ kuye xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Xa mixi nde n yanfa, a bira sematoe fɔxɔ ra, a nun mixi naxan mixi faxaxie rawɔyɛnma, n gbilenma na kanyi fɔxɔ ra, n a keri a xa ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Wo xa wo ɲɛrɛ sɛniyɛnyi kui, alako wo xa sɛniyɛn, barima Alatala nan n na, wo Marigi Ala. ");
INSERT INTO sus_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Wo xa n ma yaamarie rabatu, wo xa e ratinmɛ. Alatala nan n na, naxan wo rasɛniyɛnma.» ");
INSERT INTO sus_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Naxan yo a baba danka, xa na mu a ra a nga, wo xa na kanyi faxa. A tan nan a faxa fe ragirixi, barima a bara a baba danka, xa na mu a ra a nga.» ");
INSERT INTO sus_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Xa xɛmɛ nde yɛnɛ raba a malan boore xa ginɛ ra, na xɛmɛ nun na ginɛ xa faxa e xa langoeɲa xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Xa xɛmɛ nde kafu nun a baba xa ginɛ ra, a bara fe ɲaaxi raba a baba ra. Wo xa na xɛmɛ nun na ginɛ faxa e xa yunubi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«Xa xɛmɛ nde kafu nun a xa di xa ginɛ ra, wo xa e firinyi birin faxa na yunubi xa fe ra, barima na fe mɔɔli mu fan feo.» ");
INSERT INTO sus_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Xa xɛmɛ nde kafu nun xɛmɛ gbɛtɛ ra alɔ xɛmɛ darixi a raba ra ginɛ ra ki naxɛ, wo xa e firinyi birin faxa na fe xɔnxi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Xa xɛmɛ nde kafu nun ginɛ ra nun na xa di ginɛ ra, e bara fe ɲaaxi raba. Wo xa e gan tɛ ra, xɛmɛ nun ginɛ, alako na fe xɔnxi mɔɔli naxa lu wo tagi.» ");
INSERT INTO sus_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Xa xɛmɛ nde kafu nun sube ra, wo xa na xɛmɛ nun na sube birin faxa.» ");
INSERT INTO sus_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«Xa ginɛ nde a maso sube ra kafu booreɲa ra, wo xa na ginɛ nun na sube faxa na fe ɲaaxi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Xa xɛmɛ nde kafu nun a maaginɛ ra, a baba xa di ginɛ, xa na mu a ra a nga xa di ginɛ, fe mayaagixi nan a ra. Wo xa e keri e xa ɲama ya ma, barima xɛmɛ bara kafu nun a maaginɛ ra. Na kote xa lu a xun ma.» ");
INSERT INTO sus_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Xa xɛmɛ nde kafu nun ginɛ ra naxan na a xa kike wali kui, a wuli naxa mini kɛnɛ ma. E firinyi birin xa keri ɲama ya ma na fe ma.» ");
INSERT INTO sus_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Wo naxa kafu nun wo nga xunya, xa na mu a ra wo nga taara ra, xa na mu a ra wo baba maaginɛ ra, barima wo bariboore nan e ra. Naxan na mɔɔli rabama na kote xa lu a xun ma.» ");
INSERT INTO sus_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Xa xɛmɛ nde kafu nun a baba xunya xa ginɛ ra, xa na mu a ra a baba taara xa ginɛ ra, e na kote xaninma nɛ. E birin fama faxade dibaritareɲa nan kui.» ");
INSERT INTO sus_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Xa xɛmɛ nde kafu nun a xunya xa ginɛ ra, xa na mu a ra a kafu nun a taara xa ginɛ ra, a bara fe sɛniyɛntare raba. E birin fama faxade dibaritareɲa nan kui.» ");
INSERT INTO sus_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Wo xa n ma sɛriyɛ nun n ma yaamari birin nabatu, wo xa na birin naba, alako wo mu fama keride ki naxɛ bɔxi ma n wo rasabatima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Wo naxa bira na bɔxi sie xa sɛriyɛ fɔxɔ ra, n fama naxee keride wo ya ra. E naxan nabama na mu rafanxi n ma feo. ");
INSERT INTO sus_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","N bara a fala wo bɛ na bɔxi findima wo gbe ra. N bara na bɔxi fi wo ma, xiɲɛ nun kumi gbegbe na dɛnnaxɛ. Alatala nan n na, wo Marigi Ala, naxan wo sugandixi sie tagi. ");
INSERT INTO sus_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Wo xa sube raharamuxie nun sube radaxaxie tagi rasa, e nun xɔni raharamuxie nun xɔni radaxaxie, alako wo naxa findi sɛniyɛntaree ra e saabui ra. N bara tɔnyi dɔxɔ na subee, na xɔnie, nun na bɔximasee ra. E mu sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Wo xa findi n ma ɲama sɛniyɛnxi ra, barima n tan Alatala nan sɛniyɛn. N bara wo sugandi sie tagi, alako wo xa findi n gbe ra.» ");
INSERT INTO sus_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Mixi yo naxan mixi faxaxie rawɔyɛnma, xa na mu a ra a findi sematoe ra, wo xa a magɔnɔ gɛmɛe ra han a xa faxa. A tan nan a faxa fe ragirixi.» ");
INSERT INTO sus_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Alatala naxa a masen Annabi Munsa bɛ, «A fala Haruna xa di sɛrɛxɛdubɛe bɛ, sɛrɛxɛdubɛ naxa a yɛtɛ findi sɛniyɛntare ra a xa mixi nde fure saabui ra, ");
INSERT INTO sus_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","fo a xa mixi kɛndɛ nde alɔ a nga, a baba, a xa di xɛmɛ, a xa di ginɛ, a xunya xɛmɛma, a taara xɛmɛma, ");
INSERT INTO sus_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","nun a maaginɛ, ginɛdimɛdi na naxan na, a mu dɔxɔxi xɛmɛ taa sinden, a na a xɔnyi. Sɛrɛxɛdubɛ na din e fure ra, a findima nɛ mixi sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","A mu lanma sɛrɛxɛdubɛ xa findi sɛniyɛntare ra a xa ginɛ fure xa fe ra, xa na mu a ra a xa ginɛ xa mixie fure xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Xa ɲɔnfe bara a li, a mu lanma sɛrɛxɛdubɛ xa a xunyi bi, xa na mu a ra a dɛ xabee sɛɛti maxaba, xa na mu a ra a fate maxaba. ");
INSERT INTO sus_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","E xa sɛniyɛn e Marigi Ala bɛ. E naxa e Marigi Ala xili kana, barima e tan nan sɛrɛxɛ gan daaxie bama n tan Alatala bɛ, naxee luxi alɔ n ma donse. E lan e xa sɛniyɛn na nan ma. ");
INSERT INTO sus_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","A mu lanma sɛrɛxɛdubɛ xa langoe ginɛ dɔxɔ, xa na mu a ra ginɛ futi kanɛ, xa na mu a ra ginɛ xɛmɛ mɛɛxi naxan na. Sɛrɛxɛdubɛ tan sɛniyɛn a Marigi Ala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wo xa a kolon mixi sɛniyɛnxi ra, barima a tan nan sɛrɛxɛe fima Ala ma naxee luxi alɔ donse. Wo xa a kolon a sɛniyɛn, barima n tan Alatala sɛniyɛn, n tan naxan wo rasɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Xa sɛrɛxɛdubɛ xa di ginɛ nde a yɛtɛ rayaagima findife ra langoe ra, a bara a baba rayaagi. A lanma na ginɛ xa gan tɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Sɛrɛxɛdubɛ kuntigi naxan sugandixi a ngaxakerenyie tagi, e ture sɛniyɛnxi sa a ma, e dugi sɛniyɛnxi ragoro a ma, na naxa a xunsɛxɛ kana, a naxa a xa dugi ibɔɔ. ");
INSERT INTO sus_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","A naxa so fure xun ma, a naxa findi sɛniyɛntare ra fure xa fe ra, hali a baba xa na mu a ra a nga. ");
INSERT INTO sus_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A naxa mini yire sɛniyɛnxi kui, a naxa a Marigi Ala xa hɔrɔmɔlingira manɔxɔ, barima n tan Ala nan a sugandixi, ture sɛniyɛnxi saxi a xunyi ma. Alatala nan n na. ");
INSERT INTO sus_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","A xa ginɛdimɛdi dɔxɔ ginɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","A naxa kaaɲɛ ginɛ dɔxɔ, a naxa ginɛ rabɛɲinxi dɔxɔ, a naxa langoe dɔxɔ, a naxa ginɛ dɔxɔ ginɛdimɛdi mu naxan na. A xa ginɛdimɛdi tongo ginɛ ra a xa mixie ya ma, ");
INSERT INTO sus_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","alako a naxa a bɔnsɔɛ rayaagi. Alatala nan n na naxan a rasɛniyɛnma.» ");
INSERT INTO sus_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«A fala Haruna bɛ, mixi mabɛnxi yo naxa sɛrɛxɛdubɛ wali raba, a sɛrɛxɛ sa sɛrɛxɛbade ma n tan Ala bɛ. Na mu lanma abadan. ");
INSERT INTO sus_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mabɛnyie nan ya naxee mu daxa e xa e maso sɛrɛxɛbade ra: naxan ya mu fan, naxan mu nɔma ɲɛrɛde a fanyi ra, naxan salonse nde kanaxi, ");
INSERT INTO sus_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","naxan bɛlɛxɛ, xa na mu a ra sanyi giraxi, ");
INSERT INTO sus_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","naxan kuntinxi, naxan xa kuyɛ mu kamalixi, naxan ya mu fanxi, fate kiri fure na naxan ma, nun xɛmɛ banaxi. ");
INSERT INTO sus_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mabɛnyi yo fatan sɛrɛxɛdubɛ Haruna xabilɛ ra, a naxa a maso n tan Alatala xa sɛrɛxɛbade ra sɛrɛxɛ gan daaxi bafe ra a Marigi Ala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A nɔma n tan Ala xa donse sɛniyɛnxi mɔɔli birin donde, ");
INSERT INTO sus_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","kɔnɔ a mu lan a xa a maso yire sɛniyɛnxi fisamante xa dugi ra, xa na mu a ra sɛrɛxɛbade ra. A naxa n ma yire sɛniyɛnxi xili kana, barima Alatala nan n na, naxan a rasɛniyɛnma.» ");
INSERT INTO sus_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Annabi Munsa naxa na masenyi ti Haruna, a xa die, nun Isirayilaka birin bɛ. ");
INSERT INTO sus_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«A fala Haruna nun a xa die bɛ, e xa Isirayilakae xa sɛrɛxɛ sɛniyɛnxie ba a ba ki ma, barima e nee fima n tan nan ma. Sɛrɛxɛdubɛe naxa n xili sɛniyɛnxi kana. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«A fala e bɛ, xa e bɔnsɔɛ mixi nde sa findi sɛniyɛntare ra, a naxa a maso Isirayilakae xa sɛrɛxɛ ra e naxee fima n tan Alatala ma, na kanyi kerima nɛ n ya i. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«Kunɛ fure na mixi yo ma Haruna bɔnsɔɛ ya ma, xa na mu a ra kɔrɔsila fure, na mu lan a xa sɛrɛxɛ sɛniyɛnxi don fo a xa gɛ sɛniyɛnde. A man mu lan mixi xa na raba xa a bara din mixi nde ra naxan bara din mixi fure ra. Xa ye sɛniyɛntare na minife mixi xɛmɛya kui, a mu lan a xa sɛrɛxɛ sɛniyɛnxi don. ");
INSERT INTO sus_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Xa mixi nde bara din bubuse ra, xa na mu a ra mixi sɛniyɛntare ra, na mu lan a xa sɛrɛxɛ sɛniyɛnxi don. ");
INSERT INTO sus_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Naxan na rabama, na kanyi findima sɛniyɛntare nan na han nunmare. Beenu a xa na sɛrɛxɛ sɛniyɛnxi don, a xa a fate maxa. ");
INSERT INTO sus_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Soge na goro, a bara sɛniyɛn, a nɔma sɛrɛxɛ sɛniyɛnxi donde sɔnɔn, barima a baloe na a ra.» ");
INSERT INTO sus_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","«Sɛrɛxɛdubɛ naxa sube don naxan faxaxi a yɛtɛ ma. A man naxa sube don sube gbɛtɛ naxan faxaxi, alako a naxa findi sɛniyɛntare ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Sɛrɛxɛdubɛe xa n ma yaamarie rabatu e baloe xa fe ra, alako e naxa yunubi sɔtɔ, e fa faxa. Alatala nan n na, naxan e rasɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Mixi yo naxa sɛrɛxɛ sɛniyɛnxi don xa sɛrɛxɛdubɛ mu a ra. Hali sɛrɛxɛdubɛ xa xɔɲɛ, xa na mu a ra a xa walikɛ mu lanma a xa a don. ");
INSERT INTO sus_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kɔnɔ sɛrɛxɛdubɛ xa konyi, a naxan sara kɔbiri ra, a nun na konyi xa denbaya tan nɔma sɛrɛxɛdubɛ baloe donde. ");
INSERT INTO sus_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Sɛrɛxɛdubɛ xa di ginɛ naxan dɔxɔxi xɛmɛ Ala kolontare xɔn ma, naxa sɛrɛxɛ sɛniyɛnxi don. ");
INSERT INTO sus_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Sɛrɛxɛdubɛ xa di ginɛ naxan findixi kaaɲɛ ginɛ ra, xa na mu a ra xɛmɛ mɛɛxi naxan na e mu di bari, a gbilen a baba xɔnyi alɔ a nu na naa ki naxɛ a dimɛdi ra, na ginɛ nɔma a baba baloe donde. Mixi yo naxan mu findi Isirayilaka ra, na mu lanma a xa na mɔɔli don. ");
INSERT INTO sus_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Xa mixi nde sa sɛrɛxɛ sɛniyɛnxi don kolontareya ma, a lan a xa a ɲɔxɔɛ fi kɔbiri ra, a man xa nde sa na fari. Na findima kɔbiri naxan na, a na donse sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na so sɛrɛxɛdubɛ yi ra. ");
INSERT INTO sus_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Sɛrɛxɛdubɛe naxa fe raba n tan Alatala xa sɛrɛxɛ sɛniyɛnxie ra, a mu lan naxan xa raba ");
INSERT INTO sus_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","alako e naxa yunubi sɔtɔ na sɛrɛxɛe xa fe ra e naxee donxi. Alatala nan n na, naxan e rasɛniyɛnma.» ");
INSERT INTO sus_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«A fala Haruna, a xa die, nun Isirayilakae birin bɛ, Isirayilakae birin, a nun xɔɲɛ naxee sabatixi Isirayila bɔxi ma, mixi naxan sɛrɛxɛ gan daaxi bama n tan Alatala bɛ laayidi nde rakamalife ra, xa na mu a ra a yɛtɛ ɲanige rabafe ra, ");
INSERT INTO sus_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","a lan a xa tuura nan ba, xa na mu a ra yɛxɛɛ kontonyi, xa na mu a ra sikɔtɛ, lanyuru mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Wo naxa xuruse yo ba lanyuru na naxan ma, barima n tan Ala mu na mɔɔli rasuxuma. ");
INSERT INTO sus_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Xa mixi nde wama xuruse xungbe, xa na mu a ra xuruse lanma bafe xanunteya sɛrɛxɛ ra n tan Alatala bɛ, laayidi nde rakamalife ra, xa na mu a ra ɲanige rabafe ra, na xuruse fate xa fan, lanyuru yo naxa lu a ma, xa na mu a ra n tan Ala mu a rasuxuma. ");
INSERT INTO sus_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Wo naxa xuruse yo ba naxan ya mu fan, naxan maxɔnɔxi, naxan mabɛnxi, fure na naxan kiri ma. Wo naxa na mɔɔli sa n tan Alatala xa sɛrɛxɛbade fari, a xa findi sɛrɛxɛ gan daaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","I nɔma ninge, xa na mu a ra yɛxɛɛ kɛɲa ɲaaxi bade ɲanige sɛrɛxɛ ra, kɔnɔ i mu nɔma na bade laayidi rakamali sɛrɛxɛ ra de. ");
INSERT INTO sus_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Wo naxa xuruse banaxi, xɛmɛya kanaxi, xa na mu a ra xɛmɛya mu naxan bɛ, ba sɛrɛxɛ ra n tan Alatala bɛ. Wo naxa na mɔɔli ba sɛrɛxɛ ra wo xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Wo naxa na xuruse mɔɔli rasuxu xɔɲɛe yi ra, wo xa e ba sɛrɛxɛ ra wo Marigi Ala bɛ, barima e fate mu fanxi, e mu kamalixi. N tan Ala mu nee rasuxuma.» ");
INSERT INTO sus_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Ninge yɔrɛ, yɛxɛɛ yɔrɛ, nun si yɔrɛ na bari, e xa lu e nga bun ma xi solofere, beenu e xa findi sɛrɛxɛ gan daaxi ra n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Wo naxa ninge, xa na mu a ra yɛxɛɛ, nun a xa di kɔn naxaba lɔxɔɛ keren kui.» ");
INSERT INTO sus_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Wo xa tantui sɛrɛxɛ ba n tan Alatala bɛ a ba ki ma alako n xa a suxu. ");
INSERT INTO sus_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Wo xa na sɛrɛxɛ don na lɔxɔɛ yati, a naxa lu han gɛɛsɛgɛ. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Wo xa n ma yaamarie rabatu, wo xa e suxu. Alatala nan n na. ");
INSERT INTO sus_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Wo naxa n xili sɛniyɛnxi kana. Isirayilakae birin xa a kolon n sɛniyɛn. Alatala nan n na, naxan wo rasɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","N tan nan wo ramini Misira bɔxi ra, n xa findi wo Marigi Ala ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«A fala Isirayilakae bɛ, n tan Alatala xa sali lɔxɔɛe nan ya, naxee sɛniyɛnxi wo bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Wo xa wali xi senni, kɔnɔ xi solofere nde findixi malabui lɔxɔɛ nan na, malanyi sɛniyɛnxi rabama lɔxɔɛ naxɛ. Wo naxa wali yo raba na lɔxɔɛ. Na findixi n tan Alatala nan gbe ra. Wo xa na sɛriyɛ suxu wo sabatide birin.» ");
INSERT INTO sus_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«N tan Alatala xa sali lɔxɔɛ gbɛtɛe nan ya, wo ɲama maxilima lɔxɔɛ naxee ma: ");
INSERT INTO sus_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Kike singe, xi fu nun naani nde, soge dula tɛmui, Sayamalekɛ Dangi Sali sɛrɛxɛ xa ba n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","N tan Alatala xa Taami Lɛbinitare Sali fɔlɔma na kike xi fu nun suuli nde lɔxɔɛ nɛ. Wo xa taami lɛbinitaree don na xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Na sali xi singe kui, wo xa malanyi sɛniyɛnxi raba. Wo naxa wali yo raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Wo xa sɛrɛxɛe gan daaxie ba n tan Alatala bɛ na xi solofere bun ma. Xi solofere nde lɔxɔɛ, wo man xa malanyi sɛniyɛnxi raba. Wo naxa wali yo raba na lɔxɔɛ.» ");
INSERT INTO sus_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«A fala Isirayilakae bɛ, wo na so bɔxi ma n naxan fima wo ma, wo na xɛ xaba, wo xa a xiri singe xanin sɛrɛxɛdubɛ xɔn. ");
INSERT INTO sus_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Sɛrɛxɛdubɛ xa na masen n tan Alatala bɛ malabui lɔxɔɛ dangi xanbi, alako n xa a suxu wo bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Wo na xiri singe masenma n tan Alatala bɛ lɔxɔɛ naxɛ, wo man xa yɛxɛɛ fanyi ɲɛ keren daaxi ba sɛrɛxɛ gan daaxi ra n bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","a nun sansi xɔri dinxi konbo ya keren naxan masunbuxi ture ra. Na findima sɛrɛxɛ gan daaxi ra n tan Alatala bɛ naxan xiri rafan n ma. Wo man xa wɛni litiri keren ba wɛni sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Wo naxan sɔtɔ xɛ xaba tɛmui, wo naxa sese don, taami, tɔnsɔɛ ganxi, nun sansi xɔri ra, beenu wo xa na sɛrɛxɛ ba wo Marigi Ala bɛ. Sɛriyɛ nan na ki wo bɔnsɔɛ bɛ wo sabatide birin. Na mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Fɔlɔ malabui lɔxɔɛ kuye iba ma, wo na xiri singe lintanma Alatala ya i sɛrɛxɛ ra lɔxɔɛ naxɛ, lɔxun solofere xa dangi. ");
INSERT INTO sus_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","A xi tongo suuli nde, malabui lɔxɔɛ xi solofere nde kuye iba, wo man xa sɛrɛxɛ ba n tan Alatala bɛ daxamui nɛɛnɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Wo xa fa taami firin na wo naxan lintanma n tan Alatala ya i sɛrɛxɛ ra, kelife ra wo xɔnyie. Wo xa e yailan sansi xɔri luxutaxi konbo ya keren na, wo lɛbini sunbu a ra. Bogise singe sɛrɛxɛ nan na ki n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Wo man xa yɛxɛɛ fanyi ɲɛ keren daaxi solofere sa na taami fari, tuura lanma keren, nun yɛxɛɛ kontonyi firin naxee bama sɛrɛxɛ gan daaxie ra. Wo man xa sansi xɔri luxutaxi nun wɛni sɛrɛxɛ sa nee fari. Nee gan xiri nafan n tan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Wo man xa sikɔtɛ keren ba yunubi xafari sɛrɛxɛ ra, a nun yɛxɛɛ firin ɲɛ keren daaxi, naxee findima xanunteya sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Sɛrɛxɛdubɛ na birin lintanma n tan Alatala ya i sɛrɛxɛ ra, na taami singee, nun na yɛxɛɛ firinyie. E birin fima n tan Alatala nan ma, e fa lu sɛrɛxɛdubɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Na lɔxɔɛ wo xa malanyi sɛniyɛnxi raba. Wo naxa wali yo raba na lɔxɔɛ. Sɛriyɛ na a ra wo bɔnsɔɛ bɛ yire birin abadan. ");
INSERT INTO sus_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Wo na xɛ xaba wo xɔnyi, wo naxa a tuxuie xaba. Baloe naxan birama bɔxi ma, wo xa na lu naa setaree bɛ, a nun mixie bɛ naxee kelixi ɲamanɛ gbɛtɛe ma. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«A fala Isirayilakae bɛ, kike solofere nde, xi singe, wo xa wo malabu na lɔxɔɛ, wo xa ɲama maxili sara xui ra, wo malanyi sɛniyɛnxi raba. ");
INSERT INTO sus_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Wo naxa wali yo raba na lɔxɔɛ, wo xa sɛrɛxɛ gan daaxie ba n tan Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Kike solofere nde, xi fu nde xa findi Xunsare Lɔxɔɛ ra. Wo xa malanyi sɛniyɛnxi raba, wo xa sunyi suxu, wo xa sɛrɛxɛ gan daaxie ba n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Wo naxa wali yo raba na lɔxɔɛ, barima Xunsare Lɔxɔɛ na a ra, wo xun sarama wo Marigi Alatala ya i lɔxɔɛ naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mixi naxan tondima sunyi suxude na lɔxɔɛ, na kanyi raminima nɛ a xa ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mixi naxan wali yo rabama na lɔxɔɛ, n a sɔntɔma nɛ a xa ɲama tagi. ");
INSERT INTO sus_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Wo naxa wali yo raba. Sɛriyɛ na a ra wo bɔnsɔɛ birin bɛ yire birin, naxan mu kanama abadan. ");
INSERT INTO sus_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Na findima malabui lɔxɔɛ nan na wo bɛ. Wo xa sunyi suxu fɔlɔfe na kike xi solomanaani lɔxɔɛ nunmare ra, han a xi fu lɔxɔɛ nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«A fala Isirayilakae bɛ, kike solofere nde xi fu nun suuli nde, Bage Ti Sali fɔlɔma, a bu xi solofere n tan Alatala xa binyɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Sali xi singe malanyi sɛniyɛnxi rabama nɛ. Wo naxa wali yo raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Wo xa sɛrɛxɛ gan daaxie ba n tan Alatala bɛ xi solofere bun ma. Xi solomasaxan nde wo xa malanyi sɛniyɛnxi raba. Wo xa sɛrɛxɛ gan daaxie ba n tan Alatala bɛ. Sali xungbe na a ra, wo naxa wali yo raba.» ");
INSERT INTO sus_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«N tan Alatala xa sali lɔxɔɛ xungbee nan na ki wo bɛ. Wo xa sɛrɛxɛ gan daaxie, sansi xɔri sɛrɛxɛe, nun wɛni sɛrɛxɛe ba a ba tɛmui. ");
INSERT INTO sus_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Wo xa n tan Alatala xa malabui lɔxɔɛe rabatu, wo xa xanunteya sɛrɛxɛe, wo xa laayidi sɛrɛxɛe, a nun wo xa ɲanige sɛrɛxɛe wo naxee fima n ma, wo xa e rakamali.» ");
INSERT INTO sus_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Kike solofere nde xi fu nun suuli nde, wo gɛ xanbi wo xa xɛe bogisee malande, wo xa sali raba n tan Alatala bɛ xi solofere bun ma. Sali xi singe nun a xi solomasaxan nde findixi malabui lɔxɔɛe nan na. ");
INSERT INTO sus_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sali xi singe, wo xa bogise fanyie ba sansi bilie kɔn na, tugi fɛnsɛe, nun wuri tofanyi ɲingie. Wo xa sɛɛwa wo Marigi Alatala ya i xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wo xa yi sali raba Alatala bɛ ɲɛ yo ɲɛ xi solofere bun ma. Sɛriyɛ na a ra wo bɔnsɔɛ birin bɛ naxan mu kanama abadan. Wo xa na sali raba kike solofere nde kui. ");
INSERT INTO sus_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Wo xa xi bagee kui na xi solofere bun ma. Isirayilakae birin xa xi bagee kui, ");
INSERT INTO sus_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","alako wo bɔnsɔɛe xa a kolon a n a niyaxi nɛ wo benbae xa xi bagee kui n e ramini Misira bɔxi ra tɛmui naxɛ. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Annabi Munsa xa masenyi nan na ki, a naxan masen Isirayilakae bɛ Alatala xa salie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Isirayilakae yamari, e xa fa oliwi ture fanyi ra i xɔn, alako lanpuie xa dɛxɛ tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Haruna xa a ɲɛngi sa lanpuie xɔn, naxee na hɔrɔmɔlingira kui, yire sɛniyɛnxi sɛɛti ma. Saatɛ kankira na na yire sɛniyɛnxi fisamante nan kui, dugi gbakuxi a sode dɛ ra. A xa a niya lanpuie xa nu dɛxɛ n tan Alatala ya i tɛmui birin, kelife nunmare ra han gɛɛsɛgɛ. Sɛriyɛ na a ra wo bɔnsɔɛ bɛ abadan. ");
INSERT INTO sus_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Haruna xa a ɲɛngi sa lanpuie xɔn naxee dɔxɔxi lanpui dɔxɔ se xɛɛma daaxie fari n tan Alatala ya i.» ");
INSERT INTO sus_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Wo xa taami fu nun firin yailan sansi xɔri luxutaxi fanyi ra, taami keren, sansi xɔri dinxi konbo ya keren. ");
INSERT INTO sus_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Wo xa e sa safɛ firin, senni na sɛɛti keren, senni na sɛɛti boore, teebili fari n tan Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Wo xa surayi fanyi sa taami safɛe sɛɛti ma, naxan fama gande taami ɲɔxɔɛ ra n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Taami xa sa teebili fari malabui lɔxɔɛ birin. Sɛriyɛ na a ra Isirayilakae bɛ abadan. ");
INSERT INTO sus_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Haruna nun a xa die xa na taamie don yire sɛniyɛnxi, barima sɛrɛxɛ sɛniyɛnxi na a ra, naxee fixi Alatala ma a gan daaxi ra. Sɛriyɛ na a ra naxan mu kanama abadan.» ");
INSERT INTO sus_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Lɔxɔɛ nde mixi nde naxa so Isirayilakae ya ma. A nga findi Isirayilaka nan na, kɔnɔ a baba naxa findi Misiraka ra. Gere naxa bira a i na mixi nun Isirayilaka nde tagi. ");
INSERT INTO sus_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Na kui, na Isirayila ginɛ xa di naxa Alatala xili bɛxu, a a konbi. E naxa a xanin Annabi Munsa xɔn na fe ma. Na mixi nga xili nɛ Selomiti, Dibiri xa di ginɛ, Dana bɔnsɔɛ. ");
INSERT INTO sus_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","E naxa a suxu a fanyi ra han Alatala yati naxa a xa fe ya iba e bɛ. ");
INSERT INTO sus_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Ɲama xa yi konbiti xanin ɲama yonkinde fari ma. Naxee na konbi mɛxi, nee xa e bɛlɛxɛe sa a xunyi, ɲama birin fa a magɔnɔ gɛmɛ ra han a faxa. ");
INSERT INTO sus_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","I xa a fala Isirayilakae bɛ, mixi yo naxan n tan Ala konbima, na yunubi kote luma a xun ma. ");
INSERT INTO sus_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Naxan na n tan Alatala xili bɛxu, ɲama birin xa a magɔnɔ gɛmɛ ra han a xa faxa. Xa a findi xɔɲɛ ra, xa a findi beka ra, a xa faxa barima a bara n tan Alatala bɛxu.» ");
INSERT INTO sus_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Mixi naxan na adamadi faxa, a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mixi naxan na mixi nde xa xuruse faxa, a xa a ɲɔxɔɛ so a yi. Nii ɲɔxɔɛ xa fi nii ra. ");
INSERT INTO sus_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mixi naxan na a boore maxɔnɔ, a fan xa maxɔnɔ na ki. ");
INSERT INTO sus_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Maxɔnɛ ɲɔxɔɛ maxɔnɛ nan na. Ya ɲɔxɔɛ ya nan na, ɲinyi ɲɔxɔɛ na ɲinyi nan na. A xa maxɔnɔ alɔ a a rabaxi a boore ra ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mixi naxan na mixi xa xuruse faxa, a xa a ɲɔxɔɛ fi, kɔnɔ mixi naxan na adamadi faxa, na kanyi fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Sɛriyɛ keren na a ra wo birin bɛ, xɔɲɛe nun Isirayilakae. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Annabi Munsa to gɛ na masenyi tide Isirayilakae bɛ, ɲama naxa na konbiti xanin ɲama yonkinde fari ma, e a magɔnɔ gɛmɛ ra han a faxa. Na kui e naxa Alatala xa yaamari suxu alɔ Annabi Munsa a masenxi e bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Alatala naxa a masen Annabi Munsa bɛ Turusinina geya fari, ");
INSERT INTO sus_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«A fala Isirayilakae bɛ, wo na so bɔxi kui n naxan fima wo ma, wo xa a lu bɔxi xa malabu n tan Alatala xa binyɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Wo xa xɛ wali suxu, wo xa mɛɛni wɛni bilie ma, wo xa e bogie ba. Wo xa na birin naba ɲɛ senni bun ma, ");
INSERT INTO sus_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","kɔnɔ ɲɛ solofere nde wo xa a lu bɔxi xa a malabu n tan Alatala xa binyɛ bun ma. Wo naxa xɛ wali raba, wo naxa fefe raba wɛni bilie ra na ɲɛ kui. ");
INSERT INTO sus_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Sansi bogi naxee bulama e yɛtɛ ma, wo naxa e xaba. Wɛni bogie naxee bogima e yɛtɛ ma, wo xa e lu naa barima malabui ɲɛ na a ra bɔxi bɛ. ");
INSERT INTO sus_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Bɔxi naxan naminima na malabui ɲɛ kui, wo birin nɔma na donde, wo tan, wo xa konyie, wo xa walikɛe, wo xa xɔɲɛe, ");
INSERT INTO sus_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","wo xa xurusee, a nun burunyi sube naxee na bɔxi kui. Bɔxi naxan namini a yɛtɛ ra na ɲɛ ra, na nan findima wo baloe ra.» ");
INSERT INTO sus_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Wo xa malabui ɲɛ solofere kɔnti, ɲɛ tongo naani nun solomanaani, ɲɛ solofere dɔxɔ solofere. ");
INSERT INTO sus_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","A kike solofere xi fu nde, wo xa sarae fe ɲama bɛ bɔxi birin kui, a findima Xunsare Lɔxɔɛ nan na. ");
INSERT INTO sus_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Na ɲɛ tongo suuli nde xa findi xɔrɛya ɲɛ ra bɔxi mixi birin bɛ. Konyi birin xa xɔrɛya sɔtɔ, kankan xa gbilen a xɔnyi a xabilɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Na ɲɛ tongo suuli nde findima Xɔrɛya Ɲɛ nan na wo bɛ. Wo naxa sansi xɔrie si, wo naxa sansi bogie nun wɛni bogie ba naxee bulama e yɛtɛ ma, ");
INSERT INTO sus_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Xɔrɛya Ɲɛ nan na ra, waxati sɛniyɛnxi na a ra wo bɛ. Bɔxi daxamui xa findi wo xa baloe ra.» ");
INSERT INTO sus_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Na Xɔrɛya Ɲɛ kui, birin xa gbilen e xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Xa wo bɔxi matima wo ngaxakerenyi ma, xa na mu a ra wo bara nde sara wo ngaxakerenyi ma, wo naxa wo boore tɔɔrɔ na kui. ");
INSERT INTO sus_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wo xa na sara sare tinxinxi ra, naxan ɲɛe kɔntima kelife Xɔrɛya Ɲɛ waxati. Wo ngaxakerenyi xa na mati wo ma sɛriyɛ ki ma. A xa xɛ xaba ɲɛ kɔnti naxee luxi beenu Xɔrɛya Ɲɛ xa a li. ");
INSERT INTO sus_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Xa ɲɛ wuyaxi luxi, a sare xa mate na ki. Xa ɲɛ wuyaxi mu luxi, a sare xa magoro. Wo xa a mato xɛ xabama sanmaya yeri beenu Xɔrɛya Ɲɛ xa a li. ");
INSERT INTO sus_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Wo naxa wo boore tɔɔrɔ na kui. Wo xa gaaxu wo Marigi Ala ya ra. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«Wo xa n ma sɛriyɛ suxu, wo xa n ma yaamarie rabatu, alako wo xa lu yi bɔxi ma bɔɲɛsa kui. ");
INSERT INTO sus_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Bɔxi daxamui fama wo wasade, wo man sabatima bɔɲɛsa kui. ");
INSERT INTO sus_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Xa wo sa maxɔrinyi ti yi ki, ‹Xa won mu sese sima ɲɛ solofere nde kui, xa won mu sansi xabama na tɛmui, won baloma munse ra fa?› ");
INSERT INTO sus_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","N tan nan baraka ragoroma wo ma ɲɛ senni nde kui, naxan findima baloe ra wo bɛ ɲɛ saxan bun ma. ");
INSERT INTO sus_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wo xa sansi xɔri si ɲɛ solomasaxan nde kui, kɔnɔ wo donse ragataxi nan donma han ɲɛ solomanaani nde. Donse naxan nagataxi, na wo ralima nɛ han baloe nɛɛnɛ sa minima tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Wo naxa bɔxi mati a xa lu wo boore yi ra abadan, barima n tan nan gbe bɔxi ra. Wo luxi nɛ alɔ xɔɲɛe naxee yigiyaxi n xɔnyi. ");
INSERT INTO sus_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Sɛriyɛ ki ma, wo xa tin yi bɔxi birin xun xa sara. ");
INSERT INTO sus_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Xa wo ngaxakerenyi nde a xa bɔxi mati a xa setareɲa ma, a bariboore nde xa na bɔxi matixi xun sara. ");
INSERT INTO sus_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Xa a bariboore mu na naxan nɔma na bɔxi xun sarade, kɔnɔ a tan naxa sa na xunsare fɛɛrɛ sɔtɔ a yɛtɛ ra, ");
INSERT INTO sus_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","a xa bɔxi sare kɔnti sɛriyɛ ki ma, kelife a sara tɛmui, a fa na ɲɔxɔɛ ragbilen a sara mixi ma, alako a xa gbilen a xa bɔxi masɔtɔ ra. ");
INSERT INTO sus_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kɔnɔ xa a mu na xunsare fɛɛrɛ sɔtɔ, na bɔxi xa lu a sara mixi yi ra han Xɔrɛya Ɲɛ ra. Na tɛmui bɔxi kanyi man xa gbilen a xa bɔxi masɔtɔ ra.» ");
INSERT INTO sus_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Xa mixi nde sa a xa banxi mati naxan na taa kui tɛtɛ rabilinxi naxan na, a nɔma na banxi xun sarade ɲɛ keren bun ma. ");
INSERT INTO sus_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Xa na banxi xun mu sara na ɲɛ kui, a luma nɛ a sara mixi nun a bɔnsɔɛ yi ra abadan. Hali Xɔrɛya Ɲɛ kui a sara mixi mu kelima naa. ");
INSERT INTO sus_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kɔnɔ banxi naxee tixi taa xunxurie kui, naxee mu rabilinxi tɛtɛ ra, nee luma alɔ bɔxi. E nɔma xun sarade. Naxan na mɔɔli sarama, a lanma a xa mini na banxi Xɔrɛya Ɲɛ ra.» ");
INSERT INTO sus_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Lewikae tan nɔma e xa banxie xun sarade e xa taae kui tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Naxan bara Lewika nde xa banxi sara, a minima nɛ na kui Xɔrɛya Ɲɛ tɛmui, barima banxi naxee na Lewikae xa taae kui, nee findixi Lewikae nan gbe ra Isirayila ɲama tagi. ");
INSERT INTO sus_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Xɛ naxee na Lewikae xa taae rabilinyi, nee mu nɔma matide, barima Lewikae nan gbe e ra abadan.» ");
INSERT INTO sus_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Xa wo ngaxakerenyi nde findi setare ra, fɛɛrɛ mu na a yi ra a baloma naxan na, a lanma wo xa a mali alɔ xɔɲɛ, a xa lu wo fɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Wo naxa riba sa a xa doni xun ma. Wo xa gaaxu Wo Marigi Ala ya ra. Wo xa wo ngaxakerenyi yigiya. ");
INSERT INTO sus_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Wo naxa riba sa a xa doni xun ma, wo naxa riba sa a xa donse sare xun ma. ");
INSERT INTO sus_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Alatala nan n na, wo Marigi Ala, naxan wo raminixi Misira bɔxi kui, n xa Kanaan bɔxi fi wo ma, n xa findi wo Marigi Ala ra.» ");
INSERT INTO sus_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Xa wo ngaxakerenyi nde a yɛtɛ mati wo ma a xa setareɲa ma, wo naxa konyi wali dɔxɔ a ma. ");
INSERT INTO sus_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","A xa lu alɔ wo xa walikɛ, xa na mu a ra wo xa xɔɲɛ han Xɔrɛya Ɲɛ waxati. ");
INSERT INTO sus_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Na tɛmui, a tan nun a xa die xa xɔrɛya, e xa gbilen e xabilɛ ma, e benbae xa bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","barima n ma walikɛe nan Isirayilakae ra, n naxee raminixi Misira bɔxi ra. A mu lanma e xa mati konyiya ra. ");
INSERT INTO sus_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Wo naxa e yamari a ɲaaxi ra, wo xa gaaxu wo Marigi Ala ya ra. ");
INSERT INTO sus_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Xa wo wama konyie xɔn, wo xa e sara si gbɛtɛe tagi, naxee na wo rabilinyi. E tan nan xa findi wo xa konyie ra. ");
INSERT INTO sus_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Wo man nɔma konyie sarade si gbɛtɛe xa mixie ya ma naxee dɔxɔxi wo tagi, a nun e xabilɛe mixi naxee barixi wo xa bɔxi kui. Nee nɔma findide wo xa konyie ra. ");
INSERT INTO sus_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wo nɔma e lude wo xa die yi ra kɛ ra. E nɔma lude konyiya kui abadan, kɔnɔ wo ngaxakerenyi Isirayilakae mu nɔma lude e ngaxakerenyi xa yaamari xɔrɔxɔɛ bun ma.» ");
INSERT INTO sus_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Xa wo ngaxakerenyi setare nde a yɛtɛ mati xɔɲɛ bannaxi ma wo xa bɔxi kui, xa na mu a ra na xɔɲɛ xabilɛ mixi nde ma, ");
INSERT INTO sus_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","wo ngaxakerenyi bariboore nde nɔma a xun sarade. ");
INSERT INTO sus_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","A sɔxɔ, xa na mu a ra a sɔxɔ xa di, xa na mu a ra a bariboore nde gbɛtɛ, nɔma a xun sarade. Xa a fan fɛɛrɛ sɔtɔ, a nɔma a yɛtɛ xun sarade. ");
INSERT INTO sus_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","A xa na xunsare kɔnti sɛriyɛ ki ma, kelife a sara ɲɛ ma, han Xɔrɛya Ɲɛ ra. A xa na ɲɔxɔɛ ragbilen a kanyi ma, a xa lu alɔ wali sare. ");
INSERT INTO sus_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Xa ɲɛ wuyaxi luxi, a xunsare xa gbo na ki a kanyi mabiri. ");
INSERT INTO sus_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Xa ɲɛ wuyaxi mu luxi beenu Xɔrɛya Ɲɛ xa a li, a xunsare xa lan na ɲɛ xasabi ma. ");
INSERT INTO sus_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A nɔma lude alɔ walikɛ a kanyi xɔnyi, kɔnɔ a mu lanma a kanyi xa a yamari a ɲaaxi ra. ");
INSERT INTO sus_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Xa a mu nɔma a yɛtɛ xun sarade yi fɛɛrɛ mɔɔli yo ra, a tan nun a xa die xa lu e kanyi yi ra han Xɔrɛya Ɲɛ ra, ");
INSERT INTO sus_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","barima n tan nan ma walikɛe na Isirayilakae ra, n naxee raminixi Misira bɔxi ra. Alatala nan n na, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Wo naxa kuye yo yailan, wo naxa ala nde rafala, wo naxa gɛmɛ batu daaxi dɔxɔ, wo naxa gɛmɛ masolixi batu, barima Alatala nan n na, wo Marigi Ala. ");
INSERT INTO sus_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Wo xa n ma malabui lɔxɔɛe rabatu, wo xa n ma yire sɛniyɛnxi binya. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Xa wo n ma sɛriyɛ suxu, xa wo n ma yaamarie rabatu, ");
INSERT INTO sus_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","n tunɛ ragoroma nɛ wo bɛ a waxati, bɔxi daxamui raminima nɛ, sansie bogima nɛ xɛ ma. ");
INSERT INTO sus_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Sansi bɔnbɔ tɛmui buma nɛ han wɛni bogi ba tɛmui. Wɛni bogi ba tɛmui fan buma nɛ han sansi si tɛmui. Wo wasama nɛ baloe ra, wo sabati wo xa bɔxi ma bɔɲɛsa kui. ");
INSERT INTO sus_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","N hinnɛma wo ra alako wo xa xi bɔɲɛsa kui, alako burunyi subee nun geresoe naxa wo tɔɔrɔ wo xɔnyi. ");
INSERT INTO sus_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Wo nɔma nɛ wo yaxuie ra santidɛgɛma ra. ");
INSERT INTO sus_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Wo xa sɔɔri suuli fama nɛ wo yaxui mixi kɛmɛ keride. Wo xa sɔɔri kɛmɛ fama wo yaxui mixi wulu fu keride. Wo fama nɔde wo yaxuie ra gere kui. ");
INSERT INTO sus_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Won birin na a ra. N di wuyaxi fima nɛ wo ma, n wo rawuya. N nan n ma saatɛ rakamalima nɛ wo bɛ. ");
INSERT INTO sus_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Wo yala maale donma nɛ han maale xaba tɛmui. Wo a fori bama nɛ a sasee kui a xa gboe ma, alako wo xa nɔ maale nɛɛnɛ ragatade. ");
INSERT INTO sus_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","N luma nɛ wo sɛɛti ma, n mu mɛɛma wo ra. ");
INSERT INTO sus_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","N ɲɛrɛma nɛ wo ya ma. Wo Marigi Ala nan n na, wo fan bara findi n ma ɲama ra. ");
INSERT INTO sus_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Alatala nan n na, wo Marigi Ala, naxan wo ramini Misira bɔxi ra alako wo naxa lu e yi ra. N bara konyiya kote ba wo xun ma, alako wo xa ɲɛrɛ xunnakeli kui.» ");
INSERT INTO sus_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Kɔnɔ, xa wo mu n xui ramɛ, xa wo mu n ma yaamarie birin nabatu, ");
INSERT INTO sus_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","xa wo mu n ma sɛriyɛ suxu, xa wo mu bira n waxɔnfe fɔxɔ ra, xa wo n ma saatɛ kana, ");
INSERT INTO sus_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","n yi nan nabama wo ra: N yihadi ragoroma nɛ wo ma, n wo rafurama nɛ fure ɲaaxi ra naxan wo yae kanama, naxan wo bɔɲɛ tɔɔrɔma. Wo sansi xɔrie sima nɛ fufafu, barima wo yaxuie na birin donma nɛ. ");
INSERT INTO sus_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","N gbilenma nɛ wo fɔxɔ ra. Wo yaxuie nɔma nɛ wo ra, wo xɔnnantee wo yamarima nɛ. Wo luma gaaxui nan kui, wo nu wo gi hali mixi mu na wo fɔxɔ ra.» ");
INSERT INTO sus_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Kɔnɔ na birin kui, wo mu fama n xui ramɛde. N wo ɲaxankatama han sanmaya solofere wo xa yunubie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","N wo xa yɛtɛ igboɲa kanama nɛ. N koore balanma nɛ wo ya ra han wo xa bɔxi xɔrɔxɔ alɔ wure gbeeli. ");
INSERT INTO sus_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Wo sɛnbɛ ɲɔnma nɛ fufafu. Wo xa bɔxi tondima nɛ daxamui raminide, wo xa sansie mu bogima sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Xa wo lu n matandi ra, xa wo mu n xui ramɛ, n wo ɲaxankatama han sanmaya solofere wo xa yunubie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","N burunyi subee rafama nɛ wo xili ma. E wo xa die faxama nɛ, e wo xa xurusee ibɔɔ, e wo sɔntɔ han mixi ɲɔn kirae xɔn ma.» ");
INSERT INTO sus_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Na birin naba xanbi wo ra, xa wo mu tin n ma sɛriyɛ ra, xa wo lu n matandi ra, ");
INSERT INTO sus_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","n fe xɔrɔxɔɛ rafama nɛ wo ma, n wo ɲaxankata han sanmaya solofere wo xa yunubie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","N gere rakelima nɛ wo ma n ma saatɛ kanaxi xa fe ra. Wo na wo nɔxun wo xa taa makantaxie kui, n wo rafurama nɛ fure ɲaaxi ra, wo fa lu wo yaxuie sagoe. ");
INSERT INTO sus_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","N kaamɛ radinma wo ma tɛmui naxɛ, ginɛ fu taami ganma nɛ taami ganse keren kui. E na itaxun a xunxuri ra, e a xanin wo xɔn ma wo a don, kɔnɔ a mu wo wasama.» ");
INSERT INTO sus_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Na birin naba xanbi wo ra, xa wo mu wo tuli mati n na, xa wo tondi n waxɔnfe suxude, ");
INSERT INTO sus_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","n fe xɔrɔxɔɛ rafama nɛ wo ma, n wo ɲaxankata han sanmaya solofere wo xa yunubie xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Wo fama wo xa die sube yati donde. ");
INSERT INTO sus_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","N wo xa kuye batudee kanama nɛ naxee na geyae fari. N wo xa gɛmɛe rabirama nɛ, wo naxee batuma. N furee malanma nɛ wo xa kuyee fari. N wo rabɛɲinma nɛ, ");
INSERT INTO sus_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","n wo xa taae findi gbengberenyi ra, n wo xa batudee kana, n tondi wo xa sɛrɛxɛe suxude sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","N na gɛ wo xa bɔxi kanade, wo yaxuie yati fama kaabade na xa fe ra. ");
INSERT INTO sus_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","N wo rayensenma nɛ ɲamanɛ gbɛtɛe ma, n wo ɲaxankatama nɛ santidɛgɛma ra. Wo xa bɔxi kanama nɛ, mixi yo mu luma wo xa taae kui.» ");
INSERT INTO sus_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Na waxati bun ma wo xa bɔxi malabuma nɛ. Wo na wo yaxuie yire tɛmui naxɛ, wo xa bɔxi fanma nɛ malabui saabui ra. ");
INSERT INTO sus_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Wo xa bɔxi malabui sɔtɔma na waxati nan kui a mu naxan sɔtɔ wo nu na mɛnni tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Naxee mu faxama na geree kui, nee luma nɛ gaaxui kui e yaxuie yire, hali wuri burɛxɛ nan din e ra, fo e e gi. E e gima nɛ, e bira hali santidɛgɛma kanyi yo mu na e fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","E birama nɛ e boore fari, alɔ santidɛgɛma kanyi nan e fɔxɔ ra, a fa li mixi yo mu na e fɔxɔ ra. Wo mu nɔma tide wo yaxuie ya ra. ");
INSERT INTO sus_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Wo sɔntɔma nɛ si gbɛtɛe tagi, wo yaxuie nɔma nɛ wo ra. ");
INSERT INTO sus_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Naxee mu faxama gere kui wo ya ma, nee fama nɛ faxade e yaxuie xa bɔxi ma e xa yunubie nun e benbae xa yunubie xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«E fama e xa yunubie nun e benbae xa yunubie masende n bɛ, a nun e naxan nabaxi n na matandi kui. ");
INSERT INTO sus_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","N fan e tɔɔrɔma nɛ e yaxuie xa bɔxi kui, alako mixi naxee e yɛtɛ fixi n ma, e xa magoro. E xa e xa yunubie sare fi. ");
INSERT INTO sus_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Na tɛmui n nan n ɲɔxɔ sama nɛ n ma saatɛ xɔn ma naxan na n tan, nun Yaxuba, Isiyaga, nun Iburahima tagi. N mu nɛɛmuma na bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Bɔxi fama nɛ malabude na tɛmui, barima Isirayilakae bara siga pon e xa yunubi sare fide. E bara n ma sɛriyɛ bɛɲin, e bara yo n ma yaamarie ma.» ");
INSERT INTO sus_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","«Kɔnɔ, n na e keri sigafe ra e yaxuie yire tɛmui naxɛ, n mu e rabɛɲinma han e xa sɔntɔ. N mu n ma saatɛ kanama e tan ma fe ra, barima Alatala nan n na, e Marigi Ala. ");
INSERT INTO sus_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","N nan n ɲɔxɔ sama nɛ n ma saatɛ singe xɔn ma, n e ramini Misira bɔxi ra sie ya xɔri tɛmui naxɛ, alako n xa findi e Marigi Ala ra. Alatala nan n na.» ");
INSERT INTO sus_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Alatala xa sɛriyɛ, a xa yaamarie, nun a xa masenyie nan na ki Alatala naxee masenxi Isirayilakae bɛ Annabi Munsa saabui ra Turusinina geya fari. ");
INSERT INTO sus_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Alatala naxa a masen Annabi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«A fala Isirayilakae bɛ, xa mixi nde laayidi tongo, a xa mixi nde fi n tan Alatala ma, a nɔma a xun sarade yi kɔbiri xasabi nan na. ");
INSERT INTO sus_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Xa xɛmɛ na a ra naxan xa simaya kelima ɲɛ mɔxɔɲɛn han ɲɛ tongo senni, a xun sarama gbeti kole tongo suuli nan na naxan maniyama yire sɛniyɛnxi maniyase ra. ");
INSERT INTO sus_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Xa ginɛ na a ra, a xun sarama gbeti kole tongo saxan nun a tagi nan na. ");
INSERT INTO sus_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Xa di xɛmɛ na a ra naxan xa simaya kelima ɲɛ suuli han ɲɛ mɔxɔɲɛn, a xun sarama gbeti kilo mɔxɔɲɛn nan na. Xa ginɛ dimɛdi na a ra, a xun sarama gbeti kole fu nan na. ");
INSERT INTO sus_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Xa di xɛmɛ na a ra naxan mu ɲɛ suuli sɔtɔxi sinden, a xun sarama gbeti kole suuli nan na. Xa di ginɛ na a ra, a xun sarama gbeti kole saxan nan na. ");
INSERT INTO sus_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Xa xɛmɔxi na a ra naxan xa simaya dangima ɲɛ tongo senni ra, a xun sarama gbeti kole fu nun suuli nan na. Xa ɲɛlɛxɛfori na a ra, a xun sarama gbeti kole fu nan na. ");
INSERT INTO sus_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Xa setare bara na laayidi tongo, naxan mu nɔma na xunsare xasabi fide, a lan a xa a yɛtɛ masen sɛrɛxɛdubɛ bɛ naxan fama xunsare xasabi falade a bɛ a nɔma naxan na.» ");
INSERT INTO sus_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Xa mixi nde laayidi tongo xuruse nde fife ra, naxan nɔma bade sɛrɛxɛ ra n tan Alatala bɛ, na xuruse xa fi n tan Alatala ma. A bara sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Xuruse gbɛtɛ mu fima a masare ra, a fan ba, a mu fan ba. Xa wo na rabama, e firinyi bara findi se sɛniyɛnxi ra. ");
INSERT INTO sus_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Xa sube raharamuxi na a ra, naxan mu bama sɛrɛxɛ ra n tan Alatala bɛ, a xa xanin sɛrɛxɛdubɛ xɔn. ");
INSERT INTO sus_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Sɛrɛxɛdubɛ xa xunsare nde fala sube kɛɲa ma. Na xa findi a sare ra. ");
INSERT INTO sus_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Xa a kanyi wama na sube xun sarafe, a xa na sare fi, a man xa kɔbiri nde sa na fari. Na findima kɔbiri naxan na, a na se sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na fi xunsare ra.» ");
INSERT INTO sus_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Xa mixi nde a xa banxi fi n tan Alatala ma, sɛrɛxɛdubɛ xa na sare fala banxi kɛɲa ma. Na xa findi a sare ra. ");
INSERT INTO sus_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Xa a kanyi wama a xun sarafe, a xa na sare fi, a man xa kɔbiri nde sa na fari. Na findima kɔbiri naxan na, a na banxi sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na fi xunsare ra. Na tɛmui banxi xa gbilen a kanyi ma.» ");
INSERT INTO sus_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Xa mixi nde a xa xɛ fi n tan Alatala ma, a sare fatanma sansi xɔri xasabi nan na naxan nɔma garansande naa. Gbeti kole tongo suuli xa fi fundenyi maniyɛ busali naani xasabi ra. ");
INSERT INTO sus_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Xa a a xa xɛ fi Xɔrɛya Ɲɛ nan kui, a sare mu masarama. ");
INSERT INTO sus_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Xa a a xa xɛ fi Xɔrɛya Ɲɛ dangi xanbi nɛ, sɛrɛxɛdubɛ xa ɲɛe kɔnti naxee luxi beenu Xɔrɛya Ɲɛ gbɛtɛ xa fa. A xa nde ba xɛ sare ra na sɛriyɛ kui. ");
INSERT INTO sus_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Xa xɛ kanyi wama a xa xɛ xun sarafe, a xa na sare fi, a man xa kɔbiri nde sa na fari. Na findima kɔbiri naxan na, a na xɛ sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na fi xunsare ra. Na tɛmui xɛ xa lu a yi ra. ");
INSERT INTO sus_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Xa a mu xɛ xun sara, a fa a mati mixi gbɛtɛ ma, a mu nɔma a xun sarade sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Xɔrɛya Ɲɛ na a li, na xɛ kanyi nɛɛnɛ xa keli na bɔxi ma. Bɔxi bara sɛniyɛn, a bara lu alɔ bɔxi naxan natɔnxi. A bara findi Alatala gbe ra, sɛrɛxɛdubɛe xa na rawali. ");
INSERT INTO sus_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Xa mixi bara xɛ saraxi fi Alatala ma, naxan mu na a xabilɛ kɛ ya ma, ");
INSERT INTO sus_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sɛrɛxɛdubɛ xa a sare fala a sɛriyɛ ki ma. A na kolonma ɲɛ xasabi nan ma naxee luxi beenu Xɔrɛya Ɲɛ xa a li. Na kanyi xa a sare fi na lɔxɔɛ yati, barima a sɛniyɛn n tan Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Xɔrɛya Ɲɛ na a li, na xɛ gbilenma na xɛ kanyi singe nan ma, boore a sara naxan ma. ");
INSERT INTO sus_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Na saree birin maniyama yire sɛniyɛnxi xa se maniya ki nan ma. A kole keren lanxi garamu fu nan ma.» ");
INSERT INTO sus_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Mixi yo mu nɔma a xa xuruse di singe fide n tan Alatala ma, barima a ɲan findixi n tan Alatala gbe nan na. Xuruse xungbe nun a lanma di singe birin findixi n tan nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mixi nɔma sube raharamuxi xa di singe xun sarade. Na mixi xa a sare fi, a man xa kɔbiri nde sa na fari. Na findima kɔbiri naxan na, a na sube sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na fi a xunsare ra. Xa a kanyi mu a xun sarama, a xa a mati a sare ra.» ");
INSERT INTO sus_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Kɔnɔ se ndee na mixi naxee fima n tan Alatala ma a bɔɲɛ birin na e findi n gbe ra, adama mu nɔma nee xun sarade sɔnɔn. Nee bara sɛniyɛn, nee bara findi n tan Alatala gbansan gbe ra. Nee nɔma findide mixi, xuruse, xɛ, xa na mu a ra se gbɛtɛ ra. ");
INSERT INTO sus_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Mixi se naxee fima n tan Alatala ma na mɔɔli ra, e xun mu nɔma sarade, fo e xa faxa nɛ.» ");
INSERT INTO sus_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Bɔxi farilɛ birin findima n tan Alatala nan gbe ra, sansi xɔri naxan naminima nun wuri bili naxan bogima. Na farilɛ birin fima n tan Alatala nan ma. ");
INSERT INTO sus_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Xa mixi nde wama a xa farilɛ xun sarafe, a xa a sare fi, a man xa kɔbiri nde sa na fari. Na findima kɔbiri naxan na, a na se sare nan itaxunma dɔxɔ suuli ra, a fa dɔxɔ keren ba a ra, a na fi a xunsare ra. ");
INSERT INTO sus_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Xuruse farilɛ birin findima n tan Alatala nan gbe ra, xuruse xungbe nun a lanma, xuruse dɛmadonyi naxan birin kɔntima. Na farilɛ birin fima n tan Alatala nan ma. ");
INSERT INTO sus_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Xurusee mu matoma xa a fan, xa a mu fan. Xuruse mu nɔma masarade xuruse gbɛtɛ ra, xa na mu a ra na firinyi birin sɛniyɛnma nɛ, e findi n tan Alatala gbe ra, e sese mu nɔma xun sarade sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Alatala xa yaamarie nan na ki, a naxee so Annabi Munsa yi ra Turusinina geya fari Isirayilakae bɛ.");
INSERT INTO sus_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isirayilakae xa mini Misira ɲɛ firin nde, kike firin nde, xi singe, Alatala naxa a masen Munsa bɛ Turusinina gbengberenyi ma hɔrɔmɔlingira kui, ");
INSERT INTO sus_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Wo xa Isirayila xɛmɛ birin kɔnti a xabilɛ nun a denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","naxee xa simaya bara ɲɛ mɔxɔɲɛn li, naxee nɔma findide Isirayila sɔɔrie ra. I nun Haruna, wo xa e itaxun sɔɔri gaali ki ma. ");
INSERT INTO sus_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Bɔnsɔɛ xunyie xa wo mali na wali kui. ");
INSERT INTO sus_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","E xilie nan ya: Ruben bɔnsɔɛ ya ma, Sedeyuri xa di xɛmɛ Elisuru. ");
INSERT INTO sus_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeyɔn bɔnsɔɛ ya ma, Surisadayi xa di xɛmɛ Selumiyeli. ");
INSERT INTO sus_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yuda bɔnsɔɛ ya ma, Aminadabo xa di xɛmɛ Naxason. ");
INSERT INTO sus_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakari bɔnsɔɛ ya ma, Suwara xa di xɛmɛ Netaneeli. ");
INSERT INTO sus_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sabulon bɔnsɔɛ ya ma, Xelon xa di xɛmɛ Eliyabi. ");
INSERT INTO sus_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yusufu xa di xɛmɛ Efirami bɔnsɔɛ ya ma, Amixudi xa di xɛmɛ Elisama. Yusufu xa di xɛmɛ Manasi bɔnsɔɛ ya ma, Pedasuru xa di xɛmɛ Gamaliyɛli. ");
INSERT INTO sus_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Bunyamin bɔnsɔɛ ya ma, Gideyoni xa di xɛmɛ Abidan. ");
INSERT INTO sus_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dana bɔnsɔɛ ya ma, Amisadayi xa di xɛmɛ Axiyeseri. ");
INSERT INTO sus_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aseri bɔnsɔɛ ya ma, Okiran xa di xɛmɛ Pagiyɛli. ");
INSERT INTO sus_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gadi bɔnsɔɛ ya ma, Duweli xa di xɛmɛ Eliyasafa. ");
INSERT INTO sus_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nafatali bɔnsɔɛ ya ma, Enan xa di xɛmɛ Axira.» ");
INSERT INTO sus_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Na bɔnsɔɛ xunyie nan xilixi, e xa findi Isirayila sɔɔri mangɛe ra. ");
INSERT INTO sus_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","E naxa kafu Munsa nun Haruna ma, ");
INSERT INTO sus_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","e xa Isirayila ɲama malan, na kike firin nde, xi singe. Xɛmɛ birin naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, e naxa e tɛngɛ e xabilɛ nun e denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","alɔ Alatala a yamari ki naxɛ. Munsa naxa e tɛngɛ Turusinina gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","E naxa Isirayila xa di singe Ruben bɔnsɔɛ birin tɛngɛ e xabilɛ nun e denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Na xasabi lan nɛ xɛmɛ wulu tongo naani nun senni, xɛmɛ kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","E naxa Simeyɔn bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Na xasabi lan nɛ xɛmɛ wulu tongo suuli nun solomanaani, xɛmɛ kɛmɛ saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","E naxa Gadi bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Na xasabi lan nɛ xɛmɛ wulu tongo naani nun suuli, xɛmɛ kɛmɛ senni tongo suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","E naxa Yuda bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Na xasabi lan nɛ xɛmɛ wulu tongo solofere nun naani, xɛmɛ kɛmɛ senni nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","E naxa Isakari bɔnsɔɛ birin tɛngɛ e xabilɛ nun e denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Na xasabi lan nɛ xɛmɛ wulu tongo suuli nun naani, xɛmɛ kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","E naxa Simeyɔn bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Na xasabi lan nɛ xɛmɛ wulu tongo suuli nun solofere, xɛmɛ kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","E naxa Yusufu xa di xɛmɛ Efirami bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Na xasabi lan nɛ xɛmɛ wulu tongo naani, xɛmɛ kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","E naxa Yusufu xa di xɛmɛ Manasi bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Na xasabi lan nɛ xɛmɛ wulu tongo saxan nun firin, xɛmɛ kɛmɛ firin nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","E naxa Bunyamin bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Na xasabi lan nɛ xɛmɛ wulu tongo saxan nun suuli, xɛmɛ kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","E naxa Dana bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Na xasabi lan nɛ xɛmɛ wulu tongo senni nun firin, xɛmɛ kɛmɛ solofere nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","E naxa Aseri bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Na xasabi lan nɛ xɛmɛ wulu naani nun keren, xɛmɛ kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","E naxa Nafatali bɔnsɔɛ birin tɛngɛ e xabilɛ nun e xa denbaya ki ma. E naxa xɛmɛe xili sɛbɛ, naxee xa simaya nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade. ");
INSERT INTO sus_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Na xasabi lan nɛ xɛmɛ wulu tongo suuli nun saxan, xɛmɛ kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Isirayila bɔnsɔɛ xunyi fu nun firinyi nan kafu Munsa nun Haruna ma na tɛngɛ tife ra. ");
INSERT INTO sus_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Isirayila xɛmɛ naxee nu bara ɲɛ mɔxɔɲɛn li, naxee nu nɔma sɔɔriɲa rabade, ");
INSERT INTO sus_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","nee nu lanxi xɛmɛ wulu kɛmɛ senni nun saxan, xɛmɛ kɛmɛ suuli nun tongo suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Kɔnɔ Lewi bɔnsɔɛ mu nu na na kɔnti ya ma, ");
INSERT INTO sus_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","barima Alatala nu bara a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«I naxa Lewikae tɛngɛ Isirayilakae ya ma. ");
INSERT INTO sus_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","I xa hɔrɔmɔlingira nun a xa se birin taxu e ra. N ma saatɛ tɔnxuma na a ra. E xa a maxanin, e xa mɛɛni a ma, e xa yonkin a rabilinyi ra. ");
INSERT INTO sus_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wo na keli sigade, e xa a ragoro. Wo na yire nɛɛnɛ li, e xa a ti. Xa mixi gbɛtɛ a maso a ra naxan mu findi Lewi bɔnsɔɛ ra, na kanyi lan nɛ a xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isirayilaka birin xa yonkin yire e na dɛnnaxɛ masen e bɛ, e bɔnsɔɛ xa tɔnxuma bun ma, a nun e xa sɔɔrie. ");
INSERT INTO sus_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewi bɔnsɔɛe xa yonkin hɔrɔmɔlingira rabilinyi, xa na mu a ra n xɔnɔma nɛ Isirayila ɲama ma. Lewikae xa e ɲɛngi sa hɔrɔmɔlingira xɔn ma.» ");
INSERT INTO sus_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Isirayilakae naxa Alatala xa yaamari birin suxu, a naxan soxi Munsa yi ra. ");
INSERT INTO sus_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Isirayilaka birin yonkinma e xabilɛ xa tɔnxuma nan bun ma. E birin ya rafindima e booree nan ma, hɔrɔmɔlingira fa lu e tagi.» ");
INSERT INTO sus_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Yuda bɔnsɔɛ nan yonkinma sogetede mabiri e xa tɔnxuma bun ma. Aminadabo xa di Naxason nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A xa sɔɔrie xasabi lan mixi wulu tongo solofere nun naani, mixi kɛmɛ senni nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isakari bɔnsɔɛ nan yonkinma Yuda bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Suwara xa di Netaneeli nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A xa sɔɔrie xasabi lan mixi wulu tongo suuli nun naani, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sabulon bɔnsɔɛ nan yonkinma Yuda bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Xelon xa di Eliyabi nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A xa sɔɔrie xasabi lan mixi wulu tongo suuli nun solofere, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Gali naxan yonkin Yuda bɔnsɔɛ mabiri, e xasabi lan mixi wulu kɛmɛ mixi wulu tongo solomasaxan nun senni, mixi kɛmɛ naani nan ma. E tan nan tima yare ra. ");
INSERT INTO sus_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ruben bɔnsɔɛ nan yonkinma sogetede mabiri e xa tɔnxuma bun ma. Sedeyuri xa di Elisuru nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A xa sɔɔrie xasabi lan mixi wulu tongo naani nun senni, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeyɔn bɔnsɔɛ nan yonkinma Ruben bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Surisadayi xa di Selumiyeli nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A xa sɔɔrie xasabi lan mixi wulu tongo suuli nun solomanaani, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gadi bɔnsɔɛ nan yonkinma Ruben bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Duweli xa di Eliyasafa nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A xa sɔɔrie xasabi lan mixi wulu tongo naani nun suuli, mixi kɛmɛ senni nun tongo suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Gali naxan yonkin Ruben bɔnsɔɛ mabiri, e xasabi lan mixi wulu kɛmɛ mixi wulu tongo suuli nun keren, mixi kɛmɛ naani nun tongo suuli nan ma. E tan nan sigama a firin nde. ");
INSERT INTO sus_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Lewi bɔnsɔɛ naxan yonkinma e tagi, a birama e fɔxɔ ra hɔrɔmɔlingira xaninfe ra. Bɔnsɔɛ birin ɲɛrɛma e safɛ ki nan ma e xa tɔnxuma bun ma. ");
INSERT INTO sus_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efirami bɔnsɔɛ nan yonkinma sogegorode mabiri e xa tɔnxuma bun ma. Amixudi xa di Elisama nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A xa sɔɔrie xasabi lan mixi wulu tongo naani, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manasi bɔnsɔɛ nan yonkinma Efirami bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Pedasuru xa di Gamaliyɛli nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A xa sɔɔrie xasabi lan mixi wulu tongo saxan nun firin, mixi kɛmɛ firin nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Bunyamin bɔnsɔɛ nan yonkinma Efirami bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Gideyoni xa di Abidan nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A xa sɔɔrie xasabi lan mixi wulu tongo saxan nun suuli, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Gali naxan yonkin Efirami bɔnsɔɛ mabiri, e xasabi lan mixi wulu kɛmɛ mixi wulu solomasaxan, mixi kɛmɛ nan ma. E tan nan sigama a saxan nde. ");
INSERT INTO sus_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dana bɔnsɔɛ nan yonkinma yirefanyi mabiri e xa tɔnxuma bun ma. Amisadayi xa di Axiyeseri nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A xa sɔɔrie xasabi lan mixi wulu tongo senni nun firin, mixi kɛmɛ solofere nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aseri bɔnsɔɛ nan yonkinma Dana bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Okiran xa di Pagiyɛli nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A xa sɔɔrie xasabi lan mixi wulu tongo naani nun keren, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Nafatali bɔnsɔɛ nan yonkinma Dana bɔnsɔɛ sɛɛti ma e xa tɔnxuma bun ma. Enan xa di Axira nan e xa yarerati ra. ");
INSERT INTO sus_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A xa sɔɔrie xasabi lan mixi wulu tongo suuli nun saxan, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Gali naxan yonkin Dana bɔnsɔɛ mabiri, e xasabi lan mixi wulu kɛmɛ mixi wulu tongo suuli nun solofere, mixi kɛmɛ senni nan ma. E tan nan sigama a dɔnxɔɛ ra e xa tɔnxumae bun ma. ");
INSERT INTO sus_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isirayilaka naxee tɛngɛ e xabilɛ ki ma nun e xa sɔɔri gali ki ma, e xasabi lan mixi wulu kɛmɛ senni nun saxan, mixi kɛmɛ suuli nun tongo suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewi bɔnsɔɛ tan mu tɛngɛ Isirayilakae xun ma, alɔ Alatala a masen ki naxɛ Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Isirayilakae naxa bira Alatala xa yaamari birin fɔxɔ ra, alɔ a Munsa yamari a ra ki naxɛ. E nu yonkinma e xa tɔnxuma nan bun ma, e man nu ɲɛrɛma e xabilɛ nun e xa denbaya ki nan ma. ");
INSERT INTO sus_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Haruna nun Munsa xa taruxui nan ya, Alatala to wɔyɛn Munsa bɛ Turusinina geya ma. ");
INSERT INTO sus_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Haruna xa di xɛmɛe xilie nan yi ki: a xa di xɛmɛ singe nu xili nɛ Nadabo, a xunyae, Abihu, Eleyasari, nun Itamari. ");
INSERT INTO sus_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nee nan sugandixi e xa findi sɛrɛxɛdubɛe ra. ");
INSERT INTO sus_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kɔnɔ Nadabo nun Abihu naxa faxa Alatala ya i e to sɛrɛxɛ gan tɛ ra naxan mu lanxi. E mu di yo sɔtɔ, kɔnɔ Eleyasari nun Itamari naxa lu sɛrɛxɛdubɛɲa kui e baba Haruna xa yaamari bun ma. ");
INSERT INTO sus_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«I xa Lewi bɔnsɔɛ masen Haruna bɛ, e xa a mali a xa sɛrɛxɛdubɛ wali kui. ");
INSERT INTO sus_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","E xa Haruna nun Isirayila ɲama mali hɔrɔmɔlingira wali kui. ");
INSERT INTO sus_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","E xa e ɲɔxɔ sa hɔrɔmɔlingira raxunmasee xɔn na, e man xa hɔrɔmɔlingira wali raba Isirayilakae bɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Na kui i Lewi bɔnsɔɛ sama Haruna nun a xa di xɛmɛe nan sago. E sugandixi Isirayilakae ya ma Haruna malife nan na. ");
INSERT INTO sus_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","I xa Haruna nun a xa die nan tun ti sɛrɛxɛdubɛ wali rabafe ra. Xa mixi gbɛtɛ sa a maso hɔrɔmɔlingira ra, na kanyi xa faxa.» ");
INSERT INTO sus_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«N bara Lewi bɔnsɔɛ sugandi Isirayilakae tagi Isirayila ginɛe xa di singe birin ɲɔxɔɛ ra. Na bɔnsɔɛ findixi n gbe nan na, ");
INSERT INTO sus_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","barima n gbe nan na di xɛmɛ singe birin na. N to di xɛmɛ singe birin faxa Misira bɔxi ma, n naxa Isirayila di xɛmɛ singe birin sugandi n yɛtɛ bɛ, a findi mixi ra, a findi xuruse ra. N tan nan na Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Alatala naxa a masen Munsa bɛ Turusinina gbengberenyi ma, ");
INSERT INTO sus_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Lewi bɔnsɔɛ tɛngɛ a denbaya nun a xabilɛ ki ma. Xɛmɛ birin tɛngɛma nɛ naxan ma simaya bara kike keren li.» ");
INSERT INTO sus_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Munsa naxa e tɛngɛ alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lewi xa di xɛmɛe xilie nan yi ki: Gerison, Kehati, nun Merari. ");
INSERT INTO sus_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerison xa di xɛmɛe xilie nan yi ki a xabilɛ ki ma: Libini nun Simeyi. ");
INSERT INTO sus_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehati xa di xɛmɛe a xabilɛ ki ma: Amarama, Yisehari, Xebiron nun Yusiyɛli. ");
INSERT INTO sus_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari xa di xɛmɛe a xabilɛ ki ma: Maxali nun Musi. Lewi xabilɛ nan na ki e xa denbaya ki ma. ");
INSERT INTO sus_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerison bɔnsɔɛ nu na Libini Simeyi xabilɛ nan na. ");
INSERT INTO sus_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Naxee xa simaya nu bara kike keren li, e xasabi lan mixi wulu solofere mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gerison xabilɛ nu yonkinma hɔrɔmɔlingira nan xanbi ra sogegorode mabiri ra. ");
INSERT INTO sus_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","E xunyi nu na Layɛli xa di xɛmɛ Eliyasafa nan na. ");
INSERT INTO sus_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gerison xa mixie nu e ɲɔxɔɛ saxi hɔrɔmɔlingira nan xɔn ma, nun mafelenyi naxan felenma a xun ma, a nun a sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","a nun kɔlimɛ naxee nu sama hɔrɔmɔlingira nun sɛrɛxɛbade rabilinyi ma, a nun na tɛtɛ sode dɛ ra, a nun luutie e na maxirima naxee ra. ");
INSERT INTO sus_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kehati xa mixie nan yi ki: Amarama xabilɛ, Yisehari xabilɛ, Xebiron xabilɛ, nun Yusiyɛli xabilɛ. Na xabilɛe nan minixi e benba Kehati ma. ");
INSERT INTO sus_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","E xa di xɛmɛ naxee xa simaya nu bara kike keren li, e xasabi lan mixi wulu solomasaxan kɛmɛ senni nan ma. Kehati xa mixie nan nu mɛɛnima hɔrɔmɔlingira ma. ");
INSERT INTO sus_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","E tan nu yonkinma hɔrɔmɔlingira yirefanyi mabiri nɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Yusiyɛli xa di xɛmɛ Elisafan nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Hɔrɔmɔlingira saatɛ kankira, teebili, lanpuie, sɛrɛxɛbadee, yirabase naxee rawalima yire sɛniyɛnxi kui, nun dugi yarasa naxan na hɔrɔmɔlingira kui, e nu taxuxi e tan nan na. ");
INSERT INTO sus_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lewi bɔnsɔɛ birin xunyi nu na Haruna xa di xɛmɛ Eleyasari nan na. A tan nan nu Lewi bɔnsɔɛ mixie xun ma, naxee mɛɛnima hɔrɔmɔlingira ma. ");
INSERT INTO sus_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari xa mixie nan yi ki: Maxali xabilɛ nun Musi xabilɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","E xa di xɛmɛ naxee xa simaya nu bara kike keren li, e xasabi lan mixi wulu senni kɛmɛ firin nan ma. ");
INSERT INTO sus_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Abixayili xa di xɛmɛ Suriyeli nan nu na Merari xabilɛe xunyi ra. E nu yonkinma hɔrɔmɔlingira kɔɔla mabiri nɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hɔrɔmɔlingira xebenyie, a wuri kuyee, a kɔntigibae, a sanbunyie, a xa yirabase, nun a rawalisee nu taxuxi e tan nan na. ");
INSERT INTO sus_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","E man nu e ɲɔxɔ sama kɔntigibae xɔn ma naxee nu hɔrɔmɔlingira tɛtɛ rabilinxi, a nun e sanbunyie, e xa kɔridie, nun e xa luutie. ");
INSERT INTO sus_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Munsa, Haruna, nun a xa di xɛmɛe nu yonkinma hɔrɔmɔlingira sode dɛ nan na sogetede mabiri. E tan nan nu e ɲɔxɔ sama hɔrɔmɔlingira xɔn ma Isirayilaka birin xili ra. Xa mixi gbɛtɛ sa a maso hɔrɔmɔlingira ra, na kanyi xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewi bɔnsɔɛ di xɛmɛ naxee xa simaya nu bara kike keren li, e xasabi lan mixi wulu mɔxɔɲɛn nun firin nan ma. Munsa nun Haruna nu bara e tɛngɛ e xabilɛ ki ma alɔ Alatala e yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Alatala naxa a masen Munsa bɛ, «Di xɛmɛ singe birin tɛngɛ Isirayilakae ya ma, naxee simaya bara kike keren li, i xa e xilie sɛbɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Lewi bɔnsɔɛ xa findi Isirayila di xɛmɛ singe birin ɲɔxɔɛ ra. Lewi bɔnsɔɛ xa gɔɔrɛ xa findi Isirayilakae xa xurusee di singee ɲɔxɔɛ ra. N tan nan na Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Munsa naxa Isirayila di xɛmɛ singe birin tɛngɛ alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Isirayila di xɛmɛ singe birin naxee xa simaya bara kike keren li, e xasabi lan mixi wulu mɔxɔɲɛn nun firin mixi kɛmɛ firin tongo solofere nun saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Lewi bɔnsɔɛ xa findi Isirayila di xɛmɛ singe birin ɲɔxɔɛ ra. Lewi bɔnsɔɛ xa gɔɔrɛ xa findi Isirayilakae xa xurusee di singee ɲɔxɔɛ ra. N tan nan na Alatala ra. ");
INSERT INTO sus_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Na Isirayila di xɛmɛ singe mixi kɛmɛ firin tongo solofere nun saxan naxee xasabi dangi Lewi bɔnsɔɛ kɔnti ra, ");
INSERT INTO sus_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","i xa kankan xun sara gbeti giramu tongo suuli nun solofere ra naxan mɔɔli rawalima hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","I xa na gbeti so Haruna nun a xa di xɛmɛ yi ra, di singee xunsare ra naxee xasabi nu dangi Lewi bɔnsɔɛ xasabi ra.» ");
INSERT INTO sus_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Munsa naxa na gbeti suxu naxan fixi di singee xunsare xa fe ra, naxee xasabi nu dangi Lewi bɔnsɔɛ xasabi ra. ");
INSERT INTO sus_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","A naxa na gbeti kilo fu nun suuli nun a tagi rasuxu Isirayila di singee yi ra. Gbeti nan a ra naxan nu rawalima hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Munsa naxa na xunsare gbeti so Haruna nun a xa di xɛmɛe yi ra alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Kehati xa die tɛngɛ Lewi bɔnsɔɛe ya ma a xabilɛ nun a denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kehati xa die lanma e xa mɛɛni se sɛniyɛnxie ma naxee na hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Isirayilakae na keli sigade, Haruna nun a xa di xɛmɛe xa dugi yarasa ragoro, e saatɛ kankira makoto a ra. ");
INSERT INTO sus_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Na dangi xanbi e xa foye yɛxɛ kiri sa na fari, a nun gɛrɛ dugi. A dɔnxɔɛ ra e xa wuri kuyee raso kankira tongosee ra.» ");
INSERT INTO sus_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«E na gɛrɛ dugi gbɛtɛ itala teebili ma, e xa piletie, tɔnbilie, nun kundie sa na fari, naxee rawalima wɛni sɛrɛxɛe ra. Taami naxan bama sɛrɛxɛ ra, na fan sama nɛ na teebili nan fari. ");
INSERT INTO sus_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","E dugi gbeeli nan sama na birin xun ma, e fa foye yɛxɛ kiri itala na fari. Na dangi xanbi e xa wuri kuyee raso teebili tongosee ra.» ");
INSERT INTO sus_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«E xa gɛrɛ dugi dusu lanpui dɔxɔse, lanpuie, a yirabasee, xube sasee, nun ture kundie xun ma. ");
INSERT INTO sus_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","E xa na birin mafilin foye yɛxɛ kiri nan kui, e fa a sa xaninse fari. ");
INSERT INTO sus_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","E xa gɛrɛ dugi itala sɛrɛxɛbade xɛɛma daaxi fari, e fa a makoto foye yɛxɛ kiri ra, e wuri kuyee raso a tongosee ra. ");
INSERT INTO sus_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Na hɔrɔmɔlingira raxunmase birin makotoma garɛ dugi nan na, e e mafilin foye yɛxɛ kiri kui, e fa na sa xaninse fari. ");
INSERT INTO sus_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","E xa xube ba sɛrɛxɛbade wure gbeeli daaxi kui, e fa dugi gbeeli dusu a xun na. ");
INSERT INTO sus_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","E na a yirabasee sa a fari, alɔ surayi gansee, suxumɛe, pelie, nun pɔɔti xungbee, e xa na birin mafilin foye yɛxɛ kiri ra, e fa wuri kuyee raso a tongose ra. ");
INSERT INTO sus_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Haruna nun a xa di xɛmɛe na gɛ na xunmase sɛniyɛnxie nun a yirabasee makotode, Kehati xa die lanma e xa na birin xanin biyaasi kui. Kɔnɔ e mu lanma e xa din na se sɛniyɛnxie ra xa na mu e faxama nɛ. Kehati bɔnsɔɛe xa wali nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Haruna sɛrɛxɛdubɛ xa di xɛmɛ Eleyasari nan a ɲɔxɔ sama lanpui ture, surayi, sansi sɛrɛxɛ, nun ture sɛniyɛnxi xɔn ma. Hɔrɔmɔlingira raxunmase sɛniyɛnxie nun a yirabase birin taxuxi a tan nan na.» ");
INSERT INTO sus_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Wo naxa lu Kehati bɔnsɔɛ xabilɛe xa ba Lewi bɔnsɔɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Haruna nun a xa di xɛmɛe xa e mati hɔrɔmɔlingira kui, e fa e xa wali masen kankan bɛ alako e naxa e makɔrɛ se sɛniyɛnxie ra, e fa faxa. ");
INSERT INTO sus_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","E mu lan e xa e ya masa se sɛniyɛnxie ma, hali dondoronti, xa na mu e faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gerison bɔnsɔɛ tɛngɛ a xabilɛ nun a denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gerison xabilɛ xa wali nan yi ki. ");
INSERT INTO sus_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","E hɔrɔmɔlingira mafelenyie nan xaninma, a nun mafelenyi naxan yailanxi foye yɛxɛ kiri ra, a nun mafelenyi naxan gbakuxi hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","E xa tɛtɛ mafelenyie fan xanin naxee hɔrɔmɔlingira nun sɛrɛxɛbade rabilinma, a nun naxan gbakuxi tɛtɛ sode dɛ ra, a nun tɛtɛ luutie. E xa e ɲɔxɔ sa na se mɔɔli birin xɔn ma. ");
INSERT INTO sus_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gerison xabilɛ walima Haruna nun a xa di xɛmɛe xa yaamari nan bun ma, a findi kotee xaninfe ra, a findi wali gbɛtɛ rabafe ra. Nee nan a falama e bɛ e lan e xa naxan naba, a nun e lan e xa naxan xanin. ");
INSERT INTO sus_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gerison bɔnsɔɛ xa wali nan na ki hɔrɔmɔlingira xa fe ra. E na wali rabama Haruna sɛrɛxɛdubɛ xa di xɛmɛ Itamari xa yaamari nan bun ma.» ");
INSERT INTO sus_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«I xa Merari bɔnsɔɛ fan tɛngɛ a xabilɛ nun a denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","See nan yi ki e tan lan e xa naxee maxanin hɔrɔmɔlingira see ra: a xebenyie, a wuri kuyee, a kɔntigibae, nun e sanbunyie. ");
INSERT INTO sus_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","E xa tɛtɛ fan xanin, a nun a kɔntigibae, e sanbunyie, e sɔrɔnsee, e xa luutie, e xa yirabasee, nun e xa walise birin. Wo see masen kankan bɛ, a lanma a xa naxee xanin. ");
INSERT INTO sus_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari bɔnsɔɛe xa wali birin nan na ki hɔrɔmɔlingira xa fe ra. E walima Haruna sɛrɛxɛdubɛ xa di xɛmɛ Itamari xa yaamari nan bun ma.» ");
INSERT INTO sus_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Munsa, Haruna, nun ɲama kuntigie naxa Kehati xa mixie tɛngɛ e xabilɛ nun e xa denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","xɛmɛ naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","E xasabi lan mixi wulu firin, mixi kɛmɛ solofere, tongo suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Xɛmɛe nan na ki Kehati xabilɛe ya ma naxee hɔrɔmɔlingira wali rabama. Munsa nun Haruna bara e tɛngɛ alɔ Alatala Munsa yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","E naxa Gerison xa mixie tɛngɛ e xabilɛ nun e xa denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","xɛmɛ naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","E xasabi lan mixi wulu firin, kɛmɛ senni, tongo saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Xɛmɛe nan na ki Gerison xabilɛe ya ma naxee hɔrɔmɔlingira wali rabama. Munsa nun Haruna bara e tɛngɛ alɔ Alatala Munsa yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","E naxa Merari xa mixie tɛngɛ e xabilɛ nun e xa denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","xɛmɛ naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","E xasabi lan mixi wulu saxan mixi kɛmɛ firin nan ma. ");
INSERT INTO sus_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Xɛmɛe nan na ki Merari xabilɛe ya ma naxee hɔrɔmɔlingira wali rabama. Munsa nun Haruna bara e tɛngɛ alɔ Alatala Munsa yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Munsa, Haruna, nun Isirayila kuntigie, e Lewi bɔnsɔɛ mixi naxee tɛngɛxi e xabilɛ nun e xa denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","xɛmɛ naxee xa simaya bara ɲɛ tongo saxan li han ɲɛ tongo suuli, naxee fama hɔrɔmɔlingira wali rabade. ");
INSERT INTO sus_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","E xasabi lan mixi wulu solomasaxan, kɛmɛ suuli, tongo solomasaxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Xɛmɛe nun e xa walie nan na ki Lewi naxee tɛngɛxi Munsa nun Haruna saabui ra alɔ Alatala Munsa yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Isirayilakae yamari e xa kunɛ kanyi nun kɔrɔsila kanyi birin namini e yonkinde, a nun mixi naxee dinxi fure nde ra, e fa findi sɛniyɛntaree ra. ");
INSERT INTO sus_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","A findi xɛmɛ ra, a findi ginɛ ra, wo e ramini wo ya ma, e xa sa lu e xati ma alako e naxa sɛniyɛntareɲa raso wo ya ma, n sabatixi dɛnnaxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isirayilakae naxa a raba alɔ Alatala a yamarixi ki naxɛ, e naxa na mixie ramini e ya ma. Alatala a yamari ki naxɛ Munsa bɛ, e naxa a raba na ki. ");
INSERT INTO sus_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«A fala Isirayilakae bɛ, a findi xɛmɛ ra, a findi ginɛ ra, naxan yo na haakɛ nde raba a boore ra, haakɛ naxan findima Alatala xui matandife ra, na fe dɔxɔxi a xun ma. ");
INSERT INTO sus_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","A lan nɛ a xa a ti na haakɛ ra, a xa na fe yailan a nun na kanyi tagi, a man fa na fe kanaxi dɔxɔ suuli nde sa na fari. ");
INSERT INTO sus_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Xa a sa li a haakɛ rabaxi naxan na, a bara faxa, a xa mixi yo mu na naxan nɔma na fe yailanxi rasuxude, na findima Alatala nan gbe ra, a so sɛrɛxɛdubɛ yi ra. Fe kanɛ man fa yɛxɛɛ kontonyi keren ba a xa yunubi xafari ra, a a so sɛrɛxɛdubɛ yi ra. ");
INSERT INTO sus_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Isirayilakae na sɛrɛxɛ ba, e a fi sɛrɛxɛdubɛ ma, na sɛrɛxɛ findima na sɛrɛxɛdubɛ nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Naxan birin sɛrɛxɛ bama, a naxan bama, a gbe nan na ki, kɔnɔ a naxan fima sɛrɛxɛdubɛ ma, sɛrɛxɛdubɛ gbe nan na ki.» ");
INSERT INTO sus_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«A fala Isirayilakae bɛ, e yi nan nabama xa ginɛ nde sa yɛnɛ raba. ");
INSERT INTO sus_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Xa e nun xɛmɛ gbɛtɛ bara e sa gundo ra, ginɛ xa mɔri mu na kolon, seede mu na, mixi mu a suxu a kui, ");
INSERT INTO sus_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","kɔnɔ a xa mɔri bara a xa ginɛ tɔɔnɛ fɔlɔ, xa a xa ginɛ sɛniyɛnxi, xa na mu a mu sɛniyɛnxi, ");
INSERT INTO sus_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","a xa a xa ginɛ xanin sɛrɛxɛdubɛ yire, a mɛngi kilo saxan ba a bɛ sɛrɛxɛ ra ture nun surayi mu na naxan xun, barima tɔɔnɛ sɛrɛxɛ nan a ra naxan bama a kolonfe ra xa yunubi rabaxi.» ");
INSERT INTO sus_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Sɛrɛxɛdubɛ xa na ginɛ ti Alatala ya i, ");
INSERT INTO sus_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","a fa xube makɔ bɔxi ma hɔrɔmɔlingira kui, a a masunbu ye sɛniyɛnxi ra fɛɲɛ kui. ");
INSERT INTO sus_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ginɛ na ti Alatala ya i, sɛrɛxɛdubɛ xa a xunsɛxɛ fulun, a fa tɔɔnɛ sɛrɛxɛ sa ginɛ bɛlɛxɛ maratuse ra. Sɛrɛxɛdubɛ tan xa na ye tongo naxan findima danka ra, a a lintan ginɛ ya i.» ");
INSERT INTO sus_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","«Sɛrɛxɛdubɛ ginɛ rakalima nɛ, a a fala, ‹Xa a sa li i tan nun xɛmɛ gbɛtɛ mu kafuxi, i mu i xa mɔri yanfa, i mu sɛniyɛntareɲa sɔtɔ futi kui, i xa ratanga dankɛ ma yi ye fama naxan na. ");
INSERT INTO sus_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Kɔnɔ xa a sa li, i bara i xa mɔri yanfa wo xa futi kui, i nun xɛmɛ gbɛtɛ bara kafu sɛniyɛntareɲa kui, ");
INSERT INTO sus_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Alatala xa a ragiri i furi xa kana. Na kui i ngaxakerenyie i dankama nɛ, e i konbi. ");
INSERT INTO sus_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Yi ye naxan fama dankɛ ra, a xa i furi mafuntu, a i xɔrɛ maba.› Ginɛ xa a ratin a falafe ra, ‹Amina, amina.›» ");
INSERT INTO sus_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Sɛrɛxɛdubɛ na gɛ na dankɛ sɛbɛde kiri ma, a xa na kiri xa na ye sɛniyɛnxi ra, ");
INSERT INTO sus_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","a fa a fi ginɛ ma, a xa a min. Na ye naxan nɔma findide dankɛ ra, a soma a fate i. ");
INSERT INTO sus_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Sɛrɛxɛdubɛ tɔɔnɛ sɛrɛxɛ rasuxuma nɛ ginɛ yi ra, a a dɛntɛgɛ Alatala bɛ sɛrɛxɛbade yire. ");
INSERT INTO sus_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Sɛrɛxɛdubɛ xa mɛngi suxui keren gan sɛrɛxɛbade fari, a findi sɛrɛxɛ tɔnxuma ra. A na gɛ na ra, a xa na ye fi ginɛ ma, a xa a min. ");
INSERT INTO sus_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","A na na ye min, xa a sa li na ginɛ bara findi sɛniyɛntare ra, a bara a xa mɔri yanfa, na ye naxan findima dankɛ ra, a soma nɛ a fate i, a a tɔɔrɔ ki fanyi ra. A furi funtuma nɛ, a xɔrɛ mabama nɛ, a ngaxakerenyie fama nɛ a dankade.» ");
INSERT INTO sus_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","«Kɔnɔ xa a sa li a mu sɛniyɛntareɲa yo rabaxi, tɔɔɲɛgɛ bama nɛ a xun ma, a man nɔma di baride. ");
INSERT INTO sus_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Tɔɔnɛ sɛriyɛ nan na ki naxan nawalima xa ginɛ findima sɛniyɛntare ra, a a xa mɔri yanfa futi kui, ");
INSERT INTO sus_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","xa na mu a ra, tɔɔnɛ xaxili na so xɛmɛ furi, a fa siikɛ a xa ginɛ ma. A a xa ginɛ xaninma Alatala ya i, sɛrɛxɛdubɛ fa na sɛriyɛ rabatu a xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Na kui yunubi mu na na xɛmɛ ma, kɔnɔ ginɛ tan a xa yunubi sare sɔtɔma nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«A fala Isirayilakae bɛ, xa xɛmɛ nde, xa na mu ginɛ nde sa laayidi tongo Alatala bɛ, a xa lu a sago, na nan na ki a xa findi Nasari ra, ");
INSERT INTO sus_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","na kanyi mu lan a xa wɛni nun beere min. A naxa sese min naxan kelixi wɛni bogi ma, xa na mu beere ma. A naxa wɛni bogi bunda don, a naxa a xare don. ");
INSERT INTO sus_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A tɛmui naxan birin nabama a xa Nasariya kui, a naxa sese don naxan keli wɛni bili ma, keli a bogi ma a sa dɔxɔ a xɔri ra.» ");
INSERT INTO sus_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«A xa Nasariya kui, a mu lanma a xunyi xa bi. A xa lu sɛniyɛnyi kui, a xunsɛxɛ xa nu kuya ra tun. ");
INSERT INTO sus_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Na waxati bun ma, a mu lan a xa a maso fure ra, ");
INSERT INTO sus_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","hali a findi a baba ra, a nga, a taara, xa na mu a ra a xunya fure ra. A na Alatala nan sago tun, alɔ a xunsɛxɛ kɛɲa a masenxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A tɛmui naxan birin nabama a xa Nasariya kui, a luma sɛniyɛnyi nan kui Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Xa mixi nde sa faxa a fɛ ma a tɛrɛnna ki ma, a xunsɛxɛ bara findi se sɛniyɛntare ra. Na tɛmui a xa sɛniyɛn lɔxun keren bun ma, a man fa a xunyi bi na xi solofere lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A xi solomasaxan lɔxɔɛ, a fogotara firin nan xaninma sɛrɛxɛdubɛ xɔn ma hɔrɔmɔlingira sode dɛ ra, xa na mu ganbɛ firin. ");
INSERT INTO sus_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sɛrɛxɛdubɛ xɔni keren nan bama yunubi xafari sɛrɛxɛ ra, boore findima a gan daaxi nan na, alako a xa yunubi xa xafari, barima a dinfe fure ra, na findima yunubi nan na. Na lɔxɔɛ a man xa a xunyi rasɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","A na gɛ na ra, a man xa gbilen a xa laayidi ma. Fo a xa yɛxɛɛ keren ba yɛtɛ ragbilen sɛrɛxɛ ra, naxan ɲɛ keren a ra a xa yunubi xafarife ra. Lɔxɔɛ naxee bara dangi, nee mu kɔntima sɔnɔn, barima a nu bara sɛniyɛntareɲa sɔtɔ.» ");
INSERT INTO sus_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Mixi na gɛ Nasariya rabade, a xa bira yi sɛriyɛ nan fɔxɔ ra. A xa siga hɔrɔmɔlingira sode dɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","a xa sɛrɛxɛ gan daaxi ba Alatala bɛ, yɛxɛɛ naxan bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxan ma. A xa yunubi xafari sɛrɛxɛ fan ba, yɛxɛɛ ginɛ naxan bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxan ma. A xa xanunteya sɛrɛxɛ ba, yɛxɛɛ kontonyi, lanyuru yo mu na naxan ma. ");
INSERT INTO sus_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","A xa sɛrɛxɛ ndee sa na fari, alɔ sansi xɔri dinxi sɛrɛxɛ, wɛni sɛrɛxɛ, taami lɛbinitare, lɛki yailanxi ture ra, nun lɛki ture masoxi naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Sɛrɛxɛdubɛ na sɛrɛxɛ see nan dɛntɛgɛma Alatala bɛ, a fa yunubi xafari sɛrɛxɛ ba, a nun sɛrɛxɛ gan daaxi. ");
INSERT INTO sus_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","A xa na taami lɛbinitare masen Alatala bɛ, a xa na yɛxɛɛ kontonyi ba xanunteya sɛrɛxɛ ra, a xa sansi xɔri dinxi sɛrɛxɛ nun wɛni sɛrɛxɛ sa na fari.» ");
INSERT INTO sus_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«Na tɛmui Nasari xa a xunsɛxɛ bi hɔrɔmɔlingira sode dɛ ra, a naxan fixi Alatala ma. A xa na raso tɛ xɔɔra xanunteya sɛrɛxɛ na bafe dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nasari na gɛ a xunsɛxɛ bide, sɛrɛxɛdubɛ yɛxɛɛ kontonyi bɛlɛxɛ ganxi keren nan tongoma a bɛlɛxɛ ra, a nun lɛki lɛbinitare firin naxee na debe kui. ");
INSERT INTO sus_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","A xa e dɛntɛgɛ Alatala bɛ e lintanfe ra. Na findi donse sɛniyɛnxi nan na sɛrɛxɛdubɛ bɛ, a nun na yɛxɛɛ ganyanyi nun a tabe. Na dangi xanbi, Nasari nɔma wɛni minde sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Nasari sɛriyɛ nan na ki. A lanma a xa na sɛrɛxɛe ba Alatala bɛ alɔ a ɲanigexi ki naxɛ, a nun se gbɛtɛe a nɔma naxan na. Fo a xa a xa Nasari laayidi rakamali a sɛriyɛ ki ma.» ");
INSERT INTO sus_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«A fala Haruna nun a xa die bɛ, e xa duba Isirayilakae bɛ yi ki nɛ: ");
INSERT INTO sus_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹Alatala xa baraka sa i xa fe, a xa i kanta. ");
INSERT INTO sus_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Alatala yatagi xa nɔrɔ i ma, a xa hinnɛ i ra. ");
INSERT INTO sus_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Alatala xa a ya rafindi i ma, a xa bɔɲɛsa fi i ma.› ");
INSERT INTO sus_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","E dubama Isirayilakae bɛ na ki nɛ, n fan baraka sama nɛ e ma.» ");
INSERT INTO sus_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Munsa to gɛ hɔrɔmɔlingira tide, a naxa ture sɛniyɛnxi sa a ma, a nun a xunmasee, a xa sɛrɛxɛbadee, nun a yirabasee, alako nee xa sɛniyɛn Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Isirayila kuntigie, xabilɛ xunyi naxee bɔnsɔɛe tɛngɛ, e naxa hadiyae ba Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","E naxa fa sarɛti makotoxi senni nun ninge fu nun firin na hɔrɔmɔlingira sode dɛ ra, e xa findi e xa sɛrɛxɛ ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Yi hadiyae rasuxu e yi ra hɔrɔmɔlingira wali xa fe ra. E taxu Lewi bɔnsɔɛ xa mixie ra kankan xa wali bɛrɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Munsa naxa na sarɛtie nun ningee so Lewi xa mixie yi ra. ");
INSERT INTO sus_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A naxa sarɛti firin nun ninge naani so Gerison xabilɛ yi ra e xa wali bɛrɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","A naxa sarɛti naani nun ninge solomasaxan so Merari xabilɛ yi ra e xa wali bɛrɛ ra. E nu na Haruna sɛrɛxɛdubɛ xa di Itamari xa yaamari nan bun ma. ");
INSERT INTO sus_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kɔnɔ a mu sese so Kehati xabilɛ tan yi, barima a nu lanma e xa se sɛniyɛnxie maxanin e tunki fari alɔ Alatala e yamarixi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Sɛrɛxɛbade nɛɛnɛ xa wali singe, ture sɛniyɛnxi to maso a ma tɛmui naxɛ, kuntigie naxa fa e xa sɛrɛxɛe ra sɛrɛxɛbade yire. ");
INSERT INTO sus_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Alatala nu bara a masen Munsa bɛ, «Lɔxɔɛ yo lɔxɔɛ mixi keren xa fa a xa hadiya ra sɛrɛxɛbade nɛɛnɛ xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Na lɔxɔɛ singe, Aminadabo xa di Naxason kelife Yuda bɔnsɔɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Aminadabo xa di Naxason xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Na lɔxɔɛ firin nde, Suwara xa di Netaneeli kelife Isakari bɔnsɔɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Suwara xa di Netaneeli xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Na lɔxɔɛ saxan nde, Xelon xa di Eliyabi kelife Sabulon bɔnsɔɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Xelon xa di Eliyabi xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Na lɔxɔɛ naani nde, Sedeyuri xa di Elisuru kelife Ruben bɔnsɔɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","A man naxa fa pɔɔti keren naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Sedeyuri xa di Elisuru xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Na lɔxɔɛ suuli nde, Surisadayi xa di Selumiyeli kelife Simeyɔn bɔnsɔɛ, ");
INSERT INTO sus_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Surisadayi xa di Selumiyeli xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Na lɔxɔɛ senni nde, Duweli xa di Eliyasafa fatanfe Gadi bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Duweli xa di Eliyasafa xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Na lɔxɔɛ solofere nde, Amixudi xa di Elisama fatanfe Efirami bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","A man naxa fa pɔɔti keren naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Amixudi xa di Elisama xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Na lɔxɔɛ solomasaxan nde, Pedasuru xa di Gamaliyɛli fatanfe Manasi bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Pedasuru xa di Gamaliyɛli xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Na lɔxɔɛ solomanaani nde, Gideyoni xa di Abidan fatanfe Bunyamin bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Gideyoni xa di Abidan xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Na lɔxɔɛ fu nde, Amisadayi xa di Axiyeseri fatanfe Dana bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Amisadayi xa di Axiyeseri xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Na lɔxɔɛ fu nun keren nde, Okiran xa di Pagiyɛli fatanfe Aseri bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Aminadabo xa di Naxason xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Na lɔxɔɛ fu nun firin nde, Enan xa di Axira fatanfe Nafatali bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","a naxa fa yi hadiyae ra: pileti keren naxan yailanxi gbeti kilo fu nun suuli ra, a nun pɔɔti keren naxan yailanxi gbeti kilo keren na alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. E firin nafexi sansi xɔri dinxi ra, ture masunbuxi naxan na, alako a xa findi sansi sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","A man naxa fa pɔɔti keren na naxan yailanxi xɛɛma giramu kɛmɛ giramu fu nun naani ra, naxan nafexi surayi ra, ");
INSERT INTO sus_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","a nun naxee bama sɛrɛxɛ gan daaxi ra alɔ tuura keren, yɛxɛɛ kontonyi keren, nun yɛxɛɛ keren naxan xa simaya bara ɲɛ keren li, ");
INSERT INTO sus_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a nun naxee bama xanunteya sɛrɛxɛ ra alɔ ninge firin, yɛxɛɛ kontonyi suuli, nun yɛxɛɛ suuli naxee xa simaya bara ɲɛ keren li. Enan xa di Axira xa hadiya nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Isirayila kuntigie xa hadiya malanxie findixi yi nan na sɛrɛxɛbade nɛɛnɛ xa fe ra: pileti gbeti daaxi fu nun firin, pɔɔti gbeti daaxi fu nun firin, nun pɔɔti xɛɛma daaxi fu nun firin. ");
INSERT INTO sus_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Pileti keren keren lanxi gbeti kilo keren nun a tagi nan ma. Pɔɔti keren keren lanxi gbeti kilo keren nan ma. Se naxee yailanxi gbeti ra, nee lanxi kilo mɔxɔɲɛn nun naani nan ma, alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Pɔɔti xɛɛma daaxi fu nun firin lanxi xɛɛma giramu kɛmɛ giramu fu nun naani nan ma, alɔ se maniyama ki naxɛ hɔrɔmɔlingira kui. Na pɔɔti fu nun firin lanxi xɛɛma kilo keren nun a tagi nan ma. E birin nafexi surayi nan na. ");
INSERT INTO sus_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Sɛrɛxɛ gan daaxi xuruse xasabi naxa lan tuura fu nun firin ma, a nun yɛxɛɛ kontonyi fu nun firin, nun yɛxɛɛ fu nun firin naxee xa simaya nu bara ɲɛ keren li, a nun e xa sansi xɔri dinxi sɛrɛxɛ. Yunubi xafari sɛrɛxɛ xuruse xasabi naxa lan sikɔtɛ fu nun firin ma. ");
INSERT INTO sus_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Xanunteya sɛrɛxɛ xa xuruse xasabi naxa lan tuura mɔxɔɲɛn nun naani ma, yɛxɛɛ kontonyi tongo senni, sikɔtɛ tongo senni, nun yɛxɛɛ tongo senni naxee bara ɲɛ keren sɔtɔ. Nee nan findi hadiyae ra sɛrɛxɛbade xa wali fɔlɔ tɛmui, ture sɛniyɛnxi to sa a ma. ");
INSERT INTO sus_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Munsa to so hɔrɔmɔlingira kui, a nun Alatala xa sumun, a naxa Alatala xui mɛ saatɛ kankira dɛrakote fari, a masenyi tima a bɛ malekɛ firinyie sawurɛ tagi naxee na na kankira fari. ");
INSERT INTO sus_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«A fala Haruna bɛ, a xa lanpui solofere dɔxɔ alako e xa yanba e dɔxɔse ya ra.» ");
INSERT INTO sus_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruna a raba na ki nɛ. A naxa lanpui dɔxɔ alɔ Alatala a yamari ki naxɛ Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Lanpuie dɔxɔse nu rafalaxi xɛɛma dinxi nan na, kelife a sanbunyi ma han a xunyi, alɔ Alatala a masenxi Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Lewi bɔnsɔɛ ba Isirayilakae ya ma, i xa e rasɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","I e rasɛniyɛnma yi ki nɛ. Marasɛniyɛn ye makasan e ma. E xa e fate maxabe birin bi, e xa e xa dugie xa, alako e xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Na xanbi, e xa tuura keren ba sɛrɛxɛ ra, a nun mɛngi naxan masunbuxi ture ra. I xa tuura gbɛtɛ ba yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","I xa Lewi bɔnsɔɛ nun Isirayilaka birin malan hɔrɔmɔlingira sode dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Mɛnni, Alatala ya xɔri, Isirayilakae xa e bɛlɛxɛ sa Lewi bɔnsɔɛ mixie ma. ");
INSERT INTO sus_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haruna nan fama e dɛntɛgɛde Alatala bɛ e xa lu alɔ sɛrɛxɛ Isirayilakae ɲɔxɔɛ ra. Na kui e nɔma Alatala xa wali rabade.» ");
INSERT INTO sus_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«Lewi bɔnsɔɛ mixie xa e bɛlɛxɛ sa na tuura firinyie ma. Keren bama yunubi xafari sɛrɛxɛ nan na, boore ba sɛrɛxɛ gan daaxi ra, alako e xa yunubie xa xafari. ");
INSERT INTO sus_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Lewi bɔnsɔɛ na ti Haruna nun a xa die ya i, i xa e dɛntɛgɛ a sɛrɛxɛ ki ma Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","A lima nɛ, na tɛmui, i bara Lewi bɔnsɔɛ tan ba Isirayilakae ya ma, e xa findi n gbe ra.» ");
INSERT INTO sus_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«I na gɛ e rasɛniyɛnde a sɛrɛxɛ ki ma, Lewi bɔnsɔɛ fama nɛ sode e xa hɔrɔmɔlingira wali kui. ");
INSERT INTO sus_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Isirayilakae nan e ra naxee findixi n gbe ra Isirayila di singe birin ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Isirayila di singe birin nun e xa xuruse di singe birin findixi n gbe nan na, kafi n sa Misirakae xa di singe birin faxa tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","N naxa Lewi bɔnsɔɛ tongo Isirayila di singe birin ɲɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","N bara e so Haruna nun a xa die yi ra Isirayilakae tagi, alako e xa hɔrɔmɔlingira wali raba Isirayilakae xili ra. E man xa yunubi xafari sɛrɛxɛ ba Isirayilakae bɛ, alako gbaloe yo naxa goro Isirayilakae ma e na makɔrɛ yire sɛniyɛnxi ra tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Munsa, Haruna, nun ɲama birin naxa na raba Lewi bɔnsɔɛ ra alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewi bɔnsɔɛ naxa e yɛtɛ rasɛniyɛn, e naxa e xa dugie xa. Haruna naxa e dɛntɛgɛ Alatala bɛ. A naxa e xa yunubi xafari sɛrɛxɛ ba e bɛ e xa sɛniyɛn. ");
INSERT INTO sus_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Na to ba a ra, Lewi bɔnsɔɛ naxa fa e xa wali suxu hɔrɔmɔlingira xa fe ra Haruna nun a xa die xa yaamari bun ma, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Lewi bɔnsɔɛ mixie xa simaya na ɲɛ mɔxɔɲɛn nun suuli li, e nɔma hɔrɔmɔlingira wali suxude. ");
INSERT INTO sus_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","E na ɲɛ tongo suuli sɔtɔ, e xa na wali lu naa. ");
INSERT INTO sus_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","E nɔma e ngaxakerenyie malide na wali kui, kɔnɔ e tan mu nɔma na rabade sɔnɔn. I xa na sɛriyɛe suxu Lewi bɔnsɔɛ xa fe ra hɔrɔmɔlingira wali rabafe ma.» ");
INSERT INTO sus_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Isirayilakae to mini Misira bɔxi ma, e fa lu gbengberen yire ɲɛ firin, na kike singe Alatala nu bara a masen Munsa bɛ Turusinina gbengberenyi ma, ");
INSERT INTO sus_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Isirayilakae xa Sayamalekɛ Dangi Sali raba ");
INSERT INTO sus_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","yi kike xi fu nun naani, soge dula tɛmui alɔ a yamarixi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Munsa naxa a fala Isirayilakae bɛ, a e xa Sayamalekɛ Dangi Sali raba. ");
INSERT INTO sus_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","E naxa na sali raba kike singe xi fu nun naani soge dula tɛmui Turusinina gbengberenyi ma. E naxa a raba, alɔ Alatala a yamari ki naxɛ Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kɔnɔ na lɔxɔɛ, mixi ndee mu nɔ Sayamalekɛ Dangi Sali raba barima e nu bara din mixi fure ra, e fa findi sɛniyɛntare ra na lɔxɔɛ. Na lɔxɔɛ kerenyi e naxa siga Munsa nun Haruna yire. ");
INSERT INTO sus_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","E a fala e bɛ, «Muxu mu sɛniyɛn fure xa fe ra, kɔnɔ munfe ra muxu mu lan muxu xa fa muxu xa hadiya ra Alatala bɛ alɔ Isirayilaka birin?» ");
INSERT INTO sus_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Munsa naxa e yaabi, «Wo mamɛ ti sinden, n xa a mato Alatala naxan yamarima wo xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Xa wo mu sɛniyɛn fure nde xa fe ra, xa na mu a ra wo na biyaasi kui, wo man nɔma Sayamalekɛ Dangi Sali rabade Alatala xa binyɛ bun ma, keli wo tan ma han a sa wo bɔnsɔɛ li. ");
INSERT INTO sus_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Kɔnɔ e tan xa a raba kike firin nde xi fu nun naani soge dula tɛmui. E yɛxɛɛ don a nun taami lɛbinitare nun burɛxɛ xɔnɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","A dɔnxɔɛ yo naxa lu han gɛɛsɛgɛ. A xɔri fan mu ibɔɔma. E xa na sali raba a sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kɔnɔ xa mixi sɛniyɛnxi naxan mu na biyaasi kui, a tondi Sayamalekɛ Dangi Sali rabade, na kanyi lanma a xa ba Alatala xa ɲama ya ma, barima a mu fa hadiya ra Alatala bɛ a waxati. Na kanyi fama nɛ a xa yunubi sare sɔtɔde.» ");
INSERT INTO sus_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«Xa i xa xɔɲɛ nde wama Sayamalekɛ Dangi Sali rabafe, a xa a raba a sɛriyɛ ki ma. Sɛriyɛ naxan saxi taa kanyie ma, na sɛriyɛ kerenyi nan luma na xɔɲɛ fan ma.» ");
INSERT INTO sus_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Hɔrɔmɔlingira ti lɔxɔɛ, saatɛ walaxɛe na dɛnnaxɛ, nuxui nde naxa dusu na xun na. Keli nunmare han kuye iba, a nu na hɔrɔmɔlingira fari, a maniyaxi tɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tɛmui birin a nu na na ki nɛ, nuxui nu na hɔrɔmɔlingira fari yanyi ra, a fa yanba alɔ tɛ kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Nuxui nɛfɛ keli hɔrɔmɔlingira xun ma, Isirayilakae fan bara keli, e ɲɛrɛ fɔlɔ han a goro, e fa yonkin mɛnni. ");
INSERT INTO sus_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Na kui Isirayilakae nu ɲɛrɛma Alatala xa yaamari nan bun ma, e man nu yonkinma Alatala xa yaamari nan ma. Fanni nuxui na hɔrɔmɔlingira xun ma, e fan yonkinma mɛnni nɛ. ");
INSERT INTO sus_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Xa nuxui sa bu hɔrɔmɔlingira fari a gbe ra, Isirayilakae nu birama Alatala xa yaamari nan fɔxɔ ra, e lu mɛnni. ");
INSERT INTO sus_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tɛmui ndee na nuxui mu buma, a keli. Isirayilakae nu luma Alatala xa yaamari nan bun ma, e fan keli, e yonkin nuxui yire. ");
INSERT INTO sus_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Tɛmui ndee nuxui bara lu yire xi keren, keli kɔɛ ra han kuye iba, a fa siga. A nɛfɛ keli, Isirayilakae fan bara keli, e bira a fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Xa nuxui lu hɔrɔmɔlingira xun ma xi firin, xa na mu kike keren, xa na mu ɲɛ keren, Isirayilakae mu nu kelima e yonkinde, fo na nuxui na keli hɔrɔmɔlingira xun ma tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","E nu yonkinma Alatala xa yaamari nan bun ma, e nu kelima Alatala xa yaamari nan bun ma. E nu birama Alatala xa yaamari nan fɔxɔ ra, a naxan fixi Munsa saabui ra. ");
INSERT INTO sus_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«I xa sara firin yailan gbeti bɔnbɔxi ra. E rawalima ɲama xilife nan na malanyi. E man nawalima ɲama kelife nan na biyaasi tɛmui. ");
INSERT INTO sus_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","E firin na fe tɛmui keren, ɲama birin xa malan i yire hɔrɔmɔlingira dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Xa sara keren nan fe, Isirayila yareratie nun kuntigie gbansan xa malan i yire.» ");
INSERT INTO sus_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","«Wo kelima biyaaside tɛmui naxɛ, sarae xa fe keren. Na kui naxee dɔxɔxi sogetede, e xa siga. ");
INSERT INTO sus_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Sarae na fe firin, naxee dɔxɔxi yirefanyi ma, nee fan xa siga. Sara xui nan a masenma ɲama siga tɛmui bara a li. ");
INSERT INTO sus_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Sara xui kɛɲa gbɛtɛ nan a masenma ɲama malan tɛmui bara a li.» ");
INSERT INTO sus_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Haruna bɔnsɔɛ sɛrɛxɛdubɛe nan na sarae fema. Sɛriyɛ nan na ra wo tan nun wo bɔnsɔɛe bɛ abadan. ");
INSERT INTO sus_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Wo na wo yaxuie gere wo xa bɔxi ma tɛmui naxɛ, wo xa na sarae fe. Alatala ɲɔxɔ sama nɛ wo xɔn, a wo ratanga wo yaxuie ma. ");
INSERT INTO sus_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Wo xa sali lɔxɔɛ xungbee nun wo xa kike nɛɛnɛ sali lɔxɔɛe, wo man xa na sarae fe wo sɛrɛxɛ gan daaxie nun xanunteya sɛrɛxɛe bama tɛmui naxɛ. Na nan a niyama, n nan n ɲɔxɔ sama wo xɔn ma. N tan nan na wo Marigi Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ɲɛ firin nde kike firin nde xi mɔxɔɲɛn lɔxɔɛ, nuxui naxan nu dɔxɔxi hɔrɔmɔlingira xun ma, Ala xa seede nu na dɛnnaxɛ, a naxa ɲɛrɛ fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Na kui Isirayilakae naxa keli Turusinina gbengberenyi ma, e bira na nuxui fɔxɔ ra han a sa ti Paran gbengberenyi xun ma. ");
INSERT INTO sus_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Alatala naxa e yamari Annabi Munsa saabui ra, e xa na biyaasi singe fɔlɔ. ");
INSERT INTO sus_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda bɔnsɔɛ naxa ti yare, e xa tɔnxuma tixi e ya ra. E xunyi nu na Aminadabo xa di xɛmɛ Naxason nan na. ");
INSERT INTO sus_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Suwara xa di xɛmɛ Netaneeli nan nu na Isakari bɔnsɔɛ xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Xelon xa di xɛmɛ Eliyabi nan nu na Sabulon bɔnsɔɛ xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hɔrɔmɔlingira to mafagati, Gerison xa di xɛmɛe nun Merari xa di xɛmɛe naxa a xanin. ");
INSERT INTO sus_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruben bɔnsɔɛ naxa bira e fɔxɔ ra, e xa tɔnxuma tixi e ya ra. Sedeyuri xa di xɛmɛ Elisuru nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeyɔn bɔnsɔɛ naxa bira e fɔxɔ ra. Surisadayi xa di xɛmɛ nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gadi bɔnsɔɛ naxa bira e fɔxɔ ra. Duweli xa di xɛmɛ Eliyasafa nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kehati xabilɛ naxa bira e fɔxɔ ra hɔrɔmɔlingira se sɛniyɛnxie ra. Booree tan lan nɛ e xa hɔrɔmɔlingira ti beenu Kehati xabilɛ xa so. ");
INSERT INTO sus_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efirami bɔnsɔɛ naxa bira e fɔxɔ ra, e xa tɔnxuma tixi e ya ra. Amixudi xa di xɛmɛ Elisama nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasi bɔnsɔɛ naxa bira e fɔxɔ ra. Pedasuru xa di xɛmɛ Gamaliyɛli nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gideyoni xa di xɛmɛ Abidan nan nu na Bunyamin bɔnsɔɛ xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dana bɔnsɔɛe naxa ɲɛrɛ e birin xanbi ra, e xa tɔnxuma tixi e ya ra. Amisadayi xa di xɛmɛ Axiyeseri nan nu na e xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okiran xa di xɛmɛ Pagiyɛli nan nu na Aseri bɔnsɔɛ xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enan xa di xɛmɛ Axira nan nu na Nafatali bɔnsɔɛ xunyi ra. ");
INSERT INTO sus_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isirayilakae nu ɲɛrɛma na ki nɛ e gali ki ma. ");
INSERT INTO sus_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Munsa naxa a fala a bitanyi Reyuweli Madiyanka xa di xɛmɛ Xobabo bɛ, «Muxu na sigafe Alatala dɛnnaxan laayidixi muxu bɛ. I fan xa fa. Na findima sɔɔnɛya nan na i bɛ, barima Alatala bara laayidi tongo a fe fanyie rabama nɛ Isirayila bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Xobabo naxa a yaabi, «Ade, n xa gbilen n xɔnyi n ma mixie tagi.» ");
INSERT INTO sus_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Munsa naxa a maxandi, «Yandi, i naxa keli muxu xun ma. I tan nan yi gbengberenyi birin kolon muxu nɔma yonkinde dɛnnaxɛ. I findima muxu raɲɛrɛma nan na. ");
INSERT INTO sus_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Xa i muxu matima, muxu i kima nɛ hɛɛri ra Alatala fama naxan fide muxu ma.» ");
INSERT INTO sus_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","E naxa keli Alatala xa geya bun ma, e xi saxan ɲɛrɛ raba. Alatala xa saatɛ kankira nu tixi e ya ra na xi saxan bun ma yonkinde fenfe ra. ");
INSERT INTO sus_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","E to nu kelima e yonkinde, Alatala xa nuxui nu tixi e xun ma fɛɛɲɛnyi kui. ");
INSERT INTO sus_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","E to nu saatɛ kankira rakelima tɛmui naxɛ, Munsa nu a falama, «Alatala, i xa keli, i xa i yaxuie rayensen. Naxee i xɔnxi, nee fan xa e gi i ya ra.» ");
INSERT INTO sus_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","E to nu saatɛ kankira ragoroma tɛmui naxɛ, Munsa nu a falama, «Alatala, i xa i magoro Isirayila ɲama wuyaxi tagi.» ");
INSERT INTO sus_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Lɔxɔɛ nde, ɲama naxa e mawa e xa tɔɔrɛ xa fe ra Alatala ya i. Alatala naxa xɔnɔ na fe ma, a fa tɛ rasin ɲama tagi, a yire nde gan yonkinde sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ɲama to gbelegbele Munsa ra, a naxa Alatala maxandi. Na kui tɛ naxa xuben. ");
INSERT INTO sus_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","E naxa na yire xili sa Tabera, na nan na ki «Tɛ mankanɛ,» barima Alatala nu bara tɛ rasin e tagi. ");
INSERT INTO sus_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mixi kobi ndee to wa donse mɔɔli gbɛtɛ xɔn ma, Isirayilakae man naxa e mawa, a falafe ra, «Muxu wama sube nan xɔn! ");
INSERT INTO sus_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Muxu muxu ratuma na donse fanyi ma muxu naxan sɔtɔ Misira bɔxi ma kɔbiri xanbi, alɔ yɛxɛ, kaakunboosi, basikɛti, yɛbɛ, nun yɛbɛ maniyɛ. ");
INSERT INTO sus_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Kɔnɔ yakɔsi donse xɔli mu na muxu ma, barima ‹mana› donse nan tun na be.» ");
INSERT INTO sus_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Na «mana» nu luxi nɛ alɔ funden xɔri fiixɛ. ");
INSERT INTO sus_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ɲama nu minima a matongode, e fa a din gɛmɛ ra, xa na mu, mulunyi kui. E nu lɛki yailanma a ra. A nu luxi alɔ ture nu na a ma. ");
INSERT INTO sus_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Mana nu goroma xini goro tɛmui. ");
INSERT INTO sus_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Munsa naxa ɲama wa xui ramɛ. Mixi birin nu e mawama e xɔnyi. Alatala naxa xɔnɔ ki fanyi ra. Munsa naxa kɔntɔfili. ");
INSERT INTO sus_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","A naxa Alatala maxɔrin, «N Marigi, munfe ra i bara yi kɔntɔfili lu i xa konyi ma? N munse rabaxi naxan a niyama i xa yi ɲama xa kote dɔxɔ n xun ma? N tan nan nu wama a xɔn? ");
INSERT INTO sus_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","N tan nan e barixi? Munfe ra i bara e sa n bɛlɛxɛ, n xa e xanin bɔxi ma i naxan laayidixi e benbae bɛ, alɔ dingɛ a xa di xaninma ki naxɛ? ");
INSERT INTO sus_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","N sube sɔtɔma minden yi ɲama birin bɛ? E e mawama e wama sube xɔn. ");
INSERT INTO sus_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","N keren mu nɔma yi ɲama birin xa kote ra, a binya n bɛ. ");
INSERT INTO sus_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Faxɛ nan fisa na kote bɛ. Xa n ma fe rafan i ma, i naxa n xun nakana.» ");
INSERT INTO sus_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Alatala naxa a masen Munsa bɛ, «Isirayila fori tongo solofere malan n bɛ, i naxee kolon taa yareratie nun kuntigie ra. E xa e malan hɔrɔmɔlingira dɛ ra i sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","N fama gorode i yire, won xa wɔyɛn. N Xaxili Sɛniyɛnxi naxan fixi i ma, n na nde bama i ma, n xa na sa e fan ma, alako i keren naxa yi ɲama xa kote xanin sɔnɔn. Wo nun na kuntigie nan a xaninma fa.» ");
INSERT INTO sus_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«A fala ɲama bɛ, ‹Wo xa wo yɛtɛ rasɛniyɛn, barima tina wo sube donma nɛ. Alatala bara wo wa xui mɛ, a falafe ra, «Muxu wama sube nan xɔn ma. Lufe Misira nan fisa.» Alatala fama sube fide wo ma wo naxan donma. ");
INSERT INTO sus_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Kɔnɔ wo mu a donma xɛ xi keren, xa na mu xi firin, xa na mu xi suuli, xa na mu xi fu, xa na mu xi mɔxɔɲɛn. ");
INSERT INTO sus_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Wo a donma nɛ han kike keren, han a mini wo ɲɔɛ kui, han a raɲaaxu wo ma, barima wo bara Alatala rabɛɲin, naxan na wo ya ma. Wo bara wo mawa a falafe ra, «Munfe ra muxu minixi Misira?»›» ");
INSERT INTO sus_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Munsa naxa a masen Alatala bɛ, «I a falama i sube fima yi ɲama ma kike keren bun ma? N na xɛmɛ wulu kɛmɛ senni nan ya ma. ");
INSERT INTO sus_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Xuruse gɔɔrɛ mu nɔma e ralide sube ra. Hali yɛxɛ naxee na baa ma, e mu nɔma e ralide.» ");
INSERT INTO sus_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Alatala naxa a yaabi, «N sɛnbɛ xurun na rabade? I fama a kolonde xa n ma wɔyɛnyi findixi nɔndi nan na.» ");
INSERT INTO sus_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Munsa naxa siga Alatala xa masenyi dɛntɛgɛde ɲama bɛ. A naxa ɲama forie mixi tongo solofere malan Ala xa hɔrɔmɔlingira rabilinyi. ");
INSERT INTO sus_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Alatala naxa goro nuxui kui, a masenyi ti Munsa bɛ. A naxa a yɛtɛ Xaxili Sɛniyɛnxi nde tongo naxan nu na Munsa ma, a a sa na fori mixi tongo solofere ma. Na Xaxili Sɛniyɛnxi to goro e ma, e naxa so masenyi tife Ala xili ra, kɔnɔ e mu a ikuya. ");
INSERT INTO sus_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Kɔnɔ xɛmɛ firin nu na na fori tongo solofere ya ma naxee mu siga malanyi. E mu siga hɔrɔmɔlingira yire, e naxa lu yonkinde kui. Kɔnɔ Ala Xaxili Sɛniyɛnxi naxa goro e fan ma, e fa masenyi ti Ala xili ra ɲama tagi. ");
INSERT INTO sus_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Fonike nde naxa a gi, a sa a fala Munsa bɛ, «Eledade nun Medadi na masenyi tife Ala xili ra ɲama tagi.» ");
INSERT INTO sus_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nunu xa di xɛmɛ Yosuwe, naxan nu Munsa malima kafi a fonike tɛmui, a naxa a fala Munsa bɛ, «N marigi, i xa na fe dan.» ");
INSERT INTO sus_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Munsa naxa a yaabi, «I tɔɔnɛ tife n tan nan ma fe ra? A xɔli n ma Alatala xa ɲama birin findi namiɲɔnmɛe ra naxee bara Ala Xaxili Sɛniyɛnxi sɔtɔ!» ");
INSERT INTO sus_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Na tɛmui, Munsa nun Isirayila kuntigie naxa gbilen ɲama ya ma. ");
INSERT INTO sus_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Alatala naxa foye xungbe ramini kelife baa ma, naxan xɔni gbegbe radin ɲama yonkinde rabilinyi, han kelife yonkinde tagi, a sa dɔxɔ fɛɛɲɛn keren ɲɛrɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ɲama naxa fɛɛɲɛn na xɔnie matongo ra, han na kuye iba. E man naxa fɛɛɲɛn xɔnie matongo ra, han kankan naxa paani ya fu sɔtɔ, litiri kɛmɛ saxan tongo suuli sama paani naxan kui. E naxa e rafen e xa yonkinde rabilinyi. ");
INSERT INTO sus_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kɔnɔ beenu Isirayilakae xa gɛ na sube donde, Alatala naxa xɔnɔ e ma, a e ɲaxankata a xɔrɔxɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","E naxa na yire xili sa Kibiroti Hataawa, na nan na ki «milante gaburi,» barima milante gali nan nagata mɛnni. ");
INSERT INTO sus_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ɲama naxa keli Kibiroti Hataawa, e sa yonkin Xaseroti. ");
INSERT INTO sus_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Munsa to nu bara Kusi ginɛ dɔxɔ, Mariyama nun Haruna naxa Munsa mafala, ");
INSERT INTO sus_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","a falafe ra, «Alatala wɔyɛnma Munsa nan gbansan saabui ra? A mu wɔyɛnma muxu fan saabui ra?» Alatala naxa na masenyi mɛ. ");
INSERT INTO sus_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Munsa nu findixi yɛtɛ magoroe nan na dangife mixi birin na. ");
INSERT INTO sus_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Alatala naxa Munsa, Haruna, nun Mariyama xili keren na, a e birin xa siga hɔrɔmɔlingira. E to siga naa, ");
INSERT INTO sus_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Alatala naxa goro nuxui kui hɔrɔmɔlingira dɛ ra. A naxa Haruna nun Mariyama xili. E firin naxa e maso a ra. ");
INSERT INTO sus_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Alatala naxa a masen e bɛ, «Wo tuli mati n ma masenyi ra. N namiɲɔnmɛ xɛɛma wo ya ma tɛmui naxɛ, n nan n yɛtɛ masenma na kanyi bɛ laamatunyi nan kui. N wɔyɛn a ra xiye ra. ");
INSERT INTO sus_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kɔnɔ n ma konyi Munsa tan gbe mu na na ki xɛ. A tan findixi n dugutɛgɛ nan na n ma wali birin kui. ");
INSERT INTO sus_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","N na n ma masenyi makɛnɛnma a bɛ, n mu taali wɔyɛnyi rawalima muxu tagi. N nan n yɛtɛ masenma a bɛ, a fa n niini igbɛfe. Munfe ra wo mu gaaxu n ma konyi Munsa mafalafe ra?» ");
INSERT INTO sus_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Alatala naxa xɔnɔ e ma, a fa keli e xun ma. ");
INSERT INTO sus_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nuxui to keli hɔrɔmɔlingira xun ma, Mariyama fate naxa rafiixɛ kunɛ ra keren na. Haruna to a to, kunɛ na Mariyama fate birin ma, ");
INSERT INTO sus_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","a naxa Munsa mayandi, «Yandi, n marigi, i naxa muxu ratɔn muxu xa yunubi xa fe ra, muxu naxan nabaxi muxu xa xaxilitareɲa kui. ");
INSERT INTO sus_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mariyama naxa lu alɔ di naxan faxaxi a nga furi, naxan fate sɛɛti bɔrɔxi beenu a bari tɛmui.» ");
INSERT INTO sus_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Munsa naxa a xui rate Alatala ma, «N Marigi, n bara i maxandi, a rayalan!» ");
INSERT INTO sus_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Alatala naxa a yaabi, «Xa a baba dɛye bɔxun a yatagi, a mu yaagima xɛ han lɔxun keren? I xa a ramini ɲama ya ma. A na ge lɔxun keren nabade ɲama yonkinde fari ma, wo nɔma a rasode wo ya ma.» ");
INSERT INTO sus_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Na kui, e naxa a ramini ɲama ya ma, a xi solofere raba yonkinde fari ma. Ɲama mu keli e yonkinde han Mariyama naxa ragbilen e ya ma. ");
INSERT INTO sus_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Na to ba a ra, ɲama naxa keli Xaseroti, e naxa sa yonkin Paran gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«I xa yarerati keren keren sugandi bɔnsɔɛ birin ya ma, i xa e xɛɛ Kanaan bɔxi ma, e xa sa na bɔxi rabɛn, n naxan fima Isirayilakae ma.» ");
INSERT INTO sus_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Munsa naxa na mixie xɛɛ kelife Paran gbengberenyi ma, alɔ Alatala a yamarixi ki naxɛ. Na mixi birin findi Isirayila kuntigie nan na. ");
INSERT INTO sus_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","E xilie nan yi ki: Kelife Ruben bɔnsɔɛ ma, Sakuru xa di xɛmɛ Samuwa. ");
INSERT INTO sus_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kelife Simeyɔn bɔnsɔɛ ma, Xori xa di xɛmɛ Safati. ");
INSERT INTO sus_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kelife Yuda bɔnsɔɛ ma, Yefune xa di xɛmɛ Kalebi. ");
INSERT INTO sus_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kelife Isakari bɔnsɔɛ ma, Yusufu xa di xɛmɛ Yigali. ");
INSERT INTO sus_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kelife Efirami bɔnsɔɛ ma, Nunu xa di xɛmɛ Hoseya. ");
INSERT INTO sus_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kelife Bunyamin bɔnsɔɛ ma, Rafu xa di xɛmɛ Paliti. ");
INSERT INTO sus_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kelife Sabulon bɔnsɔɛ ma, Sodi xa di xɛmɛ Gadiyeli. ");
INSERT INTO sus_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kelife Yusufu xa di, Manasi bɔnsɔɛ ma, Susi xa di xɛmɛ Gadi. ");
INSERT INTO sus_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kelife Dana bɔnsɔɛ ma, Gemali xa di xɛmɛ Amiyɛli. ");
INSERT INTO sus_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kelife Aseri bɔnsɔɛ ma, Mikayeli xa di xɛmɛ Seturu. ");
INSERT INTO sus_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kelife Nafatali bɔnsɔɛ ma, Fofisi xa di xɛmɛ Naxabi. ");
INSERT INTO sus_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kelife Gadi bɔnsɔɛ ma, Maki xa di xɛmɛ Geyuweli. ");
INSERT INTO sus_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Xɛmɛe xilie nan na ki Munsa naxee xɛɛ Kanaan bɔxi rabɛnde. Munsa naxa Nunu xa di xɛmɛ Hoseya xili sa Yosuwe. ");
INSERT INTO sus_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Munsa to e xɛɛ Kanaan bɔxi rabɛnde, a naxa a fala e bɛ, «Wo xa mini Negewi gbengberenyi biri, han wo geyae yire li. ");
INSERT INTO sus_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Wo xa na bɔxi rabɛn, wo xa a kolon xa mɛnnikae sɛnbɛ gbo, xa e sɛnbɛ mu gbo, xa e wuya, xa e mu wuya. ");
INSERT INTO sus_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Wo xa a mato xa na bɔxi fan. Wo xa a kolon xa tɛtɛ na na taae rabilinyi ma. ");
INSERT INTO sus_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Wo xa a mato xa na bɔxi fan sansi bɛ, xa wurie gbo naa. Wo kata wo xa fa na sansi bogi ndee ra.» Wɛni bilie bogi singe tɛmui nan nu a ra. ");
INSERT INTO sus_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","E naxa sa na bɔxi rabɛn, kelife Sini gbengberenyi ma, han Rexobo, Xamata mabiri. ");
INSERT INTO sus_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","E naxa dangi Negewi gbengberenyi ra, e sa Xebiron li, Anaki xa die Aximan, Sɛsayi, nun Talamayi nu sabatixi dɛnnaxɛ. Xebiron taa nu tixi ɲɛ solofere beenu Sowan taa xa ti Misira. ");
INSERT INTO sus_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","E to Esekoli gulunba li, e naxa wɛni bili salonyi nde rasɛgɛ, a tɔnsɔɛ nu na naxan ma. Mixi firin naxa na xanin wuri kuye ra. E naxa xɔrɛ bogi nde fan tongo, a nun bogise nde naxan xili girenadi, naxan maniyɛ kɔɔbɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","E naxa na yire xili sa Esekoli, na nan na ki «Tɔnsɔɛ yire,» na wɛni bogi tɔnsɔɛ xa fe ra, e naxan baxi. ");
INSERT INTO sus_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","E to xi tongo naani raba naa na bɔxi rabɛnde, e naxa gbilen ");
INSERT INTO sus_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Munsa, Haruna, nun Isirayila ɲama yire. E nu na Kadesi, Paran gbengberenyi ma. Mɛnni e naxa dɛntɛgɛ sa, e na bɔxi sansi bogie masen e bɛ. ");
INSERT INTO sus_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","E naxa a fala Munsa bɛ, «Muxu so nɛ bɔxi ma, i muxu xɛɛ dɛnnaxɛ. Bɔxi nan a ra, kumi nun xiɲɛ xɛlɛma dɛnnaxɛ. Na bogise ndee nan ya. ");
INSERT INTO sus_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Kɔnɔ ɲama naxan sabatixi na bɔxi ma, e sɛnbɛ gbo. Tɛtɛ dɔxɔxi taa birin na. Taa xungbe nan e ra. Muxu Anaki bɔnsɔɛ yati toxi nɛ naa. ");
INSERT INTO sus_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛkikae sabatixi Negewi gbengberenyi nan ma. Xitikae, Yebusukae, nun Amorikae, nee nan sabatixi geya yire. Kanaankae tan sabatixi baa dɛ nan na, a nun Yurudɛn xure dɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebi naxa ɲama masabari Munsa ya xɔri, a falafe ra, «Won xɛɛ! Won xa yi bɔxi findi won gbe ra. Won nɔma na rabade.» ");
INSERT INTO sus_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kɔnɔ boore naxee siga bɔxi rabɛnde, nee naxa a fala, «Won mu nɔma sigade na ɲama gerede. E sɛnbɛ gbo won bɛ!» ");
INSERT INTO sus_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Na kui e naxa fe ɲaaxi fala na bɔxi xa fe ra Isirayila ɲama bɛ. E naxa a fala, «Muxu bɔxi naxan nabɛnxi, bɔxi nan a ra naxan mixi faxama. Mixi gbangbalanyie sabatixi naa. ");
INSERT INTO sus_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Muxu anabiyoroe to nɛ naxan fatanxi Anaki bɔnsɔɛ ra. Muxu nu luxi nɛ alɔ katoe e mabiri. E tan yo, muxu tan yo, e birin a toxi na ki nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ɲama naxa wa xui ramini kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Isirayilaka birin nu fa wɔyɛn na Munsa nun Haruna ma, e nu a fala, «A nu fisa muxu xa faxa Misira, xa na mu a ra yi gbengberen yire. ");
INSERT INTO sus_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Munfe ra Alatala muxu rasofe yi bɔxi ma, muxu xa faxa santidɛgɛma ra, muxu xa die nun muxu xa ginɛe xa suxu gere kui. A mu fisa muxu xa gbilen Misira?» ");
INSERT INTO sus_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E naxa a fala e booree bɛ, «Won mangɛ keren ti won xun na, won xa gbilen Misira.» ");
INSERT INTO sus_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Munsa nun Haruna naxa e yatagi rafelen bɔxi ma Isirayilaka birin ya xɔri. ");
INSERT INTO sus_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nunu xa di xɛmɛ Yosuwe nun Yefune xa di xɛmɛ Kalebi naxa e xa donma ibɔɔ sunnunyi kui. Na mixi firin nu na na xɛɛrae ya ma, naxee siga Kanaan bɔxi rabɛnde. ");
INSERT INTO sus_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","E naxa fa yi masenyi ti ɲama bɛ, «Muxu bɔxi naxan matoxi, bɔxi fanyi fanyi nan a ra. ");
INSERT INTO sus_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Xiɲɛ nun kumi yire nan a ra. Xa Alatala na won bɛ, a won nasoma nɛ naa, a na bɔxi fi won ma. ");
INSERT INTO sus_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yandi, wo naxa Alatala matandi. Wo naxa gaaxu na bɔxi mixie ya ra. Won nɔma nɛ e ra. E sanke yo mu na sɔnɔn, barima Alatala na won tan nan bɛ. Wo naxa gaaxu e ya ra.» ");
INSERT INTO sus_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ɲama nu wama e magɔnɔfe, kɔnɔ Alatala xa nɔrɛ naxa mini hɔrɔmɔlingira Isirayilaka birin ya xɔri. ");
INSERT INTO sus_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Alatala naxa a masen Munsa bɛ, «Yi ɲama bama n maberefe mun tɛmui? Munfe ra e siikɛma hali n kaabanakoe rabama e tagi? ");
INSERT INTO sus_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","N xa wuganyi radin e ma, n nee faxa. Na tɛmui n bɔnsɔɛ xungbe sɛnbɛma nde rakelima nɛ i saabui ra, naxan dangi e tan na.» ");
INSERT INTO sus_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Munsa naxa Alatala yaabi, «Misirakae bara a kolon, a i yi ɲama ramini e xa bɔxi ra i sɛnbɛ nan na. ");
INSERT INTO sus_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","E bara bekae rakolon. Nee bara a mɛ, a i tan Alatala na i xa ɲama fɔxɔ ra, a i i yɛtɛ masenma e ma, a i nuxui sama e xun ma, a i ɲɛrɛma e ya ra nuxui kui yanyi ra, nun tɛ kui kɔɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Xa i fa yi ɲama birin faxa kerenyi ra, bɔnsɔɛ naxee i xa fe mɛxi, e a falama nɛ, ");
INSERT INTO sus_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Alatala sɛnbɛ yo mu nu nɔma yi ɲama rasode bɔxi ma, a naxan laayidixi e bɛ. Na nan a ra, a e birin sɔntɔ gbengberenyi ma.›» ");
INSERT INTO sus_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«I xa i sɛnbɛ masen e bɛ, alɔ i tan yati a yitaxi ki naxɛ, a falafe ra, ");
INSERT INTO sus_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹N mu xɔnɔma mafuren mafuren. N ma diɲɛ nun fanyi gbo. N mixie xa yunubie nun fe ɲaaxie xafarima. Kɔnɔ n mixi kobi nun mixi fanyi tagi rasama. N benbae xa yunubi sare dɔxɔma e xa die xun ma han bɔnsɔɛ saxan, xa na mu naani.› ");
INSERT INTO sus_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Yandi, n bara i maxandi, diɲɛ i xa ɲama xa yunubi ma i xa hinnɛ xa fe ra, alɔ i a rabaxi kabi e mini Misira tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Alatala naxa a yaabi, «N bara diɲɛ i xa maxandi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kɔnɔ, n bara n kali, nɔndi nan a ra alɔ n to na na, alɔ n ma nɔrɛ naxan bɔxi rafema, ");
INSERT INTO sus_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","xɛmɛ naxan birin n ma nɔrɛ nun n ma kaabanakoe toxi, n naxee raba Misira nun gbengberenyi ma, kɔnɔ e fa muruta n ma han sanya fu tuli xɔrɔxɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","nee sese mu bɔxi toma, n naxan laayidixi e benbae bɛ. Naxan birin murutaxi n ma, e sese mu na toma. ");
INSERT INTO sus_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kɔnɔ n ma konyi di Kalebi to bira xaxili gbɛtɛ fɔxɔ ra, a fa n nabatu, n a tan nasoma nɛ na bɔxi ma, a naxan nabɛnxi. A bɔnsɔɛ kɛ sɔtɔma nɛ naa. ");
INSERT INTO sus_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amalɛkikae nun Kanaankae to sabati gulunba kui, tina wo xa wo mafindi, wo xa gbilen gbengberenyi ma Xulunyumi Baa mabiri.» ");
INSERT INTO sus_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Yi ɲama kobi n matandima han mun tɛmui? N bara Isirayilakae xui mɛ, e naxan falama n bɛ, e ti n kanke. ");
INSERT INTO sus_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","A fala e bɛ, ‹N bara n kali, nɔndi nan a ra, alɔ n to na na, n a rabama nɛ wo bɛ alɔ n a mɛxi wo dɛ i ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Wo tan matandilae, naxan birin kɔntixi Isirayila ɲama ya ma, naxee xa simaya bara dangi ɲɛ mɔxɔɲɛn na, wo faxama nɛ yi gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Wo mu soma bɔxi ma n naxan laayidi wo bɛ, fo Yefune xa di xɛmɛ Kalebi nun Nunu xa di xɛmɛ Yosuwe. ");
INSERT INTO sus_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Wo xa die, wo naxee ma a e birin faxama gere nan kui, n nee tan nasoma nɛ na bɔxi kui, wo mɛɛxi naxan na. ");
INSERT INTO sus_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Wo faxama gbengberenyi nan ma, wo furee luma na nɛ. ");
INSERT INTO sus_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wo xa die findima ɲɛrɛtie nan na ɲɛ tongo naani bun ma yi gbengberenyi ma. E wo xa yunubi sare xaninma han wo birin faxa gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Wo xi xasabi naxan naba na bɔxi rabɛnde, wo na ɲɛ xasabi rabama gbengberenyi ma wo xa yunubi xa fe ra. Wo to xi tongo naani raba na bɔxi rabɛnde, wo fama nɛ ɲɛ tongo naani rabade gbengberenyi ma, alako wo xa a kolon n na yunubi xɔnxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","N tan Alatala, n bara gɛ wɔyɛnde. N bara na natɛ tongo yi ɲama kobi xa fe ra, naxan ti n kanke. E birin faxama nɛ gbengberenyi ma.›» ");
INSERT INTO sus_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Munsa xa xɛɛrae to gbilen kelife na bɔxi rabɛnde, e naxa fe xɔrɔxɔɛ fala na bɔxi xa fe ra han Isirayila ɲama naxa ti Munsa kanke. ");
INSERT INTO sus_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Na kui, Alatala naxa e faxa keren na. ");
INSERT INTO sus_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Na xɛɛrae ya ma, Yefune xa di xɛmɛ Kalebi nun Nunu xa di xɛmɛ Yosuwe nan gbansan mu faxa. ");
INSERT INTO sus_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Munsa to na masenyi ti Isirayila ɲama bɛ, e naxa sunnun ki fanyi. ");
INSERT INTO sus_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","E naxa keli subaxɛ ma, e xa te geya longori. E naxɛ, «Muxu xa te yire, Alatala dɛnnaxɛ masenxi muxu bɛ. Muxu bara yunubi raba.» ");
INSERT INTO sus_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Munsa naxa e maxɔrin, «Wo Alatala xa yaamari nan matandife? Wo mu geenima na kui. ");
INSERT INTO sus_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Wo naxa te de, barima Alatala mu na wo ya ma sɔnɔn. Wo naxa a niya wo yaxuie xa nɔ wo ra. ");
INSERT INTO sus_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalɛkikae nun Kanaankae na wo ya ra, e wo sɔntɔma nɛ e xa santidɛgɛmae ra. Wo to bara wo kobe so Alatala ra, a mu na wo fɔxɔ ra.» ");
INSERT INTO sus_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kɔnɔ Isirayila ɲama mu e tuli mati Munsa ra. E naxa te geya yire, kɔnɔ Alatala xa saatɛ kankira nun Munsa mu keli ɲama xa yonkinde. ");
INSERT INTO sus_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalɛkikae nun Kanaankae naxee nu sabatixi na geya yire, e naxa goro Isirayilakae xili ma, e fa e bɔnbɔ, e e masɛgɛ han Horoma. ");
INSERT INTO sus_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«A fala Isirayilakae bɛ, ‹Wo na so bɔxi ma, n dɛnnaxan fixi wo ma sabatide ra, ");
INSERT INTO sus_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","xa wo wama xuruse bafe sɛrɛxɛ ra naxan nafan Alatala ma, alɔ sɛrɛxɛ gan daaxi, laayidi sɛrɛxɛ, sɛrɛxɛ ɲanigexi, xa na mu a ra sali sɛrɛxɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","wo xa sansi xɔri dinxi sɛrɛxɛ sa na fari, naxan findima sansi xɔri dinxi luxutaxi kilo saxan masunbuxi ture litiri keren nun a tagi ra, ");
INSERT INTO sus_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","a nun wɛni litiri keren nun a tagi. Na sama sɛrɛxɛ gan daaxi nun sɛrɛxɛ ɲanigexi nan xun ma naxan findima yɛxɛɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Xa a sa findi yɛxɛɛ kontonyi nan na, wo xa sansi xɔri dinxi sɛrɛxɛ sa na fari, naxan findima sansi xɔri dinxi luxutaxi kilo senni masunbuxi ture litiri firin na, ");
INSERT INTO sus_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","a nun wɛni litiri firin. Na ganxi rafan Alatala ma.›» ");
INSERT INTO sus_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«Xa wo wama ninge bafe sɛrɛxɛ ra naxan nafan Alatala ma, alɔ sɛrɛxɛ gan daaxi, laayidi sɛrɛxɛ, xanunteya sɛrɛxɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","wo xa sansi xɔri dinxi sɛrɛxɛ sa na fari, naxan findima sansi xɔri dinxi luxutaxi kilo solomanaani naxan masunbuxi ture litiri saxan na, ");
INSERT INTO sus_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","a nun wɛni litiri saxan. Na ganxi rafan Alatala ma.» ");
INSERT INTO sus_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Na nan nabama ningee, yɛxɛɛ kontonyie, yɛxɛɛe, nun sie birin bɛ wo naxan bama sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Wo xa na raba xuruse birin bɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isirayilaka birin xa a raba na ki nɛ e xa sɛrɛxɛ birin bɛ, e naxan bama tɛ ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Xɔɲɛ naxee na wo ya ma, e fan xa a raba na ki e sɛrɛxɛ gan daaxi bama tɛmui naxɛ. Na rafan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Sɛriyɛ keren nan luma ɲama birin bɛ, Isirayilakae ba, xɔɲɛe ba. Keli wo tan ma, han wo xa die, nun nee fan xa die naxee fama, wo tan yo, xɔɲɛ yo, wo birin xa Alatala xa sɛriyɛ suxu na ki nɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Isirayilakae ba, xɔɲɛe ba, wo birin na sɛriyɛ keren nun yaamari keren nan bun ma.» ");
INSERT INTO sus_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«A fala Isirayilakae bɛ, ‹Wo na so bɔxi ma, n wo rasofe dɛnnaxɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","wo fa na bɔxi daxamui sɔtɔ, wo xa nde ba sɛrɛxɛ ra n bɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Wo na taami singe yailan sansi xɔri nɛɛnɛ ra, wo xa nde ba sɛrɛxɛ ra n bɛ, alɔ wo sansi xɔri nɛɛnɛ nde bama ki naxɛ xɛ xaba tɛmui lonyi yire. ");
INSERT INTO sus_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Wo xa na taami singe ba Alatala bɛ ɲɛ yo ɲɛ.›» ");
INSERT INTO sus_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Xa a sa li wo tantanxi nɛ Alatala xa yaamarie suxufe kui, a naxee masenxi Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","kelife na masen tɛmui, han wo xa die xa mamadie xa tɛmui, ");
INSERT INTO sus_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","xa wo mu na raba wo ɲanige ra, wo a raba kolontareya kui, ɲama xa tuura ba sɛrɛxɛ gan daaxi ra, naxan nafan Alatala ma. Wo xa sansi xɔri dinxi sɛrɛxɛ nun wɛni sɛrɛxɛ sa na fari a raba ki ma, a nun sikɔtɛ naxan findima yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sɛrɛxɛdubɛ yunubi xafari maxandima nɛ Isirayilaka birin bɛ. Alatala diɲɛma nɛ e ma. Yunubi nan a ra, e mu naxan ɲanigexi. E man bara sɛrɛxɛ gan daaxi ba Alatala bɛ, a nun e xa yunubi xafari sɛrɛxɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Na yunubi xafarima nɛ Isirayilaka birin nun e xa xɔɲɛe bɛ, barima tantanyi na nu a ra.» ");
INSERT INTO sus_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Xa mixi keren nan yunubi raba ɲanigetareɲa kui, a xa si ginɛ keren ba yunubi xafari sɛrɛxɛ ra, naxan bara ɲɛ keren sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Sɛrɛxɛdubɛ yunubi xafari maxandima nɛ na mixi bɛ naxan yunubi raba ɲanigetareɲa kui Alatala ya xɔri. Na na ɲɔn, a xa yunubi bara xafari. ");
INSERT INTO sus_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Na sɛriyɛ kerenyi na Isirayilakae nun e xa xɔɲɛe bɛ, yunubi rabafe ɲanigetareɲa xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Kɔnɔ xa mixi nde sa Alatala matandi a ɲanige ra, a findi Isirayilaka ra, a findi xɔɲɛ ra, na kanyi kerima nɛ ɲama tagi. ");
INSERT INTO sus_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","A bara Alatala xa masenyi mabere, a bara Alatala xa sɛriyɛ matandi. Na kanyi kerima nɛ ɲama tagi, barima na yunubi kote dɔxɔxi a xun ma.» ");
INSERT INTO sus_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Isirayilakae to nu na gbengberenyi ma, e naxa mixi nde li malabui lɔxɔɛ a yege fenfe. ");
INSERT INTO sus_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","E naxa a xanin Munsa nun Haruna xɔn ɲama ya xɔri. ");
INSERT INTO sus_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","E naxa a suxu, kɔnɔ e mu a ɲaxankata, barima natɛ mu nu tongoxi a xa fe ra sinden. ");
INSERT INTO sus_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Alatala naxa a masen Munsa bɛ, «Yi xɛmɛ lan nɛ a xa faxa. Ɲama birin xa a magɔnɔ han a faxa yonkinde fari ma.» ");
INSERT INTO sus_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ɲama birin naxa a ramini e yonkinde fari ma, e a magɔnɔ han a faxa, alɔ Alatala a yamari Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«A fala Isirayilakae bɛ, e tan nun e xa die xa mamadie e xa e xa sosee sanbunyi rafutufutu, e gɛsɛ gɛrɛ daaxi xiri a dɛ i. ");
INSERT INTO sus_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Na sanbunyi rafutufutuxi findima tɔnxuma nan na wo bɛ, alako wo xa ratu Alatala xa yaamarie ma, wo man xa e rabatu. Wo naxa bira wo yɛtɛ waxɔnfee fɔxɔ ra, naxee wo ratantanma. ");
INSERT INTO sus_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Na nan a niyama, wo ratuma n ma yaamarie ma, wo man e rabatu. Na kui, wo bara findi n ma mixie ra. ");
INSERT INTO sus_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","N tan nan Alatala ra, wo Marigi Ala, naxan wo ramini Misira bɔxi ra, alako n xa findi wo Marigi Ala ra. N tan nan Alatala ra, wo Marigi Ala.» ");
INSERT INTO sus_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lewi bɔnsɔɛ mixi nde, naxan xili Kora, Yisehari xa di xɛmɛ, Kehati xa mamadi, a nun Datan nun Abirami, Eliyabi xa di xɛmɛe, a nun Peleta xa di xɛmɛ Oni, naxan fatanxi Ruben bɔnsɔɛ ra, ");
INSERT INTO sus_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","nee naxa ti Munsa kanke. Isirayilaka mixi kɛmɛ firin mixi tongo suuli nu na e xanbi ra. Kuntigi belebelee nu na e ya ma. ");
INSERT INTO sus_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","E naxa e malan Munsa nun Haruna xili ma, e fa a fala e bɛ, «Wo xa mangɛya bara ɲɔn! Isirayila ɲama birin sɛniyɛn, Alatala man na muxu tagi. Munfe ra wo tan gbansan wo yɛtɛ itema Alatala xa ɲama xun ma?» ");
INSERT INTO sus_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Munsa to na mɛ, a naxa a yatagi rafelen bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","A naxa a fala Kora nun a xa mixie bɛ, «Tina gɛɛsɛgɛ, Alatala fama a masende won bɛ, a xa mixi sɛniyɛnxi na naxan na. A tinma na kanyi xa makɔrɛ a ra, a naxan sugandima. ");
INSERT INTO sus_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Kora, i nun i xa mixie, wo xa surayi gansee tongo. ");
INSERT INTO sus_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Tina wo tɛ sa e kui, wo surayi gan Alatala bɛ. Alatala na naxan sugandi, na nan sɛniyɛn. Lewi bɔnsɔɛ, yakɔsi wo bara a radangi a i.» ");
INSERT INTO sus_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Munsa man naxa a fala Kora bɛ, «Lewi bɔnsɔɛ xa die, wo wo tuli mati. ");
INSERT INTO sus_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Isirayila Marigi Ala wo sugandixi nɛ Isirayila ɲama ya ma a xa hɔrɔmɔlingira wali xa fe ra. Wo tan nan tima ɲama ya ra e sali tɛmui. Na mu wo wasa? ");
INSERT INTO sus_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","A tinma wo tan Lewi bɔnsɔɛ xa makɔrɛ a ra, kɔnɔ wo wama sɛrɛxɛdubɛ wali fan nan nabafe. ");
INSERT INTO sus_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Na kui i tan nun i xa mixie, wo bara lan wo boore ma wo xa Alatala matandi. Munfe ra wo na tife Haruna kanke?» ");
INSERT INTO sus_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Munsa naxa mixi xɛɛ Eliyabi xa di xɛmɛe Datan nun Abirami xilide, kɔnɔ e naxa tondi, e fa a fala, «Muxu tan mu sigama. ");
INSERT INTO sus_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Munfe ra i bara muxu ramini bɔxi ma, kumi nun xiɲɛ xɛlɛma dɛnnaxɛ, alako muxu xa faxa yi gbengberenyi ma? I man wama i yɛtɛ findife muxu xa mangɛ ra? ");
INSERT INTO sus_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","I mu muxu rasoxi bɔxi kui kumi nun xiɲɛ xɛlɛma dɛnnaxɛ. I mu xɛe nun wɛni bilie xa fixi muxu ma kɛ ra. I ɲɔxɔ a ma, a i nun dɔnxuie nan a ra? Muxu mu sigama!» ");
INSERT INTO sus_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Munsa naxa xɔnɔ ki fanyi ra, a a fala Alatala bɛ, «I naxa e xa sɛrɛxɛ suxu. N mu sese tongoxi e yi ra, hali sofale keren. N mu fe ɲaaxi yo rabaxi e ra.» ");
INSERT INTO sus_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Munsa naxa a fala Kora bɛ, «I tan nun i xa mixie, tina wo nun Haruna xa ti be Alatala ya i. ");
INSERT INTO sus_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Wo birin xa wo xa surayi gansee tongo, wo xa surayi sa a ma, wo wo yɛtɛ masen Alatala bɛ. Na lanma surayi ganse kɛmɛ firin tongo suuli nan ma. I tan nun Haruna, wo fan xa wo xa surayi ganse suxu wo yi ra.» ");
INSERT INTO sus_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","E birin naxa tɛ sa e xa surayi gansee kui, e naxa surayi sa a ma, e fa ti hɔrɔmɔlingira dɛ ra. Munsa nun Haruna fan nu na naa. ");
INSERT INTO sus_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora to ɲama birin malan Munsa nun Haruna xili ma hɔrɔmɔlingira dɛ ra, Alatala xa nɔrɛ naxa mini ɲama birin ma. ");
INSERT INTO sus_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Wo mini yi mixie ya ma. N xa e sɔntɔ keren na!» ");
INSERT INTO sus_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Munsa nun Haruna naxa e yatagi rafelen bɔxi ma, e fa a fala, «Alatala, Daali birin Mangɛ, a lanma i xa xɔnɔ ɲama birin ma, mixi keren xa yunubi xa fe ra?» ");
INSERT INTO sus_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Alatala naxa Munsa yaabi, ");
INSERT INTO sus_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«A fala ɲama birin bɛ, e xa e makuya Kora, Datan, nun Abirami xɔnyi ra.» ");
INSERT INTO sus_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Munsa nun Isirayila kuntigie naxa siga Abirami nun Datan yire. ");
INSERT INTO sus_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","A naxa a fala ɲama bɛ, «Wo wo makuya yi yunubitɔɛe xa lingirae ra. Wo naxa din e xa see ra, alako wo naxa fa faxa e xa yunubie xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ɲama naxa a masiga Kora, Datan, nun Abirami xa lingirae ra. Datan nun Abirami naxa mini e xɔnyi, e ti naadɛ ra, e nun e xa ginɛe, nun e xa die. ");
INSERT INTO sus_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Munsa naxa a fala, «Wo a kolonma a Alatala nan n tixi yi wali birin na, n tan mu a ra. ");
INSERT INTO sus_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Xa yi mixie mu faxa kaabanakoe ra, Alatala mu n xɛɛxi. ");
INSERT INTO sus_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kɔnɔ xa Alatala sa kaabanako raba, a bɔxi rabi, e goro e ɲiɲɛ ra a kui, e tan nun e kɛ birin, na nan a masenma wo bɛ, a e bara Alatala mabere.» ");
INSERT INTO sus_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Munsa to gɛ na falade, bɔxi naxa rabi e sanyi bun ma, ");
INSERT INTO sus_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","a e gerun, Kora nun a xa mixie, e xa lingirae, a nun e xa harige birin. ");
INSERT INTO sus_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","E naxa goro aligiyama e ɲiɲɛ ra, e tan nun e sɔtɔse birin. Bɔxi naxa e makoto, e naxa lɔɛ ɲama tagi. ");
INSERT INTO sus_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Isirayilaka naxan birin nu na e sɛɛti ma, e naxa e gi e gbelegbele xui ma, e nu fa a fala, «Bɔxi naxa muxu fan gerun de!» ");
INSERT INTO sus_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Alatala naxa tɛ radin na mixi kɛmɛ firin mixi tongo suuli ma, naxee surayi gan hɔrɔmɔlingira dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«A fala Haruna sɛrɛxɛdubɛ xa di xɛmɛ Eleyasari bɛ, a xa surayi gansee matongo tɛ xɔɔra, a xa e tɛ wolee rawoli yire makuye. Na surayi gansee bara findi se sɛniyɛnxie ra Ala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Wo xa na surayi gansee matongo, yunubitɔɛe naxee rawalixi e fa faxa, wo e bɔnbɔ han e xa findi a kebela ra, wo e sa sɛrɛxɛbade ma. Se sɛniyɛnxi na a ra barima a nu bara masen Alatala bɛ. Na kui a findi tɔnxuma nan na Isirayilakae bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Eleyasari sɛrɛxɛdubɛ naxa na mixie xa surayi ganse wure gbeeli daaxie matongo, na mixi faxaxie naxee rawalixi, a e bɔnbɔ han e findi kebela ra, a e sa sɛrɛxɛbade ma. ");
INSERT INTO sus_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Na bara findi tɔnxuma ra Isirayilakae bɛ, alako e xa ratu a ma a mu lan mixi yo xa surayi gan sɛrɛxɛ ra bafe Haruna xa die, xa na mu a ra a fan luma nɛ alɔ Kora nun a xa mixie, alɔ Alatala a masenxi Munsa bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Na kuye iba, Isirayila ɲama naxa wɔyɛn fɔlɔ Munsa nun Haruna ma, a e tan nan Alatala xa ɲama faxaxi. ");
INSERT INTO sus_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","E nu e malanfe tɛmui naxɛ Munsa nun Haruna xili ma, e naxa a to nuxui naxa dusu hɔrɔmɔlingira xun ma, Alatala xa nɔrɛ fa mini e ma. ");
INSERT INTO sus_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Munsa nun Haruna naxa siga hɔrɔmɔlingira dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Wo mini yi mixie ya ma, n xa e sɔntɔ kerenyi ra.» Munsa nun Haruna naxa e yatagi rafelen bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Munsa fa a fala Haruna bɛ, «I xa tɛ wole tongo sɛrɛxɛbade yire, i a sa i xa surayi ganse kui a nun surayi nde. Na xanin mafuren mafuren ɲama mabiri, i sa yunubi xafari maxandi e bɛ. Alatala bara a xa xɔnɛ fulun yi ɲama xili ma, sɔntɔɛ ɲan bara fɔlɔ.» ");
INSERT INTO sus_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Haruna naxa surayi ganse tongo alɔ Munsa a fala a bɛ ki naxɛ, a a gi a siga ɲama yire, sɔntɔɛ nu bara fɔlɔ dɛnnaxɛ. A naxa surayi ba sɛrɛxɛ ra, a fa yunubi xafari maxandi ɲama bɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","A naxa ti mixi faxaxie nun mixi ɲiɲɛe tagi. Mixi faxafe naxa dan. ");
INSERT INTO sus_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Mixi wulu fu nun naani mixi kɛmɛ solofere nan faxa, bafe Kora xa mixie ra, naxee singe faxa. ");
INSERT INTO sus_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Mixi faxafe to dan, Haruna naxa gbilen Munsa yire hɔrɔmɔlingira dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«A fala Isirayilakae bɛ, bɔnsɔɛ xunyi birin xa yisuxuwuri keren so i yi ra, na lanma yisuxuwuri fu nun firin nan ma. I xa bɔnsɔɛ birin xili sɛbɛ a xa yisuxuwuri ma. ");
INSERT INTO sus_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","I xa Haruna xili sɛbɛ Lewi bɔnsɔɛ xa yisuxuwuri ma. Bɔnsɔɛ xunyi birin xa yisuxuwuri xa lu naa. ");
INSERT INTO sus_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","I na yisuxuwurie sama hɔrɔmɔlingira nan kui, saatɛ kankira ya tode ra, n luma n yɛtɛ masen na wo bɛ dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","N mixi naxan sugandixi, na kanyi xa yisuxuwuri mabutunma nɛ. Na kui, n bara a niya Isirayilakae naxa wɔyɛn wo ma sɔnɔn.» ");
INSERT INTO sus_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Munsa naxa dɛntɛgɛ sa Isirayilakae bɛ. Isirayila bɔnsɔɛ xunyi birin naxa fa e xa yisuxuwuri ra. Na naxa lan yisuxuwuri fu nun firin ma. Haruna gbe nu na e ya ma. ");
INSERT INTO sus_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Munsa naxa na yisuxuwurie sa Alatala ya i, hɔrɔmɔlingira kui, saatɛ kankira na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Na kuye iba, a to so hɔrɔmɔlingira kui, a naxa a to Haruna xa yisuxuwuri, naxan sa Lewi bɔnsɔɛ xili ra, a bara butun, a bara fuga, a tamare bogi gbeeli ramini. ");
INSERT INTO sus_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Munsa naxa yisuxuwuri birin namini, a e masen Isirayila ɲama bɛ. Bɔnsɔɛ xunyi birin to e to, e naxa e gbe tongo. ");
INSERT INTO sus_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Alatala naxa a masen Munsa bɛ, «I man xa Haruna xa yisuxuwuri ragbilen saatɛ kankira yire, a xa ragata tɔnxuma ra matandilae bɛ. Na kui e mu wɔyɛnma n ma, e mu faxa.» ");
INSERT INTO sus_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Munsa naxa Alatala xa yaamari rabatu, alɔ a masen a bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Isirayilakae naxa a fala Munsa bɛ, «A mato, muxu birin ɲɔnma nɛ halaki kui. ");
INSERT INTO sus_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Naxan yo a maso Alatala xa hɔrɔmɔlingira ra, na kanyi faxama nɛ. Muxu birin xa sɔntɔ?» ");
INSERT INTO sus_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Alatala naxa a masen Haruna bɛ, «I tan, i xa die, nun Lewi bɔnsɔɛ birin, wo tan nan yunubi sɔtɔma xa fe ɲaaxi sa raba hɔrɔmɔlingira xa fe ra. Haruna i tan nun i xa die, wo tan nan yunubi sɔtɔma xa fe ɲaaxi sa raba sɛrɛxɛdubɛɲa xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","I xa Lewi bɔnsɔɛ mixi birin maso i ra, alako e xa i tan nun i xa die mali wo xa wali ra hɔrɔmɔlingira kui. ");
INSERT INTO sus_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","E i malima hɔrɔmɔlingira wali kui, kɔnɔ e naxa makɔrɛ yirabase sɛniyɛnxie nun sɛrɛxɛbade ra, alako wo naxa faxa, e tan nun i tan. ");
INSERT INTO sus_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","E birama nɛ i fɔxɔ ra i xa hɔrɔmɔlingira wali birin kui. Mixi gbɛtɛ yo naxa sunbu wo ra. ");
INSERT INTO sus_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Wo tan gbansan xa sɛniyɛn lingira nun sɛrɛxɛbade wali raba, alako Alatala naxa fa a xa xɔnɛ ramini Isirayilakae ma sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","N tan nan wo ngaxakerenyi Lewi bɔnsɔɛ tongoxi Isirayilakae ya ma n yɛtɛ bɛ. N bara e sa wo sagoe, e xa wo mali hɔrɔmɔlingira wali raba ra. ");
INSERT INTO sus_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","I tan nun i xa die, wo ɲɔxɔ sama nɛ wo xa sɛrɛxɛdubɛ wali xɔn ma sɛrɛxɛbade nun yire sɛniyɛnxi fisamante, naxan na dugi gbakuxi xanbi ra. N tan nan na wali fixi wo ma. Mixi gbɛtɛ na a maso na ra, a faxama nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Alatala naxa a fala Haruna bɛ, «N bara Isirayilakae xa hadiya sɛniyɛnxi birin fi i tan nun i xa die ma, barima wo tan nan sugandixi sɛrɛxɛdubɛe ra abadan. ");
INSERT INTO sus_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","See nan yi ki naxee findima i gbe ra se sɛniyɛnxie tagi, tɛ mu naxee ganxi: Isirayilakae xa sɛrɛxɛ, e xa sansi xɔri dinxi sɛrɛxɛe, e xa yunubi xafari sɛrɛxɛe, nun e xa yɛtɛ ragbilen sɛrɛxɛe. Na sɛrɛxɛ sɛniyɛnxie findima i tan nun i xa die nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Wo nee donma nɛ alɔ se sɛniyɛnxie. Xɛmɛ birin nɔma e donde wo xa denbaya kui. Se sɛniyɛnxie nan e ra wo bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Se naxee baxi Isirayilakae xa hadiya sɛniyɛnxie ra, n nee fan fima nɛ i ma, naxee lintanma n ya i a masenfe ra n gbe na a ra. N na fima i tan, i xa di xɛmɛe, nun i xa di ginɛe ma. I xa mixi birin naxee sɛniyɛnxi e nɔma na donde. ");
INSERT INTO sus_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","N man bara daxamui singee fi i ma, Isirayilakae naxee bama n na hadiya ra alɔ ture, wɛni, nun sansi xɔrie dinxi. ");
INSERT INTO sus_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Daxamui singee e fama naxan birin na n bɛ, na birin findima i gbe nan na. I xa mixi birin naxee sɛniyɛnxi e nɔma na donde.» ");
INSERT INTO sus_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«Se naxan birin haramuxi mixie bɛ Isirayila bɔxi ma, a fa findi n gbe ra, n bara na fi i ma. ");
INSERT INTO sus_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Di singe birin naxee fima Alatala ma, a findi mixi ra, a findi xuruse ra, na birin i tan nan gbe a ra. Kɔnɔ ibunadama xa di xɛmɛ singe nun sube haramuxi xa di xɛmɛ singe, e tan xun sarama nɛ. ");
INSERT INTO sus_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","E na kike keren sɔtɔ, e xun xa sara gbeti kole suuli, naxan kole keren lanma giramu fu ma.» ");
INSERT INTO sus_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«Kɔnɔ i naxa ningee, yɛxɛɛe, nun sie xa di singee xun sara, barima e tan sɛniyɛnxi. E wuli xa kasan sɛrɛxɛbade ma, e ture xa ba sɛrɛxɛ ra. E xa gan tɛ ra Alatala bɛ. Na rafan a ma. ");
INSERT INTO sus_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","E ganyanyi nun e yirefanyi tabe findima i gbe nan na, barima e nu lintanxi n tan Alatala ya i sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","N bara nee fi i tan nun i xa die ma abadan, Isirayilaka naxan birin bama e xa sɛrɛxɛ sɛniyɛnxie ra Alatala bɛ. Saatɛ nan a ra naxan mu kanama abadan, i tan nun i bɔnsɔɛ birin bɛ Alatala ya i.» ");
INSERT INTO sus_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Alatala naxa a masen Haruna bɛ, «I mu kɛ sɔtɔma Isirayila bɔxi ma alɔ boore. N tan nan findima i kɛ ra Isirayilakae tagi. I hayi mu na sese gbɛtɛ ma.» ");
INSERT INTO sus_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«N Isirayila xa farilɛ fima Lewi bɔnsɔɛ nan ma sare ra e xa hɔrɔmɔlingira wali xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Isirayilakae naxa e maso hɔrɔmɔlingira ra sɔnɔn, alako e naxa fa yunubi sɔtɔ na kui e faxama naxan ma. ");
INSERT INTO sus_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lewi bɔnsɔɛ nan hɔrɔmɔlingira xa wali rabama. Xa yunubi yo sa mini na wali kui, e tan nan a kote tongoma. Na findima sɛriyɛ nan na wo bɛ abadan. Lewi bɔnsɔɛ mu fama kɛ sɔtɔde Isirayilakae tagi. ");
INSERT INTO sus_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","N bara Isirayilakae xa farilɛ fi Lewi bɔnsɔɛ ma kɛ ra. Na nan a toxi, n na a falaxi e xa fe ra, kɛ mu na e tan bɛ Isirayilakae tagi.» ");
INSERT INTO sus_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«A fala Lewi bɔnsɔɛ bɛ, ‹Isirayilakae na fa e xa farilɛ ra, n naxan fima wo ma, wo xa na farilɛ xa farilɛ ba n tan bɛ. ");
INSERT INTO sus_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Na kui wo fan a rabama nɛ alɔ wo ngaxakerenyi naxee farilɛ bama e xa sansi xɔri ra lonyi yire, xa na mu a ra e xa wɛni ra e a bunduma tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Wo xa wo xa hadiya ba n bɛ Isirayilakae xa farilɛ ra, wo fa a so Haruna sɛrɛxɛdubɛ yi ra. ");
INSERT INTO sus_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Wo xa farilɛ ba n bɛ hadiya ra wo naxan birin sɔtɔma. Wo xa daxamui singee wo naxee sɔtɔma, wo xa n gbe ba na ra.› ");
INSERT INTO sus_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","I man xa a fala e bɛ, ‹Wo na gɛ daxamui fisamante bade n bɛ, wo xa na farilɛ ba sansi xɔri nun wɛni ra Lewi bɔnsɔɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Wo tan nun wo xa denbayae nɔma na donde wo wama a xɔn dɛnnaxɛ. Wo xa hɔrɔmɔlingira wali sare nan na ki. ");
INSERT INTO sus_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Daxamui singee bafe mu findima yunubi ra wo bɛ. Wo mu Isirayilakae xa hadiya sɛniyɛnxie maberema na kui, wo man mu faxama na xa fe ra.›» ");
INSERT INTO sus_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Alatala naxa a masen Munsa nun Haruna bɛ, ");
INSERT INTO sus_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Ala xa sɛriyɛ nan ya. Isirayilakae xa fa ninge ginɛ gbeeli ra, naxan mu mabɛnxi, lanyuru mu na naxan ma, a nun naxan mu sari bɛndunxi sinden. ");
INSERT INTO sus_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","I xa na so Eleyasari sɛrɛxɛdubɛ yi ra, a kɔn fa raxaba a ya xɔri yonkinde fari ma. ");
INSERT INTO sus_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleyasari xa a wuli nde kasan a bɛlɛxɛsole ra hɔrɔmɔlingira sode mabiri sanmaya solofere. ");
INSERT INTO sus_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","E xa na ninge gundi birin gan a ya xɔri, a kiri, a sube, a wuli, nun a ɲaɲɛ. ");
INSERT INTO sus_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Na ninge na ganfe tɛmui naxɛ, sɛrɛxɛdubɛ xa sɛdiri wuri nde, hisopi, nun gɛsɛ gbeeli woli tɛ xɔɔra.» ");
INSERT INTO sus_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","«Na dangi xanbi, sɛrɛxɛdubɛ xa a fate nun a xa sosee maxa, a fa so yonkin yire, kɔnɔ a mu sɛniyɛnxi han nunmare. ");
INSERT INTO sus_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Naxan bara ninge gan, na fan xa a fate nun a xa sosee maxa, kɔnɔ a mu sɛniyɛnxi han nunmare. ");
INSERT INTO sus_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Mixi sɛniyɛnxi nde xa na ninge ganxi xube makɔ, a sa e sa yire sɛniyɛnxi yonkinde fari ma. A ragatama mɛnni nɛ Isirayila ɲama bɛ alako e xa marasɛniyɛn yɛ yailan a ra. Yunubi xafari sɛrɛxɛ nan a ra. ");
INSERT INTO sus_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Naxan bara na ninge ganxi xube makɔ, na fan xa a fate nun a xa dugie xa, kɔnɔ a mu sɛniyɛnxi han nunmare. Na sɛriyɛ mu kanama abadan Isirayilakae nun e xɔɲɛe bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Naxan na din mixi faxaxi ra, na kanyi findima sɛniyɛntare nan na xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","A xa a yɛtɛ rasɛniyɛn yi marasɛniyɛn ye ra a xi saxan nde nun a xi solofere nde ma. Xa a mu a raba na xi saxan nde nun na xi solofere nde ma, a mu sɛniyɛnma. ");
INSERT INTO sus_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Xa naxan yo din mixi faxaxi fure ra, a fa lu a mu a yɛtɛ rasɛniyɛn, na kanyi xa sɛniyɛntareɲa dangima nɛ Alatala xa hɔrɔmɔlingira ma. Na kanyi xa keri Isirayilakae ya ma. Marasɛniyɛn ye to mu kasanxi a ma, a mu sɛniyɛnxi.» ");
INSERT INTO sus_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Sɛriyɛ nan ya: Xa mixi faxa kiri banxi nde kui, mixi yo naxan na naa, xa na mu a ra a soma naa, na kanyi findima mixi sɛniyɛntare nan na xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Sesase rabixi birin findima se sɛniyɛntare ra. ");
INSERT INTO sus_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Mixi naxan din mixi faxaxi ra wula i, naxan bara faxa a ɲaaxi ra, xa na mu a faxa a yɛtɛ ma, na kanyi findima sɛniyɛntare nan na xi solofere bun ma. Naxan din mixi faxaxi xɔrie ra, xa na mu a gaburi ra, na fan mu sɛniyɛnxi xi solofere bun ma.» ");
INSERT INTO sus_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«A lanma na mixi mɔɔli xa sɛniyɛn ye ra, naxan masunbuxi na ninge ganxi xube ra. Na ye xa tongo dulonyi yire, xa na mu a ra xure. ");
INSERT INTO sus_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Xɛmɛ sɛniyɛnxi nde xa hisopi wuri salonyi tongo, a a rasin na ye xɔɔra, a a kasan na kiri banxi ma, a kui se birin ma, nun mixie ma naxee nu na a kui. E man xa na raba mixi ra naxan dinxi mixi fure ra, naxan faxa a ɲaaxi ra, xa na mu a ra naxan faxa a yɛtɛ ma, a nun mixi naxan dinxi mixi xɔrie ra, xa na mu gaburi ra. ");
INSERT INTO sus_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mixi sɛniyɛnxi xa na ye kasan mixi sɛniyɛntare ma a xi saxan nde nun a xi solofere nde. A na gɛ na ra, a xa a yɛtɛ nun a xa sosee maxa ye ra, a fa findi mixi sɛniyɛnxi ra na xi solofere nunmare ra.» ");
INSERT INTO sus_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Mixi naxan tondi a yɛtɛ rasɛniyɛnde, na kanyi xa keri ɲama ya ma, barima a xa sɛniyɛntareɲa dangima nɛ Alatala xa hɔrɔmɔlingira ma. A to mu kasanxi marasɛniyɛn ye ra, a mu sɛniyɛnxi. ");
INSERT INTO sus_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Yaamari nan na ki Isirayilakae bɛ naxan mu kanama abadan.» «Marasɛniyɛn ye kasanma naxan ma, na kanyi xa a xa dugie xa. A mu sɛniyɛnma fo nunmare. ");
INSERT INTO sus_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Mixi sɛniyɛntare dinma se naxan na, na se bara findi se sɛniyɛntare ra. Mixi naxan dinma na se ra, na fan findima mixi sɛniyɛntare nan na han nunmare.» ");
INSERT INTO sus_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Kike singe, Isirayila ɲama birin naxa so Sini gbengberenyi ma, e yonkin Kadesi. Mariyama naxa faxa mɛnni, e fa a ragata gaburi kui. ");
INSERT INTO sus_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ye to mu nu na ɲama yi ra, e naxa e malan Munsa nun Haruna xili ma. ");
INSERT INTO sus_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","E naxa sɔnxɔ Munsa ra, e nu a fala, «A nu fisa muxu fan xa faxa Alatala muxu ngaxakerenyie faxa tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Munfe ra wo Alatala xa ɲama rafaxi yi gbengberenyi ma, muxu nun muxu xa xurusee xa faxa? ");
INSERT INTO sus_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Munfe ra wo muxu raminixi Misira bɔxi ra fafe ra yi yire ɲaaxi, xɔrɛ bili, wɛni bili, girenadi wuri bili mu na dɛnnaxɛ. Hali ye min daaxi mu sɔtɔma be.» ");
INSERT INTO sus_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Munsa nun Haruna naxa keli ɲama ya ma, e e felen hɔrɔmɔlingira sode dɛ ra. Alatala xa nɔrɛ naxa mini e ma. ");
INSERT INTO sus_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«I xa yisuxuwuri tongo. I tan nun i taara Haruna, wo xa Isirayilaka birin malan, wo wɔyɛn fanye ra e ya xɔri, alako a xa ye ramini. Wo ye raminima nɛ Isirayila ɲama bɛ alako e tan nun e xa xurusee xa ye min.» ");
INSERT INTO sus_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Munsa naxa a xa yisuxuwuri tongo naxan nu na hɔrɔmɔlingira kui, alɔ Alatala a yamari a bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Munsa nun Haruna naxa ɲama malan na fanye ya ra, e fa a fala e bɛ, «Wo tuli mati, wo tan matandilae. Muxu xa ye ramini wo bɛ yi fanye kui?» ");
INSERT INTO sus_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Munsa naxa a bɛlɛxɛ ite, a fanye bɔnbɔ sanya firin a xa yisuxuwuri ra. Ye naxa gbusan fanye ra, ɲama nun xuruse birin naxa e min. ");
INSERT INTO sus_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kɔnɔ Alatala naxa a masen Munsa nun Haruna bɛ, «Wo to mu laxi n na, Isirayila ɲama ya xɔri, wo xa binyɛ ti n tan Sɛniyɛntɔɛ ma, wo tan mu fama yi ɲama rasode na bɔxi ma n dɛnnaxɛ fixi e ma.» ");
INSERT INTO sus_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","E mɛnni nan xili Meriba ye, barima Isirayilakae sɔnxɔ Alatala ma mɛnni nɛ, a fa a xa sɛniyɛnyi masen e bɛ. ");
INSERT INTO sus_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Munsa naxa xɛɛrae xɛɛ Edon mangɛ ma keli Kadesi, a falafe ra a bɛ, «I ngaxakerenyi Isirayilakae xui nan ya! I a kolon muxu tɔɔrɔxi ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Muxu benbae goro nɛ Misira, muxu naxa ɲɛ wuyaxi raba mɛnni. Kɔnɔ Misirakae naxa muxu nun muxu benbae ɲaxankata. ");
INSERT INTO sus_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Muxu naxa Alatala maxandi, a fa muxu xui ramɛ. A naxa a xa malekɛ xɛɛ muxu raminide Misira. Yakɔsi muxu na be Kadesi naxan na wo xa naaninyi ra. ");
INSERT INTO sus_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","A lu muxu xa dangi wo xa bɔxi tagi. Muxu mu wo xa xɛe nun wo xa wɛni bilie kanama. Muxu mu ye bama wo xa kɔlɔnyie kui. Muxu mu sigama kɔɔla ma, muxu mu fama yirefanyi ma. Muxu tima wo xa kira xungbe kerenyi nan xɔn, han muxu dangima wo xa bɔxi ra tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edon mangɛ naxa a yaabi, «Wo mu dangima muxu xa bɔxi ra fefe ma, xa na mu muxu wo gerema santidɛgɛma nan na.» ");
INSERT INTO sus_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isirayilakae man naxa a fala a bɛ, «Muxu tan dangima nɛ kira xɔn. Xa muxu nun muxu xa xurusee wo xa ye nde min, muxu xa a sare fi. Muxu mu i maxɔrinxi sese ma, muxu wama dangife nɛ tun.» ");
INSERT INTO sus_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edon mangɛ man naxa a yaabi, «Wo mu dangima feo!» Na kui, a naxa a xa sɔɔrie ramini a sɛnbɛ ki ma Isirayilakae ya ra. ");
INSERT INTO sus_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edon mangɛ to tondi Isirayilakae xa dangi a xa bɔxi ra, Isirayila naxa gbilen. ");
INSERT INTO sus_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isirayila ɲama naxa keli Kadesi, e naxa siga Horo geya yire. ");
INSERT INTO sus_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Alatala naxa a fala Munsa nun Haruna bɛ Horo geya yire, Edon xa bɔxi naaninyi ra, ");
INSERT INTO sus_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Haruna fama nɛ a benbae lide aligiyama. A mu soma na bɔxi ma n dɛnnaxɛ fixi Isirayilakae ma, barima wo bara n ma yaamari matandi Meriba ye xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","I xa Haruna nun a xa di xɛmɛ Eleyasari xanin Horo geya fari. ");
INSERT INTO sus_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mɛnni i xa sɛrɛxɛdubɛ dugie ba Haruna ma, i e ragoro a xa di xɛmɛ Eleyasari ma. Haruna laaxirama nɛ mɛnni, a fa a benbae yire li.» ");
INSERT INTO sus_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Munsa naxa a raba, alɔ Alatala a yamari ki naxɛ. E naxa te Horo geya fari Isirayilaka birin ya xɔri. ");
INSERT INTO sus_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Munsa naxa Haruna xa donmae ba a ma, a e ragoro a xa di xɛmɛ Eleyasari ma. Haruna naxa laaxira geya fari. Munsa nun Eleyasari naxa goro geya ra, ");
INSERT INTO sus_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","e fa Isirayila ɲama rakolon Haruna faxa fe ra. Isirayila naxa a ɲɔn fe raba xi tongo saxan bun ma. ");
INSERT INTO sus_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Aradi mangɛ Kanaanka, naxan nu sabatixi Negewi bɔxi ma, a to a mɛ, a Isirayila nu minife Atarima kira nan na, a naxa e gere, a ndee findi geelimanie ra. ");
INSERT INTO sus_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Na kui Isirayila naxa yi laayidi tongo Alatala bɛ, «Xa i yi mixie sa muxu sagoe, muxu e xa taa birin kanama nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Alatala naxa tin Isirayilakae xa laayidi ra, a naxa Kanaankae sa e sagoe. Isirayilakae naxa e sɔntɔ, e e xa taae kana. Na nan a toxi e naxa mɛnni xili sa Horoma, naxan wama a falafe «gbaloe.» ");
INSERT INTO sus_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isirayilakae naxa keli Horo geya ma Xulunyumi Baa kira xɔn ma, alako e xa Edon bɔxi mabilin. Kɔnɔ limaniya naxa ba e yi ra, ");
INSERT INTO sus_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","e fa a fala Alatala nun Munsa bɛ, «Munfe ra wo muxu raminixi Misira bɔxi ra, alako muxu xa fa faxa gbengberenyi ma? Taami mu na be, ye mu na be, fo yi donse ɲaaxi naxan goroma koore ma!» ");
INSERT INTO sus_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Na kui Alatala naxa a niya bɔximasee xa mini e tagi, e xa mixie xin, e mixi gbegbe faxa. ");
INSERT INTO sus_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ɲama naxa a fala Munsa bɛ, «Muxu bara yunubi raba wɔyɛnfe ra i tan nun Alatala ma. I xa Alatala maxandi muxu bɛ, a xa yi bɔximasee makuya muxu ra.» Munsa naxa tin na ra, a Alatala maxandi ɲama bɛ. ");
INSERT INTO sus_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Alatala naxa a yaabi, «Bɔximase misaali rafala wure gbeeli ra, a gbaku wuri kuye ra. Mixi xinxi naxan a ya tima na ra, a mu faxama.» ");
INSERT INTO sus_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Munsa naxa bɔximase yailan wure gbeeli ra, a a gbaku wuri kuye ra. Na tɛmui bɔximasee mixi naxee xinxi, e nu nɔma e ya tide na ra, e kisi. ");
INSERT INTO sus_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isirayilakae naxa siga, e sa yonkin Oboti. ");
INSERT INTO sus_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","E naxa keli mɛnni, e siga Iye Abarimi gbengberenyi ma naxan ya rafindixi Mowaba bɔxi ma, sogetede mabiri. ");
INSERT INTO sus_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","E to keli mɛnni, e naxa siga Serede gulunba yire. ");
INSERT INTO sus_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","E to keli mɛnni, e naxa siga Arinon dɛ ra, xure naxan na Amori bɔxi ma. Arinon nan na naaninyi ra Mowabakae nun Amorikae tagi. ");
INSERT INTO sus_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Na nan a ra, a sɛbɛxi sɛbɛli nde kui, Alatala xa geree xa fe na naxan kui, «Wahebi nun a xa gulunbae na Sufa bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Arinon gulunbae gexi han Ari, a findi Mowaba naaninyi nan na.» ");
INSERT INTO sus_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","E to keli, e naxa siga Beeri, Alatala a masen Munsa bɛ dɛnnaxɛ, «Ɲama malan, n xa e ki ye ra.» ");
INSERT INTO sus_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Isirayilakae yi suuki ba na waxati nɛ: «Ye xa te kɔlɔnyi ra! Wo xa bɛɛti ba a xa fe ra! ");
INSERT INTO sus_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Mangɛe nun kuntigie bara a ge, mangɛ tɔnxuma kanyie.» ");
INSERT INTO sus_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","E to keli gbengberenyi ma, e naxa siga Matana. E to keli Matana, e naxa siga Naxaliyɛli. E to keli Naxaliyɛli, e naxa siga Bamoti. ");
INSERT INTO sus_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","E to keli Bamoti, e naxa siga Mowaba gulunba yire, Pisiga geya na dɛnnaxɛ. Gbengberen yire birin toma nɛ na geya fari. ");
INSERT INTO sus_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isirayilakae naxa xɛɛrae xɛɛ Amorikae xa mangɛ Sixɔn yire a falafe ra, ");
INSERT INTO sus_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Muxu wama girife i xa bɔxi nan ma. Muxu mu xɛ yire nun wɛni bogi yire lima. Muxu mu wo xa kɔlɔn ye minma. Muxu luma mangɛ xa kira gbansan nan xɔn ma, han muxu i xa bɔxi igiri.» ");
INSERT INTO sus_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sixɔn mu tin e xa dangi a xa bɔxi ma. A naxa a xa sɔɔrie malan, e naxa mini Isirayilakae xili ma gbengberenyi ma, e fa e gere Yahasi. ");
INSERT INTO sus_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isirayilakae naxa geeni. E naxa e xa bɔxi birin tongo keli Arinon xure ma han Yaboko xure, han Amonikae xa bɔxi naaninyi ra. E mu nɔ dangide na ra barima Amonikae sɛnbɛ nu gbo. ");
INSERT INTO sus_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Kɔnɔ Isirayilakae naxa Amorikae xa taae birin suxu, e fa sabati nee kui. E naxa Xɛsibɔn fan suxu, a nun a xa rabilinyi. ");
INSERT INTO sus_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Xɛsibɔn nan nu na Amorikae xa mangɛ Sixɔn xa mangataa ra. A nu bara na taa ba Mowaba mangɛ nde yi, a nun a xa bɔxi birin han Arinon xure. ");
INSERT INTO sus_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Na nan a ra, bɛɛtibae a falama, «Wo fa Xɛsibɔn! Sixɔn xa taa xa ti, a man xa sɛnbɛ sɔtɔ! ");
INSERT INTO sus_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tɛ bara Xɛsibɔn gan, Sixɔn xa taa bara kana tɛ ra. Mowaba bɔxi xa taa Ari fan bara gan, naxan xa mixie nu nɔma Arinon tode. ");
INSERT INTO sus_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ɲaxankatɛ na wo bɛ Mowabakae, wo tan Kemosi xa batulae. A xa di xɛmɛe bara e gi. A xa di ginɛe bara findi geelimanie ra Amori mangɛ Sixɔn xɔnyi. ");
INSERT INTO sus_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Kɔnɔ muxu bara nɔ e ra, Xɛsibɔn bara kana han Dibon. Muxu bara e halaki han Nofa, han a sa Medeba li.» ");
INSERT INTO sus_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Isirayila naxa sabati Amorikae xa bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Munsa to gɛ Yaasɛri taa rabɛnde, Isirayila naxa Amorikae keri na longori birin ma. ");
INSERT INTO sus_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Na dangi xanbi, e naxa kira tongo sigafe ra Basan. Basan mangɛ Ogo nun a xa sɔɔrie naxa e li Edereyi. ");
INSERT INTO sus_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Alatala naxa a masen Munsa bɛ, «I naxa gaaxu a ya ra! N na sama nɛ i bɛlɛxɛ, a nun a xa sɔɔrie nun a xa bɔxi birin. I xa a bɔnbɔ alɔ i Amori mangɛ Sixɔn bɔnbɔxi ki naxɛ Xɛsibɔn.» ");
INSERT INTO sus_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Isirayilakae naxa Ogo, a xa die, nun a xa sɔɔri birin bɔnbɔ. Mixi keren mu nɔ a bade e yi. E naxa a xa bɔxi findi e gbe ra. ");
INSERT INTO sus_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isirayilakae naxa siga e sa yonkin Mowaba fiili ma, Yurudɛn xure dɛ, Yeriko ya tagi. ");
INSERT INTO sus_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Siporo xa di xɛmɛ Balaki nu bara a mɛ Isirayilakae naxan nabaxi Amorikae ra. ");
INSERT INTO sus_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mowabakae nu bara gaaxu Isirayila ɲama belebele xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Na kui, e naxa a fala Madiyan kuntigie bɛ, «Yi ɲama belebele fama won ma bɔxi birin xun nakanade, alɔ ningee mɛrɛ xun nakanama ki naxɛ.» Balaki nan nu na Mowaba mangɛ ra na tɛmui. ");
INSERT INTO sus_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","A naxa xɛɛrae xɛɛ Beyori xa di xɛmɛ Balami yire, naxan nu sabatixi Petori, a bari taa xure dɛ ra, a falafe ra, «Ɲama belebele nde bara keli Misira bɔxi ma, e fa yonkin n ma bɔxi sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Yandi, i xa fa yi ɲama dankade, barima e sɛnbɛ gbo n bɛ. Tɛmunde, na ki n nɔma nɛ e bɔnbɔde, n e keri yi bɔxi ma. N a kolon, i na duba naxan bɛ, na bara baraka. I man na naxan danka, na fan bara danka.» ");
INSERT INTO sus_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mowaba kuntigie nun Madiyan kuntigie naxa siga se matoe sare ra Balami xɔn, e fa Balaki xa xɛɛraya iba a bɛ. ");
INSERT INTO sus_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balami naxa a fala e bɛ, «Wo xa kɔɛ radangi be. Alatala na yaabi so n yi, n na falama nɛ wo bɛ.» Na kui, Mowaba kuntigie naxa xi Balami xɔnyi. ");
INSERT INTO sus_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Alatala naxa mini Balami ma, a a maxɔrin, «Nde na yi mixie ra i naxee rasɛnɛxi i xɔnyi yi ki?» ");
INSERT INTO sus_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balami naxa a yaabi, «Mowaba mangɛ Siporo xa di xɛmɛ Balaki nan yi mixie xɛɛ, a e xa fa a fala n bɛ, ");
INSERT INTO sus_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Ɲama belebele nde bara keli Misira bɔxi ma, e fa sabati n ma bɔxi sɛɛti ma. I xa fa yi ɲama danka, alako n xa nɔ e keride.›» ");
INSERT INTO sus_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Alatala naxa a masen Balami bɛ, «I naxa bira yi mixie fɔxɔ ra, i naxa na ɲama danka. Barakatɔɛ ɲama na a ra.» ");
INSERT INTO sus_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Na kuye iba Balami naxa keli, a a fala Balaki xa kuntigie bɛ, «Wo gbilen wo xa bɔxi ma, barima Alatala mu tinxi n xa bira wo fɔxɔ ra.» ");
INSERT INTO sus_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Na kui, Mowaba kuntigie naxa gbilen Balaki yire, e a fala a bɛ, «Balami bara tondi birade muxu fɔxɔ ra.» ");
INSERT INTO sus_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki man naxa kuntigi gbegbe gbɛtɛ xɛɛ, naxee tide dangi a singee ra. ");
INSERT INTO sus_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","E naxa siga Balami yire, e a fala a bɛ, «Balaki xa masenyi nan ya: ‹N tan Siporo xa di xɛmɛ Balaki, n bara i mayandi, i naxa tondi talufe ra n yire! ");
INSERT INTO sus_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","N i sare fima nɛ a fanyi ra. I wama naxan yo xɔn, n na fima nɛ i ma. Yandi i xa yi ɲama danka n bɛ.›» ");
INSERT INTO sus_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Kɔnɔ Balami naxa Balaki xa xɛɛrae yaabi, «Hali Balaki a xa banxi rafe gbeti nun xɛɛma ra, a a so n yi ra, n mu nɔma fefe rabade n Marigi Alatala mu n yamari naxan na. ");
INSERT INTO sus_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Wo naxan nabama, wo fan xa lu be han tina gɛɛsɛgɛ. N man xa Alatala xa masenyi ramɛ.» ");
INSERT INTO sus_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Alatala naxa mini Balami ma kɔɛ ra, a a masen a bɛ, «Yi mixie to bara fa i xilide, i xa bira e fɔxɔ ra, kɔnɔ n na naxan fala i bɛ, i na nan nabama.» ");
INSERT INTO sus_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na kuye iba Balami naxa baki a xa sofale fari, a bira Mowaba kuntigie fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balami sigafe naxa Alatala raxɔnɔ. Alatala xa malekɛ naxa siga kira ibolonde Balami ya ra. A nu dɔxɔxi a xa sofale fari, a xa walikɛ firinyie nu na a fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Balami xa sofale to Alatala xa malekɛ to kira tagi, santidɛgɛma suxuxi a yi, a raminixi a tɛ i, a naxa keli kira xɔn ma, a so xɛ ra. Balami naxa sofale bɔnbɔ, alako a xa a xun ti kira ra. ");
INSERT INTO sus_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Alatala xa malekɛ man naxa sa ti e xa kira di xɔn ma wɛni bilie tɛtɛ firinyie tagi. ");
INSERT INTO sus_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Sofale to Alatala xa malekɛ to, a naxa a raxɛtɛn tɛtɛ ra, a Balami sanyi xɛtɛn tɛtɛ ra a ɲaaxi ra. Balami naxa gbilen a bɔnbɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Alatala xa malekɛ man naxa sa ti yire raxɛtɛnxi a fanyi ra. Dangide yo mu nu na. ");
INSERT INTO sus_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Sofale to Alatala xa malekɛ to, a naxa a sa Balami bun ma. Balami naxa xɔnɔ a ma, a a bɔnbɔ a xa yisuxuwuri ra. ");
INSERT INTO sus_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Na kui, Alatala naxa sofale dɛ ramini, a a niya a xa a fala Balami bɛ, «A saxan nde nan yi ki i n bɔnbɔma. N munse rabaxi i ra?» ");
INSERT INTO sus_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balami naxa a yaabi, «I n matandixi nɛ. Xa santidɛgɛma na n yi ra nu, n i faxama nɛ keren na.» ");
INSERT INTO sus_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Sofale naxa a fala Balami bɛ, «N tan xa mu i xa sofale ra, i tema naxan fari tɛmui birin? N darixi yi mɔɔli raba ra?» Balami naxa a yaabi, «Ade.» ");
INSERT INTO sus_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Na tɛmui Alatala naxa Balami ya rabi malekɛ tofe ra, a tixi kira tagi, a xa santidɛgɛma baxi a tɛ i, a suxuxi a bɛlɛxɛ. Balami naxa a felen, a suyidi keren na. ");
INSERT INTO sus_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malekɛ naxa a maxɔrin, «Munfe ra i bara i xa sofale bɔnbɔ sanya saxan? N faxi nɛ n xa kira ibolon i ya ra, barima i na kira naxan xɔn yi ki, murutɛla xa kira na a ra. ");
INSERT INTO sus_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","I xa sofale bara i ratanga n ma sanya saxan. Xa a tan mu a ra nu, n bara i faxa nu, kɔnɔ n mu a tan faxama.» ");
INSERT INTO sus_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balami naxa a fala a bɛ, «N bara yunubi raba! N mu nu a kolonxi, i tixi n ya ra. Kɔnɔ yakɔsi, xa yi biyaasi mu i kɛnɛnxi, n xa gbilen n xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Alatala xa malekɛ naxa a masen, «Ade, i xa bira yi mixie fɔxɔ ra, kɔnɔ n na masenyi naxan masen i bɛ, i na nan falama.» Na kui, Balami nun Balaki xa xɛɛrae naxa siga. ");
INSERT INTO sus_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki to a mɛ a Balami na fafe, a naxa siga a ralande taa nde ma Arinon xure dɛ ra, Mowaba xa naaninyi yire. ");
INSERT INTO sus_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","A naxa Balami maxɔrin, «Munfe ra i mu fa n ma xɛɛraya singe xili ma? I ɲɔxɔ a ma n mu nɔma i sare fide?» ");
INSERT INTO sus_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balami naxa Balaki yaabi, «N bara fa i xɔn, kɔnɔ n mu nɔma wɔyɛnde na ki tun. Alatala masenyi naxan sama n dɛ i, n na nan tun falama.» ");
INSERT INTO sus_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balami nun Balaki naxa siga, e so Kiriyati Xusoti. ");
INSERT INTO sus_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki naxa ningee nun yɛxɛɛe ba sɛrɛxɛ ra, a nde so Balami yi ra a nun kuntigi naxee nu na a fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Na kuye iba, Balaki naxa Balami xanin Bamoti Baali geya fari. Mɛnni a naxa Isirayila ɲama sɛɛti nde to. ");
INSERT INTO sus_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balami naxa a fala Balaki bɛ, «I xa sɛrɛxɛbade solofere yailan be. I man xa fa tuura solofere nun yɛxɛɛ kontonyi solofere ra.» ");
INSERT INTO sus_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balami naxan maxɔrin, Balaki naxa a birin naba. E naxa tuura keren nun yɛxɛɛ kontonyi keren ba sɛrɛxɛ ra na sɛrɛxɛbade keren keren ma. ");
INSERT INTO sus_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balami naxa a fala Balaki bɛ, «I xa lu be sɛrɛxɛ fɛ ma, n tan xa n makuya dondoronti. Tɛmunde Alatala fama minide n ma. A naxan yo masen n bɛ, n a falama i bɛ.» Balami to te geya nde fari, ");
INSERT INTO sus_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Alatala naxa mini a ma. Balami naxa a fala a bɛ, «N bara sɛrɛxɛbade solofere yailan, n yɛxɛɛ kontonyi keren nun tuura keren nan baxi a birin keren keren fari.» ");
INSERT INTO sus_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Alatala naxa masenyi fi Balami ma a naxan masenma. A naxa a yita a bɛ, «Siga Balaki yire, i xa yi masenyi ti a bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balami naxa gbilen Balaki yire, a a li a tixi a xa sɛrɛxɛ fɛ ma, a tan nun Mowaba kuntigie. ");
INSERT INTO sus_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balami naxa a xa masenyi ti yi ki, «Balaki nan faxi n na kelife Siriya. Mowaba mangɛ nan n xilixi, kelife sogetede geyae kɔn na. ‹Fa, Yaxuba bɔnsɔɛ danka n bɛ! I xa xɔnɛ radin Isirayila ma!› ");
INSERT INTO sus_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","N nɔma mixi dankade di, Alatala mu naxan dankaxi? N nɔma xɔnɔde mixi ma di, Ala mu xɔnɔxi naxan ma? ");
INSERT INTO sus_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","N e toma kelife geya kɔn na, keli yire itexi. Ɲama nan a ra, naxan luma a xati ma, naxan tagi rasama e nun si gbɛtɛe ra. ");
INSERT INTO sus_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Nde nɔma Yaxuba bɔnsɔɛ kɔntide, kɔnti naxan dangima mɛyɛnyi kɔnti ra? E nu Isirayila ɲama itaxun dɔxɔde naani ra, nde nɔma a sɛɛti keren yati kɔntide? Ala xa n mali n xa aligiyama li tinxinyi kui. Ala xa n mali n xa maniya e ra n ma saya kui.» ");
INSERT INTO sus_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki naxa a fala Balami bɛ, «I munse rabaxi n na yi ki? N i rafaxi nɛ n yaxuie dankade, kɔnɔ i tan na dubafe e bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balami naxa a yaabi, «Alatala na masenyi naxan sa n dɛ i, n mu lan n xa na fala?» ");
INSERT INTO sus_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki man naxa a fala a bɛ, «Won xa siga yire gbɛtɛ, i nɔma e tode dɛnnaxɛ. I sɛɛti keren nan gbansan toma be, i mu e birin toma. Mɛnni i nɔma e birin tode, i fa e danka.» ");
INSERT INTO sus_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","A naxa Balami xanin Sofimi, Pisiga geya fari. A naxa sɛrɛxɛbade solofere yailan mɛnni, a tuura keren nun yɛxɛɛ kontonyi keren ba sɛrɛxɛ ra na sɛrɛxɛbade keren keren ma fari. ");
INSERT INTO sus_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balami naxa a fala Balaki bɛ, «I xa lu be i xa sɛrɛxɛ fɛ ma, n tan xa n makuya dondoronti, n nun Alatala xa lu yire keren.» ");
INSERT INTO sus_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Alatala naxa mini Balami ma, a masenyi nde fi a ma, a fa a fala a bɛ, «Siga Balaki yire, i xa yi masenyi ti a bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balami naxa gbilen Balaki yire, a a li a tixi a xa sɛrɛxɛ fɛ ma, a tan nun Mowaba kuntigie. Balaki naxa a maxɔrin, «Alatala munse masenxi?» ");
INSERT INTO sus_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balami naxa yi masenyi ti a bɛ, «Balaki, keli. Siporo xa di xɛmɛ, i tuli mati. ");
INSERT INTO sus_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ala mixi mu a ra, a mu wule falama. Adamadi mu a ra, a xa a xaxili masara. A mu a xui masarama. A mu nɛɛmuma a xa saatɛ ma. A mu laayidi kanama. ");
INSERT INTO sus_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ala bara n yamari n xa duba yi ɲama bɛ. Alatala bara baraka sa e ma. N mu nɔma na masarade. ");
INSERT INTO sus_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Tɔɔrɛ mu luma Yaxuba bɔnsɔɛ ya ma. Setareɲa mu toma Isirayila. E Marigi Alatala na e fɔxɔ ra. Mangɛ xui mɛma nɛ e tagi. ");
INSERT INTO sus_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Alatala e raminixi Misira bɔxi ra, sɛnbɛ na e yi ra alɔ sɛxɛ ninge. ");
INSERT INTO sus_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Karamɔxɔ wali mu nɔma Yaxuba bɔnsɔɛ tɔɔrɔde. Sematoe mu nɔma sese rabade Isirayila xili ma. A fama falade Yaxuba nun Isirayila xa fe ra, Ala xa wali mato! ");
INSERT INTO sus_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Yi ɲama kelima alɔ yɛtɛ ginɛ, e tima alɔ yɛtɛ xɛmɛ, naxan mu a sama fo a xa sube don, a naxan faxa, fo a xa a wuli min.» ");
INSERT INTO sus_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki naxa a fala Balami bɛ, «Xa i mu wama e dankafe, hali i mu duba e bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balami naxa a yaabi, «N mu a fala i bɛ, Alatala na naxan yo masen n bɛ, n na nan falama?» ");
INSERT INTO sus_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki naxa a fala Balami bɛ, «Awa, won xa siga yire gbɛtɛ. Tɛmunde Alatala tinma i xa yi ɲama danka n bɛ mɛnni.» ");
INSERT INTO sus_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki naxa Balami xanin Peyori geya fari, gbengberenyi toma dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balami naxa a fala Balaki bɛ, «Sɛrɛxɛbade solofere ti be, i man xa fa tuura solofere nun yɛxɛɛ kontonyi solofere ra.» ");
INSERT INTO sus_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balami naxan maxɔrin, Balaki naxa a birin naba. A naxa tuura keren nun yɛxɛɛ kontonyi keren ba sɛrɛxɛ ra na sɛrɛxɛbade keren keren ma fari. ");
INSERT INTO sus_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balami to a to a Alatala nu wama baraka safe Isirayila xa fe ma, a mu karamɔxɔ wali raba alɔ a darixi a raba ra ki naxɛ. A naxa a ya rafindi gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","A to Isirayila ɲama to, e yonkinxi e bɔnsɔɛ ki ma, Ala Xaxili naxa goro a ma, ");
INSERT INTO sus_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","a fa yi masenyi ti: «N yi nan masenma, n tan Beyori xa di xɛmɛ Balami, naxan xa se igbɛma a fanyi ra, ");
INSERT INTO sus_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","naxan Ala xui ramɛma, naxan Ala Xili Xungbe Kanyi xa laamatunyi toma, naxan fahaamui sɔtɔma suyidi kui. ");
INSERT INTO sus_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yaxuba, i xa kiri banxie rayabu, Isirayila, i xa lingirae tofan. ");
INSERT INTO sus_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","E gulunba rafema, e luma alɔ laakɔɛ naxan na xure dɛ ra, alɔ wuri bilie Alatala naxee sixi ye yire. ");
INSERT INTO sus_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ye mu ɲɔnma Isirayila ɲama yi ra, tunɛ goroma e xa sansie ma a fanyi ra. E xa mangɛ sɛnbɛ gbo Agaga bɛ, Isirayila xa mangɛya xili fanyi sɔtɔma nɛ. ");
INSERT INTO sus_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ala naxa e ramini Misira bɔxi ma, e sɛnbɛ gbo alɔ sɛxɛ ninge. E e yaxuie xun nakanama nɛ, naxee e xɔri girama, e e faxama xalie ra. ");
INSERT INTO sus_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","E e malabuma nɛ alɔ yɛtɛ, nde suusama e rakelide? Baraka xa lu mixi bɛ naxan na duba wo bɛ, danka xa lu mixi bɛ naxan na wo danka!» ");
INSERT INTO sus_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Na kui Balaki naxa xɔnɔ Balami ma a ɲaaxi ra. A naxa a fala, «N i xili nɛ i xa n yaxuie danka, kɔnɔ a sanya saxan nde nan yi ki, i na dubafe e bɛ! ");
INSERT INTO sus_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Keli be keren na! Siga i xɔnyi! N nu bara laayidi tongo i bɛ wali sare xa fe ra, kɔnɔ Alatala mu tinxi i xa a sɔtɔ!» ");
INSERT INTO sus_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balami naxa a yaabi, «N mu a fala i xa xɛɛrae bɛ, ");
INSERT INTO sus_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Hali Balaki a xa banxi nan nafe gbeti nun xɛɛma ra n bɛ, n mu nɔma sese rabade Alatala mu n yamari naxan na. Alatala naxan masenma n bɛ, n nɔma gbilende na fɔxɔ ra?› ");
INSERT INTO sus_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Awa, yakɔsi, n na gbilenfe n xɔnyi, kɔnɔ i xa a kolon yi ɲama naxan nabama wo ra.» ");
INSERT INTO sus_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Na tɛmui Balami naxa yi masenyi ti a bɛ: «Beyori xa di xɛmɛ Balami xa masenyi nan ya, naxan see igbɛma a fanyi ra, ");
INSERT INTO sus_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","naxan Ala xui ramɛma, naxan Ala Xili Xungbe Kanyi xa laamatunyi toma, naxan fahaamui sɔtɔma Ala Xili Xungbe saabui ra. ");
INSERT INTO sus_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","N fe toxi naxan fama rabade yare. N fe toxi naxan makuya yakɔsi ra. Tunbui nde fama tede kelife Yaxuba xa mixie ma. Mangɛ tɔnxuma nde fama kelide Isirayila ya ma. A Mowaba xun nakanama nɛ, a Seti xa die xa fe ɲɔnma nɛ. ");
INSERT INTO sus_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edon xa fe goroma nɛ, Seyiri xa fe goroma nɛ, kɔnɔ Isirayila sɛnbɛ sɔtɔma nɛ. ");
INSERT INTO sus_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mangɛ nde kelima Yaxuba xa mixie ya ma, naxan bekae sɔntɔma.» ");
INSERT INTO sus_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balami to Amalɛkikae to, a naxa yi masenyi ti: «Amalɛki si fisamante na nu a ra, kɔnɔ a raɲɔnyi, a bɔnɔma nɛ!» ");
INSERT INTO sus_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balami to Kenikae to, a naxa yi masenyi ti: «Wo sabatide mabanbanxi, wo tɛɛ saxi fanye nan fari, ");
INSERT INTO sus_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","kɔnɔ Asuri fama nɛ wo xun nakanade, a wo findi geelimanie ra.» ");
INSERT INTO sus_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Na tɛmui a naxa a xa masenyi xun dusu: «Nde nɔma kiside Ala xa ɲaxankatɛ ma? ");
INSERT INTO sus_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kunkuie fama nɛ kelife Kitimi, e nɔma nɛ Asuri nun Xeberi ra, kɔnɔ a raɲɔnyi, e fan xun nakanama nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Na dangi xanbi, Balami naxa keli, a gbilen a xɔnyi. Balaki fan naxa keli naa. ");
INSERT INTO sus_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isirayilakae to nu yonkinxi Sitimi, e naxa so yɛnɛ rabafe Mowaba ginɛe ra. ");
INSERT INTO sus_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Na ginɛe naxa Isirayila xɛmɛe xili e xa lan e xa sɛrɛxɛe ma, naxee nu bama e xa kuyee bɛ. ");
INSERT INTO sus_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Isirayilakae to Peyori xa Bali kuye batu fɔlɔ, Alatala naxa xɔnɔ e ma. ");
INSERT INTO sus_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Alatala naxa a fala Munsa bɛ, a a xa ɲama yarerati birin gbaku wuri kɔn na a ya i, a e ya rafindi soge ma, alako a xa xɔnɛ xa gbilen Isirayila fɔxɔ ra. ");
INSERT INTO sus_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Munsa naxa Isirayila kiitisae yamari, «Wo xa mixi birin faxa, naxan bara Peyori xa Bali kuye batu!» ");
INSERT INTO sus_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","A fɛfɛ na fala, Isirayilaka nde naxa fa Madiyanka ginɛ nde ra a ngaxakerenyie ya i. Munsa nun Isirayila ɲama naxee nu na wafe hɔrɔmɔlingira sode dɛ ra, naxa na ginɛ nun na xɛmɛ to. ");
INSERT INTO sus_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Haruna xa mamadi, Eleyasari xa di xɛmɛ Finexasi sɛrɛxɛdubɛ to na ginɛ nun na xɛmɛ to, a naxa keli, a tanbɛ tongo, ");
INSERT INTO sus_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","a bira na xɛmɛ fɔxɔ ra kiri banxi kui, a sa a tan nun na ginɛ sɔxɔ a xa tanbɛ ra e furi ma keren na. Na tɛmui Alatala xa xɔnɛ naxa dan. ");
INSERT INTO sus_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mixi wulu mɔxɔɲɛn nun naani nan faxa na gbaloe kui. ");
INSERT INTO sus_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Haruna sɛrɛxɛdubɛ xa mamadi, Eleyasari xa di xɛmɛ Finexasi, bara n ma xɔnɛ ba Isirayilakae ma. N ma xanunteya n ma ɲama bɛ nu na a bɔɲɛ kui, a fa a niya a xa na raba. N tan mu Isirayila birin sɔntɔ n ma xanunteya xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","A fala Finexasi bɛ, n bara bɔɲɛsa saatɛ xiri a tan nun n tan tagi. ");
INSERT INTO sus_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Na saatɛ luma n tan nun a bɔnsɔɛ tagi, e fa findi sɛrɛxɛdubɛe ra abadan, barima n ma xanunteya nu na a bɔɲɛ kui, a man fa a niya Isirayilakae xa yunubi xa xafari.» ");
INSERT INTO sus_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isirayilaka naxan faxa e nun na Madiyan ginɛ ra, a nu xili Simiri, Salu xa di xɛmɛ. Simeyɔn bɔnsɔɛ xunyi nde nan nu a ra. ");
INSERT INTO sus_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Na ginɛ Madiyanka tan nu xili Kɔsibi, Suuru xa di ginɛ. Madiyan xabilɛ ndee xunyi nan nu a baba ra. ");
INSERT INTO sus_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Wo xa Madiyankae gere alɔ yaxuie! ");
INSERT INTO sus_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","E findixi wo bɛ yaxuie nan na Peyori kuye xa fe ra, nun e maaginɛ Kɔsibi xa fe ra. Kɔsibi findixi e xa yarerati nde xa di ginɛ nan na, ");
INSERT INTO sus_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","naxan faxa Peyori kuye xa fe kui.» ");
INSERT INTO sus_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Na gbaloe to dangi, Alatala naxa a fala Munsa nun Haruna sɛrɛxɛdubɛ xa di xɛmɛ Eleyasari bɛ, ");
INSERT INTO sus_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Wo xa Isirayila ɲama birin xili sɛbɛ, keli a ɲɛ mɔxɔɲɛn ma han na xanbi, a denbaya ki ma, naxan birin nɔma sɔɔriɲa rabade.» ");
INSERT INTO sus_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Munsa nun Eleyasari sɛrɛxɛdubɛ naxa a fala Isirayilakae bɛ Mowaba bɔxi ma Yurudɛn xure sɛɛti ma Yeriko ya i, ");
INSERT INTO sus_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Isirayilaka birin xa kɔnti, keli mixi ma naxan bara ɲɛ mɔxɔɲɛn sɔtɔ han na xanbi, alɔ Alatala a yamari Munsa nun Isirayilakae bɛ ki naxɛ.» Isirayila bɔnsɔɛ naxee mini Misira bɔxi ra, nee nan yi ki. ");
INSERT INTO sus_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","A fɔlɔ Isirayila xa di singe Ruben nan ma, a xa die nan yi ki: Xanɔki, Palu, ");
INSERT INTO sus_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Xesiron, Karimi, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ruben bɔnsɔɛ xabilɛe nan na ki. Nee xasabi lan mixi wulu tongo naani nun saxan kɛmɛ solofere tongo saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu xa di xɛmɛ Eliyabi ");
INSERT INTO sus_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","nan nu na Nemuweli, Datan, nun Abirami baba ra, naxee keli Munsa nun Haruna xili ma Isirayila kuntigie ya ma. E nun Kora nun a fɔxirabirɛe to keli Alatala xili ma, ");
INSERT INTO sus_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","bɔxi rabi nɛ, a fa e birin gerun. Na lɔxɔɛ Alatala mixi kɛmɛ firin mixi tongo suuli gan nɛ tɛ ra, e xa findi misaali ra ɲama bɛ. ");
INSERT INTO sus_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kɔnɔ Kora xa die tan mu faxa na fe kui. ");
INSERT INTO sus_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeyɔn xa die nan yi ki e xabilɛ ki ma: Nemuweli, Yamin, Yakimi, ");
INSERT INTO sus_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sera, Sawulu, a nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeyɔn bɔnsɔɛ xabilɛe nan na ki. Nee xasabi lan mixi wulu mɔxɔɲɛn nun firin, mixi kɛmɛ firin nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gadi xa die nan yi ki e xabilɛ ki ma: Sefon, Xagi, Suni, ");
INSERT INTO sus_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Oseni, Eri, ");
INSERT INTO sus_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi, Areli, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gadi bɔnsɔɛ xabilɛe nan na ki. E xasabi lan mixi wulu tongo naani, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yuda xa die nan yi ki: Eru nun Onan. Kɔnɔ e tan faxa Kanaan bɔxi nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yuda xa die nan yi ki e xabilɛ ki ma: Selaha, Peresi, Sera, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peresi xa die nan yi ki: Xesiron, Xamuli, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yuda bɔnsɔɛ xabilɛe nan na ki. E xasabi lan mixi wulu tongo solofere nun senni, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakari xa die nan yi ki e xabilɛ ki ma: Tola, Puwa, ");
INSERT INTO sus_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasubu, Simiron, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isakari bɔnsɔɛe nan na ki e xabilɛ ki ma. E xasabi lan mixi wulu tongo senni nun naani, mixi kɛmɛ saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sabulon xa die nan yi ki e xabilɛ ki ma: Seredi, Elon, Yaxaleeli, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sabulon bɔnsɔɛ xabilɛe nan na ki. E xasabi lan mixi wulu tongo senni, mixi kɛmɛ suuli nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yusufu xa die nan yi ki e xabilɛ ki ma: Manasi nun Efirami. ");
INSERT INTO sus_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasi xa die nan yi ki: Makiri nun a xabilɛe. Makiri nan Galadi nun a xabilɛe sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galadi xa die nan yi ki e xabilɛ ki ma: Yeseri, Xeleki, ");
INSERT INTO sus_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asirɛli, Sikemi, ");
INSERT INTO sus_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Sɛmida, Xeferi, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Xeferi xa di xɛmɛ Selofexadi tan di ginɛe nan tun sɔtɔ. Nee xilie nan yi ki: Maxala, Nowa, Xogala, Milika nun Tirisa. ");
INSERT INTO sus_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manasi bɔnsɔɛ xabilɛe nan na ki. E xasabi lan mixi wulu tongo suuli nun firin, mixi kɛmɛ solofere nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efirami xa die nan yi ki e xabilɛ ki ma: Sutela, Bekeri, Taxani, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela xa di nan yi ki: Eran nun a xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efirami xa die nan na ki. E xasabi lan mixi wulu tongo saxan nun firin, mixi kɛmɛ suuli nan ma. Yusufu xa mamadie nan na ki e xabilɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Bunyamin xa die nan yi ki e xabilɛ ki ma: Bela, Asibeli, Axirama, ");
INSERT INTO sus_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufami, Xufami, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela xa die naxa findi Arade, Naaman, nun e xabilɛe ra. ");
INSERT INTO sus_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Bunyamin xa die nan na ki e xabilɛ ki ma. E xasabi naxa lan mixi wulu tongo naani nun mixi suuli kɛmɛ senni ma. ");
INSERT INTO sus_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dana xa die nan yi ki e xabilɛ ki ma. Suxami nun a xabilɛe. Dana bɔnsɔɛ nan na ki e xabilɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","E xasabi naxa lan mixi wulu tongo senni nun naani, mixi kɛmɛ naani ma. ");
INSERT INTO sus_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aseri xa die nan yi ki e xabilɛ ki ma: Yimena, Yisiwi, Beriya, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriya xa die nan yi ki: Xeberi, Malakiyeli, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseri xa di ginɛ nu xili nɛ Sera. ");
INSERT INTO sus_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Aserikae nan na ki e xabilɛ ki ma. E xasabi lan mixi wulu tongo suuli nun saxan, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nafatali xa die nan yi ki e xabilɛ ki ma: Yaxaseeli, Guni, ");
INSERT INTO sus_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeseri, Silemi, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Nafatali bɔnsɔɛe nan na ki e xabilɛ ki ma. E xasabi lan mixi wulu tongo naani nun suuli, mixi kɛmɛ naani nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isirayilaka kɔnti lanxi mixi wulu kɛmɛ senni nun keren, mixi kɛmɛ solofere tongo saxan nan ma. ");
INSERT INTO sus_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Kanaan bɔxi itaxunma na mixie nan ma e bɔnsɔɛ xasabi ma, a findi e kɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Bɔnsɔɛ birin kɛ sɔtɔma a xa mixie xasabi bɛrɛ nan na. Bɔnsɔɛ naxee xa mixie gbo, i nee gbe ragbo dangi booree ra, naxee xa mixi xurun. ");
INSERT INTO sus_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","N tan nan a ragirima bɔnsɔɛ birin lan a xa kɛ naxan sɔtɔ e bɔnsɔɛ xasabi ma. ");
INSERT INTO sus_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Bɔxi itaxunyi findima Ala xa maragiri nan na, bɔnsɔɛ xungbee nun bɔnsɔɛ xurie tagi.» ");
INSERT INTO sus_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lewi bɔnsɔɛ nan yi ki naxee kɔnti e xabilɛ ki ma: Gerison, Kehati, Merari, nun e xabilɛe. ");
INSERT INTO sus_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Lewi bɔnsɔɛ xabilɛe nan yi ki: Libini, Xebiron, Maxali, Musi, nun Kora. Kehati nu bara Amarama sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amarama xa ginɛ nu xili nɛ Yebedi, Lewi xa di ginɛ, naxan bari Misira. A naxa Haruna, Munsa, nun e maaginɛ Mariyama bari Amarama bɛ. ");
INSERT INTO sus_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruna nu bara Nadabo, Abihu, Eleyasari, nun Itamari sɔtɔ di ra. ");
INSERT INTO sus_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabo nun Abihu faxa nɛ, e to sɛrɛxɛ gan tɛ ra naxan mu daxa. ");
INSERT INTO sus_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Di xɛmɛ naxan kɔnti Lewi bɔnsɔɛ ya ma, keli a kike keren ma han na xanbi, a xasabi lan mixi wulu mɔxɔɲɛn nun saxan nan ma. E xa kɔnti nu na a xati ma, barima e mu bɔxi sɔtɔ kɛ ra Isirayilakae ya ma. ");
INSERT INTO sus_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Munsa nun Eleyasari sɛrɛxɛdubɛ na mixie nan kɔnti Mowaba bɔxi ma Yurudɛn xure sɛɛti ma Yeriko taa ya i, ");
INSERT INTO sus_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","kɔnɔ Munsa nun Haruna sɛrɛxɛdubɛ mixi naxee kɔnti Turusinina gbengberenyi ma, na keren mu nu na Isirayilakae ya ma sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Alatala a fala nɛ, a nee birin faxama nɛ gbengberenyi ma. Na kui, e sese mu lu duniɲa, fo Yefune xa di xɛmɛ Kalebi, nun Nunu xa di xɛmɛ Yosuwe. ");
INSERT INTO sus_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Yusufu xa di xɛmɛ Manasi, na fan xa di xɛmɛ Makiri, na fan xa di xɛmɛ Galadi, na fan xa di xɛmɛ Xeferi, na fan xa di xɛmɛ Selofexadi, di ginɛ suuli nan sɔtɔ, naxee nu xili: Maxala, Nowa, Xogala, Milika nun Tirisa. ");
INSERT INTO sus_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Na di ginɛe nan fa e yɛtɛ kan dɛntɛgɛ Munsa, Eleyasari sɛrɛxɛdubɛ, nun Isirayila yareratie bɛ, Isirayila ɲama birin ya xɔri, hɔrɔmɔlingira sode dɛ ra. E naxa a masen, ");
INSERT INTO sus_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Muxu baba mu di xɛmɛ sɔtɔ. A bara faxa gbengberenyi ma, kɔnɔ a mu nu na Kora xa mixie ya ma naxee keli Alatala xili ma. A tan faxa a yɛtɛ kan xa yunubi rabaxi nan ma. ");
INSERT INTO sus_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Munfe ra muxu baba xili bama a xabilɛ xa mixie ya ma, di xɛmɛ to mu na a bɛ? Kɛ nde so muxu fan yi ra, muxu baba ngaxakerenyie tagi!» ");
INSERT INTO sus_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Munsa naxa e xa fe dɛntɛgɛ Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Alatala naxa a masen a bɛ, ");
INSERT INTO sus_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Selofexadi xa di ginɛe bara nɔndi fala. E baba kɛ so e yi ra alɔ e baba ngaxakerenyie a sɔtɔ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","A fala Isirayilakae bɛ, ‹Xa xɛmɛ nde sa faxa di xɛmɛ xanbi, wo a kɛ so a xa di ginɛe yi ra. ");
INSERT INTO sus_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Xa di ginɛ fan mu na a bɛ, wo a kɛ so a fafaxakerenyie yi ra. ");
INSERT INTO sus_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Xa fafaxakeren yo mu na a bɛ, wo a so a baba fafaxakerenyie yi ra. ");
INSERT INTO sus_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Xa a sa li, a baba fafaxakeren yo mu na, wo a kɛ so mixi yi ra, e nun naxan makɔrɛ e boore ra a xabilɛe ya ma.› Na xa findi yaamari nun sɛriyɛ ra Isirayilakae bɛ, alɔ n tan Alatala a yamarixi i bɛ ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Alatala naxa a masen Munsa bɛ, «Te yi Abarimi geya fari, alako i xa bɔxi mato n naxan fima Isirayilakae ma. ");
INSERT INTO sus_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","I na gɛ a matode, i taa masarama nɛ, i gbilen i benbae ma alɔ i taara Haruna, ");
INSERT INTO sus_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","barima wo bara n ma yaamari matandi. Isirayilakae to keli n xili ma ye xɔli xa fe ra Kadesi, Sini gbengberenyi ma, wo mu seedeɲɔxɔya raba n ma sɛniyɛnyi xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Munsa naxa a fala Alatala bɛ, ");
INSERT INTO sus_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Alatala, daali birin Marigi Ala, mixi keren dɔxɔ ɲama xun ma, ");
INSERT INTO sus_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","naxan tima e ya ra, e mini tɛmui nun e so tɛmui, naxan e raminima, a e raso, alako i xa ɲama naxa lu alɔ xuruse naxee rabɛɲinxi e yɛtɛ ma, kantama yo mu e bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Alatala naxa a masen Munsa bɛ, «I xa Nunu xa di Yosuwe sugandi, Xaxili Sɛniyɛnxi na naxan ma. I xa i bɛlɛxɛ sa a ma. ");
INSERT INTO sus_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","I xa a ti Eleyasari sɛrɛxɛdubɛ nun ɲama birin ya xɔri, i fa yaamarie so a yi ra, ");
INSERT INTO sus_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","i xa mangɛya nde xa dangi a ma, alako Isirayila ɲama birin xa a xui suxu. ");
INSERT INTO sus_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","A tima nɛ Eleyasari sɛrɛxɛdubɛ ya i n waxɔnfe maxɔrinde gɛmɛ sugandixie ra. N yaabi naxan fima, a tan nun ɲama birin ɲɛrɛma na nan ma. E minima Eleyasari sɛrɛxɛdubɛ xui nan ma, e soma Yosuwe xui nan ma.» ");
INSERT INTO sus_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Munsa naxa Alatala xa yaamari raba. A naxa Yosuwe tongo, a sa a ti Eleyasari sɛrɛxɛdubɛ nun Isirayila ɲama ya i, ");
INSERT INTO sus_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","a a bɛlɛxɛ sa a ma, a yaamarie so a yi ra, alɔ Alatala nu bara a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Alatala naxa yi masenyi ti Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«A fala Isirayilakae bɛ, e xa n ma sɛrɛxɛ ba a ba tɛmui. Donsee nan e ra, naxee ganma, e xiri ɲɔxunmɛ te n na. ");
INSERT INTO sus_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«A fala e bɛ, ‹Lɔxɔ yo lɔxɔ wo xa sɛrɛxɛ gan daaxi ba Alatala bɛ, yɛxɛɛ firin, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Keren xa ba gɛɛsɛgɛ, boore xa ba nunmare. ");
INSERT INTO sus_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Wo man xa sansi xɔri dinxi kilo saxan ba sɛrɛxɛ ra naxan namulanxi oliwi ture fanyi litiri keren nun a tagi ra. ");
INSERT INTO sus_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Na sɛrɛxɛ gan daaxi mɔɔli nu bama n bɛ Turusinina geya ma, a xiri ɲɔxunmɛ nu tema n na. ");
INSERT INTO sus_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Wɛni sɛrɛxɛ litiri keren nun a tagi bama yɛxɛɛ sɛɛti ma Alatala bɛ. Na sɛrɛxɛ rafalama yire sɛniyɛnxi nan kui. ");
INSERT INTO sus_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Wo xa sansi xɔri dinxi sɛrɛxɛ nun wɛni sɛrɛxɛ ba nunmare tɛmui yɛxɛɛ sɛɛti ma. Na birin findima sɛrɛxɛ gan daaxi nan na naxan xiri ɲɔxunmɛ tema n tan Alatala ra.›» ");
INSERT INTO sus_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Malabui lɔxɔɛ wo xa yɛxɛɛ firin ba malabu lɔxɔɛ sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. Sansi xɔri dinxi sɛrɛxɛ naxan namulanxi ture kilo senni ra, nun wɛni sɛrɛxɛ xa ba na yɛxɛɛe sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Malabui lɔxɔɛ sɛrɛxɛ gan daaxie nan bama gɛɛsɛgɛ nun nunmare sɛrɛxɛe ra, a nun e xa wɛni sɛrɛxɛe. ");
INSERT INTO sus_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Kike xi singe birin, wo xa tuura firin ba sɛrɛxɛ gan daaxi ra, a nun yɛxɛɛ kontonyi keren, a nun yɛxɛɛ solofere, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa tuura keren yo tuura keren sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa yɛxɛɛ kontonyi keren yo yɛxɛɛ kontonyi keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa yɛxɛɛ keren yo yɛxɛɛ keren sɛɛti ma. Sɛrɛxɛ gan daaxi nan a ra naxan ganma, a xiri ɲɔxunmɛ te n tan Alatala ra. ");
INSERT INTO sus_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Wɛni litiri saxan sɛrɛxɛ xa ba tuura birin bɛ. Wɛni litiri firin sɛrɛxɛ xa ba yɛxɛɛ kontonyi birin bɛ. Wɛni litiri keren sɛrɛxɛ xa ba yɛxɛɛ birin bɛ. Na sɛrɛxɛ mɔɔli bama kike xi singe birin ɲɛ kui. ");
INSERT INTO sus_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Wo xa sikɔtɛ keren fan ba Alatala bɛ yunubi xafari sɛrɛxɛ ra, wo gɛɛsɛgɛ nun nunmare sɛrɛxɛ bama tɛmui naxɛ, a nun a xa wɛni sɛrɛxɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Kike singe xi fu nun naani nde, wo xa Sayamalekɛ Dangi Sali raba Alatala xa binyɛ bun ma. ");
INSERT INTO sus_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Na kike xi fu nun suuli nde findima sali lɔxɔɛ nan na. Wo xa taami lɛbinitare don xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Na xi singe wo xa wo malan Ala batude. Wo naxa wali yo raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Wo xa yi sɛrɛxɛ gan daaxie ba Alatala bɛ na lɔxɔɛ: tuura firin, yɛxɛɛ kontonyi keren, nun yɛxɛɛ solofere, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa tuura keren yo tuura keren sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa yɛxɛɛ kontonyi keren yo yɛxɛɛ kontonyi keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa yɛxɛɛ yo yɛxɛɛ sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Wo xa sikɔtɛ keren fan ba Alatala bɛ yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Wo xa na sɛrɛxɛe sa gɛɛsɛgɛ daaxie xun ma, naxee bama lɔxɔɛ birin. ");
INSERT INTO sus_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Wo xa nee ba xi solofere bun ma. Sɛrɛxɛ gan daaxi nan a ra naxan ganma, a xiri ɲɔxunmɛ te n tan Alatala ra. Nee bama nɛ lɔxɔ yo lɔxɔ, e nun boore sɛrɛxɛ gan daaxie, nun wɛni sɛrɛxɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","A xi solofere nde, wo xa wo malan Ala batude. Wo naxa wali gbɛtɛe raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Xɛ Xaba Sali, wo na fa sansi bogi singee sɛrɛxɛ ra Alatala xɔn ma, wo xa wo malan n batude. Wo naxa wali yo suxu na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Wo xa yi sɛrɛxɛe ba: tuura firin, yɛxɛɛ kontonyi keren, nun yɛxɛɛ solofere, naxee bara ɲɛ keren sɔtɔ. Nee nan bama sɛrɛxɛ gan daaxi ra, e xiri ɲɔxunmɛ te n tan Alatala ra. ");
INSERT INTO sus_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa tuura keren yo tuura keren sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa yɛxɛɛ kontonyi keren yo yɛxɛɛ kontonyi keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa yɛxɛɛ keren yo yɛxɛɛ keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Wo xa sikɔtɛ keren fan ba Alatala bɛ yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra. Lanyuru yo naxa lu na sɛrɛxɛe ma. ");
INSERT INTO sus_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Kike solofere nde xi singe, wo xa wo malan n batude. Wo naxa wali yo raba na lɔxɔɛ. Wo sarae fema nɛ na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Wo xa tuura firin ba sɛrɛxɛ gan daaxi ra, a nun yɛxɛɛ kontonyi keren, a nun yɛxɛɛ solofere, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa tuura keren yo tuura keren sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa yɛxɛɛ kontonyi keren yo yɛxɛɛe kontonyi keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa yɛxɛɛ keren yo yɛxɛɛ keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Wo xa sikɔtɛ keren fan ba Alatala bɛ yunubi xafari sɛrɛxɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Na sɛrɛxɛ birin sama sɛrɛxɛ gan daaxie nan xun, wo naxee bama lɔxɔ yo lɔxɔ, a nun wo naxee bama kike yo kike a xi singe, a nun sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan sama e sɛɛti ma. Sɛrɛxɛe nan e ra naxee ganma, e xiri ɲɔxunmɛ te n tan Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Na kike solofere nde, xi fu lɔxɔɛ, wo xa wo malan n batude, wo fan xa sunyi suxu. Wo naxa wali yo raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Na lɔxɔɛ wo xa tuura nde ba sɛrɛxɛ gan daaxi ra, a nun yɛxɛɛ kontonyi keren, a nun yɛxɛɛ solofere, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. ");
INSERT INTO sus_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa tuura sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa yɛxɛɛ kontonyi keren yo yɛxɛɛ kontonyi keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa yɛxɛɛ keren yo yɛxɛɛ keren sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra, dangife na yunubi xafari sɛrɛxɛ, nun na sɛrɛxɛ gan daaxie wo naxee bama lɔxɔ yo lɔxɔ, a nun sansi xɔri dinxi nun wɛni sɛrɛxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Kike solofere nde, xi fu nun suuli, wo xa wo malan n batude. Wo naxa wali yo raba na lɔxɔɛ. Wo xa sali nde raba n tan Alatala bɛ xi solofere bun ma. ");
INSERT INTO sus_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","A xi singe, wo xa tuura fu nun saxan, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ gan daaxi ra n tan Alatala bɛ, naxee bara ɲɛ keren sɔtɔ, lanyuru yo mu na naxee ma. Wo na e gan, a xiri ɲɔxunmɛ te n tan Alatala ra. ");
INSERT INTO sus_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Sansi xɔri dinxi sɛrɛxɛ kilo solomanaani naxan namulanxi ture ra, a xa sa na tuura fu nun saxan sɛɛti ma. Sansi xɔri dinxi sɛrɛxɛ kilo senni naxan namulanxi ture ra, a xa sa na yɛxɛɛ kontonyi firin sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Sansi xɔri dinxi sɛrɛxɛ kilo saxan naxan namulanxi ture ra, a xa sa na yɛxɛɛ fu nun naani sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra, dangife na yunubi xafari sɛrɛxɛ, nun na sɛrɛxɛ gan daaxie wo naxee bama lɔxɔ yo lɔxɔ, a nun sansi xɔri dinxi nun wɛni sɛrɛxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«Sali xi firin nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«Sali xi saxan nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«Sali xi naani nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«Sali xi suuli nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«Sali xi senni nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«Sali xi solofere nde, wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma, ");
INSERT INTO sus_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","a nun e xa sansi xɔri dinxi nun wɛni sɛrɛxɛ naxan lanma sɛriyɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Wo xa sikɔtɛ keren fan ba Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«Sali xi solomasaxan nde, wo xa wo malan n tan Ala batude. Wo naxa wali gbɛtɛe raba na lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Wo xa tuura fu nun firin, yɛxɛɛ kontonyi firin, nun yɛxɛɛ fu nun naani ba sɛrɛxɛ gan daaxi ra, naxee bara ɲɛ keren sɔtɔ, lanyuru mu na naxan ma. E xiri ɲɔxunmɛ tema n tan Alatala ma. ");
INSERT INTO sus_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Wo man xa sansi xɔri dinxi nun wɛni sɛrɛxɛ ba naxan lanma sɛriyɛ ki ma na tuura, na yɛxɛɛ kontonyi, nun na yɛxɛɛ xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Wo xa sikɔtɛ keren fan ba n tan Alatala bɛ yunubi xafari sɛrɛxɛ ra. Wo xa na sɛrɛxɛe sa boore sɛrɛxɛe xun, wo naxee bama lɔxɔɛ birin, e nun sansi xɔri nun wɛni naxan fan bama sɛrɛxɛ ra.» ");
INSERT INTO sus_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«Sɛrɛxɛe nan na ki wo lan wo xa naxee ba n tan Alatala bɛ wo xa sali lɔxɔɛe, bafe wo xa laayidi sɛrɛxɛe, wo xa sɛrɛxɛ ɲanigexie, wo xa sɛrɛxɛ gan daaxie, wo xa sansi xɔri dinxi sɛrɛxɛe, wo xa wɛni sɛrɛxɛe, nun wo xa xanunteya sɛrɛxɛe.» ");
INSERT INTO sus_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Munsa naxa Alatala xa yaamari birin fala Isirayilakae bɛ, a naxee so a yi ra. ");
INSERT INTO sus_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Munsa naxa yi masenyi ti Isirayila bɔnsɔɛ kuntigie bɛ, «Alatala xa yaamarie nan ya: ");
INSERT INTO sus_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Xa mixi nde sa laayidi tongo Alatala bɛ fe nde ma, xa na mu a a kali Alatala ra fe nde ma, na kanyi lan nɛ a xa a xui rakamali. A naxan birin falaxi a dɛ ra, a xa a birin naba.» ");
INSERT INTO sus_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","«Ginɛ dimɛdi na sa laayidi tongo fe nde ma Alatala bɛ, a na a baba xɔnyi tɛmui naxɛ, a fa a kali, ");
INSERT INTO sus_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","a baba naxa a kolon a a xa di ginɛ bara laayidi nde tongo, a baba mu sese fala na fe kui, a xa na laayidi rakamali. ");
INSERT INTO sus_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Kɔnɔ xa a baba mu tin na laayidi tongoxi ra a mɛ tɛmui, a mu lan na ginɛ dimɛdi xa a rakamali. Alatala mu a suxuma a ra a baba waxɔnfe xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","«Ginɛ na sa laayidi tongo, xa na mu a a kali wɔyɛnyi mafuraxi ra, ");
INSERT INTO sus_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","xa a xa mɔri sa na mɛ, a fa lu a mu sese fala na fe ra, a xa na laayidi rakamali. ");
INSERT INTO sus_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Kɔnɔ xa a xa mɔri mu tin na fe ra a mɛ tɛmui, a mu lan na ginɛ xa a rakamali. Alatala mu a suxuma a ra.» ");
INSERT INTO sus_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Kaaɲɛ ginɛ na laayidi tongo, xa na mu, ginɛ naxan nun a xa xɛmɛ bara fatan, a xa a xa laayidi rakamali.» ");
INSERT INTO sus_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","«Ginɛ xɛmɛ taa idɔxɔɛ na laayidi tongo, xa na mu a a kali fe nde ma, ");
INSERT INTO sus_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","xa a xa mɔri fa na fe kolon, kɔnɔ a mu fefe fala na fe kui, a lanma na ginɛ xa a xa laayidi rakamali. ");
INSERT INTO sus_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","A xa mɔri na a xa laayidi mɛ tɛmui naxɛ, a nɔma tinde a ra, xa na mu a ra, a nɔma tɔnyi dɔxɔde a ma. Alatala mu a suxuma a ra. ");
INSERT INTO sus_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","A xa mɔri nɔma tinde, xa na mu a ra tondide a xa laayidi nun a xa kali birin na. ");
INSERT INTO sus_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Xa a mu fefe falama na fe kui, a xa ginɛ lanma a xa a xa laayidi rakamali. A xa dundui a niyama nɛ ginɛ xa a xa laayidi rakamali. ");
INSERT INTO sus_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Xa a xa mɔri tɔnyi dɔxɔma a xa ginɛ xa laayidi ma tɛmui gbɛtɛ, a tan nan yati a xa ginɛ xa kote xaninma.» ");
INSERT INTO sus_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","«Alatala xa sɛriyɛ nan na ki a naxan fixi Munsa ma, ginɛ xa fe ra naxan na xɛmɛ taa, xa na mu a ra ginɛ naxan na a baba xɔnyi.» ");
INSERT INTO sus_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Alatala naxa yi masenyi ti Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«I xa Isirayilakae gbe ɲɔxɔ Madiyankae ma. I na gɛ na ra, i fa taa masara.» ");
INSERT INTO sus_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Munsa naxa a fala ɲama bɛ, «Xɛmɛ ndee xa geresosee tongo Madiyan xili ma wo gbe ɲɔxɔde Alatala xili ra. ");
INSERT INTO sus_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Isirayila bɔnsɔɛ birin xa mixi wulu keren keren ba geresoe ra.» ");
INSERT INTO sus_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Isirayila bɔnsɔɛ fu nun firin naxa mixi wulu keren keren ba geresoe ra. ");
INSERT INTO sus_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Munsa naxa na sɔɔri wulu fu nun firin xɛɛ gere tide. Eleyasari sɛrɛxɛdubɛ xa di xɛmɛ Finexasi naxa e mati, se sɛniyɛnxie nu na a yi ra, a nun sara naxee tɔnxuma fima e boore ma gere xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","E naxa siga gere tide Madiyan xili ma, alɔ Alatala a yamari ki naxɛ Munsa bɛ. E naxa na xɛmɛe birin faxa, ");
INSERT INTO sus_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","a nun Madiyan mangɛ suuli: Efi, Rekemi, Suuru, Xuru, nun Reba. E naxa Beyori xa di xɛmɛ Balami fan faxa santidɛgɛma ra. ");
INSERT INTO sus_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","E naxa Madiyan ginɛe nun e xa di birin findi konyie ra. E naxa e xa xurusee, e xa gɔɔrɛe, nun e harige birin tongo. ");
INSERT INTO sus_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","E naxa e xa taae nun e xa daaxae gan. ");
INSERT INTO sus_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","E naxa e xa harige, e xa xurusee, nun e xa ginɛe suxu, ");
INSERT INTO sus_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","e e xanin Munsa, Eleyasari, nun Isirayila ɲama xɔn ma e yonkinde Mowaba fiili ma, Yurudɛn xure dɛ i, Yeriko ya tagi. ");
INSERT INTO sus_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Munsa, Eleyasari sɛrɛxɛdubɛ, nun Isirayila ɲama yareratie naxa e ralan yonkinde fari ma. ");
INSERT INTO sus_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Munsa naxa xɔnɔ sɔɔri wulu xunyie nun sɔɔri kɛmɛ xunyie ma, a a fala e bɛ, ");
INSERT INTO sus_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","«Munfe ra wo mu yi ginɛe faxa? ");
INSERT INTO sus_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","E tan nan bira Balami xa marasi fɔxɔ ra, e Isirayilakae ramini Alatala xa kira xɔn Peyori, Alatala fa gbaloe ragoro a xa ɲama ma. ");
INSERT INTO sus_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Awa, yakɔsi, wo xɛmɛ dimɛ birin faxa, a nun ginɛ naxee bara xɛmɛ fe kolon. ");
INSERT INTO sus_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ginɛ dimɛdie tan, wo xa nee ragata wo yɛtɛ bɛ. ");
INSERT INTO sus_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Wo tan naxee bara mixi faxa, xa na mu wo bara din fure ra, wo xa lu yonkinde fari ma xi solofere, a nun mixie wo naxee suxu gere kui. Wo xa wo yɛtɛ nun wo xa mixi suxuxie rasɛniyɛn a xi saxan nde nun a xi solofere nde. ");
INSERT INTO sus_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Wo xa wo xa dugie fan nasɛniyɛn a nun see naxan tan birin nafalaxi kiri, si xabe, nun wuri ra.» ");
INSERT INTO sus_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleyasari sɛrɛxɛdubɛ naxa a fala sɔɔrie bɛ naxee gere tixi, «Alatala xa sɛriyɛ nan ya a naxan masenxi Munsa bɛ: ");
INSERT INTO sus_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Xɛɛma, gbeti, wure gbeeli, wure, yɔxui, nun sunbui, ");
INSERT INTO sus_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","se naxan birin mu ganma tɛ ra, wo xa a raso tɛ, a xa sɛniyɛn. Na dangi xanbi wo man xa a rasɛniyɛn ye ra. Se naxan mu nɔma rasode tɛ, wo xa na rasɛniyɛn ye ra. ");
INSERT INTO sus_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Wo xa wo xa dugie xa a xi solofere nde. Na tɛmui wo bara sɛniyɛn, wo fa nɔma sode yonkinde.» ");
INSERT INTO sus_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«I tan, Eleyasari sɛrɛxɛdubɛ, nun Isirayila kuntigie, wo xa yi mixi suxuxie, nun e xa xurusee kɔnti, wo naxee sɔtɔxi gere kui. ");
INSERT INTO sus_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","I xa e itaxun sɔɔrie nun ɲama ra. ");
INSERT INTO sus_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Sɔɔrie gbe ya ma, i xa mixi keren tongo mixi kɛmɛ suuli yo mixi kɛmɛ suuli tagi, a xa findi n gbe ra. Xurusee fan na ki, kɛmɛ suuli yo kɛmɛ suuli, i keren nan tongoma e ya ma n bɛ. A findi ningee ra, a findi sofalee ra, a findi xuruse lanmae ra. ");
INSERT INTO sus_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","I xa nee ba sɔɔrie gbe ya ma, i e fi Eleyasari sɛrɛxɛdubɛ ma Alatala xili ra. ");
INSERT INTO sus_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Isirayila ɲama gbe ya ma, i xa mixi keren tongo mixi tongo suuli yo mixi tongo suuli ya ma, kɛmɛ suuli yo kɛmɛ suuli, i keren nan tongoma e ya ma n bɛ. A findi ningee ra, a findi sofalee ra, a findi xuruse lanmae ra. I xa nee so Lewi bɔnsɔɛ yi ra, naxee e ɲɔxɔ saxi n ma hɔrɔmɔlingira xɔn.» ");
INSERT INTO sus_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Munsa nun Eleyasari sɛrɛxɛdubɛ naxa a raba, alɔ Alatala a yamari ki naxɛ Munsa bɛ. ");
INSERT INTO sus_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Naxan sɔtɔ gere kui, a xasabi lan xuruse lanma wulu kɛmɛ senni wulu tongo solofere nun suuli nan ma, ");
INSERT INTO sus_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ninge wulu tongo solofere nun firin, ");
INSERT INTO sus_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sofale wulu tongo senni nun keren, ");
INSERT INTO sus_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ginɛ naxee mu xɛmɛ fe kolon, mixi wulu tongo saxan nun firin. ");
INSERT INTO sus_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Sɛɛti naxan fixi sɔɔrie ma naxee gere ti, a xasabi naxa lan xuruse lanma wulu kɛmɛ saxan wulu tongo saxan nun solofere kɛmɛ suuli ma. ");
INSERT INTO sus_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Alatala gbe naxan ba na ra, na naxa lan xuruse lanma kɛmɛ senni tongo solofere nun suuli ma. ");
INSERT INTO sus_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ninge naxee fixi sɔɔrie ma, e xasabi naxa lan wulu tongo saxan nun senni ma. Alatala gbe naxan ba na ra, na naxa lan ninge tongo solofere nun firin ma. ");
INSERT INTO sus_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Sofale naxee fixi sɔɔrie ma, e xasabi naxa lan wulu tongo saxan kɛmɛ suuli ma. Alatala gbe naxan ba na ra, na naxa lan sofale tongo senni nun keren ma. ");
INSERT INTO sus_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Mixi naxee fixi sɔɔrie ma, e xasabi naxa lan wulu fu nun senni ma. Alatala gbe naxan ba na ra, na naxa lan mixi tongo saxan nun firin ma. ");
INSERT INTO sus_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Munsa naxa Alatala gbe fi Eleyasari sɛrɛxɛdubɛ ma, alɔ Alatala a yamari ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Isirayila ɲama gbe, Munsa naxan so e yi ra, naxan mu nu na sɔɔrie gbe ya ma, ");
INSERT INTO sus_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","na findixi xuruse lanmae wulu kɛmɛ saxan tongo saxan nun solofere kɛmɛ suuli nan ma, ");
INSERT INTO sus_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","a nun ninge wulu tongo saxan nun senni, ");
INSERT INTO sus_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","a nun sofale wulu tongo saxan kɛmɛ suuli, ");
INSERT INTO sus_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","a nun mixi wulu fu nun senni. ");
INSERT INTO sus_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Na kui, xurusee ba, mixie ba, tongo suuli yo tongo suuli, Munsa naxa keren keren ba a birin na, a e so Lewi bɔnsɔɛ yi ra, naxee e ɲɔxɔ saxi Alatala xa hɔrɔmɔlingira xɔn, alɔ Alatala a yamari a bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Sɔɔri kɛmɛ xunyie nun sɔɔri wulu xunyie naxa fa Munsa yire, ");
INSERT INTO sus_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","e a fala a bɛ, «Muxu tan i xa konyie, muxu bara sɔɔrie kɔnti naxee nu na muxu xa yaamari bun ma. E birin na na. ");
INSERT INTO sus_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Na nan a toxi muxu bara fa hadiyae ra Alatala bɛ xunsare xa fe ra. Kankan bara fa a sɔtɔsee ra alɔ bɛlɛxɛrasoe, xurundɛe, tulirasoe, nun kɔnmagore xɛɛma daaxi.» ");
INSERT INTO sus_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Munsa nun Eleyasari sɛrɛxɛdubɛ naxa na see xɛɛma daaxi rasuxu e yi ra. ");
INSERT INTO sus_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Na xɛɛma birin, sɔɔri xunyie fa naxan na Alatala bɛ, a xasabi lan fayida xɛɛma kilo kɛmɛ tongo solofere nan ma. ");
INSERT INTO sus_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Sɔɔrie tan nu e gbee ragataxi e yi ra. ");
INSERT INTO sus_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Munsa nun Eleyasari sɛrɛxɛdubɛ naxa na see birin nasuxu sɔɔri wulu xunyie nun sɔɔri kɛmɛ xunyie yi ra, e a xanin hɔrɔmɔlingira yire, alako na xa findi tɔnxuma ra Isirayila xa fe ra Alatala bɛ. ");
INSERT INTO sus_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Gɔɔrɛ gbegbe nan nu na Ruben bɔnsɔɛ nun Gadi bɔnsɔɛ yi ra. E to a to Yaasɛri nun Galadi bɔxi fan xurusee bɛ, ");
INSERT INTO sus_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","e naxa fa Munsa, Eleyasari, nun Isirayila kuntigie yire, ");
INSERT INTO sus_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","e a fala e bɛ, «Taa naxee xili Ataroti, Dibon, Yaasɛri, Nimira, Xɛsibɔn, Eleyale, Sebami, Nebo, nun Beyon, nee na bɔxi ya ma, ");
INSERT INTO sus_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Alatala naxan saxi Isirayila ɲama sagoe. Na longori fan xuruse kanyie bɛ alɔ muxu tan. ");
INSERT INTO sus_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Xa wo bara tin a ra, be xa findi muxu tan gbe ra, hali muxu mu dangi Yurudɛn naakiri ma.» ");
INSERT INTO sus_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Munsa naxa Gadi bɔnsɔɛ nun Ruben bɔnsɔɛ yaabi, «Wo ngaxakerenyie sigama nɛ gere sode, wo tan xa lu be? ");
INSERT INTO sus_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Munfe ra wo wama limaniya bafe wo ngaxakerenyie yi ra, alako e naxa dangi Yurudɛn naakiri ma bɔxi ma Alatala naxan fixi e ma? ");
INSERT INTO sus_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Wo babae fan bara na wali mɔɔli raba n to e xɛɛ Kanaan bɔxi rabɛnde kelife Kadesi Barineya. ");
INSERT INTO sus_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","E to gɛ Esekoli gulunba rabɛnde, e naxa gbilen, e fa limaniya ba Isirayilakae yi ra sofe ra bɔxi ma, Alatala naxan fixi e ma. ");
INSERT INTO sus_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Alatala naxa xɔnɔ Isirayilakae ma na lɔxɔɛ, a fa a kali, ");
INSERT INTO sus_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹Yi mixi naxan birin kelixi Misira, naxan xa simaya bara dangi ɲɛ mɔxɔɲɛn na, e mu soma bɔxi ma n nan n kali Iburahima, Isiyaga nun Yaxuba bɛ dɛnnaxan fife ra e ma, barima e mu bira n fɔxɔ ra e ɲanige birin na. ");
INSERT INTO sus_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Fo Yefune xa di xɛmɛ Kalebi Kenisika, nun Nunu xa di xɛmɛ Yosuwe, nee nan peti bira n xui fɔxɔ ra e ɲanige birin na.› ");
INSERT INTO sus_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Alatala naxa xɔnɔ Isirayilakae ma ki fanyi, a fa e rabɛɲin gbengberenyi ma ɲɛ tongo naani bun ma, han na mixi birin faxa, naxee wali ki mu nu rafan a ma. ");
INSERT INTO sus_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Wo tan yunubitɔɛ bɔnsɔɛe, wo na birafe wo benbae fɔxɔ ra Alatala raxɔnɔfe ra Isirayila xili ma. ");
INSERT INTO sus_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Xa wo keli Ala xa kira xɔn, a man Isirayila rabɛɲinma nɛ gbengberenyi ma, e halaki wo xa fe ra.» ");
INSERT INTO sus_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","E naxa siga Munsa yire, e a fala a bɛ, «Muxu wama gɔɔrɛ tife be muxu xa xurusee bɛ, a nun muxu wama yiree yailanfe be muxu xa ginɛe nun muxu xa die luma dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Kɔnɔ muxu bara tin sɔɔriɲa rabade muxu ngaxakerenyi Isirayilakae bɛ han e xa so e sode. Muxu xa die tan luma be muxu xanbi ra nɛ taa kantaxie kui, alako bekae naxa e tɔɔrɔ. ");
INSERT INTO sus_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Muxu mu gbilenma muxu xɔnyi be, fo Isirayilaka birin a gbe bɔxi masɔtɔ. ");
INSERT INTO sus_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Kɛ gbɛtɛ mu luma muxu tan bɛ sɔnɔn Yurudɛn naakiri ma. Muxu gbe na bebiri Yurudɛn sogetede nɛ.» ");
INSERT INTO sus_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Munsa naxa a fala e bɛ, «Xa wo sa a raba alɔ wo a falaxi ki naxɛ, xa wo wo maxiri sigafe ra gere tide Alatala xili ra, ");
INSERT INTO sus_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","xa wo mu gbilen be Yurudɛn naakiri ma, han Alatala gɛ a yaxuie birin keride a ya ra, ");
INSERT INTO sus_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na tɛmui be bara findi wo xa bɔxi ra Alatala xili ra. Mɛnni na lu Alatala xa yaamari bun ma, wo nɔma gbilende be. Na kui wo bara wo xa laayidi rakamali Isirayila nun Alatala bɛ.» ");
INSERT INTO sus_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","«Kɔnɔ xa wo mu sa na sɛriyɛ rabatu, na bara findi yunubi ra wo bɛ, wo na sare fima nɛ. ");
INSERT INTO sus_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Yakɔsi, wo xa taae ti wo xa ginɛe nun wo xa die bɛ. Wo xa gɔɔrɛe yailan wo xa xurusee fan bɛ. Kɔnɔ wo naxa nɛɛmu wo xa laayidi tongoxi ma de, wo xa na rakamali.» ");
INSERT INTO sus_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gadi bɔnsɔɛ nun Ruben bɔnsɔɛ naxa Munsa yaabi, «Muxu fama nɛ i xa yaamari birin suxude. ");
INSERT INTO sus_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Muxu xa die, muxu xa ginɛe, nun muxu xa xurusee birin luma be Galadi bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","kɔnɔ muxu geresosee tongoma nɛ, muxu fa gere so Alatala bɛ alɔ i a yitaxi ki naxɛ, muxu marigi.» ");
INSERT INTO sus_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Munsa naxa Eleyasari sɛrɛxɛdubɛ, Nunu xa di xɛmɛ Yosuwe, a nun Isirayila kuntigie yamari, ");
INSERT INTO sus_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«Xa Gadi bɔnsɔɛ nun Ruben bɔnsɔɛ sa dangi Yurudɛn naakiri ma, e siga gere sode Alatala bɛ, han wo naxa na bɔxi birin masɔtɔ tɛmui naxɛ, wo xa Galadi bɔxi so e yi ra kɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Kɔnɔ xa e mu na raba, e fan xa sabati wo tagi Kanaan bɔxi ma!» ");
INSERT INTO sus_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gadi bɔnsɔɛ nun Ruben bɔnsɔɛ naxa e yaabi, «Alatala naxan birin masenxi a xa konyi die xa fe ra, muxu a birin nabama nɛ. ");
INSERT INTO sus_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Muxu dangima nɛ Yurudɛn naakiri ma muxu xa geresosee ra sigafe ra Kanaan bɔxi ma Alatala ya tode ra, kɔnɔ muxu kɛ tan findima bɔxi nan na Yurudɛn bebiri sɛɛti ma.» ");
INSERT INTO sus_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Munsa naxa Amorikae xa mangɛ Sixɔn nun Basan mangɛ Ogo xa bɔxi nun na rabilinyi fi Gadi bɔnsɔɛ, Ruben bɔnsɔɛ, nun Yusufu xa di xɛmɛ Manasi bɔnsɔɛ sɛɛti keren ma. ");
INSERT INTO sus_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gadi xa die naxa gbilen Dibon ti ra, a nun Ataroti, Aroweri, ");
INSERT INTO sus_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atiroti Sofana, Yaasɛri, Yogbeha, ");
INSERT INTO sus_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beti Nimira, nun Beti Xarani. E bara findi taa makantaxie ra, gɔɔrɛe gbegbe fan nu na. ");
INSERT INTO sus_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruben bɔnsɔɛ naxa gbilen Xɛsibɔn ti ra, a nun Eleyale, Kiriyatayimi, ");
INSERT INTO sus_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baali Meyoni, nun Sibima. E naxa na taa ndee xilie masara. ");
INSERT INTO sus_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manasi xa di Makiri xa die to Galadi taa suxu, e Amorikae keri naxee nu sabatixi naa, ");
INSERT INTO sus_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Munsa naxa na taa so e yi ra sabatide ra. ");
INSERT INTO sus_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manasi xa Yayiri fan naxa taa ndee suxu, a e xili Yayiri xa taae. ");
INSERT INTO sus_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba fan naxa Kenata taa nun a rabilinyi suxu, a yɛtɛ xili sa e xun ma. ");
INSERT INTO sus_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ɲɛrɛ nan ya Isirayilakae naxan naba e xundɛ ki ma Munsa nun Haruna xa yaamari bun ma e to keli Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Munsa na birin sɛbɛxi nɛ alɔ Alatala a yamari a bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","E naxa keli Ramesesi taa Misira bɔxi kike singe xi fu nun suuli. Sayamalekɛ Dangi Sali lɔxɔɛ, na kuye iba Isirayilakae naxa mini Misira xɔrɛya kui Misiraka birin ya xɔri. ");
INSERT INTO sus_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","A a lixi na tɛmui, Misirakae nu na e xa di singee ragatafe, Alatala naxee faxa e ya ma a xa xɔnɛ kui e xa kuyee xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isirayilakae naxa keli Ramesesi, e sa yonkin Sukɔti. ");
INSERT INTO sus_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","E to keli mɛnni, e naxa siga Etama gbengberenyi dɛ ra. ");
INSERT INTO sus_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","E to keli Etama, e naxa gbilen Pi Haxirɔti mabiri, Baali Sefon ya tagi, e sa yonkin Migidoli ya ra. ");
INSERT INTO sus_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","E to keli mɛnni, e naxa baa igiri, e siga gbengberenyi ma. E naxa xi saxan ɲɛrɛ raba Etama gbengberenyi ma, e sa yonkin Mara. ");
INSERT INTO sus_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","E to keli mɛnni, e naxa siga Elimi, e dulonyi fu nun firin nun tugi tongo solofere li dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","E to keli mɛnni, e naxa siga Xulunyumi Baa sɛɛti ma. ");
INSERT INTO sus_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","E to keli mɛnni, e naxa siga Sini gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","E to keli mɛnni, e naxa sa yonkin Dofika. ");
INSERT INTO sus_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","E to keli mɛnni, e naxa siga Alusu. ");
INSERT INTO sus_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","E to keli mɛnni, e naxa siga Refidimi, kɔnɔ e mu ye to naa. ");
INSERT INTO sus_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","E to keli mɛnni, e naxa siga Turusinina gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","E to keli mɛnni, e naxa siga Kibiroti Hataawa. ");
INSERT INTO sus_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","E to keli mɛnni, e naxa siga Xaseroti. ");
INSERT INTO sus_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","E to keli mɛnni, e naxa siga Ritima. ");
INSERT INTO sus_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","E to keli mɛnni, e naxa siga Rimɔn Peresi. ");
INSERT INTO sus_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","E to keli mɛnni, e naxa siga Libina. ");
INSERT INTO sus_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","E to keli mɛnni, e naxa siga Risa. ");
INSERT INTO sus_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","E to keli mɛnni, e naxa siga Kehelata. ");
INSERT INTO sus_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","E to keli mɛnni, e naxa siga Seeferi geya ma. ");
INSERT INTO sus_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","E to keli mɛnni, e naxa siga Xarada. ");
INSERT INTO sus_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","E to keli mɛnni, e naxa siga Makeloti. ");
INSERT INTO sus_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","E to keli mɛnni, e naxa siga Taxati. ");
INSERT INTO sus_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","E to keli mɛnni, e naxa siga Tera. ");
INSERT INTO sus_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","E to keli mɛnni, e naxa siga Mitika. ");
INSERT INTO sus_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","E to keli mɛnni, e naxa siga Xasamona. ");
INSERT INTO sus_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","E to keli mɛnni, e naxa siga Mosera. ");
INSERT INTO sus_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","E to keli mɛnni, e naxa siga Beneyaakan. ");
INSERT INTO sus_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","E to keli mɛnni, e naxa siga Horo Gidigada. ");
INSERT INTO sus_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","E to keli mɛnni, e naxa siga Yotobata. ");
INSERT INTO sus_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","E to keli mɛnni, e naxa siga Abarona. ");
INSERT INTO sus_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","E to keli mɛnni, e naxa siga Esiyon Geberi. ");
INSERT INTO sus_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","E to keli mɛnni, e naxa siga Kadesi Sini gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","E keli mɛnni nɛ, e naxa siga Horo geya ma, Edon bɔxi naaninyi fɛ ma. ");
INSERT INTO sus_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Isirayilakae xa mini Misira ɲɛ tongo naani kike suuli nde xi singe, Alatala naxa Haruna yamari a xa te Horo geya fari, a xa laaxira mɛnni. ");
INSERT INTO sus_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruna nu bara ɲɛ kɛmɛ mɔxɔɲɛn nun saxan sɔtɔ, a faxa tɛmui Horo geya fari. ");
INSERT INTO sus_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Aradi mangɛ, naxan sabatixi Negewi gbengberenyi Kanaan bɔxi ma, a naxa a kolon Isirayilakae bara fa. ");
INSERT INTO sus_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Isirayilakae to keli Horo geya yire, e naxa sa yonkin Salamona. ");
INSERT INTO sus_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","E to keli mɛnni, e naxa siga Punon. ");
INSERT INTO sus_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","E to keli mɛnni, e naxa siga Oboti. ");
INSERT INTO sus_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","E to keli mɛnni, e naxa siga Iye Abarimi, Mowaba bɔxi naaninyi ra. ");
INSERT INTO sus_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","E to keli mɛnni, e naxa siga Dibon Gadi. ");
INSERT INTO sus_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","E to keli mɛnni, e naxa siga Alamɔn Dibilatayima. ");
INSERT INTO sus_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","E to keli mɛnni, e naxa siga Abarimi geyae yire, Nebo geya yatagi. ");
INSERT INTO sus_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","E to keli mɛnni, e naxa siga Mowaba fiili ma, Yurudɛn xure dɛ ra, Yeriko taa yatagi. ");
INSERT INTO sus_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","E naxa yonkin Yurudɛn xure dɛ ra, Beti Yesimoti nun Abeli Sitimi longori Mowaba fiili ma. ");
INSERT INTO sus_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Alatala naxa a masen Munsa bɛ Mowaba fiili ma, Yurudɛn xure dɛ ra, Yeriko taa yatagi, ");
INSERT INTO sus_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«A fala Isirayilakae bɛ, ‹Wo na Yurudɛn xure giri tɛmui naxɛ sofe ra Kanaan bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","wo mɛnnikae birin faxa. Wo xa e xa kuye birin kana, naxee masolixi gɛmɛ ra, naxee yailanxi wure raxunuxi ra. Wo xa e xa batudee fan kana. ");
INSERT INTO sus_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Wo xa na bɔxi suxu, wo fa sabati naa. N bara na bɔxi fi wo ma. ");
INSERT INTO sus_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Na bɔxi itaxunma wo ma Alatala xa maragiri kɛɲa nan ma a xabilɛ ki ma. Naxee bɔnsɔɛ xa mixie na wuya, e xa bɔxi belebele sɔtɔ. Naxee bɔnsɔɛ xa mixie mu wuya, e xa bɔxi xa xurun. Alatala a ragirima kankan naxan sɔtɔma a bɔnsɔɛ ki ma. ");
INSERT INTO sus_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kɔnɔ xa wo mu mɛnnikae faxa, e fama maniyade ɲooge nan na naxan mixi ya tɔɔrɔma, xa na mu a ra tunbee naxee mixi fari masɔxɔma. E findima nɛ wo yaxuie ra wo xɔnyi. ");
INSERT INTO sus_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Na tɛmui, n e xa yunubi sare dɔxɔma wo tan nan ma.›» ");
INSERT INTO sus_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«A masen Isirayilakae bɛ, ‹Wo na siga Kanaan bɔxi ma, n naxan fixi wo ma kɛ ra, a naaninyie nan yi ki: ");
INSERT INTO sus_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Yirefanyi mabiri, wo xa bɔxi naaninyi sa fɔlɔma Sini gbengberenyi nan ma, Edon bɔxi mabiri. Na naaninyi sa fɔlɔma Fɔxɔɛ Baa nan ma sogetede mabiri, ");
INSERT INTO sus_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","a sa a kɔnkɔrɔn Tali Tede yirefanyi mabiri, a a xun sa Sini, a dangi Kadesi Barineya yirefanyi mabiri, a siga Xasari Adari mabiri, a sa Asimon li. ");
INSERT INTO sus_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","A sa keli Asimon, a a kɔnkɔrɔn han Misira dabonyi kui, a fa sa mini Baa Xungbe ma.›» ");
INSERT INTO sus_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","«A sogegorode naaninyi findima Baa Xungbe nan na.» ");
INSERT INTO sus_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","«A kɔɔla naaninyi sa fɔlɔma Baa Xungbe nan ma, han a fa dɔxɔ Horo geya ra. ");
INSERT INTO sus_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Kelife ra Horo geya ma, wo xa naaninyi sigama na ki nɛ han Xamata sode dɛ ra, a sa dɔxɔ Sedade ra. ");
INSERT INTO sus_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","A na keli mɛnni, a sigama Sifiron mabiri nɛ han a sa mini Xasari Enan ma. Wo xa bɔxi naaninyi nan na ki kɔɔla mabiri.» ");
INSERT INTO sus_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","«A sogetede, wo xa naaninyi sa kelima Xasari Enan nan ma, a siga han Seefami. ");
INSERT INTO sus_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","A keli mɛnni, a siga Ribila, Ayin sogetede biri, a man siga, a sa din tentenyie ra Kinereti baa sogetede biri ra, ");
INSERT INTO sus_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","a sa mini Yurudɛn xure ma, a fa sa a raɲɔn Fɔxɔɛ Baa ma. Wo xa bɔxi naaninyie nan na ki.» ");
INSERT INTO sus_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Munsa naxa na yaamari radangi Isirayilakae ma, a falafe ra, «Bɔxi nan yi ki, naxan itaxunma Isirayila bɔnsɔɛ solomanaani nun a tagi ma, alɔ Alatala a ragirixi kankan ma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Ruben bɔnsɔɛ, Gadi bɔnsɔɛ, nun Manasi bɔnsɔɛ sɛɛti bara e gbe kɛ sɔtɔ e denbaya ki ma, ");
INSERT INTO sus_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Yurudɛn naakiri ma, Yeriko ya tagi sogetede biri ra.» ");
INSERT INTO sus_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Eleyasari sɛrɛxɛdubɛ nun Nunu xa di xɛmɛ Yosuwe nan yi bɔxi itaxunma. ");
INSERT INTO sus_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Wo xa yarerati keren keren sugandi bɔnsɔɛ birin kui, naxee lanma yi bɔxi itaxunyi. ");
INSERT INTO sus_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","E xilie nan yi ki: Yuda bɔnsɔɛ, Yefune xa di xɛmɛ Kalebi. ");
INSERT INTO sus_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeyɔn bɔnsɔɛ, Amixudi xa di xɛmɛ Semuweli. ");
INSERT INTO sus_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Bunyamin bɔnsɔɛ, Kisilon xa di xɛmɛ Elidada ");
INSERT INTO sus_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dana bɔnsɔɛ, Yogoli xa di xɛmɛ Buuki. ");
INSERT INTO sus_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yusufu xa di Manasi bɔnsɔɛ, Efodo xa di xɛmɛ Xaniyɛli. ");
INSERT INTO sus_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efirami bɔnsɔɛ, Sifitan xa di xɛmɛ Kemuweli. ");
INSERT INTO sus_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Sabulon bɔnsɔɛ, Paranaki xa di xɛmɛ Elisafan. ");
INSERT INTO sus_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isakari bɔnsɔɛ, Asana xa di xɛmɛ Palatiyɛli. ");
INSERT INTO sus_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aseri bɔnsɔɛ, Selomi xa di xɛmɛ Axihudi. ");
INSERT INTO sus_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Nafatali bɔnsɔɛ, Amixudi xa di xɛmɛ Pedaheli.» ");
INSERT INTO sus_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Alatala nee nan sugandi Kanaan bɔxi itaxunfe ra Isirayilakae ma. ");
INSERT INTO sus_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Alatala naxa a masen Munsa bɛ, Mowaba fiili ma, Yurudɛn xure fɛ ma, Yeriko ya tagi, ");
INSERT INTO sus_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«A fala Isirayilakae bɛ, e xa taa ndee nun e rabilinyie sugandi e xa bɔxi kui, e naxee fima Lewi bɔnsɔɛ ma, e sabatima dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Lewi bɔnsɔɛ sabatima na taae nan kui, e xa xurusee luma na rabilinyie. ");
INSERT INTO sus_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Na taa rabilinyie xa gboya sigama nɛ han nɔngɔn wulu keren na taa sɛɛti naani birin ma, ");
INSERT INTO sus_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","kelife taa tɛtɛ ma sigafe nɔngɔn wulu firin a sogetede biri, a sogegorode biri, a kɔɔla ma, nun a yirefanyi ma.» ");
INSERT INTO sus_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«Na taa tongo naani nun solomasaxan ya ma, wo xa taa senni sugandi naxee findima makantadee ra mixie bɛ naxee bara faxɛ ti e mu a ɲanigexi. ");
INSERT INTO sus_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Wo xa na taa tongo naani nun solomasaxan nun e rabilinyie fi Lewi bɔnsɔɛ ma. ");
INSERT INTO sus_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Bɔnsɔɛ naxee xa taae wuya, e xa taa gbegbe fi. Bɔnsɔɛ naxee xa taae mu wuya, e xa taa dondoronti fi Lewi bɔnsɔɛ ma.» ");
INSERT INTO sus_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Alatala naxa a masen Munsa bɛ, ");
INSERT INTO sus_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«A fala Isirayilakae bɛ, e na Yurudɛn xure igiri sofe ra Kanaan bɔxi ma, ");
INSERT INTO sus_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","e xa taae sugandi, naxee findima makantadee ra mixie bɛ naxee bara faxɛ ti e mu a ɲanigexi. ");
INSERT INTO sus_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Na taae nan findima makantadee ra na mixie bɛ, han kiitisae e makiitima tɛmui naxɛ. Na kui e xa ratanga mixie ma naxee wama e gbeɲɔxɔfe, naxee wama e faxafe keren na. ");
INSERT INTO sus_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Wo xa taa senni sugandi na wali xa fe ra, ");
INSERT INTO sus_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","saxan Yurudɛn naakiri ma, saxan Kanaan bɔxi ma. Na taae nan findima wo makantadee ra. ");
INSERT INTO sus_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Mixi yo mixi, a findi Isirayilaka ra, a findi xɔɲɛ ra, a findi dangi mixi ra, xa naxan yo sa mixi nde faxa a mu a ɲanigexi, na kanyi nɔma a nii ratangade na taa sennie nde kui.» ");
INSERT INTO sus_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«Kɔnɔ xa mixi sa mixi bɔnbɔ wure ra han a faxa, nii ba nan a ra. A lan nɛ, a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Xa mixi sa mixi bɔnbɔ gɛmɛ nan na han a faxa, nii ba nan a ra. A lan nɛ, a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Xa mixi sa mixi bɔnbɔ wuri nan na han a faxa, nii ba nan a ra. A lan nɛ, a fan xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Gbeɲɔxɔɛ xa na faxɛti faxa a a suxuxi tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Xa mixi nde sa a boore radin yɛ maraɲaaxui ma, xa na mu, a ɲanige a xa a gɔnɔ se nde ra, a faxa, faxɛti nan a ra. ");
INSERT INTO sus_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","Xa mixi nde sa a boore din a bɛlɛxɛ ra yaxuya ra, a faxa, faxɛti nan a ra. A lan nɛ, a fan xa faxa. Gbeɲɔxɔɛ xa na faxɛti faxa a a suxuxi tɛmui naxɛ.» ");
INSERT INTO sus_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«Kɔnɔ xa mixi nde sa a boore radin yɛ ɲanigetareɲa kui, xɔnɛ mu na, xa na mu a se nde woli a ma ɲanigetareɲa kui, ");
INSERT INTO sus_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","xa na mu a a gɔnɔ gɛmɛ ra ɲanigetareɲa kui, a fa faxa, kɔnɔ xɔnɛ nun yaxuya mu na a kui, ");
INSERT INTO sus_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ɲama xa a makiiti yi sɛriyɛ ra gbeɲɔxɔɛ xa fe ra. ");
INSERT INTO sus_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ɲama xa a ba gbeɲɔxɔɛ yi ra, a a raso makantade kui. A xa lu mɛnni han sɛrɛxɛdubɛ kuntigi laaxirama tɛmui naxɛ, Alatala naxan sugandixi. ");
INSERT INTO sus_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Kɔnɔ xa na kanyi sa mini makantade fari ma, a nu bara so dɛnnaxɛ, ");
INSERT INTO sus_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","gbeɲɔxɔɛ fa a to, a faxa, gbeɲɔxɔɛ mu findima faxɛti ra. ");
INSERT INTO sus_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Mixi naxan nii bama ɲanigetareɲa kui, a xa lu makantade han sɛrɛxɛdubɛ kuntigi laaxirama tɛmui naxɛ. Sɛrɛxɛdubɛ kuntigi na laaxira tɛmui naxɛ, mixi naxan nii baxi ɲanigetareɲa kui, a nɔma gbilende a xɔnyi maratange kui.» ");
INSERT INTO sus_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«Sɛriyɛ nan ya wo bɔnsɔɛ bɛ yire birin, tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Faxɛti mu lan a xa faxa seede keren xui ma, fo seede wuyaxi. ");
INSERT INTO sus_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Faxɛti mu lan a xun xa sara, a xa faxa. ");
INSERT INTO sus_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Mixi naxan faxɛ ti ɲanigetareɲa kui, a mu lan a xun xa sara alako a xa gbilen a xɔnyi beenun sɛrɛxɛdubɛ kuntigi laaxirama tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Wo mu lan wo xa bɔxi findi bɔxi sɛniyɛntare ra. Wuli raminife na nan nabama. Faxɛti wuli gbansan nan findima bɔxi xunsare ra. ");
INSERT INTO sus_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Wo naxa wo xɔnyi findi yire sɛniyɛntare ra. N tan Alatala sabatixi wo tan Isirayilakae ya ma.» ");
INSERT INTO sus_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Denbaya xunyi naxee nu na Galadi xabilɛ ya ma, Makiri xa die, Manasi xa mamadie, Yusufu xabilɛe, nee naxa siga Munsa nun Isirayila denbaya xunyie yire. ");
INSERT INTO sus_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","E naxa a fala Munsa bɛ, «Alatala bara a yamari i tan n marigi, i xa yi bɔxi itaxun Isirayila die ma Alatala xa maragiri kɛɲa ma, a xa findi e kɛ ra. Alatala man bara i yamari i xa muxu taara Selofexadi xa harige so a xa di ginɛe yi ra. ");
INSERT INTO sus_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Kɔnɔ xa na di ginɛe sa dɔxɔ bɔnsɔɛ gbɛtɛ xɛmɛe xɔn, e kɛ bama nɛ muxu bɔnsɔɛ kɛ ra, a sa e xa xɛmɛe bɔnsɔɛe kɛ xun ma. Na kui nde bama nɛ muxu kɛ ra, naxan fixi muxu bɔnsɔɛ ma maragiri kui. ");
INSERT INTO sus_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Xɔrɛya Ɲɛ na a li, e kɛ bama nɛ muxu benbae kɛ ra, a sa e xa xɛmɛe benbae kɛ xun ma.» ");
INSERT INTO sus_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Munsa naxa Alatala xa yaamari radangi Isirayilakae ma, a falafe ra, ");
INSERT INTO sus_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","«Yusufu bɔnsɔɛ, wo nɔndi. Alatala xa yaamari nan ya Selofexadi xa di ginɛe bɛ. E xa dɔxɔ xɛmɛ xɔn naxan na xabilɛ nde kui e baba bɔnsɔɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Sese mu bama Isirayila bɔnsɔɛ nde kɛ ra, a findi bɔnsɔɛ gbɛtɛ kɛ ra. Birin a benba kɛ nan xun makantama. ");
INSERT INTO sus_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Di ginɛ kɛ kanyi xa dɔxɔ xɛmɛ xɔn naxan na xabilɛ nde kui a baba bɔnsɔɛ ya ma. ");
INSERT INTO sus_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Sese mu bama Isirayila bɔnsɔɛ nde kɛ ra, a findi bɔnsɔɛ gbɛtɛ kɛ ra. Birin a benba kɛ nan xun makantama.» ");
INSERT INTO sus_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofexadi xa di ginɛe naxa Alatala xa yaamari suxu alɔ Munsa a fala ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","E xilie nan ya: Maxala, Tirisa, Xogala, Milika, nun Nowa. E birin naxa dɔxɔ e dɛɛxɔe xɔn ma. ");
INSERT INTO sus_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","E dɔxɔ Manasi xa di xabilɛe nan xɔn ma. Na kui e kɛ naxa lu e benba Yusufu bɔnsɔɛ. ");
INSERT INTO sus_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Alatala xa sɛriyɛ nun yaamarie nan na ki a naxee fixi Munsa ma, katarabi Isirayila ma, e nu na Mowaba fiili ma tɛmui naxɛ, Yurudɛn xure fɛ ma, Yeriko ya tagi.");
INSERT INTO sus_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Wɔyɛnyie nan yi ki, Annabi Munsa naxan masen Isirayilakae birin bɛ. Na tɛmui a nu na Yurudɛn sogetede biri ra, gbengberenyi ma naxan na Araba, Sufi ya tagi, Paran, Tofeli, Laban, Xaseroti, nun Disahabi longori. ");
INSERT INTO sus_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Keli Xorebe geya han Kadesi Barineya kira ra minife ra Seyiri geyae biri, xi fu nun keren ɲɛrɛ na a ra. ");
INSERT INTO sus_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","E xa keli ɲɛ tongo naani nde ma Misira, a kike fu nun keren nde, xi singe, Annabi Munsa naxa Alatala xa yaamari masen Isirayilakae bɛ. ");
INSERT INTO sus_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Na tɛmui Annabi Munsa nu bara xutu sɔtɔ Sixɔn ma, Amori mangɛ, naxan nu sabatixi Xɛsibɔn, a nun Ogo, Basan mangɛ, naxan nu sabatixi Asataroti nun Edereyi. ");
INSERT INTO sus_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yurudɛn sogetede biri Mowaba bɔxi ma, Annabi Munsa naxa Ala xa sɛriyɛ tagi raba e bɛ. Na wɔyɛnyi nan yi ki. ");
INSERT INTO sus_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«Won nu na Xorebe geya yire tɛmui naxɛ, won Marigi Alatala yi nan masen won bɛ, ‹Wo bara bu yi geya bun ma. ");
INSERT INTO sus_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Wo ti kira xɔn ma fa. Wo xa siga geya ma Amorikae na dɛnnaxɛ, nun na longori birin, Araba bɔxi ma, geya biri, Sefela nun Negewi biri, baa dɛ ra, han Kanaan bɔxi ma, han Liban sa dɔxɔ Efirati xure belebele ra. ");
INSERT INTO sus_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Wo xa na bɔxi mato, n naxan fixi wo ma. Wo siga, wo xa na tongo, barima n tan Alatala yati nan na bɔxi laayidi tongoxi wo benbae bɛ, Iburahima, Isiyaga, a nun Yaxuba, a nun e bɔnsɔɛ birin hali e dangi xanbi.›» ");
INSERT INTO sus_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«Na tɛmui n yi nan fala wo bɛ, ‹N tan keren mu nɔma wo xa fe nɔde. ");
INSERT INTO sus_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Wo Marigi Alatala bara wo ragbo yɛ. Yakɔsi wo bara gbo yɛ alɔ tunbuie naxee na koore ma. ");
INSERT INTO sus_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Wo benbae Marigi Alatala xa wo rawuya han. A xa baraka sa wo xa fe alɔ a masen ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","N tan keren nɔma wo xa kalamuie makiitide di? ");
INSERT INTO sus_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Wo kuntigi lɔnnilae sugandi, naxee kolonxi wo bɔnsɔɛe ya ma. N nee nan findima ɲama yareratie ra.› ");
INSERT INTO sus_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Wo naxa n yaabi, a n ma maɲɔxunyi, a maɲɔxun fanyi na a ra. ");
INSERT INTO sus_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","N naxa wo xa yareratie tongo, wo xa kuntigi lɔnnila naxee kolonxi wo bɔnsɔɛ ya ma. N naxa e findi mixi wulu, mixi kɛmɛ, mixi tongo suuli, mixi fu xunyie ra. N naxa e findi yareratie ra wo bɔnsɔɛe ya ma. ");
INSERT INTO sus_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Na tɛmui n naxa yaamari so wo makiitimae yi ra. N naxɛ, ‹Wo xa wo tuli mati wo baribooree ra. Wo xa birin makiiti sɛriyɛ kɛɲa ma, wo ngaxakerenyie tagi nun e tan nun xɔɲɛe tagi. ");
INSERT INTO sus_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Wo naxa ti mixi yo xɔn ma kiiti sade. Wo naxa xurunyi nun gboe mato. Wo naxa gaaxu mixi yo ya ra, barima kiitisa na Ala nan na. Xa kiiti sa xɔrɔxɔ wo bɛ han, wo fa a ra n xɔn, n tan kiiti sama.› ");
INSERT INTO sus_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Na ki n bara fe birin masen wo bɛ, a lan wo xa naxan naba.» ");
INSERT INTO sus_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«Na to dangi, won naxa keli Xorebe geya, won mini gbengberenyi magaaxuxi ra wo bara dɛnnaxɛ to. Won naxa bira kira fɔxɔ ra naxan sigama Amori geyae biri ra, alɔ won Marigi Alatala a masen won bɛ ki naxɛ. Won naxa so Kadesi Barineya. ");
INSERT INTO sus_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","N naxa a fala wo bɛ, ‹Wo bara Amori geyae li, won Marigi Alatala dɛnnaxɛ fixi won ma. ");
INSERT INTO sus_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Wo a mato, wo Marigi Alatala bara yi bɔxi ti won ya i. Wo siga, wo xa na tongo alɔ wo benbae Marigi Alatala a falaxi wo bɛ ki naxɛ. Wo naxa gaaxu, wo xa limaniya.›» ");
INSERT INTO sus_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","«Na tɛmui, wo birin naxa fa n yire, wo fa a fala n bɛ, ‹Won xa mixie xɛɛ, e xa siga yi bɔxi ma, e xa naa rabɛn. Na xa findi nee fan ma wali ra, alako won xa a kolon won lan won xa won ɲɛrɛ kira naxan xɔn a nun won sigama taa naxee.› ");
INSERT INTO sus_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Wo xa maɲɔxunyi naxa findi n bɛ fe fanyi ra. Na nan a to n naxa xɛmɛ mixi fu nun firin mayegeti wo ya ma, wo bɔnsɔɛ keren keren ma tagi. ");
INSERT INTO sus_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","E naxa siga geyae biri ra han e naxa gulunba li naxan xili Esekoli. E naxa naa rabɛn. ");
INSERT INTO sus_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","E naxa yi bɔxi bogisee ba, e fa e masen won bɛ. E naxa dɛntɛgɛ sa won bɛ yi ki, ‹Won Marigi Alatala bɔxi fanyi nan fixi won ma.› ");
INSERT INTO sus_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Kɔnɔ wo mu tin tede, wo naxa tondi wo Marigi Alatala xa yaamari ra. ");
INSERT INTO sus_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Wo a maxɔrɔxɔ nɛ wo xa kiri banxie kui. Wo naxa a fala, ‹Xɔnnanteya na xɛɛxi, Alatala won tongoxi Misira bɔxi ma. A wama won sofe Amorikae nan yi ra alako e xa won halaki. ");
INSERT INTO sus_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Won sigama minden? Limaniya mu na won bɛ, barima won ngaxakerenyie bara a fala won bɛ a mɛnnikae sɛnbɛ gbo. E man gbangbalan won bɛ, nun na taae xa fe maxɔrɔxɔ. Tɛtɛ naxan naa rabilinxi, a ite han. Muxu Anaki bɔnsɔɛe yati to nɛ.›» ");
INSERT INTO sus_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","«N naxa a fala wo bɛ, ‹Wo naxa siikɛ. Wo naxa gaaxu e ya ra! ");
INSERT INTO sus_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Wo Marigi Alatala naxan ɲɛrɛma wo ya ra, a gere soma nɛ wo bɛ alɔ a a rabaxi wo ya xɔri ki naxɛ Misira bɔxi ma han gbengberenyi ma. ");
INSERT INTO sus_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Wo man bara a to, wo Marigi Alatala faxi nɛ wo ra alɔ xɛmɛ a xa di xaninma ki naxɛ, wo ɲɛrɛxi kira naxan birin na han wo naxa fa be li. ");
INSERT INTO sus_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Kɔnɔ na birin kui, wo mu nu laxi wo Marigi Alatala ra. ");
INSERT INTO sus_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","A tan nan ti wo ya ra, a yire fen wo bɛ wo luma dɛnnaxɛ. Kɔɛ ra a tan nan nu kira iyalanma wo bɛ tɛ ra. Yanyi fan na, a findi nuxui ra, a ti wo ya ra. ");
INSERT INTO sus_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Alatala naxa wo xurutuxurutu xui mɛ. A xa xɔnɛ kui, a naxa a rakali, ");
INSERT INTO sus_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«Yi mixi kobi yo mu soma yi bɔxi fanyi ma, n naxan laayidixi wo babae bɛ ");
INSERT INTO sus_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","fo Kalebi, Yefune xa di. A tan a toma nɛ. A bɔxi dɛnnaxɛ ɲɛrɛxi, na findima nɛ a gbe nun a bɔnsɔɛ gbe ra, barima a bara bira n tan Alatala xa kira fɔxɔ ra.»›» ");
INSERT INTO sus_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","«Wo tan xa fe ra Alatala bara xɔnɔ n fan ma. A naxa a masen, ‹I tan yɛtɛ yati mu soma yi bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Yosuwe, Nunu xa di, i malima, nan fama sode. Limaniya fi a ma, barima a tan nan tima Isirayilakae ya ra yi bɔxi masɔtɔfe ra, a xa findi e kɛ ra. ");
INSERT INTO sus_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Wo xa die, wo a falaxi naxee bɛ, e findima geelimanie ra. E tan naxan mu fe kobi nun fe fanyi tagi raba kolonxi, e tan nan fama sode na bɔxi ma. N fama na bɔxi fide e tan nan ma. A findima e tan nan gbe ra. ");
INSERT INTO sus_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Kɔnɔ wo tan man xa wo mafindi gbilenfe ra gbengberenyi biri ra, sigafe Kale baa mabiri.›» ");
INSERT INTO sus_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","«Wo naxa a yaabi, ‹Muxu bara findi yunubitɔɛ ra Alatala ya i, kɔnɔ yakɔsi muxu fa wama sigafe gere sode nɛ, alɔ muxu Marigi Alatala muxu yamarixi a ra ki naxɛ.› Kankan naxa geresose tongo, barima wo a maɲɔxun nɛ a yi geya taa masɔtɔfe a findima sɔɔnɛya ra. ");
INSERT INTO sus_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Na nan a to Alatala naxa a masen n bɛ, ‹A fala e bɛ, wo naxa siga gere sode de, barima n mu na wo ya ma. Wo naxa siga de, wo yaxuie naxa fa wo bɔnbɔ.› ");
INSERT INTO sus_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","N yi marasi fixi nɛ wo ma, kɔnɔ wo mu tin wo tuli matide n na. Wo naxa Alatala xui matandi, wo naxa te yɛtɛ igboɲa kui geya fari. ");
INSERT INTO sus_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Na tɛmui Amorika naxee nu sabatixi geya fari e naxa mini wo gerede alɔ kumi dinma mixi ra ki naxɛ. E naxa wo bɔnbɔ keli Seyiri han Horoma. ");
INSERT INTO sus_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Wo to gbilen, wo naxa wa Alatala ya i, kɔnɔ Alatala mu a tuli mati wo wa xui ra. ");
INSERT INTO sus_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Wo man naxa lu Kadesi, wo bu naa alɔ wo singe bui naxan naba.» ");
INSERT INTO sus_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","«Na xanbi won naxa gbilen gbengberenyi kira suxu ra sigafe Kale Baa mabiri, alɔ Alatala a masen n bɛ ki naxɛ. Won naxa xi wuyaxi raba Seyiri geyae rabilinyi.» ");
INSERT INTO sus_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","«Alatala naxa a fala n bɛ, ");
INSERT INTO sus_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‹Wo bara yi geya mabilin a gbe ra. Wo wo mafindi sigafe ra kɔɔla ma.› ");
INSERT INTO sus_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","A naxa a fala n bɛ n xa yi yaamari fi wo ma. Wo fama dangide Seyiri bɔxi sɛɛti ma, wo ngaxakerenyie na dɛnnaxɛ, Esayu bɔnsɔɛ. E fama nɛ gaaxude wo ya ra, kɔnɔ wo wo yɛtɛ masuxu e gerefe ra, ");
INSERT INTO sus_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","barima n mu sese soma wo yi ra e xa bɔxi ma, hali sanyi tide. N bara Seyiri geyae fi Esayu ma. ");
INSERT INTO sus_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Wo na wa donse nun ye naxan xɔn fo wo a sara e ma gbeti ra. ");
INSERT INTO sus_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Wo Marigi Alatala bara baraka sa wo wali fɔxi. A bara a ɲɔxɔ sa wo xa fe xɔn ma wo nu yi gbengberenyi igirima tɛmui naxɛ. Yi ɲɛ tongo naani bun ma, wo birin nan nu a ra. Sese xa fe mu xɔrɔxɔ wo ma.» ");
INSERT INTO sus_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","«Won naxa dangi won ngaxakerenyie ra yire makuye, Esayu bɔnsɔɛ naxan sabatixi Seyiri bɔxi ma. Won man naxa dangi Araba, Elata, Esiyon Geberi kira ra yire makuye. Na xanbi won naxa won mafindi, won Mowaba gbengberenyi kira suxu.» ");
INSERT INTO sus_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","«Alatala naxa a fala n bɛ, ‹Wo naxa gere giri Mowabakae ma de. Wo naxa gere ti e bɛ de, barima n mu fama sese sode wo yi ra e xɔnyi. N bara Ari bɔxi fi Loti ma.›» ");
INSERT INTO sus_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Singe ra, Emikae nan nu na Ari bɔxi ma. Ɲama gbangbalanyi nan nu e ra. E wuya, e fan kuya alɔ Anaki bɔnsɔɛe. ");
INSERT INTO sus_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Mixi ndee naxa e maɲɔxun Refakae ra, naxee maniya Anaki bɔnsɔɛe ra, kɔnɔ Mowabakae nu e xilima nɛ Emikae. ");
INSERT INTO sus_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Naxan findi Seyiri bɔxi ra, Xorikae nan singe nu na naa. Esayu bɔnsɔɛ naxa e masuxu, e e faxa. E tan naxa sabati naa. Isirayilakae fan fama na mɔɔli nan nabade bɔxi ma Alatala na dɛnnaxɛ fi e ma. ");
INSERT INTO sus_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","«Alatala naxa a fala n bɛ, ‹Yakɔsi, wo keli, wo xa Serede xure igiri.›» Won naxa na raba. ");
INSERT INTO sus_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ɲɛ tongo saxan nun solomasaxan dangi nɛ kabi won keli lɔxɔɛ Kadesi Barineya han won giri lɔxɔɛ Serede xure ra. Na waxati kui geresoe naxee nu na, nee birin nu bara faxa alɔ Alatala a rakali e bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Alatala naxa e tuxunsan han e birin naxa halaki. ");
INSERT INTO sus_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Na geresoe to bara halaki ɲama tagi, ");
INSERT INTO sus_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Alatala naxa a masen n bɛ, ");
INSERT INTO sus_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«Wo fa sigafe dangide Mowaba naaninyi nan na sigafe Ari bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Wo makɔrɛma nɛ Amonikae ra. Wo naxa gere giri e ma de. Wo naxa e fen gere ra, barima n mu fama sese sode wo yi ra e xa bɔxi ma. N naa fixi Loti bɔnsɔɛ nan ma.» ");
INSERT INTO sus_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","E nu yi bɔxi maɲɔxunxi Refakae nan gbe ra. Kabi tɛmui xɔnnakuye Refakae nan nu sabatixi naa. Amonikae nu e xilima nɛ Samisumikae. ");
INSERT INTO sus_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Ɲama sɛnbɛma nan nu lanxi e ma, e wuya, e man gbangbalan alɔ Anaki bɔnsɔɛ. Kɔnɔ Alatala naxa e halaki Amonikae saabui ra. Naa naxa findi Amonikae gbe ra, e naxa sabati naa. ");
INSERT INTO sus_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Alatala naxa na mɔɔli raba Esayu xa die bɛ naxee sabatixi Seyiri bɔxi ma. A to nu Xorikae halakima e saabui ra, naa naxa findi e gbe ra. E sabatixi mɛnni nɛ han yakɔsi. ");
INSERT INTO sus_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Naxan findi Awikae tan na, naxee nu sabatixi taae kui han Gasa, e naxa halaki Kafatorokae saabui ra. Naa naxa findi Kafatorokae gbe ra, e naxa sabati naa. Kafatorokae naxa keli Kafatoro. ");
INSERT INTO sus_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Alatala naxa a masen won bɛ, «Wo ti kira xɔn ma, wo xa Arinon xure igiri. Wo a mato, n bara Sixɔn Amorika Xɛsibɔn mangɛ so wo yi ra nun a xa bɔxi. Yakɔsi, wo na tongo, wo e gere. ");
INSERT INTO sus_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","To n fama nɛ wo xa fe magaaxui lude duniɲa mixi birin ma. E na wo xili mɛ, e fama nɛ sɛrɛnde gbirigbiri.» ");
INSERT INTO sus_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","«N xɛɛra xɛɛ nɛ Sixɔn, Xɛsibɔn mangɛ ma, kelife ra Kedemoti gbengberenyi ma. N naxa yi bɔɲɛsa masenyi ti a bɛ, ");
INSERT INTO sus_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‹Muxu wama i xa bɔxi igirife. Muxu muxu ɲɛrɛma kira nan tun xɔn ma. Muxu mu sigama kɔɔla ma, muxu mu sigama yirefanyi ma. ");
INSERT INTO sus_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Muxu donse nun ye naxan minma, muxu fama nɛ a birin sare fide i ma gbeti ra. A lu kansan muxu xa dangi i xa bɔxi ma muxu sanyi ra. ");
INSERT INTO sus_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Esayu bɔnsɔɛe naxee sabatixi Seyiri bɔxi ma, nun Mowabakae naxee sabatixi Ari bɔxi ma, nee naxa muxu sagoe sa dangife ra e xa bɔxi ma. I fan xa muxu sagoe sa muxu xa Yurudɛn xure igiri, muxu xa so bɔxi ma muxu Marigi Alatala dɛnnaxɛ fixi muxu ma.› ");
INSERT INTO sus_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Kɔnɔ Xɛsibɔn mangɛ Sixɔn naxa tondi muxu sagoe fide dangife ra a xa bɔxi ma, barima wo Marigi Alatala nu bara a xaxili raxɔrɔxɔ. A naxa a bɔɲɛ balan alako a xa a so wo yi ra alɔ wo a toxi ki naxɛ to.» ");
INSERT INTO sus_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","«Alatala naxa a fala n bɛ, ‹I bara a to, n bara gɛ Sixɔn nun a xa bɔxi sode i yi ra. Naa tongo i gbe.› ");
INSERT INTO sus_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sixɔn nun a xa ɲama birin naxa keli fafe ra won gerede Yahasi. ");
INSERT INTO sus_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Won Marigi Alatala naxa e so won yi ra xunnakeli kui. Won naxa nɔla sɔtɔ e ma, a tan, a xa die a nun a xa ɲama birin. ");
INSERT INTO sus_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Won naxa na taae birin suxu, won naxa e birin kana. Won man naxa xɛmɛe, nun ginɛe, a nun dimɛe birin faxa. Won mu mixi yo lu a ɲiɲɛ ra, ");
INSERT INTO sus_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","kɔnɔ won mu sese tongo fo xurusee a nun se xɔri naxee nu na na taae kui. ");
INSERT INTO sus_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Keli Aroweri Arinon xure dɛ ra, a nun taa naxan na geya lanbanyi, sigafe ra han Galadi, taa yo sɛnbɛ mu dangi won na. Won Marigi Alatala naxa a birin so won yi ra. ");
INSERT INTO sus_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Kɔnɔ wo mu wo makɔrɛ Amonikae xa bɔxi ra, Yaboko xure dɛ birin, taa naxee na geya fari, a nun Alatala tɔnyi dɔxɔ won ma bɔxi naxee gerefe ra.» ");
INSERT INTO sus_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","«Won naxa won mafindi tefe ra Basan kira xɔn ma. Ogo, Basan mangɛ, naxa mini won gerede Ederi, a tan nun a xa ɲama birin. ");
INSERT INTO sus_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Alatala naxa a fala n bɛ, ‹I naxa gaaxu a ya ra, barima n a niyama nɛ i xutu sɔtɔ a tan nun a xa ɲama birin ma nun a xa bɔxi. I xa nɔ a ra alɔ i a rabaxi Amorikae xa mangɛ Sixɔn na ki naxɛ.› ");
INSERT INTO sus_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Won Marigi Alatala naxa a niya won xa xutu sɔtɔ Basan mangɛ Ogo nun a xa ɲama birin ma. Won naxa e birin faxa, mixi yo mu lu. ");
INSERT INTO sus_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Na tɛmui won nu bara e xa taae birin suxu. Na taa yo mu lu won mu dɛnnaxɛ suxu, taa tongo senni na a ra naxan na Aragobo rabilinyi. Na taa birin nu na Ogo xa mangɛya nan bun ma Basan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Na taae birin nu rabilinxi tɛtɛ itexie nan na, nun naadɛ mabalanxie ra. Taa gbegbe fan nu na tɛtɛ mu nu naxee rabilinxi. ");
INSERT INTO sus_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Won naxa na longori taa birin kana alɔ won a raba Xɛsibɔn, Sixɔn mangɛ xa bɔxi ra ki naxɛ. Won naxa xɛmɛe, nun ginɛe, a nun dimɛe birin faxa, ");
INSERT INTO sus_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","kɔnɔ won naxa e xa xurusee nun e harige tan xanin.» ");
INSERT INTO sus_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","«Won a raba na ki nɛ. Na waxati won naxa bɔxie rasuxu, naxee nu na Yurudɛn sogetede biri, Amorikae xa mangɛ firinyie yi ra. Na longori keli Arinon xure han Xerimon geya. ");
INSERT INTO sus_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidɔnkae na geya xili falama nɛ Siriyon. Amorikae tan na xili falama Seniri. ");
INSERT INTO sus_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Taa naxee birin na lanbanyi ma, won naxa e birin masɔtɔ, a nun Galadi bɔxi rabilinyi birin, sigafe ra Basan ma sa dɔxɔ Salika nun Ederi ra. Na taa birin nu na Ogo xa mangɛya nan bun ma Basan bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Basan mangɛ Ogo nan keren mu faxa Refakae ya ma. A xa wure sade nu na Raaba nɛ, Amonikae xa mangataa. A kuyɛ nu sigaxi nɔngɔn solomanaani, a igboe nɔngɔn naani.» ");
INSERT INTO sus_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","«Na tɛmui won naxa xutu sɔtɔ na bɔxi ma. Kelife Aroweri sigafe ra Arinon xure ma, a nun Galade geya sɛɛti, nun a taae, n naxa na birin so Ruben nun Gadi bɔnsɔɛ yi ra. ");
INSERT INTO sus_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","N naxa Galade sɛɛti dɔnxɔɛ nun Ogo xa mangɛya naxan na Basan bɔxi ma so Manasi bɔnsɔɛ sɛɛti yi ra. Aragobo rabilinyi nun Basan nu kolonxi Refakae xa bɔxi nan na. ");
INSERT INTO sus_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manasi xa di Yayiri naxa Aragobo bɔxi findi a gbe ra, han Gesurikae nun Maakakae naaninyi ra. A naxa a xili sa Basan xun ma, naxan xili falama han yakɔsi Yayiri taa. ");
INSERT INTO sus_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","N naxa Galade so Makiri yi ra. ");
INSERT INTO sus_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","N naxa Galade sɛɛti so Ruben bɔnsɔɛ a nun Gadi bɔnsɔɛ yi ra, han a sa dɔxɔ Arinon xure ra. Xure nan na naaninyi ra, han a sa dɔxɔ Yaboko xure ra Amonikae naaninyi ra, ");
INSERT INTO sus_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","a nun Araba bɔxi naxan nun Yurudɛn naaninyi baxi, keli Kinereti Baa ma, a sa dɔxɔ Araba Fɔxɛ Baa ra, naxan na Pisiga lanbanyi ma sogetede.» ");
INSERT INTO sus_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","«Na tɛmui n naxa yi yaamari fi wo ma, ‹Wo Marigi Alatala bara yi bɔxi fi wo ma alako a xa findi wo gbe ra. Wo tan xɛmɛ kɛndɛe, wo findima nɛ wo ngaxakerenyi Isirayilakae xa sɔɔrie ra. ");
INSERT INTO sus_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Wo xa ginɛe nun wo xa diyɔrɛe, nun wo xa xurusee nan gbansan fama lude taae kui n naxee soxi wo yi ra. N na a kolon xurusee gbegbe na wo yi ra. ");
INSERT INTO sus_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Wo sɔɔriɲa rabama nɛ han wo Marigi Alatala malabui fima wo ngaxakerenyie ma tɛmui naxɛ. Wo Marigi Alatala bɔxi fima e ma Yurudɛn naakiri nan ma. Na tɛmui kankan fama gbilende a xa bɔxi ma n naxan soxi a yi ra.›» ");
INSERT INTO sus_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","«Na tɛmui n naxa yaamari so Yosuwe yi ra. N fa a fala a bɛ, ‹I ya bara fee birin to i Marigi Alatala naxee rabaxi yi mangɛ firinyie ra. Alatala fama nɛ na rabade mangataa birin i na dangi dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","I naxa gaaxu e ya ra, barima i Marigi Alatala nan fama e gerede wo bɛ.›» ");
INSERT INTO sus_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","«Na tɛmui n naxa Alatala maxandi, ");
INSERT INTO sus_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‹N Marigi Alatala, i bara i xa fisamanteya nun i sɛnbɛ masen i xa konyi bɛ. Ala gbɛtɛ yo mu na koore ma a nun bɔxi naxan nɔma i fɔxi a nun i xa kaabanakoe rabade. ");
INSERT INTO sus_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","N bara i mayandi, a lu n xa nɔ Yurudɛn xure igiride, alako n xa na bɔxi fanyi nun a xa geya fanyie to naxan na naakiri ma, a nun Liban.› ");
INSERT INTO sus_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Kɔnɔ wo tan xa fe ra, Alatala naxa xɔnɔ n ma. A mu n danxun. Alatala naxa a fala n bɛ, ‹A mu lan i xa yi wɔyɛnyi fala n bɛ sɔnɔn. ");
INSERT INTO sus_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Te Pisiga geya xuntagi, i xa sogegorode biri, kɔɔla biri, yirefanyi biri, a nun sogetede biri mato, kɔnɔ i xa a kolon a fanyi ra i mu Yurudɛn igirima. ");
INSERT INTO sus_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","I xa yaamari so Yosuwe yi ra, i xa limaniya nun sɛnbɛ fi a ma, barima a tan nan fama tide ɲama ya ra Yurudɛn igirife ra. I bɔxi naxan toma, Yosuwe fama nɛ na bɔxi sode Isirayila yi ra, a findi e kɛ bɔxi ra.› ");
INSERT INTO sus_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Na nan a toxi, won naxa lu gulunba Beti Peyori yatagi. ");
INSERT INTO sus_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","«Yakɔsi, Isirayila, wo wo tuli mati. Wo xa bira sɛriyɛ nun yaamari fɔxɔ ra n wo xaranfe naxee ra yi ki, alako wo xa simaya sɔtɔ, wo man xa bɔxi sɔtɔ wo babae Marigi Alatala naxan fixi wo ma. ");
INSERT INTO sus_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Wo naxa sese sa yaamari xun, n naxan falaxi wo bɛ. Wo man naxa sese ba a ra. Wo xa wo Marigi Alatala xa yaamari rawali alɔ n na falaxi wo bɛ ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","«Wo yae bara fee to Alatala naxee rabaxi Peyori. Wo Marigi Alatala bara mixi birin faxa naxee Bali batuxi Peyori. ");
INSERT INTO sus_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Kɔnɔ wo tan naxee biraxi wo Marigi Alatala xa fe fɔxɔ ra, wo birin man na simaya kui han to.» ");
INSERT INTO sus_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","«Wo a kolon, n bara wo xaran sɛriyɛ nun yaamari ra alɔ n Marigi Alatala a yamarixi n na ki naxɛ, alako wo xa a raba bɔxi ma dɛnnaxɛ findima wo gbe ra. ");
INSERT INTO sus_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Wo xa a ti xɔri ma, wo xa a raba, a xa findi lɔnni ra wo bɛ, a xa xaxili fi wo ma. Si gbɛtɛe na yi sɛriyɛe kolon, e fama nɛ a falade, ‹Yi si findixi lɔnnila fanyie nan na.› ");
INSERT INTO sus_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Si mundun xa ala makɔrɛxi a ra alɔ won Marigi Alatala a makɔrɛma won na ki naxɛ won na a maxandi tɛmui naxɛ? ");
INSERT INTO sus_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Sɛriyɛ nun yaamari tinxinxi na si mundun bɛ alɔ won ma sɛriyɛ n naxan soxi wo yi ra yi ki? ");
INSERT INTO sus_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Wo xa fee ragata wo xaxili ma lɔxɔɛ birin wo xa simaya kui, wo naxee toxi. Wo naxa nɛɛmu nee ma, e naxa ba wo bɔɲɛ ma. Wo xa e masen wo xa die nun wo xa mamadie bɛ.» ");
INSERT INTO sus_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","«Wo wo maɲɔxun lɔxɔɛ ma wo ti wo Marigi Alatala ya i lɔxɔɛ naxɛ, Xorebe geya fari. Na lɔxɔɛ Alatala naxa a fala n bɛ, ‹Ɲama birin xa malan n yire. N xa n ma sɛriyɛ fala e bɛ alako e xa gaaxu n ya ra e xa duniɲɛigiri kui. E man xa a xaran e xa die fan na.› ");
INSERT INTO sus_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Wo naxa wo maso geya bunyi ra. Tɛ nu bara din geya ra han koore ma. Dimi, nuxui, nun kunda naxa goro. ");
INSERT INTO sus_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Alatala naxa wɔyɛn wo bɛ tɛ tagi. Wo naxa a wɔyɛn xui mɛ, kɔnɔ wo mu sese to. Wo nu a xui nan tun mɛma. ");
INSERT INTO sus_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","A naxa a xa saatɛ masen wo bɛ, wo naxan nawalima. A naxa na yaamari fu sɛbɛ gɛmɛ walaxɛ firinyi ma. ");
INSERT INTO sus_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Na waxati, Alatala naxa n yaamari n xa wo xaran sɛriyɛ nun yaamari ra, alako wo xa a raba bɔxi ma naxan findima wo gbe ra.» ");
INSERT INTO sus_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","«Wo naxa wo yɛtɛ ranɛɛmu lɔxɔɛ ma de Alatala wɔyɛn wo bɛ lɔxɔɛ naxɛ, Xorebe geya fari tɛ tagi, wo mu a gundi yati to. ");
INSERT INTO sus_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Wo naxa findi yunubitɔɛ ra de kuyee yailanfe ra, naxee misaalixi xɛmɛ, ginɛ, ");
INSERT INTO sus_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","sube, xɔni, ");
INSERT INTO sus_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","bubusee nun yɛxɛe ra naxee na ye ma. ");
INSERT INTO sus_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Wo naxa wo yae rate koore ma de, soge batufe ra, xa na mu a ra kike, xa na mu a ra tunbuie. Se naxee birin na koore ma, wo naxa wo igoro e bɛ, wo naxa e batu. Wo Marigi Alatala nee daaxi si birin nan bɛ, naxee na duniɲa ma. ");
INSERT INTO sus_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Kɔnɔ wo tan, Alatala wo ramini nɛ fe xɔrɔxɔɛ kui Misira bɔxi ma alako wo xa findi a xa ɲama ra, alɔ wo na ki naxɛ to lɔxɔɛ.» ");
INSERT INTO sus_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","«Alatala naxa xɔnɔ n ma wo xa fe ra. A naxa a kali a n mu Yurudɛn igirima, n mu fama sode yi bɔxi fanyi ma wo Marigi Alatala naxan fixi wo ma kɛ ra. ");
INSERT INTO sus_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","N tan, n fama faxade yi bɔxi nan ma. N mu fama Yurudɛn igiride feo. Kɔnɔ wo tan fama nɛ a igiride, na bɔxi fanyi findi wo gbe ra. ");
INSERT INTO sus_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Wo xa wo ɲɛngi sa wo yɛtɛ xɔn ma alako wo naxa nɛɛmu wo Marigi Alatala xa saatɛ ma a naxan tongoxi wo bɛ. Wo naxa kuye yo yailan wo Marigi Alatala naxee ratɔnxi wo ma, ");
INSERT INTO sus_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","barima wo Marigi Alatala luma alɔ tɛ naxan se kanama, a mu wama a firin boore xɔn ma.» ");
INSERT INTO sus_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","«Wo na die nun mamadie sɔtɔ tɛmui naxɛ, wo na bu ki naxɛ bɔxi ma, xa wo kuye yailan se nde misaali ra, xa wo fe ɲaaxi raba wo Marigi Alatala ya i naxan mu rafan a ma, ");
INSERT INTO sus_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","koore nun bɔxi nan na won seede ra to lɔxɔɛ, wo fama nɛ faxade mafuren bɔxi ma naxan fama findide wo gbe ra Yurudɛn naakiri ma. Wo mu fama simaya sɔtɔde, wo halakima nɛ. ");
INSERT INTO sus_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Alatala wo rayensenma nɛ ɲamanɛe ma. Wo si fama nɛ xurunde ɲamae tagi Alatala na wo xanin dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Mɛnni wo fama kuyee nan batude, mixie naxee yailanxi wuri ra, xa na mu a ra gɛmɛ, kuye naxee mu nɔma se tode, e mu fe mɛma, e mu e dɛgema, e mu se xiri mɛma. ");
INSERT INTO sus_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Mɛnni wo fama nɛ wo Marigi Alatala fende. Wo a toma nɛ xa wo a fen wo bɔɲɛ fanyi ra, wo ɲanige birin na. ");
INSERT INTO sus_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Wo xa tɔɔrɛ kui na fe birin wo lima nɛ. Na tɛmui wo fama gbilende wo Marigi Alatala ma, wo a xui mɛma nɛ, ");
INSERT INTO sus_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","barima wo Marigi Alatala, Ala na a ra naxan kinikinima mixi ma, naxan mu wo rabɛɲinma, naxan mu wo halakima. A mu fama nɛɛmude saatɛ ma a rakali naxan na wo babae bɛ.» ");
INSERT INTO sus_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«Wo wo maɲɔxun fe forie ma naxee bara dangi duniɲa ma kabi Ala adama daaxi tɛmui naxɛ. Fe kaabanakoe gbɛtɛ fan bara raba na xanbi ra? Nde bara na fe mɔɔli maniyɛ mɛ sinden? ");
INSERT INTO sus_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ɲama gbɛtɛ nde na na ba, naxee bara Ala xui mɛ tɛ tagi, a man fa simaya sɔtɔ alɔ naxan bara raba wo tan bɛ? ");
INSERT INTO sus_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ala mundun bara ɲama ba ɲama gbɛtɛ yi ra ɲaxankatɛ ra, tɔnxuma ra, kaabanakoe ra, gere belebele ra, fe magaaxuxie ra, alɔ wo Marigi Alatala naxan naba wo bɛ Misira bɔxi ma wo ya xɔri?» ");
INSERT INTO sus_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","«Na bara fiixɛ wo bɛ alako wo xa la a ra a Alatala keren peti nan Ala ra, Ala gbɛtɛ yo mu na fo a keren. ");
INSERT INTO sus_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","A naxa a xui ramini koore ma alako wo xa gaaxu a ya ra. A naxa tɛ belebele masen wo bɛ bɔxi fari, a wɔyɛn wo bɛ a tagi. ");
INSERT INTO sus_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","A naxa wo babae xanu, a naxa e bɔnsɔɛ fan sugandi hali e dangi xanbi. Na nan a toxi a wo raminixi sɛnbɛ ra Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","A sie keri wo bɛ naxee sɛnbɛ gbo wo tan bɛ, a e xa bɔxi so wo yi ra kɛ ra alɔ wo a toxi ki naxɛ to. ");
INSERT INTO sus_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Wo lan nɛ wo xa a kolon to lɔxɔɛ wo bɔɲɛ kui, a Alatala keren peti nan na Ala ra koore nun bɔxi ma. Ala gbɛtɛ mu na na fo a keren. ");
INSERT INTO sus_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Wo a xa sɛriyɛ nun a xa yaamari rabatu, n naxan sofe wo yi ra to lɔxɔɛ, alako wo xa hɛɛri sɔtɔ wo tan nun wo bɔnsɔɛ, hali wo dangi xanbi, alako wo man xa simaya xɔnkuye sɔtɔ bɔxi ma wo Marigi Alatala dɛnnaxɛ fixi wo ma abadan.» ");
INSERT INTO sus_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Annabi Munsa naxa taa saxan sugandi Yurudɛn sogetede biri. ");
INSERT INTO sus_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Nee naxa findi mixi ratanga taae ra faxatie bɛ naxee faxɛ tima, kɔnɔ e mu a ɲanigexi. Na faxɛti nɔma lude yi taa keren keren na ma kui alako a nii xa ratanga gbeɲɔxɔɛ ma. ");
INSERT INTO sus_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Na taae findi Beteseri nan na gbengberenyi ma geya fari, Rubenkae xɔnyi, Ramoti taa naxan na Galede, Gadikae xɔnyi, a nun Golan, taa naxan na Basan bɔxi ma Manasikae xɔnyi. ");
INSERT INTO sus_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ala xa sɛriyɛ nan ya, Annabi Munsa naxan masenxi Isirayilakae bɛ. ");
INSERT INTO sus_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Masenyi, sɛriyɛ, nun yaamari nan ya, Annabi Munsa naxan fala Isirayilakae bɛ e nu minima Misira bɔxi ra tɛmui naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Na tɛmui, e nu na Yurudɛn naakiri nan ma, gulunba Beti Peyori ya tagi, Amorikae xa mangɛ Sixɔn xa bɔxi ma. Sixɔn nu sabatixi Xɛsibɔn nɛ. Annabi Munsa nun Isirayilakae to mini Misira bɔxi ma, e naxa nɔla sɔtɔ Sixɔn ma. ");
INSERT INTO sus_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","E naxa a xa bɔxi rasuxu a yi ra, a nun Basan mangɛ Ogo xa bɔxi. Yi Amorikae xa mangɛ firinyie nu na Yurudɛn naakiri ma sogetede biri. ");
INSERT INTO sus_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Yi taae nu sigaxi Aroweri han Arinon xure, sigafe ra Xerimon geya ma, naxan xili Siyon. ");
INSERT INTO sus_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Yi taae nan nu Araba bɔxi ma Yurudɛn naakiri ma, sogetede biri, a sa dɔxɔ Araba baa ra Pisiga geya bun ma. ");
INSERT INTO sus_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Annabi Munsa naxa Isirayila ɲama maxili, a naxa a fala e bɛ, «Isirayilakae, wo wo tuli mati yi sɛriyɛ nun yaamari ra, n naxan falafe wo bɛ to lɔxɔɛ. Wo lan wo xa a xaran, wo xa fɛntɛn a raba ki ma. ");
INSERT INTO sus_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Won Marigi Alatala bara saatɛ tongo won bɛ Xorebe geya fari. ");
INSERT INTO sus_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Alatala nun won babae xa mu yi saatɛ xirixi. A xirixi won tan nan birin tagi, won tan naxee na simaya kui yi waxati. ");
INSERT INTO sus_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Alatala wɔyɛn nɛ won bɛ ya nun ya tɛ tagi geya fari. ");
INSERT INTO sus_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Na tɛmui n tan nan nu na wo nun Alatala tagi alako n xa Alatala xa masenyi ya xaran wo bɛ, barima wo nu gaaxuxi tɛ ya ra. Wo mu te geya fari. A naxa a masen wo bɛ, ");
INSERT INTO sus_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‹N tan nan na wo Marigi Alatala ra. N tan nan wo raminixi Misira, wo nu na konyiya kui dɛnnaxɛ.›» ");
INSERT INTO sus_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«Wo naxa Ala gbɛtɛ batu fo n keren.» ");
INSERT INTO sus_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«Wo naxa kuye yailan misaali yo ra, se yo ra naxee na koore nun bɔxi ma, naxee na ye bun ma. ");
INSERT INTO sus_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Wo naxa wo igoro e bɛ de, wo naxa e batu de, barima n tan nan na wo Marigi Alatala ra, n mu wama n firin boore xɔn. Xa mixi nde n matandi, n na kanyi ɲaxankatama nɛ, a tan nun a bɔnsɔɛ han a sa dɔxɔ a tolobitɛe ra, xa na mu a ra a tolontolonyie ra naxee na n naɲaaxu. ");
INSERT INTO sus_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Kɔnɔ n fe fanyi rabama nɛ bɔnsɔɛ wulu bɛ n nafan naxee ma, naxee n ma sɛriyɛ rabatuma.» ");
INSERT INTO sus_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","«Wo naxa wo Marigi Alatala xili yelefu, barima Alatala mixi ɲaxankatama nɛ naxan na rabama.» ");
INSERT INTO sus_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","«Wo lan nɛ wo xa fɛntɛn malabui lɔxɔɛ ma, wo xa a binya alɔ wo Marigi Alatala a yamarixi wo bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Xi senni nan na wo bɛ lɔxɔxunyi kui wali lɔxɔɛe ra, wo xa wali birin nabafe ra. ");
INSERT INTO sus_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","A xi solofere nde findixi wo Marigi Alatala xa malabui lɔxɔɛ nan na. Wo naxa wali yo raba na lɔxɔɛ keli wo tan ma, a sa wo xa die li, wo xa konyie, wo xa ningee, wo xa sofalee, wo xa xuruse mɔɔli birin, han a sa wo xa xɔɲɛe li naxee na wo xɔnyi, alako wo xa konyie fan xa e malabu alɔ wo tan. ");
INSERT INTO sus_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Wo naxa nɛɛmu konyi nan nu wo ra Misira. N naxa wo ramini na konyiya kui, a keli n sɛnbɛ ma. N a falaxi wo bɛ na nan ma, wo xa malabui lɔxɔɛ binya.» ");
INSERT INTO sus_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","«Wo xa wo baba nun wo nga binya alɔ wo Marigi Alatala a yamarixi wo bɛ ki naxɛ, alako wo xa simaya xɔnkuye nun sɛɛwɛ sɔtɔ bɔxi ma wo Marigi Alatala naxan fima wo ma.» ");
INSERT INTO sus_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","«Wo naxa faxɛ ti.» ");
INSERT INTO sus_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","«Wo naxa yɛnɛ raba.» ");
INSERT INTO sus_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","«Wo naxa muɲɛ ti.» ");
INSERT INTO sus_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","«Wo naxa wule seedeɲɔxɔya raba wo boore xun.» ");
INSERT INTO sus_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","«Wo naxa mila wo boore xa ginɛ ma, a xa banxi, a xa xɛ, a xa konyi, a xa ninge, a xa sofale, nun se naxan birin findixi a gbe ra.» ");
INSERT INTO sus_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","«Alatala yi fee nan masen wo xa malanyi kui, a xui itexi ra, geya fari, tɛ tagi, nuxui nun kunda tagi. A mu sese sa a xun ma. A naxa e sɛbɛ gɛmɛ walaxɛ firin ma, a e so n yi ra.» ");
INSERT INTO sus_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","«Wo yi xui mɛ kuye ifɔɔrɛ kui tɛmui naxɛ, tɛ tagi, geya fari, wo naxa wo maso n na, wo nun wo xa mangɛe nun kuntigie. ");
INSERT INTO sus_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Wo naxa a fala, ‹Muxu Marigi Alatala bara a xa nɔrɛ nun a xa gboe masen muxu bɛ. Muxu bara a xui mɛ wɔyɛn na tɛ tagi. Muxu bara a kolon to a Ala nɔma wɔyɛnde mixi bɛ, na kanyi man fa lu a mu faxa. ");
INSERT INTO sus_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Yakɔsi, muxu fa muxu makɔrɛma faxɛ ra munfe ra? Yi tɛ muxu faxama nɛ. Xa muxu man muxu tuli mati won Marigi Alatala xui ra, muxu faxama nɛ. ");
INSERT INTO sus_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Mixi mundun luxi alɔ won tan naxan bara Alatala xui mɛ a wɔyɛnma tɛ tagi, na kanyi man fa lu a mu faxa? ");
INSERT INTO sus_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","I tan Munsa, i maso won Marigi Alatala ra, i xa i tuli mati a xa masenyi ra, alako i xa na madangi muxu bɛ, muxu muxu tuli matima nɛ i ra, muxu man fa a xui rabatu.›» ");
INSERT INTO sus_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","«Alatala naxa wo xa wɔyɛnyi mɛ, wo naxan falaxi n bɛ. A naxa a masen n bɛ, ‹N bara ɲama fala xui mɛ. E naxan birin falaxi nɔndi na a ra. ");
INSERT INTO sus_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Xa n ma fe gaaxui lu e bɔɲɛ ma tɛmui birin, e man naxa n ma yaamari rabatu, e tan nun e bɔnsɔɛ fama nɛ hɛɛri sɔtɔde abadan. ");
INSERT INTO sus_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Siga i xa sa a fala e bɛ, e xa so e xa kiri banxie bun ma. ");
INSERT INTO sus_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Kɔnɔ i tan xa lu n fɛ ma be. N xa n ma sɛriyɛ nun yaamari birin masen i bɛ, i lan i xa e xaran naxan na, alako e xa nɔ na raɲɛrɛde bɔxi ma n fama dɛnnaxɛ fide e ma.› ");
INSERT INTO sus_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Wo Marigi Alatala naxan masenxi wo bɛ, wo xa wo tuli mati na ra, wo man xa a rabatu. Wo naxa siga kɔɔla ma, wo naxa siga yirefanyi ma. ");
INSERT INTO sus_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Wo xa bira yi kira fanyi nan fɔxɔ ra won Marigi Alatala naxan masenxi, alako wo naxa faxa, wo fa simaya xɔnkuye sɔtɔ sɛɛwɛ kui bɔxi ma wo fama dɛnnaxɛ sɔtɔde.» ");
INSERT INTO sus_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","«Sɛriyɛ, yaamari, nun masenyi nan yi ki, wo Marigi Alatala naxan soxi n yi ra alako n xa a xaran wo ra, wo xa nɔ a rabade bɔxi ma a fafe naxan fide wo ma. ");
INSERT INTO sus_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Wo xa gaaxu won Marigi Alatala ya ra. Wo xa simaya kui, wo tan, wo xa die, a nun wo xa mamadie, wo xa yi sɛriyɛ nun yi yaamari birin naba n naxan soxi wo yi ra, alako wo xa simaya xɔnkuye sɔtɔ. ");
INSERT INTO sus_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Isirayilakae, wo wo ɲɛngi sa yi birin xɔn ma, wo man xa fɛntɛn a raba ki ma. Wo fama nɛ hɛɛri sɔtɔde, wo fama nɛ findide ɲama gbegbe ra yi bɔxi ma xiɲɛ nun kumi gbegbe na dɛnnaxɛ, alɔ wo benbae Marigi Alatala a falaxi wo bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Isirayilakae, wo wo tuli mati. Won Marigi Alatala keren peti na a ra. ");
INSERT INTO sus_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Wo lan nɛ wo xa wo Marigi Alatala xanu wo bɔɲɛ fiixɛxi ra, wo nii ra, a nun wo sɛnbɛ birin na. ");
INSERT INTO sus_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","N yi masenyi naxan xaranxi wo bɛ yi ki, a xa lu wo bɔɲɛ ma. ");
INSERT INTO sus_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Wo fama nɛ a mabanbande wo xa die bɛ tɛmui birin, xa wo na banxi kui, xa wo na biyaasife, kɔɛ nun yanyi ra. ");
INSERT INTO sus_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","A xa xiri wo bɛlɛxɛ nun wo tigi ra tɔnxuma ra. ");
INSERT INTO sus_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Wo xa a sɛbɛ wo xa banxi nun wo xa naadɛ ma.» ");
INSERT INTO sus_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","«Wo Marigi Alatala na wo xanin tɛmui naxɛ bɔxi ma a na dɛnnaxɛ sofe wo yi ra, alɔ a rakali wo babae Iburahima, Isiyaga, a nun Yaxuba bɛ ki naxɛ, wo fama nɛ taa belebele tofanyie sɔtɔde wo mu naxee tixi, ");
INSERT INTO sus_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","banxi rafexie harige mɔɔli birin na wo mu naxee fenxi, kɔlɔnyie wo mu naxee gexi, wɛni bilie nun oliwi bilie wo mu naxee sixi. ");
INSERT INTO sus_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Wo na wo dɛge han wo naxa wasa tɛmui naxɛ, wo naxa nɛɛmu wo Marigi Alatala ma de, naxan wo raminixi konyiya kui Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Wo xa gaaxu wo Marigi Alatala ya ra. Wo xa a keren nan batu. Wo xa wo kali a xili nan na. ");
INSERT INTO sus_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Wo naxa ala gbɛtɛe batu de, mixie naxee batuma wo rabilinyi, ");
INSERT INTO sus_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","barima wo Marigi Alatala mu wama a firin nde xɔn. Xa na mu a ra a xɔnɔma nɛ wo ma, a man fa wo faxa.» ");
INSERT INTO sus_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","«Wo naxa wo Marigi Alatala mato de, alɔ wo naxan naba Masa. ");
INSERT INTO sus_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Wo xa wo Marigi Alatala xa sɛriyɛ, a xa masenyi, nun a xa yaamari rabatu tinxinyi kui a naxan soxi wo yi ra. ");
INSERT INTO sus_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Wo xa wo ɲɛrɛ tinxinyi kira ra. Alatala wama fe naxan birin xɔn ma, wo lan wo xa na nan naba. Na tɛmui wo fama nɛ hɛɛri sɔtɔde, wo fa bɔxi fanyi sɔtɔ Alatala a kali naxan na wo babae bɛ. ");
INSERT INTO sus_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Wo wo yaxuie kerima nɛ alɔ Alatala a masenxi ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","«Wo xa die na wo maxɔrin tɛmui naxɛ, ‹Munse na yi masenyi, yi sɛriyɛ, nun yi yaamari ra, won Marigi Alatala naxan soxi won yi ra yi ki?› ");
INSERT INTO sus_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Wo fama nɛ e yaabide, ‹Firawuna xa konyie nan nu muxu ra Misira bɔxi ma, Alatala fa muxu ramini naa a sɛnbɛ ra. ");
INSERT INTO sus_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Alatala naxa tɔnxuma nun kaabanako belebele magaaxuxie raba muxu ya xɔri Misirakae ra, Firawuna nun a xa denbaya birin na. ");
INSERT INTO sus_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","A muxu ramini nɛ Misira alako a xa muxu xanin bɔxi ma, a a kali dɛnnaxɛ xa fe ra won babae bɛ sofe ra won yi ra. ");
INSERT INTO sus_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Na tɛmui Alatala naxa muxu yaamari, a muxu xa yi sɛriyɛ birin nawali a rawali ki ma. Xa won gaaxu won Marigi Alatala ya ra, a hɛɛri nun simaya xɔnkuye fima nɛ won ma alɔ a na a rabafe ki naxɛ yakɔsi. ");
INSERT INTO sus_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Xa won sa won Marigi Alatala xa yaamari birin nabatu alɔ a masenxi won bɛ ki naxɛ, na findima nɛ tinxinyi ra won bɛ.›» ");
INSERT INTO sus_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","«Wo Marigi Alatala na wo xanin bɔxi ma tɛmui naxɛ, a dɛnnaxɛ fima wo ma, a fama nɛ si solofere keride naxee findi Xitikae, Girigasakae, Amorikae, Kanaankae, Peresikae, Hiwikae nun Yebusukae ra, si solofere naxee sɛnbɛ gbo wo bɛ, e man wuya wo bɛ. ");
INSERT INTO sus_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Wo Marigi Alatala na e lu wo sagoe tɛmui naxɛ, wo xutu sɔtɔma nɛ e ma, wo e halaki. Wo naxa saatɛ xiri wo tagi, wo man naxa kinikini e ma. ");
INSERT INTO sus_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Wo nun e tan naxa futi malan de. Wo naxa wo xa di ginɛe fi e xa di xɛmɛe ma, wo naxa ginɛe fan fen e ra wo xa di xɛmɛe bɛ. ");
INSERT INTO sus_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Xa na mu a ra yi xɔɲɛe fama nɛ wo xa die ratantande, e xa ala gbɛtɛe batu. Alatala xɔnɔma nɛ wo ma na tɛmui, a man fa wo faxa mafurenyi ra. ");
INSERT INTO sus_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Kira nan yi ki wo lan wo xa mini naxan na yi mixie bɛ. Wo xa e xa sɛrɛxɛbadee a nun e xa gɛmɛ batuxie birin kana. Wo xa e xa Asera wuri masolixie bolon, wo xa e xa kuye birin gan.» ");
INSERT INTO sus_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","«Wo bara findi wo Marigi Alatala xa ɲama ra. Wo Marigi Alatala bara wo tan nan sugandi duniɲa ɲama tagi bɛndɛ fuɲi fari, alako wo xa findi a yɛtɛ yati gbe ra. ");
INSERT INTO sus_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Alatala mu wo sugandixi wo xa ɲama xasabi xa fe xa ra, barima wo xurun si birin bɛ. ");
INSERT INTO sus_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Alatala wo tan nan sugandixi a xa xanunteya xa fe ra. A bara wa saatɛ rakamalife a naxan tongo wo benbae bɛ. Na nan a toxi a wo raminixi bɔxi ma a sɛnbɛ ra wo nu na konyiya kui dɛnnaxɛ. A naxa wo ba Firawuna yi ra, Misira mangɛ. ");
INSERT INTO sus_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Wo xa a kolon wo Marigi Alatala, nan keren peti na Ala ra. Ala findixi Fonisire Mangɛ nan na naxan a xa saatɛ rakamalima, naxan hɛɛri gbegbe fima wo ma. A na rabama wo bɔnsɔɛe bɛ naxee fama wo xanbi ra, naxee a xanuma, e man a xa yaamarie rabatu. ");
INSERT INTO sus_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Kɔnɔ a gbilenma nɛ mixie fɔxɔ ra naxee a xɔnma, a a xɔnnantee ralɔɛma nɛ keren na. ");
INSERT INTO sus_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Wo xa fɛntɛn n ma yaamari nun n ma sɛriyɛ ma n naxan soxi wo yi ra to lɔxɔɛ.» ");
INSERT INTO sus_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","«Xa wo wo ɲɛngi sa yi yaamari xɔn ma, wo naxa fɛntɛn a ma, wo Marigi Alatala fama a xa saatɛ rakamalide, a hɛɛri fima nɛ wo ma alɔ a rakalixi wo benbae bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","A wo xanuma nɛ, a barakɛ sa wo xa fe, a man wo rawuya. A di gbegbe barife ragiri wo ma. Wo fa bɔxi daxamui fan sɔtɔde, mɛngi, wɛni nɛɛnɛ nun ture. A man fa wo xa ningee nun wo xa xurusee rawuya. A yi birin nabama nɛ bɔxi ma, a rakali naxan na wo babae bɛ sofe ra wo yi. ");
INSERT INTO sus_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","A wo barakama nɛ dangife si birin na. Dibaritare mu fama lude wo ya ma, xɛmɛ ba, ginɛ ba, xa na mu a ra xuruse. ");
INSERT INTO sus_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Alatala wo ratangama nɛ fure dɔxɔɛ mɔɔli birin ma, a nun fe ɲaaxi birin ma wo naxee kolonxi Misira bɔxi ma. Kɔnɔ a yi fure rasanbama mixie nan ma naxee na wo raɲaaxu. ");
INSERT INTO sus_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Wo lan nɛ wo xa mixi birin faxa, wo Marigi Alatala naxee soma wo yi ra. Wo naxa kinikini e ma, wo man naxa e xa alae batu, alako e naxa wo ratantan.» ");
INSERT INTO sus_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","«Wo fama a maɲɔxunde wo bɔɲɛ ma, ‹Yi sie gbo dangife won tan na. Won tan nɔla sɔtɔma nee ma di?› ");
INSERT INTO sus_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Kɔnɔ, wo naxa gaaxu e ya ra. Wo xa ratu wo Marigi Alatala naxan nabaxi Firawuna nun Misira bɔxi ra. ");
INSERT INTO sus_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Wo bara fe xɔrɔxɔɛe to naxee dɔxɔxi e ma, tɔnxumae nun kaabanakoe naxee rabaxi. Wo bara wo Marigi Alatala sɛnbɛ to a wo ramini ki naxɛ Misira bɔxi ma. Na nan a toma wo Marigi Alatala na mɔɔli rabama ɲamanɛ birin na wo gaaxuxi naxee ya ra. ");
INSERT INTO sus_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Wo Marigi Alatala fama nɛ wo yaxuie birin halakide, hali naxee nɔxunma wo ma. ");
INSERT INTO sus_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Wo naxa gaaxu e ya ra, barima wo nun wo Marigi Alatala na a ra, Ala belebele naxan magaaxu.» ");
INSERT INTO sus_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","«Wo Marigi Alatala fama nɛ yi ɲama keride a xuri xuri ra wo ya i. Wo mu nɔma e birin faxade waxati keren bun, xa na mu a ra wula i subee fama nɛ wuyade, e wo tɔɔrɔ. ");
INSERT INTO sus_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Wo Marigi Alatala fama nɛ yi mixie sode wo yi ra. E ifuma nɛ kira ma, han e sa halaki. ");
INSERT INTO sus_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","A fama nɛ e xa mangɛe sode wo yi ra, wo e xili ralɔɛ. Mixi yo mu nɔma tide wo kanke. Wo e birin halakima nɛ.» ");
INSERT INTO sus_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","«Wo e xa ala yailanxie ganma nɛ. Wo naxa mila e xa xɛɛma nun gbeti ma naxan na kuyee ma. Wo naxa na findi wo gbe ra alako a naxa findi wo fan bɛ gantanyi ra, barima fe nan na ki wo Marigi Alatala naxan naharamuxi. ");
INSERT INTO sus_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Wo naxa na kuye mɔɔli ɲaaxi raso wo xa banxi kui de, alako wo naxa halaki alɔ kuyee. Wo nee findima se ɲaaxi nan na barima a raharamuxi.» ");
INSERT INTO sus_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","«Wo xa yi yaamari birin naba n naxan xaranfe wo bɛ to lɔxɔɛ. Na nan fama a niyade wo xa simaya sɔtɔ, wo fa findi ɲama gbegbe ra. Na tɛmui, wo nɔma yi bɔxi sɔtɔde alɔ Alatala a rakalixi wo babae bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Wo xa wo maɲɔxun ɲɛrɛ xɔnkuye ma wo Marigi Alatala naxan nagiri wo ma yi gbengberenyi igirife ra yi ɲɛ tongo naani bun ma. A yi fe xɔrɔxɔɛe rabaxi nɛ wo ra, alako wo xa wo yɛtɛ magoro, a xa wo mato, a xa nɔ a kolonde fe naxan na wo sondonmɛ ma. A man xa nɔ a kolonde xa wo wama a xa sɛriyɛ mabanbanfe. ");
INSERT INTO sus_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","A bara wo xa fe magoro, a bara wo raxi kaamɛ ra. A bara mana so wo yi ra, wo nun wo benbae mu donse naxan kolon. A a masen wo bɛ na ki nɛ, a ibunadama mu nɔma balode donse xa kansan xun na, kɔnɔ masenyi fan birin na naxan fatanxi Alatala ra. ");
INSERT INTO sus_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Wo xa donmae mu ɲɔnxi, wo sanyie mu funtuxi yi ɲɛ tongo naani bun ma. ");
INSERT INTO sus_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Wo lan nɛ wo xa a kolon a wo Marigi Alatala na wo xurufe nɛ alɔ baba a xa di xuruma ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Wo wo Marigi Alatala xa yaamari mabanban, wo xa wo yɛtɛ suxu alɔ a wama a xɔn ma ki naxɛ, wo man xa gaaxu a ya ra.» ");
INSERT INTO sus_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","«Wo Marigi Alatala wo rasoma nɛ bɔxi fanyi ma xuree nun dulonyie na dɛnnaxɛ. Ye gbegbe na na bɔxi bun ma, a man minima gulunba nun geya fari. ");
INSERT INTO sus_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Bɔxi na a ra mɛngi, fundenyi maniyɛ, wɛni bili, xɔrɛ, kinkirinsi, oliwi, nun kumi na dɛnnaxɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Taami mu ɲɔnma sɔnɔn, se birin fama nɛ lude wo yi ra. Wure fama nɛ minide gɛmɛe kui, wure gbeeli fan sɔtɔma nɛ geya kui.» ");
INSERT INTO sus_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","«Wo na wo dɛge han wo naxa luga, wo xa wo Marigi Alatala tantu yi bɔxi fanyi xa fe ra. ");
INSERT INTO sus_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Wo naxa wo yɛtɛ ranɛɛmu wo Marigi Alatala xa fe ma de, tondife a xa yaamari nun a xa sɛriyɛ rabatufe ra, n naxan xaranxi wo bɛ to lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Wo na wo dɛge han wo naxa luga, wo na banxie ti, wo naxa sabati e kui, ");
INSERT INTO sus_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","wo xa xurusee xungbe nun a lanmae na wuya, wo xa gbeti nun wo xa xɛɛma na gbo, wo harige birin na gbo, ");
INSERT INTO sus_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","wo xa fɛntɛn wo yɛtɛ ma a fanyi ra alako wo naxa wo yɛtɛ igbo han wo xa nɛɛmu wo Marigi Alatala ma, naxan wo raminixi Misira bɔxi ma konyiya kui. ");
INSERT INTO sus_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","A bara wo radangi gbengberen yire magaaxuxi ra, bɔximase xɔnɛ kanyi nun tali na dɛnnaxɛ, ye mu na bɔxi naxan ma. A naxa ye ramini fanye kui. ");
INSERT INTO sus_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","A naxa mana donse so wo yi ra gbengberenyi ma, wo benbae mu nu naxan kolon, alako a xa wo xa fe magoro, a xa wo mato, a fa nɔ fe fanyi rabade wo bɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Wo naxa a maɲɔxun de a wo sɛnbɛ nun wo xa kɔɔta nan yi harige fixi wo ma. ");
INSERT INTO sus_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Wo xa wo ratu wo Marigi Alatala ma, a tan nan yi sɛnbɛ fima wo ma, alako wo xa na harige birin sɔtɔ. A man bara saatɛ masen wo bɛ to lɔxɔɛ a naxan tongo a nun wo babae ra.» ");
INSERT INTO sus_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","«Xa wo nɛɛmu wo Marigi Alatala ma, xa wo bira ala gbɛtɛe batufe fɔxɔ ra, xa wo tuubi e bɛ, xa wo wo magoro e bɛ, n xa a fala wo bɛ to lɔxɔɛ, wo halakima nɛ. ");
INSERT INTO sus_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Iyo, wo halakima nɛ alɔ Alatala si gbɛtɛe halakixi ki naxɛ wo ya xɔri, barima wo mu wo tuli matixi wo Marigi Alatala xa masenyi ra.» ");
INSERT INTO sus_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","«Isirayilakae wo wo tuli mati. To lɔxɔɛ wo na sigafe Yurudɛn nan igiride. Wo fama nɛ sie ragide naxee gbo wo bɛ, e sɛnbɛ dangi wo ra. Wo fa e xa taae tongo naxee tɛtɛ itexi han. ");
INSERT INTO sus_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Wo fama Anaki xa die nan masɔtɔde, mixi sɛnbɛmae naxee gbangbalan, wo naxee kolon a fanyi ra. Wo bara a mɛ, e a falama, ‹Nde nɔma tide Anaki xa die ya i?› ");
INSERT INTO sus_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Wo nɔma a kolonde yakɔsi, a wo Marigi Alatala na a ɲɛrɛfe wo ya ra, alɔ tɛ naxan se birin kanama. A tan nan yati e halakima, a e xa fe magoro wo ya xɔri. Wo e kerima nɛ, wo e birin halakima nɛ alɔ wo Marigi Alatala a masenxi wo bɛ ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Wo Marigi Alatala na e keri wo ya ra tɛmui naxɛ, wo naxa wo yɛtɛ matɔxɔ de han wo xa a fala, ‹Alatala na a xɛɛxi muxu yi bɔxi masɔtɔxi muxu xa tinxinyi saabui ra.› E xa fe kobi raba na a toxi Alatala e kerixi beenun wo xa be li. ");
INSERT INTO sus_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Wo naxa a maɲɔxun de a wo be sɔtɔxi wo xa tinxinyi nun wo xa fanyi nan ma. Alatala yi sie kerima e xa yuge kobi nan ma, a man xa natɛ rakamali a naxan tongo wo babae Iburahima, Isiyaga, nun Yaxuba bɛ. ");
INSERT INTO sus_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Wo xa a kolon wo xa tinxinyi xa mu a niyaxi wo Marigi Alatala yi bɔxi fanyi soxi wo yi ra a xa findi wo gbe ra. Ɲama xurutare nan na wo ra.» ");
INSERT INTO sus_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","«Wo xa wo ratu a ma wo wo Marigi Alatala raxɔnɔ ki naxɛ gbengberenyi ma. Wo naxa nɛɛmu wo keli lɔxɔɛ ma Misira, han wo so lɔxɔɛ be, wo nu xurutareɲa rabama nɛ wo Marigi Alatala ra. ");
INSERT INTO sus_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Wo Alatala raxɔnɔ nɛ Xorebe geya fari han a naxa wa wo faxafe. ");
INSERT INTO sus_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","N to te geya fari alako n xa walaxɛ gɛmɛ daaxi tongo naxan findi saatɛ ra Alatala nun won tan tagi, n naxa yanyi tongo naani nun kɔɛ tongo naani raba geya fari, n mu taami don, n mu ye fan min. ");
INSERT INTO sus_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Alatala naxa yi walaxɛ gɛmɛ daaxi firinyie so n yi ra, a naxan sɛbɛ a xɔnyɛ ra. Alatala naxan fala wo bɛ tɛ tagi, wo nu malanxi lɔxɔɛ naxɛ geya fari, na birin sɛbɛxi walaxɛ ma.» ");
INSERT INTO sus_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","«Yi yanyi tongo naani nun yi kɔɛ tongo naani dangi xanbi, Alatala naxa yi walaxɛ gɛmɛ daaxi firinyi so n yi ra naxan findi saatɛ ra. ");
INSERT INTO sus_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Alatala naxa a fala n bɛ, ‹Keli, i xa goro mafuren barima i xa ɲama i naxan naminixi Misira bɔxi ra, e bara yangoe belebele raba, e bara e ba kira ma n naxan masen e bɛ, e bara kuye yailan wure raxunuxi ra.› ");
INSERT INTO sus_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Alatala man naxa yi masen n bɛ, ‹N bara a to yi ɲama, ɲama xurutare na a ra. ");
INSERT INTO sus_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Keli be, n xa e halaki, n xa e xili ɲɔn duniɲa ma. N i mafindima ɲama gbegbe ra naxan sɛnbɛ gbo, e man wuya, dangi boore ɲama ra.› ");
INSERT INTO sus_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","N naxa goro geya fari, naxan nu luxi alɔ a na tɛ nan tagi, na walaxɛ firinyie suxuxi n yi ra, Ala xa saatɛ sɛbɛxi naxee ma. ");
INSERT INTO sus_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Na tɛmui n naxa a to wo bara yunubi fe raba wo Marigi Alatala ra. Wo ninge yailan wure raxunuxi ra. Wo wo ba kira ma Alatala naxan masen wo bɛ. ");
INSERT INTO sus_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","N naxa yi walaxɛ gɛmɛ daaxi firinyie suxu n bɛlɛxɛ firinyi ra, n fa e wɔlɛ, e naxa ibɔɔ wo ya xɔri.» ");
INSERT INTO sus_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","«N naxa bira bɔxi Alatala ya i alɔ n naxan naba a singe. N naxa lu naa yanyi tongo naani nun kɔɛ tongo naani, n mu taami don, n mu ye fan min. N na birin naba wo xa yunubi nan ma fe ra, naxan naɲaaxuxi Alatala ma, a a raxɔnɔ. ");
INSERT INTO sus_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","N naxa gaaxu Alatala xa xɔnɛ ra a xɔnɔxi wo ma naxan ma han a wa wo halakife. Kɔnɔ Alatala man naxa n ma maxandi suxu. ");
INSERT INTO sus_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","A bɔɲɛ nu texi Haruna nan ma a gbe ra han a wa a halakife, kɔnɔ n naxa Ala maxandi Haruna fan bɛ. ");
INSERT INTO sus_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","N naxa ninge tongo wo naxan yailanxi, naxan findixi wo xa yunubi fe ra, n a woli tɛ xɔɔra, n a iwuru han a findi xube ra. N naxa na xube ibagan susui ye xɔɔra naxan kelima geya kɔn na.» ");
INSERT INTO sus_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","«Wo man bara Alatala raxɔnɔ Tabera, Masa, nun Kibiroti Hataawa. ");
INSERT INTO sus_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Alatala to wo xɛɛ kelife Kadesi Barineya yi xɛɛraya ra, ‹Wo siga, wo xa bɔxi tongo n naxan soxi wo yi ra,› wo naxa wo Marigi Alatala xui matandi. Wo mu la a fala xui ra, wo mu na fan suxu nɔndi ra. ");
INSERT INTO sus_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Kabi n naxa sa wo kolon, wo xurutare fe nan tun nabafe Alatala ra.» ");
INSERT INTO sus_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","«Alatala to wa wo faxafe, n naxa n felen bɔxi ma, n a maxandi yanyi tongo naani nun kɔɛ tongo naani bun ma. ");
INSERT INTO sus_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","N naxa Alatala maxandi, ‹Marigi Alatala, i naxa i yɛtɛ xa ɲama halaki, i ɲama naxan xa xɔrɛya soxi a yi i xa gboe saabui ra, i naxan naminixi Misira bɔxi ma i sɛnbɛ ra. ");
INSERT INTO sus_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","I ratu i xa konyie ma, Iburahima, Isiyaga, nun Yaxuba. I naxa i kobe rato yi ɲama xa xaxili xɔrɔxɔya ma, e xa ɲaaxui, nun e xa yunubi ma, ");
INSERT INTO sus_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","alako Misirakae naxa a fala, «Alatala mu nɔma yi mixie xaninde bɔxi ma a dɛnnaxɛ laayidi tongoxi e bɛ. A e xɔnxi nɛ. A e ramini alako a xa sa e faxa gbengberenyi ma.» › ");
INSERT INTO sus_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Alatala i xa ɲama nan lanxi e ma. I gbe nan na e ra, i naxee xɔrɛyaxi i sɛnbɛ nun i xa mangɛya ra.» ");
INSERT INTO sus_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","«Na tɛmui Alatala naxa yaamari fi n ma. A naxɛ, ‹Walaxɛ gɛmɛ daaxi firin yailan alɔ a singee nu ki naxɛ. I man xa kankira wuri daaxi yailan. Na tɛmui i xa fa n yire geya fari. ");
INSERT INTO sus_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","N man gbilenma nɛ yi sɛriyɛ sɛbɛ ra naxan nu na boore walaxɛe ma, i naxee kanaxi. I fama e sade na kankira nan kui.› ");
INSERT INTO sus_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","N naxa kankira yailan wuri mɔɔli nde ra naxan xɔrɔxɔ. N naxa walaxɛ gɛmɛ daaxi firin fan yailan naxan maniya booree ra. N naxa te e ra geya fari. ");
INSERT INTO sus_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Alatala naxa sɛbɛli ti yi walaxɛ nɛɛnɛe ma, alɔ naxan singe nu sɛbɛxi booree ma. Yi yaamari fu, a naxee yaxaran wo bɛ geya fari tɛ tagi wo nu malanxi tɛmui naxɛ, Alatala naxa e so n yi ra. ");
INSERT INTO sus_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","N naxa goro geya fari, n fa e sa kankira kui, n naxan yailanxi. E naxa lu naa alɔ Alatala a fala n bɛ ki naxɛ.» ");
INSERT INTO sus_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Isirayilakae naxa keli Bene Yakan kɔlɔnyie ra sigafe ra Mosera. Haruna laaxira mɛnni nɛ, a naxa bɛndɛ sɔtɔ naa. A xa di Eleyasari naxa findi a ɲɔxɔɛ ra sɛrɛxɛdubɛɲa kui. ");
INSERT INTO sus_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Na dangi xanbi Isirayilakae naxa siga Gudugoda. E to keli Gudugoda, e naxa siga Yotobata, xure gbegbe na bɔxi naxan ma. ");
INSERT INTO sus_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Na waxati bun ma, Alatala naxa wali taxu Lewi bɔnsɔɛ ra, e xa findi kankira xaninyie ra, e xa ti Alatala ya i a xa wali rabafe ma, e man xa duba ɲama bɛ Alatala xili ra. Na nan nabafe han to lɔxɔɛ. ");
INSERT INTO sus_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Na fe na a toxi Lewi bɔnsɔɛ mu kɛ sɔtɔxi e ngaxakerenyie ya ma. Alatala nan na e tan malima ra alɔ a a fala ki naxɛ. ");
INSERT INTO sus_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","«N naxa lu geya fari yanyi tongo naani nun kɔɛ tongo naani alɔ n naxan naba singe ra. Alatala man naxa n ma maxandi suxu, barima a mu waxi wo faxafe. ");
INSERT INTO sus_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Alatala naxa a masen n bɛ, ‹Ɲama raɲɛrɛ. E xa so bɔxi ma n nan nakalixi naxan na e babae bɛ sofe ra e yi.›» ");
INSERT INTO sus_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","«Yakɔsi fa, Isirayilakae wo Marigi Alatala wama wo xa munse raba? A wama nɛ wo xa gaaxu a ya ra alako wo xa wo ɲɛrɛ a xa kira xɔn ma, wo xa a xanu, wo xa a rabatu wo bɔɲɛ fiixɛ nun wo nii birin na. ");
INSERT INTO sus_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Alatala wama nɛ wo xa a xa yaamari raba, wo xa a xa sɛriyɛ rabatu, n naxan soxi wo yi ra to lɔxɔɛ, alako wo xa simaya xa fan. ");
INSERT INTO sus_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Wo Marigi Alatala nan gbe na koore nun bɔxi ra, a nun se naxan birin na a ma. ");
INSERT INTO sus_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Alatala wo babae nan xanu. Yakɔsi fa wo tan nan na e bɔnsɔɛ ra, a wo tan nan sugandixi boore sie tagi, alɔ wo a toxi ki naxɛ to lɔxɔɛ.» ");
INSERT INTO sus_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","«Wo lan nɛ wo xa wo xaxili rasɛniyɛn, wo naxa xurutareɲa raba sɔnɔn, ");
INSERT INTO sus_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","barima wo Marigi Alatala keren peti nan na Ala ra, mangɛe xa mangɛ, Ala belebele sɛnbɛma magaaxuxi, naxan mu mixi rafisa a boore bɛ, naxan mu kiiti ɲaaxi kɔbiri rasuxuma. ");
INSERT INTO sus_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","A tan nan kiridie nun kaaɲɛ ginɛe kantama ra. Xɔɲɛe rafan a ma, a donse nun sose soma e yi ra. ");
INSERT INTO sus_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Wo tan fan, wo hinnɛ xɔɲɛe ra naxee na wo ya ma. Wo xa wo maɲɔxun xɔɲɛ nan nu na wo tan fan na Misira bɔxi ma. ");
INSERT INTO sus_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Wo xa gaaxu wo Marigi Alatala ya ra, wo xa tuubi a bɛ, wo xa bira a fɔxɔ ra, wo man xa wo rakali a tan nan xili ra. ");
INSERT INTO sus_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","A tan nan na wo xa nɔrɛ ra. A tan nan na wo Marigi Ala ra, naxan kaabanakoe nun fe magaaxuxie rabaxi wo ya xɔri. ");
INSERT INTO sus_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Wo babae nu fama tɛmui naxɛ Misira, e mu nu dangixi mixi tongo solofere ra. Yakɔsi wo Marigi Alatala bara wo rawuya dangi tunbuie ra naxee na koore ma.» ");
INSERT INTO sus_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Wo xa wo Marigi Alatala xanu, wo tuubi a bɛ, wo xa a xa yaamari, a xa sɛriyɛ, a xa masenyi, nun a xa tɔnyi rabatu tɛmui birin. ");
INSERT INTO sus_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Wo xa a kolon to lɔxɔɛ wo xa die mu Alatala xa kaabanako magaaxuxie toxi e ya ra. E mu wo Marigi Alatala xa sɛriyɛ mɛxi e tuli ra. ");
INSERT INTO sus_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","