﻿USE sofia;
DROP TABLE IF EXISTS sofia.sur_vpl;
CREATE TABLE sur_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sur_vpl WRITE;
INSERT INTO sur_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɗesǝ a shee pwoo ɗeret nkaa Jesu Kristi Nguɓam, Làa Naan. ");
INSERT INTO sur_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kaaɗe gyet mo kǝ ten ran nɗǝǝn ɓǝǝt haal mǝ Aizaya ngusatpwoo Naan sǝ nǝnee, <<Naan wur sat nǝ, an nlep ngulep fen shindǝm a kyeen fwaa, <<mbǝkǝ wur ɗak ar fwaa ɗi. ");
INSERT INTO sur_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mee gwar kǝ pǝreppee shi ɗoo ɗeɗes a naaryil, <Wur ɗak ar nDaa Wur aar ar nwur ndir-ndir!> >> ");
INSERT INTO sur_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Joon ngucìn baptisma, a wur jì put a naaryil. Wur satpwoo Naan ngurum mo, mbǝkǝ mmo tuwap ɗi, kǝ nwur cìn baptisma ɗi mmo, mbe fwo kǝ shikbish mo-mo. ");
INSERT INTO sur_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nenyil nJudiya mo, kǝ nenyil nJerusalem mo ɗes, mo pwat dǝm pee Joon ɗi, ɗe mo woo shikbish fur mo, ɓe wur cìn baptisma mmo nɗǝǝn gyeen nJodan. ");
INSERT INTO sur_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joon lep a nlǝr ɗe mo ɗak shi shweep raakumi, wur kǝ ɗyiin zaal ɗe mo ɗak shi shim shin ciir mɓwoon fin. Wur kǝ se a ciɓel, kǝ nloor nshìi ɗe mo a yil. ");
INSERT INTO sur_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wur sat ngurum mo nǝnee, <<Mee gwar pǝ jì mɓwoon fen, ɗe, wur ɗes met nghan, kǝ baa ɗeret fen nǝ mak, kǝ nghan ɗoom mbǝkǝ nghan fwen teng kwoopshi wur ɗi kas. ");
INSERT INTO sur_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wen kǝn cìn baptisma nwun a shi am, ɗangɓǝ gwar nǝ wur njì ɓe wur ncìn baptisma nwun a shi Riin Ɗeɓang.>> ");
INSERT INTO sur_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","nƊǝǝn teer mǝnǝ mo, ɓǝ Jesu yool nyil nNazaret mǝ Galili, kǝ wur dǝm pǝ Joon ɗi gyeen nJodan, ɓe Joon cìn baptisma nwur nɗǝǝn gyeen nJodan nǝ. ");
INSERT INTO sur_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kaaɗe Jesu nkaa put nɗǝǝn am nǝ, ɓe abet, wur naa ɗengnaan a wuwang. Ɓe Riin sham kaa mbul sǝ, nǝ sham lang nkaa wur. ");
INSERT INTO sur_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kǝzak, mee ɗoo put nɗǝǝn ɗengnaan ɗe nǝ sat nǝnee, <<Gha a Làa fen ɗe nwal gha, kǝ kat retnyit kǝ gha hakyeng.>> ");
INSERT INTO sur_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Abet-abet, ɓǝ Riin Naan dǝm kǝ Jesu a naaryil. ");
INSERT INTO sur_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesu cìn teer laarfeer a yil nǝ, a peeɗi ngujwaan kam wur ɗi. Wur yem ashak kǝ luwaa yil mo. Nenlep Naan mo jì ɓam wur ");
INSERT INTO sur_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aɓwoon ɗe mo kǝ yaa Joon le nɗǝǝn lushoot, ɓǝ Jesu dǝm wul nGalili, wur nkaa satpwoo ɗeret mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wur sat ngurum mo nǝnee, <<Pee nǝ kǝ wul, kǝ mulki kǝ Naan nǝ kus zak. Wu tuwap, wu shinzeen mpwoo ɗeret nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kaaɗe Jesu a ar ɗel mpwoo am kuur mǝ Galili, ɓǝ wur naa Simon Pita kǝ ɗyemnǝǝn fin Andru, mon nkaa bwet shang mɓut am, mbe yak pupwap mo. ");
INSERT INTO sur_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ɓe Jesu wur sat mmo nǝnee, <<Wu jì nɗang nghan, ɓe nghan nle kǝ wu ɗee a nensatpwo kǝ Naan, mbǝkǝ wu dul gurum mo shin jì pee nghan ɗi kaaɗi wuu yak pupwap sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Abet, ɓe mo yool yit shang fur mo, ɓe mo dǝm nɗang wur. ");
INSERT INTO sur_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kaaɗe wur gyes dǝm ɗe a kyeen lee, ɓe wur naa Jemis làa Zeɓeɗi, kǝ ɗyemnǝǝn fin Joon, mo nɗǝǝn tii zak. Mon nkaa ɗak shang fur mo. ");
INSERT INTO sur_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Abet, ɓe wur pet mo. Ɓe mo yool yit puun fur Zeɓeɗi nɗǝǝn tii nǝ, ashak kǝ nen ɗe moo cìn ɗak mmo. Ɓe mo dǝm nɗang Jesu. ");
INSERT INTO sur_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mo dǝm nɗǝǝn Kaparnahum, ɓe Jesu ɗel nɗǝǝn mee lu Naan parpuus Nookɗi. Ɓe wur yaa kámpwoo Naan ngurum mo. ");
INSERT INTO sur_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kám wur nǝ aapwoo mmo zam, mbǝɗe wu kám a kaa gwar ɗe wu kǝ iiko sǝ, baa a kaa nenkám Wàar Mosis mo sǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mee gwar wu kǝ riin ɗebish, nɗǝǝn lu Naan nǝ, ɓe gwar nǝ ɓwet or. ");
INSERT INTO sur_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wur sat nee, <<Jesu ngwe Nazaret, a me kaat mun kǝ gha ye? A jì mpesi a mbe twe mun aa? Wen man nǝ, gha a gwar ɗeɓang mǝ Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu gwak riin ɗebish nǝnee, <<A ɗok tǝtǝk! A put aku nɗǝǝn gwar nǝ!>> ");
INSERT INTO sur_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kaaɗe riin ɗebish nǝ yoon gwar nǝ ɓal-ɓal, ɓe nǝ le or shiɓal, ɓe nǝ put nɗǝǝn gwar nǝ. ");
INSERT INTO sur_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne aapwoo gurum nǝ mo jir, har mo ɗoom tal pushak nǝ, <<A me nɗesǝ ye? A mee kám ɗepoo nɗesi! Wu satpwoo shi iiko, ɓe har riin ɗebish mo cìn mbii ɗe wu sat.>> ");
INSERT INTO sur_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Abet ɓe pwoo nkaa Jesu nǝ put dǝm nɗǝǝn yil ɗe mo neer Galili ciirkaat jir. ");
INSERT INTO sur_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kaaɗe mo pwat nɗǝǝn lu Naan nǝ, ɓe mo dǝm ntul Simon Pita kǝ Andru, ashak kǝ Jemis kǝ Joon. ");
INSERT INTO sur_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ɓe mo kat nǝǝnkaam Pita waa saam kǝ cilem. Abet ɓe mo sat nJesu. ");
INSERT INTO sur_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɓe wur jì yaa sar waa, wu ɗyeep waa tong a tǝng, ɓe cilem nǝ kyes nwar, ɓe war cìn ɗak mbiise mmo. ");
INSERT INTO sur_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nkansǝǝn, kaaɗi puus nǝ ɗoom taa nlu, ɓe gurum mo jì kǝ nen ciinkoom mo ɗes, ɗe mo kǝ riin ɗebish mo pee Jesu ɗi. ");
INSERT INTO sur_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nen yilkaam nǝ mo jir, mo jì kuur mpolu nǝ. ");
INSERT INTO sur_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu bar nenciinkoom mo ɗes, kǝ shwal mo shini-shini, wu pwat kǝ riin ɗebish mo ɗes zak. Baa wu yit kǝ riin ɗebish nǝ mo leshap ɗe kas, mbǝɗe mo kǝ man wur. ");
INSERT INTO sur_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ɗaar nǝ, ɓe Jesu yool put mpar-mpar, ɓe wur dǝm a peeɗi baa mee gurum ɗi kas, mbe wur ɗangnaan (leshap kǝ Naan). ");
INSERT INTO sur_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pita kǝ nen ɗe mo ashak kǝ wur, mo pwat dǝm mbe yap wur. ");
INSERT INTO sur_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kaaɗe mo kat wur, ɓe mo sat nwur nǝnee, <<Gurum mo jir mo nkaa yap gha.>> ");
INSERT INTO sur_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu sat mmo nǝnee, <<Wu yit kǝ mu dǝm njep yil ɗe mo akyeen sǝ, mbǝkǝ nghan dǝm nsatpwo Naan ɗi nyil mǝnǝ mo zak. Mbǝɗe wen jì a mbe satpwoo Naan nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mbǝmǝnǝ, ɓe wu dǝm nɗǝǝn yil nGalili jir, wu satpwoo Naan ngurum mo nɗǝǝn lu Naan mo, kǝ wur pwat kǝ riin ɗebish mo zak. ");
INSERT INTO sur_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mee nguloom jì kurum nfurum ntoom Jesu, ɓe wu ɗang pǝ Jesu nǝnee, <<Katɗang a rǝɓet, ɓe gha mak bar nghan kǝ wen ɗee ɗi a ɗeɓang.>> ");
INSERT INTO sur_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu naajeel gwar nǝ, ɓe wu zan sar fin, wu tung gwar nǝ, ɗang wur sat ngwar nǝ nǝnee, <<wen nlap ii, aa bar. ");
INSERT INTO sur_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Abet, ɓe loom nǝ kyes, ɓe gwar nǝ zum. ");
INSERT INTO sur_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu satpwoo ngwar nǝ shiɓal. Ɓe wur ɓwet gwar nǝ abet-abet. ");
INSERT INTO sur_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ɓe wur sat ngwar nǝnee, <<A tap, taji a sat mee mbii mmee gurum kas. Ɗangɓe a dǝm a kam sak fwaa mpris, mbǝkǝ wur naa gha ɗi, kǝ a shin zuum ɗi zak, kaaɗi gyet Mosis sat nǝ, nen ɗe mo ke ten zum, ɓe mo shin mbiizuum, mbǝkǝ gurum mo man nnǝ moo ke ɗee a ɗebǝbar.>> ");
INSERT INTO sur_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɗangɓe gwar nǝ wur put, ɓe wur yaa satpwoo nǝ gurum mo ɗes, ɓe pwoo nǝ kaatpee jir, har nǝ le kǝ baa Jesu mak baa ɗel nɗǝǝn yil nǝ agaak kas. Ɗangɓe wur tong a peeɗi baa mee gurum mo ɗe kas. Jir kǝsǝ, ɓe gurum mo pwat shipee-shipee, mo dǝm pee wur ɗi. ");
INSERT INTO sur_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","mƁwoon jep teer mo ɓe Jesu wur ɗel nɗǝǝn Kaparnahum, ɓe gurum mo kǝlǝng nǝ, wur waaji ntul. ");
INSERT INTO sur_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gurum mo ɗes mo gam lu nǝ, har mpolu, ɗe baa mee pee ɗenshii ɗi kas. Jesu nkaa satpwoo Naan mmo. ");
INSERT INTO sur_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɓe mee des mo feer, mo jì kǝ mee gwar ɗe foshik wur fii, pee Jesu ɗi. ");
INSERT INTO sur_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbǝ ɗuu gurum nǝ mo, ɓe baa mo mak dǝm kǝ gwar nǝ kus pee Jesu ɗe kas. Ɗangɓǝ mo kàa tap wang ɗeng lu nǝ nciit kǝ pee ɗi Jesu wur nɗǝǝn nǝ. Kaaɗe mo wang ɗeng lu nǝ, ɓe mo lep gwar nǝ sham nkaa mbiisaam, ɗe gwar nii saam nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kaaɗe Jesu naa shinzeen mo nǝ, ɓe wu sat ngwe foshik ɗe fii nǝ nǝnee, <<Làa fen, mo kǝ fwo shikbish fwaa mo ngha.>> ");
INSERT INTO sur_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɗangɓe pak nenkám Wàar Mosis mo, ɗe moo tong ɗe, mo nkaa pan nɗǝǝn pǝtuup fur mo nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<A me le ɗang gwar ɗesǝ wur sat pwoo mǝnǝ ye? Wur leshin kaa Naan sǝ! Baa mee gurum mak fwo shikbish kas, see Naan bǝshin ɓejee ɗak.>> ");
INSERT INTO sur_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Abet, ɓe Jesu man mbii ɗe moo pan nǝ nɗǝǝn pǝtuup fur mo, ɓe wur sat mmo nǝnee, <<A mi le ɗang wuu pan mbii ɗesǝ mo nɗǝǝn pǝtuup fuu mo ye? ");
INSERT INTO sur_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A ɗeɗang fiyeel met ye? Ɗe wen nsat nguciinkoom nǝnee, <mo kǝ fwo shikbish fwaa mo ngha,> aa koo ɗe wen nsat nwur nǝnee, <A yool a mang mbiisaam fwaa a mwaan> yi? ");
INSERT INTO sur_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ɗangɓǝ mbǝkǝ wu man ɗe nǝ, Làa Gurum, wur kǝ iiko nkaa yil nǝ, mbe fwo shikbish mo. Ɓe Jesu sat ngwar ɗe foshik wur fii nǝ, nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<Wen sat gha, a yool, a mang mbiisaam fwaa a dǝm ntul>> ");
INSERT INTO sur_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Abet, ɓe gwar nǝ wur yool, wur mang mbiisaam fin, ɓe wur put dǝm ntul a yit mo jir. Ɓe nǝ aapwoo mo jir, ɓe mo kwoop Naan, mo sat nǝ, <<Baa muu cam naa mee mbii aapwoo kaa ɗesǝ sǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu put dǝm mpwoo am kuur zak, ɓe gurum mo ɗes, mo jì kuur pee wur ɗe. Ɓe wu yaa kámpwoo Naan mmo. ");
INSERT INTO sur_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ɓe kaaɗi wur a ar ɗel dǝm, ɓe wur naa Livai làa Alfiyas, wur tong a peelap shool wap. Jesu sat nwur nǝnee, <<A jì nɗang an.>> Ɓe Livai wur yool taa nɗang Jesu. ");
INSERT INTO sur_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kaaɗe Jesu dǝm tong a peese mbiise nlu Livai, ɓe nenlapwap mo ɗes, kǝ nenshikbish mo, nen ɗe baa moo kyeer Wàar Mosis kas, kǝ pak gurum mo ɗes, mo jì tong ashak kǝ Jesu kǝ jeplep wur mo, a peese mbiise nǝ. ");
INSERT INTO sur_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ɓe nenkám Wàar nMosis mo, ɗe mo a nen Farisi mo, mo naa Jesu wur nkaa sese ashak kǝ nenshikbish mo, kǝ nenlapwap mo. Ɓe mo sat jeplep mo nǝnee, <<A me le ɗang Jesu wur sese ashak kǝ nenlapwap mo, kǝ nenshikbish mo yi?>> ");
INSERT INTO sur_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kaaɗe Jesu kǝlǝng pwoo mǝnǝ, ɓe wur lap mmo nǝnee, <<Baa nen ɗe mon nkoom, mon nyap nguyen kas, amma a nen ɗe mo a gok. Baa wen jì a mbe pet nen ɗe ndere mo kas, amma wen jì a mbe pet nenshikbish mo.>> ");
INSERT INTO sur_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nenlep nJoon mo, kǝ nen Farisi mo, mon nkaa wet kǝ neen. Pak gurum mo jì pee Jesu ɗi, mo tal pǝ wur nǝnee, <<A me le ɗangɓe nenlep nJoon mo, kǝ mǝ nen Farisi mo, moo wet kǝ neen, ɗangɓǝ baa jeplep fwaa, moo wet kǝ neen kas yi?>> ");
INSERT INTO sur_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu lap mmo nǝnee, <<Wu yee nǝ, nǝn mmak cìn kǝ mǝzep ɗe mo a pee serǝɓet mǝ ɗyik, mon ntong kǝ neen, ɓe mish kǝ matpoo nǝ wur ɗe ashak kǝ mo me? Katɗang mish matpoo nǝ wur kuɗi ashak kǝ mo, ɓe baa mon mmak wet kǝ neen kas. ");
INSERT INTO sur_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɗangɓǝ puus nǝ mon njì, ɗe mon mmang mish nǝ nkaa mo. Ɗangɓe, mon ntong kǝ neen nɗǝǝn teer mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Baa mee gurum mak luwas nlǝr ɗesǝǝr shi fuwaat ɗepoo kas, katɗang wu cìn kǝsǝ, ɓe fuwaat ɗepoo, ɗe wu luwas nlǝr ɗesǝǝr nǝ ɗishik, nǝn nkur, ɓe nǝn nwaa tee nlǝr ɗesǝǝr nǝ, ɓe tee mǝnǝn nɗes met nɗinshee. ");
INSERT INTO sur_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kǝzak, baa mee gurum mak ɗoo am anab ɗepoo nɗǝǝn tuulshim ɗesǝǝr mo kas. Katɗang wur cìn kǝsǝ, ɓe am anab ɗepoo nǝn mpyan tuulshim ɗesǝǝr nǝ mo, kǝ am anab nǝn mɓeer, kǝ tuulshim nǝ mon ntee zak. Amma moo ɗoo am anab ɗepoo a nɗǝǝn tuulshim ɗepoo mo.>> ");
INSERT INTO sur_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mee parpuus Nookɗi, ɓe Jesu yaa ar ɗel mɓut mmaar ɗǝɓen. Kaaɗe mo a ar ɗel nǝ, ɓe nenɗǝm nɗang Jesu mo ɗoom cǝlang pak ɗǝɓen nǝ. ");
INSERT INTO sur_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nen Farisi mo sat nJesu nǝnee, <<A naa jeplep fwaa mo nkaa cìn mbii ɗe baa nǝ ret kǝ mo cìn mǝnǝ parpuus Nookɗi kas.>> ");
INSERT INTO sur_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu lap mmo nǝnee, <<Ashee, baa wuu cam tang mbii ɗe mo ran nɗǝǝn ɓǝǝt haal Naan nkaa mbii ɗe gyet Devit, kǝ nenyil ɗe mo ashak kǝ wur mo cìn, kaaɗi gyet neenláa wur kǝ nenyil ɗe mo ashak kǝ wur kas se? ");
INSERT INTO sur_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Gyet wur ɗel nɗǝǝn Lu Naan ɗǝǝɗes, ɓe wur mang gǝǝl aas ɗe mo kǝ ten shin nǝn nNaan, wur se, kǝ wur shin pak nenyil ɗe mo ashak kǝ wur. Gǝǝl aas ɗe baa a mee gurum buu mak se nǝ kas, see a pris mo ɗak. Gyet wur ɗel Lu Naan ɗǝǝɗes nǝ a mɓít ɗe Abiyata wur a pris ɗǝǝɗes met jir.>> ");
INSERT INTO sur_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu sat mmo nǝ, <<Mo le parpuus Nookɗi nǝ a mbe gurum, baa mo le a gurum mbe parpuus Nookɗi nǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɗesǝ nǝ kám nǝ, Làa Gurum, wur a Daa mǝ puus Nookɗi nǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesu waa baa ɗel nɗǝǝn mee lu Naan. Ɓe mee gwar ɗi nlu nǝ, ɗe sar wur fii. ");
INSERT INTO sur_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pak gurum mo leyit fur mo nkaa Jesu, mbǝkǝ mo naa ɗe. Kyet wur mbar gwar nǝ mpuus Nookɗi wa? Mbǝkǝ mo kat mbii cìn mwaanaa ɗi. ");
INSERT INTO sur_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu sat gwar ɗe sar wur nǝ fii nǝnee, <<A yool a jì a ɗar sǝ agaak.>> ");
INSERT INTO sur_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɓe wur tal pǝ mo nǝnee, <<Kyet Wàar Mosis nǝ sat nǝ, mu cìn a mbii ɗeret mpuus Nookɗi, aa koo mu cìn a mbii ɗebish ye? Mu ɓam seen gurum aa, koo mu tutu seen nǝ ye?>> Amma mo ɗok tǝtǝk. ");
INSERT INTO sur_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu naa mo shi tuup, mbǝɗe nǝ shwal nwur mɓut mɓe ɓalkáa kǝ mo nǝ, ɓǝ wur sat ngwar nǝnee, <<A zan sar fwaa.>> Ɓe gwar nǝ zan sar nǝ, ɓe sar wur nǝ zuum. ");
INSERT INTO sur_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nen Farisi mo pwat, ɓǝ abet, mo dǝm ɓwolpwoo ashak kǝ nen nHerot mo, mbǝkǝ mo yap ar ɗe mon ntu Jesu ɗe. ");
INSERT INTO sur_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu yool dǝm mpwoo am kuur, ashak kǝ nenɗǝm nɗang wur mo, ɓe nen Galili mo, kǝ nen Judiya mo ɗes, mo dǝm nɗang wur, ");
INSERT INTO sur_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kǝ nen ɗe mo nkwang nJerusalem, kǝ nkwang Idumiya, kǝ canɗel nkwang Jodan, kǝ nkwang yil nTaya kǝ Sidon zak. Gurum mo ɗes mo jì pee Jesu ɗi. Mɓeɗi mo kǝlǝng mbii ɗewur cìn mo jir. ");
INSERT INTO sur_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesu sat njeplep fir mo, kǝ mo tang mee tii le nwur kus, mbǝkǝ taji ɗuu gurum nǝ mo jyar jì ɗwat wur ɗe kas. ");
INSERT INTO sur_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mɓeɗi wur kǝ bar gurum mo ɗes, ɓe nenciinkoom mo ɗe nkaa jì, mbǝkǝ mo tung wur ɗe. ");
INSERT INTO sur_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kǝ nen ɗe mo kǝ riin ɗebish mo, katɗang mo naa wur, ɓe mmo taa ntoom nwur, ɓe mo bwet or nǝnee, <<Gha a Làa Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɗangɓe Jesu sat nriin ɗebish nǝ mo shiɓal hakyeng, nǝ, Taji mo woo wuɗi kas. ");
INSERT INTO sur_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesu kaa aɗeng jwak, ɓe wur pǝrep nen ɗewur rǝɓet mo, ɓe mo jì pee wur ɗi. ");
INSERT INTO sur_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wur bǝlǝp gurum mo kaapaat baavǝl, mbǝkǝ mo ɗee ɗe a jeplep nwur mo, kǝ mo tong ɗi ashak kǝ wur, kǝ wur lep mo ɗe mɓe satpwoo Naan. ");
INSERT INTO sur_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wur shin mbal mo mbe ceen riin ɗebish mo zak. ");
INSERT INTO sur_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sǝm nen ɗewur bǝlǝp mo kaapaat baavǝl nǝ, mo a Simon, ɗe Jesu le sǝm nwur a Pita. ");
INSERT INTO sur_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Kǝ Jemis làa Zeɓeɗi, kǝ Joon ɗyemnǝǝn Jemis, wur le sǝm mo a Bowanarjis, ɗe shii mǝnǝ nǝ, (moo cìn mbii a koo nluu ɗe nii petpee sǝ.) ");
INSERT INTO sur_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kǝ Andru, kǝ Filip, kǝ Bartolomi, kǝ Matiyu, kǝ Tomas, kǝ Jemis làa Alfiyas, kǝ Taddawus, kǝ Simon, ɗe moo pet wur a Zeelot. ");
INSERT INTO sur_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Kǝ Judas Iskariyot, gwar ɗewur ji seet kǝ Jesu sǝ. ");
INSERT INTO sur_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesu waa baa ntul zak. Ɓe gurum mo ɗes mo waa baaji kuur pee wur ɗi zak, har nǝ le kǝ baa Jesu kǝ jeplep wur mo mak se mbiise kas. ");
INSERT INTO sur_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kaaɗe nen wur mo kǝlǝng nǝ, baa wur mak katpee mbe se mbiise kas, kǝ mo kǝlǝng gurum moo sat nǝ, Jesu kǝ tar, ɓe mo dǝm mbe yaa wur. ");
INSERT INTO sur_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pak nenkám Wàar Mosis ɗe mo pwat nJerusalem ji, mo sat zak nǝnee, <<Jesu kǝ Beelzebul, ɗe nǝ a mishkoom mǝ riin ɗebish mo, kǝ wur kǝ ceen riin ɗebish mo a shiɓal mǝ mishkom kǝ riin ɗebish mo.>> ");
INSERT INTO sur_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu pǝrep mo jì kus, ɓe wur sat Sǝmpwoo mo nǝnee, <<Cinarang ɗangɓe ngujwaan nwaa ceen ngujwaan put yi? ");
INSERT INTO sur_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Katɗang ɓe mee yil ɗǝdes ɓàk set vǝl, mɓe cìn lek kǝ set, ɓe yil ɗǝdes mǝnǝn nleng. ");
INSERT INTO sur_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Katɗang ɓe mee nentul mo ɓàk sut vǝl, mbe cìn lek kǝ shak, ɓe tul mǝnǝn nleng. ");
INSERT INTO sur_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","mBe mǝnǝ, kaɗang ɓe ngujwaan wur ɓàk mulki wur ɗe vǝl, mbe cìn lek kǝ foshik wur, ɓe baa mulki wur nǝn nɗar kas, ɓe a kyes wur nǝ mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Baa mee gurum mak ɗel ntul nguɓal, mbǝkǝ wur hǝr long wur ɗǝ kas, see koo wur shee ɓwot nguɓal nǝ akuɗang, ɓe wur mmak hǝr long wur nǝ. ");
INSERT INTO sur_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","<<Azeen, kǝn sat nwun nǝ, shikbish ɗe gurum moo cìn, kǝ pwoo ɗebish ɗe moo sat, ɓe Naan wur nfwo shikbish mǝnǝn ngurum mo. ");
INSERT INTO sur_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɗangɓǝ katɗang mee gwar cìn shikbish, nkaa Riin Naan, ɓe baa Naan nfwo gwar mǝnǝ kas, mɓe vit. Mɓeɗi wu cìn a shikbish ɗe baa Naan cam fwo nǝ nwur kas har ngaa-ngaa.>> ");
INSERT INTO sur_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu satpwoo ɗesǝ a mbǝɗe pak gurum moo sat nǝnee, <<Wur kǝ riin ɗebish.>> ");
INSERT INTO sur_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nǝǝn Jesu kǝ ɗyemnǝǝn wur mo jì ɗar atǝleng, ɓe mo lep mee gurum ɗel pet wur. ");
INSERT INTO sur_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gurum mo ɗes mo tong neer Jesu cǝǝrkaat, mo sat nwur nǝnee, <<Nǝǝn fwaa, kǝ ɗyemnǝǝn fwaa moo rǝɓet naa gha atǝleng.>> ");
INSERT INTO sur_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu sat mmo nǝnee, <<A wii a nǝǝn fen, kǝ a wii mo a ɗyemnǝǝn fen yi?>> ");
INSERT INTO sur_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɓe wur lyap nen ɗe moo tong neer wur cǝǝrkaat, ɓe wur sat mmo nǝnee, <<Wu naa, a nǝǝn fen, kǝ ɗyemnǝǝn fen mon nɗesi! ");
INSERT INTO sur_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngwar ɗewur cìn ɗyen kǝ Naan, ɓe a gwar mǝnǝ a ɗyemnǝǝn fen ɗemish, kǝ ɗyemnǝǝn fen ɗe mat, kǝ nǝǝn fen zak.>> ");
INSERT INTO sur_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesu waa baa yaa kám-kam ɗe ngurum mo mpwoo am kuur nǝ. Ɓe gurum mo ɗes mo jì kuur pee wur ɗi. Mbe ɗuu kǝ gurum nǝ mo, ɓe Jesu ɗel tong nɗǝǝn tii nkaa am nǝ, ɓe ɗuu kǝ gurum nǝ mo jì ɗar pǝkom am kuur nǝ. ");
INSERT INTO sur_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesu kám mbii mo ngurum mo ɗes shi sǝmpwoo mo. Nɗǝǝn kám wur nǝ mo, ɓe wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<wu lekom! Gyet mee ngumaar wur put dǝm mɓe ɓwet cirem mɓut mmaar. ");
INSERT INTO sur_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɓe kaaɗi wur nkaa ɓwet cirem nǝ, ɓe pak cirem nǝ mo taa nkaa ar, ɓe nyer mo sham cak cirem nǝ se. ");
INSERT INTO sur_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pak cirem nǝ mo taa nkaa kwoop, a peeɗi baa nǝ kǝ yil ɗes kas. Abet, ɓe cirem nǝ mo ciir kàa. ");
INSERT INTO sur_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kaaɗe puuskàa ɓe mo caan har mo fii, mbǝɗe baa mo kat yil ɗes mbe sham seen kas. ");
INSERT INTO sur_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pak cirem nǝ mo taa mɓut nhǝr mo, ɓe mo kàa wurang nɗǝǝn hǝr nǝ mo, ɓe hǝr nǝ mo tǝreng káa mmo, ɓe baa mo le mee aa kas. ");
INSERT INTO sur_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pak cirem nǝ mo taa nkaa yil ɗeret, ɓe mo kàa wurang rǝret, kǝ mo le àa ɗes. Memee le àa mo laarkun, kǝ memee le mo laarpeemee, kǝ memee le mo kambil.>> ");
INSERT INTO sur_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesu sat nǝnee, <<Ngwar ɗewur kǝ koom mǝ kǝlǝngpee, ɓe nǝ ret kǝ wur kǝlǝng.>> ");
INSERT INTO sur_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kaaɗe Jesu ɗee mbǝshin, ɓe pak nen ɗe mo kǝlǝng sǝmpwoo nǝ, mo jì ashak kǝ jeplep wur ɗe ɗekaapaat baavǝl sǝ mo. Mo jì tal pǝ wur, mbǝkǝ wur sat shii Sǝmpwoo nǝ ɗi mmo. ");
INSERT INTO sur_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesu sat mmo nǝ, <<Naan shin man nwun, mbǝkǝ wur manshii kǝ mbii ɗe mo a sǝsok mǝ mulki Naan, amma pee nen ɗe atǝlǝng mo, ɓe moo kǝlǝng mbii ɗesǝ mo jir a shi sǝmpwoo. ");
INSERT INTO sur_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mbǝkǝ koo <ɗe mo naa, ɓe mon nnaa shi yit ɗak, amma baa mon nnaashii nǝ kas. Pee nen ɗe mo kǝlǝng, ɓe mon nkǝlǝng a shi kom ɗak, amma baa mon mmanshii nǝ kas, mbǝkǝ taji mo ciir, kǝ Naan fwo shikbish fur mo ɗi.>> ");
INSERT INTO sur_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesu tal pǝ mo nǝnee, <<Baa wuu manshii sǝmpwoo ɗesǝ nǝ kas aa? Cinarang ɗang wun mmanshii kǝ koor sǝmpwoo nǝ mo yi? ");
INSERT INTO sur_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Shii kǝ sǝmpwoo nǝ nɗesi, ngumaar nǝ wur a kaa ngusatpwoo Naan sǝ. ");
INSERT INTO sur_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pak gurum mo a kaa cirem ɗe mo taa a ar sǝ, ɗe katɗang mo kǝlǝng pwoo Naan nǝ, ɓe abet, ngujwaan wur jì ghǝr pwoo ɗe mo kǝlǝng nǝ nɗǝǝn pǝtuup fur mo. ");
INSERT INTO sur_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pak gurum mo a kaa cirem ɗe mo ɓwet a kwoop sǝ, ɗe katɗang mo kǝlǝng pwoo kǝ Naan ni, ɓe mo lap shi retnyit kǝlak-kǝlak. ");
INSERT INTO sur_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma baa nǝ sham seen jurum-jurum, nɗǝǝn mo kas, kǝ baa mon nteer vǝl kas. Katɗang mee luk yool koo gurum mo shin jeel mmo, mbe pwoo Naan nǝ, ɓe abet, mo baa shiɓwoon kǝlak-kǝlak. ");
INSERT INTO sur_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pak gurum mo a kaa cirem ɗe mo taa mɓut nghǝr mo sǝ, ɗe katɗang mo kǝlǝng pwoo Naan nǝ, ");
INSERT INTO sur_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɓe, mbe pan kǝ mbii mo, kǝ choor long mǝ yil ɗesǝ mo, kǝ numpee mǝ long mo, kǝ fwoot mǝ pak mbii mo, mo vwan pwoo nǝ, ɓe baa mo làa-làa kas. ");
INSERT INTO sur_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pak gurum mo a kaa cirem ɗe mo ɓwet mo nkaa yil ɗeret sǝ, ɗe mo kǝlǝng pwoo Naan nǝ. Ɓe mo lap nǝ, ɓe pwoo Naan nǝ cìn ɗak ɗes nɗǝǝn pǝtuup fur mo, kaa cirem ɗe nǝ làa-làa mo ɗes sǝ. Pak mo làa-làa laarkun, pak mo laarpeemee kǝ pak mo kambil.>> ");
INSERT INTO sur_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu sat mmo nǝnee, <<Kyet mee gurum nle wus nfitila, ɗang wur waa mang ɗaa ɗeɗes paa nǝ ɗi wa? Koo wur waa le nǝ nder peesaam wa? Amma wur nle nǝ aɗeng pee, a pee le fitila. ");
INSERT INTO sur_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Baa mee mbii ɗe, ɗe nǝ a sǝsok ɗe nǝn nook put agaak kas, kǝ baa mee mbii ɗe, ɗe nǝ a pǝpaa, ɗe mon nook put kǝ nǝ agaak kas. ");
INSERT INTO sur_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ngwar ɗewur kǝ kom mǝ kǝlǝngpee, ɓe nǝ ret kǝ wur kǝleng.>> ");
INSERT INTO sur_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wur sat mmo zak nǝnee, <<Wu cìn pan nkaa mbii ɗe wuu kǝlǝng mo. Shi ɗaa ɗe wuu kám mbii ɗe ngurum mo, ɓe mon nkám mbii mo wun a shi shik zak, ɓe nǝn ngam met mumo nǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Koo ɗang weyi ɗewur kǝ mbii, ɓe mon ncin ɗyikǝ nwur. Ɗangɓe gwar ɗe baa wur kǝ mee mbii kas, ɓe mon nsǝǝt nwaa yaa wur kǝ rep mbii ɗewur kǝ nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu sat zak nǝnee, <<Mulki Naan nǝ a kaa mee gwar ɗe wu ɓwet cirem ɗǝɓen mɓut mmaar sǝ. ");
INSERT INTO sur_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɓe wur saam mpar, kǝ wur yool mbít, ɓe ɗǝɓen nii kàa nii wurang. Ɓe baa wur man kaaɗi nii wurang sǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yil nǝ shikáa wur, nii kǝ le mbii kǝkop mo kaa làa-làa. Nshee, ɓe nǝ wurang kàa pyan kom, ɓe nǝ putkáa, kǝ nǝ le àa. ");
INSERT INTO sur_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kaaɗe ɗǝɓen nǝ nung, ɓe wur mang cuk dǝm ɗiip ɗǝɓen nǝ abet, mbǝɗe pee mak ɗiip nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesu sat nǝnee, <<Mun nkám mulki Naan nǝ a kaa me sǝ yi? Kǝ mun nkám nǝ a shi sǝmpwoo ɗeɗangyii? ");
INSERT INTO sur_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nǝ a kaa àas kǝ mee tǝng, ɗe moo pet nǝ a mustad sǝ, ɗe nǝ kat met àas kǝ cirem mo jir, ɗang ɓe katɗang mo kop nǝ nyil, ");
INSERT INTO sur_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ɓe nǝ yool wurang, ɓe nǝ ɗee a tǝng ɗeɗes zam. Nii put song ɗenan-nan mo, ɓe nyer mo jì le tish fur mo mɓut riin ni.>> ");
INSERT INTO sur_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu satpwoo ngurum mo, nkaa mulki kǝ Naan shi sǝmpwoo mo shini-shini, kaaɗi mo mak manshii nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Baa Jesu satpwoo ngurum nǝ mo kas, see a shi sǝmpwoo mo. Ɗang be katɗang wur ɗee mbǝshin ashak kǝ jeplep nwur mo, ɓe wur tap yakshii sǝmpwoo nǝ mmo jir. ");
INSERT INTO sur_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Parpuus mǝnǝ, nkansǝǝn, ɓe Jesu sat njeplep fin mo nǝnee, <<Wu yool mmun, kǝ mu canɗel mu dǝm nkor ɗesí.>> ");
INSERT INTO sur_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mo yool yit ɗuu gurum nǝ mo, ɓe mo dǝm ashak kǝ Jesu nɗǝǝn tii ɗewur tong nɗǝǝn nǝ. Pak tii nǝ mo yool dǝm nɗang wur zak. ");
INSERT INTO sur_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mee kut ɗeɗes nǝ yool nkaa am nǝ, ɓe am ɗel nɗǝǝn tii nǝ. Ɓe tii nǝ ɗoom gam kǝ am. ");
INSERT INTO sur_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ɗangbe Jesu nsaam mɓwoon nɗǝǝn tii nǝ. Ɓe jeplep wur mo dǝm mii wur. Mo sat nǝ, <<Ngukám, a naa mun murep mbǝsǝ kas aa?>> ");
INSERT INTO sur_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesu wur mii, ɓe wur gwak kut nǝ, ɓǝ wur sat am kuur nǝ nǝnee, <<A ɗok tǝtǝk. A saam coot.>> Ɓe kut nǝ ɗar, pee ɗokshik tǝtǝk. ");
INSERT INTO sur_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesu sat njeplep wur mo nǝnee, <<A me le ɗang kǝǝrmuut yaa wun ye? Har yaksǝ, ɓe baa wun shinzeen kas aa?>> ");
INSERT INTO sur_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nǝ aapwoo mmo ɗes zam, ɓe mo sat nshak nǝnee, <<Gwar ɗesǝ wur a weye? Ɗe har kut kǝ am kuur, mo cìn nɗyen wur!>> ");
INSERT INTO sur_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu kǝ jeplep wur mo can am kuur ɗe Galilee ɗel, ɓe mo jì wul nkor ɗǝǝr mu yil nGarasin. ");
INSERT INTO sur_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kaaɗe Jesu put nɗǝǝn tii nǝ abet ɓe wur kaat kǝ mee gwar ɗewur kǝ riin ɗebish, wur kǝ tong a nɗǝǝn gwoot kǝcir mo. ");
INSERT INTO sur_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A peetong kǝ ngwar nǝ mmǝnǝ. Baa mee gurum katɓal ɗe mmak yaa wur ɓwoot kas. Koo ɗe mo ɓwoot wur a shi tǝsek, ɓǝ wur kǝ saa tǝsek nǝ. ");
INSERT INTO sur_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Di moo naa njwal shii fir mo mɓut nfut, kǝ mo ɓwoot sar wur mo shi tǝsek, ɗang ɓe wur roop nfut nǝ, kǝ wur kǝram tǝsek nǝ fwo. Baa mee gurum mak cìn mee mbii nwur kas. ");
INSERT INTO sur_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Par kǝ puus, ɓe wur tong a nɗǝǝn kǝcir, kǝ nɗǝǝn jwak mo, kǝ wur le or, kǝ wur kóon foshik wur nkaa jwak nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kaaɗe wur naa Jesu kǝ jì jong-jong, ɓe wur yool su dǝm, wur dǝm kurum nfurum ntoom wur. ");
INSERT INTO sur_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ɓe wur bwet ɗoo shiɓal nǝnee, <<A me kaat mun kǝ gha ye? Jesu Làa Naan Ɗehai! Wen ɗang pǝ gha mbe sǝm Naan, taji a lejeel nghan kas.>> ");
INSERT INTO sur_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gwar nǝ sat kǝsǝ, a mbǝɗe Jesu kǝ sat nriin ɗebish nǝ nǝnee, <<A put aku mɓut ngwar nǝ, gha riin ɗebish.>> ");
INSERT INTO sur_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesu tal pǝ gwar nǝ nǝnee, <<Sǝm fwaa a weyi?>> Gwar nǝ lap nǝnee, <<Sǝm fen nǝ a Lijiyon, ɗe shii kǝ mǝnǝ nǝ, mun ɗi ɗes.>> ");
INSERT INTO sur_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Riin ɗebish nǝ mo ɗang pǝ Jesu hakyeng, mbǝkǝ taji wur ceen mo pwat nɗǝǝn yil mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kus kǝ peemǝnǝ, ɓe kuur kǝ danus mo ɗi ɗes, mo nkaa se shit shituur jwak. ");
INSERT INTO sur_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Riin ɗebish nǝ mo ɗang pǝ Jesu, kǝ wur cínpee mmo, kǝ mo dǝm ɗel ɗe nɗǝǝn danus nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu cínpee mmo, ɓe riin ɗebish nǝ mo pwat nɗǝǝn gwar nǝ, ɓe mo dǝm ɗel nɗǝǝn danus nǝ mo. Ɗuu kǝ danus nǝ mo wul ngal vǝl, mo yool shwe sham a shituur jwak, ɓe mo sham ɓeer nɗǝǝn am canɗar nǝ, har mo murap jir. ");
INSERT INTO sur_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nentap danus nǝ mo shwe dǝm sat ngurum mo nɗǝǝn yilkaam, kǝ jepyil mo jir. Gurum mo pwat jì mɓe naa mbii ɗe nǝ kǝ cìn. ");
INSERT INTO sur_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mo jì pee Jesu ɗe, ɓe mo naa gwar ɗe di wur kǝ riin ɗebish mo wur kǝ tong, kǝ nlǝr a lǝlep, kǝ wur nɗǝǝn ɗyen fin rǝret, ɓe kǝǝrmuut yaa mo. ");
INSERT INTO sur_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nen ɗe mo cìn mbii ɗesǝ nǝ a yit fur, ɓe mo yakshii nǝ ngurum mo, kaaɗi Jesu bar gwar ɗe di wur kǝ riin ɗebish mo sǝ, kǝ kaaɗi danus nǝ mo murap sǝ. ");
INSERT INTO sur_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɗangɓe nenyil nǝ mo ɗang pǝ Jesu, kǝ wur yool put nɗǝǝn yil fur. ");
INSERT INTO sur_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kaaɗe Jesu pǝ ɗel nɗǝǝn tii, ɓe gwar ɗe, wur kǝ riin ɗebish sǝ, wur ɗang pǝ Jesu nǝnee, <<A yit an dǝm ɗi nɗang gha.>> ");
INSERT INTO sur_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amma baa Jesu rǝɓet kas. Wur sat ngwar nǝ nǝnee, <<A waa baa ntul, pee ɗyemnǝǝn fwaa mo ɗi, mbǝkǝ a satpwoo ɗe mmo nkaa mbii ɗeɗes ɗe Naan kǝ cìn gha, kǝ ɗewur kǝ naajeel fwaa.>> ");
INSERT INTO sur_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gwar nǝ wur baa waa, ɓe wur taa satpwoo nǝ nenyil ɗe nkwang nyil nDikapolis mo, nkaa mbii ɗeɗes ɗe Jesu kǝ cìn nwur. Mbii ɗe gwar nǝ sat nǝ aapwoo ngurum mo. ");
INSERT INTO sur_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu waa baa canɗel nkwang nkor ɗese, nɗǝǝn am, ɓe gurum mo ɗes mo jì kuur pee wur ɗi, mpwo am kuur nǝ. ");
INSERT INTO sur_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mee gwar ɗe moo pet sǝm wur a Jairus, wur a memee nɗǝǝn nennan-nan mǝ mee lu Naan, wur jì kurum ntoom Jesu. ");
INSERT INTO sur_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wur ɗang pǝ Jesu hakyeng, wur sat nǝnee, <<Reep fen ɗelee war pǝ yap muut. A jì a lesar fwaa nkaa war, mbǝkǝ war kat seen ɗi.>> ");
INSERT INTO sur_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu yool dǝm ashak kǝ Jairus, ɓe gurum mo ɗes mo dǝm nɗang wur, ɓe mo neer wur cǝǝrkaat kus-kus. ");
INSERT INTO sur_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mee mat war ɗe zak, ɗe waa kǝ ɓeer toom mbe ɓit mo kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","War kǝ kyes long fin mo jir pǝ nenyen mo, jir kǝsǝ, ɓe baa memee mak bar war kas. Ɗangɓe shwal war nii war sǝǝt cicíi nnǝ. ");
INSERT INTO sur_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kaaɗe war kǝlǝng pwoo nkaa mbii ɗe Jesu wur cìn mo, ɓe war dǝm ɗel mɓut ɗuu gurum nǝ mo. Ɓe war tap dǝm mɓwoon Jesu, ɓe war tung pǝkom nlǝr wur. ");
INSERT INTO sur_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mɓeɗi war kǝ ten pan nɗǝǝn pǝtuup war nǝnee, <<Katɗang ɓe an tung koo a pǝkom nlǝr wur ɗe ɓejee ɗak, ɓe an mbar.>> ");
INSERT INTO sur_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aasǝ ɓe, war tung pǝkom nlǝr wur nǝ, ɓe abet, toom war nǝ ɗar. War man nɗǝǝn fwoshik war nǝ, nee shwal war nǝ kǝ kyes jee. ");
INSERT INTO sur_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Abet Jesu man nǝ, iiko kǝ put nɗǝǝn foshik wur nǝ, ɓe wur ciir tal pǝ gurum nǝ mo, nǝnee, <<A wii tung nlǝr fen yi?>> ");
INSERT INTO sur_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jeplep wur mo lap nwur nǝnee, <<A naa ɗuu gurum nǝ mo neer gha ciirkaat, ɓe a sat nǝnee, <A wii tung gha yi> aa?>> ");
INSERT INTO sur_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesu ciir mbǝkǝ wur naa gwar ɗe tung pǝkom nlǝr wur nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mat nǝ war man koom ɗe war kǝ kat nǝ, ɓe war jì shi kǝǝrmuut kǝ ɗaar, war kurum nyil ntoom Jesu, ɓe war sat zeen nwur jir mbii ɗe nǝ kǝ cìn. ");
INSERT INTO sur_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu sat nwar nǝnee, <<Reep fen, shinzeen fii nǝ le kǝ yi ɗee a ɗebǝbar. Shwal fii nǝ kyes. Yi dǝm, yi wul riyang.>> ");
INSERT INTO sur_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaaɗe Jesu kuɗi nkaa sat pwoo mǝnǝ, ɓe mee des mo tong ntul Jairus mo jì, ɓe mo sat nwur nǝnee, <<Reep fwaa war kǝ muut, Mbǝmǝnǝ ɓe taji a lejeel Ngukám wur kas.>> ");
INSERT INTO sur_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amma Jesu lekom kaa baa wur kǝlǝng pwoo ɗe mo sat nǝ kas sǝ. Ɓe wur sat nJairus nǝnee, <<Taji pǝtuup fwaa wat kas, amma a shinzeen ɓejee.>> ");
INSERT INTO sur_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Baa Jesu yit kǝ mee gurum dǝm nɗang wur kas, see a Pita, kǝ Jemis kǝ Joon ɗyemnǝǝn Jemis ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kaaɗe mo jì wul ntul Jairus nǝ, ɓe Jesu naa gurum mo nkaa fwo ruruu, mo nkaa wal, mo nkaa maap zak. ");
INSERT INTO sur_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wur ɗel nɗǝǝn lu nǝ, ɓe wur sat mmo nǝnee, <<A me le ɗang, wuu fwo ruruu kǝ wun mmaap yi? Baa laareep nǝ war kǝ muut kas, amma war a nsaam ɓejee.>> ");
INSERT INTO sur_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amma gurum nǝ mo jir, mo shwar wur shi shwar mǝ ɓakpee. Kaaɗe wur le kǝ gurum nǝ mo pwat atǝleng jir. Ɓe wur le kǝ puun kǝ nǝǝn reep nǝ, kǝ nen ɗe mo ashak kǝ wur, mo ɗel nɗǝǝn lu ɗe laareep nǝ war kǝ saam ɗi. ");
INSERT INTO sur_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɓe wur yaa sar laareep nǝ, ɓe wur sat nwar nǝnee, <<Talifa kumi> ɗe shii mǝnǝ a nǝ, <<Apa, wen sat yi, yi yool.>> ");
INSERT INTO sur_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Abet ɓe reep nǝ war yool ɗar, war yaa mwaan. Ɓitlàa war nǝ a kaapaat baavǝl. Nǝ aapwoo ngurum mo ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu satpwoo mmo shiɓal nǝnee, <<Taji wu satpwoo mmee gurum nkaa nǝ kas.>> Wur sat zak nǝnee, <<wu shin mbiise nwar se.>> ");
INSERT INTO sur_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu yool yit peemǝnǝ, ɓe wur waaji nɗǝǝn yil wur. Jeplep wur ɗe mo jì nɗang wur. ");
INSERT INTO sur_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kaaɗe parpuus Nookɗi nǝ wul, ɓe wur yaa kám-kam ngurum mo, nɗǝǝn lu Naan. Gurum mo ɗes mo kǝlǝng wur, nǝ aapwoo mmo, ɓe mo sat nǝnee, <<Gwar ɗesǝ wur kat mbii ɗesǝ mo jir a nneyi? Mo shin a seen ɗeɗang ngwar ɗesǝ ye? Ɗe nǝ le kǝ wur cìn mbii aapwoo ɗenan-nan sǝ mo yi? ");
INSERT INTO sur_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Baa a ngu pwas shyeep sǝ nɗesǝ kas aa? Ɗyem kǝ Meeri, ɗe ɗyemnǝǝn wur mo a Jemis, kǝ Josep, kǝ Judas, kǝ Simon kas aa? Ɗe ɗyemnǝǝn wur ɗe mat sǝ mo, ashak kǝ mu zak, kas aa?>> Mbǝmǝnǝ ɓe mo langtuup kǝ wur. ");
INSERT INTO sur_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu sat mmo nǝnee, <<Baa gurum moo cii shin ɗeɗes ngusatpwoo Naan kas, see a pǝ nenyil wur mo, kǝ ɗang wur mo, kǝ nentul wur mo, a moo cii shin ɗeɗes nwur ɓejee ɗak.>> ");
INSERT INTO sur_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Baa wur cìn mee mbii aapwoo ɗenan-nan mo mpeemǝnǝ kas, amma wur lesar nkaa pak nenciinkoom mo lee ɗak, ɓǝ wur bar mo. ");
INSERT INTO sur_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nǝ aapwoo nJesu zam, mbǝɗe baa gurum nǝ mo shinzeen kas. ");
INSERT INTO sur_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesu mwaan neer jepyil nǝ mo, mbǝkǝ wur kámpwoo Naan ɗe ngurum mo. Wur pǝrep jeplep wur ɗe kaapaat baavǝl sǝ mo, ɓe wur lep mo she seet vǝl-vǝl. Wur shin iiko mmo nkaa riin ɗebish mo. ");
INSERT INTO sur_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wur sat mmo shiɓal nǝnee, <<Taji wu mang mee mbii mbǝ mwaan nǝ kas, koo gill aas, koo kuluk, koo shool nɗǝǝn daam fuu mo kas. ");
INSERT INTO sur_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Amma wu mak mang kammwaan, kǝ wu jwal kwoopshi nshii fuu mo ɓejee ɗak. Kǝ taji wu lep nlǝr mo vǝl kas. ");
INSERT INTO sur_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Koo tul ɗeɗangyii, ɗe wu ɗel ɗe, ɓe wu tong ntul mǝnǝ, har parɗe wun nyool wu yit pee nǝ. ");
INSERT INTO sur_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Koo pee ɗeɗangyi ɗe baa mo lap wun kas, kǝ baa mo kǝlǝng pwoo fuu kas zak, ɓe katɗang wun a ar put mbe nǝ, ɓe wu ɓwap ǝrong ɗe nǝn nkaa shii fuu mo, mbǝkǝ nǝ ɗee ɗe a langtǝng nkaa nenyil nǝ mo, nǝ mo cii lap wun.>> ");
INSERT INTO sur_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɗangɓe mo pwat dǝm yaa satpwoo Naan ngurum mo, mbǝkǝ gurum mo tuwap ɗi. ");
INSERT INTO sur_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mo ceen riin ɗebish mo ɗes, kǝ mo pwes nenciinkoom mo ɗes shi mwoor paat, kǝ mo bar mo. ");
INSERT INTO sur_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mishkoom Herot kǝlǝng pwoo nkaa Jesu, mbǝɗe sǝm Jesu nǝ ɗee a ɗemǝman ngurum mo jir, mbe mbii aapwoo ɗewur cìn mo, ɓe nǝ le kǝ pak gurum moo sat nǝnee, <<A Joon ngucìn baptisma wur kǝ yool a peemúut. A nǝ le ɗangɓe wur kǝ iiko mbe cìn mbii aapwoo ɗesǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Amma pak gurum mo sat nǝnee, <<A Ilaija jì kámshin agaak.>> Kǝ pak mo sat nǝnee, <<Wur a ngusatpwoo Naan, koo memee nɗǝǝn nensatpwo Naan ɗe gyet yam mo sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kaaɗe Herot wur kǝlǝng mǝnǝ, ɓe wur sat nǝnee, <<A Joon ɗe Di wen kǝn le kǝ mo can káa wur sí. A wur kǝ baa yool a peemúut.>> ");
INSERT INTO sur_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Di Herot shikáa wur, wur kǝ lep gurum mo dǝm yaa Joon ɓwoot le nlushoot, mbe Herodiyas mat ɗyemnǝǝn nwur Filip, ɗe Herot wur kǝ lap war mmat. ");
INSERT INTO sur_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mɓeɗi Di Joon wur naa nsat nHerot nǝ, <<Baa nǝ ret kǝ a lapmat kǝ ɗyemnǝǝn fwaa kas.>> ");
INSERT INTO sur_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A mpeemǝnǝ ɓe Herodiyas war fes naa Joon kǝ yit ɗǝ bish, ɓe war rǝɓet tu Joon, ɗang baa war kat ar nǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot wur kǝǝr Joon, mbǝɗe wur man nǝ, Joon wur a nguzeen, kǝ gwar ɗe ndere. Nǝ le kǝ nHerot tap kǝ Joon rǝret nɗǝǝn lushoot nǝ. Herot wur kǝlǝng pwoo ɗe Joon kǝ sat mo shi retnyit, amma pwoo nǝ moo daampee nwur zam. ");
INSERT INTO sur_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aɓwoon jep mǝnǝ, ɓe Herodiyas waa katpee mɓe tu Joon, a parpuus ɗe mishkoom nHerot wur cet mbii serǝɓet, mɓe pan parpuus ɗe gyet mo làa wur ɗe. Ɓe wur pǝrep mishkoom ɗe mon nder wur, kǝ nenyil ɗenan-nan nkaa shiitoon nwur mo, kǝ nenyil ɗenan-nan ɗe mo nɗǝǝn Galili, mbǝkǝ mo jì ɗe mɓe serǝɓet nǝ. ");
INSERT INTO sur_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɓe reep kǝ Herodiyas war ɗel met kook, ɓe nǝ ret nHerot nyit zam, kǝ nenyil ɗe moo tong a pee sese ashak kǝ wur zak. Mishkoom Herot wur sat nreep nǝ war nǝnee, <<Koo mbii ɗeɗangyii, ɗe yii rǝɓet, ɓe yi ɗang, ɓe wen ncin nyi.>> ");
INSERT INTO sur_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wur waa baa tuweerpwoo nwar shiɓal zak nǝ, <<Koo a meye ɗe yi ɗang pǝ an jir, ɓe an ncin nyi. Koo ɗang nǝ a koor mulki fen, ɓe nghan nshin nyi.>> ");
INSERT INTO sur_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Reep nǝ war dǝm tal pǝ nǝǝn waa nǝnee, <<Wen nɗang a meye?>> Nǝǝn nǝ war sat nǝnee, <<Yi dǝm yi sat wur shin káa Joon nguchìn baptisma nyi.>> ");
INSERT INTO sur_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Reep nǝ war baa pǝ mishkoom ɗe kǝlak-kǝlak, ɓe war sat nwur nǝnee, <<A shin kaa nJoon nguchìn baptisma an nɗǝǝn kong sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mbii ɗe war ɗang ɗesǝ nǝ wàt pǝtuup mishkoom zam, amma mbǝɗe wur kǝ ten tuweerpwoo nreep nǝ war shi ɓǝlemcuk, ntoom mǝzep wur nǝ mo, ɓe nǝ ɗee nwur a tǝng, kǝ wur shin káa nJoon nwar. ");
INSERT INTO sur_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Abet-abet mishkoom Herot wur lep mee shiitoon mɓut nen tappee wur mo ke wur dǝm can káa nJoon jì kǝ ɗi. Shiitong nǝ wur dǝm can káa Joon nɗǝǝn lushoot. ");
INSERT INTO sur_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɓe wur jì kǝ káa nǝ nɗǝǝn kong. Ɓe wur shin nwar. Ɓe war dǝm shin nnǝǝn fer. ");
INSERT INTO sur_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kaaɗe jeplep Joon mo kǝlǝng nǝ mo kǝ tu Joon, ɓe mo jì mang kúm wur dǝm wum nɗǝǝn kǝcir. ");
INSERT INTO sur_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jeplep Jesu mo waaji pǝ wur ɗe, ɓe mo sat nwur mbii ɗe mo dǝm cìn mo, kǝ mbii ɗe mo kǝ kám ngurum mo zak. ");
INSERT INTO sur_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mɓeɗi gurum mo ɗes moo jì, kǝ pak moo waa baa zak, ɓe nǝ le kǝ baa Jesu kǝ jeplep fir mo katpee ɗe mon nse mbiise ɗe kas. Ɓe Jesu sat mmo nǝnee, <<Wu jì mmun, mu dǝm mbǝsun a peeɗi baa gurum mo ɗe kas kǝ wun wu nook ɗi.>> ");
INSERT INTO sur_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓe mo dǝm mbusut nɗǝǝn mee tii am, mpeeɗe baa gurum mo ɗi kas. ");
INSERT INTO sur_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma gurum nǝ mo naa moo dǝm, kǝ mo man nǝ, a mo. Ɓe gurum nǝ mo yool nɗeen yilkaam mo jir, mo yaa ar a ɗǝǝr nshii, ɓe mo dǝm taa tǝleng nJesu kǝ jeplep wur mo. ");
INSERT INTO sur_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kaaɗe Jesu put nɗǝǝn tii nǝ, ɓe wu naa gurum mo kuur ɗes. Ɓe wur naa mo jeel wur nyit, ɗang mo ɗee a kaa tǝm ɗe baa mo kǝ ngunaa kas sǝ. Wur ɗoom kám mbii mo mmo ɗes. ");
INSERT INTO sur_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kus yak puus nru, ɓe jeplep nwur mo jì sat nwur nǝnee, <<A naa puus nǝ kus kǝ ru, ɗang pee ɗesǝ nǝ a naaryil ɗe baa tul gurum mo ɗi kas. ");
INSERT INTO sur_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","A sat ngurum nǝ mo dǝm, mbǝkǝ mo dǝm ɗe nɗǝǝn tul nenmaar mo, kǝ jepyil ɗe mo neer pee ɗesǝ cǝǝrkaat, mo seet mbiise ɗe shikáa fur.>> ");
INSERT INTO sur_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɗangɓe Jesu lap mmo nǝnee, <<Wu shin mbiise mmo se.>> Mo lap nwur nǝnee, <<Mun ndem mu seet gǝǝl aas mǝ shool zinariya kambil vǝl, kǝ mu shin mmo se aa?>> ");
INSERT INTO sur_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu tal pǝ mo nǝnee, <<Wun kǝ gǝǝl aas mo a kong ye? Wu dǝm wu naa ɗe.>> Kaaɗe mo dǝm naa, ɓe mo sat nǝnee, <<Mun kǝ gǝǝl aas mo paat, kǝ pupwap mo vǝl.>> ");
INSERT INTO sur_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ɓe Jesu sat njeplep wur mo ɓàk gurum nǝ mo tong nyil, shikuur-shikuur nkaa ɗem ɗe mǝlep nǝ. ");
INSERT INTO sur_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aasǝ ɓe gurum nǝ mo tong nyil shikuur-shikuur, pak mo kambil-kambil, ɗang pak mo laarpaat-laarpaat. ");
INSERT INTO sur_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu mang gǝǝl aas ɗepaat nǝ mo, kǝ pupwap ɗe vǝl nǝ mo, ɓe wur ɗyeep yit fer aɗeng, ɓe wur cìn ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan. Ɓe wur yilang gǝǝl aas nǝ shin jeplep wur mo, kǝ mo swap ɗe ngurum nǝ mo se, kǝzak, wur ɓàk pupwap ɗe vǝl nǝ mmo aasǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gurum nǝ mo jir, mo se ǝɓǝl. ");
INSERT INTO sur_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Har nen mwaan nɗang wur nǝ mo kok kor gǝǝl aas kǝ pupwap ɗe mo ɗee ɗe, ɓe nǝ gam kǝcik mo kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɗaa ɗe mo se mbiise nǝ, mo wul ngal paat. ");
INSERT INTO sur_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Abet, ɓe Jesu le kǝ nen mwaan nɗang wur mo ɗel nɗǝǝn tii, mbǝkǝ mo dǝm ɗi nwur atǝleng, mbe canɗel nkor Betseda, kǝ wur ɓwet ɗuu kǝ gurum nǝ mo ɗe akuɗang. ");
INSERT INTO sur_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aɓwoon ɗewur kǝ ɓwet mo, ɓe wu kaa aɗeng jwak mɓe cìn ɗangnaan (leshap kǝ Naan). ");
INSERT INTO sur_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kaaɗe tii nǝ kǝ wul a naar am kuur nǝ, ɓe pee kǝ shool. Jesu wur ɗee ɗi a ɗǝǝr mɓǝshin. ");
INSERT INTO sur_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wur naa mo nkaa shwaajeel, mpee tung tii nǝ, mbǝɗe mee kut ɗeɗes nii baa kǝ mo shiɓwoon. Ɓe wur mwaan nkaa am kuur nǝ ke wur dǝm pee mo ɗi, naar kǝ karfe kun har dǝm karfe mpeemee. Kaaɗe wur dǝm wul pee mo ɗi, ɓe wur cìn kaa wur nɗǝɗel mo sǝ. ");
INSERT INTO sur_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ɓe, kaaɗi mo naa wur mwaan nkaa am nǝ, ɓe mo pan nǝ a mee nshon, ɓe mo ɓwet or. ");
INSERT INTO sur_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mɓeɗi mo jir mo naa wur, ɓe kǝǝrmuut fes yaa mo ɗes. Abet, ɓe Jesu leshap kǝ mo, wur sat mmo nǝnee, <<Wu ɓwet pǝtuup fuu mo, a an. Taji kǝǝrmuut yaa wun kas.>> ");
INSERT INTO sur_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ɓe wur kàa ɗel nɗǝǝn tii nǝ ashak kǝ mo, ɗangɓe kut nǝ ɗar coot. Ɓe nǝ aapwoo mmo zam. ");
INSERT INTO sur_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mɓeɗi baa mo manshii kǝ pwoo nkaa mbii aapwoo ɗe Jesu cìn nkaa gǝǝl aas, ɗang wur shin ngurum mo ngal paat mo se sǝ kas. Mɓeɗi baa pǝtuup fur mo mak manshii nǝ rǝret kas. ");
INSERT INTO sur_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kaaɗe mo can am nǝ ɗel, ɓe mo jì wul kwang nyil nGenesaret, ɓe mo ɗyiin tii nǝ pǝkom ɗǝǝr. ");
INSERT INTO sur_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kaaɗe mo pwat nɗǝǝn tii nǝ, ɓe abet-abet Ɓe gurum mo man nǝ, a Jesu. ");
INSERT INTO sur_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mo yool shwe dǝm ɗel nɗǝǝn yil nǝ jir, ɓe mo ghǝr nenciinkoom mo nkaa mbiisaam fur mo, mo dǝm kǝ mo mpee ɗe mo kǝlǝng nnǝ Jesu ɗi. ");
INSERT INTO sur_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Peeɗi Jesu ɗel ɗe jir, koo nɗǝǝn jepyil mo, koo nɗǝǝn yilkaam mo, koo a peemaar mo, ɓe gurum mo ghǝr nenciinkoom fur mo, mo le mo mpwoo lutuk, kǝ mo ɗang pǝ Jesu, katɗang wur rǝɓet, ɓe wur yit kǝ mo tung koo a pǝkom nlǝr wur ɗe ɓejee ɗak. Nen ɗe mo tung nlǝr wur nǝ jir, ɓe mo bar. ");
INSERT INTO sur_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nen Farisi mo, kǝ pak nenkám Wàar Mosis mo, ɗe mo tong nJerusalem, mo jì kuur pee Jesu ɗi. ");
INSERT INTO sur_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓe mo naa pak jeplep Jesu moo se mbiise shi sar ɗe baa nǝ ɓang kas, shii kǝ mǝnǝ nǝ, baa mo vwang sar fur mo kaaɗi nen Farisi mo sat nnǝ, mo cìn sǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Baa nen Farisi mo kǝ nen Yahudi mo jir, moo see mbiise kas, see mo shee vwang sar fur mo rǝret akuɗang. Moo tap aa mbii ɗe gyet mǝyii fur moo loot kǝ cìn nǝ. ");
INSERT INTO sur_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Katɗang mo tong nlutuk jì, ɓe baa mon nse mee mbii kas, see mo shee vwang sut rǝret akuɗang. Pak mbii mo ɗǝɗes, ɗe moo cìn, ɗe mo kám a pǝ nen mǝyii fur mo, kaa vwang laaɗaa mo, kǝ tuul mo, kǝ ɗaa bòng mo sǝ. ");
INSERT INTO sur_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nen Farisi mo, kǝ nenkám Wàar nMosis mo tal pǝ Jesu nǝnee, <<A me le ɗangɓe baa jeplep fwaa moo tap kǝ kám kǝ nen mǝyii funu mo kas ye? Har moo se mbiise shi sar ɗe baa mo ɓang kas.>> ");
INSERT INTO sur_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu lap mmo nǝnee, <<Wun nen mwaan ndang Naan shi pǝtuup vǝl-vǝl mo. Gyet Aizaya wur satpwoo nkaa wun azeen nǝnee, <Nen ɗesǝ moo shin ɗeɗes nghan a shi mǝshpwoo fur mo. Amma pǝtuup fur mo jong kǝ an. ");
INSERT INTO sur_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Moo seyil nghan a buu. Kám ɗe moo kám nǝ a Wàar mǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wuu yit Wàar Naan, kǝ wu ɗyel a Wàar ɗe gurum moo loot kǝ cìn nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wur sat mmo zak nǝnee, <<Wun kǝ mee ar seen mbe cii Wàar Naan mo, mbǝkǝ wu ɗyel kám fuu mo ɗe. ");
INSERT INTO sur_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosis sat nǝnee, <A shin ɗeɗes mpuun fwaa kǝ nǝǝn fwaa,> Kǝzak nǝnee, <gwar ɗewur satpwoo ɗebish nkaa puun koo nǝǝn wur, ɓe mon ntu wur ating.> ");
INSERT INTO sur_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma wuu kám ngurum mo nǝ, <Katɗang gurum wu kǝ mee mbii ɗe nǝ ret kǝ wu ɓam puun wur ɗe, koo nǝǝn wur shi shik, ɗangɓe wu sat nǝ, nǝ a Korban, (ɗe shii mǝnǝ nnǝ, nǝ a mǝ Naan). ");
INSERT INTO sur_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ɓe baa wu kuɗi wuu yit nwur cìn mee mbii mɓe ɓam puun wur ɗe kǝ nǝǝn wur ɗe kas. ");
INSERT INTO sur_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A mɓe kám fuu ɗesǝ mo, ɓe wuu lepwoo Naan ɗee a mbii ɗebuu, kǝ mbii mo ɗes ɗe wuu cìn mo aasǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu waa baa pet ɗuu gurum nǝ mo, ɓe wur sat mmo nǝnee, <<Wu lekom, kǝ wur kǝlǝng mbii ɗe an nsat ɗi, kǝ wur manshii nǝ ɗe zak. ");
INSERT INTO sur_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Baa mee mbii ɗe gurum kǝ se mpwoo, nǝn nle kǝ gurum ɗee a mbii ɗebish (nyaknkap) nyit Naan kas, amma a mbii ɗe moo kàa pwat mpwoo gurum, a mǝnǝ moo ke le gurum ɗee a mbii ɗebish (nyaknkap) nyit Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Katɗang gwar ɗe kǝ kom mɓe kǝlǝngpee, ɓe wu kǝleng. ");
INSERT INTO sur_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kaaɗe Jesu yool yit ɗuu gurum nǝ mo, ɓe wur dǝm ɗel nɗǝǝn lu. Ɓe jeplep wur mo tal shii sǝmpwoo mǝnǝ pǝ wur. ");
INSERT INTO sur_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu sat mmo nǝnee, <<Baa wun wu manshii nǝ kas zak aa? Wu man nǝ, koo a mbii ɗeɗangyi ɗe gurum se, ɓe baa nǝn mmak le gurum ɗee a mbii ɗebish (nyaknkap) nyit Naan kas. ");
INSERT INTO sur_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mɓeɗi mbii ɗe gurum se, ɓe baa nii ɗel sham a nɗǝǝn pǝtuup wur kas, amma nii ɗel sham a nɗǝǝn ɓut nwur, ɓe wu ndem kǝn nǝ nɗyes.>> Jesu satpwoo ɗese, a mbǝkǝ wur kám ɗe nǝ, baa mee mbiise mak le gurum ɗee a mbii ɗebish (nyaknkap) nyit Naan kas. ");
INSERT INTO sur_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesu sat zak nǝnee, <<A mbii ɗe moo kàa pwat nɗǝǝn pǝtuup gurum, a moo le gurum a mbii ɗebish (nyaknkap) nyit Naan. ");
INSERT INTO sur_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mɓeɗi a nɗǝǝn pǝtuup ngurum, ɓe pan ɗebish moo pwat a ɗi. Mbii mo kaa tang mat mo, kǝ wat, kǝ tukáa, kǝ ngaa. ");
INSERT INTO sur_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kǝ tǝlǝk, kǝ yaa bǝ pǝtuup, kǝ gwampee, kǝ ciin yaasut, kǝ zuur, kǝ wat sǝm, kǝ ɗyeep kaa, kǝ dak mwen. ");
INSERT INTO sur_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A mbii ɗebish ɗesi mo jir, ɗe moo pwat nɗǝǝn pǝtuup gurum, a mǝnǝ moo ke le gurum ɗee a mbii ɗebish (nyaknkap) nyit Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu yool a peemǝnǝ zak, ɓe wur dǝm nɗǝǝn yil nTaya kǝ Sidon. Wur dǝm ɗel nɗǝǝn mee lu, ɗe baa wur rǝɓet kǝ mee gurum manpee ɗewur ɗe kas, amma jir kǝsǝ, ɓe gurum mo dǝm yap wur kat. ");
INSERT INTO sur_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kaaɗe mee mat, ɗe riin ɗebish nɗǝǝn reep war ɗelee, war kǝlǝng pwoo nkaa Jesu, ɓe abet, war jì taa ntoom wur. ");
INSERT INTO sur_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Baa mat nǝ war a mat Yahudi kas, war a mat Heleni. Mo làa war a nFonisha, ɗe nǝn nyil nSiriya. War ɗang pǝ Jesu, mbǝkǝ wur ceen riin ɗebish nǝ put mɓut nreep war nǝ. ");
INSERT INTO sur_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu lap nwar nǝnee, <<Yi yit kǝ mu shin mbiise njeplu mo ǝɓǝl ɗi aku, mbǝɗe baa nǝ ret kǝ mu mang mbiise mǝ jep mo, kǝ mu fwo nǝn as mo kas.>> ");
INSERT INTO sur_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Amma waa sat nǝ, <<Ii, nǝ aasǝ Daa, amma as nǝ moo se rep pak mbiise ɗe nii ɗong nyil, nder peetong mǝ sese jeplu nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu sat nwar nǝnee, <<Mbǝ pwoo ɗe yi sat sǝ, ɓe yi dǝm ntul wur-wur, riin ɗebish nǝ kǝ put mɓut nreep fii nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaaɗe mat nǝ war baa ntul far, ɓe war kat reep war nsaam nkaa mbiisaam. Riin ɗebish nǝ kǝ put nɗǝǝn reep nǝ jee. ");
INSERT INTO sur_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu yool yit yil nTaya, ɓe wur taa mer nSidon, ɓe wur jì wul am kuur mǝ Galili, nkwang nyil nDikapolis. ");
INSERT INTO sur_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mee des mo jì kǝ mee tǝding, ɗe baa wur mak leshap kas pee Jesu ɗe. Mo ɗang pǝ wur, kǝ wur lesar wur ɗi nkaa tǝding nǝ. ");
INSERT INTO sur_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mɓut ɗuu gurum nǝ mo, ɓe Jesu yaa tǝding nǝ nsar, dǝm kǝ wur mee kwang coot mbǝshin. Jesu jwal nǝkongsar fin mo nɗǝǝn kom gwar nǝ, kǝ wur ɓwet lii, ɓe wu tung liis gwar nǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesu naapee kaa aɗeng, ɗangɓe wur nook puut, ɓe wur sat ntǝding nǝ shi lǝpwoo mu nenyil Arameek mo nǝnee, <<Iffata>> ɗe shii kǝ mǝnǝ nǝ, <<Wang!>> ");
INSERT INTO sur_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɓe abet, ɓe gwar nǝ kǝlǝngpee, kǝ liis nwur nǝ fween, ɓe wur leshap rǝret. ");
INSERT INTO sur_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu satpwoo ngurum nǝ mo shiɓal nǝ, taji mo satpwoo nkaa nǝ mmee gurum kas, amma a koppee ɗe mon nɗok tǝtǝk, ɓe mo waa dǝm satpwoo ngurum mo nkaa nǝ ɗes. ");
INSERT INTO sur_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nǝ aapwoo ngurum nǝ mo hakyeng, ɗangɓe mo sat nǝnee, <<Wur cìn mbii mo jir a ndǝre-ndǝre. Wur le kǝ komjoor mo kǝlǝngpee, kǝ tǝding mo leshap zak.>> ");
INSERT INTO sur_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nɗǝǝn teer mǝnǝ mo, ɓe ɗuu gurum nǝ mo waa baa kuur pǝ Jesu ɗi ɗes. Ɓe baa mo kǝ mbiise kas. Jesu pǝrep nen jeplep wur mo, ɓe wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Wen naajeel ɗuu gurum sǝ mo, mbǝɗe mo kǝ cìn teer kun ashak kǝ an nɗesi, ɗang baa mo kuɗi kǝ mbiise kas. ");
INSERT INTO sur_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Katɗang wen ɓwet mo shindǝm ntul fur mo kǝ neen, ɓe mon ntaa muutleet a ar, mbǝɗe pak mo pwat a mpee ɗejong.>> ");
INSERT INTO sur_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jeplep Jesu mo tal pǝ wur nǝnee, <<Mun mmak kat mbiise a nneye, a naaryil ɗese, ɗe ɗuu gurum sǝ mon nse kǝ nǝ mak ǝɓǝl mo ɗe ye?>> ");
INSERT INTO sur_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu tal pǝ mo nǝnee, <<Wun kǝ gǝǝl aas mo a kong ye?>> Mo lap nǝnee, <<Mun kǝ gǝǝl aas nǝ mo a pwovǝl.>> ");
INSERT INTO sur_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesu sat nɗuu gurum nǝ mo tong nyil. Ɓe wur mang gǝǝl aas ɗe pwovǝl nǝ mo, wur cin ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan. Ɓe wur yilang gǝǝl aas nǝ mo, wur shin jeplep wur mo, mbǝkǝ mo shwap ɗe ngurum nǝ mo, ɓe jeplep wur nǝ mo shwap ngurum nǝ mo se. ");
INSERT INTO sur_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mo kǝ rep pak pupwap mo ɗikǝ lee. Jesu cìn ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan nkaa pupwap nǝ mo, ɓe wur shin jeplep wur mo, mbǝkǝ mo shin ɗe ngurum nǝ mo se zak. ");
INSERT INTO sur_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɗuu gurum nǝ mo se, har mo ǝɓǝl jir. Ɗangɓe jeplep Jesu mo kok koor mbiise ɗe nǝ ɗee ɗe, ɓe nǝ gam kǝcik mo pwovǝl. ");
INSERT INTO sur_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɗuu gurum ɗe mo se mbiise nǝ mo wul ngal feer. Aɓwoon mǝnǝ, ɓe Jesu ɓwet gurum nǝ mo shin waa. ");
INSERT INTO sur_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɓe abet, Jesu ɗel nɗǝǝn tii ashak kǝ jeplep wur mo, ɓe mo ɗel dǝm nyil nDalmanuta. ");
INSERT INTO sur_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pak nen Farisi mo jì pee Jesu ɗe, ɓe mo ɗoom ɓeetshik kǝ Jesu, mbǝkǝ mo kam wur ɗe. Ɓe mo sat nwur nǝnee, <<A cìn mee mbii aapwoo ɗe nǝ tong aɗeng sham ɗe.>> ");
INSERT INTO sur_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ɓe Jesu nook puut kǝ tuup. Wur sat mmo nǝ, <<A me le ɗang gurum ɗe nyiicinsǝ moo rǝɓet naa mee mbii aapwoo ɗe nǝ tong aɗeng sham ye? Azeen, kǝn sat nwun nǝ, baa mon nkám mee mbii aapwoo nen ɗe nyiicinsǝ mo kas.>> ");
INSERT INTO sur_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesu yool yit mo, ɓe wur baa ɗel nɗǝǝn tii am, mbǝkǝ wur can am ɗel dǝm nkor ɗesí. ");
INSERT INTO sur_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jeplep Jesu mo munsut mmang gǝǝl aas pan, ɗang ɓe mo kǝ memee mǝndong ɓejee nɗǝǝn tii nǝ. ");
INSERT INTO sur_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu sat mmo shiɓal nǝnee, <<Wu tap kǝ kám (yist) mǝ nen Farisi mo kǝ mǝ Herot.>> ");
INSERT INTO sur_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jeplep wur nǝ mo ɗoom ɓeet ashak, nǝnee, <<Wur sat pwoo mǝnǝ a mbǝɗe baa mun kǝ gǝǝl aas kas.>> ");
INSERT INTO sur_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu man mbii ɗe moo ɓeet nǝ, ɓe wur sat mmo nǝnee, <<A me le ɗang wuu ɓeet nnǝ, baa wun kǝ gǝǝl aas kas yi? Tan, har yaksǝ ɓe baa wu naashii nǝ kǝ wu man kas aa? Pǝtuup fuu nǝ mo ɗee a ɗeɓal ɗe mo cíi manshii kǝ nǝ me? ");
INSERT INTO sur_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wun kǝ yit, mɓe naapee, ɓe baa wu naapee shi shik kas aa? Wun kǝ kom mɓe kǝlǝngpee, ɓe baa wun kǝlǝngpee shi shik kas aa? Wuu munshik ee? ");
INSERT INTO sur_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gǝǝl aas ɗepaat sǝ mo, ɗe di an yilang nshin ngurum mo ngal paat mo se sǝ. Ɓe di wu kok koor gǝǝl aas ɗe nǝ ɗee ɗe, ɓe di nǝ gam kǝcik mo a kong ye?>> Mo lap nǝ, <<di nǝ gam kǝcik mo kaapaat baavǝl.>> ");
INSERT INTO sur_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Koo ɗang wuu munshik gǝǝl aas ɗe pwovǝl sǝ mo, ɗe di an yilang nshin ngurum mo ngal feer mo se sǝ ye? Ɓe di wur kok koor gǝǝl aas ɗe nǝ ɗee ɗe, ɓe di nǝ gam kǝcik mo a kong yi?>> Mo lap nǝ, <<di nǝ gam kǝcik mo pwovǝl.>> ");
INSERT INTO sur_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesu sat mmo nǝnee, <<To, ɓe yaksǝ, baa wu manshii nǝ kas aa?>> ");
INSERT INTO sur_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mo jì wul mBetseda. Ɓe mee des mo jì kǝ mee nguvum pee Jesu ɗe. Mo ɗang pǝ wur, kǝ wur tung nguvum nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ɓe Jesu yaa nguvum nǝ nsar, ɓe wur put kǝ nguvum nǝ aɓwoon laayil nǝ. Kaaɗe Jesu tus lii nkaa yit kǝ nguvum nǝ, ɓe wur lesar wur mo nkaa nguvum nǝ. Ɓe wur tal pǝ nguvum nǝ nǝnee, <<Aa naa mee mbii ye?>> ");
INSERT INTO sur_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ɓe nguvum nǝ wur ɗyeep yit, ɓe wur lap nǝnee, <<Ii, wen naa gurum mo, ɗang ɓe nghan naa mo, a kaa tǝng ɗe moo mwaan sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu baa lesar fin mo nkaa nyit gwar nǝ, ɓe yit gwar nǝ wang, ɓǝ wur naapee, har wur naa mbii mo rǝret jir. ");
INSERT INTO sur_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu ɓwet gwar nǝ shindǝm ntul fir, ɗang wur sat ngwar nǝ nǝnee, <<Taji a baa ɗel nɗǝǝn laayil nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu kǝ jeplep wur mo yool put, ɓe mo dǝm ɗel nɗǝǝn jepyil ɗe mo nkwang nSizariya mǝ Filipi. Kaaɗe mo a ar, ɓe Jesu tal pǝ jeplep wur mo nǝnee, <<Gurum moo sat nǝ an a weyi?>> ");
INSERT INTO sur_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jeplep nwur mo lap nǝnee, <<Pak gurum nǝ moo sat nǝnee, <gha a Joon ngucìn baptisma,> ɗang pak moo sat zak nǝnee, <gha a Ilaija.> Pak moo sat nǝnee, <gha a memee mɓut nensatpwoo Naan mo.>> ");
INSERT INTO sur_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesu tal pǝ mo nǝnee, <<Amma wun, wuu sat nǝ, nghan a weyi?>> Pita lap nwur nǝ, <<Gha a Kristi.>> ");
INSERT INTO sur_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu satpwoo mmo shiɓal nǝ, taji mo sat mee pwoo nkaa wuɗi a Kristi Nguɓam ɗe Naan lep kas. ");
INSERT INTO sur_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aɓwoon mǝnǝ, ɓe Jesu ɗoom kám jeplep wur nǝ mo nǝnee, <<Nǝ a tǝng Làa Gurum, wur nshwaajeel mo ɗes shini-shini, kǝzak, nennan-nan mo, kǝ pris ɗenan mo, kǝ nenkám Wàar Mosis mo, mon chii wur, ɗangɓe mon ntu wur. Ɓe parpuus ɗekun, ɓe wur mbaa yool a peemúut.>> ");
INSERT INTO sur_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesu satpwoo ɗesǝ mmo agaak, ɓe Pita pet Jesu dǝm kǝ wur mmee kwang coot, ɓe wur jǝǝr wur. ");
INSERT INTO sur_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma Jesu ciir naa jeplep wur nǝ mo, ɓe wur sat mPita nǝnee, <<A baku pee an ɗe, gha Shetan! Mɓeɗi baa gha aa pan a mbii ɗe mo a mǝ Naan kas. Amma pan fwaa nǝ a mǝ gurum mo ɓejee.>> ");
INSERT INTO sur_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu pǝrep ɗuu gurum nǝ mo ashak kǝ jeplep wur nǝ mo, ɓe wu sat mmo nǝnee, <<Katɗang mee gurum rǝɓet jì nɗang an, ɓe naa tǝng wur cii shin kǝ wur ɗakshin ɗe mɓe shwaajeel, nǝn nɗee a kaa wur mang a shiyeepmúut fin, kǝ wur jì ɗe nɗang an sǝ. ");
INSERT INTO sur_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Koo gwar ɗeɗangyi ɗewur rǝɓet ɓam seen fir, ɓe nǝn nloom wur, amma koo gwar ɗeɗang ye, ɗewur shin seen fin mbe sǝm fen, kǝ mɓe pwoo ɗeret nǝ zak, ɓe gwar mǝnǝn nkat seen. ");
INSERT INTO sur_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gurum nkat a lǝɓet ɗeɗang ye, katɗang wur kat mbii ɗe mǝ yil nǝ mo jir, amma katɗang seen wur loom a wu, ɓe kwoop mbii mǝnǝ mo a meyii? ");
INSERT INTO sur_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A me a mbii ɗe gurum wu nshin a koppee kǝ seen wur yi? ");
INSERT INTO sur_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Koo gwar ɗeɗangyi ɗe naashwoop yaa wur mɓe nghan, kǝ kám fen mo nyiicinsǝ, ɗe nǝ a mǝ nenɓutbish mo, kǝ nen ɗe baa mo man Naan kas. Ɓe Làa Gurum, wur ncìn naashwoop kǝ gwar nǝ zak, parpuus ɗe wu njì nɗǝǝn ɗeɗes mǝ puun wur ɗe ashak kǝ nenlep Naan ɗeɓang mo.>> ");
INSERT INTO sur_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu sat mmo nǝnee, <<Azeen nzeen kǝn sat nwun nǝ, pak mo ɗe nɗǝǝn nen ɗe moo ɗirang mpeesǝ, baa mon mmurep kas, naa tǝng mo naa mulki Naan nǝ jì shi mbal akuɗang.>> ");
INSERT INTO sur_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","nƁwoon teer mo peemee, ɓe Jesu mang Pita, kǝ Jemis, kǝ Joon. Wur kàa kǝ mo a mee ɗeng jwak ɗewurang, mon mbusut. Ɓe fwoshik Jesu nǝ cǝǝr nɗǝǝn ɗeɗes wur a yit fur. ");
INSERT INTO sur_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nlǝr wur mo cǝǝr ɗee a ɗepiyaa pet-pet, ɗangɓe nǝ mang yit mmo. Baa mee gurum nɗǝǝn yil sǝ mak vwang nlǝr piyaa kaa mǝnǝ sǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɗangɓe jeplep Jesu mo naa Mosis, kǝ Ilaija mon nkaa leshap kǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ɓe Pita sat nJesu nǝnee, <<Ngukám, nǝ ret kaaɗi mun ɗe mpeesǝ sǝ. A yit kǝ mo ɗyik bìt mo kun, memee gha, memee Mosis, kǝ me ɗi Ilaija.>> ");
INSERT INTO sur_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Baa Pita man mbii ɗe nwur nsat kas, mbǝɗe kǝǝrmuut nii fes yaa mo. ");
INSERT INTO sur_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɗangɓe nluu jì paa mo, kǝ mo kǝlǝng mee ɗoo nǝ put nɗǝǝn nluu nǝ, ɗe nǝ sat nǝnee, <<Ɗesǝ a Làa fen, ɗe wen nwal nwur zam. Wu kǝlǝng wur.>> ");
INSERT INTO sur_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Abet, kaaɗi mo ciir naapee, ɓe baa mo naa mee gurum kuɗi ashak kǝ mo kas, ɓe a Jesu nbǝshin ɓejee. ");
INSERT INTO sur_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kaaɗe mo a ar sham aɗeng jwak nǝ, ɓe Jesu sat mmo shiɓal nǝ, taji mo sat mmee gurum mbii ɗe mo naa kas, naa tǝng Làa Gurum wur yool a peemúut akuɗang. ");
INSERT INTO sur_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baa mo sat mbii ɗe mo kǝ naa nǝ mmee gurum kas, amma mo tal peshak nǝnee, <<A me a shii kǝ yool a peemúut nǝ yi?>> ");
INSERT INTO sur_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mo tal pǝ Jesu nǝnee, <<A me le ɗang nenkám Wàar Mosis mo sat nǝnee, <<Ting Ilaija wur shee jì akuɗang yi?>> ");
INSERT INTO sur_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu lap mmo nǝnee, <<Ilaija wur nshee jì, mbǝkǝ wur ɗak mbii mo ɗe reret jir. Ɓe a me le ɗangɓe mo kǝ ten ran nǝ, Làa Gurum wur nshwaajeel mo ɗes shini-shinǝ mon mɓák wur, kǝ le wur a ɗebuu yi? ");
INSERT INTO sur_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma wen sat nwun nǝ, Ilaija wur kǝ ten jì, kǝ mo kǝ cìn mbii ɗe mo rǝɓet kǝ wur jir, kaaɗi mo kǝ ran nɗǝǝn ɓǝǝt haal Naan nkaa wur sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kaaɗe mo sham wul pee kor jeplep wur nǝ mo ɗe, ɓe mo naa ɗuu gurum mo ɗes pee mo ɗe, kǝ nenkám Wàar Mosis mo, mo nkaa ɓeetshik kǝ nen mwaan nɗang Jesu nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaaɗe ɗuu gurum nǝ mo naa Jesu, ɓe nǝ aapwoo mo jir. Abet, ɓe mo shwe dǝm pee wur ɗe, ɓe mo tok kǝ wur. ");
INSERT INTO sur_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu tal pǝ jeplep wur nǝ mo nǝnee, <<Wuu cin a ɓeetshik me kǝ mo yi?>> ");
INSERT INTO sur_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɓe mee gwar mɓut ɗuu gurum nǝ mo wur lap nǝnee, <<Ngukám, wen jì kǝ làa fen pee gha ɗe, mbǝɗe wur kǝ riin ɗebish, ɗe nǝ kǝ cíi leshap nwur. ");
INSERT INTO sur_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tong ɓe nii jì yool yaa wur karmat, ɓe nii mang wur shweer nyil, ɗang tǝfil kǝ jì put nwur mpwoo, ɗang wur kǝ sǝm oos, ɗangɓe nii le kǝ fwoshik wur nǝ fii. Wen ɗang pǝ jeplep fwaa mo, mbǝkǝ mo ceen riin ɗebish nǝ put ɗe, amma baa mo mak kas.>> ");
INSERT INTO sur_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu sat mmo nǝnee, <<Wun nen ɗe nyicinsǝ baa wur shinzeen kas! Wen ntong ashak kǝ wun mɓe vit aa? Wu jì kǝ làa nǝ pee an ɗi.>> ");
INSERT INTO sur_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mo jì kǝ làa nǝ pee Jesu ɗi. Kaaɗe riin ɗebish nǝ naa Jesu, ɓe abet nǝ yoon làa nǝ, nǝ mang wur shweer nyil, ɓe làa nǝ wur bǝring nyil, tǝfil jì put nwur mpwoo. ");
INSERT INTO sur_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu tal pǝ puun làa nǝ nǝnee, <<Mbii ɗesǝ nǝ yaa cìn ɗyem fwaa nǝ a pǝrangyi?>> Puun nǝ wur lap nǝnee, <<Pǝgyet wur kuɗi a làa ɗelee. ");
INSERT INTO sur_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nii naa mang wur vwet nɗǝǝn wus, kǝ nɗǝǝn am zak, mbǝkǝ nǝ tu wur ɗi. Amma katɗang gha mak cìn mee mbii, ɓe a naajeel fen, kambok a ɓam mun.>> ");
INSERT INTO sur_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu sat nwur nǝnee, <<A me le ɗang waa sat nǝnee, <Katɗang wen mak yi?> Ngwar ɗewur shinzeen, ɓe mbii mo jir, mon mmak cìn mɓe wur.>> ");
INSERT INTO sur_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Abet-abet, ɓe puun làa nǝ wur ɗyeep ɗoo fir nǝnee, <<Wen shinzeen. A ɓam an kǝ ciin shinzeen fen nǝ!>> ");
INSERT INTO sur_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kaaɗe Jesu naa ɗes gurum nǝ mo jar jì kus-kus, ɓe wur gwak riin ɗebish nǝ, wur sat nnǝ nǝnee, <<Gha, riin ɗebish ɗe waa cíi leshap kǝ kǝlǝngpee ngurum. Wen sat ngha, a put mɓut nlàa nǝ. Taji a baa ɗel nɗǝǝn làa nǝ zak kas.>> ");
INSERT INTO sur_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aɓwoon ɗe riin ɗebish nǝ le or, ɓe nǝ yoon làa nǝ shiɓal, ɓe nǝ mang làa nǝ vwet nyil, ɓe nǝ put. Làa nǝ wur gan nyil kaa wur kǝ mumuut sǝ, ɗangɓe nǝǝn gurum nǝ mo sat nǝnee, <<Làa nǝ kǝ muut.>> ");
INSERT INTO sur_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amma Jesu yaa sar làa nǝ, wu ɗyeep wur, ɓe làa nǝ yool ɗar atǝng. ");
INSERT INTO sur_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aɓwoon mǝnǝ, ɓe Jesu ɗel nɗǝǝn lu, ɓe jeplep wur mo tal pǝ wur coot nǝnee, <<A me le ɗangɓe baa mun mu mak put kǝ riin ɗebish nǝ kas yi?>> ");
INSERT INTO sur_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu lap mmo nǝnee, <<Baa mbii kaa ɗesǝ nǝn mmak put kas, see a shi leshap kǝ Naan. >> ");
INSERT INTO sur_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesu kǝ jeplep wur nǝ mo yool yit peemǝnǝ, ɓe mo yaa ar ɗel nyil nGalili, ɓe baa wur rǝɓet kǝ gurum mo man peeɗi wur ɗe kas. ");
INSERT INTO sur_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mɓeɗi wur nkaa kam jeplep wur mo nǝnee, <<Mon nshin Làa Gurum nɗǝǝn sar gurum mo, ɓe mon ntu wur, ɗangɓe a puus ɗekun ɓe wur nyool a peemúut.>> ");
INSERT INTO sur_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma baa jeplep Jesu nǝ mo manshii pwoo mǝnǝ kas, ɗang mo kǝǝr tal nǝ pǝ wur zak. ");
INSERT INTO sur_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaaɗe mo jì wul nyil nKaparnahum, ɓe Jesu ɗel nɗǝǝn lu, ɓe wur tal pǝ jeplep wur nǝ mo nǝnee, <<Ɗe wuu ɓeetshik, a nkaa me, a ar sǝ yi?>> ");
INSERT INTO sur_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma mo ɗok tǝtǝk, mbǝɗe mo kǝ ɓeetshik kǝ shak a ar nǝ, a wii a ɗeɗes met jir nɗǝǝn ɗun yi? ");
INSERT INTO sur_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesu tong nyil, ɓe wur pǝrep jeplep wur ɗe kaapaat baavǝl nǝ mo, ɓe wur sat mmo nǝ, <<Katɗang mee gurum rǝɓet ɗen a ɗenshee, ɓe nǝ ret kǝ wu ɗee a ɗe aɓwoon, kǝ a wur nɗen a nguɗak niyee mo jir zak.>> ");
INSERT INTO sur_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wur pet mee làa ɗelee, ɓe wur le làa nǝ ɗar nnaar fur, ɓe wur mang làa nǝ nsar fin, ɓe wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Koo gwar ɗeɗangyii, ɗewur lap mee làa ɗelee kaa ɗesǝ sǝ, nɗǝǝn sǝm fen, ɓe gwar nǝ lap a nghan mmǝnǝ. Koo gwar ɗeɗangyi ɗewur lap an zak, ɓe baa wur lap a nghan mbǝsen ɓejee kas, amma wur lap a gwar ɗewur lep an shiin ji mmǝnǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joon sat nwur nǝnee, <<Ngukám ɗe mu naa mee gwar wu nkaa ceen riin ɗebish mo pwat nɗǝǝn gurum mo shi sǝm fwaa, ɓe mǝ cíi nwur, mbǝɗe baa wur a memee nɗǝǝn mun kas.>> ");
INSERT INTO sur_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amma Jesu sat mmo nǝnee, <<Taji wu cíi nwur kas. Mɓeɗi baa mee gurum mak cìn mee mbii aapwoo shi sǝm fen, ɗangɓe wur waa ciir satpwoo ɗebish nkaa an kas. ");
INSERT INTO sur_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mɓeɗi gwar ɗe baa wur a shaarlek fun kas, ɓe gwar nǝ a munu mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Azeen nzeen kǝ sat nwun nǝ, koo gwar ɗeɗangyii, ɗewur shin am nwun shwaa, mbǝɗe wun a mu Kristi mo, ɓe gwar mǝnǝn nlap kwat nǝ hakyeng.>> ");
INSERT INTO sur_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Koo gwar ɗeɗangyi ɗewur le kǝ memee mǝndong nɗǝǝn jep sǝ mo, ɗe mo shinzeen an, mo cìn shikbish, ɓe nǝ nret met kǝ mo ɗyiin mee fin ɗyees ɗak ɗetoon ntook gwar mǝnǝ, kǝ mo vwet wur ɗe nɗǝǝn am kuur. ");
INSERT INTO sur_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Katɗang sar fwaa nǝ le kǝ a cìn shikbish, ɓe a can nǝ a vwet. Mɓeɗi ngyal ɗesi ɓe a ɗel nɗǝǝn peeseen kǝ sar mǝndong, nǝ ret met aku ɗe mon nvwet gha nɗǝǝn aawus ɗe dǝm ngaa-ngaa, ɓe gha kǝ sar mo vǝl. ");
INSERT INTO sur_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A peeɗi nyet ɗe moo se gurum mo, baa mon cham murap kas, kǝ baa wus nǝn cham pit ɗe kas zak. ");
INSERT INTO sur_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kǝ katɗang ɓe shii fwaa nǝ le kǝ a cìn shikbish, ɓe a can nǝ a vwet. Mɓeɗi ngyal a ɗel nɗǝǝn peeseen shi shii mǝndong, nǝ ret met, aku ɗe mon nvwet gha nɗǝǝn aawus ɗe dǝm ngaa-ngaa ɓe gha kǝ shii mo vǝl. ");
INSERT INTO sur_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A peeɗi nyet ɗe moo se gurum mo, baa mon cham murap kas, kǝ baa wus nǝn cham pit ɗe kas zak. ");
INSERT INTO sur_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kǝ katɗang ɓe yit fwaa nǝ le kǝ a cìn shikbish, ɓe a pun nǝ a vwet. Mɓeɗi ngyal ɗeesi ɓe a ɗel nɗǝǝn mulki mǝ Naan kǝ yit mǝndong, nǝ ret met aku ɗe mon nvwet gha nɗǝǝn aawus ɗe dǝm ngaa-ngaa, ɓe gha kǝ yit mo vǝl. ");
INSERT INTO sur_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A peeɗi nyet ɗe moo se gurum mo, baa mon cham murap kas, kǝ baa wus nǝn cham pit ɗi kas zak. ");
INSERT INTO sur_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","<<Mon ncìn ɗak shi wus, mbǝkǝ mo le gurum mo pan shee ret ɗe jir, kaaɗi moo le kǝǝn nkaa mbii, mbǝkǝ taji nǝ wam kas sǝ. ");
INSERT INTO sur_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kǝǝn nǝ a mbii ɗeret, ɗang ɓe katɗang baa kǝǝn nǝ kuɗi kǝ shang kas, ɓe mon nɗak nǝ a shi me, mbǝkǝ nǝ waa shang ɗe yi? Wun jeplep fen mo, wu tongryang kǝ shak, kaa kǝǝn ɗe baa nii ɓàkshak kǝ shang nǝ kas sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu yool yit peemǝnǝ, ɓe wur dǝm nkwang yil nJudiya, wur canɗel nkor Jodan. Ɗuu gurum mo ɗes mo waaji kuur pee wur ɗi, ɗangɓe wur kámpwoo Naan mmo, kaaɗi wur loot kǝ nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pak nen Farisi mo jì pee wur ɗi, mbǝkǝ mo kam wur ɗi, ɓe mo tal nǝnee, <<Kyet Wàar Mosis nǝ sat nǝ, gurum mak ceen mat wur mbe koo a mbii ɗebish ɗeɗangyi ɗe war cìn waa?>> ");
INSERT INTO sur_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu lap mmo nǝnee, <<Gyet Mosis ran nnǝ, wur ncìn a meyii?>> ");
INSERT INTO sur_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mo lap nǝnee, <<Mosis ran nnǝ, gurum mak ceen mat wur, katɗang wur kǝ ten ran haal mǝ tuɗyik shin nwar.>> ");
INSERT INTO sur_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu sat mmo nǝnee, <<A mbǝɗe wun a nen cíishik mo, a nǝ le ɗang gyet Mosis ran Wàar ɗesǝ mo nwun. ");
INSERT INTO sur_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gyet a Naan wur le mish kǝ mat pugyet ɗe nshee kǝ yil nǝ. ");
INSERT INTO sur_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","<Mɓǝmǝnǝ ɓe gurum wur nyit puun kǝ nǝǝn wur mo, mbǝkǝ wur ɓalkaa wur ɗe ashak kǝ mat wur. ");
INSERT INTO sur_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ɗangɓe mo weet, mon nɗee a nan ɗemǝndong. Aɓwoon ɗese, ɓe baa mo kuɗi a gurum mo vǝl kas, amma moo ɗee a nan ɗemǝndong.> ");
INSERT INTO sur_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mbǝmǝnǝ, ɓe nen ɗe Naan wur kǝ ten ɓàl mo ashak, ɓe taji mee gurum ɓàk mo kas.>> ");
INSERT INTO sur_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kaaɗe mo ɗel nlu, ɓe jeplep wur mo waa baa tal shii pwoo mǝnǝ ɗe pǝ wur. ");
INSERT INTO sur_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɓe wur sat mmo nǝnee, <<Koo gwar ɗeɗangyi wur ceen mat wur, mbǝkǝ wur lap mee mat ɗecì ɗi, ɓe gwar mǝnǝ cìn a ngaa nkaa mat wur ɗe mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kǝ katɗang ɓe, mee mat war yit mish war, mbǝkǝ war dǝm ɗyik ɗe mmee gwar ɗecì, ɓe war cìn a ngaa mmǝnǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pak gurum mo jì kǝ jep ɗe ɗyeen-ɗyeen mo pee Jesu ɗi, mbǝkǝ wu le ɗeret ɗe nkaa mo shi sar wur, ɓe jeplep wur mo gwak gurum nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Amma kaaɗi Jesu naa mǝnǝ, ɓe nǝ làa nwur mɓut, ɓe wur sat jeplep mu mo nǝnee, <<Wur yit kǝ jep ɗe ɗyeen-ɗyeen mo jì pee an ɗe, taji wur daam mo kas. Mɓeɗi mulki Naan nǝ a mɓe nen ɗe mo kǝ mǝse kaa mǝ jep ɗe ɗyeen-ɗyeen mo sǝ. ");
INSERT INTO sur_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Azeen-nzeen sat nwun nǝ, koo weye ɗe baa wur le Naan a ɗeɗes nɗǝǝn pǝtuup wur shi mǝse ɗe nǝ kaa mǝ jep ɗeɗyeen mo sǝ kas, ɓe baa wur mmak ɗel nɗǝǝn mulki Naan kas, koo dǝɓen.>> ");
INSERT INTO sur_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɗangɓe Jesu ghǝr jep nǝ mo nkaa baal wur, ɓe wur le sar nkaa mo, ɗang wur le ɗeret nkaa mo. ");
INSERT INTO sur_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kaaɗe Jesu yool put mɓe dǝm, ɓe mee gwar su jì kurum nfurum ntoom wur. Gwar nǝ tal pǝ wur nǝnee, <<Ngukám ɗeret, an ncìn a ɗak ɗeret ɗeɗang, mbǝkǝ wen kat seen ɗe dǝm ngaa-ngaa ɗe yi?>> ");
INSERT INTO sur_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu lap nwur nǝnee, <<A me le ɗang a pet an a Ngukám ɗeret yi? Baa mee gurum ɗe a ɗeret kas, see a Naan mbǝshin ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gha man mbii ɗe Wàar Mosis nǝ mo sat jir nǝnee, <Taji a tukáa kas. Taji a cìn ngaa kas. Taji a cìn wat kas. Taji a cìn langtǝng mǝ ɗung nkaa gǝnang fwaa kas. Kǝ taji a seen a gurum mo kas. A shin ɗeɗes mpuun fwaa, kǝ nǝǝn fwaa.> >> ");
INSERT INTO sur_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gwar nǝ wur lap nǝnee, <<Ngukám, nghan kǝn ten tap Wàar ɗesǝ mo jir pegyet din kuɗi a làa zǝlang.>> ");
INSERT INTO sur_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu naa gwar nǝ shi wal, ɓe wur sat ngwar nǝ nǝnee, <<A mbii mǝndong ɗee ɗe nghan ɓejee. A dǝm, a sǝrep long fwaa mo jir, kǝ a ɓàk shool nǝ ɗe nenjeel mo, ɗangɓe waa nkat long nɗǝǝn ɗengnaan. Aɓwoon mǝnǝ, ɓe a jì nɗang nghan.>> ");
INSERT INTO sur_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaaɗe gwar nǝ wur kǝlǝng pwoo mǝnǝ, ɓe nǝ wàt pǝtuup nwur, ɗangɓe wur waa baa shi pǝtuup ɗewuwat, mbǝɗe wur kǝ long mo ɗes zam. ");
INSERT INTO sur_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu lyap jeplep wur mo cǝǝrkaat, ɓe wur sat mmo nǝnee, <<Nin nluk, kǝ nenlong mon nɗel nɗǝǝn mulki Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kaaɗe jeplep wur mo kǝlǝng pwoo mǝnǝ, ɓe nǝ aapwoo mmo zam. Jesu baa sat mmo zak nǝnee, <<Jep fen mo, nǝ luk, kǝ gurum wur ɗel nɗǝǝn mulki Naan. ");
INSERT INTO sur_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngyal ɗesǝ ɓe raakumi nkǝlak ɗel nɗǝǝn fung ngilili, met aku ɗe ngulong wur ndel nɗǝǝn mulki Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaaɗe jeplep wur mo waa baa kǝlǝng pwoo mǝnǝ, ɓe nǝ sǝǝt aapwoo mo zam. Ɓe mo sat kǝ shak nǝnee, <<Katɗang mbii nǝ aasǝ, ɓe a wii mmak kat ɓam yi?>> ");
INSERT INTO sur_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Amma Jesu lyap mo, ɓe wur sat mmo nǝnee, <<Baa gurum mak cìn mbii ɗesǝ mo kas, amma Naan wur mak cìn mbii mo jir.>> ");
INSERT INTO sur_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ɗangɓe Pita sat nǝnee, <<A naa, mun kǝ yit mbii mo jir, mbǝkǝ mu dǝm ɗi nɗang gha.>> ");
INSERT INTO sur_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu sat mmo nǝnee, <<Azeen kǝn sat nwun, koo a gwar ɗeɗangyi ɗewur yit tul, koo ɗyemnǝǝn ɗemish mo, koo ɗyemnǝǝn ɗe mat mo, koo nǝǝn, koo jep mo, koo mmaar, mɓe sǝm fen, kǝ mɓe pwoo ɗeret, ");
INSERT INTO sur_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɓe wur nkat tul mo, kǝ ɗyemnǝǝn ɗemish mo, kǝ ɗyemnǝǝn ɗe mat mo, kǝ nǝǝn mo, kǝ jep mo, kǝ mmaar mo, har mo wul kambil nyiicinsǝ, ashak kǝ shwaajeel, kǝ wur nkat seen ɗe dǝm ngaa-ngaa nɗǝǝn seen ɗe nǝn pǝ jì zak. ");
INSERT INTO sur_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pak gurum ɗenshee mo ɗes, mon nyool ɗee a nen ɗe aɓwoon mo. Nen ɗe aɓwoon mon nyool ɗee a nen ɗenshee mo zak.>> ");
INSERT INTO sur_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kaaɗe mo a ar kàa nJerusalem, ɓe Jesu táa kyeen mmo ɓe nǝ aapwoo mo, kǝ nǝ lekǝǝrmuut nen ɗe moo dǝm nɗang wur nǝ mo. Ɓe Jesu pǝrep jeplep wur ɗe kaapaat baavǝl nǝ mo, dǝm mmee kwang mbǝsut, ɓe wur sat mmo mbii ɗe mon nkàa cìn nwur nJerusalem. ");
INSERT INTO sur_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nǝnee, <<Wu naa, mun a ar kàa nJerusalem nɗesi, katɗang mu wul, ɓe mon nseet Làa Gurum nɗǝǝn sar pris ɗenan mo, kǝ nen kám Wàar kǝ Mosis mo, ɗang mon ncanɗyeel muut nwur. Mon nshin wur nsar nen ɗe baa mo a nen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kǝ mon nshwar wur, mon ntwas lii nkaa wur. Mon nfwo nɓwat nwur, mon ntu wur zak, ɗangɓe parpuus ɗekun, ɓe wur nyool a peemúut.>> ");
INSERT INTO sur_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ɗangɓe Jemis kǝ Joon, jep Zeɓeɗi mo, mo jì pee Jesu ɗi, ɓe mo sat nwur nǝnee, <<Ngukám, muu rǝɓet kǝ koo a meye ɗi mu ɗang pǝ gha ɓe a cin mmun.>> ");
INSERT INTO sur_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu tal pǝ mo nǝnee, <<Wuu rǝɓet kǝ wen cin a me nwun ye?>> ");
INSERT INTO sur_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mo lap nwur nǝnee, <<Katɗang a rǝɓet, ɓe parɗe ghan ntong nɗǝǝn ɗeɗes fwaa, ɓe a le kǝ mun mu tong ashak kǝ gha, memee nsarse fwaa, kǝ memee nsarkul fwaa zak.>> ");
INSERT INTO sur_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu sat mmo nǝnee, <<Baa wur man mbii ɗe wuu ɗang nǝ kas. Wun mmak shwaajeel ɗe nghan nshwaa nǝ aa? Wun mmak lap baptisma ɗe mon ncìn nghan nǝ aa? ");
INSERT INTO sur_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mo lap nǝnee, <<Ii mun mmak.>> Ɗangɓe Jesu sat mmo nǝnee, <<Azeen wun mmak nshwaajeel ɗe wen nshwaa nǝ, kǝ baptisma ɗe mon ncìn nghan nǝ. ");
INSERT INTO sur_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amma mbe shin pee nwun tong nsarse fen, kǝ nsarkul fen, baa an kǝ ɓal ɗe an ncin mǝnǝ nwun kas. Amma nǝ a mɓee nen ɗe Naan wur kǝ ten ɗak nǝ le mbe mo.>> ");
INSERT INTO sur_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kaaɗe jeplep wur ɗe kaapaat sǝ mo kǝlǝng ɗang mǝnǝ, ɓe mo langtuup kǝ Jemis kǝ Joon. ");
INSERT INTO sur_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu pǝrep mo jì ashak jir, ɓe wur sat mmo nǝnee, <<Wu man nǝ, a mishkom nen ɗe baa mo a nenyil Yahudi mo kas, moo lesut fur mo a ɗeɗes nkaa nen fur mo, kǝ nennan fur mo, moo kám iiko fur mo zam, nkaa gurum nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma baa nǝn nɗen nnaar fuu aasǝ kas. Koo gwar ɗeɗangyi ɗewur yool ɗee a ɗeɗes nnaar fuu, ɓe nǝ a tǝng kǝ wur sham kǝ káa wur, mbe cìn ɗak nwun. ");
INSERT INTO sur_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kǝ koo gwar ye ɗewur rǝɓet ɗee a ɗenshee nɗǝǝn wun, ɓe nǝ a tǝng kǝ wur ɗee a kǝrem fuu jir. ");
INSERT INTO sur_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Baa Làa Gurum wur jì a mbǝkǝ gurum mo cìn ɗak ɗe nwur kas, amma a mbǝkǝ wur cìn ɗak ɗe ngurum mo, kǝ wur shin seen fir ɗi mbe ang gurum mo ɗes zak.>> ");
INSERT INTO sur_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mo jì wul nJeriko, ɓe kaaɗi Jesu a ar put nɗǝǝn Jeriko nǝ, ashak kǝ jeplep wur mo, kǝ ɗuu kǝ gurum mo ɗes. Ɓe mee nguvum ɗe moo pet sǝm wur a Bartimawus làa Timawus, wur kǝ tong a pwoo ar mbe ɗang-ɗang. ");
INSERT INTO sur_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kaaɗe nguvum nǝ wur kǝlǝng nǝ, a Jesu ngu Nazaret, ɓe wur yaa ɗyeep ɗoo shiɓal nǝnee, <<Jesu, Làa Devit, a naajeel fen!>> ");
INSERT INTO sur_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gurum mo ɗes mo gwak wur, ɓǝ mo sat nwur ɗok kǝtǝk. Dang ɓe wur waa sǝǝt ɗyeep ɗoo ɓalɓal nǝnee, <<Làa Devit, a naajeel fen.>> ");
INSERT INTO sur_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu ɗar, ɓe wur sat mmo nǝnee, <<Wu pet wur shin ji.>> Ɗangɓe mo pet nguvum nǝ, mo sat nwur nǝnee, <<Taji kǝǝrmuut yaa gha kas. A yool, Jesu kǝ pet gha.>> ");
INSERT INTO sur_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nguvum nǝ wur vwet mbiisǝp wur, ɓe wur sham yool wuret, dǝm pee Jesu ɗe. ");
INSERT INTO sur_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu tal pǝ wur nǝnee, <<Aa rǝɓet kǝ nghan cìn a me nghan ye?>> Nguvum nǝ wur lap nǝnee, <<Ngukám, a le kǝ yit fen mo naapee.>> ");
INSERT INTO sur_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu sat nwur nǝnee, <<To yit fwaa mo naapee ɗak, mbǝɗe waa shinzeen nnǝ an mbar gha.>> Abet-abet, ɓe yit wur nǝ mo naapee. Ɓe wur dǝm nɗang Jesu, kǝ wur shin ɗeɗes nNaan. ");
INSERT INTO sur_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kaaɗe mo jì wul kus kǝ Jerusalem, ɓe mo jì wul mBetfaji, kǝ Betani mǝ Jwakpaat. Ɓe Jesu lep jeplep fir mo vǝl. ");
INSERT INTO sur_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wur sat mmo nǝnee, <<Wur dǝm nɗǝǝn laayil ɗe nǝ a kyeen fuu sǝ. Katɗang wu wul, ɓe abet, wun nkat mee làa jaaki ɗe a ɗiɗiin, ɗe baa mee gurum kǝ cam lang nkaa nǝ kas. Ɓe wur shang wur jì kǝ nǝ mpesi. ");
INSERT INTO sur_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Katɗang mee gurum tal pǝ wun nǝnee, <A me le ɗang wuu shang jaaki nǝ yi?> Ɓe wur sat nǝ, a Daa wur kǝ rǝɓet nǝ. Aɓwoon ɓe wu mbaa lep nǝ shi jì abet.> >> ");
INSERT INTO sur_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mo dǝm kat làa jaaki nǝ a ɗiɗiin mpolu kus kǝ pwoo ar. Kaaɗe mo yaa shang nǝ, ");
INSERT INTO sur_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ɓe nen ɗe moo ɗar ɗe a pee nǝ, mo sat nǝnee, <<A me le ɗang wuu shang làa jaaki nǝ yi?>> ");
INSERT INTO sur_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓe jeplep nǝ mo lap nciit kǝ mbii ɗe Jesu sat mmo. Ɗangɓe nenjaaki nǝ mo yit mmo dǝm ɗe kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kaaɗe jeplep nǝ mo jì kǝ làa jaaki nǝn Jesu, ɓe mo le nlǝr fur mo nkaa jaaki nǝ, ɓe Jesu lang nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gurum mo ɗes mo paa ar nǝ shi nlǝr fur mo, ɓǝ pak mo saa kom kǝkar mɓut mmaar mo, mo paa ar nǝ shi-shik zak. ");
INSERT INTO sur_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nen ɗe mo akyeen, kǝ ɗe mon mɓwoon Jesu, mo ɗyeep ɗoo fur mo sat nǝnee, <<Hosana! Daa le ɗeret nkaa gwar ɗewur jì nɗǝǝn sǝm Daa! ");
INSERT INTO sur_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Naan le ɗeret nkaa mulki ɗe mu puun fun Devit nǝ, nii jì wul. Hosana Naan nɗǝǝn mulki fin.>> ");
INSERT INTO sur_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kaaɗe Jesu ɗel nɗǝǝn Jerusalem, ɓe wur ɗel nɗǝǝn Lu Naan ɗeɗes nǝ. Ɓe wur naa mbii mo ɗe nɗǝǝn Lu Naan nǝ jir. Kaaɗe kansǝǝn kǝ ten cìn, ɓe wur put dǝm nBetani ashak kǝ jeplep wur ɗe kaapaat baavǝl sǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Daɗaar nǝ, ɓe kaaɗi mo kǝ yool yit Betani nǝ, ɓe neenláa nJesu. ");
INSERT INTO sur_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaaɗe wur naa mee tǝngkyeen kǝ ɗee jong, ɗe nǝ lǝhǝt kǝ kom zam, ɓe wur dǝm mbe naa tǝngkyeen nǝ, kyet nii mee làa mo wa, ɗangɓǝ wur kat nii lǝhǝt aa kompee ɓejee ɗak, mbǝɗe baa a tar làa mǝ keen nǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesu sat ntǝngkyeen nǝ nǝnee, <<Taji mee gurum kuɗi kǝ se làa kyeen mɓut wii zak kas.>> Jeplep wur mo kǝlǝng pwoo ɗewur sat ntǝngkyeen nǝ. ");
INSERT INTO sur_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kaaɗe mo jì wul nJerusalem. Ɓe Jesu ɗel nɗǝǝn Lu Naan ɗǝɗes, wur yaa ceen nenwer mo, kǝ nenseet mbii mo nɗǝǝn Lu Naan ɗeɗes nǝ. Wur bǝrep teebul mǝ nen pǝring shool mo, kǝ mbii tong mǝ nensǝrep mbul mo. ");
INSERT INTO sur_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Baa wur yit kǝ mee gurum mang mee mbii ji ɗel seet kǝnǝ afur nɗǝǝn lu Naan nǝ kas zak. ");
INSERT INTO sur_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wur kám ngurum nǝ mo nǝnee, <<Nǝ a rǝran nɗǝǝn ɓǝǝt haal Naan nǝnee, <Mon mpet lu fen a lu ɗangnaan (leshap kǝ Naan) mbe gurum ɗe mo nɗǝǝn yil nǝ jir,> amma wun kǝ ciir kǝ ni, kǝ nǝ ɗee a gwoot mu nwat mo.>> ");
INSERT INTO sur_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kaaɗe pris ɗenan mo, kǝ nenkám Wàar Mosis mo kǝlǝng pwoo mǝnǝ, ɓe mo tang ar ɗe mon ntu Jesu ɗe. Amma mo kǝǝr wur, mbǝɗe kám wur nǝ aapwoo nɗuu gurum nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kaaɗe kansǝǝn cìn, ɓe Jesu kǝ jeplep fir mo, mo pwat yit yilkaam nǝ. ");
INSERT INTO sur_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Daɗar mɓít, ɓe kaaɗi mo a ar ɗel, ɓe mo taa naa tǝngkyeen nǝ kǝ fii sham put jir. ");
INSERT INTO sur_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kaaɗe Pita panpwoo ɗe doon Jesu sat ntǝngkyeen nǝ, ɓe wur sat nJesu nǝnee, <<Ngukám, a naa tǝngkyeen ɗe doon a le ɗoor sí, nǝ kǝ fii jee.>> ");
INSERT INTO sur_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu sat mmo nǝnee, <<Wu shinzeen nNaan. ");
INSERT INTO sur_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɓe azeen-nzeen kǝn sat nwun nǝ, koo a gwar ɗeɗangyi ɗewur sat njwak ɗesǝ nǝnee, <A yool a sham a taa nɗǝǝn am kuur sǝ.> Katɗang baa gwar nǝ sat pwoo mǝnǝ a shi pǝtuup vǝl kas, amma gwar nǝ shinzeen nǝ, mbii ɗewur sat nǝn ncìn, ɓe nǝn ncìn. ");
INSERT INTO sur_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A mpeemǝnǝ, ɓe wen sat nwun nǝ, koo mbii ɗeɗangyi ɗe wu cìn ɗangnaan (leshap kǝ Naan) mɓe nǝ, ɗang wur shinzeen nǝ, wuu ten wur lap mbii ɗewur ɗang nǝ, ɓe Naan wur nshin nwun. ");
INSERT INTO sur_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kǝ koo a pǝrangye ɗe wu yaa chìn ɗangnaan (leshap kǝ Naan), ɓe wur fwo shikbish ɗe gurum mo cìn nwun, mbǝkǝ Naan puun fuu ɗe aɗeng wur fwo shikbish fuu mo ɗe nwun zak. ");
INSERT INTO sur_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mɓeɗi katɗang baa wur fwo shikbish ɗe gurum mo cìn nwun kas, ɓe baa Naan puun fuu ɗe aɗeng wur nfwo shikbish fuu mo wun kas zak. ");
INSERT INTO sur_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mo waaji nJerusalem, ɓe kaaɗi Jesu nkaa mwaan nɗǝǝn Lu Naan ɗǝɗes, ɓe pris ɗenan mo, kǝ nenkám Wàar Mosis mo, kǝ nennan-nan mo, mo jì pee wur ɗi. ");
INSERT INTO sur_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɓe mo tal pǝ wur nǝnee, <<Waa aa cìn mbii ɗesǝ mo a shi iiko ɗeɗangyii? A wii shin iiko ɗesǝ nwaa yi?>> ");
INSERT INTO sur_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu lap mmo nǝnee, <<Wen kǝn rǝɓet tal mee mbii pǝ wun ɗe zak. Katɗang wu lap nghan, ɓe an nsat nwun iiko ɗe nghan kǝn cìn mbii ɗesǝ mo shi shik zak. ");
INSERT INTO sur_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kyet gyet a Naan lep Joon mbǝkǝ wu jì cìn baptisma ɗe ngurum mo aa? Aa koo gyet a gurum mo lep wu yi? Wu lap nghan.>> ");
INSERT INTO sur_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mo ɓeet ɓwet nshak nǝnee, <<Katɗang mu sat nǝ, Gyet a Naan lep wur shin ji, ɓe wur nsat nǝnee, <A me le ɗang baa gyet wu shinzeen nwur kas ye?> ");
INSERT INTO sur_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɗangɓe katɗang mu sat nǝ, gyet a gurum lep Joon jì, ɓe gurum nǝ mon nlangtuup.>> Moo kǝǝr gurum mo, mbǝɗe gurum nǝ mo jir moo le Joon a ngusatpwoo Naan. ");
INSERT INTO sur_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɗangɓe mo lap nJesu nǝnee, <<Baa mu man kas.>> Jesu sat mmo nǝnee, <<Katɗang nǝ aasǝ, ɓe baa wen nsat nwun gwar ɗe shin iiko nghan, mɓe cìn mbii aapwoo nǝ mo kas zak.>> ");
INSERT INTO sur_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesu ɗoom sat pwoo ngurum mo shi sǝmpwoo mo nǝnee, <<Gyet mee ngulu wur kop anab mo mbong wur, ɓe wur neer nǝ shi kok, wur ɓwan mee tuun mɓe ɗwat làa tǝng anab nǝ, kǝzak, wur ɗyik mee ɗengpee mɓe naa anab nǝ. Ɗangɓe wur yit mar nǝ nsar mee kǝ nennaa mar mo, mbǝkǝ mo naa bong nǝ ɗe nwur. Aɓwoon mǝnǝ, ɓe wur yool dǝm mmee yil. ");
INSERT INTO sur_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kaaɗe tar nung làa anab nǝ wul, ɓe wur lep mee kǝrem nwur dǝm pee nennaa maar anab nǝ mo ɗe, mbǝkǝ kǝrem lap pak làa anab nǝ dǝm kǝ nǝ ɗe nwur. ");
INSERT INTO sur_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɗangɓe nennaa maar anab nǝ mo yaa kǝrem ni, mo nǝram wur, ɓe mo ceen wur baa shi sar ɗe nfii. ");
INSERT INTO sur_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngulu nǝ wur waa baa lep mee kǝrem shiin dǝm pee mo ɗe zak. Ɓe mo nas wur nkáa, kǝ mo shínjeel nkǝrem mǝnǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aɓwoon mǝnǝ, ɓe ngulu nǝ wu waa baa lep mee kǝrem dǝm pee nennaa mar nǝ mo zak, ɓe mo yaa kǝrem mǝnǝ tu, kǝ moo naa ncìn mpak kǝrem nǝ mo aasǝ zak, har mo nǝram pak mo, kǝ mo twe pak mo. ");
INSERT INTO sur_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngulu nǝ wur ɗee ɗe kǝ memee mǝndong, ɗe mǝnǝ a làa wur ɗewur nwal nlàa nǝ zam. Ɓe wur lep làa nǝ dǝm pee nennaa bong nǝ mo ɗe, aɓwoon kǝ kǝrem nǝ mo jir. Ngulu nǝ wur pan nǝnee, <Nentap maar nǝ mon naa ɗeɗes kǝ làa fin.> ");
INSERT INTO sur_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ɗangɓe nennaa maar nǝ mo sat nshak nǝnee, <wu naa a làa ɗe mǝnǝn nyool ghǝr kop puun nǝ nɗesi, wu jì mmun, kǝ mǝ tu wur, mbǝkǝ kop nǝ ɗee ɗe a munu.> ");
INSERT INTO sur_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɗangɓe mo yaa làa nǝ tu, ɓe mo vwet kúm nǝ shin ciir mɓwoon kok maar nǝ. ");
INSERT INTO sur_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wur pan nǝ, ngumaar nǝ wur ncìn a me kǝ nennaa maar ɗesǝ nǝ mo ye? Wun njì twe nennaa mar ɗesǝ nǝ mo, mbǝkǝ wur le mee nennaa mar ɗecì mo ɗi. ");
INSERT INTO sur_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Baa wuu cam tang pwoo ɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan sǝ kas me? Ɗe nǝ sat nǝnee, <<nGhǝk ɗe nen ɗyiklu mo cii nǝ, <<Ɓe a nǝ ɗee a ɗeɗes nɗǝǝn kwang lu nǝ. ");
INSERT INTO sur_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɗesǝ nǝ a ɗak ɗe Daa wur kǝ ten cìn; <<Nǝ a mbii aapwoo pee mun ɗi!> >> ");
INSERT INTO sur_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nennan mǝ nen Yahudi mo yappee mɓe yaa Jesu, mbǝɗe mo man nǝ, wur sat sǝmpwoo ɗesǝ nǝ a nkaa mo, ɗangɓǝ baa mo mak yaa wur kas, mbǝɗe mo kǝǝr ɗuu gurum nǝ mo. Mbǝmǝnǝ, ɓe mo yool yit wur ɗe, ɓe mo dǝm ntul. ");
INSERT INTO sur_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɗangɓe nen Farisi mo kǝ nen nHerot mo lep pak nen fur mo shindǝm pee Jesu ɗe, mbǝkǝ mo kat mee mbii ɗe mon nyaa wur ɗi nɗǝǝn pwoo ɗewur sat mo. ");
INSERT INTO sur_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kaaɗe mo jì, ɓe mo sat nJesu nǝnee, <<Ngukám, mu man nǝ, gha a nguzeen, baa waa kǝ kak mee gurum kas, ɗang baa waa kǝ shangyit mmee gurum kas zak, ɗangɓǝ gha aa kám ar Naan ngurum mo azeen-nzeen. Kyet nǝn ndere kǝ mu kwatwap Siza, mishkoom ɗeɗes mu nen Rom mo aa, koo mu nook kwat nǝ yi?>> ");
INSERT INTO sur_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɗangɓe mbǝɗe Jesu man pan ɗebish mǝ pǝtuup fur mo, ɓe wur lap mmo nǝnee, <<A me le ɗangɓe wuu kam nghan yi? Wu jì kǝ mee shool zinariya nǝ nghan naa.>> ");
INSERT INTO sur_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓe mo jì kǝ memee nwur. Ɓe Jesu tal pǝ mo nǝnee, <<A mǝ riin mukáa, kǝ sǝm mu we, a rǝran nkaa shool nǝ yi?>> Mo lap nǝnee, <<A mǝ Siza mishkoom nRom.>> ");
INSERT INTO sur_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu sat mmo nǝnee, <<Wu shin nSiza mbii ɗe mo a mǝ Siza, kǝ wu shin Naan mbii ɗe mo a mǝ Naan zak.>> Nǝ aapwoo mmo zam mɓe mbii ɗewur sat nǝ. ");
INSERT INTO sur_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pak nen Saddusi mo, nen ɗe moo sat nǝ, baa mee yool a peemúut ɗe kas, mo jì pee Jesu ɗe, ɓe mo tal pǝ wur nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Ngukám, Mosis kǝ ran mmun nǝ, katɗang mee gurum muut seet yit mat wur ɗi, ɗe baa war làa-làa nwur kas, ɓe nnǝ mee ɗyemnǝǝn wur lap matkaa nǝ, mbǝkǝ wur làa-làa mo ɗe nɗyemnǝǝn fin ɗe wu kǝ ten muut nǝ. ");
INSERT INTO sur_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gyet mee ɗyemnǝǝnshak mo ɗe pwovǝl. Gwar ɗenshee nǝ wur lapmat, ɓe wur muut nɗin nlàa mee làa. ");
INSERT INTO sur_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɓe ɗyemnǝǝn fin ɗevǝl nǝ wur lap matkaa nǝ, ɓe baa wur làa mee làa kas, ɗang wur jì muut. Gwar ɗekun nǝ wur waa lap matkaa nǝ war zak. ");
INSERT INTO sur_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɗang mo pwovǝl, mo lapmat nǝ war, ɓǝ mo jì murǝp jir, ɓe baa memee yit mee làa ɗee ɗe kas. Kyes nǝ, ɓe mat nǝ war yool muut aɓwoon kǝ mo nǝ jir zak. ");
INSERT INTO sur_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, katɗang parpuus yool a peemúut, ɓe war kǝ nɗee a mat we nɗǝǝn mo pwovǝl sǝ ye? Mɓeɗi mo jir, mo kǝ lap war mmat.>> ");
INSERT INTO sur_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu sat mmo nǝnee, <<Wun wuu ɗel ɗikǝ, mbǝɗe baa wu man mbii ɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan kas, kǝ baa wu man ɗeɗes Naan kas zak. ");
INSERT INTO sur_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mɓeɗi parpuus ɗe nen nǝ mon nyool a peemúut, ɓe mon nɗee a kaa nenlep Naan ɗe aɗeng mo sǝ. Baa mee lapmat, koo dǝmɗyik ɗe kas. ");
INSERT INTO sur_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pwoo nkaa yool a peemúut mǝ nen ɗe mo kǝ ten murǝp mo, ɓe baa wuu kam tang pwoo ɗe mo kǝ ten ran nǝ nɗǝǝn ɓǝǝt haal Mosis kas aa? Mbii ɗe Naan sat nwur nɗǝǝn làa lǝǝt ɗe nǝ lapwus sí nǝ, <Wen a Naan kǝ Abraham, kǝ Naan Aizik, kǝ Naan kǝ Jekop.> ");
INSERT INTO sur_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Baa wur a Naan mu nenmuut mo kas, amma a mǝ nen ɗe mmeen mo. (Ɗesǝ nǝ kám nǝ koo ɗe mo kǝ ten murap ɓe mo ɗe kǝ seen pee Naan.) Wun wu ɗel ɗikǝ bish-bish hakyeng!>> ");
INSERT INTO sur_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mee gwar mɓut nenkám Wàar Mosis mo, wur jì kǝlǝng mo nkaa ɓeetshik nǝ, ɓe wur kǝlǝng Jesu tap lappwoo nǝ nen Saddusi mo rǝret. Ɓe wur tal pǝ Jesu nǝnee, <<A Wàar ɗeɗang a ɗeɗes met jir nɗǝǝn Wàar nǝ mo yi?>> ");
INSERT INTO sur_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu lap nwur nǝnee, <<A Wàar ɗeɗes met nǝ nɗesi, <Wun nen Isreil mo, wur kǝleng. Daa Naan fun, a wur a Daa mǝndong ɓejee. ");
INSERT INTO sur_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A wal nDaa Naan fwaa shi pǝtuup fwaa jir, shi seen fwaa jir, kǝ shi pan fwaa jir, kǝ shiɓal fwaa jir.> ");
INSERT INTO sur_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɗe vǝl nǝ a kaa mǝnǝ sǝ zak nǝnee, <A wal ngǝnang fwaa kaa sak fwaa sǝ.> Baa mee Wàar ɗe waa ɗes met ɗe vǝl sǝ mo kas.>> ");
INSERT INTO sur_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngukám Wàar Mosis nǝ wur sat nJesu nǝnee, <<Azeen Ngukám, a sat a rǝret. Daa Naan wur a mǝndong ɓejee ɗak, baa memee ɗe kas, see a wur mbǝshin. ");
INSERT INTO sur_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kǝ nǝ a tǝng kǝ gurum nwal nwur shi pǝtuup fin jir, kǝ shi pan fin jir, kǝ shiɓal fin jir, kǝ gurum nwal ngǝnǝǝn fin kaa shin fin sǝ zak. Wàar ɗe vǝl sǝ mo ret met nlong ɗe gurum moo shin mbe wus mbiizuum, kǝ koor mbiizuum ɗe gurum moo shin mon nNaan jir.>> ");
INSERT INTO sur_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kaaɗe Jesu kǝlǝng gwar nǝ tap lappwoo nǝ rǝret, ɓe wur sat ngwar nǝ nǝnee, <<Baa waa jong kǝ mulki Naan kas.>> Aɓwoon ɗesǝ ɓe baa mee gurum mak katɓal mputuup mɓe tal mee pwoo ɗe pǝ Jesu zak kas. ");
INSERT INTO sur_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kaaɗe Jesu nkaa kam-kam ngurum mo nɗǝǝn Lu Naan ɗǝɗes, ɓe wur tal pǝ mo nǝnee, <<A me le ɗangɓe nenkám Wàar Mosis moo sat nǝ, <Kristi wur a làa Devit ye?> ");
INSERT INTO sur_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mɓeɗi Riin Naan nǝ le kǝ Devit shikáa fin wu sat nǝnee, <Daa wu sat nDaa fen nǝ, A tong nsarse fen. Har parɗi wen le shaarlek fwaa mo tong nder shii fwaa.> ");
INSERT INTO sur_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit pet Kristi a Daa fin, ɓe cirang ɗang Kristi wu waa ciir ɗee a Làa Devit zak ye?>> Ɗuu gurum nǝ mo kǝlǝng wur shi retnyit. ");
INSERT INTO sur_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","nƊǝǝn kám Jesu, ɓe wur sat ngurum nǝ mo nǝnee, <<Wu tap kǝ kam nenkám Wàar Mosis mo. Mo a nen ɗe moo jwal nlǝr ɗeshwal-shwal mo, kǝ moo mwaan mbǝkǝ gurum mo naa mo ɗi. Moo rǝɓet kǝ gurum mo tok kǝ mo nɗǝǝn lutuk. ");
INSERT INTO sur_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kǝ moo rǝɓet peetong mǝ nennan-nan mo nɗǝǝn lu Naan mo, kǝ moo rǝɓet peetong ɗeret met jir mo a pee serǝɓet mo. ");
INSERT INTO sur_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","A moo yak matkaa mo kǝ lee fur mo, kǝ moo ɗangnaan (leshap kǝ Naan) ɗeshwal-shwal mo shi nyang zak, mbǝkǝ gurum mo kwoop mo ɗi. Mɓee mbii ɗebish ɗe moo cìn ɗesǝ mo, ɓe Naan wur ncin kwat ɗeshwal mo ɗes hakyeng.>> ");
INSERT INTO sur_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kaaɗe Jesu tong a kyeen, kus kǝ pee ɓwet shool mbiizuum mǝ Lu Naan ɗeɗes nǝ, ɓe wur naa kaaɗi gurum moo ɓwet shool mbiizuum fur mo ɗe nɗǝǝn nǝ. Pak nenlong mo ɗes mo ɓwet shool ɗes nɗǝǝn nǝ. ");
INSERT INTO sur_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɓe mee matkaa ɗe war a matjeel waa jì ɓwet rep anini mo vǝl ɗe nɗǝǝn nǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu pǝrep jeplep wur nǝ mo jì ashak, ɓe wur sat mmo nǝnee, <<Azeen kǝn sat nwun, mbii ɗe matkaa ɗejeel ɗesǝ waa ɓwet nɗǝǝn kwati mǝ ɓwet mbiizuum nǝ, nǝ met mǝ koor gurum nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mɓeɗi nen ɗesǝ mo jir, mo ɓwet mbiizuum nǝ a mɓut nɗes mǝ long ɗe mo kǝni, ɗangɓǝ war nɗǝǝn jeel war, ɓe war sǝhǝt ɓwet a kyes kǝ mbii ɗe war kǝ nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kaaɗe Jesu a ar put nɗǝǝn Lu Naan ɗeɗes nǝ, ɓe memee mɓut jeplep nwur mo sat nǝnee, <<Koi, Ngukám, a naa lu ɗeret ɗe mo tap ɗyik mo shi nghǝk ɗenan-nan sǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu lap nǝnee, <<Aa naa a lu ɗe mo ɗyik mo nan-nan shi nghǝk sǝ mo aa? Baa mon nyit mee nghǝk tong nkaa nghǝk mpee ɗesǝ kas, amma mon nshirip mo jir.>> ");
INSERT INTO sur_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kaaɗe Jesu tong nkaa Jwakpaat ɗe nii naa shak kǝ Lu Naan ɗǝɗes, ɓe Pita, kǝ Jemis, kǝ Joon, kǝ Andru, mo jì tal pǝ wur a sǝsok, mo sat nwur nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<A sat mmun, mbii ɗesǝ mon yool cìn a pǝrangyi? Kǝ mun nnaa a mbii aapwoo ɗeɗang, katɗang mbii ɗesǝ mo ɗoom gam yi?>> ");
INSERT INTO sur_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu ɗoom sat mmo nǝnee, <<Wu tap, taji mee gurum ngwam wun kas. ");
INSERT INTO sur_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mɓeɗi gurum mo ɗes mon njì nɗǝǝn sǝm fen, kǝ mo sat nǝ, wuɗun a wen, ɗangɓe mon ngwam gurum mo ɗes. ");
INSERT INTO sur_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Katɗang ɓe wu kǝlǝng pwoo nkaa lek mo, kǝ pwoo kyetwa nkaa lek mo, ɓe taji kǝǝrmuut yaa wun kas, mbǝɗe nǝ atǝng mbii ɗesǝ mon nyool cìn akuɗang, ɓe parkyes yil nii kuɗi kǝ jì. ");
INSERT INTO sur_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pak yil mon nyool lek nkaa pak yil mo, kǝ mee mulki mon nyool lek nkaa mee mulki ɗecì mo. Yil nǝn ntungpee ɗes-ɗes shipee-shipee, neen nǝn ntaa, nɗǝǝn yil nǝ mo. Ɗangɓe mbii ɗesǝ mo jir a shee kǝ jeel, kaaɗi aak kǝ shee se mat sǝ. ");
INSERT INTO sur_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Ɗangɓe wu tap kǝ káa fuu, mbǝɗe gurum mon nyool sǝrep wun nsar kǝ nentokɗyeel mo, kǝ mon nnǝram wun nɗǝǝn lu Naan mo. Mon ndǝm kǝ wun ntoom gofna, kǝ mishkoom mo, mbe sǝm fen. Ɗesǝ nǝn nle kǝ wun katpee satpwoo ɗeret nǝ ɗe ntoom mo. ");
INSERT INTO sur_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɗangɓe akuɗang kyes kǝ yil nii jì, ɓe tǝng see mo shee satpwoo Naan ɗeret sǝ ngurum mo jir nɗǝǝn yil nǝ akuɗang. ");
INSERT INTO sur_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Katɗang ɓe mo yak wun, kǝ mo dǝm kǝ wun nluɗyeel ɓe taji wu an suk mbe mbii ɗe wun nsat kas. Mɓeɗi a Riin Naan wur nkám wun mbii ɗe wun nsat mo. Mɓeɗi baa a wun nkaa satpwoo nǝ kas, amma a Riin Naan wur nkaa satpwoo nǝ. ");
INSERT INTO sur_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ɗyemnǝǝnshak mon nsǝrep shak har mpee muut, ɓǝ puun wur nseet làa fin zak. Jep mon nyool lek kǝ puun fur mo, kǝ nǝǝn wu mo, ɓe mon nle kǝ mo twe mo. ");
INSERT INTO sur_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gurum mon ncii wun jir, mɓe sǝm fen. Ɗangɓe gwar ɗe wu gung har peekyes nǝ, ɓe a wur nkat ɓam.>> ");
INSERT INTO sur_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Ɗangɓe katɗang wu naa mbii ɗebish, ɗe nii watpee ɗee buu, nii ɗar a peeɗi baa nǝ ret kǝ nǝ ɗar ɗe kas. (Ngwar ɗewur tang pwoo ɗesǝ ni, ɓe nǝ ret kǝ wu manshii nǝ). Ɓe nenyil ɗe mo nɗǝǝn Judiya, mo swe dǝm mɓut jwak mo. ");
INSERT INTO sur_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngwar ɗewur nkaa ɗeng lu, ɓe taji wu sham ɗel nɗǝǝn lu nǝ, mɓe mang lée fin mo kas. ");
INSERT INTO sur_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kǝ gwar ɗewur a peemaar a yil, ɓe taji wu waa baa ntul mbǝ mang mbiisǝp fin kas. ");
INSERT INTO sur_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amma jeel nǝn nsǝǝt naat nkaa mat aak mo, kǝ mat ɗe mon nkaa shin wur njep mo nɗǝǝn teer mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wu cìn ɗangnaan (leshap kǝ Naan) nNaan, mbǝkǝ taji mbii ɗesǝ mo cìn a ntarkut kas. ");
INSERT INTO sur_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mɓeɗi jeel ɗeɗes nǝn njì taa nkaa gurum mo nɗǝǝn teer mǝnǝ mo, ɗe baa mo kǝ cam naa nǝ kas, pǝgyet Naan shee leyil nǝ ɗe, har cicinsi, kǝ baa gurum mon mbaa naajeel mǝnǝ ɗe zak kas har ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Katɗang ɗe baa Daa Naan wur baa kǝ pak teer nǝ mo kas, ɓe baa ɗe mee gurum mmak kat bar kas, amma a mɓe sǝm kǝ nen ɗebǝbǝlǝp nǝ mo, ɓe Naan wur baa kǝ pak teer nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","<<Katɗang mee gurum sat nwun nǝnee, <Wu naa, Kristi wu mpesi.> Koo ɗang nnǝ, <wu naa, wur akyeen sí!> Ɓe taji wu shinzeen mpwoo mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mɓeɗi nen ɗe mon ncìn ɗung, nnǝ wuɗun a Kristi, kǝ nen ɗe mo lesut a kaa nensatpwoo Naan mo sǝ, ɗangɓǝ mo a nenɗung mo, mon njì put ɗes. Mon ncìn mbii aapwoo mo ɗes, kǝ mbii lukshik mo zak. Mbeekǝ katɗang nǝ mak cìn, ɓe mo ngwam nen ɗe Naan wu kǝ ten bǝlǝp mo. ");
INSERT INTO sur_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amma wu tap kǝ káa fuu mo. Wen kǝn satpwoo ɗesǝ mo nwun nshee akuɗang pee nii wul.>> ");
INSERT INTO sur_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Aɓwoon kǝ jeel mǝnǝ mo, ɓe puus nǝn ncǝǝr ɗee a peenkoo, kǝ baa tar nǝn mɓangpee kas, nɗǝǝn teer mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kǝ zar ɗe aɗeng mon mɓeer sham nyil, kǝ iiko ɗe mo aɗeng mon ntungpee zak. ");
INSERT INTO sur_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɗangɓe gurum mon naa Làa Gurum, wur sham put nɗǝǝn nluu ɗe aɗeng, shi iiko kǝ Ɗehai, kǝ ɓal ɗǝɗes. ");
INSERT INTO sur_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɓe wur nlep nenlep Naan mo, mbǝkǝ mo dǝm kok nen ɗewur kǝ ten bǝlǝp mo kuur ashak, nɗǝǝn kwang ɗe feer mǝ yil nǝ. Yaa mpeeɗar kǝ yil nǝ jir, ɓe dǝm wul mpeeɗar kǝ ɗeng nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Wu yit kǝ tǝngkyeen nǝ ɗee a mbiikám pee wun ɗi. Katɗang song tǝngkyeen nǝ mo ɗoom put kǝ kompee ɗepoo, ɓe wu man nǝ, tarlok nǝ kus mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aasǝ zak, katɗang wu naa mbii ɗesǝ mo cìn jir, ɓe wu man nǝ, wen kǝn jì wul kus-kus mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Azeen nzeen kǝn sat nwun nǝ, Baa gurum ɗe yaksǝ mon mmurep jir kas, nǝ atǝng mbii ɗesǝ mo gam jir akuɗang. ");
INSERT INTO sur_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ɗeng kǝ yil mon nɗel dǝm weet, ɗangɓǝ baa pwoo fen mmak cam ɗel dǝm kas.>> ");
INSERT INTO sur_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Baa mee gurum mak man puus mǝnǝ, kǝ pee nǝ kas, koo a nenlep Naan ɗe aɗeng mo, kǝ koo a Làa nǝ shikáa fin, ɓe baa wur man kas, amma see a puun ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wu tap kǝ káa fuu mo, kǝ wu tong shi gongpee, mbǝɗe baa wu man parɗi pee nǝn nwul ɗe kas. ");
INSERT INTO sur_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Katɗang pee nǝ wul, ɓe nǝn nɗee a kaa mee gurum ɗe wu yool mɓe dǝm mwaan jong-jong sǝ. Akuɗang wur yool yit tul nǝ, ɓe wu le nǝ nsar kǝ kǝrem fin mo, wu shwap ɗak nkǝrem fin nǝ mo jir, shimǝndong-shimǝndong. Wur sat ngutap kǝ shiyeepkǝpang mǝ tul nǝ nǝnee, <A tong shi gongpee rǝret.> ");
INSERT INTO sur_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mbǝmǝnǝ, wu tong shi gongpee, mbǝɗe baa wu man parpuus ɗe ngulu nǝ wu mbaajì wul ɗe kas. Meeɓe wu mbaajì nkansǝǝn, koo a nnaar mpar, koo a nciit kǝ pǝɓit, koo a mɓít. ");
INSERT INTO sur_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mbǝkǝ taji wur mbaajì nwun ndi mman, ɗangɓe wur kat wu ɗee nsaam kas. ");
INSERT INTO sur_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mbii ɗe wen sat nwun, ɓe an kǝn sat a ngurum mo jir mmǝnǝ nǝ, wu tong shi gongpee.>> ");
INSERT INTO sur_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɗee teer mo ɗe vǝl, kǝ mo cìn retnyit mǝ Canɗel ɗi, kǝ mu retnyit mǝ gǝǝl aas ɗe baa nǝ kǝ yist kas. Ɓe pris ɗenan mo, kǝ nenkám Wàar Mosis mo, mo tang ar ɗe mon nyaa Jesu ɗe shi seen, mbǝkǝ mo tu wur ɗi. ");
INSERT INTO sur_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɗangɓe mo waa sat nǝnee, <<Baa mun nyaa wur a nɗǝǝn teer mǝ retnyit sǝ kas, mbǝkǝ taji gurum nǝ mo yool lek nkaa mun.>> ");
INSERT INTO sur_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kaaɗe Jesu nyil mBetani, nɗǝǝn lu kǝ Siman nguloom, ɓe wur nkaa se mbiise. Ɓe mee mat war jì kǝ tuut mwoor ɗe nǝ kǝ toos shangshang ɗe moo pet nǝ a nard, ɗe nǝ kǝrim zam. Ɓe war tep took kǝ tuut nǝ, mbǝkǝ war ɗoo mwoor nǝn nJesu nkáa. ");
INSERT INTO sur_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Amma nǝ láa mpak gurum ɗe mo ɗe mɓut, har mo satpwoo kǝ shak nǝnee, <<A me le ɗangɓe moo tǝkook kǝ mwoor ɗesǝ aasǝ yi? ");
INSERT INTO sur_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ɗe nǝ ret kǝ mo seet kǝ mwoor ɗesǝ nǝ nkaa shool zinariya ɗe nǝ met kambil kun, mbǝkǝ mo shin shool nǝ ɗe nenjeel mo.>> Pak gurum nǝ mo gwak mat nǝ war, shi tuup. ");
INSERT INTO sur_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amma Jesu sat mmo nǝnee, <<Wu yit war ɗi. A me le ɗang wuu daampee nwar yi? War cìn a ɗak ɗeret nghan hakyeng. ");
INSERT INTO sur_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wun ɗi ashak kǝ nenjeel mo shidaar-shidaar, mpeemǝnǝ ɓe koo a par ɗeɗangyi ɗe wuu rǝɓet, ɓe wun mmak cìn ɗeret mmo. Amma baa wun nkat nghan ashak kǝ wun shidaar-shidaar kas. ");
INSERT INTO sur_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","War kǝ cìn mbii ɗe waa mak cìn nǝ. Mwoor ɗe waa kǝ ɗoo nkaa fwoshik fen sǝ, war cìn mǝnǝ a mɓe ɗak san fen mɓe wum. ");
INSERT INTO sur_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Azeen kǝn sat nwun nǝ, koo a pee ɗeɗangyi nɗǝǝn yil ɗesǝ jir, ɗe mon nsatpwoo ɗeret ɗesǝ ni, ɓe mbii ɗe mat ɗesǝ war cìn nghan, ɓe mon nkǝǝ sat nǝ mɓe pan war.>> ");
INSERT INTO sur_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariyot, ɗewur a memee nɗǝǝn jeplep Jesu ɗe kaapaat baavǝl sǝ mo, Wur dǝm pee pris ɗenan-nan mo ɗi, mbǝkǝ wur seet kǝ Jesu ɗe nɗǝǝn sar mo. ");
INSERT INTO sur_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kaaɗe mo kǝlǝng pwoo mǝnǝ, ɓe nǝ ret mon nyit zam, har mo tuweerpwoo nǝ, mon nshin shool nwur. Yaa mparmǝni, ɓe Judas Iskariyot naa nyap ar ɗewur nseet kǝ Jesu ɗi mo. ");
INSERT INTO sur_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Parpuus ɗenshee ɗe mǝ gǝǝl aas ɗe baa nǝ kǝ yist kas, ɗe nǝ a puus ɗe moo fet tǝm mo, mbǝ mbiise mǝ retnyit mǝ Canɗel nǝ. Ɓe jeplep kǝ Jesu mo tal pǝ wur nǝnee, <<Aa rǝɓet kǝ mu dǝm mu ɗak peese mbiise mǝ Canɗel nǝ nghan a nneyi?>> ");
INSERT INTO sur_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesu lep memee mo vǝl nɗǝǝn jeplep fin mo, wu sat mmo nǝnee, <<Wu ɗel nɗǝǝn yilkaam ni, ɓe wun nkat kǝ mee gurum ɗewur kǝ tuul am nkáa, ɓe wu dǝm nɗang wur, ");
INSERT INTO sur_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","har nɗǝǝn lu ɗewur ndǝm ɗel ɗe. Ɓe wu tal pǝ ngulu nǝ nǝnee, <Ngukám wur sat nnǝ, lumǝzep ɗe wen nse mbiise Tong Ashak mu Canɗel ashak kǝ jeplep fen mo, nǝ a nneyi?> ");
INSERT INTO sur_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ngulu nǝ wur nkám mee luɗeng ɗeɗes nwun, ɗe mo kǝ ɗakle. Ɓe wu ɗak mbiise nǝ mmun, nlu mǝni.>> ");
INSERT INTO sur_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jeplep ɗe vǝl nǝ mo yool dǝm ɗel nɗǝǝn yilkaamnǝ, ɓe mo kat nǝ a kaaɗi Jesu wu sat mmo sǝ, ɓe mo ɗak mbiise Tong Ashak mǝ Canɗel nǝ nlu ni. ");
INSERT INTO sur_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kaaɗe kansǝǝn cìn, ɓe Jesu jì ashak kǝ jeplep ɗe kaapaat baavǝl nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mon nkaa se mbiise nǝ, ɓe Jesu sat mmo nǝnee, <<Azeen-nzeen, kǝn sat nwun, memee nɗǝǝn wun wu nseet kǝ an. A gwar ɗe mun nkaa sese ashak kǝ wur yaksǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pwoo ɗe Jesu sat, nǝ wàt pǝtuup mmo zam, ɓe mo ɗoom tal pǝ wur shimǝndong-shimǝndong nǝnee, <<Daa a an aa?>> ");
INSERT INTO sur_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wur sat mmo nǝnee, <<A memee nɗǝǝn wun ɗe kaapaat baavǝl sǝ mo. A gwar ɗewur sham kǝ gǝǝl aas nsar mbǝ lep mpuk nɗaa kǝ an. ");
INSERT INTO sur_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɓeɗi Làa Gurum, wur mmuut a kaaɗi mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan nkaa wur sǝ. Amma jeel nǝn ntaa nkaa gwar ɗewur seet kǝ Làa Gurum. Ngyal ɗesi ɓe, Di mon nnook làa gwar mǝni, ɓe ɗi nǝ ret met nwur.>> ");
INSERT INTO sur_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaaɗe mo nkaa sese nǝ, ɓe Jesu mang gǝǝl aas, ɓe wur cìn ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan nkaa nǝ, ɓe wur yilang nǝ, ɓe wur shin njeplep fin mo. Wur sat mmo nǝnee, <<Wu lap, ɗesǝ nǝ a fwoshik fen.>> ");
INSERT INTO sur_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wur mang mee laaɗaa zak, ɓe wu cìn ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan nkaa nǝ, ɓe wur shin mmo. Ɓe mo jir mo shwaa nɗǝǝn nǝ. ");
INSERT INTO sur_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ɓe wur sat mmo nǝnee, <<Ɗesǝ nǝ a toom fen ɗe nǝ ɗee a gam mǝ tuweerpwoo ɗepoo shi toom mǝ Naan, ɗe nǝ yaa ɗak mɓe toom fen ɗe mon mɓeer nǝ mɓe gurum mo ɗes. ");
INSERT INTO sur_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Azeen-nzeen, kǝn sat nwun nǝ, baa an mbaa shwaa am anab ɗi kas, see parɗi an nshwaa am anab ɗepoo nǝ nɗǝǝn mulki Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kaaɗe mo cìn kook, ɓe mo pwat dǝm a Jwakpaat. ");
INSERT INTO sur_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu sat mmo nǝnee, <<Wun jir wun nshwe wu yit nghan ɗi, mbǝɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan nǝnee, <Wen ntu ngukiyeer tǝm nǝ mo, ɓe tǝm nǝ mon ntiit shini-shini.> ");
INSERT INTO sur_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma aɓwoon ɗe Naan wur baa yool kǝ an a peemúut, ɓe an ndǝm nwun akyeen nyil nGalili.>> ");
INSERT INTO sur_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita sat nJesu nǝnee, <<Koo ɗe mo jir, mo shwe yit gha ɗe, ɓe baa wen cam yit waa kas.>> ");
INSERT INTO sur_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu sat mPita nǝnee, <<Azeen-nzeen kǝn sat gha nǝ, mpar cicinsi, akuɗang deel taaɗoo yit vǝl, ɓe waa nciipwoo yit kun nǝ, baa waa man an kas.>> ");
INSERT INTO sur_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma Pita lappwoo nJesu shiɓal hakyeng nǝnee, <<Koo ɗangɗe nǝ atǝng kǝ wen muut ashak kǝ gha, ɓe baa wen cam cíipwoo kas.>> Ɓe koor jeplep Jesu nǝ mo sat aasǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mo jì wul mee peeɗi moo pet nǝ a Getsamani, ɓe Jesu sat njeplep fin mo nǝnee, <<Wu tong mpeesǝ, aku nghan cìn ɗangnaan (leshap kǝ Naan) ɗi.>> ");
INSERT INTO sur_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɓe Jesu dǝm ashak kǝ Pita, kǝ Jemis, kǝ Joon. Pǝtuup fin nǝ wat, nǝ daampee nwur zam hakyeng. ");
INSERT INTO sur_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wur sat mmo nǝnee, <<Pǝtuup fen nǝ wat zam, har kaa nǝn ntǝtu nghan sǝ. Wu tong mpeesǝ, kǝ wur gongpee ɗe.>> ");
INSERT INTO sur_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wur gyes dǝm ɗe akyeen lee, ɓe wur dǝm kurum nyil, wur cìn ɗangnaan (leshap kǝ Naan) nǝnee, <<Puun fen, katɗang ɗe nǝ mak cìn, ɓe taji wen shwaajeel ɗesǝ nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kǝ wur sat nǝnee, <<Daa, puun fen, waa mak cìn mbii mo jir, ɓe a baa kǝ kap mǝ jeel ɗesǝ aku pee nghan ɗe. Baa a kaaɗi wen kǝn rǝɓet sǝ kas, amma see a kaaɗi waa aa rǝɓet sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wur waa dǝm pee jeplep fin ɗekun nǝ mo ɗe, ɓe wur kat mo nkaa saam. Ɓe wur sat mPita nǝnee, <<Simon waa a nkaa saam wo? Tan, baa a mak gongpee mɓe awa mǝndong kas aa? ");
INSERT INTO sur_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wu tong shi gongpee, kǝ wu cìn ɗangnaan (leshap kǝ Naan), mbǝkǝ taji wu ɗel mɓut jwaan kas. Riin nǝ rǝɓet ɗak, amma nan nǝ cii, mbǝɗe baa nǝ ɓal kas.>> ");
INSERT INTO sur_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesu waa dǝm ɗe, a pee ɗangnaan (leshap kǝ Naan) nǝ, ɓe wur waa baa cìn ɗangnaan (leshap kǝ Naan) a kaaɗi wur cìn nshee sǝ zak. ");
INSERT INTO sur_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wur waa baaji kat jeplep ɗekun nǝ mo ɗe nsaam zak, mbǝɗe yit fur mo toon kǝ nsaam. Baa mo man mbii ɗe mon nlap nwur kas. ");
INSERT INTO sur_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kaaɗe wur waa waaji pee jeplep nǝ mo ɗe yit ɗekun, ɓe wur sat mmo nǝ, <<Har yaksǝ, ɓe wun ɗe nkaa saam kǝ nookɗi aa? Nǝ mak kǝsǝ, pee nǝ kǝ wul. Mo kǝ seet kǝ Làa Gurum nsar nenshikbish mo. ");
INSERT INTO sur_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wu yool mmun seet. Wu naa gwar ɗewur seet kǝ an wur kǝ jì wul.>> ");
INSERT INTO sur_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kaaɗe Jesu kuɗi nkaa leshap mǝni, ɓe Judas Iskariyot, ɗewur a memee nɗǝǝn jeplep Jesu ɗe kaapaat baavǝl sǝ mo, wur jì wul ashak kǝ ɗuu gurum mo ɗes nɗang wur. Gurum nǝ mo kǝ kwai mo, kǝ kam mo. A pris ɗenan-nan mo, kǝ nenkám Wàar Mosis mo, kǝ nennan-nan mo, a mo lep gurum nǝ mo. ");
INSERT INTO sur_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gwar ɗewur seet kǝ Jesu nǝ, wur kǝ ten cìn mee ɓe naa man (alaama) mmo nǝnee, <<Ngwar ɗe wen tok kǝ wur, ɗang wen tung wur shi mǝshpwoo, ɓe a gwar nǝ mmǝnǝ. Ɓe wu yaa wur rǝret, wu dǝm kǝ wur.>> ");
INSERT INTO sur_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaaɗe Judas jì, ɓe wur dǝm pee Jesu ɗe abet, kǝ wur sat nǝnee, <<Ngukám.>> Ɓe wur tok kǝ Jesu, ɗangɓe wur tung Jesu shi mǝshpwoo zak. ");
INSERT INTO sur_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɗangɓe mo jì yaa Jesu. ");
INSERT INTO sur_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amma memee nɗǝǝn nen ɗe moo ɗar ɗe mpee nǝ, wur shang kwai fin, ɓe wur can kom kǝ kǝrem mǝ pris ɗeɗes met jir nǝ vwet nyil. ");
INSERT INTO sur_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu sat nɗuu kǝ gurum nǝ mo nǝ, <<Wun, wu pwat wur jì kǝ kwai mo, kǝ duul mo, mbǝkǝ wu yaa wen ɗe, kaa wen a mee kus wat sǝ aa? ");
INSERT INTO sur_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Shidaar-shidaar ɓe an ɗe ashak kǝ wun, kǝ an kǝn kám nwun nɗǝǝn Lu Naan ɗǝɗes, ɓe baa wu yaa an kas. Amma mbii ɗesǝ mo cìn aasǝ jir, a mbǝkǝ pwoo ɗe mo kǝ ten ran mo nɗǝǝn ɓǝǝt haal Naan mo gam ɗe.>> ");
INSERT INTO sur_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jeplep wur mo jir, mo yool shwe yit wur ɗe. ");
INSERT INTO sur_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mee ɗyem zǝlang wur ɗi, ɗewur sup a mee fuwaat nkaa shin ɓejee, wur dǝm nɗang Jesu, kaaɗi mo yaa wur, ");
INSERT INTO sur_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɓe wur su dǝm ngum, wur yit fuwaat nǝ mmo. ");
INSERT INTO sur_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mo dǝm kǝ Jesu ntul kǝ pris ɗeɗes met jir nǝ, a peeɗi pris ɗenan-nan mo, kǝ nennan-nan mo, kǝ nenkám Wàar Mosis moo kuur ɗe ashak. ");
INSERT INTO sur_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita tap dǝm nɗang Jesu aɓwoon jong-jong, har ntul kǝ pris ɗeɗes met jir nǝ, ɓe wur ɗel tong ashak kǝ nentappee mo, kǝ wur kǝ kǝlǝng wong wus ɗe. ");
INSERT INTO sur_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pris ɗenan-nan nǝ mo, kǝ kuur nennan-nan nǝ mo jir, mo tang mbii ɗe mon cìn langtǝng mǝ ɗung mo nkaa wur, mbǝkǝ mo katpee tu Jesu ɗe, amma baa mo kat kas. ");
INSERT INTO sur_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Koo ɗi gurum mo ɗes mo jì kǝ langtǝng mǝ ɗung mo nkaa Jesu, ɓe baa mbii ɗe mo sat nkaa Jesu nǝ mo yakshak kas. ");
INSERT INTO sur_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pak gurum mo yool ɗar atǝng, kǝ mo sat mbii ɗe mǝ ɗung nkaa Jesu nǝnee, ");
INSERT INTO sur_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Mu kǝlǝng wur sat nǝnee, <wuɗin nshirip Lu Naan ɗeɗes sǝ, ɗe gurum mo ɗyik nǝ shi sar, ɗangɓe wuɗin mbaa ɗyik memee ɗe nɗǝǝn teer mo kun zak, ɗe baa a shi sar kas.> >> ");
INSERT INTO sur_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jir kǝsǝ, ɓe baa mbii ɗe mo sat nǝ mo yakshak kas. ");
INSERT INTO sur_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɗangɓe pris ɗeɗes met jir nǝ wur yool ɗar atǝng nnaar fur. Ɓe wur tal pǝ Jesu nǝnee, <<Baa waa kǝ mee mbii ɗe waa nlap nkaa pwoo ɗesǝ mo kas aa? A sat a me nkaa mbii ɗe des ɗesǝ mo sat nkaa gha yi?>> ");
INSERT INTO sur_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amma Jesu ɗok kǝtǝk, baa wur lap mee pwoo kas. Ɓe pris ɗeɗes met jir nǝ wur waa baa tal ɗe pǝ Jesu zak nǝnee, <<A gha a Kristi Làa Naan Ɗehai aa?>> ");
INSERT INTO sur_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu lap nǝnee, <<A nghan a wu, wun nnaa Làa Gurum, wur tong nsarse Naan ɗeɓal met jir, ɓǝ wun nnaa wur jì nɗǝǝn nluu ɗe aɗeng mo zak.>> ");
INSERT INTO sur_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kaaɗe pris ɗeɗes met jir, wur kǝlǝng pwoo mǝni, ɓe wur yilang nlǝr fin mo, ɓǝ wur sat nǝnee, <<Muu tang a langtǝng ɗeɗang ɗikǝ zak yi? ");
INSERT INTO sur_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yaksǝ, wu kǝlǝng pwoo ɗe Jesu wur sat, ɗewur leshin a kaa Naan sǝ. Wur naa arang nkaa pwoo mǝnǝ yi?>> Ɓe mo jir, mo canɗyeel muut nJesu. ");
INSERT INTO sur_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pak mo yaa twes lii nkaa wur, mo paa yit wur mo, ɗang mo nǝrem wur, ɓǝ mo sat nwur nǝnee, <<A woo gwar ɗe cut gha nǝ mmun.>> Ɓe nentappee mo nǝrem wur hakyeng. ");
INSERT INTO sur_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kaaɗe Pita ɗar a fur nder luɗyeel nǝ, ɓe mee reep ɗe war a kǝrem pris ɗeɗes nǝ war jì. ");
INSERT INTO sur_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ɓe kaaɗi war naa Pita ke tong a wus, ɓe war tǝǝr yit nzing nkaa Pita, ɓǝ war sat nǝnee, <<Gha ashak kǝ Jesu ngwe Nazaret zak!>> ");
INSERT INTO sur_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ɗangɓe Pita cíipwoo nǝnee, <<Baa wen man mbii ɗe yii sat nǝ kas, baa wen man pwoo mǝnǝ kas.>> Ɓe wur yaa ar ɗel put nshiyeeppǝbong. ");
INSERT INTO sur_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɓe reep ɗe war a kǝrem mu pris ɗeɗes met jir nǝ war baa naa wur ɗe, ɓe war sat nen ɗe moo ɗar mpwoo shiyeeppǝbong nǝ mo nǝnee, <<Gwar ɗǝsi wur a memee mɓut nen Jesu nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amma Pita baa cíipwoo ɗe zak. Lang ɗi lee, ɓe nen ɗe moo ɗar ɗi pee nǝ, mo sat mPita nǝnee, <<Azeen-nzeen, gha a mee mɓut nen Jesu nǝ mo, mbǝɗe gha a ngu Galili.>> ");
INSERT INTO sur_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Amma Pita cíipwoo, wur ɗalwus, wur sat nǝnee, <<Naan shin kar nghan katɗang wen man gwar ɗe wuu satpwoo nkaa wur nǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Abet-abet, ɓe deel tokshik ɗe vǝl. Ɓe Pita yeepwoo ɗe Jesu sat nwur sí nǝnee, <<Akuɗang deel tokshik yit vǝl, ɓe ghan cíipwoo fen yit kun nnǝ, baa a man wen kas.>> Kaaɗe Pita yeepwo mǝni, ɓe nǝ tep kwak nwur, ɓǝ wur yaa gwar maap. ");
INSERT INTO sur_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kaaɗe ɓit mang, ɓe pris ɗenan-nan mo, ashak kǝ nennan-nan mo, kǝ nenkám Wàar Mosis mo, kǝ nenɓeetpwoo nǝ mo jir, mo kuur ashak, ɓe mo lepwoo, ɓe mo ɓwot sar kǝ Jesu, mo dǝm shin wur mPailet. ");
INSERT INTO sur_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailet tal pǝ Jesu nǝnee, <<A gha a mishkom nen Yahudi mo aa? Jesu lap nǝnee, <<aa ten a sat.>> ");
INSERT INTO sur_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pris ɗenan-nan nǝ mo jì kǝ langtǝng mǝ ɗung mo ɗes nkaa Jesu. ");
INSERT INTO sur_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailet, wur waa baa tal pǝ Jesu nǝnee, <<Baa gha kǝ mee pwoo ɗe ghan nlap kas aa? A naa pwoo mo ɗes ɗe mo jì kǝ mo nkaa gha>> ");
INSERT INTO sur_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma baa Jesu lap mee pwoo nwur koo mǝndong kas, har nǝ fes aapwoo mPailet zam. ");
INSERT INTO sur_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gyet ɓe koo a parpuus mǝ retnyit mǝ Canɗel ɗeɗangyii, ɓe Pailet wur kǝ loot ɓwet mee gurum ɗe ɓuɓwoot mǝndong mmo, ɗe gurum nǝ moo rǝɓet. ");
INSERT INTO sur_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mee gwar ɗe moo pet sǝm nwur a Barabbas, wur ɗe a ɓuɓwoot nlushoot ashak kǝ nenbwetɓeer mo, ɗe mo kǝ tukáa nɗǝǝn ɓwetɓeer fur nǝ. ");
INSERT INTO sur_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɗuu gurum nǝ mo jì kus, ɓe mo yaa ɗang nǝ pǝ Pailet, kǝ wur ɓwet mee gurum ɗe mmo, kaaɗi wur loot kǝ cìn nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailet tal pǝ mo nǝnee, <<Wuu rǝɓet kǝ nghan ɓwet a mishkoom mǝ nen Yahudi mo nwun aa?>> ");
INSERT INTO sur_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailet man nǝ, pris ɗenan nǝ mo jì kǝ Jesu ntoom fin a mbǝ zuur. ");
INSERT INTO sur_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɗangɓe pris ɗenan mo kar ɗuu gurum nǝ mo, mbǝkǝ mo ɗang pǝ Pailet kǝ wu ɓwet Barabbas ɗe mmo. ");
INSERT INTO sur_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailet waa baa sat mmo nǝnee, <<Wuu rǝɓet kǝ nghan cìn a me kǝ gwar ɗe wuu pet wu a mishkoom nen Yahudi mo yi?>> ");
INSERT INTO sur_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɗangɓe mo waa sǝǝt le or shiɓal nǝnee, <<A le kǝ mo pwas wur nkaa shiyeep.>> ");
INSERT INTO sur_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailet sat mmo nǝnee, <<A mɓe meye? Wur cin a mbii ɗebish ɗeɗang yi?>> Be mo waa sǝǝt le or shi ɗoo ɗeɗes hakyeng, <<A le kǝ mo pwas wur nkaa shiyeep! A le kǝ mo pwas wur nkaa shiyeep!>> ");
INSERT INTO sur_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mɓeɗi Pailet rǝɓet kǝ nǝ ret ɗe nɗuu kǝ gurum nǝ mon nyit, ɓe wu ɓwet Barabbas mmo. Amma aɓwoon ɗewur fwo nbwat Jesu, ɓe wur shin Jesu mmo, mbǝkǝ mo dǝm pwas wur ɗe nkaa shiyeep. ");
INSERT INTO sur_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɗangɓe shiitoon mo ɗel kǝ Jesu nɗǝǝn lu mǝ gofna nǝ, ɗe moo pet nǝ a Praitoriyum, ɓe mo pǝrep shiitoon ɗe mpee mǝnǝ mo jir, mo jì kuur ashak pee Jesu ɗi. ");
INSERT INTO sur_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mo lep mee nlǝr ɗe nǝ naat pan a tup nJesu, kǝ mo ráa mee mbiikáa ghǝr, mo lep nwur nkáa. ");
INSERT INTO sur_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɗangɓe mo tok kǝ nwur nǝnee, <<Muu tok kǝ gha da mishkoom nen Yahudi mo.>> ");
INSERT INTO sur_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓe mo cut wur nkáa shi raas, ɓǝ mo tus lii nkaa wur. Ɓe mo kurum nfurum, kǝ mo seyil nwur. ");
INSERT INTO sur_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aɓwoon ɗe mo kǝ shwar, kǝ ɓák wur, ɓe mo shang nlǝr ɗenaat pan a tup nǝ nkaa wur, ɗangɓe mo lep nlǝr nwur mo nwur. Ɓe mo put dǝm kǝ wur atǝleng, mbǝkǝ mo pwas wur ɗe. ");
INSERT INTO sur_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaaɗe mo a ar dǝm nǝ, ɓe mo taa kaat kǝ mee gwar, ɗe moo pet sim nwur a Simon, wu a ngu Sairin, puun Alekzanda kǝ Rufus, wur tong mmee laayil jì ɗe, ɓe shiitoon nǝ mo le wur mang shiyeepmúut Jesu nǝ ating. ");
INSERT INTO sur_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mo jì wul kǝ Jesu mmee peeɗi moo pet nǝ a Golgofa (shii kǝ Golgofa nǝ a ɗyeskáa.) ");
INSERT INTO sur_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mo shin am anab ɗe mo kǝ riyeep nǝ kǝ mee yen ɗe moo pet naa myrrh nwur, amma wur cii shwaa nǝ. ");
INSERT INTO sur_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kaaɗe mo pwas Jesu nkaa shiyeep, ɓe mo koospaa mɓe ɓàk nlǝr wur. Ɓe Mo ɓàk nlǝr nwur mo nnaar mu. Ɓe mo bǝlǝp mbǝkǝ mo naa be ɗe koo a gwar ɗeɗangyi nwur nkat ɗi. ");
INSERT INTO sur_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mo pwas Jesu nkaa shiyeepyoom nǝ a kaa karfe pwoofeer ɗe mǝ bit sǝ. ");
INSERT INTO sur_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mo ran pwoo nkaa mbii ɗe nǝ le ɗang mo tu Jesu, mo lang nkaa shiyeepyoom nǝ nɗeel nkáa nJesu, ɗǝ nǝ sat nǝnee, << A MISHKOOM MƏ NEN YAHUDI MO NƊESƏ. ");
INSERT INTO sur_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mo pwas mee kus wat mo vǝl ashak kǝ Jesu zak. Mo pwas memee nkwang sarse nwur, ɓǝ memee nkwang sarkul nwur zak. ");
INSERT INTO sur_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mo cìn mbii ɗesǝ mo jir a mbǝkǝ pwoo ɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan nǝ gam ɗe nǝnee, <<Mon tang wur mɓut nenɗebish mo. ");
INSERT INTO sur_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nen ɗe mo ɗel ar peeɗi mo pwas Jesu ɗe, mo zǝkkáa fur mo, kǝ mo nwangpwoo nwur nǝnee, <<Kaigwa! Waa ɗe di a sat nǝ, waa nshirip Lu Naan ɗǝɗes, ɗangɓe nghan mbaa ɗyik nǝ ɗe nɗǝǝn teer mo kun zak. ");
INSERT INTO sur_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","A ɓam sak kǝse! A sham nkaa shiyeep nǝ shiko.>> ");
INSERT INTO sur_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pris ɗenan-nan mo, kǝ nenkám Wàar Mosis mo, mo shwar, ɓǝ mo toklong nJesu zak, mo sat nǝnee, <<Waa ɓam nen ɗeci mo, ɗangɓǝ baa waa mak ɓam sak kas. ");
INSERT INTO sur_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Katɗang gha a Kristi azeen-nzeen, mishkoom nen Isreil mo. Ɓe a sham nyil nkaa shiyeepmúut nǝ yaksǝ, mbǝkǝ mu naa, kǝ mun shinzeen ɗe.>> Wat ɗe mo pwas mo ashak kǝ Jesu, mo satpwoo ɗebuu nwur zak. ");
INSERT INTO sur_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaaɗe karfe kaapaat baavǝl mǝ puus a naar ting-tǝng nǝ wul, ɓe pee nǝ rii nɗǝǝn yil nǝ jir, ɗel dǝm wul karfe kun mǝ puus. ");
INSERT INTO sur_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kaaɗe karfe kun nǝ cìn, ɓe Jesu wu petpee shi ɗoo ɗǝɗes, nǝnee, <<Eloi, Eloi, lama sabaktani?>> Manshii nǝ a nǝnee, <<Naan fen, Naan fen. A mbeeme ɗang a yit an yi?>> ");
INSERT INTO sur_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kaaɗe pak gurum mo mɓut nen ɗe moo ɗar ɗe mpee nǝ, mo kǝlǝng petpee mǝni, ɓe mo sat nǝnee, <<Gwar ɗesǝ wur kǝ pet a Ilaija>> ");
INSERT INTO sur_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɓe memee nɗǝǝn mo, wur su dǝm mang tuvuk lep nɗǝǝn am anab ɗeɗwang, wur lep nkaa rep mee kam. Wur lep kàa nJesu mbǝkǝ wur ɗyas ɗe. Pak gurum nǝ mo sat nǝnee, <<Wu ɗar aku mun naa mbii ɗe nǝn ncìn ɗi ɗe, kyet Ilaija wun njì ɓam wur wo?>> ");
INSERT INTO sur_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu waa baa bwet or shi ɗoo ɗǝɗes, ɓe wur shang nookmuut. ");
INSERT INTO sur_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɓe fuwaat ɗe nǝ nɗǝǝn Lu Naan ɗeɗes ɗe nii paapee Ɗeɓang met jir, nǝ tee sham a naar ɓe nǝ ɓàk vǝl. ");
INSERT INTO sur_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kaaɗe gwar ɗǝǝɗes nkaa shiitoon mo kambil mǝndong ɗewur ɗar kus kǝ shiyeepmúut nǝ, wur naa kaaɗi Jesu shang nookmuut, ɓe wu sat nǝ, <<Azeen-nzeen, gwar ɗesǝ wur a Làa Naan.>> ");
INSERT INTO sur_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pak mat moo ɗar ɗe pan jong, mon nkaa naa mbii ɗe nii cìn jir. nƊǝǝn mat nǝ mo, ɓe Meeri Makdalin waa ɗe, kǝ Salome kǝ Meeri nǝǝn Jemis ɗelee kǝ Josep. ");
INSERT INTO sur_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","A mo a mat ɗe di mo dǝm nɗang Jesu, kǝ moo cìn ɗak nwur kaaɗi di wur kuɗi nɗǝǝn yil nGalili, kǝ pak mat mo ɗes ɗe mo yool nGalili jì ashak kǝ wur nJerusalem. ");
INSERT INTO sur_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nciit kǝ mǝni, ɓe kansǝǝn cìn, a parpuus ɗe gurum moo ɗak sut ɗe, mbǝɗe ɗaar nǝ a puus nookɗi. ");
INSERT INTO sur_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ɓe Josep ngu Arimafiya, mee gwar ɗǝɗes, ɗewur nɗǝǝn nenɓeetpwoo mo, wur shikáa fin wur nkaa gong jì kǝ mulki Naan. Wur yaa pǝtuup, ɓe wur dǝm ɗang kúm Jesu pǝ Pailet, mbǝkǝ wur dǝm wum ɗe. ");
INSERT INTO sur_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nǝ aapwoo mPailet zam, mbǝɗe wur kǝlǝng nǝ, Jesu kǝ ten muut. Ɗangɓe Pailet pet shiitoon ɗeɗes nǝ, ɓe wur tal pǝ shiitoon nǝnee, <<Kyet Jesu kǝ ten muut a yam wo?>> ");
INSERT INTO sur_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kaaɗe Pailet kǝlǝng mbii ɗe shiitoon nǝ sat, ɓe Pailet sat mmo kǝ mo dǝm shin kúm Jesu nǝn nJosep. ");
INSERT INTO sur_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ɗangɓe Josep seet kǝ mee fuwaat ɗepiyaa. Ɓe wur sham kǝ kúm Jesu nǝ, wur ɓwot kúm nǝ shi fuwaat nǝ. Ɓe wur dǝm le kúm Jesu nǝ nɗǝǝn kǝcir ɗe mo am nǝ nɗǝǝn jwak. Ɓe wur tup mee nghǝk ɗǝɗes, wur paa pwoo kǝcir nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meeri Makdalin, kǝ Meeri nǝǝn kǝ Josep, mo naapee ɗe mo le kum Jesu nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Aɓwoon kǝ parpuus Nookɗi mǝ nen Yahudi mo, ɓe Meeri Makdalin kǝ Salome, kǝ Meeri nǝǝn kǝ Jemis, mo seet mwoor tus shangshang, mbǝkǝ mo dǝm pwes ɗe nkaa kúm Jesu. ");
INSERT INTO sur_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Parpuus ɗenshee mɓut nteer pwovǝl sǝ mo, mɓít nciit kǝ ɗe puus mɓe kaa ɓe mat nǝ mo pwat dǝm a peeɗi kǝcir nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mon nkaa sat nǝ shak a ar nǝnee, <<A wii mbet nghǝk ɗeɗes nǝ mmun mpwoo kǝcir nǝ ye?>> ");
INSERT INTO sur_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɓe kaaɗi mo ɗyeep yit, ɓe mo naa mo kǝ bèt nghǝk ɗeɗes nǝ baa kǝnǝ. Nghǝk nǝ a ɗeɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kaaɗe mo ɗel nɗǝǝn kǝcir nǝ, ɓe mo naa mee zǝlang wur tong nkwang sarse, wur kǝ nlǝr ɗepiyaa, ɓe nǝ lekǝǝrmuut mmo zam. ");
INSERT INTO sur_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Zǝlang nǝ wur sat mmo nǝnee, <<Taji kǝǝrmuut yaa wun kas, mbǝɗe wen man nǝ, wun pǝ yap a Jesu ngu Nazaret. Gwar ɗe mo pwas wur nkaa shiyeep sí, wur kǝ yool a peemúut nǝ. Baa wur mpesi kas. Wu jì wu naapee ɗe mo le wur ɗe nɗesi! ");
INSERT INTO sur_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɓe wu dǝm, wu sat jeplep wur mo, kǝ Pita nǝ, wur kǝ yool a peemúut, yaksǝ wur a ar dǝm nGalili a tǝleng nwun. Wun ndem wu naa wur a mpee mǝni, kaaɗi dǝ wur kǝ ten sat nwun sǝ.>> ");
INSERT INTO sur_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɗangɓe mat nǝ mo yool pwat yit kǝcir nǝ, ɓe mo shwe dǝm kǝ kǝǝrmuut, ɗang nǝ aapwoo mo zak. Baa mo taa sat mee mbii mmee gurum kas, mbǝɗe kǝǝrmuut nǝ fes yaa mo zam. ");
INSERT INTO sur_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kaaɗe Jesu yool mɓít parpuus ɗenshee, ɗe nǝ a puus Láadi ɓe wur shee kámshin fin a mMeeri Makdalin, a war a mat ɗe di Jesu kǝ ceen riin ɗebish mo pwoovǝl pwat nɗǝǝn war sí. ");
INSERT INTO sur_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","War dǝm sat nen ɗe di mo ashak kǝ Jesu. Mon nkaa wal kǝ maap. ");
INSERT INTO sur_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amma kaaɗi mo kǝlǝng pwoo ɗe war sat nǝ, Jesu wur kǝ yool a peemúut, ɗangɓe wen kǝ naa wur, ɓe baa mo shinzeen kas. ");
INSERT INTO sur_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aɓwoon mǝni, ɓe Jesu kámshin mmee jeplep wur mo vǝl, kaaɗi mo a ar dǝm mmee laayil. ");
INSERT INTO sur_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mo ciir dǝm sat nkoor jeplep nǝ mo nǝ, wuɗun kǝ naa Jesu, amma baa koor nǝ mo shinzeen kas. ");
INSERT INTO sur_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aɓwoon ɗese, ɓe Jesu jì kámshin njeplep ɗe kaapaat baamǝndong sǝ mo, ɓe moo tong a peese mbiise. Wur gwak mo mɓe ciin shinzeen fur, kǝ mbǝɗe pǝtuup fur mo a ɗeɓal, mbǝɗe baa mo shinzeen nen ɗe mo naa wur aɓwoon ɗewur kǝ yool a peemúut kas. ");
INSERT INTO sur_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesu sat mmo nǝnee, <<Wur dǝm nɗǝǝn yil nǝ jir, wur satpwoo ɗeret ɗe ngurum mo jir. ");
INSERT INTO sur_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gwar ɗewur shinzeen, kǝ mo cìn baptisma wur zak, ɓe wur nkat ɓam, amma gwar ɗewur cii shinzeen, ɓe mon ncanɗyeel muut nwur. ");
INSERT INTO sur_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mon nnaa mbii aapwoo ɗesǝ mo pǝ nen ɗe mo shinzeen nghan. Mon nshin iiko mmo mɓe ceen riin ɗebish mo nɗǝǝn sǝm fen. Mon nkatpwoo shi liispwoo mo shini-shini. ");
INSERT INTO sur_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Katɗang mo yak nwòo mo, koo mo shwaa yen tupee ɓe baa nǝn ncìn mee mbii mmo kas koo dǝɓen. Mon nle sar fur mo nkaa nenciinkoom mo ɓe mon mbar.>> ");
INSERT INTO sur_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aɓwoon ɗe Daa Jesu kǝ leshap kǝ mo, ɓe mo mang wur kaa aɗeng Naan. Ɓe wur kàa tong nsarse Naan. ");
INSERT INTO sur_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jeplep nǝ mo pwat dǝm satpwoo Naan shipe-shipe. Daa wur cìn ɗak nɗǝǝn mo, wur kám agaak nǝ, pwoo ɗe moo sat nǝ azeen shi mbii aapwoo ɗe mo cìn mo.");
INSERT INTO sur_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dǝm pǝ gha Tiyofilus. Nɗǝǝn ɓǝǝt-haal fen ɗenshee, ɓǝ wen ran pwoo nkaa mbii ɗe Jesu wur cìn mo, kǝ mbii ɗewur kám mo. ");
INSERT INTO sur_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Dǝm wul parpuus ɗe Naan mang wur kaa kǝ nǝ aɗeng. Aku ɗang Naan mang wur kaa kǝ nǝ aɗeng, ɓǝ wur leshap nnen ɗewur kǝ bǝlǝp mo, mbǝkǝ mo ɗee ɗe a jeplep fin mo, shi iiko mǝ Riin Ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mbǝ teer mo laarfeer aɓwoon ɗe Jesu kǝ yool a peemúut, ɓǝ wur woo shin mmo yit ɗes, nɗǝǝn ar mo shini-shini, ɗe nǝ kám agaak nǝ, wur ɗi mmeen azeen-zeen. Mo naa Jesu, kǝ wur leshap mmo nkaa mulki mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Par mǝ puus sǝ, ɓǝ kaaɗe wur ɗi ashak kǝ jeplep fin mo, ɓǝ wur leshap mmo ɓalɓal nǝnee, <<Taji wu yool wu yit Jerusalem kas. Ɗangɓe wu tong, wu naa gam zuum ɗe puun fen wur kǝ ten cweer nwun, ɗe wuu kǝlǝng nǝ mpwoo fen. ");
INSERT INTO sur_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dǝ Joon wur cìn baptisma ngurum mo a shi am, ɗang ɗee meeteer mo ɗi a lee ɗak, ɓǝ mon ncìn baptisma nwun a shi Riin Ɗeɓang.>> Mo Mang Jesu Kàa Kǝ Wur Aɗeng ");
INSERT INTO sur_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kaaɗe jeplep Jesu mo kuur ashak, ɓǝ mo tal pǝ wur nǝnee, <<Daa, gha mbǝ cin shin mulki nǝ nnen Isreil mo a nɗǝǝn meeteer ɗesǝ mo ee?>> ");
INSERT INTO sur_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesu lap mo nǝnee, <<Baa ɗesǝ nǝ a muu, mbǝkǝ nwun man puus nǝ, kǝ ɓit ɗe Daa kǝ ten le mo nɗǝǝn iiko fin kas. ");
INSERT INTO sur_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɗangɓǝ Naan wur nshin ɓal nwun, katɗang Riin Ɗeɓang sham nkaa wun. Ɓǝ wun mbǝ ɗee a langtǝng fen mhffig o nɗǝǝn Jerusalem, kǝ nɗǝǝn Judiya jir, kǝ Samariya, dǝm wul nɗǝǝn yil mo jir zak.>> ");
INSERT INTO sur_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kaaɗe wur sat pwoo mǝnǝ, ɓǝ mo mang wur kaa kǝ nǝ aɗeng a yit mo. Yaksǝ nluu jì paa wur, baa mo kutɗi naa wur kas. ");
INSERT INTO sur_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kaaɗe mo ɗi nkaa ban yit mo mo kaa kǝ nǝ aɗeng, ɓǝ mee gurum mo vǝl, mo jì ɗar pǝ mo ɗi, kǝ nlǝr piyaa petpet ");
INSERT INTO sur_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nen nǝ mo sat nǝnee, <<Wun nnen Galili mo, a mii le ɗang wuu ɗar, wuu ban yit kaa kǝ nǝ aɗeng ii? Jesu ɗe wu naa mo kǝ mang wur kaa kǝ nǝ aɗeng pǝ wun ɗi sǝ, ɓǝ wur mbǝ baa sham a kǝsǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ɓǝ jeplep mǝ Jesu mo yool yit Zuul Paat ɗe nǝ kus kǝ Jerusalem, ɗejong nǝ kǝ Jerusalem a meel mǝndong ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kaaɗe mo jì wul nɗǝǝn pee kaam nǝ, ɓǝ mo dǝm kàa nɗǝǝn luɗeng, a pee ɗe moo tong ɗi. A mon nɗesǝ, Pita, kǝ Joon, kǝ Jemis, kǝ Andru, Filip kǝ Tomas, Bartolomi, kǝ Matiyu, kǝ Jemis ɗyem Alfiyas, kǝ Simon Zelot, memee mɓut mee nnen ɗe gyet mo ɓalkaa mo mbǝ tang mulki mǝ yil mo, kǝ Judas làa Jemis. ");
INSERT INTO sur_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nen ɗesǝ mo ɓalkaa mo mo ashak mbǝ ɗangnaan shidaar-shidaar, shi pǝtuup mǝndong ashak kǝ pak shurep mo, kǝ Meri nǝǝn Jesu, kǝ ɗyemnǝǝn fin mo zak. ");
INSERT INTO sur_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nɗǝǝn meeteer mǝnǝ mo, ɓǝ nen shinzeen nǝ mo kuur ashak, (ɗe ɗuu mo nǝ wul kambil mǝndong kǝ laarvǝl), ɓǝ Pita yool ɗar atǝng nnaar mo mbǝ leshap, ɓǝ wur sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","<<Ɗyemnaa mo, nǝ a tǝng kǝ mo gampwoo ɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal mǝ Naan. Pwoo ɗe gyet Riin Ɗeɓang le kǝ Devit leshap nkaa Judas ngwe ɗewur ɗee a ngukám ar nnen ɗe dǝ mo yaa Jesu. ");
INSERT INTO sur_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Dǝ wur a memee mɓut mmun, kǝ dǝ wur cìn pak ɗak fun ɗesǝ nǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Shi shool ɗe Judas lap mbǝ kwat ɗak fin ɗebish, ɓǝ wur dǝm seet mee maar ɗishik. A pee ɗewur sham taa wur muut, wur piin ɓut fin, dǝm kat pinbut wur mo pwat ɓeer. ");
INSERT INTO sur_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mbii ɗesǝ nǝ ɗee a ɗemǝman ngurum ɗe moo tong nɗǝǝn yil nJerusalem jir, moo pet maar ɗesǝ nǝ shi liispwoo mo a Akeldama. Ɗe shii mǝnǝ a maar toom). ");
INSERT INTO sur_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","<<Mbǝɗǝ mo Jeplep Jesu mo ten ran nɗǝǝn ɓǝǝt haal Zabura nǝnee, <<Wu ar kǝ nlu wur nǝ ɗee a kǝrem. Taji mee gurum tong nɗǝǝn nǝ kas,> Kǝ mo ran zak nǝnee, <Wu yit kǝ mee gurum ɗee ɗi a koppee wur nǝ.> ");
INSERT INTO sur_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","<<Mbǝ mǝnǝ, ɓǝ nǝ ret kǝ mmun bǝlǝp mee gurum mɓut nnen ɗe peegyet mo ɗi ashak kǝ mun, kaaɗe dǝ Daa Jesu wur kǝ mwaan dǝm kǝ mun shipee-shipee sǝ. ");
INSERT INTO sur_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yool mɓít ɗe Joon kǝ cìn baptisma ngurum mo, dǝm wul parpuus ɗe Naan mang Jesu kaa kǝ nǝ aɗeng, pǝ mun ɗi. Nǝ ɗee a tǝng kǝ memee mɓut nnen ɗe mun mbǝlǝp sǝ mo, wur ɗee a ngusatpwoo nkaa yool kǝ Jesu a peemúut nǝ ashak kǝ mun.>> ");
INSERT INTO sur_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aasǝ ɓǝ mo le gurum mo vǝl ɗe sǝm mo mo a Josep ɗe moo pet wur a Barsabas koo Jastus, kǝ Matiyas zak. ");
INSERT INTO sur_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yaksǝ mo ɗangnaan nǝnee, <<Daa, gha ɗe a man pǝtuup gurum mo jir. A kám ngwe ɗe waa a bǝlǝp mmun, nɗǝǝn des ɗevǝl sǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mbǝkǝ ngwe nǝ cìn ɗak ɗi a koppee mǝ Judas kaa memee nɗǝǝn jeplep kǝ Jesu mo sǝ. Dǝ Judas yool yit ɗak nǝ ɗi, mbǝkǝ nwur dǝm ɗi a pee ɗyem fin.>> ");
INSERT INTO sur_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kaaɗe mo ɓwet bǝlǝp nǝ, ɓǝ nǝ taa nkaa, Matiyas. Yool mmǝnǝ, ɓǝ mo tang Matiyas ashak kǝ jeplep ɗe kaapaat baamǝndong nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kaaɗe parpuus Pentikos nǝ wul, ɓǝ nen shinzeen nǝ moo kuur ashak a pee mǝndong jir. ");
INSERT INTO sur_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yaksǝ, nnen mman, ɓǝ mee ɗoo ɗe fiipee ka kut ɗeɓal-ɓal sǝ, nǝ tong aɗeng sham gam lu ɗe moo tong ɗi jir. ");
INSERT INTO sur_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yaksǝ mo naa mee mbii kàa mbǝlem wus sǝ, nǝ sham lang nkaa mo jir ");
INSERT INTO sur_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mo gam mo jir shi Riin Ɗeɓang, yaksǝ mo ɗoom leshap mo shi liispwoo mo shini-shini, kaaɗe Riin Ɗeɓang kám mmo sǝ. ");
INSERT INTO sur_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nɗǝǝn meeteer mǝnǝ mo, ɓǝ pak nen Yahudi mo nɗǝǝn Jerusalem ɗe moo kǝǝr Naan mo ɗi, kǝ ɗe mo pwat nɗǝǝn yil mo shini-shinǝ jir, mo jì nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kaaɗe gurum mo kǝlǝng ɗoo nǝ, ɓǝ ɗuu mǝ gurum nǝ mo kuur a peeshak. Nǝ aapwoo ngurum nǝ mo, mbǝɗe koo a ngwe ɗeɗangyi, ɓǝ wur kǝlǝng nen shinzeen nǝ mo nkaa leshap shi liispwoo mǝ yil fin. ");
INSERT INTO sur_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nǝ lekǝǝrmuut, ɗang nǝ aapwoo mo, ɓǝ mo sat nǝnee, <<Nen ɗe moo leshap sǝ mo jir, a nen Galili mo. ");
INSERT INTO sur_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Cirang ɗang koo a ngwe ɗǝɗang nɗǝǝn mun, pǝ kǝlǝng mo nkaa leshap shi liispwoo mǝ yil fin ii? ");
INSERT INTO sur_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mun mu tong a nyil mPartiya, kǝ Mediya, kǝ Elam, kǝ nen ɗe mo tong nɗǝǝn Mesopotamiya, kǝ Judiya, kǝ Kapadosiya, kǝ Pontus, kǝ Eshiya, ");
INSERT INTO sur_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kǝ Firijiya, kǝ Pamfiliya, kǝ Ijip, kǝ ngaar Libiya, kus kǝ Sairin, kǝ pak fun mo a mǝzep ɗe mo tong nyil nRom jì ɗi. ");
INSERT INTO sur_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Mo a nen Yahudi mo, kǝ nen ɗe mo jì ɗeɗel nɗǝǝn nen Yahudi mo). Kǝ nen Kritan mo, kǝ nen Arab mo. Muu kǝlǝng mo nkaa leshap nkaa mbii aapwoo ɗǝnan-nan ɗe Naan wur cìn mo shi liispwoo mǝ yil fun mo.>> ");
INSERT INTO sur_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nǝ aapwoo mmo, ɗang nǝ suur mo jir, ɗang mo baa tal pǝ shak nǝnee, <<A mii a shii mbii ɗesǝ yii?>> ");
INSERT INTO sur_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ɗangɓǝ pak gurum mo nwang pwoo mmo, ɗang mo sat nǝnee, <<Nen ɗesǝ mo raa a am anab.>> Pita leshap nƊuu Gurum Mo Parpuus Pentikos ");
INSERT INTO sur_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ɓǝ Pita yool ɗar atǝng ashak kǝ jeplep ɗe kaapaat baamǝndong sǝ mo, ɓǝ wur ɗiyeep ɗoo fin ɓalɓal, ɓǝ wur sat nɗuu gurum nǝ mo nǝnee, <<Wun nen Yahudi mo, kǝ wun nen ɗe wuu tong nJerusalem jir. Wu lekom kǝ nwen sat shii mbii ɗesǝ mo ɗi nwun. ");
INSERT INTO sur_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Baa nen ɗesǝ mo raa a am anab kǝ nǝ yir kaa mo kaaɗe wuu pan sǝ kas, mbǝɗe pee nǝ kutɗi a pwoofeer mǝ bít nɗesǝ ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ɗangɓǝ, ɗesǝ nǝ a mbii ɗe gyet ngusat pwoo Naan Jowel kǝ ten sat sǝ nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<Naan wur sat nǝnee, Nɗǝǝn meeteer mǝ kyes nǝ mo. Ɓǝ an mbǝ nɗoo Riin fen nkaa gurum mo jir. Jep fuu ɗemish mo, kǝ ɗe mat mo, mon nsatpwoo Naan ngurum mo, kǝ mbii ɗe mo mbǝ jì akyeen. Zǝlang fuu mon nnaa mbii ɗesǝsok mo, ɗe Naan wur rǝɓet kám nǝ mmo, kǝ dǝkaam fuu mon nsuun suun mo. ");
INSERT INTO sur_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kǝzak, nɗǝǝn teer mǝnǝ mo, ɓǝ an mbǝ ɗoo Riin fen nkaa kǝrem fen ɗemish mo, kǝ ɗe mat mo. Ɓǝ mon nsatpwoo fen, kǝ mbii ɗe mo mbǝ jì akyeen zak. ");
INSERT INTO sur_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","An mbǝ cìn mbii lukshik mo aɗeng, ɗang an mbǝ cìn mbii aapwoo mo nɗǝǝn yil nǝ, ɗe toom kǝ wus, kǝ ɗiyeel, mon ɗen kàa gǝrong-gǝrong, ");
INSERT INTO sur_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","akuɗang puus ɗeɗes, kǝ iiko mǝ Daa nǝn njì, ɓǝ Puus nǝn nciir ɗee a peenkwoo, kǝ tar nǝn nciir ɗee a toom zak. ");
INSERT INTO sur_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Parmǝnǝ, ɓǝ koo a ngwe ɗeɗangyii, ɗewur pet sǝm mǝ Daa ɓǝ a wur nkat ɓam.> ");
INSERT INTO sur_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Wun nen Isreil mo! Wu lekom kǝ wu kǝlǝng pwoo ɗesǝ mo ɗe. Jesu ngu Nazaret, ngwe ɗe Naan kat retnyit kǝ wur, kǝ ɗe Naan cìn mbii lukshik mo, kǝ mbii aapwoo mo kǝ Sǝmpwoo mo nsar wur a yit fuu. Wun shikáa fuu wu man nǝ, mbii ɗesǝ mo cìn a kǝsǝ. ");
INSERT INTO sur_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A Jesu ɗesǝ ɗe mo seet wur nsar fuu. Mbǝɗǝ a Naan kǝ ten le, kǝ wur man nǝ, nǝn ncìn a kǝsǝ. A wun wu tu wur, mbǝɗe a wun wu le, kǝ nnenshikbish mo pwas wur nkaa shiyeep. ");
INSERT INTO sur_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ɗangɓe Naan yool kǝ Jesu a peemúut, kǝ wur fween Jesu nɗǝǝn jeel mǝ muut, mbǝɗe baa muut nǝ mmak yaa wur le ntuun nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mbǝɗǝ gyet Devit kǝ ten leshap nkaa Jesu nǝnee, wen naa Daa ashak kǝ an shidaar-shidaar. Mbǝɗǝ wur kus kǝ an, ɓǝ baa mee mbii mmak daampee nghan kas. ");
INSERT INTO sur_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mbǝ mǝnǝ, ɓǝ pǝtuup fen nǝ gam kǝ retnyit, ɗang lis fen met kook retnyit. Dǝm wul a ɗe fwooshik fen tong nɗǝǝn canciin zak. ");
INSERT INTO sur_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mbǝɗǝ baa gha mmak yit seen fen nɗǝǝn kǝcir kas, kǝ baa gha mmak yit Ngwe Ɗeɓang fwaa nwur naa wam nɗǝǝn kǝcir kas. ");
INSERT INTO sur_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Waa a ten a kám ar ɗe mo a mǝ seen nghan. Kǝ gha mbǝ ngam pǝtuup fen shi retnyit ntoom fwaa zak.> ");
INSERT INTO sur_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Ɗyemnaa mo, wu lekom, kǝ nghan leshap ɗi nwun rǝrret nkaa puunkaam fun Devit, ɗe gyet wur muut, ɓǝ mo wum wur, kǝcir wur nǝ ɗi mpee ɗesǝ har cicinsǝ. ");
INSERT INTO sur_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Gyet wur a ngusat pwoo mǝ Naan, ɗang wur man mbii ɗe Naan kǝ ten cweer nǝnee, wur nyool le memee nɗǝǝn ɗang wur mo, kǝ nwur ɗee ɗi a mishkoom koo Devit sǝ. ");
INSERT INTO sur_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gyet Devit kǝ ten naa mbii ɗe Naan nyool cìn akyeen, a kǝsǝ ɓǝ, wur leshap nkaa yool mǝ Kristi a peemúut nǝnee. Baa Naan nyit wur a peemúut kas, kǝ baa fwooshik wur nǝn nwam nɗǝǝn kǝcir kas. ");
INSERT INTO sur_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A Jesu ɗesǝ ɗe Naan kǝ yool kǝ wur a peemúut, ɗang mun sǝ jir, mun a langtǝng nǝ Jesu kǝ yool a peemúut. ");
INSERT INTO sur_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mo kǝ le Jesu a ɗeɗes, yaksǝ wur kǝ tong nsarse mǝ Naan, wur kǝ lap Riin Ɗeɓang pǝ Naan kaaɗe gyet wur kǝ cweer sǝ. Mbii ɗe wuu naa, kǝ ɗe wuu kǝlǝng sǝ, a zuum mǝ Riin Ɗeɓang ɗewur kǝ ɗoo shin sham nkaa mun. ");
INSERT INTO sur_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Baa gyet Devit kǝ kaa aɗeng kas, ɗang wur shikáa fin sat nǝnee <Daa wur kǝ sat nDaa fen nǝnee, A tong nsarse fen. ");
INSERT INTO sur_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Dǝm wul a ɗe an nle shaarlek fwaa mo ɗee a mbii leshii ngha.> ");
INSERT INTO sur_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Mbǝ mǝnǝ, wu yit kǝ nnen Isreil mo jir, mo man azeen-zeen nǝnee, An pǝ leshap a nkaa Jesu ɗe wu pwas wur sǝ. Ɗangɓe Naan kǝ le wur ɗee a Daa, kǝ Kristi zak.>> ");
INSERT INTO sur_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kaaɗe gurum nǝ mo kǝlǝng pwoo mǝnǝ, ɓǝ nǝ sul pǝtuup mmo hakyeng, yaksǝ mo sat mPita kǝ koor jeplep nǝ mo nǝnee, <<Ɗyemnaa mo, mun mbǝ ncìn a mii?>> ");
INSERT INTO sur_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ɓǝ Pita lap mmo nǝnee, <<Wu tuwap, mbǝkǝ mmo cìn baptisma ɗi nwun jir ngwe ɗeɗangyii nɗǝǝn wun, nɗǝǝn sǝm kǝ Jesu Kristi, mbǝkǝ nNaan fwo shikbish fuu mo ɗi nwun. Ɓǝ wun mbǝ lap zuum mǝ Riin Ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pwoo ɗe mo cweer nǝ, a mbǝ wun, kǝ jep fuu mo, kǝ mbǝ nen ɗejong mo jir, kǝ koo a ngwe ɗeɗangyii ɗe Daa fun Naan wur mpet zak.>> ");
INSERT INTO sur_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Shi pwoo mo ɗes, ɓǝ wur leshap mmo ɓalɓal, ɗang wur sat mmo nǝnee, <<Wu shang káa fuu mo mɓut kar ɗe nǝ mbǝ jì nkaa nen ɗebish ɗe nyicinsǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nen ɗe mo shinzeen mpwoo ɗewur le nǝ, ɓǝ mo cìn baptisma mmo, parpuus mǝnǝ, ɓǝ mo kat gurum mo ɗyikye koo ngal kun sǝ. ");
INSERT INTO sur_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Moo tong ashak shidaar-shidaar mbǝ kǝlǝng kám mǝ jeplep Jesu mo, kǝ shaar ashak, kǝ moo sese ashak, kǝ ɗangnaan ashak zak. Tong Nǝ Dǝm Dan Jesu Mo ");
INSERT INTO sur_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jeplep mǝ Jesu nǝ mo, cìn mbii aapwoo mo kǝ mbii lukshik mo ɗes, nǝ le kǝ gurum mo kǝǝr Naan zam. ");
INSERT INTO sur_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nen ɗe mo shinzeen nJesu jir, ɓǝ mo ɓalkaa mo mo ashak, kǝ mo le mbii mo mo ashak jir, a pee mǝndong. ");
INSERT INTO sur_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mo sǝrep mbii mo mo, kǝ long fur mo jir, mbǝkǝ mo shwap ɗi ashak, koo a wii, ɓǝ baa wur kat mee mbii jee nwur kas. ");
INSERT INTO sur_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Koo puus ɗeɗangyii ɓǝ moo dǝm kuur ashak, nɗǝǝn Lu Naan ɗeɗes nǝ, kǝzak mo kǝ se mbiise fur mo ashak nɗǝǝn lu fur mo shi retnyit hakyeng, kǝ shi pǝtuup ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Moo kwoop Naan, ɗang gurum moo kǝlǝng retnyit kǝ mo. Koo a puus ɗeɗangyii, ɓǝ Daa wur jì kǝ nen ɗe mo kǝ kat ɓam ɗyikye mmo. ");
INSERT INTO sur_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Par sǝ ɓǝ Pita kǝ Joon mo kàa nLu Naan ɗeɗes mbǝ ɗangnaan koo kun ɗe mǝ puus sǝ. ");
INSERT INTO sur_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yaksǝ mo kat mee gwar ɗe mo làa wur a kurumkut mpwoo lu nǝ, ɗe moo pet a Ɗeret. Koo puus ɗeɗangyii ɓǝ moo mang wur jì le mpwoo lu nǝ, mbǝkǝ nwur ɗang shool ɗi pǝ nen ɗe moo ɗel nɗǝǝn Lu Naan ɗeɗes nǝ. ");
INSERT INTO sur_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kaaɗe wur naa Pita kǝ Joon mo mbǝ ɗel nɗǝǝn Lu Naan nǝ, ɓǝ wur ɗang shool pǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita kǝ Joon mo ban yit nkaa wur. Ɓǝ Pita sat ngwar nǝ nǝnee, <<A naa mun.>> ");
INSERT INTO sur_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yaksǝ wur lepyit nkaa mo, mbǝɗe wur pan nǝ, mon nshin mee mbii nɗin. ");
INSERT INTO sur_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita sat ngwar nǝ nǝnee, <<Baa an kǝ mee shool azurfa, koo zinariya kas. Mbii ɗe an kǝ nǝ, ɓǝ an nshin ngha. Nɗǝǝn sǝm kǝ Jesu Kristi ngu Nazaret, a yool a mwaan.>> ");
INSERT INTO sur_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita yaa sarse mǝ gwar nǝ, kǝn nwur wur ɗiyeep gwar nǝ ɗi. Yaksǝ abet-abet, ɓǝ kwakshii wur mo, kǝ ɓaas wur mo katɓal. ");
INSERT INTO sur_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɓǝ gwar nǝ yool mǝreppee shi shii fin mo, ɗang wur ɗoom mwaan, dǝm ɗel nɗǝǝn Lu Naan ɗeɗes nǝ ashak kǝ mo zak. Wur nkaa mwaan, ɗang wur nkaa mǝreppee, kǝzak wur nkaa kwoop Naan. ");
INSERT INTO sur_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kaaɗe gurum mo naa wur nkaa mwaan, ɗang wur nkaa kwoop Naan, ");
INSERT INTO sur_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ɓǝ mo man nǝ, a gwar ɗe di moo mang wur jì le mpwoo lu Naan ɗe moo pet a Ɗeret mbǝkǝ nwur ɗang shool ɗi pǝ gurum mo. Nǝ aapwoo ngurum nǝ mo zam, kǝzak nǝ lekǝǝrmuut mo mbǝ mbii ɗe mo cin ngwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kaaɗe gwar nǝ wur ɗyiin nɗang Pita kǝ Joon, ɓǝ nǝ aapwoo ngurum nǝ mo zam, yaksǝ mo su dǝm pǝ mo ɗi nɗǝǝn kuut ɗe moo pet a mǝ Solomon. ");
INSERT INTO sur_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kaaɗe Pita naa a kǝsǝ, ɓǝ wur sat ngurum nǝ mo nǝnee, <<Wun nen Isreil mo! A mii le ɗang bar gwar ɗesǝ nǝ aapwoo nwun yii? A mii le ɗang wuu ban yit nkaa mun, koo a shi mee ɗeɗes fun, koo a shi mee ɗeret fun, ɗang mu le ngwar ɗesǝ mwaan yii? ");
INSERT INTO sur_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Naan mǝ Abraham kǝ mǝ Aizik kǝ mǝ Jekop, kǝ mǝ puun fun mo, a wur le nguɗak fin Jesu a ɗeɗes. Dǝ a wun wu seet Jesu, ɗang wu cii wur ntoom Pailet, kaaɗe Pailet sat nǝ, ɗyin mbǝ ɓwet Jesu. ");
INSERT INTO sur_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dǝ wu cii ngwe Ɗeɓang, ɗewur a ngwe ɗe ndǝre, mbǝkǝ nwun ɗang mmo ɓwet a ngutukáa ɗi nwun. ");
INSERT INTO sur_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wu tu ngwe ɗewur a tuus mǝ seen, ɗe a wur shin seen ngurum mo. Ɗangɓe Naan yool kǝ wur a peemúut, ɗang mun a langtǝng mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A shi shinzeen nɗǝǝn sǝm kǝ Jesu, a nǝ le ɗang gwar ɗesǝ, kat bar. Gwar ɗe wu naa, kǝ ɗe wu man sǝ. A nɗǝǝn sǝm kǝ Jesu, kǝ shinzeen ɗe nǝ put pǝ wur ɗi, a nǝ le ngwar ɗesǝ wur ɗee a ngu nkoom kǝdǝng-dǝng, a yit fuu jir. ");
INSERT INTO sur_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Yaksǝ ɗyemnaa mo, wen man nǝ, mbii ɗe dǝ wun kǝ nennan fuu mo, wu cìn nJesu, ɓǝ dǝ wu cìn a mbǝ ciin man. ");
INSERT INTO sur_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ɗangɓe Naan yit kǝ mo cìn mbii ɗesǝ mo jir, a mbǝkǝ mmo gampwoo ɗe gyet Naan kǝ ten sat mpwoo nensatpwoo fin mo nǝ, Kristi fin mbǝ shwaajeel. ");
INSERT INTO sur_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wu tuwap, mbǝkǝ nwun ciir pǝ Naan ɗi, mbǝkǝ nNaan fwoo shikbish fuu mo ɗi nwun. Katɗang wu tuwap azeen-zeen, ɓǝ Naan mbǝ naa ngam wun shi mbii ɗe mo a mǝ Riin fin, mbǝkǝ taji nǝ waam wun kas. ");
INSERT INTO sur_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kǝ wur mbǝ lep Jesu Kristi, ɗewur kǝ ten bǝlǝp wur mbǝ wun. ");
INSERT INTO sur_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wur mbǝ tong nɗǝǝn ɗengnaan, dǝm wul parɗe Naan ciir kǝ mbii mo ɗee a ɗepwoo jir akuɗang. Kaaɗe gyet Naan kǝ ten cweer mpwoo nensatpwoo fin ɗeɓang mo pǝgyet ɗi yam-yam sǝ. ");
INSERT INTO sur_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gyet Mosis sat nǝnee, <Daa Naan fuu mbǝ yool kǝ mee ngusatpwoo fin nwun, mɓut nnen fuu mo, kaa wen sǝ.> Nǝ a tǝng nwun lekom, kǝ nwun kǝlǝng mbii ɗewur mbǝ sat mo ɗi nwun jir. ");
INSERT INTO sur_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Koo a ngwe ɗeɗangyii ɗe baa wur mbǝ lekom kǝ nwur kǝlǝng ngusatpwoo Naan mǝnǝ ɗi kas, ɓǝ mon nshang wur baa kǝ nǝ mɓut nen Naan mo. ");
INSERT INTO sur_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nensatpwoo mǝ Naan mo jir, yool mɓít Samuwel, kǝ nensatpwoo Naan ɗe mo jì mɓwoon wur zak, mo jir mo kǝ ten leshap nkaa teer ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pwoo ɗe gyet Naan wur cweer mpwoo nensatpwoo fin mo nǝ a mbǝ wun, kǝ nwun sekop mǝ mbii ɗe gyet Naan wur kǝ ten cweer mpuun fuu mo shi toom, kǝ ɗe gyet wur sat Abraham nǝnee, <A nɗǝǝn ɗang fwaa, ɓǝ gurum ɗe nɗǝǝn yil nǝ mo jir, mon nkat ɗeret.> ");
INSERT INTO sur_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kaaɗe Naan wur bǝlǝp nguɗak fin, ɓǝ Naan wur shee lep wur shin jì a pǝ wun ɗi, mbǝkǝ nwur le ɗeret ɗi nkaa wun, kǝ mbǝkǝ nǝ ciir ɗi kǝ koo a wii nɗǝǝn wun, kǝ nwur yit cìn mbii ɗebish mo ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kaaɗe Pita kǝ Joon, mo ɗi nkaa leshap ngurum nǝ mo, ɓǝ pak pris mo, kǝ ngwe ɗeɗes mǝ nentap Lu Naan ɗeɗes, kǝ pak nen Sadusi mo, mo jì pǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nǝ láa mmo mɓut, mbǝɗe jeplep ɗevǝl nǝ mo, nkaa kám ngurum mo nǝ, Jesu kǝ yool a peemúut. Ɗe nǝ kám nǝ, katɗang gurum mo murep, ɓǝ mon nyool a peemúut mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mo yaa Pita kǝ Joon, ɓǝ mo dǝm shoot mo teer nlushoot, mbǝɗe kansǝǝn kǝ cìn. ");
INSERT INTO sur_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jir aasǝ gurum mo ɗes mo shinzeen mpwoo nǝ, ɗe daas mo kus kǝ wul ngal paat. ");
INSERT INTO sur_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dǝɗaar nǝ, ɓǝ nen taatǝleng mǝ nen Yahudi mo, kǝ nen ɗenan-nan mo mo, kǝ nenkám Wàar Mosis mo, mo kuur ashak, nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kǝ Anas ɗewur a pris ɗeɗes met jir, wur ɗi ashak kǝ mo, kǝ Kayafas, kǝ Joon kǝ Alekzanda, kǝ nen ɗe mo a ɗang mǝ pris ɗeɗes met jir nǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kaaɗe mo lep kǝ mmo dǝm jì kǝ Pita kǝ Joon, ɓǝ mo le mmo ɗar ntoom mo. Yaksǝ mo ɗoom tal pǝ mo nǝnee, <<A shi ɗeɗes mǝ wii, koo a nɗǝǝn sǝm mǝ wii, ɓǝ wuu cìn mbii ɗesǝ yii?>> ");
INSERT INTO sur_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mbǝɗǝ Pita wur gam kǝ Riin Ɗeɓang, ɓǝ wur lap mmo nǝnee, <<Wun nen taatǝleng mǝ gurum mo, kǝ nen ɗenan-nan mo. ");
INSERT INTO sur_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Katɗang wu tokɗyeel mun cicinsǝ a mbǝ ɗeret ɗe mo cìn ngwar ɗe dǝ wur a kurumkut sǝ, kǝ nkaa ar ɗe gwar nǝ wur ɗee a ɗebǝbar sǝ, ");
INSERT INTO sur_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ɓǝ wu yit kǝ mbii ɗesǝ ɗee a mǝ man pǝ wun ɗi, kǝ nen Isreil mo jir nee, a shi sǝm mǝ Jesu Kristi ngu Nazaret, ɗe wu pwas wur nkaa shiyeep ɗewur muut, ɗangnaan yool kǝ wur a peemúut. A mbǝ Jesu, ɗang gwar ɗesǝ wur ɗar ntoom fuu a ɗebǝbar. ");
INSERT INTO sur_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A Jesu a ngwe ɗe mo kǝ ten ran pwoo nkaa wur nɗǝǝn ɓǝǝt-haal mǝ Naan nǝnee, <Ngǝk ɗe wun nen ɗyiklu mo wu cii, ɓǝ a nǝ ɗee a ngǝk ɗekǝkoop met jir nɗǝǝn kwang mǝ lu nǝ.> ");
INSERT INTO sur_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Baa gurum mon nwaa mak kat mee ɓam pǝ mee ngwe ɗi kas. Mbǝɗǝ nɗǝǝn yil ɗesǝ jir, ɓǝ baa Naan kǝ shin ɗeɗes mmee ngwe, mbǝkǝ nwur ɓam gurum mo ɗi kas, tǝng a nɗǝǝn sǝm mǝ Jesu Kristi ɓejee ɗak>> ");
INSERT INTO sur_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaaɗe mo naa Pita kǝ Joon, mo leshap ɓalɓal, baa kǝ mee kǝǝrmuut kas, ɓǝ nǝ aapwoo mmo, mbǝɗe baa Pita kǝ Joon mo a mee mbii kas, kǝzak baa mo kǝ kam tang ran dǝm jong kas zak nǝ tang mo pǝtuup nǝ ɗe mo ashak kǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Baa nenɓeetpwoo nǝ mo mak cìn mee mbii kas, mbǝɗe mo naa gwar ɗe mo kǝ bar wur nǝ, wur ɗar ɗi ashak kǝ Pita kǝ Joon. ");
INSERT INTO sur_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aasǝ, ɓǝ mo le kǝ mmo pwat kǝ Pita kǝ Joon, mbǝkǝ mmo ɓeet ɗi ashak mbii ɗe mon ncìn kǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mo sat nǝnee, <<Mmun ncìn a mii kǝ nen ɗesǝ mo yii? Azeen-zeen gurum ɗe moo tong nɗǝǝn nJerusalem jir, mo kǝ man nǝ, Naan kǝ cìn mee mbii lukshik ɗeɗes nsar kǝ Pita kǝ Joon, ɗang baa mun mmak cíipwoo nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mbǝkǝ taji gurum mo ɗes mo kǝlǝng pwoo ɗesǝ nǝ kas, ɓǝ wu yit kǝ mmun cíi mmo nǝ, taji mo baa leshap ɗi mmee gurum nɗǝǝn sǝm mǝ Jesu kas.>> ");
INSERT INTO sur_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kaaɗe mo waa pet Pita kǝ Joon mo ɗel, ɓǝ mo sat mmo ɓalɓal nǝnee, <<Taji wu baa wu sat meepwoo, koo wu kám mee mbii nɗǝǝn sǝm mǝ Jesu kas.>> ");
INSERT INTO sur_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ɗangɓe Pita kǝ Joon mo lap mmo nǝnee, <<Wun shikáa fuu wu ɓeet, kyet nǝn nret nNaan nyit kǝ mmun cìn a mbii ɗe wun wu sat aa? Koo a mbii ɗe Naan sat yii? ");
INSERT INTO sur_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Baa mun mbǝ nook leshap nkaa mbii ɗe mu naa, kǝ mbii ɗe mu kǝlǝng kas.>> ");
INSERT INTO sur_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aɓwoon ɗe mo kǝ gwak mo ɓalɓal kǝ lekǝǝrmuut mmo, ɓǝ mo ɓwet mo, baa nenɓeetpwoo nǝ mo mak cin mee kar ɗebish mPita kǝ Joon kas, mbǝɗe gurum nǝ mo jir, mon nkaa kwoop Naan mbǝ mbii ɗe mo naa nǝ cìn. ");
INSERT INTO sur_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gwar ɗe mo bar wur shi ar ɗe mǝ aapwoo nǝ, ɓit wur mo met nlaarfeer. ");
INSERT INTO sur_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaaɗe mo ɓwet Pita kǝ Joon, ɓǝ mo dǝm pǝ nniyee fur mo ɗi. Mo sat nniyee fur nǝ mo, mbii ɗe pris ɗenan-nan mo, kǝ nen ɗenan-nan mo sat mmo jir. ");
INSERT INTO sur_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kaaɗe nen shinzeen nǝ mo kǝlǝng pwoo mǝnǝ, ɓǝ mo ɗangnaan shi pǝtuup mǝndong, nǝnee, <<Daa Ɗehai, ɗe waa a le ɗeng kǝ yil, kǝ am kuur mo, kǝ mbii ɗe mo nɗǝǝn mo jir. ");
INSERT INTO sur_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gyet a shi Riin Ɗeɓang, ɓǝ waa a leshap mpwoo mǝ kǝrem fwaa ɗewur a puunkaam fun Devit nǝnee <A mii le ɗang gurum ɗe baa mo a nen Yahudi mo kas, mo yool ntuup yii? A mii le ɗang gurum nǝ mo kǝ pan ɗebish nɗǝǝn pǝtuup fur mo, mbǝ cìn mbii ɗebuu mo yii? ");
INSERT INTO sur_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Deskoom ɗe mǝ yil nǝ mo, mo kǝ ɗak sut fur mo mbǝ lek, kǝ nenpanyil mo kǝ ɓalkaa fur mo ashak, mbǝkǝ mmo yaa lek ɗi kǝ Daa Naan kǝ Kristi fin zak.> ");
INSERT INTO sur_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mbǝɗǝ azeen-zeen nɗǝǝn pee nkaam ɗesǝ, ɓǝ Herot kǝ Pontus Pailet, ashak kǝ nen ɗe baa mo a nen Yahudi mo kas, kǝ nen Isreil mo, mo kǝ kuur ashak, mbǝkǝ mmo ɗee a shaarlek mǝ nguɗak fwaa Jesu Ɗeɓang, ɗe waa a bǝlǝp wur, ɗe a gha le nwur ɗee a Kristi. ");
INSERT INTO sur_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mo kuur ashak, mbǝkǝ mmo cìn koo a mbii ɗeɗangyii ɗe a gha aa ten a le shi iiko fwaa kǝ reɓet fwaa nǝ, mbii nǝ mon ncìn a kǝsǝ. ");
INSERT INTO sur_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yaksǝ Daa Naan a naa kǝǝrmuut ɗe moo le mmun. A shínɓal mmun kǝrem fwaa mo, mbǝkǝ mmun satpwoo fwaa ɗi ɓalɓal, baa ashak kǝ kǝǝrmuut kas. ");
INSERT INTO sur_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","A le kǝn iiko fwaa nǝ bar gurum mo, kǝ a le kǝ mbii lukshik mo kǝ mbii aapwoo mo cìn nɗǝǝn sǝm mǝ nguɗak fwaa Jesu Ɗeɓang.>> ");
INSERT INTO sur_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kaaɗe mo kyes ɗangnaan mǝnǝ, ɓǝ pee ɗe moo kuur ɗi ashak, nǝ sǝǝn. Mo gam kǝ Riin Ɗeɓang jir, yaksǝ mo yaa satpwoo mǝ Naan ɓalɓal agaak, baa ashak kǝ kǝǝrmuut kas. ");
INSERT INTO sur_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nen ɗe mo shinzeen nJesu jir, ɓǝ pan mo mo, kǝ mǝse mo mo ɗee a ɗemǝndong jir zak. Baa mee gurum nɗǝǝn mo mak sat nǝ, long fin nǝ a mǝnǝ mbǝshin kas, ɗang mo le mbii fur mo jir, ashak. ");
INSERT INTO sur_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jeplep nǝ mo ɗee a langtǝng shi iiko, nkaa yool mǝ Daa Jesu a peemúut. Daa Naan le ɗeret nkaa mo jir hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Baa mee ngwe ɗee, a ngujeel nɗǝǝn mo koo mǝndong kas, mbǝɗe nen ɗe mo kǝ maar mo, kǝ lu mo, ɓǝ mo sǝrep mo jir, ");
INSERT INTO sur_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɓǝ mo jì shin shool mǝ mbii ɗe mo kǝ sǝrep nǝ mon njeplep mǝ Jesu nǝ mo. Ɓǝ jeplep nǝ mo shwap shool nǝ nnen shinzeen nǝ mo nciit-nciit, mbǝkǝ koo ngwe ɗeɗangyii, ɓǝ wur kat mbii ɗewur kǝ reɓet. ");
INSERT INTO sur_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kaaɗe mo nkaa cìn mǝnǝ kǝsǝ, ɓǝ Josep ngu Livai, ɗewur put a nyil nSaiprus, kǝ ɗe jeplep nǝ mo le sǝm nwur a Barnabas, (ɗe shii mǝ sǝm mǝnǝ a nǝ, Ngwe ɗewur kǝ caapee). ");
INSERT INTO sur_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wur mang mee maar fin seet, ɓǝ wur jì shin shool nǝ jir njeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mee gwar ɗi, ɗe moo pet sǝm wur a Ananiyas, kǝ mat fin Saffira, mo mang mee maar fur mo seet. ");
INSERT INTO sur_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɗangɓe wur kǝ mat fin mo ɓalpwoo mo ashak, mbǝkǝ mmo sok pak shool nǝ ɗi, ɗang Ananiyas jì shin koor shool nǝ njeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ɗangɓe Pita sat nǝnee, <<Ananiyas, a mii le ɗang a yit kǝ nngujwaan gam pǝtuup fwaa, kǝn nghan cìn ɗung ɗi nRiin Ɗeɓangyii? Mbǝɗǝ aa sok pak shool maar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Akuɗang aa mang maar nǝ a seet, ɓǝ baa dǝ nǝ a mwaa kas aa? Kǝzak aɓwoon ɗe dǝ a mang maar nǝ a seet, ɓǝ baa shool nǝ a mwaa kas ee? A mii le ɗang a kat pan mǝ cìn mbii ɗesǝ nɗǝǝn pǝtuup fwaa yii? Baa a cìn ɗung ɗesǝ nǝ a ngurum mo kas, a cìn ɗung nǝ a nNaan.>> ");
INSERT INTO sur_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kaaɗe Ananiyas kǝlǝng pwoo mǝnǝ, ɓǝ wur taa nyil, wur muut. Nen ɗe mo kǝlǝng muut nǝ jir, ɓǝ kǝǝrmuut ɗeɗes yaa mo hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Zǝlang mo jì ɗel nɗǝǝn lu nǝ, ɓǝ mo ɓwoot kúm wur nǝ shi zaal, ɓǝ mo mang kúm nǝ put kǝ nǝ a tool, ɗang dǝm wum wur. ");
INSERT INTO sur_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aɓwoon ɗe mo tong koo awa kun sǝ, ɓǝ mat wur Saffira jì ɗel nlu nǝ. Baa war man mbii ɗe nǝ kǝ tung kas. ");
INSERT INTO sur_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita tal pǝ war nǝnee, <<Yi sat nghan, kyet a jee mǝ shool ɗe wu seet kǝ maar nǝ nɗesǝ aa?>> War lap nǝnee, <<Ii, a jee shool nǝ mmǝnǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita sat nwar nǝnee, <<A mii le ɗang wu ɓalpwoo ashak kǝ mish fii, mbǝkǝ nwun wu kam Riin mǝ Daa Naan ɗi ee? Yi kǝlǝng shii mǝ nen ɗe mo waa nwum mish fii mo kǝ jì wul mpwoo lu sǝ. Mo mbǝ mang kúm fii nǝ put kǝ nǝ a kǝsǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Abet-abet ɓǝ war sham taa nyil nshii Pita, yaksǝ war muut. Kaaɗe zǝlang nǝ mo jì ɗel nlu nǝ, ɓǝ mo kat war kǝ muut, ɓǝ mo mang kúm nǝ put kǝ nǝ a tool, ɓǝ mo dǝm wum war pǝshak kǝ mish fer. ");
INSERT INTO sur_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kǝǝrmuut ɗeɗes yaa nen shinzeen nǝ mo jir, kǝ nen ɗe mo kǝlǝng pwoo nkaa mbii mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jeplep nǝ mo cìn mbii lukshik mo, kǝ mbii aapwoo mo ɗes, nnaar gurum nǝ mo. Nenshínzeen nǝ moo kuur ashak jir nɗǝǝn kuut mǝ Solomon shi pǝtuup ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ɗangɓe nɗǝǝn koor gurum ɗe baa mo shinzeen kas, ɓǝ baa mee ngwe mak gung, ɗewur mɓàlkáa fin ashak kǝ mo kas. Jir kǝsǝ, ɓǝ gurum mo kǝ kwoop mo hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gurum mo ɗes, daas mo kǝ shurep mo, mo shinzeen nDaa, ɓǝ mo ɓalkaa fur mo ashak kǝ nen shinzeen nǝ mo, ɗe nen shinzeen nǝ mo ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mbǝ mbii aapwoo ɗe jeplep nǝ mo cìn, ɓǝ gurum mo kok nengok mo jì le pǝkom ar nkaa gwaansaam mo, kǝ kurkwaa mo, mbǝkǝ katɗang Pita jì ɗel, ɓǝ mǝ riin wur nǝ ntáa tung pak nengok nǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nen ɗe mo nɗǝǝn yil ɗe mo neer Jerusalem ciirkaat mo jì kuur. Mo jì kǝ nen ɗe baa mo kǝlǝng koom kas, kǝ nen ɗe riin ɗebish mo kǝ lejeel mmo, ɓǝ jeplep nǝ mo bar mo jir. ");
INSERT INTO sur_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pris ɗeɗes met jir kǝ nen ɗe mo ashak kǝ wur jir, ɗe mo a soon mǝ nen Sadusi mo, mo gam kǝ zuur mbǝ jeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mo yak jeplep nǝ mo, mo dǝm le mo nɗǝǝn lushoot. ");
INSERT INTO sur_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ɗangɓe mpar, ɓǝ mee ngulep mǝ Daa jì wang pwoo lushoot nǝ mmo, ɓǝ wur pwat kǝ mo, ɗang wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<Wu dǝm, wu ɗar nɗǝǝn Lu mǝ Naan ɗeɗes nǝ, kǝn nwun satpwoo mǝ seen ɗesǝ nǝ ɗi ngurum mo jir.>> ");
INSERT INTO sur_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kaaɗe mo kǝlǝng pwoo mǝnǝ, ɓǝ ɗaar mɓít-mɓít, mo dǝm ɗel nɗǝǝn Lu mǝ Naan ɗeɗes nǝ, ɓǝ mo yaa kámpwoo Naan ngurum mo. Ɓǝ pris ɗeɗes met nǝ jì kǝ nen ɗe mo ashak kǝ wur, ɓǝ mo pǝrep nenɓeetpwoo mo, kǝ nen ɗenan-nan ɗe mǝ nen Yahudi mo, mo kuur ashak jir. Yaksǝ mo lep jepkam mo shindǝm nlushoot nǝ, mbǝkǝ mmo jì ɗi kǝ jeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɗangɓe kaaɗe jepkam nǝ mo dǝm, ɓǝ baa mo dǝm kat jeplep nǝ mo ɗi nɗǝǝn lushoot nǝ kas. Yaksǝ jepkam nǝ mo baaji sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Mu kat lushoot nǝ a shishoot rǝrret, kǝ nentappee nǝ mo kǝ ɗar mpwoo lu nǝ mo, ɗang kaaɗe mu wang lu nǝ, ɓǝ baa mu kat jeplep nǝ mo ɗi kas.>> ");
INSERT INTO sur_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kaaɗe ngwe ɗeɗes nkaa nentap Lu mǝ Naan ɗeɗes nǝ, kǝ pris ɗǝnan-nan mo kǝlǝng pwoo mǝnǝ, ɓǝ nǝ daampee mmo zam, mbǝ jeplep nǝ mo, mbǝɗe baa mo man mbii ɗe nǝ kǝ kat jeplep nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mee gurum jì sat mmo nǝnee, <<Wu naa, nen ɗe wu le mo nɗǝǝn lushoot sǝ, mon nkaa kam-kam ngurum mo nɗǝǝn Lu mǝ Naan ɗeɗes nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yaksǝ ngwe ɗeɗes nkaa nentap Lu mǝ Naan ɗeɗes nǝ dǝm, ashak kǝ pak nentap lu mǝ Naan nǝ mo, mo dǝm jì kǝ jeplep nǝ mo. Ɗang baa mo dǝm jì kǝ mo a shi mee ɓal kas, mbǝɗe mo kǝǝr gurum nǝ mo, mbǝkǝ taji gurum nǝ mo car mo shi ndǝng kas. ");
INSERT INTO sur_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kaaɗe mo jì kǝ jeplep nǝ mo, ɓǝ mo le mmo ɗar ntoom mǝ nenɓeetpwoo nǝ mo. Yaksǝ pris ɗeɗes met jir nǝ tal pǝ Pita kǝ Joon nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","<<Muu tǝǝrsar nwun ɓalɓal nǝ, taji baa wu kám mee mbii ngurum mo nɗǝǝn sǝm mǝ Jesu kas. Ɗangɓe mbii ɗe wuu cìn ɗesǝ nǝ, wuu ɗaar a mbǝkǝ nwun sat ɗi ngurum mo nǝ, a mun mu tu gwar ɗesǝ nǝ, kǝzak wu gam Jerusalem shi kám fuu ɗesǝ nǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ɗangɓe Pita kǝ jeplep nǝ mo, mo lap mmo nǝnee, <<Nǝ a tǝng kǝ mun cìn a mbii ɗe Naan sat, met mbii ɗe gurum mo sat. ");
INSERT INTO sur_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesu ɗe wu tu wur, ɗe wu pwas wur nkaa shiyeepyoom, ɓǝ Naan mǝ puun fun mo, kǝ yool kǝ Jesu a peemúut. ");
INSERT INTO sur_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Naan kǝ yool kǝ Jesu a peemúut, ɓǝ yaksǝ Jesu kǝ tong nsarse mǝ Naan, a wur a Laakop kǝ Nguɓam zak. A wur wang ar tuwap nnen Isreil mo, mbǝkǝ nNaan fwo shikbish mo mo ɗi zak. ");
INSERT INTO sur_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mun a langtǝng mǝ mbii ɗesǝ mo, kǝ Riin Ɗeɓang ɗe Naan shin nnen ɗe mo cìn ɗyen wur, mo kǝ cìn langtǝng nǝ a kǝsǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaaɗe kuur mǝ nenɓeetpwoo nǝ mo kǝlǝng pwoo mǝnǝ, ɓǝ nǝ láa mmo mɓut hakyeng, dǝm wul a ɗe moo reɓet twe jeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ɗang mee ngu Farisi ɗe kǝ kám Wàar mǝ Mosis, ɗi sǝm wur a Gamaliyel, gurum mo jir mo kǝ shin ɗeɗes nwur. Wur yool ɗar atǝng nɗǝǝn lu ɓeetpwoo nǝ, ɓǝ wur le kǝ mmo pwat kǝ jeplep nǝ mo a tool ɓe reppee lee. ");
INSERT INTO sur_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɓǝ wur sat nnen ɓeetpwoo nǝ mo nǝnee, <<Ɗyemnaa mo, nen Isreil mo. Wu tap kǝ mbii ɗe wuu reɓet cìn nǝn ndes ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gyet yam-yam, ɓǝ mee gwar ɗe, ɗe mo kǝ pet sǝm wur a Tudas, wur kǝ cam yool a kǝsǝ. Gyet wur lekáa fin a koo mee ngwe ɗeɗes sǝ, ɗe gurum mo koo kambil feer sǝ mo dǝm nɗang wur. Ɗang aɓwoon ɗe mo tu wur, ɓǝ nen ɗe mo dǝm nɗang wur nǝ jir, mo rangkáa, baa mo ɗee a mee mbii kas. ");
INSERT INTO sur_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aɓwoon Tudas, ɓǝ Judas, mee ngu Galili yool zak, nɗǝǝn ɓit ɗe moo tang ɗuu gurum mo ɗi, yaksǝ wur dul pak gurum mo dǝm nɗang shin, ɗang aɓwoon ɗe mo tu wur zak, ɓǝ nen ɗe mo dǝm nɗang wur jir, mo rangkáa. ");
INSERT INTO sur_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mbǝmǝnǝ an pǝ sat nwun, taji wu cìn mee mbii ndes ɗesǝ mo kas. Wu yit mo mbǝsut. Mbǝɗǝ katɗang pwoo ɗe moo kám ngurum mo, kǝ ɗak ɗe mo kǝ cìn nǝ a mǝ mǝse mǝ gurum, ɓǝ nǝn nyool ɗee a ɗebuu. ");
INSERT INTO sur_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ɗang katɗang mbii ɗe moo cìn nǝ a mǝ Naan, ɓǝ baa mu mmak se koorong nkaa mo kas. Wu tap taji nwun ɗee koo wun a nlek kǝ Naan sǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nenɓeetpwoo nǝ mo kǝlǝngkar Gamaliyel nǝ. Mo pǝrep jeplep nǝ mo cin jì ɗel zak, ɓǝ mo sǝrem mo, kǝzak mo tǝǝrsar mmo ɓalɓal nǝnee, <<Taji baa wu sat mee pwoo ɗi nɗǝǝn sǝm mǝ Jesu zak kas.>> Aɓwoon pwoo mǝnǝ, ɓǝ mo ɓwet mo. ");
INSERT INTO sur_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jeplep nǝ mo pwat ntoom mǝ nenɓeetpwoo nǝ mo shi retnyit, mbǝɗe mo mak shwaajeel mbǝ sǝm mǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yool parmǝnǝ, ɓǝ baa mo nook kám kǝ leshap mǝ Naan ngurum mo, nɗǝǝn Lu mǝ Naan ɗeɗes nǝ kǝ nɗǝǝn lu mǝ gurum mo, koo puus ɗeɗangyii kas, nǝ Jesu a Kristi. ");
INSERT INTO sur_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kaaɗe nenseet nɗang Jesu mo ɗoom yaa ɓul, nɗǝǝn meeteer mǝnǝ mo, ɓǝ mee ɓǝlep yool nnaar mǝ nnen ɗe mo man pwoo mǝ nen Grik mo kǝ nen Yahudi ɗe mo kǝ tong nJerusalem, mbǝɗe nen ɗe mo man pwoo Grik nǝ mo sat nǝ, baa mo kǝ shìn mbiise Matkáa fur mo mɓut mbiise ɗe moo shwap shidaar-shidaar kas. ");
INSERT INTO sur_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aasǝ ɓǝ, jeplep ɗe kaapaat baavǝl nǝ mo pǝrep kuur mǝ nenseet nɗang Jesu mo jir, kǝ mo sat nǝnee, <<Baa nǝ ret kǝ mmun nook satpwoo mǝ Naan, mbǝkǝ mu ɗee ɗi ɓàk mbiise kas. ");
INSERT INTO sur_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mbǝ mǝnǝ, ɗyemnaa mo, wu bǝlǝp mee gurum mo pwoovǝl nnaar fuu, ɗe mo kǝ mǝse ɗeret, kǝ ɗe mo gam kǝ Riin Ɗeɓang, kǝ ɗe mo manshii mǝ mbii zak. Mbǝkǝ mun le mo tap ɗi kǝ ɗak shwap mbiise nǝ. ");
INSERT INTO sur_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɗang mun, mbǝ sekyeen kǝ ɗangnaan shidaar-shidaar kǝ satpwoo mǝ Naan.>> ");
INSERT INTO sur_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pwoo ɗe jeplep nǝ mo sat nǝ, ret nkuur mǝ nenseet nɗang Jesu nǝ mo jir. Aasǝ ɓǝ mo bǝlǝp Stivin, ɗewur gam kǝ shinzeen, kǝ Riin Ɗeɓang, kǝ Filip, kǝ Prokorus, kǝ Nikanor, kǝ Timoti, kǝ Parmenas, kǝ Nikolas ngu Antiyok, ɗe gyet wur kǝ piring mbǝ seyil nNaan mǝ nen Yahudi mo. ");
INSERT INTO sur_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mo jì kǝ nen ɗe mo kǝ bǝlǝp mo ntoom jeplep nǝ mo, ɓǝ mo ɗangnaan kǝzak mo lesar fur mo nkaa mo. ");
INSERT INTO sur_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pwoo Naan nǝ sekyeen, dǝm wul a ɗe nenseet nɗang Jesu ɗe mon nJerusalem mo ɓul ɗes hakyeng, kǝ pris mo ɗes mo shinzeen nJesu Kristi. ");
INSERT INTO sur_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stivin, ɗewur gam kǝ ɗeret kǝ ɓal mǝ Naan, wur cìn mbii lukshik mo, kǝ mbii aapwoo ɗenan mo nnaar gurum mo. ");
INSERT INTO sur_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ɗangɓe pak gurum mo ɗi, ɗe mo a mmee lu Naan ɗe mo kǝ pet a lu Naan mǝ nen Frimen mo. Nen ɗesǝ mo a nnen Yahudi ɗe mo pwat nyil nSairin, kǝ Alekzandriya, kǝ ngaar yil nSilisiya, kǝ mǝ yil Eshiya mo zak, mo yool kǝ pwoo mo, kǝ ɓeetshik nkaa Stivin. ");
INSERT INTO sur_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ɗang baa mo mak katɓal ɗe mon nɗar kǝn mo cin ɓeetshik ɗi kǝ Stivin kas, mbǝɗe wur leshap a shi ɗyen ɗe Riin mǝ Naan shin nwur. ");
INSERT INTO sur_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mo kar pak gurum mo a sǝsok, mbǝkǝ mmo sat ɗi nǝnee, <<Mu kǝlǝng Stivin satpwoo ɗebish nkaa Mosis, ɗang wur baa satpwoo ɗebuu nkaa Naan zak.>> ");
INSERT INTO sur_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pwoo ɗe mo sat nǝ láa ngurum nǝ mo mɓut, ɓǝ pak nen ɗǝnan-nan mo, kǝ pak nenkám Wàar Mosis mo. Mo yool kǝ tuup, mo dǝm yaa Stivin, ɓǝ mo jì kǝ wur ntoom mǝ kuur mǝ nenɓeetpwoo mo. ");
INSERT INTO sur_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kǝzak mo jì kǝ langtǝng mǝ ɗung mo, ɗe mo sat nǝnee, <<Gwar ɗesǝ wur leshap ɗebish nkaa Lu Naan ɗeɗes nǝ, kǝ nkaa Wàar Mosis shidaar-shidaar zak. ");
INSERT INTO sur_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mu kǝlǝng wur sat nǝ, Jesu ngu Nazaret mbǝ shirip Lu mǝ Naan ɗeɗes nǝ, kǝn nwur cǝǝr kǝ mbii ɗe muu loot kǝ cìn mo, ɗe gyet Mosis shin mo mmun.>> ");
INSERT INTO sur_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nen ɗe moo tong ɗi a pee ɓeetpwoo nǝ jir, mo ban yit fur mo nkaa Stivin, ɓǝ mo naa yit wur nǝ ɗee a koo yit ngulep mǝ Naan sǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pris ɗeɗes met jir nǝ wur tal pǝ Stivin nǝnee, <<Mbii ɗe moo sat nkaa gha sǝ, mo azeen aa?>> ");
INSERT INTO sur_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yaksǝ Stivin lap nǝnee, <<Ɗyemnaa mo, kǝ puun mo, wu lekom, kǝn nwun kǝlǝng mbii ɗe an mbǝ sat nǝ ɗi. Gyet Naan Ɗehai wur woo shin fin mpuun fun Abraham, ɓǝ wur kutɗi nyil mMesopotamiya, akuɗang wur dǝm tong nɗǝǝn yil nHaran. ");
INSERT INTO sur_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Naan sat nwur nǝnee, <A yool a yit yil fwaa, kǝ ɗang fwaa mo zak, kǝn nghan dǝm ɗi mmee yil ɗe an mbǝ kám nǝ ngha.> ");
INSERT INTO sur_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham yool yit yil nen Kaldiya mo, kǝn wur dǝm tong ɗi nɗǝǝn yil nHaran. Aɓwoon ɗe puun Abraham muut nyil nHaran, ɓǝ Naan jì kǝ Abraham nɗǝǝn yil ɗesǝ, ɗe wuu tong nɗǝǝn nǝ yaksǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ɗangɓǝ baa Naan shin rep pak yil nǝ Abraham, mbǝkǝ nǝ ɗee ɗi a mǝ káa wur, koo kaa mang shii mǝndong sǝ kas. Jir kǝsǝ, ɓǝ Naan cweerpwoo Abraham nǝ, wur mbǝ shin yil nǝ Abraham, kǝ nǝ ɗee a mbii sekop wur, dǝm wul kǝ ɗang wur ɗe mon njì mɓwoon wur zak. Koo ɗe gyet mɓít mǝnǝ, ɓǝ baa Abraham kǝ mee làa kas aku. ");
INSERT INTO sur_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gyet Naan sat zak nǝnee, <Dang Abraham mon mbǝ ɗee a mǝzep mo nɗǝǝn mee yil ɗecì. Nenyil mǝnǝ mon nle kǝ mmo cìn ɗak laatong zak, kǝ mon nle mmo ɗee a kǝrem mo, mbǝ ɓit kambil feer.> ");
INSERT INTO sur_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naan wur baa sat ɗyikye zak nǝnee, <An mbǝ tokɗyeel nnen ɗe mo le mo ɗee a kǝrem, ɗang aɓwoon mǝnǝ, ɓǝ an mbǝ pwat kǝ mo aku mɓut yil mǝnǝ, mbǝkǝ mmo jì seyil ɗi nghan nɗǝǝn pee ɗesǝ.> ");
INSERT INTO sur_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naan sat Abraham can-can, kǝ nǝ ɗee a Sǝmpwoo (alaama) mǝ pwoo ɗe Naan kǝ ten cweer nAbraham shi toom. Mbǝ mǝnǝ kaaɗe Abraham làa Aizik, ɓǝ wur can ɗyem fin nǝ nkaa puus nɗepwookun. Aizik can làa wur Jekop a kǝsǝ zak, kǝ Jekop can jep fin mo, ɗe mo a puun fun ɗe kaapaat baavǝl sǝ mo a kǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Puun fun ɗesǝ mo, mo cìn zuur kǝ Josep, yaksǝ mo seet kǝ wur sham nyil Ijip koo kǝrem sǝ. Ɗangɓe Naan ɗi ashak kǝ wur. ");
INSERT INTO sur_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Naan ɓam Josef mɓut jeel ɗe mo taa nkaa wur jir. Naan shin ɗeret nJosep, kǝ manshii mǝ cìn mbii ntoom Feero, mishkoom Ijip, ɗe nǝ le nwur ɗen Josep a ɗeɗes nkaa yil Ijip, kǝ nkaa lu fin zak. ");
INSERT INTO sur_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mee neen ɗeɗes taa nyil Ijip jir, kǝ yil nKeenan ɗe nǝ jì kǝ jeel ɗeɗes hakyeng, ɗe le baa puun fun mo kat mbiise kas. ");
INSERT INTO sur_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kaaɗe Jekop kǝlǝng nǝ, mbiise ɗi nyil Ijip, ɓǝ wur shee lep puun fun mo sham nyil Ijip nǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A nɗǝǝn sham mo nɗevǝl nyil Ijip nǝ, ɗang Josef woo shin nɗyemnǝǝn fin mo. A mpeemǝnǝ, ɓǝ Feero man ɗang mǝ Josep mo jir. ");
INSERT INTO sur_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Aɓwoon mǝnǝ, ɓǝ Josep lep kǝ mmo kàa pet puun fin Jekop kǝ nen wur mo jir. Nen ɗe mo pet mo shin sham nyil Ijip nǝ jir, mo wul laarpwoovǝl baapaat. ");
INSERT INTO sur_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nǝ le ɗang Jekop sham nyil Ijip, ɓǝ wur sham muut a nyil mǝnǝ, kǝzak puun fun mo jì murep a nyil Ijip zak. ");
INSERT INTO sur_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yaksǝ mo kok kúm mo mo kàa kǝ mo nyil nShekem, mbǝkǝ mo wum mo ɗi nɗǝǝn kǝcir ɗe gyet Abraham kǝ seet shi azurfa mo, nsar jep Hamor mo. ");
INSERT INTO sur_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","kaaɗe pee nǝ wul kus, mbǝkǝ nNaan gam mbii ɗe gyet wur kǝ ten cweer Abraham, ɓǝ nen fun mo kǝ ɓul ɗes nɗǝǝn yil Ijip nǝ hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nen Ijip mo lep mee mishkoom ɗepwoo nyil Ijip, ɗe baa wur man mee pwoo nkaa Josep kas. ");
INSERT INTO sur_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mishkoom ɗesǝ wur gwam puun fun mo, ɗang wur shin jeel mpuun fun mo, wur le kǝ mpuun fun mo fwo jep fur mo mbǝkǝ mmo murep ɗi. ");
INSERT INTO sur_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","A nɗǝǝn ɓit mǝnǝ, ɓǝ mo làa Mosis. Gyet Mosis a mee làa ɗeret naa zam. Puun wur mo kyeer wur nɗǝǝn lu mbǝ tar kun. ");
INSERT INTO sur_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɗang kaaɗe mo put dǝm le wur a tǝleng, ɓǝ reep Feero mang Mosis ɗyel, kǝ nwar kyeer wur koo làa fer sǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mo kám man mǝ nen Ijip mo mMosis jir, yaksǝ wur yool ɗee a mee ngwe ɗeɗes nɗǝǝn mbii ɗewur sat mo, kǝ mbii ɗewur cìn mo zak. ");
INSERT INTO sur_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Kaaɗe Mosis wul ɓit mo laarfeer, ɓǝ wur pan mputuup fin mbǝ dǝm naa ɗyemnǝǝn fin nen Isreil mo. ");
INSERT INTO sur_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yaksǝ wur táa naa mee ngu Ijip nkaa shinjeel mmee ngu Isreil. Ɓǝ Mosis dǝm ɓam ngu Isreil nǝ, kǝ nwur lap ɗi ngwar nǝ. Yaksǝ Mosis tu ngu Ijip nǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosis pan nǝ, nen fin mo mmanshii mǝnǝ nǝ, Naan mbǝ ɓam mo a shi sar fin. Ɗang baa mo manshii nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Daar nǝ, ɓǝ Mosis kat mee nen Isreil mo vǝl, pǝ lek nshak. Yaksǝ wur reɓet ɓen mo, kǝ wur sat mmo nǝnee, <Daa mo, wun a ɗyemnǝǝnshak, a mii le ɗang wuu lek nshak yii?> ");
INSERT INTO sur_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ɗangɓǝ gwar ɗewur nkaa shinjeel ngǝnǝǝn nǝ, bet Mosis shin baa aku, kǝ nwur sat mMosis nǝnee, <A wii le gha a mishkoom kǝ ngutokɗyeel nkaa mun ii? ");
INSERT INTO sur_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aa reɓet tu wen a kaaɗe doon a tu ngu Ijip sǝ mee?> ");
INSERT INTO sur_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kaaɗe Mosis kǝlǝng pwoo mǝnǝ, ɓǝ wur su ar yil Ijip, kǝ nwur dǝm tong ɗi nyil mMidiyan, koo mǝzep sǝ. A nɗǝǝn yil mMidiyan nǝ, ɓǝ Mosis làa jep ɗemish mo vǝl. ");
INSERT INTO sur_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Aɓwoon ɓit mo laarfeer, ɓǝ mee ngulep mǝ Naan jì woo shin mMosis, shi mbǝlem wus nkaa mee laalǝǝt a yil kus kǝ zuul Sinai. ");
INSERT INTO sur_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kaaɗe Mosis naa wus nǝ, ɓǝ nǝ aapwoo nwur, ɓǝ wur gyes dǝm ɗi kus rep laalǝǝt nǝ, mbǝkǝ nwur naa ɗi rǝrret, ɓǝ wur kǝlǝng ɗoo mǝ Daa, nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<A an a Naan mǝ puun fwaa mo, Naan mǝ Abraham, kǝ mǝ Aizik, kǝ mǝ Jekop.> Yaksǝ Mosis ɗaar, mbǝɗe kǝǝrmuut fes yaa wur zam, baa wur katɓal ɗewur mbǝ mak naa wus nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Daa Naan sat mMosis nǝnee, <A shwat kwoopshi ɗe mon nshii fwaa, mbǝɗe pee ɗe aa ɗar ɗi yaksǝ, nǝ a pee ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Azeen-zeen, an kǝn naajeel nen fen ɗe mon nyil Ijip, kǝn kǝlǝng gwan mo mo. Mbǝmǝnǝ kǝn sham, mbǝkǝ nghan ɓam mo ɗi zak. Mbǝ mǝnǝ, a jì kǝ nghan lep gha shindǝm nyil Ijip.> ");
INSERT INTO sur_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<Gyet nen Isreil mo cii Mosis, ɓǝ gyet mo sat nǝnee, <A wii le gha a mishkoom kǝ ngutokɗyeel nkaa mun yii?> A Mosis a ngwe ɗe gyet Naan lep wur, mbǝkǝ nwur ɗee a Taakyeen kǝ Nguɓam mǝ nen Isreil mo shi ɓam mǝ ngulep mǝ Naan ɗe gyet wur woo shin mMosis nɗǝǝn rep laalǝǝt a yil sǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A Mosis put kǝ nen Isreil mo nɗǝǝn yil Ijip, kǝzak gyet wur cìn mbii lukshik mo, kǝ mbii aapwoo mo nɗǝǝn yil Ijip nǝ, kǝ nɗǝǝn Am kuur Ɗenaat, kǝ a naaryil, mbǝ ɓit mo laarfeer zak. ");
INSERT INTO sur_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Gyet a Mosis sat nnen Isreil mo nǝnee, <Naan mbǝ yool lep mee ngusat pwoo Naan nwun, koo an sǝ, mɓut nnen fuu mo.> ");
INSERT INTO sur_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Gyet Mosis ɗi ashak kǝ kuur nen Isreil mo a naaryil, ashak kǝ puun fun mo, kǝ ngulep mǝ Naan ɗe gyet wur leshap kǝ Mosis nkaa nzuul Sinai. A mbǝɗe gyet Mosis kǝ kǝlǝngkar mǝ seen pǝ Naan ɗi shin mmun. ");
INSERT INTO sur_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Ɗangɓe gyet puun fun mo cii cìn mbii ɗe Mosis sat, kǝzak mo toklong shi Mosis, kǝ mo le mputuup fur mo mbǝ waa baa dǝm Ijip. ");
INSERT INTO sur_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mo sat Eeron nǝnee, <A kǝlem pak naan mo mmun, ɗe mon ntaa mmun akyeen. Mbǝɗǝ baa mu man mbii ɗe nǝ kat Mosis ɗe gyet wur put kǝ mun nɗǝǝn nyil Ijip kas.> ");
INSERT INTO sur_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A nɗǝǝn meeteer mǝnǝ mo, ɓǝ mo kǝlem mee laanǝng kǝ nǝ ɗee mmo, koo mee naan sǝ. Mo jì kǝ mbiizuum mo laanǝng nǝ, yaksǝ mo serǝɓet mǝ retnyit mbǝ naan ɗe mo kǝlem shi sar fur mo. ");
INSERT INTO sur_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mbǝ mǝnǝ ɓǝ Naan cǝǝr kǝɓwoon mmo, kǝzak wur le kǝ mmo seyil ɗi nzar mo, kǝ mbii ɗe aɗeng mo. Kaaɗe mo kǝ ten ran nɗǝǝn ɓǝǝt-haal mǝ nensatpwoo kǝ Naan mo nǝnee, <Wun nen Isreil mo, nɗǝǝn ɓit ɗelaarfeer sǝ mo a naaryil, ɓǝ baa gyet wu saa long mo, kǝ wus mbiizuum mo, a mbǝ an kas. ");
INSERT INTO sur_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɗang gyet wuu mang a Tent mǝ kùm Molek, wu mwaan kǝ nǝ, kǝ zar mǝ kùm fuu Refan. Wu kǝlem mbii ɗesǝ mo, mbǝkǝ nwun seyil ɗi mmo. Mbǝ mǝnǝ, ɓǝ an mbǝ le kǝ mmo dǝm kǝ wun jong-jong, ɗe dǝm ɗel yil ɗe aɓwoon mBabilon.> ");
INSERT INTO sur_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Gyet puun fun mo kǝ Tent mǝ langtǝng nǝ, Naan ɗi ashak kǝ mo a naaryil. Mo ɗak Tent mǝnǝ a nciit-nciit kǝ ɗe Naan shin mMosis naa. Mosis sat mmo tap ɗak a kǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aɓwoon mǝnǝ, ɓǝ puunkaam fun mo lap Tent mǝnǝ pǝ puun fur mo kǝ mmo mang Bìt mǝ Daa nǝ pan kaaɗe mo ɗel ashak kǝ Joshuwa nɗǝǝn yil ɗe Naan shin mmo. Naan ceen nenyil mǝnǝ mo, ɗe baa mo a nen Yahudi mo kas, a yit puun fun mo. Tent mǝnǝ war ɗi jì wul mɓít mǝ Devit. ");
INSERT INTO sur_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit kat ɗeret ntoom Naan, wur ɗang, mbǝkǝ nwur ɗyik mee peetong ɗi nNaan mǝ Jekop. ");
INSERT INTO sur_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ɗangɓe a Solomon yool ɗyiklu Naan nǝ. ");
INSERT INTO sur_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jir kǝsǝ, ɓǝ baa Daa Naan Ɗehai kǝ tong a nɗǝǝn lu ɗe gurum mo ɗyik kas. Pwoo ɗesǝ nǝ nciit kǝ pwoo ɗe gyet ngusatpwoo Naan ten sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<Naan sat nǝ, ɗengnaan nǝ a peetong fen, kǝ yil ɗesǝ nǝ a pee leshii fen zak. Wun nɗyik a mee lu ɗǝɗang nghan yii? Peeɗe an nnookɗi a nii? ");
INSERT INTO sur_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Baa a sar fen le mbii ɗesǝ mo jir kas aa?> ");
INSERT INTO sur_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<Wun nencinshik mo, ɗe pǝtuup fuu mo ɗee a koo mǝ nenkum mo sǝ. Wuu ɗee a komjoor mo mbǝ cíikǝlǝngpwoo mǝ Naan, kǝzak wu cii Riin Ɗeɓang shidaar-shidaar, kaaɗe gyet puun fuu mo kǝ cìn sǝ. Mbǝmǝnǝ wun a koo puun fuu mo gyet sǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gyet puun fuu mo shínjeel nnenkop pwoo Naan mo jir. Gyet mo twe nen ɗe moo leshap nkaa jì Ngwe ɗe ndǝre sǝ, ɗe yaksǝ ɓǝ a wun seet wur, ɗang a wun, wu tu wur zak. ");
INSERT INTO sur_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","A wun a nen ɗe wu lap Wàar mǝ Naan ɗewur shin nwun nsar nenlep mǝ Naan mo, ɗang baa wu cìn mbii ɗe Wàar nǝ mo sat kas.>> ");
INSERT INTO sur_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaaɗe nenɓeetpwoo nǝ mo kǝlǝng pwoo ɗe Stivin sat mmo, ɓǝ nǝ láa mmo mɓut ɗes hakyeng, yaksǝ mo ǝrep sar fur mo mbǝ tuup. ");
INSERT INTO sur_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mbǝɗǝ Stivin gam kǝ Riin Ɗeɓang, ɓǝ wur naapee kaa aɗeng, ɓǝ wur naa Ɗehai mǝ Naan, kǝ Daa Jesu kǝ ɗar nsarse kǝ Naan zak. ");
INSERT INTO sur_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ɓǝ Stivin sat nǝnee, <<Wu naa mo wang ɗengnaan, kǝzak Làa kǝ Gurum kǝ ɗar nsarse mǝ Naan.>> ");
INSERT INTO sur_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɗangɓe gurum nǝ mo lep or shi ɗoo ɗeɗes, kǝ mmo duur kom fur mo shi sar fur mo, ɓǝ mo yool su jì taa nkaa Stivin. ");
INSERT INTO sur_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mo dul wur put mɓwoon pee nkaam nǝ, ɓǝ mo car wur shi gyǝk ɓǝ wur muut. Nen ɗe mo car Stivin nǝ mo, shwat nlǝr fur mo, mo le pǝ mee zǝlang ɗe moo pet sǝm wur a Sool. ");
INSERT INTO sur_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kaaɗe mon nkaa car Stivin, ɓǝ wur nkaa ɗangnaan nǝnee, <<Daa Jesu, a lap seen fen.>> ");
INSERT INTO sur_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yaksǝ wur kurum mfurum, ɓǝ wur petpee shi ɗoo ɗeɗes nǝnee, <<Daa Naan, a fwoo shikbish ɗesǝ nǝ mmo.>> Kaaɗe wur sat pwoo mǝnǝ, ɓǝ wur muut. ");
INSERT INTO sur_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nǝ fes ret nSool nyit zam, mbǝɗe mo tu Stivin. Parpuus mǝnǝ, ɓǝ jeel ɗeɗes nǝ táa nkaa kuur mǝ nenseet nɗang Jesu ɗe moo tong nJerusalem. Mbǝ jeel nǝ, ɓǝ mo rangkáa jir, dǝm nɗǝǝn yil nJudiya, kǝ Samariya, tǝng ɗee a jeplep nǝ mo ɗe nJerusalem ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pak nen ɗe mo kǝǝr Naan, mo wum Stivin, kǝzak mo yém mmaap mbǝ muut wur nǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ɗangɓe Sool shínjeel nenseet nɗang Jesu nǝ mo ɗes hakyeng. Wur dǝm ɗel shitul-shitul, kǝn nwur yak daas mo, kǝ shurep mo, dǝm shoot mo nɗǝǝn lushoot. ");
INSERT INTO sur_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nen ɗe mo rangkáa nǝ mo. Mo dǝm kop pwoo Naan ngurum mo koo a pee ɗeɗangyii ɗe mo dǝm ɗi. ");
INSERT INTO sur_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip dǝm mmee pee kaam ɗe nen nSamariya, wur nkaa leshap ngurum mo nkaa Kristi mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kaaɗe kuur mǝ gurum nǝ mo kǝlǝng, ɗang mo naa mbii lukshik ɗe Filip pǝ cìn mo zak, ɓǝ mo lekom, kǝzak mo lepan fur mo nkaa mbii ɗewur sat nǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Riin ɗebish mo lep or ɗeɗes, kǝzak mo pwat mɓut ngurum mo ɗes. Mo bar gurum mo ɗes ɗe shik mo mo fii, kǝ kǝɓel mo. ");
INSERT INTO sur_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mbǝ mǝnǝ, ɓǝ gurum mo kat retnyit ɗes nɗǝǝn pee nkaam mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mee gwar ɗewur ɗi nɗǝǝn pee nkaam nǝ, ɗe sǝm wur a Simon, ɗe mbǝ ɓit mo ɗes, ɓǝ wur kǝcin mulak, kǝzak wur kǝcin mbii aapwoo mo a yit mǝ nen Samariya mo. Wur cutzung nǝ, ɗyin a mee ngwe ɗeɗes. ");
INSERT INTO sur_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gurum mo jir mo kǝ lepyit nkaa wur, yool nɗeɗyeen mo, dǝm wul nɗenannan mo, ɗang moo sat nǝ, gwar ɗesǝ wur aa ɓal mǝ Naan ɗe moo pet a iiko Ɗeɗes Met ");
INSERT INTO sur_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Moo lepyit nkaa wur, a mbǝɗe ɓit mo ɗes, ɓǝ wur cìn mbii aapwoo mo a yit mo mo shi mulak nǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ɗang kaaɗe mo shinzeen mpwoo ɗeret ɗe Filip sat mmo, nkaa mulki mǝ Naan, kǝ nkaa Jesu Kristi zak, ɓǝ mo cìn baptisma ndaas mo, kǝ shurep mo ɗe mo shinzeen. ");
INSERT INTO sur_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon shikáa fin shinzeen zak, ɓǝ mo cìn baptisma nwur. Aɓwoon mǝnǝ, ɓǝ wur dǝm nɗang Filip, ɗang nǝ aapwoo nwur mbǝ mbii lukshik mo, kǝ ɗak ɗǝnan-nan ɗewur naa Filip kǝcin mo. ");
INSERT INTO sur_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kaaɗe jeplep ɗe moo tong nJerusalem mo kǝlǝng nǝ, nen Samariya mo kǝ lappwoo Naan, ɓǝ mo lep Pita kǝ Joon dǝm pǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kaaɗe Pita kǝ Joon mo dǝm wul, ɓǝ mo ɗangnaan nkaa nen ɗe mo shinzeen nǝ. Mbǝkǝ nNaan shin Riin Ɗeɓang ɗe mmo. ");
INSERT INTO sur_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mbǝɗǝ baa Riin Ɗeɓang kǝ sham nkaa memee nɗǝǝn mo kas. Mo kǝ cìn a baptisma mmo nɗǝǝn sǝm mǝ Daa Jesu ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita kǝ Joon, mo lesar fur mo nkaa mo, ɓǝ Naan shin Riin Ɗeɓang ngurum nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kaaɗe Simon naa nǝ, moo shin Riin Ɗeɓang nǝ nnen shinzeen nǝ mo, a mbǝɗe jeplep nǝ mo lesar fur mo nkaa mo, ɓǝ wur shin shool mPita kǝ Joon, ɗang wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","<<Wu shin ɓal mǝnǝ nghan zak, mbǝkǝ koo wii ɗe wen lesar fen nkaa wur, ɓǝ wur nkat Riin Ɗeɓang nǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ɗangɓǝ Pita sat nSimon nǝnee, <<Waa kǝ shool fwaa nǝ, wun nɗel nwus. Mbǝɗǝ aa pan nǝ, a mmak seet mbiizuum mǝ Naan a shi shool. ");
INSERT INTO sur_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Baa mee mbii ɓàl gha kǝ mun mɓut ɗak fun ɗesǝ nǝ kas mbǝɗe baa pǝtuup fwa nǝ nɗere a kǝkyeen nNaan kas. ");
INSERT INTO sur_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","A tuwap mbǝ pan fwaa ɗebish nǝ, kǝzak a ɗang Daa Naan, mbǝkǝ nNaan fwoo shikbish mǝ pan kǝ pǝtuup fwaa ɗebish nǝ ɗi ngha. ");
INSERT INTO sur_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mbǝɗǝ wen naa, aa gam kǝ zuur ɗebish, ɗang aa ɗee a ɗe ɓuɓwoot nɗǝǝn shikbish.>> ");
INSERT INTO sur_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon sat mPita kǝ Joon nǝnee, <<Kuzuk, wu ɗang pǝ Daa Naan, mbǝkǝ taji memee nɗǝǝn mbii ɗe wu sat sǝ mo kat an kas.>> ");
INSERT INTO sur_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aɓwoon ɗe Pita kǝ Joon mo kǝ satpwoo nkaa Jesu, ɗang mo leshap Naan zak, ɓǝ kaaɗe mo a ar kàa nJerusalem, ɓǝ mo taa kop pwoo ɗeret nǝ nɗǝǝn jepyil mo ɗes, ɗe mo nSamariya. ");
INSERT INTO sur_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mee ngulep mǝ Naan sat mFilip nǝnee, <<A yool a sham nkor ngyeen a ar ɗe nǝ yool nJerusalem dǝm wul nGaza, ɗe nǝ a naaryil.>> ");
INSERT INTO sur_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Wur yool seet, ɓǝ wur taakáat kǝ mee ngu Itiyopiya ɗewur a meermuut. Wur a mee ngwe ɗeɗes ɗewur tap kǝ long mǝ mishkoom ɗe mat, Kandes mǝ yil Itiyopiya. Gwar ɗesǝ wur waa a nJerusalem mbǝ seyil nNaan. ");
INSERT INTO sur_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kaaɗe wur a ar baa waa, ɓǝ wur kǝ tong nɗǝǝn mbiilang, wur nkaa tang ɓǝǝt-haal mǝ ngusatpwoo mǝ Naan Aizaya. ");
INSERT INTO sur_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɓǝ Riin Ɗeɓang sat mFilip nǝnee, <<A dǝm kus kǝ mbiilang ɗesǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip su dǝm kus kǝ mbiilang nǝ, ɓǝ wur kǝlǝng gwar nǝ nkaa tang ɓǝǝt-haal mǝ ngusatpwoo mǝ Naan Aizaya. Yaksǝ Filip tal pǝ gwar nǝ nǝnee, <<A manshii mǝ mbii ɗe gha nkaa tang nǝ aa?>> ");
INSERT INTO sur_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Gwar nǝ lap nǝnee, <<Cirang ɗang an mbǝ mmanshii mǝnǝ ɗi ii? Kat baa a mee gurum kámshii mǝnǝ nghan kas ii?>> Gwar nǝ sat mFilip kàa tong ashak kǝ wur. ");
INSERT INTO sur_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A pwoo ɗewur nkaa tang nǝ nɗǝǝn ɓǝǝt-haal nǝ nɗesǝ, ɗe nǝ sat nǝnee, <<Wur a koo tǝm ɗe mo kǝ dǝm kǝnǝ, mpee saa sǝ. Koo tǝm ɗe ɗok tǝtǝk ntoom mǝ ngusaa shweep nǝ sǝ, Wur ɗok tǝtǝk a kǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mbǝɗǝ wur sham kǝ káa fin, ɓǝ baa mo tokɗyeel nwur nkaa zeen kas. A wii mmak yool leshap nkaa ɗang wur mo ii? Mbǝɗǝ mo kǝ mang seen wur nɗǝǝn yil nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɓǝ ngu Itiyopiya nǝ wur tal pǝ Filip nǝnee, <<A sat nghan. Gyet ngusatpwoo mǝ Naan ɗesǝ wur leshap nǝ a nkaa wii? Wur leshap nǝ a nkaa shin aa? Koo a mee ngwe ɗecì yii?>> ");
INSERT INTO sur_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yaksǝ Filip ɗoom leshap ɗeret nkaa Jesu, shi pwoo ɗe gwar nǝ kǝ tang nǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kaaɗe mon mwaan a ar nǝ, ɓǝ mo jì wul mpee ɗe am ɗi, ɓǝ ngu Itiyopiya nǝ wur sat mFilip nǝnee, <<A naa am sǝsǝ! A mii ncíi kǝ nghan cìn baptisma nghan ii?>> ");
INSERT INTO sur_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip lap nǝnee, <<Katɗang a shinzeen nJesu shi pǝtuup mǝndong azeen-zeen, ɓǝ mon ncìn baptisma ngha. Ngu Itiyopiya nǝ wur sat nǝ, Nshinzeen nǝ Jesu Kristi wur a Làa mǝ Naan azeen-zeen.>> ");
INSERT INTO sur_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yaksǝ gwar nǝ wur le mbiilang nǝ ɗar. Ɓǝ Filip kǝ gwar ɗe nǝ, mo sham nɗǝǝn am nǝ dukvǝl, ɓǝ Filip cìn baptisma ngwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kaaɗe mo kàa pwat mɓut am nǝ, ɓǝ Riin mǝ Daa, mang Filip dǝm kǝ wur mmee mpee. Baa ngu Itiyopiya nǝ wur kutɗi kǝ naa Filip zak kas. Yaksǝ wur sekyeen kǝ mwaan fin, kǝzak wur gam kǝ retnyit. ");
INSERT INTO sur_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Gurum mo naa Filip nɗǝǝn yil Azotus. Wur dǝm shipee-shipee nɗǝǝn pee nkaam nǝ mo jir, mbǝ kop pwoo ɗeret nǝ, dǝm wul nSizariya. ");
INSERT INTO sur_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sool sekyeen kǝ shinjeel nnenseet nɗang Jesu mo, wur tang ar mbǝ twe mo. Aasǝ ɓǝ, wur dǝm pǝ pris ɗeɗes met jir nǝ. ");
INSERT INTO sur_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yaksǝ Sool ɗang pǝ pris ɗeɗes nǝ, mbǝkǝ nwur shin lep a rǝran mmo ɗewur ndǝm kǝ mmo nLu mǝ Naan mo, ɗe mo nDamaskus, mbǝkǝ katɗang wur kat nen ɗe moo dǝm nɗang ar Jesu, koo daas mo kǝ shurep mo, ɓǝ wur yak mo jì kǝ mo nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kaaɗe wur jì wul kus kǝ Damaskus, ɓǝ nnen mman, ɓǝ mee peeɓang tong aɗeng sham ɓangpee ɗewur ɗe. ");
INSERT INTO sur_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yaksǝ wur taa nyil, kǝzak wur kǝlǝng mee ɗoo kǝ sat nǝnee, <<Sool, Sool! A mii le ɗang aa shinjeel nghan yii?>> ");
INSERT INTO sur_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yaksǝ Sool tal nǝnee, <<A gha a wii Daa?>> Ɗoo nǝ lap nǝnee, <<A an Jesu, ɗe gha nkaa shinjeel nghan. ");
INSERT INTO sur_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A yool a ɗel nɗǝǝn pee nkaam nǝ, ɓǝ mon nsat nghan mbii ɗe nǝ a tǝng gha ncìn.>> ");
INSERT INTO sur_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nen ɗe mon mwaan nǝ ashak kǝ wur mo ɗar tǝtǝk, baa mo le mee shap kas, mo kǝlǝng ɗoo nǝ, ɗang baa mo naa nguleshap nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sool yool ɗar atǝng, ɓǝ wur wang yit fin, ɗang, baa wur mak naapee kas. Mbǝ mǝnǝ ɓǝ mo yaa sar nwur, mo ɗel kǝ wur nDamaskus. ");
INSERT INTO sur_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mbǝ teer mo kun, ɓǝ baa wur mak naapee kas, kǝzak baa wur se mee mbiise, koo shwaa mee mbii kas zak. ");
INSERT INTO sur_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mee nguseet nɗang Jesu ɗi nDamaskus, ɗe moo pet wur a Ananiyas. Daa sat Ananiyas nɗǝǝn suun nǝnee, <<Ananiyas!>> Yaksǝ wur lap nǝnee, <<An sǝsǝ Daa.>> ");
INSERT INTO sur_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Daa sat nwur nǝnee, <<A yool a dǝm a ar ɗesǝ, ɗe moo pet a Sham ndǝr-ndǝr, ɓǝ a tal mee gwar ɗe moo pet sǝm wur a Sool, wur a ngu Tarsus. Wur ntul Judas. Yaksǝ ɓǝ wur nkaa ɗangnaan. ");
INSERT INTO sur_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nɗǝǝn suun wur, ɓǝ wur naa mee gwar ɗe moo pet sǝm wur a Ananiyas, wur jì ɗel, ɗang wur lesar fin nkaa wur, mbǝkǝ nyit fin mo baa naapee ɗi zak.>> ");
INSERT INTO sur_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ɗangɓe Ananiyas lap nǝnee, <<Daa, gurum mo ɗes mo kǝ leshap nghan, nkaa niyang ɗe gwar ɗesǝ wur kǝcin nnen fwaa ɗe mon nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kǝzak wur jì mpee ɗesǝ nDamaskus, shipee ɗe pris ɗenan mo shin nwur, mbǝkǝ nwur yak nen ɗe mo shinzeen nɗǝǝn sǝm fwaa jir.>> ");
INSERT INTO sur_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ɗangɓe Daa lap wur nǝnee, <<A yool a dǝm, mbǝɗe an kǝn bǝlǝp wur, mbǝkǝ nwur cìn ɗak ɗi nghan. Wur mbǝ le kǝn nnen ɗe baa mo a nen Yahudi mo kas, kǝ mishkoom mo, kǝ nnen Yahudi mo man sǝm fen zak. ");
INSERT INTO sur_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","An mbǝ kám nwur jeel ɗe nwur mbǝ shwaa mo mbǝ sǝm fen.>> ");
INSERT INTO sur_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiyas yool dǝm ɗel nɗǝǝn lu Judas nǝ. Wur lesar fin mo nkaa Sool, ɗang wur sat nǝnee, <<Ɗyemnaa Sool, Daa Jesu ɗewur woo shin fin ngha, kaaɗe gha a ar jì mpee ɗesǝ, a wur lep an, mbǝkǝ nghan baa a naapee ɗi zak. Kǝ mmo gam gha shi Riin Ɗeɓang zak.>> ");
INSERT INTO sur_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Abet-abet ɓerep mee mbii mo koo feel mǝ pupwap sǝ, mo pwat nyit Sool, mo sham ɗong nyil, ɓǝ yit wur mo cin naapee. Yaksǝ wur yool ɗar atǝng, ɓǝ mo cìn baptisma nwur. ");
INSERT INTO sur_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aɓwoon ɗewur kǝ se mbiise, ɓǝ wur baa katɓal zak. Sool tong ashak kǝ nenseet nɗang Jesu ɗe mon nDamaskus, mbǝ meeteer mo ruk. ");
INSERT INTO sur_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Abet-abet ɓǝ wur dǝm nɗǝǝn lu mǝ Naan mo ɓǝ wur ɗoom sat nǝ, Jesu a Làa Naan. ");
INSERT INTO sur_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nen ɗe mo kǝlǝng wur jir, ɓǝ nǝ aapwoo mmo, ɗang mo tal nǝnee, <<Baa a gwar ɗewur twe nen ɗe mo shinzeen nɗǝǝn sǝm mǝ Jesu, nɗǝǝn Jerusalem sǝ nɗesǝ kas ee? Wur jì mpee ɗesǝ a mbǝkǝ nwur yak mo dǝm kǝ mo a ɓuɓwoot pǝ pris ɗǝnan-nan mo ɗi zak kas aa?>> ");
INSERT INTO sur_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ɗangɓe Sool katɓal, kǝn nwur leshap ɗi ɓal-ɓal, ɗe nǝ kám agaak nǝ, Jesu wur a Kristi azeen-zeen. Pwoo ɗewur sat nǝ mo, nǝ daampee nnen Yahudi ɗe moo tong nDamaskus. ");
INSERT INTO sur_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Aɓwoon meeteer mo ɗes, ɓǝ nen Yahudi mo ɓeetpwoo kǝ sut, mbǝkǝ mmo tu Sool ɗi. ");
INSERT INTO sur_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ɗang pwoo ɗe mo ɓwoot nǝ taa nkom Sool. Mo tap pwoo lu ɗe mon mpee nkaam nǝ mpar kǝ puus, mbǝkǝ mmo tu Sool ɗe. ");
INSERT INTO sur_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ɗangɓe nen shinzeen ɗe mo dǝm ɗang Sool nǝ mo, mo mang wur nɗǝǝn kǝci mpar, ɓǝ mo ɓwet wur sham mɓwoon pee nkaam nǝ nɗǝǝn mee fung. ");
INSERT INTO sur_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kaaɗe Sool wul nJerusalem, ɓǝ wur tang ar ɗewur mbǝ ɓàlkáa wur ɗi ashak kǝ nenseet nɗang Jesu mo. Ɗangɓe mo jir, mo kǝǝr wur, mbǝɗe baa mo shinzeen nǝ, wur kǝ ɗee a nguseet nɗang Jesu kas. ");
INSERT INTO sur_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yaksǝ a Barnabas jì kǝ wur pǝ jeplep nǝ mo ɗi, kǝn nwur leshap ngurum nǝ mo, kaaɗe Sool kǝ naa Daa Jesu a ar, nǝ, Daa Jesu kǝ leshap kǝ Sool. Barnabas leshap mmo nkaa sat pwoo kǝ Naan nɗǝǝn Jesu agaak, ɗe Sool kǝ cìn nɗǝǝn Damaskus, baa ashak kǝ mee kǝǝrmuut kas, koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aasǝ ɓǝ wur tong ashak kǝ mo. Kǝzak wur mwaan dǝm shipee-shipee nɗǝǝn Jerusalem, kǝzak wur satpwoo kǝ Naan ɓalɓal nɗǝǝn sǝm mǝ Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wur naa nleshap nǝ, kǝ ɓeetshik kǝ nen Yahudi ɗe moo kǝlǝng pwoo kǝ nen Helene mo, ɗe nǝ le kǝ mmo tang ar ɗe mon ntu wur ɗi. ");
INSERT INTO sur_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jir aasǝ kaaɗe nenseet nɗang Jesu mo kǝlǝng mǝnǝ, ɓǝ mo dǝm kǝ Sool nSizariya, kǝ mo lep wur shindǝm nTarsus. ");
INSERT INTO sur_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Aɓwoon mǝnǝ, ɓǝ nenseet nɗang Jesu ɗe mon nJudiya, kǝ Galili, kǝ Samariya, mo tongriyang nɗǝǝn meeteer mǝnǝ mo. Shi ɓam mǝ Riin Ɗeɓang, ɓǝ nenseet nɗang Jesu nǝ mo katɓal, ɗang mo ɓul zak. Moo mwaan nɗǝǝn kǝǝr mǝ Naan, ɗang moo shin ɗeɗes nNaan zak. ");
INSERT INTO sur_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita mwaan shipee-shipee jir, ɓǝ wur jì wul pǝ nen Naan mo, ɗe mo kǝ tong nLidda. ");
INSERT INTO sur_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yaksǝ wur kat mee gwar ɗi mpee nkaam mǝnǝ, ɗe mo kǝ pet sǝm wur a Aniyas, ɗewur kǝ mee shwal ɗe nǝ fii shik wur, ɗe baa wur mak yool a peesaam kas, mbǝ ɓit mo pwookun. ");
INSERT INTO sur_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita sat nwur nǝnee, <<Aniyas, Jesu Kristi wur bar gha. A yool a ciɓet mbiisaam fwaa.>> Abet-abet, ɓǝ wur yool. ");
INSERT INTO sur_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kaaɗe jir nen ɗe mo kǝ tong nɗǝǝn Lidda kǝ Sharon mo naa wur bar, ɓǝ mo cǝǝr kǝ pǝtuup fur mo, ɗe nǝ le mmo shinzeen nDaa. ");
INSERT INTO sur_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mee mat seet nɗang Jesu war ɗi nɗǝǝn yil nJoppa, ɗe sǝm war a Tabita, sǝm war nǝ shi liispwoo mǝ nen Heleni mo a Dokas, ɗe shii kǝnǝ a <<Tap.>> Mat ɗesǝ war kǝ cìn ɗak ɗeret mo, ɗang war kǝ ɓam nenjeel mo zak. ");
INSERT INTO sur_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nɗǝǝn meeteer mǝnǝ mo, ɓǝ mee shwal yaa war, ɗe nǝ le nwar muut. Kaaɗe mo vwang kúm war, ɓǝ mo le nɗǝǝn mee luɗeng. ");
INSERT INTO sur_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda kus kǝ Joppa, ɓǝ kaaɗe nenseet nɗang Jesu mo kǝlǝng nǝ Pita ɗi nJoppa, ɓǝ mo lep gurum mo vǝl shindǝm pǝ wur ɗe, mbǝkǝ mmo ɗang ɗi pǝ wur, kǝ nwur jì pǝ mo ɗi kǝkǝlak, taji wur taa ɗee bir kas. ");
INSERT INTO sur_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita yool dǝm ashak kǝ mo, kaaɗe mo jì wul, ɓǝ mo kàa kǝ wur nɗǝǝn luɗeng nǝ. A pee ɗe matkaa mo jì ɗirang pǝ wur ɗi. Mo nkaa wal, ɗang mo kám nlǝr mo, kǝ leelep mo, ɗe dǝ Tabita kǝ raa mmatkáa nǝ mo, ɓǝ war kutɗi seen. ");
INSERT INTO sur_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ɗangɓe Pita le mmo pwat a tool jir, ɓǝ wur kurum mfurum, kǝ nwur ɗangnaan ɗi. Yaksǝ wur cǝǝr pǝ kúm nǝ ɗe, wur sat nǝnee, <<Tabita yi yool.>> Yaksǝ war wang yit fer. Kaaɗe war naa Pita, ɓǝ war yool tong atǝng. ");
INSERT INTO sur_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ɓǝ wur yaa sar nwar, ɗang wur ɗiyeep war ɗar atǝng. Ɓǝ wur pǝrep nen mǝ Naan nǝ mo, kǝ matkaa nǝ mo, ɓǝ wur shin Tabita mo kǝ seen. ");
INSERT INTO sur_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbii ɗesǝ nǝ ɗee a ɗemǝman nɗǝǝn yil nJoppa jir, ɓǝ gurum mo ɗes mo shinzeen nDaa. ");
INSERT INTO sur_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita tong ashak kǝ mee nguɗak shim, ɗe mo kǝ pet sǝm wur a Simon, mbǝ teer mo ɗes ɗe nJoppa nǝ. ");
INSERT INTO sur_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mee gwar ɗi nɗǝǝn Sizariya, ɗe sǝm wur a Konilus, wur a mee ngwe ɗeɗes, ɗewur kǝ tap kǝ shiitoon mo kambil mǝndong, ɗe mǝ yil Itali. ");
INSERT INTO sur_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wur a mee ngwe ɗewur le pǝtuup fin nkaa Naan, kǝzak wur kǝǝr Naan ashak kǝ nenlu fin mo jir. Wur shin zuum ngurum mo ɗes, kǝ wur kǝ naa ndang Naan shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Parmeeci sǝ, koo kun ɗe mǝ puus sǝ, ɓǝ nɗǝǝn suun, ɓǝ wur naa ngulep kǝ Naan agaak, ɗang ngulep nǝ sat nwur nǝnee, <<Konilus,>> ");
INSERT INTO sur_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ɓǝ Konilus naa ngulep nǝ shi yit kǝǝrmuut, ɓǝ wur sat nǝnee, <<A mii yii Daa?>> Ngulep mǝ Naan sat nKonilus nǝnee, <<Naan kǝ lap ɗang fwaa mo, kǝ mbiizuum ɗe aa shin nenjeel mo, ɓǝ mo kǝkàa wul pǝ Naan ɗi aɗeng, ɗang mo ɗee a mbii ɗe Naan pan gha zak. ");
INSERT INTO sur_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mbǝmǝnǝ, ɓǝ a lep mee gurum mo dǝm nJoppa, mbǝkǝ mmo dǝm pet mee gwar ɗe mo kǝ pet sǝm wur a Simon Pita, jì ntul fwaa. ");
INSERT INTO sur_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wur tong a nlu Simon nguɗak shim, ɗe lu wur nǝ kus kǝ pwoo Am kuur sǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kaaɗe ngulep mǝ Naan leshap kǝ Konilus, ɓǝ Konilus pet kǝrem fin mo vǝl kǝ mee shiitoon, ɗewur a ngwe ɗe ndǝre mɓut nen ɗe mo kǝ cìn ɗak ntul fin shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aɓwoon ɗewur sat mmo mbii ɗe nǝ cìn jir, ɓǝ wur lep mo dǝm nJoppa. ");
INSERT INTO sur_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Daar nǝ, ɓǝ mo yaa ar, ɓǝ mo jì wul kus kǝ pee nkaam nǝ. Pita kǝkàa nluɗeng mbǝ ɗangnaan, koo puus a naar sǝ. ");
INSERT INTO sur_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Neenláa nwur, ɗang wur reɓet mee mbii ɗewur nse. Kaaɗe mo kutɗi nkaa cet mbiise nǝ, ɓǝ Pita cin mee suun. ");
INSERT INTO sur_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɗee wur naa ɗengnaan nǝ wang, ɗang mee mbii tong aɗeng sham koo haal ɗeɗes sǝ. Mo yaa sham kǝnǝ nyil shi kwang nǝ mo feer. ");
INSERT INTO sur_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nɗǝǝn nǝ, ɓǝ koo a luwaa ɗeɗangyii, ɗe mo kǝ mwaan shi shii feer mo, kǝ ɗe mo kǝ fee shi ɓut mo, kǝ nyer ɗe mo kǝ yool ncáap mo ɗiɓut jir. ");
INSERT INTO sur_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɓǝ Pita kǝlǝng mee ɗoo kǝ sat nǝnee, <<Pita a yool, a can a se.>> ");
INSERT INTO sur_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ɗangɓe Pita lap nǝnee, <<Hai Daa! Baa wen kǝn cam se mee luwaa ɗebuu, koo ɗe baa nǝ ret kǝ ngu Yahudi se kas.>> ");
INSERT INTO sur_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pita waa cin kǝlǝng ɗoo nǝ ɗe zak, ɗe nǝ sat nǝnee, <<Mbii ɗe Naan kǝ le a ɗeɓang, ɓǝ taji waa a le a ɗebuu kas.>> ");
INSERT INTO sur_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mo cìn a kǝsǝ dǝm wul ar kun, ɓǝ mo waa baakàa kǝ haal nǝ aɗeng. ");
INSERT INTO sur_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kaaɗe Pita nkaa panshii mǝ suun nǝ, ɓǝ nen ɗe Konilus lep mo sǝ, mo kǝ ten yap lu mǝ Simon nǝ mo kat, ɓǝ mo jì ɗar mpwoo lu nǝ. ");
INSERT INTO sur_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mo petpee, ɓǝ mo tal nǝnee, <<Kyet gwar ɗe mo kǝ pet wur a Simon Pita sǝ, kǝ tong a nlu ɗesǝ ee?>> ");
INSERT INTO sur_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kaaɗe Pita kutɗi nkaa panshii mǝ suun ɗesǝ nǝ, ɓǝ Riin mǝ Naan sat nwur nǝnee, <<A naa mee gurum mo kun, mo pǝ yap gha. ");
INSERT INTO sur_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","A yool, a sham, kǝ nghan seet ashak kǝ mo, baa a shi mee kyetwo kas, mbǝɗe a an lep mo.>> ");
INSERT INTO sur_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ɓǝ Pita sham pǝ nen nǝ mo ɗi, ɓǝ wur sat mmo nǝnee, <<An sǝ, a an a ngwe ɗe wun pǝ yap nǝ. Wu jì a mbǝ miyi?>> ");
INSERT INTO sur_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mo lap nǝnee, <<A mee ngwe ɗeɗes nkaa shiitoon mo, ɗe mo kǝ pet sǝm wur a Konilus ɗewur a mee ngwe ɗe ndǝre, ngukǝǝr Naan. Ɗe nen Yahudi mo jir mo kǝ kwoop wur. A mee ngulep mǝ Naan ɗeɓang jì sat nwur nǝ, wur lep mo pet gha, kǝ nghan dǝm ɗi ntul fin, mbǝkǝ nwur kǝlǝng mbii ɗe gha mbǝ sat nǝ ɗi nwur.>> ");
INSERT INTO sur_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ɗel kǝ des ɗekun nǝ mo nlu, mbǝkǝ mmo teer ɗi. Daar nǝ, ɓǝ Pita yool seet ashak kǝ mo. Pak nenseet nɗang Jesu ɗe mon nJoppa mo seet ashak kǝ wur. ");
INSERT INTO sur_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Daar nǝ, ɓǝ mo dǝm wul nSizariya. Konilus nkaa ɗarnaa mo. Wur kǝ ten pǝrep ɗang fin mo, kǝ shaar fin mo, mo kuur ashak ɗes. ");
INSERT INTO sur_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kaaɗe Pita a ar ɗel nɗǝǝn lu nǝ, ɓǝ Konilus kaat wur, ɓǝ wur taa mPita ntoom, mbǝ seeyil nwur. ");
INSERT INTO sur_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ɗangɓe Pita ɗiyeep Konilus, ɓǝ wur sat nǝnee, <<A yool atǝng, wen shikáa fen, an a gurum koo waa sǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita nkaa leshap kǝ Konilus, ɓǝ kaaɗe wur ɗel, nɗǝǝn lu nǝ, ɓǝ wur kat gurum mo kǝ kuur ashak ɗes. ");
INSERT INTO sur_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita sat mmo nǝnee, <<Wun shikáa fuu wu man nǝ, baa nǝ ndǝre kǝ ngu Yahudi ɓalkaa fin ashak kǝ mee soon ɗecì mo, koo wur jì pǝ mo ɗi kas. Ɗangɓe Naan kǝ kám nghan, kǝ taji wen mpet mee gurum a ɗebuu, koo ɗebish kas. ");
INSERT INTO sur_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mbǝ mǝnǝ, kaaɗe wu lep mo pet an sǝ, ɓǝ wen jì pǝ wun ɗi, baa wen cii kas. Mbǝmǝnǝ wen reɓet kǝlǝng mbii ɗe nǝ le kǝ nwun pet an nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilus sat nǝnee, <<Nǝ kus aa teer mo feer cicinsǝ, nciit kǝ pee kǝsǝ, ɓǝ nkaa ndang Naan nkun mǝ puus nɗǝǝn lu fen. Ɓǝ nnaa mee gwar sǝ, ɗe nlǝr wur mo piyaa pet-pet, wur jì ɗar a kyeen fen. ");
INSERT INTO sur_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yaksǝ wur sat nǝnee, Konilus! Naan kǝ lap ɗang fwaa, kǝ mbiizuum ɗe aa shin nenjeel mo sǝ, mo ɗee a mbii ɗe Naan wur pan gha zak. ");
INSERT INTO sur_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mbǝ mǝnǝ a lep-lep dǝm nJoppa, kǝ mo dǝm pet mee gwar ɗe sǝm wur a Simon Pita, wur kǝ tong a ntul mǝ Simon nguɗak shim, ɗe lu wur nǝ kus kǝ pwoo am kuur sǝ. ");
INSERT INTO sur_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Abet-abet ɓǝ wen nlep-lep shindǝm pǝ gha ɗi. Nǝ ret zam kaaɗe a jì mpee ɗesǝ. Mun sǝ jir ntoom mǝ Naan yaksǝ, mbǝkǝ mmun kǝlǝng mbii ɗe Daa wur sat ngha, mbǝkǝ nghan sat ɗi mmun.>> ");
INSERT INTO sur_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita leshap mmo nǝnee, <<Azeen-zeen wen naa nǝ, baa Naan kǝ ɓakyit mmee gurum kas. ");
INSERT INTO sur_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ɗangɓǝ Naan wur kǝ lap gurum mo jir, ɗe mo kǝ kǝǝr wur, kǝzak moo cìn mbii ɗeret mo zak. ");
INSERT INTO sur_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","A pwoo ɗe Naan wur lep nnen Isreil mo nɗesǝ. Moo leshap ɗeret, ɗe nǝ a mǝ tongriyang mmo nɗǝǝn Jesu Kristi, ɗewur a Daa mǝ mbii mo jir, ");
INSERT INTO sur_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wun shikáa fuu, wu man mbii aapwoo ɗe mo kǝ cìn nɗǝǝn yil nJudiya jir. Gyet mo shee cìn nǝ a nGalili, aɓwoon ɗe gyet Joon ngucìn baptisma wur leshap mmo nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɗesǝ nǝ a pwoo nkaa Jesu Ngu Nazaret, ɗe gyet Naan ɗoo Riin Ɗeɓang kǝ iiko nkaa wur. Wur dǝm koo a pee ɗeɗangyii, ɓǝ wur cìn ɗak ɗeret, ɗewur bar nen ɗe mon ndǝr ɓal mǝ nngujwaan jir, mbǝɗe Naan ashak kǝ wur. ");
INSERT INTO sur_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mun a langtǝng mǝ mbii ɗewur cìn mo jir nɗǝǝn yil nJudiya, kǝ nɗǝǝn Jerusalem zak. A wur a ɗe gyet mo tu wur, kaaɗe gyet mo pwas wur nkaa shiyeepyoom sǝ, ɗee wur muut. ");
INSERT INTO sur_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jir aasǝ Naan yool kǝ wur a peemúut parpuus ɗekun, kǝzak Naan le kǝ nwur woo shin fin mmun agaak. ");
INSERT INTO sur_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Baa a gurum mo jir mo naa wur kas, ɗang wur woo shin a mmun, ɗe Naan kǝ ten bǝlǝp mun, kǝ mmun ɗee ɗi a langtǝng fin. Gyet muu se mbiise kǝ shwaa am ashak kǝ wur, aɓwoon ɗewur kǝ yool a peemúut zak. ");
INSERT INTO sur_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wur sat mmun ɓalɓal nǝ, mu satpwoo mǝ Naan ngurum mo jir zak, kǝ mmun tong a langtǝng ɗi nǝ, a Jesu wur a gwar ɗe Naan shin ɗeɗes nwur, mbǝkǝ nwur ɗee ɗi a ngutokɗyeel nnen ɗe mmeen mo, kǝ nnen ɗe mo kǝ murep mo zak. ");
INSERT INTO sur_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A wur a ngwe ɗe gyet nensatpwoo mǝ Naan mo jir, mo kǝ ten tong a langtǝng wur nǝ, a mbǝ sǝm wur, ɗang koo a ngwe ɗeɗangyii ɗewur shinzeen, ɓǝ wur nkat fwo mǝ shikbish wur mo.>> ");
INSERT INTO sur_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaaɗe Pita kutɗi nkaa leshap ɗesǝ mmo, ɓǝ Riin Ɗeɓang sham nkaa nen ɗe mo pǝ kǝlǝng pwoo nǝ jir. ");
INSERT INTO sur_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nen Yahudi ɗe mo a nen shinzeen ɗe mo jì ashak kǝ Pita sǝ, nǝ aapwoo mmo, Mbǝɗǝ mo naa Naan shin Riin Ɗeɓang shi zuum nnen ɗe baa mo a nnen Yahudi mo kas zak. ");
INSERT INTO sur_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mo kǝlǝng mo kǝ leshap shi pak liispwoo mo, ɗang mon nkaa shin ɗeɗes nNaan. Ɓǝ Pita sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Kyet mee gurum mmak cíi nkaa am ɗe mon ncìn baptisma ɗi nnen ɗesǝ mo aa? Mbǝɗǝ mo kǝ lap Riin Ɗeɓang nǝ a kaaɗe gyet mmun mu lap sǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yaksǝ Pita le kǝ mo cìn baptisma mmo nɗǝǝn sǝm mǝ Jesu Kristi. Mo ɗang pǝ Pita, mbǝkǝ nwur pan yém ɗi ashak kǝ mo mbǝ rep meeteer mo ruk akuɗang. ");
INSERT INTO sur_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jeplep mo kǝ nenseet nɗang Jesu ɗe mon nJudiya, mo kǝlǝng nǝ, pak gurum ɗe baa mo a nnen Yahudi mo kas, mo kǝ lappwoo Naan zak. ");
INSERT INTO sur_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kaaɗe Pita kàa wul nJerusalem, ɓǝ nen shinzeen ɗe mo kǝ can mo, mo yool kǝ pwoo nkaa wur. ");
INSERT INTO sur_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mo sat nǝnee, <<Waa dǝm a ɗel nlu mǝ nen ɗe nsuluk mo har a se mbiise ashak kǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aasǝ ɓǝ Pita yaa yakshii mǝ mbii ɗe nǝ cìn jir, wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","<<Dǝ an nɗǝǝn pee nkaam nJoppa, ɓǝ kaaɗe an nkaa ɗangnaan ɓǝ wen suun. Ɓǝ nɗǝǝn suun nǝ, nnaa mee haal ɗeɗes ɗe nǝ tong aɗeng sham ɗe, nǝ kǝ kwang mo feer, nǝ sham wul pǝ an ɗi. ");
INSERT INTO sur_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wen ban yit nkaa nǝ, ɓǝ nnaa longlu mo, kǝ luwaayil mo, kǝ mbii ɗe mo kǝ fee shi ɓut mo, kǝ nyer ɗe mo kǝ yool ncáap, mo ɗi nɗǝǝn nǝ. ");
INSERT INTO sur_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ɓǝ nkǝlǝng mee ɗoo, ɗe nǝ sat nghan nǝnee, <Pita, a yool a saa mo, a se.> ");
INSERT INTO sur_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ɗangɓe wen nsat nǝnee, <Hai Daa! Baa wen kǝn cam se mee luwaa ɗebuu, koo ɗe baa nǝ ret kǝ ngu Yahudi se kas.> ");
INSERT INTO sur_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yaksǝ ɗoo nǝ cin sat ɗi nghan aɗeng nǝnee, <Mbii ɗe Naan le a ɗeɓang, ɓǝ taji a le nǝ a ɗebish kas.> ");
INSERT INTO sur_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mo cìn a kǝsǝ, dǝm wul ar kun, ɓǝ mo waa baa dul haal nǝ kaa kǝ nǝ aɗeng. ");
INSERT INTO sur_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Abet, nciit kǝ mǝnǝ, ɓǝ gurum mo kun, ɗe mo kǝ lep mo nSizariya mbǝ jì pet an, mo kǝ ɗar mpwoo lu ɗe an ɗi. ");
INSERT INTO sur_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Riin mǝ Naan sat nghan nǝ, a seet ashak kǝ mo, baa ashak kǝ mee kyetwo kas. Pak nenseet nɗang Jesu mo peemee, mo seet ashak kǝ an zak, ɓǝ mu dǝm mu ɗel nlu kǝ gwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yaksǝ gwar nǝ wur sat mmun nǝ, ɗi naa mee ngulep mǝ Naan kǝ ɗar nɗǝǝn lu fin, ɗang ngulep nǝ sat nɗyin nǝnee, <A lep shindǝm nJoppa, kǝ mo pet mee gwar ɗe mo kǝ pet sǝm wur a Simon Pita jì ntul fwaa.> ");
INSERT INTO sur_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wur mbǝ nsatpwoo nghan ɗe nǝn nle kǝ nwun kat ɓam, waa kǝ nenlu fwaa mo jir. ");
INSERT INTO sur_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<Kaaɗe nɗoom leshap, ɓǝ Riin Ɗeɓang sham nkaa mo, nciit kǝ ɗe dǝ wur sham nkaa mun nshee sǝ. ");
INSERT INTO sur_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ɓǝ nǝ le nghan panpwoo mǝ Daa, ɗe gyet wur sat nǝnee, <Joon kǝ cìn baptisma ngurum mo a shi am, ɗangnaan wur mbǝ ncìn baptisma nwun a shi Riin Ɗeɓang.> ");
INSERT INTO sur_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Katɗang ɓǝ mbiizuum ɗesǝ, ɗe Naan wur shin mmo, nǝ a ɗemǝndong kǝ ɗewur shin mmun, mbǝɗe mu shinzeen nDaa Jesu Kristi, ɓǝ wen a wii, ɗe an mmak cíi nNaan yii?>> ");
INSERT INTO sur_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kaaɗe mo kǝlǝng pwoo mǝnǝ, ɓǝ mo ɗok tǝtǝk, yaksǝ mo kwoop Naan ɗeɗes. Mo sat nǝ, <<Daa Naan kǝ shínpee nnen ɗe baa mo a nnen Yahudi mo kas, mbǝkǝ mo tuwap, kǝ mo kat seen ɗi zak.>> ");
INSERT INTO sur_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nen ɗe dǝ mo rangkáa mbǝ jeel ɗe nǝ kǝ yool, ɗe nǝ le gyet mo tu Stivin, ɓǝ pak mo dǝm wul nyil mFonisha, kǝ Saiprus, kǝ pee nkaam nAntiyok. Baa mo satpwoo Naan nǝ, mmee nen ɗecì mo kas, tǝng a nnen Yahudi mo ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ɗangɓe pak nen shinzeen nǝ mo, ɗe mo a nen Saiprus mo, kǝ Sairin mo, mo dǝm wul Antiyok, ɓǝ mo kop pwoo Naan nǝ nnen Helene mo zak, kǝzak mo leshap ɗeret ngurum mo nkaa Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Iiko mǝ Daa nǝ ɗi ashak kǝ mo, ɓǝ gurum mo ɗes mo shinzeen, ɓǝ mo ciir kǝ pǝtuup fur mo pǝ Daa Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pwoo nkaa mo nǝ wul nkom mǝ nenseet nɗang Jesu ɗe mo kǝ tong nɗǝǝn Jerusalem, ɓǝ mo lep Barnabas, kǝ nwur dǝm ɗe Antiyok nǝ. ");
INSERT INTO sur_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kaaɗe wur seet wul, ɓǝ wur naa ɗeret ɗe Naan le nkaa mo, ɓǝ wur kat retnyit, ɗang wur leshap mmo jir, mbǝkǝ mmo ɗar ɓalɓal nɗǝǝn shinzeen nNaan azeen-zeen shi pǝtuup fur mo jir. ");
INSERT INTO sur_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas a mee ngwe ɗe ndǝre, kǝzak wur gam kǝ Riin Ɗeɓang, kǝ shinzeen zak. Gurum mo ɗes mo shinzeen nDaa zak. ");
INSERT INTO sur_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Aɓwoon mǝnǝ, ɓǝ Barnabas dǝm nTarsus, mbǝ yap Sool. ");
INSERT INTO sur_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kaaɗe wur kat Sool, ɓǝ wur jì kǝ wur nAntiyok. Mbǝ ɓit mǝndong, ɓǝ Barnabas kǝ Sool moo kaat ashak kǝ nen shinzeen nǝ mo, yaksǝ mo kám-kam ngurum mo. Mo shee pet nenseet nɗang Jesu mo a Kristiyan a nɗǝǝn pee nkaam Antiyok. ");
INSERT INTO sur_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nɗǝǝn teer mǝnǝ mo, ɓǝ pak nensatpwoo mǝ Naan mo pwat nJerusalem, ɓǝ mo jì Antiyok. ");
INSERT INTO sur_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Memee nɗǝǝn mo, ɗe sǝm wur a Agabus, wur yool ɗar atǝng, ɓǝ wur sat agaak shi iiko ɓal mǝ Riin Ɗeɓang nǝnee, <<Mee neen ɗeɗes nǝ mbǝ taa nkaa yil nǝ jir.>> Mo cìn mǝnǝ a nɗǝǝn ɓit ɗe Klodiyus a mishkoom. ");
INSERT INTO sur_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nenseet nɗang Jesu mo le pǝtuup fur mo, kǝ koo weyi, ɓǝ wur shin mbii ɗewur mak, mbǝkǝ mmo lep ɓam dǝm ɗi nnen shinzeen ɗe mo kǝ tong nɗǝǝn yil nJudiya. ");
INSERT INTO sur_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kaaɗe mo cak zuum fur nǝ mo le ashak, ɓǝ mo lep shindǝm nnen ɗǝnan-nan mǝ nen shinzeen ɗe mo kǝ tong nɗǝǝn yil nJudiya nsar Barnabas kǝ Sool. ");
INSERT INTO sur_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nɗǝǝn teer mǝnǝ mo, ɓǝ mishkoom Herot ɗoom shinjeel ɓaanɓaan nkaa pak nenseet nɗang Jesu nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wur tu Jemis, ɗyemnǝǝn mǝ Joon shi kwai. ");
INSERT INTO sur_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kaaɗe mishkoom Herot naa muut mǝ Jemis nǝ ret nnen Yahudi mon nyit, ɓǝ wur waa cin shin yaa Pita zak. Ɗesǝ nǝ ɗen a nciit kǝ ɗe mo kǝ se mbiise retnyit mǝ gilaas ɗe baa nǝ kǝ yist kas ");
INSERT INTO sur_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kaaɗe Herot yaa Pita, ɓǝ wur le wur nɗǝǝn lushoot, nsar shiitoon mo kaapaat baapeemee, mbǝkǝ mmo tap wur ɗe rǝrret. Herot kǝ lepan nǝ, ɗyin mbǝ put kǝ Pita ntoom gurum mo aɓwoon mǝ retnyit nǝ mɓekǝ tok ɗiyeel. ");
INSERT INTO sur_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kaaɗe Pita ɗi a ɓuɓwoot nɗǝǝn lushoot nǝ, ɓǝ nenseet nɗang Jesu mon nkaa ɗangnaan hakyeng, mbǝ wur. ");
INSERT INTO sur_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɗangɓǝ mpar, ɗe daar ɓǝ Herot wur lepan mbǝ put kǝ Pita, mbǝkǝ nwur shinjeel ɗi nwur. Ɓǝ Pita nsaam nnaar shiitoon mo vǝl. Mo ɓwoot wur shi shoolbǝring mo vǝl. Nentappee mo ɗe mpwoo lushoot nǝ, mon nkaa tappee rǝrret. ");
INSERT INTO sur_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yaksǝ ngulep mǝ Daa jì ɗar pǝ Pita ɗi, ɓǝ peeɓang nǝ ɓangpee nɗǝǝn lu nǝ. Ngulep mǝ Daa cut Pita nkwoop, wur mii Pita, ɓǝ wur sat nǝnee, <<A yool nkyen>> Yaksǝ shoolbǝring ɗe mo nsar wur mo ɗong nyil. ");
INSERT INTO sur_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ngulep nǝ sat nwur nǝnee, <<A lep lee fwaa, kǝzak a jwal kwoopshi fwaa mo.>> Ɓǝ Pita wur cìn mbii ɗe ngulep nǝ sat. Ngulep nǝ sat nwur zak nǝnee, <<A sǝp mbiisǝp fwaa. A jì nɗang an.>> ");
INSERT INTO sur_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita put dǝm nɗang ngulep nǝ. Baa wur man nǝ, mbii ɗe ngulep nǝ cìn nǝ azeen kas. Mbǝɗǝ wur pan nǝ ɗyin a nsuun. ");
INSERT INTO sur_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kaaɗe mo ɗel nentappee ɗenshee mo, kǝ ɗevǝl mo, ɓǝ mo jì wul mpwoo lu ɗe mo ɗak a shi shool, ɗe nii naa nkwoop pee nkaam, ɓǝ pwoo lu mǝnǝ wang shikáa fer. Ɓǝ mo pwat, mo yaa ar ɗemǝndong. Ɓǝ nnen mman, ɓǝ ngulep nǝ wur yit Pita mbǝshin. ");
INSERT INTO sur_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kaaɗe Pita kǝ winshin mɓut mbii ɗe nǝ cìn, ɓǝ wur sat nǝnee, <<Yaksǝ, wen mman azeen-zeen nǝ, a Daa lep ngulep fin, mbǝkǝ nwur jì ɓam an ɗi nsar Herot, kǝ mbii ɗe nen Yahudi mon nkaa lepyit nǝ, nǝn ncìn.>> ");
INSERT INTO sur_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kaaɗe wur winshin mɓut nǝ a kǝsǝ, ɓǝ wur dǝm nlu Meeri nǝǝn Joon, ɗe moo pet wur a Maak zak. A pee ɗe gurum mo kǝ kuur ɗi ɗes, kǝ mo nkaa ɗangnaan ɗi. ");
INSERT INTO sur_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kaaɗe Pita ɓwap pwoo lu, ɓǝ mee laareep ɗe mo kǝ pet sǝm war a Roda, war jì mbǝ wang pwoo lu nǝ. ");
INSERT INTO sur_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kaaɗe war kǝlǝng ɗoo nǝ a mǝ Pita, ɓǝ baa war wang pwoo lu nǝ kas mbǝ retnyit. Ɗangɓe war waa cin shin, kǝ nwar sat nnen ɗe mo nɗǝǝn lu nǝ, Pita kǝ ɗar a tool mpwoo lu nǝ. ");
INSERT INTO sur_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mo sat nwar nǝnee, <<Yii tǝttar aa?>> Ɗangɓe war sat nǝ, tǝng a Pita azeen-zeen. Yaksǝ mo sat nǝnee, <<A ngulep wur.>> ");
INSERT INTO sur_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ɗangɓe Pita naa a mɓwap pwoo lu nǝ ɗak, ɓǝ kaaɗe mo wang pwoo lu nǝ, ɓǝ mo naa a Pita azeen-zeen, ɓǝ nǝ aapwoo mmo zam. ");
INSERT INTO sur_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ɗangɓe Pita ɗǝk sar mmo, mbǝkǝ mmo ɗok tǝtǝk. Ɓǝ wur yakshii nǝ mmo, kaaɗe Daa put kǝ ɗyin nɗǝǝn lushoot nǝ. Wur sat mmo zak nǝnee, <<Wu satpwoo ɗesǝ nǝ nJemis, kǝ koor nen shinzeen nǝ mo zak.>> Aɓwoon mǝnǝ, ɓǝ Pita yool dǝm mmee pee ɗecì. ");
INSERT INTO sur_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kaaɗe ɓitmang, ɓǝ mee ɓǝlep ɗeɗes yool nnaar shiitoon ɗe mo kǝ tap Pita nɗǝǝn lushoot nǝ, mbǝɗe baa mo man mbii ɗe nǝ cìn Pita kas. ");
INSERT INTO sur_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot kǝ le kǝ mmo dǝm yappee ɗe Pita dǝm ɗi, ɓǝ baa mo dǝm kat wur kas. Herot tal pǝ shiitoon nǝ mo rǝrret, ɓǝ wur le kǝ mmo twe mo ɗi. Aɓwoon mǝnǝ, ɓǝ Herot yool yit yil nJudiya, kǝ nwur dǝm ɗi nyil nSizariya, ɓǝ wur dǝm cìn mee rep teer mo ɗe mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot langtuup kǝ nen Taya mo, kǝ nen Saidon mo hakyeng. Aasǝ ɓǝ mo ɓalkaa fur mo ashak, mbǝkǝ mmo dǝm naa wur ɗi. Mo shee yap ar ɗe mon ndǝm naa Herot a pǝ Blastus ɗi, ɗewur a ngwe ɗeɗes nkaa lu mishkoom nǝ. Yaksǝ mo dǝm pǝ Herot ɗi, ɓǝ mo ɗang pǝ wur, kǝ mmo kat tongriyang ɗi pǝ mishkoom, mbǝɗe yil mo nii kat mbiise a nɗǝǝn yil mishkoom nǝ. ");
INSERT INTO sur_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kaaɗe puus ɗe mo kǝ le nǝ wul, ɓǝ Herot tap jwal lee fin ɗe mǝ mishkoom, wur tap tong nkaa mbii tong mǝ ɗeɗes fin, ɓǝ wur leshap nnen nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nen nǝ mo le or, ɗang mo sat nǝnee, <<Ɗesǝ nǝ a ɗoo mǝ mee naan baa a mǝ gurum kas.>> ");
INSERT INTO sur_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nnen mman, ɓǝ mee ngulep mǝ Daa Naan cut Herot, mbǝɗe baa wur shin ɗeɗes nNaan kas. Ɓǝ yaksǝ nyet mo se Herot ɓǝ wur muut. ");
INSERT INTO sur_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gurum mo ɗes mo kǝlǝng pwoo mǝ Naan, ɓǝ mo shinzeen, ɓǝ pwoo mǝ Naan nǝ dǝm shipee-shipee zak. ");
INSERT INTO sur_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kaaɗe Barnabas kǝ Sool mo kyes ɗak fur, ɓǝ mo baaji nJerusalem ashak kǝ Joon ɗe mo kǝ pet wur a Maak. ");
INSERT INTO sur_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nɗǝǝn kuur kǝ nenseet nɗang Jesu ɗe mon Antiyok, ɓǝ pak nensatpwoo mǝ Naan mo, kǝ nenkam-kám mo ɗi. Barnabas, kǝ Simiyon ɗe mo kǝ pet wur a ɗetǝp, kǝ Lusiyus ngu Sairin, kǝ Manayen ɗewur wurang ashak kǝ mishkoom Herot, kǝ Sool. ");
INSERT INTO sur_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kaaɗe mon nkaa seyil nDaa ɗang mon nkaa yaa pwoo kǝ neen zak, ɓǝ Riin Ɗeɓang sat nǝnee, <<Wu bǝlǝp Barnabas kǝ Sool wu le nghan, mbǝ ɗak ɗe an kǝn mpet mo mbǝ cìn nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ɓǝ mo yaa pwoo kǝ neen, ɗang mo ɗangnaan zak, ɓǝ mo lesar nkaa mo, ɓǝ mo ɓwet Barnabas kǝ Sool mo shinseet. ");
INSERT INTO sur_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Riin Ɗeɓang lep Barnabas kǝ Sool mo shindǝm nSelusiya, ɓǝ mo dǝm ɗel tii mpeemǝnǝ, kǝ mo dǝm ɗe nSaiprus. ");
INSERT INTO sur_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kaaɗe mo wul nSalamis, ɓǝ mo satpwoo mǝ Naan ngurum mo nɗǝǝn lu mǝ Naan mǝ nnen Yahudi mo. Joon ɗe sǝm wur a Maak sǝ, wur ɗe ashak kǝ mo mbǝ ɓam. ");
INSERT INTO sur_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aɓwoon ɗe mo kǝ mwaan nɗǝǝn yil ɗe Am kuur neer nǝ cǝǝrkaat jir ɓǝ, mo dǝm wul mPafos, ɓǝ mo kat mee ngu Yahudi ɗe mo kǝ petsǝm wur a Barjesu wur a ngucìn yen ɗebish, kǝzak wur leshin a koo ngusatpwoo mǝ Naan sǝ, ɗang baa wur a ngusatpwoo Naan kas. ");
INSERT INTO sur_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wur ɗi ashak kǝ nguɗak mǝ ngwe ɗeɗes nǝ, gofna Sarjiyus Polo, wur a mee ngumanshii mbii zam. Gofna nǝ wur pet Barnabas kǝ Sool, mbǝɗe wur reɓet kǝlǝng pwoo mǝ Naan pǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ɗangɓe Elimas nguyen ɗebish sǝ, (A sǝm wur nǝ mmǝnǝ shi liispwoo mǝ Heleni) wur cíi mmo, mbǝɗe wur rǝɓet kǝ taji gofna nǝ wur shinzeen mpwoo mǝ Naan kas. ");
INSERT INTO sur_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɗangɓe Sool ɗe moo pet wur a Pool, wur gam kǝ Riin mǝ Naan, ɓǝ wur ban yit fǝn nzǝng nkaa ngucìn yen ɗebish nǝ, ");
INSERT INTO sur_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɓǝ wur sat nǝnee, <<Waa làa mǝ ngunjwaan! Gha a shaarlek mǝ mbii ɗe ndǝre mo jir. Kǝzak pǝtuup fwaa nǝ gam kǝ gwampee, kǝ cìn nyang. Aa ɗaar shidaar-shidaar, mbǝkǝ nghan cǝǝr kǝ zeen mǝ Daa, mbǝkǝ nǝ ɗee ɗi a ɗung. ");
INSERT INTO sur_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","A naa yaksǝ, Daa Naan wur mbǝ le kǝ gha ɗee a vum. Baa gha mmak naa puus kas, mbǝ reppee lee.>> Abet-abet, ɓǝ vuun, kǝ peenkwoo mo jì paa Elimas, ɓǝ wur ɗoom yappee, mbǝ yap ngwe ɗe mbǝ yaakam nwur. ");
INSERT INTO sur_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kaaɗe gofna nǝ wur naa mbii aapwoo mǝnǝ, ɓǝ wur shinzeen, mbǝɗe nǝ fes aapwoo nwur nkaa kám ɗewur kǝlǝng nkaa Daa Naan. ");
INSERT INTO sur_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pool kǝ nnen ɗe mo ashak kǝ wur, mo yool mPafos, ɓǝ mo ɗel nɗǝǝn tii, kǝ mo dǝm ɗi mPaga ɗe nǝ nyil mPamfiliya, ɓǝ Joon Maak yit mo mpeemǝnǝ, kǝ nwur baa dǝm ɗi nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mo yool mPaga, ɓǝ mo ɗel dǝm Antiyok ɗe nǝ mPisidiya. Parpuus Nookɗi, ɓǝ mo ɗel nɗǝǝn lu mǝ Naan, ɓǝ mo tong ɗi. ");
INSERT INTO sur_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Aɓwoon ɗe mee gurum kǝ tang nɗǝǝn ɓǝǝt-haal mǝ Wàar mǝ Mosis mo, kǝ nɗǝǝn ɓǝǝt-haal mǝ nensatpwoo mǝ Naan mo, ɓǝ nen ɗǝnan-nan nkaa lu mǝ Naan nǝ, mo lep sat mmo nǝnee, <<Ɗyemnaa mo, katɗang wun kǝ mee pwoo ɗe wun mbǝ sat ngurum nǝ mo, ɓǝ wu sat.>> ");
INSERT INTO sur_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pool yool ɗar atǝng, ɓǝ wur ɗiyeep sar wur, mbǝkǝ ngurum nǝ mo ɗok ɗe tǝtǝk, ɓǝ wur sat nǝnee, <<Wun nnen Isreil mo, kǝ wun nen ɗe baa wun a nnen Isreil mo kas, ɗe wuu kǝǝr Naan, wu lekom fuu mo. ");
INSERT INTO sur_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Naan mǝ nnen Isreil mo, bǝlǝp puun fun mo ɗang wur le mo a ɗeɗes, ɓǝ mo a mǝzep nɗǝǝn yil Ijip. Wur put kǝ mo nɗǝǝn yil Ijip shiɓal fin ɗeɗes zak. ");
INSERT INTO sur_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mbǝ ɓit mo laarfeer, ɓǝ wur mang gung kǝ mo a naaryil. ");
INSERT INTO sur_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wur le kǝ mmo twe mee soon mo pwoovǝl nɗǝǝn yil nKeenan, ɓǝ wur shin yil mǝnǝ nnen fin Isreil mo, ɓǝ nǝ ɗee mo a mbii kok kop. Mo tong nɗǝǝn yil mǝnǝ mbǝ ɓit mo kambil feer kǝ laarpaat. ");
INSERT INTO sur_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Aɓwoon mǝnǝ, ɓǝ wur shin nentokɗyeel mo mmo, dǝm jì wul mɓít mǝ ngusatpwoo mǝ Naan Samuwel. ");
INSERT INTO sur_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kaaɗe mo ɗang pǝ Naan kǝ nwur shin mishkoom mmo, ɓǝ Naan shin Sool làa mǝ Kish mmo, ɗewur a ɗang mǝ Benjamin. Sool se mishkoom nǝ mbǝ ɓit mo laarfeer. ");
INSERT INTO sur_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Aɓwoon ɗe Naan shang Sool mɓut nɗak mishkoom nǝ. Ɓǝ wur bǝlǝp Devit kǝ nwur ɗee a mishkoom mo. Naan shin langtǝng nkaa Devit nǝnee, <An kǝn nkat Devit làa mǝ Jese, a ngwe ɗe wen nreɓet hakyeng. Wur mbǝ cin mbii ɗe nsat mo nwur jir.> ");
INSERT INTO sur_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","A nɗǝǝn ɗang mǝ gwar ɗe ɗesǝ, ɓǝ Naan jì kǝ Jesu Nguɓam mbǝ nnen Isreil mo, kaaɗe gyet Naan kǝ ten tuweer mmo sǝ. ");
INSERT INTO sur_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Akuɗang Jesu jì, ɓǝ Joon kǝ ten satpwoo Naan nnen Isreil mo jir nǝnee, <Mo tuwap, mbǝkǝ mmo cin baptisma ɗi mmo zak.> ");
INSERT INTO sur_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kaaɗe Joon kus kǝ kyes ɗak fin, ɓǝ wur tal pǝ gurum nǝ mo nǝnee, <Wun, pǝpan nǝ, an a wii? Baa a an a ngwe ɗe wun mbǝ ɗarnaa jì wur kas. Ɗangɓe wu lekom, mee gurum mbǝ jì aɓwoon fen, ɗe koo a teng kwoopshi ɗe nshii wur mo, ɓǝ baa ɗeret fen nǝ mak kǝ nghan fwen teng kwoopshi wur nǝ mo kas.> ");
INSERT INTO sur_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Ɗyemnaa mo! Jep mǝ ɗang Abraham mo, kǝ nen ɗe baa mo a nnen Yahudi mo kas, ɗe mo kǝ kǝǝr Naan nɗǝǝn wun. A mbǝ wun jir, ɓǝ Naan kǝ lep pwoo ɓam ɗesǝ nǝ jì. ");
INSERT INTO sur_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nen ɗe mo kǝ tong nɗǝǝn Jerusalem kǝ nennan fur mo, baa mo man nǝ, Jesu a Nguɓam kas, kǝzak baa mo manshii mǝ pwoo nensatpwoo mǝ Naan mo, ɗe mo kǝ tang koo a parpuus Nookɗi ɗeɗangyii kas zak. Gyet mo gampwoo ɗe gyet nensatpwoo mǝ Naan mo kǝ ten sat kaaɗe gyet mo tokɗyeel muut nJesu sǝ. ");
INSERT INTO sur_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Koo ɗe baa gyet mo kat wur cìn mee shikbish ɗe nǝ mak muut nwur kas, ɓǝ mo ɗang pǝ Pailet kǝ mmo tu wur ɗi. ");
INSERT INTO sur_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kaaɗe mbii ɗe mo kǝ ten nran nkaa wur mo gam jir, ɓǝ mo sham kǝ kúm wur nkaa shiyeepyoom nǝ, ɓǝ mo dǝm le kúm wur nɗǝǝn gwoot kǝcir. ");
INSERT INTO sur_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ɗangɓe Naan yool kǝ wur a peemúut. ");
INSERT INTO sur_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mbǝ meeteer mo ɗes, ɓǝ wur woo shin fin nnen ɗe gyet mo kǝ mwaan ashak kǝ wur, yool nGalili jì nJerusalem. Yaksǝ ɓǝ mo ɗee a langtǝng wur pǝ gurum mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mmun, muu satpwoo ɗeret nwun, a pwoo ɗe gyet Naan kǝ ten cweer mpuun fun mo. ");
INSERT INTO sur_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Naan kǝgam pǝ mun jep mo mo nɗesǝ, kaaɗe wur yool kǝ Jesu a peemúut. Ɗesǝ nǝ nciit kǝ mbii ɗe mo kǝ ten ran nɗǝǝn Zabura ɗevǝl sǝ nǝnee, <Gha a Làa fen, cicinsǝ an kǝn ɗee a puun fwaa.> ");
INSERT INTO sur_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","A pwoo ɗe Naan sat nkaa yool wur a peemúut nɗesǝ nǝnee, <Baa wur mbǝ baa cam muut ɗe zak kas> Kǝzak Naan sat zak nǝnee, <An mbǝ le ɗeret ɗe nǝ azeen-zeen nkaa wun, ɗe gyet kǝn ten ncweer nDevit.> ");
INSERT INTO sur_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kǝzak, wur sat nɗǝǝn mee Zabura nǝnee, <Baa gha mmak yit kǝ ngwe fwaa ɗeɓang wam nɗǝǝn kǝcir kas.> ");
INSERT INTO sur_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Gyet Devit kǝ cìn ɗak nciit kǝ ɗyen mǝ Naan mɓít fin mo, ɓǝ wur muut, ɓǝ mo wum wur ashak kǝ puun fin mo, ɓǝ wur wam. ");
INSERT INTO sur_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ɗang Jesu ɗe Naan kǝ yool kǝ wur a peemúut, baa wur wam nɗǝǝn kǝcir kas. ");
INSERT INTO sur_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mbǝ mǝnǝ ɗyemnaa mo! Wu man nǝ, a mbǝ ɗeret mǝ gwar ɗesǝ nǝ, ɓǝ mun nkaa leshap nwun nkaa fwo mǝ shikbish fuu mo. ");
INSERT INTO sur_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A mbǝ Jesu zak, ɗang koo ngwe ɗeɗangyii ɗewur shinzeen, ɓǝ wur mbǝ kat ɓam nɗǝǝn shikbish mo jir. Ɗangɓe baa Wàar Mosis nǝ mo mak ɓam wun mɓut shikbish fuu mo kas. ");
INSERT INTO sur_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mbǝ mǝnǝ, wu tap kǝ káa fuu mo, kǝ taji mbii ɗe gyet nensatpwoo mǝ Naan mo sat nǝ sham taa nkaa wun kas. Gyet mo sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<Wu lekom, wun nenɓákpee mo, nǝn aapwoo nwun, ɗang wu mmurep. Mbǝɗǝ an mbǝ cìn mee ɗak nɗǝǝn teer fuu mo, ɗak ɗe baa wun mbǝ shínzeen nnǝ kas, koo dǝɓen. Koo ɗe mee gurum leshap nwun nkaa nǝnee, ɓǝ baa wun mbǝ shínzeen kas.> >> ");
INSERT INTO sur_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kaaɗe Pool kǝ Barabbas mo a ar put nɗǝǝn lu mǝ Naan nǝ, ɓǝ gurum nǝ mo ɗang pǝ mo, mbǝkǝ mmo cin leshap ɗi nkaa mbii ɗe mo kǝ sat mo, parpuus Nookɗi ɗe mbǝ jì zak. ");
INSERT INTO sur_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ɓǝ aɓwoon ɗe gurum mo rangkáa a peekuur nǝ, ɓǝ nnen Yahudi mo ɗes, kǝ nnen ɗe mo kǝ ciir ɗee a nnen Yahudi mo. Nen ɗe moo lepyit nkaa Naan, mo seet nɗang Pool kǝ Barnabas. Yaksǝ Pool kǝ Barnabas mo leshap mmo, shínɓal mmo mputuup, mbǝkǝ mmo mwaan ɗi nɗǝǝn ɗeret mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kaaɗe parpuus Nookɗi nǝ jì wul, ɓǝ nen pee nkaam nǝ mo ɗes hakyeng mo baaji kuur, mbǝ kǝlǝng pwoo mǝ Naan nǝ, ɗee rep pak mo nɗǝǝn pee nkaam nǝ a lee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ɗangɓe kaaɗe nnen Yahudi mo naa gurum mo kuur ɗes, ɓǝ pǝtuup mo mo gam kǝ zuur zam, nǝ le mmo sat nǝ, mbii ɗe Pool sat nǝ mo a ɗung, ɗang mo leshap ɗebuu nkaa wur zak. ");
INSERT INTO sur_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yaksǝ Pool kǝ Barnabas mo waa sǝǝt leshap nǝ ɓalɓal agaak baa kǝ mee kǝǝrmuut kas. Mo sat nǝnee, <<Nǝ a tǝng kǝ mo shee satpwoo mǝ Naan nǝ a nwun, ɗang wu ciipwoo Naan nǝ, kǝzak wu lesuk a koo baa wun kǝkoop nǝ mbǝ kat seen ɗe dǝm nghaa-nghaa kas. Ɓǝ yaksǝ, mun mbǝ yit wun, mbǝkǝ mmun dǝm mu satpwoo mǝ Naan nǝ ɗe nnen ɗe baa mo a nnen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mbǝɗǝ Daa kǝ sat mmun nǝnee, <An kǝn le gha, mbǝkǝ nghan ɗee a peeɓang mbǝ nen ɗe baa mo a nnen Yahudi mo kas. Mbǝkǝ nɗǝǝn gha, ɓǝ gurum ɗe nɗǝǝn yil nǝ mo jir, mo mbǝ kat ɓam ɗi.> >> ");
INSERT INTO sur_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kaaɗe nen ɗe baa mo a nnen Yahudi mo kas, mo kǝlǝng pwoo mǝnǝ, ɓǝ mo kǝlǝng retnyit zam, kǝzak mo lepwoo mǝ Naan a ɗeɗes. Nen ɗe mo kǝ ten bǝlǝp mo le, mbǝkǝ mmo kat seen ɗe dǝm nghaa-nghaa ɗi. ");
INSERT INTO sur_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pwoo kǝ Daa Naan nǝ dǝm shipee-shipee nɗǝǝn yil mǝnǝ jir. ");
INSERT INTO sur_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ɗangɓe nnen Yahudi mo kar pak shurep ɗe mo kǝǝr Naan, shurep ɗǝnan-nan mo, kǝ nen ɗenan-nan mǝ pee nkaam nǝ mo, kǝ mmo shinjeel ɗe nkaa Pool kǝ Barnabas. Ɗangɓe mo ceen Pool kǝ Barnabas put aku nɗǝǝn yil mo. ");
INSERT INTO sur_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ɓǝ Pool kǝ Barnabas mo ɓwap ǝrong ɗe nǝn nkaa shii mo mo, mbǝkǝ nǝ ɗee ɗi a langtǝng nkaa nen pee nkaam nǝ mo, ɓǝ mo dǝm Ikoniyum. ");
INSERT INTO sur_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nenseet nɗang Jesu mo gam kǝ retnyit zam, ɗang mo gam kǝ Riin mǝ Naan zak. ");
INSERT INTO sur_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","nƊǝǝn Ikoniyum, ɓǝ Pool kǝ Barnabas mo ɗel nɗǝǝn lu mǝ Naan mǝ nnen Yahudi mo. Ɓǝ mo sat pwoo mǝ Naan, ɗe gurum mo ɗes nɗǝǝn nnen Yahudi mo, kǝ nen ɗe baa mo a nnen Yahudi mo kas, mo shinzeen. ");
INSERT INTO sur_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ɗangɓe nnen Yahudi ɗe mo cii shinzeen mpwoo nǝ, mo kar, kǝzak mo lepshii nnen ɗe baa mo a nnen Yahudi mo kas, mbǝkǝ mmo yool ɗi kǝ pwoo ɗebuu nkaa nenseet nɗang Jesu mo. ");
INSERT INTO sur_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pool kǝ Barnabas mo tong mpee nkaam mǝnǝ, mbǝ teer mo ɗes hakyeng, kǝ mmo leshap ngurum mo nkaa Daa ɓalɓal agaak, baa ashak kǝ mee kǝǝrmuut kas. Mo ɗee a langtǝng mǝ pwoo wur ɗeret nǝ, mbǝɗe Daa kǝ le kǝn Pool kǝ Barnabas mo cìn mbii lukshik mo, kǝ mbii aapwoo mo. ");
INSERT INTO sur_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nen pee nkaam nǝ mo ɓàksut vǝl, pak mo dǝm nɗang pwoo mǝ nnen Yahudi mo, ɗang pak mo dǝm nɗang pwoo mǝ jeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nen ɗe baa mo a nnen Yahudi mo kas, kǝ nnen Yahudi mo, mo ɓalpwoo mo mo ashak kǝ nen ɗenan-nan mǝ pee nkaam nǝ mo, mbǝkǝ mmo shinjeel ɗi njeplep nǝ mo, kǝ mmo car mo ɗi shi ghǝk zak. ");
INSERT INTO sur_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Yaksǝ kaaɗe jeplep nǝ mo kǝlǝng mǝnǝ, ɓǝ mo pwat shwe dǝm mpee nkaam nListira kǝ Debi, ɗe mo ngaar yil nLukoniya, kǝ pak jepyil ɗe mo neer pee nkaam mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mo leshap ɗeret ngurum mo mpeemǝnǝ mo zak. ");
INSERT INTO sur_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nɗǝǝn Listira nǝ, ɓǝ mee gwar wur ɗi, ɗe shii wur mo kut, mbǝɗe pǝgyet mo làa wur a kurumkut ɓe baa wur kǝ cam mwaan shi shii fin kas. ");
INSERT INTO sur_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wur lekom mbǝkǝ nwur kǝlǝng Pool ɗe nkaa leshap. Pool ban yit nzǝng nkaa gwar nǝ, ɓǝ kaaɗe wur naa gwar nǝ kǝ shinzeen ɗe nǝ mak kǝn mo bar gwar nǝ, ");
INSERT INTO sur_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","yaksǝ Pool sat shi ɗoo ɗeɗes nǝnee, <<A yool a ɗar shi shii fwaa!>> Ɓǝ gwar nǝ wur sham yool metpee, ɗang wur mwaan zak. ");
INSERT INTO sur_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kaaɗe kuur mǝ gurum nǝ mo naa mbii ɗe Pool cìn ɓǝ mo ɗiyeep ɗoo fur mo shi liispwoo mǝ nnen Lukoniya mo, mo sat nǝnee, <<A naan mo sham pǝ mun ɗe, nɗǝǝn nan koo mun gurum sǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mo pet Barnabas a Ziiyos, ɗang mo pet Pool a Hamis, mbǝɗe a Pool wur a ngusatpwoo nǝ. ");
INSERT INTO sur_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yaksǝ mishkoom kùm ɗe mǝ Ziiyos, ɗe lu kùm wur nǝ kus kǝ pee nkaam nǝ, wur jì kǝ kus nǝng mo, kǝ pelɗem mo, ngaar pǝbong nǝ, mbǝɗe wur kǝ kuur gurum nǝ mo, mo kǝ reɓet wus mbiizuum njeplep nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ɗangɓe, kaaɗe, Barnabas kǝ Pool mo kǝlǝng mǝnǝ, ɓǝ mo yilang nlǝr fur mo. Mo shwe dǝm ɗel nɗǝǝn kuur gurum nǝ mo, ɓǝ mo le or, ɓǝ mo sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Hee des oo! A mii le ɗang wun pǝ reɓet cìn mbii mǝnǝ ii? Mun a gurum mo koo wun sǝ. Mu jì mpee ɗesǝ a mbǝkǝ mmo satpwoo ɗeret ɗe nwun, mbǝkǝ nwun yit mbii ɗebuu sǝ mo ɗi, ɗe baa mo kǝ mee koop nǝ kas. Mbǝkǝ nwun jì pǝ Naan ɗewur kǝ seen. A wur le ɗeng, kǝ yil, kǝ Am kuur mo, kǝ mbii ɗe nɗǝǝn mo jir zak. ");
INSERT INTO sur_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dǝ yam-yam ɓǝ, a Naan shínpee ngurum mo jir, kǝ mo mwaan nɗǝǝn ar ɗe mo kǝ reɓet. ");
INSERT INTO sur_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Jir kǝsǝ, ɓǝ baa wur kǝ cam nook cìn langtǝng mbǝ shin fin kas, mbǝɗe wur cìn mbii ɗeret mo. A wur shin fwan sham nwun aɗeng, kǝ mbii kǝkop fuu mo ntarpas, ɗang a wur shin mbiise nwun ɗes zak, kǝzak a wur gam pǝtuup fuu mo shi retnyit zak.>> ");
INSERT INTO sur_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jeplep nǝ mo leshap ɗesǝ mmo, jir kǝsǝ, ɓǝ a prurut, ɗang mo cíi nkuur kǝ gurum nǝ mo, mbǝkǝ taji gurum nǝ mo wus mbiizuum mbǝ seyil mmo kas. ");
INSERT INTO sur_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ɗangɓe pak nnen Yahudi mo pwat Antiyok, ɗe nǝ mPisidiya, kǝ Ikoniyum, mo jì mangɗyeen ngurum nǝ mo, ɗe mo kar kuur gurum nǝ mo, mbǝkǝ mmo yool ɗi kǝ lek nkaa jeplep nǝ mo. Yaksǝ mo car Pool shi ghǝk, ɓǝ mo fee wur put kǝ nǝ aɓwoon pee nkaam nǝ. Mo pan nǝ, Pool kǝ muut. ");
INSERT INTO sur_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ɗang kaaɗe nenseet nɗang Jesu mo jì neer Pool, ɓǝ wur yool, wur ɗel nɗǝǝn pee nkaam nǝ. Daar nǝ, ɓǝ wur kǝ Barnabas mo pwat dǝm nDebi. ");
INSERT INTO sur_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pool kǝ Barnabas, mo dǝm leshap ɗeret nǝ nnen pee nkaam nDaabi mo, ɓǝ gurum mo ɗes mo shinzeen nDaa Jesu. Aɓwoon mǝnǝ, ɓǝ mo baaji nListira, kǝ Ikoniyum, kǝ Antiyok zak. ");
INSERT INTO sur_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mo shínɓal mputuup nenseet nɗang Jesu mo. Mo leshap mmo, mbǝkǝ mmo ɗar ɗe ɓalɓal nɗǝǝn shinzeen mo, kǝ mo kám mo zak nǝnee, <<Mun shwaajeel ɗes, akuɗang ɓǝ mun mbǝ mmak ɗel nɗǝǝn pee ɗehai mǝ Naan.>> ");
INSERT INTO sur_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pool kǝ Barnabas mo bǝlǝp nen ɗenan-nan mo, mbǝ koo a kuur mǝ nenseet ndang Naan ɗǝɗang mo ii, ashak kǝ ɗang, kǝ yaa pwoo kǝ neen zak, ɓǝ mo le nnen ɗe mo bǝlǝp nǝ mo nsar mǝ Daa, ɗe mo shinzeen nwur. ");
INSERT INTO sur_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Aɓwoon ɗe mo kǝ taaɗel ngaar mPisidiya, ɓǝ mo jì wul mPamfiliya. ");
INSERT INTO sur_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kaaɗe mo kǝ satpwoo nǝ nɗǝǝn Paga, ɓǝ mo yool sham dǝm Ataliya. ");
INSERT INTO sur_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mo yool mpee mǝnǝ, ɓǝ mo ɗel tii, kǝn mmo baaji ɗin Antiyok, pee nkaam ɗe dǝ mo shee ɗangnaan ɗi nkaa mo, mbǝkǝ nɗeret mǝ Naan nǝ kyeer mo ɗi nɗǝǝn ɗak, ɗe yaksǝ ɓǝ mo kǝ cìn kyes. ");
INSERT INTO sur_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kaaɗe mo baaji wul, ɓǝ mo pet kuur nenseet nɗang Jesu nǝ mo ashak jir, ɓǝ mo leshap ngurum nǝ mo nkaa mbii ɗe Naan le kǝ mmo cìn, kǝ kaaɗe wur wang ar mǝ shinzeen nnen ɗe baa mo a nnen Yahudi mo kas zak. ");
INSERT INTO sur_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mo tong nɗǝǝn pee nkaam mǝnǝ ɗes, ashak kǝ nenseet nɗang Jesu mo. ");
INSERT INTO sur_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pak gurum mo tong nJudiya mo jì nAntiyok, ɓǝ mo jì kám nenseet nɗang Jesu nǝ mo nǝnee, <<Katɗang baa mo can wun, kaaɗe Wàar mǝ Mosis sat sǝ kas, ɓǝ baa wun mbǝ mak kat ɓam kas.>> ");
INSERT INTO sur_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pool kǝ Barnabas mo cìn ɓeetshik ɗes kǝ mo, nkaa kám mǝnǝ. Aasǝ ɓǝ, mo bǝlǝp Pool kǝ Barnabas kǝ pak gurum mo nɗǝǝn nen shinzeen nǝ mo, kǝ mmo dǝm nJerusalem pǝ jeplep mo ɗi, kǝ nennan mǝ Eklesiya mo, mbǝkǝ mmo dǝm ɓeetpwoo ɗesǝ nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Eklesiya mo ɓwet mo, ɓǝ mo taa mer nyil mFonisha kǝ Samariya. Mo satpwoo tuwap mǝ nen ɗe baa mo a nnen Yahudi mo kas, kǝzak kaaɗe mo le pǝtuup mo mo pǝ Naan ɗi. Pwoo ɗesǝ nǝ jì kǝ retnyit nnenseet nɗang Jesu nǝ mo hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kaaɗe mo wul nJerusalem, ɓǝ nenseet nɗang Jesu mo kǝ jeplep mo, kǝ nen ɗenan-nan mo, mo kaat mo. Yaksǝ mo yakshii mǝ mbii ɗe Naan wur cìn ashak kǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yaksǝ pak nen shinzeen ɗe mo a mǝ ar mǝ nen Farisi mo, mo yool kǝ pwoo nǝnee, <<Nǝ ret kǝ tǝng mo can nen ɗe baa mo a nnen Yahudi mo kas, kǝzak nǝ a tǝng mo tap Wàar mǝ Mosis rǝrret zak.>> ");
INSERT INTO sur_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jeplep mo, kǝ nen ɗenan-nan mǝ Eklesiya nǝ, mo kuur ashak, mbǝkǝ mmo naashii mǝ pwoo ɗesǝ nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aɓwoon ɗe mo kǝ ɓeetpwoo nǝ ɗes ndǝr-ndǝr hakyeng, ɓǝ Pita yool ɗar atǝng, ɓǝ wur sat mmo nǝnee, <<Ɗyemnaa mo! Wu man nǝ, Naan shee bǝlǝp an mɓut nwun, mbǝkǝ nghan sat pwoo ɗeret nǝ ɗi nnen ɗe baa mo a nen Yahudi mo kas, kǝ mmo shinzeen ɗi. ");
INSERT INTO sur_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naan ɗewur man pǝtuup mǝ gurum mo jir, wur kám agaak nǝ, ɗyin ɗi lap mo, kaaɗe wur shin Riin Ɗeɓang mmo, nciit kǝ ɗe dǝ wur kǝ shin mmun sǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Baa Naan ɓàkyit mmun kǝ mo kas. Wur vwang shikbish ɗe nɗǝǝn pǝtuup mo mo, a mbǝɗe mo shinzeen. ");
INSERT INTO sur_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mbǝ mǝnǝ yaksǝ, ɓǝ a mii le ɗang wun pǝ kam Naan ii? Wun nkaa le lée ɗe toon nkaa took mǝ nenseet nɗang Jesu mo, ɗe koo a puun fun mo, kǝ mun, ɓǝ baa mu mak mang lée nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Hai! Mu shinzeen nǝ, a mbǝ ɗeret mǝ Daa fun Jesu, ɗang mu kat ɓam, kaaɗe mo kat ɓam nǝ sǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kuur mǝ gurum nǝ mo ɗok tǝtǝk, kǝ mmo lekom mbǝ kǝlǝng pwoo mǝ Barnabas, kǝ Pool, kaaɗe mo nkaa leshap mmo nkaa mbii lukshik mo, kǝ mbii aapwoo mo, ɗe Naan le kǝ mPool kǝ Barnabas mo cìn, nɗǝǝn nen ɗe baa mo a nnen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aɓwoon ɗe mo kyes leshap nǝ, ɓǝ Jemis sat nǝnee, <<Ɗyemnaa mo, wu lekom kǝ nwun kǝlǝng an ɗi. ");
INSERT INTO sur_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita kǝ leshap nwun nkaa wal ɗe Naan shee kám nǝ nnen ɗe baa mo a nnen Yahudi mo kas. Wur shwat pak mo nɗǝǝn mo, mbǝkǝ mmo ɗee ɗi a nen fin mo. ");
INSERT INTO sur_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɗesǝ nǝ a nciit kǝ pwoo mǝ nensatpwoo mǝ Naan mo, ɗe mo kǝ ten ran nɗǝǝn ɓǝǝt-haal mǝ Naan nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<Aɓwoon ɗesǝ ɓǝ an mbǝ baajì. Mbǝkǝ nghan mbaa ɗi kǝ lu mǝ Devit ɗe nǝ shirip sǝ ɗi. An mbǝ baa ɗiyeep kǝrem lu ɗe mo kǝ shirip nǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mbǝkǝ nkoor gurum mo jir, ɓǝ mo jì tang Daa ɗi, kǝ jir nen ɗe baa mo a nnen Yahudi mo kas, ɗe an kǝn pǝrep mo, mbǝkǝ mo ɗee ɗi a nen fen mo. ");
INSERT INTO sur_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A Daa kǝ sat a kǝsǝ! Wur kǝ ten le kǝ mbii ɗesǝ mo ɗee a ɗemǝman pegyet ɗi yam-yam.> ");
INSERT INTO sur_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<Mbǝ mǝnǝ, nnaa mǝnǝ, ɓǝ taji wu le nǝ luk nen ɗe baa mo a nnen Yahudi mo kas, ɗe mo ciir kǝ pǝtuup fur mo pǝ Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ɗangɓe mu ran lep a rǝran mmo, mbǝkǝ mmun sat ɗi mmo nǝnee. Taji mo se mee mbiise ɗe mo kǝ ten shin nkùm kas. Kǝzak taji mo cìn ngaa kas. Taji mo se luwaa mǝ long ɗe mo miyoor took nǝ kas. Kǝzak taji mo se toom kas zak. ");
INSERT INTO sur_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mbǝɗǝ mo kǝ tang Wàar mǝ Mosis nǝ peedǝ ɗi yam-yam, koo a parpuus Nookɗi ɗeɗangyii nɗǝǝn lu mǝ Naan nǝ mo jir, kǝ nɗǝǝn pee nkaam nǝ mo jir zak.>> ");
INSERT INTO sur_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jeplep nǝ mo, kǝ nen ɗenan-nan mo, kǝ nen shinzeen nǝ mo jir, mo naa nǝ, nǝ ret kǝ mmo bǝlǝp pak gurum mo nnaar fur, mbǝkǝ mmo lep mo shindǝm Antiyok ashak kǝ Pool kǝ Barnabas. Ɓǝ mo bǝlǝp Judas ɗe moo pet wur a Barsabas, kǝ Silas zak, ɗe mo a ɗǝnan-nan mɓut nnen shinzeen nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yaksǝ mo lep mo shindǝm ashak kǝ lep a rǝran ɗe nǝ sat nǝnee, <<Jeplep mo, kǝ nen ɗenan-nan mǝ Eklesiya mo, mun ɗyemnǝǝn fuu mo, muu lep tokshik fun ɗeɗes dǝm pǝ wun ɗyemnǝǝn fun, nenseet nɗang Jesu mo, ɗe baa wun a nnen Yahudi mo kas. Ɗe wuu tong nɗǝǝn yil Antiyok, kǝ Siriya, kǝ Silisiya. ");
INSERT INTO sur_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mu kǝlǝng nǝ, pak gurum mo nɗǝǝn nen ɗe mo pwat pǝ mun ɗi, mo kǝ dǝm daampee nwun shi pwoo mo, kǝ mmo ringshii nwun. Ɓǝ baa a mun mu lep mo kas. ");
INSERT INTO sur_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaaɗe mu kuur ashak, ɓǝ pwoo fun mo seet ndangshak, ɓǝ mu naa nǝ, nǝ ret kǝ mmun bǝlǝp pak gurum mo, mbǝkǝ mmun lep mo dǝm pǝ wun ɗi. Mo dǝm ashak kǝ shaar fun mo Barnabas kǝ Pool. ");
INSERT INTO sur_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Mo kǝ shin seen fur mo mbǝ cìn ɗak mǝ Daa fun Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mbǝ mǝnǝ, mu lep Judas kǝ Silas dǝm pǝ wun ɗi. Mo shikáa fur, mon nyakshii mǝ mbii ɗe mǝ nran nɗǝǝn lep a rǝran nǝ nwun shi pwoo. ");
INSERT INTO sur_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mbǝɗǝ Riin Ɗeɓang kǝ naa nǝ ret, ɗang mmun mu naa nǝ ret a kǝsǝ zak, mbǝkǝ taji mo le mee lée toon nkaa wun, waa met mbii ɗesǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Taji wu se mbiise ɗe mo kǝ ten shin nkùm kas, kǝzak taji wu se luwaa ashak kǝ toom kas. Taji wu se luwaa mǝ long ɗe mo miyoor took nǝ kas, ɗang taji wu cìn ngaa kas. Katɗang baa wuu cìn mbii ɗesǝ mo kas, ɓǝ nǝ ret zam. Ɗang mukaat. Wu tongriyang.>> ");
INSERT INTO sur_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mo lep nenlep nǝ mo shinseet, ɓǝ mo dǝm Antiyok, a mpee ɗe kuur mǝ nenseet nɗang Jesu mo ɗi ashak, ɓǝ mo shin lep ɗe a rǝran nǝ mmo. ");
INSERT INTO sur_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kaaɗe mo tang lep a rǝran nǝ ngurum nǝ mo, ɓǝ mo kǝlǝng retnyit zam, mbǝɗe pwoo nǝ fes gangkwak mmo zam. ");
INSERT INTO sur_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mbǝɗǝ Judas kǝ Silas, mo a nensatpwoo mǝ Naan mo zak, ɓǝ mo shínɓal ngurum nǝ mo mputuup zak. ");
INSERT INTO sur_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aɓwoon ɗe mo cìn rep teer mo nɗǝǝn Antiyok ɓǝ nenseet nɗang Jesu nǝ mo ɓwet mo ryang, mbǝkǝ mmo baa ɗi pǝ nen ɗe dǝ mo lep mo. ");
INSERT INTO sur_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ɗangɓǝ Silas naa nǝ nǝ ret kǝ nɗyin ɗi tong ɗi mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ɓǝ Pool kǝ Barnabas mo tong nɗǝǝn Antiyok mbǝ rep teer mo. Mo nkaa kám, kǝzak mo nkaa satpwoo mǝ Daa, ashak kǝ pak gurum mo ɗes. ");
INSERT INTO sur_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Aɓwoon meeteer mo ruk, ɓǝ Pool sat mBarnabas nǝnee, <<Nǝ ret kǝ mmun cin mu dǝm, mbǝkǝ mmun tok kǝ nenseet nɗang Jesu mo nɗǝǝn koo a pee nkaam ɗeɗangyii ɓe kǝ mun nakoom mu ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas reɓet kǝ mmo seet ashak kǝ Joon ɗe moo pet wur a Maak. ");
INSERT INTO sur_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ɗangɓǝ Pool naa baa nǝ ret kǝ nwur seet ashak kǝ mo a peeɗak nǝ kas. Mbǝɗǝ dǝ wur kǝ su yit mo ɗe nyil mPamfiliya kǝzak baa wur sekyeen ashak kǝ mo nɗǝǝn ɗak nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɓǝ ɓeetshik yool mmo nnaar, ɗe nǝ le mmo ɓàkshak. Barnabas mang Maak ashak kǝ wur, ɓǝ mo ɗel nɗǝǝn tii kǝ mmo dǝm ɗi nSaiprus. ");
INSERT INTO sur_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ɗangɓǝ Pool bǝlǝp Silas. Ɓǝ aɓwoon ɗe nenseet nɗang Jesu mo ɗangnaan (leshap kǝ Naan), ɓǝ mo le mo nsar ɗeret mǝ Daa Naan, ɓǝ mo pwat seet. ");
INSERT INTO sur_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pool ɗel dǝm nɗǝǝn yil nSiriya kǝ Silisiya, wur nkaa gangkwak nnenseet nɗang Jesu ɗe mo mpeemǝnǝ jir. ");
INSERT INTO sur_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pool jì wul nDebi kǝ Listira. Yaksǝ wur kat mee nguseet nɗang Jesu nɗǝǝn Listira nǝ, ɗe sǝm wur a Timoti. Wur a làa mee mat Yahudi ɗe war shinzeen nDaa Jesu, ɗang puun wur a ngu Heleni. ");
INSERT INTO sur_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nenseet nɗang Jesu ɗe mon nListira kǝ Ikoniyum, moo kwoop mǝse kǝ Timoti nǝ. ");
INSERT INTO sur_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool reɓet kǝ nTimoti seet nɗang wur, a kǝsǝ ɓǝ Pool can Timoti, mbǝ nnen Yahudi ɗe mo nɗǝǝn peemǝnǝ mo. Mbǝɗǝ mo jir, mo man nǝ, puun Timoti a ngu Heleni. ");
INSERT INTO sur_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kaaɗe mo a ar mwaan, ɓǝ mo dǝm ɗel nɗǝǝn pee nkaam mo, kǝ mo leshap kǝ nenseet nɗang Jesu ɗe mon mpeemǝnǝ mo, nkaa Wàar ɗe jeplep mo, kǝ nennan mǝ Eklesiya ɗe nJerusalem mo kǝ sat, mbǝkǝ nnenseet nɗang Jesu mo tap ɗi kǝ Wàar nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aasǝ ɓǝ, nenseet nɗang Jesu nǝ mo ɗar ɓalɓal nɗǝǝn shinzeen fur, ɗang mo ɓul shidaar shidaar zak ");
INSERT INTO sur_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pool kǝ nen ɗe mo ashak kǝ wur, mo ɗel dǝm nɗǝǝn yil nFirjiya kǝ yil nGalati zak, mbǝɗe baa Riin Ɗeɓang yit kǝ mmo satpwoo Naan nɗǝǝn yil Eshiya kas. ");
INSERT INTO sur_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kaaɗe mo wul a pee ɓàkyil mǝ nen Misiya mo, ɓǝ moo reɓet ɗel dǝm nyil mBisiniya, ɗang Riin Jesu tǝǝrsar mmo. ");
INSERT INTO sur_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Aasǝ ɓǝ, mo ɗel dǝm nɗǝǝn yil mMisiya, mbǝkǝ mmo ɗel sham ɗi nyil nTrowas. ");
INSERT INTO sur_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mparmǝnǝ, ɓǝ Pool teer suun nǝ, ɗi naa mee ngu Masidoniya kǝ ɗar, ɗang wur nkaa ɗang pǝ ɗyin nǝnee, <<A can a ɗel nyil mMasidoniya kǝ nghan ɓam mun ɗi!>> ");
INSERT INTO sur_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kaaɗe Pool suun suun ɗesǝ, ɓǝ abet-abet mu ɗak sun mbǝ dǝm Masidoniya nǝ, mbǝɗe mu man azeen-zeen nǝ, a Naan pet mun, mbǝkǝ mmun dǝm mu satpwoo fin ɗi mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mu yool nɗǝǝn tii nTrowas, ɓǝ mu ɗel mu seet wur-wur mbǝ dǝm nSamotras. Daar nǝ ɓǝ mu jì mu wul Niyapolis. ");
INSERT INTO sur_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mu yool a mpeemǝnǝ, ɓǝ mu mwan shi ji nFilipi, ɗe nǝ a pee nkaam ɗeɗes ngaar mMasidoniya. Nǝ a mee yil ɗe nǝn ndǝr nen Rom mo. Yaksǝ mu cìn meeteer mo ruk nɗǝǝn pee nkaam mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Parpuus Nookɗi, ɓǝ mu put mpee nkaam nǝ, kǝn mmun dǝm ɗi mpwoo dung, a pee ɗe mu pan nǝ, mun nkat mee pee ɗangnaan ɗi. Mu tong ɗi mpwoo dung nǝ, mu leshap kǝ shurep ɗe mo jì kuur ɗi. ");
INSERT INTO sur_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mee mat war ɗi mɓut nnen ɗe mo kǝlǝng mun, sǝm war a Lidiya ɗe war a mat Tayatira, ɗe war kǝ seet kǝ leelep ɗe rǝrret mo, kǝzak war a mat ɗe war kǝ seyil nNaan zak. Daa Naan wang pǝtuup war, nǝ le nwar lappwoo ɗe Pool kǝ sat mo. ");
INSERT INTO sur_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aɓwoon ɗe mo cìn baptisma nwar kǝ nenlu war mo jir, ɓǝ war ɗang pǝ mun nǝnee, <<Katɗang wu le, nǝ an a mat ɗe wen shinzeen nDaa azeen-zeen, ɓǝ wu jì ntul fen.>> Nǝ le nwar ɗyiin shi mun, mbǝ dǝm ntul fer nǝ. ");
INSERT INTO sur_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Par sǝ kaaɗe mun mbǝ dǝm mbǝ ndang Naan ɓǝ mukaat kǝ mee reep ɗe war mat joon, ɗe nii le kǝn nwar naa mbii ɗe mo mbǝ jì a kyeen. War kǝ naa njì kǝ shool ɗes mpuun fer mo, mbǝɗe war kǝ naa mbii ɗe mo mbǝ cìn a kyeen ngurum mo. ");
INSERT INTO sur_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","War naa jì nɗang Pool kǝ mun, ɗang war le or nǝnee, <<Nen ɗesǝ mo a kǝrem mǝ Naan Ɗehai, kǝzak mon nkaa sat a ar ɗe mǝ ɓam nwun!>> ");
INSERT INTO sur_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","War naa ncìn a kǝsǝ, mbǝ meeteer mo ɗes, dǝm wul a ɗe nǝ láa mPool mɓut ɗes hakyeng, ɓǝ wur ciir sat nriin ɗebish nǝ nǝnee, <<An pǝ sat nghan nɗǝǝn sǝm mǝ Jesu Kristi, a put aku mɓut nwar.>> Abet-abet ɓǝ riin ɗebish nǝ put nɗǝǝn war. ");
INSERT INTO sur_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɗangɓǝ kaaɗe puun war mo naa ar kat shool mo nǝ duu, ɓǝ mo yaa Pool kǝ Silas, mo dul mo dǝm kǝ nǝ ntoom nen tokɗyeel mo mpeepring. ");
INSERT INTO sur_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kaaɗe mo jì kǝ mo ntoom nentokɗyeel nǝ mo, ɓǝ mo sat nǝnee, <<Nen ɗesǝ mo a nnen Yahudi. Moo ring gurum mo nɗǝǝn pee nkaam fun. ");
INSERT INTO sur_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mo nkaa kám mbii mo mmun, ɗe baa muu loot cìn mo kas. Mbǝ mǝnǝ, baa mu lap mbii ɗe mon nkaa kám nǝ kas, mbǝɗe mun a nnen Rom mo.>> ");
INSERT INTO sur_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yaksǝ ɗuu gurum nǝ mo jir mo yool táa nkaa Pool kǝ Silas. Nen tokɗyeel nǝ mo le kǝ mmo yilang nlǝr mPool kǝ Silas. Ɓǝ mo le kǝ mmo nǝrem mo shi kam. ");
INSERT INTO sur_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kaaɗe mo nǝrem mo ɗes, ɓǝ mo dǝm shoot mo nɗǝǝn lushoot. Mo sat ngutap nen ɗe mo a shishoot nǝ, kǝn nwur tap mo ɗe rǝret. ");
INSERT INTO sur_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kaaɗe gwar nǝ kǝlǝng pwoo nǝ ɓal a kǝsǝ, ɓǝ wur dǝm shoot Pool kǝ Silas nɗǝǝn lushoot ɗe nǝ ndǝǝn-ndǝǝn, ɓǝ wur jwal shii mo mo mɓut nfut. ");
INSERT INTO sur_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nnaar par, ɓǝ Pool kǝ Silas mo nkaa ɗangnaan kǝ kook mǝ kwoop Naan. Nen ɗe mo a shishoot nǝ mo lekom kǝ moo kǝlǝng Pool kǝ Silas ɗe. ");
INSERT INTO sur_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ɓǝ nnen mman, yil nǝ sǝǝn ɗes hakyeng, yaksǝ kuk lushoot nǝ mo yoon. Abet ɓǝ pwoo lushoot nǝ mo wang, ɓǝ shoolbǝring ɗe mo ɓwoot nen ɗe mo a shishoot nǝ jir mo fwen. ");
INSERT INTO sur_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kaaɗe ngutap nen ɗe mo, a shishoot nǝ mo mii nsaam, ɓǝ wur naa pwoo lushoot nǝ mo a wuwang jir, ɓǝ wur shang kwai fin, mbǝkǝ nwur tu shik ɗe, mbǝɗe wur pan nǝ nnen ɗe mo a shishoot nǝ jir mo, mo kǝ pwat shwe seet jee. ");
INSERT INTO sur_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ɗangɓǝ Pool ɗiyeep ɗoo ɓalɓal nǝnee, <<Taji a le mee láa nsak kas, mbǝɗe mun ɗi jir.>> ");
INSERT INTO sur_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yaksǝ ngutap nen ɗe mo a shishoot nǝ wur pet mo jì kǝ wus, ɓǝ wur yool kǝkǝlak, ɗel taa ntoom Pool kǝ Silas, wur nkaa ɗaar mbǝ kǝǝrmuut. ");
INSERT INTO sur_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ɓǝ wur put kǝ mo a tool, kǝn nwur sat mmo nǝnee, <<Daa mo, an cin a miyi, kǝ nghan kat ɓam ɗi yi?>> ");
INSERT INTO sur_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mo sat nwur nǝnee, <<A shinzeen nDaa Jesu. Ɓǝ gha mbǝ nkat ɓam, waa kǝ nenlu fwaa mo jir.>> ");
INSERT INTO sur_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mo satpwoo Naan nwur ashak kǝ nenlu fin mo jir. ");
INSERT INTO sur_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ɓǝ mparmǝnǝ, wur vwang láa mo mo. Yaksǝ abet-abet mo cìn baptisma nwur, ashak kǝ nenlu fin mo jir. ");
INSERT INTO sur_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wur jì kǝ mo ntul fin, kǝn nwur shin mbiise mmo. Pǝtuup wur nǝ gam kǝ retnyit ɗes hakyeng, mbǝɗe wur ashak kǝ nenlu fin mo jir, mo shinzeen nDaa Naan. ");
INSERT INTO sur_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ɓǝ kaaɗe ɓitmang, ɓǝ nenɗyeel nǝ mo lep jepkam mo, mbǝkǝ mmo sat ɗi ngutap nen ɗe mo a shishoot nǝ mo nǝnee, <<A ɓwet des ɗevǝl sǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yaksǝ ngutap nen ɗe mo a shishoot nǝ sat mPool nǝnee, <<Nenɗyeel mo lep-lep nǝ, mun ɓwet gha kǝ Silas, mbǝkǝ nwun seet mbuu ɗi. Mbǝ mǝnǝ wu put yaksǝ, kǝn nwun seet ɗi ryang.>> ");
INSERT INTO sur_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ɗang Pool sat njepkám nǝ mo nǝnee, <<Doo mo kǝ nǝrem mun agaak, ɓǝ baa mo kǝ tokɗyeel mmun, mbǝkǝ mmo man ɗi nǝ kyet muu cin mee mbii ɗebish ɗi kas. Mun ɗe mun a nnen Rom mo. Kǝzak doon mo dǝm shoot mun nlushoot zak. Ɗangɓǝ yaksǝ, ɓǝ moo reɓet ceen mun a sǝsok aa? Dǝm wu sat mo jì pwat kǝ mun shikáa fur.>> ");
INSERT INTO sur_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Aasǝ ɓǝ, jepkam nǝ mo baa, ɓǝ mo satpwoo ɗe Pool sat nnentokɗyeel nǝ mo. Kaaɗe nentokɗyeel nǝ mo kǝlǝng nǝ, Pool kǝ Silas mo a nnen Rom mo, ɓǝ kǝǝrmuut yaa mo. ");
INSERT INTO sur_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓǝ nentokɗyeel nǝ mo jì ɗang pǝ Pool kǝ Silas, mbǝkǝ mmo fwoo ɗi mmo. Yaksǝ mo tap put kǝ mo nɗǝǝn lushoot nǝ, ɗangɓǝ mo sat mPool kǝ Silas kǝ mmo yit pee nkaam nǝ. ");
INSERT INTO sur_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aɓwoon ɗe Pool kǝ Silas mo kǝ pwat nɗǝǝn lushoot nǝ, ɓǝ mo dǝm ntul Lidiya. A pee ɗe mo kat nenseet nɗang Jesu mo ɗe, ɓǝ mo leshap mǝ caa pǝtuup ngurum nǝ mo, ɗang mo yool yit pee nkaam mǝnǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool kǝ Silas mo yaa ar dǝm put Amfipolis kǝ Apoloniya, ɓǝ mo jì wul nTasoloni, a pee ɗe lu Naan mǝ nnen Yahudi mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ɓǝ Pool ɗel nLu Naan, kaaɗe wur loot kǝ cìn nǝ sǝ. Mbǝ puus Nookɗi mo yitkun, ɓǝ Pool nkaa ɓeetpwoo kǝ gurum nǝ mo nɗǝǝn pwoo Naan. ");
INSERT INTO sur_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wur nkaa kámshii mǝ pwoo Naan nǝ mmo, ɗe mo naa nǝ ɗee agaak nǝ, nǝ a tǝng kǝn Kristi shwaajeel, ɗang wur nyool a peemúut zak. Wur sat zak nǝnee, <<Jesu ɗe an kǝn satpwoo nwun nkaa wur sǝ, a wur a Kristi.>> ");
INSERT INTO sur_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pak nnen Yahudi nǝ mo shinzeen mpwoo ɗe Pool sat ɓǝ, nǝ le mmo seet nɗang Pool kǝ Silas. Aasǝ zak, ɓǝ nnen Heleni mo ɗes ɗe mo kǝ kǝǝr Naan, mo shinzeen ashak kǝ pak shurep ɗǝnan-nan mo. ");
INSERT INTO sur_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ɗangɓe nnen Yahudi mo gam kǝ zuur, mbǝɗe gurum mo ɗes mo dǝm nɗang kám mǝ Pool kǝ Silas, ɓǝ mo dǝm pǝrep pak nen ɗebish mo, kǝ jepkut ɗe mo kǝ tong mpwoo lutuk mo, mo kuur mo ashak. Yaksǝ mo yool kǝ or kǝ pwoo ɗebuu koo mo tǝttar sǝ nɗǝǝn pee nkaam nǝ. Ɓǝ mo shwe dǝm ntul Jesen, mo nkaa yap Pool kǝ Silas, mbǝkǝ mmo put ɗi kǝ mo pǝ ɗuu mǝ gurum nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ɗang kaaɗe baa mo kat mo kas, ɓǝ mo fee Jesen, kǝ pak nenseet nɗang Jesu mo pwat, ɓǝ mo jì kǝ mo ntoom nen ɗǝnan-nan mǝ pee nkaam nǝ mo. Mo nkaa le or nǝnee, <<Nen ɗesǝ mo, ɗe mo kǝ ciir kǝ yil nǝ shikáa atuum, mo jì mpee ɗesǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nǝ le Jesen lap mo le ntul fin! Moo tep a Wàar mǝ Siza, mbǝɗe mon nkaa sat nǝ, mee mishkoom ɗi, ɗe mo kǝ pet wur a Jesu.>> ");
INSERT INTO sur_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kaaɗe gurum nǝ mo kǝ nen ɗǝnan-nan mǝ pee nkaam nǝ mo kǝlǝng pwoo mǝnǝ, ɓǝ nǝ daampee mmo, ɓǝ tuup tu mo zam. ");
INSERT INTO sur_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yaksǝ nen ɗǝnan-nan mǝ pee nkaam nǝ mo le Jesen kǝ pak nenseet nɗang Jesu nǝ mo kwat shool ɓwet, akuɗang mo ɓwet mo. ");
INSERT INTO sur_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kaaɗe par cìn, ɓǝ nenseet nɗang Jesu mo sat mPool kǝ Silas, kǝn mmo dǝm nyil mBeriya. Kaaɗe mo dǝm wul mBeriya, ɓǝ mo ɗel nɗǝǝn lu Naan mǝ nnen Yahudi mo. ");
INSERT INTO sur_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nen Yahudi ɗe mon mBeriya, mo kǝ ɗyen met nnen Yahudi ɗe mon nTasoloni, mbǝɗe mo kǝlǝngkar nǝ shi pǝtuup mǝndong rǝret, ɗang mo nkaa bǝlǝp pwoo Naan, shidaar shidaar mbǝkǝ mmo naa ɗi nǝ, kyet pwoo ɗe Pool sat mo azeen aa? ");
INSERT INTO sur_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nen Yahudi mo ɗes mo shinzeen, kǝ pak nnen Heleni mo ɗes mo shinzeen, daas mo kǝ pak shurep ɗǝnan-nan mo zak. ");
INSERT INTO sur_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ɗangɓǝ kaaɗe nnen Yahudi ɗe mon nTasoloni, mo kǝlǝng nǝ, Pool nkaa sat pwoo Naan nɗǝǝn yil mBeriya. Yaksǝ mo dǝm kar ɗuu mǝ gurum ɗe mon nyil mBeriya nǝ, mbǝkǝ mmo yool kǝ lek nkaa Pool kǝ Silas zak. ");
INSERT INTO sur_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Abet, ɓǝ nenseet nɗang Jesu mo lep Pool dǝm mpwoo Am kuur ɗang Silas kǝ Timoti mo pan yém ɗi nyil mBeriya nǝ. ");
INSERT INTO sur_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nen ɗe mo dǝm ɓwet Pool, mo seet ndangshak kǝ wur ɓǝ mo dǝm wul Atens. Ɓǝ mo baa nyil mBeriya ashak kǝ lep mǝ Pool pǝ Silas kǝ Timoti nǝ, mo dǝm kat ɗyin kǝkǝlak. ");
INSERT INTO sur_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kaaɗe Pool nkaa ɗarnaa jì Timoti mpee nkaam Atens nǝ, ɓǝ nǝ daampee nwur zam, mbǝɗe wur naa pee nkaam nǝ gam kǝ kùm mo koo a pee ɗǝɗangyi. ");
INSERT INTO sur_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yaksǝ Pool bǝlǝp shii pwoo Naan nǝ ashak kǝ nnen Yahudi mo, kǝ nnen Heleni ɗe mo kǝ seyil nNaan, nɗǝǝn lu Naan mǝ nnen Yahudi nǝ mo, kǝ wur satpwoo Naan nɗes gurum ɗe mo kǝ jì nɗǝǝn lutuk zak. ");
INSERT INTO sur_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yaksǝ pak nnen Ipikuriyan mo, kǝ nnen Stoyik mo, des ɗesǝ mo a nenman mo. Mo kaat kǝ Pool, ɓǝ mo ɗoom ɓeetshik kǝ wur. Yaksǝ pak mo sat nǝnee, <<Ngulupwoo buu koo mwen sǝ, kǝ reɓet sat a miyi?>> Ɗang pak mo sat nǝnee, <<Muu kǝlǝng koo wur leshap a nkaa mee Naan ɗecì mo sǝ.>> Mo leshap ɗesǝ, a mbǝɗe Pool nkaa satpwoo ɗeret nkaa Jesu, kǝ yool a peemúut zak. ");
INSERT INTO sur_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mo yaa Pool, ɓǝ mo kàa kǝ wur a peekuur ɗe mo kǝ pet a Ariyopagus, ɓǝ mo sat nwur nǝnee, <<Muu reɓet manshii mǝ kám ɗepwoo ɗe gha nkaa leshap nkaa nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mbǝɗǝ pak mbii ɗe waa a sat nǝ mo a ɗepwoo pǝ mun ɗi, kǝzak muu reɓet manshii mo nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Nen pee nkaam Atens mo jir, kǝ mǝzep ɗe mo jì tong ɗi, mo kǝ fes reɓet kǝlǝng, kǝ leshap nkaa mbii ɗepwoo mo, ɓǝ mo le nǝ ɗee a koo ɗak sǝ.) ");
INSERT INTO sur_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pool yool ɗar a peekuur ɗe moo pet a Ariyopagus nǝ, ɓǝ wur sat mmo nǝnee, <<Wun nnen Atens mo! An pǝ naa wun a nen ɗe wuu seyil nnaan mo ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mbǝɗǝ kaaɗe an pǝ mwaan nɗǝǝn pee nkaam fuu nǝ, ɓǝ an pǝ naa mbii ɗe wuu seyil mmo shini-shinǝ. Nǝ le nghan kat mee peewus mbiizuum, ɗe mo ran-ran nkaa nǝ nǝnee, <Mbǝ Naan ɗe baa mu man wur kas.> Naan ɗe baa wu man wur kas, ɗe wuu seyil nwur sǝ, an pǝ kǝn leshap nwun a nkaa wur. ");
INSERT INTO sur_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Naan ɗewur leyil ɗesǝ, kǝ mbii ɗe mo nɗǝǝn yil nǝ jir. Wur a Daa mǝ ɗeng kǝ yil ɗesǝ, kǝ baa wur kǝ tong a nɗǝǝn lu ɗe gurum mo ɗyik shi sar mbǝ seyil nwur kas. ");
INSERT INTO sur_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Baa wur kǝ yap mee ɓam pǝ gurum kas koo dǝɓen, mbǝɗe a wur shikáa fin, kǝ shin seen kǝ nook ngurum mo, kǝ mbii mo jir zak. ");
INSERT INTO sur_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A nɗǝǝn gurum mǝndong, ɓǝ Naan le peeput mǝ gurum ɗe mo nɗǝǝn yil nǝ mo shini-shinǝ jir. Wur le kǝ mmo tong nkaa yil nǝ jir. Wur kǝ tap le ɓit nǝ mo, kǝ peekaat mǝ yil fur nǝ mo shini-shinǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Naan cìn kǝsǝ, a mbǝkǝ ngurum mo yap wur ɗi, meeɓe, mon nyap wur kat, mbǝɗe baa wur jong kǝ mun gurum kas. ");
INSERT INTO sur_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","A mbǝ ɗeɓal mǝ Naan, ɓǝ muu kat seen, kǝ muu mwaan, ɗang mun ɗe zak. Kaaɗe pak nenkook fuu mo kǝ sat sǝ nǝnee, <Mun zak, a jep wur mo.> ");
INSERT INTO sur_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kaaɗe mun a jep mǝ Naan mo sǝ, ɓǝ baa nǝ ret kǝ mmun pan nǝ, mǝse mǝ Naan nǝ a koo mbii ɗe gurum mo kǝ ɗak a shi zinariya, koo azurfa, koo ngǝk, koo mee mbii ɗe gurum mo am shi seen fur kas. ");
INSERT INTO sur_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gyet yam-yam ɓǝ baa Naan leɗyeen nkaa mwen mǝ gurum nǝ mo kas, ɗang yaksǝ, ɓǝ wur kǝ sat ngurum mo tuwap jir, koo a nɗǝǝn yil ɗǝɗang yi. ");
INSERT INTO sur_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mbǝɗǝ Naan lepuus ɗewur mbǝ tokɗyeel ngurum ɗe nɗǝǝn nyil nǝ jir, shi gwar ɗewur kǝ ten bǝlǝp. Naan wur kǝ woo langtǝng mǝnǝ ngurum mo agaak jir, mbǝɗe wur kǝ yool kǝ gwar mǝnǝ a peemúut.>> ");
INSERT INTO sur_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kaaɗe mo kǝlǝng Pool leshap nkaa yool a peemúut, ɓǝ pak mo shwar wur shi shwar mǝ ɓákpee, ɗang pak mo nǝnee. Muu reɓet kǝn nghan cin a leshap ɗi nkaa mbii ɗesǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Aasǝ ɓǝ Pool yool yit peekuur nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pak gurum nǝ mo seet nɗang wur, ɓǝ mo shinzeen. Mɓut nnen ɗe mo shinzeen nǝ, a Diyonisiyus ɗewur a memee mɓut nennan mǝ peekuur ɗe mo kǝ pet nǝ a Ariyopagus, kǝ mee mat ɗe moo petsǝm war a Damaris, kǝ pak gurum mo. ");
INSERT INTO sur_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Aɓwoon ɗesǝ, ɓǝ Pool yool yit Atens, ɓǝ wur dǝm nKoronti. ");
INSERT INTO sur_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ɓe wur kat mee ngu Yahudi, ɗe moo pet sǝm wur a Akila, ɗe mo làa wur a mPontus. Wur kǝ mat fin Priskila mo yool a Itali mo jì nKoronti nǝ. Mbǝɗe mishkoom Klodiyus sat nǝ, nen Yahudi mo jir, mo yool aku nRom. Pool dǝm pǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ɓe wur tong pǝ mo ɗi, mbǝɗe wur a nguɗak Tent koo mo sǝ, ɗang mo cìn ɗak fur ashak zak. ");
INSERT INTO sur_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Koo a parpuus Nookɗi ɗeɗangyii, ɓǝ Pool kǝ naa mɓeetshik kǝ nnen Yahudi mo, kǝ nen Heleni mo mbǝkǝ mo shinzeen ɗi. ");
INSERT INTO sur_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kaaɗe Silas kǝ Timoti mo tong mMasidoniya jì wul, ɓǝ Pool fes lekáa fin kyap, mbǝ satpwoo ɗeret nǝ, ɗang wur ɗee a langtǝng nen Yahudi mo nǝ, Jesu a Kristi. ");
INSERT INTO sur_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ɗangɓǝ kaaɗe nen Yahudi mo ciipwoo nǝ, kǝzak mo leshap ɗebuu nwur, ɓǝ wur ciir kǝɓwoon mmo, ɓǝ wur sat mmo kǝ tuup nǝnee, <<Katɗang wu murep nɗǝǝn shikbish fuu mo, ɓǝ a wun wu lesuk. Baa mee sar fen ɗiɓut kas. Yool nyaksǝ, ɓǝ an mbǝ dǝm a pǝ nen ɗe baa mo a nen Yahudi mo kas.>> ");
INSERT INTO sur_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wur yool yit lu Naan mǝ nen Yahudi nǝ mo, ɓǝ wur dǝm ɗel ntul mee gwar ɗe mo kǝ petsǝm wur a Titus Jastus. Wur a mee nguseyil nNaan, ɗe lu wur nǝ kus kǝ lu Naan nǝ. ");
INSERT INTO sur_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus ngwe ɗeɗes nlu Naan nǝ, shinzeen nDaa ashak kǝ nenlu wur mo jir. Kǝzak gurum mo ɗes nɗǝǝn nen Koronti mo, ɗe mo kǝlǝng pwoo Pool nǝ, ɓǝ mo shinzeen, yaksǝ mo cìn baptisma mmo zak. ");
INSERT INTO sur_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Parmeeci sǝ mpar, ɓǝ Daa leshap kǝ Pool nɗǝǝn suun nǝnee, <<Taji kǝǝrmuut yaa gha kas, a satpwoo nǝ, kǝzak taji a nook sat nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mbǝɗǝ an ɗi ashak kǝ gha. Baa mee gurum mmak cìn mee mbii nghan kas. Mbǝɗǝ an ɗi kǝ gurum mo ɗes nɗǝǝn pee nkaam ɗesǝ nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aasǝ ɓǝ, Pool tong nɗǝǝn pee nkaam nKoronti, mbǝ ɓit mǝndong kǝ koor, wur nkaa kámpwoo Naan ngurum mo. ");
INSERT INTO sur_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ɗangɓǝ nɗǝǝn ɓit ɗe moo le Galiyo a gofna mǝ yil Akaya, ɓǝ nnen Yahudi mo ɓalkaa ashak, ɓǝ mo yaa Pool dǝm kǝ wur pǝ nentokɗyeel mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mo sat nǝnee, <<Gwar ɗesǝ wur nkaa pǝring kǝ pan mǝ gurum mo, mbǝkǝ mmo seyil ɗi nNaan nɗǝǝn ar ɗe baa nǝ nciit kǝ Wàar nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ɗangɓǝ kaaɗe Pool ɗoom leshap, ɓǝ Galiyo ɗewur a gofna, sat nnen Yahudi nǝ mo nǝnee, <<Wun nnen Yahudi mo! Katɗang ɓǝ ɗe gwar ɗe ɗesǝ wur cìn a mee mbii ɗebish, kǝ koo ɗewur wat a mee mbii, ɓǝ yoo an mmak lekom kǝn nghan nkǝlǝng wun ɗi. ");
INSERT INTO sur_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ɗangɓǝ kaaɗe nǝ a ɓeetshik nkaa pak pwoo mo, kǝ sǝmpwoo, kǝ Wàar fuu mo, ɓǝ wu dǝm wu ɓeet mǝnǝ mbuu shikáa fuu. Baa an mbǝ reɓet ɗee a ngutokɗyeel mǝ mbii koo mǝnǝ mo sǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yaksǝ wur ceen mo shin pwat aku nɗǝǝn luɗyeel nǝ. ");
INSERT INTO sur_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mo jir mo yaa Sostenis, ngwe ɗeɗes nkaa lu Naan nǝ, ɓǝ mo nǝrem wur mpwoo luɗyeel nǝ, ɗang baa Galiyo lekáa ɗyikye kas. ");
INSERT INTO sur_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pool waa cin tong ɗi nKoronti nǝ ɗes ashak kǝ nenseet nɗang Jesu nǝ mo. Ɓǝ wur yool yit mo, ɓǝ wur ɗel nɗǝǝn tii mbǝ dǝm nyil nSiriya, ashak kǝ Priskila kǝ mish war Akila. Akuɗang Pool yool seet, ɓǝ wur sak káa fin nSenkiriya, mbǝkǝ nwur gampwoo ɗewur kǝ ten cweer nǝn nNaan nkaa shin fin. ");
INSERT INTO sur_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mo jì wul nɗǝǝn yil Afisus ɓǝ Pool yit Priskila kǝ Akila mpee mǝnǝ. Yaksǝ wur dǝm ɗel nɗǝǝn lu Naan, kǝ wur yakshii mǝ pwoo mo ashak kǝ nnen Yahudi mo. ");
INSERT INTO sur_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kaaɗe mo ɗang pǝ wur kǝ nwur pan yém ɗe pǝ mo, ɓǝ wur cíi. ");
INSERT INTO sur_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ɗangɓe kaaɗe wur yool yit mo, ɓǝ wur cweerpwoo mmo nǝnee, <<Katɗang Naan reɓet, ɓǝ an mbǝ baajì pǝ wun ɗi.>> Aasǝ ɓǝ, wur ɗel nɗǝǝn tii dǝm nAfisus. ");
INSERT INTO sur_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kaaɗe wur dǝm wul nSizariya, ɓǝ wur kàa nJerusalem, kǝ nwur tok ɗi kǝ nenseet nɗang Jesu nǝ mo. Aɓwoon mǝnǝ, ɓǝ wur dǝm Antiyok. ");
INSERT INTO sur_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Aɓwoon ɗewur pan cìn rep teer mo ɗe, ɓǝ wur yool dǝm shipee-shipee, ngaar yil nGalati, kǝ Firijiya, wur nkaa gangkwak mputuup nenseet nɗang Jesu nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mee ngu Yahudi ɗe moo petsǝm wur a Apolos, ɗe mo làa wur a nAlekzandriya, ɓe wur ji Afisus. Wur a mee nguman, ɗang wur man ɓǝǝt-haal mǝ Naan ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mo kǝ kám ar ɗe nǝ a mǝ Daa nwur, ɗang wur ɗar ɓalɓal nɗǝǝn nǝ. Wur leshap, ɗang wur kám ngurum mo nkaa Daa Jesu ndǝre-ndǝre, ɗang jir kǝsǝ, ɓe wur man a baptisma mǝ Joon ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wur ɗoom kop pwoo Naan agaak, baa ashak kǝ mee kǝǝrmuut kas, nɗǝǝn lu Naan nǝ. Kaaɗe Priskila kǝ Akila mo kǝlǝng wur, ɓǝ mo pet wur dǝm kǝ nǝ ntul fur, kǝn mmo sǝǝt kám ar mǝ Naan ɗi nwur ndǝre-ndǝre. ");
INSERT INTO sur_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos yool mbǝ dǝm Akaya, ɓe nenseet nɗang Jesu ɗe mon Afisus mo ɓam wur, shi ran lep a rǝran shin nwur pán nenseet nɗang Jesu ɗe mon nyil Akaya, mbǝkǝ mmo kaat wur ɗi, katɗang wur dǝm wul. Kaaɗe wur dǝm wul, ɓǝ wur ɓam nnen ɗe mo kǝ shinzeen mbǝ ɗeret mǝ Daa zam. ");
INSERT INTO sur_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wur gan nnen Yahudi mo ntoom kǝ gurum mo, mbǝ ɓeetshik, kǝzak wur kám ngurum mo agaak, wur nkaa leshap mmo nkaa mbii ɗe mo nɗǝǝn pwoo Naan nǝnee, <<Jesu wur a Kristi azeen-zeen.>> ");
INSERT INTO sur_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kaaɗe Apolos ɗi nɗǝǝn Koronti, ɓǝ Pool nkaa mwaan nɗǝǝn yil mo, ɓǝ wur jì wul Afisus. Yaksǝ wur jì kat pak nenseet nɗang Jesu mo ɗi mpee nkaam mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ɓǝ wur tal pǝ mo nǝnee, <<Kaaɗe dǝ wu shinzeen, ɓǝ wuu lap Riin Ɗeɓang ee?>> Mo lap nwur nǝnee, <<Hai, baa muu cam kǝlǝng mee pwoo nkaa Riin Ɗeɓang kas.>> ");
INSERT INTO sur_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wur tal pǝ mo nǝnee, <<Ɓǝ dǝ mo cìn a baptisma ɗǝɗang nwun yii?>> Mo lap nǝnee, <<A baptisma mǝ Joon.>> ");
INSERT INTO sur_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool sat mmo nǝnee, <<Baptisma mǝ Joon nǝ a mbǝ nen ɗe mo kǝ tuwap. Gyet Joon sat nnen Yahudi mo shinzeen a ngwe ɗewur mbǝ jì mɓwoon fin. A Jesu mmǝnǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kaaɗe mo kǝlǝng pwoo ɗesǝ, ɓǝ mo cìn baptisma mmo nɗǝǝn sǝm kǝ Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pool lesar fin nkaa mo, ɓǝ Riin Ɗeɓang sham nkaa mo, ɓǝ mo leshap shi liispwoo ɗecì mo, ɗang mo satpwoo Naan ngurum mo. ");
INSERT INTO sur_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nen ɗe mo lap baptisma nǝ, mo wul kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pool wur ɗel nɗǝǝn lu Naan, mbǝ tar mo kun, ɓǝ wur leshap nǝ, baa ashak kǝ kǝǝrmuut kas, kǝzak wur cìn ɓeetshik kǝ mo, ɗang wur ɗaar mbǝkǝ nwur kám ɗe mmo agaak nkaa mulki mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ɗangɓǝ pak mo cǝǝr ɓal mputuup, kǝ mmo cii shinzeen, ɓǝ mo leshap ɗebuu nkaa pwoo mǝ Naan ntoom gurum mo jir. Aasǝ ɓǝ, Pool yit mo ɗe, ɓǝ wur pǝrep nen shinzeen nǝ mo shin jì ashak. Ɓǝ koo a puus ɗeɗangyii, ɓǝ wur yakshii kǝ pwoo mo nɗǝǝn lu kam-kam ɗe mǝ Tairanus. ");
INSERT INTO sur_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Moo naa ncìn a kǝsǝ dǝm wul mbǝ ɓit vǝl. Aasǝ ɓǝ, nen ɗe mo kǝ tong nɗǝǝn yil Eshiya, nen Yahudi mo, kǝ nnen ɗe baa mo a nen Yahudi mo kas, mo jir mo kǝlǝng pwoo kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Naan le kǝ Pool cìn mbii lukshik mo ɗes, ɗe baa mo kǝ cam naa mo kas. ");
INSERT INTO sur_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nǝ le har mmo lap lee ɗewur kǝ pwes wun ɗishik, kǝ nlǝr ɗewur kǝ lep mo, kǝ mo dǝm tung nengok mo ɗishik, ɓǝ mo kat bar nɗǝǝn shwal mo mo shini-shini, kǝzak riin ɗebish mo pwat mɓut ngurum mo ɗes zak. ");
INSERT INTO sur_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɗangɓǝ mee des mo ɗi mɓut nnen Yahudi mo, ɗe moo mwaan dǝm shiyil-shiyil, kǝn mmo kǝ ceen riin ɗebish mo ɗi. Mo ɗoom leshap nnen ɗe mo kǝ riin ɗebish mo nɗǝǝn sǝm mǝ Jesu, ɓǝ mo sat nǝnee, <<Nɗǝǝn sǝm mǝ Jesu ɗe Pool kǝ leshap nkaa wur sǝ, ɓǝ an nsat ngha, a put aku.>> ");
INSERT INTO sur_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mee ɗyemnǝǝnshak mo ɗi pwoovǝl, ɗe mo a jep mee pris ɗeɗes mǝ nnen Yahudi mo, ɗi sǝm wur a Skiiva. A mo a nnen cìn mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Riin ɗebish nǝ lap mmo nǝnee, <<Wen man Jesu, kǝ wen mman Pool zak, ɗang wun a wii mo yii?>> ");
INSERT INTO sur_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɓǝ gwar ɗewur kǝ riin ɗebish nǝ, wur yool met nkaa mo, ɓǝ wur met mmo mɓal jir mo. Wur nas mo, ɗang wur le láa mmo, ɓǝ wur yilang nlǝr mmo, ɓǝ mo yool shwe pwat nɗǝǝn lu nǝ ngúm, ɓǝ toom kǝ sham mmo. ");
INSERT INTO sur_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kaaɗe mbii ɗesǝ nǝ ɗee a ɗemǝman pǝ nnen Yahudi mo, kǝ nnen Heleni mo ɗe mo kǝ tong nɗǝǝn yil Afisus, ɓǝ kǝǝrmuut yaa mo jir, ɓǝ gurum mo le ɗeɗes nsǝm kǝ Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Gurum mo ɗes mɓut nnen ɗe mo shinzeen, mo jì woo shikbish mo mo, kǝ ɗak mo ɗebish mo agaak zak. ");
INSERT INTO sur_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pak gurum mo ɗes mɓut nnen ɗe moo cìn yen ɗebish mǝ gwampee mo, mo kok ɓǝǝt-haal mǝ yen mo nǝ mo, kǝn mmo jì fwoo mo nwus ntoom gurum nǝ mo jir. Kaaɗe mo tang shool mǝ ɓǝǝt-haal ɗe mo fwo nwus nǝ mo, ɓǝ mo kat shool azurfa mo wul ngal laarpaat. ");
INSERT INTO sur_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Aasǝ ɓǝ, pwoo mǝ Daa nǝ mwaan shipee-shipee jir, nǝ le nǝ ɓal hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Aɓwoon ɗe mbii ɗesǝ mo kǝ cìn, ɓǝ Pool naa nǝ ret nǝ, kǝ nɗyin dǝm nJerusalem, ɓǝ ɗyin mbǝ yaa ar nǝ dǝm put a mMasidoniya kǝ Akaya. Ɓǝ wur sat nǝnee, <<Aɓwoon ɗe an ndǝm wul nJerusalem, ɓǝ nǝ atǝng an mbǝ ndǝm nyil nRom zak.>> ");
INSERT INTO sur_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pool lep Timoti kǝ Erastus ɗe mo a nenɓam wur mo, kǝ mmo dǝm mMasidoniya akyeen wur, ɗang wur shikáa fin, wur mpan yém ɗi lee nɗǝǝn yil Eshiya nǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nciit kǝ mǝnǝ, ɓǝ gurum mo yool kǝ pwoo ɗebish ɗe nǝ daampee zam nkaa pwoo Naan nǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mee ngukǝlem, ɗewur kǝ ɗak mbii mo shi azurfa, ɗe moo pet sǝm wur a Demetriyus. Wur naa nkǝlem pak jep kùm mo, shi azurfa ɗe mo lapshak kǝ war kùm Atemis ɗeɗes nǝ, ɓǝ ɗak ɗesǝ nii jì kǝ shool nnenkǝlem nǝ mo zam. ");
INSERT INTO sur_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriyus pǝrep nenkǝlem nǝ mo jì ashak jir, kǝ nen ɗe ɗak mo nǝ mo, a koo mǝ nenkǝlem nǝ mo sǝ zak. Yaksǝ wur sat mmo nǝnee, <<Daa mo! Wu man nǝ, mmun muu kat shool ɗes a nɗǝǝn ɗak fun ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yaksǝ wun shikáa fuu, ɓǝ wu naa, kǝ wuu kǝlǝng mbii ɗe gwar ɗe moo pet wur a Pool sǝ wur kǝ cìn. Wur sat nǝ, naan ɗe gurum mo kǝ ɗak mo a shi sar, ɓǝ baa mo a naan kas koo lee lee, ɗang wur ciir kǝ pǝtuup gurum mo ɗes nɗǝǝn pee nkaam Afisus, kǝ yil ɗe mo ngaar Eshiya jir. Nǝ, taji mo seet kùm nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wu naa zak, yaksǝ baa ɗak fun nǝ kutɗi kǝ mee sǝm ɗeret kas. Baa a ɗak fun nǝ ɓejee ɗak kas, kǝ Atemis ɗeɗes, war mbǝ ɗee a mbii shwar ngurum mo, kǝ naan nǝ war shikáa fer zak. Gurum ɗe mo ngaar yil Eshiya, kǝ yil sǝ jir, mo kǝ seyil a nwar.>> ");
INSERT INTO sur_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kaaɗe mo kǝlǝng pwoo mǝnǝ, ɓǝ nǝ láa mmo mɓut zam, mo le or pwoo mǝndong, mo sat nǝnee, <<Atemis mǝ Afisus war a ɗeɗes!>> ");
INSERT INTO sur_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gurum ɗe mo nɗǝǝn pee nkaam nǝ, mo jir mo lap or nǝ zak. Gurum nǝ mo dǝm yaa Gayus kǝ Aristakus ɗe mo a nen Masidoniya mo, kǝ ɗe mo a shaar mwaan mǝ Pool, ɓǝ mo dǝm kǝ mo kǝkǝlak a peekuur. ");
INSERT INTO sur_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool reɓet dǝm ɗar akyeen gurum nǝ mo, ɓǝ nenseet nɗang Jesu mo cíi nwur. ");
INSERT INTO sur_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pak nen ɗenan-nan ɗe nyil Eshiya mo, ɗe mo a shaar Pool. Mo lep shindǝm nwur nǝ, taji wur dǝm ɗi a peekuur nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Gurum nǝ mo le or a peekuur nǝ jir, mon nkaa sat mbii mo shini-shini, mbǝɗe ɗes mǝ gurum nǝ mo, baa mo man mbii ɗe nǝ le kǝ mo kuur ashak kas. ");
INSERT INTO sur_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nen Yahudi mo le kǝn Alekzanda dǝm ɗar akyeen mǝ gurum nǝ mo, ɓǝ wur ɗiyeep sar, mbǝkǝ ngurum nǝ mo ɗok ɗi tǝtǝk, mbǝɗe wur kǝ reɓet leshap ngurum nǝ mo nǝ, baa ɗyin kǝ nen fin mo, ɗuu cìn mee mbii ɗebish kas. Mbǝɗǝ kaaɗe gurum nǝ mo naa Alekzanda kǝ ɗar akyeen, ɓǝ mo pan nǝ, a wur kǝ mbii nǝ. ");
INSERT INTO sur_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kǝzak kaaɗe mo naa nǝ, wur a ngu Yahudi, ɓǝ mo sǝǝt le or pwoo mǝndong jir, mbǝ awa vǝl. Mo nkaa sat nǝnee, <<Atemis, kǝ nǝ Afisus mo, war a ɗeɗes!>> ");
INSERT INTO sur_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kaaɗe nguran mǝ pee nkaam nǝ wur le kǝ ngurum mo ɗok tǝtǝk, ɓǝ wur sat mmo nǝnee, <<Wun nen Afisus mo! A wii nook man nǝ, a wun a nnen ɗe wun pǝ tap kǝ lu kùm mǝ Atemis ɗeɗes nɗǝǝn Afisus kas yii? Kǝzak nghǝk ɗe gyet nǝ tong aɗeng sham taa mpee ɗesǝ kas yii? ");
INSERT INTO sur_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Baa mee gurum mak cíipwoo mǝ mbii ɗesǝ mo kas. Mbǝ mǝnǝ ɓǝ nǝ ret kǝ nwun tong coot, taji wu cìn mee mbii kǝkǝlak kǝsǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wun wu jì kǝ nen ɗesǝ mo mpee ɗesǝ, ɓǝ baa mo kǝ cìn mee wat nɗǝǝn lu kùm fuu nǝ mo kas, kǝ baa mo sat mee pwoo ɗebish nkaa naan fuu ɗeɗes war kas zak. ");
INSERT INTO sur_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Katɗang Demetriyus ashak kǝ nniyee fin mo, mo kǝ mee pwoo nkaa mee gurum, ɓǝ mo dǝm kǝ pwoo nǝ nluɗyeel mpee ɗe nenɗyeel mo ɗi, mbǝkǝ mmo ɓeetpwoo nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɗangɓǝ kat wun pǝ tang a mee mbii ɗecì, ɓǝ wu ɓeetpwoo mǝnǝ a peekuur kǝ nenyil nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Azeen-zeen mun mbǝ teer ɗiɓut katɗang mo dǝm kǝ mun nluɗyeel mbǝ or ɗǝ cicinsǝ, mbǝɗe baa mun manshii mǝ mbii ɗe wun pǝ ɗyeep or nkaa nǝ kas, kǝzak, baa kuur fuu nǝ kǝ mee koop nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aɓwoon ɗewur kǝ leshap mǝnǝ, ɓǝ wur sat ngurum nǝ mo dǝm ntul mo. ");
INSERT INTO sur_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Aɓwoon ɗe or nǝ kyes, ɓǝ Pool pǝrep nenseet nɗang Jesu mo, ɓǝ wur leshap kǝ mo, mbǝ shínɓal mmo mputuup, ɓǝ wur sat ɗang mukaat mmo, ɓǝ wur yool dǝm mMasidoniya. ");
INSERT INTO sur_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wur mwaan dǝm ngaar nyil mǝnǝ mo jir, wur nkaa caa pǝtuup ngurum nǝ mo, ɓǝ wur jì wul nyil nGris. ");
INSERT INTO sur_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A mpee ɗewur cìn tar kun ɗi. Nen Yahudi mo ɓalpwoo mo ashak nkaa wur, ɓǝ kaaɗe wur mbǝ ɗel nɗǝǝn tii mbǝ dǝm nyil nSiriya, ɓǝ wur waa yaa ar nǝ a mMasidoniya. ");
INSERT INTO sur_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ɓǝ Sopata làa Pires ngu Beriya, dǝm nɗang Pool kǝ Aristakus kǝ Sekundus, ɗe mo a nnen Tasoloni mo, kǝ Gayus ngu Debi, kǝ Timoti, kǝ Tikikus, kǝ Trofimus ɗe mo a nen Eshiya mo. ");
INSERT INTO sur_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nen ɗesǝ mo shee dǝm wul nTrowas mmun akyeen, kǝn mmo ɗar naa jì fun a mpee nkaam mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mun mu ɗel nɗǝǝn tii nFilipi, aɓwoon retnyit mǝ se gǝǝl aas ɗe baa nǝ kǝ yist kas. Ɓǝ nɗǝǝn teer mo paat, ɓǝ mu dǝm mu wul pǝ mo ɗe nTrowas nǝ. Mun cìn teer pwoovǝl ɗi mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Parpuus ɗenshee mɓut nteer ɗepwoovǝl, ɓǝ mu kuur ashak mbǝ se Tong Ashak. Pool kǝ ɗak shin, mbǝkǝ daar wur yool mwaan ɗi, ɓǝ wur leshap ngurum mo. Wur naa a nleshap nǝ ɗak, dǝm wul nnaar mpar. ");
INSERT INTO sur_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mo lewus naapee mo ɗi ɗes nɗǝǝn luɗeng ɗe muu kuur ɗe nǝ. ");
INSERT INTO sur_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mee zǝlang ɗe mo kǝ pet sǝm wur a Yutikus kǝ tong mpwoo fung mǝ luɗeng nǝ, ɓǝ kaaɗe Pool naa an satpwoo Naan nǝ ɗak, ɓǝ saam ɗoom yaa Yutikus, ɓǝ saam nǝ jì met nwur mɓal, ɓǝ wur yool mpwoo fung mǝ luɗeng ɗekun nǝ, sham taa nyil, kaaɗe mo sham mang wur, ɓǝ mo kat wur kǝ muut. ");
INSERT INTO sur_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yaksǝ Pool sham zan shik fin nkaa kúm mǝ zǝlang nǝ, ɓǝ wur kup kúm nǝ, ɓǝ wur sat ngurum nǝ mo nǝnee, <<Taji nǝ daampee nwun kas, mbǝɗe wur ɗe kǝ seen.>> ");
INSERT INTO sur_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ɓǝ Pool baakàa ɗi nluɗeng nǝ, wur tep gǝǝl aas se. Aɓwoon ɗewur kǝ leshap kǝ mo har ɓit mang, ɓǝ wur yool seet. ");
INSERT INTO sur_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mo dǝm kǝ ɗyem zǝlang nǝn ntul kǝ seen, ɓǝ mo kat retnyit ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pool sat mmun nǝ, ɗyin pǝ reɓet dǝm Asos a nshii, mbǝmǝnǝ ɓǝ mun mu dǝm mu ɗel nɗǝǝn tii dǝm mu wul Asos nwur akyeen, a pee ɗe mu mang wur ɗi. ");
INSERT INTO sur_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kaaɗe wur jì kat mun Asos, ɓǝ mu mang wur nɗǝǝn tii nǝ, kǝ mu dǝm mMitilini. ");
INSERT INTO sur_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mu yool mMitilini nǝ, ɓǝ ɗaar nǝ mu dǝm mu wul kus kǝ yil nKiyos. Daar nǝ zak, ɓǝ mu jì mu wul ngaar Samos, kǝ daar nǝ zak, ɓǝ mu jì mMiletus. ");
INSERT INTO sur_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pool leɗyeen mbǝ ɗel dǝm Afisus nɗǝǝn tii nǝ, mbǝkǝ taji wur waa taa ɗee nɗǝǝn yil Eshiya kas, mbǝɗe wur reɓet wurung, mbǝkǝ kat nǝ mak cìn, ɓǝ wur wul ɗi nJerusalem parpuus Pentikos. ");
INSERT INTO sur_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kaaɗe Pool wul mMiletus, ɓǝ wur lep shindǝm nen ɗenan-nan mǝ Eklesiya ɗe Afisus mo, nǝ mo jì kat nɗyin ɗi. ");
INSERT INTO sur_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɓǝ kaaɗe mo jì wul pǝ wur ɗi, ɓǝ wur leshap mmo nǝnee, <<Wun shikáa fuu, wu man tong fen nnaar fuu peedǝ ɗi an nshee jì ɗi ngaar nyil Eshiya. ");
INSERT INTO sur_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Gyet ncìn ɗak mǝ Daa nǝ, baa a shi mee ɗiyeepkáa kas, kǝzak an kǝ shwaajeel ɗes mbǝ cìn ɗak nǝ shiɓit shiɓit, kǝ mbǝ gwak ɗe dǝ nen Yahudi mo ɓwet mbǝ an. ");
INSERT INTO sur_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wun shikáa fuu wu man zak nǝ, baa gyet nsak shii mbǝ sat mee mbii ɗe nǝ kǝkoop nwun pǝ wun ɗi kas. An mbǝ kámpwoo nkaa Jesu nwun jir agaak, kǝ an kǝ dǝm nkámpwoo nǝ nwun shilu-shilu zak. ");
INSERT INTO sur_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gyet wen kǝn sat zeen nnen Yahudi mo, kǝ nen ɗe baa mo a nnen Yahudi mo kas, ɓalɓal nǝ, nǝ ret kǝ mmo tuwap jir, kǝ mo jì pǝ Naan ɗi, kǝ mmon shinzeen ɗe nDaa fun Jesu Kristi zak. ");
INSERT INTO sur_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yaksǝ, wu naa an mbǝ dǝm nJerusalem, mbǝɗe a Riin Ɗeɓang lep an shindǝm, ɗang baa wen man mbii ɗe nǝn ndǝm kat an ɗi mpee mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ɗangɓǝ Riin Ɗeɓang kǝ kám nghan nǝ jir nɗǝǝn pee nkaam ɗeɗangyii, kǝ jeel pǝ ɗarnaa an, ɓǝ gurum mon yaa an shoot zak. ");
INSERT INTO sur_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Baa wen lesen fen nǝ kǝ mee koop nǝ pǝ an ɗi kas, ɗang an kǝn reɓet kǝ nghan kyes a ɗak ɗe Daa Jesu kǝ shin nghan mbǝ cìn nǝ. Ɗak ɗewur shin nǝ nghan nɗesǝ, kǝ nghan leshap ɗeret ɗi ngurum mo nkaa zuum mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<Yaksǝ wen man nǝ, baa memee nɗǝǝn wun, ɗe gyet an kǝn mwaan nnaar fuu, mbǝ leshap nwun nkaa yil mishkoom mǝ Naan nǝ, wun baa wu naa an ɗi kas. ");
INSERT INTO sur_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mbǝ mǝnǝ, wen kǝn sat nwun cicinsǝ nǝ, katɗang ɓǝ memee fuu muut mɓut shikbish, ɓǝ sar fen mo paat. ");
INSERT INTO sur_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mbǝɗǝ baa gyet wen nsak shii mbǝ sat pan mǝ Naan mo jir nwun kas. ");
INSERT INTO sur_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mbǝ mǝnǝ, wun nen ɗe Riin mǝ Naan kǝ le a nennaa kuur mǝ tǝm nǝ mo jir, wu tap kǝ káa fuu mo rǝret, kǝn nwun kyeer Eklesiya mǝ Naan ɗewur kǝ seet nshin shi toom mǝ káa fin. ");
INSERT INTO sur_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Wen man nǝ, aɓwoon ɗe wen kǝn seet, ɓǝ ncuwe ɗeɓyaal mo, mon njì ɗel nnaar fuu, ɓǝ baa mon nyit tǝm nǝ mo ɗe kas. ");
INSERT INTO sur_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pee nǝ pǝ jì, ɓǝ pak gurum mon nyool nnaar fuu, mo mbǝ sat pwoo ɗe mo a ɗung nkaa zeen nǝ, mbǝkǝ mmo dul nenseet nɗang Jesu mo dǝm ɗi nɗang mo. ");
INSERT INTO sur_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mbǝ mǝnǝ, ɓǝ wu tong shi gongpee, taji wu munsuk kas nǝ, gyet mbǝ ɓit mo kun, ɓǝ baa wen nook leshap nǝ nwun mpar kǝ puus ɓalɓal, kǝ yitmwaa kas. ");
INSERT INTO sur_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","<<Yaksǝ, ɓǝ wen le wun nsar Naan, kǝ pwoo ɗeret wur ɗe nǝ kǝ ɓal mbǝ ɗyik wun, mbǝkǝ nǝ shin ɗeret mǝ Naan, ɗi wur kǝ nǝ mbǝ nnen wur mo jir nwun zak. ");
INSERT INTO sur_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Baa wen kǝn coor mee azurfa, koo zinariya, koo nlǝr mǝ mee gurum kas. ");
INSERT INTO sur_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Wun shikáa fuu wu man nǝ, a shi sar fen ɗesǝ mo, ɓǝ an kǝn cìn ɗak shi mo, mbǝ mbii ɗe an kǝn reɓet mo, kǝ mbǝ mbii ɗe nnen ɗe mo ashak kǝ an mo kǝ reɓet zak. ");
INSERT INTO sur_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","An kǝn nkám nwun nɗǝǝn mbii mo jir, nǝ, a shi ɗak mǝ káa fuu mo, ɗang wun ɓam nen ɗe baa mo katɓal kas, kaaɗe muu panpwoo ɗe Daa Jesu kǝ sat shikáa fin sǝ nǝnee, <Kat gurum shin mbii, ɓǝ wur nkat ɗeret met ngwe ɗewur lap nǝ.> >> ");
INSERT INTO sur_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aɓwoon ɗe Pool sat pwoo mǝnǝ, ɓǝ wur kurum nkaa furum ashak kǝ mo jir, kǝn nwur ɗangnaan ɗi ");
INSERT INTO sur_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kaaɗe mo ɗoom sat ɗang mukaat mPool, ɓǝ mon nkaa wal, ɗang mo kǝ jì lesar nwur ntook, kǝ mo kǝ tung wur shi mishpwoo zak. ");
INSERT INTO sur_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mbii ɗe nǝ sǝǝt wàt pǝtuup mmo met jir, nǝ aapwoo ɗe Pool sat mmo nǝ, baa mon nkutɗi mbǝ naa yit fin kas. Mo dǝm ɓwet wur mpwoo tii. ");
INSERT INTO sur_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Aɓwoon ɗe muu sat ɗang mukaat mmo, ɓǝ mu ɗel nɗǝǝn tii ɓǝ mu yaa ar wur-wur mu dǝm nyil nKos. Daar nǝ, ɓǝ mu dǝm mu wul nRodes. Mu yool mpeemǝnǝ, ɓǝ mu dǝm mPatara. ");
INSERT INTO sur_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kaaɗe mu kat mee tii ɗe nǝ mbǝ canɗel mFonisha, ɓǝ mu ɗel nɗǝǝn nǝ, ɓǝ mu yool. ");
INSERT INTO sur_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kaaɗe mu naa yil nSaiprus kǝ ɗee, ɓǝ mu yit nǝ nsarkul, mu ɗel mǝ dǝm akyeen nyil nSiriya. Mu dǝm mu sham mpee nkaam nTaya, mbǝɗe tii nǝn nsham kǝ lee mo a mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kaaɗe mu katpee ɗe pak nenseet nɗang Jesu mo ɗe, ɓǝ mo sat mPool nǝ, taji wur dǝm nJerusalem kas. ");
INSERT INTO sur_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ɗangɓǝ kaaɗe puus seet fun nǝ jì wul, ɓǝ mu yool mǝ sekyeen kǝ mwaan fun. Ɓǝ nenseet nɗang Jesu nǝ mo ashak kǝ shurep fur mo, kǝ jep fur mo, mo dǝm nɗang mun mɓwoon pee nkaam nǝ, a pee ɗe mǝ kurum nkaa furum mbǝ ɗangnaan ɗi ashak kǝ mo mpwoo am kuur nǝ. ");
INSERT INTO sur_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Aɓwoon ɗe mu sat ɗang mukaat nshak, ɓǝ mmun mu ɗel nɗǝǝn tii nǝ, ɓǝ mo baa ntul. ");
INSERT INTO sur_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Yaksǝ mmun mu sekyeen kǝ mwaan fun. Mu yool nTaya, ɓǝ mu jì mǝ wul mPolemayas. Ɓǝ mu dǝm mu tok kǝ nenseet nɗang Jesu mo mpeemǝnǝ, ɓǝ mu tong ashak kǝ mo, mu teer mǝndong. ");
INSERT INTO sur_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Daar nǝ, ɓǝ mu yool, mu dǝm mu wul nSizariya, ɓǝ mu tong ntul Filip ngusat pwoo Naan ɗewur a memee mɓut nnen ɗepwoovǝl sǝ mo, ɗe gyet mo bǝlǝp mo nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filip kǝ jiraap mo feer, ɗe baa mo kǝ yool ɗyik kas. Jiraap ɗesǝ nǝ mo kǝ leshap nkaa mbii ɗe nǝ mbǝ jì. ");
INSERT INTO sur_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kaaɗe mu pan mu yém ɗe, mbǝ meeteer mo ruk, ɓǝ mee ngusatpwoo mǝ Naan ɗi sǝm wur a Agabus, wur kǝ tong nJudiya jì ɗi. ");
INSERT INTO sur_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kaaɗe wur jì pǝ mun ɗi, ɓǝ wur mang zaal ɗe Pool kǝ ɗyiin mɓwoon, ɓǝ wur ɓwoot sar kǝ shii fin mo ɗishik. Ɓǝ wur sat nǝnee, <<Riin Ɗeɓang sat nǝ, nnen Yahudi ɗe mon nJerusalem, mon ndǝm ɓwoot ngu zaal ɗesǝ nǝ a kǝsǝ zak, kǝn mmo shin wur nsar mǝ nen ɗe baa mo a nnen Yahudi mo kas.>> ");
INSERT INTO sur_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kaaɗe mu kǝlǝng pwoo mǝnǝ, ɓǝ mmun kǝ koor nǝ mo, mu ɗang pǝ Pool mbǝkǝ taji wur dǝm nJerusalem kas. ");
INSERT INTO sur_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ɗangɓǝ Pool lap nǝnee, <<A mii le ɗang wun pǝ wal, kǝn nwun wàt pǝtuup fen ɗi yii? Yaksǝ wen kǝn ɗak sen, baa a mbǝkǝ mmo ɓuɓwoot an ɗi ɓejee ɗak kas, koo a mbǝkǝ nghan muut ɗi nɗǝǝn yil nJerusalem zak, mbǝ sǝm mǝ Daa Jesu.>> ");
INSERT INTO sur_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kaaɗe baa mu mak daam wur kas, ɓǝ mu nook, ɗang mu sat nǝnee, <<Ɗee a mbii ɗe Daa Naan naa kǝ gha ɗak.>> ");
INSERT INTO sur_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aɓwoon rep meeteer mo, ɓǝ mu ɓwoot lee fun mo, kǝ mmun kàa ɗi nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Pak nen Jesu ɗe mon nSizariya mo jì nɗang mun, ɗe mo jì wul kǝ mun ntul Mason, a mpee ɗe mǝ tong ɗi. Wur a ngu Saiprus, ɗang wur a memee mɓut nenseet nɗang Jesu ɗenshee mo. ");
INSERT INTO sur_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kaaɗe mu jì mu wul nJerusalem, ɓǝ nenseet nɗang Jesu mo kaat mun shi retnyit. ");
INSERT INTO sur_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Daar nǝ, ɓǝ Pool dǝm kǝ mun pǝ Jemis ɗi, a pee ɗe nennan mǝ Eklesiya mo ɗe ashak jir. ");
INSERT INTO sur_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Aɓwoon ɗe Pool kǝ tok kǝ mo, ɓǝ wur yaa yakshii nǝ mmo ɓang-ɓang, mbii ɗe Naan le kǝn nwur cìn mo nɗǝǝn nen ɗe baa mo a nnen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Aɓwoon ɗe mo kǝlǝng pwoo nkaa mbii mǝnǝ mo, ɓǝ mo kwoop Naan hakyeng. Ɓǝ mo sat mPool nǝnee, <<Ɗyemnǝǝn fun, a naa nnen Yahudi mo ɗes hakyeng mo kǝ ɗee a nen shinzeen mo, ɗang mo fes le pǝtuup fur mo nkaa Wàar mǝ Mosis. ");
INSERT INTO sur_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Mo kǝ kǝlǝng pwoo nkaa gha nǝnee, <Waa a kám nnen Yahudi mo jir, ɗe mo kǝ tong mɓut nnen ɗe baa mo a nnen Yahudi mo kas, nǝ, mo yit Wàar Mosis mo, ɗang nǝ taji mo can jep fur mo kas, kǝzak nǝ taji mo tap kǝ mbii ɗe puun fun mo kǝ loot kǝ cìn mo kas.> ");
INSERT INTO sur_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ɓǝ, yaksǝ, ɓǝ gha arang yaksǝ yii? A lekom kǝn nghan kǝlǝng mbii ɗe mun nsat, ɗe nǝ ret kǝ nghan cìn. Mbǝɗǝ tǝng mon nkǝlǝng nǝ, aa jì. ");
INSERT INTO sur_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","A mbii ɗe muu reɓet kǝ nghan cìn nɗesǝ. Mun kǝ gurum mo feer, ɗe mo kǝ cweerpwoo nDaa Naan nkaa káa fur. ");
INSERT INTO sur_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","A dǝm ashak kǝ mo, kǝn nwun cìn mbii ɗe wun nlesuk ɗee ɗi a ɗeɓang nyit mǝ Naan. A gha nkwat shool mbǝ mbii ɗe mon ncìn jir. Ɓǝ mon mmak sak shweepkáa fur mo zak. A nɗǝǝn ar ɗesǝ, ɓǝ jir mo mman nǝ, baa mee zeen mɓut pwoo ɗe mo kǝ sat nkaa gha nǝ kas, mbǝɗe gha shikáa fwaa aa tap kǝ Wàar mǝ Mosis nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mbǝ nnen ɗe mo shinzeen ɗe baa mo a nnen Yahudi mo kas, ɓǝ mu ten mulep a rǝran mmo, nkaa pwoo ɗe gyet mu yool mu ɗar nkaa nǝ, nǝ, taji mo se mee mbiise ɗe mo kǝ ten shin nkùm kas, kǝ taji mo se toom kas, kǝzak taji mo se long ɗe mo miyoor took nnǝ kas, kǝ taji mo cin ngaa kas.>> ");
INSERT INTO sur_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Daar nǝ, ɓǝ Pool seet ashak kǝ des ɗefeer nǝ mo, kǝ mmo cìn mbii ɗe mon nlesut ɗee ɗi a ɗeɓang nyit mǝ Naan. Yaksǝ wur ɗel nɗǝǝn Lu Naan Ɗeɗes nǝ, mbǝkǝ nwur sat ɗi ngurum mo, puus ɗe mon nlesut ɗee a ɗeɓang nǝn nkyes ɗi, parpuus ɗe koo a wii, ɓǝ wur nshin mbiizuum mbǝ shik. ");
INSERT INTO sur_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kaaɗe teer ɗepwoovǝl nǝ mo kus kǝgam, ɓǝ pak nnen Yahudi ɗe mo kǝ tong Eshiya mo jì naa Pool nɗǝǝn Lu Naan ɗeɗes, ɓǝ mo kar, kǝzak mo lepshii nkuur mǝ gurum nǝ mo jir, ɓǝ mo yaa Pool. ");
INSERT INTO sur_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Moo le or, ɓǝ mon nkaa sat nǝnee, <<Wun nnen Isreil mo, wu ɓam mun! Wu naa gwar ɗe dǝ wur dǝm shipee-shipee nɗǝǝn yil nǝ mo, mbǝkǝ nwur kám ngurum mo, kǝn mmo ɓák mun nnen Isreil mo ɗe, kǝ Wàar mǝ Mosis mo, kǝ Lu Naan ɗeɗes sǝ zak. Baa a mǝnǝ ɓejee ɗak kas, wur kǝ ɗel kǝ pak nnen ɗe baa mo a nnen Yahudi mo kas nɗǝǝn Lu Naan ɗeɗes zak. Wur kǝ le Lu Naan ɗeɗes nǝ ɗee a ɗebuu.>> ");
INSERT INTO sur_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mo leshap ɗesǝ, a mbǝɗe mo kǝ naa Trofimus ngu Afisus ashak kǝ wur nɗǝǝn pee nkaam, ɓǝ mo pan nǝ, ntong a Pool kǝ jì kǝ wur nɗǝǝn Lu Naan ɗeɗes nǝ. ");
INSERT INTO sur_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɓǝ nen pee nkaam nǝ mo yool jir, gurum nǝ mo shwe jì kuur ashak abet, koo a nkoop pee ɗeɗangyii, mo yaa Pool, ɓǝ mo fee wur put mɓwoon Lu Naan ɗeɗes nǝ, ɓǝ mo shoot pwoolu nǝ mo abet-abet. ");
INSERT INTO sur_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kaaɗe mo nkaa tangpee tu Pool, ɓǝ ngwe ɗeɗes mǝ shiitoon mǝ nnen Rom mo, kǝlǝng nǝ, Jerusalem nǝ gam kǝ or ɗes zam. ");
INSERT INTO sur_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Abet-abet ɓǝ wur pǝrep shiitoon mo, kǝ pak ɗǝnan-nan mǝ shiitoon nǝ mo, ɓǝ mo shwe dǝm pǝ nen ɗe mo yaa Pool ɗi. Kaaɗe mo naa ngwe ɗeɗes nǝ kǝ shiitoon mo, ɓǝ mo nook nǝrem Pool. ");
INSERT INTO sur_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yaksǝ ngwe ɗeɗes nǝ jì kus kǝ Pool, ɓǝ wur yaa Pool, wur le kǝ mmo ɓwoot Pool shi shoolbǝring mo vǝl. Wur tal nǝnee, <<Gwar ɗesǝ wur a wii? Kǝzak wur cìn a mii?>> ");
INSERT INTO sur_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Yaksǝ kuur mǝ gurum nǝ mo le or. Pak mo nkaa sat mee mbii, ɗang pak mo nkaa sat mee mbii ɗecì mo zak. Kaaɗe baa ngwe ɗeɗes nǝ wur mak manshii mǝ mbii ɗe nǝ le kǝn ngurum nǝ mo kǝ ɗyeep ɗoo ɗes kas, ɓǝ wur le kǝ mmo dǝm kǝ wur mpeetong mǝ shiitoon mo. ");
INSERT INTO sur_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kaaɗe mo jì wul a pee kǝkàa mpwoo lu nǝ, ɓǝ shiitoon mo mang wur ɗiyeep aɗeng mbǝɗe kuur mǝ gurum nǝ mo ɗee a koo nentar mo sǝ. ");
INSERT INTO sur_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mo nkaa ɗiyeep ɗoo ɓǝ, mo nkaa sat nǝnee, <<Wu tu wur, wu tu wur!>> ");
INSERT INTO sur_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kaaɗe mo nkaa ɗel kǝ Pool nɗǝǝn peetong mǝ shiitoon nǝ mo, ɓǝ wur sat ngwe ɗeɗes mǝ shiitoon nǝ mo nǝnee, <<Kyet a mmak yit nghan nsat mee mbii ɗi nghan wo?>> Ngu taakyeen nǝ tal pǝ wur nǝnee, <<A man pwoo mǝ nnen Heleni mo ee? ");
INSERT INTO sur_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tan! Baa a gha a ngu Ijip ɗe gyet nɗǝǝn meeteer ɗeɗel sǝ mo, ɓǝ wur ɓwetɓeer nkaa gwomnati, ɗewur dul gurum mo ngal feer, dǝm nɗang shin a naaryil, mbǝ twe gurum mo sǝ kas ee?>> ");
INSERT INTO sur_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool lap nwur nǝnee, <<An a ngu Yahudi. Mo làa an a nTarsus nɗǝǝn yil nSilisiya. An a laayil mǝnǝ, ɗe nǝ a mǝ man nkòo a wii. An pǝ ɗang pǝ gha, a shínpee nghan nleshap ɗi kǝ kuur mǝ gurum nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ngu taakyeen nǝ wur shínpee nwur. Yaksǝ Pool ɗar nkaa pee kǝkàa nǝ, wur ɗiyeep sar nkuur mǝ gurum nǝ mo, mbǝkǝ mmo ɗok ɗe tǝtǝk. Kaaɗe mo ɗok tǝtǝk, ɓǝ wur leshap ngurum nǝ mo shi liispwoo Hiburu. Wur sat mmo nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","<<Ɗyemnaa mo, kǝ puun fen mo, wu lekom kǝn nwun kǝlǝng an ɗi, kǝn nghan leshap ɗe nwun agaak, ɗe nenkám nǝ, baa wen kǝn cìn mee mbii ɗebish kas.>> ");
INSERT INTO sur_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kaaɗe mo kǝlǝng wur leshap mmo a shi liispwoo Hiburu, ɓǝ mo sǝǝt ɗok tǝtǝk. Yaksǝ Pool sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","<<An a ngu Yahudi, ɗe mo làa an a nTarsus mǝ yil nSilisiya. Ɗangɓǝ nwurang a nɗǝǝn pee nkaam ɗesǝ. An nkam tang ran a nsar mǝ Gamaliyel. Mo kǝ tap kám nghan rǝret hakyeng nɗǝǝn Wàar ɗe mo a mǝ puun fun mo, ɗe an kǝ zuur ɗes zam mbǝ cìn ɗak Naan, koo wun sǝ. ");
INSERT INTO sur_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nǝ le gyet wen kǝn shinjeel ɗes, nnen ɗe mo kǝ seet nɗang Jesu Kristi, kǝzak, wen kǝn twe pak mo, ɗang kǝn mɓwoot shurep mo kǝ daas mo, ɗe nle mo nlushoot. ");
INSERT INTO sur_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Koo a pris ɗeɗes sǝ, kǝ nen ɗenan-nan ɗesǝ mo, ɓǝ mon mmak ɗar langtǝng fen, nǝ pwoo ɗe an pǝ sat nǝ azeen. Mbǝɗǝ gyet wen kǝn lap ɓǝǝt-haal a pǝ mo, mbǝkǝ nghan ndǝm kǝ nǝ nɗyemnǝǝn fun nnen Yahudi mo, ɗe mo kǝ tong nɗǝǝn Damaskus, kǝ nghan nyak nenseet nɗang Jesu, ɗe mo kǝ tong pee nkaam mǝnǝ. Mbǝkǝ nghan jì ɗi kǝ mo nJerusalem a ɓuɓwoot, kǝn mmo shinjeel ɗi mmo.>> ");
INSERT INTO sur_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Kaaɗe an a ar yoo mwaan nǝ, ɓǝ jì nwul kus kǝ Damaskus, koo puus a naar sǝ. Nnen mman, ɓǝ mee peeɓang ɗeɗes, tong aɗeng sham ɓangpee ɗe an ɗi cǝǝrkaat. ");
INSERT INTO sur_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Yaksǝ ntaa nyil, ɓǝ kǝlǝng mee ɗoo nǝ pǝ sat nghan nǝnee, <Sool, Sool, a mii le ɗang aa shin jeel nghan yii?> ");
INSERT INTO sur_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ɓǝ ntal nǝnee, <A gha wii Daa?> ɓe wu sat nghan nǝnee, <A an Jesu ngu Nazaret ɗe gha nkaa shinjeel nghan.> ");
INSERT INTO sur_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nen ɗe mo ashak kǝ an, mo naa peeɓang nǝ, ɗang baa mo kǝlǝng ɗoo mǝ ngwe ɗewur leshap kǝ an nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ɓǝ ntal nǝnee, <Daa, waa a reɓet kǝn nghan cìn a mii?> Yaksǝ Daa sat nghan nǝnee, <A yool a dǝm nDamaskus, a mpeemǝnǝ ɓǝ mon nsat mbii mo nghan jir, ɗe an kǝn nle mo mbǝkǝ gha cìn ɗi.> ");
INSERT INTO sur_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wen ncǝǝr nɗee a vum, mbǝ ɓal mǝ peeɓang nǝ. Ɓǝ nen ɗe mo ashak kǝ an, mo yaa sar nghan, ɓǝ mo dǝm kǝ an nDamaskus. ");
INSERT INTO sur_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Mee gwar ɗi ɗe mo kǝ petsǝm wur a Ananiyas, wur a mee nguseet ndang Naan, ɗewur kǝ cìn mbii ɗe Wàar Mosis moo sat rǝret. Nnen Yahudi ɗe mo kǝ tong nDamaskus jir, moo shin ɗeɗes nwur. ");
INSERT INTO sur_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wur jì ɗar kus kǝ an, ɓǝ wur sat nghan nǝnee, <Ɗyemnǝǝn fen Sool, a naapee> Abet-abet ɓǝ nnaapee, ɗe nǝ le nghan nnaa wur. ");
INSERT INTO sur_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ɓǝ wur sat nghan zak nǝnee, <Naan mǝ puun fun mo, kǝ bǝlǝp gha, mbǝkǝ nghan man mbii ɗe Naan kǝ reɓet kǝn gha cìn ɗi, kǝ mbǝkǝ nghan naa Ngwe ɗe ndǝre sǝ, kǝ nghan kǝlǝng ɗoopwoo wur ɗi zak. ");
INSERT INTO sur_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mbǝɗǝ gha mbǝ ɗee a langtǝng wur, mbǝkǝ nghan leshap ɗi ngurum mo nkaa mbii ɗe aa naa, kǝ mbii ɗe aa kǝlǝng zak. ");
INSERT INTO sur_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yaksǝ, ɓǝ aa yap a mii? A yool kǝn mmo cìn baptisma ɗe ngha, Mbǝkǝ nghan ɗang ɗi nɗǝǝn sǝm mǝ Daa, kǝn nwur vwang shikbish fwaa mo ɗi.> >> ");
INSERT INTO sur_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Kaaɗe waa baa nji nJerusalem, ɓǝ an nkaa ɗangnaan nɗǝǝn Lu Naan ɗeɗes, ɓǝ nsuun suun. ");
INSERT INTO sur_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","An naa Daa, ɓǝ wur sat nghan nǝnee, <A yool nkyen, a put aku nɗǝǝn Jerusalem nǝ, mbǝɗe baa mon lap langtǝng ɗe gha mbǝ sat nǝ nkaa an kas.> ");
INSERT INTO sur_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ɓǝ nlap nǝ, daa, mo shikáa mo, mo man nǝ, gyet an kǝn ɗel nkòo a lu Naan ɗeɗangyii, mbǝkǝ nghan twe nen ɗe mo shinzeen ngha, kǝ gyet an kǝn nǝrem mo zak. ");
INSERT INTO sur_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kǝzak, kaaɗe gyet mo tu Stivin ngusatpwoo fwaa, ɓǝ gyet an kǝn ɗar ɗi zak, ɗang gyet an aɓwoon mǝ mbii ɗe mo cìn nǝ jir, ɗe gyet a an nyaa leelep mǝ nen ɗe mo tu Stivin nǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ɓǝ Daa sat nghan nǝnee, <A yool a dǝm, mpeeɗe an mbǝ lep gha dǝm jong-jong, pǝ nen ɗe baa mo a nnen Yahudi mo kas.> >> ");
INSERT INTO sur_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kuur mǝ gurum nǝ mo lekom pǝ kǝlǝng Pool ɓǝ jì wul mpwoo ɗewur sat nǝ, ɗangɓǝ mo waa baa ɗyeep ɗoo ɗi zak, mo sat nǝnee, <<Wu tu wur! Wu tu wur! Wu baa kǝ gwar ɗe mǝnǝ aku nɗǝǝn yil nǝ. Baa nǝ ret kǝ mmo yit gwar ɗe mǝnǝ ɗi mmeen kas!>> ");
INSERT INTO sur_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kaaɗe mo nkaa ɗyeep ɗoo nǝ, kǝ mo nkaa taat leelep fur mo shin kaa aɗeng, ɗang mo nkaa woo ǝrong kaa kǝ nǝ aɗeng zak. ");
INSERT INTO sur_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yaksǝ ngwe ɗeɗes mǝ shiitoon mo, le kǝn mmo ɗel kǝ Pool nɗǝǝn lu ɗe a peetong mǝ shiitoon nǝ mo. Wur le kǝ mo cam Pool shi mbwat, mbǝkǝ nwur mak manshii mǝ mbii ɗe nǝ le kǝ nkuur gurum nǝ mo kǝ ɗyeep ɗoo ɗi nkaa wur. ");
INSERT INTO sur_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ɗangɓǝ kaaɗe mo ɓwoot wur shi teng shim, mbǝkǝ mmo shin mbwat ɗi nwur, ɓǝ Pool sat mmee ɗeɗes mǝ shiitoon nǝ mo, ɗewur ɗar kus kǝ wur nǝnee, <<Tan, kyet nǝ a ndǝre kǝn nwun shin mbwat ngwe ɗewur a ngu Rom, ɓǝ baa mo kǝ tok mee ɗyeel ɗe nǝ yaa wur kas aa?>> ");
INSERT INTO sur_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kaaɗe shiitoon ɗeɗes kǝlǝng pwoo mǝnǝ, ɓǝ wur dǝm sat ngwe ɗeɗes mǝ shiitoon nǝ mo nǝnee, <<Aa reɓet cìn a mii ngwar ɗesǝ yii? Gwar ɗesǝ nǝ wur a ngu Rom.>> ");
INSERT INTO sur_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ɓǝ ngwe ɗeɗes nǝ wur jì sat mPool nǝnee, <<A sat an azeen-zeen, gha a ngu Rom ee?>> Yaksǝ wur lap nǝnee, <<Kǝzak an a ngu Rom!>> ");
INSERT INTO sur_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ɓǝ ngwe ɗeɗes nǝ sat nwur nǝnee, <<Gyet wen nkwat a shool ɗes, akuɗang ɓǝ wen ɗee a nguyil nRom nǝ.>> Pool sat nǝnee, <<Ɗang mo làa wen a ngu Rom.>> ");
INSERT INTO sur_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mbǝ mǝnǝ ɓǝ nen ɗe mo kǝ reɓet cìn tal pǝ wur ɗe, mo yool abet ɓǝ mo yit wur mbǝshin. Kaaɗe ngwe ɗeɗes nǝ man nǝ, Pool a ngu Rom, ɓǝ kǝǝrmuut yaa wur hakyeng, mbǝɗe wur kǝ ten ɓwoot wur. ");
INSERT INTO sur_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ɗangɓǝ daar nǝ, ɓǝ ngwe ɗeɗes nǝ reɓet man zeen mǝ mbii ɗe nǝ le kǝ nnen Yahudi mo reɓet yaa wur nǝ. Yaksǝ wur fwen Pool, wur le kǝn mmo pǝrep pris ɗenan mo, kǝ nenɗyeel mo, mo kuur ashak jir, ɗang wur dǝm le Pool ɗar ntoom nenɗyeel nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pool ban yit nkaa nenɗyeel nǝ mo, ɓǝ wur sat mmo nǝnee, <<Ɗyemnaa mo, an kǝn ncìn ɗak mǝ Naan a shi pan kǝ pǝtuup fen ɗe nǝ a nɗe ndǝre ntoom mǝ Naan jiwul nCicinsǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kaaɗe Ananiyas, pris ɗeɗes kǝlǝng pwoo mǝnǝ, ɓǝ wur sat nnen ɗe moo ɗar kus kǝ Pool, kǝ mmo shweer wur mpwoo. ");
INSERT INTO sur_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ɓǝ Pool sat nwur nǝnee, <<Naan nshweer gha zak, gha a koo shiɓutlu ɗe mo pwes shi tweep piyaa piyaa sǝ. Waa aa tong mbǝkǝ nghan tokɗyeel ɗi nghan shi wàar nǝ mo, ɗang a gha waa ciir a tep wàar nǝ zak. Mbǝɗǝ a gha sat nǝ mo shweer an.>> ");
INSERT INTO sur_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nen ɗe moo ɗar ɗi a pee nǝ, mo sat mPool nǝnee, <<Waa aa fǝlǝp a pris ɗeɗes mǝ Naan mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool sat nǝnee, <<Ɗyemnaa mo, baa wen mman nǝ, wur a pris ɗeɗes mǝ Naan kas, mbǝɗe mo kǝ ten ran nɗǝǝn ɓǝǝt-haal mǝ Naan nǝnee, <Taji a sat mee pwoo ɗebish nkaa ngwe ɗeɗes ɗewur nkaa nen fwaa mo kas.> >> ");
INSERT INTO sur_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kaaɗe Pool man nǝ, pak mo nɗǝǝn nenɗyeel nǝ mo a nnen Sadusi mo, kǝ pak mo a nnen Farisi mo, ɓǝ wur ɗiyeep ɗoo nɗǝǝn luɗyeel nǝ. Wur sat nǝnee, <<Ɗyemnaa mo, an a ngu Farisi, ɗang a ngu Farisi làa an zak. A mbǝɗe wen shinzeen nǝ, gurum mon nyool a peemúut, a nǝ le ɗang mo mbǝ tokɗyeel nghan nɗesǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kaaɗe Pool sat pwoo mǝnǝ, ɓǝ ɓǝlep yool nnaar nnen Farisi mo, kǝ nnen Sadusi mo, ɓǝ kuur kǝ gurum nǝ mo ɓak sut vǝl. ");
INSERT INTO sur_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nen Sadusi moo sat nǝ baa gurum mon nyool a peemúut kas, kǝ baa mee nenlep mǝ Naan mo ɗi kas, kǝ baa mee mǝ riin mo ɗe kas zak, ɗang nnen Farisi mo shinzeen nǝ mbii ɗesǝ mo ɗe jir. ");
INSERT INTO sur_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɓǝ or ɗeɗes yool ɗi nɗǝǝn luɗyeel nǝ. Pak nenkám Wàar mǝ Mosis ɗe mo a nnen Farisi mo, mo yool ɗar atǝng, mo yaa ɓeetshik ɗes hakyeng. Mo sat nǝnee, <<Baa mu naa mee mbii ɗebish nɗǝǝn gwar ɗesǝ kas, ngul a mee riin, koo a mee ngulep mǝ Naan leshap kǝ wur.>> ");
INSERT INTO sur_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kaaɗe ɓeetshik nǝ naat zam, ɓǝ ngwe ɗeɗes kǝǝr nǝ, mon nyool tu Pool, ɓǝ wur lep shiitoon mo dǝm dul wur ɓalɓal shin put nɗǝǝn luɗyeel nǝ, kǝ mmo dǝm kǝ wur a mpeetong mǝ shiitoon nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Parmǝnǝ mpar, ɓǝ Daa jì woo shin mPool, ɓǝ wur sat nǝnee, <<Taji kǝǝrmuut yaa gha kas, kaaɗe aa leshap ngurum mo nkaa an nɗǝǝn Jerusalem kǝ kaaɗe a ɗee a langtǝng nkaa an sǝ, ɓǝ tǝng gha mbǝ dǝm a leshap ngurum mo nkaa an nɗǝǝn Rom a kǝsǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Daar mɓít, ɓǝ pak nnen Yahudi mo ɓalpwoo mo shi ɓal ashak, kǝ mmo ɓǝlemcuk shi toom nɗǝǝn sǝm mǝ Naan nǝ, baa ɗun nse mee mbii, koo shwaa mee am kas, tǝng ɗun tu Pool akuɗang. ");
INSERT INTO sur_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nen ɗe mo ɓalpwoo ashak mbǝ tu Pool nǝ, mo met nlaarfeer. ");
INSERT INTO sur_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yaksǝ mo jì pǝ pris ɗenan mo, kǝ nen ɗenan-nan mo, mo sat nǝnee, <<Mun muu ɓalpwoo fun ɓalɓal ashak, kǝ mmun tuweer nɗǝǝn sǝm mǝ Naan nǝ, baa mun cam mee mbiise kas, tǝng mun tu Pool akuɗang. ");
INSERT INTO sur_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","<<Mbǝ mǝnǝ yaksǝ, wun kǝ nenɗyeel mo jir, wu sat ngwe ɗeɗes, kǝn nwur jì kǝ Pool pǝ wun ɗi, koo wuu tang a naa pwoo wur nǝ ɗi rǝret sǝ. Mun mun ten mu ɗak sun, mbǝkǝ mun taa mu tu wur ɗi a ar, akuɗang wur jì wul pǝ wun ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɗangɓǝ kǝn Pool, kǝlǝng pwoo ɗe mo sat nkaa loom ndǝm mo pǝkom ar nǝ, ɓǝ wur dǝm ɗel nɗǝǝn Peetong shiitoon nǝ mo, ɓǝ wur woo pwoo mǝnǝ mPool. ");
INSERT INTO sur_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Yaksǝ Pool pet memee mɓut ɗenan mǝ shiitoon nǝ mo, ɓǝ wur sat nǝnee, <<A dǝm kǝ làa zǝlang ɗesǝ pǝ ngwe ɗeɗes ɗi, mbǝɗe wur kǝ mee pwoo ɗewur kǝ reɓet sat nǝ ngwe ɗeɗes.>> ");
INSERT INTO sur_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mee ɗeɗes nkaa shiitoon nǝ mo, wur mang làa zǝlang nǝ, wur dǝm kǝ wur pǝ ngwe ɗeɗes ɗi, ɓǝ wur sat nǝnee, <<A Pool ɗewur a ɓuɓwoot sǝ, a wur pet an, kǝn nwur ɗang pǝ an, kǝn nghan njì kǝ làa zǝlang ɗesǝ pǝ gha ɗi. Nǝ, làa nǝ wur kǝ mee pwoo ɗewur kǝ reɓet sat nǝ ngha.>> ");
INSERT INTO sur_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ɓǝ ngwe ɗeɗes nǝ yaa sar làa zǝlang nǝ, wur dǝm kǝ làa zǝlang nǝ mmee koop mbǝshin. Yaksǝ wur tal pǝ làa zǝlang nǝ coot nǝnee, <<Waa aa mee pwoo ɗǝɗang ɗe aa reɓet sat nǝ nghan yii?>> ");
INSERT INTO sur_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Làa zǝlang nǝ sat nǝnee, <<A nnen Yahudi mo kǝ ɓalpwoo mo ashak nǝ, mo mbǝ jì ɗang pǝ gha, mbǝkǝ daar a dǝm ɗi kǝ Pool a pee ɓeetpwoo. Mo mbǝ cìn koo mo a mbǝ baa naa pwoo nǝ ɗi rǝret sǝ. ");
INSERT INTO sur_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Taji a reɓet mmo kas, mbǝɗe gurum mo met nlaarfeer mɓut mmo, mo kǝ lǝǝm a ar, mo mbǝ yap Pool dǝm. Mo kǝ ɓǝlemcuk shi toom nɗǝǝn sǝm mǝ Naan nǝ, baa ɗun nse, koo shwaa mee mbii kas, tǝng ɗun ntu Pool akuɗang. Yaksǝ mo kǝ ɗak sut, moo ɗar naa a ɗe gha mbǝ lep Pool shindǝm ɓejee.>> ");
INSERT INTO sur_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Aɓwoon mǝnǝ, ɓǝ ngwe ɗeɗes nǝ wur ɓwet làa zǝlang nǝ shinseet, ɓǝ wur sat làa zǝlang nǝ nǝnee, <<Taji a woo mmee gurum nǝ aa leshap ɗesǝ nǝ nghan kas.>> ");
INSERT INTO sur_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Aɓwoon mǝnǝ, ɓǝ ngwe ɗeɗes nǝ pet mee ɗǝnan-nan mǝ shiitoon mo vǝl, ɗe mo kǝ tap shiitoon mo kambil kambil. Wur sat mmo nǝnee, <<Wu le shiitoon mo kambil vǝl, kǝ shiitoon mǝ lang bǝring mo laarpwoovǝl, kǝ shiitoon mǝ lek lek shi kop mo kambil vǝl zak. Mbǝkǝ mmo dǝm nSizariya, koo naapuus pwoofeer ɗe mǝ par cicinsǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wur sat kǝn mmo le mee bǝring ɗe nǝn mang Pool, mbǝkǝ mo seet kǝ wur ryang pǝ gofna Feliks ɗi. ");
INSERT INTO sur_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ngu taakyeen nǝ ran mee lep a rǝran shindǝm ngofna Feliks, ɗe nǝ sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","<<Tokshik nsar ngwe ɗeɗes Klodiyus Lisiyas, dǝm pǝ ngwe ɗeɗes gofna Feliks ɗi. ");
INSERT INTO sur_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nnen Yahudi mo kǝ yaa gwar ɗesǝ, ɗang dǝ mo yappee ɗe mon ntu wur ɗi, a kǝsǝ ɓǝ a, an ndǝm kǝ shiitoon mo, ɓǝ a an mɓam wur, mbǝɗe nkǝlǝng nǝ, wur a ngu Rom. ");
INSERT INTO sur_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kaaɗe an pǝ reɓet manshii mǝ mbii ɗe nǝ le ɗang mo yaa wur, ɓǝ ndǝm kǝ wur nɗǝǝn luɗyeel mo. ");
INSERT INTO sur_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yaksǝ nkat mo yaa wur a mbǝ pak mbii ɗe mo nɗǝǝn Wàar mo mo, ɗang pwoo ɗe mo sat nkaa wur nǝ, ɓǝ baa nǝ mak muut nwur, koo nǝ le kǝ mo shoot wur kas. ");
INSERT INTO sur_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ɓǝ kaaɗe nkǝlǝng nǝ pak nnen Yahudi nǝ mo kǝ ɓalpwoo mo mbǝ tu gwar nǝ, ɓǝ nlep wur shindǝm pǝ gha ɗi abet. An kǝn nsat nnen ɗe mo kǝ pwoo nkaa wur nǝ, kǝn mmo dǝm leshap ɗe mo kǝ nǝ nkaa wur ɗi ntoom fwaa.>> ");
INSERT INTO sur_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aasǝ ɓǝ shiitoon nǝ mo mang Pool, kaaɗe mo kǝ sat mmo sǝ, mo dǝm kǝ wur Antipatris mpar. ");
INSERT INTO sur_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Daar nǝ, ɓǝ mo yit kǝn nnenbǝring mo dǝm kǝ wur, kǝn nnenshii mo waa baa ɗi a peetong shiitoon nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kaaɗe nenbǝring ɗesǝ nǝ mo dǝm wul nSizariya, ɓǝ mo shin Pool kǝ lep ɗi a rǝran nǝ ngofna. ");
INSERT INTO sur_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kaaɗe gofna tang lep ɗi a rǝran nǝ, ɓǝ wur tal pǝ Pool nǝnee, <<Waa a put a nkoop yil ɗeɗangyii>> Ɓǝ kaaɗe wur kǝlǝng nǝ Pool put a nkoop nSilisiya, ");
INSERT INTO sur_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Yaksǝ gofna nǝ sat nǝnee, <<An mbǝ kǝlǝng pwoo fwaa nǝ, katɗang nen ɗe mo pungwool fwaa nǝ mo jì wul.>> Wur le kǝn mmo shoot Pool nkoop tul mǝ mishkoom Herot. ");
INSERT INTO sur_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Aɓwoon meeteer mo paat, ɓǝ Ananiyas pris ɗeɗes, jì ashak kǝ pak pris ɗenan mo, kǝ mee Nguɓerepdyeel ɗe sǝm wur a Tartulus, mo dǝm kǝ ɗyeel nkaa Pool pǝ gofna ɗi. ");
INSERT INTO sur_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kaaɗe mo pet Pool, ɓǝ Tartulus ɗoom leshap nkaa Pool nǝnee, <<Waa Feliks ngwe ɗeret met jir. A mbǝ gha, ɗang muu tongriyang, hakyeng, kǝ a mbǝ ɗak ɗeret fwaa mo zak, ɗang yil fun ɗesǝ nǝ ɗee a ɗe ɗak, koo a mpee ɗeɗangyii. ");
INSERT INTO sur_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mbii ɗe a cìn nǝ mo, ɓǝ mu plang ɗes zam, koo a nii, ɓǝ gurum moo plang gha. ");
INSERT INTO sur_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ɗangɓǝ mbǝkǝ taji nle kǝn nghan yool a yaa pwoo a tong mpee ɗesǝ kas, ɓǝ an pǝ ɗang pǝ gha mbǝ ɗeret fwaa, a lekom kǝn nghan kǝlǝng mun ɗi mbǝ reppee lee. ");
INSERT INTO sur_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mu kat gwar ɗesǝ wur a ngu tǝkook kǝ pee, ɗǝ wur le ɓǝlep ɗebish yool nnaar kǝ nnen Yahudi mo. Koo mpee ɗeɗangyii nɗǝǝn yil nǝ. Kǝzak wur a ngu taakyeen mǝ soon mǝ nnen Nazarin mo zak. ");
INSERT INTO sur_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nǝ le gyet wur reɓet le Lu Naan ɗeɗes nǝ ɗee a mbii ɗebuu, ɗang mu yaa wur. Muu reɓet tokɗyeel nwur a shi wàar fun mo. ");
INSERT INTO sur_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ɗangɓǝ gyet ngwe ɗeɗes Lisiyas jì dul wur put kǝnǝ shiɓal nsar fun. ");
INSERT INTO sur_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Yaksǝ Lisiyas sat nnen ɗe mo kǝ pwoo nkaa wur nǝ, kǝn mo jì pǝ gha ɗi. Katɗang a tal pwoo mo nkaa mbii ɗe muu sat sǝ mo shikáa fwaa pǝ wur, ɓǝ a mman zeen mǝ pwoo ɗesǝ mo jir, ɗe muu jì kǝ mo nkaa wur.>> ");
INSERT INTO sur_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nen Yahudi mon mɓwoon pwoo ɗe Ngu ɓǝrep ɗyeel nǝ sat, dǝm mo tong a langtǝng nǝ, pwoo ɗe Ngu ɓǝrep ɗyeel sat nǝ mo azeen jir. ");
INSERT INTO sur_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ɓǝ gofna kam sar mPool, mbǝkǝ nwur leshap ɗi. Yaksǝ Pool sat nǝnee, <<Wen man nǝ, waa aa cìn ɓit mo ɗes, ɓǝ gha nkaa tokɗyeel nnen ɗesǝ mo. Mbǝ mǝnǝ ɓǝ an pǝ leshap ɗesǝ nǝ a shi retnyit, mbǝ put kǝ káa fen. ");
INSERT INTO sur_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Waa shikáa fwaa a mak bǝlǝp shii mǝnǝ, ɓǝ a mman nǝ, mɓut teer ɗe mo ɗel kaapaat baavǝl sǝ mo, ɓǝ gyet wen nkàa nJerusalem mbǝ seyil nNaan. ");
INSERT INTO sur_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Baa nnen Yahudi mo kǝ cam kat an mpwoo kǝ mee gurum nɗǝǝn Lu Naan ɗeɗes kas, kǝ baa mo cam kat wen nle mee gurum ɓwetɓeer kas, koo a nɗǝǝn Lu Naan mo, kǝ koo a nɗǝǝn pee nkaam nǝ kas zak. ");
INSERT INTO sur_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kǝzak, baa mon mmak kám nghan agaak azeen-zeen nkaa mbii ɗe mo ji kǝ dyeel fen pǝ gha yaksǝ nǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ɗangɓǝ nǝ azeen-zeen, an kǝn seyil nNaan mǝ puun fun mo a nɗǝǝn ar ɗe mǝ mo kǝ pet a ɗung. An kǝn seyil nNaan mǝ puun fun mo, ɗang nshinzeen mbii ɗe mo ran mo nɗǝǝn ɓǝǝt-haal mǝ Mosis mo jir. Kǝ mbii ɗe mo ran mo nɗǝǝn ɓǝǝt-haal mǝ nen satpwoo mǝ Naan mo zak. ");
INSERT INTO sur_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","An kǝn canciin nɗǝǝn Naan, kaaɗe mǝ mo kǝ canciin nɗǝǝn Naan sǝ zak nǝ, mon nyool kǝ gurum mo a peemúut jir, nnen ɗe ndǝre mo, kǝ nen ɗebish mo zak. ");
INSERT INTO sur_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","A mbǝ canciin mǝnǝ, ɗang an pǝ mbǝ gung, mbǝkǝ nghan tong ɗe shi mǝse ɗeret ntoom kǝ Naan, kǝ ntoom kǝ gurum mo shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Aɓwoon mǝ ɓit mo ruk, ɓǝ wen njì kǝ shool mbǝ ɓam nen fen mo, kǝ mbii mo mbǝ wus mbiizuum nNaan zak. ");
INSERT INTO sur_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kaaɗe an nkaa cìn mǝnǝ, ɓǝ mo jì kat an nɗǝǝn Lu Naan ɗeɗes nǝ, ɓǝ kǝn lesen a ɗeɓang. Ɓǝ baa mo kat an ashak kǝ mee kuur gurum mo, ɗe mun nkaa ɗyeep ɗoo koo wat mee mbii mo kas. Gyet pak nnen Yahudi ɗe mo pwat Eshiya mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Katɗang yoo mo kǝ mee pwoo nkaa an, ɓǝ yoo nǝ nret kǝn nnen Yahudi ɗe mo pwat Eshiya sǝ, mo ɗe ntoom fwaa, mbǝ jì kǝ ɗyeel nkaa an nǝ. ");
INSERT INTO sur_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","An mbǝ reɓet kǝ nnen ɗe mon mpee ɗesǝ shikáa fur kǝn mmo sat mbii ɗebish ɗe mo kat nɗǝǝn an, kaaɗe ɗe nɗar ntoom nenɗyeel mo sǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɗee a mbii mǝndong, ɗe ɗiyeep ɗoo fen nnaar mo, ɓǝ a an sat mmo nǝnee, <A mbǝ pwoo nkaa yool a peemúut, ɗang wun bǝ tokɗyeel nghan ntoom fuu cicinsǝ, ɓejee ɗak.> >> ");
INSERT INTO sur_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ɗangɓǝ mbǝɗe Feliks pan man pwoo nkaa ar nǝ rǝret, ɓǝ wur ɗar kǝ ɗyeel nǝ. Wur sat nǝnee, <<Katɗang parpuus ɗe Lisiyas ngwe ɗeɗes mǝ shiitoon mo jì wul, ɓǝ an nsǝǝt nnaa pwoo fuu nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wur sat ngwe ɗeɗes nkaa shiitoon mo, kǝ nwur tap kǝ Pool, ɗang wur shínpee mPool, taji mo daampee nshaar mǝ Pool mo mbǝ jì cìn ɓam nwur kas. ");
INSERT INTO sur_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Aɓwoon pak meeteer mo, ɓǝ Feliks jì ashak kǝ mat fin Drusila, ɗe war a reep Yahudi. Yaksǝ wur lep mmo dǝm jì kǝ Pool. Feliks lekom kǝn nwur kǝlǝng pwoo ɗe Pool nkaa sat nǝ, ɗe nǝ a mǝ shinzeen nɗǝǝn Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pool leshap nkaa tong ɗe ndǝre-ndǝre, kǝ ngurum yaashin, kǝ pwoo nkaa tokɗyeel ɗe nǝn mbǝ jì. Ɓǝ kǝǝrmuut yaa Feliks, nǝ le nwur sat mPool nǝnee, <<A mak seet yaksǝ aku, katɗang parpuus ɗe nkatpee, ɓǝ an mbǝ pet gha zak.>> ");
INSERT INTO sur_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks leɗyeen nǝ, tong Pool mbǝ shin a shool nɗyin, a nǝ le ɗang wur naa mpet Pool shidaar-shidaar, mbǝkǝ nwur leshap ɗe kǝ nwur. ");
INSERT INTO sur_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aɓwoon ɓit mo vǝl, ɓǝ Poncus Festus wur kaa a gofna a koppee Feliks. Gyet a mbǝɗe Feliks reɓet kǝn nnen Yahudi mo ɗee a shaar fin mo, a nǝ le ɗang gyet wur yit Pool nɗǝǝn lushoot. ");
INSERT INTO sur_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Aɓwoon meeteer mo kun, ɗe Festus kǝ jì nɗǝǝn yil mǝ mulki mishkoom fin, ɓǝ wur yool nSizariya kàa nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Yaksǝ pris ɗenan mo, kǝ nennan mǝ nnen Yahudi mo jì kǝ ɗyeel mǝ mbii ɗebish mo, ɗe nǝ, Pool kǝ cìn mo pǝ Festus ɗi, mo ɗang pǝ wur, ");
INSERT INTO sur_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mbǝkǝ nwur ɓam mo ɗi. Moo reɓet kǝn Festus lep mmo jì kǝ Pool nJerusalem, mbǝɗe mo kǝ tap ɗaksut, mbǝkǝ mmo táa tu Pool ɗi a ar. ");
INSERT INTO sur_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ɗangɓǝ Festus lap mmo nǝnee, <<Pool wur a ɓuɓwoot nSizariya. An shikáa fen, wen nreɓet yool sham nSizariya nǝ nɗǝǝn meeteer ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Wur sat zak nǝnee, wu yit kǝn mpak nen ɗenan-nan mo mɓut nwun, mo sham ashak kǝ an, mbǝkǝ mmo sat mbii ɗebish ɗe gwar nǝ wur cìn mo ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Aɓwoon ɗe Festus tong ashak kǝ mo mbǝ teer mo pwookun koo kaapaat, ɓǝ wur yool sham nSizariya. Yaksǝ wur tong nkaa mbii tong mǝ tokɗyeel, ɓǝ wur sat mmo dǝm jì kǝ Pool. ");
INSERT INTO sur_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kaaɗe mo jì wul kǝ Pool, ɓǝ nnen Yahudi mo jì, ɗe mo tong nyil Jerusalem kǝ pwoo ɗebish mo ɗes nkaa wur, ɗe baa mǝ mo shikáa mo mo mak kám agaak zeen mǝ pwoo nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pool ɗar ɓalɓal mbǝ shang káa fin, ɓǝ wur sat nǝnee, <<Baa an kǝn cìn mee mbii ɗebish kas, koo a nkaa Wàar mǝ nnen Yahudi mo, kǝ koo a nkaa Lu Naan ɗeɗes nǝ, kǝ koo a nkaa Wàar mǝ mishkoom Siza kas koo lee lee.>> ");
INSERT INTO sur_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ɗangɓǝ mbǝɗe Festus reɓet kǝ nnen Yahudi mo ɗee a shaar fin, ɓǝ wur tal pǝ Pool nǝnee, <<Kyet aa reɓet kàa nJerusalem, kǝn nghan tokɗyeel ɗi nghan mpeemǝnǝ nkaa mbii ɗesǝ mo aa?>> ");
INSERT INTO sur_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ɓǝ Pool sat nǝnee, <<An mbǝ ɗar a ntoom mbii tong mǝ tokɗyeel mǝ Siza, a pee ɗe nǝ ret kǝ mmo tokɗyeel ɗi nghan mmǝnǝ. Baa an kǝn cìn mee shikbish nnen Yahudi mo kas. Waa shikáa fwaa a man azeen-zeen nǝ, baa an kǝn cìn mee mbii ɗebish kas. ");
INSERT INTO sur_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Katɗang yoo an kǝn tep Wàar nǝ, koo cìn mee mbii ɗebish ɗe nǝ mak kǝn mmo tu an, ɓǝ ɗi baa an kǝǝrmuut nǝ kas. Ɗangɓǝ katɗang ɓǝ baa mee zeen ɗi nɗǝǝn mbii ɗe nnen ɗesǝ moo ɗyeel fen mbǝ nǝ kas, ɓǝ baa mee gurum mak shin an nsar mo kas. An kǝn reɓet kǝ a Siza tokɗyeel nǝ nghan.>> ");
INSERT INTO sur_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ɓǝ aɓwoon ɗe Festus ɓeetpwoo nǝ ashak kǝ nnen ɗe moo ɓam wur nɗyéel, ɓǝ wur sat nǝnee, <<Waa a ɗang mbǝ dǝm pǝ Siza ɗi! Ɓǝ gha mbǝ dǝm a pǝ Siza ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Aɓwoon teer mo ruk, ɓǝ mishkoom Agripa kǝ Benis mo jì wul nSizariya, mbǝkǝ mmo sat mwaanlee ɗi nFestus. ");
INSERT INTO sur_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mbǝɗǝ mo kǝ cìn teer mo ɗes ɗi nSizariya nǝ, ɓǝ Festus yakshii mǝ pwoo nkaa Pool mishkoom Agripa, wur sat nǝnee, <<Mee gwar ɗi, ɗe gyet Feliks yit wur a ɓuɓwoot nlushoot. ");
INSERT INTO sur_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kaaɗe dǝ nkàa nJerusalem, ɓǝ pris ɗenan mo, kǝ nen ɗenan-nan mǝ nnen Yahudi mo jì kǝ ɗyeel nkaa gwar nǝ pǝ an ɗi. Mo ɗang pǝ an, mbǝkǝ nghan canɗyeel muut ɗi ngwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ɗangɓǝ nlap mmo nǝ, baa nǝ a mǝse mǝ nnen Rom mo, kǝn mmo canɗyeel mmee gurum, ɗe mo kǝ jì kǝ ɗyeel nkaa wur nen pee mmo kǝn shínpee nwur, kǝn nwur leshap mǝ shang káa fin ɗi nluɗyeel ashak kǝ nen ɗe mmo ji kǝ ɗyeel nǝ mo kas. Ɗangɓǝ tǝng mo nshee shínpee nwur, kǝn nwur leshap mǝ shang káa fin ɗi akuɗang mon ncanɗyeel ngwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kaaɗe mo jì mpee ɗesǝ ashak kǝ an, ɓǝ baa wen nɗar ɗi kǝ pwoo nǝ kas, ɓǝ daar nǝ, ɓǝ wen tong nkaa mbii tong mǝ tokɗyeel, ɓǝ wen nle kǝ mmo dǝm jì kǝ gwar nǝ. ");
INSERT INTO sur_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kaaɗe nen ɗe mo jì kǝ ɗyeel nkaa gwar nǝ, mo yool ɗar leshap, ɓǝ baa mo sat mee pwoo ɗebish mo nkaa gwar nǝ, kaaɗe an kǝn pan sǝ kas. ");
INSERT INTO sur_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɗangɓǝ pwoo ɗe mo sat nkaa wur nǝ, a pwoo nkaa pak mbii ɗe mo a mǝ mǝse mǝ seyil nNaan mo, kǝ pwoo nkaa mee ngwe ɗe moo pet sǝm wur a Jesu zak. Ɗe nǝ, wur muut. Ɓǝ nǝ, Pool leshap ngurum mo ɓalɓal nǝ, Jesu ɗe mmeen. ");
INSERT INTO sur_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kaaɗe baa wen mman mbii ɗe an mbǝ cìn nkaa pwoo ɗesǝ nǝ mo kas, ɓǝ wen ntal pǝ Pool nǝ, kyet aa reɓet kàa nJerusalem, kǝ mmo tokɗyeel ɗe nghan nkaa mbii ɗesǝ mo mpeemǝnǝ aa? ");
INSERT INTO sur_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ɗangɓe kaaɗe Pool ɗang nǝ, tǝng a Siza tokɗyeel nǝ nɗyin, ɓǝ wen nle kǝ mmo tap kǝ wur rǝret, dǝm wul parpuus ɗe an mbǝ lep wur shindǝm pǝ Siza ɗi.>> ");
INSERT INTO sur_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ɓǝ Agripa sat nFestus nǝnee, <<An kǝn nreɓet kǝlǝng pwoo mǝ gwar mǝnǝ shikáa fen.>> Festus sat nǝnee, <<Dǝɗaar ɓǝ gha mbǝ nkǝlǝng wur.>> ");
INSERT INTO sur_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Daar nǝ, ɓǝ Agripa kǝ Benis mo jì nɗǝǝn ɗeɗes mo hakyeng, ɓǝ mo ɗel nɗǝǝn luɗyeel nǝ ashak kǝ pak shiitoon ɗǝnan-nan mo, kǝ nnen ɗǝnan-nan mǝ pee nkaam nǝ mo. Yaksǝ Festus lep mmo dǝm jì kǝ Pool. ");
INSERT INTO sur_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ɓǝ Festus sat nǝnee, <<Mishkoom Agripa, kǝ wun nen ɗe wun ashak kǝ mun jir mpee ɗesǝ. Wu naa gwar ɗesǝ, dǝ nnen Yahudi mo jir, mo kǝ jì kǝ ɗyeel nkaa wur pǝ an ɗi nJerusalem, kǝ mpee ɗesǝ zak. Dǝ mon nkaa ɗyeep ɗoo ɗang moo sat nǝ baa nǝ ret kǝ mmo yit gwar ɗesǝ ɗi mmeen kas. ");
INSERT INTO sur_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɗangɓǝ baa wen kat wur kǝ cìn mee mbii ɗebish ɗe nǝn mmak kǝ mmo tu wur kas. Pool shikáa fin, ɗang kǝ mmo dǝm kǝ ɗyeel fin nǝ pǝ Siza ɗi. Yaksǝ ɓǝ wen kǝn leɗyeen mbǝ lep Pool shindǝm pǝ Siza ɗi. ");
INSERT INTO sur_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ɗangɓǝ baa wen mman zeen kǝ mǝ mbii ɗewur cìn nǝ, ɗe wen nran Agustus nkaa nǝ kas. Mbǝ mǝnǝ wen njì kǝ wur ntoom fuu, met jir, ɓǝ a ntoom fwaa mishkoom Agripa, mbǝkǝ aɓwoon ɗe mo bǝlǝp pwoo wur nǝ, ɓǝ an nkat mee mbii ɗe an nran shindǝm ɗi Agustus. ");
INSERT INTO sur_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mbǝɗǝ wen naa nǝ ɗee a koo ɗak mwen sǝ, kǝn mmo lep mee gurum shindǝm a ɓuɓwoot, baa ashak kǝ satpwoo nkaa mbii ɗebish ɗe ngwe nǝ cìn kas.>> ");
INSERT INTO sur_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mishkoom Agripa sat mPool nǝnee, <<Mo shínpee ngha, mbǝkǝ nghan leshap ɗi shikáa fwaa.>> Aasǝ ɓǝ Pool ɗiyeep sar fin, ɓǝ wur leshap mǝ shang káa fin. Wur sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","<<Azeen-zeen, mishkoom Agripa, yaksǝ ɓǝ nǝ fes shang nghan zam, mbǝɗe wen nkatpee leshap mǝ shang nkáa fen ntoom fwaa cicinsǝ, nkaa mbii ɗe nnen Yahudi moo sat cin nkaa an mo jir. ");
INSERT INTO sur_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mbǝɗǝ gha kǝ man ɗes zam, nkaa mǝse mǝ mbii ɗe mo a mǝ nnen Yahudi mo, kǝ pwoo nkaa mbii ɗe moo ɓǝlep nkaa nǝ zak. Wen nɗang pǝ gha, a gung kǝn nghan kǝlǝng mbii ɗe an mbǝ nsat mo shi pǝtuup mǝ gung. ");
INSERT INTO sur_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Nnen Yahudi mo jir, mo man tong fen, peegyet nkutɗi a nzǝlang. Mɓut nnen fen mo, kǝ nɗǝǝn Jerusalem zak, jì wul cicinsǝ. ");
INSERT INTO sur_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Mo man an peegyet ɗi nshee. Kǝzak katɗang ɓǝ ɗe moo reɓet langtǝng nǝ, yoo mon nsat nǝ, azeen an a ngu Farisi, ɗe nǝ a mee soon ɗe mo fes ɗar ɓal-ɓal nkaa seyil nNaan fun nǝ. ");
INSERT INTO sur_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mbǝmǝnǝ kǝn ɗar mpee ɗesǝ, mbǝkǝ mmo tokɗyeel ɗi nghan, a mbǝɗe an pǝ canciin nkaa gampwoo ɗe gyet Naan kǝ cweer nǝn mpuun fun mo. ");
INSERT INTO sur_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","A pwoo ɗe gyet Naan kǝ cweer nsoon fun ɗe kaapaat baavǝl sǝ mo, ɗe moo canciin mbǝ lap nǝ, ɗang mo kǝ gung mbǝ seyil nNaan mpar kǝ puus, mbǝ canciin ɗesǝ. Ɓǝ nnen Yahudi mo dǝm kǝ ɗyeel fen, ntoom fwaa mishkoom! ");
INSERT INTO sur_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A mii le ɗang baa nnen Yahudi mon mmak shinzeen nǝ, Naan mbǝ nyool kǝ nnen ɗe mo kǝ murep a peemúut kas yii? ");
INSERT INTO sur_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Gyet wen mpan shikáa fen nǝ, an mbǝ cìn mbii ɗe mmak jir, mbǝkǝ nghan tekook kǝ sǝm Jesu ngu Nazaret ɗi. ");
INSERT INTO sur_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Gyet a mbii ɗe ncìn nJerusalem mmǝnǝ, ɗe kǝn nlap ɓal pǝ pris ɗenan mo. Gyet kǝn shoot nenseet nɗang Jesu mo ɗes nɗǝǝn lushoot, kǝzak gyet an mɓwoon nnen ɗe mo twe nenseet nɗang Jesu nǝ mo zak. ");
INSERT INTO sur_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yit ɗes, ɓǝ nshinjeel nnenseet nɗang Jesu nǝ mo nɗǝǝn lu Naan mo zak. Gyet kǝn reɓet le kǝn mmo cíipwoo nǝ, baa Jesu a Kristi kas. Mbǝɗǝ gyet njar naa mo nyit bǝbish zam. Mbǝ mǝnǝ ɓǝ gyet mmwaan ndǝm mpee nkaam ɗe baa mo a mǝ nnen Yahudi mo kas, mbǝkǝ nghan nshinjeel ɗi nnenseet nɗang Jesu mo.>> ");
INSERT INTO sur_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Par sǝ mpuus ɓǝ an a ar dǝm nDamaskus mbǝ yak nenseet nɗang Jesu nǝ mo, shi ɓal ɗe kǝn nlap pǝ pris ɗenan mo, ɗǝ a mo lep an zak. ");
INSERT INTO sur_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ɓǝ kaaɗe puus a naar, mishkoom! Yaksǝ nnaa mee peeɓang ɗe nǝ tong aɗeng sham ɓangpee, ɗe nǝ met mɓangpee mǝ puus. Nǝ ɓangpee neer an cǝǝrkaat ashak kǝ nen ɗe mo ashak kǝ an. ");
INSERT INTO sur_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ɓǝ mun jir mu ɗong nyil, ɓǝ nkǝlǝng mee ɗoo nǝ sat nghan shi liispwoo Hiburu nǝnee, <Sool, Sool, a mii le ɗang waa aa shinjeel nghan yii? Nǝn nshwal ngha, kǝn nghan cut sak shi deelkam ɗe peet peet.> ");
INSERT INTO sur_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ɓǝ ntal nǝnee, <A gha wii Daa?> Yaksǝ Daa sat nghan nǝnee, <A an Jesu ɗe aa shinjeel nghan sǝ. ");
INSERT INTO sur_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yaksǝ a yool a ɗar atǝng, mbǝɗe an mbǝ woo sen fen ngha, a mbǝkǝ nghan ɗee ɗe a nguɗak fen, kǝ nguɗar langtǝng ngurum mo nkaa mbii ɗe aa naa, kǝ mbii ɗe an mbǝ kám mo nghan zak.> ");
INSERT INTO sur_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","An mbǝ ɓam gha nsar nnen Isreil mo, kǝ nsar nnen ɗe baa mo a nnen Yahudi mo kas. An mbǝ lep gha shindǝm pǝ nnen ɗe baa mo a nnen Yahudi mo kas zak. ");
INSERT INTO sur_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mbǝkǝ nghan wang yit mo mo ɗi. Kǝn mmo yit peenkwoo, kǝ mmo ɗel ɗi nɗǝǝn peeɓang. Kǝzak mbǝkǝ mmo put ɗi mɓut mɓal mǝ ngujwaan. Kǝn mmo jì ɗi pǝ Naan zak. Mbǝkǝ katɗang mo shinzeen, ɓǝ mon nkat fwoo mǝ shikbish fur mo, kǝn mon nkat peetong ɗe ashak kǝ nen ɗe Naan kǝ ten bǝlǝp mo zak.>> ");
INSERT INTO sur_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Mishkoom Agripa, baa gyet ncii cìn mbii ɗe suun ɗe nǝ tong aɗeng sham sat nghan kas. ");
INSERT INTO sur_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Gyet nshee satpwoo Naan nǝ a nnen Damaskus mo, ɗang ndǝm kǝn nghan sat ɗe nnen Jerusalem mo, kǝ yil ɗe mo neer Judiya jir. Aɓwoon mǝnǝ, ɓǝ nsat nnen ɗe baa mo a nnen Yahudi mo kas zak. An pǝ sat mmo tuwap, kǝn mmo ciir pǝ Naan ɗi, kǝn mmo cìn ɗak ɗe nǝ kám tuwap mo nǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","A mpeemǝnǝ, ɗang nnen Yahudi mo yaa an nɗǝǝn Lu Naan ɗeɗes, kǝ gyet mo kǝ tang ar mbǝ tu an. ");
INSERT INTO sur_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ɗangɓǝ mbǝɗe nkat ɓam pǝ Naan ɗi, a nǝ le ɗang kǝn nɗar ɗi ntoom fwaa mbǝ cicinsǝ. An nkaa satpwoo Naan nǝ nennan mo, kǝ jep ɗeɗyeen mo jir. Baa nsat a mmee pwoo ɗecì kas, tǝng a pwoo ɗe nensatpwoo Naan mo, kǝ Mosis mo kǝ ten sat nǝ, nǝn nyool cìn a kǝsǝ. ");
INSERT INTO sur_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nǝ, tǝng Kristi mbǝ shwaajeel, kǝ a wur a ngwe ɗenshee mǝ yool a peemúut zak. A wur mbǝ shee leshap nkaa peeɓang nǝ nnen Yahudi mo, kǝ nen ɗe baa mo a nnen Yahudi mo kas zak.>> ");
INSERT INTO sur_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kaaɗe Pool nkaa leshap mbǝ shang káa nǝ, ɓǝ Festus sat shii ɗoo ɗeɗes nǝnee, <<Pool aa tǝttar aa? Man fwaa nii le gha ɗee a ngutar.>> ");
INSERT INTO sur_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ɓǝ Pool lap nǝnee, <<Baa an a ngutar kas Festus, ngwe ɗeret met jir. An kǝn sat a pwoo ɗe mo azeen-zeen kǝ ɗe mo a ndǝre zak. ");
INSERT INTO sur_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mishkoom man mbii ɗe kǝn nsat sǝ mo agaak. Mbǝɗǝ mman azeen-zeen nǝ, baa mee mbii loom gha mɓut mbii ɗesǝ mo jir kas. Mbǝɗǝ baa gyet mo cìn mbii mǝnǝ mo a sǝsok kas. ");
INSERT INTO sur_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mishkoom Agripa, a shinzeen nnensat pwoo mǝ Naan mo ee? Mman nǝ, a shinzeen.>> ");
INSERT INTO sur_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mishkoom Agripa sat mPool nǝnee, <<Nɗǝǝn reppee ɗi lee sǝ, ɓǝ aa reɓet ciir kǝ an, kǝn nghan nɗee ɗi a nguseet nɗang Jesu ee?>> ");
INSERT INTO sur_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool lap nǝnee, <<koo a nɗǝǝn reppee lee. Koo a nɗǝǝn pee ɗe nǝ ɗes, ɓǝ an nkaa ɗangnaan mbǝ gha, kǝ nnen ɗe mo nkaa kǝlǝng an cicinsǝ jir, mbǝkǝ mmo tuwap kǝn mmo ɗee ɗi a nenseet nɗang Jesu koo an sǝ. Ɗangɓe taji a shi shoolbǝring kaaɗe an kǝ nǝ sǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Aɓwoon mǝnǝ, ɓǝ mishkoom yool, kǝ gofna, kǝ Benis, kǝ nnen ɗe mo kǝ tong ashak kǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ɓǝ mo dǝm mmee koop mbǝsut, ɓǝ mo ɓeet kǝ shak nǝnee, <<Baa gwar ɗesǝ kǝ cìn mee mbii ɗebish ɗe nǝ mak muut, koo mo nle wur nɗǝǝn lushoot kas.>> ");
INSERT INTO sur_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa sat nFestus nǝnee, <<Katɗang yoo baa gwar ɗesǝ wur kǝ ɗang mbǝ dǝm kǝ ɗyeel nǝ pǝ Siza ɗi kas, ɓǝ yoo mon ɓwet wur.>> ");
INSERT INTO sur_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kaaɗe mo ɓeet nǝ, mun nɗel ntii kǝn mmo dǝm ɗi nyil Itali, ɓǝ mo le Pool kǝ pak nen ɗe mo a ɓuɓwoot, nsar mǝ mee ngwe ɗeɗes nkaa shiitoon mo, ɗe moo pet sǝm wur a Juliyus, ɗe nǝ a soon mǝ nentap mǝ mishkoom Agustus. ");
INSERT INTO sur_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Mu ɗel nɗǝǝn mee tii ɗe nǝ tong a nyil Adramitiyum jì, ɗang nǝn mbǝ yool mbǝ dǝm ngaar yil ɗe mo nkoop yil Eshiya mo. Yaksǝ mu yool mwaan nǝ nɗǝǝn tii nǝ. Aristakus mee ngu Masidoniya mǝ yil nTasoloni, wur ɗi ashak kǝ mun zak. ");
INSERT INTO sur_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Daar nǝ, ɓǝ mǝ wul nSidon. Juliyus cìn ɗeret mPool, wur shínpee mPool kǝ nwur dǝm pǝ shaar fin mo, mbǝkǝ mmo ɓam wur ɗi. ");
INSERT INTO sur_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kaaɗe mǝ yool mpeemǝnǝ, ɓǝ mu dǝm shigǝng mǝ yil nSaiprus nǝ, mbǝɗe kut nǝ daampee mmun zam. ");
INSERT INTO sur_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Aɓwoon mǝnǝ, ɓǝ mu dǝm mu wul nkor kuur ɗe nǝn ngaar Silisiya kǝ Pamfiliya. Yaksǝ mu dǝm mu wul mMira ɗe nǝn nyil nLisiya. ");
INSERT INTO sur_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","A mMira nǝ, ɓǝ ngwe ɗeɗes nkaa shiitoon mo, kat mee tii ɗe nǝ tong Alekzandriya jì, ɗe nǝn mbǝ dǝm Itali, ɓǝ wur le mun nɗǝǝn nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mu cìn teer mo ɗes-ɗes mun mmwaan lee-lee, nkaa am kuur nǝ, a purut-purut ɗang mǝ jì mǝ wul kus kǝ Nidus. Kaaɗe baa kut nǝ yit mmun dǝm ɗe a kyeen kas, ɓǝ mǝ waa mǝ yaa ar nǝ shigǝng mǝ yil nKrit, kus kǝ Salmone. ");
INSERT INTO sur_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","A purut-purut ɗang mu jì mu wul ɗi a pǝkom ɗǝǝr nǝ, ɓǝ mu jì mǝ wul mmee mpee ɗe mo kǝ pet a peekaat ɗeret, ɗe nǝ kus kǝ pee nkaam nLasiya. ");
INSERT INTO sur_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mbǝɗǝ mun mbǝ yém ɗi mpeemǝnǝ mbǝ teer mo ɗes, ɓǝ kaaɗe mǝ yaa mwaan, ɓǝ nǝ jì kǝ jeel ɗes, mbǝɗe tar mwaan nkaa am nǝ kǝ ten ɗel, ɗang nǝ aɓwoon tartong kǝ neen, ɓǝ Pool leshap nnen ɗe mo nɗǝǝn tii nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Wur sat mmo nǝnee, <<Daa mo, wen nnaa mwaan fun ɗesǝ nǝn nɗen kǝ jeel, kǝ lée ɗe mun kǝ mo nɗǝǝn tii nǝ mon ntǝkook, ɗang tii mǝnǝn ntǝkook, dǝm wul kǝ seen fun mo zak.>> ");
INSERT INTO sur_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Jir aasǝ baa ngwe ɗeɗes nkaa shiitoon nǝ mo, leɗyeen mpwoo ɗe Pool sat kas, tǝng wur nkǝlǝng a pwoo mǝ ngutung tii nǝ ɗak, kǝ mǝ ngu tii nǝ met mbii ɗe Pool sat nwur. ");
INSERT INTO sur_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Baa peeɗar mǝ tii ɗesǝ nii ret ntarkut kas, a kǝsǝ ɓǝ ɗes mǝ gurum nǝ mo ɓeet nǝ, ngyel mǝ yool aku mpeemǝnǝ, kǝ koo ɗe arang yii ɓǝ mu nwul ɗi nFoniks, ɗe nǝ a mee pee am kuur ɗeret nɗǝǝn pee nkaam nKrit, nii naa gaar ngyeen, nsar puusru, kǝ ngaar ndeng nsar puusru zak, mu hos ntarkut a mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kaaɗe kut nǝ ɗoom cut pee lee-lee ngaar ngyeen, ɓǝ mo pan nǝ, nǝn njì wuɗun nciit kǝ pan fur mo, ɓǝ mo dul ɓwootsǝǝp nǝ, kǝ mmo tung tii nǝ shindǝm kus kǝ pǝkom ɗǝǝr mǝ yil nKrit. ");
INSERT INTO sur_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ɗangɓǝ kaaɗe mo lang ɗi lee, ɓǝ mee kut ɗeɗes ɗe moo pet a Yurakium dǝ nǝ put nnar kwang ɗeng kǝ sar puus kaa nǝ cutpee jì ɗi nkaa pee nkaam nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kaaɗe kut ɗeɗes nǝ cut tii nǝ, ɓǝ baa tii nǝ mak dǝm ngaar pee ɗe kut nǝ kǝ jì ɗe kas. Ɓǝ mu yit nkut nǝ tǝp mun shindǝm ɗi mmee ngaar ɗyik. ");
INSERT INTO sur_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mu ɗel shigǝng mǝrep mee yil ɗe am neer ciirkaat ɗe moo pet a Kauda. A purut-purut ɗang mu mak ɓwoot làa tii nǝ nkaa ɗeɗes nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Aɓwoon ɗe mo kǝ ɗiyeep làa tii nǝ le nɗǝǝn tii ɗeɗes nǝ, ɓǝ mo ɓwoot teng shin ciir nkaa tii ɗeɗes nǝ. Mo sham kǝ nlǝr mǝ tii nǝ mo. Mbǝɗǝ mo kǝǝr nǝ, taji kut nǝ tǝp tii nǝ dǝm shweer shi pǝkom ɗyees nSirtis kas. Mo dul ɓwootsǝǝp mǝ tii nǝ kàa nɗǝǝn am nǝ kǝn mmo yit, kǝn nkut nǝ tǝp tii nǝ shindǝm ɗi. ");
INSERT INTO sur_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mbǝɗǝ kut nǝ ɗes zam, ɗang nǝ fes yoon mun ɗes zam. Daar nǝ, ɓǝ mo ɗoom kok pak lee ɗe mo nɗǝǝn tii nǝ car mɓut am. ");
INSERT INTO sur_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Parpuus ɗekun nǝ zak, ɓǝ mo shikáa fur, mo kok lee tii nǝ mo car mɓut am zak. ");
INSERT INTO sur_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mu cìn teer mo ɗes, baa mu mak naa puus koo zar mo kas. Ɗee a kut ɗeɗes, kǝ tungzung mo kàa paa mun ɗak, ɗe nǝ le kǝn mmun put kǝ pǝtuup nǝ baa mun mbar kas. ");
INSERT INTO sur_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Mbǝɗǝ gurum nǝ mo kǝ cìn teer mo ɗes nnen se mbiise, ɓǝ Pool yool nnaar mo, ɓǝ wur sat nǝnee, <<Daa mo, katɗang dǝ wu kǝlǝng pwoo fen, ɓǝ baa dǝ wun nyool nɗǝǝn yil nKrit, kǝn nwun shwaajeel ɗesǝ, kǝn nwun bǝlang nlée fuu mo kǝrong kas. ");
INSERT INTO sur_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mbǝmǝnǝ an pǝ sat nwun, wu yaa pǝtuup fuu mo, mbǝɗe baa mee gurum nɗǝǝn wun, mbǝ mmuut kas, a tii nǝn mpyan kash-kash ɗak. ");
INSERT INTO sur_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mbǝɗǝ dǝdoon mpar, ɓǝ mee ngulep mǝ Naan ɗe an a mǝwur, kǝ ɗe an kǝn nseyil nwur zak, wur jì woo shin nghan. ");
INSERT INTO sur_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","<<Ɓǝ wur sat nghan nǝnee, <Taji kǝǝrmuut yaa gha kas Pool. Nǝ a tǝng gha mbǝ ɗar ntoom kǝ Siza. A naa Naan kǝ cìn ɗeret ngha, ashak kǝ nen ɗe mo nɗǝǝn tii nǝ jir. Baa mee gurum nɗǝǝn tii nǝn mmuut kas.> ");
INSERT INTO sur_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Mbǝ mǝnǝ, daa mo, wu cìn retnyit. Mbǝɗǝ wen nshinzeen nNaan nǝ, mbii ɗe mo woo nghan, ɓǝ nǝn ncìn a kǝsǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ɗang jir kǝsǝ ɓǝ kut nǝn tǝp tii nǝ shweer nkaa mee yil ɗe am neer nǝ ciirkaat.>> ");
INSERT INTO sur_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nɗǝǝn teer ɗe kaapaat baafeer nǝ, ɓǝ kut nǝ tǝp mun kàa kǝ sham nɗǝǝn am kuur mǝ Adriya. Yaksǝ nnaar par, ɓǝ nen tii nǝ mo pan nǝ, muu wul kus kǝ mee yil. ");
INSERT INTO sur_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓǝ mo kam lu mǝ am nǝ, ɓǝ mo kat nǝ a shii mo kambil mǝndong kǝ laarvǝl (120). Kaaɗe mu gyes mu dǝm ɗi lee, ɓǝ mo cin shin kam lu mǝ am nǝ ɗe zak, ɓǝ mo kat nǝ wul a shii laarpwoofeer (90). ");
INSERT INTO sur_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mbǝ kǝǝrmuut ɗe nǝ, meesǝ, kut nǝn ndǝm shweer tii nǝ nkaa ngǝk, ɓǝ mo fwen ɓwootsǝǝp nǝ mo sham feer mɓwoon mǝ tii nǝ, mbǝkǝ ntii nǝ ɗar ɗi coot, mbǝɗe mo le pan nkaa ɓit ɗe nǝn mbǝ mang. ");
INSERT INTO sur_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nentung tii nǝ mo nkaa yap ar ɗe mon nshwe yit tii nǝ ɗi, ɓǝ mo kǝ ten shang làa tii nǝ shinsham mɓut am kuur nǝ. Mo cìn kǝsǝ a mbǝ gwam gurum mo, kǝn mmo naa ɗi nǝ, wuɗun a mbǝ fwo ɓwootsǝǝp nǝ ɗe mon mpǝkyeen mǝ tii nǝ, ɗe moo ɓwet shinsham sǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ɗangɓe Pool sat ngwe ɗeɗes mǝ shiitoon nǝ mo nǝnee, <<Katɗang ɓǝ baa nentung tii nǝ mo tong ɗi nɗǝǝn tii nǝ kas, ɓǝ wu mmurep jir.>> ");
INSERT INTO sur_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ɓǝ shiitoon mo can teng mǝ làa tii nǝ, mo yit nǝ sham taa nɗǝǝn am nǝ, yaksǝ kut mang nǝ seet kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kaaɗe ɓit kus kǝ mang, ɓǝ Pool sat ngurum nǝ mo jir kǝ mmo se mbiise, wur sat nǝnee, <<A teer mo kaapaat baafeer nɗesǝ, ɓǝ wun pǝ tong gongpee, kǝ baa wu se mee mbiise kas. ");
INSERT INTO sur_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mbǝmǝnǝ kǝn ɗang pǝ wun, mbǝkǝ nwun se mbiise, mbǝɗe mǝnǝn nshínɓal nwun nɗǝǝn shik fuu mo. Baa mee shweepkáa mǝ mee gurum mǝndong nɗǝǝn wun nǝn nloom kas.>> ");
INSERT INTO sur_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kaaɗe Pool sat pwoo mǝnǝ, ɓǝ wur mang gǝǝl aas, ɓǝ wur ɗangnaan ɗe mǝ plang Naan a yit gurum nǝ mo jir, ɓǝ wur tep gǝǝl aas nǝ, ɓǝ wur yaa se nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yaksǝ gurum nǝ mo jir mo kat retnyit, ɓǝ mo shikáa fur mo se gǝǝl aas nǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mun gurum ɗe mun nɗǝǝn tii nǝ jir, mu wul kambil vǝl kǝ laarpwoovǝl kǝ peemee (276). ");
INSERT INTO sur_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kaaɗe gurum mo se mbiise mo ǝɓǝl, ɓǝ mo kok aàs ɗǝɓen ɗe nǝ nɗǝǝn tii nǝ, mo car shinsham mɓut am kuur nǝ, kǝn ntii nǝ pan fiyeel ɗi. ");
INSERT INTO sur_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kaaɗe ɓitmang, ɓǝ baa nentung tii nǝ mo man yil ɗe mo ɗi nǝ kas, ɓǝ mo naa mee pǝkom ɗǝǝr ɗe nǝ kǝ ɗyees, ɓǝ mo ɓeet nǝ, katɗang nǝ mak cìn, ɓǝ mo dǝm kǝ tii ɗi pǝkom nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓǝ mo saa teng ɗe mo yaa ɓwootsǝǝp nǝ mo, kǝn mmo yit ɓwootsǝǝp nǝ mo mɓut am kuur nǝ, kǝn mmo fween teng ɗe moo yaa mbii ciir kǝ tii nǝ. Yaksǝ mo ɗiyeep nlǝr ɗe nǝn mpǝkyeen mǝ tii nǝ nkor ɗe kut kǝ jì ɗi, ɓǝ mo yaa ar dǝm pǝkom ɗǝǝr. ");
INSERT INTO sur_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ɗangɓǝ kaaɗe mu wul mmee mpee ɗe kut kǝ cut am nǝ jì kaat ɗi, ɓǝ tii nǝ ɗel shamru mɓut ɗiyees, ɗe baa nǝ kutɗi kǝ tungpee kas, ɓǝ koor mɓwoon mǝ tii nǝ ɗoom pyan, mbǝ ɓal mǝ kut ɗe nii cut nǝ. ");
INSERT INTO sur_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Yaksǝ shiitoon nǝ mo ɓeetpwoo, mbǝ twe nen ɗe mo a ɓuɓwoot jir, mbǝkǝ taji mo cut lung, kǝ mo dǝm loom ɗi kas. ");
INSERT INTO sur_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ɗangɓǝ ngwe ɗeɗes nkaa shiitoon nǝ mo, kǝ reɓet ɓam Pool, ɓǝ wur cíi mmo. Wur le kǝ nnen ɗe mo man lung jir, mo mǝrep sham mɓut am nǝ, kǝn mmo taa lung dǝm wul ɗe a pwoo ɗǝǝr. ");
INSERT INTO sur_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Aɓwoon mǝnǝ, ɓǝ koor gurum nǝ mo mǝrep sham taa nkaa shiyeep mo, kǝ pak mo nkaa yoom mǝ tii ɗe nǝ pyan nǝ zak. ");
INSERT INTO sur_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Aɓwoon ɗe mu wul nɗǝǝn yil nǝ nkoom jir, ɓǝ mu kǝlǝng nǝ, moo pet sǝm yil ɗe am neer nǝ cǝǝrkaat a Malta. ");
INSERT INTO sur_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nenyil nǝ mo kaat mun jir, kǝzak mo ɓam mun zam, ɓǝ mo ɓil wus mmun, mbǝɗe fwan nkaa jì, kǝ pee zuum zak. ");
INSERT INTO sur_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ɗangɓǝ kaaɗe Pool kok yoom le nwus, ɓǝ mbǝ tal mǝ wus nǝ, ɓǝ mee nwòo ɗe sǝm nǝ a pang, nǝ pus sar mPool, ɗang nǝ ɗyiin nkaa sar wur. ");
INSERT INTO sur_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kaaɗe nenyil nǝ mo naa nwòo ɗesǝ nii ɗyiin mPool nkaa sar, ɓǝ mo sat nshak nǝnee, <<Azeen-zeen gwar ɗesǝ wur a ngutukáa, koo ɗewur kǝ put mɓut njeel mǝ am kuur nǝ, ɓǝ baa kwat mǝ shikbish nǝ mak yit wur ɗe mmeen kas.>> ");
INSERT INTO sur_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ɓǝ Pool vwet nwòo nǝ sham taa nwus. Mbǝɗǝ nwòo ɗe nǝ pus wur nǝ, ɓǝ baa nǝ cìn mee mbii nwur kas. ");
INSERT INTO sur_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nenyil nǝ mo pan nǝ, yak mon nnaa Pool wup, koo mo nnaa wur taa nyil muut. Ɗangɓǝ kaaɗe mo tong naapee, ɓǝ baa mo naa mee mbii cìn Pool kas, ɓǝ mo waa sheepwoo ɗe, mo sat nǝnee, <<Gwar ɗesǝ wur a mee naan.>> ");
INSERT INTO sur_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kus kǝ peemǝnǝ, ɓǝ mee maar mǝ Pubiliyus ngwe ɗeɗes nkaa yil ɗe am neer cǝǝrkaat nǝ, wur kaat mun le nlu fin mbǝ teer mo kun, ɗang wur tap kǝ mun, wur cìn ɗeret mmun zam. ");
INSERT INTO sur_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Puun mǝ Pubiliyus, baa wur nkoom kas, wur a peesaam kǝ shikshwal, kǝ ɗyestoom zak. Pool ɗel pǝ ngunan nǝ ɗi, ɓǝ wur ɗangnaan ɓǝ wur lesar fin nkaa ngunan nǝ, ɓǝ ngunan nǝ bar. ");
INSERT INTO sur_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kaaɗe Pool cìn mǝnǝ, ɓǝ koor nengok ɗe mo nɗǝǝn yil ɗe am neer cǝǝrkaat nǝ, mo jì jir, mbǝkǝ mPool bar mo ɗi. ");
INSERT INTO sur_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nenyil nǝ mo shin zuum mo mmun ɗes, ɗang kaaɗe mun mbǝ ɗel nɗǝǝn tii nǝ mbǝ seet, ɓǝ mo shin mbii ɗe mon mɓam mun a ar mwaan nǝ jir zak. ");
INSERT INTO sur_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Aɓwoon tar mo kun, ɓǝ mǝ yool nɗǝǝn mee tii ɗe nǝ tong a Alekzandriya jì, ɗe nii hos ntarkut nɗǝǝn yil ɗe am neer cǝǝrkaat sǝ. tii ɗesǝ nǝ kǝ sǝmpwoo (alaama) mǝ káa Jan ɗemish mo nkaa nǝ, ɗe mo a Kasto, kǝ Pollukus, mee naan mǝ mo, nǝ mo. ");
INSERT INTO sur_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Mu jì mǝ wul nSirakus, ɓǝ mu cìn teer mo kun ɗi, mpee mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kaaɗe mu yool mpee mǝnǝ, ɓǝ mu jì mu wul nRegiyum. Mu teer mpeemǝnǝ, ɓǝ mee kut yool nkor ngyeen, ɓǝ ɗaar nǝ, ɓǝ mu dǝm mu wul mPutiyoli. ");
INSERT INTO sur_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mu kat nenseet nɗang Jesu mo mpeemǝnǝ, ɓǝ mo ɗang mun kǝn mmun cìn teer mo pwoovǝl ɗi ashak kǝ mo. A mwaan fun nǝ mmǝnǝ, ɗee mu dǝm mu wul nRom. ");
INSERT INTO sur_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kaaɗe nenseet nɗang Jesu ɗe mon mpee nkaam nRom, mo kǝlǝng pwoo nkaa mun, ɓǝ mo pwat jì mbǝ kaat mun, ɓǝ mo jì wul mpeepring Apiyus, kǝ pee ɗe lumǝzep mo ɗekun. Kaaɗe Pool naa mo, ɓǝ wur plang Naan, ɗang pǝtuup wur nǝ sǝǝt katɓal. ");
INSERT INTO sur_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kaaɗe mu jì mu wul nɗǝǝn pee nkaam nRom, ɓǝ mo shínpee mPool tong ɗi mbǝshin mpee ɗewur rǝɓet, ashak kǝ shiitoon ɗewur kǝ tap Pool. ");
INSERT INTO sur_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Aɓwoon teer mo kun, ɓǝ Pool pǝrep nen ɗenan-nan mǝ nnen Yahudi mo. Kaaɗe mo kuur ashak, ɓǝ wur sat mmo nǝnee, <<Ɗyemnaa mo, baa kǝn cìn mee mbii ɗebish nnen fun mo kas. Koo a nkaa mǝse mǝ wàar puun fun mo, ɓǝ baa kǝn cìn mee mbii ɗebish kas, jir kǝsǝ, ɓǝ mo yaa an shin nnen Rom mo a ɓuɓwoot nɗǝǝn yil nJerusalem. ");
INSERT INTO sur_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kaaɗe nnen Rom mo tokɗyeel nghan, ɓǝ mo rǝɓet ɓwet an, mbǝɗe baa kǝn cìn mee mbii ɗebish ɗe nǝ mak kǝ mmo tu an kas. ");
INSERT INTO sur_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ɗangɓǝ baa nnen Yahudi mo rǝɓet kǝ mmo ɓwet an kas, ɓǝ nǝ ɗee nghan a tǝng kǝn nghan ɗang nǝ, mo jì kǝ ɗyeel fen nǝ pǝ Siza ɗi. Baa nǝ, kǝn rǝɓet yap a nen fun mo kǝ ɗyeel kas. ");
INSERT INTO sur_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A mbǝ pwoo ɗesǝ, ɓǝ wen nyappee ɗe an nnaa wun ɗi, mbǝkǝ wen leshap ɗi kǝ wun, mbǝɗe a mbǝ canciin ɗe nnen Isreil mo kǝ nǝ, ɗang an ɗi a ɓuɓwoot shi shoolbǝring ɗesǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mo sat nwur nǝnee, <<Baa mmun muu kat mee lep a rǝran nyil Judiya nkaa gha kas. Kǝzak baa mee ɗyemnǝǝn fun mo jì mpee ɗesǝ, kǝn mmo satpwoo ɗi mmun nkaa gha, koo mo sat mee pwoo mmun nkaa mbii ɗebish ɗe a cìn mo kas zak. ");
INSERT INTO sur_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ɗangɓǝ mu rǝɓet kǝlǝng nǝ mpwoo fwaa mbii ɗe gha naa nǝ ret, mbǝɗe katɗang a pwoo nkaa Ar ɗesǝ nǝ, ɓǝ mu man nǝ, koo a nii, ɓǝ mo nkaa leshap ɗebish nkaa nǝ.>> ");
INSERT INTO sur_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Aɓwoon mǝnǝ, ɓǝ mo lepuus. Ɓǝ kaaɗe puus nǝ wul, ɓǝ gurum mo ɗes mo jì pǝ Pool ɗi a pee ɗewur kǝ tong ɗi. Yool mbít, dǝm wul nkansǝǝn, ɓǝ Pool kámshii mǝ mulki mǝ Naan nǝ ngurum mo, ɗang wur tong a langtǝng nkaa nǝ zak. Wur rǝɓet dul mo jì pǝ Jesu ɗi, shi kám mǝ Wàar mǝ Mosis, kǝ shi kám mǝ nensatpwoo mǝ Naan mo zak. ");
INSERT INTO sur_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Pak gurum nǝ mo shinzeen mpwoo ɗewur sat nǝ, ɗang baa pak mo shinzeen kas. ");
INSERT INTO sur_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kaaɗe baa mo kǝlǝngkar nǝ ashak jir kas, ɓǝ akuɗang moo rangkáa, ɓǝ Pool sat mee pwoo mmo mǝndong, nǝnee, <<Azeen-zeen pwoo ɗe gyet Riin Ɗeɓang wur kǝ sat mpuun fuu mo nsar kǝ ngusat pwoo Naan Aizaya nǝnee, ");
INSERT INTO sur_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<A dǝm pǝ nnen ɗesǝ mo ɗi, kǝn nghan sat mmo nǝnee, wun nsat a kǝlǝngpee, ɗang baa wun mmanshii mǝ mbii ɗe wun kǝlǝng nǝ kas koo dǝɓen. Wun nsat a nnaapee ɗak, ɗang baa wun mmanshii mǝ mbii ɗe wuu naa nǝ kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mbǝɗǝ pǝtuup mǝ nnen ɗesǝ nǝ mo fii ɗee kakras. Mo kǝ duur kom fur mo, ɗang mo kǝ kup ar fur mo zak. Mbǝkǝ taji mo naapee shi yit fur mo, kǝ taji mo kǝlǝngpee shi kom fur mo zak, kǝzak, mbǝkǝ taji mo manshii nǝ nɗǝǝn pǝtuup fur mo. Kǝn mmo ciir pǝ an ɗi, ɓǝ yool an ɓam mo.> ");
INSERT INTO sur_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","<<Mbǝ mǝnǝ, ɓǝ wen nrǝɓǝt kǝ nwun man nǝ, mo kǝ lep pwoo nkaa ɓam mǝ Naan nǝ shindǝm nnen ɗe baa mo a nen Yahudi mo kas. Yaksǝ mon nlekom mbǝ pwoo nǝ, ɓǝ mon nkǝlǝng.>> ");
INSERT INTO sur_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kaaɗe Pool leshap ɗesǝ mmo, ɓǝ nnen Yahudi mo rangkáa, kǝ mon nkaa ɓeetpwoo nǝ kǝ shak. ");
INSERT INTO sur_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pool tong nɗǝǝn lu ɗe a wur kwat shikáa fin, mbǝ ɓit mo vǝl. Wur kǝ kaat nen ɗe mo jì pǝ wur ɗi jir. ");
INSERT INTO sur_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wur leshap ngurum mo nkaa mulki mǝ Naan nǝ, baa ashak kǝ mee kǝǝrmuut kas, kǝ baa mee ngwe cíi nwur kas, kǝzak, wur kámpwoo ngurum mo nkaa Daa Jesu Kristi.");
INSERT INTO sur_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Lepran ɗǝsǝ nǝ put a nsar kǝ Pool, ɗe shi ɗem Naan, ɓe Naan pet wur kǝ wur ɗee a laalep mǝ Kristi Jesu, kǝ ɗyemnǝǝn fun Sosfenes. ");
INSERT INTO sur_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Wen kǝn lep pwoo ɗesǝ nǝ dǝm pee Ekǝlisya mǝ Naan ɗe nǝ nyil nKoronti. Nen ɗe Naan kǝ ten bǝlǝp mo le, mbǝkǝ mo ɗee ɗi a nen fir mo ndǝǝn Jesu Kristi, kǝ mpee nen ɗi koo a nneye, ɗe moo pet sǝm kǝ Daa fun Jesu Kristi ɗewur a Daa fur kǝ Daa fun zak. ");
INSERT INTO sur_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ɗeret kǝ tongryang ɗe nǝ put a pee Naan puun kǝ Daa fun Jesu Kristi nǝ tong ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Wen pǝlang Naan shidaar-shidaar mɓe wun, mɓeɗǝ Naan wur cin ɗeret wun ndǝǝn Kristi Jesu. ");
INSERT INTO sur_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","nƊǝǝn Jesu Kristi, ɓe Naan wu kǝ shin man mbii mo wun, kǝ man leshap rǝret ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Mbǝɗe langtǝng fun nkaa Kristi nǝ ɗee azeen-nzeen ndǝǝn wun. ");
INSERT INTO sur_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Mɓemǝnǝ, ɓe baa wu nook kat mee zuum ɗe nǝ a mǝ Riin Naan kas, kaaɗe wuu choor mɓe kum parpuus ɗi Daa fun Jesu Kristi wun njì put agaak. ");
INSERT INTO sur_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Wur nwaa shin ɓal nwun har peekyes nǝ, mbǝkǝ wu ɗee ɗi a ɗe ndǝre-ndǝre parpuus mǝ Daa fun Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Naan ɗewur kǝ ten pǝrep wun, kǝ wu ɗee ɗi a nentong ashak kǝ Làa fir Jesu Kristi, Daa fun, wur a nguzeen. ");
INSERT INTO sur_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ɗyemnaa mo, wen ɗang pee wun, ndǝǝn sǝm kǝ Daa fun Jesu Kristi, nee, nǝ ret kǝ pwoo fuu mo dǝm ndangshak, mbǝkǝ taji mee ɓàkshak yool nnaar fuu kas. Ɗangɓe nǝ ret kǝ wu ɗee a ɗemǝndong ndǝǝn pan fuu mo kǝ ndǝǝn mbii ɗe wu rǝɓet cìn mo. ");
INSERT INTO sur_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ɗyemnaa mo, nentul kǝ Klo mo jì sat wen nǝ, ɓǝlep kǝ yool nnaar fuu. ");
INSERT INTO sur_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Mbii ɗe mo sat nǝ a nǝ, koo a weye ndǝǝn wun, ɓe wur sat mbii mo shini-shini, pak moo sat nǝnee, <<Wen a mǝ Pool,>> Koo <<wen a mǝ Apolos,>> Koo, <<wen a mǝ Kefas,>> Koo, <<wen a mǝ Kristi.>> ");
INSERT INTO sur_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kristi wur ɗee a ɗeɓǝɓak ee? Gyet mo pwas a Pool nkaa shiyeepyoom mbǝ wun aa? Aa koo gyet mo cìn baptisma nwun a ndǝǝn sǝm kǝ Pool yii? ");
INSERT INTO sur_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Wen pǝlang Naan, mɓeɗǝ baa gyet wen cìn baptisma memee fuu kas, tǝng a Krispus kǝ Gayus ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Mɓǝmǝnǝ ɓe baa mee fuu mmak sat nǝ, gyet mo cìn baptisma wuɗin a ndǝǝn sǝm fen kas. ");
INSERT INTO sur_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Ɗangɓe gyet wen cìn baptisma nentul Stifenas mo. Katɗang baa a mo kas, ɓe baa wen pan nǝ, gyet Wen cìn baptisma mmee gwe kas.) ");
INSERT INTO sur_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Baa gyet Kristi wur lep wen a mbǝkǝ wen cìn baptisma ɗi kas, amma gyet wur lep an, a mbǝkǝ wen satpwoo ɗeret nǝ ɗi, baa a shi mee seen kǝ man satpwoo kas. Mbeekǝ taji mo leɓal mǝ shiyeepmúut kǝ Kristi nǝ ɗee a ɗebuu kas. ");
INSERT INTO sur_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Pee nenyil ɗi mo nkaa loom, ɓe pwoo nkaa shiyeep nǝ a pwoo ɗebuu pee mo ɗi. Ɗangɓe pee mun, nen ɗe muu kat seen, ɓe shiyeep nǝ a iiko Naan. ");
INSERT INTO sur_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Mbǝɗe mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan nǝnee, <<Wen nshirip seen nenseen mo, kǝ nghan mmang man kǝ nenman mo nle mmee kwang akuɗang.>> ");
INSERT INTO sur_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Katɗang nǝ a kǝsǝ, ɓe nguseen nǝ a nneyii? Ɓe nguman mbii a nneyii? Ɓe nguɓeetshik mɓut mɓít ɗǝsǝ a nneyii? Naan wu kǝ ten shin ciir kǝ nenseen mǝ yil ɗesǝ nǝ ɗee a mwen mo. ");
INSERT INTO sur_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Mɓǝɗǝ ndǝǝn seen kǝ Naan, ɓe yil nǝ shi seen kǝ nǝ, baa nǝ man Naan kas. Ɗangɓe nǝ ret Naan nyit mɓe pwoo ɗeret ɗi mǝ sat nǝ, ɗe pak nenkǝlengpwoo mo, ɓe moo sat nǝ, nǝ a pwoo mwen mo. Ɗangɓe nǝ a ɓam mpee nen ɗe mo shinzeen. ");
INSERT INTO sur_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Nen Yahudi moo tang mbii aapwoo mo, kǝ nen Heleni moo tang a seen. ");
INSERT INTO sur_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ɗangɓe mun, muu sat a pwoo nkaa Kristi ɗe mo pwas wur nkaa shiyeepyoom. Ɗesǝ nǝ ɗee a mbii canshii nen Yahudi mo, kǝ nǝ ɗee a pwoo mwen pee nen ɗi baa mo a nen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ɗangɓe pee nen ɗe Naan kǝ ten pǝrep mo, koo a nen Yahudi mo, koo a nen Heleni mo, ɓe Kristi wur a iiko mǝ Naan kǝ seen fir zak. ");
INSERT INTO sur_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Mbǝɗe mwen Naan nǝ met nseen gurum mo, kǝ ɓwàar kǝ Naan nǝ kǝ ɓal met ɓal mǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ɗyemnaa mo, wu pan kaaɗe Naan wur pǝrep wun sǝ. Baa gyet wur pǝrep a nen ɗe moo seen mǝ yil ɗǝsǝ ɗes kas, kǝ baa gyet a nen ɗe mo kǝ iiko ɗes kas. Baa a nen ɗe gyet mo làa mo mɓut nɗang mǝ nenlong mo ɗes kas. ");
INSERT INTO sur_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ɗangɓe Naan wur bǝlǝp a mbii ɗemwen mǝ yil nǝ mo, mbǝkǝ wur cin yitlwaan ɗi nenseen mǝ yil nǝ mo. Naan wur bǝlǝp mbii ɗe baa mo kǝ ɓal ndǝǝn yil nǝ kas, mbǝkǝ mo shweep mbii ɗe moo ɓal mo ɗi. ");
INSERT INTO sur_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Naan wur bǝlǝp a mbii ɗe yil nǝ ɓees, kǝ yil nii naa mo a kaa mbii ɗebuu mo sǝ, har kaa mbii ɗi baa mo ɗi kas sǝ, mbǝkǝ nǝ twe mbii ɗe yil nii naa mo, a kaa mbii ɗe moo koop nǝ sǝ ɗe. ");
INSERT INTO sur_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Mbeekǝ taji mee gwe canjoom nyit Naan kas. ");
INSERT INTO sur_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ɗangɓe Naan wur jì kǝ wun ndǝǝn Kristi Jesu, kǝ wur le Jesu Kristi a seen fun, kǝ ɗeret fun, kǝ a mɓee wur ɗangɓe wu mak ɗee a ɗeɓang nyit Naan, kǝ a wurang mun mɓut shikbish fun mo zak. ");
INSERT INTO sur_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Nǝ a kaa ɗe mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan sǝ nǝnee, <<Koo a weyii ɗe wur canjoom, ɓe nǝ ret kǝ wur canjoom nǝ ndǝǝn ɓe ɗe Daa Naan Cin.>> ");
INSERT INTO sur_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ɗyemnaa mo, kaaɗe gyet wen jì pee wun ɗe, ɓe baa gyet wen satpwoo nwun nkaa mbii ɗesǝsok mǝ Naan nǝ mo a shi liispwoo ɗeshang kǝleng, kǝ man satpwoo mǝ seen kas. ");
INSERT INTO sur_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Mɓǝɗǝ, kaaɗe gyet wen ashak kǝ wun, ɓe gyet wen kǝ ten lesen a kaa gwe ɗi baa wur man mǝ ɓe kas, a Jesu Kristi ɓejee, ɗe mo kǝ pwas wur nkaa shiyeepyoom sǝ. ");
INSERT INTO sur_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Gyet wen ashak kǝ wun, ɓe wen a ndǝǝn cíinɓal, kǝ ndǝǝn kǝǝrmuut kǝ ɗaar zak. ");
INSERT INTO sur_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Kǝ gyet pwoo ɗe wen kǝn sat nǝ, kǝ kám fen nǝ mo, baa gyet wen kǝn sat mo a shi pwoo ɗeshang kǝlǝng kǝ seen mǝ man satpwoo kas, amma gyet nǝ a ndǝǝn kám mǝ iiko kǝ Riin. ");
INSERT INTO sur_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Mbeekǝ taji wu le shinzeen fuu mo tong a ndǝǝn seen mǝ gurum mo kas, amma wu le shinzeen fuu mo a ndǝǝn iiko kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ɗangɓe muu sat a pwoo ɗi mǝ man, pee nen ɗe mo kǝ wurang ndǝǝn mbii ɗe mo a mǝ Riin Naan. Baa man ɗǝsǝ nǝ a mǝ yil ɗǝsǝ kas, kǝ baa nǝ put a pee nen mulki mǝ yil ɗǝsǝ mo, ɗe mo mbǝ ɗel dǝm sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ɗangɓe mun muu sat a pwoo nkaa man Naan ɗe nǝ a sǝsok ngurum mo, man ɗe Naan wur kǝ ten le mbe ɗeɗes fun akuɗang wur leyil nǝ. ");
INSERT INTO sur_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Baa mee ngu mulki mǝ yil ɗǝsǝ mmak man mǝnǝ kas. Katɗang ɗe gyet moo man mǝni, ɓe baa gyet mon mpwas Daa ɗe hai nkaa shiyeepyoom kas. ");
INSERT INTO sur_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Kaaɗǝ mo kǝ ten ran ndǝǝn ɓǝǝt haal sǝ nǝnee, <<Mbii ɗi baa gurum kǝ cham naa kǝ yit kas, <<ɗe baa gurum kǝ cham kǝlǝng nǝ shi kom kas, <<ɗe baa pǝtuup gurum kǝ cham pan <<mbii ɗe Naan wur kǝ tap ɗak nǝ le, <<nen ɗe mo wal nwur mo kas.>> ");
INSERT INTO sur_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ɗangɓe Naan wur kámshii mǝnǝ mmun a shi Riin fir, mɓeɗǝ Riin wur bǝlǝp mbii mo jir, har koo ɗi a jurum kǝ mbii aapwoo mǝ Naan mo. ");
INSERT INTO sur_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","A gurum ɗeɗang mmak man pan kǝ mee gwe yii? Katɗang baa a riin kǝ gwe nǝ kas yii? Nǝ aasǝ zak, baa mee ngwar cham man pan Naan kas, naa tǝng a Riin Naan ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Baa mun mu kat a riin mǝ yil ɗǝsǝ kas, amma mǝ lap a Riin Naan, mbǝkǝ mu manshii kǝ mbii ɗe Naan wur ten shìn mmun ɗe. ");
INSERT INTO sur_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Mɓǝmǝnǝ, pwoo ɗe muu sat nwun, baa nǝ put a mɓut mman mǝ gurum kas, amma a Riin wur woo nǝ mmun. Riin nǝ wur woo zeen, mbe nen ɗe mo kǝ Riin Naan ndǝǝn pǝtuup fur mo. ");
INSERT INTO sur_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ngwar ɗi baa wu kǝ Riin kǝ Naan ndǝǝn pǝtuup fin kas, ɓe baa wur mak lap zuum ɗe mo a mǝ Riin Naan kas. Mɓǝɗǝ mbii ɗe mo a mǝ Riin Naan, mo a pwoo ɗebuu pee gwe mǝnǝ ɗi, kǝzak, baa pan kǝ gwe mǝnǝ mak manshii mo nǝ kas, mɓeɗǝ a Riin Naan kǝ mak le gurum man mbii ɗǝsǝ nǝ mo. ");
INSERT INTO sur_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ngwe ɗewur kǝ Riin Naan ndǝǝn pǝtuup fir, ɓe wur mak manshii mbii ɗǝsǝ nǝ mo, amma baa mee gurum mak tokɗyeel nwur kas. ");
INSERT INTO sur_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Kaaɗǝ mo kǝ ten ran ndǝǝn ɓǝǝt haal kǝ Naan sǝ nǝnee, <<A wii kǝ man pan Daa yii? Mbeekǝ gwe mǝnǝ ɓeetpwoo ɗe kǝ wur yii?>> amma mun kǝ pǝtuup mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Ɗyemnaa mo, baa wen mak leshap kǝ wun kaa nen ɗe mo kǝ Riin Naan sǝ kas, ɗangɓe Wen katpwoo kǝ wun a kaa nen ɗi mǝ yil nǝ mo sǝ, mɓeɗǝ gyet wun a laa njuu mo ndǝǝn mbii ɗe mo a mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Gyet wen kǝn shin a wur nwun. Baa gyet a mbiise ɗeɓal kas, mɓeɗǝ baa gyet wu mak se mbiise ɗeɓal kas, har yaksǝ ɓe baa wuu ɗaksuk mɓe se mbiise ɗeɓal nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Tong fuu, nǝ ɗe a mǝ yil ɗǝsǝ, mɓeɗǝ wun kǝ cìn zuur, kǝ wuu jǝǝr kǝ shak. Kiyeet kǝ tong ɗesǝ kám nǝ, wun ɗe a mǝ yil nǝ, kǝ wuu mwaan a ndǝǝn shiimwaan mǝ yil ɗesǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Katɗang memee fuu sat nǝ, wuɗin a mǝ Pool, kǝ memee sat nǝ, wuɗin a mǝ Apolos, ɗang ntan azeen-nzeen ɓe wuu sat mbii mǝnǝ mo a ndǝǝn pan mǝ gurum kas aa? ");
INSERT INTO sur_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","A wii a Apolos yii? A wii a Pool yii? Mun a kǝrem Naan, ɗe Naan wur shìn ɗak mun kǝ har wu shinzeen. Koo ɗang a weyi ndǝǝn mun, ɓe gyet muu cìn a mbii ɗe Naan wur kǝ ten le nsar fun. ");
INSERT INTO sur_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","A an kop, ɗangɓe Apolos wur le am ɗike, amma a Naan wur le nǝ wurang. ");
INSERT INTO sur_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Mɓǝmǝnǝ ɓe gwe ɗewur kop mbii, kǝ gwe ɗewur le am ɗike, ɓe baa mo a mee mbii kas, amma a Naan bǝshin wur kǝ le mbii nǝ mo wurang. ");
INSERT INTO sur_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ngwe ɗe wur kop, kǝ gwe ɗewur le am ɗikǝ, ɓe mo a nchiit-nchiit. Koo a weyi ɓe wur nlap kwat fir a nchiit-nchiit kǝ ɗak ɗe gwe nǝ cìn. ");
INSERT INTO sur_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Mun jir a shaar ɗak kǝ Naan. Wun a bong kǝ Naan, kǝ wun a lu kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Shi ɗeret ɗe Naan wur kǝ ten shin nǝ wen, ɓe wen kǝn ɓwet kuklu nǝ, a kaa nguman ɗyiklu sǝ, kǝ mee gwe ɗyiklu nkaa kuk nǝ. Ɗangɓe nǝ a tǝng kǝ koo a weyi, ɓe wur tap kǝ ɗyikpee ɗe wur ɗyik nǝ nkaa kuk nǝ. ");
INSERT INTO sur_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Baa mee kuk ɗi, ɗe mee gurum nwaa baa ɓwet ɗi, waa met kuk ɗe Naan wur kǝ ten ɓwet nǝ, shi Jesu Kristi kas. ");
INSERT INTO sur_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Yaksǝ, katɗang mee gwe kǝ ɗyikpee nkaa kuk nǝ a shi zinariya, koo shi azurfa, koo shi ghǝk ɗekǝrǝm mo, koo shi yoom, koo shi shit, koo shi yangkas, ");
INSERT INTO sur_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ɓe nǝ ret kǝ ngwar mǝnǝ man nǝ, ret kǝ ɗak fir nǝn nɗee agaak parpuus ɗe Daa Jesu wur mbaajì ndǝǝn yil ɗesǝ. Parpuus mǝnǝ ɓe mon nwoo ɗak kǝ koo a ngwar ɗeɗangyii, har a wus ncham ret mǝ ɗak kǝ koo weyii. ");
INSERT INTO sur_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Katɗang baa wus se mbii ɗe gurum kǝ ten ɗyik nkaa kuk nǝ kas, ɓe gwar mǝnǝ nlap kwat. ");
INSERT INTO sur_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ɗangɓe katɗang wus se mbii ɗe gurum kǝ ten cìn nǝ, ɓe nǝn nɗee a ɗak ɗebuu, amma gwar mǝnǝ shikáa fir, ɓe wur nkat ɓam wur, amma nǝ ɗee kaa wu ɗel put wus nǝ a shi tambut sǝ. ");
INSERT INTO sur_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Baa wu man nǝ, wun shikáa fuu wun a lu ɗǝǝɗes kǝ Daa Naan kas aa? Kǝ Riin kǝ Naan kǝ tong ndǝǝn wun kas aa? ");
INSERT INTO sur_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Katɗang mee ngwar tǝkook lu kǝ Naan nǝ, ɓe Naan wun tǝkook gwar mǝnǝ zak. Mɓeɗǝ lu kǝ Naan nǝ a ɗeɓang kǝ a wuwun a lu kǝ Naan nǝ. ");
INSERT INTO sur_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Taji mee gurum numkáa fir kas, katɗang mee gurum ndǝǝn wun ɗi wu kǝ lekáa fir a kaa ngwar ɗi kǝ seen nyìcinsǝ, ɓe nǝ ret kǝ gwar mǝnǝ lekáa fir kaa mwen sǝ, mbǝkǝ wur kat seen ɗi. ");
INSERT INTO sur_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mɓeɗi seen mǝ yil ɗesǝ nǝ a mwen nyit Naan ɓejee, kaaɗe mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan sǝ nǝnee, <<Naan wur yak nenseen mǝ yil ɗesǝ mo, nɗǝǝn seen fur ɗebish.>> ");
INSERT INTO sur_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Kǝzak, <<Daa wur man nǝnee, <<pan kǝ nenseen mǝ yil ɗesǝ mo nǝ a mbii ɗebuu.>> ");
INSERT INTO sur_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Mɓǝmǝnǝ ɓe taji mee gurum canjoom nkaa gurum mo kas. Mɓeɗi mbii mo jir a muu. ");
INSERT INTO sur_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Koo ɗang ɗe a Pool, koo a Apolos, koo a Kefas, koo ɗe a yil ɗesǝ, koo ɗe a seen, koo ɗe a muut, koo ɗe a yaksǝ, koo ɗe a mbii ɗe mo akyeen, ɓe mo jir a muu. ");
INSERT INTO sur_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kǝzak, wun a mǝ Kristi, kǝ Kristi wur a mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nǝ ret kǝ gurum mo man mun a kaa jeplep kǝ Kristi mo sǝ, kǝ kaa nenɗak mo, ɗe Naan wur kǝ ten le zeen mbii fir ɗesǝsok mo ndǝǝn sar fun sǝ. ");
INSERT INTO sur_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Nǝ a tǝng nen ɗe mo kǝ ten le zeen nǝ nsar fur, ɓe mo ɗee a nenyil ɗe mon ncínzeen mmo. ");
INSERT INTO sur_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Baa nǝ daampee wen kas koo dǝɓen, katɗang wu cham an, koo ɗe cham nǝ a nluɗyeel mǝ gurum mo, baa wen kǝn tokɗyeel nsen kas. ");
INSERT INTO sur_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Wen man nǝ, baa an ɗel ɗike kas, amma jir kǝsǝ, ɓe baa nǝ kám nǝ wen a nen nshikbish kas. A Daa wur a gwe ɗe wur tokɗyeel wen. ");
INSERT INTO sur_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Mɓǝmǝnǝ ɓe, taji wu canɗyeel nkaa mee gurum kas, atǝng pee nǝ wul akuɗang. Wu gong waaji nDaa. Daa wur njì le mbii ɗe mo a sǝsok mo ɗee agaak, kǝ wur nwang pan ɗe mo ndǝǝn pǝtuup kǝ gurum mo ɗee agaak zak. A nchiit kǝ mǝnǝ ɓe koo a weyii, ɓe Naan wun nkwoop wur nchiit-nchiit kǝ kwoop ɗe nǝ ret kǝ wu kat. ");
INSERT INTO sur_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Yaksǝ ɗyemnaa mo, wen kǝn sat sǝmpwoo ɗǝsǝ mo nkaa Apolos kǝ sen fen, mbǝkǝ mu ɗee ɗi a mbiikám pee wun ɗi, <<Taji wu cìn mbii mo met mbii ɗi mo kǝ ten ran nǝ kas,>> Kǝ taji memee fuu cìn roop nkaa mee gurum, kǝ wur ɓees mee gurum ɗi kas zak. ");
INSERT INTO sur_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","A wii le waa met niyee mo yii? Baa dǝ a Naan shin mbii ɗe waa kǝ mo jir kas aa? Katɗang nǝ aasǝ, ɓe a me le ɗang gha kǝ ɗyeepkáa ye, kaa baají waa lǝlap a nzuum sǝ kas sǝ aa? ");
INSERT INTO sur_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Wuu ten wu kat mbii ɗe wuu Rǝɓet mo jir. Wuu ten wu ɗee a nenlong mo. Wuu ɗee a mishkoom mo, baa ashak kǝ mun kas. Ɗyen wen kǝ ɗe wuu ten wu ɗee a mishkoom mo, kǝ mun ɗee ɗi a mishkoom ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Nnaa mǝnǝ, ɓe Naan wu kǝ le mun a jeplep Jesu mo. Muu ɗee a nen ɗe mo tong sham sǝǝt nǝ, kaa nen ɗe mo kǝ ten canɗyeel muut mmo sǝ, mbǝkǝ mo twe mun ɗi nyit gurum mo ɗes. Mu ɗee a mbiishwar nyil nǝ jir, nyit mǝ Nenlep Naan mo, kǝ nyit gurum mo zak. ");
INSERT INTO sur_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Mu ɗee a mwen mo mɓe sǝm kǝ Kristi, amma wun a nenseen mo ndǝǝn Kristi. Baa mun kǝ ɓal kas, amma wun kǝ ɓal. Gurum mo shìn ɗeɗes nwun, amma mo ɓees mun. ");
INSERT INTO sur_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Har yaksǝ ɓe neen kǝ láa mmun, kǝ neen am kǝ tu mun. Muu jwal a goklee mo, kǝ gurum moo nas mun. Baa mun kǝ mee tul kas. ");
INSERT INTO sur_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Muu cìn ɗak ɓalɓal shi sar fun mo. Katɗang gurum mo ɓees mun, ɓe muu le ɗeret nkaa mo. Katɗang mo lejeel mmun, ɓe muu gung. ");
INSERT INTO sur_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Katɗang mo satpwoo ɗebish nkaa mun, ɓe muu lap mmo shi pwoo ɗeret. Yaksǝ, ɓe mo ɗee a kaa zungtung ɗi gurum moo ɓeerpee ɗe sǝ. Muu ɗee a mbii ɗebish ɗe koo weyii kǝ cii mun ndǝǝn yil nǝ. ");
INSERT INTO sur_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Wen kǝn ran ɗesǝ nwun, baa a mbǝkǝ an cin yitluwaan ɗi nwun kas, amma a mbǝkǝ nghan kámshii nǝ ɗi nwun, kaa jep fen ɗi nghan wal mmo sǝ. ");
INSERT INTO sur_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Koo ɗang ɗi wun kǝ nenkám mo ngal kaapaat ndǝǝn Kristi, amma ɓe wun kǝ puun a mǝndong. Mɓǝɗǝ ndǝǝn Jesu Kristi, ɓe wen kǝn ɗee a puun fuu ndǝǝn pwoo ɗeret nǝ. ");
INSERT INTO sur_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Mɓǝmǝnǝ, ɓe Wen kǝn ɗang pǝ wun, kǝ wu mwaan ndǝǝn shiimwaan fen zak. ");
INSERT INTO sur_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","A mbii ɗe nǝ le mmǝnǝ, ɗangɓe Wen kǝn lep Timoti, ɗyem fen, ɗe wen wal nwur, ɗe wur kǝ ɗar ɓalɓal ndǝǝn Daa, dǝm pee wun ɗǝ. Wur yee nwun nkaa mwaan fen ndǝǝn Kristi Jesu. Mwaan fen nǝ nchiit-nchiit kǝ mbii ɗi Wen kǝn kám ngurum mo, koo a nneye ndǝǝn Ekǝlisya mo. ");
INSERT INTO sur_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Pak mo ndǝǝn wun, moo roop kaa baa wen nkuɗi kǝn mbaadǝm pee wun ɗi kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Katɗang Daa wur rǝɓet, kǝ wen dǝm pee wun ɗi kǝlak-kǝlak, ɓe wen nnaa mbii ɗe nenroop nǝ moo sat, kǝ wen nnaa iiko ɗe mo kǝ nǝ zak. ");
INSERT INTO sur_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Baa mulki Naan nǝ a sat shi pwoo kas, amma nǝ a iiko. ");
INSERT INTO sur_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Wu rǝɓet a ɗeɗangyii? Kyet wen njì pee wun ɗi a shi mbwat wo? Koo ɗang a shi wal mǝ riin ɗe nǝ a pǝɗok yii? ");
INSERT INTO sur_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Azeen gurum moo sat nwen nǝ nencìn ngaa mo ɗi nnaar fuu, kaan ngaa ɗe koo a nenkum mo, ɓe baa moo cìn mǝnǝ kas. Mɓeɗi wen kǝlǝng nǝ, laa kǝ saam kǝ mat kǝ puun fin. ");
INSERT INTO sur_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Har nnǝ, wuu cìn roop kǝ mǝnǝ. Baa ɗi nǝ ret kǝ wu gam aa wat pǝtuup, kǝ ɗi nǝ ret kǝ wu ceen kaan nen ɗe moo cìn mbii ɗebish mǝnǝ mo ndǝǝn tong ashak fuu kas aa? ");
INSERT INTO sur_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Koo ɗang ɗi baa nghan ashak kǝ wun mɓut nan kas, amma wen ɗi ashak kǝ wun ndǝǝn Riin, kǝ wen kǝn ten canɗyeel ɗebish gwe ɗi wu cìn mbii ɗebish mǝnǝ nɗeen sǝm kǝ Jesu Kristi, kaa nghan ɗi ashak kǝ wun sǝ. ");
INSERT INTO sur_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Katɗang wu kuur ashak ndǝǝn sǝm kǝ Daa Jesu, ɓe wen ɗi ashak kǝ wun ndǝǝn riin, kǝ iiko mǝ Daa fun Jesu nǝ ɗi ashak kǝ mun. ");
INSERT INTO sur_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Wu shin ngucìn ngaa nǝ nsar Shetan, mbǝkǝ shin fin ɗi nǝ a mǝ cìn shikbish nǝ muut ɗi, amma riin fir nǝ ɗee ɗi a ɗeɓǝɓam parpuus mǝ Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Baa roop fuu nǝ ret kas, koo dǝɓen. Baa wu man nǝ a rep yist nlee ɓe nii fuk gǝǝl aas kas aa? ");
INSERT INTO sur_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Mɓǝmǝnǝ ɓe wu pwat kǝ yist ɗesǝǝr mǝ shikbish nǝ ndǝǝn tong fuu mo aku mbǝkǝ wu ɗee ɗi a nenyil ɗeɓang mo. Gyet Jesu Kristi wu muut a mbǝ shikbish fun mo, a wu a Laatǝm mǝ Retnyit kǝ Canɗel fun, ɗe mo kǝ ten shin wur a mbiizuum sǝ. ");
INSERT INTO sur_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Mɓǝmǝnǝ ɓe wu yit kǝ mu sekyeen kǝ cìn Retnyit mǝ Canɗel fun, baa a shi gǝǝl aas ɗe nii yist ɗesǝǝr mǝ shikbish kǝ ɓutbish kas. Ɗangɓe mǝ cìn Retnyit mǝ Canɗel nǝ shi gǝǝl aas ɗi baa nii yist kas, gǝǝl aas ɗe nǝ a mǝ pǝtuup mǝndong kǝ zeen. ");
INSERT INTO sur_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Gyet wen kǝn ran nwun ndǝǝn lepran fen nnǝ taji wu ɓalkaa fuu ashak kǝ nencìn ngaa mo kas. ");
INSERT INTO sur_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Baa gyet wen kǝn satpwoo a nkaa nencìn ngaa ɗi mǝ yil ɗesǝ mo, kǝ nenrǝɓet mbii mo, koo wat mo, koo nenyil ɗi moo seyil nkùm mo kas. Katɗang wu rǝɓet kǝ taji mee mbii ɓàl wun kǝ nenyil ɗesǝ mo kas, ɓe nǝ a tǝng kǝ wun mpwat aku ndǝǝn yil ɗesǝ kǝnding-nding mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Amma wen kǝn ran nwun, nǝ, taji wu ɓalkaa fuu kǝ ngwar ɗe wu kǝ pet shin a ngudǝm nɗang Jesu, ɗangɓe wur kǝ cìn ngaa, koo rǝɓet mbii, koo seyil nkùm, koo satpwoo ɗebish nkaa gurum mo, koo shwaamwes, koo ngucìn wat kas. Baa nǝ ret kǝ wu se mbiise ashak kǝ gwar mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Baa nǝ a ɗak fen mbǝkǝ an tokɗyeel nenyil ɗi baa mo a nen dǝm nɗang Jesu mo kas. A wun tokɗyeel nenyil ɗe mo ndǝǝn Ekǝlisya mo ɓejee. ");
INSERT INTO sur_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","A Naan nwur ntokɗyeel nenyil ɗi baa mo a nendǝm nɗang Jesu kas. Wen sat nǝnee, <<Wu ceen ngwar ɗebish put aku mbut nwun.>> ");
INSERT INTO sur_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Katɗang memee ndǝǝn wun kǝ mee pwoo nkaa ɗyemnǝǝn fin, ɓe wu naa nǝ ret kǝ wu mang pwoo nǝ, dǝm kǝ nǝ ntoom kǝ nguɗyeel ɗi baa wu a ngucínzeen kas aa? Baa nǝ ret kǝ a nen Naan mo ɓeetpwoo mǝnǝ kas aa? ");
INSERT INTO sur_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Baa wu man nǝ, a nen Jesu mon ntokɗyeel nyil nǝ kas aa? Katɗang a wun nyool wu tokɗyeel nyil nǝ, ɓe baa, wu mak ɓeet rep jep pwoo ɗelee-lee mo kas aa? ");
INSERT INTO sur_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Baa wu man nǝ, parmeeci ɓe a mun ntokɗyeel Nenlep kǝ Naan mo kas aa? Katɗang nǝ aasǝ, ɓe a me le ɗang baa mǝ mak ɓeet ɗyeel ɗi mǝ yil ɗesǝ kas ye? ");
INSERT INTO sur_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Katɗang wun kǝ ɗyeel mo, ɓe a me le ɗang wuu dǝm kǝ ɗyeel nǝ a ntoom kǝ nen ɗe baa mo a mee mbii pee Ekǝlisya mo ɗe kas ye? ");
INSERT INTO sur_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Wen sat ɗesǝ nǝ a mbǝkǝ nǝ shweep wun ɗi. A nǝ le ɗang kǝn sat nwun nǝ, baa wun kǝ mee gurum ɗeseen ndǝǝn wun, ɗewur mmak ɓeet ɗyeel mǝnǝ mo nwun nendǝm nɗang Jesu mo kas aa? ");
INSERT INTO sur_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Kyet nǝ ret kǝ ngudǝm nɗang Jesu mang ɗyemnǝǝn fir ngudǝm nɗang Jesu zak, dǝm kǝ wur nluɗyeel, mbǝkǝ wu ɗar ɗi ntoom nguɗyeel ɗe baa wu a ngucínzeen kas wo? ");
INSERT INTO sur_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Katɗang wuu mangshak wu dǝm kǝ nǝ nluɗyeel, ɓe nǝ kám nǝ, wuu taa wu ɗee kǝnding-nding mmǝnǝ. Gyel ɗesǝ ɓe wu yit kǝ ɗyemnǝǝn fuu mo wàt pǝtuup wun met aku ɗi wun dǝm kǝ shak nluɗyeel. Gyel ɗee a sǝ ɓe wu yit kǝ mo seen kaa wun kas aa? ");
INSERT INTO sur_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ɗangɓe wun shikáa fuu, wuu wàt pǝtuup nshak, kǝ wuu seen kaa shak zak. Jir ɗi wun a ɗyemnǝǝn ɗemǝndong ndǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Baa wu man kas aa? Nǝ, baa nen ɗǝbish mon nɗel mmulki Daa Naan kas. Taji wu numkáa fuu kas. Baa nencìn mbii ɗebish mo, koo nenseyil nkùm mo, koo nencìn ngaa mo, koo mish ɗe moo teer kǝ shak, koo mat ɗi moo teer nshak, koo wat mo, koo nenrǝɓet mbii mo, koo nenshwaa mwos mo, koo nensatpwoo ɗebish nkaa gurum mo. Koo ɗang nenseen akǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","Baa mon mmak ɗel ndǝǝn mulki Naan kas. ");
INSERT INTO sur_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Gyet yam ɓe pak fuu mo kǝ cìn mbii ɗiisi mo, amma mo kǝ vwang wun mɓut shikbish. Yaksǝ mo kǝ le kǝ wu ɗee a nen Naan. Yaksǝ ɓe Daa Jesu Kristi, kǝ Riin Naan fun, wu kǝ le kǝ wu ɗee a nen ɗin ɗǝre mo nyit Naan. ");
INSERT INTO sur_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Meeɓe mee gurum sat nǝ, <<Baa mee mbii ɗe nǝ cíi cìn ɗi kas.>> Ii, azeen, amma baa a mbii mo jir ɗi mo kǝ kwoop nǝ kas, <<Pee wen ɗi, ɓe nǝ azeen-nzeen nǝ, baa mee mbii ɗe nǝ cíi cìn ɗi wen kas.>> Ɗangɓe baa Wen rǝɓet ɗee a kǝrem kǝ mee mbii kas. ");
INSERT INTO sur_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Mee gwe tal nǝnee, <<Mbiise nǝ a mbǝ ɓut, kǝ ɓut a mbǝ mbiise.>> Nǝ azeen, amma Naan wu nshirip mo weet. Baa mo leshin kǝ gurum, a mbǝ cìn mbii ɗebish mo kaa ngaa sǝ kas. Ɗangɓe mo leshin kǝ gurum a mbǝkǝ nǝ cìn ɗak ɗi Daa, kǝ a Daa wur tap kǝ shin kǝ gurum nǝ zak. ");
INSERT INTO sur_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Naan wu yool kǝ Daa a peemúut, ɓe wu nyool kǝ mun a peemúut shi iiko fin aasǝ zak. ");
INSERT INTO sur_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Baa wu man nǝ, fwoshik fuu nǝ mo, a ɓeep kǝ Kristi kas aa? Chinarang ɗangɓe wen mmang mee ɓeep kǝ Kristi, kǝ nghan ɓal nǝ ashak kǝ ɓeep mǝ mat ngaa yii? Baa mǝnǝ mmak cìn kas koo dǝɓen! ");
INSERT INTO sur_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Baa wu man nǝ, ngwar ɗi wu ɓàlshin fin kǝ mat ngaa, ɓe wu ɗee a nan ɗemǝndong kǝ mat ngaa nǝ kas aa? Mɓǝɗǝ mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan nǝnee, <<Mo vǝl, mon nɗee a nan ɗemǝndong.>> ");
INSERT INTO sur_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ɗangɓe ngwar ɗe wu ɓal shin kǝ Daa, ɓe mo ɗee a ɗemǝndong ndǝǝn Riin. ");
INSERT INTO sur_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Wu swa wu baa aku pee mbii ɗebish mo, kaa ngaa sǝ. Koo a shikbish ɗeɗangyii, ɗe gurum kǝ cìn nǝ, ɓe wur kǝ cìn nǝ a kǝɓwoon kǝ fwoshik fin. Ɗangɓe gwar ɗi wu kǝ cìn ngaa, ɓe wu kǝ cìn shikbish a nkaa fwoshik fin. ");
INSERT INTO sur_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Baa wu man nǝ, fwoshik fuu nǝ a lu kǝ Riin kǝ Naan ɗewur tong ndǝǝn wun kas aa? A Naan wu shin Riin mǝnǝ wun kǝ baa wun a mukáa fuu kas. ");
INSERT INTO sur_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Jesu kǝ seet kǝ wun shi mbii ɗekǝrǝm, mbǝmǝnǝ, ɓe nǝ a tǝng, kǝ wu shìn ɗeɗes nNaan shi fwoshik fuu mo. ");
INSERT INTO sur_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Yaksǝ, ɓe wen kǝn rǝɓet satpwoo nwun nkaa mbii ɗe ɗí wu ran mo. Nǝ ret kǝ gurum tong kǝsǝ nen nlapmat. ");
INSERT INTO sur_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ɗangɓe mɓe jwaan mǝ cìn ngaa, ɓe nǝ ret kǝ koo a mish ɗeɗangyi, ɓe wur kǝ mat fin, kǝ koo a mat ɗeɗangyi, ɓe war kǝ mish fer. ");
INSERT INTO sur_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Nǝ ret kǝ mish nǝ wu cìn mbii ɗe nǝ ret kǝ wur cìn mmat fin, kǝ nǝ ret kǝ mat nǝ waa cìn mbii ɗi nǝ ret kǝ war cìn mmish fer zak. ");
INSERT INTO sur_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Baa mat war kǝ iiko nkaa fwopshik fer kas, amma mish war wur kǝ nǝ. Nǝ aasǝ zak, baa mish wur kǝ mee iiko nkaa fwoshik fin kas, amma a mat wur war kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Taji wu cíi nshak akǝ fwoshik fuu mo kas, see katɗang wuu ten wu lap ii kǝ shak nǝ, wun nnookɗi mɓe rep mee pee mo nlee ɗak, mbǝkǝ wu lekáa fuu ɗi mɓe cìn ɗangnaan (leshap kǝ Naan). Ɗangɓe aɓwoon mǝnǝ, ɓe wu baa wu kaat ɗi nshak, mbǝkǝ taji ngujwan gwam wun mɓe cíin yaasuk kas. ");
INSERT INTO sur_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Wen kǝn satpwoo ɗesǝ mo nwun a kaa chiin sǝ, baa wen kǝn sat a mee Wàar nwun kas. ");
INSERT INTO sur_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Azeen, wen rǝɓet kǝ, ɗe wun ntong kaa an sǝ, amma koo weyi, ɓe wu kǝ lap zuum pee Naan ɗi ɗyík kǝ mǝ gǝnǝǝn. Naan wu shin zuum mo mmun a shini-shini. ");
INSERT INTO sur_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Yaksǝ, wen kǝn sat nen ɗi baa mo kǝ cìnɗyik kas, kǝ matkaa mo nǝ, nǝ ret kǝ mo tong kǝ sǝ, kaa an sǝ. ");
INSERT INTO sur_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ɗangɓe katɗang ɓe baa mo mak yaasut kas, ɓe nǝ ret kǝ mo cìnɗyik, mbǝɗe ngyel gurum cìnɗyik, met aku ɗi coor se seen ngurum. ");
INSERT INTO sur_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Mpee nen ɗe mo kǝ cìnɗyík, ɓe wen kǝ mee Wàar ɗi, (baa a an kas, amma a Daa wu kǝ shin nwen) mbǝkǝ an sat ɗi mo nǝ. Taji mat waa ɓàkshak kǝ mish fer kas. ");
INSERT INTO sur_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Katɗang war ɓàkshak kǝ mish war, ɓe taji war baa cìn mee ɗyik ɗi zak kas, kasɓe, war waaji pee mish waa ɗi, kǝ mo ɗak ɗyik fur ɗi. Taji mee mish wur tuɗyík kǝ mat fin kas. ");
INSERT INTO sur_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Mpee koor nǝ mo, ɓe wen sat nǝ, (baa a Daa wu sat mǝnǝ kas, a an), katɗang mee ngudǝm nɗang Jesu, wur kǝ mat ɗi baa war kǝ cinzeen kas, ɗangɓe war rǝɓet tong ashak kǝ mish fer, ɓe taji wur ɓàkshak kǝ war kas. ");
INSERT INTO sur_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Katɗang mee mat dǝm nɗang Jesu war kǝ mish ɗi baa wur kǝ shinzeen kas, ɗangɓe wur rǝɓet tong ashak kǝ war, ɓe taji war ɓàkshak kǝ wur kas. ");
INSERT INTO sur_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Mbǝɗe mish ɗi baa wur kǝ shinzeen kas, ɓe wur ɗee a ɗelǝlap nyit Naan, mɓe mat fin ɗi war kǝ shinzeen. Kǝzak, mat ɗi baa war kǝ cinzeen kas, ɓe war ɗee a ɗelǝlap nyit kǝ Naan, mɓe mish war ɗewur shinzeen. Kat kǝsǝ kas, ɓe jep fuu mon nɗee a kaa jep kǝ nenkum mo sǝ, amma yaksǝ ɓe mo a ɗelǝlap nyit Naan. ");
INSERT INTO sur_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ɗangɓe katɗang mish koo mat, ɗe baa mo kǝ shinzeen kas, moo rǝɓet ɓàkshak, ɓe wur yit kǝ mo ɓàkshak ɗi. Katɗang nǝ aasǝ, ɓe ngushínzeen nǝ, kyet a mish aa, koo a mat nǝ ye, ɓe gwe nǝ kǝ pee, mɓe cìn mbii ɗi wur naa nǝ ret. Mɓǝɗǝ Naan wur pǝrep mun a mbǝkǝ mu tong ɗe ryang kǝ shak. ");
INSERT INTO sur_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Wii mat dǝm nɗang Jesu, cirang yi mman ɗi ye? Ngul yi nyool yi ɓam wur mish yii? Waa mish ngudǝm nɗang Jesu, cirang gha mman ɗi yii? Ngul waa nyool a ɓam mat fwaa yii? ");
INSERT INTO sur_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Koo weyi, ɓe wur tong nchiit kǝ peeɗe Daa wur le gwe nǝ ɗi, Naan wur kǝ pet gwe nǝ mɓe nǝ. A ɗǝsǝ nǝ a Wàar fen pee koo a Ekǝlisya ɗeɗangyi. ");
INSERT INTO sur_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ngwe ɗi gyet mo kǝ ten can wur akuɗang Naan kǝ pet wur, ɓe taji wur yappee ɗewur nɗee ɗi nsuluk kas. Kǝ gwar ɗe baa gyet mo kǝ ten can wur kas, ɗangɓe Naan pet wu, ɓe taji wur waa tang ar ɗi mon ncan wur ɗi kas. ");
INSERT INTO sur_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Mɓǝɗǝ koo ɗi mo can gwe nǝ, kǝ koo ɗi baa mo can ngwar nǝ kas, ɓe baa mǝnǝ mo kǝkoop nǝ kas. Ɗangɓe mbii ɗe nǝ kǝkoop nǝ, a ɗi gurum ntap kǝ Wàar kǝ Naan mo ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Koo weyi, ɓe wur tong ɗi ndǝǝn peeɗi gyet wur kǝnǝ, akuɗang Naan kǝ pet wur sǝ. ");
INSERT INTO sur_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Katɗang gyet waa a kǝrem, akuɗang Naan kǝ pet gha, ɓe taji mǝnǝ daampee nwaa kas. Ɗangɓe katɗang waa mak katpee, mbǝkǝ a ɗee ɗi a mukáa fwaa, ɓe a gung kǝ a kat nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ngwe ɗi gyet Naan pet wur ɓe wur kuɗi a kǝrem, ɗangɓe yaksǝ, ɓe wur ɗee a mukáa fin ndǝǝn Daa. Nǝ aasǝ zak, gwe ɗe gyet wur a laa lu kaa ɗe Naan pet wur, amma yaksǝ gwe mǝnǝ ɗee a kǝrem mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Jesu Kristi sǝrep wun a shi toom ɗekǝrǝm, Mɓemǝnǝ ɓe taji wu ɗee a kǝrem mǝ gurum mo kas. ");
INSERT INTO sur_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Nǝ aasǝ, ɗyemnaa mo, koo ɗi gyet mo pǝrep wun a ndǝǝn tong ɗeɗangyi, ɓe nǝ ret kǝ mu tong ɗi a ndǝǝn tong mǝnǝ ashak kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Pwoo nkaa nen ɗe baa mo kǝ cìnɗyik kas, ɓe baa wen kǝ mee Wàar pee Daa ɗi, mbe mo kas. Ɗangɓe wen kǝn sat a pan fen, kaa gwe ɗi ndǝǝn kambok kǝ Naan, ɓe gurum mo mak shinzeen wen sǝ, ɓe wen kǝn pan nǝ, ");
INSERT INTO sur_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Mpee mbii daampee ɗi mo ɗi yaksǝ, ɓe wen naa nnǝ nǝ ret kǝ taji gurum cìnɗyik kas. ");
INSERT INTO sur_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ɗangɓe katɗang waa kǝ mat, ɓe taji a tang ar mɓe tuɗyik nǝ kas. Katɗang baa waa kǝ mat kas, ɓe taji a tang ar mbǝkǝ a lapmat ɗi kas. ");
INSERT INTO sur_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ɗangɓe katɗang waa cìnɗyik, ɓe baa waa cìn a shikbish kas, kǝ katɗang mee reep cìnɗyik, ɓe baa war cìn shikbish kas. Ɗangɓe jir kǝsǝ, nen ɗi mo cìnɗyik, ɓe mon nkat jeel mǝ yil nǝ. Mɓǝmǝnǝ, nnaa fen ɓe taji gurum cìnɗyik kas, mbǝkǝ taji wur shwaajeel. ");
INSERT INTO sur_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Mbii ɗe wen kǝn rǝɓet sat nǝ nɗesǝ ɗyemnaa mo, peeɗi Naan wur kǝ ten bǝlǝp nǝ le, nǝ kǝ wul kus. Yool nyaksǝ, ɓe nen ɗe mo kǝ mat mo, ɓe mo tong kaa baa mo kǝ cham cìnɗyik kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Nen ɗi mon mmaap, ɓe mo tong kaa nen ɗi baa mon mmaap kas sǝ. Nen ɗi mon nretnyit, ɓe mo tong kaa baa mo a nretnyit kas sǝ. Nen ɗi mo nkaa nweer mo, ɓe mo tong kaa nen ɗi baa mo kǝ mee mbii kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Nen ɗi moo cìn ɗak kǝ mbii mǝ yil ɗesǝ mo, ɓe mo tong kaa baa mo kǝ cham cìn mee mbii kǝ mbii mǝ yil nǝ mo kas sǝ. Mɓǝɗǝ mbii ɗe mǝ yil ɗesǝ nǝ mo nkaa ɗel seet. ");
INSERT INTO sur_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ɗyeen nwen, kǝ taji wu daampee nsuk kas. Ngwe ɗi baa wu kǝ cìnɗyik kas, ɓe wur le pǝtuup fin a nkaa mbii ɗi mo a mǝ Daa. Wur pan a ar ɗi wur ncìn ɗak ɗi mo ret ɗi nDaa nyit. ");
INSERT INTO sur_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ɗangɓe ngwar ɗi wu kǝ cìnɗyik, ɓe wur kǝ le pǝtuup fin a nkaa mbii mǝ yil nǝ mo, wur kǝ pan a ar ɗi wur ncìn mbii ɗe mo ret ɗi mmat fin nyit. ");
INSERT INTO sur_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Ɗesǝ nǝ le kǝ pan fin mo ɓak vǝl mmǝnǝ. Mat ɗi baa war kǝ cìnɗyik kas, koo reep, ɓe war le pǝtuup war a nkaa ar ɗi war ncìn mbii ɗe mo ret ɗi nDaa nyit, kǝ ar ɗi war nɗee a ɗeɓang ndǝǝn nan, kǝ ndǝǝn Riin. Ɗangɓe mat ɗi war kǝ cìnɗyik, ɓe waa le pǝtuup fer a nkaa mbii mǝ yil nǝ mo, ɗi war ncìn, mbǝkǝ nǝ ret ɗi mmish fer nyit. ");
INSERT INTO sur_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Wen kǝn sat ɗesǝ a mbǝkǝ nǝ ɓam wu wun ɗi, baa wen cíi a cìnɗyik nwun kas, ɗangɓe wen sat pwoo sǝ mo a mbǝkǝ mbii mo dǝm ɗi nwun ndǝre-ndǝre, kǝ mbǝkǝ wu cìn ɗak mǝ Daa ɗi shi pǝtuup mǝndong. ");
INSERT INTO sur_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Katɗang nǝ dampee mǝ gwar, kaa baa wur pee cin ɓe ɗe nɗere nmat kwam fin kas ɗang katɗang coor mat kǝ jar dampee nwur, ɗang wur nan nǝ ret kǝ mo cin dyik ɗi, ɓe nǝ ret kǝ wur cin ɓe ɗe nǝ nbut pan wur, baa wur pee cin a shikbish kas. ");
INSERT INTO sur_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ɗangɓe katɗang ɓe wur naa nǝ, baa nǝ a tǝng kǝ wur cìnɗyik nreep fin kas, kǝ wur ɗar kǝ pan fin nkaa mbii ɗi wur naa nǝ ret nwur, kǝ wur fes le pǝtuup fin ɓalɓal nǝ, wur mmak tap kǝ waar, ɓe wur cìn a mbii ɗe nǝ ret. ");
INSERT INTO sur_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ngwe ɗe wur cìnɗyik, ɓe wur cìn a mbii ɗi nǝ ret, ɗangbe gwe ɗi baa wur cìnɗyik kas, ɓe wur cìn a mbii ɗe nǝ waa ret met. ");
INSERT INTO sur_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Mat war a nder mish fer, har parpuus ɗi wur mmuut. Katɗang mish nǝ muut, ɓe waa kǝ pee mɓe cìnɗyik koo a weyi ɗi war kǝ rǝɓet, ɗangɓe tǝng a gwe ɗi wur ndǝǝn Daa. ");
INSERT INTO sur_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Amma katɗang a nnaa mǝnǝ, ɓe war ntong shi retnyit met, katɗang war nook cìnɗyik. Pan fen, ɓe wen kǝ Riin Naan zak. ");
INSERT INTO sur_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Yaksǝ, pwoo nkaa mbiise ɗi mo kǝ ten shìn nkùm mo, mǝ man nǝnee, <<mun jir mun kǝ man >> Man nii le kǝ gurum ɗyeepkáa, ɗangbe wal nii tap ɗyik gurum kàa rǝret. ");
INSERT INTO sur_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Katɗang mee gurum kǝ pan nǝ, wuɗi man mee mbii, ɓe baa wu kǝ man mee mbii kaaɗe nǝ ret kǝ wur man sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ɗangɓe gwe ɗe kǝ wur wal nNaan, ɓe Naan man gwe mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Yaksǝ, pwoo nkaa se mbiise ɗe mo kǝ ten shin nǝ nkùm mo, mǝ man azeen nǝ, baa kùm mo kǝ mee seen kas. Kǝzak, mǝ man nǝ, Naan wur a ɓishin ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Koo ɗi pak mbii mo ɗi, ɗe moo pet mo a naan mo, ɗi mo ndǝǝn ɗengnaan, koo ɗe mo ndǝǝn yil ɗesǝ, mbǝɗe naan mo ɗi ɗes, kǝ daa mo ɗi ɗes zak. ");
INSERT INTO sur_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Ɗangɓe jir kǝsǝ, ɓe pee mumun ɗi, ɓe Naan wur a mǝndong ɓejee, ɗewur a puun fun, a wur le mbii mo jir, kǝ a mbǝ wur ɗangɓe mun kǝ seen. Daa fun wur a mǝndong ɓejee zak, wur Jesu Kristi, ɗi a ndǝǝn wur ɓe Naan le mbii mo jir, kǝ a ndǝǝn wur ɓe mun kǝ seen. ");
INSERT INTO sur_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ɗangɓe baa a gurum mo jir mo kǝ man zeen ɗesǝ nǝ kas. Pak mo kǝ fes loot kǝ kùm mo hakyeng, har mbǝ cicinsi, ɓe katɗang mo se mbiise, ɓe moo pan nǝ mbiise nǝ a mǝ kùm. Baa pan ɗe mputuup fur nǝ ɓal kas, kǝ mo pan nǝ, wuɗun kǝ ɗee, a ɗewuwat mbǝ mbiise. ");
INSERT INTO sur_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Baa mbiise mak jì kǝ mun kus kǝ Naan kas. Koo ɗi mu se mbiise, ɓe baa mun nshee ɗi kas, kǝ koo ɗi baa mu se mbiise kas, ɓe baa mun ntaa mǝ kat kas. ");
INSERT INTO sur_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Ɗangɓe wu tap taji katpee fuu mɓe cìn mbii ɗi wuu rǝɓet nǝ ɗee a mbii canshii nen ɗi baa shinzeen fur nǝ ɓal kas. ");
INSERT INTO sur_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Mɓǝɗǝ katɗang mee gwar ɗe baa shinzeen fin nǝ ɓal ndǝǝn mbii ɗesǝ mo kas, wur naa gha gwar ɗi waa kǝ man, aa se mbii nlukùm, ɓe baa nǝn nshìn ɓal nwur ndǝǝn pǝtuup wur ɓe kǝ wur se mbiise ɗi mo kǝ ten shin nǝ nkùm kas aa? ");
INSERT INTO sur_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Nǝ aasǝ, ɓe shi man fwaa, gha le kǝ ɗyemnǝǝn fwaa ɗi Kristi kǝ muut mɓe wu, wu ɗee a ɗelǝloom. ");
INSERT INTO sur_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Katɗang gha cìn mbii mǝnǝ, ɓe gha cìn shikbish nkaa gǝnang, mbǝɗe gha kǝ le kǝ pǝtuup fin ɗi baa nǝ kǝ ɗar ɓalɓal kas nǝ pal, kǝzak, gha cìn shikbish a nkaa Kristi shikáa fin. ");
INSERT INTO sur_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Mɓǝmǝnǝ, katɗang mbii ɗe wen nse, nǝn nɗee a mbii le canshii nɗyemnǝǝn fen, ɓe baa wen nkuɗi kǝn se mbiise mǝnǝ zak kas, mbǝkǝ taji wen le kǝ ɗyemnǝǝn fen canshii kas. ");
INSERT INTO sur_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Baa wen mak cìn mbii ɗi wen kǝn rǝɓet kas aa? Baa wen a laalep Kristi kas aa? Baa wen kǝn ten naa Daa fun Jesu Kristi kas aa? Baa gyet a Wen satpwoo Naan nǝ nwun, ɗangɓe wu ɗee a nen dǝm nɗang Daa kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Koo ɗi baa pak gurum mo lap an kaa laalep Kristi sǝ kas, ɓe nǝ a tǝng wen a laalep Kristi pee wun ɗi. Mɓǝɗǝ wun a langtǝng mǝ ɗak fen kaa laalep Kristi sǝ pee Daa ɗi. ");
INSERT INTO sur_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","A ɗesǝ nǝ a mbii ɗi wen kǝn sat, nen ɗi moo chakpwoo nɗang wen. ");
INSERT INTO sur_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Baa wen kǝ pee mbǝkǝ wen se mbiise kǝ shwaa mbii shwaa ɓe ɗak fen kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Baa wen kǝ pee, mɓe lapmat ɗi war a ngudǝm nɗang Jesu, kǝ wen pan war nɗang sen kas aa? Kaaɗǝ koor jeplep kǝ Kristi mo, kǝ ɗyemnǝǝn mǝ Daa mo, kǝ Pita moo cìn sǝ kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Aa koo a wen kǝ Barnabas ɓejee ɗe tǝng see mǝ cìn ɗak aku mu kat mbiise ɗe mun nse ɗi aa? ");
INSERT INTO sur_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","A mee shiitoon ɗeɗang wur kǝ cham kwat shool ɗak ɗi wur cìn nshin ye? A wii kǝ cham kop anab mbong, ɓe baa wur nyool se làa anab nǝ kas yi? A wii kǝ cham kyeer long mo, ɓe baa wur nshwaa wur mo nǝ kas yi? ");
INSERT INTO sur_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Kyet wen kǝn sat ɗesǝ nǝ a shi pan mǝ gurum wo? Baa Wàar Mosis nǝ sat aasǝ zak kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Mo kǝ ten ran nǝ ndǝǝn ɓǝǝt haal Wàar Mosis nǝnee, <<Taji a lep shang nkus randong mpwoo, <<kaaɗǝ nǝ nkaa tǝreng ɗeɓen mbong <<mbǝkǝ aas nǝ put ɗi kas.>> Naan wur kǝ pan aa randong mo aa? ");
INSERT INTO sur_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ɗangɓe gyet wur le kǝ mo ran Wàar mǝnǝ mo a mɓe mun gurum. Mbǝkǝ gwe ɗi wur kop kǝ gwe ɗi wur ɗiip, ɓe mo cìn ɗak fur ɗi shi canciin mɓe se ɗǝɓen nǝ. ");
INSERT INTO sur_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Katɗang mun, muu ten mu kop a mbii ɗi nǝ a mǝ Riin mɓut nwun, ɓe baa nǝ ret, kǝ wuwun wu ɓam mun kǝ mbii ɗi mǝ yil nǝ mo kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Katɗang pak gurum moo kat mbii ɗesǝ mo pee wun ɗi, ɓe baa nǝ ret kǝ mun, mu kat mbii mo ɗes met mumo nǝ pee wun ɗi kas aa? Baa mun muu le tǝng nwun, mbǝkǝ wu shin mbii ɗesǝ mo ɗi mmun kas, ɗangbe muu gung mbii mo jir, a mbǝkǝ taji mu daam sekyeen mpwoo ɗeret mǝ Kristi kas. ");
INSERT INTO sur_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Baa wu man nǝ, nen ɗi moo cìn ɗak ndǝǝn Lu Naan ɗǝɗes, ɓe moo kat mbiise fur a nLu Naan ɗeɗes nǝ kas aa? Kǝ baa wu man nǝ nen ɗi moo wus mbiizuum a peewus mbiizuum mo, ɓe moo se a pak mbiizuum nǝ kas aa? ");
INSERT INTO sur_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Nǝ aasǝ zak, ɓe Daa wu satpwoo nǝ. Nen ɗi moo satpwoo ɗeret ngurum mo, ɓe nǝ ret kǝ mo kat mbiise fur a ɗeɓut zak. ");
INSERT INTO sur_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ɗangɓe, baa wen kǝn cham cìn ɗak kǝ iiko fen ɗesǝ kas, kǝ baa Wen ran lepran ɗesǝ nwun, a mbǝkǝ wu shin mbii mo ɗi nwen kas. Ngyal ɗesǝ ɓe wen muut, met a kuɗi mee gwe le mbii ɗi wen kǝn canjoom nkaa nǝ ɗee a mbii ɗebuu. ");
INSERT INTO sur_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Mɓǝɗǝ koo ɗi wen kǝn satpwoo ɗeret nǝ, ɓe baa wen kǝ pee mɓe canjoom kas. Ɗangɓe kǝn satpwoo ɗeret nǝ a mɓeɗǝ, a Naan wur kǝ letǝng an, mbǝkǝ an satpwoo nǝ ɗi. Jeel ɗi mɓe wen, katɗang baa wen satpwoo ɗeret nǝn ngurum mo kas. ");
INSERT INTO sur_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Katɗang ɗi wen kǝn satpwoo nǝ a shi ɗyen fen, ɓe ɗi wen nkat kwat. Ɗangɓe wen kǝn satpwoo ɗeret nǝ ngurum mo, baa a shi ɗyen fen kas, mɓeɗǝ a ɗak ɗi Naan wur kǝ le nǝ nsar fen mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Kwat fen nǝ a meyii? A kwat fen nǝn nɗesǝ, a peeɗi Naan wur kǝ shínpee nwen, mbǝkǝ wen satpwoo ɗeret nǝ ngurum mo shi zuum, baa wen kǝn cìn ɗak kǝ iiko fen mɓe tang kwat pee wun ɗi kas. ");
INSERT INTO sur_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Koo ɗi baa wen a kǝrem kǝ mee gurum kas, ɗangbe wen kǝn ten nle sen a kǝrem kǝ gurum mo jir, mbǝkǝ wen jì ɗi kǝ gurum mo ɗes nDaa. ");
INSERT INTO sur_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Mbǝ nen Yahudi mo, ɓe wen ɗee a kaa mo sǝ, mbǝkǝ wen jì kǝ mo ɗi nDaa. Kǝzak, nen Yahudi mo, a ndǝr Wàar Mosis, ɓe wen ɗee a kaa mo sǝ, koo ɗi baa wen shikáa fen an a nder Wàar Mosis kas. Ɗangɓe wen kǝn ɗee a kaa nen ɗi mon ndǝr Wàar Mosis nǝ sǝ, mbǝkǝ wen jì kǝ mo ɗi nDaa. ");
INSERT INTO sur_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Mpee nen ɗi baa mo kǝ Wàar kǝ Mosis kas, ɓe wen ɗee a kaa mo sǝ, mbǝkǝ wen jì kǝ mo ɗi nDaa. Ɗangɓe wen kǝn tap kǝ Wàar Naan. Azeen wen a ndǝr kǝ Wàar mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Mpee nen ɗi baa mo kǝ ɓal ndǝǝn shinzeen kas, ɓe wen fwang mo, mbǝkǝ wen jì kǝ mo nDaa. Wen kǝn ten ɗee a mbii mo jir, pee gurum mo ɗi jir, mbǝkǝ koo ɗi a ndǝǝn ar ɗeɗangyi, ɓe wen ɓam pak mo ɗi. ");
INSERT INTO sur_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Wen kǝn lesen ndǝǝn mbii mo jir, a mɓe pwoo ɗeret nǝ, kǝ mbǝkǝ wen kat pak ɗeret mǝ pwoo ɗeret nǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Baa wu man nǝ, ndǝǝn kwoon mǝ sushii, ɓe gurum mo ɗes moo shwe, ɗangbe a ngumǝndong kǝ lap zuum nǝ ɓejee ɗak kas aa? Nǝ aasǝ zak, nǝ ret kǝ wu shwe, mbǝkǝ wu kat zuum nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Koo weyi, ɗi wur a ngusushii, ɓe wu naa nkar shin fin ndǝǝn mbii mo jir. Wur kar shin fin, mbǝkǝ wur lap zuum ɗi nii kǝlak kǝ wat ɗi, amma mumun, muu lap a zum ɗi baa nǝn cham wat kas. ");
INSERT INTO sur_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Baa wen kǝn su a buu-buu kas, kǝ cutpee ɗi wen kǝn cìn nǝ, baa wen kǝn cut a buu kas. ");
INSERT INTO sur_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Ɗangɓe wen kǝn cìn kǝ sen fen, mbǝkǝ sen fen nǝ ɓal ɗi, kǝ nǝ ɗee ɗi ndǝr fen kaa kǝrem sǝ, mbǝkǝ taji aɓwoon ɗi wen kǝ satpwoo ɗeret nǝ ngurum mo, ɗangɓe mo yool baa kǝ wen shikáa fen mɓwoon kas. ");
INSERT INTO sur_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Ɗyemnaa mo, wen rǝɓet kǝ wu man, gyet puun fun mo jir, mo a nder nluu, kǝ gyet mo jir mo can am Bahar Ɗenaat mo ɗel ryang nɗang Mosis zak. ");
INSERT INTO sur_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Gyet mo cìn baptisma mmo jir a ndǝǝn nluu, kǝ ndǝǝn am bahar kaaɗe gyet mo dǝm nɗang Mosis sǝ. ");
INSERT INTO sur_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Gyet mo jir, mo se mbiise ɗi gyet Naan shin mmo ɗi nǝ a mǝ Riin. ");
INSERT INTO sur_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Gyet mo jir mo shwaa am ɗi Naan shin mmo. Mɓeɗi gyet mo shwaa am ɗi gyet nǝ jì put mɓut jwak. Gyet jwak ɗesǝ nǝ mwaan nɗang mo. Gyet jwak ɗesǝ a Kristi shikáa fir. ");
INSERT INTO sur_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Jir kǝsǝ, ɓe baa gyet Naan wur kat retnyit kǝ pak mo kas. Mɓǝmǝnǝ ɓe mo murep ɗes a naaryil. ");
INSERT INTO sur_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Yaksǝ, ɓe mbii ɗesǝ mo jir, mo ɗee a mbiikám mumun. Mo gwak mun, mbǝkǝ taji mu coor mbii ɗebish mo, kaaɗe gyet mo cìn sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Taji wu ɗee a nenkum mo, kaaɗe gyet pak mo ndǝǝn mo, mo cìn sǝ kas, kaaɗe mo kǝ ten ran ndǝǝn ɓǝǝt haal mǝ Naan sǝ nǝnee, <<Gurum nǝ mo tong nyil, <<mbǝkǝ mo se gwom kùm, <<kǝ shwaa mwes, <<kǝ mo yool a tǝng mɓe cìn kook.>> ");
INSERT INTO sur_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Taji mu cìn ngaa kas, kaaɗe gyet pak mo ndǝǝn mo, mo cìn sǝ, har gurum mo ngal laarvǝl baakun, mo murǝp parpuus mǝndong. ");
INSERT INTO sur_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Taji mu kam Daa kas, kaaɗe gyet pak mo ndǝǝn mo, mo cìn sǝ, ɓe har gyet nwòo mo, twe mo. ");
INSERT INTO sur_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Taji mǝ chakpwoo nɗoom-nɗoom kas, kaaɗe gyet pak mo ndǝǝn mo, mo cìn sǝ, har mo murǝp nsar kǝ ngulep mǝ muut. ");
INSERT INTO sur_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Mbii ɗi gyet nǝ kat mo, nǝ ɗee a mbiikám pee mun ɗi. Mo kǝ ten ran mo, a mbǝkǝ mo gwak mun ɗi, mun ɗe peekyes kǝ ɓit nǝ mo kǝ jì a nkaa mun. ");
INSERT INTO sur_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Mɓǝmǝnǝ, ɓe koo a weyi, ɗi wur kǝ pan nnǝ wuɗin kǝ ɗar ɓalɓal, ɓe wur tap, taji wur pal kas. ");
INSERT INTO sur_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Baa mee jwaan ɗe nǝn nkat wun ɗi kas, see a ɗi nǝn nkat koor gurum mo jir zak. Naan wur a nguzeen, baa wur nyit kǝ mee jwaan kat wun, ɗe nǝn mmet mɓal fuu kas. Ɗangɓe a shi jwaan nǝ, ɓe nwun nle ar put nǝ ɗi zak, mbǝkǝ wu mak gung jwaan nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Mɓǝmǝnǝ ɗyemnaa mo, taji wu seyil nkùm mo kas. ");
INSERT INTO sur_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Wen kǝn katpwoo wun, a kaa nen ɗe mo kǝ ɗyen sǝ, Naan wur kǝ ten kám ar nǝ wun sǝ. Mɓǝmǝnǝ, ɓe wu ɓeet kǝ suk, nkaa mbii ɗi wen kǝn sat nǝ. ");
INSERT INTO sur_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Katɗang mu mang laaɗaa mǝ Se Tong Ashak ɗi muu pǝlang Naan mɓe nǝ, ɓe baa wu man nǝ, muu ɓàl a káa fun mo ashak kǝ Kristi ndǝǝn toom fir kas aa? Gill aas ɗe muu yilang sǝ, ɓe baa wu man nǝ, muu ɓàl a káa fun ndǝǝn fwoshik Kristi kas aa? ");
INSERT INTO sur_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Mɓǝɗǝ gill aas nǝ a mǝndong, ɗi muu yilang nǝ mǝ mu se ashak. Nǝ aasǝ zak, mun ɗi ɗes, ɗangbe mun a nan ɗemǝndong, mbǝɗe muu se a gill aas ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Wu pan nkaa nen Iisreal mo ndǝǝn nan, nen ɗi moo se ndǝǝn mbiizuum ɗi mo wus nǝ, ɓe moo ɓal a káa fur kǝ Naan ɗi moo shìn nǝ nwur. ");
INSERT INTO sur_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Wen kǝn rǝɓet sat a meyii? Kyet mbiise ɗi moo shìn nkùm, mǝnǝ a mee mbii ee? Koo a kùm nǝ a mee mbii ye? ");
INSERT INTO sur_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Hai yo, wen kǝn sat a nǝ, mbii ɗi nenkum moo gap mpee cìn zuum, ɓe moo shìn nǝ a riin ɗebish mo, baa moo shin zuum nǝ a nNaan kas. Baa wen rǝɓet kǝ wu ɓalkaa fuu mo ashak kǝ riin ɗebish mo kas. ");
INSERT INTO sur_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Baa wun mmak shwaa mɓut laaɗaa mǝ Daa, kǝ wu waa wu shwaa mɓut laaɗaa mǝ riin ɗebish mo zak kas. ");
INSERT INTO sur_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Taji mu cìn mee mbii ɗi nǝn nle kǝ Naan cìn tuup kas. Kyet mun, mu ɓal met wur wo? ");
INSERT INTO sur_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Gurum mo sat nǝ, <<Mu mak cìn koo meye, ɗi mu rǝɓet.>> Nǝ azeen, ɗangbe baa a mbii mo jir ɗi mo mak ɗik wun koo moo koop nǝ mbǝ gurum kas. ");
INSERT INTO sur_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Taji mee gurum tang mbii ɗe mo ret mukáa fin kas. Amma nǝ ret kǝ wur tang a mbii ɗi mo ret mbǝ niyee mo. ");
INSERT INTO sur_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Wu se mbii ɗi moo sǝrep mo ndǝǝn lutuk mǝ luwaa mo. Taji wu talpwoo kas, mbǝ pan ɗi nǝ ndǝǝn pǝtuup. ");
INSERT INTO sur_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Mɓǝɗǝ mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan nǝnee, <<Yil nǝ kǝ mbii ɗe mo ndǝǝn nǝ jir, mo a mǝ Daa.>> ");
INSERT INTO sur_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Katɗang mee gwar ɗi baa wur kǝ shinzeen nDaa Jesu kas, wur pet wun mbǝ sese ashak kǝ wur. Katɗang wuu lap ii, nnǝ wun ndem, ɓe wu se mbii ɗi wu nle a kyeen fuu. Taji wu tal kas, mbǝ pan ɗi nǝ ndǝǝn pǝtuup fuu. ");
INSERT INTO sur_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Amma katɗang mee gwe kǝ ten sat nwun nǝnee, <<Mo kǝ ten shin luwaa ɗesǝ nǝ nkùm.>> Ɓe taji wu se luwaa nǝ kas, mbǝ gwar ɗe wu sat pwoo mǝnǝ nwun, kǝ mɓe pan ɗe nǝ ndǝǝn pǝtuup. ");
INSERT INTO sur_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Baa a mɓe pan muu mo kas, amma a mɓe pan kǝ gwar nǝ. Mbǝme ɗang pan kǝ mee gurum nǝn ncíi nwen, mbǝ katpee ɗe wen kǝ nǝ, mɓe cìn mbii ɗi wen kǝn rǝɓet yi? ");
INSERT INTO sur_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Katɗang wen pǝlang Naan mɓe mbiise fen. Ɓe cirang ɗangɓe gurum moo leshap ɗebuu nkaa wen, mbǝ mbiise ɗi wen kǝn ten pǝlang Naan nkaa nǝ yi? ");
INSERT INTO sur_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Mbǝmǝnǝ, ɓe koo a mbii ɗeɗangyi ɗe wuu cìn, koo a se mbiise, koo a shwaa mbiishwaa, ɓe wu cìn mbii mo jir mbǝ shin ɗehai Naan. ");
INSERT INTO sur_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Taji wu le kǝ mee gurum canshii kas. Koo ɗang ɗi gwe nǝ a ngu Yahudi koo baa a ngu Yahudi kas, koo ɗi a Ekǝlisya mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Kaaɗǝ wen kǝn gung mbǝkǝ wen cìn mbii ɗi mo shang ɗi ngurum mo jir. Baa wen kǝn tang a ɗeret mukáa fen kas, ɗangɓe wen kǝn tang a ɗeret mǝ gurum mo ɗes, mbǝkǝ mo kat ɓam wur ɗi. ");
INSERT INTO sur_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Wu mwaan ndǝǝn shiimwaan fen, kaaɗi wen kǝn mwaan ndǝǝn shiimwaan mǝ Kristi sǝ. ");
INSERT INTO sur_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Wen kwoop wun, mɓeɗǝ wuu pan an ndǝǝn mbii mo jir, kǝ wuu mwaan ndǝǝn kám dǝ wen kám mo nwun zak. ");
INSERT INTO sur_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Amma wen rǝɓet kǝ wun man nǝ, a Kristi wu a káa kǝ koo a mish ɗeɗangyi, kǝ a mish wu a káa kǝ mat fin, kǝ Naan wu a káa kǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Mɓǝmǝnǝ koo mish ɗeɗangyi ɗi wu cìn ɗangnaan (leshap kǝ Naan), kǝ satpwoo Naan ndǝǝn ɗuu kǝ gurum mo kǝ káa fin a pǝpaa, ɓe wur jì kǝ yitluwaan nkaa Kristi ɗi a wu a káa fin mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Koo mat ɗeɗangyi ɗi war cìn ɗangnaan (leshap kǝ Naan), kǝ satpwoo kǝ Naan ɗi baa war Paakáa war kas, ɓe war jì kǝ yitluwaan nkaa mish war. Ɗewur a káa fin, kǝzak, ɓe war ɗee a kaa mat ɗi mo sak káa nwar ngau sǝ mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Katɗang baa mat Paakáa fin kas, ɓe nǝ ret kǝ war saa shweepkáa fer. Amma katɗang saa shweepkáa koo sak shweepkáa nǝn njì kǝ yitluwaan mmat, ɓe nǝ ret kǝ war Paakáa fer. ");
INSERT INTO sur_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Baa nǝ ret kǝ ngumish Paakáa fin kas, mɓeɗǝ Naan ɗak mish a kaa shin sǝ, kǝ wur kám a ɗeɗes kǝ Naan. Amma mat war kǝ kám a ɗeɗes mǝ mish. ");
INSERT INTO sur_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Baa gyet Naan ɗak mish a shi fwoshik mǝ mat kas, ɗangbe gyet wur ɗak mat a fwoshik mǝ mish. ");
INSERT INTO sur_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Kǝzak, baa gyet Naan wu le mish a mɓe mat kas, amma gyet wur le mat a mɓe mish. ");
INSERT INTO sur_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Mɓǝmǝnǝ, ɓe nǝ ret kǝ mat Paakáa war, kǝ nǝ kám ɗi nǝ, war nder kǝ mish fer, kǝ mɓe nenlep kǝ Naan mo zak. ");
INSERT INTO sur_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Jir kǝsǝ, ɓe seen fun ɗi mun kǝ nǝ ndǝǝn Daa, ɓe baa mat war ɗyik kǝ mish fer kas, kǝ baa mish wur ɗik kǝ mat fin kas zak. ");
INSERT INTO sur_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Mɓeɗi gyet Naan wu ɗak mat a shi mee ɗyes kǝ mish, kǝ nǝ aasǝ zak, yaksǝ ɓe a mat war kǝ làa mish. Mbii moo pwat a pee Naan ɗi jir. ");
INSERT INTO sur_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Wun shikáa fuu, wu ɓeetpwoo ɗesǝ nǝ, kyet nǝn ndere mbǝkǝ mat war cìn ɗangnaan (leshap kǝ Naan) nNaan ndǝǝn kuur kǝ gurum mo, ɗe baa war Paakáa war kas wo? ");
INSERT INTO sur_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Koo a shi ɗyen, ɓe nǝ kám nwun kas aa? Nǝ a mbii yitluwaan kǝ mish wur ɗyel shweepkáa shwal-shwal. ");
INSERT INTO sur_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Amma katɗang ɓe mat war ɗyel sheepkáa ɗeshwal-shwal, ɓe mǝnǝ a mbii jwat nwar kas aa? Mɓǝɗǝ mo shin sheepkáa ɗeshwal-shwal nǝ nwar, a mbǝkǝ waa Paakáa war ɗi. ");
INSERT INTO sur_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Amma katɗang mee ngwar kǝ rǝɓet ɓeetshik nkaa pwoo ɗesǝ, ɓe baa mumun, koo Ekǝlisya mǝ Naan mo, baa mu loot kǝ mee ar ɗi nǝ a mǝ seyil nNaan ɗi nǝ ɗik kǝ mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","nƊǝǝn wàar ɗǝsǝ, ɓe baa wen kwoop wun kas, mɓeɗǝ kuur fuu nǝ baa nii kwoop nǝ kas. Mɓeɗi katɗang wu jì wu kaat ndǝǝn kuur fuu, ɓe mbii ɗi wuu cìn nǝ mo, ɓe baa mo ret kas. Nii waa wuwat gurum mo met aku ɗi nǝn mɓam mo. ");
INSERT INTO sur_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","To, ɗinshee nǝ, katɗang wu kuur, kaa Ekǝlisya sǝ, mɓe seyil nNaan, ɓe baa pwoo fuu moo dǝm ndangshak kas, har kaaɗe ɗe wen kǝlǝng pwoo mǝnǝ, ɓe wen ɗoom shinzeen nǝ. ");
INSERT INTO sur_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Baa nǝ kǝ mee kyetwoo kas, nǝ a tǝng, kǝ mo kat ɓàkshak ɗi ndǝǝn wun, mbǝkǝ mo man nen dǝm ndang Naan ɗe ɗǝre nǝ mo ɗi azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Katɗang wu jì wu kaat ashak, ɓe baa wuu se a Tong Ashak mǝ Daa nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Mɓǝɗǝ katɗang wu ɗoom se nǝ, ɓe koo weye wur yaa se mbiise ɗi wur jì kǝni, har wuu le kǝ neenláa mpak mo, kǝ pak moo shwaa ɓe yiirkaa ɗi. ");
INSERT INTO sur_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Kai! Baa wun kǝ tul ɗi wun nse kǝ shwaa ɗi kas aa? A me le ɗang wuu toklong shi nkuur mǝ Ekǝlisya kǝ Daa ye? Kǝ a me le ɗang wuu shin yitluwaan nen ɗi baa mo kǝ mee mbii kas yi? Wen nsat a me nwun mbǝ mbii kaa ɗesǝ sǝ yi? Wen nkwoop wun aa? Hai yo, baa wen nkwoop wun kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Wen lap kám ɗǝsǝ nǝ a pee Daa ɗǝ, ɗe wen kǝn shin nwun sǝ zak. Nǝ, mpar ɗi gyet mo seet Daa Jesu ɗi, ɓe Daa Jesu wur mang gill aas. ");
INSERT INTO sur_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Aɓwoon ɗi wur kǝ cìn ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan nkaa gill aas nǝ, ɓe wur yilang nǝ, wur sat nǝnee, <<Ɗesǝ nǝ a fwoshik fen, <<ɗi wen kǝn shin nǝ mɓe wun, <<Wu naa nshìn aasǝ, <<mbǝkǝ taji wu muunshik nwen kas.>> ");
INSERT INTO sur_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Nǝ aasǝ zak, ɓe aɓwoon ɗi mo se mbiise, ɓe wur mang laaɗaa, ɓe wu sat nǝnee, <<Laaɗaa ɗǝsǝ nǝ a ɓǝlemcuk shi toom kǝ Naan ɗepwoo, ɗi nǝ ndǝǝn toom fen. Katɗang koo a pǝrangye ɗi wun nshwaa am anab ndǝǝn laaɗaa nǝ, ɓe wuu shwaa nǝ a mbǝkǝ taji wu muunshik wen kas.>> ");
INSERT INTO sur_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Shii kǝ ɗǝsǝ nǝ a nǝ, koo a pǝrangye ɗi wuu se gill aas nǝ, kǝ wu shwaa am anab ndǝǝn laaɗaa nǝ, ɓe wuu cìn a langtǝng nkaa muut kǝ Daa Jesu, har parɗi wur mbaa jì. ");
INSERT INTO sur_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Katɗang mee gwe kǝ se gill aas nǝ kǝ shwaa am anab ndǝǝn laaɗaa mǝ Daa nǝ, baa a ndǝǝn ar ɗin ɗǝre kas, ɓe gwe mǝnǝ kǝ cìn a shikbish nkaa fwoshik mǝ Jesu kǝ toom fir mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Nǝ ret kǝ gurum shee kyamshin fin akuɗang wur se gill aas, kǝ shwaa am anab ɗi nǝn ndǝǝn laaɗaa mǝ Daa nǝ. ");
INSERT INTO sur_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Mɓǝɗǝ katɗang baa gurum manshii kǝ shin mǝ Daa Jesu kǝ toom fin nǝ kas, ɗangɓe wu kǝ se gill aas kǝ shwaa am anab ɗi nǝ ndǝǝn laaɗaa mǝ Daa ni, ɓe gwar mǝnǝ kǝ jì aa ɗyeel nkaa fwoshik fin mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","A nii le, ɗangɓe pak fuu mo a gok, kǝ baa pak mo kǝ ɓal kas, har pak fuu mo ɗes, mo kǝ murǝp. ");
INSERT INTO sur_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Amma katɗang mǝ kyamsun fun mo azeen-nzeen, kǝ mǝ cìn mbii mon ndǝre-ndǝre ɓe baa Naan tokɗyeel mmun kas. ");
INSERT INTO sur_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Amma Naan wur tokɗyeel mmun, kǝ wur kar mun, a mbǝkǝ taji wu ncanɗyeel ɗebish mmun ashak kǝ gurum ɗebish, ɗi mo ndǝǝn yil ɗesǝ, parkyes kǝ yil nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Mɓǝmǝnǝ, ɗyemnaa mo, katɗang wu kuur ashak mɓe Se Tong Ashak mǝ Daa, ɓe nǝ ret kǝ wu ɗarnaa shak. ");
INSERT INTO sur_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Katɗang neenláa mmemee fuu, ɓe nǝ ret kǝ gwar mǝnǝ sese ntul fir akuɗang wur jì kuur nǝ. Mbeekǝ taji Naan wur canɗyeel ɗebish nkaa wun jir, a peekuur fuu nǝ. Pwoo nkaa koor mbii ɗi mo ɗee ɗi, ɓe see parɗǝ wen wul pee wun ɗi, ɗangɓe wen nsatpwoo nwun nkaa mo jir. ");
INSERT INTO sur_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ɗyemnaa mo, pwoo nkaa zuum ɗi Riin Naan wur shin ngurum. Baa wen rǝɓet kǝ wu nook manshii nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Wu man nǝ, kaaɗe gyet wu kuɗi a nenseyil nkùm mo, ɓe wuu seyil nkùm ɗe baa mo kǝ seen kas, shi ar mo shinǝ-shinǝ. ");
INSERT INTO sur_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Wen rǝɓet kǝ wu man nǝ, baa mee gwe, ɗi wur katpwoo shi Riin Naan, wur mmak sat nǝnee <<Jesu canɗoor!>> kas, kǝ baa mee gurum mak cìn langtǝng nǝnee, <<Jesu wur a Daa.>> Katɗang baa wur mwaan a ndǝǝn Riin Naan kas. ");
INSERT INTO sur_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Zuum ɗi Riin kǝ Naan wur shin ngurum mo, mo ɗi shinǝ-shinǝ, amma a Riin ɗemǝndong wur cin mo ngurum mo. ");
INSERT INTO sur_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Ɗak mo ɗi shinǝ-shinǝ, amma Daa a mǝndong. ");
INSERT INTO sur_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Man ɗi gurum moo cìn ɗak ɗishik mo shinǝ-shinǝ, ɗangbe a Naan ɗemǝndong wur cìn man nǝ ngurum mo, mbǝkǝ mo cìn ɗak nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Riin Naan wur kám shin ngurum mo ndǝǝn ar mo shinǝ-shinǝ, mbǝkǝ mo cìn ɗak ɗe nǝ mɓam niyee mo ɗi jir. ");
INSERT INTO sur_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Mee gurum, ɓe Riin Naan nǝ shin a zuum mǝ man satpwoo nwur shi seen, kǝ mee gurum ɓe Riin nǝ shìn a zuum mǝ man mbii nwur. ");
INSERT INTO sur_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Mee gurum, ɓe Riin nǝ shin a zuum mǝ cinzeen nwur, kǝ mee gurum ɓe Riin nǝ shin a iiko nwur mɓe bar nenchǝǝnkoom mo. ");
INSERT INTO sur_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Mee gurum ɓe Riin Naan nǝ shin a zuum mǝ cìn mbii aapwoo nwur, kǝ mee gurum ɓe Riin Naan nǝ shin a iiko mu satpwoo Naan gwe nǝ. Mee gurum ɓe Riin wur shin a man mǝ ɓàkyit nzuum ɗe mo put a pee Riin Naan ɗi, kǝ riin ɗi baa mo put a pee Naan ɗi kas zak. Mee gurum ɓe Riin wu shin a zuum mǝ katpwoo shi lǝpwoo mo shinǝ-shinǝ ngwar mǝnǝ. Kǝ Mee gurum zak, ɓe wur shin a zuum ɗe mǝ manshii kǝ pǝring lǝpwoo mǝ gurum mo shinǝ-shinǝ gwe nǝ. ");
INSERT INTO sur_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","A Riin Naan ɗesǝ wur mǝndong, ɗi wur shin zuum ɗǝsǝ mo ngurum mo shinǝ-shinǝ zak, kaaɗe wur naa nǝ ret nwur nyit sǝ. ");
INSERT INTO sur_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Kristi wur a kaa fwoshik kǝ gurum sǝ. Kaaɗǝ wu man nǝ, shin kǝ gurum nǝ kǝ ɓeep mo ɗes, amma jir kǝsǝ ɓe fwoshik kǝ gurum nǝ a mǝndong ɓejee ɗak, koo ɗi nǝ kǝ ɓeep mo shinǝ-shinǝ. ");
INSERT INTO sur_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Mo cìn baptisma mmun jir a ndǝǝn Riin ɗemǝndong, aasǝ ɓe mu ɗee a ɗemǝndong, koo ɗi mun a nen Yahudi mo, koo ɗi baa mun a nen Yahudi mo kas, koo ɗi mun a kǝrem mo, kǝ koo ɗi mun a jeplu mo zak. Mun jir, ɓe muu ten mǝ shwaa a bwut Riin Naan ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Baa fwoshik kǝ gurum nǝ kǝ ɓeep a mǝndong ɓejee kas, amma nǝ kǝ ɓeep mo a ɗes. ");
INSERT INTO sur_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Katɗang shii sat nǝnee, <<mbǝɗe baa wen a sar kas, ɓe baa wen a memee mɓut fwoshik kǝ gurum kas.>> Koo ɗe shii sat pwoo mǝnǝ, ɓe baa nǝn nnook ɗee a memee mɓut ɓeep mǝ fwoshik kǝ gurum kas. ");
INSERT INTO sur_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Kǝzak, katɗang ɓe kom sat nǝnee, <<mbǝɗe baa wen a yit kas, ɓe baa wen a memee mɓut fwoshik kǝ gurum kas.>> Koo ɗe kom sat pwoo mǝnǝ, ɓe baa kom nǝn nnook ɗee a memee mɓut shin kǝ gurum kas. ");
INSERT INTO sur_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Katɗang ɗi fwoshik kǝ gurum nǝ a yit jir, ɓe ɗe gurum kǝ kǝlǝngpee a shi meyii? Katɗang ɗi fwoshik kǝ gurum a kom jir ɓejee, ɓe ɗe cirang gurum nkǝlǝng ɗu kǝ mbii mo ɗi yi? ");
INSERT INTO sur_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Amma Naan wur leɓeep mo shinǝ-shinǝ ndǝǝn fwoshik kǝ gurum, kaaɗe wur naa nǝ ret nwur nyit sǝ. ");
INSERT INTO sur_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Katɗang ɓe ɗi ɓeep nǝ a mǝndong ɓejee ɗak, ɓe ɗi fwoshik kǝ gurum nǝ a nneyi? ");
INSERT INTO sur_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Kaaɗǝ ɓeep kǝ gurum mo ɗi ɗes, amma ɓe fwoshik kǝ gurum nǝ a mǝndong ɓejee ɗak, ");
INSERT INTO sur_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","mpeemǝnǝ, ɓe baa yit mmak sat nsar nǝ, <<Baa wen kǝn rǝɓet wii kas.>> Kǝzak, baa káa mmak sat nshii nǝnee, <<Baa wen kǝn rǝɓet wii kas.>> ");
INSERT INTO sur_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Azeen, baa nǝ aasǝ kas, mɓeɗǝ rep ɓeep ɗi muu naa mo kaa baa mo kǝ ɓal kas sǝ, ɓe mo kǝkoop nǝ ɗes mɓe fwoshik kǝ gurum. ");
INSERT INTO sur_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Kǝ muu tap kǝ ɓeep ɗi muu ɓák mo ɗes zam. Ɓeep ɗe mo mɓut nsun funu mo, ɗi baa mo ret naa kas, ɓe muu tap kǝ mo rǝret. ");
INSERT INTO sur_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Ɗangɓe baa muu shin ɗeɗes mǝnǝ mɓeep fun ɗeret naa nǝ mo kas. A Naan wur tap le fwoshik kǝ gurum aasǝ, mbǝkǝ ɓeep ɗi baa mo kǝ ɓal kas, ɓe mu tap ɗi kǝ mo rǝret zak. ");
INSERT INTO sur_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Mbǝkǝ taji mee ɓàkshak yool ndǝǝn fwoshik kǝ gurum kas. Amma koo a ɓeep ɗeɗangyi ɓe nii tap kǝ gǝnǝǝn. ");
INSERT INTO sur_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Katɗang jeel taa nkaa mee ɓeep nǝ, ɓe koor ɓeep nǝ mo jir mon nshwaajeel nǝ. Amma katɗang mo kwoop mee ɓeep nǝ, ɓe koor ɓeep nǝ mo jir, mon ncìn retnyit ashak kǝ ɓeep mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Wun jir wun a fwoshik kǝ Kristi, koo a weye ndǝǝn wun, ɓe wur a memee mɓut mɓeep fin. ");
INSERT INTO sur_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","nƊǝǝn Ekǝlisya, ɓe Naan wu kǝ bǝlǝp gurum mo le shinǝ-shinǝ. Ɗin nshee, ɓe wu kǝ bǝlǝp jeplep kǝ Jesu mo, ɗevǝl, ɓe wu bǝlǝp nensatpwoo Naan mo, ɗekun, ɓe wur kǝ bǝlǝp nenkám mo. Kǝ wur bǝlǝp nen cìn ɗak mǝ mbii aapwoo mo. Ɗangɓe wur kǝ bǝlǝp nen bar gurum mo, kǝ nenɓam gurum mo, nennaa gurum mo, mbǝkǝ mo cìn ɗak ɗi ndǝre-ndǝre, kǝ nnen katpwoo mo shi liispwoo mo shinǝ-shinǝ zak. ");
INSERT INTO sur_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Baa a gurum mo jir a jeplep kǝ Jesu kas. Baa a gurum mo jir mo a nensatpwoo Naan kas. Baa a gurum mo jir mo a nen kamkam kas. Baa a gurum mo jir mo cin dak ɗi mǝ aapwoo kas. ");
INSERT INTO sur_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Baa a gurum jir moo mak barr gurum mo kas. Baa a gurum jir mo kǝ mak katpwoo shi liispwoo mo shinǝ-shinǝ kas. Baa a gurum mo jir, ɗi moo mak yakshii mbii ɗi moo sat shi liispwoo mo shinǝ-shinǝ kas. ");
INSERT INTO sur_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Ɗangɓe nǝ ret kǝ pǝtuup fuu mo ɗee a nkaa zuum ɗi mo kǝkoop nǝ met ndǝǝn zuum ɗesǝ nǝ mo. Yaksǝ, ɓe wen nkám wun mee mbii ɗe nǝ ret kǝ wu cìn met koor mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Katɗang wen mak katpwoo shi lǝpwoo mǝ gurum mo, kǝ mǝ nenlep Naan mo, ɗangɓe katɗang baa an kǝ wal ndǝǝn pǝtuup fen kas, ɓe wen ɗee a kaa wal tuul ɗe nǝn nfii sǝ, koo kaa wal kungguleng sǝ. ");
INSERT INTO sur_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Katɗang ɓe Wen kǝ zuum mǝ satpwoo Naan nkaa mbii ɗe mo pǝ jì, kǝ wen manshii mbii ɗesǝsok mo, har kǝ koor seen mo jir, kǝ koo ɗi wen kǝ shinzeen ɗi nǝ le kǝ wen sat njwak mo yool aku, a peeɗe mo ɗi, ɓe katɗang baa wen kǝ wal ndǝǝn pǝtuup fen kas, ɓe baa wen a mee mbii kas, koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Koo ɗe wen shin long fen mo jir ngurum mo shi zuum, kǝ koo ɗe wen shin sen fen mbǝkǝ mo wus nǝ ɗi, ɓe katɗang baa wen kǝ wal kas, ɓe baa nii mee koop pee wen ɗi kas, koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Wal nǝ a gung mbii mo, kǝ naajeel gurum mo zak. Baa wal nǝ kǝ cìn zuur koo canjoom kas koo wup nsat kas. ");
INSERT INTO sur_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Baa wal nǝ kǝ roop, koo toklong ngurum mo kas. Baa wal nǝ kǝ ɗar a nkaa mbii ɗe mo ret nǝ nyit ɓejee ɗak kas. Baa wal nǝ kǝ langtuup, koo nǝ wet nyaa shikbish ɗe gurum kǝ nǝ mputuup kas. ");
INSERT INTO sur_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Baa wal nǝ kǝ kat retnyit kǝ mbii ɗebish mo kas, amma wal nii kat retnyit a ndǝǝn mbii ɗi mo azeen. ");
INSERT INTO sur_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Wal nǝ kǝ gung ndǝǝn mbii mo jir, kǝ nii shinzeen ndǝǝn mbii mo jir zak. Wal nii canciin ndǝǝn mbii mo jir, kǝ nii yaa sat ndǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Baa wal nii kyes kas, har ngaa-ngaa. Amma satpwoo Naan nkaa mbii ɗe mo pǝ jì mon nɗel dǝm, kǝ zuum mǝ iiko mǝ katpwoo shi lǝpwoo mo shinǝ-shinǝ, mon nɗel dǝm. Manshii mbii mo, ɓe mǝnǝ nɗel seet zak. ");
INSERT INTO sur_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Azeen baa man fun nǝ a ɗe kǝgam kas, kǝzak, satpwoo Naan nkaa mbii ɗe mo pǝ jì, baa nǝ a ɗegǝgam kas. ");
INSERT INTO sur_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Amma katɗang parɗi gwe ɗi wu a ɗegǝgam wu njì, ɓe mbii ɗi baa mo a ɗegǝgam kas, mon nɗel dǝm sǝ. ");
INSERT INTO sur_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Kaaɗǝ gyet wen kuɗi a làa, ɓe wen kǝn katpwoo a kaa làa sǝ. Wen kǝn cìn a pan njep mo ndǝǝn pǝtuup fen, kǝzak, wen kǝn cìn mbii mo a kaa làa sǝ. Amma, yaksǝ kaaɗe wen a ngunan, ɓe wen yit ɗak ɗi mo a mǝ jep mo jir. ");
INSERT INTO sur_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Mbii ɗi muu naa mo yaksǝ, ɓe muu naa mo a shir-shir kaaɗe muu naa muriin ndǝǝn mbii naayit ɗi baa nǝ naapee rǝret kas sǝ. Amma parmeeci ɓe mun nnaa mbii mo rǝret shi yit kǝ yit. Yaksǝ ɓe mbii ɗe wen man mo akáa-akáa ɓejee ɗak, amma parpuus mǝnǝ ɓe wen mman mbii mo ndǝre-ndǝre jir, kaaɗe Naan wur kǝ ten man wen sǝ. ");
INSERT INTO sur_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Mbii mo ɗe kun, ɗe baa mon cham ɗel kas, mo a shinzeen, kǝ le pǝtuup, kǝ wal, amma wal nǝ ɗes met mmo jir. ");
INSERT INTO sur_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Nǝ ret kǝ wu naa tong ndǝǝn wal, kǝzak, wu le pǝtuup fuu mo nkaa zuum ɗi Riin wur shin mo, met jir, ɓe a zuum mǝ satpwoo Naan nkaa mbii ɗi mon ncìn. ");
INSERT INTO sur_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Koo a weyi ɗi wu kǝ katpwoo a shi mee lǝpwoo ɗecǝ, ɓe wur katpwoo aa Naan, baa wur katpwoo aa gurum mo kas. Mɓǝɗǝ baa mee gurum man mbii ɗi wu sat nǝ kas, wur sat a mbii ɗi mo a sǝsok ndǝǝn ɓal kǝ Riin. ");
INSERT INTO sur_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Ɗangɓe koo a weyi, ɗewur sat a mbii ɗe Naan kǝcin nwur, mbǝkǝ wur sat ɗi ngurum mo, ɓe wur leshap aa gurum mo jir mmǝnǝ. Mbǝku wur ɓal kwak ɗi ngurum mo, kǝzak, mbǝkǝ wur gang kwak mo ɗi, kǝ mbǝkǝ wur caa mo ɗi. ");
INSERT INTO sur_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Ngwe ɗewur katpwoo a shi mee lǝpwoo ɗecǝ, wur ɓam a káa fin ɓejee. Amma gwe ɗi wur sat a pwoo ɗi Naan kǝ shin nwur, mbǝkǝ wur sat ɗi ngurum mo, ɓe wur ɓam a Ekǝlisya nǝ jir. ");
INSERT INTO sur_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Wen rǝɓet kǝ wun jir, wu katpwoo shi lǝpwoo mo shinǝ-shinǝ, amma ɗyen nwen nǝ, ɗi wun jir, wun nsat a pwoo ɗe Naan kǝ shin nwun, mbǝkǝ wu sat ɗe ngurum mo. Ngwe ɗi wur sat a pwoo ɗe Naan kǝ shin nwur mbǝkǝ wu sat ɗi ngurum mo, ɓe gwar mǝnǝ met gwar ɗi wur kǝ katpwoo shi mee lǝpwoo ɗecǝ, see koo katɗang ɓe mee gurum ɗi, ɗi wur mmak pǝring kǝ pwoo nǝ akuɗang, mbǝkǝ nǝ ɓam Ekǝlisya nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Yaksǝ ɗyemnaa mo, katɗang wen dǝm pee wun ɗi, ɗangɓe wen katpwoo kǝ wun a shi lǝpwoo mo shinǝ-shinǝ, ɓe kyet nghan kǝ mee koop nǝ pee wun ɗi wa? Katɗang baa nghan dǝm aa mee lep ɗepwoo nwun pee Naan ɗi, koo mee man, koo mee pwoo ɗi Naan wu kǝ shin nwen, mbǝkǝ nghan kám ɗi nwun kas, ɓe baa nǝ kǝ mee koop nǝ pee wun kas. ");
INSERT INTO sur_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Koo ɗang a mbii cìn kook ɗi baa mo kǝ mee seen kas, kaa koor kǝ ndeng-ndeng sǝ, katɗang baa ngutaa nǝ, taa ɗoo nǝ rǝret kas, ɓe cirang ɗang gurum mmanshii kǝ kook ɗi gwar nii taa ɗi yi? ");
INSERT INTO sur_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Kǝzak, katɗang baa ngutaa feer wu taa ɗoo nǝ rǝret kas, ɓe cirang ɗang gurum mon ɗak sut mɓe lek yi? ");
INSERT INTO sur_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Nǝ aasǝ zak kǝ wun, katɗang wu sat mbii mo a shi lǝpwoo ɗecǝ ɗi baa gurum mo manshii nǝ rǝret kas, ɓe cirang ɗang gurum mon mmanshii kǝ mbii ɗi wuu sat nǝ ɗi yi? Katɗang nǝ aasǝ, ɓe pwoo ɗi wuu sat nǝ, ɓe kut kǝ mang nǝ ɗel dǝm kǝ nǝ sǝ zhaap. ");
INSERT INTO sur_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Azeen lǝpwoo mo ɗi shinǝ-shinǝ ndǝǝn yil ɗesǝ, kǝ koo a ɗeɗangyi, ɓe nǝ kǝ manshii nǝ. ");
INSERT INTO sur_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Ɗangɓe katɗang baa wen manshii lǝpwoo ɗi mee gurum kǝ sat kas, ɓe gwar mǝnǝ a mǝzep pee wen ɗi, kǝ wen ɗee a mǝzep pee gwar mǝnǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Nǝ aasǝ zak kǝ wuwun. Kaaɗǝ wun wuu fes wu coor zuum mo ɗi Riin kǝ Naan wur kǝ Shin mo, ɓe wu gung kǝ wu cìn ɗak ɗi, a shi zuum ɗe mon ncìn mɓam mɓe ɗyik Ekǝlisya nǝ. ");
INSERT INTO sur_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Mɓǝmǝnǝ, ngwar ɗe wur katpwoo shi lǝpwoo mo shinǝ-shinǝ, ɓe wu ɗangnaan (leshap kǝ Naan), mbǝkǝ Naan wu shin zum mǝ man pǝring shii kǝ mbii ɗi wur nsat nǝ mo ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Mbǝɗe katɗang wen ɗangnaan (leshap kǝ Naan) nNaan shi mee lǝpwoo ɗiiɗik, ɓe riin fen nii ɗangnaan (leshap kǝ Naan) nǝ zak, ɗangbe baa pan fen nii koop nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Katɗang nǝ aasǝ, ɓe wen ncìn a meye? Wen nɗangnaan (leshap kǝ Naan) shi riin fen, kǝ wen ɗangnaan (leshap kǝ Naan) shi pan fen zak. Wen ncìn kook ndǝǝn riin fen, kǝ wen ncìn kook nǝ shi pan fen zak. ");
INSERT INTO sur_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Katɗang waa ɗangnaan (leshap kǝ Naan) mǝ pǝlang Naan ndǝǝn kuur a shi riin fwaa ɓejee, ɗi baa gurum mo kǝlǝng mbii ɗi gha sat nǝ kas, ɓe cirang mon nsat nǝnee <<nǝ akǝse>> mɓe ɗangnaan (leshap kǝ Naan) mǝ pǝlang ɗi gha sat nǝ ye? Mɓeɗǝ baa gurum nǝ mo man mbii ɗi gha sat nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Koo ɗang ɗi ɗangnaan (leshap kǝ Naan) fwaa mǝ pǝlang Naan nǝ ret nNaan nyit, ɓe baa nǝ ɓam gǝnang kas. ");
INSERT INTO sur_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Wen pǝlang Naan, mɓeɗǝ wen kǝn leshap mo shi lǝpwoo mo shinǝ-shinǝ met nwun jir. ");
INSERT INTO sur_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Ɗang be ndǝǝn kuur mǝ Ekǝlisya, ɓe ngyel wen satpwoo mo a paat ɓejee, ɗi gurum mon nkǝleng, kǝ nǝ kám mbii mo zak, met ɗi wen nsatpwoo mo ngal kaapaat shi lǝpwoo mo shinǝ-shinǝ ɗe baa gurum mo manshii nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Ɗyemnaa mo, taji wu cìn pan kaa jep mo sǝ kas, wu ɗee kaa jep mo sǝ ndǝǝn mbii ɗebish mo, ɗangbe wu ɗee kaa nennan mo sǝ ndǝǝn pan fuu mo. ");
INSERT INTO sur_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan nǝnee, <<A shi gurum ɗi moo leshap ɗecǝ mo, <<kǝ a shi lǝpwoo kǝ mǝzep mo, <<ɓe wen nkatpwoo nen ɗesǝ mo, <<a ɗishik ɗangbe jir kǝsǝ, <<ɓe baa mon nkǝlǝng wen kas, Daa wur sat aasǝ.>> ");
INSERT INTO sur_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Katpwoo shi lǝpwoo mo shinǝ-shinǝ, nǝ ɗee a ɓee naa man mɓe nen ɗi baa mo shinzeen kas. Satpwoo ɗi Naan kǝ shin mmee gurum, mbǝkǝ wu sat mbii ɗi ngurum mo, mǝnǝ a mɓe nen ɗi mo kǝ ten shinzeen mo, baa mǝnǝ a mɓe nen ɗi baa mo kǝ shinzeen kas. ");
INSERT INTO sur_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Mɓǝmǝnǝ katɗang nenyil Ekǝlisya mo kaat ashak, ɗangɓe koo weyi wu ɗoom leshap shi lǝpwoo mo shinǝ-shinǝ, ɓe katɗang nen ɗi baa mo man mee mbii kas, koo nen ɗi baa mo kǝ shinzeen kas, mo jì ɗel ndǝǝn kuur fuu nǝ, ɓe wu pan nnǝ, mon nsat nǝ wun a nentar mo kas aa? ");
INSERT INTO sur_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Ɗangɓe katɗang ɓe koo weyi wur sat a pwoo kǝ Naan, ɓe katɗang mee gurum ɗi baa wur kǝ shinzeen kas, koo gwar ɗi baa wur man mee mbii kas, wur jì ɗel ndǝǝn kuur fuu nǝ. Ɓe pwoo Naan ɗi wuu sat nǝ, nǝn nle kǝ gwar mǝnǝ man nǝnee azeen-nzeen ɗi a ngushikbish, ɓe pwoo ɗewur kǝlǝng nǝ, nǝn mɓiyang pǝtuup fin. ");
INSERT INTO sur_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Mbii ɗi gwar mǝnǝ kǝ pan mo a sǝsok ndǝǝn pǝtuup fin, ɓe mon nkàa put agaak, kǝ har wu ntaa nyil, kǝ wu seyil ɗi nNaan, kǝ wur nsat ɗi nǝ, azeen-nzeen Naan wu ɗi nnaar fuu. ");
INSERT INTO sur_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","A mbii ɗe wen kǝn rǝɓet sat nǝ nɗesǝ, ɗyemnaa mo. Katɗang wu kuur ashak mɓe seyil nNaan, ɓe memee fuu kǝ kook mǝ kwoop Naan, kǝ memee kǝ mbiikám, kǝ memee kǝ pwoo ɗi Naan kǝ woo nwur, kǝ memee kǝ satpwoo ndǝǝn lǝpwoo ɗecǝ mo, kǝzak, memee kǝ pǝring mbii ɗi moo sat shi lǝpwoo ɗecǝ nǝ mo. Wu yit kǝ mbii ɗesǝ mo jir, mo ɗee a mbii ɗe mon cìn ɓal Ekǝlisya nǝ. ");
INSERT INTO sur_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Katɗang mee gurum mo man katpwoo shi lǝpwoo ɗecǝ mo, ɓe gurum mo kaa vǝl koo kun sǝ, mo katpwoo nǝ ndangshak-ndangshak, ɓe nǝ a tǝng mee gurum pǝring shii mbii ɗe mo sat nǝ ngurum mo jir. ");
INSERT INTO sur_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Ɗangɓe katɗang baa mee gurum ɗi, ɗewur mmak yakshii mbii ɗe ngusatpwoo shi lǝpwoo ɗecǝ nǝ wu sat kas, ɓe gwar mǝnǝ ɗok tǝtǝk ndǝǝn kuur Ekǝlisya nǝ, ɓe see wu leshap mǝnǝ a ndǝǝn pǝtuup fin kǝ Naan ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Gurum mo kaa vǝl koo kun sǝ, mo leshap ɗe Naan wur kǝ shin mo, mbǝkǝ mo sat nǝ ɗi ngurum mo. Nǝ ret kǝ kwoor nǝ mo ɓeetshii kǝ mbii ɗi mo sat nǝ. ");
INSERT INTO sur_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ɗangɓe katɗang Naan wu shin mee pwoo mee gurum ɗewur ɗi ndǝǝn kuur nǝ, mbǝkǝ wur sat ɗi ngurum nǝ mo, ɓe nǝ ret kǝ gwar ɗewur nkaa leshap nshee sǝ wur ɗok tǝtǝk. ");
INSERT INTO sur_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Wu mak satpwoo kǝ Naan nǝ ngurum mo ndangshak-ndangshak, mbǝkǝ koo weyi ɓe wu kám mee mbii ɗi kǝ nǝ ɓam pǝtuup nwur ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Zuum mǝ satpwoo Naan, nǝ a nder kǝ ngusatpwoo Naan nǝ. ");
INSERT INTO sur_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Baa Naan wur a Naan ɗewur cìn mbii mo a ɓurish kas, amma wur a Naan ɗewur tap cìn mbii mo ndangshak-ndangshak ndǝǝn ryang. ndǝǝn Ekǝlisya mǝ nen ɗeɓang mo jir, ");
INSERT INTO sur_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","nǝ ret kǝ, mat mo ɗok tǝtǝk ndǝǝn kuur mǝ Ekǝlisya mo. Baa mu rǝɓet mmo, kǝ mo leshap ɗi kas. Amma nǝ ret kǝ, mo sham kǝ káa fur mo, kaaɗi Wàar kǝ nen Yahudi mo sat sǝ. ");
INSERT INTO sur_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Katɗang mo rǝɓet man mee mbii, ɓe mo tal pǝ mish fur mo ntul. Mɓeɗi nǝ a mbii shweeppee, mbǝkǝ mat katpwoo ndǝǝn kuur kǝ Ekǝlisya mo. ");
INSERT INTO sur_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Ɗe mo shee pwoo kǝ Naan nǝ a shi wun aa? Koo a wun a nen ɗi pwoo Naan nǝ wul pee wun ɗi ɓejee ɗak yi? ");
INSERT INTO sur_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Katɗang mee gurum kǝ pan nǝ, wuɗin a ngusatpwoo Naan, koo wuɗi kǝ zuum ɗi nǝ a mǝ Riin, ɓe nǝ ret kǝ gwar mǝnǝ man nǝ, mbii ɗe wen kǝn ran nwun nǝ a Wàar Naan. ");
INSERT INTO sur_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Katɗang gwar mǝnǝ chii kǝlǝng pwoo ɗesǝ nǝ mo, ɓe taji wu kǝlǝng wu kas. ");
INSERT INTO sur_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Mɓǝmǝnǝ, ɗyemnaa mo, wu le pǝtuup fuu mo a nkaa satpwoo kǝ Naan, kǝ taji wu cíi katpwoo ndǝǝn lǝpwoo mo shinǝ-shinǝ kas. ");
INSERT INTO sur_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Amma wu cìn koo a meyii ndǝǝn ɗyen, kǝ ndangshak-ndangshak zak. ");
INSERT INTO sur_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Ɗyemnaa mo, yaksǝ ɓe wen rǝɓet baa lepan ɗi nwun, nkaa pwoo ɗeret, ɗe gyet wen kǝn sat nǝ nwun, ɗe gyet wuu lap nǝ, kǝ ɗe wu shinzeen, ɗi wuu ɗar a nkaa nǝ zak. ");
INSERT INTO sur_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","A shi pwoo ɗeret ɗesǝ nǝ, ɓe wuu kat ɓam wur katɗang ɓe wu yaa pwoo ɗi nghan kǝn sat nǝ nwun ɓalɓal. Katɗang aasǝ kas, ɓe shinzeen fuu nǝ a ɗebuu. ");
INSERT INTO sur_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Mbii ɗi gyet nghan kǝn lap nǝ, ɓe wen kǝ shin a nǝ nwun, ɗi nǝ kǝ kwoop nǝ hakyeng nǝ Kristi wu muut mɓe shikbish fun mo, kaaɗi mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan sǝ. ");
INSERT INTO sur_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Mo wum wur, ɓe wur yool a peemúut par shii ɗekun, nchiit kǝ mbii ɗi mo kǝ ten ran ndǝǝn ɓǝǝt haal kǝ Naan sǝ. ");
INSERT INTO sur_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Wur shee kámshin fin mPita, ɗangɓe wu kámshin fin njeplep fin ɗekaapaat baavǝl sǝ mo. ");
INSERT INTO sur_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Aɓwoon mǝnǝ, ɓe wur kámshin fin nenshínzeen mo, ɗi mo met kambǝlpàat a nook mǝndong. Pak nenyil ɗe jì mo naa wu, mo ɗi ɗes ɗe mo kuɗin kǝ seen, amma pak mo kǝ ten murep. ");
INSERT INTO sur_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Wur kámshin fin nJemis zak, kǝ jeplep fin nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Ɗangɓe a peekyes nǝ, ɓe wur kámshin fin nwen zak, wen ɗe an a kaa làa ɗe mo taa làa, ɓe baa tar làa nǝ kǝ wul kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Mɓeɗi nghan a ɗelee mɓut jeplep kǝ Jesu nǝ mo. Baa ɗi nǝ ret kǝ mo pet wen a memee mɓut jeplep Jesu mo kas, mbǝɗe gyet wen kǝn shin jeel Ekǝlisya Naan. ");
INSERT INTO sur_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Amma mɓe ɗeret Naan, ɓe wen ɗe, a agwe ɗe wen a nǝ yaksǝ sǝ. Ɗǝret ɗesǝ ɗe Naan wu shin nwen, nǝ kǝ cìn ɗak ɗes ndǝǝn wen. Har wen kǝn cìn ɗak shiɓal met jeplep fin nǝ mo jir. Ɗangɓe jir kǝsǝ, ɓe baa a wen cìn ɗak mǝnǝ mo kas, ɗangɓe a ɗeret Naan ɗe nǝ cìn ɗak ndǝǝn pǝtuup fen. ");
INSERT INTO sur_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Nǝ aasǝ, koo ɗi gyet, a Wen satpwoo nǝ, koo ɗi gyet a mo satpwoo nǝ, ɓe muu sat a mbii ɗemǝndong, kǝ wun wuu shinzeen a pwoo mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Katɗang moo satpwoo nǝ, Kristi wur kǝ yool a peemúut, ɓe a me le ɗang pak fuu moo sat nnǝ, baa mee yool a peemúut ɗi mɓe nen ɗi mo kǝ ten murǝp mo kas yi? ");
INSERT INTO sur_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Katɗang baa mee yool a peemúut ɗi, mɓe nen ɗi mo kǝ ten murǝp kas, ɓe nǝ kám nǝ, baa Kristi wur kǝ yool a peemúut kas mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Katɗang ɓe baa ɗi Kristi wur kǝ yool a peemúut kas, ɓe pwoo ɗeret, ɗi muu sat nǝ ɗee a ɗebuu, kǝ ɓe ɗe shinzeen fuu nǝ ɗee a ɗebuu zak. ");
INSERT INTO sur_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ɓe ɗi mǝ ɗee a nen cìn langtǝng mǝ ɗung mo nkaa Naan, mɓeɗǝ muu cìn langtǝng nkaa Naan nǝ, a Naan wur yool kǝ Kristi a peemúut. Amma katɗang ɗi nǝ azeen-nzeen nnǝ, baa nen ɗi mo kǝ ten murǝp mon nyool a peemúut kas, ɓe baa Naan wu kǝ yool kǝ Kristi a peemúut kas mǝnǝ zak. ");
INSERT INTO sur_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Katɗang baa nen ɗi mo kǝ murǝp mon nyool kas, ɓe baa Kristi wur kǝ yool kas zak. ");
INSERT INTO sur_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Katɗang ɗi baa Kristi wur kǝ yool a peemúut kas, ɓe shinzeen fuu nǝ ɗee a ɗebuu, ɓe ɗe har yaksǝ, wuu tong ɗi a mɓut shikbish fuu mo vit. ");
INSERT INTO sur_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Ɓe ɗi nen ɗi mo kǝ ten murǝp mɓut Kristi, mo kǝ ɗee a ɗiilǝloom mo mmǝnǝ zak. ");
INSERT INTO sur_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Katɗang ɗi canciin fun ndǝǝn Kristi nǝ a mɓe seen ɗi mǝ yil ɗiisi ɗak, ɓe ɗi mǝ ɗee a mbii naajeel, met koor gurum mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Yaksǝ Naan wur kǝ yool kǝ Kristi a peemúut azeen-nzeen. A wur a ɗinshee, mǝ yool a peemúut, mǝ nen ɗi mo kǝ ten murǝp mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Kaaɗǝ gyet, muut nǝ ɗel ndǝǝn yil ɗǝsǝ, a mɓe ngumǝndong, nǝ aasǝ zak, ɓe a mɓe ngumǝndong, ɓe Naan wur nyool kǝ gurum ɗi mo kǝ ten murǝp mo a peemúut zak. ");
INSERT INTO sur_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Mɓeɗǝ a mɓe Adam ɓe gurum mo jir mo murǝp, nǝ aasǝ zak, a ndǝǝn Kristi ɓe gurum mo jir mon nyool a peemúut kǝ seen. ");
INSERT INTO sur_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Ɗangɓe koo meye ɓe mo a ndangshak-ndangshak. A Kristi wur a ɗinshee mǝ yool a peemúut akuɗang. Katɗang wur mbaajì, ɗangɓe nen wur mon nyool a peemúut zak. ");
INSERT INTO sur_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Ɗangɓe peekyes kǝ yil nǝn njì wul, ɓe Kristi wur nshin mulki nǝ nNaan puun, aɓwoon ɗi wur kǝ ten twe koo a mulki, kǝ iiko, kǝ koo a ɓal ɗeɗang ye. ");
INSERT INTO sur_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Mɓǝɗǝ tǝng Kristi wur ncìn mulki nǝ har parpuus ɗe Naan wur nle shaarlek kǝ Jesu mo ɗee nder shii fen. ");
INSERT INTO sur_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Shaarlek ɗe wur ntu nǝ a peekyes nǝ, a muut. ");
INSERT INTO sur_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Mɓǝɗǝ Naan wur kǝ ten le mbii mo jir nder shii fen. Kaaɗǝ mo kǝ sat sǝ nǝnee, <<mo kǝ le mbii mo jir nder shii fen.>> Ɓe nǝ ɗee agaak nnǝ, baa a Naan ɗee nder fir kas, amma Naan wur kǝ le mbii mo jir nder kǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Dangbe, aɓwoon ɗi mo kǝ le mbii mo jir, nder mulki mǝ Naan, ɓe Làa nǝ wur shikáa fen, wur nleshin fen nder kǝ Naan. Naan ɗi wur le mbii mo jir nder Kristi, mbǝkǝ Naan wur se mulki ɗi nkaa mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Yaksǝ, katɗang ɓe ɗe baa mee yool a peemúut ɗi kas, ɓe ɗi nen ɗe moo cìn baptisma mmo a koppee kǝ nen ɗi mo kǝ murǝp, ɓe mon nkat a meye? Katɗang ɗi baa mee yool a peemúut ɗi kas, ɓe a me le ɗangɓe gurum moo cìn baptisma a koppee kǝ nenmuut mo ye? ");
INSERT INTO sur_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Kǝzak, ɓe ɗi a me le ɗangɓe muu lappee, kǝ muu shwaajeel ɗi kǝsǝ shidaar-shidaar yi? ");
INSERT INTO sur_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Ɗyemnaa mo, wen kǝn naa muut, koo a puus ɗeɗang yi. A roop ɗi wen kǝnǝ ndǝǝn wun, ɗi nǝ a seen fun ndǝǝn Kristi Jesu, Daa fun, a nǝ le ɗang wen sat pwoo mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Katɗang ɗi gyet wen cìn lek ashak kǝ luwayil mo nyil Afisus a mbe pan mǝ gurum ɗak, ɓe lǝɓet ɗi wen nkat nǝ a me yi? Katɗang ɓe baa mo yool kǝ nen ɗi mo kǝ ten murǝp a peemúut kas, <<Ɓe wu yit kǝ mu se, mu shwaa, mbǝkǝ dǝɗaar ɓe mǝ murǝp ɗi.>> ");
INSERT INTO sur_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Taji wu yit kǝ mee gurum ngwam wun kas. Katɗang gurum kǝ mwaan ashak kǝ nenɗebish mo, ɓe mǝse fin nǝn nɗee a ɗebish zak. ");
INSERT INTO sur_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Wu baa wu jì ndǝǝn pan fuu mo kaaɗi nǝ ret kǝ wu cìn sǝ, kǝ wu nook cìn shikbish. Wen kǝn sat nwun nǝ, baa pak fuu mo man Naan kas. Wen kǝn sat ɗiisi a mbǝkǝ nǝ shweep wun ɗi. ");
INSERT INTO sur_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Meeɓe, mee gurum ntal nǝnee, <<Chinarang ɗangɓe nen ɗi mo kǝ ten murǝp, mon mbaa yool ɗi a peemúut kǝ seen yi? Mon nyool a shi nkan fwoshik ɗeɗang yi?>> ");
INSERT INTO sur_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Waa mwen! A man nǝ, katɗang a kop cirem ndǝǝn yil, ɓe see cirem nǝn nwam, ɗangɓe àas mbii ɗi a kop nǝ kàa put. ");
INSERT INTO sur_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Katɗang a kop mee cirem nyil, ɓe baa waa kǝ iiko nkaa nǝ kas, amma waa kǝkop a àas nǝ ɓejee ɗak. Bishmee ɓe, nǝ a àas shwaa, kas meeɓe mee cirem ɗeɗik. ");
INSERT INTO sur_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Ɗangɓe Naan wur nshin mee fwooshin ɗi nnǝ, kaaɗe wur kǝ ten le nǝ sǝ. Koo àas cirem ɗeɗangyi, ɓe Naan wur ntap shin fwooshin kǝ nǝ ɗík. ");
INSERT INTO sur_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Baa nan mo a nchiit-nchiit jir kas. Gurum mo kǝ nan muru ɗyik, kǝ luwa mo kǝ nan muru ɗyik, kǝ nyer mo kǝ nan muru ɗyik, kǝ pupwap mo kǝ nan muru ɗyik zak. ");
INSERT INTO sur_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Mun ɗi kǝ fwoshik ɗi mo a mǝ ɗengnaan, kǝ mun ɗi kǝ fwoshik ɗi mo a mǝ yil ɗesǝ zak. Amma fwoshik fun ɗi mo a mǝ ɗengnaan, ret kǝ ɗeɗes kǝ mo ɗík zak kǝ fwoshik fun ɗe mo a mǝ yil ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Ret ɗeɗes mǝ puus nǝ ɗík, ret kǝ ɗeɗes mǝ tar nǝ ɗík, kǝ mǝ zar mo ɗík zak, jir kǝsǝ, ɓe pak ret kǝ ɗǝɗes, mǝ zar nǝ moo met nshak zak. Mo ɗe kǝ ɗeɗes fur mo shinǝ-shinǝ. ");
INSERT INTO sur_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Nin nɗee aasǝ zak, parpuus ɗi nen ɗi mo kǝ ten murep, mon nyool a peemúut. Kaaɗǝ mo wum gurum, ɓe fwoshik fin nǝ wam, amma kaaɗe Naan wu nyool kǝ gurum a peemúut, ɓe baa fwoshik fin nǝn nwam ɗi zak kas. ");
INSERT INTO sur_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Kaaɗǝ mo wum gurum, ɓe nii bish naa, kǝ baa nǝ kǝ ɓal kas, amma parpuus ɗe Naan wur nyool kǝ nǝ a peemúut, ɓe nǝn yool a ndǝǝn ɗǝɗes, nǝn nret naa zak. ");
INSERT INTO sur_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Kúm gurum ɗi moo wum nǝ aa fwoshik mǝ nan ɓejee ɗak, ɗangɓe parpuus ɗi Naan wur nyool kǝ gurum a peemúut, ɓe nǝ ɗen a fwoshik mǝ riin. Kaaɗǝ fwoshik ɗi nǝ a mǝ nan nǝ ɗi sǝ, ɓe azeen-nzeen fwoshik ɗe nǝ a mǝ riin nǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Mo kǝ ten ran ndǝǝn ɓǝǝt haal Naan nǝnee, <<Naan wur shee le Adam wur a gurum ɗeseen.>> Amma Adam ɗe mǝ kyes nǝ, wur a Riin, kǝ wur shin seen ngurum mo. ");
INSERT INTO sur_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Baa gyet a gwe mǝ riin wur shee jì kas, amma gyet a gwe mǝ nan shee jì ɗangɓe gwe mǝ Riin kǝ waaji. ");
INSERT INTO sur_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Gwar ɗe gyet Naan shee le wur, ɓe gyet Naan ɗak wur a shi yil, ɗangɓe gwar ɗevǝl nǝ wur tong aɗeng sham ɗi. ");
INSERT INTO sur_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Nen ɗi mo a mǝ yil nǝ, ɓe mo a kaa gwar ɗi gyet Naan shee ɗak wur shi yil nǝ sǝ. Ɗangɓe nen ɗi mo a mǝ ɗeng, ɓe mo a kaa gwar ɗi gyet wur tong aɗeng sham ɗi sǝ. ");
INSERT INTO sur_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Kaaɗǝ muu lep a fwoshik ɗi nǝ a kaa mǝ gwar ɗe gyet Naan ɗak wur a shi yil sǝ, ɓe mun nyool mǝ lep a fwoshik ɗe nǝ a kaa mǝ gwar ɗewur tong aɗeng sham ɗi sǝ zak. ");
INSERT INTO sur_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Ɗyemnaa mo, wen kǝn sat nwun agaak nǝ, baa gurum ndǝǝn mǝse mǝ nan kǝ toom, mak sekoop mǝ mulki Naan kas. Kǝ baa mbii ɗewam, nǝn mmak sekop a koppee kǝ mbii ɗi baa nii cam wam kas, zak. ");
INSERT INTO sur_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Wu lekom, kǝ wen sat mee mbii ɗe nǝ a sǝsok ɗi nwun. Baa mun jir mun mmurep kas, amma Naan wur nchǝǝr kǝ fwoshik fun nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Kǝlak kaa ɗyaapyit (kup yit chǝǝr wang) sǝ, parpuus ɗi mon ntàa feer ɗi mǝ kyes nǝ, ɓe nen ɗi mo kǝ ten murep, mon nyool kǝ seen. Baa mon mbaa wam ɗi zak kas. Ɗangɓe mon nchǝǝr kǝ fwoshik fun nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Mɓǝɗǝ nǝ a tǝng parpuus mǝnǝ, ɓe fwoshik fun ɗi mo a mǝ wam, mon nlep sun ɗi baa mǝnǝ mon cham wam kas zak, kǝ sun fun ɗi mo a mǝ muut, ɓe baa mon cham murǝp kas zak. ");
INSERT INTO sur_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Aɓwoon ɗi fwoshik fun ɗi mo a mǝ wam, mo lep fwoshik ɗi baa mon cham wam kas, kǝ fwoshik fun ɗi mo a mǝ muut, mo lep fwoshik ɗi baa mon cham murǝp kas zak. Ɗangɓe sǝmpwoo ɗi mo kǝ ten ran nǝ ndǝǝn ɓǝǝt haal kǝ Naan nǝn ngam ɗi, ɗe nǝ sat nǝnee, <<Mo kǝ see koorong kǝ muut hakyeng kǝnding-nding. ");
INSERT INTO sur_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Muut, koorong fii nǝ a nneyi? Muut, ɓal fii ɗi wii twe gurum mo ɗishik sǝ nǝ a nneyi?>> ");
INSERT INTO sur_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ɓal mǝ twapee kǝ muut nǝ a shikbish, kǝ a mbǝ Wàar ɗangɓe shikbish nǝ kat iiko. ");
INSERT INTO sur_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Ɗangɓe yaksǝ, mǝ pǝlang Naan, ɗewur shin se koorong mmun ndǝǝn Daa funu Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Mɓǝmǝnǝ ɗyemnaa mo, wu ɗar ɓalɓal. Taji wu le kǝ mee mbii tǝr wun kas. Ɗangɓe wu sat a ncìn ɗak mǝ Daa shidaar-shidaar, mbǝɗe wu man nǝ, koo a ɗak ɗeɗangyi ɗe wuu cìn nǝ mɓe Daa, ɓe baa nǝn cham ɗee a mbii ɗebuu kas, koo dǝɓen ");
INSERT INTO sur_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Yaksǝ, ɓe pwoo nkaa kok shool ɗi wun ntul nǝ mɓe ɓam nen Naan ɗe mo nyil nJudiya, nǝ ret kǝ wu cìn kaaɗe gyet wen kǝn sat Ekǝlisya ɗi mo ndǝǝn yil nGalati mo cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Koo a puus Láadi ɗeɗangyi, ɓe nǝ ret kǝ koo weye wu le mee shool mɓe shin zuum nciit-nciit kǝ ɓal fin, mbǝkǝ katɗang parpuus ɗe wen ndem pee wun ɗi, ɓe taji wu ɗee ncak mee shool kas. ");
INSERT INTO sur_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Katɗang wen ndem wul pee wun ɗi, ɓe wen nshin lepran Nen ɗe wuu ten wu bǝlǝp mo, mbǝkǝ mo dǝm ɗi kǝ shool nǝ yilkaam nJerusalem. ");
INSERT INTO sur_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Katɗang wen naa nǝ ret, kǝ wen dǝm nJerusalem, ɓe mon ndem ashak kǝ wen zak. ");
INSERT INTO sur_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Wen njì pee wun ɗi, aɓwoon ɗe wen kǝn dǝm nyil mMasidoniya, mɓeɗǝ wen kǝn Rǝɓet yaa ar nǝ ɗel dǝm a nyil mMasidoniya nǝ. ");
INSERT INTO sur_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Meeɓe wen mpan nyém pee wun ɗi mɓe rep pee mo nlǝr ɗak, kǝ meeɓe wen ntong pee wun ɗi mɓe tar kut, mbǝkǝ wu ɓam wen ɗi, a ar mwaan fen, koo pee ɗeɗang ye ɗi wen ndem ɗi. ");
INSERT INTO sur_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Ɗyeen nwen nnaa wun zam, baa a ɗe wen nnaa wun, ɓe wen a ar ɗel dǝm kǝlak-kǝlak kas. Katɗang Daa wur rǝɓet, ɓe wen ncanciin mɓe dǝm tong pee wun ɗi pan pong. ");
INSERT INTO sur_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Amma wen ntong mpeesǝ nyil Afisus, har see parpuus mǝ serǝɓet mǝ Pentikos. ");
INSERT INTO sur_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Mɓǝɗǝ, pee ɗe nwen ɗes mpee ɗesǝ, mbǝkǝ wen katpee cìn ɗak ɗeret, kǝ ɗi nii koop nǝ ndǝǝn nyil Afisus nǝ zak. Koo ɗe gurum mo ɗes moo cii ɗak fen nǝ. ");
INSERT INTO sur_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Katɗang Timoti wur dǝm wul pee wun ɗi, ɓe wu kaat wur rǝret nnaar fuu. Taji wu le mee kǝǝrmuut yaa wur kas, mɓeɗǝ wur kǝ cìn a ɗak kǝ Daa, kaaɗe wen kǝn cìn sǝ zak. ");
INSERT INTO sur_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Taji mee gurum ɓák wur kas, amma nǝ ret kǝ wu ɓam wur ndǝǝn mwaan fin, mbǝkǝ wur sekyeen ɗi kǝ mwaan fin nǝ ndǝǝn ryang, kǝ mbǝkǝ wur waaji ɗi pee wen ɗi zak, mɓeɗǝ wen kǝn leyit mɓe naa waaji fin ashak kǝ pak ɗyemnaa mo zak. ");
INSERT INTO sur_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Yaksǝ, pwoo nkaa ɗyemnǝǝn fun, Apolos, ɗí wen kǝn satpwoo nwur shiɓal nǝ, nǝ ret kǝ wur dǝm naa wun ashak kǝ ɗyemnǝǝn mo. Baa gyet ɗyeen nwur ndǝm pee wun ɗi nciit kǝ mǝnǝ kas, ɗangɓe katɗang wur nkatpee, ɓe wur ndǝm pee wun ɗi. ");
INSERT INTO sur_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Wu tong shi gongpee, kǝ wu ɗar ɓalɓal ndǝǝn shinzeen fuu. Wu ɗee a nengung mo ndǝǝn pǝtuup, kǝ nenɗeɓal mo. ");
INSERT INTO sur_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Wu cìn ɗak fuu mo jir ndǝǝn wal. ");
INSERT INTO sur_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Wu man nǝ, gyet a nentul kǝ Stifenas mo a nen ɗi gyet mo shee shinzeen ndǝǝn nyil Akaya, kǝ mo shin sut fur mo mɓe cìn ɗak ɗi mo ɓam nen Naan mo ɗi zak. Wen kǝn ɗang pǝ wun ɗyemnaa fen mo, ");
INSERT INTO sur_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","kǝ wu mwaan nɗang mǝse kǝ gurum mo kaa mǝnǝ mo sǝ, kǝ wu mwaan nɗang koo weyi ɗe wu shin káa fin, mɓe cìn ɗak mǝ ɓam wur, ashak kǝ mo. ");
INSERT INTO sur_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Nǝ fes ret nwen nyit zam, mɓe jì kǝ Stifenas kǝ Fortunatus, kǝ Akaikus, mɓeɗǝ mo jì kǝ mbii mo nwen a koppee fuu, mbii ɗe baa ɗí wen kǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Kǝzak, mo caa wen, kaaɗe ɗi moo caa wuwun sǝ. Gurum mo kaa mo sǝ, nǝ ret kǝ wu shin ɗeɗes mmo. ");
INSERT INTO sur_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Ekǝlisya ɗe mon nkwang yil mǝ Eshiya moo lep tokshik fur mo dǝm pee wun ɗi. Akwila kǝ Priskila, kǝ Ekǝlisya ɗi moo kaat ashak ndǝǝn tul fur, mo lep tokshik mǝ nen dǝm nɗang Jesu mo dǝm nwun ndǝǝn sǝm kǝ Daa. ");
INSERT INTO sur_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Ɗyemnǝǝn fun, ɗi mo mpeesǝ, moo lep tokshik fur mo dǝm pee wun ɗi jir. Wu tok kǝ shak ndǝǝn wal kaa mǝ nen dǝm ndang Naan mo sǝ. ");
INSERT INTO sur_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","A wen Pool, kǝn ran tokshik ɗesǝ nwun, shi sar fen. ");
INSERT INTO sur_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Koo ngwar ɗeɗangyi ɗe baa wur wal nDaa kas, ɓe wu yit kǝ gwar mǝnǝ ɗee a mbii caan Naan. Daa fun wur mbǝ waaji. ");
INSERT INTO sur_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Ɗǝret kǝ Daa fun Jesu nǝ tong ashak kǝ wun jir. ");
INSERT INTO sur_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Wal fen nǝ tong ashak kǝ wun jir ndǝǝn sǝm kǝ Kristi Jesu. Nǝ aa sǝ.");
INSERT INTO sur_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Lepran desǝ nǝ put a nsar Pool laalǝp mǝ Kristi Jesu, shi reɓet Naan, kǝ nsar kǝ ɗyemnǝǝn fun nǝ Timoti. Wen kǝn lep lepran desǝ nǝ dǝm pee Ekǝlisya joon Naan ɗi moo nKoronti, kǝ nenseet nɗang Jesu ɗi mo nɗǝǝn yil Akaya jir. ");
INSERT INTO sur_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Ɗeret, kǝ ryang mǝ Naan puun fun, kǝ mǝ Daa fun Jesu Kristi mo tong ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","wen kǝn pǝlang Naan puun Daa fun Jesu Kristi. Puun ɗi wur gam kǝ kussuk mǝ naajeel. Naan ɗi wur a nguɓam mun jir. ");
INSERT INTO sur_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","A wur ɓam mun mɓut njeel fun mo jir, mbǝkǝ mǝ katpee ɓam nen ɗi moo shwaajeel mu shinǝ-shinǝ shi ɓam ɗi mu mǝ kat nǝ pee Naan ɗi sǝ zak. ");
INSERT INTO sur_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Kaaɗe mu shwaajeel ɗes, nɗǝǝn jeel ɗe Kristi wur kǝ shwaajeel sǝ, bǝ Naan wur mɓam mun ɗes nɗǝǝn Kristi aasǝ zak. ");
INSERT INTO sur_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Katɗang mu shwaajeel, bǝ nǝ a mbǝ gang pǝtuup fuu mo, kǝ nǝ a mbǝ ɓam fuu zak. Katɗang Naan wur ɓam mun, bǝ nǝ a mbǝ ɓam wun zak, ɗi nǝn nle kǝ wu gung caan jeel ɗi wuu shwaa nǝ mo, kaa mun sǝ zak. ");
INSERT INTO sur_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Mbǝmǝnǝ bǝ canciin fun ɗi nǝ nɗǝǝn wun, baa nǝ mak yoon kas, koo lee. Pe gyet di mu man nǝ, kaaɗi wuu shwaajeel ashak kǝ mun sǝ, bǝ wun nkat ɓam ashak kǝ mun aasǝ zak. ");
INSERT INTO sur_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Ɗyemnaa mo, muu reɓet kǝ mǝ le nwun npan, nkaa jeel ɗi mǝ shwaa nǝ nɗǝǝn yil Eshiya. Gyet jeel nǝ fes ten mun toon-toon hakyeng, har gyet nǝ met mmun mɓal, kǝ har gyet mu put kǝ pǝtuup fun mo nǝ, baa mun mbar kas. ");
INSERT INTO sur_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Kǝ gyet mǝ naa kaa mo can a ɗyeel tukáa mmun sǝ, ɗang nǝ cìn aasǝ, a mbǝkǝ taji mu gángkáa fun a nkaa sun fun mo kas, amma mu gángkáa fun nǝ mo a nkaa Naan ɓejee ɗak. Naan ɗi wur yool kǝ gurum mo a peemúut. ");
INSERT INTO sur_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Naan wur ten put kǝ mun nɗǝǝn muut nǝ, kǝ wur mbǝ put kǝ mun nɗǝǝn muut nǝ zak. Mun mǝ shinzeen nǝ, wur waa put kǝ mun nɗǝǝn muut nǝ ryang zak. ");
INSERT INTO sur_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","Wu ɓam mun shi ɗangnaan (leshap kǝ Naan) fuu mo, mbǝkǝ gurum mo ɗes mo pǝlang Naan ɗi mbǝ mun, mbǝ ɓam ɗi Naan wur cam cìn nǝ mmun. Pe ɗi Naan wur lap ɗangnaan (leshap kǝ Naan) ɗi gurum mo ɗes moo cìn nǝ mbǝ mun. ");
INSERT INTO sur_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","A mbii ɗe mu canjoom ɗikǝ nɗesǝ, apan ɗi nɗǝǝn pǝtuup fun mo kǝ cìn langtǝng nǝ, tong fun nɗǝǝn yil desǝ nǝ a shi pǝtuup mǝndong, pǝ Naan, kǝ pee wun ɗi zak. Baa a shi mee seen ɗi nǝ a mu gurum mo kas, amma a shi ɗeret mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Baa mu ran a mee pwoo ɗeluk nwun nɗǝǝn ran nǝ kas, ɗang a pwoo nkaa mbii ɗe wun mmak tang nǝ, bǝ wun mmanshii nǝ zak. Wen canciin nǝ, wun mmanshii nǝ rǝret. ");
INSERT INTO sur_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Kaaɗe wuu ten wu manshii nǝ lee sǝ nǝ, wun mmak canjoom shi mun, kaaɗe mumun ncanjoom shi wun sǝ zak, parɗe Daa fun Jesu wur njì nɗǝǝn yil ɗesǝ zak. ");
INSERT INTO sur_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","A mbǝɗe gyet wen naa nǝ ret aasǝ, a nǝ le ɗang gyet wen kǝ reɓet dǝm pee wun ɗi nshee, mbǝkǝ wu kat ɗeret ɗi kaa yit vǝl sǝ. ");
INSERT INTO sur_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Wen kǝn reɓet taa pee wun ɗi, a ar dǝm mMasidoniya, kǝ katɗang wen dǝm mMasidoniya nǝ, bǝ wen njì taa pee wun ɗi zak, mbǝkǝ wu ɓam wen ɗi a ar dǝm nyil nJudiya. ");
INSERT INTO sur_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Ashee! Kaaɗe di wen reɓet cìn kǝsǝ, bǝ wen cìn a mbii ɗe nkan mmǝnǝ aa? Aa koo, wu yee nǝ wen kǝn cìn mbii a buubuu, kaaɗi gurum mǝ yil nǝ moo cìn sǝ yi? Ɗe wen nsat nǝnee, <<Ii, Ii>> ɗangɓe nbwoon, bǝ wen waa sat nǝnee, <<haiyoo, haiyoo>> Zak aa? ");
INSERT INTO sur_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Kaaɗe Naan wur a nguzeen sǝ, bǝ pwoo ɗe muu sat nwun, baa nǝ a <<Ii>> Kǝ <<haiyoo>> Kas. ");
INSERT INTO sur_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Pwoo ɗi gyet Silas kǝ Timoti kǝ wen, mu sat nwun nkaa Jesu Kristi làa Naan, bǝ baa pwoo mǝnǝ a Ii, koo haiyoo kas. Amma nɗǝǝn Naan, bǝ koo a pǝrangye, bǝ pwoo mǝnǝ a <<Ii>> ");
INSERT INTO sur_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Pe gyet ɗi pwoo ɗe Naan wur tuweerpwoo mo jir, bǝ mo gampwoo mǝnǝ mo a nɗǝǝn Jesu, kǝ a mbǝ Jesu ɗangɓe muu sat nǝnee, <<Nǝ aasǝ>> Zak mbǝkǝ mo le Naan ɗi a ɗeɗes. ");
INSERT INTO sur_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","A Naan ɗi wur bǝlǝp mun le ɗyik, a wur le mun ashak kǝ wun nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","Wur bii naa man wur nkaa mun, nǝ mun a mu wur mo. Wur shin Riin wur ɗeɓang mmun nɗǝǝn pǝtuup fun mo, mbǝkǝ Riin nǝ kám ɗi mmun mbii ɗe wur le nǝ mmun a kyeen. ");
INSERT INTO sur_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Amma wen pet Naan a langtǝng fen nǝ, mbii ɗe di nǝ le kǝ wen nook dǝm nKoronti nǝ, a mbǝkǝ taji wen lejeel nwun kas. ");
INSERT INTO sur_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Baa muu gung a mbǝkǝ mu le tǝng ɗi nwun nkaa mbii ɗi wu shinzeen nnǝ kas koo lee, mbǝɗe wuu ɗar ɓalɓal nɗǝǝn shinzeen nǝ. Amma muu cìn ɗak ashak kǝ wun, mbǝkǝ wu kat retnyit ɗi. ");
INSERT INTO sur_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Wen lepan nɗǝǝn pǝtuup fen nǝ, baa wen mbaa dǝm pee wun ɗi kas, mbǝkǝ taji wen wàt pǝtuup nwun. ");
INSERT INTO sur_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Katɗang bǝ wen wàt pǝtuup nwun, bǝ a wii nɗee ɗi a ɗe wur nle retnyit nwen yi? A wun nen ɗi wen wàt pǝtuup nwun, bǝ a wun ncaa wen. ");
INSERT INTO sur_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","A mbǝmǝnǝ, bǝ wen ran-ran nǝ nwun, mbǝkǝ katɗang wen jì pee wun ɗi, bǝ taji wen kat mee mbii wàt pǝtuup mɓut nwun, nen ɗi wu le retnyit nwen kas. Wen shinzeen nwun jir nǝ, retnyit fen nǝ a muu jir zak. ");
INSERT INTO sur_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Wen ran-ran nǝ nwun a shi pǝtuup ɗeewuwat hakyeng, kǝ shi yitmwaa, kǝ jeel ɗes zak. Wen ran-ran desǝ, baa a mbǝkǝ wen wàt pǝtuup ɗi nwun kas, amma a mbǝkǝ wu man ɗi nǝ, wen wal nwun zam. ");
INSERT INTO sur_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Katɗang mee ngwe wàt pǝtuup mmee gurum, bǝ baa ngwe mǝnǝ tǝkook a pǝtuup mǝnǝ ɓejee ɗak kas, amma wur tǝkook aa pǝtuup muu, koo a pǝtuup mǝ pak fuu mo. Baa ɗyen nwen nsatpwoo shiɓal nkaa ngwe mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Mpee nkaan ngwe mǝnǝ, bǝ kar ɗe wuu ten shin nwur, nǝ mak. ");
INSERT INTO sur_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Amma yaksǝ, bǝ ngyel wu fwo ɗi ngwar mǝnǝ, mbǝkǝ wu ɓam wur ɗi, mbǝkǝ taji pǝtuup ɗe wat wur nǝ waa sǝǝt daampee nwur hakyeng. ");
INSERT INTO sur_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Mbǝmǝnǝ wen ɗang pee wun, wu sǝǝt wu kám wal fuu moo nwur. ");
INSERT INTO sur_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Gyet wen ran-ran nǝ nwun, a mbǝkǝ wen cam wun ɗi, kǝ wen man ɗi nǝ, kyet wun a nen cìn mbii mo, nɗǝǝn ɗyen jir wo? ");
INSERT INTO sur_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Koo ngwe ɗeɗangyi ɗi wu fwo nwur, mbǝ mee ɗebish ɗe wur cìn, bǝ wen nfwo ngwe nǝ aasǝ zak. Katɗang bǝ mee mbii mǝ fwo nǝ ɗi, bǝ wen nfwo ngwe mǝnǝ a mbǝ wun, mbǝ ɗeret Kristi. ");
INSERT INTO sur_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Mbǝkǝ taji Gujwan kat mee lǝɓet nɗǝǝn mun kas, mbǝɗe baa seen wur ɗebish mo a ɗesǝsok mmun kas. ");
INSERT INTO sur_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Kaaɗe wen baaji nTrowas mbǝ satpwoo nkaa Kristi ngurum mo, bǝ wen kat Daa wur kǝ wang ar mbǝ wen. ");
INSERT INTO sur_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Jir kǝsǝ, bǝ baa pǝtuup fen nǝ kat retnyit kas, mbǝɗe baa wen kat ɗyemnǝǝn fen Titus ɗi mpǝmǝnǝ kas. Mbǝmǝnǝ bǝ gyet wen sat ɗang-mukaat mmo, bǝ wen ɗel dǝm nyil Masidoniya. ");
INSERT INTO sur_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","wen pǝlang Naan, ɗe a wur kǝ ɓwet mun shidaar-shidaar, kǝ mu ɗee ɗi a koorong mo, mbǝ ɗeret Kristi. A shi mun, bǝ wur pwǝǝr man Kristi ɗe nǝ a kaa mbii ɗe nǝ kǝ toos shangshang sǝ, koo a mpee ɗeɗangyi. ");
INSERT INTO sur_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Pe gyet ɗi pee Naan ɗi, bǝ mun a kaa toos deshang mo, mǝ Kristi, pǝ nen ɗe mo kat ɓam, kǝ nen ɗe mo a ar loom. ");
INSERT INTO sur_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","A mǝ peekyes nǝ nɗesǝ, ɗu ɗevǝl nǝ a ɗu ɗe mǝ wam, mǝ muut ɗi nǝ dǝm a peeloom. Amma a mu ɗinshee nǝ nɗesǝ, nǝ a fwaap deshang mǝ seen ɗi nǝ dǝm a peeseen. A wii mmak mang toon mbii ɗesǝ mo yii? ");
INSERT INTO sur_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Mɓeɗe baa mun a kaa pak gurum ɗe moo satpwoo Naan nǝ a mbǝ kat lǝɓet mǝ shool kas. Pwoo munu nǝ a mǝndong, mbii ɗi Naan wur sat mmun, bǝ mu sat a pwoo mǝnǝ dǝǝn zeen ntoom Naan aasǝ, kaa kǝrem Kristi mo sǝ. ");
INSERT INTO sur_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Yaksǝ, bǝ mun nwaa mǝ ɗoom kwoop a káa fun zak aa? Kyet mu reɓet mee ran nkaa mu mǝ langtǝng dǝm pǝ wun ɗi, koo ran mǝ langtǝng nkaa wun ji pǝ mun ɗi, kaaɗǝ pak gurum moo kǝ cìn sǝ wo? ");
INSERT INTO sur_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Wun shikáa fuu, a wun a ran fun, ɗi mon cin langtǝng ɗishik nǝ. Mo joon ran nǝ nɗǝǝn pǝtuup fuu mo, mbǝkǝ koo wii wur man nǝ ɗi, kǝ wur tang ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Nǝ kám agaak nǝ, a Kristi shikáa wur ran-ran desǝ nǝ mo nɗǝǝn pǝtuup fuu mo, ɗangɓe wur lep nǝ nsar fun. Baa mo ran-ran desǝ nǝ a shi ink kas, kǝ baa mo ran nǝ a nkaa sulet mǝ ngǝk kas. Amma mo ran nǝ a nɗǝǝn pǝtuup gurum mo, shi Riin Naan ɗi wur mmeen har ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Muu sat pwoo mǝnǝ, a mbǝɗe mu gàngkàa nkaa Naan nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Baa mee mbii nɗǝǝn mun, ɗi nǝ mak le kǝ mu sat nǝ, mǝ cìn mbii desǝ mo a shikáa fun nǝ kas. Ɗak desǝ nǝ a ɓal ɗi mu mak cìn pak mbii mo, put a pee Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Mbǝɗe a wur le kǝ mǝ ɗee a nen cìn ɗak mǝ ɓǝlemcuk shi toom Naan ɗepwoo, baa a shi Wàar ɗerǝran mo kas, amma a shi Riin. Wàar ɗerǝran nǝ jì kǝ muut, amma Riin mǝ Naan wur shin seen. ");
INSERT INTO sur_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Gyet mo ran Wàar Mosis nǝ mo a nkaa sulet mǝ ngǝk mo, kǝ Kaaɗe gyet Naan shin Wàar nǝ mo mMosis, bǝ ɗeɗes mǝ Naan jì put agaak. Koo ɗi gyet mǝlep mǝ yit Mosis nǝ kyes, bǝ baa gyet nen Yahudi mo mak tǝǝr yit fur mo nkaa yit Mosis kas, mbǝ peeɓang ɗi nǝ ɗes nǝ. Katɗang bǝ gyet Wàar mǝ Mosis ɗi nǝ jì kǝ muut nǝ jì aa ɗeɗes aasǝ, ");
INSERT INTO sur_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ɓe nǝ a tǝng ɗak mǝ Riin mǝ Naan nǝn nɗes met mǝ Wàar nǝ. ");
INSERT INTO sur_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Katɗang bǝ mo le ɗak mǝ Wàar ɗi nǝ jì kǝ loom a ɗeɗes, bǝ azeen-nzeen ɗak mǝ Riin ɗi nǝn njì kǝ ɗeret mǝ Naan, nǝ a ɗeɗes met ɗak mǝ Wàar nǝ hakyeng. ");
INSERT INTO sur_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Nɗǝǝn desǝ, bǝ wu naa nǝ, mbii ɗi gyet nǝ a ɗeɗes, bǝ mbii ɗi nǝn ntong ɗi har ngaa-ngaa nǝ fes met ɗi gyet yam nǝ. ");
INSERT INTO sur_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Katɗang bǝ mo kám nǝ, mbii ɗi ndung ɗel dǝm a ɗeɗes, bǝ mbii ɗi nǝ ntong ɗi har ngaa-ngaa nǝn nɗen kǝ ɗeɗes met ɗi nǝ ndung ɗel dǝm nǝ, ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Mbǝɗe mun kǝ canciin nɗǝǝn pwoo ɗeret nǝ aasǝ, bǝ muu satpwoo fun shiɓal agaak hakyeng. ");
INSERT INTO sur_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Baa mun a kaa Mosis sǝ kas, ɗi gyet wur paa yit wur shi fwaat, mbǝkǝ taji nen Yahudi mo naa kyes ɗeɗes, mǝ mǝlep mǝ yit wur ɗi nǝn nɗel dǝm sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Mbǝɗe gyet pan fur nǝ mo a ɗeduduur har mbǝ cicinsǝ. Katɗang mo ɗoom tang pwoo Naan ɗesǝǝr, bǝ fwaat paapee desǝ nǝ paa nǝ, kǝ nǝ kutdi, a ɗepǝpaa pee mo ɗi. See katɗang gurum shinzeen nKristi ɓejee, ɗangɓe moo mmak mang fwaat nǝ waa kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Azeen-nzeen har cicinsǝ, katɗang mo ɗoom tang Wàar mǝ Mosis nǝ mo, bǝ fwaat desǝ, nǝ kǝ paa pǝtuup fur mo ɗi vit. ");
INSERT INTO sur_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Amma katɗang mee gurum cǝǝr pee Daa ɗi, bǝ abet, mon mmang fwaat nǝ baa kǝ nǝ aku pee ngu nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Daa wur a Riin, kǝ peeɗe Riin Daa nǝ ɗi, bǝ gurum mo ɗee a mukáa fur. ");
INSERT INTO sur_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Yaksǝ, mun nenseet nɗang Jesu mo jir, bǝ mo mang fwaat ɗi nǝ paa yit fun mo ba kǝ nǝ aku. Yaksǝ bǝ gurum moo naa a ɗeɗes kǝ Daa nɗǝǝn tong fun nǝ mo, kǝ wur cǝǝr kǝ mun, kǝ mǝ ɗee ɗi kaa wur sǝ, nɗǝǝn ɗeɗes wur ɗi nǝ nkaa wurang. Ɗesǝ nǝ put a pee Riin mǝ Naan ɗewur a Daa. ");
INSERT INTO sur_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","A Naan Wur cin ɗak mǝ Satpwoo wur ɗeret wo mun nɗǝǝn ɗeret mǝ kussuk wur. Mbǝmǝnǝ, bǝ taji nǝ waam kwak mun kas. ");
INSERT INTO sur_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Mu cii cìn ɗak ɗebish mo, kǝ mbii naashweep ɗe a sǝsok, kǝ mbii ɗe mo le naashweep ngurum mo jir. Baa mun ncìn ɗung ngurum mo, koo sat ɗung nkaa pwoo kǝ Naan kas. Ɗang mu sat zeen nǝ agaak, mbǝkǝ koo a wii, bǝ wur naa zeen fun nǝ di, nɗǝǝn ɗyen wur, nyit Naan. ");
INSERT INTO sur_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Katɗang bǝ pwoo Naan ɗe muu sat nǝ a ɗepǝpaa, bǝ nǝ a pǝpaa a mɓee nen ɗe mo a ar loom ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Baa mo shinzeen kas, a mbǝɗe mishkoom ɗebish mǝ yil desǝ wur kǝ paa yit fur mo, Mɓǝkǝ taji mo naa peeɓang mǝ pwoo ɗeret mǝ Kristi kas, ɗewur a ɗemǝndong kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Mbǝɗe baa muu satpwoo nǝ ngurum mo nkaa fwoshik fun kas, amma a pwoo nkaa Jesu Kristi, ɗi wur a Daa, kǝ mun shikáa fun bǝ mu ɗee a kǝrem fuu mo mbǝ sǝm kǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Naan wur kǝ ten sat nǝ, peeɓang nǝ put a nɗǝǝn peenkwoo, kǝ nǝ ɓangpee ɗi. A wur le kǝ nǝ ɓang pǝtuup fun mo, mbǝkǝ nǝ shin peeɓang ɗi mmun, kǝ mbǝkǝ mu man ɗeɗes Naan ɗi, nɗǝǝn yit Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Mun kǝ long ɗe mǝ Riin kǝ Naan nǝ, a nɗǝǝn Tuulwan. Shii kǝ mǝnǝ, a fwoshik fun mo, mbǝkǝ mo kám ɓal ɗeɗes desǝ nǝ ɗi, agaak nǝ, nǝ a mǝ Naan, kǝ baa nǝ a munu kas. ");
INSERT INTO sur_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Moo tǝreng mun koo a nkwoop ɗeɗangyi, jir kǝsǝ, bǝ baa mo mpyan mun kas. Moo wuk mun, jir kǝsǝ bǝ baa kǝǝrmuut yaa mun kas. ");
INSERT INTO sur_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Gurum mo lejeel mmun, jir kǝsǝ, bǝ pak gurum moo wal mmun. Moo hǝr mun car nyil, jir kǝsǝ, bǝ baa Mu murep kas. ");
INSERT INTO sur_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Koo a pǝrangyi, bǝ mun a nɗǝǝn jeel mǝ muut, kaa caan kǝ muut ɗe gyet Jesu cìn sǝ, mbǝkǝ gurum mo naa mǝse kǝ Jesu nǝ ɗi nɗǝǝn fwoshik fun mo. ");
INSERT INTO sur_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Kaaɗe mun ɗe mmeen sǝ, bǝ muu tong a tong mǝ muut mbǝ Jesu, mbǝkǝ mo kám mǝse kǝ Jesu nǝ ɗi, nɗǝǝn fwoshik fun, ɗe mo a mǝ muut sǝ. ");
INSERT INTO sur_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Ɗesǝ nǝ kám nǝ, muut nǝ nkaa cìn ɗak nɗǝǝn mun, amma seen nǝ nkaa cìn ɗak nɗǝǝn wun. ");
INSERT INTO sur_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Mo kǝ ten ran nɗǝǝn ɓǝǝt haal kǝ Naan nǝnee, <<wen shinzeen, a nǝ le ɗangɓe wuu satpwoo.>> A mbǝɗe mun mǝ shinzeen nNaan aakǝsǝ, a nǝ le ɗang mu satpwoo zak. ");
INSERT INTO sur_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Mu man nǝ, ngwe dǝ wur yool kǝ Daa Jesu a peemúut, nwur nyool kǝ mun ashak kǝ Jesu aasǝ zak, kǝ wur njì kǝ mun ashak kǝ wun ntoom wur zak. ");
INSERT INTO sur_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Mbii ɗesǝ mo jir a mbǝ wun, mbǝkǝ ɗeret kǝ Naan nǝ wul ɗi mɓut ngurum mo ɗes, kǝ mbǝkǝ gurum mo ɗes mo pǝlang Naan ɗi mbǝ ɗeɗes wur. ");
INSERT INTO sur_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Mɓemǝnǝ, bǝ baa nǝ waam mmun kas. Koo dǝ mun kǝ fwoshik ɗi nǝ a mu gurum, ɗe nǝ wam, amma jir kǝsǝ, bǝ koo puus ɗeɗangyi, bǝ moo le riin fun nǝ mo ɗee a ɗepwoo. ");
INSERT INTO sur_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Mbǝɗe rep jeel ɗe mu shwaa nǝ a mbǝ rep pee lee ɗak, nǝn nkǝlak kǝ ɗel dǝm, kǝ nǝn njì kǝ ɗeɗes ɗe nǝ dǝm ngaa-ngaa, ɗe nǝ met mu sat, nǝ met jir. ");
INSERT INTO sur_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Baa mu leyit fun nǝ mo nkaa mbii ɗe gurum moo naa nǝ yaksǝ kas, amma muu leyit fun nǝ mo a nkaa mbii dǝ baa mu mak naa nǝ yaksǝ sǝ kas. Mbǝɗe mbii ɗe gurum mo mak naa mo shi yit yaksǝ, ɓe a mo a mbii ɗe mo nkǝlak kǝ ɗel dǝm. Amma mbii ɗe baa gurum mo mak naa mo yaksǝ shi yit kas, a mo a mbii ɗe moo tong ɗi har ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Yaksǝ bǝ mu man nǝ, katɗang bǝ fwoshik fun ɗe mun kǝ mo nɗǝǝn yil desǝ, mo wam, bǝ Naan wur kǝ ɗak mee fwoshik fun ɗe mon ntong ɗe har ngaa-ngaa nɗǝǝn ɗengnaan. A Naan wur ɗak fwoshik mǝnǝ mo shikáa wur. ");
INSERT INTO sur_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Nɗǝǝn fwoshik fun, bǝ muu gwaar gwan, kǝ mu coor, mbǝkǝ Naan shin fwoshik fun ɗe mo a mǝ ɗengnaan sǝ ɗe mmun. ");
INSERT INTO sur_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Mbǝɗe katɗang Naan cin fwoshik fun mǝnǝ mo mmun, bǝ baa mo mmak kat mun ngum kas. ");
INSERT INTO sur_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Kaaɗe mu kutdi mu tong nɗǝǝn fwoshik fun ɗe nǝ. A mǝ yil nǝ, bǝ muu gwaar gwan mbǝ jeel ɗe mu shwaa. Baa a mbǝɗe nǝ, muu reɓet a ɓàkshak kǝ fwoshik fun ɗe mo a mǝ yil desǝ kas. Amma muu reɓet kǝ Naan shin fwoshik fun ɗe mo a mǝ ɗengnaan sǝ mmun. Ɓe fwoshik fun ɗe mo kǝ seen sǝ, mo nɗee ɗe a koppee kǝ fwoshik fun ɗe mo a mǝ muut yaksǝ. ");
INSERT INTO sur_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","A Naan wur ɗak mun, mbǝ cǝǝr ɗesǝ mo, kǝ wur kǝ ten shin Riin wur mmun, ɗe nǝ ɗee a ɓe naa man mǝ mbii ɗewur kǝ ɗak mo le mbǝ mun. ");
INSERT INTO sur_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Mbǝmǝnǝ, bǝ koo a pǝrangyi, bǝ mun kǝ shinzeen nɗǝǝn pǝtuup fun, kǝ mu man zak nǝ, kaaɗe mu kutdi nɗǝǝn fwoshik fun ɗe mǝ yil desǝ, bǝ baa mun ashak kǝ Daa kas. Mu jong kǝ wur. ");
INSERT INTO sur_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Muu tong nɗǝǝn yil desǝ nǝ a shi shinzeen, baa a shi mbii ɗe mu naa mo shi yit kas. ");
INSERT INTO sur_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Azeen-nzeen mun kǝ shinzeen nɗǝǝn pǝtuup fun, kǝ ɗyeen mmun mɓàkshak kǝ fwoshik desǝ nǝ mo, mbǝkǝ mu tong ɗe ashak kǝ Daa ntul. ");
INSERT INTO sur_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Mbǝmǝnǝ bǝ koo ɗe mun ɗi nɗǝǝn yil ɗesǝ, kǝ koo a nɗǝǝn yil ɗe nǝn ndung jì, bǝ ɗyen mmun kǝ mu cin a mbii ɗe mo ret nNaan nyit. ");
INSERT INTO sur_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Mbǝɗe tǝng, mun jir, mun nɗar ntoom kǝ mbii tong mǝ tokɗyeel kǝ Kristi, mbǝkǝ koo a weyi ɓe wur nlap kwat mǝ ɗak ɗe wur kǝcin mo, bǝ wur kutdi nɗǝǝn shin mǝ yil desǝ. Kyet kwat nǝ a ɗeret aa? Aa koo a ɗebish yi? ");
INSERT INTO sur_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","A mbǝɗe mu manshii mǝ kǝǝr Daa, a nǝ le ɗang mu gung mbǝ dul gurum mo jì pee Kristi ɗi. Nɗǝǝn tong fun, bǝ Naan wur man rǝret hakyeng, kǝ mu canciin nǝ, wun wu man mun akǝsǝ zak, nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Baa muu gung a mbǝkǝ mu waa mu baa mu sat mee langtǝng ɗe nkaa sun fun mo pee wun ɗi kas. Amma mu kám a ar nwun, mbǝkǝ wu cìn retnyit ɗe shi mun, kǝ mbǝkǝ wu katpee lappwoo ɗe nen ɗi moo canjoom a shi ɗeɗes fur mo. Baa a shi mǝse fur mo kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Mbǝɗe koo ɗe baa mun ɗe mɓut mǝse fun nǝ mo kas, bǝ mǝnǝ a mbǝ Naan, kǝ katɗang mun ɗi nɗǝǝn mǝse fun mo, bǝ mǝnǝ a mbǝ wun. ");
INSERT INTO sur_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Yaksǝ, bǝ wal kǝ Kristi nǝ se mulki nɗǝǝn pǝtuup fun mo mbǝ wun, kǝ mu man azeen nǝ, mee ngwe mǝndong wur kǝ muut mbǝ gurum mo jir. Mbǝmǝnǝ, bǝ gurum mo jir mo cam muut zak. ");
INSERT INTO sur_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Wur muut a mbǝ gurum mo jir, mbǝkǝ nen ɗe mo kǝ lap seen wur, bǝ taji mo waa baa tong ɗi a mukáa fur. Zak kas. Amma mo tong a mǝ ngwe ɗewur kǝ muut mbǝ mo, kǝ mo waa yool kǝ wu a peemúut mbǝ mo zak. ");
INSERT INTO sur_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Mbǝmǝnǝ, yaksǝ, bǝ baa mu kutdi mu naa tong kǝ gurum a shi yit ɗe mǝ yil desǝ kas. Ɗe mu naa Kristi a shi shin ɗe mǝ yil ɗesǝ, amma yaksǝ, bǝ baa mu kutdi mu naa wur a shi fwoshik ɗe mǝ yil sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Koo ngwe ɗeɗangyi ɗe wur tong nɗǝǝn Kristi, ɓe ngwe mǝnǝ kǝ ɗee a ɗepwoo. Mbǝɗe mǝse wur ɗesǝǝr mo kǝ ɗel dǝm jee, kǝ koo mii nǝ kǝ ɗee a ɗepwoo zak. ");
INSERT INTO sur_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Mbii desǝ mo jir, a cìn Naan, ɗe wur cǝǝr kǝ mun shaarlek wur mo, mbǝkǝ mu ɗee ɗi a shaar wur mo shi Kristi. Wur cin ɗak ɗesǝ mmun, mbǝkǝ mu cǝǝr kǝ gurum mo, ɗi mo a shaarlek wur mo, mbǝkǝ mo ɗee ɗi a shaar wur mo zak. ");
INSERT INTO sur_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","A pwoo ɗe mun nkaa sat nǝ desǝ nǝ, Naan wur nkaa le gurum ɗe mo nɗǝǝn yil nǝ, kǝ mo ɗee a shaar wur. Baa Naan wur tang shikbish kǝ gurum nǝ mo nkaa mo kas, kǝ wur kǝ lepwoo mu cǝǝr kǝ gurum ɗe mo a shaarlek wur mo, kǝ mo ɗee a shaar wur mo nsar fun zak. ");
INSERT INTO sur_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Mbǝmǝnǝ, bǝ yaksǝ mun a jeplep mǝ Kristi mo, ɗe Naan wur pǝrep gurum mo a shi mun. Mu ɗang pǝ wun a koppee kǝ Kristi, wu yit kǝ Naan wur cǝǝr kǝ wun, kǝ wu ɗee ɗi a shaar wur mo. ");
INSERT INTO sur_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Wur ɗe baa wur man cìn mee shikbish kas, bǝ Naan le wur mang shikbish fun mo, mbǝkǝ nɗǝǝn wur bǝ mu ɗee ɗi a nen ɗin ndǝre mo, nyit Naan. ");
INSERT INTO sur_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Kaaɗe mun mu cìn ɗak ashak kǝ Naan zak, bǝ mu ɗang pee wun, mbǝkǝ taji wu lap ɗeret kǝ Naan wu le nǝ a mbii ɗebuu kas. ");
INSERT INTO sur_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Wu kǝlǝng mbii ɗe Naan wur kǝ sat nǝnee, <<Kaaɗe pee mǝ cìn ɗeret nǝ wul, ɓǝ wen cìn ɗeret nwaa. Kaaɗe puus ɓam nǝ jì wul, ɓǝ wen ɓam waa zak.>> Azeen-nzeen wen sat nwun nǝ, cicinsǝ nǝ a pee mǝ lap ɗeret mǝ Naan! Kǝzak, cicinsǝ nǝ a puus mǝ kat ɓam pee Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Baa mu le mee mbii canshii mmee gurum kas, mbǝkǝ taji mo ɓees ɗak fun nǝ ɗi kas. ");
INSERT INTO sur_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Amma koo a nɗǝǝn ar ɗeɗangyi, bǝ muu kám ngurum mo azeen-nzeen nǝ, Mun a kǝrem mǝ Naan mo, kǝ muu kám nǝ, mun a kǝrem kǝ Naan mo shi gung kǝ shwaajeel ɗes, kǝ mwaan nɗǝǝn mbii lejeel mo. ");
INSERT INTO sur_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Muu shwaanas, kǝ mo naa mɓwoot mun, kǝ muu tong mɓut nenyool kǝ ɓǝlep mo, kǝ ɗak mo ɗes, kǝ tong shi gongpee, kǝ tong kǝ neen, kǝ ciin saam zak. ");
INSERT INTO sur_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Muu kám zeen fun shi mǝse ɗeret kǝ man, kǝ gung shi mǝse ɗe mǝ naajeel nɗǝǝn Riin Ɗeɓang, kǝ shi wal mu azeen-zeen zak, ");
INSERT INTO sur_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","kǝ shi pwoo ɗe mo azeen-nzeen, kǝ shiɓal kǝ Naan. Mun kǝ zeen nǝ, kaa leelek ɗin ndǝre mo sǝ, nsarse kǝ nsarkul fun mo. ");
INSERT INTO sur_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Gurum mo le mun a ɗeɗes, amma pak moo waa lejeel mmun zak. Pak gurum moo kwoop mun, ɗang pak moo waa ɓees mun zak. Moo le mun a kaa nenɗung mo sǝ, ɗang mun a nensat zeen mo. ");
INSERT INTO sur_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Gurum mo le mun a kaa baa mo man mun kas sǝ, ɗang mun a ɗe mǝ man pee mo. Mu ɗee kaa muu mumurep sǝ, ɗang mun ɗi kǝ seen. Mo nǝrem mun, jir kǝsǝ, bǝ baa mo twe mun kas. ");
INSERT INTO sur_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Mu ɗee kaa mun aa pǝtuup ɗeewat sǝ, ɗangɓe mun a mɓut nretnyit shidaar-shidaar. Mu ɗee kaa nenjeel mo sǝ, ɗang jir kǝsǝ, bǝ mu le kǝ gurum mo ɗes mo kat long. Mu ɗee kaa baa mun kǝ mee mbii kas sǝ, ɗang jir kǝsǝ, bǝ koo mbii ɗeɗangyi bǝ nǝ a munu. ");
INSERT INTO sur_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Wun nen Koronti mo, wu man nǝ, baa mu sok mee mbii nwun kas. Gyet muu satpwoo nwun agaak mbii ɗe mo nɗǝǝn pǝtuup fun jir. ");
INSERT INTO sur_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Baa gyet mu nook sat nwun mbii ɗe mo nɗǝǝn pǝtuup fun kas. Gyet a wun wu nook sat mmun mbii ɗe mo nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Wen ɗang pee wun kaa jep fen mo sǝ, mbǝkǝ wu woo mbii dǝ mo nɗǝǝn pǝtuup fuu mo mmun. ");
INSERT INTO sur_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Taji wu ɓàlsuk ashak kǝ nen ɗe baa mo shinzeen nNaan kas. Mbǝɗe a mii ɓal ɗak ɗeret kǝ ɗak ɗebish yii? Kǝ a mii ɓal peeɓang kǝ peenkwoo yii? ");
INSERT INTO sur_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Baa mee shaar ashak ɗe nnaar Kristi kǝ Gujwan kas. A mii ɓal ngushinzeen, kǝ ngwe ɗe baa wur shinzeen kas yi? ");
INSERT INTO sur_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","A mii ɓal Lu Naan ɗeɗes kǝ lu kùm yii? Pǝtuup fun mo a peeɗe Naan wur tong ɗi, Kaaɗe wur kǝ ten sat sǝ nǝnee, <<wen ntong ashak kǝ mo, kǝ wen mmwaan nnaar fu zak. Wen nɗee a Naan fu, kǝ mon nɗee a nen fen mo zak.>> ");
INSERT INTO sur_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Mbǝmǝnǝ bǝ wu put aku, <<mɓut nen ɗe baa mo shinzeen kas, kǝ wu ɓàkshak kǝ mo zak, Daa Naan wur sat akǝsǝ. Taji wu tung mee mbii ɗe nǝ a ɗerap kas, ɗangɓe wen nlap wun. ");
INSERT INTO sur_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Wen nɗee a puun fuu, kǝ wun nɗee a jep fen ɗemish mo, kǝ ɗe mat mo. A Daa ɗeɓal met jir, wur sat pwoo mǝnǝ.>> ");
INSERT INTO sur_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Shaar fen mo ɗe wen wal nwun, kaaɗe Naan wur kǝ ten tuweerpwoo mbii ɗesǝ mo mmun akǝsǝ, bǝ nǝ ret kǝ mu lesun fun mo ɗee a ɗeɓang, nɗǝǝn koo a mbii ɗebish ɗeɗangyi, ɗe nǝ tǝkook kǝ nan fun mo, kǝ riin fun mo zak. Nǝ ret kǝ mu ɗee a nen ɗeɓang mo rǝret nɗǝǝn shiimwaan fun mo, mbǝ shin ɗeɗes nNaan. ");
INSERT INTO sur_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Wu wang pǝtuup fuu mo mmun, mbǝɗe baa di mu cìn mee mbii ɗebish mmee gurum kas, kǝ baa mu tikook kǝ mee gurum kas zak. Baa di mu seen nkaa mee gurum kas. ");
INSERT INTO sur_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Baa wen sat desǝ nǝ a mbǝkǝ wen le wun ɗi a nenshikbish mo kas, ɗang wen satpwoo ɗesǝ nǝ a mbǝɗe di wen kǝ ten sat nwun nǝ, mu wal nwun zam. Kǝ koo ɗe a nɗǝǝn muut, kǝ koo ɗe mun ɗi kǝ seen, bǝ mun ɗi ashak vit nɗǝǝn pǝtuup fun mo. ");
INSERT INTO sur_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Wen shinzeen nwun azeen-nzeen, kǝ wen kǝ cìn roop ɗes a shi wun zak. Har wu fes wu caa pǝtuup fen nǝ rǝret hakyeng. Jir kǝ jeel ɗe muu shwaa nǝ, bǝ wen nkaa cìn retnyit ɗes zam. ");
INSERT INTO sur_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Kaaɗe gyet mu dǝm mu wul nyil mMasidoniya sǝ, ɓe baa gyet mu kat mee pee ɓwet sun kas. Gurum mo shin jeel mmun ɗes, koo a nɗǝǝn ar ɗeɗangyi. Gurum mo ɓǝlep kǝ mun, kǝ gyet nɗǝǝn pǝtuup fun mo, bǝ kǝǝrmuut nǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Ɗangnaan wur shin ɓal kǝ wur caa pǝtuup mu nen ɗe baa mo ɓal mputuup kas. Gyet wur shin ɓal pǝtuup fun mo shi jì kǝ Titus. ");
INSERT INTO sur_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Baa a jì kǝ Titus nǝ ɓejee ɗak kas, ɗang ashak kǝ ɗi gyet wu cìn caa pǝtuup wur, har wur sat mmun nǝ, wu coor mbǝ naa wen, kǝ wuu naajeel fen, kǝ nǝ, wun mɓwoon fen zak. Pwoo ɗesǝ nǝ mo sǝǝt le retnyit nwen ɗes hakyeng. ");
INSERT INTO sur_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Koo ɗe gyet wen wàt pǝtuup nwun shi ran ɗe wen ran nwun sǝ, ɓe baa gyet nǝ daampee nwen, mbǝɗe wen ran-ran nǝ nwun kas. Gyet yam ɓe nǝ wàt pǝtuup nwen, mbǝɗe gyet wen naa nǝ, ran nǝn wàt pǝtuup fuu mo zam. Koo ɗi gyet nǝ wàt pǝtuup nwen a mbǝ rep pee mo lee ɗak. ");
INSERT INTO sur_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ɗang yaksǝ wen kat retnyit. Baa nǝnee mbǝɗe a ran nǝ le pǝtuup fuu mo tikook kas, ɗang a mbǝkǝ wu tuwap ɗi, mbǝ mbii ɗe mo le kǝ pǝtuup fuu mo tikook. Daa Naan wur reɓet a kyeet kǝ tikook kǝ pǝtuup mǝnǝ, mbǝɗe nǝ nle kǝ wu tuwap. Mbǝmǝnǝ ɓe baa mu cìn a mee mbii ɗebish nwun kas. ");
INSERT INTO sur_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Mbǝɗe kyeet kǝ pǝtuup ɗewat ɗi a Naan le, nǝ kǝ jì kǝ tuwap, kǝ nǝ jì kǝ kat ɓam zak. Baa nǝ le kǝ gurum mak sat nǝnee, <<katɗang ɗi wen oo!>> Kas. Ɗang pǝtuup ɗewat mǝ yil ɗesǝ, mǝnǝ kǝ jì aa muut. ");
INSERT INTO sur_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Wu naa, mbii ɗe Naan wur kǝ cìn kǝ pǝtuup ɗewat nǝ, nǝ le kǝ wu ɗak mǝse fuu mo azeen-nzeen. Kǝ nǝ le kǝ wuu reɓet kám agaak nǝ, baa gyet wu man mee mbii ɗebish kas, har nǝ kǝ le kǝ wu kat canciin. Nǝ le kǝ wu katɓal, kǝ nǝ le kǝ wu kat gung nɗǝǝn kar fuu zak. Mɓut mbii ɗesǝ mo, bǝ koo a nɗǝǝn ar ɗeɗangyi, ɓe nǝ kám azeen-nzeen nǝnee, << wuu mwaan a nɗǝǝn ɗeret. ");
INSERT INTO sur_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Koo ɗe gyet wen kǝ ran-ran nwun, bǝ baa nǝ a mbǝ mee ngwe ɗe wur kǝ cìn shikbish kas. Kǝ baa nǝ a nkaa mee ngwe dǝ mo cìn ɗebish nwur kas. Ɗang wen ran-ran nǝ, a mbǝkǝ nǝ kám ɗi nwun agaak ntoom kǝ Naan, canciin fuu mbǝ mun. ");
INSERT INTO sur_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","A mbǝ mbii ɗesǝ mo, ɗangɓe gyet pǝtuup fun mo katɓal. Baa gyet nǝ gang a kwak fun mo ɓejee ɗak kas, ɗang mu kat retnyit ɗi kǝ ɗes, mbǝ retnyit kǝ Titus, mbǝɗe gyet wun jir wuu kaat wur shi retnyit. ");
INSERT INTO sur_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Gyet wen kǝ ten canjoom fuu nwur, ɓe baa gyet mee naashweep yaa wen mbǝmǝnǝ kas. Mbii ɗe mu sat mo nwun sǝ, mo azeen-nzeen. Canjoom fun ɗe mu sat nTitus nkaa wun, nǝ azeen a kǝ sǝ zak. ");
INSERT INTO sur_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Wur le pǝtuup wur nkaa wun jir met ɗeyam hakyeng. Kaaɗe wur yee nǝ, wun jir, wun a nen gyet ɗe wu lappwoo ɗewur sat mo nwun. Kǝ wu kaat wur shi retnyit, kǝ gyet wu cìn mbii ɗeret wur zak. ");
INSERT INTO sur_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Wen kat retnyit mbǝɗe wen mak kǝk kaa nkaa wun rǝret hakyeng. ");
INSERT INTO sur_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Ɗyemnaa mo, muu reɓet kǝ wu man pwoo nkaa ɗeret ɗe Naan wur shin nǝ Ekǝlisya ɗe mo nyil mMasidoniya. ");
INSERT INTO sur_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Koo ɗe ɗi mo kǝ cam mo shi jeel ɗenaat, kǝ mo nkaa shwaajeel mǝ mbii mo zak, bǝ jir kǝsǝ, retnyit fur nǝ ɗes. Ɓǝ nǝ le kǝ mo cìn mbii ɗeret mbǝɗe mo shin mbii fur mo shi zuum, koo ɗe baa mo kǝ mee mbii ɗes kas. ");
INSERT INTO sur_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Wen man azeen nǝ, mbii ɗe mo cin nǝ a nciit kǝ ɓal fur, har nǝ met ɓal fur, mbǝɗe mo shin nǝ a shi reɓet kǝ pǝtuup fur mo. ");
INSERT INTO sur_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Moo ɗang pǝ mun ɗes hakyeng nǝ, mu shin pee nɗun kǝ mo leɗun mɓut nen ɗe mon ncìn ɓam mbǝ nen Jesu mo sǝ. ");
INSERT INTO sur_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Har mo shin mbii mo ɗes met mbii ɗe mu lepan. Ɗang mo shee shin a pǝtuup fur mo nDaa, kǝ mun zak, nciit kǝ mbii ɗe Naan kǝ rǝɓet kǝ mo cìn. ");
INSERT INTO sur_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Kaaɗe mu naa nǝ ret, bǝ mu lep Titus dǝm pee wun ɗi, mbǝɗe ɗi a wur shee cìn ɗak ɗeret desǝ nǝ nɗǝǝn wun, ɓe nǝ ret kǝ a wur nsǝǝt sekyeen kǝ ɗak nǝ. ");
INSERT INTO sur_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Wun kǝ sekyeen nɗǝǝn koo a mbii ɗeɗangyii, har nɗǝǝn shinzeen, kǝ satpwoo, kǝ man, kǝ gung mbii mo ɗes, kǝ wal ɗi wun kǝ nǝ mbǝ mun. Nǝ ret kǝ wu sekyeen kǝ cìn ɗak ɗeret mǝ shin zuum shi pǝtuup mǝndong. ");
INSERT INTO sur_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Baa wen kǝ le a mee wàar pee wun ɗi kas, ɗang nǝ a mbǝ kám gung ɗe nwun, mbǝkǝ wen man ɗi azeen nǝ, wal ɗe wun kǝ nǝ, mbǝ ɓam niyee mo, nǝ azeen. ");
INSERT INTO sur_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Mbǝɗe wun kǝ man ɗeret mu Daa fun Jesu Kristi, koo ɗe gyet wur a ngulong, jir kǝsǝ, bǝ wur lekáa wur ɗee kaa ngujeel sǝ mbǝ wun. Mbǝkǝ nɗǝǝn jeel wur nǝ, ɓe wu ɗee ɗi a nenlong mo. ");
INSERT INTO sur_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","A pan mǝnǝ nkaa mbii nǝ nɗesǝ, nǝn nret kǝ yaksǝ bǝ wu sǝǝt koor mbii ɗe gyet wuu yaa cìn nǝ doontoom sǝ. Gyet a wun shee shin mbii, kǝ wun kǝ pǝtuup mu shin mbii hakyeng. ");
INSERT INTO sur_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Nǝ ret kǝ wu kyes koor ɗak nǝ shi reɓet kǝ pǝtuup fuu mo, nciit kǝ ɓal fuu, kaaɗe gyet wu shee cin nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Katɗang ɓe mee gurum kǝ pǝtuup ɗe mǝ shin mbiizuum, ɓe Naan nlap mbiizuum kǝ ngwe nǝ nciit kǝ mbii ɗe ngwe nǝ shin nNaan. Baa Naan wur ntang a mbii ɗi ngwe nǝ nnǝ kas. ");
INSERT INTO sur_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Baa wen sat pwoo mǝnǝ a mbǝkǝ pak gurum mo nook shin mbiizuum, mbǝkǝ nǝ toon ɗi wuwun kas. ");
INSERT INTO sur_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Ɗang a mbǝkǝ mo le mbii mo ɗee ɗin ndǝre, bǝ wu ɓam mo yaksǝ, shi mbii kǝkat fuu mo, mbǝɗe baa mo kǝ mee mbii kas. Mbǝkǝ katɗang parpuus ɗe wu táa njeel, ɓe mo ɓam wun ɗi zak. Ɗesinǝ nǝ a mbǝkǝ mo shwap mbii mo ɗi nciit-nciit. ");
INSERT INTO sur_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Kaaɗe mo kǝ ten ran nɗǝǝn ɓǝǝt haal kǝ Naan sǝ nǝnee, <<Ngwe ɗewur chak ɗes, ɓe baa nǝn njar ɗes kaa wur kas, kǝ ngwe ɗewur chak lee, ɓe baa nǝn njar kat kaa wur kas.>> ");
INSERT INTO sur_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","wen pǝlang Naan, ɗe wur lepan nɗǝǝn pǝtuup kǝ Titus, mbǝkǝ wur ɓam wun ɗi, kaaɗe wen kǝn cìn wun sǝ. ");
INSERT INTO sur_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Baa wur lap ii a mbǝ ɗang fun ɓejee ɗak kas, amma wur kǝ fes lepan wur, mbǝkǝ wur dǝm pee wun shi pan mukáa wur. ");
INSERT INTO sur_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Muu lep wur dǝm pee wun ɗi ashak kǝ ɗyemnǝǝn fun ɗi gurum moo fes shin ɗeɗes nwur, mbǝ satpwoo kǝ Naan nɗǝǝn Ekǝlisya mo jir. ");
INSERT INTO sur_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Baa a mǝnǝ ɓejee ɗak kas, amma Ekǝlisya mo bǝlep wur, mbǝkǝ wur dǝm ɗi ashak kǝ mun, mbǝ dǝm kǝ mbiizuum ɗe muu shin nǝ, mbǝ le Daa a ɗeɗes, kǝ kám agaak nǝ, mun kǝ pǝtuup ɗe nǝ a mǝ ɓam zak. ");
INSERT INTO sur_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Baa muu reɓet kǝ mee gurum fǝlǝp mun nkaa mbiizuum ɗesǝ, ɗe gurum moo shin nǝ shi pǝtuup mǝndong, ɗe mun nkaa shin nǝ sǝ kas. ");
INSERT INTO sur_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Mbii ɗe muu reɓet nɗesǝ, kǝ wu cìn mbii mo ɗi ndǝre-ndǝre, baa a ntoom kǝ Daa ɓejee ɗak kas, har kǝ ntoom kǝ gurum mo jir zak. ");
INSERT INTO sur_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Muu lep ɗyemnǝǝn fun ashak kǝ mo zak. Mun kǝ cam ɗyemnǝǝn fun wur yit mo ɗes, ɓe mǝ kat wur a nguɗak zam nɗǝǝn ar mo shinǝ-shinǝ. Yaksǝ bǝ wur cìn ɗak nǝ waa met ɗeyam zak. Wur kǝ cìn ɗak ɗeret nǝ ɗes mbǝ ɓam wun. ");
INSERT INTO sur_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Titus wur a shaarmwaan fen, ɗewur cìn ɗak ashak kǝ wen mbǝ ɓam wun zak. Mpee ɗyemnǝǝn fun desǝ mo, ɓe mo a nen ɗe Ekǝlisya mo lep mo, mbǝkǝ mo le sǝm kǝ Kristi ɗi a ɗeɗes. ");
INSERT INTO sur_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Mbǝmǝnǝ, ɓe wu kám wal fuu mmo, mbǝkǝ Ekǝlisya nǝ mo man ɗi azeen-nzeen nǝ, joom ɗe mu can nǝ mbǝ wun, nǝ a ndǝre azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Pwoo nkaa cin ɓam mbǝ nenseet nɗang Jesu mo, ɓe baa nǝ a tǝng kǝ wen ran mee pwoo nwun nkaa nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Mbǝɗe wen man sekyeen fuu, har wen kǝ canjoom shi wun ntoom kǝ nen Masidoniya mo. Wen sat mmo nǝ, gyet doontoom ɓe Ekǝlisya ɗin Akaya war kǝ ten ɗak set mbǝ cin ɓam. Rǝɓet fuu mbǝ shin mbiizuum ɗe wu shin nǝ ɓalkwak ngurum mo ɗes nɗǝǝn mo zam. ");
INSERT INTO sur_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Amma wen lep ɗyemnǝǝn fun ɗesǝ mo dǝm pee wun ɗi, mbǝkǝ taji canjoom ɗe mu sat shi wun, nkaa mbii ɗesǝ nǝ ɗee a mbii ɗebuu kas, ɗang mbǝkǝ wu tong ɗi shi ɗak suk, kǝ mbiizuum nǝ, kaaɗe gyet wen kǝn sat nwun nǝ, wu tong shi ɗak suk sǝ. ");
INSERT INTO sur_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Mbǝɗe katɗang pak nen Masidoniya nǝ mo yool jì ashak kǝ wen, ɗangɓe mo jì kat baa wuu ɗak suk kas, bǝ naashweep nyaa mun, kǝ nǝn nsǝǝt yaa wun met nwen zak, mbǝɗe muu shinzeen nwun. ");
INSERT INTO sur_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Nǝ akǝsǝ ɓe wen naa nǝ, nǝ ret kǝ wen ɗang ɗyemnǝǝn fun ɗesǝ mo, mbǝkǝ mo shee dǝm pee wun ɗi nwen atǝleng, mbǝkǝ mo cak mbiizuum ɗe gyet wuu tuweer nǝ, wun nshin nǝ ɗi. Katbaa wen kǝn dǝm wul pee wun ɗi, ɓe mo kǝ ten chak mbiizuum nǝ mo. Ɓe nǝ kám nǝ, wu shin mbiizuum nǝ a shi reɓet kǝ pǝtuup fuu mo, baa a mee gurum le tǝng nwun kas. ");
INSERT INTO sur_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Taji wu munsuk kas nǝ, ngwe ɗewur kop cirem lee nɗǝǝn maar wur, ɓe wur nɗiip ɗeɓen nǝ a lee ɗak. Ngwe ɗewur kop cirem ɗes, bǝ wur nɗiip ɗeɓen nǝ ɗes akǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Koo weyi ɓe wur cin mbii ɗewur kǝ pan mputuup mbǝ shin nǝ, baa a shi pǝtuup vǝl-vǝl kas, kǝ baa a gurum mo le tǝng nwur kas. Mbǝɗe Naan wur kǝ reɓet a ngwe ɗewur shin mbiizuum, a shi retnyit nɗǝǝn pǝtuup wur. ");
INSERT INTO sur_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Naan wur kǝ ɓal ɗe wur nshin mbii mo nwun ɗes met mbii ɗe wuu reɓet mo. Mbǝkǝ koo a pǝrangyi, ɓe wu kat mbii ɗe wuu reɓet mo ɗi mbǝ suk fuu mo, kǝ mbǝkǝ wu katpee shin mbiizuum ɗi shi pǝtuup mǝndong mbǝ ɗak ɗeret mo jir. ");
INSERT INTO sur_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Kaaɗe mo kǝ ran nɗǝǝn ɓǝǝt haal kǝ Naan sǝ nǝnee, <<Wur shin mbii nenjeel mo shi zuum ɗes, kǝ shi pǝtuup mǝndong, Ɗeret wur nǝn ntong ɗe har ngaa-ngaa.>> ");
INSERT INTO sur_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","A Naan kǝ shin cirem ngumaar, kǝ a wur shin mbiise mu se zak. A wur nshin cirem nwun wu kop, kǝ a wur nle kǝ nǝ kàa wurang. Wur nle ɗeret nkaa ɗak fuu ɗin ndǝre, kǝ nǝ ɗes ɗi hakyeng. ");
INSERT INTO sur_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Wur nle kǝ wu ɗee a nenlong mo koo a nɗǝǝn ar ɗeɗangyi, mɓekǝ wu naa nshin mbiizuum ɗi shi pǝtuup mǝndong. Mbiizuum ɗe wun nshin nǝ, nǝ nɗee ngurum mo a mbii pǝlang pee Naan. ");
INSERT INTO sur_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Mbǝɗe ɗak fuu ɗeret ɗesǝ nǝ, baa nǝ ɓam a nen Naan mo ɓejee ɗak kas, ɗang nǝ waa sǝǝt le kǝ gurum mo pǝlang Naan ɗes zam. ");
INSERT INTO sur_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Ɗak fuu ɗeret desǝ nǝ kám nǝ, shinzeen fuu nǝ ɗar ɓalɓal hakyeng. Nǝn nle kǝ gurum mo le Naan a ɗeɗes, mbǝ mbiizuum ɗe wu shin mo ashak kǝ koor gurum nǝ mo shi pǝtuup mǝndong. Ɓe nǝ kám agaak nǝ, wuu lappwoo ɗeret mu Kristi nǝ azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","A mbǝ wal ɗe gurum mo kǝ nǝ mbǝ wun, ɓe mo ncìn ɗangnaan (leshap kǝ Naan) mbǝ wun, Mbǝɗe mo man nǝ, Naan wur kǝcin ɗeret nwun ɗes zam. ");
INSERT INTO sur_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Wu yit kǝ mu pǝlang Naan mbǝ zuum ɗe wur shin mmun. Zuum ɗi nǝ met mɓal mu sat. ");
INSERT INTO sur_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Wen Pool shikáa fen, wen ɗang pee wun, mbǝ mǝse mu pǝɗok kǝ ɗeret mǝ Kristi. Wen ɗe moo sat nǝ, wen a nguɗokpwoo tǝktǝk, katɗang wen ashak kǝ wun, ɗang Nnee wen kǝn sat mbii mo nwun agaak, katɗang baa wen ashak kǝ wun kas. ");
INSERT INTO sur_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Wen ɗang pee wun, mbǝkǝ taji wu le tǝng nwen satpwoo nwun shiɓal kas, katɗang wen jì pee wun ɗi. Mbǝɗe wen man azeen nǝ, wen mak satpwoo shiɓal nen ɗe moo sat nnǝ, mbii ɗe muu cìn sǝ ɓe nǝ a ɗak mǝ yil ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Koo ɗe muu tong a nɗǝǝn yil nǝ, ɓe mbii ɗe mun nkaa cìn lek mbǝ nǝ, baa nǝ a mǝ yil ɗesǝ kas. ");
INSERT INTO sur_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Leelek ɗe muu cìn lek ɗishik, baa nǝ a mǝ yil desǝ kas. Ɗang leelek fun nǝ a ɓal mǝ Naan, ɗe nǝn mmak shirip kok ɗeɓal mo. ");
INSERT INTO sur_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","Muu shirip pwoo kǝ nen ɗe moo jì kǝ mbii langkáa nkaa man Naan, kǝzak, muu shirip koo a kok mǝ roop ɗeɗangyi ɗe nǝ daam man Naan ngurum mo. Kǝ muu le kǝ koo a pan kǝ weyi, ɓe nǝ cìn ɗyen kǝ Kristi ɗi zak. ");
INSERT INTO sur_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Aɓwoon ɗe wun nkám agaak azeen-nzeen nǝ, wuu kǝlǝng pwoo fun, bǝ mun ɗak sun fun rǝret mbǝ kar nencii kǝlǝngpee mo. ");
INSERT INTO sur_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","A mii le ɗang wuu leyit fuu mo nkaa mbii dǝ mo aɓwoon yi? Katɗang mee gurum kǝ leshin nnǝ, wuɗin a mǝ Kristi, ɓe nǝ ret kǝ wur pan rǝret, kǝ wur man nnǝ mun a mǝ Kristi zak. ");
INSERT INTO sur_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Mbǝɗe koo dǝ wen canjoom ɗes shi ɓal ɗe Daa wur shin mmun, ɓe nǝ a mbǝkǝ mu ɗak wun ɗi, baa a mbǝkǝ mu shirip wun ɗi kas. Baa mee naashweep yaa wen kas. ");
INSERT INTO sur_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Taji wu pan nǝ, wen kǝn gung a mbǝkǝ wen lekǝǝrmuut ɗi nwun shi ran fen nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Mbǝɗe pak gurum moo sat nǝ, mbii ɗe wur ran nɗǝǝn ran wur nǝ mo toon, kǝ mo ɓal zam, amma katɗang gurum naa wur nyit, bǝ baa shin wur nǝ kǝ mee ɓal kas. Pwoo ɗe wur sat nǝ, ɓe baa nǝ ke koop nǝ kas. ");
INSERT INTO sur_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Nǝ ret kǝ nen sat pwoo mǝnǝ mo man nǝ, mbii ɗe muu sat nɗǝǝn ran, bǝ baa nǝ ɗyik kǝ mbii ɗe muu sat nwun nyit kǝ yit kas, katɗang mukaat ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Baa mu mak lekáa fun, koo mu kámkáa fun mo nciit kǝ nen ɗe moo canjoom a shi sut fur mo kas. Mbǝɗe moo kám sut fur mo kǝ shak, kǝ moo camsut fur kǝ shak zak. Nen mǝnǝ mo a mwen mo. ");
INSERT INTO sur_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Baa mun ncanjoom ɗel peeɗe nǝ ret kǝ mu ɗar ɗi kas. Amma mu ɗar a nkaa pee ɗak ɗe Naan wur kǝ can nǝ mmun, desǝ nǝ ɓal kǝ ɗak fun nnaar fu. ");
INSERT INTO sur_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Wun a nɗǝǝn pee ɗak dǝ Naan wur kǝ can mun, akǝsǝ bǝ baa di mu canjoom mbǝ ɗak fun ɗik kas, kaaɗe gyet mu dǝm kǝ pwoo mǝ Kristi nǝ nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Baa canjoom fun nǝ ɗel met mbii dǝ nǝ ret kas, kǝ baa nǝ tung ɗak ke mee gurum mo kas. Amma mu canciin nǝ, a shinzeen fuu nǝ ɓul hakyeng, ɓe ɗak fun nɗǝǝn wun, nǝn mɓul ɗes hakyeng zak. ");
INSERT INTO sur_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Mbǝkǝ mu katpee satpwoo kǝ Naan ɗi nɗǝǝn yil ɗe mo a kyeen fuu. Baa mu canjoom a shi peeɗe mee gurum kǝ cam cìn ɗak ɗi kas. ");
INSERT INTO sur_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Amma kaaɗe moo kǝ ran nɗǝǝn ɓǝǝt haal kǝ Naan sǝ nǝnee, <<Jir ngwe ɗe wur canjoom, bǝ nǝ ret kǝ wur canjoom nǝ a shi mbii ɗe Daa wur kǝ cìn.>> ");
INSERT INTO sur_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Mbǝɗe baa Naan wur kǝ reɓet ngwe ɗe wur ke kwoop a shin kas, amma a ngwe ɗe Daa wur kǝ kwoop ɓejee. ");
INSERT INTO sur_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Wen canciin nǝ, wu ngung kǝ wen mbǝ rep mwen fen sǝ. Kussuk wu gung kǝ wen! ");
INSERT INTO sur_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Wen kǝn cìn zuur nkaa wun mbǝ Naan. Wun a kaa reep nuk ɗe baa war kǝ man mish kas. Wen kǝn tuweerpwoo mbǝ shin wun nɗyik, kaa matpoo sǝ pee mish war ɗe, a Kristi wur a mish fuu nǝ. ");
INSERT INTO sur_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Amma wen kǝn kǝǝr, taji nǝ yool ɗee a kaa gyet nwoo gwam Iif shi seen wur ɗe mu ɗung sǝ kas. Taji mo yool gwam wun, kǝ mo mer kǝ pan fuu mo nkaa wal ɗeret, ɗe wun kǝ nǝ mbǝ Kristi kas. ");
INSERT INTO sur_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","A mii le ɗang katɗang mee gurum jì satpwoo nkaa mee Jesu ɗe ɗyík kǝ pwoo ɗe mun mu sat nǝ nwun bǝ wuu kǝlǝng pwoo mǝnǝ yi? Wu pan nǝ riin mǝnǝ ɗyík kǝ Riin Naan ɗe wuu kat nǝ yi? Kǝ wu pan nǝ, mee pwoo Naan nǝ ɗe ɗyik waa met pwoo Naan ɗe wuu lap nǝ yi? ");
INSERT INTO sur_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Wen man azeen nǝ, baa wen a ɗekat met jir nɗǝǝn jeplep nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Meeɓe, baa wen man satpwoo rǝret kas, amma wen man satpwoo ɗeret nǝ. Muu kám man nǝ nwun agaak koo a pǝrangyi mɓut mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Tan, gyet wen cìn a mbii ɗebish, mbǝɗe gyet wen sham kǝ káa fen, mbǝkǝ Naan wur ɗiyeep wun ɗi kaaɗe wen satpwoo kǝ Naan nǝ nwun shi zuum sǝ wa? ");
INSERT INTO sur_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Wen lap ɓam pǝ pak Ekǝlisya mo, mbǝkǝ wen cìn ɗak ɗi nnaar fuu. Wen mak sat nǝ, gyet wen ghǝr a long fur mo, mbǝkǝ wen ɓam wun ɗi. ");
INSERT INTO sur_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Kaaɗe gyet wen ɗe ashak kǝ wun, bǝ baa gyet wen kǝ mee mbii kas, kǝzak, baa gyet wen lejeel mmee gurum kas. Mbǝɗe ɗyemnǝǝn fun ɗe mo tong mMasidoniya jì ɗi, a mo jì shin wen mbii ɗe wen kǝn reɓet mo. A mbǝmǝnǝ, ɗangɓe koo a nɗǝǝn ar ɗeɗangyi, ɓe baa wen le mee jeel wun kas. Kaaɗe baa gyet wen lejeel wun kas sǝ. ");
INSERT INTO sur_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Mbǝɗe wen man nǝ, pwoo ɗe wen kǝn sat nǝ a pwoo mǝ Kristi azeen, ɓe baa mee ngwe mak cíi canjoom nwen nɗǝǝn yil Akaya kas. ");
INSERT INTO sur_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","A mii le ɗang wen sat kǝsǝ yi? A mbǝɗe baa wen wal nwun kas aa? Naan wur man nǝ, wen wal nwun zam. ");
INSERT INTO sur_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Ɗak ɗe wen nkaa cìn nǝ, ɓe wen sat a ncìn a nǝ, mbǝkǝ wen shootpwoo mu canjoom ɗi jeplep ɗe moo sat nǝ, ɗak fur nǝ a nciit kǝ munu. ");
INSERT INTO sur_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Kaan kǝ nen mǝnǝ mo a jeplep mu ɗung mo. Moo cìn a ɗak ɗe mu numpee mo. Moo lekáa fur kaa mo a jeplep mu Kristi mo sǝ, ɗang baa mo a jeplep Kristi kas. ");
INSERT INTO sur_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Baa nǝ ɗee a mbii aapwoo kas, mbǝɗe koo a Gujwan shikáa wur, bǝ wur leshin kaa wur a ngulep mu peeɓang sǝ. ");
INSERT INTO sur_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Mbǝmǝnǝ ɓe baa nǝ ɗee a mbii aapwoo kas, katɗang bǝ kǝrem mu Gujwan mo lesut fur, kaa mo a nen cìn ɗak ɗeret mo sǝ zak. A peekyes nǝ, ɓe mon nlap kwat fur mo nciit kǝ ɗak fur mo zak. ");
INSERT INTO sur_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Wen kǝn baa sat ɗi zak nǝ, taji mee gurum pan nǝ, wen a mwen kas. Amma katɗang wu pan nǝ, wen a mwen, ɓe wu lap wen ɗesǝ kaa mwen nǝ sǝ, mbǝkǝ wen kat pee can rep joom ɗi lee. ");
INSERT INTO sur_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Pwoo ɗe wen sat sǝ, ɓe baa wen sat a mee pwoo ɗe Daa wur lep wen kas, amma wen kǝn satpwoo nǝ a kaa mwen sǝ, wen kǝn sat pwoo mǝnǝ a tyap. ");
INSERT INTO sur_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Kaaɗe gurum mo ɗes moo can a joom ɗe mu yil ɗesǝ ɓejee ɗak sǝ, ɓe wen ncanjoom nǝ akǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Wun nen ɗe wu seen ɓe wu gung kǝ nenmwen mo shi retnyit. ");
INSERT INTO sur_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Mbǝɗe katɗang, ɓe mee gurum le wun kaa kǝrem mo sǝ, koo wur ghǝǝr wun, koo wur se lǝɓet nkaa wun, kǝ koo wur kám a ɓal mu tuur nwun, kǝ koo wur nǝnas wun, jir kǝsǝ ɓe wuu gung kǝ ngwe mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","Nǝ shweep wen mbǝ lap ii, nǝ gyet mun kǝ ɓal mbǝ cìn mbii ɗesǝ mo kas, amma katɗang mee gurum kǝ canjoom nkaa mee mbii, ɓe wen kǝn satpwoo nǝ a kaa mwen sǝ. Wen ncanjoom akǝsǝ zak. ");
INSERT INTO sur_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Katɗang ɓǝ, mo a nen Hiburu mo, bǝ wen a ngu Hiburu zak. Katɗang ɓe, mo a nen Izrel mo, ɓe wen a ngu Izrel zak. Katɗang ɓe mo a ɗang kǝ Abraham, ɓe wen a ɗang kǝ Abraham zak. ");
INSERT INTO sur_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Katɗang ɓe mo a kǝrem mu Kristi mo, ɓe wen a kǝrem mu Kristi zak. Wen satpwoo nǝ a kaa ngutar sǝ! Mbǝɗe wen cìn ɗak ɗe nǝ ɗes met mumo nǝ. Mo kǝ ɓwoot wen le nlushoot, kǝ wen shwaanas met mǝ sat zak. Wen kǝn shwaajeel mo shinǝ-shinǝ har kus kǝ muut zak. ");
INSERT INTO sur_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Gyet yit paat, ɓe nen Yahudi mo fwo ngwoor nwen laarkun baapwoofeer. ");
INSERT INTO sur_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Nennan-nan mu Rom mo sǝrem wen shi gwoor yitkun. Nen Yahudi mo car wen shi nding yit mǝndong, mbǝkǝ mo tu wen ɗi. Yitkun ɓe tii am, nǝ taa pyan kǝ mun. Wen kǝn cam teer kǝ wet nkaa am bahar. ");
INSERT INTO sur_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Shidaar-shidaar bǝ wen a ar mwaan mo ɗes, kǝ nwen kǝn naa muut shi yit fen mɓut ndung mo. Wen kǝn naa muut nsar kǝ nenwat mo, kǝ nwen naa muut nsar kǝ ɗang fun nǝ Yahudi mo zak. Wen kǝ naa muut nsar kǝ nenkum mo. Wen kǝn naa muut nɗǝǝn yilkaam mo, kǝzak, wen kǝn naa muut a naaryil mo. Wen kǝ naa muut nkaa am bahar mo. Wen kǝn naa muut nsar kǝ ɗyemnǝǝn ɗe mu ɗung mo. ");
INSERT INTO sur_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Wen kǝn shwaaɗak mo, kǝ wen kǝn shwaajeel mo, kǝn nnaa nteer mmeen, kǝ wen kǝ shwaaneen zak, kǝ neen am tu wen zak. Yit mo ɗes baa wen kat mee mbiise kas. Wen kǝn shwaakut, mbǝ ciin mbiisǝp, ");
INSERT INTO sur_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","kǝ pak mbii mo ɗes ɗe kǝzak. Mbii ɗe mo daampee nwen, koo puus ɗeɗangyi, nǝ a mbǝɗe wen kǝ toon mǝ tap kǝ Ekǝlisya mo jir zak. ");
INSERT INTO sur_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Katɗang baa mee ngwe katɓal kas, ɓe nǝ le kǝ baa wen katɓal kas zak. Katɗang mee ngwe taa pal nɗǝǝn shikbish, ɓe nǝ shwal nwen zam. ");
INSERT INTO sur_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Katɗang bǝ nǝ a tǝng kǝ wen canjoom, ɓe wen canjoom nǝ a nkaa mbii ɗe nǝn nkám agaak nǝ baa wen kǝ ɓal kas, ");
INSERT INTO sur_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Naan puun kǝ Daa Jesu ɗe sǝm wur nǝ kat ɗeret har ngaa-ngaa. Wur man azeen-nzeen nǝ, baa wen kǝn sat a ɗung kas. ");
INSERT INTO sur_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Nɗǝǝn yil nDamaskus, ɓe gofna ɗewur ndir kǝ mishkoom Aritas wur shootpwoo sheep pǝbong ɗin nDamaskus mo, mbǝkǝ mo yaa wen ɗi. ");
INSERT INTO sur_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Mo le wen sham nɗǝǝn kǝci ɗeɗes mmee fung mu fwang mu yilkaam nǝ, har wen put nkoom nsar wur. ");
INSERT INTO sur_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Wen ncanjoom a tǝng, koo ɗe baa wen kat mee lǝɓet nɗǝǝn nǝ kas. Amma yaksǝ ɓe wen nsekyeen kǝ satpwoo nkaa suun mo, kǝ mbii ɗe Daa wur woo mo nwen. ");
INSERT INTO sur_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Wen man mee gurum nɗǝǝn Kristi ɗe gyet Naan mang wur kàa kǝ wur nɗǝǝn ɗengnaan ɗekun. Nǝ wul a ɓit mo kaapaat baafeer yaksǝ. Kyet, gyet Naan kàa kǝ wur a nɗǝǝn nan mu yil ɗesǝ aa? Ɓe baa wen man kas, amma Naan man. ");
INSERT INTO sur_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Wen man nǝ, mo mang gwar nǝ kàa kǝ wur a mparadayis. (Shii kǝ mǝnǝ a peeɗe Naan ɗi). Kyet a shi nan mu yil ɗesǝ aa? Koo baa a shi fwoshik mu yil ɗesǝ kas aa? Ɓe baa wen man kas, amma Naan wur man. ");
INSERT INTO sur_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","Wur kǝlǝng mbii mo, ɗe baa mon mmak sat mo shi pwoo kas, kǝ mbii ɗe baa gurum mo mak sat shi lǝpwoo kas zak. ");
INSERT INTO sur_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Wen kǝn canjoom a shi gwar ɗesǝ. Baa wen kǝn canjoom a shikáa fen kas. Amma wen kǝn kám a ciin ɓal fen agaak. ");
INSERT INTO sur_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Koo ɗe wen reɓet canjoom nǝ, ɓe baa wen ɗee a mwen kas, mbǝɗe wen kǝn sat azeen. Amma baa wen canjoom kas, mbǝkǝ taji mee gurum lepan nkaa wen, waa met mbii ɗewur naa wen kǝn cìn mo, kǝ mbii ɗewur kǝlǝng kǝ pwoo fen kas. ");
INSERT INTO sur_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Mbǝkǝ taji wen ɗiyeep káa fen mbǝ suun ɗeɗes ɗesǝ ɗi Naan kǝ kám mo nwen kas. Amma mo le mee ghǝr nɗǝǝn fwoshik fen, ɗe nǝ ɗee a mee shwal pee wen ɗi, ngulep kǝ Gujwan wur daampee nwen, mbǝkǝ taji wen canjoom kǝ fwoshik fen kas. ");
INSERT INTO sur_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Wen kǝn ɗang pee Daa yit kun, mbǝkǝ wur shang mbii ɗesǝ nǝ baa kǝ nǝ aku. ");
INSERT INTO sur_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Amma Daa wur sat nwen nǝnee, <<Ɗeret fen nǝ mak waa. Mbǝɗe a nɗǝǝn ciin ɓal mu gurum, ɗangɓe mon naa gam kǝ ɓal fen.>> Mbǝmǝnǝ ɓe wen sǝǝt canjoom nɗǝǝn ciin ɓal fen nǝ. Mbǝkǝ ɓal mu Kristi nǝ tong ɗi nɗǝǝn wen. ");
INSERT INTO sur_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Aasǝ ɓe wen kǝn kat retnyit nɗǝǝn sǝm mu Kristi, mbǝ ciin ɓal fen nǝ, kǝ fǝlǝp ɗe moo cìn nwen, kǝ mbii daampee mo, kǝ jeel mo, kǝ luk mo shinǝ-shinǝ, mbǝ Kristi. Mbǝɗe katɗang baa wen kǝ ɓal kas, ɓe wur shínɓal nwen. ");
INSERT INTO sur_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Wen kǝn lesen ɗee a kaa mwen sǝ, amma a wun wu le kǝ wen ɗee a mwen nǝ. Gyet nǝ ret kǝ a wun, wun nkwoop wen, mbǝɗe baa wen a ɗekat met jir nɗǝǝn jeplep nǝ mo kas, koo ɗe baa wen a mee mbii kas. ");
INSERT INTO sur_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Naan cìn mbii lukshik kǝ mbii aapwoo mo, kǝ ɗak ɗenan-nan mo shi wen, kaaɗe wen gung mbǝ cìn ɗak fen mo shidaar-shidaar. Ɗak mu mbii aapwoo ɗe mo kám agaak nǝ, wen a ngulep azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Wen kǝn cìn a mii, koor Ekǝlisya nǝ mo yii? Ɗi baa wen kǝn cìn mǝnǝ nwun kas yi? Aa koo a mbǝɗe baa gyet wen le mee toon nwun kas aa? Ɓe wu fwo ɗi nwen. ");
INSERT INTO sur_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Yaksǝ ɓe wen kǝn ɗak sen mbǝ dǝm pee wun ɗi, ɓe a dǝm ɗekun pee wun ɗi mmǝnǝ. Baa wen le kǝ wu kwat wen kas, mbǝɗe baa wen kǝn tang a mee mbii pee wun ɗi kas, amma wen kǝn tang a wuwun. Mbǝɗe baa a jep mon ntang mbii le mbǝ puun fur mo kas. Amma puun nǝ mon ntang mbii le mbǝ jep fur mo. ");
INSERT INTO sur_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Nǝ nret nwen nyit zam, mbǝkǝ wen cin mbii ɗe wen kǝ nǝ jir, kǝ sen fen zak, mbǝ ɓam wun. Wen wal nwun ɗes, ɗangɓe wun wu wal nwen a lee ɗak aa? ");
INSERT INTO sur_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Wu man azeen nǝ, baa gyet wen lejeel wun kas. Amma mee gurum sat nǝ gyet wen sǝseen nkaa wun, kǝ wen le cip mu gwampee wun zak. ");
INSERT INTO sur_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Kyet wen kǝn cam seen a wun shi gwampee mɓut nen dǝ wen lep mo dǝm pee wun ɗi wa? ");
INSERT INTO sur_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Gyet wen ɗang Titus, kǝ wur dǝm pee wun ɗi, ashak kǝ ɗyemnǝǝn fun ɗesǝ. Kyet, gyet Titus wur lap mee mbii pee wun ɗi wa? Baa a Riin Naan ɗe mǝnɗong wur ɓwet mun weet kas aa? Baa mun weet muu cìn ɗak nǝ a ar ɗe mǝnɗong kas aa? ");
INSERT INTO sur_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Tan, peeɗi ɗi ɓe wuu pan nǝ, mu jì aa mee mbii langkáa mbǝ sun fun pee wun ɗi wa? Hai. Muu sat a pwoo mu Kristi ntoom Naan. Shaar fen mo, mbii ɗe muu cìn mo jir, ɓe muu cìn mo a mbǝ ɓam wun. ");
INSERT INTO sur_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Mbǝɗe wen kǝǝr nǝ, meeɓe, katɗang wen dǝm pee wun ɗi, ɓe wen nkat mǝse fuu nǝ ɗyik kǝ mǝse dǝ ɗyeen nwen nkat wun kǝ nǝ. Kǝzak, wun nnaa mǝse mǝnǝ nǝ ɗyík, kǝ mǝse dǝ ɗyeen wun naa wen kǝ nǝ. Meeɓe wen kat ɓǝlep, kǝ zuur, kǝ tuup, kǝ walnkáa, kǝ ɗung kǝ pwoo nɗom ndom, kǝ ɗyeepkáa, kǝ ciin tongryang nnaar fuu. ");
INSERT INTO sur_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Wen kǝǝr nǝ, katɗang wen waa ndǝm pee wun ɗi, ɓe baa Naan fen wur nsham kǝ wen ntoom fuu kas. Katɗang Naan sham kǝ wen ntoom fuu, bǝ wen nkat pǝtuup ɗewat, kǝ gurum mo ɗes nɗǝǝn wun. Nen dǝ gyet mo kǝ cìn shikbish yam, ɗangɓe baa mo kǝ tuwap kas mbǝ mǝse ɗebish, kaa cìn ngaa, kǝ koor mu cìn mbii ɗebish mo zak. ");
INSERT INTO sur_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Wen kǝn dǝm pee wun ɗi, a ɗekun nɗesǝ, <<Mbǝkǝ mo man zeen kǝ meepwoo azeen-nzeen, bǝ nǝ a tǝng kǝ mo kat langtǝng mo vǝl koo kun>> kaaɗe mo ran nɗeen bǝǝt haal. ");
INSERT INTO sur_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Wen kǝn gwak a nen dǝ gyet mo cìn shikbish yam, kǝ koor nǝ mo jir zak. Gyet wen kǝn gwak mo, ɓe baa wen ɗi ashak kǝ mo kas. Wen gwak wun kaaɗe gyet wen gwak wun nji fen ɗevǝl pee wun ɗi sǝ, nǝ, katɗang wen mbaajì, ɓe wen nshin kar nen ɗe ɗi mo cìn shikbish sǝ, kǝ koor nǝ mo. ");
INSERT INTO sur_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","Katɗang ɓe ɗyeen nwun kǝ wu man azeen-nzeen nǝ, wen kǝn satpwoo ɗesǝ mo a shi ɓal mu Kristi, ɓe nǝ ret kǝ wu man nǝ Kristi wur kǝ ɓal ɗes. A wur nkar wun, kǝ a wur kám ɓal wur nɗǝǝn wun. ");
INSERT INTO sur_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Mbǝɗe koo ɗe gyet mo pwas wur nkaa shyeep, ɓe gyet a wur shin shin nǝ mo pwas nkaa shyeep nǝ, ɓe jir kǝsǝ, ɓe wur ɗi kǝ seen shi iiko mu Naan. Mun a nen ɗe baa mun kǝ ɓal kas, ɗang nɗǝǝn iiko mu Naan shi Kristi, ɓe mun ɗi kǝ seen, mbǝkǝ mu ɓam wun ɗi. ");
INSERT INTO sur_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Wu camkáa fuu mo, kǝ wu man ɗi rǝret nǝ, kyet wuu mwaan a nɗǝǝn shinzeen fuu nǝ mo wa? Wu camkáa fuu mo rǝret. Baa wu man nǝ, Jesu Kristi wur kǝ tong a nɗǝǝn wun kas aa? See koo katɗang wuu taa wu pal kǝnding-nding. ");
INSERT INTO sur_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Muu reɓet kǝ wu man nǝ, baa mun mu taa mu kat kas. ");
INSERT INTO sur_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Muu ɗang pǝ Naan kǝ taji wu cìn mee mbii ɗebish kas. Muu ɗang pǝ Naan, baa a mbǝkǝ nǝ cám ɗi agaak nǝ, mun kǝ se koorong nkaa cam nǝ kas, amma see a mbǝkǝ wun wu cìn mbii ɗeret mo ɗi, koo dǝ wu naa kaa mun muu taa mu kǝkat sǝ. ");
INSERT INTO sur_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Mbǝɗe baa nǝ mmak cìn kǝ mu cìn mee mbii nkaa zeen nǝ kas, amma see muu sat azeen nǝ. ");
INSERT INTO sur_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Muu kat retnyit, katɗang baa mun kǝ ɓal kas, kǝ wun ɗi kǝ ɓal. Ɗangnaan ɗe muu cìn nǝ a mbǝkǝ wu ɗee ɗi a ɗegǝgam. ");
INSERT INTO sur_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Mbǝmǝnǝ, bǝ wen ran-ran ɗesǝ dǝm wun bǝ baa wen ɗi ashak kǝ wun kas, a shiɓal dǝ Naan wur shin nǝ nwen mbǝ ɗyik wun, baa nǝ a mbǝ shirip wun kas. ");
INSERT INTO sur_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Peekyes kǝ nǝ, ɗyemnaa mo, ɗang mukaat. Wu ɗak mǝse fuu mo. Wu kǝlǝng pwoo fen mo. Wu lappwoo kǝ shak, kǝ wu tongryang kǝ shak zak. Naan dǝ wur a wal, kǝ ryang, wur ntong ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Wu tok kǝ shak shi wal rǝret. ");
INSERT INTO sur_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Nen Naan mo jir, moo tok kǝ wun. ");
INSERT INTO sur_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Ɗeret kǝ Daa Jesu Kristi, kǝ wal Naan, kǝ shaar ashak kǝ Riin Ɗeɓang, mo tong ashak kǝ wun jir. Nǝ a kǝ sǝ.");
INSERT INTO sur_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Wen Pool, laalep Jesu Kristi, ɗe baa a gurum mo pet an koo a me gwar pet an, ɗang nǝ le kǝ nghan ɗee a laalep wur kas, ɗangɓe a shi rǝɓet Jesu Kristi, kǝ Naan puun, ɗewur yool kǝ Jesu a peemúut. ");
INSERT INTO sur_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Ɗyemnaa ɗe mo ashak kǝ wen, moo lep tokshik fur mo shindǝm pǝ nendǝm ndang Naan (Ekǝlisya) ɗe mo nɗǝǝn yil nGalati. ");
INSERT INTO sur_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Naan puun kǝ Daa fun Jesu Kristi mo naa wun shi yit mǝ naajeel, kǝ mo shin tongryang nwun zak. ");
INSERT INTO sur_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Jesu Kristi wur shín shin mbǝ shikbish fun mo, mbǝkǝ wur ɓam mun ɗe nɗǝǝn ɓit ɗebish ɗesǝ mo, nciit-nciit kǝ rǝɓet kǝ Naan puun fun. ");
INSERT INTO sur_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Ɗeɗes ɗee pǝ wur mbe ngaa-ngaa kǝ ngaa-ngaa. Nǝ aasǝ. ");
INSERT INTO sur_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Nǝ aapwoo nwen zam, mbǝɗe wu ciir wu cii ngwe ɗewur pet wun shi yit naajeel mǝ Kristi kǝlak-kǝlak aasǝ, mbǝkǝ wu shindǝm ɗe nɗang mee pwoo Naan ɗecì. ");
INSERT INTO sur_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Azeen-nzeen baa mee pwoo ɗeret waa ɗee ɗe, ɗe nǝ waa met ɗe wuu kǝlǝng pǝ ghan ɗe kas. Ɗang pak gurum moo daampee nwun, kǝ mo rǝɓet ciir kǝ pwoo ɗeret mǝ Kristi nǝ. ");
INSERT INTO sur_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Ɗangɓe koo ɗe a mun, jir ɗe a mee ngulep Naan tong a ɗengnaan sham, ɗangɓe wur sat mee pwoo ɗeret ɗe nwun, ɗyik kǝ mbii ɗe mu ten mu sat nwun, ɓe gwar mǝnǝ ɗee a mbii ɗebuu-buu mbǝ vit. ");
INSERT INTO sur_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Kaaɗe mu ten mu sat sǝ, an kǝn baa nsat ɗe nǝnee. Katɗang mee ngusatpwoo ɗeret ɗe nwun ɗyik kǝ ɗe mu ten mu sat nwun, ɓe wu yit kǝ ngwar mǝnǝ ɗee ndǝr tuup Naan mbǝ vit. ");
INSERT INTO sur_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Wu pan nee, an kǝn tang a ɗeɗes pǝ gurum mo ɗe aa? Aa koo a pǝ Naan ɗi yi? ɗang wu pan nee, an tang a tong ɗyen ngurum mo ghe? Katɗang ɗe an kǝn tang a tong ɗyen ngurum mo, ɓe ɗe baa an a kǝrem Kristi kas. ");
INSERT INTO sur_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Ɗyemnaa mo, ɗyen wen kǝ wun man nee, pwoo ɗeret ɗe gyet wen kǝn sat nwun, baa nǝ put a pǝ mee gurum ɗi kas. ");
INSERT INTO sur_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Mbǝɗe, baa gyet wen nla nǝ a nsar mee gurum kas. Kǝzak, baa a mee gurum kám nǝ nwen kas, a Jesu Kristi shikáa wur, wur woo nǝ nwen. ");
INSERT INTO sur_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Wu kǝlǝng pwoo nkaa shiimwaan fen, ɗe gyet nyam, nɗǝǝn seyil nNaan mǝ nen Yahudi mo, mɓít mǝnǝ, ɓe wen shínjeel Ekǝlisya Naan mo hakyeng, mbe gyet wen kǝn gung mbǝkǝ nghan tu nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Gyet nɗǝǝn gang fen mo, ɓe wen met mmo jir, mbǝ mwaan nɗǝǝn rat nen Yahudi mo. Gyet wen cìn zuur mbǝ mwaan nɗǝǝn wàar puun fen ɗe moo ten murep mo. ");
INSERT INTO sur_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Ɗangɓe Naan ɗewur ten bǝlǝp an yam-yam, akuɗang moo làa an, ɓe nɗǝǝn ɗeret wur, ɓe wur pet ghan mbǝkǝ wen ɗee ɗi a mǝ wur. ");
INSERT INTO sur_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Ɓe nǝ ret nNaan wur nyit ɓe wur kám Làa wur nwen, mbǝkǝ nghan sat pwoo ɗeret ɗe nkaa wur, nen ɗe baa mo a nen Yahudi mo kas. Baa gyet wen ɓeet mǝnǝ kǝ mee gurum kas. ");
INSERT INTO sur_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Kǝzak, baa gyet wen kàa nJerusalem, pǝ jeplep Jesu Kristi mo ɗe kas, ɗe gyet wur shee pǝrep mo baaɗang wur pet an. Ɗangɓe wen dǝm nyil Arabiya, aɓwoon mǝnǝ ɓe wen waa mbaa dǝm nDamaskus. ");
INSERT INTO sur_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Aɓwoon ɓit mo kun, ɓe wen kàa nJerusalem, mbǝkǝ nghan naa Kefas ɗi. Wen tong ashak kǝ wur mbee teer mo kaapaat baapaat. ");
INSERT INTO sur_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Baa gyet wen waa nkaat kǝ memee nɗǝǝn jeplep Jesu mo kas. Gyet wen kaat aa Jemis ɗyemnǝǝn Daa, ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Ntoom Naan, ɓe mbii ɗe wen ran nwun, baa mo a ɗung kas. ");
INSERT INTO sur_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Aɓwoon mǝnǝ, ɓe wen ndǝm nkwang yil nSiriya kǝ Silisiya. ");
INSERT INTO sur_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Baa gyet nendǝm nɗang Kristi ɗe mo nɗǝǝn Judiya nǝ mo man wen kas. ");
INSERT INTO sur_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Moo kǝlǝng a gurum mo nkaa sat nǝnee, <<Gwar ɗe dǝ wur shínjeel mmun sǝ, yaksǝ ɓe wur nkaa satpwoo ngurum mo nkaa shinzeen ɗe gyet wur gung mbǝ tu nǝ.>> ");
INSERT INTO sur_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Mo kwoop Naan mbǝ an. ");
INSERT INTO sur_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Aɓwoon ɓit mo kaapaat baafeer, ɓe wen mbaa nkàa nJerusalem, ashak kǝ Barnabas. Gyet wen mang Titus mpan ɗi. ");
INSERT INTO sur_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Wen kàa nJerusalem nǝ, a mbǝɗe Naan woo nwen nǝ, nkàa ɗi. Gyet nciit kǝ mǝnǝ, ɓe nkaat kǝ nen ɗenan-nan nǝ mo a sǝsok, mbǝkǝ wen sat ɗi mmo, nkaa pwoo ɗeret ɗe wen nkaa sat nǝ nen ɗe baa mo a nen Yahudi mo kas. Mbǝkǝ taji, ɗak ɗe gyet wen cìn nǝ kǝ ɗe wen nkaa cin yool ɗee a buu kas. ");
INSERT INTO sur_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Ɗangɓe Titus, ɗewur ashak kǝ wen, jir ɗewur a ngu Heleni, ɓe baa gyet mo letǝng nwur, kǝ mo can nwur ɗi kas. ");
INSERT INTO sur_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Ɗang pak nendǝm nɗang Kristi ɗe mǝ ɗung sǝ mo, mo tap jì ɗel nɗǝǝn mun, kaa nengwol mo sǝ, mbǝkǝ mo tap gwol mun, kǝ mo katpee ɗe mɓut mun, ɗe mun nɗǝǝn Kristi Jesu, mbǝkǝ mo le mu ɗee ɗi a kǝrem fur mo. ");
INSERT INTO sur_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Baa gyet mu shínpee mmo kas koo dǝɓen, mbǝkǝ mu tap ɗe kǝ zeen mǝ pwoo ɗeret nǝ ɗe mbǝ wun. ");
INSERT INTO sur_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Ɗangɓe mbǝ nen ɗe mo lekáa fur mo a kaa mee mbii sǝ, koo ɗe mo a wii mo yi, ɓe baa nǝ daampee nwen kas. Baa Naan wur shwatyit mmee gurum kas. Nen ɗe kǝn sat mmo, koo ɗe gyet mo a nen ɗenan-nan mo, ɗangɓe ɓe jir kǝsǝ, ɓe baa gyet mo le mee mbii ɗyik nkaa pwoo fen nǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Akoppee mǝnǝ bǝ mo naa nǝ, Naan wur cin ɗak mǝ satpwoo ɗeret nǝ nen ɗe baa mo a nen Yahudi mo kas nsar fen, kaaɗe wur cin ɗak mǝ satpwoo ɗeret nǝ mPita mbǝ nen Yahudi mo sǝ. ");
INSERT INTO sur_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Ɓe mo naa nǝnee, << Naan ɗewur shinɓal mPita, mbǝkǝ wur ɗee ɗe a ngusatpwoo ɗeret nǝ nen Yahudi mo, a wur shinɓal nwen zak, mbǝkǝ wen ɗee ɗi a ngusatpwoo ɗeret nǝ nen ɗe baa mo a nen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Kaaɗe mo naa ɗeret ɗe Naan wur cin nwen, Jemis kǝ Pita, kǝ Joon, ɗe gyet mo a nen nan mǝ nendǝm ndang Naan nǝ mo, (Ekǝlisya) nǝ, mo shin sarse fur ɗe mǝ shaarshak nwen, kǝ Barnabas. Mo sat nǝ, mmun mu dǝm mu satpwoo Naan nǝ nen ɗe baa mo a nen Yahudi mo kas, kǝ nwuɗun, ɗu dǝm ɗe pee nen Yahudi mo. ");
INSERT INTO sur_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Mo sat mmun nee, taji mu mundǝr nenjeel ɗe mo nɗǝǝn mo kas, a mbii ɗe gyet kǝn fes le pǝtuup fen mbee cìn nǝ mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Ɗang kaaɗi Pita gyet kàa nAntiyok, ɓe wen shin sar wur nyit, mbǝ mbii ɗe gyet wur cìn nǝ baa nǝ nkaa ar kas. ");
INSERT INTO sur_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Akuɗang pak gurum mo tong pǝ Jemis jì ɗe, ɓe wur kǝ sese ashak kǝ nen ɗe baa mo a nen Yahudi mo kas, ɗangɓe kaaɗe des ɗesǝ nǝ mo jì wul, ɓe wur cii sese ashak kǝ nen ɗe baa mo a nen Yahudi mo kas, mbǝɗe wur kǝǝr nen Yahudi mo. ");
INSERT INTO sur_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Ashak kǝ wur, ɓe koor nen Yahudi ɗe mo a nendǝm nɗang Jesu mo, baa mo ɗar nkaa zeen kas, kaa wur sǝ, ɗang kǝ Barnabas zak, wur mɓwoon mo nɗǝǝn mwaan mo kǝ pǝtuup ɗe vǝl-vǝl nǝ. ");
INSERT INTO sur_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Ɗang kaaɗe wen naa mǝnǝ, baa mo ɗar ndǝre-ndǝre nkaa zeen mǝ pwoo ɗeret nǝ kas, ɓe nsat mPita, nnaar mo nǝnee, <<Katɗang waa ɗe waa a ngu Yahudi aa tong a kaa ngwe ɗe baa wur a ngu Yahudi kas, ɓe cirang ɗangɓe gha nle tǝng nen ɗe baa mo a nen Yahudi mo kas, kǝ mo tong kaa nen Yahudi mo sǝ yi?>> ");
INSERT INTO sur_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Mun shikáa fun, mo làa mun a nen Yahudi mo, baa a nen shikbish kaa koor gurum mo sǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Ɗang mu man nee, baa gurum kǝ ɗee a ɗeɓang nyit Naan, a shi ɗak ɗewur cìn nɗǝǝn Wàar mo kas, ɗangɓe gurum kǝ ɗee a ɗeɓang, a mbǝ shinzeen nɗǝǝn Jesu Kristi. Har mun, mu shinzeen nɗǝǝn Kristi, mbǝkǝ mmun ɗee ɗi a ɗeɓang shi shinzeen nKristi, baa a shi mee ɗak ɗe mu cìn nɗǝǝn Wàar nǝ kas. Mbǝɗe, shi ɗak ɗe gurum cìn nǝ nɗǝǝn Wàar nǝ, ɓe baa gurum ncam ɗee a ɗeɓang nyit Naan kas. ");
INSERT INTO sur_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Ɗangɓe muu gung kǝ mun ɗee ɗe a ɗeɓang nɗǝǝn Kristi. Katɗang mo waa kat a mun a nenshikbish mo, ɓe nǝ kám nǝ, Kristi wur a mee ngulep mǝ shikbish aa? Hai baa aasǝ kas koo dǝɓen! ");
INSERT INTO sur_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Ɗangɓe katɗang wen kǝn ɗyik, a nkaa mbii ɗe wen kǝn ten nshirip mo, ɓe kǝn kám káa fen agaak nǝ, an a ngushikbish. ");
INSERT INTO sur_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Wen kǝn ɗee a ɗemumuut nɗǝǝn Wàar nǝ, mbǝkǝ wen tong ɗe kǝ seen pǝ Naan ɗe. ");
INSERT INTO sur_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Mo pwas an ashak kǝ Kristi. Baa a an kǝn tong nɗǝǝn seen ɗesǝ kas, ɗangɓe a Kristi wur kǝ tong nɗǝǝn an. Kǝ seen ɗe wen kǝ nǝ yaksǝ nɗǝǝn an ɗesǝ, an kǝn tong a shi shinzeen nɗǝǝn Làa Naan, ɗewur wal nwen, ɗang wur shìn kaashin mbǝ an. ");
INSERT INTO sur_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Baa wen cii ɗeret Naan kas, mbǝɗe katɗang gurum kǝ ɗee a ɗeɓang nyit Naan, a shi Wàar mo, ɓe muut ɗe Kristi wur muut nǝ, nǝ nɗee a buu mǝnǝ ɓe baa nǝ kǝ mee koop nǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Hai! Wun nen Galati mo, wu mwen zam. A soot ɗeɗang kǝ se ɓut nwun yi? A yit fuu mo, ɓe mo sat nwun agaak kaaɗe mo pwas Kristi. ");
INSERT INTO sur_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Wu ɗar kǝ wen cìn mee tal ɗe pǝ wun. Gyet wu lap Riin nǝ a mbǝ ɗak ɗe wu cìn nɗǝǝn Wàar nǝ aa koo a mbǝɗe gyet wu shinzeen yi? ");
INSERT INTO sur_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Wun wu mwen aasǝ wo? Gyet wu shee wu yaa a nɗǝǝn Riin, ɗangɓe yaksǝ, ɓe wuu rǝɓet kyes nǝ a nɗǝǝn nan fuu mo aa? ");
INSERT INTO sur_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Tan wu shwaajeel kǝ mbii mo shini-shinǝ a buu mǝnǝ aa? Taji wu yit kǝ nǝ ɗee a ɗebuu kas. ");
INSERT INTO sur_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Wur ɗewur shin Riin wur nwun, kǝ wur cìn mbii aapwoo mo nɗǝǝn wun, ɓe wu pan nee, a mbǝɗe wuu tap kǝ Wàar nǝ mo aa koo a mbǝɗe wu kǝlǝng, ɗang wu shinzeen pwoo ɗeret nǝ yi? ");
INSERT INTO sur_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Wu cìn pan nkaa Abraham, kaaɗe pwoo Naan nǝ sat sǝ nǝnee, <<Wur shinzeen nNaan mbǝ mo tang mǝnǝ wur a kaa ngwe ɗe ndǝre sǝ.>> ");
INSERT INTO sur_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Mbǝmǝnǝ, ɓe yaksǝ, wu naa a nenshínzeen mo a jep Abraham nǝ mo. ");
INSERT INTO sur_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","nƊǝǝn pwoo Naan, ɓe mu ten mu naa nǝ, Naan wur le nen ɗe baa mo a nen Yahudi mo kas, kǝ mo ɗee a ɗeɓang nyit wur a mbee shinzeen. Mo satpwoo ɗeret ɗesǝ nǝ mɓít mǝ Abraham nǝnee, <<A nɗǝǝn waa ɓe gurum mo jir, nɗǝǝn nyil nǝ mon nkat ɗeret.>> ");
INSERT INTO sur_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Nǝ aasǝ ɓe, nen ɗe mo shinzeen, mon nkat ɗeret ashak kǝ Abraham, mbǝɗe gyet wur kǝ shinzeen. ");
INSERT INTO sur_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Nen ɗe moo le pǝtuup fur mo, a nkaa ɗak Wàar nǝ, ɓe mo a ndǝr tuup Naan. Mo ran nɗǝǝn ɓǝǝt haal Naan nǝnee, <<Koo a wii ɗe baa wur gam Wàar ɗe mo ran mo nɗǝǝn ɓǝǝt haal mǝ Wàar nǝ kas, ɓe gwar mǝnǝ a ndǝr tuup Naan.>> ");
INSERT INTO sur_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Yaksǝ, nǝ ɗee agaak nǝ, baa mee gurum mak ɗee a ɗeɓang nyit Naan shi Wàar mo kas. Mbǝɗe koo a wii, ɗewur ɗee a ɗe ndǝre a mbǝ shinzeen wur, ɓe a wur nkat seen. ");
INSERT INTO sur_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Ɗangɓe baa Wàar nǝ ɗar a nkaa shinzeen kas, <<Koo a wii ɗewur ngam Wàar nǝ mo, ɓe gwar mǝnǝ wur nkat seen a shi mo.>> ");
INSERT INTO sur_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Mun jir, mon ntokɗyeel ɗebish mun, mbǝɗe baa mu gam Wàar nǝ mo jir kas, ɗangɓe Kristi, wur can mun nɗǝǝn ɗyeel ɗebish nǝ. A mbǝ mun, ɓe wur shwaajeel fun mo, ɗang wur mang ɗyeel ɗebish nǝ le nkaa shin. Nǝ a rǝran nɗǝǝn ɓǝǝt haal Naan nǝnee, <<Koo a wii, ɗe mo pwas wur nkaa tǝng, ɓe wur a ndǝr tuup Naan.>> ");
INSERT INTO sur_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Mbǝkǝ nɗǝǝn Kristi Jesu, ɓe ɗeret mǝ Abraham nǝ ɗee nkaa nen ɗe baa mo a nen Yahudi mo kas. Kǝzak, mbǝkǝ mun mu lap Riin ɗe Naan wur kǝ ten cweer nǝ nnǝ, wuɗin ncin mmun mbǝ shinzeen fun mo. ");
INSERT INTO sur_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Ɗyemnaa mo, an ncìn kám kǝ mbii ɗe mu ten mu loot kǝ mo nɗǝǝn tong fun mo shidaar-shidaar. Katɗang gurum mo vǝl moo ten ɓwootpwoo ashak nkaa me mbii, ɓe nǝ nluk kǝ mee gurum ɗyik teppwoo ɗe mo kǝ ten ɓwoot nǝ, kǝzak, baa mee gurum mak le mee mbii ɗe nkaa nǝ kas, mbǝɗe mo kǝ ten ɓwoot nǝ. ");
INSERT INTO sur_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Nǝ aasǝ, Naan wur kǝ ten cweerpwoo mo Abraham yam-yam kǝ ɗang wur. Baa mo ran a nee kǝ ɗang wur mo kas. Katɗang ɗe mo sat nee, a ɗang wur mo, ɓe ɗe nǝ kám nǝ, ɗang nǝ mo a ɗes, ɗangɓe mo ran a nkaa ɗang wur mǝndong ɓejee. Dang wur ɗemǝndong ɗesǝ nǝ a Kristi. ");
INSERT INTO sur_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Mbii ɗe an nkaa sat nǝ a nee, gyet yam-yam, ɓe Naan wur kǝ ten ɓǝlemcuk shi toom. Ɗangɓe aɓwoon ɓit mo kambil feer kǝ laarkun, aku ɗang Naan wur shin Wàar nǝ nen Yahudi mo. Wàar ɗe Naan wur shin ɗesǝ nǝ, baa nǝ mak teppwoo ɗe gyet wur kǝ ten cweer nǝ kas, kǝzak, baa Wàar nǝ mo mak tupwoo ɗe Naan wur kǝ ten cweer mo kas. ");
INSERT INTO sur_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Katɗang ɗe Naan wur shin zuum wur ngurum mo a mbǝɗe moo tap Wàar nǝ, ɓe ɗe baa gurum mo nkat zuum wur nǝ a mbǝ pwoo ɗe Naan wur kǝ ten cweer nǝ kas. Ɗang mu man nee, a mbǝɗe gyet Naan kǝ ten cweer nǝ, ɗangɓe wur shin zuum nǝ Abraham. ");
INSERT INTO sur_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Ɗang, a mii a koop Wàar nǝ yi? Naan wur shin Wàar nǝ mo, a mbǝkǝ mmun man mbii ɗebish mo ɗi. Gyet Naan wur shin Wàar nǝ mo mmun, a mbǝkǝ mo tap mun ɗi, mbǝ reppee lee, ɓe parɗe pee nǝ wul, mbǝkǝ ɗang Abraham nǝ jì ɗi. Mbǝɗe Naan wur kǝ ten cweerpwoo mǝnǝ a nwur. Naan wur shin Wàar nǝ a nnenlep wur mo, mbǝkǝ mo sham shin ɗi nsar mee gurum ɗe gyet wur a ngu ar nnaar Naan kǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Katɗang ngu ar ɗe mɓut mee mbii, bǝ nǝ kám mmun nǝ wur ɗar a naar gurum mo vǝl. Ɗang nɗǝǝn pwoo ɗe gyet Naan cweer Abraham nǝ, ɓe gyet a Naan wur mbǝshin ɓejee, ɗe gyet wur cweerpwoo mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Kyet ɗesǝ nǝ kám mmun nǝ, Wàar nǝ a nkaa koon kǝ pwoo ɗe Naan wur kǝ ten cweer nǝ wo? Baa nǝ aasǝ kas koo dǝɓen. Katɗang gyet mee Wàar nǝ ɗe, ɗe gyet nǝ mmak shìn seen ngurum mo, ɓe gyet nǝ mmak le gurum mo ɗee a ɗe ndǝre nyit Naan. Ɗang baa mee kaan Wàar mǝnǝ ɗi kas. ");
INSERT INTO sur_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Ɗang kaaɗe mo ran nɗǝǝn ɓǝǝt haal Naan sǝ nee, mbii ɗe mo nɗǝǝn nyil nǝ jir, mo a ndǝr shikbish. A nen ɗe mo shinzeen nJesu Kristi, mo lap mbii ɗi Naan wur kǝ ten cweer nǝnee, wuɗin shìn nen ɗe mo shinzeen Kristi ɓejee. ");
INSERT INTO sur_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Gyet akuɗang shinzeen nǝ jì, ɓe mun a ɗe shishoot nɗǝǝn Wàar nǝ, aku ɗang Naan wur wang ar mmun, kǝ mu shinzeen ɗi nJesu Kristi. ");
INSERT INTO sur_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Mbǝmǝnǝ, ɓe gyet Wàar nǝ a ngukám fun, akuɗang Jesu Kristi wur jì. Kaaɗi wur jì ɓe mu ɗee a ɗi ndǝre nyit Naan, mbǝɗe mu shinzeen wur. ");
INSERT INTO sur_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Ɗang nyaksǝ, kaaɗi Naan kǝ wang ar nǝ mun, mbǝkǝ mu shinzeen ɗe Jesu Kristi, ɓe baa mu kuɗi a ndǝr ngupan mun kas. ");
INSERT INTO sur_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Mbǝɗe yaksǝ bǝ shinzeen, nɗǝǝn Jesu Kristi, ɓe wun a jep Naan mo jir. ");
INSERT INTO sur_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Wun ɗe moo cìn baptisma nwun jir nɗǝǝn Kristi, ɓe wuu ɗee a ɗebǝɓal kǝ Kristi mǝnǝ. Mbǝmǝnǝ mu mwaan nɗǝǝn ɗyen mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Yaksǝ, baa mee shwatyit kuɗi nnaar nen Yahudi mo kǝ nen ɗe baa mo a nen Yahudi mo kas, koo naar kǝrem kǝ jeplu mo kas, koo nnaar mish mo kǝ mat mo kas, mbǝɗe wun a ɗemǝndong jir nɗǝǝn Kristi Jesu. ");
INSERT INTO sur_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Katɗang wun a mǝ Kristi, ɓe wun a jep Abraham mo. Wuu lap mbii mo jir, ɗe gyet Naan wur kǝ ten cweer nǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Mbii ɗe an nkaa sat nǝ a nee, làa ɗewur nsekop, baa wur met kǝrem kas, naar ɗewur kuɗi a làa, jir kǝ ɗe long nǝ mo a mǝ wur. ");
INSERT INTO sur_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Kaaɗi wur kuɗi a làa, ɓe a gurum moo tap wur zak. A gurum moo naa mbii wur mo, har parpuus ɗe puun wur le nǝ wul. ");
INSERT INTO sur_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Nǝ kǝ mun aasǝ zak. Gyet nyam, naar ɗe gyet baa mu manshii zeen kǝ mbii mo kas, ɓe gyet mun a kǝrem mon ndǝr Wàar kǝ mbii ɗe gurum mo loot kǝ cìn mo, ɗe mo nyil ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Ɗang kaaɗi pee nǝ wul tyap, ɓe Naan wur lep Làa wur sham nɗǝǝn nyil ɗesǝ. Mo làa wur a kaaɗi mo kǝ làa gurum mo sǝ, ndǝr Wàar. ");
INSERT INTO sur_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","Mbǝkǝ wurang nen ɗe mon ndǝr Wàar nǝ ɗi, mbǝkǝ wur le mun ɗee ɗe a jep Naan mo. ");
INSERT INTO sur_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Mbǝɗe wun a jep wur mo yaksǝ, ɓe Naan wur lep Riin kǝ Làa wur sham nɗǝǝn pǝtuup fun mo. Riin nǝ wur petpee shiɓal nee, Daa puun! ");
INSERT INTO sur_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Yaksǝ, ɓe nɗǝǝn Naan, baa wu kuɗi a kǝrem mo kas, ɗangɓe wun a jeplu mo. Katɗang wu ɗee a jeplu mo, ɓe wun nsekop kǝ mbii ɗe Naan wur ncìn nǝ jep wur mo. ");
INSERT INTO sur_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Gyet nyam, ɓe baa wu man Naan kas, ɓe gyet wun a kǝrem mo ndǝr riin ɗe baa mo a naan kas. ");
INSERT INTO sur_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Ɗangɓe yaksǝ kaaɗi wu man Naan sǝ, koo kaaɗi Naan kǝ man wun sǝ, ɓe cirang ɗang wun ciir kǝɓwoon nNaan, kǝ wun waa wu baa wu dǝm ɗe nɗang Wàar kǝ mbii ɗe gurum mo loot kǝ cìn yi mǝ riin ɗe mo nyil ɗesǝ baa moo mee ɓal kas yi? Ɗyen nwun kǝ wu baa wu ɗee ɗe a kǝrem mo zak aa? ");
INSERT INTO sur_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Wuu tap kǝ teer mo, kǝ puus serǝɓet mo, kǝ tar mo, kǝ pak teer mo nɗǝǝn ɓit nǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Ɗangɓe wu shin kǝǝrmuut taji ɗak ɗe gyet wen cìn pee wun, nǝ yool ɗee a ɗebuu. ");
INSERT INTO sur_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Ɗyemnaa mo, an kǝn ɗang pee wun, kǝ wu ɗee kaa ghan sǝ. Kaaɗi ghan kǝn ɗee kaa wun sǝ. Baa wuu cìn mee mbii ɗebish nwen kas. ");
INSERT INTO sur_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Wu man nee, gyet a wen shee jì kǝ pwoo ɗeret nǝ nwun. Mbii ɗe gyet nǝ le ɗang wen tong pee wun ɗe, a mbǝɗi baa gyet wen nkoom kas. ");
INSERT INTO sur_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Koo ɗe gyet shwal nǝ daampee nwun, bǝ baa wu cii an kas, kǝzak, baa wu ɓak an kas. Ɗangɓe wu lap ghan shi pǝtuup mǝndong kaa wuu lap a mee ngulep Naan sǝ. Gyet wu lap ghan a kaa Kristi Jesu shikáa wur sǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","A nee, retnyit ɗe gyet wu cìn ashak kǝ wen sǝ, nǝ a nii? Mbǝɗe wen sat nwun azeen, katɗang ɗe a mbii ɗe nǝ mmak cìn, ɓe ɗi gyet wun shwatyit fuu mo wu shìn nghan. ");
INSERT INTO sur_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Cirang ɗangɓe wen mbǝ ciir nɗee a shaarlek fuu yi? Mbǝɗe wen sat zeen nǝ nwun aa? ");
INSERT INTO sur_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Nen ɗe mo nkaa cìn ɗung nwun sǝ mo, moo gung a mbǝkǝ mo kat ɗeret ɗe nyit fuu, ɗangɓe mbii ɗe nǝ le ɗang mo rǝɓet cìn kǝsǝ nǝ, baa nǝ ret kas. Mo rǝɓet a kǝ wun ɓàkshak ɗe kǝ wen, mbǝkǝ wu kǝlǝng a mo ɗi ɓejee. ");
INSERT INTO sur_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Katɗang gurum mo tap shak a mbee mbii ɗeret, ɓe nǝ ret zam. Ɗesǝ nǝ azeen-nzeen, koo a pǝrangyi. Koo ɗe ghan ashak kǝ wun, koo ɗe baa ghan ashak kǝ wun kas, ɓe wen kǝn pan wun. ");
INSERT INTO sur_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Jep fen ɗe kǝn wal nwun sǝ mo, ghan a kaa mat ɗe war nkaa shwaajeel mbee làa-làa sǝ. Wen nsat a nshwaajeel nǝ ɗak, har parɗi mǝse fuu ɗee nciit-nciit kǝ mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Ɗyeen ghan ndǝǝm pee wun ɗe zam, mbǝkǝ nghan man ar ɗe an nsat mbii ɗesǝ mo ɗe nwun. Yaksǝ, baa wen man mbii ɗe an nsat nwun kas. Mbii nǝ daampee nwen nkaa wun zam. ");
INSERT INTO sur_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Wun nen ɗe wu sat nee, wun a ndǝr Wàar nǝ mo. Wu sat nwen yaksǝ, wu kǝlǝng mbii ɗe Wàar ɗesǝ nǝ mo nkaa sat nǝ aa? ");
INSERT INTO sur_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Mo ran nɗǝǝn ɓǝǝt haal Naan nǝnee <<Gyet Abraham kǝ jep ɗemish mo vǝl. Gyet nǝǝn memee war a kǝrem, kǝ nǝǝn ɗevǝl nǝ, baa war a kǝrem kas.>> ");
INSERT INTO sur_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Ɗangɓe mo làa-làa kǝ mat ɗe gyet war a kǝrem sǝ, nɗǝǝn nan, ɗangɓe làa mat ɗe gyet baa war a kǝrem kas sǝ, mo làa wur a nciit-nciit kǝ pwoo ɗe gyet Naan wur ten cweer nǝ Abraham. ");
INSERT INTO sur_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Pwoo ɗesǝ nǝ mee mbiikám ɗejurum ɗe ɓut. Mat ɗevǝl ɗesǝ nǝ mo, mo ɗee a kaa cweerpwoo shi toom mo vǝl sǝ, ɗe gyet Naan wur sat nǝ mo. Hagar a mat ɗe war a kǝrem sǝ, war ɗee a sǝmpwoo ɗe Naan wur cweer nǝ mMosis nkaa jwak Sinai. A war ɗe war làa-làa mo ɓe mo ɗee a kǝrem mo. ");
INSERT INTO sur_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Hagar war ɗee a sǝmpwoo kǝ jwak Sinai ɗe nǝ nyil Arabiya. War ɗee a kaa Jerusalem sǝ, ɗe war kǝ jep war mo, mo ɗee nkaa cìn ɗak kǝrem mbǝ cicinsǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Ɗang Jerusalem ɗe nǝ nɗǝǝn ɗengnaan, baa war a kǝrem kas, war a nǝǝn fun. ");
INSERT INTO sur_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Ɓǝǝt haal Naan sat nǝnee, <<Wii jeer, yi cìn retnyit. Wii ɗe baa yii cam shwaajeel mǝ làa-làa kas, mbǝɗe mat ɗemish ceen war, war kat jep mo ɗes met mat ɗe war tong ashak kǝ mish war.>> ");
INSERT INTO sur_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Yaksǝ, ɗyemnaa, mo mmun a jep ɗe mo kǝ tuwap nkaa ɗe wun a kaa Aizik sǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Gyet nyam nǝ, ɓe làa ɗe gyet mo làa wur a nɗǝǝn nan sǝ, wur shínjeel laa ɗe gyet mo làa wur a nɗǝǝn Riin. Nǝ aasǝ yaksǝ. ");
INSERT INTO sur_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Ɗang, mbii ɗe mo ran nǝ nɗǝǝn ɓǝǝt haal Naan nǝ sat a mbǝmi? Nǝ sat nǝnee, <<A ceen kǝrem nǝ war kǝ làa war nǝ, mbǝɗe baa làa kǝrem nǝ mmak sekop ashak kǝ laalu nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Mbǝmǝnǝ ɗyemnaa mo, baa mun a kǝrem mo kas, ɗangɓe mun a jeplu mo. ");
INSERT INTO sur_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Mbii ɗe nǝ le, ɗangɓe Kristi wur pwat kǝ mun ndǝr Wàar kǝ nen Yahudi nǝ mo, a mbǝkǝ mun ɗee ɗi a nankáa sun azeen-nzeen. Mbǝmǝnǝ, ɓe wen kǝn sat nwun nee, wu ɗar ɓalɓal kaa nen ɗe mo a nankáa sut sǝ. Taji wu baa wu shìn káa fuu, mbǝkǝ wu baa wu ɗee ɗi a kǝrem kas. ");
INSERT INTO sur_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Wen Pool, an nkaa sat nǝ wun nee, katɗang wu yit mmee gurum can wun, ɓe nǝ ɗee agaak nǝnee, << mbii ɗe Kristi kǝ cìn mbǝ wun, ɓe nǝ ɗee a buu mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Wen kǝn rǝɓet kǝ koo a weyi man azeen-nzeen nǝ, katɗang mee gurum waa rǝɓet kǝ mo can wur, ɓe nǝ ɗee a tǝng kǝ wur gam koor wàar nǝ mo ɗi jir. ");
INSERT INTO sur_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Wun nen ɗe wu pan nee, wuu ɗee a ɗe ndǝre nyit Naan, mbǝɗe wuu tap kǝ wàar nǝ mo, ɓe wu pwat kǝ káa fuu mo aku nɗǝǝn Kristi. Wuu ɗee a ɗepǝpal nɗǝǝn ɗeret ɗe Kristi kǝ ten cìn mo mbǝ wun. ");
INSERT INTO sur_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Ɗangɓe mun nen ɗe baa mu leyit a nkaa can kas, ɓe nɗǝǝn Riin shi shinzeen ɓe, muu tong a shi gongpee shi canciin mǝ ɗe ndǝre mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Katɗang mu ɗee a ɗemǝndong kǝ Kristi Jesu, ɓe baa nǝ kuɗi mee koop nǝ kas, koo ɗe mo can gurum, kǝ koo ɗe baa mo can gurum kas, ɗangɓe mbii ɗe nǝ kǝkoop nǝ a shinzeen ɗe nǝ kám sat nɗǝǝn wal. ");
INSERT INTO sur_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Dǝ nyam, ɓe wun nkaa sekyeen nɗǝǝn pwoo ɗeret nǝ hakyeng, ɗangɓe yaksǝ, ɓe a me le ɗang baa wu kuɗi wuu mwaan nɗǝǝn zeen nǝ kas yi? ");
INSERT INTO sur_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Baa a Naan ɗewur pǝrep wun, a wur cíi sekyeen nwun kas. ");
INSERT INTO sur_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","<<A rep yist lee nǝ le kǝ bred wup ɗi.>> ");
INSERT INTO sur_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Ɗang mbǝɗe mun a ɗemǝndong nɗǝǝn Daa fun, ɓe an shinzeen nee, baa pan fuu mo waa ɗen ɗyik kǝ mǝnǝ kas. Wen shinzeen nee, ngwe ɗewur nǝk wun sǝ, koo ɗewur a wii, ɓe Naan nshín kar wur. ");
INSERT INTO sur_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Ɗang ɗyemnaa mo, katɗang an kǝn sat an satpwoo nǝ, can nǝ a tǝng, ɓe a me le ɗang ghan kǝn sat a nshwaajeel ɗak yi? Katɗang nǝ aasǝ, ɓe moo shang mbii ɗe nǝ le canshii ngurum mo nɗǝǝn shiyeepyoom Kristi. ");
INSERT INTO sur_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Nen ɗe mo daampee nookɗi nwun sǝ, wen fes nrǝɓet kǝ mo dǝm pun sut kǝ mo ɗee ɗi a meermuut mo. ");
INSERT INTO sur_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Ɗyemnaa mo, Naan wur pǝrep wun, mbǝkǝ taji wu ɗee a kǝrem mo ndǝr wàar mǝ nen Yahudi mo kas, ɗangɓe, taji wu le kǝ katpee fuu nǝ, nǝ ɗee a ar ɗe wun ncìn mbii ɗebish mǝ nan ɗi kas. Ɗangɓe nǝ ret kǝ wu walnshak kǝ ɓamshak zak. ");
INSERT INTO sur_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Mo gam wàar nǝ mo jir a nɗǝǝn pwoo ɗesǝ nǝnee, <<A wal ngǝnang fwaa kaa sak sǝ.>> ");
INSERT INTO sur_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Katɗang wun nɗee a kaa luwaayil ɗe moo seshak sǝ, ɓe wu tap taji wu tu shak kyes kǝdǝng-ndǝng. ");
INSERT INTO sur_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Wen kǝn sat nwun nee, wu mwaan nɗǝǝn Riin, mbǝkǝ taji wu gam ɗyen mǝ nan nǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Mbǝɗe mbii ɗenan nǝ kǝ rǝɓet, ɓe baa mo a nciit kǝ mbii ɗe Riin nǝ rǝɓet kas. Kǝzak, mbii ɗe Riin nǝ rǝɓet ɓe baa mo a nciit kǝ mbii ɗenan nǝ rǝɓet kas. Mbii ɗevǝl sǝ mo baa moo rǝɓet shak kas. Ɗesǝ nǝ ɗee nee baa wu mak cìn mbii ɗe wuu rǝɓet kas. ");
INSERT INTO sur_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Ɗang katɗang wuu mwaan a nɗǝǝn Riin Naan, ɓe baa wu kuɗi a ndǝr Wàar nǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Ɗak ɗe gurum moo cìn nɗǝǝn mǝse kǝ gurum, nǝ agaak. Kyeet kǝ ɗak mǝnǝ mo, a kaa cin ngaa, ɗak ɗebish mo, cìn mbii ɗebish nen yitlwaan. ");
INSERT INTO sur_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","Seyil nkùm, ɗak soot, ciishak, jǝǝr, zuur, tuup, rǝɓetkáa, ɓákshak, mǝse ɗe nǝ a mǝ yilangpee. ");
INSERT INTO sur_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","Zuur ɗebish, shwaayuur, kuur ashak ɗebish mo, kǝ mbii ɗebish mo ɗe shini-shinǝ. Wen kǝn satpwoo nwun shiɓal, kaaɗe gyet ghan kǝn sat nwun sǝ nǝ, nen ɗe moo cìn mbii ɗesǝ mo jir, ɓe baa mon ncam ɗel nɗǝǝn mulki Naan kas, koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Ɗang ɗak ɗe gurum moo cìn nɗǝǝn Riin Naan mo a, walnshak, kǝ retnyit, tongryang, gung mbii mo, naajeel nshak, cìn mbii ɗeret mo, shinzeen, ");
INSERT INTO sur_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","sham kǝ káa, yaasuk. Mbii ɗesǝ mo jir, baa mee Wàar ɗe nkaa mo kas. ");
INSERT INTO sur_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Nen ɗe mo a mǝ Kristi Jesu, mo kǝ ten pwas nan fur mo nkaa shiyeep ashak kǝ koor nǝ. ");
INSERT INTO sur_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Katɗang mu tong a nɗǝǝn Riin, ɓe nǝ ret kǝ mu mwaan nɗǝǝn Riin nǝ zak. ");
INSERT INTO sur_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Taji mu ɗiyeepkáa kas, kǝ taji mu le tuup nshak kas. Taji mu cìn zuur kǝ shak kas zak. ");
INSERT INTO sur_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Ɗyemnaa mo, katɗang mee gurum taa pal, ɓe wun ɗe wun a ɗe ɓalɓal nɗǝǝn Riin Naan wu ɓam wur, mbǝkǝ wur tuwap ɗe. Wu sham kǝ káa fuu mo, kaaɗe wun nkaa ɓam wur. Wu tap kǝ káa fuu, mbǝkǝ taji wun wu waa wu ɗel nɗǝǝn jwaan nǝ kas. ");
INSERT INTO sur_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Wu ɓamshak, katɗang wu cìn aasǝ ɓe wu gam Wàar Kristi mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Katɗang memee fuu lekáa wur a mee mbii, ɗangɓe nɗǝǝn zeen nǝ, ɓe baa wur a mee mbii kas, ɓe gwar mǝnǝ nǝk a kaa shin ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Ɗang nǝ ret kǝ, koo a wii ɓe wur cam ɗak wur, ɗangɓe wur nleshap shikáa shin, baa ashak kǝ ɗewur kám shin kǝ mee gurum kas. ");
INSERT INTO sur_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Koo a weyi nɗǝǝn wun ɓe wur mang toon kǝ mbii ɗewur cìn mo shikáa wur. ");
INSERT INTO sur_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Koo weyi ɗewur nkaa lap kámpwoo Naan, ɓe nǝ ret kǝ wur ɓàk mbii ɗeret mo jir, ashak kǝ ngukám nǝ. ");
INSERT INTO sur_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Taji mee gurum gwamkáa shin kas, mbǝɗe baa mee ngwe cam zaal nNaan kas. Mbii ɗe gurum kop ɓe wur nɗyiip a nǝ. ");
INSERT INTO sur_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Ngwe ɗewur kop a nɗǝǝn nan nwur, ɓe wur nɗyiip a mbii ɗewam nɗǝǝn nan nǝ. Ɗang ngwe ɗewur kop nɗǝǝn Riin Naan, ɓe nɗǝǝn Riin ɓe wur nɗyiip a seen ɗe ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Taji kwak fun mo waam mbǝ cìn mbii ɗeret mo kas, mbǝɗe katɗang pee nǝ wul, ɓe mun nɗyiip ɗeret mǝ ɗak fun mo, ka baa mu taa mu muutleet kas. ");
INSERT INTO sur_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Aasǝ, nǝ ret kǝ mu cìn mbii ɗeret mo, kaaɗe mu katpee nǝ sǝ. Mu cìn mbii ɗeret ngurum mo jir, met jir, a ɗyemnǝǝn fun mo, ɗe mo a nendǝm nɗang Kristi mo. ");
INSERT INTO sur_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Ran ɗenan-nan ɗe wu naa sǝ mo, a an ran mo shi sar fen shindǝm nwun. ");
INSERT INTO sur_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","A nen ɗe mo rǝɓet leshap nɗǝǝn nan ɗesǝ, a moo rǝɓet letǝng nwun, mbǝkǝ wu can-can ɗe, kǝzak, mbǝkǝ taji mo shwaajeel, mbǝ shiyeepyoom Kristi kas. ");
INSERT INTO sur_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Nen ɗe moo ten can mo, mo shikáa fur, baa mo kyeer wàar nǝ kas. Ɗangɓe nǝ a rǝɓet kǝ mo, kǝ mo can wun, mbǝkǝ mo katpee ɗe mbǝ canpwoo nkaa wun nɗǝǝn nan. ");
INSERT INTO sur_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Ɗangɓe pee wen ɗe ɓe a shi shiyeepyoom Daa fun Jesu Kristi, a nǝ a mbii mǝndong ɗe nǝ mmak le kǝ nghan canpwoo ɓejee ɗak. A mbǝ shiyeepmúut wur, ɓe mbii ɗe mǝ nyil ɗesǝ mo, baa mo kuɗi mee koop nǝ pee ghan ɗe kas. Nǝ ɗee a kaa moo ten pwas mo nkaa shiyeepmúut Kristi, kǝzak, an a kaa ngwe ɗe kǝ ten muut sǝ, har wen kǝn yit mbii mǝ nyil ɗesǝ mo mɓwoon. ");
INSERT INTO sur_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Koo ɗe mo can gurum, kǝ koo ɗe baa mo can gurum kas, ɓe baa nǝ kǝ mee koop nǝ kas. Mbii ɗe nǝ kǝkoop nǝ hakyeng nǝ nɗesǝ, Naan wur shin seen ɗepwoo mun. ");
INSERT INTO sur_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Mbǝ ɗe mo kǝ mwaan nɗǝǝn seen ɗepwoo ɗesǝ nǝ, ɓe mo a nen Naan mo azeen. Moo tongryang kǝ Naan kǝ wur naa mo shi yit naajeel zak. ");
INSERT INTO sur_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Yool yaksǝ, ɓe baa ɗyen nwen kǝ mee gurum daampee nwen zak kas, mbǝɗe nǝmer ɗe mo nkaa an mo kám nǝ, an a kǝrem mǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Ɗyemnaa mo, ɗeret mǝ Daa fun Jesu Kristi nǝ tong ashak kǝ riin fuu mo jir. Nǝ a kǝsǝ.");
INSERT INTO sur_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Pool laalep Kristi shi rǝɓet Naan, shindǝm pee nen Naan ɗe mo nɗǝǝn nyil Afisus, ɗe mo shinzeen nJesu Kristi azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Ɗeret kǝ ryang mǝ Naan puun fun kǝ Daa fun Jesu Kristi mo tong ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Mu pǝlang Naan puun, kǝ Daa fun Jesu Kristi, ɗewur le ɗeret wur nkaa mun, shi koo a ɗeret ɗeɗangyi ɗe nǝ a mǝ Riin nɗǝǝn ɗengnaan mo, shi Kristi. ");
INSERT INTO sur_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Akuɗang Naan wur leyil nǝ, ɓe wur kǝ ten bǝlǝp mun, mbǝkǝ mu ɗee a mǝ wur nɗǝǝn Kristi, mbǝkǝ mu ɗee ɗe a ɗeɓang nɗǝǝn wal mbǝɗe baa mee shikbish ɗi ntoom nwur kas. ");
INSERT INTO sur_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Naan kǝ ten sat nee, nɗǝǝn Jesu Kristi, ɓe ɗyin nle kǝ mun ɗee a jep wur mo. Ɗesǝ nǝ put a nɗǝǝn pan mǝ retnyit wur. ");
INSERT INTO sur_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Wu yit kǝ mun kwoop wur mbǝ ɗeɗes mǝ yit naajeel nwur, ɗewur shìn mmun nzuum nɗǝǝn Làa wur ɗewur wal wur. ");
INSERT INTO sur_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Mbǝɗe a shi muut Kristi ɗangɓe mo fween mun, shii mǝnǝ a nee, mo fwo shikbish fun mo mmun. Yit naajeel nNaan nǝ ɗes zam, ");
INSERT INTO sur_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ɗewur ɗoo nǝ nkaa mun ɗes, kǝ seen kǝ manshii mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Yaksǝ Naan wur le kǝ mun man mbii ɗe mo a sǝsok mǝ pan wur mo, nciit-nciit kǝ pan wur ɗewur kǝ ten le nǝ, kǝ nǝ ɗee a ɗegǝgam nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Mbii ɗe Naan wur kǝ ten sat nee, wuɗyin ncìn mo katɗang pee nǝ wul. Ɓe Naan wur njì kǝ mbii ɗewur kǝ ten le mo nɗǝǝn nyil ɗesǝ ashak, kǝ ɗe mo nɗǝǝn ɗengnaan kǝ ɗe mo nɗǝǝn nyil ɗesǝ jir, ɓe Kristi wur nɗee a káa mmo jir. ");
INSERT INTO sur_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Mon cìn mbii mo jir a nciit-nciit kǝ mbii ɗe Naan wur kǝ ten sat nǝ wuɗin cìn mo. Naan wur ten bǝlǝp mun, kǝ mun ɗee a nen wur mo nɗǝǝn Kristi nciit-nciit kǝ pan wur. Mbii mo ɗes aasǝ, nciit-nciit kǝ mbii ɗewur kǝ ten sat nǝ wuɗin cìn mo pǝgyet ɗi nshee. ");
INSERT INTO sur_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Mun ɗe mu shee canciin nkaa Kristi, wu yit kǝ mun kwoop Naan mbǝ ɗeɗes wur. ");
INSERT INTO sur_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","A wun zak, wu ɗee a nen Naan mo kaaɗi wu kǝlǝng pwoo ɗe azeen nǝ. Pwoo ɗeret ɗe nǝ jì ɓam wun, kaaɗe wu shinzeen nKristi sǝ, ɓe Naan wur kǝ le sar wur nkaa wun, kǝ nwun ɗee ɗe a mǝ wur. Kaaɗe wur shin Riin Ɗeɓang nǝ nwun nciit-nciit kǝ mbii ɗewur kǝ ten sat sǝ. ");
INSERT INTO sur_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Riin Ɗeɓang ɗe Naan wur shin nǝ mun, wur ɗee a mbii ɗenshee ɗe nǝ kám mun nǝ, mu lap mbii ɗe Naan ten sat nǝ wuɗyin shìn nen wur mo. Ɗesǝ nǝ kám mun nǝ, Naan wur shínpee nen ɗe mo a mǝwur mo, yit kǝ mu kwoop Ɗehai wur ɗi. ");
INSERT INTO sur_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Mbǝ mbii ɗesǝ, ɓe yool mparpuus ɗe wen kǝlǝng pwoo nkaa shinzeen fuu nǝ nɗǝǝn Daa Jesu, kǝ wal fuu nǝ mbǝ nen Naan mo jir, ");
INSERT INTO sur_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ɓe baa wen kǝn nook pǝlang Naan mbǝ wun kas. Wen kǝn pan wun nɗǝǝn ɗangnaan fen mo. ");
INSERT INTO sur_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Wen kǝn ɗang pǝ Naan kǝ Daa fun Jesu Kristi, puun ɗehai shidaar-shidaar nee, ɗewur nshin Riin nwun, kǝ wur le nwun ɗee a nenseen mo, kǝ woo man mǝ Naan nwun rǝret hakyeng. ");
INSERT INTO sur_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Yit kǝ pǝtuup fuu mo wang ɗi, kǝ wu naan pee ɓang wur ɗi, mbǝkǝ wu man mbii ɗe wuu canciin ɗe ke ɗewur kǝ ten pǝrep wun mbǝ nǝ, kǝ kop ɗewur nshin nen wur mo. ");
INSERT INTO sur_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Baa mee ngwe mmak kám ɗeɗes wur, ɗe nǝ nkaa cìn ɗak nɗǝǝn mun kas, mun nen ɗe mu shinzeen wur. Iiko ɗe nǝ nkaa cìn ɗak nɗǝǝn mun, nǝ nciit-nciit kǝ ɗeɗes mǝ ɓal wur, ");
INSERT INTO sur_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ɗe gyet wur cìn ɗak kǝ nǝ, mbǝkǝ wur yool ɗe kǝ Kristi a peemúut, kǝ nNaan wur le kǝ Kristi kàa tong nsarse wur nɗǝǝn ɗengnaan. ");
INSERT INTO sur_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Kristi wur met mɓal mishkoom mo jir, kǝ iiko, kǝ ɓal, kǝ ɗes mǝ se mishkoom mo jir. Sǝm wur nǝ met koor sǝm mo jir. Baa a nɗǝǝn ɓit ɗeyaksǝ ɓejee ɗak kas, ɗangɓe kǝ nɗǝǝn ɓit ɗe mo ndung jì akyeen. ");
INSERT INTO sur_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Naan wur kǝ ten le mbii mo jir ndershii wur, kǝzak wur le wur ɗee a káa mbii mo jir mbǝ Ekǝlisya nǝ. ");
INSERT INTO sur_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Kuur nendǝm nɗang wur mo, a shin wur, ɗe mo gam kǝ wur shikáa wur, ɗewur gam mbii mo jir, koo a nɗǝǝn ar ɗeɗangyi ");
INSERT INTO sur_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Gyet nyam ɓe, wun a ɗemǝmurep nɗǝǝn tep waar kǝ shikbish fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Gyet nciit kǝ mǝnǝ, ɓe wuu mwaan a nɗǝǝn coor ɗebish mǝ yil ɗesǝ, kǝ nwun kǝlǝng a ɗoo mǝ mishkoom ɓal kǝ riin ɗe mo nɗǝǝn kut mo, riin ɗe nǝ pǝ cin dak nkaa nen ɗe mo cii cìn ɗyen Naan. ");
INSERT INTO sur_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Gyet mu tong a kaa mo sǝ, nɗǝǝn coor mǝ nan fun mo. Kǝ gyet mu cìn mbii ɗe mu naa mo shang nnan fun mo, kǝ pan mǝ pǝtuup fun mo zak. ɗang nɗǝǝn tong fun, kaa koor gurum mo sǝ, ɓe dǝ mu ten mu ɗee a ɗe mun nshwaajeel mbǝ tuup Naan. ");
INSERT INTO sur_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Ɗang mbǝɗe kussuk Naan kǝ wal wur nǝ ɗes zam, ");
INSERT INTO sur_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ɓe jir ɗe gyet mun a ɗemǝmurep nɗǝǝn shikbish fun mo, ɓe wur le kǝ mu kat seen ashak kǝ Kristi. Nǝ a mbǝ yit naajeel Naan, ɗangɓe mu kat ɓam. ");
INSERT INTO sur_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Naan wur nle kǝ mun yool ashak kǝ Kristi, kǝ wur le kǝ mun tong ashak kǝ wur nɗǝǝn ɗengnaan mbǝ sǝm kǝ Kristi Jesu. ");
INSERT INTO sur_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","nƊǝǝn ɓit ɗe mo pǝ jì, ɓe wur nkám mmun ɗes shi ɗeɗes wur ɗe baa mee gurum mak kám nǝ kas. Ɗesǝ nǝ a yit naajeel wur ɗeɗes mbǝ mun nɗǝǝn Kristi Jesu. ");
INSERT INTO sur_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","A mbǝ yit naajeel Naan, ɗangɓe wu kat ɓam, mbǝɗe wu shinzeen. Baa wu kat ɓam ɗesǝ nǝ a mbǝ mee ɗak ɗeret ɗe wu cìn kas, nǝ a zuum mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Baa nǝ a mbǝ mǝnǝ ɗak kas. Mpeemǝnǝ, ɓe taji mee gurum ɗiyeepkáa wur kas. ");
INSERT INTO sur_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","A Naan wur le mun shi sar wur, kaaɗe mun ɗe sǝ, ɗangɓe yaksǝ nɗǝǝn Kristi, ɓe wur le mun a mbǝ cìn ɗak ɗeret mo, ɗewur kǝ ten ɗak nǝ le mbǝ mun, mbǝkǝ mun cìn mo ɗi. ");
INSERT INTO sur_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Taji wu mundǝr kas, nǝ, gyet nyam ɓe wun a nen ɗe baa mo làa wun a nen Yahudi mo kas. Ɓe gyet nen Yahudi ɗe dǝ mo lesut a nen ɗe mo can mo nɗǝǝn nan shi sar gurum mo, moo pet wun a nen ɗe nsuluk mo. ");
INSERT INTO sur_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Taji wu mundǝr kas nǝ, gyet mɓít mǝnǝ mo, ɓe baa wu kus kǝ Kristi kas, kǝ baa gyet wu man Naan kas. Gyet mo shwat wun nɗǝǝn jep mǝ nen Yahudi mo, kǝ gyet wun a mǝzep mo. Mbǝɗe Naan kǝ ten ɓǝlemcuk shi toom, kǝ baa gyet wun kǝ mee mbii canciin nɗǝǝn yil nǝ kas. ");
INSERT INTO sur_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Amma, yaksǝ nɗǝǝn Kristi Jesu, ɓe wun ɗe gyet wu jong, mo kǝ jì kǝ wun kus, shi toom Kristi. ");
INSERT INTO sur_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","A Kristi jì kǝ tongryang mmun, ɓe wur le kǝ nen Yahudi mo ɗee a ɗemǝndong kǝ nen ɗe baa mo a nen Yahudi mo kas. Wur shirip kok ɗe gyet nǝ ɓàk mun, mbǝkǝ mun ɗee ɗi a shaarshak. ");
INSERT INTO sur_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Wur mang Wàar nen Yahudi mo baa kǝnǝ aku, mbǝkǝ wur waa le gurum ɗepwoo mo ɗe nɗǝǝn ɗang ɗevǝl sǝ mo. Ɗe a nɗǝǝn ar ɗesǝ, ɓe wur jì kǝ tongryang. ");
INSERT INTO sur_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","A shi muut wur nkaa shiyeepyoom, ɓe wur tu mbii ɗe nǝ jì kǝ ciishak ngurum mo. A shi shiyeepmúut wur, ɓe wur ɓàl ɗang mo shini-shini, kǝ mo ɗee a ɗemǝndong nɗǝǝn Naan. ");
INSERT INTO sur_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Jesu wur jì satpwoo, mǝ ryang nwun. Wun nen ɗe gyet wu jong kǝ Naan, kǝzak, wur jì kǝ pwoo nǝ nen ɗe gyet mo kus kǝ Naan zak. ");
INSERT INTO sur_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","A nɗǝǝn Kristi ɓe mun gurum jir, mu mak jì nɗǝǝn Riin ɗemǝndong pǝ puun fun ɗi. ");
INSERT INTO sur_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Mbǝmǝnǝ, ɓe yaksǝ, wun nen ɗe baa wun a nen Yahudi mo kas, baa wu kuɗi a mǝzep koo pǝkor mo kas. Yaksǝ wun a ɗemǝndong kǝ jepyil mǝ nen Naan mo, kǝ nwun ɗee a jeplu mǝ Naan mo zak. ");
INSERT INTO sur_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Mo ɗyik wun a nkaa kuk ɗe jeplep kǝ Jesu mo, kǝ nensatpwoo Naan mo kǝ ten ɗyik nǝ. Jesu Kristi wur shikáa wur, a nghǝk ɗeɗes mǝ kwang lu nǝ. ");
INSERT INTO sur_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","A nɗǝǝn wur, ɓe jir koor lu nǝ kǝkàa nkaa wur, kǝ a wur le kǝ lu nǝ wurang, kǝ nǝ ɗee a lu ɗeɓang mǝ Daa. ");
INSERT INTO sur_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","A nɗǝǝn wur, ɓe mo ɗyik wun, kǝ nwun ɗee a pee ɗi Naan wur tong ɗi, shi riin wur. ");
INSERT INTO sur_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","A mbǝ ɗesǝ, ɓe wen Pool, an a shishoot mbǝ Kristi Jesu, mbǝ wun nen ɗe baa wun a nen Yahudi mo kas. ");
INSERT INTO sur_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Azeen-nzeen wu man nee, nɗǝǝn ɗeret Naan, ɓe wur shin ɗak ɗesǝ nǝ nwen, mbǝkǝ nghan cìn ɗi mbǝ wun. ");
INSERT INTO sur_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Naan wur woo mbii ɗesǝsok mo nwen ɗewur kǝ ten sat nǝ wuɗin ncìn nwen. Wen kǝn ran pwoo nwun lee nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Katɗang wu tang mbii ɗe ghan kǝn ran nǝ, ɓe wun mmanshii mman fen, nkaa mbii ɗesǝsok mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Gyet nyam, ɓe baa mo woo mbii ɗesǝsok nǝ mo ngurum mo kas, amma yaksǝ ɓe Naan wur kǝ woo nǝ agaak pee jeplep Jesu Kristi mo, kǝ nensatpwoo Naan ɗeɓang mo, shi Riin wur ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Mbii ɗesǝsok nǝ a nee, nen ɗe baa mo a nen Yahudi mo kas, yaksǝ nɗǝǝn pwoo ɗeret nǝ, ɓe mo kat ɗeret mǝ Naan ashak kǝ nen Yahudi nǝ mo. Kǝzak yaksǝ, ɓe nen ɗe baa mo a nen Yahudi mo kas, mo ɗee a mbii ɗemǝndong. Mo mak sekop nɗǝǝn mbii ɗe Naan wur kǝ ten cweer nǝ, nwur gam nǝ nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","A mbee pwoo ɗeret ɗesǝ, ɓe Naan wur nle kǝ ghan ɗee a ngucìn ɗak wur, nciit kǝ zuum ɗeret mǝ yit naajeel wur ɗewur kǝcin nwen, ɗe nǝ nkaa cìn ɗak nɗǝǝn ɓal wur. ");
INSERT INTO sur_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Koo ɗe ghan a ɗetaakat met jir nɗǝǝn nen Naan mo, amma Naan wur cin ɗak ɗesǝ nǝ nwen, ɗe nǝ satpwoo ɗeret nǝ mbǝ nen ɗe baa mo a nen Yahudi mo kas. Pwoo nkaa long Kristi ɗe baa nǝ kǝ peekyes kas. ");
INSERT INTO sur_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Kǝzak, mbǝkǝ nghan le kǝ gurum mo manshii mbii ɗesǝsok mǝ Naan mo ɗi, ɗe Naan ɗewur le mbii mo nɗǝǝn nyil nǝ jir, ɓe wur kǝ ten sok mbii ɗesǝ nǝ mbee ɓit mo ɗes. ");
INSERT INTO sur_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Pan wur ɗesǝ nǝ, yaksǝ nɗǝǝn nendǝm nɗang wur mo, ɓe ɗeɗes mǝ seen wur nǝ ɗee agaak nɗǝǝn ar mo shini-shini, pǝ nenlep Naan mo kǝ iiko ɗe mo nɗǝǝn ɗengnaan ");
INSERT INTO sur_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Nciit-nciit kǝ mbii ɗe Naan wur kǝ ten sat nee, wuɗin ncìn nǝ shindǝm ngaa-ngaa, ɗewur gam nǝ nɗǝǝn ɓalkaa fun ashak kǝ Kristi Jesu Daa fun. ");
INSERT INTO sur_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Kǝ shinzeen fun nɗǝǝn wur, ɓe mu katɓal mpǝtuup, kǝ mu dǝm ɗe ntoom Naan, baa a shi kǝǝrmuut kas. ");
INSERT INTO sur_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Wen kǝn ɗang pǝ wun, taji kwak fuu mo murep kas, mbǝɗe jir shawaajeel ɗe an nkaa shwaa nǝ a mbǝ wun. Shwaajeel fen nǝ kǝkoop nǝ pee wun ɗi. ");
INSERT INTO sur_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","A mbǝmǝnǝ, ɓe an kǝn kurum ntoom puun, ");
INSERT INTO sur_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","a mbǝ wur, ɓe koo a weyi ɗe mo nɗǝǝn ɗengnaan kǝ ɗe mo nɗǝǝn nyil ɗesǝ moo kat sǝm wur. ");
INSERT INTO sur_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Wen kǝn ɗang pǝ Naan nɗǝǝn long wur ɗeɗes, mbǝkǝ wur shin iiko ɗe nwun nɗǝǝn Riin wur. Mbǝkǝ nwun katɓal ɗe nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Mɓe kǝ Kristi wur tong nɗǝǝn pǝtuup fuu mo, mbǝɗe wu shinzeen wur. Wu shamseen, kǝ nwun ɗar nkaa kuk ɗe nǝ a wal. ");
INSERT INTO sur_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Mbǝkǝ nwun, ashak kǝ nen Naan mo, ɓe wu man kaam, kǝ shwal, kǝ wurang, kǝ jurum mǝ wal mǝ Kristi ɗi. ");
INSERT INTO sur_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Kǝzak, mbǝkǝ wu man wal mǝ Kristi ɗe nǝ met nkoor man mo jir, mbǝkǝ wu gam ɗi kǝ man Naan nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Yaksǝ, pee wur, ɗewur kǝ iiko ɗe nǝ cìn ɗak nɗǝǝn mun, met mbii ɗe mu mak ɗang mo, koo pan ɗe mo nɗǝǝn pǝtuup fun. ");
INSERT INTO sur_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Ɗeɗes nǝ ɗee a mǝ Naan nɗǝǝn nendǝm ndang wur mo, kǝ nɗǝǝn Kristi Jesu mbǝ pǝ mo jir, yool yaksǝ kǝ, har ngaa-ngaa. Nǝ a kǝsǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Wen ɗe an a shishoot mbǝ sǝm Daa. Wen kǝn ɗang pǝ wun, mbǝkǝ wu mwaan-mwaan ɗe mo lapshak kǝ petpee ɗe Naan wur kǝ pǝrep wun mbǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Wu sham kǝ káa fuu mo koo pǝranyi. Wu cìn mbii mo nɗǝǝn ɗyen, kǝ wun gung zak. Wu kám wal fuu mo agaak, kǝ nwun fwangshak zak. ");
INSERT INTO sur_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Wu gung, kǝ nwun tap ɗe kǝ ɓalkaa ɗe Riin wur shin nwun, shi tongryang ɗe nǝ ɓàl wun ashak. ");
INSERT INTO sur_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Shin nǝ a mǝndong, kǝ Riin nǝ mǝndong ɓejee. Kaaɗi mo kǝ pǝrep wun, nɗǝǝn canciin mǝndong nkaa mbii ɗe mo kǝ pet wun mbǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Daa a mǝndong, shinzeen nǝ a mǝndong, baptisma nǝ a mǝndong, ");
INSERT INTO sur_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Naan a mǝndong, ɗewur a puun fun jir. Wur met mbii mo jir, kǝ a wur cìn ɗak nɗǝǝn mun jir, kǝ a wur nɗǝǝn mun jir zak. ");
INSERT INTO sur_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Ɗang koo a weyi nɗǝǝn mun, ɓe wur kǝ lap ɗeret nciit-nciit kǝ zuum kǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Kaaɗe mo kǝ ran nɗǝǝn ɓǝǝt haal Naan sǝ nǝnee, <<Kaaɗe Kristi wur kaa aɗeng, ɓe wur pan kǝrem ɗeyiyak mo ɗes ashak kǝ wur, kǝ wur shin zuum ngurum mo zak.>> ");
INSERT INTO sur_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Yaksǝ, ɓe nǝnee, <<wur kaa aɗeng >> ɓe shii mǝnǝ a mii? Shii mǝnǝ nee, nshee ɓe wur sham nɗǝǝn jurum kǝ peekyes kǝ yil ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Mbǝmǝnǝ, gwar ɗe gyet wur sham, a wur a gwar ɗewur kaa aɗeng-ɗeng a kǝkyeen ɗengnaan mo, mbǝkǝ wur gam ɗeng kǝ yil jir. ");
INSERT INTO sur_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","A wur shìn zuum ngurum mbǝkǝ npak mo ɗee ɗi, a jeplep mo, kǝ npak mo ɗee a nensatpwoo Naan mo, kǝ npak mo ɗee ɗi a nenkop pwoo Naan mo, kǝ npak mo ɗee ɗi a Pasto mo, kǝ npak mo ɗee ɗi a nenkám kam mo zak. ");
INSERT INTO sur_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Wur shin zuum ɗesǝ mo, a mbǝkǝ nǝ ɗak nen Naan mo ɗe, mbǝ ɓamshak, kǝ mbǝkǝ mo ɗyik fwoshik kǝ Kristi ɗi. ");
INSERT INTO sur_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Nǝ aasǝ, ɓe mun jir, mun nyool mu ɗee a ɗemǝndong nɗǝǝn shinzeen fun, kǝ man fun ɗe nǝ nɗǝǝn Làa Naan. Mun nyool mu ɗee a nen ɗe kǝ man mo, Mbǝkǝ mun wul mbǝ gam ɗeɗes mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Ɓe baa mu kuɗi a jep ɗeɗyeen mo kas mǝnǝ, ɗe mo nnum mun shindǝm sǝ, Mbǝkǝ mo mang mun pán, shi koo a kyaan kám ɗeɗangyi kas. Mo a nenseen mo ɗe mo a korong mbǝ ɓǝrǝm ɗung. ");
INSERT INTO sur_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Akoppee mǝnǝ nǝ ret kǝ mun sat zeen nǝ nɗǝǝn nwal. Nǝ ret kǝ mun wurang nɗǝǝn mbii mo jir, nɗǝǝn Kristi ɗewur a káa fun. ");
INSERT INTO sur_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","A mbǝ wur, ɗangɓe koo a ɓeep ɗeɗangyi, mo shini-shini, mo tap ɓàl ashak, kǝ koo a peeɓal ɗeɗangyi, nǝ katɓal a nɗǝǝn wur. Katɗang koo a ɓeep ɗeɗangyi nǝ kǝ cìn ɗak war rǝret, ɓe fwoshik nǝ nwurang, kǝ nǝ ɗyik set ɗi nɗǝǝn nwal zak. ");
INSERT INTO sur_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","nƊǝǝn sǝm Daa, ɓe nkǝn satpwoo wun shiɓal nǝ, taji wu sat a ntong kaa nen ɗe baa mo a nen Yahudi mo kas sǝ, ɗe pan mo a ɗebuu. ");
INSERT INTO sur_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Pan ɗe nɗǝǝn pǝtuup mo, nǝ a mǝ peenkwoo, baa mo kǝ mee lǝɓet nɗǝǝn seen ɗe Naan shin kas, mbǝɗe baa mo kǝ mee man kas, kǝ mo ɗee a nencinshik mo. ");
INSERT INTO sur_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Baa mo kuɗi kǝ naashweep kǝ mee mbii kas. Mo fes shínkáa fur mo mbǝ cìn mbii ɗebish mo, kǝ moo coor mbǝ cìn koo a mbii ɗebish ɗeɗangyi. Baa moo kǝ mee yaasut kas. ");
INSERT INTO sur_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Amma baa a mbii ɗe wun wu kám pee Kristi ɗe mǝnǝ kas! ");
INSERT INTO sur_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Mo sat nnǝ, wuu ten wu kǝlǝng pwoo nkaa wur, kǝ mmoo kám nwun zeen ɗe nǝ nɗǝǝn Jesu. ");
INSERT INTO sur_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Wu shwat suk ɗesǝǝr nǝ mo wu baa kǝ mo aku, ɗe dǝ moo nnum wun nɗǝǝn coor mǝ nan sǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Nǝ a tǝng kǝ npǝtuup fuu mo kǝ pan fuu mo ɗee a ɗepwoo, ");
INSERT INTO sur_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Kǝzak, nǝ a tǝng kǝ wu jwal fwoshik ɗepwoo nǝ mo, ɗe Naan wur ɗak mǝnǝ shikaa fin sǝ, kǝ nǝ woo káa nnǝ agaak nɗǝǝn seen ɗe nǝ azeen-nzeen ɗe nǝ a ɗeret kǝ ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Mbǝmǝnǝ, wu baa kǝ ɗung nɗǝǝn wun, kǝ koo a weyi ɓe wur sat azeen ngǝnǝǝn wur ɓejee ɗak. Mbǝɗe mun a ɗemǝndong kǝ shak nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Katɗang wu langtuup, ɓe taji wu cìn shikbish kas. Taji puus shamru, ɓe wun ɗe nkaa langtuup kas. ");
INSERT INTO sur_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Taji wu shínpee ngujwaan kas. ");
INSERT INTO sur_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Ngwe ɗe wur cìn wat, ɓe taji wur baa cìn ɗe kas, ɗangɓe nǝ ret kǝ wur cìn ɗak ɗeret shi sar wur, mbǝkǝ wur mak cin mee mbii ɗe nen ɗe mo mɓut njeel ");
INSERT INTO sur_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Taji pwoo ɗebish mo put nɗǝǝn pwoo fuu mo kas, ɗangɓe ɗang a mbii ɗeret mo, ɗe mon nɗyik wun, kaaɗi nǝ tap ret kǝ pee nǝ sǝ. Mbǝkǝ nǝ jì ɗe kǝ ɗeret nen ɗe moo kǝlǝng nǝ. ");
INSERT INTO sur_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Taji wu wàt pǝtuup nRiin Ɗeɓang mǝ Naan kas, wur ɗe a wur ɗee a langtǝng nǝ, wuu ɗee a ɗe fufwang mbǝ parpuus ɗe mon mɓam wun. ");
INSERT INTO sur_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Wu pwat kǝ pwoo ɗeɗeet mo, kǝ ciishak, kǝ tuup, kǝ ɓutbish, kǝ fǝlǝppee ashak kǝ cìn nyang mo jir. ");
INSERT INTO sur_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Ɗang nǝ ret kǝ nwun naajeel shak, kǝ nwun ɓam shak, kǝ nwun fwo ɗi nshak, kaaɗi Naan wur fwo ɗi nwun nɗǝǝn Kristi sǝ. ");
INSERT INTO sur_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Kaaɗe wun a jep Naan mo ɗewur wal wun sǝ, ɓe nǝ a tǝng kǝ nwun kám shiimwaan Naan. ");
INSERT INTO sur_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Kǝzak, wu mwaan nɗǝǝn wal, kaaɗe Kristi wur wal mmun sǝ, ɓe wur shìn kaashin mbǝ mun kaa zuum kǝ mbiizuum ɗe nǝ kǝ toos shang shang pǝ Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Taji pwoo nkaa ngaa, kǝ mbii ɗebish mo, kǝ rǝɓet mbii mo pwat nɗǝǝn pwoo fuu mo kas. Mbǝɗe pwoo nkaa kaan kǝ mǝnǝ mo, baa nǝ ret kǝ mo pwat mpwoo nen Naan mo kas. ");
INSERT INTO sur_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Kǝsǝ zak, taji mee pwoo ɗebish mǝ le naashweep kǝ pwoo mǝ mwen mo, kǝ pwoo ɗebuu mo, mo pwat nɗǝǝn pwoo fuu mo kas, amma wu yit kǝn plang put pwoo fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Taji wu mundǝr nee, nen ɗe moo cìn ngaa, kǝ nen ɗe pan mo a ɗebish, kǝ ngutǝlǝk mo, ɓe baa mee kaan nen mǝnǝ moo mee lǝɓet mǝ sekop nɗǝǝn mulki Kristi kǝ mǝ Naan kas. ");
INSERT INTO sur_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Taji wu yit kǝ mee gurum nnum wun shi pwoo ɗebuu mo kas, mbǝɗe a mbǝ mbii mo kaa ɗesǝ mo ɓe tuup Naan nǝ taa nkaa nencii kǝlǝngpee mo. ");
INSERT INTO sur_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Mbǝmǝnǝ, taji wu ɓalkaa fuu ashak kǝ nen mǝnǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Gyet nyam, wun a nɗǝǝn peenkwoo, ɗangɓe yaksǝ wun a nɗǝǝn peeɓang, nɗǝǝn Daa. Nǝ ret kǝ wu mwaan kaa nen ɗe mo nɗǝǝn peeɓang nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Ɗak nen ɗe mo nɗǝǝn peeɓang, nǝ a nɗǝǝn mbii ɗeret mo, kǝ ɗe ndǝre mo, kǝ zeen zak. ");
INSERT INTO sur_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Wu gung, kǝ nwun kám mbii ɗe mon nret nNaan nyit. ");
INSERT INTO sur_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Taji wu lesar fuu mo nɗǝǝn ɗak ɗe mo a mǝ peenkwoo, ɗe baa mo kǝkoop nǝ kas, ɗangɓe nǝ ret kǝ wu woo ɗak mǝnǝ mo agaak. ");
INSERT INTO sur_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Nǝ a mbii naashweep mbee satpwoo nkaa mbii ɗe moo cìn mo a sǝsok. ");
INSERT INTO sur_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Ɗang katɗang jir mbii ɗe nǝ agaak, a pee ɗe ɓang ɗi, ɓe nǝ nɗee a ɗe gurum mo mak naa nǝ. Mbǝɗe jir mbii ɗe gurum mo mak naa nǝ, ɓe nǝ a nɗǝǝn peeɓang. ");
INSERT INTO sur_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Nǝ a kaaɗi mo kǝ ran nɗǝǝn ɓǝǝt haal nNaan sǝ nǝnee, <<Ngusaam, a mii, a yool a peemúut Mbǝkǝ Kristi wur shin peeɓang ɗe ngha>> ");
INSERT INTO sur_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Wu tap kǝ shiimwaan fuu mo. Taji wu mwaan kaa mwen mo sǝ kas, ɗangɓe wu mwaan kaa nen ɗe kǝ seen mo sǝ. ");
INSERT INTO sur_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Wu cìn ɗak koo a pee ɗeɗangyi, mbǝɗe teer ɗe yaksǝ nǝ mo gam kǝ mbii ɗebish mo. ");
INSERT INTO sur_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Mbǝmǝnǝ, ɓe taji wu ɗee a mwen mo kas, amma wu manshii kǝ mbii ɗe Daa wur rǝɓet kǝ nwun cìn. ");
INSERT INTO sur_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Taji wu shwaa am anab kǝ nǝ yuur wun kas, mbǝɗe mǝnǝ mak jwaan wun, amma wu ɗee a ɗegǝgam shi Riin Ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Wu sat mee pwoo kǝ shak shi kook ɗe mǝ kwoop mo, kǝ kook ɗe mo a mǝ Riin. Wu cìn kook ɗeret mo nNaan, kǝ pǝlang nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Koo pǝranyi ɓe wu plang Naan puun mbǝ mbii mo jir nɗǝǝn sǝm nDaa fun Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Wu shin ɗeɗes ndǝr shak, mbǝkǝ wu shin ɗeɗes ɗi nKristi. ");
INSERT INTO sur_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Mat mo, wu shin ɗe ɗeɗes mmish fuu mo, kaaɗi wuu cìn nDaa sǝ. ");
INSERT INTO sur_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Mbǝɗe mish wur a káa mat, kaaɗi Kristi wur a káa Ekǝlisya sǝ, shii kǝ mǝnǝ a fwooshin fin kǝ wur shikáa fin a Nguɓam war zak. ");
INSERT INTO sur_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Kaaɗe Ekǝlisya war ndǝr Kristi, nǝ aasǝ zak, wun mat mo, wu shin ɗeɗes mmish fuu mo nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Mish mo, wu wal mmat fuu mo, kaaɗi Kristi wur wal Ekǝlisya nǝ sǝ, har wur shinkaa shin mbǝ war. ");
INSERT INTO sur_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Mbǝkǝ wur le war ɗee ɗi a ɗeɓang shi vwang war kǝ am, kǝ pwoo Naan. ");
INSERT INTO sur_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Mbǝkǝ wur ɗak Ekǝlisya nǝ le ɗe nshin, nɗǝǝn ɗeɗes, kǝ ɗemen, baa ashak kǝ mee rap, kǝ mee pee taakat mɓut mo kas. Mbǝkǝ mo ɗee ɗe a ɗeɓang baa kǝ mee rap kas. ");
INSERT INTO sur_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Ni ret kǝ mish mo wal mmat fur mo kaa sut sǝ. Ngwe ɗewur wal mmat wur, ɓe wur wal a nshin mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Baa mee gurum kǝ cam cii shin kas, ɗangɓe wur tap shin mbiise nnǝ, kǝ wur tap kǝ nǝ rǝret, kaaɗi Kristi wur cìn Ekǝlisya sǝ ");
INSERT INTO sur_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Mbǝɗe mun a ɓeep mǝ foshik nwur. ");
INSERT INTO sur_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","A mbǝmǝnǝ, ɓe gurum wur nyit puun wur kǝ nǝǝn wur, kǝ wur ɓalkaa ɗe ashak kǝ mat wur, kǝ mo vǝl mo ɗee ɗi a ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Ɗesǝ nǝ a mee mbii ɗeɗes ɗesǝsok. Mbii ɗe wen kǝn sat nǝ, a nkaa Kristi kǝ Ekǝlisya. ");
INSERT INTO sur_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Jir arang ɓe wu yit koo weyi wur wal mmat wur, kaa kaashin sǝ, kǝ mat war shin ɗeɗes mmish war zak. ");
INSERT INTO sur_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Jep mo, wu kǝlǝng pwoo mpuun fuu mo nɗǝǝn Daa, mbǝɗe mǝnǝ a mbii ɗe ndǝre. ");
INSERT INTO sur_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","<<A shin ɗeɗes mpuun fwa kǝ nǝǝn fwaa mo,>> ɗesǝ nǝ a Wàar ɗenshee ɗe mo kǝ ten le, ");
INSERT INTO sur_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","<<mbǝkǝ a tong ɗi ryang, kǝ mbǝkǝ a kat teer mo ɗi ɗes nɗǝǝn nyil nǝ.>> ");
INSERT INTO sur_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Puun mo, taji wu le kǝ pǝtuup jep fuu mo wat, kǝ nǝ le kǝ mo cìn tuup kas, amma wu kyeer mo, kǝ wu kar mo nɗǝǝn kám ɗe mo a mǝ Daa Naan. ");
INSERT INTO sur_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Kǝrem mo, wu kǝlengpwoo nen ɗe moo ɗyel wun nsar fur mo. Kǝn sat a puun fuu ɗe mo a mǝ yil ɗesǝ nǝ. Wu kǝlengpwoo mo nɗǝǝn kǝǝr kǝ ɗaar shi pǝtuup mǝndong, kaaɗi wuu cìn nKristi sǝ. ");
INSERT INTO sur_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Taji wu cìn ɗak a yit gurum mo ɓejee, kǝ mo plang wun ɗe kas, amma wu cìn ɗak kaa kǝrem mǝ Kristi sǝ. Wu cìn ɗyen nNaan nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Wu cìn ɗak shi pǝtuup ɗeret, mbǝɗe wu cìn a nDaa Naan, baa a mmee gurum kas. ");
INSERT INTO sur_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Taji wu mundǝr kas nǝ, ɗak ɗeret ɗe gurum kǝ cìn mo, ɓe wur nwaa lap kwat nǝ pee Daa ɗi, koo ɗewur a kǝrem, kǝ ɗewur a laalu. ");
INSERT INTO sur_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Wun nen ɗe wun kǝ kǝrem mo wu cìn mbii ɗeret mmo zak. Taji wu wuk mo kas, mbǝɗe wu man nǝ, Daa fu kǝ moo, wur a nɗǝǝn ɗengnaan, baa wur kǝ nshwatyit kas. ");
INSERT INTO sur_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Peekyes nǝ, wu ɗar ɓalɓal nɗǝǝn Daa nɗǝǝn iiko mǝ ɗeɗes wur. ");
INSERT INTO sur_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Wu jwal leelek ɗe Naan wur shin mo wun jir, mbǝkǝ nwun mak ɗar ɗi ɓalɓal nkaa Ngujwaan kǝ gwampee wur. ");
INSERT INTO sur_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Mbǝɗe baa mu cìn lek nǝ a nkaa gurum mo, ɗe moo nan kǝ toom kas, ɗangɓe nǝ a nkaa se mishkoom, nen iiko ɗe mo a mǝ Ngujwaan mo, nkaa se mishkoom kǝ nen peeknwoo ɗe nɗǝǝn ɗengnaan mo. ");
INSERT INTO sur_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Mbǝmǝnǝ, ɓe wu jwal leelek ɗe Naan wur nshin nwun, mbǝkǝ nwun ɗar ɗi ɓalɓal nɗǝǝn teer ɗebish mo. Mbǝkǝ taji Ngujwaan wur se koorong nkaa wun kas. ");
INSERT INTO sur_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Wu ɗar ɓalɓal shi ɗak suk, kǝ ɓwoot ɓwoon fuu mo shi zeen, kǝ cìn mbii ɗe ndǝre kaa kawung ɗe nǝ tap tuur ngurum sǝ. ");
INSERT INTO sur_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Wu jwal kwoopshii nshii fuu mo, mbǝ satpwoo ɗeret, ɗe nǝn jì kǝ tongryang. ");
INSERT INTO sur_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Koo pǝrangyi, ɓe wu mang gwat ɗe nǝ a shinzeen ashak kǝ wun, mbǝ tap pas mǝ wus ɗe gwar ɗebish nǝ wur mpwas shinji nkaa wun. ");
INSERT INTO sur_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Wu mang ɓam ɗe Naan wur cìn nwun, kaa mbiikáa shool ɗe nenlek moo lep mbǝkǝ nǝ tap káa ɗi mmo sǝ. Kǝ wu ɗyel pwoo Naan nǝ, kaa kwai ɗe Riin Ɗeɓang wur shin nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Wu ɗangnaan (leshap kǝ Naan), mbǝ mbii ɗesǝ mo shidaar-shidaar nɗǝǝn Riin. Wu tong shi gongpee, kǝzak, wu gung nɗǝǝn mbii mo jir. Wu cìn ɗangnaan (leshap kǝ Naan) mbǝ nen Naan mo jir. ");
INSERT INTO sur_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Wu ɗangnaan (leshap kǝ Naan) mbǝ ghan zak, mbǝkǝ Naan wur cìn mbii ɗe wen nsat mo ɗi, kǝ mbǝkǝ ghan sat mbii ɗesǝsok mǝ pwoo ɗeret nǝ mo, ɗe shiɓal baa a shi kǝǝrmuut kas. ");
INSERT INTO sur_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","A mbǝ pwoo ɗeret nǝ, ɗang mo lep an mbǝkǝ wen sat nǝ ɗi. Ɓe wen a shishoot shi tǝsek mǝ shool yaksǝ. Jir kǝ ɗe an a shishoot, ɓe wu cìn ɗangnaan (leshap kǝ Naan), mbǝkǝ wur shinɓal ɗi nwen, kǝn satpwoo ɗeret nǝ ɗe shiɓal, kaaɗi nǝ ret kǝ wen cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tikikus ɗyemnǝǝn fun ɗe mu wal wur, ɗewur a kǝrem Daa azeen-nzeen, wur nsat mbii mo nwun jir, nkaa an, kǝ nkaa ɗak ɗe ghan nkaa cìn nǝ. ");
INSERT INTO sur_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Wen kǝn ten nlep wur shindǝm pee wun ɗe, a mbǝkǝ wur satpwoo ɗi nwun nkaa mun, mbǝkǝ nwun man tong fun ɗe, kǝ nǝ ɓam pǝtuup fuu mo ɗi zak. ");
INSERT INTO sur_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Naan puun, kǝ Daa fun Jesu Kristi shin tongryang, kǝ wal, kǝ shinzeen nɗyemnǝǝn fun mo jir. ");
INSERT INTO sur_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Ɗeret Naan nǝ ɗee ashak kǝ nen ɗe mo wal nDaa fun Jesu Kristi, shi wal ɗe baa nii peekyes kas har ngaa-ngaa.");
INSERT INTO sur_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Lepran ɗesǝ nǝ put a nsar Pool kǝ Timoti kǝrem Daa Jesu Kristi mo, shindǝm pee nen Naan, ɗe mo nɗǝǝn nyil nFilipi ɗe mo ɓalkaa fur mo ashak kǝ Kristi, jir kǝ nen ɗenan-nan mǝ Ekǝlisya mo, kǝ nenɓam mo, kǝ Bishop mo, kǝ Dikon mo. ");
INSERT INTO sur_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Naan puun fun kǝ Daa fun Jesu Kristi, mo shin ɗeret kǝ tongryang nwun. ");
INSERT INTO sur_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Wen kǝn plang Naan koo a pǝrangyi, katɗang wen yee wun, ");
INSERT INTO sur_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","nɗǝǝn ɗangnaan ɗe kǝn cìn mbǝ wun jir shidaar-shidaar, ɓe kǝn cìn nǝ a shi retnyit ");
INSERT INTO sur_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","mbǝɗe wu fes wu ɓalkaa fuu kǝ an nɗǝǝn pwoo ɗeret nǝ, yool mpuus ɗe gyet wu shee kǝlǝng nǝ jiwul cicinsǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Wen man azeen-nzeen nee, Naan ɗewur yaa cìn ɗak ɗeret ɗesǝ nɗǝǝn wun, wur nsat a ncìn nǝ har parpuus ɗe Kristi Jesu wur mbaaji. ");
INSERT INTO sur_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Wen kǝn yee wun nɗǝǝn pǝtuup fen shidaar-shidaar, mbǝmǝnǝ, ɓe nǝ ret kǝ wen kat pan mǝnǝ nkaa wun. Mbǝɗe wu ɓalkaa fuu mo kǝ an nɗǝǝn ɗeret ɗe Naan wur cin nwen. Kaaɗi yaksǝ, ɓe wen nɗǝǝn lushoot, kǝ kaaɗi gyet wen katpee mbǝkǝ wen kám ɗi ngurum mo nee, pwoo ɗeret nǝ azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Naan wur a langtǝng fen, pan ɗe ghan kǝ nǝ mbǝ wun nǝ a kaa wal ɗe Jesu Kristi shikáa wur kǝ nǝ mbǝ mun sǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Wen kǝn ɗangnaan, mbǝkǝ nwal fuu nǝ naa nwurang ɗe, kǝ mbǝkǝ wu kat man kǝ seen ɗi wun mman ɓeet mbii mo ɗe ndǝre-ndǝre. ");
INSERT INTO sur_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Mbǝkǝ nwun bǝlǝp mbii ɗe nǝ rǝret met ɗi, kǝzak, mbǝkǝ wu ɗee ɗe a ɗeɓang, ɗe baa wun kǝ mee rap kas parpuus Kristi wur mbaaji. ");
INSERT INTO sur_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Seen fuu mo gam kǝ mbii ɗeret mo azeen-nzeen, ɗe a Jesu Kristi wur mak shìn nǝ ɓejee, mbǝ le Naan a ɗeɗes kǝ kwoop wur. ");
INSERT INTO sur_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Ɗyemnaa mo, kǝn rǝɓet kǝ nwun man nee, jeel ɗe mo kat wen, ɓe nǝ le kǝ pwoo ɗeret nǝ sekyeen. ");
INSERT INTO sur_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","har shiitoon ɗe moo tap lu mishkoom nRom, kǝ pak gurum mo, mo man nǝ, wen a shishoot a mbǝ sǝm Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Pak ɗyemnǝǝn fun mo ɗes ɗe mo nɗǝǝn Daa mo waa katɓal nɗǝǝn pǝtuup fur mo, mbǝ satpwoo ɗeret nǝ shi pǝtuup mǝndong, baa a shi kǝǝrmuut kas, mbǝɗe wen a shishoot a mbǝ sǝm Jesu. ");
INSERT INTO sur_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Ii, azeen-nzeen, pak moo satpwoo ɗeret nkaa Kristi a mbǝ zuur, kǝ ɓǝlep, ɗangɓe pak moo sat a shi pǝtuup mǝndong. ");
INSERT INTO sur_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Nen ɗe moo satpwoo ɗeret nkaa Kristi shi pǝtuup mǝndong sǝ, moo sat mǝnǝ a nɗǝǝn nwal, kǝzak, mo man nǝ, wen a shishoot a mbǝɗe an kǝ ɗar ɓalɓal bǝ tap pwoo ɗeret nǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Ɗangɓe nen ɗe moo satpwoo ɗeret nkaa Kristi a mbǝ zuur sǝ, moo rǝɓet wat a pǝtuup fen, kǝ mo pan nǝ, wuɗun jì aa jeel nkaa wen nɗǝǝn lushoot nǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Baa nǝ daampee nghan kas, katɗang mo satpwoo ɗeret nkaa Kristi, koo a mbǝ mbii ɗeɗangyi, ɓe nǝ ret nwen nyit. Koo ɗe moo sat a nɗǝǝn pan ɗebish, koo ɗe moo sat a nɗǝǝn pan ɗeret, ɓe ghan nsat a nkat retnyit ɗak, mbǝɗe gurum moo kǝlǝng pwoo ɗeret nkaa Kristi jir neyi. ");
INSERT INTO sur_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Mbǝɗe wen man nǝ, shi ɗangnaan fuu mbǝ ghan, kǝ ɓam ɗe nǝ put pǝ Riin Jesu Kristi ɗi, ɓe mon nbwoot wen. ");
INSERT INTO sur_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","A ɗyen fen kǝ canciin fen ɗesǝ nǝ, baa wen cìn mee mbii ɗe nǝ njì kǝ naashweep nkaa ghan kas. Ɗangɓe rǝɓet fen, kǝ nghan satpwoo ɗeret nǝ shiɓal baa shi kǝǝrmuut kas mbǝkǝ koo a ɗeɗangyi, kǝ koo a pǝrangyi, ɓe wen shin ɗeɗes ɗe nKristi shiɓal kǝ foshik fen jir. Koo ɗe wen ɗe kǝ seen, kǝ koo ɗi wen mmuut. ");
INSERT INTO sur_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Pee wen ɗi, ɓe seen fen nǝ a Kristi, kǝ muut fen nǝ a lǝɓet zak. ");
INSERT INTO sur_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Ɗang katɗang wen sat a ntong nɗǝǝn nan ɗesǝ ɗak, ɓe ghan ncìn ɗak ɗe nǝ mɓam gurum mo. Yaksǝ baa nghan mman ar ɗe ghan mbǝlǝp kas. ");
INSERT INTO sur_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Wen ɗee a kaa kamlang a naar kǝ am sǝ. Pan ɗevǝl ɗesǝ nǝ mo dul ghan shindǝm nɗǝǝn ar mo vǝl. Wen kǝn rǝɓet kǝ ghan muut ɗe yaksǝ, mbǝkǝ ghan dǝm ntong ɗe ashak kǝ Kristi, mǝnǝ ret nwen met. ");
INSERT INTO sur_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Ɗang nǝ kǝkoop nǝ zam, mbǝkǝ nghan tong ɗi kǝ seen nɗǝǝn fwoshik ɗesǝ, mbǝ ɓam wun. ");
INSERT INTO sur_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Mbǝɗe nghan man zeen nǝ aasǝ. Mbǝmǝnǝ, ɓe wen man nee, baa nghan mmuut yaksǝ kas, nghan ntong ɗi, mbǝkǝ wen ɓam wun ɗe kǝ wu sekyeen ɗe shi retnyit nɗǝǝn shinzeen fuu. ");
INSERT INTO sur_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Mbǝkǝ katɗang wen mbaajì pee wun ɗi zak, ɓe wu kat mbii ɗe wun canpwoo ɗi kaa an, mbǝ seen ɗe wun kǝ nǝ nɗǝǝn Kristi Jesu, mbǝ tong ɗe wen ntong ashak kǝ wun nǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Nǝ a tǝng kǝ nwun mwaan a nɗǝǝn mbii ɗe pwoo ɗeret Kristi nǝ sat nnǝ wu cìn mo. Mbǝkǝ koo ɗe nghan njì naa wun, koo ɗe baa nghan nkatpee baaji naa wun kas, ɓe nghan kǝlǝng nǝ, wuu ɗar a ɗe ɓalɓal, kǝ pwoo fuu mo ɗee a ɗemǝndong, kǝ pan fuu mo ɗee a ɗemǝndong zak. Mbǝkǝ wu cìn lek ɗi ashak, mbǝ pwoo ɗeret, ɗe wuu shinzeen nǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Taji wu kǝǝr shaarlek fuu mo kas, koo dǝɓen. Ɗesǝ nǝ nkám mmo nǝ, Naan wur kǝ ten ɓam wun, ɗangɓe wur ntwe mo mbǝ shikbish fur mo. Mbǝkǝ nwun man ɗe zak nǝ, Naan shikáa wur, wur nshin korong nǝ nwun aasǝ. ");
INSERT INTO sur_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Naan wur shínpee nwun, baa a mbǝkǝ wu shinzeen ɗi nKristi ɓejee kas, ɗangɓe a mbǝkǝ wu shwaajeel ɗe mbǝ wur zak. ");
INSERT INTO sur_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Yaksǝ nwun mak cìn lek nǝ ashak kǝ an. Lek ɗesǝ nǝ a lek ɗemǝndong kǝ ɗe gyet wu naa an nkaa cìn nǝ, kǝ kaaɗe wu kǝlǝng nǝ, an ɗe a nkaa cìn lek mǝnǝ jiwul cicinsǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Katɗang seen fuu ɗe mo nɗǝǝn Jesu Kristi mo ɗee a ɗeɓal. Katɗang wal wur nǝ jwan wun, katɗang wuu shaar ashak kǝ Riin wur, katɗang wuu naajeel shak kǝcin ɗeret shak, ");
INSERT INTO sur_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ɓe wu le kǝ retnyit fen nǝ gam, kǝ pan fuu mo ɗee a ɗemǝndong kǝ wal fuu nǝ ɗee a ɗemǝndong kǝ pǝtuup fuu mo ɗee a ɗemǝndong nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Taji wu cìn mee mbii mbǝ rǝɓetkáa kǝ ɗiyeepkáa kas, ɗangɓe wu sham kǝ káa fuu mo. Wu shin ɗeɗes nshak met nkáa fuu mo. ");
INSERT INTO sur_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Taji memee fuu ɗee ntap a mbii ɗe mo a mǝkáa fin ɓejee ɗak kas, ɗangɓe wun ntap kǝ mbii mǝ nyee fuu mo zak. ");
INSERT INTO sur_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Wu yit kǝ mǝse fuu mo ɗee a kaa mǝse Jesu Kristi wur kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Jesu ɗewur a ɗemǝndong kǝ Naan, ɗangɓe baa wur lekáa fin nciit-nciit kǝ Naan kas. Ɗang baa a mbii ɗewur nyaa nǝ rip shiɓal kǝ wur ɗee ɗi kaa Naan sǝ kas. ");
INSERT INTO sur_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Ɗangɓe Jesu wur sham kǝ káa fin, har wur leshin a káa kǝrem sǝ. Mo làa wur nɗǝǝn nan kaa koor gurum mo sǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Ɗangɓe kaaɗi gyet wur ɗe nɗǝǝn nan kaa gurum sǝ, ɓe wur sham kǝ káa fin, ɗang wur shín shin mbǝ muut nkaa shiyeepyoom. ");
INSERT INTO sur_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Mbǝmǝnǝ ɓe Naan ɗiyeep wur a ɗeɗes hakyeng, kǝ wur shìn sǝm wur a nJesu, ɗe nǝ met koor sǝm mo jir. ");
INSERT INTO sur_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Mbǝkǝ nɗǝǝn sǝm Jesu, ɓe gurum mo jir nɗǝǝn ɗengnaan, kǝ nɗǝǝn nyil ɗesǝ, kǝ ndǝr nyil ɗesǝ, ɓe mon njì kurum ntoom Jesu. ");
INSERT INTO sur_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Kǝzak, koo a pwoo ɗeɗangyi, ɓe nǝ nsat nǝ, Jesu Kristi wur a Daa, mbǝ ram Naan puun. ");
INSERT INTO sur_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Mbǝmǝnǝ, wun ɗe wen wal nwun sǝ kaaɗi shidaar-shidaar ɓe wuu naa ncìn mbii ɗe dǝ wen nsat nee, wu cìn mo, ɓe an ashak kǝ wun sǝ. Ɓe wu sat a sekyeen kǝ cìn mbii ɗe gyet wen sat mo nwun ɗak. Jir kǝ ɗe baa an kuɗi ashak kǝ wun kas, ɓe wu shin ɗeɗes nNaan, kǝ wu kǝǝr wur nɗǝǝn pǝtuup fuu mo zak. Wu cìn ɗak shiɓal fuu mo, mbǝkǝ ɓam fuu nǝ ɗee ɗi a ɗegǝgam. ");
INSERT INTO sur_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Mbǝɗe a Naan ɗewur kǝ cìn ɗak nɗǝǝn pǝtuup fuu mo shidaar-shidaar. A wur kǝ le kǝ nwun cìn mbii ɗe mo ret wur nyit. Wur nshín ɓal nwun mbǝkǝ nwun cìn mbii ɗeret nǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Wu cìn mbii mo jir, baa a shi pwoo nɗoom-nɗoom kǝ ɓeetshik kas, ");
INSERT INTO sur_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","mbǝkǝ taji gurum mo naa bish fuu kas. Mbǝkǝ nwun ɗee ɗe a ɗeɓang kaa jep Naan ɗegǝgam mo sǝ, ɗe moo tong nɗǝǝn nyil ɗebish sǝ, kǝ nɗǝǝn gurum ɗe mo gam kǝ shikbish sǝ. Wu ɗee a peeɓang mɓut mmo nɗǝǝn nyil ɗesǝ nǝ, kaa peeɓang mǝ zar ɗe mo aɗeng sǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","Kaaɗi wuu satpwoo ɗeret mǝ seen nǝ mo sǝ. Katɗang wu cìn aasǝ, ɓe ghan nkatpee mbǝ leshap shi wun parpuus mǝ Kristi. Mbǝɗi parpuus mǝnǝ, ɓe nǝ nɗee agaak nee, ɗaar kǝ ɗak ɗe dǝ ghan kǝn cìn nǝ, baa nǝ a buu kas. ");
INSERT INTO sur_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Koo ɗe mon nfet ghan, kǝ mo ɗoo toom fen kaa mbiizuum ɗe shang sǝ mbǝ shinzeen fuu nɗǝǝn Naan, ɓe nǝ ret nwen nyit, kǝ nǝ shang nwen ashak kǝ wun jir. ");
INSERT INTO sur_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Nǝ aasǝ zak, nǝ ret kǝ wun, wu cìn retnyit ashak kǝ an zak. ");
INSERT INTO sur_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Katɗang Daa Jesu Kristi wur rǝɓet, ɓe wen kǝn lepan nǝ, an nlep Timoti shindǝm pee wun ɗe kǝkǝlak. Mbǝkǝ katɗang wur baaji, ɓe wen kǝlǝng pwoo ɗe nkaa tong fuu, kǝ nǝ caa an ɗi. ");
INSERT INTO sur_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Baa nghan kǝ mee ngwe kaa wur sǝ kas, ɗewur kǝ shìn shin azeen-nzeen mbǝ sekyeen fuu. ");
INSERT INTO sur_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Koor gurum nǝ mo ɗee a ncìn mbii ɗe mǝkáa fur mo ɓejee ɗak, baa mo kak sekyeen mǝ pwoo Jesu Kristi kas. ");
INSERT INTO sur_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Wun shikáa fuu wuu man tong Timoti, mbǝɗe an kǝ wur, mun a kaa puun kǝ ɗyem nwur sǝ, ɗe muu cìn ɗak ashak mbǝ satpwoo ɗeret nǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Mbǝmǝnǝ kǝn lepan, mbǝkǝ wen lep wur shindǝm pee wun ɗi kǝlak-kǝlak. kaɗang mman mbii ɗe nǝ kat an ɗi. ");
INSERT INTO sur_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Wen shinzeen nɗǝǝn Daa nee, Baa nǝ ntong ɗes kas, ɓe wur nle kǝ nghan shikáa fen wen dǝm pee wun ɗi. ");
INSERT INTO sur_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Wen kǝn pan nee, nǝ ret kǝ nghan lep Epafradaitus ɗyemnǝǝn fun, wur a shaarɗak fen, ɗewur kǝ cìn lek nǝ ashak kǝ an, shindǝm pee wun ɗi. Gyet a wun lep wur jì pee an ɗi, mbǝkǝ wur ɓam an ɗe nɗǝǝn ɗak mo. ");
INSERT INTO sur_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Gyet wur kǝ fes lepan mbǝkǝ wur naa wun ɗe jir, ɗangɓe wur kǝ pǝtuup ɗewat mbǝɗe baa gyet wur nkoom kas kaaɗi gyet wu kǝlǝng sǝ. ");
INSERT INTO sur_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Azeen-nzeen baa gyet wur nkoom kas, mbǝ gyet wur kus kǝ muut, ɗangɓe Naan wur naajeel wur. Baa Naan naa a jeel wur ɓejee kas, ɗangɓe kǝ wen jir, mbǝkǝ taji nkat pǝtuup ɗewat nkaa pǝtuup ɗewat kas. ");
INSERT INTO sur_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Mbǝmǝnǝ, wen kǝn fes nlepan, mbǝkǝ nghan lep wur shindǝm pee wun ɗi. Mbǝkǝ nwun kat retnyit ɗe mbǝ baa naa wur shi yit fuu mo, mbǝkǝ pǝtuup mǝnǝ pan saam ɗe zak. ");
INSERT INTO sur_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Mbǝmǝnǝ, wul a wur nɗǝǝn sǝm nDaa shi retnyit hakyeng. Wu shin ɗeɗes nkaan nen mǝnǝ mo. ");
INSERT INTO sur_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Gyet ɗee ɗi a lee kǝ wur muut mbǝ ɗak Kristi. Gyet wur shin seen wur, mbǝkǝ wur ɓam an ɗe, nɗǝǝn ɗak ɗe baa wun shikáa fuu wu mak cìn nǝ kas. ");
INSERT INTO sur_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Ɗyemnaa mo, mpee kyes nǝ, ɓe wu cìn retnyit nɗǝǝn Daa. Baa nǝ daampee nwen mbǝ baa ran pwoo ɗe gyet wen kǝn ten ran mo nwun kas, ɗangɓe nǝ a mbǝkǝ nǝ ɓam wun ɗe, kǝ wun tong ɗe ryang. ");
INSERT INTO sur_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Wu tap kǝ nen ɗe moo cìn mbii ɗebish, kaa as mo sǝ. Nen ɗe mo sat nee, nǝ a tǝng kǝ gurum mo can-can. ");
INSERT INTO sur_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","A mun a ɗe mo kǝ can mun, baa a mo kas. Mbǝɗe muu seyil nNaan a nɗǝǝn Riin wur, kǝ muu cìn retnyit nɗǝǝn Jesu Kristi, mbǝɗe seen fun mo a nɗǝǝn wur. Baa muu gángkáa fun a nkaa mbii ɗe gurum moo cìn, ɗe mo a mǝ nan kas. ");
INSERT INTO sur_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Katɗang ɓe ɗe kǝn rǝɓet, ɓe ɗe an mmak gángkáa fen, nkaa mbii ɗe gurum moo cìn mǝ nan nǝ. Mbǝmǝnǝ, katɗang mee gurum kǝ pan nǝ, wur kǝ mbii gángkáa nɗǝǝn nan nǝ, ɓe an met ngwar mǝnǝ hakyeng nɗǝǝn mbii ɗe mo a mǝ nan nǝ mo. ");
INSERT INTO sur_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Kaaɗi gyet mo làa an, ɓe aɓwoon ɗe kǝn wul teer pwookun, ɓe mo can ghan. Wen a ngu Yahudi, nɗǝǝn soon mǝ Benjamin. Wen a ngu Hiburu, làa nen Hiburu tyap. Katɗang a nɗǝǝn ar mǝ tap Wàar mǝ nen Yahudi mo, ɓe ghan kǝn tap Wàar nǝ a kaa nen Farisi mo sǝ. ");
INSERT INTO sur_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Gyet kǝn shin jeel nendǝm nɗang Jesu mo. Nkwang mǝ tap Wàar nnen Yahudi mo, ɓe kǝn tap Wàar nǝ mon ndǝre-ndǝre jir. ");
INSERT INTO sur_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Ɗangɓe nɗǝǝn mbii ɗe gyet wen kǝn kat mo, kaa lǝɓet sǝ, ɓe yaksǝ kǝn le mo ɗee a ɗebuu mbǝ sǝm nKristi. ");
INSERT INTO sur_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Ii, azeen-nzeen, kǝn le mbii ɗesǝ mo ɗee a ɗebuu, mbǝɗe yaksǝ, wen kǝn man ɗeɗes mǝ wal Kristi Jesu Daa fen, ɗe nǝ met mbii mo jir. Mbǝ sǝm wur, ɓe ghan kǝn fwo mbii mǝnǝ mo jir. Yaksǝ, ɓe kǝn nnaa moo ɗee a kaa pee ɗe mo ɓeer a zungtung sǝ, mbǝɗe wen cii mo jir. kǝ nghan ɗee ɗi a mǝ Kristi, ");
INSERT INTO sur_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","kǝ nghan tong ɗe nɗǝǝn wur. Baa a mbǝ ɗeret fen kas, ɗe an mak kat nǝ mbǝ tap Wàar nǝ mo kas. Ɗang a mbǝ ɗeret ɗe mu kat nǝ mbǝ shinzeen ɗe mun kǝ nǝ nɗǝǝn Kristi. A ɗeret ɗe nǝ put a pǝ Naan ɗi, ɗe nǝ ɗar a nkaa shinzeen. ");
INSERT INTO sur_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","A mbii ɗe nkǝn fes nrǝɓet nɗesǝ, kǝ nghan man Kristi ɗi kǝ Iiko nyool a peemúut nwur. Kǝ nghan shwaa pak jeel wur nǝ ɗe zak, mbǝkǝ nghan ɗee ɗe kaa wur sǝ nɗǝǝn muut wur. ");
INSERT INTO sur_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Mbǝkǝ koo ɗe a me cìn yii, ɓe wen kat yool a peemúut nǝ ɗi zak. ");
INSERT INTO sur_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Baa kǝn ten kat mbii ɗe kǝn leyit nkaa mo kas. Koo ɗe baa kǝn ɗee a ɗe ndǝre-ndǝre kas, ɗangɓe kǝn gung mbǝkǝ mbii mǝnǝ mo ɗee ɗe a mǝnǝ, mbǝɗe Kristi Jesu wur le kǝ wen ɗee a mǝ wur. ");
INSERT INTO sur_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Ɗyemnaa mo, baa an kǝn lesen nǝ, kǝn ten nkat mbii ɗesǝ nǝ mo kas, ɗangɓe mbii mǝndong ɗe kǝn cìn, wen kǝn mundǝr mbii ɗe mo kǝ ten ɗel. Yaksǝ, wen kǝn leyit fen ndǝre-ndǝre a nkaa mbii ɗe mo a tǝleng fen ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Wen kǝn gung mbǝ dǝm wul a peekyes nɗak fen, mbǝkǝ nghan lap kwat ɗe mǝ kaa aɗeng ɗe ashak kǝ Jesu Kristi, nɗǝǝn petpee ɗe Naan wur pet an nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Wu yit kǝ pan ɗesǝ, nǝ ɗee nɗǝǝn pǝtuup fun mo. Mun nen ɗe mun kǝ seen, katɗang mee mbii ɗi, ɗe baa wu manshii nǝ kas, ɓe Naan wur nkámshii nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Nǝ ret kǝ mun cin mbii mo nciit-ciit ɗe muu ten mu man nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Ɗyemnaa mo, wun jir wu mwaan nɗǝǝn shiimwaan fen, kǝzak, wu naa nen ɗe mwaan mo mo a ɗeret nɗǝǝn ar nǝ, kaaɗi mun muu ɗee a mbiikám pee wun ɗe sǝ. ");
INSERT INTO sur_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Wen kǝn ten sat mbii ɗesǝ mo nwun, yit ɗes. Yaksǝ, ɓe nghan baa sat a nǝ ɗe nwun, jir shi yitmwaa. Gurum mo ɗǝɗes nɗǝǝn wun, ɗe mo a shaarlek mǝ shiyeepmúut mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Peekyes mǝ nen ɗesǝ nǝ mo, a muut mǝ aawus ɗe baa nii peekyes kas, mbǝɗe naan mmo nǝ a ɓut mo. Baa mo kǝ mee naashweep kas. Moo ɗiyeepkáa fur mo. Mo fes le pǝtuup fur mo a nkaa mbii ɗe mǝ nyil ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Ɗang mun, ɓe tul fun nǝ a nɗǝǝn ɗengnaan. A pee ɗe muu naa Nguɓam fun Daa Jesu Kristi ɗewur ntong aɗeng sham ɗe. ");
INSERT INTO sur_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Wur mbǝ ciir kǝ mǝse fun ɗebish sǝ mo, mbǝkǝ mo ɗee ɗe kaa mǝ ram wur sǝ. Shi iiko wur ɗesǝ, ɓe wur njì kǝ mbii mo jir, kǝ mo ɗee ɗe ntoom wur. ");
INSERT INTO sur_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Mbǝmǝnǝ ɗyemnaa mo, ɗe wen wal nwun. Wen fes nrǝɓet wun, ɗe kǝn kat retnyit a shi wun, kǝ ghan kǝn cìn roop a shi wun zak. Wu ɗar ɓalɓal nɗǝǝn Daa. ");
INSERT INTO sur_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Wen kǝn satpwoo Yudiya, mo kǝ Sintiki nǝ. Nǝ ret kǝ mo tongryang kǝ shak, mbǝɗe mo jir vǝl mo a nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Wen ɗang pee waa ɗyemnǝǝn fen, ɗe muu cìn ɗak ashak, kussuk a ɓam mat ɗesǝ mo. Mbǝɗi mat ɗesǝ nǝ moo cìn ɗak ashak kǝ an nɗǝǝn satpwoo ɗeret nǝ, ashak kǝ Kelemen kǝ koor des ɗe muu cìn ɗak ashak kǝ mo jir. Nen ɗe sǝm mo a ɗerǝran nɗǝǝn ɓǝǝt haal mǝ seen. ");
INSERT INTO sur_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Wu cìn retnyit nɗǝǝn Daa shidaar-shidaar. Wen baa nsat a nǝ ɗe nwun zak nǝ, wu cìn retnyit. ");
INSERT INTO sur_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Wu yit kǝ gurum mo jir, mo naa gung fuu. Mbǝɗǝ baaji Daa nǝ wul kus. ");
INSERT INTO sur_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Taji wu yit kǝ mee mbii daampee nwun kas, ɗangɓe nɗǝǝn mbii mo jir, ɓe wu sat mbii, ɗe wuu rǝɓet mon nNaan, nɗǝǝn ɗangnaan kǝ plang. ");
INSERT INTO sur_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Tongriyang nNaan ɗe nǝ met man mo jir, nǝ tap kǝ pǝtuup fuu mo kǝ pan fuu mo, nɗǝǝn Kristi Jesu. ");
INSERT INTO sur_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Ɗyemnaa mo, peekyes nǝ, ɓe jir mbii ɗe nǝ azeen, ɗe nǝ mak shin ɗeɗes, ɗe nǝ a ɗe ndǝre, ɗe nǝ a ɗeɓang, jir a ɗe nǝ a nwal, kǝ jir mbee ɗe nǝ rit naa, jir katɗang nii mee mbii ɗeret met jir ɗe, jir ɗe nǝ mee mbii ɗe nǝ ret plang ɗe, ɓe wu cìn pan nkaa mbii ɗesǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Wu cin ɗak kǝ mbii ɗe gyet wuu ten wu kám mo, kǝ mbii ɗe gyet wuu ten wu lap mo, kǝ mbii ɗe gyet wuu ten wu naa mo, kǝ mbii ɗe gyet wuu ten wu kǝlǝng mo pee an ɗi. Naan ɗewur shin tongryang mmun, wur ntong ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Wen kat retnyit nɗǝǝn Daa hakyeng, mbǝɗe gyet wuu ɗoom mundǝr nwen, ɗangɓe yaksǝ wuu pan ghan. Azeen-nzeen, gyet wuu pan an, ɗangɓe baa gyet wu kat a pee mbǝ ɓam an kas. ");
INSERT INTO sur_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Baa nǝ, a mee mbii jee nwen kas, mbǝɗe gyet wen kǝn ten kám ar mǝ gung nɗǝǝn jir mbii ɗe ghan kǝ nǝ. Jir ɗe nǝ ɗes, kǝ jir ɗe nǝ a lee, ɓe wen kǝn tong a shi retnyit. ");
INSERT INTO sur_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Wen man mbii ɗe an cin, katɗang baa ghan kǝ mee mbii kas, kǝzak, mman mbii ɗe ghan ncìn katɗang ghan kǝ mbii mo ɗes. nƊǝǝn mbii mo jir, ɓe ghan kǝn kám mbii ɗesǝsok ɗesǝ, mbǝkǝ nghan katpee ɗar ɗe ɓalɓal, jir a nɗǝǝn ghǝɓǝl kǝ an nɗǝǝn neen. ");
INSERT INTO sur_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Wen mak cìn mbii mo jir, a nɗǝǝn ɓal ɗe Kristi wur shìn nwen shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Wen plang wun, mbǝɗe dǝ wu ɓam an nɗǝǝn jeel fen. ");
INSERT INTO sur_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Wun nen Filipi mo, wu man shikáa fuu nǝ, gyet nshee mǝ pwoo ɗeret nǝ, kaaɗi gyet an yool yit yil mMasidoniya, ɓe baa mee Ekǝlisya ɗe nǝ shínkáa war ashak kǝ an mbǝ shin zuum mo, kǝ lap zuum mo kas, ɗang a wun ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ɗang kaaɗi gyet nghan nɗǝǝn nyil nTasoloni, ɓe wuu lep ɓam shindǝm nwen nkaashak-nkaashak, baa a yit mǝndong kǝ vǝl ɓejee kas. ");
INSERT INTO sur_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Baa nǝ, a mbǝɗe an kǝn tang a mee zuum pee wun ɗi kas, ɗangɓe kǝn rǝɓet kǝ nwun wu kat lǝɓet ɗe nkaa kwat fuu mo. ");
INSERT INTO sur_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Wuu ten wu kwat ghan kǝndǝng, mbǝɗe kǝn kat mbii ɗe kǝn rǝɓet nǝ, ɗang nǝ ɗes met mbii ɗe dǝ ghan kǝn rǝɓet nǝ. Mbǝɗe nghan kǝn la zuum ɗe wu lep shinji nwen nsar nEpafradaitus. Mbiizuum fuu ɗesǝ nǝ mo, moo toos shang shang a kaa zuum ɗe gurum moo shin nNaan sǝ. Mbiizuum ɗe Naan lap ɗe mo shang nyit nNaan hakyeng. ");
INSERT INTO sur_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Kǝzak Naan fen wur shin jir mbii ɗe nǝ ret kǝ nwun kat ɗi nciit-nciit kǝ ɗeɗes mǝ long wur nɗǝǝn Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Ɗeɗes nǝ ɗee a mǝ Naan puun fun mbǝ ngaa-ngaa, Nǝ aasǝ. ");
INSERT INTO sur_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Wu tok kǝ nen Naan ɗe mo a mǝ Kristi Jesu jir. Ɗyemnaa ɗe mo ashak kǝ an, moo tok kǝ wun. ");
INSERT INTO sur_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Nen Naan mo jir moo tok kǝ wun. Met jir, a nen Naan ɗe mon ntul mishkoom ɗeɗes Siza. ");
INSERT INTO sur_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Ɗeret kǝ Daa fun Jesu Kristi nǝ tong ashak kǝ riin fuu mo jir. Nee aasǝ.");
INSERT INTO sur_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Lepran ɗesǝ nǝ put a nsar mǝnǝ Pool ɗe Naan wu kǝ ten bǝlǝp nghan mbǝkǝ nghan tong ɗe a laalep nJesu Kristi, kǝ Timoti ɗyemnǝǝn fun nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Dǝm pee nen Naan ɗe mo nɗǝǝn yil nKolosi, pee ɗyemnǝǝn fun mo ɗe mo ɓalkaa fur mo ashak kǝ Jesu Kristi. Ɗeret kǝ Naan puun fun kǝ tongryang fin ɗee ashak kǝ wun jir. ");
INSERT INTO sur_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Muu chìn ɗangnaan nNaan mɓe wun shidaar-shidaar. Kǝzak, muu naa pǝlang Naan ɗe wu a puun kǝ Daa fun Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Mbǝɗe mu kǝlǝng nǝ, shinzeen fuu nɗǝǝn Jesu Kristi nii sekyeen, kǝzak nnǝ, wuu wal nen kǝ Naan mo jir. ");
INSERT INTO sur_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Mbǝɗe wuu le pǝtuup nkaa mbii ɗe Naan wu kǝ ten ɗak nǝ le nɗǝǝn ɗengnaan, Wu kǝlǝng pwoo nkaa mbii ɗesǝ mo a nɗǝǝn pwoo ɗeret ɗe nǝ azeen ɗe di wuu ten wu kǝlǝng nǝ. ");
INSERT INTO sur_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Pwoo ɗeret ɗesǝ nǝ, nǝn nkaa mwan dǝm shipee-shipee nɗǝǝn yil ɗesǝ. Nii shin ciir kǝ pǝtuup gurum mo, ɗangɓe nii le kǝ mo chìn ɗak ɗeret mo. Yaksǝ, gurum mo ɗes, mo nkaa shinzeen ɗikǝ-ɗikǝ. Nǝ aasǝ, ɓe nǝ kǝ dǝm wul mpee fuu, ɗangɓe nǝ nkaa ciir kǝ pǝtuup fuu mo, mbǝkǝ wun chìn ɗak ɗeret mo ɗe. Yaa mparpuus ɗe di wu shee kǝlǝng nǝ, ɓe yaksǝ wu manshii kǝ nǝ azeen-nzeen, kaaɗi Naan wur le ɗeret nkaa wun sǝ. ");
INSERT INTO sur_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Wu shee kǝlǝng pwoo ɗeret ɗesǝ, a mpwoo kǝ Abafaras, ɗe muu wal nwur, ɗang wur a shaarɗak fun. Wur cìn ɗak kǝ Jesu Kristi shi pǝtuup mǝndong nnaar fuu a koppee fun. ");
INSERT INTO sur_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","A wur sat mmun pwoo nkaa nwal fuu nɗǝǝn Riin Ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Nǝ aasǝ, ɓe yool mparpuus ɗe di mu kǝlǝng pwoo mǝnǝ nkaa wun, ɓe muu ɗangnaan(leshap kǝ Naan) (leshap kǝ Naan) mbǝ wun shidaar-shidaar. Muu ɗang pǝ Naan, mbǝkǝ wur gam wun ɗe seen mǝ man ɗyen fen, man ɗe nǝ put a pee Riin wur jì ɗi. ");
INSERT INTO sur_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Man mǝnǝ le, kǝ mwaan fuu mo lapshak kǝ mǝ nen ɗe mo dǝm nɗang Jesu. Mwaan ɗe nǝ tong ɗyen nJesu. Katɗang wu mwaan a nɗǝǝn ɗyen Jesu, ɓe mǝse fuu nǝn nle kǝ wu chìn ɗak ɗeret mo, kǝ wu sat a nwurang nɗǝǝn man pwoo nkaa Naan ɗak. ");
INSERT INTO sur_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Muu ɗangnaan (leshap kǝ Naan) nǝ, Naan ɗewur ɓal met jir, wur nshínɓal nwun, mbǝkǝ wu ɗar ɗe ɓalɓal nɗǝǝn mbii mo jir. Kǝzak, koo ɗe a me cìn yi, ɓe nwun sat a ngung ɗe ɗak, kǝ nwun kat retnyit ɗi zak. ");
INSERT INTO sur_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Wu pǝlang puun fun ɗewur aɗeng, wur ɗewur wang ar nǝ mmun, mbǝkǝ mu sekop fen ɗe ashak kǝ nen fin mo nɗǝǝn pee ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Wur put kǝ mun nɗǝǝn iiko mu peenkoo, ɗangɓe wu waa mang mun ɗel kǝ mun nɗǝǝn mulki kǝ Làa fin. ");
INSERT INTO sur_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","A Làa fin, wu ang mun, ɗe nǝ kam nǝ a wur fwo shikbish fun mo mmun. ");
INSERT INTO sur_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Baa mee gwar kǝ cam naa Naan kas, amma gurum mo kǝ naa Jesu ɗe wu lapshak kǝ Naan. A wur kám tong kǝ Naan mmun agaak. Jesu wur a Làa Naan ɗenshee, ɗewur met mbii ɗe Naan wur le mo jir. ");
INSERT INTO sur_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","A nɗǝǝn Jesu, ɓe Naan wur le mbii ɗe mo nɗǝǝn yil nǝ jir. Mbii ɗe mo nɗǝǝn ɗengnaan kǝ ɗe mo nɗǝǝn yil ɗesǝ. Mbii ɗe gurum moo mak naa mo, kǝ mbii ɗe baa gurum moo mak naa mo kas. A nɗǝǝn ɗeɗes wur, ɓe Naan wur le mbii ɗe mo kǝ iiko nɗǝǝn ɗengnaan. Mbii ɗenan mo kǝ ɗeɗyeen mo nciit-nciit kǝ ɓal fur mo. A nɗǝǝn Jesu, ɓe Naan wur le mbii mo jir, kǝ mbii mo jir, a Jesu wu kǝ mo nsar, ɓe mo a mu wur jir zak. ");
INSERT INTO sur_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Pǝgyet ɗe yam-yam, ɓe Jesu wur ɗe, akuɗang Naan wur le mbii mo nɗǝǝn yil nǝ. Naan ɓàl mbii mo jir ashak a nɗǝǝn Jesu. ");
INSERT INTO sur_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","nƊǝǝn nen Naan mo, ɓe Jesu a káa mo. Koor gurum nǝ mo a foshik wur. A Jesu a káa mǝ nen dǝm ndang Naan mo. A wur a ɗenshee, zak, a wur shee yool a peemúut. Mpee mbii ɗesǝ mo, ɓe a wur a ɗenshee nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Nǝ ret nNaan nyit, ɓe wur le kǝ ɗyen fen nǝ gam, kǝ nǝ tong nɗǝǝn Jesu. ");
INSERT INTO sur_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Nǝ ret Naan nyit zak, mbǝkǝ wur waaji kǝ mbii mo jir pǝ shin ɗi nɗǝǝn Jesu. A nɗǝǝn toom ɗe Làa kǝ Naan wur ɓeer nkaa shiyeepyoom, ɗangɓe Naan wur rǝɓet waa baaji kǝ mbii mo jir, pǝ shin ɗi. Mbii ɗe mo nɗǝǝn yil ɗesǝ, kǝ ɗe mo nɗǝǝn ɗengnaan. ");
INSERT INTO sur_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Di mmee nnaar, ɓe wuu tong a jong-jong kǝ Naan, kǝ di wun a shaarlek Naan, mbǝ mbii ɗebish, ɗe di wuu cìn mo, kǝ pan fuu ɗebish mo. ");
INSERT INTO sur_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Amma yaksǝ, mbǝ muut Làa Naan, ɗe mo làa wur nɗǝǝn nan, ɓe Naan le kǝ wu ɗee a shaar fin mo, mbǝkǝ pǝtuup fuu mo ɗee ɗi a ɗeɓang, kǝ mbǝkǝ wur jì kǝ wun ɗe ntoom Naan, ɗewur a ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","A mbii ɗe Jesu cìn nwun mmǝnǝ, katɗang wu sekyeen kǝ shinzeen nɗǝǝn pwoo ɗeret nǝ. Kǝzak, katɗang wu ɗar ɓalɓal nɗǝǝn mbii ɗesǝ mo. Wu sat a nlepǝtunp, nkaa mbii ɗe wu kǝlǝng pwoo nkaa mo nɗǝǝn pwoo ɗeret nǝ. A pwoo nkaa pwoo ɗeret, ɗe moo ten sat nǝ nkòo a weyi, nɗǝǝn yil ɗesǝ. Wen Pool, ɗak fen nǝ a mbǝkǝ nghan sat ɗe ngurum mo, pwoo nkaa pwoo ɗeret ɗesǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Kaaɗe wen nkaa shwaajeel mbǝ sǝm fuu, ɓe nghan kǝ retnyit mputuup. Kaaɗe gyet Daa Jesu shwaajeel sǝ, ɓe wen zak, kǝn shwaajeel nɗǝǝn nan mbǝ sǝm kǝ nen fin mo ɗe mo a fwooshin fin. Wen shwaajeel nǝ a mbǝkǝ wen sǝǝt nkyes koor ɗak wur nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","A Naan wur bǝlǝp nghan, mbǝkǝ nghan ɗee ɗi a kǝrem mǝ nen kǝ Jesu mo, ɓe wu le ɗak ɗesǝ nǝ nsar fen mbǝ sǝm fuu. Ɗak ɗe wu le nsar fen nǝ, a mbǝkǝ nghan satpwoo fen ɗeret ɗe ngurum mo kǝdǝng. ");
INSERT INTO sur_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Pwoo ɗe wen kǝn sat ngurum mo, ɓe gyet yam, ɓe nǝ a ɗe sǝsok. Mbǝmǝnǝ ɓe baa gyet gurum mo manshii nǝ kas, amma yaksǝ Naan woo mmun agaak nen fin mo. ");
INSERT INTO sur_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Nǝ ret nNaan nyit, ɓe wu le, kǝ nen fin mo manpwoo ɗejurum ɗesǝ, ɗe nǝ a mbii aapwoo zam. Nii koop nǝ hakyeng, mbǝ gurum mo jir, koo a nɗǝǝn yil ɗeɗangyi. Pwoo ɗewur woo nǝ mmun, a nǝ, Jesu Kristi wur tong nɗǝǝn wun. Mbǝmǝnǝ, ɓe wu lepǝtuup, mbǝ parpuus ɗe wun ntong ashak kǝ wur nɗǝǝn ram fen. ");
INSERT INTO sur_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","A mbǝmǝnǝ ɓe muu satpwoo ngurum mo jir nkaa Jesu Kristi. Muu satpwoo nkòo a weyi, kǝ wur tap, kǝzak, muu kám seen ngurum mo nkaa mbii ɗesǝ nǝ mo, a mbǝkǝ koo a weyi, ɓe wur ɗee ɗe kǝ seen nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","A mbǝmǝnǝ, ɓe wen kǝn cìn ɗak shiɓal ɗe Jesu wu shin nghan, ɗang wen kǝn gung mbǝkǝ nghan kyes ɗak ɗesǝ nǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Ɗyen nghan, kǝ wun man ɗak ɗe nghan kǝn gung mɓe cìn nǝ mbǝ sǝm fuu, kǝ mɓe nen ɗe mo nɗǝǝn yil Lodisiya, kǝ jir nen ɗe baa mo kǝ cam naa an kas. ");
INSERT INTO sur_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Wen nkaa cìn ɗak ɗesǝ nǝ, a mbǝkǝ mo katɓal ɗe mputuup fur mo, mbǝkǝ mo wal ɗe nshak, mɓekǝ mo ɗee ɗe a ɗemǝndong. Ɗyeen nghan kǝ mo man jurum kǝ man nkaa Jesu hakyeng nǝ kyeet, mbǝkǝ mo manshii kǝ mbii ɗesǝ mo ɗe jir. Ɗesǝ nǝ njì kǝ ɗeret nkaa mo hakyeng. Mbii ɗejurum nǝ, a Kristi shikáa fen. ");
INSERT INTO sur_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Mo sok long mǝ seen kǝ man mo jir, a nɗǝǝn Jesu. ");
INSERT INTO sur_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Wen kǝn sat mbii ɗesǝ mo nwun, a mbǝkǝ taji mee gurum ngwom wun shi liispwoo ɗe nǝ shangkǝlǝng kas. ");
INSERT INTO sur_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Koo ɗang ɗe baa wen ashak kǝ wun nɗǝǝn nan kas, ɓe nghan ɗe ashak kǝ wun nɗǝǝn riin. Nǝ shang nghan zam, kaaɗe wen nnǝ kǝlǝng nǝ, wuu cìn mbii mo a nciit-nciit nɗǝǝn ar ɗeret, kǝzak, wuu ɗar ɓalɓal nɗǝǝn shinzeen fuu ɗe nǝ nɗǝǝn Kristi. ");
INSERT INTO sur_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Kaaɗe, wu mang Jesu Kristi kaa Daa fuu sǝ, ɓe nǝ ret kǝ wu mwaan-mwaan ɗe nǝ ret kǝ nen ɗe mo ɓalkaa fur mo ashak kǝ Jesu, moo cìn. Wu tong nɗǝǝn wur. ");
INSERT INTO sur_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Wu sham seen fu mo nɗer-nɗer nɗǝǝn nwur, wu ɗyik seen fu mo kaa wur, kǝ wun ɗeng kǝ ɓal nɗǝǝn shinzeen nwur, kaaɗe mǝ kám nwun sǝ. Kǝzak, wu pǝlang wu shidaar-shidaar mbǝ mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Wu tap, taji mee gurum ngwom wun shiman mǝ yil ɗesǝ, mbǝkǝ wu taa wu mer ɗe a ar ɗeret nǝ kas. Kyaan kǝ man ɗe nǝ put a nɗǝǝn wàar mǝ gurum mo, kǝ nɗǝǝn riin ɗebish mǝ yil ɗesǝ, baa nii put a pee Kristi ɗi kas. ");
INSERT INTO sur_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","A nɗǝǝn Jesu, ɓe muu naa gam kǝ ɗyeen Naan, kǝ tong nɗǝǝn nan nǝ zak. ");
INSERT INTO sur_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Mo shin seen nwun, a mbǝɗi wuu ɓalkaa ashak kǝ Jesu. A wur a káa kǝ mulki kǝ mɓal mo jir. ");
INSERT INTO sur_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","A nɗǝǝn wur, ɓe mo can wun, baa a can ɗe moo cìn shi sar nɗǝǝn nan kas, ɗangɓe a can ɗe Jesu Kristi wur cìn nwun ɗe nǝ put kǝ wun nɗǝǝn shikbish. ");
INSERT INTO sur_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Kaaɗe gyet mo cìn baptisma nwun, mɓe mo wum wun ashak kǝ Kristi, ɗangɓe mo waa yool kǝ wun ashak kǝ wur a peemúut. ");
INSERT INTO sur_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Gyet yam ɓe wun a ɗemumuut mɓe shikbish fuu mo, kǝ baa gyet wun a nen Naan mo kas ɗe baa moo mee waar kas. Ɗangɓe Naan shin seen nwun ashak kǝ Kristi, kǝzak, Naan kǝ fwo shikbish fun mo jir. ");
INSERT INTO sur_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Gyet yam ɓe mun a ɗemumurep mo nder wàar mǝ Naan, mbǝɗi baa gyet muu cìn mbii ɗe wàar kǝ Naan nǝ sat kas. Dangɓe yaksǝ, Naan wur mang shikbish mǝnǝ mo baa kǝnǝ aku nkaa káa fun mo, kǝ wu fwo ɗe mmun jir zak. Mbǝɗe gyet mo pwas Jesu Kristi nkaa shiyeepyoom, a mɓe shikbish fun ɗesǝ nǝ mo. ");
INSERT INTO sur_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Kaaɗe gyet Jesu Kristi muut nkaa shiyeepyoom, ɓe wur se koorong nkaa riin ɗebish mo kǝ iiko mo, wur kám ngurum mo a agaak nǝ, wur ɓal met mmo jir. ");
INSERT INTO sur_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Mbǝmǝnǝ, ɓe taji wu yit kǝ mee gurum lewàar nwun nkaa mbii ɗe wuu se, kǝ shwaa kas, koo nkaa puus ɗeɓang mo, koo nkaa mbii ɗe wuu cìn mo, mɓe tar ɗepwoo, koo nkaa puus Nookɗi. ");
INSERT INTO sur_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Mbii ɗesǝ mo ɗee a mǝ riin, ɗe gyet moo kám ngurum mo mbii ɗe mo pǝ jì akyeen. Mbii ɗe gyet moo ɗee a mǝ riin ɗesǝ nǝ, moo gam, a Kristi shikáa fin. ");
INSERT INTO sur_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Mbǝmǝnǝ, taji wu yit kǝ nen ɗe mo lesut a kaa nenɗenan mo sǝ, mo tokɗyeel ɗebish nwun kas. Nen ɗe mo sat nǝ, Naan kǝ woo mbii mo nwuɗun zuum. Mo sat nǝ, wu sham kǝ káa fuu mo mǝ ɗung, kǝzak, nnǝ wu seyil nenlep Naan mo. Nen mǝnǝ, moo roop, koo ɗe baa mo a mee mbii kas. Pan fur mo a mǝ yil ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Baa moo rǝɓet ɓalkaa fur ashak kǝ Kristi ɗe wu a káa mǝ nen mwaan ndang Naan nǝ mo kas. Ɗe a wur shínɓal mmo, ɗang a wur shin mbiise mmo zak. Jir nen ɗe moo ɓalkaa fur mo ashak kǝ Jesu, ɓe wur kǝ shínɓal mmo, mbǝkǝ mo jì ɗe ashak zak. Kǝ mbǝkǝ, mo wurang ɗe a nɗǝǝn mbii ɗe mo a mǝ Kristi, kaaɗi Naan wur rǝɓet sǝ. Ɓeep mǝ fwoshik fun moo kaat shishak, mbǝɗe mo kǝ peeɓal mo, kǝ paar mo. Nǝ a kaaɗi Kristi wu ɓàl nen mwaan nɗang wur mo, ɗe mo a shin fin sǝ. ");
INSERT INTO sur_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Kaaɗe wu murap ashak kǝ Kristi, ɓe baa riin ɗe mǝ yil ɗesǝ mon nkat ɓal nkaa wun kas. Dangɓe a me le ɗang wuu sekyeen kǝ mwaan kaa kor gurum ɗe mǝ yil ɗesǝ mo yi? A me le ɗangɓe wu cínkáa fuu nder kǝ wàar ɗe gurum sat nee, wu cìn yi ");
INSERT INTO sur_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","Kaaɗe moo sat nwun nǝ, taji wu tung mbii ɗesǝ shi sar kas. Taji wu se mbii ɗesǝ kas, kǝzak, taji wu tung mbii ɗesǝ shi sar kas. ");
INSERT INTO sur_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Kyaan kǝ wàar ɗesǝ mo, mo a kám mǝ gurum. Ɗe katɗang mo gung cìn ɗak kǝ mo, ɓe mo ɗee a ɗebuu. ");
INSERT INTO sur_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Wàar kaa ɗesǝ mo sǝ, mo kǝ lapshak kaa mo aa mee koop mǝ seen sǝ. Mɓeɗi wàar nǝ mo letǝng ngurum mo, kǝ mo seyil ɗe nɗǝǝn ar ɗeret, kǝ mo sham kǝ káa fur mo, mǝ ɗung zak, kǝ moo shínjeel ɗe nsut fur mo, ɗangɓe azeen-nzeen, baa moo mee koop nǝ kas, mbǝɗe baa moo mee ɓal ɗe mon mɓam gurum, mbǝkǝ wu tap ɗe nǝ coor mǝ nan nǝ kas. ");
INSERT INTO sur_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Mbǝɗe mo kǝ yool kǝ wun nɗǝǝn seen ashak kǝ Kristi, mpeemǝnǝ, ɓe wu le pǝtuup fuu mo nkaa mbii ɗe mo nɗǝǝn ɗengnaan, a peeɗi Kristi wur tong ɗe, nsarse kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Wu lepan fuu mo a nkaa mbii ɗe mo aɗeng. Taji wu lepan fuu mo nkaa mbii ɗe mo nɗǝǝn yil ɗesǝ kas. ");
INSERT INTO sur_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Mɓeɗi wuu murep, ɗang ɓe seen fuu ɗepwoo nǝ mo a sǝsok pee Kristi ɗe nɗǝǝn Naan. ");
INSERT INTO sur_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Katɗang Kristi ɗewur a seen fuu, wur jì put, ɓe wuwun zak, wun mput ashak kǝ wur nɗǝǝn ɗehai fin. ");
INSERT INTO sur_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Wu twe mbii ɗe mo a mǝ yil ɗesǝ, ɗe moo cin ɗak nɗǝǝn seen fuu mo jir. Mbii kaa cìn ngaa mo sǝ, kǝ mwaan ɗebish mo, kǝ coor mbii mǝ nan mo, kǝ rǝɓet mbii ɗebish mo kǝ tǝlǝk, ɗe nǝ a see nyil mee naan ɗeci. ");
INSERT INTO sur_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","A mbǝ mbii ɗebish kaa ɗesǝ mo sǝ, ɓe Naan wur woo tuup fin nkaa nenyil ɗe mo cii kǝlǝng ɗoo fin. ");
INSERT INTO sur_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Gyet wun, shikáa fuu, wuu cìn mbii ɗesǝ mo, har gyet wuu mwaan a nɗǝǝn mo. ");
INSERT INTO sur_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Ɗangɓe yaksǝ, kaaɗi wun kǝ seen ɗepwoo sǝ, ɓe nǝ ret kǝ wu shwat sar fuu mo aku, nɗǝǝn mbii ɗebish ɗesǝ nǝ mo jir. Mbii mo kaa langtuup, pan ɗebish nkaa shak, pwoo ɗebuu nkaa shak, kǝ jir pwoo ɗe baa mo kǝ mee koop nǝ kas. Taji wu baa wu cìn mo ɗe zak kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Taji wu cìn ɗung nshak kas, mbǝɗe wuu ten wu yit shiimwaan fuu ɗe gyet yam nǝ mo ɗi. ");
INSERT INTO sur_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","Mbǝmǝnǝ wu shee shiimwaan ɗepwoo ɗe Naan wu le nɗǝǝn pǝtuup fuu mo, ɗe nǝ nɗak shiimwaan fuu mo, kǝ wu ɗee ɗe kaa wu sǝ, mbǝkǝ wu man wu ɗikǝ. ");
INSERT INTO sur_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Yaksǝ, baa mee shwatnyit ɗe nnaar kǝ ngu Heleni kǝ ngu Yahudi kas, koo nnaar kǝ gwar ɗe moo can wu kǝ gwar ɗe nsuluk kas. Nnaar kǝ nenseen mo, kǝ nenyil ɗe baa moo seen kas, nnaar kǝ mǝzep mo, kǝ nenyil mo, nnaar kǝ kǝrem mo, kǝ jeplu mo. Yaksǝ ɓe gurum mo ɗee a nciit-nciit, nɗǝǝn Kristi, mbǝɗe wu met mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Taji wu muunshik nǝ, Naan wal nwun zam, har wur bǝlǝp wun, mbǝkǝ wu ɗee ɗe a nenyil fin mo. Nǝ a tǝng kǝ shiimwaan fuu mo ret, kaa jep Naan mo sǝ. Wu naajeel mǝ shak. Wu cìn mbii ɗeret nshak. Wu sham kǝ kaa fuu mo. Wu cìn mbii mo nɗǝǝn ɗyeen, kǝzak, wu gung nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Taji wu kǝlak kǝ langtuup kǝ shak kas. Kat mee gurum cìn shikbish ngǝnǝǝn, ɓe gwar ɗe mo cìn shikbish nǝ nwur, wu fwo ɗe ngucìn shikbish nǝ. Daa Naan kǝ fwo shikbish fuu mo, mpeemǝnǝ, ɓe nǝ ret kǝ wuwun, wu fwo ɗi nshak zak. ");
INSERT INTO sur_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Mbii ɗe nii koop nǝ met jir, wu wal, mbǝɗe nwal nǝ kǝ ɓàl gurum mo ashak nɗǝǝn tong ɗe mbii mo a ɗekǝgam jir. ");
INSERT INTO sur_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Wu yit kǝ tongryang mǝ Kristi, nǝ se mishkoom nɗǝǝn pǝtuup fuu mo. A mpeemǝnǝ ɓe Naan wu pǝrep wun, mbǝkǝ wu tong nɗǝǝn tongryang mǝnǝ. Wu pǝlang Naan shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Wu yit kǝ pwoo kǝ Kristi nǝ tong nɗǝǝn wun hakyeng, kaaɗi wu cìn kám, kǝ ɓamshak nɗǝǝn seen ɗe Naan wu cìn nwun sǝ. Wu kwoop Naan shi kook mo, kǝ kook ɗe mo a mǝ Riin, ɗe mo put nɗǝǝn pǝtuup fuu, ɗe Riin kǝ Naan wu cìn wun. Kaaɗe wuu koop Naan shi kook mo sǝ, ɓe nǝ ret kǝ wu pǝlang wu nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","nƊǝǝn mbii ɗe wuu cìn mo jir, koo ɗe a nɗǝǝn ɗak, ɓe wu cìn mo jir a nɗǝǝn sǝm kǝ Daa fun Jesu. Wu pǝlang Naan puun nɗǝǝn sǝm fin. ");
INSERT INTO sur_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Wun mat mo, wu shin ɗeɗes mish fuu mo, kaaɗe nǝ ret kǝ nendǝm ɗangnaan mo cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Wun mish mo, wu nwal mmat fuu mo. Taji wu tong kǝ mo a shi lek kas. ");
INSERT INTO sur_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Wun jep mo, wu kǝlǝng pwoo puun fuu mo, mbǝɗe mǝnǝ ret nNaan nyit zam. ");
INSERT INTO sur_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Wun puun mo, taji wu le kǝ jep mo langtuup kas, mbǝɗe kat wu le kǝ mo langtuup, ɓe nǝ nroop kwak mmo. ");
INSERT INTO sur_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Wun kǝrem mo, wu cìn mbii ɗe nenlu fuu mo sat nnǝ wu cìn. Taji wu cìn mbii mo a mbǝɗe moo naa wun kas, mbǝkǝ wu kat ɗeret ɗe pee mo ɓejee kas, ɗangɓe wu cìn mbii mo a shi pǝtuup ɗemǝndong, kǝ shin ɗeɗes nNaan. ");
INSERT INTO sur_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Koo ɗang ɗe ɗak fuu nǝ a meyii, ɓe wu cìn nǝ shi pǝtuup mǝndong, kaaɗe wuu cìn a nNaan sǝ, baa a mɓe gurum mo kas. ");
INSERT INTO sur_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","A Daa Jesu Kristi wu a Daa fuu. Wun nlap kwat fuu mo a pǝ wu ɗe. Kwat ɗe wu nshin nwun nǝ, a sekop ɗe wu ɗak nǝ le mɓe nenyil fin mo nɗǝǝn ɗengnaan, mbǝɗe ɗak ɗe wuu cìn nǝ, ɓe wuu seyil nDaa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Ngwar ɗe wu cìn mbii ɗebish, ɓe Daa wu nkwat gwar mǝnǝ a shi mbii ɗebish, nciit-nciit kǝ mbii ɗebish ɗe gwar mǝnǝ cìn. Baa mee shwatyit ɗe kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Wun nen ɗe wun kǝ kǝrem mo, wu fwang mo nɗǝǝn ar ɗeret, nɗǝǝn zeen zak, mbǝɗe wu man nǝ, wun ɗe kǝ mee gwar ɗeɗes zak, nɗǝǝn ɗengnaan, ɗewur kǝ fwang wun. ");
INSERT INTO sur_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Wu ɗangnaan(leshap kǝ Naan) shidaar-shidaar. Wu tong shi gongpee, kǝzak, wu pǝlang Naan mɓe mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Wu ɗangnaan(leshap kǝ Naan) mɓe mun zak, mbǝkǝ Naan wang ar ɗǝ mmun, kǝ mu satpwoo fin ɗe ngurum mo. Kǝ mbǝkǝ mu yakshii nǝ ɗe ngurum mo mbii ɗe jurum, ɗe Naan wu woo mmun nkaa Jesu Kristi. A mɓe pwoo ɗeret nǝ, ɗangɓe nghan a shishoot nɗǝǝn lushoot. ");
INSERT INTO sur_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Wu ɗang pǝ Naan, mbǝkǝ nghan satpwoo ɗeret nǝ ɗe ngurum mo agaak, kǝ mo manshii nǝ ɗi, kaaɗe nǝ ret kǝn ghan sat sǝ. ");
INSERT INTO sur_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Wu mwaan shi seen, pǝ nenyil ɗe baa mo a nendǝm ndang Naan mo kas. Wu cìn ɗak kǝ koo a pee ɗeɗangyi ɗe Naan shin wun! ");
INSERT INTO sur_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Wu yit kǝ liispwoo fuu mo shang kǝlǝng ngurum mo, kaa mbii ɗǝ mo tap le kǝǝn ɗike sǝ, mbǝkǝ wu man mbii ɗe wun nlap ɗe ngurum mo katɗang mo tal mee mbii pǝ wun. ");
INSERT INTO sur_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Tikikus satpwoo nwun, nkaa mbii ɗǝ an kǝn cìn mo jir. Wur a ɗyemnǝǝn fun ɗe muu wal wur nɗǝǝn Kristi. Wur kǝ cìn ɗak kǝ nendǝm ndang Naan mo, a shi pǝtuup mǝndong. Wen kǝ wu, mun a kǝrem kǝ Daa Jesu nɗǝǝn ɗak fin. ");
INSERT INTO sur_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Wen kǝn lep wur dǝm pee wun ɗi, a mbǝkǝ wur sat ɗe nwun mbii ɗe muu cìn mo jir, kǝzak, mbǝkǝ wu caa wun ɗi. ");
INSERT INTO sur_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Unisimus ɗewur a nguyil fuu, wur ndǝm ashak kǝ Tikikus. Mon nsat nwun mbii mo jir, nkaa an. Unisimus wu a ɗyemnǝǝn fun, ɗe muu wal nwur. Wur cìn ɗak kǝ nen dǝm ndang Naan mo a shi pǝtuup mǝndong. ");
INSERT INTO sur_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristaakus ɗewur a shishoot ashak kǝ an, wur kǝ tok kǝ wun jir. Maak kǝn kǝ Barnabas, wur kǝ tok kǝ wun zak. Wen kǝn ten ran pwoo nwun nkaa wur zak. Katɗang wur dǝm pǝ wun ɗe, ɓe wu lap wu shi pǝtuup mǝndong rǝret. ");
INSERT INTO sur_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Joshuwa ɗe moo pet wur a Jastus, wur tok kǝ wun. Das ɗekun sǝ mo, moo ɓam nghan zam. A mo a nen Yahudi ɗe moo cìn ɗak ashak kǝ nghan mpeesǝ. Muu sat ngurum mo nǝ, Naan wu a mishkoom. ");
INSERT INTO sur_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Abafaras ɗewur a nɗǝǝn wun, wur tok kǝ wun. Abafaras wu a kǝrem kǝ Jesu Kristi. Wur ɗangnaan(leshap kǝ Naan) mɓe wun shidaar-shidaar. Wur ɗang pǝ Naan, mbǝkǝ wu ɗar ɗe ɓalɓal, nɗǝǝn mbii ɗe mo a mǝ Naan, mbǝkǝ wu man mbii ɗe moo ret ɗe nNaan nyit. Kǝzak, mbǝkǝ wu kǝlǝng ɗoo fin ɗe, nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Wen shikáa fen, nghan kǝn naa, kaaɗe wur cìn ɗak ɓalɓal mɓe sǝm fuu wun ɗe wun nɗǝǝn Kolosi, kǝ ɓe nen ɗe mo nɗǝǝn Lodisiya kǝ Hirapolis. ");
INSERT INTO sur_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luka ɗewur a nguyen, ɗe muu wal nwur zam, kǝ Dimas moo tok kǝ wun. ");
INSERT INTO sur_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Wu tok kǝ ɗyemnǝǝn fun ɗe mo nɗǝǝn Lodisiya, kǝ Nimfas, kǝ nendǝm ndang Naan ɗe mo nɗǝǝn tul nwur. ");
INSERT INTO sur_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Aɓwoon ɗe mo kǝ tang lepran ɗesǝ nwun, ɓe wu le kǝ mee gurum tang nǝ nɗǝǝn nendǝm ndang Naan ɗe mon nLodisiya zak. Wu tang lepran, ɗe nendǝm ndang Naan ɗǝ mon nyil nLodisiya mon nlep shiin ji nwun zak. ");
INSERT INTO sur_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Wu sat Arkipus nǝnee, <<Wur kyes ɗak ɗe di Daa Jesu Kristi Shìn nwur, mbǝkǝ wur cìn ɗe sǝ.>> ");
INSERT INTO sur_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","A an Pool ran lepran ɗesǝ nwun shi sar fen. Taji wu muunshik nǝ, an a shishoot nɗǝǝn lushoot kas. Ɗeret Naan tong ashak kǝ wun jir. nǝ aasǝ.");
INSERT INTO sur_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Lepran ɗesǝ nǝ put a nsar Pool kǝ Silas kǝ Timoti shin dǝm pǝ nenɗǝm ndang Naan ɗe mo nɗǝǝn yil nTasoloni, ɗe nǝ nɗǝǝn Naan puun kǝ Daa Jesu Kristi. Naan cin ɗeret nwun kǝ tongryang zak. ");
INSERT INTO sur_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Koo pǝrangyi, ɓe muu pǝlang Naan mɓe wun jir, kǝzak, muu yee wun jir nɗǝǝn leshap kǝ Naan fun mo shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Muu yee wun mɓe Naan fun, ɗewur aɗeng, kaaɗe wu kám cinzeen fuu nǝ nɗǝǝn mbii ɗe wuu cìn mo. Kǝ kaaɗe wal fuu nii le kǝ wu cìn ɗak shiɓal, kǝ kaaɗe canciin fuu nkaa Jesu Kristi nǝ ɗar ɓalɓal sǝ. ");
INSERT INTO sur_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Ɗyemnaa mo, mu man nee, Naan wur wal nwun, ɗang wur kǝ ten bǝlǝp wun, kǝ wu ɗee a nen fin mo zak. ");
INSERT INTO sur_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Mbǝɗe baa gyet mu satpwoo ɗeret nǝ nwun a shi lepwoo fun ɓejee kas, amma a nɗǝǝn iiko mǝ Riin Ɗeɓang. Kǝ mun mu cinzeen nee, mbii ɗǝ mǝ sat nǝ azeen. Wu man tong fun, kaaɗe gyet mun ɗe ashak kǝ wun. Muu cìn mbii mo jir a mɓe fuu. ");
INSERT INTO sur_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Gyet wun, wuu yaa mwaan nɗǝǝn shiimwaan fun, kǝ nɗǝǝn shiimwaan kǝ Daa fun, koo ɗe wuu shwaajeel, amma nǝ a mbǝɗe wun kǝ lappwoo ɗeret nǝ shi retnyit ɗe Riin Ɗeɓang shin nwun. ");
INSERT INTO sur_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Nǝ aasǝ ɓe, wu ɗee a mbii kám nkoor nenshínzeen nJesu Kristi ɗe mo nɗǝǝn nyil mMasidoniya kǝ Akaya. ");
INSERT INTO sur_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","A mbǝ wun ɗangɓe nenyil ɗe mo kus, kǝ ɗejong mo, mo kǝlǝng pwoo Daa. Baa a mMasidoniya kǝ Akaya ɓejee kas, amma shinzeen fuu nɗǝǝn Naan nǝ dǝm wul koo pee ɗeɗangyi. Mbǝmǝnǝ, baa mun kǝ mee mbii mbǝ sat kas. ");
INSERT INTO sur_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Gurum mo, koo a nnǝyi, ɓe moo sat a wun, kaaɗe gyet wu lap mun shi pǝtuup mǝndong sǝ, kǝ kaaɗe gyet wu yit kùm fuu mo, mbǝkǝ wu seyil ɗi nNaan ɗewur kǝ seen kǝ wur azeen, ");
INSERT INTO sur_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","kǝ wuu tong shi gongpee mbǝ waaji kǝ Làa fin nɗǝǝn ɗengnaan, shii kǝ mǝnǝ a Làa nwur Jesu Kristi ɗe Naan wu yool kǝ wur a peemúut, kǝ wur ɓam mun nɗǝǝn tuup Naan ɗe nǝn a ar jì zak. ");
INSERT INTO sur_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Ɗyemnaa mo, wun wu man shikáa fuu nee, jì fun pee wun ɗe baa nǝ a buu kas. ");
INSERT INTO sur_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Wu man kaaɗe mun mu ten mu shwaajee kǝ fǝlǝp nɗǝǝn yil nFilipi, akuɗang muu jì pee wun ɗe nTasolonǝ. Koo ɗe gyet gurum mo ɗes mmo cii mun, ɗangɓe Naan fun wur shínɓal mmun mputuup, mbǝkǝ mǝ satpwoo wur ɗeret nǝ ɗe nwun. ");
INSERT INTO sur_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Pwoo ɗe mu sat nwun nǝ, baa nǝ a ɗung koo pan ɗebish kas. Baa gyet mǝ sat nǝ, a mbǝkǝ mǝ gwam mee gurum ɗe kas. ");
INSERT INTO sur_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Amma mbǝɗe Naan wur kǝ ten bǝlǝp mun, kǝ wur kǝ ten le pwoo nwur nǝ nɗǝǝn sar wur. Muu cìn kǝ mǝ tong ɗyeen ɗǝ a nNaan, ɗewur man pǝtuup fun mo jir. Baa muu cìn mbǝkǝ mutong ɗyeen ɗe a ngurum kas. ");
INSERT INTO sur_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Wu man nǝ, baa muu kam jì kǝ mee pwoo ɗeshang mmee gurum shi lǝpwoo fun mo kas, mbǝkǝ mǝ gwam wun, kǝ mǝ kat shool ɗe pee wun kas. Naan wu man nǝ aasǝ. ");
INSERT INTO sur_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Baa muu cam tang a ɗeɗes pee gurum mo ɗe kas, koo pǝ wun, koo pee nenɗeci mo. Koo ɗi mun kǝ pee mɓe cìn ɗak kǝ iiko fun kaa nenlep Kristi mo sǝ. ");
INSERT INTO sur_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Dangɓe jir kǝsǝ, ɓe gyet muu fwang wun, a kaaɗe nǝǝn kyee war fwang jep war mo sǝ. ");
INSERT INTO sur_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Mbǝɗe mǝ wal nwun zam, har gyet mu rǝɓet mbǝkǝ mǝ shin seen fun mo mɓe wun, baa a mɓe pwoo ɗeret Naan ɗe gyet mǝ sat nwun ɓejee kas. ");
INSERT INTO sur_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Ɗyemnaa mo, wu yee nɗak ɗe gyet mun mu cìn shiɓal pee wun ɗi. Gyet mun mu cìn ɗak mpar kǝ puus, mbǝkǝ taji mu lejeel nwun kas, nnaar ɗe gyet mun nkaa satpwoo ɗeret mǝ Naan nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Wun a langtǝng fun, kǝ Naan zak, Gyet shiimwaan fun mo mbǝ wun ɗi, wun ɗe wu shinzeen nǝ a ɗeɓang, ɗeret ɗang nii mee luk kas. ");
INSERT INTO sur_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Wu man nee, mu tap wun a kaaɗe puun kǝ tap jep nwur mo sǝ. ");
INSERT INTO sur_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Muu caa wun, muu ɓam wun zak, kǝzak, mun kǝ sat nǝ yit ɗes nǝ, nǝ ret kǝ wun mwaan a mwaan ɗe nǝ ret nNaan nyit. Naan ɗewur pǝrep wun, mbǝkǝ wu ɗel ɗe nɗǝǝn mulki nwur, kǝ mǝ tong ɗe ashak kǝ wur nɗǝǝn ram fin. ");
INSERT INTO sur_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Mee mbii ɗe nii le, kǝ mu pǝlang Naan shidaar-shidaar zak, gyet mǝ shee satpwoo Naan nǝ nwun, ɓe kaaɗe wu kǝleng, ɓe wu lap nǝ, baa a kaa pwoo gurum sǝ kas, amma wu lap nǝ a kaa pwoo Naan sǝ ɗang nǝ a pwoo nǝ azeen, ɗe nǝ nkaa cìn ɗak nɗǝǝn pǝtuup fuu mo, wun nen ɗe wu cinzeen. ");
INSERT INTO sur_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Ɗyemnaa fun mo, wu mwaan nɗǝǝn shiimwaan nenɗǝm ndang Naan ɗe mo a mǝ Kristi Jesu, ɗe mo nɗǝǝn yil nJudiya. Wuu nshwaajeel nsar nenyil fuu mo, kaaɗe gyet mu shwaajeel nsar nen Yahudi mo sǝ. ");
INSERT INTO sur_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Gyet a nen Yahudi nǝ mo tu Daa Jesu, kǝ mo twe nensatpwoo Naan mo. Mo ceen mun zak. Baa mbii ɗe mo cìn nǝ ret nNaan nyit kas koo lee. Kǝzak, mo a shaarlek gurum mo jir. ");
INSERT INTO sur_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Mbǝɗe moo yaappee, mbǝkǝ mo cíi satpwoo ɗeret nǝ ɗe mmun, mɓe nen ɗe baa mo a nen Yahudi mo kas, mbǝkǝ taji mo kat seen ɗe zak. A nɗǝǝn ar ɗesi ɓe, mo gam shi ɓutbish fur ɗe moo naa ncìn nǝ, amma yaksǝ tuup Naan nii taa nkaa mo jir. ");
INSERT INTO sur_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Ɗyemnaa mo, kaaɗe gyet mu ɓàkshak kǝ wun, mɓe rep pee lee, yaksǝ nǝ daampee mmun, koo ɗe a yit fun mo ɓàkshak ɗak, ɓe pǝtuup fun moo pan wun ɗe shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Ɗyeen mmun naa yit fuu mo zam. Muu fes mǝ rǝɓet dǝm pee wun ɗe zam. An Pool, kǝ lepan fen mbǝ dǝm pee wun ɗi met nyitvǝl, amma nGujwaan ɗar a ar nǝ. ");
INSERT INTO sur_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","A me a mbii canciin fun, kǝ retnyit fun, ɗe nǝ kám nnǝ, muu se koorong nyit Daa fun Jesu, parpuus ɗewur mbaajì yii? Baa a wun kas aa? ");
INSERT INTO sur_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","A wun a nen ɗe wu le kǝ mu kat retyit kǝ nǝ nshang mmun parpuus ɗe mun nnaa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Mbǝmǝnǝ, kaaɗe baa mu mak gung kǝ kas. Nǝ aasǝ, ɓe rǝɓet fun nǝ, mun koor nǝ mo, mun ntong Afens mbusun, ");
INSERT INTO sur_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","kǝ mǝ lep Timoti shinɗǝm pee wun ɗe. Timoti wur a ɗyemnǝǝn fun nɗǝǝn ɗak Naan, mu satpwoo ɗeret nkaa Jesu Kristi. Mu lep wur shinɗǝm pee wun ɗi, mbǝkǝ wur caa pǝtuup fuu mo ɗe, kǝ wur kám ɗǝ nwun, kǝ wu ɗar ɗi ɓalɓal nɗǝǝn shinzeen fuu. ");
INSERT INTO sur_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Mbǝkǝ taji jeel ɗe wun nkaa shwaa nǝ lee, kǝ memee fuu baa mɓwoon kas. Wun wu man nnǝ, Naan wu kǝ ten lee nnǝ, mun nen fin mo mun nshwaajeel. ");
INSERT INTO sur_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Kaaɗe gyet mun ɗe ashak kǝ wun, ɓe muu sat nwun nnǝ, nǝ a tǝng mun jir mun nshwaajeel. Yaksǝ wun nkaa naajeel nǝ, kaaɗe gyet muu ten mu sat nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Gyet wen man nnǝ, wun nkaa shwaajeel, a nǝ le ɗangɓe nghan lep Timoti dǝm pee wun, mbǝkǝ ghan man ɗe. Kyet wuu ɗar ɓalɓal nɗǝǝn shinzeen fuu nǝ wo? Baa di wen kuɗi kǝn mak gung kas mbǝɗe kǝǝrmuut ɗoom yaa an. Wen yee nee, meeɓe ngujwaan wur kǝ cǝǝr kǝ wun, mbǝkǝ ɗak ɗe gyet mu cìn nnaar fuu, ɓe nǝ a ɗee buu. ");
INSERT INTO sur_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Yaksǝ Timoti wur kǝ jì pee mun ɗi. Wur satpwoo ɗe nǝ ret mmun nyit, kaaɗe wuu ɗar ɓalɓal nɗǝǝn shinzeen fuu nɗǝǝn Jesu Kristi, kǝ wal fuu nǝ ɓal zak. Wur sat mmun nee, wuu yee mun shidaar-shidaar shi retnyit, kǝ nnǝ ɗyeen nwun nnaa mun kaaɗe ɗyeen mmu nnaa wun sǝ zak. ");
INSERT INTO sur_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Ɗyemnaa mo, kaaɗe mu kǝlǝng nee, shinzeen fuu nii sekyeen, ɓe koo ɗe mun nkaa shwaajeel, kǝ mbii mo ɗes moo daampee mmun, ɓe ɗesǝ nǝ, fes ɓam pǝtuup mmun zam. A shinzeen fuu nǝ ɓam pǝtuup fun mo. ");
INSERT INTO sur_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Yaksǝ mun nkat gangkwak, katɗang wu ɗar ɓalɓal nɗǝǝn Daa Jesu. ");
INSERT INTO sur_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Mu pǝlang Naan ɗeɗes hakyeng mɓe wun, kǝ mu kat retnyit a kyeen nwur mɓe wun. Mu pǝlang wur mɓe retnyit ɗe mu kat ntoom Naan fun, mɓe wun. ");
INSERT INTO sur_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Muu naa ncìn ɗangnaan (leshap kǝ Naan) shidaar-shidaar, par kǝ puus, mbǝkǝ, katɗang mǝ katpee, ɓe mun njì pee wun ɗe, kǝ mǝ naa wun ɗe shi yit fun. Kǝ mǝ ɓam wun ɗe, nɗǝǝn mbii ɗe moo luk wun nɗǝǝn shinzeen fuu nǝ. ");
INSERT INTO sur_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Muu ɗangnaan (leshap kǝ Naan) nee, Naan puun fun shikáa nwur, kǝ Daa fun Jesu Kristi wur nwang ar nǝ mmun, kǝ mu dǝm pee wun ɗi. ");
INSERT INTO sur_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Daa wur le kǝ wu sekyeen kǝ wal kǝ koor gurum mo jir, kaaɗe muu wal nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Mbǝkǝ wur gangkwak ɗe nwun nɗǝǝn pǝtuup fuu mo, mbǝkǝ shiimwaan fuu nǝ ɗee ɗe a ɗeret, kǝ ɗeɓang nyit Naan ɗewur a puun fun jir, parɗe Daa fun Jesu Kristi wur njì nɗǝǝn yil ɗesǝ ashak kǝ nen nwur ɗeɓang mo jir. ");
INSERT INTO sur_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Ɗyemnaa mo peekyes nǝ, muu ɗang pǝ wun nɗǝǝn sǝm nDaa Jesu. Wu kám shi mun, caan kǝ mwaan ɗe mun muu cìn, mbǝkǝ nǝ gam ɗyeen Naan ɗe. Azeen, wuu ten wu yaa kyeet kǝ mwaan mǝnǝ, naa tǝng wun sekyeen nɗǝǝn mwaan mǝnǝ ɗikǝ ɗikǝ. ");
INSERT INTO sur_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Wu man kám ɗe gyet mu cìn nwun nɗǝǝn ɓal Daa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Naan wur rǝɓet kǝ wu ɗee a ɗeɓang. Taji wu ɗel nɗǝǝn shikbish ɗe nǝ a mǝ ngaa kas. ");
INSERT INTO sur_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Koo weyi nɗǝǝn wun, ɓe nǝ ret kǝ wur man kaaɗe wur yaa kaa fin ɗi nɗǝǝn ar ɗǝɓang, ɗe nǝ ret. ");
INSERT INTO sur_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Baa a shi coor mǝ nan kas, kaaɗe nenkum ɗe baa mo man Naan kas, moo cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Taji mee gwe cìn mbǝɗe bish nkaa ɗyemnǝǝn nwur kas, mbǝɗe Daa wur cii nen ɗe moo cìn kaan mbii mǝnǝ mo jir. Muu ten mu satpwoo nwun shiɓal nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Baa Naan wur pet mun a mbǝkǝ mu ɗee ɗi a nɗǝǝn shikbish kas, amma kǝ mǝ ɗee ɗi a ɗǝɓang. ");
INSERT INTO sur_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Mbǝmǝnǝ kat mee gurum cii kám ɗesǝ mo, ɓe baa gwar mǝnǝ cii a gurum kas, amma wur cii a Naan, ɗewur shìn Riin nwur Ɗeɓang nwun. ");
INSERT INTO sur_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Baa nii mee kwoop nǝ kǝ nghan ran mee mbii nwun, nkaa wal nɗyemnǝǝn fuu mo kas, mbǝɗe Daa Naan shikáa nwur, wur kǝ ten kám nwun kaaɗe wun nwal nshak zak. ");
INSERT INTO sur_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Azeen, wu wal nenɗǝm nɗang Jesu Kristi ɗe mo nɗǝǝn Masidoniya jir, amma muu ɗang pǝ wun ɗyemnaa mo, mbǝkǝ wu sekyeen ɗe kǝ wal ɗikǝ ɗikǝ, mɓe mo jir. ");
INSERT INTO sur_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Wu gung kǝ wu mwaan ɗi shi mǝse mǝ pǝɗok, wu tap kǝ mbii ɗe wun pǝ cin mo, ɗang wu cìn ɗak shi sar fuu mo, kaaɗe gyet mu sat nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Katɗang wu cìn mbii ɗe mǝ sat nwun sǝ mo, ɓe nen ɗe baa mo shinzeen nDaa Jesu kas, mon nshin ɗeɗes nwun, kǝ baa wun ntaa wu kat mɓut mme mbii kas. ");
INSERT INTO sur_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Ɗyemnaa mo, mǝ rǝɓet kǝ wu man mee mbii hakyeng, nkaa nen ɗi mo kǝ ten murǝp mo, mbǝkǝ taji pǝtuup fuu mo wat, kaa nen ɗi baa mo shinzeen nyool a peemúut nǝ sǝ kas. ");
INSERT INTO sur_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Mun mu shinzeen nee, Jesu kǝ muut, kǝ wur kǝ baa yool a peemúut. Mbǝmǝnǝ, ɓe mu man nee, katɗang Jesu wur njì, ɓe Naan wur nle kǝ nen ɗe mo kǝ murǝp nɗǝǝn Jesu, ɓe mon njì ashak kǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Pwoo ɗe muu sat nwun sǝ, nǝ put a pee Daa ɗe shikáa nwur. Katɗang Daa Jesu wur njì nɗǝǝn yil ɗesǝ, ɓe mun nen ɗe mǝ kuɗi mmeen, baa a mun ntaa tǝleng, nen ɗe mo kǝ ten murǝp mo kas. ");
INSERT INTO sur_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Parpuus mǝnǝ, ɓe Daa wur nɗyeep ɗoo shiɓal, kǝ ngulep Naan ɗeɗes, wur ntàa feer. Ɗangɓe Daa Jesu wur nyool yit ɗengnaan kǝ wur sham ɗe nɗǝǝn yil ɗesǝ. Nen ɗe mo kǝ ten murǝp nɗǝǝn Kristi, a mon nshee yool a peemúut nǝ. ");
INSERT INTO sur_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Mun nen ɗǝ mu kuɗi mmeen nɗǝǝn yil ɗesǝ, ɓe Naan wur nlap mun kàa kǝ mun nɗǝǝn nluu, mbǝkǝ mukaat ɗikǝ Jesu nnaar kǝ ɗengnaan. Yool mmǝnǝ ɓe mun ntong ashak kǝ Daa har ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Mbǝmǝnǝ, ɓe wu caa pǝtuup nshak shi pwoo ɗesǝ mo. ");
INSERT INTO sur_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Ɗyemnaa mo, baa nii mee kwoop nǝ, kǝ mu ran mee mbii nwun nkaa parpuus kǝ peeɗi Daa Jesu wur njì kas. ");
INSERT INTO sur_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Wuu ten wu man pwoo nkaa nǝ. Wun shikáa fuu, wuu ten wu man nee, parpuus mǝnǝ ɓe Daa wur njì a kaa wat ɗe kǝ jì mpar sǝ. ");
INSERT INTO sur_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Nciit kǝ mǝnǝ, ɓe gurum mon mɓwet sut, ɗang mon nsat nǝnee, << <<Koo meyii, ɓe nǝ ɗe ryang, kǝ mbii mo ɗi rǝre.>> Ɗangɓe, ndi mman, mee jeel kǝ shwal ntaa nkaa mo, kaa shwal ɗe mat moo kǝlǝng nǝ, kaaɗe mo pǝ làa-làa sǝ. Parmǝnǝ ɓe baa mee gwar mbar kas koo mǝndong. ");
INSERT INTO sur_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Amma wun ɗyemnaa fen mo, baa wun a nɗǝǝn peenkoo kas. Mbǝmǝnǝ taji parpuus mǝnǝ ɗee nwun a mbii aapwoo, kaaɗe jì kǝ wat aapwoo ngurum mo sǝ kas. ");
INSERT INTO sur_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Wun jir, wun a nen ɗe mo nɗǝǝn peeɓang, ɗe wuu mwaan mpuus, baa wun a nen ɗe nɗǝǝn peenkwoo mo kas, ɗe muu tong nɗǝǝn peenkwoo sǝ kas. ");
INSERT INTO sur_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Mbǝmǝnǝ, taji wu saam kaaɗe koor gurum moo cìn sǝ kas, amma mu yaasun, kǝ mǝ tong ɗi shi gongpee. ");
INSERT INTO sur_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Gurum moo saam a mpar, kǝ gurum moo yuur a mpar, ");
INSERT INTO sur_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","amma mun, muu mwaan a mpuus. Mbǝmǝnǝ ɓe mǝ yaasun fun mo. Mu sat a nsekyeen nɗǝǝn shinzeen, kǝ wal nɗǝǝn Daa Jesu. Mbǝɗe ɗesǝ mo a kaa nlǝr shool, ɗe shiitoon moo lep mɓe gong tuur mmo, mbǝkǝ taji mee mbii tung mo kas sǝ. Kǝzak, wu yit kǝ mu sat a nleyit nkaa Daa Jesu ɗǝ wur ɓam mun. Mbǝɗe leyit ɗesǝ nǝ ɗee a kaa mbiikáa shool ɗe kǝ fwang káa ngurum nɗǝǝn lek sǝ. ");
INSERT INTO sur_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Mu man nǝ, Naan wu bǝlǝp mun, baa a mbǝkǝ mǝ ɗel ɗe nɗǝǝn jeel kǝ tuup nwur kas, ɗangɓe wur bǝlǝp mun a mbǝkǝ mu kat ɓam ɗe nɗǝǝn Daa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Wur ɗewur muut, mbǝkǝ katɗang wur mbaajì, ɓe koo ɗe mu kuɗi mmeen nɗǝǝn yil nǝ, kǝ koo ɗe muu ten mu murǝp, ɓe mun ntong ashak kǝ nwur. ");
INSERT INTO sur_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Mbǝmǝnǝ wu gangkwak nshak, kǝ wu ɓamshak kaaɗe wuu pǝ ncìn nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Ɗyemnaa mo, mu ɗang pǝ wun kǝ wu shìn ɗeɗes nen ɗe moo cìn ɗak pee wun ɗi. Muu sat a nen ɗe moo fwang wun kǝ kam wun nɗǝǝn kǝǝr nDaa. ");
INSERT INTO sur_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Wu shìn ɗeɗes mmo hakyeng, kǝ wu wal mmo zak, mbǝ ɗak ɗe moo cìn nǝ. Wu tongryang kǝ shak jir. ");
INSERT INTO sur_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Ɗyemnaa mo, muu ɗang pǝ wun, mbǝkǝ wu gwak nenseer mo, ɗe sar fur mon nfii. Wuu gang pǝtuup nen ɗe moo kǝǝrmuut mo, kǝ wu ɓam nen ɗe baa moo ɓal kas, kǝ wu gung kǝ shak jir zak. ");
INSERT INTO sur_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Wu tap, mbǝkǝ taji mee gwar kwat ɗebish shi ɗebish kas, amma wu gung kǝ wu cìn ɗeret ɗe nshak kǝ gurum mo jir, koo pǝrangyi. ");
INSERT INTO sur_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Wu cìn retnyit koo pǝrangyi. ");
INSERT INTO sur_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Wu ɗangnaan (leshap kǝ Naan) shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","nƊǝǝn mbii mo jir, ɓe wu pǝlang Naan, mbǝɗe nii ret nNaan mbǝ wun nen ɗe mo kǝ ɓal wun kǝ Jesu Kristi, kǝ wun cìn zak. ");
INSERT INTO sur_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Taji wu cíi cìn ɗak nRiin Naan ɗe wu nɗǝǝn wun kas. ");
INSERT INTO sur_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Taji wu ɓákpwoo ɗe mo put a pǝ Naan ɗi kas. ");
INSERT INTO sur_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Wu kam mbii mo jir, mbǝkǝ wu man ɗi nǝ azeen ɗe. Wu yaa mbii ɗe mo a ɗeret. ");
INSERT INTO sur_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Taji wu cìn mee mbii ɗebish kas koo le. ");
INSERT INTO sur_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Wen cìn ɗangnaan (leshap kǝ Naan) nǝ, Naan shikáa fin, wur ɗewur cìn tongryang nwun, wu nle kǝ wu ɗee a ɗeɓang nɗǝǝn mbii mo jir. nƊǝǝn riin fuu mo, kǝ seen fuu mo, kǝ suk fuu mo, mbǝkǝ wu ɗak suk fuu mo ɗe, mɓe puus jì Daa Jesu Kristi, ɓe baa wun nɗen kǝ mee yitluwaan (naasheep) kas. ");
INSERT INTO sur_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Naan ɗewur pǝrep wun agu cinzeen baa wur mmak ɓam wun kas. ");
INSERT INTO sur_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Ɗyemnaa mo, wu cìn ɗangnaan (leshap kǝ Naan) mɓe mun. ");
INSERT INTO sur_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Wu tok kǝ nen cínzeen nǝ mo jir shi tokshik ɗǝɓang, wu yaa sar nshak nɗǝǝn wal ɗe nǝ a mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","nƊǝǝn sǝm kǝ Daa, ɓe an kǝn satpwoo nwun shiɓal nee, nǝ a tǝng wu tang lepran ɗesǝ nǝ nkom nen cínzeen nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Ɗeret Daa fun Jesu Kristi nǝ tong ashak kǝ wun. Nǝ aasǝ.");
INSERT INTO sur_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Lepran ɗesǝ nǝ put a nsar Pool kǝ Silas, kǝ Timoti. Muu tok kǝ nenɗǝm ndang Naan ɗe mon nTasoloni, ɗe mo a mǝ Naan puun fun kǝ Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Naan puun fun kǝ Daa Jesu Kristi mo shín ɗeret nwun kǝ tongryang zak. ");
INSERT INTO sur_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Ɗyemnaa mo, nǝ a tǝng kǝ mu pǝlang Naan mɓe wun shidaar-shidaar. Nǝ ret kǝ mun, mu pǝlang wun aasǝ zak, mbǝɗe cinzeen fuu nǝ nkaa wurang hakyeng, kǝzak, wal fuu mbǝ niyee fuu mo nii seet ɓuɓul ɗak. ");
INSERT INTO sur_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","A nǝ le ɗang mun shikáa fun muu canpwoo shi wun nenɗǝm ndang Naan mo, mbǝ gung fuu, kǝ shinzeen fuu, kaaɗe wuu ɗar ɗi ɓalɓal jir kǝ ɗe wuu gung kǝ shinjeel kǝ shwaajeel ɗe wuu shwaa mo shini-shini. ");
INSERT INTO sur_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Mbǝ mbii ɗe wuu shwaajeel nǝ mo yaksǝ, parmee puus ɓe mon nkat wun kǝ kwoop nǝ mbǝ mulki Naan. Ɗesǝ mo ɗee a langtǝng mɓe kám nwun nee, ");
INSERT INTO sur_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Naan a ngucanɗyeel ɗen ndǝre ndǝre. Mbǝmǝnǝ, wur nshìnjeel nen ɗe mo shínjeel nwun. ");
INSERT INTO sur_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Wur nshìn nookɗi nwun kǝ mun jir nɗǝǝn jeel ɗe muu shwaa mo yaksǝ. Mbii ɗesǝ mon nɗen aasǝ parɗe Daa fun Jesu wur ntong nɗǝǝn ɗengnaan sham. Wur nkámkáa fin ashak kǝ nenlep nwur ɗeɓal mo. ");
INSERT INTO sur_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Wur njì shi wus ɗe nii bǝlempee, mbǝkǝ wur kwat nen ɗe mo cii Naan ɗe, kǝ nen ɗe mo ciipwoo ɗeret nkaa Daa fun Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Kwat mo nǝn nɗee a muut ɗel dǝm kǝ mo ngaa-ngaa. Baa mon mmak naa yit Naan koo ɗeɗes mǝ iiko nwur kas, koo le. ");
INSERT INTO sur_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Katɗang wur njì, parpuus ɗeɗes mǝnǝ, ɓe nen nwur mo jir, mon nshin ɗeɗes nwur. Jir nen ɗe mo shinzeen nwur, ɓe mon nkwoop wur, kǝ wun zak wun nɗee nɗǝǝn nen ɗe mon nkwoop wur, mbǝɗe wuu ten wu shinzeen mpwoo wur ɗe mun kǝ sat nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Mbǝmǝnǝ ɓe muu ɗangnaan (Leshap kǝ Naan) mɓe wun shidaar-shidaar, mbǝkǝ Naan wur le kǝ wu ɗee ɗekoop nǝ, mɓe zeen ɗe Naan wur pǝrep wun mbǝmǝnǝ. Naan wur le kǝ wu mak cìn koo a mbii ɗeret ɗeɗangyi ɗe wuu pan cìn nǝ mɓe shinzeen fuu shiɓal nwur. ");
INSERT INTO sur_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","A nɗǝǝn kaan kǝ ar ɗesǝ, ɓe gurum mon nle ram nsǝm Daa Jesu nɗǝǝn wun, kǝ wun ɗe nɗǝǝn wur zak, shi ɗeret Daa Naan fun kǝ Daa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Pwoo nkaa ji nDaa fun Jesu Kristi, kǝ kuur fun pee wur ɗe. Ɗyemnaa mo, mu ɗang pǝ wun, ");
INSERT INTO sur_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","taji pan fuu mo ɗee a ɗecicǝǝr koo nǝ daampee nwun kas. Mbǝɗe pak gurum moo sat nee, puus Daa nii ten ji. Koo ɗe gurum mo sat pwoo mǝnǝ a nɗǝǝn Riin, nnǝ puus nii ten ɗel, koo a shi liispwoo nǝ, mo aasǝ. Koo kaaɗe pak mo nkaa sat nǝ, nǝ di mu ran pwoo nwun, nkaa nǝ aasǝ nɗǝǝn pwoo ɗe di mu ran nwun sǝ. ");
INSERT INTO sur_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Taji wu le kǝ mee gurum ngwam wun kas, koo le. Baa puus nǝ kǝ waaji kas, atǝng nnaar ɗe gurum mon ncíi tuwap kǝ mo cii Naan, nǝn nshee dì akuɗang, kǝ gwar ɗebish, ɗewur ɗee a ɗelǝloom, ɗe mon nvwet wur nɗǝǝn wus, wu njì put agaak akuɗang zak. ");
INSERT INTO sur_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Wun ncìn lek nkaa mbii ɗe gurum mo kǝ seyil mmo jir, kǝ wur nlekáa fin a kaa Naan sǝ. A wur nsat nee, wuɗi met mmo jir, kǝzak wur nɗel nɗǝǝn Lu Naan ɗeɗes, kǝ wur ntong a peetong, ɗangɓe wur leshin a Naan. ");
INSERT INTO sur_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Baa wu pan kas aa? kaaɗe gyet mun ashak kǝ wun sǝ, ɓe wen kǝn ten nsat nwun nee, mbii ɗesǝ mo jir mon nɗen aasǝ. ");
INSERT INTO sur_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Yaksǝ ɓe, a mee mbii kǝ yaa wur baa kǝnǝ. Wun shikáa fuu, wu man mbii mǝnǝ. Katpee nǝ wul, ɓe gwar ɗebish wur njì put agaak. ");
INSERT INTO sur_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Jurum kǝ ɓal kǝ ngwar ɗebish nǝ nkaa cìn ɗak yaksǝ nɗǝǝn yil ɗesǝ nǝ. Ɗangɓe mee ngwar kǝ yaa wu baa kǝ nǝ mɓe reppee ɗeɓen ɗak. Katɗang mo mang ngwar ɗe nii yaa wur baa kǝnǝ, ");
INSERT INTO sur_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","ɓe ngwar ɗebish nǝ wur njì put. Dangɓe Daa Jesu wur ntu ngwar ɗebish nǝ shi nook kǝ pwoo fin. Katɗang Daa Jesu wur mbaajì nɗǝǝn ɗeɗes fin. ");
INSERT INTO sur_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Katɗang ngwar ɗebish wur njì put, ɓe wur njì a nɗǝǝn ɓal mǝ ngunjwaan. Wun ngwam gurum mo shi mbii aapwoo mo ɗes ɗewur ncìn mo. ");
INSERT INTO sur_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Wur ncìn ɗak kǝ koo mbii ɗebish ɗeɗangyi, mbǝkǝ wu ngwam nenyil ɗe mon nloom ɗe. Nen ɗesǝ mo ɗee a ɗelǝloom mbǝɗe di mo cii shinzeen, kǝ mo cii wal nzeen. Mbǝmǝnǝ, ɓe baa mo kat ɓam kas. ");
INSERT INTO sur_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Aasǝ ɓe, Naan cǝǝr kǝ pan fur mo, mbǝkǝ mo shinzeen ɗe a mbii ɗǝ nǝ a ɗung ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Mbǝmǝnǝ, ɓe mon nɗee a ɗelǝloom, mbǝɗe mo cii shinzeen atǝng mo kǝlǝng shang mǝ cìn shikbish ɗak. ");
INSERT INTO sur_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Ɗyemnaa fun mo, Daa wu wal nwun. Mbǝmǝnǝ ɓe nǝ ret kǝ mu pǝlang Naan mɓe wun. Naan wur ten bǝlǝp wun, pǝgyet ɗi nshee, mbǝkǝ wur kat ɓam wur ɗe nɗǝǝn ɓal Riin fin ɗeɓang, ɗewur le wu ɗee a nen fin ɗeɓang mo shi shinzeen nɗǝǝn mbii ɗe nǝ azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Naan wu pǝrep wun, mbǝkǝ wu tong ɗe ashak kǝ Daa Jesu nɗǝǝn ram fin, mɓe pwoo ɗeret ɗe mun kǝ sat nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Mbǝmǝnǝ ɗyemnaa mo, wu ɗar ɓalɓal, kǝ wu yaa mbii ɗe gyet mu kám mo ɗe, koo ɗe gyet mǝ sat a shipwoo, kǝ koo ɗe gyet mu sat a shi lepran ɗe gyet mǝ ran mo nwun zak. ");
INSERT INTO sur_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Daa fun Jesu Kristi shikáa nwur, kǝ Naan puun fun moo ɓam pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Kǝ wur shínɓal nwun, mbǝkǝ wur cìn koo a ɗak ɗeɗangyi, kǝ pwoo ɗeret ɗe wuu sat zak. ");
INSERT INTO sur_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Ɗyemnaa fun mo, pwoo ɗe muu rǝɓet sat mǝ kyes nǝ a nee, muu ɗang pǝ wun, mbǝkǝ wu ɗangnaan (leshap kǝ Naan) ɗe mbǝ mun. Mbǝkǝ pwoo Naan nǝ kaatpee mo ɗe, kǝ mbǝkǝ gurum mo lap nǝ ɗi kǝkoop, kaaɗe gyet wun wu lap nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Kǝzak, wu cìn ɗangnaan (leshap kǝ Naan) mɓe mun, mbǝkǝ Naan wur ɓam mun ɗe nɗǝǝn sar kǝ nen bish mo, ɗe pǝtuup fur mo a ɗe ɗeet. Baa a gurum mo jir, mo shinzeen mpwoo nǝ kas. ");
INSERT INTO sur_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Dangɓe Daa wur kǝ ɗar nkaa zeen. Wur nshin ɓal nwun kǝ wur tap fwang wun aku nsar ngujwaan. ");
INSERT INTO sur_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Mu shinzeen nDaa ɓe wun, nǝ, wu cìn mbii ɗe mu sat mo ɗe, kǝ wuu sekyeen kǝ cìn mo zak. ");
INSERT INTO sur_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Daa wur nle kǝ wu man wal Naan ɗeɗes mɓe wun, kǝ gung kaaɗe Daa Jesu gung sǝ zak. ");
INSERT INTO sur_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Ɗyemnaa mo, nɗǝǝn sǝm kǝ Daa Jesu Kristi, muu sat nwun shiɓal nee, taji wu ɓalkaa kǝ ɗyemnǝǝn fun ɗe mo a seer mo kas. Shii kǝ mǝnǝ, a nen ɗe baa moo mwaan nkaa kám ɗe gyet mu kám nwun kas. ");
INSERT INTO sur_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Wun shikáa fuu, wu man nee, nǝ ret kǝ wu mwaan nɗǝǝn shiimwaan fun, mbǝɗe gyet mun ashak kǝ wun, ɓe baa gyet muu tong kǝ sar fun mo nfii kas, ");
INSERT INTO sur_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","kǝ baa muu se mbiise nsar mee ngwar zuum kas, amma muu cìn ɗak shiɓal kǝ sar fun mo mpar kǝ puus, mbǝkǝ taji mu lejeel mmee ngwar nɗǝǝn wun kas. ");
INSERT INTO sur_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Gyet mun kǝ iiko mbǝkǝ mǝ sat nwun nnǝ wu shin mbiise mmun, ɗangɓe baa gyet mu tal pǝ wun kas, mɓeɗi gyet mu rǝɓet kám nwun ar ɗe wun ncìn ɗak shi sar fuu mo. ");
INSERT INTO sur_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Kaaɗe gyet mun ɗe ashak kǝ wun, ɓe muu naa nsatpwoo nwun shiɓal nǝ, katɗang baa mee gurum cìn ɗak kas, ɓe taji wu shín mee mbii nwur se kas. ");
INSERT INTO sur_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Mu kǝlǝng nee, pak mo nɗǝǝn wun, moo ɗee a seer mo. Nnǝ baa moo cìn mee ɗak kas, amma nnǝ, moo ɗee mwaan buu, mbǝkǝ mo lep pwoo ɗe nɗǝǝn ɗak kǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","nƊǝǝn sǝm kǝ Daa Jesu Kristi, muu satpwoo shiɓal nee, nǝ ret kǝ nen mǝnǝ mo nook mwaan mǝnǝ, mbǝkǝ mo cìn ɗak, ɗe mon nkat mbiise mukáa fur mo ɗi, mbǝ pwoo fur mo. ");
INSERT INTO sur_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Ɗyemnaa mo, taji kwak fuu mo murǝp mbǝ cìn ɗak ɗeret kas. ");
INSERT INTO sur_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Katɗang mee ngwar cii cìn mbii ɗe mu sat nɗǝǝn pwoo ɗesǝ, ɓe wu naa gwar mǝnǝ rǝret. Taji wu cìn mee mbii ashak kǝ wun kas, mbǝkǝ naashweep yaa gwar mǝnǝ ɗi. ");
INSERT INTO sur_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ɗangɓe taji wu naa wur a kaa shaarlek sǝ kas, ɗangɓe wu fwang wur kaa ɗyemnǝǝn sǝ. ");
INSERT INTO sur_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Daa Jesu shikáa fin, ɗe ryang kǝ put a pee wur ɗi, wur shìn tongryang nwun nɗǝǝn mbii mo jir. Daa Jesu tong ashak kǝ wun jir. ");
INSERT INTO sur_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Ɗesǝ a sar ran mǝnǝ Pool, ɗe an kǝn le nǝ nɗǝǝn pwoo ɗe moo put pee ghan ɗi. Wen kǝn ran aasǝ. ");
INSERT INTO sur_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Ɗeret kǝ Daa fun Jesu Kristi nǝ tong ashak kǝ wun jir. Nǝ aasǝ.");
INSERT INTO sur_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","A ghan Pool kǝrem nDaa Naan, kǝ laalep mǝ Daa Jesu Kristi, ran wasika ɗesǝ nǝ. A Jesu wur bilip ghan, mbǝkǝ nghan ɓam nen ɗe Naan wur kǝ ten bilip mo, mbǝkǝ shinzeen mo wurang ɗe nɗǝǝn Naan, kǝzak, mbǝkǝ mo man zeen nǝ ɗe jir nkaa ar kǝ Naan. ");
INSERT INTO sur_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Kǝ mo leyit fur mo ɗe nkaa seen ɗe nǝ azeen, ɗe ngha-ngha. Naan ɗe baa wur cìn ɗung kas, wur kǝ ten sat nǝ, wur shin seen mǝnǝ ngurum mo. ");
INSERT INTO sur_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Nciit-nciit kǝgam pee nǝ, ɓe wur nwoo seen ɗesǝ nǝ agaak shi pwoo wur, ɗewur kǝ ten le nǝ nsar fen. A Naan ɗewur ɓam mun, a wur a ngwe ɗewur ten lep nghan, mbǝkǝ ghan satpwoo wur ɗe ngurum mo. ");
INSERT INTO sur_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Wen nkaa ran wasika ɗesǝ nghan Titus, làa fen ɗe azeen-nzeen nɗǝǝn shinzeen, ɗe mun kǝ nǝ vǝl. Ɗeret, kǝ ryang pee Naan puun nJesu Kristi Nguɓam fun, mo tong ashak kǝ waa. ");
INSERT INTO sur_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Mbii ɗe nǝ le kǝ nghan yit waa nyil nKrit, a mbǝkǝ gha sǝǝt a ɗak mbii mo ɗe ndǝre-ndǝre, kǝ gha bilip nennan mo ɗe mbee jir lu nNaan ɗeɗang ghi, ɗe nǝ nɗǝǝn nyil nKrit. Taji a mundǝr mbii ɗe dǝ nsat nghan kas. ");
INSERT INTO sur_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Jir we ɗe a bilip kaa ngunan sǝ, ɓe nǝ a tǝng kǝ gwar mǝnǝ kǝ mǝse ɗeret, ngwe ɗewur kǝ mat a mǝndong ɓejee ɗak. Kǝ jep wur mo zak, nǝ a tǝng kǝ mo ɗen a nen ɗe mo shinzeen. Ngwe ɗe mǝse wur nǝ mak le kǝ gurum mo naa nǝ, baa wur a ngucìn mbii ɗebish kas, kǝzak, baa a ngukáaɓál kas. ");
INSERT INTO sur_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Jir a wii ɗewur a ɗeɗes nɗǝǝn nendǝm ndang Naan mo, ɓe wur naa a mbii ɗe mo a mǝ Naan. Mbǝmǝnǝ, ɓe mǝse wur nǝ a tǝng kǝ nǝ ɗee a ɗeret. Baa wur nɗee a nguroop, jir a ngwe ɗe mbii kǝkǝlak làa wur mɓut kas. Baa wur nshwaa am anab (filip) kǝ nǝ yuur wur ɗe kas, baa wur a nguɓwanbish kas. Baa wur a ngurǝɓet mbii mbee kat lǝɓet ɗebuu kas. ");
INSERT INTO sur_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ni ret kǝ wur ɗee a ngula gurum mo nɗǝǝn tulu wur. Nǝ a tǝng kǝ wur wal mbii ɗeret mo. Nǝ ret kǝ wur ɗee a ngwe ɗe mwaan wur nǝ a ndǝre-ndǝre, kǝ mǝse wur nǝ ɗee a ɗe nǝ shang nNaan zak. Nguyaashin. ");
INSERT INTO sur_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","A ngwe ɗewur ɗar ɓalɓal nɗǝǝn shinzeen ɗe mu kám nǝ, mbǝkǝ wur mak kám ɗe ngurum mo zak. Mɓe kǝ mo katɓal ɗe nɗǝǝn pǝtuup fur mo, kǝzak, mbǝkǝ wur man mbii ɗewur nkám ɗe nen ɗe moo satpwoo ɗebuu mo, kǝ wur kám ɗe mmo, pee ɗe mo taa ɗel ɗe. ");
INSERT INTO sur_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Gurum mo ɗǝɗes, ɗe mo a nen tǝkook kǝ pee met jir, ɓe a pak nen Yahudi ɗe mo ɗee a nendǝm nɗang Kristi. Mo sat nǝ, jir nen ɗe mo ɗee a nendǝm nɗang Daa Jesu, ɓe tǝng mo can mo akuɗang, kaaɗi nen Yahudi moo cìn sǝ zak. Mo a nen satpwoo ɗebuu moo, cìn ɗung ɗe ngurum mo zak. ");
INSERT INTO sur_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","A le kǝ mo ɗok tǝtǝk, mbǝɗe moo kám a mbii ɗe baa nǝ ret kǝ mo kám kas, mbǝkǝ mo kat lǝɓet ɗebuu ɗe nɗǝǝn cìn mbii ɗebish. Mo nkaa dǝm ntul mo ɗes nɗǝǝn ar ɗebish. ");
INSERT INTO sur_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Mee gurum wur ɗe mɓut nen Krit nǝ mo, ɗewur leshin a kaa ngusatpwoo Naan sǝ, wur sat nǝ, <<Nen Krit mo a nenɗung mo, a kaa luwayil mo sǝ, nenrǝɓet mbii mo, kǝ seer zak.>> ");
INSERT INTO sur_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Pwoo ɗesǝ nǝ azeen. ");
INSERT INTO sur_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Taji mo lekom mbee kǝlǝng pwoo ɗebuu mǝ nen Yahudi mo, kǝ Wàar gurum mo, ɗe mo cii zeen zak kas. ");
INSERT INTO sur_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Katɗang pǝtuup gurum mo a ɗeɓang, ɓe mbii mo jir, mon nɗee a ɗeɓang pee nen mǝnǝ mo ɗe zak. Ɗang nen ɗe pǝtuup mo a ɗebish kǝ ɗe baa mo kǝ shinzeen kas, ɓe baa mee mbii ɗe nǝ a ɗeɓang pee mo ɗe kas, mbǝɗe pan mo a ɗebish, baa mo man mbii ɗeret kas. ");
INSERT INTO sur_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Mo lekáa fur mo, a kaa nen ɗe mo man Naan sǝ, ɗangɓe mbii ɗe moo cìn nǝ, nǝ kám ngurum mo nǝnee, baa mo man Naan kas jir dǝɓen. Mo a nencii gurum mo, nencii kǝlǝngpee mo, baa mo mak cìn mee mbii ɗe nǝ ret kas jir dǝɓen. ");
INSERT INTO sur_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Ɗang waa, a kám ngurum mo mbii ɗe mo a nɗǝǝn kám ɗe nǝ azeen-nzeen. ");
INSERT INTO sur_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","A kám nen ɗekukun mo nǝnee, << nǝ ret kǝ mo ɗee a nen ɗe mo ya sut, kǝ mo le pǝtuup fur mo ɗar a pee mǝndong. Taji mo ɗee ntan kas, ɗangɓe mo ɗee a nen ɗe mo ɗar ɓalɓal nɗǝǝn shinzeen nǝ. Nen ɗe mo wal ngurum mo, kǝ nengung nɗǝǝn mbii mo zak. ");
INSERT INTO sur_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","A sat mmat ɗenan mo nǝnee, << nǝ ret kǝ mo kǝ mwaan kaa nen ɗe mo man Naan sǝ. Taji mo satpwoo ɗebish nkaa gurum mo kas. Taji mo ɗee a kǝrem mǝ shwaa mwes kas. Nǝ ret kǝ mo kám mbii ɗeret ngurum mo. ");
INSERT INTO sur_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Mɓe kǝ mo kám ɗe mmat ɗeɗyeen mo, kǝ mo wal ɗe mmish fur mo, kǝ jep fur mo zak. ");
INSERT INTO sur_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Nen yaasut mo, mbǝkǝ mo ɗee ɗe a ɗeɓang nɗǝǝn pǝtuup fur mo, mbǝkǝ mo naa tulu fur mo ɗe rǝret, kǝ mo ɗee ɗe a ɗeret, kǝ mo lekáa fur mo ndǝr mish fur mo. Mɓe kǝ taji mee gurum katpee satpwoo ɗebish nkaa pwoo Naan kas. ");
INSERT INTO sur_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","A sat jepzǝlang mo nǝnee, << nǝ ret kǝ mo yaasut. ");
INSERT INTO sur_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","nƊǝǝn mbii mo jir, ɓe nǝ ret kǝ mo ɗee a nen ɗe moo mǝse ɗeret mo. A kám ngurum mo. A kám ngurum mo mbii ɗe nǝ nɗǝǝn pǝtuup fwa ɗe nǝ azeen-nzeen, kǝ taji a ɗee ntan kas. ");
INSERT INTO sur_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","A cìn ɗak shi pwoo ɗeret mo, mbǝkǝ taji mee gurum katpee, mbee sat mee mbii nkaa pwoo ɗe aa sat nǝ mo kas, mbǝkǝ nen ɗe mo cii nǝ, ɓe naashweep ya mo ɗe, mbǝɗe baa mo naa mee mbii ɗebish, mbǝkǝ mo satpwoo ɗe nkaa mun kas. ");
INSERT INTO sur_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","A sat kǝrem mo nǝnee, << mo sham kǝ káa fur mo ndǝr nen ɗe mo sǝrep mo, kǝ mo cìn mbii ɗeret nen ɗe moo mo zak. Taji kǝrem mo lapwoo nen ɗe mo sǝrep mo shiɓal kas. ");
INSERT INTO sur_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Taji mo cìn wat kas, ɗangɓe nǝ ret kǝ jir a pǝranghe, ɓe mo ɗee a nenzeen mo, mbǝkǝ mbii ɗe moo cìn jir, ɓe nǝ le kǝ gurum mo satpwoo ɗeret ɗe nkaa kám ɗe nǝ nkaa Naan Nguɓam fun. ");
INSERT INTO sur_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Naan wur kám ɗeret wur mmun, mbǝkǝ gurum mo jir mo kat ɓam ɗe. ");
INSERT INTO sur_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Ɗeret Naan nǝ kám mmun ar ɗe mun nnook cìn mbii ɗebish mo ɗe nyit Naan, kǝ coor mǝ yil ɗesǝ. Ɗang nǝ ret kǝ mun yaasun kǝ mun mwaan ɗe ndǝre-ndǝre zak, mbǝkǝ nɗǝǝn mbii ɗe muu cìn mo jir, ɓe nǝ ret ɗe nNaan nyit. ");
INSERT INTO sur_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Kaaɗi mun nkaa naa puus ɗeret parɗi mbii ɗe muu leyit nkaa mo nǝ ngam, nciit kǝ mǝnǝ, ɓe mun nnaa ɗeɗes nNaan fun. Ɗeɗes met jir mǝ Nguɓam fun Jesu Kristi zak. ");
INSERT INTO sur_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Mbǝ mun ɓe wur shin seen wur mbǝkǝ, wur can mun ɗe nɗǝǝn mbii ɗebish mo jir, kǝ mbǝkǝ wur le mun ɗee ɗe a nen ɗe pǝtuup fun mo a ɗeɓang. Kǝ mun ɗee ɗe a nen wur mo, nen ɗe mo coor cìn mbii ɗeret mo jir. ");
INSERT INTO sur_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Mbii ɗesǝ mo, a mbii ɗe waa nkám ngurum mo. A cìn ɗak kǝ ram ɗe Naan kǝ shin ngha, mbǝkǝ nghan caa gurum mo ɗe, kǝ nghan gwak mo ɗe zak. Taji a yit kǝ mee gurum ɓák gha kas. ");
INSERT INTO sur_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","A lepan nen fwa mo nǝnee, << nǝ ret kǝ mo sham kǝ káa fur mo ndǝr mishkoom mo, kǝ nen ɗe mo kǝ ram jir. Nǝ ret kǝ mo kǝlǝng mo, kǝzak mo tong shi ɗak sut, mbee cìn jir ɗak ɗeɗang ɗe nǝ a ɗeret. ");
INSERT INTO sur_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Baa nǝ ret kǝ mo satpwoo ɗebish nkaa mee gurum kas. Taji mo cìn jǝr kas, ɗangɓe mo sham kǝ káa fur mo ndǝr gurum mo jir. ");
INSERT INTO sur_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Gyet mun shikáa fun, ɓe mun a mwen mo, nenbaashik mo, nen cìn mbii ɗe nǝkan mo. Gyet mun a kǝrem mo, mbee shang mǝ nan ɗesǝ. Pan fun mo jir a ɗebish shidaar-shidaar, kǝ coor mbii gurum mo shi yit ɗebish. Gurum mo cii mun, ɓe mun zak, muu cii mo. ");
INSERT INTO sur_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Ɗang kaaɗi Naan, ɗewur a Nguɓam fun, wur kám ɗeret wur kǝ nwalshak wur mmun, ");
INSERT INTO sur_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ɓe wur ɓam mun. Ɓam ɗesǝ, baa nǝ a mbee mee mbii ɗeret ɗe muu cìn shikáa fun kas, ɗangɓe a mbee naajeel wur, ɗangɓe wur ɓam mun shi Riin Ɗeɓang. Wur wang pǝtuup fun mo, kǝ mo ɗee a ɗeɓang, kǝzak, wur shin seen ɗepoo mmun. ");
INSERT INTO sur_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Wur ɗoo Riin wur nkaa mun nɗǝǝn Jesu Kristi Nguɓam fun. ");
INSERT INTO sur_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Mɓe kǝ shi ɗeret wur, ɓe mu ɗee ɗe a nenɗeret mo, kǝ mun kat seen ɗe ngha-ngha, ɗe muu leyit nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Pwoo ɗesǝ nǝ azeen. Wen kǝn rǝɓet kǝ nghan sat mbii ɗesǝ mo nen fwa mo shidaar-shidaar, mbǝkǝ nen ɗe mo shinzeen nNaan, ɓe mo lepan fur mo mbee cìn mbii ɗe ndǝre mo shidaar-shidaar. Mbii ɗesǝ mo a ɗeret, kǝzak, mo kǝkoop nǝ mbee gurum mo. ");
INSERT INTO sur_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","A nok sat mee pwoo ɗebuu taji a watpee buu, kǝ nwun ɗee ntang sǝm puun fuu ɗe mo kǝ murep mo kas. Kaji wu jǝr kǝ shak kas, jir wu ɗee mɓeetshik nkaa Wàar mǝ Mosis mo kas. Mbii kaa mǝnǝ mo sǝ, baa mo kǝ mee koop nǝ kas, jir dǝɓen. ");
INSERT INTO sur_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Katɗang mee gwar ɗewur cii kám fwa nǝ, ɓe a gwak wur yit mǝndong, jir yit vǝl, katɗang baa gwar nǝ kǝlǝng gha kas, ɓe a yit wur ɗe. ");
INSERT INTO sur_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","A man nǝnee, << gurum kaa mǝnǝ sǝ, ɓe pan wur mo jir a ɗebish, a ngushikbish, wur shikáa wur, kǝ ten man nǝ; ɗyin a ɗebish. ");
INSERT INTO sur_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Katɗang wen lep a Artimas, a ɗang a Tikikus shidǝm pee gha ɗe, ɓe a gung, kǝ nghan jì a kat nghan ɗe nɗǝǝn Nikapolis, mbǝɗe nghan ntong ɗe, mbe kyes tar kut. ");
INSERT INTO sur_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","A gung kǝ nghan ɓam Zinas ɗe, ɗewur a nguman wàar mo, kǝ Apolos nɗǝǝn ɗak sut mbee mwaan mmo, mbǝkǝ taji mo kat mee mbii jee kas. ");
INSERT INTO sur_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Nǝ ret kǝ nen fun sǝ mo shin sut mbee cìn ɗak ɗeret mbee ɓam nen ɗe mo nɗǝǝn jeel mo. Kaji mo tong buu shi sar ɗe nfii kas. ");
INSERT INTO sur_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Nen ɗe mo ashak kǝ an jir, moo tok kǝ gha. A tok kǝ nen ɗe mo wal mmun nɗǝǝn shinzeen nNaan jir. Naan wur le ɗeret nkaa wun.");
INSERT INTO sur_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Lepran ɗesǝ nǝ put a nsar Jemis kǝrem mǝ Naan kǝ Daa Jesu Kristi, tokshik mpee nenyil kǝ Naan, ɗe mo a titiit shipee shipee nɗǝǝn yil ɗese. ");
INSERT INTO sur_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Ɗyemnaa mo, wu chìn retnyit, katɗang wu ɗel nɗǝǝn jwaan mo shini-shini. ");
INSERT INTO sur_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Mɓeɗi wu man nǝ, katɗang mo kam shinzeen fuu ni, ɓe nǝn nle kǝ gung fuu nǝ ɗee a ɗeɓal. ");
INSERT INTO sur_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Wu yit kǝ gung fuu nǝ sat a nwurang ɗak, mbǝkǝ wun ɗee ɗe a ɗiigǝgam nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Katɗang mee gwar nɗǝǝn wun ɗe baa wu kǝ ɗyeen kas, ɓe wu yit kǝ gwar mǝnǝ ɗang pǝ Naan, mbǝkǝ Naan shin ɗyeen ɗe nwur. Naan wur zum zam, wu naa nchin mbii ngurum mo jir, baa wur chakpwo mɓe shin mbii ngurum mo kas. Naan wu nshin ɗyeen mun jir ɗe mo ɗang pǝ wu. ");
INSERT INTO sur_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Katɗang mee gwar ɗang mee mbii pee Naan ɗe, ɓe nǝ a tǝng gwar nǝ shinzeen nǝ, Naan wu ncin mbii nǝ nwur. Taji gwar mǝnǝ pan kyetwa nɗǝǝn pǝtuup fǝr kas. Mɓeɗi gwar ɗewur pan kyetwa nɗǝǝn pǝtuup fǝr, ɓe wu ɗee a kaa am ɗe kut kǝ cut nǝ dǝm kǝ ni, koo a pee ɗeɗangyi sǝ. ");
INSERT INTO sur_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Mbǝmǝnǝ, ɓe taji gwar mǝnǝ lepan nnǝ, wuɗin nkat mee mbii pǝ Daa ɗe kas. ");
INSERT INTO sur_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Gwar mǝnǝ a ngupan mo vǝl-vǝl, kǝ baa wur ɗar a pee mǝndong kas, koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Nguso nɗang Jesu Kristi, ɗe baa wu kǝ long kas, ɓe wu chìn retnyit, mɓeɗi Naan kǝ ten shin ɗǝǝɗes nwur. ");
INSERT INTO sur_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Nguso nɗang Jesu Kristi, ɗe wu kǝ long, ɓe nǝ ret kǝ wu chìn retnyit zak, mɓeɗi Naan kǝ le kǝ wu sham kǝ káa fǝr. Mɓeɗi gwar mǝnǝ man nǝ, jir kǝ long wu ni, ɓe wur nɗel dǝm kǝlak-kǝlak, a kaa pel mǝ ɗem ɗe nii kǝlak kǝ fii sǝ. ");
INSERT INTO sur_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Puus nǝ kàa yaapee nkaa pel mo, ɓe nǝ le kǝ mo fii. Pel nǝ mo ɗong, ɓe men fun nǝ kyes mmǝnǝ vit. Ni aasǝ zak, ɓe ngulong wur muut kaaɗi wu nkaa tang long nǝ ɗikǝ. ");
INSERT INTO sur_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Ngwar ɗe wu gung jwaan mo, ɓe wu nkat ɗeret. Mɓeɗi katɗang wu se koorong nkaa jwaan nǝ mo jir, ɓe Naan nshin seen nwur, ɗe nǝn nɗee a koppee kǝ kwat ni, kaaɗi Naan wu kǝ ten sat nǝ, wuɗin nshin ngurum mo jir, ɗe mo nwal nwuɗi. ");
INSERT INTO sur_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Katɗang jwaan kat mee gurum, ɓe taji gwar mǝnǝ sat nǝ, a Naan jwaan wuɗi kas. Baa mee mbii ɗe nǝn mmak jwaan Naan, mbǝkǝ wu chìn mbii ɗebish ɗe kas. Naan shikáa fǝr, baa wu cham jwaan mee gurum, mbǝkǝ gwar mǝnǝ chìn mbii ɗebish ɗe kas. ");
INSERT INTO sur_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","A shoor ɗebish ɗe nǝ nɗǝǝn pǝtuup gurum, a nii jwaan gurum, mbǝkǝ wu chìn mbii ɗebish mo ɗe. ");
INSERT INTO sur_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Kyoor ɗebish ɗesǝ ni, a nii le kǝ gurum chìn mbii ɗebish mo. Katɗang mbii ɗebish nǝ wurang, ɓe peekyes nǝ a muut. ");
INSERT INTO sur_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Ɗyemnaa fen mo, taji wu le kǝ mee gurum ngwom wun ɗe kas. ");
INSERT INTO sur_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Mbii ɗeret mo, kǝ ɗe azeen mo jir, moo tong a pee Naan jì. Mbii ɗesǝ mo jir, a zuum ɗe moo pwat a pee Naan ɗe, ɗe wu lepuus, kǝ zar mo, kǝ tar nɗǝǝn ɗengnaan. Naan wu shikáa fǝr, baa wur cham sheeɗi kas, kǝ nǝ le kǝ mǝ ɗee ɗe nkòo kas. ");
INSERT INTO sur_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","A mɓut pan mǝ káa fǝr, ɗang wu naa nǝ ret wun nyit, nɗǝǝn pwoo wu ɗe nǝ azeen, ɓe wu shin seen mmun, mbǝkǝ mun ɗee ɗe a jep ɗenshee mo nɗǝǝn mbii ɗe wu kǝ ten le mo nɗǝǝn yil ɗese. ");
INSERT INTO sur_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Ɗyemnaa mo, ɗe wen nwal nwun. Ni ret kǝ wu man mbii ɗesǝ mo, koo a weye, ɓe wu lekom mɓe kǝlingpee kǝlak-kǝlak, ɗang ɓe nǝ ret kǝ koo a weye, ɓe taji wu lappwoo kǝlak-kǝlak kas. Taji mee mbii kǝlak láa nwun mɓut kas. ");
INSERT INTO sur_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Ngwar ɗe wu kǝlak kǝ langtuup, ɓe baa gwar mǝnǝ mak chìn mbii ɗe mo ret nNaan nyit kas. ");
INSERT INTO sur_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Mɓǝmǝnǝ nghan kǝn sat nwun nǝ, wu baa kǝ mbii ɗebish mo jir nɗǝǝn tong fuu mo. Wu fwo mo sí. Wu chii mbii ɗebish mo jir, wu sham kǝ káa fuu mo ntoom Naan. Wu kǝlǝng pwoo ɗe Naan wu kǝ ten kop nɗǝǝn pǝtuup fuu mo, mɓeɗi a nɗǝǝn ɓal kǝ pwoo wu, ɗangɓe wu mɓam seen fuu mo. ");
INSERT INTO sur_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Ɗangɓe nǝ a tǝng ƙǝn wu chìn mbii ɗe pwoo Naan nǝ sat nnǝ wu chìn ni, baa nǝ, wu kǝlǝng a shi kom ɓejee ɗak kas. Nen ɗe mo kǝlǝng pwoo Naan, ɗangɓe baa mo chìn mbii ɗe pwoo nǝ sat nnǝ mo chìn kas, ɓe nen mǝnǝ moo ngwom a sut fur ɓejee. ");
INSERT INTO sur_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Katɗang gurum kǝ kǝlǝng a pwoo nǝ ɓejee, ɗangɓe baa gwar nǝ chìn mbii ɗe pwoo nǝ sat kas, ɓe nǝ ɗee a kaa gwar ɗe wu naa shin fǝr nɗǝǝn mbii naayit sǝ. ");
INSERT INTO sur_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Ɗe aɓwoon ɗe wu kǝ ten naa shin nɗǝǝn mbii naayit ni, ɓe kaaɗi wu chiir kǝɓwoon mbii naayit ni, ɓe wu chiir muunshik nyit fǝr ɗe wu kǝ naa ni. ");
INSERT INTO sur_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Ɗangɓe gwar ɗe wu tap bǝlǝp wàar kǝ Naan, ɗangɓe wu chìn mbii ɗe wàar nǝ mo sat, baa wu kǝkǝlǝng ɓejee kas, ɗe nǝn nle kǝ wu muunshik mbii nǝ mo kas, ɗang ɓe wu tap chìn mbii ɗe wàar nǝ sat, ɓe Naan wu nle ɗeret nkaa gwar mǝnǝ hakyeng. Mɓeɗi wàar kǝ Naan mo a ɗin ndǝre-ndǝre, mo ɓál mɓe chínpee mmun, mbǝkǝ mu ɗee ɗe a mukáa fun. ");
INSERT INTO sur_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Katɗang mee gurum leshin a kaa nguso ndang Naan sǝ, ɗangɓe baa gwar mǝnǝ tap kǝ liis fǝr kas, ɓe gwar mǝnǝ ngwom a káa fǝr ɓejee. Mwaan wur ɗe nǝ a mǝ nenɗǝm ndang Naan mo, nǝ ɗee a buu. ");
INSERT INTO sur_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Nyit kǝ Naan ɗe wu a puun fun jir, ɓe mwaan ɗe mǝnǝ a mǝ nen mwaan ndang Naan ɗe nǝ azeen-nzeen, ɓe a gwar ɗewur tap kǝ lukáa mo, kǝ matkaa mo, ɗe mo nkaa shwaajeel, kǝzak, gwar mǝnǝ tap kǝ káa fǝr, mbǝkǝ taji mbii ɗebish mǝ yil ɗesǝ mo ngwom wu, kǝ mo le kǝ wu cìn shikbish kas. ");
INSERT INTO sur_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Ɗyemnaa fen mo, kaaɗi wun a nyemcínzeen nɗǝǝn Daa fun Jesu Kristi sǝ, ɗe wu a ɗǝǝɗes met jir, ɓe taji wu bakyit ngurum mo kas. ");
INSERT INTO sur_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Katɗang mee gwar jì ɗel nɗǝǝn kuur fuu kǝ kawan mǝ zinariya nkaa nǝkongsar fǝr, kǝ nlǝr ɗeret mo, ɗang kat mee ngujeel jì ɗel nɗǝǝn kuur fuu, kǝ goklee. ");
INSERT INTO sur_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Katɗang wu tap wu kaat gwar ɗe wu loplee ɗeret sí, kǝ wu sat nwur nǝ, a jì a tong a peetong ɗeret sǝ, ɗang ɓe wu sat ngujeel nǝ nǝnee, waa ɗar sǝ, koo wu sat nwur nǝ, a tong nyil mpesi nder shii fen. ");
INSERT INTO sur_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Katɗang wuu cìn mbii kaa mǝnǝ sǝ, ɓe wu cìn a shikbish. Wuu baakyit ngurum mo nnaar fuu, ɓe wu ɗee a nentokɗyeel mo, shi pan ɗebish mo. ");
INSERT INTO sur_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Ɗyemnaa mo, ɗe wen nwal nwun, wu lekom, Naan wur bǝlǝp a nenjeel mo nɗǝǝn yil ɗese, mbǝkǝ mo shinzeen ɗe nDaa Jesu Kristi, kǝ mbǝkǝ mo kat mulki/ɗehai ɗe gyet Naan wu kǝ ten sat nnǝ, wuɗin ncin nenyil ɗe mo nwal nwuɗi mo. ");
INSERT INTO sur_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ɗangɓe wun, wu bakseen nenjeel nǝ mo. A nenlong moo seen a wun, ɗangɓe mo dul wun dǝm kǝ nǝ nluɗiyeel. ");
INSERT INTO sur_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Kǝ, a nenlong nǝ moo satpwoo ɗebish nkaa sim ɗeret, ɗe Naan wur le kǝ mo pet wun ɗishik, kaa nen fǝr mo sǝ zak. ");
INSERT INTO sur_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Katɗang wu fes wu gam wàar, ɗe nǝ put a pee Naan ɗe azeen-nzeen, ɗe mo kǝ ten ran nǝ nɗǝǝn ɓǝǝt haal Naan nǝnee: <<<<A nwal ngǝnang fwaa kaa sak fwaa sǝ.>> <<Ɓe wu cìn a mbii ɗeret hakyeng. ");
INSERT INTO sur_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ɗangɓe katɗang wuu shin ɗǝǝɗes ngurum mo, a shi baakyit, ɓe mon nkat wun a ɗebish, mɓeɗi wu tep wàar Naan. ");
INSERT INTO sur_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Koo ɗang ɗe gurum gam wàar Naan nǝ mo jir, ɗang ɓe wu taa kat nɗǝǝn memee mǝndong ɓejee ɗak, ɓe wu kǝ ɗee a ɗiipǝpal ntom Naan mɓut kor wàar nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Ngwar ɗe wu sat nǝ: <<<<Taji wu chìn ngaa kas, <<kǝ <taji wu tukáa kas.> >> Ɗangɓe katɗang mee gwar tukáa, ɓe gwar mǝnǝ kǝ tep wàar Naan nǝ mmǝnǝ, koo ɗe baa wu chìn ngaa kas, ɓe nǝ ɗee nǝ, gwar mǝnǝ taa pal nɗǝǝn mbii ɗe Naan kǝ ten sat nnǝ taji wu cìn kas. ");
INSERT INTO sur_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Mbǝmǝnǝ, ɓe nghan kǝn sat nwun nǝ, nɗǝǝn mbii mo jir, ɗe wuu sat, kǝ ɗe wuu cìn, ɓe taji wu muunshik nǝ, a Naan wun ntokɗyeel mmun shi wàar fǝr, ɗe nǝ chínpee mmun, kǝ mǝ ɗee ɗe a mukáa fun mo. ");
INSERT INTO sur_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Katɗang mee gurum chii naajeel niyee mo, ɓe Naan wu nchii naajeel ngwar mǝni, parɗi Naan wu ntokɗyeel ngwar mǝnǝ zak. Ɗangɓe naajeel kǝ Naan nǝ se koorong nkaa ɗiyeel. ");
INSERT INTO sur_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Ɗyemnaa mo, katɗang mee gurum sat nǝnee, wuɗi shinzeen nNaan, ɗang ɓe, baa wur chìn ɗak ɗe Naan sat nnǝ mǝ chìn mo kas, ɓe baa shinzeen mǝnǝ kǝ mee kwoop nǝ kas. Chinarang ɗangɓe shinzeen mǝnǝn mɓam wu ye? ");
INSERT INTO sur_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Katɗang ɓe, mee ɗyemnǝǝn ɗemish koo ɗe mat, baa mo kǝ leelop, koo mbiise kas. ");
INSERT INTO sur_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","Ɗangɓe wu sat nwur nǝ, <<A seet ryang, Naan le kǝ a kat mbiise kǝ leelep mo zak.>> Ɗangɓe baa wu shin leelep, koo mbiise nwur kas, ɓe kwoop mǝnǝ a meye? ");
INSERT INTO sur_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Ni aasǝ zak, kǝ shinzeen ɗe baa nǝ ashak kǝ ɗak kas, ɓe nǝ a ɗiimumuut. ");
INSERT INTO sur_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Ɗangɓe mee gurum mmak sat nǝnee, <<Mee gwar kǝ shinzeen, kǝ memee kǝ chìn ɗak ɗeret mo,>> Wen nlap gwar mǝnǝ a nǝnee, <<A kám shinzeen kǝ mee gurum nghan, ɗe baa nǝ ashak kǝ ɗak kas ɗe! Ɓe wen nkám shinzeen fen ngha, shi ɗak fen mo.>> ");
INSERT INTO sur_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Waa shinzeen nǝ, Naan ɗe azeen, wu a mǝndong, kaaɗi a sat aasǝ, ɓe nǝ ret. Ɗangɓe koo a riin ɗebish mo, ɓe mo shinzeen nǝ, Naan wu a mǝndong, ɗangɓe kǝǝrmuut kǝ yaa mo, kǝ moo ɗaar zak. ");
INSERT INTO sur_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Waa mwen, baa a man nǝ, katɗang gurum shinzeen nNaan, ɗangɓe baa gwar mǝnǝ kǝ chìn ɗak ɗeret kas, ɓe shinzeen fǝr nǝ ɗee a buu mmǝnǝ kas aa? ");
INSERT INTO sur_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","A yee puun fun Abraham, gyet a me le ɗangɓe Naan naa Abraham kaa gwar ɗe ɗeret sǝ ye? A mɓe ɗe gyet wu mang làa fǝr Aizik, mbǝkǝ wu shin mbiizuum ɗe nNaan, kaaɗi gyet Naan kǝ ten sat nnǝ wu chìn sǝ. ");
INSERT INTO sur_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Ni agaak nǝ, gyet nɗǝǝn tong Abraham, ɓe shinzeen, kǝ chìn mbii ɗeret mo, moo set a ndangshak. Mbii ɗe gyet wu chìn ni, nǝ gam shinzeen nwur. ");
INSERT INTO sur_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Ni gam mbii ɗe gyet mo kǝ ten ran nǝ nɗǝǝn ɓǝǝt haal Naan sǝ nǝnee: <<<<Abraham wu shinzeen nNaan, mpeemǝnǝ ɓe <<Abraham wu ɗee a gwar ɗe ɗeret nyit <<Naan.>> ɗang gyet gurum moo pet wu a shaar Naan. ");
INSERT INTO sur_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Yaksi ɓe gha naa agaak nǝnee, a nɗǝǝn ɗak ɗeret ɗe gurum kǝ cìn, ɗangɓe gurum kǝ mak ɗee a ɗeret nyit Naan, baa a shinzeen nNaan ɓejee ɗak kas. ");
INSERT INTO sur_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Ni aasǝ zak Rahab, mat ngaa sǝ, gyet waa lap nyemcoghol mo, kǝzak, gyet waa tap bwet mo a mee ar ɗiiɗik. Baa gyet a mɓe ɗak ɗeret ɗese, ɗangɓe waa ɗee a ɗeret nyit kǝ Naan kas aa? ");
INSERT INTO sur_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Ni aasǝ zak, kat baa riin kuɗi nɗǝǝn gurum kas, ɓe gwar mǝnǝ ɗee a kúm nǝ. Aasǝ, shinzeen nɗin nchìn ɗak ɗeret mo, ɓe nǝ a ɗiimumuut zak. ");
INSERT INTO sur_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Ɗyemnaa mo, taji gurum mo ɗes mo ɗee a nenkám mo kas. Wu man nǝnee, ɗyeel ɗe Naan wu ntok nǝ mmun nenkám mo, ntoon met mǝ kor gurum mo. ");
INSERT INTO sur_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Mun jir muu ɗel ɗikǝ. Katɗang baa mee gwar ɗe wu ɗel ɗikǝ nɗǝǝn leeshaap kas, ɓe gwar mǝnǝ a ɗin ɗeret, wu mak yaashin nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Wu pan shool bǝring ɗe muu lep nǝ mbǝring mo mpwo. Katɗang mǝ rǝɓet kǝ mo chìn mbii ɗe muu rǝɓet, mǝ mak dul teng shool bǝring ni, mǝ dǝm kǝ nǝ mpee ɗe muu rǝɓet kǝ bǝring nǝ dǝm ɗe. ");
INSERT INTO sur_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Wu naa jirgi am mo, koo ɗe mo ɗes zam, ɓe kut ɗǝǝɗes mak mang mo dǝm kǝ ni, ɗang ɓe jir kǝsǝ, ɓe ngutung nǝ wur shin ciir kǝ nǝ a shi rep mee làa sitiyari dǝm nkwang ɗewur rǝɓet dǝm ɗe. ");
INSERT INTO sur_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Ni aasǝ zak, liis nǝ a rep memee nɗǝǝn ɓeep ɗe nǝ nɗǝǝn fwoshik fun mo, (nǝ kǝ ɓal nɗǝǝn seen kǝ gurum) nii canjagham ɗǝǝɗes nkaa mbii mo. Wu man nǝ, a rep wus ɗiidiɓen kǝ caan lǝhǝt ɗǝǝɗes. ");
INSERT INTO sur_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Liis fun nǝ a kaa wus sǝ. Mbii ɗebish moo tong a ɗe, mbii ɗebish ɗesǝ nǝ mo, mo mak mwaan dǝm koo a pee ɗeɗangyi nɗǝǝn ɓeep fun mo, ɗangɓe nǝ wat gurum. Liis nǝ mak lewus lap, ɗe nǝn ncaan seen kǝ gurum hakyeng. Yaa nkaaɗi gurum ɗe a làa, ɗangɓe parmuut fǝr, har dǝm nluwus ɗe Naan kǝ ɗak nǝ mɓe nenshikbish mo. ");
INSERT INTO sur_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Gurum kǝ mak yaa koo a luwayil ɗeɗang ye, kǝ nǝ jì ɗee kaa longlu sǝ, har koo a nyer mo, kǝ luwa ɗe moo mwaan shii ɓut mo, kǝ luwa ɗe mo nɗǝǝn am mo. Luwa mo jir, ɓe gurum kǝ ten le mo ɗee nder fǝr. ");
INSERT INTO sur_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Ɗangɓe baa mee gurum kǝ cham fwang liis kas. Ni a mee mbii ɗebish ɗe pǝder chíi yaa nyil nǝ. Ni gam kǝ yen ɗe nǝ a mǝ muut. ");
INSERT INTO sur_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Muu chìn ɗak kǝ liis, mbǝkǝ mun kwoop Naan ɗe wu a Daa, kǝ puun fun, kǝzak muu waa mu chiir mu satpwoo ɗebuu nkaa gurum mo kaa mun sǝ a shii liis. Gurum ɗe Naan wu le mo kaa shin fǝr sǝ. ");
INSERT INTO sur_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Pwoo mǝ kwoop, kǝ pwoo mǝ fǝleep, moo pwat a nɗǝǝn pwoo ɗemǝndong. Ɗyemnaa mo, mbii kaa ɗesǝ sǝ, baa nǝ ret kas. ");
INSERT INTO sur_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Baa am ɗiiɗeet kǝ ɗiishang mon mmak put a mɓut tuɓut ɗemǝndong kas. ");
INSERT INTO sur_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Ɗyemnaa mo, baa tingkeen ncham làa paat kas, kǝzak, baa nǝn mmak chìn kǝ mo kat am ɗeret nɗǝǝn tuun ɗemǝndong ashak kǝ am ɗebish kas. ");
INSERT INTO sur_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","A wii a gwar ɗe wu kǝ seen, kǝ wur man mbii mo nɗǝǝn wun ye? Ɓe nǝ ret kǝ wu kám nǝ agaak shi mwaan fǝr ɗeret, kǝ shi ɗak fǝr ɗeret mo, ɗe wu cìn mo nɗǝǝn seen, kǝ sham kǝ káa fǝr zak. ");
INSERT INTO sur_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Ɗangɓe katɗang pǝtuup fuu mo gam aa zuur ɗiiɗeet, kǝ rɨɓetkáa, ɓe baa nǝ ret kǝ wu canjagham, kǝ wu chìn ɗung nkaa zeen nǝ kas. ");
INSERT INTO sur_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Kiyeet kǝ seen ɗe nii cìn mbii ɗesǝ mo, ɓe baa nǝ tong a pee Naan sham ɗe kas, ɗang ɓe nǝ a mǝ yil44 ɗǝsi. Baa Riin Naan ɗe nɗǝǝn nǝ kas, ɗang ɓe nǝ put a pǝ ngujwaan jì ɗe. ");
INSERT INTO sur_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Koo a pee ɗeɗang ye, ɗe zuur, kǝ rǝɓetkáa mo ɗe, ɓe ɓwanbish, kǝ watpee, kǝ mbii ɗebish mo jir moo tong a mpee mǝni. ");
INSERT INTO sur_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Ɗangɓe gwar ɗe wu kǝ seen ɗe nǝ tong a pee Naan sham ɗe, ɗenshee ni, ɓe gwar nǝ a ɗin ɗeret, kǝ nii jì kǝ tongryang, nii le kǝ gurum mo chìn mbii nɗǝǝn ɗyen ɗeret, baa nii le gurum mo ɗee a nyemciishik mo kas. Nii le gwar mǝnǝ ɗee a ngutap kǝ niyee mo, kǝ shidaar-shidaar ɓe wur naa nchìn ɗak ɗeret mo, niyee mo. Pǝtuup kǝ gwar mǝni, baa nǝn cham chiir kas, kǝzak, baa wur chìn ɗung ngurum mo kas. ");
INSERT INTO sur_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Ɗiiret, a nǝ a mbii ɗe nen ɗe moo kop cirem mǝ tongryang nɗǝǝn pǝtuup kǝ gurum mo, mon nɗiip ni. ");
INSERT INTO sur_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","A me moo jì kǝ lek, kǝ jǝǝr nwun ye? Wuu lek kǝ shak, a mɓeɗi choor ɗebish mo nkaa lek nɗǝǝn pǝtuup fuu mo. ");
INSERT INTO sur_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Wuu choor mbii mo, ɗang ɓe baa wuu kat kas, mpeemǝnǝ, ɓe wuu tukáa. Wuu chìn zuur kǝ mbii mo, ɗang ɓe baa wu kat kas, mpeemǝnǝ ɓe wuu jǝǝr kǝ shak. Wuu lek kǝ shak zak. Baa wu kat mbii ɗesǝ mo kas, a mɓeɗi baa wu ɗang mo pee Naan ɗe kas. ");
INSERT INTO sur_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Mmee naar ɓe wuu ɗang pee Naan ɗe, ɗang ɓe baa wu kat kas, a mɓeɗi wuu ɗang mo a nɗǝǝn ar ɗebish. Wuu ɗang mo a mbǝkǝ wu tu ɗe nɗǝǝn ar ɗe nkan, ɗe mo a mǝ shoor kǝ nan fuu mo. ");
INSERT INTO sur_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Wun a kaa mat ɗe moo chìn ngaa sǝ. Wu man nǝ, katɗang gurum kǝ rǝɓet ɗee a shaar mǝ yil ɗese, ɓe gwar mǝnǝ kǝ rǝɓet ɗee a shaarlek Naan. Mbǝmǝnǝ, koo a weye, ɗe wu rǝɓet ɗee a shaar mǝ yil ɗese, ɓe wu leshin ɗee a shaarlek Naan mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Wu pan nǝ, pwoo ɗe mo kǝ ten ran nǝ nɗǝǝn ɓǝǝt haal kǝ Naan, nǝn nɗee a buu aa? Ɗe mo ran nǝ: <<<<Riin ɗe Naan wu le nɗǝǝn pǝtuup fuu mo, <<nǝ gam kǝ zuur hakyeng.>> ");
INSERT INTO sur_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Ɗangɓe ɗeret ɗe Naan wu shin mmun, nǝ ɓal met choor ɗebish ɗe mo nɗǝǝn pǝtuup fun mo. Ni a kaaɗi mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan sǝ nǝ: <<<<Naan wu chii nyemroop mo, <<ɗang ɓe wu chìn ɗeret nenyil ɗe mo sham kǝ káa fur mo.>> ");
INSERT INTO sur_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Mbǝmǝnǝ, wen kǝn sat nwun nǝ, wu sham kǝ káa fuu mo ntoom Naan. Wu chii ngujwaan, ɓe wun nsu yit wun ɗe. ");
INSERT INTO sur_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Wu jì kus kǝ Naan, ɓe Naan wu njì kus kǝ wun zak. Wu vwang sar fuu mo, wun nenshikbish mo. Wun nen ɗe wun kǝ pǝtuup mo vǝl-vǝl, wu pwat kǝ mbii ɗebish ɗe mo nɗǝǝn pǝtuup fuu mo, kǝ wun ɗee ɗe a ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Ni ret kǝ wu kat pǝtuup ɗewuwat, kǝ wu nwal mɓe shikbish ɗe wuu ten wu nchìn mo. Wu yit kǝ shwar fuu mo chiir ɗee a maap, kǝ retnyit fuu mo ɗee a mbii wàt pǝtuup. ");
INSERT INTO sur_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Wu sham kǝ káa fuu mo ntoom Naan, ɓe wun nɗyeep wun zak. ");
INSERT INTO sur_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Ɗyemnaa fen mo, taji wu leeshaap ɗebish duk shak kas, koo a weye ɗewur leeshaap ɗebish nkaa ɗyemnǝǝn fǝr, koo tokɗyeel nwur, ɓe gwar mǝnii katpwoo ɗebish a nkaa wàar nǝ. Kǝ wur ɗee a ngutokɗyeel nkaa nwàar nǝ zak. Ɗangɓe katɗang mee gurum tokɗyeel wàar ni, ɓe baa gwar mǝnǝ cìn mbii ɗe wàar nǝ sat kas, ɗang ɓe wu leshin a ngutokɗyeel mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","A Naan ɓishin, ɗewur shin wàar ngurum, kǝ a wur ɓishin, ɗewur ntokɗyeel ngurum mo jir. A wur a ɗewur kǝ ɓal mɓe ɓam gurum mo, kǝ wur kǝ ɓál mɓe le kǝ gurum mo muut zak. Waa a weye ɗe aa tokɗyeel ɗyemnǝǝn fwaa ye? ");
INSERT INTO sur_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Wu kǝlǝng pwoo fen, wun nenyil ɗe wuu sat nǝ, <<Ɓit bang, koo ɓitsi, ɓe mun nyool mɓít-mɓít kǝ mǝ dǝm nɗǝǝn bǝrnǝ ɗesí, kǝ mǝ hos ɓit ɗe, kǝ mǝ cìn nwor, kǝ mǝ kat shool ɗe.>> ");
INSERT INTO sur_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ɗangɓe wun shikáa fuu, baa wu man mbii ɗe nǝn ncìn daɗaar kas. Seen fuu nǝ a kaa me sǝ ye? Seen fuu nǝ mo a kaa vuun sǝ, ɗe nǝ jì put, amma nɗǝǝn rep pee lee, ɓe nǝ ɗel dǝm loom. ");
INSERT INTO sur_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Amma nǝ ret kǝ wu sat a nǝnee, katɗang Naan rǝɓet kǝ, katɗang ɓe mun ɗe kǝ seen, ɓe mun ncìn mbii ɗese, koo ɗesí. ");
INSERT INTO sur_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Har yaksi, wuu sat a ɗiyeepkáa ɗak, kǝ wuu sat a canjagham ɗak. Kiyeet kǝ canjagham ɗese, baa nǝ ret kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Koo a weye ɗe wu man mbii ɗǝ nǝ ret kǝ wu cìn, ɗang baa wur cìn kas, ɓe gwe mǝnǝ cìn a shikbish mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Wu kǝlǝng nghan yaksi, wun nenlong mo. Ni ret kǝ wu nwal kǝ maap mɓe jeel ɗe mo mbǝ jì nkaa wun. ");
INSERT INTO sur_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Long fuu nǝ mon nɗee a ɗiiwam, kǝ ndukup mon nse nlǝr fuu ɗeret nǝ mo. ");
INSERT INTO sur_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Azurfa, kǝ zinariya kǝ shool fuu nǝ mon nnaatnjileng. Naatnjileng kǝ shool fuu ɗǝsi nǝ mo, mmo ɗee a mbǝǝkám nǝnee, kaaɗǝ shool fuu ɗǝsi nǝ mon nnaatnjileng sǝ, ɓe nan fuu mon ncaan a kaaɗǝ wus kǝ caan mbii mo sǝ zak. Wuu sok long fuu mo yaksi, ntiit kǝ ɗǝ yil nǝ kus kǝ kyes. ");
INSERT INTO sur_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Wuu cìn ɗung nenyil ɗe moo cìn ɗak nɗǝǝn maar fuu mo, wu chii kwat mo nchiit-nchiit kǝ ɗak ɗe mo cìn nwun. Mbǝmǝnǝ, ɓe moo nwal pee Daa Naan ɗe, mbǝkǝ wur ɓam mo ɗe. Yaksi, wal fur nǝ kǝ wul nkom Naan ɗe a wur kǝ mbii mo jir nsar fin. ");
INSERT INTO sur_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Wuu ten wu tong nɗǝǝn long mǝ yil ɗǝsi, kǝ wuu ten wu cìn mbii ɗe wu naa nǝ ret nwun nyit. Wuu ɗak suk, kǝ wu mwaal kaa randong ɗe moo gong parpuus ɗe mon nfet mo sǝ. ");
INSERT INTO sur_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Wuu tokɗyeel ɗebish nkaa nen ɗe baa mo cìn mee mbii ɗebish kas. Wuu twe nen ɗe baa di mmo mak ɓam sut kas. ");
INSERT INTO sur_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Mbǝmǝnǝ, ɗyemnaa mo, an kǝn sat nwun nǝnee, wu gung har parɗi Daa Jesu Kristi wu mbaajì nɗǝǝn yil ɗǝsi. Wu yee nenmaar mo, wu naa kaaɗǝ moo gung ɗe sǝ, moo gongpee, kǝ moo tap kǝ maar fur mo, har parɗi fwan jì wul, kǝ parɗǝ ɗǝǝp ɗǝɓen nǝ jì wul zak. ");
INSERT INTO sur_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Ni ret kǝ wun, wu gung kaa nenmaar mo sǝ. Wu ɗak pǝtuup fuu mo, kǝ wu ɗar ɓalɓal, mɓeɗǝ puus ɗǝ Jesu Kristi wu mbaajì nǝ wul kus. ");
INSERT INTO sur_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Ɗyemnaa mo, taji wu leeshaap nɗoom-nɗoom nkaa shak kas, mbǝkǝ taji mo tokɗyeel nwun kas. Wu naa, ngutokɗyeel nǝ wur ɗar kus. ");
INSERT INTO sur_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Ɗyemnaa mo, wu yee nensatpwo Naan ɗe gyet yam sǝ mo. Gyet mo satpwoo nɗǝǝn sim Naan, mo shwaajeel, amma jir kǝsǝ, ɓe gyet mo gung nɗǝǝn shwaajeel nǝ. Ni ret kǝ wun, wu gung nɗǝǝn jeel nǝ kaaɗǝ gyet mo gung sǝ. ");
INSERT INTO sur_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Muu sat nǝ, mo a nenyil ɗǝ mo kat retnyit, mɓeɗǝ gyet mo gung har peekyes nǝ. Wu man pwoo nkaa gung kǝ Joob, kaaɗi gyet kam nǝ jì taa nkaa wu sǝ. Wu man zak nǝnee, gyet Naan le kǝ shwaajeel kǝ Joob nǝ waa jì kǝ ɗeret nwur. Azeen - nzeen Naan wur kǝ pǝtuup ɗeret mɓe mun jir, kǝ wur naajeel nenyil fin mo zak. ");
INSERT INTO sur_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Ɗangɓe mee mbii ɗǝ nǝ met koor nǝ mo jir, ɗyemnaa mo. Taji wu tweer shi ɗengnaan, koo shi yil ɗǝsi kas. Taji wu cìn tweerpwo, koo shi sim mee mbii kas. Ɗangɓe wu yit kǝ ii, fuu mo ɗee a ii, kǝ waash, fuu mo ɗee a waash, ɓejee ɗak, mbǝkǝ taji mo tokɗyeel ɗebish nwun kas. ");
INSERT INTO sur_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Katɗang memee nɗǝǝn wun nkaa shwaajeel, ɓe nǝ ret kǝ wu cìn aduwa nNaan. Katɗang memee nɗǝǝn wun kat retnyit, ɓe wu yit kǝ wu kwoop Naan. ");
INSERT INTO sur_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Katɗang memee nɗǝǝn wun, ɗe baa wur nkoom kas, ɓe wu yit kǝ wur pet nennan mǝ (Ekǝlisya) nen mwaan ndang Naan mo, mbǝkǝ mo cìn aduwa ɗin nNaan mɓe wur. Katɗang mo ɗoom cìn aduwa ni, ɓe mo pwes mwoor nkaa wur nɗǝǝn sǝm kǝ Daa. ");
INSERT INTO sur_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Aduwa ɗǝ gurum moo cìn nǝ a shi zeen azeen-nzeen, ɓe nǝn nle kǝ nguchiinkom nǝ wu bar. Naan wu nle kǝ nguchiinkom nǝ kat koom hakyeng; kǝ katɗang nguchiinkom nǝ wur kǝ cìn shikbish, ɓe Naan wur nfwo shikbish nǝ mo nwur zak. ");
INSERT INTO sur_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Mbǝmǝnǝ, nghan kǝn sat nwun nǝ, wu woo shikbish fuu mo nshak, kǝ wu cìn aduwa mɓe shak zak. Mbǝkǝ wu kat koom ɗǝ nɗǝǝn shwal fuu mo. ");
INSERT INTO sur_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Gyet, Ilaija wu a gurum kaa mun sǝ, ɓe wur cìn aduwa azeen-nzeen, mbǝkǝ taji fwan jì kas. Ɓe aduwa ɗe gyet wu cìn ni, ɓe mɓe ɓit ƙen an kǝ kaghar, ɓe baa fwan jì kas. ");
INSERT INTO sur_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Mɓwoon mǝni, ɓe wu waa cìn aduwa zak, mbǝkǝ fwan jì ɗe, ɓe Naan le kǝ fwan nǝ jì, nyil nǝ lok, har mbii mo yaa kàa. ");
INSERT INTO sur_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Ɗyemnaa mo, katɗang memee nɗǝǝn wun taa mer nɗǝǝn ar ɗǝ nǝ a mǝ zeen ni, ɓe nǝ ret kǝ memee fuu mo fwang wu waaji kǝ wur ɗe, nɗǝǝn ar ɗǝ nǝ a mǝ zeen nǝ. ");
INSERT INTO sur_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Nǝ ret kǝ wu man nǝ, koo a weye, ɗǝ wur waaji kǝ mee ngushikbish nɗǝǝn ar ni, ɓe gwar mǝnǝ ɓam seen kǝ ngushikbish nǝ nɗǝǝn muut, kǝzak, ɓe gwar mǝnǝ le kǝ Naan wur nfwo shikbish ɗe mo ɗes ngwar ni.");
INSERT INTO sur_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","Wen Pita, laalep nDaa Jesu Kristi, kǝn ran pwoo ɗesǝ nǝ, shidǝm pee wun nen ɗe Naan wur kǝ ten bilip wun, ɗe wun a mǝzep nɗǝǝn nyil ɗesǝ, kǝzak, wun a tǝtiit nɗǝǝn nyil mPontus, kǝ Galati kǝ Kapadosiya, kǝ Eshiya kǝ Bifiniya. ");
INSERT INTO sur_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","Naan puun wur kǝ ten bilip wun, mbǝkǝ nwun ɗee a nen wur mo nciit-nciit kǝ pan wur. Riin wur Ɗeɓang, nǝ le kǝ nwun ɗee a nen ɗeɓang mo, kǝ wu kǝlǝng ɗoo nDaa Jesu Kristi, mbǝkǝ toom wur vwang wun ɗee a ɗeɓang. Yit naajeel nNaan kǝ zuum wur mo wurang nɗǝǝn wun. ");
INSERT INTO sur_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","Mu kwoop Naan puun kǝ Daa fun Jesu Kristi, mbǝɗe a mbee yit naajeel wur, ɗangɓe wur shin seen ɗepoo mmun nɗǝǝn Làa wur, kaaɗi wur yol kǝ Jesu a peemúut sǝ. Mu leyit nkaa seen ɗepoo ɗesǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","Kǝzak, mu sekop ɗe baa nǝ ncam wam, koo ɗee a ɗebish kas. Naan wur kǝ tap ɗak mǝnǝ le mbee mun nɗǝǝn ɗengnaan. ");
INSERT INTO sur_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","Wun ɗe Naan wur tap wun shiɓal wur, mbǝɗe wu shinzeen, parkyes nyil ɗesǝ, ɓe wun nkat seen ɗe Naan wur nwoo nǝ agaak parpuus mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Mpeemǝnǝ wu cìn retnyit ɗes, mbee mbii ɗe Naan wur tap ɗak mo le mbee wun nɗǝǝn ɗengnaan, koo ɗe nyaksǝ ɓe wun kǝ pǝtuup ɗewat mbee jeel ɗe wuu shwaa mo. Wen man nǝnee, << jeel ɗe wuu shwaa mo nyaksǝ, a mbee reppee lee ɓejee. ");
INSERT INTO sur_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","Mbii ɗe nǝ le ɗang wuu naajeel ɗesǝ mo, a mbǝkǝ gurum mo naa ɗi nǝ shinzeen fuu nǝ azeen-nzeen. Koo a zinariya, mbii ɗe nǝ a mǝ nyil ɗesǝ, ɓe gurum moo cam ret nǝ a shi wus. Nǝ aasǝ nciit-nciit kǝ shinzeen fun ɗe nǝ met nzinariya. Duk nkaa cam shinzeen fuu nyaksǝ, mbǝkǝ parpuus ɗe Daa Jesu Kristi wur mbaajì, ɓe gurum mo kwoop Naan, kǝ mo cin ɗeɗes wur mbee wun. ");
INSERT INTO sur_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","Koo ɗe baa wu naa Jesu Kristi wur kǝ yit kas, ɗangɓe wu wal wur, kǝ wu shinzeen zak. Nǝ aasǝ, ɓe wun kǝ retnyit hakyeng, ɗe baa mee gurum mak sat nǝ kas. ");
INSERT INTO sur_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","Katɗang wu sat a ncínzeen nɗǝǝn Jesu Kristi ɗak, ɓe wun a nkaa kat seen ɗe ngha-ngha. ");
INSERT INTO sur_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","Gyet ɓe nensatpwoo Naan mo satpwoo nkaa ɓam ɗesǝ ɗe Naan wur cìn mmun, ɗewur kǝ ten ɗak nǝ mbee mun. Nensatpwoo Naan nǝ mo tap bilip shi ɗyen, mbǝkǝ mo man ar ɗe Naan wur yool ɓam gurum mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","Gyet Riin nDaa Jesu Kristi nɗǝǝn pǝtuup fur mo, gyet nǝ sat mmo jir nkaa jeel ɗe Jesu wur yool shwaa, akuɗang wur ɗel nɗǝǝn ɗeɗes wur. Gyet moo leyit mbee parpuus ɗe mbii ɗesǝ mon ngam ɗi. ");
INSERT INTO sur_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","Naan wur kám mmo nǝnee, << baa mon mmak naa gam nǝ nɗǝǝn teer fur mo kas, ɗangɓe a wun naa gam nǝ. NYaksǝ nen ɗe mo satpwoo ɗiiret nǝ nwun, mo kǝ ten sat mbii mo nwun jir, kaaɗi Riin nNaan ɗewur tong aɗeng sham, wur shìn ɓal mmo sǝ. Nen lep Naan mo shikáa fur, mo rǝɓet naa mbii ɗesǝ nǝ mo. ");
INSERT INTO sur_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","Mpeemǝnǝ wu ɗak pan fuu mo, mbǝkǝ nwun ɗar ɗi ɓalɓal mbee cìn ɗak nNaan. Wu tap kǝ káa fuu mo rǝret, kǝ nwun leyit ɗi a nkaa ɗeret ɗe Naan wur ncin nwun parpuus ɗe Daa Jesu wur baajì zak. ");
INSERT INTO sur_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","Wu sat a nkǝlǝng ɗoo nNaan, kǝ nwun cìn mbii ɗewur sat mo. Kaji wu waa wu baa shiɓwoon mbee cìn mbii ɗebish, ɗe gyet moo shwat nwun akuɗang wuu man pwoo Naan kas. ");
INSERT INTO sur_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","Nǝ ret kǝ nwun man nǝnee, << Naan ɗewur pǝrep wun kǝ nwun ɗee a nen wur mo, wur a Naan ɗeɓang. Nǝ a tǝng, ɓe wu yit kǝ mwaan fuu mo ɗee a ɗeɓang nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","Nǝ a nciit-nciit kǝ mbii ɗe mo kǝ ran nɗǝǝn ɓǝǝt haal Naan sǝ nǝnee, << <<Wu yit kǝ mwaan fuu mo ɗee a ɗeɓang kaaɗi an a ɗeɓang sǝ.>> ");
INSERT INTO sur_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","Wuu pet Naan a puun fuu, mbǝmǝnǝ ɓe nǝ ret kǝ nwun kǝlǝng wur, kǝ nwun shin ɗeɗes wur, kǝ wu kǝ mwaan nɗǝǝn ɗyen ɗeret nɗǝǝn mbii ɗe wuu cìn mo jir. Kaaɗi wuu tong ɗi nɗǝǝn yil ɗesǝ, mbǝɗe Naan wur ntokɗyeel nkòo we a nciit-nciit kǝ mbii ɗe gurum cìn. ");
INSERT INTO sur_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","Wu man nǝnee, << Daa Jesu wur seet wun, a mbǝkǝ wur put ɗi kǝ wun nɗǝǝn wàar ɗebuu mǝ gurum ɗe gyet puun fuu moo cìn. Baa Daa Jesu wur seet wun a shi zinariya, koo azurfa ɗe moo wat sǝ kas, ");
INSERT INTO sur_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","ɗangɓe wurang wun a shi toom wur ɗe nǝ kɨrim zam. Jesu wur ɗee a kaa tǝm ɗe mo bilip nǝ, mbǝkǝ mo can nǝ kaa mbiizuum ɗe shang sǝ, wur ɗi baa wur kǝ mee shikbish, koo mee rap kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","Naan wur kǝ ten sat mbii ɗesǝ aasǝ, akuɗang wur leyil ɗesǝ, nǝnee, << Jesu wur mɓam gurum mo a nɗǝǝn ar ɗesǝ. NYaksǝ, kaaɗi yil nǝ kus kǝ kyes, ɓe Naan kám Jesu mmun agaak mbee wun. ");
INSERT INTO sur_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","nƊǝǝn Jesu, ɓe wu shinzeen nNaan ɗewur yol kǝ wur a peemúut, kǝ wur cin ɗeɗes wur zak. A mbǝmǝnǝ, ɓe wu shinzeen nNaan, kǝ wu leyit fuu mo a nkaa wur. ");
INSERT INTO sur_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","Wuu ten wu le pǝtuup fuu mo ɗee a ɗeɓang, mbǝɗe wuu cìn mbii ɗe azeen, ɗe pwoo Naan nǝ sat nǝnee wu cìn mo, azeen-nzeen, wuu wal nendǝm nɗang Kristi mo. Mpeemǝnǝ nghan nkaa sat nwun nǝnee, << wu walnshak shi pǝtuup fuu mo, kǝ ɓal fuu mo jir. ");
INSERT INTO sur_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","Kaji wu mundǝr nǝnee, << moo baa làa wun ɗi apoo a buu kas, ɗangɓe mbee ɓal ɗi nǝ nɗǝǝn pwoo wur ɗe nǝ jì kǝ seen. Baa mee mbii mak wat pwoo wur nǝ kas, nǝ tong ɗi mbe ngha-ngha. Baa a nen ɗemǝmurep mo làa wun nyaksǝ kas, ɗangɓe a Naan ɗe baa wur muut kas, a wur shin seen ɗesǝ nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","Gyet nyam ɓe mo ran nɗǝǝn ɓǝǝt haal nNaan nǝnee: <<<<Gurum mo jir mo a kaa shit ɗe <<nǝ fii sǝ, men fur nǝ a kaa <<pel ɗe nǝ ciir fii kǝlak-kǝlak sǝ, <<mbee reppee lee, ɓe shit kǝ pel moo fii.>> ");
INSERT INTO sur_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","Ɗang pwoo Naan nǝ ɗi mbe ngha-ngha. Pwoo ɗesǝ nǝ a pwoo ɗeret ɗe muu sat nǝ nwun. ");
INSERT INTO sur_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","Kaaɗi Naan wur kǝ ten shin seen ɗepoo ɗesǝ nwun, ɓe nǝ ret kǝ nwun pwat kǝ mbii ɗebish mo nɗǝǝn seen fuu mo jir. Kaji wu baa wu cìn ɗung kas. Kaji wu ɗee a nen ɗe moo satpwoo, ɗangɓe mo waa ciir cìn mee mbii ɗeɗik kas. Kaji wu leyit nkaa mbii kǝ mee gurum kas. Kaji wu sat mee pwoo ɗebuu nkaa gurum mo kas. ");
INSERT INTO sur_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","Ɗang nǝ ret kǝ mwaan fuu nǝ ɗee a kaa mǝ jep ɗe mo làa mo apoo, ɗe moo tang a wur pee nǝǝn fur mo shidaar-shidaar sǝ. Nǝ ret kǝ neen am tu wun mbee wur ɗi nǝ azeen-nzeen. kǝ mǝnǝ, a pwoo Naan ɗe nǝ shin ɓál nwun shidaar-shidaar, mbe parpuus ɗe Naan wur mɓam wun.) ");
INSERT INTO sur_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","Nǝ ret kǝ nwun sat a tang pwoo Naan shidaar-shidaar, mbǝɗe wun shikáa fuu wu man nǝnee, << Daa fun Jesu Kristi wur wal mmun zam. ");
INSERT INTO sur_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","Mpeemǝnǝ, wu jì kus kǝ Daa Jesu Kristi, ɗewur shin seen ngurum mo. A wur a jwak ɗe nǝ kǝ seen ɗe ngha-ngha, ɗe gurum mo cii nǝ kaa mbii ɗe baa nǝ kǝkoop nǝ kas sǝ. Ɗangnaan bilip wur, mbǝɗe pǝ Naan ɗi, ɓe wur kǝkoop nǝ hakyeng. ");
INSERT INTO sur_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","Wun shikáa fuu wun kǝ seen, mbǝmǝnǝ nǝ ret kǝ nwun ɗee a kaa jwak ɗe Naan wur ɗyiklu ɗishik sǝ, mbǝɗe Riin wur ɗeɓang wur nɗǝǝn wun. Wun a nen ɗe Naan wur kǝ ten bilip wun, mbǝkǝ nwun ɗee ɗi a pris wur mo, mbǝkǝ nwun cìn ɗak wur ɗi shi pǝtuup mǝndong nɗǝǝn ar ɗe nǝ shang wur, mbee sǝm kǝ Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","Gyet mo kǝ ten ran nɗǝǝn ɓǝǝt haal Naan, ɗe Naan sat nǝnee:<<Wu naa ghan nkaa le mee nhik nɗǝǝn Zayon, <<mbǝkǝ lu fen ɗar ɗi hakyeng. <<Koo a wii ɗe shinzeen wur, ɓe baa ngwe mǝnǝ nkǝlǝng yitlwaan kas.>> ");
INSERT INTO sur_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","Wun nen ɗe wuu shinzeen nɗǝǝn wur, ɓe wur kǝkoop nǝ pee wun ɗi hakyeng. Ɗang nen ɗe baa mo shinzeen wur kas, ɓe nǝnee: <<<<Ngǝk ɗe gyet nen ɗyiklu mo cii, <<a nǝ yol ɗee a nghǝk ɗe lu nǝ ɗar nkaa nǝ.>> ");
INSERT INTO sur_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","Mo waa baa ran nɗǝǝn ɓǝǝt haal Naan nǝnee, << <<<<Ɗesǝ nǝ a nghǝk ɗe nǝ le gurum <<mo canshii kǝ mo pal.>> Mbii ɗe nǝ le ɗang gurum mo canshii kǝ mo pal, nǝ a mbǝɗe mo cii cìn mbii ɗe pwoo Naan sat nǝ mo cìn. Naan wur kǝ ten sat yam-yam nǝ nǝ nɗen aasǝ. ");
INSERT INTO sur_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","Ɗang pee wun, ɓe wun a ɗang ɗi Naan wur kǝ ten bilip. Kǝ wu ɗee a pris ɗe moo cìn ɗak mishkoom ɗeɗes. Wun a ɗang ɗi Naan wur tap bilip wun le nshin. Wun a nen ɗe Naan wur kǝ ten cak wun mbee sǝm wur. Naan wur bilip wun, a mbǝkǝ wu sat ɗi agaak mbii ɗeɗes ɗeret, ɗewur kǝ ten cìn mo nwun, kaaɗi wur put kǝ wun nɗǝǝn pekwoo, kǝ wur jì kǝ wun mbǝkǝ nwun mwaan ɗi nɗǝǝn peeɓang wur, ɗesǝ nǝ aapwoo ngurum mo zam. ");
INSERT INTO sur_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","Gyet nyam ɓe baa wun a nen Naan mo kas, ɗangɓe nyaksǝ, wun a nen wur mo. Gyet nyam ɓe baa wu man yit naajeel nNaan kas, ɗangɓe nyaksǝ wu man yit naajeel wur. Nǝ ret kǝ nen Naan mo shin ɗeɗes mishkoom mo, kǝ nen ɗe moo cìn se mishkoom nkaa mo jir. ");
INSERT INTO sur_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","Wun ɗe wen wal nwun mo, taji wu mundǝr nǝ wun a mǝzep mo, ɗe baa wuu tong a vit nɗǝǝn nyil ɗesǝ kas, mbǝmǝnǝ ɓe ghan kǝn ɗang pǝ wun, taji wu lesuk fuu mo nɗǝǝn shikbish, ɗe pǝtuup fuu moo rǝɓet cìn nǝ kas. Mbǝɗe kyeet kǝ mbii mǝnǝ moo rǝɓet wat seen fuu mo. ");
INSERT INTO sur_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","Wu sat a mwaan-mwaan ɗe nǝ ret nyit nnen ɗe baa mo a nen Naan mo kas, mbǝkǝ koo ɗe gurum moo satpwoo ɗebuu nkaa wun, ɓe mo naa mbii ɗeret ɗe wuu cìn mo, mbǝkǝ mo ciir, kǝ mo kwoop Naan ɗe parpuus ɗewur njì naa mun. ");
INSERT INTO sur_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","Mbǝ sǝm kǝ Daa fun Jesu Kristi, ɓe wu sham kǝ káa fuu mo ndǝr kǝ nen ɗe Naan shin iiko mmo nɗǝǝn nyil ɗesǝ. Wu shin ɗeɗes mishkoom ɗewur naa gurum mo jir. ");
INSERT INTO sur_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","Kǝ nwun kǝlǝng gofna mo, ɗe mo kǝ ten bilip mo, mbǝkǝ mo kar nen ɗe moo cìn mbii ɗebish mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","Nǝ nret nNaan nyit, kat ɗang mwaan fun mon ndǝre, mbǝɗe katɗang mwaan fuu mo a ndǝre, ɓe wun nle kǝ nyemɗemwen ɗe baa mo man mee mbii kas, nen ɗe moo satpwoo ɗebuu nkaa wun, mon nɗok tǝtǝk. ");
INSERT INTO sur_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","Wun a nen ɗe baa wun a shishoot kas, ɗangɓe koo ɗi baa wun a shishoot kas, ɓe taji wu sat nǝnee, << katpee fuu nǝ shínpee nwun mbee cìn shikbish kas. Ɗang nǝ ret kǝ nwun mwaan-mwaan ɗeret mǝ kǝrem nNaan mo. ");
INSERT INTO sur_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","Wu shin ɗeɗes ngurum mo jir. Wu wal nɗyemnǝǝn fuu ɗe mo a nendǝm nɗang Kristi mo jir, kǝ nwun sat a nkǝǝr Naan. Wu shin ɗeɗes mishkoom ɗewur mbee fuu. ");
INSERT INTO sur_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","Wun ɗe wun a kǝrem mo, wu sham kǝ káa fuu mo ndǝr nenlu fuu mo, kǝzak, wu shin ɗeɗes mmo nɗǝǝn mbii mo jir. Nǝ a tǝng kǝ nwun shin ɗeɗes mmo, koo ɗi moo ɓiyaal, koo ɗe baa moo naa wun nyit kas, ɓe nǝ ret kǝ nwun kǝlǝng mmo. ");
INSERT INTO sur_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","Ngwe ɗewur gung nɗǝǝn shwaajeel, ɓe ngwe mǝnǝ man nǝnee, << gung nɗǝǝn jeel nǝ ret nNaan nyit. Koo ɗe gwar nǝ shwaa jeel nǝ, katɗang baa a mbee mee mbii ɗebish ɗewur cìn kas. Nǝ ret kǝ a ngwe mǝnǝ kat pǝlang pee gurum mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","Ɗang gwar ɗewur gung nɗǝǝn shwaajeel a mbee mbii ɗebish ɗewur cìn, ɓe cirang ɗang wu naa mǝnǝ a kaa mee mbii ɗeret pǝlang wur sǝ ne? Gwar mǝnǝ lap a kwat mbii ɗewur kǝ ten cìn. Ɗang gwar ɗe mo shin jeel wur a mbee mbii ɗeret ɗewur cìn, ɗangɓe wur gung nɗǝǝn jeel sǝ, nǝ ret kǝ a gwar mǝnǝ kat pǝlang pee Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","Naan ɗewur pǝrep wun, kǝ nwun ɗee a nen wur mo, a wur le, mbǝkǝ nwun shwaajeel ɗesǝ mo, koo ɗe wuu cìn mbii mo ndǝre-ndǝre, mbǝɗe Daa Jesu Kristi shikáa wur wur shwaajeel mbee wun. Nǝ ret kǝ nwun mwaan a nɗǝǝn shiimwaan wur. ");
INSERT INTO sur_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","Baa gyet Jesu wur cìn mee shikbish kas koo dǝɓen. Baa wur nǝk mee gurum kas. ");
INSERT INTO sur_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","Koo ɗe gyet gurum mo fǝlǝp wur, ɓe baa wur lap mmo shi fǝlǝp zak kas. Koo ɗe gyet wur shwaajeel nsar gurum mo, ɓe baa wur sat nǝ wuɗin nkwat mo shi jeel zak kas. Ɗang gyet wur lekáa wur a nɗǝǝn sar nNaan ɗewur ntokɗyeel ngurum mo ndǝre-ndǝre. ");
INSERT INTO sur_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","Jesu shikáa wur, wur mang shikbish fun mo le nkaa shin, kaaɗi gyet mo pwas wur nkaa shiyeepyoom, mbǝkǝ mun ɗee ɗi a nen ɗe baa mu kuɗi muu mwaan nɗǝǝn shikbish kas, ɗangɓe muu mwaan a nɗǝǝn ar seen, mbǝkǝ mu cìn mbii ɗeret ɗi. Mbǝ láa ɗe Jesu wur kat, ɓe mu ɗee a ɗebǝbar. ");
INSERT INTO sur_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","Gyet nyam ɓe wuu ɗee a ɗelǝloom kaa tǝm ɗe mo dǝm loom sǝ, ɗangɓe nyaksǝ wuu baa wu jì. Wu mwaan a nɗang ngukiyeer fuu, wur ɗewur tap wun zak. ");
INSERT INTO sur_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","Wun mat mo, nǝ ret kǝ nwun sham kǝ káa fuu mo ndǝr mish fuu mo, mbǝkǝ katɗang mee mish ɗe baa wur shinzeen pwoo Naan kas, meeɓe wur ntuwap, kǝ wur shinzeen ɗi mpwoo Naan, mbǝɗe mwaan kǝ mat nǝ a ɗeret, koo ɗe baa mat nǝ war satpwoo Naan mmish nǝ shi pwoo kas. ");
INSERT INTO sur_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","Mbǝɗe mish fuu moo leyit, kǝ mo naa mwaan fuu mo ɗi, kyet mwaan fuu nǝ mo a ɗeret aa, koo a ɗebish ghe. Kǝzak, moo naa kyet wuu cìn mbii ɗe Naan wur sat nǝ wu cìn aa, koo wuu cìn kas ghe? ");
INSERT INTO sur_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","Taji wu ɗee pan a nkaa ar ɗe wun nlep lée mo nkaa suk fuu mo shidaar-shidaar kas, shii mǝnǝ, wu ɗee mpan jwat, kaa tepkáa, kǝ lep mbiikom, kǝ lep mbiitook mǝ makluwa mo sǝ. Kǝzak, lep lée ɗekǝrǝm mo nkaa suk fuu mo. ");
INSERT INTO sur_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","Ɗang wu yit kǝ ret fuu, nǝ put a nɗǝǝn pǝtuup fuu mo shidaar-shidaar. Wu gung mbii mo, kǝ nwun sham kǝ káa fuu mo zak. Mbǝɗe ngyeel kǝ ret mǝnǝ, nii koop nǝ zam pǝ Naan ɗi, kaa mbii ɗeret sǝ. ");
INSERT INTO sur_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","Wu cìn pan nkaa mat ɗiiyam-yam mo, ɗe gyet moo leyit fur a nkaa Naan. Gyet shiimwaan mmo, nǝ le kǝ mmo ɗee a mat ɗeret mo, mbǝɗe mo sham kǝ káa fur mo ndǝr mish fur mo. ");
INSERT INTO sur_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","Seera, war ɗee a mee mbiikám. Gyet war kǝ mwaan nɗǝǝn ar mwaan ɗeret, war pet Abraham a Daa fɨɗa. Katɗang wun wu mwaan nɗǝǝn shiimwaan war, ɓe wun a jep war mo azeen. Wu gung. Taji wu rǝɓet kǝ mmee mbii lekǝǝrmuut nwun kas. ");
INSERT INTO sur_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","Wun mish mo, nǝ ret kǝ nwun tong kǝ mat fuu mo nɗǝǝn ar ɗe nǝ ret, mbǝɗe wu man nǝnee, << baa mat mo kǝ ɓal a kaa mish mo sǝ kas. Mbǝmǝnǝ wu shin ɗeɗes mmo, mbǝɗe wun kǝ mo, wun ashak. Wun nkaa tap seen ɗe Naan wur shin nwun nzuum. Katɗang wu cìn mbii mo a nɗǝǝn ar ɗeret ɗesǝ, ɓe baa mee mbii mmak le kǝ ɗangnaan fuu mo ɗee a buu kas. ");
INSERT INTO sur_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","Pwoo fen ɗe mu kyes nǝ nɗesǝ, nǝ ret kǝ pwoo fuu mo ɗee a ɗemǝndong, kǝzak, wu naajeel nshak, wu walnshak, nendǝm nɗang Jesu mo, mbǝɗe wun a ɗyemnǝǝnshak mo nɗǝǝn Kristi. Wu fwangshak, kǝ nwun sham kǝ káa fuu mo. ");
INSERT INTO sur_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","Katɗang mee gurum cìn mbii ɗebish nwun, ɓe taji wu kwat mǝnǝ shi mbii ɗebish zak kas. Katɗang mee ngwe satpwoo ɗebish nkaa wun, ɓe taji wu fǝlǝp gwar mǝnǝ kas, ɗangɓe nǝ ret kǝ nwun le ɗeret nkaa nen mǝnǝ mo, mbǝɗe mbii ɗe nǝ le ɗangɓe Naan wur pǝrep wun, kǝ nwun ɗee a nen wur mo, a mbǝkǝ wur le ɗeret ɗi nkaa wun. ");
INSERT INTO sur_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","Duk kǝ ran nɗǝǝn ɓǝǝt haal Naan nǝnee: <<<<Katɗang mee ngwe kǝ rǝɓet tong shang shang nɗǝǝn seen ɗeret, <<ɓe taji gwar mǝnǝ kuɗi kǝ sat mee pwoo ɗebish kas. <<Taji gwar mǝnǝ cìn ɗung kas. ");
INSERT INTO sur_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","Nǝ a tǝng, ɓe gwar mǝnǝ yit cìn mbii ɗebish mo jir. <<Ɗang nǝ ret kǝ gwar mǝnǝ cìn a mbii ɗeret mo ɓejee ɗak. <<Nǝ ret kǝ nwur sat a ntang tongryang kǝ nwur kat nǝ zak, <<mbǝkǝ wur kat tongryang ɗe pǝ Naan. ");
INSERT INTO sur_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","Naan wur tap nen ɗe moo cìn mbii ɗeret mo, shidaar-shidaar, <<kǝ Naan wur kǝlǝng ɗangnaan mmo. <<Ɗang nen ɗe moo cìn mbii ɗebish mo, ɓe Naan wur cii mo.>> ");
INSERT INTO sur_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","Katɗang wun nkaa gung, mbee cìn mbii ɗeret mo, ɓe a wii mmak tung wun kǝ mbii ɗebish ghe? ");
INSERT INTO sur_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","Ɗang katɗang wuu shwaajeel a mbǝɗe wuu cìn mbii ɗeret, ɓe Naan wur nle ɗeret nkaa wun, mbǝmǝnǝ ɓe, taji wu kǝǝr nen ɗe moo rǝɓet cìn mbii ɗebish nwun kas. Taji wu an suk kas. ");
INSERT INTO sur_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","Ɗang nǝ ret kǝ nwun leyit a nkaa Kristi ɓejee. Wu yit kǝ wur ɗee a mishkoom nɗǝǝn pǝtuup fuu mo, kǝ nɗǝǝn mbii ɗe wuu cìn mo jir. Wu tong shi ɗak suk, koo a pǝrang ghe, mbǝkǝ nwun man mbii ɗe wun nsat ɗi. ");
INSERT INTO sur_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","Wu sham kǝ káa fuu mo ndǝr nnen ɗe moo cìn tal ɗesǝ mo pee wun ɗi, kǝzak, wu cìn mbii ɗe wu naa nǝ ret nɗǝǝn pǝtuup fuu mo shidaar-shidaar. Mɓe kǝ katɗang gurum mo sat mee pwoo ɗebish nkaa mǝse fuu ɗeret mǝ nendǝm nɗang Jesu Kristi, ɓe yitlwaan ya mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","Nǝ ret met mbǝkǝ gurum shwaajeel mbee cìn mbii ɗiiret, katɗang nǝ a shi rǝɓet kǝ Naan, nǝ ret met nɗi gurum nshwaajeel a mbee ɗebish ɗewur kǝ cìn. ");
INSERT INTO sur_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","Daa Jesu Kristi wur shwaajeel a mbee shikbish fun mo yit mǝndong, ɓe wur kyes ɗak mǝ vwang shikbish fun mo. Yit mǝndong ɓe ngwe ɗe ndǝre wur muut mbee mun nenshikbish mo, mbǝkǝ wur jì kǝ mun ɗi kus kǝ Naan. Gyet gurum mo tu wur nɗǝǝn nan, ɗangɓe Naan le kǝ wur yol a peemúut kǝ seen. ");
INSERT INTO sur_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","Kaaɗi Jesu wur kuɗi nɗǝǝn iiko mǝ riin wur, ɓe wur dǝm satpwoo Naan nriin ɗe mo a shishoot, ɗe mo a peemúut mo. ");
INSERT INTO sur_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","Riin ɗesǝ mo a riin ɗe gyet mo cii kǝlǝng pwoo Naan, kaaɗi gyet Nowa nkaa ɗak tii am ɗeɗes. Jir kǝsǝ ɓe gyet Naan wur sat a ngung kǝ mo ɗak. Gyet mǝnǝ, ɓe gurum mo a kong ɓejee ɗak, ɗe mo nɗǝǝn tii nǝ, ɓe baa am tu mo kas. Gyet gurum nǝ mo a pwookun ɓejee. ");
INSERT INTO sur_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","Am ɗe gyet mo ɗel nɗǝǝn nǝ, nǝ ɗee a koppee baptisma. Duk ɓam wun mɓut shikbish fuu mo, a mbee baptisma, mbǝɗe gyet Daa Jesu Kristi wur yol a peemúut. Suup ɗe gyet mo suup wun, kaaɗi gyet mo cìn baptisma nwun sǝ, baa nǝ a mbǝkǝ wur vwang pǝtuup fuu mo ɗee ɗi a ɗeɓang ɓejee kas. A mbee yol kǝ Daa Jesu Kristi a peemúut, ɗang wu kat ɓam nɗǝǝn shikbish fuu mo. ");
INSERT INTO sur_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","Daa Jesu wur kǝ ten kàa nɗǝǝn ɗengnaan. NYaksǝ ɓe wur tong a nsarse nNaan. Wur a mishkoom nkaa nenlep nNaan mo, kǝ mbii mo jir ɗe moo iiko. ");
INSERT INTO sur_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","Kaaɗi gyet Jesu wur shwaajeel nɗǝǝn nan, nǝ aasǝ ɓe nǝ ret kǝ nwun wu ɗak suk mbǝkǝ nwun shwaajeel ɗi nɗǝǝn nan kaaɗi gyet wur shwaa sǝ zak. Mbǝɗǝ koo ngwe ɗeɗang nǝ, ɗewur shwaajeel nɗǝǝn nan ɗesǝ, ɓe wur yit shikbish. ");
INSERT INTO sur_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","Yool nyaksi, taji wu yit kǝ coor mǝ pǝtuup fuu mo se korong nkaa wun kas, ɗangɓe nǝ ret kǝ nwun cìn a mbii ɗe Naan kǝ rǝɓet kǝ nwun cìn shidaar-shidaar. ");
INSERT INTO sur_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","Wuu ten wu watpee ɗes nkaa cìn mbii ɗebish, kaa nen ɗe baa mo man Naan kas, moo cìn sǝ. Taji wu cìn mbii mǝnǝ mo kas. Gyet nyam ɓe wuu mwaan a nɗǝǝn coor mǝ nan fuu mo, baa gyet tong fuu nǝ mo ret kas. Gyet coor mǝ nan nǝ mo se korong nkaa wun. Gyet wuu sat a nshwaamwes, kǝ nǝ yuur wun ɗi ɗak, shidaar-shidaar ɓe wuu kuur ashak mbee shwaayuur, ɗeɗang gyet wuu seyil nkùm mo, jir mbii ɗesǝ mo, ɓe Naan wur cii mo hakyeng. ");
INSERT INTO sur_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","Ɗang nyaksǝ, baa wu kuɗi wuu cìn mbii ɗebish sǝ mo ashak kǝ mo kas. Nǝ aapwoo ngurum mo, mbǝɗe baa wu kuɗi wuu cìn mbii ɗesǝ mo ashak kǝ mo kas, mbǝmǝnǝ ɓe moo kas wun. ");
INSERT INTO sur_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","Ɗang parmeeci, ɓe nen ɗesǝ mon nɗar ntoom Naan, kǝ wur tokɗyeel ɗi mmo, mbee mbii ɗe mo cìn mo nɗǝǝn nyil ɗesǝ. Baa pee nǝ kuɗi jong-jong kas, aku Naan tokɗyeel ɗe mmo, nen ɗe mo kuɗi kǝ seen nɗǝǝn nyil ɗesǝ, kǝ nen ɗe mo kǝ ten murep mo. ");
INSERT INTO sur_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","A nǝ le ɗang mo satpwoo Naan nǝ nen ɗemǝmurep mo, a mbee kǝ riin mmo kat seen ɗi, kaaɗi Daa Naan wur kǝ seen sǝ. ");
INSERT INTO sur_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","Parɗi yil ɗesǝ nǝ nkyes, baa nǝ kǝ jì wul kas, mbǝmǝnǝ wu tap kǝ káa fuu mo, kǝ nwun ɗar ɗi ɓalɓal, mbǝkǝ nwun mak cìn ɗangnaan ɗi. ");
INSERT INTO sur_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","Mbii ɗe nǝ koop nǝ met jir nǝ a nǝnee, << wu sat a walnshak shi pǝtuup mǝndong shidaar-shidaar. Mbǝɗe katɗang wuu wal ngurum mo, ɓe baa wun nsat a pan shikbish ɗe mo cìn mo nkaa wun kas. ");
INSERT INTO sur_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","Wu wang polu fuu mo nshak. Wu cin mbii ngurum a shi pǝtuup mǝndong. ");
INSERT INTO sur_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","Naan wur nle ɗeret nkaa wun nɗǝǝn ar mo shini-shinǝ. Wur shinɓal ngurum mo mbee cìn ɗak mo shini-shinǝ. Mpeemǝnǝ, ɓe nǝ ret kǝ koo we, ɓe wur cìn ɗak nǝ nɗǝǝn ar ɗeret. Nǝ ret kǝ wur cìn ɗak kǝ ɓal ɗe Naan kǝ le nǝ nsar fuu, mbǝkǝ nwun ɓam gurum mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","Katɗang Naan wur cin a iiko mee gurum ɗe mǝ sat mee pwoo ngurum, ɓe wu yit kǝ gwar mǝnǝ sat a pwoo ɗe nǝ put pee Naan ɗi. Katɗang Naan wur shin mmee gurum, a iiko ɗe mǝ cìn ɗak mbee niyee mo, ɓe wu yit kǝ wur shin ɗeɗes nNaan mbee mbii mo jir, nɗǝǝn Jesu Kristi. A wur a ngwe ɗewur kǝ ɗeɗes kǝ iiko mbe ngha-ngha. Amin. ");
INSERT INTO sur_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","Wun ɗi kǝn wal nwun, taji nǝ ɗee nwun a mbii aapwoo kas, mbǝɗe wu ɗel nɗǝǝn jeel ɗenaat mo ɗes. Mbii ɗesǝ mo kat wun, a mbǝkǝ mo cam shinzeen fuu ɗi nɗǝǝn Naan. Mpeemǝnǝ taji wu pan nǝ jeel ɗe mo jì nkaa wun nǝ, mo a mee mbii ɗiiɗik kas. ");
INSERT INTO sur_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","Wun a nkaa ɓalkaa nɗǝǝn jeel ɗe gyet Daa Jesu Kristi wur kǝ shwaa, mbǝkǝ parpuus ɗe gurum mon nnaa ɗeɗes wur agaak, ɓe wun ngam kǝ retnyit. ");
INSERT INTO sur_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","Katɗang gurum mo sat mee pwoo ɗebuu nkaa wun, mbǝɗe wun a nen mǝ Kristi mo, ɓe wu cìn retnyit, mbǝɗe Riin nNaan ɗewur a ɗeɗes hakyeng wur ashak kǝ wun. ");
INSERT INTO sur_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","Ɗang katɗang mee gurum shwaajeel a mbǝɗe wur cìn mbii ɗebish, kaa tukáa sǝ, koo cìn wat, koo ngule pwoo nɗǝǝn mbii ɗe baa wur ɗǝǝn nǝ kas, baa kyeet kǝ shwaajeel mǝnǝ kǝ mee mbii ɗeret ɗǝǝn nǝ, ɗe gurum mon nkwoop nǝ kas. Wu tap kǝ káa fuu mo. Taji mee ngwe cìn mbii ɗebish, ɗe nǝ nle kǝ wur lap nkyeet kǝ kwat mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","Ɗang kat mee ngwe shwaajeel, a mbǝɗe wur a ngutaa nɗang Kristi, ɓe taji wur kat yitlwaan kas, ɗangɓe nǝ ret kǝ wur kwoop Naan, mbǝɗe gurum moo naa wur a ngwe mǝ Kristi. ");
INSERT INTO sur_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","Katɗang pee nǝ wul ɗe Naan wur ntokɗyeel ngurum mo, ɓe wur nshee a nkaa nen wur mo. Katɗang Naan wur nshee tokɗyeel nǝ a nkaa nen wur mo, ɓe a me ncìn kǝ nen ɗe mo ciipwoo Naan ne? ");
INSERT INTO sur_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","Nǝ a rǝran nɗǝǝn ɓǝǝt haal nNaan nǝnee: <<<<Katɗang nǝ nluk, mbǝkǝ nenɗeret mo kat ɓam, <<ɓe a me nkat nen shikbish ɗe baa mo man Naan kas se?>> ");
INSERT INTO sur_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","Mbǝmǝnǝ nen ɗe mo shwaajeel, ɗe nǝ a shi rǝɓet nNaan, ɓe nǝ ret kǝ mo sat a ncìn mbii ɗeret mo. Kǝzak, nǝ ret kǝ mo lekáa fur nɗǝǝn sar nNaan ɗewur le mo, kǝ ɗewur gam mbii mo jir. Mbii ɗewur sat nǝ, wuɗin ncin mmo. ");
INSERT INTO sur_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","Wen kǝ mee mbii mbee sat nwun, wun ɗe wun a nennan mo nɗǝǝn Ekɨlisya. Wen shikáa fen, an a ngunan kaa wun sǝ. Gyet nyam, ɓe an kǝn naa shi yit fen kyeet kǝn shwaajeel ɗe gyet Daa Jesu wur shwaa, ɗangɓe nyaksǝ, ghan kǝn ɓalkaa kǝ wun, mbǝkǝ mo naa ɗeɗes Jesu ɗi nǝ nɗǝǝn mun, ɗe Naan wur woo nǝ mmun agaak. A mbǝmǝnǝ, ɓe wen kǝn ɗang pǝ wun nǝnee, ");
INSERT INTO sur_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","wu naa nen Naan mo. Nen ɗewur le mo nsar fuu, mbǝkǝ nwun tap mo ɗi. Wu tap mo kaaɗi ngukiyeer tǝm wur tap tǝm wur mo sǝ, mbǝkǝ taji mee mbii tung mo kas. Taji wu cìn ɗak nǝ a kaaɗi mee gurum sat nǝ, tǝng wu cìn sǝ kas. Ɗang wu cìn ɗak shi pǝtuup mǝndong, kaaɗi gurum kǝ fes cin káa wur mbee cìn ɗak sǝ. Wu lekáa fuu mo nkaa cìn ɗak ɗesǝ nǝ. Kaji wu ɗee nleyit a nkaa shool ɗe gurum mon nkwat wun kas, mbǝɗe nǝ a mbii naashweep kǝ gurum ɗee, ntang shool nɗǝǝn ɗak kaa ɗesǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","Taji wu ɗee nkám ɓàl fuu nkaa nen ɗe Naan wur le mo nsar fuu kas, mbǝkǝ nwun tap mo ɗi. Ɗang nǝ ret kǝ shiimwaan fuu mo ɗee a mbii ɗe nǝ ret kám ngurum mo. ");
INSERT INTO sur_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","Katɗang mwaan fuu nǝ mo a ɗeret, ɓe parpuus ɗe Daa Jesu Kristi, ɗewur a káa nenkyeer tǝm nǝ mo, wur njì put agaak, mbǝkǝ gurum mo naa wur ɗi jir, ɓe wur ncin mee mbiizuum ɗe shang ɗe nii koop nǝ hakyeng nwun nen ɗe wu ɗar ɓalɓal. Mbiizuum ɗesǝ nǝ a ɗe ngha-nghan ɗe baa nǝ ncam wat kas. ");
INSERT INTO sur_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","Wun jepzǝlang mo, wu sham kǝ káa fuu mo ndǝr nennan mo. Wun jir, wu shin ɗeɗes nshak, kǝ nwun tong shi ɗak suk mbee cìn ɗak nshak. Mbǝɗe nǝ a rǝran nɗǝǝn ɓǝǝt haal nNaan nǝnee: <<<<Naan wur cii nenroop mo, <<ɗangɓe wur le ɗeret nkaa nen ɗe mo sham kǝ káa fur mo.>> ");
INSERT INTO sur_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","Nǝ aasǝ ɓe wen kǝn sat nwun nǝnee, << wu sham kǝ káa fuu mo ntoom nNaan ɗewur kǝ ɓal, mbǝkǝ wur ɗiyeep wun ɗi, katɗang wur naapee nǝ wul wur nyit. ");
INSERT INTO sur_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","Mbii ɗe moo daampee nwun jir, ɓe wu le mo nɗǝǝn sar nNaan, mbǝɗe a wur tap wun jir. ");
INSERT INTO sur_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","Taji wu ɗee ntan kas, ɗangɓe wu tong shi gongpee, mbǝɗe shaarlek fuu Ngujwaan wur kǝ mwaan mass-mass kaa mbwoor ɗe nǝ wal kaaɗi nǝ nkaa tang ngwe ɗe nǝ nse. ");
INSERT INTO sur_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","Wu ɗar ɓalɓal. Taji wu shin pee nwur kas. Wu sekyeen kǝ cìn ɗak nNaan ɓejee ɗak. Taji kǝǝrmuut ya wun kas. Wu man nǝnee, << ɗyemnǝǝn fuu nen Jesu mo koo a nǝ nɗǝǝn nyil ɗesǝ, ɓe mon nkaa shwaajeel kaaɗi wuu shwaajeel nyaksǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","Katɗang wu shwaajeel nǝ mbee reppee lee, ɓe Naan ɗe mbii ɗeret mo jir, moo put a pee wur ɗi, wur ɗe gyet wur pet wun, mbǝkǝ nwun tong ɗi ashak kǝ Kristi nɗǝǝn ɗeɗes wur, ɗe nǝ dǝm ngha-ngha. A Naan shikáa wur, wur njì ɗak wun. Wur nshin ɓal nwun, mbǝkǝ nwun ɗar ɗi ɓalɓal nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","Naan wur le kǝ ɓal wur nǝ ɗee ashak kǝ wun jir. Amin. ");
INSERT INTO sur_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","A Silas ɓam ghan mbee ran rep wasika ɗesǝ nǝ, nwun. Wen kǝn naa wur a kaa ɗyemnǝǝn nɗǝǝn Kristi sǝ, ɗewur koop nǝ hakyeng, ɗe gurum mak gángkáa nkaa wur. Wen kǝn ran pwoo ɗesǝ mo nwun, a mbǝkǝ nghan caa pǝtuup fuu mo ɗi. Wen a nkaa sat zeen nǝ nwun agaak nǝnee, << Naan wur le ɗeret nkaa wun. ");
INSERT INTO sur_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","Ekɨlisya ɗe nǝ nɗǝǝn pee ɗesǝ nyil mBabilon, ɗe Naan wur kǝ ten bilip nǝ, kaaɗi wur bilip wun sǝ, moo tok kǝ wun jir. Làa fen Maak wur tok kǝ wun zak. ");
INSERT INTO sur_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","Wun zak, wu tok kǝ shak nɗǝǝn wal, kǝ nǝ kám ɗi nǝnee, << wuu wal nshak kaa ɗyemnǝǝn ɗe moo dǝm nɗang Jesu ashak sǝ. Wu yit kǝ ryang nDaa Jesu Kristi nǝ tong ashak kǝ wun jir, wun ɗe wun a mǝ Jesu Kristi mo. Amin.");
INSERT INTO sur_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","A wen Simon Pita, kǝrem kǝ laalep nDaa Jesu Kristi, kǝn ran wasika ɗesǝ shidǝm pee wun ɗi jir, wun nen ɗe wun kǝ shinzeen ɗe nǝ nciit kǝ munu, nɗǝǝn ɗeret nNaan fun, kǝ Nguɓam fun Daa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("P21_2","091_1_2","2PE","1","2","2","Ɗeret kǝ ryang mo ɗee a muu ɗes hakyeng, nɗǝǝn man Naan kǝ Jesu Daa fun. ");
INSERT INTO sur_vpl VALUES ("P21_3","091_1_3","2PE","1","3","3","Naan nɗǝǝn ɗeɗes mǝ man wur, ɓe wur kǝ ten bilip mun, mbǝkǝ mun tong ɗi ashak kǝ wur nɗǝǝn ɗeɗes wur, kǝ nɗǝǝn ɗeret wur zak. A nɗǝǝn ar ɗesǝ, ɓe wur cìn ɗak kǝ ɓal wur ɗeɗes, mbǝkǝ wur cin mbii mo ɗe mmun jir. Mbii ɗe baa mun kǝ mo kas, kǝ mu kat seen ɗe, kǝ mbǝkǝ mun mwaan ɗi nɗǝǝn ar ɗe nǝ ret nwur nyit. ");
INSERT INTO sur_vpl VALUES ("P21_4","091_1_4","2PE","1","4","4","A nɗǝǝn ar ɗesǝ, ɓe wur cin mbii mo mmun ɗes, mbiizuum ɗe shang ɗe gyet wur kǝ ten sat nǝ, wur ncin mmun. Wur cin mbii ɗesǝ mo jir, a mbǝkǝ nɗǝǝn mbiizuum ɗesǝ mo, ɓe mun npwat nɗǝǝn mbii ɗebish, ɗe mo ɗi nɗǝǝn yil ɗesǝ, ɗe gurum mo fes rǝɓet mo. Ɗang wur kǝ ten pǝrep wun, mbǝkǝ nwun tong ɗyen ɗi nNaan. ");
INSERT INTO sur_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","Mpeemǝnǝ, ɓe wen kǝn sat nwun nǝnee, << kaaɗi wuu ten wu shinzeen nJesu Kristi, ɓe wu gung, mbǝkǝ shiimwaan fuu mo ɗee ɗi a ɗeret hakyeng, kǝzak, wu gung kǝ nwun man mbii mo ɗi. ");
INSERT INTO sur_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","Taji wu yit nǝ ɗee a man mbii mo ɓejee kas, ɗangɓe wu gung kǝ nwun yaasuk ɗi. Kaaɗi wuu gung mbǝkǝ nwun yaasuk ɗi, ɓe wu ɗar ɓalɓal nɗǝǝn mbii ɗeret mo jir, kǝ nwun shin ɗeɗes nNaan. ");
INSERT INTO sur_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","Kaaɗi wuu mwaan nɗǝǝn ar ɗe nǝ shang nNaan sǝ, ɓe nǝ ret kǝ wu tap kǝ shak a kaa ɗyemnǝǝnshak mo sǝ. Wu wal ngurum mo jir. ");
INSERT INTO sur_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","Katɗang wuu sat a ncìn mbii ɗeret ɗesǝ mo ɗak, ɓe baa man fuu ɗe nǝ nɗǝǝn Jesu Kristi nǝ nɗee a ɗebuu kas, ɗangɓe seen fuu nǝ mon nlàa-làa ɗeret mo. ");
INSERT INTO sur_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","Ɗang nen ɗe baa mo kǝ ɗyen ɗe nǝ a mǝ Naan kas, mo a kaa vum ɗe baa moo naapee kas sǝ. Mo mundǝr nǝnee, << Naan wur kǝ ten fwo ɗi mmo mbee shikbish ɗe moo cìn. ");
INSERT INTO sur_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","Mpeemǝnǝ, ɗyemnaa mo, wen kǝn ɗang pee wun, mbǝkǝ nwun ɗar ɗi ɓalɓal nɗǝǝn mbii ɗesǝ mo, mbǝɗe Naan wur kǝ ten pǝrep wun, kǝ nwur bilip wun, mbǝkǝ nwun ɗee ɗi a nen wur mo. Katɗang wuu cìn mbii ɗeret nǝ mo, ɓe baa wun ncam pal kas. ");
INSERT INTO sur_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","Nǝ aasǝ ɓe, Naan wur wang polu nǝ nwun, mbǝkǝ nwun ɗel ɗi nɗǝǝn se mishkoom nDaa fun Jesu Kristi. Wur ɗewur a Nguɓam fun. Mun ntong ashak kǝ wur mbe nghaa-nghaa. ");
INSERT INTO sur_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","A Mbǝmǝnǝ, ɓe kǝn sat nwun shidaar-shidaar, mbee lepan nwun nkaa mbii ɗesǝ mo jir, koo ɗi wuu ten wu man mo, kǝ kaaɗi wuu ɗar ɓalɓal nɗǝǝn zeen, ɗe wu man mo. ");
INSERT INTO sur_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","Kaaɗi wen kuɗi kǝ seen nɗǝǝn nyil ɗesǝ, ɓe ghan naa nǝ ret, mbǝkǝ nghan lepan ɗi nwun nkaa mbii ɗesǝ mo shidaar-shidaar, mbǝkǝ taji wu ɗee nsaam kas. ");
INSERT INTO sur_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","Wen man nǝnee, << nɗǝǝn rep pee lee, ɓe yak ghan nyit nan mǝ yil ɗesǝ nǝ ɗi, kaaɗi gyet Daa fun Jesu Kristi wur kám nwen nǝ, an cìn aasǝ. ");
INSERT INTO sur_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","Wen ngung hakyeng, mbǝkǝ nghan lepan ɗi nwun nkaa mbii ɗesǝ mo koo pǝrang ghe, koo aɓwoon ɗe kǝn muut. ");
INSERT INTO sur_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","Gyet nyam ɓe mu satpwoo nwun nkaa jì nDaa fun Jesu Kristi nɗǝǝn ɓal wur. Mbii ɗe gyet mun nkaa sat nǝ nwun, baa nǝ a mee pwoo tongɗiryem ɗe mo put a nɗǝǝn pan mu gurum mo kas, ɗangɓe mun shikáa fun, ɓe muu ten mu naa ɗeɗes wur shi yit fun mo. ");
INSERT INTO sur_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","Kaaɗi, gyet Jesu wur lap ɗeɗes kǝ ɗehai, pǝ Naan ɗi, ɓe mun ɗe gyet mu kǝlǝng, kaaɗi Naan ɗeɗes met jir wur sat mee pwoo nǝnee: <<<<Ɗesǝ a Làa fen, ɗe wen wal wur. <<Ɗi wur cìn mbii ɗe mo ret nwen nyit zam.>> ");
INSERT INTO sur_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","Mun shikáa fun, gyet mun ɗi ashak kǝ Daa fun Jesu Kristi nkaa ɗengjwak nNaan, gyet mu kǝlǝng ɗoo ɗe nǝ tong aɗeng sham. ");
INSERT INTO sur_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","Pwoo kǝ nensatpwoo kǝ Naan mo sǝǝt kám mmun agaak nǝnee, << mbii ɗesǝ mo azeen-nzeen. Nǝ ret kǝ nwun lekáa fuu mo nkaa pwoo kǝ mo nǝ mo, mbǝɗe pwoo mǝnǝ, nǝ a kaa ngyam ɗe nǝ ɓangpee nɗǝǝn kwoo sǝ, wul kus kǝ ɓitmang mǝ puus mǝnǝ. Parpuus mǝnǝ, kaaɗi zar mangɓit nǝ kàa put, ɓe nwun naa mbii mo agaak ndǝre-ndǝre nɗǝǝn pǝtuup fuu mo aasǝ. ");
INSERT INTO sur_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","Mbii ɗe nǝ kǝkoop nǝ met jir, ɓe wen kǝn sat nwun nǝnee, << pwoo ɗe gyet nensatpwoo Naan mo kǝ ten sat nǝ, ɗe mo a rǝran nɗǝǝn ɓǝǝt haal mǝ Naan, baa mo put a nɗǝǝn pan mǝ gurum mo kas. ");
INSERT INTO sur_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","Mbǝɗe pwoo ɗe gyet nensatpwoo Naan mo sat, baa gyet nǝ put a nɗǝǝn pan mǝ gurum mo kas, ɗangɓe gyet a Riin Ɗeɓang mǝ Naan, wur ɗel nɗǝǝn pǝtuup mmo, ɗangɓe wur le kǝ mo sat mee pwoo ɗe nǝ put a pee Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","Ɗang gyet nyam, ɓe nensatpwoo mǝ ɗung mo yol ɗi nɗǝǝn gurum nǝ mo, kaaɗi nensatpwoo mǝ ɗung mon nɗel ɗi nɗǝǝn wun sǝ. Mon ncìn kám ɗebish, ɗe nǝ nwat shinzeen gurum mo, ɓe mon nciipwoo nkaa Daa Jesu Kristi nǝnee, << baa wuɗun man wur kas. Wur ɗe gyet wurang mo nɗǝǝn shikbish fur mo, mbee mbii ɗebish ɗe mon nkaa cìn nǝ. Ɓe nɗǝǝn rep pee lee, ɓe kwat ɗe nǝ a mǝ jeel ɗeɗes nǝ njì taa nkaa mo, kǝ nǝ ntwe mo. ");
INSERT INTO sur_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","Gurum mo ɗes mon mmwaan nɗǝǝn shiimwaan fur ɗe nǝ a mǝ naashweep. Ɗang mon nle kǝ gurum sat mee pwoo ɗebish nkaa zeen mǝ ar nNaan. ");
INSERT INTO sur_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","Nensatpwoo mǝ ɗung nǝ mo, moo rǝɓet mbii gurum mo aasǝ, kǝ mo cìn ɗung mbǝkǝ mo nǝk wun, kǝ mo kat mee lǝɓet ɗi. Pǝgyet ɗi yam-yam, ɓe Naan ɗewur ntokɗyeel ngurum mo jir, wur kǝ ten ɗak shin, mbǝkǝ wur shin kwat ɗe mo mǝ mbii ɗebish ɗe moo cìn mo. Peeɗi seen mmo nǝ nkyes ɗi azeen-nzeen, ɓe nǝ kǝ jì wul kus. ");
INSERT INTO sur_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","Gyet nenlep Naan ɗe mo cìn shikbish, ɓe baa Naan wur nyit mo kas. Wur yak mo ɓe wur fwo mo nɗǝǝn tuun ɗe nǝ a mǝ aawus, a ɓuɓwoot shi tǝsek ɗe nǝ a mǝ shool, nɗǝǝn pee ɗe kwoo ɗe nǝ rap. Mon ntong a nɗǝǝn peemǝnǝ jiwul npuus ɗiyeel. ");
INSERT INTO sur_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","Nenɗenyam, ɗe gyet mo cìn shikbish, ɓe baa Naan wur nyit mo kas. Naan wur le kǝ am ɗeɗes nǝ jì tu nen ɗe gyet mo cii kǝlǝng ɗoo wur jir. Gyet a Nowa ɓejee, ɗe Naan tap wur, mbǝkǝ taji mee mbii tung wur kas, mbǝɗe gyet Nowa wur satpwoo ngurum mo nǝ, mo cìn mbii ɗeret. Nowa wur bar, kǝ gurum mo pwoovǝl. ");
INSERT INTO sur_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","Gyet Naan wur twe yil nSodom kǝ nGomora shi wus, ɓe mo ɗee a fwat. Yil ɗesǝ mo ɗee a mbiikám ngurum mo, nkaa mbii ɗe nǝ nkat nen ɗe baa mo kǝ Naan nɗǝǝn pǝtuup fur mo kas. ");
INSERT INTO sur_vpl VALUES ("P22_7","091_2_7","2PE","2","7","7","Gyet nciit kǝ mǝnǝ, ɓe wur ɓam Lot ɗe gyet wur a ngwe ɗɨ ndǝre. Gyet shikbish ɗe gurum mo cìn, nǝ fes daampee mpǝtuup wur zam, mbii ɗebish ɗe gyet nen ɗebish ɗesǝ moo cìn. ");
INSERT INTO sur_vpl VALUES ("P22_8","091_2_8","2PE","2","8","8","Lot wur a ngwe ɗe ndǝre. Gyet wur tong ashak kǝ nenshikbish ɗesǝ nǝ mo, wur naa mbii ɗebish ɗe moo cìn shidaar-shidaar, kǝ gyet wur kǝlǝng pwoo mo ɗebish nǝ mo shidaar-shidaar zak. Shikbish ɗe des mǝnǝ mo cìn nǝ, nǝ fes wàt pǝtuup wur zam, mbǝɗe gyet wur a ngwe ɗe ndǝre. ");
INSERT INTO sur_vpl VALUES ("P22_9","091_2_9","2PE","2","9","9","Mbii ɗe mo kǝ ten ɗel gyet nyam nǝ mo, mo kám mmun nǝnee, << Naan wur man ar ɗewur mɓam nen wur mo ɗi nɗǝǝn jwaan. Mbii ɗesǝ nǝ mo waa kám zak nǝnee, << Naan wur man ar ɗewur nkwat nen cìn shikbish mo, ɗi wur nle mo ndǝr kǝ kar, jiwul parpuus ɗiyeel. ");
INSERT INTO sur_vpl VALUES ("P22_10","091_2_10","2PE","2","10","10","Met jir, nǝ a mbee nen ɗe moo sat a ncìn mbii ɗebish ɗak, ɗenan mo nǝ naa ncoor nǝ, kǝ mo waa ciipwoo nNaan. Nenkám ɗe mǝ ɗung ɗesǝ mo, mo ɓal mpǝtuup, kǝ cíishik zam. Baa mee kǝǝrmuut kǝ ya mo mbee satpwoo ɗebuu nkaa riin ɗeɗes ɗe mo nɗǝǝn ɗengnaan kas. Moo sat a nkàss mo ɗak. ");
INSERT INTO sur_vpl VALUES ("P22_11","091_2_11","2PE","2","11","11","Nen lep Naan mo met nenɗung ɗesǝ mon mɓal, ɓe baa mo kas mo kǝsǝ ntoom Naan kas. ");
INSERT INTO sur_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","Nen ɗesǝ nǝ mo, moo satpwoo ɗebish nkaa mbii ɗe baa mo manshii nǝ ndǝre-ndǝre kas. Moo cìn mbii mo a kaa nen ɗe baa mo man mee mbii kas sǝ. Moo cìn mbii mo a kaa luwayil mo sǝ. Ɗi mo làa mo a mbǝkǝ gurum mo yak mo twe ɗi nluwaa. Azeen-nzeen moo twe mo a kaa luwayil mo sǝ, ɗe baa gurum mo kuɗi kǝ kǝlǝng sǝm mo kas. ");
INSERT INTO sur_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","Naan wur kwat mo shi jeel, mbee jeel ɗe gyet mmo kǝ shin ngurum mo. Nen ɗesǝ nǝ mo rǝɓet a kǝlǝng shang mǝ seen ɗesǝ ɓejee, ɓe moo cìn pak mbii nǝ mo a nnaar puus. Shiimwaan mmo nǝ mo, mo a mbii yitlwaan pee wun ɗi. Moo tong ashak kǝ wun mbee se mbiise, ɗangɓe moo tap ciir mɓwoon fuu, kǝ mo cìn mbii ɗebish ɗe mo shang mmo ɗi. ");
INSERT INTO sur_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","Duk lepan mo a nkaa mat mo, mbǝkǝ mo cìn ngaa ɗi kǝ mo shidaar-shidaar. Baa cìn shikbish nǝ cam mak mo kas. Kat mo naa nen ɗe baa mo ɗar ɓalɓal nɗǝǝn ar Naan kas, ɓe mo nǝk nen mǝnǝ mo, mbǝkǝ mo cìn mbii ɗebish ɗi. Koo pǝranghe, ɓe moo leyit a nkaa mbii mǝ gurum mo. Gurum kaa mǝnǝ mo sǝ, ɓe mon ntaa ndǝr ɗyeel mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","Duk yit ar ɗe ndǝre nǝ, kǝ mo waa kǝ mwaan ɗe a nɗǝǝn ar nBalaam làa Beyor. Gyet Balaam wur a ngwe ɗewur fes kǝlǝng shang mbee cìn mbii ɗebish, mbǝkǝ wur kat shool ɗi. ");
INSERT INTO sur_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","Ɗangɓe mo gwak wur mbee shikbish wur, ɗang nciit kǝ mǝnǝ, ɓe jaaki wur ɗe baa nǝ kǝ cam sat mee pwoo kas, ɓe nǝ sat mee pwoo nwur kaa gurum sǝ, ɓe njaakii nǝ le kǝ wur nook cìn nkyeet kǝ shikbish mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","Das ɗesǝ nǝ mo ɗee a kaa dung ɗe baa moo am kas sǝ. Mo ɗee a kaa nluu ɗe kut kǝ mang nǝ ɗel shidǝm kǝ nǝ sǝ, mbǝkǝ taji nǝ jì kǝ fwan kas. Naan wur tap ɗak mee pee ɗǝǝn nkòo le ɗi mbee mo. ");
INSERT INTO sur_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","Moo leshap shi ɗoo ɗeɓal nkaa pwoo ɗe baa mo kǝ mee koop nǝ kas koo dǝɓen. Mo gung mbǝkǝ mo nǝk nen ɗe mo nkaa pwat nɗǝǝn nen ɗi baa mo man zeen nǝ kas. Mo gung kǝ mo dul nen mǝnǝ mo jì cìn shikbish, ɗi mo a mǝ ngaa, kaaɗi moo cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","Duk nkaa tuwap shi sǝm mo nǝnee, << mo katpee mbee cìn mbii ɗe moo rǝɓet, ɗangɓe mǝ mo nen ɗe mo sat pwoo mǝnǝ, mo a kǝrem mǝ shikbish. Mbǝɗe koo a mbemi ɗe nǝ ɗee a mishkoom nkaa gurum, ɓe ngwe mǝnǝ ɗee a kǝrem mbii nǝ. ");
INSERT INTO sur_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","Katɗang gurum mo kǝ ten put nɗǝǝn mbii ɗebish nyil ɗesǝ, ɗe moo wat, mbǝɗe mo kǝ shinzeen nJesu Kristi, ɗewur a Nguɓam fur. Ɗangɓe katɗang mo waa ciir pǝtuup, ɗang kǝ mbii ɗebish mo waa ya mo, kǝ mo se korong nkaa mo, ɓe nǝ ɗee nǝnee, << nɗǝǝn peekyes nǝ, ɓe mbii nǝ mbish nkaa mo met ɗinshee nǝ. ");
INSERT INTO sur_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","Katɗang nǝ ɗee aasǝ, ɓe ngyal gyet mon nnook man ar ɗe ndǝre nǝ, mbǝɗe baa nǝ kǝkoop nǝ, kǝ gurum mo man ar nǝ hakyeng, ɗangɓe mo waa ciir pǝtuup fur mo, kǝ mo yit Wàar kǝ Naan nǝ kas. ");
INSERT INTO sur_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","Mbii ɗe nǝ kat mo, ɓe nǝ kám mmun nǝnee, << sǝmpwoo ɗesǝ mo azeen ɗe mo sat nǝnee: <<<<As waa baa dǝǝm se mbii ɗe nǝ kǝ fuut, kǝ ntuus ɗe gurum kǝ vwang, nǝ waa baa dǝǝm ɓɨring nɗǝǝn ɓook.>> ");
INSERT INTO sur_vpl VALUES ("P23_1","091_3_1","2PE","3","1","1","Wun ɗe wen wal nwun sǝ mo, ɗesǝ nǝ a wasika ɗevǝl, ɗe wen kǝn ran nwun. nƊǝǝn wasika ɗevǝl sǝ nǝ mo, ɓe wen kǝn lepan nwun nkaa mbii ɗesǝ mo, ɗe wuu ten wu man mo, mbǝkǝ nǝ mii wun ɗi, kǝ nwun dǝm ɗi ndang Naan shi pǝtuup ɗemǝndong. ");
INSERT INTO sur_vpl VALUES ("P23_2","091_3_2","2PE","3","2","2","Wen kǝn ran mbii ɗesǝ nǝ mo, a mbǝkǝ nghan lepan ɗi nwun, kǝ taji wu mundǝr kas pwoo ɗe pǝgyet nensatpwoo Naan ɗeɓang mo kǝ sat nǝ, nǝnee nǝ ncìn. Taji wu mundǝr nWàar ɗe Daa fun Jesu Kristi, ɗewur a Nguɓam fun wur sat nǝnee, << wu cìn mo kas. Gyet a wur nkaa satpwoo nǝ nwun shipo jeplep wur mo, ɗewur lep mo pee wun ɗi. ");
INSERT INTO sur_vpl VALUES ("P23_3","091_3_3","2PE","3","3","3","A pwoo ɗinshee ɗe kǝn rǝɓet sat nǝ nwun nɗesǝ. Wu man nǝnee, << kus kǝ kyes mǝ yil nǝ, ɓe gurum mon yool ya cìn mbii ɗe nǝ shang mmo nyit. Nen ɗesǝ nǝ mon nyaa shwar mǝ ɓákpee, ");
INSERT INTO sur_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","kǝ mon nsat nǝnee: <<<<A me le ɗangɓe baa Jesu Kristi wur jì, <<kaaɗi gyet wur kǝ ten sat sǝ kas sii? <<Puun fun mo kǝ ten murep, <<ɗangɓe mbii mo ɗe a kaa pǝgyet mo ɗi sǝ, <<nciit kǝ shee yil nǝ, baa mee mbii <<shee ɗi kas koo dǝɓen.>> ");
INSERT INTO sur_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","Nen ɗe moo satpwoo ɗesǝ, mo fes cii a nyang. Mo man nǝnee, << gyet nyam ɓe Naan wur le ɗeng kǝ yil ɗesǝ a shi pwoo ɗewur sat. Wur ɗak yil nǝ shi am, ɓe nǝ ɗee nǝ, yil nǝ put a nɗǝǝn am. ");
INSERT INTO sur_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","Nǝ aasǝ ɓe, gyet Naan wur tu yil ɗi mɓít mǝnǝ a shi am, kaaɗi gyet am ɗeɗes, nǝ jì paa yil nǝ jir sǝ. ");
INSERT INTO sur_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","Naan wur kǝ ten sat nǝnee, << ɗeng kǝ yil ɗeyaksǝ mo, mon ntong ɗi mbe parpuus ɗe wus jì caan mo jir hakyeng. Naan wur yit yil nǝ kǝ mbii ɗe mo ɗi jir, ɗang puus nǝ nwul ɗewur ntokɗyeel ngurum mo jir, kǝ wur ntwe nen ɗebish ɗe mo cii kǝlǝng ɗoo wur jir zak. ");
INSERT INTO sur_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","Wun ɗe wen wal nwun mo, mee mbii mǝndong ɗe nǝ kǝkoop nǝ, ɗe baa nǝ ret kǝ nwun mundǝr nnǝ kas. Nǝ a nǝnee, << pee Naan ɗi, ɓe teer mǝndong nǝ a kaa ɓit mo ngal sǝ, kǝzak, ɓit mo ngal, ɓe nǝ a kaa teer mǝndong sǝ. Duk a ɗemǝndong pee Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","Pak gurum moo pan nǝnee, << Naan wur cii zam, mbǝɗe baa wur nkaa cìn mbii ɗewur kǝ ten sat nnǝ, mbii mǝnǝ mon ncìn kas. Baa nǝ aasǝ kas, koo dǝɓen, Naan wur gung kǝ wun, a mbǝkǝ wur shínpee ɗe ngurum mo, mbǝkǝ mo katpee tuwap ɗi. Baa nǝ a ɗyen Naan kǝ mee gurum loom ɗi kas. Wur rǝɓet kǝ gurum mo jir, mmo tuwap. ");
INSERT INTO sur_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","Jir kǝsǝ, katɗang pee nǝ wul, ɓe Daa Jesu Kristi wur mbaajì. Wur baajì a nnǝ mman! Kaa jì wat, ɗe baa gurum mo lepan nǝ, mee wat njì kas sǝ. Nciit kǝ mǝnǝ, ɓe gurum mon nkǝlǝng mee ɗoo ɗeɓal, a ɗengnaan nǝ loom. Jir mbii ɗe mo nɗǝǝn ɗengnaan, kǝ ɗe mo nɗǝǝn yil ɗesǝ, mon ncaan jir. Ɗangɓe yil ɗesǝ kǝ mbii ɗe mo nɗǝǝn nǝ jir, mon loom. ");
INSERT INTO sur_vpl VALUES ("P23_11","091_3_11","2PE","3","11","11","Kaaɗi wun kǝ man nǝnee, << mbii mo jir mon loom aasǝ, ɓe nǝ ret kǝ nwun ɗak tong fuu mo, kǝ nwun tap ɗi kǝ shiimwaan fuu mo. Nǝ ret kǝ seen fuu mo ɗee a ɗeɓang, kǝ nwun lesuk nɗǝǝn sar Naan kǝdǝng-ndǝng. Kǝ nwun kǝlǝng ɗoo wur nɗǝǝn mbii mo jir. ");
INSERT INTO sur_vpl VALUES ("P23_12","091_3_12","2PE","3","12","12","Wu leyit nkaa parpuus ɗe Naan wur mbaajì nɗǝǝn yil ɗesǝ zak, kǝ nwun cìn mbii mo nɗǝǝn ar ɗeret, ɗe nǝ nle kǝ puus mǝnǝ jì wul ɗi kǝlak-kǝlak. A puus mǝnǝ, a ɗe ɗengnaan nǝ ncaan. Ɗangɓe nǝ loom zak, kǝ mbii ɗe mo nɗǝǝn ɗengnaan jir kǝ ɗe mo nɗǝǝn yil ɗesǝ, mon nɗee a fwat, baa mee mbii nɗee ɗi kas koo dǝɓen. ");
INSERT INTO sur_vpl VALUES ("P23_13","091_3_13","2PE","3","13","13","Ɗangnaan wur kǝ ten sat mmun nǝnee, << wuɗin mbaa ɗak mee ɗengnaan kǝ yil ɗepoo mo ɗe, a pee ɗe mbii mo jir mon nɗee ɗi ndǝre-ndǝre. A mbii ɗe muu leyit nkaa nǝ mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("P23_14","091_3_14","2PE","3","14","14","Wun ɗe wen wal nwun mo, wen kǝn sat nwun nǝnee, << kaaɗi nwun naa puus mǝnǝ, parɗi Jesu Kristi wur mbaajì, ɓe wu gung kǝ mwaan fuu mo ɗee ɗi a ɗiiret, mbǝkǝ wu tong ɗe ryang nɗǝǝn wur. ");
INSERT INTO sur_vpl VALUES ("P23_15","091_3_15","2PE","3","15","15","Wu man nǝnee, << mbii ɗe nǝ le ɗangɓe Daa fun Jesu Kristi wur gung, a mbǝkǝ nwun wu katpee ɗi mbee bar. Ɗyemnǝǝn fun Pool, ɗe mu wal wur, wur cìn ɗak kǝ seen ɗe Naan shin wur, mbǝkǝ wur kám mbii mo ɗi nwun, kaaɗi wur ran wasika wur nwun. ");
INSERT INTO sur_vpl VALUES ("P23_16","091_3_16","2PE","3","16","16","nƊǝǝn wasika wur mo jir, ɓe wur kǝ sat mbii ɗesǝ mo nwun jir. nƊǝǝn pak wasika wur nǝ mo, ɓe nǝ luk mbǝkǝ gurum manshii pak pwoo nǝ mo. Nen ɗe baa mo kǝ seen kas, nen ɗe baa mo ɗar ɓalɓal kas, moo ciir kǝ mbii ɗewur sat nǝ mo. Kaaɗi mo ciir kǝ pwoo ɗe mo nɗǝǝn ɓǝǝt haal nNaan sǝ. Mbii ɗe moo cìn ɗesǝ mo, moo dul a ɗyeel Naan jì nkaa káa moo. ");
INSERT INTO sur_vpl VALUES ("P23_17","091_3_17","2PE","3","17","17","Ɗang wun, ɗe wen wal nwun mo, wuu ten wu man mbii ɗesǝ mo. Mbǝmǝnǝ, wen kǝn sat nwun nǝnee, << wu tap kǝ taji nen ɗe mo cii Naan, mo le kǝ nwun táa wu pal nɗǝǝn shikbish mmo kas. Kaji wu shínpee mmo, kǝ mo le kǝ nwun yol wu yit peeɗar fuu ɗeret nǝ kas. ");
INSERT INTO sur_vpl VALUES ("P23_18","091_3_18","2PE","3","18","18","Ɗang nǝ ret kǝ nwun sekyeen nɗǝǝn ar ɗeret, mbǝkǝ nDaa fun Jesu Kristi, ɗewur a Nguɓam fun wur kám ɗeret wur ɗi nwun, nkaashak nkaashak, mbǝkǝ nwun sat a nwurang nɗǝǝn wal wur. Mu yit kǝ gurum mo shin ɗeɗes ɗi nwur nyaksǝ kǝ mbe ngha-ngha. Amin.");
INSERT INTO sur_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Lepran desǝ nǝ put a nsar fen ngunan, dǝm pee wii ɗi, mat ɗebǝbǝlip pee Naan kǝ jep fii mo. Wii ɗe wen kǝn wal yi ndǝǝn zeen, baa a wen ɓejee ɗak kas, ɗang kǝ jir nen ɗe mo man zeen nǝ. ");
INSERT INTO sur_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","Mbǝɗe zeen ɗe nǝ tong ndǝǝn mun yaksǝ, nǝ ntong ndǝǝn mun ɓe vit. ");
INSERT INTO sur_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Daa Naan puun Làa wur Jesu Kristi, mo cìn ɗeret mmun, kǝ mo naa mun shi yit naajeel, kǝ tongryang. Ɗesǝ mo nɗee ashak kǝ mun ndǝǝn zeen kǝ wal zak. ");
INSERT INTO sur_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Nǝ ret nwen nyit zam, mbǝɗe wen kat pak jep fii moo mwaan ndǝǝn zeen nǝ, nciit kǝ kaaɗe puun wur sat nee, mu cìn sǝ. ");
INSERT INTO sur_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Yaksǝ wen kǝ ɗang pee yi naa, yi yit kǝ mu walnshak. Baa ɗesǝ nǝ a mee wàar ɗepwoo ɗe wen ran nǝ nyi kas, ɗang a ɗe mun kǝ nǝ pǝgyet ɗe nshee, nɗang nǝ mu walshak. ");
INSERT INTO sur_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","A wal nǝ nɗesǝ, nee, mu mwaan ndǝǝn wàar wur mo. Ɗesǝ nǝ a wàar nǝ, kaaɗe wuu kǝlǝng nshee sǝ, nee, wu mwaan ndǝǝn wal. ");
INSERT INTO sur_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Nennumpee mo ɗes, mo kǝ ɗel ɗe ndǝǝn yil nǝ jir. Nen ɗe mo Cíipwoo nee, baa gyet Jesu wur jì ndǝǝn yil desǝ a ndǝǝn nan kas. Kiyeet nǝ mǝnǝ mo a nennumpee mo, kǝ a mo a shaarlek Kristi. ");
INSERT INTO sur_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Wu tap kǝ káa fuu mo, mbǝkǝ taji wu ɓaam mbii ɗe gyet mu ten cìn ɗak mbǝ nǝ sǝ kas, ɗang wu gung, kǝ kwat nǝ gam ɗi. ");
INSERT INTO sur_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Koo a wii ɗe wur dǝm akyeen, ɗang katɗang baa wur mwaan a ndǝǝn kám Kristi kas, ɓe baa wur kǝ Naan kas. Dang jir ngwe ɗe wur sekyeen ndǝǝn kám Daa Jesu, ɓe gwar mǝnǝ kǝ Naan Puun kǝ Làa ndǝǝn pǝtuup wur. ");
INSERT INTO sur_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Katɗang mee gurum jì pee wun ɗi, ɗang baa gwar mǝnǝ jì aa kám desǝ nwun kas, ɓe taji wu lap wur wu le ntulu fuu mo, koo wu kaat gwar mǝnǝ kas. ");
INSERT INTO sur_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Mbǝɗe jir ngwe ɗe wur lap nen mǝnǝ mo, ɓe wur ɓalkáa ashak kǝ nen mǝnǝ ndǝǝn ɗak ɗebish mo. ");
INSERT INTO sur_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Koo ɗe wen kǝ mbii mo ɗes mbǝ ran mo nwun, ɓe baa wen nran mo nwun shi haal mǝ ɓǝǝt haal kǝ ing kas, ɗang wen kǝn lepan nee, wen njì kǝn naa wun ɗe, kǝ mu katpwoo ɗe ashak zak, mbǝkǝ retnyit fun nǝ gam ɗe. ");
INSERT INTO sur_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Jep ɗyemnǝǝn fii ɗebǝbǝlip pǝ Naan, moo tok kǝ yi.");
INSERT INTO sur_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Lepran desǝ nǝ put a nsar fen ngunan, dǝm pee waa Gayus ɗe, ɗe wen wal nwaa nɗǝǝn zeen. ");
INSERT INTO sur_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Shaar fen, wen kǝ ɗangnaan mbǝ nwaa, mbǝkǝ a kat ɗeret ɗe nɗǝǝn mbii mo jir, kǝzak, mbǝkǝ a tong ɗe nkoom, kaaɗe seen fwaa nǝ kat ɗeret sǝ. ");
INSERT INTO sur_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Nǝ ret nwen nyit zam, kaaɗe pak ɗyemnǝǝn fun mo jì satpwoo ɗeret nwen nkaa waa nǝnee, aa ɗar ɓalɓal nɗǝǝn shinzeen nǝ, kǝ kaaɗe aa mwaan nɗǝǝn shinzeen nǝ sǝ zak. ");
INSERT INTO sur_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Baa mee retnyit ɗe wen ɗǝ nǝ waa met nɗesǝ kas, kǝ wen kǝlǝng nnǝ, jep fen moo mwaan a nɗǝǝn shinzeen nǝ. ");
INSERT INTO sur_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Shaar fen, aa ɗar ɓalɓal nɗǝǝn zeen ɗe aa cìn nǝ mbǝ dyemnǝǝn fun nendǝm nɗang Jesu mo, jir kǝ ɗǝ mo mǝzep mo. ");
INSERT INTO sur_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Mo kǝ satpwoo Eklisiya mo nkaa wal fwa nǝ. Kuzuk a ɓam mo nɗǝǝn mwaan mo, nkaa ar ɗǝ nǝ shin ɗǝɗes Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Mbǝɗe mo yool yaa mwaan nǝ a mbǝ sǝm kǝ Daa. Baa mo nwaa lap mee ɓam pee neen kùm mo kas. ");
INSERT INTO sur_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Mbǝmǝnǝ, nǝ ret kǝ mun mu lap nen mǝnǝ mo nɗǝǝn lu fun mo, mbǝkǝ mu ɗee ɗe a shaar ɗak ɗi ashak nɗǝǝn zeen. ");
INSERT INTO sur_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","wen kǝn ran mee mbii Eklisiya nǝ, ɗang Diyoturifis ɗe wur fes leshin a ɗi nshee, wur bǝ kaat mun kas. ");
INSERT INTO sur_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Katɗang wen jì, ɓǝ wen ndul ɗiyen fuu shinji kaa bii ɗe wur nkaa cin ne, Pwoo ɗebuu ɗe wur naa nsat nǝ nkaa mun. Baa mǝnǝ mak wur kas, ɗang wur cii kaat pak nen dǝmdang Jesu, wur cíi nnen ɗe moo pǝ rǝɓet kaat mo kǝ wur put ke mo nɗǝǝn Eklisiya ne ");
INSERT INTO sur_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Sharfen, taji a kam cin bii ɗǝ bish mo kas, Ɗangɓe a kam a ɗeret mo. Koo a weyii ɗe wur cìn mbii ɗeret, ɓǝ gwar mǝnǝ a mǝ Naan. Jir ngwe ɗe wur cìn mbii ɗebish, baa gwar mǝnǝ kǝ naa Naan kas koo lee. ");
INSERT INTO sur_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Gurum mo jir mo satpwoo ɗeret nkaa Dimitiriyus, har zeen nǝ shikáa fir. Mun zak muu sat dǝret nkaa wur. waa man nǝnee, mbii camkat fun nǝ azeen. ");
INSERT INTO sur_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Wen kǝ mbii mo ɗes mbǝ ran mo ngha, ɗang baa an nran mo ngha a shi haal kǝ ing kas. ");
INSERT INTO sur_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","Wen kǝ lepan nǝ, an naa ngha, ɗangɓǝ mun leshap kǝ shak yit kǝ yit. ");
INSERT INTO sur_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Tongriyang ashak kǝ wun. Shaar ɗǝ pee ɗǝsǝ mo lep kǝ tokshik. Tokshik kǝ shaar ɗǝ peemenǝ mo shi sǝm.");
INSERT INTO sur_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Juud kǝrem Jesu Kristi, dyemnǝǝn nJemis, Pǝ ran lepran ɗǝsǝ shidǝm dǝm pee nen ɗǝ Naan pǝrep mo, ɗe Naan puun wur wal mmo, kǝ mo ɗee a ɗe fufwang nɗǝǝn Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Naajeel, kǝ ryang, kǝ wal wur, mo naa nwurang nɗǝǝn wun ɗak. ");
INSERT INTO sur_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Sharfen ɗǝ hakyeng mo, gyet ɗyeen fen mbǝ kǝ wen ran ɗǝ wun nkaa ɓam ɗe mun kǝ nǝ ashak. Dang mee bii le an ting kǝ nghan ran nwun, mbǝkǝ wen caa wun, kǝ wun sekyeen ɗi nɗǝǝn lek, mbǝ shinzeen ɗe Naan wur kǝ ten shin nen wur ɗe ɓang mo. ");
INSERT INTO sur_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Mbǝɗe pak gurum mo ɗi, ɗe mo kǝ ɗen a ɗǝ dyeel kǝ se mo pǝgyet kǝ jì ɗel nɗǝǝn wun a sǝsok. Nen ɗe mo ciir kǝ pwoo Naan kǝ ɗǝret wur, mbǝkǝ mo katpee cìn mbii ɗebish mǝ nan mo ɗi. Kǝzak, mo cii Daa Jesu Kristi. ");
INSERT INTO sur_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Ko ɗe wuu ten wu man mbii desǝ mo jir, an pǝ rǝɓet ye wun, kaaɗe gyet Naan wur put kǝ nen Izrel mo nyil Ijip. Dang nbwoon mǝnǝ, ɓe gyet Naan wur tǝkook nen ɗe mo cii shinzeen. ");
INSERT INTO sur_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Kǝzak, nenlepnaan ɗe mo yaa peetong mulki mo retret kas ɗang mo yit peetong fur mo, ɓe mo ɓwoot mo shi tǝsek ɗǝ ngha-ngha nɗǝǝn peeɗe nǝ nkwoo, Naan wur le mo a npeemǝnǝ, har parpuus ɗyeel nǝn njì wul. ");
INSERT INTO sur_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Nǝ akǝsǝ zak, Sodom kǝ Gomora, kǝ yil ɗe mo kus kǝ mo. Gyet yil desǝ mo shin káa fur mo, mbǝ cìn ngaa kǝ mbii ɗebish mo. Mo ɗee a nbiikam nen lap kwat nshikbish ɗe mo nɗǝǝn wus ɗe nǝ dǝm ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Nǝ a nɗǝǝn ar desǝ, ɓe nen desǝ mo naa suun mo, ɗe nǝ le mo waa ciir cìn shikbish nkaa sut fur mo. Mo cii ɗeɗes Naan, kǝ mo satpwoo ɗebish nkaa nenɗǝret mo ɗe mo, nɗǝǝn ɗengnaan. ");
INSERT INTO sur_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Mbii ɗe koo a Makiyel ɗe wur a ngwe ɗeɗes mǝ nenlep mo, baa wur mak sat nǝ kas. Kaaɗe gyet Makiyel kǝ gujwan mo jiir nkaa kúm Mosis, ɓe baa Makiyel mak wang pwoo, mbǝkǝ wur fǝlǝp gujwan ɗe kas, ɗang wur sat nǝnee, << Daa ngwak ngha!>> ");
INSERT INTO sur_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Ɗangɓe nen desǝ mo can mbii mo jir ɗe baa mo manshii nǝ kas, kǝ mbii ɗǝ mo manshi nǝ shi pan mǝ nan, mo a kaa long mo sǝ. A mbii mǝnǝ moo waa ciir tǝkook kǝ mo. ");
INSERT INTO sur_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Jeel mbǝ mo, Mbǝɗe moo mwaan a nɗǝǝn ar Keen, kǝ tang lǝɓet mo nɗǝǝn ar ɗe gyet Balaam Ɗelɗekǝ, Mo kǝ tǝkook kǝ mo nɗeen tǝkook kǝ pee Kora. ");
INSERT INTO sur_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Nen ɗesǝ mo a mbii naashwep ɗǝǝn kuur fu ɗe mǝ walshak fu, kaaɗe mo pǝ se mbiise kǝ wun nnen kǝǝrmuut. Mo a kaa nen naa long ɗe moo tap a kaasut ɓǝjee dak. Mo a nluu ɗe nǝ kǝ fwan kas ɗǝ kut kǝ mang ɗel seet kǝ nǝ sǝ. Mo a tǝng ɗe nǝ cii làa-làa harwaap jì mang sǝ. Tǝng ɗe mo kǝ ɓwan seen nǝ, kǝ nǝ ɗee a ɗǝ mumuut sǝ. ");
INSERT INTO sur_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Mo a am ɗe kut kǝ chut nǝ ɓalɓal nɗǝǝn bahar. Mo woo tǝfil mǝ mbii naashweep ɗe moo cìn mo zak. Mo a zar ɗe moo mwaan. Naan wur tap ɗak mee pee ntun-ntun, ɗerap shekshek, le mbǝ mo ngha-ngha ");
INSERT INTO sur_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Enok, wur a ɗang ɗepwoovǝl nɗǝǝn cirem Adam, wur satpwoo nkaa mo nǝnee, <<Wu naa, Daa wur kǝ jì kǝ nenlep wur ɗeɓang mo ngal nkaa ngal mo, ");
INSERT INTO sur_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","mɓǝkǝ mo tokdyeel ɗi ko weyii, kǝ mo canɗyeel ɗi mo jir mbǝ ɗak ɗebish ɗe mo kǝ cin, Kǝ jir pwoo ɗǝbuu ɗe nenshikbish desǝ nǝ mo kǝ ten sat nkaa Naan.>> ");
INSERT INTO sur_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Nen desǝ mo naa nkatpwoo nɗom ndom, nenyapɗebish nɗǝǝn nnyee mo, nen ɗǝ mo tong a mǝ cin ɓutɗeet, mo kǝ canpwoo nkaa sut, ɗang mo caa gurum mo ar ɗebish mbǝ kat lǝbet fur. ");
INSERT INTO sur_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Wun sharfen mo, wen wal nwun sǝ, taji wu munshik mbii ɗe gyet jeplep Daa fun Jesu Kristi mo sat nwun. ");
INSERT INTO sur_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Mo sat nwun nee, <<Ndǝǝn teer mǝ peekyes nǝ mo, ɓe nenɓákpee, mo njì put, Nen ɗe moo mwaan a nɗǝǝn coor mǝ nan fur mo.>> ");
INSERT INTO sur_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","A nen ɗesǝ mo, a nen ɗǝ mo kǝ ji kǝ ɓakshak nɗǝǝn wun, A mo a nen ɗe mo coor mbii ɗebish mǝ yil desǝ shi mǝse fuu mo, baa mo kǝ Riin nNaan kas. ");
INSERT INTO sur_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Dang wun, sharfen mo ɗe wen wal nwun, wu ɗyiksuk nɗǝǝn shinzeen fuu ɗeɓang, ɗang Wuu leshap kǝ Naan ɗǝǝn Riin Ɗeɓang zak. ");
INSERT INTO sur_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","Wu lesuk fuu mo nɗǝǝn wal Naan, kaaɗe wu leyit nkaa naajeel nDaa Jesu Kristi mbǝkǝ wur ji kǝ wun ɗi nɗǝǝn seen ɗǝ ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Wu naajeel nen ɗe mo ɗee nket-nket kǝ wun, ");
INSERT INTO sur_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Wu ɓam pak mo bǝkǝ wu put kǝ mo ɗi mɓut nwus, kǝ mbǝ pak mo, ɓǝ wu naajeel, reep kǝ kǝǝrmuut. Dang wu cii lée mo, Mbǝɗe lée nǝ kǝ ten ɗee a ɗerap shi shikbish fuu mo. ");
INSERT INTO sur_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","Pǝ wur ɗe wur mak fwang wun, mbǝkǝ taji wu táa wu pal kas, kǝ wur njì kǝ wun ntoom ɗeɗes Naan nɗǝǝn retnyit, baa kǝ mee rap kas. ");
INSERT INTO sur_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","Mu shin ram nNaan ɗewur mbǝshin a Nguɓam fun, kǝ ram, kǝ Ɗehai, kǝ mulki, kǝ ɗeɗes kǝ ɓal, ndǝǝn Jesu Kristi Daa fun, pǝgyet ɗe yam-yam, ji wul yaksǝ, kǝ har ngaa-ngaa! Nǝ a kǝsǝ.");
INSERT INTO sur_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","Suun mǝ Jesu kristi ɗǝ Naan Cin wur Kǝ wur woo ɗǝ kǝrem fǝr mo mbii ɗǝ mo kus kǝ ji. Jesu Kristi wur lep ngulep wur dǝm pee kǝrem wur Joon ɗǝ, mbǝkǝ wur woo mbǝ ɗesǝ mo ɗe nwur. ");
INSERT INTO sur_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Joon wur kǝ ten sat agaak mbii ɗe wur kǝ naa mo jir, kǝ wur ten ran pwoo kǝ Naan ɗe Jesu Kristi woo mo nwur nnee, nǝ a zeen. ");
INSERT INTO sur_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Koo a weye, ɗe wur tang bǝǝthaal ɗesǝ nǝ, ɓe wur nkat ɗǝret, kǝ nen ɗe mo lekom mbǝ kǝlǝng pwoo ɗesǝ nǝ ɗe Naan kǝ woo nǝ, kǝ moo cin mbǝɗe nǝ sat, ɓe mo nkat ɗeret, mbǝɗe pee nǝ kǝ wul kus, mbǝkǝ mbǝ ɗesǝ nǝ mo ngam ɗǝ. ");
INSERT INTO sur_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","Wen Joon kǝn tok kǝ Ekǝlisya ɗe pwoovǝl sǝ mo, ɗe mo ndǝǝn yil Eshiya. Naan wur naa wun shi yit naajeel wur, kǝ wur cin tongryang nwun zak. Naan ɗe wur ɗe yaksǝ, ɗe pǝgyet wur ɗe yam, kǝ ɗe wur nɗang jì, kǝ Riin ɗe pwoovǝl nǝ mo, ɗe mo ɗar ntom kǝ Naan a peetong wur ɗǝɗes. ");
INSERT INTO sur_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","Kǝ Jesu Kristi, ɗe wur a langteng ɗe a zeen, wur a ɗinshee, ɗe mo shee yool kǝ wur a peemúut, kǝ zak, a wur a Mishkoom nkaa mishkoom ɗe mo ndǝǝn yil ɗesǝ jir. Wur wal mmun a mbǝ muut ɗe wur ɓeer toom fin, ɓe wur fween mun mɓut shikbish fun mo. ");
INSERT INTO sur_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","Wur le mǝ ɗee a mishkoom mǝ pris mo, mbǝkǝ mǝ seyil ɗe nNaan puun wur. Ram, kǝ iiko, mo ɗee a mǝ Jesu Kristi mbǝ ngaa-ngaa. Nǝ aasǝ! ");
INSERT INTO sur_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Wu naa, wur pǝ jì nkaa nluu. Gurum mo nnaa wur jir, mbe kǝ nen ɗe gyet mo shulang wur. Gurum ɗe mo ndǝǝn yil ɗesǝ jir, mo nwal maap mbǝ wur. Nǝ ndǝǝn aasǝ! Nǝ aasǝ. ");
INSERT INTO sur_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Daa Naan ɗeɗes wur sat nǝnee <<a wen ɗe shee kǝ mbǝ mo, kǝ kyes kǝ mbǝ mo jir zak. Naan ɗe wur ɗe yaksǝ, wur ɗe yam, kǝ a wur pǝ jì zak.>> ");
INSERT INTO sur_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","A an, Joon ɗyemnǝǝn fuu ngudǝm nɗang Jesu, an a memee ndǝǝn wun nen ɗe wuu gung kǝ shwaajeel, mbǝɗe wun a dǝr Mishkoom Kristi. An mee laayil, ɗe am neer nǝ cǝǝrkaat, ɗe moo pet nǝ a Patmos, mbǝɗe gyet an kǝn satpwoo Naan nǝ gurum mo, ɗe Jesu wur shin langteng ne. ");
INSERT INTO sur_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Parpuus kǝ Daa, ɓe Riin Naan wur jì ɗel ndǝǝn an. Ɗangɓe wen kǝlǝng mee ɗoo ɗeɗes, kaa wal kǝ feer sǝ. Pǝ leshap mbwoon fen. ");
INSERT INTO sur_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Ɗoo ne sat an nǝnee, << A ran mbǝɗe waa nkaa naa nǝ, kǝ a lep kǝ ɓǝǝthaal nǝ dǝ Ekǝlisya ɗepwoovǝl sǝ mo, ɗe mo nyilkaam, Afisus kǝ Simena, kǝ Pagamum, kǝ Tayatǝra, kǝ Sardis, kǝ Filadalfiya, kǝ Lodisiya.>> ");
INSERT INTO sur_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Wen cǝǝr mbǝkǝ an naa ngwe ɗe wur katpwoo nǝ ɗǝ. Kaaɗe an cǝǝr, ɓe an naa, peele ngyem mo pwoovǝl, ɗe mo ɗak mo a shi zinariya. ");
INSERT INTO sur_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Nnaar kǝ peele ngyem ɗe pwoovǝl ɗesǝ nǝ mo, ɓe an naa mee gwar wur ɗar ɗǝ, ɗe wur lapshak kǝ Làa Gurum. Wur lep mee nlǝr ɗe nǝ sham wul wur nkwakshii, kǝ wur ɓwoot mee teng sǝ cǝǝr nkaa tuur wur, ɗe mo ɗak mǝnǝ a shi zinariya. ");
INSERT INTO sur_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Shwepkáa wur nǝ mo piyaa kaa shuu sǝ, kǝ nǝ kaa ɗoor sǝ. Yit wur nǝ mo lapwus kaa liis kǝ wus sǝ. ");
INSERT INTO sur_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Shi wur mo mǝlep, kaa shool ɗemǝlep, ɗe mo tap ɗak shi wus mbǝkǝ nǝ ɗee a ɗeret sǝ. Ɗoo wur nǝ a kaa wal kǝ am ɗe moo sham mpǝtuul sǝ. ");
INSERT INTO sur_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Wur kǝ zar mo pwoovǝl nsarse wur, kǝ mee kwai ɗi se put pwoo wur ɗe nǝ se koop weet. Yit wur nǝ fes ɓangpee hakyeng kaa puus a naar sǝ. ");
INSERT INTO sur_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","Kaaɗe an naa wur, ɓe an taa nyil nder shii wur kaa an kǝn mumuut sǝ. Ɓe wur le sarse wur nkaa an, ɗangɓe wur sat nǝnee, <<Taji kǝǝrmuut yaa waa kas. A an a ɗinshee, kǝ a an a kyes ne. ");
INSERT INTO sur_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","A an a ɗe mmeen. Gyet an kǝn muut, mɓe yaksǝ, ɓe an kǝ seen. Wen ntong ɗe kǝ seen mbe ngaa-ngaa. Wen kǝ mbii wang peemúut, kǝ peedǝm kǝ nen mumuut mo, a sar fǝn. ");
INSERT INTO sur_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","<<A ran mbǝɗe aa ten a naa mo yaksǝ, kǝ mbǝɗe waa nkaa naa mo, kǝ mbǝɗe mo mbǝ jì. ");
INSERT INTO sur_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","A ɗesǝ nǝ a shii kǝ zar ɗesǝsok ɗe pwoovǝl ɗe mo nsarse fen, kǝ peeɗar mǝ ngyem ɗe pwoovǝl ɗe mo ɗak a shi zinariya. Zar ɗe pwoovǝl nǝ mo, a mo a nenlep kǝ Ekǝlisya ɗe pwoovǝl nǝ mo, kǝ peeɗar kǝ ngyem ɗe pwoovǝl sǝ mo, mo a Ekǝlisya ɗe pwoovǝl nǝ mo zak.>> ");
INSERT INTO sur_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","<<A ran shi dǝm lep-Naan ɗe Ekǝlisya ɗi Sarduis wur ɗen Ekǝlisya ɗe nǝn nyil Afisus nǝnee, << Lep ɗesǝ nǝ, a pwoo ɗe nǝ put mpwoo kǝ gwar ɗe wur kǝ zar mo pwoovǝl nsarse wur sǝ, ɗe wur mwaan nnaar kǝ peele ngyem ɗe pwoovǝl sǝ mo, ɗe mo ɗak mo a shi zinariya sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Wen man ɗak ɗe wun kǝ ten cin nǝ, kǝ jeel fuu, kǝ gung fuu zak. Baa wuu shaar kǝ nenɗebish mo kas. Wuu cam shiimwaan kǝ nen ɗe mo sat nǝnee, << wuɗun a jeplep Jesu mo, mɓe baa mo a jeplep Kristi kas. Wuu ten wu man ne, moo cin a ɗung. ");
INSERT INTO sur_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","Wu gung, koo ɗe wun nkaa shwaajeel mbǝ sǝm fen, ɓe taji wu baa mɓwoon kas. ");
INSERT INTO sur_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","Amma an ɗe kǝ mee mbii mǝndong nkaa wun ɗe an kǝn rǝɓet sat nǝ nwun. Baa wu kuɗi wuu wal nghan kaa ɗe gyet wuu wal an nshee sǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Taji wu mander nshiimwaan fuu ɗe gyet yam, akuɗang wuu táa wu pal sǝ kas. Wu tuwap, mbǝkǝ wu baa wu mwaan ɗe ndǝǝn ar nǝ, kaa gyet yam sǝ. Katɗang baa wu tuwap kas, ɓe an mbǝ jì, kǝ an mang peele ngyem nǝ ɗe a peeɗar ni. ");
INSERT INTO sur_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","Ɗangbe mbǝ mbii mǝndong ɗe an kǝ kwoop wun mbǝ nǝ a nɗǝsi, baa ɗyeen wun mbǝ ɗak nen Nikolaitan mo kas, kaaɗǝ baa nǝ a ɗyeen fen kas sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Ngwe ɗe wur kǝ kom, mbǝ kǝlǝngpee ɓe wur kǝlǝng mbǝɗe Riin nǝ nkaa sat nǝ nendǝm ɗangnaan mo, <<Ngwe ɗe wur se koorong, ɓe an ncin pee nwur se laatǝng ɗe nǝ a mǝ seen, ɗe nǝ kàa ndǝǝn bong kǝ Naan.>> ");
INSERT INTO sur_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","<<A ran lep dǝm pee ngulep Naan ɗe wur ɗǝǝn Ekǝlisya ɗe nǝn nyil nSimena nǝnee, <<Lep ɗesǝ nǝ a pwoo ɗe nǝ put mpwoo kǝ gwar ɗe wur a ɗinshee, kǝ a wur a kyes kǝ mbǝ mo jir, ɗe gyet wur kǝ muut, mɓe yaksǝ wur kǝ seen. ");
INSERT INTO sur_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","Wen man shwa jeel fuu mo kǝ jeel fuu, kǝ zak, nghan man nǝnee, << Jir kǝ sǝ wun a nenlong mo. Wen man pwoo ɗebish mǝ nen ɗe moo lesut a nen Yahudi mo, ɓe baa mo a nen Yahudi mo kas. Mo a nen kǝ ngujwaan mo. ");
INSERT INTO sur_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","Taji wu kat mee kǝǝrmuut nkaa jeel ɗe wun mbǝ shwaa nǝ kas. A kǝleng, nGujwaan wur cam wun. Wur nle pak fuu mo ndǝǝn lushoot, wun nshwaajeel mbǝ teer mo kaapaat. Mbe wu gung, taji wu cii an kas, koo ɗe mo ntǝtwe wun, ɓe wu gung, mbǝkǝ an cin biikaa koorong mǝ seen ɗeɗes nwun. ");
INSERT INTO sur_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Ngwe ɗe wur kǝ kom, ɓe wur kǝlǝng mbǝɗe Riin wur nkaa sat nǝ (Ekǝlisya) nendǝm ndang Naan mo. Ngwe ɗe wur se koorong, ɓe baa muut ɗe vǝl nǝn ntung wur kas.>> ");
INSERT INTO sur_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","<<A ran lep dǝm pee ngulep Naan ɗe wur Ekǝlisya ɗe nen nyil Pagamum nǝ, Lep ɗesǝ nǝ put a mpwoo kǝ gwar ɗe wur kǝ kwai ɗe nǝ se koop vǝl sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","Wen man, npee ɗe wuu tong ɗe nǝ, ɓe ngujwaan wur kǝ le mpeetong fǝn a pee mǝ nǝ. jir kǝsǝ ɓe wuu yaa sǝm fǝn ɓalɓal. Baa wu nyan shin zeenpwoo fǝn kas, kaaɗǝ gyet ɗǝǝn teer mǝ Antipas mo ngucìn langteng fǝn mɓǝ mo tu wur nɗǝǝn yilkaam fu peeɗe shetaan kǝ tong. ");
INSERT INTO sur_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","Mbe an kǝ rep pak mbǝ mo lee nkaa wun. Wun kǝ pak gurum mo nnaar fuu, ɗe moo dǝm a nɗang kám mǝ Balaam. Gyet a Balaam wur kám mBalak, kǝ wur gangkwak nen Izrel mo, mbe gyet mo shin shikbish mbǝ se mbiise ɗe gyet mo kǝ ten cin nkùm, kǝ cin mbǝ ɗebish mo kaa ngaa sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Kǝzak, wun kǝ nen ɗe moo dǝm nɗang kám nǝn Nikolaus mo. ");
INSERT INTO sur_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","Wu tuwap, kas ɓe an kus kǝ jì, kun cin lek ɗe kǝ wun, shi kwai fǝn ɗe nǝ jì put mpwoo fǝn sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Ngwe ɗe wur kǝ kom, mbǝ kǝlǝngpee, ɓe wur kǝlǝng mbǝɗe Riin Naan wur nkaa sat nǝ Ekǝlisya nendǝm ndang Naan mo.>> Ngwe ɗe wur se koorong, ɓe nghan ncin pak man ɗe nǝ a sǝsok nwur. Kǝ zak, an ncin jwak ɗepiyaa ngwar nǝ, kǝ sǝm ɗepwoo a rǝran ɗi kǝ nkaa jwak nǝ. Gwar ɗe wur nlap jwak nǝ, ɓe a wur man mbǝɗe mo ran nkaa nǝ ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","<<A ran lep dǝm pee ngulep Naan ɗe wur tap kǝ Ekǝlisya ɗe nǝn nyil nTayatǝra nǝ, Lep ɗesǝ nǝ put a mpwoo kǝ Làa kǝ Naan ɗe yit wur moo lapwus kaa mbǝlem kǝ wus sǝ, ɗe shii wur moo mǝlep kaa shool ɗe mo tap ɗak nǝ sǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","Wen man ɗak fuu mo, kǝ wal fuu, kǝ cinzeen fuu, kǝ ɗak ɓam ɗe wu cin mo, kǝ gung fuu, kǝ zak, yaksǝ ɓe wun nkaa cin ɗak nǝ met ɗe gyet wu cin mo nshee. ");
INSERT INTO sur_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","Mbǝ jir kǝsǝ, ɓe an kǝ mbǝ ɗesǝ mo nkaa ɗel ɗekǝ ɗǝsǝ moo nkaa wun. Mɓeɗe wu tap wu kiyee mat ɗe moo pet war a Jezebel sǝ, ɗe war pet set a mat satpwoo kǝ Naan. A shi ar kám war, ɓe war le kǝ kǝrem fǝn mo cin mbǝ ɗebish mo kaa cin ngaa, kǝ se mbiise ɗe mo kǝ ten cin nkùm. ");
INSERT INTO sur_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","Wen kǝn shin pee nwar, mbǝkǝ war tuwap ɗǝ, ɓe war cii tuwap mbǝ shikbish war, ɗe nǝ a mǝ ngaa. ");
INSERT INTO sur_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","Wen nle kǝ shwal yaa war ɗǝ, kǝ nen ɗe moo cin ngaa ashak kǝ war, katɗang baa mo tuwap kas, kǝ mo nook cin mbii ɗebish mǝnǝ mo kas, ɓe nghan shin jeel mo. ");
INSERT INTO sur_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Wen nle kǝ jep war mo murep kǝ shwal, mbǝkǝ Ekǝlisya mo jir mo man ɗi nǝnee, << an a ngwe ɗe an kǝn man pan ɗe nǝ nɗǝǝn pǝtuup gurum mo, kǝ zak, an kǝn leng pǝtuup mo mo. Wen nkwat koo a weye nciit kǝ ɗak ɗe ngwe nǝ kǝ ten cin. ");
INSERT INTO sur_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","Yaksǝ kǝn nsat wun koor nen Tayatǝra, ɗe baa wu lap kám nǝ kas, baa wu man mbii ɗebish, ɗe gurum moo pet nǝ a ɗe sǝsok ndǝr mǝ Shetan kas, baa an le teng kaa wun kǝ mee leeton kas. ");
INSERT INTO sur_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","Wu ɗar ɓalɓal nɗǝǝn mbiiɗe wuu ten wu kám, ɗang mbaa njì. ");
INSERT INTO sur_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","mbe gwar ɗe wur se koorong, ɗang wur cin ɗyen fǝn, dǝm sul, an shin ɓal nkaa yil nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","Mo ncìn mulki nkaa yil nǝ mo, a shi kám shool, ɗang mo mpyan mo, a kaa tuulwan ɗe gurum kǝ piin nǝ sǝ, kaaɗe wen kǝn kat ɓal nsar puun fen sǝ ");
INSERT INTO sur_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","ɓe an nshin zar mangɓit ngwar mǝnǝ. ");
INSERT INTO sur_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Ngwe ɗe wur kǝ kom, mbǝ kǝlǝngpee, ɓe wur kǝlǝng mbǝɗe Riin Naan nǝ sat luu Naan nǝ mo>> ");
INSERT INTO sur_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","<<A ran lep dǝm shi dǝm ngulep Naan ɗe Ekǝlisya ɗe nǝ nyil nSardis nǝnee, << A lep nǝ nɗesǝ, ɗe nǝ put a mpwoo kǝ gwar ɗe wur kǝ Riin Naan mo pwoovǝl, kǝ zar mo pwoovǝl zak. Wen man ɗak fwa, waa le kǝ gurum mo pan nnee, waa ɗe kǝ seen, mɓe waa a ɗemumuut. ");
INSERT INTO sur_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","A yool atǝng, mbǝkǝ a fwang rep koor seen ɗe nǝ ɗee nǝ ɗe, mbǝkǝ taji nǝ sǝǝt muut kǝnding-nding. Wen naa, baa shiimwaan fwa nǝ a ɗeret nyit kǝ Naan kas. ");
INSERT INTO sur_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Mɓemǝnǝ, ɓe nghan kǝn sat nwaa, a pan mbǝɗe gyet aa ten a kǝlǝng mo, ɗe gyet mbe aa lap mo. A cinzeen mǝnǝ mo ɓalɓal. A yool, Katɗang baa waa yool kas, ɓe an mbaajì a kaa wat sǝ, ɗe baa waa mman parpuus baaji fǝn nǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","Mbe rep pak gurum mo ɗe, nyil nSardis, ɗe mo tap le lée mo mo a ɗeɓang. Nen mǝnǝ moo mwaan ashak kǝ nghan. Mo nlep lée ɗepiyaa-piyaa mo, mbǝɗe shiimwaan fur nǝ mo ret. ");
INSERT INTO sur_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Nen ɗe mo se koorong, ɓe mo nlep lée ɗepiyaa-piyaa mo zak. Baa an ncam tu sǝm mo nɗǝǝn bǝǝthaal mǝ nenseen mo kas. Kǝ lep wur mo, ɓe an nsat agaak ne, mo a nen fen mo akyeen Naan, kǝ kǝkyeen Jeplep wur mo. ");
INSERT INTO sur_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Ngwe ɗe wur kǝ kom mbǝ kǝlǝngpee, ɓe wur kǝlǝng mbii ɗe Riin Naan wur nkaa sat nǝ nen lu Naan mo.>> ");
INSERT INTO sur_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","<<A ran lep dǝm pee ngulep Naan ɗe wur kǝ tap Ekǝlisya ɗe nǝn nyil nFiladalfiya. <<Lep ɗesǝ nǝ put a mpwoo kǝ gwar ɗe wur a ɗeɓang kǝ wur azeen. A wur kǝ makuli kǝ Devid. Katɗang wur wang pwoolu nǝ, ɓe baa mee gurum mak shoot nǝ kas, kǝ zak, katɗang wur shoot pee nǝ, ɓe baa mee gurum mmak wang nǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Wen man ɗak fwa. A naa, an kǝn ten wangpee nwaa, ɗe baa mee ngwe mmak shoot nǝ kas. Wen man nǝnee, << koo ɗe baa ɓal fwa nǝ ɗes kas, ɓe waa aa ɗar ɓalɓal nɗǝǝn pwoo fen, kǝ zak, baa waa ciipwoo nǝnee a nook man an kas. ");
INSERT INTO sur_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","A kǝleng, an nle nen mǝ ngujwaan ɗe moo le sut a nen Yahudi sǝ mo, mɓe baa mo a nen Yahudi mo kas, moo cin a ɗung. Wen nle kǝ nenɗung ɗesǝ mo jì kurum ntoom fwa, kǝ nder shii fwa, kǝ mo man ɗe zak nǝnee, << an wal nwaa. ");
INSERT INTO sur_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","Kaaɗe aa ten a keer war fen sǝ mo, kǝ gung zak, mpeemǝnǝ ɓe nghan ntap kǝ waa, mbǝkǝ taji mee mbii tung waa kas, nɗǝǝn teer mǝ jeel ɗe nǝn nɗang jì nkaa yil nǝ, mbǝkǝ nǝ cam gurum mo ɗe jir nɗǝǝn ɓǝm-yil ne. ");
INSERT INTO sur_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Wen nɗang jì kǝlak-kǝlak. A yaa mbǝɗe waa kǝ nǝ ɓalɓal, mbǝkǝ taji, mee gurum mang zuum mǝ koorong nǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Jir gwar ɗe wur se koorong, ɓe an nle kǝ war ɗen a kaa ndwet mǝ Lu Naan ɗeɗes Naan fen. Ɗe baa nǝ ncam put ɗe nɗǝǝn Lu Naan nǝ kas. Wen nran sǝm Naan fǝn nkaa mo, kǝ sǝm mǝ yil Naan fen, Jerusalem ɗepwoo, ɗe nǝ tong a ɗeng sham pǝ Naan fen ɗǝ, kǝzak, an nran sǝm fǝn ɗepwoo nkaa mo. ");
INSERT INTO sur_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Ngwe ɗe wur kǝ kom mbǝ kǝlǝngpee, ɓe wur kǝlǝng mbǝɗe Riin Naan wur nkaa sat nen dǝm ndang Naan mo.>> ");
INSERT INTO sur_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","Gwar nǝ sat nghan nǝnee, <<A ran lep dǝm pee ngulep kǝ Naan ɗe wur tap kǝ Ekǝlisya ɗe nǝn nyil nLodisiya. <<Lep ɗesǝ nǝ put a mpwoo kǝ gwar ɗe moo pet wur a Amin. Shi kǝ mǝnǝ nǝnee, <nǝ aasǝ> Wur a ngwe ɗe azeen-nzeen, kǝ wur a langteng ɗe azeen. A wur a kuk kǝ mbǝɗe Naan wur le mo jir. ");
INSERT INTO sur_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Wen man ɗak fwa, baa waa a ɗezuum koo ɗetal kas. Ngyel ɗe waa a ɗezuum, koo ɗetal. ");
INSERT INTO sur_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","mbǝɗe waa anaar-anaar, baa waa a ɗetal kas, koo ɗezuum kas, mpeemǝnǝ, ɓe an mbe wut waa put aku mɓut mpwoo fǝn. ");
INSERT INTO sur_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Waa sat nǝnee, << waa kǝ long, kǝ waa kat mbii mo jir! Mɓǝ baa aa reɓet mee mbii kas. Ɗangɓe baa waa man nǝ nghaa kǝ mbii kas, nghaa bii yitmwaa, ngu jeel, vuum, kǝ ngum. ");
INSERT INTO sur_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","Wen pǝ shin kar wun kǝ wu seet zinariya ɗǝret ɗǝ mo ɗak shi wus pǝ nghan mbǝkǝ a ɗee ɗe a ngulong. A seet lée ɗepiyaa mo pǝ nghan ɗi, mbǝkǝ a paa gum bii naashweep fwa ɗi. A jì a seet yen mǝ yit zak, mbǝkǝ a le ɗe nyit fwa mo, mbǝkǝ a naapee ɗi. ");
INSERT INTO sur_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Nen ɗe wen kǝn wal mo, a mo a nen ɗe kǝn gwak mo inn le more kaa ar. Mɓemǝnǝ, ɓe wu ɗar azeen-nzeen, mbǝkǝ wu tuwap ɗi. ");
INSERT INTO sur_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","An sǝsǝ kǝn ɗar mpwoolu nǝ pǝ ɓwap pee. Katɗang mee ngwe kǝlǝng ɗoo fen, ɗang gwar nǝ wang pwoolu nǝ, ɓe nghan nɗel nɗǝǝn lu nǝ, mɓǝ nghan se mbiise ashak kǝ gwar mǝnǝ, kǝ gwar mǝne nse mbiise ashak kǝ nghan zak. ");
INSERT INTO sur_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Gwe ɗe wu se koorong, ɓe wen shin pee mo, mbǝkǝ mo tong ɗe ashak kǝ nghan nkaa mbetong mǝ mulki fen, kaaɗe gyet wen kǝn se koorong sǝ. Wen kǝn tong ashak kǝ puun fen nkaa mbǝtong mǝ mulki wur. ");
INSERT INTO sur_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Ngwe ɗe wur kǝ kom mbǝ kǝlǝngpee, ɓe wu kǝlǝng mbǝɗe Riin nǝ nkaa sat nǝ lunaan mo.>> ");
INSERT INTO sur_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Aɓwoon mǝnǝ, ɓe an ɗiyeep yit fǝn. Ɓe an naa mee polu ɗe nǝ a wuwang nɗǝǝn ɗengnaan, ɓe an kǝlǝng ɗoo ɗe nǝ wal nciit kǝ feer, ɗe ɗí nǝ katpwoo kǝ an nshee. Nǝ sat an nǝnee, <<A kàa mpesi. Wen nkám nwaa mbǝɗe ting mo ncìn aɓwoon mbii ɗesǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Aɓet-Aɓet, ɓe Riin Naan wur jì ɗel nɗǝǝn an, ɗangɓe nɗǝǝn ɗengnaan, ɓe an naa mee peetong mǝ mulki, ɗe mee gwar kǝ tong nkaa ne. ");
INSERT INTO sur_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Yit kǝ gwar ɗe wur tong nkaa nǝ, nii lapwus kaa jwak ɗeret ɗe moo pet mo a jaspa, kǝ kaneliyan, kǝ lilliu ɗe nǝ lapshak kǝ mee jwak ɗe moo pet nǝ a emiral, mo tap neer peetong mǝ mulki nǝ cǝǝrkaat. ");
INSERT INTO sur_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Mee peetong mǝ mulki mo laarvǝl baafeer, mo neer peetong mǝ mulki nǝ le nnaar. Nennan mo laarvǝl baafeer, moo tong nkaa peetong mǝ mulki ɗiisi nǝ mo. Nennan ɗesǝ nǝ mo, moo lep a lée ɗepiyaa-piyaa mo, kǝ zak, mo lep a mbekáa mǝ mulki, ɗe mo ɗak mo a shi zinariya. ");
INSERT INTO sur_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Mǝlep kǝ pee kǝ put ɗe nɗǝǝn peetong mǝ mulki nǝ, kǝ or ɗeɗes kǝ nluu pǝrep. Akiyeen kǝ peetong mǝ mulki ɗesǝ nǝ mo, ɓe ngyem mo pwoovǝl mo nkaa lapwus. A ɗesǝ nǝ mo a Riin Naan ɗe pwoovǝl sǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Kǝzak, akyeen kǝ peetong mǝ mulki nǝ, ɓe an naa mee mbǝ káa baahar sǝ, ɗe nǝ mǝlep kaa gǝlas sǝ, kǝ nǝ ɗong kyet-kyet. Mee mbǝɗe mo kǝ seen, mo feer, moo ɗar peefeer, cǝǝr mɓwoon kǝ peetong mǝ mulki ɗeɗes nǝ, mbǝ ɗefeer ɗe mo kǝ seen nǝ mo, mo gam kǝ yit nkoop mɓwoon kǝ nkoop ndǝǝn. ");
INSERT INTO sur_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Ɗin nshee nǝ, lapshak kǝ nvar, ɗevǝl nǝ lapshak kǝ kus randong, ɗekun nǝ, ɓe yit kǝ nǝ nciit kǝ mǝ gurum, ɗefeer nǝ lapshak kǝ puul ɗe nǝ nkaa yool ncáap sǝ. ");
INSERT INTO sur_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Koo a ɗeɗangyi ndǝǝn mbǝɗe mo kǝ seen feer ɗesǝ nǝ mo, ɓe nǝ kǝ cáap mo peemee, kǝ mo kǝ yit cǝǝr kat kǝ nɗer caap mo. Mpar kǝ puus, baa mo nok sat nǝnee, <<Ɗǝɓang, ɗeɓang, ɗeɓang, a wur a ɗe yam, kǝ a wur a ɗe yaksǝ, kǝ a wur a ɗǝ mǝ ji zak.>> ");
INSERT INTO sur_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Kaaɗe mbii ɗefeer ɗe mo kǝ seen ɗesǝ mo, mo kwoop, kǝ mo cin ɗeɗes mǝ pǝlang, pee gwar ɗe wur tong nkaa peetong mǝ mulki nǝ, a wur ɗe wur kǝ seen mbe ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","ɓe Nennan ɗe laarvǝl baafeer sǝ mo, mo zǝm ntoom kǝ gwar ɗe wur tong nkaa peetong mǝ mulki nǝ, mo seyil nwur. Wur ɗe wur mmeen mbe ngaa-ngaa. Nennan ɗesǝ nǝ mo shwat mbiikáa ɗe mǝ mulki mo mo ntoom wur, ɗang mo nkaa sat nǝnee, ");
INSERT INTO sur_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","<<Daa Naan fun a waa mak lap ram, kǝ kwoop, kǝ ɓal A waa ɗak mbǝ mo ɗe jir, A shi pan fwa ɓe waa ɗak mo ɗǝ, kǝzak, A waa cin nseen mo.>> ");
INSERT INTO sur_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Wen naa mee ɓǝǝt haal ɗe nǝ a ciciɓet nɗǝǝn sarse kǝ gwar ɗe wur tong nkaa peetong mǝ mulki nǝ. Mo ran-ran nkaa ɓǝǝt haal ɗesǝ nǝ, nkoop mɓwoon kǝ nkoop nɗǝǝn zak. Mo lus mo pwoovǝl shi stam. ");
INSERT INTO sur_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Ɗangɓe wen naa mee ngulep kǝ Naan ɗǝɗes, ɗe wur nkaa satpwoo ɓalɓal nǝnee, <<A wii mmak fǝlǝp káa kǝ <<stam ɗe pwoovǝl nǝ mo, <<mbe kǝ wur wang ɓǝǝthaal <<ɗeciciɓet nǝ ɗe ye?>> ");
INSERT INTO sur_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","Mbe baa mee gurum nɗǝǝn ɗengnaan, koo nɗǝǝn yil ɗese, koo nder kǝ yil nǝ, ɗe wur mak wang ɓǝǝt haal ɗesǝ nǝ, kǝ wur mak naa ɗǝǝn nǝ ɗe kas. ");
INSERT INTO sur_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","Ɓe wen wal hakyeng, mbǝɗe baa mo kat mee gurum ɗe wur mak wang ɓǝǝthaal nǝ, koo naa ɗǝǝn nǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","Ɗangɓe memee nɗǝǝn nennan nǝ mo, sat an nǝnee, <<Taji a wal kas, a naa mbwoor nɗang kǝ Juda, kǝ nɗang kǝ Devid wur kǝ se koorong. Wur mmak fǝlǝp nbii ɗe mo lwas nǝ, kǝ wur wang ɓǝǝt haal nǝ, kǝ mbii lwas ɗepwoovǝl nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Ɗangɓe an naa mee Laatǝm kǝ naapee kaa ɗe ge gap sǝ, kǝ ɗar nnaar kǝ peetong mǝ mulki nǝ mo, mo neer wur cǝǝr kat kǝ mbǝ ɗefeer ɗe mo kǝ seen sǝ mo, kǝ nennan ɗe sǝ mo. Laatǝm ɗesǝ nǝ kǝ soom mo pwoovǝl, kǝ yit mo pwoovǝl zak. Ɗese nǝ mo a Riin kǝ Naan ɗe pwoovǝl sǝ mo, ɗe Naan wur lep mo koo a pee ɗeɗangyi nɗǝǝn yil ɗese. ");
INSERT INTO sur_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Laatǝm ɗesǝ nǝ yool dǝm lap ɓǝǝt haal ɗeciciɓet ɗe nǝ nsarse kǝ gwar ɗe wur tong nkaa peetong mǝ mulki ne. ");
INSERT INTO sur_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","Kaaɗe wur lap ɓǝǝthaal ɗesǝ nǝ, ɓe mbǝɗe mo kǝ seen feer sǝ mo, kǝ nennan ɗe laarvǝl baafeer sǝ mo, mo kurum nyil, ntoom kǝ Laatǝm nǝ. Koo a weye nɗǝǝn nennan ɗe laarvǝl baafeer sǝ mo, ɓe mo kǝ nɗeng-nɗeng, mo kǝ yaa ɗaa shool, zinariya, ɗe nǝ gam kǝ mee mbiizuum ɗeshang. Mbiizuum ɗesǝ nǝ a ɗangnaan kǝ nen kǝ Naan mo. ");
INSERT INTO sur_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","Mo mang mee kook ɗepwoo nǝnee, <<A wa a mak mbǝ a mang ɓǝǝt haal nǝ, kǝ a wang lwas nǝ mo, mbǝɗe gyet mo kǝ tu waa, kǝ a shi toom fwa, ɓe a waa seet gurum mo ɗes, kǝ a jì kǝ mo nDaa Naan. Nen ɗe waa seet nǝ mo, mo put a ndǝǝn koo a soon ɗeɗangyii. Kǝ koo a ndǝǝn lespwoo ɗeɗangyii, kǝ koo a nɗǝǝn gurum ɗeɗang mo yii, kǝ koo a nɗǝǝn yil ɗeɗangyii zak. ");
INSERT INTO sur_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","Waa le mo ɗee a mishkoom, kǝ mo ɗee a pris mo cin ɗak nNaan fun, kǝzak, mo se mulki nkaa mo nɗǝǝn yil ne. ");
INSERT INTO sur_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Kaaɗe naapee, ɓe an kǝlǝng ɗoo kǝ nenlep Naan mo ɗes, ɗe mo ngal kaapaat nkaa ngal kaapaat, ɗe mo neer peetong mǝ mulki nǝ cǝǝrkaat, kǝ mbii ɗefeer ɗe mo kǝ seen sǝ mo, mo neer mbetong mǝ mulki nǝ kǝ Nennan sǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Mo cin kook shi ɗoo ɗeɗes nǝnee, <<Laatǝm ɗe gyet mo kǝ tu nǝ, a wur mak lap, iiko kǝ long, kǝ seen, kǝ ɓal, kǝ ɗeɗes kǝ ram, kǝ kwoop.>> ");
INSERT INTO sur_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Ɗangɓe an kǝlǝng mbǝɗe mo ɗak mo jir, ɗe mo nɗǝǝn ɗengnaan, kǝ ɗe mo nɗǝǝn yil, kǝ ɗe mo nder kǝ yil, kǝ ɗe mo nkaa am, kǝ mbǝɗe mo nɗǝǝn mo jir, mo cin kook nǝnee, <<Mbee wur ɗe wuu tong nkaa peetong mǝ mulki, kǝ Laatǝm, wu yit kǝ mǝ kwoop wur, kǝ shin ɗeɗes nwur, kǝ ram, kǝ iiko kǝ ɓal ngaa-ngaa.>> ");
INSERT INTO sur_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Ɗangɓe mbǝɗe mo kǝ seen feer sǝ mo sat nǝnee, <<nǝ akǝ sǝ.> ɗang Nennan sǝ mo nkurum furum, kǝ mo seyil ɗe nwur. ");
INSERT INTO sur_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Wen naa kaaɗe Laatǝm nǝ, fulep mbii luwaspee ɗinshee mɓwut ɗepwoovǝl sǝ mo. Ɗangɓe an kǝlǝng ɗoo kǝ memee mɓut mbǝ ɗefeer ɗe mo kǝ seen sǝ. Wur petpee shi ɗoo ɗeɓal kaa kwòot kǝ nluu sǝ nǝnee, << Jì!>> ");
INSERT INTO sur_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","Kaaɗe wen naapee, ɓe wen naa mee bǝrǝng ɗepiyaa kǝ ji akyeen fen. Gwar ɗe wur lang bǝrǝng ɗesǝ, wur kǝ nree nsar wur. Mo shin mbiikáa ɗǝɗes nwur, wur jì put kaa ɓǝrǝng nǝ kaa gu koorong sǝ, mɓe kǝ wur sǝ koorong ɗi. ");
INSERT INTO sur_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Kaaɗe Laatǝm nǝ fulep mbii lwaspee ɗevǝl nǝ, ɓe wen kǝlǝng mbii ɗevǝl ɗǝ kǝ seen sǝ mo, sat nǝnee, << jì!>> ");
INSERT INTO sur_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","Ɗangɓe mee bǝring npoo jì put, nǝ a naat. Gwar ɗe wur lang bǝring ɗenaat ɗesǝ nǝ, mo shin iiko nwur mbǝkǝ wur mang tongryang baa kǝ nǝ aku ndǝǝn yil ɗese, mbǝkǝ gurum mo ɗoom twe shak ɗi. mo shin mee kwai ɗeɗes nwur zak. ");
INSERT INTO sur_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","Kaaɗe Laatǝm nǝ fulep mbii luwaspee ɗekun nǝ, ɓe wen kǝlǝng mbii ɗekun, ɗe kǝ seen nǝ sat nǝnee, <<Jì!>> naapee, ɓe naa bǝring ɗetǝp a kyeen fen. Gwar ɗe wur lang bǝring ɗetǝp nǝ, wur kǝ mbii kám mbii mo nɗǝǝn sar fǝn. ");
INSERT INTO sur_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","ɓe nkǝlǝng mee mbii kaa ɗoo sǝ, ndǝǝn mbǝ ɗefeer ɗe mo kǝ seen sǝ, ɗoo nǝ sat nǝnee, <<Gurum mmang shool ɗak wur, mǝ puus mǝndong, kǝ wur seet muuduu mǝ alkama ɗe mǝndong, kǝ zak, gurum mang shool ɗak wur, mǝ puus mǝndong, kǝ wur seet muuduu mo kun mǝ shwanan ɗǝ. Mbe taji a tǝkook kǝ mwoor nǝ kǝ am anab nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","Kaaɗe Laatǝm nǝ fulep mbii luwaspee ɗefeer nǝ, ɓe wen kǝlǝng ɗoo kǝ ɗefeer mɓut mbǝɗe mo kǝ seen nǝ wur sat nǝnee, <<Jì!>> ");
INSERT INTO sur_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","Ool mee bǝring sǝ, nǝ a vuun, akyeen fǝn, moo pet gwar ɗe wur lang bǝring ɗesǝ a muut, kǝ peetong nǝ nenmuut mo mɓwoon nwur. Mo cin iiko mo nkaa mǝndong mɓut feer kǝ yil nǝ, mbǝkǝ mo twe gurum mo shi kwai, kǝ neen, kǝ muut, kǝ luwayil mo zak. ");
INSERT INTO sur_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Kaaɗe wur fulep mbiiluwaspee ɗepaat nǝ, ɓe wen naa nder kǝ peewus mbezuum. A seen kǝ nen ɗe gyet mo twe mo, mbǝɗe gyet mo satpwoo Naan nǝ, kǝ zak, mo ɗar kaa shin zeen fur. ");
INSERT INTO sur_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","Mo petpee shi ɗoo ɗeɗes <<Daa Naan ɗǝɗes, ɗeɓang, kǝ ɗe waa azeen, <<a pǝrang ɗang wen ntokɗyeel nenyil nǝ mo ye? <<Nen ɗe gyet mo twe mun sǝ mo, <<mɓǝkǝ waa laa kwat mo ɗe yii?>> ");
INSERT INTO sur_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","Koo aweyi ɗǝǝn mo mo shin lée ɗepiyaa mo jwal. Ɗang mo waa sat mo nǝnee, <<Wu gung ɗelee aku, kǝ ɗuu kǝ shaar ɗak fuu mo, kǝ ɗyemnǝǝn fuu ɗe mo ntwe mo, kaaɗe mo twe wun sǝ, ");
INSERT INTO sur_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Naa Laatǝm nǝ fulep mbii luwaspee ɗepeemee nǝ, ɓe naa yil nǝ yoon ɗes zam, ɗangɓe puus nǝ cǝǝr ɗee a tǝp kaa nlǝr maap, ɗe moo ɗak shi shweep ghǝ sǝ, kǝ tar nǝ cǝǝr ɗee a naat kaa toom sǝ. ");
INSERT INTO sur_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","Zar mo ndǝǝn ɗengnaan, mbe mo sham ɗyong nyil, kaaɗǝ laatǝng kyeen ɗenung moo ɗyong nyil, katɗang kut cutpee ɓalɓal sǝ. ");
INSERT INTO sur_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Ɗengnaan nǝ ɗel loom kaa garvit ɗe mo cǝɓet sǝ, mo shang jir zuul nǝ mo, kǝ yil ɗe am neer mo le nnaar, baa kǝ nǝ pee mo ɗe. ");
INSERT INTO sur_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","Ɗangɓe mishkoom mǝ yil nǝ mo, kǝ nen ɗe mo se mulki mo, Ke jep mishkoom mo kǝ ɗenan-nan mǝ shiitoon mo, kǝ nenlong mo, kǝ nen ɗe mo kǝ iiko mo, kǝ koor gurum mo jir, kǝrem mo, kǝ jeplu mo, mo dǝm loom ndǝǝn gwoot mo, kǝ goop zuul mo. ");
INSERT INTO sur_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","Mo pǝt Zuul nǝ mo kǝ jwak nǝ mo nǝnee, <<Wu jì wu taa nkaa mun, kǝ wun paa mun yit gwar ɗe wur kǝ tong nkaa mulki nǝ kǝ tuup Laatǝm nǝ. ");
INSERT INTO sur_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","Mɓeeɗe puus tuup mo ɗeɗes nii jì wul. A wii mmak ɗar pwoo nǝ mpuus mǝnǝ yii?>> ");
INSERT INTO sur_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Aɓwoon ɗe mbii ɗesǝ mo kyes, ɓe nghan naa nenlep kǝ Naan mo feer, moo ɗar nkoop kwang ɗefeer mǝ yil nǝ, mo yaa kut ɗin nkwang ɗefeer mǝ yil nǝ mo ɗar kǝ nǝ, mbǝkǝ taji mee kut cutpee nkaa yil nǝ, koo nkaa baahar, koo nkaa tǝng mo kas. ");
INSERT INTO sur_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Ɗangɓe nghan naa mee ngulep nNaan, ɗe wur kǝ put a nkoop puus kàa, wur kǝ me bii lǝlu Awas pee Naan ɗe kǝ seen nsar wur. Wur pet nenlep ɗefeer nǝ mo shi ɗoo ɗi ɓalɓal ɗe mo shin iiko mo, mbǝkǝ mo tǝkook kǝ yil kǝ am. ");
INSERT INTO sur_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","Ɓe wur sat nǝnee, <<Taji wu wat yil nǝ, koo baahar nǝ, koo tǝng mo kas. Wu ɗar akuɗang, see mǝ le fili (alaama) mǝ lǝluwas mǝ Naan nkaa pǝkyeen mǝ kǝrem wur mo akuɗang.>> ");
INSERT INTO sur_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Ɗangɓe nghan kǝlǝng ɗuu nen ɗǝ mo le fili (alaama) nǝ mo mpǝkyeen mo, mo ngal kambil mǝndong kǝ lar feer baafeer. Nen ɗesǝ nǝ mo put a ndǝǝn koo soon ɗeɗangyi mǝ nen Izrel mo. ");
INSERT INTO sur_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","nKwang soon Juda mo, Ngal kaapaat baavǝl nKwang soon mǝ Ruben mo, Ngal kaapaat baavǝl. nƊǝǝn soon mǝ Gad mo, Ngal kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","nKwang soon mǝ Asher mo, ngal kaapaat baavǝl, nKwang soon mú Naftali mo, ngal kaapaat baavǝl, nKwang soon Manasseh, ngal kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","nKwang soon mǝ Simiyon, ngal kaapaat baavǝl. nKwang soon Levayi mo, ngal kaapaat baavǝl, nKwang soon Isaka, ngal kaapaat baavǝl, nKwang soon Zebulum, ngal kaapaat baavǝl, nKwang soon Josef, ngal kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","nKwang soon Zebulum, ngal kaapaat baavǝl, nKwang soon Josef, ngal kaapaat baavǝl. nKwang soon mǝ Benjami mo, ngal kaapaat baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Aɓwoon ɗesǝ, ɓe wen ool, mbǝ ɗuu gurum mo ɗes, ɗe baa mee gurum mak tang mo kas. Nen ɗesǝ nǝ mo puwat a ndǝǝn yil mo shinǝ-shinǝ, kǝ nkwang soon mo shinǝ-shinǝ, kǝ gurum mo shinǝ-shinǝ, kǝ liispwoo mo shinǝ-shinǝ, kǝ ndǝǝn koo a pee ɗeɗangyi ndǝǝn yil ɗǝsǝ. Mo ɗar ntoom peetong mǝ mulki, kǝ ntoom Laatǝm. Mo jwal lée ɗepiyaa mo, mo kǝ kom kǝkar nsar mo zak. ");
INSERT INTO sur_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","Mo ɗiyeep ɗoo mo mo ashak shiɓal, nǝnee, <<Ɓam tong a pǝ Naan fun, ɗe wur tong nkaa peetong mǝ mulki sǝ, kǝ Laatǝm nǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","Nenlep mo jir, moo ɗar atǝng neer peetong mǝ mulki nǝ, kǝ nennan sǝ mo, kǝ mbǝ ɗefeer ɗe mo kǝ seen sǝ mo zak. Nenlep nǝ mo saam kǝ yit fur nyil ntoom peetong mǝ mulki nǝ, kǝ mo seyil nNaan. ");
INSERT INTO sur_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","Mo sat nǝnee, <<Nǝ aasǝ, kwoop, kǝ ɗehai, kǝ seen, kǝ pǝlang, kǝ ɗǝɗes, kǝ iiko, kǝ ɓal, mo ɗee a mǝ Naan fun mbǝ ngaa-ngaa, Nǝ aasǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Ɗangɓe memee mɓut nennan nǝ mo wur tal pǝ an ɗi, ɓe wur sat nǝnee, <<Nen ɗǝ mo din nlǝr ɗe piyaa-piyaa sǝ mo awii mo me? Mo pwat a ni jii?>> ");
INSERT INTO sur_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Wen lap nwur nǝnee, <<Daa fen, a man.>> Ɗangɓe wur sat nǝnee, <<Nen ɗesǝ mo, a nen ɗe mo pwat ndǝǝn nen ɗi mo shin keer mo, mo kǝ vwang lée nmo, kǝ mo ɗee a ɗepiyaa mo, ndǝǝn toom Laatǝm. ");
INSERT INTO sur_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","A mpeemǝnǝ, ɓe moo ɗar ntoom peetong mǝ mulki Naan, kǝ moo seyil ndǝǝn Lu Naan ɗǝdes, mpaar kǝ puus. Gwar ɗe wur tong nkaa peetong mǝ mulki nǝ, wur tap mo. ");
INSERT INTO sur_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Baa neen ncham láa mo kas, kǝ zak, baa neen am cham tu mo kas. Baa puus, koo tal kǝ puus nǝn cham mo kas. ");
INSERT INTO sur_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","Laatǝm ɗe wur nnaar peetong mǝ mulki nǝ, wur nɗeen a ngukiyeer mo. Wur dǝm kǝ mo a pee tuɓut ɗe nǝ a mǝ seen. Naan wur mpwes yitmwaan mo jir.>> ");
INSERT INTO sur_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","Ɗe Laatǝm nǝ fulep bii luwas ɗe pwoovǝl nǝ ɓe pee ɗok titik nɗǝǝn ɗengnaan, mbe nǝ kus kǝ koor awa mǝndong. ");
INSERT INTO sur_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","Wen naa jeplep Naan mo pwoovǝl, ɗe moo ɗar ntoom Naan, ɓe mo shin feer mo pwoovǝl. ");
INSERT INTO sur_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","Mee ngulep Naan wur jì ɗar kus kǝ peewus mbiizuum, wur kǝ mee shool mǝ zinariya wus mbezuum. Mo shin mwoor ɗeɗu shangshang mǝ wus mbiizuum nwur ɗes, mbǝkǝ wur shin mo ɗe ashak kǝ ɗangnaan mǝ nen Naan mo, nkaa peewus mbiizuum ɗe mo ɗak nǝ a shi zinariya, ɗe nǝ ntoom peetong mǝ mulki ne. ");
INSERT INTO sur_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","Ɗiyeel wus mbezuum ɗǝ kǝ toos shangshang nǝ, kǝ ɗangnaan mǝ nen Naan mo, ɗe nǝn nsar ngulep Naan nǝ, nǝ kàa wul pee Naan ɗǝ. ");
INSERT INTO sur_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","Ɗangɓe ngulep nǝ wur mang ɗaa shool mǝ wus mbezuum nǝ, wur gam shool nǝ shi wus nkaa pe wus mbiizuum nǝ, ɓe wur vwet nkaa yil nǝ, Kaaɗe wur vwet wus ɗesǝ nǝ nkaa yil nǝ, ɓe peekwoot, kǝ ɗoo mo, kǝ pee mǝlep, ɓe yil nǝ yoon. ");
INSERT INTO sur_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","Ɓe nenlep Naan ɗepwoovǝl ɗe mo kǝ feer mo pwoovǝl sǝ, mo ɗaksut, mbǝkǝ mo tàa feer nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","Ngulep Naan ɗinshee tàa feer wur, ɓe ɗoor kǝ wus, riyeep kǝ toom, mo sham ɓeer nkaa yil nǝ. Mǝndong nkaa kun, mǝ yil nǝ caan, kǝ mǝndong nkaa kun mǝ tǝng mo caan zak, kǝ shit ɗe mbrak mo caan jir. ");
INSERT INTO sur_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","Ngulep Naan ɗevǝl tàa feer wur, ɓe mee mbii kaa duum jwak lap wus, ɓe mo vwet nǝ ndǝǝn baahar. Mǝndong nkaa kun mǝ baahar nǝ cǝǝr atoom. ");
INSERT INTO sur_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","Ɓe Mǝndong nkaa kun, mǝ mbǝɗe mo kǝ seen ɗen baahar nǝ mo murep jir, Mǝndong nkaa kun, mǝ tii mo tǝkook. ");
INSERT INTO sur_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","Ngulep Naan ɗekun wur tàa feer wur, ɓe mee zar ɗǝɗes, ɗe nǝ lap wus hǝlak-hǝlak kaa ngǝyem sǝ, nǝ put aɗeng ɓe nǝ sham táa nkaa mǝndong mɓut nkun, mǝ gyeen mo, kǝ tuɓut mǝ am mo. ");
INSERT INTO sur_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","Sǝm zar ɗesǝ nǝ a, Ɗeet. Ɓe mǝndong mɓut nkun mǝ am nǝ, mo cǝǝr ɗee a ɗeɗeet, gurum mo ɗes mo murep, mbǝ am ɗǝ nǝ kǝ ɗen a ɗeɗeet. ");
INSERT INTO sur_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","Ngulep Naan ɗefeer tàa feer wur, ɓe mo cut mǝndong mɓut nkun mǝ puus, kǝ mǝndong mɓut nkun mǝ tar, kǝ mǝndong mɓut nkun mǝ zar mo, Mɓemǝnǝ, ɓe mǝndong mɓut nkun mǝ peeɓang mo baa moo kuɗi kǝ ɓangpee kas. Mǝndong mɓut nkun mǝ puus, baa nǝ kuɗi kǝ peeɓang kas, kǝ mǝndong ɗin kun mǝ paar nǝ ɓangpee kas. ");
INSERT INTO sur_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Kaaɗe nghan naapee, ɓe nghan kǝlǝng mee puul, ɗe nǝ mwaan aɗeng, nii petpee shi ɗoo ɗeɓal, nǝnee, <<Jeel! Jeel! Jeel. Mpee gurum ɗe mo ndǝǝn yil nǝ, mbǝɗe nenlep Naan ɗe mo kuɗi kun sǝ, mo kus kǝ tàa feer mo.>> ");
INSERT INTO sur_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","Ngulep Naan ɗepaat wur tàa feer wur, ɓe nghan naa mee zar ɗe nǝ tong a ɗengnan sham taa ɓǝm-yil nǝ. Mo shin biwangpee nzar nǝ mǝ tuun ɗejurum, ɗe baa nǝ kǝ peeɗar sǝ kas nwur. ");
INSERT INTO sur_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","Kaaɗe wur wang pwoo tuun ɗejurum ɗesǝ nǝ, ɓe ɗyeel kàa put ndǝǝn tuun nǝ, kaa ɗyeel wus ɗe nǝ se lu sǝ. Ɗiyeel ɗesǝ nǝ kàa paa puus, kǝ ɗengnaan, mbe pee nǝ rap kaa par sǝ. ");
INSERT INTO sur_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","nƊǝǝn ɗyeel ɗesǝ nǝ, ɓe ciɓel mo sham nkaa yil nǝ, mo shín ɓal mo kaa mǝ ɗoor mo sǝ. ");
INSERT INTO sur_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Mo sat mo, << taji wu tung shit, koo tǝng, kǝ bii ɗǝ mo kop mo ɗe mo ndǝǝn yil nǝ kas, mɓe wu tung a nen ɗe baa mo kǝ mbii luwas mǝ Naan pǝkyeen mo kas. ");
INSERT INTO sur_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","Baa mo shin iiko nǝ mo a mbǝkǝ mo twe nen ɗesǝ nǝ mo kas, mɓe mo shin iiko nǝ mo, a mbǝkǝ mo shinjeel ɗe nen ɗesǝ nǝ mo mbǝ tar mo paat. Jeel ɗe mo shwaa nǝ, nǝ shwal kaa shwal ɗe ɗoor pus gurum sǝ. ");
INSERT INTO sur_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","nƊǝǝn tar ɗepaat ɗesǝ nǝ mo, ɓe nen ɗesǝ nǝ mo yap muut, mɓe baa mo kat kas. Moo rǝɓet muut mɓe muut nǝ dǝm jong kǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","Ciɓel ɗesǝ nǝ mo lapshak kǝ bǝring ɗe mo tap ɗak mo mbǝ dǝm nlek. Mo jwal mee mbii mo nkáa mo, kaa mbiikáa ɗe mo ɗak mo shi zinariya sǝ, kǝ zak, yit mo lapshak kǝ yit ngurum mo. ");
INSERT INTO sur_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","Shwepkáa mo, a kaa mǝ shurep mo sǝ, kǝ zak, oos mo nǝ a kaa oos mǝ mbwoor mo sǝ. ");
INSERT INTO sur_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","Mo paa tuur mo nǝ mo, shi shool, kǝ cáap mo mo wal nciit kǝ wal mǝ shii bǝring ɗe moo dul keke bǝring mo mbǝ dǝm nlek. ");
INSERT INTO sur_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Mo kǝ nɗang ɗe nii pwaspee kaa ɗoor mo sǝ. A shi ndang ɗesǝ mo, ɓe mo katɓal mbǝ shinjeel gurum mo, mbǝ tar mo paat. ");
INSERT INTO sur_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","Mo kǝ gwe ɗǝ a kaa mishkoom mo a ngulep mǝ tuun ɗejurum, ɗe baa nǝ kǝ peeɗar kas sǝ, sǝm wur shi Yahudi, a Abaaddon, ɗangɓe sǝm wur shi Heleni a Apoliyon. Shi mǝnǝ a nǝnee, <<Ngutǝkook kǝ mbii mo.>> ");
INSERT INTO sur_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","Jeel ɗeɗes ɗinshee nǝ ɗel mmǝnǝ. Ɗee jeel ɗeɗes mo ɗe vǝl, ɗe mo ndang jì. ");
INSERT INTO sur_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","Ngulep kǝ Naan ɗepeemee nǝ wur tàa feer wur, ɗangɓe nghan kǝlǝng mee ɗoo nǝ jì put ndǝǝn kwang ɗefeer mǝ peewus mbezuum ɗe mo ɗak nǝ a shi zinariya, ɗe nǝ ɗar ntoom Naan. ");
INSERT INTO sur_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Ɗoo nǝ katpwoo ngulep ɗepeemee ɗǝ wur kǝ feer nǝ nǝ nǝnee, <<A fween nenlep ɗefeer sǝ mo, ɗe gyet mo ɓwoot mo le ngǝyen Yufrates ɗeɗes sǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","Nenlep ɗefeer ɗesǝ mo, mo gyet bwet mo a mbe pee ɗesǝ, kǝ teer, kǝ tar, kǝ ɓit nǝ, gyet mo ɓwet mo, kǝ mo twe gurum ɗe nyil nǝ mo mǝndong kaa kun. ");
INSERT INTO sur_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Ɗuu shiiton ɗe mo lang bǝring nǝ mo a miliyon kambil vǝl. Wen kǝlǝng ɗuu mo nǝ ");
INSERT INTO sur_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","Bǝring nǝ mo kǝ nenlang nǝ mo, ɗe wen naa mo ndǝǝn suun fen nǝ, mo lap kǝsǝ, gwat tuur mo, ɗe nǝ naat kaa wus sǝ, nǝ tǝp kaa ɗengnaan sǝ, kǝ zak, nǝ a kaa fwat wus sǝ. Káa bǝring nǝ mo lapshak kǝ mǝ nvar mo. Wus kǝ ɗiyeel, kǝ fwat wus mo jì put mpwoo kǝ bǝring nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","Mǝnɗong kaa kun mǝ gurum ɗe nyil nǝ mo mo murep mbe mbii shin jeel ɗekun ɗesǝ mo, wus nǝ, kǝ ɗiyeel, kǝ fwat wus ɗe pwat pwoo bǝring nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","Ɓal bǝring nǝ mo, a nɗǝǝn pwoo mo, kǝ ndang mo mo. Dang mo nǝ mo a kaa nwòo mo sǝ, ɗe mo kǝ káa. A shi nɗang ɗesǝ nǝ mo, ɓe bǝring ɗesǝ mo cínjeel gurum ɗe nyil mo. ");
INSERT INTO sur_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","Kaar gurum ɗe baa mo murǝp nsar kǝ jeel ɗesǝ mo kas, ɓe baa mo tuwap kas, mo sat a nseyil nriin ɗebish mo, kǝ kùm ɗe mo ɗak shi zinariya, kǝ azurfa, kǝ bòng ɗenaat, kǝ jwak, kǝ yoom mo. Baa moo naapee, koo kǝlǝngpee, koo mee mwaan kas. ");
INSERT INTO sur_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Baa mo waa tuwap mbǝ tukáa ɗe moo cin nǝ kas, kǝ mulak, mo kǝ shin ngaa, kǝ wat. ");
INSERT INTO sur_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","Ɗangɓe wen naa mee ngulep kǝ Naan ɗeɗes, wur tong a ɗengnaan sham. nLuu paa wur kaa nlǝr sǝ, kǝ zak, wiw neer káa wur cǝǝrkaat. Yit wur nǝ a kaa puus sǝ, kǝ shii wur nǝ mo a kaa ndwet ɗǝnan-nan mǝ wus sǝ. ");
INSERT INTO sur_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","Wur kǝ mee replàa garvit, ɗe nǝ a wuwang nsar wur, wur leshii se wur nǝ nkaa baahar, kǝ shii kul wur nǝ kaa yil, ");
INSERT INTO sur_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","Ɗangɓe wur petpee shi ɗoo ɗeɓal ɗe nǝ lap shak kǝ or mǝ nvar. Kaaɗe wur kǝ petpee nǝ, ɓe peekwoot ɗepwoovǝl mo lap nwur shi ɗoo ɗeɓal. ");
INSERT INTO sur_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","Kaaɗe peekwoot ɗe pwoovǝl nǝ mo leshap, ɓe wen kǝn rǝɓet ran nǝ, mɓe wen kǝlǝng mee ɗoo ndǝǝn ɗengnaan sat nǝnee, <<A shoot mbǝɗe nluu ɗe mo petpee pwoovǝl nǝ mo sat. Taji a ran mbǝɗe mo sat nǝ kas.>> ");
INSERT INTO sur_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","Ɗangɓe ngulep kǝ Naan, ɗe mee shii wur nǝ nkaa baahar, kǝ mee shii wur nkaa yil sǝ, wur ɗiyeep sar se wur kaa aɗeng. ");
INSERT INTO sur_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","Wur tuceerpwoo nɗǝǝn sǝm kǝ Naan ɗe wur ɗe ngaa-ngaa, Wur ɗe wur le ɗengnaan ke mbii ɗe ɗǝǝn mo, kǝ ɓǝm-yil kǝ mbii ɗe ɗǝǝn mo, kǝ baahar kǝ mbii ɗe ɗǝǝn mo. Laalep nNaan nǝ sat nǝ, <<Baa mee pee kuɗi kas! ");
INSERT INTO sur_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","Katɗang laalep Naan ɗe pwoovǝl wur kus tàa feer wur nǝ, ɓe mbii mǝ Naan ɗesǝsok mo ngam, kaaɗe gyet wur kǝ ten sat nkǝrem wur mo, nensatpwoo Naan mo. ");
INSERT INTO sur_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","ɗangɓe ɗoo ɗe ken kǝlǝn sǝ nɗǝǝn ɗengnaan, nǝ katpwoo kǝ nghan zak nǝnee, <<A dǝm, a mang ngarvit ɗe wuwang nsar laalep nNaan ɗe wur kǝ ɗar nkaa baahar kǝ yil.>> ");
INSERT INTO sur_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","nƊǝm pee Laalep nNaan nǝ ntal kǝ wur shin rep laagarvit nǝ nghan. Wur sat nghan nǝ, <<A la, a se. Nǝ be nɗuwang ɓut nfwaa, dang mɓut mpwoo fwaa, ɓe nǝn mbǝ shang kaa loor nshii sǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","Wen la replàa ngarvit nǝn nsar Laalep nǝ nse, ɓe nǝ shang nciit kǝ loor nshii pwoo fen. Abwoon ɗe nɗal nǝ, mɓe cǝǝr ɗuwang ɗuwaan mɓut fen. ");
INSERT INTO sur_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Ɗangɓe mo sat nghan nǝnee, <<Nǝ atǝng a baa can joom zak ɗǝ gurum mo shinǝ-shinǝ kǝ nyil mo shinǝ-shinǝ, kǝ lespwoo mo shinǝ-shinǝ, kǝ nkaa mishkoom mo mo shinǝ-shinǝ zak.>> ");
INSERT INTO sur_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","nLa mee kam, kaa kám kam mbii sǝ, ɗangɓe mo sat nghan nǝnee, <<A dǝm a kám Lu Naan ɗeɗes nǝ, kǝ peewus mbezuum nǝ kǝ, a tang ɗuu nen seyil nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","Mbe taji a kám fuur nǝ kas, mbǝɗe mo kǝ ten shin mǝnǝ, nen ɗe baa mo a nen Yahudi mo kas. Nen ɗesǝ mon treng nkaa yilkaam ɗeɓang nǝ, mbǝ tar mo laarfeer baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","Wen mbe nshin nlangtǝng fen mo vǝl, mbǝkǝ mo sat joom, mbǝ teer mo ngal mǝndong kǝ ɗari vǝl kǝ laarpeemee. Mo njwal leemaap mo.>> ");
INSERT INTO sur_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","Nenlangtǝng ɗevǝl ɗesǝ nǝ mo, a mo a tingpaat ɗevǝl sǝ mo, kǝ ngyem ɗevǝl sǝ mo zak, ɗe moo ɗar ntoom kǝ Daa ɗe mǝ yil ɗesǝ ne. ");
INSERT INTO sur_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","Katɗang mee gurum kǝ rǝɓet tǝkook kǝ mo, ɓe wus njì put mpwoo mo, mbe nǝ se shaarlek mo mo. A ɗesǝ ɗee, a ar muut jir gwar ɗe wur kǝ rǝɓet tǝtook kǝ mo ating kǝ wur muut. ");
INSERT INTO sur_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","Nen ɗesǝ nǝ mo kǝ iiko, mbǝkǝ mo shoot ɗengnaan, mbǝkǝ taji fwan jì kas, nɗǝǝn teer ɗe mo nkaa can joom. Kǝzak, mo kǝ iiko, mbǝkǝ mo le am mo jir, mo ceer a toom. Mo mak cut mɓǝmyil nǝ shi shwal mo shini-shini, kaaɗe mo naa nǝ ret mo nyit sǝ. ");
INSERT INTO sur_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","Aɓwoon ɗe mo nkyes sat caamkat mo nǝ mo, ɓe mee luwa ɗe nǝ kàa put nɗǝǝn tuun ɗe baa nǝ kǝ peeɗar kas sǝ. Luwa ɗesǝ nǝn mɓwet lek nkaa mo, mbe nǝn nse koorong nkaa mo, ɗangɓe nǝn ntwe mo zak. ");
INSERT INTO sur_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","Kúm ɗes nǝ mo mbǝ ngǝrang nɗǝǝn peekat mǝ yilkaam ɗǝnan-nan sǝ mo, ɗe moo kǝ koon mo a kǝ <<Sodom>> kǝ <<Ijip>> sǝ, pee ɗe gyet mo pwas Daa mo ɗe. ");
INSERT INTO sur_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","Mbe teer kun kǝ koor ɓǝ Gurum, mo shinǝ-shinǝ, soon mo shinǝ-shinǝ, liispwoo mo shinǝ-shinǝ, kǝ yil shinǝ-shinǝ, mo nnaa kúm kǝ mo nǝ, mbǝ mo ncii wum kúm kǝ mo ne. ");
INSERT INTO sur_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","Nen ɗe moo tong nɗǝǝn yil ɗese, mo mbe ncìn retnyit mbǝ murǝp kǝ das ɗevǝl ɗesǝ nǝ mo, mo mbe yool mǝrep kǝ retyit. Kǝ zak, mo nlep zuum mo nshak, mbǝɗe nenjoom ɗe ɗevǝl sǝ mo kǝ shinjeel nen ɗe yil nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","Aɓwoon teer mo kun kǝ koor, ɓe Naan wur le kǝ nook mǝ seen ɗel nɗǝǝn mo, mbe mo yool ɗar nkaa shii mo mo, ɗangɓe mee kǝǝrmuut ɗeɗes nǝ yaa nen ɗe mo naa mo. ");
INSERT INTO sur_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","Ɗangɓe nen ɗevǝl sǝ mo kǝlǝng mee ɗoo ɗeɗes ɗe nǝ put nɗǝǝn ɗengnaan nǝ sat mo nǝnee, <<Wu kàa sǝ.>> Ɓe shaarlek mo naa mo ɗel kàa nɗǝǝn ɗengnaan ɗǝǝn nluu. ");
INSERT INTO sur_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","Abet-abet, ɓe yil nǝ yoon ɓalɓal. Mǝndong mɓut nkaapaat mǝ yil nǝ pyan, kǝ gurum mo ngal pwoovǝl, mo murǝp nɗǝǝn yoon kǝ yil mǝnǝ. Kǝǝrmuut ɗeɗes yaa koor nen ɗe mo baar nǝ mo, mbe mo kwoop ɗǝdes nNaan ɗe wur nɗǝǝn ɗengnaan. ");
INSERT INTO sur_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","Aɓwoon mbii shin keermuut ɗevǝl kǝ ɗel, mɓe mbii shin keermuut ɗekun nǝn njì kǝlak-kǝlak. ");
INSERT INTO sur_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","Ngulep Naan ɗe pwoovǝl nǝ wur tàa feer fǝn, ɓe ɗoo ɗeɓal-ɓal mo nɗǝǝn ɗengnaan, mo sat nǝnee, <<Semishkoom mǝ yil ɗesǝ nǝ, nǝ ɗee a mulki mǝ Daa fun, kǝ mǝ Kristi, wur ncìn mulki nǝ a mbǝ ngaa-ngaa.>> ");
INSERT INTO sur_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","Ɗangɓe nennan ɗe Laarvǝl baafeer sǝ mo, ɗe moo tong nkaa mbii tong mǝ mulki mo mo ntoom kǝ Naan sǝ, mo kurum nyil, kǝ mo seyil ɗe nNaan. ");
INSERT INTO sur_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","Mo sat nǝnee, <<Mu pǝlang waa, Daa Naan ɗeɓal met jir, A waa ɗe yaksǝ, kǝ ɗe ɗeyaam, mɓeeɗe aa mang iiko fwa ɗeɗes, kǝ a yaa se mulki. ");
INSERT INTO sur_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","Yil nǝ mo langtuup, dang tuurnung ɗebish ɓish fwaa kǝ ji. Pee nǝ wul ɗe mon tokɗyeel Nen mumuut mo, kǝ shin kwat kerǝm fwaa nen cin joom mo kǝ nen fwaa mo ɗe moo ɗyeep sǝm fwaa, ɗenan, kǝ ɗeɗyeen kǝ mbe tǝkook kǝ nen ɗe mo tǝkook kǝ ɓǝmyil nǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","Lu Naan ɗeɗes ɗe nǝ nɗǝǝn ɗengnaan wang, ɓe mo naa Kwati Mǝ Tucǝǝrpwoo shi toom mǝ Naan. Ɗangɓe pee nǝ mǝlep ɗes, kǝ ɗoo ɗeɗes mo, mǝ peekwoot, ɓe yil nǝ yoon, kǝ vivir. ");
INSERT INTO sur_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","Mee mbii naaman ɗeɗes put ɗǝǝn ɗengnaan, Mee mat war, lep nlǝr puus, kǝ tar nder shii war, kǝ war lepmbiikaa mulki kǝ zar mo kaapaat baavǝl nkáa war. ");
INSERT INTO sur_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","War dǝ kǝ aak ɓe war wal ɗeɓal ɓut shal, kaaɗe aak nǝ ɗoom se war. ");
INSERT INTO sur_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Ɗangɓe mee mbii naaman zak nǝ jì put ɗe nɗǝǝn ɗengnaan nǝ, mee duum nwòo ɗeɗes, ɗe nǝ a naat, kǝ káa mo pwoovǝl, kǝ soom mo kaapaat, kǝ mbiikáa mǝ mulki mo pwoovǝl, nkaa nǝ. ");
INSERT INTO sur_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","nƊang nwòo nǝ fet mǝndong kaa nkun, mǝ zar ɗe mo nɗǝǝn ɗengnaan sham ɗyong nyil. Nwòo nǝ ɗar akyeen mat ɗe war pǝ yap làa-làa sǝ, mbǝkǝ nǝ ɓalapǝ se làa nǝ ɗi kaɗang war laa. ");
INSERT INTO sur_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","War làa ɗemish, wur ɓe nse mulki nkaa nyil mo jir, shi kamshool. Nǝ ɓam laa nǝ kwet! Shi kàa pee Naan ɗi, npeetong mulki wur. ");
INSERT INTO sur_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","Mat nǝ war su dǝm a naaryil, a npeeɗe Naan wur tap ɗakle nwar, ɗe mo ntap war, mbe teer mo ngal mǝndong, kǝ kambil vǝl kǝ laarpeemee. ");
INSERT INTO sur_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","Lek yool nɗǝǝn nɗengnaan. Makiyel kǝ nenlep wur mo, mo nkaa lek kǝ nwòo nǝ, nwoo nǝ kǝ nenlep wur mo cǝǝr lek kǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","Dang baa ɓal wur nǝ mak kas ɓe mo ceen wur ɗǝǝn ɗengNaan nǝ. ");
INSERT INTO sur_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","Mo mang cut am ɗesǝ nǝ, mo vwet wur shin sham nɗǝǝn yil nǝ nwòo ɗegyet mǝnǝ mo pet wur a ngujwaan, ko shetan ɗǝ wur gwom gurum mo yil nǝ dǝm kǝnǝ a ar ɗe nkan mo mang wur vwet shi sham yil, kǝ jeplep wur mo. ");
INSERT INTO sur_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Ɗangɓe nghan kǝlǝng mee ɗoo ɗeɗes nɗǝǝn ɗengnaan nǝ sat nǝnee, <<Yaksǝ, ɓe ɓam Naan nǝ kǝ njì wul, kǝ iiko kǝ mulki mǝ Naan fun, kǝ iiko mǝ kristi. Ɓe gwar ɗe wur fǝlǝp ɗyemnǝǝn fun mo, ntoom Naan fun puus kǝ par mo vwet shin sham yil. ");
INSERT INTO sur_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","Mo se koorong nkaa wur mbǝ toom kǝ Laatǝm kǝ, pwoo kaa caamkat mo, baa mo wal seen fur kas hakyeng ɓe mo shin seen fur har muut. ");
INSERT INTO sur_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Mɓemǝnǝ, ɓe wu cin retnyit, wun ɗengnaan mo, <<kǝ nen ɗe moo tong nɗǝǝn ɗengnaan nǝ mo zak, Mbe jeel kaa ɓǝmyil, kǝ baahar nǝ, mɓeeɗe ngujwaan wur kǝ sham pee wun ɗi, Wur gam kǝ pǝtuup ɗewat, Wur man pee wur nǝ ɗee a lee ɗak.>> ");
INSERT INTO sur_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","Kaaɗe cut am ɗesǝ nǝ naa, nǝ, mo vwet wuɗin shin sham nɗǝǝn yil ɗese, ɓe nǝ yaa sushii nɗang mat ɗe war làa-làa ɗemish sǝ. ");
INSERT INTO sur_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","Mbe mo shin cáap mat nǝ mo vǝl ɗe ɗǝnan-nan mǝ puul, mbǝkǝ war katpee yool dǝm wul pee ɗe mo kǝ ten ɗak war annaar yil, pee ɗe mo mbe tap war ɗe ɓǝrepee, kǝ koor pee ɗe baa nwoo nǝ mak wul ɗe kas. ");
INSERT INTO sur_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","Ɗangɓe Nwòo nǝ wuut am shin put mpwoo nǝ kaa gyeen sǝ, ɓe kǝ am nǝ ɗel mat nǝ kǝ nǝ soo war seet kǝ nǝ kǝ tungzung nǝ. ");
INSERT INTO sur_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","Ɗangɓe yil nǝ ɓam mat nǝ war, ɓe nǝ wang pwoo nǝ ɓe nǝ ɗal gyeen ɗe cut am nǝ wuut pwoo wur nǝ. ");
INSERT INTO sur_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","Tuup fes tu nwòo nǝ nɗang mat war kaaɗe nǝ naa baa nǝ mak yaa mat nǝ war kas, ɓe nǝ dǝm yaa lek nkaa ndang kǝ war nǝ mo. Dang kǝ mat nǝ, a nen ɗe moo kǝlǝng ɗoo kǝ Naan, ɗe mo kǝ caamkat kǝ Jesu. ");
INSERT INTO sur_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","kut am nǝ ɗar nkaa pwoo ɗyees mǝ am baahar ne. ");
INSERT INTO sur_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","nWoo, nǝ ɗar duk ɗyees kǝ pwoo am baahar ɓe nnaa mee Luwayil kǝ put ɗǝǝn am baahar. nǝ kǝ soom mo kaapaat, kǝ káa mo pwoovǝl, nǝ kǝ mbiikáa mǝ mulki mo kaapaat nkaa soom wur nǝ mo, koo a káa ɗeɗang yii, ɓe mo ran mee sǝm ɗe nǝ satpwoo ɗebish. ");
INSERT INTO sur_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","Luwayil ɗe nghan naa nǝ, nǝ lapshak kǝ lushim, ɗang nǝ kǝ shii kaa mǝ ludang kǝ pwoo nǝ kaa mǝ nvar sǝ nwoo nǝ shin ɓal fen luwayil kǝ peetong mulki wur nǝ kǝ iiko Ɗeɓal. ");
INSERT INTO sur_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","Mee ɓut káa wur nǝ mo nciit kǝ nǝ mee laa ɗebish bish ɗang laa ɗebish-bish nǝ kǝ zuum. Yil nǝ gam kǝ mbii aapwoo ɓe nǝ taadang Luwayil nǝ. ");
INSERT INTO sur_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","Gurum mo seyil nwoo nǝ ɓeeɗe nǝ shin iikoo luwayil nǝ, ɗang ɓe mo seyil nluwayil nǝ ɓe mo tal nǝnee <<A wee kaa luwayil nǝ sǝ? A wee mak cin lek kǝ nǝ yii?>> ");
INSERT INTO sur_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","Mo shin pwoo nluwa ɗesǝ nǝ mbe kǝ nǝ satpwoo roop, kǝ moo fǝlǝp Naan ɗe kǝ nǝ cin ɗak kǝ iikoo fǝn ɗi mbǝ tar mo laarfeer baavǝl. ");
INSERT INTO sur_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","Luwa nǝ wang pwoo nǝ mbe kǝ nǝ satpwoo ɗebuu mo kaa Naan, kǝ nǝ tǝkook kǝ sǝm wur ɗi kǝ peetong wur, kǝ des ɗi mo kǝ tong a Ɗengnan ");
INSERT INTO sur_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","Mo Shin ɓal nǝ mbǝkǝ nǝ cin lek ɗe nkaa nen Naan ɗeɓang mo kǝ se koorong kaa mo. Ɗang mo shin iiko nkaa jir soon ɗeɗang yii, gurum ɗeɗang yii, liispwoo ɗeɗang yii? kǝ yil ɗǝɗang yi. ");
INSERT INTO sur_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","Jir nǝn ɗe moo kǝ tong nɗǝǝn ɓǝmyil ɗesǝ mo ɓe seyil luwayil nǝ. Jir sǝm ɗi baa mo kǝ ran mo ɗǝǝn bǝǝthaal mǝ seen mǝ laatǝm, laatǝm ɗǝ di mo tuu pǝ gyet ɗe nshee kǝ yil nǝ. ");
INSERT INTO sur_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","Ngwe ɗe wur kǝ kom mbǝ kǝlǝngpee. << ");
INSERT INTO sur_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","Katɗang mee gurum bǝ dǝm pee shoot, ɓe moo dǝm kǝ wur peeshoot. Katɗang mo ntu mee gwe a shi kwai, ɓe nǝ a tǝng mo ntu wur a shi kwai nǝ.>> Ɗesǝ nǝ a petpee mbǝkǝ mo gung, kǝ mo ɗar ɗe ɓalɓal kǝ shinzeen nkwang nen Naan mo. ");
INSERT INTO sur_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","Ɗangɓe naa mee luwayil ɗevǝl, ɗǝ nii put ɗǝǝn Ɓǝmyil. Luwa ɗesǝ nǝ kǝ soom mo vǝl kaa laatǝm sǝ, Mbe nǝ leeshap kaa kut am sǝ. ");
INSERT INTO sur_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Luwa ɗesǝ nǝ cin ɗak kǝ iiko mǝ luwayil ɗeshee nǝ koppee nǝ, kǝ nǝ lee ɓǝmyilɗ kǝ mbii ɗe kǝ tong ɗǝǝn mo seyil ɗe luwayil ɗeshee nǝ, ɗe laa nǝ ɗebish bish sǝ kǝ zuum. ");
INSERT INTO sur_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","Luwayil ɗevǝl ɗesǝ nǝ cin mbii nnaaman mo ɗes hakyeng, nǝ le kǝ wus tong aɗeng Naan sham nkaa ɓǝmyil nǝ nyitnaapee gurum mo. ");
INSERT INTO sur_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","Mbee mbii nnaaman nǝ mo ɓe mo shin ɓal nǝ ɓe cin mbii mo koo-pee mǝ luwayil ɗe nshee nǝ, nǝ gwam nen tong ɗǝǝn ɓǝm-yil nǝ mo. wur lee mo mo ɗen mbii kum mo ɓut shin ɗǝdes luwayil ɗe ɗi wur kat laa shi kwai jir kǝsǝ ɓe wur kǝ seen. ");
INSERT INTO sur_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","Mo shínɓal nluwayil ɗevǝl kǝ wur shin nook ɗe kum luwayil ɗinshee nǝ, kǝ kum nǝ leeshaap ɗi kǝ wur lee jir ngwe ɗi wur cii seyil kum nǝ ɓe mo tu. ");
INSERT INTO sur_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","Nǝ lee ting gurum mo jir, ɗeɗes kǝ ɗelee, nenlong, kǝ nenjeel, jeplu mo, kǝ kǝrem mo, kǝ mo lap mee mbiinaaman nkaa sarse mo, koo nkaa pǝkyeen mo mo, ");
INSERT INTO sur_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","Kǝ taji mo mak seet koo seet kǝ mbii kas see mo kǝ mbii naaman ɗese, ɗe nǝ a sǝm luwayil mǝne koo mee lambaa ɗe naa sǝm nǝ. ");
INSERT INTO sur_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Ɗese nǝ wal a seen ɓe see a ngwe ɗe wur kǝ seen, yit gwe ɗe wur kǝ ɗyeen wur yakshii luwayil nǝ mo ɗe, Mɓeɗe nǝ a lambaa mǝ gurum ɓe lambaa nǝ a 666. ");
INSERT INTO sur_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","Kaaɗe wen ɗiyeep yit, ɓe wen naa Laatǝm akyeen fen, wur ɗar nkaa jwak nZayon, ashak kǝ nen wur gurum, ɗe mo wul ngal kambil mǝndong kǝ laarfeer baafeer (144,000). Das ɗesǝ nǝ mo kǝ sǝm Laatǝm nǝ, kǝ sǝm kǝ puun wur a rǝran nkaa pǝkyeen mo jir. ");
INSERT INTO sur_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Ɗangɓe wen kǝlǝng mee ɗoo sǝ nɗǝǝn ɗengnaan, ɗe nǝ nciit-nciit kǝ wal kǝ am ɗe nǝ sham nɗang ɗes, kǝ nǝ wal kaa peekwoot sǝ. Ɗoo ɗe kǝleng nǝ, nǝ a kaa nen ɗe mo pǝ taa nɗeng-nɗeng sǝ. ");
INSERT INTO sur_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Mo cin kook ɗepwoo ntoom kǝ mpeetong mǝ mulki nǝ, kǝ ntoom kǝ mbii ɗefeer ɗe mo kǝ seen sǝ mo, kǝ ntoom kǝ nennan sǝ mo. Baa mee ngwe mak kám kook mǝnǝ kas, see a das ɗe mo ngal kambil mǝndong kǝ laarfeer baafeer. A mo a nen ɗe mo kǝ ten ang mo nɗǝǝn yil nǝ. ");
INSERT INTO sur_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","Das ɗesǝ nǝ mo a nen ɗe baa gyet mo cam tǝkook kǝ sut kǝ mat mo kas, moo cam man mee mat mo kas. Mo dǝm nɗang Laatǝm nǝ, koo a pee ɗeɗang yii. Mo ang mo mɓut gurum mo, kǝ mo shin mo kaa laa tǝng ɗeshee nǝ nNaan, kǝ Laatǝm nǝ. ");
INSERT INTO sur_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","Baa mee ɗung cam put mpwoo mo kas, mbǝɗe baa mo kǝ mee shikbish kas. ");
INSERT INTO sur_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Ɗangɓe wen naa mee ngulep Naan pwoo, nkaa mwaan nɗǝǝn kut a shi cáap, wur kǝ pwoo ɗeret, ɗeɗǝm ngaa-ngaa, Mbǝkǝ wur sat nǝ ɗe nen ɗe mo nɗǝǝn ɓǝm-yil ɗese. Pwoo ɗesǝ nǝ, nǝ a mbǝ koo a yil ɗeɗang yii, kǝ mbǝ koo a soon ɗeɗang yii, koo a lespwoo ɗeɗang yii, kǝ nǝ a mbǝ gurum mo. ");
INSERT INTO sur_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Wur sat shi ɗoo ɗeɗes nǝnee, <<Wu kǝǝr Naan, wu cin ɗeɗes nwur, mbǝɗe puus tokɗyeel wur nǝ jì wul. Wu seyil nNaan, mbǝɗe a wur le ɗeng mo kǝ yil nǝ. A wur le am nɗǝǝn baahar, kǝ tuɓut mo zak.>> ");
INSERT INTO sur_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","nGulep Naan ɗevǝl nǝ, jì sat nǝnee, << pal! Pal!! Yil Babilon ɗeɗes nǝ pal!!!. Gyet a war le ɗang gurum ɗe nɗǝǝn yil nǝ mo shinǝ-shinǝ mo shwaa am yuurpee, ɗe nǝ a mǝ cin ngaa.>> ");
INSERT INTO sur_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","Mee ngulep Naan ɗekun wur taa dang mo, wur sat shi ɗoo ɗeɓal nǝnee, << Katɗang mee gurum seyil nluwayil sǝ, kǝ muriin wur, mbe kǝ ngwe mǝnǝ lap mbiinaaman mǝ luwayil nǝ nkaa pǝkyeen wur koo sar wur, ");
INSERT INTO sur_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","Mo jir ɓe nshwaa am laa ting ɗe mǝ tuup Naan, Ɗi wur kǝ ten ɗoo shiɓal nɗǝǝn ɗaa shool wur ɗe nǝ a mǝ tuup wur. Mo nshínjeel ngwar mǝnǝ shi wus ɗenaat, ntoom jeplep-Naan ɗeɓang mo, kǝ Laatǝm ne. ");
INSERT INTO sur_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","Ɗangɓe dyeel mǝ shwaajeel kǝ das mǝnǝ mo, nǝ yool kaa aɗeng mbǝ ngaa-ngaa. Baa mee nookɗi ɗi kas par kǝ puus ɓe nen ɗe mo seyil nluwayil kǝ mǝ riin nǝ, Kǝ koo aweyi ɗe la mbiinaaman mǝ sǝm ne.>> ");
INSERT INTO sur_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","Ɗesǝ petpee nen Naan mo, mbǝkǝ mo gung ɗe ndǝǝn tap kǝ Wàar Naan, kǝ zak, mbǝkǝ mo ɗar ɗe ɓalɓal shi shinzeen mo nɗǝǝn Jesu. ");
INSERT INTO sur_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","Ɗangɓe wen kǝlǝng mee ɗoo ndǝǝn ɗengnaan, nǝ sat nǝnee, <<A ran ɗesǝ, Ɗeret aa nen ɗe mo kǝ murep, nen ɗe mo mmurǝp ɗǝǝn Daa, yool nyaksǝ. ɗel dǝm akyeen>> Riin nǝ sat nǝ, << Ii, <<mo nnookɗi mɓut nɗak mo mo, mbǝɗe ɗak cin mo nǝ dǝm nɗang mo.>> ");
INSERT INTO sur_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","Naapee, akyeen fen, ɓe wen naa mee nluu ɗepiyaa, mee gwar kǝtong nkaa nluu nǝ, ɗe wur lapshak kǝ Làa Gurum. Wur kǝ mbiikáa mǝ zinariya nkaa káa wur, ɗǝ wur kǝ mee jeem ɗesese nsar wur. ");
INSERT INTO sur_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","Ɓe mee ngulep-Naan wur jì put ndǝǝn Lu Naan ɗǝɗes, ɓe wur petpee gwar ɗe wur tong nkaa nluu sǝ, shi ɗoo ɗeɓal, <<A mang jeem fwa nǝ, kǝ a yaa ɗiip-ɗiip ɗe, mbǝɗe pee mǝ ɗiip nǝ kǝ jì wul, ɓedǝ Ɗǝɓen nǝ kǝ nung mak ɗiip.>> ");
INSERT INTO sur_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","Gwar ɗe wur tong nkaa nluu sǝ, wur wiit jeem wur nkaa maar ɗe mo nɗǝǝn ɓǝmyil nǝ, ɓe mo ɗiip ɓǝm-yil nǝ. ");
INSERT INTO sur_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","Mee ngulep Naan, wur jì put ndǝǝn Lu Naan ɗeɗes nǝ nɗǝǝn ɗengnaan, ngulep ɗesǝ wur kǝ jeem ɗesese nsar wur zak. ");
INSERT INTO sur_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","Mee ngulep Naan, ɗe a wur kǝ tap wus, wur jì put a npee wus mbezuum ɗi, wur pet ngulep Naan ɗe wur kǝ jeem ɗesese sǝ shi ɗoo ɗeɓal nǝnee, <<A mang jeem fwa, kǝ a yaa saa tuun laatǝng anab ɗi mǝ ɓǝm yil ɗesǝ nǝ, mbǝɗe laatǝng anab nǝ mo kǝ nung.>> ");
INSERT INTO sur_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","Ngulep Naan nǝ wur wiit jeem wur nkaa yil nǝ, ɓe wur yaa saa tuun anab mo, ɗangɓe wur le mo nɗǝǝn pee ɗwat am anab, ɗe nǝ a tuup Naan ɗǝɗes. ");
INSERT INTO sur_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Mo tǝreng, kǝ mo ɗwat làa anab nǝ mo, aɓwoon yilkaam nǝ. Toom put nɗǝǝn làa anab ɗesǝ nǝ mo, mɓe toom nǝ sham kaa am sǝ, ɗe jong nǝ wul meel mo ngal mǝndong kǝ kambil peemee, kǝ jurum nǝ a kaa kám kǝ shii mo paat sǝ. ");
INSERT INTO sur_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","Ɗang wen naa, mee mbiinaaman ɗǝɗes, ɗe nǝ ɗee a mbii aapwoo nɗǝǝn ɗengnaan. Wen naa nenlep Naan mo pwoovǝl, kǝ jeel ɗe mǝ kyes nǝ mo pwoovǝl zak. A shi jeel ɗesǝ mo, ɓe Naan wur woo kyes kǝ tuup wur. ");
INSERT INTO sur_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Ɗangɓe wen naa, mee mbǝɗe nǝn nciit kǝ am baahar mǝ gǝlas, ɗe mo riyeep nǝ ashak kǝ wus, Nen ɗe mo se koorong nkaa luwa sǝ, kǝ nkaa muriin wur, kǝ nkaa gwar ɗe sǝm wur a sǝmɗuu (lambaa), moo ɗar ɗe mpwoo gǝnǝ nǝ. Mo kǝ ndeng-ndeng mo nsar mo, ɗe Naan wur shin mo, ");
INSERT INTO sur_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","ɗangɓe mo cin kook mǝ Mosis kǝrem Naan, kǝ kook Laatǝm nǝ, mo cin kook nǝ nǝnee, <<Ɗak fwa nǝ mo a ɗǝnan-nan mo, ɗe mo aapwoo, Daa Naan ɗe ɓal met jir. Ar fwa nǝ mo a ɗe ndǝre, kǝ mo azeen-nzeen zak, Mishkoom mǝ gurum ɗe mo ndǝǝn yil nǝ mo jir. ");
INSERT INTO sur_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","A wii nkǝǝr waa kas ye, Daa? Kǝzak, a wii nnook kwoop sǝm fwa ye? Daa a waa mmǝsak, a ɗeɓang. Gurum ɗe nɗǝǝn yil mo jir, mo njì seyil nwaa. Mɓeeɗe gurum mo jir, mo kǝ woo ɗak fwa ɗe ndere nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","Aɓwoon ɗese, ɓe nghan naapee aɗengnaan, ɓe nghan naa mo wangpee ɗeɓang mǝ bit mǝ Naan, ɗe nǝ a langteng kǝ pwoo ɗe gyet Naan wur kǝ ten tuweer ne. ");
INSERT INTO sur_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","Nenlep Naan mo pwoovǝl, ɗe mo kǝ jeel mǝ kyes ɗe pwoovǝl sǝ, mo jì put ndǝǝn Lu Naan ɗǝɗes, ɗe nǝ a mǝ Bìt Daa nǝ. Mo jwal a lée ɗeɓang, fuwaat ɗemǝlep mo, ɗe moo mangyit. Mo ɓwoot tuur fur mo shi zaal ɗe mo ɗak mo a shi zinariya. ");
INSERT INTO sur_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Memee ndǝǝn mbii ɗefeer ɗe mo kǝ seen sǝ shin ɗaa shool mǝ zinariya mo pwoovǝl, nenlep Naan ɗe pwoovǝl nǝ mo. Ɗaa shool ɗesǝ nǝ mo gam kǝ tuup Naan ɗe wur kǝ seen ɗeɗǝm ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","Ɓǝ Lu Naan ɗeɗes nǝ gam kǝ ɗyeel mǝ ɗeɗes wur, kǝ iiko wur zak. Baa mee gurum mak ɗel nɗǝǝn Lu Naan ɗeɗes nǝ kas, see aɓwoon ɗe jeel ɗe pwoovǝl mǝ nenlep ɗǝ pwoovǝl nǝ mo gam. ");
INSERT INTO sur_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Ɗangɓe nghan kǝlǝng mee ɗoo ɗeɓal nɗǝǝn Lu Naan ɗeɗes nǝ, nǝ sat nenlep kǝ Naan ɗe pwoovǝl nǝ mo nǝnee, <<Wu dǝm wu ɗoo mbii ɗe ndǝǝn ɗaa shool ɗe pwoovǝl ɗi mǝ tuup Naan nǝ mo nkaa yil ne.>> ");
INSERT INTO sur_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","Ngulep Naan ɗinshee wur dǝm ɗoo mbii ɗe nǝ nɗǝǝn ɗaa shool ɗe wur kǝ nǝ nkaa yil nǝ. Ɗangɓe sǝrep ɗeshwal ɗe mo bish naa, mo pwas nen ɗe mo kǝ fili (alaama) mǝ luwa nkaa sut sǝ, kǝ nen ɗe ɗi mo seyil mmuriin kǝ luwa ne. ");
INSERT INTO sur_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","Ngulep Naan ɗevǝl wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝ nǝ nkaa baahar, ɗangɓe am nǝ cǝǝr ɗee kaa toom kǝ ngu mumuut sǝ. Mɓe ɗe mo kǝ seen ɗe moo tong nɗǝǝn am, mo murap jir. ");
INSERT INTO sur_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","Ngulep Naan ɗekun, wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝ nǝ nkaa gǝnǝ am mo, kǝ tuɓut mo. Am nǝ mo cǝǝr ɗee a toom. ");
INSERT INTO sur_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","Wen kǝlǝng ngulep ɗe wur tap kǝ am mo, wur sat nǝnee, <<Waa a ɗin ndǝret, mbǝ canɗyeel ɗesǝ mo, Waa a ɗeɓang, waa ɗe gyet yam, ɓǝ waa ɗǝ, waa ɗe waa ɗe yaksǝ. ");
INSERT INTO sur_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","Mɓeeɗe gyet mo ɓeer toom kǝ nen fwa mo, kǝ toom nensatpwoo fwa mo zak, <<Mbe waa kǝ shin toom mo shwaa ntiit-ntiit kǝ kwat mo.>> ");
INSERT INTO sur_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","Ɗangɓe nghan kǝlǝng mee ɗoo a peewus mbezuum nǝ sat zak nǝnee, <<Ii, Daa Naan ɗeɓal met jir. Azeen-nzeen, canɗyeel fwa nǝ mo azeen, kǝ mo a ndǝre zak.>> ");
INSERT INTO sur_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","Ngulep Naan ɗefeer, wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝ nǝ, nkaa puus. Ɗangɓe mo cínɓal mpuus nǝ, mbǝkǝ nǝ caan gurum mo ɗe shi wus. ");
INSERT INTO sur_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","Tal kǝ puus nǝ fes ɓaan gurum mo, shiɓal, mbe mo satpwoo ɗebuu nkaa sǝm kǝ Naan, ɗe wur kǝ iiko nkaa jeel nǝ mo. Mbe mo chi tuwap, baa mo kwoop ɗeɗes Naan kas. ");
INSERT INTO sur_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","Ngulep Naan ɗepaat, wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝ nǝ, nkaa pee mǝ mulki mǝ luwa nǝ. Ɗangɓe mulki kǝ luwa nǝ cǝǝr ɗee a peenkoo. Ɓe gurum mo ǝrap liis fur mo mbǝ jeel ɗe mo nkaa shwaa ne. ");
INSERT INTO sur_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","Gurum mo waa satpwoo ɗebuu nkaa Naan, mbǝ shwaajeel ɗe mo nkaa shwaa nǝ, kǝ sǝrap mo mo zak, mɓe jir kǝse, ɓe mo chi tuwap, mbǝ ɗak ɗebish ɗe mo kǝ ten cin mo. ");
INSERT INTO sur_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","Ngulep Naan ɗepeemee, wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝni, nkaa gǝnǝ Yufrates ɗeɗes sǝ, ɓe am ɗe nǝ nɗǝǝn gǝnǝ ɗesǝ nǝ ɗel fii, mbǝkǝ nǝ ɗak ar ɗe mishkoom ɗe mo njì nkoop puus kǝkàa. ");
INSERT INTO sur_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","Ɗangɓe nghan naa riin ɗebish mo kun, ɗe mo kaa nzargook mo sǝ, mo jì put nɗǝǝn pwoo kǝ kus nwòo sǝ, kǝ nɗǝǝn pwoo kǝ luwa sǝ, kǝ nɗǝǝn pwoo kǝ ngusatpwoo Naan mǝ ɗung sǝ. ");
INSERT INTO sur_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","Riin ɗebish ɗesǝ nǝ mo nkaa cin mbǝ aapwoo mo ɗes hakyeng. Mo dǝm pee mishkoom mǝ yil ɗesǝ mo jir, mbǝkǝ mo kyak mo le ɗe ashak mbǝ cin lek parpuus ɗeɗes mǝ Naan ɗeɓal met jir sǝ. ");
INSERT INTO sur_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","<<Wu naa nghan njì a kaa wat sǝ! Nen ɗe mo tong shi gongpee, ɗe mo kǝ lée fur mo a lǝlep, mbǝkǝ taji mo put ngum, kǝ mo kat naashwoop ɗe kas, ɓe nen mǝnǝ mo nkat ɗeret.>> ");
INSERT INTO sur_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","Riin ɗebish ɗesǝ nǝ mo kyak mishkoom mǝ yil ɗesǝ mo le ashak, mmee mɓeɗǝ moo pet nǝ shi lespwoo mǝ nen Yahudi mo a Armageddon. ");
INSERT INTO sur_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","Ngulep ɗepwoovǝl, wur dǝm ɗoo mbǝɗe nǝ nɗǝǝn ɗaa ɗe wur kǝnǝ nkaa kut. Ɗang mee ɗoo ɗeɓal jì put nɗǝǝn Lu kǝ Naan ɗǝɗes, a peetong mǝ mulki nǝ nǝnee, <<Nǝ kǝ shin!>> ");
INSERT INTO sur_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","Kǝzak, pee nǝ mǝlep, nluupet, kǝ pee nǝ gwan. Yil nǝ yoon shiɓal, ɗe baa yil kǝ kyam yoon kaa mǝnǝ sǝ kas, pǝgyet ɗe gurum mo yaa tong ɗe ndǝǝn yil ne. ");
INSERT INTO sur_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","Bǝrnǝn ɗeɗes nǝ ɓàk kun, kǝ kaar yil ɗe ndǝǝn yil nǝ mo jir, mo shirip. Naan wur pan Babilon ɗeɗes sǝ, mbe wur cin kap ɗe nǝ gam kǝ am anab (filip) ɗe nǝ a mǝ tuup wur nwura shwaa. ");
INSERT INTO sur_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","Koo rep laayil ɗeɗangyi ɗe am neer nǝ cǝǝrkaat, ɓe nǝ su dǝm loom, kǝ ɗengjwak mo su dǝm laam zak. ");
INSERT INTO sur_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","Ɗaar ɗǝnan-nan mo put nɗengnaan, mbe mo sham taa nkaa gurum mo, koo a ɗaar ɗeɗangyi ɓe toon kǝ nǝ wul kaa mǝ bufu kǝǝn sǝ. Gurum mo satpwoo ɗebuu nkaa Naan, mbǝ shwal ɗe moo shwaa nǝ, mbǝ sham kǝ ɗaar ɗesǝ nǝ mo, kǝ zak, mɓeeɗe jeel nǝ fes shwal zam hakyeng. ");
INSERT INTO sur_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","Memee mɓut nenlep Naan ɗe pwoovǝl sǝ mo ɗe mo kǝ ɗaa mo pwoovǝl sǝ wur jì mpee nghan ɗǝ, ɓe wur sat nghan nǝnee, <<A jì, ɓe nghan nkám nwaa, kar ɗe mo can mmat ngaa ɗeɗes nǝ ɗǝ war kǝ tong pǝkom am mo. ");
INSERT INTO sur_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","Mishkoom ɗe mǝ yil ɗesǝ mo cin ngaa ashak kǝ war, kǝ gurum ɗe nɗǝǝn yil ɗesǝ mo fes yuur kǝ am anab mǝ ngaa war nǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","Ɓe la lep Naan mang an seet kǝ nǝ ɓut Riin, sǝ dǝm a naaryil, a npee ɗe baa am ɗe kas. A naaryil nǝ, ɓe nghan naa mee mat kǝ tong nkaa mee luwayil ɗe nǝ a naat. Mo ran sǝm ɗebish mo, ɗe mo satpwoo ɗebuu nkaa Naan. Luwayil ɗesǝ nǝ kǝ káa mo pwoovǝl, kǝ soom mo kaapaat. ");
INSERT INTO sur_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","Mat nǝ war tap jwal a lée ɗe mo pan a naat mo ɗe mo ret naa zam, war kǝ tap ɗak mo a shi mbǝɗe mo ɗak mo a shi zinariya kǝ ngǝk ɗeapwus mo, kǝ mbii jwat ɗe rǝret mo, kaa mbǝɗe moo pet nǝ a peyal mo sǝ. Mat nǝ war kǝ mee ɗekwat nsar war, ɗe mo ɗak a shi zinariya, ɗe nǝ gam kǝ mbǝ ɗebish mo, ɗe mo a mǝ ar tong war ɗebish mǝ ngaa. ");
INSERT INTO sur_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","Sǝm ɗǝ Mo ran nkaa pǝkeen war nǝ a bii ɗe mo manshi nǝ kas. BABILON ƊEƊES, NƏƏN MAT nGAA MO, KƏ mBƏ ƊEBISH ƊE MO nƊƏƏN YIL NƏ JIR. ");
INSERT INTO sur_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","Wen naa mat nǝ war kǝ yuur shi toom nen Naan ɗe ɓang mo, Toom nen ɗe gyet mo shin langtǝng kǝ Jesu. Kaaɗe naa war, ɓe nǝ fes aapwoo nghan zam. ");
INSERT INTO sur_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","Ngulep Naan wur tal pǝ nghan nǝnee, <<A mii aapwoo nwaa yii? Wen woo shii mbǝ ɗe baa a manshi nǝ kas kaa mat nǝ kǝ luwayil ɗe war kǝ lang kaa nǝ ɗe nǝ kǝ káa mo pwoovǝl, kǝ soom mo kaapaat sǝ. ");
INSERT INTO sur_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","Luwayil ɗe a naa sǝ, ɗǝ gyet yam ɓe nǝ di, mɓe yaksǝ, baa nǝ kuɗi kas, nǝn yool kàa put a nɗǝǝn tuun ɗe baa nii peeɗar kas sǝ, mbǝkǝ nǝ dǝm ɗe a npeeɗe mo ntu nǝ ɗe vit. Nen ɗe mo ndǝǝn yil ɗese, ɗe pǝgyet ɗe nshee kǝ yil nǝ, ɓe baa mo ran sǝm mo mo nɗǝǝn buthaal mǝ seen kas. Nin aapwoo mo mbǝ naa luwayil ɗesǝ nǝ, mbǝɗe gyet nǝ ɗi kǝ seen, mɓe nǝ kǝ muut, jir kǝsǝ, ɓe nǝ nwaa baaji put kǝ seen zak. ");
INSERT INTO sur_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","<<Ɗǝsǝ kǝ rǝɓet a pǝtuup ɗe kǝ seen manshi bii mo. Káa ɗe pwoovǝl nǝ mo, mo a zuul mo pwoovǝl, ɗe mat nǝ war tong nkaa mo sǝ. ");
INSERT INTO sur_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","Mo a mishkom mo pwoovǝl zak. Mo kǝ sham kǝ paat mo ndǝǝn mulki mo, mɓe mǝndong ɗe nkaa se mulki yaksǝ. Baa ɗevǝl nǝ kǝ jì wul kas, mɓe katɗang wur njì wul, ɓe wur nse mulki nǝ a mbǝ rep pee lee ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","Luwayil ɗe ɗi nǝ ɗi, yaksǝ baa nǝ kuɗi kas, a nǝ a mishkoom ɗepwookun nǝ. Mɓe nǝ a nɗǝǝn soon mishkoom ɗe pwoovǝl sǝ mo. Ɓe nǝ nkaa dǝm a pee ɗe mo tǝkook kǝ nǝ. ");
INSERT INTO sur_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","<<Soom ɗekaapaat ɗe a naa sǝ mo, mo a mishkoom mo kaapaat, ɗe baa mo kǝcin mulki mo kas aku. Ɓe mbǝ awa mǝndong, ɓe mo ncin iiko mo kaa mishkoom mo sǝ, kǝ mo cin mulki ɗe ashak kǝ luwayil ne. ");
INSERT INTO sur_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","Mishkoom ɗekaapaat sǝ mo, pan mo nǝ mo a ɗemǝndong, mo ncin ɓal mo, kǝ iiko mo nluwayil ne. ");
INSERT INTO sur_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","Mo ncìn lek kǝ Laatǝm nǝ, mɓe Laatǝm nǝ wur nse koorong nkaa mo, mbǝɗe a wur a Daa ndaa mo, Mishkoom kǝ mishkoom mo, ashak kǝ wur, ɓe nen ɗe wur kǝ ten pǝrep, kǝ bǝlǝp mo, mo nse koorong zak.>> ");
INSERT INTO sur_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","Ɗangɓǝ ngulepnaan wur sat nghan nǝnee, <<Am ɗe a naa sǝ, a mpeeɗǝ mat ngaa sǝ war tong ɗǝ, gurum mo, kuur gurum mo shinǝ-shinǝ, kǝ yil mo shinǝ-shinǝ, kǝ liispwoo mo shinǝ-shinǝ zak. ");
INSERT INTO sur_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","Soom ɗe kaapaat ɗe a naa sǝ mo, kǝ luwayil nǝ, mo mɓǝ cii mat ngaa nǝ. Mo mbǝ tǝkook kǝ mbii ɗǝ war kǝ nǝ mo jir, mbǝ mo yit war ɗee ngum, mo nse luwa war, kǝ mo ncaan war shi wus. ");
INSERT INTO sur_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","A Naan wur kǝ ten le mǝnǝ nɗǝǝn pǝtuup mo, mbǝkǝ mo cin mbǝɗe nǝ gam ɗyen wur ɗǝ, kaaɗǝ mo ɓalkaa mo mo, mbǝkǝ mo shínɓal mo mo, mbǝ se mulki kǝ luwayil nǝ, mbe parɗi pwoonaan nǝ gam. ");
INSERT INTO sur_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","Mat ɗe nwaa a naa nǝ, a yil ɗeɗes ɗe nǝ kǝ cin mulki, nkaa mishkoom mǝ yil nǝ mo.>> ");
INSERT INTO sur_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","Aɓwoon ɗese, ɓǝ nghan naa mee ngulepnaan npoo kǝ sham nɗǝǝn ɗengnaan. Ngulepnaan ɗesǝ wur kǝ iiko ɗeɗes zam. Mɓǝ peeɓang mǝ iiko wur nǝ ɓang yil nǝ kǝdǝng. ");
INSERT INTO sur_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","Shi ɗoo ɗeɗes ɓe wur le or: <<Ɓal fi kǝ kyes! Ɓal fi kǝ kyes! Yil nBabilon ɗeɗes War kǝ ɗee a tulu riin ɗebish mo War ɗee a peetong mǝ koo a riin ɗebish ɗeɗangyii, War ɗee a peetong mǝ koo a mbǝ ɗerap, kǝ nyer ɗebish. Kǝ koo a luwa ɗeɗang ɗe nyakkap. ");
INSERT INTO sur_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","Mɓeeɗe gyet gurum nyil mo shini-shini, gyet mo shwaa a am anab mǝ ngaa ashak kǝ war. Mishkoom mǝ yil ɗǝsǝ mo gyet mo cin ngaa kǝ war Kǝ nennwer ɗe mǝ yil ɗesǝ mo, moo long a shi lǝɓet mbǝ bii kǝ kat war ɗe mǝ yil ɗese, ɗe nǝ met mǝ sat.>> ");
INSERT INTO sur_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","Ɗangɓe wen kǝlǝng mee ɗoo npoo ɗe nǝ put nɗǝǝn ɗengnaan, nǝ sat nǝnee, <<Wun nen fǝn mo, wu put aku ndǝǝn war, mɓekǝ taji mo cin kwat nwun ashak kǝ war mbǝ shikbish war nǝ mo kas, Mɓekǝ taji wu lap memee nɗǝǝn jeel war nǝ mo kas. ");
INSERT INTO sur_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","Mbǝɗǝ shikbish war nǝ mo kǝ ak kàa wul a ɗengnaan, Naan kǝ yee ɗakɗebish war mo. ");
INSERT INTO sur_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","Wu kwat war nciit kǝ mbii ɗǝ war kǝ cin wun, wu kwat war yitvǝl, mbǝ mbii ɗe gyet war kǝ cin mo nwun. Wu ɗoo mo yitvǝl, kaaɗe gyet war kǝ kam nwun ɗin ɗekwat war sǝ. ");
INSERT INTO sur_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","Wu yit kǝ kwat ɗe nǝ a mǝ kar kǝ jeel ɗe war lap nǝ, nǝ ɗee nciit-nciit kǝ ram kǝ long ɗe gyet war shin nkáa war, mɓeeɗe war nkaa ɗyeep kaa nnee <wen a mishkoom ɗe mat. baa wen a matkaa, baa wen cam wal maap kas.> ");
INSERT INTO sur_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","Mɓemǝnǝ ɓe, jeel war nǝ mo njì taa nkaa war ndi mman, mɓeeɗi a parpuus mǝndong, ɓe muut kǝ maap, kǝ neen, mo ntaa nkaa war. Ɗangɓe wus ncaan war, mbǝɗe Daa Naan ɗe wur ntokɗyeel nwar, wur kǝ iiko ɗes. ");
INSERT INTO sur_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","<<Katɗang mishkoom mǝ ɓǝm-yil ɗesǝ mo, ɗe gyet mo cin ngaa ashak kǝ war, ɗe gyet mo se pak long war nǝ mo ashak kǝ war, ɓe mo nnaa ɗyeel ɗe nǝ caan war, ɓe mo nwal kǝ maap mbǝ war. ");
INSERT INTO sur_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","Mbee jeel ɗeɗes ɗe war shwaa nǝ. Ɓe kǝǝrmuut nyaa mo, mbǝ mo nɗar a jong-jong kǝ moo wal ɗǝ, kǝ mo nsat nǝnee, <<Jeel! Jeel mɓee wii yil ɗeɗes Babilon! Yil ɗe gyet wii kǝ iiko ɗes, nɗǝǝn awa mǝndong, ɓe kyes fii nǝ jì wul!>> ");
INSERT INTO sur_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","<<Nennwer ɗe mo ɓǝm-yil nǝ mo, mo nwal kǝ maap nkaa war, mbǝɗe baa mee ngwe kuɗi, nseet lée mo mo kas. ");
INSERT INTO sur_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","Lée nwar ɗe mo a zinariya mo, kǝ mǝ azurfa mo, kǝ mǝ nghǝk ɗeret ɗe moo mǝlep nyilaknyilak, kǝ nlǝr ɗe rǝret mo shini-shini, kǝ nlǝr ɗe pan a naat mo, kǝ shiyeep ɗeret mo, kǝ mbii ɗe mo ɗak mo a shi oos nǝ mo, kǝ shiyeep ɗekǝrǝm mo, kǝ mbǝɗe mo ɗak mo a shi shool ɗeret mo, kǝ nghǝk ɗeret ɗe mǝ ɗyiklu mo, ");
INSERT INTO sur_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","kǝ bii ɗe kǝ toos shangshang, kaa sinamon, kǝ le shǝta, meer, kǝ frankisens, kǝ mwoor ɗe gurum kǝ caan, mbǝkǝ wur kǝlǝng toos ɗeshang nǝ ɗe sǝ, kǝ mǝ am anab, kǝ mǝ mwoor paat, kǝ mǝ áas ɗeret mo, mǝ alkama, kǝ mǝ randong mo, kǝ tǝm mo, kǝ mǝ bǝring mo, kǝ mǝ keke bǝring, kǝ gurum mo ɗi mo sǝrep mo kaa kǝrem mo sǝ>> ");
INSERT INTO sur_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","Nennwer nǝ mo nsat nwar nǝnee, <<Jir mbii ɗi rǝret ɗe ɗi yii leyit nkaa mo, moo ɗel dǝm jee. Long fii mo jir, kǝ rak fii nǝ mo jir, mo nloom. Baa wii kuɗi yii kat mo ɗi zak kas.>> ");
INSERT INTO sur_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","Nennwer ɗe mo seet kǝ mbii ɗesǝ mo, ɗe mo kat long pǝ war di, mo nɗar jong-jong, kǝ kǝǝrmuut fes yaa mo, mbǝ shwaajeel ɗe war nkaa shwaa nǝ mo nwal kǝ maap. ");
INSERT INTO sur_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","Har mo nfwo ruruu nǝnee, <<Jeel fii, jeel fii, wii yil ɗǝɗes, gyet yam, ɓe wii yii jwal a lee mulki ɗi rǝret mo ɗetap piyaa mo, kǝ ɗetap naat juwal mo. Ɗi mo mǝlep shi zinariya, kǝ shi nghǝk ɗekǝrǝm ɗi mo, kǝ lilliu. ");
INSERT INTO sur_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","nƊǝǝn awa mǝndong ɓejee, ɓǝ long fii ɗeɗes sǝ mo ɗee a ɗebuu!> Jir nentung tii am mo, kǝ gurum ɗe moo ghǝr mo ntii nǝ mo, kǝ nen ɗe moo kat mbii teer mo mo a nɗǝǝn baahar mo, das ɗesǝ mo jir, mo nɗar jong-jong, kǝ war. ");
INSERT INTO sur_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","Katɗang mo nnaa ɗyeel mǝ caan war nǝ kàa, ɓe mo nfwo or shiɓal nǝnee, <Baa mo cam kat mee yil ɗeɗes kaa yil sǝ kas.> ");
INSERT INTO sur_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","Mo kok yil le nkaa káa mo mo, ashak kǝ wal, kǝ maap nǝnee, <<Jeel fii! Jeel fii, wii yil ɗeɗes, Gyet yam ɓe nen ɗe mo kǝ tii mo nkaa baahar, moo kat long a mbǝ long fii, mɓe ndǝǝn awa mǝndong, ɓe wii ɗee a ɗelǝloom jee!> ");
INSERT INTO sur_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","Wii ɗengnaan, yi cin retnyit, mbǝ mbii ɗe nǝ kat yil ɗesǝ war. Wu cin retnyit, wun nen Naan mo, kǝ wun jeplep mo, kǝ nensatpwoo Naan mo, mɓeeɗe Naan wur canɗyeel nwar, mɓee mbii ɗe gyet war kǝcin mo nwun.>> ");
INSERT INTO sur_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","Ɗangɓe mee ngulep Naan ɗeɓal, wur mang mee nghǝk ɗeɗes kaa fin ɗyees ɗak sǝ, wur vwet nǝ nɗǝǝn am baahar, kǝ wur sat nǝnee, <<Mo mɓwet Babilon yil ɗeɗes sǝ a shiɓal aasǝ zak, baa mo nkuɗi kǝ naa war ɗe zak kas. ");
INSERT INTO sur_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","Baa mo mbaa kǝlǝng wal kǝ ndeng-ndeng, kǝ ɗoo nenkook mo, kǝ wal mɓel, kǝ wal nfeer mo nɗǝǝn wii Babilon kas. Baa mo nwaa kat mee ngucìn ɗak shi sar, mǝ koo a kaan ɗak ɗeɗangyi nɗǝǝn wa kas. Baa mo waa baa kǝlǝng wal nfin ɗyees ɗakmo nɗǝǝn wii kas. ");
INSERT INTO sur_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","Baa mee wus ngyem nwaa baa ɓangpee ɗi nɗǝǝn wii kas. Baa mo waa baa kǝlǝng mee ɗoo mǝshpwoo kǝ matpoo nɗǝǝn wii kas. Gyet yam, ɓe nennwer fii nǝ mo, a nen ɗǝnan-nan mǝ yil nǝ mo. Gyet a shi mulgut mǝ soot fii, ɓe yii le gurum ɗe mo ndǝǝn yil nǝ mo jir, mo taa mer ar ɗi buu. ");
INSERT INTO sur_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","Gyet a nɗǝǝn Babilon, ɓe mo kat toom nensatpwoo Naan mo, kǝ toom mǝ nen Naan mo, kǝ toom mǝ gurum ɗe gyet mo saa mo jir nɗǝǝn ɓǝm-yil nǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","Aɓwoon ɗese, ɓe nghan kǝlǝng mee ɗoo ɗe nǝ kaa ɗoo ɗeɗes, mǝ gurum mo ɗeɗes sǝ nɗǝǝn ɗengnaan. Ɗoo nǝ mo sat nǝnee, << kwoop Naan! Mɓeeɗe ɓam, kǝ ram, kǝ iiko mo a mǝ Daa Naan fun. ");
INSERT INTO sur_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","Mɓeeɗe canɗyeel wur nǝ azeen, kǝ nǝ a ndǝret. Wur kǝ canɗyeel ɗebish, mmat ngaa sǝ. Ɗe gyet war tǝkook yil nǝ shi ngaa war sǝ. Wur baa kwat war, nciit kǝ toom kǝ kǝrem wur ɗe gyet war twe mo.>> ");
INSERT INTO sur_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Kǝzak, mo waa baa fwo or shiɓal nǝnee, << kwoop Naan! Ɗyeel ɗe mo caan war nǝ nkàa ɗeng ngaa-ngaa.>> ");
INSERT INTO sur_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","Nennan ɗe laarvǝl baafeer sǝ mo, kǝ mbii ɗefeer ɗe mo kǝ seen sǝ mo, mo kurum nyil, kǝ mo seyil ɗe nNaan, ɗe wur tong a peetong mǝ mulki. Mo seyil nwur, mo sat nǝnee, <<Nǝ aa sǝ! Kwoop Naan!>> ");
INSERT INTO sur_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","Ɗangɓe mee ɗoo jì put ɗe nɗǝǝn peetong mǝ mulki nǝ nǝnee, <<Kwoop Naan fun, wun kǝrem wur mo, wun ɗe wuu kǝr wur, nen ɗeɗyeen mo, kǝ nen ɗenan mo jir.>> ");
INSERT INTO sur_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","Ɗangɓe wen kǝleng mee mbii kaa ɗoo kǝ gurum mo ɗes sǝ, nǝn nciit kǝ wal kǝ am ɗǝɗes, ɗe nii sham ndang, kǝ nǝ wal kaa nluu ɗe nii pet sǝ. Ɗoo nǝ mo sat nǝnee, <<Kwoop Naan! Mɓeeɗe Daa Naan fun ɗeɓal jir, wur se mulki. ");
INSERT INTO sur_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","Wu yit kǝ mǝ cin retnyit shi pǝtuup ɗeɓang, wu yit kǝ mǝ shin ɗeɗes nwur. Mɓeeɗe pee nǝ wul, ɗe Laatǝm kǝ Naan wur ncìnɗyik. Matpoo nǝ war kǝ ɗak seet mbǝ ɗyik nǝ. ");
INSERT INTO sur_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","Mo shin lée ɗepiyaa peng-peng mo nwar, mɓekǝ war lep ɗi.>> (Lée ɗepiyaa peng-peng nǝ mo, moo kám a ɗak ɗeret ɗe nen Naan ɗe pang mo kǝ ten cin.) ");
INSERT INTO sur_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Ɗangɓe ngulep Naan wur sat nghan nǝnee, <<A ran ɗesǝ. Ɗeret nkaa nen ɗe mo pǝrep mo mbǝ se serǝɓet mǝ Laatǝm nǝ.>> Ngulep Naan wur waa baa sat nghan nǝnee, <<Ɗese nǝ a pwoo Naan azeen-nzeen.>> ");
INSERT INTO sur_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","Wen saam nyil ntoom wur, mbǝkǝ nghan seyil ɗi nwur, mbǝ wur sat nghan nǝnee, <<Taji a cin mǝnǝ kas, nghan a kǝrem Naan kaa waa sǝ, <<kǝ koor ɗyemnǝǝn fun ɗe mo lap langteng mǝ Jesu sǝ. A seyil a nNaan. Pwoo ɗe Jesu wur woo nǝ, a nǝ a káa riin nensatpwoo Naan mo.>> ");
INSERT INTO sur_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","Wen naa Ɗengnaan a wuwang, ɓe mee bǝring ɗepiyaa ɗe nii ɗar a kyen fen, ɗe sǝm kǝ gwar ɗe wur lang bǝring ɗepiyaa nǝ a Ngwe ɗe ndǝre, kǝ Nguzeen. Wur canɗyeel a ndǝǝn ar ɗe ndǝre, kǝ cin lek zak. ");
INSERT INTO sur_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Yit wur mo a kaa aawus sǝ, kǝ wur kǝ mbiikáa mǝ mulki mo ɗes nkaa káa wur zak. Wur kǝ mee sǝm ɗe nǝ a rǝran nkaa shin, ɗe baa mee gurum mak man nǝ kas, see a wur shikáa wur ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Wur lep lée ɗe sǝɓen ɗe mo kǝ lep ndǝǝn toom, kǝ sǝm wur nǝ a Pwoo Naan. ");
INSERT INTO sur_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Nenlek ɗe mo ndǝǝn ɗengnaan, moo mwaan nɗang wur nkaa bǝring ɗepiyaa-piyaa mo, kǝ mo tap lep a lee lilin ɗepiyaa kǝ ɗeɓang. ");
INSERT INTO sur_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Mee kwai ɗesese jì put mpwoo wur. A shi kwai ɗesǝ ɓe wur nsaa gurum ɗe mo nyil nǝ mo shinǝ-shinǝ, <<Wur nse mulki nkaa mo a shi ɗul shool.>> Wur ntǝreng am anab nǝ a peetǝreng anab ɗe nǝ a mǝ tuup Naan ɗeɓal met jir. ");
INSERT INTO sur_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","Nkaa nlǝr wur, kǝ nkaa cìi wur, ɓe sǝm ɗe nǝ sat nǝnee, <<MISHKOOM MƏ MISHKOOM MO, DAA MƏ DAA MO.>> ");
INSERT INTO sur_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","Ɓe nghan naa mee ngulep Naan wur ɗar nkaa puus, wur pǝrep nyer ɗe moo yool ncáap shi ɗoo ɗeɗes, nǝnee, <<Wu jì, wu kaat ashak jir, mbǝ gomteer ɗeɗes mǝ Naan. ");
INSERT INTO sur_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","Mɓekǝ wuu se luwa mishkoom mo ɗi, kǝ luwa ɗenan-nan mǝ nenlek mo, kǝ luwa nen ɗǝnan-nan mo, kǝ luwa mǝ bǝring mo, kǝ mǝ nenlang bǝring nǝ mo, kǝ luwa gurum mo jir, mǝ jeplu mo, kǝ mǝ kǝrem mo, ɗeɗyeen, kǝ ɗenan.>> ");
INSERT INTO sur_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","Wen naa luwayil sǝ, kǝ mishkoom mǝ yil nǝ mo, kǝ nenlek mo mo, mo kuur ashak, mbǝkǝ mo cin lek ɗi kǝ ngulang bǝring ɗepiyaa sǝ, kǝ nenlek wur mo. ");
INSERT INTO sur_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","Mbǝ mo yaa luwayil nǝ ashak kǝ ngusatpwoo Naan mǝ ɗung sǝ, ɗe gyet wur cin mbii aapwoo, kǝ mbiinaaman mo a pee mǝ luwayil nǝ. A shi mbii aapwoo ɗesǝ mo, ɓe gyet wur num nen ɗe mo lap mbiinaaman mǝ luwayil nǝ, kǝ gyet mo seyil muriin wur zak. Mo vwet mo weet mmeen nɗǝǝn aawus ɗe nii lap a shi fwat mǝ bintǝka. ");
INSERT INTO sur_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","Mo twe koor nǝ mo shi kwai ɗe nǝ jì put pwoo kǝ ngulang bǝring ɗepiyaa sǝ. Nyer mo jir, mo se luwa nǝ, mbǝ nǝ mak mo. ");
INSERT INTO sur_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","Ɗangɓe Wen naa mee ngulep Naan kǝ sham put ndǝǝn ɗengnaan, wur kǝ biwangpee mǝ wang tuun ɗejurum, ɗe baa nii peeɗar kas sǝ, kǝ wur kǝ mee tǝzek ɗeɗes nsar wur. ");
INSERT INTO sur_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","Wur yaa nwòo sǝ, nwòo ɗe pǝgyet nǝ ɗi yam-yam sǝ. A nwòo nǝ wur a ngujwan, ko shetan, Ngulep Naan wur ɓwoot ngujwaan mbǝ ɓit ngal mǝndong. ");
INSERT INTO sur_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","Ngulep Naan nǝ vwet nwòo nǝ sham nɗǝǝn tuun ɗe baa nii peeɗar kas sǝ. Aɓwoon mǝnǝ, ɓe wur shoot pwoo tuun nǝ, kǝ wur lus nǝ, mbǝkǝ taji ngujwaan wur katpee mbǝ gwam gurum ɗe nɗǝǝn yil nǝ mo ɗi zak kas, see aɓwoon ɓit ngal mǝndong akuɗang. Aɓwoon mǝnǝ, ɓe mo mɓwet ngujwaan nǝ, mbǝ reppee lee ɗak. ");
INSERT INTO sur_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Ɗangɓe wen naa mbii tong mǝ mulki mo, kǝ zak, nen ɗe mo kǝ tong nkaa mbiitong mulki mo, moo shin ɓal mo bǝ tok ɗyeel. Wen naa seen nen ɗe gyet mo saa káa mo, mbǝɗe gyet mo shin camkat mbǝ Jesu, kǝ mbǝ pwoo Naan. Baa gyet moo seyil luwayil nǝ koo mǝ riin wur kas, kǝ baa gyet mo lap mbiinaaman mǝ luwayil nǝ nkaa pǝkyeen mo mo, koo nkaa sar mo mo kas. Mo baa shin seen mo, mbe mo se mulki ashak kǝ Kristi mbǝ ɓit duɓu mǝndong. ");
INSERT INTO sur_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","Koor nen ɗǝ mumurap nǝ mo nkat seen kas, see mɓwoon ɓit mo ngal mǝndong akuɗang. A ɗesǝ nǝ a yool a pee muut ɗe nshee. ");
INSERT INTO sur_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","Ɗǝret kǝ ɗǝɓang a nen ɗe mo mak yool a peemúut ɗinshee ɗiisi nǝ. Baa muut ɗevǝl mak katɓal nkaa mo kas, mɓǝ mo nɗe a pris mǝ Naan mo, kǝ mǝ Kristi, mbǝ mo nse mulki ashak kǝ wur mbǝ ɓit mo ngal mǝndong. ");
INSERT INTO sur_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","Aɓwoon ɗe ɓit ngal mǝndong nǝ mo ɗel, ɓe mo nfwen shetan nɗǝǝn lushoot ɗe mo ɓwoot wur ɗǝ. ");
INSERT INTO sur_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","Ɓe ngujwaan wur nput dǝm mbǝkǝ wur gwam gurum ɗe mo ndǝǝn yil nǝ mo ɗǝ, nɗǝǝn kwang ɗefeer mǝ yil nǝ. Yil ɗiisi nǝ mo a Gok, kǝ Magok, wur cak mo le ashak mbǝ lek. Ɗuu mo nǝ ɗee a kaa ɗyees mpwoo am baahar sǝ. ");
INSERT INTO sur_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","Mo mpǝǝr nkaa yil nǝ jir, mbǝ mo ndǝm neer mpeeɗǝ nen Naan moo kuur ɗǝ, kǝ yil ɗe wur wal nnǝ. Ɗangɓǝ wus ntong a ɗengnaan sham se mo. ");
INSERT INTO sur_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","Ɗangɓǝ ngujwaan ɗe gyet wur gwam mo, mo nvwet wur nɗǝǝn aawus ɗe nii lap a shi fwat mǝ bindǝga, nɓeeɗe luwayil nǝ kǝ ngusatpwoo Naan mǝ ɗung sǝ mo. Mo nshwaajeel a peemǝnǝ mpar kǝ puus, mbǝ ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","Ɗangɓǝ wen naa mee peetong mǝ mulki ɗeɗes a piyaa, gwar ɗe wur tong nkaa peetong mǝ mulki ɗiisi nǝ, ɓe yil kǝ ɗengnaan mo loom ciir nyit wur, baa mee peeɗi bǝ kas. ");
INSERT INTO sur_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","Wen naa nen mumuut, ɗenan, kǝ ɗeɗyeen mo kǝ ɗar toom mulki wur, ɓǝ bǝǝt-haal mo wang. Ɓǝ ɓǝǝt-haal pwoo wang ɗe nǝ a Ɓǝǝt-haal mǝ seen. Mo ntokɗyeel nen mumuut nǝ mo nkaa mbii ɗi moo cin kaaɗe mo kǝ ran ɗin ɓǝǝt haal nǝ mo sǝ. Mo ran mo nkaa ɗak ɗe gyet nen mumuut nǝ mo kǝ cin ɓe mo kutɗi mmeen. ");
INSERT INTO sur_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","Bahar war shwat nen mumuut ɗe mo nɗǝǝn war, kǝ muut mǝ peemúut mo shwat nen mumuut ɗe mo nɗǝǝn mo, koo a ngwe ɗeɗang ye, mo tokɗyeel mo nciit-nciit kǝ mbii ɗe moo kǝ ten cin. ");
INSERT INTO sur_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","Mɓǝ mo vwet muut kǝ peemúut nɗǝǝn aawus. Aawus ɗesǝ nǝ a peemúut ɗevǝl mmǝnǝ. ");
INSERT INTO sur_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","Jir ngweɗe baa sǝm wur nǝ a rǝran nɗǝǝn bǝǝthaal mǝ seen kas, ɓe mo kǝ vwet gwar mǝnǝ nɗǝǝn aawus ne. ");
INSERT INTO sur_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Wen naa ɗengnaan ɗepwoo kǝ ɓǝm-yil ɗepwoo, mbǝɗe ɗengnaan ɗinshee, kǝ ɓǝm-yil ɗinshee nǝ, mo kuɗi kas, kǝ baa mee baahar kuɗi kas. ");
INSERT INTO sur_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","Wen naa yil ɗeɓang, Jerusalem ɗepwoo, nǝ sham put ndǝǝn ɗengnaan pee Naan ɗǝ. Mo tap ɗak war a kaa matpoo ɗe war lep lée rǝret mbǝ kaat kǝ mish war sǝ. ");
INSERT INTO sur_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","Ɗangɓǝ nghan kǝlǝng mee ɗoo put a peetong mǝ mulki nǝ, nǝ sat nǝnee, <<Wu naa! Peetong Naan nǝ ashak kǝ gurum mo, wur ntong ashak kǝ mo. Mo mbǝ ɗee a nen wur mo, kǝ Naan wur shikáa fǝn ntong ashak kǝ mo, nwur nɗee a Naan mo zak. ");
INSERT INTO sur_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","Wur mbǝ mpwes koo a yitmwaan ɗeɗangyi nɗǝǝn yit mo mo. Baa mee muut koo maap, koo wal, koo shwal kuɗi kas, mbǝɗe mbǝ deyam mo kǝ ɗel seet.>> ");
INSERT INTO sur_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","Wur ɗe dǝ wur kǝ tong nkaa peetong mǝ mulki nǝ wur sat nǝnee, <<Wen nkaa ɗak koo meye, a ɗepwoo.>> Ɗangɓe wur sat nǝnee, <<A ran mbii ɗesǝ, mbǝɗe mo mak kǝ gurum shinzeen, kǝ mo azeen zak.>> ");
INSERT INTO sur_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","Wur sat nghan nǝnee, <<Nǝ kǝ chin. A an a Alfa nǝ kǝ Omega, ɗinshee nǝ, kǝ kyes nǝ. Ngwe ɗe am tu wur, an bǝ shin am nwur nzuum, nɗǝǝn tuɓut mǝ am seen sǝ. ");
INSERT INTO sur_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","Nen ɗǝ mo se koorong, ɓǝ mo nse kop mbii ɗesǝ mo jir. An nɗee a Naan mo, kǝ mo ɗee a jepfen mo. ");
INSERT INTO sur_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","Mbǝ nenkǝrmuut mo, kǝ nencii cinzeen mo, kǝ nenɗebish mo, kǝ nentukáa mo, kǝ nenngaa mo, kǝ soot mo, kǝ nenseyil nkùm mo, kǝ nencìn ɗung mo, mo nfwo mo nɗǝǝn aawus ɗe nii lap wus a shi fwat mǝ bintǝka. Ɗese nǝ a muut ɗevǝl mmǝne.>> ");
INSERT INTO sur_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","Memee mɓut nenlepnaan ɗe pwoovǝl sǝ mo, ɗe mo kǝ ɗaa mo pwoovǝl, gam kǝ jeel ɗe pwoovǝl mǝ kyes nǝ sǝ mo, jì sat nghan nǝnee, <<A jì, kǝ nghan kám matpoo nǝ ɗi ngha, ɗǝ war a mat nlaatǝm nǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","Ɓǝ wur mang an seet kǝ nǝ ɗǝǝn Riin shin kaa aɗǝng zuul ɗǝdes ɗang wurang, kǝ wur kam pee yil ɗǝɓang nghan. Jerusalem nǝ tong aɗeng sham put pǝ Naan ɗi. ");
INSERT INTO sur_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","Nǝ ɓangpee shi ram nNaan, kǝ ɓangpee nǝ a kaa mǝ jwak ɗekǝrǝm mo sǝ, kaa ɓangpee mǝ jaspa sǝ. Nǝ ɓangpee kyel-kyel! ");
INSERT INTO sur_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","Nǝ kǝ mee kok ɗǝɗes, ɗewurang, ɗe nǝ kǝ polu mo kaapaat baavǝl. Nenlepnaan mo kaapaat baavǝl, moo ɗar mpolu ɗesǝ mo, Mo ran sǝm soon ɗekaapaat baavǝl mǝ nen Izrel mo nkaa polu ɗekaapaat baavǝl ɗesǝ nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","Dǝ polu mo kun nsar puus kaa, polu mo kun nkwang ndeel, polu mo kun nkwang ngyeen, kǝ mo kun nǝ sarpuus sham. ");
INSERT INTO sur_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","Kok mǝ yil nǝ kǝ kuk mo kaapaat baavǝl. Mo ran sǝm jeplep ɗǝ kaapaat baavǝl Laatǝm nǝ mo nkaa mo. ");
INSERT INTO sur_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","Ngulepnaan ɗe wur leshap kǝ nghan, wur kǝ mbiikám pee, ɗe mo ɗak nǝ a shi zinariya, mbǝkǝ wur kám yil nǝ ɗǝ, kǝ polu nǝ mo, kǝ kok nǝ mo. ");
INSERT INTO sur_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","Shwàl nyil nǝ kǝ kaam nǝ, mo a nciit-nciit. Ngulepnaan nǝ wur kam yil nǝ, bǝ wur kat nǝ wul meel ngal kaapaat nɗǝǝn sǝɓen nyil nǝ, kǝ kaam nǝ, kǝ wurang nǝ nciit-nciit. ");
INSERT INTO sur_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","Ngulepnaan nǝ wur waa kám kaam kok nǝ, ɓe nǝ a shii kambil mǝndong kǝ laarfeer baafeer ntoon kǝ nǝǝr nǝ. ");
INSERT INTO sur_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","Mo ɗak kok nyil nǝ a shi jaspa, kǝ yil nǝ a shi zinariya kǝding-ding, nǝ mǝlep kaa mbiinaarin. ");
INSERT INTO sur_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","Mo ɗak jwat nkuk kok mǝ yil nǝ mo shi nghǝk ɗǝret. Moɗak kuk ɗinshee nǝ a shi jaspa, ɗevǝl nǝ a shi safiya, ɗekun nǝ a shi aget, ɗefeer nǝ a shi emiral, ");
INSERT INTO sur_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","Ɗepaat nǝ a shi Onis, ɗepeemee nǝ a shi rubi, Ɗepwoovǝl nǝ a shi krisolait, ɗepwookun nǝ a shi beril, Ɗepwoofeer nǝ a shi topas, ɗekaapaat nǝ a shi tokwes, ɗekaapaat baamǝndong nǝ a shi jasinf, ɗekaapaat baavǝl nǝ a shi ametis. ");
INSERT INTO sur_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","Mo ɗak koo a pwoolu ɗeɗangyi ɗekaapaat baavǝl sǝ mo shi mee nghǝkɗeret ɗe moo pet nǝ a peyal. Koo a pwoolu ɗeɗang ye, ɓe nǝ mang peyal mǝndong. Ar ɗǝɗes ɗǝ nǝ nyilkaam nǝ mo mo ɗak a shi zinariya kǝdǝng-dǝng kaa binaariin sǝ. ");
INSERT INTO sur_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","Baa wen naa mee Lu Naan ɗeɗes ɗe nɗǝǝn yil nǝ kas, mbǝɗe Daa Naan ɗeɓal met jir, kǝ Laatǝm nǝ, a mo a Lu Naan ɗǝɗes. ");
INSERT INTO sur_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","Baa yil nii rǝɓet puus, koo tar mbǝ kǝnǝ ɓang nǝ ɗi kas, mbǝɗe ɗeɗes Naan nii ɓang yil nǝ jir, kǝ Laatǝm wur a ngyam yil ne. ");
INSERT INTO sur_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","Ɓǝ song yil nǝ mo mwaan a nɗǝǝn peeɓang nǝ, kǝ mishkoom mǝ Ɓǝm-yil nǝ mo, mo njì kǝ ɗeɗes mo mo ndǝǝn nǝ. ");
INSERT INTO sur_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","Baa mo cam shoot polu nǝ mo koo yit mǝndong kas, mbǝɗe baa mee paar nɗen ɗi kas. ");
INSERT INTO sur_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Ɓǝ yil nǝ mo bǝ ji kǝ ram, kǝ Long mo mo, nɗǝǝn nǝ jir. ");
INSERT INTO sur_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","Baa mee mbii ɗerap mmak ɗel ɗe nɗǝǝn yil nǝ kas. Koo ngwe ɗe wur cin mbǝɗe mǝ nashweep, koo gwampee, ɓe baa mo cam ɗel nɗǝǝn yil nǝ kas, mɓe see a nen ɗe sǝm mo mo a rǝran ndǝǝn bǝǝthaal mǝ seen Laatǝm ɓejee ɗak. ");
INSERT INTO sur_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","Ɗangɓe ngulep Naan wur kám mee geen nghan, ɗe nǝ a mǝ am mǝ seen. Am nǝ ɗong yet-yet. Am nǝ put a peetong mǝ mulki Naan, kǝ mǝ Laatǝm ne. ");
INSERT INTO sur_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","Am ɗesǝ nǝ sham a nnaar ar ɗeɗes mǝ yil nǝ. Tǝng mǝ seen nii ɗar mpwoo geen nǝ koo nkwang ɗeɗang ye. Nii làa-làa mo kaapaat baavǝl, koo tar ɗeɗangyi mǝ laatǝng mo. Kom tǝng ɗǝsǝ nǝ a mbǝ baar gurum ɗi mǝ yil nǝ mo jir, shinǝ-shinǝ. ");
INSERT INTO sur_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","Baa mee mbii ɗebish mmak ɗel nɗǝǝn yil nǝ zak kas. Peetong mǝ mulki Naan kǝ Laatǝm, mo ntong nɗǝǝn yil nǝ, kǝ kǝrem wur mo nseyil nwur. ");
INSERT INTO sur_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","Mo nnaa yit Naan, moo nnaa sǝm wur nkaa pǝkyeen mo mo. ");
INSERT INTO sur_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Baa mee par kuɗi zak kas. Baa mo nwaa kuɗi kǝ cin ɗak kǝ peeɓang mǝ ngyam zak kas, koo mǝ puus kas, mbǝɗe Daa Naan wur nshin peeɓang mo, kǝ mo nse mulki mbe ngaa-ngaa. ");
INSERT INTO sur_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","Ngulepnaan wur sat nghan nǝnee, <<Pwoo ɗesǝ nǝ mo mak ɗe gurum nshínzeen mo, Kǝ mo azeen zak. Daa Naan ɗe wur cin Riin wur nensatpwoo wur mo, wur lep ngulep wur, mbǝkǝ ngulep nǝ wur kám ɗin nkǝrem wur mo, mbii ɗe a ting mo ncìn akyeen kǝlak.>> ");
INSERT INTO sur_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","<<Jesu sat nǝ nee, Wu naa, nghan kǝ jì kǝlak-kǝlak! Ɗeret nkat ngwe ɗe wur tap pwoo ɗǝ nen satpwoo nan mo ran nɗǝǝn ngarvit ɗesǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","A nghan Joon, a an a ngweɗe nkǝlǝng, ɗang nnaa mbii ɗesǝ mo, kaaɗe nghan kǝlǝng ɗang nghan naa mo, ɓǝ nghan taa nyil shii ngulepnaan nǝ kǝ nghan seyil ɗe wur dǝ kǝ kám mbii ɗesǝ nǝ mo nghan. ");
INSERT INTO sur_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","Mbe wur sat nghan nǝnee, <Taji a seyil nghan kas, nnǝ wuɗin a kǝrem kaa nghan sǝ, kǝ ɗyemnǝǝn fun nensatpwoo Naan mo, kǝ jir nen ɗe moo tap kǝ pwoo ɗerǝran nɗǝǝn bǝǝthaal ɗesǝ nǝ. Wu seyil a nNaan!> ");
INSERT INTO sur_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","Ngulep nǝ wur sat nghan nǝnee, << Pwoo Naan ɗe mo nɗǝǝn bǝǝthaal ɗesǝ, taji a paa mo kas, mbǝɗe pee nǝ wul, mbǝkǝ mbii ɗesǝ nǝ mo cin ɗi. ");
INSERT INTO sur_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Wu yit kǝ ngucìn mbii ɗebish mo, ɓe wur sekyeen kǝ cin nǝ. Wu yit kǝ ngucìn mbii ɗerap mo, ɓe wur sekyeen kǝ chin mo. Ngucìn mbii ɗin ndǝre mo, wu yit kǝ wur sekyeen kǝ cin ɗin ndǝre wur. Ngwe ɗe wur a ɗeɓang ɓe wur sekyeen ɗe a ɗeɓang.>> ");
INSERT INTO sur_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","<<Wu naa, nghan pǝ jì kǝlak-kǝlak ashak kǝ kwat fǝn. Wen shin nǝ nkòo a weye, nciit-nciit kǝ mbii ɗe gurum kǝ ten cin mo. ");
INSERT INTO sur_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","Wen a Alfa kǝ Omega, ɗe a nghan a Tǝleng kǝ mbii mo, kǝ ɗe mɓwoon kǝ mo, nghan a Ɗinshee kǝ Kyes kǝ mbii mo jir zak. ");
INSERT INTO sur_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Nen ɗe mo vwang lée mo mo ɓang-ɓang, ɓe mo nkat ɗeret, mbǝɗe a mo nkat iiko mbǝ se laatǝng ɗǝ mǝ seen nǝ, kǝ mo nɗel mpolu nǝ mo, mbǝ ɗel nɗǝǝn yil ne. ");
INSERT INTO sur_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","Mɓwoon yil nǝ, ɓe as mo ɗi, kǝ soot mo, kǝ nenngaa mo, kǝ nentukáa mo, kǝ nenseyil nkùm mo, kǝ jir nen ɗe mo rǝɓet cìn ɗung mo. ");
INSERT INTO sur_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","A nghan a Jesu kǝn lep ngulep fen, mbǝkǝ wur shin langteng ɗesǝ mo nwaa, mbǝ Ekǝlisya mo. A nghan a cirem kǝ dang Devit, kǝ a nghan a Tar mangɓit, ɗe nii ɓangpee sǝ.>> ");
INSERT INTO sur_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Riin nǝ kǝ matpoo nǝ, mo sat nǝnee, <<A jì!>> Wu yit kǝ koo a weye, ɗe wur kǝlǝngpee, ɓe wur sat nǝnee, <<A jì.>> Wu yit kǝ koo a weye ɗe neen am tu wur, mbǝ am mǝ seen, ɓe wu yit kǝ wur jì, mbǝkǝ wur lap am mǝ seen nǝ shwaa ɗe shi zuum. ");
INSERT INTO sur_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","Wen Joon pǝ dul kom kòo a weye shiɓal nee koo a weyii ɗe wur kǝlǝng pwoo ɗe mo ran ndǝǝn ngarvit ɗesǝ, ɗe mo put pee Riin Naan ɗi. Katɗang mee gurum le mee pwoo nkaa ɗe mo kǝ ten ran nɗǝǝn ngarvit ɗesǝ nǝ, ɓe Naan wur le kwat pwoo ngwar mǝnǝ a shi jeel ɗe mo kǝ ten ran nɗǝǝn ngarvit ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","Katɗang mee ngwe mang mee mbii baa kǝ nǝ ndǝǝn pwoo ɗe mo a rǝran, ɗe mo put a pee Riin Naan nɗǝǝn ngarvit ɗesǝ, ɓe Naan mbǝ mang pak pwoo mǝwur ndǝǝn tǝng mǝ seen kǝ ndǝǝn Yil Ɗebang, kaaɗǝ mo kǝ sat nɗǝǝn ngarvit ɗesǝ. ");
INSERT INTO sur_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","Gwar ɗe wu shin camkat mbǝ mbii ɗesǝ nǝ mo jir, wur sat nǝnee, <<Ii, nghan pǝ ji kǝlak-kǝlak. Nǝ akǝsǝ. A jì, Daa Jesu.>> ");
INSERT INTO sur_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","Ɗeret Daa Jesu tong ashak kǝ wun jir. Naasǝ.");
ALTER TABLE sur_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
